﻿USE sofia;
DROP TABLE IF EXISTS sofia.gmvl_vpl;
CREATE TABLE gmvl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gmvl_vpl WRITE;
INSERT INTO gmvl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Xoossi koyro salonne sa7a medhdhides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","He wode sa7ay lo7i giigibeennanne aykkoyka baynda mela dees; ciimmasohota dhumay goozi oykkides; Xoossa Ayanay haaththafe bollara may7i uttides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Hessafe guye Xoossi, «Poo7o gido» giin poo7o gidides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Poo7oy lo7o gididayssa Xoossi be7idi poo7o dhumappe shaakkides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Xoossi poo7oza, «Gallas», dhumaza, «Omars» gi sunththides. Gadey qammidessinne wontides; hessika koyro gallassa. ");
INSERT INTO gmvl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Hessafe guye Xoossi, «Bollara diza haaththaa garsara diza haaththaafe shaakkiza salo gufanththoy hano» giin hanides. Xoossi salo gufanththo giigsidi, salo gufanththofe bollara diza haaththaa garsara diza haaththaafe shaakkides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Xoossi he gufanththoza, «Salo» gi sunththides. Gadey qammidessinne wontides; hessika nam7anththo gallassa. ");
INSERT INTO gmvl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Hessafe guye Xoossi, «Saloppe garsara diza haaththi issison shiiqi eelliko mela biittay qoncco» giin hanides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Xoossi he mela sohoza, «Biitta» gi sunththides; qasse issison eellida haaththaa, «Abba» gi sunththides; histtidi Xoossi hessi lo7o gididayssa be7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Hessafe simmiin Xoossi, «Biittay miththinne maata mokiso; zereththa ayfera diza miththinne zereththa ayfera diza teeriza mith dumma dumma qommo mokiso» giin hanides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Hessa gishshas biittay miththinne maata dumma dumma qommon mokisiin Xoossi hessi lo7o gididayssa be7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Gadey qammidessinne wontides; hessika heedzdzanththo gallassa. ");
INSERT INTO gmvl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Hessafe guye Xoossi, «Gallas qammafe shaakkanaas poo7oti salo gufanththon gidetto; istti gallas, wodenne layth erisetto; ");
INSERT INTO gmvl_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","biitta bollan poo7isana mala istti salo gufanththon poo7etto» giin hanides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Xoossi nam7u gita poo7ota, gitatizayssi gallas poo7ana malanne guuxxizayssi omars poo7ana mala medhdhides; xoolinttetakka medhdhides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Xoossi istta ha biitta bollan poo7isana mala, gallassinne qamma haarana malanne poo7oza dhumappe shaakkana mala, salo gufanththon istta woththides. Histtidi Xoossi hessi lo7o gididayssa be7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Gadey qammidessinne wontides; hessika oydanththo gallassa. ");
INSERT INTO gmvl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Hessafe guye Xoossi, «Shemppora diza dumma dumma medheteththati haaththa giddon daretto; kafotikka biittafe bollaranne salo gufanththofe garsara piradhdhetto» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Histtidi Xoossi abban diza gita do7ata, haaththa giddon woxxi qaaxxiza medheteththata ubbaa, kafo ubbaa dumma dumma qommon medhdhides. Hessika lo7o gididayssa Xoossi be7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Xoossi isttas, «Yelettite; darite; abba haaththaa kumite; kafoykka biitta bollan coratto» gi anjjides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Gadey qammidessinne wontides; hessika ichchashanththo gallassa. ");
INSERT INTO gmvl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Hessafe guye Xoossi, «Shemppora diza medheteththati ba qommon qommon meheti, biittara gooshettiza medheteththatinne do7ati ba qommon qommon biitta bolla kezetto» giin hanides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Xoossi do7ata istta qommon qommon, mehetakka istta qommon qommoninne biittara gooshettiza medheteththatakka ubbaa istta qommon qommon medhdhides; hessika lo7o gididayssa Xoossi be7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Hessafe simmiin Xoossi, «Ane as nu leemison nuna misatissidi medhdhoos; istti abba moleta, salo kafota, meheta, biitta bolla woxxi qaaxxiza medheteththata ubbaa haaretto» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Hessaththo Xoossi as ba leemison bana misatissidi medhdhides; izi istta addenne macca ooththi medhdhides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Xoossi isttas, «Yelettite; corattite; hayssa biittaa kumitenne haarite; abba mole, salo kafotanne biitta bolla woxxi qaaxxiza, shemppora diza medheteththata ubbaa haarite» gi anjjides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Hessafe simmiin Xoossi, «Be7ite! Tani ha biitta ubbaa bollan zereththa ayfera diza miththinne zereththa ayfera diza teeriza mith ubbaa inttes immadis; isttika inttes miza quma gidetto. ");
INSERT INTO gmvl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Qasseka ha biittaa bolla diza mehenne do7a ubbaas, salo kafotas ubbaas, biittara gooshettiza medheteththata ubbaassinne shemppora paxa diza medheteththata ubbaas miza miish gidana mala, cilila miththinne maata kumeth immadis» giin hanides. ");
INSERT INTO gmvl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Xoossi ba medhdhidayssa ubbaaka xeellidi daro lo7o gididayssa be7ides. Gadey qammidessinne wontides; hessika usuppunththa gallassa. ");
INSERT INTO gmvl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Salo bollanne sa7a bolla dizay wuri hayssaththo oosetti polettides. ");
INSERT INTO gmvl_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Xoossi ba ooththida ooso usuppunththa gallas polidi ba ooththida ooso ubbaafe laappunththa gallas shempides. ");
INSERT INTO gmvl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Qasse Xoossi laappunththa gallassaa anjjidessinne dumma gallas ooththides; ays giikko Xoossi ba ooththiza ooso wursidi shempiday he gallassanna. ");
INSERT INTO gmvl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Saloynne sa7ay medhettiday hessa malanna. GODAY sa7anne salo medhdhida wode, ");
INSERT INTO gmvl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","sa7a bollan maatay, miththi, ay miishshika mokkibeenna; ays giikko GODAY ira bukisibeenna; qasse biitta ooththiza asikka medhettibeenna. ");
INSERT INTO gmvl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Gidikkoka haaththi biittafe pude maacotti kezidi biitta ubbaa irxxisees. ");
INSERT INTO gmvl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Hessafe guye GODAY biittafe issi as medhdhidi iza siidhen de7o shemppo punnin addezi shemppora dizaade gidides. ");
INSERT INTO gmvl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Kase GODAY arshey mokkiza baggara Edene geetettizason lo7oso giigsidi ba medhdhida addeza heen woththides. ");
INSERT INTO gmvl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","GODAY xeellanaas lo7iza, maanaaska mal7iza dumma dumma qommo mith biittafe mokisides; Edene giddon de7o immiza miththi dees; hessaththoka lo7onne iita erisiza mith woththides. ");
INSERT INTO gmvl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Gannate ushshiza shaafa haaththi Edeneppe goggees. Edeneppe kezidaappe guye, oyddu shaafa gidi shaakettees. ");
INSERT INTO gmvl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Koyro shaafaa sunththi Pisoone; Pisooney worqqay diza Hawila geetettiza biittaa yuusho ubbaan goggees. ");
INSERT INTO gmvl_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","He biittaa worqqay geeshsha worqqa; qasse al7o shittoynne keehi lo7iza shuchchi heen dees. ");
INSERT INTO gmvl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Nam7anththo shaafaa sunththi Giyoone; Giyooney Tophphiya biitta yuusho ubbaan goggees. ");
INSERT INTO gmvl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Heedzdzanththo shaafaa sunththi Xegroose; Xegroosey Asooreppe arshey mokkiza baggara goggees; qasse oydanththo shaafay Efiraaxise geetettees. ");
INSERT INTO gmvl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Addezi Edenen ooththana malanne naagana mala GODAA Xoossay iza efi woththides. ");
INSERT INTO gmvl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Histtidi GODAA Xoossay addeza, «Edene miththa teera ubbaafe neni maana giikko ma; ");
INSERT INTO gmvl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","gido attiin lo7onne iita erisiza miththay teerappe mooppa; ays giikko neni izippe mida gallas tumu hayqqana» gi azazides. ");
INSERT INTO gmvl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Hessafe guye GODAA Xoossay, «Addezi barkka dizayssi lo7o deenna; tani izas injjetiza maado as medhdhana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","GODAA Xoossay kase meheta do7ata salo kafota ubbaa biittafe medhdhides; qasse addezi istta ay giidi sunththanakko siyanaas izakko ehiin addezi shemppora diza medheteththata ubbaa sunththida sunththay isttas sunth gidi attides. ");
INSERT INTO gmvl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Hessaththo addezi meheta, salo kafotanne, do7ata ubbaa sunththides; gido attiin Addaames injjetiza maado asi beettibeenna. ");
INSERT INTO gmvl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Hessa gishshas GODAA Xoossay addeza dhisko dhiskisidi, izi dhiskon dishin iza mille meqeththatappe issaa ekkidi he sohozan asho kunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","GODAA Xoossay addezappe ekkida meqeththaa maccas medhdhidi izo addezakko ehides. ");
INSERT INTO gmvl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ehiin addezi, «Hekko! Ha meqeththaya ta meqeththafe, ha ashoyakka ta ashoppe ekettidaaro; izakka attumasappe ekettida gishshas, maccas geetettu» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Hessa gishshas asi ba aawaanne ba aayo aggees; ba machcheyra issife dees; istti nam7ay issi asho. ");
INSERT INTO gmvl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Addezinne iza machcheya nam7ayka paxa kallo deettes; gido attiin issay issaas yeellati erettenna. ");
INSERT INTO gmvl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Shooshshay GODAA Xoossay medhdhida do7a ubbaafe aadhdhida genanchcha; issi gallas shooshshay he maccassayo, «Xoossi tumu inttena, ‹Edenen diza miththa ayfe ubbaafekka moopite› gidee?» gi oychchides. ");
INSERT INTO gmvl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Maccassaya shooshshas zaarada, «Gidenna! Xoossi hessaththo gibeena; nuni Edenen diza miththata ayfe maanaas dandayoos; gido attiin Xoossi nuna, ‹Edene giddon diza miththaa ayfe moopite; bochchofte; histtontta aggiko intte hayqqana› gides» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Shooshshay maccassayo, «Gidenna! Intte tuma hayqqeketa; ");
INSERT INTO gmvl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Xoossi hessa giday he miththay ayfe intte miikko intte ayfey doyettiin, Xoossa mala intte lo7onne iita shaakki eranayssa izi eriza gishshassa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Maccassaya he miththaa ayfey maanaas mal7izayssa, xeellanaas lo7izayssa, qasse asi aadho erateth demmanaas amosizaaz gididayssa beyada he miththaa ayfeppe ekkada madus; qasse banara diza ba azinaaska hessafe immiin izikka mides. ");
INSERT INTO gmvl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Mida wode istta nam7aa ayfeykka doyettiin istti baas paxa kallo dizayssa eridi balase geetettiza miththa hayth sikkidi ba xeessan gixxida. ");
INSERT INTO gmvl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Omarsa wode, Edene giddon GODAA Xoossay hemettishin, iza cenggurssaa addezinne iza machcheya siyidi GODAA Xoossaafe Edene miththa giddon qotettida. ");
INSERT INTO gmvl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Gido attiin GODAA Xoossay addeza xeygidi, «Addaame awan day?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Addezikka, «Edene giddon ne cenggurssaa siyada tani kallo diza gishshas babbada qotettadis» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","GODAA Xoossay iza, «Neni kallo daasa giidi nees yootiday oonee? Tani nena, ‹Mooppa› gaada azazida miththaa ayfeppe madii?» gi oychchides. ");
INSERT INTO gmvl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Izikka, «Tanara daana mala ne immida maccassaya he miththaa ayfeppe taas immiin madis» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","GODAA Xoossay hessafe guye maccassayo, «Neni hessa ays ooththadii?» gi oychchides. Maccassayakka, «Tana shooshshay baleththiin madis» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","GODAA Xoossay hessafe guye shooshshaa, «Neni hayssa ooththida gishshas, mehe ubbaanne do7a ubbaa garsan ne xallay qanggettidaaza! Neni ne ulon biittara gooshettana; ne de7o layth ubbaankka biitta gudulla laacca. ");
INSERT INTO gmvl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Tani neessinne maccassays, ne zereththassinne izi zereththas giddon morkketeth medhdhana; izi ne hu7e qoxxana; nenikka iza qirphe dukkana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Maccassayokka GODAA Xoossay, «Ne shaaraza aginan neni daro tuggatana; qasse neni wolqqama miixan nayta yelana. Gidikkoka neni ne azinara aqanaas amottana; izikka nena haarana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Addaamekka GODAA Xoossay, «Neni ne machchey qaala siyida gishshas tani nena, ‹He miththaa ayfe mooppa› gaada azazida miththaa ayfeppe neni mida gishshas, «Ne geedon biittay qanggettidaaz gido! Neni ne de7o layth ubbaan gita daaburan biitta ooththada maana. ");
INSERT INTO gmvl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Biittay nees agunththinne kindichcho mokisana; neni biittafe mokkidayssa maana. ");
INSERT INTO gmvl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Neni biittan simmana gakkanaas daaburan ne cawa gussa ooththada maana; neni biittafe medhettida gishshas biittan simmandasa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Addaamey ba machchiyo Hewaano gi sunththides; ays giikko iza asa ubbaas aayo. ");
INSERT INTO gmvl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","GODAA Xoossay Addaamessinne iza machcheys ite giigsidi istta mayzides. ");
INSERT INTO gmvl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Hessafe guye GODAA Xoossay, «Histtiin asi nuuppe issaade mala lo7onne iita erizaade gidides; izi ba kushe yeddidi de7o immiza miththaafe ekkidi qasse montta malanne mernaas paxa de7ontta mala teqettanaas koshshees» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Hessa gishshas izi ba medhettida biittaa ooththana mala, GODAA Xoossay Edeneppe iza kessides. ");
INSERT INTO gmvl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Iza kessidi, de7o miththaako efiza oge naagana mala, kirube geetettiza kiitanchchatanne popol7u gi aadhdhi aadhdhi wodhdhiza tama laco misatiza giththa mashsha Edeneppe arshey mokkiza baggara woththides. ");
INSERT INTO gmvl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Addaamey ba machcho Hewaanira aqiin iza shaarada attuma naa yeladus; «GODAY tana maaddiin attuma naa demmadis» gashe iza Qayeele ga sunththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Qasse iza isha Aabeelekka yeladus. Aabeeli dorsa heenththanchcha; Qayeeley biitta goshshanchcha. ");
INSERT INTO gmvl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Undenna wodeppe guye Qayeeley ba gaden mokkida kaththaafe Godaas yarsho shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Gido attiin Aabeeli ba dorsata giddon koyro yelettida laaqqatappe issaa ekki shukkidi ashozappe handaza yarshides; GODAY Aabeelenne iza yarshoza ekkides. ");
INSERT INTO gmvl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Qayeelenne iza yarsho ekkibeenna; hessa gishshas Qayeeley keehi yiillotides; ba ayfesokka iissides. ");
INSERT INTO gmvl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Histtiin GODAY Qayeele, «Ays yiillotay? Ne ayfesoy ays dhumidee? ");
INSERT INTO gmvl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ne lo7o ooththidaa gididaakko Xoossi ne yarsho ekkenneeshin? Neni lo7o ooththontta ixxiko nagaray ne karen nena naagees; nagaray nena haarana koyees; neni iza xoonana bessees» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Hessafe guye Qayeeley ba isha Aabeele, «Ane gede dembaso boos» gides. Biidi istti demban dishin Qayeeley ba isha Aabeele bolla dendidi wodhides. ");
INSERT INTO gmvl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","GODAY Qayeele, «Ne ishay Aabeeli awan dizee?» gi oychchides. Qayeeley zaaridi, «Ta erikke; ta ishaa naagizay taneyee?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","GODAY Qayeele, «Hessa ays ooththadii? Beya; ne ishaa suuththi biittafe pude taakko waassees. ");
INSERT INTO gmvl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ne kusheppe ne ishaa suuththaa ekkidi mittanaas doona doyda biittaa bolla ha7i neni qanggettadasa. ");
INSERT INTO gmvl_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Neni ooththiinkka biittay nees kath immenna; bete asa mala neni biitta bollan toylattana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Qayeeley GODAA, «Ne tana qaxxayiza qixaate tani mulekka dandaykke. ");
INSERT INTO gmvl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Hekko neni tana hach ha biittafe yedeththaasa; tani ne sinththafe qotettana; bete asa mala tani biitta bolla toylattana; tana demmiday oonikka wodhana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","GODAY iza, «Nena oonikka wodhenna; wodhikko ne halo tani laappun kushe kessana» gides; hessa gishshas demmiday oonikka iza wodhontta mala GODAY iza bolla malata woththides. ");
INSERT INTO gmvl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Qayeeley GODAA sinththafe kezidi Edene baggafe arshey mokkiza baggara diza Noode geetettiza biittan de7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Qayeeley ba machcheyra aqiin iza shaarada Heenooke yeladus; he wode Qayeeley katama giigsidi he katamaa ba naaza sunththan, «Heenooke» gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Heenookey Iraade yelides; Iraadey Mahuyaa7eele yelides; Mahuyaa7eeley Matusa7eele yelides; Matusa7eeley Laameeke yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Laameekey Aadonne Xiilo geetettiza nam7u machcheta dawuth ekkides. ");
INSERT INTO gmvl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Aaday Yaabaale yeladus; Yaabaaley mehe haarishe yuuyi yuuyi dunkaanen diza asata aawa. ");
INSERT INTO gmvl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Iza ishaa sunththi Yuubaale; Yuubaaley qasse diith diixxizanne susul7e punniza asata ubbata aawa; ");
INSERT INTO gmvl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Xiilay qasse Tubaaliqayne geetettiza naa yeladus; Tubaaliqayney xarqimalappenne biratappe dumma dumma miishshata qoxxizaadde. Tubaaliqayne michcheya Naa7imo geetettawus. ");
INSERT INTO gmvl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Issi gallas Laameekey ba machcheta, «Ta machcheto Aadee, Xiilee siyite! Ane tani yootizayssa ezgite. Issi asi tana wadhdhi madunththida gishshas tani iza wodhadis; ee, tani he tana madunxissida wodallaza wodhadis. ");
INSERT INTO gmvl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Qayeele halo kessanaas laappun kushe koshshiko Laameeke halo kessanaas laappun tammanne laappun kushe koshshees» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Addaamey ba machcheyra aqiin hara naa yeladus. Yelada «Qayeeley wodhida Aabeele gishshas Xoossi taas hara naa immides» gashe iza Seete gaada sunththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seeteykka attuma naa yelidi iza, «Heenoose» gi sunththides. Asay he wode GODAA sunth xeygidi goyno oykkides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Addaame zereththi hayssafe kaallidi xaafettides; Xoossi as medhdhida gallas bana misatissidi medhdhides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Addenne maccas ooththi medhdhidi istta anjjides. Istta medhdhidi as gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Addaamey 130 layth de7idi bana misatiza attuma naa yelidi iza, «Seete» gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Addaamey Seete yelidaappe guye 800 layth de7ides; hara attuma naytanne macca nayta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Addaamey mulera 930 layth de7idi hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seetey 105 layth de7idi Heenoose yelides; ");
INSERT INTO gmvl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seetey Heenoose yelidaappe guye 807 layth de7ides; hara attuma naytanne macca nayta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seetey mulera 912 layth de7idi hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Heenoosey 90 layth de7idi Qaynaane yelides; ");
INSERT INTO gmvl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Heenoosey Qaynaane yelidaappe guye 815 layth de7ides; hara attuma naytanne macca nayta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Heenoosey mulera 905 layth de7idi hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Qaynaaney 70 layth de7idi Malal7eele yelides; ");
INSERT INTO gmvl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Qaynaaney Malal7eele yelidaappe guye 840 layth de7ides; hara attuma naytanne macca nayta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Qaynaaney mulera 910 layth de7idi hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Malal7eeley 65 layth de7idi Yaareede yelides; ");
INSERT INTO gmvl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Malal7eeley Yaareede yelidaappe guye 830 layth de7ides; hara attuma naytanne macca nayta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Malal7eeley mulera 895 layth de7idi hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaareedey 162 layth de7idi Heenooke yelides; ");
INSERT INTO gmvl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yaareedey Heenooke yelidaappe guye 800 layth de7ides; hara attuma naytanne macca nayta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yaareedey mulera 962 layth de7idi hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Heenookey 65 layth de7idi Maatusaala yelides; ");
INSERT INTO gmvl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Maatusaala yelidaappe guye Heenookey 300 layth Xoossa ufayssishe de7ides; hara attuma naytanne macca nayta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Heenookey mulera 365 layth de7ides; ");
INSERT INTO gmvl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Izi Xoossa ufayssishe diin Xoossi iza ekkida gishshas beettontta dhaydes. ");
INSERT INTO gmvl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Maatusaalay 187 layth de7idi Laameeke yelides; ");
INSERT INTO gmvl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Maatusaalay Laameeke yelidaappe guye, 782 layth de7ides; hara attuma naytanne macca nayta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Maatusaalay mulera 969 layth de7idi hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Laameekey 182 layth de7idi attuma naa yelidi, ");
INSERT INTO gmvl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","«Ha naazi GODAY qanggida biitta bollan nuna nu daaburappe shempisana» giidi Nohe gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Laameekey Nohe yelidaappe guye 595 layth de7ides; hara attuma naytanne macca nayta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Laameekey mulera 777 layth de7idi hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nohey 500 layth de7idi Seeme, Kaamenne Yaafeete yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Asi biitta bolla darida wode asas macca nayti yelettida; ");
INSERT INTO gmvl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","«Xoossa nayta» geetettiza medheteththati asa macca nayti medho lo7o gididayssa be7idi isttafe ba dooridayta machcho ekkida. ");
INSERT INTO gmvl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","GODAY, «Asi hayqqizaaza; iza layththayka 120 layththafe darenna; hessa gishshas ta Ayanay asa naa bolla mernaas deenna» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","He wodenne hessafe guye Xoossa nayti asa macca nayta machcho ekkiin nayti yelettida wode wogga wolqqama asati biitta bollan deettes. Isttika beni wode olas minonne erettida asa. ");
INSERT INTO gmvl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","GODAY he wode biitta bollan diza asaa iitateththi daridayssanne istti ba wozinan qoppizayssi wuri ubba wodekka iita xalala gididayssa be7ides; ");
INSERT INTO gmvl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","GODAY as ha biitta bollan medhdhida gishshas modhettides; ba wozinan keehi seelettides. ");
INSERT INTO gmvl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Hessa gishshas GODAY, «Tani medhdhida asaa ha biitta bollafe ubbaa dhayssana; asa, mehe, do7a, biittara gooshettiza medheteththatanne kafota dhayssana; ays giikko tani istta medhdhida gishshas mishettadis» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Gido attiin Nohey GODAA sinththan sabettides. ");
INSERT INTO gmvl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nohey hanidayssi hayssafe kaallidi xaafettides. Nohey xillo asa; izi ba woden diza asaa giddon suure asa; Nohey Xoossara giiga duus de7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nohey Seeme, Kaamenne Yaafeete geetettiza heedzdzu attuma nayta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","He wode biitta bolla diza asi wuri Xoossa sinththan tunides; biittay wuri makkallan kumides. ");
INSERT INTO gmvl_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Xoossi duge biitta xeellishin biitta bolla diza asay wuri tunidayssa be7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Hessa gishshas Xoossi Nohe, «Tani asa ubbaa dhayssana gays; asa gaason biittay makkallan kumida gishshas tani tumappe asanne biitta bolla dizaaz ubbaa dhayssana. ");
INSERT INTO gmvl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Hessa gishshas mino miththafe nees markabe keexxa; he markabeza giddon kifile ooththa; histtada soo baggaranne kare baggara shidan meesha. ");
INSERT INTO gmvl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Markabeza keexxashe iza adussateththi 300 wadha, gomppay 50 wadha, pude dhoqqateththi 133 wadha histta ooththa. ");
INSERT INTO gmvl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Markabezas kaara medhdha; kaaraappenne godaappe giddon issi wadha gidizaso doya agga; pengeza markabezas millera kessa; markabeza heedzdzu pooqe kessa keexxa. ");
INSERT INTO gmvl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","«Tani saloppe garsan shemppora diza medheteththa ubbaa dhayssanaas ha biitta bollan dhayssa haath yeddiko biittan dizayssi wuri dhayana. ");
INSERT INTO gmvl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Gido attiin tani nenara caaqettana. Neni, ne machchiya, ne naytinne ne nayta machcheti nenara markabezan gelandeta. ");
INSERT INTO gmvl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Istti nenara paxa daana mala shemppora diza medheteththa ubbaafe qommon qommon addenne macca nam7u nam7u histtada markabeza giddo gelththa. ");
INSERT INTO gmvl_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Dumma dumma qommo kafotappe, dumma dumma qommo mehetappenne biittara gooshettiza dumma dumma qommo medheteththatappe ubbaafe nam7u nam7u gididi shemppora paxa attana mala neekko yaana. ");
INSERT INTO gmvl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Qasse neninne nenara dizayti maana mala dumma dumma qommo kath efada markabeza giddo gelththa» gi azazides. ");
INSERT INTO gmvl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nohey ubbaaka Xoossi azazida mala ooththides. ");
INSERT INTO gmvl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Hessafe guye GODAY Nohe, «Neni hayssa ha wode yeletaa giddon xillo gididayssa ta be7ida gishshas neni neso asaa ubbaara markabeza giddo gela. ");
INSERT INTO gmvl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Neni geesh gidida mehenne do7a ubbaafe iza qommofe qommofe addenne macca laappun laappun, geesh gidontta mehenne do7a ubbaafe iza qommofe qommofe issi addenne issi macca qasse kafotappe iza qommofe qommofe addenne macca laappun laappun, biitta ubbaa bollan dumma dumma zereththay paxa daana mala nenara ekka gela. ");
INSERT INTO gmvl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ays giikko laappun gallassafe guye tani oyddu tammu gallassinne oyddu tammu qamma biitta bollan ira bukisana; histtada tani medhdhida medheta ubbaa biitta bollafe dhayssana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nohey GODAY iza azazidayssa ubbaa ooththides. ");
INSERT INTO gmvl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Dhaysa haaththi biitta bolla yiza wode Nohes layththay usuppun xeeta. ");
INSERT INTO gmvl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nohe, iza attuma nayti, iza machcheyanne iza nayta machcheti dhayssa haaththaafe attanaas markabeza giddo gelida. ");
INSERT INTO gmvl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Geeshsha meheppenne do7appe, geesh gidontta meheppenne do7appe, kafoppenne biittara gooshettiza ubbaafe, ");
INSERT INTO gmvl_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Xoossi Nohe azazida malakka addenne macca nam7u nam7u gididi Nohekko markabeza giddo geliin, ");
INSERT INTO gmvl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","laappun gallassafe guye dhayssa haaththi biitta bolla yides. ");
INSERT INTO gmvl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nohes usuppun xeetu layth gidishin nam7anththo aginan tammanne laappunththa gallassan he gallassankka biitta giddon diza gita ciimma pulttoy wuri dhuuqqides; salon diza haaththa maskootetikka doyetti wodhdhida. ");
INSERT INTO gmvl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Iray biitta bollan oyddu tammu gallassinne oyddu tammu omars bukkides. ");
INSERT INTO gmvl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","He gallassan Noheynne iza attuma nayti, Seemey, Kaameynne Yaafeetey, Nohe machcheyanne iza nayta heedzdzata machcheti issife markabeza giddo gelida. ");
INSERT INTO gmvl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Isttanne do7a ubbaafe ba qommon qommon, mehe ubbaafekka ba qommon qommon, biittara gooshettizayata ubbaafe ba qommon qommon, kafo ubbaafe ba qommon qommon isttara issife gelida. ");
INSERT INTO gmvl_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Shemppora paxa dizayti wuri nam7u nam7u gididi Nohekko markabezan gelida; ");
INSERT INTO gmvl_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Xoossay Nohe azazida mala medheta ubbaafe addenne macca gididi markabeza giddo geliin Nohey giddon dishin GODAY markabeza penge gordides. ");
INSERT INTO gmvl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Dhayssa haaththi oyddu tammu gallas biitta bolla bukkishe gam7ides; haaththi daridi, markabeza biittafe pude denththides. ");
INSERT INTO gmvl_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Haaththay biitta bollan keehi dariin markabezi haaththaa bollan tookettides. ");
INSERT INTO gmvl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Saloppe garsara diza dhoqqa zumati wuri mitettana gakkanaas haaththay biitta bollan keehi wolqqafe darides. ");
INSERT INTO gmvl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Haaththay zumata xeerappe aadhdhidi 15 wadha gakkanaas dhoqqu gides. ");
INSERT INTO gmvl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Histtiin biitta bollan shemppora paxa qaaxxiza medheteththati wuri, kafoy, mehey, do7ay, biitta bollan woxxi qaxxizaynne asi wuri hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Biitta bollan diza siidhera shempizay wurikka hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ha biittan paxa dizay wuri asi, meheynne do7ay, biittara gooshettiza medheteththinne salo kafoti wurikka biittafe pitetti dhayiin Noheynne izara markabe giddon dizayti xalla attida. ");
INSERT INTO gmvl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Haaththayka 150 gallas gakkanaas biitta bollan gam7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Gido attiin Xoossi Nohe, izara markabeza giddon diza do7anne mehe ubbaa qoppidi biitta bollan carko carkissiin haaththay wodhdhi wodhdhi bides. ");
INSERT INTO gmvl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Qasse biitta giddon diza ciimma pulttoynne salon diza haaththa maskooteti gordettida; iraykka salon teqettides. ");
INSERT INTO gmvl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Histtiin haaththay wodhdhi wodhdhi bides; he 150 gallassafe guye haaththay wodhdhides. ");
INSERT INTO gmvl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Haaththay wodhdhiin markabezi laappunththa aginan tammanne laappunththa gallassan Araraate geetettiza zuma bolla shempides. ");
INSERT INTO gmvl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Haaththay tammanththo agina gakkanaaska wodhdhi wodhdhi bides; tammanththo aginan koyro gallas zumatas hu7ey beettides. ");
INSERT INTO gmvl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Oyddu tammu gallassafe guye Nohey ba keexxida markabeza maskooteza doydi, ");
INSERT INTO gmvl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","issi quuro kare kessi yeddiin quurozi haaththi biitta bollafe melana gakkanaas yaanne haa piradhdhishe gam7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Qasse Nohey haaththi biitta bollafe wodhdhi wuridaakko beyanaas issi haraphphe kare yeddides. ");
INSERT INTO gmvl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Gido attiin he haraphpheya haaththi biitta ubbaa bollan ha7ikka diza gishshas shempizaso demmabeekku; hessa gishshas simmada markabeza giddon diza Nohekko yiin izi ba kushe yeddidi baakko markabeza giddo ekkides. ");
INSERT INTO gmvl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Qasseka hara laappun gallas gam7idi ha7ikka haraphpheyo markabeza giddofe kessi yeddides. ");
INSERT INTO gmvl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","He haraphpheya gadey qammishin izakko simma yashe wogara xeerappe cilila hayth duuththada doonan saxxa ekka yida gishshas haaththi biitta bollafe wodhdhidayssa Nohey erides. ");
INSERT INTO gmvl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Qasse Nohey hara laappun gallas gam7idi he haraphpheyo zaari yeddides; gido attiin he haraphpheya izakko simma yabeekku. ");
INSERT INTO gmvl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nohey 601 layth de7iin koyro aginan koyro gallas haaththi biitta bollafe xoskides; Nohey markabeza kaaraa qaari xeellidi gadey xoskidayssa be7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Nam7anththo aginan nam7u tammanne laappunththa gallassan biittay mulera melides. ");
INSERT INTO gmvl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","He wode Xoossi Nohe hizgi azazides, ");
INSERT INTO gmvl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Neni ne machcho, ne naytanne ne nayta machcheta ekkada markabezappe keza. ");
INSERT INTO gmvl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Istti yeletti daridi corattana mala shemppora diza medheteththa ubbaafe nenara dizayta, kafota, meheta, do7atanne biittara gooshettizayta ubbaa nenara kessa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nohey ba naytara, ba machcheyranne ba nayta machchetara markabeza giddofe kezides. ");
INSERT INTO gmvl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Mehey, do7ay, biittara gooshettiza medheteththi, kafoynne biitta bollan woxxi qaaxxiza miishshi wuri ba qommon qommon markabeza giddofe kezides. ");
INSERT INTO gmvl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Hessafe guye Nohey GODAAS yarshizaso keelidi geeshsha mehe ubbaafenne geeshsha kafo ubbaafe ekkidi yarshizason xuuggidi yarshides. ");
INSERT INTO gmvl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Histtiin GODAY yarshoza peeno sawizayssa singidi ba wozinan, «Yelagateththafe doommiin asi wozinan qoppizayssi wuri iita gidikkoka tani asa gishshas gaada nam7anththo mulekka ha biitta qanggike. Qasse tani ha7i ooththida mala paxa diza medheteth ubbaa nam7anththo mulekka dhayssike. ");
INSERT INTO gmvl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ha biittay diza wode ubbaan zereththa wodeynne maxa wodey mooceynne hombey, boneynne balgoy, gallassinne qammay ubba wodekka paccenna» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Xoossi Nohenne iza nayta, «Yelettite; corattite; biitta ubbaa kumite. ");
INSERT INTO gmvl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Biitta do7ati, kafoti, biittan woxxi qaaxxiza miishshatinne abba giddon diza moleti wuri inttes yayettonne dagammetto; istti intte shenen detto. ");
INSERT INTO gmvl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ta inttes biittafe mokkiza dumma dumma kaththata immida malakka shemppora paxa diza medheteththati wuri inttes quma gidana. ");
INSERT INTO gmvl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Shemppoy suuththa giddon diza gishshas suuththi izappe gukkontta asho moopite. ");
INSERT INTO gmvl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Tani intte shemppoy izan diza intte suuth meheppenne do7a ubbaafe tumu ta oychchana; qasse asa ubbaafekka iza mala asa suuth oychchana. ");
INSERT INTO gmvl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Xoossi as bana misatissidi medhdhida gishshas asa suuth gussiza oonakka gidikko iza suuththika asa kushen gukkana. ");
INSERT INTO gmvl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Intte yelettite; corattitenne; biitta bolla keehi darite» gi anjjides. ");
INSERT INTO gmvl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Hessafe guye Xoossi Nohenne izara diza iza nayta hizgides; ");
INSERT INTO gmvl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","10","«Histtiin ha7i tani ta caaqo inttenara, inttefe guye intte zereththaranne nenara shemppora diza medheteththatara caaqettadis; ee! Tani ta caaqo kafora, mehera, biitta do7a ubbaaranne markabeppe inttenara kezida paxa diza medheteth ubbaara caaqettadis. ");
INSERT INTO gmvl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Tani inttenara caaqettadis; hayssafe sinththan paxa dizay wuri dhayssiza haaththan mulekka dhayenna; ha biittaa dhayssiza haaththi hayssafe guye mulekka deenna» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Qasseka Xoossi, «Tani taappenne inttefe, inttenara diza paxa medheteththatas ubbaafe giddon yaana yeleta ubbaara caaqettiza caaqozas malatay hayssa; ");
INSERT INTO gmvl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","tani ta zuulla salo bolla essana; izi taappenne ha biitta bolla diza medheteththafe giddon diza caaqozas malata gidana. ");
INSERT INTO gmvl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tani biittafe bollan shaara ehida wodenne shaara bollan zuullay beettida wode, ");
INSERT INTO gmvl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","‹Paxa diza medheteth ubbaa dhayssanaas hayssafe sinththan mulekka dhayssa haaththi yeenna› gaada taappenne inttefe paxa diza dumma dumma qommo medheteththata ubbaafe giddon caaqqida ta qaalaa ta qoppana. ");
INSERT INTO gmvl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Zuullay shaara bolla beettida wode aydekka tani iza beyada taappe Xoossaafenne ha biittaa bollan paxa diza dumma dumma qommo medheteththa ubbaafe giddon caaqo gelida mernaa caaqo qaalaa ta hassa7ana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Xoossi Nohe, «Tani taappenne ha biitta bollan paxa diza ubbaafe giddon caaqqida caaqozas malatay hayssa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Markabezappe kezida Nohe nayti Seeme, Kaamenne Yaafeete; Kaamey Kanaane aawa. ");
INSERT INTO gmvl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Hayti heedzdzayka Nohe nayta; biitta ubbaan diza asay isttafe yelettides. ");
INSERT INTO gmvl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nohey goshshanchcha; izi woyne mith toketh oykkides. ");
INSERT INTO gmvl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Issi gallas izi woyneppe oosettida cajje uyi maththottidi ba Dunkaaneza giddon paxa kallo ichchides. ");
INSERT INTO gmvl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kanaane aawa Kaamey ba aawaa kalloteth be7idi kare kezidi ba ishata nam7atas yootides. ");
INSERT INTO gmvl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Gido attiin Seemeynne Yaafeetey may7o ekkidi nam7ayka ba hashe hashe bolla gaththi oykkidi gundiguth hemetti gelidi ba aawa kalloteth kammida; istti ba aawaa kalloteth be7ontta mala ba ayfeso guye zaarida. ");
INSERT INTO gmvl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nohey maththoy aadhdhiin beeggidi ubbaafe kaalo naazi ba bolla ooththidayssa eridi, ");
INSERT INTO gmvl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","«Kanaaney qanggettidaaz gido! Izi ba ishata aylletas aylle gido!» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Qasseka Nohey, «GODAY, Seeme Xoossi galatetto! Kanaaney Seeme aylle gido! ");
INSERT INTO gmvl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Xoossi Yaafeete biitta aasso! Yaafeete zereththati Seeme zereththatara detto! Kanaaney Yaafeete aylle gido!» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Dhayssa haaththafe guye Nohey 350 layth de7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nohey mulera 950 layth deyidi hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nohe nayta, Seeme, Kaamenne Yaafeete yeletay hayssafe kaalli xaafettidayssa; dhayssa haaththaafe guye isttas attuma nayti yelettida. ");
INSERT INTO gmvl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yaafeete attuma nayti Goomere, Maagooge, Maadaye, Yaawaane, Tubaale, Mesheekenne Tiraase, ");
INSERT INTO gmvl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Goomere attuma nayti Ashkenaaze, Irafaatenne Togarma. ");
INSERT INTO gmvl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yaawaane attuma nayti Elishe, Tarseese, Kiitimenne Eroode. ");
INSERT INTO gmvl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Haytanttafe abba doonan diza asay wuri ba biittan biittan, ba qaalan qaalan, ba qommon qommoninne, ba kawoteththan kawoteththan shaakettides. ");
INSERT INTO gmvl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kaame attuma nayti Kuushe, Gibxe, Puuxenne Kanaane. ");
INSERT INTO gmvl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kuushe attuma nayti Seeba, Hawila, Saabite, Eraa7imenne Sabiteka. Eraa7ime attuma nayti Saabanne Dadaane. ");
INSERT INTO gmvl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuushey Namuruude yelides; Namuruudey biitta bollan koyro wolqqama olanchcha gidides; ");
INSERT INTO gmvl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","GODAA sinththankka izi wolqqama shankkanchcha gidides; hessa gishshas, «Namuruude mala GODAA sinththan wolqqama shankkanchcha gida» geetettees. ");
INSERT INTO gmvl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Iza kawoteththan koyro katamati Sana7oore biittan diza Baabiloone, Ereeke, Akkaadenne Kalanahe. ");
INSERT INTO gmvl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","Izi he biittaafe Asoore biidi Nannawe, Erahoobotenne Kaalahe katamata ooththides; qasse Nannaweppenne Kaalaheppe giddon diza Ereseene geetettiza gita katamakka ooththides. ");
INSERT INTO gmvl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Gibxey Luudimeta, Anaameta, Lahaabeta, Naftuheta, Phaxirooseta, Kaasiluhetanne Filisxeemeta yelida Kaftooreta aawa. ");
INSERT INTO gmvl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","16","Kanaaney ba bayra naaza Sidoona, Keexeta, Yaabuseta, Amooreta, Gergeseta aawa; ");
INSERT INTO gmvl_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","qasseka Hiiweta, Arqeta, Siineta, ");
INSERT INTO gmvl_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwaadeta, Xamaaretanne Hamaateta aawa. Hessafe guye Kanaane zereththati biitta bolla laalettida. ");
INSERT INTO gmvl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanaane biitta zaway Sidoonappe doommidi Geraarenne Gaazara kanththidi, Sodoomenne Gamoora, Adaamanne Xaboyme kanththi biidi Lasha7ere gakkees. ");
INSERT INTO gmvl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Kaame attuma nayti ba qommon qommon, ba qaalan qaalan, ba biittan biittaninne ba kawoteththan kawoteththan xaafettidayti haytantta. ");
INSERT INTO gmvl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Seemes nayti yelettida; izi Yaafeetes bayra ishanne Eboore nayta ubbaas mayza. ");
INSERT INTO gmvl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Seeme attuma nayti Elaame, Asoore, Arfaakiside, Luudenne Aaraame. ");
INSERT INTO gmvl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aaraame attuma nayti Uuxe, Huule, Geterenne Meeshe. ");
INSERT INTO gmvl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaakisidey Sheelahe yelides. Sheelahey Eboore yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eboores nam7u attuma nayti yelettida; biittan diza asay iza woden shaakettida gishshas issaa sunththi Peeleege geetettides; iza ishaza sunththi Yoqixaane geetettees. ");
INSERT INTO gmvl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoqixaaney nayta yelides; isttika Almodaade, Shelefe, Haxarmaawete, Yerahe, ");
INSERT INTO gmvl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoraame, Uzaale, Diiqile, ");
INSERT INTO gmvl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Oobaale, Abima7eele, Saaba, ");
INSERT INTO gmvl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofire, Hawilanne Yobaabe; haytanti wurikka Yoqixaane attuma nayta. ");
INSERT INTO gmvl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Istti de7ida biittay arshey mokkiza baggara diza zuma Meesheppe biidi Safaare gakkees. ");
INSERT INTO gmvl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Seeme attuma nayti ba qommon qommon, ba qaalan qaalan, ba biittan biittaninne ba kawoteththan kawoteththan xaafettidayti haytantta. ");
INSERT INTO gmvl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Haytanti ba qommon qommoninne ba kawoteththan kawoteththan xaafettida Nohe attuma nayta zereththata; dhayssa haaththafe simmiin kawoteththati haytanttafe biitta ubbaa bolla laalettida. ");
INSERT INTO gmvl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Biitta bollan diza asi wuri koyro issi doonanne issi qaala haasayees. ");
INSERT INTO gmvl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Asay arshey mokkiza bagga simmidi bishe Sana7oore geetettiza biittan issi dembaso demmidi heen uttides. ");
INSERT INTO gmvl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Istti issoy issaa, «Haa yiite; xuube medhdhidi ane taman xuuggoos» giidi istta shuchcha gishshas xuube, urqqa gishshas shida ");
INSERT INTO gmvl_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ekkidi, «Haa yiite! Nu sunth xeygisanaassinne qasse nuni ha biitta ubbaa bollan laalettontta mala issi gita katamanne xeeray pude salo gakkiza issi gimbe ane keexxoos» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Gido attiin GODAY asay keexxida gita katamazanne gimbeza beyanaas duge wodhdhidi, ");
INSERT INTO gmvl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","«Hekko istti issi asa! Qasse istti wurikka issi qaalan haasayeettes; istti ha7i hayssa ooso oykkidaappe guye, istti baas ooththanaas qoppidayssa istta digganay deenna. ");
INSERT INTO gmvl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Haa yiite! Ane nu duge wodhdhidi istti issoy issaa qaala erontta mala istta qaala walakkoos» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Hessa gishshas GODAY istta hessafe biitta ubbaa bollan laalliin istti he gita katama ooththizayssa aggaagida. ");
INSERT INTO gmvl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","GODAY biitta asaa qaalaa heen walakkida gishshas he katamaya Baabile geetettadus. GODAY istta hessafe biitta ubbaa bollan laallides. ");
INSERT INTO gmvl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Seeme zereththi hayssafe kaallidi xaafettidayssa; dhayssa haaththi simmiin nam7u layththafe guye Seemes layththay 100 gidiin Seemey Arfaakiside yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Seemey Arfaakiside yelidaappe guye 500 layth de7ides; hara attuma naytakka macca naytakka yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaakisidey 35 layth de7idi Sheelahe yelides; ");
INSERT INTO gmvl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arfaakisidey Sheelahe yelidaappe guye 403 layth de7ides; hara attuma naytanne macca naytakka yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sheelahey 30 layth de7idi Eboore yelides; ");
INSERT INTO gmvl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sheelahey Eboore yelidaappe guye 403 layth de7ides; hara attuma naytanne macca nayta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eboorey heedzdzu tammanne oyddu layth de7idi Peeleege yelides; ");
INSERT INTO gmvl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eboorey Peeleege yelidaappe guye 430 layth de7ides; hara attuma naytanne macca nayta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peeleegey 30 layth de7idi Era7e yelides; ");
INSERT INTO gmvl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peeleegey Era7e yelidaappe guye 209 layth de7ides; hara attuma naytanne macca nayta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Era7ey 32 layth de7idi Saruge yelides; ");
INSERT INTO gmvl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Era7ey Saruge yelidaappe guye 207 layth de7ides; hara attuma naytanne macca nayta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sarugey 30 layth de7idi Naakoore yelides; ");
INSERT INTO gmvl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Sarugey Naakoore yelidaappe guye 200 layth de7ides; hara attuma naytanne macca nayta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naakoorey 29 layth de7idi Taara yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Naakoorey Taara yelidaappe guye 119 layth de7ides; hara attuma naytanne macca nayta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Taaray 70 layth de7idi Abraame, Naakoorenne Haaraane yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Taara yeletay hayssafe kaallidi xaafettidayssa; Taaray Abraame, Naakoorenne Haaraane yeliin Haaraaney Looxe yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haaraaney ba aaway Taaray paxa dishin ba yelettida Kaladaaweta biittan Uure geetettiza gita katamaan hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abraameynne Naakoorey nam7ayka machchida; Abraame machchey sunththi Soora; qasse Naakoore machchey sunththi Milka; Milkay Haaraane naa; Haaraaney Milkissinne Yiskaanissi aawa. ");
INSERT INTO gmvl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sooray maynne; izis nay baawa. ");
INSERT INTO gmvl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Taaray ba naa Abraame, ba naaza Haaraane naa Looxenne ba naa Abraame machcho Soora ekkidi keziin istti issife Kanaane biitta baanaas Uure geetettiza Kaladaaweta katamappe dendida; gido attiin istti Kaaraane geetettiza katama gakkanaas biidi heen de7ida. ");
INSERT INTO gmvl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Taaray 205 layth de7idi Kaaraanen hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","GODAY Abraame, «Ne dereppe, ne dabbotappenne ne aawa keeththa asaappe shaakettada tani nena bessiza biitta ba. ");
INSERT INTO gmvl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","«Tani nena gita kawoteth ooththana; qasseka anjjana; Ne sunththaa gitasana; nekka haratas anjjo gidana. ");
INSERT INTO gmvl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nena anjjizayta ta anjjana; nena qanggizaytakka ta qanggana; biitta bolla diza asi wuri ne baggara anjjettana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abraamey GODAY izas yootida mala dendi bides; Looxeykka izara bides; Abraamey Kaaraane dereppe bishin izas layththay laapun tammanne ichchasha. ");
INSERT INTO gmvl_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abraamey ba machchiyo Soora, ba isha naa Looxe, Kaaraanen istti demmida aylletanne heen shiishshida bantta aqota ubbaa ekkidi Kanaane biitta bides. ");
INSERT INTO gmvl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abraamey he biittan Seekeemen Moore geetettizason diza gita miththaako gakkanaas bides; he wode Kanaane asati he biittan deettes. ");
INSERT INTO gmvl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","GODAY Abraames qonccidi, «Ha biittaa tani ne zereththas immana» gides; izi baas qonccida GODAAS he sohon yarsho yarshizaso keexxidi goynnides. ");
INSERT INTO gmvl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Hessafe dendidi Beeteleppe arshey mokkiza baggara diza zumatizaso biidi heen Beetele arshey wulliza baggan aggidi qasse Aye geetettiza katama arshey mokkiza bagga aggidi giddon ba dunkaane tolides; heenkka GODAAS yarsho yarshizaso keexxidi GODAA sunththaa xeygides. ");
INSERT INTO gmvl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Hessafe guye Abraamey heeppe dendi biidi Negebe geetettiza bazzo gakkides. ");
INSERT INTO gmvl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","He wode Kanaane biittan koshay dendiin koshazi keehi iita gidida gishshas Abraamey kosha wode aaththanaas duge Gibxe wodhdhides. ");
INSERT INTO gmvl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Gibxe gelana hanishin Abraamey ba machchiyo Soora, «Siya! Ne daro mala lo7o maccas gididayssa ta erays. ");
INSERT INTO gmvl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Gibxe asay nena be7iza wode isttas, ‹Hanna iza machcho› giidi nena aggidi tana wodhana. ");
INSERT INTO gmvl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Hessa gishshas istti taas ne gaason kiyana malanne qasse ne gaason ta hayqqontta attana mala neni, ‹Ta izas michcho› ga» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abraamey Gibxe biitta gelida wode Gibxe asati he maccassaya daro mala lo7o maccas gididayssa be7ida. ");
INSERT INTO gmvl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Qasse Gibxe kawos ooththiza halaqatikka izo be7idi kawo sinththan izo nashshida; histtidi izo kawoso efida. ");
INSERT INTO gmvl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Histtiin izi geedon kawoy Abraame lo7o ayfen xeellidi Abraames dorsatanne boorata, adde haretanne macca hareta, adde aylletanne macca aylleta, gaamellatakka immides. ");
INSERT INTO gmvl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Gido attiin GODAY Abraame machcheyo Soora geedon Gibxe kawo bollanne izaso asaa bolla bosha yeddides. ");
INSERT INTO gmvl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Histtiin kawozi Abraame xeygidi, «Neni hayssa ays ta bolla ooththadii? Iza ne machcho gididayssa ays taas yootabeekkii? ");
INSERT INTO gmvl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ta izo machcho ekkana mala, ‹Iza ta michcho› gaada aazas wordotadii? Hekko hanno ne machcheyo ekkada ba!» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Kawozikka ba aylleta Abraame iza machcheyranne izas dizaaz ubbaa kessidi yeddana mala azaziin aylleti istta dereppe kessi yeddida. ");
INSERT INTO gmvl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Hessa gishshas Abraamey ba machcheyranne baas dizaaz ubbaara Gibxeppe Negebe bazzo bides; Looxeykka izara bides. ");
INSERT INTO gmvl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abraamey he wode mehen, biraninne worqqan daro duretides. ");
INSERT INTO gmvl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Izi Negebeppe dendidi Beetele gakkanaas bides; Beeteleppenne Ayeppe giddon diza dere bides; hesoykka izi koyro ba dunkaane tolidi, ");
INSERT INTO gmvl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","yarsho shiishshanaas keexxidaso; heenkka Abraamey GODAA sunth xeygides. ");
INSERT INTO gmvl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abraamera yuuyiza Looxeska daro miizi, dorsi, deyshinne dunkaaney dees. ");
INSERT INTO gmvl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Gido attiin isttas daro mehey diza gishshassinne istti issife daanaas isttas biittay xuummida gishshas issife daanaas dandaybeettenna. ");
INSERT INTO gmvl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Hessa geedon Abraame wude heemmizayta giddoninne Looxe wude heemmizayta giddon ooshshi medhettides; he wode Kanaanetinne Paarizeti he biittan deettes. ");
INSERT INTO gmvl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Histtiin Abraamey Looxes, «Nuni ishantta gidida gishshas, nu giddon, ta mehe heemmizayta giddoninne ne mehe heemmizayta giddon oosh medhdhofa. ");
INSERT INTO gmvl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Biittay wuri ne sinththan deennee? Ane nuni shaakettoos; neni hadirsa bagga biikko, tani ushachcha bagga baana; neni ushachcha bagga biikko tani hadirsa bagga baana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Looxey yuuyi aadhdhi xeellidi Yordaanoose shoobbay biidi Zo7aare gakkanaas GODAA gannate woykko Gibxe biitta mala daro haaththi dizayssa be7ides. (Hessika GODAY Sodoomenne Gamoora geetettiza katamata dhayssanaappe kase.) ");
INSERT INTO gmvl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Hessa gishshas Looxey baas Yordaanoose shoobba ubbaa dooridi arshey mokkiza baggara bida gishshas istti ba garsan shaakettida. ");
INSERT INTO gmvl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abraamey Kanaane biittan de7ides; Looxey gidikko shoobban diza gita katamata giddon uttidi Sodoome katama matan ba Dunkaaneza tolides. ");
INSERT INTO gmvl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","He wode Sodoome asay iitanne GODAA sinththan pala nagara ooththizayta. ");
INSERT INTO gmvl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Looxey Abraameppe shaakettidaappe guye GODAY Abraame, «Dhoqqu gaada neni dizasoppe arshey mokkiza bagganne geliza bagga qasse dugeha bagganne pudeha bagga xeella. ");
INSERT INTO gmvl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Hayssa neni xeelliza biitta ubbaa ta neessinne ne zereththas mernaas immana. ");
INSERT INTO gmvl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Tani ne zereth biitta ace mala darsana; oonikka biitta ace taybana dandaykko ne zereththika taybettana. ");
INSERT INTO gmvl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Dendada biitta bolla pudenne duge, yaanne ha yuuya xeella; gaasoykka tani hayssa biittaa nees immana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Histtiin Abraamey ba Dunkaaneza shoddidi, Kebroonen Mamire geetettizason diza gita miththaa achchan de7anaas bides. Heenkka GODAAS yarsho yarshizaso keexxides. ");
INSERT INTO gmvl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","He wode Sana7oore Kawoy Amiraafeeley, Eelaasaare kawoy Aryookey, Elaame kawoy Kadorlaa7oomereynne ayzaabe kawo Tidi7aaley oyddati, ");
INSERT INTO gmvl_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Sodoome kawo Beera7era, Gamoora kawo Birshara, Adaama kawo Shin7aabera, Xaboyme kawo Shemebeereynne (Zo7aare geetettiza) Beela kawora olettanaas bida. ");
INSERT INTO gmvl_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ha ichchashu kawoti gaaggidi issi bagga gididi, (Hayqo Abba geetettiza) Siddime shoobban shiiqida. ");
INSERT INTO gmvl_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Istti kase tammanne nam7u layth Kadorlaa7oomeres haarettida; gido attiin tammanne heedzdzanththo layththan iza bolla makkallida. ");
INSERT INTO gmvl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Tammanne oydanththo layththan Kadorlaa7oomereynne izara zuppetida kawoti ba olanchchata ekki biidi, Astaroote-Qarnaymen diza Erafaymeta, Haaman diza Zuuzetanne Shaawe-Qiriyaataymen diza Eemime geetettiza dereta olidi xoonida. ");
INSERT INTO gmvl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Hoore biitta asatakka Seyre zuma bolla olidi bazzo achchan diza Elparaane geetettizaso gakkanaas gooddida. ");
INSERT INTO gmvl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Hessafe guye simmidi En-Mishipaaxe yida. (Ha7i he derey Qaadeese geetettees.) Istti Amaaleeqeta biitta qasse Haxaxoone Taamaare geetettizason diza Amoore asaa ubbaa olidi xoonida. ");
INSERT INTO gmvl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Hessafe simmiin, Sodoome kawoy, Gamoora kawoy, Adaama kawoy, Xaboyme kawoynne (Zo7aare geetettiza) Beela kawoy dendidi Siidime shoobban olas salfida. ");
INSERT INTO gmvl_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Hayti wuri Elaame kawora, ayzaabeta kawora, Sana7oore kaworanne Eelaasaare kawora (ha ichchashu kawoti oyddu kawotara) olettida. ");
INSERT INTO gmvl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","He wode Siidime shoobban, shida oykkiza daro ollay dees. Sodoome kawoynne Gamoora kawoy ba ola asaara olappe baqatishin, isttafe guuththati he ollatan kundida; gido attiin attidayti pude zuma bolla baqatida. ");
INSERT INTO gmvl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Oyddu kawoti Sodoomenne Gamoora katamata aqotanne miza kath ubbaa bonqqi ekki bida. ");
INSERT INTO gmvl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abraame isha nay Looxey, Sodoomen diza gishshas izakka iza aqotaakka ubbaa ekki bida. ");
INSERT INTO gmvl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Hessafe guye issi asi kessi ekkidi baqati yiidi Ibraawe Abraames hessa yootides; Abraamey he wode Eshkoolenne Aneere isha Amoore dere as Mamire wola achchan dees; istti wurikka ola zaaranaas Abraamera caaqettida. ");
INSERT INTO gmvl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abraamey ba dabboy di7ettidayssa siyida wode ola eriza bason yelettida heedzdzu xeetanne tammanne osppun asaa denththides; he oyddu kawota kaallidi Daane geetettiza katama gakkanaas bides. ");
INSERT INTO gmvl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Heen omarsan ba asaa cugan cugan shaakkidi, ba morkketara olettidi xoonides; histtidi Damasqofe bolla baggara diza Hoobbe geetettizaso gakkanaas gooddides. ");
INSERT INTO gmvl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abraameykka ba dabbo Looxenne iza aqota ubbaa kase di7ettida maccassaanne hara asaakka woththi ekkides. ");
INSERT INTO gmvl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abraamey Kadorlaa7oomerenne izara zuppetida kawota xoonidi simmidaappe guye, Sodoome kawoy, (kawota shoobba geetettiza) Shaaweha shoobbaan iza mokkanaas kezides. ");
INSERT INTO gmvl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","He wode, Saaleme kawoy Malkexeedeqey ukeththinne woyne ushshu ekki yides; izikka Ubbaafe Dhoqqa Xoossaa qeese. ");
INSERT INTO gmvl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Izi Abraame hizgi anjjides; «Ubbaafe Dhoqqa Xoossi salonne sa7a medhdhidayssi Abraame anjjo. ");
INSERT INTO gmvl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Qasse Ubbaafe Dhoqqa Xoossi, Ne morkketa ne kushen aaththi immidayssi galatetto» gides. Abraamey ubbaafe tammaafe issi kushe kessidi Malkexeedeqes immides. ");
INSERT INTO gmvl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodoome kawoy Abraame, «Ta asaa taas zaarada ne di7ida meheza ubbaa nees ekka» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Gido attiin Abraamey Sodoome kawo, «Tani GODAAS, Ubbaafe Dhoqqa Xoossaas, salonne sa7a medhdhidayssas, ta kushe denththada caaqqaychchadis. ");
INSERT INTO gmvl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","24","Ta asay midayssafenne tanara bida Aneere, Eshkoolenne Mamire gakkizayssafe attiin neni, ‹Abraame tani duresadis gontta mala tani neyssafe haray atto issi miish woykko caamma kirekka ta ekkike; istti bana gakkizayssa ekketto› gees» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Hessafe guye GODAA qaalay ajjuutan Abraamekko yiidi, «Abraame, babbofa! Tani nees gondalle; ne anjjoy keehi gita» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abraamey, «Abeet Ubbaa Haariza GODAWU! Taas mulekka nay baynda gishshas neni immiza imotay taas ayssee? Damasqo dere as El7ezeerey tana laattana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Qasseka Abraamey, «Neni taas aykko naa immabeekka; hessa gishshas tason diza aylley tana laattanaas dees» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","GODAA qaalay izakko yiidi, «Hayssi aylley nena laattenna; neeppe yelettiday nena laattana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Hessafe guye GODAY Abraame kare kessidi, «Pude salo xeella; neni xoolintteta taybanaas dandaykko tayba; ne zereththayka hayssa mala gidana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abraameykka GODAA ammanides; iza ammanoykka Xilloteththan qoodettides. ");
INSERT INTO gmvl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Qasseka GODAY iza, «Ne hayssa biittaa laattana mala ta nees immanaas Uure geetettiza Kaladaaweta katamappe nena kessa ehida GODAY tana diikkinaa?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Gido attiin Abraamey iza, «Abeet Ubbaa Haariza GODAWU! Tani hayssa biittaa laattanayssa aazan eroo?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","GODAYKKA iza, «Heedzdzu layththa us, heedzdzu layththa deysh, heedzdzu layththa dorsa laaqqanne nam7u qommo haraphpheta taas ekka ya» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Izi heyta ubbata izas ekki efi shukkidi giddon nam7u nam7u kessi shaakkidi issaa issaa ginan woththides; gido attiin kafota nam7u kessibeenna. ");
INSERT INTO gmvl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","He wode ankko kafoti he ashoza bolla uttiin Abraamey istta gooddides. ");
INSERT INTO gmvl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Arshey wulliza wode Abraame wolqqama dhiskoy oykkiin daganththiza girdi gida dhumay iza bolla dhumides. ");
INSERT INTO gmvl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Histtiin GODAY izas, «Ne zereththay hara biittan bete gidi daanayssa neni tumappe era; istti aylletidi 400 layth yedhetti haarettana. ");
INSERT INTO gmvl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ayllesidi istta haariza kawoteththaa ta qaxxayana; hessafe guye istti daro aqora he biittaafe kezana. ");
INSERT INTO gmvl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Neni gidikko ne aawatakko saron baana; ne keeha cimmada hayqqananne moogettana. ");
INSERT INTO gmvl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Oydanththo yeletan ne zereththay ha biitta simmana; ays giikko Amoore dere asaa nagaray buro kumontta gishshassa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Arshey wulliin gadey dhumidaappe guye cooce tama lacoynne cuway beettidi he nam7u nam7u kezi shaakettida ashota giddora kanththides. ");
INSERT INTO gmvl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","He gallas GODAY Abraames, «Gibxe shaafappe doommidi Efiraaxise geetettiza gita shaafaa gakkanaas ha biittaa tani ne zereththaas immadis. ");
INSERT INTO gmvl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Heytikka Qenaaweta, Qenaazeta, Qadimooneta, Hiiteta, Paarizeta, Erafaymeta, Amooreta, Kanaaneta, Gergesetanne Yaabuseta biitta» gi caaqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abraame machcheya Sooray izas ha7ikka naa yelabeekku; gido attiin izis Gibxeppe yida Aggaaro geetettiza issi aylleya dawus. ");
INSERT INTO gmvl_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Hessa gishshas Sooray Abraame xeygada, «Beya! GODAY tana yelo diggides. Neni baada, ta aylleyra aqa; oonee erizay, tani izi baggara naa aayo gidanaakkonne» gadus; histtiin Abraamey Soora qaala siyides. ");
INSERT INTO gmvl_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abraamey Kanaane biittan tammu layth uttidaappe guye Abraame machcheya Sooray Gibxeppe ehida ba aylleyo Aggaaro, ba azina Abraames machcho histta immadus. ");
INSERT INTO gmvl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abraameykka Aggaaro ekkiin iza qanththatadus; iza baas shaaray attidayssa erida wode ba godatteyo leqqadus. ");
INSERT INTO gmvl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","He wode Sooray Abraame, «Ta qohettiza qohoy nena gakko; tani ta aylleyo nees immiin iza ha7i baas shaaray attidayssa erada tana leqqawus. Neessinne taas Xoossi pirdo» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abraameykka Soora, «Hanno beya! Ne aylleya ne kushen dawus; neni izo nena lo7idaaz ooththa» gides; hessafe guye Sooray Aggaaro qohiin iza kezada izippe betadus. ");
INSERT INTO gmvl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","GODAA kiitanchchay Aggaaro bazzon pultto haaththa achchan demmides; he pulttoy Shuura geetettiza biitta efiza oge matan dees. ");
INSERT INTO gmvl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Izikka Aggaaro, «Hanne Soora aylle Aggaaree! Awappe yadii? Qasse awa bay?» gi oychchides. Iza, «Tani ta godatteyo Soorappe bete bays» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","GODAA kiitanchchayka izis, «Neni ne godatteyko guye simma baada izis haaretta» gides ");
INSERT INTO gmvl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Qasseka Xoossa kiitanchchay izo, «Ne zereth taybanaas dandayettonttayssa keena tani darsana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Qasseka GODAA kiitanchchay izo, «Ha7i neni qanththatadasa; neni attuma naa yelana; yelada iza Isma7eele gaada sunththana; gaasoykka Xoossi ne waasaa siyides. ");
INSERT INTO gmvl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Izi bazzon yeda diza hare mala gidana; asa ubbaara izi eqettana; qasse asi wurikka izara eqettana; izi ba ishata ubbaara ixetti daana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Aggaarakka, «Tani tana be7izayssa be7ada paxa attanee?» gaada iza baas haasayda GODAA, «Neni tana be7iza Xoossa» ga sunththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Hessa gishshas he pultto ollay, «Tana Be7iza De7o Xoossa pultto» geetettides; he ollay ha7i gakkanaas Qaadeeseppenne Baareedeppe giddon dees. ");
INSERT INTO gmvl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Aggaara Abraames attuma naa yeladus; Abraamey Aggaara yelida naaza Isma7eele gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Aggaara Isma7eele Abraames yelida wode Abraame layththay 86. ");
INSERT INTO gmvl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abraame layththi uddufun tammanne uddufun gidishin GODAY izas qonccidi, «Tani Ubbaa Dandayza Xoossa; ne ta sinththan suure hemetta. ");
INSERT INTO gmvl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Tani taappenne neeppe giddon diza caaqo qaalaa minththana; tani ne zereththaa keeha darsana!» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abraamey biittan duge gufannidi hu7ey biitta bochchiin izi Xoossas ziggiin Xoossi izas, ");
INSERT INTO gmvl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Ha7i ta nenara caaqqiza caaqoy hayssa; neni daro kawoteththatas aawa gidana. ");
INSERT INTO gmvl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Hachchife guye ne sunththi Abraame geetettenna; gido attiin ne sunththi Abrahaame geetettana; aazas giikko tani nena daro kawoteththatas aawa ooththadis. ");
INSERT INTO gmvl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Tani nena keeha darsana; tani nena daro kawoteth histtana; kawotikka neeppe kezana. ");
INSERT INTO gmvl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Tani taappenne neeppe, neeppe guye ne zereththa giddon, yeletappe yeleta gakkanaas ta gelida caaqo qaala minththana; ha caaqoykka tani neessinne neeppe guye ne zereththas Xoos gidana. ");
INSERT INTO gmvl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ha7i neni bete gidada diza Kanaane derey wuri neessinne neeppe guye ne zereththas mernaas laata biitta gidana mala tani immana; qasse tani istta Xoos gidana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Qasseka Xoossi Abrahaame, «Nekka neeppe guye ne zereththayka, yeletappe yeleta gakkanaas ta caaqo qaalaa naagite. ");
INSERT INTO gmvl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Taappenne neeppe, neeppe guye ne zereththa giddon intte naagana ta caaqo qaalay hayssa; intte giddon diza attumas ubbay qaxxaretto. ");
INSERT INTO gmvl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Intte shurte qaxxaretteeta; hayssi taassinne inttes giddon diza caaqo qaalaas malata gidana. ");
INSERT INTO gmvl_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Intte giddon sinththafe yelettana adde nayti wuri yelettida osppunththa gallas qaxxarettanaas koshshees; neson yelettidayta gidiin, woykko allagappe miishshan shamettida aylleta gidiin ne zereth gidontta addetakka qaxxaranaas koshshees. ");
INSERT INTO gmvl_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Neson yelettidaytinne ne miishshan shamettidayti qaxxarettetto; hayssi intte ashon diza ta caaqoy mernaa caaqo gidana. ");
INSERT INTO gmvl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Qaxxarettontta attumasi wuri ba asaappe shaakettidi dhayo; gaasoykka izi ta caaqo qaalaa naagibeenna» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Qasseka Xoossi Abrahaame, «Ne machchey sunththaa Soora gooppa; hayssafe guye izi sunththi Saara geetetto. ");
INSERT INTO gmvl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Tani izo anjjana; tani izippe nees tumappe attuma naa immana; izo tani anjjana; iza kawoteththatas aayo gidana; kawoti izippe yelettana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abrahaamey biitta bolla gufannidi ba wozinan miiccishe, «100 layththa asi tumu naa yelanee? Qasse izis layththay uddufun tammu gidida Saaray buro naa yelanee?» gi qoppides. ");
INSERT INTO gmvl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abrahaamey Xoossaas, «Ne Isma7eele taas anjjidaakko ay mala lo7oshin!» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Xoossayka izas, «Hanenna! Ne machcheya Saaray nees attuma naa tumappe yelana; neni iza Yisaaqa gaada sunththana; izappe guye iza zereththas mernaa caaqo gidana mala ta izara caaqo qaala gelana. ");
INSERT INTO gmvl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Isma7eeles gidikko ne oychchidayssa ta siyadis; tani izakka anjjana; tani iza darsana; iza zereththaa keeha darsana; izi tammanne nam7u kawota yelana; tani iza zereththaa gita kawoteth kessana. ");
INSERT INTO gmvl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Gido attiin tani ta caaqo qaalaa layth hanni wode Saaray nees yelana naaza Yisaaqara caaqettana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Xoossi Abrahaamera haasaydi wursidaappe guye, Abrahaameppe shaakettidi pude bides. ");
INSERT INTO gmvl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","He gallassankka Abrahaamey ba naa Isma7eele bason yelettidayta ubbaa, ba miishshan shammidayta ubbaanne bason diza attumas ubbaa, Xoossi izas yootida mala qaxxarides. ");
INSERT INTO gmvl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahaamey qaxxarettishin izas layththay uddufun tammanne uddufuna. ");
INSERT INTO gmvl_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Iza naa Isma7eeley qaxxarettishin izas layththay tammanne heedzdza. ");
INSERT INTO gmvl_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abrahaameynne iza naa Isma7eeley nam7atikka issi gallas qaxxarettida. ");
INSERT INTO gmvl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Abrahaameson diza attumasay wuri iza soon yelettidaytinne miishshan shamettidayti wurikka izara qaxxarettida. ");
INSERT INTO gmvl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Seeta gallas Abrahaamey Mamiren diza gita miththata garsan ba dunkaane pengen utti dishin GODAY izas qonccides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abrahaamey dhoqqu gi xeellidi heedzdzu asati eqqidayta be7idi istta mokki ekkanaas ba Dunkaaneza pengefe dendidi woxxi bides; he gakki biittan hokkidi istta sinththan ziggides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ziggi simmidi, «Abeet ta godoo! Ne tana ne aylleza bonchchizaa gidikko taso gelontta aadhdha booppa. ");
INSERT INTO gmvl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ha7i intte toho meeccana toho haaththi yiikko intte toho meecettidi hayssa miththaa kuwan shempi ekkite. ");
INSERT INTO gmvl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Intte ha7i taakko intte ayllezakko yida gishshas shempi ekkidi intte bizaso baana mala tani inttes miza miish ane ehays» gides. Istti, «Daro lo7o; neni giza mala ooththa» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abrahaamey Dunkaaneza giddo Saarakko eesoti biidi, «Eesotada liiqo dhiillezappe heedzdzu kere gidizayssa ekka munuqada uketh uukka» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Qasse Abrahaamey ba wudezaakko woxxi biidi lo7o anqara mar dooridi issi aylles immiin izi eeson shukkidi giigsides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Histtiin Abrahaamey meqo maaththinne giigsida maraa ashoza imaththata sinth aaththides; istti mishin izi he miththaa garsan istta achchan eqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Istti iza, «Ne machcheya Saaray awanee?» gi oychchiin izi, «Henin dunkaane giddon dawus» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","GODAY izas, «Tani yiza layth hanni wode tumu neekko simmana; he wode ne machchiya Saaray attuma naa nees yelana» gides. Saaraykka izappe guye baggara dunkaaneza sinththan dashe hessa siyadus. ");
INSERT INTO gmvl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrahaameynne Saaray keehi cimmida; Saaraska maccassatas yiza wogay aggides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Hessa gishshas Saaray ba wozinan, «Tani ha7i cimmidaappe guye, ta azinaykka cimmidaappe guye hayssi ufayssay taas hananee?» gaada miiccadus. ");
INSERT INTO gmvl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","He wode GODAY Abrahaame, « ‹Tani cimmaychidaappe guye tumu naa yelanee?› gaada Saaray aazas miiccadee? ");
INSERT INTO gmvl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","GODAAS dandayettontta miishshi tumu dizee? Ta gida mala yiza layth hanni wode ta neekko yaana; he wode Saaray attuma naa yelana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saaray keeha babbida gishshas, «Tani miiccabeekke» gaada lahottadus. Gido attiin izi, «Ee, neni tuma miiccadasa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Hessafe guye asati baana dendishe Sodoome katama duge zaari xeellida; Abrahaameykka istta moyzishe isttara bides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","He wode GODAY, «Tani ta ooththana gizayssa Abrahaameppe qottanee? ");
INSERT INTO gmvl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abrahaamey tumappe gitanne wolqqama kawoteth gidana; ha biitta asi wuri iza baggara anjjettana. ");
INSERT INTO gmvl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Xilloteththinne suure ooso ooththidi GODAA oge naagana mala ba naytanne baappe guye ba soo asaa izi zorana mala tani iza dooradis; hessika GODAY Abrahaames immana gidayssa ubbaa polanaassa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","21","GODAY Abrahaame, «Sodoomenne Gamoora waasoy keehi darida gishshassinne istta nagaray keehi deexxida gishshas istti ooththidayssi taakko gakkida waaso mala iitakkonne iita gidonttaakko ane tani duge wodhdha beyays» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Hessafe guye nam7u asati Sodoome simmi bida; gido attiin Abrahaamey GODAA sinththan eqqida mala dees. ");
INSERT INTO gmvl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","He wode Abrahaamey izakko shiiqidi, «Tumu neni xillota iitatara gaththa dhayssanee? ");
INSERT INTO gmvl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","He gita katamaan 50 xilloti diikko neni istta dhayssanee? Neni izan diza 50 xillota gishshas he katamaa maarkkii? ");
INSERT INTO gmvl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Xillota wordotara gaththa wodhizayssinne xillotanne wordota issi ayfen xeellizayssi hessi neeppe haakko; ha biitta ubbaa bolla pirdiza neni xillo pirdikii?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","GODAYKKA, «He Sodoome katamaan 50 xilloti diikko he katamaa ubbaa istta gishshas tani ubbaa maarana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Hessafe guye Abrahaamey, «Tani biittanne bidinththakoshin ta Godaara xalada haasaya oykkadis. ");
INSERT INTO gmvl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ichchashu tammu xillotappe ichchashati pacciko neni he paccida ichchashata gishshas he katamaa ubbaa dhayssanee?» gides. GODAYKKA, «Tani heen oyddu tammanne ichchash xillota demmiko he katamaa dhayssike» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abrahaamey zaareththidikka, «Heen 40 xilloti xalla beettikochchii?» gides. Izikka, «Tani he oyddu tammata gishshas he katamaa dhayssike» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Hessafe guye izi, «Ta Godoo! Ne ta bolla hanqettofa; tani gujjadakka oychchays; heen 30 xilloti xalla beettikochchii?» gides. GODAY, «Tani heen 30 xillo as demmiko he katamaa dhayssike» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Qasseka Abrahaamey, «Tani Godaara xalateththan haasaya doommadis; heen 20 xilloti xalla beettikochchii?» gides. GODAY, «He nam7u tammata gishshas dhayssike» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Hessafe guye Abrahaamey, «Ta Godoo! Ne ta bolla hanqettofa; tani mexi issito haasayays; heen 10 xilloy beettikochchii?» gides. GODAY, «He tammata gishshas tani he katamaa dhayssike» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","GODAY Abrahaamera haasaya wursidaappe guye bides; Abrahaameykka baso simmides. ");
INSERT INTO gmvl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","He nam7u kiitanchchati omars Sodoome katama gakkiza wode Looxey he katamaa pengen uttides. Looxey istta be7idi isttara gaagganaas dendi biidi ba hu7e duge biitta gaththi ziggidi, ");
INSERT INTO gmvl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","«Ta godatoo! Intte aylle taso haa yerketi; intte toho meecetti aqidi wonto maaladora dendidi intte bizaso beeta» gides. Isttika, «Akkay bookko; nuni hayssa katamaa dubbushan aqana» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Gido attiin izi istta keehi shoobbida gishshas izara biidi iza soo gelida; izikka isttas uketh uukkidi kawo aaththiin istti mida. ");
INSERT INTO gmvl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Istti ichchontta dishin Sodoome katamaa attumasay wuri naytappe cima gakkanaas issaadeyka attontta yiidi keeththaa yuuyi aadhdhida. ");
INSERT INTO gmvl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Isttika Looxe xeygidi, «Hach omars neso yida asati awan dizoo? Nuni isttara aqana mala istta nuukko kare kessa» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Looxey isttara gaagganaas kare kezidi sohon diza asata bolla kareza guye zaari gordidi, ");
INSERT INTO gmvl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","isttas, «Ta ishatoo! Hayssa iita ooso ooththofte. ");
INSERT INTO gmvl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Taas adde gelontta nam7u geela7o macca nayti deettes; tani istta inttes kare kessiko intte istta inttena lo7ida mala ooththana dandayeeta; gido attiin hayta asata bolla aykkoka ooththofte; ays giikko istti ta keeth gelidi ta imath gidida» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Asati iza, «Nu sinththafe kichcha!» qasseka, «Hayssi addezi ha biittan bete as gidi uttidi ha7i nu bolla pirdanaas kajjalees; ha7i nuni istta bolla ooththana qoppida iitaappe aadhdhida iita ne bolla ooththana» gida. Looxekka guye sugi yeggidi pengeza menththanaas matida. ");
INSERT INTO gmvl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Gido attiin he nam7u asati ba kushe kare yeddidi Looxe soo goochchi gelththidi kareza zaari gordida. ");
INSERT INTO gmvl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Hessafe guye istti keeththaa pengen diza asaa guuththafe gita gakkanaas qooqisiin istti pengeza demmanaas koyishe daaburda. ");
INSERT INTO gmvl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","He nam7u asati Looxe, «Nees hayssa katamaa garsan diza attuma naa woykko macca naa gidiin ne nayta ekkanaas giigsidaytikka diikko woykko hara dabboy diikko istta hayssafe kessa. ");
INSERT INTO gmvl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ays giikko nuni hayssa katamaa dhayssana goos; ha deraa nagaray keehi daro gididayssa GODAY be7ida gishshas hayssa katamaa dhayssanaas nuna kiittides» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Hessa gishshas Looxey ba macca nayta ekkanaas giigsidaytakko biidi isttas, «GODAY ha katamaa dhayssana giza gishshas Eleli dendidi hayssafe kezi kichchite» gides; gido attiin iza macca nayta giigsidayti izi qidhe gees gi qoppida. ");
INSERT INTO gmvl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Gadey wonttana gishin he kiitanchchati Looxe, «Denda! Ne machchiyonne hayssan diza ne nam7u macca nayta ekkada eeson keza! Kezontta ixxiko, hanna katamaya pirdettiza wode nenikka dhayana» giidi eesosida. ");
INSERT INTO gmvl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Gido attiin Looxey shinniin GODAY isttas qadhettida gishshas kiitanchchati iza kushe, iza machchey kushenne macca nayta nam7ata kushe oykkidi he katamaappe istta kessida. ");
INSERT INTO gmvl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kiitanchchati istta katamaappe kessida malakka kiitanchchatappe issay, «Intte shemppo ekkidi baqatite! Guye xeellofte! Qasse hayssa shoobbaan awanka eqqofte! Zumaakko woxxite! Histtontta ixxiko intte dhayana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Gido attiin Looxey isttas, «Ta godatoo! Hessaththo gidoppo! ");
INSERT INTO gmvl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Tani intte aylley intte sinththan sabettida gishshas tana ashshanaas taas daro qadhettideta; gidikkoka hayssi bashshay tana gakkidi dhayssiko hayqqana gishshas tani pude zumaakko baqatanaas dandaykke. ");
INSERT INTO gmvl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Be7ite! Baqati biidi attanaas matan issi guuththa katamay dawus; ta shemppo ashshanaas hee baqatoo? Iza qeeri katama deekkee?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Gido attiin kiitanchchay, «Ee gido! Tani ne woosaa siyadis; tani neni giza katamayo dhayssike. ");
INSERT INTO gmvl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Hessa gishshas gede eeson baqata; neni gede gakkanaas tani aykkoka ooththanaas dandaykke» gides; histtiin he katamay sunththi Zo7aare geetettides. ");
INSERT INTO gmvl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Looxey Zo7aare gakkishin buro xalqqey caarides. ");
INSERT INTO gmvl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","He wode GODAY tamanne xuuggiza diine Sodoome bollanne Gamoora bolla saloppe bukisides. ");
INSERT INTO gmvl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Hessaththo ooththidi GODAY he zullen diza katamatanne zullen dizaaz ubbaa he katamata giddon diza asaa ubbaanne he biittan diza miththinne maata ubbaa xuuggi dhayssides. ");
INSERT INTO gmvl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Gido attiin Looxe machchiya guye xeellada maxine shuch gidadus. ");
INSERT INTO gmvl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Wonteththa gallas Abrahaamey maalado wonttara dendidi GODAA sinththan kase izi eqqidaso simmi bides. ");
INSERT INTO gmvl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Izi Sodoomenne Gamoora he shoobbaan diza biitta ubbaa duge xeelliza wode wolqqama cuway xuussa tama mala he biittaafe tullu gizayssa be7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Xoossi he shoobban diza katamata dhayssida wode, Abrahaame qoppidi Looxey kase diza katamata dhayssida wode Looxe dhayssafe ashshides. ");
INSERT INTO gmvl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Looxey Zo7aaren de7anaas babbida gishshas ba macca nayta nam7atara zuma bolla kezidi gongolo giddon de7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Issi gallas bayra naya kaaloyo, «Nu aaway cimmides; biitta bolla diza woga mala nunara zin7anaas hayssa biittaan mulekka attumay deenna. ");
INSERT INTO gmvl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Hessa gishshas haa ya; woyne ushshu nu aawa ushshi maththosoos; histtidi izara aqidi ane nu aawappe nuus zereth essoos» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","He gallassa omarsika ba aawaa woyne ushshu ushshidaappe guye bayraya gelada izara zin7adus; iza izara zin7iza wodekka dendiza wodekka izi eribeenna. ");
INSERT INTO gmvl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Wonteththa gallas bayraya kaaloyo, «Siya! Qamma tani nu aawara aqadis; hach omars qasse woyne ushshu ushshiko neni gelada izara aqa; histtidi nuni nu aawappe nuus zereth essoos» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","He gallas qamma qasseka woyne ushshu iza ushshidaappe guye kaaloya gelada izara aqadus; iza izara aqada denda biza wode izi eribeenna. ");
INSERT INTO gmvl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Histtidi Looxe macca nayti nam7atikka ba aawaas qanththatida. ");
INSERT INTO gmvl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Bayraya attuma naa yeladus; sunththaaka Mo7aabe gaada sunththadus; izikka hach gakkanaas Mo7aabetas aawa. ");
INSERT INTO gmvl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Qasse kaaloyakka attuma naa yeladus; sunththaaka Beeni-Aame gaada sunththadus; izikka hach gakkanaas Amoonetas aawa. ");
INSERT INTO gmvl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahaamey Mamireppe dendidi Negebe geetettiza biitta biidi Qaadeesenne Shuura geetettiza katamatappe giddon de7ides; Geraare biittan guuththa wode gam7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Heen Abrahaamey ba machchiyo Saara, «Iza taas michcho» giin Geraare kawo Abimelekkey kiittidi Saara baso efides. ");
INSERT INTO gmvl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Gido attiin Xoossi issi gallassa omars agumon Abimelekkeko yiidi, «Neni ehida maccassay geedon ne hayqqana; iza asa machcho» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Gido attiin Abimelekkey izira aqibeenna; hessa gishshas, «Ta godoo! Neni, tani, ta kawoteththayka nena qohontta dishin nuna coo dhayssanee? ");
INSERT INTO gmvl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Izi, ‹Iza ta michcho› gibeennee? Qasse iza, ‹Izi ta isha› gabeekkee? Tani hayssa tumu wozinappe ooththadis» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Hessafe guye Xoossi agumon izas, «Ee, neni ne wozina geeshshateththan ooththidayssa tani erada neni izo bochchontta malanne ta sinththan nagara ooththontta mala nena tani teqqadis. ");
INSERT INTO gmvl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ha7i hanno maccassayo izi azinaas zaara; gaasoykka izi nabe gidida gishshas izi nees Xoossaa woossiko neni paxana; gido attiin ne izo zaarontta ixxiko neninne nees dizaazi wuri hayqqanayssa tumappe ne era» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimelekkey wonteththa gallas maalado ba kawoteththan diza shuumeta ubbaa xeygidi ha yo7oza ubbaa isttas yootiin istti keehi babbida. ");
INSERT INTO gmvl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Histtiin Abimelekkey Abrahaame xeygidi, «Neni nu bolla ay ooththadii? Neni ta bollanne ta kawoteththaa bolla hayssa mala qoho ehanaas tani nees ay iita miish ooththadinaa? Neni ta bolla oosettanaas bessontta iita ooththadasa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Qasseka Abimelekkey Abrahaame, «Nena hayssa oosisiday aazee?» gi oychchiin, ");
INSERT INTO gmvl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abrahaamey, « ‹Xoossas babbiza issi asikka ha deren baawa; qasseka ta machchey geedon istti tana wodhana› gaada qoppida gishshassa. ");
INSERT INTO gmvl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Izakka ta aawa naa gidida gishshas taas michcho; taas aayi naa gidontta gishshas ta izo machcho ekkadis. ");
INSERT INTO gmvl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Xoossi tana ta aawa keeththafe kessida wode tani izis nuni bida biittan ubbaan neni taas ooththana kiyateththi, ‹Izi taas isha› gaada yoota gadis» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Hessafe guye Abimelekkey dors, miiz, macca aylletanne attuma aylleta ehidi Abrahaames immides; qasse iza machchiyo Saarakka izas zaarides. ");
INSERT INTO gmvl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelekkey, «Hekko ta biittay ne sinththan dees; nena lo7izason da» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Saaraska, «Tani ne ishaas issi shii saqile bira immadis; hayssi hekko nenara dizayta ubbaa sinththan neni xillo gididayssa erisana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","GODAY Abrahaame machcheyo Saara geedon Abimelekke keeththa asa ubbaa yeliza ulo makkarssida gishshas Abrahaamey Xoossaa woossiin Abimelekkey iza machcheyanne iza macca aylleti naa yelana mala Xoossi istta paththides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","GODAY Saara qoppides; kase izis yootida malakka ooththides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saaray shaarada cimateththan Abrahaames Xoossi gida wodey gakkiin attuma naa yeladus. ");
INSERT INTO gmvl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Saaray izas yelida naaza sunththaa Abrahaamey, «Yisaaqa» gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abrahaamey naaza Yisaaqa Xoossi bana azazida mala yelettidaappe osppunththa gallas qaxxarides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Iza naa Yisaaqi izas yelettida wode Abrahaames layththay xeeta. ");
INSERT INTO gmvl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saaray, «Xoossi tana miichchides; qasse hayssa siyizay wuri tanara miiccana» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Qasseka Saaray, «Abrahaames Saaray naa yelananne dhanththana giidi qoppiday oonee? Gidikkoka tani ha7i izas izi cimmida woden naa yeladis» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Guuththa naazi diccidi dhanth duuxxides; Yisaaqi dhanththafe duuxxida gallas Abrahaamey gita diggisa diggisides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Gibxeppe yida Aggaara Abrahaames yelida naazi Isma7eeley Yisaaqa leqqizayssa Saaray be7ada, ");
INSERT INTO gmvl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Abrahaame, «Hanno aylley naazi ta naa Yisaaqara mulekka laattontta gishshas aylleyonne izi naaza kessa goodda» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ha yo7ozi ba naaza bochchiza gishshas Abrahaamey daroppe metotettides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Gido attiin Xoossi Abrahaame, «Ne zereththay Yisaaqa baggara xeygettanayssa gishshas aylley gishshassinne izi naaza gishshas daro metotoppa; Saaray nees yootizayssa ubbaa siya. ");
INSERT INTO gmvl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Qasse tani izi ne zereth gidida gishshas aylley naaza kawoteth histtana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abrahaamey maalado wonttara dendidi guuththa kaththinne koddan haath ekkidi Aggaaro hashen toossidi izi naazakka izis immidi kessi yeddides; iza baada Bersaabehe geetettiza bazzon toylattadus. ");
INSERT INTO gmvl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","16","Haaththayka koddaafe wuriin iza, «Ta naazi hayqqishin uttada ta iza be7ikke» gaada naaza buura garsan woththada 200 wadha gidizaso mala baada heen uttadus; heenkka izakko simma uttada ba qaala dhoqqu histta yeekkadus. ");
INSERT INTO gmvl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Xoossi naaza waaso siyides; saloppe Xoossa kiitanchchay Aggaaro xeygidi, «Aggaaree! Waanadii? Xoossi naazi ichchidason yeekkizayssa siyida gishshas babbofa; ");
INSERT INTO gmvl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","denda eqqa; naaza denththada ne kushen oykka; tani iza gita kawoteth histtana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Xoossi izis haaththa olla bessiin baada koddan haath kunththadus; naazakka ushshadus. ");
INSERT INTO gmvl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Xoossi naazara dees; naazikka diccidi bazzo biittan wondafe dukkiza as gidides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Izi Paaraane bazzon de7ishin iza aaya izas machcho Gibxeppe ekkadus. ");
INSERT INTO gmvl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","He wode Abimelekkey ba wottadarata halaqa Pikoolera Abrahaamekko biidi, «Neni ooththiza ubbaan Xoossi nenara dees. ");
INSERT INTO gmvl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Neni ta bolla woykko ta nayta bolla woykko ta zereththa bolla baleththon gene ooththontta mala ha7i hayssan Xoossa sinththan taas caaqqa; tani nees ne kiyidayssaththo nenikka taassinne neni imaththateththan diza hayssa biittazas lo7o ooththa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abrahaamey, «Tani caaqqays» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","He wode Abrahaamey Abimelekke aylleti ekkida haaththa olla gishshas Abimelekkes magannides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Gido attiin Abimelekkey, «Hessa ooni ooththidaakko tani erikke; nenikka qasse taas yootabeekka; tani hach gakkanaas hessa siyabeekke» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Hessafe guye Abrahaamey dorsatanne miizata ehidi Abimelekkes immiin istti nam7ay caaqettida. ");
INSERT INTO gmvl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abrahaamey meheta giddofe laappun uzzi dorsata shaakkides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelekkey Abrahaame, «Ha neni shaakkida laappun uzzota ays shaakkadii?» gi oychchides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abrahaamey, «Tani hayssa haaththa ollaa bookkidayssas markka gidana mala hayta laappun uzzota taappe ekka» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Heen he nam7u asati caaqettida gishshas he sohoy Bersaabehe geetettides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Bersaabehen caaqo caaqettidayssafe guye Abimelekkeynne iza wottadarata halaqa Pikooley dendidi Filisxeeme biitta simmida. ");
INSERT INTO gmvl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abrahaamey Bersaabehen Tamarssike geetettiza mith tokkidi heen GODAA Mernaa Xoossa xeygidi goynnides. ");
INSERT INTO gmvl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abrahaamey Filisxeeme biittan daro wode imaththateththan de7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Hessafe guye Xoossi Abrahaame paaccides; Xoossi, «Abrahaamee!» gi xeygiin Abrahaamey, «Yee!» gi koyides. ");
INSERT INTO gmvl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Xoossi, «Neni siiqiza ne mexi issi naaza Yisaaqa ekkada Mooriya geetettiza biitta ba; baada heen tani nees bessiza issi zuma bollan iza xuugettiza yarsho ooththada taas yarsha» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Wonteththa gallas Abrahaamey maalado wonttara dendidi hare caanides; ba aylletappe nam7atanne ba naa Yisaaqa banara ekkidi xuuggiza yarshos gidiza mith qeri ekkidi Xoossi izas yootidaso baanaas dendides. ");
INSERT INTO gmvl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Bishe heedzdzanththa gallas Abrahaamey dhoqqu giidi yarsho yarshanasoza haahon be7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abrahaamey ba aylleta, «Intte harezara hayssan diishshite; taninne ta naazi gede biidi Xoossas goynnidi intteko haa simmana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abrahaamey yarsho miththaa denththidi naaza Yisaaqa toossidi baas tamanne shuka mashsha oykkides; istti nam7ay issife bishin, ");
INSERT INTO gmvl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Yisaaqi ba aawa Abrahaame, «Aabboo!» gides. Abrahaameykka, «Yee! Ta naazoo!» giin Yisaaqi, «Tamaynne miththi dees shin yarshettana dorsay awanee?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abrahaameykka, «Ta naazoo! Yarshettana dorsaa Xoossi giigsana» gides; histtiin istti nam7ay issife bida. ");
INSERT INTO gmvl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Istti Xoossi izas yootidaso gakkida wode Abrahaamey yarsho yarshizaso heen giigsidi miththaa korides; ba naa Yisaaqa qachchidi he miththaa bollan shukkanaas ishisides. ");
INSERT INTO gmvl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abrahaamey ba naaza shukkanaas kushe yeddidi mashsha ekkides. ");
INSERT INTO gmvl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Gido attiin GODAA kiitanchchay saloppe iza, «Abrahaamee! Abrahaamee!» gi xeygiin izi, «Yee!» gi koyiin, ");
INSERT INTO gmvl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","«Naaza bolla ne kushe woththofa; iza aykkoka ooththofa; neni ne mexi issi naazakka tana diggontta gishshas neni Xoossas yayyiza as gididayssa tani ha7i eradis» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abrahaamey dhoqqu giidi xeellishin kacey turan oykettida dharsho be7ides; Abrahaamey biidi he dharshoza ekkidi xuugettiza yarsho yarshides. ");
INSERT INTO gmvl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Hessa gishshas Abrahaamey he sohoza, «GODAY immizaso» gi sunththides; hach gakkanaaska he sohozi, «GODAY zuma bollan immana» geetettees. ");
INSERT INTO gmvl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","GODAA kiitanchchay saloppe nam7anththo Abrahaame xeygidi, ");
INSERT INTO gmvl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","«Tani nees tanan caaqqays; neni hayssa ooththida gishshas ne mexi issi naazakka tana diggontta gishshas, ");
INSERT INTO gmvl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","tani nena tumu anjjana; ne zereththaaka tani salo xoolintte malanne abba doonan diza ace mala ooththada darsana; ne zereththati ba morkketa katamata laattana. ");
INSERT INTO gmvl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Neni taas azazettida gishshas ha kawoteththay wuri ne zereththa baggara anjjettana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Hessafe guye Abrahaamey ba aylletakko simmiin istti wuri issife Bersaabehe dendi bida. Abrahaamey Bersaabehen de7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Hessafe simmiin Abrahaames, «Milkay ne isha Naakoores nayta yeladus. ");
INSERT INTO gmvl_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Isttika, bayra naa Uuxe, Uuxe ishata Buuze, ");
INSERT INTO gmvl_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Aaraame aawa Qamu7eele, Keesade, Haazo, Pildaase, Yidilaafe, Baatu7eele geetetteettes. ");
INSERT INTO gmvl_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Heyta he osppun naytakka Milka Abrahaame isha Naakoores yeladus; Baatu7eeli Irbiqa yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Erehimo geetettiza iza garadeya qasse Xebaahe, Gehaame, Tehaashanne Makisa yeladus» gi yootida. ");
INSERT INTO gmvl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saaray 127 layth de7idaappe guye, ");
INSERT INTO gmvl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","iza Kanaane biittan diza (Kebroone geetettiza) Qiriyaate-Arba7e katamaan hayqqiin Abrahaamey Saaras yeekkidessinne kayottides. ");
INSERT INTO gmvl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abrahaamey ba machchey aha achchafe Hiitetakko biidi, ");
INSERT INTO gmvl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Tani intte giddon imaththa; ta machcheyo mooganaas taas intte gadeppe moogoso bayzerketii!» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Hiiteti izas, «Godoo! Nuni nena yootizayssa siya; neni nu giddon gita asa; neni ne machchey aha nu duufoppe nena lo7idaason mooga; neni ne machchey aha mooganaas ba duufo oonikka nena diggenna» gi zaarida. ");
INSERT INTO gmvl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abrahaamey dendi eqqidi Hiiteta halaqata sinththan ziggides. ");
INSERT INTO gmvl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","Izi isttas, «Intte tana, ‹Ne machchey aha mooga› giikko siyite; Xoohaare naa Efroones iza gadeza gaxan diza Makipheele geetettiza gongoloza taas duufos bayzana mala kumeththa waagan nuna zal7iserketii» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","He wode Efrooney katama pengen shiiqida ba asaa Hiiteta giddon dees; hessa gishshas Hiiteti wuri siyishin Abrahaames, ");
INSERT INTO gmvl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«Hessa mala gidenna; ta godoo! Ta yootizayssa siya; tani gadezakka iza giddon diza gongolozakka ta nees hayssa asaa sinththan immadis; nekka ne machchey ahaa mooga» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abrahaamey halaqata sinththan qasseka ziggidi, ");
INSERT INTO gmvl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","asay siyishin Efroone, «Ta yootizayssa siyarkkii! Tani he gadezas waaga qanxxana; ne taappe ekkarkkii! Heen tani ta machchey aha moogana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Efrooney Abrahaames zaaridi, «Ta godoo! Tani yootizayssa siya; gadezi 400 saqile bira xalla kessiza gade gidida gishshas hayssi ne giddoninne ta giddon aykkoka gidenna; ne machchey aha izan mooga» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abrahaamey Hiite asay siyishin Efrooney gida waaga 400 saqile bira Efroones immides. ");
INSERT INTO gmvl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Mamire katamaa achchan Makipheelen diza Efroone gaden diza gongoloynne he gaden diza miththay wuri, ");
INSERT INTO gmvl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","katamaa pengen shiiqida Hiite asaa ubbaa sinththan wogan Abrahaame gade gidides. ");
INSERT INTO gmvl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Hessafe guye Abrahaamey ba machcho Saara ahaa Kanaane biittan (Kebroone geetettiza) Mamire katama achchan diza gongolon moogides. ");
INSERT INTO gmvl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Hessa gishshas he gadezinne gadezan diza gongolozi Hiiteta sinththan wogan Abrahaames gidides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abrahaamey daro cimmides; GODAY iza ubbaankka anjjides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abrahaamey baso as ubbaas halaqatizayssanne izappe garsara iza aqota ubbaa ayssiza aylleza, «Ne kushe ta gulbate bolla woththada caaqqa. ");
INSERT INTO gmvl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Tani istta giddon diza Kanaane macca naytappe ne ta naas machcho oychchontta mala salo sa7a medhdhida Xoossaan ta nees caaqqays; ");
INSERT INTO gmvl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","gido attiin ta yelettida biitta ta dabbotakko baada, ta naa Yisaaqas machcho oychcha» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Iza oosanchchazi, «Maccassaya tanara yaanaas dosontta ixxiko naaza neni yida biittaa guye zaara efoo?» gi oychchides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abrahaamey, «Ta naaza gede guye zaara efontta mala naagetta! ");
INSERT INTO gmvl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","GODAA salo Xoossay tana ta aawa sohoppenne ta yelettida biittaafe kessidayssi taas, ‹Ne zereththas tani hayssa biittaa immana› gi caaqqidayssi neni ta naas heeppe machcho demmana mala izi ba kiitanchcha neeppe sinththe kiittana. ");
INSERT INTO gmvl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Maccassaya nenara guye yaanaas dosontta ixxiko hayssi tani nena caaqeththida caaqoy nees gometoppo; naaza guye mulekka efoppa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Hessa gishshas oosanchchazi ba godaa Abrahaame wodira bolla ba kushe woththi caaqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Hessafe guye oosanchchazi ba godaa gaamellatappe tammata ekkidi ba godaa miishshafekka muuruta muuruta ekkidi bides; Mesphexoomiya geetettiza biittan diza Naakoore katama gakkides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Omarsa wode maccassi haath duuqqanaas yishin katamaappe gaxan haaththa olla achchan ba gaamellata gulbatissidi, ");
INSERT INTO gmvl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","«GODAWU! Ta godaa Abrahaame Xoossoo! Hach tani qoppada yidayssa taas injjesa; qasse ta godaa Abrahaames kiya ooththa. ");
INSERT INTO gmvl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Beya! Tani hayssa pultto haaththa achchan eqqadis; ha katama asaa macca nayti haath duuqqanaas haa yeettes. ");
INSERT INTO gmvl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Tani, ‹Ane otoza ziqqi histtada tana haath ushsha› giza wode, izakka, ‹Hekko uya! Qasse ne gaamellatakka tani ushshana› gizaara hinna ne aylle; Yisaaqas neni dooridaaro gidu; neni ta godaas kiya ooththidayssa tani hessan erana» gi woossides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Buro izi woosa wursontta dishin Irbiqay haaththa oto tookka ekkada puttu gadus; izo Baatu7eeli yelides; Baatu7eeli Milka naa; Milkay Abrahaame isha Naakoore machcho. ");
INSERT INTO gmvl_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Irbiqay daro mala lo7onne gelontta geela7o. Duge wodhdhada pulttozappe ba oto haath kunththada kezadus. ");
INSERT INTO gmvl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","He aylley izikko woxxi biidi izo, «Ne otozappe tana guuththa haath ushsharkkii!» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Iza, «Ero ta godoo! Uya» gadus. Eesotada otoza ba hasheppe woththada geddi histta oykkada iza ushshadus. ");
INSERT INTO gmvl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Iza ushshidayssafe guye, «Ne gaamellatikka alana gakkanaas tani isttas haath duuqqana» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Attida haaththe eeson haaththa gonggen tigada duuqqanaas haaththa ollay dizaso woxxadus; gaamellati wuri alana gakkanaas haaththaa ollafe duuqqa duuqqa ehada haaththa gonggen tigada ushshadus. ");
INSERT INTO gmvl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Izi qoppidi yida qofaa GODAY injjesidaakko erana mala addezi co7u giidi izo xeellees. ");
INSERT INTO gmvl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Gaamellati haath uyi simmiin addezi ichchash giraame bagga gidiza worqqa sagayotanne 100 giraame gidiza nam7u worqqa sagayota, ");
INSERT INTO gmvl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","kessidi izo, «Neni oona naa? Ane taas yoota; ne aawa soon nuus aqizasoy daanee?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Iza, «Tani Milkay Naakoores yelida Baatu7eele naa. ");
INSERT INTO gmvl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Nuson gidiza happaynne bassoy dees; qasse intteska aqizasoy dees» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Addezi gulbatidi GODAAS goynnishe, ");
INSERT INTO gmvl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","«Ba kiyateththaanne ba tumaa ta godaappe haassontta ta godaa Abrahaame GODAA Xoossay galatetto! Tani yishin GODAA Xoossay tana ta godaa dabbotaso kaaleththides» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Naya woxxa baada, ba aayeyson diza asaas hanidayssa yootadus. ");
INSERT INTO gmvl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Irbiqas Laaba geetettiza ishay dees; Laabay kare kezidi haaththa pultto achchan diza addezakko woxxides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Qalabatenne ba michchey kushen diza sagayota be7ida malanne Irbiqay addezi bana gidayssa yootiin siyida mala kezi biidi addezi gaamellatara pulttoza achchan eqqidayssa demmides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Iza, «Haysso GODAY nena anjjidaysso haa ya! Neni hayssan karen ays eqqadii? Tani nees keeththinne gaamellataska soo giigsadis» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Hessa gishshas addezi soo gelides; Laabay gaamellata caanaa birshidi happanne basso gaamellatas yeggides. Izassinne izara diza asatas toho haath ehides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Qumakka iza sinth aaththides; izi, «Tana ehida guddaa inttes yootontta dashe kath miikke» gides. Laabay, «Histtiko yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Hessa gishshas izi, «Tani Abrahaame aylle. ");
INSERT INTO gmvl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","GODAY ta godaa Abrahaame keehi anjjiin izi duretides; dors, miiz, bira, worqqa, attuma aylleta, macca aylleta, gaamellatanne, hareta izas immides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ta godaa machchiya Saaray ba cimateththa layththan izas attuma naa yeliin izi baas dizaaz ubbaa izas immides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ta goday tana hayssaththo caaqisides; ‹Tani diza Kanaane biitta macca naytappe ta naazas machcho oychchofa; ");
INSERT INTO gmvl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ta aawa asaakko ta zereththaako baada ta naazas machcho oychcha› gides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Tanikka ta godawu, ‹Naya tanara yaanaas dosontta ixxikochchii?› gadis. ");
INSERT INTO gmvl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Izi, ‹GODAY tani iza sinththan suure hemettida Xoossi nenara ba kiitanchcha kiittana; neni ta nees ta aawa asaappe, ta zaretappe machcho demmana mala, ne biza oge ubbaa lo7eththana. ");
INSERT INTO gmvl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Neni ta zaretakko biin istti nees izo immontta ixxiko he wode nees caaqoy gomettenna› gides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","«Tani hach hayssa pulttozaakko yida wode GODAWU! Ta godaa Abrahaame Xoossoo! Ne shene gidikko tani biza qofaza injjesa. ");
INSERT INTO gmvl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Be7a; tani ha pulttoza achchan eqqadis; geela7o issiniya haaththe duuqqanaas yiikko tani izo, ‹Tana ne otozappe guuththa haath ushsharkkii!› gaana. ");
INSERT INTO gmvl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Histtiko iza tana, ‹Ero uya› qasse, ‹Ne gaamellataska tani haath duuqqana› gizaara Xoossi ta GODAY nees dooridaaro gidu. ");
INSERT INTO gmvl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","«Tani ta wozinan woossizayssa wursontta dishin Irbiqay ba oto hashen tookka ekkada puttu gadus; duge pulttaako wodhdhada haath duuqqadus; tani izo, ‹Tana haath ushsharkkii!› gadis. ");
INSERT INTO gmvl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","«Iza eeson ba hasheppe otoza woththada, ‹Hekko uya! Qasse tani ne gaamellata ushshana› gadus; tanikka uyadis; qasse ta gaamellatakka ushshadus. ");
INSERT INTO gmvl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","«Tani izo, ‹Neni oona naa?› ga oychchadis. «Iza, ‹Tani Milkay Naakoores yelida Baatu7eele naa› gadus. «Tanikka izi kushen qalabate aaththadis. ");
INSERT INTO gmvl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Hessafe guye tani gulbatada GODAAS goynnadis; tani GODAA ta godaa Abrahaame Xoossa, ta godaa isha nayo iza nees ekkanaas tana likke oge kaaleththidayssa galatays. ");
INSERT INTO gmvl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ha7ikka intte ta godaas kiyana malanne ammanettanaa gidikko taas yootite; hessi hanenna giikkoka taas yootite; hessafe guye tani hananayssa ta erays» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laabaynne Baatu7eeli, «Ha qofazi GODAAPPE yides; nuni nees gede haa gaanaas dandayokko. ");
INSERT INTO gmvl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Irbiqa hanno beya; ekkada ba! GODAY gida mala ne godaa naazas machcho gidu» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Abrahaame aylley istti gizayssa siyida mala biittan gulbatidi Xoossas goynnides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ashkarazi bira alleqonne worqqaa alleqo, may7oka kessidi Irbiqas immides; qasse al7o miishshata izi ishassinne izi aayeys immides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Hessafe guye izikka izara dizayti midanne uyida; histtidi heen aqida; istti maalado wonttara dendiin, «Tana ta godaakko moyzite» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Gido attiin izi ishaynne izi aaya, «Naya issi tammu gallassa mala nunara takku; hessafe guye iza baana» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Izi gidikko, «GODAY tani yidayssa injjesiin intte tana gam7isopite; tani ta godaakko baana mala tana moyzite» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Isttika, «Nayo xeygidi ane nu izo oychchoos» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Hessa gishshas Irbiqa xeygidi, «Ha addezara baanee?» gi oychchida. Izakka, «Ee; tani baana» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Histtiin istti ba michcheyo Irbiqa izo dichchizaarira, Abrahaame ayllezaranne iza asatara moyzida. ");
INSERT INTO gmvl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Istti Irbiqa, «Nu michcheye Irbiqaa! Coratta biitta kuma; ne zereththi ba morkketa katamata laattetto» gi anjjida. ");
INSERT INTO gmvl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Hessafe guye Irbiqaynne izi garadeti dendidi gaamellata toggidi addezara bida; histtiin ayllezi Irbiqa ekkidi bides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","He wode Yisaaqi, «Tana Be7iza De7o Xoossaa Pultto» giza pulttoza mata biidi, Negebe bazzon dees. ");
INSERT INTO gmvl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Issi gallassa omars Yisaaqi ba wozinan qoppidi demba kezidi yuuyishe izi dhoqqu gi xeelliza wode gaamellati yizayta be7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Irbiqaykka dhoqqu histta xeellada Yisaaqa beyada gaamellaa bollafe wodhdhadus. ");
INSERT INTO gmvl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Wodhdhada aylleza, «Nunara gaagganaas sekki dembara haa yiza addey oonee?» gadus. Ashkarazi, «Izi ta godaa deennee» gides; iza ba shaasheza ekkada gullunttadus. ");
INSERT INTO gmvl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Qasse ayllezi ba ooththidayssa ubbaa Yisaaqas yootides. ");
INSERT INTO gmvl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Yisaaqi Irbiqa ba aayey Saara dunkaanen efidi izo machcho ekkides; izakka izas machcho gidadus; histtiin izi izo siiqidessinne ba aayey hayqon kayottizayssafe minettides. ");
INSERT INTO gmvl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Qasse Abrahaamey Keexura geetettiza hara machcho ekkides. ");
INSERT INTO gmvl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Iza Zimiraane, Yoqishaane, Medaane, Midiyaane, Yishibaaqenne Shuha izas yeladus. ");
INSERT INTO gmvl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoqishaaney Saabanne Dadaane yelides; Dadaaney Asooreta, Lexuusetanne Le7aameta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiyaane nayti Eefa, Efere, Heenooke, Abida7enne Elda7e. Hayti wurikka Keexura nayta. ");
INSERT INTO gmvl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrahaamey ba haaro ubbaa Yisaaqa laatissides. ");
INSERT INTO gmvl_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Gido attiin izi buro paxa dishe ba garadetappe yelida naytas baas dizayssafe woytides. Woytidi ba naa Yisaaqappe istta shaakkidi arshey mokkiza baggara diza dere yeddides. ");
INSERT INTO gmvl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahaamey mulera 175 layth de7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abrahaamey daro wode de7idi lo7o cima cimmidi hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Iza nayti Yisaaqinne Isma7eeley iza Makipheele geetettiza gongolo duufon moogida; he gongolozi Mamire achchan Hiite Xoohaare naa Efroone gaden dees. ");
INSERT INTO gmvl_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Hessika Abrahaamey Hiitetappe shammida gade. Abrahaamey ba machchiya Saaray moogettidason moogettides. ");
INSERT INTO gmvl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abrahaamey hayqqidaappe guye Xoossi iza naa Yisaaqa anjjides. He wode Yisaaqi, «Tana Be7iza De7o Xoossaa Pultto» geetettiza pultto achchan dees. ");
INSERT INTO gmvl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Saara aylleya Gibxeppe yida Aggaara Abrahaames yelida naaza Isma7eele yeletay hayssafe kaalli xaafettidayssa. ");
INSERT INTO gmvl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Isma7eele nayti ba sunththaninne ba yeleta maaran haytantta; heytanttika Nebayoote, Qeedaare, Adibi7eele, Mibisaame, ");
INSERT INTO gmvl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishima7e, Duuma, Maase, ");
INSERT INTO gmvl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadaade, Teema, Yixure, Nafishaanenne Qeedima. ");
INSERT INTO gmvl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Isma7eele nayti haytantta; istta sunththi istta mooththaaninne dizason dizason hayssa; isttas 12 zarkke halaqati deettes. ");
INSERT INTO gmvl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isma7eeley mulera 137 layth de7idi hayqqides; hayqqidi ba aawatan gaaggides. ");
INSERT INTO gmvl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Isma7eele zereththi Gibxeppe arshey mokkiza baggan diza Hawilappenne Shuurappe giddon Asoore efiza oge achchan de7ida. Istti ba ishata ubbatara morkketeththan de7ida. ");
INSERT INTO gmvl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abrahaame naa Yisaaqa yeletay hayssafe kaalli xaafettidayssa. Abrahaamey Yisaaqa yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Yisaaqas layththay 40 gidida wode Irbiqa ekkides; iza Mesphexoomiyan diza Aaraame Baatu7eele nayonne Aaraame dere as Laaba michcho. ");
INSERT INTO gmvl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Yisaaqi ba machchiya maynne gidida gishshas izis GODAA woossiin GODAY iza woosaa siyides; histtiin iza machchiya Irbiqaykka qanththatadus. ");
INSERT INTO gmvl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Gido attiin izi ulo giddon diza nayti mentte gidida gishshas issoy issaara sugettida; histtiin iza, «Hayssi ta bolla ays hanizee?» gadus. Hessa gishshas Xoossaa oychchana biin, ");
INSERT INTO gmvl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","GODAY izis, «Ne ulon nam7u kawoteththi dees; qasse ne ulon diza nam7u dere asati issoy issaafe shaakettana; issi dere asay hankkoytappe minnana; qasse bayray kaalozas haarettana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Izis yelo wodey gakkiin iza 2 attuma nayta mentte yeladus. ");
INSERT INTO gmvl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Koyro yelettidayssi aarissa; iza bollayka wuri iske xalla; hessa gishshas istti iza Eesawe gi sunththida. ");
INSERT INTO gmvl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Hessafe guye, iza ishay yelettishe Eesawe toho oykki yelettides; hessa gishshas iza Yaaqoobe gi sunththida. Irbiqay istta yelida wode, Yisaaqas layththay usuppun tammu layththi gidides. ");
INSERT INTO gmvl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Nayti diccida; Eesawey shankka eriza bazzo as gidides; gido attiin Yaaqoobey dunkaanen diza ashke as gidides. ");
INSERT INTO gmvl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Yisaaqi Eesawe siiqides; ays giikko izi shankkatidayssafe maanaas dosides; gido attiin Irbiqay Yaaqoobe siiqadus. ");
INSERT INTO gmvl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Issi wode Yaaqoobey woxe kaththishin Eesawe gafay wodhishin, bazzofe yides. ");
INSERT INTO gmvl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Eesawey Yaaqoobe, «Tana hayssa zo7o woxezappe miza; tana gafay wodhees» gides. (Hessa gishshas qasse iza sunththi Eedoome geetettides.) ");
INSERT INTO gmvl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yaaqoobey iza, «Koyro taas ne bayrateththaa bayza» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Histtiin Eesawey, «Hekko! Ta hayqqana gays hanna ta bayrateththaya tana ay maaddanee?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yaaqoobey zaaridi, «Ane taas koyro neni caaqqa» gides; hizgiin izi caaqqides; ba bayrateththaaka Yaaqoobes bayzides. ");
INSERT INTO gmvl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Hessafe simmiin Yaaqoobey Eesawes buddenanne misira woxe immiin izi midessinne uyides; hessafe guye dendidi bides; Eesawey ba bayrateththaa kadhides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","He biittan kase Abrahaame woden diza koshaappe hara koshay dendides; histtiin Yisaaqi Filisxeeme kawo Abimelekkeko Geraare bides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","GODAY Yisaaqas qonccidi, «Gibxe biitta duge booppa; tani nees yootiza biittan de7a. ");
INSERT INTO gmvl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ha biittan guuththa wode uttaashsha; tani nenara gidana; nena anjjana; ays giikko hayssa biittaa ubbaa tani neessinne ne zereththaas immana; tani ne aawa Abrahaames caaqo gelida ufayssa qaalaa minththana. ");
INSERT INTO gmvl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ne zereththaa tani salo xoolintte mala darsana; hayssa biitta ubbaa ta isttas immana; biitta asay ubbay ne zereththaa baggara anjjettana. ");
INSERT INTO gmvl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Gaasoykka Abrahaamey ta qaalaa siyidi azazettides; ta izas yootidayssa izi ubbaa naagida gishshassa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Hessa gishshas Yisaaqi Geraaren de7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","He biitta asay Irbiqa gishshas denththidi Yisaaqa, «Hanna nees aazee?» gi oychchida. Izikka Irbiqay keeha mala lo7o gidida gishshas, «Tani iza ta machcho giikko ha asay izi geedon tana wodhanakkonne» gi babbida gishshas, «Hanna taas michcho» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Yisaaqi heen daro wode didaappe guye Filisxeeme kawo Abimelekkey maskootera duge xeellidi Yisaaqi ba machcho Irbiqara idimettishe kaa7ishin be7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Hessa gishshas Abimelekkey Yisaaqa xeygisidi, «Hekko iza nees machcho! Neni ays izo ta michcho gadii?» gi oychchides. Izikka, «Iza ta machcho giikko izi gaason asay tana wodhana gaada babbida gishshas gadis» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Histtiin Abimelekkey, «Hayssi neni nu bolla ooththidayssi aazee? Ta asaappe issi asi ne machcheyra aqidaakko nu bolla gome ehashe aggadasa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Hessa gishshas Abimelekkey ba asaa ubbaa, «Ha addeza woykko iza machcho bochchizay oonikka tumu hayqqo» gi azazides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Yisaaqi he biittan kath zeriin GODAY iza anjjida gishshas he layththan xeetu kushe shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Izas aqotay dari dari bida gishshas keehi duretides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Yisaaqas dorsi, miiza wudeynne aylleti keehi darida gishshas Filisxeeme asay iza miqqaynides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Hessa gishshas iza aawa Abrahaame woden iza aawaa aylleti bookkida haaththa olla ubbaa Filisxeeme asay biitta zaaridi kunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","He wode Abimelekkey Yisaaqa, «Nuuppe shaakettada ba; neni nuuppe aadhdha minnadasa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Hizgiin Yisaaqi heeppe dendidi Geraare shoobbaa biidi dunkaane tokkidi heen de7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Abrahaamey paxa dishe bookissida haaththa ollata Abrahaamey hayqqidaappe guye Filisxeeme asay tuccida haaththa ollata Yisaaqi qasseka bookkana mala ooththidi kase iza aaway sunththida sunththaan xeygides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Yisaaqa aylleti shoobban haaththa olla bookkishe bookkiza ollaafe pulttiza haath demmida. ");
INSERT INTO gmvl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Gido attiin Geraaren mehe heemmizayti Yisaaqa mehe heemmizaytara, «Haaththay nuyssa» gi ooyettida. Istti izara palamettida gishshas Yisaaqi he haaththa ollaa, «Eseqe» gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Hessafe guye istti hara haaththa ollaka bookkida; gido attiin istti he haaththa ollaa geedonkka ooyettida; hessa gishshas izi he haaththa ollaa, «Siixina» gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Hessafe guuth haraso aadhdhi hara haaththa olla bookissides; iza gaason oonikka ooyettibeenna; «Xoossi ha7i nuus aassides; nuni ha biittan darana» giidi iza, «Oroboote» gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Hessafe guye Yisaaqi pude Bersaabehe geetettizaso kezides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Hee bida gallas qammara GODAY izas qonccidi, «Tani ne aawa Abrahaame Xoossa; tani nenara diza gishshas babbofa! Tani nena anjjana; ta aylle Abrahaame gishshas ne zereththaa ta darsana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Yisaaqi heen yarshizaso keexxidi GODAA sunth xeygides; heen izi ba dunkaaneza tokkides; qasse heen iza aylleti haaththa olla bookkida. ");
INSERT INTO gmvl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Hessafe guye Abimelekkey bana zoriza Ahuzaatanne ba wottadarata halaqa Pikoole ekkidi Geraareppe Yisaaqakko yides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Yisaaqi isttas, «Intte kase tana ixxidi intte biittafe kessi yeddidi ha7i qasse taakko ay ekkana yidetii?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Istti iza, «GODAY nenara dizayssa tumu nuni qonccen be7idos; hessa gishshas nuussinne nees giddon caaqo qaalay de7ana koshshees goos. ");
INSERT INTO gmvl_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Gido attiin nuni nees kiyateth xalla ooththidi nena saroteththan moyzidos; hessaththoka neni nu bolla iita miish ooththontta mala ane nenara caaqo caaqettoos; ha7i nena GODAY anjjidayssi qonccides» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","He wode Yisaaqi isttas gibira giigsiin midanne uyida. ");
INSERT INTO gmvl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Wonteththa gallas maalado wonttara dendidi istti issoy issaara caaqettida. Yisaaqi istta moyziin istti izappe saron shaakettidi bida. ");
INSERT INTO gmvl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","He gallas Yisaaqa aylleti yiidi ba bookkida haaththa ollaa gishshas, «Nuni haath demmidos» gi izas yootida. ");
INSERT INTO gmvl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Izi he haaththa ollaa, «Saabehe» gi sunththides; hessa gishshas he katamaa sunththi hach gakkanaas Bersaabehe geetettees. ");
INSERT INTO gmvl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Eesawe layththi 40 gidida wode Bi7eere naa Yooditonne Eeloone naa Baasemaato machcho ekkides; istti nam7ayka Hiite biitta asa. ");
INSERT INTO gmvl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Isttika Yisaaqanne Irbiqa mishisishe de7ida. ");
INSERT INTO gmvl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Yisaaqi cimmiin iza ayfey xeelo ixxida wode baas bayra naaza Eesawe xeygidi iza, «Ta naazoo!» gides. Histtiin izi, «Yee!» gi koyides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Izikka, «Beya! Ha7i tani cimadis; tani ayde hayqqanaakkonne ta hayqqana gallas erikke. ");
INSERT INTO gmvl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Hessa gishshas ha7i ne izara shankkatiza toora ekkada bazzo baada do7a shankkatada taas asho ekkada ya. ");
INSERT INTO gmvl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ta dosiza mal7o quma kaththada taas aaththa; hessika tani hayqqanaappe kase nena anjjanaassa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Irbiqay Yisaaqi ba naa Eesawes yootizayssa he wode siyadus; Eesawey do7a shankkatidi ehanaas bazzo biin, ");
INSERT INTO gmvl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Irbiqay ba naaza Yaaqoobe, «Ne aaway ne ishaa Eesawe, ");
INSERT INTO gmvl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‹Do7a shankkata ehada ta maana mala taas mal7o quma kaththa; histtiko ta hayqqontta dashe GODAA sinththan nena anjjana› gishin tani siyadis. ");
INSERT INTO gmvl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ta naazoo! Ha7i tani nena azazizayssa lo7eththada siya. ");
INSERT INTO gmvl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Wudeza gars baada nam7u anqara deysha laaqqata taas ekkada ya; ne ehikko tani ne aawaas mal7o quma izi dosiza mala kaththana. ");
INSERT INTO gmvl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ne aaway miidi hayqqontta dishe miidi nena anjjana mala ehada miza» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Gido attiin Yaaqoobey ba aayo Irbiqas, «Ta isha Eesawe bollan iskey dees; gido attiin ta bollay liiqo. ");
INSERT INTO gmvl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ta aaway tana oykki beykkochii? Tani iza cimmizaa izas misatikko tani anjjo aggada qanggeththa ta bolla ehanaakko» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Iza aayeya iza, «Ta naazoo! He qanggeththay tana gakko. Tani nees yootizayssa ne ooththa; baada deysha laaqqata taas ekka ya» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Izi ehidi ba aayeys immiin aayeya mal7o quma iza aaway dosida mala mal7eththa kaththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Hessafe guye Irbiqay soon ba achchan diza ba bayra naa Eesawe lo7o may7o ehada kaalo naaza Yaaqoobe mayzadus. ");
INSERT INTO gmvl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Qasse he deyshata ite iza kusheninne iza qoodhen mayzadus. ");
INSERT INTO gmvl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Histtada ba kaththida mal7o qumaanne ukeththaa ba naa Yaaqoobe kushen woththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Histtiin izi ba aawaakko bi gelidi, «Ta aawawu!» gides. Izikka, «Yee! Ta naazoo! Neni oonee?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yaaqoobey ba aawaas, «Tani ne bayra naa Eesawe; neni tana azazida mala tani ooththadis; suurada, tani shankkata ehidayssa ma; histtada tana anjja» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Yisaaqi Yaaqoobe, «Ta naazoo! Wostta eeson demmadii?» gi oychchides. Izikka, «GODAY ne Xoossi tana maaddiina» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Yisaaqi Yaaqoobe, «Ta naazoo! Neni tumu ta naa Eesawekkonne tani nena oykka be7anaas ane taakko haa shiiqa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yaaqoobey ba aawa Yisaaqakko shiiqiin oykki be7idi, «Hayssi qaalay Yaaqoobe qaala shin kushey Eesawe kushe» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Iza kushey iza ishaa Eesawe kusheththo iskera diza gishshas erontta iza anjjides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Iza, «Tumu neni ta naa Eesawee?» gi oychchides. Izikka, «Ee tanakko!» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Izikka, «Ta naazoo! Tani neni shankkatidayssa maanaas haa aaththa; maada tani nena anjjana» gides. Yaaqoobey aaththiin izi mides; woyne ushshaaka ehiin uyides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Hessafe guye iza aawa Yisaaqi, «Ta naazoo! Haa shiiqada tana yeera» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yaaqoobey shiiqidi iza yeerides; Yisaaqi iza may7o singi siyidi, «Ta naaza peenoy GODAY anjjida goshsha mala sawees. ");
INSERT INTO gmvl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Xoossi salo iranne sa7a anjjo, kaththinne ooraththa woyne ushshu palahissidi nees immo. ");
INSERT INTO gmvl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kawoteththati nees haarettetto; asi wuri nees gulbato; neni ne ishatas godaa gida; ne aayey zereththi nees gulbato; nena qanggizay qanggettidaaz gido; nena anjjizay anjjettidayssa gido» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Yisaaqi Yaaqoobe anjji wursidaappe guye Yaaqoobey ba aawa Yisaaqa sinththafe kezida mala Eesawey shankkafe puttu gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Izikka qasse mal7o qumaa kaththidi ba aawaas aaththides; aaththidi iza, «Ta aawawu! Suurada hayssa tani shankkatidayssafe ma; histtada tana anjja» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Histtiin aaway Yisaaqi iza, «Ne oonee?» gi oychchides. Izi, «Tani nees bayra naaza Eesawe» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Yisaaqi dagammidi kokkorishe, «Histtiin do7a shankkatidayssa ekkidi taas aaththiday oonee? Tani ha7i neni yaanaappe sinththe maada iza anjjadis; tumukka izi anjjettidayssa gidana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Eesawey ba aawaa qaala siyida mala ba qaalaa dhoqqu histtadi daro camo yeeho yeekkidi ba aawaa, «Tana anjja; ta aawawu tanakka anjja!» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Gido attiin izi, «Ne ishay yiidi tana cimmidi ne anjjo ekkichchides» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Eesawey, «Iza eridi Yaaqoobe gi sunththides; izi tana cimmishin hayssi nam7anththo; izi ta bayrateththaa ekkides; qasse ha7ikka ta anjjo ekkides» gides; qasse zaaridi ba aawaa, «Neni taas anjjofe aykkoka ashshabeekkii?» gi oychchides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Yisaaqi Eesawes, «Tani iza ne bolla godatana mala, iza ishati izas ooththana mala, kaththinne woyne ushshi palahana mala anjjadis; histtiin ta naazoo ta nees ha7i ay ooththana dandayazinaa?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Eesawey ba aawaa, «Ta aawawu nees dizay issi anjjo xallaa? Ta aawawu! Tanakka anjjarkkii!» gides. Hessafe guye Eesawey ba qaala dhoqqu histtidi yeekkides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Iza aawa Yisaaqi zaaridi, «Ne dizasoy ha sa7a dureteththaafe haakkana; salo iraykka nees bukkenna. ");
INSERT INTO gmvl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Neni ne giththa mashshan aqana; neni ne ishaas haarettana; gido attiin neni izara eqettiko iza qambara ne morgefe diggana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Aaway Yaaqoobe anjjida gishshas Eesawey Yaaqoobe keehi ixxides; izi ba wozinara, «Ta aaway hayqqana matides; izi hayqqida mala ta ishaa Yaaqoobe ta wodhana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Giddotiin Irbiqay hayssa ba bayra naaza Eesawe qaala siyida gishshas ba kaalo naa Yaaqoobe xeygisa ehada, «Ne ishay Eesawey nena wodhidi halo kessanaas koyees. ");
INSERT INTO gmvl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ha7ikka ta naazoo, tani nees yootizayssa ooththa. Denda! Dendada Kaaraanen diza ta isha Laabakko baqata! ");
INSERT INTO gmvl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Histtada ne ishaa hanqoy dochchana gakkanaas imaththateththan izara daashsha. ");
INSERT INTO gmvl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ne ishay nees hanqettizayssa izi aggiza wodenne ne iza bolla ooththidayssa izi baliza wode tani kiittada nena heeppe ehisana; tani issi gallas inttefe nam7atappe mela attana mala koykke» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Hessafe guye Irbiqay Yisaaqa, «Eesawey ekkida Hiiteta macca nayta geedon duussay tana iitees; qasse Yaaqoobeykka heyta mala Hiiteta macca naytappe machcho ekkiko tani hekko hayqqanaas koyays» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Hessa gishshas Yisaaqi Yaaqoobe xeygidi, «Kanaane asaa macca naytappe nees machcho ekkofa. ");
INSERT INTO gmvl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Dendada ne aayey aawa Baatu7eelekko, Mesphexoomiya biitta baada heeppe ne aayey isha Laaba macca naytappe issiniyo nees machcho ekka. ");
INSERT INTO gmvl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ubbaa Dandayza Xoossi nena anjjo; izi nees daro nayta immo; nena daro deres aawa histto. ");
INSERT INTO gmvl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Abrahaame anjjida mala nenanne ne zereth Xoossi anjjo; hayssa Abrahaamey immida biittanne nekka imaththateththan de7ida biittaa nees immo» azazides. ");
INSERT INTO gmvl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Histtiin Yisaaqi Yaaqoobe yeddiin Yaaqoobey Mesphexoomiya biitta Laabakko bides. Laabay Yaaqoobenne Eesawe yelida Irbiqas ishanne Aaraame biitta as Baatu7eele naa. ");
INSERT INTO gmvl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Yisaaqi Yaaqoobe anjjidayssa heeppe machcho ekkanaas Mesphexoomiya biitta iza yeddidayssa qasseka izi Yaaqoobe anjjida wode, «Kanaane maccas ekkofa» gi azazidayssa siyides; ");
INSERT INTO gmvl_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yaaqoobeykka ba aawassinne ba aayeys azazettidi Mesphexoomiya biitta bidayssa Eesawey erides. ");
INSERT INTO gmvl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Eesawey iza aawa Yisaaqay Kanaane macca nayta ay mala ixxizaakkonne hessan erides. ");
INSERT INTO gmvl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Hessa gishshas Eesawey Abrahaame naa Isma7eelekko biidi iza nayo Mahilaato ba machchey bolla gujji ekkides. Izakka Nebayoote michcho. ");
INSERT INTO gmvl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yaaqoobey Bersaabeheppe Kaaraane baanaas dendides. ");
INSERT INTO gmvl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Izi issi soo gakkishin arshey wulliin heen aqides; he soon diza shuchchatappe issi shuch ekki borkotidi heen dhiskides. ");
INSERT INTO gmvl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Agumozan biittan eqqidi xeeray pude salo gakkiza yangare be7ides; yangareza bolla Xoossa kiitanchchati duge wodhdhishininne pude kezishin be7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Yangarezas bolla xeeran GODAY eqqidi iza, «Tani GODAA ne aawa Abrahaame Xoossa, Yisaaqa Xoossa. Ha ne ichchida biittaa ta neessinne ne zereththas immana. ");
INSERT INTO gmvl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ne zereththay biitta ace mala darana; isttika oyddu bagga gakkana; biitta bollan diza asi wuri ne baggaranne ne zereththa baggara anjjettana. ");
INSERT INTO gmvl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Tani nenara days; neni bizaso ubbaan tani nena naagana; qasse tani nena ha biitta guye zaarada ehana; tani nees ooththana gidayssa ooththana; nenakka yeggike» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yaaqoobey dhiskofe beeggidi, «Tani erabeekkefe attiin GODAY tumu hayssan dees» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Izi babbidi, «Hayssi ay mala babisizasoo! Hayssi Xoossa Keeththafe attiin haraso deenna; hayssi salo penge» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yaaqoobey wonteththa gallas maalado wonttara dendidi ba borkotida shuchchaa ekkidi tuussa mala essidi Xoossas dummasanaas iza bolla zayte gussides. ");
INSERT INTO gmvl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Yaaqoobey he sohoza Beetele gi sunththides; he katamaya hessafe kase Looza geetettawus. ");
INSERT INTO gmvl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","21","Yaaqoobey, «Ne tanara gidada ta biza ogen ne tana naagikko taas miza qumanne may7o ne immiko ta aawa soo saron ne tana zaarikko neni GODAY ta Xoossa gidana. ");
INSERT INTO gmvl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Tani tuussa mala essida ha shuchchay Xoossa keeth gidana; neni taas immiza ubbaafe tammaafe issi kushe tani nees immana» gi adinettides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Hessafe guye Yaaqoobey dendi biidi arshey mokkiza baggara diza asata dere gakkides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Histtidi issi demban haaththa ollay dizayssa be7ides; heedzdzu cuga dorsi qasse he haaththa olla achchan ichchides; ays giikko wudey wuri haath uyizay he ollazappe; he haaththa ollaa doona tuchcha shuchchayka gita. ");
INSERT INTO gmvl_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Dorsa wudey wuri heen shiiqida wode wudeza heemmizayti haaththa olla doonappe he shuchchaa genderisidi dorsaa ushsheettes. Ushshidi he shuchchaa haaththa ollaan zaaridi tucceettes. ");
INSERT INTO gmvl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yaaqoobey isttas, «Haytoo! Intte awappe yidetii?» gi oychchides. Isttika, «Nuni Kaaraaneppe yidos» gi yootiin, ");
INSERT INTO gmvl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","izi, «Naakoores naaza naa Laaba ereetii?» gides. Isttika, «Ee, iza nu eroos» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yaaqoobey isttas, «Izi lo7o dizee?» gi oychchiin, «Ee, lo7okko; iza naa Eraheelo dors ekka yizaaro hanno beya» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Histtiin Yaaqoobey isttas, «Be7ite! Arshey ha7i dhoqqan dees; mehe soo shiishshiza wodey buro gakkibeenna; dorsata haath ushshidi efi heemmiishshite» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Gido attiin isttas, «Mehey wuri shiiqana gakkanaas, shuchchaa haaththa ollaza doonappe genderisana gakkanaas nuni ushshanaas dandayokko; hessafe guye nuni mehaa ushshana» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Izi buro haasayan dishin dorsata heemmizay izo gidida gishshas Laaba naya Eraheela ba aawaa dorsata laagga ekkada gakka wodhadus. ");
INSERT INTO gmvl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yaaqoobey ba aayey isha Laaba naa Eraheeli dorsata be7ida wode biidi ollaa doonappe shuchchaa genderisidi ba aayey ishaa dorsata haath ushshides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yaaqoobey Eraheelo yeeridi ufayssafe dendidayssan ba qaala dhoqqisidi yeekkides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yaaqoobey izis aawa dabbonne Irbiqa naa gididayssa Eraheelis yootiin iza woxxa baada ba aawaas yootadus. ");
INSERT INTO gmvl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laabay ba michchey naa Yaaqoobe wore siyida mala izara gaagganaas woxxides; woxxi gakkidi iza idimmi yeeri ekkidi ba soo efides; heen Yaaqoobey ba hanidayssa ubbaa Laabas yootides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laabay iza, «Neni tumu ta ashonne ta suuththa» gides. Yaaqoobey izara issi agina kumeth uttides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Hessafe guye Laabay iza, «Neni taas dabbo gidida gishshas taas coo mela ooththanee? Ane nees ay qanxxanaas bessizaakko taas yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laabas nam7u macca nayti deettes; bayray sunththi Liya, kaaloya Eraheelo. ");
INSERT INTO gmvl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Liya ayfey shola; Eraheeli ayfey gidikko lo7o. ");
INSERT INTO gmvl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yaaqoobey Eraheelo siiqida gishshas, «Tani nees kaalo nayo Eraheeli gishshas nees laappun layth ooththana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laabay, «Izo hara asas immanaappe nees immizayssi lo7o; neni tanara hayssan deya» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Hessa gishshas Yaaqoobey Eraheelo ekkanaas laappun layth ooththides; gido attiin izi izo siiqiza gishshas izas wodezi keehi qaanth misatides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Hessafe guye Yaaqoobey Laaba, «Ta machcho taas imma; ta wodey wurides; tani izo ekkana koyays» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Hessa gishshas Laabay heen diza ubba asaa xeygi shiishshidi, bullachcha kessides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Gido attiin gadey qammiin izi ba naa Liya efidi Yaaqoobes immides; Yaaqoobeykka izo ekkides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Qasse Laabay ba aylleyo Zilfo ba naa Liyas aylle gidana mala immides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Gadey wontiin xeelliza wode hekko Liya gidadus! Histtiin Yaaqoobey Laaba, «Hayssi neni ta bolla ooththidayssi aazee? Tani nees ooththiday Eraheeli gishshas deennee? Tana ays cimmadii?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laabay iza, «Nu biittan bayraya dishin kaaloyo azinaas immizayssi woga deenna. ");
INSERT INTO gmvl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","He mishirateththa saamintta ubbaa wursa; qasse kaalotizaarokka nuni nees immana; hessafe guye hara laappun layth taas ooththaasa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yaaqoobey hessaththo hanidi he saaminttaa wursides; hessafe guye Laabay ba nayo Eraheelo izas immides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Qasse Laabay ba aylleyo Biliha ba naa Eraheelis aylle gidana mala immides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yaaqoobey Eraheelokka ekkides; Eraheelo Liyappe aaththi siiqides; hara laappun layth Laabas ooththides. ");
INSERT INTO gmvl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yaaqoobey Liya Eraheeli mala siiqonttayssa be7idi GODAY izis yeliza uloza doydes; gido attiin Eraheelis nay baa. ");
INSERT INTO gmvl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Liyay shaarada attuma naa yeladus; iza sunththaaka Oroobeele ga sunththadus; ays giikko iza, «GODAY ta meto be7ides; ha7i tumu tana ta azinay siiqana» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Iza qasseka shaarada ha7ikka attuma naa yeladus; iza, «GODAY tani dosettonttayssa be7ida gishshas taas hayssaka gujjides» gaada iza Simoona ga sunththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Iza qasseka shaarada attuma naa yeladus; iza, «Tani izas heedzdzu attuma nayta yelida gishshas ta azinay ba wozina taakko zaarana» gaada iza Lewe ga sunththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Iza qasseka qanththatada attuma naa yelada iza, «Hi7a tani GODAA galatana» gadus; hessa gishshas iza Yuhuda ga sunththadus; hessafe guye yelo essadus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Eraheela Yaaqoobes nay izippe yelettonttayssa erada ba michchey bolla qanaatadus; hessa gishshas iza Yaaqoobe, «Taas naa imma; ixxis giikko ta hayqqana» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yaaqoobey Eraheeli bolla hanqettidi, «Tana nees yelo digganaas Xoossa gadii?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Izakka, «Ta aylleyo Biliha hinno be7a; iza ta gishshas yelana mala neni izo ekka; histtiko izi baggara tanikka naa aayo gidana» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Eraheela ba aylleyo Biliha machcho histti ekkana mala izas immiin Yaaqoobey izo ekkides. ");
INSERT INTO gmvl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Biliha shaarada attuma naa Yaaqoobes yeladus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Histtiin Eraheela, «Xoossi taas pirdides; ta woosaakka siyidi taas attuma naa immides» gadus; hessa gishshas yelettida naaza, «Daane» ga sunththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Eraheeli aylleya Biliha qasseka shaarada Yaaqoobes nam7anththo attuma naa yeladus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Eraheelakka, «Tani ta michcheyra wolqqama baaxe baaxetada xoonadis» gashe naaza Niftaaleme ga sunththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Liyay baas yeloy eqqidayssa beyada ba aylleyo Zilfo efada Yaaqoobes machcho histta immadus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Liya aylle Zilfa Yaaqoobes attuma naa yeladus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Liyaykka, «Hayssi ay mala lo7o qaadaa!» gashe naaza Gaade gaada sunththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Liya aylleya Zilfay Yaaqoobes nam7anththo attuma naa yeladus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Liyaykka, «Tani keeha ufayettadis! Maccassayka tana ufayettizaaro gaana» gadus; hessa gishshas iza naaza Aaseere ga sunththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Gistte maxa aginan Oroobeeley gade giddo biidi inkoye teera demmidi ba aayo Liyas ehides; Eraheela Liya, «Ne nay ehida inkoyezappe ane taas imma» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Gido attiin, «Ne ta azinaza taappe woththa ekkidayssi gidontta ixxiin qasse ta naaza inkoyeza ekkanee?» gadus. Eraheelakka, «Histtiko ne naaza inkoyeza gishshas Yaaqoobey hachcha qamma nenara aqo» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","He gallassa omars Yaaqoobey oososoppe simmishin Liyay iza mokkanaas kezada, «Neni tanara aqana koshshees; ays giikko tani ta naa inkoyezan nena kiras ekkaychchadis» giin izi he gallassa omars izira aqides. ");
INSERT INTO gmvl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Xoossi Liya woosa siyides; hessa gishshas iza qanththatada ichchashanththo attuma naa Yaaqoobes yeladus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Liyaykka, «Tani ta aylleyo ta azinaas immida gishshas Xoossi hessa kira taas qanxxides» gashe naaza Yisakoore gaada sunththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Liyay qasseka shaarada usuppunththa attuma naa Yaaqoobes yeladus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Liyay, «Xoossi taas al7o imota immides; tani ta azinaas usuppun nayta yelida gishshas ha7i izi tana bonchchana» gadus. Hessa gishshas iza naaza Zaabiloone ga sunththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Hessafe guye issi macca naa yelada izo Diina ga sunththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Xoossi Eraheelo qoppides; izi woosaakka siyidi izis yeliza ulo doydes. ");
INSERT INTO gmvl_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Izakka shaarada attuma naa yeladus; «Xoossi ta yeella taappe denththides; ");
INSERT INTO gmvl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","GODAY taas hara attuma naakka gujjerennee!» gashe naaza Yooseefe ga sunththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Eraheela Yooseefe yelidaappe guye Yaaqoobey Laaba, «Tani ta aawa biitta simmana mala tana moyza. ");
INSERT INTO gmvl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Tani istta gishshas nees ooththida ta machchetanne ta nayta taas imma; tani baana; ays giikko tani nees ay mala ooththidaakko ne eraasa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Qasse Laabay izas, «Tani nees issi miish yootays; GODAY ne geedon tana anjjidayssa ta beyadis. ");
INSERT INTO gmvl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ne ekkana damoza taas yoota; tani nees iza qanxxana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yaaqoobey, «Tani nees wostta ooththidaakko ne meheykka waani yelettidaakko neni eraasa. ");
INSERT INTO gmvl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Tani yaanaappe kase nees diza guuththay ha7i keehi darides; ta aadhdhida ubbason GODAY nena anjjides; gido attiin ha7i tani taso asaas ayde ooththoo?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laabay, «Tani nees ay immoo?» gi iza oychchiin, Yaaqoobey, «Taas aykkoka immofa; gido attiin neni taas issi miish ooththiko tani ne wudeza qasseka heemmananne naagana. ");
INSERT INTO gmvl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Tani hach ne mehe ubbaa giddora aadhdhana; heen ne dorsaafe masara woykko puncara ubbaa, dorsa laaqqa kareththata ubbaa, deyshafe puncaranne masara gididayta ubbaa ta shaakkana; heytantti ta damoza gidetto. ");
INSERT INTO gmvl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Hessa gishshas ta xilloteththi neni taas qanxxida damozaa taybanaas sinththafe ne yiza wode erettana; ta deyshaafe xalaqa gidonttay woykko kareth gidontta issi laaqqay ta achchan beettiko kaysotida mala qoodetto» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laabay, «Ne gida mala gido» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","He gallassika Laabay xalaqa gidida orgeta ubbaa, xalaqa gidida macca deyshetanne kareththa dorsa laaqqata ubbaa kessidi heemmana mala ba attuma naytas immides. ");
INSERT INTO gmvl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Histtidi he mehezara heedzdzu gallassa oge Yaaqoobeppe haakki bides; gido attiin Yaaqoobey attida Laaba meheta heenth gelides. ");
INSERT INTO gmvl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yaaqoobey miththafe qaye guufe kessidi baggaa poqqidi baggaa poqqontta aggidi guufeza baggaa kareth, baggaa booth histtidi warardes. ");
INSERT INTO gmvl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Mehey haaththe uyana yiza ubba wode meheti haath uyiza gongge giddon guufeta woththides; meheteth kezida meheti haath uyanaas yiza wode, ");
INSERT INTO gmvl_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","he guufeta sinththan mehettida; isttika masara, xalaqanne battaka laaqqata yelida. ");
INSERT INTO gmvl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yaaqoobey laaqqata mehetappe shaakkidi dumma woththides; attida meheta masaranne xalaqa gididayta Laaba mehe sinth zaarides; hessaththo Yaaqoobey ba mehe Laaba mehera walakettontta mala dumma shaakki woththides. ");
INSERT INTO gmvl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Gooba mino macca dorsatinne deyshati meheteth keziza wode ayde gidiinkka istti he guufeta achchan mehettana mala Yaaqoobey he guufeta haaththa gongge giddon meheta sinththan woththides. ");
INSERT INTO gmvl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Guufeza laafa meheta sinththan woththenna; hessa gishshas laafa laafa meheti Laabas gidiin goobizayti Yaaqoobes gidida. ");
INSERT INTO gmvl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Hessaththo hanidi Yaaqoobey keehi duretidi, daro mehe wude, macca aylletanne attuma aylleta, daro gaamellatanne hareta haarides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Laaba attuma nayti ba giddon, «Yaaqoobey nu aawa haaro ubbaa ekkides; hayssi ubbay izi shiishshida aqotay nu aawappe beettidaaza» gi haasayshin Yaaqoobey siyides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yaaqoobey Laaba ayfesoy izas kase mala gidonttayssa be7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","He wode GODAY Yaaqoobe, «Neni ne aawata biitta ne dabbotakko guye simma; tani nenara gidana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Hessa gishshas Yaaqoobey Eraheelonne Liya ba mehey dizaso yaana mala kiittidi xeygisides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Izi isttas, «Intte aawa ayfesoy taas kaseyssa mala gidonttayssa tani be7adis; gido attiin ta aawa Xoossi tanara dees. ");
INSERT INTO gmvl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Tani ta kumeththa wolqqafe intte aawaas ooththidayssa intte ereeta. ");
INSERT INTO gmvl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Gido attiin intte aaway tana cimmidi ta damoza tammuto laammi laammi yeggides; gidikkoka izi tana qohontta mala Xoossi iza diggides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Izi, ‹Masara dorsatinne deyshati ne damoza gidana› giin wude meheti wuri masara xalla yelida; qasse izi, ‹Xalaqa dorsatinne deyshatikka ne damoza gidana› giin mehey wuri xalaqa yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Xoossi hayssaththo intte aawappe woththi ekkidi intte aawa mehe taas immides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","«Meheti meheteth keziza aginan agumora meheta mehessiza deysha orgeti masara, xalaqanne battaka gididayssa beyadis. ");
INSERT INTO gmvl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Xoossa kiitanchchay agumon tana, ‹Yaaqoobee!› gi xeygiin tani, ‹Yee!› gaada koyadis. ");
INSERT INTO gmvl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Izikka tana, ‹Dhoqqu gaada meheta mehetissiza deysha orgeti wuri masaranne xalaqa gididayssa beya; gaasoykka Laabay ne bolla ooththizayssa ubbaa ta beyadis. ");
INSERT INTO gmvl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Neni shuch essada zayte iza bolla tigada adinida Beetele Xoossi tana; ha7i dendada ha biittafe kezada elelada guye ne yelettida biitta simma› » gides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Hessafe guye Eraheelanne Liyay izas, «Nu aawayssafe nuna gakkanay aazee? ");
INSERT INTO gmvl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Izi nuna allaga mala xeellees deennee? Izi nuna bayzi ekkides; bayzidi ekkida mishakka baas mi dhayssides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Xoossi nu aawappe woththi ekkidi nees immida mehey wuri tumukka nuussanne nu naytayssa; hessa gishshas Xoossi nees yootidayssa ubbaa ooththa» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Histtiin Yaaqoobey Kanaane biittan diza ba aawa Yisaaqakko baanaas dendides; izi ba naytanne ba machcheta gaamella togisides; baas diza mehe ubbaa sinththe aaththi laaggidi Mesphexoomiyan dishe izi shiishshida haaro ubbaa ekki bides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laabay ba dorsata iskeza qanxxanaas bichchidaashe Eraheela ba aawa eeqa misleta kaysadus. ");
INSERT INTO gmvl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yaaqoobeykka ba baqatizayssa Aaraame dere asi gidida Laabas yootontta baleththi bides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Izi baas dizaaz ubbaa shiishshi ekki baqatidi Efiraaxise Shaafaa pinnidi Gala7aade geetettiza gezze biitta bides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Yaaqoobey baqati bidayssa Laabay heedzdzanththo gallas siyides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ba dabbota banara ekkidi laappun gallassa oge Yaaqoobe guye kaallidi kaallidi Gala7aade geetettiza gezze biittan iza gakki oykkides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","He gallassa omars Xoossi Aaraame Laabakko agumora yiidi, «Neni Yaaqoobe bolla iita gidiin kiya gidiinkka haasayontta mala naageeta!» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laabay gakkiza wode Yaaqoobey Gala7aade gezzen dunkaani uttides; qasse Laabaynne iza dabboti heen dunkaane tokkida. ");
INSERT INTO gmvl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Hessafe guye Laabay Yaaqoobe, «Neni hayssaththo ays ooththadii? Neni tana cimmada ta macca nayta olan di7ettida mala laaggada kessadasa. ");
INSERT INTO gmvl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Neni ays qotan taappe kessa ekkada tana cimmadii? Tani karabeninne diiththan ufayssa yeththan nena moyzana mala taas ays yootabeekkii? ");
INSERT INTO gmvl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Neni haray atto ta nayta naytanne ta macca nayta tani yeera ekkontta mala diggadasa; neni balla ooso ooththadasa. ");
INSERT INTO gmvl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Tani nena qohanaas taas wolqqay dees; gido attiin ne aawa Xoossi qamma omars tana, ‹Yaaqoobe bolla iita gidiin kiya gidiinkka issi miish ne haasayontta mala naagetta!› giidi taas yootides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ha7i gidikkoka neni ne aawa soo baanaas keeha laamotida gishshas ke7adasa; gido attiin taso eeqa misleta aazas kaysadii?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yaaqoobey Laaba, «Neni ne nayta taappe wolqqan woththa ekkanaakko gaada babbida gishshas hayssaththo ooththadis. ");
INSERT INTO gmvl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Gido attiin ne misleta oykkida as oonakka neni demmiko he uray hayqqo! Nees gidida miishshi ta achchan beettiko nu dabboti beyishin koyada demmiko nees ekka» gides; gaasoykka Yaaqoobey Eraheela eeqa misleta kaysidayssa eribeenna. ");
INSERT INTO gmvl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Hessa gishshas Laabay Yaaqoobe dunkaane giddo, Liya dunkaane giddonne nam7u aylleta dunkaane giddo gelides; gido attiin aykkoka demmibeenna; Liya dunkaanaappe kezidi Eraheeli dunkaane giddo gelides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Eraheela ba aawa eeqa misleta ekkada gaamella koora garsan qottada, iza bolla uttadus. Laabay dunkaanan dizayssa ubbaa pilggidi koyides; gido attiin aykkoka demmibeenna. ");
INSERT INTO gmvl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Eraheela ba aawa, «Ta aawawu! Tana hanqettofa; tani nees eqqana dandaykke; taas maccassa wogay yides» gadus. Izi ubbason koyides; gido attiin eeqa misleta demmibeenna. ");
INSERT INTO gmvl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yaaqoobey Laaba bolla hanqettidi, «Tani ay mooradinaa? Hessa sire ne tana kaallanaas tani ooththida nagaray aazee? ");
INSERT INTO gmvl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ha7i neni ta miishshaa ubbaa pilggada koyadasashin ay demmadii? Istti neeppenne taappe ooni wordoko pirdana mala ha yo7oza ta dabbota sinththaninne ne dabbota sinththan woththa. ");
INSERT INTO gmvl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","«Tani nenara nam7u tammu layth kumeth de7adis; ne dorsinne deysha gidiin awucaybeenna; woykko ne meheppe galth mabeekke. ");
INSERT INTO gmvl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Do7ay wodhidayssaka ubbaa ta bolla qoodadis attiin nees ehabeekke; gallas gidiin omars kaysoy ekkidayssa tana qanxxisadasa. ");
INSERT INTO gmvl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Gallas awa seelay, omars kenchchoy tana qohides; dhiskoyka ta ayfeppe dhaydes. ");
INSERT INTO gmvl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Tani hayssaththo ne soon nam7u tammu layth de7adis; ne macca naa nam7ata gishshas 14 layth, attida usuppun layth ne immida meheta gishshas nees ooththashe de7adis; gido attiin neni ta damoza tammuto laamma laamma yeggadasa. ");
INSERT INTO gmvl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ta aawati Abrahaameynne Yisaaqi goynnida Xoossi tanara gidonttaakko ne tana mela kushe kessa yeddanakoshin Xoossi ta waayenne ta daabura be7idi qamma omars nena hanqides» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laabay Yaaqoobe, «Ne machcheti ta macca nayta; istti yelida naytikka ta nayta; mehezikka ta mehe; nees dizaazi wurikka tayssa; hach ha macca nayta tayta bollanne istti yelida nayta bolla ay ooththanaas dandayazinaa? ");
INSERT INTO gmvl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ane ha7i haa ya; neninne tani caaqettoos; hayssi neeppenne taappe giddon markka gido» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Hessa gishshas Yaaqoobey issi shuch ekkidi tuussa mala essides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Izi ba dabbotakka, «Shuch shiishshite» gides; histtiin istti shuch shiishshidi korida; he shuchcha koraa achchanka kath mida. ");
INSERT INTO gmvl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laabay he shuchcha koraa, Yigaar-Sahaaduta gi sunththides; qasse Yaaqoobey iza Gal7eede gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laabay, «Ha keelay neeppenne taappe giddon hach markka» gides; hessa gishshas iza sunththay Gal7eede geetettides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Qasse izi he shuchcha tuussaa Mixiphpha gi sunththides; ays giikko Laabay, «Nuni issay issaafe haakkidi diza wode GODAY ne giddoninne ta giddon gididi naago. ");
INSERT INTO gmvl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Neni ta macca nayta qohiko, woykko neni ta macca nayta bolla hara maccassata ekkiko nunara ha7i oonikka baynda aggikokka ne giddoninne ta giddon Xoossay markka gididayssa era» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laabay qasseka Yaaqoobes, «Keelettida shuchchaa hayssa beya; qasse tani neeppenne taappe giddon essida shuchcha tuussa hayssa beya. ");
INSERT INTO gmvl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Tani ne bolla gene ooththanaas ha keelappe neekko kanththontta mala nenikka ta bolla gene ooththanaas ha keelappenne ha shuchchaa tuussaafe kanththontta mala ha shuchcha koraynne ha shuchcha tuussay markka. ");
INSERT INTO gmvl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abrahaame Xoossi, Naakoore Xoossi, istta aawa Xoossi, izi nu giddon pirdo» gides. Yaaqoobey ba aawa Yisaaqi goynnida Xoossa sunththan caaqqides. ");
INSERT INTO gmvl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yaaqoobey zumaa bollan yarsho yarshides; ba dabbotakka quma maanaas xeygides; istti miidi heen zuma bollan aqida. ");
INSERT INTO gmvl_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Wonteththa gallas maalado wonttara Laabay dendidi ba nayta naytanne ba macca nayta anjjidinne yeeri ekkidi guye ba soo simmides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yaaqoobey dendidi sinththe bishin Xoossa kiitanchchati izara gaaggida. ");
INSERT INTO gmvl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yaaqoobey istta be7idi, «Hayssi Xoossi aqizaso» gishe he sohoza Mahanayme gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yaaqoobey Seyre geetettizason Eedoome biittan diza ba isha Eesawekko baappe sinththe kiita yeddides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Izi istta bolla kiita, «Intte ta godaa Eesawes gaana miishshi hayssa; ‹Ne aylle Yaaqoobey, tani Laaba achchan hanno gakkanaas gam7adis. ");
INSERT INTO gmvl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Taas miizi, harey, dorsi, deyshi, adde aylletinne macca aylleti deettes; ha7i tani ha kiitaa ta godaas kiittizay taas lo7o qoppana mala ga kiittadis› gides» gi kiittides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kiitettidayti Yaaqoobekko simmidi izas, «Nuni ne isha Eesawekko bidos; ha7i izi qasse nenara gaagganaas yees; izarakka 400 asi dees» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yaaqoobey babbidi shoobbides; banara diza asaa 2 cugan cugan shaakkidi ba dorsaa, deyshaa, miizaanne gaamellaa 2 cugan cugan shaakkides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Izi, «Eesawey yiidi issi cuga oli ekkizaa gidikko attida cugay kessi ekkanaakko» gi qoppides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","He wode Yaaqoobey, «Abeet Xoossawu! Ta aawa Abrahaame Xoossawu, ta aawa Yisaaqa Xoossawu, tana, ‹Ne dabbotakko ne dere simma; tani nees lo7o ooththana› gidaso, ");
INSERT INTO gmvl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","neni ne ayllezas ooththida kiyateththaassinne ammaneteththaas ubbaas tani bessontta asa. Tani haa Yordaanoose shaafa pinniza wode taas issi guufeyppe attiin kushen haray deenna; gido attiin ha7i tani nam7u cuga dere gidadis. ");
INSERT INTO gmvl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ta nena woossays; ta ishaa Eesawe kusheppe tana ashsha; gaasoykka izi yiidi tananne ta nayta aayeta istta naytara dhayssanaakko gaada babbadis. ");
INSERT INTO gmvl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Gido attiin neni tana, ‹Tani nees tumu lo7o ooththana; tani ne zereththay taybettanaas dandayettontta abba shaamintta mala ooththana› gidayssa qoppa» gi woossides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","He gallassa omars izi heen aqiday baas diza ubbaafe ba isha Eesawes immanaassa. ");
INSERT INTO gmvl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","15","Izikka 200 macca deyshatanne nam7u tammu deysha orgeta, 200 macca dorsatanne 200 dharshota, 300 dhanththiza gaamellatanne istta maratara, 40 miizata, 10 korma boorata, 20 macca haretanne 10 wodalla hareta qori kessides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Heyta istti wuden wuden shaakki shaakki ba aylleta kushen woththidi aylletas, «Taappe sinththati biite; wudeza issaa issaafe haassi haassi laaggite» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ubbaafe sinththan bizayssa, «Ta isha Eesawey nenara gaaggidi nena, ‹Ne oonee? Awa bay? Ne sinththan diza mehey wuri oonassee?› gi oychchizaa gidikko, ");
INSERT INTO gmvl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","‹Neni izas hayti ne aylle Yaaqoobessa; izi hayta yeddidaykka ta godaa Eesawes immanaassa; qasse izikka nuuppe guyera yees› ga» gi azazides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Qasseka nam7anththonne heedzdzanththo cugatassinne wudeza kaalliza hara ubbatas hayssaththo, «Intte Eesawera gaaggiza wode hayssaththoka geeta; ");
INSERT INTO gmvl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‹Ne aylle Yaaqoobey nuuppe guyera yees› gontta aggofte» gides; izi hessaththo giday, «Tani taappe sinththe immanaas kiittidayssan iza hanqo doshisana; hessafe guye tani izara gaaggiza wode izi tana mokki ekkanaakko oonee erizay» gi qoppides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Hessa gishshas ba immizayssa baappe sinththasi yeddides; gido attiin izi ba hu7es he gallassa omars heen ba dizason aqides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","He gallassa omars Yaaqoobey dendidi, ba nam7u machcheta, ba nam7u aylleta ba nayta tammanne issineta ekkidi Yaabooqe geetettiza shaafa gakkides; izi isttanne baas dizayta ubbaa pinththi yeddides; ");
INSERT INTO gmvl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Gido attiin Yaaqoobey barkka heen attides. He wode issi asi gadey wonttana gakkanaas izara baaxetides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","He addezi iza xoonanaas dandayettonttayssa be7idi Yaaqoobes wodira bochchiin iza wodiray doccides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Histtiin he addezi iza, «Gadey wonttana gees tana yedda» gides. Gido attiin Yaaqoobey iza, «Ne tana anjjontta yeddike» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Addezikka iza, «Ne sunththi oonee?» gi oychchiin izi, «Yaaqoobe» gi zaarides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Addezikka iza, «Hayssafe sinththan ne sunththi Isra7eele geetetto attiin Yaaqoobe geetettofo; ays giikko neni Xoossaranne asara baaxetada xoonadasa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yaaqoobey iza, «Ne sunththi oonee?» gi oychchides. Addezikka, «Neni ta sunththu ays oychchay?» gi simmidi iza heen anjjides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Hessa gishshas Yaaqoobey he sohoza Phin7eele gi sunththides; ays giikko izi, «Tani Xoossaa ta ayfera be7ada hayqqontta attadis» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Izi Panu7eeleppe dendiza wode iza bolla xalqqey kezides; izi ba wodiraa gishshas wobbides. ");
INSERT INTO gmvl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Yaaqoobe wodiray deshettida gishshas Isra7eele asay hach gakkanaaska geda giddon diza paashsha asho mi erettenna. ");
INSERT INTO gmvl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yaaqoobey dhoqqu gi xeellidi Eesawey 400 as banara ekki yizayssa be7ides; hessa gishshas nayta Liyas, Eraheelissinne nam7u aylletas shaakki shaakki immides. ");
INSERT INTO gmvl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ashkaratanne istta nayta sinththan Liyanne izi nayta isttafe guyen Eraheelonne Yooseefe wurseththan woththides. ");
INSERT INTO gmvl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Gido attiin izi ba baggara ubbaafe sinththe aadhdhidi ba ishaakko matida wode laappunto ziggides. ");
INSERT INTO gmvl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Eesawey gidikko izara gaagganaas woxxidi iza qoodhe bolla xaaxettidi yeerides; nam7atikka yeekkida. ");
INSERT INTO gmvl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Hessafe guye Eesawey dhoqqu gi xeellidi maccassatanne nayta be7idi, «Ha nenara dizayti oonanttee?» gi oychchides. Yaaqoobey izas, «Hayti Xoossi ne aylles taas ba kiyateththan immida nayta» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Hessafe guye aylleti ba naytara shiiqidi iza sinththan ziggida. ");
INSERT INTO gmvl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Kaallidi Liyaynne izi nayti yiidi ziggida; wurseththan Yooseefeynne Eraheela yiidi ziggida. ");
INSERT INTO gmvl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Eesawey, «Sinththan tanara gaaggida mehey wuri aaza mehee?» gi oychchides. Izikka, «Ta godoo! Hayssi ne tana ufayssan mokka ekkanaassa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Eesawey, «Ta ishoo! Taas daro haaroy dees; ne miishshi nees gido» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yaaqoobey, «Akkay, ha7i ne tana mokka ekkanaa gidikko ta nees immizayssa ekka; ne tana siiqon mokka ekkishin ta be7idayssa Xoossa ayfeso be7ida mala qoodays. ");
INSERT INTO gmvl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Xoossi ba kiyateththan ubbaa kunththi taas immida gishshas koshshizaazi ubbay taas dees; ta nees immizayssa ekkarkkii» giidi Yaaqoobey minththi shoobbida gishshas Eesawey izi gidayssa ekkides. ");
INSERT INTO gmvl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Hessafe guye Eesawey, «Denda ane boos; tanikka inttenara issife baana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Gido attiin Yaaqoobey iza, «Ta godoo! Ne be7iza mala nayti shugo gididayssa ne eraasa; qasse tani galo maratanne guuththa laaqqata dhanththiza dorsatanne miizata naagana koshshees; istti elle elle laaggiko meheti wuri issi gallas hayqqi wurana. ");
INSERT INTO gmvl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Hessa gishshas ta godoo neni taappe sinththatada ba; ta sinththan diza meheynne nayti hemettana dandayza keena hemettidi nenara Seyren gayttana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Eesawey iza, «Histtiko tani ta asaappe guuththata nees ashshays» gides. Gido attiin Yaaqoobey iza, «Hessi ayssee? Tani ta godaa sinththan bonchchettidayssi taas gidana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Hessa gishshas Eesawey he gallas Seyre simmi bides. ");
INSERT INTO gmvl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Gido attiin Yaaqoobey Sukoote bides; heen baas keeth keexxides; ba mehetaska aqizaso giigsides; hessa gishshas he sohoza Sukoote gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yaaqoobey Mesphexoomiyappe simmida wode Kanaane biittan diza Seekeeme giza katama saron gakkides; katamays sinththa baggara diza dembaan dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ba Dunkaaneza tolida gadeza Seekeeme aawa Emoore naytappe 100 saqile biran shammides. ");
INSERT INTO gmvl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Heen yarshosoho keexxidi iza, «Xoossi Isra7eele Xoossa» gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Liyay Yaaqoobes yelida naya Diinay he wode Seekeeme dere maccassa beyanaas kezadus. ");
INSERT INTO gmvl_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","He biittaa haariza Hiiwey Emoore naa Seekeemey izo wolqqara oykkidi laymatides. ");
INSERT INTO gmvl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Hessafe guye iza wozinay izin ekettides; izikka nayo keehi dosida gishshas siiqo qaalan baleththides. ");
INSERT INTO gmvl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Seekeemey ba aawa Emoore, «Taas hanno nayo machcho oychcharkkii!» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yaaqoobey ba naa Diinay moorettidayssa siyida wode iza attuma nayti mehera bazzon diza gishshas istti yaana gakkanaas co7u gides. ");
INSERT INTO gmvl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hessafe guye Seekeeme aawa Emoorey Yaaqoobera haasayanaas yides. ");
INSERT INTO gmvl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yaaqoobe attuma nayti he hanidayssa siyida mala ba dizasoppe yiidi ceecidanne shenetida; ays giikko Seekeemey Isra7eele naa bolla ooththanaas bessontta ooso ooththida gishshas daro hanqettida. ");
INSERT INTO gmvl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Gido attiin Emoorey isttas, «Ta naa Seekeemey intte nayo diina daro siiqiza gishshas hayyana izo izas machcho immerketii! ");
INSERT INTO gmvl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Nunara ekettitenne gelettite; intte macca nayta nuus immite; nu macca naytakka inttes ekkite. ");
INSERT INTO gmvl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Intte nu giddon uttana dandayeeta; derey keehi aaho; izan de7ite; zal7ite; izan aqo kessite» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","He wode Seekeemey Diina aawaanne izi ishata, «Tani intte ta gizayssa kunththizaa gidikko intte oychchizayssa ay gidikkoka ta immana. ");
INSERT INTO gmvl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Intte koyta koykko immana; imota koykko intte koyidayssa keena ta immana shin nayo ta ekkana mala ero giite» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ba michcheyo Diina Seekeemey tunisida gishshas Yaaqoobe attuma nayti Seekeemessinne iza aawa Emoores wordo yootida; ");
INSERT INTO gmvl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","isttika isttas, «Nuni hessa mala miish ooththana dandayokko; nuni nu michcheyo qaxxarettontta asas immiko hayssi nuna kawushshiza miishsha. ");
INSERT INTO gmvl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nuni intte issi miish ooththiko inttes, ‹Ero› gaana; hessika aazee giikko intte biittaa attuma asay wuri nu mala qaxxarettiko. ");
INSERT INTO gmvl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Nuni nu macca nayta inttes immana intte macca naytakka nuus ekkana; nu intte giddon uttidi inttenara issi dere gidana. ");
INSERT INTO gmvl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Intte qaxxarettanaas koyonttaa gidikko nuni nu michcheyo ekkidi baana» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Histtiin istti gidayssi Emooressinne iza naa Seekeemes lo7o misatides. ");
INSERT INTO gmvl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ba aawa keeththan diza ubbaafe aadhdhi bonchchettida Seekeemey Yaaqoobe nayin ufayettida gishshas istti gidayssa ooththanaas gam7ibeenna. ");
INSERT INTO gmvl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","He wode Emooreynne iza naa Seekeemey ba asaas yootanaas ba diza katama simmi biidi, ");
INSERT INTO gmvl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Ha asati nunara siga; istti nu biittan dettonne zal7etto; nu derey keehi aaho; istta macca nayta nuni ekkana; isttika nu macca nayta ekketto. ");
INSERT INTO gmvl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Gido attiin nunara istti issi asa mala de7anaas nuni issi miish ooththanaas koshshees; hessika istti qaxxarettida mala nu attuma asay wuri qaxxarettiko hanana. ");
INSERT INTO gmvl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Nuni hessaththo ooththiko istta miizay, istta aqoynne istta mehey wuri nuus deennee? Hessa gishshas ane nuni istti goyssa ero goos; isttika nunara daana» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Katamaa dubbushan shiiqida asay wuri Emooressinne iza naa Seekeemes, «Ero» gida. Histtiin he katama attumasay wuri qaxxarettides. ");
INSERT INTO gmvl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Heedzdzanththo gallas istti wuri ba qaxxara madunththaa sakettishin, Yaaqoobe attuma naytappe Diina ishati, Simooninne Lewey giththa mashsha ekkidi oonikka erontta katamaa gelidi, adde gididayta ubbaa wodhida. ");
INSERT INTO gmvl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Emoorenne iza naa Seekeeme giththa mashshan wodhidi ba michcheyo Diina Seekeeme sooppe kessi ekkidi bida. ");
INSERT INTO gmvl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yaaqoobe attuma naytikka ahata bollara yedhetti aadhdhidi ba michcheyo Diino tunisida katamaa bonqqida. ");
INSERT INTO gmvl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Istta dors, deysh, miiz, hare, qasseka katamaa giddon dizayssanne gaxan dizayssa ubbaa ekkida. ");
INSERT INTO gmvl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Istta mehetanne istta machcheta guuththa naytara ubbaa di7i ekki bida; keeththan dizayssaka ubbaa bonqqida. ");
INSERT INTO gmvl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yaaqoobey Simoonanne Lewe, «Intte ta bolla meto ehichchideta; ha biittan diza Kanaanetinne Paarizeti tana ixxana; nuni qoodan guuththa; istti issife gididi ta bolla worajjiko taninne taso asay dhayana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Gido attiin isttas, «Histtiin izi nu michcheyo layma maccassa mala ooththanaas bessizee?» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Hessafe guye Xoossi Yaaqoobe, «Dendada pude Beetele baada heen de7a; neni ne isha Eesaweppe baqatiza wode nees qonccida Xoossaas heen yarsho yarshizaso giigsa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yaaqoobeykka baso asaanne banara diza asaa ubbaa, «Intte giddon diza allaga eeqa misleta diggite; intte bolla geeshshite; intte may7oka laammite. ");
INSERT INTO gmvl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ane dendidi pude Beetele boos; ta metotida gallas tani gizaa siyidi tani bida ubbason tanara gidida Xoossaas tani heen yarsho yarshizaso giigsana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Hessa gishshas istti ba achchan diza hara dere asaa eeqa misleta ubbaanne ba hayththan diza gutichcha ubbaa kessidi Yaaqoobes immiin Yaaqoobey heyta Seekeemen diza wolaa garsan moogides. ");
INSERT INTO gmvl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Hessafe guye istta yuushon diza katama ubba asaa bolla Xoossafe dagamaynne yashshateththi wodhdhida gishshas Yaaqoobeynne iza attuma nayti dendidi bishin oonikka istta oykkanaas kaallibeenna. ");
INSERT INTO gmvl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yaaqoobeynne izara diza asay wuri Kanaane biittan diza Beetele geetettiza Looza gakkida. ");
INSERT INTO gmvl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Heen izi yarsho yarshizaso keexxidi he sohoza Eli-Beetele gi sunththides; ays giikko izi ba ishaappe baqatidi biza wode Xoossi izas qonccida soho gidida gishshassa. ");
INSERT INTO gmvl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Irbiqa dichchida Dibooray heen hayqqada Beeteleppe duge baggara diza wolaa garsan iza moogettadus; hessa gishshas he miththaa sunththi Alem-Bakute geetettides. ");
INSERT INTO gmvl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yaaqoobey Mesphexoomiyappe simmidaappe guye Xoossi izas qasseka qonccidi iza anjjides; ");
INSERT INTO gmvl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Xoossi iza, «Ha7i gakkanaas ne sunththi Yaaqoobe; gido attiin hayssafe guye mulekka Yaaqoobe geetettaka; ne sunththi Isra7eele geetettana» giidi izi iza Isra7eele gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Qasse Xoossi Yaaqoobe, «Tani Ubbaa Dandayza Xoossa; neni yeletta; coratta; dereynne dere maabaray neeppe kezana; kawotikka ne gulbateppe kezana. ");
INSERT INTO gmvl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tani Abrahaamessinne Yisaaqas immida biittaa qasse nees immana; neeppe guyekka tani ha biittaa ne zereththas immana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Hessafe guye Xoossi izara haasayda sohoppe pude bides. ");
INSERT INTO gmvl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yaaqoobey Xoossi banara haasayda sohon shuch essidi iza bolla ushsha yarsho gussides; zaytekka iza bolla tigides. ");
INSERT INTO gmvl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yaaqoobey Xoossi banara haasayda sohoza, «Beetele» gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Istti hessafe guye Beeteleppe dendi Efraata gakkanaas guuth ashshida mala Eraheelo wolqqama miixay oykkides. ");
INSERT INTO gmvl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Miixay izo waayisiin izo yelissizaara, «Babbofa; hayssika attuma naa» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Gido attiin iza hayqqa shemppo kezishin ba naa Beeni-Oone ga sunththadus; Yaaqoobey iza Biniyaame gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Hessafe guye Eraheela hayqqada Beeteliheeme giza Efraata efiza oge doonan moogettadus. ");
INSERT INTO gmvl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yaaqoobey izi duufon hawulte shuch essides; he hawulte shuchchay hach gakkanaaska Eraheeli duufo malata gidi dees. ");
INSERT INTO gmvl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isra7eeley heeppe dendidi Edera gimbefe he pinththan ba Dunkaaneza tokkides. ");
INSERT INTO gmvl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Isra7eeley he biittan dishin Oroobeeley biidi ba aawaas yelida aylle Bilihara zin7ides; Isra7eeleykka ha yo7oza siyides. Yaaqoobe attuma nayti tammanne nam7a.Isttika, ");
INSERT INTO gmvl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Liya nayti Yaaqoobe bayra naa Oroobeele, Simoona, Lewe, Yuhuda, Yisakoorenne Zaabiloone. ");
INSERT INTO gmvl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Eraheeli attuma nayti Yooseefenne Biniyaame. ");
INSERT INTO gmvl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Eraheeli aylle Biliha attuma nayti Daanenne Niftaaleme. ");
INSERT INTO gmvl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Liya osanchcha Zilfi attuma nayti Gaadenne Aaseere. Hayti Masophexoomyan Yaaqoobes yelettida iza attuma nayta. ");
INSERT INTO gmvl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yaaqoobey ba aaway dizaso Mamire geetettizaso yides; hessika Abrahaameynne Yisaaqi kase deyida Qiriyaate-Arba7e woykko Kebroone geetettizaso. ");
INSERT INTO gmvl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Yisaaqi 180 layth de7ides; ");
INSERT INTO gmvl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","izi daro wode de7idi keehi cimmi hayqqidi ba aawatan gaaggides; iza nayti Eesaweynne Yaaqoobey iza moogida. ");
INSERT INTO gmvl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Eedoome geetettiza Eesawe yeletay hayssafe kaalli xaafettidayssa. ");
INSERT INTO gmvl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Eesawey Kanaane biitta macca naytappe baas machcho ekkides; isttika Hiite Eeloone naa Aada, Hiiweya Xiba7oone naa Aanay yelida Oholibaamenne ");
INSERT INTO gmvl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Isma7eele naa Nebayooti michchiyo Baasemaato. ");
INSERT INTO gmvl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Aaday Eesawes Elfaaze yeladus; Baasemaatayakka Era7u7eele yeladus; ");
INSERT INTO gmvl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibaame Ya7uushe, Ya7ilaamenne Qoore yeladus; Kanaane biittan Eesawes yelettida attuma nayti haytantta. ");
INSERT INTO gmvl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Eesawey ba machcheta, ba attuma naytanne macca nayta, baso as ubbaa ba miizatanne ba mehe ubbaa Kanaane biittan izi haaridayssa ubbaa ekkidi ba isha Yaaqoobeppe haakki bides. ");
INSERT INTO gmvl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Istta haaroy darida gishshas istti issife de7anaas dandaybeettenna; mehey isttas darida gishshas istti diza derey istta nam7atas gidanaas dandaybeenna. ");
INSERT INTO gmvl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Histtiin Eedoome geetettiza Eesawey Seyre geetettiza gezzen uttides. ");
INSERT INTO gmvl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Seyre geetettiza gezze biittan diza Eedoometa aawa Eesawe yeletay hayssafe kaalli xaafettidayssa. ");
INSERT INTO gmvl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Eesawe attuma nayta sunththi hayssafe kaalli xaafettidayssa; hessatikka Eesawe machcho Aada naa Elfaazenne Eesawe machcho Baasemaati naa Era7u7eele. ");
INSERT INTO gmvl_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elfaaze nayti Temaane, Omaare, Xefo, Ga7itaamenne Qenaaze. ");
INSERT INTO gmvl_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Qasse Eesawe naa Elfaazes Teminaa7e geetettiza aylley dawus; izakka Elfaazes Amaaleeqe yeladus; hayti Eesawe machcho Aadis naa nayta. ");
INSERT INTO gmvl_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Era7u7eele attuma nayti Nahaate, Zaraahe, Shammahanne Miizahe; hayti Eesawe machchiyo Baasemaatis naa nayta. ");
INSERT INTO gmvl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Xiba7oones naaza naa Aanay yelida Oholibaami attuma nayti hayta; iza Eesawes Ya7uushe, Ya7ilaamenne Qoore yeladus. ");
INSERT INTO gmvl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Eesawe yeletaa zereththa halaqati hayssafe kaalli xaafettidayta. Eesawes bayra naa Elfaaze attuma naytas halaqa gididayti Temaane, Omaare, Xefo, Qenaaze, ");
INSERT INTO gmvl_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Qoore, Ga7itaamenne Amaaleeqe; Eedoome biittan Elfaazey yelida halaqati hayta; hayti wuri Aadis naa nayta. ");
INSERT INTO gmvl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Eesawe naa Era7u7eele attuma naytas halaqa gididayti Nahaate, Zaraahe, Shammahanne Miizahe; Eedoome biittan Era7u7eeley yelida halaqati hayta; istti Eesawe machcho Baasemaatis naa nayta. ");
INSERT INTO gmvl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Eesawe machchiyo Oholibaami attuma naytas halaqa gididayti Ya7uushe, Ya7ilaamenne Qoore; istti Aana naa, Eesawe machchiyo Oholibaamippe yelettida halaqata. ");
INSERT INTO gmvl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Hayti Eedoome geetettiza Eesawe attuma naytassinne istta zereththatas halaqata. ");
INSERT INTO gmvl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Eedoome biittan diza Hoore Seyre attuma nayti hayssafe kaalli xaafettidayta; heytikka Looxaane, Shobaale, Xiba7oone, Aana, ");
INSERT INTO gmvl_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishoone, Exeerenne Dishaane; isttika Eedoome biittan diza Seyre attuma nayti, Hooreta halaqata. ");
INSERT INTO gmvl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Looxaane attuma nayti Hoorenne Hemaane; Looxaane michchiya Teminaa7o. ");
INSERT INTO gmvl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Shobaale attuma nayti Aliwaane, Manahaate, Eebaale, Shefanne Oonname. ");
INSERT INTO gmvl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Xiba7oone attuma nayti Aayanne Aana; Aanaykka bazzon ba aawa Xiba7oone hareta heemmishe xabala haath demmidayssa. ");
INSERT INTO gmvl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Aana nay Dishoone; naya qasse Oholibaamo. ");
INSERT INTO gmvl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dishoone attuma nayti Hemdaane, Eshibaane, Yitiraanenne Kaaraane. ");
INSERT INTO gmvl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Exeere attuma nayti Bilihaane, Za7iwaanenne Aqaane. ");
INSERT INTO gmvl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishaane attuma nayti Uuxenne Araane. ");
INSERT INTO gmvl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hooreta halaqati haytantta; Looxaane, Shobaale, Xiba7oone, Aana, ");
INSERT INTO gmvl_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishoone, Exeerenne Dishaane. Hayti Seyre biittan ba qommon qommon shaakettida Hooreta halaqata. ");
INSERT INTO gmvl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Isra7eelen kawoy kawotanaappe kase Eedoome biittan kawotida kawoti hayssafe kaalli xaafettidayta. ");
INSERT INTO gmvl_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bi7oore naa Beelay Eedoomen kawotides; iza katamaa sunththi Dinaabe geetettees. ");
INSERT INTO gmvl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Beelay hayqqiin Booxirappe yida Zaraahe nay Yobaabey kawotides. ");
INSERT INTO gmvl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobaabey hayqqiin Temaane biittafe yida Hushamey kawotides. ");
INSERT INTO gmvl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hushamey hayqqiin Midiyaame asata Mo7aabe biittan xoonida Badaade naa Hadaadey, kawotides; iza katamaa sunththi Awite geetettides. ");
INSERT INTO gmvl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadaadey hayqqiin Maasireeqeppe yida Samilay kawotides. ");
INSERT INTO gmvl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samilay hayqqiin shaafa achchan diza Erahooboteppe yida Sha7uley kawotides. ");
INSERT INTO gmvl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sha7uley hayqqiin Akiboore naa Ba7aali-Hanaaney kawotides. ");
INSERT INTO gmvl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akiboore naa Ba7aali-Hanaaney hayqqiin Hadaarey kawotides; iza katamaa sunththi Paa7u geetettees; iza machchiya Mezahaabe nayo Maxireeda yelida Mahexabi7eelo geetettawus. ");
INSERT INTO gmvl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Eesawe yeleta halaqati ba qommon qommon ba sunththan sunththan haytantta; Teminaa7e, Aliwa, Yeteete, ");
INSERT INTO gmvl_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibaame, Eela, Pinoone, ");
INSERT INTO gmvl_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Qenaaze, Temaane, Mibizaare, ");
INSERT INTO gmvl_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magidi7eelenne Iraame. Haytanti ba haariza biittan, ba dizason Eedoome halaqata. Hayssi Eesawey Eedoometa aawa. ");
INSERT INTO gmvl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yaaqoobey kase ba aaway deyida Kanaane biittan uttides. ");
INSERT INTO gmvl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yaaqoobe nayti hanidayssi hayssafe kaallidi xaafettidayssa. Yooseefey 17 layththa naa gidida wode ba aawaa aylletappe, Bilihappenne Zilfife yelettida ba ishatara ba aawa meheta heemmees; he wode izi ba aawaas istti ooththida iita miish ehi yootees. ");
INSERT INTO gmvl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isra7eeley Yooseefe cimateththan yelida gishshas hankko attuma nayta ubbaafe aaththi siiqees; izi izas alleqo may7o giigsides. ");
INSERT INTO gmvl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Iza ishati istta aaway iza isttafe aaththi siiqizayssa be7idi istti iza ixxidi lo7o qaalan izara haasayanaas dandaybeettenna. ");
INSERT INTO gmvl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yooseefey agumo agumettidi ba ishatas yootides; isttika iza gede gujji ixxida. ");
INSERT INTO gmvl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Izi isttas, «Tani agumettida agumo siyite. ");
INSERT INTO gmvl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nuni gade giddon kaththa mirqqe mirqqishin ta mirqqeya dendada sitti ga eqqadus; intte mirqqeti gidikko yuuyi aadhdhidi ta mirqqeysi ziggida» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Iza ishati iza, «Neni nu bolla kawotana hanay? Woykko nuna tumu haarana hanay?» gida; istti iza agumoza gishshassinne izi isttas yootida qaalaa gishshas kaseppe iza aaththi ixxida. ");
INSERT INTO gmvl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Qasseka Yooseefey hara agumo agumettidi ba ishanttas yootides; «Siyite; tani hara agumokka agumettadis; he agumozan arshey, aginaynne 11 xoolintteti taas ziggishin be7adis» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","He izi be7ida agumoza ba aawassinne ba ishatas yootiin iza aaway iza, «Hayssi neni agumettidayssi ay agumoo? Tumu tani, ne aayeyanne ne ishati yiidi ne sinththan sa7an gufannidi nees zigganee?» gi hanqettides. ");
INSERT INTO gmvl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Iza ishati iza miqqaynida; gido attiin iza aaway ha yo7oza ba wozinan woththidi naagides. ");
INSERT INTO gmvl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Issi gallas iza ishati Seekeeme achchan ba aawaa meheta heemmanaas biin, ");
INSERT INTO gmvl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Isra7eeley Yooseefe, «Ne ishati Seekeemen mehe heemmizayssa ne eraasa; haa ya; ta nena isttako kiittana» gides. Yooseefeykka, «Ero» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yaaqoobeykka, «Baada ne ishatinne mehey saro dizaakko be7a yaada istta hanota taas yoota» giidi iza Kebroone shoobba kiittiin izi Seekeeme bides. ");
INSERT INTO gmvl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Heen demba giddon izi gede haa simerettishin issi asi iza demmidi, «Naazoo! Ay koyay?» gi oychchides. ");
INSERT INTO gmvl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Izikka, «Ta ishata koyays; istti mehe heemmizasohoy awakko taas yootarkkii!» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Histtiin addezi, «Hessafe dendichchida; isttas, ‹Nuni Dootaane boos› gishin siyadis» gides; hessa gishshas Yooseefey ba ishata guye biidi istta Dootaanen demmides. ");
INSERT INTO gmvl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Gido attiin izi haahon dishin istti iza be7ida; izi isttako gakkontta dishin istti iza wodhanaas maqettida. ");
INSERT INTO gmvl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Issoy issaas, «Be7ite! Agumo goday yees. ");
INSERT INTO gmvl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Haa yiite! Iza wodhidi ha ollatappe issaa giddo yeggoos. Hessafe guye, ‹Iita do7ay iza mides› gaana; histtidi iza agumoy polettiin ane be7ana» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Oroobeeley hessa siyidi istta kusheppe iza ashshanaas koyidi, «Iza wodho wodhdhoko; ");
INSERT INTO gmvl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Suuth gussofte; iza intte bazzon diza ha ollaa giddo yeggite; iza bolla kushe woththofte» gides. Oroobeeley iza istta kusheppe ashshidi guye iza aawaakko yeddanaas qoppides. ");
INSERT INTO gmvl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yooseefey ba ishataakko gakkida wode izi may7ida alleqo may7o izappe qaari ekkida; ");
INSERT INTO gmvl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","iza efidi haaththi baynda mela ollan yeggida. ");
INSERT INTO gmvl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Istti ba qumaa maanaas uttidaashe Isma7eele dere asati Gibxe baanaas Gala7aadeppe yizayta dhoqqu giidi be7ida; istti ba gaamellan sawo, balasaane geetettiza dhalenne karbbe caani woththida. ");
INSERT INTO gmvl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuhuday ba ishata, «Nuni nu ishaa wodhidi iza suuththaa qottiko nuna ay maaddanee? ");
INSERT INTO gmvl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Haa yiite; iza Isma7eeletas bayzoos; iza bolla nu kushe woththoko; gaasoykka izi nu ishanne nu asho.» Histtiin iza ishati wurikka ero gida. ");
INSERT INTO gmvl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Hessa gishshas Midiyaame biitta zal7anchchati hessara aadhdhishin iza ishati Yooseefe ollaafe kessidi Isma7eele asatas 20 biras bayziin istti Yooseefe Gibxe biitta efida. ");
INSERT INTO gmvl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Oroobeeley ollaako simmidi Yooseefey heen bayndayssa be7ida wode ceecidi ba may7o daakkides ");
INSERT INTO gmvl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Izi guye ba ishataakko biidi, «Naazi heen baawa; ha7i ta awa simma boo!» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Hessafe guye istti issi deysh ekki shukkidi Yooseefe may7o suuththan maadhida. ");
INSERT INTO gmvl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Iza aleqo may7oza aawaakko efidi aawaas, «Nuni hayssa demmi ekkidos; hayssi ne naaza may7okkonne harakko ane xeella» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Aawaykka may7ozi Yooseefeyssa gididayssa eridi, «Ee hayssi ta naaza may7o! Iita do7ay iza michchides; tumukka Yooseefe do7ay puuzereththi montta aggenna» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yaaqoobeykka mishettidi ba may7o peedhi yeggides; maaqa may7idi daro wode gakkanaas ba naazas yeekkides. ");
INSERT INTO gmvl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Iza attuma naytinne macca nayti wuri iza minththeththanaas izakko yida; gido attiin izi minettontta ixxidi, «Hanenna! Tani yeekkada ta naakko baada duufon gelana» giidi iza aaway izas yeekkides. ");
INSERT INTO gmvl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","He wode Midiyaame biitta asati Yooseefe Gibxe kawo oosanchcha Phixifaaras Gibxen bayzida; Phixifaaraykka zabeta halaqa. ");
INSERT INTO gmvl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","He wode Yuhuday ba ishatappe shaakettidi Adulaame geetettiza katamaan diza Hiira geetettiza addezara de7ana bides. ");
INSERT INTO gmvl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Heen Yuhuday Shu7a geetettiza Kanaane dere macca naa be7ides. Izikka izo machcho ekkidi izira de7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Iza izas shaarada attuma naa yelada Eera ga sunththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Qasseka shaarada attuma naa yelada Oonaane ga sunththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Qasse gujjadakka attuma naa yelada iza Seela ga sunththadus. Izakka iza Akizaabe geetettiza biittan yeladus. ");
INSERT INTO gmvl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yuhuday ba bayra naaza Eera Ti7imaaro machcho ekisides. ");
INSERT INTO gmvl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Yuhuda bayra naa Eeray GODAA sinththan iita as gidida gishshas GODAY iza wodhides. ");
INSERT INTO gmvl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yuhuday Oonaane, «Ne ishaza machcho laattada izas laata naa yelada iza sunth xeygisa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Gido attiin Oonaaney yelettiza nayti baas gidonttayssa eridi ba ishaa machcheyra aqiza wode aydekka ba ishaas nay yelettontta mala ba zereththaa biittan gussees. ");
INSERT INTO gmvl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Izi ooththidayssi GODAA sinththan para gidida gishshas GODAY izakka wodhides. ");
INSERT INTO gmvl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Hessafe guye Yuhuday ba naa machcho Ti7imaaro, «Ta nayee Seelay diccana gakkanaas ne aawaa soo baada am7eteththan daashsha» gides. Hessa izi aazas gidee? giikko, «Seelay ba ishata mala hayqqanaakko» giidi hirgida gishshassa. Hessa gishshas Ti7imaara baada ba aawa soon de7adus. ");
INSERT INTO gmvl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Daro wodeppe guye Shu7a naya, Yuhuda machchiya hayqqadus. Yuhuday kayotti aaththidaappe guye ba lagge Adulaame dere as Hiira geetettizayssara ba dorsa iske qanxxiza asati dizaso Temina bides. ");
INSERT INTO gmvl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Asay Ti7imaaris, «Beya; ne bolloy Yuhuday ba dorsata iske qanxxanaas Temina bees» gi yootides. ");
INSERT INTO gmvl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Iza ba am7eteththa may7oza qaarada bana baleththanaas goos ekka gullunttada Temina efiza oge doonan diza Enayme katama pengen uttadus. Hessa iza ooththiday Seelay diccidi gakkinkka iza izas machcho gidanaas ekkonttayssa erida gishshassa. ");
INSERT INTO gmvl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Iza ba ayfeso gulluntta uttida gishshas Yuhuday izo be7idi layma maccas giidi qoppides. ");
INSERT INTO gmvl_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ba naa machcho gididayssa erontta dishe oge gaxa izikko shiiqidi izo, «Tanara zin7arkkii!» gides. Histtiin iza, «Tani nenara zin7iko neni taas ay immanee?» ga oychchadus. ");
INSERT INTO gmvl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Izikka, «Tani ta meheppe issi deysha laaqqa nees yeddana» gides. Izakka, «Neni hessa taas yeddana gakkanaas ay oyththanee?» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Izi, «Ay oyththoo?» gi iza oychchides. Izakka, «Ne maatame qalabateza iza qachchizayssaranne ne kushen diza guufeza oyththa» giin izi heyta immidi izira zin7iin iza izas shaaradus. ");
INSERT INTO gmvl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Iza hessafe dendada bidaappe guye ba gullunttida goossaza qaarada ba am7eteththa may7o may7adus. ");
INSERT INTO gmvl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuhuday ba oyththidayssa izippe zaari ekkanaas deysha laaqqa ba lagge Adulaame bolla izis yeddides; gido attiin izi izo demmibeenna. ");
INSERT INTO gmvl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Izi he biitta asaa, «Enayme katamaan oge doonan uttida layma maccassaya awa badee?» gi oychchides. Asay, «Layma maccassi hayssan mulekka baawa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Izikka Yuhudakko simmidi iza, «Tani izo demmabeekke; hessafekka bollara he biitta asay, ‹Layma maccassi hayssan mulekka di erenna› gida» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Histtiin Yuhuday, «Ba oykkidayssa baas ekku; histtontta aggiko asi nuna miiccana. Histtiin tani izis deysha laaqqa yeddadis; gido attiin neni izo demmabeekka» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Heedzdzu aginappe guye asay, «Ne naa machchiya Ti7imaara laymatada shaaradus» giidi Yuhudas yootides. Yuhudaykka, «Izo kare kessidi taman xuuggite» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Izo kare kessiza wode, «Tani shaariday ha miishshata godaassa; beya; hayssa maatame qalabateza iza qachchizayssanne hayssi guufezi oonayssako erana dandaykko era» gaada ba bollos kiita yeddadus. ");
INSERT INTO gmvl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuhuday he miishshata eridi, «Taappe iza xillo; gaasoykka tani izo ta naa Seelas ekkabeekke» gides. Hessafe guye izi izira nam7anththo zin7ibeenna. ");
INSERT INTO gmvl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Iza yelana haniza wode izi ulon mentte attuma nayti deettes. ");
INSERT INTO gmvl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Iza maarettishin isttafe issay ba kushe kessiin yelissizaara, «Be7ite; hayssi koyro kezees» gaada zo7o qacina iza kushen qachchadus. ");
INSERT INTO gmvl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Gido attiin izi ba kushe guye ekkida wode iza ishay yelettiin iza, «Neni waana sinththata kezadii!» gadus. Hessa gishshas iza Paareese ga sunththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Hessafe guye iza kushen zo7o qacinay qashetti diza Paareese ishay yelettiin sunththay Zaraahe geetettides. ");
INSERT INTO gmvl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Isma7eele asati Yooseefe Gibxe efiin Gibxe kawo oosanchchatappe Phixifaara geetettiza zabeta halaqay Yooseefe Isma7eeletappe shammides. ");
INSERT INTO gmvl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","GODAY Yooseefera diza gishshas izi ooththizayssa ubbaa izas injjesides; izikka ba godaa soon Gibxen de7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","GODAYKKA izara de7izayssanne GODAY izi ooththidayssa ubbaa izas injjesidayssa Phixifaaray be7idi, ");
INSERT INTO gmvl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yooseefe dosides. Yooseefeykka iza oosanchcha gidides. Phixifaaray iza ba keeththa asaa bolla sunththidi baas dizaaz ubbaa iza kushen woththides. ");
INSERT INTO gmvl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Phixifaaray ba keeththan dizayssa ubbaa bollanne ba aqota ubbaa bolla sunththida wodeppe doommiin GODAY Gibxe addeza keeth Yooseefe geedon anjjides. GODAA anjjoy Phixifaara soon gidiin karen diza miish ubbaa bolla wodhdhides. ");
INSERT INTO gmvl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Hessa gishshas baas diza ubbaa Yooseefes sheedhdhides; izi ba miza kaththaafe attiin hara Yooseefe kushen yeggides. Yooseefey yegalththinne mala lo7o asa. ");
INSERT INTO gmvl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Guuththa wodeppe guye iza goda machcheya Yooseefe cadda xeellada, «Haa ya; tanara zin7a» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Gido attiin izi ixxides; ba godaa machcheys, «Beya! Ta goday bason diza ubbaa taas sheedhdhidi aazaska hirgenna; baas dizayssa ubbaa ta kushen woththides. ");
INSERT INTO gmvl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Hason taappe aadhdhizay deenna; neni iza machcho gidida gishshas nena xalla attiin ta goday taas immontta miishshi baawa. Histtiin tani hayssa mala iita miish Xoossa sinththan wostta ooththoo?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Iza ubba wode Yooseefe saleththinkka izi eemo immibeenna; izira ishech attiin izikko shiiqanawukka koyibeenna. ");
INSERT INTO gmvl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Issi gallas izi ba ooso ooththanaas soo gelishin soo aylletappe oonikka soon baawa. ");
INSERT INTO gmvl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Izakka Yooseefe may7o shiishsha oykkada, «Tanara zin7a» gadus. Gido attiin izi ba may7o izi kushen yeggidi sooppe kare woxxi kezides. ");
INSERT INTO gmvl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Yooseefey ba may7o izi kushen yeggidi sooppe kare woxxi kezidayssa iza be7ada, ");
INSERT INTO gmvl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ba soo aylleta xeygada isttas, «Be7ite! Ta azinay ehida Ibraawe addezi tana kawushshishe aggides; izi tanara zin7anaas haa soo gelides; gido attiin tani ta qaala dhoqqisada waassadis. ");
INSERT INTO gmvl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Histtiin izi ba may7o ta achchan yeggidi sooppe kare woxxi kezides» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Keeththa aaway yaana gakkanaas iza Yooseefe may7oza ba achchan woththadus. ");
INSERT INTO gmvl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Hessafe guye iza izas, «Hessi neni nuus ehida Ibraawe aylley tanara zin7anaas taakko gelides; ");
INSERT INTO gmvl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Gido attiin tani ta qaala dhoqqisada waassiin izi ba may7o ta achchan yeggidi sooppe kare woxxi kezides» gadus. ");
INSERT INTO gmvl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Keeththa aaway machcheyo, «Ne aylley tana hayssaththo ooththides» gaada yootida qaalaa siyidi daro hanqettides. ");
INSERT INTO gmvl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Izikka Yooseefe efidi kawo qasho asay diza qasho keeththan yeggides. ");
INSERT INTO gmvl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Gido attiin Yooseefey heen qasho keeththan diza wode GODAY izara dees. Xoossi qasho keeththan izara diza ba kiyateth izas darssides. Qasseka qasho keeththa halaqaza sinththan izas bonchcho immides. ");
INSERT INTO gmvl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Histtiin qasho keeththaa halaqay qasho asaa ubbaa Yooseefe kushen woththides; heen oosettizayssa ubbaa bolla aawatizay iza. ");
INSERT INTO gmvl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","GODAY Yooseefera gididi izi ooththiza ubbaa polisiza gishshas woyne keeththaa alaafey Yooseefe alaafeteththan diza ay miishshaska waanandeesha giidi hirgi erenna. ");
INSERT INTO gmvl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Guuththa wodeppe guye Gibxe kawo ushshu duuqqizayta alaafeynne quma kaththizayta alaafey ba godaa Gibxe kawo qohida. ");
INSERT INTO gmvl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Kawoy ushshu duuqqizayta halaqanne quma kaththizayta halaqata nam7ata bolla keehi hanqettides. ");
INSERT INTO gmvl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Hessa gishshas zabeta halaqaza keeththan Yooseefey qashettida woyne keeththan yeggides. ");
INSERT INTO gmvl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Zabeta halaqay istta Yooseefes sheedhdhiin izi isttas koshshiza miishshan maaddides; isttika qasho keeth gelidi guuth gam7ida mala, ");
INSERT INTO gmvl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Gibxe kawos ushshu duuqqizayta halaqaynne quma kaththizayta halaqay, nam7ayka qasho keeththan dishe issi qamma omars baas baas agumo agumettida. Nam7ata agumo birsheththika dumma dumma. ");
INSERT INTO gmvl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yooseefey maalado isttako gelida wode istti muuzotti uttidayta be7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Hessa gishshas ba godaa qasho keeththan banara diza kawo oosanchchata, «Hach intte ayfesoy aazas dhumidee?» gi oychchides. ");
INSERT INTO gmvl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Isttika izas, «Nuni nam7ay agumo agumettidos; gido attiin nuus birshiza asi dhaydes» gida. Yooseefeykka isttas, «Agumo birshizay Xoossa gidennee? Intte agumoza ane taas yootite» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Histtiin ushshu duuqqizayta halaqay ba agumo Yooseefes, «Tani ta agumon issi woyne mith ta sinththan dizayssa be7adis. ");
INSERT INTO gmvl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Qasse he woyne miththaas heedzdzu haggay dees. Heerakka aacada ciiyadus; lo7eththa wurcada ayfadus. ");
INSERT INTO gmvl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","He wode Paaroone ushshaa xuu7ay ta kushen dees; tanikka woyneza ayfe maxada xuu7aza giddon gum7ada ushshaa Paaroones immadis» gi yootides. ");
INSERT INTO gmvl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Histtiin Yooseefeykka zaaridi, «Hessa birsheththi hayssa; heedzdzu haggati heedzdzu gallassata. ");
INSERT INTO gmvl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Heedzdzu gallassata giddon kawoy nena denththidi izi nena kase ne diza alaafeteththan woththana; kase neni ushshu duuqqiza wode ooththida mala neni kawo wancaa iza kushen woththana. ");
INSERT INTO gmvl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Gido attiin nees wodey lo7ida wode tana baloppa; taaska kiya; ta gishshas kawos yootada ha qasho keeththaafe tana kesisa; ");
INSERT INTO gmvl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","gaasoykka tana Ibraaweta biittafe wolqqara shammi ehida; gido attiin hayssaththo tana qashos gaththiza miish aykkoka ooththabeekke» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Kath kaththizayta halaqay Yooseefey ushshu duuqqizayta agumo lo7eththi birshidayssa be7idi Yooseefes, «Tanikka agumo agumettadis; hessika, ‹Ta hu7en heedzdzu masoobe tookka oykkadis. ");
INSERT INTO gmvl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Bolla bagga masooben Gibxe kawos uukettida dumma dumma qumay dees. Gido attiin kafoti hessa ta hu7en diza masoobezappe mida› » gi yootides. ");
INSERT INTO gmvl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Histtiin Yooseefey, «Hessa birsheththay hayssa; heedzdzu masoobeti heedzdzu gallassata. ");
INSERT INTO gmvl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Heedzdzu gallassata giddon kawoy nena denththidi ne qoodhe muucidi miththa bolla kaqisana; ne ashokka kafoti maana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Heedzdzanththo gallas Gibxe kawoy ba yelettida gallas ba kawoteththan diza shuumeta ubbaas gibira giigsides. Ushshu duuqqizayta halaqanne kath kaththizayta halaqaa qasho keeththaafe kessidi ba shuumeta sinththan essides. ");
INSERT INTO gmvl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ushshu duuqqizayta halaqaza kase iza shuumeteththan zaariin izi kawo kushen wanca woththides. ");
INSERT INTO gmvl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Gido attiin kawozi kath kaththizayta halaqaa Yooseefey iza agumo birshida mala iza kaqisides. ");
INSERT INTO gmvl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ushshu duuqqizayta halaqay gidikko Yooseefe qoppontta dogi aggides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Nam7u layth kumeth aadhdhida wode Gibxe kawoy agumo agumettides; agumora izi Abbaye shaafaa doonan eqqi dishin, ");
INSERT INTO gmvl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","laappun ordenne modhdho miizati Abbaye shaafappe kezidi shaafaa achchan maata mishin be7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Isttafe kaallidi hara laappun mala iitanne gilqa miizati Abbaye shaafappe kezidi shaafaza doonan diza modhdho miizata achchan eqqida. ");
INSERT INTO gmvl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","He medho iitanne gilqa miizati laappun ordenne modhdho miizata mittishin be7ides. Hessafe guye kawoy dhiskofe beeggides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Izi qasseka dhiskidi nam7anththo agumettidi laappun lo7onne muuruta tiyati issi maqa bolla diccidayssa be7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Isttafe kaallidi ayfe laafanne carkon shullidi melida laappun tiyati kezida. ");
INSERT INTO gmvl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","He laafa ayfe tiyati lo7onne muuruta tiyata mittida. Hessafe guye kawozi beeggidi agumo gididayssa erides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Gadey wontishin iza wozinay shirotdes; hessa gishshas Gibxen diza bitanchchatassinne era asata ubbaas kiittidi xeygisides; kawoy isttas ba agumoza yootides; gido attiin izas he agumoza birshanaas dandayza asi beettibeenna. ");
INSERT INTO gmvl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","He wode ushshu duuqqizayta halaqay Gibxe kawos, «Tani ta mooro hach qoppays. ");
INSERT INTO gmvl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Issito kawoy ba aylles hanqettidi tananne kath kaththizayta halaqaza qasho keeththan yeggides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Nuni heen dishe nuus nuus agumo agumettidos; agumozaska dumma dumma birsheththi dees. ");
INSERT INTO gmvl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","He wode zabeta halaqaza aylle gidida issi Ibraawe panththi nunara qasho keeththan dees. Nuni nu agumo izas yootiin izi nuus hu7en hu7en nu agumo birshides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Histtiin he yo7oti izi nuus birshida mala hanida. Hessi aazee giikko tani kase ta alaafeteththan simmadis; hankkoyssi gidikko kaqettides» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Histtiin Gibxe kawoy Yooseefe kiittidi xeygisides. Istti iza qasho keeththafe eeson ekki yiin ba hu7e meedettidi may7o laammidi kawozaakko gelides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kawoy Yooseefe, «Ta agumettida agumoza birshanaas oonikka dandaybeenna. Gido attiin tani, ‹Yooseefey agumo siyikko birshanaas dandayees› gizaaz siyadis» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Histtiin Yooseefey, «Tani hessa dandaykke; gido attiin Xoossay kawos lo7o birsheth immana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kawoykka, «Tani ta agumon Abbaye haaththa shaafaa doonan eqqidishin, ");
INSERT INTO gmvl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Laappun gitanne modhdho miizati Abbaye shaafappe kezidi haaththaa doonan maata mishin. ");
INSERT INTO gmvl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Qasseka isttafe hara laappun medha iita, gilqanne laafa miizati shaafappe kezida; tani hessa mala medha iita miiz Gibxe biittan mulekka be7a erikke. ");
INSERT INTO gmvl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Medha iitanne laafa miizati koyroyta laappun modhdho miizata mitti aggida. ");
INSERT INTO gmvl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Gido attiin istti mittidaappe guyekka istta medhay kase malakka iiti uttida gishshas istti mittidayssa asi eranaas dandaybeenna. Hessafe guye tani dhiskofe beeggadis. ");
INSERT INTO gmvl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","«Qasseka agumora laappun lo7onne muuruta tiyati issi maqa bolla diccidayta be7adis. ");
INSERT INTO gmvl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Qasseka isttafe hara ayfe laafanne carkon shullida laappun tiyati kezida. ");
INSERT INTO gmvl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","He shulli uttida tiyati laappun lo7o tiyata mittida. Tani ha agumoza marotas yootadis; gido attiin taas agumoza birshiza asi beettibeenna» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Hessafe guye Yooseefey Gibxe kawoza, «Nam7ayka ne be7ida agumota birsheththayka issino. Xoossi ba ooththana hanizayssa kawos qonccisides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","He laappun lo7o miizati laappun layththata; qasse laappun lo7o tiyati laappun layththata; nam7ayka issi mala. ");
INSERT INTO gmvl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","He laappun medha iitanne laafa miizati laappun layththata; qasse carkon shullida paththontta laappun tiyati laappun kosha layththata. ");
INSERT INTO gmvl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","«Tani kawos yootida malakka Xoossi ba ooththana hanizayssa kawos bessides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Laappun daro kalo layththati Gibxe biittas ubbaas yaana; ");
INSERT INTO gmvl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Gido attiin laappun kosha layththati izappe kaallidi yaana. He wode Gibxe kaloy wuri dogettana; biittay koshan shocettana. ");
INSERT INTO gmvl_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Kalo layththatappe guye yiza gafa layththati keehi iita gidida gishshas kase kaloy mulekka qofettontta attana. ");
INSERT INTO gmvl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Nam7uto kawos he agumoy beettiday aazassee giikko hayssa yo7oza Xoossi minththidi kuuyida gishshassa; Xoossi hessa eeson ooththana. ");
INSERT INTO gmvl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","«Ha7i hekko eeson kawoy aadho erateththinne akeekay diza as koyidi Gibxe biittan sunththo. ");
INSERT INTO gmvl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Hessaththoka laappun kalo layththatappe ichchashanththo kushe shiishshiza alaafeta kawoy shuumo. ");
INSERT INTO gmvl_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Istti yiza kalo layththatan kath shiishshidi kawo aawateththan minjjetto; he kaththaaka katamatan naagetto. ");
INSERT INTO gmvl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Biittay koshan qohettontta mala ha kaththay Gibxe biittan laappun layththan dendana koshaas minjjettidi de7o» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Histtiin ha yo7ozi Gibxe kawossinne iza oosanchchatas lo7o gididi beettides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Hessa gishshas kawoy isttas, «Nuni Xoossa Ayanara diza hayssa mala hara as oona demmanee?» gi oychchides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Hessafe guye kawoy Yooseefe, «Xoossi hayssa ubbaa nena erisida gishshas ne mala aadho erateththinne akeekay diza asi oonikka baawa. ");
INSERT INTO gmvl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tani nena ta keeththan shuumays; ta asay wuri nees azazettana; tani neeppe aadhdhanay ta kawoteththa algan xalla gidana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Hessa gishshas kawoy Yooseefe, «Beya! Tani nena Gibxe biitta ubbaa bollan shuumadis» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Hessafe guye kawoy ba kawoteththa qalabate ba biradhdhefe kessidi Yooseefe biradhdhen aaththides; qasseka Laynoppe dadettida may7o mayzidi iza qoodhenkka worqqa loota aaththides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Kawoy ba nam7anththo para-gaareza Yooseefe togisides; aylletikka, «Ziggite! Ziggite!» giidi izappe sinththara bida. Hessaththo ooththidi kawoy iza Gibxe biitta ubbaa bolla shuumides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Hessafe guye kawoy Yooseefe, «Tani kawo! Gido attiin neni qaaxxa gontta Gibxe biitta ubbaan oonikka kushe woykko toho qaaththenna» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Kawoy Yooseefe, «Xaafinaate-Pa7inaahe» gi sunththides; izi izas Oona geetettiza katama qeese Phixifaara nayo Asinaato machcho immides. Histtiin Yooseefey kumeththa Gibxe biittaa yuuyi xeellides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yooseefey Gibxe kawos ooththanaas doommiza wode izas layththay heedzdzu tamma. Qasse Yooseefey kawo sinththafe kezidi Gibxe biitta ubbaa yuuyi xeellides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","He laappun kalo layththatan biittay keehi daro kath immides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yooseefey Gibxe biittan he laappun kalo layththaa kath ubbaa shiishshidi katamatan minjjides. Issi issi katamata yuushon kaxxida kath ubbaa he kataman kataman minjjides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yooseefey abba shaamintta mala daro kath minjjides; kaththay wogappe dariin makkanaas dandaybeenna gishshas makki makki qolizayssa aggaagides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Laappun kosha layththay yaanaappe kase Oona geetettiza katamaa qeese Phixifaara nayo Asinaatippe Yooseefey nam7u attuma nayta yelides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yooseefey, «Xoossi tana ta metonne ta aawa soo asa ubbaa dogissides» gishe ba koyro naaza Minaase gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Nam7anththo naazakka, «Xoossi taas ta tuggatida biittan tana ayfissides» gishe Efreeme gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Gibxe biittan diza he laappun kalo layththati wurida. ");
INSERT INTO gmvl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Qasse Yooseefey kaseti yootida mala laappun kosha layththati doommida. Hara biitta ubbaan koshay dendides; gido attiin Gibxe biitta ubbaan kaththi dees. ");
INSERT INTO gmvl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Gibxe derey wuri koshattida wode asay, «Kath imma» gi kawos waassiin kawozi Gibxe asaa ubbaa, «Yooseefekko biidi izi yootizayssa ooththite» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Koshay Gibxe biittaa ubbaa gakkida wode Yooseefey kath minjjida keeththata ubbaa doydi kath Gibxe asaas bayzisides; gaasoykka koshay kumeththa Gibxen minnides. ");
INSERT INTO gmvl_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Sa7a ubbaan koshay suullida gishshas biittan diza asay wuri kath Yooseefeppe shammanaas Gibxe yides. ");
INSERT INTO gmvl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yaaqoobey Gibxen kaththi dizayssa siyidi ba attuma nayta, «Intte issoy issaara aazas xeeletteetii? ");
INSERT INTO gmvl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Be7ite! Gibxen kaththi dizayssa tani siyadis; duge Gibxe biidi nu hayqqontta paxa daana mala heeppe kath nuus shammi ehite» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Hessa gishshas Yooseefe ishati tammati kath shammanaas duge Gibxe bida. ");
INSERT INTO gmvl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Gido attiin Yaaqoobey Yooseefe ishaa Biniyaame izi qohettanaakko giidi qoppida gishshas iza ishatara yeddibeenna. ");
INSERT INTO gmvl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kanaane biittan wolqqama koshay diza gishshas kath shammana bizaytara Isra7eele attuma nayti Gibxe bida. ");
INSERT INTO gmvl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","He wode Yooseefey he biittaa ayssizaadenne biittan diza asaa ubbaas kath bayzisizay iza gidida gishshas Yooseefe ishati gakkida mala, ba hu7e biittan gaththidi izas ziggida. ");
INSERT INTO gmvl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yooseefey ba ishata be7ida mala erides shin izi istta erontta asa mala hanqo qaalan istta, «Intte awappe yidetii?» gi oychchides. Isttika, «Kath shammanaas, Kanaane biittafe yidos» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yooseefey ba ishata erides; istti gidikko iza eribeettenna. ");
INSERT INTO gmvl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Heerakka Yooseefey istta gishshas agumettida agumoza qoppidi isttas, «Intte dere xomosiza asa; intte nu biittan naagey leppiza baggay awayssako xeellanaas yideta» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Histtiin istti, «Nu godoo! Nuni dere xomosiza as gidokko; nuni ne aylleti kath shammanaas yidos. ");
INSERT INTO gmvl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nu wurikka issi aawa nayta. Nuni ne aylleti ammanettiza asa» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Histtiin Yooseefey isttas, «Gidekketa! Intte nu biittan naagoy leppiza baggay awayssako xomosi xeellana yideta» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Gido attiin istti, «Nuni ne aylleti tammanne nam7u ishatanne Kanaane biittan diza issi aawa nayta. Wurseththa kaaloy ha7i nu aawara dees; issoy gidikko dhaydes» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yooseefey isttas, «Tani inttes yootida malakka intte biitta xomosizayta. ");
INSERT INTO gmvl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Qasse intte paacettanay hayssana; tumuppe kawoy beyiin! Intte wurseththa kaalo ishay haa yontta ixxiko intte hayssafe beekketa. ");
INSERT INTO gmvl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Intte yootizayssi tumukkonne paaccanaas, inttefe issaade kiittite; izi intte ishaa ekki yo; attidayti qasho keeththan gam7eeta. Hessa mala gidontta aggiko kawoy beyiin! intte yuuyi yuuyi dere xomosiza asa» ");
INSERT INTO gmvl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","giidi istta heedzdzu gallassas qasho keeththan yeggides. ");
INSERT INTO gmvl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Heedzdzanththo gallassan Yooseefey isttas, «Tani Xoossas babbiza asa; intte issi miish ooththiko intte shemppo ashsheeta. ");
INSERT INTO gmvl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Intte tumukka ammanettiza as gidikko intte ishatappe issoy hayssan qasho keeththan do; attidayti gafida intteso asaas kath ekki biite; ");
INSERT INTO gmvl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Gido attiin intte qaalay tumu gidana malanne intte hayqqontta mala intte intte wurseththa kaalo ishaa taakko ekki yaanaas koshshees» gides. Isttika ha yo7ozan ero gida. ");
INSERT INTO gmvl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Istti issoy issaa, «Tumu nu ooththida geney nuna gakkides. Izi ba shemppos hanizaazi ixxiin nuna shoobbiza wode nuni siyishe ixxidos; ha waayey nuna gakkiday hessa gishshassa» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Oroobeeley, «Tani inttena, ‹Naaza bolla nagara ooththofte› gaada yootadis; gido attiin intte siyontta ixxideta. Histtiin ha7i iza suuththaa gomey nuna mootees» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Istti gizayssa Yooseefey erizayssa istti akeekibeettenna; ays giikko izi isttara wokkalen haasayees. ");
INSERT INTO gmvl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Izi isttafe shaaketti guye simmidi yeekkides; gido attiin qasse isttako simmidi istta haasayssides. Izi Simoona isttafe duuththi ashshidi istti be7ishin iza qachchides. ");
INSERT INTO gmvl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yooseefey ba aylleta, «Kath istta ogoro kunththite; istta biraakka zaaridi istta ogoron ogoron yeggite; qasse isttas oge shinqe immite» gi azazides. ");
INSERT INTO gmvl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Istti izi gida mala ooththidaappe guye Yooseefe ishati kaththaa ba haretan caanidi dendi bida. ");
INSERT INTO gmvl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Istti oge bolla qamma aqanaas shempidason isttafe issay ba harezas kaththaafe yegganaas ba ogoro birshidi, ogoroza doonan diza ba biraa demmides. ");
INSERT INTO gmvl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Izi ba ishata, «Ta biray taas simmides; tuma hayssa be7ite! Ta ogoron dees» gides. Istti dagammidi kokkorishe issoy issaakko simmidi, «Xoossi aazas nu bolla hayssa ooththidee?» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Istti Kanaane biittan diza ba aawa Yaaqoobekko soo simmi yiidi ba bolla gakkidayssa ubbaa izas yootida. ");
INSERT INTO gmvl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Istti izas, «He biittays godaa gidida addezi nuna babisides; hessafe guye izi nuna he biittaa yuuyi yuuyi xomosi xeelliza asa mala ooththi godatides. ");
INSERT INTO gmvl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Gido attiin nuni izas, ‹Nu ammanettiza asa; dere xomosi xeelliza as gidokko. ");
INSERT INTO gmvl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nuni tammanne nam7u ishati issi aawa nayta; issoy dhaydes; wurseththa kaaloy Kanaane biittan ha7i nu aawara dees› gi yootidos. ");
INSERT INTO gmvl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Histtiin he biittays godaa gidida addezi nuna, ‹Intte ammanettiza as gididayssa tani hayssan erana; intte ishatappe issaa haan ta achchan yeggidi gafida intte soo asaas kath ekki biite. ");
INSERT INTO gmvl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Intte dere yuuyi yuuyi xomosizaade gidontta, ammanettiza as gididayssa tani erana mala, intte wurseththa kaalo ishaa taakko ekki yiite. Histtiko tani haan attida intte ishaa inttes zaara immana; intteka ha biittan zal7ana dandayeeta› gides» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Istti ba ogoroppe ogoroppe kaththaa qolidi ba ogoron ogoron biray qashora uttidayssa demmida. Isttinne istta aaway he qashora diza biraa be7idi babbida. ");
INSERT INTO gmvl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Istta aawa Yaaqoobey isttas, «Intte tana ta naytappe mela kessideta; Yooseefey baawa, Simooni baawa; qasse intte Biniyaame efana koyeeta. Wuri taas dhuma girdi gides» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Hessafe guye Oroobeeley ba aawaa, «Tani Biniyaame nees zaara ehontta aggiko ta attuma nayta nam7atakka wodha; tana ammanettada iza ta kushen imma; qasse tani iza zaarada ehana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Gido attiin Yaaqoobey isttas, «Ta naazi inttenara duge beenna; iza ishay hayqqiin attiday iza xalla; intte efishin ogen iita miishshi iza gakkizaa gidikko intte tana yeehoranne muuzora duufon efana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ha7ikka koshay Kanaane biittan minnides. ");
INSERT INTO gmvl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Histtiin istti Gibxeppe ehida kaththay mulera wuriin istta aaway, «Qasseka guye biidi nuus guuththa kath shammite» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Gido attiin Yuhuday izas, «He addezi nuna, ‹Intte isha inttenara ekki yontta aggiko ta ayfeso nam7anththo be7ekketa› giidi lo7eththi yootides. ");
INSERT INTO gmvl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Neni nu ishaa nunara yeddiko nuni duge biidi nees kath shammana. ");
INSERT INTO gmvl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Gido attiin neni iza yeddontta ixxiko nuni duge bookko; ays giikko he addezi nuna, ‹Intte isha inttenara ehontta aggiko intte ta ayfeso nam7anththo be7ekketa› gides» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Isra7eeleykka, «Intte, ‹Nuus hara ishay dees› gi yootidi hayssa ha metoza ta bolla ays ehidetii?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Isttika izas, «He addezi nu gishshassinne nuso asaa gishshas lo7eththi oychchides. Izi nuna, ‹Intte aaway ha7ikka paxa dizee? Inttes hara ishay dizee?› gi oychchiin nuni izi oychchida oyshozas zaaro immidos. Izikka nuna, ‹Intte ishaa duge haa ekki yiite› gaanayssa nuni aazan erinoo?» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuhuday ba aawa Isra7eele, «Nunikka, nenikka, nu naytikka hayqqontta paxa daana mala naaza tanara yedda; nuni ha7i elelidi baana. ");
INSERT INTO gmvl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Naaza nuus ta waaseteththan imma; iza gishshas tana oychcha; tani iza nees lo7ora zaara ehontta aggiko ta diza wode ubbaan ta oyshettana. ");
INSERT INTO gmvl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nuni haan gam7onttaako hanni wode nam7anththo gede gakkidi ha simmana shin» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Hessafe guye istta aawa Isra7eeley isttas, «Hessa gidikko histtite; he addezas kushe genththo miish nu biittan mokkiza miish ubbaafe lo7izayssa doorite; hessika shitto, ees, sawo, karbbe, miththa ayfeta intte ogoron yeggi ekki biite. ");
INSERT INTO gmvl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Intte ogoro doonan simmida birazi baletan simmidaaz gidana dandayza gishshas biraakka nam7u kushe histti ekki biite. ");
INSERT INTO gmvl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Qasse intte ishaakka ekkidi he addezakko eeson guye biite. ");
INSERT INTO gmvl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Izi hankko intte ishaa yeddana mala Biniyaameykka inttenara simmi yaana mala Ubbaa Dandayza Xoossay he addezi inttes qadhettana mala ooththo; tani gidikko ta naytappe mela attikonne attays» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Hessa gishshas he asati kushe genththo kase biraas nam7u kushe qasse Biniyaame ekkidi duge Gibxe biidi Yooseefe sinth shiiqida. ");
INSERT INTO gmvl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yooseefey ba ishatara Biniyaame be7idi ba keeththa halaqaza, «Ha asata taso ekkada ba; hachcha gallas istti tanara quma maana mala mehe shukkada giigsa» gi azazides. ");
INSERT INTO gmvl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Histtiin izi Yooseefey izas yootida mala he asata Yooseefeso efides. ");
INSERT INTO gmvl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Asati Yooseefe soo bida gishshas babbida; isttas, «Istti nuna hayssa ehiday koyro nu ogorora simmi bida biraa gishshas gidontta aggenna; izi nuna qohanaas aylleteththan haaranaassinne nu hareta ekkanaas hanees» gi qoppida. ");
INSERT INTO gmvl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Hessa gishshas istti Yooseefe keeththaa penge gakkidi keeththaa halaqaza, ");
INSERT INTO gmvl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«Nu godoo! Nuni koyro kath shammanaas haa yidos; ");
INSERT INTO gmvl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","simmidi bishe nu aqizaason omars nu ogoro ogoro nu birshiin nu biray paccontta nu ogoro ogoro doonan dizayssa demmidos; hessa gishshas ha7i nuni iza guye ekki yidos. ");
INSERT INTO gmvl_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Qasse nuni kath shammanaas hara biraakka ekki yidos. Nu biraa nu ogoro ogoro doonan ooni woththidaakko nu erokko» gi haasayssida. ");
INSERT INTO gmvl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Histtiin izi isttas, «Aykkoy baa hessas babofte! Intte Xoossi intte aawa Xoossi intte ogoro giddon inttes bira immides; tani intte biraa ekkadis» gides. Hessafe guye Simoona isttako kessides. ");
INSERT INTO gmvl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","He addezi he asata Yooseefe soo efidi istta tohos haath ehiin ba toho meecettida. Istta haretaska harqqo immides. ");
INSERT INTO gmvl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Yooseefera quma maana mala isttas yootettida gishshas Yooseefey yaana gakkanaas izas immana kushe genththo giigsida. ");
INSERT INTO gmvl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yooseefey baso gelida mala istti ba giigsida kushe genththoza izas immidi iza sinththan ba hu7e duge biittan gaththi ziggida. ");
INSERT INTO gmvl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Izi istta saroteth oychchi simmidi, «Intte taas yootida intte cima aaway lo7i dizee? Ha7ikka izi paxa dizee?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Histtiin istti, «Ee, ne aylley nu aaway ha7ikka paxa dees; izi lo7okko» gi hokki izas ziggida. ");
INSERT INTO gmvl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Izi ba aayey naa Biniyaame be7idi isttas, «Intte yootida intte wurseththa kaalo ishay hayssee?» gides. Qasse izi Biniyaame, «Ta naazoo Xoossi nena anjjo» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yooseefey ba ishaa be7iin izas yeehoy dandayettontta ixxiin yeekkanaas issife issiso pooqqides. Izi ba dumma qol7a gelidi heen yeekkides. ");
INSERT INTO gmvl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Izi ba ayfeso meecetti simmi kezidi barkka bana minththeththidi, «Quma haa aaththite!» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Histtiin istti izas dumma, iza ishatas dumma, heen izara miza Gibxe asatas dumma aaththida; ays giikko Gibxe asay Ibraawe asaara issife mi erettenna. Hessika Gibxe biitta asaas tunateththa. ");
INSERT INTO gmvl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Istti Yooseefe sinththan bayray ba bayrateththaa mala kaaloy ba kaaloteththa mala maaran uttida. Istti issoy issaa xeellidi istta wostti utissidaakko be7idi malalettida. ");
INSERT INTO gmvl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yooseefey ba gishaappe isttas qumaa gishiza wode, Biniyaame gakkidayssi haratayssafe ichchashu kushe darees; histtiin istti ufayettishe izara midanne uyida. ");
INSERT INTO gmvl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yooseefey ba keeththaa halaqazas, «Neni ha asata ogoroy ekkiza keena kath isttas kunththa; istta bira ubbaa istta ogoro ogoro doonan woththa; ");
INSERT INTO gmvl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Histtada wurseththa kaaloza ogoro doonan ta bira wancanne iza kaththa biraa woththa» gi azaziin izi Yooseefey gida mala ooththides. ");
INSERT INTO gmvl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Gadey wontishin he asati ba hareta ekkidi baana mala moyzida. ");
INSERT INTO gmvl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Istti he katamappe kezidi haakki biichchontta dishin Yooseefey ba keeththaa halaqaas, «Denda! Ha asata guye kaalla; neni ba istta gakkada, ‹Intte ays kiya gishshas iita zaaridetii?› ");
INSERT INTO gmvl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","‹Ays ta godaa bira wanca kaysidetii? Hayssi ta goday uyizayssanne qasse xuura miish demmiza wanca gidennee? Hayssi intte ooththidayssi gita qoho› ga» gides. He wode Gibxe biitta asati wanca garsan diza ushshaa be7idi sinththafe aazi hananaakko ereettes. ");
INSERT INTO gmvl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Histtiin izi istta guyera gakkidi izi gida malakka isttas yootides. ");
INSERT INTO gmvl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Gido attiin istti, «Nu goday aazas hayssa mala qaala nu bolla haasayzee? Hessa mala miish oosoy nuuppe ne aylletappe haakko! ");
INSERT INTO gmvl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Haray attoshin hayssafe kase nu ogoro doonappe demmida biraa Kanaane biittafe guye nees nu zaari ehidayssa ne eraasa. Histtiin ha7i nuni ne godaa sooppe wosttidi bira woykko worqqa kaysizonii? ");
INSERT INTO gmvl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ne aylleta nu giddofe he wancay izakkon beettidaadey hayqqo; qasse attida nuni nu godaas aylle gidana» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Izi isttas, «Hessa mala gidikko lo7o; intte gida mala gido; wancaza ekkida uray oonikka ta aylle gidana; hankko attida intte gidikko sarora baana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Hessafe guye istti eeson ba ogoro ogoro woththi birshida. ");
INSERT INTO gmvl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Halaqazikka ubbaafe bayratizayssa ogoroppe doommidi wurseththa kaalozayssa gakkanaas koyides; he wancazakka Biniyaame ogoro giddofe demmides. ");
INSERT INTO gmvl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Histtiin istti muuzottidi ba may7o daakkida; ba ogoro ogoro ba haretan caanidi guye katamaa simmida. ");
INSERT INTO gmvl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuhuday ba ishatara Yooseefekko geliza wode Yooseefey soon dizayssa demmidi istti iza sinththan gufannida. ");
INSERT INTO gmvl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yooseefey isttas, «Intte ay pala miish ooththidetii? Ta mala asi xuura miishshi hessaththo demmizayssa erekketiyee?» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Histtiin Yuhuday, «Nu godaas nu ay gaanee? Nuni ay haasayanee? Woykko nuni xilloteth wostti bessanee? Xoossi ne aylleta mooro qonccisides. Histtiin nunakka gidiin he wancay izappe beettidayssika gidiin ta godaas aylle gidana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Gido attiin Yooseefey, «Hessa mala miish oosoy taappe haakko; ta bira wancazi izappe beettida addezi xalla ta aylle gidana. Histtiko intte intte aawaakko guye saron simmite» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Histtiin Yuhuday izakko shiiqidi iza, «Ta godoo! Tani issi qaala haasayana mala nena woossays; ne kawo Paaroone mala gidikkoka tana ne aylleza bolla hanqettofa. ");
INSERT INTO gmvl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Neni ta goday nuna ne aylleta, ‹Inttes aaway dizee woykko ishay dizee?› ga oychchadasa. ");
INSERT INTO gmvl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nunikka, ‹Nuus cimmida aaway dees; izi cimmidi yelida kaalo naykka dees; he naaza ishay hayqqides; ba aayeeys issi iza xallay attides; aawaykka iza keehi siiqees› gi nees yootidos. ");
INSERT INTO gmvl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","«Nekka ne aylletas nuus, ‹Tani iza beyana mala taas ekki yiite› gadasa. ");
INSERT INTO gmvl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nuni nu godaas nees, ‹Ee naazi ba aawappe shaakettanaas dandayenna; shaakettiko iza aaway hayqqana› gidos. ");
INSERT INTO gmvl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Gido attiin neni ne aylleta, ‹Intte kaalo ishay inttenara duge yontta ixxiko nam7anththo ta ayfeso beyekketa› gadasa. ");
INSERT INTO gmvl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Nuni ne aylleti nu aawaakko simmi bida wode ne nu goday nuus gidayssa izas yootidos. ");
INSERT INTO gmvl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","«Nu aaway, ‹Ha7ikka simmi guye biidi guuththa kath gujji shammite› giin, ");
INSERT INTO gmvl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nuni izas, ‹Nuus kaalo ishay nunara biikkofe attiin guye baanaas dandayokko; ays giikko nu kaalo ishay nunara bontta gidikko nuni he addeza ayfeso beyanaas dandayokko› gidos. ");
INSERT INTO gmvl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","«Histtiin nu aaway ne aylleta nuna, ‹Ta machcha Eraheela taas nam7u attuma nayta yelidayssa intte ereeta; ");
INSERT INTO gmvl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Isttafe issoy taappe shaaketti biin tumu iza do7ay puuzereththi mides; hach gakkanaaska tani iza beyabeekke. ");
INSERT INTO gmvl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Hayssa qasse intte taappe shaakki efiin iita miishshi iza gakkiko intte cimateththan ta bolla ehiza mishay tana wodhana› » gides. ");
INSERT INTO gmvl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","«Hessa gishshas ha7i ta ne aylley guye ta aawaakko biza wode ta aaway naaza ba shemppo mala siiqizayssi, naazi nunara donttayssa beykko hayqqana. Nuni ne aylleti nu aawaa cimateth kayora duufon yeggana. ");
INSERT INTO gmvl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Tani ne aylley naaza ta waaseteththan ekka yadis; tani iza, ‹Aabboo, tani iza nees saron zaarada ehontta aggiko ta layththa kumeththan ta oyshettana!› ga yoota woththadis. ");
INSERT INTO gmvl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","«Hessa gishshas tani ne aylley ta godaas naaza gishshas aylletada haan attiin naazi ba ishatara guye simmo. ");
INSERT INTO gmvl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Naazi baynda tani waanada guye ta aawaakko simma boo? Hanenna; ta aaway mishettana miishshaa tana bessofa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","He wode Yooseefey he asaa ubbaa sinththan genccana dandayontta gishshas, «Asa ubbaa ta sinththafe kessite» gi waassides. Hessa gishshas Yooseefey bana ba ishatas erisishin ishatappe attiin haray izara oonikka deenna. ");
INSERT INTO gmvl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Izi ba qaala dhoqqisidi Gibxe asay iza siyana gakkanaas waassi yeekkides. Kawoza soo asaykka he woreza siyides. ");
INSERT INTO gmvl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yooseefey ba ishatas, «Tani Yooseefekko! Ta aaway hanno gakkanaas paxa dizee?» gi oychchides. Gido attiin iza ishati daro dagammida gishshas izas malthe zaaranaas dandaybeettenna. ");
INSERT INTO gmvl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Histtiin Yooseefey ba ishatas, «Taakko haa shiiqite» gides. Isttika izakko shiiqiin izi isttas, «Tani intte Gibxe biittas bayzida intte ishaa Yooseefekko, ");
INSERT INTO gmvl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Xoossi tana inttefe sinththe kiittiday asa shemppo ashshanaas gidida gishshas intte tana haa bayzidayssas zil7ettofte. ");
INSERT INTO gmvl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Koshay ha biittaa geliin hayssi nam7anththo layththa; qasse sinththafe yiza ichchashu layththata giddon asay biitta goyidi kath shiishshanaas dandayenna. ");
INSERT INTO gmvl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Gido attiin tani inttes zereth biitta bolla ashshana malanne intte shemppo hayssa mala gita atoteththan ashshana mala, Xoossi tana inttefe sinththe ha kiittides. ");
INSERT INTO gmvl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Hessa gishshas tana haa kiittiday Xoossaa attiin inttena deekketa. Xoossi tana Gibxe kawos aawa, iza aqo ubbaas godaanne Gibxe biitta haarizaade ooththides» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","«Ha7i eeson guye ta aawaakko biidi izas ne naa Yooseefey, ‹Xoossi tana Gibxe biitta ubbaa bolla godaa kessides; hessa gishshas gam7ontta taakko haa ya. ");
INSERT INTO gmvl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Neni ta matan Geeseme biittan ne naytara, nayta naytara, dorsatara, mehetara, nees diza ubbaara haan daandeta. ");
INSERT INTO gmvl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Buroppe ichchashu kosha layththati deettes; nena neso asaanne ne mehe koshay gakkontta mala tani nena mizana› gees giite» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Qasseka Yooseefey isttas, «Ha inttenara haasayzayssi tumu tani Yooseefe gididayssa intteka, ta ishaa Biniyaameykka intte ayfen be7eeta. ");
INSERT INTO gmvl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Taas Gibxe biittan diza bonchcho intte be7idayssa ubbaa ta aawaas yootite; eesonkka haa duge ekki yiite» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Histtidi ba ishaa Biniyaame idimmi oykkidi yeekkides; Biniyaameykka ba ishaa idimmi oykkidi yeekkides. ");
INSERT INTO gmvl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yooseefeykka yeekkishe ba ishata ubbaa yeeri yeeri ekkides. Hessafe guye iza ishati izara haasaya oykkida. ");
INSERT INTO gmvl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Yooseefe ishata yuussa worey kawo Paaroone keeth gakkida wode kawoynne iza oosanchchati ufayettida. ");
INSERT INTO gmvl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kawoy Yooseefe, «Neni ne ishata, ‹Intte mehe caanidi Kanaane biitta simmite; ");
INSERT INTO gmvl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Histtidi intte aawaanne intte soo asaa ekkidi guye taakko haa ehite. Tani inttes Gibxe biittan ubbasoppe lo7izaso immana; isttika ha biittaa modhdho kaachana› ga. ");
INSERT INTO gmvl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Qasseka neni ne ishata, ‹Para-gaareza intte naytassinne intte maccassatas Gibxeppe ekki biidi intte aawaakka ekki yiite. ");
INSERT INTO gmvl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Gibxe biittan diza ubbaafe aadhdhi lo7iza miish inttes gidana gishshas inttes diza haaro ekki yaana qoppofte› ga yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Histtiin Yaaqoobe nayti gida mala ooththida. Yooseefeykka kawoy azazida mala para-gaaretanne oges gidiza shinqe isttas immides. ");
INSERT INTO gmvl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Isttas ubbaasikka hu7en hu7en ooraththa may7o immides; gido attiin Biniyaames heedzdzu xeetu saqile biranne ichchashu kumeththa may7o immides. ");
INSERT INTO gmvl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Izikka ba aawaas Gibxen diza ubbaafe lo7izayssa tammu haren caanidi, qasse oges kath, ukeththinne hara shinqe tammu macca haretan caanidi yeddides. ");
INSERT INTO gmvl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Yooseefey ba ishata moyzides. Istti bishin izi isttas, «Bishe ogen intte garsan ooyettofte» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Istti Gibxeppe kezidi bida; Kanaane biitta biidi ba aawa Yaaqoobekko gakkida. ");
INSERT INTO gmvl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Istti izas, «Yooseefey paxa dees! Qasseka izi Gibxe biitta ubbaa haarees» giin Yaaqoobe wozinay dagammida gishshas istta ammanibeenna. ");
INSERT INTO gmvl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Gido attiin istti Yooseefey baas yootidayssa ubbaa izas yootininne iza ekki ehana mala Yooseefey kiittida para-gaareta izi beyiin, istta aawa Yaaqoobes shemppoy simmides. ");
INSERT INTO gmvl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Yaaqoobeykka, «Hessi taas gidana; ta naazi Yooseefey hanno gakkanaas paxa dees! Tani hayqqanaappe sinththan baada iza beyana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Isra7eeley baas dizayssa ubbaa ekki dendidi Bersaabehe gakkides. Heenkka izi ba aawa Yisaaqa Xoossaas yarsho shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Xoossi omars agumora iza, «Yaaqoobe, Yaaqoobe» gi xeygiin izi, «Yee!» gi koyides. ");
INSERT INTO gmvl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","«Tani Xoossay ne aawa Xoossa; neni duge Gibxe baanaas babbofa; ays giikko tani nena heen gita kawoteth kessana. ");
INSERT INTO gmvl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Tani nenara issife Gibxe baana; qasse tani ne zereththaa heeppe kessana. Yooseefey ba kushera ne hayqqishin nena shiishshana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Hessafe guye Yaaqoobey Bersaabeheppe dendides; Yaaqoobe attuma nayti ba aawa Yaaqoobe, ba naytanne ba machcheta Gibxe kawoy isttas kiittida para-gaare togisi ekki bida. ");
INSERT INTO gmvl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Istti Kanaane biittan haarida aqonne mehe ubbaa ekki bida. Yaaqoobeynne iza zereththi wuri izara Gibxe bides. ");
INSERT INTO gmvl_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Izikka ba zereth ubbaa ba attuma nayta, ba macca naytanne nayta nayta ubbaa banara Gibxe ekki bides. ");
INSERT INTO gmvl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yaaqoobera Gibxe biitta bida Isra7eele nayta sunththi hayssafe kaalli xaafettidayssa. Yaaqoobe bayra nay Oroobeele; ");
INSERT INTO gmvl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Oroobeele attuma nayti Heenooke, Paalu, Hexiroomenne Karme. ");
INSERT INTO gmvl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simoona attuma nayti Yimu7eele, Yaamine, Ohaade, Yaakine, Xoohaarenne Kanaane maccassay naa Sa7oole. ");
INSERT INTO gmvl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewe attuma nayti Gershoone, Qa7aatenne Meraare. ");
INSERT INTO gmvl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuhuda attuma nayti Eera, Oonaane, Seela, Paareesenne Zaraahe; gido attiin Eeraynne Oonaaney Kanaane biittan hayqqida. Paareese attuma nayti Hexiroomenne Hamule. ");
INSERT INTO gmvl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Yisakoore attuma nayti Tola, Puuwa, Yaashubenne Shimiroone. ");
INSERT INTO gmvl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zaabiloone attuma nayti Sereede, Eeloonenne Yaahile7eele. ");
INSERT INTO gmvl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Hayti Liyay Mesphexoomiyan Yaaqoobes yelida attuma nayta; izi macca naya Diino. Hayti iza naytinne nayta nayti mulera heedzdzu tammanne heedzdza. ");
INSERT INTO gmvl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gaade attuma nayti Xafoone, Hagge, Shuune, Exiboone, Ere, Aroodenne Ar7eele. ");
INSERT INTO gmvl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aaseere attuma nayti Yimine, Yishiwa, Yishiwenne Barihe; istta michcheyakka Seraho. Barihe attuma nayti Heeberenne Malkki7eele. ");
INSERT INTO gmvl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Laabay ba naa Liyas immida Zilfay Yaaqoobes yelida nayti nayta nayti hayta; istti mulera tammanne usuppuna. ");
INSERT INTO gmvl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yaaqoobe machcheyo Eraheeli attuma nayti Yooseefenne Biniyaame. ");
INSERT INTO gmvl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Oona geetettiza katama qeese Phixifaara naya Asinaata Yooseefes Gibxen Minaasenne Efreeme yeladus. ");
INSERT INTO gmvl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Biniyaame nayti Beela, Bekere, Ashibeele, Geera, Na7imaane, Eehe, Orooshe, Muppiime, Huppimenne Araade. ");
INSERT INTO gmvl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Yaaqoobes yelettida Eraheeli attuma naytinne nayta nayti hayta; istti mulera tammanne oydda. ");
INSERT INTO gmvl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Daane attuma nay Hushime. ");
INSERT INTO gmvl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Niftaaleme attuma nayti Yahixele, Gune, Yexirenne Sheleme ");
INSERT INTO gmvl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Laabay ba naa Eraheelis immida Bilihay Yaaqoobes yelida naytinne nayta nayti hayta; istti mulera laappuna. ");
INSERT INTO gmvl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yaaqoobera Gibxe bida naytinne nayta nayti, iza nayta machcheta gujjontta mulera usuppun tammanne usuppuna. ");
INSERT INTO gmvl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Gibxen Yooseefes yelettida nam7u nayta gujjiin Gibxe bida Yaaqoobe soo asay mulera laappun tamma. ");
INSERT INTO gmvl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Sinththati biidi Geeseme biittan bana mokkana mala Yaaqoobey Yuhuda baappe sinththe Yooseefekko yeddides; istti Geeseme gakkida wode, ");
INSERT INTO gmvl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yooseefey ba para-gaareza giigsidi ba aawaa Yaaqoobera gaagganaas Geeseme bides. Yooseefey ba aawa demmida mala idimmi oykkidi daro saate yeekkides. ");
INSERT INTO gmvl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isra7eeley Yooseefe, «Neni paxa dishin tani ne ayfeso be7ida gishshas hi7a tani hayqqiko metenna» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Hessafe guye Yooseefey ba ishatassinne ba aawa soo asatas, «Tani Gibxe kawozaakko baada izas, ‹Kanaane biittan diza ta ishatinne ta aawa soo asay taakko yida. ");
INSERT INTO gmvl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Istti miizinne dorsa haarizayta; istti banara ba dorsata, ba miizatanne baas dizayssa ubbaa ekki yida› gaana. ");
INSERT INTO gmvl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kawoy inttena xeygidi, ‹Intte oosoy aazee?› gi oychchiko, ");
INSERT INTO gmvl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","intte izas, ‹Nuni ne aylleti naateththafe doommidi nu aawata malakka mehe heemmoos› giite. Histtiko izi inttena Geeseme biittan woththana; ays giikko dorsa heenththanchchay wuri Gibxe asaa achchan kadhettidayta» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yooseefey gelidi Gibxe kawos, «Ta aawaynne ta ishati ba dorsatara, ba miizatara baas dizaaz ubbaa ekkidi Kanaane biittafe yiidi, ha7i Geeseme biittan deettes» gi yootides. ");
INSERT INTO gmvl_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Izi ba ishatappe ichchashata dooridi kawoza sinth aaththides. ");
INSERT INTO gmvl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kawoy he ishata, «Intte oosoy aazee?» gi oychchiin istti kawozas, «Nuni ne aylleti nu aawataththo dorsa heemmoos» gi yootida. ");
INSERT INTO gmvl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Qasse istti izas, «Kanaane biittan koshay darida gishshas nuus ne aylleta mehetas miza miishshi aykkoka baynda gishshas, nuni hayssan imaththateththan daana yidos; shoobbe nuna ne aylleta Geesemen woththarkkii!» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kawoy Yooseefe, «Ne aawaynne ne ishati neekko yida. ");
INSERT INTO gmvl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Histtiin Gibxe derey ne kushen dees gidennee; ha biittan ubbaafe aadhdhidi lo7izason ne aawaanne ne ishata woththa; istti Geeseme biittan detto. Istta giddofe dumma erateththi dizayta ne erizaa gidikko heyta ta meheta bolla shuuma» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Hessafe guye Yooseefey ba aawaa Yaaqoobe gelththidi kawo sinth aaththides. Yaaqoobey Gibxe kawo anjjides. ");
INSERT INTO gmvl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Kawoykka Yaaqoobe, «Nees aappun layththee?» gi oychchides. ");
INSERT INTO gmvl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yaaqoobey kawozas, «Tani yuuya yuuya deyida layththay 130; ta layththay beni ta aawati yuuyi yuuyi deyida layththatappe guuththanne metoy darida layththa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Hessafe guye Yaaqoobey kawoza anjjidi iza sinththafe kare kezides. ");
INSERT INTO gmvl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yooseefey ba aawaanne ba ishata Gibxe biittan woththides; kawoy azazida mala Gibxe biittan Eraamise achchan diza ubbasoppe aadhdhidi lo7iza gade isttas immides. ");
INSERT INTO gmvl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yooseefey qasse ba aawaas, ba ishatassinne ba aawa soo asaa ubbaas istta nayta qooda mala kath immides. ");
INSERT INTO gmvl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Gidikkoka koshay darida gishshas biitta ubbaa bolla kaththi dhaydes. He koshaan Gibxe dereynne Kanaane derey nam7ayka qohettida. ");
INSERT INTO gmvl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yooseefey Gibxe kath bayzidi Gibxeninne Kanaane biittan diza miish ubbaa shiishshidi Gibxe kawo keeth gelththides. ");
INSERT INTO gmvl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Gibxe miishshaynne Kanaane miishshay ubbay wuriin Gibxe asay wuri Yooseefekko yiidi iza, «Nuus kath imma; nu miishshay wurida gishshas nuni ne dishin ays hayqqizonii?» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Histtiin Yooseefey isttas, «Intte mehe ekki yiite; intte miishshay wuridaa gidikko tani kath inttes mehera laammana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Hessa gishshas istti ba mehe Yooseefes ehiin Yooseefey istta para, dorsa, deyshe, miizinne hare kaththara laammides; izi he layth istta mehe ubbaara kath laammi laammi mizi shaachchides. ");
INSERT INTO gmvl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","He layththay wuriin nam7anththo layththan istti izakko yiidi izas, «Nuni nu godaappe qottiza miishshi deenna; nu miishshay wurides; nuus diza mehekka ubbaa nees sheedhdhidos; nu godaas nees nunateththafenne nu gadeppe attiin nu immana miishshi haray deenna. ");
INSERT INTO gmvl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ne dishin nu ays hayqqizonii? Nu gadeykka ays dhayzee? Nunakka nu gadezakka kaththara laamma; nuni kawos aylletana; nu gadeykka izas gido; nuni hayqqontta de7on daana malanne nu gadeykka oxxontta mala zereth nuus imma» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yooseefey Gibxe biitta ubbaa kawos shammides. Gibxeti wuri koshay minnida gishshas ba gadeza bayziin gadezi kawos gidides. ");
INSERT INTO gmvl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yooseefey Gibxe asa ubbaa ha gaxappe doommidi he gaxa gakkanaas kawos aylle kessides. ");
INSERT INTO gmvl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Gidikkoka kawoy qeesetas kath immiza gishshas qeeseta gade shammibeenna. Hessa gishshas qeeseti ba gade bayzibeettenna. ");
INSERT INTO gmvl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yooseefey asaa, «Histtiin hach tani inttenanne intte gade kawos shammida gishshas zereth ekkidi intte gaden gaden zerite. ");
INSERT INTO gmvl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Gido attiin kath maxi gelththiza wode kaththaafe ichchashu kusheppe issi kushe kawos immite. Ichchash kusheppe attida oyddu kushezi intte gades zereth, intteso asaassinne intte naytas quma gido» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Histtiin istti, «Neni nuna ashshadasa! Nu godaa sinththan nuni nashettidaa gidikko nu kawos aylle gidana» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Hessa gishshas Yooseefey Gibxe biittan kaxxida kaththaas ichchash kusheppe issi kushe kawos immizayssi woga gidana mala ooththides. He wogazikka hach gakkanaas eqqi dees. Kawos gidontta gadey qeeseta gade xalla. ");
INSERT INTO gmvl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Isra7eeleti Gibxe biittan Geeseme geetettizason uttida; istti heen aqota demmida; istti yelettidanne daro corattida. ");
INSERT INTO gmvl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yaaqoobey Gibxe biittan 17 layth de7ides. Yaaqoobey de7ida layththay issi xeetanne oyddu tammanne laappuna. ");
INSERT INTO gmvl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Yaaqoobes hayqo wodey matiin ba naa Yooseefe xeygisidi, «Tani ne sinththan sabettidaa gidikko ne kushe ta gulbate bolla woththada neni taas kiyattanaassinne ammanettanaas ane caaqqa. Tana Gibxen moogoppa. ");
INSERT INTO gmvl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Gido attiin tani ta aawatan gaaggiza wode tana Gibxeppe efada istti moogettidason mooga» gides. Histtiin Yooseefey, «Tani nena neni gida mala ooththana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yaaqoobey iza, «Ane taas caaqqa» gides. Yooseefeykka izas caaqqides; hessafe guye Yaaqoobey ba hiixan gufannidi Xoossas goynnides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Hessafe guye asay Yooseefes, «Ne aaway sakettees» gi yootiin izi ba nam7u attuma nayta Minaasenne Efreeme ekki bides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Asay Yaaqoobe, «Beya! Ne nay Yooseefey neekko yides» giin Isra7eeley minettidi ba hiixa bolla dendi uttides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yaaqoobey Yooseefe, «Ubbaa Dandayza Xoossi Kanaane biittan Looza geetettizason taas qonccidi heen tana anjjides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Izi tana, ‹Ta nees yelo immana ne yelotakka darsana; tani nena daro dere histtana. Ha biittaa tani neeppe guye ne zereththas mernaas laata biitta histta immana› gides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","«Histtiin ha7i ne nam7u attuma nayti tani neekko hayssa yaanaappe kase Gibxen nees yelettidayti tayta; Efreemeynne Minaasey taas Oroobeelenne Simoona mala. ");
INSERT INTO gmvl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Isttafe guye nees yelettidayti ne nayta; istti laattana derey Efreemenne Minaase sunththan summo. ");
INSERT INTO gmvl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Tani Mesphexoomiyappe simmishin Efraata geetettiza dere gakkana gishin Eraheela Kanaane biittan hayqqiin tani izo Beeteliheeme geetettiza Efraata efiza oge doonan moogadis» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Isra7eeley Yooseefe attuma nayta nam7ata be7idi, «Hayti oonee?» gi oychchides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yooseefeykka ba aawaas, «Hayti Xoossi taas haan hayssan immida ta nayta» gides. Histtiin Isra7eeley, «Ta istta anjjana mala taakko haa shiishsha» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yaaqoobey cimmiin iza ayfey daaburda gishshas demmanaas dandaybeenna. Hessa gishshas Yooseefey ba attuma nayta izakko shiishshiin iza aaway istta idimmidi yeerides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Yaaqoobey Yooseefe, «Tani ne ayfeso beyana gaada qoppabeekke; gido attiin Xoossi hekko ne naytakka tana bessides» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yooseefey istta Yaaqoobe gulbate bollafe denththidi ba hu7e biitta gaththi ziggides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yooseefey ba nam7u attuma nayta ekkidi Efreeme ba ushachcha baggan Yaaqoobes hadirsa baggara, Minaase ba hadirsa baggan Yaaqoobes ushachcha baggara izakko shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Gido attiin Yaaqoobey ba kushe yaanne haa qaaseththi aaththidi ba ushachcha kushe kaalo naaza Efreeme hu7e bolla, ba hadirsa kushe bayra naaza Minaase hu7e bolla woththides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Hessafe guye Yaaqoobey Yooseefe, «Ta aawati Abrahaameynne Yisaaqi iza sinththan suuren de7ida Xoossi, ta de7o ubbaan hach gakkanaas tana heemmida Xoossi, ");
INSERT INTO gmvl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","iita miishsha ubbaafe tana ashshida kiitanchchay, ha nayta anjjo. Ta sunththaynne ta aawata Abrahaamenne Yisaaqa sunththay isttan xeygetto. Istti biitta bollan corattetto» gi anjjides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yooseefey ba aaway ba ushachcha kushe Efreeme hu7e bolla woththidayssa dosibeenna. Hessa gishshas Efreeme hu7e bollafe denththidi Minaase hu7e bolla woththanaas ba aawa kushe oykkides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yooseefey ba aawaas, «Aabboo hessaththo deenna! Bayray hayssa gidontta gishshas ne ushachcha kushe hayssa bolla woththa» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Gido attiin iza aaway ixxidi izas, «Ta naazoo! Ta erays; izikka gita dere gidana. Gidikkoka kaalo ishay izappe aadhdhi gitatana; iza zereththayka daro gita kawoteth gidana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Izi he gallas istta anjjidi, «Isra7eele nayti anjjo anjjiza wode, ‹Xoossi inttena Efreeme malanne Minaase mala ooththo› giidi intte sunththan anjjana» gides. Histtidi Efreeme Minaaseppe sinththe aaththides. ");
INSERT INTO gmvl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Hessafe guye Yaaqoobey Yooseefe, «Ta hayqqana gays; gido attiin Xoossi inttenara gidana; qasse izi intte aawata biitta inttena guye zaarana. ");
INSERT INTO gmvl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Qasse nena ne ishatara gakkiza biittaafe gisha darssada nees immays; hessika tani Amooretappe ta mashshaninne tooran ola ekkida biitta» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Hessafe guye Yaaqoobey ba attuma nayta xeygidi, «Sinththafe inttes hananayssa tani inttes yootana mala haa shiiqite. ");
INSERT INTO gmvl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","«Intteno Yaaqoobe naytoo! Issife haa shiiqidi siyite; intte aaway Isra7eeley inttes yootizayssa ezgite. ");
INSERT INTO gmvl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","«Oroobeele ta naa bayrazoo, neni ta wolqqa; ta minoteththas koyro; neni bonchchonkka wolqqankka ubbaafe aadhdhaasa. ");
INSERT INTO gmvl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Neni bixalay baynda para mala; ne dosidaa hanaasa; neni ne aawa hiith kezadasa; ne aawa hiiththaaka tunisadasa. Hessa gishshas halaqateththi nees bessenna. ");
INSERT INTO gmvl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","«Simooninne Lewey ishantta; istti iita ooththanaas mashshanne toora ekkeettes. ");
INSERT INTO gmvl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Tani istta zoreteththan gelikke; tani istta shiiqosonkka uttike. Ays giikko istti ba hanqon as wodhidanne bana ekka ekka giin boorata gildayi qanxxida. ");
INSERT INTO gmvl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Istta iita hanqoynne istta meqeththa iitateththi qanggettidaaz gido! Tani istta Yaaqoobe asaa giddon laallana; Isra7eele biittan dharccana. ");
INSERT INTO gmvl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","«Yuhuda ne ishati nena galatana; neni ne morkketa morge naaqqa oykkana; ne aawa nayti nees hokkidi ziggana. ");
INSERT INTO gmvl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuhuda neni wodalla gaammo mala; ta naazoo! Neni shankkati oykkidi, cogotti ichchida gaammo mala. Neni asi bana bosheththanaas koyontta macca gaammo mala. ");
INSERT INTO gmvl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Dere haarizaadey yaana gakkanaashe, kawoteththaa algay Yuhudappe, halaqateththa guufey iza keeththafe shaakettenna. Qasse dere asay izas azazettana. ");
INSERT INTO gmvl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Izi ba hare kaththa giddon ba hare gutteka doorettida kaththan qachchana. Izi ba haath woyne ushshan, ba may7o qasse woyne maadhan meeccana. ");
INSERT INTO gmvl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Iza ayfey woyne ushshafe aadhdhi zo7ana; iza achchayka maaththafe aadhdhi boottana. ");
INSERT INTO gmvl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","«Zaabilooney abba doonan daana; iza biittay daro markabetas shemposo gidana; iza zaway Sidoona gakkana. ");
INSERT INTO gmvl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","«Yisakoorey nam7u goday go7ettiza mino hare mala. ");
INSERT INTO gmvl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Izi ba shempizasoy lo7o gididayssanne ba derey ufayssizaaz gididayssa be7idi, tooho tookkanaas ba zokko ziqqi histtidi, aylleteththa ooso ooththana. ");
INSERT INTO gmvl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","«Daaney Isra7eele qommotappe issaas pirdiza daanna gidana. ");
INSERT INTO gmvl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Daaney para toggidaadey guye kundana mala para qirphe dukkiza oge doonan diza haso shooshsha. ");
INSERT INTO gmvl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","«Abeet Godoo! Ta ne maado naagays. ");
INSERT INTO gmvl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","«Gaadey bonqqizaytan deshettana; gido attiin izikka istta geedo kaallidi istta bonqqana. ");
INSERT INTO gmvl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","«Aaseere maadday aakkana; kawotas izi lo7o quma immana. ");
INSERT INTO gmvl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","«Niftaalemey qashettontta yeda diza, lo7o laaqqata yeliza genessa. ");
INSERT INTO gmvl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","«Yooseefey melontta pultto haaththa achchan tokettada, izi ayfey lasha bollara alalettana gakkanaas ayfe immiza miththay mala. ");
INSERT INTO gmvl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Wondafeza dukkizayti iza bolla worajjida; ba wondafenkka gooddi gooddi caddeettes. ");
INSERT INTO gmvl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Gido attiin Yaaqoobe Godaa Xoossa wolqqan iza heemmiza Isra7eele zaallan iza wondafey minnides; iza mino qeseykka pilatides. ");
INSERT INTO gmvl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Nena maaddiza ne aawa Xoossan Ubbaa Dandayzayssaninne nena anjjiza Xoossan pude bollafe beettiza maadoninne garsa biittafe beettizan anjjon qasseka aayi uloppenne dhanththafe beettiza anjjon nena anjjana. ");
INSERT INTO gmvl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ne aawa anjjoy beni wodeppe hanno gakkanaas minni diza zumatappenne mernaa zumata ubbaafe aadhdhees. Hessa gishshas hayssi ha anjjoy wurikka Yooseefe gakko. Ba ishata bolla halaqa gidida Yooseefe bolla wodhdho. ");
INSERT INTO gmvl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","«Biniyaamey bonqqiza kana suyte mala. Ba shankkatidayssa maalado mees; ba di7idayssa omars gishereththees» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Hayti tammanne nam7u Isra7eele qommota; qasse istta aaway istta issaa issaa istta hano mala isttas bessiza anjjo hessaththo anjjides. ");
INSERT INTO gmvl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Hessafe guye izi isttas, «Tani ta aawatan gaaggana gays; tana Hiite as Efroone gaden diza gongolon, ta aawatara moogite. ");
INSERT INTO gmvl_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Hessika Kanaane biittan, Mamire achchan diza Makipheele geetettiza gongolo; hayssika Abrahaamey moogos Hiite as Efrooneppe gadaara gaththi shammida gongolo. ");
INSERT INTO gmvl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Abrahaameynne iza machcheya Saaray heen moogettida; Yisaaqinne iza machcheya Irbiqaykka heen moogettida; tani qasse Liya heen moogadis. ");
INSERT INTO gmvl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","He gadezinne izan diza gongoloy Hiitetappe shamettidayssa» gi azazides. ");
INSERT INTO gmvl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yaaqoobey ba naytas azazo wursidaappe guye ba toho pude ba hiixan shiishshi ekkidi hayqqidi ba aawatan gaaggides. ");
INSERT INTO gmvl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yooseefey ba aawaa aha bolla kundidi yeekkidessinne iza yeerides. ");
INSERT INTO gmvl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Hessafe guye Yooseefey dhale shiishshiza ba oosanchchata ba aawa Isra7eele aha sawiza shitto tiydi melissana mala azaziin istti tiydi melissida. ");
INSERT INTO gmvl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Shitto tiyoy xalla 40 gallas kumeth wursides; ays giikko hayssi tiyoy wonakka oyddu tammu gallas ekkees. Gibxe asati izas laappun tammu gallas yeekkida. ");
INSERT INTO gmvl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Yeeho gallassati aadhdhiin Yooseefey Gibxe kawo keeththaa asata, «Tani intte sinththan sabettidaa gidikko kawos hizgi yootite; ");
INSERT INTO gmvl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Ta aaway tana issi caaqo caaqisides; izi tana, ‹Tani hayqqana hanays; tani taas Kanaane biittan woocida gongolo duufon tana mooga› gides. Hessa gishshas, ‹Ha7i tani pude baada ta aawa moogana mala yeddarkkii! Hessafe guye tani simmana› » gides. ");
INSERT INTO gmvl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Histtiin kawoy, «Izi nena caaqisida mala pude baada ne aawa mooga» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yooseefey ba aawa mooganaas pude bides. Kawoza oosanchchati wuri, iza kawoteththa keeththan diza gita asay wuri Gibxe biittan diza gita asay wuri Yooseefe kaallidi bides. ");
INSERT INTO gmvl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Qasse Yooseefe soo asay wuri iza ishatinne iza aawa soo asay izara biin; istta naytinne mehey xalla Geesemen attida. ");
INSERT INTO gmvl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Para-gaaretikka toga asaykka izara pude bides; iza kaallidi bida asay keehi daro. ");
INSERT INTO gmvl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Istti Yordaanoose shaafaa achchan diza Axaade geetettiza bale gakkidi ba qaalaa dhoqqu histtidi izas zilalidanne yeekkida; heen Yooseefey ba aawa yeehon laappun gallas uttides. ");
INSERT INTO gmvl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","He biittan diza Kanaane asati Axaade geetettiza yeeho balen he yeehoza be7idi, «Gibxe asay ay misha yeeho yeekkizoo!» gida. Hessa gishshas Yordaanoose achchan diza he soy, Gibxeta yeeho geetettides. ");
INSERT INTO gmvl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yaaqoobe nayti ba aaway istta azazida mala ooththida; ");
INSERT INTO gmvl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Iza ahaa Kanaane biitta efidi Mamire achchan diza Makipheele geetettiza gongolon, Abrahaamey Hiite as Efrooneppe moogos shammida gaden iza moogida. ");
INSERT INTO gmvl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yooseefey ba aawa moogidaappe guye, ba ishatanne iza aawa mooganaas izara bida hara asata ubbaara Gibxe simmides. ");
INSERT INTO gmvl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Istta aaway hayqqidayssa be7idi, Yooseefe ishati ba garsan, «Ooni erizee Yooseefey nuna ba ulon morkkidi nuni izas ooththida iita miish ubbaas halo kessana koykko, nuni waananee?» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Hessa gishshas Yooseefekko kiita, «Ne aaway hayqqanaappe kase; ");
INSERT INTO gmvl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Intte Yooseefe, ‹Neni ne ishata nagaranne istti nena qohida iita qohoza hayyana atto ga› giidi yootite gides. Hessa gishshas ha7i hayyana, nu nagaraa, ne aawa Xoossa aylleta nagaraa atto ga» gida. He kiitay izakko gakkiin, Yooseefey yeekkides. ");
INSERT INTO gmvl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Hessafe guye iza ishati barkka izakko biidi iza sinththan gufannidi, «Nuni ne aylleta» gida. ");
INSERT INTO gmvl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Gido attiin Yooseefey isttas, «Babbofte; tana inttes Xoossa gidetiyee? ");
INSERT INTO gmvl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Intte taas iitanaas ooththideta shin hayssi daro asay hayqqontta attana mala Xoossi lo7os hayssa ooththides. ");
INSERT INTO gmvl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Hessa gishshas hekko intte babofte; tani inttenanne intte nayta mizana» giidi, izi istta minththeththidi lo7o qaalan haasayides. ");
INSERT INTO gmvl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yooseefey ba aawa soo asaa ubbaara Gibxen gam7ides; izi 110 layth de7ides. ");
INSERT INTO gmvl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Efreeme nayta, heedzdzanththo yeleta gakkanaas be7ides; qasse Minaase naa Maakire naytakka izi ba naa mala histtides. ");
INSERT INTO gmvl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Hessafe guye Yooseefey ba ishata, «Tani hayqqana gays; gido attiin Xoossi inttena maaddanaas tumu wochchana; izi inttena ha biittafe kessidi Abrahaames, Yisaaqassinne Yaaqoobes immana giidi caaqqida biittaa zaari efana» gides. ");
INSERT INTO gmvl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yooseefey Isra7eele nayta, «Xoossi inttena maaddanaas tumu xomosiza wode, intte ta meqeththa ha biittafe pude ekki biite» giidi caaqechides. ");
INSERT INTO gmvl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yooseefey 110 layth de7idi hayqqiin, istti shitton iza aha tiydi melissidaappe guye Gibxe biittan wongire giddon woththida.");
INSERT INTO gmvl_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Baso asa ubbaa ekki Yaaqoobera Gibxe bida Yaaqoobe nayta sunththi hayssafe kaalli xaafettides. ");
INSERT INTO gmvl_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Isttika Oroobeele, Simoona, Lewe, Yuhuda, ");
INSERT INTO gmvl_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Yisakoore, Zaabiloone, Biniyaame, ");
INSERT INTO gmvl_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Daane, Niftaaleme, Gaadenne Aaseere. ");
INSERT INTO gmvl_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yaaqoobe zereththati mulera laappun tamma; Yooseefey kasetidi Gibxe biidi heen dees. ");
INSERT INTO gmvl_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yooseefey, iza ishatinne he yeletay wurikka hayqqides; ");
INSERT INTO gmvl_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","gido attiin Isra7eele zereththati yelettidi keehi darida; he biittaa kumana gakkanaas istti keehi corattida. ");
INSERT INTO gmvl_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Hessafe guye Yooseefe erontta ooraththa kawoy Gibxe biittan dendides. ");
INSERT INTO gmvl_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Izi ba asaa, «Be7ite; hayti Isra7eele asay nuuppe keehi daridanne wolqqamida. ");
INSERT INTO gmvl_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Haa yiite, ane nuni istta hiillan oykkoos; histtontta aggiko istti kaseppe gede dari dari baana. Geelli gida olay dendiko istti nu morkketara gaaggidi nuna olananne biittaa yeggidi baana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Hessa gishshas deexo ooson istta tuggasana mala istta bolla halaqata doorida. Isttika kawos Piitoomenne Eraamise geetettiza dumma dumma minjja miishshata woththiza katamata keexxida. ");
INSERT INTO gmvl_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Gido attiin Gibxe asay istta keehi waayisida wode istti gujetti gujetti yelettidanne biitta gakkida. Hessa gishshas Gibxe asay Isra7eele nayta ixxides. ");
INSERT INTO gmvl_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Hessa gishshas istta daro daabursiza ooson waayisida. ");
INSERT INTO gmvl_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Wolqqama ooson, simintoninne xuube medhon, qasse goshshe goyson, istta duussan un7eththida; daabursiza ooso ubbaa qadhetay baynda istta oosisida. ");
INSERT INTO gmvl_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Gibxe kawoy Ibraawe maccassata yelissiza Sipooronne Puuho geetettiza nam7u maccassatas, ");
INSERT INTO gmvl_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","«Ibraawe maccassati yeliza wode intte yelissishin yelettidayssi attuma naa gidikko wodhite; gido attiin macca naa gidikko wodhopite» ");
INSERT INTO gmvl_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Gido attiin Yelissizayti Xoossas babbidi Gibxe kawoy istta azazida mala ooththibeettenna; wodhontta attuma nayta paxa aggida. ");
INSERT INTO gmvl_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Hessafe guye Gibxe kawoy he yelissizayta xeygidi, «Intte ays hayssaththo ooththidetii? Attuma nayta ays paxa aggidetii?» gi oychchides. ");
INSERT INTO gmvl_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Yelissizayti zaaridi, «Ibraawe maccassati Gibxe maccassata mala gidettenna; istti mino gidida gishshas yelissizayti gakkanaappe sinththatidi yelichcheettes» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Hessa gishshas Xoossi yelissizaytas kiyides. Asaa qoodaykka gujetti gujetti biidi kaseyssafe gede daridesinne minnides. ");
INSERT INTO gmvl_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Qasse yelissizayti Xoossas babbida gishshas Xoossi isttas yelo immi anjjides. ");
INSERT INTO gmvl_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Hessafe guye kawoy ba asaa ubbaa, «Ibraawetappe yelettiza adde naa ubbaa Nayle geetettiza Shaafa haaththan olite; gido attiin macca nay yelettiko paxa aggite» giidi azazides. ");
INSERT INTO gmvl_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","He wode issi Lewe qommo gidida addey Lewe macca nayo machcho ekkides; ");
INSERT INTO gmvl_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","iza qanththatada adde naa yeladus. Naazikka mala lo7o naa gididayssa beyada heedzdzu agina qottadus. ");
INSERT INTO gmvl_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Gido attiin iza hessafe daro qottanaas dandayonttayssa erada, shaccafe keeshe izas daddada shidan meeshada, naaza iza giddon woththada Nayle shaafa doonan duureessa geetettiza maata giddon woththadus. ");
INSERT INTO gmvl_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Iza michcheya iza bolla aazi hananaakko beyanaas haahon eqqada xeellawus. ");
INSERT INTO gmvl_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Gibxe kawo naya bolla meecettanaas Nayle shaafa wodhdhadus; izi macca aylletikka haaththa doonan yaanne haa hemetteettes; iza keesheza duureessa geetettiza maata giddon beyada, baada ekkada yaana mala ba aylleyo kiittadus; ");
INSERT INTO gmvl_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","keesheza doyada he guuththa naaza beyadus. Izi yeekkiza gishshas izas qadhettada, «Hayssi Ibraaweta guuththa naytappe issaa gidontta aggenna» gadus. ");
INSERT INTO gmvl_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","He wode iza michcheya kawaa nayo, «Nees ha naaza dhanththanaas Ibraawetappe issi maccas ehanaas boo?» gaada oychchadus. ");
INSERT INTO gmvl_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Histtiin iza, «Ee, ba» gadus. Naya baada he naaza aayo ehadus. ");
INSERT INTO gmvl_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Kawoza naya he maccassayo, «Hayssa naaza efada taas dhanththaashsha; tani nees damoza qanxxana» gadus. Maccassaya naaza efada dhanththa dichchadus. ");
INSERT INTO gmvl_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Naazi dicciin kawo naykko iza ehiin izi izis naa gidides; «Tani iza haaththafe kessadis» gaada iza Muse ga sunththadus. ");
INSERT INTO gmvl_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Musey diccidi gita gididi issi gallas ba asay dizaso biidi istti deexo ooso ooththishin be7ides. Issi Gibxe biitta asi iza asata Ibraawetappe issaa wadhdhishin be7ides. ");
INSERT INTO gmvl_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Izi yaanne haa xeelliin oonikka bayndayssa be7idi he Gibxe addeza wodhidi ace giddon kaashi qottides. ");
INSERT INTO gmvl_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Wonteththa gallas kezidi nam7u Ibraaweti ba garsan wadhettizayta be7ides. Qohizayssa izi, «Neni ne as gidida Ibraaweza ays wadhdhay?» gi oychchides. ");
INSERT INTO gmvl_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","He addezikka, «Nena nu bolla godaanne daanna histtiday oonee? Neni Gibxe addeza wodhidayssa mala tanakka wodhana qoppay?» giin Musey, «Tani ooththidayssi erettichchides» gi babbides. ");
INSERT INTO gmvl_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kawozi hessa siyidi Muse wodhanaas koyides; gido attiin Musey kawaappe betidi Midiyaame biittan daanaas biidi issi haaththa olla doonan uttides. ");
INSERT INTO gmvl_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","He wode issi Midiyaame qeeses laappun macca nayti deettes; istti he haaththa ollaako ba aawaa dorsata haath ushshanaas yiidi gonggen haath duuqqi kunththida. ");
INSERT INTO gmvl_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Heemmizayti yiidi macca nayta gooddida; gido attiin Musey dendi eqqidi istta ashshidessinne istta dorsata haath ushshides. ");
INSERT INTO gmvl_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Istti ba aawa Yootorekko biin izi, «Hach waani eeson yidetii?» gi oychchides. ");
INSERT INTO gmvl_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Istti zaaridi, «Issi Gibxe biitta adde dayssi nuna mehe heemmizaytappe ashshides; qasseka nuus haaththeka duuqqidi nu dorsatakka ushshides» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Histtiin izi ba macca nayta, «Ha7i izi awan dizee? Intte he addeza ays heen aggidetii? Ane iza xeygite; yiidi kath mo» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Museykka he addezara heen daanaas dosides; addezikka ba nayo Xipooro Muses machcho histti immides. ");
INSERT INTO gmvl_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Xipoora adde naa yeliin Musey naaza, «Tani asa biittan bete asa» gishe Gershoome gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Musey Midiyaame biittan diza daro layththata garsan Gibxe kawoy hayqqides. Isra7eele asay ba aylleteththafe dendidayssan oolidanne waassida; aylleteththa waayey dariin istti waassida waasoy pude Xoossako gakkides. ");
INSERT INTO gmvl_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Xoossi istta oolezanne istta waasoza siyidi izi Abrahaamera, Yisaaqaranne Yaaqoobera caaqqida caaqo qaalaa yuushshi qoppides. ");
INSERT INTO gmvl_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Hessa gishshas Xoossi Isra7eele nayta xeellidi istta hanoteth qoppides. ");
INSERT INTO gmvl_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Musey Midiyaame biitta qeese, ba bollo Yootore dorsata heemmees; izi dorsata laaggi ekki biidi bazzo biitta gaxa gakkanaas efidi Siina geetettiza Xoossa zumaakko gakkides. ");
INSERT INTO gmvl_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Heen Xoossa kiitanchchay qeeri wora giddon eexxiza tama laco giddon izas beettides; wora giddon tama lacoy diikkoka tamay woraa monttayssa Musey be7ides. ");
INSERT INTO gmvl_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Hessa gishshas Musey, «Tani gede baada ays woray taman meetettonttaako hayssa ooraththa miish ane beyays» gi qoppides. ");
INSERT INTO gmvl_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Izi beyanaas gede bishin Xoossi be7idi woraa giddon dishe iza, «Musee! Musee!» gi xeygides. Museykka, «Yee!» gi koyides. ");
INSERT INTO gmvl_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Xoossi iza, «Haa shiiqoppa; neni eqqidasoy geesh gidida gishshas ne tohon diza caammaa kessa» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Qasseka Xoossay iza, «Tani ne aawata Abrahaame, Yisaaqanne Yaaqoobe Xoossa» gides. Histtiin Musey Xoossaa xeellanaas babbida gishshas ba ayfeso kammides. ");
INSERT INTO gmvl_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Qasseka GODAY, «Tani Gibxe biittan ta asay waayiza waaye lo7eththa beyada, istti ba godatappe dendidayssan waassiza waaso siyadissinne istta waaye eradis. ");
INSERT INTO gmvl_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Hessa gishshas tani istta Gibxe biitta asata kusheppe ashshanaasinne he biittafe istta kessada, aahonne lo7o biitta efanaas haa duge wodhdhadis. He biittay maaththinne eessi goggiza biitta; ha7i he biittan Kanaaneti, Hiiteti, Amooreti, Paarizeti, Hiiwetinne Yaabuseta geetettiza asati deettes. ");
INSERT INTO gmvl_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ha7i Isra7eele nayta waasoy taakko gakkides; Gibxe biitta asati istta qohiza qohokka ta beyadis; ");
INSERT INTO gmvl_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","hessa gishshas ha7i ba; ta asata, Isra7eele nayta Gibxeppe kessana mala, Gibxe kawozaakko tani nena kiittays» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Gido attiin Musey Xoossaas, «Kawozaakko baanaassinne Isra7eele nayta Gibxeppe kessanaas tani oonee?» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Xoossika iza, «Tani nenara gidana; qasse tani nena kiittidayssas malatay hayssa; neni he asaa Gibxeppe kessida wode hayssa zuma bollan intte taas Xoossas goynnana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musey Xoossaas, «Gido attiin tani Isra7eele naytakko baada isttas, ‹Intte aawata Xoossi tana intteko kiittides› giikko, istti tana, ‹Iza sunththi oonee?› gi oychchiko he wode tani isttas ay ga yootanee?» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Xoossika Muses, « ‹Tani tanakko; hessa gishshas kasekka ha7ikka diza Xoossi tana intteko kiittides› gaada yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Qasse Xoossi Muses, «Neni Isra7eele naytas, ‹GODAY intte aawata Abrahaame, Yisaaqanne, Yaaqoobe Xoossi izi tana intteko kiittides› ga yoota; hayssi yeletappe yeleta gakkanaas tani erettiza ta sunththa. ");
INSERT INTO gmvl_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","«Hee baada Isra7eele cimata shiishshada GODAA intte aawata Abrahaame, Yisaaqanne Yaaqoobe Xoossi taas qonccidi, ‹Tani intteko yadis; Gibxen intte bolla aazi oosettidaakko tani beyadis. ");
INSERT INTO gmvl_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Tani inttena Gibxe biittaa waayeppe kessada pude maaththinne eessi goggiza Kanaaneta, Hiiteta, Amooreta, Paarizeta, Hiiwetanne Yaabuseta biitta efana gadis› gides» gaada yoota. ");
INSERT INTO gmvl_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","«Isra7eele cimati ne qaala siyana; hessafe guye neninne he cimati Gibxe kawozaakko biidi izas, ‹GODAA Ibraaweta Xoossay nuus qonccides. Ha7i nuni heedzdzu gallassa oge bazzo biidi GODAAS nu Xoossaas yarsho yarshana mala nuna yedda› giite. ");
INSERT INTO gmvl_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Gido attiin ta wolqqara yedisontta dishin Gibxe kawoy inttena yeddonttayssa tani erays. ");
INSERT INTO gmvl_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Hessa gishshas tani ta kushe yeddada istta giddon tani ooththiza ta malaatata ubbaan Gibxe asaa shocana. Hessafe guye izi inttena yeddana. ");
INSERT INTO gmvl_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","«Intte ke7iza wode Gibxe asay inttes kiyana mala ta ooththana gishshas ke7ishe mela kushe ke7ekketa. ");
INSERT INTO gmvl_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ibraawe maccassati wuri ba guta Gibxe maccassatanne ba soon diza Gibxe maccassata oonakkoka gidiin biidi bira, worqqanne adde naytinne macca nayti may7ana may7ota, ‹Immite› gi oychchana. Hessaththo ooththidi intte Gibxe asaa aqo ubbaa buuri ekkidi kezana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Museykka GODAAS, «Istti tana ammanontta ixxiko woykko tani yootizayssa siyontta ixxidi, ‹GODAY nees qonccibeenna› giikko ta waanoo?» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","GODAY iza, «Hessi ne kushen dizay aazee?» gi oychchides. Izikka, «Guufekko» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","GODAYKKA iza, «Ane iza gaden yegga» gides. Musey he guufeza gaden yeggiin shoosh gidides; histtiin Musey izappe woxxi kichchides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Hessafe guye GODAY iza, «Ne kushe yeddada shooshshaa goyna oykka» gides. Musey yeddidi shooshshaa goyna oykkiin shooshshazi iza kushen simmidi guufe gidides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","GODAY, «Hayssi hanidayssi ne aawata Abrahaame, Yisaaqanne Yaaqoobe Xoossi nees qonccidayssa istti ammanana malassa» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Qasseka GODAY iza, «Ne kushe ne shophpha giddo gelththa» giin Musey ba kushe ba shophpha giddo gelththides; izi ba kusheza shophphaafe kessiza wode kushezi qaaratidi shachcha mala booxxides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","GODAY iza, «Ne kushe ne shophpha giddo zaara gelththa» gides. Histtiin Musey ba kushe ba shophpha giddo zaari gelththi kessiza wode iza kushey simmidi hankko bollaa mala gidides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Qasseka GODAY izas, «Istti nena ammanontta aggiko koyro malaataa ammanontta ixxiko, nam7anththoza ammanana. ");
INSERT INTO gmvl_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Gido attiin istti Xoossi ooththiza ha nam7u malaatata ammanontta aggiko woykko neni yootizayssa siyontta ixxiko, Nayle shaafappe haath duuqqa ekkada biitta bolla gussa; neni shaafaappe ekkida haaththi biitta bolla suuth gidana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Gido attiin Musey GODAAS, «Abeet Godoo! Tani hayssafe kasekka, woykko neni ne ayllezas taas yootoosoppe haa simmiinkka tani lo7eththa haasayanaas dandayontta as gidikkinaa?» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","GODAY izas, «Asas doona medhdhiday oonee? As duude, woykko tulle ooththizay oonee? Xeelanne qooqe ooththizay oonee? Tana GODAA gidikkinaa? ");
INSERT INTO gmvl_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Neni ha7i ba; ne haasayana mala ta nenara gidananne nena maaddana; neni yootanayssaka ta nena tamaarsana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Gido attiin Musey GODAA, «Abeet Godoo! Hayssa ooththanaas hara as kiittarkkii!» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Hessafe guye GODAY Muse bolla keehi hanqettidi iza, «Lewe baggafe gidida ne isha Aarooney dees gidennee? Izi lo7o haasayana dandayzayssa tani erays; ha7i izi nenara gaagganaas yishe oge bollan dees; izi nena be7idi ufayettana. ");
INSERT INTO gmvl_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Neni izas yoota; izi yootana qaalaakka ne iza erisa; tani inttena nam7atakka haasayan maaddananne intte ooththanayssa tamaarsana. ");
INSERT INTO gmvl_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Izi asaas ne gishshas yootana; hessika izi nees ne doona mala gidiin ne izas haasayza Xoossa mala gidana guussa. ");
INSERT INTO gmvl_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Malaatata izan ooththanaas neni hayssa guufeza ekka» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Hessafe guye Musey ba bollo, Yootorekko simmi biidi, «Hanno gakkanaas asay paxa dizaakko beyanaas tani guye ta asaakko Gibxe boo?» gides. Yootoreykka Muse, «Ee ba; saron gakka» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Musey Midiyaame biittan dishin GODAY iza, «Nena wodhanaas koyida asati wuri hayqqida gishshas guye Gibxe biitta simma ba» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Musey ba machchiyonne ba attuma nayta hare togisi ekkidi guye Gibxe simmishe Xoossa guufe oykki bides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","GODAY Muse, «Neni Gibxe simmada biza wode tani nees immida wolqqan neni ooththana malaatata ubbaa Gibxe kawo Paaroone sinththan neni ooththanayssa baloppa. Histtiinkka izi asaa yeddontta mala tani iza wozina muumisana. ");
INSERT INTO gmvl_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","He wode tani GODAY gizayssa kawaas: Isra7eeley taas bayra naa; ");
INSERT INTO gmvl_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ta naazi taas goynnanaas ne yeddana mala tani nees yootadis shin neni iza yeddontta ixxadasa; hessa gishshas, ‹Tani nees bayra naaza wodhana› gides gaada yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Oge bolla imaththi shempizason GODAY Musera gaaggidi iza wodhanaas koyides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Iza machchiya Xipooray qara shuch ekkada ba naaza qaxxaradus. Qaxxarada he shurteza Muse toho bochchada Muse, «Neni taas tumu suuththa mishira» gadus. ");
INSERT INTO gmvl_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Hessa gishshas GODAY iza wodhontta aggides. He wode qaxxaraa gaason izas, «Neni taas suuththa mishira» gadus. ");
INSERT INTO gmvl_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","GODAY Aaroone, «Neni Musera gaagganaas bazzo ba» giin izi biidi Musera Xoossa zumaa bolla gaaggidi iza yeerides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Hessafe guye Musey GODAY ba bolla kiittida qaala ubbaa qasseka ooththana mala bana azazida malaatata ubbaa Aaroones yootides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Museynne Aarooney biidi Isra7eele cimata ubbaa issi bolla shiishshida. ");
INSERT INTO gmvl_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aarooney GODAY Muses yootida qaala ubbaa isttas yootidessinne malaatata he asaa sinththan ooththides. ");
INSERT INTO gmvl_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Isttika ammanida. GODAY isttako yidayssanne istta waaye be7idayssa siyida mala biitta bolla gufanni goynnida. ");
INSERT INTO gmvl_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Hessafe guye Museynne Aarooney Gibxe kawozaakko biidi izas, «GODAY, Isra7eele Xoossi, ‹Ta asay taas bazzon ba7aale bonchchana mala yedda› gides» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Histtiin kawozi, «Tani izas azazettada Isra7eele yeddanaas he GODAY izi oonee? Tani Godaa erikke; Isra7eelekka yeddike» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Hessafe guye Museynne Aarooney, «Ibraaweta Xoossi nunara gaaggides. Ha7i nuni GODAAS, nu Xoossaas yarsho yarshanaas heedzdzu gallassa oge bazzo giddo baanaas nuna yeddarkkii! Histtontta aggiko izi nuna iita hargen woykko olan wodhana» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Gido attiin Gibxe kawoy, «Inttenoo! Muse! Aaroonee! Asaa ays ooso diggeetii? Simmidi intte oosos biite» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Kawozikka, «Hekko be7ite, ha biittan asay corattides; qasse intte asaa ooso diggeeta» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","He gallas kawoy Isra7eele asaa garsafe asaa oosisizaytanne isttafe bollara diza Gibxe halaqata hizgi azazides. ");
INSERT INTO gmvl_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«Hara wodeyssa mala xuube ooththiza uttula asaas ehi immofte; istti uttula baappe koyidi shiishshetto; ");
INSERT INTO gmvl_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Gido attiin istti qoodan kaseyssa gina xuube medhdhidi sheedhdhana mala azazite; kase qoodaappe pacisopite; ays giikko istti azalla; isttas, ‹Nuni nu Xoossaas yarsho yarshana mala nuna yedda› giidi waassizay hessassa. ");
INSERT INTO gmvl_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Istti ooson sheekkana malanne wordo haasaya siyontta aggana mala isttas ooso deexeththite» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Hessafe guye Isra7eele asaa garsafe asaa oosisizaytinne isttafe bollara diza Gibxe halaqati kezidi asaas, «Kawozi, ‹Hayssafe guye ta inttes uttula mulekka immike. ");
INSERT INTO gmvl_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Intte uttula demmana dandayzasoppe intte baggara koyi ehite shin intte kase sheedhdhiza xuube qooday mulekka paccofo› gides» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Histtiin asay uttula shiishshanaas Gibxe biitta ubbaan laalettides. ");
INSERT INTO gmvl_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Gibxe halaqati isttas, «Kase inttes uttula immiza wode intte hach hach ooththizayssa mala ooththite» giidi istta bolla godatida. ");
INSERT INTO gmvl_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Isra7eele nayta oosisizaytas waanna halaqati, «Intte kase ooththizayssa mala xuube qamma woykko hach ays ooththi wursibeekketii?» gi oychchidi wadhdhida ");
INSERT INTO gmvl_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Hessafe guye Isra7eele naytappe doorettidi asaa oosisizayti biidi kawozas waassida; istti izas, «Nuni ne aylleta gidishin nu bolla hayssaththo aazas ooththay? ");
INSERT INTO gmvl_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ne aylletas nuus uttula imettenna; gido attiin, ‹Xuubeza medhdhite› giidi nuna ne aylleta wadhdheettes shin balay ne asaa bolla dees» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Gido attiin kawozi istta, «Ha azallati! Intte azallata! Hessa gishshassa intte zaari zaaridi, ‹Nuni GODAAS yarshanaas baana nuna yedda› geeta. ");
INSERT INTO gmvl_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ha7i biidi ooththite; istti inttes aykko galabaka immettenna; gido attiin intte kaseyssafe pacisontta xuubeza medhdhite» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Isra7eele naytappe doorettidi asaa oosisizayti, «Intte hach hach medhdhiza xuube qooda kaseyssafe pacisopite» gida giin istti meton gelidayssa erida. ");
INSERT INTO gmvl_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Istti kawoza sinththafe kezidi Museynne Aarooney isttara gaagganaas naagizayta demmida. ");
INSERT INTO gmvl_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Istti, «Xoossi inttena xeello! Intte bolla izi pirdo! Intte nuna kawoninne iza oosanchchatan ixisideta; qasse istti nuna wodhana mala, mashsha isttas immideta» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Musey GODAAKKO simmidi, «Godoo, neni ha asaa bolla meto ays ehadii? Neni tana kiittiday hayssassee? ");
INSERT INTO gmvl_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Tani ne sunththan kawaas haasayanaas bida wodeppe doommiin izi ha asaa bolla meto ehides. Qasse nenikka ne asaa mule ashshabeekka» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Hessafe guye GODAY Muses, «Tani Gibxe kawo bolla ooththanayssa neni ha7i beyana; ta wolqqama qese gaason izi istta yeddana; ta wolqqama qeseppe dendidayssan izi istta ba biittafe kessi gooddana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Xoossi qasseka Muses, «Tani GODAA; ");
INSERT INTO gmvl_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","tani Ubbaa Dandayza Xoossa gidada Abrahaames, Yisaaqassinne Yaaqoobes qonccadis shin tani, ‹GODAA› geetettiza ta sunththan tanateththaa istta erisabeekke. ");
INSERT INTO gmvl_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Qasse tani isttas istti bete gididi de7ida Kanaane biittaa isttas immanaas ta isttara caaqettadis. ");
INSERT INTO gmvl_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Qasseka Gibxe asay aylle histti waayisida Isra7eele nayta waaso siyada ta gelida caaqo qaala qoppadis. ");
INSERT INTO gmvl_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","«Hessa gishshas neni Isra7eele naytas, ‹Tani GODAA; tani inttena Gibxe asaa qohoppe kessana; tani inttena istta aylleteththafekka goochcha kessana; qasse tani inttena ta gita wolqqaninne dumma dumma pirdan wozzana. ");
INSERT INTO gmvl_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Tani inttena ta dere histtana; tani intte Xoossaa gidana. He wode ta inttena Gibxe asaa aylleteththafe kessida intte GODAA Mernaa Xoossaa gididayssa intte erana. ");
INSERT INTO gmvl_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Qasse tani inttena Abrahaames, Yisaaqassinne Yaaqoobes immana gaada ta kushe denththada caaqqida biitta ehana; he biittaa tani inttes intte gade histta immana; tani GODAA› ga» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musey hessa Isra7eele naytas yootides shin istti ufays qanxxida gishshassinne iita aylleteththafe dendidayssan istta wozinay meqqida gishshas istti iza qaalaa siyibeettenna. ");
INSERT INTO gmvl_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Hessafe guye GODAY Muse, ");
INSERT INTO gmvl_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Hee baada Gibxe kawaas, ‹Isra7eele nayta ne biittafe kessa yedda› gaada yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Gido attiin Musey GODAAS, «Isra7eele nayti tayssa siyontta ixxida shin tani doonay birshontta as gidishin kawoy ta gizayssa wostti siyanee?» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","GODAY Musenne Aaroone, «Biidi intte Isra7eele asaa Gibxeppe kessana mala tani inttena yeddidayssa Isra7eele asaassinne Gibxe kawos yootite» gi azazides. ");
INSERT INTO gmvl_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Hayssafe kaalli dizayti istta keeththa keeththa halaqata. Isra7eeles bayra naa Oroobeele attuma nayti, Heenooke, Paalu, Hexiroomenne Karme; haytanti Oroobeele qommota. Istta soo asata halaqati hayta. ");
INSERT INTO gmvl_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Qasse Simoona attuma nayti, Yimu7eele, Yaamine, Ohaade, Yaakine, Xoohaarenne Kanaane biitta maccassatappe yelettida Sa7oole; hayti Simoona qommota. ");
INSERT INTO gmvl_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Lewe baggati ba yeleta maaraa mala Gershoone, Qa7aatenne Meraare. Lewey 137 layth de7ides. ");
INSERT INTO gmvl_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gershoone attuma nayti ba qommon qommon Libinanne Shim7e geetetteetes. ");
INSERT INTO gmvl_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Qaheete attuma nayti Amiraame, Yixihaare, Kebroonenne Uzi7eele. Qa7aatey 133 layth de7ides. ");
INSERT INTO gmvl_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Meraare attuma nayti Mahilenne Mushe geetettizayta. Ba Yeleta maaran Lewe zareti haytantta. ");
INSERT INTO gmvl_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amiraamey ba aawaa michcheyo Yokaabedo machcho ekkides. Izakka izas Aaroonenne Muse yeladus. Amiraamey 137 layth de7ides. ");
INSERT INTO gmvl_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Yixihaare attuma nayti, Qoore, Nefegenne Zikire. ");
INSERT INTO gmvl_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzi7eele attuma nayti, Misha7eele, Elxafaanenne Siitire. ");
INSERT INTO gmvl_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aarooney Aminadaabe nayo, Ne7asoone michcheyo Elisheebo machcho ekkides. Histtiin iza izas Nadaabe, Abihu, El7ezeerenne Itamaare yeladus. ");
INSERT INTO gmvl_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Qoore attuma nayti, Assire, Hilqaananne Abiyaasaafe; haytanti Qoore qommotas aawata. ");
INSERT INTO gmvl_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aaroone naa El7ezeerey Puti7eele naytappe issiniyo machcho ekkides; izakka izas Finihaase yeladus. Haytanti ba qommon qommon Lewe keeththa asaa halaqata. ");
INSERT INTO gmvl_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","GODAY, «Gibxe biittafe Isra7eele nayta istta cugan cugan kessite» giidi azaziday hayta Musenne Aaroone. ");
INSERT INTO gmvl_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Isra7eele nayta Gibxe biittafe kessizayssa Gibxe kawaas yootidayti Musenne Aaroone. ");
INSERT INTO gmvl_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","GODAY Gibxen Muses yootiza wode izas, ");
INSERT INTO gmvl_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","«Tani GODAA; tani nees yootizayssa ubbaa neni Gibxe kawaas yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Musey qasse GODAAS, «Tani doonay birshontta as gidida gishshas kawoy tani yootizayssa wostti siyanee?» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Hessafe guye GODAY Muses, «Beya; tani nena Gibxe kawaas Xoossa mala ooththadis; ne isha Aarooney ne doona gididi ne gishshas haasayana; ");
INSERT INTO gmvl_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","tani nena azazidayssa ubbaa ne isha Aaroones yootandassa; kawozi Isra7eele nayta ba biittafe kessi yeddana mala izi yootana. ");
INSERT INTO gmvl_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Gido attiin tani kawoza wozina minththana; tani Gibxe biittan ta malaatanne maalalissiza miish darsa ooththikokka, ");
INSERT INTO gmvl_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","izi intte yootizayssa siyenna. He wode tani ta kushe Gibxe asaa bolla denththana; tani ta dereta Isra7eele nayta wolqqama pirdan Gibxeppe kessana. ");
INSERT INTO gmvl_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Qasse Gibxeti tani ta qese Gibxe asaa bolla denththada Isra7eele nayta istta giddofe kessiza wode tani GODAA gididayssa istti erana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Museynne Aarooney GODAY istta azazida mala ooththida. ");
INSERT INTO gmvl_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Istti kawozas yootiza wode Muses layththay osppun tamma; Aarooney qasse 83 layththa asa. ");
INSERT INTO gmvl_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","GODAY Musenne Aaroone, ");
INSERT INTO gmvl_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Kawoy inttena, ‹Ane malaata tana bessite› giikko neni Aaroone, ‹Ne guufaa ekkada kawoza sinththan yegga› ga; histtiko izi shoosh gidana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Histtiin Museynne Aarooney kawozaakko gelidi GODAY istta azazida mala ooththida; Aarooney ba guufe kawoza sinththaninne daannata sinththan yeggiin guufezi shoosh gidides. ");
INSERT INTO gmvl_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Hessafe guye kawozi daro eranchchatanne bitizayta xeygisiin Gibxe dere marotikka ba deren hessaththo ooththida. ");
INSERT INTO gmvl_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Istti wurikka ba guufe guufe gaden yeggiin guufeti wurikka shoosh gidida shin Aaroone guufeya istta guufeta ubbaa mittadus. ");
INSERT INTO gmvl_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Gidikkoka GODAY yootida mala kawoza wozinay minnida gishshas izi istta yo7o siyontta ixxides. ");
INSERT INTO gmvl_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","GODAY Muses, «Kawoza wozinay muumiin asaa izi yeddontta ixxida gishshas, ");
INSERT INTO gmvl_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","kawozi shaafa biza wode maaladora neni izakko baada izara gaaggana mala Abbaye shaafaa doonan eqqa; hee bashe shooshshan laamettida guufeza oykka ekkada ba. ");
INSERT INTO gmvl_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Neni iza, ‹GODAA Ibraaweta Xoossay nena, «Bazzon taas goynnana mala ta asaa yedda» giidi tana neekko kiittides shin hanno gakkanaas neni ero gabeekka. ");
INSERT INTO gmvl_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","GODAY, «Tani GODAA gididayssa neni hayssan erana» gides. Tani Abbaye shaafa haaththaa ta kushen diza guufezan shocikko haaththay suuththan laamettana. ");
INSERT INTO gmvl_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Abbaye shaafaa moleykka hayqqana; shaafaykka xinqqana; Gibxeti he shaafa haaththaa uyanaas dandayettenna› gaada yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","GODAY Muses, «Neni Aaroones, ‹Ne guufe oykkada Gibxe haaththata bolla, shaafata bolla, zara haaththata bollanne eellida haaththi dizaso ubbaa bolla ne kushe piddisa› ga; izi ba kushe piddisikko haaththi wuri suuththan laamettana; Gibxe biitta ubbaan, haray attoshin, miththafenne shuchchafe wooci kessida haath tigiza miishshata ubbaan suuththi kumana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Museynne Aarooney GODAY azazida mala ooththida. Kawoza sinththaninne daannata sinththan Aarooney ba guufeza denththidi shaafa haaththaa shociin haaththi wuri suuththan laamettides. ");
INSERT INTO gmvl_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","He shaafa haaththaa giddon diza moleti hayqqida; shaafa haaththi keehi xinqqida gishshas Gibxe asay uyanaas dandaybeenna. Gibxe biittay kumeth suuth xalla gidides. ");
INSERT INTO gmvl_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Gido attiin Gibxe maroti ba biittan izaththoka ooththida; GODAY yootida malakka kawoza wozinay minnida gishshas Museynne Aarooney yootidayssa siyontta ixxides. ");
INSERT INTO gmvl_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Hessafe guye kawozi hessas aykko babbontta dishe ba soo simmi bides. ");
INSERT INTO gmvl_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Gibxe asay wuri Abbaye shaafa haaththaa uyanaas dandayontta gishshas, uyiza haath demmanaas Abbaye shaafaa achchan olla bookkida. ");
INSERT INTO gmvl_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","GODAY haaththaa suuththan laammiin laappun gallas gidides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Hessafe guye GODAY Muse, «Gibxe kawaakko baada, ‹GODAY nena hizgees ga; taas goynnana mala ta asaa yedda; ");
INSERT INTO gmvl_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","neni istta yeddontta ixxiko tani ne biitta ubbaa mooriza ooqqars yeddana. ");
INSERT INTO gmvl_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Abbaye shaafan ooqqarsi kumi aadhdhidi ne soo, ne aqiza soo, ne arsa bolla, daannata keeththa giddo gelana; ne asaa bolla kezana; ne coocen ne munuqa gonggetankka gelana. ");
INSERT INTO gmvl_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ooqqarsati ne bolla, ne asaa bollanne daannata ubbaa bolla kezana› gaada yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Hessafe guye GODAY Muse, «Neni Aaroone, ‹Ne guufeza ekkada, shaafata bolla, zara haaththata bollanne eellida haaththata bolla ne kushe piddisada ooqqarsi Gibxe biitta bolla kezana mala ooththa› gaada yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Histtiin Aarooney Gibxe haaththata bolla ba kushe piddisiin ooqqarsi kezidi Gibxe biitta may7ides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Gido attiin marotikka bantta biittan Gibxen ooqqarsi kezana mala izaththoka ooththida. ");
INSERT INTO gmvl_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Kawozi Musenne Aaroone xeygisidi, «Hayssa ooqqarsaa taappenne ta asaa bollafe diggana mala GODAA intte woossite; histtiko GODAAS yarshana mala tani asaa yeddana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Histtiin Musey kawoza, «Kawoo nees too! Ooqqarsi neeppenne ne sooppe dhaydi Abbaye shaafan xalla attana mala tani nees, daannatassinne ne asaas woossana gallas ne yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Histtiin kawozi, «Wonto gido» gides. Museykka, «GODAA nu Xoossa malay oonikka bayndayssa neni erana mala ne gida mala ooththana. ");
INSERT INTO gmvl_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","He ooqqarsay neeppe, ne keeththafe, daannatappenne ne asaappe dhayana; istti Abbaye shaafan xalla attana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Museynne Aarooney kawaa achchafe kezidi kawoza bolla izi ehida ooqqarsata gishshas Musey GODAAKKO waassides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","GODAYKKA Musey oychchida mala ooththides; ooqqarsi soon, kareninne demban dizayssi wuri hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Gibxe asay ooqqarsaa shiishshi shiishshidi korides; biittayka xinqqon zeeqqides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Gido attiin kawozi guuththa peeqa demmida wode ba wozina minththides; GODAY yootida malakka izi Museynne Aarooney yootida yo7oza siyontta ixxides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Hessafe guye GODAY Muse, «Neni Aaroones, ‹Ne guufezara, biitta gudulla shoca› ga; izi shocikko Gibxe biitta ubbaan gudullay cuuch gidana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Histtiin istti hessaththo ooththida; Aarooney ba guufe ekkidi guufezara biitta gudullaa shociin asanne mehe ubbaa bolla cuuchchi kezides. Gibxe biittan ha gaxappe heni gaxa gakkanaas gudullay wuri cuuch gidides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Marotikka ba bitan izaththo ooththanaas paacciin isttas dandayetibeenna. Cuuchchay asa bollanne mehe bolla kumides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Marotikka kawozas, «Hayssi Xoossa oosokko!» gida. Gido attiin kawoza wozinay minnides; GODAY gida malakka izi istti yootizayssa siyontta ixxides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","GODAY Muses, «Wontta maaladora dendada, kawozi shaafa bishin izara gaaggada neni iza, ‹GODAY taas goynnana mala ta asaa yedda; ");
INSERT INTO gmvl_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","neni ta asaa yeddontta ixxiko, tani ne bolla, daannata bolla, ne asaa bollanne ne keeththata giddo wolqqama boxe yeddana; Gibxe asaa keeththaninne istti diza biitta ubbaan boxey kumana. ");
INSERT INTO gmvl_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Gido attiin tani GODAY ha biittan dizayssa neni erana mala he gallas ta asay diza Geeseme biittan boxey gakkontta mala tani teqqada istta biittaa naagana. ");
INSERT INTO gmvl_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Tani ne asaappe ta asaa dumma shaakkana; hayssan malaata wonto ooththana› gides gaada yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Hessafe guye GODAY gida mala ooththides; kawoza sooninne iza daannata soon daro wolqqama boxey kumides; kumeththa Gibxe biitta ubbaa iissides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","He wode kawozi Musenne Aaroone xeygisidi, «Biite; hayssa ha biittan intte Xoossaas yarshite» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Gido attiin Musey, «Hessi lo7o deenna; nuni GODAA nu Xoossaas shiishshiza yarshoti Gibxe asaas tuna miish gidana; nuni istta tunisiza yarshota istti xeellishin yarshiko, istti nuna shuchchan caddettennee? ");
INSERT INTO gmvl_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Nuni GODAA nu Xoossaas yarshota shiishshanaas izi nuna azazida mala heedzdzu gallassa oge bazzo baanaas koshshees» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Histtiin kawozi, «GODAA intte Xoossaas intte bazzo biidi yarshana mala tani inttena yeddana shin intte haakki boopite; ha7i taas woossite» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musey, «Tani ne achchafe kezida mala GODAA woossana; ha wolqqama boxey wonto kawozappe, daannatappenne iza asaappe kichchana. Gido attiin GODAAS yarshanaas asaa yeddontta ixxanaas kawoy nuna zaari cimmontta mala qoppo» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Hessafe guye Musey kawoza achchafe kezidi GODAA woossides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Musey oychchida mala GODAY ooththides; boxey kawozappe, daannatappenne iza asaappe issinokka attontta kichchides. ");
INSERT INTO gmvl_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Gido attiin ha7ikka kawaa wozinay minnida gishshas izi asaa yeddontta ixxides. ");
INSERT INTO gmvl_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","GODAY Muse, «Gibxe kawozaakko baada GODAA Ibraaweta Xoossay nena, ‹Taas goynnana mala ta asaa yedda; ");
INSERT INTO gmvl_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Neni yeddontta ixxizaa gidikko, ");
INSERT INTO gmvl_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","heemettizason diza ne meheta bolla, parata bolla, hareta bolla, gaamellata bolla, miizata bolla, dorsata bollanne deyshata bolla wolqqama harge yeddana. ");
INSERT INTO gmvl_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Gido attiin tani GODAY Isra7eele meheta giddoninne Gibxe asaa meheta giddon shaakoteth medhdhana. Isra7eele asaa mehetappe issoyka hayqqenna› ga» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","GODAY wode baridi, «Tani wonto hayssa ha biitta bolla ooththana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Wonteththa gallas GODAY hessa ooththides. Gibxe asaa mehey wuri hayqqides shin Isra7eele asaa meheppe issinakka hayqqabeekku. ");
INSERT INTO gmvl_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Kawozi ha yo7oza paaccanaas as kiittidi Isra7eele nayta meheppe, haray attoshin pexi issinakka hayqqonttayssa erides. Gidikkoka kawoza wozinay minnidasoppe simmontta ixxida gishshas asaa yeddontta ixxides. ");
INSERT INTO gmvl_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Hessafe guye GODAY, Musenne Aaroone, «Kushe kunththidi cooceppe bidinththa kuucci ekkidi Musey kawozi xeellishin hessa pude carko bolla laallo; ");
INSERT INTO gmvl_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","hayssi Gibxe biitta ubbaa bolla gudulla gidana; Gibxe biitta ubbaan asa bollanne mehe bolla kixay wodhdhana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Histtiin istti cooceppe bidinth ekkidi kawoza sinththan eqqida; Musey hessa pude carkon laalliin asaa bollanne mehe bolla giiyiza kixay kezides. ");
INSERT INTO gmvl_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Marotikka istta bollanne Gibxe asaa ubbaa bolla wodhdhida kixay eqo diggiin Muse sinththan eqqanaas dandaybeettenna. ");
INSERT INTO gmvl_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Gido attiin GODAY Muses gida malakka kawoza wozina minththida gishshas Museynne Aarooney yootizayssa kawozi siyontta ixxides. ");
INSERT INTO gmvl_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Hessafe guye GODAY Muses, «Wonto wontta maaladora denda baada kawozara gaaggada iza Ibraaweta GODAY nena, ‹Taas goynnana mala ta asaa yedda. ");
INSERT INTO gmvl_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ne yeddontta ixxiko ne bolla, daannata bollanne ne asaa bolla ta wolqqama hanqo ha7i yeddana; hessankka biitta bollan ta malay bayndayssa neni erana. ");
INSERT INTO gmvl_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Tani hanno gakkanaas ta kushe yeddada nenanne ne asaa iita hargen qohidaakko ha biittaa bollafe pitta dhayssanakkoshin. ");
INSERT INTO gmvl_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Tani nena paxa woththiday nena ta wolqqa bessanaassinne ta sunththi biitta ubbaa bollan xeygettana malassa. ");
INSERT INTO gmvl_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Neni ha7ikka otorettada ta asaa yeddontta ixxadasa. ");
INSERT INTO gmvl_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Hessa gishshas tani wonto hanni wode Gibxey Gibxe gidoosoppe hach gakkanaas bukki erontta wolqqama shach bukisana. ");
INSERT INTO gmvl_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ha7i neni ne mehenne gaden nees dizaaz ubbaa soo gelththana mala azaza; ays giikko soo gelontta buro gaden diza asa ubbaa bollanne mehe ubbaa bolla shachchi bukkidi wodhana› gides ga» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Kawozi sunththida daannatappe GODAA qaalaas babbidayti ba aylletanne ba mehe eesotidi soo gelththida. ");
INSERT INTO gmvl_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Gido attiin GODAA qaala kadhidayti ba aylletanne ba mehe karen aggaagida. ");
INSERT INTO gmvl_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Hessafe guye GODAY Muses, «Gibxe biitta ubbaa bollan, asaa bolla, mehe bollanne biittafe mokkiza ubbaa bolla shachchi bukkana mala ne kushe salo denththa» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musey ba guufe pude salo denththida mala, GODAY dadanne shach yeddides; wolqqanththika duge biitta bolla wolqqamides. GODAY Gibxe biittan shach bukisides. ");
INSERT INTO gmvl_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Shachchay bukkides; wolqqanththika wolqqamides; Gibxe derey dere gidoosoppe haa simmiin Gibxe biitta ubbaa bolla wodhdhida shachcha ubbaafe hayssi aadhdhiza iita shachcha. ");
INSERT INTO gmvl_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","He shachchay Gibxe biitta ubbaan gaden diza ubbaa, asakka mehekka shocides; biittafe mokkidaaz ubbaa duge zaaridi shocides; miththika ubbaa menththereththides. ");
INSERT INTO gmvl_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Isra7eele nayti diza Geeseme biittay xalla shachchi bukkontta attides. ");
INSERT INTO gmvl_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Kawoykka Musenne Aaroone xeygisidi, «Ha7i hekko, tani nagara ooththadis; GODAY xillo; taninne ta asay wordo. ");
INSERT INTO gmvl_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Dadaynne shachchi nu bolla darida gishshas nuus GODAA woossite. Tani inttena yeddana; hekko hayssafe sinththan intte hayssan gam7eketa» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Museykka izas, «Tani ha katamaappe keza baada woossanaas ta kushe GODAAKKO miccana; histtiko daday aggana; qasse shachchayka bukkenna; hessankka biittay GODAAS gididayssa neni erana. ");
INSERT INTO gmvl_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Gido attiin neninne daannati GODAA Xoossaas ha7ikka babbonttayssa tani erays» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","32","Ciiyida kaththaynne tiyattida kaththay wuri dhaydes; gido attiin ciiyonttanne tiyattontta buro gakkiza kaththaa shachchay qohibeenna. ");
INSERT INTO gmvl_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Hessafe guye Musey kawoza achchafe dendidi katamappe gaxa kezidi ba kushe GODAAKKO miccides; histtiin dadaynne shachchay eqqides; iraykka biitta bolla bukkizayssa aggides. ");
INSERT INTO gmvl_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Gido attiin kawozi iray, shachchaynne daday aggidayssa be7ida wode qasseka nagara ooththides; izinne daannatikka bantta wozina minththida. ");
INSERT INTO gmvl_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","GODAY Muse doonara haasayda malakka kawaa wozinay minniin Isra7eele nayta yeddontta ixxides. ");
INSERT INTO gmvl_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","2","Hessafe guye GODAY Muses, «Gibxe kawaakko guye simma ba; ays giikko tani Gibxe asaa wostta qaxxaydaakkonne malaata istta giddon wostta ooththidaakko intte intte naytassinne intte nayta naytas yootana mala, qasse intteka tani GODAA gididayssa erana mala, ta malaata istta giddon ooththanaas iza wozinanne daannata wozina minththa woththadis» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Histtiin Museynne Aarooney kawozaakko gelidi, «GODAA Ibraaweta Xoossi nena, ‹Ne nenateththaa ta sinththan kawushshontta ixxizay awude gakkanaassee? Ha7i taas goynnana mala ta asaa yedda. ");
INSERT INTO gmvl_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Neni istta yeddontta ixxiko wonto ta ne biittaa bolla boole yeddana. ");
INSERT INTO gmvl_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Boolezi oonikka be7ontta mala biittaa may7ana. Inttes shachchaafe attida guuththa miishshi, gaden dicciza miththika ubbaa maana. ");
INSERT INTO gmvl_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ne keeththatan, daannata keeththaninne Gibxe asa ubbaa keeththan kumana; hayssi ne aawati, woykko ne mayzati ha biittaa bolla doosoppe hanno gakkanaas mulekka beyi erontta miishsha› gides» gida. Hessafe guye Musey kawoza sinththafe kezi bides. ");
INSERT INTO gmvl_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Kawozi sunththida daannatikka kawoza, «Hayssi addezi nuus ayde gakkanaas dhuphe gidanee? Istti GODAA ba Xoossaas goynnana mala neni asaa yedda; Gibxe derey dhaydayssa neni ha7ikka yuushsha qoppikii?» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Hessa gishshas kawozi Musenne Aaroone xeygisi guye zaaridi, «Biite; GODAA intte Xoossaas goynnite shin bizayti oonanttee?» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Histtiin Musey, «Nuni nu qeeri naytara cimatara, nu attuma naytara macca naytara, nu mehaaranne miiza wudetara issife baana; ays giikko nuni bizason GODAAS ba7aale bonchchanaas koshshees» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Kawozi, «Intte maccassataranne intte naytara baana mala ta inttena yeddana; GODAY inttenara gido; gido attiin intte intte wozinan gene qoppideta. ");
INSERT INTO gmvl_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Hessa gishshas hanenna; intte, ‹Nu biidi GODAAS goynnana mala nuna yedda› gishe gam7ida gishshas attumasay xalla biidi GODAAS goynnite» gides. Hessafe guye Musenne Aaroone kawoza sinththafe kessi gooddida. ");
INSERT INTO gmvl_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","GODAY Muses, «Booley Gibxe biitta bolla yaana mala shachchaafe attidi dicciza ubbaa lim7i histti wursana mala, ne kushe Gibxe biittaa bolla piddisa» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Musey ba oykkida guufaa Gibxe biitta bolla dhoqqu histti denththiin, he wode gallassinne qamma GODAY arshey mokkiza baggafe wolqqama carko biitta ubbaa bolla yeddides; gadey wontishin he carkoy boole ekki yides. ");
INSERT INTO gmvl_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Booley Gibxe biitta kumeththi may7ides. Hayssa lagge boole boshay he biittaan hayssafe kase hanibeenna; hayssafe sinththankka iza malay hanenna. ");
INSERT INTO gmvl_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Biittay karexxana gakkanaas boolezi biitta ubbaa may7ides. Shachchafe attidi biitta bolla diccizaazanne miththa bollan diza ayfe ubbaa lim7i histti mides. Hessa gishshas miththa hayththi woykko gaden diza cilila miishshi wuri Gibxe biitta ubbason aykkoyka attibeenna. ");
INSERT INTO gmvl_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Kawozikka Musenne Aaroone eeson xeygisidi, «GODAA intte Xoossanne inttena tani qohadis. ");
INSERT INTO gmvl_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Hekko intte tana wurseththa maaro maarite. Ha iita boshaa taappe diggana mala GODAA intte Xoossaa woossite» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musey kawoza achchafe kezidi GODAA woossides. ");
INSERT INTO gmvl_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","GODAYKKA arshey mokkiza baggara yida carkoza arshey wulliza baggara yida wolqqama carkon laammiin booleza tookki ekki efidi, Zo7o abbaan yeggides. Gibxe biitta kumeththaan issi booleykka attibeenna. ");
INSERT INTO gmvl_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Gidikkoka GODAY kawoza wozina minththida gishshas Isra7eele nayta yeddontta ixxides. ");
INSERT INTO gmvl_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Hessafe guye GODAY Muses, «Gibxe biittan girdi gida dhumay dhumana mala ne kushe pude salo denththa» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musey ba kushe pude salo denththiin Gibxe biitta ubbaan heedzdzu gallas kumeth girdi gida dhumay dhumides. ");
INSERT INTO gmvl_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","He heedzdzu gallassatan asi oonikka issoy issaa be7ontta, woykko sooppe kare kezontta gam7ides. Gido attiin Isra7eele nayti dizaso ubbaan isttas poo7oy dees. ");
INSERT INTO gmvl_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Kawozi Muse xeygisidi, «Biite; biidi GODAAS goynnite; intte maccassayka intte naytikka inttenara baana dandayeettes. Intte meheta gidikko haan aggi biite» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Gido attiin Musey izas, «Nuni xuuggidi yarshiza yarsho GODAA nu Xoossaas shiishshana mala mehe immada yeddanaas koshshees. ");
INSERT INTO gmvl_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Issi xugunththika attontta dishin nu mehey wurikka nunara baanaas bessees. Nuni gede gakkontta dishe mehaappe awayssa awayssa yarshanaakko ha7i eranaas dandayokko. GODAA nu Xoossaas, yarshos he mehaappe dooridi ekkanaas koshshees» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Gido attiin GODAY kawoza wozina minththida gishshas izi istta yeddanaas koyibeenna. ");
INSERT INTO gmvl_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Hessafe guye kawozi Muse, «Ta achchafe kichcha! Nam7anththo ta sinththan beettashe nena era! Nam7anththo ta ayfeso ne be7ida gallas ne hayqqana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Histtiin Musey izas, «Tumukka; neni gida mala tani nena nam7anththo mulekka beykke» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","GODAY Muses, «Tani Gibxe kawaa bollanne iza asaa bolla issi hara bosha yeddana; hessafe guye izi inttena ha biittaafe kessi yeddana; kessidi izi inttena issaade ashshontta ubbaa gooddi kessana. ");
INSERT INTO gmvl_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Isra7eele asay maccay addey ba shoorotappe birappenne worqqafe oosettida miishshata oychchi ekkana mala isttas yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","GODAYKKA Gibxe asay Isra7eele asaas kiyateth ooththana mala ooththides. Qasse Musey ba baggara Gibxe biittan kawoy sunththida daannataninne asan keehi daro bonchchettida asa mala xeelettides. ");
INSERT INTO gmvl_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Musey kawozas, «GODAY, ‹Giddi giddoth tani Gibxe biittan hemettana; ");
INSERT INTO gmvl_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Gibxe biittan diza attuma nay, kawoteththa algan uttida kawaas bayra naappe doommidi, woxan gaacciza aylley bayra naa gakkanaaska bayra yelettida meheykka attontta wuri hayqqana. ");
INSERT INTO gmvl_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Gibxe biitta ubbaan hayssafe kase gidiin woykko sinththafekka hanontta yeehoy yeekettana. ");
INSERT INTO gmvl_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Gido attiin Isra7eele nayta giddon asa bolla woykko mehe bolla asi attoshin kanaykka boccenna› gides. He wode GODAY Gibxessinne Isra7eele naytas giddon shaakoteth medhdhanayssa intte erana. ");
INSERT INTO gmvl_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ne sunththida daannati wuri taakko yiidi, ta sinththan gufanni ziggidi, ‹Kezada barkkii! Nena kaalliza asay wurikka bo!› gaana. Hessafe guye tani baana» gides. Musey daro hanqettidi iza sinththafe kezidi bides. ");
INSERT INTO gmvl_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","GODAY Muses, «Ta malalisiza miish Gibxe biittan gujja gujja ooththana mala kawoy intte yootizayssa siyenna» gi kase yooti woththides. ");
INSERT INTO gmvl_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Museynne Aarooney hayta malaatata ubbaa kawoza sinththan ooththikoka GODAY kawoza wozina minththida gishshas izi Isra7eele nayta ba dereppe yeddontta ixxides. ");
INSERT INTO gmvl_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Gibxe biittan GODAY Musenne Aaroone hizgides; ");
INSERT INTO gmvl_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Ha aginay inttes layththas koyro agina gido; ");
INSERT INTO gmvl_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Isra7eele asaa ubbaas hayssa ha wogaza yootite; hayssi aginay gelida tammanththa gallas, issi issi asi ba soo asas issi laaqqa doori ekko. ");
INSERT INTO gmvl_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","He keeththa asaa qooday laaqqaza ubbaa maanaas guuxxizaa gidikko izaadey baas matattiza guta ba soo asaa mala qoodidi issaadey issaadey mi wursanayssa shaakki eretto. ");
INSERT INTO gmvl_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Intte doori ekkana laaqqay yelettiin issi layth gididi iza bolla aykko borey baynda adde laaqqa gido. Intte laaqqaza dorsafe woykko deyshafe ekkanaas dandayeeta. ");
INSERT INTO gmvl_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ha aginay tammanne oydanththo gallas gidana gakkanaas istta naagite; he gallas arshey wullishin Isra7eele maabara asay wuri istta shukkanaas koshshees. ");
INSERT INTO gmvl_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Shukkidi suuththafe ekkidi istta ashoza miza keeththas qosilaththaanne qoreza bolla tiyetto. ");
INSERT INTO gmvl_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ashoza he gallas qammaka taman xiixidi, cammiza bonccoranne irshoy baynda uukettida ukeththara metto. ");
INSERT INTO gmvl_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ashoza qaye woykko doyssidi moopite; hu7eza; gedata; qanththa ashozakka ubbaa xiixidi miite. ");
INSERT INTO gmvl_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","He ashozappe gadey wonttana gakkanaas aykkoka ashshofte. Wonttana gakkanaas attidaazi diikko taman xuuggana koshshees. ");
INSERT INTO gmvl_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Miish, oges gidiza may7o may7idi, intte caamma tohon aaththidi intte guufe intte kushen oykkidi eeson miite; hayssi tana GODAA intte bonchchiza Paaziga yarsho. ");
INSERT INTO gmvl_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","«Tani he gallas qammara Gibxe biittara hemettashe bayra yelettida, asekka mehekka ubbaa wodhana. Gibxe eeqata ubbaa bollaka tani pirdana; tani GODAA gidikkinaa? ");
INSERT INTO gmvl_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","He suuththay intte diza keeththata erisiza malata gidana. Tani he suuththaa be7iza wode inttena agga aadhdhana; tani Gibxe biittaa boshan shociza wode intte bolla aykko boshaykka gakkenna. ");
INSERT INTO gmvl_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","«He gallassay tani GODAY inttes ooththidayssa qoppi qoppi bonchchiza gallas gido; intte zereththi wuri GODAA ba7aale bonchcho; hayssa inttes woga histtidi mernaas bonchchite. ");
INSERT INTO gmvl_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","«Laappun gallas gakkanaas irshoy gelontta uketh miite; koyro gallas intte sooppe irsho diggite. He koyro gallassafe doommidi laappunththa gallas gakkanaas, irshora diza uketh miza asi oonikka Isra7eele asaa giddofe shaaketti dhayo. ");
INSERT INTO gmvl_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Koyro gallas geeshsha duulata shiiqite; hara geeshsha duulata qasse laappunththa gallas shiiqite; asay wuri maanaas quma kaththofe attiin he gallassata ubbaan aykkoka ooththofte; intte ooththana miishshi hessa xalla. ");
INSERT INTO gmvl_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","«Tani inttena Isra7eele nayta Gibxe biittafe kessiday he gallas gidida gishshas Ukeththa ba7aale bonchchite. He gallassa ba7aaleza naa naas attontta woga histti bonchchite. ");
INSERT INTO gmvl_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Koyro aginan he aginaas tammanne oydanththa gallassa omarsafe doommidi nam7u tammanne issinththa gallassa omarsa gakkanaas irshoy gelontta uketh miite. ");
INSERT INTO gmvl_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Laappun gallas gakkanaas irshoy intte soon beettofo; irshoy gelida kath miza asi bete asi gidiin woykko he dere as oonakka gidiin hessaadey Isra7eele maabara giddofe dhayo. ");
INSERT INTO gmvl_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Irshoy gelidaaz aykkoka moopite; intte dizason awanka irshoy gelontta uketh maanaas bessees.» ");
INSERT INTO gmvl_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Hessafe guye Musey Isra7eele cimata ubbaa xeygisidi, «Intte biidi intte soo asaas Paaziga yarshos laaqqa ekki shukkite. ");
INSERT INTO gmvl_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Hisophphe geetettiza maata hayththafe danki ekkidi keren diza suuththaan gelththi kessidi, he suuththaa nam7u qosilaththataninne qoreta bolla tiyite; inttefe issi asikka gadey wonttana gakkanaas ba keeththafe kare kezoppo. ");
INSERT INTO gmvl_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","GODAY Gibxe bayra nayta wodhanaas he biittara hemettiza wode suuth keeththa qosilaththataninne qoreta bolla be7idi karera aadhdhi baana; wodhizayssi intte soo gelidi inttena wodhontta mala iza GODAY diggana. ");
INSERT INTO gmvl_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","«Intte hayssa azazoza inttessinne intte zereththas mernaas woga histtidi azazettite. ");
INSERT INTO gmvl_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","GODAY kase immana giidi caaqqida qaala mala izi immiza biittaa intte geliza wode ha wogaa naagite. ");
INSERT INTO gmvl_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Intte nayti inttena, ‹Hayssa ha wogazas birsheththi aazee?› gi oychchiko, ");
INSERT INTO gmvl_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","intte isttas, ‹Hayssi GODAA bonchchanaas yarshiza Paaziga yarsho; ays giikko GODAY Gibxe biittan Isra7eele asaa keeth aggi aadhdhidi Gibxe asaa wodhidi nuna ashshida gishshassa› giite» gides. Hessafe guye asay biitta bolla gufanni goynnides. ");
INSERT INTO gmvl_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Isra7eele asay biidi GODAY Musenne Aaroone azazida mala ooththides. ");
INSERT INTO gmvl_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Giddi giddoththan GODAY Gibxen bayra yelettida ubbaa kawoteththa algan uttiza kawo bayra naappe doommidi, qasho keeththan diza di7ettida asaa bayra naa gakkanaas, qasse bayra yelettida mehe ubbaa dippi histtides. ");
INSERT INTO gmvl_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Kawoy, izi sunththida daannatinne Gibxe biitta asay wuri qammara beeggides. Gibxe biittan asi hayqqontta keeththi mulekka baynda gishshas asay qaala dhoqqu histtidi daro waassi yeekkides. ");
INSERT INTO gmvl_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","He gallassa omars kawozi Musenne Aaroone xeygisidi, «Dendite! Intteka intte asaykka ta asaa giddofe kezite! Biidi intte oychchida malakka GODAAS goynnite! ");
INSERT INTO gmvl_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Intte gida malakka intte mehe; intte deyshinne dors ubbaa ekkidi biite! Qasse tanakka anjjite» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Isra7eele asay ba biittafe eeson kezana mala Gibxe asay dirbasides. Ays giikko istti, «Kezontta ixxiko nuni wurikka wurana» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Hessa gishshas Isra7eele asay irshoy gelontta munuqa keren kunththi may7on xaaxidi hashen tookkides. ");
INSERT INTO gmvl_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Isra7eele asay Musey istta azazida mala, Gibxe asaa bira, worqqanne may7o, «Immite» gi oychchides. ");
INSERT INTO gmvl_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","GODAY Gibxe asaa sinththan Isra7eele asay sabettana mala ooththida gishshas Gibxe asay istta oychchidayssa ubbaa immida. Hessaththo histtidi istta Gibxe asata aqo buuri ekki bida. ");
INSERT INTO gmvl_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Isra7eele asay Eraamise geetettiza katamappe dendidi Sukoote geetettizaso gakkanaas bides. Asay naytanne maccassaa gujjontta qoodiin tohon hemettiza attuma asay 600,000 gidides. ");
INSERT INTO gmvl_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Qasse isttara daro hara dere asay, keehi daro mehe, dorsinne deysh ekki kezides. ");
INSERT INTO gmvl_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Gibxeppe istti ekki kezida irshoy gelontta munuqappe uketh uukkida; ays giikko istta Gibxeppe eeson kessida gishshas baas shinqe kaththanaassinne munuqay dendiin uukkana wode istta gaththibeenna. ");
INSERT INTO gmvl_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isra7eele asay Gibxe biittan deyida layththay wuri oyddu xeetanne heedzdzu tamma. ");
INSERT INTO gmvl_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","He oyddu xeetanne heedzdzu tammu layththay wuriza he wurseththa gallassan GODAA asay wuri Gibxe biittafe kezides. ");
INSERT INTO gmvl_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Gibxe biittafe omarsa wode GODAY ba asaa kessishe naagida gishshas he qammay naa naa gakkanaas, Isra7eele asay wuri beeggi naagidi aqiza GODAAS dummatida qamma. ");
INSERT INTO gmvl_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","GODAY Musenne Aaroone, «Paaziga bonchchiza wogay hayssa; hara dere asi izappe oonikka mulera mooppo. ");
INSERT INTO gmvl_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Intte miishshan shammida aylley oonikka intte iza qaxxaridaappe guye izappe maanaas koshshees. ");
INSERT INTO gmvl_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Gido attiin guuththa wodes inttenara imaththateththan gam7izaynne une ooththiza hara dere asi izappe mooppo. ");
INSERT INTO gmvl_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","«Ha Paaziga yarshoza intte issi keeththan miite; intte he ashozappe aykkoka kare kessofte. Meqeththatappe issinokka menththofte. ");
INSERT INTO gmvl_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isra7eele maabaray wuri Paaziga yarsho bonchchanaas koshshees. ");
INSERT INTO gmvl_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","«Bete yiidi intte giddon diza asi GODAA Paaziga yarsho bonchchanaas koykko ba soon adde gidida asa ubbaa qaxxaro. Hessafe guye izi he biittan yelettida asa mala shiiqidi Paaziga yarsho bonchchanaas bessees. Gido attiin qaxxarettontta asi mulekka izappe mooppo. ");
INSERT INTO gmvl_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Intte biittan yelettidayssaska gidiin intte giddon bete gididi dizayssaska gidiin hayssi wogay ubbaas issino» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Histtiin Isra7eele asay wuri GODAY Musenne Aaroone azazida malakka ooththides. ");
INSERT INTO gmvl_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","He gallassankka GODAY Isra7eele nayta istta cugan cugan Gibxe biittafe kessides. ");
INSERT INTO gmvl_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","GODAY Muse hizgides, ");
INSERT INTO gmvl_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Adde gidi koyro yelettida ubbaa taas dummasa. Isra7eele asaa giddon koyro yelettida bayray wuri mehe gidiin as gidiin wurikka taassa.» ");
INSERT INTO gmvl_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Hessafe guye Musey asaa, «Gibxeppe, aylleteththa biittafe intte kezida gallassaya hanno gallassayo gididayssa yuushshi qoppite; ays giikko GODAY ba wolqqama qesen inttena kessides; hessa gishshas irshoy gelida kath aykkoka moopite. ");
INSERT INTO gmvl_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Intte ha gallassayn Abibe geetettiza aginan kezideta. ");
INSERT INTO gmvl_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","GODAY Kanaaneta, Hiiteta, Amooreta, Hiiwetanne Yaabuseta geetettiza dereta biittaa inttena gaththiza wode intte ha bonchcho gallassaa ha aginan bonchcheeta. He biittay GODAY inttes immana mala kase intte aawatas caaqqi woththida biitta. He biittay maaththinne eessi goggiza biitta. ");
INSERT INTO gmvl_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Intte laappun gallas irshoy gelontta uketh maana; laappunththa gallas GODAAS ba7aale histti bonchcheeta. ");
INSERT INTO gmvl_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","He laappun gallassatan irshoy gelontta uketh intte maana; intte giddon irshora dizay aykkoyka beettofo; ne biitta zawan awankka irshoy mulekka dooppo. ");
INSERT INTO gmvl_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","«He gallas neni ne naytas, ‹Tani hayssa ooththizay tani Gibxeppe keziza wode GODAY taas ooththidayssa zaari qoppanaassa› ga yoota. ");
INSERT INTO gmvl_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","GODAY inttena ba wolqqama kushen Gibxeppe kessida gishshas, GODAA wogay intte doonappe shaakettontta mala, hayssi ba7aalezi intte kushe bolla qashettidanne intte liiphen woththiin qofsiza miishsha mala gidana. ");
INSERT INTO gmvl_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Hessa gishshas intte ha wogaa woththidi layththan layththan ha gallassan bonchchite. ");
INSERT INTO gmvl_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«GODAY inttessinne kase intte aawatas immanaas caaqqida mala, izi inttena Kanaaneta biitta gelththidi, he biittaa inttes immiza wode, ");
INSERT INTO gmvl_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","attuma gidi yelettida bayra ubbaa GODAAS dummasite; ne mehe garsan adde gididi bayra yelettiday wuri GODAASSA. ");
INSERT INTO gmvl_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Bayra yelettiza hare mar ubbaa laaqqara laammada wozza; laammada wozzontta ixxiko iza morgen shoca wodha. Ne nayta giddon attuma gidi bayra yelettidayta ubbaa wozza. ");
INSERT INTO gmvl_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Wodeppe ne nay nena, ‹Hayssi aaza wogaa?› gi oychchiko, neni izas, ‹GODAY nuna ba wolqqama qesen aylleteththa biitta Gibxeppe kessides; ");
INSERT INTO gmvl_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Gibxe kawoy ba wozina minththidi nuna yeddontta ixxiin GODAY Gibxe biittan diza bayra ubbaa, asappe doommidi mehe bayra gakkanaas wodhides. Tani aayi uloppe koyro yelettida adde mehe ubbaa GODAAS yarshizayssinne bayra gidida attuma nayta ubbaa wozzizayssi hessassa› ga. ");
INSERT INTO gmvl_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","GODAY nuna ba wolqqama qesen Gibxeppe kessidayssas, hayssi inttes kushen qachchida malatanne liiphe bolla woththida malata mala gidana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Kawoy asaa yeddida wode Xoossi istta Filisxeeme biittara kanththisiza ogey mata shin he ogezara efibeenna; gaasoykka Xoossi, «Asay ola beykko ba qofaa laammidi guye Gibxe simmanaakko» giidi qoppides. ");
INSERT INTO gmvl_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Hessa gishshas Xoossi asaa bazzo ogera yuushshidi, Zo7o abbaako kaaleththides. Isra7eele asay Gibxe biittafe olas giigettida asa mala giigettidi Gibxeppe kezides. ");
INSERT INTO gmvl_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Yooseefey Isra7eele asaa, «Xoossi tumappe inttena maaddana yaana; he wode intte ta meqeththaa hayssafe inttenara ekki biite» giidi caaqeththi woththida gishshas Musey iza meqeththaa banara ekki bides. ");
INSERT INTO gmvl_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Istti Sukooteppe dendidi bazzo doonan diza Etaame geetettizason uttida. ");
INSERT INTO gmvl_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Istti gallassika qammaka hemettana mala GODAY istta oge bessanaas tuussa mala eqqida shaaran gallas, tuussa mala eqqida taman omars istta kaaleththides. ");
INSERT INTO gmvl_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Gallas tuussa mala eqqida shaaray, omars tuussa mala eqqida tamay asaa sinththafe ubba wode shaakettibeenna. ");
INSERT INTO gmvl_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","2","Hessafe guye GODAY Muses, «Istti guye simmidi Migidooleppenne abbaafe giddon, Pihaahiroote achchan uttana mala deraas yoota; istti abba achchan Ba7aali-Xafoone sinththan bazzaan uttetto. ");
INSERT INTO gmvl_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Gibxe Kawoy, ‹Bazzon ogey gordetti dhayiin Isra7eele asay bizaso dhaydi coo toylattees› giidi qoppana. ");
INSERT INTO gmvl_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Tani kawoza wozina minththana; izi istta gooddana; tani kawoza baggaranne iza olanchchata ubbaa baggara bonchchettana; Gibxe asaykka tani GODAA gididayssa erana» gides. Histtiin Isra7eele asay izi yootida mala ooththides. ");
INSERT INTO gmvl_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Asay kessi ekki bidayssa Gibxe kawos yootiin, izikka daannata Isra7eele nayta gishshas qoppida ba qofaa laammidi, «Nuni hayssaththo aazas ooththidonii? Nuni Isra7eele nayta yeddidi istti nuus ooththiza wolqqafe mela attidos» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Hessa gishshas kawozi ba para-gaareza kooridi olanchchata banara ekki bides. ");
INSERT INTO gmvl_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Izi ubbaafe aadhdhiza 600 para-gaareta, qasse Gibxe biittan diza para-gaareta ubbaa bollaka ola halaqata woththi ekki bides. ");
INSERT INTO gmvl_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","GODAY Gibxe biitta kawo wozina minththiin minoteththara buro buussa bolla diza Isra7eele asaa gooddides. ");
INSERT INTO gmvl_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Gibxe asay kawo para-gaareti wuri para asatinne olanchchati Isra7eele nayta kaalli gooddida. Abbaa doonan Ba7aali-Xafoone sinththan diza Pihaahiroote achchan istti utti dishin demmida. ");
INSERT INTO gmvl_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Kawozi matigdiin Isra7eele asay guye xeelliza wode, Gibxe asay istta guyera kaalli yizayssa be7idinne daroppe babbidi GODAAS waassida. ");
INSERT INTO gmvl_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Istti Muses, «Neni nuna Gibxe biittan nuus duufoy dhayiin bazzon hayqqana mala kessadii? Nuna Gibxeppe aazas ehadii? ");
INSERT INTO gmvl_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Nuni Gibxen dishe, ‹Nuna agga; nuni Gibxe asaas haarettana› giidi nees yootibeekkonii? Bazzon hayqqanaappe isttas haarettizayssi nuus lo7okkoshin» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musey asaa, «Babbofte; minni eqqite; GODAY hach inttena ashshanayssa intte beyana. Hach intte be7iza Gibxe asaa nam7anththo mulekka be7ekketa. ");
INSERT INTO gmvl_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Intte gishshas GODAY olettana; inttefe koyettizay co7u guus xalala» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","GODAY Muse, «Neni taakko ays waassay? Isra7eele asay gede sinththe baana mala yoota. ");
INSERT INTO gmvl_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Isra7eele asay mela biitta bollara abbaa pinni baana mala ne guufe denththadanne ne kushe abbaa bolla piddisada haaththaa nam7u kessa shaakka. ");
INSERT INTO gmvl_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Tani Gibxe asa wozina minththiko istti intte guye kaallidi abban gelana. Tani kawozanne iza olanchchata ubbaa bolla, iza para-gaaretanne toga asata bolla taas bonchcho demmana. ");
INSERT INTO gmvl_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Tani kawoza baggara iza para-gaareta baggaranne iza toga asata baggara taas bonchcho demmida wode tani GODAA gididayssa Gibxe asay erana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Hessafe guye kase Isra7eele asaa sinththara biza Xoossa kiitanchchay asaappe guye aadhdhi eqqides. Tuussa mala shaaraykka istta sinththafe guye bagga yuuyidi, ");
INSERT INTO gmvl_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Gibxe asaassinne Isra7eele naytas giddon aadhdhi eqqides. He shaaray omars issi baggara dhumisidi hankko baggara poo7isides; histtiin omars kumeth issoy issaakko shiiqana dandaybeettenna. ");
INSERT INTO gmvl_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Hessafe guye Musey abbaa bollan ba kushe piddisides; GODAY he gallassa omars kumeth arshey mokkiza baggafe wolqqama carko yeddidi, abbaa shaakki shaakkidi mela biitta kessides. Haaththayka nam7an shaakettides. ");
INSERT INTO gmvl_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Isra7eele asay abbaa giddon mela biittara hemettidi haaththi isttas ushachcharanne hadirsara goda mala eqqiin bida. ");
INSERT INTO gmvl_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Gibxe asay kawo parati wuri, para-gaaretinne toga asay istta gooddi ekkidi abbaa giddo gelida. ");
INSERT INTO gmvl_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Buro bazzoy zo7anaappe kasetidi GODAY tamaninne tuussa mala shaaran gididi, Gibxe olanchchata xeellida wode istta wozinay dhaydes. ");
INSERT INTO gmvl_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","GODAY istta para-gaareta toho qachchi oykkida gishshas laagoy bana waayisiin Gibxe asay, «GODAY istta maaddidi Gibxe oliza gishshas ane nuni Isra7eele asaappe baqatoos» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","GODAY Muse, «Haaththay Gibxe asaa bolla, istta para-gaareta bollanne toga asata bolla guye goggana mala ne kushe abbaa bolla piddisa» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musey ba kushe abbaa bolla piddisides; gadey wontishin abbay kase ba diza soho guye simmides; Gibxe asay gede iza giddo baqatishin GODAY Gibxe asaa heen abbaa giddon yeggides. ");
INSERT INTO gmvl_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Haaththay guye simmidi para-gaareta toga asatanne Isra7eele nayta kaallidi abban gelida kawo olanchchata mule mitti aggides; isttafe issaadeyka attibeenna. ");
INSERT INTO gmvl_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Gido attiin Isra7eele asay haaththi isttas ushachcharanne hadirsara goda mala eqqi dishin abbaa giddora mela biitta bollara hemetti bides. ");
INSERT INTO gmvl_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","GODAY he gallas Isra7eele asaa Gibxe asaa kusheppe hayssaththo ashshides. Qasse Isra7eele asay Gibxe asaa aha abba doonan be7ides. ");
INSERT INTO gmvl_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","GODAY Gibxe asa bolla bessida gita wolqqaa be7idi Isra7eele asay GODAAS babbidessinne izanne iza aylle Musekka ammanides. ");
INSERT INTO gmvl_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","He wode Museynne Isra7eele asay hayssa mazamureza GODAAS yexxides; «Bonchchon izi keehi dhoqqu dhoqqu gida gishshas, tani GODAAS mazamure yexxana. Paranne para toggida asaa abba giddon yeggides. ");
INSERT INTO gmvl_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","GODAY taas wolqqanne mazamure; izi tana ashshides. Izi ta Xoossa; tani iza sabbana. Izi ta aawa Xoossa; tani iza dhoqqu dhoqqu histtana. ");
INSERT INTO gmvl_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","GODAY olanchcha; iza sunththika GODAA. ");
INSERT INTO gmvl_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Gibxe kawo para-gaaretanne iza olanchchata abban wursides; ubbaafe aadhdhi doorettida Gibxe kawo halaqati, Zo7o abbaan mitettida. ");
INSERT INTO gmvl_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ciimma haaththi istta kammides; istti shuchchaththo ciimman mitettida. ");
INSERT INTO gmvl_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","«Abeet GODAWU! Ne ushachcha kushey wolqqan goobides; GODAWU ne wolqqama ushachcha kushey morkke menththereththides. ");
INSERT INTO gmvl_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ne gita wolqqaan nenara eqettidayta kundisadasa. Eexxiza ne hanqo ne yeddadasa, izikka istta gafe mala mides. ");
INSERT INTO gmvl_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ne peenoy haaththaa pude essi doorides. Goggiza haaththika goda mala minni eqqides; ciimma giddon diza haaththi abbaa giddon irkkides. ");
INSERT INTO gmvl_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","«Morkkey ceeqettishe, ‹Tani istta yedeththa oykkana. Tani istta haaro shaakkada, ta koyidayssa ubbaa ekkana. Tani ta giththa mashsha shoddada, istta dhayssana› gides. ");
INSERT INTO gmvl_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Gido attiin neni istta ne peenon punniin, abbay istta kammides. Istti wolqqama haaththan biratay mitettiza mala mitettida. ");
INSERT INTO gmvl_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","«Abeet GODAWU! Eeqa xoossata giddon ne malay oonee? Geeshshateththan bonchchettizay, bonchchon babisizaynne, malalisiza miish ooththizay ne malay oonee? ");
INSERT INTO gmvl_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Neni ne ushachcha kushe piddisadasa, biittayka istta mittides. ");
INSERT INTO gmvl_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","«Ne wozzida ne asaa wurontta ne siiqon kaaleththadasa. Neni ne wolqqan istta ne aqiza geeshsha soo gelththadasa. ");
INSERT INTO gmvl_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Dere asay hessa siyidi kokkorides. Filisxeeme biitta asatakka hirga miixay oykkides. ");
INSERT INTO gmvl_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","He wode Eedoome biitta halaqati dagammida. Mo7aabe biitta haarizayti hirgan kokkorida. Kanaane dere asay wuri seerides. ");
INSERT INTO gmvl_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Abeet GODAWU! Dagamaynne hirgay istta oykkana. Istti ne wolqqa gitateth be7idi, ne asay aadhdhana gakkanaas, neni wozzida asay aadhdhana gakkanaas, shuchcha mala toletti eqqana. ");
INSERT INTO gmvl_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Neni istta ehada, nees buzo biittan diza zuma hu7en tokkana. Abeet Mernaa Godoo, he sohoy neni nees deyanaas ooththida sohokko. Abeet GODAWU! He geeshsha sohoy neni ne kushen minththa essida sohokko. ");
INSERT INTO gmvl_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","GODAY mernaappe mernaa gakkanaas kawotana.» ");
INSERT INTO gmvl_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Gibxe kawo parati wuri, para-gaaretinne toga asati abbaan gelida wode GODAY istta bolla abba haaththaa guye zaari ehides; gido attiin Isra7eele asay abbaa giddora mela biitta bollara hemettidi pinnides. ");
INSERT INTO gmvl_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Aaroone michcheya, nabe Maarama karabe ekkadus; maccassay wuri karabe baqqidi yexxishenne guppishe izo kaallides. ");
INSERT INTO gmvl_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Maarama isttas mazamureza yexxashe, «GODAY keehi dhoqqu dhoqqu gida gishshas izas yexxite. Paranne para toggidayta izi abban olides» ga yexxadus. ");
INSERT INTO gmvl_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Hessafe guye Musey Isra7eele asaa Zo7o abbaafe pinththiin istti Shuura geetettiza bazzo bida. He bazzon istti haath demmontta heedzdzu gallas hemettida. ");
INSERT INTO gmvl_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Istti Maara geetettizaso gakkida wode Maara haaththi camo gidida gishshas uyana dandaybeettenna; hessa gishshas he sohoy Maara geetettides. ");
INSERT INTO gmvl_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Asaykka, «Nuni ay uyanee?» giidi Muse bolla zuuzumides. ");
INSERT INTO gmvl_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musey GODAAS waassiin GODAY iza issi mith bessides; Musey he miththaa haaththaan yeggiin haaththay mal7ides. Heen GODAY isttas woganne maara kessidessinne istta paaccides. ");
INSERT INTO gmvl_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Izi isttas, «GODAA intte Xoossay yootizayssa intte lo7eththi siyikko, iza ayfe sinththan lo7o ooththiko, intte iza azazo wozinan woththi naagikko, iza wogaakka ubbaa naagikko, tani Gibxe asaa bolla ehida hargefe issaaka intte bolla ehikke; gaasoykka tani inttena paththiza GODAA» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Hessafe istti tammanne nam7u haaththa pulttotinne laappun tammu zamba miththati dizaso Eelaame yiidi heen haaththa doonan uttida. ");
INSERT INTO gmvl_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Gibxeppe kezida nam7anththo aginan, tammanne ichchashanththo gallassan Isra7eele asaa maabaray kumeth Elaameppe dendi biidi Eelaameppenne Siinappe giddon diza Siine geetettiza bazzo yida. ");
INSERT INTO gmvl_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Isra7eele asaa maabaray wuri bazzon Muse bollanne Aaroone bolla zuuzumides; ");
INSERT INTO gmvl_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","«GODAY nuna Gibxe biittan ba kushen wodhidaakko lo7okkoshin! Heen nuni asho miza kereza yuuyi aadhdhi uttidi nuni koyida mala kath kalli midos; gido attiin intte nuna heeppe kessidi hayssa deraa ubbaa gafan wodhanaas haa bazzo ehideta» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Histtiin GODAY Muses, «Tani inttes saloppe miza kath bukisana; asay ubba gallassika kezidi hachchis hachchis gidanaaz xalala maxana koshshees. Asay ta azazo kaallizaakkonne kaallonttaako tani istta hessan paacca xeellana. ");
INSERT INTO gmvl_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Usuppunththo gallas istti hara wode maxizayssas nam7u kushe maxidi kaththetto» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Hessa gishshas Museynne Aarooney Isra7eele asa ubbaas, «Inttena Gibxe biittafe kessiday GODAA gididayssa hach omars intte erana. ");
INSERT INTO gmvl_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Qasse iza bolla intte zuuzumidayssa izi siyida gishshas maalado intte GODAA bonchcho beyana. Intte nu bolla zuuzumanaas nuni oonee?» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Hessafe guye Musey, «Intte iza bolla zuuzumidayssa izi siyida gishshas izi inttes maanaas omars asho immiko intte koyida mala miza ukeththaaka ubbaa inttes maalado immana. Nu oonee? Intte GODAA bolla zuuzumideta attiin nu bolla zuuzumibeekketa» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Musey Aaroones, «Neni Isra7eele asaa maabara ubbaa, ‹GODAY intte zuuzunththaa siyida gishshas GODAA sinth shiiqite› ga yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aarooney Isra7eele asaa maabara ubbaas yootida mala asay bazzo simmi xeellishin heen GODAA bonchchoy shaarara qonccidayssa be7ida. ");
INSERT INTO gmvl_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","GODAY Muses, «Tani Isra7eele nayta zuuzunththaa siyadis; neni isttas, ‹Intte omarsa wode asho maana; maalado uketh kallana; he wode tani GODAA intte Xoossaa gididayssa intte erana› gaada yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","He gallassa omarsa wode kurachoti yiidi Isra7eele asay dizason kumida; qasse maalado istti dizaso yuushon xaazay may7i uttides. ");
INSERT INTO gmvl_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Xaazay xoskishin biitta bollan booththa shach misatiza liiqo miishshi beettides. ");
INSERT INTO gmvl_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Isra7eele asay hessa be7idi ba garsan issoy issaa, «Hayssi aazee?» gida. Ays giikko istti izi aazakko eribeettenna. Histtiin Musey isttas, «Inttes maanaas GODAY immida kaththi hayssako. ");
INSERT INTO gmvl_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","GODAY, ‹Asay issoy issoy baas maanaas koshshiza mala shiishsho; intte soo asaas hu7en hu7en issi issi kilonne bagga ekkite› gi azazides» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Isra7eele asay Musey isttas yootida mala ooththides; baggay darssidi baggay qasse guuththidi shiishshida. ");
INSERT INTO gmvl_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Shiishshidi istti makkiin darssidi shiishshidayssas palahibeenna; guuth shiishshidayssaska paccibeenna; wurikka issoy issoy baas gidiza mala shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Hessafe guye Musey isttas, «Oonikka izappe wontos ashshofo» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Gidikkoka isttafe baggay Musey yootizayssa ekkontta aggidi attidayssa wonto maalado gakkanaas woththida; woththidayssika guxunidi xinqqides. Hessa gishshas Musey istta hanqettides. ");
INSERT INTO gmvl_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Maalado maalado asay wuri baas koshshizayssa lagge shiishshides; arshey michchiza wode biittan attidayssi maayides. ");
INSERT INTO gmvl_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Usuppunththa gallassan istti kaseyssas nam7u kushe issi issi asas heedzdzu kilo shiishshida. Histtiin maabara halaqati wuri yiidi hessa Muses yootida. ");
INSERT INTO gmvl_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Izi isttas, «GODAY azazidayssi hayssa; wontoy shemppo gallassa, GODAAS geeshsha sambata. Hessa gishshas intte uukkanayssa uukkite; intte doyssanayssaka doyssite; palahidayssa wontos ashshite» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Hessa gishshas istti Musey azazida mala wontos woththiin xinqqibeenna woykko guxunibeenna. ");
INSERT INTO gmvl_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Wonteththa gallas Musey isttas, «Hayssa hach mi wursite; ays giikko hach GODAA Sambata; intte iza hach demban demmeketa. ");
INSERT INTO gmvl_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Intte usuppun gallassan iza shiishshite; gido attiin laappunththa gallassay sambata gidida gishshas aykkoyka deenna» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Gido attiin issi issi asati laappunththa gallassan shiishshanaas kezida shin aykkoka demmibeettenna. ");
INSERT INTO gmvl_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","GODAY Muses, «Intte ta azazotanne ta wogata naagoza ayde gakkanaas ixxanee? ");
INSERT INTO gmvl_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ta inttes Sambata immidayssa akeekite; usuppunththa gallassan ta inttes nam7u gallassas kath immizayssi hessa gishshassa. Laappunththa gallas wurikka ba dizason dizason taakko; oonikka awakka booppo» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Hessa gishshas asay laappunththa gallassan shempides. ");
INSERT INTO gmvl_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Isra7eele asay he kaththaza manna gi sunththides. Izikka deebbo ayfe mala gididi booththa; eessara uukettida ukeththa mala mal7ees. ");
INSERT INTO gmvl_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musey Isra7eele asaas, «GODAY azazidayssi hayssa, ‹Tani inttena Gibxe biittafe kessida wode, bazzon mizida kaththaa istti beyana mala, mannafe issi issi kilonne bagga intte sinththafe yaana yeletatas ashshi woththite› gi azazides» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Histtiin Musey Aaroone, «Issi xaaro ekkada issi kilonne bagga gidiza manna izan qola; histtada yaana yeletatas minjjana mala GODAA sinththan woththa» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","GODAY Muse azazida mala minjjanaas, Aarooney mannaa GODAA markka Taabotaa sinththan woththides. ");
INSERT INTO gmvl_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isra7eele asay ba daana biitta bi gakkanaas oyddu tammu layth kumeth manna mida; Istti Kanaane biitta zawa gakkanaas manna mishe de7ida. ");
INSERT INTO gmvl_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Issi kiloynne baggay he wode makkiza gita maka miishshas tammaafe issi kushekko. ");
INSERT INTO gmvl_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Isra7eele maabaray wuri GODAY azazida mala Siina geetettiza bazzofe dendi biidi Erafidime geetettizason uttides; gido attiin asaas uyanaas haaththi heen beettibeenna. ");
INSERT INTO gmvl_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Hessa gishshas istti Musera ooyettidi iza, «Nuus uyana haath imma» gida. Musey zaaridi, «Intte tanara ays ooyetteetii? GODAA intte ays paacceetii?» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Gido attiin asay heen saamettidi Muse bolla zuuzumides. Istti, «Neni nuna, nu naytanne nu mehe saamon wodhdhanaas Gibxeppe ays kessadii?» giidi Muse bolla gugumida. ");
INSERT INTO gmvl_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Histtiin Musey, «Tani ha asaa wosttoo? Istti tana shuchchan caddana geettes» giidi GODAAKKO waassides. ");
INSERT INTO gmvl_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","GODAY Muse, «Isra7eele asaa cimatappe nenara ekkada, kase neni Abbaye Shaafa haaththaa izara shocida guufeza ne kushen oykkada asaappe sinth ba. ");
INSERT INTO gmvl_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Tani Siina zuman diza zaallaa bolla heen ne sinththan eqqada naagana; neni he zaallaa shoca; asay uyana mala haaththi izappe kezana» giin Musey Isra7eele cimata sinththan izi gida mala ooththides. ");
INSERT INTO gmvl_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Isra7eele asay, «GODAY nu giddon dizeyee? Deennee?» gi GODAA paaccidi ooyettida gishshas he sohoza Musey Maasanne Mariiba gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amaaleeqe asay yiidi Erafidimen Isra7eele nayta olides. ");
INSERT INTO gmvl_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musey Iyaaso, «Neni nuus asaa garsafe issi issi as doora ekkada wonto Amaaleeqetara olettana keza; tanikka Xoossa guufe oykkada dhoqqasohon eqqana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Iyaasoy Musey gida mala, Amaaleeqetara olettides. Musey, Aarooneynne Huurey dhoqqaso kezida. ");
INSERT INTO gmvl_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Musey ba kushe pude denththishin Isra7eele asay xoonees shin izi ba kushe ziqqisishin Amaaleeqe asay xoonees. ");
INSERT INTO gmvl_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Muse kushey ixettishin Aarooneynne Huurey shuch ekki ehidi Muse iza bolla utisida. Istti issoy issi baggara ushachcha kushaa issoy issi baggara hadirsa kushaa dhoqqu histti oykkida. Histtiin arshey wullana gakkanaas iza kushey dhoqqu gi gam7ides. ");
INSERT INTO gmvl_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Hessa gishshas Iyaasoy Amaaleeqe olanchchatanne Amaaleeqe asaa giththa mashshan xoonides. ");
INSERT INTO gmvl_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Hessafe guye GODAY Muses, «Tani Amaaleeqe asay qofettontta mala istta biitta bollafe kumeth dhayssana. Hayssi ubba wode qofettana mala maxaafan xaafada Iyaasos nababa sissontta aggofa» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Museykka yarsho yarshizaso ooththidi, «GODAY ta Bandira» gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Qasseka, «Tumappe GODAY ba kushe denththidi yeletappe yeleta gakkanaas Amaaleeqetara olettanaas caaqqides» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Midiyaame biitta qeese, Muse bollo Yootorey, Xoossay Musessinne iza asaa Isra7eele naytas ooththidayssa hessika GODAY istta Gibxe biittafe kessidayssa ubbaa siyides. ");
INSERT INTO gmvl_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","He wode Muse bollo Yootorey, Musey guye zaari moyzida Muse machcheyo Xipooronne izi nam7u nayta banara ekki yides. Museykka, «Tani asa biittan bete as gidadis» gishe bayra naaza Gershoome gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Qasseka, «Ta aawaa Xoossi tana maaddides; izi tana Gibxe kawo toorappe ashshides» gishe Nam7anththo naaza El7ezeere gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Muse bollo Yootorey Muse attuma naytaranne Muse machcheyra gididi bazzon Xoossa zuma achchan diza Musekko yides. ");
INSERT INTO gmvl_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Izi, «Tani ne bollo Yootorey, ne machcheyranne izi nayta nam7atara neekko he boos» giidi kiita Musekko yeddides. ");
INSERT INTO gmvl_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Hessa gishshas Musey ba bollozara gaagganaas kezidi hokkidi iza yeerides. Istti issoy issaa saroththidaappe guye Muse dunkaane giddo gelida. ");
INSERT INTO gmvl_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","GODAY Isra7eele asaa gishshas Gibxe kawo bollanne Gibxe asaa bolla ooththidayssa, oge bolla istta gakkida daaburanne GODAY istta ashshidayssa ubbaa Musey ba bollozas yootides. ");
INSERT INTO gmvl_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Isra7eele asaa, Gibxe asaa kusheppe ashshanaas GODAY ooththida lo7o ooso ubbaa siyidi Yootorey ufayettides. ");
INSERT INTO gmvl_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","«Inttena Gibxe asaa kusheppenne kawo Paaroone kusheppe ashshida GODAY ba asaa Gibxe asaa kusheppe kessi ekkidayssi izi galatetto. ");
INSERT INTO gmvl_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Izi Isra7eele asaa bolla otorettidaytas hayssa ooththida gishshas GODAY hara eeqa xoossata ubbaafe gooba gididayssa tani ha7i eradis» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Hessafe guye Muse bollo Yootorey xuugettiza yarsho qasseka hara yarshota Xoossas shiishshides. Aarooneynne Isra7eele cimati wuri Xoossa sinththan Muse bollozara kath maanaas yida. ");
INSERT INTO gmvl_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Wonteththa gallas Musey asaas pirdanaas uttiin asay iza sinththan yiidi yiidi eqqiza gishshas Musey maaladoppe omarsa wode gakkanaas uttides. ");
INSERT INTO gmvl_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Muse bolloy Musey asaas ooththizayssa ubbaa be7idi, «Neni ha asaas ooththizayssi hayssi aazee? Hayssi asay wuri maaladoppe doommidi omarsa wode gakkanaas ne sinththan yiidi yiidi eqqishin, maadoy baynda asa mala neni nerkka ays pirdas uttadii?» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Histtiin Musey ba bollozas, «Asay Xoossa shene oychchanaas taakko yiza gishshassa. ");
INSERT INTO gmvl_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Istta giddon yo7oy diikko taakko yeettes; tanikka istta giddon diza yo7o pirdays; Xoossa maaraanne wogaa istta erisays» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Yootoreykka, «Hayssi neni ooththizayssi lo7o deenna. ");
INSERT INTO gmvl_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Neninne nenara diza asay daabura xalala daabureeta; hayssi oosozi nees daro deexo; neni hayssa nerkka ooththanaas dandayakka. ");
INSERT INTO gmvl_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ane ha7i ta nena zorays! Ta yootizayssa siya; Xoossi nenara gido. Neni ha asaa gishshas Xoossa sinththan eqqa; asaza yo7okka Xoossako shiishsha. ");
INSERT INTO gmvl_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Xoossa maaraanne wogaa istta neni tamaarsa; istti waani daanaakko istti ooththana ooso istta bessa. ");
INSERT INTO gmvl_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Qasse asa ubbaa giddofe era asata, Xoossas babbizayta, ammanettidaytanne matta7e ixxizayta doorada isttafe asaas shaalaqata, mato halaqata, hamsa halaqatanne asira halaqata histta sunththa. ");
INSERT INTO gmvl_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Istti ubba wode asaas pirdetto; gido attiin deexo yo7o ubbaa neekko ehetto; waayisontta yo7o ubbaa istti heen wursetto. Istti nenara gishettiza gishshas toohoy nees kawuyana. ");
INSERT INTO gmvl_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Neni hessaththo ooththiko hayssi Xoossa shene gidikko neni daro daaburakka. Qasse ha asay wurikka ba yo7oy polettiin ufayssan ba soo ba soo baana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musey ba bolloza qaala siyides; izi gidayssa ubbaaka ooththides. ");
INSERT INTO gmvl_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Musey Isra7eele ubbaa giddofe era asata dooridi asaa kaaleththiza shaalaqata, mato halaqata, hamsa halaqatanne asira halaqata histti sunththides. ");
INSERT INTO gmvl_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Isttika asaas ubba wode pirdida; bana deexxida yo7oza Musekko ehida shin deexxontta yo7oza ubbaa barkka wursida. ");
INSERT INTO gmvl_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Hessafe guye Musey ba bollo Yootore moyziin Yootorey guye ba dere simmides. ");
INSERT INTO gmvl_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Isra7eele asay Gibxeppe kezida heedzdzanththo aginan koyro gallas Siina bazzo gakkides. ");
INSERT INTO gmvl_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Istti Erafidimeppe dendidi Siina bazzo biidi bazzon diza zumaa sinththan uttida. ");
INSERT INTO gmvl_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Museykka Xoossaako pude zumaa bolla keziin GODAY zumaa bolla dishe iza xeygidi, «Neni Yaaqoobe keeththa as gidida Isra7eele naytas hizga yoota; ");
INSERT INTO gmvl_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‹Tani Gibxe asaa bolla ay ooththidaakko qasse golle kafoy ba naa ba qefen tookkiza mala tani inttena wostta tookkada taakko ehidaakko intte intte ayfera beyideta. ");
INSERT INTO gmvl_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Histtiin ha7i intte taas kumeth azazettiko, intte ta caaqo qaalaa naagikko, kumeththa deraa garsan intte taas buzo dere gidana. Biittay wuri taas gidikkoka, ");
INSERT INTO gmvl_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","intte ta kawoteththaas dumma shaakettida qeesetanne dumma dere gidana;› Neni Isra7eele naytas yootana qaalay hayssa» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Histtiin Musey zumaa bollafe duge asaakko wodhidi dere cimata xeygi shiishshidi GODAY yoota gida qaalata ubbaa isttas yootides. ");
INSERT INTO gmvl_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Asay wuri issi qaalan gididi, «GODAY gidayssa ubbaa nu ooththana» giin Musey istti gidayssa GODAAKKO ekki bides. ");
INSERT INTO gmvl_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","GODAY Muse, «Tani nenara haasayshin asay siyana malanne istti nenan ubba wodekka ammanettana mala, tani neekko wolqqama shaarara yaana» gides. Hessafe guye Musey asay gidayssa GODAAS yootides. ");
INSERT INTO gmvl_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","GODAY Muses, «Neni asaakko baada hachchinne wonto istta geeshsha. Istti ba may7o meeccidi, ");
INSERT INTO gmvl_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","heedzdzanththo gallassas giigettetto. Gaasoykka heedzdzanththo gallassan asay wuri beyishin tani GODAY Siina zuma bolla wodhdhana. ");
INSERT INTO gmvl_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Neni asay dizaso yuushon asaas zawa woththada isttas, ‹Zuma bolla pude kezontta mala woykko zumaa xapho bochchontta mala inttena erite. Zuma bochchiday oonikka tumappe hayqqanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","As woykko mehe gidiin zawa pinni aadhdhiko oonikka ba kushen iza bochchontta shuchchan caddidi woykko wondafen dukkidi wodho› gees. Zaye goochchi punniko istti pude zumaa bolla kezana dandayeettes» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Musey zumaappe asaakko duge wodhdhidaappe guye asaa geeshshiin asay ba may7o meeccides. ");
INSERT INTO gmvl_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Asaakka, «Heedzdzanththo gallassas giigettite; maccassara aqopite» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Heedzdzanththo gallas maalado dada giirissi siyettides. Wolqqanththa poo7oynne wolqqama shaaray zumaa bolla beettides; Zayey punettiza daro wolqqama giirissi siyettides. Hessa gishshas asay wuri ba dizason babbidi kokkorides. ");
INSERT INTO gmvl_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Museykka asaa Xoossara gaththanaas asay dizasoppe kessiin asay zumaa achchan eqqides. ");
INSERT INTO gmvl_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","GODAY Siina zumaa bolla tamara wodhdhida gishshas gita cooceppe keziza mala cuway tullu gi kezidi zumaa kumeth kammides; zumazi kumeth keehi qaaxxides. ");
INSERT INTO gmvl_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Zayeza giirissayka keehi dari dari bida wode Musey haasayiin haasayiin Xoossi izas zaari zaaridi qaalan haasaydes. ");
INSERT INTO gmvl_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","GODAY kase Siina zumaa bolla wodhdhida wode Muse pude zumaa hu7e xeygiin Musey pude kezides. ");
INSERT INTO gmvl_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","GODAY iza, «Neni duge baada asay beyana giidi haa taakko zawa aadhdhontta malanne isttafe daroti hayqqontta mala asaa hanqa. ");
INSERT INTO gmvl_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Haray attoshin ta mata shiiqiza qeesetikka ubba wode bana geeshshanaas koshshees; histtontta ixxiko GODAY istta qaxxayana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musey GODAAS, «Asay zumaa bolla pude yaanaas dandayenna; ays giikko neni ne hu7en, ‹Ha sohoza geeshsha mala dummasada, ha zumaa achchan zawa woththite› gaada nuus yoota woththadasa» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Histtiin GODAY iza, «Neni duge ha7i elle wodhdhada pude keza. Aarooneykka nenara yo. Qeesetanne asaa ta qaxxayontta mala istti zawa pinnidi pude taakko yoopetto» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Hessa gishshas Musey duge asaakko wodhdhidi GODAY gidayssa isttas yootides. ");
INSERT INTO gmvl_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","GODAY haasayda qaalati ubbay hayssafe kaallizayta; ");
INSERT INTO gmvl_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«Nena Gibxeppe aylleteththa biittafe kessida GODAA ne Xoossay tana. ");
INSERT INTO gmvl_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","«Taappe attiin hara eeqa xoossatas goynnofa. ");
INSERT INTO gmvl_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","«Bolla salon diza miish gidiin, woykko garsa sa7an diza miish gidiin, woykko biittafe garsan haaththa giddon diza miish gidiin aykkoka misatissada nees misle histtada medhdhofa. ");
INSERT INTO gmvl_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Isttas hokkofanne isttas goynnofa. Ays giikko tani GODAA ne Xoossay qanaatiza Xoossako; tana ixxizayta aawata nagara gishshas nayta heedzdzanththo yeletanne oydanththo yeleta gakkanaas qaxxayays. ");
INSERT INTO gmvl_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Qasse tani tana siiqizaytassinne ta azazo naagizaytas daro shii yeleteth gakkanaas tani ta siiqo bessiza Xoossa. ");
INSERT INTO gmvl_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","«GODAA ne Xoossaa sunth hadan denththofa; ays giikko GODAA ne Xoossay ba sunth hadan denththizayta qaxxayana. ");
INSERT INTO gmvl_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","«Sambata gallassa hara gallassatappe dummasada naaga. ");
INSERT INTO gmvl_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ne ooththiza ooso ubbaa usuppun gallassatan ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Gido attiin laappunththa gallassay GODAA ne Xoossaas Sambata. He gallas aykko oosokka ooththofa; neni woykko ne attuma nay, woykko ne macca nay, woykko ne attuma aylley, woykko ne macca aylley, woykko ne miizay, woykko ne deren diidi nees ooththiza hara dere as gidiin he gallassan ay oosokka ooththofte. ");
INSERT INTO gmvl_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ays giikko usuppun gallassan GODAY salo, sa7a, abbanne istta giddon diza ubbaa medhdhidi laappunththa gallas shempides. Hessa gishshas GODAY Sambata gallassaa anjjidessinne dummasides. ");
INSERT INTO gmvl_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","«GODAA ne Xoossay nees immiza biittan ne daro layth daana mala, ne aawaanne ne aayo bonchcha. ");
INSERT INTO gmvl_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","«As wodhoppa. ");
INSERT INTO gmvl_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","«Laymatoppa. ");
INSERT INTO gmvl_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","«Kaysotoppa. ");
INSERT INTO gmvl_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","«Oona bollaka wordo markkattofa. ");
INSERT INTO gmvl_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","«Asa keeth amottofa; asa machcho woykko iza aylle woykko iza aylleyo woykko iza boora woykko iza hare woykko izas diza ay miishshika amottofa» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Asay wuri daday giirizayssanne zayey zayetizayssa siyidi qasse wolqqanththi wolqqamizayssanne zumay cuwattizayssa be7idi kokkorishe haahon eqqides. ");
INSERT INTO gmvl_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Asay Muses, «Nuni hayqqontta mala Xoossi nunara haasayoppo; neni nuus yoota; nuni siyana» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musey asaas, «Xoossi inttena paaccanaas, iza yashshi intte wozinan kumiin intte nagara ooththontta mala yida gishshas babbofte» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Asay haahon eqqi dishin Musey Xoossi dizaso wolqqama shaara dhumaakko shiiqides. ");
INSERT INTO gmvl_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Hessafe guye GODAY Muse, «Isra7eele asaas, ‹Tani saloppe inttes haasayshin intte intte ayfera be7ideta. ");
INSERT INTO gmvl_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Taappe attiin hara xoossi inttes dooppo; birappe woykko worqqafe inttes eeqa xoossata medhdhidi goynnofte. ");
INSERT INTO gmvl_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","« ‹Neni taas yarsho yarshizaso urqqafe medhdhada xuugettiza yarshota, issifeteththa yarshota, ne dorsatappe, ne deyshatappenne ne mehetappe iza bolla yarsha. Ta sunththi qofettana mala, intte ooththidaso ubbaa soho yaada ta inttena anjjana. ");
INSERT INTO gmvl_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Neni taas yarsho yarshizaso shuchchafe ooththizaa gidikko masettida shuchchafe ooththofa; ays giikko neni massiza biratan iza bochchiko ne iza tunisaasa. ");
INSERT INTO gmvl_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Taas yarsho yarshizaso pude kezanaas yangare medhdhada iza bolla kezoppa; gaasoykka neni keziza wode ne kalloteththi beettana› gaada yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","«Neni Isra7eele naytas immana wogay hayssa. ");
INSERT INTO gmvl_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Neni Isra7eele nayta garsafe aylle shammiko izi nees usuppun layth ooththo; gido attiin laappunththa layththan izi aykkoka qanxxontta aylleteththafe coo mela yedetto. ");
INSERT INTO gmvl_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Izi barkka yidaa gidikko barkka bo; ba machcheyra yidaa gidikko iza machcheyakka izara bu. ");
INSERT INTO gmvl_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Iza goday izas machcho ekkidaa gidikko machcheya izas adde nayta woykko macca nayta yelidaa gidikko, he maccassayanne izi nayti iza godaas attiko izi barkka kezi bo. ");
INSERT INTO gmvl_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Gido attiin he aylley, ‹Tani ta godaa, ta machchiyonne ta nayta siiqays; tani aylleteththafe kezikke› giikko, ");
INSERT INTO gmvl_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","iza goday iza pirdiza asa sinth aaththo; hessafe guye keeththa penge woykko penge qosilaththaako iza efidi iza hayth goonththan lukko. Histtiko izi ba de7o layth ubbaan izas aylle gidana. ");
INSERT INTO gmvl_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","«Asi ba macca nayo aylleteththas bayzikko adde aylleti aylleteththafe keziza mala iza kezuppu. ");
INSERT INTO gmvl_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Iza bana dooridi efida godaa ufayssontta ixxiko izi goday izo wozzisanaas koshshees. Izi izis ammanettontta aggida gishshas izo allagas bayzana bessenna. ");
INSERT INTO gmvl_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Izi izo ba naas ekkanaas koykko ba macca naas ooththiza mala izis bessizayssa ooththo. ");
INSERT INTO gmvl_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Izi baas hara machcho ekkiko koyro machcheys quma woykko may7o pacisoppo; qasse izira aqo aggofo. ");
INSERT INTO gmvl_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Izi hayta heedzdzata izis immontta ixxiko aykko miishsheyka qanxxettontta aylleteththafe kezada bu. ");
INSERT INTO gmvl_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«As wodhida asi hayqqanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Xoossa shene gidi uttiin qoppontta dishe as wodhidaadey tani giigsidaso bete bo. ");
INSERT INTO gmvl_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Gido attiin as wodhana qoppidi erishe hara as wodhikko hessaadey attanaas giidi he ta giigsida taas yarsho shiishshizaso yiikko yarshizasohozappe haraso efada wodha. ");
INSERT INTO gmvl_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","«Ba aawa woykko ba aayo wadhdhiza asi oonikka hayqqo. ");
INSERT INTO gmvl_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","«Asa wolqqan oykkidi bayzizaadey woykko wolqqan oykkiin asi iza kushen beettidaadey hayqqanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","«Ba aawa woykko ba aayo cayizaadey hayqqo. ");
INSERT INTO gmvl_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","«Nam7u asati ba garsan ooyettiko, issoy issaa shuchchara caddiko woykko kushera icciko he qohettidaadezi hayqqontta hargidi hiixan ichchiko, ");
INSERT INTO gmvl_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","hessafe dendidi guufera kare giddon hemettiko, he qohidayssi qaxxayettontta attees; gidikkoka izi iza ooso teqqida gishshas miishshe qanxxanaassinne izi paxana gakkanaas iza xeellanaas koshshees. ");
INSERT INTO gmvl_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","«Asi ba attuma aylle woykko macca aylleyo guufen shocikko he shochchaa geedon heerakka iza kushen hayqqiko shocidayssi qaxxayettanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Gido attiin he qohettidayssi issi gallas woykko nam7u gallas gakkanaas hayqqontta aggiko he ayllezi iza miish gidida gishshas izi qaxxayettenna. ");
INSERT INTO gmvl_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","«Nam7u asati ba garsan issoy issaara ooyettishe qanththara diza maccassayo boshas gaththiko, hessafe hara iita miish izi bolla gaththontta aggiko, izi bolla qoho gaththidaadey he maccassay azinay oychchidayssa daannati pirdiko ay miishsheka qanxxo. ");
INSERT INTO gmvl_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Gido attiin izis boshay darikko shemppo gishshas shemppo, ");
INSERT INTO gmvl_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ayfe gishshas ayfe, achcha gishshas achcha, kushe gishshas kushe, toho gishshas toho, ");
INSERT INTO gmvl_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","xuussa gishshas xuus, madunththa gishshas madunth, qoo7o gishshas qoo7o ekkanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","«Issi asi attuma woykko macca aylle ayfe shoci toyssiko he ayfeza gishshas aylleteththafe kessi yeddo. ");
INSERT INTO gmvl_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Hessaththoka ba aylley woykko ba aylleza ach menththiko he achchaa gishshas aylleteththafe kessi yeddo. ");
INSERT INTO gmvl_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","«Booray maccas woykko attumas icci wodhikko, he booray shuchchan cadetti hayqqo; iza ashoy meetettofo. Gido attiin boora goday qaxxayettofo. ");
INSERT INTO gmvl_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Gido attiin booray kasekka icciza boora gidikko, asay booraza godaas yootidishin booraa goday booraa qachchontta aggiko, booray adde woykko macca as wodhikko he booray shuchchan cadetti hayqqo; qasse booraza godaykka hayqqo. ");
INSERT INTO gmvl_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Gido attiin izi cigo qanxxana mala oyshettiko istti oychchidayssa ay gidikkoka qanxxidi ba shemppo wozzo. ");
INSERT INTO gmvl_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Booray attuma naa woykko macca naa icci wodhikko pirday issi mala gido. ");
INSERT INTO gmvl_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Booray attuma aylle woykko macca aylleyo icci wodhikko booraa goday aylleza godaas heedzdzu tammu bira ciggo; booraykka shuchchan cadettidi hayqqo. ");
INSERT INTO gmvl_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","«Issi asi olla kama qaarikko woykko olla bookkidi kammontta aggiko, booray woykko harey he ollaan wulliko, ");
INSERT INTO gmvl_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","he ollaza goday meheza waaga qanxxo. Izi meheza godaas waaga qanxxidi hayqeththaa baas ekko. ");
INSERT INTO gmvl_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","«Issi asa booray hara asa boora icci wodhikko, icci wodhida paxa booraa bayzidi iza miishshanne hayqqida booraza ashoza giddon gina shaakki ekketto. ");
INSERT INTO gmvl_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Gido attiin he booray icciza boora gididayssi kaseti erettishin, iza goday iza qachchontta aggiko, iza goday booraa gishshas boora qanxxidi he hayqqidayssa baas ekko. ");
INSERT INTO gmvl_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","«Issi asi boora woykko dorsa kaysoti ekkidi shukkiko, woykko bayzi ekkiko, issi boora gishshas ichchashu boora, issi dorsa gishshas oyddu dors qanxxo. ");
INSERT INTO gmvl_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","«Kaysoy keeth bookkishe oykettidi shocetti hayqqiko shocidayssi suuth gussida gishshas oychchettenna. ");
INSERT INTO gmvl_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Gido attiin hessi gadey wonti geyiin hanizaa gidikko izi he gukkida suuththaa acon oyshettees. Kaysozi kaysotidayssa qanxxo; gido attiin izas aykkoyka bayndaa gidikko kaysotidayssa qanxxanaas izi bayzetto. ");
INSERT INTO gmvl_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Izi kaysotida mehey paxa dishe iza kushen beettiko, boora woykko hare woykko dorsa gidikkoka izi ba kaysotidayssas nam7u kushe qanxxo. ");
INSERT INTO gmvl_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","«Issi asi ba mehe demban woykko ayfey meetettiza miththa giddon heemmishe, meheta hara asa kaththan la7a yeddi heemmiko, izi ba kaththaafe woykko ayfey meetettiza ba miththa ubbaafe lo7izayssa afilaama qanxxo. ");
INSERT INTO gmvl_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","«Issi asi buuraa xuuggiko tamay dendidi buuraza wursidi dooren diza kath woykko eqon diza kaththaa mulera mizaa gidikko koyro tama oyththida addezi afilaama qanxxo. ");
INSERT INTO gmvl_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","«Issi asi bira woykko hara miish naagissanaas ba shooros hadara immiko, shoorozasoppe he miishshaa kaysotida kaysozi oykettiko, kaysozi he miishshas nam7u kushe qanxxo. ");
INSERT INTO gmvl_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Gido attiin kaysozi beettontta ixxiko, hadara ekkida addezi pirdizaytakko shiiqidi hadara miishsha izi miishshaa monttayssas caaqqo. ");
INSERT INTO gmvl_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","«Asi ay mootonkka boora geedon, woykko hare geedon, woykko dorsa geedon, woykko may7o geedon, woykko hara dhayda miishsha geedon, ‹Hayssi tayssa› giidi mootettiko, nam7u baggayka ba yo7oza pirdizayta sinth aaththetto; pirdizayti wordosida asi hankkoyssas nam7u kushe qanxxo. ");
INSERT INTO gmvl_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","«Asi ba shooros hare, woykko boora, woykko dorsa, woykko hara ay mehekka hadara immiin oonikka be7ontta hayqqiko, woykko qohettiko, woykko asi bonqqi efikko, ");
INSERT INTO gmvl_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","hadaraaddey ba shooro meheza bochchonttayssas GODAA sinththan caaqqiko, istta giddon diza yo7ozi wurees. He meheza goday caaqoza ekko; qanxxisanaas bessenna. ");
INSERT INTO gmvl_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Gido attiin mehezi hadaraaddefe kaysotettidaa gidikko mehaaddes qanxxo. ");
INSERT INTO gmvl_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","He meheza do7ay midaa gidikko, markka gidana mala do7ay mishin attidayssafe ekki ehi besso; histtidi meetettida meheza gishshas qanxxofo. ");
INSERT INTO gmvl_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","«Asi ba shooroppe mehe garxxi ekkiko iza goday bayndason he mehey qohettiko woykko hayqqiko he meheza gishshas qanxxo. ");
INSERT INTO gmvl_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Gido attiin iza goday izara diikko, garxxidayssi qanxxofo; kiras ekkidaa gidikko kiras ciggiza miishshay acozas qanxxo gido. ");
INSERT INTO gmvl_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","«Issi asi azinas giigontta geela7oyo baleththidi izira zin7izaa gidikko izo cilooshidi baas machcho ekko. ");
INSERT INTO gmvl_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Izi aaway izo izas immontta ixxiko, geela7oyo ekkiza asi cilooshas imettiza miishshaa keena bira izi aawaas immo. ");
INSERT INTO gmvl_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","«Bita bitiza maccas paxa woththofa. ");
INSERT INTO gmvl_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","«Mehera gaaggiza asi oonikka hayqqo. ");
INSERT INTO gmvl_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","«GODAAS xalalappe attiin hara xoossas shukki yarshiza asi oonikka hayqqi dhayo. ");
INSERT INTO gmvl_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","«Betidi yida as qohopite, woykko waayisopite; gaasoykka intteka Gibxe biittan bete gididi de7ideta. ");
INSERT INTO gmvl_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Azinay hayqqida am7eyonne aaway woykko aaya hayqqida naa waayisopite. ");
INSERT INTO gmvl_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Intte istta waayisiin istti taakko waassiko tani istta waaso tumappe siyana; ");
INSERT INTO gmvl_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","he wode ta hanqoy intte bolla dendana; tani inttena mashshan wursana; intte machcheti am7eta intte naytikka aaway baynda yi7o nayta gidana. ");
INSERT INTO gmvl_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","«Intte giddon diza ta asaas issi manqo asas miishshe tal7iko, ba miish dichchas immiza asa mala hanopite; neni yelo iza oychchofa. ");
INSERT INTO gmvl_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Neni issi miishsha gishshas ne lagge may7o oykkiko arshey wullontta dishin izas zaara. ");
INSERT INTO gmvl_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Aazas giikko izi ba kallo kammizay izin xalla; hara ay may7idi aqanaas dandayzee? Izi taas waassiko ta mishettiza gishshas izas siyananne iza maaddana. ");
INSERT INTO gmvl_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","«Xoossa bolla cashsha qaala haasayoppa, woykko dere ayssizaade qanggofa. ");
INSERT INTO gmvl_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","«Ne kaththa xeera, woyne miththa ayfe xeeranne wogara zayte taas yarsho shiishsha. Neni ne attuma nayta giddon bayratiza naa taas immanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Boorappe, deyshafenne dorsafekka hessaththo ooththa. Istti laappun gallassay gakkanaas, ba aayira aayira gam7etto; osppunththa gallas istta taas imma. ");
INSERT INTO gmvl_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","«Intte taas geeshsha as gidanaas koshshees; hessa gishshas do7ay demban wodhida woykko dafi daakkida mehe asho kanas yeggite attiin moopite. ");
INSERT INTO gmvl_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«Wordo yo7o laallofa; wordo markkattada iita as maaddofa. ");
INSERT INTO gmvl_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","«Iita miish ooththanaas daro asa kaallofa; pirda mirqqanaas daro asaara gidada markkattofa. ");
INSERT INTO gmvl_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Manqo asi pirdaso shiiqikko iza manqoteth be7ada maadda pirdofa. ");
INSERT INTO gmvl_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","«Ne morkke booray woykko harey dhaydayssa demmiko izaades zaara imma. ");
INSERT INTO gmvl_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Nena ixxiza asas harey caanara kundi dishin be7ikko izara maadettada denththa attiin heen agaagoppa. ");
INSERT INTO gmvl_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","«Pirdas dubbushan shiiqada, manqo asa pirda wobbisoppa. ");
INSERT INTO gmvl_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Wordo mooto siyoppa; geesh woykko xillo as hayqos aaththa immofa; ays giikko mooro ooththidaade tani mela yeddike. ");
INSERT INTO gmvl_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","«Matta7e ekkofa; aazas giikko matta7ey xeellizayta ayfe qooqiseessinne xillota qaala mirqqees. ");
INSERT INTO gmvl_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","«Hara dereppe yida bete as qohoppite; bete as gideththi ay mala deexxizaakko intte ereeta; ays giikko intte intte hu7en bete gididi Gibxe biittan de7ideta. ");
INSERT INTO gmvl_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«Usuppun layth gakkanaas ne goyada zerida kaththa maxa shiishsha. ");
INSERT INTO gmvl_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Laappunththa layththan gadeza goyontta shaachcha; histtiko ne dere garsan diza manqoti hessafe maana kath demmana; qasse isttafe attizayssa do7ati maana. Neni ne woyne tokkiza gade bollanne zayte immiza wogara miththa gade bollaka hessaththo ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","«Usuppun gallas ne ooso ooththa; ne booraynne ne harey shempana malanne neson yelettida aylleynne bete asi, shempana mala, laappunththa gallas ooso ooththofa. ");
INSERT INTO gmvl_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","«Tani inttena gidayssa ubbaa minththidi ooththite; hara xoossata sunth xeygopitenne istta woossofte. ");
INSERT INTO gmvl_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«Layththan heedzdzuto intte taas ba7aale bonchchite. ");
INSERT INTO gmvl_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Abibe geetettiza aginan barettida gallassan ukeththa ba7aale bonchchite; ays giikko intte Gibxeppe keziday he aginanna. Tani inttena azazida mala laappun gallas irshoy gelontta uketh miite. «Inttefe issaadeyka ta sinththan mela kushe beettofo. ");
INSERT INTO gmvl_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","«Qasse intte intte gaden zeriin, koyro gakkida kath maxiza wode, kaththa xeera shiishshiza ba7aale bonchchite. «Qasseka layththaa wurseththan, kath ubbaa shiishshi wursiza wode, kaththa shiisho ba7aale bonchchite. ");
INSERT INTO gmvl_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Addeti wuri ubbaa Haariza GODAA ta sinth layththan heedzdzuto yetto. ");
INSERT INTO gmvl_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","«Neni yarsho suuth taas shiishshashe irshora uukettida ukeththara shiishshofa. He ba7aaleza bonchchiza gallas yarshettida moodheppe maalados aykkoyka attofo. ");
INSERT INTO gmvl_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ne gaden bayra kaxxida kaththa ubbaafe lo7izayssa GODAA ne Xoossaa soo ekka ya. Deyshsha laaqqa iza aayey maaththan doyssofa. ");
INSERT INTO gmvl_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«Ne ogen nena naagana malanne tani nees giigsidaso nena efana mala, tani kiitanchcha ne sinththara yeddana. ");
INSERT INTO gmvl_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Izi yootizayssa ero gaada izas azazetta; iza bolla makkallofa; ta iza kiittida gishshas intte nagara ooththiko inttes izi atto geenna. ");
INSERT INTO gmvl_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Izi yootizayssa intte lo7eththi siyikko, tani yootizayssa ubbaa ooththiko intte morkketa ubbaa tani morkkana; inttenara eqettizaytara tanikka eqettana. ");
INSERT INTO gmvl_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ta kiitanchchay inttefe sinththe biidi, inttena Amooreta biitta, Hiiteta biitta, Paarizeta biitta, Kanaaneta biitta, Hiiweta biittanne Yaabuseta biitta efana. Tani istta mulera dhayssana. ");
INSERT INTO gmvl_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Istta eeqata sinththan hokkofte, woykko goynnofte, woykko istta hano qullofte. Intte istta dhayssanaassinne tuussa mala eqqi diza istta shuchcha eeqata menththereththanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","GODAA intte Xoossaas goynnite; histtiko, izi inttena kaththaninne haaththan anjjana; ta intte giddofe harge diggana. ");
INSERT INTO gmvl_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Intte biittan ay maccasika boshettennanne maynenna. Tani intte daana layth adussana. ");
INSERT INTO gmvl_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","«Inttenara gaaggiza dereta ubbaa daganththana mala tani ta yashshateth intte sinththara yeddana; intte morkketi wuri inttes zokko zaaridi, baqatana mala ta ooththana. ");
INSERT INTO gmvl_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Tani inttefe sinththara kazhe yeddada Hiiweta, Kanaanetanne Hiiteta goodda kessana. ");
INSERT INTO gmvl_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Gido attiin biittay kallo attontta malanne do7ay darontta mala, ta istta issi layththa garsan gooddike. ");
INSERT INTO gmvl_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Gido attiin intte qoodan daridi, he biittaa laattana gakkanaas, tani istta guuth guuth goodda kessana. ");
INSERT INTO gmvl_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Tani intte zawaa Zo7o abbaafe Mediteraane abbaa gakkanaas, bazzofe Efiraaxise shaafaa gaththana. He biittan dizaaz ubbaa tani intte kushen aaththa immana; intteka istta intte sinththafe gooddi kessana. ");
INSERT INTO gmvl_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Isttara woykko istta eeqa xoossatara caaqon gelopite. ");
INSERT INTO gmvl_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Istta intte biittan woththofte; intte histtontta aggiko istti inttena ta bolla nagara oosisana; ays giikko istta eeqatas goynnizayssi tumappe inttes narxa gidana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","GODAY Muse, «Neni, Aarooney, Nadaabey, Abihuynne Isra7eeleppe laappun tammu dere halaqati GODAAKKO zuma bolla pude kezidi haahon eqqidi taas goynnite. ");
INSERT INTO gmvl_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Gido attiin neni nerkka taakko shiiqa; harati ta mata shiiqopetto. Qasse asaykka nenara pude kezoppo» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musey yiidi GODAA qaalanne iza woga ubbaa asaas yootiin asay wuri issi qaalan, «GODAY yootidayssa ubbaa nuni ooththana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Musey GODAY yootidayssa ubbaa xaafides. Wonteththa gallas maalado wonttara dendidi zumaa garsan yarshizaso giigsidi Isra7eele asaa tammanne nam7u qommota sunththan tammanne nam7u shuch tuussa mala essides. ");
INSERT INTO gmvl_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Izi Isra7eele asaappe naateththa attuma nayta kiittiin, istti biidi GODAAS mirgota xuugettiza yarshonne issifeteththa yarsho histti yarshida. ");
INSERT INTO gmvl_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musey suuththaafe baggaa ekkidi keretan qolides; attida suuththaa yarsho yarshiza sohozan cacafides. ");
INSERT INTO gmvl_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Hessafe guye Caaqo Qaala Maxaafaa ekkidi asaas dhoqqu histtidi nababiin asay, «GODAY yootidayssa ubbaa nuni ooththananne azazettana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Museykka keretan attida suuththaa ekkidi asaa bolla wuxxidi asaa, «Be7ite, hayssi GODAY hayta qaalata inttes immishe inttenara woththida caaqo suuththa» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Hessafe guye Musey, Aarooney, Nadaabey, Abihuynne Isra7eele halaqatappe laappun tammati pude kezidi, ");
INSERT INTO gmvl_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Isra7eele Xoossaa be7ida; istti be7oyssika iza tohoppe garsara salo mala geeyi uttida simpere geetettiza shuchchafe oosettida miish misatiza wuyge dizayssako. ");
INSERT INTO gmvl_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Gido attiin Xoossi Isra7eele asaa halaqata wodhibeenna; istti Xoossaa be7ida; iza sinththan midanne uyida. ");
INSERT INTO gmvl_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","GODAY Muses, «Neni taakko zumaa bolla pude haa ya; haa taakko kezada haan gam7a; histtiko neni wogaa tamaarsana mala tani wogaanne azazo iza bolla xaafida lochcha shuchchata nees immana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Hessafe guye Musey ba aylle Iyaasora baana keziin Musey pude Xoossa zumaa bolla kezides. ");
INSERT INTO gmvl_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Isra7eele asaa halaqata izi, «Nuni intteko simmanaashe gakkanaas hayssan diishshite; Aarooneynne Huurey haan inttenara deettes; yo7oy diza asi oonikka isttako bo» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Musey zumaa bolla pude keziin Xoossa shaaray zumaa kammides. ");
INSERT INTO gmvl_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","GODAA bonchchoyka Siina zumaa bolla wodhdhi gam7ides; usuppun gallas gakkanaas shaarazi zumaa goozi oykkides; laappunththa gallassan shaaraa giddora GODAY Muse xeygides. ");
INSERT INTO gmvl_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Isra7eele naytas GODAA bonchchoy zumaa xeeran eexxiza tama misatidi beettides. ");
INSERT INTO gmvl_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Hessafe guye Musey he shaaraa giddo gelidi pude zumaa bolla kezidi heen oyddu tammu gallassinne oyddu tammu qamma gam7ides. ");
INSERT INTO gmvl_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«Taas imota ehana mala neni Isra7eele naytas yoota; taas immanaas iza wozinay iza imma imma giin immiza asa imota ubbaa ne taas ekka. ");
INSERT INTO gmvl_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Intte isttafe ekkana imotay haytantta; worqqa, bira, xarqimala, ");
INSERT INTO gmvl_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","salo misatiza qacina, ochcha teera misatiza qacina, xeeqa zo7o qacinanne booththa liiqo layno, deysha iske, ");
INSERT INTO gmvl_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","dharsho ite zo7o qalamen yeggi kessidayssa, abbaa giddon diza issi do7a galba, odoro mith, ");
INSERT INTO gmvl_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","xomppes wogara zayte, tiyettiza zaytessinne exaanes sawissiza qimame, ");
INSERT INTO gmvl_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","eefudeninne tira bollan diza kiiseta giddon woththiza margide geetettiza shuchchatanne hara al7o shuchchata. ");
INSERT INTO gmvl_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","«Histtidi tani istta giddon aqana mala istti taas dumma goynniza soo giigsetto. ");
INSERT INTO gmvl_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Xoossa Dunkaanezanne iza giddon diza miishshata tani nena bessiza leemisoza mala ooththite. ");
INSERT INTO gmvl_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«Istti odoro miththafe adussateththay nam7u wadhanne bagga, gomppay issi wadhanne bagga, dhoqqateththay qasse issi wadhanne bagga gidiza Taabota ooththetto. ");
INSERT INTO gmvl_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Soo baggaanne kare baggaa walakay baynda worqqan meesha; iza yuuyi aadhdhanaas bolla bagga xanxaa worqqara yuushsha aaththa ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Taabotaas oyddu worqqa sagayota ooththada oyddu tohotan issi baggara nam7u sagayota, qasse hankko baggara nam7u sagayota aaththa. ");
INSERT INTO gmvl_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Hessafe guye odoro miththafe tooho miththata kessada worqqa tiya. ");
INSERT INTO gmvl_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Taabotaa tookkana mala Taabotaza millen diza sagayotan tooho miththata gelththa. ");
INSERT INTO gmvl_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Tooho miththati Taabotaa sagayota giddon detto; istti heeppe mulekka kezopetto. ");
INSERT INTO gmvl_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Tani nees immiza caaqo qaala markka taabotaa giddon woththa. ");
INSERT INTO gmvl_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","«Harara walakettontta worqqafe xalala nam7u wadhanne bagga aduqqiza, issi wadhanne bagga aakkiza maaroteththa kama ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Kamaza xeera nam7u baggara qoxxada nam7u kirubeta worqqafe ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Issi kirubeza issi bagga gaxan, nam7anththo kirubeza hankko bagga gaxan nam7atakka maaroteththaa kamazara gaththa ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kirubeti ba qefe denththidi maaroteththa kamaa bollara kammetto; qasse issoy issaakko simmi uttidi kamazakko xeelletto. ");
INSERT INTO gmvl_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Tani nees immiza caaqo qaala markka Taabotaa giddon woththa; qasse kamaza Taabotaas bolla baggara woththa. ");
INSERT INTO gmvl_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Caaqo qaala markkay izan diza Taabotaa kamaa bolla diza nam7u kirubetappe giddon tani nenara gaaggada Isra7eele asaas immiza azazo ubbaa heen ta nees immana. ");
INSERT INTO gmvl_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«Odoro miththafe adussateththay nam7u wadha, gomppay issi wadha, dhoqqateththay qasse issi wadhanne bagga gidiza issi xaraphpheeza ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Histtada walakay baynda worqqan tiya; qasse iza yuushon worqqa xanxa yuushsha aaththa. ");
INSERT INTO gmvl_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Hessaththoka qasse aahoteththi tadhdhako gidiza xanxa iza bolla yuushsha aaththa. Histtada iza bolla worqqa balxxanth yuushsha aaththa. ");
INSERT INTO gmvl_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Xaraphpheezazas oyddu worqqa sagayota medhdhada, xaraphpheeza tohoti diza oyddu baggara oyththa. ");
INSERT INTO gmvl_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Xaraphpheeza tookkanaas tooho mith iza giddora aaththiza sagayoti xaraphpheezazas xanxa matan detto. ");
INSERT INTO gmvl_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","He tookkiza miththata odoro miththafe kessada, worqqa tiyada isttara xaraphpheezaza tookka. ");
INSERT INTO gmvl_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Hessaththoka qasse saanetanne pil7ota, duuqqana xaarotanne kereta walakay baynda worqqafe ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ta sinth aadhdhiza geeshsha ukeththay ubba wodekka xaraphpheeza bollafe dhayoppo. ");
INSERT INTO gmvl_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«Worqqafe xalla qoxxada xomppe istta bolla woththiza ballata kessa; qasseka iza qoxxada xomppezi izan eqqiza toho, giddo toomanne toomaza kureta, dhemotanne ciishshata ubbaa ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Issi millera heedzdzu ballati, issi millera qasseka heedzdzu ballati issi bolla usuppun haggati izas detto. ");
INSERT INTO gmvl_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Usuppun ballataska issaas issaas dhemoynne ciishshay izan diza ochcholoone geetettiza miththa ciish misatiza heedzdzu kureti detto. ");
INSERT INTO gmvl_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Xomppeza giddo toomay, dhemotinne ciishshati izan diza ochcholoone geetettiza miththa ciish misatiza oyddu kureti detto. ");
INSERT INTO gmvl_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Nam7ay nam7ay issife waaththan diza heedzdzu ballatappe garsara issi issi dhemoy de7o. ");
INSERT INTO gmvl_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Dhemotinne ballati wuri giddo toomazappe qoxettidi walakay baynda worqqafe oosettetto. ");
INSERT INTO gmvl_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","«Hessafe guye Xomppe woththizasozas laappun eexxizaso giigsada xomppeti sinththa bagga poo7ana mala oyththa. ");
INSERT INTO gmvl_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Xomppeza bolla eexxishe qaammida shalota kessiza qaphetanne xiixa woththiza saaneta walakay baynda worqqafe ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Xomppezinne iza miishshati wuri heedzdzu tammanne ichchashu kilo giraame gidiza walakay baynda worqqafe oosettetto. ");
INSERT INTO gmvl_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Tani nena zumaa bolla bessida leemisoza kaallada akeekan ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«Qasse lo7eththi suqettida booththa laynoppe dadettida tammu magalashata dunkaaneza giddon giigsa. Qasseka salo misatiza, ochcha teera misatizanne xeeqa zo7o qacinara he magalashata bolla issi hiillan kirubeta misle oosisa. ");
INSERT INTO gmvl_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Magalashati wuri issi gina gidetto; issaa issaa adussateththay nam7u tammanne osppun wadha; gomppay qasse oyddu wadha gido. ");
INSERT INTO gmvl_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Ichchashu magalashata issife gaththa sikka; hankko attida ichchashu magalashatakka isttaththoka ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Issife gaaggi sikettida magalashatappe gaxan diza magalashaas balxxanththa bolla salo misatiza carqqafe siidhe ooththa; qasse issife gaaggidi sikettida hankko magalashaankka hessaththo ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Issife gaaggida issi magalashaa bolla ichchashu tammu siidhe misatiza miish, qasse issife gaaggida hankko magalashaa bollaka ichchash tammu siidhe misatiza miish ooththa; he siidhe misatiza miishshati wurikka he baggaranne ha baggara issay issaara ginan detto. ");
INSERT INTO gmvl_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Hessafe guye worqqafe ichchash tammu qapheta medhdhada giddo dunkaanezi issino gidana mala, he magalashata manxakotan issaa issaara oyseththa. ");
INSERT INTO gmvl_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«Giddo Dunkaaneza bollara hara dunkaane ooththanaas tammanne issi magalashata deysha iskefe dadda. ");
INSERT INTO gmvl_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Tammanne issi magalashatikka issi gina gidetto; issi issi magalasha adussateththay heedzdzu tammu wadha, gomppay qasse oyddu wadha gido. ");
INSERT INTO gmvl_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ichchashu magalashata issi baggara usuppun magalashata qasse hankko baggaara gaththa sikka. Usuppunththa magalashay sinththara soo bagga simmi qalam7etto. ");
INSERT INTO gmvl_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Gaththi sikkida magalashatappe issi magalashaa gaxan ichchash tammu siidhe misatiza miishshata ooththa; qasse gaththi sikkida hankko magalashatappe wurseththa magalashaa balxxanththa bolla ichchash tammu siidhe misatiza miishshata ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Xarqimalappe ichchashu tammu qapheta ooththada, qanggo misatiza miishshata giddo gelththa; histtada bolla dunkaaneza issife gaththa oyththa. Histtiko ha nam7u oykettida kamati issino gidana. ");
INSERT INTO gmvl_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Bolla dunkaaneza magalashatappe palahida bagga magalashay giddo dunkaanezas guyera alaletto. ");
INSERT INTO gmvl_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Bolla Dunkaaneza magalashati nam7u baggarakka issi issi wadha mala palahidi heera haara alalettidi giddo dunkaaneza kammana mala nam7u bagga millera alaletto. ");
INSERT INTO gmvl_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","«Bolla bagga dunkaaneza bollara kammanaas zo7o qalamen geli kezida dharsho ite giigsa; qasse iza bollara kammanaas haaththa giddo do7a galbafe hara kama giigsa. ");
INSERT INTO gmvl_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«Giddo Dunkaaneza tole miththata odoro miththafe ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Issi issi tole miththas adussateththay tammu wadha, gomppay issi wadhanne bagga gido. ");
INSERT INTO gmvl_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Issi tole miththas issi bolla oyketti uttida nam7u tohota ooththa. Giddo Dunkaaneza tole miththata ubbaaka hessaththo ooththa; ");
INSERT INTO gmvl_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Giddo Dunkaanezas duge baggara nam7u tammu tole miththata kessada, ");
INSERT INTO gmvl_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","issi issi tole miththas nam7u eqoso, mulera oyddu tammu eqoso birappe giigsa. ");
INSERT INTO gmvl_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Giddo Dunkaanezas pudeha baggara, nam7u tammu tole miththata kessada, ");
INSERT INTO gmvl_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","issi issi tole miththas nam7u eqoso, mulera oyddu tammu eqoso birappe giigsa. ");
INSERT INTO gmvl_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Qasse giddo Dunkaanezas guyera arshey wulliza baggara usuppun tole miththata kessada, ");
INSERT INTO gmvl_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","guye baggara diza zoozetas nam7u tole miththata giigsa. ");
INSERT INTO gmvl_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Guye baggara diza tole miththati wuri xaphoppe xeeraa gakkanaas issi bolla gaaggi oykettidi, xeeran issoy issaara sagayon oyketetto; hessaththoka nam7u zoozeta bolla diza nam7u tole miththatikka hara tole miththatara oyketetto. ");
INSERT INTO gmvl_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Issi issi tole miththas garsara nam7u nam7u tole eqosoy de7o; mulera osppun tole miththatinne birappe oosettida tammanne usuppun eqosoy deyo. ");
INSERT INTO gmvl_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«Qasse meega miththata odoro miththafe kessa. Giddo Dunkaanezas issi bagga millen diza tole miththatas ichchashu meega miththata, ");
INSERT INTO gmvl_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","qasse hankko bagga millen diza tole miththatas ha7ikka ichchashu meega miththata giigsa. Hessaththoka giddo Dunkaanezas guyera arshey wulliza baggara diza tole miththatas ichchashu meega miththata giigsa. ");
INSERT INTO gmvl_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Giddo meega miththati tole miththatas giddora ha gaxappe he gaxa gakkanaas kanththi kezanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","«Tole miththata worqqan tiyada meega miththati istta giddora aadhdhiza sagayota worqqafe ooththa; qasse meega miththatakka worqqan tiya. ");
INSERT INTO gmvl_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Giddo dunkaaneza tani nena zumaa bollan bessida leemisoza mala tokka. ");
INSERT INTO gmvl_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«Salo misatizappe, ochcha teera misatiza qacinappenne xeeqa zo7o qacinappenne lo7i suqettida liiqo laynoppe issi magalasha ooththa; he magalashaza bolla kirubeta misle sikki medhdhiza hiillan oosisa. ");
INSERT INTO gmvl_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Histtada odoro miththafe oosettidi worqqan tiyettida oyddu eqo miththata bolla diza worqqafe oosettida kaqotan kaqqa. He oyddu eqo miththati birappe oosettida eqosotan geletto. ");
INSERT INTO gmvl_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","He magalashaza giddo dunkaaneza kaaran diza qaphetappe garsara kaqqada, Caaqo qaalaas markka gidida taabotaa magalashazappe gaaththa baggara woththa; histtiko he magalashazi geesh geetettiza sohoza ubbaafe dummatiza qol7aafe giddon shaakkana. ");
INSERT INTO gmvl_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Maaroteththa kama ubbaafe dummatida qol7an diza caaqo qaalaas markka gidida taabotaa bolla woththa. ");
INSERT INTO gmvl_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Xaraphpheezaza magalashaappe karera pude baggara woththa; xomppe woththiza ballaa qasse iza ginan duge baggara woththa. ");
INSERT INTO gmvl_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","«Dunkaanezan geliza pengezas salo misatiza qacinappe, ochcha teera misatiza qacinappe, xeeqa zo7o qacinappenne lo7i suqettida liiqo laynoppe xilpen alleqissi oosettida magalasha giigsa. ");
INSERT INTO gmvl_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Magalashazas ichchashu eqo miththata odoro miththafe kessada, worqqan tiya; istta kaqotikka worqqafe oosettidaa gidetto; eqo miththatas xarqimalappe oosettida ichchashu eqoso giigsa. ");
INSERT INTO gmvl_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«Odoro miththafe yarshizaso ooththa. He yarshizasoza dhoqqateththay heedzdzu wadha; gomppaynne adussateththay issi mala, ichchashu ichchashu wadha gididi oyddu zoozera deyo. ");
INSERT INTO gmvl_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Oyddu zoozeta wurseththa gaxan gaxan issi issi kace medhdha; kaceti yarshosozappe oosettetto. Histtada yarshizasoza xarqimala tiya. ");
INSERT INTO gmvl_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Izan go7ettiza miishshata, Bidinth kaashiza miishshata, kaashettida bidinththaa kessiza miishshata, kereta, asho xiixiza konccetanne tama kaachizanne kessiza miishshata ubbaa xarqimalappe ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Histtada izas xarqimalappe zayzare mala miishshinne oyddu gulata bollan oyddu sagayota ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Histtada yarshizasozas dabba bolla woththa. ");
INSERT INTO gmvl_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Odoro miththafe yarshizasozas tooho miththata kessada xarqimala tiya. ");
INSERT INTO gmvl_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Yarshizasoza tookkiza wode maaddana mala he tooho miththatas nam7u millera diza sagayotan aaththa. ");
INSERT INTO gmvl_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Tani nena zumaa bollan bessida mala yarshizasoza sanqqafe ooththada giddoza doya agga. ");
INSERT INTO gmvl_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«Xoossa Dunkaaneza gibbe lo7i dadettida liiqo laynoppe magalashata giigsa. Duge baggara diza magalashata adussateththay xeetu wadha gido. ");
INSERT INTO gmvl_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Izas nam7u tammu eqo miththatinne eqo miththati isttan eqqiza nam7u tammu eqosota xarqimalappe ooththa; istta hu7en qasse kaqotanne tore miththata hu7e bolla gita sagayota birappe ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Hessaththoka pude bagga adussateththay xeetu wadha; qasse nam7u tammu tore miththatinne eqo miththatas nam7u tammu xarqimalappe oosettida eqosoti detto. Histtada birappe oosettida kaqotanne eqo miththatas hu7e bolla gita sagayota woththa. ");
INSERT INTO gmvl_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Arshey wulliza baggara aakoteththay ichchashu tammu wadha gido; tammu tore miththatinne tore miththatas tammu eqosoti diza magalashati izas detto. ");
INSERT INTO gmvl_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Qasse arshey mokkiza baggara aakoteththay ichchashu tammu wadha gididi, ");
INSERT INTO gmvl_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","pengezappe issi baggara tammanne ichchashu wadha aduqqiza magalashati detto; isttas heedzdzu eqo miththatinne isttan eqqiza heedzdzu eqosoti detto. ");
INSERT INTO gmvl_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Hessaththoka hankko baggara tammanne ichchashu wadha aduqqiza magalashati detto; isttas heedzdzu eqo miththatinne isttan eqqiza heedzdzu eqosoti detto. ");
INSERT INTO gmvl_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","«Pengezas nam7u tammu wadha aduqqiza magalasha salo misatiza, ochcha teera misatizanne xeeqa zo7o qacinappenne lo7i suqettida laynoppe dadettida, xilpen lo7ida magalasha giigsa. Iza tuuqi oykkanaas oyddu eqo miththatinne tore miththati isttan eqqiza oyddu eqosota giigsa. ");
INSERT INTO gmvl_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","«Gibbeza yuuyi aadhdhanaas diza eqo miththata ubbaas birappe oosettida gita sagayoti, kaqotinne, xarqimalappe oosettida eqosoti detto. ");
INSERT INTO gmvl_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Gibbeza adussateththay xeetu wadha, aakoteththay ichchash tammu wadha gido; dhoqqateththay ichchashu wadha gidida lo7i suqetti dadettida laynoppe oosettida magalashati detto; qasseka xarqimalappe oosettida eqosoti detto. ");
INSERT INTO gmvl_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","«Xoossa Dunkaaneza oosos go7ettiza miishshati, Dunkaanezanne gibbeza tole dhishketi wurikka xarqimalappe oosettetto. ");
INSERT INTO gmvl_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«Xomppey to7ontta eexxishe daana mala izas koshshiza zayte wogara miththa ayfe caddi gum7idi xillo zayte nees ehana mala Isra7eele nayta azaza. ");
INSERT INTO gmvl_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aarooneynne iza attuma nayti xomppey GODAA sinththan qammida gadey wonttana gakkanaas poo7ana mala, Xoossa Dunkaaneza giddon, caaqo qaalaas markkay iza giddon diza taabotaa sinththan diza magalashaappe karera eeththetto. Hayssi Isra7eele asaas mernaas woga gidi de7o. ");
INSERT INTO gmvl_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«Ne isha Aaroonenne iza attuma nayta Nadaabe, Abihu, El7ezeerenne Itamaare neekko ekka ya; istti qeese gididi taas ooththana mala Isra7eele asaa giddofe istta dummasa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Izas bonchchonne lo7oteth immana mala ne isha Aaroones dumma may7o giigsa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Tani dumma dumma erateth immida kushe hiilla eriza as ubbaa xeygada Aaroones may7o giigsana mala yoota; izikka qeese gididi taas ooththanaas dummato. ");
INSERT INTO gmvl_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Istti giigsana may7otikka haytanttako; tira kiise, eefude, eefudeppe garsara may7iza hara may7o, qasseka ubbaafe garsara may7iza adussa may7o, goossenne dancco. Ne ishay Aarooneynne iza attuma nayti qeese gididi taas ooththishe dumma may7ota may7ana mala, may7o giigsetto. ");
INSERT INTO gmvl_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Kushe hiillateth erizaytikka he may7ota giigsanaas, worqqa, salo misatiza, ochcha teera misatizanne xeeqa zo7o qacinanne liiqo layno ekki ooththetto. ");
INSERT INTO gmvl_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«Eefude geetettiza may7o worqqafe, salo misatiza, ochcha teera misatizaa, xeeqa zo7o qacinappenne lo7i suqettida liiqo laynoppe kushe hiillati alleqissi giigsetto. ");
INSERT INTO gmvl_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Izas hashera duge wodhdhiza nam7u kaqoti detto; isttika biidi eefude may7ozara issife hara oyththiza miishshara dabba bolla oykettidi issino gidetto. ");
INSERT INTO gmvl_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Hiillay lo7eththidi daddida danccoyka eefudeza mala worqqafe, salo misatiza ochcha teera misatizaa, xeeqa zo7o qacinappenne lo7i baqettida laynoppe eefudezara issife oyketti dadetto. ");
INSERT INTO gmvl_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","«Margide geetettiza nam7u shuchchata ekkada Isra7eele nayta sunth istta bolla wooca xaafa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Istta yeleta maaraa mala issi shuchchaa bolla usuppun sunth, hankko shuchchaa bolla qasse attida usuppunata sunth wooca xaafa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Hiillanchchay maatame bolla sunth wooci xaafiza mala, he nam7u shuchchata bolla Isra7eele nayta sunththu wooca xaafada yuuyi aadhdhanaas worqqafe giigettida miishsha giddon woththa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Histtada tammanne nam7u Isra7eele zereththata qofsizaaz gidana mala ha nam7u shuchchata eefudezara oyththada hashe bolla woththa; histtiko GODAA sinththan ubba wode qofettana mala ha sunththata Aarooney ba hashe bolla tookko. ");
INSERT INTO gmvl_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Shuchchata woththanaas worqqafe dooqetti giigida macarata ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Qasse walakay baynda worqqafe wodoro mala dooqettida nam7u orde sansalatata giigsada, shuchchata woththanaas worqqafe dooqetti giigettida macaratara gaththa oyeseththa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«GODAA sheney aazakkonne iza oychchidi eriza tira kiise kushe hiillanchchan oosisa. He tira kiise eefude daddida mala, worqqafe, salo misatiza, ochcha teera misatizanne xeeqa zo7o qacinappenne lo7i suqettida laynoppe dadda. ");
INSERT INTO gmvl_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Izas adussateththaynne aahoteththay dakkoti qalam7ettidi issi tadhdhako gido. ");
INSERT INTO gmvl_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Hessafe guye iza bolla oyddu maaran al7o shuchchata woththa; koyro maaran sardiyoone, tophaaziyoonenne phoolliza inqqu. ");
INSERT INTO gmvl_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Nam7anththo maaran baluure, simperenne almaaze geetettiza al7o shuchchata; ");
INSERT INTO gmvl_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","heedzdzanththo maaran yaakintte, kelqedoonenne ametesxinoose; ");
INSERT INTO gmvl_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","oydanththo maaran birille, margide, yasphiide. Haytanti wuri shuchchata woththanaas worqqafe dooqetti giigida macarata bolla uttetto. ");
INSERT INTO gmvl_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Isra7eele qommota sunththaa qooda mala, shuchchata qoodaykka tammanne nam7u gido; issaa issaa bolla maatame mala woocettidi tammanne nam7u zereththata sunththi he shuchchatan xaafetto. ");
INSERT INTO gmvl_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","«Tira kiises walakay baynda worqqafe wodoro mala dooqettida orde sansalatata ooththa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Nam7u yiich worqqafe giigsada tira kiises qommo gaxa xeerara gaththada oyththa woththa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","He nam7u worqqa sansalatata tira kiisetas xeeratan diza sagayotara gaththa oyththa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","He sansalatatas hankko bagga xeeraa qasse eefudezas sinththa baggara, hashe bolla diza shuchchata woththanaas worqqafe dooqetti giigida macaratara gaththa oyseththa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Qasseka nam7u worqqa yiichchata giigsada, eefudeppe kaalli diza tira kiisetas gaaththa baggara diza nam7u xeeratan aaththa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Hessaththoka worqqafe hara nam7u yiichchata giigsada eefudezas sinththa baggara, hashe bolla diza kaqozappe garsa baggara, eefude danccizasoppe qommora sikoy gaaggizaso achchan istta oyththa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Tira kiisen diza sagayota eefudezan diza sagayotara gaththidi salo misatiza suqeththan danccozara gaththa qachcha; histtiko tira kiisezi xeessafe bollara diza gishshas qashoy leppenna. ");
INSERT INTO gmvl_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","«Aarooney ubbaafe dumma qol7aa geliza wode he tira kiisen diza Isra7eele qommota sunththata tookko. Histtiko hayssi GODAA sinththan ubba wode hassa7ettana. ");
INSERT INTO gmvl_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Qasse Urimenne Tumime geetettizayta tira kiisetan yegga. Aarooney GODAA sinth aadhdhishe ba tiran woththi ekki gelo. GODAA sheney aazakkonne Isra7eele asaa erisana mala, izi GODAA sinththan ooththanaas geliza ubba wode tira kiiseppe dhayssofo. ");
INSERT INTO gmvl_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«Eefudezappe bollara may7ettiza adussa may7o salo misatiza carqqafe xalla giigsa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","He adussa may7ozas hu7ey gelizaso giigsa. Hu7ey kezizasozi daakettontta mala soo bagga qalam7ada yuushsha aaththa sikka. ");
INSERT INTO gmvl_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Adussa may7ozas garsa bagga maccaraa yuushon salo misatiza, ochcha teera misatizanne xeeqa zo7o qacinappe, oroomaane geetettiza miththa ayfe misleta medhdha. Histtada istta giddon worqqafe oosettida daalata walakan woththa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Worqqa daalatinne oroomaane miththa ayfe misleti he adussa may7o garsa bagga xeeran yuuyi aadhdhanaas walakan detto. ");
INSERT INTO gmvl_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aarooney qeeseteththan ooththiza wode ha adussa may7oza may7o; GODAA sinth ubbaafe dumma qol7a geliza wodenne keziza wode daalay giirana. Izi he may7oza may7iko hayqqenna. ");
INSERT INTO gmvl_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Walakay baynda worqqafe issi alleqo giigsada maatame wooci kessiza mala iza bolla woocada, ‹GODAAS geesh gidi dummatides› gaada xaafa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Histtada hu7en goossa bolla salo misatiza qacinan goossazas sinththa baggara oyththa kaqqa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Histtidi Aarooney iza ba liiphen woththo; heen Isra7eele asay GODAAS imota immishe moorida miishshi diikkoka he mooroza Aarooney tookko. Asay ehizayssa GODAY ekkana mala izi he xaafettidayssa ubba wodekka ba liiphen woththanaas koshshees. ");
INSERT INTO gmvl_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","«Aaroone shamize lee7e laynoppe dadda; hu7en xaaxiza goossaka laynoppe giigsa. Qasse danccozakka xilpen alleqissada sikissa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Aaroone naytas bonchchonne alleqo gidana mala, shamizeta, danccotanne hu7en xaaxiza goossata giigsa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Neni ha may7ota ne isha Aaroonenne iza nayta mayzidaappe guye, istti qeeseteththan taas ooththana mala istta wogara zayte tiya; tiyada istti qeese gididi taas ooththana mala istta dummasa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Istta kalloy kamettana mala garsara gixxiza gith, xeessaafe biidi wodira gakkanaas kammizaaz, liiqo layno qacinappe giigsa. ");
INSERT INTO gmvl_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aarooneynne iza nayti Xoossa Dunkaane giddo geliza wode woykko gibbe giddon qeeseteththan ooththanaas yarsho yarshizaso shiiqiza wode hayta may7ota may7etto. Hessaththo hankko istti bantta bolla qohonne hayqo ehettenna. Hayssi Aaroonessinne iza zereththatas mernaas woga gido. ");
INSERT INTO gmvl_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«Aarooneynne iza nayti qeese gididi taas ooththana mala neni istta dummasanaas ooththa; wosoy baynda issi mirgonne nam7u dharshota ekka. ");
INSERT INTO gmvl_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Lo7o gistte dhiille ekkada irsho yeggontta uketh uukka; qasseka irsho yeggontta zayten guuththa uketh uukka; hessaththoka irsho yeggontta qeeri uketh uukkada zayte tiya. ");
INSERT INTO gmvl_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Neni heyta leematen woththada, mirgoza nam7u dharshotara issife taas shiishsha. ");
INSERT INTO gmvl_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","«Histtada Aaroonenne iza nayta Xoossa Dunkaaneza penge ehada haaththan meecca. ");
INSERT INTO gmvl_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Hessafe guye may7ota ekkada, shamize, eefudeppe bollara may7iza adussa may7o, eefudenne tira kiise Aaroone mayzada eefudeza hiillan dadettida danccon danccisa. ");
INSERT INTO gmvl_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Goossaza iza hu7en goozisada, ‹GODAAS geesh gidi dummatides› geetetti xaafettida alleqoza goossa bolla woththa. ");
INSERT INTO gmvl_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Tiyiza zaytekka ekkada iza hu7en tigada tiya. ");
INSERT INTO gmvl_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Iza naytakka ehada shamizeta mayza. ");
INSERT INTO gmvl_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Goossaka istta hu7en goozisa. Hessafe guye Aaroonenne iza nayta dancco danccisa. Qeeseteththay isttas mernaa ooso woga gido; hessaththo histtada Aaroonenne iza nayta qeese histta. ");
INSERT INTO gmvl_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","«Ne taas mirgo Xoossa Dunkaane sinth ehikko Aarooneynne iza nayti iza hu7e bolla ba kushe woththiko, ");
INSERT INTO gmvl_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","wofanoza heen GODAA sinththan shukka. ");
INSERT INTO gmvl_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Wofanoza suuththan ne biradhdhe gelththa kessada, yarshizasoza bollan diza kaceta tiya; tiyishin attida suuththaa yarshizasozappe garsa baggara gussa. ");
INSERT INTO gmvl_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Hessafe guye marace kammida moodhe, tirezara oyketti diza asho, nam7u kilahotanne istta kammida handaa ekkada, yarshizasohoza bolla woththada xuugga. ");
INSERT INTO gmvl_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Gido attiin mirgoza asho, galbaanne maraceza, meetettontta ashota asi dizasohoppe haraso efada nagara yarsho gidana mala xuugga; ");
INSERT INTO gmvl_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«Nam7u dharshotappe issaa ne ekkiko Aarooneynne iza nayti ba kushe iza hu7e bolla woththetto. ");
INSERT INTO gmvl_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Shukkada suuththaa yarshizasoza mille bolla ubba baggara wuxxa. ");
INSERT INTO gmvl_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Dharshoza asho qanxxereththada, qanththa ashonne tohota meeccada hu7ezaranne hankko attida ashaara issi bolla woththa. ");
INSERT INTO gmvl_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Hessafe guye dharshoza mulera yarshizasohoza bolla xuugga; hessi GODAAS taman xuugettiza sawo tunnu giza yarshoko. ");
INSERT INTO gmvl_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«Qasse hankko dharshoza ne ekkiko Aarooneynne iza nayti ba kushe iza hu7e bolla woththetto. ");
INSERT INTO gmvl_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","He dharshoza shukkada iza suuththaafe guuththara ekkada, Aaroonessinne iza naytas ushachcha hayththata xeera, ushachcha kushe manththa biradhdhetanne ushachcha toho manththa biradhdheta tiya; hessafe guye attida suuththaa yarshizaso mille bolla Ubbasora wuxxa. ");
INSERT INTO gmvl_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Yarshizason diza suuththaafenne tiyettiza zaytezappe ginara ekkada, Aaroone bollanne iza may7o bolla, iza nayta bollanne istta may7o bolla wuxxa; histtiko izi iza naytinne, istta may7oy GODAA oosos dummatana. ");
INSERT INTO gmvl_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","«Ha dharshozappe goynazanne izan diza tolthoza, marace bollan diza moodhe, tirezara oyketti diza asho, nam7u kilahota, istta kammi oykkida handaaranne ushachcha gedaara neni ekka; hayssi qeeseteththa sunth immiza wode shukettiza dorsa. ");
INSERT INTO gmvl_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","GODAA sinththan woththida irshoy gelontta ukeththaafe issino, zaytey walakettontta ukeththaafe issino, zaytera uukkida issi komponne issi qeeri kompa ekka. ");
INSERT INTO gmvl_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Neni ha kaththaa ubbaa Aaroone kusheninne iza nayta kushen woththiko istti yaanne haa qaaseththiza yarsho histtidi GODAA sinththan shiishshetto. ");
INSERT INTO gmvl_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Hessafe guye neni istta kusheppe heyta ekkada, yarshizasoza bolla woththada, xuugettiza yarshora issife gaththada, GODAAS sawo tunnu gaana mala, yarshizasoza bolla taman xuugga. ");
INSERT INTO gmvl_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Aarooney qeese gididi summiza wode shukkida dharshoza angaso ekkada GODAA sinththan yaanne haa qaaseththiza yarsho histta qaaseththa; hayssi inttena gakkiza gisha gidana. ");
INSERT INTO gmvl_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","«He shukettida dharshoza ashoppe yarsho ooththidi yaanne haa qaaseththida angasozanne GODAA sinth shiiqida gedaa dummasa. Hessika Aaroone gishanne iza nayta gisha gidana. ");
INSERT INTO gmvl_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Isra7eele asay GODAAS shiishshiza issifeteththa yarshozappe angasozanne gedaza ubba wodekka Aaroonessinne iza attuma nayta gakkiza gisha gido. Ays giikko hayssi Isra7eele asay GODAAS shiishshiza imota. ");
INSERT INTO gmvl_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«Aaroone qeeseteththaa dumma may7oy izappe guye iza zereththaas gido; istti tiyettidi qeese gidiza wode he may7oza may7etto. ");
INSERT INTO gmvl_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Iza naytappe izasohon qeese gididi dummatida sohozan ooththanaas Xoossa dunkaane yida attuma nay he may7oza laappun gallas gakkanaas may7o. ");
INSERT INTO gmvl_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«Aarooneynne iza nayti qeeseteththan sunththanaas shukettida dharshaa asho ekkada dumma sohozan doyssa. ");
INSERT INTO gmvl_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aarooneynne iza nayti dharshoza ashaa leematen diza ukeththara Xoossa Dunkaane pengen metto. ");
INSERT INTO gmvl_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Istti qeese gididi summiza wodenne dummatiza wode istta nagaray atto geetettana mala yarshettida he yarshota metto. Gido attiin he yarshoti geesh gidida gishshas hara asi oonikka mooppo. ");
INSERT INTO gmvl_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Qeeseteththan sunththanaas shukkida dharshoza ashoppe woykko ukeththaafe maalado gakkanaas palahidi aqikko dumma gidida gishshas taman xuugetto attiin meetettofo. ");
INSERT INTO gmvl_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«Hessaththo histtada Laappun gallas gakkanaas tani nena azazida mala Aaroonenne iza nayta qeese histtada sunththa. ");
INSERT INTO gmvl_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","«Nagaray atto geetettana mala hach hach nagara gishshas issi mirgo yarsha. Hessankka yarshizasoza geeshsha; histtada yarshizasoza dummaththanaas zayte tiya. ");
INSERT INTO gmvl_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Yarshizasoza nagara geesho wogaa laappun gallas gakkanaas wursada iza dummaththa. Histtiko yarshizasozi dumma geeshshasoho gidana. Iza bochchizaadey ubbay geesh gidana bessees. ");
INSERT INTO gmvl_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«Yarshizason neni hach hach shiishshana yarshoy hayssa; Yelettiin issi layth kumontta nam7u adde laaqqa yarsha. ");
INSERT INTO gmvl_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Adde laaqqatappe issaa maalado, qasse nam7anththoza omarsa wode yarsha. ");
INSERT INTO gmvl_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Koyro dharsho laaqqa issi kilonne bagga lo7o gistte dhiille issi litiro gum7ettida zayten munuqada yarsha; issi litiro woyne ushshu ushsha yarsho histtada yarsha. ");
INSERT INTO gmvl_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Nam7anththo dharsho laaqqaza omarsa wode yarsha. Maaladoyssa gina dhiille, zaytenne woyne ushshu shiishsha. Hessika GODAAS taman xuugettidi sawo tunnu giza yarsho gidana. ");
INSERT INTO gmvl_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","«Ha xuugettiza yarshoy yiza yeleta ubbaan Xoossa Dunkaaneza pengen GODAA sinththan pacey baynda yarshettanaas koshshees. Tani inttenara gaagganaynne nees haasayanay heenkko. ");
INSERT INTO gmvl_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Qasse heen tani Isra7eele naytara gaaggananne ta bonchchoyka he sohoza dumma soho histtana. ");
INSERT INTO gmvl_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","«Hessa gishshas tani Xoossa Dunkaanezanne yarshizasoza dummasana; Aarooneynne iza nayti taas qeese gididi ooththana mala tani istta dummasana. ");
INSERT INTO gmvl_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Histtada tani Isra7eele nayta giddon de7ana; qasse tani istta Xoossaa gidana. ");
INSERT INTO gmvl_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Tani istta giddon de7ana mala Gibxeppe istta kessida GODAA istta Xoossaa gididayssa istti erana. Ee, tani GODAA istta Xoossaa. ");
INSERT INTO gmvl_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«Exaane cuwasi yarshizaso odoro miththafe giigsa; ");
INSERT INTO gmvl_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","izas oyddu zoozey deyo; adussateththay issi wadha, aahoteththay issi wadha, dhoqqateththay qasse nam7u wadha gido; kacetikka izara issi bolla oyketti oosettetto. ");
INSERT INTO gmvl_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Izas bolla baggaa, oyddu milletanne kaceta ubbaa walakay baynda worqqan tiya; iza yuushonkka worqqa balxxanth yuushsha aaththa. ");
INSERT INTO gmvl_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","He balxxanththafe garsara exaane cuwasi yarshizasozas worqqafe nam7u qanggota ooththada he baggaranne ha baggara oyseththa. Heyti tookkiza wode tooho miththata gelththanaassa. ");
INSERT INTO gmvl_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Tooho miththata odoro miththafe kessada worqqan tiya. ");
INSERT INTO gmvl_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ha yarshizasoza Caaqo qaalaa markkay izan diza Taabotaa sinththan kaqettida magalashaappe kare baggara, Caaqo qaala markka bollan diza atto geetettiza sohoza kama ginara woththa. Hessika tani nenara gaaggizaso. ");
INSERT INTO gmvl_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","«Aarooney maalado maalado xomppeta giigsanaas yiza wode sawiza exaane yarshizasozan cuwaso. ");
INSERT INTO gmvl_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Aarooney omarsa wode xomppeta poo7isiza wode, zaareththidikka exaane cuwaso; histtiko exaaney GODAA sinththan yiza yeletaas ubba wode cuwattana. ");
INSERT INTO gmvl_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ha yarshizasozan hara digettida exaanekka, woykko xuugettiza yarsho, woykko kaththa yarsho yarshofa; ushsha yarshoka iza bolla tigoppa. ");
INSERT INTO gmvl_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aarooney layththan issito nagarappe maarettanaas shukkiza mehe suuth ekkidi he yarshizasoza bolla diza kaceta bolla tiyo. Histtidi geesho wogaa polo. Ha wogay sinththara yaana wodeta ubbaan layththan layththan ooththetto. Hessaththo ha yarshizasozi GODAAS dumma geeyidaso gido» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Hessafe guye GODAY Muse hizgides, ");
INSERT INTO gmvl_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«Neni Isra7eele attuma asaa taybiza wode, issi issi asi taybettidi ba shemppo ashshanaas GODAAS miishshe immo; histtiko neni istta taybiza wode asa bolla boshay yeenna. ");
INSERT INTO gmvl_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Taybettida attuma asay hu7en hu7en Xoossa Dunkaanen erettida maka miishsha mala koshshiza miish qanxxo. Issi issi asi baas diza mala immo. ");
INSERT INTO gmvl_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Qoodan geliza attuma asaa layththay nam7u tammu kumidaynne hessafe bollay wuri GODAAS imota eho. ");
INSERT INTO gmvl_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Intte intte shemppo ashshanaas GODAAS imota immishin, dureykka manqoyka issi mala immanaappe attiin, durey darssidi woykko manqoy guuththidi immofo. ");
INSERT INTO gmvl_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ba shemppo ashshanaas immiza miishshe Isra7eele asaappe ekkada Xoossa Dunkaaneza oosos peyshsha. Ha miishshay intte shemppo wozzanaas, GODAA sinththan Isra7eele asaa gishshas hassa7issizaaz gidana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Hessafe guye GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«Meechcha kerezanne kereza iza bolla woththiza miish xarqimalappe medhdha. Xoossa Dunkaanezappenne yarshizasozappe giddon woththada izan haath tiga. ");
INSERT INTO gmvl_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","He haaththaan Aarooneynne iza nayti ba kushenne ba toho meecettetto. ");
INSERT INTO gmvl_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Istti hayqqontta mala Xoossa Dunkaanezan gelshe aydekka he haaththan meecettetto. Qasse GODAAS taman yarsho yarshanaas yarshizaso mata shiiqiza wode, ");
INSERT INTO gmvl_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","istti hayqqontta mala ba kushenne ba toho meecettetto. Hayssi Aaroonessinne iza zereththatas, yiza yeleta ubbaas mernaa woga gido» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","GODAY Muse hizgides, ");
INSERT INTO gmvl_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«Lo7o qimameta, heytikka usuppun kilo goggiza karbbe, heedzdzu kilo sawiza qarafa, heedzdzu kilo sawiza gucachcha maatanne ");
INSERT INTO gmvl_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","usuppun kilo burgude ekka. Hayssi wurikka Xoossa Dunkaanen erettida meezaanen meezaanettidaa gido. Hessa bollaka oyddu litiro wogara zayte gujja ekka. ");
INSERT INTO gmvl_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Heytantta shitto ooththiza mala walakkada sawiza geeshshateththas tiyettiza dumma zayte giigsa. ");
INSERT INTO gmvl_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Histtada Xoossa Dunkaaneza, Caaqo qaalaa markkay izan diza Taabotaa, ");
INSERT INTO gmvl_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","xaraphpheezanne izan go7ettiza miishshata ubbaa, xomppe woththiza ballaanne iza miishshata, exaane cuwasi yarshizasoza, ");
INSERT INTO gmvl_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","xuugettiza yarsho yarshizasozanne izan go7ettiza miishshata ubbaa, meechcha kerenne iza woththizasoza ubbaa tiya. ");
INSERT INTO gmvl_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Istti keehi geesh gidana mala neni istta dummasa; istta bochchizay wurikka geesh gidanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","«Qasseka Aarooneynne iza nayti qeese gididi taas ooththana mala istta tiyada dummasa; ");
INSERT INTO gmvl_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Isra7eele asaas, ‹Hayssi buro yaana yeletaska tiyettiza geeshsha zayte gido. ");
INSERT INTO gmvl_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ha zayteza hara as tiyoppa; qasse hara zayte hessaththo giigsofa. Izi dumma gidida gishshas intteka iza dummateth erite. ");
INSERT INTO gmvl_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Hayssa mala shitto giigsiza asinne tiyettanaas bessontta hara as tiyiza asi oonikka ba asaa garsafe dhayo› ga» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Hessafe guye GODAY Muses, «Sawiza qimameta, miththa uzas, helelon diza shitto, sawiza shidanne harara walakettontta exaane ekka; istta ubbaa meezaaneykka issi gina gido. ");
INSERT INTO gmvl_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Shitto mala walakettida exaane ooththada isttan go7etta; walakay baynda geeshshinne dumma gidana mala izan maxine yegga. ");
INSERT INTO gmvl_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Izappe ekkada liiqisa cadda; histtada tani nenara gaaggiza Xoossa Dunkaaneza giddon Caaqo qaala markkay izan diza Taabotaa sinththan exaane cuwasi yarshizasoza bolla woththa. Izi nees ubbaafe aadhdhida geesh gidana. ");
INSERT INTO gmvl_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Hayssa giigsidayssaththo hara exaane giigsofte. Hessi taas dumma geesh gididayssa ne era. ");
INSERT INTO gmvl_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Hessa misatizaaz giigsidi iza sawo singidi ufayettanaas koyza asi diikko izi ba asaa garsafe dhayo» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Qasseka GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Beya; tani Yuhuda zereth gidida Uures naaza naa, Huurey naa, Basli7eele dooradis. ");
INSERT INTO gmvl_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Iza tani ta Ayanan; hiillateththan, akeekaninne ooso ubbaa ooththiza erateththan kunththadis. ");
INSERT INTO gmvl_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Hessika izi qoppi qoppidi hiillateththan, worqqafe, birappenne xarqimalappe dumma dumma miish ooththanaassa. ");
INSERT INTO gmvl_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Hessaththoka al7o shuch massi massidi giigsanaas, mith massanaassinne heytantta ubbaa ooththanaassa. ");
INSERT INTO gmvl_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","«Hessa bollaka qasse iza maaddana mala, Daane zereth gidida Ahisaameke naa Eelaabe dooradis. Tani nena azazidayssa ubbaa istti ooththana mala, kushe hiillateth erizayta ubbaas erateth immadis. ");
INSERT INTO gmvl_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Istti ooththanayssi Xoossa Dunkaane, Caaqo qaalay izan diza Taabotaanne Taabotaza bolla woththiza atoteththa kama, Xoossa Dunkaaneza ooththanaas go7ettiza miishshata ubbaa, ");
INSERT INTO gmvl_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","xaraphpheezanne iza miishshata, walakay baynda worqqafe oosettida xomppe iza bolla woththiza miish ubbaara, exaane cuwasi yarshizasoza, ");
INSERT INTO gmvl_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","xuugettiza yarsho yarshizasozanne iza miishshata ubbaara, meecettiza kerenne keraa iza bolla woththiza miishshara, ");
INSERT INTO gmvl_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","dadetti oosettida carqqata, qeese Aarooney may7iza dumma may7o, iza attuma nayti qeeseteththa ooso ooththishe may7ana may7o, ");
INSERT INTO gmvl_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","qasse tiyettiza zaytenne geeshsha sozas sawo tunnu giza exaane. Istti hayssa ubbaa tani nena azazida mala ooththana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Hessafe guye GODAY Muse, ");
INSERT INTO gmvl_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«Neni Isra7eele asaas, ‹Ta Sambataa lo7eththi naagite. Hessi tani GODAY inttena taas dumma histtada dooridayssa bessizaaz gididi yaana yeleta ubbaas taappenne inttefe giddon malata gidana. ");
INSERT INTO gmvl_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Inttes he gallassay dumma gidida gishshas Sambata naagite. Iza tunisiza asi mule hayqqanaas bessees; he gallassan ooso ooththizay oonikka ba asaa garsafe dhayo. ");
INSERT INTO gmvl_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Usuppun gallassatan intte ooso ooththite; gido attiin laappunththa gallassay taas GODAAS dummatida shempo Sambata; he gallassaan ooththizaadey oonikka mulera hayqqanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Isra7eele asay he Sambata gallassaa naa naas mernaas malata histtidi naago. ");
INSERT INTO gmvl_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Tani usuppun gallassatan salonne sa7a medhdhada laappunththa gallassan ooso aggada shempida gishshas, taassinne Isra7eele naytas giddon hayssi mernaas caaqo gidana› ga» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","GODAY Musera Siina zumaa bolla haasayzayssa wursida mala izi ba biradhdhen xaafida tammu azazota oykkida nam7u masettida shuchchata Muses immides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Musey zumaappe wodhdhontta keehi gam7idayssa be7idi asay Aaroone yuushon shiiqidi, «Ane Haa ya; neni nuna kaaleththiza eeqa xoossata nuus medhdha. Gibxe biittaafe nuna kessida Musey gidikko izi waanidaakko nu erokko!» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Histtiin Aarooney isttas, «Intte machcheta hayththan, intte attuma nayta hayththaninne macca nayta hayththan diza worqqaa kessidi taas ha ekki yiite» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Hessafe guye asay wuri ba hayththa worqqaa kessidi Aaroones ehides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Izi hessa istta kusheppe ekkidi taman seerisidaappe guye qoxxiza miishshan qoxxidi mara misle medhdhides. Hessafe guye asaykka, «Isra7eele asawu! Nuna Gibxe biittafe kessida nu xoossati haytantta» gides ");
INSERT INTO gmvl_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aarooney hessa be7idi mara misleza sinththan yarshizaso giigsidi, «Wonto GODAAS ba7aale gallas gidana» gi awajjides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Hessa gishshas wonteththa gallas asay wonttara dendidi xuugettiza yarshotanne issifeteththa yarshota yarshides. Histtidi asay maanaassinne uyanaas uttides. Mi uyi simmidi qasse duranaassinne guppanaas dendides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Histtiin GODAY Muses, «Ne Gibxeppe kessa ehida ne asay nagara ooththidi banateththaa tunisida gishshas eeson duge wodhdha. ");
INSERT INTO gmvl_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Tani istta azazida ogeppe istti eeson sher7i giichchida. Worqqa seerisidayssa mara misatissidi, baas eeqa xoossata medhdhidi izas goynnidanne yarshida. Qasseka, ‹Isra7eele asawu! Nuna Gibxe biittafe kessida nu xoossati haytantta› gida. ");
INSERT INTO gmvl_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","«Tani ha asaa beyadis; istti bantta wozina muumida asa. ");
INSERT INTO gmvl_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ha7i ta hanqoy istta bolla eexxi keziin tani istta dhayssanayssa neni tana diggofa. Hessafe qasse ta nena gita kawoteth histtana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Gido attiin Musey GODAA ba Xoossaa, «Abeet Godoo! Neni ne gita wolqqaninne ne mino qesen Gibxeppe kessada ehida ne asaa bolla hessaththo aazas hanqettay? ");
INSERT INTO gmvl_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Gibxe asay, ‹Izi istta zumata bollan wodhanaassinne biittafe pitti dhayssanaas iita qofan kessides› ays geetettay? Neni ne wolqqama hanqofe simma; asaa dhayssanaas qoppidayssa agga. ");
INSERT INTO gmvl_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ne aylleta Abrahaame, Yisaaqanne Yaaqoobe qoppa; neni isttas, ‹Tani intte zereth salo xoolintte mala darsana; tani inttes immana gida biittaa ubbaaka intte zereththatas immana; istti he biittaa mernaas laattana› gaada neni ne sunththan caaqqida qaalaa yuushsha qoppa» giidi gaannatides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Hessa gishshas GODAY ba asaa bolla iita miish ehanaas qoppidayssa aggides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Hessafe guye Musey zumaa bollafe duge wodhdhishe tammu azazoti istta bolla nam7u baggara xaafetti uttida nam7u maseththa shuchchata ba kushen oykki ekki yides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","He masettida shuchchata giigsiday Xoossa; shuchchata bolla woocidi xaafidaykka Xoossa. ");
INSERT INTO gmvl_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Iyaasoy asay wocamizayssa siyidi Muses, «Asay dizason ola waasoy siyettees» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Museykka zaaridi, «Tani siyizayssi hayssi yeththafe attiin, olan xoonidayta qaala woykko xoonettidayta qaala deenna» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Musey derezi dizaso matishe mara misleza sinththan asay durishininne guppishin be7idi keehi hanqettidi masettida shuchchata zuma garsan bollafe yeggidi menththereththides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Asay medhdhida maraakka ekkidi taman xuuggides; hessafe guye liiqisi gaacci haaththan maadhidi Isra7eele asay uyana mala ooththides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Hessafe guye, Musey Aaroone, «Ha asay nena wosttiin neni istta hayssa mala gita nagara ooththana mala kaaleththadii?» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aarooneykka zaaridi, «Ta godoo, hanqettofa! Hayssi asay iita ooththanaas ay mala koyzaakko ne eraasa. ");
INSERT INTO gmvl_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Istti tana, ‹Nuna kaaleththiza eeqa xoossata nuus medhdha. Ays giikko nuna Gibxeppe kessi ehida Musey izi waanidaakko nu erokko!› gida. ");
INSERT INTO gmvl_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Histtiin tani isttas, ‹Intte bolla diza worqqaa kessidi hammite› gadis; hessafe guye istti taas immida worqqaa tani taman yeggiin hayssi maray kezides» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Aarooney asaa la7a yeddi aggiin asay ba morkketa sinththan kawuyidi kadhettanayssa Musey be7ides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Hessa gishshas Musey asay dunkaanidi dizaso geliza pengen eqqidi, «GODAA bagga gidida asi oonikka taakko ha yo!» giin Lewe qommoti wuri izakko shiiqida. ");
INSERT INTO gmvl_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Hessafe guye izi isttas, «GODAA Isra7eele Xoossay, ‹Asay wuri ba giththa mashsha ba xeessan xeessan gixxidi asay dunkaanidason gaxappe gaxa gakkanaas, asaa giddon yaanne haa simerettidi ba isha, ba laggenne ba shooro wodho› » gides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Lewe qommoti Musey azazida mala ooththida; he gallas asaappe heedzdzu shii gidiza asi hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Hessafe guye Musey Lewe qommota, «Hach intte GODAAS dummatideta; ays giikko intte intte naytanne intte ishata wodhanaas azazettidi wodhdhideta; hach GODAY inttena anjjides» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Wonteththa gallas Musey asaa, «Intte gita nagara ooththideta shin ha7i tani GODAAKKO pude zumaa bolla kezana; ta intte nagara atto giissanaakko oonee erizay» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Histtiin Musey GODAAKKO simmi biidi, «Hayssi asay gita nagara ooththides; istti baas worqqafe eeqa xoos medhdhida. ");
INSERT INTO gmvl_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Gido attiin Abeet Godoo! Ha7i istta nagara atto ga; akkay giikko neni xaafida mazgabaappe ta sunththaa qucca digga» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Histtiin GODAY zaaridi Muses, «Tani ta mazgabaappe ta bolla nagara ooththida asata sunththaa quccana. ");
INSERT INTO gmvl_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ha7i baada ha asaa tani nees yootida soo kaaleththa; ta kiitanchchayka nena kaaleththana; gido attiin qaxxayana wodey gakkishin istta nagaraa gishshas ta istta qaxxayana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Aarooney worqqafe mara misle medhdhana mala asay iza waayisida gishshassinne izi medhdhida gishshas GODAY istta bolla bosha yeddides. ");
INSERT INTO gmvl_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Hessafe guye GODAY Muses, «Neninne ne Gibxeppe kessida asay hayssafe dendidi, ‹Tani intte zereththatas immana› ga woththida biittaa biite. He biittay tani Abrahaames, Yisaaqassinne Yaaqoobes immana gaada kase caaqqa woththidayssa. ");
INSERT INTO gmvl_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Tani inttefe sinththara kiitanchcha kiittada, Kanaaneta, Amooreta, Hiiteta, Paarizeta, Hiiwetanne Yaabuseta gooddana. ");
INSERT INTO gmvl_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Maaththinne eessi goggiza he biittaa biite. Gido attiin intte wozina muume as gidida gishshas tani inttena ogen dhayssontta mala ta inttenara biikke» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Asay hessa iita yo7oza siyidi keehi yeekkides. He wodeppe doommidi asay wurikka alleqos aaththizayssa aggides. ");
INSERT INTO gmvl_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Gaasoykka GODAY Muses, «Isra7eele asaas, ‹Intte wozina muumida asa. Haray attoshin guuththa wode ta inttenara issife bizaakko tani inttena dhayssana. Ha7i intte alleqo kessichite; histtiko tani intte bolla ay ooththanaakko intte beyana› ga» gi yooti woththides. ");
INSERT INTO gmvl_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Isra7eele asay Siina zumaappe doommidi ba alleqo miishshaa kessi woththides. ");
INSERT INTO gmvl_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musey Dunkaaneza ekki efidi asay dunkaanidasoppe haassi tolides. Dunkaanezi, «Gaytoteththa Dunkaane» geetetti summides. GODAA oychchanaas koyzay wuri he gayteththa dunkaaney dizaso bees. ");
INSERT INTO gmvl_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Musey he dunkaanezakko bida wode aydekka asay wuri ba dunkaaneza pengen pengen eqqidi Musey dunkaanezan gelana gakkanaas iza xeellees. ");
INSERT INTO gmvl_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Musey gayteththa dunkaaneza giddo gelida wode tuussa mala shaaray duge wodhdhiin GODAY Musera haasayshe dunkaaneza pengen gam7ees. ");
INSERT INTO gmvl_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Tuussa mala shaaraza dunkaaneza pengen be7ida ubba wode, asay wuri ba pengen pengen eqqidi dizasohon dishe GODAAS goynnees. ");
INSERT INTO gmvl_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Asi ba laggera haasayza mala GODAY Musera sinththan eqqidi haasayees. Hessafe guye Musey dunkaaney dizaso guye simmees shin iza maaddiza naateththa naa, Nawe naa Iyaasoy gaytoteththa Dunkaanezappe shaakettenna. ");
INSERT INTO gmvl_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musey GODAAS, «Neni tana, ‹Hayssa asaa kaaleththa› gadasashin tanara neni oona kiittizaakko tana erisabeekka. Neni, ‹Tani nena ne sunththan erays; neni ta sinththan sabettida asa› gadasa. ");
INSERT INTO gmvl_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ne sinththan ta sabettidaa gidikko tani nena erana malanne sinththafekka ne sinththan sabettashe daana mala, ne oge tana tamaarsa. Ha asay ne asa gididayssa qoppa» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Histtiin GODAY zaaridi, «Tani nenara baana; tani nena shempisana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Histtiin Musey iza, «Neni nunara bonttaa gidikko hayssafe nuna kessofa. ");
INSERT INTO gmvl_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Neni nunara bontta ixxiko tananinne ne asaan neni sabettidayssa asay wuri wostti eranee? Biitta bolla diza hara asa ubbaafe tananne ne asaa dummasizay hara miishshi aazee?» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Histtiin GODAY Muse, «Ta nenan sabettida gishshassinne nena ne sunththan eriza gishshas neni tana oychchidayssa qasseka tani ooththana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Histtiin Musey, «Histtiko ne gita bonchchoza tana bessarkkii?» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","GODAY, «Tani ta lo7eteththaa ubbaa ne sinththara aaththana; ta geeshsha sunththaaka ne achchan awajjana. Tani GODAA; tani maaranaas koyzayta maarana; qasse mishettanaas koyzaytaska mishettana. ");
INSERT INTO gmvl_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Gido attiin neni ta ayfeso beyakka; ays giikko oonikka tana be7idi paxa attenna» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Hessafe guye GODAY, «Neni ta achchan eqqanaas zaalla bolla eqqanasoy hayssan dees. ");
INSERT INTO gmvl_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ta bonchchoy aadhdhi biza wode tani nena zaalla za7a giddon woththana. Aadhdhana gakkanaas ta kushen nena kammana. ");
INSERT INTO gmvl_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Hessafe guye tani ta kushe diggiko neni ta zokko beyanashin ta ayfesoy beettanaas bessenna» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","GODAY Muses, «Koyroyta misatiza nam7u shuchchata massa giigsa; histtiko tani he masettida shuchchata bolla kase neni menththida shuchchata bollan diza qaalata xaafana. ");
INSERT INTO gmvl_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Wonto maalado pude Siina zumaa bolla kezanaas giigetta; histtada tanara heen zumaa bollan gaagga. ");
INSERT INTO gmvl_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Nenara oonikka kezoppo; woykko zumaa bolla awanka beettofo; haray attoshin dorsi woykko mehe wudeykka zumaa sinththan heemettofo» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Hessa gishshas Musey koyro shuchchata misatiza nam7u shuchchata massidi GODAY azazida mala, shuchchata ba kushen oykki ekkidi, maalado wonttara pude Siina zumaa bolla kezides. ");
INSERT INTO gmvl_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Keziin GODAY shaarara duge wodhdhi izara heen eqqidi ba sunththaa, «GODAA» gi erisides. ");
INSERT INTO gmvl_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","GODAY Muse sinththara, «Tani GODAY qadhetaynne maarotay kumida Xoossa, hanqettanaas gam7iza, mernaas siiqizanne ammaneteththay darida Xoossa. ");
INSERT INTO gmvl_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Tani ta mernaa siiqoza shii yelet gakkanaas naagays; iitateth, makkallanne nagara atto gays. Gidikkoka moorizaade qaxxayontta aggike; aawata nagara gishshas naytanne nayta nayta, heedzdzanththo yeletanne oydanththo yeleta gakkanaas qaxxayays» gi awajjishe aadhdhides. ");
INSERT INTO gmvl_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Histtiin Musey heerakka biitta bolla gufanni goynnidi, ");
INSERT INTO gmvl_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","«Abeet Godoo! Neni tanan ufayettidaa gidikko ne nunara issife baana mala ta nena woossays. Hayssi asay wozina muume gidikkoka nu iitateththaanne nu nagaraa atto gaada nuna ne as histta» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Histtiin GODAY, «Tani inttenara caaqo geladis; hayssafe kase biitta bolla diza kawoteth ubbaan hani erontta malalisiza miish ne asa ubbaa sinththan ooththana; tani GODAY inttes ooththiza oosoy ay mala malalisizaazakko neni istta giddon diza asay beyana. ");
INSERT INTO gmvl_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Hach tani inttena azaziza azazo naagite; intte sinththafe Amooreta, Kanaaneta, Hiiteta, Paarizeta, Hiiwetanne Yaabuseta tani gooddana. ");
INSERT INTO gmvl_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Istti inttes narxa gidontta mala intte biza biittan diza asaara caaqo caaqettofte. ");
INSERT INTO gmvl_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Istti yarshizasohota laallite; istti goynniza shuchchatakka menththereththite; qasse Asheero geetettiza istta macca eeqa xoossay misletakka menththereththi yeggite. ");
INSERT INTO gmvl_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Tani GODAY qanaatiza Xoossa gidiza gishshas taappe attiin hara eeqa xoossatas goynnofte. ");
INSERT INTO gmvl_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","«He biittan diza asatara ay caaqokka caaqettofte; ays giikko istti tanan ammanettontta ixxidi ba eeqata kaalliza wodenne isttas yarshiza wode istti inttena xeygikko intte istta yarsho maana. ");
INSERT INTO gmvl_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Qasse intte istta macca naytappe dooridi intte attuma naytas ekkana; he wode he macca nayti tanan ammanettontta ixxidi ba eeqa xoossaa kaallidi intte attuma nayti istta kallana mala ooththana. ");
INSERT INTO gmvl_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«Inttes goynnana eeqa xoossata aazappeka seerisidi medhdhofte. ");
INSERT INTO gmvl_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«Ukeththa Ba7aale bonchchite; tani inttena azazida mala laappun gallassas irshoy gelontta uukettida uketh miite; hessaka intte Gibxeppe kezida Abibe aginan ooththite. ");
INSERT INTO gmvl_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«Uloppe bayra yelettiza attuma nay wuri taassa; intte mehe ubbaafekka boora gidiin, woykko dorsa gidiin bayray taassa; ");
INSERT INTO gmvl_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","koyro yelettida hare mar, dorsa laaqqara laammada wozza; wozzontta ixxiko iza qoodhe mirqqa wodha. Ne naytappe bayra yelettida attuma naa ubbaa wozza. «Oonikka immiza miish oykkontta mela kushe ta sinththan beettofo. ");
INSERT INTO gmvl_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«Usuppun gallas ooththite shin laappunththa gallas shempite; goshsha wode gidiin woykko maxa wodenkka laappunththa gallassan shempite. ");
INSERT INTO gmvl_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«Gistte xeera intte maxiza wode kaththa shiisho Ba7aale bonchchite; he layththa wurseththa kath shiishshiza wodekka daase Ba7aale bonchchite. ");
INSERT INTO gmvl_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Isra7eele attuma asay wuri GODAA Ubbaa Haariza Isra7eele Xoossaa sinththan layththan heedzdzuto beettetto. ");
INSERT INTO gmvl_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Dumma dumma dereta tani intte sinththafe yedeththa kessana; histtada intte zawaa tani aassana. GODAA intte Xoossaa sinththan intte layththan heedzdzaa beettanaas pude keziza wode oonikka intte biitta amottenna. ");
INSERT INTO gmvl_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«Intte taas suuththa yarsho yarshiza wode irsho yeggidi uukkida ukeththara yarshofte. Paaziga bonchchiza gallassas yarshida yarshofe maalados aykkoyka attofo. ");
INSERT INTO gmvl_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","«Intte gaden bayra kaxxida kaththaafe koyro xeeraa GODAA intte Xoossaa keeth ehite. «Deyshsha laaqqa iza aayey maaththan doyssofte» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","GODAY Muses, «Tani nenaranne Isra7eele asaara caaqo caaqettizay ha qaalati giza mala gidida gishshas ha qaalata xaafa» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musey kath monttanne haaththe uyontta oyddu tammu gallassinne oyddu tammu qamma GODAARA heen gam7idi caaqo qaala gidida tammu azazota masettida shuchcha bolla xaafides. ");
INSERT INTO gmvl_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musey nam7u masettida shuchchata ba kushen oykkidi Siina zumaappe duge wodhdhida wode, izi GODAARA haasayshe gam7ida gishshas iza ayfesoy xolqides; gido attiin izi hessa eribeenna. ");
INSERT INTO gmvl_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aarooneynne Isra7eele asay wuri Muse xeellidi iza ayfesoy xolqizayssa be7idi izakko shiiqanaas babbida. ");
INSERT INTO gmvl_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Gido attiin Musey istta xeygiin Aarooneynne dereza kaaleththiza halaqati wuri izakko yiin izi istta haasayssides. ");
INSERT INTO gmvl_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Hessafe guye Isra7eele asay wuri izakko shiiqiin GODAY izas Siina zumaa bolla immida azazota ubbaa izi isttas immides. ");
INSERT INTO gmvl_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musey isttas yooti wursidi ba ayfeso naxalan kammides. ");
INSERT INTO gmvl_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Gido attiin Musey GODAA sinth izara haasayanaas gaytoteththa dunkaane giddo geliza wode naxalaa ba ayfesoppe qaarees. Heeppe kezidi GODAY azazidayssa Isra7eele asaas yootees. ");
INSERT INTO gmvl_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Musey yootiza wode Isra7eele asay iza ayfesoy xolqizayssa be7ides. Hessa gishshas Musey GODAARA haasayana baana gakkanaas ba ayfeso zaareththidikka naxalan kammees. ");
INSERT INTO gmvl_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musey Isra7eele asaa ubbaa shiishshidi, «Intte ooththana mala GODAY azazidayssi hayssafe kaalli dizayssa. ");
INSERT INTO gmvl_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Saamintta giddon usuppun gallas xalala ooso ooththite; gido attiin laappunththa gallassay inttes dumma gallassa; GODAASKA shempo Sambata. He gallas ay oosokka ooththiza asi oonikka hayqqanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Sambata gallassan intte soon soon tama eeththofte» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musey Isra7eele maabaraas kumeththaas, «GODAY inttena hizgi azazides. ");
INSERT INTO gmvl_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Inttes dizayssafe GODAAS imota ehite; GODAAS imota ehanaas koyzay oonikka worqqa, biraa, xarqimala, ");
INSERT INTO gmvl_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","salo misatiza qacina, ochcha teera misatiza qacina, xeeqa zo7o qacinanne liiqo layno, deysha anttasha, ");
INSERT INTO gmvl_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","zo7o qalamen geli kezida dharsho ite, qaacettida galba, odoro mith, ");
INSERT INTO gmvl_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","xomppes wogara zayte, tiyettiza zaytenne exaane sawiza qimame, ");
INSERT INTO gmvl_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","eefudenne tira kiisen woththiza margide geetettiza shuchchatanne hara xolqiza al7o shuchchata eho. ");
INSERT INTO gmvl_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","«Intte giddon diza kushe hiillanchchay ubbay yiidi GODAY azazidayssa ubbaa ooththo. ");
INSERT INTO gmvl_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Xoossa Dunkaaneza, Dunkaanezas soo baggaranne kare baggara kammiza dunkaane, qapheta, tole miththata, gorde miththata, tuussatanne isttan eqqiza tohota, ");
INSERT INTO gmvl_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Taabotaanne iza tookkiza toho miththata, atto geetettiza kamanne Taabotaa kammiza magalasha, ");
INSERT INTO gmvl_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","xaraphpheezaza, iza tookkiza tooho miththataranne izas koshshiza miishshata ubbaa, GODAA sinththan woththiza dumma ukeththa; ");
INSERT INTO gmvl_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","xomppe iza bolla woththiza miishshaa izas koshshiza miishshatara, xomppeta, xomppe zayte, ");
INSERT INTO gmvl_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","exaane cuwasizasozanne iza tookkiza tooho miththata, tiyettiza zaytenne sawiza exaane, Xoossa Dunkaaneza penge magalasha, ");
INSERT INTO gmvl_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","xuugettiza yarsho yarshizasonne xarqimalappe oosettida zayzareza, iza tookkiza tooho miththatanne izas koshshiza miishshata ubbaa, xarqimalappe oosettida meechcha kerenne iza woththizaso, ");
INSERT INTO gmvl_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","dunkaanaas kare bagga wuyge magalashata, tuussatanne istta tohota, dunkaanaas kare bagga wuyge geliza pengeza magalasha, ");
INSERT INTO gmvl_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Xoossa dunkaaneza toliza dhishketa, dunkaanaas kare bagga wuyge dhishketanne istta wodorota, ");
INSERT INTO gmvl_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","qeeseti dummasozan ooththishe may7anaas dadettida may7ota, qeese Aarooneynne iza nayti qeeseteththa ooso ooththishe may7iza may7ota ooththana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Hessafe guye Isra7eele asay wuri Muse sinththafe kezi bides. ");
INSERT INTO gmvl_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Immanaas koyidaytinne istta wozinay istta imma imma gidayti wuri yiidi Xoossa dunkaanezas, iza giddon oosettiza oosossinne geeshsha may7o ubbaas koshshiza miish ubbaa ehida. ");
INSERT INTO gmvl_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Immana koyza attumaynne maccay wuri yiidi worqqafe oosettida alleqota, hayththa worqqa, sagayo, qoodhen aaththiza xangalatanne worqqa alleqota ehidi GODAAS yaanne haa qaaseththiza yarsho histti shiishshida. ");
INSERT INTO gmvl_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Salo misatiza qacinay, ochcha teera misatiza qacinay, xeeqa zo7o qacinay, woykko layno geetettiza liiqo qacinay, woykko deysha anttashayay, zo7o qalamen geli kezida dharsho itey, woykko qaacettida galbay diza asi wuri ehides. ");
INSERT INTO gmvl_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Bira woykko xarqimala immanaas dandayzay wuri ba imota GODAAS immides; qasse odoro miththi diza asay wuri dumma dumma oosos odoro mith ehides. ");
INSERT INTO gmvl_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Kushe hiilla eriza maccassay wuri ba kushen suqida salo misatiza qacina, ochcha teera misatiza qacina, xeeqa zo7o qacinanne liiqo layno ehides. ");
INSERT INTO gmvl_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Qasseka imota immanaas koyida maccassay wuri deysha anttasha daddi ehida. ");
INSERT INTO gmvl_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Halaqati eefudenne tira kiisen woththiza margidenne hara bonchchettida shuchchata ehida. ");
INSERT INTO gmvl_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Qasseka xomppes, sawiza exaanessinne tiyettanaas wogara zaytenne qimame ehida. ");
INSERT INTO gmvl_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Isra7eele asay wuri attumaynne maccay, istti ooththana mala GODAY Muse baggara azazida oosos gidiza imota ubbaa ba dosan GODAAS ehides. ");
INSERT INTO gmvl_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Musey Isra7eele asaas, «Be7ite; GODAY Yuhuda qommofe Uures naaza naa, Huurey naa Basli7eele doorides. ");
INSERT INTO gmvl_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","GODAY iza Xoossa Ayanan, aadho eran, akeekaninne ooso ubbaa ooththiza erateththan kunththides. ");
INSERT INTO gmvl_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Hessika hiillan ooso qoppi kessidi worqqafe, birappenne xarqimalappe dumma dumma miish ooththanaassa. ");
INSERT INTO gmvl_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Hessaththoka al7o shuch massi giigsanaassa; qasseka mith massanaassinne dumma dumma ooso hiillan ooththanaassa. ");
INSERT INTO gmvl_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Hessa bollaka qasse izassinne Daane qommofe Ahisaameke naa Eelaabes, hara as tamaarssiza erateth immides. ");
INSERT INTO gmvl_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Istti ubba qommo ooso ooththana mala, hiillan ooththizayta, ooso qofa kessizayta, salo misatiza qacinan, ochcha teera misatiza qacinan, xeeqa zo7o qacinaninne layno qacinan alleqissi daddizayta gidana mala, GODAY istta erateththan kunththides. Istti wurikka ubba qommo ooso eriza eranchcha gidida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","«Hessa gishshas Basli7eeley, Eelaabeynne Xoossa Dunkaane ooththana mala GODAY erateth immida asay wuri GODAY azazida mala istti ooththana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Hessafe guye Musey Basli7eele, Eelaabenne GODAY dumma erateth immidayta ooso ooththanaas yaana koyzayta ubbaa xeygidi shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Shiiqidayti Isra7eele asay Xoossa Dunkaane ooththanaas ehida imota ubbaa Museppe ekkida. Qasse asay ba dosan coo immiza imota maalado maalado gujji gujjidi eho aggibeenna. ");
INSERT INTO gmvl_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Histtiin Xoossa Dunkaaneza ooththiza erateththi kumida asay wuri ba ooththizayssa aggi Musekko biidi, ");
INSERT INTO gmvl_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","«Asay GODAY azazida oosos koshshizayssafe bollara daro ehon dees» gida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Histtiin Musey ba dunkaanen dunkaanen diza asaas, «Nam7anththo oonakka gidiin Xoossa Dunkaane oosos immiza imota ehoppo» gi yootiin asay ehizayssa aggaagides. ");
INSERT INTO gmvl_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Gaasoykka istti ehida imotay ooso ubbaa ooththanaas gidi palahana. ");
INSERT INTO gmvl_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Oosoza ooththizayta giddofe hiillaa darzayti wuri liiqo laynoppenne salo misatiza, ochcha teera misatizanne xeeqa zo7o qacinappe dadettida tammu magalashatappe Xoossa Dunkaaneza giigsida. He magalashata bolla bollara issi hiillanchchay kirubeta misle sikkides. ");
INSERT INTO gmvl_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Magalashati wuri issi gina gididi adussateththay nam7u tammanne osppun wadha; aahoteththay oyddu wadha. ");
INSERT INTO gmvl_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ichchashu magalashata issife gaththi sikkida; qasse hankko attida ichchashu magalashatakka izaththoka ooththida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Issife gaththi sikkida magalashatappe issi magalashaas wurseththa gaxan salo misatiza carqqafe siidhe medhdhida. Qasse issife gaaggi sikettida hankko magalashatankka hessaththoka ooththida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Istti issife gaaggida issi magalasha bolla ichchashu tammu siidheta, qasse issife gaaggida hankko magalashata bollaka ichchashu tammu siidheta medhdhida. He siidheti wurikka issoy issaara ginan deettes. ");
INSERT INTO gmvl_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Hessafe guye worqqafe ichchashu tammu qapheta medhdhidi Dunkaanezi issino gidana mala, he magalashata gaxaa gaxaa he qaphetan gaththi oyseththida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Xoossa Dunkaaneza bollara kammiza dunkaanezas tammanne issi magalashata deysha anttashappe daddida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Tammanne issi magalashatikka issi gina; issi issi magalashaas adussateththi heedzdzu tammu wadha, aahoteththi oyddu wadha. ");
INSERT INTO gmvl_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ichchashu magalashata issi baggara, usuppun magalashata qasse hankko baggara gaththidi sikkida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Hessafe guye gaththi sikkida magalashatappe issi magalasha gaxan ichchashu tammu siidheta medhdhida. Qasseka gaththi sikkida hankko magalashatappe wurseththa magalashaza gaxan ichchashu tammu siidheta medhdhida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Nam7u baggara diza magalashata gaththi issi kama ooththanaas xarqimalappe ichchashu tammu qapheta medhdhida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Hessafe guye Dunkaaneza kammanaas zo7o qalamen yeggi kessida dharsho ite giigsida; qasse iza bollara kammanaas qaacettida galba giigsida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Xoossa Dunkaane tole miththata luule gidida odoro miththafe kessida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Issi issi tole miththaas adussateththay tammu wadha; aahoteththay issi wadhanne bagga. ");
INSERT INTO gmvl_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Issi issi tole issaa issaara gaththi oyseththiza nam7u tole medhdhida. Xoossa Dunkaaneza tole miththata wursika hessaththo ooththida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Xoossa Dunkaanezas tohoso baggara nam7u tammu tole miththata medhdhidi, ");
INSERT INTO gmvl_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Issi issi tole miththas nam7u toho, mulera oyddu tammu toho birappe giigsida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Xoossa Dunkaanezas hu7eso baggara nam7u tammu tole miththata medhdhidi, ");
INSERT INTO gmvl_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Issi issi tole miththas nam7u toho, mulera oyddu tammu toho birappe giigsida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Xoossa Dunkaanezas guye gaxan duge baggara usuppun tole miththata medhdhida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Xoossa Dunkaaneza guye gaxan diza zoozetas nam7u tole miththata giigsida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ha nam7u zoozetan diza toleti xaphoppe xeera gakkanaashe nam7u gidi biidi xeeran issi sagayon geli oykettida. Istti nam7ayka hessaththo oosettida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Hessa gishshas issi issi tole miththas garsara nam7u nam7u tohoti deettes; mulera osppun xagagatinne birappe oosettida tammanne usuppun tohoti deettes. ");
INSERT INTO gmvl_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Qasse istti odoro miththafe tammanne ichchashu kare gordiza mith kessida; isttafe Xoossa Dunkaanezas issi bagga millen diza tole miththatas ichchashu gordiza miththata, ");
INSERT INTO gmvl_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","qasse hankko bagga millen diza tole miththatas ichchashu gordiza miththata giigsida. Hessaththoka Xoossa Dunkaanezas guye baggara arshey wulliza baggara wurseththa gaxan diza tole miththatas ichchashu gordiza miththata medhdhida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Giddora gordiza miththati xagagatas giddo ginara, ha gaxappe he gaxa gakkanaas kanththi kezana mala ooththida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Tole miththaa worqqan tiydi gordiza miththati aadhdhiza sagayota worqqafe medhdhida; qasse gordiza miththata worqqan tiyda. ");
INSERT INTO gmvl_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Salo misatiza qacinappe, ochcha teera misatiza qacinappe, xeeqa zo7o qacinappenne liiqo laynoppe issi magalasha ooththida. He magalashaza bolla issi hiillay kirubeta misle sikkides. ");
INSERT INTO gmvl_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Magalashaas oyddu tuussata odoro miththafe giigsidi worqqan tiyda. Histtidi worqqafe kaqota isttas giigsida. Qasse tuussata essiza oyddu tohota birappe medhdhida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Xoossa Dunkaane geliza pengezas salo misatiza, ochcha teera misatizanne xeeqa zo7o qacinappenne liiqo laynoppe dadettida, xilpen aleqettida magalasha giigsida. ");
INSERT INTO gmvl_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Qasse isttas ichchashu kaqotara diza ichchashu tuussata ooththida. Tuussata xeeraanne ciro qachchizayta worqqan tiyda. Qasse tuussati eqqana mala ichchashu toho xarqimalappe medhdhida. ");
INSERT INTO gmvl_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Basli7eeley odoro miththaafe Taabota giigsides. Taabotaas adussateththay nam7u wadhanne bagga; aahoteththay issi wadhanne baggaa; dhoqqateththay issi wadhanne baggaa. ");
INSERT INTO gmvl_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Taabotaa giigsidi soo bagganne kare baggaa walakay baynda worqqan meeshides; iza yuuyi aadhdhanaas dancco worqqara yuushshi aaththides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Qasse oyddu worqqa sagayota seerisidi Taabotaas oyddu tohotan, issi baggara nam7u sagayota, qasse hankko baggara nam7u sagayota aaththides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Histtidi odoro miththafe tooho miththata kessidi isttaka worqqan meeshides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Taabotaa tookkanaas Taabotaa millen diza sagayotan tooho miththata aaththides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Walakay baynda worqqafe nam7u wadhanne baggaa aduqqiza, issi wadhanne baggaa aakkiza atto geetettiza sohoza kama medhdhides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Kamatas wurseththa nam7u bagga gaxan nam7u kirubeta qoxettida worqqafe medhdhides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Issi kirubeza issi bagga gaxan, nam7anththo kirubeza hankko bagga gaxan, nam7atakka kamazara gaththi oyseththi medhdhides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Kirubeti ba qefe denththidi atto geetettiza sohoza kammiza kama ba qefen kammi woththida; qasse issoy issaara xeelettana mala ooththides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Qasse adussateththay nam7u wadha, aahoteththay issi wadha, dhoqqateththay issi wadhanne bagga gidida xaraphpheeza odoro miththafe medhdhidi, ");
INSERT INTO gmvl_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","walakay baynda worqqan meeshides. Iza yuuyi aadhdhanaas worqqa kifafe yuushshi aaththides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Hessaththoka aahoteththay tadhdhako gidiza kifafe iza bolla yuushshi aaththides. Histtidi iza yuuyi aadhdhanaas worqqa dancco yuushshi aaththides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Histtidi Taabotaa tookkanaas giigiza oyddu worqqa sagayota medhdhidi oyddu tohoti tokettida oyddu zoozetara oyseththides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Xaraphpheezaza tookkanaas tooho miththata istta giddora aaththiza sagayoti xaraphpheezaza xanxa bolla medhettida. ");
INSERT INTO gmvl_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Xaraphpheezaza tookkiza tooho miththaa odoro miththafe kessidi worqqan meeshides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Hessaththoka xaraphpheeza bolla woththiza dumma dumma miishshata walakay baynda worqqafe medhdhides; heytikka saanetanne cilfata, qasse ushsha yarsho isttan seerisiza keretanne xuu7ata. ");
INSERT INTO gmvl_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Hessafe guye Basli7eeley xomppe woththizasoza qoxettida walakay baynda worqqafe medhdhides; xomppezi izan eqqiza toho, qasse giddo toomaakka ubbaa qoxettida worqqafe medhdhides. Iza kureta, iza dhemotanne iza ciishshata ubbaa izara issife oyseththi medhdhides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Millera usuppun ballata medhdhides; heedzdzu haggata issi baggara, qasse heedzdzu haggata hankko baggara kessides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Usuppun haggataska hu7en hu7en issi issi dhemotinne ciishshati diza, ochcholoone ciish misatiza wanca medhdhides; ");
INSERT INTO gmvl_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","xomppe woththizasozas giddo toomay, dhemotinne ciishshati diza ochcholoone ciishshe misatiza oyddu wancan alleqetti uttides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Nam7ay nam7ay issife waaththan diza heedzdzu ballatanne garsara issi issi dhemoy dees. ");
INSERT INTO gmvl_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Dhemotinne haggati wuri xomppe woththizasozara issife oyketti issino gididi walakay baynda worqqafe qoxetti medhettida. ");
INSERT INTO gmvl_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Izi qasse xomppe woththizasozas laappun xomppeta, xomppe toyssiza qaphetanne qapheta woththizaso walakay baynda worqqafe medhdhides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Xomppeza woththizasozanne izan go7ettiza miish ubbaa medhdhanaas heedzdzu tammanne ichchash kilo gidiza walakay baynda worqqa wursides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Hessaththoka qasse exaane cuwasizasoza odoro miththafe medhdhides. Izas oyddu gulay dees; adussateththay issi wadha; aahoteththay issi wadha, dhoqqateththay nam7u wadha. Iza kacetikka izara issino gididi oyketti medhettidayta. ");
INSERT INTO gmvl_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Izas bolla baggaza, oyddu milletanne iza kaceta walakay baynda worqqan meeshidi iza yuushshi aaththanaas xanxaza worqqafe ooththides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","He worqqa xanxaafe garsara exaane cuwasizasozas worqqafe nam7u sagayota medhdhides; histtidi he baggaranne ha baggara nam7u nam7u oyththides. Heyti tookkiza wode tooho miththata aaththanaas maaddanaassa. ");
INSERT INTO gmvl_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Tooho miththata odoro miththafe kessidi istta worqqan meeshides. ");
INSERT INTO gmvl_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Qasse dummatida tiyettiza zaytenne sawo tunnu giza lo7o exaane, shitto mala giigsides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Odoro miththafe xuugettiza yarsho yarshizaso ooththides. He yarshizasoza dhoqqateththay heedzdzu wadha, aahoteththaynne adussateththay issi gina, ichchashu ichchashu wadha gididi oyddu gulay dizayssa ooththides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Oyddu gulata wurseththa xeeran xeeran issi issi kace medhdhides. He kaceti yarshizasozara issife oykettidi oosettida. Histtidi yarshizasoza xarqimalara meeshides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Izan go7ettiza miishshata, bidinth kessiza saaneta, akaafata, kereta, asho konccetanne bonqo tama oykkiza kon7a ubbaa xarqimalappe medhdhides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Histtidi xarqimalappe zayzare yarshizasozas giigsidi yarshizasozas duge giddo ginan diza xanxazas garsa baggara woththides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Xarqimalappe medhdhida zayzarezas oyddu gulan tooho miththata aaththanaas oyddu qanggota medhdhides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Odoro miththafe yarshizasoza tooho miththata kessidi xarqimalan meeshides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Yarshizasoza tookkiza wode maaddana mala tooho miththata nam7u millera diza qanggotan aaththides. Yarshizasoza giddo doy7a aggidi sanqqafe medhdhides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Xarqimalappe meechcha kerenne kereza woththizaso medhdhides; he xarqimalazikka Xoossa Dunkaaneza pengen ooththiza maccassati ehida xarqimala mastooteppe ekettides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Hessafe guye dubbushasoza giigsides. Dunkaanezas kare bagga wuyges tohoso bagga adussateththaa xeetu wadha ooththidi, liiqo laynoppe dadettida magalasha giigsides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Izas xarqimalappe nam7u tammu tuussatanne tuussati izan eqqiza xarqimala toho ooththides; istta hu7en qasse birappe medhettida istta bolla kaqqizaytanne tuussata hu7en qachchizayta ooththides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Dunkaanezas kare bagga wuygezas hu7eso baggaa adussateththay xeetu wadha; qasse nam7u tammu tuussatinne he tuussatas nam7u tammu xarqimala tohoti deettes. Qasseka birappe oosettida istta bolla kaqqizaytinne tuussata hu7en qachchizayti deettes. ");
INSERT INTO gmvl_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Arshey wullizaso baggara diza dubbushaa aahoteththi ichchashu tammu wadha gididi tammu tuussatinne tuussatas tammu tohoti diza magalashata giigsides; he tuussata hu7en birappe medhettida istta bolla kaqotanne tuussatas hu7en qachchizayta ooththides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Qasse arshey mokkiza baggara diza dubbushaso aahoteththi ichchash tammu wadha. ");
INSERT INTO gmvl_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Dunkaanezas kare bagga wuygeza gelizasoppe issi baggara tammanne ichchash wadha aduqqiza magalashati, isttas heedzdzu tuussatinne tuussatas heedzdzu tohoti deettes. ");
INSERT INTO gmvl_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Hessaththoka Dunkaanezas kare bagga wuygeza gelizasoppe hankko baggara tammanne ichchashu wadha aduqqiza magalashati, isttas heedzdzu tuussatinne tuussatas heedzdzu tohoti deettes. ");
INSERT INTO gmvl_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Dunkaanezas kare bagga wuygeza yuushon diza magalashati wuri liiqo laynoppe dadettida. ");
INSERT INTO gmvl_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","He tuussatas tohoy xarqimalappe, kaqotinne tuussatas hu7en qachchizayti birappe oosettida; istta hu7ey biran meeshettides. Hessa gishshas dubbushasoza yuushon diza tuussata ubbaa hu7en birappe oosettida qachchiza miishshati deettes. ");
INSERT INTO gmvl_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Dunkaanezas kare bagga wuygeza gelizason kaqqiza magalashay salo misatiza, ochcha teera misatizanne xeeqa zo7o qacinappenne liiqo laynoppe dadettidi xilpen alleqissi giigsidaaza. Izas adussateththay nam7u tammu wadha; dhoqqateththay Dunkaanezas kare bagga wuygeza magalashata mala ichchashu wadha. ");
INSERT INTO gmvl_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Izaskka xarqimalappe oosettida oyddu tuussatinne tuussatas oyddu tohoti deettes. Istta kaqotinne tuussatas hu7en qachchiza miishshati birappe oosettida; istta xeeratikka biran meeshettida. ");
INSERT INTO gmvl_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Xoossa Dunkaaneza dhishketinne iza yuushon diza Dunkaanezas kare bagga wuygeza dhishketi wuri xarqimalappe oosettidayta. ");
INSERT INTO gmvl_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Xoossa Dunkaanezas go7ettida miishshata Lewe qommoti mazgaban xaafida. He miishshata qeese Aaroone naa Itamaare daannateththa garsan diza Leweti mazgaban xaafana mala Musey azazides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Biniyaame zereth gidida Uures naaza naa, Uure naa, Basli7eeley GODAY Muse azazidayssa ubbaa ooththides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Daane zereth gidida Ahisaameke naa Eelaabey izara dees; izi kushe hiillanchchanne oosos koyro qofa kessizaadeko; qasse salo misatiza, ochcha teera misatizanne xeeqa zo7o qacinaninne liiqo laynon dadidi xilpen alleqissiza asa. ");
INSERT INTO gmvl_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Xoossa Dunkaaneza oosos GODAAS yaanne haa qaaseththi shiishshiza yarshos imettida worqqay Xoossa Dunkaanen erettida meezaanen woththiin 1,000 kilo gidides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Taybon diza maabara asaappe beettida biray Xoossa Dunkaanen erettida meezaanen woththiin 3,430 kilo gidides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Asaa taybiza wode taybettida attumasay wuri issaadey hu7en hu7en immidayssi Xoossa Dunkaanen erettida meezaanen woththiin usuppun giraame mala gidides. Taybettida asay nam7u tammu layth kumidaynne nam7u tammaafe bollara dizay mulera 603,550. ");
INSERT INTO gmvl_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Xoossa Dunkaaneza magalashata essida xeetu tohoti 3,400 kilo gidiza biran oosettida. Hessika issi issi tohos 34 kilo tigettiza bira. ");
INSERT INTO gmvl_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Attida heedzdzu tammu kilo biraa tuussata bolla kaqoso medhdhanaas, tuussatas hu7e bolla meeshanaassinne istta hu7en qachchiza miishshata medhdhanaas go7ettida. ");
INSERT INTO gmvl_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Hessaththoka asay GODAAS yaanne haa qaaseththi shiishshanaas ehida xarqimala yarshoy 2,425 kilo gidides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","He xarqimalappe Xoossa Dunkaaneza gelizason eqqiza tuussatas tohoy, xarqimalappe oosettida yarshizaso geetettiza yarshizasozi, iza giddon woththida xarqimala zayzareynne iza giddon go7ettiza dumma dumma miishshay wuri medhettides. ");
INSERT INTO gmvl_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Hessaththoka qasse Dunkaanezas kare bagga wuyge yuushon diza dirsa giddo gelizaso pengen eqqida tohoy, qasse Xoossa Dunkaanezanne iza yuushon diza Dunkaanezas kare bagga wuyge dirsay tolettida dhishketi wuri he xarqimalaappe medhettida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Qeeseti Xoossa Dunkaanen ooththiza wode may7ana may7o, salo misatiza, ochcha teera misatizanne xeeqa zo7o qacinappe daddida. Aaroone qeeseteththaa may7oka GODAY Muse azazida mala ooththida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Qasse istti eefude worqqafe, salo misatiza, ochcha teera misatizanne xeeqa zo7o qacinappenne liiqo laynoppe daddida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Istti worqqa qoxxi lee7isidi, izappe qarari qararidi qacina kessida. Histtidi salo misatiza, ochcha teera misatizanne xeeqa zo7o qacinanne liiqo layno gaththidi kushe hiillanchchati daddida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Nam7u baggay gaaggidi issino gidana mala nam7u hashe bolla gaththidi oyththiza carqqa giigsida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","GODAY Muse azazida mala hiillay alleqissidi daddida danccoyka eefudera issife gididi, worqqafe salo misatiza, ochcha teera misatizanne xeeqa zo7o qacinappenne liiqo laynoppe dadettides. ");
INSERT INTO gmvl_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Istti margide geetettiza nam7u shuchchata giigsidi worqqafe medhdhida shuchchu oykkizayssa bolla maarara woththida. Maatafa bolla sunth wooci xaafiza mala he shuchchata bolla Isra7eele nayta sunth woocidi xaafida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","GODAY Muse azazida mala tammanne nam7u Isra7eele qommota hassa7issizaaz gidana mala, ha tammanne nam7u shuchchata eefudezara oyththidi hashe kaqoza bolla woththida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Istti tiran woththiza kiise kushe hiillan ooththida. He tiran woththiza kiiseza eefude worqqafe daddida mala, salo misatiza, ochcha teera misatizanne xeeqa zo7o qacinappenne liiqo laynoppe daddida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Izas oyddu xeeray dees; dhoqqateththaynne aahoteththay issi issi tadhdhako. ");
INSERT INTO gmvl_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Hessafe guye iza bolla oyddu maaran al7o shuchchata woththida; koyro maaraan woththida shuchchay sardiyoone, tophaaziyoonenne xolqiza inqqu; ");
INSERT INTO gmvl_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","nam7anththo maaran baluure, simpere almaaze geetettiza al7o shuchchata; ");
INSERT INTO gmvl_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","heedzdzanththo maaran yaakintte, kelqedoonenne ametesxinoose; ");
INSERT INTO gmvl_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","oydanththo maaran birille, margidenne yasphiide. Heyta ubbaa worqqafe oosettida shuchchu oykkizayssa bolla woththida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Isra7eele nayta sunththaa qooda mala, shuchchata qoodaykka tammanne nam7a; issay issay maatame mala woocettidi tammanne nam7u qommota sunththi he shuchchata bolla xaafettides. ");
INSERT INTO gmvl_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Tiran diza kiisezas wodoro mala dooqettida sansalataa walakay baynda worqqafe medhdhida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Nam7u worqqafe medhdhida shuchchu oykkizaytanne nam7u worqqa migidota medhdhidi tiran woththiza kiisezas qommo gaxa xeerata gaththi oyththida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","He nam7u worqqa sansalatata tiran woththiza kiisezas xeeran diza migidotara gaththi oyseththida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","He sansalatatas hankko bagga xeeraa qasse eefudezas sinththa baggara, hashe kaqo bolla diza shuch oykkizaytara gaththi qachchida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Qasseka nam7u worqqa midigata medhdhidi eefudeppe kaalli diza tira kiisezas soo baggara diza nam7u xeeratan aaththida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Hessaththoka worqqafe hara nam7u migidota medhdhidi, eefudezas sinththa baggara, hashe kaqozappe garsa baggara eefude xeessan qachchizayssafe qommora, sikoy gaaggizaso achchan istta oyththida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","GODAY Muse azazida mala tira kiisen diza migidota eefudezan diza migidotara gaththidi, salo misatiza suqeththan qachchida gishshas tira kiisezi xeessafe bollara diza gishshas, qashoy dol7enna. ");
INSERT INTO gmvl_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Eefudezappe bollara may7iza qamisa istti mulera salo misatiza carqqafe giigsida; hessika shemmaane oosokko. ");
INSERT INTO gmvl_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","He qamisazas qoodhe aaththizaso medhdhida; qoodhesoy daakettontta mala, soo bagga qalam7idi yuushshi aaththi sikkida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Istta qamisazas duge bagga maccara yuushon salo misatiza, ochcha teera misatizanne xeeqa zo7o qacinappenne liiqo laynoppe oroomaane geetettiza miththa ayfe teera misleta medhdhida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Qasseka worqqafe daalata medhdhidi qamisatas duge bagga xeera yuushshi aaththidi oroomaane misleta giddon aaththi aaththi walakkida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","GODAY Muses azazida mala istti Xoossa Dunkaane ooso ooththishe may7ana mala qamisazas duge bagga maccara yuushshi aaththidi daalanne oroomaane teera misle walakki aaththida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","GODAY Muse azazida mala istti Aaroonessinne iza naytas shemmaaney daddida liiqo laynoppe qolleta giigsida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Qasse hu7en xaaxiza shaasheta, qoobetanne garsara may7iza may7ota liiqo laynoppe daddidi giigsida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Hessaththoka qasse istti salo misatiza, ochcha teera misatizanne xeeqa zo7o qacinappenne liiqo laynoppe daddidi kushe hiillan alleqissidi dancco giigsida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Istti akilile misle walakay baynda worqqafe medhdhidi maatame bolla woociza mala iza bolla, «GODAAS geesh gididi dummatides» gizayssa wooci xaafida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Hessafe guye hu7e goossa bolla kaqqana mala, GODAY Muse azazida mala salo misatiza baqeth izan aaththidi qachchida. ");
INSERT INTO gmvl_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Xoossa Dunkaaneza oosoy wuri mulera polettides. Isra7eele asay ubbaa GODAY Muse azazida mala ooththides. ");
INSERT INTO gmvl_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Hessafe guye istti Xoossa Dunkaaneza mulera ekkidi Musekko ehida; hessika dunkaanezanne iza miishshaza ubbaa, qapheta, tole miththata, penge gordiza miththata, tuussatanne istti eqqiza tohota, ");
INSERT INTO gmvl_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","bollara kammanaas dharshoza ite zo7o qalamen yeggi kessidayssa, qaacettida galba, genththiza magalasha, ");
INSERT INTO gmvl_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Caaqo Qaala Taabotaa, iza tookkiza tooho miththata, atto geetettiza kamaa, ");
INSERT INTO gmvl_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","xaraphpheezanne iza miishshe ubbaa GODAA sinththan woththiza geeshsha ukeththaa, ");
INSERT INTO gmvl_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","walakay baynda worqqafe oosettida xomppe woththizasozanne izan maaran diza xomppeta, istta miishshata ubbaanne xomppe zayte, ");
INSERT INTO gmvl_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","worqqafe oosettida exaane cuwasizasoza, tiyettiza zayte, sawiza exaane, Xoossa Dunkaane penge magalasha, ");
INSERT INTO gmvl_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","xarqimalappe ooththida yarshizasoza, xarqimala zayzareza, iza tookkiza tooho mith, iza miishshata ubbaa, meechcha kerenne kereza iza bolla woththiza miishshata, ");
INSERT INTO gmvl_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Dunkaanezas kare bagga wuyge godaa genththiza magalashata, iza tuussata, istti eqqiza tohota, Dunkaanezas kare bagga wuyge geliza pengeta magalashata, Dunkaanezas kare bagga wuyge wodorotanne dhishketa, Xoossa Dunkaanezas koshshiza miishshata ubba; ");
INSERT INTO gmvl_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Qeeseti Geeshsha soon ooththidi may7anaas dadettida may7ota, Aarooneynne iza nayti qeeseteththan ooththishe may7iza may7ota. ");
INSERT INTO gmvl_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Isra7eele asay oosoza ubbaa GODAY Muse azazida mala ooththides. ");
INSERT INTO gmvl_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musey oosoza xomosi xeellidi istta GODAY azazida mala ooththidayssa be7ides. Hessa gishshas Musey istta anjjides. ");
INSERT INTO gmvl_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Hessafe guye GODAY Muse, ");
INSERT INTO gmvl_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Koyro aginan koyro gallas, neni Xoossa Dunkaane tola. ");
INSERT INTO gmvl_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Caaqo Qaala Taabotaa iza giddon woththada Taabotaza magalashan genththa. ");
INSERT INTO gmvl_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Xaraphpheezaa gelththada iza bolla wodhdhanaas koshshiza miishshata ubbaa iza bolla woththa. Histtada xomppeta iza bolla woththiza miishshaza soo gelththada iza bolla xomppeta woththa. ");
INSERT INTO gmvl_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Worqqafe oosettida exaane cuwasizasoza Caaqo Qaala Taabotaa sinththan woththada, Xoossa Dunkaaneza giddo geliza penge magalashaza kaqqa. ");
INSERT INTO gmvl_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","«Xuugettiza yarsho yarshizasoza Xoossa Dunkaanezi geliza penge sinththan woththa. ");
INSERT INTO gmvl_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Izan meecettiza kereza Xoossa Dunkaanezappenne yarshizasozappe giddon woththada haaththe izan tiga. ");
INSERT INTO gmvl_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Xoossa Dunkaanezappe karera yuushsha aaththada Dunkaanezas kare bagga wuyge giigsada dubbushaa gelizason magalasha kaqqa. ");
INSERT INTO gmvl_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«Tiyettiza zayteza ekkada Xoossa Dunkaanezanne iza giddon dizayssa ubbaa tiya; izanne iza giddon go7ettiza miishshata ubbaa dummasa; histtiko izi geesh gidana. ");
INSERT INTO gmvl_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Hessafe guye xuugettiza yarsho yarshizasonne izas go7ettiza miishshaa ubbaa tiya; yarshizasoza dummasa; histtiko izi ubbaafe aadhdhida geesh gidana. ");
INSERT INTO gmvl_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Meechcha kerezanne kereza iza bolla woththiza miishshata tiyada istta dummasa. ");
INSERT INTO gmvl_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«Neni Aaroonenne iza nayta Xoossa Dunkaanezi geliza penge ehada haaththan meecca. ");
INSERT INTO gmvl_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Hessafe guye qeeseteththa may7oza Aaroone mayzada izi taas qeeseteththan ooththana mala iza tiyada dummasa. ");
INSERT INTO gmvl_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Iza attuma naytakka ehada qolle mayza. ");
INSERT INTO gmvl_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Istti taas qeeseteththan ooththana mala, istta aawaa tiyda mala, isttaka tiya. Istta tiyeteththankka isttanne istta yeletay wuri qeese gididi ooththana mala ta ooththana» gides. ");
INSERT INTO gmvl_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musey ubbaaka GODAY bana azazida mala ooththides. ");
INSERT INTO gmvl_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Hessa gishshas Gibxeppe istti kezida nam7anththo layththan, koyro aginan koyro gallassan Xoossa Dunkaaney tolettides. ");
INSERT INTO gmvl_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musey Xoossa Dunkaaneza essiza wode Dunkaaneza toho istta sohon sohon woththides; tole miththatanne tuussaa aaththides; gordiza miththatakka gelththides. ");
INSERT INTO gmvl_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Hessafe guye Musey GODAY azazida mala dunkaaneza tolidi iza bollara kama kammides. ");
INSERT INTO gmvl_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Histtidi tammu azazoti xaafettida masettida shuchchata efidi Taabotaza giddon woththides; tookkiza tooho miththata Taabotaan aaththides; maaroteththa kamaakka Taabotaa bolla woththides. ");
INSERT INTO gmvl_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Hessafe guye Taabotaza Xoossa Dunkaaneza giddo gelththides; genththiza magalashaa kaqqidi, GODAY azazida mala Caaqo Qaala Taabotaza kammides. ");
INSERT INTO gmvl_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","GODAY Muse azazida mala, Musey xaraphpheezaza Xoossa Dunkaanezan gelththidi, magalashaappe karera hu7esora woththidi, ");
INSERT INTO gmvl_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","iza bolla GODAA sinththan woththiza geeshsha uketh giigsides. ");
INSERT INTO gmvl_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","GODAY Muse azazida mala, xomppe woththizasoza Xoossa Dunkaane giddo gelththidi, xaraphpheezas sinththa baggara, Xoossa Dunkaanezas tohosora woththides; ");
INSERT INTO gmvl_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","qasse xomppeta GODAA sinththan oyththides. ");
INSERT INTO gmvl_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","GODAY azazida mala, worqqafe oosettida exaane cuwasizasoza Xoossa Dunkaaneza giddo gelththidi magalashazas sinththa baggara woththidi, ");
INSERT INTO gmvl_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","iza bolla sawiza exaane cuwasides. ");
INSERT INTO gmvl_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Hessafe guye Xoossa Dunkaaneza pengen magalashaa kaqqides. ");
INSERT INTO gmvl_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Xuugettiza yarsho yarshizasoza Xoossa Dunkaane gelizaso penge achchan woththides; iza bolla xuugettiza yarshonne kaththa yarsho GODAY azazida mala yarshides. ");
INSERT INTO gmvl_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Meechcha kereza Xoossa Dunkaanezappenne yarshizasozappe giddon woththides. Histtidi meecettanaas haaththe izan tigides. ");
INSERT INTO gmvl_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musey, Aarooneynne iza nayti ba kushenne ba toho izan meecettida. ");
INSERT INTO gmvl_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","GODAY Muse azazida mala, istti Xoossa Dunkaanen geliza wode woykko yarshizaso shiiqiza wode aydekka meecetteettes. ");
INSERT INTO gmvl_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Xoossa Dunkaanen yarshizaso yuushshi aaththidi dubbusha giigsides; he dubbushaa pengen magalasha kaqqides. Hessaththo histtidi Musey oosoza polides. ");
INSERT INTO gmvl_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Hessafe guye shaaray Xoossa Dunkaaneza kammides; GODAA bonchchoyka iza kumides. ");
INSERT INTO gmvl_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Shaaray Xoossa Dunkaaneza bolla uttida gishshassinne GODAA bonchchoy iza giddon kumida gishshas Musey iza giddo gelanaas dandaybeenna. ");
INSERT INTO gmvl_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Isra7eele asay ba oge ubbaan, he shaaray Xoossa Dunkaanezappe dendiza wode aydekka iza kaallidi beettes. ");
INSERT INTO gmvl_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Gido attiin he shaaray dendontta ixxiko izi dendana gallassay gakkanaas isttika qaaxxettenna. ");
INSERT INTO gmvl_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Istta oge ubbaan GODAA shaaray Isra7eele asay wuri be7ishin, gallas gallas Xoossa Dunkaane kammeessinne qamma qamma qasse tamay he shaaraa giddon eexxees.");
INSERT INTO gmvl_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","GODAY Gaytoteththa Dunkaaneza giddon dishe Muse xeygidi hizgi azazides, ");
INSERT INTO gmvl_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«Isra7eele asay GODAAS yarsho shiishshiza wode istti naagana wogay hayssafe kaallizayssa; issi issi asi miizappe gidiin dorsafe woykko deyshafe gidiin ay qommo yarshoka shiishshiza wode, ");
INSERT INTO gmvl_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","hessika miizappe issaa xuugettiza yarshos shiishshanaas koykko issi boreykka iza bolla baynda mirgo boora dooridi eho; histtiko izi GODAA ufayssiza yarsho gidana mala Gaytoteththa Dunkaaneza pengen shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Xuugettiza yarsho shiishshizaadey ba shiishshiza booraa hu7e bolla ba kushe woththo; he yarshozikka iza nagaraa wursanaas GODAY ekkiza lo7o yarsho gidana. ");
INSERT INTO gmvl_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Hessaadey mirgoza heen GODAA sinththan shukko; histtiko Aaroone zereththatappe gidida qeeseti booraza suuththaa GODAAS shiishshetto; Gaytoteththa Dunkaanen geliza penge baggara diza yarsho yarshizasoza bolla lanqera yuuyi aadhdhanaas suuththaa wuxxetto. ");
INSERT INTO gmvl_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Hessafe guye he yarshoza shiishshizayssi he shukettida meheza galbaa shooqidi kesso; ashoza qommon qommon qanxxereththo. ");
INSERT INTO gmvl_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Qeese Aaroone zereth gidida qeeseti yarsho yarshizasoza bolla mith gophidi tama eeththetto. ");
INSERT INTO gmvl_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Qeeseza Aaroone zereth gidida qeeseti he meheza ashoza qommon qommon shaakkidi hu7ezanne handaza gujjidi yarsho shiishshizason korettida miththaa bolla woththetto. ");
INSERT INTO gmvl_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","He yarshoza shiishshizayssi he meheza qanththa ashozanne guye gedata haaththan meecco; qeesezi yarshoza ubbaa yarshizasoza bolla xuuggo; hayssa mala taman xuugettiza yarsho sawoy GODAA ufayssees. ");
INSERT INTO gmvl_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","«Izaadey ba dorsafe woykko ba deyshafe issaa xuugettiza yarshos shiishshana koykko issi borey iza bolla baynda dharsho woykko orge gido. ");
INSERT INTO gmvl_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Hessaka yarsho shiishshizasozappe pudeha baggara Xoossa sinththan shukko; Aaroone zereth gidida qeeseti suuththaa ekkidi yarsho yarshizasoza bolla yuuyi aadhdhanaas wuxxetto. ");
INSERT INTO gmvl_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","He yarshaa shiishshizaadey he shukkida ashoza qommon qommon qanxxi kessidaappe guye he oosozas doorettida qeesey he kessida ashoza ubbaa hu7ezanne handazakka issife yarsho yarshizason gophettidi taman eexxiza miththaa bolla woththo; ");
INSERT INTO gmvl_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Addezi he mehezas qanththa ashozanne nam7u gedata haaththan meecco; qeesezikka hessa ubbaa GODAAS yarsho ooththi shiishshidi yarsho shiishshizasoza bolla ubbaa xuuggo; hessa mala taman xuugettiza yarsho sawoy Xoossaa ufayssees. ");
INSERT INTO gmvl_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","«Issaadey GODAAS xuugettiza yarsho kafoppe shiishshana koykko haraphphe ciye woykko waanose geetettiza kafoppe gidanaas dandayees. ");
INSERT INTO gmvl_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Qeesezikka he kafoza ekkidi gede yarshozaso shiishshidi kafoza qoodhe mirqqo; yarshoza shiishshida tamaan iza xuuggo; suuththika yarshoy iza bolla shiiqizayssa millera duge xoketto. ");
INSERT INTO gmvl_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Baallezanne qanththa ashoza dumma shaakkidi yarsho iza bolla shiishshizasozappe arshey mokkiza baggara bidinththi qolettizason yegetto. ");
INSERT INTO gmvl_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Qefeta oykkidi nam7u kessi phalqidi ashoza mulera shaakki yeggontta dishe yarsho shiishshizasoza bolla diza tamaan mulera xuuggo; hessa mala taman xuugettiza yarsho sawoy GODAA ufayssees. ");
INSERT INTO gmvl_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«Ay asikka Xoossas kaththa yarsho shiishshiza wode liiqo dhiille shiishshana bessees; he dhiilleza bolla wogara zaytenne exaane gujjo; ");
INSERT INTO gmvl_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Aaroone zereththafe gidida qeesetakko ekki yo; he wode iza ooso taray gakkida qeesey he dhiillezappe ba kuphpha kumeththa zaytezanne exaaneza ekkidi wurikka Xoossas shiiqidayssa erisanaas yarsho shiishshizayssa bolla taman xuuggo; hessa mala kaththa yarsho sawoy Xoossaa ufayssees. ");
INSERT INTO gmvl_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Kaththa yarshofe attida dhiilley Aaroone zereththafe gidida qeesetas imetto; hessika Xoossas shiiqida yarshofe shaaketti ekettida gishshas haratappe keehi dummatees. ");
INSERT INTO gmvl_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","«Yarshozi ukeththi uukettiza bashen uukettidaa gidikkoka irshoy bochchonttaaz gido; izikka wogara miththa zaytera walakettidi liiqo dhiillera uukettida qeeri uketh woykko zayten gindetti uukettida uketh gidanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","«Yarshozi tama coocen kompettidaaz gidikko irshoy bochchontta wogara miththa zaytey gujettidi liiqo dhiillefe giigettidaaz gido. ");
INSERT INTO gmvl_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Ne ukeththaza basereththada iza bolla wogara miththa zayte gussada kaththa yarsho shiishsha. ");
INSERT INTO gmvl_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","«Yarshozi qeeri bashen uukettida ukeththa mala gidikko wogara miththa zaytey izan gujetti munuqettida liiqo dhiillefe giigidaaz gido. ");
INSERT INTO gmvl_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Kaththa Yarsho Xoossas imettiza yarsho histta qeesezas imma; qeesezikka yarsho yarshizason yarsho. ");
INSERT INTO gmvl_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Qeesezi hessa he yarshozappe baggaa ekkidi ubbaa GODAY izi shiishshidayssa yuushshi qoppana mala yarsho yarshizason diza tamaan xuuggo; hayssa mala taman xuugettiza yarsho sawoy GODAA ufayssees. ");
INSERT INTO gmvl_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Yarshishin attidayssi qasse qeesetas imetto; hessika GODAAS shiiqida yarshofe shaaketti ekettida gishshas haratappe keehi dummatees. ");
INSERT INTO gmvl_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","«GODAAS xuugetti yarshettiza kaththa yarshora shiiqiza irsho gidiin woykko ees gidikkoka ne taman xuugganaas bessontta gishshas ne GODAAS shiishshiza kaththa yarshon ubbaan aykko irshoyka izan geloppo. ");
INSERT INTO gmvl_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Layththan layththan kath shiishshiza wode koyro maxettida kaththaafe xeera yarsho ooththidi GODAAS ekki yiite; he yarshozi yarsho yarshizasozan taman xuugettofo. ");
INSERT INTO gmvl_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Ay qommo kaththa yarshonkka maxiney dhayoppo; hessi neni ne Xoossaara caaqettida caaqo qaalaas malata; hessa gishshas ne shiishshiza kaththa yarsho ubbaa maxinera mal7inththa ooththa. ");
INSERT INTO gmvl_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Kath shiishshiza koyro aginan kaththa xeera ne shiishshiza wode caacettidi shigechchettida tiya gido. ");
INSERT INTO gmvl_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Hayssi kaththa yarsho gidida gishshas iza bolla wogara miththa zaytenne exaane gujja. ");
INSERT INTO gmvl_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Qeesezikka he yarshozappe bagga ekkidi izi GODAAS shiiqidaaz gididayssa akeekissana mala zaytezakka, exaanezakka ubbaa kaththara issife xuuggo. ");
INSERT INTO gmvl_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«Ay asikka saroteththa gishshas ba meheppe GODAAS issifeteththa yarsho shiishshiza wode iza bolla wosoy baynda mirgo woykko macca miiz dooridi eho. ");
INSERT INTO gmvl_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Yarsho ehizaadey yarshos izi shiishshiza meheza bolla ba kushe woththidi Gaytoteththa Dunkaane penge matan shukko; Aaroone zereth gidida qeeseti suuththaa izappe ekkidi yarshoy yarshettizasoza milleza bolla yuuyi aadhdhanaas wuxxetto. ");
INSERT INTO gmvl_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Issifeteththa yarshos shiiqiza yarshozappe GODAAS taman xuugettiza yarsho gidi shiiqanayti qanththa ashota goozi oykkida handaa kumeth, ");
INSERT INTO gmvl_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","kilahotanne istta bolla diza handaa hessaththoka tire goozi oykkida handatappe doorettidayta. ");
INSERT INTO gmvl_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Qeeseti hessa ubbaa hara xuugettiza yarshora gaththi yarsho yarshizason xuugetto; hessa mala taman xuugettiza yarsho sawoy GODAA ufayssees. ");
INSERT INTO gmvl_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","«Issifeteththas shiiqiza yarshoy dorsafe woykko deyshafe gidikko adde woykko macca gididi istta bolla wosoy bayndayta gidetto. ");
INSERT INTO gmvl_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Issi asi GODAAS shiishshiza yarshoy dorsa laaqqa gidikko, ");
INSERT INTO gmvl_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ba kusheza laaqqaa hu7e bolla woththidi Dunkaaneza penge bolla shukko; qeeseti suuththaa izappe ekkidi yarsho yarshizasoza bolla milleza yuuyi aadhdhanaas wuxxetto. ");
INSERT INTO gmvl_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Issifeteththa yarshos shiiqiza yarshozappe GODAAS taman xuugettiza yarsho gidi shiiqanayti handazanne zokko meqeththa garsafe qanxxettida goyna ubbaa, qanththa asho goozi oykkida handa ubbaa, ");
INSERT INTO gmvl_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","kilahotanne istta goozi oykkida handa ubbaa qasse tire kammi oykkida lo7o handa ubbaa, ");
INSERT INTO gmvl_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","qeesezikka hessa ubbaa GODAAS kaththa yarsho histti shiishshidi yarsho yarshizasoza bolla xuuggo. ");
INSERT INTO gmvl_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","«Issi asi GODAAS yarsho deyshe shiishshizaa gidikko, ");
INSERT INTO gmvl_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ba kushe deyshaza hu7e bolla woththidi Dunkaaneza sinththan shukko; qeeseti suuththaa izappe ekkidi yarshoy yarshettizasoza bolla milleza yuuyi aadhdhanaas wuxxetto. ");
INSERT INTO gmvl_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","He shukettida ashozappe hayssafe kaalliza asho qommota kaththa yarsho ooththidi GODAAS shiishshetto; heytikka qanththa asho kammiza handa ubbaa, ");
INSERT INTO gmvl_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","kilahotanne istta goozi oykkida handaa, qasseka tire kammi oykkida lo7o handazappe ekketto. ");
INSERT INTO gmvl_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Qeesezikka hessa taman xuugetti sawiza yarsho ooththidi yarsho yarshizason xuuggo; handay wuri GODAAS shaakettidi dummato. ");
INSERT INTO gmvl_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Isra7eele naytappe handa mizaadey woykko mehe suuth uyizaadey dooppo; hessi wuri Isra7eele nayti dizasoninne istti diza wode ubbaan mernaas eqqi diza woga gido.» ");
INSERT INTO gmvl_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Xoossi Muse hizgi azazides; ");
INSERT INTO gmvl_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«Neni Isra7eele naytas yootanayssi hayssa; oonikka erontta baleteththan nagara ooththiko woykko erontta GODAA azazotappe issaa moorikko hayssafe kaalliza wogaa naago! ");
INSERT INTO gmvl_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","«He wode tiyettida qeesey nagara ooththidi derezi nagara ooththidaa misatissi beettiko iza bolla issi wosoykka baynda issi mirgo boora ehidi ba nagaraa gishshas GODAAS yarsho shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Kormaza dunkaaneza penge ehidi ba kushe iza hu7e bolla woththidi GODAA sinththan shukko. ");
INSERT INTO gmvl_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Hessafe guye qeeseta halaqay he booraza suuththaafe guuththara ekkidi gede dunkaaneza giddo gelo; ");
INSERT INTO gmvl_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","GODAA Keeththa magalashaas sinththa baggara eqqidi ba biradhdhe suuththaan gelththi gelththi kessidi laappunto gakkanaas wuxxo. ");
INSERT INTO gmvl_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Izappe guuththa suuth ekkidi Dunkaaneza giddon exaane yarshizasozan oyddu baggara diza dhemota bolla woththo; hankko attida suuththaa dunkaanezan geliza penge baggara xuugettiza yarshoy yarshettizaso garsan gusso. ");
INSERT INTO gmvl_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","He mirgoza handaza ubbaa, qanththa asho kammi oykkida handazakka, ");
INSERT INTO gmvl_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","kilahotakka istta goozi oykkida handazanne hessaththoka tire kammi oykkida moodhezappe doorettidayssa ekko. ");
INSERT INTO gmvl_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Qeeseta halaqay hessa ubbaa ekkidi xuugettiza yarshoy shiiqiza yarshosoza bolla xuuggo; oosozikka issifeteththas yarshoy shiiqiza meheza handafe ekkidi xuugettiza yarshos shiiqiza mala hano. ");
INSERT INTO gmvl_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Gido attiin galbaza, ashoza, hu7ezanne tohota, maracezaranne qanththa asho, ");
INSERT INTO gmvl_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","heeraappe gede kare kesso; gede bidinth kessi qolizaaso, tunonttaso efidi miththi shiishshidi taman xuuggo. ");
INSERT INTO gmvl_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«Isra7eele asay erontta bala ooththiko woykko erontta GODAA azazoppe issino mooridaa gidikko he nagaraykka asaappe geemmiko, ");
INSERT INTO gmvl_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","he oosettida nagaray erettida mala heerakka derezi he nagaraa gishshas yarshos issi mirgo eho; izakka asay Gaytoteththa Dunkaane sinththe shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Deraa halaqati bantta kushe mirgoza hu7e bolla woththiin heen boorazi GODAA sinththan shuketto. ");
INSERT INTO gmvl_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Tiyettida qeesey he mirgoza suuththafe guuththara ekkidi gede Dunkaanezan gelo; ");
INSERT INTO gmvl_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","GODAA Keeththa magalashaas sinththa baggara gididi ba kushe biradhdheta laappunto suuththan gelththi gelththi kessidi Xoossa sinththan wuxxo. ");
INSERT INTO gmvl_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Qasseka guuththa suuth ekkidi Dunkaane giddon diza exaane iza bolla yarshizasozas oyddu baggara diza dhemota bolla woththo; attida suuththaa qasse gede Dunkaanen gelizason xuugettiza yarshoy yarshettizasoza garsan gusso. ");
INSERT INTO gmvl_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Hessafe qasse he mirgo moodheza ubbaa ekkidi yarsho yarshizasoza bolla xuuggo. ");
INSERT INTO gmvl_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Oosozi wurikka nagara gishshas shiiqiza mirgo yarshizayssaththo ooththetto; tiyettida Qeesezi deraappe nagara diggana; deraasikka atto geetettana. ");
INSERT INTO gmvl_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Hessafe guye mirgoza asay dizasoppe gede kare kessidi ba nagaraa gishshas shiishshida mirgoza kase xuuggoyssaththo xuuggo; hessika dereza nagarappe geeshshiza yarsho gidana. ");
INSERT INTO gmvl_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«Nagara ooththidaadeynne erontta dishe baleteththan GODAA ba Xoossaa azazotappe issiniyo mooridaadey izi dere kaaleththizaade gidikko, ");
INSERT INTO gmvl_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ba ooththida nagara izi erida mala heerakka issi borey iza bolla baynda deysha orge ba nagarappe maarettanaas yarsho shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ba kushe deyshaa hu7e bolla woththidi yarsho yarshizasozappe pudeha baggara xuugettiza yarshos shiiqiza meheti shukettizason GODAA sinththan shukko. Hessika nagara diggiza yarsho gidana. ");
INSERT INTO gmvl_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Qeesezi he shukettida meheza suuththan ba biradhdheta gelththi gelththi kessidi oyddu baggara diza dhemota tiyo; izappe attida suuththa yarshoy yarshettizasoza garsan gusso. ");
INSERT INTO gmvl_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Handaza ubbaa yarsho yarshizasoza bolla xuuggo; he oosoy kase issifeteththa yarshos shiishshida meheta handa xuuggoyssaththo ooththetto; hessaththo qeesezi dereza kaaleththizaade nagara wursanaas yarsho shiishsho; izaskka atto geetettana. ");
INSERT INTO gmvl_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«Nagara ooththidaadeynne erontta dishe baleteththan GODAA azazotappe issiniyo mooridaadey hankko deraa giddofe gidikko, ");
INSERT INTO gmvl_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ba ooththida nagara izi erida mala heerakka izi bolla issi boreykka baynda macca deysh ba nagaraa gishshas shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ba kushe he deyshay hu7e bolla woththo; yarsho yarshizasoppe pudeha baggara xuugettiza yarshos shiiqiza meheti shukettizason shukko. ");
INSERT INTO gmvl_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Qeesezikka he shukettida deyshay suuththan ba biradhdheta gelththi gelththi kessidi oyddu baggara diza dhemota tiyo; izappe attida suuththaa yarshoy yarshettizasoza garsan gusso. ");
INSERT INTO gmvl_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Issifeteththas shiiqiza yarshos shiiqiza meheta moodhe bollara shooqi kessizayssaththo hayssa ha meheza moodheka ubbaa bollara shooqi digo; sawozi GODAA ufayssiza yarsho ooththidi yarshizasoza bolla xuuggo; hessaththo qeesezi he addeza nagara izappe digganaas yarsho shiishsho; izaadeska atto geetettana. ");
INSERT INTO gmvl_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","«He addezi ba nagarappe maarettanaas yarshos dors shiishshana koykko izi bolla aykko borey baynda macca dors shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Izaadeyka dorsay hu7e bolla ba kushe woththo; yarsho yarshizasoppe pudeha baggan xuugettiza yarshos shiiqiza meheti shukettizason shukko. ");
INSERT INTO gmvl_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Qeesezi qasse dorsay suuththan ba biradhdhe gelththi gelththi kessidi yarsho yarshizasozas oyddu baggara diza dhemota suuththara tiyo; izappe attida suuththaa yarsho yarshizaso garsan gusso. ");
INSERT INTO gmvl_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Hessafe kaallidi issifeteththa yarshos shiiqiza meheta moodhe shooqi ekkizayssa mala ha dorsay moodheka ubbaa shooqi digo; hessaka GODAAS shiiqiza kaththa yarshos shiishshizasoza bolla xuuggo; hessaththo qeesezi he addeza nagara izappe digganaas yarsho shiishsho; izaadeska atto geetettana. ");
INSERT INTO gmvl_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","«Issaadey ba be7ida miishshe markkattana mala pirda pirdizaso xeygettidi ba be7idayssa woykko ba erizayssa markkattontta ixxiko hessi izas nagara gidana; hessa gishshas izaadey oyshettana. ");
INSERT INTO gmvl_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","«Ay asikka erontta dishe wogan digettida do7ata bawuta, meheta bawuta woykko tiran biittara gooshettiza medheteththata bawuta bochchidaadey tunees; hessika izaades nagara gidees. ");
INSERT INTO gmvl_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","«Ay asikka erontta dishin asappe goggi kezidi tunisiza miish bochchiko izaadey hessa erida gallassafe doommidi izas nagara gidees. ");
INSERT INTO gmvl_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","«Ay asikka iitas gidiin kiyas gidiin yuushshi qoppontta coo mela adina adinettiko izaadey ooththida mooroza zaari akeekida wodeppe doommidi izaades nagara gidana. ");
INSERT INTO gmvl_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","«Ay asikka hayta ha miishshatappe issaan qohi beettiko ba nagara qonccisi paaxanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Izaadey ba nagaraa gishshas macca dors woykko macca deysh yarshanaas eho; qeeseykka izappe ekkidi izaade nagara wursanaas GODAA sinththan yarsho. ");
INSERT INTO gmvl_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","«Ay asikka ba ooththida nagara gishshas dors woykko deyshe shiishshanaas dandayonttaaz gidikko nam7u haraphpheta woykko haraphphe ciyeta ehidi issiniyo nagara yarshos nam7anththayokka xuugettiza yarshos Xoossa sinth shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Ehidi qeesezas immo; qeesezikka qoho yarshos shiiqiza kafoy qoodhe qanxxontta mirqqidi qoho yarshos shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Suuththaafe guuththara ekkidi yarsho yarshozasoza bolla yuuyi aadhdhanaas wuxxo; attida suuththaa yarsho yarshizaso garsan wuxxo; hessika nagara wurso yarsho gidana. ");
INSERT INTO gmvl_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Hankko attida kafoyo diza wogaa mala xuugettiza yarsho histti shiishsho; hessaththo ooththidi qeesezi izaade nagaraa wursanaas yarsho; iita ooththidaades iza nagaray atto geetettana. ");
INSERT INTO gmvl_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Izaadey nam7u haraphpheta shiishshanaas dandayonttayssa gidikko ba nagaraa gishshas issi kilo liiqo dhiille eho; hessika nagara yarshos gidiza gishshas wogara zaytey woykko exaaney izan gujettofo. ");
INSERT INTO gmvl_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Izakka ehidi qeesezas immo; qeesezikka he dhiillezappe ba kushen kuphphati ekkidi GODAAS shiiqiza kaththa yarshora issife gaththi hassa7issanaas yarsho yarshizasoza bolla xuuggo; hessika nagara gishshas shiiqiza yarsho. ");
INSERT INTO gmvl_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ay asikka haytantta mala nagaratappe issaa ooththiko qeesezi hessa mala ooththidi izaadey ooththida nagaraa wursanaas yarsho shiishsho; hessaadeska atto geetettana; hankko attida dhiilley kaththa yarshoy qeesezas attiza mala izas gido.» ");
INSERT INTO gmvl_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«Ay asikka GODAAS immanaas bessizayssa erontta aggidi immontta aggiko izas nagara gidida gishshas issi wosoy iza bolla baynda dharsho qohos gidiza yarsho GODAAS shiishsho; iza waaga heregaykka kase Xoossa Keeththan erettida herega mala gido; hessika qoho gishshas shiiqiza yarsho. ");
INSERT INTO gmvl_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","GODAAS immanaas bessishin izaadey immontta aggidayssa ciggo; hessafekka bollara hayssa ha heregaas ichchashaappe issi kushe gujjidi qeesezikka izi ehida dharshaara gaaggidi nagara yarsho ooththidi ehidaade nagara wursana; he mooro ooththidayssi atto geetettana. ");
INSERT INTO gmvl_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","«Ay asikka erontta dishe GODAY ooththofte gida azazotappe issiniyo moorikko izaades nagara; he nagaraa gishshas izaadey oyshettana. ");
INSERT INTO gmvl_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Izaadeyka ba moorida mooroza gishshas ba meheta giddofe iza bolla issi wosoy baynda dharsho qeesezakko eho; izi ehidayssa wogay kase qoho yarshos ciggiza waaga kessizaaz gido; qeesezikka hessaththo asi erontta ooththida mooroza geeshsho; izaadeyka maarettana. ");
INSERT INTO gmvl_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Hessika qoho gishshas shiiqiza yarsho; izaadeyka GODAA sinththan mooro ooththida gishshas nagaranchcha.» ");
INSERT INTO gmvl_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«Oonikka asi izas hadara woykko tal7e immida miish kaddidi ba lagge baleththon nagara ooththidi hessan GODAA mishisikko woykko asa miishshe bonqqi ekkiko woykko baleththiko, ");
INSERT INTO gmvl_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","woykko asappe wodhdhi dhayda miishshe demmi ekkidi ta beyabeekke gi wordora caaqqiko asi ooththiza ha moorota ubbaafe issineyn qohikko, ");
INSERT INTO gmvl_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ay asikka hayssa mala nagara ooththiko izi kayson ekkidayssa izas hadara imettidayssa woykko dhayiin demmi ekkidayssa zaaro. ");
INSERT INTO gmvl_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Wordora caaqqi ekkidayssa ubbaa qoho yarsho shiishshiza wode kase ba ekkoyssa bolla ichchashaappe issi kushe gujjidi zaaro. ");
INSERT INTO gmvl_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Ba qohidayssas eda gidana mala iza bolla issi wosoy baynda dharsho GODAAS yarshana mala qeesekko eho; iza wogaykka kase qoho yarshos cigettiza waaga kessizaaz gido. ");
INSERT INTO gmvl_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Qeesezikka he addeza nagara diggana mala GODAA sinththan yarsho; izaadeska atto geetettana.» ");
INSERT INTO gmvl_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","GODAY Muse hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","«Neni Aaroonessinne iza naytas istti naagana mala ne isttas immana azazoy hayssafe kaallizayssa; xuugettiza yarshoy pacey baynda gadey wonttana gakkanaas yarshizasoza bolla ubba wode tamay eexxishe aqo. ");
INSERT INTO gmvl_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Qeesezi laynoppe dadettida qamisanne sure may7idi xuugettiza yarshoza tamay midayssafe guye attida bidinththaa heeppe yarsho yarshizasozappe mille baggara qolo. ");
INSERT INTO gmvl_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Hessafe guye ba may7ida may7o laammidi bidinththaza tookki ekkidi asi dizasoppe gede kare kessidi maarara lo7oson qolo. ");
INSERT INTO gmvl_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Yarshizaso bolla diza tamay to7ontta ubba wode eexxishe do; aydekka to7oppo; qeesezikka wontta wontta taman mith gujjo; iza bolla xuugettiza yarsho ubba wode giigsi woththidi issifeteththa yarshos shiiqiza handa xuuggo. ");
INSERT INTO gmvl_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Yarsho yarshizasoza bolla diza tamay ubba wode to7ontta eexxanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","«Kaththa yarsho shiisho gishshas woththida wogati hayssafe kaallizayta; Aaroone baggafe gidida qeesezi kaththa yarsho yarshizaso sinththa baggara Xoossas yarsho. ");
INSERT INTO gmvl_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Kaaleththidi zaytera diza liiqo dhiille kuphphati ekkidinne kaththa yarsho bolla diza exaaneza ubbaa denththidi GODAAS shiishshidayssa erisana mala yarsho shiishshizaso bolla xuuggo; hessa sawoykka GODAA ufayssiza yarsho gidana. ");
INSERT INTO gmvl_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Hessafe attidayssa qeeseti metto; izankka irshoy gelontta dishin uukkidi GODAY woosettiza geeshsha dunkaanaasi sinththa baggara diza dembaa bolla metto. ");
INSERT INTO gmvl_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Hessika izan irshoy gelontta uukettanaas bessees; tani GODAY taman xuugettiza kaththa yarshofe hayssa istta gisha histta immadis; hessika nagara gishshassinne qoho gishshas shiishshiza yarsho mala wurikka keehi dummatidaaza. ");
INSERT INTO gmvl_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Wode wodenaas Aaroone zereththaafe attuma gidi yelettiday wuri GODAAS shiiqiza yarshofe shaakettidi dumma izas gisha imettidayssi hessi izas gisha gidida gishshas izi ba gisha maanaas dandayees; oonikka hessa he yarshoza bochchidaadey GODAAS dummatidaade gidana bessees.» ");
INSERT INTO gmvl_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","«Aarooney woykko iza zereththati qeeseteththan shuumettiza gallas istti Xoossas shiishshana kaththa yarshoy ubba wode issi kilo gidiza liiqo dhiille kaththa yarsho ooththidi GODAAS shiishshetto; hessafe baggaa maalado, baggaa omars yarshetto. ");
INSERT INTO gmvl_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Zayten lo7eththi munuqettidi bashen uuketto. Hessafe guye kaththa yarshoza basereththidi sawozi GODAA ufayssiza sawo gidana mala Xoossas shiiqo. ");
INSERT INTO gmvl_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Hayssafe yaana layththatan qeese gididi ooththiza Aaroone zereththi wurikka hayssa ha wogaa polo; hayssi Xoossas shiiqiza yarsho gididi mulera xuugetto. ");
INSERT INTO gmvl_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Qeesezi shiishshiza kaththa yarshozi kumeth xuugetto attiin asi izappe mooppo.» ");
INSERT INTO gmvl_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","GODAY Muse hizgi azazides, ");
INSERT INTO gmvl_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","«Aaroonessinne iza naytas ne hizga yoota, ‹Nagara gishshas yarshettiza yarsho wogay hayssafe kaallizayssa, Xuugettiza yarsho mehey shukettizason nagara gishshas yarshettiza yarsho meheykka heen GODAA sinththan shuketto; hessika keehi dumma yarsho. ");
INSERT INTO gmvl_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","He yarshozakka shiishshiza qeesezi dummatidason Gaytoteththa Dunkaanezi diza gibbeza giddon diza dembaan ashoza mo. ");
INSERT INTO gmvl_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","As gidiin hara ay miishshika he ashoza bochchiko dummatana; he meheza suuththi iza bolla pinxida ay may7oyka Xoossas dummatidason meecetto. ");
INSERT INTO gmvl_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","He ashoy izan doysettida mana miishshi meqqo; ashoy xarqimala biratan doysettiko he xarqimala biratazi qiicettidi haaththan meecetto. ");
INSERT INTO gmvl_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Qeeseta zereththafe gidida attuma naa ubbay hessa he yarshozappe mo; hessika keehi dumma yarsho. ");
INSERT INTO gmvl_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Gido attiin nagara geeshos oosettiza wogan suuththay Gaytoteththa Dunkaane giddo gelidaa gidikko he meheza ashozi taman xuugetto attiin meetettofo. ");
INSERT INTO gmvl_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","« ‹Keehi dumma gidida gishshas qoho gaason shiiqiza yarsho wogay hayssafe kaallizayssa, ");
INSERT INTO gmvl_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","qoho Yarshos shiiqida mehey xuugettiza yarshos shiiqiza meheti shukettizason heen shuketto; suuththaaka yarsho yarshizasoza bolla yuuyi aadhdhanaas wuxetto. ");
INSERT INTO gmvl_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Moodhe ubbaa shiishsho; hessika goyna handa, qanththa asho goozi oykkida moodhey, ");
INSERT INTO gmvl_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","kilahota, istta kammi oykkida moodhetanne hessaththoka tire kammi oykkida moodheta issi bolla yarshetto. ");
INSERT INTO gmvl_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Yarsho yarshizason diza moodhe ubbaa qeesezi Xoossas taman xuuggi yarsho; hessika qoho gishshas shiiqiza yarsho. ");
INSERT INTO gmvl_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Qeeseta zereth gidida attuma asi ubbay he yarshoza asho mo; gido attiin he yarshozi dumma gidida gishshas izas dumma giigettidaason mo. ");
INSERT INTO gmvl_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","« ‹Nagara wursanaas shiiqiza yarshossinne qohos shiiqiza yarsho giddon nam7ataska ooththiza issi wogay dees; hessika he shukettiza meheza ashoy yarshoza shiishshiza qeesezas maana mala izas imettees. ");
INSERT INTO gmvl_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Xuugettiza yarshos shiiqiza meheza galbay shooqettidi yarshoza yarshida qeesezas imettees. ");
INSERT INTO gmvl_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Tama coocen kompettida kaththa yarshoy wuri woykko doyssiza miishshan doysettidaazinne bashen uukettida kaththa yarsho ubbay yarsho shiishshiza qeesezas imetto. ");
INSERT INTO gmvl_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Zayten munuqettidaaz gidikko woykko coo munuqettontta kaththa yarsho ubbay Aaroone zereththatappe gidida qeesetas ubbaas imetto; isttika iza ba garsan issi gina gishetti ekketto. ");
INSERT INTO gmvl_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","« ‹Asi GODAAS shiishshiza issifeteththa yarsho wogay hayssafe kaallizayssa; ");
INSERT INTO gmvl_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","issi asi GODAAS galata yarsho shiishshana koykko ba ehiza galata yarshozara irshoy izan gelontta zayten munuqetti uukettida uketh, irshoy izan gelontta lee7en uukettidi zayten tiyettida uketh, liiqo dhiillefe zayten munuqettida uketh yarsho. ");
INSERT INTO gmvl_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Galatas shiiqiza issifeteththa yarshozara gaththi imotas gidana mala irshon munuqetti uukettida uketh shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Uukettida dumma dumma qommo ukeththatappe issi issi uketh GODAAS dumma yarsho histti shiishsho; he issifeteththa yarshos shiiqiza suuththaa ekkidi yarsho shiishshizasoza yuuyi aadhdhanaas wuxxiza qeesezas gisha gido. ");
INSERT INTO gmvl_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Galatas shiiqiza issifeteththa yarshozas shiiqiza ashoy he yarshettiza gallas meetetto attiin hara gallassas attofo. ");
INSERT INTO gmvl_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Issi asi shiishshiza yarshoy adina gaso woykko ba dosan coo immiza issifeteththa yarsho gidikko he yarshozi shiiqida gallas meetetto; izappe attida ubbay wonteththa gallas meetetto. ");
INSERT INTO gmvl_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Hessafekka tirpidi heedzdzanththo gallas gakkanaas attida ashoy taman xuugetto; ");
INSERT INTO gmvl_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Heedzdzanththo gallas gakkanaas attida ay ashoykka meetettizaa gidikko he yarshoza shiishshidaade yarshozi ekettenna; yarshozi yarshettida mala qoodettenna; he yarshoyka tuna gidi qoodettana; he ashoza midaadey ba nagaran oyshettana. ");
INSERT INTO gmvl_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","« ‹Tuna gididaazara boshettida ashoy taman xuugetto attiin meetettofo; hankko tunontta attida ashoza woga mala bana geeshshateththan naagidaaddey mo. ");
INSERT INTO gmvl_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Gido attiin geesh gidontta ay asikka Xoossas shiiqiza issifeteththa yarsho ashoza miikko GODAA deraa giddofe shaaketti kichcho. ");
INSERT INTO gmvl_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Ay asikka geesh gidontta miish woykko medosatanne goggiza tuna miish bochchidi issifeteththas shiiqiza yarsho asho miikko hessaadey GODAA deraa giddofe shaaketti dhayo.› » ");
INSERT INTO gmvl_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","GODAY Muses, ");
INSERT INTO gmvl_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«Neni Isra7eele asaas, ‹Boora woykko miiza moodhe, dorsa moodhe woykko deysha moodhe moopite. ");
INSERT INTO gmvl_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Bawuta hayqqida mehe moodhey woykko do7ay wodhida mehe moodhey hara oosos eketto attiin ay asikka iza mooppo. ");
INSERT INTO gmvl_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Xuugetti GODAAS yarsho shiiqiza mehe moodhe mizaadey oonikka Xoossa deraa giddofe shaaketti dhayo. ");
INSERT INTO gmvl_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Intte awan diikkoka intte dizason kafo suuth woykko mehe suuth uyopite; ");
INSERT INTO gmvl_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Suuth uyizaadey oonikka Xoossa dere giddofe shaaketti dhayo› gi yootides» gides. ");
INSERT INTO gmvl_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","GODAY Muses, ");
INSERT INTO gmvl_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«Neni Isra7eele asaas, ‹Ay asikka issifeteththa yarsho shiishshizaa gidikko izappe baggaa shaakkidi GODAAS dumma yarsho histti eho. ");
INSERT INTO gmvl_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","He izi ehoyssaka GODAAS xuugettiza yarsho histti shiishsho; moodhezakka angasozara GODAA sinththan yaanne haa qaaseththi shiishshiza yarsho histti shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Qeesezi qasse moodheza yarsho yarshizasoza bolla xuuggo; angasozi gidikko qeesetas imetto. ");
INSERT INTO gmvl_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Intte issifeteththa yarshozappe ushachcha missaa qeesezas gisha histti immite; ");
INSERT INTO gmvl_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","issifeteththa yarshoza suuththaanne moodheza shiishshiza qeesezi ushachcha missaa ba gisha histti ekko. ");
INSERT INTO gmvl_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Isra7eele asaa issifeteththa yarshofe yaanne haa qaaseththida angasozanne yarshos shiishshida missaa ekkada qeese Aaroonessinne iza attuma naytas immadis; hessika ubba wode Isra7eele asaappe isttas gisha gidana mala immadis› gaada yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Hayssika GODAY Aaroonenne iza nayta qeese histti shuumida gallas GODAAS shiiqidi xuugettiza yarshofe qeeseta gisha gidana mala shaakkidaaza. ");
INSERT INTO gmvl_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","He gallassika istti tiyettida; GODAY hessa he yarshettizayssafe qeesetas immana mala Isra7eele asaa azazides; hessika guyeppe yaana wode ubbaan Isra7eele naytas istta gisha histti immana mala ooththides. ");
INSERT INTO gmvl_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Hessa gishshas xuugettiza yarsho gishshassinne kaththa yarsho gishshas, nagarappe maaroteththas shiiqiza yarsho gishshassinne qoho gishshas, eda yarsho gishshas, qeeseteththa gishshas shiiqiza yarshonne issifeteththa yarsho polanaas woththida wogati haytantta. ");
INSERT INTO gmvl_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Heytikka bazzon Siina zuma bolla Isra7eele nayti yarsho shiishshana mala azazida wode he gallas GODAY Muses hayta azazota immides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","GODAY Muses, ");
INSERT INTO gmvl_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«Aaroonenne iza attuma nayta, qeeseteththa may7ozakka, tiyettiza zayteza, nagara geeshos shiiqiza korma boora, nam7u dharshonne irshoy gelontta uukettida ukeththi izan diza leemateza isttara ekka ya. ");
INSERT INTO gmvl_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Kumeththa Isra7eele nayta xeygada Gaytoteththa Dunkaaneza pengen shiishsha» gides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Museykka GODAY izas yootida mala ooththides; dereykka Gaytoteththa Dunkaane pengen shiiqides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Museykka deraas, «Oosettana mala GODAY azazoyssi hayssako!» gides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Museykka Aaroonenne iza attuma nayta deraa sinth shiishshidi haaththan meeccides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Aaroone qamisaa mala adussa may7o mayzidi, kabborteka iza bolla gophi mayzidi dancco danccisides; hessa bollaka eefude geetettiza may7o mayzidi izakka dumma hiillateththan oosettida qabatton oyseththidi danccides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Eefude geetettiza may7ozas tira bolla kiisey sikettidi Urimenne Tumime geetettizayta iza giddon woththides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Iza hu7e bollaka goosse xaaxi woththidi he xaaththa goossa bolla sinththa baggara GODAY Muses yootida mala worqqafe oosettida seeloy geeshshateththas malata gidana mala kallachcha iza bolla woththides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Hessafe guye Musey tiyettiza zayteza ekkidi Gaytoteththa Dunkaanezanne izan diza ubbaa tiydi GODAA oosos dummasides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Zaytezappe guuththara ekkidi yarsho yarshizasoza bolla laappunto wuxxides; qasseka GODAA oosos dummatana mala yarsho yarshizasozanne iza oosos giigettida miishshata kumeththaa bolla hessaththoka izan meecettiza saanezanne saaneza iza bolla woththizayssa bollaka wuxxides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Tiyettiza zayteza Aaroone hu7en gussidi GODAA oosos iza dummasides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Kaaleththidikka Musey GODAY iza azazida mala Aaroone attuma nayta sinth shiishshidi adussa may7o mayzides; xeessan qabatto danccisidi istta hu7en qoobe woththides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Hessafe guye Musey nagara gishshas yarshanaas korma boora ehides; Aarooneynne iza nayti korma booraza bolla ba kushe woththida. ");
INSERT INTO gmvl_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Museykka booraza shukkides; booraa suuththan ba biradhdhe gelththidi yarsho yarshizasozas oyddu baggan diza dhemota tiydi geeshshides; hessafe attida suuththaa yarsho yarshizasoza garsan gussides; hessa malan yarsho yarshizasoza GODAAS shaakki dummasides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Musey shukettida meheza qanththa ashoza bolla diza moodheza ubbaa, tire kammi oykkida moodheza, kilahotanne istta kammi oykkida moodheza ubbaa ekkidi yarsho yarshizasoza bolla xuuggides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Kormaza ashoppe attidayssanne maraceza ekkidi GODAY iza azazida mala asay dizasoppe gede haassidi xuuggides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Hessafe guye Musey xuugettiza yarshos shiiqiza dorsa dharsho ehiin Aarooneynne iza nayti dharshoza hu7e bolla ba kushe woththida. ");
INSERT INTO gmvl_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Museykka dharshaa shukkides; suuththaaka yarsho yarshizasoza bolla yuuyi aadhdhanaas wuxxides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Dharshoza ashaa qommon qommon qanxxidi kessides; hu7eza, qommon qommon qanxxettida ashotanne moodheza xuuggides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","GODAY iza azazida mala Musey qanththa ashotanne tohota haaththan meeccides; he dharshoza asho ubbaa GODAAS taman xuugetti sawiza yarsho ooththidi yarsho yarshizasoza bolla xuuggides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Hessafe kaallidi Musey qeeseteththa sunththas nam7anththo dharshoza ehides; Aarooneynne iza attuma nayti ba kushe dharshaa hu7e bolla woththida. ");
INSERT INTO gmvl_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musey dharshaa shukkides; suuththaafe guuththara ekkidi Aaroones ushachcha hayththa xeera, ushachcha manththa biradhdhenne ushachcha toho manththa biradhdhe tiydes. ");
INSERT INTO gmvl_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Qasseka Aaroone nayta deraa sinth shiishshidi istta ushachcha hayththata xeeranne ushachcha kushe manththa biradhdhetanne ushachcha tohota manththa biradhdheta tiydes; hessafe tirpida suuththaa yarsho yarshizasoza bolla yuuyi aadhdhanaas wuxxides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Handa, goyna, qanththa asho kammi oykkida moodhe ubbaa, tire kammi oykkida moodhe, kilahotakka, kilahota bolla diza moodhezanne ushachcha misseza ekkides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Irshoy bochchontta GODAAS dumma ukeththi izan diza leematezappe issi daabbo ekkides; hessaththoka zayten munuqetti uukettida daabboy izan diza leematezappe issi daabbonne lee7e uketh ekkidi moodheza bollanne ushachcha missaa bolla woththides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","He kaththaa ubbaa ekkidi Aaroone kusheninne iza nayta kushen oyththides; isttika oykkidi yaanne haa qaaseththidi GODAAS yarsho shiishshida. ");
INSERT INTO gmvl_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Hessafe qasse Musey istta kusheppe ekkidi qeeseteththa yarsho gidana mala shiiqidi xuugettiza yarshofe bollara woththidi yarsho yarshizasoza bolla woththidi xuuggides; hessika iza sawoy GODAA ufayssiza kaththa yarsho. ");
INSERT INTO gmvl_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Musey qasseka angasoza ekkidi yaanne haa qaaseththidi GODAAS shiishshides; Musey ubbaaka GODAY iza azazida mala qeeseteththa sunth summanaas shiishshiza dharshofe Muse gishay hessa. ");
INSERT INTO gmvl_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Musey tiyettiza zayteppenne yarsho yarshizasozan diza suuththaafe guuththara ekkidi Aaroone bolla, Aaroone nayta bollanne qasseka istta may7o bolla wuxxides; hessa malan Musey isttanne istta may7o ubbaa GODAAS dummasides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Musey Aaroonenne iza attuma naytas, «Ashoza Gaytoteththa Dunkaane pengen doyssite; Aarooneynne iza nayti maana mala GODAY azazidayssa qeeseteththa sunth summiza wode yarsho izara shiishshiza leematen diza ukeththaara heen miite. ");
INSERT INTO gmvl_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ashozappe woykko ukeththazappe tirpiko taman xuuggite. ");
INSERT INTO gmvl_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Intte qeeseteththa sunth summiza wogay polettanaas laappun gallas ekkiza gishshas he laappun gallassay wurana gakkanaas Gaytoteththa Dunkaaneza pengefe kichchofte. ");
INSERT INTO gmvl_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Inttena nagarappe geeshshanaas hayssa hach nu ooththida wogaa polana mala Xoossay nuna azazides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Hessa gishshas GODAY azazidayssa polanaas laappun gallas kumeth gallassinne omars Gaytoteththa Dunkaaneza pengefe kichchofte; GODAA wogaakka naagite; histtontta aggiko intte hayqqana; tana GODAY azazida wogay hayssa» gides. ");
INSERT INTO gmvl_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aarooneynne iza nayti Muse baggara GODAY azazidayssa ubbaa polida. ");
INSERT INTO gmvl_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Osppunththa gallassan Musey Aaroone, iza attuma naytanne Isra7eele asaa kaaleththiza cimata xeygides; ");
INSERT INTO gmvl_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Aaroonekka, «Issi wosoykka istta bolla baynda issi mirgonne issi dharsho ekkada mirgoza nagara gishshas yarshiza yarsho dharshoza xuugettiza yarsho histta GODAAS yarsha. ");
INSERT INTO gmvl_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Hessafe guye Isra7eele nayta nagara gishshas shiiqiza yarshos deysha orgenne istta bolla aykko wosoy baynda issi layththa mararanne issi layththa dorsa laaqqa xuugettiza yarshos ehana mala yoota. ");
INSERT INTO gmvl_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Qasseka issi kormanne issi dorsa laaqqa issifeteththa yarshos ehetto; heytantta zayten gindettida kaththa yarshora GODAAS yarsho shiishshetto; hessa ubbaa ooththetto; gaasoykka Xoossi isttas hach qonccana» gides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Isttika Musey istta azazidayssa ubbaa Dunkaaneza penge ehida; asay wurikka GODAA sinththan shiiqi eqqides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musey isttas, «GODAA bonchchoy inttes qonccana mala intte ooththanaas GODAY inttena azazida azazoy hayssa» gides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Qasseka Musey Aaroones, «Gede yarshoy yarshettizaso shiiqada ne nagaranne dereza nagara wursanaas shiiqiza yarshonne xuugettiza yarsho yarsha; hessa ubbaa GODAY dereza nagara wursana mala izi nena azazida mala shiishsha» gides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aarooneykka yarsho yarshizaso biidi koyro ba nagaraa gishshas shiiqiza yarshos shiiqiza mirgoza shukkides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Iza nayti suuththaa izas ehida; izikka suuththaan ba biradhdhe gelththi kessidi yarsho yarshizasoza bolla diza dhemota suuth tiydes; attida suuththaa yarsho yarshizaso garsan gussides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Hessafe kaaleththidi moodheza, kilahotanne tire kammi oykkida moodheta ekkidi GODAY Muse azazida mala yarsho yarshizasoza bolla xuuggides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ashozanne galbaza qasse asay dizasoppe gede haraso haassidi xuuggides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Hessafe guye Aarooney xuugettiza yarshos shukkides; histtiin iza nayti suuththaa izas ehida; izikka suuththaza ekkidi yarsho yarshizasoza bolla yuuyi aadhdhanaas wuxxides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Iza nayti xuugettiza yarshos shukettida ashoza qommon qommon hu7ezara gaththi izas ehi immida; izikka hessa ubbaa yarsho yarshizasoza bolla xuuggides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Hessafe qasseka qanththa ashozanne guye tohota haaththan meeccidi yarsho yarshizasoza bolla xuugettiza yarshozara issife gaththi xuugettizason xuuggides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Hessafe kaaleththidi Aarooney dereza nagaraa gishshas shukettiza deysha orge ekki shukkidi ba nagara gishshas yarshidayssaththo yarshides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Xuugettiza yarshoza ehidi kase diza wogaa mala yarshides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Kaththa yarshozakka shiishshides; dhiillezappe kuphpha kumeth ekkidi yarsho yarshizasoza bolla xuuggides; hessika xuugettiza yarshos maalado maalado shiiqiza yarshoza bolla gujettidi shiiqides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Korma booraanne dharshoza shukkidi dereza gishshas issifeteththa yarsho shiishshides; iza naytikka suuththaa izas ehida; izikka suuththaa ekkidi yarsho yarshizasoza yuuyi aadhdhanaas wuxxides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Aarooneykka korma booraa moodheza, dharshaa moodheza, ubbaaka goyna tolthoza, qanththa asho kammi oykkida moodhezanne tire kammi oykkida moodheza doorettidayssa tiretanne istta bolla diza moodheza ekkidi, ");
INSERT INTO gmvl_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","he meheta angaso xeera bolla woththida; Aarooney moodheza ubbaaka yarsho yarshizasoza bolla xuuggides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Angasotanne ushachcha geda ashota Musey azazida mala yaanne haa qaaseththidi GODAAS dumma yarsho histti shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aarooney nagara gishshas shiiqiza yarsho, xuugettiza yarshonne issifeteththa gishshas shiiqiza yarsho yarshidaappe guye ba kushe dhoqqu histtidi deraa anjjidi wodhdhides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Museynne Aarooney Gaytoteththa Dunkaane giddo gelida; heeppe kezishe dereza anjjida; GODAA bonchchoy asa ubbaas qonccides. ");
INSERT INTO gmvl_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Asay qoppontta dishin GODAA achchafe kiitettida tamay yiidi yarsho yarshizasoza bolla diza yarshos shiiqida handaza ubbaa mides; derezikka wuri hessa be7idi ilili gidessinne wurikka hokki goynnides. ");
INSERT INTO gmvl_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadaabeynne Abihu geetettiza Aaroone naa nam7ati issoy issoy baas baas exaane cuwasiza xinna ekkidi bonqo tama izan gujjida; qasseka exaanekka izan gujjidi GODAAS shiishshida; he istti ekkida tamay GODAAS dummatida tama gidontta gishshas istti hessa mala tama shiishshana mala GODAY istta azazibeenna. ");
INSERT INTO gmvl_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Istti qoppontta Xoossa achchafe yida tamay istta mida gishshas istti GODAA sinththan hayqqida. ");
INSERT INTO gmvl_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Musey qasse Aaroones, «GODAY, ‹Ta sinththe shiiqidi taas ooththizaytas tani ta geeshshateththaa qonccisana; tanikka ta dereza achchan bonchchettidaade gidana› giidi izi asaa kase qofsidayssi hayssa» gides. Aarooneykka ay zaarokka immontta co7u gides. ");
INSERT INTO gmvl_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Museykka Aaroones aawaa isha Uzi7eele nayta Misha7eelenne Elxafaane xeygidi, «Haa yiite! Hayssa intte ishata ahaa geeshsha Dunkaaneppe denththidi asi dizasoppe gede haraso efte» gides. ");
INSERT INTO gmvl_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Isttika qeeseteththa may7oza hayqqidayta aha bollafe kessontta dishe biidi Musey azazida mala asata ahaa asay dizasoppe gede haraso efida. ");
INSERT INTO gmvl_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Hessafe kaallidi Musey Aaroones, iza naa El7ezeeressinne Itamaares, «Intte hayqqontta malanne GODAA hanqoy deraa bolla yontta mala hayqqidaytas mishettidi intte hu7e buucofte; intte may7oka daakkofte; gido attiin hankko Isra7eele nayti GODAA achchafe yida taman hayqqidaytas yeekkana dandayeettes. ");
INSERT INTO gmvl_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Intte GODAY azaziin tiyettiza tiyo zayten tiyettida gishshas intte hayqqontta mala Gaytoteththa Dunkaane pengefe kare kezopite» gides. Isttika Musey azazida mala hanida. ");
INSERT INTO gmvl_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","GODAY Aaroones hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Neninne ne nayti woyneppe oosettida ushshu woykko hara maththosiza ushshu uyidi Gaytoteththa Dunkaanezan intte gelontta mala naagettite; histtontta aggiko intte hayqqana; hayssi ha wogazi inttefekka guyen yaana yeleta ubbaa matankka mernaas naagettanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Intte dummatidaytanne dummatonttayta, geeshshinne tuna gididayta giddon diza dummateththaa shaakki eranaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Ta inttes Muse baggara immida woga ubbaa Isra7eele nayta tamaarsite.» ");
INSERT INTO gmvl_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Museykka Aaroonenne attida iza naa nam7ata El7ezeerenne Itamaares, «GODAAS taman xuugetti shiiqida kaththaafe ekkidi irshoy bochchontta uketh uukkite; izikka keehi dummatida yarsho gidida gishshas yarsho yarshizasoza achchan miite. ");
INSERT INTO gmvl_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","GODAAS taman xuugetti shiiqiza kaththa yarshofe shaakettidi inttessinne intte naytas imettida gisha gidida gishshas intte iza GODAAS dummatidason miite; intte hessaththo histtana mala Xoossi tana azazides. ");
INSERT INTO gmvl_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Gido attiin yaanne haa qaaseththon dumma yarsho gididi GODAAS shiiqidaappe guye qeeseta gisha gidana mala geetettida gishshas angasozanne misseza neninne ne keeththan diza ne macca nayti maandeta; hessa he wogaakka GODAAS dummatidason maandeta; hessika Isra7eele asay issifeteththaa gishshas shiishshiza yarsho ubbaafe shaaketti neessinne ne naytas imettides. ");
INSERT INTO gmvl_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Shiiqida missezanne angasoza GODAA sinththan yaanne haa qaaseththi shiishshiza yarshoza mala qaaseththanaas ehetto; hessika GODAY azazida mala mernaas neessinne ne naytas gisha gido» gides. ");
INSERT INTO gmvl_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Musey nagara gishshas shiiqida yarshos shiiqida deyshaa oychchi siyidi izi xuugettidayssa erides; hessa gishshas Musey El7ezeere bollanne Itamaare bolla hanqettidi, ");
INSERT INTO gmvl_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«Intte nagaraa gishshas shiiqida yarshoza Xoossas dummatidason aazas mibeekketii? Yarshozi GODAAS keehi dumma; izi derezappe nagaranne qoho wursana mala GODAY hessa inttes immidaaza. ");
INSERT INTO gmvl_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Suuththazi gede GODAAS dummatida dunkaanezan gelontta gishshassinne ta inttena azazida mala intte he dummatidason shiiqida yarshoza intte maanaas bessees» gides. ");
INSERT INTO gmvl_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aarooneykka Muses, «Nagara gishshas shiiqiza xuugettiza yarsho hekko hach asay Xoossa sinth ekki yides; tanakka hayssa mala metoy gakkides; histtiin hach nagara gishshas shiiqiza yarshoza ta midaakko GODAY ufayettanashin attidee?» gides; ");
INSERT INTO gmvl_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Museykka hessa siyidi izi zaarida qaalan ufayettides. ");
INSERT INTO gmvl_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","GODAY Musessinne Aaroones hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«Hayssa Isra7eele naytas yootite, ‹Biitta bolla diza do7atappenne mehetappe intte maanayti hayssafe kaalli dizayta, ");
INSERT INTO gmvl_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Toho qinccifilley phalqeththatanne banchikizayta miite. ");
INSERT INTO gmvl_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","« ‹Gido attiin banchikizayta gidi uttidi qinccifilley phalqettonttayta woykko banchikonttayta gidi uttidi qinccifilley phalqettidayta moopite; gaamellay banchikees shin qinccifilley phalqettontta gishshas izi inttes tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Guppaley banchikees shin qinccifilley phalqettontta gishshas izi inttes tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Harbaynoy banchikeessishin qinccifilley phalqettontta gishshas izi inttes tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Guddunththika moopite; iza qinccifilley phalqeth gidikkoka izi banchikontta gishshas inttes tuna gidi qoodetto. ");
INSERT INTO gmvl_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Heytantti tuna gidida gishshas istta asho moopite; haray attoshin istta ahakka bochchofte. ");
INSERT INTO gmvl_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","« ‹Abba giddoninne shaafa haaththata giddon diza medheteththata abba giddofe qefeynne poqo mala galbay diza ubbaa miite. ");
INSERT INTO gmvl_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Abba giddoninne shaafa haaththa giddon diza medheteththatappenne shemppora paxa diza hara medheteththata ubbaa giddofe qefeynne poqettiza galbay baynda ubbay inttes tuna gidida gishshas moopite. ");
INSERT INTO gmvl_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Heytantti tuna gidida gishshas istta asho moopite; haray attoshin istta ahakka bochchofte. ");
INSERT INTO gmvl_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Hessa gishshas haaththa giddon diza qefeynne poqettiza galbay istta bolla baynda medheteththati wurikka intte achchan ixettidayta gidetto. ");
INSERT INTO gmvl_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","« ‹Kafotappe hayssafe kaallizayti tuna gidida gishshas moopite. Heytanttika golle, qoollo, wole ");
INSERT INTO gmvl_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","Xilo, dumma dumma qommo phircota. ");
INSERT INTO gmvl_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","Dumma dumma quurota ");
INSERT INTO gmvl_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Yanchcha, cancce gutto, haaththa kafo, gace zare ubbaa, ");
INSERT INTO gmvl_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Gutto, biya, yindare ");
INSERT INTO gmvl_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","woyno, haaththa kafo, ankko, ");
INSERT INTO gmvl_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","zigile, saabissa geetettiza haaththa kafo zare ubbaa, jinjilaate geetettiza kafonne wurkawurkko. ");
INSERT INTO gmvl_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","« ‹Qefey dishin oyddu tohora qaaxxiza medheteththati wurikka tunata; ");
INSERT INTO gmvl_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Heytantta giddofe guppanaas maaddiza geday diza medheteththata miite; ");
INSERT INTO gmvl_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Heytikka boole zareta, xingota zaretanne gumbaro zare ubbaa. ");
INSERT INTO gmvl_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Hinko qefey dishin oyddu tohora hemettiza medheteththata intte tuna mala qoodite. ");
INSERT INTO gmvl_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","« ‹Hayssafe kaalli dizayta bochchidaadey wuri omars gakkanaas tuna gidana. ");
INSERT INTO gmvl_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","« ‹Heytantta aha denththidaadey wurikka ba may7o haaththan meecco; meeccikokka omars gakkanaas izaadey tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","« ‹Qinccifilley isttas dishin phalqettonttaytinne banchikontta mehey wurikka inttes tuna gidana; heytantta bochchidaadey wurikka tunees. ");
INSERT INTO gmvl_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Oyddu tohora dizaytappe qinccifilley baynda kanten hemettizayti wurikka intte achchan tunata gidetto; istta ahaa bochchidaadey omars gakkanaas tuna gido; ");
INSERT INTO gmvl_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Heytantta aha denththidaadey wurikka ba may7o haaththan meecco; meeccikokka omars gakkanaas izaadey tuna gido; isttika intte achchan tuna. ");
INSERT INTO gmvl_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","« ‹Biittara gooshettizayta giddofe hayssafe kaallizayti inttes tuna gidetto; giroy, ecerey, zarey, korchchey, haylashoy, geeggey, wakkalaynne, shaaqanchchay inttes tuna gidetto. ");
INSERT INTO gmvl_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Biittara gooshettiza ubbatappe tuna gididayti haytantta; istta gidiin woykko istta aha bochchizaadey wuri omars gakkanaas tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Istta ahay iza bolla wodhdhida miishshi wurikka tunees; hessika miththafe oosettida miishshati, may7oti, galba, karaxiite, ogoronne heytantta misatiza haratakka gujjees; istta aha bochchida miishshi wurikka haaththan gelidi gam7o; omars gakkanaas tuna gididi hessafe guye geesh gido. ");
INSERT INTO gmvl_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Heytantta ahay mana miishshaa giddon gelikko he miishshaa giddon diza miishshi wurikka tuniza gishshas he mana miishshaza wodhite. ");
INSERT INTO gmvl_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","He mana miishshaafe haaththi iza bolla xokettida kaththi wurikka tuna gidees; izan diza uyettiza miishshika tuna gidees. ");
INSERT INTO gmvl_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ay ahaykka bochchida miishshi wurikka tuna gidida gishshas iza ixxite; mani medhdhida cooce gidiin otoy meqqo. ");
INSERT INTO gmvl_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Heytantta ahay hara ubbaa tunisizaaz gidikkoka pultto haaththenne haaththi diza olla tunisenna. ");
INSERT INTO gmvl_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Zereththas uttida kaththa bolla wodhdhiko zereththay tunenna. ");
INSERT INTO gmvl_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Gidikkoka zereththa bolla haaththi gukki simmiin ahay bochchiko he zereththay hessafe guye tuna gidees. ");
INSERT INTO gmvl_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","« ‹Meetettiza mehe garsafe awaysikka hayqqiin he hayqeththaa bochchidaadey omars gakkanaas tuna. ");
INSERT INTO gmvl_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Ay asikka he hayqeththaafe miikko ba may7o meecco; omars gakkanaas tuna gido; ay asikka he hayqeththa ahaa tookkiko ba may7o meecco; gidikkoka omars gakkanaas izaadey tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","« ‹Biittara gooshettiza ay medheteththati wurikka intte achchan meetettonttaazinne ixettidaaz gidetto. ");
INSERT INTO gmvl_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Tiran gooshettiza, oyddu tohora bizayta, woykko daro tohoy dizayta ubbaaka moopite; istti intte matankka ixettidayta gidetto. ");
INSERT INTO gmvl_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Heytanttafe awayssaka miidi inttena tunisopite. ");
INSERT INTO gmvl_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Tani GODAA intte Xoossaa; tani harappe dumma gidida gishshas intteka dumma gidite; ba tiran gooshettizayta miidi intterkka inttena tunisopite. ");
INSERT INTO gmvl_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Inttes GODAA gidanaas Gibxeppe inttena kaaleththa kessiday intte Xoossay tana; hessa gishshas tani dumma gidida mala intteka dumma gidite. ");
INSERT INTO gmvl_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","« ‹Meheta, do7ata, kafota, haaththa giddoninne biitta bolla tiran gooshettiza medheteththata ubbaa gishshas imettida wogay hayssa; ");
INSERT INTO gmvl_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Wodhdhida wogaa mala geeshshatanne geesh gidonttayta giddon diza dummateth shaakki eranaas hessika meetettizaytanne meetettonttayta giddon diza dummateththaa shaakki eranaas intte lo7eththi naagettite.› » ");
INSERT INTO gmvl_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«Isra7eele asaas, ‹Maccassi shaarada attuma naa yelikko kase maccassa wogay izi bolla beettida wode hanizayssaththo laappun gallas gakkanaas iza tuna gidawus. ");
INSERT INTO gmvl_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Yelettida naazi osppunththa gallas qaxxarettanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Hessafe guye gacino suuththay izippe eqqana gakkanaassinne iza yeloosofe 33 gallas gakkanaas Xoossas dummatida ay miishshika bochchanaas bessenna; hessika iza geeyza wodey wurontta dishin Gaytoteththa Dunkaane giddo geluppu. ");
INSERT INTO gmvl_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","« ‹Hessaththoka issi maccassi macca naa yelikko kase bolla qitay izi bolla beettida wode hanizayssatho 14 gallas gakkanaas tuna gidawus; hessafe guye suuththay izippe simmiin iza yeloosofe 66 gallas gakkanaas gam7u. ");
INSERT INTO gmvl_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","« ‹Iza geeyza gallassati wuriza wode attuma naa gishshas gidiin woykko macca naa gishshas xuugettiza yarshos issi layththa laaqqanne nagarappe geeyanaas shiiqiza yarshos haraphphe woykko haraphphe ciye Gaytoteththa Dunkaane penge ehada heen ooththiza qeeses immu. ");
INSERT INTO gmvl_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Qeesezikka iza immizayssa izippe ekkidi GODAAS yarsho shiishsho; maccassayakka iza yelishin izippe gukkida suuththaafe geeyawus; hayssi attuma naa woykko macca naa yeliza maccassas wodhdhida woga. ");
INSERT INTO gmvl_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Yelida maccassaya dorsa laaqqa ehanaas dandayonttaaro gidikko nam7u haraphpheta woykko nam7u waanoseta ehu; nam7atappe issoy xuugettiza yarshos, hankkoyssi nagara geeshos yarsho shiiqo; qeesezikka izo nagarappe geeshsho; hessafe guye iza geesh gidana› gees.» ");
INSERT INTO gmvl_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","GODAY Musessinne Aaroones hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«Ay asikka izaade bolla kixay woykko shimpey woykko illiway izaade bolla beettidi qaachcha harge mala kaseppe gede dari dari biikko izaade gede qeese Aaroonekko woykko qeese gidida iza naytappe issaakko efetto. ");
INSERT INTO gmvl_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Qeesezikka he madunththaa lo7eththi xeello; he madunththaa heeran diza iskey booxxizaaz gidikkonne madunththazi duge ollati beettiko hessi daro iita hara asa bolla aadhdhiza galba harge; qeesezi kase wogaa mala izaadey tuna gididayssa asaas eriso. ");
INSERT INTO gmvl_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Gido attiin madunththazi booxxidi duge ollatontta aggikonne iza heeran diza iskezikka booxxontta aggiko qeesezi hessaade laappun gallas gakkanaas soon kare ba bolla gordi barkka gam7ana mala ooththo. ");
INSERT INTO gmvl_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Laappunththo gallas qeesezi iza qasseka paacci xeello; izi iza paaccishin madunththay kaseppe aykkoka dummateth bessontta aggiko ha7ikka hara laappun gallas izi ba keeththan kare ba bolla gordi uttana mala ooththo. ");
INSERT INTO gmvl_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Laappun gallassafe guye qeesezi iza qasseka paacci xeello; izi paacci xeellishin madunththay gede dich aggidi kaseppe guuxxi beettiko he madunththay deexo gidonttayssa izas yootidi wogaan dizayssa mala izi geesh gididayssa iza eriso; izaadeyka wogay giza mala geeyanaas ba may7oza haaththan meecco. ");
INSERT INTO gmvl_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Hessika qeesezi izi geesh gididayssa paaccidi izaades erisidaappe guye qasseka madunththay kaseppe aakki aakki biikko hessaadey qasseka qeesezakko shiiqo. ");
INSERT INTO gmvl_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Qeesezi qasseka paacco; madunththay kaseppe aakkiko iita galba harge gidida gishshas wogan diza mala izaadey iita galba harganchcha gididayssa eriso. ");
INSERT INTO gmvl_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«Oonikka izaade ashoza galba bolla keziza hargey oykkiko hessaade qeesekko ehetto. ");
INSERT INTO gmvl_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Qeesezikka he izaade bollay uzazizaakko lo7eththi xeellidi izaade asateththa bolla diza isketa booththiza kixa gidikko kixazi uzazidinne he uzassay dizason dizaa gidikko, ");
INSERT INTO gmvl_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","hessi iita bolla galba harge gidiza gishshas qeesey he harganchchazi tuna gididayssa izas yooto; izi tunidayssi erettida gishshas hessa mala asi karey gordettiin keeththan gam7anaas bessenna. ");
INSERT INTO gmvl_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","He galba hargezi izaade bolla toho xugunththafe biidi hu7e iske gakkanaas ubbaa gakkiko, ");
INSERT INTO gmvl_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","qeesezi qasseka paacci xeellidi hargezi izaades kumeththa asateththaa gakki may7idaa gidikko qeesezi hessaade woga mala geesh gididayssa eriso; gaasoykka iza bollay kumeth laamettidi booth gidida gishshas izaadey geeshsha. ");
INSERT INTO gmvl_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Gido attiin madunththay zaari uzazidi zo7o asho giddofe bessiko hessaadey tuna gidees. ");
INSERT INTO gmvl_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Qeesey qasseka zaari paacci xeellishin madunththay uzazishin zo7o asho beykko izaadey tuna; izi tuna gididayssa izas eriso; gaasoykka hargezi hara asa bolla aadhdhiza harge gidida gishshas hessaadey tuna. ");
INSERT INTO gmvl_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Madunththay paxidi boottizaaz gidikko hessaadey qasseka qeesekko bo. ");
INSERT INTO gmvl_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Qeeseykka paacci xeellidi madunththay booxxi bessiko qeeseykka hessaadey geesh gididayssa izas yooto; izaadeyka geesh gidana. ");
INSERT INTO gmvl_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","«Issaadey kase kixay iza bolla kezidi paxikko, ");
INSERT INTO gmvl_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","qasse gam7ishe kase madunththay dizason booththa kixay woykko zo7o illiway keziko izaadey qeesekko bo. ");
INSERT INTO gmvl_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Qeesezi lo7eththi xeellidi madunththay duge asho giddo geli beettiko iza heeran diza iskey booxxi bessiko hessaadey tuna gididayssa iza eriso; gaasoykka hessi kixa oykkidayssi ba baggara iita galba harge. ");
INSERT INTO gmvl_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Gidikkoka qeesezi paacci xeelliin galba bolla diza iskey boottontta aggikonne hankko asateththaa galbaafe ollati bessonttaaz gidikko qalame dummateththa gishshas qeesey hessaadey laappun gallas gakkanaas karey gordettiin keeththan gam7ana mala ooththo. ");
INSERT INTO gmvl_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Madunththay dizasoy kaseppe aakki aakki biikko hessaadey asa bolla aadhdhiza iita hargen oykettida gishshas izi tuna gididayssa izas qeesezi yooto. ");
INSERT INTO gmvl_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Gido attiin illiwazi kaseppe aakki aakki bontta aggidi kase ba dizason diikko kase kixay paxidaso attiin harge deenna; qeesezi izi geesh gididayssa eriso. ");
INSERT INTO gmvl_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Kase iza tamay midaadey diikko he izi taman meetettidasoy booththa illiwa woykko zo7anaadan hani bessiko, ");
INSERT INTO gmvl_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","Qeesezi iza paacci xeello; he illiway dizason mokkida iskey booth gidikkonne hankko iza achchan diza galbaafe duge ashon gelikko hessi taman xuugeteththa gaason asappe asan aadhdhiza iita galba harge; hessa gishshas qeesey hessaadey tunidayssa izas eriso. ");
INSERT INTO gmvl_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Iza bolla mokkida iskezi booththa isken laamettontta aggikonne madunththazi duge ashon gelontta aggidi shoolloti shoolloti biikko qeesezi lo7eththi be7idi laappun gallas gakkanaas kare iza bolla gordi woththo. ");
INSERT INTO gmvl_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Qasseka laappunththa gallas paacci xeello; izi kaseppe aakki aakki biikko hessi iita galba harge; hessa gishshas hessaadey tuna gididayssa qeesezi iza eriso. ");
INSERT INTO gmvl_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Madunththay dizasoy qasse kaseppe aykkoka aakkontta aggikonne paxi paxi biikko izi tamay midaso attiin hara gidenna; hessa gishshas hessaadey wogaa mala geesh gididayssa qeesey iza eriso. ");
INSERT INTO gmvl_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«Adde gidiin maccas gidiin hu7e bolla woykko shagala bolla madunththi diikko, ");
INSERT INTO gmvl_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","qeesezi he madunththaa paacci xeellishin madunththay duge ashon gelikko iza bolla diza iskey galal7o mala gididi lee7i bessiko hessi hu7e woykko buuchcha qaacisi goo7issiza daro iita galba harge gidida gishshas hessaadey tuna gididayssa qeesezi iza eriso. ");
INSERT INTO gmvl_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Qasseka qeesey paacci xeellishin madunththay hankko iza achchan diza galbaafe duge ollati bessontta aggiko, iza bolla diza iskey lo7o gidontta aggiko hessaade laappun gallas gakkanaas kare gordidi keeththan woththo. ");
INSERT INTO gmvl_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Laappunththo gallas qasseka qeesezi izaade paacci xeello; kaseppe aakki aakki bontta aggiko qooruma misatiza iskeyka baynda aggikonne madunththazi duge ashon gelontta aggiko, ");
INSERT INTO gmvl_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","Hessaadey madunththaa yuuyi aadhdhi diza iskeza ubbaa meedetto; qeeseykka iza qasseka laappun gallas gakkanaas karey iza bolla gordettiin gam7ana mala ooththo. ");
INSERT INTO gmvl_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Laappunththo gallas qeesezi qasseka he madunththaa paacci xeello; madunththay kaseppe aakki aakki bontta aggikonne asho mi ollasontta aggiko hessaadey diza wogaa mala gididayssa iza eriso; izaadeyka ba may7o meeccidi geesh gido. ");
INSERT INTO gmvl_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Gido attiin izi geesh gididayssa qonccisidaappe guye madunththay kaseppe aakki aakki biikko, ");
INSERT INTO gmvl_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","qeesezi qasseka paacci xeello; madunththay addaka kaseppe aakkidaa gidikko iskey qoorumikko woykko qoorumontta aggikokka izaadey tuna. ");
INSERT INTO gmvl_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Gido attiin qeesezi beyishin madunththay kaseppe aakki aakki bontta aggikonne lo7o iskey mokkiko madunththay paxidayssanne izaadey geeyidayssa qeesezi iza eriso. ");
INSERT INTO gmvl_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«Maccas gidiin woykko adde gidiin issaade bolla illiway kezikko, ");
INSERT INTO gmvl_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","qeesezi he illiway dizaadeza paacci xeello; illiway dizasoy coo mela puqqa booth gidontta aggiko iza daro qohontta coo mela bollara galba bolla kezida shimpe gidida gishshas hessaadey diza wogaa mala izi geeshsha. ");
INSERT INTO gmvl_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","«Issaades hu7e iskey guye baggara woykko sinththa baggara bo7atikko hessaade bo7ay iza tunisenna. ");
INSERT INTO gmvl_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Gido attiin iza bo7aa bolla woykko liiphe bolla zo7i bessiza booththa madunththi beettiko hessi iita hara asa bolla aadhdhiza galba harge. ");
INSERT INTO gmvl_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Qeesezi hessaade paacci xeellishin hessi hara asa bolla aadhdhiza galba harge misatidi zo7i bessiza booththa madunth gidikko, ");
INSERT INTO gmvl_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Hessaadey hara asa bolla aadhdhiza iita hargen oykettida gishshas izaadey tuna gididayssa qeesezi izaade eriso. ");
INSERT INTO gmvl_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Hessa mala hargey iza bolla dizaadey daakeththa may7o may7o; ba hu7ekka pixoppo; ba doona kammidi, ‹Tani tunakko! Tani tunakko!› gishe waasso. ");
INSERT INTO gmvl_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","He hargezi iza bolla diza wode ubbaan izi tuna; hessa gishshas izi asi dizasoppe gede haraso haakkidi barkka de7o. ");
INSERT INTO gmvl_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","48","«Asa bolla harge gaththiza buuqay dorsa iskefe oosettida may7o bolla woykko ay qommo may7o bollaka harpan dadettida may7o bolla woykko kushen oosettida galba may7o woykko galbafe oosettida may7o bolla beettiko, ");
INSERT INTO gmvl_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","he hargezas malay maata mala cilili bessiko woykko zo7i bessiko hessi issaafe issaan aadhdhiza harge gidida gishshas qeesezi iza beyo. ");
INSERT INTO gmvl_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Qeesezi he hargeza lo7eththi xeellidi he may7ota ubbaaka laappun gallas gakkanaas issi keeththan gelththi dumma woththo. ");
INSERT INTO gmvl_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Laappunththo gallas qasseka paacci xeellishin asa bolla harge gaththiza buuqazi kaseyssafe dari beettiko hessa mala may7ozi tuna. ");
INSERT INTO gmvl_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Hessa mala may7o buuqay asa bolla harge gaththiza gishshas qeesezi shiishshidi he buuqa may7ota taman xuuggo. ");
INSERT INTO gmvl_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","54","«Qeesezi zaari paacci xeellishin buuqazi kaseppe ha darontta aggiko may7oza haaththan meeccana mala azazo; he meecettida may7oza laappun gallas gakkanaas shaakki woththo. ");
INSERT INTO gmvl_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Hessafe qasseka xeellishin kaseppe buuqay gujettontta aggikonne buuqaza medhay kaseppe laamettontta aggiko ha7ikka izi tuna; kaseyssa bolla giddora, karera buuqazi gujettiko he may7ozi taman xuugetto. ");
INSERT INTO gmvl_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Gido attiin may7oza meecci simmidaappe qeesezi qasseka zaari be7iza wode buuqazi kaseppe duge guuxxiko buuqazi dizasoyo xalla iita may7ofe gidiin woykko afala gidiin daakki kesso. ");
INSERT INTO gmvl_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Buuqazi qasseka beettiko hessi gede dari dari biza gishshas he may7ozi xuugetto. ");
INSERT INTO gmvl_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ay may7onne galbafe oosettida ay miish meeccishin buuqazi izappe dhaykko qasseka meecco; hessafe guye wogay giza mala may7ozi geesh gidana.» ");
INSERT INTO gmvl_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Hayssi dorsa iskefe oosettida may7o bolla woykko ay qommo may7o bolla woykko harpan dadettida woykko kushen oosettida may7o bolla, galba woykko galbafe oosettida may7o bolla asa bolla harge gaththiza buuqay beettiko he may7ozi geesh woykko tuna gididayssa erisiza wogay hayssafe bollan dizayssa. ");
INSERT INTO gmvl_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«Issaadey asateththa bolla diza iita galba hargefe paxidaappe guye geesho wogay hayssafe kaallizayssa; izi geesh gididayssa izaades yootettiza gallas hessaadey qeesekko baana mala izas yootetto. ");
INSERT INTO gmvl_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","He izas yootettida qeesezi asi dizasoppe gede haraso kessidi baakko yidayssa lo7eththi xeello; izaadey hargezappe paxidaa gidikko, ");
INSERT INTO gmvl_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","qeesezi paxa diza nam7u geeshsha kafotanne ziga mith, zo7o xilata, hisophphe miththa hayth gujji ekki yaana mala azazo. ");
INSERT INTO gmvl_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Hessafe guye qeesezi kafotappe issaa pultto haaththi izan diza guuqa kere bolla shukettana mala azazo. ");
INSERT INTO gmvl_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Hankko paxa diza kafoza efidi ziga miththara, zo7o xilataranne hisophphe miththa bonccora issife gaththi kase shukettida kafoza suuththan gelththi kesso. ");
INSERT INTO gmvl_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Suuththaaka asateththa bolla diza galba hargefe paxizaade bolla laappunto wuxxo; hessafe guye izi geesh gididayssa iza eriso; hankko paxa diza kafozakka gede haraso kessidi demban piradhdhana mala yeddo. ");
INSERT INTO gmvl_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","«Iita galba hargefe paxidaadey ba may7o meecco; ba bolla diza iske ubbaa meedetto; ba bollaka meecetto; wogay giza mala izi geesh gidana; hessafe guye asi dizaso gelanaas dandayees; gido attiin laappun gallas gakkanaas izi ba dunkaanaappe karen de7o. ");
INSERT INTO gmvl_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Laappunththo gallas qasseka ba hu7e, ba buuchchinne ba deemo, hara awanka ba asateththa bolla diza iske ubbaa meedetto; ba may7o haaththan meecconne ba bollaka meecetto; hessafe guye izi geesh gidana. ");
INSERT INTO gmvl_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","«Osppunththa gallas issi wosoykka istta bolla baynda nam7u dorsa laaqqatanne issi layththa uzzo eho; kaththa yarsho gishshas wogara miththa zayten munuqettida heedzdzu kilo dhiillenne issi litiro zaytes heedzdzanththo kushe wogara miththa zayte eho. ");
INSERT INTO gmvl_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Qeesezikka addezi izi ehida ubbaara issi bolla Gaytoteththa Dunkaaneza pengen GODAA sinth shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","«Hessafe guye nam7u qeeri dharshotappe issaa ekkidi issi litiros heedzdzanththo kushe gidiza wogara zaytera issife gaththi ekkidi qoho gishshas shiiqiza yarsho histti shiishsho; qeesezi he yarshozakka yaanne haa qaaseththiza yarsho histti GODAA sinththan qaaseththi shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Laaqqazakka nagara yarshossinne xuugettiza yarshos shukkiza geeshshasohon shukko; gaasoykka qoho gishshas yarshoy nagara wursanaas shiiqiza yarsho mala qeesezas gisha gidana; izikka keehi dumma. ");
INSERT INTO gmvl_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Qeesezi qoho yarshos shiiqiza suuththafe guuththara ekkidi he geeyzaades ushachcha hayththa xeera izas ushachcha kushe manththa biradhdhenne ushachcha toho manththa biradhdhe tiyo. ");
INSERT INTO gmvl_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Qeesezi wogara miththa zaytezappe guuththara ekkidi ba hadirsa kushe qaa7an tigo. ");
INSERT INTO gmvl_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Ba ushachcha kushe xeeran guuththara ekkidi Xoossa sinththan laappunto wuxxo. ");
INSERT INTO gmvl_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ba kushe qaa7an attida zaytezappe guuththara ekkidi geeyzaades ushachcha hayththa xeera, ushachcha kushe manththa biradhdhenne ushachcha toho manththa biradhdhe tiyo. ");
INSERT INTO gmvl_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ba kushe qaa7an attida zaytezakka geeyzaade hu7en gusso; qeesey izaade nagara geeshsho. ");
INSERT INTO gmvl_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","«Hessafe guye qeesezi ba tunateththafe geeyzaade nagara wursanaas shiiqida mehe shukko. ");
INSERT INTO gmvl_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Qasseka qeesezi he xuugettiza yarshoza kaththa yarshozara issife yarsho yarshizasoza bolla woththidi xuuggo; hessa mala ooson izaade nagarappe maarisees; izaadeyka geesh gidees. ");
INSERT INTO gmvl_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«Izaadey hessa ubbaa ehanaas dandayontta manqo gidikko Godaa sinththan yaanne haa qaaseththidi ba nagara wursanaas issi dharsho laaqqa ehidi qoho yarsho gishshas shiishsho; qasse kaththa yarshozaska wogara miththa zayten munuqettida issi kilo liiqo dhiille kaththa yarshos eho; hessaththoka issi litiros heedzdzanththo kushe gidiza zayte eho. ");
INSERT INTO gmvl_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Qasseka iza wolqqay dandayda mala nam7u haraphpheta woykko nam7u waanosetappe issaa nagara gishshas yarshos, nam7anththoza qasse xuugettiza yarshos eho. ");
INSERT INTO gmvl_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","«Geesho wogay polettiza osppunththa gallas heyta ubbaa ehidi Gaytoteththa Dunkaane pengen GODAA sinththan qeeses immo. ");
INSERT INTO gmvl_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Qeesezikka qoho yarshos shiiqiza dorsa laaqqanne wogara miththa zayteza ekkidi yaanne haa qaaseththiza yarsho ooththi GODAA sinththan yarsho. ");
INSERT INTO gmvl_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Qoho gishshas shiiqiza yarshos shiiqida dorsa laaqqa shukko; suuththaafe guuththara ekkidi geeyzaades ushachcha kushe manththa biradhdhe, ushachcha toho manththa biradhdhenne ushachcha hayththa xeera tiyo. ");
INSERT INTO gmvl_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Qeesezi zaytezappe guuththara ba hadirsa kushe qaa7an tigo. ");
INSERT INTO gmvl_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Ba ushachcha kushe biradhdhen guuththara bochchidi Xoossa sinththan laappunto wuxxo. ");
INSERT INTO gmvl_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ba kushe qaa7an tigida zayteppe guuththara ekkidi qoho yarsho suuththan bochchidaason hessika geeyzaades ushachcha hayththa xeera, ushachcha kushe manththa biradhdhe xeera, ushachcha toho manththa biradhdhe xeera boshiso. ");
INSERT INTO gmvl_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Qeesezi ba kushen attida zayteza addeza hu7en gusso; hessaththo ooththidi geesho woga GODAA sinththan polo. ");
INSERT INTO gmvl_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Hessafe guye haraphpheta woykko waanoseta geeyzaade wolqqay gaththida keena qeesezi yarsho. ");
INSERT INTO gmvl_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Heytanttafe issaa nagaras shiiqiza yarshos nam7anththoza qasse xuugettiza yarshos kaththa yarshora gaththi shiishsho; qeesezi ubbaaka hayssa malan geeyzaade nagarappe geeshsho. ");
INSERT INTO gmvl_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Asappe gede hara asan aadhdhiza iita galba hargefe geeyanaas koshshiza woga polanaas dandayontta manqo asas diza wogay hayssa» gides. ");
INSERT INTO gmvl_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","GODAY Musessinne Aaroones hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«Tani inttes immiza Kanaane biitta intte geliza wode issi keeththan tani buuqa yeggiko, ");
INSERT INTO gmvl_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","he keeththaadey biidi qeeseza, ‹Tason ay iita hargey dizaakko› giidi yooto. ");
INSERT INTO gmvl_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Soon diza miish ubbay tuna geetettontta mala qeesezi he iita hargaa beyanaas gelanaappe kasetidi soon diza miish ubbaa kare kessana mala azazo; hessafe guye qeesezi xeellanaas keeththaa giddo gelo. ");
INSERT INTO gmvl_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Hargeza lo7eththi paacci xeelliza wode keeththaa lukki lukki miza hargezas medhay maata mala cilila woykko zo7o woykko puncarka misati beettiko, ");
INSERT INTO gmvl_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","qeesezi he keeththaafe kezidi keeththay laappun gallas gakkanaas gordettana mala ooththo. ");
INSERT INTO gmvl_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Qeesezi laappunththa gallas simmidi qasseka xeello; hargezi kaseppe gede dari dari biikko, ");
INSERT INTO gmvl_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","hargey istta bolla beettida shuchchati keeththaafe woocetti kezidi katamappe gede karen diza tuna miish yegettizason yegettana mala azazo. ");
INSERT INTO gmvl_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Hessafe guye keeththaas soo bagga giiridi he giireththaza katamappe kare baggara tuna miish yeggizason yeggana mala azazo. ");
INSERT INTO gmvl_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Hessafe guye kase shuchchata sohon hara ooraththa shuchchi geliin he keeththan hara ooraththa urqqay meeshetto. ");
INSERT INTO gmvl_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","«Shuchchati digettiin qasseka urqqaaka qoqofidi hara urqqan meeshi ooraththidaappe guye he hargeza malatay qasseka simmi beettiko, ");
INSERT INTO gmvl_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","qeesezi simmi biidi beyo; hargezi kaseppe gede aakki aakki biza mala gidikko he hargey issaafe issaan aadhdhiza iita harge gidida gishshas he keeththay tuna. ");
INSERT INTO gmvl_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Hessa gishshas he keeththay laalettanaas bessees; he keeththaa shuchchay, miththaynne miishshi, urqqay wurikka katamappe gede kare tuna miishshi yegettizason yegetto. ");
INSERT INTO gmvl_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Gordettidaappe guye he keeththan gelida asi wurikka omars gakkanaas tuna gidees. ");
INSERT INTO gmvl_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","He keeththan ichchidaadey woykko kath midaadey ba may7o meecco. ");
INSERT INTO gmvl_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","«Keeththay qasseka ooraxidi meeshettidaappe guye qeesezi yiidi xeellishin hargezi kaseppe aakki aakki bontta aggiko, hargeza malatay dhayda gishshas, he keeththay geesh gidida gishshas qeesezi keeththa aawaa eriso. ");
INSERT INTO gmvl_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","He keeththaa geeshshanaas nam7u kafo, Libaanoose ziga, zo7o xilatanne hisophphe geetettiza miththa hayth eho. ");
INSERT INTO gmvl_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Kafotappe issaa pultto haaththi izan diza guuqa keren shukko; ");
INSERT INTO gmvl_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","hessafe guye ziga mith, hisophphe miththa hayth, zo7o xilatanne paxa diza kafoza issife gaththi ekkidi guuqa keren diza pultto haaththaninne hankko shukettida kafoza suuththan gelththi kessidi keeththaza laappunto araco. ");
INSERT INTO gmvl_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Qeesezi hessaththo histtidi he keeththaa kafoza suuththan, pultto haaththan, paxa diza kafon, ziga miththan, hisophphe miththa hayththaninne zo7o xilatan geeshsho. ");
INSERT INTO gmvl_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Hessafe guye paxa diza kafoza izi piradhdhi baana mala gede demba kessi yeddo; hessaththo ooththidi keeththaa geeshshiza wogaa polikko keeththayka geesh gidees.» ");
INSERT INTO gmvl_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Hayssi ha wogazi issaafe issaan aadhdhiza galba bolla keziza ay harges, qaachcha harges, ");
INSERT INTO gmvl_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","may7o bollanne keeththa bolla issaafe issaan aadhdhi aadhdhi yiza harges, ");
INSERT INTO gmvl_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","kixa harges, badhinttessinne illiwa harges, ");
INSERT INTO gmvl_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","hayssi ay miishshika tuna woykko geesh gididayssa shaakki erisanaassinne issaafe issaan aadhdhiza iita harge woykko buuqa geeshshanaas diza woga. ");
INSERT INTO gmvl_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","GODAY Musessinne Aaroones hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«Ay asaska izaade asateththafe goggiza miishshi diikko hessaadey tuna gaada Isra7eele asaas yoota. ");
INSERT INTO gmvl_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Asateththafe goggi kezizayssi aggontta ixxiko woykko gogeththaa aggikokka hessaadey tuna. ");
INSERT INTO gmvl_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","«Hessaadey iza bolla ichchida hiiththi, uttida ay miishshika tuna gidees. ");
INSERT INTO gmvl_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Hiixaza bochchida ay asikka ba may7onne ba bolla haaththan meecco; gidikkoka hessaadey omars gakkanaas tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Asateththafe tunisiza miishshi goggi keziza asi uttidasohon uttida ay asikka ba may7onne ba bolla haaththan meecco; gidikkoka hessaadey omars gakkanaas tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","«Asateththafe tunisiza miishshi goggi keziza as bochchiday ay asikka ba may7onne ba bolla haaththan meecco; gidikkoka omars gakkanaas tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","«Asateththafe tunisiza miishshi goggi keziza asi hankko paxa diza asa bolla cuch cuttiko he cuchchay iza bochchida asi ba may7onne ba bolla haaththan meecco; gidikkoka hessaadey omars gakkanaas tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","«Asateththafe tunisiza miishshi goggi keziza asi uttida koora ubbay tuna; ");
INSERT INTO gmvl_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","hessaadey iza bolla uttida miish bochchida asi ubbay omars gakkanaas tuna; gido attiin he tunida issi miishshatappe issaa denththida ay asikka ba may7onne ba bolla meecco; gidikkoka izi omars gakkanaas tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","«Asateththafe tunisiza miishshi goggi keziza asi ba kushe meecettontta dishe hara bochchiko he boshettidaadey ba may7onne ba bolla haaththan meecco; gidikkoka omars gakkanaas tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Asateththafe tunisiza miishshi goggi keziza as bochchida mana miishshi meqqo; miththafe oosettida miishshi wurikka haaththan meecetto. ");
INSERT INTO gmvl_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","«Asateththafe tunisiza miishshi goggi keziza asi he hargezappe paxikko kase diza mala ba paxidayssa erisanaas laappun gallas gakkanaas gam7iishsho; hessafe guye ba may7o meecco; qasseka ba bolla xillo gidida pultto haaththan meecetto; histtidi geesh gido. ");
INSERT INTO gmvl_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Osppunththa gallas nam7u haraphpheta woykko nam7u haraphphe ciyeta Gaytoteththa Dunkaane penge efidi GODAA sinththan qeesezas immo. ");
INSERT INTO gmvl_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Qeesezikka haraphpheta ekkidi issaa nagara wursos yarsho, hankkoyssa qasse xuugettiza yarsho histti yarsho; hessaththo histtidi qeesezi hessaade goggi keziza miishshas geeyza wogaa GODAA sinththan polo. ");
INSERT INTO gmvl_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","«Ay asikka iza attumateththafe zereththi gukkiko izi ba bolla meecetto; gidikkoka omars gakkanaas tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Zereththay iza bolla gukkida ay may7o gidiin woykko galba gidikko haaththan meecetto; gidikkoka omars gakkanaas tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Addey maccassara zin7i dendidaappe guye nam7ayka bantta bolla haaththan meecettetto; gidikkoka omars gakkanaas tuna gidetto. ");
INSERT INTO gmvl_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","«Maccassas aginan aginan yiza wogay beettiko laappun gallas gakkanaas iza tuna gidu; izo bochchiza ay asikka omars gakkanaas tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Maccassas aginan aginan diza wogay yiza wode iza uttizasoynne ichchidasoy ubbay tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Iza ichchida hiixa bochchida ay asikka ba may7onne ba bolla meecco; gidikkoka omars gakkanaas tuna gido; ");
INSERT INTO gmvl_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","iza uttida ay miishshika bochchidaadey ba may7onne ba bolla meecco; gidikkoka omars gakkanaas tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Iza ichchidaso woykko uttidaso miish bochchida ay asikka omars gakkanaas tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Aginan aginan beettiza maccassa wogay yiza wode izira zin7iza ay addeyka izi mala tuna gidiza gishshas laappun gallas gakkanaas tuna gido; izi ichchiza hiixay tuna gidees. ");
INSERT INTO gmvl_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Issi maccassas aginan aginan beettiza maccassa wogay gukkiza wodeppe daro gallas gukkiko woykko aginan aginan beettiza wodezappe bollara aggontta suuththi gukkiko he suuththay eqqana gakkanaas iza tuna gidawus. ");
INSERT INTO gmvl_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","He wode iza ichchida hiixa gidiin woykko iza iza bolla uttida miishshi aginan aginan beettiza maccassa wogay diza wode haniza mala ubba wode tuna. ");
INSERT INTO gmvl_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Heyta bochchida ay asikka tunida gishshas ba may7onne ba bolla meecco; gidikkoka omars gakkanaas tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","«Izippe gukkiza suuththay eqqiko he suuththay eqqoo gallassafe biidi laappun gallas gakkanaas gam7ada hessafe guye wogay giza mala geeyu. ");
INSERT INTO gmvl_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Osppunththa gallas nam7u haraphpheta woykko nam7u waanoseta Gaytoteththa Dunkaane penge ekka yaada qeesezas immu. ");
INSERT INTO gmvl_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Qeesezikka issaa nagarappe geeshshiza yarshos nam7anththozakka xuugettiza yarshos shiishsho; histtidi he maccassayo tunateththafe geeshshiza woga polo. ");
INSERT INTO gmvl_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","«Heen istta giddon diza Gaytoteththa Dunkaane tunisidi hayqqontta mala Isra7eele nayta tunisiza miishshafe naagite.» ");
INSERT INTO gmvl_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Tunisiza miishshi iza asateththafe goggi kezizaadessinne iza attumateththafe zereththi gukkizaades, ");
INSERT INTO gmvl_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","qasseka aginan aginan beettiza maccassa wogay beettiza maccassas woykko adde gidiin macca gidiin tunisiza miishshi istta asateththafe goggiza wode woykko geeyontta maccassara zin7iza attumasaas wodhdhida wogay hessa. ");
INSERT INTO gmvl_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Aaroone attuma naa nam7ati bessontta tama GODAA sinth ekki shiiqida gishshas hayqqida; hessafe guye GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","«Ne isha Aarooney Taabotaa bollan diza atto gizasoza kammizayssa sinththan magalashaappe guye baggara diza keehi dumma geetettizasoza ba shene mala ubba wode gelontta mala izas yoota; izi ubba wode ba shenen gelizaa gidikko hayqqana; gaasoykka tani shaara giddora atto gizasoza kamaa bolla qonccays. ");
INSERT INTO gmvl_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","«Aarooney nagarappe maareththiza yarshos issi mirgo booranne qasse xuugettiza yarshos issi dharsho ekkidi keehi dumma geetettizasoza gelo. ");
INSERT INTO gmvl_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Aarooney keehi dumma geetettizaso gelanaappe kase may7oti dumma gidida gishshas ba bolla meecettidi qeeseteththa may7o may7o; hessika laynoppe oosettida qamisanne sure may7o; hessaththoka laynoppe oosettida qabatton gixxo; laynoppe oosettida goosseka goozo. ");
INSERT INTO gmvl_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","«Isra7eele nayta maabaray nagara gishshas shiishshiza yarshos nam7u deysha orgenne xuugettiza yarshos issi dharsho Aaroones ehetto. ");
INSERT INTO gmvl_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aarooney baassinne baso asaa nagara wursanaas issi korma boora yarshos shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Hessafe guye he nam7u deysha orgeta gede Gaytoteththa Dunkaaneza pengen GODAA sinth efo. ");
INSERT INTO gmvl_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Histtidi he nam7u orgeta bolla izi saama yeggo; heytappe issoy, ‹GODAA› nam7anththozi, ‹Azazeele› giza malatay diza shuchchata orgeta bolla yeggo. ");
INSERT INTO gmvl_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","GODAAS giza malatay iza bolla wodhdhida deyshaza nagarappe geeshshiza yarshos shukko. ");
INSERT INTO gmvl_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Azazeeles giza malatay iza bolla wodhdhida deyshazi shukettontta paxa GODAAS shiiqo; dereza nagara tookkidi duge bazzo yedetto. ");
INSERT INTO gmvl_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","«Aarooneykka korma booraza ba nagara wursanaassinne baso asaa nagara wursanaas yarsho shukko. ");
INSERT INTO gmvl_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Qasse GODAA sinththan diza yarsho yarshizasoppe exaane cuwasiza miishsha kumeththa bonqonne liiqi gaacettida nam7u zolle sawiza exaane ekkidi magalasha giddon diza keehi dumma gidida kifile eho. ");
INSERT INTO gmvl_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Exaaneza heen GODAA sinththan taman yeggo; izi iza be7idi hayqqontta mala exaaneza cuway Taabotaa kammizayssa ubbaa genththo. ");
INSERT INTO gmvl_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Kormaza suuththaafe guuththara ekkidi izan ba biradhdhe gelththi gelththidi Taabotaa kamaza bolla sinththa baggara araco; hessaththoka izappe guuththara Caaqo Qaala Taabotaa sinththan laappunto wuxxo. ");
INSERT INTO gmvl_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","«Hessafe guye hankko dereza nagaraa gishshas shukettiza deyshaa shukko; iza suuththaa keehi dumma geetettiza kifileza gelththidi kase kormaza suuththaa ooththoyssaththo atto gizaso Taabotaa kamaza bollaninne izas sinththa baggara laappunto wuxxo. ");
INSERT INTO gmvl_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Hessaththoka ooththidi keehi dumma gidida kifileza Isra7eele nayta tunateththafenne istta nagara ubbaafe geeshshanaas geesho woga polo; kase istti tuna miish ooththishin istta giddon diza Gaytoteththa Dunkaanezakka hessaththo geeshsho. ");
INSERT INTO gmvl_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Geesho woga polanaas Aarooney keehi dumma geetettiza kifileza gelidi ba nagara gishshas, baso asaa nagara gishshassinne Isra7eele dere nagaraa gishshas yarsho shiishshi maarisidi kezana gakkanaas ay asikka Gaytoteththa Dunkaaneza giddon dooppo. ");
INSERT INTO gmvl_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Hessafe kaallidi izi GODAA sinththan yarsho yarshizaso kezidi geeshsho; korma suuththafenne deysha suuththafe guuththara ekkidi yarsho yarshizasozan yuuyi aadhdhanaas diza dhemota tiyo. ");
INSERT INTO gmvl_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Qasse Isra7eele nayta tunateththafe yarsho yarshizasoza geeshshanaassinne dummasanaas suuththaafe guuththara ekkidi ba biradhdhe xeeran yarsho yarshizasoza bolla laappunto wuxxo. ");
INSERT INTO gmvl_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«Aarooney keehi dumma geetettizaso, Gaytoteththa Dunkaanenne yarsho yarshizasoza geesho woga polidaappe guye shukettontta attida baqa deyshaa ekkidi GODAAS shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Ba kushe nam7ata deyshaa hu7e bolla woththidi dereza nagaraa, iitateththaanne makkallateththaa ubbaa paaxo; deyshaza hu7e bolla yuushshi pittishe deraa nagara iza bolla woththo; hessafe guye kase deyshaza efanaas giigetti uttidaade bolla duge bazzo yeddetto. ");
INSERT INTO gmvl_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Hessika deyshay asa ubbaa nagara ubbaa tookkidi ay asikka bayndaso duge bazzo haassi yeddo. ");
INSERT INTO gmvl_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","«Aarooneykka gaytoteththa dunkaanaa giddo gelo; gede keehi dumma geetettiza kifileza gelanaappe kasetidi izi kase may7ida qeeseteththa may7oza heen qaari woththo. ");
INSERT INTO gmvl_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Ba bolla heen geeshshasohon meecettidi ba kase may7iza may7o; heeppe kezidi ba nagara wursanaassinne deraa nagara wursanaas xuugettiza yarsho shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Nagara wursanaas shiiqida meheza moodhe yarsho yarshizasoza bolla xuuggo. ");
INSERT INTO gmvl_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«Bazzo yedettiza deyshaa duge bazzo laaggi efidaadey guye asay dizaso simmi gelanaappe kasetidi ba may7o meecco; ba bollaka meecetto; hessafe guye asay dizaso gelo. ");
INSERT INTO gmvl_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Nagara gishshas yarshettana shiiqidaytanne nagara geeshshanaas istta suuththi keehi dumma kifile geetettizaso gelida kormazanne deyshaza ashoy, galbazinne tocey attontta asi dizasoppe gede haraso biidi xuugetto. ");
INSERT INTO gmvl_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Hessa ubbaa xuuggizaadey xuuggidi asi dizaso simmi gelanaappe kasetidi ba may7o haaththan meecco; ba bollaka meecetto. ");
INSERT INTO gmvl_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«Hayssafe kaallidi inttes imettiza wogata hayssafe guye yaana layththatan ubbaan laamettontta eqqi diza woga histtidi naagite; layththafe laappunththa aginay gelida tammanththo gallas Isra7eele dere asaynne istta garsan diza hara dere asay xooma xoomanaas bessees; he gallas ay oosoykka oosettofo. ");
INSERT INTO gmvl_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","He gallas intte nagaray kichchana malanne intte geeyana mala geesho wogay polettiza gishshas intte GODAA sinththan intte nagara ubbaafe geeyidayta gidana. ");
INSERT INTO gmvl_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","He gallassay xooma gallassinne shempo shempiza sambata gallas gido; hessika mernaa woga gido; ");
INSERT INTO gmvl_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ba aawa sohon qeeseta halaqa gidanaas tiyettidanne shuumettida qeesey nagara ubbaa woga polanaas ba qeeseteththa may7oza may7idi polo. ");
INSERT INTO gmvl_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Izikka keehi dumma kifileza, yarsho yarshizasoza, Gaytoteththa Dunkaaneza; qeesetanne Isra7eele asaa ubbaa nagara wurso. ");
INSERT INTO gmvl_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Isra7eele asaa nagara ubbaa woga intte layththan layththan issito polana mala hessi inttes mernaas laamettontta woga gido.» Hessaththo GODAY iza azazida mala Musey ooththides. ");
INSERT INTO gmvl_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","« ‹GODAY azazida azazoy hayssa› gaada Aaroones, iza naytassinne Isra7eele asi ubbay diza heeran yoota; ");
INSERT INTO gmvl_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","woykko ba diza heerappe karen boora woykko dors woykko deyshe yarsho shukkidi, ");
INSERT INTO gmvl_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","GODAAS dummatidason Xoossas yarshanaas Gaytoteththa Dunkaane penge ehontta aggiko hessaadey suuththaa coo hada gussida mala qoodettidi dere giddofe shaaketti goodetto. ");
INSERT INTO gmvl_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Hessa gishshas Isra7eele nayti ay mehe gidiin coo demban shukkontta GODAA sinth Gaytoteththa Dunkaane penge ehetto; meheta Dunkaane penge ehidi qeesezas immetto; qeesezikka issifeteththa yarsho histti shukko. ");
INSERT INTO gmvl_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Qeesezikka suuththaa Gaytoteththa Dunkaane pengen diza GODAAS yarsho yarshizasoza bolla wuxxo; GODAA ufayssiza lo7o sawo gidana mala moodheza taman xuuggo. ");
INSERT INTO gmvl_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Isra7eele nayti istta ammanoppe haassiza daydanththatas yarsho ooththidi ba mehe beettooson beettooson yarshos shukkanaas bessenna; hessika isttassinne isttafe guye yeleta ubbaas mernaa woga gidi de7o. ");
INSERT INTO gmvl_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","9","«Ne isttas, ‹Isra7eele naytappe gidiin woykko isttara diza hara dere as gidiin Dunkaaneza pengefe attiin harason awanka GODAAS xuugettiza yarsho woykko hara yarsho yarshiko hessaadey GODAA deretara qoodettanaas bessenna› ga yoota. ");
INSERT INTO gmvl_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","«Isra7eele as gididay oonikka woykko Isra7eele naytara issife diza hara dere asi suuth uyikko hessaadey ta achchan ixettidaade gidees; tani hessaade iza dere garsafe shaakka dhayssana. ");
INSERT INTO gmvl_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Shemppora paxa diza medheteth ubbaas shemppoy suuththa giddon dees; hessa gishshas asa nagara wursanaas gukkiza suuththi wurikka yarsho yarshizasoza bolla gukkana mala immadis; asa shemppo nagarappe maarisizay suuththa. ");
INSERT INTO gmvl_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Hessa gishshas Isra7eele asaa, ‹Inttefe woykko intte giddon diza hara dere asappe oonikka suuth uyoppo› gays. ");
INSERT INTO gmvl_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","«Isra7eele naytappe woykko isttara diza hara dere asappe oonikka ashoy meetettana mala imettida mehe gidiin woykko wora do7a woykko kafo shankkati oykkidi iza suuththaa biitta bolla gussidi biitta iza bolla kammo. ");
INSERT INTO gmvl_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Gaasoykka asho may7ida ubbaa shemppoy suuththa giddon dees; hessa gishshas tani Isra7eele asaa, ‹Asho may7ida medheta ubbaa shemppoy iza suuththa giddon diza gishshas suuth moopite; midaadey oonikka ba dere giddofe shaaketti dhayo› gays. ");
INSERT INTO gmvl_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","«Isra7eele naytappe woykko hara dere asappe oonikka bawuti hayqqidaaz woykko do7ay wodhida mehe asho miikko ba may7o meecco; ba bolla meecetto; gidikkoka omars gakkanaas tuna gido; hessafe guye geesh gido. ");
INSERT INTO gmvl_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ba may7o meeccontta aggikonne ba bolla meecettontta aggiko hessaadey nagara ooththida gishshas ba nagaran oyshettana.» ");
INSERT INTO gmvl_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","GODAY Muses hizgi yootides; ");
INSERT INTO gmvl_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«Isra7eele naytas, ‹Tani GODAA intte Xoossaa; ");
INSERT INTO gmvl_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","kase intte heen de7ida Gibxe biitta asay woykko buro ta inttena gelththana Kanaane biittan diza dere asay ooththiza shaattiza ooso intte ooththoftenne istta hano kaallofte. ");
INSERT INTO gmvl_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Ta wogata naagite; ta azazotakka polite; tani GODAA intte Xoossaa. ");
INSERT INTO gmvl_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ta azazotanne wogata naagite; hessantta naagiza asi ba shemppo ashshana; tani GODAA› ga yoota. ");
INSERT INTO gmvl_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","«Inttefe oonikka baas asho dabbora laymatoppo; tani GODAA. ");
INSERT INTO gmvl_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","«Ne aayeyra laymatada ne aawa kawushshofa; nees aayo gidida gishshas izira laymatoppa. ");
INSERT INTO gmvl_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","«Ne aawaas hara machchetarakka laymatada ne aawa yeellachchofa. ");
INSERT INTO gmvl_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","«Ne michcheyra laymatoppa; hessaththoka nenara issife diccidaaro gidiin woykko harason diccidaaro gidiin ne aaway yelida hara machchi naa woykko ne aaya hara azinas yelida macca nayra laymatoppa. ");
INSERT INTO gmvl_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","«Nees yeella gidontta mala nees naaza nayra, woykko nees nay nayra laymatoppa. ");
INSERT INTO gmvl_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","«Ne aawaas hara machcha yelida ne michcheyra zin7ofa; gaasoykka iza nees michcho. ");
INSERT INTO gmvl_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","«Ne aawa michcheyra zin7ofa; gaasoykka iza nees michcho. ");
INSERT INTO gmvl_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Ne aayey michcheyrakka zin7ofa; gaasoykka iza ne aayeys asho dabbo. ");
INSERT INTO gmvl_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","«Ne aawa isha machchira zin7ofa; gaasoykka iza nees aawa machchi mala. ");
INSERT INTO gmvl_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","«Ne naaza machcheyra zin7ofa; iza nees naaza machcho gidida gishshas izira zin7ofa. ");
INSERT INTO gmvl_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Ne isha machcheyra zin7ofa; gaasoykka iza nees isha machcho; hessi ne isha kawushshiza miishsha. ");
INSERT INTO gmvl_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","«Aayeyranne nayra zin7ofa; izis nay naaza nayranne nays nay nayra zin7ofa; isttika izas mata dabbo gidida gishshas hessaththo hanoy kawushshateththa. ");
INSERT INTO gmvl_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","«Ne machchiya paxa dishin izi michchiyo dawuth ekkofa; izirakka laymatoppa. ");
INSERT INTO gmvl_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","«Aginan aginan beettiza maccassa wogay yiza wode maccassara zin7ofa. ");
INSERT INTO gmvl_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","«Hara asa machchira zin7ada nerkka nena tunisoppa. ");
INSERT INTO gmvl_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","«Ne naytappe oonakka molooke geetettiza eeqas xuugettiza yarsho ooththa immofa; gaasoykka ne Xoossaa sunth tunisoppa; tani GODAA. ");
INSERT INTO gmvl_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","«GODAA sinththan ixettida miish gidida gishshas maccassara zin7iza mala addera zin7ofa. ");
INSERT INTO gmvl_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","«Adde gidiin woykko maccassi mehera parattidi banateththaa tunisoppo; hessa mala hanoy kawushshateththa. ");
INSERT INTO gmvl_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","«GODAY nena istta dere gelththanaas ne sinththafe diggana; hankko asay barkka ba ooson bana tunisidayssa mala istti ooththiza iita oosotappe issineynka inttena tunisopite. ");
INSERT INTO gmvl_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Istta oosoy biitta tunisida gishshas tani he biittayo izi nagara gishshas qaxxayadis; biittayakka ba giddon diza asaa kessa cuttadus. ");
INSERT INTO gmvl_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Intte gidikko ta azazotanne ta woga naagite; Isra7eele asaappe woykko intte giddon diza hara biitta asappe oonikka hayssa mala ay oosokka ooththofte. ");
INSERT INTO gmvl_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Inttefe kase he biittayn diza asati heyta mala harassiza miish ooththida gishshas biittaya tunadus. ");
INSERT INTO gmvl_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Intte hessaththo ooththiko biittaya kase inttefe sinththan diza kawoteththata cuttidayssaththo inttenakka cuttana. ");
INSERT INTO gmvl_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","«Hayta harassiza iita oosotappe issineyokka ooththizaadey ba dere asaa giddofe shaaketti dhayo. ");
INSERT INTO gmvl_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Hessa gishshas inttefe kase sinththan biitta bolla diza asati ooththida tuna oosota ubbaa ooththidi intte tunontta mala ta azazota naagite; tani GODAA intte Xoossaa.» ");
INSERT INTO gmvl_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","GODAY Muse hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«Hayssa Isra7eele naytas yoota, ‹Tani GODAY intte Xoossay dumma gidida mala intteka dumma gidite. ");
INSERT INTO gmvl_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","« ‹Inttefe oonikka attontta ba aawaanne ba aayo bonchcho; ta inttena azazida mala Sambata gallassata bonchcho; tani GODAA intte Xoossaa. ");
INSERT INTO gmvl_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","« ‹Tana aggidi eeqatas goynnofte; woykko eeqa Xoossata biratappe seerisidi inttes medhdhofte; tani GODAA intte Xoossaa. ");
INSERT INTO gmvl_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","« ‹Intte issifeteththa yarsho GODAAS shiishshiza wode he yarshoy intte gishshas ekettana bessiza mala yarshite. ");
INSERT INTO gmvl_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Yarshoza shiishshida gallas woykko wonteththa gallas meetettanaas bessees; heedzdzanththo gallas gakkanaas gam7ida yarshoy wurikka taman xuugetto. ");
INSERT INTO gmvl_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Heedzdzanththo gallassan iza miikko hessi tuna; hessa gishshas tani he yarshoza ekkike. ");
INSERT INTO gmvl_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Izappe midaadey oonikka taas dummatidayssa hada miishsha mala qoodida gishshas izi ba nagaran oyshettana; hessaadey ba dere asaa giddofe shaaketti dhayo. ");
INSERT INTO gmvl_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","« ‹Intte maxa wode intte kath maxishin gaxa bolla diza kath maxopite; intte maxishin geedon attida puushechcho maxanaas guye simmofte. ");
INSERT INTO gmvl_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Neni ne woyne miththa ayfe maxishin hagga giddon qotetti attidayssa woykko gaden qoqofettidayssa qora ekkanaas guye simmofa; heytantta ubbaa manqotassinne bete yidaytas aggaaga; tani GODAA intte Xoossaa. ");
INSERT INTO gmvl_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","« ‹Kaysotopite; as baleththofte; wordo haasayopite; ");
INSERT INTO gmvl_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","« ‹Ta sunththan wordora caaqqofte; wordo caaqqidi intte Xoossa sunththaa tunisopite; tani GODAA intte Xoossaa. ");
INSERT INTO gmvl_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","« ‹As baleththofa; woykko asa miishshe bonqqa ekkofa; miishshe immana gaada ne ooso oosisidaades miishshaa immontta dashe ne achchan issi qammaka ayssofa. ");
INSERT INTO gmvl_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","« ‹Siyenna gaada tulle cayoppa; qooqey dhuphettidi kundana mala iza sinththan dhuphizaaz woththofa; ne Xoossas yayya; tani GODAA ne Xoossa. ");
INSERT INTO gmvl_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","« ‹Neni pirda pirdiza wode pirda geellasoppa; manqo iza manqoteththa gishshas maadda pirdofa; gita asatas dumma bonchcho immofa; dere asaakka dumma maadda pirdofa; asa ubbaas tumu pirda pirda. ");
INSERT INTO gmvl_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","« ‹Neni asa giddon zigirs ekkada yuuyoppa; ne shooroza hayqos gaththiza ay miishshika ooththofa; tani ne GODAA. ");
INSERT INTO gmvl_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","« ‹Ne isha ne wozinan ixxofa; iza gaason nees nagara gidontta mala ne shooroza hanqa. ");
INSERT INTO gmvl_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","« ‹As ubbaa ne nena siiqiza mala siiqa attiin ay asa bollaka ne ulon lancce oykkada halo kessofa; tani GODAA. ");
INSERT INTO gmvl_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","« ‹Ta azazota naagite; dumma dumma qommo meheta issi bolla gaththi mehetisofte; nam7u qommo kaththa zereth walakkidi issi bolla zeropite; nam7u qommo miishshafe dadettida may7o may7ofte. ");
INSERT INTO gmvl_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","« ‹Issaadey hara asara giigetta uttida aylleyra laymatikko izakka ba aylleteththafe wozzettonttaaro gidikko izaadey qaxxayetto; gidikkoka iza wozzettontta gishshas nam7ayka hayqqofetto. ");
INSERT INTO gmvl_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Hessa mala qoho gaththidaadey qoho gishshas shiiqiza yarshos issi dharsho gaytoteththa dunkaane penge GODAA sinth eho. ");
INSERT INTO gmvl_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Qeesezikka hessaade nagara wursanaas Xoossa sinththan qoho yarshos imettida dharshoza shiishsho; izaade nagaraykka atto geetettana. ");
INSERT INTO gmvl_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","« ‹Intte Kanaane gelidi ayfe ayfiza mith tokkiko he ayfe ayfiza miththaya ayfe doommoosofe biidi heedzdzu layth gakkanaas immiza ayfey meetettontta digettidayssa erite; he layththatan he miththata ayfe moopite. ");
INSERT INTO gmvl_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Oydanththo layththa bolla he miththaa ayfey ubbay GODAAS galatas shiishshiza yarsho gido. ");
INSERT INTO gmvl_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Ichchashanththo layththan qasse miththaa ayfeza inttes miite; intte hessaththo histtiko ayfe ayfiza intte miththay woden woden inttes immiza ayfey kaseppe gede gujetti gujetti baana; tani GODAA intte Xoossaa. ");
INSERT INTO gmvl_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","« ‹Suuththara diza ay ashokka moopite; maroththoftenne bita bitopite. ");
INSERT INTO gmvl_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","« ‹Intte hu7e binana garsara yuushshi aaththidi qanxxofte; intte buuchchaaka qaanththan qanxxofte. ");
INSERT INTO gmvl_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","« ‹Intte asateththa bolla niqse cach caddofte; woykko asi hayqqiko izas mishettidi intte bolla qanxxi madunththofte; tani GODAA. ");
INSERT INTO gmvl_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","« ‹Biittaya laymaninne tunateththan kumontta mala ne nayo laymateththa oosos aaththa immada kawushshofa. ");
INSERT INTO gmvl_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Ta Sambata gallassata naagite; ta keeththaa bonchchite; tani GODAA. ");
INSERT INTO gmvl_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","« ‹Moytille haasayssizayta woykko iita ayanata haasayssizayta zore oychchofa; intte tunontta mala istta koyopite; tani GODAY intte Xoossa. ");
INSERT INTO gmvl_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","« ‹Neeppe cimmidaade beykko ne uttidasohoppe denda eqqada bonchcha; taas Xoossas yashshateththan azazetta; tani GODAA. ");
INSERT INTO gmvl_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","« ‹Hara biittafe yiidi intte giddon diza asata qohopite. ");
INSERT INTO gmvl_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Intte intte dere asas ooththiza mala isttaskka lo7o ooththite; intte inttena siiqiza mala isttaka siiqite; kase intteka Gibxe biittan beteta gididayssa yuushshi qopite; tani GODAA intte Xoossaa. ");
INSERT INTO gmvl_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","« ‹Maka miishshen gidiin woykko meezaanen woykko wadha miishshan as cimmofte. ");
INSERT INTO gmvl_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","As cimmontta tumu meezaaney, maka miishshinne mixe miishshi inttes de7o; tani inttena Gibxeppe kessida GODAA intte Xoossa. ");
INSERT INTO gmvl_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","« ‹Ta inttes immida ta azazotanne ta wogata ubbaa naagitenne ooththite; tani intte GODAA.› » ");
INSERT INTO gmvl_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","GODAY Muse hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«Isra7eele nayta, ‹Inttena gidikkonne intte giddon diza hara dere asatappe oonikka molooke geetetti xeygettiza eeqa xoossas ba naytappe issaa aaththi immi beettiko kumeththa Isra7eele dere asay hessaade shuchchan caddi wodho. ");
INSERT INTO gmvl_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Oonikka ba naytappe issaade molookes aaththi immidi ta keeththaa tunisida gishshassinne geeshshaa sunththaa tayssa kawushshida gishshas ta hessaade bolla qixaate yeddana; hessafe guye ta izaades morkke gidada dere giddofe iza shaakka dhayssana. ");
INSERT INTO gmvl_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Iza dere asay izaadey ooththoyssa ubbaaka wudettontta bessi aggikonne wodhontta aggiko, ");
INSERT INTO gmvl_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","tani ta baggara hessaadenne izaadeso asaa qasseka taas ammanettontta molookes goynnon izara issife gididayta ubbaa bolla iita hanqo yeddana; hessafe guye heytantta tani istta istta dereza giddofe shaakka dhayssana. ");
INSERT INTO gmvl_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","« ‹Oonikka isttafe zore oychchanaas moytille xeygizaytakkonne marotakko biikko hessaade bolla ta iita hanqo yeddana; hessafe guye hessaade tani iza dere giddofe shaakka dhayssana. ");
INSERT INTO gmvl_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","« ‹Intte asateth ubbaa geeshshite; dummatite; gaasoykka tani GODAA intte Xoossaa. ");
INSERT INTO gmvl_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ta azazoyo naagitenne polite; gaasoykka tani inttena taas dummasida intte GODAA. ");
INSERT INTO gmvl_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","« ‹Ba aawa woykko ba aayo cayizaadey hayqon qaxxayetto; izi hayqon qaxxayettizay ba mooronna. ");
INSERT INTO gmvl_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","« ‹Issi asi hara asa machchira laymatikko he laymatida addezaranne maccassayra nam7ayka hayqon qaxxayettetto. ");
INSERT INTO gmvl_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Issi asi ba aawa machchira laymatikko ba aawa kawushshida gishshas he laymatidayti nam7ayka hayqon qaxxayettetto; istti hayqon qaxxayettizay ba moorida mooronna. ");
INSERT INTO gmvl_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Issi asi baas naaza machchira laymatikko he laymatidayti nam7ayka hayqon qaxxayettetto; asho dabboteth layman tunisida gishshas istti hayqon qaxxayettizay ba moorida mooronna. ");
INSERT INTO gmvl_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","« ‹Issi asi maccara zin7iza mala addey addera zin7iko nam7ayka yeellachchiza miish ooththida gishshas hayqon qaxxayettetto; istti hayqon qaxxayettizay ba moorida mooronna. ");
INSERT INTO gmvl_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","« ‹Issi asi aayeyonne nayo machcho ekkiko heytantti ooththida harassiza hanoza gishshas heedzdzayka taman xuugetti hayqqetto; heytantta mala iita hanoy intte giddon polettanaas bessenna. ");
INSERT INTO gmvl_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","« ‹Ay asikka mehera paratikko izaadeynne he mehezi nam7ay hayqqetto. ");
INSERT INTO gmvl_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","« ‹Issi maccassi mehera paratikko izanne he iza parattida mehey nam7ay hayqqetto; istti hayqqizay ba moorida mooronna. ");
INSERT INTO gmvl_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","« ‹Issi asi ba michchiyo, baas aayi nayo woykko aawa nayo machcho ekkiko hessi yeellachchizaaza; hessa gishshas istti bantta dere giddofe shaaketti dhayetto; ba ooththida mooro gishshas ba qixaate ekketto. ");
INSERT INTO gmvl_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","« ‹Issi asi aginan aginan beettiza maccassa wogay beettida maccassara zin7iko izaadey izi kalloteth qaarida gishshassinne izakka ba kalloteththaa qaara bessida gishshas nam7ayka bantta dere giddofe shaaketti dhayetto. ");
INSERT INTO gmvl_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","« ‹Ay asikka ba aawa michchira woykko ba aayi michchira zin7ofo; hessaththo ooththizaa gidikko nam7ayka bantta dabboteththa kawushshiza gishshas ba moorida mooron oyshettana. ");
INSERT INTO gmvl_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","« ‹Ay asikka ba aawa isha machchira woykko ba aayey isha machchira laymatikko ba aawa isha machcho woykko ba aayi isha yeellasida gishshas laymatidayti nam7ayka oyshettananne yeloy baynda attana. ");
INSERT INTO gmvl_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Ay asikka ba isha machcho ekkizaa gidikko hessi tuna ooththees; ba ishaza bonchcho kawushshida gishshas nam7ayka naa yelontta attana. ");
INSERT INTO gmvl_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","« ‹Ta inttena izin gelththana Kanaane biittaya inttena cutta diggontta mala intte ta azazotanne ta wogata naagitenne polite. ");
INSERT INTO gmvl_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Tani intte sinththafe dhayssiza kawoteththata lose woga kaallofte; istti heytantta ubbaa ooththida gishshas ta istta shaatettadis. ");
INSERT INTO gmvl_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ta qasse izippe maaththinne eessi goggiza he cilila biittayo inttena gelththanaas caaqqadis; izokka ta inttes immana; hankko dereppe intte taas shaakettidayta gidana mala ooththiday tana GODAA intte Xoossaa. ");
INSERT INTO gmvl_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","« ‹Hessa gishshas intte geesh gidida mehetanne kafota tuna gididaytappe lo7eththidi shaakki erite; tani haytanti inttes tuna ga woththida mehetan, kafotaninne biitta bolla qaaxxiza ay miishshankka inttena tunisopite. ");
INSERT INTO gmvl_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Intte taas dumma shaakettidayta gidite; gaasoykka tani GODAY dumma Xoossa; intte ta dereta gidana mala Ayzaabeta giddofe tani inttena taas dummasa shaakkadis. ");
INSERT INTO gmvl_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","« ‹Ay asikka intte giddofe moytille xeygizaa woykko marotizaade gidikko izi shuchchan cadetti hayqo; hessaththo ooththizaadey ay asikka hayqon qaxxayettizay ba ooththida mooronna› ga yoota.» ");
INSERT INTO gmvl_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","GODAY Muses, «Aaroone naytas qeesetas, ‹Inttefe oonikka ba dabbota garsafe asi hayqqiko izaade aha bochchidi bana tunisoppo. ");
INSERT INTO gmvl_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Mata dabbotappe aaya woykko aaway woykko ba nay woykko ba ishay hayqqiko, ");
INSERT INTO gmvl_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","hessaththoka azina gelontta ixxada diza michcheya hayqqiko istta aha bochchanaas dandayees. ");
INSERT INTO gmvl_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Gido attiin geloninne ekon dabbotidayti aha bochchidi bana tunisopetto. ");
INSERT INTO gmvl_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","« ‹Qeesetappe oonikka hayqqidaades mishettidi ba hu7e binana buucoppo; ba buuchcheka buucoppo; ba bollaka qaaci madunththofo. ");
INSERT INTO gmvl_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Qeesey wurikka taas dumma gido; bantta Xoossaa sunththaa tunisopetto; gaasoykka istti Xoossas taman xuugettiza yarshonne GODAAS kaththa yarsho shiishshizayta gidida gishshas istti geesh gidetto. ");
INSERT INTO gmvl_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","« ‹Qeese gididaadey layma maccas woykko geela7oteththi ekettida geela7oyo woykko gela kezida maccas machcho ekkofo; gaasoykka qeeseti Xoossas dummatidayta; ");
INSERT INTO gmvl_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","qeesey intte Xoossas kaththa yarsho shiishshizayssa gidida gishshas izi hara asappe dumma gido; tani inttena geeshshiza intte GODAY geeshsha; izikka geesh gido. ");
INSERT INTO gmvl_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Qeese macca nay laymatikko iza ba aawaa kawushshida gishshas taman xuugetta hayqqu. ");
INSERT INTO gmvl_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","« ‹Qeeseta halaqay izi ba hu7e tiyettiza zaytey tiyettida gishshassinne qeeseteththa may7o may7ana mala dummatidaade gidida gishshas asi hayqqiko hayqqidaades izi mishettizayssa erisanaas ba hu7e binana buucoppo; ba may7oka daakkofo. ");
INSERT INTO gmvl_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ahay dizasokka izi geloppo; haray attoshin ba aawa woykko ba aayey ahakka bochchidi bana tunisoppo. ");
INSERT INTO gmvl_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Iza dummasanaas tiyda Xoossa zaytey iza bolla diza gishshas qeesey Xoossa Keeththafe kezi biidi Xoossa Keeththaa tunisoppo. ");
INSERT INTO gmvl_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","« ‹Qeesey ekkana machcha geela7o gidu. ");
INSERT INTO gmvl_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Azinay hayqqidaaro woykko gela kezidaaro woykko layma maccas ekkofo; gelontta geela7o xalla ba dere asaa giddofe doori ekko. ");
INSERT INTO gmvl_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Hessaththo histtontta aggiko izi ba dere giddon ba nayta tunisana; iza dumma shaakkida GODAY tana Xoossaa› ga yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","GODAY Muse hizgi azazides; ");
INSERT INTO gmvl_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«Aaroones, ‹Ne qommotappe iza asateththaa bolla wosoy dizaadey oonikka taas yarsho shiishshofo; hayssi ha wogay buro sinththafe yaana yeletan ubbaan naagetti de7o. ");
INSERT INTO gmvl_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Pace asateththi dizaadey oonikka hessika qooqey woykko wobbey woykko medho iitay woykko asateththay borsizaadey, ");
INSERT INTO gmvl_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","kushey woykko tohoy silidaadey, ");
INSERT INTO gmvl_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","zokko quunay woykko dinkey, ayfey sakkizaadey woykko iza bolla uzazizaazi dizaadey woykko shuufay kaththa yarsho taas shiishshanaas bessenna. ");
INSERT INTO gmvl_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Aaroone zereth kumeththaa giddofe asateththa bolla wosoy diza asi oonikka xuugettiza yarshonne yarsho ba GODAAS yarshanaas yooppo. ");
INSERT INTO gmvl_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Hessa mala asi nam7u qommo kaththa yarshota maanaas dandayees; heytikka dummatida kaththinne keehi dummatida yarsho kaththa. ");
INSERT INTO gmvl_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Gidikkoka iza asateththan borey diza gishshas ta keeththaa tunisontta mala izaadey gede yarsho yarshizaso woykko gede magalashakko shiiqoppo; gaasoykka istta dumma ooththa shaakkiday tana Xoossa› gaada yoota.» ");
INSERT INTO gmvl_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Museykka hessa ubbaa Aaroonessinne Aaroone naytas kumeththa Isra7eele dere asaas yootides. ");
INSERT INTO gmvl_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","GODAY Muse hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«Aaroonessinne iza naytas, ‹Intte harappe dumma gidida ta sunththaa tunisontta mala Isra7eele nayti taas dummasidi shiishshiza yarsho ubbaa bonchchora ekkidi geeshshateththan naagite; tani GODAA. ");
INSERT INTO gmvl_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","« ‹Intte zereththafe tunidaadey Isra7eele nayti taas dumma shaakki immida miish xalateththan bochchidaadey ta sinththafe dhayana; hayssi ha wogay hayssafe guye sinththara yaana yeleta ubbaan naagetto; tani GODAA. ");
INSERT INTO gmvl_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","« ‹Aaroone zereththatappe ay asikka iza bolla asappe asan aadhdhiza galba hargey dizaadey woykko iza asateththafe goggi keziza miishshi dizaadey oonikka geeyana gakkanaas Xoossas dummatida miish mooppo; ahay bochchiin tunida miish bochchidaadey woykko iza bollafe zereththa haaththi xokettizaade bochchidaadey, ");
INSERT INTO gmvl_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","hessaththoka biittara gooshettizaytanne ay miishshankka tunida as bochchidaadey, ");
INSERT INTO gmvl_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","hessa mala ay tuna miishshika bochchidaadey omars gakkanaas tuna gidees; hessafe guye izi ba bolla haaththan meecettontta dishe Xoossas dummatida kath mooppo. ");
INSERT INTO gmvl_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Arshey wullidaappe guye qasse izi geesh gidees; hessafe guye dumma gidida kaththa yarshoza izas quma gidida gishshas maanaas dandayees. ");
INSERT INTO gmvl_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Bawuti hayqqidaazinne do7ay wodhida mehe asho mooppo; izi hessa mizaaz gidikko tunees; tani GODAA. ");
INSERT INTO gmvl_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","« ‹Qeeseti tani isttas immida wogaa naagetto; istti naagontta aggiko geesh gidida ta azazotas azazettontta ixxida gishshas isttas qoho gidiin istti hayqqana; istta dummasa shaakkiday tana GODAA. ");
INSERT INTO gmvl_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","« ‹Taas dummatida yarshofe maanaas dandayzay qeesetanne isttaso as xalla attiin hara asi izappe mooppo; qeesera imaththi woykko oosos qaxxarettidi izara dizaadeyka mooppo. ");
INSERT INTO gmvl_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Gido attiin qeesey ba miishshan shammida aylley woykko soon yelettida aylley qeeseza gishaappe mo. ");
INSERT INTO gmvl_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Qeese gidontta hara as gelida qeeseza naya Xoossas dummatida yarshofe muuppu. ");
INSERT INTO gmvl_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Gido attiin naa yelontta dishin izi azinay hayqqidaara woykko ba azinappe anjjettada ba aawa soo simmada diza qeese naya kase iza naateteththa wode ooththiza mala ba aawa gishaappe mu; gidikkoka qeeseso asappe attiin hara asi dummatida yarsho kaththaafe mooppo. ");
INSERT INTO gmvl_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","« ‹Qeeseso as gidonttaadey oonikka erontta dishe GODAAS dummatidi imettida miish miikko he izi midayssa kumeththa wogaa xeetappe nam7u kushe gujjidi qeesezas qanxxo. ");
INSERT INTO gmvl_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Isra7eele nayti Xoossas immiza dumma yarshota qeeseti tunisanaas bessenna. ");
INSERT INTO gmvl_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Hessika izappe maanaas bessonttaades qeeseti immiko he midaades mooro gididi izaade bolla hanqo gaththana; imotata ubbaa taas dummasiday tana GODAA› ga yoota.» ");
INSERT INTO gmvl_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","GODAY Muse hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«Aaroones iza naytassinne Isra7eele dere ubbaas, ‹Isra7eele as gididay woykko Isra7eele nayta giddon diza imaththa asi adina gaththanaas woykko izi coo ufayssan mela immiza xuugettiza yarsho shiishshiko, ");
INSERT INTO gmvl_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","iza yarshoy ekettana mala issi borey iza bolla baynda korma boorappe, dharshofenne deysha orgefe gido. ");
INSERT INTO gmvl_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Iza bolla wosoy diza mehe intte shiishshiko GODAY hessa ekkenna. ");
INSERT INTO gmvl_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","« ‹Qasse oona gidikkoka ba adina gaththanaas issifeteththa yarsho GODAAS yarshiza wode woykko ba dosan ba mehetappe kiyateththa imota immizaa gidikko he imotaa ekkana mala izi immiza meheza bolla aykko wosoy bayndaaz gido. ");
INSERT INTO gmvl_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Qooqe woykko meqo woykko qiisha woykko giiyza madunththara dizaa woykko gaaranda woykko shattora diza mehe GODAAS yarsho shiishshofa; hessantta mala mehe yarsho yarshizasozan xuugettiza yarsho histta yarshofa. ");
INSERT INTO gmvl_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Izas medheteththi wogay baynda adussa woykko qaanth gidida mehe ba dosan immiza kiyateththa imota gididi shiiqanaas dandayees; gido attiin adina gasos shiishshanaas dandayenna. ");
INSERT INTO gmvl_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Sangettida woykko dhiiqettida mehe GODAAS yarsho shiishshofte; intte biittan heytantta mala yarshofte. ");
INSERT INTO gmvl_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Allaga asappe imettida mehe Xoossas yarsho shiishshofte; heytantta mala meheti borey diza mala qoodettiza gishshas istti ekkettettenna› ga yoota.» ");
INSERT INTO gmvl_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«Miiza mari woykko dorsa laaqqay woykko deysha laaqqay yelettiko laappun gallas gakkanaas ba aayppe shaakettofo; gido attiin osppunththa gallassafe oykkidi xuugettiza yarshos shiiqanaas dandayees. ");
INSERT INTO gmvl_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Miiz izi marara, dors izi laaqqara issi gallas yarshos shukkofte. ");
INSERT INTO gmvl_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","«Intte GODAAS galata yarsho yarshiza wode intte shiishshiza galatazi ekettana mala ooththi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Intte shiishshidayssafe aykkoka wontos ashshontta he gallas ubbaa michchite; tani GODAA. ");
INSERT INTO gmvl_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«Intte ta azazota naagitenne ooththite; tani GODAA. ");
INSERT INTO gmvl_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ta geeshsha sunththaa tunisopite; ta geeshshateththaa kumeththa Isra7eele asay eridi tana bonchcho; inttena dummasiday tana GODAA. ");
INSERT INTO gmvl_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Intte Xoossaa gidanaas inttena Gibxe biittafe kessiday tana; tani GODAA intte Xoossaa.» ");
INSERT INTO gmvl_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","GODAY Muse hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«Isra7eele asaas Dumma shiiqo gi awajjidi intte bonchchanaas bessiza doorettida ba7aaleti hayssafe kaalli dizayta; ");
INSERT INTO gmvl_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","«Intte inttes ooththanaas usuppun gallassati deettes; laappunththa gallassay gidikko inttes shempiza Sambata gallassa; he gallas intte Xoossa goynnanaas shiiqite attiin ay oosokka ooththofte; intte dizaso ubbaan hessi intte Xoossa bonchchana Sambata gallassa. ");
INSERT INTO gmvl_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«Isttas wodhdhida woden geeshsha shiiqo ooththi awajjidi intte bonchchanaas bessiza GODAA ba7aaleti hayssafe kaallizayta, ");
INSERT INTO gmvl_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","GODAY izan bonchchettiza paaziga ba7aaley koyro aginay gelida tammanne oydanththo gallas arshey wulliin gadey lem7i lem7ishin oykettees. ");
INSERT INTO gmvl_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","He aginazan tammanne ichchashanththo gallas ukeththa ba7aaley oykettees; hessafe guye laappun gallas gakkanaas irshoy gelontta uketh miite. ");
INSERT INTO gmvl_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","He gallassatappe koyro gallas Xoossa goynnanaas shiiqite; he gallas intte ooso ooththofte. ");
INSERT INTO gmvl_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Laappun gallas gakkanaas xuugettiza yarsho GODAAS shiishshite; intte ooso aggidi laappunththa gallas GODAA goynnanaas shiiqite.» ");
INSERT INTO gmvl_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","GODAY Muse hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«Isra7eele asaas tani inttes immiza biittaa gelidi intte kath shiishshiza wode kaththa xeera qeesekko ehite. ");
INSERT INTO gmvl_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","GODAA sinththan intte shiishshizayssi ekettana mala qeesezi qasse kaththaa xeeraa ekkidi yaanne haa qaaththiza yarsho histti Xoossas shiishsho; qeesezi he xeera kaththaa yaanne haa qaaseththiza yarsho histti shiishshanaas bessizay Sambata gallassafe wonteththa gallas gido. ");
INSERT INTO gmvl_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Intte he yarsho shiishshiza gallas iza bolla borey baynda issi layththa dharsho laaqqa xuugettiza yarsho ooththidi issi bolla Xoossas shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Izara issife wogara miththa zayten munuqettida nam7u kilo gidiza liiqo dhiille kaththa yarsho histti shiishshite; hessika iza sawoy GODAA ufayssiza xuugettiza yarsho gidana; izara issife issi litiro gidiza woyne ushshu imota shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Intte heyta GODAAS immanaappe koyro gakkida kaththa ayfe qaye gidiin woykko shaash woykko uketh uukkidi moopite; hayssa ha wogaza intte dizaso ubbaan guyeppe yaana intte yeletas eqqi diza mernaa woga gido. ");
INSERT INTO gmvl_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","«Intte GODAAS yaanne haa qaaseththi shiishshiza yarsho yarshida Sambata gallassa wonteththafe doommidi laappun Sambata qoodite; ");
INSERT INTO gmvl_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Laappunththa sambatappe guye ichchash tammanththo gallas qasseka hara ooraththa kaththa yarsho GODAAS shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Nam7u kilo gidiza liiqo dhiille intte sooppe irshon munuqetti uukettida nam7u uketh yaanne haa qaaseththiza yarsho histti ekki yiite; hessika oorath shiiqiza kaththaa gishshas Xoossas shiiqiza kaththa yarsho gido. ");
INSERT INTO gmvl_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","He ukeththaarakka issife istta bolla wosoy baynda issi layth gidiza laappun dharsho laaqqata issi korma boorara nam7u dharshota shiishshite; kaththa yarshozaranne woyne ushsha yarshozara issife GODAAS xuugettiza yarshonne sawo tunnu giza yarsho histti shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Qasseka nagara gishshas shiiqiza yarshos issi deysha orge, issifeteththa yarshos issi layth dharsho laaqqa nam7ata yarshos shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Qeesey ukeththaa nam7u laaqqatara yaanne haa qaaseththidi GODAAS dumma yarsho histti shiishsho; hessika qeeseta gisha gido; heyti he imotati harappe dumma imota. ");
INSERT INTO gmvl_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","He gallas awajja awajjidi GODAA goynnanaas issi bolla shiiqite attiin hara ooso ooththofte; hayssi intte dizaso ubbaan inttefe guyera yiza yeletas mernaas eqqi diza woga gido. ");
INSERT INTO gmvl_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Intte intte biittan kath shiishshiza wode dhassa bolla diza kaththaa maxopite; maxishin guyen attidayssa maxanaas guye simmofte; guyen attidayssi manqotassinne hara biittafe bete yida asatas atto; tani GODAA intte Xoossaa.» ");
INSERT INTO gmvl_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«Isra7eele asaas laappunththa aginay gelida koyro gallassay inttes shempo gallas gido; he wode zayey punettishin intte GODAA goynnanaas shiiqiza dumma shiiqo gido. ");
INSERT INTO gmvl_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","He gallas GODAAS taman xuugettiza kaththa yarsho shiishshite attiin he gallas aykkoka ooththofte.» ");
INSERT INTO gmvl_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«Laappunththo aginay gelidaappe guye tammanththa gallassay nagarappe maareteththa gallassa; he gallas ay kaththika moopite; GODAA goynnanaas shiiqite; Xoossas taman xuugettiza yarsho shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","He gallassay GODAA intte Xoossa sinththan asa nagara wurso gallas gidida gishshas he gallas aykkoka ooththofte. ");
INSERT INTO gmvl_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","He gallas banateththaa kawushshidi maarettontta ay asikka deraa giddofe shaaketti dhayo. ");
INSERT INTO gmvl_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","He gallas ay ooso gidiin ooththizaade tani iza iza deraa giddofe shaakka dhayssana; ");
INSERT INTO gmvl_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Hessa gishshas he gallas intte ay oosokka ooththofte; hayssi ha wogazi intte dizaso ubbaan inttefe guye yaana intte yeletaas eqqi diza mernaa woga gido. ");
INSERT INTO gmvl_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","He aginay gelida uddufunththo gallassa omarsafe biidi tammanththo gallassa omars gakkanaas inttenateththaa kawushshidi he gallassaa Sambata histti bonchchite.» ");
INSERT INTO gmvl_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«GODAAS Daase ba7aaley laappunththa aginay gelida tammanne ichchashanththo gallassafe doommidi laappun gallas gakkanaas bonchchetto. ");
INSERT INTO gmvl_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","He gallassatappe koyro gallas GODAA goynnanaas shiiqite attiin ay oosokka ooththofte. ");
INSERT INTO gmvl_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Laappun gallassatan issaan issaan GODAAS xuugettiza yarsho shiishshite; osppunththa gallas qasseka GODAA goynnanaas shiiqite; GODAAS xuugettiza kaththa yarsho yarshite; he gallassay intte shiiqoza wursiza gallas gidida gishshas he gallas aykkoka ooththofte. ");
INSERT INTO gmvl_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","«Intte taman xuugettiza yarshonne kaththa yarsho qasse hara yarshota ubbaanne ushsha yarsho koshshiza keena woththida gallassan GODAAS shiishshanaas intte geeshsha shiiqo ooththidi awajjanaas bessiza GODAAS doorettida ba7aaleti haytantta. ");
INSERT INTO gmvl_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Hayti ha yarshoti GODAA Sambata gallassatan intte shiishshizaytappe Xoossas immiza imotatappe adina gaththizaytappenne intte intte dosan coo immizaytappe bollara gujjidi intte immiza imotata. ");
INSERT INTO gmvl_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","«Intte kath shiishshidaappe guye laappunththa aginay gelida tammanne ichchashanththa gallas koyrora hayssa ufayssa ba7aaleza GODAA sinththan laappun gallas gakkanaas bonchchite; koyro gallassinne osppunththa gallassay inttes dumma shemppo gallas gido. ");
INSERT INTO gmvl_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","He koyro gallas intte biittan kaxxiza lo7o miththa ayfeppe, zamba hayth, cilila miththa hagganne haaththinaage miththa hagga oykkidi GODAA intte Xoossaa sinththan ufayettishe laappun gallas gakkanaas ba7aale ooththite. ");
INSERT INTO gmvl_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Hayssaka layththan layththan laappunththa aginan laappun gallas gakkanaas GODAA sinththan bonchchite; hayssi ha wogay inttes naa naa gakkanaas mernaa woga gidi bonchchetto. ");
INSERT INTO gmvl_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Kumeththa Isra7eele derey laappun gallas gakkanaas daasen utto. ");
INSERT INTO gmvl_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Hayssanka tani Isra7eele nayta Gibxe biittafe kessida wode istti daasen uttana mala ta ooththidayssa inttefe guye yiza yeletay erana. Tani GODAA intte Xoossaa.» ");
INSERT INTO gmvl_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Musey hayssaththo ooththidi GODAA ba7aaleta bonchchiza wogaa Isra7eele asaa erisides. ");
INSERT INTO gmvl_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«Dunkaanezan pacey baynda poo7ana mala ooththanaas wogara miththafe gum7i xillisi kessida zayte Isra7eele dere asay nees ehana mala azaza. ");
INSERT INTO gmvl_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aarooney omars omars xomppeza oyseththo; hessika Gaytoteththa Dunkaaneza giddon diza Caaqo Qaala Taabotazappe sinththa baggara diza magalashaappe kare baggara GODAA sinththan gadey wonttana gakkanaas poo7ishe aqo; hayssi ha wogazi sinththafe yaana yeletaas mernaa woga gido. ");
INSERT INTO gmvl_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Aarooney he xomppeta woththiza walakay baynda worqqafe oosettida ballaza bolla diza xomppeti pacey baynda GODAA sinththan poo7ana mala naago. ");
INSERT INTO gmvl_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«Tammanne nam7u kilo gidiza liiqo dhiille ekkada tammanne nam7u uketh uukka. ");
INSERT INTO gmvl_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Ukeththatappe usuppunata bollara walakay baynda worqqan tiyettida xaraphpheeza bolla issi baggara woththa; qasse hankko usuppunata hankko baggara diza maaddaa bolla maaran maaran woththa. ");
INSERT INTO gmvl_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","GODAAS taman xuugetti yarshettiza kaththa yarsho gididayssa qofsanaas muuruta exaane nam7u baggarakka woththa. ");
INSERT INTO gmvl_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Hayssa ha ukeththaza Sambatan Sambatan ubba wode Aarooney GODAA sinththan Isra7eele asaa gishshas woththo; hayssi Isra7eele asay pacey baynda ooththana mala bessiza caaqo qaala. ");
INSERT INTO gmvl_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Ukeththay Aaroonessinne iza zereththatas gisha gido; istti ukeththaa GODAAS dummatidason metto; hessika GODAAS taman xuugetti shiiqiza yarshotappe keehi dummatida Aaroonessinne iza zereththatas imettida gisha gido.» ");
INSERT INTO gmvl_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Aayi baggara Isra7eele, aawa baggara Gibxe dere as gidida issaadey dees; izikka issi gallas ba diza heeran diza issi Isra7eele as gididaarira ooyettides. ");
INSERT INTO gmvl_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","He aayey baggara Isra7eele as gididayssi ooyettishe GODAA sunth cayides; histtiin izaade Musekko ehida; he addeza aaya Daane baggafe gidida Dibraye naa Shalomito geetettawus. ");
INSERT INTO gmvl_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Istti iza bolla ay qixaate yegganaas bessizaakko GODAY isttas yootana gakkanaas iza qasho keeththan yeggida. ");
INSERT INTO gmvl_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«He addeza asay dizasoppe gede haraso kessa; izi Xoossa cayishin siyida ubbay hessaadey mooro ooththidayssa markkattanaas issoy issoy ba kushe he addeza hu7e bolla woththo; hessafe kaallidi kumeththa Isra7eele derey iza shuchchan caddi wodho. ");
INSERT INTO gmvl_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Tana Xoossaa cayida ay asikka hessaththoka ba qixaate ekko. ");
INSERT INTO gmvl_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","GODAA cayida ay as gidiinkka derey ubbay iza shuchchan caddi wodho; Isra7eele as gidiin woykko Isra7eele dere garsan diza hara dere as gidiin GODAA cayidaadey shuchchan cadetti hayqqo. ");
INSERT INTO gmvl_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","«Ase wodhidaadey oonikka hayqon qaxxayetto. ");
INSERT INTO gmvl_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Asa mehe wodhidaadey iza mala mehe qanxxo; hessi he waagazi shemppo gishshas shemppo qanxxiza woga. ");
INSERT INTO gmvl_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","«Ay asikka hara asa bolla qoho gaththiko izaadey qoho gaththidayssa mala qohoy he gaththidaade bolla gakko. ");
INSERT INTO gmvl_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Meqeth menththidaades meqeththi meqqo; ayfe toyssidaades ayfey to7o; ach menththidaades achchi meqqo; hara asa bolla ay qohokka gaththidaades izi gaththida qohoza malay iza bolla gakko. ");
INSERT INTO gmvl_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Mehe wodhidaadey mehe qanxxo; ase wodhidaadey gidikko hayqon qaxxayetto. ");
INSERT INTO gmvl_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Hayssi wogazi inttes Isra7eele naytas gidiin woykko intte giddon diza hara dere asaa ubbaassa; gaasoykka tani GODAA intte Xoossaa.» ");
INSERT INTO gmvl_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Musey hessa ubbaa derezas yooti polidaappe guye he Xoossaa cayida addeza asi dizasoppe haraso kessidi shuchchara caddi wodhida; hessaththoka Isra7eele asay GODAY Muse azazida mala ooththida. ");
INSERT INTO gmvl_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","GODAY Siina zuma bollan Muse hizgi azazides, ");
INSERT INTO gmvl_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«Ne Isra7eele asaas, ‹Tani inttes immiza biitta intte geliza wode laappunththa laappunththa layththan biitta goyontta shaachchi shempison Xoossa bonchchite. ");
INSERT INTO gmvl_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Usuppun layath kumeth goyitenne zerite; woyne miththay lo7eththi ayfana mala qirxite; ayfekka maxi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Gido attiin laappunththa layththay taas Xoossaas dumma gidiin biittay shemppo demmiza layth gido; he layth biitta goyopite; woyne miththayka ayfana mala qirxofte. ");
INSERT INTO gmvl_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Intte zerontta azabba caarida kaththaa inttes maxi shiishshofte; he layththay biittaya mulera shempiza layththa. ");
INSERT INTO gmvl_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","He layth iza aykkoka goyontta aggikokka biittaya inttes intte aylletasinne inttes miishshara ooththizaytas; qasseka hara dereppe yiidi inttenara diza hara yeletatas mizaaz gido. ");
INSERT INTO gmvl_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Intte mehetassinne intte biitta bolla diza do7atassara meetettizaaz biittaya immana; he iza immizayssi ubbay isttas meetettizaaz gido. ");
INSERT INTO gmvl_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","« ‹Laappunto laappun layth qooda; he layththata qooday oyddu tammanne uddufun layth gidees; ");
INSERT INTO gmvl_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Laappunththo aginay gelidaappe tammanththa gallas bonchchettiza nagarappe maareteththa gallas kumeththa biittaa bolla zaye zayanaade yeddite. ");
INSERT INTO gmvl_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Hessaththoka ichchash tammanththo layththaa dummasi shaakkidi biittay bolla dizaytas ubbaas wozzeteth awajjite; hayssafe kase bayzettida gadey kase bayzidaades woykko izaade qommos simmo; aylleteththan bayzettida aylleyka kase ba asaakko simmo. ");
INSERT INTO gmvl_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","He layth goshshe goyidi zereth zeropite; zereth zerontta coo azabba kaxxida kath woykko qirxettontta ayfida woyne miththa ayfe maxi shiishshofte. ");
INSERT INTO gmvl_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","He layththay kumeth inttes dumma shaakettida layth gido; kase intte zerontta coo barkka kaxxida kath xalla miite. ");
INSERT INTO gmvl_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","« ‹Hayssafe kase bayzettida gadey ubbay he wozzo layththan gadaades simmo. ");
INSERT INTO gmvl_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Hessa gishshas ne asho gidida Isra7eele asaa neni gade bayzidaaz gidikko woykko ne haa nees shammidaaz gidikko gene ooso ooththofa. ");
INSERT INTO gmvl_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Gadeza waagay heregettanaas bessizay sinththafe biittay simmiza layththay gakkanaappe kase he gadey immana dandayza kaththa qoppi hereganaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Layththay daro gidikko heregaykka daro gido; layththay guuth gidikko heregaykka guuth gido; gadey bayzettiza waagay gadezi immiza kaththaa mala gido. ");
INSERT INTO gmvl_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Issi Isra7eele asi hara Isra7eele as qohoppo; intte intte Xoossaas yayyite; tani GODAA intte Xoossaa. ");
INSERT INTO gmvl_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","« ‹Intte intte biittaa bolla saron de7ana mala Xoossa woga ubbaa bonchchite. ");
INSERT INTO gmvl_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Biittaya inttes gidana kath immana; intteka izippe kallana gakkanaas maana; saroteththanka de7ana. ");
INSERT INTO gmvl_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","« ‹Gido attiin laappunththa layththan goshshe goyonttanne kath zerontta maxontta ay maanee?› giidi oychchiza asi dontta aggenna. ");
INSERT INTO gmvl_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Usuppunththa layththatan biittayo anjjana; histtiko iza inttes heedzdzu layththas gidana kath immana. ");
INSERT INTO gmvl_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Osppunththa layththankka goshshe goyishe intte kase shiishshida kaththaa maana; hessa he kaththaa uddufunththa layththan bone kath intte shiishshana gakkanaas izappe maana. ");
INSERT INTO gmvl_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","« ‹Gadey wozzettontta mala bayzanaas bessenna; gaasoykka biittay taassa attiin iza inttes gidukku; intte imaththatanne bete asata mala. ");
INSERT INTO gmvl_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","« ‹Biittay bayzettiko he bayzizaadey he biittaa zaari wozzanayssi erettidaaz gido. ");
INSERT INTO gmvl_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Isra7eele asaappe issaadey metoppe attanaas ba gade bayzikko izas matiza dabboy he bayzettida gadaa wozzo. ");
INSERT INTO gmvl_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Izas wozziza mata dabboy dontta aggiko izaadey gam7ishe miishshe demmidi zaari wozzanaas dandayees. ");
INSERT INTO gmvl_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Hessa wozzanaas izi dandayza wode ba bayzida wodezappe doommidi diza layththaa qoodidi attida layththata miishshaa shammidaades zaaro; hessafe guye kase ba gadeza zaari ekko. ");
INSERT INTO gmvl_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Qasseka gadeza wozzanaas gidiza miishshi izas dontta aggiko izi bayzida gadey wozzettiza layththay gakkanaas shammidaade kushen de7o; wozzettiza layththay gakkishin gadey gadaades simmo; gadaadeyka gede ba gaden simmo. ");
INSERT INTO gmvl_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","« ‹Issi asi gimbey gimbettida katama giddon diza keeth bayzidaa gidikko izi bayzidaappe issi layththa garsan zaari wozzanaas dandayees; izi zaari wozzana dandayzay issi layththa garsan xalla. ");
INSERT INTO gmvl_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Gidikkoka issi layththa garsan zaari wozzanaas dandayontta aggiko hara wode zaari wozzisiza wogay izas deenna; keeththay shammidaades woykko iza naa naas haaro gidi attees; bayzettida miishshay wozzettiza layththankka bayzidaades keeththay simmenna. ");
INSERT INTO gmvl_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Gimbey gimbettontta coo dere garsan diza keeththati bayzettidaappe guye goshsha biitta mala qoodettidi keeththa goday zaari wozzanaas dandayees. ");
INSERT INTO gmvl_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","« ‹Gido attiin Lewe nayti baas imettida katamatan diza ba keeththata ba koyida ay wodekka wozzanaas dandayeettes. ");
INSERT INTO gmvl_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Hayti katamatan issi Lewe qommoy keeth bayzikko qasse zaari wozzanaas izi dandayontta aggiko bayzettida miish wozzo layththan izas simmo; gaasoykka Lewe qommoti ba katamatan keexxida keeththati Isra7eele nayta giddon ay wode gakkanaaska isttassa. ");
INSERT INTO gmvl_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Qasseka istti katamata yuushon diza mehey heemettiza biittay mulekka bayzettofo; he biittay ay wodekka isttassa. ");
INSERT INTO gmvl_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","« ‹Ne bagga Isra7eele asaappe issaadey manqidi bana ayssanaas dandayonttaade gidikko imaththa gidida woykko bete asi ne achchan daana mala ne maaddizayssaththo izakka maadda. ");
INSERT INTO gmvl_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ne bagga gidida Isra7eele asi nenara daana mala izappe dich mooppa; ne Xoossas yayya. ");
INSERT INTO gmvl_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ne izas tal7e immiko izappe dich oychchofa; ne kath izas wodhera bayzoppa. ");
INSERT INTO gmvl_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Nena Kanaane biitta laatissanaas nees GODAA gidanaas Gibxe biittafe kessida Xoossay tana. ");
INSERT INTO gmvl_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","« ‹Ne bagga gidida Isra7eele asaappe issaadey manqoteththaafe dendidayssan aylle mala nees haarettanaas bana bayzikko ne iza aylle mala oosisoppa. ");
INSERT INTO gmvl_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Ne iza ne matan diza imaththa mala woykko miishshas ooththiza oosanchcha mala qooda; izikka ichchashu tammu layth gakkanaas nees ooththo. ");
INSERT INTO gmvl_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Hessafe guye ba naytara neeppe shaaketti gede baso asakkonne ba duussaso simmo. ");
INSERT INTO gmvl_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Isra7eele asaa ta Gibxe biittafe kessida ta oosanchchata gidida gishshas istti aylle mala bayzettofetto. ");
INSERT INTO gmvl_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ne istta wolqqara haaroppa; ne Xoossaas yayya. ");
INSERT INTO gmvl_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","« ‹Nees attumanne macca aylleti de7ana mala koykko ne yuushon diza Ayzaabeta giddofe shamma ekka. ");
INSERT INTO gmvl_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Qasseka intte biittan diza bete asatappenne intte biittan yelettida asatappe shammanaas dandayeeta; istti inttes haaro gidetto. ");
INSERT INTO gmvl_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Heytan intte intte nayta laatissanaas dandayeeta; istti de7iza layththa ubbaan intte naytas ooththizayta gidana; intte qommo gidida Isra7eele as wolqqara haaropite. ");
INSERT INTO gmvl_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","« ‹Intte giddon diza hara dere asaappe issaadey dure gidikko intte bagga gidida Isra7eele naytappe manqo gididay bana hara dere dures woykko izaso asaappe issaades bana aylleteththas aaththi immiko, ");
INSERT INTO gmvl_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","izi bayzettidaappe guye simmidi nam7anththo wozzettanaas dandayees; hessa gishshas iza ishatappe issaadey iza wozzo. ");
INSERT INTO gmvl_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Iza aawaa ishay woykko iza aawaa isha nay woykko izas mata dabbotappe issaadey iza zaari wozzanaas dandayees; izaadey baas gidiza miishshe shiishshidaa gidikko ba miishshara wozzettanaas dandayees. ");
INSERT INTO gmvl_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Izi bana haaridaadera issife gididi izi bana barkka bayzida layththaafe doommidi wozzeteththa layththaa gakkanaas diza layththaa qoodo; iza wozzisiza miishshay he layththata qooda gido; izi bana haarizayssara gam7ida wode waagay issi asi ooththidi demmiza kira miishsha keena gido. ");
INSERT INTO gmvl_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Wozzo layththay gakkanaas buro daro layththati attidaa gidikko ba bayzettida waagaappe he attida layththaa qoodan bana wozziza waagaa qanxxo. ");
INSERT INTO gmvl_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","He attida layththati guuth gidikko ba haarettiin attida layththaa qoodidi bana wozziza waaga qanxxo. ");
INSERT INTO gmvl_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Izi layththafe layth gakkanaas une ooththiza asa mala bana haaridaadera de7oppe attiin iza wolqqara haaranaas bessenna. ");
INSERT INTO gmvl_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","« ‹Hessaththo hanidi wozzettanaas dandayontta aggiko sinththafe yaana aylleteththafe wozzettiza layththan izinne iza nayti mela yedettetto. ");
INSERT INTO gmvl_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Isra7eele asay taas aylletanne tani Gibxe biittafe kessida ta oosanchchata; tani GODAA intte Xoossaa. ");
INSERT INTO gmvl_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","« ‹Intte izas goynnana mala inttes aykkoka eeqa medhdhofte; hessaththoka misle woykko hawulte woykko shuchchafe masetti kezida tuus essofte; tani GODAA intte Xoossaa. ");
INSERT INTO gmvl_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","« ‹Sambata gallassata naagite; ta keeththaa bonchchite; tani GODAA. ");
INSERT INTO gmvl_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","« ‹Intte ta wogan diikkonne ta azazotakka naagikko, ");
INSERT INTO gmvl_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","tani inttes ira wodera bukisana; biittayakka kath darsa immana; ayfe immiza miththatikka darssi ayfana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Intte kaththay keehi daro gidida gishshas intte buro shiisho bolla dishin woyne miththa ayfe qanxxiza wodey gakkana; intte woyne miththa ayfe qanxxidi shiishshi wursontta dishin kath zeriza wodey gakkana; intte kath kalli maana; intte biittankka saroteththan daana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","« ‹Intte biittas saroteth immana; oonaska babbontta intte woppu gi aqana; iita do7ata intte dereppe ta diggana; hayssafe guye intte deren olay deenna. ");
INSERT INTO gmvl_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Intte intte morkketa gooddana; isttika intte sinththan mashshan hayqqana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Inttefe ichchash asi xeetu as, xeetay qasse 10,000 as gooddana; intte morkkey intte sinththan mashshan wurana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","« ‹Tani ta sinth intteko zaarana; histtada inttena darsana; ta inttes gelida caaqo qaalaa naagana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Kaththay inttes layththafe layth gaththana; hessafe dendidayssan oorath gakkida kath gelththanaas zilayththa kaththaafe attidayssa haraso kesseeta. ");
INSERT INTO gmvl_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Tani intte giddon deyana; ta inttena shaatettike. ");
INSERT INTO gmvl_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Tani ubba wode intte giddon simerettana; tani intte Xoos gidana; intteka ta dereta gidana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Intte aylleteththan haarettontta mala Gibxe biittafe inttena kessiday tani GODAA intte Xoossaa; tani intte aylleteththa qambara menththada intte dhoqqu giidi baana mala ooththadis. ");
INSERT INTO gmvl_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","« ‹Gido attiin intte ta gizaaz siyontta ixxiko ha azazota ubbaa ooththontta aggiko, ");
INSERT INTO gmvl_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ta wogaanne ta azazota intte kadhizaa gidikko ta inttenara caaqettida caaqoza intte laalliko, ");
INSERT INTO gmvl_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","he wode tani intte bolla hayssa ehana; gita dagama, gilqateth, ayfe boljesizaaz, asateththa gilqisizaaz qoxo harge ta intte bolla ehana; intte zereth zeranaashin coo mela hada gidana; gaasoykka intte zeridayssa intte morkketi maana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Tani intte bolla hanqon dendiza gishshas intte xoonettana; intte ixxiza intte morkketi inttena haarana; oonikka inttena gooddontta intte intterkka baqatana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","« ‹Hessi wurikka intte bolla gakkidaappe guyekka intte taas azazettontta ixxiko ta intte bolla yeggana qixaateza laappun kushe darsana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Intte otoroteththaa wolqqa ta menththana; inttefe bollara saloza birata mala ooththana; intte biittaaka xarqimalaththo ooththana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Intte wolqqay coo hada wurana; gaasoykka intte biittay kath immenna; miththatikka ayfettenna. ");
INSERT INTO gmvl_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","« ‹Ha7ikka intte taas ixxis giidi azazettontta aggiko tani intte bolla intte nagaraa keena qixaateza laappun kushe darsana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Iita do7ata ta intte giddo yeddana; he do7ati intte nayta wadhdhana; intte miizatakka ubbaa dhayssana; inttefe guuththa asati xalla attana; kase intte hemettiza ogey samana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","« ‹Hayssi ha qixaatezi intte bolla gakkidaappe guyekka intte ta gizayssa siyontta ixxidi ta bolla intte eqeteth darssiko, ");
INSERT INTO gmvl_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","he wode tanikka inttes morkke gidana; intte nagara gishshas ta inttena laappun dakko qaxxayana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Intte tanara caaqqida qaalaa laallida gishshas ta inttena qaxxayanaas intte bolla ola yeddana; intte intte katamatan shiiqiza wode ta intte giddon iita harge kiittana; intte morkketas intte aadhdhi imettana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Intte kaththaa tani dhayssiza wode tammu maccassati wuri issi bashen uukkana; izokka maka miishshan geeddari geeddari ekkana; intteka miidi kalleketa. ");
INSERT INTO gmvl_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","« ‹Hayssi ubbay intte bolla gakkiin intte taas azazettontta ixxidi ta bolla makkalli makkalli biikko, ");
INSERT INTO gmvl_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ta intte bolla hanqon dendana; intte nagaraa gishshas ta inttena laappun dakko qaxxayana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Intte kosha daroppe dendidayssan intte nayta asho maana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Dhoqqasohon diza intte goynniza eeqa xoossata tani dhayssana; intte exaane yarsho izan shiishshizasoza ta laallana; intte ahaa intte eeqata bolla ta yeggana; ta shemppiya inttena shaatettana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ta intte katamata laallana; intte goynnizasota ta kays histtana; sawiza intte yarshoza ta ekkike. ");
INSERT INTO gmvl_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Intte biittaa mulera ta dhayssana; heen diza intte morkketi malalettana gakkanaas biittayo ta asi bayndaso histtana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ta intte bolla ola ehada inttena Ayzaabeta giddon laallana; tani ta mashsha kessada inttena gooddana; intte kawoteththay asi baynda biitta gidana; intte katamatikka laalettana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Intte intte morkketa biittan diza wode intte biittay kays gidiza gishshas shemppo demmada Sambata layththatan ufayettana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Intte biittaya kase intte izin dishin Sambata demmonttaara asay dhayda wode iza shemppo demmana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","« ‹Intte bete biittan dizayti wurikka carkoy qaaththiza qonashe giiris siyidi dagaman piradhdhi baqatana mala ta ooththana; morkkey olason gooddiin woxxiza mala intte woxxana; ay morkkeyka intte achchan baynda intte dhuphetti kundana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Oonikka inttena gooddontta intte intterkka issoy issaara qaxetti kundana; intte intte morkketara eqetti olettanaas dandayekketa. ");
INSERT INTO gmvl_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Intte bete biidi he deren hayqqana; intte intte morkketa kawoteththan mitetti attana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Intte morkketa deren hayqqontta attidayti qasse intte nagaraninne kase intte aawata nagara geedon heen gilqi attana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","« ‹Gido attiin intte taas ammanettontta aggidayssanne ta bolla makkallida intte nagaraanne intte aawata nagaraa intte paaxikko, ");
INSERT INTO gmvl_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","tani inttes morkke gidada inttena gede intte morkketa biitta yeddana mala tana oosisida intte nagaraa intte paaxikko muumida intte wozinaa intte kawushshidi intte nagaraappe intte simmiko, ");
INSERT INTO gmvl_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Abrahaamera, Yisaaqaranne Yaaqoobera ta caaqqida caaqo qaalaa qoppana; biittayokka ta qoppana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Istti yeggi bida gishshas biittaya asi baynda bazzo gidadus; he wode izin asi baynda bazzo gidada ba Sambata ufayssan bonchchana; istti ta wogaanne ta azazoza kawushshida gishshas istti ooththida nagaraa gishshas qaxxayettana. ");
INSERT INTO gmvl_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Gidikkoka istti ba morkketa deren diza wode istta mulera dhayssike gaada ta caaqqida qaalaa mabeekke; ta inttena aggaagikke; ta inttena harassetike; tani GODAA intte Xoossaa. ");
INSERT INTO gmvl_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Tani istta Xoossaa gidana gaada Ayzaabe asay beyishin Gibxe biittafe kessida istta aawatara caaqqida caaqoza ta qoppana; tani GODAA› gees.» ");
INSERT INTO gmvl_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Isra7eele deraas yootana mala Musey Siina zumaa bolla dishin Xoossi izas immida wogati, maaratinne azazoti haytantta. ");
INSERT INTO gmvl_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«Isra7eele asaas, ‹Ay asikka GODAAS as immanaas adinettiin he adinay polettiko he immana gi adinettidayssa wozzanaas adina wogay, ");
INSERT INTO gmvl_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","hessaade layththay nam7u tammaafe biidi usuppun tammu kumida attuma as gidikko GODAA Keeththan erettida meezaanen meezaanettidi ichchash tammu gidiza saqile bira qanxxo. ");
INSERT INTO gmvl_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Macca gidikko heedzdzu tammu saqile bira gido; ");
INSERT INTO gmvl_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","qasseka ichchash layththafe biidi nam7u tammu layth gakkanaas diza attuma naa gidikko nam7u tammu saqile bira, macca naa gidikko tammu saqile bira qanxxo; ");
INSERT INTO gmvl_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","issi aginappe biidi ichchash layth gakkanaas diza attuma naa gidikko ichchash saqile bira qanxxo; he layththata giddon diza macca naas gidikko heedzdzu saqile bira qanxxo. ");
INSERT INTO gmvl_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Hessaththoka layththay usuppun tammaafe bollara diza attuma as gidikko tammanne ichchash saqile bira, macca gidikko tammu saqile bira qanxxo. ");
INSERT INTO gmvl_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Adina adinettidaadey hayssa ha heregettoyssa qanxxanaas dandayontta keehi manqo gidikko izi ba immana gi adinidayssa qeeseza sinth ekki yo; qeesezikka adinettidaade xeelli be7idi izaade wolqqa keena herego. ");
INSERT INTO gmvl_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","« ‹Adina adinettidayssi Xoossas yarshanaas bessiza mehe gidikko hessa mala mehey Xoossas dumma gidida gishshas wozzettenna. ");
INSERT INTO gmvl_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Adina adinettidaadey ba adinettida meheza hara mehen laammofo; gido attiin iitazakka lo7o mehen laammizaa gidikko izi kase ehoyssara nam7ayka Xoossas dummatidayta gidetto. ");
INSERT INTO gmvl_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Izaadey immizayssi Xoossas yarshettanaas bessontta mehe gidikko he meheza ehidaadey meheza qeesekko eho. ");
INSERT INTO gmvl_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Qeesezi he meheza iitateththinne iza lo7eteth caddi xeellidi izi kessana waaga yooto; he izi gida waagay izi gida mala hano. ");
INSERT INTO gmvl_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","He meheza goday meheza zaari miishshara shammana koykko he meheza waaga bolla xeetappe nam7u tammu kushe gujjidi shammo. ");
INSERT INTO gmvl_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","« ‹Issaadey ba keeth GODAAS dumma imota immiko qeeseta halaqay keeththay iitakkonne lo7okko iza hanoteth caddi xeelli heregidi waaga yooto; he qeesezi heregida waagay keeththaas herega gido. ");
INSERT INTO gmvl_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Kase keeththaa goday he keeththaa zaari wozzana koykko heregettida waaga xeetappe nam7u tammu kushe bollara gujjidi keeththaa baas ekko. ");
INSERT INTO gmvl_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","« ‹Issaadey ba gadeppe shaakki GODAAS dumma imota immiko biittay immiza kaththaa mala heregetto; hessika issi kilo bangga gishshas ichchash tammu saqile biray qanxxetto. ");
INSERT INTO gmvl_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Gadeza goday kase gadeza immiday wozzo layththa ba7aaleppe guye gidikko gades kase wodhdhida wogay laamettenna. ");
INSERT INTO gmvl_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Izaadey gadaa immiday ichchash tammanththo layththaafe guye gidikko qeesezi hereganay yiza ichchash tammanththo layth gakkanaas diza attida layththaa qoodidi herego; miishshaafe ashshi ciggo. ");
INSERT INTO gmvl_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Gadeza immidaadey zaari wozzana koykko kase gadezi heregettida waaga bolla xeetappe nam7u kushe gujjidi zaari wozzo. ");
INSERT INTO gmvl_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Kase gadey ba gadaa Xoossafe miishshan wozzanaappe sinththan hara asas bayzidaa gidikko qasse he gadeza nam7anththo zaari wozzana wogay izas deenna. ");
INSERT INTO gmvl_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Wozzo layththan gadey simmiza wode he gadezi gidikko GODAAS dummatidi qeeseta laata gade gidi atto. ");
INSERT INTO gmvl_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","« ‹Issaadey hara asappe shammi ekkida gade Xoossas immana koykko, ");
INSERT INTO gmvl_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","kaalli yiza wozzo layth gakkanaas gadezi kessana waaga qeesezi herego; he gallas he heregettida miish gadaadey qanxxo; he miishshayka Xoossa oosos dummatidaaz gidana. ");
INSERT INTO gmvl_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Wozzo layththa ba7aaley gakkiza wode he gadeza koyro laatan ekkidi bayzidaades gadezi simmo. ");
INSERT INTO gmvl_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","He heregaza waagay GODAA Keeththan erettida meezaanen meezaanettidi nam7u tammu saqile gido. ");
INSERT INTO gmvl_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","« ‹Koyro bayra yelettida mehey izi kasekka GODAAS gidida gishshas oonikka iza Xoossas mela kiyateth immanaas dandayenna; galo mar gidiin woykko dorsanne deysha laaqqati kasetidi Xoossas dummatidayta. ");
INSERT INTO gmvl_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Iza bolla wosoy diza mehenne yarsho shiishshanaas bessontta mehe gidikko he meheza goday iza heregettida waagaa bolla xeetaappe nam7u tammu kushe gujjidi zaari wozzi ekkanaas dandayees; iza goday wozzi ekkanaas koyontta ixxiko he heregettida waagaan hara asas bayzetto. ");
INSERT INTO gmvl_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","« ‹Issaadey ba godaas baas dizayssafe as gidiin woykko mehe, gidiin woykko gade gidiin kumeththara dumma shaakkidaappe guye mulekka bayzanaassinne zaari wozzanaas bessenna. ");
INSERT INTO gmvl_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","« ‹Asa giddofe shaakettidi deyana mala pirdettidaadey wozzettofo; izaadey hayqqanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","« ‹Biittafe mokkiza kath gidiin woykko miththa ayfe gidiin tammaafe issoy Xoossas dummatida asraata. ");
INSERT INTO gmvl_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Hessafe awayssaka baas wozzi ekkanaas koyzaadey he miishshay bayzettiza waagaas xeetappe nam7u tammu kushe gujjidi shammanaas dandayees. ");
INSERT INTO gmvl_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Soo mehetappe tammaafe issay Xoossa gisha; mehey taybettishin tammanththay tammanththay GODAAS dumma shaakettidaaza. ");
INSERT INTO gmvl_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Tammanththa mehey iita gidiin woykko lo7o gidiin dooroppo; woykko harara laammofo; laammizaa gidikko koyroyssinne laame imettidayssara nam7ayka GODAAS dummatidaaz gideettes attiin zaari wozzanaas dandayenna› ga yoota.» ");
INSERT INTO gmvl_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Siina zumaa bolla GODAY Muse baggara Isra7eele asaa azazida azazoti haytantta.");
INSERT INTO gmvl_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Isra7eele asay Gibxeppe kezida nam7anththo layththan nam7anththa aginay doommida koyro gallas istti Siina bazzon dishin GODAY Gaytoteththa Dunkaane giddon Musera gayttidi, ");
INSERT INTO gmvl_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«Attumasaa issaa issaa sunththan sunththan xaafada Isra7eele asaa qommon qommoninne zarkken zarkken qooda. ");
INSERT INTO gmvl_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Neninne Aarooney isttas layththay nam7u tammunne izappe bollara diza oletti dandayana attumasata istta maaran maaran qoodite. ");
INSERT INTO gmvl_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Dumma dumma zarkketappe istta kaaleththiza isttas aawatiza korapinneti inttenara gidetto. ");
INSERT INTO gmvl_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Inttena maaddanayta sunththi hayssafe kaalli dizayta, Oroobeele zarkkefe Shaadure naa Elxuure, ");
INSERT INTO gmvl_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simoona zarkkefe Xurshadaye naa Salum7eele, ");
INSERT INTO gmvl_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Yuhuda zarkkefe Aminadaabe naa Ne7asoone, ");
INSERT INTO gmvl_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Yisakoore zarkkefe Xu7aare naa Natina7eele, ");
INSERT INTO gmvl_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zaabiloone zarkkefe Heloone naa Elyaabe, ");
INSERT INTO gmvl_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Yooseefe naytappe Efreeme qommoti Amihuude naa Elshama Minaase naytappe Pedaxuure naa Gamal7eele, ");
INSERT INTO gmvl_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Biniyaame zarkkefe Gidi7oone naa Abidaane ");
INSERT INTO gmvl_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Daane zarkkefe Amishadaye naa Ahi7ezeere, ");
INSERT INTO gmvl_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Aaseere zarkkefe Okra naa Fagu7eele, ");
INSERT INTO gmvl_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gaade zarkkefe Da7u7eele naa Elyaasaafe, ");
INSERT INTO gmvl_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Niftaaleme zarkkefe Enaane naa Ahire» gi yootides. ");
INSERT INTO gmvl_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Maabaraa garsafe zarkkefe zarkkefe Isra7eele asaa kaaleththanaas doorettida korapinneti haytantta. ");
INSERT INTO gmvl_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Museynne Aarooney hayta bantta sunththan xaafettidayta ekkida. ");
INSERT INTO gmvl_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Nam7anththo aginay doommida koyro gallas maabaraza kumeth issi bolla shiishshidi zarkken zarkkeninne dabbon dabbon shiishshidaappe guye dereza qoodida; yelettiin layththay nam7u tammu kumidaytanne hessafekka bollara gidida attumasaa istta sunththan sunththan mazgabi qoodida. ");
INSERT INTO gmvl_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Hessaththoka Musey GODAY azazida mala Siina bazzon dereza qoodides. ");
INSERT INTO gmvl_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Ola olettanaas dandayzayta layththay nam7u tammaanne hessafekka bollara dizayti bantta zarkkefe zarkkefe qoodettida; addeta qooday hayssafe kaallizayssa; ");
INSERT INTO gmvl_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Oroobeele zarkkefe 46,500, ");
INSERT INTO gmvl_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","Simoona zarkkefe 59,300, ");
INSERT INTO gmvl_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","Gaade zarkkefe 45,650 ");
INSERT INTO gmvl_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","Yuhuda zarkkefe 74,600, ");
INSERT INTO gmvl_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","Yisakoore zarkkefe 54,400, ");
INSERT INTO gmvl_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","Zaabiloone zarkkefe 57,400, ");
INSERT INTO gmvl_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","33","Yooseefe naa Efreeme zarkkefe 40,500, ");
INSERT INTO gmvl_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","35","Yooseefe naa Minaase zarkkefe 32,200, ");
INSERT INTO gmvl_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","Biniyaame zarkkefe 35,400, ");
INSERT INTO gmvl_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","Daane zarkkefe 62,700, ");
INSERT INTO gmvl_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","Aaseere zarkkefe 41,500, ");
INSERT INTO gmvl_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","Niftaaleme zarkkefe 53,400. ");
INSERT INTO gmvl_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Musey, Aarooneynne tammanne nam7u Isra7eele zarkketa korapinneti qoodida attuma asay haytantta; ");
INSERT INTO gmvl_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","olas baana dandayza addeti ubbay isttas layththay nam7u tammanne hessafekka bollara dizayti ba zarkken zarkken qoodettida. ");
INSERT INTO gmvl_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Heyta qooday issi bolla 603,550 gidides. ");
INSERT INTO gmvl_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Gido attiin hankko zarkketara Lewe zarkketi qoodettibeettenna. ");
INSERT INTO gmvl_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Kase GODAY Muses, ");
INSERT INTO gmvl_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Ne Isra7eele attuma asaa qoodashe Lewe zarkketa isttara gaththa qoodoppa. ");
INSERT INTO gmvl_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Lewe zarkketi gidikko Gaytoteththa Dunkaanenne iza giddon go7ettiza miishshaa bolla alaafeteth imma; istti Dunkaanezanne iza giddon go7ettiza miishshata ubbaa tookketto; dunkaana giddon ooththetto; iza yuushon dunkaani uttetto. ");
INSERT INTO gmvl_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Intte kase dunkaani dizasoppe dendi biza wode Lewe zarkketi xalala Dunkaaneza shoddi laallidi istti shempiza ooraththason isttaka tokketto; isttafe attiin dunkaanaakko shiiqiza ay asikka hayqon qaxxayetto. ");
INSERT INTO gmvl_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Hankko attida Isra7eele asay ba butten butteninne ba diza gutan gutan ba bandira bandira tokketto. ");
INSERT INTO gmvl_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Gido attiin ay asikka dunkaanaakko shiiqidi tana hanqeththidi Isra7eele deraa dhaysisontta mala Lewe zarkketi he Dunkaaneza yuushon dunkaanidi naagetto» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Hessa gishshas Isra7eele asay GODAY Muse azazida mala ubbaaka ooththida. ");
INSERT INTO gmvl_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","GODAY Musessinne Aaroones hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«Isra7eele asay ba bagga bagga asaa erisiza malatanne bantta zarkke zarkke erisiza bandira kaallidi Gaytoteththa Dunkaanezappe guuththara haakkidi iza yuushon dunkaano.» ");
INSERT INTO gmvl_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Arshey mokkiza baggara Yuhuda zarkketi uttetto; Yuhuda zarkke kaaleththanay Aminadaabe naa Ne7asoone. ");
INSERT INTO gmvl_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Izi kaaleththiza asaa qooday 74,600. ");
INSERT INTO gmvl_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Yuhuda zarkketappe kaallidi Yisakoore qommoti istta matan dunkaani uttetto; Yisakoore zarkketa kaaleththanay Xu7aare naa Natina7eele. ");
INSERT INTO gmvl_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","He izappe garsara diza asaa qooday 54,400. ");
INSERT INTO gmvl_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Yisakoore zarkketappe kaallidi Zaabiloone zarkketi dunkaani uttetto; Zaabiloone zarkketa kaaleththanay Heloone naa Elyaabe. ");
INSERT INTO gmvl_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Izas diza asaa qooday 57,400. ");
INSERT INTO gmvl_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Ba zarkken zarkken gididi Yuhuda zarkketi dunkaanida baggara uttida asaa qooday kumeth 186,400; asaappe sinth bizay hayssa ha buttezan diza asaa. ");
INSERT INTO gmvl_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Dugeha baggara Oroobeele zarkketi ba baggata erisiza malata garsan dunkaani uttetto; Oroobeele zarkketa kaaleththizay Shaadure naa Elxuure. ");
INSERT INTO gmvl_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Istta qooday 46,500. ");
INSERT INTO gmvl_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Oroobeele zarkketappe kaallidi Simoona zarkketi dunkaani uttetto; istta kaaleththanay Xurshadaye naa Salum7eele. ");
INSERT INTO gmvl_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Istta qooday 59,300. ");
INSERT INTO gmvl_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Isttafe kaallidi Gaade zarkketi dunkaani uttetto; Gaade zarkketa kaaleththanay Era7u7eele naa Elyaasaafe. ");
INSERT INTO gmvl_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Heytantta qooday 45,650. ");
INSERT INTO gmvl_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Istti ba zarkken zarkken gididi Oroobeeley dunkaani uttida baggara dunkaanida asaa qooday kumeth 151,450 gidides; Yuhuda buttezappe kaallidi nam7anththora bizay Oroobeele butteza. ");
INSERT INTO gmvl_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Koyro nam7u buttetappenne wurseththa nam7u buttetappe giddon Lewe baggati Gaytoteththa Dunkaaneza tookkidi betto; issi issi buttey ba qommoy shaaketti erettana mala dumma malata garsan bantta tara tara naagidi betto. ");
INSERT INTO gmvl_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Arshey wulliza baggara Efreeme zarkketi ba baggata erisiza mala garsan dunkaani uttetto; Efreeme zarkke kaaleththanay Amihuude naa Elshama. ");
INSERT INTO gmvl_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Isttas qooday 40,500. ");
INSERT INTO gmvl_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Efreeme zarkketappe kaallidi Minaase zarkketi dunkaanetto; Minaase zarkketa kaaleththanay Pedaxuure naa Gamal7eele. ");
INSERT INTO gmvl_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Istta qooday 32,200. ");
INSERT INTO gmvl_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Isttafe kaallidi Biniyaame zarkketi dunkaani uttetto; Biniyaame zarkketa kaaleththanay Gidi7oone naa Abidaane. ");
INSERT INTO gmvl_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","He istta qooday 35,400. ");
INSERT INTO gmvl_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Istti ba zarkken zarkken gididi Efreeme zarkketi dunkaani uttida baggara dunkaanida asaa qooday 108,100 gidides; Oroobeele butteza kaallidi heedzdzanththon Efreeme buttey bo. ");
INSERT INTO gmvl_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Pudeha baggara Daane zarkketi ba baggata erisiza malata garsan dunkaani uttetto; Daane qommota kaaleththana halaqay Amishadaye naa Ahi7ezeere. ");
INSERT INTO gmvl_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Istta qooday 62,700. ");
INSERT INTO gmvl_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Daane zarkketappe kaallidi Aaseere zarkketi dunkaani uttetto; Aaseere zarkketa kaaleththana halaqay Okra naa Fagu7eele. ");
INSERT INTO gmvl_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Istta qooday 41,500. ");
INSERT INTO gmvl_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Isttafe kaallidi Niftaaleme zarkketi dunkaani uttetto; Niftaaleme zarkketa kaaleththana halaqay Enaane naa Ahire. ");
INSERT INTO gmvl_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Heytantta qooday 53,400. ");
INSERT INTO gmvl_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Istti ba zarkken zarkken gididi Daane zarkketi dunkaani uttida baggara dunkaanida asaa qooday kumeth 157,600 gidides. Hessaththoka Daane zarkketi wurseththan oydanththo maaran betto. ");
INSERT INTO gmvl_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Isra7eele asay bason basoninne ba zarkken zarkken mazgabettidayta qooday issi bolla 603,550 gidides. ");
INSERT INTO gmvl_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Lewe zarkketi gidikko GODAY kase Muse azazida mala hankko Isra7eele asaara qoodettibeettenna. ");
INSERT INTO gmvl_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Hessa malan Isra7eele asay GODAY kase Muse azazida mala ooththida; istta zarkketappe issoy issoy ba bandira bandira kaalli kaalli dunkaani uttides; issoy issoy ba soo asaara issife hemettees. ");
INSERT INTO gmvl_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","GODAY Muse Siina zuma bolla haasayssiza wode Aaroone yeletaynne Muse yeletay hayssafe kaalli dizayssa; ");
INSERT INTO gmvl_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aaroones oyddu attuma nayti deettes; heytikka bayrazi Nadaabe gidishin hankkoyti Abihu, El7ezeerenne Itamaare. ");
INSERT INTO gmvl_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Heyti qeeseteththan ooththana mala tiyettidanne summida. ");
INSERT INTO gmvl_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Gido attiin istta garsafe Nadaabeynne Abihuy Siina bazzon GODAA sinththan bessontta tama ehidi eeththida gishshas GODAA hanqon boshetti hayqqida; Isttas nay baynda gishshas El7ezeereynne Itamaarey xalla istta aawa Aarooney shemppora paxa diza wode ubbaan qeeseteththan ooththida. ");
INSERT INTO gmvl_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Neni Lewe zarkketa shiishshada istti qeese Aaroone ooson maaddana mala woththa. ");
INSERT INTO gmvl_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Istti Aaroonenne kumeththa maabaraa Gaytoteththa Dunkaaneza giddon ooththi maadon ba oosoza ooththi poletto. ");
INSERT INTO gmvl_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Gaytoteththa Dunkaaneza giddon diza ooso miishshatas istta alaafe gidetto; Dunkaaneza giddon Isra7eele asaas oosettiza ooso ooththi poletto. ");
INSERT INTO gmvl_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Isra7eele asaa ubbaafe istti shaakettidi Aaroonenne iza nayta ooson maaddana mala Lewe zarkketa woththa. ");
INSERT INTO gmvl_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Qeeseteththa oosoza istti polana mala Aaroonenne iza nayta ne sunththa; isttafe attiin hara asi hayssa ha oosoza ooththanaas Gaytoteththa dunkaanezakko shiiqizaa gidikko izaadey hayqon qaxxayetto.» ");
INSERT INTO gmvl_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","«Hekko Lewe qommoti taas haggazizayta; tani Gibxe dere asaa bayra wursa wodhida wode Isra7eele asaappe issaafe issaafe yelettida bayranne istta meheta bayrata kumeth taas dummasadis; gido attiin ha7i qasse bayra gidi yelettida attuma nayta sohon Lewe zarkketa tani taas dooradis; istti taas ooththizayta gidana; tani GODAA.» ");
INSERT INTO gmvl_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","GODAY Muses Siina zumaa bolla hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Lewe zareta istta istta zarkken zarkkeninne istta qommon qommon qooda; yelettiin izas issi agina kumidayssanne hessafe bollara diza attuma naa wursaka qooda.» ");
INSERT INTO gmvl_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Museykka GODAY iza azazida mala qoodides. ");
INSERT INTO gmvl_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Lewes heedzdzu attuma nayti deettes; heytikka Gershoone, Qa7aatenne Meraare geetetteettes. ");
INSERT INTO gmvl_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gershoone zarkketi Libinanne Shim7e geetetteettes. ");
INSERT INTO gmvl_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Qa7aate zarkketi Amiraame Yixihaare, Kebroonenne Uzi7eele geetetteettes ");
INSERT INTO gmvl_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Meraare zarkketi Mahilenne Mushe geetetteettes; heytantti ba sunththan sunththan ba keeththa asaas aawatizayta. ");
INSERT INTO gmvl_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Libinanne Shim7e keeththa asay Gershoone zarkken qoodettida. ");
INSERT INTO gmvl_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Yelettiin issi agina gidida naappe doommidi mazgabettida attumasaa qooday 7,500. ");
INSERT INTO gmvl_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gershoone baggati Dunkaanezappe guye baggara arshey wulliza baggara dunkaanida. ");
INSERT INTO gmvl_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Gershoone baggata kaaleththizay La7eele naa Elyaasaafe. ");
INSERT INTO gmvl_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Gaytoteththa Dunkaanen Gershoone zarkketa alaafeteththi, Gaytoteththa Dunkaaneza kamatanne penge bolla qaaphettiza magalashata, ");
INSERT INTO gmvl_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Gibbeza giddo magalashata, Dunkaanezanne yarsho yarshizasoza yuuyi aadhdhida gibbeza pengaa magalasha toletanne hessaththoka heytanttas gidiza miishshata ubbata naago. ");
INSERT INTO gmvl_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Amiraame, Yixihaare, Kebroonenne Uzi7eele soo asay Qa7aate zarkken qoodettida. ");
INSERT INTO gmvl_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Yelettiin issi aginanne hessafe bollara gidida attumasaa qooday 8,600; heytantti Gaytoteththa dunkaaneza naageettes. ");
INSERT INTO gmvl_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Qa7aate zarkketi Gaytoteththa Dunkaanezappe guyera dugeha baggara dunkaanida. ");
INSERT INTO gmvl_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Qa7aate qommota kaaleththiza korapinney Uzi7eele naa Elxafaane. ");
INSERT INTO gmvl_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Istta alaafeteththi Caaqo Qaala Taabotaa bolla, maadda iza bolla woththiza xaraphpheeza bolla, xomppe iza bolla woththizayssa bolla, yarsho iza bolla yarshizayssa bolla, qeeseti dumma qol7azan go7ettiza miishshata bolla, gede Dunkaanezas ubbaafe dummatida giddo qol7a gelizaso baggara diza magalashaa gidishin kumeth hayta ha miishshata bolla isttas naagana alaafeteththi dees. ");
INSERT INTO gmvl_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Lewe zarkke ubbaa halaqay qeese Aaroone naa El7ezeere; izi dummatida qol7an ooththizayta ubbaa bolla alaafe. ");
INSERT INTO gmvl_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Mahile soo asaynne Mushe soo asay Meraare zarkkera issino gidida; heyti Meraare zarkken qoodettida. ");
INSERT INTO gmvl_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Yelettiin issi agina gidida guuththa naappe doommidi qoodettida attumasaa qooday usupun xeetanne nam7u xeeta. ");
INSERT INTO gmvl_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Meraare zarkketa kaaleththizay Xuri7eele naa Abi7eele; istti Gaytoteththa Dunkaanezappe pudeha baggara dunkaani uttida. ");
INSERT INTO gmvl_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Istta alaafeteththi Dunkaaneza toleta, kolatata, tuussatanne tuussata isttan essiza tohota, hessaththoka hara oosos go7ettiza miishshata bollanne heytanttas bessiza oosota ooththana alaafeteththi dees. ");
INSERT INTO gmvl_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Hessaththoka gibbeza yuushon diza tuussata, Dunkaaneza toleta, dhishketanne tole wodorota bolla alaafeteththi dees. ");
INSERT INTO gmvl_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Gaytoteththa Dunkaanezappe arshey mokkiza baggara dunkaani uttanayti Muse, Aaroonenne iza nayta; Gaytoteththa Dunkaane giddon Isra7eele asaa gishshas oosettiza ay ooso gidikkoka he oosoza woga polisiza alaafey istta gidetto; haray oonikka gede Gaytoteththa Dunkaane keeththazakko shiiqikko hayqon qaxxayetto. ");
INSERT INTO gmvl_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","GODAY istta azazida mala Museynne Aarooney yelettiin issi agina gidida naappe doommidi asay ba keeththan keeththan mazgabida Lewe qommotappe attuma nayti kumeth 22,000 gidida. ");
INSERT INTO gmvl_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","GODAY Muses, «Isra7eelen bayra gidi yelettida attuma naytas layththay issi aginanne hessafe bollara gididayta qoodada istta sunththaa xaafa. ");
INSERT INTO gmvl_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Isra7eele asaa bayra nayta ubbaa saama Lewe nayta, hessaththoka Isra7eele asaa mehe bayra ubbaa saama Lewe qommota mehe ekka; Tani GODAA» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Museykka bana GODAY azazida mala Isra7eele asaa garsan bayra gidi yelettidayta ubbaa qoodides. ");
INSERT INTO gmvl_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Istti yelettiin issi aginanne hessafe bollara gidida bayra attuma nayta ubbaa istta sunththan sunththan qoodiin istta qooday 22,273 gidides. ");
INSERT INTO gmvl_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«Hessa gishshas bayra giidi yelettida Isra7eele asaa attuma nayta sohon Leweta ne taas shaakka; hessaththoka Isra7eele asaa mehe bayra sohon Leweta mehe taas dummasa; tani GODAA. ");
INSERT INTO gmvl_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Isra7eele asay yelida bayra nayta qooday Lewe qommotappe 273 gidi dariza gishshas heyta tirpa attuma nayta miishshan wozza. ");
INSERT INTO gmvl_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Issaa issaa wozzanaas Gaytoteththa Dunkaane meezaaneza mala ichchashu Saqile bira ekka; ");
INSERT INTO gmvl_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","He attida wozzo miishshaa Aaroonessinne iza naytas imma.» ");
INSERT INTO gmvl_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Museykka Lewe qommotan wozzettidaytappe bollara tirpida 273 asata gishshas shiiqida wozzo miishshaa ekkides. ");
INSERT INTO gmvl_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Isra7eele asaa bayratappe Gaytoteththa Dunkaane meezaaneza mala miishshaa 1,365 saqile bira ekkides. ");
INSERT INTO gmvl_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","GODAY azazida mala Musey wozzo miishshaa Aaroonessinne iza naytas immides. ");
INSERT INTO gmvl_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","GODAY Musessinne Aaroones hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Lewe nayta giddofe Qa7aate zareta istta soo asaan asaan istta mata dabbon dabbon qooda. ");
INSERT INTO gmvl_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Gaytoteththa dunkaanezan ooththanaas dandayzayta, istta layththi heedzdzu tammaafe biidi ichchashu tammu gakkanaas diza attumasata ubbaa mazgaba. ");
INSERT INTO gmvl_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Istti ooththana oosoy Gaytoteththa Dunkaaneza giddon diza ubbaafe dumma geeshsha miishshata naago gidana. ");
INSERT INTO gmvl_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Asay ba dizasoppe dendi bishin Aarooneynne iza nayti dunkaanezan gelidi Caaqo Qaala Taabotaza sinththan diza magalashaa duge woththidi Caaqo Qaala Taabotaza izan xaaxetto. ");
INSERT INTO gmvl_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Iza kammanaas qaacettida galbaa magalashaza bollara woththidi hessa bolla mulera salo mala kareththa may7o iza bolla miccidi mayzetto; histtidi tooho miththata qalabate lukozan gelththetto. ");
INSERT INTO gmvl_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","«GODAAS shiiqiza dumma ukeththaa iza bolla woththiza gabateza salo misatiza kareththa carqqan kammetto; Gabateza bolla shel7eta, Cilfata, xuu7atanne woyne ushshu duuqqiza miishshatanne uketh ubba wode pacey baynda iza bolla woththetto. ");
INSERT INTO gmvl_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Hessa ubbaa zo7o carqqan kammidi bollara qaacettida galba mayzetto; isttan tookkiza tooho miththata qalabate lukozan gelththetto. ");
INSERT INTO gmvl_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","«Salo misatiza kareththa carqqaza ekkidi xomppe iza bolla woththizayssanne xomppeta, qaphetanne bidinth woththiza kon7ata, hessaththoka zayte woththiza miishshata ubbaa issi bolla kammetto. ");
INSERT INTO gmvl_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Xomppezanne xomppezas koshshiza miishshata ubbaaka iza kammiza galban xaaxidi izara tookkiza halaa bolla woththetto. ");
INSERT INTO gmvl_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","«Kaaleththidi worqqafe oosettida yarsho yarshizayssa bolla salo misatiza carqqan kammidi qaacettida galbaa bollara mayzidi tooho miththata izan gelththetto. ");
INSERT INTO gmvl_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Gaytoteththa Dunkaanen go7ettiza miishshata ubbaa ekkidi salo mala kareththa carqqan kammetto; qaacettida lee7e galba iza bollara kammidi tooho miththaa bolla woththetto. ");
INSERT INTO gmvl_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Bidinththaza yarsho yarshizasoza bollafe pittidi yarsho yarshizasoza ochcha teera misatiza carqqan kammetto. ");
INSERT INTO gmvl_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Yarsho yarshizasozan ooththanaas go7ettiza miishshata heytikka hulaleta, menxota, tama kaashiza miishshatanne guuqa saaneta iza bolla woththetto; qaacettida lee7e galba iza bolla kammidi tooho miththata izan gelththetto. ");
INSERT INTO gmvl_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Istti ba diza heeraappe dendi bishin Aarooneynne iza nayti geeshsha miishshatanne he miishshati isttan go7ettiza miishshata ubbaaka kammidaappe guye Qa7aate nayti yiidi tooketto; gido attiin istti hayqqontta mala he geeshsha miishshata kushen bochchanaas bessenna; hessa gishshas Gaytoteththa Dunkaanezi dendiza wode hessi wurikka Qa7aate nayta alaafeteththa. ");
INSERT INTO gmvl_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","«Qeeseza Aaroone naa El7ezeerey xomppeza zayte lo7o sawo sawiza exaane, ubba wode shiiqiza kaththa yarshozaninne tiyettiza zayteza bolla izas alaafeteththi de7o; hessaththoka Gaytoteththa Dunkaanezanne iza giddonkka diza geeshsha miishshata ubbaa naago.» ");
INSERT INTO gmvl_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","GODAY Musenne Aaroone hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«Qa7aate nayti Lewe qommota giddofe dhayana mala ooththofte. ");
INSERT INTO gmvl_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Gede ubbaafe dumma geeshsha miishshatakko shiiqidi istti hayqqontta mala istta Aarooneynne iza nayti Gaytoteththa Dunkaanen gelidi asaas issaas issaas oosonne izaade tooho shaakki immetto. ");
INSERT INTO gmvl_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Gido attiin istti hayqqontta mala Qa7aate nayti Dunkaaneza giddo gelidi beyanaas guuththa wodeska xeellopetto.» ");
INSERT INTO gmvl_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Lewe zarkketa garsafe Gershoone nayta istta dabbon dabboninne istta yeletan yeletan qooda. ");
INSERT INTO gmvl_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Gaytoteththa Dunkaanezan ooththanaas dandayzayta heedzdzu tammu layththafe biidi ichchashu tammu layth gakkanaas diza attumasata ubbaa qooda. ");
INSERT INTO gmvl_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","«Dumma dumma miishshata tookkana alaafeteththi isttas dees. ");
INSERT INTO gmvl_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Gaytoteththa Dunkaaneza soo baggaranne kare baggara kammiza bollarakka iza bolla kammiza qaacettida lee7e galbaanne geloso pengezakka tookketto. ");
INSERT INTO gmvl_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Hessaththoka Dunkaanezanne yarsho yarshosoho gibbeza yuuyi aadhdhida magalashata, tole wodorota, gibbe gelizaso penge magalashatanne heytantta ooththanaas giigettida miishshatakka istti tookketto; heyta he miishshatas gidiza ay oosokka istti poletto. ");
INSERT INTO gmvl_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Gershoone nayti ooththiza ooso gidiin woykko tooho gidiin Aarooneynne iza nayti istta azazida mala ooththetto; istti tookkanaas bessiza miishshaa kumeth ne isttas gisha imma. ");
INSERT INTO gmvl_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Gaytoteththa Dunkaaneza giddon Gershoone nayta oosoy hessa; istta ooso qeese Aaroone naa Itamaarey xeelli oosiso. ");
INSERT INTO gmvl_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«Lewe zarkkefe gidida Meraare nayta istta zarkken zarkkeninne istta yeletan yeletan qooda. ");
INSERT INTO gmvl_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Gaytoteththa Dunkaane giddon ooththanaas dandayzayta isttas layththay 30 layththafe biidi 50 layth gakkanaas diza attumasata ubbaa qooda. ");
INSERT INTO gmvl_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Istti tookkanaas bessizay Dunkaaneza toletanne toleta giddora gelizayta, tuussata; Dunkaanezi izan tolettiza miishshata. ");
INSERT INTO gmvl_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Hessaththoka Dunkaaneza yuushon diza demban eqqiza tuussata tohota; toleta wodorotanne heyta ubbatas koshshiza miishshata; issi issi asi tookkanaas bessiza miishshay iza sunththan sunththan izas utto. ");
INSERT INTO gmvl_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Qeese Aaroone naa Itamaarey oosoza naagetti oosisanaas Gaytoteththa Dunkaane giddon Meraare nayta soo asaa oosoy hayssa.» ");
INSERT INTO gmvl_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Musey, Aarooneynne dereza halaqati Qa7aate zereththata istta zarkken zarkkeninne istta dabbon dabbon qoodida. ");
INSERT INTO gmvl_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Gaytoteththa Dunkaaneza giddon ooththanaas ooson gelidayta kumeth 30 layththafe biidi 50 layth gididayta qoodida. ");
INSERT INTO gmvl_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Qoodettida asay 2,750 gidides. ");
INSERT INTO gmvl_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","GODAY kase Muse azazida mala Gaytoteththa Dunkaanezan ooththidayti Museynne Aarooney qoodida Qa7aate soo asay haytantta. ");
INSERT INTO gmvl_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Ba zarkken zarkkeninne ba dabbon dabbon qoodettida Gershoone nayti, ");
INSERT INTO gmvl_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Gaytoteththa Dunkaanezan ooththana gelanaas dandayzaytas layththay heedzdzu tammaafe biidi ichchashu tammu layth gakkanaas dizayti wurikka, ");
INSERT INTO gmvl_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","nam7u shiyanne usuppun xeetanne heedzdzu tamma. ");
INSERT INTO gmvl_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","GODAY Muse azazida mala Gaytoteththa Dunkaanezan ooththidaytinne Museynne Aarooney qoodida Gershoone nayti haytantta. ");
INSERT INTO gmvl_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Ba zarkken zarkkeninne ba dabbon dabbon qoodettida Meraare nayti, ");
INSERT INTO gmvl_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Gaytoteththa Dunkaanezan ooththana gelanaas dandayzaytas layththay heedzdzu tammaafe biidi ichchashu tammu layth gakkanaas dizayti wurikka, ");
INSERT INTO gmvl_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","heedzdzu shiyanne nam7u xeeta. ");
INSERT INTO gmvl_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","GODAY Muse azazida mala Gaytoteththa Dunkaanezan haggaziza Museynne Aarooney qoodida Meraare nayti haytantta. ");
INSERT INTO gmvl_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Musey, Aarooneynne Isra7eele halaqati istta qommon qommoninne istta zarkken zarkken qoodida Lewe nayti, ");
INSERT INTO gmvl_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","heedzdzu tammu layththafe doommidi 50 layth gakkanaas dizayti Gaytoteththa Dunkaaneza giddon oosoza ooththanaas ooththiza miishshata tookkanaas gelidayti, ");
INSERT INTO gmvl_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","mulera istta qooday 8,580. ");
INSERT INTO gmvl_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Hessa malan issi issi asi GODAY Muse azazida mala qoodettides; hessaththoka GODAY Muses immida azazo mala issi issi asi tookkanaas alaafeteth ekkides. ");
INSERT INTO gmvl_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«Inchchirachcha hargey iza bolla dizaade woykko iza bollaafe haaththa malay goggizaade woykko aha bochchidi tunidaade ubbaa Isra7eele asay ba diza gutappe kare kessana mala azaza. ");
INSERT INTO gmvl_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Tani isttara diza istta guta istti tunisontta mala heyta geeyontta asata ubbaa adde gidiin macca gidiin intte giddofe kessi gooddite.» ");
INSERT INTO gmvl_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","GODAY Muse azazida mala Isra7eele asay ba gutappe istta kessi gooddides. ");
INSERT INTO gmvl_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«Neni Isra7eele asaas, maccafe gidiin attumasappe ay asikka GODAAS ammanettonttaade gidi beettidi ay asa bollaka qoho gaththiko hessaadey qohanchcha. ");
INSERT INTO gmvl_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Izi ba nagara paaxo; ba qohoza gishshas qanxxettiza miishshaa bolla xeetappe nam7u tammu kushe gujjidi qohettidaades eho. ");
INSERT INTO gmvl_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Gido attiin he qohettidaadey hayqqidaa gidikkonne edaa ekkanaas izas mata dabboy bayndaa gidikko he eday GODAASSA; he edatiza eday qohidaade nagara wursana shiiqiza yarshos immiza dharshozara issife qeesezas imetto. ");
INSERT INTO gmvl_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Hessa malan Isra7eele asay GODAAS immiza dumma imotay wurikka he imotaa ekkiza qeesezas gido. ");
INSERT INTO gmvl_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Issi issi asi GODAAS immiza dumma imotay he imotaa immidaadessa; gido attiin izi qeesezas immizaa gidikko he miishshay qeesezassa.» ");
INSERT INTO gmvl_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Hessafe guye GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«Isra7eele asaappe issaade machcha ba azinaas ammanettontta aggada kare kare giikko, ");
INSERT INTO gmvl_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","hara addera zin7iko, qasseka iza ooththida tuna oosoy qonccontta azinappe geemmidaa gidikko, izi bolla markkattiza asi beettontta aggiin izi tunateththay qonccontta aggiko, ");
INSERT INTO gmvl_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","iza tunida gishshas izi azinay izo sidhanaas dandayees; woykko iza tunontta dishin izi qanaaten kumida gishshas ba machcho sidhana dandayees. ");
INSERT INTO gmvl_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Hessaadey ba machchiyo qeesekko ekki eho; he maccassay gishshas koyettiza issi kilo bangga dhiille yarshos ekki yo; hayssi qanaates shiiqiza kaththa yarshoy qoho qofsizaaz gidiza gishshas zayte iza bolla gussofo; exaanekka iza bolla woththofo. ");
INSERT INTO gmvl_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","«Qeesezi maccassayo efidi GODAA sinththan esso. ");
INSERT INTO gmvl_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Geeshsha haath xaaron duuqqi ekko; Gaytoteththa Dunkaane wuygeppe guuththa biitta ekkidi he haaththaan gujjo. ");
INSERT INTO gmvl_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Qeesezi maccassayo GODAA sinththan esso; izi goosse birsho; qanaates shiiqiza kaththa yarshoza izi kushen woththo; qasse he qeesezi qanggeth ehiza camo haath xaarora ba kushen oykko. ");
INSERT INTO gmvl_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Qeesezi izo hizgi caaqeththo; neni ne azinara dishin hara addey nenara aqontta gidikkonne neni nena tunisontta gidikko qanggeth ehiza hayssi camo haaththay nees gometoppo. ");
INSERT INTO gmvl_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Gido attiin neni ne azinappe hara addera zin7ada tunidaa gidikko, ");
INSERT INTO gmvl_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","‹GODAY nees yela ulo melisonne ne ulo puuriso! Ne dereza garsan nena caaqossinne qanggeththas kesso. ");
INSERT INTO gmvl_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Hayssi haaththazi gede ne bolla giddo gelidi ne uloza puuriso! Nees yela uloza gundiso!› Maccassayakka, ‹Amiin! GODAY ta bolla hessaththo ooththo› ga zaaru. ");
INSERT INTO gmvl_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","«Hessafe guye qeesezi hessa he qanggeththa qaala xaaththa maxaafan xaafo; he xaafoyssaka camo haaththazi diza xaarozan yeggi meecco. ");
INSERT INTO gmvl_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Izi maccassayo iita sako oyththiza camo haaththaa izo ushshanaappe sinththan, ");
INSERT INTO gmvl_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","qeesezi maccassayfe yarsho dhiilleza ekkidi GODAAS yaanne haa qaaseththi shiishshiza dumma yarsho gidana mala yarsho yarshizasoza bolla shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Hessafe guye kaththa yarsho issi zolla dhiille ekkidi qofso yarsho gidana mala yarsho yarshizasoza bolla xuuggo; wurseththan he maccassayo he haaththaa ushsho. ");
INSERT INTO gmvl_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Maccassaya bana tunisada ba azinaas diza ammaneteththaa pacinchchidaa gidikko qanggeth ehiza haaththaa iza uyiza wode izi bolla giddon wolqqama sako ehana; hessika izi uloy puurana; izis yela uloy gundana; izi sunththi izi dereza giddon qanggettidaaz gidi attana. ");
INSERT INTO gmvl_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Gido attiin iza aykko moorokka ooththonttaa gidikko izi bolla aykko qohoykka gakkenna; iza naytakka yelana. ");
INSERT INTO gmvl_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","«Issaadey ba machcho laymateththan sidhiza wode ooththana wogay hayssafe kaallizayssa; iza kare kare gaada hara addera zin7ada tunidaa gidikko, ");
INSERT INTO gmvl_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","woykko issi asi ba machcho coo mela sidhizaa gidikko iza GODAA sinththan eqqana mala ooththo. ");
INSERT INTO gmvl_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Izi azinazikka qohoppe geesh gidana; maccassaya laymata beettidaa gidikko qasse iza ba qohoza gaason ba bolla gakkiza pirda ekkana.» ");
INSERT INTO gmvl_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«Isra7eele asaas, ‹Macca gidiin woykko adde gidiin ay asikka bana GODAAS dummasanaas adina adinettiko, ");
INSERT INTO gmvl_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","hessaadey woyne ushshu woykko hara maththosiza ushshu uyoppo; woyneppe woykko harappe oosettida caala woykko maththosiza ushshu izi uyoppo; woyne miththa ayfeppe tiya gidiin woykko mela gidiin mooppo. ");
INSERT INTO gmvl_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Izi bana dummasidi diza woden woyne miththa hagga bolla diza ayfe gidiin woykko poqo mooppo. ");
INSERT INTO gmvl_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","« ‹Izi naaziraaweteththas adinettida wodey wurana gakkanaas izaade hu7e binana magallay bochchofo; izi bana GODAAS dummasida wodey polettana gakkanaas izi dummatidaade gididi ba hu7e binana dichcho. ");
INSERT INTO gmvl_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Izi naaziraawe gidi diza wode ubbaan hayqqida ahaakko shiiqoppo. ");
INSERT INTO gmvl_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Izi ba Godaas bana dummasida malatay iza hu7e bolla diza gishshas izas aaway woykko aaya woykko izas ishay woykko michcha hayqqiko istta aha bochchidi izi bana tunisoppo. ");
INSERT INTO gmvl_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Izi bana Naaziraawe ooththida wode ubbaan izi GODAAS dummatida asa. ");
INSERT INTO gmvl_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","« ‹Izi qoppontta dishin issaadey iza achchan hayqqidi kase dummati diza iza hu7e binana tunisikko izi laappunththa gallas ba hu7e binana meedetti buluso. ");
INSERT INTO gmvl_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Osppunththa gallas nam7u haraphpheta woykko haraphphe ciyeta Gaytoteththa Dunkaaneza pengen diza qeesezakko eho. ");
INSERT INTO gmvl_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Qeesezikka issi haraphpheza nagara yarshos nam7anththoza qasse xuugettiza yarshos shiishsho; gaasoykka izi aha mata shiiqidi tunida gishshas qeesezi iza nagaraa wursana; he gallassika naaziraawey ba hu7e iskeza nam7anththo GODAAS dummaso. ");
INSERT INTO gmvl_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Izi naaziraaweteththan ooththanaas bana GODAAS nam7anththo dummaso; GODAAS dummatida he iza iskezi tunida gishshas hessafe kase izi naaziraaweteththan gam7ida wodey izas qoodan gelenna; izi ba qohoza gishshas issi layththa dharsho laaqqa eho. ");
INSERT INTO gmvl_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","« ‹Issi naaziraawey ba naaziraaweteththa adina ubba wode izi polana wogay hayssafe kaalli dizayssa; izi gede Gaytoteththa Dunkaanen geliza pengezakko biidi, ");
INSERT INTO gmvl_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","heen ba yarsho GODAAS shiishsho; hessika xuugettiza yarshos issi layth kumida dharsho laaqqa, nagara yarshos issi layth kumida uzzi dors, hessaththoka issifeteththa yarshos wosoy baynda dharsho shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Qasse kaththa yarshonne ushsha yarsho isttara issife yarshanaas eho; he leematezan kaththa yarshoy irshoy izan gelonttayssa gido; qasse liiqo dhiille zayten munuqi uukkida orde ukeththinne zayten tiyettida lee7e uketh eho. ");
INSERT INTO gmvl_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","« ‹Qeesezikka hessa ubbaa nagara yarshonne xuugettiza yarsho ooththidi GODAA sinth shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Dharshozanne leematera irshoy izan gelontta ukeththata issifeteththa yarsho ooththidi GODAAS shiishsho; qasse hessara issife gaththidi kaththa yarshonne ushsha yarsho yarsho. ");
INSERT INTO gmvl_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","« ‹Hessafe guye Gaytoteththa Dunkaanezan geliza penge bolla he naaziraawezi GODAAS adinettida ba hu7e binana meedettidi issifeteththa yarshoy xuugettiza taman yeggo. ");
INSERT INTO gmvl_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","« ‹Bana Godaas dummasida naaziraawey ba hu7e binana meedettidaappe guye qeesezi doysettida dharshoza missa asho, irshoy gelontta uukettida orde ukeththinne lee7e uketh leemateppe ekkidi he naaziraaweza kushen woththo. ");
INSERT INTO gmvl_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Hessafe guye qeesezi ubbaa ekkidi GODAA sinththan yaanne haa qaaseththiza yarsho histti shiishsho; heytikka GODAAS dummatida yarsho; he qaaseththida angasoynne missazi qeesezas gido; hessafe guye naaziraawezi woyne ushshu uyanaas dandayees. ");
INSERT INTO gmvl_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","« ‹Hessa gishshas GODAAS bana dummasanaas adinida naaziraawes wodhdhida wogay bana Godaas yarshanaas koshshiza yarshotappe bollara aaththi geppiko izi qaala gelida mala ba adinaa polanaas bessees ga yoota› gees.» ");
INSERT INTO gmvl_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","GODAY Muses hizgides; ");
INSERT INTO gmvl_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«Aarooneynne iza nayti Isra7eele deraa anjjishe hizgi anjjetto, ");
INSERT INTO gmvl_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‹GODAY nena anjjo; izi nena naago; ");
INSERT INTO gmvl_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","GODAY ba ayfeso poo7o nees qoncciso; izi nees qadhetto. ");
INSERT INTO gmvl_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","GODAY nena ba maaroteththa ayfen xeello; ba saroteththka izi nees immo› gaada yoota.» ");
INSERT INTO gmvl_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Qasseka GODAY, «Istti Isra7eele asaa ta sunththan anjjiza wode tani istta anjjana» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Musey Gaytoteththa Dunkaaneza toli giigida wode Dunkaanezanne izan go7ettiza miishshata ubbaa, yarsho yarshizasozanne izan go7ettiza miishshata tiydi dummasides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Hessafe guye Isra7eele asaa kaaleththizayti, deraa qoodiza wode istta bolla alaafeteththi diza korapinneti wuri ba yarsho yarsho GODAAS shiishshida. ");
INSERT INTO gmvl_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Istti shiishshida yarshoti nam7u nam7u halaqata sunththan issi para-gaare, hessaththoka issi issi halaqa sunththan issi issi boora; he istti shiishshida yarshoti issi bolla usuppun para-gaaretanne tamman nam7u boorata; heyta he yarshotakka Gaytoteththa Dunkaaneza sinththan shiishshida. ");
INSERT INTO gmvl_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«Hayti miishshati Gaytoteththa Dunkaanezan dumma dumma oosos isttan go7ettana mala hayta yarsho miishshata isttafe ekkada, dumma dumma oosos isttas koshshiza mala shaakkada Lewetas imma.» ");
INSERT INTO gmvl_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Hessa gishshas Musey para-gaaretanne boorata ekkidi Lewetas immides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Gershoone zarkketas oosos koshshiza nam7u para-gaaretanne oyddu boorata immides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Qasseka Meraare zarkketas oyddu para-gaaretanne osppun boorata immides; heytantta oosoy polettanay Aaroone naa Itamaare alaafeteththanna. ");
INSERT INTO gmvl_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Isttas diza alaafeteththi geeshsha miishshata ba hashen tookkiza gishshas Musey Qa7aate zarkketas para-gaareta gidiin woykko booratakka immibeenna. ");
INSERT INTO gmvl_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Yarsho yarshizasoza Musey tiydi geeshshida gallas halaqati yarsho yarshizasoza anjjisanaas bantta imota ehidi yarsho yarshizasoza sinththan shiishshida. ");
INSERT INTO gmvl_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","GODAY Muses, «Tammanne nam7u gallassatan tammanne nam7u halaqati pacey baynda issoy issoy issi issi gallas anjjiso ba7aales gidiza yarsho hu7en hu7en shiishshana mala yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Koyro gallas Yuhuda qommota garsafe Aminadaabe naa Ne7asooney shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Izi shiishshida yarshotikka hayssafe kaallizayta; erettida meezaanen woththiin 130 saqile birappe oosettida issi picca saanenne 70 saqile issi guuqa saane, nam7ayka kath yarsho shiishshanaas liiqo dhiillefe zayten munuqettida munuqan kumida. ");
INSERT INTO gmvl_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Izan exaaney kumi uttida 10 saqile worqqafe oosettida cilfa. ");
INSERT INTO gmvl_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Xuugettiza yarshos issi mirgo, issi dharsho, issi layththa dharsho laaqqa, ");
INSERT INTO gmvl_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Nagara yarshos issi deysha orge, ");
INSERT INTO gmvl_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","issifeteththa yarshos 2 boorata, 5 dharshota, 5 deysha orgetanne layth kumida 5 dharsho laaqqata; heyti wuri Aminadaabe naa Ne7asooney shiishshida yarshota. ");
INSERT INTO gmvl_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Nam7anththo gallas Yisakoore zarkketa garsafe Xu7aare naa Natina7eeley shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Izi shiishshida yarshotikka hayssafe kaallizayta, erettida meezaanen woththiin xeetanne heedzdzu tammu saqile birappe oosettida issi picca saanenne laappun tammu saqile guuqa saane, nam7ayka kaththa yarsho shiishshanaas liiqo dhiillefe zayten munuqettida munuqan kumi uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Izan exaaney kumi uttida tammu saqile worqqafe oosettida cilfa. ");
INSERT INTO gmvl_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Xuugettiza yarshos issi mirgo; issi dharsho, issi layththa dharsho laaqqa, ");
INSERT INTO gmvl_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Nagara yarshos issi deysha orge, ");
INSERT INTO gmvl_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","issifeteththa yarshos 2 boorata, 5 dharshota, 5 deysha orgetanne layth kumida 5 dharsho laaqqata; heyti wuri Xu7aare naa Natina7eeley shiishshida yarshota. ");
INSERT INTO gmvl_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Heedzdzanththo gallas Zaabiloone zarkketa garsafe Heloone naa Elyaabey shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Izi shiishshida yarshotikka hayssafe kaallizayta, erettida meezaanen woththiin xeetanne heedzdzu tammu saqile birappe oosettida issi picca saanenne laappun tammu saqile guuqa saane, nam7ayka kaththa yarsho shiishshanaas liiqo dhiillefe zayten munuqettida munuqan kumida. ");
INSERT INTO gmvl_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Izan exaaney kumi uttida tammu saqile worqqafe oosettida cilfa. ");
INSERT INTO gmvl_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Xuugettiza yarshos issi mirgo; issi dharsho, issi layththa dharsho laaqqa, ");
INSERT INTO gmvl_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Nagara yarshos issi deysha orge, ");
INSERT INTO gmvl_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Issifeteththa yarshos 5 boorata, 5 dharshota, 5 deysha orgetanne layth kumida 5 dharsho laaqqata; heyti wuri Heloone naa Elyaabey shiishshida yarshota. ");
INSERT INTO gmvl_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Oydanththo gallas Oroobeele qommota garsafe Shaadure naa Elxuurey shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Izi shiishshida yarshotikka hayssafe kaallizayta, erettida meezaanen woththiin 130 saqile birappe oosettida issi picca saanenne 70 saqile issi guuqa saane, nam7anka kaththa yarsho shiishshanaas liiqo dhiillefe zayten munuqettida munuqay kumi uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Izan exaaney kumi uttida issi tammu saqile worqqafe oosettida cilfata, ");
INSERT INTO gmvl_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Xuugettiza yarshos issi mirgo, issi dharsho, issi layththa dharsho laaqqa, ");
INSERT INTO gmvl_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Nagara yarshos issi deysha orge, ");
INSERT INTO gmvl_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","issifeteththa yarshos 2 boorata, 5 dharshota, 5 deysha orgetanne layth kumida 5 dharsho laaqqata; heyti wuri Shaadure naa Elxuurey shiishshida yarshota. ");
INSERT INTO gmvl_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ichchashanththo gallas Simoona qommota garsafe Xurshadaye naa Salum7eeley shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Izi shiishshida yarshotikka hayssafe kaallizayta, erettida meezaanen woththiin 130 saqile birappe oosettida issi picca saanenne 70 saqile issi guuqa saane, nam7ayka kaththa yarsho shiishshanaas liiqo dhiillefe zayten munuqettida munuqan kumida. ");
INSERT INTO gmvl_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Izan exaaney kumi uttida issi tammu saqile worqqafe oosettida cilfata, ");
INSERT INTO gmvl_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Xuugettiza yarshos issi mirgo, issi dharsho, issi layththa dharsho laaqqa, ");
INSERT INTO gmvl_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Nagara yarshos issi deysha orge, ");
INSERT INTO gmvl_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","issifeteththa yarshos 2 boorata, 5 dharshota, 5 deysha orgetanne layth kumida ichchashu dharsho laaqqata; heyti wuri Xurshadaye naa Salum7eeley shiishshida yarshota. ");
INSERT INTO gmvl_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Usuppunththo gallas Gaade zarkketa garsafe Da7u7eele naa Elyaasaafey shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Izi shiishshida yarshotikka hayssafe kaallizayta, erettida meezaanen woththiin 130 saqile birappe oosettida issi picca saanenne 70 saqile issi guuqa saane, nam7ayka kaththa yarsho shiishshanawu liiqo dhiillefe zayten munuqettida munuqan kumida. ");
INSERT INTO gmvl_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Izan exaaney kumi uttida issi tammu saqile worqqafe oosettida cilfata, ");
INSERT INTO gmvl_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","xuugettiza yarshos issi mirgo, issi dharsho, issi layththa dharsho laaqqa, ");
INSERT INTO gmvl_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Nagara yarshos issi deysha orge, ");
INSERT INTO gmvl_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Issifeteththa yarshos 2 boorata, 5 dharshota, 5 deysha orgetanne layth kumida 5 dharsho laaqqata; heyti wuri Da7u7eele naa Elyaasaafey shiishshida yarshota. ");
INSERT INTO gmvl_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Laappunththo gallas Efreeme zarkketa garsafe Amihuude naa Elshamay shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Izi shiishshida yarshotikka hayssafe kaallizayta, erettida meezaanen woththiin 130 saqile birappe oosettida issi picca saanenne 70 saqile issi guuqa saane, nam7ayka kaththa yarsho shiishshanaas liiqo dhiillefe zayten munuqettida munuqan kumida. ");
INSERT INTO gmvl_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Izan exaaney kumi uttida issi tammu saqile worqqafe oosettida cilfata, ");
INSERT INTO gmvl_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","xuugettiza yarshos issi mirgo, issi dharsho, issi layththa dharsho laaqqa, ");
INSERT INTO gmvl_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","nagara yarshos issi deysha orge, ");
INSERT INTO gmvl_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","issifeteththa yarshos 2 boorata, 5 dharshota, 5 deysha orgetanne layth kumida 5 dharsho laaqqata; heyti wuri Amihuude naa Elshama yarshota. ");
INSERT INTO gmvl_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Osppunththa gallas Minaase zarkketa garsafe Pedaxuure naa Gamal7eeley shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Izi shiishshida yarshotikka hayssafe kaallizayta, erettida meezaanen woththiin 130 saqile birappe oosettida issi picca saanenne 70 saqile issi guuqa saane, nam7ayka kaththa yarsho shiishshanaas liiqo dhiillefe zayten munuqettida munuqan kumida. ");
INSERT INTO gmvl_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Izan exaaney kumi uttida issi tammu saqile worqqafe oosettida cilfata, ");
INSERT INTO gmvl_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","xuugettiza yarshos issi mirgo, issi dharsho, issi layththa dharsho laaqqa, ");
INSERT INTO gmvl_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Nagara yarshos issi deysha orge, ");
INSERT INTO gmvl_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","issifeteththa yarshos 2 boorata, 5 dharshota, 5 deysha orgetanne layth kumida 5 dharsho laaqqata; heyti wuri Pedaxuure naa Gamal7eele yarshota. ");
INSERT INTO gmvl_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Uddufunththo gallas Biniyaame zarkketa garsafe Gidi7oone naa Abidaaney shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Izi shiishshida yarshotikka hayssafe kaallizayta, erettida meezaanen woththiin 130 saqile birappe oosettida issi picca saanenne 70 saqile issi guuqa saane, nam7ayka kaththa yarsho shiishshanaas liiqo dhiillefe zayten munuqettida munuqan kumida. ");
INSERT INTO gmvl_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Izan exaaney kumi uttida issi tammu saqile worqqafe oosettida cilfata, ");
INSERT INTO gmvl_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Xuugettiza yarshos issi mirgo, issi dharsho, issi layththa dharsho laaqqa, ");
INSERT INTO gmvl_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","nagara yarshos issi deysha orge, ");
INSERT INTO gmvl_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","issifeteththa yarshos 2 boorata, 5 dharshota, 5 deysha orgetanne layth kumida 5 dharsho laaqqata; heyti wuri Gidi7oone naa Abidaane yarshota. ");
INSERT INTO gmvl_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Tammanththo gallas Daane qommota garsafe Amishadaye naa Ahi7ezeerey shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Izi shiishshida yarshotikka hayssafe kaallizayta, erettida meezaanen woththiin 130 saqile birappe oosettida issi picca saanenne 70 saqile issi guuqa saane, nam7ayka kaththa yarsho shiishshanaas liiqo dhiillefe zayten munuqettida munuqan kumida. ");
INSERT INTO gmvl_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Izan exaaney kumi uttida issi tammu saqile worqqafe oosettida cilfata, ");
INSERT INTO gmvl_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Xuugettiza yarshos issi mirgo, issi dharsho, issi layththa dharsho laaqqa, ");
INSERT INTO gmvl_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","nagara yarshos issi deysha orge, ");
INSERT INTO gmvl_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","issifeteththa yarshos 2 boorata, 5 dharshota, 5 deysha orgetanne layth kumida 5 dharsho laaqqata; heyti wuri Amishadaye naa Ahi7ezeere yarshota. ");
INSERT INTO gmvl_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Tammanne issinththa gallas Aaseere qommota garsafe Okra naa Fagu7eeley shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Izi shiishshida yarshotikka hayssafe kaallizayta, erettida meezaanen woththiin 130 saqile birappe oosettida issi picca saanenne 70 saqile issi guuqa saane, nam7ayka kaththa yarsho shiishshanaas liiqo dhiillefe zayten munuqettida munuqan kumida. ");
INSERT INTO gmvl_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Izan exaaney kumi uttida issi tammu saqile worqqafe oosettida cilfata, ");
INSERT INTO gmvl_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","xuugettiza yarshos issi mirgo, issi dharsho, issi layththa dharsho laaqqa, ");
INSERT INTO gmvl_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","nagara yarshos issi deysha orge, ");
INSERT INTO gmvl_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","issifeteththa yarshos 2 boorata, 5 dharshota, 5 deysha orgetanne layth kumida 5 dharsho laaqqata; heyti wuri Okra naa Fagu7eele yarshota. ");
INSERT INTO gmvl_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Tammanne nam7anththa gallas Niftaaleme zarkketa garsafe Enaane naa Ahirey shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Izi shiishshida yarshotikka hayssafe kaallizayta, erettida meezaanen woththiin 130 saqile birappe oosettida issi picca saanenne 70 saqile issi guuqa saane, nam7ayka kaththa yarsho shiishshanaas liiqo dhiillefe zayten munuqettida munuqan kumida. ");
INSERT INTO gmvl_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Izan exaaney kumi uttida issi tammu saqile worqqafe oosettida cilfata, ");
INSERT INTO gmvl_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","xuugettiza yarshos issi mirgo, issi dharsho, issi layththa dharsho laaqqa, ");
INSERT INTO gmvl_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","nagara yarshos issi deysha orge, ");
INSERT INTO gmvl_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","issifeteththa yarshos 2 boorata, 5 dharshota, 5 deysha orgetanne layth kumida 5 dharsho laaqqata; heyti wuri Enaane naa Ahire yarshota. ");
INSERT INTO gmvl_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Yarsho yarshizasoza tiydi geeshshida gallas halaqati yarshosoza anjjiso gaason shiishshida imotay haytantta; birappe oosettida 12 picca saaneta, birappe oosettida 12 guuqa saanetanne worqqafe oosettida isttan exaane woththiza 12 kereta. ");
INSERT INTO gmvl_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Birappe oosettida issi issi kerey 130 saqile gidi deexxees; birappe oosettida issi issi quule mala saaney 7 saqile gidi deexxees; birappe oosettida keretinne quule mala saaneti Xoossa Keeththa meezaanen woththiza wode ubbay issi bolla 2,400 saqile gidida. ");
INSERT INTO gmvl_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Worqqafe oosettida exaaney istta kumi uttida tammanne nam7u shaatetti GODAA Keeththa meezaanen woththiza wode issoy issoy 10 saqile gidishin ubbay issi bolla 120 saqile gidides. ");
INSERT INTO gmvl_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Kaththa yarshora issife xuugettiza yarshos shiiqida mehe qooday 12 boorata, 12 dharshotanne layth kumida 12 dharsho laaqqata; qasse istti nagara yarshos shiishshiday 12 deysha orgeta. ");
INSERT INTO gmvl_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Issifeteththa yarshos shiiqida mehe qooday 24 boora, 60 dharsho, 60 deysha orgenne layth kumida 60 dharsho laaqqa; yarsho yarshizasozi tiyetti geeyidaappe guye anjjiso ba7aales imettida imotati haytantta. ");
INSERT INTO gmvl_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Musey GODAARA haasayanaas gede Gaytoteththa Dunkaanezan geliin atoteth demmanaas shiiqizason Taabotaa kama bolla diza nam7u Kirubeta giddora GODAY izas haasayza qaala siyidi izikka izara haasayettides. ");
INSERT INTO gmvl_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","« ‹Neni Aaroones laappun xomppeta istta bolla woththiza wode xomppeti xomppe istta bolla woththiza ballatas sinththa baggara dizaso poo7isana› gaada yoota.» ");
INSERT INTO gmvl_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aarooneykka GODAY Muse azazida mala ooththides; xomppeta istta bolla woththiza ballatappe sinththa baggara dizasoza poo7isana mala giigsi woththides. ");
INSERT INTO gmvl_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Xomppeta istta bolla woththiza ballati garsa tohosoppe doommidi ciishshe misatiza ballata xeera gakkanaas qoxettida worqqafe oosettida; heytikka GODAY Muse bessida mala xomppe istta bolla woththiza ballata leemison oosettida. ");
INSERT INTO gmvl_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Hankko attida Isra7eele deraa garsafe Lewe qommota dumma shaakkada geeshsha. ");
INSERT INTO gmvl_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Geesho wogas giigettida haaththan istta araca; istti bantta bolla diza iske ubbaa meedettanaassinne ba may7oka meeccidi bana geeshshana mala ooththa. ");
INSERT INTO gmvl_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Hessafe kaallidi issi mirgonne kaththa yarshos gidiza liiqo dhiillefe zayten munuqettida munuqa ekki betto; nekka nagara yarshos shiiqiza issi mirgo ekka ba. ");
INSERT INTO gmvl_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Hessafe guye ne Isra7eele asaa shiishshada Leweti Gaytoteththa Dunkaanaas sinththa baggara GODAA sinththan essa. ");
INSERT INTO gmvl_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Isra7eele asaykka Leweta hu7e bolla ba kushe woththo. ");
INSERT INTO gmvl_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aarooney Leweta GODAA ooso ooththanaas giigettidayta gidana mala Isra7eele asaa garsafe yaanne haa qaaseththi shiishshiza yarsho ooththidi istta GODAA sinth shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","«Hessafe guye Leweti ba kusheta he nam7u mirgota hu7e bolla woththetto; issaa nagara wurso yarshos, issaa xuugettiza yarshos ooththada istta maarisanaas GODAA sinththan yarsha. ");
INSERT INTO gmvl_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Leweta yaanne haa qaaseththi shiishshiza yarsho histtada GODAA sinth shiishsha; Aaroonenne iza naytakka istta bolla shuuma. ");
INSERT INTO gmvl_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Hessa malan Leweti tayta gidana mala hankko attida Isra7eele asaa giddofe ne taas istta shaakka. ");
INSERT INTO gmvl_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","«Neni Leweta shaakka geeshshidaappenne yaanne haa qaaseththi shiishshiza yarsho histtidaappe guye istti Gaytoteththa Dunkaaneza giddon ooththana bessiza oosoza polanaas yetto. ");
INSERT INTO gmvl_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Tani istta koyro bayra yelettiza Isra7eele asaa attuma nayta ubbaa gishshas taas dooradis; Isra7eele asaa giddofe istti taas mulera buzo gidana. ");
INSERT INTO gmvl_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Gibxe biittan bayra yelettida asaappe mehe gakkanaas dizayta tani wodhida wode Isra7eele asaa issaa issaa keeththan adde gididi bayra yelettida asaappe mehe gakkanaas dizayta ubbaa taas dummasa shaakkadis. ");
INSERT INTO gmvl_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ha7i qasse Isra7eele asaa bayra attuma nayta gishshas Lewe zarkketa taas shaakkadis. ");
INSERT INTO gmvl_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Istti Isra7eele asaa gishshas gididi Gaytoteththa Dunkaaneza giddon taas ooththana malanne Isra7eele asay gede geeshshasozakko shiiqidi boshan boshettontta mala istta naagana mala Leweta Isra7eele asaa garsafe taas imota mala ekkada Aaroonessinne iza naytas immadis.» ");
INSERT INTO gmvl_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Hessa gishshas GODAY Muse azazida mala Musey, Aarooneynne Isra7eele asay ubbay Leweta dummasi shaakkida. ");
INSERT INTO gmvl_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Leweti meecetti geeyida; ba may7oka meeccida; Aarooney istta yaanne haa qaaseththi shiishshiza yarsho histti GODAA sinth shiishshides; geesho wogaakka istta gishshas polides. ");
INSERT INTO gmvl_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","GODAY Muses Leweta gishshas immida azazoza mala derezi wurikka ooththides; hessa malan Leweti Aaroonenne iza nayta alaafeteththa garsan Gaytoteththa Dunkaaneza giddon ooththanaas giigettida. ");
INSERT INTO gmvl_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","25","«Leweti ooso doommanaas bessiza wogati yelettiin nam7u tammanne ichchashu layththafe biidi ichchashu tammu layth gakkanaas dizayti wuri Gaytoteththa Dunkaaneza giddon ooththetto; ichchash tammu layth kumishin ooththofetto. ");
INSERT INTO gmvl_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Hessafe guye istta ishati Gaytoteththa Dunkaaneza giddon ooththiza wode maaddanaas dandayeettes attiin barkka xalla diikko ay oosokka ooththofetto.» ");
INSERT INTO gmvl_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Isra7eele asay Gibxeppe kezida nam7anththo layththan koyro aginan GODAY Muses Siina bazzon hizgi yootides, ");
INSERT INTO gmvl_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«Isra7eele asay Paaziga ba7aaleza izi bonchchettiza woden bonchcho; ");
INSERT INTO gmvl_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","hayssa ha aginazan tammanne oydanththo gallassa omars wogaa malanne diza maaraa mala bonchcho.» ");
INSERT INTO gmvl_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Hessa gishshas Musey Paaziga ba7aaleza asay bonchchana mala yootides. ");
INSERT INTO gmvl_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Isttika koyro aginay gelida tammanne oydanththo gallas gadey qammishin Siina bazzon Paaziga ba7aaleza bonchchida; Isra7eele asay GODAY Muse azazida mala ubbaa ooththida. ");
INSERT INTO gmvl_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Gido attiin istta garsafe hayqqida aha bochchida gishshas tunida asati istta giddon diza gishshas he gallas Paaziga ba7aaleza bonchchanaas dandaybeettenna; hessa gishshas istti Musekkonne Aaroonekko shiiqidi, ");
INSERT INTO gmvl_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Muses, «Nuni aha bochchidi tunidos shin hankko Isra7eele asaappe dummason nuni iza woden GODAAS yarsho shiishshontta mala aazas digettizonii?» gida. ");
INSERT INTO gmvl_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Museykka isttas, «Tani GODAAPPE izi intte gishshas azazizayssa siyana gakkanaas naagiishshite» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«Neni Isra7eele asaas, ‹Inttefe gidiin woykko intte zereththafe asay aha bochchidi tunikko woykko oge bidaa gidikko izaadey GODAA Paaziga ba7aale bonchchanaas dandayees. ");
INSERT INTO gmvl_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Hessika nam7anththo aginay gelida tammanne oydanththo gallas gadey qammishin bonchchanaas dandayees; istti bonchchishe Paaziga dorsaa irshoy gelontta uketh camo miththa hayththara meto. ");
INSERT INTO gmvl_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Gadey wonttana gakkanaas he kaththaafe aykkoka ashshofetto; shukettida meheza meqeththafe issineyokka menththofetto; isttas imettida wogaa mala ba7aaleza bonchchetto. ");
INSERT INTO gmvl_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Geesh gididinne oge bontta asi oonikka Paaziga ba7aaleza bonchchiza gallas bochchonttaadey ta deraappe shaaketto; izi yarshoza bessiza woden yarshontta aggida gishshas ba nagaraas bessiza qixaate ekko. ");
INSERT INTO gmvl_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","« ‹Intte giddon beti yida hara dere asi GODAA Paaziga ba7aaleza bonchchana koykko diza wogaa mala ubbaa poli bonchchanaas bessees; deren yelettidayssa gidiin asa biitta as gidiin hayssa wogaza issi mala polo› gaada yoota.» ");
INSERT INTO gmvl_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Gaytoteththa Dunkaanezi tokettida gallas shaarazi Dunkaaneza goozi oykkides; omarsafe biidi gadey wonttana gakkanaas Dunkaaneza bolla tama misatiza shaaray kammi oykkides. ");
INSERT INTO gmvl_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Gallas gallas shaaray kammi oykkees; he shaarazikka omars omars tama mala poo7ees. ");
INSERT INTO gmvl_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Shaarazi Dunkaaneza bollafe dendiza wode ubbaan Isra7eele asay ba dunkaani dizasoppe dendi bees; shaarazi eqqiza wode asaykka ba dizason dunkaani uttees. ");
INSERT INTO gmvl_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Isra7eele asay ba dizasoppe dendi biza wode gidiin istti harason dunkaani uttiza wode GODAY istta azazida mala haneettes; shaarazi Dunkaaneza bolla wodhdhidi kammi oykkida wode ubbaan istti bantti dunkaani uttidasohon gam7eettes. ");
INSERT INTO gmvl_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Shaarazi Dunkaaneza bolla daro gallas gam7ikokka istti GODAAS azazeteththan heen ba dunkaani dizason gam7eettes attiin awakka qaaxxettenna. ");
INSERT INTO gmvl_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Issi issi wode shaarazi Dunkaaneza bolla guuththa gallassata xalla gam7ees; gidikkoka heen gadaan istti gam7iko woykko gede sinththe biikko GODAY istta azazida mala haneettes. ");
INSERT INTO gmvl_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Shaarazi issi issi wode gadey wonttana gakkanaas xalla gam7ees; gadey wontishin shaarazi dendida mala heerakka hemeth doommeettes; woykko shaarazi gallas gidiin omars dendiza wode isttika dendi beettes. ");
INSERT INTO gmvl_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Nam7u gallas gidiin woykko issi agina gidiin woykko issi layththika gidiin hessafekka adussa wode shaarazi Dunkaaneza bolla kammi uttida wode ubbaan isttika bantti dunkaani dizasoppe qaaxxettenna; gido attiin shaarazi dendi biza wode isttika dendi hemeth doommeettes. ");
INSERT INTO gmvl_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Istti dunkaani uttizay woykko ba dizasoppe dendi bizay GODAY Muses immida azazoza mala. ");
INSERT INTO gmvl_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Dereza issi bolla shiishshanaas gidiin woykko asay dunkaani dizasoppe denththeththanaas punniza nam7u zayeta birappe qoxxa kessa. ");
INSERT INTO gmvl_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Nam7u zayeti punettiza wode kumeththa maabaray Gaytoteththa Dunkaaneza pengen ne dizaso shiiqo. ");
INSERT INTO gmvl_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Issi zayey zayettiza wode gidikko Isra7eele asaappe korapinneti xalla neekko shiiqetto. ");
INSERT INTO gmvl_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Zayeza dhoqqu histti zaykko arshey mokkiza baggara dunkaani uttida asay koyro hemeth doommo. ");
INSERT INTO gmvl_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Ne zayeza nam7anththo dhoqqu histta punniza wode dugeha baggara dunkaani uttida asay hemeth doommo; zayey dhoqqu gi zayetiza wode asay hemeth doommanaas malata gido. ");
INSERT INTO gmvl_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Deraa issi bolla shiishshanaas zayeta dhoqqisontta ziqqi histta zaya. ");
INSERT INTO gmvl_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Qeese gidida Aaroone nayti zayeta punnetto; hessika inttes naa naa gakkanaas eqqi diza woga gido. ");
INSERT INTO gmvl_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","«Intte deraa bolla worajjida intte morkketara intte olettanaas keziza wode zayeta dhoqqu histti punnite; histtiko GODAA intte Xoossay inttena qoppananne intte morkketappe inttena ashshana. ");
INSERT INTO gmvl_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Hessaththoka intte ufayssa ba7aale gallas, hessika agina ba7aaletanne dumma dumma intte bonchchanaas qachchida ba7aaleta bonchchiza wode xuugettiza yarshonne issifeteththa yarshota shiishshiza wode zayeta punnite; heyti Xoossa sinththan inttena qofsana; tani GODAA intte Xoossaa.» ");
INSERT INTO gmvl_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Derezi Gibxe dereppe kezida nam7anththo layththan nam7anththo aginay gelida nam7u tammanththo gallas Markkateththa Dunkaanezappe bollara diza shaarazi dendides. ");
INSERT INTO gmvl_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Isra7eele asay Siina bazzofe dendidi shaarazi Paaraane bazzon eqqana gakkanaas dumma dummason shempida. ");
INSERT INTO gmvl_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Isra7eele asay GODAY kase Muse azazida azazoza mala koyro yuusho hemeth doommides. ");
INSERT INTO gmvl_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Yuhuda qommota bandira garsan diza Aminadaabe naa Ne7asooney kaaleththiin ba butte tara naagidi koyro bida. ");
INSERT INTO gmvl_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Yisakoore zarkketa kaaleththizay Xu7aare naa Natina7eele. ");
INSERT INTO gmvl_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Zaabiloone zarkketa kaaleththizay Heloone naa Elyaabe. ");
INSERT INTO gmvl_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Hessafe guye dunkaanezi shodettiin Dunkaaneza tookkidayti Gershoone qommotinne Meraare zarkketi buus doommida. ");
INSERT INTO gmvl_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Istta kaallidi Oroobeele zarkketa bandira garsan dizayti Shaadure naa Elxuurey kaaleththiin ba tara naagidi bida. ");
INSERT INTO gmvl_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Simoona zarkketa kaaleththizay Xurshadaye naa Salum7eele. ");
INSERT INTO gmvl_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gaade zarkketa kaaleththizay Da7u7eele naa Elyaasaafe. ");
INSERT INTO gmvl_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Hessafe guye Lewe bagga as gidida Qa7aate zarkke gididayti geeshsha miishshata tookki ekkidi bida; istti baappe sinththa baggan diza heeraza gakkanaappe kase Xoossa dunkaanezi toletti uttees. ");
INSERT INTO gmvl_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Hessafe kaallidi Efreeme zarkketa bandira garsan dizayti Amihuude naa Elshamay kaaleththiin ba tara naagidi bida. ");
INSERT INTO gmvl_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Minaase zarkketa kaaleththizay Pedaxuure naa Gamal7eele. ");
INSERT INTO gmvl_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Biniyaame zarkketa kaaleththizay Gidi7oone naa Abidaane. ");
INSERT INTO gmvl_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Wurseththan ha butteta guye tuchchan naagiza Daane zarkketa bandira garsan dizayti ba tara naagidi bida; Daane qommota kaaleththizay Amishadaye naa Ahi7ezeere. ");
INSERT INTO gmvl_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Aaseere zarkketa kaaleththizay Okra naa Fagu7eele; ");
INSERT INTO gmvl_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Niftaaleme zarkketa kaaleththizay Enaane naa Ahire. ");
INSERT INTO gmvl_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Hessa gishshas Isra7eele asay kase ba dizasoppe kezidi ba butten butten biza buussaa maaray hayssa mala. ");
INSERT INTO gmvl_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Musey ba machchey aawa Midiyaame dere as Era7u7eele naa Hobaabes, «Hekko nuni GODAY nuus immanaas kase caaqqida dere baanaas giigettidos; GODAY Isra7eele asaa duresanaas kase nuus caaqqi woththides; hessa gishshas nekka nunara hedhdha; nuni nees lo7o ooththana» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobaabey, «Akkay! Kase tani yelettida derenne ta dabbotakko simma baana» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Musey izas, «Ne nuuppe shaaketta booparkkii! Nuni hayssa bazzo biittan bishe awan awan shempana bessizaakko neni eraasa; neni nuna oge kaaleththiza as gidana. ");
INSERT INTO gmvl_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Neni nunara biikko GODAY nuus immiza lo7o miishsha ubbaafe nu nees shaakki immana» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Derezi geeshsha zumay diza Siina bazzo yeggidi heedzdzu gallassa oge bides; heedzdzu gallassatan GODAA Caaqo Qaala Taabotazi asay shempanaaso koyanaas asappe sinththati bides; istti kase ba diza heeraa yeddanaappe kasetidi asay shempanaaso koyanaas Caaqo Qaalaa Taabotazi isttafe sinththan sinththan bides. ");
INSERT INTO gmvl_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Istti ba dizasoppe dendi dendi bishin GODAA shaaray gallas gallas istta kammi oykkees. ");
INSERT INTO gmvl_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Caaqo Qaalaa Taabotay baana dendishin dendishin Musey, «GODAWU! Nekka denda; ne morkketi laalettetto; nena ixxizayti wurikka ne sinththafe kichchetto!» gees. ");
INSERT INTO gmvl_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Caaqo Qaala Taabotazi issiso gakki eqqiza wode, «Ta GODAWU! Daro shiyan qoodettiza Isra7eele asaakko ne ayfeso haa zaara» gees. ");
INSERT INTO gmvl_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Isra7eele asay ba bolla gakkida meto ubbaa gishshas GODAA bolla zuuzumides; GODAY asaa zuuzunththaa waasoza siyidi keehi hanqettides; istta bollaka xuuggiza tama yeddides; he GODAA tamay asay dunkaani uttidasohoppe gaxara amardayssa mides. ");
INSERT INTO gmvl_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Asaykka bana GODAARA giigsana mala Musekko waassides; Museykka GODAA woossiin tamazi to7ides. ");
INSERT INTO gmvl_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Xoossa tamay heen istta giddon eexxida gishshas he sohoy, «Tabeere» geetettides. ");
INSERT INTO gmvl_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Isra7eele asaara walaketti kezidi biza hara dumma dumma dere asay asho maanaas daro amottides; Isra7eele asaykka, «Nuni maana asho awappe demminoo! ");
INSERT INTO gmvl_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Kase nu Gibxen diza wode aykko miish qanxxontta coo mela miza mole ashoy, lelehey, lelehe misatiza habbihabbey, dono misatiza kuraatey, sunkurtoynne tuumoy nuna laamoththees. ");
INSERT INTO gmvl_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ha7i gidikko manna xallay nuna saleththides; qoodheykka kath ixxides; mannafe attiin hara nu be7iza kaththi baawa» gi yeekkides. ");
INSERT INTO gmvl_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mannay deebbo ayfe mala guuththa; izas medhay booxxi ekkiza shida mala gididi galal7o misatees. ");
INSERT INTO gmvl_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Asay hessa yuuyi yuuyi maxees; iza woxan gaaccidi woykko udulan caddidi guuththa xaaron munuqidi uukkees; mishin izi doonan zaytera gindetti uukettida ukeththa mala mal7ees. ");
INSERT INTO gmvl_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Omars omars istti dunkaani dizaso heeran xaazay wodhdhishin mannay izara issife wodhdhees. ");
INSERT INTO gmvl_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Derezi wurikka ba dunkaane pengen pengen baso asaara asaara eqqidi yeekkishin Musey siyides; Xoossi istta bolla hanqettida gishshas Musey keehi ceecides. ");
INSERT INTO gmvl_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Izi GODAA, «Hayssa deexo meto nees aylle gidida ta bolla ays ehadii? Neni hayssa ha dereza ubbaa deexo tooho tana ne toossanaas ta nena ay mishisadinaa? ");
INSERT INTO gmvl_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Buro dhanth dhammiza naa dichchiza he guuththa naaza idimmiza mala tani istta idimmada neni kase aawatas caaqqida biittaa gaththana mala ne tana ooththizay haytantta wursa shaariday tanee? Woykko istta ta yeladinaa? ");
INSERT INTO gmvl_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Istti tana, ‹Nuus asho imma› giidi taakko yiidi yeekkiza gishshas hayssa asaa ubbaas gidana asho ta awappe ehoo? ");
INSERT INTO gmvl_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Tani tarkka hayssa deraa kaaleththanaas dandaykke; hayssi alaafeteththazi tana keehi deexxides. ");
INSERT INTO gmvl_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ne tana hayssaththo waayisanaappe tani meto be7ontta mala ne taas mishettizaa gidikko ne tana ha7i wodhidaakko taas lo7o» gi woossides. ");
INSERT INTO gmvl_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","GODAY Muses, «Dereza ayssana dandayza erettida laappun tammu cimata doora; neni istta shiishshada Gaytoteththa Dunkaanezakko ehada ne achchan essa. ");
INSERT INTO gmvl_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Tanikka hee wodhdhada nenara haasayana; tani nees immida ayanaappe isttas shaakka immana; hessafe guye istti dereza nees diza alaafeteththaafe shaakki ekkidi dereza tooho tookki nena maaddana; hayssafe guye hayssa alaafeteththaa ne xalla tookkaka. ");
INSERT INTO gmvl_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ha7ikka derezas, ‹Wontos inttena geeshshite; inttes maana ashoy daana; intte nuni maana asho nuus oonee immanay giidi yeekkidayssanne nuus Gibxey lo7o gidayssa GODAY siyides; hekko ha7i inttes GODAY asho immana; intteka iza maandeta. ");
INSERT INTO gmvl_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Intte asho maanay issi gallas woykko nam7u gallas woykko ichchashu gallas woykko tammu gallas woykko nam7u tammu gallas xalla gidenna. ");
INSERT INTO gmvl_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Izi inttena saleththidi inttes siidhera kezana gakkanaas agina kumeth intte iza maana; hessika hananay intte hayssa intte giddon diza GODAA kadhida gishshassinne nuni Gibxeppe kase kezontta aggidaakko nuus lo7okkoshin giidi intte yeekkida gishshassa› » gides. ");
INSERT INTO gmvl_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Musey GODAAS, «Hekko ha7i tani kaaleththizay usuppun xeetu shii asa; ‹Neni aginas gidana asho isttas immana› gaada qaala geladasa. ");
INSERT INTO gmvl_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Histtiin hayssa asaas ay keena mehey shukettiin gidanee? Abba giddon diza moley ubbay issi bolla shiiqidaakko gidandee?» gi oychchides. ");
INSERT INTO gmvl_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","GODAY Muses, «Taas Xoossas wolqqay guuththee? Ta qaalay intte achchan polettanaakkonne agganaakko ne ha7i be7ana» gi zaarides. ");
INSERT INTO gmvl_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Hessa gishshas Musey kezidi GODAY izas gidayssa ubbaa derezas yootides; dereza kaaleththizaytappe laappun tammu as issiso shiishshidi dunkaaneza yuushon essides. ");
INSERT INTO gmvl_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","GODAYKKA shaarara wodhdhidi izas yootides; Muses immida ayanaappe shaakkidi deraa kaaleththiza laappun tammu cimata bolla woththides; ayanay istta bolla wodhdhiin istti bantta qaala dhoqqu histtidi nabeta mala tinbite haasayda; istti hessa nam7anththibeettenna. ");
INSERT INTO gmvl_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Mazgabettida laappun tammu deraa kaaleththizayta giddofe nam7ati Eldaadenne Medaade geetettizayti gede Dunkaanezakko bontta bantti diza heeran gam7ida; istti heen dishin ayanay istta bolla wodhdhiin isttika ba qaala dhoqqu histtidi nabeta mala tinbite haasayda. ");
INSERT INTO gmvl_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Issi naateththa asi Musekko woxxi biidi, «Eldaadeynne Medaadey heen bantta heeran dishe tinbite haasayeettes» gi yootides. ");
INSERT INTO gmvl_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Naateththafe doommidi Muse ooththi maaddiza Nawe naa Iyaasoy, «Ta godaa Musee! Haytanti tinbite haasayontta mala teqqa!» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Museykka izas, «Ne taas mishettada hessa gay? Tani gidikko Xoossi hayssa deraa ubbaa bolla ba ayana woththikonne ubbayka ba qaala dhoqqu histtidi nabeta mala tinbite haasaydaakko hessi taas ufayssa!» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Museynne Isra7eele asaa kaaleththiza laappun tammu asay gede ba dizaso simmides. ");
INSERT INTO gmvl_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Hessafe guye GODAY carko denththidi abba giddofe kuracho misatiza kafo asay dunkaani uttida heera ehides; histtidi he kafota biittafe pude nam7u wadha keena dhoqqu giidi piradhdhi yiidi asay dunkaani uttida heera yuushon issi gallassa oge keena gidizaason biitta bolla may7i uttida. ");
INSERT INTO gmvl_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Hessa gishshas he gallassinne omars, hessaththoka wonteththa gallassika derezi he kafota oykki shiishshides; issi asikka tammu kiloppe pace oykkibeenna; izikka melana mala ba dunkaanida heera yuusho ubbaan miccida. ");
INSERT INTO gmvl_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Gido attiin istti buro coommi mittontta dishin GODAY deraa bolla keehi hanqettides; GODAY gita boshakka deraa bolla yeddides. ");
INSERT INTO gmvl_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Asho amottidi hayqqida asaa heen gadaan moogida gishshas he gadeza sunththi, «Kibroote-Hatta7aabe» geetettides. ");
INSERT INTO gmvl_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Asay Kibroote-Hatta7aabe gede Haxiroote biidi heen dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Musey Tophphiyappe machcho ekkida gishshas Maaramanne Aarooney zigirsan iza hizgi kadhida, ");
INSERT INTO gmvl_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","«GODAY Muse baggara xalla haasaydee? Nu baggara haasaybeennee?» GODAY istti gidayssa ubbaaka siyides. ");
INSERT INTO gmvl_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Musey gidikko biitta bolla diza asaa ubbaafe aadhdhida ashke asa. ");
INSERT INTO gmvl_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Heerakka GODAY Muse, Aaroonenne Maaramo, «Intte heedzdzay Gaytoteththa dunkaanekko haa yiite!» gides; isttika bida. ");
INSERT INTO gmvl_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Histtiin GODAY tuus misatiza shaara giddora wodhdhidi Dunkaaneza pengen eqqidi, «Haysso Aaroone! Hanne Maaramee!» gi xeygides; Nam7atikka gede iza sinth shiiqida. ");
INSERT INTO gmvl_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","GODAY isttas, «Hekko ha7i ta inttena gizayssa akeeki siyite! «Intte giddon nabeti diikko, tani tana isttas ajjuutan qonccisays; agumon istta haasayssays. ");
INSERT INTO gmvl_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Tani taas haggaziza Musera gidikko hessa malan haasaykke; izi ta keeththan ammanettida asa. ");
INSERT INTO gmvl_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Hessa gishshas tani izara sinththan qonccera haasayays attiin guyera qotan haasaykke; izi ta medha beyees; histtiin intte ta oosanchchaza Muse bolla waani yayyontta kadhe qaala haasaydetii?» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","GODAA hanqoy istta bolla tama mala eexxi kezides; izikka istta heen aggi bides. ");
INSERT INTO gmvl_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Shaarazi dunkaaneza bollafe dendi biin Maarama inchchirachcha harganchcha gidadus; inchchirachcha hargezikka izi bolla shachcha mala booththides; Aarooney Maaramo beyishin iza izas inchchirachcha harganchcha gida beettadus. ");
INSERT INTO gmvl_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aarooney Muses, «Ta godoo! Nuni ne bolla ooththida nagaraa gaason hayssi iita qixaatey nu bolla polettana mala ooththofarkkii! ");
INSERT INTO gmvl_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Izakka ba aayi ulon hayqqada izis bagga asateththay meetettichchiin yelettida awucaya naa mala ooththofarkkii!» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Hessa gishshas Musey, «Xoossawu! Izo paththarkkii!» giidi pude GODAAKKO waassides. ");
INSERT INTO gmvl_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","GODAYKKA Muses, «Izi aaway ayfeson cuch cuttidaarakka yeellatada laappun gallas gakkanaas gam7a erekkee? Hessa gishshas iza asay diza heeraappe kezada laappun gallas gakkanaas asi bayndason takkaashshu; hessafe guye asay dizaso gelanaas dandayawus» gi zaarides. ");
INSERT INTO gmvl_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Hessa gishshas Maarama asi diza gutappe kare kezada laappun gallas gakkanaas bana genththadus; iza heeppe simmana gakkanaas derezi ba dizasoppe haraso qaaxxibeenna. ");
INSERT INTO gmvl_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Hessafe guye asay Haxirooteppe dendidi Paaraane bazzon dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«Tammanne nam7u Isra7eele asaa garsafe dere kaaleththizayta doorada tani Isra7eele asaas immana gida Kanaane biittayo xomosi xeellidi yaana mala yedda.» ");
INSERT INTO gmvl_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Museykka GODAY iza azazida mala Isra7eele asaa kaaleththizayta giddofe Paaraane bazzofe tammanne nam7u asata yeddides. ");
INSERT INTO gmvl_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","He asata sunththayka hayssafe kaallizayssa; Oroobeele zarkkefe Zakure naa Shaamu7e, ");
INSERT INTO gmvl_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simoona zarkkefe Hoore naa Saafaaxe ");
INSERT INTO gmvl_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Yuhuda zarkkefe Yoofine naa Kaalebe, ");
INSERT INTO gmvl_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Yisakoore zarkkefe Yooseefe naa Yigi7aale, ");
INSERT INTO gmvl_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efreeme zarkkefe Nawe naa Hose7e, ");
INSERT INTO gmvl_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Biniyaame zarkkefe Eraafo naa Palixe, ");
INSERT INTO gmvl_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zaabiloone zarkkefe Sade naa Gadu7eele; ");
INSERT INTO gmvl_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Yooseefe zarkkefe Minaase bagga gidida Suse naa Gaadeye, ");
INSERT INTO gmvl_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Daane zarkkefe Gamaale naa Am7eele, ");
INSERT INTO gmvl_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Aaseere zarkkefe Mika7eele naa Sature ");
INSERT INTO gmvl_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Niftaaleme zarkkefe Wafise naa Nahibe, ");
INSERT INTO gmvl_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gaade zarkkefe Makke naa Ga7u7eele. ");
INSERT INTO gmvl_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Heyti dereza hanota xomosi xeellidi yaana mala Musey kiittidayta; Nawe naa Hose7e, «Iyaaso» giidi iza sunththaa laammides. ");
INSERT INTO gmvl_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Musey istta kiitti yeddishe, «Intte bishe Negebe baggara aadhdhidi pude gezze biitta biite. ");
INSERT INTO gmvl_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","He dereya ay misatizaakko, ay keena asi izin dizaakko qasseka asaa minoteththi ay malakko xomosi xeellidi yiite. ");
INSERT INTO gmvl_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","He biittaya iitakkonne lo7okko asay diza katamaya gimbetta uttidaakko woykko gimbettontta coo mela dizaakko xomosi xeellite. ");
INSERT INTO gmvl_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Biittaya modhdhokonne qallako, worakkonne coo dizaakko xomosi xeellite; minnite! He biittan diza miththa ayfetappe ekki yiite» gides; istti hee bida wodey woyne miththa ayfey teeriza wode. ");
INSERT INTO gmvl_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Hessa gishshas he wode asay pudeha bagga dere bides; he derezan diza Xiine bazzofe doommidi gede Hamaate aadhdhi bizasoza matan diza Erahoobe gakkanaas yuuyi xeellida. ");
INSERT INTO gmvl_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Koyro gede Negebe biidi heera Kebroone gakkida; Kebrooneykka, «Enaaqe» geetettiza geesanne gubba gita asata zereth gidida Ahimaane, Shashayenne Talimaye geetettiza zarkketi diza biitta. Kebrooney Gibxen diza Xaanoose katamayppe laappun layth sinththata eqqadus. ");
INSERT INTO gmvl_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Istti heera aadhdhidi gede Eshkoole shoobba gakkida; heeppeka woyne miththa ayfera diza hagga qanxxi ekkidi he woyne miththaa ayfeppe issi wurco issaadey barkka tookkanaas dandayontta deexo gidida gishshas nam7u asati miththan aaththi tookkida; izara issife oroomaane miththa ayfenne balase miththa ayfe ekki yida. ");
INSERT INTO gmvl_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Hessi he sohozi, «Eshkoole shoobba» geetettida gaasoykka Isra7eele asay woyne miththaa iza ayfe wurcozara gaththi qanxxi ekkidi yidaso gidida gishshassa. ");
INSERT INTO gmvl_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Istti biittayo oyddu tammu gallas xomosi xeellidaappe guye aggi simmida. ");
INSERT INTO gmvl_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Paaraane bazzon Qaadeesen diza Musekko, Aaroonekkonne Isra7eele maabara kumeththaakko simmi yiidi bantti beydayssa ubbaa qonccisi yootida; bantti ekki yida miththa ayfezakka istta bessida. ");
INSERT INTO gmvl_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Istti Muses, «Nuni biittayo xomosi be7idi addafekka iza maaththinne eessi kumida dure dere gididaaro nu shaakki eridos; he biittaya immiza ayfeza hayssa beya. ");
INSERT INTO gmvl_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Gido attiin he dereyin diza asay daro mino; hessafe bollara istta katamatikka daro gitatanne gimbey yuuyi aadhdhidayta; hessi hessa gidishin asay qasse geesanne gubba gita gidida Enaaqe zereththata nu beydos. ");
INSERT INTO gmvl_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amaaleeqe asay Negeben dishin, Hiite asay, Yaabuse asaynne Amoore asay bolla gezze biittan Kanaane asay qasse Yordaanoose haaththa gaxaninne Mediteraane abba achchan deettes» gi yootida. ");
INSERT INTO gmvl_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kaalebey qasse Muse sinththan asaa co7u histtidi, «Nuni istta xoonanaas nuus gidiza wolqqay diza gishshas nuni ha7i biidi he biittayo ane oykkoos» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Kaalebera bida asati qasse, «Nuni istta bolla meto gaththanaas mulekka nuus wolqqay baawa; he deraan diza asay nuuppe daro mino» gida. ");
INSERT INTO gmvl_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Istti xomosi xeellana bida dereza gishshas Isra7eele asaas ehi yootida yo7oy asaas diza hidota qanxxisiza yo7o; istti qasseka, «Nuni izo xomosi xeellida biittaya izin daanaas biza as mittiza biitta; nuni heen beyda asaykka geesanne gubba gita. ");
INSERT INTO gmvl_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Nefleeme bagga gidida Enaaqe nayta nuni heen beydos; nuni istta achchan qeeri gumbaro misatidos; isttika nuna hessaththo xeellontta aggettenna» gida. ");
INSERT INTO gmvl_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Derezi he gallassa omars kumeth ba qaala dhoqqu histtidi waassishe aqides; ");
INSERT INTO gmvl_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Kumeththa Isra7eele maabaray Muse bollanne Aaroone bolla zuuzumishe, «Nuni kase heen Gibxen dishe woykko hayssa ha bazzo biittan hayqqidaakko nuus lo7okkoshin! ");
INSERT INTO gmvl_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","GODAY nuna hinno he dereyo aazas efizee? Nuni wurikka olan wuranaas doos; nu machchetinne nu naytikka di7ettana; hessafe nuni duge Gibxe simmiko nuus lo7ana» gida. ");
INSERT INTO gmvl_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Hessa gishshas istti ba garsan issoy issaara, «Ane haa yiite! Nuna kaaleththana as dooridi ane aggi guye Gibxe simmoos» gi haasayettida. ");
INSERT INTO gmvl_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","He wode Museynne Aarooney kumeththa deraa sinththan biitta bolla gufannida. ");
INSERT INTO gmvl_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Biittayo xomosanaas kiitettida asatappe Nawe naa Iyaasoynne Yoofine naa Kaalebey yo7ozan daro ceecidi bantta may7oza daakkida. ");
INSERT INTO gmvl_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Istti derezas, «Nuni biidi yuuyi xomosi xeellida biittaya keeha lo7o biitta. ");
INSERT INTO gmvl_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","GODAY nunan ufayettidaa gidikko izi nuna hee efana; eessinne maaththi izin kumida gasa biittayo izi nuus immana. ");
INSERT INTO gmvl_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Intte gidikko GODAA bolla makkallofte! Heen diza derezaska babofte! Nuni istta qiison xoonana; GODAY nunara dees; istta bollafe eeshoy dendichchida gishshas intte isttas mulekka babbofte!» gida. ");
INSERT INTO gmvl_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Istta shuchchara caddi wodhanaas kumeththa maabaray istta bolla dendides; gido attiin GODAA bonchchoy Isra7eele asaa kumeththaas Gaytoteththa Dunkaanezan qonccides. ");
INSERT INTO gmvl_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","GODAY Muses, «Hayssi derezi ayde gakkanaas tana kadhanee? Tani dereza sinththan daro malaata ooththadis; histtiin derezi tanan ammanettontta ayde gakkanaas ixxanee? ");
INSERT INTO gmvl_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Hekko ha7i tani iita harge istta bolla ehada istta ubbaa wursana; nena gidikko isttafe aadhdhiza mino kawoteththas aawasana» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Musey gidikko GODAAS, «Neni hayssa dereza ne wolqqan Gibxeppe kessadasa; neni hayssa ne dereza bolla ooththidayssa Gibxe asay siyida wode, ");
INSERT INTO gmvl_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","hessa hanida yo7o ubbaa hayssa derezan diza asaa kumeththas istti yootana; hayti ha asati neni GODAY nunara dizayssanne shaaray nuuppe bollara qonccen beettiza mala neni gallas gallas shaara mala tuussan omars omars tama mala tuussan gidada nuuppe sinththe aadhdha kaaleththizayssa siyishe gam7ida. ");
INSERT INTO gmvl_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Histtiin ne ha7i ne asaa wursa wodhikko ne goobateththaa siyida kawoteth ubbay, ");
INSERT INTO gmvl_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","nena, ‹Izi ba dereza gelththana giidi kase caaqqida caaqoza polanaas dandayontta aggida gishshas istta bazzon wodhi dhayssides› gaana. ");
INSERT INTO gmvl_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","18","Godoo hayssafe kase neni, ‹GODAY elle hanqetti erenna; iza maaroteththaynne iza siiqoy daro; izi nagaranne geellateththaa atto gaana; gido attiin naytanne isttas nayta nayta gakkanaas istti yelidayta nagara gishshas ta istta qaxxayana› gida mala polada ne wolqqa bessa. ");
INSERT INTO gmvl_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ha7ikka Godoo! Laamettontta ne gita siiqozan istti Gibxeppe kezoosofe hanno gakkanaas ne istta maarida mala hayssa deraa nagara ne maarana mala ta nena woossays» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","GODAYKKA Muses, «Ne tana oychchida mala ta istta maaradis. ");
INSERT INTO gmvl_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Gido attiin tani de7on diza malanne ta bonchchoy biitta ubbaan kumida mala, ");
INSERT INTO gmvl_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","tani isttas Gibxeninne hayssa bazzo biittan ooththida gita malaatanne ta bonchchoza be7idi taas azazettontta ixxidaytappenne tammuto tana paaccida asatappe oonikka, ");
INSERT INTO gmvl_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","tani kase istta aawatas immana gaada caaqqida biittayo istti mulekka gelettenna; tana kadhiday oonikka izo mulera be7enna. ");
INSERT INTO gmvl_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Gido attiin ta oosanchcha Kaalebes hankkoytappe dumma qofay izas diza gishshassinne izi tana kumeththa wozinappe kaallida gishshas izi biidi kase yuuyi xeellida biittayo ta izas immana; iza zereththatikka he biittayo laattana. ");
INSERT INTO gmvl_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Amaaleeqe dere asaynne Kanaane dere asay shoobba giddon diza gishshas intte wonto guye simmidi Zo7o abba baggara efiza ogezara gede bazzo simmi biite» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","GODAY Musessinne Aaroones hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«Hayti iita asati ayde gakkanaas ta bolla zuuzumanee? Ha zuuzumettiza Isra7eele asay ta bolla zuuzumettishin ta siyadis. ");
INSERT INTO gmvl_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ne isttas, ‹Tani ta de7o sunththan caaqqays; tani intte haasayshin ta hayththan siyida mala intte bolla ooththana; tani GODAY hayssa yootadis. ");
INSERT INTO gmvl_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Intte ta bolla zuuzumettida gishshas intte garsafe qoodettishin layththay nam7u tammunne izappe bollara gididayta ubbaa ahay hayssa bazzo biittan kundi attana. ");
INSERT INTO gmvl_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Intte he dereyo gelidi de7ana mala kase ta inttes caaqqadis; gido attiin Yoofine naa Kaalebeppenne Nawe naa Iyaasoppe attiin inttefe issaadeyka he biittayo gelenna. ");
INSERT INTO gmvl_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Di7ettidi attana geetettida intte nayta intte kadhida biittayo ta gelththana; he biittayo ta istta laatissana. ");
INSERT INTO gmvl_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Intte ahay gidikko hayssa ha bazzozan kundi attana. ");
INSERT INTO gmvl_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Intte nayti intte ammanontta ixxida gaason inttefe wurseththan hayqqizaade ahay bazzo biittan kundi attana gakkanaas 40 layth kumeth gita meto ekkishe hayssa ha bazzozan toylattana. ");
INSERT INTO gmvl_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Intte he biittaa xomosi xeellida 40 gallassaa qoodan issi gallassayo issi layth, hessika oyddu tammu layth kumeth intte intte nagaraa gishshas waayettana; tani intte intte bolla dendidayssa intte hessan erana. ");
INSERT INTO gmvl_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ta bolla dendida iita asata bolla tani hayssa ubbaa ooththana; hayssa bazzozan ubbatikka wuri wurana; ubbatikka hayqqana; tani GODAY hayssa yootadis› ga yoota.» ");
INSERT INTO gmvl_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Musey Kanaane biittayo xomosi xeellanaas kiitti yeddida asati biidi biittayo beyi simmidaappe guye he biittay gishshas iita wore ehidi derezi ba garsan zuuzumettana mala ooththida. ");
INSERT INTO gmvl_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","He asati GODAA sinththan boshan shocetti hayqqida. ");
INSERT INTO gmvl_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","He biittayo biidi xomosi xeellida asata giddofe Nawe naa Iyaasoynne Yoofine naa Kaalebey xalla shemppora paxa attida. ");
INSERT INTO gmvl_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","GODAY gidayssa Musey Isra7eele asaas yootiin asay camo yeeho yeekkides. ");
INSERT INTO gmvl_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Wonteththa gallas wontta maaladora istti dendidi pude gezzetizaso kezanaas giigettidi, «Nuni nagara ooththoyssaka zaari akeekidos; ha7i gidikko nuni kase Xoossi nuna gelththana gi hidota immida dereyo baanaas giigettidos» gida. ");
INSERT INTO gmvl_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Musey gidikko isttas, «Histtiin intte GODAAS ha7ikka ays azazeteketii? Intte qoppidayssi inttes suurenna. ");
INSERT INTO gmvl_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Hessa gishshas intte hee boopite GODAY inttenara gidontta gishshas intte morkketi inttena xoonana. ");
INSERT INTO gmvl_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amaaleeqe asaynne Kanaane asay inttenara heen olettana; gido attiin intte GODAA aggida gishshassinne izi inttenara baynda gishshas intte he olaan hayqqana» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Muse gidiin Caaqo Qaala Taabotazi kase ba diza heeraappe dendontta dishin istti pude gezze biittayo olanaas xalateththan dendida. ");
INSERT INTO gmvl_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Hessafe guye he deren diza Amaaleeqe asaynne Kanaane asay istta bolla meto gaththidi xoonida Horma gakkanaas gooddi yeddida. ");
INSERT INTO gmvl_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«Neni Isra7eele asaas, ‹Ta inttes immana qoppida biittayo intte gelida wode, ");
INSERT INTO gmvl_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","xuugettiza yarshos woykko adina gishshas yarshettana yarshos woykko asi ba lo7o qofappe shiishshiza yarsho gishshas, woykko lose ba7aaleta wode shiiqiza yarshota miizappe woykko dorsafe GODAAS intte shiishshandeta; hessa misatiza yarshoy GODAA sawiza yarsho gidana. ");
INSERT INTO gmvl_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Hessa gishshas hessa mala shiishshiza asi wuri issi litiro gidana zayten issi kilo gidiza liiqo dhiillefe munuqettida kaththa yarsho shiishshanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Qasse xuugettiza yarshos woykko hara yarshos ehiza issi issi dorsa laaqqara issi litiro woyne ushsha yarsho shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","« ‹Dharsho yarshos shiishshiza wode qasse nam7u kilo dhiille issi litironne sayso gidiza wogara zayten munuqidi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Ushsha yarshos issi litironne sayso gidiza woyne ushshu shiishsha; hessi wurikka lo7o GODAA sawizaazinne ufayssizaaz gidana; ");
INSERT INTO gmvl_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","« ‹Neni issi mirgo adinas, woykko issifeteththa yarshos, woykko xuugettiza yarshos, woykko hara yarshos shiishshiza wode, ");
INSERT INTO gmvl_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","he mirgozara heedzdzu kilo gidiza liiqo dhiillefe nam7u litiro zayten munuqettida kaththa yarsho shiishsha. ");
INSERT INTO gmvl_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Hessaththoka ushsha yarshos nam7u litiro gidiza woyne ushshu shiishsha; hessika GODAA ufayssiza, sawizaazanne xuugettiza yarsho gidana. ");
INSERT INTO gmvl_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Hessa gishshas issi issi mirgo, woykko issi issi dharsho woykko dharsho laaqqa woykko korbe laaqqa yarshos shiishshiza wode issife shiiqiza kaththa yarshoy hessa. ");
INSERT INTO gmvl_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Issi meheppe bollara shiiqiza wode izara issife shiiqiza kaththa yarshoy hessa mala gujettees. ");
INSERT INTO gmvl_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Deren yelettida Isra7eele asaappe issoy issoy xuugettiza yarshonne sawoy GODAA ufayssiza yarsho shiishshiza wode hessaththo ooththanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Sinththafe yaana yeletaan inttenara diza bete asi woykko intte garsan diza hara dere asi oonikka xuugettiza yarsho woykko GODAA ufayssiza kaththa yarsho GODAAS shiishshana koykko izaadeyka intte ooththizayssa mala ooththanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Intte ubbatikka intte giddon diza asa dere asatikka hayssafe yaana layththatan ubbatan hayta wogata issi mala naaganaas inttes bessees; intteninne istti ubbati GODAA sinththan issino. ");
INSERT INTO gmvl_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Inttessinne inttenara diza hara dere asaa ubbaas diza wogaynne maaray issino gido› ga yoota.» ");
INSERT INTO gmvl_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«Neni Isra7eele asaas, ‹Ta inttena kaaleththiza biittayo intte geliza wode, ");
INSERT INTO gmvl_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","he biittayn kaxxiza kath ubbaa miza wode he kaththaafe GODAAS imota immite. ");
INSERT INTO gmvl_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Hessika koyro dhiillezappe uketh uukkidi baleppe imettida yarsho ooththidi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Buroppe yaana yeleta ubbaan koyro dhiillezappe ekkidi GODAAS imota shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","« ‹GODAY Muses immida azazotappe issaa intte erontta moorizaa gidikko, ");
INSERT INTO gmvl_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","woykko sinththafe yaana yeletati Muse baggara imettida azazoza polontta aggiko, ");
INSERT INTO gmvl_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","hessa mala balay maabaray erontta hanikko issi mirgo ehidi GODAA sawidi ufayssiza yarshonne xuugettiza yarsho izas shiishshetto; wogazi azaziza mala kaththa yarshonne ushsha yarsho izara issi bolla gaththi shiishshetto; hessafekka bollara issi deysha orge nagara yarshos shiishshetto. ");
INSERT INTO gmvl_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Qeesezi kumeththa Isra7eele maabaraa nagara wurso; istti erontta ooththida nagara gaason xuugettiza yarshonne kaththa yarsho shiishshida gishshas istta nagaray atto geetettana. ");
INSERT INTO gmvl_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Ubbayka erontta dishe nagara ooththida gishshas Isra7eele asaa woykko istta giddon diza hara dere asaa nagaray atto geetettana. ");
INSERT INTO gmvl_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","« ‹Issi asi erontta nagara ooththiko issi layththa deysha laaqqa ba nagara gishshas yarshos shiishsho. ");
INSERT INTO gmvl_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Erontta dishe nagara ooththidaades iza nagaray atto geetettana mala qeesezi GODAA sinththan iza nagaraa wurso; iza nagaraykka atto geetettana. ");
INSERT INTO gmvl_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Isra7eele deren yelettida Isra7eele asi woykko istta giddon diza asa dere asi erontta dishe nagara ooththidaa gidikko ubbaas diza wogay issi mala. ");
INSERT INTO gmvl_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","« ‹Gido attiin Isra7eele dere as woykko hara dereppe beti istta giddo yida asi wozinay erishin nagara ooththida asi wurikka GODAA leqqida gishshas derezappe shaaketti dhayo. ");
INSERT INTO gmvl_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Izaadey GODAA leqqida gishshassinne iza azazota erishe moorida gishshas mulera dhayo; iza gomey izara bo› ga yoota.» ");
INSERT INTO gmvl_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Isra7eele asay bazzon diza wode issi gallas issaadey sambata gallas mith mixishe oykettides. ");
INSERT INTO gmvl_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","He iza oykkida asati iza oykki ekkidi Musekko, Aaroonekkonne kumeththa maabaray dizaso efida. ");
INSERT INTO gmvl_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Isttika iza wosttanaakkonne erettontta ixxiin guuththa wodes qashettiishana mala zabes imettides. ");
INSERT INTO gmvl_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Hessafe guye GODAY Muses, «He addezi hayqqo! Kumeththa maabaray dizasoppe iza kare kessidi shuchchara caddi wodho» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Hessa gishshas kumeththa maabaray bantti diza gutappe haraso efidi GODAY azazida mala shuchchara kurakki wodhides. ");
INSERT INTO gmvl_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«Neni Isra7eele asaas, ‹Intte may7iza may7os macara kessite; issi issi macaray salo misatiza xilatappe gido; hessaka intte buroppe yaana yeleta ubbaankka aggofte. ");
INSERT INTO gmvl_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","He macarata intte be7iza wode ubbaan ta azazota hassa7i ekkidi polite; histtiko intte intte ayfen be7idayssanne intte wozinan amottidayssa kaallidi taappe shaaketteketa. ");
INSERT INTO gmvl_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","May7ota xeeran diza macarata intte be7iza wode ta azazota ubbaa polana mala istti inttena qofsana; intteka mulera taas haarettidayta gidana. ");
INSERT INTO gmvl_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Tani intte GODAA; inttes Godaa gidanaas inttena Gibxeppe kessida Xoossay tana› ga yoota.» ");
INSERT INTO gmvl_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Lewe zarkke Qa7aate baggafe Yixihaare naa Qoorey, Oroobeele zarkke Elyaabe nayti Daataaneynne Abraamey qasseka Palete naa Oonay meto medhdhida. ");
INSERT INTO gmvl_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Isra7eele asaa garsan erettida dereza kaaleththanaas doorettida 250 asata bantta bolla ekkidi Muse bolla dendida. ");
INSERT INTO gmvl_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Isttika Muse sinththaninne Aaroone sinththan shiiqidi isttas, «Intte mulekka wogappe aadhdhideta! Hayssi derezi ubbay GODAAS dummatida dere; GODAYKKA isttara dees; histtiin intte GODAA deraa bolla aazas inttena dhoqqu dhoqqu histteetii?» gida. ");
INSERT INTO gmvl_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Museykka hessa siyida mala gufannidi woossides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Qooressinne iza kaallizaytas, «Wonto maalado GODAY izas dummatidayti oonanttako izi shaakki nuna bessana; hessika baas gidizaytanne ba dooridayta baas ooththana mala baakko shiishshi ekkana. ");
INSERT INTO gmvl_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Wonto maalado neninne nenara issife ooththizayti wurikka intte izan exaane cuwasiza xinnaza ekki yiite. ");
INSERT INTO gmvl_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Istta bolla bonqo tamanne exaane woththidi gede yarsho iza bolla yarshizaso shiishshite; hessafe guye GODAY nuuppe oona baas dooridaakko nu beyana; intte Lewe nayti keehi moorideta!» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Qasseka Musey Qoores, «Intte Leweti wozinan woththi siyite! ");
INSERT INTO gmvl_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Intte gede izakko shiiqidi Gaytoteththa Dunkaane giddon intte intte ooso polana malanne intte Isra7eele asaa sinththan eqqidi isttas ooththana mala Isra7eele GODAY inttena hankko Isra7eele asaa garsafe shaakki dummasidayssa intte coo mela laafa ayfen xeelleetii! ");
INSERT INTO gmvl_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Izi inttenanne hankko Lewe zarkketa baakko shiishshides; intte gidikko qeeseteththaa ekkanaas qaaqqateeta; ");
INSERT INTO gmvl_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","hessa gishshas neninne nenara zuppetizayti wurikka GODAA bolla dendideta; intte Aaroone bolla zuuzumettanaas izi oonee?» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Hessafe guye Musey Elyaabe nayta Daataanenne Abraame xeygisides; istti gidikko, «Nu bookko! ");
INSERT INTO gmvl_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Nuni bazzon hayqqana mala ne nuna eessinne maaththi kumida biittafe kessidayssi nees guuxxiin ha7i qasse nu bolla halaqa gidanaas koyay? ");
INSERT INTO gmvl_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Neni nuna lo7o kath immiza goshsha gade ehonttayssi woykko atakiltera dizaso laatisonttayssi erettidaaza; ha7i qasse ne nuna baleththanaas koyaasa; hessa gishshas ha7i nu neekko bookko!» gida. ");
INSERT INTO gmvl_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Museykka daro hanqettidi GODAAS, «Hayti asati nees shiishshiza yarshoza ne ekkofa; tani gidikko isttafe issaadeka qohabeekke; haray attoshin issi harekka isttafe ekkabeekke» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Musey Qoores, «Neninne nenara issife diza 250 asay Aarooney dizaso Gaytoteththa dunkaanekko yiite. ");
INSERT INTO gmvl_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Inttefe issaadey issaadey intte intte xinna oykki yiite; xinnaza giddon exaane gujjite; 250 xinnatara intte intte exaaneza GODAA sinththan shiishshandeta; neninne Aarooneykka intte intte exaane exaane shiishshite» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Hessa gishshas istti wurikka issoy issoy ba xinnan xinnan exaane gujji ekkidi Gaytoteththa Dunkaane pengen Museranne Aaroonera issife eqqida. ");
INSERT INTO gmvl_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Hessafe guye Qoorey isttara eqettidi banara zuppetizayta Gaytoteththa Dunkaaneza penge shiishshida wode GODAA bonchchoy kumeththa deraas qonccides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","GODAYKKA Musessinne Aaroones hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«Hayssa deraa achchafe haakki eqqite; tani istta issito ubbaa dhayssana.» ");
INSERT INTO gmvl_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Museynne Aarooney sinththa guth gufannidi, «Shemppora diza medheta ubbaas Godaa gidida Xoossoo! Issi asi ooththida nagara geedon neni kumeththa deraa dhayssana gay?» giidi Xoossako waassida. ");
INSERT INTO gmvl_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","24","GODAY Muses, «Qoore dunkaanaappe, Daataane dunkaanaappenne Abraame dunkaanaappe haakki eqqana mala neni deraas yoota» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Hessafe guye Musey Isra7eele asaa kaaleththizayta kaaleththi ekkidi Daataanekkonne Abraamekko bides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Derezaska, «Intte hayta makkalla asata dunkaanetappe haakki eqqite; istta miish gididaaz aykkoka bochchofte; histtontta aggiko istta nagara gaason intte wurikka isttara issife pitetti dhayana» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Hessa gishshas derezi qoore dunkaanezappe; Daataane dunkaanezappenne Abraame dunkaanezappe haakki eqqides. Daataaneynne Abraameykka ba machchetaranne ba naytara ba dunkaanezappe kare kezidi ba pengen pengen eqqida. ");
INSERT INTO gmvl_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","He wode Musey deraas, «Hayssa ha oosoza ooththanaas GODAY tana kiittidayssanne tanikka hayssa ooththizay ta shenen gidonttayssa intte hayssan erana. ");
INSERT INTO gmvl_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Hayti ha asati asi hayqqiza mala hayqqizaa gidikko GODAY tana kiittibeenna. ");
INSERT INTO gmvl_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Gido attiin asi hayththan siyi erontta ooraththa miish GODAY istta bolla ooththiin istti shemppora paxa dishe duge hayqqidayti dizaso wodhdhana mala biittaya doyettada isttanne isttas dizaaz ubbaa mittiko hayti asati GODAARA eqettidayssa intte he wode erana» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Musey hessa yootida mala Daataaneynne Abrooney eqqi diza biittaya doyettada, ");
INSERT INTO gmvl_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","isttanne istta soo asaa, Qoore, izara zuppetiza asaanne isttas dizaaz ubbaa mittadus. ");
INSERT INTO gmvl_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Histtiin istti shemppora paxa dishe baas diza miishshaara duge duufon gelida; biittaya istta kammada deraa giddofe dhayssadus. ");
INSERT INTO gmvl_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","He heeran diza Isra7eele asay he asaa waaso siyidi, «Hayssi biittay nunakka mittontta aggenna!» gi waassishe baqatides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Qasseka GODAY saloppe tama yeddidi exaane cuwasiza 250 asaa xuuggides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Hessafe guye GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","«Aaroone naa El7ezeerey xarqimalappe qoxettida xinnati dumma gidida gishshas xuugettiza asata matappe istta giddon diza bonqo tamaza haahoso efi qolana mala izas yoota; ");
INSERT INTO gmvl_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","he xinnati GODAAS yarsho yarshizasoza shiiqida wode geeyida; hessa gishshas ba nagara gaason hayqqida asata xinna ekkada lee7isa qoxxa; histtada yarsho yarshizasozas kama ooththa; heytikka Isra7eele asay naagettana mala isttas seera malata gidana.» ");
INSERT INTO gmvl_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Hessa gishshas El7ezeerey xinnata ekkidi yarsho yarshizasozas kama gidana mala lee7en qoxxi kessides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Hessi he hanozi oonikka Aaroone zereth gidontta asi GODAAS exaane cuwasanaas yarsho yarshizasoza shiiqontta mala Isra7eele asay ubbay naagettana mala qofsiza malata gidana; hessaththo gidontta aggiko hessa mala ooththiza asi ubbayka Qoore malanne izara zuppetidayta mala dhayana; hayssi wurikka kase GODAY Muse baggara immida azazoza mala polettides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Wonteththa gallas kumeththa Isra7eele maabaray, «GODAA deraa intte wodhideta» giidi Muse bollanne Aaroone bolla gugumides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Derey Museranne Aaroonera eqettanaas issi bolla shiiqettida wode Gaytoteththa Dunkaaneza shaaray kammi oykkiin GODAA bonchchoy izan qonccidayssa guye simmi be7idos. ");
INSERT INTO gmvl_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Museynne Aarooney yiidi Gaytoteththa Dunkaanaas sinththa baggara eqqida. ");
INSERT INTO gmvl_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","«Hayta ha asatappe pooqqi eqqite; tani istta issito dippi histta dhayssana!» Nam7atikka duge biitta bolla gufannida. ");
INSERT INTO gmvl_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Musey Aaroones, «Neni ne xinna ekkada yarsho yarshizasozappe bonqo tama iza bolla gujja; he tamaa bolla exaane woththa; hessafe guye eeson deraakko baada asaa nagara wursa! Hekko Xoossa hanqoy qonccida gishshas dereza giddon boshay doommides» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Hessa gishshas Aarooney Musey azazida mala ba xinna ekkidi shiiqetti diza asaa giddo eeson bides; boshay deraa giddon doommidayssa be7idi exaaneza bonqo tama bolla woththidi asaa nagaraa wursides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Aarooney paxa diza asaassinne hayqqida asaas giddon eqqidi deraa bolla yiza boshaa teqqides. ");
INSERT INTO gmvl_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","He wode hayqqida asaa qooday Qoorera issife geellateththan hayqqidayti attiin 14,700. ");
INSERT INTO gmvl_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Boshazi eqqiin Aarooney Gaytoteththa Dunkaaneza pengen diza Musekko simmi bides. ");
INSERT INTO gmvl_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«Isra7eele asaappe zarkkefe zarkkefe korapinney issi issi guufe shiishshidi tammanne nam7u guufe immana mala oychcha; histtada issaa issaa sunth he guufeta bolla xaafa. ");
INSERT INTO gmvl_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Lewe zarkketappe shiiqida guufeta bolla Aaroone sunth xaafa; issi issi zarkke kaaleththizaades issi guufey shiiqo. ");
INSERT INTO gmvl_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Heytakka gede Gaytoteththa Dunkaanezan efada ta nena haasayssizason Taabotazappe sinththa baggara woththa. ");
INSERT INTO gmvl_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Hessafe guye tani doorizaade guufey purccidi cililana; hessan Isra7eele asay ubba wode ne bolla zuuzumontta mala ta diggana.» ");
INSERT INTO gmvl_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Hessa gishshas Musey hessa Isra7eele asaas yootides; dereza kaallizayti issoy issoy ba guufe guufe ekkidi izas immides; issi zarkke gishshas issi issi guufe gidishin ubbay issi bolla 12 guufey shiiqides; he shiiqida guufeta giddon Aaroone guufey dees. ");
INSERT INTO gmvl_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Musey guufeta ubbaa ekkidi Gaytoteththa Dunkaaneza giddon GODAA Caaqo Qaala Taabotaza sinththan woththides. ");
INSERT INTO gmvl_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Wonteththa gallas Musey gede Gaytoteththa Dunkaanezan gelishin Lewe qommo sunththan shiiqida Aaroone guufeya cililidaaro be7ides; qasseka ciiyada kaxxida ochcholoone ayfe ayfidaaro be7ides. ");
INSERT INTO gmvl_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Museykka guufeta ubbaaka ekki efidi Isra7eele asaa bessides; asaykka hessa ubbaa be7idi issi issi korapinneti ba guufe guufe ekkida. ");
INSERT INTO gmvl_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","GODAY Muses, «Aaroone guufeza zaarada Caaqo Qaala Taabotaappe sinththa baggara woththa; makkalliza Isra7eele asay ta bolla zuuzumizayssa aggontta ixxiko istti hayqqanayssa bessiza malata gidi utto» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Museykka GODAY iza azazida mala ooththides. ");
INSERT INTO gmvl_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Isra7eele asay Muses, «Hayssa mala gidikko nuni wurikka wuranaas doos! ");
INSERT INTO gmvl_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Gaytoteththa Dunkaanezakko shiiqida asi ubbay hayqqizaa gidikko nunikka wuri hayqqanaas doos guussee?» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","GODAY Aaroones, «Gaytoteththa Dunkaaneza giddon oosettiza mooro ubbaa gishshas neninne ne nayti, Lewe qommoti alaafeteth ekkideta; qeeseteththa ooson polettiza mooro gishshas gidikko hessa alaafeteth ekkanay nenanne ne nayta xalla. ");
INSERT INTO gmvl_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Neninne ne nayti Gaytoteththa Dunkaanezan ooththiza wode inttena ooson maaddanaas Lewe qommo gidida ne baggata ekka. ");
INSERT INTO gmvl_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Istti ne alaafeteththa garsan dishe Gaytoteththa Dunkaaneza ooso ooththetto; gido attiin geeshshasozan go7ettiza miishshatakko yarsho yarshizaso shiiqopetto; hee shiiqizaa gidikko neninne isttika issi bolla hayqqana. ");
INSERT INTO gmvl_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Istti ubba wode inttenara issife oosonne Gaytoteththa Dunkaaneza giddon isttas imettida ooso ubbaa ba alaafeteththan polanaas bessees; gido attiin Lewe qommo gidontta ay asikka ooththanaas intteko shiiqoppo. ");
INSERT INTO gmvl_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","«Ta hanqoy qasseka Isra7eele asaa bolla qonccontta mala geeshshasozaninne yarsho yarshizasozan oosettiza oosoza alaafeteth polanayti inttenanne intte nayta xalla. ");
INSERT INTO gmvl_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Intte bagga gidida Lewe zarkketa Isra7eele asaa garsafe inttes doorida imota histta immiday tana; isttika Gaytoteththa Dunkaaneza giddon baas imettida ooso ooththana mala taas dummatidayta. ");
INSERT INTO gmvl_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Gido attiin yarsho yarshizasozaninne magalashaappe guye baggara ubbaafe dummatida giddo qol7aan oosettiza qeeseteththa oosoy neessinne ne naytas xalla bessees; qeeseteththa oosozakka ta inttes imota histta immadis; qeese gidontta ay asikka hee shiiqikko hayqqana» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Hayssafe guye GODAY Aaroones, «Xuugettontta coo mela taas shiiqiza yarsho ubbaa ta nees immidayssa yuushsha qoppa; hessika neessinne ne zare ubbaas gisha gidana mala tani immadis. ");
INSERT INTO gmvl_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Taas daro dummati shiiqiza imotatappe taman xuugettontta yarshoy neessinne ne naytas gisha gidana; hessika kaththa yarsho ubbay, nagara gishshas woykko qoho gishshas shiiqiza yarsho ubbay neessinne ne naytas gisha gido. ");
INSERT INTO gmvl_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Intte hessa geeshshasozan dishe miite; hessaka attumasay ubbay mo; izikka keehi dummatidaaza. ");
INSERT INTO gmvl_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","«Qasseka Isra7eele asay ta sinththan yaanne haa qaaseththi yarshiza yarshoy ubbay inttes gido; haytantta tani nees, ne macca naytas, ne attuma naytassinne sinththafe yaana yeleta ubbaas eqqi daana mala inttes gisha histta immadis; neso asaappe geesh gididay oonikka maanaas dandayees. ");
INSERT INTO gmvl_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","«Isra7eele asay taas immiza oorath gakkiza kaththa xeerappe wogara zayte, woyne ushshinne kaththa qommo ubbaafe xeeraa ta inttes immadis. ");
INSERT INTO gmvl_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Istti ba gadeppe taas GODAAS immiza kaththa xeeray inttessa; hessa intteso asaan geesh gidida asi oonikka maanaas dandayees. ");
INSERT INTO gmvl_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","«Isra7eele asaappe taas imettida miishshi ubbay inttessa. ");
INSERT INTO gmvl_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Isra7eele asay taas shiishshiza meheppe woykko asappe bayra gidi yelettiday inttessa; gido attiin asaappe bayra gidi yelettidayssa gidikko istta miishshan wozzana bessees; hessaththoka geesh gidontta mehetappe koyro yelettidayssa miishshan wozzanaas dandayeeta. ");
INSERT INTO gmvl_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Issi agina nayta wozzanaas geeshshasozan erettida meezaane likken ichchashu saqile bira wozzo miish ciggidi wozzanaas dandayeettes. ");
INSERT INTO gmvl_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","«Miizappe woykko dorsafe woykko deyshafe bayra gidi yelettidayssa wozzofte; heyti mulekka geesh gidida gishshas taas yarsho gidi shiiqanaas bessees; istta suuththa yarsho yarshizasoza bolla aracite; handazakka tana lo7o sawo sawana mala taman xuuggite. ");
INSERT INTO gmvl_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Yaanne haa qaaseththi shiishshiza yarsho gididi shiiqiza angaso malanne ushachcha misse mala istta ashozi nees gido. ");
INSERT INTO gmvl_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Isra7eele asay taas shiishshiza dumma dumma imotata wursaka ta inttes, intte attuma naytassinne intte macca naytas buro sinththafe yaana wodetan ubbaan woga gididi inttes gisha gidana mala ta inttes immadis; hessika tani inttenaranne intte zereththatara caaqettiza laamettontta maxine caaqo mala» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","GODAY Aaroones, «Neni ne zereththas laatissanaas laata gadey nees imettenna; istta giddon nena gakkiza gishay aykkoyka deenna; nena gakkiza laatay tana Xoossaa» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","GODAY, «Isra7eele asay taas ehiza asraatay wuri Lewe zarkketas gisha gido gaada ta immadis; hessika istti Gaytoteththa Dunkaane giddon ooththiza oosoza damoza gido. ");
INSERT INTO gmvl_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Hankko Isra7eele asay gidikko ba bolla hayqo qixaate gaththontta mala nam7anththo gede Gaytoteththa Dunkaanezakko shiiqanaas bessenna. ");
INSERT INTO gmvl_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Hayssafe guye Gaytoteththa Dunkaaneza giddon alaafeteth ekki ooththanaas bessizay Lewe zarkketa xalla gidana; heen oosettiza mooroska istti oyshettana; hessika isttas naa naa gakkanaas laamettontta woga gidana; Lewetas xinxxoy Isra7eele deren deenna. ");
INSERT INTO gmvl_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Isra7eele asay taas dumma yarsho ehiza asraataa tani isttas gisha histta immadis; hessa gishshas isttas Isra7eele asaa giddon xinxxoy dontta mala yootadis» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«Neni Lewetas, ‹GODAY inttes gisha histti immiza asraata intte Isra7eele asaa kusheppe ekkishe intteka intte baggara he intte ekkidayssafe asraata kessidi GODAAS dumma yarsho histti shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Hessi he dumma yarshozi issi goshshanchchay kaththa xeera woykko woyne ushshu asraata immiza mala gidi inttes qoodettana. ");
INSERT INTO gmvl_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Hessa malan intteka Isra7eele asaappe ekkiza asraata ubbaafe GODAAS dumma yarsho histti shiishshite; intte GODAAS shiishshiza yarshoza qeese Aaroones immite. ");
INSERT INTO gmvl_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Intte ha ekkiza miish ubbaafe doorettidayssanne lo7o gididayssa GODAAS gisha histti immite. ");
INSERT INTO gmvl_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","« ‹Goshshanchchay kaththa ayfeppenne woyne ushshafe doorettidayssa taas immidi attidayssa baas ekkiza mala intteka doorettidayssa taas immidi attidayssa inttes ekkite. ");
INSERT INTO gmvl_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Hessika intte Gaytoteththa Dunkaane giddon ooththiza oosozas waaga gidida gishshas attidayssa intte intteso asaara awanka diidi maanaas dandayeeta. ");
INSERT INTO gmvl_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Doorettidaaz intte GODAAS shiishshidaappe guye attidayssa intte miikko inttes nagara gidenna; gido attiin doorettidayssa izappe shaakkontta miidi dumma gidida Isra7eele asaa imota tunisontta mala naagettite; tunisizaa gidikko intte hayqqana› ga» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","GODAY Musessinne Aaroones hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«Hayssi ta azazidayssi wogaas diza maara; Isra7eele asay izi morge bolla qambaray wodhdhi erontta borey baynda issi zo7o miiza us Isra7eele asay ehana mala asaas yoota. ");
INSERT INTO gmvl_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","He ussayo qeese El7ezeeres immite; he ussayo asi dizasoppe gede kare kessiko heen iza sinththan shukettu. ");
INSERT INTO gmvl_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Qeese El7ezeerey izi suuththafe guuththara ekkidi ba biradhdhe xeeran laappunto gede Gaytoteththa Dunkaanezas sinththa baggara pistto. ");
INSERT INTO gmvl_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","He ussay galbay, ashoy, suuththinne qanththa ashoy wuri qeeseza sinththan xuugetto. ");
INSERT INTO gmvl_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Qeesezi Libaanoose ziga, hisophphenne zo7o qacina ekkidi ussaya xuugettiza tamazan yeggo. ");
INSERT INTO gmvl_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Hessafe guye ba may7o meecco; ba bollaka haaththen meecettidi kase ba dizaso simmo; gido attiin omars gakkanaas wogay giza mala tuna gidi gam7o. ");
INSERT INTO gmvl_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","He ussayo xuuggidaadeyka ba may7o meecco; ba bollaka haaththan meecetto; izikka omars gakkanaas tuna gidi gam7o. ");
INSERT INTO gmvl_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","«Hessafe guye geesh gidida hara asi he bidinththaa shiishshi efidi asay dizasoppe gede kessidi geeshshasohon woththo; heenkka Isra7eele asay meecettidi geeyanaas go7iza haath giigsanaassa; hayssi wogazi oosettizay asa nagara wursanaassa. ");
INSERT INTO gmvl_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Bidinththaa shiishshidaadey ba may7o meecco; gido attiin izi omarsa wode gakkanaas tuna gidi gam7o; hayssi wogazi Isra7eele asaassinne bete yiidi istta giddon diza asaas buroppe yaana yeleta ubbaas laamettontta woga gidana. ");
INSERT INTO gmvl_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","«Hayqqida asa aha bochchida asi laappun gallas gakkanaas tuna gidi gam7o. ");
INSERT INTO gmvl_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Heedzdzanththo gallassaninne laappunththa gallassan geeyanaas giigetti diza haaththan bana geeshsho; hessafe guye izi geesh gidana; heedzdzanththo gallassinne laappunththa gallas bana geeshshontta aggiko izi geeyanaas dandayenna. ");
INSERT INTO gmvl_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Geeshshanaas diza haaththi iza bolla gukkontta aggida gishshas aha bochchidi bana geeshshontta asi tunida mala gam7o; hessa mala asi Gaytoteththa Dunkaaneza tunisees; hessa gishshas izi Isra7eele asaa giddofe shaaketti kichcho. ");
INSERT INTO gmvl_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","«Issaadey Gaytoteththa Dunkaaneza giddon hayqqiko polettana wogay hayssa. Izi hayqqida wode he wode heen Gaytoteththa Dunkaaneza giddon dizaadey woykko hee gede Gaytoteththa Dunkaanezan gelizaadey laappun gallas gakkanaas tuna gidi gam7o. ");
INSERT INTO gmvl_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","He Gaytoteththa Dunkaaneza giddon tuchchi baynda diza otoy wurikka xaaroykka tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Asi wodhida asa aha gidiin woykko hargi hayqqida asa aha gidiin Karen kundi diza aha bochchidaadey woykko asa meqeth bochchidaadey laappun gallas gakkanaas tuna gido. ");
INSERT INTO gmvl_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","«Tunida as nagarappe geeshshanaas xuugettiza ussay bidinththafe guuththara oton yegetto; xilli uttida pultto haaththi iza bolla gujjetto. ");
INSERT INTO gmvl_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Kaallidi geesh gidida hara asi hisophphe miththa hagga ekkidi haaththan gelththi gelththi kessidi Gaytoteththa Dunkaaneza bolla, iza giddon diza miishshata bollanne asaa bolla araco; hessafe guye asa meqeth woykko aha duufo bochchidaade bolla haaththe araco. ");
INSERT INTO gmvl_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Heedzdzanththa gallassinne laappunththa gallas geeyidaadey hankko geeyonttaade bolla haaththe araco; laappunththa gallas iza geeshsho; he geeyzaadeyka ba may7o meeccidaappenne ba bolla meecettidaappe guye arshey wullishin izaadey geesh gidana. ");
INSERT INTO gmvl_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","«Tunidaadeynne bana geeshshonttaadey geesho haaththaa ba bolla gussontta aggida gishshas izi tunida mala gam7o; hessa mala asi geeshshasoza tunisiza gishshas maabaraa giddofe shaaketti kichcho. ");
INSERT INTO gmvl_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Hayssa ha wogaa buroppe yaana yeletaas intte naaganaas bessees; geeshos go7iza haaththaa ba bolla araciza asi ba may7ozakka meeccanaas bessees; he haaththaa bochchidaadey omars gakkanaas tuna gidi gam7o. ");
INSERT INTO gmvl_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Geeyontta asi bochchida miishshi ubbay tuna gido; he tuna miishshaa bochchida asikka omars gakkanaas tuna gido.» ");
INSERT INTO gmvl_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Koyro aginan Isra7eele asay kumeth Xiine bazzon Qaadeese geetettizason dunkaani uttides; Maarama hayqqiin heen moogida. ");
INSERT INTO gmvl_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Asay dunkaani uttidasohon haaththi baynda gishshas Muse bollanne Aaroone bolla dendides. ");
INSERT INTO gmvl_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Derezi, «Nuni kase Gaytoteththa Dunkaane sinththan hayqqida Isra7eele asaa mala isttaththo nunikka hayqqidaakko nuus lo7o gidanashin; ");
INSERT INTO gmvl_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","intte GODAA maabaraa hayssa ha bazzo biitta ehiday nuninne nu mehey hayssan wurana mala ooththanaassee? ");
INSERT INTO gmvl_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Intte nuna Gibxeppe kessidi hayssa aykkoy mokkontta iita bazzo nuna aazas ehidetii? Hayssan kaththi, balasey, woyne ayfeynne oroomaaney deenna; haray attoshin ganxi ekkiza haaththika deenna!» giidi Musera ooyettida. ");
INSERT INTO gmvl_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Museynne Aarooney asaappe shaakettidi gede Gaytoteththa Dunkaane penge bida; istti duge biittan gufanni dishin GODAA bonchchoy isttas qonccides. ");
INSERT INTO gmvl_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«Caaqo Qaala Taabotaa sinththan diza guufeza ekkida neninne Aarooney kumeththa maabara issi bolla shiishshite; neni heen kumeththa deraa sinththan diza zaallazi haaththe immana mala yoota; neni hessaththo ooththada zaallazappe isttas haaththe kessa; histtiko isttinne istta mehey haath uyidi alana.» ");
INSERT INTO gmvl_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Musey GODAY iza azazida mala biidi Gaytoteththa Dunkaanezappe ba guufeza ekki yides. ");
INSERT INTO gmvl_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Izinne Aarooney kumeththa maabaraa zaallaza sinththan shiishshidaappe guye Musey dereza, «Intteno makkallanchchatoo! Hayssa ha zaallazappe nu inttes haaththe kessanee!» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Hessafe guye Musey ba guufezan zaallaza nam7aa zaari shocides; wolqqama haaththi zaallafe pulttides; derezinne mehey haaththaa uyides. ");
INSERT INTO gmvl_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Gido attiin GODAY Muse bollanne Aaroone bolla, «Intte Isra7eele asa sinththan ta dummateththaa mala tana bonchchanaas ammanettibeekketa; hessa gishshas ta inttena laatissana ga caaqqida dereza hayssa deraa kaaleththidi gelekketa» gi hanqettides. ");
INSERT INTO gmvl_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Isra7eele asay GODAARA ooyettidasoynne izi ba dummateththaa qonccisidasoy Mariiba geetettida gishshas haaththayka Mariiba haath geetetti summides. ");
INSERT INTO gmvl_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musey Eedoome kawos kiita gaththana mala qasttanne as Qaadeeseppe yeddides; «Ne isha Isra7eeley, ‹Nu bolla gakkida metoza ubbaa neni siyadasa; ");
INSERT INTO gmvl_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Beni nu aawati waani duge Gibxe wodhdhidaakkonne nunikka Gibxen daro layththata waani waani didaakko ne eraasa; Gibxe asay kase nu aawata gidiin nunakka daro waayisides. ");
INSERT INTO gmvl_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Nunikka izi nuna maaddana mala GODAAKKO waassidos; izikka nu waasoza siyidi Gibxeppe nuna kessanaas ba kiitanchcha nuus kiittides; hekko nuni ha7i nees dhassan diza Qaadeesen doos. ");
INSERT INTO gmvl_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Hessa gishshas nuni ne biittaara aadhdhi baana mala nuus ero garkkii! Nuna gidiin nu meheykka ogeppe kare kezokko; kaththa giddo gidiin woykko woyne miththa giddo nu gelokko; ne haaththa ollafekka uyokko; ne dereppe aadhdhana gakkanaas ogeppe kare kezokko› gees» gi kiittides. ");
INSERT INTO gmvl_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Eedoome asay gidikko, «Intte nu derera aadhdhi baana mala koyokko; intte nu dere gelanaas paacciko nu intte bolla worajjana» gida. ");
INSERT INTO gmvl_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Isra7eele asaykka, «Nuni waanna ogezappe kezokko; nuna gidiin woykko nu mehey intte haaththafe uyikko nu inttes iza waaga qanxxana; nu waanna koyzay intte derezara aadhdhi baanaassa» giidi isttas malthe immida. ");
INSERT INTO gmvl_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Eedoome asay gidikko, «Hessi hanenna! Nu inttena aaththi yeddoko!» giidi mino olanchchata ekkidi Isra7eele asaa olanaas kezida. ");
INSERT INTO gmvl_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Eedoome dere asay ba biittara aaththi yeddonttayssa eridi Isra7eele asay ba biza ogeza laammidi harasora bides. ");
INSERT INTO gmvl_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Kumeththa Isra7eele maabaray Qaadeeseppe dendi Hoore zumaakko gakkides. ");
INSERT INTO gmvl_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","He zumazi Eedoome dhassan dees; GODAY heen Musessinne Aaroones, ");
INSERT INTO gmvl_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«Tani Isra7eele asaas immana gaada kase caaqqida dereyo Aarooney gelenna; intte wurikka Mariiba haaththaa achchan ta azazoza bolla makkallida gishshas Aarooney hayqqana. ");
INSERT INTO gmvl_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Aaroonenne iza naaza El7ezeere nenara ekkada pude Hoore zumaa bolla keza. ");
INSERT INTO gmvl_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Aarooney qeeseteththas may7ida may7oza qaara ekkada El7ezeere mayza; Aarooney heen hayqqana» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Museykka GODAY izas gidayssa ubbaaka ooththides; kumeththa maabaray istta xeellishin istti pude Hoore zumaa bolla kezida. ");
INSERT INTO gmvl_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Museykka Aaroone qeeseteththa may7oza qaari ekkidi El7ezeere mayzides; Aarooney heen zumaa hu7en hayqqides; Museynne El7ezeerey zumaa bollafe duge simmi wodhdhida. ");
INSERT INTO gmvl_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Aarooney hayqqidayssa kumeththa derezi siyidi 30 gallas gakkanaas izas mishettidi yeekkides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Izas duussasoy Negebe gidida Kanaane dere kawo Araadey Isra7eele asay Ataraame baggara yizayssa siyidi istta bolla ola denththidi isttafe amardayta di7ides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","He wode Isra7eele asay, «Nuni hayssa dereza xoonana mala ne nuna maaddiko istta gidiin woykko istta katamata nam7anththo dendontta mala ooththidi nu istta mulera dippi histtana» giidi GODAAS adinida. ");
INSERT INTO gmvl_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","GODAY istta woosa siyidi maaddida gishshas istti Kanaane asaa xooni oykkida; hessa gishshas Isra7eele asay isttanne istta katama mulera dippi histti dhayssida; istti wuri wuridayssa eranaas hessa he gadeza, «Horma» gi sunththida. ");
INSERT INTO gmvl_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Isra7eele asay Eedoome dere yuuyi aadhdhidi baanaas qoppida Hoore zumaappe dendidi gede Zo7o abbaako efiza ogezara bida; gido attiin istti buro ogen dishin derezappe dandayay wurides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","GODAA bollanne Muse bolla iita qaala kessidi, «Haaththinne kaththi bayndaso hayssa bazzo biittan nu hayqqana mala nuna Gibxeppe ays kessidetii? Hayssi ha iita kaththay nuna saleththides» gida. ");
INSERT INTO gmvl_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Hessafe guye GODAY iita marzera diza shoosh dereza giddo yeddides; he shooshshay dukkiin Isra7eele asaappe daroy hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Derezikka Musekko biidi, «GODAA bollanne ne bolla nu iita qaala haasayda gishshas nuni qohidos; ha7ikka hayti dukkiza shooshshati nuuppe kichchana mala neni nuus GODAA woossarkkii!» gida; Museykka deraas woossides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","He wode GODAY Muses, «Neni xarqimala shoosh qoxxa kessada tuussa mala adussa miththa bolla kaqqa; shooshshi dukkida asi wurikka hessa be7idi attana» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Museykka xarqimalappe shoosh medhdhidi tuussa mala adussa miththa bolla qaaphides; shooshshi saxxida asi ubbay he xarqimala shooshshaa dhoqqu gi xeelliday xeelliday paxides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Isra7eele asay ba dizasoppe dendi biidi Obooten dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Heeppe dendidi Mo7aabeppe arshey mokkiza baggara diza Iye-Abaarime bazzon dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Heeppe dendi biidi Zaraade shoobban uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Heeppeka dendi biidi Amooreta derera kanththi biza bazzo Arnoone shaafappe he pinththan diza biittan dunkaani uttida; Arnoone shaafazi Mo7aabe deresinne Amoore derezas giddo dhassan dees. ");
INSERT INTO gmvl_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Hessa gaason GODAY kaaleththiin olettida ola gishshas yootiza taarike maxaafazan, «Suufa heeraninne shoobbatan diza Waheebe kataman Arnoonen haaththi baynda shaafan, ");
INSERT INTO gmvl_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","biidi Eere katamanne Mo7aabe dhas gakkanaas kanththi biza zoozeta» geetettides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Heeppe dendidi Bi7eere bida; hessika GODAY Muses, «Deraa issi bolla shiishsha; tani isttas haath immana» giidi yootida haaththa olla. ");
INSERT INTO gmvl_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","He wode Isra7eele asay hayssa, «Haysso pulttozo pultta; intteka izas yexxite. ");
INSERT INTO gmvl_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Kawoti ba kawoteththa guufen bookkida; daannati ba guufen ziqqisida; haaththa ollaas yexxite» gida. He bazzozappe dendidi gede Mataane bida. ");
INSERT INTO gmvl_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Mataaneppeka gede Nahal7eelera kanththidi gede Bamoote bida. ");
INSERT INTO gmvl_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bamooteppe dendidi Amoone deren diza shoobbaa bida; he shoobbayka Pizga zumaappe dan7e baggara bazzoza ginan dees. ");
INSERT INTO gmvl_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Hessafe guye Isra7eele asay Amoore dere kawo Sihoones qasttanne yeddidi, ");
INSERT INTO gmvl_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«Nuni ne biittara aadhdhi baana mala nuna aaththa yeddarkkii! Nuninne nu mehey ogeppe kare kezokko; gede ne kaththa giddo gidiin woykko ne woyne miththa gars nu gelokko; ne haaththa ollafe ekki uyokko; nuni ne derera aadhdhi baana gakkanaas ogeppe sher7i gookko» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sihooney gidikko Isra7eele asay iza biittara aadhdhi baana mala koyibeenna; harappeka izi baas diza ola asaa shiishshi ekkidi Yahaaxe bazzo wodhdhides; Isra7eele asaraakka ola oykettides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Isra7eele asay gidikko istta xoonides; Arnoone shaafappe doommidi Amoone dere dhas gidida Yaabooqe shaafa gakkanaas dizasoza oykkida; gido attiin Amoone asay ba zawa minni naagiza gishshas hee gelibeettenna. ");
INSERT INTO gmvl_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Isra7eele asay histtidi Amoore dere biittan diza katamata Haseboonenne he heeran diza guuththa katamatakka oykkidi dunkaani uttida. ");
INSERT INTO gmvl_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hasebooney Amooreta kawo Sihooney kawotida katama; izikka kase Mo7aaben kawotida kawozara olettidi Arnoone shaafaa gakkanaas diza biitta ubbaa isttafe woththi ekkides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Ginxo giigsidi yexxizayti hessa gishshas yexxishe «Haseboonekko haa yiite! Hanna katamaya gimbettu! Sihoone katamaya ooso doomettu. ");
INSERT INTO gmvl_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Hasebooneppe tamay kezides; Lacoykka Sihoone katamappe kezides; Mo7aabe deren Eere geetettizasoza dhayssides; Arnoonen bolla gezze biittan diza halaqatakka dippi histtides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Hanne Mo7aabe nees aayye ana! Intteno Kamooshes goynnizaytoo! Intte dippi gi dhayana; intte attuma nayta betes, intte macca naytakka di7eteththas Amoore kawo Sihoones aaththi immides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Hessa gishshas istta zereththay mulera dhaydes; Hasebooneppe biidi Diboone gakkanaas Nofappe biidi Medeba gakkanaas diza ubbaa piski histti laallidos» gida. ");
INSERT INTO gmvl_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Hessa gishshas Isra7eele asay Amoore deren dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Museykka Iyaazeere biidi xomosana as yeddides; Isra7eele asaykka he katamayonne izi heeran diza qeeri katamata oli oykkida; kase heen diza Amoore asata gooddida. ");
INSERT INTO gmvl_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Hessafe guye Isra7eele asay guye simmidi gede Baasaane efiza ogezara bida; Baasaane kawo Aagey Edira7en isttara ola oykettanaas ba olanchchata ubbaa ekki kezides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","GODAY Muses, «Hayssa addezas babbofa! Iza asaanne iza dereza ta nees aaththa immana; kase Haseboonen de7ishe Amooreta haariza kawo Sihoone bolla ne ooththoyssaththo hayssa bollaka ooththa» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Hessa gishshas Isra7eele asay Aage, iza naytanne iza deraa ubbaa dippi histtidi biitta baas ekkides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Hessafe guye Isra7eele asay dendidi Iyarkko ginara Yordaanoose shaafappe arshey mokkiza baggara diza Mo7aabe demban dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Isra7eele asay Amooreta bolla ooththidayssa ubbaa Xipoora naa Balaaqey siyides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Isra7eele asay keehi daro gidida gishshas Mo7aabe asay keehippe babbides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Mo7aabeti Midiyaame cimatas, «Booray maata mi dhayssiza mala ha maate asay nu yuushon diza ubbaa dippi histti dhayssana» gida. He wode Mo7aabe Kawo Xipoora naa Balaaqey, ");
INSERT INTO gmvl_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Amaawa biittan Efiraaxise shaafa matan Patoore katamaan diza Bi7oore naa Balaamekko qasttanne kiittidi, «Beya! Gibxe biittafe kezida issi derey biittaa may7ides; he derezi nu matan dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Istti nuuppe keehi wolqqama gidida gishshas woze nena huu! Haa yaada taas istta qanggarkkii! Ne qanggizaa gidikko ta istta xoonada biittafe kessanakko oonee erizay? Ays giikko neni anjjidaadey anjjettizayssa, ne qanggidaadey qanggettizayssa ta erays» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Histtiin Mo7aabe cimatinne Midiyaame cimati qanggisanaas ekki bida miishsha Balaames immidi Baalaaqe kiitaa yootida. ");
INSERT INTO gmvl_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaamey isttas, «Intte hach haan aqikko GODAY taas yootidayssa ubbaa ta inttes wonto maalado yootana» gides; histtiin Mo7aabe cimati Balaame matan aqida. ");
INSERT INTO gmvl_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Xoossi Balaamekko yiidi, «Hayti nenara diza asati ay asee?» giidi oychchides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaameykka Xoossas, «Mo7aabe kawo Xipoora naa Balaaqey, ");
INSERT INTO gmvl_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‹Gibxeppe kezida derey biittaa yi may7ides; neni yaada taas istta qanggizaa gidikko ta istta ola xoonada biittafe kessanakko oonee erizay!› gi kiittida asata» gi zaarides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Xoossi qasse Balaame, «Neni hayta ha asatara booppa; Isra7eele derey anjjettida dere gidida gishshas neni istta qanggofa» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Wonteththa gallas maaladora Balaamey dendidi Balaaqey kiittida cimatas, «Tani inttenara bontta mala GODAY diggida gishshas intte biitta simmite» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Histtiin Mo7aabe cimati Balaaqekko simmidi Balaamey isttara yontta ixxidayssa izas yootida. ");
INSERT INTO gmvl_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Hessafe guye zaaridikka Balaaqey kase kiitettidaytappe aadhdhi bonchchettidanne qoodan daro cimata Balaamekko kiittides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Isttika Balaamekko biidi, «Xipoora naa Balaaqey nena, ‹Neni taakko yontta mala ay miishshika nena teqqofo! ");
INSERT INTO gmvl_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Ta nees iza kushe zaarana; ne tana oychchida ubbaa ta nees immana; hessa gishshas ha dereza yaada ne taas qanggana mala ta nena shoobbays!› gides» gi yootida. ");
INSERT INTO gmvl_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Gido attiin Balaamey isttas, «Balaaqey ba kawoteththa keeththan diza biranne worqqa ubbaa izi taas immizaakkoka GODAY tana azazida azazoza menththada tani taappe ay miishshika gujjanaas woykko pacinchchanaas dandaykke. ");
INSERT INTO gmvl_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","GODAY taas yootiza hara miishshi diikko ta eranaashe gakkanaas intteka kaseytaththo hachcha omars haan aqite» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","He gallassa omars Xoossi Balaamekko yiidi, «Ha asati nena xeygana yida gishshas dendada isttara ba; gidikkoka ta nees yootizaaz xalla ooththa» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Histtiin wonteththa gallas Balaamey ba hare koori toggi ekkidi Mo7aabe halaqatara bides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Balaamey ba hare toggi ekkidinne ba aylletappe nam7ata kaaleththidi bishin GODAA hanqoy iza bolla tama mala eexxi kezides; histtiin GODAA kiitanchchay iza teqqanaas oge bolla aadhdhi eqqides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Hareya GODAA kiitanchchay giththa mashsha oykkidi eqqidayssa beyada ogeppe haraso kezadus. Balaamey hareyo ogen zaaranaas iita shoch shocides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Histtiin GODAA kiitanchchay nam7u baggara woyney tokettizasohoppe giddon ya baggaranne ha baggara gimbey gimbetti uttida un7oson eqqides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Hareya GODAA kiitanchchaza be7ida mala gimbezaakko shiiqada Balaame tohoza gimbezara daraxadus; histtiin Balaamey hareyo nam7anththo buka oykkides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Hessafe guye GODAA kiitanchchay gede sinththe aadhdhi biidi nam7u baggara aadhdhizasoy baynda xunththa ogen eqqides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Hareya GODAA kiitanchchaza be7ada Balaamey toggi dishin biittan ichchadus; hessa gishshas Balaamey ba guufera izo bukkides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","He wode GODAY hareys haasayanaas doona doyiin iza Balaames, «Ta nees ay iita ooththadinaa? Heedzdzuto ne tana ays shocadii?» gadus. ");
INSERT INTO gmvl_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaameykka izis, «Ne tana keeha kaa7ida gishshassa! Ta kushen mashshay dizaakko ta nena wodho wodhanashin!» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Hareyakka Balaames, «Hanno gakkanaas ne toggiza ta ne hareyo gidikkinaa! Hayssafe kase hanniththo hana erazinaa?» gadus. Balaamey izis zaaridi, «Mulekka hayssaththo hana erakka» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","He wode GODAY Balaame ayfeta doyiin GODAA kiitanchchay giththa mashsha shoddi oykkidi ogen eqqidayssa be7idi Balaamey biitta bolla gufannides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","GODAA kiitanchchazi izas, «Ne hareyo ays heedzdzuto shocadii? Tani yaada ne oge gordiday ne biza ogezi geella gidida gishshas nena zaaranaassa. ");
INSERT INTO gmvl_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ne hareya tana be7ada heedzdzuto ta sinththafe baqatadus; iza baqatonttaako ta izo aggada nena wodhaychchanakkoshin» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaamey GODAA kiitanchchaas zaaridi, «Tumukka ta nagara ooththadis; ne tana teqqanaas oge bolla eqqidayssa ta erabeekke; ha7ikka ne ta buussaa dosonttaa gidikko tani guye taso simmana» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","GODAA kiitanchchay Balaames, «Ne ha asatara ba shin tani nees yootizayssa xalla yoota» gides; histtiin Balaamey Balaaqey kiittida halaqatara bides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaaqey Balaamey yizayssa siyidi iza mokkanaas Mo7aabe bazzon Arnoone shaafa achchan diza Eere katama bides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaaqey Balaame, «Koyro ta neekko kiittida asatara aazas yontta ixxadii? Ta nena bonchchontta as misatiinee?» gi iza oychchides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaameykka Balaaqes, «Gidikkoka ha7i tani neekko yadis; ha7ikka taas ay wolqqay dizee? Ta haasayana dandayzay Xoossi taas yootooro xalla» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Hessa gishshas Balaamey Balaaqera gede Qiriyaate Huxoote katama bides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaaqey heen mehe shukissidi he ashozappe guuth heen banara diza dere kaaleththizaytassinne Balaames immides. ");
INSERT INTO gmvl_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Wonteththa gallas maalado Balaaqey Balaame Isra7eele asaappe baggay beettizaso pude Bamooti Ba7aale geetettiza zumaa bolla kessides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaamey Baalaaqe, «Ne taas hayssan laappun yarsho yarshanaasota ooththa; qasseka laappun korma booratanne laappun dorsa dharshota taas haa ekka ya» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaaqey Balaamey izas yootida mala ooththides; istti nam7ay yarsho yarshizasohota bolla issi issi korma booranne issi issi dharsho yarsho shiishshida. ");
INSERT INTO gmvl_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Hessafe guye Balaamey Balaaqes, «Xoossi haa taakko Yaanaakkonne yonttaakko tani gede baada erana gakkanaas neni hayssan xuugettiza yarshoza achchan eqqaashsha; GODAY taas qonccisikko hessa ta nees wursa yootana» gides; hessafe guye Balaamey barkka pude dhoqqaso kezides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Heen Xoossi izara gayttides; Balaameykka, «Tani laappun yarsho yarshizasohota giigsadis; yarsho yarshizasohota issaa issaa bolla issi issi korma booranne issi issi dharsho yarshadis» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","GODAYKKA Balaamey Balaaqes yootanaas bessiza kiita izas yootidaappe guye Balaaqekko simmi baana mala yootides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Izikka guye simmi bishin Balaaqey Mo7aabe ayssiza daannata ubbaara issife he xuugettiza yarshoza achchan eqqida mala demmides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Hessafe guye Balaamey haasaya doommidi, «Mo7aabe kawo Balaaqey arshey mokkiza baggara diza zumati diza Aaraameppe tana xeygi ehides; izi tana, ‹Haa yaada Isra7eele asaa taas doqqarkkii! Istti dhayana mala taas istta qanggarkkii!› gides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Histtiin tani Xoossi qanggonttaade wostta qanggoo? Xoossi hilonttaade tani wostta hiloo? ");
INSERT INTO gmvl_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Tani istta hayta gita zaallata bolla dashe demmays; dhoqqa zumata bolla dashe ta istta xeellays; istti barkka diza kawoteth; istti bana hara kawoteththara gaththi qoodonttayssi taas beettees. ");
INSERT INTO gmvl_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Gudulla mala corida Yaaqoobe zereththaa qoodi dandayanay oonee? Woykko Isra7eeles cigozakka qoodi kanththanay oonee? Xillo asata hayqo ta hayqqana; ta wurseththayka istta wurseththaa mala gido» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaaqey Balaames, «Hayssi ne ta bolla ooththidayssi aazee? Tani nena haa ehiday ne ta morkketa qangganaassa; neni gidikko istta anjjo anjjadasa attiin qanggabeekka» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balaameykka zaaridi, «GODAY taas qonccisidayssa xalla ta yootanaas bessennee?» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balaaqey Balaames, «Isra7eele asaa kumeththaa gidontta isttafe guuththati nees beettizaso gede haraso tanara issife baada ne istta heen taas qanggarkkii!» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Hessafekka pude Pizga zumaa hu7en diza Xoofime demba efides; heenkka laappun yarsho yarshizaso giigsidi issi issi yarshizasoza bolla issi issi korma booranne dharsho yarshides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaamey Balaaqes, «Neni hayssa xuugettiza yarshoza matan eqqaashsha; tani GODAARA gayttana gede bays» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","GODAYKKA Balaamera heen gayttides; izi yootana kiitaa izas yootidi neni Balaaqekko simma baada hayssa ha kiitaa izas yoota. ");
INSERT INTO gmvl_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Izi simmi bishin Balaaqey Mo7aabe dereza kaaleththizaytara he xuugettiza yarshoza matan eqqida mala demmides; Balaaqeyka GODAY izas ay yootidaakko iza oychchides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balaameykka izas haasaya doommishe, «Xipoora naa Baalaaqe! Haa shiiqa! Tani nees yootizayssa siya. ");
INSERT INTO gmvl_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Xoossi asa mala wordotenna; iza qofay asa qofa mala laamettenna; izi ba immida hidota ubbaa polees; izi ba yootida ubbaa ooththees. ");
INSERT INTO gmvl_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Izi taas ta anjjana mala yootides; Xoossi anjjida qaalaa tani laammanaas dandaykke. ");
INSERT INTO gmvl_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Yaaqoobe zereththa bolla metoy gakkenna; Isra7eele asaa bollaka waayey gakkonttayssi taas beettees; GODAY isttara dees; Xoossi kawo gididayssa istti qonccen yooteettes. ");
INSERT INTO gmvl_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Xoossi istta Gibxeppe kessides; izi isttas menththa mala qaycana. ");
INSERT INTO gmvl_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Yaaqoobe nayta bolla ay bitay, Isra7eele bolla ay muurennoyka ooththenna; hekko ha7i Yaaqoobessinne Isra7eeles, ‹Xoossi istti ay ooththidaakko ane xeellite!› geetettana. ");
INSERT INTO gmvl_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Isra7eele asay macca gaammo mala dendana; ba shankkati ehidayssa montta, suuththaaka uyontta dishe shempontta gaammo mala dendana» gi yootides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Hessafe guye Balaaqey Balaames, «Neni Isra7eele asaa qanggontta ixxida mala istta anjjoka anjjofa!» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaameykka, «Tani kase nees GODAY taas yootooro xalla ta ooththana gaada yootabeekkinaa?» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaaqeyka, «Haa ya ane hayssafe haraso boos; oonee erizay neni heen daada hayssa dereza taas qanggana mala Xoossi nees ero gontta aggenna» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Hessa gishshas Balaaqey Balaame gede bazzo ginara diza Pe7oore zumaa hu7e ekki kezides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaameykka iza, «Hayssan taas laappun yarsho yarshizaso giigsa; laappun korma booratanne laappun dharshota haa taas ekka ya» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaaqeyka Balaamey izas yootida mala ooththides; yarsho yarshizasoza bolla issi issi korma booranne issi issi dharsho yarsho shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balaameykka GODAY Isra7eele asaa anjjanaas dosidayssa erida wode kase izi ooththizayssa mala muurenno ooso ooththanaas koyibeenna; ba sinththaaka duge bazzo zaarides. ");
INSERT INTO gmvl_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Isra7eele asay ba qommon qommon maarara dunkaani uttidayssa be7ides; Xoossa Ayanay iza bolla wodhdhides; ");
INSERT INTO gmvl_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","histtiin izi tinbite haasaya doommidi, «Bi7oore naa Balaamey haasayza tinbite qaalay, iza ayfetikka doyettidaadey, ");
INSERT INTO gmvl_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Xoossa qaala siyizaadey izi kundi dishin iza ayfeti doyettiin Ubbaa Dandayza Xoossa ajjuuta be7izaade kiitay hayssa. ");
INSERT INTO gmvl_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Yaaqoobe ne dunkaaneti Isra7eele ne dizasoti ay mala lo7oo? ");
INSERT INTO gmvl_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Isttika micettida zulleta mala; qasseka shaafa doonan diza atakiltesohota mala; GODAY tokkida godare uuththa mala; woykko shaafa doonan diza Libaanoose ziga mala. ");
INSERT INTO gmvl_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Iray ubba wode isttas bukkiza gishshas istta haaththi kumi palahees; zereththa wode isttas gidiza haaththi dees; istta kawoy Agaageppe aadheth gidana; istta kawoteththi dhoqqu dhoqqu gaana. ");
INSERT INTO gmvl_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Istta Gibxeppe kessida Xoossi isttas menththa mala olettana; istta morkke gidida kawoteththata izi puuzereththi yeggana; izi istta meqeththata liiqisana; istta wondafetakka menththereththi yeggana. ");
INSERT INTO gmvl_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Hayssi kawoteththay gaammo mala zamadi uttides; macca gaammo malakka zuggi uttides; istti zamadi uttidasohoppe istta denththana dandayzay oonee? Nena anjjizaadey anjjetto; nena qanggizaadeyka qanggetto» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balaaqey hanqon ba kushe baqqidi Balaames, «Tani nena ta morkketa qangganaas xeygadis; gido attiin neni istta heedzdzuto anjjadasa. ");
INSERT INTO gmvl_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Ha7i gidikko eeson gede neso ba! Ta nees daro miish immana ga qaala geladis; gido attiin ne he miishshaa demmontta mala Xoossi gordides» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaamey Balaaqes zaaridi, «Neni taakko kiittida asatas, ");
INSERT INTO gmvl_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‹Balaaqey baas diza biranne worqqa ubbaa izi taas immizaakkoka tani ta shenen iita gidiin woykko lo7o ooththanaas GODAA qaalappe aadhdhanaas dandaykke; tani yootanay GODAY taas yootooro xalla› gaada kase ta isttas yootabeekkinaa?» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Wurseththan Balaamey Balaaqes, «Ha7i tani gede ta dere simma bays; gido attiin ta baanaappe kasetada Isra7eele asay ne dere asaa bolla gaththanayssa nees qonccisanaas koyays» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Hessafe guye izas tinbite yooto doommidi, «Iza ayfey doyettidaadey, Bi7oore naa Balaamey yootiza tinbite qaalay hayssa; ");
INSERT INTO gmvl_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Xoossa qaala siyizaade, izi kundi dishin iza ayfeti doyettiin Wolqqama Xoossafe erateth demmidaade, Ubbaa Dandayza Xoossaa ajjuuta be7izaade kiitay hayssa. ");
INSERT INTO gmvl_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Tani iza be7ays; gido attiin ha7i gidenna; ta iza xeellays; gidikkoka ha7i matan gidenna; Xoolinttey Yaaqoobeppe beettana; Kawoteththa guufey Isra7eeleppe kezana; Mo7aabe zereththaanne Seete zereththata ubbaa dippi histti dhayssana. ");
INSERT INTO gmvl_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Eedoomey xoonettana; iza morkke Seyreykka izas haarettana; Isra7eele derey xoonoy xoonoshin daana. ");
INSERT INTO gmvl_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Yaaqoobeppe dere ayssizaadey kezana; izi katama giddon attidayta pitti dhayssana» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Hessafe guye Balaamey gede Amaaleeqe zaari xeellidi, «Amaaleeqey ubbaafe aadhdhiza wolqqama kawoteth; gido attiin izi wurseththan mernaas dhayana» gi tinbite yootides. ");
INSERT INTO gmvl_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Gede Qenaawe dere asaakko simmi xeellidi, «Ne duussasoy ammanettidaso misatikkoka, Ne keeththay zaallafe woocetti keexettidaa gidikkoka, ");
INSERT INTO gmvl_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Intteno Qenaawe deretoo! Asoorey inttena xoonidi di7i efiza wode intte wuri wurana» gi tinbite yootides. ");
INSERT INTO gmvl_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Wurseththan Balaamey, «Xoossi hayssa ooththishin oonee shemppora paxa daanay? ");
INSERT INTO gmvl_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Olas worajjiza asay markabera Qophirooseppe yaana; isttika Asoorenne Eboore dhayssana; isttika ba hu7es mernaas dhayana» gi tinbite yootides. ");
INSERT INTO gmvl_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Hessafe guye Balaamey dendidi gede ba dere bides; Balaaqeyka baso simmides. ");
INSERT INTO gmvl_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Isra7eele asay Shiixime shoobban diza wode addeti heen diza Mo7aabe dere maccassatara laymatida; ");
INSERT INTO gmvl_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","He Mo7aabe maccassati eeqa xoossatas yarshiza yarsho kaththaafe maana mala Isra7eele asaa xeygiin isttika he kaththaafe miidi eeqa xoossas goynnida. ");
INSERT INTO gmvl_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Isra7eele asay Ba7aali-Pe7oore geetettiza eeqa xoossaas goynnida gishshas Xoossi istta bolla hanqettides. ");
INSERT INTO gmvl_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","GODAY Muses, «Isra7eele asaa bolla eexxida ta hanqoy dochchana mala Isra7eele asaa kaaleththizayta ubbaa ekkada seeta gallas suulliza awan derezi be7ishin kaqqa wodha» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Museykka Isra7eele asaa bolla pirdiza daannatas, «Intte issoy issoy intte zarkkefe zarkkefe Ba7aali-Pe7oore geetettiza eeqa xoossazas goynnida as ubbaa wodhite» giidi azazides. ");
INSERT INTO gmvl_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Museynne kumeththa maabaray Gaytoteththa Dunkaane pengen shiiqidi yeekkishin Isra7eele asaa garsafe issaadey issi Midiyaame maccassayo ekkidi deraa sinththara aadhdhi gede baso asaakko bides. ");
INSERT INTO gmvl_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Qeese Aaroones naaza nay, El7ezeere naa Finihaasi hessa be7idi kase ba uttidasohoppe pusukku gi dendidi tohora ekkidi dereza giddofe kezi bides. ");
INSERT INTO gmvl_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","He addezinne maccassaya izan diza dunkaanen gelides; nam7atakka issi bolla toorara caddi wodhides; histtiin Isra7eele asaa bolla yida boshay simmides. ");
INSERT INTO gmvl_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Boshay simmana gakkanaas sinththan hayqqida asay 24,000 gidides. ");
INSERT INTO gmvl_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«Qeese Aaroones naaza naa, El7ezeere naa Finihaasi Isra7eele asaa giddon tani ta bonchchos eqettiza mala izi eqettida gishshas istta bolla ta hanqettida hanqoy dochchides; hessa gishshas tani ta hanqozan Isra7eele asaa dhayssabeekke. ");
INSERT INTO gmvl_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Hessa gaason tani izas mernaa saroteththa caaqo qaala gelidayssa ne izas yoota. ");
INSERT INTO gmvl_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Izi ba Godaa bonchchos eqqida gishshassinne deraa nagara izi wursida gishshas izinne iza zereththati ubbay mernaas qeese gidana.» ");
INSERT INTO gmvl_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","He Midiyaame maccassayra issife hayqqida Isra7eele addeza sunththi Saalu naa Zimire geetettees; izikka Simoona zarkketas korapinne. ");
INSERT INTO gmvl_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","He maccassaya Kozeebo geetettawus; izi aaway Xuure geetettees; izikka banara issife diza amarda Midiyaame qommotas korapinne. ");
INSERT INTO gmvl_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«Intte Midiyaame asaa morkke mala qoodidi dippi histti dhayssite. ");
INSERT INTO gmvl_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Gaasoykka istti Pe7ooren intte bolla gene ooththida gishshassinne heen wodhdhida bosha geedon hayqqida istta halaqaa nayo Kozeebi baggara baleththidi intte bolla morkketeththa ooso ooththida gishshassa.» ");
INSERT INTO gmvl_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","He boshazi aggidaappe guye Xoossi Musessinne qeese Aaroone naa El7ezeeres, ");
INSERT INTO gmvl_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«Kumeththa Isra7eele maabaran issaade keeththan keeththan isttas layththi 20 kumidaytanne hessafekka bollara gididi wottadareteththan ooththanaas dandayza attuma nayta ubbaa qoodite» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Museynne qeese El7ezeerey Yordaanoose shaafa matan Iyarkko ginara diza Mo7aabe dembaan dereza shiishshidi, ");
INSERT INTO gmvl_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«GODAY Muses azazida mala nam7u tammu layththinne hessafekka bollara diza asaa ubbaa qoodite» gida. Gibxe dereppe kezida Isra7eele asay hayssafe kaallizayta; ");
INSERT INTO gmvl_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Yaaqoobes bayra naaza Oroobeele zarkkefe yelettidayti Heenookenne iza zereththata, Paalunne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hexiroomenne iza zereththata, Karmenne iza zereththata. ");
INSERT INTO gmvl_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Oroobeele zarkkefe qoodettidayti 43,730. ");
INSERT INTO gmvl_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Paalu nay Elyaabe; ");
INSERT INTO gmvl_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Elyaabe nayti Namu7eele, Daataanenne Abraame; Daataaneynne Abraamey derezan doorettidayta gidi uttidi Qooreranne iza kaallizaytara zuppetidi GODAA bolla makkallidi Musenne Aaroone paaccida. ");
INSERT INTO gmvl_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Isttaka biittaya doyettada Qoorera issi bolla gaththa mittadus; isttika hayqqiin saloppe wodhdhida tamay 250 asaa xuuggides; histtiin istta qaxxayeteththi hara asaas malata gidides. ");
INSERT INTO gmvl_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Qoore zereththati gidikko hayqqibeettenna. ");
INSERT INTO gmvl_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simoona zarkkefe yelettidayti Namu7eelenne iza zereththata, Yaaminenne iza zereththata, Yaakinenne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zaraahenne iza zereththata, Sa7oolenne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Simoona zarkketappe qoodettidayti 22,200 addeta. ");
INSERT INTO gmvl_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gaade zarkkefe yelettidayti Xifoonenne iza zereththata, Haggenne iza zereththata, Shuunenne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Osinanne iza zereththata, Eerenne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Aroodenne iza zereththata, Ar7eelenne iza zereththata. ");
INSERT INTO gmvl_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Gaade zarkketappe qoodettidayti 40,500 addeta. ");
INSERT INTO gmvl_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Yuhuda zarkkefe yelettidayti, Eeranne Oonaane; istti Kanaane biittan hayqqida. ");
INSERT INTO gmvl_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Hankko attida Yuhuda zarkkefe yelettidayti Seloomenne iza zereththata, Paareesenne iza zereththata, Zaraahenne iza zereththata. ");
INSERT INTO gmvl_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Paareese zereththati Hexiroomenne iza baggata, Hamulenne iza zereththata. ");
INSERT INTO gmvl_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Yuhuda zarkkefe qoodettidayti 76,500 addeta. ");
INSERT INTO gmvl_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Yisakoore zarkkefe yelettidayti Tola iza zereththata, Puuwanne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yaashubenne iza zereththata, Shimiroonenne iza zereththata. ");
INSERT INTO gmvl_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Yisakoore zarkketappe qoodettidayti 64,300 addeta. ");
INSERT INTO gmvl_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zaabiloone zarkkefe yelettidayti, Sereedenne iza zereththata, Eeloonenne iza zereththata, Yaahile7eelenne iza zereththata. ");
INSERT INTO gmvl_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Zaabiloone zarkkefe qoodettidayti 60,500 addeta. ");
INSERT INTO gmvl_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Yooseefe zarkkefe yelettidayti, Minaasenne iza zereththata, Efreemenne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Minaase nayta zereth Maakirey Gala7aade yelides; ");
INSERT INTO gmvl_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Gala7aade nayti Eezerenne iza zereththata, Heleeqenne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asira7eelenne iza zereththata, Seekeemenne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Shamidanne iza zereththata, Hefeerenne iza zereth. ");
INSERT INTO gmvl_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Hefeere naa Xilofaadey macca nayta xalla yelides; heytikka Mahilo, No7o, Hogilo, Milkkonne Tirxxo geetetteettes. ");
INSERT INTO gmvl_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Minaase qommotappe qoodettidayti 52,700 addeta. ");
INSERT INTO gmvl_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Efreeme zarkkefe yelettidayti, Shutulanne iza zereththata, Bekerenne iza zereththata, Tahaanenne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Shutula naa Eraanenne iza zereththata. ");
INSERT INTO gmvl_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Efreeme zarkketappe qoodettidayti 32,500 addeta; Yooseefe zarkkefe ba baggan baggan qoodettidayti haytantta. ");
INSERT INTO gmvl_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Biniyaame zarkkefe yelettidayti, Beelanne iza zereththata, Ashibeelenne iza zereththata, Ahiraamenne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Shafaamenne iza zereththata, Hufumenne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Beela zarkkefe Araadenne iza zereththata; Na7imaanenne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Biniyaame zarkkefe qoodettidayti 45,600 addeta. ");
INSERT INTO gmvl_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Daane zarkketappe yelettidayti, Shuhaamenne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Shuhaame zereththata qooday 64,400 addeta. ");
INSERT INTO gmvl_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Aaseere zarkketappe yelettidayti Yiminenne iza zereththata, Yishiwenne iza zereththata, Barihenne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Barihe naytappe Heeberenne iza zereththata, Malkki7eelenne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Aaseeres Seraho geetettiza macca nay dawus. ");
INSERT INTO gmvl_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Aaseere zarkketappe qoodettidayti 53,400 addeta. ");
INSERT INTO gmvl_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Niftaaleme zarkkefe yelettidayti, Yahixelenne iza zereththata, Gunenne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yexirenne iza zereththata, Shelemenne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Niftaaleme zarkketappe qoodettidayti, 45,400 addeta. ");
INSERT INTO gmvl_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Kumeth qoodettida Isra7eele attumasay 601,730 gidides. ");
INSERT INTO gmvl_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«Biittayo istta sunththa sunththa qooda mala zarkketas xinxxo gidana mala shaakka shaakkada imma. ");
INSERT INTO gmvl_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Qoodan dariza zarkketas aassa imma; qoodan guuxxizaytas xunththa imma; biitta gishoy asaa qooda corateththaa mala gido. ");
INSERT INTO gmvl_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Gidikkoka gishozi saaman gido; saamazikka yegettanay izaade zarkken zarkkenna. ");
INSERT INTO gmvl_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Saamazi yegettanay qoodan daro zereththata giddoninne qoodan guuththa zereththata giddon gido.» ");
INSERT INTO gmvl_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Lewe zarkkefe yelettidayti Gershoonenne iza zereththata, Qa7aatenne iza zereththata, Meraarenne iza zereththata, ");
INSERT INTO gmvl_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Qasseka Libina zereththata, Kebroone zereththata, Mahile zereththata, Mushe zereththata, Qoore zereththata, Qa7aatey Amiraame ma7e. ");
INSERT INTO gmvl_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amiraamey Gibxen yelettida Lewe nayo Yokaabedo machcho ekkides; izakka Aaroonenne Muse geetettiza nam7u attuma naytanne Maaramo geetettiza issi macca naa yeladus. ");
INSERT INTO gmvl_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaroones Nadaabe, Abihu, El7ezeerenne Itamaare geetettiza oyddu attuma nayti deettes. ");
INSERT INTO gmvl_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadaabeynne Abihuy Xoossa sinththan bessontta tama shiishshida gishshas boshan hayqqida. ");
INSERT INTO gmvl_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Isttas layththay issi aginanne izappe bollara gidida Lewe zarkkefe addeta qooday 23,000 gidides; heytikka hankko Isra7eele asaappe dumma mazgaban xaafetti uttida; gaasoykka isttas Isra7eele deren xinxxos gidiza aykko gadey imettonttayssasa. ");
INSERT INTO gmvl_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Museynne El7ezeerey Iyarkko ginara Yordaanoose shaafaa matan diza Mo7aabe demban Isra7eele asaa qoodida wode istti xaafi oykkida Isra7eele asaa qooday hayssafe bollan dizayta. ");
INSERT INTO gmvl_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Museynne Aarooney koyro Siina bazzon deraa qoodida wode qoodettida attumasaappe shemppora paxa attiday baawa. ");
INSERT INTO gmvl_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Hessi hessaththo haniday GODAY kase isttas, «Istti wurikka bazzo biittan hayqqana!» gida gishshassa; gido attiin Yoofine naa Kaalebeynne Nawe naa Iyaasoy attaafe ubbayka hayqqida. ");
INSERT INTO gmvl_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Yooseefey Minaase yelides; Minaasey Maakire yelides; Maakirey Gala7aade yelides; Gala7aadey Hefeere yelides; Hefeerey Xilofaade yelides; Xilofaades mahilo, No7o, Hogilo, Milkkonne Tirxxo geetettiza macca nayti deettes. ");
INSERT INTO gmvl_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Isttika Gaytoteththa Dunkaaneza pengeeko biidi kumeththa maabaranne dereza kaaleththizayti dizason Musenne El7ezeere sinththan aadhdhi eqqidi, ");
INSERT INTO gmvl_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«Nu aaway issi attuma naakka yelontta bazzo biittan hayqqides; izi GODAA bolla makkallida Qoore kaallizaytara issife zuppetibeenna; gido attiin izi ba nagara gaason hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Histtiin izi attuma naa yelontta aggida gaason xalla nu aawa sunththi Isra7eele asaa giddofe qucetti dhayanaas bessizee? Hessa gishshas nuus bessiza xinxxo gade nu aawa dabbota giddon immite» gida. ");
INSERT INTO gmvl_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Musey istta oyshaa GODAA sinth shiishshides. ");
INSERT INTO gmvl_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","GODAYKKA izas hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«Xilofaade macca nayti oychchida oyshay likke; hessa gishshas ne istta aawa dabbota giddon isttas xinxxo gade imma; kase istta aawa gadey gede isttas imetto. ");
INSERT INTO gmvl_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Attuma naa yelontta hayqqidaadey diikko iza macca nay he izas dizaaz laattanaas dandayzayssa Isra7eele asaa erisa. ");
INSERT INTO gmvl_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Izas macca naykka bayndaaz gidikko izas dizaaz iza ishati laattetto. ");
INSERT INTO gmvl_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ishaykka dontta aggiko iza aawa ishati laattetto. ");
INSERT INTO gmvl_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Izas aawa ishay dontta aggiko izas matattiza dabboy iza aqota laattidi go7ettanaas dandayees; tani GODAY nena azazida mala Isra7eele dere asay hayssa ha wogaza baas eqqi diza woga histti naago.» ");
INSERT INTO gmvl_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","GODAY Muses, «Neni pude Abaarime zumata bolla kezada tani Isra7eele asaas immanaas qoppida biitta ubbaa yuushsha xeella. ");
INSERT INTO gmvl_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Neni iza beydaappe guye ne isha Aarooney hayqqoyssaththo nekka hayqqana; ");
INSERT INTO gmvl_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Intte nam7atikka Xiine geetettiza bazzon ta azazo bolla makkallideta; kumeththa maabaray Mariiba haaththaa achchan dishe ta bolla makkallida wode intte Isra7eele asaa sinththan ta dummateththaa mala tana bonchchanaas ammanettibeekketa» gides; Mariibay Xiine bazzon Qaadeesen diza pultto haaththa. ");
INSERT INTO gmvl_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Museykka GODAAKKO hizgi woossides, ");
INSERT INTO gmvl_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«As ubbaas de7o immida GODAWU! Hayssa deraa heemmiza as neni doora; ");
INSERT INTO gmvl_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","gaasoykka hayssa ne derezi heemmizay baynda wude mala gidontta mala izi deraa kessizaadenne gelththizaade, derezakka kaaleththizaade gidana.» ");
INSERT INTO gmvl_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","GODAYKKA Muses, «Lo7o ayanay izan diza Nawe naa Iyaaso neekko ekkada ne kushe iza bolla woththa. ");
INSERT INTO gmvl_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Qeeseza El7ezeere sinththaninne kumeththa Isra7eele asaa sinththan ne iza essada izi ne olla doorettidayssa asaa erisa. ");
INSERT INTO gmvl_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Kumeththa Isra7eele maabaray izas azazettana mala nees diza maatappe izas shaakka imma. ");
INSERT INTO gmvl_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Qeese El7ezeerey Urimen GODAA shene shaakki eriza gishshas izi Iyaaso maaddana; hessa gishshas Iyaasoynne kumeththa Isra7eele maabaray El7ezeere azazon kezananne gelana» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Museykka GODAY iza azazida mala ooththides; Iyaasokka efidi qeese El7ezeere sinththaninne kumeththa Isra7eele asaa sinththan essides. ");
INSERT INTO gmvl_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","GODAY iza azazida mala Musey ba kushe Iyaaso bolla woththidi iza basohozan doorides. ");
INSERT INTO gmvl_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","GODAY Muses, ");
INSERT INTO gmvl_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«Neni Isra7eele asaas, ‹Iza sawoy tunnu gi tana ufayssana mala xuugettiza kaththa yarsho woden woden naagidi istti taas shiishshana mala ne istta azaza› ga yoota. ");
INSERT INTO gmvl_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Qasseka isttas, ‹Taman xuugettidi taas shiiqana yarshoy hayssafe kaallizayssa; istta bolla wosoy baynda layth gidiza nam7u dharsho laaqqata gallas gallas shiiqi xuugettiza yarshos shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Issi laaqqa maalado nam7anththoza omarsa wode shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Issi issi laaqqara issi kilo gidiza liiqo dhiille issi litiro gidiza wogara zayten munuqettidi kaththa yarsho gidi shiiqo. ");
INSERT INTO gmvl_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Hessika gallas gallas shiiqiza xuugettiza yarsho; hessa mala yarsho sawoy tana GODAA ufayssiza yarsho gididi koyro Siina zumaa bolla shiiqana mala wogay wodhdhides. ");
INSERT INTO gmvl_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Koyro laaqqazara shiiqiza ushsha yarshoy issi litiro gidiza mino ushshu geeshshasozan GODAAS gussite. ");
INSERT INTO gmvl_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Omarsa wode nam7anththo laaqqaza koyroyssaththoka ushsha yarshoza gujjidi shiishshite; hessa sawoykka GODAA ufayssiza kaththa yarsho gidana. ");
INSERT INTO gmvl_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","« ‹Sambata gallas, layth gidida wosoy istta bolla baynda nam7u dharsho laaqqata, ushsha yarshoranne nam7u kilo gidiza liiqo dhiille wogara zayten munuqidi kaththa yarsho histti shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Hayssi ha yarshozi ushsha yarshozappenne gallas gallas xuugettiza yarshozappe Sambata gallas gallas shiiqiza hara xuugettiza yarsho. ");
INSERT INTO gmvl_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","« ‹Aginan aginan koyro gallas gallas istta bolla wosoy baynda nam7u mirgota, issi dharshonne layth kumida laappun dharsho laaqqata GODAAS xuugettiza yarsho histti shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Issi issi mirgora kaththa yarshos heedzdzu kilo gidiza liiqo dhiille wogara zayten munuqidi shiishshite; qasse dharshozara kaththa yarshos nam7u kilo gidiza liiqo dhiille wogara zayten munuqi shiishshite; ");
INSERT INTO gmvl_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","issi issi dharsho laaqqara kaththa yarshos issi kilo gidiza liiqo dhiille wogara zayten munuqi shiishshite; he xuugettiza yarshota ubbaa sawoy GODAA ufayssiza kaththa yarsho gidi shiiqo. ");
INSERT INTO gmvl_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Issi issi mirgora nam7u litiro gidiza woyne ushshu, dharshozara issi litironne sayso gidiza woyne ushshunne issi issi laaqqara issi litiro gidiza woyne ushshu yarshos shiishshite; hessika aginan aginan layth kumeth shiiqiza xuugettiza yarsho. ");
INSERT INTO gmvl_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Gallas gallas xuugettiza yarshonne izara shiiqiza ushsha yarshoza bolla deysha orge nagara gishshas yarsho gidana mala GODAA sinth shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","« ‹GODAAS Paaziga ba7aale koyro aginay gelida tammanne oydanththo gallas bonchchite. ");
INSERT INTO gmvl_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Ha aginay gelida tammanne ichchashanththo gallassafe doommidi ukeththa ba7aale bonchchite; he gallassafe biidi laappun gallas gakkanaas uketh miite. ");
INSERT INTO gmvl_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Ba7aalezas koyro gallas goynnanaas shiiqite; he gallas ay oosokka ooththofte. ");
INSERT INTO gmvl_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Istta bolla wosoy baynda 2 mirgota, issi dharshonne layth kumida laappun dharsho laaqqata xuugettiza yarsho histti GODAAS shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Issi issi mirgora kaththa yarshos heedzdzu kilo gidiza liiqo dhiille wogara zayten munuqidi shiishshite; qasse dharshozara kaththa yarshos nam7u kilo gidiza liiqo dhiille wogara zayten munuqi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Issi issi dharsho laaqqara kaththa yarshos issi kilo gidiza liiqo dhiille wogara zayten munuqi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Qasseka nagara wursanaas deysha orge nagara yarshos shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Heyti wurikka shiiqanay ubba wode maalado maalado xuugetti shiiqiza yarshora issife shiiqetto. ");
INSERT INTO gmvl_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","GODAA sawo tunnu giidi ufayssiza kaththa yarsho laappun gallas kumeth issi malan shiishshite; hessaka gallas gallas shiiqiza xuugettiza yarsho bollanne ushsha yarsho bolla gujjidi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Laappunththo gallas goynnanaas shiiqite; he gallas ay oosokka ooththofte. ");
INSERT INTO gmvl_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","« ‹Kaththa shiishon ba7aale bonchchiza koyro gallas intte oorath gakkiza kaththaafe xeeraa GODAAS shiishshiza gallas goynnana shiiqiteppe attiin hara ay oosokka ooththofte. ");
INSERT INTO gmvl_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Nam7u mirgota, issi dharshonne layth kumida laappun dharsho laaqqata sawo tunnu giidi GODAA ufayssiza xuugettiza yarsho shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Issi issi mirgora kaththa yarshos heedzdzu kilo gidiza liiqo dhiille wogara zayten munuqidi shiishshite; qasse dharshozara kaththa yarshos nam7u kilo gidiza liiqo dhiille wogara zayten munuqi shiishshite; ");
INSERT INTO gmvl_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","issi issi dharsho laaqqara kaththa yarshos issi kilo gidiza liiqo dhiille wogara zayten munuqi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Qasseka nagara wursanaas deysha orge nagara yarshos shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Hessa he yarshoza ubbaa ushsha yarshora, he gallas shiiqi xuugettiza yarshozanne kaththa yarshoza bolla gujjidi shiishshite; he yarsho meheti wosoy bayndayta gididayssa shaakki erite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","« ‹Laappunththa aginay gelida koyro gallas goynnanaas shiiqite; he gallas ay oosokka ooththofte; he gallassay zayey punettiza gallassa. ");
INSERT INTO gmvl_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Istta bolla wosoy baynda issi mirgo, issi dharshonne layth kumida laappun dharsho laaqqata sawoy tunnu giidi GODAA ufayssiza xuugettiza yarsho yarshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Issi mirgozara kaththa yarshos heedzdzu kilo gidiza liiqo dhiille wogara zayten munuqidi shiishshite; qasse dharshozara kaththa yarshos nam7u kilo gidiza liiqo dhiille wogara zayten munuqi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","Issi issi dharsho laaqqara kaththa yarshos issi kilo gidiza liiqo dhiille wogara zayten munuqi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Qasseka nagara wursanaas deysha orge nagara yarshos shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Intte hayssa ha yarshoza gallas gallassinne aginan aginan koyro gallas shiiqi xuugettiza yarshoza, kaththa yarshozanne ushsha yarshoza bolla gujjidi shiishshite; heytanttika sawo tunnu giidi GODAA ufayssiza xuugettiza yarshota. ");
INSERT INTO gmvl_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","« ‹Laappunththo aginay gelida tammanththa gallas goynnanaas shiiqite; he gallas xoomite; oosokka ooththofte. ");
INSERT INTO gmvl_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Istta bolla wosoy baynda issi mirgo, issi dharshonne layth kumida laappun dharsho laaqqata sawoy tunnu giidi GODAA ufayssiza xuugettiza yarsho yarshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Issi mirgozara kaththa yarshos heedzdzu kilo gidiza liiqo dhiille wogara zayten munuqidi shiishshite; qasse dharshozara kaththa yarshos 2 kilo gidiza liiqo dhiille wogara zayten munuqi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","Issi issi dharsho laaqqara kaththa yarshos issi kilo gidiza liiqo dhiille wogara zayten munuqi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Nagara wursanaas shiiqiza yarshos, kaththa yarshofe, ushsha yarshofenne gallas gallas shiiqi xuugettiza yarshofe hara deysha orge gujjidi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","« ‹Laappunththa aginay gelida tammanne ichchashanththo gallas goynnanaas shiiqite; he gallas ay oosokka ooththofte; laappun gallas gakkanaas GODAAS daase ba7aale bonchchite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Ha koyro gallas istta bolla wosoy baynda 13 mirgota; nam7u dharshotanne layth kumida tammanne oyddu dharsho laaqqata sawo tunnu giidi GODAA ufayssiza xuugettiza yarsho histti shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Issi issi mirgora kaththa yarshos 3 kilo gidiza liiqo dhiille wogara zayten munuqidi shiishshite; qasse issi issi dharshora kaththa yarshos 2 kilo gidiza liiqo dhiille wogara zayten munuqi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","Issi issi dharsho laaqqara kaththa yarshos issi kilo gidiza liiqo dhiille wogara zayten munuqi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","« ‹Nagara wursanaas shiiqiza yarshos, kaththa yarshofe, ushsha yarshofenne gallas gallas shiiqi xuugettiza yarshofe hara deysha orge gujjidi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","« ‹Nam7anththo gallas istta bolla ay wosoy baynda 12 mirgota, 2 dharshotanne layththi kumida 14 dharsho laaqqata shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Mirgotara, dharshotaranne dharsho laaqqatara issife shiiqiza kaththa yarshozanne ushsha yarshoza kase wogaan wodhdhida qoodaa mala yarshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Nagara wursanaas shiiqiza yarshos, kaththa yarshofe, ushsha yarshofenne gallas gallas shiiqi xuugettiza yarshofe hara deysha orge gujjidi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","« ‹Heedzdzanththo gallas istta bolla wosoy baynda tammanne issi mirgota, nam7u dharshotanne layththi kumida tammanne oyddu dharsho laaqqata shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Mirgotara, dharshotaranne dharsho laaqqatara issife shiiqiza kaththa yarshozanne ushsha yarshoza kase wogaan wodhdhida qoodaa mala yarshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Nagara wursanaas shiiqiza yarshos, kaththa yarshofe, ushsha yarshofenne gallas gallas shiiqi xuugettiza yarshofe hara deysha orge gujjidi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","« ‹Oydanththo gallas istta bolla wosoy baynda tammu mirgota, nam7u dharshotanne layththi kumida tammanne oyddu dharsho laaqqata shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Mirgotara, dharshotaranne dharsho laaqqatara issife shiiqiza kaththa yarshozanne ushsha yarshoza kase wogaan wodhdhida qoodaa mala yarshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Nagara wursanaas shiiqiza yarshos, kaththa yarshofe, ushsha yarshofenne gallas gallas shiiqi xuugettiza yarshofe hara deysha orge gujjidi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","« ‹Ichchashanththo gallas istta bolla wosoy baynda uddufun mirgota, nam7u dharshotanne layththi kumida tammanne oyddu dharsho laaqqata shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Mirgotara, dharshotaranne dharsho laaqqatara issife shiiqiza kaththa yarshozanne ushsha yarshoza kase wogan wodhdhida qoodaa mala yarshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Nagara wursanaas shiiqiza yarshos, kaththa yarshofe, ushsha yarshofenne gallas gallas shiiqi xuugettiza yarshofe hara deysha orge gujjidi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","« ‹Usuppunththo gallas istta bolla wosoy baynda osppun mirgota, nam7u dharshotanne layth kumida tammanne oyddu dharsho laaqqata shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Mirgotara, dharshotaranne dharsho laaqqatara issife shiiqiza kaththa yarshozanne ushsha yarshoza kase wogaan wodhdhida qoodaa mala yarshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Nagara wursanaas shiiqiza yarshos, kaththa yarshofe, ushsha yarshofenne gallas gallas shiiqi xuugettiza yarshofe hara deysha orge gujjidi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","« ‹Laappunththa gallas istta bolla wosoy baynda laappun mirgota, nam7u dharshotanne layth kumida tammanne oyddu dharsho laaqqata shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Mirgotara, dharshotaranne dharsho laaqqatara issife shiiqiza kaththa yarshozanne ushsha yarshoza kase wogaan wodhdhida qoodaa mala yarshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Nagara wursanaas shiiqiza yarshos, kaththa yarshofe, ushsha yarshofenne gallas gallas shiiqi xuugettiza yarshofe hara deysha orge gujjidi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","« ‹Osppunththa gallas issi bolla goynnanaas shiiqite; he gallas ay oosokka ooththofte. ");
INSERT INTO gmvl_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Istta bolla wosoy baynda issi mirgo, issi dharshonne layth kumida laappun dharsho laaqqata sawo tunnu giidi GODAA ufayssiza xuugettiza yarsho histti shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Mirgotara, dharshotaranne dharsho laaqqatara issife shiiqiza kaththa yarshozanne ushsha yarshoza kase wogan wodhdhida qoodaa mala yarshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Nagara wursanaas shiiqiza yarshos, kaththa yarshofe, ushsha yarshofenne gallas gallas shiiqi xuugettiza yarshofe hara deysha orge gujjidi shiishshite. ");
INSERT INTO gmvl_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","« ‹Inttes wodhdhida ba7aale gallassatan GODAAS shiishshite; hessika intte adinettidi shiishshiza yarshofenne intte intte dosan shiishshiza yarshofe xuugettiza hara yarsho, kaththa yarsho, ushsha yarshonne issifeteththa yarsho shiishshite› ga.» ");
INSERT INTO gmvl_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Museykka GODAY iza azazida mala Isra7eele asaas yootides. ");
INSERT INTO gmvl_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Musey Isra7eele asaa kaaleththiza korapinnetas, «GODAY azazida azazoy hayssafe kaallizayssa, ");
INSERT INTO gmvl_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Issi asi GODAAS issi miish ooththanaas adinettiko woykko issaadey caaqqi geppidi bana barkka ba qaalan qachchiko izi ba gelida qaala ubbaa polana bessees attiin ba gidayssa agganaas bessenna. ");
INSERT INTO gmvl_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","«Issi geela7oya ba aawa soon dashe GODAAS issi miish ooththanaas adinettiko woykko caaqqa geppada bana barkka ba qaalan qachchizaa gidikko, ");
INSERT INTO gmvl_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","izi aaway hessa siyidi izo diggontta aggiko iza ba adinettidayssa woykko ba caaqqa geppida qaalaza polanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Izi aaway he yo7oza siyidi izo diggizaa gidikko iza adinettida adinay woykko iza caaqqa geppida qaalay izis gome gidenna; gaasoykka izi aaway izo diggida gishshas GODAY izo maarana. ");
INSERT INTO gmvl_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","«Azina gelontta maccassi akeekada woykko akeekontta adina adinetta uttada woykko caaqqa geppada bana barkka ba qaalan qachcha woththada azina gelikko, ");
INSERT INTO gmvl_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","iza gelida azinazi he yo7oza siyidi izo diggontta aggiko iza ba gidayssa ubbaa polanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Izi azinay he yo7oza siyidi izo diggizaa gidikko iza adinettida adinay woykko iza caaqqa geppida qaalay izis gome gidenna; gaasoykka izi azinay izo diggida gishshas GODAY izo maarana. ");
INSERT INTO gmvl_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","«Azinay hayqqida maccassi woykko azinay anjji yeddida maccassi issi miish ooththanaas adinettiko woykko caaqqa geppada bana barkka ba qaalan qachchidaa gidikko iza ba gelida qaalaa polanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","«Azina gelida maccassi issi miish ooththanaas adinettiko woykko caaqqa geppada bana barkka ba qaalan qachchidaa gidikko, ");
INSERT INTO gmvl_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","iza gelida azinazi he yo7oza siyidi izo diggontta aggiko iza ba gidayssa ubbaa polanaas bessees. ");
INSERT INTO gmvl_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Izi azinay he yo7oza siyidi izo diggizaa gidikko iza adinettida adinay woykko iza caaqqa geppida qaalay izis gome gidenna; gaasoykka izi azinay izo diggida gishshas GODAY izo maarana. ");
INSERT INTO gmvl_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Izi azinay ay adina woykko caaqqa geppada bana barkka qachchida qaalaa digganaas woykko polisanaas izas maatay dees. ");
INSERT INTO gmvl_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Izi azinay he yo7oza siyida mala wonteththa gallas aykkoka qaattontta co7u giikko iza ba gidayssa ubbaa polanaas bessees; he yo7oza siyida mala aykkoka qaattontta co7u giikko hessi izi ero gidayssa qonccisees. ");
INSERT INTO gmvl_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Gido attiin izi azinay gam7idi he izi adinaza diggizaa gidikko alaafeteththan oyshettanay iza» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Geela7oynne gelida maccassi adina adinettiko woykko caaqqa geppada barkka bana ba qaalan qachchidaa gidikko izi aawaas woykko izi azinaas diza alaafeteththanne maataa gishshas GODAY Muses immida wogay hayssa. ");
INSERT INTO gmvl_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","GODAY Muses, ");
INSERT INTO gmvl_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«Midiyaame asay Isra7eele asaa bolla gaththida qohoza gishshas neni Midiyaame asaa halo kessa; hessa ooththidaappe guye neni hayqqana» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Hessa gishshas Musey derezas, «Midiyaame asay GODAA bolla kase ooththida qohoza gishshas intte halo kessanaas olas giigettite. ");
INSERT INTO gmvl_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Isra7eele asaa zarkkefe zarkkefe issi issi shii attumas dooridi gede olas yeddite» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Hessa gishshas Isra7eele zarkketappe issi issi shii as kessi immiin 12,000 asi olas gixettidi giigettides. ");
INSERT INTO gmvl_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Museykka issi issi zarkkefe issi issi shii asi qeese El7ezeere naa Finihaase kaaleththon olas yeddides; Finihaasikka geeshshasozappe dumma miishshatanne olas denththeththiza zayeta ba kushen oykkidi bides. ");
INSERT INTO gmvl_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Isttika GODAY Muse azazida mala Midiyaame asaa olidi attumasaa mulera wodhida. ");
INSERT INTO gmvl_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Hayqqidayta giddon Midiyaame kawo ichchashati Eeway, Ereqeemey, Xuurey, Uureynne Ereba7ey deettes; Bi7oore naa Balaamekka mashshan wodhida. ");
INSERT INTO gmvl_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Isra7eele asay Midiyaame maccassatanne guuththa nayta di7idi istta mehetanne istta aqota ubbaa pitti ekkides. ");
INSERT INTO gmvl_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Istti diza katamatanne istti diza gutata ubbaa taman xuuggida. ");
INSERT INTO gmvl_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Istta asaa, mehaanne di7ida miish ubbaa ekkida. ");
INSERT INTO gmvl_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Yordaanoose shaafappe he pinththa ginara diza Mo7aabe demban dunkaani uttida Musekko, qeese El7ezeerekkonne kumeththa Isra7eele maabaraakko ehida. ");
INSERT INTO gmvl_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Musey qeese El7ezeereynne maabaraa kaaleththizayti ola asaa mokkanaas gede kezida. ");
INSERT INTO gmvl_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Musey gidikko olaasoppe haa simmiza ola asaa azaziza shaalaqata bollanne mato halaqata bolla hanqettides. ");
INSERT INTO gmvl_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Izikka isttas, «Hayssa maccas ubbaa aazas wodhontta shemppora paxa aggidetii? ");
INSERT INTO gmvl_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Nuni kase Pe7ooren dishin hayti Balaame zore ekkidi Isra7eele asay ba GODAAPPE haakkana malanne boshan wurana mala ooththiday istta gidettennee! ");
INSERT INTO gmvl_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Hessa gishshas attuma nayta ubbaanne addera gayttida maccassata ubbaa wodhite. ");
INSERT INTO gmvl_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Gido attiin addera gaytti erontta geela7ota wodhontta inttes ashshite. ");
INSERT INTO gmvl_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","«Intte garsan as wodhidaadey woykko aha bochchida asi wurikka laappun gallas gakkanaas asi dizasoppe harason gam7o; heedzdzanththa gallassinne laappunththa gallas inttenanne intte di7i ehida maccassata geeshshite. ");
INSERT INTO gmvl_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Hessaththoka ay may7o woykko galbafe, deysha iskefenne miththafe oosettida miish ubbaa geeshshite» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Qeese El7ezeerey olappe simmida attumasaas, «GODAY Muses immida wogati hayssafe kaallizayta; ");
INSERT INTO gmvl_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","worqqay, biray, xarqimalay, biratay, qorqoroynne irsaasey, ");
INSERT INTO gmvl_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","hessaththoka tamay istta qohonttayti tama giddora aadhdhidi geeyanaas bessees; tama dandayontta ay miishshika kase wodhdhida wogaa mala geeshos giigettida haaththan geeshshite. ");
INSERT INTO gmvl_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Intte intte may7o laappunththa gallas meeccite; hessafe guye intte geesh gidiza gishshas simmidi kase intte dunkaani dizaso gelanaas dandayeeta» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«Neni qeese El7ezeereynne deraa kaaleththiza korapinnetara gididi di7etti yida asaanne mehaa qoodite. ");
INSERT INTO gmvl_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Nam7u kessi shaakkidi baggaa olaso bida wottadaratas attoyssa hankko maabaraas immite. ");
INSERT INTO gmvl_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Wottadarata gishaappe di7ettida asaappe, miizatappe, haretappe dorsatappenne deyshatappe ichchashu xeetappe issino taas GODAAS dumma imota histti shaakkite. ");
INSERT INTO gmvl_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","He intte taas GODAAS shaakkidayssa ta gishaza qeese El7ezeeres immite. ");
INSERT INTO gmvl_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Hinko maabaras imettida gishaappe, asaappe, miizaappe, dorsatappe, deyshatappenne haretappe ichchash tammaafe issino Gaytoteththa Dunkaanen alaafeteththan ooththiza Lewetas immite.» ");
INSERT INTO gmvl_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Museynne El7ezeerey GODAY istta azazidayssa ubbaa ooththida. ");
INSERT INTO gmvl_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Wottadarati banttas ekkishin attidayssi, 675,000 dorsatanne deyshata, ");
INSERT INTO gmvl_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","Laappun tammanne nam7u shii miizata, ");
INSERT INTO gmvl_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","Usuppun tammanne issi shii hareta, ");
INSERT INTO gmvl_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","Heedzdzu tammanne nam7u shii adde erontta geela7ota. ");
INSERT INTO gmvl_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Di7etti yidayssafe baggay oletti yidaytas imettides; hessika 337,500 dorsata. ");
INSERT INTO gmvl_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Isttafe 675 GODAAS dumma imota geetetti shaakettidayta. ");
INSERT INTO gmvl_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Miizati 36,000; isttafe GODAAS dumma imota gidi shaakettidayti laappun tammanne nam7a. ");
INSERT INTO gmvl_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Hareti 30,500; isttafe GODAAS dumma imota gidi shaakettidayti usuppuna. ");
INSERT INTO gmvl_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Adde erontta geela7oti 16,000; isttafe GODAAS dumma imota gididi shaakettidayti heedzdzu tammanne nam7a. ");
INSERT INTO gmvl_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Hessa gishshas Musey GODAY iza azazida mala GODAAS dumma imota histti shaakkidayssa qeese El7ezeeres immides. ");
INSERT INTO gmvl_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Hankko Isra7eele Maabaraa gishay olas kiitettida wottadarata gishara issi gina. ");
INSERT INTO gmvl_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","Hessika 337,500 dorsatanne deyshata, ");
INSERT INTO gmvl_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","Heedzdzu tammanne usuppun shii miizata, ");
INSERT INTO gmvl_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","Heedzdzu tammu shiyanne ichchashu xeetu hareta, ");
INSERT INTO gmvl_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","tammanne usuppun shii adde erontta geela7ota. ");
INSERT INTO gmvl_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Hessa gishshas Musey ichchash tammaafe issino GODAY iza azazida mala Gaytoteththa Dunkaanen alaafeteththan ooththiza Lewe zarkketas immides. ");
INSERT INTO gmvl_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Hessafe guye ola asaa azazizayti shaalaqatinne mato halaqati Museeko shiiqidi, ");
INSERT INTO gmvl_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","«Nuni ne oosanchchati nuuppe garsara azazettiza wottadarata ubbaa qoodidos; isttafe issoyka paccibeenna; ");
INSERT INTO gmvl_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","hessa gishshas nuni issoy issoy ekkida worqqa aleqota, toho gimota, kushe sagayota, biradhdhe midigata, hayththa gutichchata, qoodhen aadhdhiza maccifarata ubbaa nu nagaraa wursanaas GODAAS yarsho immanaas ekki yidos» gida. ");
INSERT INTO gmvl_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Museynne qeese El7ezeerey worqqafe oosettida alleqota ubbaa ekkida. ");
INSERT INTO gmvl_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Shalaqatappenne mato halaqatappe ekkidi Museynne qeese El7ezeerey GODAAS imota histti shiishshida worqqa alleqoti 16,750 saqile gidides. ");
INSERT INTO gmvl_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Garsara diza wottadarati gidikko ba di7idayssa baas baas ekki bida. ");
INSERT INTO gmvl_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Hessa gishshas Museynne qeese El7ezeerey shalaqatappenne mato halaqatappe ekkida worqqa alleqota GODAA sinththan Isra7eele deraa hassa7isana mala gede Gaytoteththa dunkaanezaakko ekki bida. ");
INSERT INTO gmvl_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Oroobeele zarkketassinne Gaade zarkketas keehi daro mehey dees; Iyaazeere dereynne Gala7aade derey mehes daro lo7o gididayssa be7ida. ");
INSERT INTO gmvl_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Hessa gishshas istti Musekko, qeese El7ezeerekkonne hankko maabara kaaleththizaytakko biidi, ");
INSERT INTO gmvl_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","«GODAY Isra7eele asaan xoonisida Axaroote derey, Diboone derey, Iyaazeere derey, Nimra derey, Haseboone derey, El7eele derey, Sibima derey, Nebo dereynne Ba7oone derey mehes lo7o; nuuska daro mehey dees. ");
INSERT INTO gmvl_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Intte nuus lo7o qoppiko hayssa ha dereza nuus intte oosanchchatas daanaso histti immite attiin nuni Yordaanoose pinnana mala ooththofte» gida. ");
INSERT INTO gmvl_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Museykka isttas, «Intte ishati olas bishin intte haan attanaas koyeetii? ");
INSERT INTO gmvl_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Isra7eele asay Yordaanoose pinnidi GODAY isttas immida dereza gelontta mala intte asaa hidota aazas qanxxiseetii? ");
INSERT INTO gmvl_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Hanno biittayo xomosana mala Qaadeese Barineppe tani kase intte aawata yeddiin hayssaththoka ooththida. ");
INSERT INTO gmvl_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Istti Eshkoole shoobbaa gakkanaas biidi he biittayo xomosi xeellida; gido attiin heeppe simmidi Isra7eele asay GODAY isttas immida dereza gelontta mala hidota qanxxisida. ");
INSERT INTO gmvl_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","11","He gallas GODAY keehi hanqettidi, ‹Istti kumeththa wozinappe tana kaallontta ixxida gishshas Gibxeppe kezida asaappe layththay nam7u tammu kumidaytinne hessafe bollara gididayti ubbay tani Abrahaames, Yisaaqassinne Yaaqoobes immana gaada kase caaqqida biittaa istti mulekka gelontta mala caaqqadis› gides. ");
INSERT INTO gmvl_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Hayssi GODAY caaqqi qachchida qaalazi GODAA kumeththa wozinappe kaallida Qenaaze dere as Yoofine naa Kaalebeppenne Nawe naa Iyaasoppe attiin hankko asaa ubbaaka bochchees. ");
INSERT INTO gmvl_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","GODAY Isra7eele dereza bolla hanqettida gishshas he iza hanqeththida yeletati ubbay wurana gakkanaas istti bazzo biittan oyddu tammu layth toylattana mala ooththides. ");
INSERT INTO gmvl_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Intteno nagaranchcha yeletatoo! GODAY Isra7eele dere bolla gujji hanqettana mala ha7ikka intte intte aawataththo ooththeeta. ");
INSERT INTO gmvl_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Intte Oroobeele zarkketinne Gaade zarkketi GODAA kaallontta ixxiko izi ha deraa ubbaa bazzon aggaagana; istta bolla gakkiza meto ubbaan intte oyshettana» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Isttika Musekko shiiqidi, «Nuni nu mehetas aqoso, nu machchetassinne nu naytas duussaso ooththana koyoos. ");
INSERT INTO gmvl_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Gido attiin nu bagga Isra7eele asay baas duussaso gidida biittayo gelidi uttana gakkanaas nu ubbaafe sinththati olas kezanaas giigetti uttidos; nuni hessa polidi simmana gakkanaas nu naytinne nu machcheti hayssa ha derezan diza asaappe istta bolla qohoy gakkontta mala gimbettida katamaan hirgay baynda diishshetto. ");
INSERT INTO gmvl_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Isra7eele asay ubbay baas baas giigettida biittaa ekkana gakkanaas nuni nuso simmoko. ");
INSERT INTO gmvl_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Nuni nu gisha Yordaanooseppe arshey mokkiza baggara ekkida gishshas pinththafe istta gakkiza gishaappe nu aykkoka ekkoko» gida. ");
INSERT INTO gmvl_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Museykka isttas, «Hayssi intte gidayssi tumu gidikko intte GODAA sinththan ola baanaas intte giigettidaa gidikko, ");
INSERT INTO gmvl_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","qasseka GODAY ba morkketa ba sinththafe yedeththi kessana gakkanaas intte ubbatikka GODAA sinththan olas giigettidayta gididi Yordaanoose shaafaa pinniko, ");
INSERT INTO gmvl_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","biittayakka GODAAS haarettidaappe guye intte simmana dandayeeta; he wode intte GODAASSINNE Isra7eele asaas ooththanaas bessiza alaafeteth polidaappe guye hara aykkoka oyshetteketa; hessafe guye ha biittaya inttes xinxxo gidana. ");
INSERT INTO gmvl_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","«Intte intte gida qaalaa naagontta aggiko intte GODAA qoheeta; intte nagara gishshas qixaatey intte bolla gakkanayssa erite. ");
INSERT INTO gmvl_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Hessa gishshas intte machchetassinne intte naytas duussaso, intte mehetaska aqoso ooththite; intte caaqo gelida qaalaakka polite» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Gaade zarkketinne Oroobeele zarkketi Muses, «Nuni ne oosanchchati neni nu goday nuna azazidayssa nu ooththana. ");
INSERT INTO gmvl_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Nu machcheti, nu naytinne nu meheti hayssan Gala7aade katamatan gam7etto. ");
INSERT INTO gmvl_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Gido attiin nuni ne oosanchchati ola olettanaas gixettidayti wurikka GODAA sinththan olettanaas nu goday neni nuna azaziza mala gede he pinth nu pinnana» gida. ");
INSERT INTO gmvl_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Hessa gishshas Musey qeese El7ezeeres, Nawe naa Iyaasossinne Isra7eele maabaraa kaaleththiza korapinnetas istta gishshas, ");
INSERT INTO gmvl_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","«Gaade zarkketinne Oroobeele zarkketi Yordaanoose pinnidi GODAA sinththan olas giigettidi istti inttena maaddiin biittaya intte kushen geliza wode Gala7aade intte isttas xinxxo histti immite. ");
INSERT INTO gmvl_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Istti inttenara Yordaanoose shaafa pinni biidi olettontta aggiko isttika inttenara issife Kanaaneppe gishetti ekketto» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Gaade zarkketinne Oroobeele zarkketi, «Nuni ne oosanchchati GODAY nuna azazidayssa ubbaa ooththana. ");
INSERT INTO gmvl_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Nu olas GODAA sinth gede Kanaane pinnana; nu laattana biittay gidikko Yordaanoose shaafappe ha pinththan arshey mokkiza baggana» gi zaarida. ");
INSERT INTO gmvl_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Hessa gishshas Musey Amoore dere kawo Sihooney haariza deretanne Baasaane dere kawo Aagey haariza deren diza katamata, istta yuushon diza katamatanne dereta ubbaa Oroobeele qommotas, Gaade qommotassinne Minaase qommotappe baggaytas immides. ");
INSERT INTO gmvl_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Gaade qommoti, Diboone, Axaroote, Aaro7eere, ");
INSERT INTO gmvl_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Axaroote-Sofaane, Iyaazeere, Yogibaha, ");
INSERT INTO gmvl_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beeti-Niimirenenne Beeti-Haaraane yuuyi aadhdhanaas gimbe gimbida; ba mehetaska aqoso keexxida. ");
INSERT INTO gmvl_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Oroobeele zarkketi Haseboone, El7eele, Qiriyaatayme katamata zaari gimbida. ");
INSERT INTO gmvl_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Hessaththoka guyeppe isttas sunththay laamettida Nebo, Ba7aali-Me7oonenne Seebama katamata zaari gimbida; he katamata ubbatas ooraththa sunth sunththida. ");
INSERT INTO gmvl_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Minaase naa Maakire zereththati Gala7aade oli oykkidi kase heen diza Amoore asata yedeththi kessida. ");
INSERT INTO gmvl_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Hessa gishshas Musey Gala7aade dere Minaase naa Maakire zereththatas immides; isttika banttas heen duussaso ooththida. ");
INSERT INTO gmvl_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Minaase zarkkefe gidida Ya7irey issi issi gutatan meto gaththidi baas ekkides; isttika, «Habot-Ya7ire» gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobahey qasse Qenaatenne iza yuushon diza gutata oli oykkidi ba sunththan, «Nobahe» gi sunththides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Isra7eele asay ba zarkken zarkken shaaketti shaaketti Museynne Aarooney kaaleththiin Gibxeppe kezidaappe guye dumma dumma wode istti dunkaani uttidasohoti hayssafe kaallizayta; ");
INSERT INTO gmvl_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","istti dumma dumma wode dunkaani uttidasohota sunththaa GODAY azazida mala Musey xaafides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Isra7eele asay koyro aginay gelida 15 gallas Paaziga ba7aaleppe wonteth Gibxe asay ubbay istti xeellishin yayyontta Eraamise katama yeggi kezides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","He wode Gibxe asay istta giddofe GODAA boshan hayqqida bayrata bayrata moogon deettes; he wode GODAY istta eeqa xoossata bollaka pirdides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Isra7eele asay Eraamiseppe dendi biidi Sukooten dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Sukooteppe dendidi bazzo gaxa bolla diza Etaamen dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Etaameppe dendidi Ba7aali-Xafooneppe arshey mokkiza baggara diza Pihaahiroote simmidi Migidoole heeran dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Pihaahirooteppe dendidi Zo7o abba pinnidi Etaame bazzo bides; Etaame bazzon heedzdzu gallas gakkanaas biidi Maara gakki dunkaanides; ");
INSERT INTO gmvl_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Maarappe dendidi tammanne nam7u haaththa pulttotinne laappun tammu tamire miththati dizaso Eelaame gakki dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Eelaameppe dendidi Zo7o abbaa matan dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Zo7o abbaa matappe dendidi Siina bazzon dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Siina bazzofe dendidi Dufiqan dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Dufiqappe dendidi Alushen dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Alusheppe dendidi ushsha haaththi bayndason Erafidimen dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Erafidimeppe dendidi Siina bazzon dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Siina bazzofe dendidi Kibroote-Hatta7aaben dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Kibroote-Hatta7aabeppe dendidi Haxirooten dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Haxirooteppe dendidi Eretiman dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Eretimappe dendidi Eremon-Perezen dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Eremon-Perezeppe dendidi Libinan dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Libinappe dendidi Erisan dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Ersappe dendidi Qahalaaten dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Qahalaateppe dendidi Shefere zuman dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Shefere Zumaappe dendidi Haradan dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Haradappe dendidi Maqihaloten dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Mahalooteppe dendidi Tahaaten dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Tahaateppe dendidi Taaran dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Taarappe dendidi Mitiqan dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Mitiqappe dendidi Hashemoonen dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Hashemooneppe dendidi Moserooten dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Moserooteppe dendidi Beeni Yaqinen dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Beeni Yaqineppe dendidi Hori-Haggidigan dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Hori-Haggidigappe dendidi Yoxbaaten dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Yoxbaateppe dendidi Abroonen dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Abrooneppe dendidi Eexiyoon-Gaabiren dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Eexiyoon-Gaabireppe dendidi Xiine bazzon diza Qaadeesen dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Qaadeeseppe dendidi Eedoome dere dhassan diza Hoore zuman dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Qeese Aarooney GODAA azazon pude Hoore zumaa bolla kezides; heen Isra7eele asay Gibxeppe kezida oyddu tammanththa layththan ichchashanththo aginay xeerida koyro gallas hayqqides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aarooney Hoore zumaa bolla hayqqiza wode iza layththay xeetanne nam7u tammanne heedzdza. ");
INSERT INTO gmvl_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Kanaane biittan Negeben diza Kanaane as Araade kawoy Isra7eele asay yizayssa siyides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Derezikka Hoore zumaappe dendidi Xelimonan dunkaani uttida. ");
INSERT INTO gmvl_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Xelimonappe dendidi Panoonen dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Panooneppe dendidi Obooten dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Obooteppe dendidi Mo7aabe dhassan diza Iye-Abaarimen dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Iye-Abaarimeppe dendidi Diboon-Gaaden dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Diboon-Gaadeppe dendidi Almmoon-Dibilatayen dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Almmoon-Dibilatayeppe dendi Nebo matan diza Abaarime zumata bolla dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Abaarime zumatappe dendidi Iyarkkofe Yordaanoose pinththan diza Mo7aabe demban dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Heen Yordaanoose matan Mo7aabe demban Beeti-Yashimooteppe biidi Aabeeli-Shuutime gakkanaas dunkaani uttides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Iyarkko ginara Yordaanoose pinththan Mo7aabe demban istti dishin Isra7eele derezas yootana mala GODAY Muses hayssafe kaalliza wogaa immides. ");
INSERT INTO gmvl_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Neni Isra7eele asaas, «Intte Kanaane dere gelanaas Yordaanoose pinniza wode, ");
INSERT INTO gmvl_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","he biittaan diza asaa ubbaa intte sinththafe gooddi kessite; shuchchafenne biratappe oosettida istta eeqa xoossata menththereththi yeggite; hessaththoka dhoqqasohotan diza istti goynnizasotakka laallite. ");
INSERT INTO gmvl_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Tani he biittayo inttes immida gishshas laattidi intte izin diite. ");
INSERT INTO gmvl_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Biittayo intte zarkken zarkken gishetti ekkite; qoodan dariza zarkkes dalga gade immite; qoodan guuxxiza zarkketas xunththa gade immite; issoy issoy ba zarkken zarkken biittayo ay gidiinkka saamay gaththida mala baas laata gade histti ekko. ");
INSERT INTO gmvl_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","«Kase he biittan diza asata ubbaa gooddi kessontta isttafe shaakki ashshiko istti intte ayfe caddi toyssiza pilqe mala gidana; mille caddiza agunththa mala gididi istti inttena waayisana; intte diza derezan istti ubba wode ola denththi denththi inttena metoththana. ");
INSERT INTO gmvl_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Intte hessaththo ooththontta aggiko tani istta dhayssana ga qoppoyssa intte bolla zaara polana» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«Isra7eele asaa, ‹Tani inttes immiza Kanaane biittayo intte biidi geliza wode izi yuushon diza dereti hayssafe kaallizayta; ");
INSERT INTO gmvl_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","dugeha baggara Xiine bazzofe dendidi Eedoome bazzo achchara kanththi biidi arshey mokkiza baggara Hayqo abbaafe dugeha bagga xeera bollara doommidi, ");
INSERT INTO gmvl_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Aqraabime purdera kanththi aadhdhidi Xiine gakkidi dugeha baggara Qaadeese Barine gakkees; hessafe Haxaare-Adaare kanththidi Aximoone gakkees. ");
INSERT INTO gmvl_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Aximooneppe doommidi haaththi baynda Gibxe shaafatara yuuyi aadhdhidi Mediteraane abbaan eqqees. ");
INSERT INTO gmvl_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","« ‹Arshey wulliza baggara Mediteraane abbay zawa gidana. ");
INSERT INTO gmvl_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","« ‹Pudeha baggara diza zaway Mediteraane abbafe biidi Uure zuma gakkees. ");
INSERT INTO gmvl_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Uure zumaappe biidi Hamaatera aadhdhi biidi Xedaade gakkees. ");
INSERT INTO gmvl_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Gede Zipiroone pinnidi Haxaare-Enaane gakki eqqees; hayssi ubbay inttes pudeha baggara diza zawa gidana. ");
INSERT INTO gmvl_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","« ‹Arshey mokkiza baggara Haxaare-Eenaneppe biidi Shafaame gakkanaas malata woththite. ");
INSERT INTO gmvl_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Zawazi Shafaameppe doommidi Ayineppe arshey mokkiza baggara Erebila kanththi aadhdhidi Galila abbaafe arshey mokkiza baggara diza zoozetara kanththidi, ");
INSERT INTO gmvl_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Yordaanoose shaafa wodhdhees; heera biidi wurseththazi Hayqo Abba gidana; hayti intte biittayo yuuyi aadhdhiza zawata gidana› gaada azaza.» ");
INSERT INTO gmvl_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Musey Isra7eele asaa, «Saama yeggidi intte laattana mala uddufun zarkketassinne Minaase zarkkefe baggaytas he biittay imettana mala GODAY azazides. ");
INSERT INTO gmvl_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Oroobeele zarkketi Gaade zarkketinne Minaases bagga zarkketi baas imettida biittaa laattida. ");
INSERT INTO gmvl_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Isttika Yordaanooseppe he pinththan Iyarkko ginara arshey mokkiza baggara bana gakkiza xinxxoza ekkida» gi yootides. ");
INSERT INTO gmvl_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","«Qeese El7ezeereynne Nawe naa Iyaasoy gadeza derezas gishetto. ");
INSERT INTO gmvl_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Istti biittaa gishiza wode istta maaddanaas zarkkefe zarkkefe korapinne ekka. ");
INSERT INTO gmvl_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","He ne ekkana asata sunththi hayssafe kaallizayssa; Yuhuda zarkkefe Yoofine naa Kaalebe, ");
INSERT INTO gmvl_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Simoona zarkkefe Amihuude naa Sameela, ");
INSERT INTO gmvl_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Biniyaame zarkkefe Kisaloone naa Eldaade, ");
INSERT INTO gmvl_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Daane zarkkefe Yogile naa Buuqa, ");
INSERT INTO gmvl_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Yooseefe zarkkefe Minaase bagga Sufide naa Han7eele, ");
INSERT INTO gmvl_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Yooseefe zarkkefe Efreeme bagga Shifixe naa Qamu7eele, ");
INSERT INTO gmvl_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Zaabiloone zarkkefe Perinaake naa Elxafaane, ");
INSERT INTO gmvl_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Yisakoore zarkkefe Hooza naa Palti7eele, ");
INSERT INTO gmvl_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Aaseere zarkkefe Seleeme naa Ahude, ");
INSERT INTO gmvl_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Niftaaleme zarkkefe Amihuude naa Pedaheele.» ");
INSERT INTO gmvl_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Haytanti Isra7eele asaas Kanaanen biittaa gishi immana mala GODAY doorida asata. ");
INSERT INTO gmvl_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Iyarkko ginara Yordaanoose shaafappe he pinththan diza Mo7aabe dembaa bolla GODAY Muses hizgides, ");
INSERT INTO gmvl_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","«Isra7eele asay ba gishaappe gishaappe Lewe zarkketi daana katamatanne he katamata yuushon istti ba mehe izan heemmana gade immana mala yoota. ");
INSERT INTO gmvl_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","He katamatikka Lewe zarkketas duussaso gidana gides; mehe heemmizasohoti istta mehey pe7izaso gidana. ");
INSERT INTO gmvl_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Katamata yuushon intte Lewe zarkketas immana mehe heenththa gadeza aakoteththay katamaa gimbezappe doommidi oyddu baggarakka 1,000 wadha wadha gido. ");
INSERT INTO gmvl_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Hessa malan katamaza giddo aaththidi oyddu baggarakka gulappe biidi gula gakkanaas 2,000 wadha gido; hessa Lewe qommoti baas mehe heenththasoho histtetto. ");
INSERT INTO gmvl_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","«Lewe qommotas intte immiza katamatappe usuppunati as wodhida asi baqati attiza katamata gidetto; heytappe hara 42 katamata gujji immite. ");
INSERT INTO gmvl_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Istti mehe heemmizasohotara gujjiin 48 katamati imettetto. ");
INSERT INTO gmvl_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Isra7eele zarkketi laattida gadeppe istta gade gade dalgateththaa mala dalga gade oykkidaytappe dalga, xunththa gade oykkidaytappe xunth ekkidi Lewe zarkketas immite.» ");
INSERT INTO gmvl_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","GODAY Muses hizgi yootides, ");
INSERT INTO gmvl_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«Neni Isra7eele asaas, ‹Intte Kanaane dere gelanaas Yordaanoose shaafaa pinniza wode, ");
INSERT INTO gmvl_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","issi asi erontta dishe as wodhikko hessaadey baqati biidi attana katamata ne doora. ");
INSERT INTO gmvl_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","He katamati shemppo wodhidaadey pirdas shiiqontta dishin hayqqidaade dabboy iza wodhontta mala izi baqati attiza katamata gidetto. ");
INSERT INTO gmvl_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Hayti intte Lewetas immida usuppun katamati erontta shemppo wodhida asi baqati attiza katamata gidana. ");
INSERT INTO gmvl_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","He katamatappe heedzdzati Yordaanoose shaafaappe he pinththan arshey mokkiza baggara hankko heedzdzati qasse Kanaane biittan gidetto. ");
INSERT INTO gmvl_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Ha usuppun katamati erontta dishe as wodhida Isra7eele asi, imaththatinne intte giddon diza hara dere asati baqati attizaso gidetto. ");
INSERT INTO gmvl_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","« ‹Issi asi biratappe oosettidaazan as wodhidaa gidikko he shemppo wodhidaadey izikka asa kushen hayqqo. ");
INSERT INTO gmvl_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Issi asi shuchchan caddidi as wodhidaa gidikko he shemppo wodhidaadey izikka asa kushen hayqqo. ");
INSERT INTO gmvl_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Issi asi miththan caddi as wodhidaa gidikko he shemppo wodhidaadeyka asa kushen hayqqo. ");
INSERT INTO gmvl_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","He hayqqidayssas mata dabboy suuth azaranaas dandayza gishshas awanka demmiko wodhanaas dandayees. ");
INSERT INTO gmvl_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","« ‹Issi asi odidi as sugi yeggi wodhikko woykko geemason uttidi issi miishshan caddi, ");
INSERT INTO gmvl_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","wodhikko morkketeththan dendidi icci wodhikko izi shemppo wodhida gishshas izikka asa kushen hayqqanaas bessees; he hayqqidayssas mata dabboy suuth accanaas dandayza gishshas awanka demmiko wodhanaas dandayees. ");
INSERT INTO gmvl_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","« ‹Gido attiin issi asi erontta dishe as sugi wodhikko woykko qoppontta dishe issi miishshan caddi wodhikko, ");
INSERT INTO gmvl_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","woykko erontta dishe shuch iza bolla yeggi wodhizaa gidikko hessaadey iza qohanaas odi ooththontta gishshas, ");
INSERT INTO gmvl_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","derezi he wodhidayssa giddoninne hayqqidayssa dabbota giddon imettana pirday hayssafe kaallizayssa gido. ");
INSERT INTO gmvl_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Erontta dishe as wodhidaadey suuth acciza asa kusheppe derezi ashshidi izi baqati attida katama zaaro; zayten tiyettida qeeseta halaqay hayqqana gakkanaas izi heen gam7o. ");
INSERT INTO gmvl_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","« ‹As wodhidi kasasetidayssi baqati attiza katamaappe kare kezizaa gidikko, ");
INSERT INTO gmvl_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","suuththa accizaadey demmidi iza wodhikko suuththa acon oyshettenna. ");
INSERT INTO gmvl_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","As wodhidi kasasetidayssi qeeseta halaqay hayqqana gakkanaas baqati attiza katamaan gam7o; qeeseta halaqazi hayqqidaappe guye izi baso simmana dandayees. ");
INSERT INTO gmvl_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","« ‹Hayssi ha wogazi intte diza dere ubbaan inttessinne intte zereththatas eqqi diza woga gido. ");
INSERT INTO gmvl_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","« ‹Shempo wodhida ay asikka hayqo pirda pirdettanaas dandayzay iza bolla nam7u markkay woykko izappe bollara markkattiko attiin issi markkan xalla hayqo qixaate ekkenna. ");
INSERT INTO gmvl_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Shemppo wodhiin hayqo pirday iza bolla pirdettida asi hayqqana bessees attiin ba wodhida shemppo gishshas miishshe qanxxi attanaas dandayenna. ");
INSERT INTO gmvl_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Izan baqati attiza katama baqatida oonappeka qeeseta halaqay hayqqanaappe kase izi guye simmidi ba biittan de7ana mala giidi suuththa qanxxo ekkofte. ");
INSERT INTO gmvl_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Intte hessaththo ooththizaa gidikko intte biittaa tuniseeta; gaasoykka asa suuth gussizayssi biitta tunisees; he biittay geeyanay asa suuth gussidaade suuththay gukkiin attiin haran geeyenna. ");
INSERT INTO gmvl_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Tani intte GODAA gidida gishshassinne inttenara Isra7eele dereza giddon diza gishshas tani izan diza biittaa tunisopite› ga yoota.» ");
INSERT INTO gmvl_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Yooseefe naa Minaasey yelida Maakire naa Gala7aade zarkketa kaaleththiza halaqati Musekkonne Isra7eele asaa kaaleththizaytakko shiiqidi, ");
INSERT INTO gmvl_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","«Neni hanno biittayo Isra7eele derezas saaman gishana mala GODAY nena nu godaza azazides; hessaththoka nu isha Xilofaade gisha iza macca naytas immana mala nena azazides. ");
INSERT INTO gmvl_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Gido attiin istti geliza azinati hara qommofe gidikko istta gisha gadey nu zarkketa xinxxofe qanxxettidi he istti gelida azinata zarkketas gujettiza gishshas nu zarkketa xinxxozi kase ekettoyssafe pace gidees. ");
INSERT INTO gmvl_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Wozzo layththay gakkiza wode istta gishazi istti gelida zarkkes gujettees; hessa gishshas istta xinxxoy nu zarkketa xinxxo pacinchchees» gida. ");
INSERT INTO gmvl_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Hessafe guye Musey GODAY izas yootida mala Isra7eele asaas, «Minaase zarkketi gidayssi wurikka likke. ");
INSERT INTO gmvl_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Hessa gishshas GODAY Xilofaade macca nayti ba zarkketa giddofe ba dosidaade gelanaas dandayeettes. ");
INSERT INTO gmvl_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Hessa malan Isra7eele asaa xinxxoy issi zarkkefe hara zarkken aadhdhofo; Isra7eele asay kase ba aawatappe laattida biitta minththi oykko. ");
INSERT INTO gmvl_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Isra7eele asaa zarkketa giddon ba aawa gade laattida maccassi oonikka ba qommo gelanaas bessees; hessa malan Isra7eele asay ubbay ba aawata xinxxo naaganaas dandayees. ");
INSERT INTO gmvl_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Hessa gishshas gadezi issi zarkke kusheppe hara zarkke kushen aadhdhanaas dandayenna; wurikka ba zarkken zarkken ba biitta oykki naago» gides. ");
INSERT INTO gmvl_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Xilofaade macca nayti GODAY Muse azazida mala ooththida. ");
INSERT INTO gmvl_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Xilofaade macca nayti Mahilo, Tirxxo, Hogilo, Milkko, No7o; heytantti ba aawa ishata nayta gelida. ");
INSERT INTO gmvl_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Yooseefe naa Minaase zarkketa giddon azina gelida; he istta biittay istta aawata zarkke sunththan minni attides. ");
INSERT INTO gmvl_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Isra7eele asay Iyarkko ginara Yordaanoose shaafappe he pinththan Mo7aabe demban dishin GODAY Muse baggara isttas immida wogatinne azazoti haytantta.");
INSERT INTO gmvl_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Hayssa ha maxaafan diza qaalay wurikka Yordaanoose shaafappe he pinththan arshey mokkiza baggara diza bazzon istti dishin Musey Isra7eele naytas yootida qaala. Museykka ha qaalaa yootiza wode istti Suufe geetettizaso ginara Paaraane katamaappe qasseka hara baggara Topeele, Laaba, Haxirootenne Dizahaabe geetettiza katamata giddon diza Yordaanoose shoobbaan deettes. ");
INSERT INTO gmvl_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Siina zumaappe dendidi Qaadeese Barine gakkanaas Eedoome zumata bollara efiza toho ogera biikko tammanne issi gallas ekkees. ");
INSERT INTO gmvl_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Gibxeppe istti kezidaappe oyddu tammanththo layththan tammanne issinththa aginay gelida koyro gallas Musey derezas erisana mala GODAY izas yootida qaala ubbaa isttas yootides. ");
INSERT INTO gmvl_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Hessika haniday Haseboone katamaan kawoti haariza Amoore dere kawo Sihoonenne Astarooten, Edira7e katamaan uttidi haariza Baasaane kawo Aage xoonidaappe guyenna. ");
INSERT INTO gmvl_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Asay Yordaanooseppe arshey mokkiza baggara Mo7aabe deren dishin Musey hayssafe kaalli diza GODAA woga qoncciseth doommides; ");
INSERT INTO gmvl_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","«Nuni Siina zumaa bolla diza wode GODAA nu Xoossay nuus, ‹Hekko intte hayssa zuma bolla daro gam7ideta; ");
INSERT INTO gmvl_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","hayssafe guye intte dizasoppe dendi gede gezzettiza Amooreta dere, istta heeran diza Arabe deren diza gezzenne gadha, Negebe dere, Mediteraane abbaa lanqera, Kanaane derenne Libaanoose baggara kanththidi gita haaththaa Efiraaxise shaafaa gakkanaas kanththi biite. ");
INSERT INTO gmvl_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Hekko tani ha biittayo inttes immadis; intteka biidi intte aawatas Abrahaames, Yisaaqas, Yaaqoobessinne isttafe guyen yaana istta zereththatas immanaas GODAY caaqqida biittayo laattite› gides» giidi yootides. ");
INSERT INTO gmvl_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Musey derezas, «He wode tani inttes, ‹Tani tarkka inttena kaaleththanaas dandaykke. ");
INSERT INTO gmvl_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Intte GODAY intte qooda Salo xoolintte mala darssides. ");
INSERT INTO gmvl_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Ha7ikka intte aawata Xoossay kase inttes immida hidota qaalaa mala shii dakko gujjidi inttena anjjo. ");
INSERT INTO gmvl_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Gido attiin ha7i intte garsan diza palamaa, ooshshaanne intte metoza tani tarkka wostta birshana dandayazinaa? ");
INSERT INTO gmvl_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Intte intte qommofe qommofe akeekay, aadho erateththi dizaytanne ooththi losidayta doorite; tanikka istta intte bolla shuumana› ga yootadis. ");
INSERT INTO gmvl_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","«Intteka, ‹Ne shiishshida qofay lo7o› gi ekkideta. ");
INSERT INTO gmvl_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Hessa gishshas issi issi qommofe intte dooridayta ooso losidayta, aadho eranchchatanne akeekizayta inttefe ekkada baggayta shaalaqata, baggayta mato halaqata, baggayta hamsa halaqatanne asira halaqata, baggayta qommota kaaleththiza halaqa histta shuumadis. ");
INSERT INTO gmvl_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","«Ta he wode isttas, ‹Intte deraa garsan dendiza palamanne oosh ekki geellay baynda suure pirda pirdite; intte deraa giddon woykko hara dereppe yiidi intte giddon diza asaas geellay baynda suure pirda pirdite. ");
INSERT INTO gmvl_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Intte gela pirda pirdofte; guuth gidiin gita gidiin maado pirda pirdofte; pirday Xoossas gidida gishshas ay asaska babofte; inttefe bolla gididayssa ubbaa taakko ehite; hessa tani pirdana› gadis. ");
INSERT INTO gmvl_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Intte ooththanaas bessizayssa ta inttes he wode lo7eththa yootadis. ");
INSERT INTO gmvl_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","«Hessafe guye nu GODAY nuna azazida mala Siina zumaappe dendidi intte be7ida iita bazzozara kanththidi Amoore deren shaara menththora aadhdhi biidi Qaadeese Barine gakkidos. ");
INSERT INTO gmvl_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Tani inttes, ‹Xoossay nuna laatissanaas qaala gelida shaara menththo gidida Amoore dere hekko gakkideta. ");
INSERT INTO gmvl_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","He dereyo hanno be7ite! GODAY nu aawata Xoossay beni azazida mala intte gelidi izo laattite; baboftenne hidota qanxxofte› ga yootadis. ");
INSERT INTO gmvl_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","«Intte ubbatikka taakko yiidi, ‹He biittayn diza katamati ay malakko qasse nuna hee gaththana ogeykka ay mala ogekko bi wochchi simmidi nuus yootana asata nu garsafe ane dooroos› giidi tana oychchideta. ");
INSERT INTO gmvl_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","«Hessa histtanayssi taas lo7o misati beettiin intte garsafe qommaafe qommaafe issi issi as doorada tammanne nam7u asata yeddadis. ");
INSERT INTO gmvl_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Isttika shaara menththo deraara kanththi biidi Eshkoole shoobba gakkanaas yuuyi xomosi xeellida. ");
INSERT INTO gmvl_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Isttika heen ba be7ida miththaa ayfeppe amardayssa ekki yiidi GODAA nu Xoossay nuus immana qoppida biittaya keeha lo7o biitta gididayssa nuus qonccisi yootida. ");
INSERT INTO gmvl_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","«Gido attiin GODAA intte Xoossaa azazo bolla makkallida gishshas he biittayo gelanaas koyibeekketa. ");
INSERT INTO gmvl_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Intte intte dunkaanen, ‹Xoossi nuna ixxides; izi nuna Gibxeppe kessiday hayta Amoore asatan nuna wodhisanaassinne istta kushen nuna aaththi immanaassa; ");
INSERT INTO gmvl_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","histtiin nu hee aazas bizonii? Nuni babboos; nuni kiittida asati heen diza asay wurikka minonne keehi adussata gididayssa qasseka istti diza katamata gimbey salo gakkidayssa nuus yootida; keehi adus gidida Enaaqe nayta be7ida› giidi zuuzumideta. ");
INSERT INTO gmvl_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","«Gido attiin tani inttes, ‹Hayta ha asatas baboftenne dagammofte. ");
INSERT INTO gmvl_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Inttefe sinththara biza GODAA intte Xoossay kase intte ayfen be7ishin Gibxeta bolla ooththoyssa mala ha7ikka izi intte gishshas olettana. ");
INSERT INTO gmvl_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Aaway ba naa al7isiza mala intte biza bazzo biitta ubbaan izi inttena kaaleththishe inttena saron hayssa wostti gaththidaakko intte beyideta.› ");
INSERT INTO gmvl_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","33","Ha ubbaa ta yootiinkka intte dunkkaanana sohoza bessanaassinne intte baana oge bessanaas omars tuussa taman, gallas tuussa mala shaaran inttena kaaleththida intte GODAAN ammanettibeekketa. ");
INSERT INTO gmvl_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","«Intte zuuzumida zuuzunththaa Xoossi siyidi hanqettides; ");
INSERT INTO gmvl_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","hessa gishshas, ‹Tani kase intte aawatas immana gaada caaqqida he lo7o biittayo ha iita yeletaappe issoyka gelenna. ");
INSERT INTO gmvl_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Yoofine naa Kaalebey xalla he biittayo gelana; izikka kumeththa wozinappe ammanetti beettida gishshas he izi be7ida biittayo izassinne iza zereththatas ta immana› gi caaqqides. ");
INSERT INTO gmvl_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","«Intte gaason GODAY tana hanqettidi, ‹Muse nenikka he dereyo gelakka. ");
INSERT INTO gmvl_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Gido attiin nena maaddiza Nawe naa Iyaasoy he biittayo gelana; he biittayokka laattana mala Isra7eele nayta kaaleththanay iza gidida gishshas ne iza menththeththa› gides. ");
INSERT INTO gmvl_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","«Qasseka GODAY inttes, ‹Intte nu nayti di7ettana› gida iitanne kiya shaakki erontta qii nayti xalla he biittayo gelana; tani he biittayo isttas immana; isttika he biittayo laattana. ");
INSERT INTO gmvl_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Intte gidikko simmidi Zo7o abbaako efiza ogezara duge bazzo biite» gides. ");
INSERT INTO gmvl_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","«Intteka, ‹Musee! Nuni nu GODAA qohidos; ha7i GODAY nu Xoossay nuna azazida mala nu olettana› gideta; he shaara menththo dereyo worajjoy kawushsha miish misati beettiin issoy issoy olas giigettideta» gides. ");
INSERT INTO gmvl_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","GODAY gidikko, «Ta inttenara ke7ontta gishshas olas kezopite; intte ixxis gi kezikko intte morkketi inttena xoonana» giidi taas yootides. ");
INSERT INTO gmvl_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Tanikka GODAY taas yootoyssa inttes yootadis shin intte ixxideta. Iza bollaka makkallideta; otoro daroppe dendidayssan intte he shaara menththo biittayo olanaas bideta. ");
INSERT INTO gmvl_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","He zumbullata bolla diza Amoore dere asati inttenara ola oykettida; istta olanchchati maththa mala intte bolla yiidi Horma gakkanaas inttena yedeththida; zumbullati dari uttida Eedoome deren inttena xoonida. ");
INSERT INTO gmvl_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Hessa gishshas intte simmi yiidi GODAA sinththan yeekkideta; gido attiin izi intte yeehozanne waasoza siyidi inttena maaddanaas koyibeenna. ");
INSERT INTO gmvl_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Histtiin intte Qaadeesen daro wode gam7ideta. ");
INSERT INTO gmvl_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Hessafe guye Xoossi azazida mala gede Zo7o abbaako efiza ogezara guye simmi duge bazzo biitta bidos; nuni heen toylattishe shaara menththo Eedoome deren daro wode gam7idos. ");
INSERT INTO gmvl_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Hessafe guye GODAY taas hizgi yootides. ");
INSERT INTO gmvl_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","«Intte ha shaara menththo deretan daro wode toylattideta; ha7i pudeha bagga simmi biite. ");
INSERT INTO gmvl_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Deraa, ‹Intte dabbo Eesawe zereththati diza Eedoome derera aadhdhi baana; istti inttes yayyana; gidikkoka intte keehi naagettite. ");
INSERT INTO gmvl_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Shaara menththon diza Eedoome biittaa ta Eesawes xinxxo histta immida gishshas istta biittafe tohoy yedhdhizasokka ta inttes immida istta bolla ola denththofte. ");
INSERT INTO gmvl_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Inttes koshshiza kath gidiin haath miishshan shammi ekkite› ga azaza» gides. ");
INSERT INTO gmvl_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","GODAA intte Xoossay intte ooththida ubbaa inttes keehi anjjides; intte hayssa wolqqama bazzozara kanththi biza wode ishalsi oykkides; ha oyddu tammu layth kumeththaan GODAA intte Xoossay inttenara diza gishshas aykkoyka inttes paccibeenna. ");
INSERT INTO gmvl_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Hessa gishshas nuni nu isha Eesawe zereththati diza E