﻿USE sofia;
DROP TABLE IF EXISTS sofia.gmve_vpl;
CREATE TABLE gmve_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gmve_vpl WRITE;
INSERT INTO gmve_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ጾሲ ኮይሮ ሳሎኔ ሳኣ ሜꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ሄ ዎዴ ሳኣይ ሎኢ ጊጊቤናኔ ኣይኮይካ ባይንዳ ሜላ ዴስ፤ ጪማሶሆታ ꬉማይ ጎዚ ኦይኪዴስ፤ ጾሳ ኣያናይ ሃꬃፌ ቦላራ ማይኢ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ሄሳፌ ጉዬ ጾሲ፥ «ፖኦ ጊዶ» ጊን ፖኦ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ፖኦይ ሎኦ ጊዲዳይሳ ጾሲ ቤኢዲ ፖኦ ꬉማፔ ሻኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ጾሲ ፖኦዛ፥ «ጋላስ»፥ ꬉማዛ፥ «ኦማርስ» ጊ ሱንꬂዴስ። ጋዴይ ቃሚዴሲኔ ዎንቲዴስ፤ ሄሲካ ኮይሮ ጋላሳ። ");
INSERT INTO gmve_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","ሄሳፌ ጉዬ ጾሲ፥ «ቦላራ ዲዛ ሃꬃ ጋርሳራ ዲዛ ሃꬃፌ ሻኪዛ ሳሎ ጉፋንꬆይ ሃኖ» ጊን ሃኒዴስ። ጾሲ ሳሎ ጉፋንꬆ ጊግሲዲ፥ ሳሎ ጉፋንꬆፌ ቦላራ ዲዛ ሃꬃ ጋርሳራ ዲዛ ሃꬃፌ ሻኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ጾሲ ሄ ጉፋንꬆዛ፥ «ሳሎ» ጊ ሱንꬂዴስ። ጋዴይ ቃሚዴሲኔ ዎንቲዴስ፤ ሄሲካ ናምኣንꬆ ጋላሳ። ");
INSERT INTO gmve_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ሄሳፌ ጉዬ ጾሲ፥ «ሳሎፔ ጋርሳራ ዲዛ ሃꬂ ኢሲሶን ሺቂ ኤሊኮ ሜላ ቢታይ ቆንጮ» ጊን ሃኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ጾሲ ሄ ሜላ ሶሆዛ፥ «ቢታ» ጊ ሱንꬂዴስ፤ ቃሴ ኢሲሶን ኤሊዳ ሃꬃ፥ «ኣባ» ጊ ሱንꬂዴስ፤ ሂስቲዲ ጾሲ ሄሲ ሎኦ ጊዲዳይሳ ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ሄሳፌ ሲሚን ጾሲ፥ «ቢታይ ሚꬂኔ ማታ ሞኪሶ፤ ዜሬꬃ ኣይፌራ ዲዛ ሚꬂኔ ዜሬꬃ ኣይፌራ ዲዛ ቴሪዛ ሚꬅ ዱማ ዱማ ቆሞ ሞኪሶ» ጊን ሃኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ሄሳ ጊሻስ ቢታይ ሚꬂኔ ማታ ዱማ ዱማ ቆሞን ሞኪሲን ጾሲ ሄሲ ሎኦ ጊዲዳይሳ ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ጋዴይ ቃሚዴሲኔ ዎንቲዴስ፤ ሄሲካ ሄꬓንꬆ ጋላሳ። ");
INSERT INTO gmve_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ሄሳፌ ጉዬ ጾሲ፥ «ጋላስ ቃማፌ ሻካናስ ፖኦቲ ሳሎ ጉፋንꬆን ጊዴቶ፤ ኢስቲ ጋላስ፥ ዎዴኔ ላይꬅ ኤሪሴቶ፤ ");
INSERT INTO gmve_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ቢታ ቦላን ፖኢሳና ማላ ኢስቲ ሳሎ ጉፋንꬆን ፖኤቶ» ጊን ሃኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ጾሲ ናምኡ ጊታ ፖኦታ፥ ጊታቲዛይሲ ጋላስ ፖኣና ማላኔ ጉጺዛይሲ ኦማርስ ፖኣና ማላ ሜꬊዴስ፤ ጾሊንቴታካ ሜꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","ጾሲ ኢስታ ሃ ቢታ ቦላን ፖኢሳና ማላ፥ ጋላሲኔ ቃማ ሃራና ማላኔ ፖኦዛ ꬉማፔ ሻካና ማላ፥ ሳሎ ጉፋንꬆን ኢስታ ዎꬂዴስ። ሂስቲዲ ጾሲ ሄሲ ሎኦ ጊዲዳይሳ ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ጋዴይ ቃሚዴሲኔ ዎንቲዴስ፤ ሄሲካ ኦይዳንꬆ ጋላሳ። ");
INSERT INTO gmve_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ሄሳፌ ጉዬ ጾሲ፥ «ሼምፖራ ዲዛ ዱማ ዱማ ሜꬌቴꬃቲ ሃꬃ ጊዶን ዳሬቶ፤ ካፎቲካ ቢታፌ ቦላራኔ ሳሎ ጉፋንꬆፌ ጋርሳራ ፒራꬌቶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ሂስቲዲ ጾሲ ኣባን ዲዛ ጊታ ዶኣታ፥ ሃꬃ ጊዶን ዎጺ ቃጺዛ ሜꬌቴꬃታ ኡባ፥ ካፎ ኡባ ዱማ ዱማ ቆሞን ሜꬊዴስ። ሄሲካ ሎኦ ጊዲዳይሳ ጾሲ ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ጾሲ ኢስታስ፥ «ዬሌቲቴ፤ ዳሪቴ፤ ኣባ ሃꬃ ኩሚቴ፤ ካፎይካ ቢታ ቦላን ጮራቶ» ጊ ኣንጂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ጋዴይ ቃሚዴሲኔ ዎንቲዴስ፤ ሄሲካ ኢቻሻንꬆ ጋላሳ። ");
INSERT INTO gmve_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ሄሳፌ ጉዬ ጾሲ፥ «ሼምፖራ ዲዛ ሜꬌቴꬃቲ ባ ቆሞን ቆሞን ሜሄቲ፥ ቢታራ ጎሼቲዛ ሜꬌቴꬃቲኔ ዶኣቲ ባ ቆሞን ቆሞን ቢታ ቦላ ኬዜቶ» ጊን ሃኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ጾሲ ዶኣታ ኢስታ ቆሞን ቆሞን፥ ሜሄታካ ኢስታ ቆሞን ቆሞኒኔ ቢታራ ጎሼቲዛ ሜꬌቴꬃታካ ኡባ ኢስታ ቆሞን ቆሞን ሜꬊዴስ፤ ሄሲካ ሎኦ ጊዲዳይሳ ጾሲ ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ሄሳፌ ሲሚን ጾሲ፥ «ኣኔ ኣስ ኑ ሌሚሶን ኑና ሚሳቲሲዲ ሜꬎስ፤ ኢስቲ ኣባ ሞሌታ፥ ሳሎ ካፎታ፥ ሜሄታ፥ ቢታ ቦላ ዎጺ ቃጺዛ ሜꬌቴꬃታ ኡባ ሃሬቶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ሄሳꬆ ጾሲ ኣስ ባ ሌሚሶን ባና ሚሳቲሲዲ ሜꬊዴስ፤ ኢዚ ኢስታ ኣዴኔ ማጫ ኦꬂ ሜꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ጾሲ ኢስታስ፥ «ዬሌቲቴ፤ ጮራቲቴ፤ ሃይሳ ቢታ ኩሚቴኔ ሃሪቴ፤ ኣባ ሞሌ፥ ሳሎ ካፎታኔ ቢታ ቦላ ዎጺ ቃጺዛ፥ ሼምፖራ ዲዛ ሜꬌቴꬃታ ኡባ ሃሪቴ» ጊ ኣንጂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ሄሳፌ ሲሚን ጾሲ፥ «ቤኢቴ! ታኒ ሃ ቢታ ኡባ ቦላን ዜሬꬃ ኣይፌራ ዲዛ ሚꬂኔ ዜሬꬃ ኣይፌራ ዲዛ ቴሪዛ ሚꬅ ኡባ ኢንቴስ ኢማዲስ፤ ኢስቲካ ኢንቴስ ሚዛ ቁማ ጊዴቶ። ");
INSERT INTO gmve_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ቃሴካ ሃ ቢታ ቦላ ዲዛ ሜሄኔ ዶኣ ኡባስ፥ ሳሎ ካፎታስ ኡባስ፥ ቢታራ ጎሼቲዛ ሜꬌቴꬃታ ኡባሲኔ ሼምፖራ ፓጻ ዲዛ ሜꬌቴꬃታ ኡባስ ሚዛ ሚሽ ጊዳና ማላ፥ ጪሊላ ሚꬂኔ ማታ ኩሜꬅ ኢማዲስ» ጊን ሃኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ጾሲ ባ ሜꬊዳይሳ ኡባካ ጼሊዲ ዳሮ ሎኦ ጊዲዳይሳ ቤኢዴስ። ጋዴይ ቃሚዴሲኔ ዎንቲዴስ፤ ሄሲካ ኡሱፑንꬃ ጋላሳ። ");
INSERT INTO gmve_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ሳሎ ቦላኔ ሳኣ ቦላ ዲዛይ ዉሪ ሃይሳꬆ ኦሴቲ ፖሌቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ጾሲ ባ ኦꬂዳ ኦሶ ኡሱፑንꬃ ጋላስ ፖሊዲ ባ ኦꬂዳ ኦሶ ኡባፌ ላፑንꬃ ጋላስ ሼምፒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ቃሴ ጾሲ ላፑንꬃ ጋላሳ ኣንጂዴሲኔ ዱማ ጋላስ ኦꬂዴስ፤ ኣይስ ጊኮ ጾሲ ባ ኦꬂዛ ኦሶ ዉርሲዲ ሼምፒዳይ ሄ ጋላሳና። ");
INSERT INTO gmve_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ሳሎይኔ ሳኣይ ሜꬌቲዳይ ሄሳ ማላና። ጎዳይ ሳኣኔ ሳሎ ሜꬊዳ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ሳኣ ቦላን ማታይ፥ ሚꬂ፥ ኣይ ሚሺካ ሞኪቤና፤ ኣይስ ጊኮ ጎዳይ ኢራ ቡኪሲቤና፤ ቃሴ ቢታ ኦꬂዛ ኣሲካ ሜꬌቲቤና። ");
INSERT INTO gmve_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ጊዲኮካ ሃꬂ ቢታፌ ፑዴ ማጮቲ ኬዚዲ ቢታ ኡባ ኢርጺሴስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ሄሳፌ ጉዬ ጎዳይ ቢታፌ ኢሲ ኣስ ሜꬊዲ ኢዛ ሲꬌን ዴኦ ሼምፖ ፑኒን ኣዴዚ ሼምፖራ ዲዛዴ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ካሴ ጎዳይ ኣርሼይ ሞኪዛ ባጋራ ኤዴኔ ጌቴቲዛሶን ሎኦሶ ጊግሲዲ ባ ሜꬊዳ ኣዴዛ ሄን ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ጎዳይ ጼላናስ ሎኢዛ፥ ማናስካ ማልኢዛ ዱማ ዱማ ቆሞ ሚꬅ ቢታፌ ሞኪሲዴስ፤ ኤዴኔ ጊዶን ዴኦ ኢሚዛ ሚꬂ ዴስ፤ ሄሳꬆካ ሎኦኔ ኢታ ኤሪሲዛ ሚꬅ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ጋናቴ ኡሺዛ ሻፋ ሃꬂ ኤዴኔፔ ጎጌስ። ኤዴኔፔ ኬዚዳፔ ጉዬ፥ ኦይዱ ሻፋ ጊዲ ሻኬቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ኮይሮ ሻፋ ሱንꬂ ፒሶኔ፤ ፒሶኔይ ዎርቃይ ዲዛ ሃዊላ ጌቴቲዛ ቢታ ዩሾ ኡባን ጎጌስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ሄ ቢታ ዎርቃይ ጌሻ ዎርቃ፤ ቃሴ ኣልኦ ሺቶይኔ ኬሂ ሎኢዛ ሹቺ ሄን ዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ናምኣንꬆ ሻፋ ሱንꬂ ጊዮኔ፤ ጊዮኔይ ቶጵያ ቢታ ዩሾ ኡባን ጎጌስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ሄꬓንꬆ ሻፋ ሱንꬂ ጼግሮሴ፤ ጼግሮሴይ ኣሶሬፔ ኣርሼይ ሞኪዛ ባጋራ ጎጌስ፤ ቃሴ ኦይዳንꬆ ሻፋይ ኤፊራጺሴ ጌቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ኣዴዚ ኤዴኔን ኦꬃና ማላኔ ናጋና ማላ ጎዳ ጾሳይ ኢዛ ኤፊ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ሂስቲዲ ጎዳ ጾሳይ ኣዴዛ፥ «ኤዴኔ ሚꬃ ቴራ ኡባፌ ኔኒ ማና ጊኮ ማ፤ ");
INSERT INTO gmve_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ጊዶ ኣቲን ሎኦኔ ኢታ ኤሪሲዛ ሚꬃይ ቴራፔ ሞፓ፤ ኣይስ ጊኮ ኔኒ ኢዚፔ ሚዳ ጋላስ ቱሙ ሃይቃና» ጊ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ሄሳፌ ጉዬ ጎዳ ጾሳይ፥ «ኣዴዚ ባርካ ዲዛይሲ ሎኦ ዴና፤ ታኒ ኢዛስ ኢንጄቲዛ ማዶ ኣስ ሜꬋና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ጎዳ ጾሳይ ካሴ ሜሄታ ዶኣታ ሳሎ ካፎታ ኡባ ቢታፌ ሜꬊዴስ፤ ቃሴ ኣዴዚ ኢስታ ኣይ ጊዲ ሱንꬃናኮ ሲያናስ ኢዛኮ ኤሂን ኣዴዚ ሼምፖራ ዲዛ ሜꬌቴꬃታ ኡባ ሱንꬂዳ ሱንꬃይ ኢስታስ ሱንꬅ ጊዲ ኣቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ሄሳꬆ ኣዴዚ ሜሄታ፥ ሳሎ ካፎታኔ፥ ዶኣታ ኡባ ሱንꬂዴስ፤ ጊዶ ኣቲን ኣዳሜስ ኢንጄቲዛ ማዶ ኣሲ ቤቲቤና። ");
INSERT INTO gmve_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ሄሳ ጊሻስ ጎዳ ጾሳይ ኣዴዛ ꬊስኮ ꬊስኪሲዲ፥ ኢዚ ꬊስኮን ዲሺን ኢዛ ሚሌ ሜቄꬃታፔ ኢሳ ኤኪዲ ሄ ሶሆዛን ኣሾ ኩንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ጎዳ ጾሳይ ኣዴዛፔ ኤኪዳ ሜቄꬃ ማጫስ ሜꬊዲ ኢዞ ኣዴዛኮ ኤሂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ኤሂን ኣዴዚ፥ «ሄኮ! ሃ ሜቄꬃያ ታ ሜቄꬃፌ፥ ሃ ኣሾያካ ታ ኣሾፔ ኤኬቲዳሮ፤ ኢዛካ ኣቱማሳፔ ኤኬቲዳ ጊሻስ፥ ማጫስ ጌቴቱ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ሄሳ ጊሻስ ኣሲ ባ ኣዋኔ ባ ኣዮ ኣጌስ፤ ባ ማቼይራ ኢሲፌ ዴስ፤ ኢስቲ ናምኣይ ኢሲ ኣሾ። ");
INSERT INTO gmve_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ኣዴዚኔ ኢዛ ማቼያ ናምኣይካ ፓጻ ካሎ ዴቴስ፤ ጊዶ ኣቲን ኢሳይ ኢሳስ ዬላቲ ኤሬቴና። ");
INSERT INTO gmve_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ሾሻይ ጎዳ ጾሳይ ሜꬊዳ ዶኣ ኡባፌ ኣꬊዳ ጌናንቻ፤ ኢሲ ጋላስ ሾሻይ ሄ ማጫሳዮ፥ «ጾሲ ቱሙ ኢንቴና፥ ‹ኤዴኔን ዲዛ ሚꬃ ኣይፌ ኡባፌካ ሞፒቴ› ጊዴ?» ጊ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","ማጫሳያ ሾሻስ ዛራዳ፥ «ጊዴና! ጾሲ ሄሳꬆ ጊቤና፤ ኑኒ ኤዴኔን ዲዛ ሚꬃታ ኣይፌ ማናስ ዳንዳዮስ፤ ጊዶ ኣቲን ጾሲ ኑና፥ ‹ኤዴኔ ጊዶን ዲዛ ሚꬃ ኣይፌ ሞፒቴ፤ ቦቾፍቴ፤ ሂስቶንታ ኣጊኮ ኢንቴ ሃይቃና› ጊዴስ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ሾሻይ ማጫሳዮ፥ «ጊዴና! ኢንቴ ቱማ ሃይቄኬታ፤ ");
INSERT INTO gmve_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ጾሲ ሄሳ ጊዳይ ሄ ሚꬃይ ኣይፌ ኢንቴ ሚኮ ኢንቴ ኣይፌይ ዶዬቲን፥ ጾሳ ማላ ኢንቴ ሎኦኔ ኢታ ሻኪ ኤራናይሳ ኢዚ ኤሪዛ ጊሻሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ማጫሳያ ሄ ሚꬃ ኣይፌይ ማናስ ማልኢዛይሳ፥ ጼላናስ ሎኢዛይሳ፥ ቃሴ ኣሲ ኣꬎ ኤራቴꬅ ዴማናስ ኣሞሲዛዝ ጊዲዳይሳ ቤያዳ ሄ ሚꬃ ኣይፌፔ ኤካዳ ማዱስ፤ ቃሴ ባናራ ዲዛ ባ ኣዚናስካ ሄሳፌ ኢሚን ኢዚካ ሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ሚዳ ዎዴ ኢስታ ናምኣ ኣይፌይካ ዶዬቲን ኢስቲ ፓጻ ካሎ ዲዛይሳ ኤሪዲ ባላሴ ጌቴቲዛ ሚꬃ ሃይꬅ ሲኪዲ ባ ጼሳን ጊጺዳ። ");
INSERT INTO gmve_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ኦማርሳ ዎዴ፥ ኤዴኔ ጊዶን ጎዳ ጾሳይ ሄሜቲሺን፥ ኢዛ ጬንጉርሳ ኣዴዚኔ ኢዛ ማቼያ ሲዪዲ ጎዳ ጾሳፌ ኤዴኔ ሚꬃ ጊዶን ቆቴቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ጊዶ ኣቲን ጎዳ ጾሳይ ኣዴዛ ጼይጊዲ፥ «ኣዳሜ ኣዋን ዳይ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ኣዴዚካ፥ «ኤዴኔ ጊዶን ኔ ጬንጉርሳ ሲያዳ ታኒ ካሎ ዲዛ ጊሻስ ባባዳ ቆቴታዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ጎዳ ጾሳይ ኢዛ፥ «ኔኒ ካሎ ዳሳ ጊዲ ኔስ ዮቲዳይ ኦኔ? ታኒ ኔና፥ ‹ሞፓ› ጋዳ ኣዛዚዳ ሚꬃ ኣይፌፔ ማዲ?» ጊ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ኢዚካ፥ «ታናራ ዳና ማላ ኔ ኢሚዳ ማጫሳያ ሄ ሚꬃ ኣይፌፔ ታስ ኢሚን ማዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ጎዳ ጾሳይ ሄሳፌ ጉዬ ማጫሳዮ፥ «ኔኒ ሄሳ ኣይስ ኦꬃዲ?» ጊ ኦይቺዴስ። ማጫሳያካ፥ «ታና ሾሻይ ባሌꬂን ማዲስ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ጎዳ ጾሳይ ሄሳፌ ጉዬ ሾሻ፥ «ኔኒ ሃይሳ ኦꬂዳ ጊሻስ፥ ሜሄ ኡባኔ ዶኣ ኡባ ጋርሳን ኔ ጻላይ ቃንጌቲዳዛ! ኔኒ ኔ ኡሎን ቢታራ ጎሼታና፤ ኔ ዴኦ ላይꬅ ኡባንካ ቢታ ጉዱላ ላጫ። ");
INSERT INTO gmve_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ታኒ ኔሲኔ ማጫሳይስ፥ ኔ ዜሬꬃሲኔ ኢዚ ዜሬꬃስ ጊዶን ሞርኬቴꬅ ሜꬋና፤ ኢዚ ኔ ሁኤ ቆጻና፤ ኔኒካ ኢዛ ቂርጴ ዱካና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ማጫሳዮካ ጎዳ ጾሳይ፥ «ኔ ሻሪዛ ኣጊናን ኔኒ ዳሮ ቱጋታና፤ ቃሴ ኔኒ ዎልቃማ ሚጻን ናይታ ዬላና። ጊዲኮካ ኔኒ ኔ ኣዚናራ ኣቃናስ ኣሞታና፤ ኢዚካ ኔና ሃራና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ኣዳሜካ ጎዳ ጾሳይ፥ «ኔኒ ኔ ማቼይ ቃላ ሲዪዳ ጊሻስ ታኒ ኔና፥ ‹ሄ ሚꬃ ኣይፌ ሞፓ› ጋዳ ኣዛዚዳ ሚꬃ ኣይፌፔ ኔኒ ሚዳ ጊሻስ፥ «ኔ ጌዶን ቢታይ ቃንጌቲዳዝ ጊዶ! ኔኒ ኔ ዴኦ ላይꬅ ኡባን ጊታ ዳቡራን ቢታ ኦꬃዳ ማና። ");
INSERT INTO gmve_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ቢታይ ኔስ ኣጉንꬂኔ ኪንዲቾ ሞኪሳና፤ ኔኒ ቢታፌ ሞኪዳይሳ ማና። ");
INSERT INTO gmve_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ኔኒ ቢታን ሲማና ጋካናስ ዳቡራን ኔ ጫዋ ጉሳ ኦꬃዳ ማና፤ ኔኒ ቢታፌ ሜꬌቲዳ ጊሻስ ቢታን ሲማንዳሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ኣዳሜይ ባ ማቺዮ ሄዋኖ ጊ ሱንꬂዴስ፤ ኣይስ ጊኮ ኢዛ ኣሳ ኡባስ ኣዮ። ");
INSERT INTO gmve_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","ጎዳ ጾሳይ ኣዳሜሲኔ ኢዛ ማቼይስ ኢቴ ጊግሲዲ ኢስታ ማይዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ሄሳፌ ጉዬ ጎዳ ጾሳይ፥ «ሂስቲን ኣሲ ኑፔ ኢሳዴ ማላ ሎኦኔ ኢታ ኤሪዛዴ ጊዲዴስ፤ ኢዚ ባ ኩሼ ዬዲዲ ዴኦ ኢሚዛ ሚꬃፌ ኤኪዲ ቃሴ ሞንታ ማላኔ ሜርናስ ፓጻ ዴኦንታ ማላ ቴቄታናስ ኮሼስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ሄሳ ጊሻስ ኢዚ ባ ሜꬌቲዳ ቢታ ኦꬃና ማላ፥ ጎዳ ጾሳይ ኤዴኔፔ ኢዛ ኬሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ኢዛ ኬሲዲ፥ ዴኦ ሚꬃኮ ኤፊዛ ኦጌ ናጋና ማላ፥ ኪሩቤ ጌቴቲዛ ኪታንቻታኔ ፖፖልኡ ጊ ኣꬊ ኣꬊ ዎꬊዛ ታማ ላጮ ሚሳቲዛ ጊꬃ ማሻ ኤዴኔፔ ኣርሼይ ሞኪዛ ባጋራ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ኣዳሜይ ባ ማቾ ሄዋኒራ ኣቂን ኢዛ ሻራዳ ኣቱማ ና ዬላዱስ፤ «ጎዳይ ታና ማዲን ኣቱማ ና ዴማዲስ» ጋሼ ኢዛ ቃዬሌ ጋ ሱንꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ቃሴ ኢዛ ኢሻ ኣቤሌካ ዬላዱስ። ኣቤሊ ዶርሳ ሄንꬃንቻ፤ ቃዬሌይ ቢታ ጎሻንቻ። ");
INSERT INTO gmve_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","ኡንዴና ዎዴፔ ጉዬ ቃዬሌይ ባ ጋዴን ሞኪዳ ካꬃፌ ጎዳስ ያርሾ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ጊዶ ኣቲን ኣቤሊ ባ ዶርሳታ ጊዶን ኮይሮ ዬሌቲዳ ላቃታፔ ኢሳ ኤኪ ሹኪዲ ኣሾዛፔ ሃንዳዛ ያርሺዴስ፤ ጎዳይ ኣቤሌኔ ኢዛ ያርሾዛ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ቃዬሌኔ ኢዛ ያርሾ ኤኪቤና፤ ሄሳ ጊሻስ ቃዬሌይ ኬሂ ዪሎቲዴስ፤ ባ ኣይፌሶካ ኢሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ሂስቲን ጎዳይ ቃዬሌ፥ «ኣይስ ዪሎታይ? ኔ ኣይፌሶይ ኣይስ ꬉሚዴ? ");
INSERT INTO gmve_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ኔ ሎኦ ኦꬂዳ ጊዲዳኮ ጾሲ ኔ ያርሾ ኤኬኔሺን? ኔኒ ሎኦ ኦꬆንታ ኢጺኮ ናጋራይ ኔ ካሬን ኔና ናጌስ፤ ናጋራይ ኔና ሃራና ኮዬስ፤ ኔኒ ኢዛ ጾናና ቤሴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ሄሳፌ ጉዬ ቃዬሌይ ባ ኢሻ ኣቤሌ፥ «ኣኔ ጌዴ ዴምባሶ ቦስ» ጊዴስ። ቢዲ ኢስቲ ዴምባን ዲሺን ቃዬሌይ ባ ኢሻ ኣቤሌ ቦላ ዴንዲዲ ዎꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ጎዳይ ቃዬሌ፥ «ኔ ኢሻይ ኣቤሊ ኣዋን ዲዜ?» ጊ ኦይቺዴስ። ቃዬሌይ ዛሪዲ፥ «ታ ኤሪኬ፤ ታ ኢሻ ናጊዛይ ታኔዬ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ጎዳይ ቃዬሌ፥ «ሄሳ ኣይስ ኦꬃዲ? ቤያ፤ ኔ ኢሻ ሱꬂ ቢታፌ ፑዴ ታኮ ዋሴስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ኔ ኩሼፔ ኔ ኢሻ ሱꬃ ኤኪዲ ሚታናስ ዶና ዶይዳ ቢታ ቦላ ሃኢ ኔኒ ቃንጌታዳሳ። ");
INSERT INTO gmve_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ኔኒ ኦꬂንካ ቢታይ ኔስ ካꬅ ኢሜና፤ ቤቴ ኣሳ ማላ ኔኒ ቢታ ቦላን ቶይላታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","ቃዬሌይ ጎዳ፥ «ኔ ታና ቃጻዪዛ ቂጻቴ ታኒ ሙሌካ ዳንዳይኬ። ");
INSERT INTO gmve_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ሄኮ ኔኒ ታና ሃች ሃ ቢታፌ ዬዴꬃሳ፤ ታኒ ኔ ሲንꬃፌ ቆቴታና፤ ቤቴ ኣሳ ማላ ታኒ ቢታ ቦላ ቶይላታና፤ ታና ዴሚዳይ ኦኒካ ዎꬋና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ጎዳይ ኢዛ፥ «ኔና ኦኒካ ዎꬌና፤ ዎꬊኮ ኔ ሃሎ ታኒ ላፑን ኩሼ ኬሳና» ጊዴስ፤ ሄሳ ጊሻስ ዴሚዳይ ኦኒካ ኢዛ ዎꬎንታ ማላ ጎዳይ ኢዛ ቦላ ማላታ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ቃዬሌይ ጎዳ ሲንꬃፌ ኬዚዲ ኤዴኔ ባጋፌ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ኖዴ ጌቴቲዛ ቢታን ዴኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","ቃዬሌይ ባ ማቼይራ ኣቂን ኢዛ ሻራዳ ሄኖኬ ዬላዱስ፤ ሄ ዎዴ ቃዬሌይ ካታማ ጊግሲዲ ሄ ካታማ ባ ናዛ ሱንꬃን፥ «ሄኖኬ» ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ሄኖኬይ ኢራዴ ዬሊዴስ፤ ኢራዴይ ማሁያኤሌ ዬሊዴስ፤ ማሁያኤሌይ ማቱሳኤሌ ዬሊዴስ፤ ማቱሳኤሌይ ላሜኬ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ላሜኬይ ኣዶኔ ጺሎ ጌቴቲዛ ናምኡ ማቼታ ዳዉꬅ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ኣዳይ ያባሌ ዬላዱስ፤ ያባሌይ ሜሄ ሃሪሼ ዩዪ ዩዪ ዱንካኔን ዲዛ ኣሳታ ኣዋ። ");
INSERT INTO gmve_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ኢዛ ኢሻ ሱንꬂ ዩባሌ፤ ዩባሌይ ቃሴ ዲꬅ ዲጺዛኔ ሱሱልኤ ፑኒዛ ኣሳታ ኡባታ ኣዋ፤ ");
INSERT INTO gmve_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ጺላይ ቃሴ ቱባሊቃይኔ ጌቴቲዛ ና ዬላዱስ፤ ቱባሊቃይኔይ ጻርቂማላፔኔ ቢራታፔ ዱማ ዱማ ሚሻታ ቆጺዛዴ። ቱባሊቃይኔ ሚቼያ ናኢሞ ጌቴታዉስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ኢሲ ጋላስ ላሜኬይ ባ ማቼታ፥ «ታ ማቼቶ ኣዴ፥ ጺሌ ሲዪቴ! ኣኔ ታኒ ዮቲዛይሳ ኤዝጊቴ። ኢሲ ኣሲ ታና ዋꬊ ማዱንꬂዳ ጊሻስ ታኒ ኢዛ ዎꬋዲስ፤ ኤ፥ ታኒ ሄ ታና ማዱንጺሲዳ ዎዳላዛ ዎꬋዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ቃዬሌ ሃሎ ኬሳናስ ላፑን ኩሼ ኮሺኮ ላሜኬ ሃሎ ኬሳናስ ላፑን ታማኔ ላፑን ኩሼ ኮሼስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ኣዳሜይ ባ ማቼይራ ኣቂን ሃራ ና ዬላዱስ። ዬላዳ፥ «ቃዬሌይ ዎꬊዳ ኣቤሌ ጊሻስ ጾሲ ታስ ሃራ ና ኢሚዴስ» ጋሼ ኢዛ ሴቴ ጋዳ ሱንꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ሴቴይካ ኣቱማ ና ዬሊዲ ኢዛ፥ «ሄኖሴ» ጊ ሱንꬂዴስ። ኣሳይ ሄ ዎዴ ጎዳ ሱንꬅ ጼይጊዲ ጎይኖ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ኣዳሜ ዜሬꬂ ሃይሳፌ ካሊዲ ጻፌቲዴስ፤ ጾሲ ኣስ ሜꬊዳ ጋላስ ባና ሚሳቲሲዲ ሜꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ኣዴኔ ማጫስ ኦꬂ ሜꬊዲ ኢስታ ኣንጂዴስ። ኢስታ ሜꬊዲ ኣስ ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ኣዳሜይ 130 ላይꬅ ዴኢዲ ባና ሚሳቲዛ ኣቱማ ና ዬሊዲ ኢዛ፥ «ሴቴ» ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ኣዳሜይ ሴቴ ዬሊዳፔ ጉዬ 800 ላይꬅ ዴኢዴስ፤ ሃራ ኣቱማ ናይታኔ ማጫ ናይታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ኣዳሜይ ሙሌራ 930 ላይꬅ ዴኢዲ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ሴቴይ 105 ላይꬅ ዴኢዲ ሄኖሴ ዬሊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ሴቴይ ሄኖሴ ዬሊዳፔ ጉዬ 807 ላይꬅ ዴኢዴስ፤ ሃራ ኣቱማ ናይታኔ ማጫ ናይታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ሴቴይ ሙሌራ 912 ላይꬅ ዴኢዲ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ሄኖሴይ 90 ላይꬅ ዴኢዲ ቃይናኔ ዬሊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ሄኖሴይ ቃይናኔ ዬሊዳፔ ጉዬ 815 ላይꬅ ዴኢዴስ፤ ሃራ ኣቱማ ናይታኔ ማጫ ናይታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ሄኖሴይ ሙሌራ 905 ላይꬅ ዴኢዲ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","ቃይናኔይ 70 ላይꬅ ዴኢዲ ማላልኤሌ ዬሊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ቃይናኔይ ማላልኤሌ ዬሊዳፔ ጉዬ 840 ላይꬅ ዴኢዴስ፤ ሃራ ኣቱማ ናይታኔ ማጫ ናይታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ቃይናኔይ ሙሌራ 910 ላይꬅ ዴኢዲ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","ማላልኤሌይ 65 ላይꬅ ዴኢዲ ያሬዴ ዬሊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ማላልኤሌይ ያሬዴ ዬሊዳፔ ጉዬ 830 ላይꬅ ዴኢዴስ፤ ሃራ ኣቱማ ናይታኔ ማጫ ናይታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ማላልኤሌይ ሙሌራ 895 ላይꬅ ዴኢዲ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ያሬዴይ 162 ላይꬅ ዴኢዲ ሄኖኬ ዬሊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ያሬዴይ ሄኖኬ ዬሊዳፔ ጉዬ 800 ላይꬅ ዴኢዴስ፤ ሃራ ኣቱማ ናይታኔ ማጫ ናይታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ያሬዴይ ሙሌራ 962 ላይꬅ ዴኢዲ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ሄኖኬይ 65 ላይꬅ ዴኢዲ ማቱሳላ ዬሊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ማቱሳላ ዬሊዳፔ ጉዬ ሄኖኬይ 300 ላይꬅ ጾሳ ኡፋይሲሼ ዴኢዴስ፤ ሃራ ኣቱማ ናይታኔ ማጫ ናይታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ሄኖኬይ ሙሌራ 365 ላይꬅ ዴኢዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ኢዚ ጾሳ ኡፋይሲሼ ዲን ጾሲ ኢዛ ኤኪዳ ጊሻስ ቤቶንታ ꬋይዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","ማቱሳላይ 187 ላይꬅ ዴኢዲ ላሜኬ ዬሊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ማቱሳላይ ላሜኬ ዬሊዳፔ ጉዬ፥ 782 ላይꬅ ዴኢዴስ፤ ሃራ ኣቱማ ናይታኔ ማጫ ናይታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ማቱሳላይ ሙሌራ 969 ላይꬅ ዴኢዲ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ላሜኬይ 182 ላይꬅ ዴኢዲ ኣቱማ ና ዬሊዲ፥ ");
INSERT INTO gmve_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","«ሃ ናዚ ጎዳይ ቃንጊዳ ቢታ ቦላን ኑና ኑ ዳቡራፔ ሼምፒሳና» ጊዲ ኖሄ ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ላሜኬይ ኖሄ ዬሊዳፔ ጉዬ 595 ላይꬅ ዴኢዴስ፤ ሃራ ኣቱማ ናይታኔ ማጫ ናይታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ላሜኬይ ሙሌራ 777 ላይꬅ ዴኢዲ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","ኖሄይ 500 ላይꬅ ዴኢዲ ሴሜ፥ ካሜኔ ያፌቴ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ኣሲ ቢታ ቦላ ዳሪዳ ዎዴ ኣሳስ ማጫ ናይቲ ዬሌቲዳ፤ ");
INSERT INTO gmve_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","«ጾሳ ናይታ» ጌቴቲዛ ሜꬌቴꬃቲ ኣሳ ማጫ ናይቲ ሜꬎ ሎኦ ጊዲዳይሳ ቤኢዲ ኢስታፌ ባ ዶሪዳይታ ማቾ ኤኪዳ። ");
INSERT INTO gmve_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ጎዳይ፥ «ኣሲ ሃይቂዛዛ፤ ኢዛ ላይꬃይካ 120 ላይꬃፌ ዳሬና፤ ሄሳ ጊሻስ ታ ኣያናይ ኣሳ ና ቦላ ሜርናስ ዴና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ሄ ዎዴኔ ሄሳፌ ጉዬ ጾሳ ናይቲ ኣሳ ማጫ ናይታ ማቾ ኤኪን ናይቲ ዬሌቲዳ ዎዴ ዎጋ ዎልቃማ ኣሳቲ ቢታ ቦላን ዴቴስ። ኢስቲካ ቤኒ ዎዴ ኦላስ ሚኖኔ ኤሬቲዳ ኣሳ። ");
INSERT INTO gmve_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ጎዳይ ሄ ዎዴ ቢታ ቦላን ዲዛ ኣሳ ኢታቴꬂ ዳሪዳይሳኔ ኢስቲ ባ ዎዚናን ቆፒዛይሲ ዉሪ ኡባ ዎዴካ ኢታ ጻላላ ጊዲዳይሳ ቤኢዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ጎዳይ ኣስ ሃ ቢታ ቦላን ሜꬊዳ ጊሻስ ሞꬌቲዴስ፤ ባ ዎዚናን ኬሂ ሴሌቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ሄሳ ጊሻስ ጎዳይ፥ «ታኒ ሜꬊዳ ኣሳ ሃ ቢታ ቦላፌ ኡባ ꬋይሳና፤ ኣሳ፥ ሜሄ፥ ዶኣ፥ ቢታራ ጎሼቲዛ ሜꬌቴꬃታኔ ካፎታ ꬋይሳና፤ ኣይስ ጊኮ ታኒ ኢስታ ሜꬊዳ ጊሻስ ሚሼታዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ጊዶ ኣቲን ኖሄይ ጎዳ ሲንꬃን ሳቤቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","ኖሄይ ሃኒዳይሲ ሃይሳፌ ካሊዲ ጻፌቲዴስ። ኖሄይ ጺሎ ኣሳ፤ ኢዚ ባ ዎዴን ዲዛ ኣሳ ጊዶን ሱሬ ኣሳ፤ ኖሄይ ጾሳራ ጊጋ ዱስ ዴኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","ኖሄይ ሴሜ፥ ካሜኔ ያፌቴ ጌቴቲዛ ሄꬑ ኣቱማ ናይታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ሄ ዎዴ ቢታ ቦላ ዲዛ ኣሲ ዉሪ ጾሳ ሲንꬃን ቱኒዴስ፤ ቢታይ ዉሪ ማካላን ኩሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ጾሲ ዱጌ ቢታ ጼሊሺን ቢታ ቦላ ዲዛ ኣሳይ ዉሪ ቱኒዳይሳ ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ሄሳ ጊሻስ ጾሲ ኖሄ፥ «ታኒ ኣሳ ኡባ ꬋይሳና ጋይስ፤ ኣሳ ጋሶን ቢታይ ማካላን ኩሚዳ ጊሻስ ታኒ ቱማፔ ኣሳኔ ቢታ ቦላ ዲዛዝ ኡባ ꬋይሳና። ");
INSERT INTO gmve_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ሄሳ ጊሻስ ሚኖ ሚꬃፌ ኔስ ማርካቤ ኬጻ፤ ሄ ማርካቤዛ ጊዶን ኪፊሌ ኦꬃ፤ ሂስታዳ ሶ ባጋራኔ ካሬ ባጋራ ሺዳን ሜሻ። ");
INSERT INTO gmve_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","ማርካቤዛ ኬጻሼ ኢዛ ኣዱሳቴꬂ 300 ዋꬋ፥ ጎምፓይ 50 ዋꬋ፥ ፑዴ ꬎቃቴꬂ 133 ዋꬋ ሂስታ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ማርካቤዛስ ካራ ሜꬋ፤ ካራፔኔ ጎዳፔ ጊዶን ኢሲ ዋꬋ ጊዲዛሶ ዶያ ኣጋ፤ ፔንጌዛ ማርካቤዛስ ሚሌራ ኬሳ፤ ማርካቤዛ ሄꬑ ፖቄ ኬሳ ኬጻ። ");
INSERT INTO gmve_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","«ታኒ ሳሎፔ ጋርሳን ሼምፖራ ዲዛ ሜꬌቴꬃ ኡባ ꬋይሳናስ ሃ ቢታ ቦላን ꬋይሳ ሃꬅ ዬዲኮ ቢታን ዲዛይሲ ዉሪ ꬋያና። ");
INSERT INTO gmve_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ጊዶ ኣቲን ታኒ ኔናራ ጫቄታና። ኔኒ፥ ኔ ማቺያ፥ ኔ ናይቲኔ ኔ ናይታ ማቼቲ ኔናራ ማርካቤዛን ጌላንዴታ። ");
INSERT INTO gmve_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ኢስቲ ኔናራ ፓጻ ዳና ማላ ሼምፖራ ዲዛ ሜꬌቴꬃ ኡባፌ ቆሞን ቆሞን ኣዴኔ ማጫ ናምኡ ናምኡ ሂስታዳ ማርካቤዛ ጊዶ ጌልꬃ። ");
INSERT INTO gmve_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ዱማ ዱማ ቆሞ ካፎታፔ፥ ዱማ ዱማ ቆሞ ሜሄታፔኔ ቢታራ ጎሼቲዛ ዱማ ዱማ ቆሞ ሜꬌቴꬃታፔ ኡባፌ ናምኡ ናምኡ ጊዲዲ ሼምፖራ ፓጻ ኣታና ማላ ኔኮ ያና። ");
INSERT INTO gmve_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ቃሴ ኔኒኔ ኔናራ ዲዛይቲ ማና ማላ ዱማ ዱማ ቆሞ ካꬅ ኤፋዳ ማርካቤዛ ጊዶ ጌልꬃ» ጊ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ኖሄይ ኡባካ ጾሲ ኣዛዚዳ ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ሄሳፌ ጉዬ ጎዳይ ኖሄ፥ «ኔኒ ሃይሳ ሃ ዎዴ ዬሌታ ጊዶን ጺሎ ጊዲዳይሳ ታ ቤኢዳ ጊሻስ ኔኒ ኔሶ ኣሳ ኡባራ ማርካቤዛ ጊዶ ጌላ። ");
INSERT INTO gmve_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","ኔኒ ጌሽ ጊዲዳ ሜሄኔ ዶኣ ኡባፌ ኢዛ ቆሞፌ ቆሞፌ ኣዴኔ ማጫ ላፑን ላፑን፥ ጌሽ ጊዶንታ ሜሄኔ ዶኣ ኡባፌ ኢዛ ቆሞፌ ቆሞፌ ኢሲ ኣዴኔ ኢሲ ማጫ ቃሴ ካፎታፔ ኢዛ ቆሞፌ ቆሞፌ ኣዴኔ ማጫ ላፑን ላፑን፥ ቢታ ኡባ ቦላን ዱማ ዱማ ዜሬꬃይ ፓጻ ዳና ማላ ኔናራ ኤካ ጌላ። ");
INSERT INTO gmve_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ኣይስ ጊኮ ላፑን ጋላሳፌ ጉዬ ታኒ ኦይዱ ታሙ ጋላሲኔ ኦይዱ ታሙ ቃማ ቢታ ቦላን ኢራ ቡኪሳና፤ ሂስታዳ ታኒ ሜꬊዳ ሜꬌታ ኡባ ቢታ ቦላፌ ꬋይሳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","ኖሄይ ጎዳይ ኢዛ ኣዛዚዳይሳ ኡባ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ꬋይሳ ሃꬂ ቢታ ቦላ ዪዛ ዎዴ ኖሄስ ላይꬃይ ኡሱፑን ጼታ። ");
INSERT INTO gmve_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ኖሄ፥ ኢዛ ኣቱማ ናይቲ፥ ኢዛ ማቼያኔ ኢዛ ናይታ ማቼቲ ꬋይሳ ሃꬃፌ ኣታናስ ማርካቤዛ ጊዶ ጌሊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ጌሻ ሜሄፔኔ ዶኣፔ፥ ጌሽ ጊዶንታ ሜሄፔኔ ዶኣፔ፥ ካፎፔኔ ቢታራ ጎሼቲዛ ኡባፌ፥ ");
INSERT INTO gmve_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ጾሲ ኖሄ ኣዛዚዳ ማላካ ኣዴኔ ማጫ ናምኡ ናምኡ ጊዲዲ ኖሄኮ ማርካቤዛ ጊዶ ጌሊን፥ ");
INSERT INTO gmve_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ላፑን ጋላሳፌ ጉዬ ꬋይሳ ሃꬂ ቢታ ቦላ ዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","ኖሄስ ኡሱፑን ጼቱ ላይꬅ ጊዲሺን ናምኣንꬆ ኣጊናን ታማኔ ላፑንꬃ ጋላሳን ሄ ጋላሳንካ ቢታ ጊዶን ዲዛ ጊታ ጪማ ፑልቶይ ዉሪ ꬉቂዴስ፤ ሳሎን ዲዛ ሃꬃ ማስኮቴቲካ ዶዬቲ ዎꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ኢራይ ቢታ ቦላን ኦይዱ ታሙ ጋላሲኔ ኦይዱ ታሙ ኦማርስ ቡኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ሄ ጋላሳን ኖሄይኔ ኢዛ ኣቱማ ናይቲ፥ ሴሜይ፥ ካሜይኔ ያፌቴይ፥ ኖሄ ማቼያኔ ኢዛ ናይታ ሄꬓታ ማቼቲ ኢሲፌ ማርካቤዛ ጊዶ ጌሊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ኢስታኔ ዶኣ ኡባፌ ባ ቆሞን ቆሞን፥ ሜሄ ኡባፌካ ባ ቆሞን ቆሞን፥ ቢታራ ጎሼቲዛያታ ኡባፌ ባ ቆሞን ቆሞን፥ ካፎ ኡባፌ ባ ቆሞን ቆሞን ኢስታራ ኢሲፌ ጌሊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ሼምፖራ ፓጻ ዲዛይቲ ዉሪ ናምኡ ናምኡ ጊዲዲ ኖሄኮ ማርካቤዛን ጌሊዳ፤ ");
INSERT INTO gmve_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ጾሳይ ኖሄ ኣዛዚዳ ማላ ሜꬌታ ኡባፌ ኣዴኔ ማጫ ጊዲዲ ማርካቤዛ ጊዶ ጌሊን ኖሄይ ጊዶን ዲሺን ጎዳይ ማርካቤዛ ፔንጌ ጎርዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ꬋይሳ ሃꬂ ኦይዱ ታሙ ጋላስ ቢታ ቦላ ቡኪሼ ጋምኢዴስ፤ ሃꬂ ዳሪዲ፥ ማርካቤዛ ቢታፌ ፑዴ ዴንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ሃꬃይ ቢታ ቦላን ኬሂ ዳሪን ማርካቤዚ ሃꬃ ቦላን ቶኬቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ሳሎፔ ጋርሳራ ዲዛ ꬎቃ ዙማቲ ዉሪ ሚቴታና ጋካናስ ሃꬃይ ቢታ ቦላን ኬሂ ዎልቃፌ ዳሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ሃꬃይ ዙማታ ጼራፔ ኣꬊዲ 15 ዋꬋ ጋካናስ ꬎቁ ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ሂስቲን ቢታ ቦላን ሼምፖራ ፓጻ ቃጺዛ ሜꬌቴꬃቲ ዉሪ፥ ካፎይ፥ ሜሄይ፥ ዶኣይ፥ ቢታ ቦላን ዎጺ ቃጺዛይኔ ኣሲ ዉሪ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ቢታ ቦላን ዲዛ ሲꬌራ ሼምፒዛይ ዉሪካ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ሃ ቢታን ፓጻ ዲዛይ ዉሪ ኣሲ፥ ሜሄይኔ ዶኣይ፥ ቢታራ ጎሼቲዛ ሜꬌቴꬂኔ ሳሎ ካፎቲ ዉሪካ ቢታፌ ፒቴቲ ꬋዪን ኖሄይኔ ኢዛራ ማርካቤ ጊዶን ዲዛይቲ ጻላ ኣቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ሃꬃይካ 150 ጋላስ ጋካናስ ቢታ ቦላን ጋምኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ጊዶ ኣቲን ጾሲ ኖሄ፥ ኢዛራ ማርካቤዛ ጊዶን ዲዛ ዶኣኔ ሜሄ ኡባ ቆፒዲ ቢታ ቦላን ጫርኮ ጫርኪሲን ሃꬃይ ዎꬊ ዎꬊ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ቃሴ ቢታ ጊዶን ዲዛ ጪማ ፑልቶይኔ ሳሎን ዲዛ ሃꬃ ማስኮቴቲ ጎርዴቲዳ፤ ኢራይካ ሳሎን ቴቄቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ሂስቲን ሃꬃይ ዎꬊ ዎꬊ ቢዴስ፤ ሄ 150 ጋላሳፌ ጉዬ ሃꬃይ ዎꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ሃꬃይ ዎꬊን ማርካቤዚ ላፑንꬃ ኣጊናን ታማኔ ላፑንꬃ ጋላሳን ኣራራቴ ጌቴቲዛ ዙማ ቦላ ሼምፒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ሃꬃይ ታማንꬆ ኣጊና ጋካናስካ ዎꬊ ዎꬊ ቢዴስ፤ ታማንꬆ ኣጊናን ኮይሮ ጋላስ ዙማታስ ሁኤይ ቤቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ኦይዱ ታሙ ጋላሳፌ ጉዬ ኖሄይ ባ ኬጺዳ ማርካቤዛ ማስኮቴዛ ዶይዲ፥ ");
INSERT INTO gmve_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ኢሲ ቁሮ ካሬ ኬሲ ዬዲን ቁሮዚ ሃꬂ ቢታ ቦላፌ ሜላና ጋካናስ ያኔ ሃ ፒራꬊሼ ጋምኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ቃሴ ኖሄይ ሃꬂ ቢታ ቦላፌ ዎꬊ ዉሪዳኮ ቤያናስ ኢሲ ሃራጴ ካሬ ዬዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ጊዶ ኣቲን ሄ ሃራጴያ ሃꬂ ቢታ ኡባ ቦላን ሃኢካ ዲዛ ጊሻስ ሼምፒዛሶ ዴማቤኩ፤ ሄሳ ጊሻስ ሲማዳ ማርካቤዛ ጊዶን ዲዛ ኖሄኮ ዪን ኢዚ ባ ኩሼ ዬዲዲ ባኮ ማርካቤዛ ጊዶ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ቃሴካ ሃራ ላፑን ጋላስ ጋምኢዲ ሃኢካ ሃራጴዮ ማርካቤዛ ጊዶፌ ኬሲ ዬዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ሄ ሃራጴያ ጋዴይ ቃሚሺን ኢዛኮ ሲማ ያሼ ዎጋራ ጼራፔ ጪሊላ ሃይꬅ ዱꬃዳ ዶናን ሳጻ ኤካ ዪዳ ጊሻስ ሃꬂ ቢታ ቦላፌ ዎꬊዳይሳ ኖሄይ ኤሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ቃሴ ኖሄይ ሃራ ላፑን ጋላስ ጋምኢዲ ሄ ሃራጴዮ ዛሪ ዬዲዴስ፤ ጊዶ ኣቲን ሄ ሃራጴያ ኢዛኮ ሲማ ያቤኩ። ");
INSERT INTO gmve_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ኖሄይ 601 ላይꬅ ዴኢን ኮይሮ ኣጊናን ኮይሮ ጋላስ ሃꬂ ቢታ ቦላፌ ጾስኪዴስ፤ ኖሄይ ማርካቤዛ ካራ ቃሪ ጼሊዲ ጋዴይ ጾስኪዳይሳ ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ናምኣንꬆ ኣጊናን ናምኡ ታማኔ ላፑንꬃ ጋላሳን ቢታይ ሙሌራ ሜሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ሄ ዎዴ ጾሲ ኖሄ ሂዝጊ ኣዛዚዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«ኔኒ ኔ ማቾ፥ ኔ ናይታኔ ኔ ናይታ ማቼታ ኤካዳ ማርካቤዛፔ ኬዛ። ");
INSERT INTO gmve_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ኢስቲ ዬሌቲ ዳሪዲ ጮራታና ማላ ሼምፖራ ዲዛ ሜꬌቴꬃ ኡባፌ ኔናራ ዲዛይታ፥ ካፎታ፥ ሜሄታ፥ ዶኣታኔ ቢታራ ጎሼቲዛይታ ኡባ ኔናራ ኬሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","ኖሄይ ባ ናይታራ፥ ባ ማቼይራኔ ባ ናይታ ማቼታራ ማርካቤዛ ጊዶፌ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ሜሄይ፥ ዶኣይ፥ ቢታራ ጎሼቲዛ ሜꬌቴꬂ፥ ካፎይኔ ቢታ ቦላን ዎጺ ቃጺዛ ሚሺ ዉሪ ባ ቆሞን ቆሞን ማርካቤዛ ጊዶፌ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","ሄሳፌ ጉዬ ኖሄይ ጎዳስ ያርሺዛሶ ኬሊዲ ጌሻ ሜሄ ኡባፌኔ ጌሻ ካፎ ኡባፌ ኤኪዲ ያርሺዛሶን ጹጊዲ ያርሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ሂስቲን ጎዳይ ያርሾዛ ፔኖ ሳዊዛይሳ ሲንጊዲ ባ ዎዚናን፥ «ዬላጋቴꬃፌ ዶሚን ኣሲ ዎዚናን ቆፒዛይሲ ዉሪ ኢታ ጊዲኮካ ታኒ ኣሳ ጊሻስ ጋዳ ናምኣንꬆ ሙሌካ ሃ ቢታ ቃንጊኬ። ቃሴ ታኒ ሃኢ ኦꬂዳ ማላ ፓጻ ዲዛ ሜꬌቴꬅ ኡባ ናምኣንꬆ ሙሌካ ꬋይሲኬ። ");
INSERT INTO gmve_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ሃ ቢታይ ዲዛ ዎዴ ኡባን ዜሬꬃ ዎዴይኔ ማጻ ዎዴይ ሞጬይኔ ሆምቤይ፥ ቦኔይኔ ባልጎይ፥ ጋላሲኔ ቃማይ ኡባ ዎዴካ ፓጬና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ጾሲ ኖሄኔ ኢዛ ናይታ፥ «ዬሌቲቴ፤ ጮራቲቴ፤ ቢታ ኡባ ኩሚቴ። ");
INSERT INTO gmve_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ቢታ ዶኣቲ፥ ካፎቲ፥ ቢታን ዎጺ ቃጺዛ ሚሻቲኔ ኣባ ጊዶን ዲዛ ሞሌቲ ዉሪ ኢንቴስ ያዬቶኔ ዳጋሜቶ፤ ኢስቲ ኢንቴ ሼኔን ዴቶ። ");
INSERT INTO gmve_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ታ ኢንቴስ ቢታፌ ሞኪዛ ዱማ ዱማ ካꬃታ ኢሚዳ ማላካ ሼምፖራ ፓጻ ዲዛ ሜꬌቴꬃቲ ዉሪ ኢንቴስ ቁማ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","ሼምፖይ ሱꬃ ጊዶን ዲዛ ጊሻስ ሱꬂ ኢዛፔ ጉኮንታ ኣሾ ሞፒቴ። ");
INSERT INTO gmve_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ታኒ ኢንቴ ሼምፖይ ኢዛን ዲዛ ኢንቴ ሱꬅ ሜሄፔኔ ዶኣ ኡባፌ ቱሙ ታ ኦይቻና፤ ቃሴ ኣሳ ኡባፌካ ኢዛ ማላ ኣሳ ሱꬅ ኦይቻና። ");
INSERT INTO gmve_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ጾሲ ኣስ ባና ሚሳቲሲዲ ሜꬊዳ ጊሻስ ኣሳ ሱꬅ ጉሲዛ ኦናካ ጊዲኮ ኢዛ ሱꬂካ ኣሳ ኩሼን ጉካና። ");
INSERT INTO gmve_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","ኢንቴ ዬሌቲቴ፤ ጮራቲቴኔ ቢታ ቦላ ኬሂ ዳሪቴ» ጊ ኣንጂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ሄሳፌ ጉዬ ጾሲ ኖሄኔ ኢዛራ ዲዛ ኢዛ ናይታ ሂዝጊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","10","«ሂስቲን ሃኢ ታኒ ታ ጫቆ ኢንቴናራ፥ ኢንቴፌ ጉዬ ኢንቴ ዜሬꬃራኔ ኔናራ ሼምፖራ ዲዛ ሜꬌቴꬃታራ ጫቄታዲስ፤ ኤ! ታኒ ታ ጫቆ ካፎራ፥ ሜሄራ፥ ቢታ ዶኣ ኡባራኔ ማርካቤፔ ኢንቴናራ ኬዚዳ ፓጻ ዲዛ ሜꬌቴꬅ ኡባራ ጫቄታዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","ታኒ ኢንቴናራ ጫቄታዲስ፤ ሃይሳፌ ሲንꬃን ፓጻ ዲዛይ ዉሪ ꬋይሲዛ ሃꬃን ሙሌካ ꬋዬና፤ ሃ ቢታ ꬋይሲዛ ሃꬂ ሃይሳፌ ጉዬ ሙሌካ ዴና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ቃሴካ ጾሲ፥ «ታኒ ታፔኔ ኢንቴፌ፥ ኢንቴናራ ዲዛ ፓጻ ሜꬌቴꬃታስ ኡባፌ ጊዶን ያና ዬሌታ ኡባራ ጫቄቲዛ ጫቆዛስ ማላታይ ሃይሳ፤ ");
INSERT INTO gmve_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ታኒ ታ ዙላ ሳሎ ቦላ ኤሳና፤ ኢዚ ታፔኔ ሃ ቢታ ቦላ ዲዛ ሜꬌቴꬃፌ ጊዶን ዲዛ ጫቆዛስ ማላታ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ታኒ ቢታፌ ቦላን ሻራ ኤሂዳ ዎዴኔ ሻራ ቦላን ዙላይ ቤቲዳ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","‹ፓጻ ዲዛ ሜꬌቴꬅ ኡባ ꬋይሳናስ ሃይሳፌ ሲንꬃን ሙሌካ ꬋይሳ ሃꬂ ዬና› ጋዳ ታፔኔ ኢንቴፌ ፓጻ ዲዛ ዱማ ዱማ ቆሞ ሜꬌቴꬃታ ኡባፌ ጊዶን ጫቂዳ ታ ቃላ ታ ቆፓና። ");
INSERT INTO gmve_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ዙላይ ሻራ ቦላ ቤቲዳ ዎዴ ኣይዴካ ታኒ ኢዛ ቤያዳ ታፔ ጾሳፌኔ ሃ ቢታ ቦላን ፓጻ ዲዛ ዱማ ዱማ ቆሞ ሜꬌቴꬃ ኡባፌ ጊዶን ጫቆ ጌሊዳ ሜርና ጫቆ ቃላ ታ ሃሳኣና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ጾሲ ኖሄ፥ «ታኒ ታፔኔ ሃ ቢታ ቦላን ፓጻ ዲዛ ኡባፌ ጊዶን ጫቂዳ ጫቆዛስ ማላታይ ሃይሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","ማርካቤዛፔ ኬዚዳ ኖሄ ናይቲ ሴሜ፥ ካሜኔ ያፌቴ፤ ካሜይ ካናኔ ኣዋ። ");
INSERT INTO gmve_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ሃይቲ ሄꬓይካ ኖሄ ናይታ፤ ቢታ ኡባን ዲዛ ኣሳይ ኢስታፌ ዬሌቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","ኖሄይ ጎሻንቻ፤ ኢዚ ዎይኔ ሚꬅ ቶኬꬅ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ኢሲ ጋላስ ኢዚ ዎይኔፔ ኦሴቲዳ ጫጄ ኡዪ ማꬆቲዲ ባ ዱንካኔዛ ጊዶን ፓጻ ካሎ ኢቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ካናኔ ኣዋ ካሜይ ባ ኣዋ ካሎቴꬅ ቤኢዲ ካሬ ኬዚዲ ባ ኢሻታ ናምኣታስ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ጊዶ ኣቲን ሴሜይኔ ያፌቴይ ማይኦ ኤኪዲ ናምኣይካ ባ ሃሼ ሃሼ ቦላ ጋꬂ ኦይኪዲ ጉንዲጉꬅ ሄሜቲ ጌሊዲ ባ ኣዋ ካሎቴꬅ ካሚዳ፤ ኢስቲ ባ ኣዋ ካሎቴꬅ ቤኦንታ ማላ ባ ኣይፌሶ ጉዬ ዛሪዳ። ");
INSERT INTO gmve_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","ኖሄይ ማꬆይ ኣꬊን ቤጊዲ ኡባፌ ካሎ ናዚ ባ ቦላ ኦꬂዳይሳ ኤሪዲ፥ ");
INSERT INTO gmve_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","«ካናኔይ ቃንጌቲዳዝ ጊዶ! ኢዚ ባ ኢሻታ ኣይሌታስ ኣይሌ ጊዶ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ቃሴካ ኖሄይ፥ «ጎዳይ፥ ሴሜ ጾሲ ጋላቴቶ! ካናኔይ ሴሜ ኣይሌ ጊዶ! ");
INSERT INTO gmve_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ጾሲ ያፌቴ ቢታ ኣሶ! ያፌቴ ዜሬꬃቲ ሴሜ ዜሬꬃታራ ዴቶ! ካናኔይ ያፌቴ ኣይሌ ጊዶ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ꬋይሳ ሃꬃፌ ጉዬ ኖሄይ 350 ላይꬅ ዴኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ኖሄይ ሙሌራ 950 ላይꬅ ዴዪዲ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ኖሄ ናይታ፥ ሴሜ፥ ካሜኔ ያፌቴ ዬሌታይ ሃይሳፌ ካሊ ጻፌቲዳይሳ፤ ꬋይሳ ሃꬃፌ ጉዬ ኢስታስ ኣቱማ ናይቲ ዬሌቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","ያፌቴ ኣቱማ ናይቲ ጎሜሬ፥ ማጎጌ፥ ማዳዬ፥ ያዋኔ፥ ቱባሌ፥ ሜሼኬኔ ቲራሴ ");
INSERT INTO gmve_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","ጎሜሬ ኣቱማ ናይቲ ኣሽኬናዜ፥ ኢራፋቴኔ ቶጋርማ። ");
INSERT INTO gmve_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ያዋኔ ኣቱማ ናይቲ ኤሊሼ፥ ታርሴሴ፥ ኪቲሜኔ ኤሮዴ። ");
INSERT INTO gmve_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ሃይታንታፌ ኣባ ዶናን ዲዛ ኣሳይ ዉሪ ባ ቢታን ቢታን፥ ባ ቃላን ቃላን፥ ባ ቆሞን ቆሞኒኔ ባ ካዎቴꬃን ካዎቴꬃን ሻኬቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ካሜ ኣቱማ ናይቲ ኩሼ፥ ጊብጼ፥ ፑጼኔ ካናኔ። ");
INSERT INTO gmve_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","ኩሼ ኣቱማ ናይቲ ሴባ፥ ሃዊላ፥ ሳቢቴ፥ ኤራኢሜኔ ሳቢቴካ። ኤራኢሜ ኣቱማ ናይቲ ሳባኔ ዳዳኔ። ");
INSERT INTO gmve_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","ኩሼይ ናሙሩዴ ዬሊዴስ፤ ናሙሩዴይ ቢታ ቦላን ኮይሮ ዎልቃማ ኦላንቻ ጊዲዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ጎዳ ሲንꬃንካ ኢዚ ዎልቃማ ሻንካንቻ ጊዲዴስ፤ ሄሳ ጊሻስ፥ «ናሙሩዴ ማላ ጎዳ ሲንꬃን ዎልቃማ ሻንካንቻ ጊዳ» ጌቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ኢዛ ካዎቴꬃን ኮይሮ ካታማቲ ሳናኦሬ ቢታን ዲዛ ባቢሎኔ፥ ኤሬኬ፥ ኣካዴኔ ካላናሄ። ");
INSERT INTO gmve_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","ኢዚ ሄ ቢታፌ ኣሶሬ ቢዲ ናናዌ፥ ኤራሆቦቴኔ ካላሄ ካታማታ ኦꬂዴስ፤ ቃሴ ናናዌፔኔ ካላሄፔ ጊዶን ዲዛ ኤሬሴኔ ጌቴቲዛ ጊታ ካታማካ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","ጊብጼይ ሉዲሜታ፥ ኣናሜታ፥ ላሃቤታ፥ ናፍቱሄታ፥ ጳጺሮሴታ፥ ካሲሉሄታኔ ፊሊስጼሜታ ዬሊዳ ካፍቶሬታ ኣዋ። ");
INSERT INTO gmve_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","16","ካናኔይ ባ ባይራ ናዛ ሲዶና፥ ኬጼታ፥ ያቡሴታ፥ ኣሞሬታ፥ ጌርጌሴታ ኣዋ፤ ");
INSERT INTO gmve_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ቃሴካ ሂዌታ፥ ኣርቄታ፥ ሲኔታ፥ ");
INSERT INTO gmve_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ኣርዋዴታ፥ ጻማሬታኔ ሃማቴታ ኣዋ። ሄሳፌ ጉዬ ካናኔ ዜሬꬃቲ ቢታ ቦላ ላሌቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ካናኔ ቢታ ዛዋይ ሲዶናፔ ዶሚዲ ጌራሬኔ ጋዛራ ካንꬂዲ፥ ሶዶሜኔ ጋሞራ፥ ኣዳማኔ ጻቦይሜ ካንꬂ ቢዲ ላሻኤሬ ጋኬስ። ");
INSERT INTO gmve_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ካሜ ኣቱማ ናይቲ ባ ቆሞን ቆሞን፥ ባ ቃላን ቃላን፥ ባ ቢታን ቢታኒኔ ባ ካዎቴꬃን ካዎቴꬃን ጻፌቲዳይቲ ሃይታንታ። ");
INSERT INTO gmve_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ሴሜስ ናይቲ ዬሌቲዳ፤ ኢዚ ያፌቴስ ባይራ ኢሻኔ ኤቦሬ ናይታ ኡባስ ማይዛ። ");
INSERT INTO gmve_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ሴሜ ኣቱማ ናይቲ ኤላሜ፥ ኣሶሬ፥ ኣርፋኪሲዴ፥ ሉዴኔ ኣራሜ። ");
INSERT INTO gmve_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","ኣራሜ ኣቱማ ናይቲ ኡጼ፥ ሁሌ፥ ጌቴሬኔ ሜሼ። ");
INSERT INTO gmve_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","ኣርፋኪሲዴይ ሼላሄ ዬሊዴስ። ሼላሄይ ኤቦሬ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ኤቦሬስ ናምኡ ኣቱማ ናይቲ ዬሌቲዳ፤ ቢታን ዲዛ ኣሳይ ኢዛ ዎዴን ሻኬቲዳ ጊሻስ ኢሳ ሱንꬂ ፔሌጌ ጌቴቲዴስ፤ ኢዛ ኢሻዛ ሱንꬂ ዮቂጻኔ ጌቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ዮቂጻኔይ ናይታ ዬሊዴስ፤ ኢስቲካ ኣልሞዳዴ፥ ሼሌፌ፥ ሃጻርማዌቴ፥ ዬራሄ፥ ");
INSERT INTO gmve_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ሃዶራሜ፥ ኡዛሌ፥ ዲቂሌ፥ ");
INSERT INTO gmve_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ኦባሌ፥ ኣቢማኤሌ፥ ሳባ፥ ");
INSERT INTO gmve_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ኦፊሬ፥ ሃዊላኔ ዮባቤ፤ ሃይታንቲ ዉሪካ ዮቂጻኔ ኣቱማ ናይታ። ");
INSERT INTO gmve_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ኢስቲ ዴኢዳ ቢታይ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ዙማ ሜሼፔ ቢዲ ሳፋሬ ጋኬስ። ");
INSERT INTO gmve_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ሴሜ ኣቱማ ናይቲ ባ ቆሞን ቆሞን፥ ባ ቃላን ቃላን፥ ባ ቢታን ቢታኒኔ ባ ካዎቴꬃን ካዎቴꬃን ጻፌቲዳይቲ ሃይታንታ። ");
INSERT INTO gmve_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ሃይታንቲ ባ ቆሞን ቆሞኒኔ ባ ካዎቴꬃን ካዎቴꬃን ጻፌቲዳ ኖሄ ኣቱማ ናይታ ዜሬꬃታ፤ ꬋይሳ ሃꬃፌ ሲሚን ካዎቴꬃቲ ሃይታንታፌ ቢታ ኡባ ቦላ ላሌቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ቢታ ቦላን ዲዛ ኣሲ ዉሪ ኮይሮ ኢሲ ዶናኔ ኢሲ ቃላ ሃሳዬስ። ");
INSERT INTO gmve_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ኣሳይ ኣርሼይ ሞኪዛ ባጋ ሲሚዲ ቢሼ ሳናኦሬ ጌቴቲዛ ቢታን ኢሲ ዴምባሶ ዴሚዲ ሄን ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ኢስቲ ኢሶይ ኢሳ፥ «ሃ ዪቴ፤ ጹቤ ሜꬊዲ ኣኔ ታማን ጹጎስ» ጊዲ ኢስታ ሹቻ ጊሻስ ጹቤ፥ ኡርቃ ጊሻስ ሺዳ ");
INSERT INTO gmve_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ኤኪዲ፥ «ሃ ዪቴ! ኑ ሱንꬅ ጼይጊሳናሲኔ ቃሴ ኑኒ ሃ ቢታ ኡባ ቦላን ላሌቶንታ ማላ ኢሲ ጊታ ካታማኔ ጼራይ ፑዴ ሳሎ ጋኪዛ ኢሲ ጊምቤ ኣኔ ኬጾስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ጊዶ ኣቲን ጎዳይ ኣሳይ ኬጺዳ ጊታ ካታማዛኔ ጊምቤዛ ቤያናስ ዱጌ ዎꬊዲ፥ ");
INSERT INTO gmve_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","«ሄኮ ኢስቲ ኢሲ ኣሳ! ቃሴ ኢስቲ ዉሪካ ኢሲ ቃላን ሃሳዬቴስ፤ ኢስቲ ሃኢ ሃይሳ ኦሶ ኦይኪዳፔ ጉዬ፥ ኢስቲ ባስ ኦꬃናስ ቆፒዳይሳ ኢስታ ዲጋናይ ዴና። ");
INSERT INTO gmve_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ሃ ዪቴ! ኣኔ ኑ ዱጌ ዎꬊዲ ኢስቲ ኢሶይ ኢሳ ቃላ ኤሮንታ ማላ ኢስታ ቃላ ዋላኮስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ሄሳ ጊሻስ ጎዳይ ኢስታ ሄሳፌ ቢታ ኡባ ቦላን ላሊን ኢስቲ ሄ ጊታ ካታማ ኦꬂዛይሳ ኣጋጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ጎዳይ ቢታ ኣሳ ቃላ ሄን ዋላኪዳ ጊሻስ ሄ ካታማያ ባቢሌ ጌቴታዱስ። ጎዳይ ኢስታ ሄሳፌ ቢታ ኡባ ቦላን ላሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ሴሜ ዜሬꬂ ሃይሳፌ ካሊዲ ጻፌቲዳይሳ፤ ꬋይሳ ሃꬂ ሲሚን ናምኡ ላይꬃፌ ጉዬ ሴሜስ ላይꬃይ 100 ጊዲን ሴሜይ ኣርፋኪሲዴ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ሴሜይ ኣርፋኪሲዴ ዬሊዳፔ ጉዬ 500 ላይꬅ ዴኢዴስ፤ ሃራ ኣቱማ ናይታካ ማጫ ናይታካ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","ኣርፋኪሲዴይ 35 ላይꬅ ዴኢዲ ሼላሄ ዬሊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ኣርፋኪሲዴይ ሼላሄ ዬሊዳፔ ጉዬ 403 ላይꬅ ዴኢዴስ፤ ሃራ ኣቱማ ናይታኔ ማጫ ናይታካ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ሼላሄይ 30 ላይꬅ ዴኢዲ ኤቦሬ ዬሊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ሼላሄይ ኤቦሬ ዬሊዳፔ ጉዬ 403 ላይꬅ ዴኢዴስ፤ ሃራ ኣቱማ ናይታኔ ማጫ ናይታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ኤቦሬ ሄꬑ ታማኔ ኦይዱ ላይꬅ ዴኢዲ ፔሌጌ ዬሊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ኤቦሬይ ፔሌጌ ዬሊዳፔ ጉዬ 430 ላይꬅ ዴኢዴስ፤ ሃራ ኣቱማ ናይታኔ ማጫ ናይታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ፔሌጌይ 30 ላይꬅ ዴኢዲ ኤራኤ ዬሊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ፔሌጌይ ኤራኤ ዬሊዳፔ ጉዬ 209 ላይꬅ ዴኢዴስ፤ ሃራ ኣቱማ ናይታኔ ማጫ ናይታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ኤራኤይ 32 ላይꬅ ዴኢዲ ሳሩጌ ዬሊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ኤራኤይ ሳሩጌ ዬሊዳፔ ጉዬ 207 ላይꬅ ዴኢዴስ፤ ሃራ ኣቱማ ናይታኔ ማጫ ናይታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","ሳሩጌይ 30 ላይꬅ ዴኢዲ ናኮሬ ዬሊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ሳሩጌይ ናኮሬ ዬሊዳፔ ጉዬ 200 ላይꬅ ዴኢዴስ፤ ሃራ ኣቱማ ናይታኔ ማጫ ናይታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ናኮሬይ 29 ላይꬅ ዴኢዲ ታራ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ናኮሬይ ታራ ዬሊዳፔ ጉዬ 119 ላይꬅ ዴኢዴስ፤ ሃራ ኣቱማ ናይታኔ ማጫ ናይታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","ታራይ 70 ላይꬅ ዴኢዲ ኣብራሜ፥ ናኮሬኔ ሃራኔ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ታራ ዬሌታይ ሃይሳፌ ካሊዲ ጻፌቲዳይሳ፤ ታራይ ኣብራሜ፥ ናኮሬኔ ሃራኔ ዬሊን ሃራኔይ ሎጼ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ሃራኔይ ባ ኣዋይ ታራይ ፓጻ ዲሺን ባ ዬሌቲዳ ካላዳዌታ ቢታን ኡሬ ጌቴቲዛ ጊታ ካታማን ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ኣብራሜይኔ ናኮሬይ ናምኣይካ ማቺዳ፤ ኣብራሜ ማቼይ ሱንꬂ ሶራ፤ ቃሴ ናኮሬ ማቼይ ሱንꬂ ሚልካ፤ ሚልካይ ሃራኔ ና፤ ሃራኔይ ሚልኪሲኔ ዪስካኒሲ ኣዋ። ");
INSERT INTO gmve_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ሶራይ ማይኔ፤ ኢዚስ ናይ ባዋ። ");
INSERT INTO gmve_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","ታራይ ባ ና ኣብራሜ፥ ባ ናዛ ሃራኔ ና ሎጼኔ ባ ና ኣብራሜ ማቾ ሶራ ኤኪዲ ኬዚን ኢስቲ ኢሲፌ ካናኔ ቢታ ባናስ ኡሬ ጌቴቲዛ ካላዳዌታ ካታማፔ ዴንዲዳ፤ ጊዶ ኣቲን ኢስቲ ካራኔ ጌቴቲዛ ካታማ ጋካናስ ቢዲ ሄን ዴኢዳ። ");
INSERT INTO gmve_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ታራይ 205 ላይꬅ ዴኢዲ ካራኔን ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","ጎዳይ ኣብራሜ፥ «ኔ ዴሬፔ፥ ኔ ዳቦታፔኔ ኔ ኣዋ ኬꬃ ኣሳፔ ሻኬታዳ ታኒ ኔና ቤሲዛ ቢታ ባ። ");
INSERT INTO gmve_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","«ታኒ ኔና ጊታ ካዎቴꬅ ኦꬃና፤ ቃሴካ ኣንጃና፤ ኔ ሱንꬃ ጊታሳና፤ ኔካ ሃራታስ ኣንጆ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","ኔና ኣንጂዛይታ ታ ኣንጃና፤ ኔና ቃንጊዛይታካ ታ ቃንጋና፤ ቢታ ቦላ ዲዛ ኣሲ ዉሪ ኔ ባጋራ ኣንጄታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ኣብራሜይ ጎዳይ ኢዛስ ዮቲዳ ማላ ዴንዲ ቢዴስ፤ ሎጼይካ ኢዛራ ቢዴስ፤ ኣብራሜይ ካራኔ ዴሬፔ ቢሺን ኢዛስ ላይꬃይ ላፑን ታማኔ ኢቻሻ። ");
INSERT INTO gmve_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ኣብራሜይ ባ ማቺዮ ሶራ፥ ባ ኢሻ ና ሎጼ፥ ካራኔን ኢስቲ ዴሚዳ ኣይሌታኔ ሄን ሺሺዳ ባንታ ኣቆታ ኡባ ኤኪዲ ካናኔ ቢታ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ኣብራሜይ ሄ ቢታን ሴኬሜን ሞሬ ጌቴቲዛሶን ዲዛ ጊታ ሚꬃኮ ጋካናስ ቢዴስ፤ ሄ ዎዴ ካናኔ ኣሳቲ ሄ ቢታን ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ጎዳይ ኣብራሜስ ቆንጪዲ፥ «ሃ ቢታ ታኒ ኔ ዜሬꬃስ ኢማና» ጊዴስ፤ ኢዚ ባስ ቆንጪዳ ጎዳስ ሄ ሶሆን ያርሾ ያርሺዛሶ ኬጺዲ ጎይኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ሄሳፌ ዴንዲዲ ቤቴሌፔ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ዙማቲዛሶ ቢዲ ሄን ቤቴሌ ኣርሼይ ዉሊዛ ባጋን ኣጊዲ ቃሴ ኣዬ ጌቴቲዛ ካታማ ኣርሼይ ሞኪዛ ባጋ ኣጊዲ ጊዶን ባ ዱንካኔ ቶሊዴስ፤ ሄንካ ጎዳስ ያርሾ ያርሺዛሶ ኬጺዲ ጎዳ ሱንꬃ ጼይጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ሄሳፌ ጉዬ ኣብራሜይ ሄፔ ዴንዲ ቢዲ ኔጌቤ ጌቴቲዛ ባዞ ጋኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ሄ ዎዴ ካናኔ ቢታን ኮሻይ ዴንዲን ኮሻዚ ኬሂ ኢታ ጊዲዳ ጊሻስ ኣብራሜይ ኮሻ ዎዴ ኣꬃናስ ዱጌ ጊብጼ ዎꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ጊብጼ ጌላና ሃኒሺን ኣብራሜይ ባ ማቺዮ ሶራ፥ «ሲያ! ኔ ዳሮ ማላ ሎኦ ማጫስ ጊዲዳይሳ ታ ኤራይስ። ");
INSERT INTO gmve_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ጊብጼ ኣሳይ ኔና ቤኢዛ ዎዴ ኢስታስ፥ ‹ሃና ኢዛ ማቾ› ጊዲ ኔና ኣጊዲ ታና ዎꬋና። ");
INSERT INTO gmve_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ሄሳ ጊሻስ ኢስቲ ታስ ኔ ጋሶን ኪያና ማላኔ ቃሴ ኔ ጋሶን ታ ሃይቆንታ ኣታና ማላ ኔኒ፥ ‹ታ ኢዛስ ሚቾ› ጋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ኣብራሜይ ጊብጼ ቢታ ጌሊዳ ዎዴ ጊብጼ ኣሳቲ ሄ ማጫሳያ ዳሮ ማላ ሎኦ ማጫስ ጊዲዳይሳ ቤኢዳ። ");
INSERT INTO gmve_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ቃሴ ጊብጼ ካዎስ ኦꬂዛ ሃላቃቲካ ኢዞ ቤኢዲ ካዎ ሲንꬃን ኢዞ ናሺዳ፤ ሂስቲዲ ኢዞ ካዎሶ ኤፊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ሂስቲን ኢዚ ጌዶን ካዎይ ኣብራሜ ሎኦ ኣይፌን ጼሊዲ ኣብራሜስ ዶርሳታኔ ቦራታ፥ ኣዴ ሃሬታኔ ማጫ ሃሬታ፥ ኣዴ ኣይሌታኔ ማጫ ኣይሌታ፥ ጋሜላታካ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ጊዶ ኣቲን ጎዳይ ኣብራሜ ማቼዮ ሶራ ጌዶን ጊብጼ ካዎ ቦላኔ ኢዛሶ ኣሳ ቦላ ቦሻ ዬዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ሂስቲን ካዎዚ ኣብራሜ ጼይጊዲ፥ «ኔኒ ሃይሳ ኣይስ ታ ቦላ ኦꬃዲ? ኢዛ ኔ ማቾ ጊዲዳይሳ ኣይስ ታስ ዮታቤኪ? ");
INSERT INTO gmve_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ታ ኢዞ ማቾ ኤካና ማላ፥ ‹ኢዛ ታ ሚቾ› ጋዳ ኣዛስ ዎርዶታዲ? ሄኮ ሃኖ ኔ ማቼዮ ኤካዳ ባ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ካዎዚካ ባ ኣይሌታ ኣብራሜ ኢዛ ማቼይራኔ ኢዛስ ዲዛዝ ኡባ ኬሲዲ ዬዳና ማላ ኣዛዚን ኣይሌቲ ኢስታ ዴሬፔ ኬሲ ዬዲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ሄሳ ጊሻስ ኣብራሜይ ባ ማቼይራኔ ባስ ዲዛዝ ኡባራ ጊብጼፔ ኔጌቤ ባዞ ቢዴስ፤ ሎጼይካ ኢዛራ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ኣብራሜይ ሄ ዎዴ ሜሄን፥ ቢራኒኔ ዎርቃን ዳሮ ዱሬቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ኢዚ ኔጌቤፔ ዴንዲዲ ቤቴሌ ጋካናስ ቢዴስ፤ ቤቴሌፔኔ ኣዬፔ ጊዶን ዲዛ ዴሬ ቢዴስ፤ ሄሶይካ ኢዚ ኮይሮ ባ ዱንካኔ ቶሊዲ፥ ");
INSERT INTO gmve_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ያርሾ ሺሻናስ ኬጺዳሶ፤ ሄንካ ኣብራሜይ ጎዳ ሱንꬅ ጼይጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ኣብራሜራ ዩዪዛ ሎጼስካ ዳሮ ሚዚ፥ ዶርሲ፥ ዴይሺኔ ዱንካኔይ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ጊዶ ኣቲን ኢስታስ ዳሮ ሜሄይ ዲዛ ጊሻሲኔ ኢስቲ ኢሲፌ ዳናስ ኢስታስ ቢታይ ጹሚዳ ጊሻስ ኢሲፌ ዳናስ ዳንዳይቤቴና። ");
INSERT INTO gmve_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ሄሳ ጌዶን ኣብራሜ ዉዴ ሄሚዛይታ ጊዶኒኔ ሎጼ ዉዴ ሄሚዛይታ ጊዶን ኦሺ ሜꬌቲዴስ፤ ሄ ዎዴ ካናኔቲኔ ፓሪዜቲ ሄ ቢታን ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ሂስቲን ኣብራሜይ ሎጼስ፥ «ኑኒ ኢሻንታ ጊዲዳ ጊሻስ፥ ኑ ጊዶን፥ ታ ሜሄ ሄሚዛይታ ጊዶኒኔ ኔ ሜሄ ሄሚዛይታ ጊዶን ኦሽ ሜꬎፋ። ");
INSERT INTO gmve_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ቢታይ ዉሪ ኔ ሲንꬃን ዴኔ? ኣኔ ኑኒ ሻኬቶስ፤ ኔኒ ሃዲርሳ ባጋ ቢኮ፥ ታኒ ኡሻቻ ባጋ ባና፤ ኔኒ ኡሻቻ ባጋ ቢኮ ታኒ ሃዲርሳ ባጋ ባና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ሎጼይ ዩዪ ኣꬊ ጼሊዲ ዮርዳኖሴ ሾባይ ቢዲ ዞኣሬ ጋካናስ ጎዳ ጋናቴ ዎይኮ ጊብጼ ቢታ ማላ ዳሮ ሃꬂ ዲዛይሳ ቤኢዴስ። (ሄሲካ ጎዳይ ሶዶሜኔ ጋሞራ ጌቴቲዛ ካታማታ ꬋይሳናፔ ካሴ።) ");
INSERT INTO gmve_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ሄሳ ጊሻስ ሎጼይ ባስ ዮርዳኖሴ ሾባ ኡባ ዶሪዲ ኣርሼይ ሞኪዛ ባጋራ ቢዳ ጊሻስ ኢስቲ ባ ጋርሳን ሻኬቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ኣብራሜይ ካናኔ ቢታን ዴኢዴስ፤ ሎጼይ ጊዲኮ ሾባን ዲዛ ጊታ ካታማታ ጊዶን ኡቲዲ ሶዶሜ ካታማ ማታን ባ ዱንካኔዛ ቶሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ሄ ዎዴ ሶዶሜ ኣሳይ ኢታኔ ጎዳ ሲንꬃን ፓላ ናጋራ ኦꬂዛይታ። ");
INSERT INTO gmve_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ሎጼይ ኣብራሜፔ ሻኬቲዳፔ ጉዬ ጎዳይ ኣብራሜ፥ «ꬎቁ ጋዳ ኔኒ ዲዛሶፔ ኣርሼይ ሞኪዛ ባጋኔ ጌሊዛ ባጋ ቃሴ ዱጌሃ ባጋኔ ፑዴሃ ባጋ ጼላ። ");
INSERT INTO gmve_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ሃይሳ ኔኒ ጼሊዛ ቢታ ኡባ ታ ኔሲኔ ኔ ዜሬꬃስ ሜርናስ ኢማና። ");
INSERT INTO gmve_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ታኒ ኔ ዜሬꬅ ቢታ ኣጬ ማላ ዳርሳና፤ ኦኒካ ቢታ ኣጬ ታይባና ዳንዳይኮ ኔ ዜሬꬂካ ታይቤታና። ");
INSERT INTO gmve_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ዴንዳዳ ቢታ ቦላ ፑዴኔ ዱጌ፥ ያኔ ሃ ዩያ ጼላ፤ ጋሶይካ ታኒ ሃይሳ ቢታ ኔስ ኢማና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ሂስቲን ኣብራሜይ ባ ዱንካኔዛ ሾዲዲ፥ ኬብሮኔን ማሚሬ ጌቴቲዛሶን ዲዛ ጊታ ሚꬃ ኣቻን ዴኣናስ ቢዴስ። ሄንካ ጎዳስ ያርሾ ያርሺዛሶ ኬጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ሄ ዎዴ ሳናኦሬ ካዎይ ኣሚራፌሌይ፥ ኤላሳሬ ካዎይ ኣርዮኬይ፥ ኤላሜ ካዎይ ካዶርላኦሜሬይኔ ኣይዛቤ ካዎ ቲዲኣሌይ ኦይዳቲ፥ ");
INSERT INTO gmve_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ሶዶሜ ካዎ ቤራኤራ፥ ጋሞራ ካዎ ቢርሻራ፥ ኣዳማ ካዎ ሺንኣቤራ፥ ጻቦይሜ ካዎ ሼሜቤሬይኔ (ዞኣሬ ጌቴቲዛ) ቤላ ካዎራ ኦሌታናስ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ሃ ኢቻሹ ካዎቲ ጋጊዲ ኢሲ ባጋ ጊዲዲ፥ (ሃይቆ ኣባ ጌቴቲዛ) ሲዲሜ ሾባን ሺቂዳ። ");
INSERT INTO gmve_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ኢስቲ ካሴ ታማኔ ናምኡ ላይꬅ ካዶርላኦሜሬስ ሃሬቲዳ፤ ጊዶ ኣቲን ታማኔ ሄꬓንꬆ ላይꬃን ኢዛ ቦላ ማካሊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ታማኔ ኦይዳንꬆ ላይꬃን ካዶርላኦሜሬይኔ ኢዛራ ዙፔቲዳ ካዎቲ ባ ኦላንቻታ ኤኪ ቢዲ፥ ኣስታሮቴ-ቃርናይሜን ዲዛ ኤራፋይሜታ፥ ሃማን ዲዛ ዙዜታኔ ሻዌ-ቂሪያታይሜን ዲዛ ኤሚሜ ጌቴቲዛ ዴሬታ ኦሊዲ ጾኒዳ። ");
INSERT INTO gmve_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ሆሬ ቢታ ኣሳታካ ሴይሬ ዙማ ቦላ ኦሊዲ ባዞ ኣቻን ዲዛ ኤልፓራኔ ጌቴቲዛሶ ጋካናስ ጎዲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ሄሳፌ ጉዬ ሲሚዲ ኤን-ሚሺፓጼ ዪዳ። (ሃኢ ሄ ዴሬይ ቃዴሴ ጌቴቴስ።) ኢስቲ ኣማሌቄታ ቢታ ቃሴ ሃጻጾኔ ታማሬ ጌቴቲዛሶን ዲዛ ኣሞሬ ኣሳ ኡባ ኦሊዲ ጾኒዳ። ");
INSERT INTO gmve_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ሄሳፌ ሲሚን፥ ሶዶሜ ካዎይ፥ ጋሞራ ካዎይ፥ ኣዳማ ካዎይ፥ ጻቦይሜ ካዎይኔ (ዞኣሬ ጌቴቲዛ) ቤላ ካዎይ ዴንዲዲ ሲዲሜ ሾባን ኦላስ ሳልፊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ሃይቲ ዉሪ ኤላሜ ካዎራ፥ ኣይዛቤታ ካዎራ፥ ሳናኦሬ ካዎራኔ ኤላሳሬ ካዎራ (ሃ ኢቻሹ ካዎቲ ኦይዱ ካዎታራ) ኦሌቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ሄ ዎዴ ሲዲሜ ሾባን፥ ሺዳ ኦይኪዛ ዳሮ ኦላይ ዴስ። ሶዶሜ ካዎይኔ ጋሞራ ካዎይ ባ ኦላ ኣሳራ ኦላፔ ባቃቲሺን፥ ኢስታፌ ጉꬃቲ ሄ ኦላታን ኩንዲዳ፤ ጊዶ ኣቲን ኣቲዳይቲ ፑዴ ዙማ ቦላ ባቃቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ኦይዱ ካዎቲ ሶዶሜኔ ጋሞራ ካታማታ ኣቆታኔ ሚዛ ካꬅ ኡባ ቦንቂ ኤኪ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ኣብራሜ ኢሻ ናይ ሎጼይ፥ ሶዶሜን ዲዛ ጊሻስ ኢዛካ ኢዛ ኣቆታካ ኡባ ኤኪ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ሄሳፌ ጉዬ ኢሲ ኣሲ ኬሲ ኤኪዲ ባቃቲ ዪዲ ኢብራዌ ኣብራሜስ ሄሳ ዮቲዴስ፤ ኣብራሜይ ሄ ዎዴ ኤሽኮሌኔ ኣኔሬ ኢሻ ኣሞሬ ዴሬ ኣስ ማሚሬ ዎላ ኣቻን ዴስ፤ ኢስቲ ዉሪካ ኦላ ዛራናስ ኣብራሜራ ጫቄቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","ኣብራሜይ ባ ዳቦይ ዲኤቲዳይሳ ሲዪዳ ዎዴ ኦላ ኤሪዛ ባሶን ዬሌቲዳ ሄꬑ ጼታኔ ታማኔ ኦስፑን ኣሳ ዴንꬂዴስ፤ ሄ ኦይዱ ካዎታ ካሊዲ ዳኔ ጌቴቲዛ ካታማ ጋካናስ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ሄን ኦማርሳን ባ ኣሳ ጩጋን ጩጋን ሻኪዲ፥ ባ ሞርኬታራ ኦሌቲዲ ጾኒዴስ፤ ሂስቲዲ ዳማስቆፌ ቦላ ባጋራ ዲዛ ሆቤ ጌቴቲዛሶ ጋካናስ ጎዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ኣብራሜይካ ባ ዳቦ ሎጼኔ ኢዛ ኣቆታ ኡባ ካሴ ዲኤቲዳ ማጫሳኔ ሃራ ኣሳካ ዎꬂ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","ኣብራሜይ ካዶርላኦሜሬኔ ኢዛራ ዙፔቲዳ ካዎታ ጾኒዲ ሲሚዳፔ ጉዬ፥ ሶዶሜ ካዎይ፥ (ካዎታ ሾባ ጌቴቲዛ) ሻዌሃ ሾባን ኢዛ ሞካናስ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ሄ ዎዴ፥ ሳሌሜ ካዎይ ማልኬጼዴቄይ ኡኬꬂኔ ዎይኔ ኡሹ ኤኪ ዪዴስ፤ ኢዚካ ኡባፌ ꬎቃ ጾሳ ቄሴ። ");
INSERT INTO gmve_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ኢዚ ኣብራሜ ሂዝጊ ኣንጂዴስ፤ «ኡባፌ ꬎቃ ጾሲ ሳሎኔ ሳኣ ሜꬊዳይሲ ኣብራሜ ኣንጆ። ");
INSERT INTO gmve_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ቃሴ ኡባፌ ꬎቃ ጾሲ፥ ኔ ሞርኬታ ኔ ኩሼን ኣꬂ ኢሚዳይሲ ጋላቴቶ» ጊዴስ። ኣብራሜይ ኡባፌ ታማፌ ኢሲ ኩሼ ኬሲዲ ማልኬጼዴቄስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ሶዶሜ ካዎይ ኣብራሜ፥ «ታ ኣሳ ታስ ዛራዳ ኔ ዲኢዳ ሜሄዛ ኡባ ኔስ ኤካ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ጊዶ ኣቲን ኣብራሜይ ሶዶሜ ካዎ፥ «ታኒ ጎዳስ፥ ኡባፌ ꬎቃ ጾሳስ፥ ሳሎኔ ሳኣ ሜꬊዳይሳስ፥ ታ ኩሼ ዴንꬃዳ ጫቃይቻዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","24","ታ ኣሳይ ሚዳይሳፌኔ ታናራ ቢዳ ኣኔሬ፥ ኤሽኮሌኔ ማሚሬ ጋኪዛይሳፌ ኣቲን ኔኒ፥ ‹ኣብራሜ ታኒ ዱሬሳዲስ ጎንታ ማላ ታኒ ኔይሳፌ ሃራይ ኣቶ ኢሲ ሚሽ ዎይኮ ጫማ ኪሬካ ታ ኤኪኬ፤ ኢስቲ ባና ጋኪዛይሳ ኤኬቶ› ጌስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ሄሳፌ ጉዬ ጎዳ ቃላይ ኣጁታን ኣብራሜኮ ዪዲ፥ «ኣብራሜ፥ ባቦፋ! ታኒ ኔስ ጎንዳሌ፤ ኔ ኣንጆይ ኬሂ ጊታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ኣብራሜይ፥ «ኣቤት ኡባ ሃሪዛ ጎዳዉ! ታስ ሙሌካ ናይ ባይንዳ ጊሻስ ኔኒ ኢሚዛ ኢሞታይ ታስ ኣይሴ? ዳማስቆ ዴሬ ኣስ ኤልኤዜሬይ ታና ላታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ቃሴካ ኣብራሜይ፥ «ኔኒ ታስ ኣይኮ ና ኢማቤካ፤ ሄሳ ጊሻስ ታሶን ዲዛ ኣይሌይ ታና ላታናስ ዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","ጎዳ ቃላይ ኢዛኮ ዪዲ፥ «ሃይሲ ኣይሌይ ኔና ላቴና፤ ኔፔ ዬሌቲዳይ ኔና ላታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ሄሳፌ ጉዬ ጎዳይ ኣብራሜ ካሬ ኬሲዲ፥ «ፑዴ ሳሎ ጼላ፤ ኔኒ ጾሊንቴታ ታይባናስ ዳንዳይኮ ታይባ፤ ኔ ዜሬꬃይካ ሃይሳ ማላ ጊዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","ኣብራሜይካ ጎዳ ኣማኒዴስ፤ ኢዛ ኣማኖይካ ጺሎቴꬃን ቆዴቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","ቃሴካ ጎዳይ ኢዛ፥ «ኔ ሃይሳ ቢታ ላታና ማላ ታ ኔስ ኢማናስ ኡሬ ጌቴቲዛ ካላዳዌታ ካታማፔ ኔና ኬሳ ኤሂዳ ጎዳይ ታና ዲኪና?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","ጊዶ ኣቲን ኣብራሜይ ኢዛ፥ «ኣቤት ኡባ ሃሪዛ ጎዳዉ! ታኒ ሃይሳ ቢታ ላታናይሳ ኣዛን ኤሮ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ጎዳይካ ኢዛ፥ «ሄꬑ ላይꬃ ኡስ፥ ሄꬑ ላይꬃ ዴይሽ፥ ሄꬑ ላይꬃ ዶርሳ ላቃኔ ናምኡ ቆሞ ሃራጴታ ታስ ኤካ ያ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ኢዚ ሄይታ ኡባታ ኢዛስ ኤኪ ኤፊ ሹኪዲ ጊዶን ናምኡ ናምኡ ኬሲ ሻኪዲ ኢሳ ኢሳ ጊናን ዎꬂዴስ፤ ጊዶ ኣቲን ካፎታ ናምኡ ኬሲቤና። ");
INSERT INTO gmve_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ሄ ዎዴ ኣንኮ ካፎቲ ሄ ኣሾዛ ቦላ ኡቲን ኣብራሜይ ኢስታ ጎዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","ኣርሼይ ዉሊዛ ዎዴ ኣብራሜ ዎልቃማ ꬊስኮይ ኦይኪን ዳጋንꬂዛ ጊርዲ ጊዳ ꬉማይ ኢዛ ቦላ ꬉሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ሂስቲን ጎዳይ ኢዛስ፥ «ኔ ዜሬꬃይ ሃራ ቢታን ቤቴ ጊዲ ዳናይሳ ኔኒ ቱማፔ ኤራ፤ ኢስቲ ኣይሌቲዲ 400 ላይꬅ ዬꬌቲ ሃሬታና። ");
INSERT INTO gmve_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ኣይሌሲዲ ኢስታ ሃሪዛ ካዎቴꬃ ታ ቃጻያና፤ ሄሳፌ ጉዬ ኢስቲ ዳሮ ኣቆራ ሄ ቢታፌ ኬዛና። ");
INSERT INTO gmve_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","ኔኒ ጊዲኮ ኔ ኣዋታኮ ሳሮን ባና፤ ኔ ኬሃ ጪማዳ ሃይቃናኔ ሞጌታና። ");
INSERT INTO gmve_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ኦይዳንꬆ ዬሌታን ኔ ዜሬꬃይ ሃ ቢታ ሲማና፤ ኣይስ ጊኮ ኣሞሬ ዴሬ ኣሳ ናጋራይ ቡሮ ኩሞንታ ጊሻሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ኣርሼይ ዉሊን ጋዴይ ꬉሚዳፔ ጉዬ ጮጬ ታማ ላጮይኔ ጩዋይ ቤቲዲ ሄ ናምኡ ናምኡ ኬዚ ሻኬቲዳ ኣሾታ ጊዶራ ካንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ሄ ጋላስ ጎዳይ ኣብራሜስ፥ «ጊብጼ ሻፋፔ ዶሚዲ ኤፊራጺሴ ጌቴቲዛ ጊታ ሻፋ ጋካናስ ሃ ቢታ ታኒ ኔ ዜሬꬃስ ኢማዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","ሄይቲካ ቄናዌታ፥ ቄናዜታ፥ ቃዲሞኔታ፥ ሂቴታ፥ ፓሪዜታ፥ ኤራፋይሜታ፥ ኣሞሬታ፥ ካናኔታ፥ ጌርጌሴታኔ ያቡሴታ ቢታ» ጊ ጫቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ኣብራሜ ማቼያ ሶራይ ኢዛስ ሃኢካ ና ዬላቤኩ፤ ጊዶ ኣቲን ኢዚስ ጊብጼፔ ዪዳ ኣጋሮ ጌቴቲዛ ኢሲ ኣይሌያ ዳዉስ። ");
INSERT INTO gmve_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ሄሳ ጊሻስ ሶራይ ኣብራሜ ጼይጋዳ፥ «ቤያ! ጎዳይ ታና ዬሎ ዲጊዴስ። ኔኒ ባዳ፥ ታ ኣይሌይራ ኣቃ፤ ኦኔ ኤሪዛይ፥ ታኒ ኢዚ ባጋራ ና ኣዮ ጊዳናኮኔ» ጋዱስ፤ ሂስቲን ኣብራሜይ ሶራ ቃላ ሲዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ኣብራሜይ ካናኔ ቢታን ታሙ ላይꬅ ኡቲዳፔ ጉዬ ኣብራሜ ማቼያ ሶራይ ጊብጼፔ ኤሂዳ ባ ኣይሌዮ ኣጋሮ፥ ባ ኣዚና ኣብራሜስ ማቾ ሂስታ ኢማዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ኣብራሜይካ ኣጋሮ ኤኪን ኢዛ ቃንꬃታዱስ፤ ኢዛ ባስ ሻራይ ኣቲዳይሳ ኤሪዳ ዎዴ ባ ጎዳቴዮ ሌቃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ሄ ዎዴ ሶራይ ኣብራሜ፥ «ታ ቆሄቲዛ ቆሆይ ኔና ጋኮ፤ ታኒ ታ ኣይሌዮ ኔስ ኢሚን ኢዛ ሃኢ ባስ ሻራይ ኣቲዳይሳ ኤራዳ ታና ሌቃዉስ። ኔሲኔ ታስ ጾሲ ፒርዶ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ኣብራሜይካ ሶራ፥ «ሃኖ ቤያ! ኔ ኣይሌያ ኔ ኩሼን ዳዉስ፤ ኔኒ ኢዞ ኔና ሎኢዳዝ ኦꬃ» ጊዴስ፤ ሄሳፌ ጉዬ ሶራይ ኣጋሮ ቆሂን ኢዛ ኬዛዳ ኢዚፔ ቤታዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ጎዳ ኪታንቻይ ኣጋሮ ባዞን ፑልቶ ሃꬃ ኣቻን ዴሚዴስ፤ ሄ ፑልቶይ ሹራ ጌቴቲዛ ቢታ ኤፊዛ ኦጌ ማታን ዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ኢዚካ ኣጋሮ፥ «ሃኔ ሶራ ኣይሌ ኣጋሬ! ኣዋፔ ያዲ? ቃሴ ኣዋ ባይ?» ጊ ኦይቺዴስ። ኢዛ፥ «ታኒ ታ ጎዳቴዮ ሶራፔ ቤቴ ባይስ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ጎዳ ኪታንቻይካ ኢዚስ፥ «ኔኒ ኔ ጎዳቴይኮ ጉዬ ሲማ ባዳ ኢዚስ ሃሬታ» ጊዴስ ");
INSERT INTO gmve_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","ቃሴካ ጾሳ ኪታንቻይ ኢዞ፥ «ኔ ዜሬꬅ ታይባናስ ዳንዳዬቶንታይሳ ኬና ታኒ ዳርሳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ቃሴካ ጎዳ ኪታንቻይ ኢዞ፥ «ሃኢ ኔኒ ቃንꬃታዳሳ፤ ኔኒ ኣቱማ ና ዬላና፤ ዬላዳ ኢዛ ኢስማኤሌ ጋዳ ሱንꬃና፤ ጋሶይካ ጾሲ ኔ ዋሳ ሲዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ኢዚ ባዞን ዬዳ ዲዛ ሃሬ ማላ ጊዳና፤ ኣሳ ኡባራ ኢዚ ኤቄታና፤ ቃሴ ኣሲ ዉሪካ ኢዛራ ኤቄታና፤ ኢዚ ባ ኢሻታ ኡባራ ኢጼቲ ዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ኣጋራካ፥ «ታኒ ታና ቤኢዛይሳ ቤኣዳ ፓጻ ኣታኔ?» ጋዳ ኢዛ ባስ ሃሳይዳ ጎዳ፥ «ኔኒ ታና ቤኢዛ ጾሳ» ጋ ሱንꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ሄሳ ጊሻስ ሄ ፑልቶ ኦላይ፥ «ታና ቤኢዛ ዴኦ ጾሳ ፑልቶ» ጌቴቲዴስ፤ ሄ ኦላይ ሃኢ ጋካናስ ቃዴሴፔኔ ባሬዴፔ ጊዶን ዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ኣጋራ ኣብራሜስ ኣቱማ ና ዬላዱስ፤ ኣብራሜይ ኣጋራ ዬሊዳ ናዛ ኢስማኤሌ ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ኣጋራ ኢስማኤሌ ኣብራሜስ ዬሊዳ ዎዴ ኣብራሜ ላይꬃይ 86። ");
INSERT INTO gmve_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ኣብራሜ ላይꬂ ኡዱፉን ታማኔ ኡዱፉን ጊዲሺን ጎዳይ ኢዛስ ቆንጪዲ፥ «ታኒ ኡባ ዳንዳይዛ ጾሳ፤ ኔ ታ ሲንꬃን ሱሬ ሄሜታ። ");
INSERT INTO gmve_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ታኒ ታፔኔ ኔፔ ጊዶን ዲዛ ጫቆ ቃላ ሚንꬃና፤ ታኒ ኔ ዜሬꬃ ኬሃ ዳርሳና!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ኣብራሜይ ቢታን ዱጌ ጉፋኒዲ ሁኤይ ቢታ ቦቺን ኢዚ ጾሳስ ዚጊን ጾሲ ኢዛስ፥ ");
INSERT INTO gmve_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«ሃኢ ታ ኔናራ ጫቂዛ ጫቆይ ሃይሳ፤ ኔኒ ዳሮ ካዎቴꬃታስ ኣዋ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ሃቺፌ ጉዬ ኔ ሱንꬂ ኣብራሜ ጌቴቴና፤ ጊዶ ኣቲን ኔ ሱንꬂ ኣብራሃሜ ጌቴታና፤ ኣዛስ ጊኮ ታኒ ኔና ዳሮ ካዎቴꬃታስ ኣዋ ኦꬃዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ታኒ ኔና ኬሃ ዳርሳና፤ ታኒ ኔና ዳሮ ካዎቴꬅ ሂስታና፤ ካዎቲካ ኔፔ ኬዛና። ");
INSERT INTO gmve_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","ታኒ ታፔኔ ኔፔ፥ ኔፔ ጉዬ ኔ ዜሬꬃ ጊዶን፥ ዬሌታፔ ዬሌታ ጋካናስ ታ ጌሊዳ ጫቆ ቃላ ሚንꬃና፤ ሃ ጫቆይካ ታኒ ኔሲኔ ኔፔ ጉዬ ኔ ዜሬꬃስ ጾስ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ሃኢ ኔኒ ቤቴ ጊዳዳ ዲዛ ካናኔ ዴሬይ ዉሪ ኔሲኔ ኔፔ ጉዬ ኔ ዜሬꬃስ ሜርናስ ላታ ቢታ ጊዳና ማላ ታኒ ኢማና፤ ቃሴ ታኒ ኢስታ ጾስ ጊዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ቃሴካ ጾሲ ኣብራሃሜ፥ «ኔካ ኔፔ ጉዬ ኔ ዜሬꬃይካ፥ ዬሌታፔ ዬሌታ ጋካናስ ታ ጫቆ ቃላ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ታፔኔ ኔፔ፥ ኔፔ ጉዬ ኔ ዜሬꬃ ጊዶን ኢንቴ ናጋና ታ ጫቆ ቃላይ ሃይሳ፤ ኢንቴ ጊዶን ዲዛ ኣቱማስ ኡባይ ቃጻሬቶ። ");
INSERT INTO gmve_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","ኢንቴ ሹርቴ ቃጻሬቴታ፤ ሃይሲ ታሲኔ ኢንቴስ ጊዶን ዲዛ ጫቆ ቃላስ ማላታ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","ኢንቴ ጊዶን ሲንꬃፌ ዬሌታና ኣዴ ናይቲ ዉሪ ዬሌቲዳ ኦስፑንꬃ ጋላስ ቃጻሬታናስ ኮሼስ፤ ኔሶን ዬሌቲዳይታ ጊዲን፥ ዎይኮ ኣላጋፔ ሚሻን ሻሜቲዳ ኣይሌታ ጊዲን ኔ ዜሬꬅ ጊዶንታ ኣዴታካ ቃጻራናስ ኮሼስ። ");
INSERT INTO gmve_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","ኔሶን ዬሌቲዳይቲኔ ኔ ሚሻን ሻሜቲዳይቲ ቃጻሬቴቶ፤ ሃይሲ ኢንቴ ኣሾን ዲዛ ታ ጫቆይ ሜርና ጫቆ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ቃጻሬቶንታ ኣቱማሲ ዉሪ ባ ኣሳፔ ሻኬቲዲ ꬋዮ፤ ጋሶይካ ኢዚ ታ ጫቆ ቃላ ናጊቤና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ቃሴካ ጾሲ ኣብራሃሜ፥ «ኔ ማቼይ ሱንꬃ ሶራ ጎፓ፤ ሃይሳፌ ጉዬ ኢዚ ሱንꬂ ሳራ ጌቴቶ። ");
INSERT INTO gmve_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ታኒ ኢዞ ኣንጃና፤ ታኒ ኢዚፔ ኔስ ቱማፔ ኣቱማ ና ኢማና፤ ኢዞ ታኒ ኣንጃና፤ ኢዛ ካዎቴꬃታስ ኣዮ ጊዳና፤ ካዎቲ ኢዚፔ ዬሌታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ኣብራሃሜይ ቢታ ቦላ ጉፋኒዲ ባ ዎዚናን ሚጪሼ፥ «100 ላይꬃ ኣሲ ቱሙ ና ዬላኔ? ቃሴ ኢዚስ ላይꬃይ ኡዱፉን ታሙ ጊዲዳ ሳራይ ቡሮ ና ዬላኔ?» ጊ ቆፒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ኣብራሃሜይ ጾሳስ፥ «ኔ ኢስማኤሌ ታስ ኣንጂዳኮ ኣይ ማላ ሎኦሺን!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ጾሳይካ ኢዛስ፥ «ሃኔና! ኔ ማቼያ ሳራይ ኔስ ኣቱማ ና ቱማፔ ዬላና፤ ኔኒ ኢዛ ዪሳቃ ጋዳ ሱንꬃና፤ ኢዛፔ ጉዬ ኢዛ ዜሬꬃስ ሜርና ጫቆ ጊዳና ማላ ታ ኢዛራ ጫቆ ቃላ ጌላና። ");
INSERT INTO gmve_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ኢስማኤሌስ ጊዲኮ ኔ ኦይቺዳይሳ ታ ሲያዲስ፤ ታኒ ኢዛካ ኣንጃና፤ ታኒ ኢዛ ዳርሳና፤ ኢዛ ዜሬꬃ ኬሃ ዳርሳና፤ ኢዚ ታማኔ ናምኡ ካዎታ ዬላና፤ ታኒ ኢዛ ዜሬꬃ ጊታ ካዎቴꬅ ኬሳና። ");
INSERT INTO gmve_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ጊዶ ኣቲን ታኒ ታ ጫቆ ቃላ ላይꬅ ሃኒ ዎዴ ሳራይ ኔስ ዬላና ናዛ ዪሳቃራ ጫቄታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ጾሲ ኣብራሃሜራ ሃሳይዲ ዉርሲዳፔ ጉዬ፥ ኣብራሃሜፔ ሻኬቲዲ ፑዴ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ሄ ጋላሳንካ ኣብራሃሜይ ባ ና ኢስማኤሌ ባሶን ዬሌቲዳይታ ኡባ፥ ባ ሚሻን ሻሚዳይታ ኡባኔ ባሶን ዲዛ ኣቱማስ ኡባ፥ ጾሲ ኢዛስ ዮቲዳ ማላ ቃጻሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ኣብራሃሜይ ቃጻሬቲሺን ኢዛስ ላይꬃይ ኡዱፉን ታማኔ ኡዱፑና። ");
INSERT INTO gmve_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ኢዛ ና ኢስማኤሌይ ቃጻሬቲሺን ኢዛስ ላይꬃይ ታማኔ ሄꬓ። ");
INSERT INTO gmve_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ኣብራሃሜይኔ ኢዛ ና ኢስማኤሌይ ናምኣቲካ ኢሲ ጋላስ ቃጻሬቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ኣብራሃሜሶን ዲዛ ኣቱማሳይ ዉሪ ኢዛ ሶን ዬሌቲዳይቲኔ ሚሻን ሻሜቲዳይቲ ዉሪካ ኢዛራ ቃጻሬቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ሴታ ጋላስ ኣብራሃሜይ ማሚሬን ዲዛ ጊታ ሚꬃታ ጋርሳን ባ ዱንካኔ ፔንጌን ኡቲ ዲሺን ጎዳይ ኢዛስ ቆንጪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ኣብራሃሜይ ꬎቁ ጊ ጼሊዲ ሄꬑ ኣሳቲ ኤቂዳይታ ቤኢዲ ኢስታ ሞኪ ኤካናስ ባ ዱንካኔዛ ፔንጌፌ ዴንዲዲ ዎጺ ቢዴስ፤ ሄ ጋኪ ቢታን ሆኪዲ ኢስታ ሲንꬃን ዚጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ዚጊ ሲሚዲ፥ «ኣቤት ታ ጎዶ! ኔ ታና ኔ ኣይሌዛ ቦንቺዛ ጊዲኮ ታሶ ጌሎንታ ኣꬋ ቦፓ። ");
INSERT INTO gmve_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ሃኢ ኢንቴ ቶሆ ሜጫና ቶሆ ሃꬂ ዪኮ ኢንቴ ቶሆ ሜጬቲዲ ሃይሳ ሚꬃ ኩዋን ሼምፒ ኤኪቴ። ");
INSERT INTO gmve_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ኢንቴ ሃኢ ታኮ ኢንቴ ኣይሌዛኮ ዪዳ ጊሻስ ሼምፒ ኤኪዲ ኢንቴ ቢዛሶ ባና ማላ ታኒ ኢንቴስ ሚዛ ሚሽ ኣኔ ኤሃይስ» ጊዴስ። ኢስቲ፥ «ዳሮ ሎኦ፤ ኔኒ ጊዛ ማላ ኦꬃ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ኣብራሃሜይ ዱንካኔዛ ጊዶ ሳራኮ ኤሶቲ ቢዲ፥ «ኤሶታዳ ሊቆ ꬊሌዛፔ ሄꬑ ኬሬ ጊዲዛይሳ ኤካ ሙኑቃዳ ኡኬꬅ ኡካ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ቃሴ ኣብራሃሜይ ባ ዉዴዛኮ ዎጺ ቢዲ ሎኦ ኣንቃራ ማር ዶሪዲ ኢሲ ኣይሌስ ኢሚን ኢዚ ኤሶን ሹኪዲ ጊግሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ሂስቲን ኣብራሃሜይ ሜቆ ማꬂኔ ጊግሲዳ ማራ ኣሾዛ ኢማꬃታ ሲንꬅ ኣꬂዴስ፤ ኢስቲ ሚሺን ኢዚ ሄ ሚꬃ ጋርሳን ኢስታ ኣቻን ኤቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ኢስቲ ኢዛ፥ «ኔ ማቼያ ሳራይ ኣዋኔ?» ጊ ኦይቺን ኢዚ፥ «ሄኒን ዱንካኔ ጊዶን ዳዉስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ጎዳይ ኢዛስ፥ «ታኒ ዪዛ ላይꬅ ሃኒ ዎዴ ቱሙ ኔኮ ሲማና፤ ሄ ዎዴ ኔ ማቺያ ሳራይ ኣቱማ ና ኔስ ዬላና» ጊዴስ። ሳራይካ ኢዛፔ ጉዬ ባጋራ ዱንካኔዛ ሲንꬃን ዳሼ ሄሳ ሲያዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ኣብራሃሜይኔ ሳራይ ኬሂ ጪሚዳ፤ ሳራስካ ማጫሳታስ ዪዛ ዎጋይ ኣጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ሄሳ ጊሻስ ሳራይ ባ ዎዚናን፥ «ታኒ ሃኢ ጪሚዳፔ ጉዬ፥ ታ ኣዚናይካ ጪሚዳፔ ጉዬ ሃይሲ ኡፋይሳይ ታስ ሃናኔ?» ጋዳ ሚጫዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ሄ ዎዴ ጎዳይ ኣብራሃሜ፥ « ‹ታኒ ጪማይቺዳፔ ጉዬ ቱሙ ና ዬላኔ?› ጋዳ ሳራይ ኣዛስ ሚጫዴ? ");
INSERT INTO gmve_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","ጎዳስ ዳንዳዬቶንታ ሚሺ ቱሙ ዲዜ? ታ ጊዳ ማላ ዪዛ ላይꬅ ሃኒ ዎዴ ታ ኔኮ ያና፤ ሄ ዎዴ ሳራይ ኣቱማ ና ዬላና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ሳራይ ኬሃ ባቢዳ ጊሻስ፥ «ታኒ ሚጫቤኬ» ጋዳ ላሆታዱስ። ጊዶ ኣቲን ኢዚ፥ «ኤ፥ ኔኒ ቱማ ሚጫዳሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ሄሳፌ ጉዬ ኣሳቲ ባና ዴንዲሼ ሶዶሜ ካታማ ዱጌ ዛሪ ጼሊዳ፤ ኣብራሃሜይካ ኢስታ ሞይዚሼ ኢስታራ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ሄ ዎዴ ጎዳይ፥ «ታኒ ታ ኦꬃና ጊዛይሳ ኣብራሃሜፔ ቆታኔ? ");
INSERT INTO gmve_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ኣብራሃሜይ ቱማፔ ጊታኔ ዎልቃማ ካዎቴꬅ ጊዳና፤ ሃ ቢታ ኣሲ ዉሪ ኢዛ ባጋራ ኣንጄታና። ");
INSERT INTO gmve_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","ጺሎቴꬂኔ ሱሬ ኦሶ ኦꬂዲ ጎዳ ኦጌ ናጋና ማላ ባ ናይታኔ ባፔ ጉዬ ባ ሶ ኣሳ ኢዚ ዞራና ማላ ታኒ ኢዛ ዶራዲስ፤ ሄሲካ ጎዳይ ኣብራሃሜስ ኢማና ጊዳይሳ ኡባ ፖላናሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","21","ጎዳይ ኣብራሃሜ፥ «ሶዶሜኔ ጋሞራ ዋሶይ ኬሂ ዳሪዳ ጊሻሲኔ ኢስታ ናጋራይ ኬሂ ዴጺዳ ጊሻስ ኢስቲ ኦꬂዳይሲ ታኮ ጋኪዳ ዋሶ ማላ ኢታኮኔ ኢታ ጊዶንታኮ ኣኔ ታኒ ዱጌ ዎꬋ ቤያይስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ሄሳፌ ጉዬ ናምኡ ኣሳቲ ሶዶሜ ሲሚ ቢዳ፤ ጊዶ ኣቲን ኣብራሃሜይ ጎዳ ሲንꬃን ኤቂዳ ማላ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ሄ ዎዴ ኣብራሃሜይ ኢዛኮ ሺቂዲ፥ «ቱሙ ኔኒ ጺሎታ ኢታታራ ጋꬃ ꬋይሳኔ? ");
INSERT INTO gmve_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ሄ ጊታ ካታማን 50 ጺሎቲ ዲኮ ኔኒ ኢስታ ꬋይሳኔ? ኔኒ ኢዛን ዲዛ 50 ጺሎታ ጊሻስ ሄ ካታማ ማርኪ? ");
INSERT INTO gmve_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ጺሎታ ዎርዶታራ ጋꬃ ዎꬊዛይሲኔ ጺሎታኔ ዎርዶታ ኢሲ ኣይፌን ጼሊዛይሲ ሄሲ ኔፔ ሃኮ፤ ሃ ቢታ ኡባ ቦላ ፒርዲዛ ኔኒ ጺሎ ፒርዲኪ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ጎዳይካ፥ «ሄ ሶዶሜ ካታማን 50 ጺሎቲ ዲኮ ሄ ካታማ ኡባ ኢስታ ጊሻስ ታኒ ኡባ ማራና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ሄሳፌ ጉዬ ኣብራሃሜይ፥ «ታኒ ቢታኔ ቢዲንꬃኮሺን ታ ጎዳራ ጻላዳ ሃሳያ ኦይካዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ኢቻሹ ታሙ ጺሎታፔ ኢቻሻቲ ፓጪኮ ኔኒ ሄ ፓጪዳ ኢቻሻታ ጊሻስ ሄ ካታማ ኡባ ꬋይሳኔ?» ጊዴስ። ጎዳይካ፥ «ታኒ ሄን ኦይዱ ታማኔ ኢቻሽ ጺሎታ ዴሚኮ ሄ ካታማ ꬋይሲኬ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ኣብራሃሜይ ዛሬꬂዲካ፥ «ሄን 40 ጺሎቲ ጻላ ቤቲኮቺ?» ጊዴስ። ኢዚካ፥ «ታኒ ሄ ኦይዱ ታማታ ጊሻስ ሄ ካታማ ꬋይሲኬ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ሄሳፌ ጉዬ ኢዚ፥ «ታ ጎዶ! ኔ ታ ቦላ ሃንቄቶፋ፤ ታኒ ጉጃዳካ ኦይቻይስ፤ ሄን 30 ጺሎቲ ጻላ ቤቲኮቺ?» ጊዴስ። ጎዳይ፥ «ታኒ ሄን 30 ጺሎ ኣስ ዴሚኮ ሄ ካታማ ꬋይሲኬ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ቃሴካ ኣብራሃሜይ፥ «ታኒ ጎዳራ ጻላቴꬃን ሃሳያ ዶማዲስ፤ ሄን 20 ጺሎቲ ጻላ ቤቲኮቺ?» ጊዴስ። ጎዳይ፥ «ሄ ናምኡ ታማታ ጊሻስ ꬋይሲኬ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ሄሳፌ ጉዬ ኣብራሃሜይ፥ «ታ ጎዶ! ኔ ታ ቦላ ሃንቄቶፋ፤ ታኒ ሜጺ ኢሲቶ ሃሳያይስ፤ ሄን 10 ጺሎይ ቤቲኮቺ?» ጊዴስ። ጎዳይ፥ «ሄ ታማታ ጊሻስ ታኒ ሄ ካታማ ꬋይሲኬ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ጎዳይ ኣብራሃሜራ ሃሳያ ዉርሲዳፔ ጉዬ ቢዴስ፤ ኣብራሃሜይካ ባሶ ሲሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ሄ ናምኡ ኪታንቻቲ ኦማርስ ሶዶሜ ካታማ ጋኪዛ ዎዴ ሎጼይ ሄ ካታማ ፔንጌን ኡቲዴስ። ሎጼይ ኢስታ ቤኢዲ ኢስታራ ጋጋናስ ዴንዲ ቢዲ ባ ሁኤ ዱጌ ቢታ ጋꬂ ዚጊዲ፥ ");
INSERT INTO gmve_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","«ታ ጎዳቶ! ኢንቴ ኣይሌ ታሶ ሃ ዬርኬቲ፤ ኢንቴ ቶሆ ሜጬቲ ኣቂዲ ዎንቶ ማላዶራ ዴንዲዲ ኢንቴ ቢዛሶ ቤታ» ጊዴስ። ኢስቲካ፥ «ኣካይ ቦኮ፤ ኑኒ ሃይሳ ካታማ ዱቡሻን ኣቃና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ጊዶ ኣቲን ኢዚ ኢስታ ኬሂ ሾቢዳ ጊሻስ ኢዛራ ቢዲ ኢዛ ሶ ጌሊዳ፤ ኢዚካ ኢስታስ ኡኬꬅ ኡኪዲ ካዎ ኣꬂን ኢስቲ ሚዳ። ");
INSERT INTO gmve_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ኢስቲ ኢቾንታ ዲሺን ሶዶሜ ካታማ ኣቱማሳይ ዉሪ ናይታፔ ጪማ ጋካናስ ኢሳዴይካ ኣቶንታ ዪዲ ኬꬃ ዩዪ ኣꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ኢስቲካ ሎጼ ጼይጊዲ፥ «ሃች ኦማርስ ኔሶ ዪዳ ኣሳቲ ኣዋን ዲዞ? ኑኒ ኢስታራ ኣቃና ማላ ኢስታ ኑኮ ካሬ ኬሳ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ሎጼይ ኢስታራ ጋጋናስ ካሬ ኬዚዲ ሶሆን ዲዛ ኣሳታ ቦላ ካሬዛ ጉዬ ዛሪ ጎርዲዲ፥ ");
INSERT INTO gmve_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ኢስታስ፥ «ታ ኢሻቶ! ሃይሳ ኢታ ኦሶ ኦꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ታስ ኣዴ ጌሎንታ ናምኡ ጌላኦ ማጫ ናይቲ ዴቴስ፤ ታኒ ኢስታ ኢንቴስ ካሬ ኬሲኮ ኢንቴ ኢስታ ኢንቴና ሎኢዳ ማላ ኦꬃና ዳንዳዬታ፤ ጊዶ ኣቲን ሃይታ ኣሳታ ቦላ ኣይኮካ ኦꬆፍቴ፤ ኣይስ ጊኮ ኢስቲ ታ ኬꬅ ጌሊዲ ታ ኢማꬅ ጊዲዳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ኣሳቲ ኢዛ፥ «ኑ ሲንꬃፌ ኪቻ!»፤ ቃሴካ፥ «ሃይሲ ኣዴዚ ሃ ቢታን ቤቴ ኣስ ጊዲ ኡቲዲ ሃኢ ኑ ቦላ ፒርዳናስ ካጃሌስ፤ ሃኢ ኑኒ ኢስታ ቦላ ኦꬃና ቆፒዳ ኢታፔ ኣꬊዳ ኢታ ኔ ቦላ ኦꬃና» ጊዳ። ሎጼካ ጉዬ ሱጊ ዬጊዲ ፔንጌዛ ሜንꬃናስ ማቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ጊዶ ኣቲን ሄ ናምኡ ኣሳቲ ባ ኩሼ ካሬ ዬዲዲ ሎጼ ሶ ጎቺ ጌልꬂዲ ካሬዛ ዛሪ ጎርዲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ሄሳፌ ጉዬ ኢስቲ ኬꬃ ፔንጌን ዲዛ ኣሳ ጉꬃፌ ጊታ ጋካናስ ቆቂሲን ኢስቲ ፔንጌዛ ዴማናስ ኮዪሼ ዳቡርዳ። ");
INSERT INTO gmve_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ሄ ናምኡ ኣሳቲ ሎጼ፥ «ኔስ ሃይሳ ካታማ ጋርሳን ዲዛ ኣቱማ ና ዎይኮ ማጫ ና ጊዲን ኔ ናይታ ኤካናስ ጊግሲዳይቲካ ዲኮ ዎይኮ ሃራ ዳቦይ ዲኮ ኢስታ ሃይሳፌ ኬሳ። ");
INSERT INTO gmve_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ኣይስ ጊኮ ኑኒ ሃይሳ ካታማ ꬋይሳና ጎስ፤ ሃ ዴራ ናጋራይ ኬሂ ዳሮ ጊዲዳይሳ ጎዳይ ቤኢዳ ጊሻስ ሃይሳ ካታማ ꬋይሳናስ ኑና ኪቲዴስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ሄሳ ጊሻስ ሎጼይ ባ ማጫ ናይታ ኤካናስ ጊግሲዳይታኮ ቢዲ ኢስታስ፥ «ጎዳይ ሃ ካታማ ꬋይሳና ጊዛ ጊሻስ ኤሌሊ ዴንዲዲ ሃይሳፌ ኬዚ ኪቺቴ» ጊዴስ፤ ጊዶ ኣቲን ኢዛ ማጫ ናይታ ጊግሲዳይቲ ኢዚ ቂꬌ ጌስ ጊ ቆፒዳ። ");
INSERT INTO gmve_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ጋዴይ ዎንታና ጊሺን ሄ ኪታንቻቲ ሎጼ፥ «ዴንዳ! ኔ ማቺዮኔ ሃይሳን ዲዛ ኔ ናምኡ ማጫ ናይታ ኤካዳ ኤሶን ኬዛ! ኬዞንታ ኢጺኮ፥ ሃና ካታማያ ፒርዴቲዛ ዎዴ ኔኒካ ꬋያና» ጊዲ ኤሶሲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ጊዶ ኣቲን ሎጼይ ሺኒን ጎዳይ ኢስታስ ቃꬌቲዳ ጊሻስ ኪታንቻቲ ኢዛ ኩሼ፥ ኢዛ ማቼይ ኩሼኔ ማጫ ናይታ ናምኣታ ኩሼ ኦይኪዲ ሄ ካታማፔ ኢስታ ኬሲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ኪታንቻቲ ኢስታ ካታማፔ ኬሲዳ ማላካ ኪታንቻታፔ ኢሳይ፥ «ኢንቴ ሼምፖ ኤኪዲ ባቃቲቴ! ጉዬ ጼሎፍቴ! ቃሴ ሃይሳ ሾባን ኣዋንካ ኤቆፍቴ! ዙማኮ ዎጺቴ! ሂስቶንታ ኢጺኮ ኢንቴ ꬋያና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ጊዶ ኣቲን ሎጼይ ኢስታስ፥ «ታ ጎዳቶ! ሄሳꬆ ጊዶፖ! ");
INSERT INTO gmve_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ታኒ ኢንቴ ኣይሌይ ኢንቴ ሲንꬃን ሳቤቲዳ ጊሻስ ታና ኣሻናስ ታስ ዳሮ ቃꬌቲዴታ፤ ጊዲኮካ ሃይሲ ባሻይ ታና ጋኪዲ ꬋይሲኮ ሃይቃና ጊሻስ ታኒ ፑዴ ዙማኮ ባቃታናስ ዳንዳይኬ። ");
INSERT INTO gmve_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ቤኢቴ! ባቃቲ ቢዲ ኣታናስ ማታን ኢሲ ጉꬃ ካታማይ ዳዉስ፤ ታ ሼምፖ ኣሻናስ ሄ ባቃቶ? ኢዛ ቄሪ ካታማ ዴኬ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ጊዶ ኣቲን ኪታንቻይ፥ «ኤ ጊዶ! ታኒ ኔ ዎሳ ሲያዲስ፤ ታኒ ኔኒ ጊዛ ካታማዮ ꬋይሲኬ። ");
INSERT INTO gmve_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ሄሳ ጊሻስ ጌዴ ኤሶን ባቃታ፤ ኔኒ ጌዴ ጋካናስ ታኒ ኣይኮካ ኦꬃናስ ዳንዳይኬ» ጊዴስ፤ ሂስቲን ሄ ካታማይ ሱንꬂ ዞኣሬ ጌቴቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ሎጼይ ዞኣሬ ጋኪሺን ቡሮ ጻልቄይ ጫሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ሄ ዎዴ ጎዳይ ታማኔ ጹጊዛ ዲኔ ሶዶሜ ቦላኔ ጋሞራ ቦላ ሳሎፔ ቡኪሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ሄሳꬆ ኦꬂዲ ጎዳይ ሄ ዙሌን ዲዛ ካታማታኔ ዙሌን ዲዛዝ ኡባ ሄ ካታማታ ጊዶን ዲዛ ኣሳ ኡባኔ ሄ ቢታን ዲዛ ሚꬂኔ ማታ ኡባ ጹጊ ꬋይሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ጊዶ ኣቲን ሎጼ ማቺያ ጉዬ ጼላዳ ማጺኔ ሹች ጊዳዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ዎንቴꬃ ጋላስ ኣብራሃሜይ ማላዶ ዎንታራ ዴንዲዲ ጎዳ ሲንꬃን ካሴ ኢዚ ኤቂዳሶ ሲሚ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ኢዚ ሶዶሜኔ ጋሞራ ሄ ሾባን ዲዛ ቢታ ኡባ ዱጌ ጼሊዛ ዎዴ ዎልቃማ ጩዋይ ጹሳ ታማ ማላ ሄ ቢታፌ ቱሉ ጊዛይሳ ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ጾሲ ሄ ሾባን ዲዛ ካታማታ ꬋይሲዳ ዎዴ፥ ኣብራሃሜ ቆፒዲ ሎጼይ ካሴ ዲዛ ካታማታ ꬋይሲዳ ዎዴ ሎጼ ꬋይሳፌ ኣሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ሎጼይ ዞኣሬን ዴኣናስ ባቢዳ ጊሻስ ባ ማጫ ናይታ ናምኣታራ ዙማ ቦላ ኬዚዲ ጎንጎሎ ጊዶን ዴኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ኢሲ ጋላስ ባይራ ናያ ካሎዮ፥ «ኑ ኣዋይ ጪሚዴስ፤ ቢታ ቦላ ዲዛ ዎጋ ማላ ኑናራ ዚንኣናስ ሃይሳ ቢታን ሙሌካ ኣቱማይ ዴና። ");
INSERT INTO gmve_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","ሄሳ ጊሻስ ሃ ያ፤ ዎይኔ ኡሹ ኑ ኣዋ ኡሺ ማꬆሶስ፤ ሂስቲዲ ኢዛራ ኣቂዲ ኣኔ ኑ ኣዋፔ ኑስ ዜሬꬅ ኤሶስ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ሄ ጋላሳ ኦማርሲካ ባ ኣዋ ዎይኔ ኡሹ ኡሺዳፔ ጉዬ ባይራያ ጌላዳ ኢዛራ ዚንኣዱስ፤ ኢዛ ኢዛራ ዚንኢዛ ዎዴካ ዴንዲዛ ዎዴካ ኢዚ ኤሪቤና። ");
INSERT INTO gmve_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ዎንቴꬃ ጋላስ ባይራያ ካሎዮ፥ «ሲያ! ቃማ ታኒ ኑ ኣዋራ ኣቃዲስ፤ ሃች ኦማርስ ቃሴ ዎይኔ ኡሹ ኡሺኮ ኔኒ ጌላዳ ኢዛራ ኣቃ፤ ሂስቲዲ ኑኒ ኑ ኣዋፔ ኑስ ዜሬꬅ ኤሶስ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ሄ ጋላስ ቃማ ቃሴካ ዎይኔ ኡሹ ኢዛ ኡሺዳፔ ጉዬ ካሎያ ጌላዳ ኢዛራ ኣቃዱስ፤ ኢዛ ኢዛራ ኣቃዳ ዴንዳ ቢዛ ዎዴ ኢዚ ኤሪቤና። ");
INSERT INTO gmve_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ሂስቲዲ ሎጼ ማጫ ናይቲ ናምኣቲካ ባ ኣዋስ ቃንꬃቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","ባይራያ ኣቱማ ና ዬላዱስ፤ ሱንꬃካ ሞኣቤ ጋዳ ሱንꬃዱስ፤ ኢዚካ ሃች ጋካናስ ሞኣቤታስ ኣዋ። ");
INSERT INTO gmve_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ቃሴ ካሎያካ ኣቱማ ና ዬላዱስ፤ ሱንꬃካ ቤኒ-ኣሜ ጋዳ ሱንꬃዱስ፤ ኢዚካ ሃች ጋካናስ ኣሞኔታስ ኣዋ። ");
INSERT INTO gmve_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ኣብራሃሜይ ማሚሬፔ ዴንዲዲ ኔጌቤ ጌቴቲዛ ቢታ ቢዲ ቃዴሴኔ ሹራ ጌቴቲዛ ካታማታፔ ጊዶን ዴኢዴስ፤ ጌራሬ ቢታን ጉꬃ ዎዴ ጋምኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ሄን ኣብራሃሜይ ባ ማቺዮ ሳራ፥ «ኢዛ ታስ ሚቾ» ጊን ጌራሬ ካዎ ኣቢሜሌኬይ ኪቲዲ ሳራ ባሶ ኤፊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ጊዶ ኣቲን ጾሲ ኢሲ ጋላሳ ኦማርስ ኣጉሞን ኣቢሜሌኬኮ ዪዲ፥ «ኔኒ ኤሂዳ ማጫሳይ ጌዶን ኔ ሃይቃና፤ ኢዛ ኣሳ ማቾ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ጊዶ ኣቲን ኣቢሜሌኬይ ኢዚራ ኣቂቤና፤ ሄሳ ጊሻስ፥ «ታ ጎዶ! ኔኒ፥ ታኒ፥ ታ ካዎቴꬃይካ ኔና ቆሆንታ ዲሺን ኑና ጮ ꬋይሳኔ? ");
INSERT INTO gmve_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","ኢዚ፥ ‹ኢዛ ታ ሚቾ› ጊቤኔ? ቃሴ ኢዛ፥ ‹ኢዚ ታ ኢሻ› ጋቤኬ? ታኒ ሃይሳ ቱሙ ዎዚናፔ ኦꬃዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ሄሳፌ ጉዬ ጾሲ ኣጉሞን ኢዛስ፥ «ኤ፥ ኔኒ ኔ ዎዚና ጌሻቴꬃን ኦꬂዳይሳ ታኒ ኤራዳ ኔኒ ኢዞ ቦቾንታ ማላኔ ታ ሲንꬃን ናጋራ ኦꬆንታ ማላ ኔና ታኒ ቴቃዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ሃኢ ሃኖ ማጫሳዮ ኢዚ ኣዚናስ ዛራ፤ ጋሶይካ ኢዚ ናቤ ጊዲዳ ጊሻስ ኢዚ ኔስ ጾሳ ዎሲኮ ኔኒ ፓጻና፤ ጊዶ ኣቲን ኔ ኢዞ ዛሮንታ ኢጺኮ ኔኒኔ ኔስ ዲዛዚ ዉሪ ሃይቃናይሳ ቱማፔ ኔ ኤራ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","ኣቢሜሌኬይ ዎንቴꬃ ጋላስ ማላዶ ባ ካዎቴꬃን ዲዛ ሹሜታ ኡባ ጼይጊዲ ሃ ዮኦዛ ኡባ ኢስታስ ዮቲን ኢስቲ ኬሂ ባቢዳ። ");
INSERT INTO gmve_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ሂስቲን ኣቢሜሌኬይ ኣብራሃሜ ጼይጊዲ፥ «ኔኒ ኑ ቦላ ኣይ ኦꬃዲ? ኔኒ ታ ቦላኔ ታ ካዎቴꬃ ቦላ ሃይሳ ማላ ቆሆ ኤሃናስ ታኒ ኔስ ኣይ ኢታ ሚሽ ኦꬃዲና? ኔኒ ታ ቦላ ኦሴታናስ ቤሶንታ ኢታ ኦꬃዳሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ቃሴካ ኣቢሜሌኬይ ኣብራሃሜ፥ «ኔና ሃይሳ ኦሲሲዳይ ኣዜ?» ጊ ኦይቺን፥ ");
INSERT INTO gmve_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ኣብራሃሜይ፥ « ‹ጾሳስ ባቢዛ ኢሲ ኣሲካ ሃ ዴሬን ባዋ፤ ቃሴካ ታ ማቼይ ጌዶን ኢስቲ ታና ዎꬋና› ጋዳ ቆፒዳ ጊሻሳ። ");
INSERT INTO gmve_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ኢዛካ ታ ኣዋ ና ጊዲዳ ጊሻስ ታስ ሚቾ፤ ታስ ኣዪ ና ጊዶንታ ጊሻስ ታ ኢዞ ማቾ ኤካዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ጾሲ ታና ታ ኣዋ ኬꬃፌ ኬሲዳ ዎዴ ታኒ ኢዚስ ኑኒ ቢዳ ቢታን ኡባን ኔኒ ታስ ኦꬃና ኪያቴꬂ፥ ‹ኢዚ ታስ ኢሻ› ጋዳ ዮታ ጋዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ሄሳፌ ጉዬ ኣቢሜሌኬይ ዶርስ፥ ሚዝ፥ ማጫ ኣይሌታኔ ኣቱማ ኣይሌታ ኤሂዲ ኣብራሃሜስ ኢሚዴስ፤ ቃሴ ኢዛ ማቺዮ ሳራካ ኢዛስ ዛሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","ኣቢሜሌኬይ፥ «ሄኮ ታ ቢታይ ኔ ሲንꬃን ዴስ፤ ኔና ሎኢዛሶን ዳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ሳራስካ፥ «ታኒ ኔ ኢሻስ ኢሲ ሺ ሳቂሌ ቢራ ኢማዲስ፤ ሃይሲ ሄኮ ኔናራ ዲዛይታ ኡባ ሲንꬃን ኔኒ ጺሎ ጊዲዳይሳ ኤሪሳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","ጎዳይ ኣብራሃሜ ማቼዮ ሳራ ጌዶን ኣቢሜሌኬ ኬꬃ ኣሳ ኡባ ዬሊዛ ኡሎ ማካርሲዳ ጊሻስ ኣብራሃሜይ ጾሳ ዎሲን ኣቢሜሌኬይ ኢዛ ማቼያኔ ኢዛ ማጫ ኣይሌቲ ና ዬላና ማላ ጾሲ ኢስታ ፓꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ጎዳይ ሳራ ቆፒዴስ፤ ካሴ ኢዚስ ዮቲዳ ማላካ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ሳራይ ሻራዳ ጪማቴꬃን ኣብራሃሜስ ጾሲ ጊዳ ዎዴይ ጋኪን ኣቱማ ና ዬላዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ሳራይ ኢዛስ ዬሊዳ ናዛ ሱንꬃ ኣብራሃሜይ፥ «ዪሳቃ» ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ኣብራሃሜይ ናዛ ዪሳቃ ጾሲ ባና ኣዛዚዳ ማላ ዬሌቲዳፔ ኦስፑንꬃ ጋላስ ቃጻሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ኢዛ ና ዪሳቂ ኢዛስ ዬሌቲዳ ዎዴ ኣብራሃሜስ ላይꬃይ ጼታ። ");
INSERT INTO gmve_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ሳራይ፥ «ጾሲ ታና ሚቺዴስ፤ ቃሴ ሃይሳ ሲዪዛይ ዉሪ ታናራ ሚጫና» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ቃሴካ ሳራይ፥ «ኣብራሃሜስ ሳራይ ና ዬላናኔ ꬋንꬃና ጊዲ ቆፒዳይ ኦኔ? ጊዲኮካ ታኒ ሃኢ ኢዛስ ኢዚ ጪሚዳ ዎዴን ና ዬላዲስ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ጉꬃ ናዚ ዲጪዲ ꬋንꬅ ዱጺዴስ፤ ዪሳቂ ꬋንꬃፌ ዱጺዳ ጋላስ ኣብራሃሜይ ጊታ ዲጊሳ ዲጊሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ጊብጼፔ ዪዳ ኣጋራ ኣብራሃሜስ ዬሊዳ ናዚ ኢስማኤሌይ ዪሳቃ ሌቂዛይሳ ሳራይ ቤኣዳ፥ ");
INSERT INTO gmve_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ኣብራሃሜ፥ «ሃኖ ኣይሌይ ናዚ ታ ና ዪሳቃራ ሙሌካ ላቶንታ ጊሻስ ኣይሌዮኔ ኢዚ ናዛ ኬሳ ጎዳ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ሃ ዮኦዚ ባ ናዛ ቦቺዛ ጊሻስ ኣብራሃሜይ ዳሮፔ ሜቶቴቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ጊዶ ኣቲን ጾሲ ኣብራሃሜ፥ «ኔ ዜሬꬃይ ዪሳቃ ባጋራ ጼይጌታናይሳ ጊሻስ ኣይሌይ ጊሻሲኔ ኢዚ ናዛ ጊሻስ ዳሮ ሜቶቶፓ፤ ሳራይ ኔስ ዮቲዛይሳ ኡባ ሲያ። ");
INSERT INTO gmve_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ቃሴ ታኒ ኢዚ ኔ ዜሬꬅ ጊዲዳ ጊሻስ ኣይሌይ ናዛ ካዎቴꬅ ሂስታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ኣብራሃሜይ ማላዶ ዎንታራ ዴንዲዲ ጉꬃ ካꬂኔ ኮዳን ሃꬅ ኤኪዲ ኣጋሮ ሃሼን ቶሲዲ ኢዚ ናዛካ ኢዚስ ኢሚዲ ኬሲ ዬዲዴስ፤ ኢዛ ባዳ ቤርሳቤሄ ጌቴቲዛ ባዞን ቶይላታዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","16","ሃꬃይካ ኮዳፌ ዉሪን ኢዛ፥ «ታ ናዚ ሃይቂሺን ኡታዳ ታ ኢዛ ቤኢኬ» ጋዳ ናዛ ቡራ ጋርሳን ዎꬃዳ 200 ዋꬋ ጊዲዛሶ ማላ ባዳ ሄን ኡታዱስ፤ ሄንካ ኢዛኮ ሲማ ኡታዳ ባ ቃላ ꬎቁ ሂስታ ዬካዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ጾሲ ናዛ ዋሶ ሲዪዴስ፤ ሳሎፔ ጾሳ ኪታንቻይ ኣጋሮ ጼይጊዲ፥ «ኣጋሬ! ዋናዲ? ጾሲ ናዚ ኢቺዳሶን ዬኪዛይሳ ሲዪዳ ጊሻስ ባቦፋ፤ ");
INSERT INTO gmve_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ዴንዳ ኤቃ፤ ናዛ ዴንꬃዳ ኔ ኩሼን ኦይካ፤ ታኒ ኢዛ ጊታ ካዎቴꬅ ሂስታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ጾሲ ኢዚስ ሃꬃ ኦላ ቤሲን ባዳ ኮዳን ሃꬅ ኩንꬃዱስ፤ ናዛካ ኡሻዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ጾሲ ናዛራ ዴስ፤ ናዚካ ዲጪዲ ባዞ ቢታን ዎንዳፌ ዱኪዛ ኣስ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ኢዚ ፓራኔ ባዞን ዴኢሺን ኢዛ ኣያ ኢዛስ ማቾ ጊብጼፔ ኤካዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ሄ ዎዴ ኣቢሜሌኬይ ባ ዎታዳራታ ሃላቃ ፒኮሌራ ኣብራሃሜኮ ቢዲ፥ «ኔኒ ኦꬂዛ ኡባን ጾሲ ኔናራ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ኔኒ ታ ቦላ ዎይኮ ታ ናይታ ቦላ ዎይኮ ታ ዜሬꬃ ቦላ ባሌꬆን ጌኔ ኦꬆንታ ማላ ሃኢ ሃይሳን ጾሳ ሲንꬃን ታስ ጫቃ፤ ታኒ ኔስ ኔ ኪዪዳይሳꬆ ኔኒካ ታሲኔ ኔኒ ኢማꬃቴꬃን ዲዛ ሃይሳ ቢታዛስ ሎኦ ኦꬃ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ኣብራሃሜይ፥ «ታኒ ጫቃይስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ሄ ዎዴ ኣብራሃሜይ ኣቢሜሌኬ ኣይሌቲ ኤኪዳ ሃꬃ ኦላ ጊሻስ ኣቢሜሌኬስ ማጋኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ጊዶ ኣቲን ኣቢሜሌኬይ፥ «ሄሳ ኦኒ ኦꬂዳኮ ታኒ ኤሪኬ፤ ኔኒካ ቃሴ ታስ ዮታቤካ፤ ታኒ ሃች ጋካናስ ሄሳ ሲያቤኬ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ሄሳፌ ጉዬ ኣብራሃሜይ ዶርሳታኔ ሚዛታ ኤሂዲ ኣቢሜሌኬስ ኢሚን ኢስቲ ናምኣይ ጫቄቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ኣብራሃሜይ ሜሄታ ጊዶፌ ላፑን ኡዚ ዶርሳታ ሻኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ኣቢሜሌኬይ ኣብራሃሜ፥ «ሃ ኔኒ ሻኪዳ ላፑን ኡዞታ ኣይስ ሻካዲ?» ጊ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ኣብራሃሜይ፥ «ታኒ ሃይሳ ሃꬃ ኦላ ቦኪዳይሳስ ማርካ ጊዳና ማላ ሃይታ ላፑን ኡዞታ ታፔ ኤካ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ሄን ሄ ናምኡ ኣሳቲ ጫቄቲዳ ጊሻስ ሄ ሶሆይ ቤርሳቤሄ ጌቴቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ቤርሳቤሄን ጫቆ ጫቄቲዳይሳፌ ጉዬ ኣቢሜሌኬይኔ ኢዛ ዎታዳራታ ሃላቃ ፒኮሌይ ዴንዲዲ ፊሊስጼሜ ቢታ ሲሚዳ። ");
INSERT INTO gmve_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ኣብራሃሜይ ቤርሳቤሄን ታማርሲኬ ጌቴቲዛ ሚꬅ ቶኪዲ ሄን ጎዳ ሜርና ጾሳ ጼይጊዲ ጎይኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ኣብራሃሜይ ፊሊስጼሜ ቢታን ዳሮ ዎዴ ኢማꬃቴꬃን ዴኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ሄሳፌ ጉዬ ጾሲ ኣብራሃሜ ፓጪዴስ፤ ጾሲ፥ «ኣብራሃሜ!» ጊ ጼይጊን ኣብራሃሜይ፥ «ዬ!» ጊ ኮዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","ጾሲ፥ «ኔኒ ሲቂዛ ኔ ሜጺ ኢሲ ናዛ ዪሳቃ ኤካዳ ሞሪያ ጌቴቲዛ ቢታ ባ፤ ባዳ ሄን ታኒ ኔስ ቤሲዛ ኢሲ ዙማ ቦላን ኢዛ ጹጌቲዛ ያርሾ ኦꬃዳ ታስ ያርሻ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ዎንቴꬃ ጋላስ ኣብራሃሜይ ማላዶ ዎንታራ ዴንዲዲ ሃሬ ጫኒዴስ፤ ባ ኣይሌታፔ ናምኣታኔ ባ ና ዪሳቃ ባናራ ኤኪዲ ጹጊዛ ያርሾስ ጊዲዛ ሚꬅ ቄሪ ኤኪዲ ጾሲ ኢዛስ ዮቲዳሶ ባናስ ዴንዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ቢሼ ሄꬓንꬃ ጋላስ ኣብራሃሜይ ꬎቁ ጊዲ ያርሾ ያርሻናሶዛ ሃሆን ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","ኣብራሃሜይ ባ ኣይሌታ፥ «ኢንቴ ሃሬዛራ ሃይሳን ዲሺቴ፤ ታኒኔ ታ ናዚ ጌዴ ቢዲ ጾሳስ ጎይኒዲ ኢንቴኮ ሃ ሲማና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ኣብራሃሜይ ያርሾ ሚꬃ ዴንꬂዲ ናዛ ዪሳቃ ቶሲዲ ባስ ታማኔ ሹካ ማሻ ኦይኪዴስ፤ ኢስቲ ናምኣይ ኢሲፌ ቢሺን፥ ");
INSERT INTO gmve_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ዪሳቂ ባ ኣዋ ኣብራሃሜ፥ «ኣቦ!» ጊዴስ። ኣብራሃሜይካ፥ «ዬ! ታ ናዞ!» ጊን ዪሳቂ፥ «ታማይኔ ሚꬂ ዴስ ሺን ያርሼታና ዶርሳይ ኣዋኔ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ኣብራሃሜይካ፥ «ታ ናዞ! ያርሼታና ዶርሳ ጾሲ ጊጊሳና» ጊዴስ፤ ሂስቲን ኢስቲ ናምኣይ ኢሲፌ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ኢስቲ ጾሲ ኢዛስ ዮቲዳሶ ጋኪዳ ዎዴ ኣብራሃሜይ ያርሾ ያርሺዛሶ ሄን ጊግሲዲ ሚꬃ ኮሪዴስ፤ ባ ና ዪሳቃ ቃቺዲ ሄ ሚꬃ ቦላን ሹካናስ ኢሺሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ኣብራሃሜይ ባ ናዛ ሹካናስ ኩሼ ዬዲዲ ማሻ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ጊዶ ኣቲን ጎዳ ኪታንቻይ ሳሎፔ ኢዛ፥ «ኣብራሃሜ! ኣብራሃሜ!» ጊ ጼይጊን ኢዚ፥ «ዬ!» ጊ ኮዪን፥ ");
INSERT INTO gmve_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","«ናዛ ቦላ ኔ ኩሼ ዎꬆፋ፤ ኢዛ ኣይኮካ ኦꬆፋ፤ ኔኒ ኔ ሜጺ ኢሲ ናዛካ ታና ዲጎንታ ጊሻስ ኔኒ ጾሳስ ያዪዛ ኣስ ጊዲዳይሳ ታኒ ሃኢ ኤራዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ኣብራሃሜይ ꬎቁ ጊዲ ጼሊሺን ካጬይ ቱራን ኦይኬቲዳ ꬋርሾ ቤኢዴስ፤ ኣብራሃሜይ ቢዲ ሄ ꬋርሾዛ ኤኪዲ ጹጌቲዛ ያርሾ ያርሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ሄሳ ጊሻስ ኣብራሃሜይ ሄ ሶሆዛ፥ «ጎዳይ ኢሚዛሶ» ጊ ሱንꬂዴስ፤ ሃች ጋካናስካ ሄ ሶሆዚ፥ «ጎዳይ ዙማ ቦላን ኢማና» ጌቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ጎዳ ኪታንቻይ ሳሎፔ ናምኣንꬆ ኣብራሃሜ ጼይጊዲ፥ ");
INSERT INTO gmve_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","«ታኒ ኔስ ታናን ጫቃይስ፤ ኔኒ ሃይሳ ኦꬂዳ ጊሻስ ኔ ሜጺ ኢሲ ናዛካ ታና ዲጎንታ ጊሻስ፥ ");
INSERT INTO gmve_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ታኒ ኔና ቱሙ ኣንጃና፤ ኔ ዜሬꬃካ ታኒ ሳሎ ጾሊንቴ ማላኔ ኣባ ዶናን ዲዛ ኣጬ ማላ ኦꬃዳ ዳርሳና፤ ኔ ዜሬꬃቲ ባ ሞርኬታ ካታማታ ላታና። ");
INSERT INTO gmve_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ኔኒ ታስ ኣዛዜቲዳ ጊሻስ ሃ ካዎቴꬃይ ዉሪ ኔ ዜሬꬃ ባጋራ ኣንጄታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ሄሳፌ ጉዬ ኣብራሃሜይ ባ ኣይሌታኮ ሲሚን ኢስቲ ዉሪ ኢሲፌ ቤርሳቤሄ ዴንዲ ቢዳ። ኣብራሃሜይ ቤርሳቤሄን ዴኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ሄሳፌ ሲሚን ኣብራሃሜስ፥ «ሚልካይ ኔ ኢሻ ናኮሬስ ናይታ ዬላዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ኢስቲካ፥ ባይራ ና ኡጼ፥ ኡጼ ኢሻታ ቡዜ፥ ");
INSERT INTO gmve_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ኣራሜ ኣዋ ቃሙኤሌ፥ ኬሳዴ፥ ሃዞ፥ ፒልዳሴ፥ ዪዲላፌ፥ ባቱኤሌ ጌቴቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ሄይታ ሄ ኦስፑን ናይታካ ሚልካ ኣብራሃሜ ኢሻ ናኮሬስ ዬላዱስ፤ ባቱኤሊ ኢርቢቃ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ኤሬሂሞ ጌቴቲዛ ኢዛ ጋራዴያ ቃሴ ጼባሄ፥ ጌሃሜ፥ ቴሃሻኔ ማኪሳ ዬላዱስ» ጊ ዮቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ሳራይ 127 ላይꬅ ዴኢዳፔ ጉዬ፥ ");
INSERT INTO gmve_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ኢዛ ካናኔ ቢታን ዲዛ (ኬብሮኔ ጌቴቲዛ) ቂሪያቴ-ኣርባኤ ካታማን ሃይቂን ኣብራሃሜይ ሳራስ ዬኪዴሲኔ ካዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ኣብራሃሜይ ባ ማቼይ ኣሃ ኣቻፌ ሂቴታኮ ቢዲ፥ ");
INSERT INTO gmve_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«ታኒ ኢንቴ ጊዶን ኢማꬃ፤ ታ ማቼዮ ሞጋናስ ታስ ኢንቴ ጋዴፔ ሞጎሶ ባይዜርኬቲ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","ሂቴቲ ኢዛስ፥ «ጎዶ! ኑኒ ኔና ዮቲዛይሳ ሲያ፤ ኔኒ ኑ ጊዶን ጊታ ኣሳ፤ ኔኒ ኔ ማቼይ ኣሃ ኑ ዱፎፔ ኔና ሎኢዳሶን ሞጋ፤ ኔኒ ኔ ማቼይ ኣሃ ሞጋናስ ባ ዱፎ ኦኒካ ኔና ዲጌና» ጊ ዛሪዳ። ");
INSERT INTO gmve_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ኣብራሃሜይ ዴንዲ ኤቂዲ ሂቴታ ሃላቃታ ሲንꬃን ዚጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","ኢዚ ኢስታስ፥ «ኢንቴ ታና፥ ‹ኔ ማቼይ ኣሃ ሞጋ› ጊኮ ሲዪቴ፤ ጾሃሬ ና ኤፍሮኔስ ኢዛ ጋዴዛ ጋጻን ዲዛ ማኪጴሌ ጌቴቲዛ ጎንጎሎዛ ታስ ዱፎስ ባይዛና ማላ ኩሜꬃ ዋጋን ኑና ዛልኢሴርኬቲ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ሄ ዎዴ ኤፍሮኔይ ካታማ ፔንጌን ሺቂዳ ባ ኣሳ ሂቴታ ጊዶን ዴስ፤ ሄሳ ጊሻስ ሂቴቲ ዉሪ ሲዪሺን ኣብራሃሜስ፥ ");
INSERT INTO gmve_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«ሄሳ ማላ ጊዴና፤ ታ ጎዶ! ታ ዮቲዛይሳ ሲያ፤ ታኒ ጋዴዛካ ኢዛ ጊዶን ዲዛ ጎንጎሎዛካ ታ ኔስ ሃይሳ ኣሳ ሲንꬃን ኢማዲስ፤ ኔካ ኔ ማቼይ ኣሃ ሞጋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ኣብራሃሜይ ሃላቃታ ሲንꬃን ቃሴካ ዚጊዲ፥ ");
INSERT INTO gmve_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ኣሳይ ሲዪሺን ኤፍሮኔ፥ «ታ ዮቲዛይሳ ሲያርኪ! ታኒ ሄ ጋዴዛስ ዋጋ ቃንጻና፤ ኔ ታፔ ኤካርኪ! ሄን ታኒ ታ ማቼይ ኣሃ ሞጋና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","ኤፍሮኔይ ኣብራሃሜስ ዛሪዲ፥ «ታ ጎዶ! ታኒ ዮቲዛይሳ ሲያ፤ ጋዴዚ 400 ሳቂሌ ቢራ ጻላ ኬሲዛ ጋዴ ጊዲዳ ጊሻስ ሃይሲ ኔ ጊዶኒኔ ታ ጊዶን ኣይኮካ ጊዴና፤ ኔ ማቼይ ኣሃ ኢዛን ሞጋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ኣብራሃሜይ ሂቴ ኣሳይ ሲዪሺን ኤፍሮኔይ ጊዳ ዋጋ 400 ሳቂሌ ቢራ ኤፍሮኔስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ማሚሬ ካታማ ኣቻን ማኪጴሌን ዲዛ ኤፍሮኔ ጋዴን ዲዛ ጎንጎሎይኔ ሄ ጋዴን ዲዛ ሚꬃይ ዉሪ፥ ");
INSERT INTO gmve_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ካታማ ፔንጌን ሺቂዳ ሂቴ ኣሳ ኡባ ሲንꬃን ዎጋን ኣብራሃሜ ጋዴ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ሄሳፌ ጉዬ ኣብራሃሜይ ባ ማቾ ሳራ ኣሃ ካናኔ ቢታን (ኬብሮኔ ጌቴቲዛ) ማሚሬ ካታማ ኣቻን ዲዛ ጎንጎሎን ሞጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ሄሳ ጊሻስ ሄ ጋዴዚኔ ጋዴዛን ዲዛ ጎንጎሎዚ ሂቴታ ሲንꬃን ዎጋን ኣብራሃሜስ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ኣብራሃሜይ ዳሮ ጪሚዴስ፤ ጎዳይ ኢዛ ኡባንካ ኣንጂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ኣብራሃሜይ ባሶ ኣስ ኡባስ ሃላቃቲዛይሳኔ ኢዛፔ ጋርሳራ ኢዛ ኣቆታ ኡባ ኣይሲዛ ኣይሌዛ፥ «ኔ ኩሼ ታ ጉልባቴ ቦላ ዎꬃዳ ጫቃ። ");
INSERT INTO gmve_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ታኒ ኢስታ ጊዶን ዲዛ ካናኔ ማጫ ናይታፔ ኔ ታ ናስ ማቾ ኦይቾንታ ማላ ሳሎ ሳኣ ሜꬊዳ ጾሳን ታ ኔስ ጫቃይስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ጊዶ ኣቲን ታ ዬሌቲዳ ቢታ ታ ዳቦታኮ ባዳ፥ ታ ና ዪሳቃስ ማቾ ኦይቻ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ኢዛ ኦሳንቻዚ፥ «ማጫሳያ ታናራ ያናስ ዶሶንታ ኢጺኮ ናዛ ኔኒ ዪዳ ቢታ ጉዬ ዛራ ኤፎ?» ጊ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ኣብራሃሜይ፥ «ታ ናዛ ጌዴ ጉዬ ዛራ ኤፎንታ ማላ ናጌታ! ");
INSERT INTO gmve_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ጎዳ ሳሎ ጾሳይ ታና ታ ኣዋ ሶሆፔኔ ታ ዬሌቲዳ ቢታፌ ኬሲዳይሲ ታስ፥ ‹ኔ ዜሬꬃስ ታኒ ሃይሳ ቢታ ኢማና› ጊ ጫቂዳይሲ ኔኒ ታ ናስ ሄፔ ማቾ ዴማና ማላ ኢዚ ባ ኪታንቻ ኔፔ ሲንꬄ ኪታና። ");
INSERT INTO gmve_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ማጫሳያ ኔናራ ጉዬ ያናስ ዶሶንታ ኢጺኮ ሃይሲ ታኒ ኔና ጫቄꬂዳ ጫቆይ ኔስ ጎሜቶፖ፤ ናዛ ጉዬ ሙሌካ ኤፎፓ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ሄሳ ጊሻስ ኦሳንቻዚ ባ ጎዳ ኣብራሃሜ ዎዲራ ቦላ ባ ኩሼ ዎꬂ ጫቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ሄሳፌ ጉዬ ኦሳንቻዚ ባ ጎዳ ጋሜላታፔ ታማታ ኤኪዲ ባ ጎዳ ሚሻፌካ ሙሩታ ሙሩታ ኤኪዲ ቢዴስ፤ ሜስጴጾሚያ ጌቴቲዛ ቢታን ዲዛ ናኮሬ ካታማ ጋኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ኦማርሳ ዎዴ ማጫሲ ሃꬅ ዱቃናስ ዪሺን ካታማፔ ጋጻን ሃꬃ ኦላ ኣቻን ባ ጋሜላታ ጉልባቲሲዲ፥ ");
INSERT INTO gmve_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","«ጎዳዉ! ታ ጎዳ ኣብራሃሜ ጾሶ! ሃች ታኒ ቆፓዳ ዪዳይሳ ታስ ኢንጄሳ፤ ቃሴ ታ ጎዳ ኣብራሃሜስ ኪያ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ቤያ! ታኒ ሃይሳ ፑልቶ ሃꬃ ኣቻን ኤቃዲስ፤ ሃ ካታማ ኣሳ ማጫ ናይቲ ሃꬅ ዱቃናስ ሃ ዬቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ታኒ፥ ‹ኣኔ ኦቶዛ ዚቂ ሂስታዳ ታና ሃꬅ ኡሻ› ጊዛ ዎዴ፥ ኢዛካ፥ ‹ሄኮ ኡያ! ቃሴ ኔ ጋሜላታካ ታኒ ኡሻና› ጊዛራ ሂና ኔ ኣይሌ፤ ዪሳቃስ ኔኒ ዶሪዳሮ ጊዱ፤ ኔኒ ታ ጎዳስ ኪያ ኦꬂዳይሳ ታኒ ሄሳን ኤራና» ጊ ዎሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ቡሮ ኢዚ ዎሳ ዉርሶንታ ዲሺን ኢርቢቃይ ሃꬃ ኦቶ ቶካ ኤካዳ ፑቱ ጋዱስ፤ ኢዞ ባቱኤሊ ዬሊዴስ፤ ባቱኤሊ ሚልካ ና፤ ሚልካይ ኣብራሃሜ ኢሻ ናኮሬ ማቾ። ");
INSERT INTO gmve_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ኢርቢቃይ ዳሮ ማላ ሎኦኔ ጌሎንታ ጌላኦ። ዱጌ ዎꬋዳ ፑልቶዛፔ ባ ኦቶ ሃꬅ ኩንꬃዳ ኬዛዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ሄ ኣይሌይ ኢዚኮ ዎጺ ቢዲ ኢዞ፥ «ኔ ኦቶዛፔ ታና ጉꬃ ሃꬅ ኡሻርኪ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ኢዛ፥ «ኤሮ ታ ጎዶ! ኡያ» ጋዱስ። ኤሶታዳ ኦቶዛ ባ ሃሼፔ ዎꬃዳ ጌዲ ሂስታ ኦይካዳ ኢዛ ኡሻዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ኢዛ ኡሺዳይሳፌ ጉዬ፥ «ኔ ጋሜላቲካ ኣላና ጋካናስ ታኒ ኢስታስ ሃꬅ ዱቃና» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ኣቲዳ ሃꬄ ኤሶን ሃꬃ ጎንጌን ቲጋዳ ዱቃናስ ሃꬃ ኦላይ ዲዛሶ ዎጻዱስ፤ ጋሜላቲ ዉሪ ኣላና ጋካናስ ሃꬃ ኦላፌ ዱቃ ዱቃ ኤሃዳ ሃꬃ ጎንጌን ቲጋዳ ኡሻዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ኢዚ ቆፒዲ ዪዳ ቆፋ ጎዳይ ኢንጄሲዳኮ ኤራና ማላ ኣዴዚ ጮኡ ጊዲ ኢዞ ጼሌስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ጋሜላቲ ሃꬅ ኡዪ ሲሚን ኣዴዚ ኢቻሽ ጊራሜ ባጋ ጊዲዛ ዎርቃ ሳጋዮታኔ 100 ጊራሜ ጊዲዛ ናምኡ ዎርቃ ሳጋዮታ፥ ");
INSERT INTO gmve_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ኬሲዲ ኢዞ፥ «ኔኒ ኦና ና? ኣኔ ታስ ዮታ፤ ኔ ኣዋ ሶን ኑስ ኣቂዛሶይ ዳኔ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","ኢዛ፥ «ታኒ ሚልካይ ናኮሬስ ዬሊዳ ባቱኤሌ ና። ");
INSERT INTO gmve_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ኑሶን ጊዲዛ ሃፓይኔ ባሶይ ዴስ፤ ቃሴ ኢንቴስካ ኣቂዛሶይ ዴስ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ኣዴዚ ጉልባቲዲ ጎዳስ ጎይኒሼ፥ ");
INSERT INTO gmve_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","«ባ ኪያቴꬃኔ ባ ቱማ ታ ጎዳፔ ሃሶንታ ታ ጎዳ ኣብራሃሜ ጎዳ ጾሳይ ጋላቴቶ! ታኒ ዪሺን ጎዳ ጾሳይ ታና ታ ጎዳ ዳቦታሶ ካሌꬂዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ናያ ዎጻ ባዳ፥ ባ ኣዬይሶን ዲዛ ኣሳስ ሃኒዳይሳ ዮታዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ኢርቢቃስ ላባ ጌቴቲዛ ኢሻይ ዴስ፤ ላባይ ካሬ ኬዚዲ ሃꬃ ፑልቶ ኣቻን ዲዛ ኣዴዛኮ ዎጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","ቃላባቴኔ ባ ሚቼይ ኩሼን ዲዛ ሳጋዮታ ቤኢዳ ማላኔ ኢርቢቃይ ኣዴዚ ባና ጊዳይሳ ዮቲን ሲዪዳ ማላ ኬዚ ቢዲ ኣዴዚ ጋሜላታራ ፑልቶዛ ኣቻን ኤቂዳይሳ ዴሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ኢዛ፥ «ሃይሶ ጎዳይ ኔና ኣንጂዳይሶ ሃያ! ኔኒ ሃይሳን ካሬን ኣይስ ኤቃዲ? ታኒ ኔስ ኬꬂኔ ጋሜላታስካ ሶ ጊጊሳዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ሄሳ ጊሻስ ኣዴዚ ሶ ጌሊዴስ፤ ላባይ ጋሜላታ ጫና ቢርሺዲ ሃፓኔ ባሶ ጋሜላታስ ዬጊዴስ። ኢዛሲኔ ኢዛራ ዲዛ ኣሳታስ ቶሆ ሃꬅ ኤሂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ቁማካ ኢዛ ሲንꬅ ኣꬂዴስ፤ ኢዚ፥ «ታና ኤሂዳ ጉዳ ኢንቴስ ዮቶንታ ዳሼ ካꬅ ሚኬ» ጊዴስ። ላባይ፥ «ሂስቲኮ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ሄሳ ጊሻስ ኢዚ፥ «ታኒ ኣብራሃሜ ኣይሌ። ");
INSERT INTO gmve_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","ጎዳይ ታ ጎዳ ኣብራሃሜ ኬሂ ኣንጂን ኢዚ ዱሬቲዴስ፤ ዶርስ፥ ሚዝ፥ ቢራ፥ ዎርቃ፥ ኣቱማ ኣይሌታ፥ ማጫ ኣይሌታ፥ ጋሜላታኔ፥ ሃሬታ ኢዛስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ታ ጎዳ ማቺያ ሳራይ ባ ጪማቴꬃ ላይꬃን ኢዛስ ኣቱማ ና ዬሊን ኢዚ ባስ ዲዛዝ ኡባ ኢዛስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","ታ ጎዳይ ታና ሃይሳꬆ ጫቂሲዴስ፤ ‹ታኒ ዲዛ ካናኔ ቢታ ማጫ ናይታፔ ታ ናዛስ ማቾ ኦይቾፋ፤ ");
INSERT INTO gmve_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ታ ኣዋ ኣሳኮ ታ ዜሬꬃኮ ባዳ ታ ናዛስ ማቾ ኦይቻ› ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ታኒካ ታ ጎዳዉ፥ ‹ናያ ታናራ ያናስ ዶሶንታ ኢጺኮቺ?› ጋዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","ኢዚ፥ ‹ጎዳይ ታኒ ኢዛ ሲንꬃን ሱሬ ሄሜቲዳ ጾሲ ኔናራ ባ ኪታንቻ ኪታና፤ ኔኒ ታ ኔስ ታ ኣዋ ኣሳፔ፥ ታ ዛሬታፔ ማቾ ዴማና ማላ፥ ኔ ቢዛ ኦጌ ኡባ ሎኤꬃና። ");
INSERT INTO gmve_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ኔኒ ታ ዛሬታኮ ቢን ኢስቲ ኔስ ኢዞ ኢሞንታ ኢጺኮ ሄ ዎዴ ኔስ ጫቆይ ጎሜቴና› ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","«ታኒ ሃች ሃይሳ ፑልቶዛኮ ዪዳ ዎዴ ጎዳዉ! ታ ጎዳ ኣብራሃሜ ጾሶ! ኔ ሼኔ ጊዲኮ ታኒ ቢዛ ቆፋዛ ኢንጄሳ። ");
INSERT INTO gmve_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ቤኣ፤ ታኒ ሃ ፑልቶዛ ኣቻን ኤቃዲስ፤ ጌላኦ ኢሲኒያ ሃꬄ ዱቃናስ ዪኮ ታኒ ኢዞ፥ ‹ታና ኔ ኦቶዛፔ ጉꬃ ሃꬅ ኡሻርኪ!› ጋና። ");
INSERT INTO gmve_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ሂስቲኮ ኢዛ ታና፥ ‹ኤሮ ኡያ› ቃሴ፥ ‹ኔ ጋሜላታስካ ታኒ ሃꬅ ዱቃና› ጊዛራ ጾሲ ታ ጎዳይ ኔስ ዶሪዳሮ ጊዱ። ");
INSERT INTO gmve_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","«ታኒ ታ ዎዚናን ዎሲዛይሳ ዉርሶንታ ዲሺን ኢርቢቃይ ባ ኦቶ ሃሼን ቶካ ኤካዳ ፑቱ ጋዱስ፤ ዱጌ ፑልታኮ ዎꬋዳ ሃꬅ ዱቃዱስ፤ ታኒ ኢዞ፥ ‹ታና ሃꬅ ኡሻርኪ!› ጋዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","«ኢዛ ኤሶን ባ ሃሼፔ ኦቶዛ ዎꬃዳ፥ ‹ሄኮ ኡያ! ቃሴ ታኒ ኔ ጋሜላታ ኡሻና› ጋዱስ፤ ታኒካ ኡያዲስ፤ ቃሴ ታ ጋሜላታካ ኡሻዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","«ታኒ ኢዞ፥ ‹ኔኒ ኦና ና?› ጋ ኦይቻዲስ። «ኢዛ፥ ‹ታኒ ሚልካይ ናኮሬስ ዬሊዳ ባቱኤሌ ና› ጋዱስ። «ታኒካ ኢዚ ኩሼን ቃላባቴ ኣꬃዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ሄሳፌ ጉዬ ታኒ ጉልባታዳ ጎዳስ ጎይናዲስ፤ ታኒ ጎዳ ታ ጎዳ ኣብራሃሜ ጾሳ፥ ታ ጎዳ ኢሻ ናዮ ኢዛ ኔስ ኤካናስ ታና ሊኬ ኦጌ ካሌꬂዳይሳ ጋላታይስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ሃኢካ ኢንቴ ታ ጎዳስ ኪያና ማላኔ ኣማኔታና ጊዲኮ ታስ ዮቲቴ፤ ሄሲ ሃኔና ጊኮካ ታስ ዮቲቴ፤ ሄሳፌ ጉዬ ታኒ ሃናናይሳ ታ ኤራይስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ላባይኔ ባቱኤሊ፥ «ሃ ቆፋዚ ጎዳፔ ዪዴስ፤ ኑኒ ኔስ ጌዴ ሃ ጋናስ ዳንዳዮኮ። ");
INSERT INTO gmve_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ኢርቢቃ ሃኖ ቤያ፤ ኤካዳ ባ! ጎዳይ ጊዳ ማላ ኔ ጎዳ ናዛስ ማቾ ጊዱ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ኣብራሃሜ ኣይሌይ ኢስቲ ጊዛይሳ ሲዪዳ ማላ ቢታን ጉልባቲዲ ጾሳስ ጎይኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ኣሽካራዚ ቢራ ኣሌቆኔ ዎርቃ ኣሌቆ፥ ማይኦካ ኬሲዲ ኢርቢቃስ ኢሚዴስ፤ ቃሴ ኣልኦ ሚሻታ ኢዚ ኢሻሲኔ ኢዚ ኣዬይስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ሄሳፌ ጉዬ ኢዚካ ኢዛራ ዲዛይቲ ሚዳኔ ኡዪዳ፤ ሂስቲዲ ሄን ኣቂዳ፤ ኢስቲ ማላዶ ዎንታራ ዴንዲን፥ «ታና ታ ጎዳኮ ሞይዚቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ጊዶ ኣቲን ኢዚ ኢሻይኔ ኢዚ ኣያ፥ «ናያ ኢሲ ታሙ ጋላሳ ማላ ኑናራ ታኩ፤ ሄሳፌ ጉዬ ኢዛ ባና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ኢዚ ጊዲኮ፥ «ጎዳይ ታኒ ዪዳይሳ ኢንጄሲን ኢንቴ ታና ጋምኢሶፒቴ፤ ታኒ ታ ጎዳኮ ባና ማላ ታና ሞይዚቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ኢስቲካ፥ «ናዮ ጼይጊዲ ኣኔ ኑ ኢዞ ኦይቾስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ሄሳ ጊሻስ ኢርቢቃ ጼይጊዲ፥ «ሃ ኣዴዛራ ባኔ?» ጊ ኦይቺዳ። ኢዛካ፥ «ኤ፤ ታኒ ባና» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","ሂስቲን ኢስቲ ባ ሚቼዮ ኢርቢቃ ኢዞ ዲቺዛሪራ፥ ኣብራሃሜ ኣይሌዛራኔ ኢዛ ኣሳታራ ሞይዚዳ። ");
INSERT INTO gmve_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","ኢስቲ ኢርቢቃ፥ «ኑ ሚቼዬ ኢርቢቃ! ጮራታ ቢታ ኩማ፤ ኔ ዜሬꬂ ባ ሞርኬታ ካታማታ ላቴቶ» ጊ ኣንጂዳ። ");
INSERT INTO gmve_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ሄሳፌ ጉዬ ኢርቢቃይኔ ኢዚ ጋራዴቲ ዴንዲዲ ጋሜላታ ቶጊዲ ኣዴዛራ ቢዳ፤ ሂስቲን ኣይሌዚ ኢርቢቃ ኤኪዲ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ሄ ዎዴ ዪሳቂ፥ «ታና ቤኢዛ ዴኦ ጾሳ ፑልቶ» ጊዛ ፑልቶዛ ማታ ቢዲ፥ ኔጌቤ ባዞን ዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ኢሲ ጋላሳ ኦማርስ ዪሳቂ ባ ዎዚናን ቆፒዲ ዴምባ ኬዚዲ ዩዪሼ ኢዚ ꬎቁ ጊ ጼሊዛ ዎዴ ጋሜላቲ ዪዛይታ ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ኢርቢቃይካ ꬎቁ ሂስታ ጼላዳ ዪሳቃ ቤያዳ ጋሜላ ቦላፌ ዎꬋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ዎꬋዳ ኣይሌዛ፥ «ኑናራ ጋጋናስ ሴኪ ዴምባራ ሃ ዪዛ ኣዴይ ኦኔ?» ጋዱስ። ኣሽካራዚ፥ «ኢዚ ታ ጎዳ ዴኔ» ጊዴስ፤ ኢዛ ባ ሻሼዛ ኤካዳ ጉሉንታዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ቃሴ ኣይሌዚ ባ ኦꬂዳይሳ ኡባ ዪሳቃስ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ዪሳቂ ኢርቢቃ ባ ኣዬይ ሳራ ዱንካኔን ኤፊዲ ኢዞ ማቾ ኤኪዴስ፤ ኢዛካ ኢዛስ ማቾ ጊዳዱስ፤ ሂስቲን ኢዚ ኢዞ ሲቂዴሲኔ ባ ኣዬይ ሃይቆን ካዮቲዛይሳፌ ሚኔቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ቃሴ ኣብራሃሜይ ኬጹራ ጌቴቲዛ ሃራ ማቾ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ኢዛ ዚሚራኔ፥ ዮቂሻኔ፥ ሜዳኔ፥ ሚዲያኔ፥ ዪሺባቄኔ ሹሃ ኢዛስ ዬላዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","ዮቂሻኔይ ሳባኔ ዳዳኔ ዬሊዴስ፤ ዳዳኔይ ኣሶሬታ፥ ሌጹሴታኔ ሌኣሜታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","ሚዲያኔ ናይቲ ኤፋ፥ ኤፌሬ፥ ሄኖኬ፥ ኣቢዳኤኔ ኤልዳኤ። ሃይቲ ዉሪካ ኬጹራ ናይታ። ");
INSERT INTO gmve_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ኣብራሃሜይ ባ ሃሮ ኡባ ዪሳቃ ላቲሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ጊዶ ኣቲን ኢዚ ቡሮ ፓጻ ዲሼ ባ ጋራዴታፔ ዬሊዳ ናይታስ ባስ ዲዛይሳፌ ዎይቲዴስ። ዎይቲዲ ባ ና ዪሳቃፔ ኢስታ ሻኪዲ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ዴሬ ዬዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ኣብራሃሜይ ሙሌራ 175 ላይꬅ ዴኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ኣብራሃሜይ ዳሮ ዎዴ ዴኢዲ ሎኦ ጪማ ጪሚዲ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ኢዛ ናይቲ ዪሳቂኔ ኢስማኤሌይ ኢዛ ማኪጴሌ ጌቴቲዛ ጎንጎሎ ዱፎን ሞጊዳ፤ ሄ ጎንጎሎዚ ማሚሬ ኣቻን ሂቴ ጾሃሬ ና ኤፍሮኔ ጋዴን ዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ሄሲካ ኣብራሃሜይ ሂቴታፔ ሻሚዳ ጋዴ። ኣብራሃሜይ ባ ማቺያ ሳራይ ሞጌቲዳሶን ሞጌቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ኣብራሃሜይ ሃይቂዳፔ ጉዬ ጾሲ ኢዛ ና ዪሳቃ ኣንጂዴስ። ሄ ዎዴ ዪሳቂ፥ «ታና ቤኢዛ ዴኦ ጾሳ ፑልቶ» ጌቴቲዛ ፑልቶ ኣቻን ዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ሳራ ኣይሌያ ጊብጼፔ ዪዳ ኣጋራ ኣብራሃሜስ ዬሊዳ ናዛ ኢስማኤሌ ዬሌታይ ሃይሳፌ ካሊ ጻፌቲዳይሳ። ");
INSERT INTO gmve_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ኢስማኤሌ ናይቲ ባ ሱንꬃኒኔ ባ ዬሌታ ማራን ሃይታንታ፤ ሄይታንቲካ ኔባዮቴ፥ ቄዳሬ፥ ኣዲቢኤሌ፥ ሚቢሳሜ፥ ");
INSERT INTO gmve_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ሚሺማኤ፥ ዱማ፥ ማሴ፥ ");
INSERT INTO gmve_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ሃዳዴ፥ ቴማ፥ ዪጹሬ፥ ናፊሻኔኔ ቄዲማ። ");
INSERT INTO gmve_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ኢስማኤሌ ናይቲ ሃይታንታ፤ ኢስታ ሱንꬂ ኢስታ ሞꬃኒኔ ዲዛሶን ዲዛሶን ሃይሳ፤ ኢስታስ 12 ዛርኬ ሃላቃቲ ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ኢስማኤሌይ ሙሌራ 137 ላይꬅ ዴኢዲ ሃይቂዴስ፤ ሃይቂዲ ባ ኣዋታን ጋጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ኢስማኤሌ ዜሬꬂ ጊብጼፔ ኣርሼይ ሞኪዛ ባጋን ዲዛ ሃዊላፔኔ ሹራፔ ጊዶን ኣሶሬ ኤፊዛ ኦጌ ኣቻን ዴኢዳ። ኢስቲ ባ ኢሻታ ኡባታራ ሞርኬቴꬃን ዴኢዳ። ");
INSERT INTO gmve_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ኣብራሃሜ ና ዪሳቃ ዬሌታይ ሃይሳፌ ካሊ ጻፌቲዳይሳ። ኣብራሃሜይ ዪሳቃ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ዪሳቃስ ላይꬃይ 40 ጊዲዳ ዎዴ ኢርቢቃ ኤኪዴስ፤ ኢዛ ሜስጴጾሚያን ዲዛ ኣራሜ ባቱኤሌ ናዮኔ ኣራሜ ዴሬ ኣስ ላባ ሚቾ። ");
INSERT INTO gmve_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ዪሳቂ ባ ማቺያ ማይኔ ጊዲዳ ጊሻስ ኢዚስ ጎዳ ዎሲን ጎዳይ ኢዛ ዎሳ ሲዪዴስ፤ ሂስቲን ኢዛ ማቺያ ኢርቢቃይካ ቃንꬃታዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ጊዶ ኣቲን ኢዚ ኡሎ ጊዶን ዲዛ ናይቲ ሜንቴ ጊዲዳ ጊሻስ ኢሶይ ኢሳራ ሱጌቲዳ፤ ሂስቲን ኢዛ፥ «ሃይሲ ታ ቦላ ኣይስ ሃኒዜ?» ጋዱስ። ሄሳ ጊሻስ ጾሳ ኦይቻና ቢን፥ ");
INSERT INTO gmve_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ጎዳይ ኢዚስ፥ «ኔ ኡሎን ናምኡ ካዎቴꬂ ዴስ፤ ቃሴ ኔ ኡሎን ዲዛ ናምኡ ዴሬ ኣሳቲ ኢሶይ ኢሳፌ ሻኬታና፤ ኢሲ ዴሬ ኣሳይ ሃንኮይታፔ ሚናና፤ ቃሴ ባይራይ ካሎዛስ ሃሬታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ኢዚስ ዬሎ ዎዴይ ጋኪን ኢዛ 2 ኣቱማ ናይታ ሜንቴ ዬላዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ኮይሮ ዬሌቲዳይሲ ኣሪሳ፤ ኢዛ ቦላይካ ዉሪ ኢስኬ ጻላ፤ ሄሳ ጊሻስ ኢስቲ ኢዛ ኤሳዌ ጊ ሱንꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ሄሳፌ ጉዬ፥ ኢዛ ኢሻይ ዬሌቲሼ ኤሳዌ ቶሆ ኦይኪ ዬሌቲዴስ፤ ሄሳ ጊሻስ ኢዛ ያቆቤ ጊ ሱንꬂዳ። ኢርቢቃይ ኢስታ ዬሊዳ ዎዴ፥ ዪሳቃስ ላይꬃይ ኡሱፑን ታሙ ላይꬂ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ናይቲ ዲጪዳ፤ ኤሳዌይ ሻንካ ኤሪዛ ባዞ ኣስ ጊዲዴስ፤ ጊዶ ኣቲን ያቆቤይ ዱንካኔን ዲዛ ኣሽኬ ኣስ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ዪሳቂ ኤሳዌ ሲቂዴስ፤ ኣይስ ጊኮ ኢዚ ሻንካቲዳይሳፌ ማናስ ዶሲዴስ፤ ጊዶ ኣቲን ኢርቢቃይ ያቆቤ ሲቃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ኢሲ ዎዴ ያቆቤይ ዎጼ ካꬂሺን ኤሳዌ ጋፋይ ዎꬊሺን፥ ባዞፌ ዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ኤሳዌይ ያቆቤ፥ «ታና ሃይሳ ዞኦ ዎጼዛፔ ሚዛ፤ ታና ጋፋይ ዎꬌስ» ጊዴስ። (ሄሳ ጊሻስ ቃሴ ኢዛ ሱንꬂ ኤዶሜ ጌቴቲዴስ።) ");
INSERT INTO gmve_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ያቆቤይ ኢዛ፥ «ኮይሮ ታስ ኔ ባይራቴꬃ ባይዛ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ሂስቲን ኤሳዌይ፥ «ሄኮ! ታ ሃይቃና ጋይስ ሃና ታ ባይራቴꬃያ ታና ኣይ ማዳኔ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ያቆቤይ ዛሪዲ፥ «ኣኔ ታስ ኮይሮ ኔኒ ጫቃ» ጊዴስ፤ ሂዝጊን ኢዚ ጫቂዴስ፤ ባ ባይራቴꬃካ ያቆቤስ ባይዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ሄሳፌ ሲሚን ያቆቤይ ኤሳዌስ ቡዴናኔ ሚሲራ ዎጼ ኢሚን ኢዚ ሚዴሲኔ ኡዪዴስ፤ ሄሳፌ ጉዬ ዴንዲዲ ቢዴስ፤ ኤሳዌይ ባ ባይራቴꬃ ካꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ሄ ቢታን ካሴ ኣብራሃሜ ዎዴን ዲዛ ኮሻፔ ሃራ ኮሻይ ዴንዲዴስ፤ ሂስቲን ዪሳቂ ፊሊስጼሜ ካዎ ኣቢሜሌኬኮ ጌራሬ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","ጎዳይ ዪሳቃስ ቆንጪዲ፥ «ጊብጼ ቢታ ዱጌ ቦፓ፤ ታኒ ኔስ ዮቲዛ ቢታን ዴኣ። ");
INSERT INTO gmve_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ሃ ቢታን ጉꬃ ዎዴ ኡታሻ፤ ታኒ ኔናራ ጊዳና፤ ኔና ኣንጃና፤ ኣይስ ጊኮ ሃይሳ ቢታ ኡባ ታኒ ኔሲኔ ኔ ዜሬꬃስ ኢማና፤ ታኒ ኔ ኣዋ ኣብራሃሜስ ጫቆ ጌሊዳ ኡፋይሳ ቃላ ሚንꬃና። ");
INSERT INTO gmve_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","ኔ ዜሬꬃ ታኒ ሳሎ ጾሊንቴ ማላ ዳርሳና፤ ሃይሳ ቢታ ኡባ ታ ኢስታስ ኢማና፤ ቢታ ኣሳይ ኡባይ ኔ ዜሬꬃ ባጋራ ኣንጄታና። ");
INSERT INTO gmve_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ጋሶይካ ኣብራሃሜይ ታ ቃላ ሲዪዲ ኣዛዜቲዴስ፤ ታ ኢዛስ ዮቲዳይሳ ኢዚ ኡባ ናጊዳ ጊሻሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ሄሳ ጊሻስ ዪሳቂ ጌራሬን ዴኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ሄ ቢታ ኣሳይ ኢርቢቃ ጊሻስ ዴንꬂዲ ዪሳቃ፥ «ሃና ኔስ ኣዜ?» ጊ ኦይቺዳ። ኢዚካ ኢርቢቃይ ኬሃ ማላ ሎኦ ጊዲዳ ጊሻስ፥ «ታኒ ኢዛ ታ ማቾ ጊኮ ሃ ኣሳይ ኢዚ ጌዶን ታና ዎꬋናኮኔ» ጊ ባቢዳ ጊሻስ፥ «ሃና ታስ ሚቾ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ዪሳቂ ሄን ዳሮ ዎዴ ዲዳፔ ጉዬ ፊሊስጼሜ ካዎ ኣቢሜሌኬይ ማስኮቴራ ዱጌ ጼሊዲ ዪሳቂ ባ ማቾ ኢርቢቃራ ኢዲሜቲሼ ካኢሺን ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ሄሳ ጊሻስ ኣቢሜሌኬይ ዪሳቃ ጼይጊሲዲ፥ «ሄኮ ኢዛ ኔስ ማቾ! ኔኒ ኣይስ ኢዞ ታ ሚቾ ጋዲ?» ጊ ኦይቺዴስ። ኢዚካ፥ «ኢዛ ታ ማቾ ጊኮ ኢዚ ጋሶን ኣሳይ ታና ዎꬋና ጋዳ ባቢዳ ጊሻስ ጋዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","ሂስቲን ኣቢሜሌኬይ፥ «ሃይሲ ኔኒ ኑ ቦላ ኦꬂዳይሲ ኣዜ? ታ ኣሳፔ ኢሲ ኣሲ ኔ ማቼይራ ኣቂዳኮ ኑ ቦላ ጎሜ ኤሃሼ ኣጋዳሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ሄሳ ጊሻስ ኣቢሜሌኬይ ባ ኣሳ ኡባ፥ «ሃ ኣዴዛ ዎይኮ ኢዛ ማቾ ቦቺዛይ ኦኒካ ቱሙ ሃይቆ» ጊ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ዪሳቂ ሄ ቢታን ካꬅ ዜሪን ጎዳይ ኢዛ ኣንጂዳ ጊሻስ ሄ ላይꬃን ጼቱ ኩሼ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ኢዛስ ኣቆታይ ዳሪ ዳሪ ቢዳ ጊሻስ ኬሂ ዱሬቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ዪሳቃስ ዶርሲ፥ ሚዛ ዉዴይኔ ኣይሌቲ ኬሂ ዳሪዳ ጊሻስ ፊሊስጼሜ ኣሳይ ኢዛ ሚቃይኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ሄሳ ጊሻስ ኢዛ ኣዋ ኣብራሃሜ ዎዴን ኢዛ ኣዋ ኣይሌቲ ቦኪዳ ሃꬃ ኦላ ኡባ ፊሊስጼሜ ኣሳይ ቢታ ዛሪዲ ኩንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ሄ ዎዴ ኣቢሜሌኬይ ዪሳቃ፥ «ኑፔ ሻኬታዳ ባ፤ ኔኒ ኑፔ ኣꬋ ሚናዳሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ሂዝጊን ዪሳቂ ሄፔ ዴንዲዲ ጌራሬ ሾባ ቢዲ ዱንካኔ ቶኪዲ ሄን ዴኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ኣብራሃሜይ ፓጻ ዲሼ ቦኪሲዳ ሃꬃ ኦላታ ኣብራሃሜይ ሃይቂዳፔ ጉዬ ፊሊስጼሜ ኣሳይ ቱጪዳ ሃꬃ ኦላታ ዪሳቂ ቃሴካ ቦካና ማላ ኦꬂዲ ካሴ ኢዛ ኣዋይ ሱንꬂዳ ሱንꬃን ጼይጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ዪሳቃ ኣይሌቲ ሾባን ሃꬃ ኦላ ቦኪሼ ቦኪዛ ኦላፌ ፑልቲዛ ሃꬅ ዴሚዳ። ");
INSERT INTO gmve_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ጊዶ ኣቲን ጌራሬን ሜሄ ሄሚዛይቲ ዪሳቃ ሜሄ ሄሚዛይታራ፥ «ሃꬃይ ኑይሳ» ጊ ኦዬቲዳ። ኢስቲ ኢዛራ ፓላሜቲዳ ጊሻስ ዪሳቂ ሄ ሃꬃ ኦላ፥ «ኤሴቄ» ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ሄሳፌ ጉዬ ኢስቲ ሃራ ሃꬃ ኦላካ ቦኪዳ፤ ጊዶ ኣቲን ኢስቲ ሄ ሃꬃ ኦላ ጌዶንካ ኦዬቲዳ፤ ሄሳ ጊሻስ ኢዚ ሄ ሃꬃ ኦላ፥ «ሲጺና» ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ሄሳፌ ጉꬅ ሃራሶ ኣꬊ ሃራ ሃꬃ ኦላ ቦኪሲዴስ፤ ኢዛ ጋሶን ኦኒካ ኦዬቲቤና፤ «ጾሲ ሃኢ ኑስ ኣሲዴስ፤ ኑኒ ሃ ቢታን ዳራና» ጊዲ ኢዛ፥ «ኦሮቦቴ» ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ሄሳፌ ጉዬ ዪሳቂ ፑዴ ቤርሳቤሄ ጌቴቲዛሶ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ሄ ቢዳ ጋላስ ቃማራ ጎዳይ ኢዛስ ቆንጪዲ፥ «ታኒ ኔ ኣዋ ኣብራሃሜ ጾሳ፤ ታኒ ኔናራ ዲዛ ጊሻስ ባቦፋ! ታኒ ኔና ኣንጃና፤ ታ ኣይሌ ኣብራሃሜ ጊሻስ ኔ ዜሬꬃ ታ ዳርሳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ዪሳቂ ሄን ያርሺዛሶ ኬጺዲ ጎዳ ሱንꬅ ጼይጊዴስ፤ ሄን ኢዚ ባ ዱንካኔዛ ቶኪዴስ፤ ቃሴ ሄን ኢዛ ኣይሌቲ ሃꬃ ኦላ ቦኪዳ። ");
INSERT INTO gmve_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ሄሳፌ ጉዬ ኣቢሜሌኬይ ባና ዞሪዛ ኣሁዛታኔ ባ ዎታዳራታ ሃላቃ ፒኮሌ ኤኪዲ ጌራሬፔ ዪሳቃኮ ዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ዪሳቂ ኢስታስ፥ «ኢንቴ ካሴ ታና ኢጺዲ ኢንቴ ቢታፌ ኬሲ ዬዲዲ ሃኢ ቃሴ ታኮ ኣይ ኤካና ዪዴቲ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","ኢስቲ ኢዛ፥ «ጎዳይ ኔናራ ዲዛይሳ ቱሙ ኑኒ ቆንጬን ቤኢዶስ፤ ሄሳ ጊሻስ ኑሲኔ ኔስ ጊዶን ጫቆ ቃላይ ዴኣና ኮሼስ ጎስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ጊዶ ኣቲን ኑኒ ኔስ ኪያቴꬅ ጻላ ኦꬂዲ ኔና ሳሮቴꬃን ሞይዚዶስ፤ ሄሳꬆካ ኔኒ ኑ ቦላ ኢታ ሚሽ ኦꬆንታ ማላ ኣኔ ኔናራ ጫቆ ጫቄቶስ፤ ሃኢ ኔና ጎዳይ ኣንጂዳይሲ ቆንጪዴስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ሄ ዎዴ ዪሳቂ ኢስታስ ጊቢራ ጊግሲን ሚዳኔ ኡዪዳ። ");
INSERT INTO gmve_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ዎንቴꬃ ጋላስ ማላዶ ዎንታራ ዴንዲዲ ኢስቲ ኢሶይ ኢሳራ ጫቄቲዳ። ዪሳቂ ኢስታ ሞይዚን ኢስቲ ኢዛፔ ሳሮን ሻኬቲዲ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ሄ ጋላስ ዪሳቃ ኣይሌቲ ዪዲ ባ ቦኪዳ ሃꬃ ኦላ ጊሻስ፥ «ኑኒ ሃꬅ ዴሚዶስ» ጊ ኢዛስ ዮቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ኢዚ ሄ ሃꬃ ኦላ፥ «ሳቤሄ» ጊ ሱንꬂዴስ፤ ሄሳ ጊሻስ ሄ ካታማ ሱንꬂ ሃች ጋካናስ ቤርሳቤሄ ጌቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ኤሳዌ ላይꬂ 40 ጊዲዳ ዎዴ ቢኤሬ ና ዮዲቶኔ ኤሎኔ ና ባሴማቶ ማቾ ኤኪዴስ፤ ኢስቲ ናምኣይካ ሂቴ ቢታ ኣሳ። ");
INSERT INTO gmve_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ኢስቲካ ዪሳቃኔ ኢርቢቃ ሚሺሲሼ ዴኢዳ። ");
INSERT INTO gmve_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ዪሳቂ ጪሚን ኢዛ ኣይፌይ ጼሎ ኢጺዳ ዎዴ ባስ ባይራ ናዛ ኤሳዌ ጼይጊዲ ኢዛ፥ «ታ ናዞ!» ጊዴስ። ሂስቲን ኢዚ፥ «ዬ!» ጊ ኮዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ኢዚካ፥ «ቤያ! ሃኢ ታኒ ጪማዲስ፤ ታኒ ኣይዴ ሃይቃናኮኔ ታ ሃይቃና ጋላስ ኤሪኬ። ");
INSERT INTO gmve_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ሄሳ ጊሻስ ሃኢ ኔ ኢዛራ ሻንካቲዛ ቶራ ኤካዳ ባዞ ባዳ ዶኣ ሻንካታዳ ታስ ኣሾ ኤካዳ ያ። ");
INSERT INTO gmve_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ታ ዶሲዛ ማልኦ ቁማ ካꬃዳ ታስ ኣꬃ፤ ሄሲካ ታኒ ሃይቃናፔ ካሴ ኔና ኣንጃናሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ኢርቢቃይ ዪሳቂ ባ ና ኤሳዌስ ዮቲዛይሳ ሄ ዎዴ ሲያዱስ፤ ኤሳዌይ ዶኣ ሻንካቲዲ ኤሃናስ ባዞ ቢን፥ ");
INSERT INTO gmve_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ኢርቢቃይ ባ ናዛ ያቆቤ፥ «ኔ ኣዋይ ኔ ኢሻ ኤሳዌ፥ ");
INSERT INTO gmve_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‹ዶኣ ሻንካታ ኤሃዳ ታ ማና ማላ ታስ ማልኦ ቁማ ካꬃ፤ ሂስቲኮ ታ ሃይቆንታ ዳሼ ጎዳ ሲንꬃን ኔና ኣንጃና› ጊሺን ታኒ ሲያዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ታ ናዞ! ሃኢ ታኒ ኔና ኣዛዚዛይሳ ሎኤꬃዳ ሲያ። ");
INSERT INTO gmve_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ዉዴዛ ጋርስ ባዳ ናምኡ ኣንቃራ ዴይሻ ላቃታ ታስ ኤካዳ ያ፤ ኔ ኤሂኮ ታኒ ኔ ኣዋስ ማልኦ ቁማ ኢዚ ዶሲዛ ማላ ካꬃና። ");
INSERT INTO gmve_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ኔ ኣዋይ ሃይቆንታ ዲሼ ሚዲ ኔና ኣንጃና ማላ ኤሃዳ ሚዛ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ጊዶ ኣቲን ያቆቤይ ባ ኣዮ ኢርቢቃስ፥ «ታ ኢሻ ኤሳዌ ቦላን ኢስኬይ ዴስ፤ ጊዶ ኣቲን ታ ቦላይ ሊቆ። ");
INSERT INTO gmve_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ታ ኣዋይ ታና ኦይኪ ቤይኮቺ? ታኒ ኢዛ ጪሚዛ ኢዛስ ሚሳቲኮ ታኒ ኣንጆ ኣጋዳ ቃንጌꬃ ታ ቦላ ኤሃናኮ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ኢዛ ኣዬያ ኢዛ፥ «ታ ናዞ! ሄ ቃንጌꬃይ ታና ጋኮ። ታኒ ኔስ ዮቲዛይሳ ኔ ኦꬃ፤ ባዳ ዴይሻ ላቃታ ታስ ኤካ ያ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","ኢዚ ኤሂዲ ባ ኣዬይስ ኢሚን ኣዬያ ማልኦ ቁማ ኢዛ ኣዋይ ዶሲዳ ማላ ማልኤꬃ ካꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ሄሳፌ ጉዬ ኢርቢቃይ ሶን ባ ኣቻን ዲዛ ባ ባይራ ና ኤሳዌ ሎኦ ማይኦ ኤሃዳ ካሎ ናዛ ያቆቤ ማይዛዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ቃሴ ሄ ዴይሻታ ኢቴ ኢዛ ኩሼኒኔ ኢዛ ቆꬌን ማይዛዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ሂስታዳ ባ ካꬂዳ ማልኦ ቁማኔ ኡኬꬃ ባ ና ያቆቤ ኩሼን ዎꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ሂስቲን ኢዚ ባ ኣዋኮ ቢ ጌሊዲ፥ «ታ ኣዋዉ!» ጊዴስ። ኢዚካ፥ «ዬ! ታ ናዞ! ኔኒ ኦኔ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ያቆቤይ ባ ኣዋስ፥ «ታኒ ኔ ባይራ ና ኤሳዌ፤ ኔኒ ታና ኣዛዚዳ ማላ ታኒ ኦꬃዲስ፤ ሱራዳ፥ ታኒ ሻንካታ ኤሂዳይሳ ማ፤ ሂስታዳ ታና ኣንጃ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ዪሳቂ ያቆቤ፥ «ታ ናዞ! ዎስታ ኤሶን ዴማዲ?» ጊ ኦይቺዴስ። ኢዚካ፥ «ጎዳይ ኔ ጾሲ ታና ማዲና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ዪሳቂ ያቆቤ፥ «ታ ናዞ! ኔኒ ቱሙ ታ ና ኤሳዌኮኔ ታኒ ኔና ኦይካ ቤኣናስ ኣኔ ታኮ ሃ ሺቃ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ያቆቤይ ባ ኣዋ ዪሳቃኮ ሺቂን ኦይኪ ቤኢዲ፥ «ሃይሲ ቃላይ ያቆቤ ቃላ ሺን ኩሼይ ኤሳዌ ኩሼ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ኢዛ ኩሼይ ኢዛ ኢሻ ኤሳዌ ኩሼꬆ ኢስኬራ ዲዛ ጊሻስ ኤሮንታ ኢዛ ኣንጂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ኢዛ፥ «ቱሙ ኔኒ ታ ና ኤሳዌ?» ጊ ኦይቺዴስ። ኢዚካ፥ «ኤ ታናኮ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ኢዚካ፥ «ታ ናዞ! ታኒ ኔኒ ሻንካቲዳይሳ ማናስ ሃ ኣꬃ፤ ማዳ ታኒ ኔና ኣንጃና» ጊዴስ። ያቆቤይ ኣꬂን ኢዚ ሚዴስ፤ ዎይኔ ኡሻካ ኤሂን ኡዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ሄሳፌ ጉዬ ኢዛ ኣዋ ዪሳቂ፥ «ታ ናዞ! ሃ ሺቃዳ ታና ዬራ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ያቆቤይ ሺቂዲ ኢዛ ዬሪዴስ፤ ዪሳቂ ኢዛ ማይኦ ሲንጊ ሲዪዲ፥ «ታ ናዛ ፔኖይ ጎዳይ ኣንጂዳ ጎሻ ማላ ሳዌስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ጾሲ ሳሎ ኢራኔ ሳኣ ኣንጆ፥ ካꬂኔ ኦራꬃ ዎይኔ ኡሹ ፓላሂሲዲ ኔስ ኢሞ። ");
INSERT INTO gmve_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","ካዎቴꬃቲ ኔስ ሃሬቴቶ፤ ኣሲ ዉሪ ኔስ ጉልባቶ፤ ኔኒ ኔ ኢሻታስ ጎዳ ጊዳ፤ ኔ ኣዬይ ዜሬꬂ ኔስ ጉልባቶ፤ ኔና ቃንጊዛይ ቃንጌቲዳዝ ጊዶ፤ ኔና ኣንጂዛይ ኣንጄቲዳይሳ ጊዶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ዪሳቂ ያቆቤ ኣንጂ ዉርሲዳፔ ጉዬ ያቆቤይ ባ ኣዋ ዪሳቃ ሲንꬃፌ ኬዚዳ ማላ ኤሳዌይ ሻንካፌ ፑቱ ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ኢዚካ ቃሴ ማልኦ ቁማ ካꬂዲ ባ ኣዋስ ኣꬂዴስ፤ ኣꬂዲ ኢዛ፥ «ታ ኣዋዉ! ሱራዳ ሃይሳ ታኒ ሻንካቲዳይሳፌ ማ፤ ሂስታዳ ታና ኣንጃ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ሂስቲን ኣዋይ ዪሳቂ ኢዛ፥ «ኔ ኦኔ?» ጊ ኦይቺዴስ። ኢዚ፥ «ታኒ ኔስ ባይራ ናዛ ኤሳዌ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ዪሳቂ ዳጋሚዲ ኮኮሪሼ፥ «ሂስቲን ዶኣ ሻንካቲዳይሳ ኤኪዲ ታስ ኣꬂዳይ ኦኔ? ታኒ ሃኢ ኔኒ ያናፔ ሲንꬄ ማዳ ኢዛ ኣንጃዲስ፤ ቱሙካ ኢዚ ኣንጄቲዳይሳ ጊዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ኤሳዌይ ባ ኣዋ ቃላ ሲዪዳ ማላ ባ ቃላ ꬎቁ ሂስታዲ ዳሮ ጫሞ ዬሆ ዬኪዲ ባ ኣዋ፥ «ታና ኣንጃ፤ ታ ኣዋዉ ታናካ ኣንጃ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ጊዶ ኣቲን ኢዚ፥ «ኔ ኢሻይ ዪዲ ታና ጪሚዲ ኔ ኣንጆ ኤኪቺዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ኤሳዌይ፥ «ኢዛ ኤሪዲ ያቆቤ ጊ ሱንꬂዴስ፤ ኢዚ ታና ጪሚሺን ሃይሲ ናምኣንꬆ፤ ኢዚ ታ ባይራቴꬃ ኤኪዴስ፤ ቃሴ ሃኢካ ታ ኣንጆ ኤኪዴስ» ጊዴስ፤ ቃሴ ዛሪዲ ባ ኣዋ፥ «ኔኒ ታስ ኣንጆፌ ኣይኮካ ኣሻቤኪ?» ጊ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ዪሳቂ ኤሳዌስ፥ «ታኒ ኢዛ ኔ ቦላ ጎዳታና ማላ፥ ኢዛ ኢሻቲ ኢዛስ ኦꬃና ማላ፥ ካꬂኔ ዎይኔ ኡሺ ፓላሃና ማላ ኣንጃዲስ፤ ሂስቲን ታ ናዞ ታ ኔስ ሃኢ ኣይ ኦꬃና ዳንዳያዚና?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ኤሳዌይ ባ ኣዋ፥ «ታ ኣዋዉ ኔስ ዲዛይ ኢሲ ኣንጆ ጻላ? ታ ኣዋዉ! ታናካ ኣንጃርኪ!» ጊዴስ። ሄሳፌ ጉዬ ኤሳዌይ ባ ቃላ ꬎቁ ሂስቲዲ ዬኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","ኢዛ ኣዋ ዪሳቂ ዛሪዲ፥ «ኔ ዲዛሶይ ሃ ሳኣ ዱሬቴꬃፌ ሃካና፤ ሳሎ ኢራይካ ኔስ ቡኬና። ");
INSERT INTO gmve_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ኔኒ ኔ ጊꬃ ማሻን ኣቃና፤ ኔኒ ኔ ኢሻስ ሃሬታና፤ ጊዶ ኣቲን ኔኒ ኢዛራ ኤቄቲኮ ኢዛ ቃምባራ ኔ ሞርጌፌ ዲጋና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ኣዋይ ያቆቤ ኣንጂዳ ጊሻስ ኤሳዌይ ያቆቤ ኬሂ ኢጺዴስ፤ ኢዚ ባ ዎዚናራ፥ «ታ ኣዋይ ሃይቃና ማቲዴስ፤ ኢዚ ሃይቂዳ ማላ ታ ኢሻ ያቆቤ ታ ዎꬋና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ጊዶቲን ኢርቢቃይ ሃይሳ ባ ባይራ ናዛ ኤሳዌ ቃላ ሲዪዳ ጊሻስ ባ ካሎ ና ያቆቤ ጼይጊሳ ኤሃዳ፥ «ኔ ኢሻይ ኤሳዌይ ኔና ዎꬊዲ ሃሎ ኬሳናስ ኮዬስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ሃኢካ ታ ናዞ፥ ታኒ ኔስ ዮቲዛይሳ ኦꬃ። ዴንዳ! ዴንዳዳ ካራኔን ዲዛ ታ ኢሻ ላባኮ ባቃታ! ");
INSERT INTO gmve_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ሂስታዳ ኔ ኢሻ ሃንቆይ ዶቻና ጋካናስ ኢማꬃቴꬃን ኢዛራ ዳሻ። ");
INSERT INTO gmve_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ኔ ኢሻይ ኔስ ሃንቄቲዛይሳ ኢዚ ኣጊዛ ዎዴኔ ኔ ኢዛ ቦላ ኦꬂዳይሳ ኢዚ ባሊዛ ዎዴ ታኒ ኪታዳ ኔና ሄፔ ኤሂሳና፤ ታኒ ኢሲ ጋላስ ኢንቴፌ ናምኣታፔ ሜላ ኣታና ማላ ኮይኬ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ሄሳፌ ጉዬ ኢርቢቃይ ዪሳቃ፥ «ኤሳዌይ ኤኪዳ ሂቴታ ማጫ ናይታ ጌዶን ዱሳይ ታና ኢቴስ፤ ቃሴ ያቆቤይካ ሄይታ ማላ ሂቴታ ማጫ ናይታፔ ማቾ ኤኪኮ ታኒ ሄኮ ሃይቃናስ ኮያይስ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ሄሳ ጊሻስ ዪሳቂ ያቆቤ ጼይጊዲ፥ «ካናኔ ኣሳ ማጫ ናይታፔ ኔስ ማቾ ኤኮፋ። ");
INSERT INTO gmve_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ዴንዳዳ ኔ ኣዬይ ኣዋ ባቱኤሌኮ፥ ሜስጴጾሚያ ቢታ ባዳ ሄፔ ኔ ኣዬይ ኢሻ ላባ ማጫ ናይታፔ ኢሲኒዮ ኔስ ማቾ ኤካ። ");
INSERT INTO gmve_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ኡባ ዳንዳይዛ ጾሲ ኔና ኣንጆ፤ ኢዚ ኔስ ዳሮ ናይታ ኢሞ፤ ኔና ዳሮ ዴሬስ ኣዋ ሂስቶ። ");
INSERT INTO gmve_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ኣብራሃሜ ኣንጂዳ ማላ ኔናኔ ኔ ዜሬꬅ ጾሲ ኣንጆ፤ ሃይሳ ኣብራሃሜይ ኢሚዳ ቢታኔ ኔካ ኢማꬃቴꬃን ዴኢዳ ቢታ ኔስ ኢሞ» ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ሂስቲን ዪሳቂ ያቆቤ ዬዲን ያቆቤይ ሜስጴጾሚያ ቢታ ላባኮ ቢዴስ። ላባይ ያቆቤኔ ኤሳዌ ዬሊዳ ኢርቢቃስ ኢሻኔ ኣራሜ ቢታ ኣስ ባቱኤሌ ና። ");
INSERT INTO gmve_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ዪሳቂ ያቆቤ ኣንጂዳይሳ ሄፔ ማቾ ኤካናስ ሜስጴጾሚያ ቢታ ኢዛ ዬዲዳይሳ ቃሴካ ኢዚ ያቆቤ ኣንጂዳ ዎዴ፥ «ካናኔ ማጫስ ኤኮፋ» ጊ ኣዛዚዳይሳ ሲዪዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ያቆቤይካ ባ ኣዋሲኔ ባ ኣዬይስ ኣዛዜቲዲ ሜስጴጾሚያ ቢታ ቢዳይሳ ኤሳዌይ ኤሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ኤሳዌይ ኢዛ ኣዋ ዪሳቃይ ካናኔ ማጫ ናይታ ኣይ ማላ ኢጺዛኮኔ ሄሳን ኤሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ሄሳ ጊሻስ ኤሳዌይ ኣብራሃሜ ና ኢስማኤሌኮ ቢዲ ኢዛ ናዮ ማሂላቶ ባ ማቼይ ቦላ ጉጂ ኤኪዴስ። ኢዛካ ኔባዮቴ ሚቾ። ");
INSERT INTO gmve_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ያቆቤይ ቤርሳቤሄፔ ካራኔ ባናስ ዴንዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ኢዚ ኢሲ ሶ ጋኪሺን ኣርሼይ ዉሊን ሄን ኣቂዴስ፤ ሄ ሶን ዲዛ ሹቻታፔ ኢሲ ሹች ኤኪ ቦርኮቲዲ ሄን ꬊስኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ኣጉሞዛን ቢታን ኤቂዲ ጼራይ ፑዴ ሳሎ ጋኪዛ ያንጋሬ ቤኢዴስ፤ ያንጋሬዛ ቦላ ጾሳ ኪታንቻቲ ዱጌ ዎꬊሺኒኔ ፑዴ ኬዚሺን ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ያንጋሬዛስ ቦላ ጼራን ጎዳይ ኤቂዲ ኢዛ፥ «ታኒ ጎዳ ኔ ኣዋ ኣብራሃሜ ጾሳ፥ ዪሳቃ ጾሳ። ሃ ኔ ኢቺዳ ቢታ ታ ኔሲኔ ኔ ዜሬꬃስ ኢማና። ");
INSERT INTO gmve_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ኔ ዜሬꬃይ ቢታ ኣጬ ማላ ዳራና፤ ኢስቲካ ኦይዱ ባጋ ጋካና፤ ቢታ ቦላን ዲዛ ኣሲ ዉሪ ኔ ባጋራኔ ኔ ዜሬꬃ ባጋራ ኣንጄታና። ");
INSERT INTO gmve_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ታኒ ኔናራ ዳይስ፤ ኔኒ ቢዛሶ ኡባን ታኒ ኔና ናጋና፤ ቃሴ ታኒ ኔና ሃ ቢታ ጉዬ ዛራዳ ኤሃና፤ ታኒ ኔስ ኦꬃና ጊዳይሳ ኦꬃና፤ ኔናካ ዬጊኬ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ያቆቤይ ꬊስኮፌ ቤጊዲ፥ «ታኒ ኤራቤኬፌ ኣቲን ጎዳይ ቱሙ ሃይሳን ዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ኢዚ ባቢዲ፥ «ሃይሲ ኣይ ማላ ባቢሲዛሶ! ሃይሲ ጾሳ ኬꬃፌ ኣቲን ሃራሶ ዴና፤ ሃይሲ ሳሎ ፔንጌ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ያቆቤይ ዎንቴꬃ ጋላስ ማላዶ ዎንታራ ዴንዲዲ ባ ቦርኮቲዳ ሹቻ ኤኪዲ ቱሳ ማላ ኤሲዲ ጾሳስ ዱማሳናስ ኢዛ ቦላ ዛይቴ ጉሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ያቆቤይ ሄ ሶሆዛ ቤቴሌ ጊ ሱንꬂዴስ፤ ሄ ካታማያ ሄሳፌ ካሴ ሎዛ ጌቴታዉስ። ");
INSERT INTO gmve_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","21","ያቆቤይ፥ «ኔ ታናራ ጊዳዳ ታ ቢዛ ኦጌን ኔ ታና ናጊኮ ታስ ሚዛ ቁማኔ ማይኦ ኔ ኢሚኮ ታ ኣዋ ሶ ሳሮን ኔ ታና ዛሪኮ ኔኒ ጎዳይ ታ ጾሳ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ታኒ ቱሳ ማላ ኤሲዳ ሃ ሹቻይ ጾሳ ኬꬅ ጊዳና፤ ኔኒ ታስ ኢሚዛ ኡባፌ ታማፌ ኢሲ ኩሼ ታኒ ኔስ ኢማና» ጊ ኣዲኔቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ሄሳፌ ጉዬ ያቆቤይ ዴንዲ ቢዲ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ኣሳታ ዴሬ ጋኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ሂስቲዲ ኢሲ ዴምባን ሃꬃ ኦላይ ዲዛይሳ ቤኢዴስ፤ ሄꬑ ጩጋ ዶርሲ ቃሴ ሄ ሃꬃ ኦላ ኣቻን ኢቺዴስ፤ ኣይስ ጊኮ ዉዴይ ዉሪ ሃꬅ ኡዪዛይ ሄ ኦላዛፔ፤ ሄ ሃꬃ ኦላ ዶና ቱቻ ሹቻይካ ጊታ። ");
INSERT INTO gmve_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ዶርሳ ዉዴይ ዉሪ ሄን ሺቂዳ ዎዴ ዉዴዛ ሄሚዛይቲ ሃꬃ ኦላ ዶናፔ ሄ ሹቻ ጌንዴሪሲዲ ዶርሳ ኡሼቴስ። ኡሺዲ ሄ ሹቻ ሃꬃ ኦላን ዛሪዲ ቱጬቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ያቆቤይ ኢስታስ፥ «ሃይቶ! ኢንቴ ኣዋፔ ዪዴቲ?» ጊ ኦይቺዴስ። ኢስቲካ፥ «ኑኒ ካራኔፔ ዪዶስ» ጊ ዮቲን፥ ");
INSERT INTO gmve_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ኢዚ፥ «ናኮሬስ ናዛ ና ላባ ኤሬቲ?» ጊዴስ። ኢስቲካ፥ «ኤ፥ ኢዛ ኑ ኤሮስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ያቆቤይ ኢስታስ፥ «ኢዚ ሎኦ ዲዜ?» ጊ ኦይቺን፥ «ኤ፥ ሎኦኮ፤ ኢዛ ና ኤራሄሎ ዶርስ ኤካ ዪዛሮ ሃኖ ቤያ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ሂስቲን ያቆቤይ ኢስታስ፥ «ቤኢቴ! ኣርሼይ ሃኢ ꬎቃን ዴስ፤ ሜሄ ሶ ሺሺዛ ዎዴይ ቡሮ ጋኪቤና፤ ዶርሳታ ሃꬅ ኡሺዲ ኤፊ ሄሚሺቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ጊዶ ኣቲን ኢስታስ፥ «ሜሄይ ዉሪ ሺቃና ጋካናስ፥ ሹቻ ሃꬃ ኦላዛ ዶናፔ ጌንዴሪሳና ጋካናስ ኑኒ ኡሻናስ ዳንዳዮኮ፤ ሄሳፌ ጉዬ ኑኒ ሜሃ ኡሻና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ኢዚ ቡሮ ሃሳያን ዲሺን ዶርሳታ ሄሚዛይ ኢዞ ጊዲዳ ጊሻስ ላባ ናያ ኤራሄላ ባ ኣዋ ዶርሳታ ላጋ ኤካዳ ጋካ ዎꬋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ያቆቤይ ባ ኣዬይ ኢሻ ላባ ና ኤራሄሊ ዶርሳታ ቤኢዳ ዎዴ ቢዲ ኦላ ዶናፔ ሹቻ ጌንዴሪሲዲ ባ ኣዬይ ኢሻ ዶርሳታ ሃꬅ ኡሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ያቆቤይ ኤራሄሎ ዬሪዲ ኡፋይሳፌ ዴንዲዳይሳን ባ ቃላ ꬎቂሲዲ ዬኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ያቆቤይ ኢዚስ ኣዋ ዳቦኔ ኢርቢቃ ና ጊዲዳይሳ ኤራሄሊስ ዮቲን ኢዛ ዎጻ ባዳ ባ ኣዋስ ዮታዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ላባይ ባ ሚቼይ ና ያቆቤ ዎሬ ሲዪዳ ማላ ኢዛራ ጋጋናስ ዎጺዴስ፤ ዎጺ ጋኪዲ ኢዛ ኢዲሚ ዬሪ ኤኪዲ ባ ሶ ኤፊዴስ፤ ሄን ያቆቤይ ባ ሃኒዳይሳ ኡባ ላባስ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ላባይ ኢዛ፥ «ኔኒ ቱሙ ታ ኣሾኔ ታ ሱꬃ» ጊዴስ። ያቆቤይ ኢዛራ ኢሲ ኣጊና ኩሜꬅ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ሄሳፌ ጉዬ ላባይ ኢዛ፥ «ኔኒ ታስ ዳቦ ጊዲዳ ጊሻስ ታስ ጮ ሜላ ኦꬃኔ? ኣኔ ኔስ ኣይ ቃንጻናስ ቤሲዛኮ ታስ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ላባስ ናምኡ ማጫ ናይቲ ዴቴስ፤ ባይራይ ሱንꬂ ሊያ፥ ካሎያ ኤራሄሎ። ");
INSERT INTO gmve_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ሊያ ኣይፌይ ሾላ፤ ኤራሄሊ ኣይፌይ ጊዲኮ ሎኦ። ");
INSERT INTO gmve_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ያቆቤይ ኤራሄሎ ሲቂዳ ጊሻስ፥ «ታኒ ኔስ ካሎ ናዮ ኤራሄሊ ጊሻስ ኔስ ላፑን ላይꬅ ኦꬃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","ላባይ፥ «ኢዞ ሃራ ኣሳስ ኢማናፔ ኔስ ኢሚዛይሲ ሎኦ፤ ኔኒ ታናራ ሃይሳን ዴያ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ሄሳ ጊሻስ ያቆቤይ ኤራሄሎ ኤካናስ ላፑን ላይꬅ ኦꬂዴስ፤ ጊዶ ኣቲን ኢዚ ኢዞ ሲቂዛ ጊሻስ ኢዛስ ዎዴዚ ኬሂ ቃንꬅ ሚሳቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ሄሳፌ ጉዬ ያቆቤይ ላባ፥ «ታ ማቾ ታስ ኢማ፤ ታ ዎዴይ ዉሪዴስ፤ ታኒ ኢዞ ኤካና ኮያይስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ሄሳ ጊሻስ ላባይ ሄን ዲዛ ኡባ ኣሳ ጼይጊ ሺሺዲ፥ ቡላቻ ኬሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ጊዶ ኣቲን ጋዴይ ቃሚን ኢዚ ባ ና ሊያ ኤፊዲ ያቆቤስ ኢሚዴስ፤ ያቆቤይካ ኢዞ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ቃሴ ላባይ ባ ኣይሌዮ ዚልፎ ባ ና ሊያስ ኣይሌ ጊዳና ማላ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ጋዴይ ዎንቲን ጼሊዛ ዎዴ ሄኮ ሊያ ጊዳዱስ! ሂስቲን ያቆቤይ ላባ፥ «ሃይሲ ኔኒ ታ ቦላ ኦꬂዳይሲ ኣዜ? ታኒ ኔስ ኦꬂዳይ ኤራሄሊ ጊሻስ ዴኔ? ታና ኣይስ ጪማዲ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","ላባይ ኢዛ፥ «ኑ ቢታን ባይራያ ዲሺን ካሎዮ ኣዚናስ ኢሚዛይሲ ዎጋ ዴና። ");
INSERT INTO gmve_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ሄ ሚሺራቴꬃ ሳሚንታ ኡባ ዉርሳ፤ ቃሴ ካሎቲዛሮካ ኑኒ ኔስ ኢማና፤ ሄሳፌ ጉዬ ሃራ ላፑን ላይꬅ ታስ ኦꬃሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ያቆቤይ ሄሳꬆ ሃኒዲ ሄ ሳሚንታ ዉርሲዴስ፤ ሄሳፌ ጉዬ ላባይ ባ ናዮ ኤራሄሎ ኢዛስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ቃሴ ላባይ ባ ኣይሌዮ ቢሊሃ ባ ና ኤራሄሊስ ኣይሌ ጊዳና ማላ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ያቆቤይ ኤራሄሎካ ኤኪዴስ፤ ኤራሄሎ ሊያፔ ኣꬂ ሲቂዴስ፤ ሃራ ላፑን ላይꬅ ላባስ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ያቆቤይ ሊያ ኤራሄሊ ማላ ሲቆንታይሳ ቤኢዲ ጎዳይ ኢዚስ ዬሊዛ ኡሎዛ ዶይዴስ፤ ጊዶ ኣቲን ኤራሄሊስ ናይ ባ። ");
INSERT INTO gmve_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ሊያይ ሻራዳ ኣቱማ ና ዬላዱስ፤ ኢዛ ሱንꬃካ ኦሮቤሌ ጋ ሱንꬃዱስ፤ ኣይስ ጊኮ ኢዛ፥ «ጎዳይ ታ ሜቶ ቤኢዴስ፤ ሃኢ ቱሙ ታና ታ ኣዚናይ ሲቃና» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ኢዛ ቃሴካ ሻራዳ ሃኢካ ኣቱማ ና ዬላዱስ፤ ኢዛ፥ «ጎዳይ ታኒ ዶሴቶንታይሳ ቤኢዳ ጊሻስ ታስ ሃይሳካ ጉጂዴስ» ጋዳ ኢዛ ሲሞና ጋ ሱንꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ኢዛ ቃሴካ ሻራዳ ኣቱማ ና ዬላዱስ፤ ኢዛ፥ «ታኒ ኢዛስ ሄꬑ ኣቱማ ናይታ ዬሊዳ ጊሻስ ታ ኣዚናይ ባ ዎዚና ታኮ ዛራና» ጋዳ ኢዛ ሌዌ ጋ ሱንꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ኢዛ ቃሴካ ቃንꬃታዳ ኣቱማ ና ዬላዳ ኢዛ፥ «ሂኣ ታኒ ጎዳ ጋላታና» ጋዱስ፤ ሄሳ ጊሻስ ኢዛ ዩሁዳ ጋ ሱንꬃዱስ፤ ሄሳፌ ጉዬ ዬሎ ኤሳዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ኤራሄላ ያቆቤስ ናይ ኢዚፔ ዬሌቶንታይሳ ኤራዳ ባ ሚቼይ ቦላ ቃናታዱስ፤ ሄሳ ጊሻስ ኢዛ ያቆቤ፥ «ታስ ና ኢማ፤ ኢጺስ ጊኮ ታ ሃይቃና» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ያቆቤይ ኤራሄሊ ቦላ ሃንቄቲዲ፥ «ታና ኔስ ዬሎ ዲጋናስ ጾሳ ጋዲ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ኢዛካ፥ «ታ ኣይሌዮ ቢሊሃ ሂኖ ቤኣ፤ ኢዛ ታ ጊሻስ ዬላና ማላ ኔኒ ኢዞ ኤካ፤ ሂስቲኮ ኢዚ ባጋራ ታኒካ ና ኣዮ ጊዳና» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","ኤራሄላ ባ ኣይሌዮ ቢሊሃ ማቾ ሂስቲ ኤካና ማላ ኢዛስ ኢሚን ያቆቤይ ኢዞ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ቢሊሃ ሻራዳ ኣቱማ ና ያቆቤስ ዬላዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ሂስቲን ኤራሄላ፥ «ጾሲ ታስ ፒርዲዴስ፤ ታ ዎሳካ ሲዪዲ ታስ ኣቱማ ና ኢሚዴስ» ጋዱስ፤ ሄሳ ጊሻስ ዬሌቲዳ ናዛ፥ «ዳኔ» ጋ ሱንꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ኤራሄሊ ኣይሌያ ቢሊሃይ ቃሴካ ሻራዳ ያቆቤስ ናምኣንꬆ ኣቱማ ና ዬላዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ኤራሄላካ፥ «ታኒ ታ ሚቼይራ ዎልቃማ ባጼ ባጼታዳ ጾናዲስ» ጋሼ ናዛ ኒፍታሌሜ ጋ ሱንꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ሊያይ ባስ ዬሎይ ኤቂዳይሳ ቤያዳ ባ ኣይሌዮ ዚልፎ ኤፋዳ ያቆቤስ ማቾ ሂስታ ኢማዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ሊያ ኣይሌ ዚልፋ ያቆቤስ ኣቱማ ና ዬላዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","ሊያይካ፥ «ሃይሲ ኣይ ማላ ሎኦ ቃዳ!» ጋሼ ናዛ ጋዴ ጋዳ ሱንꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ሊያ ኣይሌያ ዚልፋይ ያቆቤስ ናምኣንꬆ ኣቱማ ና ዬላዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ሊያይካ፥ «ታኒ ኬሃ ኡፋዬታዲስ! ማጫሳይካ ታና ኡፋዬቲዛሮ ጋና» ጋዱስ፤ ሄሳ ጊሻስ ኢዛ ናዛ ኣሴሬ ጋ ሱንꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ጊስቴ ማጻ ኣጊናን ኦሮቤሌይ ጋዴ ጊዶ ቢዲ ኢንኮዬ ቴራ ዴሚዲ ባ ኣዮ ሊያስ ኤሂዴስ፤ ኤራሄላ ሊያ፥ «ኔ ናይ ኤሂዳ ኢንኮዬዛፔ ኣኔ ታስ ኢማ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","ጊዶ ኣቲን፥ «ኔ ታ ኣዚናዛ ታፔ ዎꬃ ኤኪዳይሲ ጊዶንታ ኢጺን ቃሴ ታ ናዛ ኢንኮዬዛ ኤካኔ?» ጋዱስ። ኤራሄላካ፥ «ሂስቲኮ ኔ ናዛ ኢንኮዬዛ ጊሻስ ያቆቤይ ሃቻ ቃማ ኔናራ ኣቆ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ሄ ጋላሳ ኦማርስ ያቆቤይ ኦሶሶፔ ሲሚሺን ሊያይ ኢዛ ሞካናስ ኬዛዳ፥ «ኔኒ ታናራ ኣቃና ኮሼስ፤ ኣይስ ጊኮ ታኒ ታ ና ኢንኮዬዛን ኔና ኪራስ ኤካይቻዲስ» ጊን ኢዚ ሄ ጋላሳ ኦማርስ ኢዚራ ኣቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ጾሲ ሊያ ዎሳ ሲዪዴስ፤ ሄሳ ጊሻስ ኢዛ ቃንꬃታዳ ኢቻሻንꬆ ኣቱማ ና ያቆቤስ ዬላዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ሊያይካ፥ «ታኒ ታ ኣይሌዮ ታ ኣዚናስ ኢሚዳ ጊሻስ ጾሲ ሄሳ ኪራ ታስ ቃንጺዴስ» ጋሼ ናዛ ዪሳኮሬ ጋዳ ሱንꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ሊያይ ቃሴካ ሻራዳ ኡሱፑንꬃ ኣቱማ ና ያቆቤስ ዬላዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ሊያይ፥ «ጾሲ ታስ ኣልኦ ኢሞታ ኢሚዴስ፤ ታኒ ታ ኣዚናስ ኡሱፑን ናይታ ዬሊዳ ጊሻስ ሃኢ ኢዚ ታና ቦንቻና» ጋዱስ። ሄሳ ጊሻስ ኢዛ ናዛ ዛቢሎኔ ጋ ሱንꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ሄሳፌ ጉዬ ኢሲ ማጫ ና ዬላዳ ኢዞ ዲና ጋ ሱንꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ጾሲ ኤራሄሎ ቆፒዴስ፤ ኢዚ ዎሳካ ሲዪዲ ኢዚስ ዬሊዛ ኡሎ ዶይዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ኢዛካ ሻራዳ ኣቱማ ና ዬላዱስ፤ «ጾሲ ታ ዬላ ታፔ ዴንꬂዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ጎዳይ ታስ ሃራ ኣቱማ ናካ ጉጄሬኔ!» ጋሼ ናዛ ዮሴፌ ጋ ሱንꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ኤራሄላ ዮሴፌ ዬሊዳፔ ጉዬ ያቆቤይ ላባ፥ «ታኒ ታ ኣዋ ቢታ ሲማና ማላ ታና ሞይዛ። ");
INSERT INTO gmve_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ታኒ ኢስታ ጊሻስ ኔስ ኦꬂዳ ታ ማቼታኔ ታ ናይታ ታስ ኢማ፤ ታኒ ባና፤ ኣይስ ጊኮ ታኒ ኔስ ኣይ ማላ ኦꬂዳኮ ኔ ኤራሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ቃሴ ላባይ ኢዛስ፥ «ታኒ ኔስ ኢሲ ሚሽ ዮታይስ፤ ጎዳይ ኔ ጌዶን ታና ኣንጂዳይሳ ታ ቤያዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ኔ ኤካና ዳሞዛ ታስ ዮታ፤ ታኒ ኔስ ኢዛ ቃንጻና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ያቆቤይ፥ «ታኒ ኔስ ዎስታ ኦꬂዳኮ ኔ ሜሄይካ ዋኒ ዬሌቲዳኮ ኔኒ ኤራሳ። ");
INSERT INTO gmve_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ታኒ ያናፔ ካሴ ኔስ ዲዛ ጉꬃይ ሃኢ ኬሂ ዳሪዴስ፤ ታ ኣꬊዳ ኡባሶን ጎዳይ ኔና ኣንጂዴስ፤ ጊዶ ኣቲን ሃኢ ታኒ ታሶ ኣሳስ ኣይዴ ኦꬆ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ላባይ፥ «ታኒ ኔስ ኣይ ኢሞ?» ጊ ኢዛ ኦይቺን፥ ያቆቤይ፥ «ታስ ኣይኮካ ኢሞፋ፤ ጊዶ ኣቲን ኔኒ ታስ ኢሲ ሚሽ ኦꬂኮ ታኒ ኔ ዉዴዛ ቃሴካ ሄማናኔ ናጋና። ");
INSERT INTO gmve_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ታኒ ሃች ኔ ሜሄ ኡባ ጊዶራ ኣꬋና፤ ሄን ኔ ዶርሳፌ ማሳራ ዎይኮ ፑንጫራ ኡባ፥ ዶርሳ ላቃ ካሬꬃታ ኡባ፥ ዴይሻፌ ፑንጫራኔ ማሳራ ጊዲዳይታ ኡባ ታ ሻካና፤ ሄይታንቲ ታ ዳሞዛ ጊዴቶ። ");
INSERT INTO gmve_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ሄሳ ጊሻስ ታ ጺሎቴꬂ ኔኒ ታስ ቃንጺዳ ዳሞዛ ታይባናስ ሲንꬃፌ ኔ ዪዛ ዎዴ ኤሬታና፤ ታ ዴይሻፌ ጻላቃ ጊዶንታይ ዎይኮ ካሬꬅ ጊዶንታ ኢሲ ላቃይ ታ ኣቻን ቤቲኮ ካይሶቲዳ ማላ ቆዴቶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ላባይ፥ «ኔ ጊዳ ማላ ጊዶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ሄ ጋላሲካ ላባይ ጻላቃ ጊዲዳ ኦርጌታ ኡባ፥ ጻላቃ ጊዲዳ ማጫ ዴይሼታኔ ካሬꬃ ዶርሳ ላቃታ ኡባ ኬሲዲ ሄማና ማላ ባ ኣቱማ ናይታስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ሂስቲዲ ሄ ሜሄዛራ ሄꬑ ጋላሳ ኦጌ ያቆቤፔ ሃኪ ቢዴስ፤ ጊዶ ኣቲን ያቆቤይ ኣቲዳ ላባ ሜሄታ ሄንꬅ ጌሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ያቆቤይ ሚꬃፌ ቃዬ ጉፌ ኬሲዲ ባጋ ፖቂዲ ባጋ ፖቆንታ ኣጊዲ ጉፌዛ ባጋ ካሬꬅ፥ ባጋ ቦꬅ ሂስቲዲ ዋራርዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ሜሄይ ሃꬄ ኡያና ዪዛ ኡባ ዎዴ ሜሄቲ ሃꬅ ኡዪዛ ጎንጌ ጊዶን ጉፌታ ዎꬂዴስ፤ ሜሄቴꬅ ኬዚዳ ሜሄቲ ሃꬅ ኡያናስ ዪዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ሄ ጉፌታ ሲንꬃን ሜሄቲዳ፤ ኢስቲካ ማሳራ፥ ጻላቃኔ ባታካ ላቃታ ዬሊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ያቆቤይ ላቃታ ሜሄታፔ ሻኪዲ ዱማ ዎꬂዴስ፤ ኣቲዳ ሜሄታ ማሳራኔ ጻላቃ ጊዲዳይታ ላባ ሜሄ ሲንꬅ ዛሪዴስ፤ ሄሳꬆ ያቆቤይ ባ ሜሄ ላባ ሜሄራ ዋላኬቶንታ ማላ ዱማ ሻኪ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","ጎባ ሚኖ ማጫ ዶርሳቲኔ ዴይሻቲ ሜሄቴꬅ ኬዚዛ ዎዴ ኣይዴ ጊዲንካ ኢስቲ ሄ ጉፌታ ኣቻን ሜሄታና ማላ ያቆቤይ ሄ ጉፌታ ሃꬃ ጎንጌ ጊዶን ሜሄታ ሲንꬃን ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ጉፌዛ ላፋ ሜሄታ ሲንꬃን ዎꬄና፤ ሄሳ ጊሻስ ላፋ ላፋ ሜሄቲ ላባስ ጊዲን ጎቢዛይቲ ያቆቤስ ጊዲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ሄሳꬆ ሃኒዲ ያቆቤይ ኬሂ ዱሬቲዲ፥ ዳሮ ሜሄ ዉዴ፥ ማጫ ኣይሌታኔ ኣቱማ ኣይሌታ፥ ዳሮ ጋሜላታኔ ሃሬታ ሃሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ላባ ኣቱማ ናይቲ ባ ጊዶን፥ «ያቆቤይ ኑ ኣዋ ሃሮ ኡባ ኤኪዴስ፤ ሃይሲ ኡባይ ኢዚ ሺሺዳ ኣቆታይ ኑ ኣዋፔ ቤቲዳዛ» ጊ ሃሳይሺን ያቆቤይ ሲዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ያቆቤይ ላባ ኣይፌሶይ ኢዛስ ካሴ ማላ ጊዶንታይሳ ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ሄ ዎዴ ጎዳይ ያቆቤ፥ «ኔኒ ኔ ኣዋታ ቢታ ኔ ዳቦታኮ ጉዬ ሲማ፤ ታኒ ኔናራ ጊዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ሄሳ ጊሻስ ያቆቤይ ኤራሄሎኔ ሊያ ባ ሜሄይ ዲዛሶ ያና ማላ ኪቲዲ ጼይጊሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ኢዚ ኢስታስ፥ «ኢንቴ ኣዋ ኣይፌሶይ ታስ ካሴይሳ ማላ ጊዶንታይሳ ታኒ ቤኣዲስ፤ ጊዶ ኣቲን ታ ኣዋ ጾሲ ታናራ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","ታኒ ታ ኩሜꬃ ዎልቃፌ ኢንቴ ኣዋስ ኦꬂዳይሳ ኢንቴ ኤሬታ። ");
INSERT INTO gmve_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ጊዶ ኣቲን ኢንቴ ኣዋይ ታና ጪሚዲ ታ ዳሞዛ ታሙቶ ላሚ ላሚ ዬጊዴስ፤ ጊዲኮካ ኢዚ ታና ቆሆንታ ማላ ጾሲ ኢዛ ዲጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","ኢዚ፥ ‹ማሳራ ዶርሳቲኔ ዴይሻቲ ኔ ዳሞዛ ጊዳና› ጊን ዉዴ ሜሄቲ ዉሪ ማሳራ ጻላ ዬሊዳ፤ ቃሴ ኢዚ፥ ‹ጻላቃ ዶርሳቲኔ ዴይሻቲካ ኔ ዳሞዛ ጊዳና› ጊን ሜሄይ ዉሪ ጻላቃ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ጾሲ ሃይሳꬆ ኢንቴ ኣዋፔ ዎꬂ ኤኪዲ ኢንቴ ኣዋ ሜሄ ታስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","«ሜሄቲ ሜሄቴꬅ ኬዚዛ ኣጊናን ኣጉሞራ ሜሄታ ሜሄሲዛ ዴይሻ ኦርጌቲ ማሳራ፥ ጻላቃኔ ባታካ ጊዲዳይሳ ቤያዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ጾሳ ኪታንቻይ ኣጉሞን ታና፥ ‹ያቆቤ!› ጊ ጼይጊን ታኒ፥ ‹ዬ!› ጋዳ ኮያዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ኢዚካ ታና፥ ‹ꬎቁ ጋዳ ሜሄታ ሜሄቲሲዛ ዴይሻ ኦርጌቲ ዉሪ ማሳራኔ ጻላቃ ጊዲዳይሳ ቤያ፤ ጋሶይካ ላባይ ኔ ቦላ ኦꬂዛይሳ ኡባ ታ ቤያዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","ኔኒ ሹች ኤሳዳ ዛይቴ ኢዛ ቦላ ቲጋዳ ኣዲኒዳ ቤቴሌ ጾሲ ታና፤ ሃኢ ዴንዳዳ ሃ ቢታፌ ኬዛዳ ኤሌላዳ ጉዬ ኔ ዬሌቲዳ ቢታ ሲማ› » ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ሄሳፌ ጉዬ ኤራሄላኔ ሊያይ ኢዛስ፥ «ኑ ኣዋይሳፌ ኑና ጋካናይ ኣዜ? ");
INSERT INTO gmve_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","ኢዚ ኑና ኣላጋ ማላ ጼሌስ ዴኔ? ኢዚ ኑና ባይዚ ኤኪዴስ፤ ባይዚዲ ኤኪዳ ሚሻካ ባስ ሚ ꬋይሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ጾሲ ኑ ኣዋፔ ዎꬂ ኤኪዲ ኔስ ኢሚዳ ሜሄይ ዉሪ ቱሙካ ኑሳኔ ኑ ናይታይሳ፤ ሄሳ ጊሻስ ጾሲ ኔስ ዮቲዳይሳ ኡባ ኦꬃ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","ሂስቲን ያቆቤይ ካናኔ ቢታን ዲዛ ባ ኣዋ ዪሳቃኮ ባናስ ዴንዲዴስ፤ ኢዚ ባ ናይታኔ ባ ማቼታ ጋሜላ ቶጊሲዴስ፤ ባስ ዲዛ ሜሄ ኡባ ሲንꬄ ኣꬂ ላጊዲ ሜስጴጾሚያን ዲሼ ኢዚ ሺሺዳ ሃሮ ኡባ ኤኪ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ላባይ ባ ዶርሳታ ኢስኬዛ ቃንጻናስ ቢቺዳሼ ኤራሄላ ባ ኣዋ ኤቃ ሚስሌታ ካይሳዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ያቆቤይካ ባ ባቃቲዛይሳ ኣራሜ ዴሬ ኣሲ ጊዲዳ ላባስ ዮቶንታ ባሌꬂ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ኢዚ ባስ ዲዛዝ ኡባ ሺሺ ኤኪ ባቃቲዲ ኤፊራጺሴ ሻፋ ፒኒዲ ጋላኣዴ ጌቴቲዛ ጌዜ ቢታ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ያቆቤይ ባቃቲ ቢዳይሳ ላባይ ሄꬓንꬆ ጋላስ ሲዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ባ ዳቦታ ባናራ ኤኪዲ ላፑን ጋላሳ ኦጌ ያቆቤ ጉዬ ካሊዲ ካሊዲ ጋላኣዴ ጌቴቲዛ ጌዜ ቢታን ኢዛ ጋኪ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ሄ ጋላሳ ኦማርስ ጾሲ ኣራሜ ላባኮ ኣጉሞራ ዪዲ፥ «ኔኒ ያቆቤ ቦላ ኢታ ጊዲን ኪያ ጊዲንካ ሃሳዮንታ ማላ ናጌታ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","ላባይ ጋኪዛ ዎዴ ያቆቤይ ጋላኣዴ ጌዜን ዱንካኒ ኡቲዴስ፤ ቃሴ ላባይኔ ኢዛ ዳቦቲ ሄን ዱንካኔ ቶኪዳ። ");
INSERT INTO gmve_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","ሄሳፌ ጉዬ ላባይ ያቆቤ፥ «ኔኒ ሃይሳꬆ ኣይስ ኦꬃዲ? ኔኒ ታና ጪማዳ ታ ማጫ ናይታ ኦላን ዲኤቲዳ ማላ ላጋዳ ኬሳዳሳ። ");
INSERT INTO gmve_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ኔኒ ኣይስ ቆታን ታፔ ኬሳ ኤካዳ ታና ጪማዲ? ታኒ ካራቤኒኔ ዲꬃን ኡፋይሳ ዬꬃን ኔና ሞይዛና ማላ ታስ ኣይስ ዮታቤኪ? ");
INSERT INTO gmve_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ኔኒ ሃራይ ኣቶ ታ ናይታ ናይታኔ ታ ማጫ ናይታ ታኒ ዬራ ኤኮንታ ማላ ዲጋዳሳ፤ ኔኒ ባላ ኦሶ ኦꬃዳሳ። ");
INSERT INTO gmve_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","ታኒ ኔና ቆሃናስ ታስ ዎልቃይ ዴስ፤ ጊዶ ኣቲን ኔ ኣዋ ጾሲ ቃማ ኦማርስ ታና፥ ‹ያቆቤ ቦላ ኢታ ጊዲን ኪያ ጊዲንካ ኢሲ ሚሽ ኔ ሃሳዮንታ ማላ ናጌታ!› ጊዲ ታስ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ሃኢ ጊዲኮካ ኔኒ ኔ ኣዋ ሶ ባናስ ኬሃ ላሞቲዳ ጊሻስ ኬኣዳሳ፤ ጊዶ ኣቲን ታሶ ኤቃ ሚስሌታ ኣዛስ ካይሳዲ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ያቆቤይ ላባ፥ «ኔኒ ኔ ናይታ ታፔ ዎልቃን ዎꬃ ኤካናኮ ጋዳ ባቢዳ ጊሻስ ሃይሳꬆ ኦꬃዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ጊዶ ኣቲን ኔ ሚስሌታ ኦይኪዳ ኣስ ኦናካ ኔኒ ዴሚኮ ሄ ኡራይ ሃይቆ! ኔስ ጊዲዳ ሚሺ ታ ኣቻን ቤቲኮ ኑ ዳቦቲ ቤዪሺን ኮያዳ ዴሚኮ ኔስ ኤካ» ጊዴስ፤ ጋሶይካ ያቆቤይ ኤራሄላ ኤቃ ሚስሌታ ካይሲዳይሳ ኤሪቤና። ");
INSERT INTO gmve_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ሄሳ ጊሻስ ላባይ ያቆቤ ዱንካኔ ጊዶ፥ ሊያ ዱንካኔ ጊዶኔ ናምኡ ኣይሌታ ዱንካኔ ጊዶ ጌሊዴስ፤ ጊዶ ኣቲን ኣይኮካ ዴሚቤና፤ ሊያ ዱንካናፔ ኬዚዲ ኤራሄሊ ዱንካኔ ጊዶ ጌሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ኤራሄላ ባ ኣዋ ኤቃ ሚስሌታ ኤካዳ ጋሜላ ኮራ ጋርሳን ቆታዳ፥ ኢዛ ቦላ ኡታዱስ። ላባይ ዱንካናን ዲዛይሳ ኡባ ፒልጊዲ ኮዪዴስ፤ ጊዶ ኣቲን ኣይኮካ ዴሚቤና። ");
INSERT INTO gmve_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ኤራሄላ ባ ኣዋ፥ «ታ ኣዋዉ! ታና ሃንቄቶፋ፤ ታኒ ኔስ ኤቃና ዳንዳይኬ፤ ታስ ማጫሳ ዎጋይ ዪዴስ» ጋዱስ። ኢዚ ኡባሶን ኮዪዴስ፤ ጊዶ ኣቲን ኤቃ ሚስሌታ ዴሚቤና። ");
INSERT INTO gmve_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ያቆቤይ ላባ ቦላ ሃንቄቲዲ፥ «ታኒ ኣይ ሞራዲና? ሄሳ ሲሬ ኔ ታና ካላናስ ታኒ ኦꬂዳ ናጋራይ ኣዜ? ");
INSERT INTO gmve_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ሃኢ ኔኒ ታ ሚሻ ኡባ ፒልጋዳ ኮያዳሳ ሺን ኣይ ዴማዲ? ኢስቲ ኔፔኔ ታፔ ኦኒ ዎርዶኮ ፒርዳና ማላ ሃ ዮኦዛ ታ ዳቦታ ሲንꬃኒኔ ኔ ዳቦታ ሲንꬃን ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","«ታኒ ኔናራ ናምኡ ታሙ ላይꬅ ኩሜꬅ ዴኣዲስ፤ ኔ ዶርሲኔ ዴይሻ ጊዲን ኣዉጫይቤና፤ ዎይኮ ኔ ሜሄፔ ጋልꬅ ማቤኬ። ");
INSERT INTO gmve_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ዶኣይ ዎꬊዳይሳካ ኡባ ታ ቦላ ቆዳዲስ ኣቲን ኔስ ኤሃቤኬ፤ ጋላስ ጊዲን ኦማርስ ካይሶይ ኤኪዳይሳ ታና ቃንጺሳዳሳ። ");
INSERT INTO gmve_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","ጋላስ ኣዋ ሴላይ፥ ኦማርስ ኬንቾይ ታና ቆሂዴስ፤ ꬊስኮይካ ታ ኣይፌፔ ꬋይዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ታኒ ሃይሳꬆ ኔ ሶን ናምኡ ታሙ ላይꬅ ዴኣዲስ፤ ኔ ማጫ ና ናምኣታ ጊሻስ 14 ላይꬅ፥ ኣቲዳ ኡሱፑን ላይꬅ ኔ ኢሚዳ ሜሄታ ጊሻስ ኔስ ኦꬃሼ ዴኣዲስ፤ ጊዶ ኣቲን ኔኒ ታ ዳሞዛ ታሙቶ ላማ ላማ ዬጋዳሳ። ");
INSERT INTO gmve_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ታ ኣዋቲ ኣብራሃሜይኔ ዪሳቂ ጎይኒዳ ጾሲ ታናራ ጊዶንታኮ ኔ ታና ሜላ ኩሼ ኬሳ ዬዳናኮሺን ጾሲ ታ ዋዬኔ ታ ዳቡራ ቤኢዲ ቃማ ኦማርስ ኔና ሃንቂዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ላባይ ያቆቤ፥ «ኔ ማቼቲ ታ ማጫ ናይታ፤ ኢስቲ ዬሊዳ ናይቲካ ታ ናይታ፤ ሜሄዚካ ታ ሜሄ፤ ኔስ ዲዛዚ ዉሪካ ታይሳ፤ ሃች ሃ ማጫ ናይታ ታይታ ቦላኔ ኢስቲ ዬሊዳ ናይታ ቦላ ኣይ ኦꬃናስ ዳንዳያዚና? ");
INSERT INTO gmve_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ኣኔ ሃኢ ሃ ያ፤ ኔኒኔ ታኒ ጫቄቶስ፤ ሃይሲ ኔፔኔ ታፔ ጊዶን ማርካ ጊዶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ሄሳ ጊሻስ ያቆቤይ ኢሲ ሹች ኤኪዲ ቱሳ ማላ ኤሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ኢዚ ባ ዳቦታካ፥ «ሹች ሺሺቴ» ጊዴስ፤ ሂስቲን ኢስቲ ሹች ሺሺዲ ኮሪዳ፤ ሄ ሹቻ ኮራ ኣቻንካ ካꬅ ሚዳ። ");
INSERT INTO gmve_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ላባይ ሄ ሹቻ ኮራ፥ ዪጋር-ሳሃዱታ ጊ ሱንꬂዴስ፤ ቃሴ ያቆቤይ ኢዛ ጋልኤዴ ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ላባይ፥ «ሃ ኬላይ ኔፔኔ ታፔ ጊዶን ሃች ማርካ» ጊዴስ፤ ሄሳ ጊሻስ ኢዛ ሱንꬃይ ጋልኤዴ ጌቴቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ቃሴ ኢዚ ሄ ሹቻ ቱሳ ሚጺጳ ጊ ሱንꬂዴስ፤ ኣይስ ጊኮ ላባይ፥ «ኑኒ ኢሳይ ኢሳፌ ሃኪዲ ዲዛ ዎዴ ጎዳይ ኔ ጊዶኒኔ ታ ጊዶን ጊዲዲ ናጎ። ");
INSERT INTO gmve_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","ኔኒ ታ ማጫ ናይታ ቆሂኮ፥ ዎይኮ ኔኒ ታ ማጫ ናይታ ቦላ ሃራ ማጫሳታ ኤኪኮ ኑናራ ሃኢ ኦኒካ ባይንዳ ኣጊኮካ ኔ ጊዶኒኔ ታ ጊዶን ጾሳይ ማርካ ጊዲዳይሳ ኤራ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ላባይ ቃሴካ ያቆቤስ፥ «ኬሌቲዳ ሹቻ ሃይሳ ቤያ፤ ቃሴ ታኒ ኔፔኔ ታፔ ጊዶን ኤሲዳ ሹቻ ቱሳ ሃይሳ ቤያ። ");
INSERT INTO gmve_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ታኒ ኔ ቦላ ጌኔ ኦꬃናስ ሃ ኬላፔ ኔኮ ካንꬆንታ ማላ ኔኒካ ታ ቦላ ጌኔ ኦꬃናስ ሃ ኬላፔኔ ሃ ሹቻ ቱሳፌ ካንꬆንታ ማላ ሃ ሹቻ ኮራይኔ ሃ ሹቻ ቱሳይ ማርካ። ");
INSERT INTO gmve_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ኣብራሃሜ ጾሲ፥ ናኮሬ ጾሲ፥ ኢስታ ኣዋ ጾሲ፥ ኢዚ ኑ ጊዶን ፒርዶ» ጊዴስ። ያቆቤይ ባ ኣዋ ዪሳቂ ጎይኒዳ ጾሳ ሱንꬃን ጫቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ያቆቤይ ዙማ ቦላን ያርሾ ያርሺዴስ፤ ባ ዳቦታካ ቁማ ማናስ ጼይጊዴስ፤ ኢስቲ ሚዲ ሄን ዙማ ቦላን ኣቂዳ። ");
INSERT INTO gmve_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ዎንቴꬃ ጋላስ ማላዶ ዎንታራ ላባይ ዴንዲዲ ባ ናይታ ናይታኔ ባ ማጫ ናይታ ኣንጂዲኔ ዬሪ ኤኪዲ ጉዬ ባ ሶ ሲሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ያቆቤይ ዴንዲዲ ሲንꬄ ቢሺን ጾሳ ኪታንቻቲ ኢዛራ ጋጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ያቆቤይ ኢስታ ቤኢዲ፥ «ሃይሲ ጾሲ ኣቂዛሶ» ጊሼ ሄ ሶሆዛ ማሃናይሜ ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ያቆቤይ ሴይሬ ጌቴቲዛሶን ኤዶሜ ቢታን ዲዛ ባ ኢሻ ኤሳዌኮ ባፔ ሲንꬄ ኪታ ዬዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ኢዚ ኢስታ ቦላ ኪታ፥ «ኢንቴ ታ ጎዳ ኤሳዌስ ጋና ሚሺ ሃይሳ፤ ‹ኔ ኣይሌ ያቆቤይ፥ ታኒ ላባ ኣቻን ሃኖ ጋካናስ ጋምኣዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ታስ ሚዚ፥ ሃሬይ፥ ዶርሲ፥ ዴይሺ፥ ኣዴ ኣይሌቲኔ ማጫ ኣይሌቲ ዴቴስ፤ ሃኢ ታኒ ሃ ኪታ ታ ጎዳስ ኪቲዛይ ታስ ሎኦ ቆፓና ማላ ጋ ኪታዲስ› ጊዴስ» ጊ ኪቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ኪቴቲዳይቲ ያቆቤኮ ሲሚዲ ኢዛስ፥ «ኑኒ ኔ ኢሻ ኤሳዌኮ ቢዶስ፤ ሃኢ ኢዚ ቃሴ ኔናራ ጋጋናስ ዬስ፤ ኢዛራካ 400 ኣሲ ዴስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ያቆቤይ ባቢዲ ሾቢዴስ፤ ባናራ ዲዛ ኣሳ 2 ጩጋን ጩጋን ሻኪዲ ባ ዶርሳ፥ ዴይሻ፥ ሚዛኔ ጋሜላ 2 ጩጋን ጩጋን ሻኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ኢዚ፥ «ኤሳዌይ ዪዲ ኢሲ ጩጋ ኦሊ ኤኪዛ ጊዲኮ ኣቲዳ ጩጋይ ኬሲ ኤካናኮ» ጊ ቆፒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ሄ ዎዴ ያቆቤይ፥ «ኣቤት ጾሳዉ! ታ ኣዋ ኣብራሃሜ ጾሳዉ፥ ታ ኣዋ ዪሳቃ ጾሳዉ፥ ታና፥ ‹ኔ ዳቦታኮ ኔ ዴሬ ሲማ፤ ታኒ ኔስ ሎኦ ኦꬃና› ጊዳሶ፥ ");
INSERT INTO gmve_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ኔኒ ኔ ኣይሌዛስ ኦꬂዳ ኪያቴꬃሲኔ ኣማኔቴꬃስ ኡባስ ታኒ ቤሶንታ ኣሳ። ታኒ ሃ ዮርዳኖሴ ሻፋ ፒኒዛ ዎዴ ታስ ኢሲ ጉፌይፔ ኣቲን ኩሼን ሃራይ ዴና፤ ጊዶ ኣቲን ሃኢ ታኒ ናምኡ ጩጋ ዴሬ ጊዳዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ታ ኔና ዎሳይስ፤ ታ ኢሻ ኤሳዌ ኩሼፔ ታና ኣሻ፤ ጋሶይካ ኢዚ ዪዲ ታናኔ ታ ናይታ ኣዬታ ኢስታ ናይታራ ꬋይሳናኮ ጋዳ ባባዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","ጊዶ ኣቲን ኔኒ ታና፥ ‹ታኒ ኔስ ቱሙ ሎኦ ኦꬃና፤ ታኒ ኔ ዜሬꬃይ ታይቤታናስ ዳንዳዬቶንታ ኣባ ሻሚንታ ማላ ኦꬃና› ጊዳይሳ ቆፓ» ጊ ዎሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ሄ ጋላሳ ኦማርስ ኢዚ ሄን ኣቂዳይ ባስ ዲዛ ኡባፌ ባ ኢሻ ኤሳዌስ ኢማናሳ። ");
INSERT INTO gmve_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","15","ኢዚካ 200 ማጫ ዴይሻታኔ ናምኡ ታሙ ዴይሻ ኦርጌታ፥ 200 ማጫ ዶርሳታኔ 200 ꬋርሾታ፥ 300 ꬋንꬂዛ ጋሜላታኔ ኢስታ ማራታራ፥ 40 ሚዛታ፥ 10 ኮርማ ቦራታ፥ 20 ማጫ ሃሬታኔ 10 ዎዳላ ሃሬታ ቆሪ ኬሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ሄይታ ዉዴን ዉዴን ሻኪ ሻኪ ባ ኣይሌታ ኩሼን ዎꬂዲ ኣይሌታስ፥ «ታፔ ሲንꬃቲ ቢቴ፤ ዉዴዛ ኢሳ ኢሳፌ ሃሲ ሃሲ ላጊቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ኡባፌ ሲንꬃን ቢዛይሳ፥ «ታ ኢሻ ኤሳዌይ ኔናራ ጋጊዲ ኔና፥ ‹ኔ ኦኔ? ኣዋ ባይ? ኔ ሲንꬃን ዲዛ ሜሄይ ዉሪ ኦናሴ?› ጊ ኦይቺዛ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","‹ኔኒ ኢዛስ ሃይቲ ኔ ኣይሌ ያቆቤሳ፤ ኢዚ ሃይታ ዬዲዳይካ ታ ጎዳ ኤሳዌስ ኢማናሳ፤ ቃሴ ኢዚካ ኑፔ ጉዬራ ዬስ› ጋ» ጊ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ቃሴካ ናምኣንꬆኔ ሄꬓንꬆ ጩጋታሲኔ ዉዴዛ ካሊዛ ሃራ ኡባታስ ሃይሳꬆ፥ «ኢንቴ ኤሳዌራ ጋጊዛ ዎዴ ሃይሳꬆካ ጌታ፤ ");
INSERT INTO gmve_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‹ኔ ኣይሌ ያቆቤይ ኑፔ ጉዬራ ዬስ› ጎንታ ኣጎፍቴ» ጊዴስ፤ ኢዚ ሄሳꬆ ጊዳይ፥ «ታኒ ታፔ ሲንꬄ ኢማናስ ኪቲዳይሳን ኢዛ ሃንቆ ዶሺሳና፤ ሄሳፌ ጉዬ ታኒ ኢዛራ ጋጊዛ ዎዴ ኢዚ ታና ሞኪ ኤካናኮ ኦኔ ኤሪዛይ» ጊ ቆፒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ሄሳ ጊሻስ ባ ኢሚዛይሳ ባፔ ሲንꬃሲ ዬዲዴስ፤ ጊዶ ኣቲን ኢዚ ባ ሁኤስ ሄ ጋላሳ ኦማርስ ሄን ባ ዲዛሶን ኣቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","ሄ ጋላሳ ኦማርስ ያቆቤይ ዴንዲዲ፥ ባ ናምኡ ማቼታ፥ ባ ናምኡ ኣይሌታ ባ ናይታ ታማኔ ኢሲኔታ ኤኪዲ ያቦቄ ጌቴቲዛ ሻፋ ጋኪዴስ፤ ኢዚ ኢስታኔ ባስ ዲዛይታ ኡባ ፒንꬂ ዬዲዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ጊዶ ኣቲን ያቆቤይ ባርካ ሄን ኣቲዴስ። ሄ ዎዴ ኢሲ ኣሲ ጋዴይ ዎንታና ጋካናስ ኢዛራ ባጼቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ሄ ኣዴዚ ኢዛ ጾናናስ ዳንዳዬቶንታይሳ ቤኢዲ ያቆቤስ ዎዲራ ቦቺን ኢዛ ዎዲራይ ዶጪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ሂስቲን ሄ ኣዴዚ ኢዛ፥ «ጋዴይ ዎንታና ጌስ ታና ዬዳ» ጊዴስ። ጊዶ ኣቲን ያቆቤይ ኢዛ፥ «ኔ ታና ኣንጆንታ ዬዲኬ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ኣዴዚካ ኢዛ፥ «ኔ ሱንꬂ ኦኔ?» ጊ ኦይቺን ኢዚ፥ «ያቆቤ» ጊ ዛሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ኣዴዚካ ኢዛ፥ «ሃይሳፌ ሲንꬃን ኔ ሱንꬂ ኢስራኤሌ ጌቴቶ ኣቲን ያቆቤ ጌቴቶፎ፤ ኣይስ ጊኮ ኔኒ ጾሳራኔ ኣሳራ ባጼታዳ ጾናዳሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ያቆቤይ ኢዛ፥ «ኔ ሱንꬂ ኦኔ?» ጊ ኦይቺዴስ። ኣዴዚካ፥ «ኔኒ ታ ሱንꬁ ኣይስ ኦይቻይ?» ጊ ሲሚዲ ኢዛ ሄን ኣንጂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ሄሳ ጊሻስ ያቆቤይ ሄ ሶሆዛ ጲንኤሌ ጊ ሱንꬂዴስ፤ ኣይስ ጊኮ ኢዚ፥ «ታኒ ጾሳ ታ ኣይፌራ ቤኣዳ ሃይቆንታ ኣታዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","ኢዚ ፓኑኤሌፔ ዴንዲዛ ዎዴ ኢዛ ቦላ ጻልቄይ ኬዚዴስ፤ ኢዚ ባ ዎዲራ ጊሻስ ዎቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ያቆቤ ዎዲራይ ዴሼቲዳ ጊሻስ ኢስራኤሌ ኣሳይ ሃች ጋካናስካ ጌዳ ጊዶን ዲዛ ፓሻ ኣሾ ሚ ኤሬቴና። ");
INSERT INTO gmve_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ያቆቤይ ꬎቁ ጊ ጼሊዲ ኤሳዌይ 400 ኣስ ባናራ ኤኪ ዪዛይሳ ቤኢዴስ፤ ሄሳ ጊሻስ ናይታ ሊያስ፥ ኤራሄሊሲኔ ናምኡ ኣይሌታስ ሻኪ ሻኪ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ኣሽካራታኔ ኢስታ ናይታ ሲንꬃን ሊያኔ ኢዚ ናይታ ኢስታፌ ጉዬን ኤራሄሎኔ ዮሴፌ ዉርሴꬃን ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ጊዶ ኣቲን ኢዚ ባ ባጋራ ኡባፌ ሲንꬄ ኣꬊዲ ባ ኢሻኮ ማቲዳ ዎዴ ላፑንቶ ዚጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ኤሳዌይ ጊዲኮ ኢዛራ ጋጋናስ ዎጺዲ ኢዛ ቆꬌ ቦላ ጻጼቲዲ ዬሪዴስ፤ ናምኣቲካ ዬኪዳ። ");
INSERT INTO gmve_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ሄሳፌ ጉዬ ኤሳዌይ ꬎቁ ጊ ጼሊዲ ማጫሳታኔ ናይታ ቤኢዲ፥ «ሃ ኔናራ ዲዛይቲ ኦናንቴ?» ጊ ኦይቺዴስ። ያቆቤይ ኢዛስ፥ «ሃይቲ ጾሲ ኔ ኣይሌስ ታስ ባ ኪያቴꬃን ኢሚዳ ናይታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ሄሳፌ ጉዬ ኣይሌቲ ባ ናይታራ ሺቂዲ ኢዛ ሲንꬃን ዚጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ካሊዲ ሊያይኔ ኢዚ ናይቲ ዪዲ ዚጊዳ፤ ዉርሴꬃን ዮሴፌይኔ ኤራሄላ ዪዲ ዚጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ኤሳዌይ፥ «ሲንꬃን ታናራ ጋጊዳ ሜሄይ ዉሪ ኣዛ ሜሄ?» ጊ ኦይቺዴስ። ኢዚካ፥ «ታ ጎዶ! ሃይሲ ኔ ታና ኡፋይሳን ሞካ ኤካናሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ኤሳዌይ፥ «ታ ኢሾ! ታስ ዳሮ ሃሮይ ዴስ፤ ኔ ሚሺ ኔስ ጊዶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ያቆቤይ፥ «ኣካይ፥ ሃኢ ኔ ታና ሞካ ኤካና ጊዲኮ ታ ኔስ ኢሚዛይሳ ኤካ፤ ኔ ታና ሲቆን ሞካ ኤኪሺን ታ ቤኢዳይሳ ጾሳ ኣይፌሶ ቤኢዳ ማላ ቆዳይስ። ");
INSERT INTO gmve_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ጾሲ ባ ኪያቴꬃን ኡባ ኩንꬂ ታስ ኢሚዳ ጊሻስ ኮሺዛዚ ኡባይ ታስ ዴስ፤ ታ ኔስ ኢሚዛይሳ ኤካርኪ» ጊዲ ያቆቤይ ሚንꬂ ሾቢዳ ጊሻስ ኤሳዌይ ኢዚ ጊዳይሳ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ሄሳፌ ጉዬ ኤሳዌይ፥ «ዴንዳ ኣኔ ቦስ፤ ታኒካ ኢንቴናራ ኢሲፌ ባና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ጊዶ ኣቲን ያቆቤይ ኢዛ፥ «ታ ጎዶ! ኔ ቤኢዛ ማላ ናይቲ ሹጎ ጊዲዳይሳ ኔ ኤራሳ፤ ቃሴ ታኒ ጋሎ ማራታኔ ጉꬃ ላቃታ ꬋንꬂዛ ዶርሳታኔ ሚዛታ ናጋና ኮሼስ፤ ኢስቲ ኤሌ ኤሌ ላጊኮ ሜሄቲ ዉሪ ኢሲ ጋላስ ሃይቂ ዉራና። ");
INSERT INTO gmve_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ሄሳ ጊሻስ ታ ጎዶ ኔኒ ታፔ ሲንꬃታዳ ባ፤ ታ ሲንꬃን ዲዛ ሜሄይኔ ናይቲ ሄሜታና ዳንዳይዛ ኬና ሄሜቲዲ ኔናራ ሴይሬን ጋይታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ኤሳዌይ ኢዛ፥ «ሂስቲኮ ታኒ ታ ኣሳፔ ጉꬃታ ኔስ ኣሻይስ» ጊዴስ። ጊዶ ኣቲን ያቆቤይ ኢዛ፥ «ሄሲ ኣይሴ? ታኒ ታ ጎዳ ሲንꬃን ቦንቼቲዳይሲ ታስ ጊዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ሄሳ ጊሻስ ኤሳዌይ ሄ ጋላስ ሴይሬ ሲሚ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ጊዶ ኣቲን ያቆቤይ ሱኮቴ ቢዴስ፤ ሄን ባስ ኬꬅ ኬጺዴስ፤ ባ ሜሄታስካ ኣቂዛሶ ጊግሲዴስ፤ ሄሳ ጊሻስ ሄ ሶሆዛ ሱኮቴ ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ያቆቤይ ሜስጴጾሚያፔ ሲሚዳ ዎዴ ካናኔ ቢታን ዲዛ ሴኬሜ ጊዛ ካታማ ሳሮን ጋኪዴስ፤ ካታማይስ ሲንꬃ ባጋራ ዲዛ ዴምባን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ባ ዱንካኔዛ ቶሊዳ ጋዴዛ ሴኬሜ ኣዋ ኤሞሬ ናይታፔ 100 ሳቂሌ ቢራን ሻሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ሄን ያርሾሶሆ ኬጺዲ ኢዛ፥ «ጾሲ ኢስራኤሌ ጾሳ» ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ሊያይ ያቆቤስ ዬሊዳ ናያ ዲናይ ሄ ዎዴ ሴኬሜ ዴሬ ማጫሳ ቤያናስ ኬዛዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ሄ ቢታ ሃሪዛ ሂዌይ ኤሞሬ ና ሴኬሜይ ኢዞ ዎልቃራ ኦይኪዲ ላይማቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","ሄሳፌ ጉዬ ኢዛ ዎዚናይ ኢዚን ኤኬቲዴስ፤ ኢዚካ ናዮ ኬሂ ዶሲዳ ጊሻስ ሲቆ ቃላን ባሌꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ሴኬሜይ ባ ኣዋ ኤሞሬ፥ «ታስ ሃኖ ናዮ ማቾ ኦይቻርኪ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ያቆቤይ ባ ና ዲናይ ሞሬቲዳይሳ ሲዪዳ ዎዴ ኢዛ ኣቱማ ናይቲ ሜሄራ ባዞን ዲዛ ጊሻስ ኢስቲ ያና ጋካናስ ጮኡ ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ሄሳፌ ጉዬ ሴኬሜ ኣዋ ኤሞሬይ ያቆቤራ ሃሳያናስ ዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ያቆቤ ኣቱማ ናይቲ ሄ ሃኒዳይሳ ሲዪዳ ማላ ባ ዲዛሶፔ ዪዲ ጬጪዳኔ ሼኔቲዳ፤ ኣይስ ጊኮ ሴኬሜይ ኢስራኤሌ ና ቦላ ኦꬃናስ ቤሶንታ ኦሶ ኦꬂዳ ጊሻስ ዳሮ ሃንቄቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ጊዶ ኣቲን ኤሞሬይ ኢስታስ፥ «ታ ና ሴኬሜይ ኢንቴ ናዮ ዲና ዳሮ ሲቂዛ ጊሻስ ሃያና ኢዞ ኢዛስ ማቾ ኢሜርኬቲ! ");
INSERT INTO gmve_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ኑናራ ኤኬቲቴኔ ጌሌቲቴ፤ ኢንቴ ማጫ ናይታ ኑስ ኢሚቴ፤ ኑ ማጫ ናይታካ ኢንቴስ ኤኪቴ። ");
INSERT INTO gmve_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ኢንቴ ኑ ጊዶን ኡታና ዳንዳዬታ፤ ዴሬይ ኬሂ ኣሆ፤ ኢዛን ዴኢቴ፤ ዛልኢቴ፤ ኢዛን ኣቆ ኬሲቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ሄ ዎዴ ሴኬሜይ ዲና ኣዋኔ ኢዚ ኢሻታ፥ «ታኒ ኢንቴ ታ ጊዛይሳ ኩንꬂዛ ጊዲኮ ኢንቴ ኦይቺዛይሳ ኣይ ጊዲኮካ ታ ኢማና። ");
INSERT INTO gmve_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","ኢንቴ ኮይታ ኮይኮ ኢማና፤ ኢሞታ ኮይኮ ኢንቴ ኮዪዳይሳ ኬና ታ ኢማና ሺን ናዮ ታ ኤካና ማላ ኤሮ ጊቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ባ ሚቼዮ ዲና ሴኬሜይ ቱኒሲዳ ጊሻስ ያቆቤ ኣቱማ ናይቲ ሴኬሜሲኔ ኢዛ ኣዋ ኤሞሬስ ዎርዶ ዮቲዳ፤ ");
INSERT INTO gmve_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ኢስቲካ ኢስታስ፥ «ኑኒ ሄሳ ማላ ሚሽ ኦꬃና ዳንዳዮኮ፤ ኑኒ ኑ ሚቼዮ ቃጻሬቶንታ ኣሳስ ኢሚኮ ሃይሲ ኑና ካዉሺዛ ሚሻ። ");
INSERT INTO gmve_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ኑኒ ኢንቴ ኢሲ ሚሽ ኦꬂኮ ኢንቴስ፥ ‹ኤሮ› ጋና፤ ሄሲካ ኣዜ ጊኮ ኢንቴ ቢታ ኣቱማ ኣሳይ ዉሪ ኑ ማላ ቃጻሬቲኮ። ");
INSERT INTO gmve_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ኑኒ ኑ ማጫ ናይታ ኢንቴስ ኢማና ኢንቴ ማጫ ናይታካ ኑስ ኤካና፤ ኑ ኢንቴ ጊዶን ኡቲዲ ኢንቴናራ ኢሲ ዴሬ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ኢንቴ ቃጻሬታናስ ኮዮንታ ጊዲኮ ኑኒ ኑ ሚቼዮ ኤኪዲ ባና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ሂስቲን ኢስቲ ጊዳይሲ ኤሞሬሲኔ ኢዛ ና ሴኬሜስ ሎኦ ሚሳቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ባ ኣዋ ኬꬃን ዲዛ ኡባፌ ኣꬊ ቦንቼቲዳ ሴኬሜይ ያቆቤ ናዪን ኡፋዬቲዳ ጊሻስ ኢስቲ ጊዳይሳ ኦꬃናስ ጋምኢቤና። ");
INSERT INTO gmve_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ሄ ዎዴ ኤሞሬይኔ ኢዛ ና ሴኬሜይ ባ ኣሳስ ዮታናስ ባ ዲዛ ካታማ ሲሚ ቢዲ፥ ");
INSERT INTO gmve_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«ሃ ኣሳቲ ኑናራ ሲጋ፤ ኢስቲ ኑ ቢታን ዴቶኔ ዛልኤቶ፤ ኑ ዴሬይ ኬሂ ኣሆ፤ ኢስታ ማጫ ናይታ ኑኒ ኤካና፤ ኢስቲካ ኑ ማጫ ናይታ ኤኬቶ። ");
INSERT INTO gmve_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ጊዶ ኣቲን ኑናራ ኢስቲ ኢሲ ኣሳ ማላ ዴኣናስ ኑኒ ኢሲ ሚሽ ኦꬃናስ ኮሼስ፤ ሄሲካ ኢስቲ ቃጻሬቲዳ ማላ ኑ ኣቱማ ኣሳይ ዉሪ ቃጻሬቲኮ ሃናና። ");
INSERT INTO gmve_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ኑኒ ሄሳꬆ ኦꬂኮ ኢስታ ሚዛይ፥ ኢስታ ኣቆይኔ ኢስታ ሜሄይ ዉሪ ኑስ ዴኔ? ሄሳ ጊሻስ ኣኔ ኑኒ ኢስቲ ጎይሳ ኤሮ ጎስ፤ ኢስቲካ ኑናራ ዳና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ካታማ ዱቡሻን ሺቂዳ ኣሳይ ዉሪ ኤሞሬሲኔ ኢዛ ና ሴኬሜስ፥ «ኤሮ» ጊዳ። ሂስቲን ሄ ካታማ ኣቱማሳይ ዉሪ ቃጻሬቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ሄꬓንꬆ ጋላስ ኢስቲ ዉሪ ባ ቃጻራ ማዱንꬃ ሳኬቲሺን፥ ያቆቤ ኣቱማ ናይታፔ ዲና ኢሻቲ፥ ሲሞኒኔ ሌዌይ ጊꬃ ማሻ ኤኪዲ ኦኒካ ኤሮንታ ካታማ ጌሊዲ፥ ኣዴ ጊዲዳይታ ኡባ ዎꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ኤሞሬኔ ኢዛ ና ሴኬሜ ጊꬃ ማሻን ዎꬊዲ ባ ሚቼዮ ዲና ሴኬሜ ሶፔ ኬሲ ኤኪዲ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ያቆቤ ኣቱማ ናይቲካ ኣሃታ ቦላራ ዬꬌቲ ኣꬊዲ ባ ሚቼዮ ዲኖ ቱኒሲዳ ካታማ ቦንቂዳ። ");
INSERT INTO gmve_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ኢስታ ዶርስ፥ ዴይሽ፥ ሚዝ፥ ሃሬ፥ ቃሴካ ካታማ ጊዶን ዲዛይሳኔ ጋጻን ዲዛይሳ ኡባ ኤኪዳ። ");
INSERT INTO gmve_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ኢስታ ሜሄታኔ ኢስታ ማቼታ ጉꬃ ናይታራ ኡባ ዲኢ ኤኪ ቢዳ፤ ኬꬃን ዲዛይሳካ ኡባ ቦንቂዳ። ");
INSERT INTO gmve_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ያቆቤይ ሲሞናኔ ሌዌ፥ «ኢንቴ ታ ቦላ ሜቶ ኤሂቺዴታ፤ ሃ ቢታን ዲዛ ካናኔቲኔ ፓሪዜቲ ታና ኢጻና፤ ኑኒ ቆዳን ጉꬃ፤ ኢስቲ ኢሲፌ ጊዲዲ ታ ቦላ ዎራጂኮ ታኒኔ ታሶ ኣሳይ ꬋያና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","ጊዶ ኣቲን ኢስታስ፥ «ሂስቲን ኢዚ ኑ ሚቼዮ ላይማ ማጫሳ ማላ ኦꬃናስ ቤሲዜ?» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ሄሳፌ ጉዬ ጾሲ ያቆቤ፥ «ዴንዳዳ ፑዴ ቤቴሌ ባዳ ሄን ዴኣ፤ ኔኒ ኔ ኢሻ ኤሳዌፔ ባቃቲዛ ዎዴ ኔስ ቆንጪዳ ጾሳስ ሄን ያርሾ ያርሺዛሶ ጊጊሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ያቆቤይካ ባሶ ኣሳኔ ባናራ ዲዛ ኣሳ ኡባ፥ «ኢንቴ ጊዶን ዲዛ ኣላጋ ኤቃ ሚስሌታ ዲጊቴ፤ ኢንቴ ቦላ ጌሺቴ፤ ኢንቴ ማይኦካ ላሚቴ። ");
INSERT INTO gmve_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ኣኔ ዴንዲዲ ፑዴ ቤቴሌ ቦስ፤ ታ ሜቶቲዳ ጋላስ ታኒ ጊዛ ሲዪዲ ታኒ ቢዳ ኡባሶን ታናራ ጊዲዳ ጾሳስ ታኒ ሄን ያርሾ ያርሺዛሶ ጊጊሳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ሄሳ ጊሻስ ኢስቲ ባ ኣቻን ዲዛ ሃራ ዴሬ ኣሳ ኤቃ ሚስሌታ ኡባኔ ባ ሃይꬃን ዲዛ ጉቲቻ ኡባ ኬሲዲ ያቆቤስ ኢሚን ያቆቤይ ሄይታ ሴኬሜን ዲዛ ዎላ ጋርሳን ሞጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ሄሳፌ ጉዬ ኢስታ ዩሾን ዲዛ ካታማ ኡባ ኣሳ ቦላ ጾሳፌ ዳጋማይኔ ያሻቴꬂ ዎꬊዳ ጊሻስ ያቆቤይኔ ኢዛ ኣቱማ ናይቲ ዴንዲዲ ቢሺን ኦኒካ ኢስታ ኦይካናስ ካሊቤና። ");
INSERT INTO gmve_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ያቆቤይኔ ኢዛራ ዲዛ ኣሳይ ዉሪ ካናኔ ቢታን ዲዛ ቤቴሌ ጌቴቲዛ ሎዛ ጋኪዳ። ");
INSERT INTO gmve_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ሄን ኢዚ ያርሾ ያርሺዛሶ ኬጺዲ ሄ ሶሆዛ ኤሊ-ቤቴሌ ጊ ሱንꬂዴስ፤ ኣይስ ጊኮ ኢዚ ባ ኢሻፔ ባቃቲዲ ቢዛ ዎዴ ጾሲ ኢዛስ ቆንጪዳ ሶሆ ጊዲዳ ጊሻሳ። ");
INSERT INTO gmve_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ኢርቢቃ ዲቺዳ ዲቦራይ ሄን ሃይቃዳ ቤቴሌፔ ዱጌ ባጋራ ዲዛ ዎላ ጋርሳን ኢዛ ሞጌታዱስ፤ ሄሳ ጊሻስ ሄ ሚꬃ ሱንꬂ ኣሌም-ባኩቴ ጌቴቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ያቆቤይ ሜስጴጾሚያፔ ሲሚዳፔ ጉዬ ጾሲ ኢዛስ ቃሴካ ቆንጪዲ ኢዛ ኣንጂዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ጾሲ ኢዛ፥ «ሃኢ ጋካናስ ኔ ሱንꬂ ያቆቤ፤ ጊዶ ኣቲን ሃይሳፌ ጉዬ ሙሌካ ያቆቤ ጌቴታካ፤ ኔ ሱንꬂ ኢስራኤሌ ጌቴታና» ጊዲ ኢዚ ኢዛ ኢስራኤሌ ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ቃሴ ጾሲ ያቆቤ፥ «ታኒ ኡባ ዳንዳይዛ ጾሳ፤ ኔኒ ዬሌታ፤ ጮራታ፤ ዴሬይኔ ዴሬ ማባራይ ኔፔ ኬዛና፤ ካዎቲካ ኔ ጉልባቴፔ ኬዛና። ");
INSERT INTO gmve_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ታኒ ኣብራሃሜሲኔ ዪሳቃስ ኢሚዳ ቢታ ቃሴ ኔስ ኢማና፤ ኔፔ ጉዬካ ታኒ ሃ ቢታ ኔ ዜሬꬃስ ኢማና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ሄሳፌ ጉዬ ጾሲ ኢዛራ ሃሳይዳ ሶሆፔ ፑዴ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ያቆቤይ ጾሲ ባናራ ሃሳይዳ ሶሆን ሹች ኤሲዲ ኢዛ ቦላ ኡሻ ያርሾ ጉሲዴስ፤ ዛይቴካ ኢዛ ቦላ ቲጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ያቆቤይ ጾሲ ባናራ ሃሳይዳ ሶሆዛ፥ «ቤቴሌ» ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ኢስቲ ሄሳፌ ጉዬ ቤቴሌፔ ዴንዲ ኤፍራታ ጋካናስ ጉꬅ ኣሺዳ ማላ ኤራሄሎ ዎልቃማ ሚጻይ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ሚጻይ ኢዞ ዋዪሲን ኢዞ ዬሊሲዛራ፥ «ባቦፋ፤ ሃይሲካ ኣቱማ ና» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ጊዶ ኣቲን ኢዛ ሃይቃ ሼምፖ ኬዚሺን ባ ና ቤኒ-ኦኔ ጋ ሱንꬃዱስ፤ ያቆቤይ ኢዛ ቢኒያሜ ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ሄሳፌ ጉዬ ኤራሄላ ሃይቃዳ ቤቴሊሄሜ ጊዛ ኤፍራታ ኤፊዛ ኦጌ ዶናን ሞጌታዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ያቆቤይ ኢዚ ዱፎን ሃዉልቴ ሹች ኤሲዴስ፤ ሄ ሃዉልቴ ሹቻይ ሃች ጋካናስካ ኤራሄሊ ዱፎ ማላታ ጊዲ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ኢስራኤሌይ ሄፔ ዴንዲዲ ኤዴራ ጊምቤፌ ሄ ፒንꬃን ባ ዱንካኔዛ ቶኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ኢስራኤሌይ ሄ ቢታን ዲሺን ኦሮቤሌይ ቢዲ ባ ኣዋስ ዬሊዳ ኣይሌ ቢሊሃራ ዚንኢዴስ፤ ኢስራኤሌይካ ሃ ዮኦዛ ሲዪዴስ። ያቆቤ ኣቱማ ናይቲ ታማኔ ናምኣ። ኢስቲካ፥ ");
INSERT INTO gmve_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ሊያ ናይቲ ያቆቤ ባይራ ና ኦሮቤሌ፥ ሲሞና፥ ሌዌ፥ ዩሁዳ፥ ዪሳኮሬኔ ዛቢሎኔ። ");
INSERT INTO gmve_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","ኤራሄሊ ኣቱማ ናይቲ ዮሴፌኔ ቢኒያሜ። ");
INSERT INTO gmve_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ኤራሄሊ ኣይሌ ቢሊሃ ኣቱማ ናይቲ ዳኔኔ ኒፍታሌሜ። ");
INSERT INTO gmve_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ሊያ ኦሳንቻ ዚልፊ ኣቱማ ናይቲ ጋዴኔ ኣሴሬ። ሃይቲ ማሶጴጾምያን ያቆቤስ ዬሌቲዳ ኢዛ ኣቱማ ናይታ። ");
INSERT INTO gmve_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ያቆቤይ ባ ኣዋይ ዲዛሶ ማሚሬ ጌቴቲዛሶ ዪዴስ፤ ሄሲካ ኣብራሃሜይኔ ዪሳቂ ካሴ ዴዪዳ ቂሪያቴ-ኣርባኤ ዎይኮ ኬብሮኔ ጌቴቲዛሶ። ");
INSERT INTO gmve_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ዪሳቂ 180 ላይꬅ ዴኢዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ኢዚ ዳሮ ዎዴ ዴኢዲ ኬሂ ጪሚ ሃይቂዲ ባ ኣዋታን ጋጊዴስ፤ ኢዛ ናይቲ ኤሳዌይኔ ያቆቤይ ኢዛ ሞጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ኤዶሜ ጌቴቲዛ ኤሳዌ ዬሌታይ ሃይሳፌ ካሊ ጻፌቲዳይሳ። ");
INSERT INTO gmve_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ኤሳዌይ ካናኔ ቢታ ማጫ ናይታፔ ባስ ማቾ ኤኪዴስ፤ ኢስቲካ ሂቴ ኤሎኔ ና ኣዳ፥ ሂዌያ ጺባኦኔ ና ኣናይ ዬሊዳ ኦሆሊባሜኔ ");
INSERT INTO gmve_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ኢስማኤሌ ና ኔባዮቲ ሚቺዮ ባሴማቶ። ");
INSERT INTO gmve_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ኣዳይ ኤሳዌስ ኤልፋዜ ዬላዱስ፤ ባሴማታያካ ኤራኡኤሌ ዬላዱስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ኦሆሊባሜ ያኡሼ፥ ያኢላሜኔ ቆሬ ዬላዱስ፤ ካናኔ ቢታን ኤሳዌስ ዬሌቲዳ ኣቱማ ናይቲ ሃይታንታ። ");
INSERT INTO gmve_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ኤሳዌይ ባ ማቼታ፥ ባ ኣቱማ ናይታኔ ማጫ ናይታ፥ ባሶ ኣስ ኡባ ባ ሚዛታኔ ባ ሜሄ ኡባ ካናኔ ቢታን ኢዚ ሃሪዳይሳ ኡባ ኤኪዲ ባ ኢሻ ያቆቤፔ ሃኪ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ኢስታ ሃሮይ ዳሪዳ ጊሻስ ኢስቲ ኢሲፌ ዴኣናስ ዳንዳይቤቴና፤ ሜሄይ ኢስታስ ዳሪዳ ጊሻስ ኢስቲ ዲዛ ዴሬይ ኢስታ ናምኣታስ ጊዳናስ ዳንዳይቤና። ");
INSERT INTO gmve_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ሂስቲን ኤዶሜ ጌቴቲዛ ኤሳዌይ ሴይሬ ጌቴቲዛ ጌዜን ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ሴይሬ ጌቴቲዛ ጌዜ ቢታን ዲዛ ኤዶሜታ ኣዋ ኤሳዌ ዬሌታይ ሃይሳፌ ካሊ ጻፌቲዳይሳ። ");
INSERT INTO gmve_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ኤሳዌ ኣቱማ ናይታ ሱንꬂ ሃይሳፌ ካሊ ጻፌቲዳይሳ፤ ሄሳቲካ ኤሳዌ ማቾ ኣዳ ና ኤልፋዜኔ ኤሳዌ ማቾ ባሴማቲ ና ኤራኡኤሌ። ");
INSERT INTO gmve_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ኤልፋዜ ናይቲ ቴማኔ፥ ኦማሬ፥ ጼፎ፥ ጋኢታሜኔ ቄናዜ። ");
INSERT INTO gmve_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ቃሴ ኤሳዌ ና ኤልፋዜስ ቴሚናኤ ጌቴቲዛ ኣይሌይ ዳዉስ፤ ኢዛካ ኤልፋዜስ ኣማሌቄ ዬላዱስ፤ ሃይቲ ኤሳዌ ማቾ ኣዲስ ና ናይታ። ");
INSERT INTO gmve_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ኤራኡኤሌ ኣቱማ ናይቲ ናሃቴ፥ ዛራሄ፥ ሻማሃኔ ሚዛሄ፤ ሃይቲ ኤሳዌ ማቺዮ ባሴማቲስ ና ናይታ። ");
INSERT INTO gmve_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ጺባኦኔስ ናዛ ና ኣናይ ዬሊዳ ኦሆሊባሚ ኣቱማ ናይቲ ሃይታ፤ ኢዛ ኤሳዌስ ያኡሼ፥ ያኢላሜኔ ቆሬ ዬላዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ኤሳዌ ዬሌታ ዜሬꬃ ሃላቃቲ ሃይሳፌ ካሊ ጻፌቲዳይታ። ኤሳዌስ ባይራ ና ኤልፋዜ ኣቱማ ናይታስ ሃላቃ ጊዲዳይቲ ቴማኔ፥ ኦማሬ፥ ጼፎ፥ ቄናዜ፥ ");
INSERT INTO gmve_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ቆሬ፥ ጋኢታሜኔ ኣማሌቄ፤ ኤዶሜ ቢታን ኤልፋዜይ ዬሊዳ ሃላቃቲ ሃይታ፤ ሃይቲ ዉሪ ኣዲስ ና ናይታ። ");
INSERT INTO gmve_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ኤሳዌ ና ኤራኡኤሌ ኣቱማ ናይታስ ሃላቃ ጊዲዳይቲ ናሃቴ፥ ዛራሄ፥ ሻማሃኔ ሚዛሄ፤ ኤዶሜ ቢታን ኤራኡኤሌይ ዬሊዳ ሃላቃቲ ሃይታ፤ ኢስቲ ኤሳዌ ማቾ ባሴማቲስ ና ናይታ። ");
INSERT INTO gmve_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ኤሳዌ ማቺዮ ኦሆሊባሚ ኣቱማ ናይታስ ሃላቃ ጊዲዳይቲ ያኡሼ፥ ያኢላሜኔ ቆሬ፤ ኢስቲ ኣና ና፥ ኤሳዌ ማቺዮ ኦሆሊባሚፔ ዬሌቲዳ ሃላቃታ። ");
INSERT INTO gmve_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ሃይቲ ኤዶሜ ጌቴቲዛ ኤሳዌ ኣቱማ ናይታሲኔ ኢስታ ዜሬꬃታስ ሃላቃታ። ");
INSERT INTO gmve_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ኤዶሜ ቢታን ዲዛ ሆሬ ሴይሬ ኣቱማ ናይቲ ሃይሳፌ ካሊ ጻፌቲዳይታ፤ ሄይቲካ ሎጻኔ፥ ሾባሌ፥ ጺባኦኔ፥ ኣና፥ ");
INSERT INTO gmve_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ዲሾኔ፥ ኤጼሬኔ ዲሻኔ፤ ኢስቲካ ኤዶሜ ቢታን ዲዛ ሴይሬ ኣቱማ ናይቲ፥ ሆሬታ ሃላቃታ። ");
INSERT INTO gmve_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","ሎጻኔ ኣቱማ ናይቲ ሆሬኔ ሄማኔ፤ ሎጻኔ ሚቺያ ቴሚናኦ። ");
INSERT INTO gmve_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ሾባሌ ኣቱማ ናይቲ ኣሊዋኔ፥ ማናሃቴ፥ ኤባሌ፥ ሼፋኔ ኦናሜ። ");
INSERT INTO gmve_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","ጺባኦኔ ኣቱማ ናይቲ ኣያኔ ኣና፤ ኣናይካ ባዞን ባ ኣዋ ጺባኦኔ ሃሬታ ሄሚሼ ጻባላ ሃꬅ ዴሚዳይሳ። ");
INSERT INTO gmve_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","ኣና ናይ ዲሾኔ፤ ናያ ቃሴ ኦሆሊባሞ። ");
INSERT INTO gmve_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","ዲሾኔ ኣቱማ ናይቲ ሄምዳኔ፥ ኤሺባኔ፥ ዪቲራኔኔ ካራኔ። ");
INSERT INTO gmve_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ኤጼሬ ኣቱማ ናይቲ ቢሊሃኔ፥ ዛኢዋኔኔ ኣቃኔ። ");
INSERT INTO gmve_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","ዲሻኔ ኣቱማ ናይቲ ኡጼኔ ኣራኔ። ");
INSERT INTO gmve_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ሆሬታ ሃላቃቲ ሃይታንታ፤ ሎጻኔ፥ ሾባሌ፥ ጺባኦኔ፥ ኣና፥ ");
INSERT INTO gmve_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ዲሾኔ፥ ኤጼሬኔ ዲሻኔ። ሃይቲ ሴይሬ ቢታን ባ ቆሞን ቆሞን ሻኬቲዳ ሆሬታ ሃላቃታ። ");
INSERT INTO gmve_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ኢስራኤሌን ካዎይ ካዎታናፔ ካሴ ኤዶሜ ቢታን ካዎቲዳ ካዎቲ ሃይሳፌ ካሊ ጻፌቲዳይታ። ");
INSERT INTO gmve_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","ቢኦሬ ና ቤላይ ኤዶሜን ካዎቲዴስ፤ ኢዛ ካታማ ሱንꬂ ዲናቤ ጌቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","ቤላይ ሃይቂን ቦጺራፔ ዪዳ ዛራሄ ናይ ዮባቤይ ካዎቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","ዮባቤይ ሃይቂን ቴማኔ ቢታፌ ዪዳ ሁሻሜይ ካዎቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ሁሻሜይ ሃይቂን ሚዲያሜ ኣሳታ ሞኣቤ ቢታን ጾኒዳ ባዳዴ ና ሃዳዴይ፥ ካዎቲዴስ፤ ኢዛ ካታማ ሱንꬂ ኣዊቴ ጌቴቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ሃዳዴይ ሃይቂን ማሲሬቄፔ ዪዳ ሳሚላይ ካዎቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ሳሚላይ ሃይቂን ሻፋ ኣቻን ዲዛ ኤራሆቦቴፔ ዪዳ ሻኡሌይ ካዎቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ሻኡሌይ ሃይቂን ኣኪቦሬ ና ባኣሊ-ሃናኔይ ካዎቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","ኣኪቦሬ ና ባኣሊ-ሃናኔይ ሃይቂን ሃዳሬይ ካዎቲዴስ፤ ኢዛ ካታማ ሱንꬂ ፓኡ ጌቴቴስ፤ ኢዛ ማቺያ ሜዛሃቤ ናዮ ማጺሬዳ ዬሊዳ ማሄጻቢኤሎ ጌቴታዉስ። ");
INSERT INTO gmve_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ኤሳዌ ዬሌታ ሃላቃቲ ባ ቆሞን ቆሞን ባ ሱንꬃን ሱንꬃን ሃይታንታ፤ ቴሚናኤ፥ ኣሊዋ፥ ዬቴቴ፥ ");
INSERT INTO gmve_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ኦሆሊባሜ፥ ኤላ፥ ፒኖኔ፥ ");
INSERT INTO gmve_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ቄናዜ፥ ቴማኔ፥ ሚቢዛሬ፥ ");
INSERT INTO gmve_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ማጊዲኤሌኔ ኢራሜ። ሃይታንቲ ባ ሃሪዛ ቢታን፥ ባ ዲዛሶን ኤዶሜ ሃላቃታ። ሃይሲ ኤሳዌይ ኤዶሜታ ኣዋ። ");
INSERT INTO gmve_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ያቆቤይ ካሴ ባ ኣዋይ ዴዪዳ ካናኔ ቢታን ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ያቆቤ ናይቲ ሃኒዳይሲ ሃይሳፌ ካሊዲ ጻፌቲዳይሳ። ዮሴፌይ 17 ላይꬃ ና ጊዲዳ ዎዴ ባ ኣዋ ኣይሌታፔ፥ ቢሊሃፔኔ ዚልፊፌ ዬሌቲዳ ባ ኢሻታራ ባ ኣዋ ሜሄታ ሄሜስ፤ ሄ ዎዴ ኢዚ ባ ኣዋስ ኢስቲ ኦꬂዳ ኢታ ሚሽ ኤሂ ዮቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ኢስራኤሌይ ዮሴፌ ጪማቴꬃን ዬሊዳ ጊሻስ ሃንኮ ኣቱማ ናይታ ኡባፌ ኣꬂ ሲቄስ፤ ኢዚ ኢዛስ ኣሌቆ ማይኦ ጊግሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","ኢዛ ኢሻቲ ኢስታ ኣዋይ ኢዛ ኢስታፌ ኣꬂ ሲቂዛይሳ ቤኢዲ ኢስቲ ኢዛ ኢጺዲ ሎኦ ቃላን ኢዛራ ሃሳያናስ ዳንዳይቤቴና። ");
INSERT INTO gmve_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ዮሴፌይ ኣጉሞ ኣጉሜቲዲ ባ ኢሻታስ ዮቲዴስ፤ ኢስቲካ ኢዛ ጌዴ ጉጂ ኢጺዳ። ");
INSERT INTO gmve_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","ኢዚ ኢስታስ፥ «ታኒ ኣጉሜቲዳ ኣጉሞ ሲዪቴ። ");
INSERT INTO gmve_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ኑኒ ጋዴ ጊዶን ካꬃ ሚርቄ ሚርቂሺን ታ ሚርቄያ ዴንዳዳ ሲቲ ጋ ኤቃዱስ፤ ኢንቴ ሚርቄቲ ጊዲኮ ዩዪ ኣꬊዲ ታ ሚርቄይሲ ዚጊዳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","ኢዛ ኢሻቲ ኢዛ፥ «ኔኒ ኑ ቦላ ካዎታና ሃናይ? ዎይኮ ኑና ቱሙ ሃራና ሃናይ?» ጊዳ፤ ኢስቲ ኢዛ ኣጉሞዛ ጊሻሲኔ ኢዚ ኢስታስ ዮቲዳ ቃላ ጊሻስ ካሴፔ ኢዛ ኣꬂ ኢጺዳ። ");
INSERT INTO gmve_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ቃሴካ ዮሴፌይ ሃራ ኣጉሞ ኣጉሜቲዲ ባ ኢሻንታስ ዮቲዴስ፤ «ሲዪቴ፤ ታኒ ሃራ ኣጉሞካ ኣጉሜታዲስ፤ ሄ ኣጉሞዛን ኣርሼይ፥ ኣጊናይኔ 11 ጾሊንቴቲ ታስ ዚጊሺን ቤኣዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ሄ ኢዚ ቤኢዳ ኣጉሞዛ ባ ኣዋሲኔ ባ ኢሻታስ ዮቲን ኢዛ ኣዋይ ኢዛ፥ «ሃይሲ ኔኒ ኣጉሜቲዳይሲ ኣይ ኣጉሞ? ቱሙ ታኒ፥ ኔ ኣዬያኔ ኔ ኢሻቲ ዪዲ ኔ ሲንꬃን ሳኣን ጉፋኒዲ ኔስ ዚጋኔ?» ጊ ሃንቄቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","ኢዛ ኢሻቲ ኢዛ ሚቃይኒዳ፤ ጊዶ ኣቲን ኢዛ ኣዋይ ሃ ዮኦዛ ባ ዎዚናን ዎꬂዲ ናጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ኢሲ ጋላስ ኢዛ ኢሻቲ ሴኬሜ ኣቻን ባ ኣዋ ሜሄታ ሄማናስ ቢን፥ ");
INSERT INTO gmve_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ኢስራኤሌይ ዮሴፌ፥ «ኔ ኢሻቲ ሴኬሜን ሜሄ ሄሚዛይሳ ኔ ኤራሳ፤ ሃ ያ፤ ታ ኔና ኢስታኮ ኪታና» ጊዴስ። ዮሴፌይካ፥ «ኤሮ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","ያቆቤይካ፥ «ባዳ ኔ ኢሻቲኔ ሜሄይ ሳሮ ዲዛኮ ቤኣ ያዳ ኢስታ ሃኖታ ታስ ዮታ» ጊዲ ኢዛ ኬብሮኔ ሾባ ኪቲን ኢዚ ሴኬሜ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ሄን ዴምባ ጊዶን ኢዚ ጌዴ ሃ ሲሜሬቲሺን ኢሲ ኣሲ ኢዛ ዴሚዲ፥ «ናዞ! ኣይ ኮያይ?» ጊ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ኢዚካ፥ «ታ ኢሻታ ኮያይስ፤ ኢስቲ ሜሄ ሄሚዛሶሆይ ኣዋኮ ታስ ዮታርኪ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ሂስቲን ኣዴዚ፥ «ሄሳፌ ዴንዲቺዳ፤ ኢስታስ፥ ‹ኑኒ ዶታኔ ቦስ› ጊሺን ሲያዲስ» ጊዴስ፤ ሄሳ ጊሻስ ዮሴፌይ ባ ኢሻታ ጉዬ ቢዲ ኢስታ ዶታኔን ዴሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ጊዶ ኣቲን ኢዚ ሃሆን ዲሺን ኢስቲ ኢዛ ቤኢዳ፤ ኢዚ ኢስታኮ ጋኮንታ ዲሺን ኢስቲ ኢዛ ዎꬋናስ ማቄቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ኢሶይ ኢሳስ፥ «ቤኢቴ! ኣጉሞ ጎዳይ ዬስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ሃ ዪቴ! ኢዛ ዎꬊዲ ሃ ኦላታፔ ኢሳ ጊዶ ዬጎስ። ሄሳፌ ጉዬ፥ ‹ኢታ ዶኣይ ኢዛ ሚዴስ› ጋና፤ ሂስቲዲ ኢዛ ኣጉሞይ ፖሌቲን ኣኔ ቤኣና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ኦሮቤሌይ ሄሳ ሲዪዲ ኢስታ ኩሼፔ ኢዛ ኣሻናስ ኮዪዲ፥ «ኢዛ ዎꬎ ዎꬎኮ፤ ");
INSERT INTO gmve_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ሱꬅ ጉሶፍቴ፤ ኢዛ ኢንቴ ባዞን ዲዛ ሃ ኦላ ጊዶ ዬጊቴ፤ ኢዛ ቦላ ኩሼ ዎꬆፍቴ» ጊዴስ። ኦሮቤሌይ ኢዛ ኢስታ ኩሼፔ ኣሺዲ ጉዬ ኢዛ ኣዋኮ ዬዳናስ ቆፒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ዮሴፌይ ባ ኢሻታኮ ጋኪዳ ዎዴ ኢዚ ማይኢዳ ኣሌቆ ማይኦ ኢዛፔ ቃሪ ኤኪዳ፤ ");
INSERT INTO gmve_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ኢዛ ኤፊዲ ሃꬂ ባይንዳ ሜላ ኦላን ዬጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ኢስቲ ባ ቁማ ማናስ ኡቲዳሼ ኢስማኤሌ ዴሬ ኣሳቲ ጊብጼ ባናስ ጋላኣዴፔ ዪዛይታ ꬎቁ ጊዲ ቤኢዳ፤ ኢስቲ ባ ጋሜላን ሳዎ፥ ባላሳኔ ጌቴቲዛ ꬋሌኔ ካርቤ ጫኒ ዎꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ዩሁዳይ ባ ኢሻታ፥ «ኑኒ ኑ ኢሻ ዎꬊዲ ኢዛ ሱꬃ ቆቲኮ ኑና ኣይ ማዳኔ? ");
INSERT INTO gmve_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ሃ ዪቴ፤ ኢዛ ኢስማኤሌታስ ባይዞስ፤ ኢዛ ቦላ ኑ ኩሼ ዎꬆኮ፤ ጋሶይካ ኢዚ ኑ ኢሻኔ ኑ ኣሾ።» ሂስቲን ኢዛ ኢሻቲ ዉሪካ ኤሮ ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ሄሳ ጊሻስ ሚዲያሜ ቢታ ዛልኣንቻቲ ሄሳራ ኣꬊሺን ኢዛ ኢሻቲ ዮሴፌ ኦላፌ ኬሲዲ ኢስማኤሌ ኣሳታስ 20 ቢራስ ባይዚን ኢስቲ ዮሴፌ ጊብጼ ቢታ ኤፊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ኦሮቤሌይ ኦላኮ ሲሚዲ ዮሴፌይ ሄን ባይንዳይሳ ቤኢዳ ዎዴ ጬጪዲ ባ ማይኦ ዳኪዴስ ");
INSERT INTO gmve_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ኢዚ ጉዬ ባ ኢሻታኮ ቢዲ፥ «ናዚ ሄን ባዋ፤ ሃኢ ታ ኣዋ ሲማ ቦ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ሄሳፌ ጉዬ ኢስቲ ኢሲ ዴይሽ ኤኪ ሹኪዲ ዮሴፌ ማይኦ ሱꬃን ማꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ኢዛ ኣሌቆ ማይኦዛ ኣዋኮ ኤፊዲ ኣዋስ፥ «ኑኒ ሃይሳ ዴሚ ኤኪዶስ፤ ሃይሲ ኔ ናዛ ማይኦኮኔ ሃራኮ ኣኔ ጼላ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ኣዋይካ ማይኦዚ ዮሴፌይሳ ጊዲዳይሳ ኤሪዲ፥ «ኤ ሃይሲ ታ ናዛ ማይኦ! ኢታ ዶኣይ ኢዛ ሚቺዴስ፤ ቱሙካ ዮሴፌ ዶኣይ ፑዜሬꬂ ሞንታ ኣጌና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ያቆቤይካ ሚሼቲዲ ባ ማይኦ ፔꬊ ዬጊዴስ፤ ማቃ ማይኢዲ ዳሮ ዎዴ ጋካናስ ባ ናዛስ ዬኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ኢዛ ኣቱማ ናይቲኔ ማጫ ናይቲ ዉሪ ኢዛ ሚንꬄꬃናስ ኢዛኮ ዪዳ፤ ጊዶ ኣቲን ኢዚ ሚኔቶንታ ኢጺዲ፥ «ሃኔና! ታኒ ዬካዳ ታ ናኮ ባዳ ዱፎን ጌላና» ጊዲ ኢዛ ኣዋይ ኢዛስ ዬኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ሄ ዎዴ ሚዲያሜ ቢታ ኣሳቲ ዮሴፌ ጊብጼ ካዎ ኦሳንቻ ጲጺፋራስ ጊብጼን ባይዚዳ፤ ጲጺፋራይካ ዛቤታ ሃላቃ። ");
INSERT INTO gmve_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ሄ ዎዴ ዩሁዳይ ባ ኢሻታፔ ሻኬቲዲ ኣዱላሜ ጌቴቲዛ ካታማን ዲዛ ሂራ ጌቴቲዛ ኣዴዛራ ዴኣና ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ሄን ዩሁዳይ ሹኣ ጌቴቲዛ ካናኔ ዴሬ ማጫ ና ቤኢዴስ። ኢዚካ ኢዞ ማቾ ኤኪዲ ኢዚራ ዴኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ኢዛ ኢዛስ ሻራዳ ኣቱማ ና ዬላዳ ኤራ ጋ ሱንꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ቃሴካ ሻራዳ ኣቱማ ና ዬላዳ ኦናኔ ጋ ሱንꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ቃሴ ጉጃዳካ ኣቱማ ና ዬላዳ ኢዛ ሴላ ጋ ሱንꬃዱስ። ኢዛካ ኢዛ ኣኪዛቤ ጌቴቲዛ ቢታን ዬላዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ዩሁዳይ ባ ባይራ ናዛ ኤራ ቲኢማሮ ማቾ ኤኪሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ዩሁዳ ባይራ ና ኤራይ ጎዳ ሲንꬃን ኢታ ኣስ ጊዲዳ ጊሻስ ጎዳይ ኢዛ ዎꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ዩሁዳይ ኦናኔ፥ «ኔ ኢሻዛ ማቾ ላታዳ ኢዛስ ላታ ና ዬላዳ ኢዛ ሱንꬅ ጼይጊሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ጊዶ ኣቲን ኦናኔይ ዬሌቲዛ ናይቲ ባስ ጊዶንታይሳ ኤሪዲ ባ ኢሻ ማቼይራ ኣቂዛ ዎዴ ኣይዴካ ባ ኢሻስ ናይ ዬሌቶንታ ማላ ባ ዜሬꬃ ቢታን ጉሴስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","ኢዚ ኦꬂዳይሲ ጎዳ ሲንꬃን ፓራ ጊዲዳ ጊሻስ ጎዳይ ኢዛካ ዎꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","ሄሳፌ ጉዬ ዩሁዳይ ባ ና ማቾ ቲኢማሮ፥ «ታ ናዬ ሴላይ ዲጫና ጋካናስ ኔ ኣዋ ሶ ባዳ ኣምኤቴꬃን ዳሻ» ጊዴስ። ሄሳ ኢዚ ኣዛስ ጊዴ? ጊኮ፥ «ሴላይ ባ ኢሻታ ማላ ሃይቃናኮ» ጊዲ ሂርጊዳ ጊሻሳ። ሄሳ ጊሻስ ቲኢማራ ባዳ ባ ኣዋ ሶን ዴኣዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ዳሮ ዎዴፔ ጉዬ ሹኣ ናያ፥ ዩሁዳ ማቺያ ሃይቃዱስ። ዩሁዳይ ካዮቲ ኣꬂዳፔ ጉዬ ባ ላጌ ኣዱላሜ ዴሬ ኣስ ሂራ ጌቴቲዛይሳራ ባ ዶርሳ ኢስኬ ቃንጺዛ ኣሳቲ ዲዛሶ ቴሚና ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","ኣሳይ ቲኢማሪስ፥ «ቤያ፤ ኔ ቦሎይ ዩሁዳይ ባ ዶርሳታ ኢስኬ ቃንጻናስ ቴሚና ቤስ» ጊ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ኢዛ ባ ኣምኤቴꬃ ማይኦዛ ቃራዳ ባና ባሌꬃናስ ጎስ ኤካ ጉሉንታዳ ቴሚና ኤፊዛ ኦጌ ዶናን ዲዛ ኤናይሜ ካታማ ፔንጌን ኡታዱስ። ሄሳ ኢዛ ኦꬂዳይ ሴላይ ዲጪዲ ጋኪንካ ኢዛ ኢዛስ ማቾ ጊዳናስ ኤኮንታይሳ ኤሪዳ ጊሻሳ። ");
INSERT INTO gmve_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ኢዛ ባ ኣይፌሶ ጉሉንታ ኡቲዳ ጊሻስ ዩሁዳይ ኢዞ ቤኢዲ ላይማ ማጫስ ጊዲ ቆፒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ባ ና ማቾ ጊዲዳይሳ ኤሮንታ ዲሼ ኦጌ ጋጻ ኢዚኮ ሺቂዲ ኢዞ፥ «ታናራ ዚንኣርኪ!» ጊዴስ። ሂስቲን ኢዛ፥ «ታኒ ኔናራ ዚንኢኮ ኔኒ ታስ ኣይ ኢማኔ?» ጋ ኦይቻዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ኢዚካ፥ «ታኒ ታ ሜሄፔ ኢሲ ዴይሻ ላቃ ኔስ ዬዳና» ጊዴስ። ኢዛካ፥ «ኔኒ ሄሳ ታስ ዬዳና ጋካናስ ኣይ ኦይꬃኔ?» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","ኢዚ፥ «ኣይ ኦይꬆ?» ጊ ኢዛ ኦይቺዴስ። ኢዛካ፥ «ኔ ማታሜ ቃላባቴዛ ኢዛ ቃቺዛይሳራኔ ኔ ኩሼን ዲዛ ጉፌዛ ኦይꬃ» ጊን ኢዚ ሄይታ ኢሚዲ ኢዚራ ዚንኢን ኢዛ ኢዛስ ሻራዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ኢዛ ሄሳፌ ዴንዳዳ ቢዳፔ ጉዬ ባ ጉሉንቲዳ ጎሳዛ ቃራዳ ባ ኣምኤቴꬃ ማይኦ ማይኣዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ዩሁዳይ ባ ኦይꬂዳይሳ ኢዚፔ ዛሪ ኤካናስ ዴይሻ ላቃ ባ ላጌ ኣዱላሜ ቦላ ኢዚስ ዬዲዴስ፤ ጊዶ ኣቲን ኢዚ ኢዞ ዴሚቤና። ");
INSERT INTO gmve_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ኢዚ ሄ ቢታ ኣሳ፥ «ኤናይሜ ካታማን ኦጌ ዶናን ኡቲዳ ላይማ ማጫሳያ ኣዋ ባዴ?» ጊ ኦይቺዴስ። ኣሳይ፥ «ላይማ ማጫሲ ሃይሳን ሙሌካ ባዋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","ኢዚካ ዩሁዳኮ ሲሚዲ ኢዛ፥ «ታኒ ኢዞ ዴማቤኬ፤ ሄሳፌካ ቦላራ ሄ ቢታ ኣሳይ፥ ‹ላይማ ማጫሲ ሃይሳን ሙሌካ ዲ ኤሬና› ጊዳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ሂስቲን ዩሁዳይ፥ «ባ ኦይኪዳይሳ ባስ ኤኩ፤ ሂስቶንታ ኣጊኮ ኣሲ ኑና ሚጫና። ሂስቲን ታኒ ኢዚስ ዴይሻ ላቃ ዬዳዲስ፤ ጊዶ ኣቲን ኔኒ ኢዞ ዴማቤካ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ሄꬑ ኣጊናፔ ጉዬ ኣሳይ፥ «ኔ ና ማቺያ ቲኢማራ ላይማታዳ ሻራዱስ» ጊዲ ዩሁዳስ ዮቲዴስ። ዩሁዳይካ፥ «ኢዞ ካሬ ኬሲዲ ታማን ጹጊቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ኢዞ ካሬ ኬሲዛ ዎዴ፥ «ታኒ ሻሪዳይ ሃ ሚሻታ ጎዳሳ፤ ቤያ፤ ሃይሳ ማታሜ ቃላባቴዛ ኢዛ ቃቺዛይሳኔ ሃይሲ ጉፌዚ ኦናይሳኮ ኤራና ዳንዳይኮ ኤራ» ጋዳ ባ ቦሎስ ኪታ ዬዳዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","ዩሁዳይ ሄ ሚሻታ ኤሪዲ፥ «ታፔ ኢዛ ጺሎ፤ ጋሶይካ ታኒ ኢዞ ታ ና ሴላስ ኤካቤኬ» ጊዴስ። ሄሳፌ ጉዬ ኢዚ ኢዚራ ናምኣንꬆ ዚንኢቤና። ");
INSERT INTO gmve_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ኢዛ ዬላና ሃኒዛ ዎዴ ኢዚ ኡሎን ሜንቴ ኣቱማ ናይቲ ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ኢዛ ማሬቲሺን ኢስታፌ ኢሳይ ባ ኩሼ ኬሲን ዬሊሲዛራ፥ «ቤኢቴ፤ ሃይሲ ኮይሮ ኬዜስ» ጋዳ ዞኦ ቃጪና ኢዛ ኩሼን ቃቻዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ጊዶ ኣቲን ኢዚ ባ ኩሼ ጉዬ ኤኪዳ ዎዴ ኢዛ ኢሻይ ዬሌቲን ኢዛ፥ «ኔኒ ዋና ሲንꬃታ ኬዛዲ!» ጋዱስ። ሄሳ ጊሻስ ኢዛ ፓሬሴ ጋ ሱንꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ሄሳፌ ጉዬ ኢዛ ኩሼን ዞኦ ቃጪናይ ቃሼቲ ዲዛ ፓሬሴ ኢሻይ ዬሌቲን ሱንꬃይ ዛራሄ ጌቴቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ኢስማኤሌ ኣሳቲ ዮሴፌ ጊብጼ ኤፊን ጊብጼ ካዎ ኦሳንቻታፔ ጲጺፋራ ጌቴቲዛ ዛቤታ ሃላቃይ ዮሴፌ ኢስማኤሌታፔ ሻሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ጎዳይ ዮሴፌራ ዲዛ ጊሻስ ኢዚ ኦꬂዛይሳ ኡባ ኢዛስ ኢንጄሲዴስ፤ ኢዚካ ባ ጎዳ ሶን ጊብጼን ዴኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ጎዳይካ ኢዛራ ዴኢዛይሳኔ ጎዳይ ኢዚ ኦꬂዳይሳ ኡባ ኢዛስ ኢንጄሲዳይሳ ጲጺፋራይ ቤኢዲ፥ ");
INSERT INTO gmve_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ዮሴፌ ዶሲዴስ። ዮሴፌይካ ኢዛ ኦሳንቻ ጊዲዴስ። ጲጺፋራይ ኢዛ ባ ኬꬃ ኣሳ ቦላ ሱንꬂዲ ባስ ዲዛዝ ኡባ ኢዛ ኩሼን ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ጲጺፋራይ ባ ኬꬃን ዲዛይሳ ኡባ ቦላኔ ባ ኣቆታ ኡባ ቦላ ሱንꬂዳ ዎዴፔ ዶሚን ጎዳይ ጊብጼ ኣዴዛ ኬꬅ ዮሴፌ ጌዶን ኣንጂዴስ። ጎዳ ኣንጆይ ጲጺፋራ ሶን ጊዲን ካሬን ዲዛ ሚሽ ኡባ ቦላ ዎꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ሄሳ ጊሻስ ባስ ዲዛ ኡባ ዮሴፌስ ሼꬊዴስ፤ ኢዚ ባ ሚዛ ካꬃፌ ኣቲን ሃራ ዮሴፌ ኩሼን ዬጊዴስ። ዮሴፌይ ዬጋልꬂኔ ማላ ሎኦ ኣሳ። ");
INSERT INTO gmve_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ጉꬃ ዎዴፔ ጉዬ ኢዛ ጎዳ ማቼያ ዮሴፌ ጫዳ ጼላዳ፥ «ሃ ያ፤ ታናራ ዚንኣ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","ጊዶ ኣቲን ኢዚ ኢጺዴስ፤ ባ ጎዳ ማቼይስ፥ «ቤያ! ታ ጎዳይ ባሶን ዲዛ ኡባ ታስ ሼꬊዲ ኣዛስካ ሂርጌና፤ ባስ ዲዛይሳ ኡባ ታ ኩሼን ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ሃሶን ታፔ ኣꬊዛይ ዴና፤ ኔኒ ኢዛ ማቾ ጊዲዳ ጊሻስ ኔና ጻላ ኣቲን ታ ጎዳይ ታስ ኢሞንታ ሚሺ ባዋ። ሂስቲን ታኒ ሃይሳ ማላ ኢታ ሚሽ ጾሳ ሲንꬃን ዎስታ ኦꬆ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ኢዛ ኡባ ዎዴ ዮሴፌ ሳሌꬂንካ ኢዚ ኤሞ ኢሚቤና፤ ኢዚራ ኢሼች ኣቲን ኢዚኮ ሺቃናዉካ ኮዪቤና። ");
INSERT INTO gmve_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ኢሲ ጋላስ ኢዚ ባ ኦሶ ኦꬃናስ ሶ ጌሊሺን ሶ ኣይሌታፔ ኦኒካ ሶን ባዋ። ");
INSERT INTO gmve_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ኢዛካ ዮሴፌ ማይኦ ሺሻ ኦይካዳ፥ «ታናራ ዚንኣ» ጋዱስ። ጊዶ ኣቲን ኢዚ ባ ማይኦ ኢዚ ኩሼን ዬጊዲ ሶፔ ካሬ ዎጺ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ዮሴፌይ ባ ማይኦ ኢዚ ኩሼን ዬጊዲ ሶፔ ካሬ ዎጺ ኬዚዳይሳ ኢዛ ቤኣዳ፥ ");
INSERT INTO gmve_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ባ ሶ ኣይሌታ ጼይጋዳ ኢስታስ፥ «ቤኢቴ! ታ ኣዚናይ ኤሂዳ ኢብራዌ ኣዴዚ ታና ካዉሺሼ ኣጊዴስ፤ ኢዚ ታናራ ዚንኣናስ ሃ ሶ ጌሊዴስ፤ ጊዶ ኣቲን ታኒ ታ ቃላ ꬎቂሳዳ ዋሳዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ሂስቲን ኢዚ ባ ማይኦ ታ ኣቻን ዬጊዲ ሶፔ ካሬ ዎጺ ኬዚዴስ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ኬꬃ ኣዋይ ያና ጋካናስ ኢዛ ዮሴፌ ማይኦዛ ባ ኣቻን ዎꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ሄሳፌ ጉዬ ኢዛ ኢዛስ፥ «ሄሲ ኔኒ ኑስ ኤሂዳ ኢብራዌ ኣይሌይ ታናራ ዚንኣናስ ታኮ ጌሊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ጊዶ ኣቲን ታኒ ታ ቃላ ꬎቂሳዳ ዋሲን ኢዚ ባ ማይኦ ታ ኣቻን ዬጊዲ ሶፔ ካሬ ዎጺ ኬዚዴስ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","ኬꬃ ኣዋይ ማቼዮ፥ «ኔ ኣይሌይ ታና ሃይሳꬆ ኦꬂዴስ» ጋዳ ዮቲዳ ቃላ ሲዪዲ ዳሮ ሃንቄቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ኢዚካ ዮሴፌ ኤፊዲ ካዎ ቃሾ ኣሳይ ዲዛ ቃሾ ኬꬃን ዬጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ጊዶ ኣቲን ዮሴፌይ ሄን ቃሾ ኬꬃን ዲዛ ዎዴ ጎዳይ ኢዛራ ዴስ። ጾሲ ቃሾ ኬꬃን ኢዛራ ዲዛ ባ ኪያቴꬅ ኢዛስ ዳርሲዴስ። ቃሴካ ቃሾ ኬꬃ ሃላቃዛ ሲንꬃን ኢዛስ ቦንቾ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ሂስቲን ቃሾ ኬꬃ ሃላቃይ ቃሾ ኣሳ ኡባ ዮሴፌ ኩሼን ዎꬂዴስ፤ ሄን ኦሴቲዛይሳ ኡባ ቦላ ኣዋቲዛይ ኢዛ። ");
INSERT INTO gmve_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ጎዳይ ዮሴፌራ ጊዲዲ ኢዚ ኦꬂዛ ኡባ ፖሊሲዛ ጊሻስ ዎይኔ ኬꬃ ኣላፌይ ዮሴፌ ኣላፌቴꬃን ዲዛ ኣይ ሚሻስካ ዋናንዴሻ ጊዲ ሂርጊ ኤሬና። ");
INSERT INTO gmve_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ጉꬃ ዎዴፔ ጉዬ ጊብጼ ካዎ ኡሹ ዱቂዛይታ ኣላፌይኔ ቁማ ካꬂዛይታ ኣላፌይ ባ ጎዳ ጊብጼ ካዎ ቆሂዳ። ");
INSERT INTO gmve_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ካዎይ ኡሹ ዱቂዛይታ ሃላቃኔ ቁማ ካꬂዛይታ ሃላቃታ ናምኣታ ቦላ ኬሂ ሃንቄቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ሄሳ ጊሻስ ዛቤታ ሃላቃዛ ኬꬃን ዮሴፌይ ቃሼቲዳ ዎይኔ ኬꬃን ዬጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ዛቤታ ሃላቃይ ኢስታ ዮሴፌስ ሼꬊን ኢዚ ኢስታስ ኮሺዛ ሚሻን ማዲዴስ፤ ኢስቲካ ቃሾ ኬꬅ ጌሊዲ ጉꬅ ጋምኢዳ ማላ፥ ");
INSERT INTO gmve_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ጊብጼ ካዎስ ኡሹ ዱቂዛይታ ሃላቃይኔ ቁማ ካꬂዛይታ ሃላቃይ፥ ናምኣይካ ቃሾ ኬꬃን ዲሼ ኢሲ ቃማ ኦማርስ ባስ ባስ ኣጉሞ ኣጉሜቲዳ። ናምኣታ ኣጉሞ ቢርሼꬂካ ዱማ ዱማ። ");
INSERT INTO gmve_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ዮሴፌይ ማላዶ ኢስታኮ ጌሊዳ ዎዴ ኢስቲ ሙዞቲ ኡቲዳይታ ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ሄሳ ጊሻስ ባ ጎዳ ቃሾ ኬꬃን ባናራ ዲዛ ካዎ ኦሳንቻታ፥ «ሃች ኢንቴ ኣይፌሶይ ኣዛስ ꬉሚዴ?» ጊ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ኢስቲካ ኢዛስ፥ «ኑኒ ናምኣይ ኣጉሞ ኣጉሜቲዶስ፤ ጊዶ ኣቲን ኑስ ቢርሺዛ ኣሲ ꬋይዴስ» ጊዳ። ዮሴፌይካ ኢስታስ፥ «ኣጉሞ ቢርሺዛይ ጾሳ ጊዴኔ? ኢንቴ ኣጉሞዛ ኣኔ ታስ ዮቲቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ሂስቲን ኡሹ ዱቂዛይታ ሃላቃይ ባ ኣጉሞ ዮሴፌስ፥ «ታኒ ታ ኣጉሞን ኢሲ ዎይኔ ሚꬅ ታ ሲንꬃን ዲዛይሳ ቤኣዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ቃሴ ሄ ዎይኔ ሚꬃስ ሄꬑ ሃጋይ ዴስ። ሄራካ ኣጫዳ ጪያዱስ፤ ሎኤꬃ ዉርጫዳ ኣይፋዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ሄ ዎዴ ፓሮኔ ኡሻ ጹኣይ ታ ኩሼን ዴስ፤ ታኒካ ዎይኔዛ ኣይፌ ማጻዳ ጹኣዛ ጊዶን ጉምኣዳ ኡሻ ፓሮኔስ ኢማዲስ» ጊ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","ሂስቲን ዮሴፌይካ ዛሪዲ፥ «ሄሳ ቢርሼꬂ ሃይሳ፤ ሄꬑ ሃጋቲ ሄꬑ ጋላሳታ። ");
INSERT INTO gmve_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ሄꬑ ጋላሳታ ጊዶን ካዎይ ኔና ዴንꬂዲ ኢዚ ኔና ካሴ ኔ ዲዛ ኣላፌቴꬃን ዎꬃና፤ ካሴ ኔኒ ኡሹ ዱቂዛ ዎዴ ኦꬂዳ ማላ ኔኒ ካዎ ዋንጫ ኢዛ ኩሼን ዎꬃና። ");
INSERT INTO gmve_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ጊዶ ኣቲን ኔስ ዎዴይ ሎኢዳ ዎዴ ታና ባሎፓ፤ ታስካ ኪያ፤ ታ ጊሻስ ካዎስ ዮታዳ ሃ ቃሾ ኬꬃፌ ታና ኬሲሳ፤ ");
INSERT INTO gmve_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ጋሶይካ ታና ኢብራዌታ ቢታፌ ዎልቃራ ሻሚ ኤሂዳ፤ ጊዶ ኣቲን ሃይሳꬆ ታና ቃሾስ ጋꬂዛ ሚሽ ኣይኮካ ኦꬃቤኬ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ካꬅ ካꬂዛይታ ሃላቃይ ዮሴፌይ ኡሹ ዱቂዛይታ ኣጉሞ ሎኤꬂ ቢርሺዳይሳ ቤኢዲ ዮሴፌስ፥ «ታኒካ ኣጉሞ ኣጉሜታዲስ፤ ሄሲካ፥ ‹ታ ሁኤን ሄꬑ ማሶቤ ቶካ ኦይካዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ቦላ ባጋ ማሶቤን ጊብጼ ካዎስ ኡኬቲዳ ዱማ ዱማ ቁማይ ዴስ። ጊዶ ኣቲን ካፎቲ ሄሳ ታ ሁኤን ዲዛ ማሶቤዛፔ ሚዳ› » ጊ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","ሂስቲን ዮሴፌይ፥ «ሄሳ ቢርሼꬃይ ሃይሳ፤ ሄꬑ ማሶቤቲ ሄꬑ ጋላሳታ። ");
INSERT INTO gmve_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ሄꬑ ጋላሳታ ጊዶን ካዎይ ኔና ዴንꬂዲ ኔ ቆꬌ ሙጪዲ ሚꬃ ቦላ ካቂሳና፤ ኔ ኣሾካ ካፎቲ ማና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ሄꬓንꬆ ጋላስ ጊብጼ ካዎይ ባ ዬሌቲዳ ጋላስ ባ ካዎቴꬃን ዲዛ ሹሜታ ኡባስ ጊቢራ ጊግሲዴስ። ኡሹ ዱቂዛይታ ሃላቃኔ ካꬅ ካꬂዛይታ ሃላቃ ቃሾ ኬꬃፌ ኬሲዲ ባ ሹሜታ ሲንꬃን ኤሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ኡሹ ዱቂዛይታ ሃላቃዛ ካሴ ኢዛ ሹሜቴꬃን ዛሪን ኢዚ ካዎ ኩሼን ዋንጫ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ጊዶ ኣቲን ካዎዚ ካꬅ ካꬂዛይታ ሃላቃ ዮሴፌይ ኢዛ ኣጉሞ ቢርሺዳ ማላ ኢዛ ካቂሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ኡሹ ዱቂዛይታ ሃላቃይ ጊዲኮ ዮሴፌ ቆፖንታ ዶጊ ኣጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ናምኡ ላይꬅ ኩሜꬅ ኣꬊዳ ዎዴ ጊብጼ ካዎይ ኣጉሞ ኣጉሜቲዴስ፤ ኣጉሞራ ኢዚ ኣባዬ ሻፋ ዶናን ኤቂ ዲሺን፥ ");
INSERT INTO gmve_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ላፑን ኦርዴኔ ሞꬎ ሚዛቲ ኣባዬ ሻፋፔ ኬዚዲ ሻፋ ኣቻን ማታ ሚሺን ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ኢስታፌ ካሊዲ ሃራ ላፑን ማላ ኢታኔ ጊልቃ ሚዛቲ ኣባዬ ሻፋፔ ኬዚዲ ሻፋዛ ዶናን ዲዛ ሞꬎ ሚዛታ ኣቻን ኤቂዳ። ");
INSERT INTO gmve_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ሄ ሜꬎ ኢታኔ ጊልቃ ሚዛቲ ላፑን ኦርዴኔ ሞꬎ ሚዛታ ሚቲሺን ቤኢዴስ። ሄሳፌ ጉዬ ካዎይ ꬊስኮፌ ቤጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ኢዚ ቃሴካ ꬊስኪዲ ናምኣንꬆ ኣጉሜቲዲ ላፑን ሎኦኔ ሙሩታ ቲያቲ ኢሲ ማቃ ቦላ ዲጪዳይሳ ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ኢስታፌ ካሊዲ ኣይፌ ላፋኔ ጫርኮን ሹሊዲ ሜሊዳ ላፑን ቲያቲ ኬዚዳ። ");
INSERT INTO gmve_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ሄ ላፋ ኣይፌ ቲያቲ ሎኦኔ ሙሩታ ቲያታ ሚቲዳ። ሄሳፌ ጉዬ ካዎዚ ቤጊዲ ኣጉሞ ጊዲዳይሳ ኤሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ጋዴይ ዎንቲሺን ኢዛ ዎዚናይ ሺሮትዴስ፤ ሄሳ ጊሻስ ጊብጼን ዲዛ ቢታንቻታሲኔ ኤራ ኣሳታ ኡባስ ኪቲዲ ጼይጊሲዴስ፤ ካዎይ ኢስታስ ባ ኣጉሞዛ ዮቲዴስ፤ ጊዶ ኣቲን ኢዛስ ሄ ኣጉሞዛ ቢርሻናስ ዳንዳይዛ ኣሲ ቤቲቤና። ");
INSERT INTO gmve_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ሄ ዎዴ ኡሹ ዱቂዛይታ ሃላቃይ ጊብጼ ካዎስ፥ «ታኒ ታ ሞሮ ሃች ቆፓይስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ኢሲቶ ካዎይ ባ ኣይሌስ ሃንቄቲዲ ታናኔ ካꬅ ካꬂዛይታ ሃላቃዛ ቃሾ ኬꬃን ዬጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ኑኒ ሄን ዲሼ ኑስ ኑስ ኣጉሞ ኣጉሜቲዶስ፤ ኣጉሞዛስካ ዱማ ዱማ ቢርሼꬂ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ሄ ዎዴ ዛቤታ ሃላቃዛ ኣይሌ ጊዲዳ ኢሲ ኢብራዌ ፓንꬂ ኑናራ ቃሾ ኬꬃን ዴስ። ኑኒ ኑ ኣጉሞ ኢዛስ ዮቲን ኢዚ ኑስ ሁኤን ሁኤን ኑ ኣጉሞ ቢርሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ሂስቲን ሄ ዮኦቲ ኢዚ ኑስ ቢርሺዳ ማላ ሃኒዳ። ሄሲ ኣዜ ጊኮ ታኒ ካሴ ታ ኣላፌቴꬃን ሲማዲስ፤ ሃንኮይሲ ጊዲኮ ካቄቲዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ሂስቲን ጊብጼ ካዎይ ዮሴፌ ኪቲዲ ጼይጊሲዴስ። ኢስቲ ኢዛ ቃሾ ኬꬃፌ ኤሶን ኤኪ ዪን ባ ሁኤ ሜዴቲዲ ማይኦ ላሚዲ ካዎዛኮ ጌሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ካዎይ ዮሴፌ፥ «ታ ኣጉሜቲዳ ኣጉሞዛ ቢርሻናስ ኦኒካ ዳንዳይቤና። ጊዶ ኣቲን ታኒ፥ ‹ዮሴፌይ ኣጉሞ ሲዪኮ ቢርሻናስ ዳንዳዬስ› ጊዛዝ ሲያዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","ሂስቲን ዮሴፌይ፥ «ታኒ ሄሳ ዳንዳይኬ፤ ጊዶ ኣቲን ጾሳይ ካዎስ ሎኦ ቢርሼꬅ ኢማና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ካዎይካ፥ «ታኒ ታ ኣጉሞን ኣባዬ ሃꬃ ሻፋ ዶናን ኤቂዲሺን፥ ");
INSERT INTO gmve_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ላፑን ጊታኔ ሞꬎ ሚዛቲ ኣባዬ ሻፋፔ ኬዚዲ ሃꬃ ዶናን ማታ ሚሺን። ");
INSERT INTO gmve_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ቃሴካ ኢስታፌ ሃራ ላፑን ሜꬋ ኢታ፥ ጊልቃኔ ላፋ ሚዛቲ ሻፋፔ ኬዚዳ፤ ታኒ ሄሳ ማላ ሜꬋ ኢታ ሚዝ ጊብጼ ቢታን ሙሌካ ቤኣ ኤሪኬ። ");
INSERT INTO gmve_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ሜꬋ ኢታኔ ላፋ ሚዛቲ ኮይሮይታ ላፑን ሞꬎ ሚዛታ ሚቲ ኣጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ጊዶ ኣቲን ኢስቲ ሚቲዳፔ ጉዬካ ኢስታ ሜꬋይ ካሴ ማላካ ኢቲ ኡቲዳ ጊሻስ ኢስቲ ሚቲዳይሳ ኣሲ ኤራናስ ዳንዳይቤና። ሄሳፌ ጉዬ ታኒ ꬊስኮፌ ቤጋዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","«ቃሴካ ኣጉሞራ ላፑን ሎኦኔ ሙሩታ ቲያቲ ኢሲ ማቃ ቦላ ዲጪዳይታ ቤኣዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ቃሴካ ኢስታፌ ሃራ ኣይፌ ላፋኔ ጫርኮን ሹሊዳ ላፑን ቲያቲ ኬዚዳ። ");
INSERT INTO gmve_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ሄ ሹሊ ኡቲዳ ቲያቲ ላፑን ሎኦ ቲያታ ሚቲዳ። ታኒ ሃ ኣጉሞዛ ማሮታስ ዮታዲስ፤ ጊዶ ኣቲን ታስ ኣጉሞዛ ቢርሺዛ ኣሲ ቤቲቤና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ሄሳፌ ጉዬ ዮሴፌይ ጊብጼ ካዎዛ፥ «ናምኣይካ ኔ ቤኢዳ ኣጉሞታ ቢርሼꬃይካ ኢሲኖ። ጾሲ ባ ኦꬃና ሃኒዛይሳ ካዎስ ቆንጪሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ሄ ላፑን ሎኦ ሚዛቲ ላፑን ላይꬃታ፤ ቃሴ ላፑን ሎኦ ቲያቲ ላፑን ላይꬃታ፤ ናምኣይካ ኢሲ ማላ። ");
INSERT INTO gmve_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ሄ ላፑን ሜꬋ ኢታኔ ላፋ ሚዛቲ ላፑን ላይꬃታ፤ ቃሴ ጫርኮን ሹሊዳ ፓꬆንታ ላፑን ቲያቲ ላፑን ኮሻ ላይꬃታ። ");
INSERT INTO gmve_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","«ታኒ ካዎስ ዮቲዳ ማላካ ጾሲ ባ ኦꬃና ሃኒዛይሳ ካዎስ ቤሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ላፑን ዳሮ ካሎ ላይꬃቲ ጊብጼ ቢታስ ኡባስ ያና፤ ");
INSERT INTO gmve_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ጊዶ ኣቲን ላፑን ኮሻ ላይꬃቲ ኢዛፔ ካሊዲ ያና። ሄ ዎዴ ጊብጼ ካሎይ ዉሪ ዶጌታና፤ ቢታይ ኮሻን ሾጬታና። ");
INSERT INTO gmve_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ካሎ ላይꬃታፔ ጉዬ ዪዛ ጋፋ ላይꬃቲ ኬሂ ኢታ ጊዲዳ ጊሻስ ካሴ ካሎይ ሙሌካ ቆፌቶንታ ኣታና። ");
INSERT INTO gmve_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ናምኡቶ ካዎስ ሄ ኣጉሞይ ቤቲዳይ ኣዛሴ ጊኮ ሃይሳ ዮኦዛ ጾሲ ሚንꬂዲ ኩዪዳ ጊሻሳ፤ ጾሲ ሄሳ ኤሶን ኦꬃና። ");
INSERT INTO gmve_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","«ሃኢ ሄኮ ኤሶን ካዎይ ኣꬎ ኤራቴꬂኔ ኣኬካይ ዲዛ ኣስ ኮዪዲ ጊብጼ ቢታን ሱንꬆ። ");
INSERT INTO gmve_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ሄሳꬆካ ላፑን ካሎ ላይꬃታፔ ኢቻሻንꬆ ኩሼ ሺሺዛ ኣላፌታ ካዎይ ሹሞ። ");
INSERT INTO gmve_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ኢስቲ ዪዛ ካሎ ላይꬃታን ካꬅ ሺሺዲ ካዎ ኣዋቴꬃን ሚንጄቶ፤ ሄ ካꬃካ ካታማታን ናጌቶ። ");
INSERT INTO gmve_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ቢታይ ኮሻን ቆሄቶንታ ማላ ሃ ካꬃይ ጊብጼ ቢታን ላፑን ላይꬃን ዴንዳና ኮሻስ ሚንጄቲዲ ዴኦ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ሂስቲን ሃ ዮኦዚ ጊብጼ ካዎሲኔ ኢዛ ኦሳንቻታስ ሎኦ ጊዲዲ ቤቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ሄሳ ጊሻስ ካዎይ ኢስታስ፥ «ኑኒ ጾሳ ኣያናራ ዲዛ ሃይሳ ማላ ሃራ ኣስ ኦና ዴማኔ?» ጊ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ሄሳፌ ጉዬ ካዎይ ዮሴፌ፥ «ጾሲ ሃይሳ ኡባ ኔና ኤሪሲዳ ጊሻስ ኔ ማላ ኣꬎ ኤራቴꬂኔ ኣኬካይ ዲዛ ኣሲ ኦኒካ ባዋ። ");
INSERT INTO gmve_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ታኒ ኔና ታ ኬꬃን ሹማይስ፤ ታ ኣሳይ ዉሪ ኔስ ኣዛዜታና፤ ታኒ ኔፔ ኣꬋናይ ታ ካዎቴꬃ ኣልጋን ጻላ ጊዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ሄሳ ጊሻስ ካዎይ ዮሴፌ፥ «ቤያ! ታኒ ኔና ጊብጼ ቢታ ኡባ ቦላን ሹማዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ሄሳፌ ጉዬ ካዎይ ባ ካዎቴꬃ ቃላባቴ ባ ቢራꬌፌ ኬሲዲ ዮሴፌ ቢራꬌን ኣꬂዴስ፤ ቃሴካ ላይኖፔ ዳዴቲዳ ማይኦ ማይዚዲ ኢዛ ቆꬌንካ ዎርቃ ሎታ ኣꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ካዎይ ባ ናምኣንꬆ ፓራ-ጋሬዛ ዮሴፌ ቶጊሲዴስ፤ ኣይሌቲካ፥ «ዚጊቴ! ዚጊቴ!» ጊዲ ኢዛፔ ሲንꬃራ ቢዳ። ሄሳꬆ ኦꬂዲ ካዎይ ኢዛ ጊብጼ ቢታ ኡባ ቦላ ሹሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ሄሳፌ ጉዬ ካዎይ ዮሴፌ፥ «ታኒ ካዎ! ጊዶ ኣቲን ኔኒ ቃጻ ጎንታ ጊብጼ ቢታ ኡባን ኦኒካ ኩሼ ዎይኮ ቶሆ ቃꬄና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ካዎይ ዮሴፌ፥ «ጻፊናቴ-ፓኢናሄ» ጊ ሱንꬂዴስ፤ ኢዚ ኢዛስ ኦና ጌቴቲዛ ካታማ ቄሴ ጲጺፋራ ናዮ ኣሲናቶ ማቾ ኢሚዴስ። ሂስቲን ዮሴፌይ ኩሜꬃ ጊብጼ ቢታ ዩዪ ጼሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ዮሴፌይ ጊብጼ ካዎስ ኦꬃናስ ዶሚዛ ዎዴ ኢዛስ ላይꬃይ ሄꬑ ታማ። ቃሴ ዮሴፌይ ካዎ ሲንꬃፌ ኬዚዲ ጊብጼ ቢታ ኡባ ዩዪ ጼሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ሄ ላፑን ካሎ ላይꬃታን ቢታይ ኬሂ ዳሮ ካꬅ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ዮሴፌይ ጊብጼ ቢታን ሄ ላፑን ካሎ ላይꬃ ካꬅ ኡባ ሺሺዲ ካታማታን ሚንጂዴስ። ኢሲ ኢሲ ካታማታ ዩሾን ካጺዳ ካꬅ ኡባ ሄ ካታማን ካታማን ሚንጂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","ዮሴፌይ ኣባ ሻሚንታ ማላ ዳሮ ካꬅ ሚንጂዴስ፤ ካꬃይ ዎጋፔ ዳሪን ማካናስ ዳንዳይቤና ጊሻስ ማኪ ማኪ ቆሊዛይሳ ኣጋጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ላፑን ኮሻ ላይꬃይ ያናፔ ካሴ ኦና ጌቴቲዛ ካታማ ቄሴ ጲጺፋራ ናዮ ኣሲናቲፔ ዮሴፌይ ናምኡ ኣቱማ ናይታ ዬሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","ዮሴፌይ፥ «ጾሲ ታና ታ ሜቶኔ ታ ኣዋ ሶ ኣሳ ኡባ ዶጊሲዴስ» ጊሼ ባ ኮይሮ ናዛ ሚናሴ ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ናምኣንꬆ ናዛካ፥ «ጾሲ ታስ ታ ቱጋቲዳ ቢታን ታና ኣይፊሲዴስ» ጊሼ ኤፍሬሜ ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ጊብጼ ቢታን ዲዛ ሄ ላፑን ካሎ ላይꬃቲ ዉሪዳ። ");
INSERT INTO gmve_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ቃሴ ዮሴፌይ ካሴቲ ዮቲዳ ማላ ላፑን ኮሻ ላይꬃቲ ዶሚዳ። ሃራ ቢታ ኡባን ኮሻይ ዴንዲዴስ፤ ጊዶ ኣቲን ጊብጼ ቢታ ኡባን ካꬂ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ጊብጼ ዴሬይ ዉሪ ኮሻቲዳ ዎዴ ኣሳይ፥ «ካꬅ ኢማ» ጊ ካዎስ ዋሲን ካዎዚ ጊብጼ ኣሳ ኡባ፥ «ዮሴፌኮ ቢዲ ኢዚ ዮቲዛይሳ ኦꬂቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ኮሻይ ጊብጼ ቢታ ኡባ ጋኪዳ ዎዴ ዮሴፌይ ካꬅ ሚንጂዳ ኬꬃታ ኡባ ዶይዲ ካꬅ ጊብጼ ኣሳስ ባይዚሲዴስ፤ ጋሶይካ ኮሻይ ኩሜꬃ ጊብጼን ሚኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ሳኣ ኡባን ኮሻይ ሱሊዳ ጊሻስ ቢታን ዲዛ ኣሳይ ዉሪ ካꬅ ዮሴፌፔ ሻማናስ ጊብጼ ዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ያቆቤይ ጊብጼን ካꬂ ዲዛይሳ ሲዪዲ ባ ኣቱማ ናይታ፥ «ኢንቴ ኢሶይ ኢሳራ ኣዛስ ጼሌቴቲ? ");
INSERT INTO gmve_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ቤኢቴ! ጊብጼን ካꬂ ዲዛይሳ ታኒ ሲያዲስ፤ ዱጌ ጊብጼ ቢዲ ኑ ሃይቆንታ ፓጻ ዳና ማላ ሄፔ ካꬅ ኑስ ሻሚ ኤሂቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ሄሳ ጊሻስ ዮሴፌ ኢሻቲ ታማቲ ካꬅ ሻማናስ ዱጌ ጊብጼ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ጊዶ ኣቲን ያቆቤይ ዮሴፌ ኢሻ ቢኒያሜ ኢዚ ቆሄታናኮ ጊዲ ቆፒዳ ጊሻስ ኢዛ ኢሻታራ ዬዲቤና። ");
INSERT INTO gmve_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ካናኔ ቢታን ዎልቃማ ኮሻይ ዲዛ ጊሻስ ካꬅ ሻማና ቢዛይታራ ኢስራኤሌ ኣቱማ ናይቲ ጊብጼ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ሄ ዎዴ ዮሴፌይ ሄ ቢታ ኣይሲዛዴኔ ቢታን ዲዛ ኣሳ ኡባስ ካꬅ ባይዚሲዛይ ኢዛ ጊዲዳ ጊሻስ ዮሴፌ ኢሻቲ ጋኪዳ ማላ፥ ባ ሁኤ ቢታን ጋꬂዲ ኢዛስ ዚጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","ዮሴፌይ ባ ኢሻታ ቤኢዳ ማላ ኤሪዴስ ሺን ኢዚ ኢስታ ኤሮንታ ኣሳ ማላ ሃንቆ ቃላን ኢስታ፥ «ኢንቴ ኣዋፔ ዪዴቲ?» ጊ ኦይቺዴስ። ኢስቲካ፥ «ካꬅ ሻማናስ፥ ካናኔ ቢታፌ ዪዶስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ዮሴፌይ ባ ኢሻታ ኤሪዴስ፤ ኢስቲ ጊዲኮ ኢዛ ኤሪቤቴና። ");
INSERT INTO gmve_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ሄራካ ዮሴፌይ ኢስታ ጊሻስ ኣጉሜቲዳ ኣጉሞዛ ቆፒዲ ኢስታስ፥ «ኢንቴ ዴሬ ጾሞሲዛ ኣሳ፤ ኢንቴ ኑ ቢታን ናጌይ ሌፒዛ ባጋይ ኣዋይሳኮ ጼላናስ ዪዴታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ሂስቲን ኢስቲ፥ «ኑ ጎዶ! ኑኒ ዴሬ ጾሞሲዛ ኣስ ጊዶኮ፤ ኑኒ ኔ ኣይሌቲ ካꬅ ሻማናስ ዪዶስ። ");
INSERT INTO gmve_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ኑ ዉሪካ ኢሲ ኣዋ ናይታ። ኑኒ ኔ ኣይሌቲ ኣማኔቲዛ ኣሳ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ሂስቲን ዮሴፌይ ኢስታስ፥ «ጊዴኬታ! ኢንቴ ኑ ቢታን ናጎይ ሌፒዛ ባጋይ ኣዋይሳኮ ጾሞሲ ጼላና ዪዴታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ጊዶ ኣቲን ኢስቲ፥ «ኑኒ ኔ ኣይሌቲ ታማኔ ናምኡ ኢሻታኔ ካናኔ ቢታን ዲዛ ኢሲ ኣዋ ናይታ። ዉርሴꬃ ካሎይ ሃኢ ኑ ኣዋራ ዴስ፤ ኢሶይ ጊዲኮ ꬋይዴስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ዮሴፌይ ኢስታስ፥ «ታኒ ኢንቴስ ዮቲዳ ማላካ ኢንቴ ቢታ ጾሞሲዛይታ። ");
INSERT INTO gmve_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ቃሴ ኢንቴ ፓጬታናይ ሃይሳና፤ ቱሙፔ ካዎይ ቤዪን! ኢንቴ ዉርሴꬃ ካሎ ኢሻይ ሃ ዮንታ ኢጺኮ ኢንቴ ሃይሳፌ ቤኬታ። ");
INSERT INTO gmve_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ኢንቴ ዮቲዛይሲ ቱሙኮኔ ፓጫናስ፥ ኢንቴፌ ኢሳዴ ኪቲቴ፤ ኢዚ ኢንቴ ኢሻ ኤኪ ዮ፤ ኣቲዳይቲ ቃሾ ኬꬃን ጋምኤታ። ሄሳ ማላ ጊዶንታ ኣጊኮ ካዎይ ቤዪን! ኢንቴ ዩዪ ዩዪ ዴሬ ጾሞሲዛ ኣሳ» ");
INSERT INTO gmve_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ጊዲ ኢስታ ሄꬑ ጋላሳስ ቃሾ ኬꬃን ዬጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ሄꬓንꬆ ጋላሳን ዮሴፌይ ኢስታስ፥ «ታኒ ጾሳስ ባቢዛ ኣሳ፤ ኢንቴ ኢሲ ሚሽ ኦꬂኮ ኢንቴ ሼምፖ ኣሼታ። ");
INSERT INTO gmve_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ኢንቴ ቱሙካ ኣማኔቲዛ ኣስ ጊዲኮ ኢንቴ ኢሻታፔ ኢሶይ ሃይሳን ቃሾ ኬꬃን ዶ፤ ኣቲዳይቲ ጋፊዳ ኢንቴሶ ኣሳስ ካꬅ ኤኪ ቢቴ፤ ");
INSERT INTO gmve_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ጊዶ ኣቲን ኢንቴ ቃላይ ቱሙ ጊዳና ማላኔ ኢንቴ ሃይቆንታ ማላ ኢንቴ ኢንቴ ዉርሴꬃ ካሎ ኢሻ ታኮ ኤኪ ያናስ ኮሼስ» ጊዴስ። ኢስቲካ ሃ ዮኦዛን ኤሮ ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ኢስቲ ኢሶይ ኢሳ፥ «ቱሙ ኑ ኦꬂዳ ጌኔይ ኑና ጋኪዴስ። ኢዚ ባ ሼምፖስ ሃኒዛዚ ኢጺን ኑና ሾቢዛ ዎዴ ኑኒ ሲዪሼ ኢጺዶስ፤ ሃ ዋዬይ ኑና ጋኪዳይ ሄሳ ጊሻሳ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ኦሮቤሌይ፥ «ታኒ ኢንቴና፥ ‹ናዛ ቦላ ናጋራ ኦꬆፍቴ› ጋዳ ዮታዲስ፤ ጊዶ ኣቲን ኢንቴ ሲዮንታ ኢጺዴታ። ሂስቲን ሃኢ ኢዛ ሱꬃ ጎሜይ ኑና ሞቴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ኢስቲ ጊዛይሳ ዮሴፌይ ኤሪዛይሳ ኢስቲ ኣኬኪቤቴና፤ ኣይስ ጊኮ ኢዚ ኢስታራ ዎካሌን ሃሳዬስ። ");
INSERT INTO gmve_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","ኢዚ ኢስታፌ ሻኬቲ ጉዬ ሲሚዲ ዬኪዴስ፤ ጊዶ ኣቲን ቃሴ ኢስታኮ ሲሚዲ ኢስታ ሃሳይሲዴስ። ኢዚ ሲሞና ኢስታፌ ዱꬂ ኣሺዲ ኢስቲ ቤኢሺን ኢዛ ቃቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ዮሴፌይ ባ ኣይሌታ፥ «ካꬅ ኢስታ ኦጎሮ ኩንꬂቴ፤ ኢስታ ቢራካ ዛሪዲ ኢስታ ኦጎሮን ኦጎሮን ዬጊቴ፤ ቃሴ ኢስታስ ኦጌ ሺንቄ ኢሚቴ» ጊ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ኢስቲ ኢዚ ጊዳ ማላ ኦꬂዳፔ ጉዬ ዮሴፌ ኢሻቲ ካꬃ ባ ሃሬታን ጫኒዲ ዴንዲ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ኢስቲ ኦጌ ቦላ ኣቃናስ ሼምፒዳሶን ኢስታፌ ኢሳይ ባ ሃሬዛስ ካꬃፌ ዬጋናስ ባ ኦጎሮ ቢርሺዲ፥ ኦጎሮዛ ዶናን ዲዛ ባ ቢራ ዴሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ኢዚ ባ ኢሻታ፥ «ታ ቢራይ ታስ ሲሚዴስ፤ ቱማ ሃይሳ ቤኢቴ! ታ ኦጎሮን ዴስ» ጊዴስ። ኢስቲ ዳጋሚዲ ኮኮሪሼ ኢሶይ ኢሳኮ ሲሚዲ፥ «ጾሲ ኣዛስ ኑ ቦላ ሃይሳ ኦꬂዴ?» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ኢስቲ ካናኔ ቢታን ዲዛ ባ ኣዋ ያቆቤኮ ሶ ሲሚ ዪዲ ባ ቦላ ጋኪዳይሳ ኡባ ኢዛስ ዮቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","ኢስቲ ኢዛስ፥ «ሄ ቢታይስ ጎዳ ጊዲዳ ኣዴዚ ኑና ባቢሲዴስ፤ ሄሳፌ ጉዬ ኢዚ ኑና ሄ ቢታ ዩዪ ዩዪ ጾሞሲ ጼሊዛ ኣሳ ማላ ኦꬂ ጎዳቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ጊዶ ኣቲን ኑኒ ኢዛስ፥ ‹ኑ ኣማኔቲዛ ኣሳ፤ ዴሬ ጾሞሲ ጼሊዛ ኣስ ጊዶኮ። ");
INSERT INTO gmve_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ኑኒ ታማኔ ናምኡ ኢሻቲ ኢሲ ኣዋ ናይታ፤ ኢሶይ ꬋይዴስ፤ ዉርሴꬃ ካሎይ ካናኔ ቢታን ሃኢ ኑ ኣዋራ ዴስ› ጊ ዮቲዶስ። ");
INSERT INTO gmve_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","ሂስቲን ሄ ቢታይስ ጎዳ ጊዲዳ ኣዴዚ ኑና፥ ‹ኢንቴ ኣማኔቲዛ ኣስ ጊዲዳይሳ ታኒ ሃይሳን ኤራና፤ ኢንቴ ኢሻታፔ ኢሳ ሃን ታ ኣቻን ዬጊዲ ጋፊዳ ኢንቴ ሶ ኣሳስ ካꬅ ኤኪ ቢቴ። ");
INSERT INTO gmve_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ኢንቴ ዴሬ ዩዪ ዩዪ ጾሞሲዛዴ ጊዶንታ፥ ኣማኔቲዛ ኣስ ጊዲዳይሳ ታኒ ኤራና ማላ፥ ኢንቴ ዉርሴꬃ ካሎ ኢሻ ታኮ ኤኪ ዪቴ። ሂስቲኮ ታኒ ሃን ኣቲዳ ኢንቴ ኢሻ ኢንቴስ ዛራ ኢማና፤ ኢንቴካ ሃ ቢታን ዛልኣና ዳንዳዬታ› ጊዴስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","ኢስቲ ባ ኦጎሮፔ ኦጎሮፔ ካꬃ ቆሊዲ ባ ኦጎሮን ኦጎሮን ቢራይ ቃሾራ ኡቲዳይሳ ዴሚዳ። ኢስቲኔ ኢስታ ኣዋይ ሄ ቃሾራ ዲዛ ቢራ ቤኢዲ ባቢዳ። ");
INSERT INTO gmve_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","ኢስታ ኣዋ ያቆቤይ ኢስታስ፥ «ኢንቴ ታና ታ ናይታፔ ሜላ ኬሲዴታ፤ ዮሴፌይ ባዋ፥ ሲሞኒ ባዋ፤ ቃሴ ኢንቴ ቢኒያሜ ኤፋና ኮዬታ። ዉሪ ታስ ꬉማ ጊርዲ ጊዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ሄሳፌ ጉዬ ኦሮቤሌይ ባ ኣዋ፥ «ታኒ ቢኒያሜ ኔስ ዛራ ኤሆንታ ኣጊኮ ታ ኣቱማ ናይታ ናምኣታካ ዎꬋ፤ ታና ኣማኔታዳ ኢዛ ታ ኩሼን ኢማ፤ ቃሴ ታኒ ኢዛ ዛራዳ ኤሃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ጊዶ ኣቲን ያቆቤይ ኢስታስ፥ «ታ ናዚ ኢንቴናራ ዱጌ ቤና፤ ኢዛ ኢሻይ ሃይቂን ኣቲዳይ ኢዛ ጻላ፤ ኢንቴ ኤፊሺን ኦጌን ኢታ ሚሺ ኢዛ ጋኪዛ ጊዲኮ ኢንቴ ታና ዬሆራኔ ሙዞራ ዱፎን ኤፋና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ሃኢካ ኮሻይ ካናኔ ቢታን ሚኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ሂስቲን ኢስቲ ጊብጼፔ ኤሂዳ ካꬃይ ሙሌራ ዉሪን ኢስታ ኣዋይ፥ «ቃሴካ ጉዬ ቢዲ ኑስ ጉꬃ ካꬅ ሻሚቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ጊዶ ኣቲን ዩሁዳይ ኢዛስ፥ «ሄ ኣዴዚ ኑና፥ ‹ኢንቴ ኢሻ ኢንቴናራ ኤኪ ዮንታ ኣጊኮ ታ ኣይፌሶ ናምኣንꬆ ቤኤኬታ› ጊዲ ሎኤꬂ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ኔኒ ኑ ኢሻ ኑናራ ዬዲኮ ኑኒ ዱጌ ቢዲ ኔስ ካꬅ ሻማና። ");
INSERT INTO gmve_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ጊዶ ኣቲን ኔኒ ኢዛ ዬዶንታ ኢጺኮ ኑኒ ዱጌ ቦኮ፤ ኣይስ ጊኮ ሄ ኣዴዚ ኑና፥ ‹ኢንቴ ኢሻ ኢንቴናራ ኤሆንታ ኣጊኮ ኢንቴ ታ ኣይፌሶ ናምኣንꬆ ቤኤኬታ› ጊዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ኢስራኤሌይካ፥ «ኢንቴ፥ ‹ኑስ ሃራ ኢሻይ ዴስ› ጊ ዮቲዲ ሃይሳ ሃ ሜቶዛ ታ ቦላ ኣይስ ኤሂዴቲ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ኢስቲካ ኢዛስ፥ «ሄ ኣዴዚ ኑ ጊሻሲኔ ኑሶ ኣሳ ጊሻስ ሎኤꬂ ኦይቺዴስ። ኢዚ ኑና፥ ‹ኢንቴ ኣዋይ ሃኢካ ፓጻ ዲዜ? ኢንቴስ ሃራ ኢሻይ ዲዜ?› ጊ ኦይቺን ኑኒ ኢዚ ኦይቺዳ ኦይሾዛስ ዛሮ ኢሚዶስ። ኢዚካ ኑና፥ ‹ኢንቴ ኢሻ ዱጌ ሃ ኤኪ ዪቴ› ጋናይሳ ኑኒ ኣዛን ኤሪኖ?» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ዩሁዳይ ባ ኣዋ ኢስራኤሌ፥ «ኑኒካ፥ ኔኒካ፥ ኑ ናይቲካ ሃይቆንታ ፓጻ ዳና ማላ ናዛ ታናራ ዬዳ፤ ኑኒ ሃኢ ኤሌሊዲ ባና። ");
INSERT INTO gmve_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ናዛ ኑስ ታ ዋሴቴꬃን ኢማ፤ ኢዛ ጊሻስ ታና ኦይቻ፤ ታኒ ኢዛ ኔስ ሎኦራ ዛራ ኤሆንታ ኣጊኮ ታ ዲዛ ዎዴ ኡባን ታ ኦይሼታና። ");
INSERT INTO gmve_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ኑኒ ሃን ጋምኦንታኮ ሃኒ ዎዴ ናምኣንꬆ ጌዴ ጋኪዲ ሃ ሲማና ሺን» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ሄሳፌ ጉዬ ኢስታ ኣዋ ኢስራኤሌይ ኢስታስ፥ «ሄሳ ጊዲኮ ሂስቲቴ፤ ሄ ኣዴዛስ ኩሼ ጌንꬆ ሚሽ ኑ ቢታን ሞኪዛ ሚሽ ኡባፌ ሎኢዛይሳ ዶሪቴ፤ ሄሲካ ሺቶ፥ ኤስ፥ ሳዎ፥ ካርቤ፥ ሚꬃ ኣይፌታ ኢንቴ ኦጎሮን ዬጊ ኤኪ ቢቴ። ");
INSERT INTO gmve_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ኢንቴ ኦጎሮ ዶናን ሲሚዳ ቢራዚ ባሌታን ሲሚዳዝ ጊዳና ዳንዳይዛ ጊሻስ ቢራካ ናምኡ ኩሼ ሂስቲ ኤኪ ቢቴ። ");
INSERT INTO gmve_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ቃሴ ኢንቴ ኢሻካ ኤኪዲ ሄ ኣዴዛኮ ኤሶን ጉዬ ቢቴ። ");
INSERT INTO gmve_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ኢዚ ሃንኮ ኢንቴ ኢሻ ዬዳና ማላ ቢኒያሜይካ ኢንቴናራ ሲሚ ያና ማላ ኡባ ዳንዳይዛ ጾሳይ ሄ ኣዴዚ ኢንቴስ ቃꬌታና ማላ ኦꬆ፤ ታኒ ጊዲኮ ታ ናይታፔ ሜላ ኣቲኮኔ ኣታይስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ሄሳ ጊሻስ ሄ ኣሳቲ ኩሼ ጌንꬆ ካሴ ቢራስ ናምኡ ኩሼ ቃሴ ቢኒያሜ ኤኪዲ ዱጌ ጊብጼ ቢዲ ዮሴፌ ሲንꬅ ሺቂዳ። ");
INSERT INTO gmve_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ዮሴፌይ ባ ኢሻታራ ቢኒያሜ ቤኢዲ ባ ኬꬃ ሃላቃዛ፥ «ሃ ኣሳታ ታሶ ኤካዳ ባ፤ ሃቻ ጋላስ ኢስቲ ታናራ ቁማ ማና ማላ ሜሄ ሹካዳ ጊጊሳ» ጊ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ሂስቲን ኢዚ ዮሴፌይ ኢዛስ ዮቲዳ ማላ ሄ ኣሳታ ዮሴፌሶ ኤፊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","ኣሳቲ ዮሴፌ ሶ ቢዳ ጊሻስ ባቢዳ፤ ኢስታስ፥ «ኢስቲ ኑና ሃይሳ ኤሂዳይ ኮይሮ ኑ ኦጎሮራ ሲሚ ቢዳ ቢራ ጊሻስ ጊዶንታ ኣጌና፤ ኢዚ ኑና ቆሃናስ ኣይሌቴꬃን ሃራናሲኔ ኑ ሃሬታ ኤካናስ ሃኔስ» ጊ ቆፒዳ። ");
INSERT INTO gmve_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ሄሳ ጊሻስ ኢስቲ ዮሴፌ ኬꬃ ፔንጌ ጋኪዲ ኬꬃ ሃላቃዛ፥ ");
INSERT INTO gmve_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«ኑ ጎዶ! ኑኒ ኮይሮ ካꬅ ሻማናስ ሃ ዪዶስ፤ ");
INSERT INTO gmve_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ሲሚዲ ቢሼ ኑ ኣቂዛሶን ኦማርስ ኑ ኦጎሮ ኦጎሮ ኑ ቢርሺን ኑ ቢራይ ፓጮንታ ኑ ኦጎሮ ኦጎሮ ዶናን ዲዛይሳ ዴሚዶስ፤ ሄሳ ጊሻስ ሃኢ ኑኒ ኢዛ ጉዬ ኤኪ ዪዶስ። ");
INSERT INTO gmve_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ቃሴ ኑኒ ካꬅ ሻማናስ ሃራ ቢራካ ኤኪ ዪዶስ። ኑ ቢራ ኑ ኦጎሮ ኦጎሮ ዶናን ኦኒ ዎꬂዳኮ ኑ ኤሮኮ» ጊ ሃሳይሲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ሂስቲን ኢዚ ኢስታስ፥ «ኣይኮይ ባ ሄሳስ ባቦፍቴ! ኢንቴ ጾሲ ኢንቴ ኣዋ ጾሲ ኢንቴ ኦጎሮ ጊዶን ኢንቴስ ቢራ ኢሚዴስ፤ ታኒ ኢንቴ ቢራ ኤካዲስ» ጊዴስ። ሄሳፌ ጉዬ ሲሞና ኢስታኮ ኬሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ሄ ኣዴዚ ሄ ኣሳታ ዮሴፌ ሶ ኤፊዲ ኢስታ ቶሆስ ሃꬅ ኤሂን ባ ቶሆ ሜጬቲዳ። ኢስታ ሃሬታስካ ሃርቆ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ዮሴፌራ ቁማ ማና ማላ ኢስታስ ዮቴቲዳ ጊሻስ ዮሴፌይ ያና ጋካናስ ኢዛስ ኢማና ኩሼ ጌንꬆ ጊግሲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","ዮሴፌይ ባሶ ጌሊዳ ማላ ኢስቲ ባ ጊግሲዳ ኩሼ ጌንꬆዛ ኢዛስ ኢሚዲ ኢዛ ሲንꬃን ባ ሁኤ ዱጌ ቢታን ጋꬂ ዚጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","ኢዚ ኢስታ ሳሮቴꬅ ኦይቺ ሲሚዲ፥ «ኢንቴ ታስ ዮቲዳ ኢንቴ ጪማ ኣዋይ ሎኢ ዲዜ? ሃኢካ ኢዚ ፓጻ ዲዜ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ሂስቲን ኢስቲ፥ «ኤ፥ ኔ ኣይሌይ ኑ ኣዋይ ሃኢካ ፓጻ ዴስ፤ ኢዚ ሎኦኮ» ጊ ሆኪ ኢዛስ ዚጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","ኢዚ ባ ኣዬይ ና ቢኒያሜ ቤኢዲ ኢስታስ፥ «ኢንቴ ዮቲዳ ኢንቴ ዉርሴꬃ ካሎ ኢሻይ ሃይሴ?» ጊዴስ። ቃሴ ኢዚ ቢኒያሜ፥ «ታ ናዞ ጾሲ ኔና ኣንጆ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ዮሴፌይ ባ ኢሻ ቤኢን ኢዛስ ዬሆይ ዳንዳዬቶንታ ኢጺን ዬካናስ ኢሲፌ ኢሲሶ ፖቂዴስ። ኢዚ ባ ዱማ ቆልኣ ጌሊዲ ሄን ዬኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ኢዚ ባ ኣይፌሶ ሜጬቲ ሲሚ ኬዚዲ ባርካ ባና ሚንꬄꬂዲ፥ «ቁማ ሃ ኣꬂቴ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ሂስቲን ኢስቲ ኢዛስ ዱማ፥ ኢዛ ኢሻታስ ዱማ፥ ሄን ኢዛራ ሚዛ ጊብጼ ኣሳታስ ዱማ ኣꬂዳ፤ ኣይስ ጊኮ ጊብጼ ኣሳይ ኢብራዌ ኣሳራ ኢሲፌ ሚ ኤሬቴና። ሄሲካ ጊብጼ ቢታ ኣሳስ ቱናቴꬃ። ");
INSERT INTO gmve_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ኢስቲ ዮሴፌ ሲንꬃን ባይራይ ባ ባይራቴꬃ ማላ ካሎይ ባ ካሎቴꬃ ማላ ማራን ኡቲዳ። ኢስቲ ኢሶይ ኢሳ ጼሊዲ ኢስታ ዎስቲ ኡቲሲዳኮ ቤኢዲ ማላሌቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ዮሴፌይ ባ ጊሻፔ ኢስታስ ቁማ ጊሺዛ ዎዴ፥ ቢኒያሜ ጋኪዳይሲ ሃራታይሳፌ ኢቻሹ ኩሼ ዳሬስ፤ ሂስቲን ኢስቲ ኡፋዬቲሼ ኢዛራ ሚዳኔ ኡዪዳ። ");
INSERT INTO gmve_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ዮሴፌይ ባ ኬꬃ ሃላቃዛስ፥ «ኔኒ ሃ ኣሳታ ኦጎሮይ ኤኪዛ ኬና ካꬅ ኢስታስ ኩንꬃ፤ ኢስታ ቢራ ኡባ ኢስታ ኦጎሮ ኦጎሮ ዶናን ዎꬃ፤ ");
INSERT INTO gmve_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ሂስታዳ ዉርሴꬃ ካሎዛ ኦጎሮ ዶናን ታ ቢራ ዋንጫኔ ኢዛ ካꬃ ቢራ ዎꬃ» ጊ ኣዛዚን ኢዚ ዮሴፌይ ጊዳ ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","ጋዴይ ዎንቲሺን ሄ ኣሳቲ ባ ሃሬታ ኤኪዲ ባና ማላ ሞይዚዳ። ");
INSERT INTO gmve_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ኢስቲ ሄ ካታማፔ ኬዚዲ ሃኪ ቢቾንታ ዲሺን ዮሴፌይ ባ ኬꬃ ሃላቃስ፥ «ዴንዳ! ሃ ኣሳታ ጉዬ ካላ፤ ኔኒ ባ ኢስታ ጋካዳ፥ ‹ኢንቴ ኣይስ ኪያ ጊሻስ ኢታ ዛሪዴቲ?› ");
INSERT INTO gmve_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","‹ኣይስ ታ ጎዳ ቢራ ዋንጫ ካይሲዴቲ? ሃይሲ ታ ጎዳይ ኡዪዛይሳኔ ቃሴ ጹራ ሚሽ ዴሚዛ ዋንጫ ጊዴኔ? ሃይሲ ኢንቴ ኦꬂዳይሲ ጊታ ቆሆ› ጋ» ጊዴስ። ሄ ዎዴ ጊብጼ ቢታ ኣሳቲ ዋንጫ ጋርሳን ዲዛ ኡሻ ቤኢዲ ሲንꬃፌ ኣዚ ሃናናኮ ኤሬቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","ሂስቲን ኢዚ ኢስታ ጉዬራ ጋኪዲ ኢዚ ጊዳ ማላካ ኢስታስ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ጊዶ ኣቲን ኢስቲ፥ «ኑ ጎዳይ ኣዛስ ሃይሳ ማላ ቃላ ኑ ቦላ ሃሳይዜ? ሄሳ ማላ ሚሽ ኦሶይ ኑፔ ኔ ኣይሌታፔ ሃኮ! ");
INSERT INTO gmve_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ሃራይ ኣቶሺን ሃይሳፌ ካሴ ኑ ኦጎሮ ዶናፔ ዴሚዳ ቢራ ካናኔ ቢታፌ ጉዬ ኔስ ኑ ዛሪ ኤሂዳይሳ ኔ ኤራሳ። ሂስቲን ሃኢ ኑኒ ኔ ጎዳ ሶፔ ዎስቲዲ ቢራ ዎይኮ ዎርቃ ካይሲዞኒ? ");
INSERT INTO gmve_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ኔ ኣይሌታ ኑ ጊዶፌ ሄ ዋንጫይ ኢዛኮን ቤቲዳዴይ ሃይቆ፤ ቃሴ ኣቲዳ ኑኒ ኑ ጎዳስ ኣይሌ ጊዳና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ኢዚ ኢስታስ፥ «ሄሳ ማላ ጊዲኮ ሎኦ፤ ኢንቴ ጊዳ ማላ ጊዶ፤ ዋንጫዛ ኤኪዳ ኡራይ ኦኒካ ታ ኣይሌ ጊዳና፤ ሃንኮ ኣቲዳ ኢንቴ ጊዲኮ ሳሮራ ባና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ሄሳፌ ጉዬ ኢስቲ ኤሶን ባ ኦጎሮ ኦጎሮ ዎꬂ ቢርሺዳ። ");
INSERT INTO gmve_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ሃላቃዚካ ኡባፌ ባይራቲዛይሳ ኦጎሮፔ ዶሚዲ ዉርሴꬃ ካሎዛይሳ ጋካናስ ኮዪዴስ፤ ሄ ዋንጫዛካ ቢኒያሜ ኦጎሮ ጊዶፌ ዴሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ሂስቲን ኢስቲ ሙዞቲዲ ባ ማይኦ ዳኪዳ፤ ባ ኦጎሮ ኦጎሮ ባ ሃሬታን ጫኒዲ ጉዬ ካታማ ሲሚዳ። ");
INSERT INTO gmve_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","ዩሁዳይ ባ ኢሻታራ ዮሴፌኮ ጌሊዛ ዎዴ ዮሴፌይ ሶን ዲዛይሳ ዴሚዲ ኢስቲ ኢዛ ሲንꬃን ጉፋኒዳ። ");
INSERT INTO gmve_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ዮሴፌይ ኢስታስ፥ «ኢንቴ ኣይ ፓላ ሚሽ ኦꬂዴቲ? ታ ማላ ኣሲ ጹራ ሚሺ ሄሳꬆ ዴሚዛይሳ ኤሬኬቲዬ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ሂስቲን ዩሁዳይ፥ «ኑ ጎዳስ ኑ ኣይ ጋኔ? ኑኒ ኣይ ሃሳያኔ? ዎይኮ ኑኒ ጺሎቴꬅ ዎስቲ ቤሳኔ? ጾሲ ኔ ኣይሌታ ሞሮ ቆንጪሲዴስ። ሂስቲን ኑናካ ጊዲን ሄ ዋንጫይ ኢዛፔ ቤቲዳይሲካ ጊዲን ታ ጎዳስ ኣይሌ ጊዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ጊዶ ኣቲን ዮሴፌይ፥ «ሄሳ ማላ ሚሽ ኦሶይ ታፔ ሃኮ፤ ታ ቢራ ዋንጫዚ ኢዛፔ ቤቲዳ ኣዴዚ ጻላ ታ ኣይሌ ጊዳና። ሂስቲኮ ኢንቴ ኢንቴ ኣዋኮ ጉዬ ሳሮን ሲሚቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ሂስቲን ዩሁዳይ ኢዛኮ ሺቂዲ ኢዛ፥ «ታ ጎዶ! ታኒ ኢሲ ቃላ ሃሳያና ማላ ኔና ዎሳይስ፤ ኔ ካዎ ፓሮኔ ማላ ጊዲኮካ ታና ኔ ኣይሌዛ ቦላ ሃንቄቶፋ። ");
INSERT INTO gmve_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","ኔኒ ታ ጎዳይ ኑና ኔ ኣይሌታ፥ ‹ኢንቴስ ኣዋይ ዲዜ ዎይኮ ኢሻይ ዲዜ?› ጋ ኦይቻዳሳ። ");
INSERT INTO gmve_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ኑኒካ፥ ‹ኑስ ጪሚዳ ኣዋይ ዴስ፤ ኢዚ ጪሚዲ ዬሊዳ ካሎ ናይካ ዴስ፤ ሄ ናዛ ኢሻይ ሃይቂዴስ፤ ባ ኣዬይስ ኢሲ ኢዛ ጻላይ ኣቲዴስ፤ ኣዋይካ ኢዛ ኬሂ ሲቄስ› ጊ ኔስ ዮቲዶስ። ");
INSERT INTO gmve_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","«ኔካ ኔ ኣይሌታስ ኑስ፥ ‹ታኒ ኢዛ ቤያና ማላ ታስ ኤኪ ዪቴ› ጋዳሳ። ");
INSERT INTO gmve_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ኑኒ ኑ ጎዳስ ኔስ፥ ‹ኤ ናዚ ባ ኣዋፔ ሻኬታናስ ዳንዳዬና፤ ሻኬቲኮ ኢዛ ኣዋይ ሃይቃና› ጊዶስ። ");
INSERT INTO gmve_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ጊዶ ኣቲን ኔኒ ኔ ኣይሌታ፥ ‹ኢንቴ ካሎ ኢሻይ ኢንቴናራ ዱጌ ዮንታ ኢጺኮ ናምኣንꬆ ታ ኣይፌሶ ቤዬኬታ› ጋዳሳ። ");
INSERT INTO gmve_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ኑኒ ኔ ኣይሌቲ ኑ ኣዋኮ ሲሚ ቢዳ ዎዴ ኔ ኑ ጎዳይ ኑስ ጊዳይሳ ኢዛስ ዮቲዶስ። ");
INSERT INTO gmve_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","«ኑ ኣዋይ፥ ‹ሃኢካ ሲሚ ጉዬ ቢዲ ጉꬃ ካꬅ ጉጂ ሻሚቴ› ጊን፥ ");
INSERT INTO gmve_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ኑኒ ኢዛስ፥ ‹ኑስ ካሎ ኢሻይ ኑናራ ቢኮፌ ኣቲን ጉዬ ባናስ ዳንዳዮኮ፤ ኣይስ ጊኮ ኑ ካሎ ኢሻይ ኑናራ ቦንታ ጊዲኮ ኑኒ ሄ ኣዴዛ ኣይፌሶ ቤያናስ ዳንዳዮኮ› ጊዶስ። ");
INSERT INTO gmve_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","«ሂስቲን ኑ ኣዋይ ኔ ኣይሌታ ኑና፥ ‹ታ ማቻ ኤራሄላ ታስ ናምኡ ኣቱማ ናይታ ዬሊዳይሳ ኢንቴ ኤሬታ፤ ");
INSERT INTO gmve_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ኢስታፌ ኢሶይ ታፔ ሻኬቲ ቢን ቱሙ ኢዛ ዶኣይ ፑዜሬꬂ ሚዴስ፤ ሃች ጋካናስካ ታኒ ኢዛ ቤያቤኬ። ");
INSERT INTO gmve_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ሃይሳ ቃሴ ኢንቴ ታፔ ሻኪ ኤፊን ኢታ ሚሺ ኢዛ ጋኪኮ ኢንቴ ጪማቴꬃን ታ ቦላ ኤሂዛ ሚሻይ ታና ዎꬋና› » ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","«ሄሳ ጊሻስ ሃኢ ታ ኔ ኣይሌይ ጉዬ ታ ኣዋኮ ቢዛ ዎዴ ታ ኣዋይ ናዛ ባ ሼምፖ ማላ ሲቂዛይሲ፥ ናዚ ኑናራ ዶንታይሳ ቤይኮ ሃይቃና። ኑኒ ኔ ኣይሌቲ ኑ ኣዋ ጪማቴꬅ ካዮራ ዱፎን ዬጋና። ");
INSERT INTO gmve_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","ታኒ ኔ ኣይሌይ ናዛ ታ ዋሴቴꬃን ኤካ ያዲስ፤ ታኒ ኢዛ፥ ‹ኣቦ፥ ታኒ ኢዛ ኔስ ሳሮን ዛራዳ ኤሆንታ ኣጊኮ ታ ላይꬃ ኩሜꬃን ታ ኦይሼታና!› ጋ ዮታ ዎꬃዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","«ሄሳ ጊሻስ ታኒ ኔ ኣይሌይ ታ ጎዳስ ናዛ ጊሻስ ኣይሌታዳ ሃን ኣቲን ናዚ ባ ኢሻታራ ጉዬ ሲሞ። ");
INSERT INTO gmve_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ናዚ ባይንዳ ታኒ ዋናዳ ጉዬ ታ ኣዋኮ ሲማ ቦ? ሃኔና፤ ታ ኣዋይ ሚሼታና ሚሻ ታና ቤሶፋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ሄ ዎዴ ዮሴፌይ ሄ ኣሳ ኡባ ሲንꬃን ጌንጫና ዳንዳዮንታ ጊሻስ፥ «ኣሳ ኡባ ታ ሲንꬃፌ ኬሲቴ» ጊ ዋሲዴስ። ሄሳ ጊሻስ ዮሴፌይ ባና ባ ኢሻታስ ኤሪሲሺን ኢሻታፔ ኣቲን ሃራይ ኢዛራ ኦኒካ ዴና። ");
INSERT INTO gmve_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","ኢዚ ባ ቃላ ꬎቂሲዲ ጊብጼ ኣሳይ ኢዛ ሲያና ጋካናስ ዋሲ ዬኪዴስ። ካዎዛ ሶ ኣሳይካ ሄ ዎሬዛ ሲዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","ዮሴፌይ ባ ኢሻታስ፥ «ታኒ ዮሴፌኮ! ታ ኣዋይ ሃኖ ጋካናስ ፓጻ ዲዜ?» ጊ ኦይቺዴስ። ጊዶ ኣቲን ኢዛ ኢሻቲ ዳሮ ዳጋሚዳ ጊሻስ ኢዛስ ማልꬄ ዛራናስ ዳንዳይቤቴና። ");
INSERT INTO gmve_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ሂስቲን ዮሴፌይ ባ ኢሻታስ፥ «ታኮ ሃ ሺቂቴ» ጊዴስ። ኢስቲካ ኢዛኮ ሺቂን ኢዚ ኢስታስ፥ «ታኒ ኢንቴ ጊብጼ ቢታስ ባይዚዳ ኢንቴ ኢሻ ዮሴፌኮ፥ ");
INSERT INTO gmve_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ጾሲ ታና ኢንቴፌ ሲንꬄ ኪቲዳይ ኣሳ ሼምፖ ኣሻናስ ጊዲዳ ጊሻስ ኢንቴ ታና ሃ ባይዚዳይሳስ ዚልኤቶፍቴ። ");
INSERT INTO gmve_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ኮሻይ ሃ ቢታ ጌሊን ሃይሲ ናምኣንꬆ ላይꬃ፤ ቃሴ ሲንꬃፌ ዪዛ ኢቻሹ ላይꬃታ ጊዶን ኣሳይ ቢታ ጎዪዲ ካꬅ ሺሻናስ ዳንዳዬና። ");
INSERT INTO gmve_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ጊዶ ኣቲን ታኒ ኢንቴስ ዜሬꬅ ቢታ ቦላ ኣሻና ማላኔ ኢንቴ ሼምፖ ሃይሳ ማላ ጊታ ኣቶቴꬃን ኣሻና ማላ፥ ጾሲ ታና ኢንቴፌ ሲንꬄ ሃ ኪቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","ሄሳ ጊሻስ ታና ሃ ኪቲዳይ ጾሳ ኣቲን ኢንቴና ዴኬታ። ጾሲ ታና ጊብጼ ካዎስ ኣዋ፥ ኢዛ ኣቆ ኡባስ ጎዳኔ ጊብጼ ቢታ ሃሪዛዴ ኦꬂዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","«ሃኢ ኤሶን ጉዬ ታ ኣዋኮ ቢዲ ኢዛስ ኔ ና ዮሴፌይ፥ ‹ጾሲ ታና ጊብጼ ቢታ ኡባ ቦላ ጎዳ ኬሲዴስ፤ ሄሳ ጊሻስ ጋምኦንታ ታኮ ሃያ። ");
INSERT INTO gmve_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ኔኒ ታ ማታን ጌሴሜ ቢታን ኔ ናይታራ፥ ናይታ ናይታራ፥ ዶርሳታራ፥ ሜሄታራ፥ ኔስ ዲዛ ኡባራ ሃን ዳንዴታ። ");
INSERT INTO gmve_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ቡሮፔ ኢቻሹ ኮሻ ላይꬃቲ ዴቴስ፤ ኔና ኔሶ ኣሳኔ ኔ ሜሄ ኮሻይ ጋኮንታ ማላ ታኒ ኔና ሚዛና› ጌስ ጊቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","ቃሴካ ዮሴፌይ ኢስታስ፥ «ሃ ኢንቴናራ ሃሳይዛይሲ ቱሙ ታኒ ዮሴፌ ጊዲዳይሳ ኢንቴካ፥ ታ ኢሻ ቢኒያሜይካ ኢንቴ ኣይፌን ቤኤታ። ");
INSERT INTO gmve_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ታስ ጊብጼ ቢታን ዲዛ ቦንቾ ኢንቴ ቤኢዳይሳ ኡባ ታ ኣዋስ ዮቲቴ፤ ኤሶንካ ሃ ዱጌ ኤኪ ዪቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ሂስቲዲ ባ ኢሻ ቢኒያሜ ኢዲሚ ኦይኪዲ ዬኪዴስ፤ ቢኒያሜይካ ባ ኢሻ ኢዲሚ ኦይኪዲ ዬኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ዮሴፌይካ ዬኪሼ ባ ኢሻታ ኡባ ዬሪ ዬሪ ኤኪዴስ። ሄሳፌ ጉዬ ኢዛ ኢሻቲ ኢዛራ ሃሳያ ኦይኪዳ። ");
INSERT INTO gmve_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ዮሴፌ ኢሻታ ዩሳ ዎሬይ ካዎ ፓሮኔ ኬꬅ ጋኪዳ ዎዴ ካዎይኔ ኢዛ ኦሳንቻቲ ኡፋዬቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ካዎይ ዮሴፌ፥ «ኔኒ ኔ ኢሻታ፥ ‹ኢንቴ ሜሄ ጫኒዲ ካናኔ ቢታ ሲሚቴ፤ ");
INSERT INTO gmve_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ሂስቲዲ ኢንቴ ኣዋኔ ኢንቴ ሶ ኣሳ ኤኪዲ ጉዬ ታኮ ሃ ኤሂቴ። ታኒ ኢንቴስ ጊብጼ ቢታን ኡባሶፔ ሎኢዛሶ ኢማና፤ ኢስቲካ ሃ ቢታ ሞꬎ ካቻና› ጋ። ");
INSERT INTO gmve_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","ቃሴካ ኔኒ ኔ ኢሻታ፥ ‹ፓራ-ጋሬዛ ኢንቴ ናይታሲኔ ኢንቴ ማጫሳታስ ጊብጼፔ ኤኪ ቢዲ ኢንቴ ኣዋካ ኤኪ ዪቴ። ");
INSERT INTO gmve_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ጊብጼ ቢታን ዲዛ ኡባፌ ኣꬊ ሎኢዛ ሚሽ ኢንቴስ ጊዳና ጊሻስ ኢንቴስ ዲዛ ሃሮ ኤኪ ያና ቆፖፍቴ› ጋ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ሂስቲን ያቆቤ ናይቲ ጊዳ ማላ ኦꬂዳ። ዮሴፌይካ ካዎይ ኣዛዚዳ ማላ ፓራ-ጋሬታኔ ኦጌስ ጊዲዛ ሺንቄ ኢስታስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ኢስታስ ኡባሲካ ሁኤን ሁኤን ኦራꬃ ማይኦ ኢሚዴስ፤ ጊዶ ኣቲን ቢኒያሜስ ሄꬑ ጼቱ ሳቂሌ ቢራኔ ኢቻሹ ኩሜꬃ ማይኦ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ኢዚካ ባ ኣዋስ ጊብጼን ዲዛ ኡባፌ ሎኢዛይሳ ታሙ ሃሬን ጫኒዲ፥ ቃሴ ኦጌስ ካꬅ፥ ኡኬꬂኔ ሃራ ሺንቄ ታሙ ማጫ ሃሬታን ጫኒዲ ዬዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ዮሴፌይ ባ ኢሻታ ሞይዚዴስ። ኢስቲ ቢሺን ኢዚ ኢስታስ፥ «ቢሼ ኦጌን ኢንቴ ጋርሳን ኦዬቶፍቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ኢስቲ ጊብጼፔ ኬዚዲ ቢዳ፤ ካናኔ ቢታ ቢዲ ባ ኣዋ ያቆቤኮ ጋኪዳ። ");
INSERT INTO gmve_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ኢስቲ ኢዛስ፥ «ዮሴፌይ ፓጻ ዴስ! ቃሴካ ኢዚ ጊብጼ ቢታ ኡባ ሃሬስ» ጊን ያቆቤ ዎዚናይ ዳጋሚዳ ጊሻስ ኢስታ ኣማኒቤና። ");
INSERT INTO gmve_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ጊዶ ኣቲን ኢስቲ ዮሴፌይ ባስ ዮቲዳይሳ ኡባ ኢዛስ ዮቲኒኔ ኢዛ ኤኪ ኤሃና ማላ ዮሴፌይ ኪቲዳ ፓራ-ጋሬታ ኢዚ ቤዪን፥ ኢስታ ኣዋ ያቆቤስ ሼምፖይ ሲሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ያቆቤይካ፥ «ሄሲ ታስ ጊዳና፤ ታ ናዚ ዮሴፌይ ሃኖ ጋካናስ ፓጻ ዴስ! ታኒ ሃይቃናፔ ሲንꬃን ባዳ ኢዛ ቤያና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ኢስራኤሌይ ባስ ዲዛይሳ ኡባ ኤኪ ዴንዲዲ ቤርሳቤሄ ጋኪዴስ። ሄንካ ኢዚ ባ ኣዋ ዪሳቃ ጾሳስ ያርሾ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ጾሲ ኦማርስ ኣጉሞራ ኢዛ፥ «ያቆቤ፥ ያቆቤ» ጊ ጼይጊን ኢዚ፥ «ዬ!» ጊ ኮዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","«ታኒ ጾሳይ ኔ ኣዋ ጾሳ፤ ኔኒ ዱጌ ጊብጼ ባናስ ባቦፋ፤ ኣይስ ጊኮ ታኒ ኔና ሄን ጊታ ካዎቴꬅ ኬሳና። ");
INSERT INTO gmve_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ታኒ ኔናራ ኢሲፌ ጊብጼ ባና፤ ቃሴ ታኒ ኔ ዜሬꬃ ሄፔ ኬሳና። ዮሴፌይ ባ ኩሼራ ኔ ሃይቂሺን ኔና ሺሻና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ሄሳፌ ጉዬ ያቆቤይ ቤርሳቤሄፔ ዴንዲዴስ፤ ያቆቤ ኣቱማ ናይቲ ባ ኣዋ ያቆቤ፥ ባ ናይታኔ ባ ማቼታ ጊብጼ ካዎይ ኢስታስ ኪቲዳ ፓራ-ጋሬ ቶጊሲ ኤኪ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ኢስቲ ካናኔ ቢታን ሃሪዳ ኣቆኔ ሜሄ ኡባ ኤኪ ቢዳ። ያቆቤይኔ ኢዛ ዜሬꬂ ዉሪ ኢዛራ ጊብጼ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ኢዚካ ባ ዜሬꬅ ኡባ ባ ኣቱማ ናይታ፥ ባ ማጫ ናይታኔ ናይታ ናይታ ኡባ ባናራ ጊብጼ ኤኪ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ያቆቤራ ጊብጼ ቢታ ቢዳ ኢስራኤሌ ናይታ ሱንꬂ ሃይሳፌ ካሊ ጻፌቲዳይሳ። ያቆቤ ባይራ ናይ ኦሮቤሌ፤ ");
INSERT INTO gmve_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ኦሮቤሌ ኣቱማ ናይቲ ሄኖኬ፥ ፓሉ፥ ሄጺሮሜኔ ካርሜ። ");
INSERT INTO gmve_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ሲሞና ኣቱማ ናይቲ ዪሙኤሌ፥ ያሚኔ፥ ኦሃዴ፥ ያኪኔ፥ ጾሃሬኔ ካናኔ ማጫሳይ ና ሳኦሌ። ");
INSERT INTO gmve_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ሌዌ ኣቱማ ናይቲ ጌርሾኔ፥ ቃኣቴኔ ሜራሬ። ");
INSERT INTO gmve_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ዩሁዳ ኣቱማ ናይቲ ኤራ፥ ኦናኔ፥ ሴላ፥ ፓሬሴኔ ዛራሄ፤ ጊዶ ኣቲን ኤራይኔ ኦናኔይ ካናኔ ቢታን ሃይቂዳ። ፓሬሴ ኣቱማ ናይቲ ሄጺሮሜኔ ሃሙሌ። ");
INSERT INTO gmve_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ዪሳኮሬ ኣቱማ ናይቲ ቶላ፥ ፑዋ፥ ያሹቤኔ ሺሚሮኔ። ");
INSERT INTO gmve_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ዛቢሎኔ ኣቱማ ናይቲ ሴሬዴ፥ ኤሎኔኔ ያሂሌኤሌ። ");
INSERT INTO gmve_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ሃይቲ ሊያይ ሜስጴጾሚያን ያቆቤስ ዬሊዳ ኣቱማ ናይታ፤ ኢዚ ማጫ ናያ ዲኖ። ሃይቲ ኢዛ ናይቲኔ ናይታ ናይቲ ሙሌራ ሄꬑ ታማኔ ሄꬓ። ");
INSERT INTO gmve_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ጋዴ ኣቱማ ናይቲ ጻፎኔ፥ ሃጌ፥ ሹኔ፥ ኤጺቦኔ፥ ኤሬ፥ ኣሮዴኔ ኣርኤሌ። ");
INSERT INTO gmve_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ኣሴሬ ኣቱማ ናይቲ ዪሚኔ፥ ዪሺዋ፥ ዪሺዌኔ ባሪሄ፤ ኢስታ ሚቼያካ ሴራሆ። ባሪሄ ኣቱማ ናይቲ ሄቤሬኔ ማልኪኤሌ። ");
INSERT INTO gmve_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ላባይ ባ ና ሊያስ ኢሚዳ ዚልፋይ ያቆቤስ ዬሊዳ ናይቲ ናይታ ናይቲ ሃይታ፤ ኢስቲ ሙሌራ ታማኔ ኡሱፑና። ");
INSERT INTO gmve_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ያቆቤ ማቼዮ ኤራሄሊ ኣቱማ ናይቲ ዮሴፌኔ ቢኒያሜ። ");
INSERT INTO gmve_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ኦና ጌቴቲዛ ካታማ ቄሴ ጲጺፋራ ናያ ኣሲናታ ዮሴፌስ ጊብጼን ሚናሴኔ ኤፍሬሜ ዬላዱስ። ");
INSERT INTO gmve_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ቢኒያሜ ናይቲ ቤላ፥ ቤኬሬ፥ ኣሺቤሌ፥ ጌራ፥ ናኢማኔ፥ ኤሄ፥ ኦሮሼ፥ ሙፒሜ፥ ሁፒሜኔ ኣራዴ። ");
INSERT INTO gmve_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ያቆቤስ ዬሌቲዳ ኤራሄሊ ኣቱማ ናይቲኔ ናይታ ናይቲ ሃይታ፤ ኢስቲ ሙሌራ ታማኔ ኦይዳ። ");
INSERT INTO gmve_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ዳኔ ኣቱማ ናይ ሁሺሜ። ");
INSERT INTO gmve_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","ኒፍታሌሜ ኣቱማ ናይቲ ያሂጼሌ፥ ጉኔ፥ ዬጺሬኔ ሼሌሜ ");
INSERT INTO gmve_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ላባይ ባ ና ኤራሄሊስ ኢሚዳ ቢሊሃይ ያቆቤስ ዬሊዳ ናይቲኔ ናይታ ናይቲ ሃይታ፤ ኢስቲ ሙሌራ ላፑና። ");
INSERT INTO gmve_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ያቆቤራ ጊብጼ ቢዳ ናይቲኔ ናይታ ናይቲ፥ ኢዛ ናይታ ማቼታ ጉጆንታ ሙሌራ ኡሱፑን ታማኔ ኡሱፑና። ");
INSERT INTO gmve_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ጊብጼን ዮሴፌስ ዬሌቲዳ ናምኡ ናይታ ጉጂን ጊብጼ ቢዳ ያቆቤ ሶ ኣሳይ ሙሌራ ላፑን ታማ። ");
INSERT INTO gmve_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ሲንꬃቲ ቢዲ ጌሴሜ ቢታን ባና ሞካና ማላ ያቆቤይ ዩሁዳ ባፔ ሲንꬄ ዮሴፌኮ ዬዲዴስ፤ ኢስቲ ጌሴሜ ጋኪዳ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ዮሴፌይ ባ ፓራ-ጋሬዛ ጊግሲዲ ባ ኣዋ ያቆቤራ ጋጋናስ ጌሴሜ ቢዴስ። ዮሴፌይ ባ ኣዋ ዴሚዳ ማላ ኢዲሚ ኦይኪዲ ዳሮ ሳቴ ዬኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ኢስራኤሌይ ዮሴፌ፥ «ኔኒ ፓጻ ዲሺን ታኒ ኔ ኣይፌሶ ቤኢዳ ጊሻስ ሂኣ ታኒ ሃይቂኮ ሜቴና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ሄሳፌ ጉዬ ዮሴፌይ ባ ኢሻታሲኔ ባ ኣዋ ሶ ኣሳታስ፥ «ታኒ ጊብጼ ካዎዛኮ ባዳ ኢዛስ፥ ‹ካናኔ ቢታን ዲዛ ታ ኢሻቲኔ ታ ኣዋ ሶ ኣሳይ ታኮ ዪዳ። ");
INSERT INTO gmve_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ኢስቲ ሚዚኔ ዶርሳ ሃሪዛይታ፤ ኢስቲ ባናራ ባ ዶርሳታ፥ ባ ሚዛታኔ ባስ ዲዛይሳ ኡባ ኤኪ ዪዳ› ጋና። ");
INSERT INTO gmve_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ካዎይ ኢንቴና ጼይጊዲ፥ ‹ኢንቴ ኦሶይ ኣዜ?› ጊ ኦይቺኮ፥ ");
INSERT INTO gmve_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ኢንቴ ኢዛስ፥ ‹ኑኒ ኔ ኣይሌቲ ናቴꬃፌ ዶሚዲ ኑ ኣዋታ ማላካ ሜሄ ሄሞስ› ጊቴ። ሂስቲኮ ኢዚ ኢንቴና ጌሴሜ ቢታን ዎꬃና፤ ኣይስ ጊኮ ዶርሳ ሄንꬃንቻይ ዉሪ ጊብጼ ኣሳ ኣቻን ካꬌቲዳይታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ዮሴፌይ ጌሊዲ ጊብጼ ካዎስ፥ «ታ ኣዋይኔ ታ ኢሻቲ ባ ዶርሳታራ፥ ባ ሚዛታራ ባስ ዲዛዝ ኡባ ኤኪዲ ካናኔ ቢታፌ ዪዲ፥ ሃኢ ጌሴሜ ቢታን ዴቴስ» ጊ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ኢዚ ባ ኢሻታፔ ኢቻሻታ ዶሪዲ ካዎዛ ሲንꬅ ኣꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ካዎይ ሄ ኢሻታ፥ «ኢንቴ ኦሶይ ኣዜ?» ጊ ኦይቺን ኢስቲ ካዎዛስ፥ «ኑኒ ኔ ኣይሌቲ ኑ ኣዋታꬆ ዶርሳ ሄሞስ» ጊ ዮቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ቃሴ ኢስቲ ኢዛስ፥ «ካናኔ ቢታን ኮሻይ ዳሪዳ ጊሻስ ኑስ ኔ ኣይሌታ ሜሄታስ ሚዛ ሚሺ ኣይኮካ ባይንዳ ጊሻስ፥ ኑኒ ሃይሳን ኢማꬃቴꬃን ዳና ዪዶስ፤ ሾቤ ኑና ኔ ኣይሌታ ጌሴሜን ዎꬃርኪ!» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ካዎይ ዮሴፌ፥ «ኔ ኣዋይኔ ኔ ኢሻቲ ኔኮ ዪዳ። ");
INSERT INTO gmve_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ሂስቲን ጊብጼ ዴሬይ ኔ ኩሼን ዴስ ጊዴኔ፤ ሃ ቢታን ኡባፌ ኣꬊዲ ሎኢዛሶን ኔ ኣዋኔ ኔ ኢሻታ ዎꬃ፤ ኢስቲ ጌሴሜ ቢታን ዴቶ። ኢስታ ጊዶፌ ዱማ ኤራቴꬂ ዲዛይታ ኔ ኤሪዛ ጊዲኮ ሄይታ ታ ሜሄታ ቦላ ሹማ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ሄሳፌ ጉዬ ዮሴፌይ ባ ኣዋ ያቆቤ ጌልꬂዲ ካዎ ሲንꬅ ኣꬂዴስ። ያቆቤይ ጊብጼ ካዎ ኣንጂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ካዎይካ ያቆቤ፥ «ኔስ ኣፑን ላይꬄ?» ጊ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ያቆቤይ ካዎዛስ፥ «ታኒ ዩያ ዩያ ዴዪዳ ላይꬃይ 130፤ ታ ላይꬃይ ቤኒ ታ ኣዋቲ ዩዪ ዩዪ ዴዪዳ ላይꬃታፔ ጉꬃኔ ሜቶይ ዳሪዳ ላይꬃ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ሄሳፌ ጉዬ ያቆቤይ ካዎዛ ኣንጂዲ ኢዛ ሲንꬃፌ ካሬ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ዮሴፌይ ባ ኣዋኔ ባ ኢሻታ ጊብጼ ቢታን ዎꬂዴስ፤ ካዎይ ኣዛዚዳ ማላ ጊብጼ ቢታን ኤራሚሴ ኣቻን ዲዛ ኡባሶፔ ኣꬊዲ ሎኢዛ ጋዴ ኢስታስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","ዮሴፌይ ቃሴ ባ ኣዋስ፥ ባ ኢሻታሲኔ ባ ኣዋ ሶ ኣሳ ኡባስ ኢስታ ናይታ ቆዳ ማላ ካꬅ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ጊዲኮካ ኮሻይ ዳሪዳ ጊሻስ ቢታ ኡባ ቦላ ካꬂ ꬋይዴስ። ሄ ኮሻን ጊብጼ ዴሬይኔ ካናኔ ዴሬይ ናምኣይካ ቆሄቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ዮሴፌይ ጊብጼ ካꬅ ባይዚዲ ጊብጼኒኔ ካናኔ ቢታን ዲዛ ሚሽ ኡባ ሺሺዲ ጊብጼ ካዎ ኬꬅ ጌልꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ጊብጼ ሚሻይኔ ካናኔ ሚሻይ ኡባይ ዉሪን ጊብጼ ኣሳይ ዉሪ ዮሴፌኮ ዪዲ ኢዛ፥ «ኑስ ካꬅ ኢማ፤ ኑ ሚሻይ ዉሪዳ ጊሻስ ኑኒ ኔ ዲሺን ኣይስ ሃይቂዞኒ?» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ሂስቲን ዮሴፌይ ኢስታስ፥ «ኢንቴ ሜሄ ኤኪ ዪቴ፤ ኢንቴ ሚሻይ ዉሪዳ ጊዲኮ ታኒ ካꬅ ኢንቴስ ሜሄራ ላማና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ሄሳ ጊሻስ ኢስቲ ባ ሜሄ ዮሴፌስ ኤሂን ዮሴፌይ ኢስታ ፓራ፥ ዶርሳ፥ ዴይሼ፥ ሚዚኔ ሃሬ ካꬃራ ላሚዴስ፤ ኢዚ ሄ ላይꬅ ኢስታ ሜሄ ኡባራ ካꬅ ላሚ ላሚ ሚዚ ሻቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ሄ ላይꬃይ ዉሪን ናምኣንꬆ ላይꬃን ኢስቲ ኢዛኮ ዪዲ ኢዛስ፥ «ኑኒ ኑ ጎዳፔ ቆቲዛ ሚሺ ዴና፤ ኑ ሚሻይ ዉሪዴስ፤ ኑስ ዲዛ ሜሄካ ኡባ ኔስ ሼꬊዶስ፤ ኑ ጎዳስ ኔስ ኑናቴꬃፌኔ ኑ ጋዴፔ ኣቲን ኑ ኢማና ሚሺ ሃራይ ዴና። ");
INSERT INTO gmve_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ኔ ዲሺን ኑ ኣይስ ሃይቂዞኒ? ኑ ጋዴይካ ኣይስ ꬋይዜ? ኑናካ ኑ ጋዴዛካ ካꬃራ ላማ፤ ኑኒ ካዎስ ኣይሌታና፤ ኑ ጋዴይካ ኢዛስ ጊዶ፤ ኑኒ ሃይቆንታ ዴኦን ዳና ማላኔ ኑ ጋዴይካ ኦጾንታ ማላ ዜሬꬅ ኑስ ኢማ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ዮሴፌይ ጊብጼ ቢታ ኡባ ካዎስ ሻሚዴስ። ጊብጼቲ ዉሪ ኮሻይ ሚኒዳ ጊሻስ ባ ጋዴዛ ባይዚን ጋዴዚ ካዎስ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ዮሴፌይ ጊብጼ ኣሳ ኡባ ሃ ጋጻፔ ዶሚዲ ሄ ጋጻ ጋካናስ ካዎስ ኣይሌ ኬሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ጊዲኮካ ካዎይ ቄሴታስ ካꬅ ኢሚዛ ጊሻስ ቄሴታ ጋዴ ሻሚቤና። ሄሳ ጊሻስ ቄሴቲ ባ ጋዴ ባይዚቤቴና። ");
INSERT INTO gmve_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ዮሴፌይ ኣሳ፥ «ሂስቲን ሃች ታኒ ኢንቴናኔ ኢንቴ ጋዴ ካዎስ ሻሚዳ ጊሻስ ዜሬꬅ ኤኪዲ ኢንቴ ጋዴን ጋዴን ዜሪቴ። ");
INSERT INTO gmve_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ጊዶ ኣቲን ካꬅ ማጺ ጌልꬂዛ ዎዴ ካꬃፌ ኢቻሹ ኩሼፔ ኢሲ ኩሼ ካዎስ ኢሚቴ። ኢቻሽ ኩሼፔ ኣቲዳ ኦይዱ ኩሼዚ ኢንቴ ጋዴስ ዜሬꬅ፥ ኢንቴሶ ኣሳሲኔ ኢንቴ ናይታስ ቁማ ጊዶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ሂስቲን ኢስቲ፥ «ኔኒ ኑና ኣሻዳሳ! ኑ ጎዳ ሲንꬃን ኑኒ ናሼቲዳ ጊዲኮ ኑ ካዎስ ኣይሌ ጊዳና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ሄሳ ጊሻስ ዮሴፌይ ጊብጼ ቢታን ካጺዳ ካꬃስ ኢቻሽ ኩሼፔ ኢሲ ኩሼ ካዎስ ኢሚዛይሲ ዎጋ ጊዳና ማላ ኦꬂዴስ። ሄ ዎጋዚካ ሃች ጋካናስ ኤቂ ዴስ። ካዎስ ጊዶንታ ጋዴይ ቄሴታ ጋዴ ጻላ። ");
INSERT INTO gmve_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ኢስራኤሌቲ ጊብጼ ቢታን ጌሴሜ ጌቴቲዛሶን ኡቲዳ፤ ኢስቲ ሄን ኣቆታ ዴሚዳ፤ ኢስቲ ዬሌቲዳኔ ዳሮ ጮራቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ያቆቤይ ጊብጼ ቢታን 17 ላይꬅ ዴኢዴስ። ያቆቤይ ዴኢዳ ላይꬃይ ኢሲ ጼታኔ ኦይዱ ታማኔ ላፑና። ");
INSERT INTO gmve_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ያቆቤስ ሃይቆ ዎዴይ ማቲን ባ ና ዮሴፌ ጼይጊሲዲ፥ «ታኒ ኔ ሲንꬃን ሳቤቲዳ ጊዲኮ ኔ ኩሼ ታ ጉልባቴ ቦላ ዎꬃዳ ኔኒ ታስ ኪያታናሲኔ ኣማኔታናስ ኣኔ ጫቃ። ታና ጊብጼን ሞጎፓ። ");
INSERT INTO gmve_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ጊዶ ኣቲን ታኒ ታ ኣዋታን ጋጊዛ ዎዴ ታና ጊብጼፔ ኤፋዳ ኢስቲ ሞጌቲዳሶን ሞጋ» ጊዴስ። ሂስቲን ዮሴፌይ፥ «ታኒ ኔና ኔኒ ጊዳ ማላ ኦꬃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ያቆቤይ ኢዛ፥ «ኣኔ ታስ ጫቃ» ጊዴስ። ዮሴፌይካ ኢዛስ ጫቂዴስ፤ ሄሳፌ ጉዬ ያቆቤይ ባ ሂጻን ጉፋኒዲ ጾሳስ ጎይኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ሄሳፌ ጉዬ ኣሳይ ዮሴፌስ፥ «ኔ ኣዋይ ሳኬቴስ» ጊ ዮቲን ኢዚ ባ ናምኡ ኣቱማ ናይታ ሚናሴኔ ኤፍሬሜ ኤኪ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","ኣሳይ ያቆቤ፥ «ቤያ! ኔ ናይ ዮሴፌይ ኔኮ ዪዴስ» ጊን ኢስራኤሌይ ሚኔቲዲ ባ ሂጻ ቦላ ዴንዲ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ያቆቤይ ዮሴፌ፥ «ኡባ ዳንዳይዛ ጾሲ ካናኔ ቢታን ሎዛ ጌቴቲዛሶን ታስ ቆንጪዲ ሄን ታና ኣንጂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ኢዚ ታና፥ ‹ታ ኔስ ዬሎ ኢማና ኔ ዬሎታካ ዳርሳና፤ ታኒ ኔና ዳሮ ዴሬ ሂስታና። ሃ ቢታ ታኒ ኔፔ ጉዬ ኔ ዜሬꬃስ ሜርናስ ላታ ቢታ ሂስታ ኢማና› ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","«ሂስቲን ሃኢ ኔ ናምኡ ኣቱማ ናይቲ ታኒ ኔኮ ሃይሳ ያናፔ ካሴ ጊብጼን ኔስ ዬሌቲዳይቲ ታይታ፤ ኤፍሬሜይኔ ሚናሴይ ታስ ኦሮቤሌኔ ሲሞና ማላ። ");
INSERT INTO gmve_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ኢስታፌ ጉዬ ኔስ ዬሌቲዳይቲ ኔ ናይታ፤ ኢስቲ ላታና ዴሬይ ኤፍሬሜኔ ሚናሴ ሱንꬃን ሱሞ። ");
INSERT INTO gmve_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ታኒ ሜስጴጾሚያፔ ሲሚሺን ኤፍራታ ጌቴቲዛ ዴሬ ጋካና ጊሺን ኤራሄላ ካናኔ ቢታን ሃይቂን ታኒ ኢዞ ቤቴሊሄሜ ጌቴቲዛ ኤፍራታ ኤፊዛ ኦጌ ዶናን ሞጋዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ኢስራኤሌይ ዮሴፌ ኣቱማ ናይታ ናምኣታ ቤኢዲ፥ «ሃይቲ ኦኔ?» ጊ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ዮሴፌይካ ባ ኣዋስ፥ «ሃይቲ ጾሲ ታስ ሃን ሃይሳን ኢሚዳ ታ ናይታ» ጊዴስ። ሂስቲን ኢስራኤሌይ፥ «ታ ኢስታ ኣንጃና ማላ ታኮ ሃ ሺሻ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ያቆቤይ ጪሚን ኢዛ ኣይፌይ ዳቡርዳ ጊሻስ ዴማናስ ዳንዳይቤና። ሄሳ ጊሻስ ዮሴፌይ ባ ኣቱማ ናይታ ኢዛኮ ሺሺን ኢዛ ኣዋይ ኢስታ ኢዲሚዲ ዬሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ያቆቤይ ዮሴፌ፥ «ታኒ ኔ ኣይፌሶ ቤያና ጋዳ ቆፓቤኬ፤ ጊዶ ኣቲን ጾሲ ሄኮ ኔ ናይታካ ታና ቤሲዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ዮሴፌይ ኢስታ ያቆቤ ጉልባቴ ቦላፌ ዴንꬂዲ ባ ሁኤ ቢታ ጋꬂ ዚጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ዮሴፌይ ባ ናምኡ ኣቱማ ናይታ ኤኪዲ ኤፍሬሜ ባ ኡሻቻ ባጋን ያቆቤስ ሃዲርሳ ባጋራ፥ ሚናሴ ባ ሃዲርሳ ባጋን ያቆቤስ ኡሻቻ ባጋራ ኢዛኮ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ጊዶ ኣቲን ያቆቤይ ባ ኩሼ ያኔ ሃ ቃሴꬂ ኣꬂዲ ባ ኡሻቻ ኩሼ ካሎ ናዛ ኤፍሬሜ ሁኤ ቦላ፥ ባ ሃዲርሳ ኩሼ ባይራ ናዛ ሚናሴ ሁኤ ቦላ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ሄሳፌ ጉዬ ያቆቤይ ዮሴፌ፥ «ታ ኣዋቲ ኣብራሃሜይኔ ዪሳቂ ኢዛ ሲንꬃን ሱሬን ዴኢዳ ጾሲ፥ ታ ዴኦ ኡባን ሃች ጋካናስ ታና ሄሚዳ ጾሲ፥ ");
INSERT INTO gmve_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ኢታ ሚሻ ኡባፌ ታና ኣሺዳ ኪታንቻይ፥ ሃ ናይታ ኣንጆ። ታ ሱንꬃይኔ ታ ኣዋታ ኣብራሃሜኔ ዪሳቃ ሱንꬃይ ኢስታን ጼይጌቶ። ኢስቲ ቢታ ቦላን ጮራቴቶ» ጊ ኣንጂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","ዮሴፌይ ባ ኣዋይ ባ ኡሻቻ ኩሼ ኤፍሬሜ ሁኤ ቦላ ዎꬂዳይሳ ዶሲቤና። ሄሳ ጊሻስ ኤፍሬሜ ሁኤ ቦላፌ ዴንꬂዲ ሚናሴ ሁኤ ቦላ ዎꬃናስ ባ ኣዋ ኩሼ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ዮሴፌይ ባ ኣዋስ፥ «ኣቦ ሄሳꬆ ዴና! ባይራይ ሃይሳ ጊዶንታ ጊሻስ ኔ ኡሻቻ ኩሼ ሃይሳ ቦላ ዎꬃ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ጊዶ ኣቲን ኢዛ ኣዋይ ኢጺዲ ኢዛስ፥ «ታ ናዞ! ታ ኤራይስ፤ ኢዚካ ጊታ ዴሬ ጊዳና። ጊዲኮካ ካሎ ኢሻይ ኢዛፔ ኣꬊ ጊታታና፤ ኢዛ ዜሬꬃይካ ዳሮ ጊታ ካዎቴꬅ ጊዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ኢዚ ሄ ጋላስ ኢስታ ኣንጂዲ፥ «ኢስራኤሌ ናይቲ ኣንጆ ኣንጂዛ ዎዴ፥ ‹ጾሲ ኢንቴና ኤፍሬሜ ማላኔ ሚናሴ ማላ ኦꬆ› ጊዲ ኢንቴ ሱንꬃን ኣንጃና» ጊዴስ። ሂስቲዲ ኤፍሬሜ ሚናሴፔ ሲንꬄ ኣꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ሄሳፌ ጉዬ ያቆቤይ ዮሴፌ፥ «ታ ሃይቃና ጋይስ፤ ጊዶ ኣቲን ጾሲ ኢንቴናራ ጊዳና፤ ቃሴ ኢዚ ኢንቴ ኣዋታ ቢታ ኢንቴና ጉዬ ዛራና። ");
INSERT INTO gmve_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ቃሴ ኔና ኔ ኢሻታራ ጋኪዛ ቢታፌ ጊሻ ዳርሳዳ ኔስ ኢማይስ፤ ሄሲካ ታኒ ኣሞሬታፔ ታ ማሻኒኔ ቶራን ኦላ ኤኪዳ ቢታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ሄሳፌ ጉዬ ያቆቤይ ባ ኣቱማ ናይታ ጼይጊዲ፥ «ሲንꬃፌ ኢንቴስ ሃናናይሳ ታኒ ኢንቴስ ዮታና ማላ ሃ ሺቂቴ። ");
INSERT INTO gmve_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","«ኢንቴኖ ያቆቤ ናይቶ! ኢሲፌ ሃ ሺቂዲ ሲዪቴ፤ ኢንቴ ኣዋይ ኢስራኤሌይ ኢንቴስ ዮቲዛይሳ ኤዝጊቴ። ");
INSERT INTO gmve_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","«ኦሮቤሌ ታ ና ባይራዞ፥ ኔኒ ታ ዎልቃ፤ ታ ሚኖቴꬃስ ኮይሮ፤ ኔኒ ቦንቾንካ ዎልቃንካ ኡባፌ ኣꬋሳ። ");
INSERT INTO gmve_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","ኔኒ ቢጻላይ ባይንዳ ፓራ ማላ፤ ኔ ዶሲዳ ሃናሳ፤ ኔኒ ኔ ኣዋ ሂꬅ ኬዛዳሳ፤ ኔ ኣዋ ሂꬃካ ቱኒሳዳሳ። ሄሳ ጊሻስ ሃላቃቴꬂ ኔስ ቤሴና። ");
INSERT INTO gmve_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","«ሲሞኒኔ ሌዌይ ኢሻንታ፤ ኢስቲ ኢታ ኦꬃናስ ማሻኔ ቶራ ኤኬቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ታኒ ኢስታ ዞሬቴꬃን ጌሊኬ፤ ታኒ ኢስታ ሺቆሶንካ ኡቲኬ። ኣይስ ጊኮ ኢስቲ ባ ሃንቆን ኣስ ዎꬊዳኔ ባና ኤካ ኤካ ጊን ቦራታ ጊልዳዪ ቃንጺዳ። ");
INSERT INTO gmve_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ኢስታ ኢታ ሃንቆይኔ ኢስታ ሜቄꬃ ኢታቴꬂ ቃንጌቲዳዝ ጊዶ! ታኒ ኢስታ ያቆቤ ኣሳ ጊዶን ላላና፤ ኢስራኤሌ ቢታን ꬋርጫና። ");
INSERT INTO gmve_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","«ዩሁዳ ኔ ኢሻቲ ኔና ጋላታና፤ ኔኒ ኔ ሞርኬታ ሞርጌ ናቃ ኦይካና፤ ኔ ኣዋ ናይቲ ኔስ ሆኪዲ ዚጋና። ");
INSERT INTO gmve_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ዩሁዳ ኔኒ ዎዳላ ጋሞ ማላ፤ ታ ናዞ! ኔኒ ሻንካቲ ኦይኪዲ፥ ጮጎቲ ኢቺዳ ጋሞ ማላ። ኔኒ ኣሲ ባና ቦሼꬃናስ ኮዮንታ ማጫ ጋሞ ማላ። ");
INSERT INTO gmve_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ዴሬ ሃሪዛዴይ ያና ጋካናሼ፥ ካዎቴꬃ ኣልጋይ ዩሁዳፔ፥ ሃላቃቴꬃ ጉፌይ ኢዛ ኬꬃፌ ሻኬቴና። ቃሴ ዴሬ ኣሳይ ኢዛስ ኣዛዜታና። ");
INSERT INTO gmve_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ኢዚ ባ ሃሬ ካꬃ ጊዶን ባ ሃሬ ጉቴካ ዶሬቲዳ ካꬃን ቃቻና። ኢዚ ባ ሃꬅ ዎይኔ ኡሻን፥ ባ ማይኦ ቃሴ ዎይኔ ማꬋን ሜጫና። ");
INSERT INTO gmve_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ኢዛ ኣይፌይ ዎይኔ ኡሻፌ ኣꬊ ዞኣና፤ ኢዛ ኣቻይካ ማꬃፌ ኣꬊ ቦታና። ");
INSERT INTO gmve_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","«ዛቢሎኔይ ኣባ ዶናን ዳና፤ ኢዛ ቢታይ ዳሮ ማርካቤታስ ሼምፖሶ ጊዳና፤ ኢዛ ዛዋይ ሲዶና ጋካና። ");
INSERT INTO gmve_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","«ዪሳኮሬይ ናምኡ ጎዳይ ጎኤቲዛ ሚኖ ሃሬ ማላ። ");
INSERT INTO gmve_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ኢዚ ባ ሼምፒዛሶይ ሎኦ ጊዲዳይሳኔ ባ ዴሬይ ኡፋይሲዛዝ ጊዲዳይሳ ቤኢዲ፥ ቶሆ ቶካናስ ባ ዞኮ ዚቂ ሂስቲዲ፥ ኣይሌቴꬃ ኦሶ ኦꬃና። ");
INSERT INTO gmve_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","«ዳኔይ ኢስራኤሌ ቆሞታፔ ኢሳስ ፒርዲዛ ዳና ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ዳኔይ ፓራ ቶጊዳዴይ ጉዬ ኩንዳና ማላ ፓራ ቂርጴ ዱኪዛ ኦጌ ዶናን ዲዛ ሃሶ ሾሻ። ");
INSERT INTO gmve_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","«ኣቤት ጎዶ! ታ ኔ ማዶ ናጋይስ። ");
INSERT INTO gmve_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","«ጋዴይ ቦንቂዛይታን ዴሼታና፤ ጊዶ ኣቲን ኢዚካ ኢስታ ጌዶ ካሊዲ ኢስታ ቦንቃና። ");
INSERT INTO gmve_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","«ኣሴሬ ማዳይ ኣካና፤ ካዎታስ ኢዚ ሎኦ ቁማ ኢማና። ");
INSERT INTO gmve_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","«ኒፍታሌሜይ ቃሼቶንታ ዬዳ ዲዛ፥ ሎኦ ላቃታ ዬሊዛ ጌኔሳ። ");
INSERT INTO gmve_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","«ዮሴፌይ ሜሎንታ ፑልቶ ሃꬃ ኣቻን ቶኬታዳ፥ ኢዚ ኣይፌይ ላሻ ቦላራ ኣላሌታና ጋካናስ ኣይፌ ኢሚዛ ሚꬃይ ማላ። ");
INSERT INTO gmve_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ዎንዳፌዛ ዱኪዛይቲ ኢዛ ቦላ ዎራጂዳ፤ ባ ዎንዳፌንካ ጎዲ ጎዲ ጫዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ጊዶ ኣቲን ያቆቤ ጎዳ ጾሳ ዎልቃን ኢዛ ሄሚዛ ኢስራኤሌ ዛላን ኢዛ ዎንዳፌይ ሚኒዴስ፤ ኢዛ ሚኖ ቄሴይካ ፒላቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ኔና ማዲዛ ኔ ኣዋ ጾሳን ኡባ ዳንዳይዛይሳኒኔ ኔና ኣንጂዛ ጾሳን ፑዴ ቦላፌ ቤቲዛ ማዶኒኔ ጋርሳ ቢታፌ ቤቲዛ ኣንጆን ቃሴካ ኣዪ ኡሎፔኔ ꬋንꬃፌ ቤቲዛ ኣንጆን ኔና ኣንጃና። ");
INSERT INTO gmve_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","ኔ ኣዋ ኣንጆይ ቤኒ ዎዴፔ ሃኖ ጋካናስ ሚኒ ዲዛ ዙማታፔኔ ሜርና ዙማታ ኡባፌ ኣꬌስ። ሄሳ ጊሻስ ሃይሲ ሃ ኣንጆይ ዉሪካ ዮሴፌ ጋኮ። ባ ኢሻታ ቦላ ሃላቃ ጊዲዳ ዮሴፌ ቦላ ዎꬎ። ");
INSERT INTO gmve_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","«ቢኒያሜይ ቦንቂዛ ካና ሱይቴ ማላ። ባ ሻንካቲዳይሳ ማላዶ ሜስ፤ ባ ዲኢዳይሳ ኦማርስ ጊሼሬꬄስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ሃይቲ ታማኔ ናምኡ ኢስራኤሌ ቆሞታ፤ ቃሴ ኢስታ ኣዋይ ኢስታ ኢሳ ኢሳ ኢስታ ሃኖ ማላ ኢስታስ ቤሲዛ ኣንጆ ሄሳꬆ ኣንጂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ሄሳፌ ጉዬ ኢዚ ኢስታስ፥ «ታኒ ታ ኣዋታን ጋጋና ጋይስ፤ ታና ሂቴ ኣስ ኤፍሮኔ ጋዴን ዲዛ ጎንጎሎን፥ ታ ኣዋታራ ሞጊቴ። ");
INSERT INTO gmve_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ሄሲካ ካናኔ ቢታን፥ ማሚሬ ኣቻን ዲዛ ማኪጴሌ ጌቴቲዛ ጎንጎሎ፤ ሃይሲካ ኣብራሃሜይ ሞጎስ ሂቴ ኣስ ኤፍሮኔፔ ጋዳራ ጋꬂ ሻሚዳ ጎንጎሎ። ");
INSERT INTO gmve_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ኣብራሃሜይኔ ኢዛ ማቼያ ሳራይ ሄን ሞጌቲዳ፤ ዪሳቂኔ ኢዛ ማቼያ ኢርቢቃይካ ሄን ሞጌቲዳ፤ ታኒ ቃሴ ሊያ ሄን ሞጋዲስ። ");
INSERT INTO gmve_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ሄ ጋዴዚኔ ኢዛን ዲዛ ጎንጎሎይ ሂቴታፔ ሻሜቲዳይሳ» ጊ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ያቆቤይ ባ ናይታስ ኣዛዞ ዉርሲዳፔ ጉዬ ባ ቶሆ ፑዴ ባ ሂጻን ሺሺ ኤኪዲ ሃይቂዲ ባ ኣዋታን ጋጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ዮሴፌይ ባ ኣዋ ኣሃ ቦላ ኩንዲዲ ዬኪዴሲኔ ኢዛ ዬሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ሄሳፌ ጉዬ ዮሴፌይ ꬋሌ ሺሺዛ ባ ኦሳንቻታ ባ ኣዋ ኢስራኤሌ ኣሃ ሳዊዛ ሺቶ ቲይዲ ሜሊሳና ማላ ኣዛዚን ኢስቲ ቲይዲ ሜሊሲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ሺቶ ቲዮይ ጻላ 40 ጋላስ ኩሜꬅ ዉርሲዴስ፤ ኣይስ ጊኮ ሃይሲ ቲዮይ ዎናካ ኦይዱ ታሙ ጋላስ ኤኬስ። ጊብጼ ኣሳቲ ኢዛስ ላፑን ታሙ ጋላስ ዬኪዳ። ");
INSERT INTO gmve_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ዬሆ ጋላሳቲ ኣꬊን ዮሴፌይ ጊብጼ ካዎ ኬꬃ ኣሳታ፥ «ታኒ ኢንቴ ሲንꬃን ሳቤቲዳ ጊዲኮ ካዎስ ሂዝጊ ዮቲቴ፤ ");
INSERT INTO gmve_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","ታ ኣዋይ ታና ኢሲ ጫቆ ጫቂሲዴስ፤ ኢዚ ታና፥ ‹ታኒ ሃይቃና ሃናይስ፤ ታኒ ታስ ካናኔ ቢታን ዎጪዳ ጎንጎሎ ዱፎን ታና ሞጋ› ጊዴስ። ሄሳ ጊሻስ፥ ‹ሃኢ ታኒ ፑዴ ባዳ ታ ኣዋ ሞጋና ማላ ዬዳርኪ! ሄሳፌ ጉዬ ታኒ ሲማና› » ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ሂስቲን ካዎይ፥ «ኢዚ ኔና ጫቂሲዳ ማላ ፑዴ ባዳ ኔ ኣዋ ሞጋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ዮሴፌይ ባ ኣዋ ሞጋናስ ፑዴ ቢዴስ። ካዎዛ ኦሳንቻቲ ዉሪ፥ ኢዛ ካዎቴꬃ ኬꬃን ዲዛ ጊታ ኣሳይ ዉሪ ጊብጼ ቢታን ዲዛ ጊታ ኣሳይ ዉሪ ዮሴፌ ካሊዲ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ቃሴ ዮሴፌ ሶ ኣሳይ ዉሪ ኢዛ ኢሻቲኔ ኢዛ ኣዋ ሶ ኣሳይ ኢዛራ ቢን፤ ኢስታ ናይቲኔ ሜሄይ ጻላ ጌሴሜን ኣቲዳ። ");
INSERT INTO gmve_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ፓራ-ጋሬቲካ ቶጋ ኣሳይካ ኢዛራ ፑዴ ቢዴስ፤ ኢዛ ካሊዲ ቢዳ ኣሳይ ኬሂ ዳሮ። ");
INSERT INTO gmve_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ኢስቲ ዮርዳኖሴ ሻፋ ኣቻን ዲዛ ኣጻዴ ጌቴቲዛ ባሌ ጋኪዲ ባ ቃላ ꬎቁ ሂስቲዲ ኢዛስ ዚላሊዳኔ ዬኪዳ፤ ሄን ዮሴፌይ ባ ኣዋ ዬሆን ላፑን ጋላስ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ሄ ቢታን ዲዛ ካናኔ ኣሳቲ ኣጻዴ ጌቴቲዛ ዬሆ ባሌን ሄ ዬሆዛ ቤኢዲ፥ «ጊብጼ ኣሳይ ኣይ ሚሻ ዬሆ ዬኪዞ!» ጊዳ። ሄሳ ጊሻስ ዮርዳኖሴ ኣቻን ዲዛ ሄ ሶይ፥ ጊብጼታ ዬሆ ጌቴቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ያቆቤ ናይቲ ባ ኣዋይ ኢስታ ኣዛዚዳ ማላ ኦꬂዳ፤ ");
INSERT INTO gmve_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ኢዛ ኣሃ ካናኔ ቢታ ኤፊዲ ማሚሬ ኣቻን ዲዛ ማኪጴሌ ጌቴቲዛ ጎንጎሎን፥ ኣብራሃሜይ ሂቴ ኣስ ኤፍሮኔፔ ሞጎስ ሻሚዳ ጋዴን ኢዛ ሞጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ዮሴፌይ ባ ኣዋ ሞጊዳፔ ጉዬ፥ ባ ኢሻታኔ ኢዛ ኣዋ ሞጋናስ ኢዛራ ቢዳ ሃራ ኣሳታ ኡባራ ጊብጼ ሲሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ኢስታ ኣዋይ ሃይቂዳይሳ ቤኢዲ፥ ዮሴፌ ኢሻቲ ባ ጋርሳን፥ «ኦኒ ኤሪዜ ዮሴፌይ ኑና ባ ኡሎን ሞርኪዲ ኑኒ ኢዛስ ኦꬂዳ ኢታ ሚሽ ኡባስ ሃሎ ኬሳና ኮይኮ፥ ኑኒ ዋናኔ?» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ሄሳ ጊሻስ ዮሴፌኮ ኪታ፥ «ኔ ኣዋይ ሃይቃናፔ ካሴ፤ ");
INSERT INTO gmve_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ኢንቴ ዮሴፌ፥ ‹ኔኒ ኔ ኢሻታ ናጋራኔ ኢስቲ ኔና ቆሂዳ ኢታ ቆሆዛ ሃያና ኣቶ ጋ› ጊዲ ዮቲቴ ጊዴስ። ሄሳ ጊሻስ ሃኢ ሃያና፥ ኑ ናጋራ፥ ኔ ኣዋ ጾሳ ኣይሌታ ናጋራ ኣቶ ጋ» ጊዳ። ሄ ኪታይ ኢዛኮ ጋኪን፥ ዮሴፌይ ዬኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ሄሳፌ ጉዬ ኢዛ ኢሻቲ ባርካ ኢዛኮ ቢዲ ኢዛ ሲንꬃን ጉፋኒዲ፥ «ኑኒ ኔ ኣይሌታ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","ጊዶ ኣቲን ዮሴፌይ ኢስታስ፥ «ባቦፍቴ፤ ታና ኢንቴስ ጾሳ ጊዴቲዬ? ");
INSERT INTO gmve_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","ኢንቴ ታስ ኢታናስ ኦꬂዴታ ሺን ሃይሲ ዳሮ ኣሳይ ሃይቆንታ ኣታና ማላ ጾሲ ሎኦስ ሃይሳ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ሄሳ ጊሻስ ሄኮ ኢንቴ ባቦፍቴ፤ ታኒ ኢንቴናኔ ኢንቴ ናይታ ሚዛና» ጊዲ፥ ኢዚ ኢስታ ሚንꬄꬂዲ ሎኦ ቃላን ሃሳዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","ዮሴፌይ ባ ኣዋ ሶ ኣሳ ኡባራ ጊብጼን ጋምኢዴስ፤ ኢዚ 110 ላይꬅ ዴኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ኤፍሬሜ ናይታ፥ ሄꬓንꬆ ዬሌታ ጋካናስ ቤኢዴስ፤ ቃሴ ሚናሴ ና ማኪሬ ናይታካ ኢዚ ባ ና ማላ ሂስቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ሄሳፌ ጉዬ ዮሴፌይ ባ ኢሻታ፥ «ታኒ ሃይቃና ጋይስ፤ ጊዶ ኣቲን ጾሲ ኢንቴና ማዳናስ ቱሙ ዎቻና፤ ኢዚ ኢንቴና ሃ ቢታፌ ኬሲዲ ኣብራሃሜስ፥ ዪሳቃሲኔ ያቆቤስ ኢማና ጊዲ ጫቂዳ ቢታ ዛሪ ኤፋና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ዮሴፌይ ኢስራኤሌ ናይታ፥ «ጾሲ ኢንቴና ማዳናስ ቱሙ ጾሞሲዛ ዎዴ፥ ኢንቴ ታ ሜቄꬃ ሃ ቢታፌ ፑዴ ኤኪ ቢቴ» ጊዲ ጫቄቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ዮሴፌይ 110 ላይꬅ ዴኢዲ ሃይቂን፥ ኢስቲ ሺቶን ኢዛ ኣሃ ቲይዲ ሜሊሲዳፔ ጉዬ ጊብጼ ቢታን ዎንጊሬ ጊዶን ዎꬂዳ።");
INSERT INTO gmve_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ባሶ ኣሳ ኡባ ኤኪ ያቆቤራ ጊብጼ ቢዳ ያቆቤ ናይታ ሱንꬂ ሃይሳፌ ካሊ ጻፌቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ኢስቲካ ኦሮቤሌ፥ ሲሞና፥ ሌዌ፥ ዩሁዳ፥ ");
INSERT INTO gmve_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ዪሳኮሬ፥ ዛቢሎኔ፥ ቢኒያሜ፥ ");
INSERT INTO gmve_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ዳኔ፥ ኒፍታሌሜ፥ ጋዴኔ ኣሴሬ። ");
INSERT INTO gmve_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ያቆቤ ዜሬꬃቲ ሙሌራ ላፑን ታማ፤ ዮሴፌይ ካሴቲዲ ጊብጼ ቢዲ ሄን ዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ዮሴፌይ፥ ኢዛ ኢሻቲኔ ሄ ዬሌታይ ዉሪካ ሃይቂዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ጊዶ ኣቲን ኢስራኤሌ ዜሬꬃቲ ዬሌቲዲ ኬሂ ዳሪዳ፤ ሄ ቢታ ኩማና ጋካናስ ኢስቲ ኬሂ ጮራቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ሄሳፌ ጉዬ ዮሴፌ ኤሮንታ ኦራꬃ ካዎይ ጊብጼ ቢታን ዴንዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ኢዚ ባ ኣሳ፥ «ቤኢቴ፤ ሃይቲ ኢስራኤሌ ኣሳይ ኑፔ ኬሂ ዳሪዳኔ ዎልቃሚዳ። ");
INSERT INTO gmve_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ሃ ዪቴ፥ ኣኔ ኑኒ ኢስታ ሂላን ኦይኮስ፤ ሂስቶንታ ኣጊኮ ኢስቲ ካሴፔ ጌዴ ዳሪ ዳሪ ባና። ጌሊ ጊዳ ኦላይ ዴንዲኮ ኢስቲ ኑ ሞርኬታራ ጋጊዲ ኑና ኦላናኔ ቢታ ዬጊዲ ባና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","ሄሳ ጊሻስ ዴጾ ኦሶን ኢስታ ቱጋሳና ማላ ኢስታ ቦላ ሃላቃታ ዶሪዳ። ኢስቲካ ካዎስ ፒቶሜኔ ኤራሚሴ ጌቴቲዛ ዱማ ዱማ ሚንጃ ሚሻታ ዎꬂዛ ካታማታ ኬጺዳ። ");
INSERT INTO gmve_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ጊዶ ኣቲን ጊብጼ ኣሳይ ኢስታ ኬሂ ዋዪሲዳ ዎዴ ኢስቲ ጉጄቲ ጉጄቲ ዬሌቲዳኔ ቢታ ጋኪዳ። ሄሳ ጊሻስ ጊብጼ ኣሳይ ኢስራኤሌ ናይታ ኢጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ሄሳ ጊሻስ ኢስታ ዳሮ ዳቡርሲዛ ኦሶን ዋዪሲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ዎልቃማ ኦሶን፥ ሲሚንቶኒኔ ጹቤ ሜꬎን፥ ቃሴ ጎሼ ጎይሶን፥ ኢስታ ዱሳን ኡንኤꬂዳ፤ ዳቡርሲዛ ኦሶ ኡባ ቃꬌታይ ባይንዳ ኢስታ ኦሲሲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ጊብጼ ካዎይ ኢብራዌ ማጫሳታ ዬሊሲዛ ሲፖሮኔ ፑሆ ጌቴቲዛ ናምኡ ማጫሳታስ፥ ");
INSERT INTO gmve_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","«ኢብራዌ ማጫሳቲ ዬሊዛ ዎዴ ኢንቴ ዬሊሲሺን ዬሌቲዳይሲ ኣቱማ ና ጊዲኮ ዎꬊቴ፤ ጊዶ ኣቲን ማጫ ና ጊዲኮ ዎꬎፒቴ» ");
INSERT INTO gmve_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ጊዶ ኣቲን ዬሊሲዛይቲ ጾሳስ ባቢዲ ጊብጼ ካዎይ ኢስታ ኣዛዚዳ ማላ ኦꬂቤቴና፤ ዎꬎንታ ኣቱማ ናይታ ፓጻ ኣጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ሄሳፌ ጉዬ ጊብጼ ካዎይ ሄ ዬሊሲዛይታ ጼይጊዲ፥ «ኢንቴ ኣይስ ሃይሳꬆ ኦꬂዴቲ? ኣቱማ ናይታ ኣይስ ፓጻ ኣጊዴቲ?» ጊ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ዬሊሲዛይቲ ዛሪዲ፥ «ኢብራዌ ማጫሳቲ ጊብጼ ማጫሳታ ማላ ጊዴቴና፤ ኢስቲ ሚኖ ጊዲዳ ጊሻስ ዬሊሲዛይቲ ጋካናፔ ሲንꬃቲዲ ዬሊቼቴስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","ሄሳ ጊሻስ ጾሲ ዬሊሲዛይታስ ኪዪዴስ። ኣሳ ቆዳይካ ጉጄቲ ጉጄቲ ቢዲ ካሴይሳፌ ጌዴ ዳሪዴሲኔ ሚኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ቃሴ ዬሊሲዛይቲ ጾሳስ ባቢዳ ጊሻስ ጾሲ ኢስታስ ዬሎ ኢሚ ኣንጂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ሄሳፌ ጉዬ ካዎይ ባ ኣሳ ኡባ፥ «ኢብራዌታፔ ዬሌቲዛ ኣዴ ና ኡባ ናይሌ ጌቴቲዛ ሻፋ ሃꬃን ኦሊቴ፤ ጊዶ ኣቲን ማጫ ናይ ዬሌቲኮ ፓጻ ኣጊቴ» ጊዲ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ሄ ዎዴ ኢሲ ሌዌ ቆሞ ጊዲዳ ኣዴይ ሌዌ ማጫ ናዮ ማቾ ኤኪዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ኢዛ ቃንꬃታዳ ኣዴ ና ዬላዱስ። ናዚካ ማላ ሎኦ ና ጊዲዳይሳ ቤያዳ ሄꬑ ኣጊና ቆታዱስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ጊዶ ኣቲን ኢዛ ሄሳፌ ዳሮ ቆታናስ ዳንዳዮንታይሳ ኤራዳ፥ ሻጫፌ ኬሼ ኢዛስ ዳዳዳ ሺዳን ሜሻዳ፥ ናዛ ኢዛ ጊዶን ዎꬃዳ ናይሌ ሻፋ ዶናን ዱሬሳ ጌቴቲዛ ማታ ጊዶን ዎꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ኢዛ ሚቼያ ኢዛ ቦላ ኣዚ ሃናናኮ ቤያናስ ሃሆን ኤቃዳ ጼላዉስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ጊብጼ ካዎ ናያ ቦላ ሜጬታናስ ናይሌ ሻፋ ዎꬋዱስ፤ ኢዚ ማጫ ኣይሌቲካ ሃꬃ ዶናን ያኔ ሃ ሄሜቴቴስ፤ ኢዛ ኬሼዛ ዱሬሳ ጌቴቲዛ ማታ ጊዶን ቤያዳ፥ ባዳ ኤካዳ ያና ማላ ባ ኣይሌዮ ኪታዱስ፤ ");
INSERT INTO gmve_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ኬሼዛ ዶያዳ ሄ ጉꬃ ናዛ ቤያዱስ። ኢዚ ዬኪዛ ጊሻስ ኢዛስ ቃꬌታዳ፥ «ሃይሲ ኢብራዌታ ጉꬃ ናይታፔ ኢሳ ጊዶንታ ኣጌና» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ሄ ዎዴ ኢዛ ሚቼያ ካዋ ናዮ፥ «ኔስ ሃ ናዛ ꬋንꬃናስ ኢብራዌታፔ ኢሲ ማጫስ ኤሃናስ ቦ?» ጋዳ ኦይቻዱስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ሂስቲን ኢዛ፥ «ኤ፥ ባ» ጋዱስ። ናያ ባዳ ሄ ናዛ ኣዮ ኤሃዱስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ካዎዛ ናያ ሄ ማጫሳዮ፥ «ሃይሳ ናዛ ኤፋዳ ታስ ꬋንꬃሻ፤ ታኒ ኔስ ዳሞዛ ቃንጻና» ጋዱስ። ማጫሳያ ናዛ ኤፋዳ ꬋንꬃ ዲቻዱስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ናዚ ዲጪን ካዎ ናይኮ ኢዛ ኤሂን ኢዚ ኢዚስ ና ጊዲዴስ፤ «ታኒ ኢዛ ሃꬃፌ ኬሳዲስ» ጋዳ ኢዛ ሙሴ ጋ ሱንꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","ሙሴይ ዲጪዲ ጊታ ጊዲዲ ኢሲ ጋላስ ባ ኣሳይ ዲዛሶ ቢዲ ኢስቲ ዴጾ ኦሶ ኦꬂሺን ቤኢዴስ። ኢሲ ጊብጼ ቢታ ኣሲ ኢዛ ኣሳታ ኢብራዌታፔ ኢሳ ዋꬊሺን ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ኢዚ ያኔ ሃ ጼሊን ኦኒካ ባይንዳይሳ ቤኢዲ ሄ ጊብጼ ኣዴዛ ዎꬊዲ ኣጬ ጊዶን ካሺ ቆቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ዎንቴꬃ ጋላስ ኬዚዲ ናምኡ ኢብራዌቲ ባ ጋርሳን ዋꬌቲዛይታ ቤኢዴስ። ቆሂዛይሳ ኢዚ፥ «ኔኒ ኔ ኣስ ጊዲዳ ኢብራዌዛ ኣይስ ዋꬋይ?» ጊ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ሄ ኣዴዚካ፥ «ኔና ኑ ቦላ ጎዳኔ ዳና ሂስቲዳይ ኦኔ? ኔኒ ጊብጼ ኣዴዛ ዎꬊዳይሳ ማላ ታናካ ዎꬋና ቆፓይ?» ጊን ሙሴይ፥ «ታኒ ኦꬂዳይሲ ኤሬቲቺዴስ» ጊ ባቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ካዎዚ ሄሳ ሲዪዲ ሙሴ ዎꬋናስ ኮዪዴስ፤ ጊዶ ኣቲን ሙሴይ ካዋፔ ቤቲዲ ሚዲያሜ ቢታን ዳናስ ቢዲ ኢሲ ሃꬃ ኦላ ዶናን ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ሄ ዎዴ ኢሲ ሚዲያሜ ቄሴስ ላፑን ማጫ ናይቲ ዴቴስ፤ ኢስቲ ሄ ሃꬃ ኦላኮ ባ ኣዋ ዶርሳታ ሃꬅ ኡሻናስ ዪዲ ጎንጌን ሃꬅ ዱቂ ኩንꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ሄሚዛይቲ ዪዲ ማጫ ናይታ ጎዲዳ፤ ጊዶ ኣቲን ሙሴይ ዴንዲ ኤቂዲ ኢስታ ኣሺዴሲኔ ኢስታ ዶርሳታ ሃꬅ ኡሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ኢስቲ ባ ኣዋ ዮቶሬኮ ቢን ኢዚ፥ «ሃች ዋኒ ኤሶን ዪዴቲ?» ጊ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ኢስቲ ዛሪዲ፥ «ኢሲ ጊብጼ ቢታ ኣዴ ዳይሲ ኑና ሜሄ ሄሚዛይታፔ ኣሺዴስ፤ ቃሴካ ኑስ ሃꬄካ ዱቂዲ ኑ ዶርሳታካ ኡሺዴስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","ሂስቲን ኢዚ ባ ማጫ ናይታ፥ «ሃኢ ኢዚ ኣዋን ዲዜ? ኢንቴ ሄ ኣዴዛ ኣይስ ሄን ኣጊዴቲ? ኣኔ ኢዛ ጼይጊቴ፤ ዪዲ ካꬅ ሞ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","ሙሴይካ ሄ ኣዴዛራ ሄን ዳናስ ዶሲዴስ፤ ኣዴዚካ ባ ናዮ ጺፖሮ ሙሴስ ማቾ ሂስቲ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ጺፖራ ኣዴ ና ዬሊን ሙሴይ ናዛ፥ «ታኒ ኣሳ ቢታን ቤቴ ኣሳ» ጊሼ ጌርሾሜ ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ሙሴይ ሚዲያሜ ቢታን ዲዛ ዳሮ ላይꬃታ ጋርሳን ጊብጼ ካዎይ ሃይቂዴስ። ኢስራኤሌ ኣሳይ ባ ኣይሌቴꬃፌ ዴንዲዳይሳን ኦሊዳኔ ዋሲዳ፤ ኣይሌቴꬃ ዋዬይ ዳሪን ኢስቲ ዋሲዳ ዋሶይ ፑዴ ጾሳኮ ጋኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ጾሲ ኢስታ ኦሌዛኔ ኢስታ ዋሶዛ ሲዪዲ ኢዚ ኣብራሃሜራ፥ ዪሳቃራኔ ያቆቤራ ጫቂዳ ጫቆ ቃላ ዩሺ ቆፒዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ሄሳ ጊሻስ ጾሲ ኢስራኤሌ ናይታ ጼሊዲ ኢስታ ሃኖቴꬅ ቆፒዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ሙሴይ ሚዲያሜ ቢታ ቄሴ፥ ባ ቦሎ ዮቶሬ ዶርሳታ ሄሜስ፤ ኢዚ ዶርሳታ ላጊ ኤኪ ቢዲ ባዞ ቢታ ጋጻ ጋካናስ ኤፊዲ ሲና ጌቴቲዛ ጾሳ ዙማኮ ጋኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ሄን ጾሳ ኪታንቻይ ቄሪ ዎራ ጊዶን ኤጺዛ ታማ ላጮ ጊዶን ኢዛስ ቤቲዴስ፤ ዎራ ጊዶን ታማ ላጮይ ዲኮካ ታማይ ዎራ ሞንታይሳ ሙሴይ ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","ሄሳ ጊሻስ ሙሴይ፥ «ታኒ ጌዴ ባዳ ኣይስ ዎራይ ታማን ሜቴቶንታኮ ሃይሳ ኦራꬃ ሚሽ ኣኔ ቤያይስ» ጊ ቆፒዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","ኢዚ ቤያናስ ጌዴ ቢሺን ጾሲ ቤኢዲ ዎራ ጊዶን ዲሼ ኢዛ፥ «ሙሴ! ሙሴ!» ጊ ጼይጊዴስ። ሙሴይካ፥ «ዬ!» ጊ ኮዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ጾሲ ኢዛ፥ «ሃ ሺቆፓ፤ ኔኒ ኤቂዳሶይ ጌሽ ጊዲዳ ጊሻስ ኔ ቶሆን ዲዛ ጫማ ኬሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ቃሴካ ጾሳይ ኢዛ፥ «ታኒ ኔ ኣዋታ ኣብራሃሜ፥ ዪሳቃኔ ያቆቤ ጾሳ» ጊዴስ። ሂስቲን ሙሴይ ጾሳ ጼላናስ ባቢዳ ጊሻስ ባ ኣይፌሶ ካሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","ቃሴካ ጎዳይ፥ «ታኒ ጊብጼ ቢታን ታ ኣሳይ ዋዪዛ ዋዬ ሎኤꬃ ቤያዳ፥ ኢስቲ ባ ጎዳታፔ ዴንዲዳይሳን ዋሲዛ ዋሶ ሲያዲሲኔ ኢስታ ዋዬ ኤራዲስ። ");
INSERT INTO gmve_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ሄሳ ጊሻስ ታኒ ኢስታ ጊብጼ ቢታ ኣሳታ ኩሼፔ ኣሻናሲኔ ሄ ቢታፌ ኢስታ ኬሳዳ፥ ኣሆኔ ሎኦ ቢታ ኤፋናስ ሃ ዱጌ ዎꬋዲስ። ሄ ቢታይ ማꬂኔ ኤሲ ጎጊዛ ቢታ፤ ሃኢ ሄ ቢታን ካናኔቲ፥ ሂቴቲ፥ ኣሞሬቲ፥ ፓሪዜቲ፥ ሂዌቲኔ ያቡሴታ ጌቴቲዛ ኣሳቲ ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ሃኢ ኢስራኤሌ ናይታ ዋሶይ ታኮ ጋኪዴስ፤ ጊብጼ ቢታ ኣሳቲ ኢስታ ቆሂዛ ቆሆካ ታ ቤያዲስ፤ ");
INSERT INTO gmve_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ሄሳ ጊሻስ ሃኢ ባ፤ ታ ኣሳታ፥ ኢስራኤሌ ናይታ ጊብጼፔ ኬሳና ማላ፥ ጊብጼ ካዎዛኮ ታኒ ኔና ኪታይስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ጊዶ ኣቲን ሙሴይ ጾሳስ፥ «ካዎዛኮ ባናሲኔ ኢስራኤሌ ናይታ ጊብጼፔ ኬሳናስ ታኒ ኦኔ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ጾሲካ ኢዛ፥ «ታኒ ኔናራ ጊዳና፤ ቃሴ ታኒ ኔና ኪቲዳይሳስ ማላታይ ሃይሳ፤ ኔኒ ሄ ኣሳ ጊብጼፔ ኬሲዳ ዎዴ ሃይሳ ዙማ ቦላን ኢንቴ ታስ ጾሳስ ጎይናና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","ሙሴይ ጾሳስ፥ «ጊዶ ኣቲን ታኒ ኢስራኤሌ ናይታኮ ባዳ ኢስታስ፥ ‹ኢንቴ ኣዋታ ጾሲ ታና ኢንቴኮ ኪቲዴስ› ጊኮ፥ ኢስቲ ታና፥ ‹ኢዛ ሱንꬂ ኦኔ?› ጊ ኦይቺኮ ሄ ዎዴ ታኒ ኢስታስ ኣይ ጋ ዮታኔ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ጾሲካ ሙሴስ፥ « ‹ታኒ ታናኮ፤ ሄሳ ጊሻስ ካሴካ ሃኢካ ዲዛ ጾሲ ታና ኢንቴኮ ኪቲዴስ› ጋዳ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ቃሴ ጾሲ ሙሴስ፥ «ኔኒ ኢስራኤሌ ናይታስ፥ ‹ጎዳይ ኢንቴ ኣዋታ ኣብራሃሜ፥ ዪሳቃኔ፥ ያቆቤ ጾሲ ኢዚ ታና ኢንቴኮ ኪቲዴስ› ጋ ዮታ፤ ሃይሲ ዬሌታፔ ዬሌታ ጋካናስ ታኒ ኤሬቲዛ ታ ሱንꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","«ሄ ባዳ ኢስራኤሌ ጪማታ ሺሻዳ ጎዳ ኢንቴ ኣዋታ ኣብራሃሜ፥ ዪሳቃኔ ያቆቤ ጾሲ ታስ ቆንጪዲ፥ ‹ታኒ ኢንቴኮ ያዲስ፤ ጊብጼን ኢንቴ ቦላ ኣዚ ኦሴቲዳኮ ታኒ ቤያዲስ። ");
INSERT INTO gmve_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ታኒ ኢንቴና ጊብጼ ቢታ ዋዬፔ ኬሳዳ ፑዴ ማꬂኔ ኤሲ ጎጊዛ ካናኔታ፥ ሂቴታ፥ ኣሞሬታ፥ ፓሪዜታ፥ ሂዌታኔ ያቡሴታ ቢታ ኤፋና ጋዲስ› ጊዴስ» ጋዳ ዮታ። ");
INSERT INTO gmve_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","«ኢስራኤሌ ጪማቲ ኔ ቃላ ሲያና፤ ሄሳፌ ጉዬ ኔኒኔ ሄ ጪማቲ ጊብጼ ካዎዛኮ ቢዲ ኢዛስ፥ ‹ጎዳ ኢብራዌታ ጾሳይ ኑስ ቆንጪዴስ። ሃኢ ኑኒ ሄꬑ ጋላሳ ኦጌ ባዞ ቢዲ ጎዳስ ኑ ጾሳስ ያርሾ ያርሻና ማላ ኑና ዬዳ› ጊቴ። ");
INSERT INTO gmve_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ጊዶ ኣቲን ታ ዎልቃራ ዬዲሶንታ ዲሺን ጊብጼ ካዎይ ኢንቴና ዬዶንታይሳ ታኒ ኤራይስ። ");
INSERT INTO gmve_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ሄሳ ጊሻስ ታኒ ታ ኩሼ ዬዳዳ ኢስታ ጊዶን ታኒ ኦꬂዛ ታ ማላታታ ኡባን ጊብጼ ኣሳ ሾጫና። ሄሳፌ ጉዬ ኢዚ ኢንቴና ዬዳና። ");
INSERT INTO gmve_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","«ኢንቴ ኬኢዛ ዎዴ ጊብጼ ኣሳይ ኢንቴስ ኪያና ማላ ታ ኦꬃና ጊሻስ ኬኢሼ ሜላ ኩሼ ኬኤኬታ። ");
INSERT INTO gmve_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ኢብራዌ ማጫሳቲ ዉሪ ባ ጉታ ጊብጼ ማጫሳታኔ ባ ሶን ዲዛ ጊብጼ ማጫሳታ ኦናኮካ ጊዲን ቢዲ ቢራ፥ ዎርቃኔ ኣዴ ናይቲኔ ማጫ ናይቲ ማይኣና ማይኦታ፥ ‹ኢሚቴ› ጊ ኦይቻና። ሄሳꬆ ኦꬂዲ ኢንቴ ጊብጼ ኣሳ ኣቆ ኡባ ቡሪ ኤኪዲ ኬዛና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","ሙሴይካ ጎዳስ፥ «ኢስቲ ታና ኣማኖንታ ኢጺኮ ዎይኮ ታኒ ዮቲዛይሳ ሲዮንታ ኢጺዲ፥ ‹ጎዳይ ኔስ ቆንጪቤና› ጊኮ ታ ዋኖ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","ጎዳይ ኢዛ፥ «ሄሲ ኔ ኩሼን ዲዛይ ኣዜ?» ጊ ኦይቺዴስ። ኢዚካ፥ «ጉፌኮ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ጎዳይካ ኢዛ፥ «ኣኔ ኢዛ ጋዴን ዬጋ» ጊዴስ። ሙሴይ ሄ ጉፌዛ ጋዴን ዬጊን ሾሽ ጊዲዴስ፤ ሂስቲን ሙሴይ ኢዛፔ ዎጺ ኪቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ሄሳፌ ጉዬ ጎዳይ ኢዛ፥ «ኔ ኩሼ ዬዳዳ ሾሻ ጎይና ኦይካ» ጊዴስ። ሙሴይ ዬዲዲ ሾሻ ጎይና ኦይኪን ሾሻዚ ኢዛ ኩሼን ሲሚዲ ጉፌ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ጎዳይ፥ «ሃይሲ ሃኒዳይሲ ኔ ኣዋታ ኣብራሃሜ፥ ዪሳቃኔ ያቆቤ ጾሲ ኔስ ቆንጪዳይሳ ኢስቲ ኣማናና ማላሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ቃሴካ ጎዳይ ኢዛ፥ «ኔ ኩሼ ኔ ሾጳ ጊዶ ጌልꬃ» ጊን ሙሴይ ባ ኩሼ ባ ሾጳ ጊዶ ጌልꬂዴስ፤ ኢዚ ባ ኩሼዛ ሾጳፌ ኬሲዛ ዎዴ ኩሼዚ ቃራቲዲ ሻቻ ማላ ቦጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ጎዳይ ኢዛ፥ «ኔ ኩሼ ኔ ሾጳ ጊዶ ዛራ ጌልꬃ» ጊዴስ። ሂስቲን ሙሴይ ባ ኩሼ ባ ሾጳ ጊዶ ዛሪ ጌልꬂ ኬሲዛ ዎዴ ኢዛ ኩሼይ ሲሚዲ ሃንኮ ቦላ ማላ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","ቃሴካ ጎዳይ ኢዛስ፥ «ኢስቲ ኔና ኣማኖንታ ኣጊኮ ኮይሮ ማላታ ኣማኖንታ ኢጺኮ፥ ናምኣንꬆዛ ኣማናና። ");
INSERT INTO gmve_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ጊዶ ኣቲን ኢስቲ ጾሲ ኦꬂዛ ሃ ናምኡ ማላታታ ኣማኖንታ ኣጊኮ ዎይኮ ኔኒ ዮቲዛይሳ ሲዮንታ ኢጺኮ፥ ናይሌ ሻፋፔ ሃꬅ ዱቃ ኤካዳ ቢታ ቦላ ጉሳ፤ ኔኒ ሻፋፔ ኤኪዳ ሃꬂ ቢታ ቦላ ሱꬅ ጊዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ጊዶ ኣቲን ሙሴይ ጎዳስ፥ «ኣቤት ጎዶ! ታኒ ሃይሳፌ ካሴካ፥ ዎይኮ ኔኒ ኔ ኣይሌዛስ ታስ ዮቶሶፔ ሃ ሲሚንካ ታኒ ሎኤꬃ ሃሳያናስ ዳንዳዮንታ ኣስ ጊዲኪና?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ጎዳይ ኢዛስ፥ «ኣሳስ ዶና ሜꬊዳይ ኦኔ? ኣስ ዱዴ፥ ዎይኮ ቱሌ ኦꬂዛይ ኦኔ? ጼላኔ ቆቄ ኦꬂዛይ ኦኔ? ታና ጎዳ ጊዲኪና? ");
INSERT INTO gmve_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ኔኒ ሃኢ ባ፤ ኔ ሃሳያና ማላ ታ ኔናራ ጊዳናኔ ኔና ማዳና፤ ኔኒ ዮታናይሳካ ታ ኔና ታማርሳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","ጊዶ ኣቲን ሙሴይ ጎዳ፥ «ኣቤት ጎዶ! ሃይሳ ኦꬃናስ ሃራ ኣስ ኪታርኪ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ሄሳፌ ጉዬ ጎዳይ ሙሴ ቦላ ኬሂ ሃንቄቲዲ ኢዛ፥ «ሌዌ ባጋፌ ጊዲዳ ኔ ኢሻ ኣሮኔይ ዴስ ጊዴኔ? ኢዚ ሎኦ ሃሳያና ዳንዳይዛይሳ ታኒ ኤራይስ፤ ሃኢ ኢዚ ኔናራ ጋጋናስ ዪሼ ኦጌ ቦላን ዴስ፤ ኢዚ ኔና ቤኢዲ ኡፋዬታና። ");
INSERT INTO gmve_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ኔኒ ኢዛስ ዮታ፤ ኢዚ ዮታና ቃላካ ኔ ኢዛ ኤሪሳ፤ ታኒ ኢንቴና ናምኣታካ ሃሳያን ማዳናኔ ኢንቴ ኦꬃናይሳ ታማርሳና። ");
INSERT INTO gmve_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","ኢዚ ኣሳስ ኔ ጊሻስ ዮታና፤ ሄሲካ ኢዚ ኔስ ኔ ዶና ማላ ጊዲን ኔ ኢዛስ ሃሳይዛ ጾሳ ማላ ጊዳና ጉሳ። ");
INSERT INTO gmve_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ማላታታ ኢዛን ኦꬃናስ ኔኒ ሃይሳ ጉፌዛ ኤካ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ሄሳፌ ጉዬ ሙሴይ ባ ቦሎ፥ ዮቶሬኮ ሲሚ ቢዲ፥ «ሃኖ ጋካናስ ኣሳይ ፓጻ ዲዛኮ ቤያናስ ታኒ ጉዬ ታ ኣሳኮ ጊብጼ ቦ?» ጊዴስ። ዮቶሬይካ ሙሴ፥ «ኤ ባ፤ ሳሮን ጋካ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","ሙሴይ ሚዲያሜ ቢታን ዲሺን ጎዳይ ኢዛ፥ «ኔና ዎꬋናስ ኮዪዳ ኣሳቲ ዉሪ ሃይቂዳ ጊሻስ ጉዬ ጊብጼ ቢታ ሲማ ባ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ሙሴይ ባ ማቺዮኔ ባ ኣቱማ ናይታ ሃሬ ቶጊሲ ኤኪዲ ጉዬ ጊብጼ ሲሚሼ ጾሳ ጉፌ ኦይኪ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","ጎዳይ ሙሴ፥ «ኔኒ ጊብጼ ሲማዳ ቢዛ ዎዴ ታኒ ኔስ ኢሚዳ ዎልቃን ኔኒ ኦꬃና ማላታታ ኡባ ጊብጼ ካዎ ፓሮኔ ሲንꬃን ኔኒ ኦꬃናይሳ ባሎፓ። ሂስቲንካ ኢዚ ኣሳ ዬዶንታ ማላ ታኒ ኢዛ ዎዚና ሙሚሳና። ");
INSERT INTO gmve_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ሄ ዎዴ ታኒ ጎዳይ ጊዛይሳ ካዋስ፡ ኢስራኤሌይ ታስ ባይራ ና፤ ");
INSERT INTO gmve_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ታ ናዚ ታስ ጎይናናስ ኔ ዬዳና ማላ ታኒ ኔስ ዮታዲስ ሺን ኔኒ ኢዛ ዬዶንታ ኢጻዳሳ፤ ሄሳ ጊሻስ፥ ‹ታኒ ኔስ ባይራ ናዛ ዎꬋና› ጊዴስ ጋዳ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ኦጌ ቦላ ኢማꬂ ሼምፒዛሶን ጎዳይ ሙሴራ ጋጊዲ ኢዛ ዎꬋናስ ኮዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ኢዛ ማቺያ ጺፖራይ ቃራ ሹች ኤካዳ ባ ናዛ ቃጻራዱስ። ቃጻራዳ ሄ ሹርቴዛ ሙሴ ቶሆ ቦቻዳ ሙሴ፥ «ኔኒ ታስ ቱሙ ሱꬃ ሚሺራ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","ሄሳ ጊሻስ ጎዳይ ኢዛ ዎꬎንታ ኣጊዴስ። ሄ ዎዴ ቃጻራ ጋሶን ኢዛስ፥ «ኔኒ ታስ ሱꬃ ሚሺራ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ጎዳይ ኣሮኔ፥ «ኔኒ ሙሴራ ጋጋናስ ባዞ ባ» ጊን ኢዚ ቢዲ ሙሴራ ጾሳ ዙማ ቦላ ጋጊዲ ኢዛ ዬሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","ሄሳፌ ጉዬ ሙሴይ ጎዳይ ባ ቦላ ኪቲዳ ቃላ ኡባ ቃሴካ ኦꬃና ማላ ባና ኣዛዚዳ ማላታታ ኡባ ኣሮኔስ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ሙሴይኔ ኣሮኔይ ቢዲ ኢስራኤሌ ጪማታ ኡባ ኢሲ ቦላ ሺሺዳ። ");
INSERT INTO gmve_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","ኣሮኔይ ጎዳይ ሙሴስ ዮቲዳ ቃላ ኡባ ኢስታስ ዮቲዴሲኔ ማላታታ ሄ ኣሳ ሲንꬃን ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ኢስቲካ ኣማኒዳ። ጎዳይ ኢስታኮ ዪዳይሳኔ ኢስታ ዋዬ ቤኢዳይሳ ሲዪዳ ማላ ቢታ ቦላ ጉፋኒ ጎይኒዳ። ");
INSERT INTO gmve_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ሄሳፌ ጉዬ ሙሴይኔ ኣሮኔይ ጊብጼ ካዎዛኮ ቢዲ ኢዛስ፥ «ጎዳይ፥ ኢስራኤሌ ጾሲ፥ ‹ታ ኣሳይ ታስ ባዞን ባኣሌ ቦንቻና ማላ ዬዳ› ጊዴስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ሂስቲን ካዎዚ፥ «ታኒ ኢዛስ ኣዛዜታዳ ኢስራኤሌ ዬዳናስ ሄ ጎዳይ ኢዚ ኦኔ? ታኒ ጎዳ ኤሪኬ፤ ኢስራኤሌካ ዬዲኬ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ሄሳፌ ጉዬ ሙሴይኔ ኣሮኔይ፥ «ኢብራዌታ ጾሲ ኑናራ ጋጊዴስ። ሃኢ ኑኒ ጎዳስ፥ ኑ ጾሳስ ያርሾ ያርሻናስ ሄꬑ ጋላሳ ኦጌ ባዞ ጊዶ ባናስ ኑና ዬዳርኪ! ሂስቶንታ ኣጊኮ ኢዚ ኑና ኢታ ሃርጌን ዎይኮ ኦላን ዎꬋና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ጊዶ ኣቲን ጊብጼ ካዎይ፥ «ኢንቴኖ! ሙሴ! ኣሮኔ! ኣሳ ኣይስ ኦሶ ዲጌቲ? ሲሚዲ ኢንቴ ኦሶስ ቢቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ካዎዚካ፥ «ሄኮ ቤኢቴ፥ ሃ ቢታን ኣሳይ ጮራቲዴስ፤ ቃሴ ኢንቴ ኣሳ ኦሶ ዲጌታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ሄ ጋላስ ካዎይ ኢስራኤሌ ኣሳ ጋርሳፌ ኣሳ ኦሲሲዛይታኔ ኢስታፌ ቦላራ ዲዛ ጊብጼ ሃላቃታ ሂዝጊ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«ሃራ ዎዴይሳ ማላ ጹቤ ኦꬂዛ ኡቱላ ኣሳስ ኤሂ ኢሞፍቴ፤ ኢስቲ ኡቱላ ባፔ ኮዪዲ ሺሼቶ፤ ");
INSERT INTO gmve_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ጊዶ ኣቲን ኢስቲ ቆዳን ካሴይሳ ጊና ጹቤ ሜꬊዲ ሼꬋና ማላ ኣዛዚቴ፤ ካሴ ቆዳፔ ፓጪሶፒቴ፤ ኣይስ ጊኮ ኢስቲ ኣዛላ፤ ኢስታስ፥ ‹ኑኒ ኑ ጾሳስ ያርሾ ያርሻና ማላ ኑና ዬዳ› ጊዲ ዋሲዛይ ሄሳሳ። ");
INSERT INTO gmve_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ኢስቲ ኦሶን ሼካና ማላኔ ዎርዶ ሃሳያ ሲዮንታ ኣጋና ማላ ኢስታስ ኦሶ ዴጼꬂቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ሄሳፌ ጉዬ ኢስራኤሌ ኣሳ ጋርሳፌ ኣሳ ኦሲሲዛይቲኔ ኢስታፌ ቦላራ ዲዛ ጊብጼ ሃላቃቲ ኬዚዲ ኣሳስ፥ «ካዎዚ፥ ‹ሃይሳፌ ጉዬ ታ ኢንቴስ ኡቱላ ሙሌካ ኢሚኬ። ");
INSERT INTO gmve_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ኢንቴ ኡቱላ ዴማና ዳንዳይዛሶፔ ኢንቴ ባጋራ ኮዪ ኤሂቴ ሺን ኢንቴ ካሴ ሼꬊዛ ጹቤ ቆዳይ ሙሌካ ፓጮፎ› ጊዴስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ሂስቲን ኣሳይ ኡቱላ ሺሻናስ ጊብጼ ቢታ ኡባን ላሌቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ጊብጼ ሃላቃቲ ኢስታስ፥ «ካሴ ኢንቴስ ኡቱላ ኢሚዛ ዎዴ ኢንቴ ሃች ሃች ኦꬂዛይሳ ማላ ኦꬂቴ» ጊዲ ኢስታ ቦላ ጎዳቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ኢስራኤሌ ናይታ ኦሲሲዛይታስ ዋና ሃላቃቲ፥ «ኢንቴ ካሴ ኦꬂዛይሳ ማላ ጹቤ ቃማ ዎይኮ ሃች ኣይስ ኦꬂ ዉርሲቤኬቲ?» ጊ ኦይቺዲ ዋꬊዳ ");
INSERT INTO gmve_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ሄሳፌ ጉዬ ኢስራኤሌ ናይታፔ ዶሬቲዲ ኣሳ ኦሲሲዛይቲ ቢዲ ካዎዛስ ዋሲዳ፤ ኢስቲ ኢዛስ፥ «ኑኒ ኔ ኣይሌታ ጊዲሺን ኑ ቦላ ሃይሳꬆ ኣዛስ ኦꬃይ? ");
INSERT INTO gmve_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ኔ ኣይሌታስ ኑስ ኡቱላ ኢሜቴና፤ ጊዶ ኣቲን፥ ‹ጹቤዛ ሜꬊቴ› ጊዲ ኑና ኔ ኣይሌታ ዋꬌቴስ ሺን ባላይ ኔ ኣሳ ቦላ ዴስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ጊዶ ኣቲን ካዎዚ ኢስታ፥ «ሃ ኣዛላቲ! ኢንቴ ኣዛላታ! ሄሳ ጊሻሳ ኢንቴ ዛሪ ዛሪዲ፥ ‹ኑኒ ጎዳስ ያርሻናስ ባና ኑና ዬዳ› ጌታ። ");
INSERT INTO gmve_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ሃኢ ቢዲ ኦꬂቴ፤ ኢስቲ ኢንቴስ ኣይኮ ጋላባካ ኢሜቴና፤ ጊዶ ኣቲን ኢንቴ ካሴይሳፌ ፓጪሶንታ ጹቤዛ ሜꬊቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ኢስራኤሌ ናይታፔ ዶሬቲዲ ኣሳ ኦሲሲዛይቲ፥ «ኢንቴ ሃች ሃች ሜꬊዛ ጹቤ ቆዳ ካሴይሳፌ ፓጪሶፒቴ» ጊዳ ጊን ኢስቲ ሜቶን ጌሊዳይሳ ኤሪዳ። ");
INSERT INTO gmve_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ኢስቲ ካዎዛ ሲንꬃፌ ኬዚዲ ሙሴይኔ ኣሮኔይ ኢስታራ ጋጋናስ ናጊዛይታ ዴሚዳ። ");
INSERT INTO gmve_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ኢስቲ፥ «ጾሲ ኢንቴና ጼሎ! ኢንቴ ቦላ ኢዚ ፒርዶ! ኢንቴ ኑና ካዎኒኔ ኢዛ ኦሳንቻታን ኢጺሲዴታ፤ ቃሴ ኢስቲ ኑና ዎꬋና ማላ፥ ማሻ ኢስታስ ኢሚዴታ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","ሙሴይ ጎዳኮ ሲሚዲ፥ «ጎዶ፥ ኔኒ ሃ ኣሳ ቦላ ሜቶ ኣይስ ኤሃዲ? ኔኒ ታና ኪቲዳይ ሃይሳሴ? ");
INSERT INTO gmve_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ታኒ ኔ ሱንꬃን ካዋስ ሃሳያናስ ቢዳ ዎዴፔ ዶሚን ኢዚ ሃ ኣሳ ቦላ ሜቶ ኤሂዴስ። ቃሴ ኔኒካ ኔ ኣሳ ሙሌ ኣሻቤካ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ሄሳፌ ጉዬ ጎዳይ ሙሴስ፥ «ታኒ ጊብጼ ካዎ ቦላ ኦꬃናይሳ ኔኒ ሃኢ ቤያና፤ ታ ዎልቃማ ቄሴ ጋሶን ኢዚ ኢስታ ዬዳና፤ ታ ዎልቃማ ቄሴፔ ዴንዲዳይሳን ኢዚ ኢስታ ባ ቢታፌ ኬሲ ጎዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ጾሲ ቃሴካ ሙሴስ፥ «ታኒ ጎዳ፤ ");
INSERT INTO gmve_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ታኒ ኡባ ዳንዳይዛ ጾሳ ጊዳዳ ኣብራሃሜስ፥ ዪሳቃሲኔ ያቆቤስ ቆንጫዲስ ሺን ታኒ፥ ‹ጎዳ› ጌቴቲዛ ታ ሱንꬃን ታናቴꬃ ኢስታ ኤሪሳቤኬ። ");
INSERT INTO gmve_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","ቃሴ ታኒ ኢስታስ ኢስቲ ቤቴ ጊዲዲ ዴኢዳ ካናኔ ቢታ ኢስታስ ኢማናስ ታ ኢስታራ ጫቄታዲስ። ");
INSERT INTO gmve_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ቃሴካ ጊብጼ ኣሳይ ኣይሌ ሂስቲ ዋዪሲዳ ኢስራኤሌ ናይታ ዋሶ ሲያዳ ታ ጌሊዳ ጫቆ ቃላ ቆፓዲስ። ");
INSERT INTO gmve_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","«ሄሳ ጊሻስ ኔኒ ኢስራኤሌ ናይታስ፥ ‹ታኒ ጎዳ፤ ታኒ ኢንቴና ጊብጼ ኣሳ ቆሆፔ ኬሳና፤ ታኒ ኢንቴና ኢስታ ኣይሌቴꬃፌካ ጎቻ ኬሳና፤ ቃሴ ታኒ ኢንቴና ታ ጊታ ዎልቃኒኔ ዱማ ዱማ ፒርዳን ዎዛና። ");
INSERT INTO gmve_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ታኒ ኢንቴና ታ ዴሬ ሂስታና፤ ታኒ ኢንቴ ጾሳ ጊዳና። ሄ ዎዴ ታ ኢንቴና ጊብጼ ኣሳ ኣይሌቴꬃፌ ኬሲዳ ኢንቴ ጎዳ ሜርና ጾሳ ጊዲዳይሳ ኢንቴ ኤራና። ");
INSERT INTO gmve_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ቃሴ ታኒ ኢንቴና ኣብራሃሜስ፥ ዪሳቃሲኔ ያቆቤስ ኢማና ጋዳ ታ ኩሼ ዴንꬃዳ ጫቂዳ ቢታ ኤሃና፤ ሄ ቢታ ታኒ ኢንቴስ ኢንቴ ጋዴ ሂስታ ኢማና፤ ታኒ ጎዳ› ጋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","ሙሴይ ሄሳ ኢስራኤሌ ናይታስ ዮቲዴስ ሺን ኢስቲ ኡፋይስ ቃንጺዳ ጊሻሲኔ ኢታ ኣይሌቴꬃፌ ዴንዲዳይሳን ኢስታ ዎዚናይ ሜቂዳ ጊሻስ ኢስቲ ኢዛ ቃላ ሲዪቤቴና። ");
INSERT INTO gmve_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ሄሳፌ ጉዬ ጎዳይ ሙሴ፥ ");
INSERT INTO gmve_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«ሄ ባዳ ጊብጼ ካዋስ፥ ‹ኢስራኤሌ ናይታ ኔ ቢታፌ ኬሳ ዬዳ› ጋዳ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","ጊዶ ኣቲን ሙሴይ ጎዳስ፥ «ኢስራኤሌ ናይቲ ታይሳ ሲዮንታ ኢጺዳ ሺን ታኒ ዶናይ ቢርሾንታ ኣስ ጊዲሺን ካዎይ ታ ጊዛይሳ ዎስቲ ሲያኔ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","ጎዳይ ሙሴኔ ኣሮኔ፥ «ቢዲ ኢንቴ ኢስራኤሌ ኣሳ ጊብጼፔ ኬሳና ማላ ታኒ ኢንቴና ዬዲዳይሳ ኢስራኤሌ ኣሳሲኔ ጊብጼ ካዎስ ዮቲቴ» ጊ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ሃይሳፌ ካሊ ዲዛይቲ ኢስታ ኬꬃ ኬꬃ ሃላቃታ። ኢስራኤሌስ ባይራ ና ኦሮቤሌ ኣቱማ ናይቲ፥ ሄኖኬ፥ ፓሉ፥ ሄጺሮሜኔ ካርሜ፤ ሃይታንቲ ኦሮቤሌ ቆሞታ። ኢስታ ሶ ኣሳታ ሃላቃቲ ሃይታ። ");
INSERT INTO gmve_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","ቃሴ ሲሞና ኣቱማ ናይቲ፥ ዪሙኤሌ፥ ያሚኔ፥ ኦሃዴ፥ ያኪኔ፥ ጾሃሬኔ ካናኔ ቢታ ማጫሳታፔ ዬሌቲዳ ሳኦሌ፤ ሃይቲ ሲሞና ቆሞታ። ");
INSERT INTO gmve_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","ሌዌ ባጋቲ ባ ዬሌታ ማራ ማላ ጌርሾኔ፥ ቃኣቴኔ ሜራሬ። ሌዌይ 137 ላይꬅ ዴኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","ጌርሾኔ ኣቱማ ናይቲ ባ ቆሞን ቆሞን ሊቢናኔ ሺምኤ ጌቴቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","ቃሄቴ ኣቱማ ናይቲ ኣሚራሜ፥ ዪጺሃሬ፥ ኬብሮኔኔ ኡዚኤሌ። ቃኣቴይ 133 ላይꬅ ዴኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","ሜራሬ ኣቱማ ናይቲ ማሂሌኔ ሙሼ ጌቴቲዛይታ። ባ ዬሌታ ማራን ሌዌ ዛሬቲ ሃይታንታ። ");
INSERT INTO gmve_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","ኣሚራሜይ ባ ኣዋ ሚቼዮ ዮካቤዶ ማቾ ኤኪዴስ። ኢዛካ ኢዛስ ኣሮኔኔ ሙሴ ዬላዱስ። ኣሚራሜይ 137 ላይꬅ ዴኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ዪጺሃሬ ኣቱማ ናይቲ፥ ቆሬ፥ ኔፌጌኔ ዚኪሬ። ");
INSERT INTO gmve_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ኡዚኤሌ ኣቱማ ናይቲ፥ ሚሻኤሌ፥ ኤልጻፋኔኔ ሲቲሬ። ");
INSERT INTO gmve_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","ኣሮኔይ ኣሚናዳቤ ናዮ፥ ኔኣሶኔ ሚቼዮ ኤሊሼቦ ማቾ ኤኪዴስ። ሂስቲን ኢዛ ኢዛስ ናዳቤ፥ ኣቢሁ፥ ኤልኤዜሬኔ ኢታማሬ ዬላዱስ። ");
INSERT INTO gmve_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","ቆሬ ኣቱማ ናይቲ፥ ኣሲሬ፥ ሂልቃናኔ ኣቢያሳፌ፤ ሃይታንቲ ቆሬ ቆሞታስ ኣዋታ። ");
INSERT INTO gmve_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ኣሮኔ ና ኤልኤዜሬይ ፑቲኤሌ ናይታፔ ኢሲኒዮ ማቾ ኤኪዴስ፤ ኢዛካ ኢዛስ ፊኒሃሴ ዬላዱስ። ሃይታንቲ ባ ቆሞን ቆሞን ሌዌ ኬꬃ ኣሳ ሃላቃታ። ");
INSERT INTO gmve_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ጎዳይ፥ «ጊብጼ ቢታፌ ኢስራኤሌ ናይታ ኢስታ ጩጋን ጩጋን ኬሲቴ» ጊዲ ኣዛዚዳይ ሃይታ ሙሴኔ ኣሮኔ። ");
INSERT INTO gmve_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ኢስራኤሌ ናይታ ጊብጼ ቢታፌ ኬሲዛይሳ ጊብጼ ካዋስ ዮቲዳይቲ ሙሴኔ ኣሮኔ። ");
INSERT INTO gmve_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ጎዳይ ጊብጼን ሙሴስ ዮቲዛ ዎዴ ኢዛስ፥ ");
INSERT INTO gmve_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","«ታኒ ጎዳ፤ ታኒ ኔስ ዮቲዛይሳ ኡባ ኔኒ ጊብጼ ካዋስ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ሙሴይ ቃሴ ጎዳስ፥ «ታኒ ዶናይ ቢርሾንታ ኣስ ጊዲዳ ጊሻስ ካዎይ ታኒ ዮቲዛይሳ ዎስቲ ሲያኔ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","ሄሳፌ ጉዬ ጎዳይ ሙሴስ፥ «ቤያ፤ ታኒ ኔና ጊብጼ ካዋስ ጾሳ ማላ ኦꬃዲስ፤ ኔ ኢሻ ኣሮኔይ ኔ ዶና ጊዲዲ ኔ ጊሻስ ሃሳያና፤ ");
INSERT INTO gmve_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ታኒ ኔና ኣዛዚዳይሳ ኡባ ኔ ኢሻ ኣሮኔስ ዮታንዳሳ፤ ካዎዚ ኢስራኤሌ ናይታ ባ ቢታፌ ኬሲ ዬዳና ማላ ኢዚ ዮታና። ");
INSERT INTO gmve_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ጊዶ ኣቲን ታኒ ካዎዛ ዎዚና ሚንꬃና፤ ታኒ ጊብጼ ቢታን ታ ማላታኔ ማላሊሲዛ ሚሽ ዳርሳ ኦꬂኮካ፥ ");
INSERT INTO gmve_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ኢዚ ኢንቴ ዮቲዛይሳ ሲዬና። ሄ ዎዴ ታኒ ታ ኩሼ ጊብጼ ኣሳ ቦላ ዴንꬃና፤ ታኒ ታ ዴሬታ ኢስራኤሌ ናይታ ዎልቃማ ፒርዳን ጊብጼፔ ኬሳና። ");
INSERT INTO gmve_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ቃሴ ጊብጼቲ ታኒ ታ ቄሴ ጊብጼ ኣሳ ቦላ ዴንꬃዳ ኢስራኤሌ ናይታ ኢስታ ጊዶፌ ኬሲዛ ዎዴ ታኒ ጎዳ ጊዲዳይሳ ኢስቲ ኤራና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","ሙሴይኔ ኣሮኔይ ጎዳይ ኢስታ ኣዛዚዳ ማላ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ኢስቲ ካዎዛስ ዮቲዛ ዎዴ ሙሴስ ላይꬃይ ኦስፑን ታማ፤ ኣሮኔይ ቃሴ 83 ላይꬃ ኣሳ። ");
INSERT INTO gmve_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","ጎዳይ ሙሴኔ ኣሮኔ፥ ");
INSERT INTO gmve_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«ካዎይ ኢንቴና፥ ‹ኣኔ ማላታ ታና ቤሲቴ› ጊኮ ኔኒ ኣሮኔ፥ ‹ኔ ጉፋ ኤካዳ ካዎዛ ሲንꬃን ዬጋ› ጋ፤ ሂስቲኮ ኢዚ ሾሽ ጊዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","ሂስቲን ሙሴይኔ ኣሮኔይ ካዎዛኮ ጌሊዲ ጎዳይ ኢስታ ኣዛዚዳ ማላ ኦꬂዳ፤ ኣሮኔይ ባ ጉፌ ካዎዛ ሲንꬃኒኔ ዳናታ ሲንꬃን ዬጊን ጉፌዚ ሾሽ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ሄሳፌ ጉዬ ካዎዚ ዳሮ ኤራንቻታኔ ቢቲዛይታ ጼይጊሲን ጊብጼ ዴሬ ማሮቲካ ባ ዴሬን ሄሳꬆ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ኢስቲ ዉሪካ ባ ጉፌ ጉፌ ጋዴን ዬጊን ጉፌቲ ዉሪካ ሾሽ ጊዲዳ ሺን ኣሮኔ ጉፌያ ኢስታ ጉፌታ ኡባ ሚታዱስ። ");
INSERT INTO gmve_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ጊዲኮካ ጎዳይ ዮቲዳ ማላ ካዎዛ ዎዚናይ ሚኒዳ ጊሻስ ኢዚ ኢስታ ዮኦ ሲዮንታ ኢጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ጎዳይ ሙሴስ፥ «ካዎዛ ዎዚናይ ሙሚን ኣሳ ኢዚ ዬዶንታ ኢጺዳ ጊሻስ፥ ");
INSERT INTO gmve_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ካዎዚ ሻፋ ቢዛ ዎዴ ማላዶራ ኔኒ ኢዛኮ ባዳ ኢዛራ ጋጋና ማላ ኣባዬ ሻፋ ዶናን ኤቃ፤ ሄ ባሼ ሾሻን ላሜቲዳ ጉፌዛ ኦይካ ኤካዳ ባ። ");
INSERT INTO gmve_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","ኔኒ ኢዛ፥ ‹ጎዳ ኢብራዌታ ጾሳይ ኔና፥ «ባዞን ታስ ጎይናና ማላ ታ ኣሳ ዬዳ» ጊዲ ታና ኔኮ ኪቲዴስ ሺን ሃኖ ጋካናስ ኔኒ ኤሮ ጋቤካ። ");
INSERT INTO gmve_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ጎዳይ፥ «ታኒ ጎዳ ጊዲዳይሳ ኔኒ ሃይሳን ኤራና» ጊዴስ። ታኒ ኣባዬ ሻፋ ሃꬃ ታ ኩሼን ዲዛ ጉፌዛን ሾጪኮ ሃꬃይ ሱꬃን ላሜታና። ");
INSERT INTO gmve_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ኣባዬ ሻፋ ሞሌይካ ሃይቃና፤ ሻፋይካ ጺንቃና፤ ጊብጼቲ ሄ ሻፋ ሃꬃ ኡያናስ ዳንዳዬቴና› ጋዳ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","ጎዳይ ሙሴስ፥ «ኔኒ ኣሮኔስ፥ ‹ኔ ጉፌ ኦይካዳ ጊብጼ ሃꬃታ ቦላ፥ ሻፋታ ቦላ፥ ዛራ ሃꬃታ ቦላኔ ኤሊዳ ሃꬂ ዲዛሶ ኡባ ቦላ ኔ ኩሼ ፒዲሳ› ጋ፤ ኢዚ ባ ኩሼ ፒዲሲኮ ሃꬂ ዉሪ ሱꬃን ላሜታና፤ ጊብጼ ቢታ ኡባን፥ ሃራይ ኣቶሺን፥ ሚꬃፌኔ ሹቻፌ ዎጪ ኬሲዳ ሃꬅ ቲጊዛ ሚሻታ ኡባን ሱꬂ ኩማና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","ሙሴይኔ ኣሮኔይ ጎዳይ ኣዛዚዳ ማላ ኦꬂዳ። ካዎዛ ሲንꬃኒኔ ዳናታ ሲንꬃን ኣሮኔይ ባ ጉፌዛ ዴንꬂዲ ሻፋ ሃꬃ ሾጪን ሃꬂ ዉሪ ሱꬃን ላሜቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ሄ ሻፋ ሃꬃ ጊዶን ዲዛ ሞሌቲ ሃይቂዳ፤ ሻፋ ሃꬂ ኬሂ ጺንቂዳ ጊሻስ ጊብጼ ኣሳይ ኡያናስ ዳንዳይቤና። ጊብጼ ቢታይ ኩሜꬅ ሱꬅ ጻላ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ጊዶ ኣቲን ጊብጼ ማሮቲ ባ ቢታን ኢዛꬆካ ኦꬂዳ፤ ጎዳይ ዮቲዳ ማላካ ካዎዛ ዎዚናይ ሚኒዳ ጊሻስ ሙሴይኔ ኣሮኔይ ዮቲዳይሳ ሲዮንታ ኢጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ሄሳፌ ጉዬ ካዎዚ ሄሳስ ኣይኮ ባቦንታ ዲሼ ባ ሶ ሲሚ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ጊብጼ ኣሳይ ዉሪ ኣባዬ ሻፋ ሃꬃ ኡያናስ ዳንዳዮንታ ጊሻስ፥ ኡዪዛ ሃꬅ ዴማናስ ኣባዬ ሻፋ ኣቻን ኦላ ቦኪዳ። ");
INSERT INTO gmve_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","ጎዳይ ሃꬃ ሱꬃን ላሚን ላፑን ጋላስ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ሄሳፌ ጉዬ ጎዳይ ሙሴ፥ «ጊብጼ ካዋኮ ባዳ፥ ‹ጎዳይ ኔና ሂዝጌስ ጋ፤ ታስ ጎይናና ማላ ታ ኣሳ ዬዳ፤ ");
INSERT INTO gmve_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ኔኒ ኢስታ ዬዶንታ ኢጺኮ ታኒ ኔ ቢታ ኡባ ሞሪዛ ኦቃርስ ዬዳና። ");
INSERT INTO gmve_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ኣባዬ ሻፋን ኦቃርሲ ኩሚ ኣꬊዲ ኔ ሶ፥ ኔ ኣቂዛ ሶ፥ ኔ ኣርሳ ቦላ፥ ዳናታ ኬꬃ ጊዶ ጌላና፤ ኔ ኣሳ ቦላ ኬዛና፤ ኔ ጮጬን ኔ ሙኑቃ ጎንጌታንካ ጌላና። ");
INSERT INTO gmve_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ኦቃርሳቲ ኔ ቦላ፥ ኔ ኣሳ ቦላኔ ዳናታ ኡባ ቦላ ኬዛና› ጋዳ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ሄሳፌ ጉዬ ጎዳይ ሙሴ፥ «ኔኒ ኣሮኔ፥ ‹ኔ ጉፌዛ ኤካዳ፥ ሻፋታ ቦላ፥ ዛራ ሃꬃታ ቦላኔ ኤሊዳ ሃꬃታ ቦላ ኔ ኩሼ ፒዲሳዳ ኦቃርሲ ጊብጼ ቢታ ቦላ ኬዛና ማላ ኦꬃ› ጋዳ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","ሂስቲን ኣሮኔይ ጊብጼ ሃꬃታ ቦላ ባ ኩሼ ፒዲሲን ኦቃርሲ ኬዚዲ ጊብጼ ቢታ ማይኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ጊዶ ኣቲን ማሮቲካ ባንታ ቢታን ጊብጼን ኦቃርሲ ኬዛና ማላ ኢዛꬆካ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ካዎዚ ሙሴኔ ኣሮኔ ጼይጊሲዲ፥ «ሃይሳ ኦቃርሳ ታፔኔ ታ ኣሳ ቦላፌ ዲጋና ማላ ጎዳ ኢንቴ ዎሲቴ፤ ሂስቲኮ ጎዳስ ያርሻና ማላ ታኒ ኣሳ ዬዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","ሂስቲን ሙሴይ ካዎዛ፥ «ካዎ ኔስ ቶ! ኦቃርሲ ኔፔኔ ኔ ሶፔ ꬋይዲ ኣባዬ ሻፋን ጻላ ኣታና ማላ ታኒ ኔስ፥ ዳናታሲኔ ኔ ኣሳስ ዎሳና ጋላስ ኔ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ሂስቲን ካዎዚ፥ «ዎንቶ ጊዶ» ጊዴስ። ሙሴይካ፥ «ጎዳ ኑ ጾሳ ማላይ ኦኒካ ባይንዳይሳ ኔኒ ኤራና ማላ ኔ ጊዳ ማላ ኦꬃና። ");
INSERT INTO gmve_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ሄ ኦቃርሳይ ኔፔ፥ ኔ ኬꬃፌ፥ ዳናታፔኔ ኔ ኣሳፔ ꬋያና፤ ኢስቲ ኣባዬ ሻፋን ጻላ ኣታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","ሙሴይኔ ኣሮኔይ ካዋ ኣቻፌ ኬዚዲ ካዎዛ ቦላ ኢዚ ኤሂዳ ኦቃርሳታ ጊሻስ ሙሴይ ጎዳኮ ዋሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","ጎዳይካ ሙሴይ ኦይቺዳ ማላ ኦꬂዴስ፤ ኦቃርሲ ሶን፥ ካሬኒኔ ዴምባን ዲዛይሲ ዉሪ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ጊብጼ ኣሳይ ኦቃርሳ ሺሺ ሺሺዲ ኮሪዴስ፤ ቢታይካ ጺንቆን ዜቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ጊዶ ኣቲን ካዎዚ ጉꬃ ፔቃ ዴሚዳ ዎዴ ባ ዎዚና ሚንꬂዴስ፤ ጎዳይ ዮቲዳ ማላካ ኢዚ ሙሴይኔ ኣሮኔይ ዮቲዳ ዮኦዛ ሲዮንታ ኢጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ሄሳፌ ጉዬ ጎዳይ ሙሴ፥ «ኔኒ ኣሮኔስ፥ ‹ኔ ጉፌዛራ፥ ቢታ ጉዱላ ሾጫ› ጋ፤ ኢዚ ሾጪኮ ጊብጼ ቢታ ኡባን ጉዱላይ ጩች ጊዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","ሂስቲን ኢስቲ ሄሳꬆ ኦꬂዳ፤ ኣሮኔይ ባ ጉፌ ኤኪዲ ጉፌዛራ ቢታ ጉዱላ ሾጪን ኣሳኔ ሜሄ ኡባ ቦላ ጩቺ ኬዚዴስ። ጊብጼ ቢታን ሃ ጋጻፔ ሄኒ ጋጻ ጋካናስ ጉዱላይ ዉሪ ጩች ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ማሮቲካ ባ ቢታን ኢዛꬆ ኦꬃናስ ፓጪን ኢስታስ ዳንዳዬቲቤና። ጩቻይ ኣሳ ቦላኔ ሜሄ ቦላ ኩሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ማሮቲካ ካዎዛስ፥ «ሃይሲ ጾሳ ኦሶኮ!» ጊዳ። ጊዶ ኣቲን ካዎዛ ዎዚናይ ሚኒዴስ፤ ጎዳይ ጊዳ ማላካ ኢዚ ኢስቲ ዮቲዛይሳ ሲዮንታ ኢጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ጎዳይ ሙሴስ፥ «ዎንታ ማላዶራ ዴንዳዳ፥ ካዎዚ ሻፋ ቢሺን ኢዛራ ጋጋዳ ኔኒ ኢዛ፥ ‹ጎዳይ ታስ ጎይናና ማላ ታ ኣሳ ዬዳ፤ ");
INSERT INTO gmve_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ኔኒ ታ ኣሳ ዬዶንታ ኢጺኮ፥ ታኒ ኔ ቦላ፥ ዳናታ ቦላ፥ ኔ ኣሳ ቦላኔ ኔ ኬꬃታ ጊዶ ዎልቃማ ቦጼ ዬዳና፤ ጊብጼ ኣሳ ኬꬃኒኔ ኢስቲ ዲዛ ቢታ ኡባን ቦጼይ ኩማና። ");
INSERT INTO gmve_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","ጊዶ ኣቲን ታኒ ጎዳይ ሃ ቢታን ዲዛይሳ ኔኒ ኤራና ማላ ሄ ጋላስ ታ ኣሳይ ዲዛ ጌሴሜ ቢታን ቦጼይ ጋኮንታ ማላ ታኒ ቴቃዳ ኢስታ ቢታ ናጋና። ");
INSERT INTO gmve_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","ታኒ ኔ ኣሳፔ ታ ኣሳ ዱማ ሻካና፤ ሃይሳን ማላታ ዎንቶ ኦꬃና› ጊዴስ ጋዳ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","ሄሳፌ ጉዬ ጎዳይ ጊዳ ማላ ኦꬂዴስ፤ ካዎዛ ሶኒኔ ኢዛ ዳናታ ሶን ዳሮ ዎልቃማ ቦጼይ ኩሚዴስ፤ ኩሜꬃ ጊብጼ ቢታ ኡባ ኢሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ሄ ዎዴ ካዎዚ ሙሴኔ ኣሮኔ ጼይጊሲዲ፥ «ቢቴ፤ ሃይሳ ሃ ቢታን ኢንቴ ጾሳስ ያርሺቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ጊዶ ኣቲን ሙሴይ፥ «ሄሲ ሎኦ ዴና፤ ኑኒ ጎዳ ኑ ጾሳስ ሺሺዛ ያርሾቲ ጊብጼ ኣሳስ ቱና ሚሽ ጊዳና፤ ኑኒ ኢስታ ቱኒሲዛ ያርሾታ ኢስቲ ጼሊሺን ያርሺኮ፥ ኢስቲ ኑና ሹቻን ጫዴቴኔ? ");
INSERT INTO gmve_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ኑኒ ጎዳ ኑ ጾሳስ ያርሾታ ሺሻናስ ኢዚ ኑና ኣዛዚዳ ማላ ሄꬑ ጋላሳ ኦጌ ባዞ ባናስ ኮሼስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ሂስቲን ካዎዚ፥ «ጎዳ ኢንቴ ጾሳስ ኢንቴ ባዞ ቢዲ ያርሻና ማላ ታኒ ኢንቴና ዬዳና ሺን ኢንቴ ሃኪ ቦፒቴ፤ ሃኢ ታስ ዎሲቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","ሙሴይ፥ «ታኒ ኔ ኣቻፌ ኬዚዳ ማላ ጎዳ ዎሳና፤ ሃ ዎልቃማ ቦጼይ ዎንቶ ካዎዛፔ፥ ዳናታፔኔ ኢዛ ኣሳፔ ኪቻና። ጊዶ ኣቲን ጎዳስ ያርሻናስ ኣሳ ዬዶንታ ኢጻናስ ካዎይ ኑና ዛሪ ጪሞንታ ማላ ቆፖ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","ሄሳፌ ጉዬ ሙሴይ ካዎዛ ኣቻፌ ኬዚዲ ጎዳ ዎሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ሙሴይ ኦይቺዳ ማላ ጎዳይ ኦꬂዴስ፤ ቦጼይ ካዎዛፔ፥ ዳናታፔኔ ኢዛ ኣሳፔ ኢሲኖካ ኣቶንታ ኪቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ጊዶ ኣቲን ሃኢካ ካዋ ዎዚናይ ሚኒዳ ጊሻስ ኢዚ ኣሳ ዬዶንታ ኢጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ጎዳይ ሙሴ፥ «ጊብጼ ካዎዛኮ ባዳ ጎዳ ኢብራዌታ ጾሳይ ኔና፥ ‹ታስ ጎይናና ማላ ታ ኣሳ ዬዳ፤ ");
INSERT INTO gmve_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ኔኒ ዬዶንታ ኢጺዛ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ሄሜቲዛሶን ዲዛ ኔ ሜሄታ ቦላ፥ ፓራታ ቦላ፥ ሃሬታ ቦላ፥ ጋሜላታ ቦላ፥ ሚዛታ ቦላ፥ ዶርሳታ ቦላኔ ዴይሻታ ቦላ ዎልቃማ ሃርጌ ዬዳና። ");
INSERT INTO gmve_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ጊዶ ኣቲን ታኒ ጎዳይ ኢስራኤሌ ሜሄታ ጊዶኒኔ ጊብጼ ኣሳ ሜሄታ ጊዶን ሻኮቴꬅ ሜꬋና። ኢስራኤሌ ኣሳ ሜሄታፔ ኢሶይካ ሃይቄና› ጋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ጎዳይ ዎዴ ባሪዲ፥ «ታኒ ዎንቶ ሃይሳ ሃ ቢታ ቦላ ኦꬃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","ዎንቴꬃ ጋላስ ጎዳይ ሄሳ ኦꬂዴስ። ጊብጼ ኣሳ ሜሄይ ዉሪ ሃይቂዴስ ሺን ኢስራኤሌ ኣሳ ሜሄፔ ኢሲናካ ሃይቃቤኩ። ");
INSERT INTO gmve_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ካዎዚ ሃ ዮኦዛ ፓጫናስ ኣስ ኪቲዲ ኢስራኤሌ ናይታ ሜሄፔ፥ ሃራይ ኣቶሺን ፔጺ ኢሲናካ ሃይቆንታይሳ ኤሪዴስ። ጊዲኮካ ካዎዛ ዎዚናይ ሚኒዳሶፔ ሲሞንታ ኢጺዳ ጊሻስ ኣሳ ዬዶንታ ኢጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ሄሳፌ ጉዬ ጎዳይ፥ ሙሴኔ ኣሮኔ፥ «ኩሼ ኩንꬂዲ ጮጬፔ ቢዲንꬃ ኩጪ ኤኪዲ ሙሴይ ካዎዚ ጼሊሺን ሄሳ ፑዴ ጫርኮ ቦላ ላሎ፤ ");
INSERT INTO gmve_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","ሃይሲ ጊብጼ ቢታ ኡባ ቦላ ጉዱላ ጊዳና፤ ጊብጼ ቢታ ኡባን ኣሳ ቦላኔ ሜሄ ቦላ ኪጻይ ዎꬋና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","ሂስቲን ኢስቲ ጮጬፔ ቢዲንꬅ ኤኪዲ ካዎዛ ሲንꬃን ኤቂዳ፤ ሙሴይ ሄሳ ፑዴ ጫርኮን ላሊን ኣሳ ቦላኔ ሜሄ ቦላ ጊዪዛ ኪጻይ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ማሮቲካ ኢስታ ቦላኔ ጊብጼ ኣሳ ኡባ ቦላ ዎꬊዳ ኪጻይ ኤቆ ዲጊን ሙሴ ሲንꬃን ኤቃናስ ዳንዳይቤቴና። ");
INSERT INTO gmve_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ጊዶ ኣቲን ጎዳይ ሙሴስ ጊዳ ማላካ ካዎዛ ዎዚና ሚንꬂዳ ጊሻስ ሙሴይኔ ኣሮኔይ ዮቲዛይሳ ካዎዚ ሲዮንታ ኢጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ሄሳፌ ጉዬ ጎዳይ ሙሴስ፥ «ዎንቶ ዎንታ ማላዶራ ዴንዳ ባዳ ካዎዛራ ጋጋዳ ኢዛ ኢብራዌታ ጎዳይ ኔና፥ ‹ታስ ጎይናና ማላ ታ ኣሳ ዬዳ። ");
INSERT INTO gmve_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ኔ ዬዶንታ ኢጺኮ ኔ ቦላ፥ ዳናታ ቦላኔ ኔ ኣሳ ቦላ ታ ዎልቃማ ሃንቆ ሃኢ ዬዳና፤ ሄሳንካ ቢታ ቦላን ታ ማላይ ባይንዳይሳ ኔኒ ኤራና። ");
INSERT INTO gmve_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ታኒ ሃኖ ጋካናስ ታ ኩሼ ዬዳዳ ኔናኔ ኔ ኣሳ ኢታ ሃርጌን ቆሂዳኮ ሃ ቢታ ቦላፌ ፒታ ꬋይሳናኮሺን። ");
INSERT INTO gmve_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ታኒ ኔና ፓጻ ዎꬂዳይ ኔና ታ ዎልቃ ቤሳናሲኔ ታ ሱንꬂ ቢታ ኡባ ቦላን ጼይጌታና ማላሳ። ");
INSERT INTO gmve_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","ኔኒ ሃኢካ ኦቶሬታዳ ታ ኣሳ ዬዶንታ ኢጻዳሳ። ");
INSERT INTO gmve_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ሄሳ ጊሻስ ታኒ ዎንቶ ሃኒ ዎዴ ጊብጼይ ጊብጼ ጊዶሶፔ ሃች ጋካናስ ቡኪ ኤሮንታ ዎልቃማ ሻች ቡኪሳና። ");
INSERT INTO gmve_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ሃኢ ኔኒ ኔ ሜሄኔ ጋዴን ኔስ ዲዛዝ ኡባ ሶ ጌልꬃና ማላ ኣዛዛ፤ ኣይስ ጊኮ ሶ ጌሎንታ ቡሮ ጋዴን ዲዛ ኣሳ ኡባ ቦላኔ ሜሄ ኡባ ቦላ ሻቺ ቡኪዲ ዎꬋና› ጊዴስ ጋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ካዎዚ ሱንꬂዳ ዳናታፔ ጎዳ ቃላስ ባቢዳይቲ ባ ኣይሌታኔ ባ ሜሄ ኤሶቲዲ ሶ ጌልꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ጊዶ ኣቲን ጎዳ ቃላ ካꬊዳይቲ ባ ኣይሌታኔ ባ ሜሄ ካሬን ኣጋጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ሄሳፌ ጉዬ ጎዳይ ሙሴስ፥ «ጊብጼ ቢታ ኡባ ቦላን፥ ኣሳ ቦላ፥ ሜሄ ቦላኔ ቢታፌ ሞኪዛ ኡባ ቦላ ሻቺ ቡካና ማላ ኔ ኩሼ ሳሎ ዴንꬃ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","ሙሴይ ባ ጉፌ ፑዴ ሳሎ ዴንꬂዳ ማላ፥ ጎዳይ ዳዳኔ ሻች ዬዲዴስ፤ ዎልቃንꬂካ ዱጌ ቢታ ቦላ ዎልቃሚዴስ። ጎዳይ ጊብጼ ቢታን ሻች ቡኪሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ሻቻይ ቡኪዴስ፤ ዎልቃንꬂካ ዎልቃሚዴስ፤ ጊብጼ ዴሬይ ዴሬ ጊዶሶፔ ሃ ሲሚን ጊብጼ ቢታ ኡባ ቦላ ዎꬊዳ ሻቻ ኡባፌ ሃይሲ ኣꬊዛ ኢታ ሻቻ። ");
INSERT INTO gmve_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ሄ ሻቻይ ጊብጼ ቢታ ኡባን ጋዴን ዲዛ ኡባ፥ ኣሳካ ሜሄካ ሾጪዴስ፤ ቢታፌ ሞኪዳዝ ኡባ ዱጌ ዛሪዲ ሾጪዴስ፤ ሚꬂካ ኡባ ሜንꬄሬꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ኢስራኤሌ ናይቲ ዲዛ ጌሴሜ ቢታይ ጻላ ሻቺ ቡኮንታ ኣቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","ካዎይካ ሙሴኔ ኣሮኔ ጼይጊሲዲ፥ «ሃኢ ሄኮ፥ ታኒ ናጋራ ኦꬃዲስ፤ ጎዳይ ጺሎ፤ ታኒኔ ታ ኣሳይ ዎርዶ። ");
INSERT INTO gmve_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ዳዳይኔ ሻቺ ኑ ቦላ ዳሪዳ ጊሻስ ኑስ ጎዳ ዎሲቴ። ታኒ ኢንቴና ዬዳና፤ ሄኮ ሃይሳፌ ሲንꬃን ኢንቴ ሃይሳን ጋምኤኬታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","ሙሴይካ ኢዛስ፥ «ታኒ ሃ ካታማፔ ኬዛ ባዳ ዎሳናስ ታ ኩሼ ጎዳኮ ሚጫና፤ ሂስቲኮ ዳዳይ ኣጋና፤ ቃሴ ሻቻይካ ቡኬና፤ ሄሳንካ ቢታይ ጎዳስ ጊዲዳይሳ ኔኒ ኤራና። ");
INSERT INTO gmve_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ጊዶ ኣቲን ኔኒኔ ዳናቲ ጎዳ ጾሳስ ሃኢካ ባቦንታይሳ ታኒ ኤራይስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","32","ጪዪዳ ካꬃይኔ ቲያቲዳ ካꬃይ ዉሪ ꬋይዴስ፤ ጊዶ ኣቲን ጪዮንታኔ ቲያቶንታ ቡሮ ጋኪዛ ካꬃ ሻቻይ ቆሂቤና። ");
INSERT INTO gmve_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","ሄሳፌ ጉዬ ሙሴይ ካዎዛ ኣቻፌ ዴንዲዲ ካታማፔ ጋጻ ኬዚዲ ባ ኩሼ ጎዳኮ ሚጪዴስ፤ ሂስቲን ዳዳይኔ ሻቻይ ኤቂዴስ፤ ኢራይካ ቢታ ቦላ ቡኪዛይሳ ኣጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ጊዶ ኣቲን ካዎዚ ኢራይ፥ ሻቻይኔ ዳዳይ ኣጊዳይሳ ቤኢዳ ዎዴ ቃሴካ ናጋራ ኦꬂዴስ፤ ኢዚኔ ዳናቲካ ባንታ ዎዚና ሚንꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ጎዳይ ሙሴ ዶናራ ሃሳይዳ ማላካ ካዋ ዎዚናይ ሚኒን ኢስራኤሌ ናይታ ዬዶንታ ኢጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","2","ሄሳፌ ጉዬ ጎዳይ ሙሴስ፥ «ጊብጼ ካዋኮ ጉዬ ሲማ ባ፤ ኣይስ ጊኮ ታኒ ጊብጼ ኣሳ ዎስታ ቃጻይዳኮኔ ማላታ ኢስታ ጊዶን ዎስታ ኦꬂዳኮ ኢንቴ ኢንቴ ናይታሲኔ ኢንቴ ናይታ ናይታስ ዮታና ማላ፥ ቃሴ ኢንቴካ ታኒ ጎዳ ጊዲዳይሳ ኤራና ማላ፥ ታ ማላታ ኢስታ ጊዶን ኦꬃናስ ኢዛ ዎዚናኔ ዳናታ ዎዚና ሚንꬃ ዎꬃዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","ሂስቲን ሙሴይኔ ኣሮኔይ ካዎዛኮ ጌሊዲ፥ «ጎዳ ኢብራዌታ ጾሲ ኔና፥ ‹ኔ ኔናቴꬃ ታ ሲንꬃን ካዉሾንታ ኢጺዛይ ኣዉዴ ጋካናሴ? ሃኢ ታስ ጎይናና ማላ ታ ኣሳ ዬዳ። ");
INSERT INTO gmve_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ኔኒ ኢስታ ዬዶንታ ኢጺኮ ዎንቶ ታ ኔ ቢታ ቦላ ቦሌ ዬዳና። ");
INSERT INTO gmve_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ቦሌዚ ኦኒካ ቤኦንታ ማላ ቢታ ማይኣና። ኢንቴስ ሻቻፌ ኣቲዳ ጉꬃ ሚሺ፥ ጋዴን ዲጪዛ ሚꬂካ ኡባ ማና። ");
INSERT INTO gmve_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ኔ ኬꬃታን፥ ዳናታ ኬꬃኒኔ ጊብጼ ኣሳ ኡባ ኬꬃን ኩማና፤ ሃይሲ ኔ ኣዋቲ፥ ዎይኮ ኔ ማይዛቲ ሃ ቢታ ቦላ ዶሶፔ ሃኖ ጋካናስ ሙሌካ ቤዪ ኤሮንታ ሚሻ› ጊዴስ» ጊዳ። ሄሳፌ ጉዬ ሙሴይ ካዎዛ ሲንꬃፌ ኬዚ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ካዎዚ ሱንꬂዳ ዳናቲካ ካዎዛ፥ «ሃይሲ ኣዴዚ ኑስ ኣይዴ ጋካናስ ꬉጴ ጊዳኔ? ኢስቲ ጎዳ ባ ጾሳስ ጎይናና ማላ ኔኒ ኣሳ ዬዳ፤ ጊብጼ ዴሬይ ꬋይዳይሳ ኔኒ ሃኢካ ዩሻ ቆፒኪ?» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ሄሳ ጊሻስ ካዎዚ ሙሴኔ ኣሮኔ ጼይጊሲ ጉዬ ዛሪዲ፥ «ቢቴ፤ ጎዳ ኢንቴ ጾሳስ ጎይኒቴ ሺን ቢዛይቲ ኦናንቴ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","ሂስቲን ሙሴይ፥ «ኑኒ ኑ ቄሪ ናይታራ ጪማታራ፥ ኑ ኣቱማ ናይታራ ማጫ ናይታራ፥ ኑ ሜሃራኔ ሚዛ ዉዴታራ ኢሲፌ ባና፤ ኣይስ ጊኮ ኑኒ ቢዛሶን ጎዳስ ባኣሌ ቦንቻናስ ኮሼስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ካዎዚ፥ «ኢንቴ ማጫሳታራኔ ኢንቴ ናይታራ ባና ማላ ታ ኢንቴና ዬዳና፤ ጎዳይ ኢንቴናራ ጊዶ፤ ጊዶ ኣቲን ኢንቴ ኢንቴ ዎዚናን ጌኔ ቆፒዴታ። ");
INSERT INTO gmve_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ሄሳ ጊሻስ ሃኔና፤ ኢንቴ፥ ‹ኑ ቢዲ ጎዳስ ጎይናና ማላ ኑና ዬዳ› ጊሼ ጋምኢዳ ጊሻስ ኣቱማሳይ ጻላ ቢዲ ጎዳስ ጎይኒቴ» ጊዴስ። ሄሳፌ ጉዬ ሙሴኔ ኣሮኔ ካዎዛ ሲንꬃፌ ኬሲ ጎዲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ጎዳይ ሙሴስ፥ «ቦሌይ ጊብጼ ቢታ ቦላ ያና ማላ ሻቻፌ ኣቲዲ ዲጪዛ ኡባ ሊምኢ ሂስቲ ዉርሳና ማላ፥ ኔ ኩሼ ጊብጼ ቢታ ቦላ ፒዲሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","ሙሴይ ባ ኦይኪዳ ጉፋ ጊብጼ ቢታ ቦላ ꬎቁ ሂስቲ ዴንꬂን፥ ሄ ዎዴ ጋላሲኔ ቃማ ጎዳይ ኣርሼይ ሞኪዛ ባጋፌ ዎልቃማ ጫርኮ ቢታ ኡባ ቦላ ዬዲዴስ፤ ጋዴይ ዎንቲሺን ሄ ጫርኮይ ቦሌ ኤኪ ዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ቦሌይ ጊብጼ ቢታ ኩሜꬂ ማይኢዴስ። ሃይሳ ላጌ ቦሌ ቦሻይ ሄ ቢታን ሃይሳፌ ካሴ ሃኒቤና፤ ሃይሳፌ ሲንꬃንካ ኢዛ ማላይ ሃኔና። ");
INSERT INTO gmve_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ቢታይ ካሬጻና ጋካናስ ቦሌዚ ቢታ ኡባ ማይኢዴስ። ሻቻፌ ኣቲዲ ቢታ ቦላ ዲጪዛዛኔ ሚꬃ ቦላን ዲዛ ኣይፌ ኡባ ሊምኢ ሂስቲ ሚዴስ። ሄሳ ጊሻስ ሚꬃ ሃይꬂ ዎይኮ ጋዴን ዲዛ ጪሊላ ሚሺ ዉሪ ጊብጼ ቢታ ኡባሶን ኣይኮይካ ኣቲቤና። ");
INSERT INTO gmve_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ካዎዚካ ሙሴኔ ኣሮኔ ኤሶን ጼይጊሲዲ፥ «ጎዳ ኢንቴ ጾሳኔ ኢንቴና ታኒ ቆሃዲስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ሄኮ ኢንቴ ታና ዉርሴꬃ ማሮ ማሪቴ። ሃ ኢታ ቦሻ ታፔ ዲጋና ማላ ጎዳ ኢንቴ ጾሳ ዎሲቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","ሙሴይ ካዎዛ ኣቻፌ ኬዚዲ ጎዳ ዎሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","ጎዳይካ ኣርሼይ ሞኪዛ ባጋራ ዪዳ ጫርኮዛ ኣርሼይ ዉሊዛ ባጋራ ዪዳ ዎልቃማ ጫርኮን ላሚን ቦሌዛ ቶኪ ኤኪ ኤፊዲ፥ ዞኦ ኣባን ዬጊዴስ። ጊብጼ ቢታ ኩሜꬃን ኢሲ ቦሌይካ ኣቲቤና። ");
INSERT INTO gmve_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ጊዲኮካ ጎዳይ ካዎዛ ዎዚና ሚንꬂዳ ጊሻስ ኢስራኤሌ ናይታ ዬዶንታ ኢጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ሄሳፌ ጉዬ ጎዳይ ሙሴስ፥ «ጊብጼ ቢታን ጊርዲ ጊዳ ꬉማይ ꬉማና ማላ ኔ ኩሼ ፑዴ ሳሎ ዴንꬃ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","ሙሴይ ባ ኩሼ ፑዴ ሳሎ ዴንꬂን ጊብጼ ቢታ ኡባን ሄꬑ ጋላስ ኩሜꬅ ጊርዲ ጊዳ ꬉማይ ꬉሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ሄ ሄꬑ ጋላሳታን ኣሲ ኦኒካ ኢሶይ ኢሳ ቤኦንታ፥ ዎይኮ ሶፔ ካሬ ኬዞንታ ጋምኢዴስ። ጊዶ ኣቲን ኢስራኤሌ ናይቲ ዲዛሶ ኡባን ኢስታስ ፖኦይ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ካዎዚ ሙሴ ጼይጊሲዲ፥ «ቢቴ፤ ቢዲ ጎዳስ ጎይኒቴ፤ ኢንቴ ማጫሳይካ ኢንቴ ናይቲካ ኢንቴናራ ባና ዳንዳዬቴስ። ኢንቴ ሜሄታ ጊዲኮ ሃን ኣጊ ቢቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","ጊዶ ኣቲን ሙሴይ ኢዛስ፥ «ኑኒ ጹጊዲ ያርሺዛ ያርሾ ጎዳ ኑ ጾሳስ ሺሻና ማላ ሜሄ ኢማዳ ዬዳናስ ኮሼስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ኢሲ ጹጉንꬂካ ኣቶንታ ዲሺን ኑ ሜሄይ ዉሪካ ኑናራ ባናስ ቤሴስ። ኑኒ ጌዴ ጋኮንታ ዲሼ ሜሃፔ ኣዋይሳ ኣዋይሳ ያርሻናኮ ሃኢ ኤራናስ ዳንዳዮኮ። ጎዳ ኑ ጾሳስ፥ ያርሾስ ሄ ሜሃፔ ዶሪዲ ኤካናስ ኮሼስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","ጊዶ ኣቲን ጎዳይ ካዎዛ ዎዚና ሚንꬂዳ ጊሻስ ኢዚ ኢስታ ዬዳናስ ኮዪቤና። ");
INSERT INTO gmve_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ሄሳፌ ጉዬ ካዎዚ ሙሴ፥ «ታ ኣቻፌ ኪቻ! ናምኣንꬆ ታ ሲንꬃን ቤታሼ ኔና ኤራ! ናምኣንꬆ ታ ኣይፌሶ ኔ ቤኢዳ ጋላስ ኔ ሃይቃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","ሂስቲን ሙሴይ ኢዛስ፥ «ቱሙካ፤ ኔኒ ጊዳ ማላ ታኒ ኔና ናምኣንꬆ ሙሌካ ቤይኬ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ጎዳይ ሙሴስ፥ «ታኒ ጊብጼ ካዋ ቦላኔ ኢዛ ኣሳ ቦላ ኢሲ ሃራ ቦሻ ዬዳና፤ ሄሳፌ ጉዬ ኢዚ ኢንቴና ሃ ቢታፌ ኬሲ ዬዳና፤ ኬሲዲ ኢዚ ኢንቴና ኢሳዴ ኣሾንታ ኡባ ጎዲ ኬሳና። ");
INSERT INTO gmve_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ኢስራኤሌ ኣሳይ ማጫይ ኣዴይ ባ ሾሮታፔ ቢራፔኔ ዎርቃፌ ኦሴቲዳ ሚሻታ ኦይቺ ኤካና ማላ ኢስታስ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","ጎዳይካ ጊብጼ ኣሳይ ኢስራኤሌ ኣሳስ ኪያቴꬅ ኦꬃና ማላ ኦꬂዴስ። ቃሴ ሙሴይ ባ ባጋራ ጊብጼ ቢታን ካዎይ ሱንꬂዳ ዳናታኒኔ ኣሳን ኬሂ ዳሮ ቦንቼቲዳ ኣሳ ማላ ጼሌቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ሙሴይ ካዎዛስ፥ «ጎዳይ፥ ‹ጊዲ ጊዶꬅ ታኒ ጊብጼ ቢታን ሄሜታና፤ ");
INSERT INTO gmve_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ጊብጼ ቢታን ዲዛ ኣቱማ ናይ፥ ካዎቴꬃ ኣልጋን ኡቲዳ ካዋስ ባይራ ናፔ ዶሚዲ፥ ዎጻን ጋጪዛ ኣይሌይ ባይራ ና ጋካናስካ ባይራ ዬሌቲዳ ሜሄይካ ኣቶንታ ዉሪ ሃይቃና። ");
INSERT INTO gmve_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","ጊብጼ ቢታ ኡባን ሃይሳፌ ካሴ ጊዲን ዎይኮ ሲንꬃፌካ ሃኖንታ ዬሆይ ዬኬታና። ");
INSERT INTO gmve_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ጊዶ ኣቲን ኢስራኤሌ ናይታ ጊዶን ኣሳ ቦላ ዎይኮ ሜሄ ቦላ ኣሲ ኣቶሺን ካናይካ ቦጬና› ጊዴስ። ሄ ዎዴ ጎዳይ ጊብጼሲኔ ኢስራኤሌ ናይታስ ጊዶን ሻኮቴꬅ ሜꬋናይሳ ኢንቴ ኤራና። ");
INSERT INTO gmve_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ኔ ሱንꬂዳ ዳናቲ ዉሪ ታኮ ዪዲ፥ ታ ሲንꬃን ጉፋኒ ዚጊዲ፥ ‹ኬዛዳ ባርኪ! ኔና ካሊዛ ኣሳይ ዉሪካ ቦ!› ጋና። ሄሳፌ ጉዬ ታኒ ባና» ጊዴስ። ሙሴይ ዳሮ ሃንቄቲዲ ኢዛ ሲንꬃፌ ኬዚዲ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","ጎዳይ ሙሴስ፥ «ታ ማላሊሲዛ ሚሽ ጊብጼ ቢታን ጉጃ ጉጃ ኦꬃና ማላ ካዎይ ኢንቴ ዮቲዛይሳ ሲዬና» ጊ ካሴ ዮቲ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","ሙሴይኔ ኣሮኔይ ሃይታ ማላታታ ኡባ ካዎዛ ሲንꬃን ኦꬂኮካ ጎዳይ ካዎዛ ዎዚና ሚንꬂዳ ጊሻስ ኢዚ ኢስራኤሌ ናይታ ባ ዴሬፔ ዬዶንታ ኢጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ጊብጼ ቢታን ጎዳይ ሙሴኔ ኣሮኔ ሂዝጊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«ሃ ኣጊናይ ኢንቴስ ላይꬃስ ኮይሮ ኣጊና ጊዶ፤ ");
INSERT INTO gmve_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ኢስራኤሌ ኣሳ ኡባስ ሃይሳ ሃ ዎጋዛ ዮቲቴ፤ ሃይሲ ኣጊናይ ጌሊዳ ታማንꬃ ጋላስ፥ ኢሲ ኢሲ ኣሲ ባ ሶ ኣሳስ ኢሲ ላቃ ዶሪ ኤኮ። ");
INSERT INTO gmve_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ሄ ኬꬃ ኣሳ ቆዳይ ላቃዛ ኡባ ማናስ ጉጺዛ ጊዲኮ ኢዛዴይ ባስ ማታቲዛ ጉታ ባ ሶ ኣሳ ማላ ቆዲዲ ኢሳዴይ ኢሳዴይ ሚ ዉርሳናይሳ ሻኪ ኤሬቶ። ");
INSERT INTO gmve_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ኢንቴ ዶሪ ኤካና ላቃይ ዬሌቲን ኢሲ ላይꬅ ጊዲዲ ኢዛ ቦላ ኣይኮ ቦሬይ ባይንዳ ኣዴ ላቃ ጊዶ። ኢንቴ ላቃዛ ዶርሳፌ ዎይኮ ዴይሻፌ ኤካናስ ዳንዳዬታ። ");
INSERT INTO gmve_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ሃ ኣጊናይ ታማኔ ኦይዳንꬆ ጋላስ ጊዳና ጋካናስ ኢስታ ናጊቴ፤ ሄ ጋላስ ኣርሼይ ዉሊሺን ኢስራኤሌ ማባራ ኣሳይ ዉሪ ኢስታ ሹካናስ ኮሼስ። ");
INSERT INTO gmve_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ሹኪዲ ሱꬃፌ ኤኪዲ ኢስታ ኣሾዛ ሚዛ ኬꬃስ ቆሲላꬃኔ ቆሬዛ ቦላ ቲዬቶ። ");
INSERT INTO gmve_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ኣሾዛ ሄ ጋላስ ቃማካ ታማን ጺጺዲ፥ ጫሚዛ ቦንጮራኔ ኢርሾይ ባይንዳ ኡኬቲዳ ኡኬꬃራ ሜቶ። ");
INSERT INTO gmve_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","ኣሾዛ ቃዬ ዎይኮ ዶይሲዲ ሞፒቴ፤ ሁኤዛ፤ ጌዳታ፤ ቃንꬃ ኣሾዛካ ኡባ ጺጺዲ ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ሄ ኣሾዛፔ ጋዴይ ዎንታና ጋካናስ ኣይኮካ ኣሾፍቴ። ዎንታና ጋካናስ ኣቲዳዚ ዲኮ ታማን ጹጋና ኮሼስ። ");
INSERT INTO gmve_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","ሚሽ፥ ኦጌስ ጊዲዛ ማይኦ ማይኢዲ፥ ኢንቴ ጫማ ቶሆን ኣꬂዲ ኢንቴ ጉፌ ኢንቴ ኩሼን ኦይኪዲ ኤሶን ሚቴ፤ ሃይሲ ታና ጎዳ ኢንቴ ቦንቺዛ ፓዚጋ ያርሾ። ");
INSERT INTO gmve_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","«ታኒ ሄ ጋላስ ቃማራ ጊብጼ ቢታራ ሄሜታሼ ባይራ ዬሌቲዳ፥ ኣሴካ ሜሄካ ኡባ ዎꬋና። ጊብጼ ኤቃታ ኡባ ቦላካ ታኒ ፒርዳና፤ ታኒ ጎዳ ጊዲኪና? ");
INSERT INTO gmve_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ሄ ሱꬃይ ኢንቴ ዲዛ ኬꬃታ ኤሪሲዛ ማላታ ጊዳና። ታኒ ሄ ሱꬃ ቤኢዛ ዎዴ ኢንቴና ኣጋ ኣꬋና፤ ታኒ ጊብጼ ቢታ ቦሻን ሾጪዛ ዎዴ ኢንቴ ቦላ ኣይኮ ቦሻይካ ጋኬና። ");
INSERT INTO gmve_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","«ሄ ጋላሳይ ታኒ ጎዳይ ኢንቴስ ኦꬂዳይሳ ቆፒ ቆፒ ቦንቺዛ ጋላስ ጊዶ፤ ኢንቴ ዜሬꬂ ዉሪ ጎዳ ባኣሌ ቦንቾ፤ ሃይሳ ኢንቴስ ዎጋ ሂስቲዲ ሜርናስ ቦንቺቴ። ");
INSERT INTO gmve_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","«ላፑን ጋላስ ጋካናስ ኢርሾይ ጌሎንታ ኡኬꬅ ሚቴ፤ ኮይሮ ጋላስ ኢንቴ ሶፔ ኢርሾ ዲጊቴ። ሄ ኮይሮ ጋላሳፌ ዶሚዲ ላፑንꬃ ጋላስ ጋካናስ፥ ኢርሾራ ዲዛ ኡኬꬅ ሚዛ ኣሲ ኦኒካ ኢስራኤሌ ኣሳ ጊዶፌ ሻኬቲ ꬋዮ። ");
INSERT INTO gmve_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ኮይሮ ጋላስ ጌሻ ዱላታ ሺቂቴ፤ ሃራ ጌሻ ዱላታ ቃሴ ላፑንꬃ ጋላስ ሺቂቴ፤ ኣሳይ ዉሪ ማናስ ቁማ ካꬆፌ ኣቲን ሄ ጋላሳታ ኡባን ኣይኮካ ኦꬆፍቴ፤ ኢንቴ ኦꬃና ሚሺ ሄሳ ጻላ። ");
INSERT INTO gmve_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","«ታኒ ኢንቴና ኢስራኤሌ ናይታ ጊብጼ ቢታፌ ኬሲዳይ ሄ ጋላስ ጊዲዳ ጊሻስ ኡኬꬃ ባኣሌ ቦንቺቴ። ሄ ጋላሳ ባኣሌዛ ና ናስ ኣቶንታ ዎጋ ሂስቲ ቦንቺቴ። ");
INSERT INTO gmve_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ኮይሮ ኣጊናን ሄ ኣጊናስ ታማኔ ኦይዳንꬃ ጋላሳ ኦማርሳፌ ዶሚዲ ናምኡ ታማኔ ኢሲንꬃ ጋላሳ ኦማርሳ ጋካናስ ኢርሾይ ጌሎንታ ኡኬꬅ ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ላፑን ጋላስ ጋካናስ ኢርሾይ ኢንቴ ሶን ቤቶፎ፤ ኢርሾይ ጌሊዳ ካꬅ ሚዛ ኣሲ ቤቴ ኣሲ ጊዲን ዎይኮ ሄ ዴሬ ኣስ ኦናካ ጊዲን ሄሳዴይ ኢስራኤሌ ማባራ ጊዶፌ ꬋዮ። ");
INSERT INTO gmve_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ኢርሾይ ጌሊዳዝ ኣይኮካ ሞፒቴ፤ ኢንቴ ዲዛሶን ኣዋንካ ኢርሾይ ጌሎንታ ኡኬꬅ ማናስ ቤሴስ።» ");
INSERT INTO gmve_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ሄሳፌ ጉዬ ሙሴይ ኢስራኤሌ ጪማታ ኡባ ጼይጊሲዲ፥ «ኢንቴ ቢዲ ኢንቴ ሶ ኣሳስ ፓዚጋ ያርሾስ ላቃ ኤኪ ሹኪቴ። ");
INSERT INTO gmve_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ሂሶጴ ጌቴቲዛ ማታ ሃይꬃፌ ዳንኪ ኤኪዲ ኬሬን ዲዛ ሱꬃን ጌልꬂ ኬሲዲ፥ ሄ ሱꬃ ናምኡ ቆሲላꬃታኒኔ ቆሬታ ቦላ ቲዪቴ፤ ኢንቴፌ ኢሲ ኣሲካ ጋዴይ ዎንታና ጋካናስ ባ ኬꬃፌ ካሬ ኬዞፖ። ");
INSERT INTO gmve_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","ጎዳይ ጊብጼ ባይራ ናይታ ዎꬋናስ ሄ ቢታራ ሄሜቲዛ ዎዴ ሱꬅ ኬꬃ ቆሲላꬃታኒኔ ቆሬታ ቦላ ቤኢዲ ካሬራ ኣꬊ ባና፤ ዎꬊዛይሲ ኢንቴ ሶ ጌሊዲ ኢንቴና ዎꬎንታ ማላ ኢዛ ጎዳይ ዲጋና። ");
INSERT INTO gmve_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","«ኢንቴ ሃይሳ ኣዛዞዛ ኢንቴሲኔ ኢንቴ ዜሬꬃስ ሜርናስ ዎጋ ሂስቲዲ ኣዛዜቲቴ። ");
INSERT INTO gmve_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","ጎዳይ ካሴ ኢማና ጊዲ ጫቂዳ ቃላ ማላ ኢዚ ኢሚዛ ቢታ ኢንቴ ጌሊዛ ዎዴ ሃ ዎጋ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ኢንቴ ናይቲ ኢንቴና፥ ‹ሃይሳ ሃ ዎጋዛስ ቢርሼꬂ ኣዜ?› ጊ ኦይቺኮ፥ ");
INSERT INTO gmve_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ኢንቴ ኢስታስ፥ ‹ሃይሲ ጎዳ ቦንቻናስ ያርሺዛ ፓዚጋ ያርሾ፤ ኣይስ ጊኮ ጎዳይ ጊብጼ ቢታን ኢስራኤሌ ኣሳ ኬꬅ ኣጊ ኣꬊዲ ጊብጼ ኣሳ ዎꬊዲ ኑና ኣሺዳ ጊሻሳ› ጊቴ» ጊዴስ። ሄሳፌ ጉዬ ኣሳይ ቢታ ቦላ ጉፋኒ ጎይኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","ኢስራኤሌ ኣሳይ ቢዲ ጎዳይ ሙሴኔ ኣሮኔ ኣዛዚዳ ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ጊዲ ጊዶꬃን ጎዳይ ጊብጼን ባይራ ዬሌቲዳ ኡባ ካዎቴꬃ ኣልጋን ኡቲዛ ካዎ ባይራ ናፔ ዶሚዲ፥ ቃሾ ኬꬃን ዲዛ ዲኤቲዳ ኣሳ ባይራ ና ጋካናስ፥ ቃሴ ባይራ ዬሌቲዳ ሜሄ ኡባ ዲፒ ሂስቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ካዎይ፥ ኢዚ ሱንꬂዳ ዳናቲኔ ጊብጼ ቢታ ኣሳይ ዉሪ ቃማራ ቤጊዴስ። ጊብጼ ቢታን ኣሲ ሃይቆንታ ኬꬂ ሙሌካ ባይንዳ ጊሻስ ኣሳይ ቃላ ꬎቁ ሂስቲዲ ዳሮ ዋሲ ዬኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ሄ ጋላሳ ኦማርስ ካዎዚ ሙሴኔ ኣሮኔ ጼይጊሲዲ፥ «ዴንዲቴ! ኢንቴካ ኢንቴ ኣሳይካ ታ ኣሳ ጊዶፌ ኬዚቴ! ቢዲ ኢንቴ ኦይቺዳ ማላካ ጎዳስ ጎይኒቴ! ");
INSERT INTO gmve_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","ኢንቴ ጊዳ ማላካ ኢንቴ ሜሄ፤ ኢንቴ ዴይሺኔ ዶርስ ኡባ ኤኪዲ ቢቴ! ቃሴ ታናካ ኣንጂቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ኢስራኤሌ ኣሳይ ባ ቢታፌ ኤሶን ኬዛና ማላ ጊብጼ ኣሳይ ዲርባሲዴስ። ኣይስ ጊኮ ኢስቲ፥ «ኬዞንታ ኢጺኮ ኑኒ ዉሪካ ዉራና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ሄሳ ጊሻስ ኢስራኤሌ ኣሳይ ኢርሾይ ጌሎንታ ሙኑቃ ኬሬን ኩንꬂ ማይኦን ጻጺዲ ሃሼን ቶኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ኢስራኤሌ ኣሳይ ሙሴይ ኢስታ ኣዛዚዳ ማላ፥ ጊብጼ ኣሳ ቢራ፥ ዎርቃኔ ማይኦ፥ «ኢሚቴ» ጊ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ጎዳይ ጊብጼ ኣሳ ሲንꬃን ኢስራኤሌ ኣሳይ ሳቤታና ማላ ኦꬂዳ ጊሻስ ጊብጼ ኣሳይ ኢስታ ኦይቺዳይሳ ኡባ ኢሚዳ። ሄሳꬆ ሂስቲዲ ኢስታ ጊብጼ ኣሳታ ኣቆ ቡሪ ኤኪ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ኢስራኤሌ ኣሳይ ኤራሚሴ ጌቴቲዛ ካታማፔ ዴንዲዲ ሱኮቴ ጌቴቲዛሶ ጋካናስ ቢዴስ። ኣሳይ ናይታኔ ማጫሳ ጉጆንታ ቆዲን ቶሆን ሄሜቲዛ ኣቱማ ኣሳይ 600,000 ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ቃሴ ኢስታራ ዳሮ ሃራ ዴሬ ኣሳይ፥ ኬሂ ዳሮ ሜሄ፥ ዶርሲኔ ዴይሽ ኤኪ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ጊብጼፔ ኢስቲ ኤኪ ኬዚዳ ኢርሾይ ጌሎንታ ሙኑቃፔ ኡኬꬅ ኡኪዳ፤ ኣይስ ጊኮ ኢስታ ጊብጼፔ ኤሶን ኬሲዳ ጊሻስ ባስ ሺንቄ ካꬃናሲኔ ሙኑቃይ ዴንዲን ኡካና ዎዴ ኢስታ ጋꬂቤና። ");
INSERT INTO gmve_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ኢስራኤሌ ኣሳይ ጊብጼ ቢታን ዴዪዳ ላይꬃይ ዉሪ ኦይዱ ጼታኔ ሄꬑ ታማ። ");
INSERT INTO gmve_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ሄ ኦይዱ ጼታኔ ሄꬑ ታሙ ላይꬃይ ዉሪዛ ሄ ዉርሴꬃ ጋላሳን ጎዳ ኣሳይ ዉሪ ጊብጼ ቢታፌ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ጊብጼ ቢታፌ ኦማርሳ ዎዴ ጎዳይ ባ ኣሳ ኬሲሼ ናጊዳ ጊሻስ ሄ ቃማይ ና ና ጋካናስ፥ ኢስራኤሌ ኣሳይ ዉሪ ቤጊ ናጊዲ ኣቂዛ ጎዳስ ዱማቲዳ ቃማ። ");
INSERT INTO gmve_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","ጎዳይ ሙሴኔ ኣሮኔ፥ «ፓዚጋ ቦንቺዛ ዎጋይ ሃይሳ፤ ሃራ ዴሬ ኣሲ ኢዛፔ ኦኒካ ሙሌራ ሞፖ። ");
INSERT INTO gmve_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ኢንቴ ሚሻን ሻሚዳ ኣይሌይ ኦኒካ ኢንቴ ኢዛ ቃጻሪዳፔ ጉዬ ኢዛፔ ማናስ ኮሼስ። ");
INSERT INTO gmve_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ጊዶ ኣቲን ጉꬃ ዎዴስ ኢንቴናራ ኢማꬃቴꬃን ጋምኢዛይኔ ኡኔ ኦꬂዛ ሃራ ዴሬ ኣሲ ኢዛፔ ሞፖ። ");
INSERT INTO gmve_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","«ሃ ፓዚጋ ያርሾዛ ኢንቴ ኢሲ ኬꬃን ሚቴ፤ ኢንቴ ሄ ኣሾዛፔ ኣይኮካ ካሬ ኬሶፍቴ። ሜቄꬃታፔ ኢሲኖካ ሜንꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ኢስራኤሌ ማባራይ ዉሪ ፓዚጋ ያርሾ ቦንቻናስ ኮሼስ። ");
INSERT INTO gmve_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","«ቤቴ ዪዲ ኢንቴ ጊዶን ዲዛ ኣሲ ጎዳ ፓዚጋ ያርሾ ቦንቻናስ ኮይኮ ባ ሶን ኣዴ ጊዲዳ ኣሳ ኡባ ቃጻሮ። ሄሳፌ ጉዬ ኢዚ ሄ ቢታን ዬሌቲዳ ኣሳ ማላ ሺቂዲ ፓዚጋ ያርሾ ቦንቻናስ ቤሴስ። ጊዶ ኣቲን ቃጻሬቶንታ ኣሲ ሙሌካ ኢዛፔ ሞፖ። ");
INSERT INTO gmve_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ኢንቴ ቢታን ዬሌቲዳይሳስካ ጊዲን ኢንቴ ጊዶን ቤቴ ጊዲዲ ዲዛይሳስካ ጊዲን ሃይሲ ዎጋይ ኡባስ ኢሲኖ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ሂስቲን ኢስራኤሌ ኣሳይ ዉሪ ጎዳይ ሙሴኔ ኣሮኔ ኣዛዚዳ ማላካ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ሄ ጋላሳንካ ጎዳይ ኢስራኤሌ ናይታ ኢስታ ጩጋን ጩጋን ጊብጼ ቢታፌ ኬሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","ጎዳይ ሙሴ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«ኣዴ ጊዲ ኮይሮ ዬሌቲዳ ኡባ ታስ ዱማሳ። ኢስራኤሌ ኣሳ ጊዶን ኮይሮ ዬሌቲዳ ባይራይ ዉሪ ሜሄ ጊዲን ኣስ ጊዲን ዉሪካ ታሳ።» ");
INSERT INTO gmve_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","ሄሳፌ ጉዬ ሙሴይ ኣሳ፥ «ጊብጼፔ፥ ኣይሌቴꬃ ቢታፌ ኢንቴ ኬዚዳ ጋላሳያ ሃኖ ጋላሳዮ ጊዲዳይሳ ዩሺ ቆፒቴ፤ ኣይስ ጊኮ ጎዳይ ባ ዎልቃማ ቄሴን ኢንቴና ኬሲዴስ፤ ሄሳ ጊሻስ ኢርሾይ ጌሊዳ ካꬅ ኣይኮካ ሞፒቴ። ");
INSERT INTO gmve_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ኢንቴ ሃ ጋላሳይን ኣቢቤ ጌቴቲዛ ኣጊናን ኬዚዴታ። ");
INSERT INTO gmve_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","ጎዳይ ካናኔታ፥ ሂቴታ፥ ኣሞሬታ፥ ሂዌታኔ ያቡሴታ ጌቴቲዛ ዴሬታ ቢታ ኢንቴና ጋꬂዛ ዎዴ ኢንቴ ሃ ቦንቾ ጋላሳ ሃ ኣጊናን ቦንቼታ። ሄ ቢታይ ጎዳይ ኢንቴስ ኢማና ማላ ካሴ ኢንቴ ኣዋታስ ጫቂ ዎꬂዳ ቢታ። ሄ ቢታይ ማꬂኔ ኤሲ ጎጊዛ ቢታ። ");
INSERT INTO gmve_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ኢንቴ ላፑን ጋላስ ኢርሾይ ጌሎንታ ኡኬꬅ ማና፤ ላፑንꬃ ጋላስ ጎዳስ ባኣሌ ሂስቲ ቦንቼታ። ");
INSERT INTO gmve_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ሄ ላፑን ጋላሳታን ኢርሾይ ጌሎንታ ኡኬꬅ ኢንቴ ማና፤ ኢንቴ ጊዶን ኢርሾራ ዲዛይ ኣይኮይካ ቤቶፎ፤ ኔ ቢታ ዛዋን ኣዋንካ ኢርሾይ ሙሌካ ዶፖ። ");
INSERT INTO gmve_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","«ሄ ጋላስ ኔኒ ኔ ናይታስ፥ ‹ታኒ ሃይሳ ኦꬂዛይ ታኒ ጊብጼፔ ኬዚዛ ዎዴ ጎዳይ ታስ ኦꬂዳይሳ ዛሪ ቆፓናሳ› ጋ ዮታ። ");
INSERT INTO gmve_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","ጎዳይ ኢንቴና ባ ዎልቃማ ኩሼን ጊብጼፔ ኬሲዳ ጊሻስ፥ ጎዳ ዎጋይ ኢንቴ ዶናፔ ሻኬቶንታ ማላ፥ ሃይሲ ባኣሌዚ ኢንቴ ኩሼ ቦላ ቃሼቲዳኔ ኢንቴ ሊጴን ዎꬂን ቆፍሲዛ ሚሻ ማላ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ሄሳ ጊሻስ ኢንቴ ሃ ዎጋ ዎꬂዲ ላይꬃን ላይꬃን ሃ ጋላሳን ቦንቺቴ። ");
INSERT INTO gmve_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«ጎዳይ ኢንቴሲኔ ካሴ ኢንቴ ኣዋታስ ኢማናስ ጫቂዳ ማላ፥ ኢዚ ኢንቴና ካናኔታ ቢታ ጌልꬂዲ፥ ሄ ቢታ ኢንቴስ ኢሚዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ኣቱማ ጊዲ ዬሌቲዳ ባይራ ኡባ ጎዳስ ዱማሲቴ፤ ኔ ሜሄ ጋርሳን ኣዴ ጊዲዲ ባይራ ዬሌቲዳይ ዉሪ ጎዳሳ። ");
INSERT INTO gmve_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ባይራ ዬሌቲዛ ሃሬ ማር ኡባ ላቃራ ላማዳ ዎዛ፤ ላማዳ ዎዞንታ ኢጺኮ ኢዛ ሞርጌን ሾጫ ዎꬋ። ኔ ናይታ ጊዶን ኣቱማ ጊዲ ባይራ ዬሌቲዳይታ ኡባ ዎዛ። ");
INSERT INTO gmve_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","ዎዴፔ ኔ ናይ ኔና፥ ‹ሃይሲ ኣዛ ዎጋ?› ጊ ኦይቺኮ፥ ኔኒ ኢዛስ፥ ‹ጎዳይ ኑና ባ ዎልቃማ ቄሴን ኣይሌቴꬃ ቢታ ጊብጼፔ ኬሲዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ጊብጼ ካዎይ ባ ዎዚና ሚንꬂዲ ኑና ዬዶንታ ኢጺን ጎዳይ ጊብጼ ቢታን ዲዛ ባይራ ኡባ፥ ኣሳፔ ዶሚዲ ሜሄ ባይራ ጋካናስ ዎꬊዴስ። ታኒ ኣዪ ኡሎፔ ኮይሮ ዬሌቲዳ ኣዴ ሜሄ ኡባ ጎዳስ ያርሺዛይሲኔ ባይራ ጊዲዳ ኣቱማ ናይታ ኡባ ዎዚዛይሲ ሄሳሳ› ጋ። ");
INSERT INTO gmve_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ጎዳይ ኑና ባ ዎልቃማ ቄሴን ጊብጼፔ ኬሲዳይሳስ፥ ሃይሲ ኢንቴስ ኩሼን ቃቺዳ ማላታኔ ሊጴ ቦላ ዎꬂዳ ማላታ ማላ ጊዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ካዎይ ኣሳ ዬዲዳ ዎዴ ጾሲ ኢስታ ፊሊስጼሜ ቢታራ ካንꬂሲዛ ኦጌይ ማታ ሺን ሄ ኦጌዛራ ኤፊቤና፤ ጋሶይካ ጾሲ፥ «ኣሳይ ኦላ ቤይኮ ባ ቆፋ ላሚዲ ጉዬ ጊብጼ ሲማናኮ» ጊዲ ቆፒዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ሄሳ ጊሻስ ጾሲ ኣሳ ባዞ ኦጌራ ዩሺዲ፥ ዞኦ ኣባኮ ካሌꬂዴስ። ኢስራኤሌ ኣሳይ ጊብጼ ቢታፌ ኦላስ ጊጌቲዳ ኣሳ ማላ ጊጌቲዲ ጊብጼፔ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","ዮሴፌይ ኢስራኤሌ ኣሳ፥ «ጾሲ ቱማፔ ኢንቴና ማዳና ያና፤ ሄ ዎዴ ኢንቴ ታ ሜቄꬃ ሃይሳፌ ኢንቴናራ ኤኪ ቢቴ» ጊዲ ጫቄꬂ ዎꬂዳ ጊሻስ ሙሴይ ኢዛ ሜቄꬃ ባናራ ኤኪ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ኢስቲ ሱኮቴፔ ዴንዲዲ ባዞ ዶናን ዲዛ ኤታሜ ጌቴቲዛሶን ኡቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","ኢስቲ ጋላሲካ ቃማካ ሄሜታና ማላ ጎዳይ ኢስታ ኦጌ ቤሳናስ ቱሳ ማላ ኤቂዳ ሻራን ጋላስ፥ ቱሳ ማላ ኤቂዳ ታማን ኦማርስ ኢስታ ካሌꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ጋላስ ቱሳ ማላ ኤቂዳ ሻራይ፥ ኦማርስ ቱሳ ማላ ኤቂዳ ታማይ ኣሳ ሲንꬃፌ ኡባ ዎዴ ሻኬቲቤና። ");
INSERT INTO gmve_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","2","ሄሳፌ ጉዬ ጎዳይ ሙሴስ፥ «ኢስቲ ጉዬ ሲሚዲ ሚጊዶሌፔኔ ኣባፌ ጊዶን፥ ፒሃሂሮቴ ኣቻን ኡታና ማላ ዴራስ ዮታ፤ ኢስቲ ኣባ ኣቻን ባኣሊ-ጻፎኔ ሲንꬃን ባዛን ኡቴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ጊብጼ ካዎይ፥ ‹ባዞን ኦጌይ ጎርዴቲ ꬋዪን ኢስራኤሌ ኣሳይ ቢዛሶ ꬋይዲ ጮ ቶይላቴስ› ጊዲ ቆፓና። ");
INSERT INTO gmve_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ታኒ ካዎዛ ዎዚና ሚንꬃና፤ ኢዚ ኢስታ ጎዳና፤ ታኒ ካዎዛ ባጋራኔ ኢዛ ኦላንቻታ ኡባ ባጋራ ቦንቼታና፤ ጊብጼ ኣሳይካ ታኒ ጎዳ ጊዲዳይሳ ኤራና» ጊዴስ። ሂስቲን ኢስራኤሌ ኣሳይ ኢዚ ዮቲዳ ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ኣሳይ ኬሲ ኤኪ ቢዳይሳ ጊብጼ ካዎስ ዮቲን፥ ኢዚካ ዳናታ ኢስራኤሌ ናይታ ጊሻስ ቆፒዳ ባ ቆፋ ላሚዲ፥ «ኑኒ ሃይሳꬆ ኣዛስ ኦꬂዶኒ? ኑኒ ኢስራኤሌ ናይታ ዬዲዲ ኢስቲ ኑስ ኦꬂዛ ዎልቃፌ ሜላ ኣቲዶስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ሄሳ ጊሻስ ካዎዚ ባ ፓራ-ጋሬዛ ኮሪዲ ኦላንቻታ ባናራ ኤኪ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ኢዚ ኡባፌ ኣꬊዛ 600 ፓራ-ጋሬታ፥ ቃሴ ጊብጼ ቢታን ዲዛ ፓራ-ጋሬታ ኡባ ቦላካ ኦላ ሃላቃታ ዎꬂ ኤኪ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","ጎዳይ ጊብጼ ቢታ ካዎ ዎዚና ሚንꬂን ሚኖቴꬃራ ቡሮ ቡሳ ቦላ ዲዛ ኢስራኤሌ ኣሳ ጎዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ጊብጼ ኣሳይ ካዎ ፓራ-ጋሬቲ ዉሪ ፓራ ኣሳቲኔ ኦላንቻቲ ኢስራኤሌ ናይታ ካሊ ጎዲዳ። ኣባ ዶናን ባኣሊ-ጻፎኔ ሲንꬃን ዲዛ ፒሃሂሮቴ ኣቻን ኢስቲ ኡቲ ዲሺን ዴሚዳ። ");
INSERT INTO gmve_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ካዎዚ ማቲግዲን ኢስራኤሌ ኣሳይ ጉዬ ጼሊዛ ዎዴ፥ ጊብጼ ኣሳይ ኢስታ ጉዬራ ካሊ ዪዛይሳ ቤኢዲኔ ዳሮፔ ባቢዲ ጎዳስ ዋሲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ኢስቲ ሙሴስ፥ «ኔኒ ኑና ጊብጼ ቢታን ኑስ ዱፎይ ꬋዪን ባዞን ሃይቃና ማላ ኬሳዲ? ኑና ጊብጼፔ ኣዛስ ኤሃዲ? ");
INSERT INTO gmve_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ኑኒ ጊብጼን ዲሼ፥ ‹ኑና ኣጋ፤ ኑኒ ጊብጼ ኣሳስ ሃሬታና› ጊዲ ኔስ ዮቲቤኮኒ? ባዞን ሃይቃናፔ ኢስታስ ሃሬቲዛይሲ ኑስ ሎኦኮሺን» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","ሙሴይ ኣሳ፥ «ባቦፍቴ፤ ሚኒ ኤቂቴ፤ ጎዳይ ሃች ኢንቴና ኣሻናይሳ ኢንቴ ቤያና። ሃች ኢንቴ ቤኢዛ ጊብጼ ኣሳ ናምኣንꬆ ሙሌካ ቤኤኬታ። ");
INSERT INTO gmve_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ኢንቴ ጊሻስ ጎዳይ ኦሌታና፤ ኢንቴፌ ኮዬቲዛይ ጮኡ ጉስ ጻላላ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ጎዳይ ሙሴ፥ «ኔኒ ታኮ ኣይስ ዋሳይ? ኢስራኤሌ ኣሳይ ጌዴ ሲንꬄ ባና ማላ ዮታ። ");
INSERT INTO gmve_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ኢስራኤሌ ኣሳይ ሜላ ቢታ ቦላራ ኣባ ፒኒ ባና ማላ ኔ ጉፌ ዴንꬃዳኔ ኔ ኩሼ ኣባ ቦላ ፒዲሳዳ ሃꬃ ናምኡ ኬሳ ሻካ። ");
INSERT INTO gmve_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ታኒ ጊብጼ ኣሳ ዎዚና ሚንꬂኮ ኢስቲ ኢንቴ ጉዬ ካሊዲ ኣባን ጌላና። ታኒ ካዎዛኔ ኢዛ ኦላንቻታ ኡባ ቦላ፥ ኢዛ ፓራ-ጋሬታኔ ቶጋ ኣሳታ ቦላ ታስ ቦንቾ ዴማና። ");
INSERT INTO gmve_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ታኒ ካዎዛ ባጋራ ኢዛ ፓራ-ጋሬታ ባጋራኔ ኢዛ ቶጋ ኣሳታ ባጋራ ታስ ቦንቾ ዴሚዳ ዎዴ ታኒ ጎዳ ጊዲዳይሳ ጊብጼ ኣሳይ ኤራና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ሄሳፌ ጉዬ ካሴ ኢስራኤሌ ኣሳ ሲንꬃራ ቢዛ ጾሳ ኪታንቻይ ኣሳፔ ጉዬ ኣꬊ ኤቂዴስ። ቱሳ ማላ ሻራይካ ኢስታ ሲንꬃፌ ጉዬ ባጋ ዩዪዲ፥ ");
INSERT INTO gmve_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ጊብጼ ኣሳሲኔ ኢስራኤሌ ናይታስ ጊዶን ኣꬊ ኤቂዴስ። ሄ ሻራይ ኦማርስ ኢሲ ባጋራ ꬉሚሲዲ ሃንኮ ባጋራ ፖኢሲዴስ፤ ሂስቲን ኦማርስ ኩሜꬅ ኢሶይ ኢሳኮ ሺቃና ዳንዳይቤቴና። ");
INSERT INTO gmve_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","ሄሳፌ ጉዬ ሙሴይ ኣባ ቦላን ባ ኩሼ ፒዲሲዴስ፤ ጎዳይ ሄ ጋላሳ ኦማርስ ኩሜꬅ ኣርሼይ ሞኪዛ ባጋፌ ዎልቃማ ጫርኮ ዬዲዲ፥ ኣባ ሻኪ ሻኪዲ ሜላ ቢታ ኬሲዴስ። ሃꬃይካ ናምኣን ሻኬቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ኢስራኤሌ ኣሳይ ኣባ ጊዶን ሜላ ቢታራ ሄሜቲዲ ሃꬂ ኢስታስ ኡሻቻራኔ ሃዲርሳራ ጎዳ ማላ ኤቂን ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ጊብጼ ኣሳይ ካዎ ፓራቲ ዉሪ፥ ፓራ-ጋሬቲኔ ቶጋ ኣሳይ ኢስታ ጎዲ ኤኪዲ ኣባ ጊዶ ጌሊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ቡሮ ባዞይ ዞኣናፔ ካሴቲዲ ጎዳይ ታማኒኔ ቱሳ ማላ ሻራን ጊዲዲ፥ ጊብጼ ኦላንቻታ ጼሊዳ ዎዴ ኢስታ ዎዚናይ ꬋይዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ጎዳይ ኢስታ ፓራ-ጋሬታ ቶሆ ቃቺ ኦይኪዳ ጊሻስ ላጎይ ባና ዋዪሲን ጊብጼ ኣሳይ፥ «ጎዳይ ኢስታ ማዲዲ ጊብጼ ኦሊዛ ጊሻስ ኣኔ ኑኒ ኢስራኤሌ ኣሳፔ ባቃቶስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ጎዳይ ሙሴ፥ «ሃꬃይ ጊብጼ ኣሳ ቦላ፥ ኢስታ ፓራ-ጋሬታ ቦላኔ ቶጋ ኣሳታ ቦላ ጉዬ ጎጋና ማላ ኔ ኩሼ ኣባ ቦላ ፒዲሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","ሙሴይ ባ ኩሼ ኣባ ቦላ ፒዲሲዴስ፤ ጋዴይ ዎንቲሺን ኣባይ ካሴ ባ ዲዛ ሶሆ ጉዬ ሲሚዴስ፤ ጊብጼ ኣሳይ ጌዴ ኢዛ ጊዶ ባቃቲሺን ጎዳይ ጊብጼ ኣሳ ሄን ኣባ ጊዶን ዬጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ሃꬃይ ጉዬ ሲሚዲ ፓራ-ጋሬታ ቶጋ ኣሳታኔ ኢስራኤሌ ናይታ ካሊዲ ኣባን ጌሊዳ ካዎ ኦላንቻታ ሙሌ ሚቲ ኣጊዴስ፤ ኢስታፌ ኢሳዴይካ ኣቲቤና። ");
INSERT INTO gmve_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ጊዶ ኣቲን ኢስራኤሌ ኣሳይ ሃꬂ ኢስታስ ኡሻቻራኔ ሃዲርሳራ ጎዳ ማላ ኤቂ ዲሺን ኣባ ጊዶራ ሜላ ቢታ ቦላራ ሄሜቲ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ጎዳይ ሄ ጋላስ ኢስራኤሌ ኣሳ ጊብጼ ኣሳ ኩሼፔ ሃይሳꬆ ኣሺዴስ። ቃሴ ኢስራኤሌ ኣሳይ ጊብጼ ኣሳ ኣሃ ኣባ ዶናን ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ጎዳይ ጊብጼ ኣሳ ቦላ ቤሲዳ ጊታ ዎልቃ ቤኢዲ ኢስራኤሌ ኣሳይ ጎዳስ ባቢዴሲኔ ኢዛኔ ኢዛ ኣይሌ ሙሴካ ኣማኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ሄ ዎዴ ሙሴይኔ ኢስራኤሌ ኣሳይ ሃይሳ ዬꬃዛ ጎዳስ ዬጺዴስ፤ «ቦንቾን ኢዚ ኬሂ ꬎቁ ꬎቁ ጊዳ ጊሻስ፥ ታኒ ጎዳስ ዬꬃ ዬጻና። ፓራኔ ፓራ ቶጊዳ ኣሳ ኣባ ጊዶን ዬጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","ጎዳይ ታስ ዎልቃኔ ዬꬃ፤ ኢዚ ታና ኣሺዴስ። ኢዚ ታ ጾሳ፤ ታኒ ኢዛ ሳባና። ኢዚ ታ ኣዋ ጾሳ፤ ታኒ ኢዛ ꬎቁ ꬎቁ ሂስታና። ");
INSERT INTO gmve_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","ጎዳይ ኦላንቻ፤ ኢዛ ሱንꬂካ ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ጊብጼ ካዎ ፓራ-ጋሬታኔ ኢዛ ኦላንቻታ ኣባን ዉርሲዴስ፤ ኡባፌ ኣꬊ ዶሬቲዳ ጊብጼ ካዎ ሃላቃቲ፥ ዞኦ ኣባን ሚቴቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","ጪማ ሃꬂ ኢስታ ካሚዴስ፤ ኢስቲ ሹቻꬆ ጪማን ሚቴቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","«ኣቤት ጎዳዉ! ኔ ኡሻቻ ኩሼይ ዎልቃን ጎቢዴስ፤ ጎዳዉ ኔ ዎልቃማ ኡሻቻ ኩሼይ ሞርኬ ሜንꬄሬꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","ኔ ጊታ ዎልቃን ኔናራ ኤቄቲዳይታ ኩንዲሳዳሳ። ኤጺዛ ኔ ሃንቆ ኔ ዬዳዳሳ፥ ኢዚካ ኢስታ ጋፌ ማላ ሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","ኔ ፔኖይ ሃꬃ ፑዴ ኤሲ ዶሪዴስ። ጎጊዛ ሃꬂካ ጎዳ ማላ ሚኒ ኤቂዴስ፤ ጪማ ጊዶን ዲዛ ሃꬂ ኣባ ጊዶን ኢርኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","«ሞርኬይ ጬቄቲሼ፥ ‹ታኒ ኢስታ ዬዴꬃ ኦይካና። ታኒ ኢስታ ሃሮ ሻካዳ፥ ታ ኮዪዳይሳ ኡባ ኤካና። ታኒ ታ ጊꬃ ማሻ ሾዳዳ፥ ኢስታ ꬋይሳና› ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ጊዶ ኣቲን ኔኒ ኢስታ ኔ ፔኖን ፑኒን፥ ኣባይ ኢስታ ካሚዴስ። ኢስቲ ዎልቃማ ሃꬃን ቢራታይ ሚቴቲዛ ማላ ሚቴቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","«ኣቤት ጎዳዉ! ኤቃ ጾሳታ ጊዶን ኔ ማላይ ኦኔ? ጌሻቴꬃን ቦንቼቲዛይ፥ ቦንቾን ባቢሲዛይኔ፥ ማላሊሲዛ ሚሽ ኦꬂዛይ ኔ ማላይ ኦኔ? ");
INSERT INTO gmve_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","ኔኒ ኔ ኡሻቻ ኩሼ ፒዲሳዳሳ፥ ቢታይካ ኢስታ ሚቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","«ኔ ዎዚዳ ኔ ኣሳ ዉሮንታ ኔ ሲቆን ካሌꬃዳሳ። ኔኒ ኔ ዎልቃን ኢስታ ኔ ኣቂዛ ጌሻ ሶ ጌልꬃዳሳ። ");
INSERT INTO gmve_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ዴሬ ኣሳይ ሄሳ ሲዪዲ ኮኮሪዴስ። ፊሊስጼሜ ቢታ ኣሳታካ ሂርጋ ሚጻይ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ሄ ዎዴ ኤዶሜ ቢታ ሃላቃቲ ዳጋሚዳ። ሞኣቤ ቢታ ሃሪዛይቲ ሂርጋን ኮኮሪዳ። ካናኔ ዴሬ ኣሳይ ዉሪ ሴሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ኣቤት ጎዳዉ! ዳጋማይኔ ሂርጋይ ኢስታ ኦይካና። ኢስቲ ኔ ዎልቃ ጊታቴꬅ ቤኢዲ፥ ኔ ኣሳይ ኣꬋና ጋካናስ፥ ኔኒ ዎዚዳ ኣሳይ ኣꬋና ጋካናስ፥ ሹቻ ማላ ቶሌቲ ኤቃና። ");
INSERT INTO gmve_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ኔኒ ኢስታ ኤሃዳ፥ ኔስ ቡዞ ቢታን ዲዛ ዙማ ሁኤን ቶካና። ኣቤት ሜርና ጎዶ፥ ሄ ሶሆይ ኔኒ ኔስ ዴያናስ ኦꬂዳ ሶሆኮ። ኣቤት ጎዳዉ! ሄ ጌሻ ሶሆይ ኔኒ ኔ ኩሼን ሚንꬃ ኤሲዳ ሶሆኮ። ");
INSERT INTO gmve_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","ጎዳይ ሜርናፔ ሜርና ጋካናስ ካዎታና።» ");
INSERT INTO gmve_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ጊብጼ ካዎ ፓራቲ ዉሪ፥ ፓራ-ጋሬቲኔ ቶጋ ኣሳቲ ኣባን ጌሊዳ ዎዴ ጎዳይ ኢስታ ቦላ ኣባ ሃꬃ ጉዬ ዛሪ ኤሂዴስ፤ ጊዶ ኣቲን ኢስራኤሌ ኣሳይ ኣባ ጊዶራ ሜላ ቢታ ቦላራ ሄሜቲዲ ፒኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ኣሮኔ ሚቼያ፥ ናቤ ማራማ ካራቤ ኤካዱስ፤ ማጫሳይ ዉሪ ካራቤ ባቂዲ ዬጺሼኔ ጉፒሼ ኢዞ ካሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","ማራማ ኢስታስ ዬꬃዛ ዬጻሼ፥ «ጎዳይ ኬሂ ꬎቁ ꬎቁ ጊዳ ጊሻስ ኢዛስ ዬጺቴ። ፓራኔ ፓራ ቶጊዳይታ ኢዚ ኣባን ኦሊዴስ» ጋ ዬጻዱስ። ");
INSERT INTO gmve_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ሄሳፌ ጉዬ ሙሴይ ኢስራኤሌ ኣሳ ዞኦ ኣባፌ ፒንꬂን ኢስቲ ሹራ ጌቴቲዛ ባዞ ቢዳ። ሄ ባዞን ኢስቲ ሃꬅ ዴሞንታ ሄꬑ ጋላስ ሄሜቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","ኢስቲ ማራ ጌቴቲዛሶ ጋኪዳ ዎዴ ማራ ሃꬂ ጫሞ ጊዲዳ ጊሻስ ኡያና ዳንዳይቤቴና፤ ሄሳ ጊሻስ ሄ ሶሆይ ማራ ጌቴቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","ኣሳይካ፥ «ኑኒ ኣይ ኡያኔ?» ጊዲ ሙሴ ቦላ ዙዙሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","ሙሴይ ጎዳስ ዋሲን ጎዳይ ኢዛ ኢሲ ሚꬅ ቤሲዴስ፤ ሙሴይ ሄ ሚꬃ ሃꬃን ዬጊን ሃꬃይ ማልኢዴስ። ሄን ጎዳይ ኢስታስ ዎጋኔ ማራ ኬሲዴሲኔ ኢስታ ፓጪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","ኢዚ ኢስታስ፥ «ጎዳ ኢንቴ ጾሳይ ዮቲዛይሳ ኢንቴ ሎኤꬂ ሲዪኮ፥ ኢዛ ኣይፌ ሲንꬃን ሎኦ ኦꬂኮ፥ ኢንቴ ኢዛ ኣዛዞ ዎዚናን ዎꬂ ናጊኮ፥ ኢዛ ዎጋካ ኡባ ናጊኮ፥ ታኒ ጊብጼ ኣሳ ቦላ ኤሂዳ ሃርጌፌ ኢሳካ ኢንቴ ቦላ ኤሂኬ፤ ጋሶይካ ታኒ ኢንቴና ፓꬂዛ ጎዳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ሄሳፌ ኢስቲ ታማኔ ናምኡ ሃꬃ ፑልቶቲኔ ላፑን ታሙ ዛምባ ሚꬃቲ ዲዛሶ ኤላሜ ዪዲ ሄን ሃꬃ ዶናን ኡቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ጊብጼፔ ኬዚዳ ናምኣንꬆ ኣጊናን፥ ታማኔ ኢቻሻንꬆ ጋላሳን ኢስራኤሌ ኣሳ ማባራይ ኩሜꬅ ኤላሜፔ ዴንዲ ቢዲ ኤላሜፔኔ ሲናፔ ጊዶን ዲዛ ሲኔ ጌቴቲዛ ባዞ ዪዳ። ");
INSERT INTO gmve_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ኢስራኤሌ ኣሳ ማባራይ ዉሪ ባዞን ሙሴ ቦላኔ ኣሮኔ ቦላ ዙዙሚዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","«ጎዳይ ኑና ጊብጼ ቢታን ባ ኩሼን ዎꬊዳኮ ሎኦኮሺን! ሄን ኑኒ ኣሾ ሚዛ ኬሬዛ ዩዪ ኣꬊ ኡቲዲ ኑኒ ኮዪዳ ማላ ካꬅ ካሊ ሚዶስ፤ ጊዶ ኣቲን ኢንቴ ኑና ሄፔ ኬሲዲ ሃይሳ ዴራ ኡባ ጋፋን ዎꬋናስ ሃ ባዞ ኤሂዴታ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ሂስቲን ጎዳይ ሙሴስ፥ «ታኒ ኢንቴስ ሳሎፔ ሚዛ ካꬅ ቡኪሳና፤ ኣሳይ ኡባ ጋላሲካ ኬዚዲ ሃቺስ ሃቺስ ጊዳናዝ ጻላላ ማጻና ኮሼስ። ኣሳይ ታ ኣዛዞ ካሊዛኮኔ ካሎንታኮ ታኒ ኢስታ ሄሳን ፓጫ ጼላና። ");
INSERT INTO gmve_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ኡሱፑንꬆ ጋላስ ኢስቲ ሃራ ዎዴ ማጺዛይሳስ ናምኡ ኩሼ ማጺዲ ካꬄቶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","ሄሳ ጊሻስ ሙሴይኔ ኣሮኔይ ኢስራኤሌ ኣሳ ኡባስ፥ «ኢንቴና ጊብጼ ቢታፌ ኬሲዳይ ጎዳ ጊዲዳይሳ ሃች ኦማርስ ኢንቴ ኤራና። ");
INSERT INTO gmve_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ቃሴ ኢዛ ቦላ ኢንቴ ዙዙሚዳይሳ ኢዚ ሲዪዳ ጊሻስ ማላዶ ኢንቴ ጎዳ ቦንቾ ቤያና። ኢንቴ ኑ ቦላ ዙዙማናስ ኑኒ ኦኔ?» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","ሄሳፌ ጉዬ ሙሴይ፥ «ኢንቴ ኢዛ ቦላ ዙዙሚዳይሳ ኢዚ ሲዪዳ ጊሻስ ኢዚ ኢንቴስ ማናስ ኦማርስ ኣሾ ኢሚኮ ኢንቴ ኮዪዳ ማላ ሚዛ ኡኬꬃካ ኡባ ኢንቴስ ማላዶ ኢማና። ኑ ኦኔ? ኢንቴ ጎዳ ቦላ ዙዙሚዴታ ኣቲን ኑ ቦላ ዙዙሚቤኬታ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","ሙሴይ ኣሮኔስ፥ «ኔኒ ኢስራኤሌ ኣሳ ማባራ ኡባ፥ ‹ጎዳይ ኢንቴ ዙዙንꬃ ሲዪዳ ጊሻስ ጎዳ ሲንꬅ ሺቂቴ› ጋ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ኣሮኔይ ኢስራኤሌ ኣሳ ማባራ ኡባስ ዮቲዳ ማላ ኣሳይ ባዞ ሲሚ ጼሊሺን ሄን ጎዳ ቦንቾይ ሻራራ ቆንጪዳይሳ ቤኢዳ። ");
INSERT INTO gmve_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","ጎዳይ ሙሴስ፥ «ታኒ ኢስራኤሌ ናይታ ዙዙንꬃ ሲያዲስ፤ ኔኒ ኢስታስ፥ ‹ኢንቴ ኦማርሳ ዎዴ ኣሾ ማና፤ ማላዶ ኡኬꬅ ካላና፤ ሄ ዎዴ ታኒ ጎዳ ኢንቴ ጾሳ ጊዲዳይሳ ኢንቴ ኤራና› ጋዳ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ሄ ጋላሳ ኦማርሳ ዎዴ ኩራቾቲ ዪዲ ኢስራኤሌ ኣሳይ ዲዛሶን ኩሚዳ፤ ቃሴ ማላዶ ኢስቲ ዲዛሶ ዩሾን ጻዛይ ማይኢ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ጻዛይ ጾስኪሺን ቢታ ቦላን ቦꬃ ሻች ሚሳቲዛ ሊቆ ሚሺ ቤቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ኢስራኤሌ ኣሳይ ሄሳ ቤኢዲ ባ ጋርሳን ኢሶይ ኢሳ፥ «ሃይሲ ኣዜ?» ጊዳ። ኣይስ ጊኮ ኢስቲ ኢዚ ኣዛኮ ኤሪቤቴና። ሂስቲን ሙሴይ ኢስታስ፥ «ኢንቴስ ማናስ ጎዳይ ኢሚዳ ካꬂ ሃይሳኮ። ");
INSERT INTO gmve_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","ጎዳይ፥ ‹ኣሳይ ኢሶይ ኢሶይ ባስ ማናስ ኮሺዛ ማላ ሺሾ፤ ኢንቴ ሶ ኣሳስ ሁኤን ሁኤን ኢሲ ኢሲ ኪሎኔ ባጋ ኤኪቴ› ጊ ኣዛዚዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ኢስራኤሌ ኣሳይ ሙሴይ ኢስታስ ዮቲዳ ማላ ኦꬂዴስ፤ ባጋይ ዳርሲዲ ባጋይ ቃሴ ጉꬂዲ ሺሺዳ። ");
INSERT INTO gmve_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ሺሺዲ ኢስቲ ማኪን ዳርሲዲ ሺሺዳይሳስ ፓላሂቤና፤ ጉꬅ ሺሺዳይሳስካ ፓጪቤና፤ ዉሪካ ኢሶይ ኢሶይ ባስ ጊዲዛ ማላ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","ሄሳፌ ጉዬ ሙሴይ ኢስታስ፥ «ኦኒካ ኢዛፔ ዎንቶስ ኣሾፎ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ጊዲኮካ ኢስታፌ ባጋይ ሙሴይ ዮቲዛይሳ ኤኮንታ ኣጊዲ ኣቲዳይሳ ዎንቶ ማላዶ ጋካናስ ዎꬂዳ፤ ዎꬂዳይሲካ ጉጹኒዲ ጺንቂዴስ። ሄሳ ጊሻስ ሙሴይ ኢስታ ሃንቄቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ማላዶ ማላዶ ኣሳይ ዉሪ ባስ ኮሺዛይሳ ላጌ ሺሺዴስ፤ ኣርሼይ ሚቺዛ ዎዴ ቢታን ኣቲዳይሲ ማዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ኡሱፑንꬃ ጋላሳን ኢስቲ ካሴይሳስ ናምኡ ኩሼ ኢሲ ኢሲ ኣሳስ ሄꬑ ኪሎ ሺሺዳ። ሂስቲን ማባራ ሃላቃቲ ዉሪ ዪዲ ሄሳ ሙሴስ ዮቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","ኢዚ ኢስታስ፥ «ጎዳይ ኣዛዚዳይሲ ሃይሳ፤ ዎንቶይ ሼምፖ ጋላሳ፥ ጎዳስ ጌሻ ሳምባታ። ሄሳ ጊሻስ ኢንቴ ኡካናይሳ ኡኪቴ፤ ኢንቴ ዶይሳናይሳካ ዶይሲቴ፤ ፓላሂዳይሳ ዎንቶስ ኣሺቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","ሄሳ ጊሻስ ኢስቲ ሙሴይ ኣዛዚዳ ማላ ዎንቶስ ዎꬂን ጺንቂቤና ዎይኮ ጉጹኒቤና። ");
INSERT INTO gmve_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","ዎንቴꬃ ጋላስ ሙሴይ ኢስታስ፥ «ሃይሳ ሃች ሚ ዉርሲቴ፤ ኣይስ ጊኮ ሃች ጎዳ ሳምባታ፤ ኢንቴ ኢዛ ሃች ዴምባን ዴሜኬታ። ");
INSERT INTO gmve_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ኢንቴ ኡሱፑን ጋላሳን ኢዛ ሺሺቴ፤ ጊዶ ኣቲን ላፑንꬃ ጋላሳይ ሳምባታ ጊዲዳ ጊሻስ ኣይኮይካ ዴና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ጊዶ ኣቲን ኢሲ ኢሲ ኣሳቲ ላፑንꬃ ጋላሳን ሺሻናስ ኬዚዳ ሺን ኣይኮካ ዴሚቤቴና። ");
INSERT INTO gmve_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ጎዳይ ሙሴስ፥ «ኢንቴ ታ ኣዛዞታኔ ታ ዎጋታ ናጎዛ ኣይዴ ጋካናስ ኢጻኔ? ");
INSERT INTO gmve_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ታ ኢንቴስ ሳምባታ ኢሚዳይሳ ኣኬኪቴ፤ ኡሱፑንꬃ ጋላሳን ታ ኢንቴስ ናምኡ ጋላሳስ ካꬅ ኢሚዛይሲ ሄሳ ጊሻሳ። ላፑንꬃ ጋላስ ዉሪካ ባ ዲዛሶን ዲዛሶን ታኮ፤ ኦኒካ ኣዋካ ቦፖ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ሄሳ ጊሻስ ኣሳይ ላፑንꬃ ጋላሳን ሼምፒዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ኢስራኤሌ ኣሳይ ሄ ካꬃዛ ማና ጊ ሱንꬂዴስ። ኢዚካ ዴቦ ኣይፌ ማላ ጊዲዲ ቦꬃ፤ ኤሳራ ኡኬቲዳ ኡኬꬃ ማላ ማልኤስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","ሙሴይ ኢስራኤሌ ኣሳስ፥ «ጎዳይ ኣዛዚዳይሲ ሃይሳ፥ ‹ታኒ ኢንቴና ጊብጼ ቢታፌ ኬሲዳ ዎዴ፥ ባዞን ሚዚዳ ካꬃ ኢስቲ ቤያና ማላ፥ ማናፌ ኢሲ ኢሲ ኪሎኔ ባጋ ኢንቴ ሲንꬃፌ ያና ዬሌታታስ ኣሺ ዎꬂቴ› ጊ ኣዛዚዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","ሂስቲን ሙሴይ ኣሮኔ፥ «ኢሲ ጻሮ ኤካዳ ኢሲ ኪሎኔ ባጋ ጊዲዛ ማና ኢዛን ቆላ፤ ሂስታዳ ያና ዬሌታታስ ሚንጃና ማላ ጎዳ ሲንꬃን ዎꬃ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","ጎዳይ ሙሴ ኣዛዚዳ ማላ ሚንጃናስ፥ ኣሮኔይ ማና ጎዳ ማርካ ታቦታ ሲንꬃን ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ኢስራኤሌ ኣሳይ ባ ዳና ቢታ ቢ ጋካናስ ኦይዱ ታሙ ላይꬅ ኩሜꬅ ማና ሚዳ፤ ኢስቲ ካናኔ ቢታ ዛዋ ጋካናስ ማና ሚሼ ዴኢዳ። ");
INSERT INTO gmve_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ኢሲ ኪሎይኔ ባጋይ ሄ ዎዴ ማኪዛ ጊታ ማካ ሚሻስ ታማፌ ኢሲ ኩሼኮ። ");
INSERT INTO gmve_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ኢስራኤሌ ማባራይ ዉሪ ጎዳይ ኣዛዚዳ ማላ ሲና ጌቴቲዛ ባዞፌ ዴንዲ ቢዲ ኤራፊዲሜ ጌቴቲዛሶን ኡቲዴስ፤ ጊዶ ኣቲን ኣሳስ ኡያናስ ሃꬂ ሄን ቤቲቤና። ");
INSERT INTO gmve_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","ሄሳ ጊሻስ ኢስቲ ሙሴራ ኦዬቲዲ ኢዛ፥ «ኑስ ኡያና ሃꬅ ኢማ» ጊዳ። ሙሴይ ዛሪዲ፥ «ኢንቴ ታናራ ኣይስ ኦዬቴቲ? ጎዳ ኢንቴ ኣይስ ፓጬቲ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ጊዶ ኣቲን ኣሳይ ሄን ሳሜቲዲ ሙሴ ቦላ ዙዙሚዴስ። ኢስቲ፥ «ኔኒ ኑና፥ ኑ ናይታኔ ኑ ሜሄ ሳሞን ዎꬋናስ ጊብጼፔ ኣይስ ኬሳዲ?» ጊዲ ሙሴ ቦላ ጉጉሚዳ። ");
INSERT INTO gmve_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ሂስቲን ሙሴይ፥ «ታኒ ሃ ኣሳ ዎስቶ? ኢስቲ ታና ሹቻን ጫዳና ጌቴስ» ጊዲ ጎዳኮ ዋሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","ጎዳይ ሙሴ፥ «ኢስራኤሌ ኣሳ ጪማታፔ ኔናራ ኤካዳ፥ ካሴ ኔኒ ኣባዬ ሻፋ ሃꬃ ኢዛራ ሾጪዳ ጉፌዛ ኔ ኩሼን ኦይካዳ ኣሳፔ ሲንꬅ ባ። ");
INSERT INTO gmve_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ታኒ ሲና ዙማን ዲዛ ዛላ ቦላ ሄን ኔ ሲንꬃን ኤቃዳ ናጋና፤ ኔኒ ሄ ዛላ ሾጫ፤ ኣሳይ ኡያና ማላ ሃꬂ ኢዛፔ ኬዛና» ጊን ሙሴይ ኢስራኤሌ ጪማታ ሲንꬃን ኢዚ ጊዳ ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ኢስራኤሌ ኣሳይ፥ «ጎዳይ ኑ ጊዶን ዲዜዬ? ዴኔ?» ጊ ጎዳ ፓጪዲ ኦዬቲዳ ጊሻስ ሄ ሶሆዛ ሙሴይ ማሳኔ ማሪባ ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ኣማሌቄ ኣሳይ ዪዲ ኤራፊዲሜን ኢስራኤሌ ናይታ ኦሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","ሙሴይ ኢያሶ፥ «ኔኒ ኑስ ኣሳ ጋርሳፌ ኢሲ ኢሲ ኣስ ዶራ ኤካዳ ዎንቶ ኣማሌቄታራ ኦሌታና ኬዛ፤ ታኒካ ጾሳ ጉፌ ኦይካዳ ꬎቃሶሆን ኤቃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","ኢያሶይ ሙሴይ ጊዳ ማላ፥ ኣማሌቄታራ ኦሌቲዴስ። ሙሴይ፥ ኣሮኔይኔ ሁሬይ ꬎቃሶ ኬዚዳ። ");
INSERT INTO gmve_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ሙሴይ ባ ኩሼ ፑዴ ዴንꬂሺን ኢስራኤሌ ኣሳይ ጾኔስ ሺን ኢዚ ባ ኩሼ ዚቂሲሺን ኣማሌቄ ኣሳይ ጾኔስ። ");
INSERT INTO gmve_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","ሙሴ ኩሼይ ኢጼቲሺን ኣሮኔይኔ ሁሬይ ሹች ኤኪ ኤሂዲ ሙሴ ኢዛ ቦላ ኡቲሲዳ። ኢስቲ ኢሶይ ኢሲ ባጋራ ኡሻቻ ኩሻ ኢሶይ ኢሲ ባጋራ ሃዲርሳ ኩሻ ꬎቁ ሂስቲ ኦይኪዳ። ሂስቲን ኣርሼይ ዉላና ጋካናስ ኢዛ ኩሼይ ꬎቁ ጊ ጋምኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ሄሳ ጊሻስ ኢያሶይ ኣማሌቄ ኦላንቻታኔ ኣማሌቄ ኣሳ ጊꬃ ማሻን ጾኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ሄሳፌ ጉዬ ጎዳይ ሙሴስ፥ «ታኒ ኣማሌቄ ኣሳይ ቆፌቶንታ ማላ ኢስታ ቢታ ቦላፌ ኩሜꬅ ꬋይሳና። ሃይሲ ኡባ ዎዴ ቆፌታና ማላ ማጻፋን ጻፋዳ ኢያሶስ ናባባ ሲሶንታ ኣጎፋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ሙሴይካ ያርሾ ያርሺዛሶ ኦꬂዲ፥ «ጎዳይ ታ ባንዲራ» ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","ቃሴካ፥ «ቱማፔ ጎዳይ ባ ኩሼ ዴንꬂዲ ዬሌታፔ ዬሌታ ጋካናስ ኣማሌቄታራ ኦሌታናስ ጫቂዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ሚዲያሜ ቢታ ቄሴ፥ ሙሴ ቦሎ ዮቶሬይ፥ ጾሳይ ሙሴሲኔ ኢዛ ኣሳ ኢስራኤሌ ናይታስ ኦꬂዳይሳ ሄሲካ ጎዳይ ኢስታ ጊብጼ ቢታፌ ኬሲዳይሳ ኡባ ሲዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","ሄ ዎዴ ሙሴ ቦሎ ዮቶሬይ፥ ሙሴይ ጉዬ ዛሪ ሞይዚዳ ሙሴ ማቼዮ ጺፖሮኔ ኢዚ ናምኡ ናይታ ባናራ ኤኪ ዪዴስ። ሙሴይካ፥ «ታኒ ኣሳ ቢታን ቤቴ ኣስ ጊዳዲስ» ጊሼ ባይራ ናዛ ጌርሾሜ ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ቃሴካ፥ «ታ ኣዋ ጾሲ ታና ማዲዴስ፤ ኢዚ ታና ጊብጼ ካዎ ቶራፔ ኣሺዴስ» ጊሼ ናምኣንꬆ ናዛ ኤልኤዜሬ ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","ሙሴ ቦሎ ዮቶሬይ ሙሴ ኣቱማ ናይታራኔ ሙሴ ማቼይራ ጊዲዲ ባዞን ጾሳ ዙማ ኣቻን ዲዛ ሙሴኮ ዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ኢዚ፥ «ታኒ ኔ ቦሎ ዮቶሬይ፥ ኔ ማቼይራኔ ኢዚ ናይታ ናምኣታራ ኔኮ ሄ ቦስ» ጊዲ ኪታ ሙሴኮ ዬዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ሄሳ ጊሻስ ሙሴይ ባ ቦሎዛራ ጋጋናስ ኬዚዲ ሆኪዲ ኢዛ ዬሪዴስ። ኢስቲ ኢሶይ ኢሳ ሳሮꬂዳፔ ጉዬ ሙሴ ዱንካኔ ጊዶ ጌሊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ጎዳይ ኢስራኤሌ ኣሳ ጊሻስ ጊብጼ ካዎ ቦላኔ ጊብጼ ኣሳ ቦላ ኦꬂዳይሳ፥ ኦጌ ቦላ ኢስታ ጋኪዳ ዳቡራኔ ጎዳይ ኢስታ ኣሺዳይሳ ኡባ ሙሴይ ባ ቦሎዛስ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ኢስራኤሌ ኣሳ፥ ጊብጼ ኣሳ ኩሼፔ ኣሻናስ ጎዳይ ኦꬂዳ ሎኦ ኦሶ ኡባ ሲዪዲ ዮቶሬይ ኡፋዬቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","«ኢንቴና ጊብጼ ኣሳ ኩሼፔኔ ካዎ ፓሮኔ ኩሼፔ ኣሺዳ ጎዳይ ባ ኣሳ ጊብጼ ኣሳ ኩሼፔ ኬሲ ኤኪዳይሲ ኢዚ ጋላቴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ኢዚ ኢስራኤሌ ኣሳ ቦላ ኦቶሬቲዳይታስ ሃይሳ ኦꬂዳ ጊሻስ ጎዳይ ሃራ ኤቃ ጾሳታ ኡባፌ ጎባ ጊዲዳይሳ ታኒ ሃኢ ኤራዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","ሄሳፌ ጉዬ ሙሴ ቦሎ ዮቶሬይ ጹጌቲዛ ያርሾ ቃሴካ ሃራ ያርሾታ ጾሳስ ሺሺዴስ። ኣሮኔይኔ ኢስራኤሌ ጪማቲ ዉሪ ጾሳ ሲንꬃን ሙሴ ቦሎዛራ ካꬅ ማናስ ዪዳ። ");
INSERT INTO gmve_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ዎንቴꬃ ጋላስ ሙሴይ ኣሳስ ፒርዳናስ ኡቲን ኣሳይ ኢዛ ሲንꬃን ዪዲ ዪዲ ኤቂዛ ጊሻስ ሙሴይ ማላዶፔ ኦማርሳ ዎዴ ጋካናስ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","ሙሴ ቦሎይ ሙሴይ ኣሳስ ኦꬂዛይሳ ኡባ ቤኢዲ፥ «ኔኒ ሃ ኣሳስ ኦꬂዛይሲ ሃይሲ ኣዜ? ሃይሲ ኣሳይ ዉሪ ማላዶፔ ዶሚዲ ኦማርሳ ዎዴ ጋካናስ ኔ ሲንꬃን ዪዲ ዪዲ ኤቂሺን፥ ማዶይ ባይንዳ ኣሳ ማላ ኔኒ ኔርካ ኣይስ ፒርዳስ ኡታዲ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","ሂስቲን ሙሴይ ባ ቦሎዛስ፥ «ኣሳይ ጾሳ ሼኔ ኦይቻናስ ታኮ ዪዛ ጊሻሳ። ");
INSERT INTO gmve_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ኢስታ ጊዶን ዮኦይ ዲኮ ታኮ ዬቴስ፤ ታኒካ ኢስታ ጊዶን ዲዛ ዮኦ ፒርዳይስ፤ ጾሳ ማራኔ ዎጋ ኢስታ ኤሪሳይስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","ዮቶሬይካ፥ «ሃይሲ ኔኒ ኦꬂዛይሲ ሎኦ ዴና። ");
INSERT INTO gmve_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ኔኒኔ ኔናራ ዲዛ ኣሳይ ዳቡራ ጻላላ ዳቡሬታ፤ ሃይሲ ኦሶዚ ኔስ ዳሮ ዴጾ፤ ኔኒ ሃይሳ ኔርካ ኦꬃናስ ዳንዳያካ። ");
INSERT INTO gmve_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ኣኔ ሃኢ ታ ኔና ዞራይስ! ታ ዮቲዛይሳ ሲያ፤ ጾሲ ኔናራ ጊዶ። ኔኒ ሃ ኣሳ ጊሻስ ጾሳ ሲንꬃን ኤቃ፤ ኣሳዛ ዮኦካ ጾሳኮ ሺሻ። ");
INSERT INTO gmve_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ጾሳ ማራኔ ዎጋ ኢስታ ኔኒ ታማርሳ፤ ኢስቲ ዋኒ ዳናኮ ኢስቲ ኦꬃና ኦሶ ኢስታ ቤሳ። ");
INSERT INTO gmve_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ቃሴ ኣሳ ኡባ ጊዶፌ ኤራ ኣሳታ፥ ጾሳስ ባቢዛይታ፥ ኣማኔቲዳይታኔ ማታኤ ኢጺዛይታ ዶራዳ ኢስታፌ ኣሳስ ሻላቃታ፥ ማቶ ሃላቃታ፥ ሃምሳ ሃላቃታኔ ኣሲራ ሃላቃታ ሂስታ ሱንꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ኢስቲ ኡባ ዎዴ ኣሳስ ፒርዴቶ፤ ጊዶ ኣቲን ዴጾ ዮኦ ኡባ ኔኮ ኤሄቶ፤ ዋዪሶንታ ዮኦ ኡባ ኢስቲ ሄን ዉርሴቶ። ኢስቲ ኔናራ ጊሼቲዛ ጊሻስ ቶሆይ ኔስ ካዉያና። ");
INSERT INTO gmve_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ኔኒ ሄሳꬆ ኦꬂኮ ሃይሲ ጾሳ ሼኔ ጊዲኮ ኔኒ ዳሮ ዳቡራካ። ቃሴ ሃ ኣሳይ ዉሪካ ባ ዮኦይ ፖሌቲን ኡፋይሳን ባ ሶ ባ ሶ ባና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","ሙሴይ ባ ቦሎዛ ቃላ ሲዪዴስ፤ ኢዚ ጊዳይሳ ኡባካ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ሙሴይ ኢስራኤሌ ኡባ ጊዶፌ ኤራ ኣሳታ ዶሪዲ ኣሳ ካሌꬂዛ ሻላቃታ፥ ማቶ ሃላቃታ፥ ሃምሳ ሃላቃታኔ ኣሲራ ሃላቃታ ሂስቲ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ኢስቲካ ኣሳስ ኡባ ዎዴ ፒርዲዳ፤ ባና ዴጺዳ ዮኦዛ ሙሴኮ ኤሂዳ ሺን ዴጾንታ ዮኦዛ ኡባ ባርካ ዉርሲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ሄሳፌ ጉዬ ሙሴይ ባ ቦሎ ዮቶሬ ሞይዚን ዮቶሬይ ጉዬ ባ ዴሬ ሲሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ኢስራኤሌ ኣሳይ ጊብጼፔ ኬዚዳ ሄꬓንꬆ ኣጊናን ኮይሮ ጋላስ ሲና ባዞ ጋኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ኢስቲ ኤራፊዲሜፔ ዴንዲዲ ሲና ባዞ ቢዲ ባዞን ዲዛ ዙማ ሲንꬃን ኡቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ሙሴይካ ጾሳኮ ፑዴ ዙማ ቦላ ኬዚን ጎዳይ ዙማ ቦላ ዲሼ ኢዛ ጼይጊዲ፥ «ኔኒ ያቆቤ ኬꬃ ኣስ ጊዲዳ ኢስራኤሌ ናይታስ ሂዝጋ ዮታ፤ ");
INSERT INTO gmve_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‹ታኒ ጊብጼ ኣሳ ቦላ ኣይ ኦꬂዳኮ ቃሴ ጎሌ ካፎይ ባ ና ባ ቄፌን ቶኪዛ ማላ ታኒ ኢንቴና ዎስታ ቶካዳ ታኮ ኤሂዳኮ ኢንቴ ኢንቴ ኣይፌራ ቤዪዴታ። ");
INSERT INTO gmve_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ሂስቲን ሃኢ ኢንቴ ታስ ኩሜꬅ ኣዛዜቲኮ፥ ኢንቴ ታ ጫቆ ቃላ ናጊኮ፥ ኩሜꬃ ዴራ ጋርሳን ኢንቴ ታስ ቡዞ ዴሬ ጊዳና። ቢታይ ዉሪ ታስ ጊዲኮካ፥ ");
INSERT INTO gmve_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ኢንቴ ታ ካዎቴꬃስ ዱማ ሻኬቲዳ ቄሴታኔ ዱማ ዴሬ ጊዳና፤› ኔኒ ኢስራኤሌ ናይታስ ዮታና ቃላይ ሃይሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","ሂስቲን ሙሴይ ዙማ ቦላፌ ዱጌ ኣሳኮ ዎꬊዲ ዴሬ ጪማታ ጼይጊ ሺሺዲ ጎዳይ ዮታ ጊዳ ቃላታ ኡባ ኢስታስ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ኣሳይ ዉሪ ኢሲ ቃላን ጊዲዲ፥ «ጎዳይ ጊዳይሳ ኡባ ኑ ኦꬃና» ጊን ሙሴይ ኢስቲ ጊዳይሳ ጎዳኮ ኤኪ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ጎዳይ ሙሴ፥ «ታኒ ኔናራ ሃሳይሺን ኣሳይ ሲያና ማላኔ ኢስቲ ኔናን ኡባ ዎዴካ ኣማኔታና ማላ፥ ታኒ ኔኮ ዎልቃማ ሻራራ ያና» ጊዴስ። ሄሳፌ ጉዬ ሙሴይ ኣሳይ ጊዳይሳ ጎዳስ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ጎዳይ ሙሴስ፥ «ኔኒ ኣሳኮ ባዳ ሃቺኔ ዎንቶ ኢስታ ጌሻ። ኢስቲ ባ ማይኦ ሜጪዲ፥ ");
INSERT INTO gmve_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ሄꬓንꬆ ጋላሳስ ጊጌቴቶ። ጋሶይካ ሄꬓንꬆ ጋላሳን ኣሳይ ዉሪ ቤዪሺን ታኒ ጎዳይ ሲና ዙማ ቦላ ዎꬋና። ");
INSERT INTO gmve_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","ኔኒ ኣሳይ ዲዛሶ ዩሾን ኣሳስ ዛዋ ዎꬃዳ ኢስታስ፥ ‹ዙማ ቦላ ፑዴ ኬዞንታ ማላ ዎይኮ ዙማ ጻጶ ቦቾንታ ማላ ኢንቴና ኤሪቴ። ዙማ ቦቺዳይ ኦኒካ ቱማፔ ሃይቃናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ኣስ ዎይኮ ሜሄ ጊዲን ዛዋ ፒኒ ኣꬊኮ ኦኒካ ባ ኩሼን ኢዛ ቦቾንታ ሹቻን ጫዲዲ ዎይኮ ዎንዳፌን ዱኪዲ ዎꬎ› ጌስ። ዛዬ ጎቺ ፑኒኮ ኢስቲ ፑዴ ዙማ ቦላ ኬዛና ዳንዳዬቴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","ሙሴይ ዙማፔ ኣሳኮ ዱጌ ዎꬊዳፔ ጉዬ ኣሳ ጌሺን ኣሳይ ባ ማይኦ ሜጪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ኣሳካ፥ «ሄꬓንꬆ ጋላሳስ ጊጌቲቴ፤ ማጫሳራ ኣቆፒቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ሄꬓንꬆ ጋላስ ማላዶ ዳዳ ጊሪሲ ሲዬቲዴስ። ዎልቃንꬃ ፖኦይኔ ዎልቃማ ሻራይ ዙማ ቦላ ቤቲዴስ፤ ዛዬይ ፑኔቲዛ ዳሮ ዎልቃማ ጊሪሲ ሲዬቲዴስ። ሄሳ ጊሻስ ኣሳይ ዉሪ ባ ዲዛሶን ባቢዲ ኮኮሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ሙሴይካ ኣሳ ጾሳራ ጋꬃናስ ኣሳይ ዲዛሶፔ ኬሲን ኣሳይ ዙማ ኣቻን ኤቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","ጎዳይ ሲና ዙማ ቦላ ታማራ ዎꬊዳ ጊሻስ ጊታ ጮጬፔ ኬዚዛ ማላ ጩዋይ ቱሉ ጊ ኬዚዲ ዙማ ኩሜꬅ ካሚዴስ፤ ዙማዚ ኩሜꬅ ኬሂ ቃጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ዛዬዛ ጊሪሳይካ ኬሂ ዳሪ ዳሪ ቢዳ ዎዴ ሙሴይ ሃሳዪን ሃሳዪን ጾሲ ኢዛስ ዛሪ ዛሪዲ ቃላን ሃሳይዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","ጎዳይ ካሴ ሲና ዙማ ቦላ ዎꬊዳ ዎዴ ሙሴ ፑዴ ዙማ ሁኤ ጼይጊን ሙሴይ ፑዴ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ጎዳይ ኢዛ፥ «ኔኒ ዱጌ ባዳ ኣሳይ ቤያና ጊዲ ሃ ታኮ ዛዋ ኣꬎንታ ማላኔ ኢስታፌ ዳሮቲ ሃይቆንታ ማላ ኣሳ ሃንቃ። ");
INSERT INTO gmve_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ሃራይ ኣቶሺን ታ ማታ ሺቂዛ ቄሴቲካ ኡባ ዎዴ ባና ጌሻናስ ኮሼስ፤ ሂስቶንታ ኢጺኮ ጎዳይ ኢስታ ቃጻያና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","ሙሴይ ጎዳስ፥ «ኣሳይ ዙማ ቦላ ፑዴ ያናስ ዳንዳዬና፤ ኣይስ ጊኮ ኔኒ ኔ ሁኤን፥ ‹ሃ ሶሆዛ ጌሻ ማላ ዱማሳዳ፥ ሃ ዙማ ኣቻን ዛዋ ዎꬂቴ› ጋዳ ኑስ ዮታ ዎꬃዳሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","ሂስቲን ጎዳይ ኢዛ፥ «ኔኒ ዱጌ ሃኢ ኤሌ ዎꬋዳ ፑዴ ኬዛ። ኣሮኔይካ ኔናራ ዮ። ቄሴታኔ ኣሳ ታ ቃጻዮንታ ማላ ኢስቲ ዛዋ ፒኒዲ ፑዴ ታኮ ዮፔቶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ሄሳ ጊሻስ ሙሴይ ዱጌ ኣሳኮ ዎꬊዲ ጎዳይ ጊዳይሳ ኢስታስ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ጎዳይ ሃሳይዳ ቃላቲ ኡባይ ሃይሳፌ ካሊዛይታ፤ ");
INSERT INTO gmve_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«ኔና ጊብጼፔ ኣይሌቴꬃ ቢታፌ ኬሲዳ ጎዳ ኔ ጾሳይ ታና። ");
INSERT INTO gmve_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","«ታፔ ኣቲን ሃራ ኤቃ ጾሳታስ ጎይኖፋ። ");
INSERT INTO gmve_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","«ቦላ ሳሎን ዲዛ ሚሽ ጊዲን፥ ዎይኮ ጋርሳ ሳኣን ዲዛ ሚሽ ጊዲን፥ ዎይኮ ቢታፌ ጋርሳን ሃꬃ ጊዶን ዲዛ ሚሽ ጊዲን ኣይኮካ ሚሳቲሳዳ ኔስ ሚስሌ ሂስታዳ ሜꬎፋ። ");
INSERT INTO gmve_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ኢስታስ ሆኮፋኔ ኢስታስ ጎይኖፋ። ኣይስ ጊኮ ታኒ ጎዳ ኔ ጾሳይ ቃናቲዛ ጾሳኮ፤ ታና ኢጺዛይታ ኣዋታ ናጋራ ጊሻስ ናይታ ሄꬓንꬆ ዬሌታኔ ኦይዳንꬆ ዬሌታ ጋካናስ ቃጻያይስ። ");
INSERT INTO gmve_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ቃሴ ታኒ ታና ሲቂዛይታሲኔ ታ ኣዛዞ ናጊዛይታስ ዳሮ ሺ ዬሌቴꬅ ጋካናስ ታኒ ታ ሲቆ ቤሲዛ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","«ጎዳ ኔ ጾሳ ሱንꬅ ሃዳን ዴንꬆፋ፤ ኣይስ ጊኮ ጎዳ ኔ ጾሳይ ባ ሱንꬅ ሃዳን ዴንꬂዛይታ ቃጻያና። ");
INSERT INTO gmve_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","«ሳምባታ ጋላሳ ሃራ ጋላሳታፔ ዱማሳዳ ናጋ። ");
INSERT INTO gmve_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ኔ ኦꬂዛ ኦሶ ኡባ ኡሱፑን ጋላሳታን ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ጊዶ ኣቲን ላፑንꬃ ጋላሳይ ጎዳ ኔ ጾሳስ ሳምባታ። ሄ ጋላስ ኣይኮ ኦሶካ ኦꬆፋ፤ ኔኒ ዎይኮ ኔ ኣቱማ ናይ፥ ዎይኮ ኔ ማጫ ናይ፥ ዎይኮ ኔ ኣቱማ ኣይሌይ፥ ዎይኮ ኔ ማጫ ኣይሌይ፥ ዎይኮ ኔ ሚዛይ፥ ዎይኮ ኔ ዴሬን ዲዲ ኔስ ኦꬂዛ ሃራ ዴሬ ኣስ ጊዲን ሄ ጋላሳን ኣይ ኦሶካ ኦꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ኣይስ ጊኮ ኡሱፑን ጋላሳን ጎዳይ ሳሎ፥ ሳኣ፥ ኣባኔ ኢስታ ጊዶን ዲዛ ኡባ ሜꬊዲ ላፑንꬃ ጋላስ ሼምፒዴስ። ሄሳ ጊሻስ ጎዳይ ሳምባታ ጋላሳ ኣንጂዴሲኔ ዱማሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","«ጎዳ ኔ ጾሳይ ኔስ ኢሚዛ ቢታን ኔ ዳሮ ላይꬅ ዳና ማላ፥ ኔ ኣዋኔ ኔ ኣዮ ቦንቻ። ");
INSERT INTO gmve_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","«ኣስ ዎꬎፓ። ");
INSERT INTO gmve_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","«ላይማቶፓ። ");
INSERT INTO gmve_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","«ካይሶቶፓ። ");
INSERT INTO gmve_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","«ኦና ቦላካ ዎርዶ ማርካቶፋ። ");
INSERT INTO gmve_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","«ኣሳ ኬꬅ ኣሞቶፋ፤ ኣሳ ማቾ ዎይኮ ኢዛ ኣይሌ ዎይኮ ኢዛ ኣይሌዮ ዎይኮ ኢዛ ቦራ ዎይኮ ኢዛ ሃሬ ዎይኮ ኢዛስ ዲዛ ኣይ ሚሺካ ኣሞቶፋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ኣሳይ ዉሪ ዳዳይ ጊሪዛይሳኔ ዛዬይ ዛዬቲዛይሳ ሲዪዲ ቃሴ ዎልቃንꬂ ዎልቃሚዛይሳኔ ዙማይ ጩዋቲዛይሳ ቤኢዲ ኮኮሪሼ ሃሆን ኤቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ኣሳይ ሙሴስ፥ «ኑኒ ሃይቆንታ ማላ ጾሲ ኑናራ ሃሳዮፖ፤ ኔኒ ኑስ ዮታ፤ ኑኒ ሲያና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","ሙሴይ ኣሳስ፥ «ጾሲ ኢንቴና ፓጫናስ፥ ኢዛ ያሺ ኢንቴ ዎዚናን ኩሚን ኢንቴ ናጋራ ኦꬆንታ ማላ ዪዳ ጊሻስ ባቦፍቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","ኣሳይ ሃሆን ኤቂ ዲሺን ሙሴይ ጾሲ ዲዛሶ ዎልቃማ ሻራ ꬉማኮ ሺቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","ሄሳፌ ጉዬ ጎዳይ ሙሴ፥ «ኢስራኤሌ ኣሳስ፥ ‹ታኒ ሳሎፔ ኢንቴስ ሃሳይሺን ኢንቴ ኢንቴ ኣይፌራ ቤኢዴታ። ");
INSERT INTO gmve_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ታፔ ኣቲን ሃራ ጾሲ ኢንቴስ ዶፖ፤ ቢራፔ ዎይኮ ዎርቃፌ ኢንቴስ ኤቃ ጾሳታ ሜꬊዲ ጎይኖፍቴ። ");
INSERT INTO gmve_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","« ‹ኔኒ ታስ ያርሾ ያርሺዛሶ ኡርቃፌ ሜꬋዳ ጹጌቲዛ ያርሾታ፥ ኢሲፌቴꬃ ያርሾታ፥ ኔ ዶርሳታፔ፥ ኔ ዴይሻታፔኔ ኔ ሜሄታፔ ኢዛ ቦላ ያርሻ። ታ ሱንꬂ ቆፌታና ማላ፥ ኢንቴ ኦꬂዳሶ ኡባ ሶሆ ያዳ ታ ኢንቴና ኣንጃና። ");
INSERT INTO gmve_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ኔኒ ታስ ያርሾ ያርሺዛሶ ሹቻፌ ኦꬂዛ ጊዲኮ ማሴቲዳ ሹቻፌ ኦꬆፋ፤ ኣይስ ጊኮ ኔኒ ማሲዛ ቢራታን ኢዛ ቦቺኮ ኔ ኢዛ ቱኒሳሳ። ");
INSERT INTO gmve_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","ታስ ያርሾ ያርሺዛሶ ፑዴ ኬዛናስ ያንጋሬ ሜꬋዳ ኢዛ ቦላ ኬዞፓ፤ ጋሶይካ ኔኒ ኬዚዛ ዎዴ ኔ ካሎቴꬂ ቤታና› ጋዳ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","«ኔኒ ኢስራኤሌ ናይታስ ኢማና ዎጋይ ሃይሳ። ");
INSERT INTO gmve_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","ኔኒ ኢስራኤሌ ናይታ ጋርሳፌ ኣይሌ ሻሚኮ ኢዚ ኔስ ኡሱፑን ላይꬅ ኦꬆ፤ ጊዶ ኣቲን ላፑንꬃ ላይꬃን ኢዚ ኣይኮካ ቃንጾንታ ኣይሌቴꬃፌ ጮ ሜላ ዬዴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ኢዚ ባርካ ዪዳ ጊዲኮ ባርካ ቦ፤ ባ ማቼይራ ዪዳ ጊዲኮ ኢዛ ማቼያካ ኢዛራ ቡ። ");
INSERT INTO gmve_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ኢዛ ጎዳይ ኢዛስ ማቾ ኤኪዳ ጊዲኮ ማቼያ ኢዛስ ኣዴ ናይታ ዎይኮ ማጫ ናይታ ዬሊዳ ጊዲኮ፥ ሄ ማጫሳያኔ ኢዚ ናይቲ ኢዛ ጎዳስ ኣቲኮ ኢዚ ባርካ ኬዚ ቦ። ");
INSERT INTO gmve_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","ጊዶ ኣቲን ሄ ኣይሌይ፥ ‹ታኒ ታ ጎዳ፥ ታ ማቺዮኔ ታ ናይታ ሲቃይስ፤ ታኒ ኣይሌቴꬃፌ ኬዚኬ› ጊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ኢዛ ጎዳይ ኢዛ ፒርዲዛ ኣሳ ሲንꬅ ኣꬆ፤ ሄሳፌ ጉዬ ኬꬃ ፔንጌ ዎይኮ ፔንጌ ቆሲላꬃኮ ኢዛ ኤፊዲ ኢዛ ሃይꬅ ጎንꬃን ሉኮ። ሂስቲኮ ኢዚ ባ ዴኦ ላይꬅ ኡባን ኢዛስ ኣይሌ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","«ኣሲ ባ ማጫ ናዮ ኣይሌቴꬃስ ባይዚኮ ኣዴ ኣይሌቲ ኣይሌቴꬃፌ ኬዚዛ ማላ ኢዛ ኬዙፑ። ");
INSERT INTO gmve_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ኢዛ ባና ዶሪዲ ኤፊዳ ጎዳ ኡፋይሶንታ ኢጺኮ ኢዚ ጎዳይ ኢዞ ዎዚሳናስ ኮሼስ። ኢዚ ኢዚስ ኣማኔቶንታ ኣጊዳ ጊሻስ ኢዞ ኣላጋስ ባይዛና ቤሴና። ");
INSERT INTO gmve_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ኢዚ ኢዞ ባ ናስ ኤካናስ ኮይኮ ባ ማጫ ናስ ኦꬂዛ ማላ ኢዚስ ቤሲዛይሳ ኦꬆ። ");
INSERT INTO gmve_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ኢዚ ባስ ሃራ ማቾ ኤኪኮ ኮይሮ ማቼይስ ቁማ ዎይኮ ማይኦ ፓጪሶፖ፤ ቃሴ ኢዚራ ኣቆ ኣጎፎ። ");
INSERT INTO gmve_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ኢዚ ሃይታ ሄꬓታ ኢዚስ ኢሞንታ ኢጺኮ ኣይኮ ሚሼይካ ቃንጼቶንታ ኣይሌቴꬃፌ ኬዛዳ ቡ። ");
INSERT INTO gmve_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«ኣስ ዎꬊዳ ኣሲ ሃይቃናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","ጾሳ ሼኔ ጊዲ ኡቲን ቆፖንታ ዲሼ ኣስ ዎꬊዳዴይ ታኒ ጊግሲዳሶ ቤቴ ቦ። ");
INSERT INTO gmve_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ጊዶ ኣቲን ኣስ ዎꬋና ቆፒዲ ኤሪሼ ሃራ ኣስ ዎꬊኮ ሄሳዴይ ኣታናስ ጊዲ ሄ ታ ጊግሲዳ ታስ ያርሾ ሺሺዛሶ ዪኮ ያርሺዛሶሆዛፔ ሃራሶ ኤፋዳ ዎꬋ። ");
INSERT INTO gmve_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","«ባ ኣዋ ዎይኮ ባ ኣዮ ዋꬊዛ ኣሲ ኦኒካ ሃይቆ። ");
INSERT INTO gmve_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","«ኣሳ ዎልቃን ኦይኪዲ ባይዚዛዴይ ዎይኮ ዎልቃን ኦይኪን ኣሲ ኢዛ ኩሼን ቤቲዳዴይ ሃይቃናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","«ባ ኣዋ ዎይኮ ባ ኣዮ ጫዪዛዴይ ሃይቆ። ");
INSERT INTO gmve_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","«ናምኡ ኣሳቲ ባ ጋርሳን ኦዬቲኮ፥ ኢሶይ ኢሳ ሹቻራ ጫዲኮ ዎይኮ ኩሼራ ኢጪኮ ሄ ቆሄቲዳዴዚ ሃይቆንታ ሃርጊዲ ሂጻን ኢቺኮ፥ ");
INSERT INTO gmve_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ሄሳፌ ዴንዲዲ ጉፌራ ካሬ ጊዶን ሄሜቲኮ፥ ሄ ቆሂዳይሲ ቃጻዬቶንታ ኣቴስ፤ ጊዲኮካ ኢዚ ኢዛ ኦሶ ቴቂዳ ጊሻስ ሚሼ ቃንጻናሲኔ ኢዚ ፓጻና ጋካናስ ኢዛ ጼላናስ ኮሼስ። ");
INSERT INTO gmve_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","«ኣሲ ባ ኣቱማ ኣይሌ ዎይኮ ማጫ ኣይሌዮ ጉፌን ሾጪኮ ሄ ሾቻ ጌዶን ሄራካ ኢዛ ኩሼን ሃይቂኮ ሾጪዳይሲ ቃጻዬታናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ጊዶ ኣቲን ሄ ቆሄቲዳይሲ ኢሲ ጋላስ ዎይኮ ናምኡ ጋላስ ጋካናስ ሃይቆንታ ኣጊኮ ሄ ኣይሌዚ ኢዛ ሚሽ ጊዲዳ ጊሻስ ኢዚ ቃጻዬቴና። ");
INSERT INTO gmve_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","«ናምኡ ኣሳቲ ባ ጋርሳን ኢሶይ ኢሳራ ኦዬቲሼ ቃንꬃራ ዲዛ ማጫሳዮ ቦሻስ ጋꬂኮ፥ ሄሳፌ ሃራ ኢታ ሚሽ ኢዚ ቦላ ጋꬆንታ ኣጊኮ፥ ኢዚ ቦላ ቆሆ ጋꬂዳዴይ ሄ ማጫሳይ ኣዚናይ ኦይቺዳይሳ ዳናቲ ፒርዲኮ ኣይ ሚሼካ ቃንጾ። ");
INSERT INTO gmve_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ጊዶ ኣቲን ኢዚስ ቦሻይ ዳሪኮ ሼምፖ ጊሻስ ሼምፖ፥ ");
INSERT INTO gmve_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ኣይፌ ጊሻስ ኣይፌ፥ ኣቻ ጊሻስ ኣቻ፥ ኩሼ ጊሻስ ኩሼ፥ ቶሆ ጊሻስ ቶሆ፥ ");
INSERT INTO gmve_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ጹሳ ጊሻስ ጹስ፥ ማዱንꬃ ጊሻስ ማዱንꬅ፥ ቆኦ ጊሻስ ቆኦ ኤካናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","«ኢሲ ኣሲ ኣቱማ ዎይኮ ማጫ ኣይሌ ኣይፌ ሾጪ ቶይሲኮ ሄ ኣይፌዛ ጊሻስ ኣይሌቴꬃፌ ኬሲ ዬዶ። ");
INSERT INTO gmve_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ሄሳꬆካ ባ ኣይሌይ ዎይኮ ባ ኣይሌዛ ኣች ሜንꬂኮ ሄ ኣቻ ጊሻስ ኣይሌቴꬃፌ ኬሲ ዬዶ። ");
INSERT INTO gmve_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","«ቦራይ ማጫስ ዎይኮ ኣቱማስ ኢጪ ዎꬊኮ፥ ሄ ቦራይ ሹቻን ጫዴቲ ሃይቆ፤ ኢዛ ኣሾይ ሜቴቶፎ። ጊዶ ኣቲን ቦራ ጎዳይ ቃጻዬቶፎ። ");
INSERT INTO gmve_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","ጊዶ ኣቲን ቦራይ ካሴካ ኢጪዛ ቦራ ጊዲኮ፥ ኣሳይ ቦራዛ ጎዳስ ዮቲዲሺን ቦራ ጎዳይ ቦራ ቃቾንታ ኣጊኮ፥ ቦራይ ኣዴ ዎይኮ ማጫ ኣስ ዎꬊኮ ሄ ቦራይ ሹቻን ጫዴቲ ሃይቆ፤ ቃሴ ቦራዛ ጎዳይካ ሃይቆ። ");
INSERT INTO gmve_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ጊዶ ኣቲን ኢዚ ጪጎ ቃንጻና ማላ ኦይሼቲኮ ኢስቲ ኦይቺዳይሳ ኣይ ጊዲኮካ ቃንጺዲ ባ ሼምፖ ዎዞ። ");
INSERT INTO gmve_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ቦራይ ኣቱማ ና ዎይኮ ማጫ ና ኢጪ ዎꬊኮ ፒርዳይ ኢሲ ማላ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ቦራይ ኣቱማ ኣይሌ ዎይኮ ማጫ ኣይሌዮ ኢጪ ዎꬊኮ ቦራ ጎዳይ ኣይሌዛ ጎዳስ ሄꬑ ታሙ ቢራ ጪጎ፤ ቦራይካ ሹቻን ጫዴቲዲ ሃይቆ። ");
INSERT INTO gmve_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","«ኢሲ ኣሲ ኦላ ካማ ቃሪኮ ዎይኮ ኦላ ቦኪዲ ካሞንታ ኣጊኮ፥ ቦራይ ዎይኮ ሃሬይ ሄ ኦላን ዉሊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ሄ ኦላዛ ጎዳይ ሜሄዛ ዋጋ ቃንጾ። ኢዚ ሜሄዛ ጎዳስ ዋጋ ቃንጺዲ ሃይቄꬃ ባስ ኤኮ። ");
INSERT INTO gmve_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","«ኢሲ ኣሳ ቦራይ ሃራ ኣሳ ቦራ ኢጪ ዎꬊኮ፥ ኢጪ ዎꬊዳ ፓጻ ቦራ ባይዚዲ ኢዛ ሚሻኔ ሃይቂዳ ቦራዛ ኣሾዛ ጊዶን ጊና ሻኪ ኤኬቶ። ");
INSERT INTO gmve_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ጊዶ ኣቲን ሄ ቦራይ ኢጪዛ ቦራ ጊዲዳይሲ ካሴቲ ኤሬቲሺን፥ ኢዛ ጎዳይ ኢዛ ቃቾንታ ኣጊኮ፥ ኢዛ ጎዳይ ቦራ ጊሻስ ቦራ ቃንጺዲ ሄ ሃይቂዳይሳ ባስ ኤኮ። ");
INSERT INTO gmve_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","«ኢሲ ኣሲ ቦራ ዎይኮ ዶርሳ ካይሶቲ ኤኪዲ ሹኪኮ፥ ዎይኮ ባይዚ ኤኪኮ፥ ኢሲ ቦራ ጊሻስ ኢቻሹ ቦራ፥ ኢሲ ዶርሳ ጊሻስ ኦይዱ ዶርስ ቃንጾ። ");
INSERT INTO gmve_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","«ካይሶይ ኬꬅ ቦኪሼ ኦይኬቲዲ ሾጬቲ ሃይቂኮ ሾጪዳይሲ ሱꬅ ጉሲዳ ጊሻስ ኦይቼቴና። ");
INSERT INTO gmve_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","ጊዶ ኣቲን ሄሲ ጋዴይ ዎንቲ ጌዪን ሃኒዛ ጊዲኮ ኢዚ ሄ ጉኪዳ ሱꬃ ኣጮን ኦይሼቴስ። ካይሶዚ ካይሶቲዳይሳ ቃንጾ፤ ጊዶ ኣቲን ኢዛስ ኣይኮይካ ባይንዳ ጊዲኮ ካይሶቲዳይሳ ቃንጻናስ ኢዚ ባይዜቶ። ");
INSERT INTO gmve_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","ኢዚ ካይሶቲዳ ሜሄይ ፓጻ ዲሼ ኢዛ ኩሼን ቤቲኮ፥ ቦራ ዎይኮ ሃሬ ዎይኮ ዶርሳ ጊዲኮካ ኢዚ ባ ካይሶቲዳይሳስ ናምኡ ኩሼ ቃንጾ። ");
INSERT INTO gmve_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","«ኢሲ ኣሲ ባ ሜሄ ዴምባን ዎይኮ ኣይፌይ ሜቴቲዛ ሚꬃ ጊዶን ሄሚሼ፥ ሜሄታ ሃራ ኣሳ ካꬃን ላኣ ዬዲ ሄሚኮ፥ ኢዚ ባ ካꬃፌ ዎይኮ ኣይፌይ ሜቴቲዛ ባ ሚꬃ ኡባፌ ሎኢዛይሳ ኣፊላማ ቃንጾ። ");
INSERT INTO gmve_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","«ኢሲ ኣሲ ቡራ ጹጊኮ ታማይ ዴንዲዲ ቡራዛ ዉርሲዲ ዶሬን ዲዛ ካꬅ ዎይኮ ኤቆን ዲዛ ካꬃ ሙሌራ ሚዛ ጊዲኮ ኮይሮ ታማ ኦይꬂዳ ኣዴዚ ኣፊላማ ቃንጾ። ");
INSERT INTO gmve_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","«ኢሲ ኣሲ ቢራ ዎይኮ ሃራ ሚሽ ናጊሳናስ ባ ሾሮስ ሃዳራ ኢሚኮ፥ ሾሮዛሶፔ ሄ ሚሻ ካይሶቲዳ ካይሶዚ ኦይኬቲኮ፥ ካይሶዚ ሄ ሚሻስ ናምኡ ኩሼ ቃንጾ። ");
INSERT INTO gmve_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ጊዶ ኣቲን ካይሶዚ ቤቶንታ ኢጺኮ፥ ሃዳራ ኤኪዳ ኣዴዚ ፒርዲዛይታኮ ሺቂዲ ሃዳራ ሚሻ ኢዚ ሞንታይሳስ ጫቆ። ");
INSERT INTO gmve_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","«ኣሲ ኣይ ሞቶንካ ቦራ ጌዶን፥ ዎይኮ ሃሬ ጌዶን፥ ዎይኮ ዶርሳ ጌዶን፥ ዎይኮ ማይኦ ጌዶን፥ ዎይኮ ሃራ ꬋይዳ ሚሻ ጌዶን፥ ‹ሃይሲ ታይሳ› ጊዲ ሞቴቲኮ፥ ናምኡ ባጋይካ ባ ዮኦዛ ፒርዲዛይታ ሲንꬅ ኣꬄቶ፤ ፒርዲዛይቲ ዎርዶሲዳ ኣሲ ሃንኮይሳስ ናምኡ ኩሼ ቃንጾ። ");
INSERT INTO gmve_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","«ኣሲ ባ ሾሮስ ሃሬ፥ ዎይኮ ቦራ፥ ዎይኮ ዶርሳ፥ ዎይኮ ሃራ ኣይ ሜሄካ ሃዳራ ኢሚን ኦኒካ ቤኦንታ ሃይቂኮ፥ ዎይኮ ቆሄቲኮ፥ ዎይኮ ኣሲ ቦንቂ ኤፊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ሃዳራዴይ ባ ሾሮ ሜሄዛ ቦቾንታይሳስ ጎዳ ሲንꬃን ጫቂኮ፥ ኢስታ ጊዶን ዲዛ ዮኦዚ ዉሬስ። ሄ ሜሄዛ ጎዳይ ጫቆዛ ኤኮ፤ ቃንጺሳናስ ቤሴና። ");
INSERT INTO gmve_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ጊዶ ኣቲን ሜሄዚ ሃዳራዴፌ ካይሶቴቲዳ ጊዲኮ ሜሃዴስ ቃንጾ። ");
INSERT INTO gmve_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ሄ ሜሄዛ ዶኣይ ሚዳ ጊዲኮ፥ ማርካ ጊዳና ማላ ዶኣይ ሚሺን ኣቲዳይሳፌ ኤኪ ኤሂ ቤሶ፤ ሂስቲዲ ሜቴቲዳ ሜሄዛ ጊሻስ ቃንጾፎ። ");
INSERT INTO gmve_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","«ኣሲ ባ ሾሮፔ ሜሄ ጋርጺ ኤኪኮ ኢዛ ጎዳይ ባይንዳሶን ሄ ሜሄይ ቆሄቲኮ ዎይኮ ሃይቂኮ ሄ ሜሄዛ ጊሻስ ቃንጾ። ");
INSERT INTO gmve_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ጊዶ ኣቲን ኢዛ ጎዳይ ኢዛራ ዲኮ፥ ጋርጺዳይሲ ቃንጾፎ፤ ኪራስ ኤኪዳ ጊዲኮ ኪራስ ጪጊዛ ሚሻይ ኣጮዛስ ቃንጾ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","«ኢሲ ኣሲ ኣዚናስ ጊጎንታ ጌላኦዮ ባሌꬂዲ ኢዚራ ዚንኢዛ ጊዲኮ ኢዞ ጪሎሺዲ ባስ ማቾ ኤኮ። ");
INSERT INTO gmve_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ኢዚ ኣዋይ ኢዞ ኢዛስ ኢሞንታ ኢጺኮ፥ ጌላኦዮ ኤኪዛ ኣሲ ጪሎሻስ ኢሜቲዛ ሚሻ ኬና ቢራ ኢዚ ኣዋስ ኢሞ። ");
INSERT INTO gmve_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","«ቢታ ቢቲዛ ማጫስ ፓጻ ዎꬆፋ። ");
INSERT INTO gmve_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","«ሜሄራ ጋጊዛ ኣሲ ኦኒካ ሃይቆ። ");
INSERT INTO gmve_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","«ጎዳስ ጻላላፔ ኣቲን ሃራ ጾሳስ ሹኪ ያርሺዛ ኣሲ ኦኒካ ሃይቂ ꬋዮ። ");
INSERT INTO gmve_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","«ቤቲዲ ዪዳ ኣስ ቆሆፒቴ፥ ዎይኮ ዋዪሶፒቴ፤ ጋሶይካ ኢንቴካ ጊብጼ ቢታን ቤቴ ጊዲዲ ዴኢዴታ። ");
INSERT INTO gmve_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","ኣዚናይ ሃይቂዳ ኣምኤዮኔ ኣዋይ ዎይኮ ኣያ ሃይቂዳ ና ዋዪሶፒቴ። ");
INSERT INTO gmve_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ኢንቴ ኢስታ ዋዪሲን ኢስቲ ታኮ ዋሲኮ ታኒ ኢስታ ዋሶ ቱማፔ ሲያና፤ ");
INSERT INTO gmve_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ሄ ዎዴ ታ ሃንቆይ ኢንቴ ቦላ ዴንዳና፤ ታኒ ኢንቴና ማሻን ዉርሳና፤ ኢንቴ ማቼቲ ኣምኤታ ኢንቴ ናይቲካ ኣዋይ ባይንዳ ዪኦ ናይታ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","«ኢንቴ ጊዶን ዲዛ ታ ኣሳስ ኢሲ ማንቆ ኣሳስ ሚሼ ታልኢኮ፥ ባ ሚሽ ዲቻስ ኢሚዛ ኣሳ ማላ ሃኖፒቴ፤ ኔኒ ዬሎ ኢዛ ኦይቾፋ። ");
INSERT INTO gmve_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ኔኒ ኢሲ ሚሻ ጊሻስ ኔ ላጌ ማይኦ ኦይኪኮ ኣርሼይ ዉሎንታ ዲሺን ኢዛስ ዛራ። ");
INSERT INTO gmve_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ኣዛስ ጊኮ ኢዚ ባ ካሎ ካሚዛይ ኢዚን ጻላ፤ ሃራ ኣይ ማይኢዲ ኣቃናስ ዳንዳይዜ? ኢዚ ታስ ዋሲኮ ታ ሚሼቲዛ ጊሻስ ኢዛስ ሲያናኔ ኢዛ ማዳና። ");
INSERT INTO gmve_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","«ጾሳ ቦላ ጫሻ ቃላ ሃሳዮፓ፥ ዎይኮ ዴሬ ኣይሲዛዴ ቃንጎፋ። ");
INSERT INTO gmve_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","«ኔ ካꬃ ጼራ፥ ዎይኔ ሚꬃ ኣይፌ ጼራኔ ዎጋራ ዛይቴ ታስ ያርሾ ሺሻ። ኔኒ ኔ ኣቱማ ናይታ ጊዶን ባይራቲዛ ና ታስ ኢማናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","ቦራፔ፥ ዴይሻፌኔ ዶርሳፌካ ሄሳꬆ ኦꬃ። ኢስቲ ላፑን ጋላሳይ ጋካናስ፥ ባ ኣዪራ ኣዪራ ጋምኤቶ፤ ኦስፑንꬃ ጋላስ ኢስታ ታስ ኢማ። ");
INSERT INTO gmve_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","«ኢንቴ ታስ ጌሻ ኣስ ጊዳናስ ኮሼስ፤ ሄሳ ጊሻስ ዶኣይ ዴምባን ዎꬊዳ ዎይኮ ዳፊ ዳኪዳ ሜሄ ኣሾ ካናስ ዬጊቴ ኣቲን ሞፒቴ። ");
INSERT INTO gmve_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«ዎርዶ ዮኦ ላሎፋ፤ ዎርዶ ማርካታዳ ኢታ ኣስ ማዶፋ። ");
INSERT INTO gmve_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","«ኢታ ሚሽ ኦꬃናስ ዳሮ ኣሳ ካሎፋ፤ ፒርዳ ሚርቃናስ ዳሮ ኣሳራ ጊዳዳ ማርካቶፋ። ");
INSERT INTO gmve_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ማንቆ ኣሲ ፒርዳሶ ሺቂኮ ኢዛ ማንቆቴꬅ ቤኣዳ ማዳ ፒርዶፋ። ");
INSERT INTO gmve_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","«ኔ ሞርኬ ቦራይ ዎይኮ ሃሬይ ꬋይዳይሳ ዴሚኮ ኢዛዴስ ዛራ ኢማ። ");
INSERT INTO gmve_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ኔና ኢጺዛ ኣሳስ ሃሬይ ጫናራ ኩንዲ ዲሺን ቤኢኮ ኢዛራ ማዴታዳ ዴንꬃ ኣቲን ሄን ኣጋጎፓ። ");
INSERT INTO gmve_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","«ፒርዳስ ዱቡሻን ሺቃዳ፥ ማንቆ ኣሳ ፒርዳ ዎቢሶፓ። ");
INSERT INTO gmve_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ዎርዶ ሞቶ ሲዮፓ፤ ጌሽ ዎይኮ ጺሎ ኣስ ሃይቆስ ኣꬃ ኢሞፋ፤ ኣይስ ጊኮ ሞሮ ኦꬂዳዴ ታኒ ሜላ ዬዲኬ። ");
INSERT INTO gmve_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","«ማታኤ ኤኮፋ፤ ኣዛስ ጊኮ ማታኤይ ጼሊዛይታ ኣይፌ ቆቂሴሲኔ ጺሎታ ቃላ ሚርቄስ። ");
INSERT INTO gmve_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","«ሃራ ዴሬፔ ዪዳ ቤቴ ኣስ ቆሆፒቴ፤ ቤቴ ኣስ ጊዴꬂ ኣይ ማላ ዴጺዛኮ ኢንቴ ኤሬታ፤ ኣይስ ጊኮ ኢንቴ ኢንቴ ሁኤን ቤቴ ጊዲዲ ጊብጼ ቢታን ዴኢዴታ። ");
INSERT INTO gmve_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«ኡሱፑን ላይꬅ ጋካናስ ኔ ጎያዳ ዜሪዳ ካꬃ ማጻ ሺሻ። ");
INSERT INTO gmve_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ላፑንꬃ ላይꬃን ጋዴዛ ጎዮንታ ሻቻ፤ ሂስቲኮ ኔ ዴሬ ጋርሳን ዲዛ ማንቆቲ ሄሳፌ ማና ካꬅ ዴማና፤ ቃሴ ኢስታፌ ኣቲዛይሳ ዶኣቲ ማና። ኔኒ ኔ ዎይኔ ቶኪዛ ጋዴ ቦላኔ ዛይቴ ኢሚዛ ዎጋራ ሚꬃ ጋዴ ቦላካ ሄሳꬆ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","«ኡሱፑን ጋላስ ኔ ኦሶ ኦꬃ፤ ኔ ቦራይኔ ኔ ሃሬይ ሼምፓና ማላኔ ኔሶን ዬሌቲዳ ኣይሌይኔ ቤቴ ኣሲ፥ ሼምፓና ማላ፥ ላፑንꬃ ጋላስ ኦሶ ኦꬆፋ። ");
INSERT INTO gmve_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","«ታኒ ኢንቴና ጊዳይሳ ኡባ ሚንꬂዲ ኦꬂቴ፤ ሃራ ጾሳታ ሱንꬅ ጼይጎፒቴኔ ኢስታ ዎሶፍቴ። ");
INSERT INTO gmve_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«ላይꬃን ሄꬑቶ ኢንቴ ታስ ባኣሌ ቦንቺቴ። ");
INSERT INTO gmve_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","ኣቢቤ ጌቴቲዛ ኣጊናን ባሬቲዳ ጋላሳን ኡኬꬃ ባኣሌ ቦንቺቴ፤ ኣይስ ጊኮ ኢንቴ ጊብጼፔ ኬዚዳይ ሄ ኣጊናና። ታኒ ኢንቴና ኣዛዚዳ ማላ ላፑን ጋላስ ኢርሾይ ጌሎንታ ኡኬꬅ ሚቴ። «ኢንቴፌ ኢሳዴይካ ታ ሲንꬃን ሜላ ኩሼ ቤቶፎ። ");
INSERT INTO gmve_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","«ቃሴ ኢንቴ ኢንቴ ጋዴን ዜሪን፥ ኮይሮ ጋኪዳ ካꬅ ማጺዛ ዎዴ፥ ካꬃ ጼራ ሺሺዛ ባኣሌ ቦንቺቴ። «ቃሴካ ላይꬃ ዉርሴꬃን፥ ካꬅ ኡባ ሺሺ ዉርሲዛ ዎዴ፥ ካꬃ ሺሾ ባኣሌ ቦንቺቴ። ");
INSERT INTO gmve_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","ኣዴቲ ዉሪ ኡባ ሃሪዛ ጎዳ ታ ሲንꬅ ላይꬃን ሄꬑቶ ዬቶ። ");
INSERT INTO gmve_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","«ኔኒ ያርሾ ሱꬅ ታስ ሺሻሼ ኢርሾራ ኡኬቲዳ ኡኬꬃራ ሺሾፋ። ሄ ባኣሌዛ ቦንቺዛ ጋላስ ያርሼቲዳ ሞꬌፔ ማላዶስ ኣይኮይካ ኣቶፎ። ");
INSERT INTO gmve_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","ኔ ጋዴን ባይራ ካጺዳ ካꬃ ኡባፌ ሎኢዛይሳ ጎዳ ኔ ጾሳ ሶ ኤካ ያ። ዴይሻ ላቃ ኢዛ ኣዬይ ማꬃን ዶይሶፋ። ");
INSERT INTO gmve_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«ኔ ኦጌን ኔና ናጋና ማላኔ ታኒ ኔስ ጊግሲዳሶ ኔና ኤፋና ማላ፥ ታኒ ኪታንቻ ኔ ሲንꬃራ ዬዳና። ");
INSERT INTO gmve_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ኢዚ ዮቲዛይሳ ኤሮ ጋዳ ኢዛስ ኣዛዜታ፤ ኢዛ ቦላ ማካሎፋ፤ ታ ኢዛ ኪቲዳ ጊሻስ ኢንቴ ናጋራ ኦꬂኮ ኢንቴስ ኢዚ ኣቶ ጌና። ");
INSERT INTO gmve_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","ኢዚ ዮቲዛይሳ ኢንቴ ሎኤꬂ ሲዪኮ፥ ታኒ ዮቲዛይሳ ኡባ ኦꬂኮ ኢንቴ ሞርኬታ ኡባ ታኒ ሞርካና፤ ኢንቴናራ ኤቄቲዛይታራ ታኒካ ኤቄታና። ");
INSERT INTO gmve_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ታ ኪታንቻይ ኢንቴፌ ሲንꬄ ቢዲ፥ ኢንቴና ኣሞሬታ ቢታ፥ ሂቴታ ቢታ፥ ፓሪዜታ ቢታ፥ ካናኔታ ቢታ፥ ሂዌታ ቢታኔ ያቡሴታ ቢታ ኤፋና። ታኒ ኢስታ ሙሌራ ꬋይሳና። ");
INSERT INTO gmve_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","ኢስታ ኤቃታ ሲንꬃን ሆኮፍቴ፥ ዎይኮ ጎይኖፍቴ፥ ዎይኮ ኢስታ ሃኖ ቁሎፍቴ። ኢንቴ ኢስታ ꬋይሳናሲኔ ቱሳ ማላ ኤቂ ዲዛ ኢስታ ሹቻ ኤቃታ ሜንꬄሬꬃናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","ጎዳ ኢንቴ ጾሳስ ጎይኒቴ፤ ሂስቲኮ፥ ኢዚ ኢንቴና ካꬃኒኔ ሃꬃን ኣንጃና፤ ታ ኢንቴ ጊዶፌ ሃርጌ ዲጋና። ");
INSERT INTO gmve_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ኢንቴ ቢታን ኣይ ማጫሲካ ቦሼቴናኔ ማይኔና። ታኒ ኢንቴ ዳና ላይꬅ ኣዱሳና። ");
INSERT INTO gmve_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","«ኢንቴናራ ጋጊዛ ዴሬታ ኡባ ዳጋንꬃና ማላ ታኒ ታ ያሻቴꬅ ኢንቴ ሲንꬃራ ዬዳና፤ ኢንቴ ሞርኬቲ ዉሪ ኢንቴስ ዞኮ ዛሪዲ፥ ባቃታና ማላ ታ ኦꬃና። ");
INSERT INTO gmve_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ታኒ ኢንቴፌ ሲንꬃራ ካዤ ዬዳዳ ሂዌታ፥ ካናኔታኔ ሂቴታ ጎዳ ኬሳና። ");
INSERT INTO gmve_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ጊዶ ኣቲን ቢታይ ካሎ ኣቶንታ ማላኔ ዶኣይ ዳሮንታ ማላ፥ ታ ኢስታ ኢሲ ላይꬃ ጋርሳን ጎዲኬ። ");
INSERT INTO gmve_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","ጊዶ ኣቲን ኢንቴ ቆዳን ዳሪዲ፥ ሄ ቢታ ላታና ጋካናስ፥ ታኒ ኢስታ ጉꬅ ጉꬅ ጎዳ ኬሳና። ");
INSERT INTO gmve_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","ታኒ ኢንቴ ዛዋ ዞኦ ኣባፌ ሜዲቴራኔ ኣባ ጋካናስ፥ ባዞፌ ኤፊራጺሴ ሻፋ ጋꬃና። ሄ ቢታን ዲዛዝ ኡባ ታኒ ኢንቴ ኩሼን ኣꬃ ኢማና፤ ኢንቴካ ኢስታ ኢንቴ ሲንꬃፌ ጎዲ ኬሳና። ");
INSERT INTO gmve_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","ኢስታራ ዎይኮ ኢስታ ኤቃ ጾሳታራ ጫቆን ጌሎፒቴ። ");
INSERT INTO gmve_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","ኢስታ ኢንቴ ቢታን ዎꬆፍቴ፤ ኢንቴ ሂስቶንታ ኣጊኮ ኢስቲ ኢንቴና ታ ቦላ ናጋራ ኦሲሳና፤ ኣይስ ጊኮ ኢስታ ኤቃታስ ጎይኒዛይሲ ቱማፔ ኢንቴስ ናርጻ ጊዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ጎዳይ ሙሴ፥ «ኔኒ፥ ኣሮኔይ፥ ናዳቤይ፥ ኣቢሁይኔ ኢስራኤሌፔ ላፑን ታሙ ዴሬ ሃላቃቲ ጎዳኮ ዙማ ቦላ ፑዴ ኬዚዲ ሃሆን ኤቂዲ ታስ ጎይኒቴ። ");
INSERT INTO gmve_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","ጊዶ ኣቲን ኔኒ ኔርካ ታኮ ሺቃ፤ ሃራቲ ታ ማታ ሺቆፔቶ። ቃሴ ኣሳይካ ኔናራ ፑዴ ኬዞፖ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","ሙሴይ ዪዲ ጎዳ ቃላኔ ኢዛ ዎጋ ኡባ ኣሳስ ዮቲን ኣሳይ ዉሪ ኢሲ ቃላን፥ «ጎዳይ ዮቲዳይሳ ኡባ ኑኒ ኦꬃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","ሙሴይ ጎዳይ ዮቲዳይሳ ኡባ ጻፊዴስ። ዎንቴꬃ ጋላስ ማላዶ ዎንታራ ዴንዲዲ ዙማ ጋርሳን ያርሺዛሶ ጊግሲዲ ኢስራኤሌ ኣሳ ታማኔ ናምኡ ቆሞታ ሱንꬃን ታማኔ ናምኡ ሹች ቱሳ ማላ ኤሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ኢዚ ኢስራኤሌ ኣሳፔ ናቴꬃ ኣቱማ ናይታ ኪቲን፥ ኢስቲ ቢዲ ጎዳስ ሚርጎታ ጹጌቲዛ ያርሾኔ ኢሲፌቴꬃ ያርሾ ሂስቲ ያርሺዳ። ");
INSERT INTO gmve_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","ሙሴይ ሱꬃፌ ባጋ ኤኪዲ ኬሬታን ቆሊዴስ፤ ኣቲዳ ሱꬃ ያርሾ ያርሺዛ ሶሆዛን ጫጫፊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ሄሳፌ ጉዬ ጫቆ ቃላ ማጻፋ ኤኪዲ ኣሳስ ꬎቁ ሂስቲዲ ናባቢን ኣሳይ፥ «ጎዳይ ዮቲዳይሳ ኡባ ኑኒ ኦꬃናኔ ኣዛዜታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ሙሴይካ ኬሬታን ኣቲዳ ሱꬃ ኤኪዲ ኣሳ ቦላ ዉጺዲ ኣሳ፥ «ቤኢቴ፥ ሃይሲ ጎዳይ ሃይታ ቃላታ ኢንቴስ ኢሚሼ ኢንቴናራ ዎꬂዳ ጫቆ ሱꬃ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ሄሳፌ ጉዬ ሙሴይ፥ ኣሮኔይ፥ ናዳቤይ፥ ኣቢሁይኔ ኢስራኤሌ ሃላቃታፔ ላፑን ታማቲ ፑዴ ኬዚዲ፥ ");
INSERT INTO gmve_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ኢስራኤሌ ጾሳ ቤኢዳ፤ ኢስቲ ቤኦይሲካ ኢዛ ቶሆፔ ጋርሳራ ሳሎ ማላ ጌዪ ኡቲዳ ሲምፔሬ ጌቴቲዛ ሹቻፌ ኦሴቲዳ ሚሽ ሚሳቲዛ ዉይጌ ዲዛይሳኮ። ");
INSERT INTO gmve_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ጊዶ ኣቲን ጾሲ ኢስራኤሌ ኣሳ ሃላቃታ ዎꬊቤና፤ ኢስቲ ጾሳ ቤኢዳ፤ ኢዛ ሲንꬃን ሚዳኔ ኡዪዳ። ");
INSERT INTO gmve_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","ጎዳይ ሙሴስ፥ «ኔኒ ታኮ ዙማ ቦላ ፑዴ ሃያ፤ ሃ ታኮ ኬዛዳ ሃን ጋምኣ፤ ሂስቲኮ ኔኒ ዎጋ ታማርሳና ማላ ታኒ ዎጋኔ ኣዛዞ ኢዛ ቦላ ጻፊዳ ሎቻ ሹቻታ ኔስ ኢማና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","ሄሳፌ ጉዬ ሙሴይ ባ ኣይሌ ኢያሶራ ባና ኬዚን ሙሴይ ፑዴ ጾሳ ዙማ ቦላ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","ኢስራኤሌ ኣሳ ሃላቃታ ኢዚ፥ «ኑኒ ኢንቴኮ ሲማናሼ ጋካናስ ሃይሳን ዲሺቴ፤ ኣሮኔይኔ ሁሬይ ሃን ኢንቴናራ ዴቴስ፤ ዮኦይ ዲዛ ኣሲ ኦኒካ ኢስታኮ ቦ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","ሙሴይ ዙማ ቦላ ፑዴ ኬዚን ጾሳ ሻራይ ዙማ ካሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ጎዳ ቦንቾይካ ሲና ዙማ ቦላ ዎꬊ ጋምኢዴስ፤ ኡሱፑን ጋላስ ጋካናስ ሻራዚ ዙማ ጎዚ ኦይኪዴስ፤ ላፑንꬃ ጋላሳን ሻራ ጊዶራ ጎዳይ ሙሴ ጼይጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ኢስራኤሌ ናይታስ ጎዳ ቦንቾይ ዙማ ጼራን ኤጺዛ ታማ ሚሳቲዲ ቤቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","ሄሳፌ ጉዬ ሙሴይ ሄ ሻራ ጊዶ ጌሊዲ ፑዴ ዙማ ቦላ ኬዚዲ ሄን ኦይዱ ታሙ ጋላሲኔ ኦይዱ ታሙ ቃማ ጋምኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«ታስ ኢሞታ ኤሃና ማላ ኔኒ ኢስራኤሌ ናይታስ ዮታ፤ ታስ ኢማናስ ኢዛ ዎዚናይ ኢዛ ኢማ ኢማ ጊን ኢሚዛ ኣሳ ኢሞታ ኡባ ኔ ታስ ኤካ። ");
INSERT INTO gmve_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ኢንቴ ኢስታፌ ኤካና ኢሞታይ ሃይታንታ፤ ዎርቃ፥ ቢራ፥ ጻርቂማላ፥ ");
INSERT INTO gmve_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ሳሎ ሚሳቲዛ ቃጪና፥ ኦቻ ቴራ ሚሳቲዛ ቃጪና፥ ጼቃ ዞኦ ቃጪናኔ ቦꬃ ሊቆ ላይኖ፥ ዴይሻ ኢስኬ፥ ");
INSERT INTO gmve_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ꬋርሾ ኢቴ ዞኦ ቃላሜን ዬጊ ኬሲዳይሳ፥ ኣባ ጊዶን ዲዛ ኢሲ ዶኣ ጋልባ፥ ኦዶሮ ሚꬅ፥ ");
INSERT INTO gmve_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ጾምፔስ ዎጋራ ዛይቴ፥ ቲዬቲዛ ዛይቴሲኔ ኤጻኔስ ሳዊሲዛ ቂማሜ፥ ");
INSERT INTO gmve_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ኤፉዴኒኔ ቲራ ቦላን ዲዛ ኪሴታ ጊዶን ዎꬂዛ ማርጊዴ ጌቴቲዛ ሹቻታኔ ሃራ ኣልኦ ሹቻታ። ");
INSERT INTO gmve_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","«ሂስቲዲ ታኒ ኢስታ ጊዶን ኣቃና ማላ ኢስቲ ታስ ዱማ ጎይኒዛ ሶ ጊጊሴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ጾሳ ዱንካኔዛኔ ኢዛ ጊዶን ዲዛ ሚሻታ ታኒ ኔና ቤሲዛ ሌሚሶዛ ማላ ኦꬂቴ። ");
INSERT INTO gmve_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«ኢስቲ ኦዶሮ ሚꬃፌ ኣዱሳቴꬃይ ናምኡ ዋꬋኔ ባጋ፥ ጎምፓይ ኢሲ ዋꬋኔ ባጋ፥ ꬎቃቴꬃይ ቃሴ ኢሲ ዋꬋኔ ባጋ ጊዲዛ ታቦታ ኦꬄቶ። ");
INSERT INTO gmve_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ሶ ባጋኔ ካሬ ባጋ ዋላካይ ባይንዳ ዎርቃን ሜሻ፤ ኢዛ ዩዪ ኣꬋናስ ቦላ ባጋ ጻንጻ ዎርቃራ ዩሻ ኣꬃ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ታቦታስ ኦይዱ ዎርቃ ሳጋዮታ ኦꬃዳ ኦይዱ ቶሆታን ኢሲ ባጋራ ናምኡ ሳጋዮታ፥ ቃሴ ሃንኮ ባጋራ ናምኡ ሳጋዮታ ኣꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ሄሳፌ ጉዬ ኦዶሮ ሚꬃፌ ቶሆ ሚꬃታ ኬሳዳ ዎርቃ ቲያ። ");
INSERT INTO gmve_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ታቦታ ቶካና ማላ ታቦታዛ ሚሌን ዲዛ ሳጋዮታን ቶሆ ሚꬃታ ጌልꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ቶሆ ሚꬃቲ ታቦታ ሳጋዮታ ጊዶን ዴቶ፤ ኢስቲ ሄፔ ሙሌካ ኬዞፔቶ። ");
INSERT INTO gmve_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ታኒ ኔስ ኢሚዛ ጫቆ ቃላ ማርካ ታቦታ ጊዶን ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","«ሃራራ ዋላኬቶንታ ዎርቃፌ ጻላላ ናምኡ ዋꬋኔ ባጋ ኣዱቂዛ፥ ኢሲ ዋꬋኔ ባጋ ኣኪዛ ማሮቴꬃ ካማ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","ካማዛ ጼራ ናምኡ ባጋራ ቆጻዳ ናምኡ ኪሩቤታ ዎርቃፌ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ኢሲ ኪሩቤዛ ኢሲ ባጋ ጋጻን፥ ናምኣንꬆ ኪሩቤዛ ሃንኮ ባጋ ጋጻን ናምኣታካ ማሮቴꬃ ካማዛራ ጋꬃ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ኪሩቤቲ ባ ቄፌ ዴንꬂዲ ማሮቴꬃ ካማ ቦላራ ካሜቶ፤ ቃሴ ኢሶይ ኢሳኮ ሲሚ ኡቲዲ ካማዛኮ ጼሌቶ። ");
INSERT INTO gmve_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ታኒ ኔስ ኢሚዛ ጫቆ ቃላ ማርካ ታቦታ ጊዶን ዎꬃ፤ ቃሴ ካማዛ ታቦታስ ቦላ ባጋራ ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ጫቆ ቃላ ማርካይ ኢዛን ዲዛ ታቦታ ካማ ቦላ ዲዛ ናምኡ ኪሩቤታፔ ጊዶን ታኒ ኔናራ ጋጋዳ ኢስራኤሌ ኣሳስ ኢሚዛ ኣዛዞ ኡባ ሄን ታ ኔስ ኢማና። ");
INSERT INTO gmve_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«ኦዶሮ ሚꬃፌ ኣዱሳቴꬃይ ናምኡ ዋꬋ፥ ጎምፓይ ኢሲ ዋꬋ፥ ꬎቃቴꬃይ ቃሴ ኢሲ ዋꬋኔ ባጋ ጊዲዛ ኢሲ ጻራጴዛ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ሂስታዳ ዋላካይ ባይንዳ ዎርቃን ቲያ፤ ቃሴ ኢዛ ዩሾን ዎርቃ ጻንጻ ዩሻ ኣꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","ሄሳꬆካ ቃሴ ኣሆቴꬂ ታꬋኮ ጊዲዛ ጻንጻ ኢዛ ቦላ ዩሻ ኣꬃ። ሂስታዳ ኢዛ ቦላ ዎርቃ ባልጻንꬅ ዩሻ ኣꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","ጻራጴዛዛስ ኦይዱ ዎርቃ ሳጋዮታ ሜꬋዳ፥ ጻራጴዛ ቶሆቲ ዲዛ ኦይዱ ባጋራ ኦይꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ጻራጴዛ ቶካናስ ቶሆ ሚꬅ ኢዛ ጊዶራ ኣꬂዛ ሳጋዮቲ ጻራጴዛዛስ ጻንጻ ማታን ዴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","ሄ ቶኪዛ ሚꬃታ ኦዶሮ ሚꬃፌ ኬሳዳ፥ ዎርቃ ቲያዳ ኢስታራ ጻራጴዛዛ ቶካ። ");
INSERT INTO gmve_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","ሄሳꬆካ ቃሴ ሳኔታኔ ፒልኦታ፥ ዱቃና ጻሮታኔ ኬሬታ ዋላካይ ባይንዳ ዎርቃፌ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ታ ሲንꬅ ኣꬊዛ ጌሻ ኡኬꬃይ ኡባ ዎዴካ ጻራጴዛ ቦላፌ ꬋዮፖ። ");
INSERT INTO gmve_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«ዎርቃፌ ጻላ ቆጻዳ ጾምፔ ኢስታ ቦላ ዎꬂዛ ባላታ ኬሳ፤ ቃሴካ ኢዛ ቆጻዳ ጾምፔዚ ኢዛን ኤቂዛ ቶሆ፥ ጊዶ ቶማኔ ቶማዛ ኩሬታ፥ ꬌሞታኔ ጪሻታ ኡባ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ኢሲ ሚሌራ ሄꬑ ባላቲ፥ ኢሲ ሚሌራ ቃሴካ ሄꬑ ባላቲ ኢሲ ቦላ ኡሱፑን ሃጋቲ ኢዛስ ዴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ኡሱፑን ባላታስካ ኢሳስ ኢሳስ ꬌሞይኔ ጪሻይ ኢዛን ዲዛ ኦቾሎኔ ጌቴቲዛ ሚꬃ ጪሽ ሚሳቲዛ ሄꬑ ኩሬቲ ዴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","ጾምፔዛ ጊዶ ቶማይ፥ ꬌሞቲኔ ጪሻቲ ኢዛን ዲዛ ኦቾሎኔ ጌቴቲዛ ሚꬃ ጪሽ ሚሳቲዛ ኦይዱ ኩሬቲ ዴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","ናምኣይ ናምኣይ ኢሲፌ ዋꬃን ዲዛ ሄꬑ ባላታፔ ጋርሳራ ኢሲ ኢሲ ꬌሞይ ዴኦ። ");
INSERT INTO gmve_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ꬌሞቲኔ ባላቲ ዉሪ ጊዶ ቶማዛፔ ቆጼቲዲ ዋላካይ ባይንዳ ዎርቃፌ ኦሴቴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","«ሄሳፌ ጉዬ ጾምፔ ዎꬂዛሶዛስ ላፑን ኤጺዛሶ ጊጊሳዳ ጾምፔቲ ሲንꬃ ባጋ ፖኣና ማላ ኦይꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ጾምፔዛ ቦላ ኤጺሼ ቃሚዳ ሻሎታ ኬሲዛ ቃጴታኔ ጺጻ ዎꬂዛ ሳኔታ ዋላካይ ባይንዳ ዎርቃፌ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ጾምፔዚኔ ኢዛ ሚሻቲ ዉሪ ሄꬑ ታማኔ ኢቻሹ ኪሎ ጊራሜ ጊዲዛ ዋላካይ ባይንዳ ዎርቃፌ ኦሴቴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","ታኒ ኔና ዙማ ቦላ ቤሲዳ ሌሚሶዛ ካላዳ ኣኬካን ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«ቃሴ ሎኤꬂ ሱቄቲዳ ቦꬃ ላይኖፔ ዳዴቲዳ ታሙ ማጋላሻታ ዱንካኔዛ ጊዶን ጊጊሳ። ቃሴካ ሳሎ ሚሳቲዛ፥ ኦቻ ቴራ ሚሳቲዛኔ ጼቃ ዞኦ ቃጪናራ ሄ ማጋላሻታ ቦላ ኢሲ ሂላን ኪሩቤታ ሚስሌ ኦሲሳ። ");
INSERT INTO gmve_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ማጋላሻቲ ዉሪ ኢሲ ጊና ጊዴቶ፤ ኢሳ ኢሳ ኣዱሳቴꬃይ ናምኡ ታማኔ ኦስፑን ዋꬋ፤ ጎምፓይ ቃሴ ኦይዱ ዋꬋ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ኢቻሹ ማጋላሻታ ኢሲፌ ጋꬃ ሲካ፤ ሃንኮ ኣቲዳ ኢቻሹ ማጋላሻታካ ኢስታꬆካ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ኢሲፌ ጋጊ ሲኬቲዳ ማጋላሻታፔ ጋጻን ዲዛ ማጋላሻስ ባልጻንꬃ ቦላ ሳሎ ሚሳቲዛ ጫርቃፌ ሲꬌ ኦꬃ፤ ቃሴ ኢሲፌ ጋጊዲ ሲኬቲዳ ሃንኮ ማጋላሻንካ ሄሳꬆ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ኢሲፌ ጋጊዳ ኢሲ ማጋላሻ ቦላ ኢቻሹ ታሙ ሲꬌ ሚሳቲዛ ሚሽ፥ ቃሴ ኢሲፌ ጋጊዳ ሃንኮ ማጋላሻ ቦላካ ኢቻሽ ታሙ ሲꬌ ሚሳቲዛ ሚሽ ኦꬃ፤ ሄ ሲꬌ ሚሳቲዛ ሚሻቲ ዉሪካ ሄ ባጋራኔ ሃ ባጋራ ኢሳይ ኢሳራ ጊናን ዴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ሄሳፌ ጉዬ ዎርቃፌ ኢቻሽ ታሙ ቃጴታ ሜꬋዳ ጊዶ ዱንካኔዚ ኢሲኖ ጊዳና ማላ፥ ሄ ማጋላሻታ ማንጻኮታን ኢሳ ኢሳራ ኦይሴꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«ጊዶ ዱንካኔዛ ቦላራ ሃራ ዱንካኔ ኦꬃናስ ታማኔ ኢሲ ማጋላሻታ ዴይሻ ኢስኬፌ ዳዳ። ");
INSERT INTO gmve_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ታማኔ ኢሲ ማጋላሻቲካ ኢሲ ጊና ጊዴቶ፤ ኢሲ ኢሲ ማጋላሻ ኣዱሳቴꬃይ ሄꬑ ታሙ ዋꬋ፥ ጎምፓይ ቃሴ ኦይዱ ዋꬋ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ኢቻሹ ማጋላሻታ ኢሲ ባጋራ ኡሱፑን ማጋላሻታ ቃሴ ሃንኮ ባጋራ ጋꬃ ሲካ። ኡሱፑንꬃ ማጋላሻይ ሲንꬃራ ሶ ባጋ ሲሚ ቃላምኤቶ። ");
INSERT INTO gmve_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ጋꬂ ሲኪዳ ማጋላሻታፔ ኢሲ ማጋላሻ ጋጻን ኢቻሽ ታሙ ሲꬌ ሚሳቲዛ ሚሻታ ኦꬃ፤ ቃሴ ጋꬂ ሲኪዳ ሃንኮ ማጋላሻታፔ ዉርሴꬃ ማጋላሻ ባልጻንꬃ ቦላ ኢቻሽ ታሙ ሲꬌ ሚሳቲዛ ሚሻታ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ጻርቂማላፔ ኢቻሹ ታሙ ቃጴታ ኦꬃዳ፥ ቃንጎ ሚሳቲዛ ሚሻታ ጊዶ ጌልꬃ፤ ሂስታዳ ቦላ ዱንካኔዛ ኢሲፌ ጋꬃ ኦይꬃ። ሂስቲኮ ሃ ናምኡ ኦይኬቲዳ ካማቲ ኢሲኖ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ቦላ ዱንካኔዛ ማጋላሻታፔ ፓላሂዳ ባጋ ማጋላሻይ ጊዶ ዱንካኔዛስ ጉዬራ ኣላሌቶ። ");
INSERT INTO gmve_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","ቦላ ዱንካኔዛ ማጋላሻቲ ናምኡ ባጋራካ ኢሲ ኢሲ ዋꬋ ማላ ፓላሂዲ ሄራ ሃራ ኣላሌቲዲ ጊዶ ዱንካኔዛ ካማና ማላ ናምኡ ባጋ ሚሌራ ኣላሌቶ። ");
INSERT INTO gmve_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","«ቦላ ባጋ ዱንካኔዛ ቦላራ ካማናስ ዞኦ ቃላሜን ጌሊ ኬዚዳ ꬋርሾ ኢቴ ጊጊሳ፤ ቃሴ ኢዛ ቦላራ ካማናስ ሃꬃ ጊዶ ዶኣ ጋልባፌ ሃራ ካማ ጊጊሳ። ");
INSERT INTO gmve_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«ጊዶ ዱንካኔዛ ቶሌ ሚꬃታ ኦዶሮ ሚꬃፌ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ኢሲ ኢሲ ቶሌ ሚꬃስ ኣዱሳቴꬃይ ታሙ ዋꬋ፥ ጎምፓይ ኢሲ ዋꬋኔ ባጋ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ኢሲ ቶሌ ሚꬃስ ኢሲ ቦላ ኦይኬቲ ኡቲዳ ናምኡ ቶሆታ ኦꬃ። ጊዶ ዱንካኔዛ ቶሌ ሚꬃታ ኡባካ ሄሳꬆ ኦꬃ፤ ");
INSERT INTO gmve_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","ጊዶ ዱንካኔዛስ ዱጌ ባጋራ ናምኡ ታሙ ቶሌ ሚꬃታ ኬሳዳ፥ ");
INSERT INTO gmve_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ኢሲ ኢሲ ቶሌ ሚꬃስ ናምኡ ኤቆሶ፥ ሙሌራ ኦይዱ ታሙ ኤቆሶ ቢራፔ ጊጊሳ። ");
INSERT INTO gmve_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ጊዶ ዱንካኔዛስ ፑዴሃ ባጋራ፥ ናምኡ ታሙ ቶሌ ሚꬃታ ኬሳዳ፥ ");
INSERT INTO gmve_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ኢሲ ኢሲ ቶሌ ሚꬃስ ናምኡ ኤቆሶ፥ ሙሌራ ኦይዱ ታሙ ኤቆሶ ቢራፔ ጊጊሳ። ");
INSERT INTO gmve_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ቃሴ ጊዶ ዱንካኔዛስ ጉዬራ ኣርሼይ ዉሊዛ ባጋራ ኡሱፑን ቶሌ ሚꬃታ ኬሳዳ፥ ");
INSERT INTO gmve_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ጉዬ ባጋራ ዲዛ ዞዜታስ ናምኡ ቶሌ ሚꬃታ ጊጊሳ። ");
INSERT INTO gmve_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ጉዬ ባጋራ ዲዛ ቶሌ ሚꬃቲ ዉሪ ጻጶፔ ጼራ ጋካናስ ኢሲ ቦላ ጋጊ ኦይኬቲዲ፥ ጼራን ኢሶይ ኢሳራ ሳጋዮን ኦይኬቴቶ፤ ሄሳꬆካ ናምኡ ዞዜታ ቦላ ዲዛ ናምኡ ቶሌ ሚꬃቲካ ሃራ ቶሌ ሚꬃታራ ኦይኬቴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ኢሲ ኢሲ ቶሌ ሚꬃስ ጋርሳራ ናምኡ ናምኡ ቶሌ ኤቆሶይ ዴኦ፤ ሙሌራ ኦስፑን ቶሌ ሚꬃቲኔ ቢራፔ ኦሴቲዳ ታማኔ ኡሱፑን ኤቆሶይ ዴዮ። ");
INSERT INTO gmve_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«ቃሴ ሜጋ ሚꬃታ ኦዶሮ ሚꬃፌ ኬሳ። ጊዶ ዱንካኔዛስ ኢሲ ባጋ ሚሌን ዲዛ ቶሌ ሚꬃታስ ኢቻሹ ሜጋ ሚꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ቃሴ ሃንኮ ባጋ ሚሌን ዲዛ ቶሌ ሚꬃታስ ሃኢካ ኢቻሹ ሜጋ ሚꬃታ ጊጊሳ። ሄሳꬆካ ጊዶ ዱንካኔዛስ ጉዬራ ኣርሼይ ዉሊዛ ባጋራ ዲዛ ቶሌ ሚꬃታስ ኢቻሹ ሜጋ ሚꬃታ ጊጊሳ። ");
INSERT INTO gmve_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","ጊዶ ሜጋ ሚꬃቲ ቶሌ ሚꬃታስ ጊዶራ ሃ ጋጻፔ ሄ ጋጻ ጋካናስ ካንꬂ ኬዛናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","«ቶሌ ሚꬃታ ዎርቃን ቲያዳ ሜጋ ሚꬃቲ ኢስታ ጊዶራ ኣꬊዛ ሳጋዮታ ዎርቃፌ ኦꬃ፤ ቃሴ ሜጋ ሚꬃታካ ዎርቃን ቲያ። ");
INSERT INTO gmve_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","ጊዶ ዱንካኔዛ ታኒ ኔና ዙማ ቦላን ቤሲዳ ሌሚሶዛ ማላ ቶካ። ");
INSERT INTO gmve_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«ሳሎ ሚሳቲዛፔ፥ ኦቻ ቴራ ሚሳቲዛ ቃጪናፔኔ ጼቃ ዞኦ ቃጪናፔኔ ሎኢ ሱቄቲዳ ሊቆ ላይኖፔ ኢሲ ማጋላሻ ኦꬃ፤ ሄ ማጋላሻዛ ቦላ ኪሩቤታ ሚስሌ ሲኪ ሜꬊዛ ሂላን ኦሲሳ። ");
INSERT INTO gmve_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ሂስታዳ ኦዶሮ ሚꬃፌ ኦሴቲዲ ዎርቃን ቲዬቲዳ ኦይዱ ኤቆ ሚꬃታ ቦላ ዲዛ ዎርቃፌ ኦሴቲዳ ካቆታን ካቃ። ሄ ኦይዱ ኤቆ ሚꬃቲ ቢራፔ ኦሴቲዳ ኤቆሶታን ጌሌቶ። ");
INSERT INTO gmve_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ሄ ማጋላሻዛ ጊዶ ዱንካኔዛ ካራን ዲዛ ቃጴታፔ ጋርሳራ ካቃዳ፥ ጫቆ ቃላስ ማርካ ጊዲዳ ታቦታ ማጋላሻዛፔ ጋꬃ ባጋራ ዎꬃ፤ ሂስቲኮ ሄ ማጋላሻዚ ጌሽ ጌቴቲዛ ሶሆዛ ኡባፌ ዱማቲዛ ቆልኣፌ ጊዶን ሻካና። ");
INSERT INTO gmve_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ማሮቴꬃ ካማ ኡባፌ ዱማቲዳ ቆልኣን ዲዛ ጫቆ ቃላስ ማርካ ጊዲዳ ታቦታ ቦላ ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","ጻራጴዛዛ ማጋላሻፔ ካሬራ ፑዴ ባጋራ ዎꬃ፤ ጾምፔ ዎꬂዛ ባላ ቃሴ ኢዛ ጊናን ዱጌ ባጋራ ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","«ዱንካኔዛን ጌሊዛ ፔንጌዛስ ሳሎ ሚሳቲዛ ቃጪናፔ፥ ኦቻ ቴራ ሚሳቲዛ ቃጪናፔ፥ ጼቃ ዞኦ ቃጪናፔኔ ሎኢ ሱቄቲዳ ሊቆ ላይኖፔ ጺልፔን ኣሌቂሲ ኦሴቲዳ ማጋላሻ ጊጊሳ። ");
INSERT INTO gmve_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ማጋላሻዛስ ኢቻሹ ኤቆ ሚꬃታ ኦዶሮ ሚꬃፌ ኬሳዳ፥ ዎርቃን ቲያ፤ ኢስታ ካቆቲካ ዎርቃፌ ኦሴቲዳ ጊዴቶ፤ ኤቆ ሚꬃታስ ጻርቂማላፔ ኦሴቲዳ ኢቻሹ ኤቆሶ ጊጊሳ። ");
INSERT INTO gmve_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«ኦዶሮ ሚꬃፌ ያርሺዛሶ ኦꬃ። ሄ ያርሺዛሶዛ ꬎቃቴꬃይ ሄꬑ ዋꬋ፤ ጎምፓይኔ ኣዱሳቴꬃይ ኢሲ ማላ፥ ኢቻሹ ኢቻሹ ዋꬋ ጊዲዲ ኦይዱ ዞዜራ ዴዮ። ");
INSERT INTO gmve_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ኦይዱ ዞዜታ ዉርሴꬃ ጋጻን ጋጻን ኢሲ ኢሲ ካጬ ሜꬋ፤ ካጬቲ ያርሾሶዛፔ ኦሴቴቶ። ሂስታዳ ያርሺዛሶዛ ጻርቂማላ ቲያ። ");
INSERT INTO gmve_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","ኢዛን ጎኤቲዛ ሚሻታ፥ ቢዲንꬅ ካሺዛ ሚሻታ፥ ካሼቲዳ ቢዲንꬃ ኬሲዛ ሚሻታ፥ ኬሬታ፥ ኣሾ ጺጺዛ ኮንጬታኔ ታማ ካቺዛኔ ኬሲዛ ሚሻታ ኡባ ጻርቂማላፔ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ሂስታዳ ኢዛስ ጻርቂማላፔ ዛይዛሬ ማላ ሚሺኔ ኦይዱ ጉላታ ቦላን ኦይዱ ሳጋዮታ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ሂስታዳ ያርሺዛሶዛስ ዳባ ቦላ ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","ኦዶሮ ሚꬃፌ ያርሺዛሶዛስ ቶሆ ሚꬃታ ኬሳዳ ጻርቂማላ ቲያ። ");
INSERT INTO gmve_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ያርሺዛሶዛ ቶኪዛ ዎዴ ማዳና ማላ ሄ ቶሆ ሚꬃታስ ናምኡ ሚሌራ ዲዛ ሳጋዮታን ኣꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","ታኒ ኔና ዙማ ቦላን ቤሲዳ ማላ ያርሺዛሶዛ ሳንቃፌ ኦꬃዳ ጊዶዛ ዶያ ኣጋ። ");
INSERT INTO gmve_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«ጾሳ ዱንካኔዛ ጊቤ ሎኢ ዳዴቲዳ ሊቆ ላይኖፔ ማጋላሻታ ጊጊሳ። ዱጌ ባጋራ ዲዛ ማጋላሻታ ኣዱሳቴꬃይ ጼቱ ዋꬋ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ኢዛስ ናምኡ ታሙ ኤቆ ሚꬃቲኔ ኤቆ ሚꬃቲ ኢስታን ኤቂዛ ናምኡ ታሙ ኤቆሶታ ጻርቂማላፔ ኦꬃ፤ ኢስታ ሁኤን ቃሴ ካቆታኔ ቶሬ ሚꬃታ ሁኤ ቦላ ጊታ ሳጋዮታ ቢራፔ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ሄሳꬆካ ፑዴ ባጋ ኣዱሳቴꬃይ ጼቱ ዋꬋ፤ ቃሴ ናምኡ ታሙ ቶሬ ሚꬃቲኔ ኤቆ ሚꬃታስ ናምኡ ታሙ ጻርቂማላፔ ኦሴቲዳ ኤቆሶቲ ዴቶ። ሂስታዳ ቢራፔ ኦሴቲዳ ካቆታኔ ኤቆ ሚꬃታስ ሁኤ ቦላ ጊታ ሳጋዮታ ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","ኣርሼይ ዉሊዛ ባጋራ ኣኮቴꬃይ ኢቻሹ ታሙ ዋꬋ ጊዶ፤ ታሙ ቶሬ ሚꬃቲኔ ቶሬ ሚꬃታስ ታሙ ኤቆሶቲ ዲዛ ማጋላሻቲ ኢዛስ ዴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ቃሴ ኣርሼይ ሞኪዛ ባጋራ ኣኮቴꬃይ ኢቻሹ ታሙ ዋꬋ ጊዲዲ፥ ");
INSERT INTO gmve_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ፔንጌዛፔ ኢሲ ባጋራ ታማኔ ኢቻሹ ዋꬋ ኣዱቂዛ ማጋላሻቲ ዴቶ፤ ኢስታስ ሄꬑ ኤቆ ሚꬃቲኔ ኢስታን ኤቂዛ ሄꬑ ኤቆሶቲ ዴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ሄሳꬆካ ሃንኮ ባጋራ ታማኔ ኢቻሹ ዋꬋ ኣዱቂዛ ማጋላሻቲ ዴቶ፤ ኢስታስ ሄꬑ ኤቆ ሚꬃቲኔ ኢስታን ኤቂዛ ሄꬑ ኤቆሶቲ ዴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","«ፔንጌዛስ ናምኡ ታሙ ዋꬋ ኣዱቂዛ ማጋላሻ ሳሎ ሚሳቲዛ፥ ኦቻ ቴራ ሚሳቲዛኔ ጼቃ ዞኦ ቃጪናፔኔ ሎኢ ሱቄቲዳ ላይኖፔ ዳዴቲዳ፥ ጺልፔን ሎኢዳ ማጋላሻ ጊጊሳ። ኢዛ ቱቂ ኦይካናስ ኦይዱ ኤቆ ሚꬃቲኔ ቶሬ ሚꬃቲ ኢስታን ኤቂዛ ኦይዱ ኤቆሶታ ጊጊሳ። ");
INSERT INTO gmve_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","«ጊቤዛ ዩዪ ኣꬋናስ ዲዛ ኤቆ ሚꬃታ ኡባስ ቢራፔ ኦሴቲዳ ጊታ ሳጋዮቲ፥ ካቆቲኔ ጻርቂማላፔ ኦሴቲዳ ኤቆሶቲ ዴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ጊቤዛ ኣዱሳቴꬃይ ጼቱ ዋꬋ፥ ኣኮቴꬃይ ኢቻሽ ታሙ ዋꬋ ጊዶ፤ ꬎቃቴꬃይ ኢቻሹ ዋꬋ ጊዲዳ ሎኢ ሱቄቲ ዳዴቲዳ ላይኖፔ ኦሴቲዳ ማጋላሻቲ ዴቶ፤ ቃሴካ ጻርቂማላፔ ኦሴቲዳ ኤቆሶቲ ዴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","«ጾሳ ዱንካኔዛ ኦሶስ ጎኤቲዛ ሚሻቲ፥ ዱንካኔዛኔ ጊቤዛ ቶሌ ꬊሽኬቲ ዉሪካ ጻርቂማላፔ ኦሴቴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«ጾምፔይ ቶኦንታ ኤጺሼ ዳና ማላ ኢዛስ ኮሺዛ ዛይቴ ዎጋራ ሚꬃ ኣይፌ ጫዲ ጉምኢዲ ጺሎ ዛይቴ ኔስ ኤሃና ማላ ኢስራኤሌ ናይታ ኣዛዛ። ");
INSERT INTO gmve_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","ኣሮኔይኔ ኢዛ ኣቱማ ናይቲ ጾምፔይ ጎዳ ሲንꬃን ቃሚዳ ጋዴይ ዎንታና ጋካናስ ፖኣና ማላ፥ ጾሳ ዱንካኔዛ ጊዶን፥ ጫቆ ቃላስ ማርካይ ኢዛ ጊዶን ዲዛ ታቦታ ሲንꬃን ዲዛ ማጋላሻፔ ካሬራ ኤꬄቶ። ሃይሲ ኢስራኤሌ ኣሳስ ሜርናስ ዎጋ ጊዲ ዴኦ። ");
INSERT INTO gmve_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«ኔ ኢሻ ኣሮኔኔ ኢዛ ኣቱማ ናይታ ናዳቤ፥ ኣቢሁ፥ ኤልኤዜሬኔ ኢታማሬ ኔኮ ኤካ ያ፤ ኢስቲ ቄሴ ጊዲዲ ታስ ኦꬃና ማላ ኢስራኤሌ ኣሳ ጊዶፌ ኢስታ ዱማሳ። ");
INSERT INTO gmve_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","ኢዛስ ቦንቾኔ ሎኦቴꬅ ኢማና ማላ ኔ ኢሻ ኣሮኔስ ዱማ ማይኦ ጊጊሳ። ");
INSERT INTO gmve_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ታኒ ዱማ ዱማ ኤራቴꬅ ኢሚዳ ኩሼ ሂላ ኤሪዛ ኣስ ኡባ ጼይጋዳ ኣሮኔስ ማይኦ ጊጊሳና ማላ ዮታ፤ ኢዚካ ቄሴ ጊዲዲ ታስ ኦꬃናስ ዱማቶ። ");
INSERT INTO gmve_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ኢስቲ ጊጊሳና ማይኦቲካ ሃይታንታኮ፤ ቲራ ኪሴ፥ ኤፉዴ፥ ኤፉዴፔ ጋርሳራ ማይኢዛ ሃራ ማይኦ፥ ቃሴካ ኡባፌ ጋርሳራ ማይኢዛ ኣዱሳ ማይኦ፥ ጎሴኔ ዳንጮ። ኔ ኢሻይ ኣሮኔይኔ ኢዛ ኣቱማ ናይቲ ቄሴ ጊዲዲ ታስ ኦꬂሼ ዱማ ማይኦታ ማይኣና ማላ፥ ማይኦ ጊጊሴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ኩሼ ሂላቴꬅ ኤሪዛይቲካ ሄ ማይኦታ ጊጊሳናስ፥ ዎርቃ፥ ሳሎ ሚሳቲዛ፥ ኦቻ ቴራ ሚሳቲዛኔ ጼቃ ዞኦ ቃጪናኔ ሊቆ ላይኖ ኤኪ ኦꬄቶ። ");
INSERT INTO gmve_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«ኤፉዴ ጌቴቲዛ ማይኦ ዎርቃፌ፥ ሳሎ ሚሳቲዛ፥ ኦቻ ቴራ ሚሳቲዛ፥ ጼቃ ዞኦ ቃጪናፔኔ ሎኢ ሱቄቲዳ ሊቆ ላይኖፔ ኩሼ ሂላቲ ኣሌቂሲ ጊጊሴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","ኢዛስ ሃሼራ ዱጌ ዎꬊዛ ናምኡ ካቆቲ ዴቶ፤ ኢስቲካ ቢዲ ኤፉዴ ማይኦዛራ ኢሲፌ ሃራ ኦይꬂዛ ሚሻራ ዳባ ቦላ ኦይኬቲዲ ኢሲኖ ጊዴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ሂላይ ሎኤꬂዲ ዳዲዳ ዳንጮይካ ኤፉዴዛ ማላ ዎርቃፌ፥ ሳሎ ሚሳቲዛ ኦቻ ቴራ ሚሳቲዛ፥ ጼቃ ዞኦ ቃጪናፔኔ ሎኢ ባቄቲዳ ላይኖፔ ኤፉዴዛራ ኢሲፌ ኦይኬቲ ዳዴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","«ማርጊዴ ጌቴቲዛ ናምኡ ሹቻታ ኤካዳ ኢስራኤሌ ናይታ ሱንꬅ ኢስታ ቦላ ዎጫ ጻፋ። ");
INSERT INTO gmve_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ኢስታ ዬሌታ ማራ ማላ ኢሲ ሹቻ ቦላ ኡሱፑን ሱንꬅ፥ ሃንኮ ሹቻ ቦላ ቃሴ ኣቲዳ ኡሱፑናታ ሱንꬅ ዎጫ ጻፋ። ");
INSERT INTO gmve_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ሂላንቻይ ማታሜ ቦላ ሱንꬅ ዎጪ ጻፊዛ ማላ፥ ሄ ናምኡ ሹቻታ ቦላ ኢስራኤሌ ናይታ ሱንꬁ ዎጫ ጻፋዳ ዩዪ ኣꬋናስ ዎርቃፌ ጊጌቲዳ ሚሻ ጊዶን ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ሂስታዳ ታማኔ ናምኡ ኢስራኤሌ ዜሬꬃታ ቆፍሲዛዝ ጊዳና ማላ ሃ ናምኡ ሹቻታ ኤፉዴዛራ ኦይꬃዳ ሃሼ ቦላ ዎꬃ፤ ሂስቲኮ ጎዳ ሲንꬃን ኡባ ዎዴ ቆፌታና ማላ ሃ ሱንꬃታ ኣሮኔይ ባ ሃሼ ቦላ ቶኮ። ");
INSERT INTO gmve_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","ሹቻታ ዎꬃናስ ዎርቃፌ ዶቄቲ ጊጊዳ ማጫራታ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ቃሴ ዋላካይ ባይንዳ ዎርቃፌ ዎዶሮ ማላ ዶቄቲዳ ናምኡ ኦርዴ ሳንሳላታታ ጊጊሳዳ፥ ሹቻታ ዎꬃናስ ዎርቃፌ ዶቄቲ ጊጌቲዳ ማጫራታራ ጋꬃ ኦዬሴꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«ጎዳ ሼኔይ ኣዛኮኔ ኢዛ ኦይቺዲ ኤሪዛ ቲራ ኪሴ ኩሼ ሂላንቻን ኦሲሳ። ሄ ቲራ ኪሴ ኤፉዴ ዳዲዳ ማላ፥ ዎርቃፌ፥ ሳሎ ሚሳቲዛ፥ ኦቻ ቴራ ሚሳቲዛኔ ጼቃ ዞኦ ቃጪናፔኔ ሎኢ ሱቄቲዳ ላይኖፔ ዳዳ። ");
INSERT INTO gmve_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ኢዛስ ኣዱሳቴꬃይኔ ኣሆቴꬃይ ዳኮቲ ቃላምኤቲዲ ኢሲ ታꬋኮ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","ሄሳፌ ጉዬ ኢዛ ቦላ ኦይዱ ማራን ኣልኦ ሹቻታ ዎꬃ፤ ኮይሮ ማራን ሳርዲዮኔ፥ ቶጳዚዮኔኔ ጶሊዛ ኢንቁ። ");
INSERT INTO gmve_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ናምኣንꬆ ማራን ባሉሬ፥ ሲምፔሬኔ ኣልማዜ ጌቴቲዛ ኣልኦ ሹቻታ፤ ");
INSERT INTO gmve_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ሄꬓንꬆ ማራን ያኪንቴ፥ ኬልቄዶኔኔ ኣሜቴስጺኖሴ፤ ");
INSERT INTO gmve_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ኦይዳንꬆ ማራን ቢሪሌ፥ ማርጊዴ፥ ያስጲዴ። ሃይታንቲ ዉሪ ሹቻታ ዎꬃናስ ዎርቃፌ ዶቄቲ ጊጊዳ ማጫራታ ቦላ ኡቴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ኢስራኤሌ ቆሞታ ሱንꬃ ቆዳ ማላ፥ ሹቻታ ቆዳይካ ታማኔ ናምኡ ጊዶ፤ ኢሳ ኢሳ ቦላ ማታሜ ማላ ዎጬቲዲ ታማኔ ናምኡ ዜሬꬃታ ሱንꬂ ሄ ሹቻታን ጻፌቶ። ");
INSERT INTO gmve_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","«ቲራ ኪሴስ ዋላካይ ባይንዳ ዎርቃፌ ዎዶሮ ማላ ዶቄቲዳ ኦርዴ ሳንሳላታታ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ናምኡ ዪች ዎርቃፌ ጊጊሳዳ ቲራ ኪሴስ ቆሞ ጋጻ ጼራራ ጋꬃዳ ኦይꬃ ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ሄ ናምኡ ዎርቃ ሳንሳላታታ ቲራ ኪሴታስ ጼራታን ዲዛ ሳጋዮታራ ጋꬃ ኦይꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ሄ ሳንሳላታታስ ሃንኮ ባጋ ጼራ ቃሴ ኤፉዴዛስ ሲንꬃ ባጋራ፥ ሃሼ ቦላ ዲዛ ሹቻታ ዎꬃናስ ዎርቃፌ ዶቄቲ ጊጊዳ ማጫራታራ ጋꬃ ኦይሴꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","ቃሴካ ናምኡ ዎርቃ ዪቻታ ጊጊሳዳ፥ ኤፉዴፔ ካሊ ዲዛ ቲራ ኪሴታስ ጋꬃ ባጋራ ዲዛ ናምኡ ጼራታን ኣꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","ሄሳꬆካ ዎርቃፌ ሃራ ናምኡ ዪቻታ ጊጊሳዳ ኤፉዴዛስ ሲንꬃ ባጋራ፥ ሃሼ ቦላ ዲዛ ካቆዛፔ ጋርሳ ባጋራ፥ ኤፉዴ ዳንጪዛሶፔ ቆሞራ ሲኮይ ጋጊዛሶ ኣቻን ኢስታ ኦይꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","ቲራ ኪሴን ዲዛ ሳጋዮታ ኤፉዴዛን ዲዛ ሳጋዮታራ ጋꬂዲ ሳሎ ሚሳቲዛ ሱቄꬃን ዳንጮዛራ ጋꬃ ቃቻ፤ ሂስቲኮ ቲራ ኪሴዚ ጼሳፌ ቦላራ ዲዛ ጊሻስ ቃሾይ ሌፔና። ");
INSERT INTO gmve_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","«ኣሮኔይ ኡባፌ ዱማ ቆልኣ ጌሊዛ ዎዴ ሄ ቲራ ኪሴን ዲዛ ኢስራኤሌ ቆሞታ ሱንꬃታ ቶኮ። ሂስቲኮ ሃይሲ ጎዳ ሲንꬃን ኡባ ዎዴ ሃሳኤታና። ");
INSERT INTO gmve_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ቃሴ ኡሪሜኔ ቱሚሜ ጌቴቲዛይታ ቲራ ኪሴታን ዬጋ። ኣሮኔይ ጎዳ ሲንꬅ ኣꬊሼ ባ ቲራን ዎꬂ ኤኪ ጌሎ። ጎዳ ሼኔይ ኣዛኮኔ ኢስራኤሌ ኣሳ ኤሪሳና ማላ፥ ኢዚ ጎዳ ሲንꬃን ኦꬃናስ ጌሊዛ ኡባ ዎዴ ቲራ ኪሴፔ ꬋይሶፎ። ");
INSERT INTO gmve_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«ኤፉዴዛፔ ቦላራ ማይኤቲዛ ኣዱሳ ማይኦ ሳሎ ሚሳቲዛ ጫርቃፌ ጻላ ጊጊሳ። ");
INSERT INTO gmve_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ሄ ኣዱሳ ማይኦዛስ ሁኤይ ጌሊዛሶ ጊጊሳ። ሁኤይ ኬዚዛሶዚ ዳኬቶንታ ማላ ሶ ባጋ ቃላምኣዳ ዩሻ ኣꬃ ሲካ። ");
INSERT INTO gmve_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","ኣዱሳ ማይኦዛስ ጋርሳ ባጋ ማጫራ ዩሾን ሳሎ ሚሳቲዛ፥ ኦቻ ቴራ ሚሳቲዛኔ ጼቃ ዞኦ ቃጪናፔ፥ ኦሮማኔ ጌቴቲዛ ሚꬃ ኣይፌ ሚስሌታ ሜꬋ። ሂስታዳ ኢስታ ጊዶን ዎርቃፌ ኦሴቲዳ ዳላታ ዋላካን ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ዎርቃ ዳላቲኔ ኦሮማኔ ሚꬃ ኣይፌ ሚስሌቲ ሄ ኣዱሳ ማይኦ ጋርሳ ባጋ ጼራን ዩዪ ኣꬋናስ ዋላካን ዴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","ኣሮኔይ ቄሴቴꬃን ኦꬂዛ ዎዴ ሃ ኣዱሳ ማይኦዛ ማይኦ፤ ጎዳ ሲንꬅ ኡባፌ ዱማ ቆልኣ ጌሊዛ ዎዴኔ ኬዚዛ ዎዴ ዳላይ ጊራና። ኢዚ ሄ ማይኦዛ ማይኢኮ ሃይቄና። ");
INSERT INTO gmve_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","ዋላካይ ባይንዳ ዎርቃፌ ኢሲ ኣሌቆ ጊጊሳዳ ማታሜ ዎጪ ኬሲዛ ማላ ኢዛ ቦላ ዎጫዳ፥ ‹ጎዳስ ጌሽ ጊዲ ዱማቲዴስ› ጋዳ ጻፋ። ");
INSERT INTO gmve_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ሂስታዳ ሁኤን ጎሳ ቦላ ሳሎ ሚሳቲዛ ቃጪናን ጎሳዛስ ሲንꬃ ባጋራ ኦይꬃ ካቃ። ");
INSERT INTO gmve_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ሂስቲዲ ኣሮኔይ ኢዛ ባ ሊጴን ዎꬆ፤ ሄን ኢስራኤሌ ኣሳይ ጎዳስ ኢሞታ ኢሚሼ ሞሪዳ ሚሺ ዲኮካ ሄ ሞሮዛ ኣሮኔይ ቶኮ። ኣሳይ ኤሂዛይሳ ጎዳይ ኤካና ማላ ኢዚ ሄ ጻፌቲዳይሳ ኡባ ዎዴካ ባ ሊጴን ዎꬃናስ ኮሼስ። ");
INSERT INTO gmve_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","«ኣሮኔ ሻሚዜ ሌኤ ላይኖፔ ዳዳ፤ ሁኤን ጻጺዛ ጎሳካ ላይኖፔ ጊጊሳ። ቃሴ ዳንጮዛካ ጺልፔን ኣሌቂሳዳ ሲኪሳ። ");
INSERT INTO gmve_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","ኣሮኔ ናይታስ ቦንቾኔ ኣሌቆ ጊዳና ማላ፥ ሻሚዜታ፥ ዳንጮታኔ ሁኤን ጻጺዛ ጎሳታ ጊጊሳ። ");
INSERT INTO gmve_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","ኔኒ ሃ ማይኦታ ኔ ኢሻ ኣሮኔኔ ኢዛ ናይታ ማይዚዳፔ ጉዬ፥ ኢስቲ ቄሴቴꬃን ታስ ኦꬃና ማላ ኢስታ ዎጋራ ዛይቴ ቲያ፤ ቲያዳ ኢስቲ ቄሴ ጊዲዲ ታስ ኦꬃና ማላ ኢስታ ዱማሳ። ");
INSERT INTO gmve_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","ኢስታ ካሎይ ካሜታና ማላ ጋርሳራ ጊጺዛ ጊꬅ፥ ጼሳፌ ቢዲ ዎዲራ ጋካናስ ካሚዛዝ፥ ሊቆ ላይኖ ቃጪናፔ ጊጊሳ። ");
INSERT INTO gmve_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ኣሮኔይኔ ኢዛ ናይቲ ጾሳ ዱንካኔ ጊዶ ጌሊዛ ዎዴ ዎይኮ ጊቤ ጊዶን ቄሴቴꬃን ኦꬃናስ ያርሾ ያርሺዛሶ ሺቂዛ ዎዴ ሃይታ ማይኦታ ማይኤቶ። ሄሳꬆ ሃንኮ ኢስቲ ባንታ ቦላ ቆሆኔ ሃይቆ ኤሄቴና። ሃይሲ ኣሮኔሲኔ ኢዛ ዜሬꬃታስ ሜርናስ ዎጋ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«ኣሮኔይኔ ኢዛ ናይቲ ቄሴ ጊዲዲ ታስ ኦꬃና ማላ ኔኒ ኢስታ ዱማሳናስ ኦꬃ፤ ዎሶይ ባይንዳ ኢሲ ሚርጎኔ ናምኡ ꬋርሾታ ኤካ። ");
INSERT INTO gmve_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ሎኦ ጊስቴ ꬊሌ ኤካዳ ኢርሾ ዬጎንታ ኡኬꬅ ኡካ፤ ቃሴካ ኢርሾ ዬጎንታ ዛይቴን ጉꬃ ኡኬꬅ ኡካ፤ ሄሳꬆካ ኢርሾ ዬጎንታ ቄሪ ኡኬꬅ ኡካዳ ዛይቴ ቲያ። ");
INSERT INTO gmve_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ኔኒ ሄይታ ሌማቴን ዎꬃዳ፥ ሚርጎዛ ናምኡ ꬋርሾታራ ኢሲፌ ታስ ሺሻ። ");
INSERT INTO gmve_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","«ሂስታዳ ኣሮኔኔ ኢዛ ናይታ ጾሳ ዱንካኔዛ ፔንጌ ኤሃዳ ሃꬃን ሜጫ። ");
INSERT INTO gmve_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ሄሳፌ ጉዬ ማይኦታ ኤካዳ፥ ሻሚዜ፥ ኤፉዴፔ ቦላራ ማይኢዛ ኣዱሳ ማይኦ፥ ኤፉዴኔ ቲራ ኪሴ ኣሮኔ ማይዛዳ ኤፉዴዛ ሂላን ዳዴቲዳ ዳንጮን ዳንጪሳ። ");
INSERT INTO gmve_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","ጎሳዛ ኢዛ ሁኤን ጎዚሳዳ፥ ‹ጎዳስ ጌሽ ጊዲ ዱማቲዴስ› ጌቴቲ ጻፌቲዳ ኣሌቆዛ ጎሳ ቦላ ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ቲዪዛ ዛይቴካ ኤካዳ ኢዛ ሁኤን ቲጋዳ ቲያ። ");
INSERT INTO gmve_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","ኢዛ ናይታካ ኤሃዳ ሻሚዜታ ማይዛ። ");
INSERT INTO gmve_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ጎሳካ ኢስታ ሁኤን ጎዚሳ። ሄሳፌ ጉዬ ኣሮኔኔ ኢዛ ናይታ ዳንጮ ዳንጪሳ። ቄሴቴꬃይ ኢስታስ ሜርና ኦሶ ዎጋ ጊዶ፤ ሄሳꬆ ሂስታዳ ኣሮኔኔ ኢዛ ናይታ ቄሴ ሂስታ። ");
INSERT INTO gmve_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","«ኔ ታስ ሚርጎ ጾሳ ዱንካኔ ሲንꬅ ኤሂኮ ኣሮኔይኔ ኢዛ ናይቲ ኢዛ ሁኤ ቦላ ባ ኩሼ ዎꬂኮ፥ ");
INSERT INTO gmve_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ዎፋኖዛ ሄን ጎዳ ሲንꬃን ሹካ። ");
INSERT INTO gmve_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","ዎፋኖዛ ሱꬃን ኔ ቢራꬌ ጌልꬃ ኬሳዳ፥ ያርሺዛሶዛ ቦላን ዲዛ ካጬታ ቲያ፤ ቲዪሺን ኣቲዳ ሱꬃ ያርሺዛሶዛፔ ጋርሳ ባጋራ ጉሳ። ");
INSERT INTO gmve_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ሄሳፌ ጉዬ ማራጬ ካሚዳ ሞꬌ፥ ቲሬዛራ ኦይኬቲ ዲዛ ኣሾ፥ ናምኡ ኪላሆታኔ ኢስታ ካሚዳ ሃንዳ ኤካዳ፥ ያርሺዛሶሆዛ ቦላ ዎꬃዳ ጹጋ። ");
INSERT INTO gmve_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ጊዶ ኣቲን ሚርጎዛ ኣሾ፥ ጋልባኔ ማራጬዛ፥ ሜቴቶንታ ኣሾታ ኣሲ ዲዛሶሆፔ ሃራሶ ኤፋዳ ናጋራ ያርሾ ጊዳና ማላ ጹጋ፤ ");
INSERT INTO gmve_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«ናምኡ ꬋርሾታፔ ኢሳ ኔ ኤኪኮ ኣሮኔይኔ ኢዛ ናይቲ ባ ኩሼ ኢዛ ሁኤ ቦላ ዎꬄቶ። ");
INSERT INTO gmve_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ሹካዳ ሱꬃ ያርሺዛሶዛ ሚሌ ቦላ ኡባ ባጋራ ዉጻ። ");
INSERT INTO gmve_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ꬋርሾዛ ኣሾ ቃንጼሬꬃዳ፥ ቃንꬃ ኣሾኔ ቶሆታ ሜጫዳ ሁኤዛራኔ ሃንኮ ኣቲዳ ኣሻራ ኢሲ ቦላ ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ሄሳፌ ጉዬ ꬋርሾዛ ሙሌራ ያርሺዛሶሆዛ ቦላ ጹጋ፤ ሄሲ ጎዳስ ታማን ጹጌቲዛ ሳዎ ቱኑ ጊዛ ያርሾኮ። ");
INSERT INTO gmve_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«ቃሴ ሃንኮ ꬋርሾዛ ኔ ኤኪኮ ኣሮኔይኔ ኢዛ ናይቲ ባ ኩሼ ኢዛ ሁኤ ቦላ ዎꬄቶ። ");
INSERT INTO gmve_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ሄ ꬋርሾዛ ሹካዳ ኢዛ ሱꬃፌ ጉꬃራ ኤካዳ፥ ኣሮኔሲኔ ኢዛ ናይታስ ኡሻቻ ሃይꬃታ ጼራ፥ ኡሻቻ ኩሼ ማንꬃ ቢራꬌታኔ ኡሻቻ ቶሆ ማንꬃ ቢራꬌታ ቲያ፤ ሄሳፌ ጉዬ ኣቲዳ ሱꬃ ያርሺዛሶ ሚሌ ቦላ ኡባሶራ ዉጻ። ");
INSERT INTO gmve_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ያርሺዛሶን ዲዛ ሱꬃፌኔ ቲዬቲዛ ዛይቴዛፔ ጊናራ ኤካዳ፥ ኣሮኔ ቦላኔ ኢዛ ማይኦ ቦላ፥ ኢዛ ናይታ ቦላኔ ኢስታ ማይኦ ቦላ ዉጻ፤ ሂስቲኮ ኢዚ ኢዛ ናይቲኔ፥ ኢስታ ማይኦይ ጎዳ ኦሶስ ዱማታና። ");
INSERT INTO gmve_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","«ሃ ꬋርሾዛፔ ጎይናዛኔ ኢዛን ዲዛ ቶልꬆዛ፥ ማራጬ ቦላን ዲዛ ሞꬌ፥ ቲሬዛራ ኦይኬቲ ዲዛ ኣሾ፥ ናምኡ ኪላሆታ፥ ኢስታ ካሚ ኦይኪዳ ሃንዳራኔ ኡሻቻ ጌዳራ ኔኒ ኤካ፤ ሃይሲ ቄሴቴꬃ ሱንꬅ ኢሚዛ ዎዴ ሹኬቲዛ ዶርሳ። ");
INSERT INTO gmve_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","ጎዳ ሲንꬃን ዎꬂዳ ኢርሾይ ጌሎንታ ኡኬꬃፌ ኢሲኖ፥ ዛይቴይ ዋላኬቶንታ ኡኬꬃፌ ኢሲኖ፥ ዛይቴራ ኡኪዳ ኢሲ ኮምፖኔ ኢሲ ቄሪ ኮምፓ ኤካ። ");
INSERT INTO gmve_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ኔኒ ሃ ካꬃ ኡባ ኣሮኔ ኩሼኒኔ ኢዛ ናይታ ኩሼን ዎꬂኮ ኢስቲ ያኔ ሃ ቃሴꬂዛ ያርሾ ሂስቲዲ ጎዳ ሲንꬃን ሺሼቶ። ");
INSERT INTO gmve_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ሄሳፌ ጉዬ ኔኒ ኢስታ ኩሼፔ ሄይታ ኤካዳ፥ ያርሺዛሶዛ ቦላ ዎꬃዳ፥ ጹጌቲዛ ያርሾራ ኢሲፌ ጋꬃዳ፥ ጎዳስ ሳዎ ቱኑ ጋና ማላ፥ ያርሺዛሶዛ ቦላ ታማን ጹጋ። ");
INSERT INTO gmve_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","ኣሮኔይ ቄሴ ጊዲዲ ሱሚዛ ዎዴ ሹኪዳ ꬋርሾዛ ኣንጋሶ ኤካዳ ጎዳ ሲንꬃን ያኔ ሃ ቃሴꬂዛ ያርሾ ሂስታ ቃሴꬃ፤ ሃይሲ ኢንቴና ጋኪዛ ጊሻ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","«ሄ ሹኬቲዳ ꬋርሾዛ ኣሾፔ ያርሾ ኦꬂዲ ያኔ ሃ ቃሴꬂዳ ኣንጋሶዛኔ ጎዳ ሲንꬅ ሺቂዳ ጌዳ ዱማሳ። ሄሲካ ኣሮኔ ጊሻኔ ኢዛ ናይታ ጊሻ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ኢስራኤሌ ኣሳይ ጎዳስ ሺሺዛ ኢሲፌቴꬃ ያርሾዛፔ ኣንጋሶዛኔ ጌዳዛ ኡባ ዎዴካ ኣሮኔሲኔ ኢዛ ኣቱማ ናይታ ጋኪዛ ጊሻ ጊዶ። ኣይስ ጊኮ ሃይሲ ኢስራኤሌ ኣሳይ ጎዳስ ሺሺዛ ኢሞታ። ");
INSERT INTO gmve_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«ኣሮኔ ቄሴቴꬃ ዱማ ማይኦይ ኢዛፔ ጉዬ ኢዛ ዜሬꬃስ ጊዶ፤ ኢስቲ ቲዬቲዲ ቄሴ ጊዲዛ ዎዴ ሄ ማይኦዛ ማይኤቶ። ");
INSERT INTO gmve_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","ኢዛ ናይታፔ ኢዛሶሆን ቄሴ ጊዲዲ ዱማቲዳ ሶሆዛን ኦꬃናስ ጾሳ ዱንካኔ ዪዳ ኣቱማ ናይ ሄ ማይኦዛ ላፑን ጋላስ ጋካናስ ማይኦ። ");
INSERT INTO gmve_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«ኣሮኔይኔ ኢዛ ናይቲ ቄሴቴꬃን ሱንꬃናስ ሹኬቲዳ ꬋርሻ ኣሾ ኤካዳ ዱማ ሶሆዛን ዶይሳ። ");
INSERT INTO gmve_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ኣሮኔይኔ ኢዛ ናይቲ ꬋርሾዛ ኣሻ ሌማቴን ዲዛ ኡኬꬃራ ጾሳ ዱንካኔ ፔንጌን ሜቶ። ");
INSERT INTO gmve_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ኢስቲ ቄሴ ጊዲዲ ሱሚዛ ዎዴኔ ዱማቲዛ ዎዴ ኢስታ ናጋራይ ኣቶ ጌቴታና ማላ ያርሼቲዳ ሄ ያርሾታ ሜቶ። ጊዶ ኣቲን ሄ ያርሾቲ ጌሽ ጊዲዳ ጊሻስ ሃራ ኣሲ ኦኒካ ሞፖ። ");
INSERT INTO gmve_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ቄሴቴꬃን ሱንꬃናስ ሹኪዳ ꬋርሾዛ ኣሾፔ ዎይኮ ኡኬꬃፌ ማላዶ ጋካናስ ፓላሂዲ ኣቂኮ ዱማ ጊዲዳ ጊሻስ ታማን ጹጌቶ ኣቲን ሜቴቶፎ። ");
INSERT INTO gmve_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«ሄሳꬆ ሂስታዳ ላፑን ጋላስ ጋካናስ ታኒ ኔና ኣዛዚዳ ማላ ኣሮኔኔ ኢዛ ናይታ ቄሴ ሂስታዳ ሱንꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","«ናጋራይ ኣቶ ጌቴታና ማላ ሃች ሃች ናጋራ ጊሻስ ኢሲ ሚርጎ ያርሻ። ሄሳንካ ያርሺዛሶዛ ጌሻ፤ ሂስታዳ ያርሺዛሶዛ ዱማꬃናስ ዛይቴ ቲያ። ");
INSERT INTO gmve_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ያርሺዛሶዛ ናጋራ ጌሾ ዎጋ ላፑን ጋላስ ጋካናስ ዉርሳዳ ኢዛ ዱማꬃ። ሂስቲኮ ያርሺዛሶዚ ዱማ ጌሻሶሆ ጊዳና። ኢዛ ቦቺዛዴይ ኡባይ ጌሽ ጊዳና ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«ያርሺዛሶን ኔኒ ሃች ሃች ሺሻና ያርሾይ ሃይሳ፤ ዬሌቲን ኢሲ ላይꬅ ኩሞንታ ናምኡ ኣዴ ላቃ ያርሻ። ");
INSERT INTO gmve_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ኣዴ ላቃታፔ ኢሳ ማላዶ፥ ቃሴ ናምኣንꬆዛ ኦማርሳ ዎዴ ያርሻ። ");
INSERT INTO gmve_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ኮይሮ ꬋርሾ ላቃ ኢሲ ኪሎኔ ባጋ ሎኦ ጊስቴ ꬊሌ ኢሲ ሊቲሮ ጉምኤቲዳ ዛይቴን ሙኑቃዳ ያርሻ፤ ኢሲ ሊቲሮ ዎይኔ ኡሹ ኡሻ ያርሾ ሂስታዳ ያርሻ። ");
INSERT INTO gmve_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ናምኣንꬆ ꬋርሾ ላቃዛ ኦማርሳ ዎዴ ያርሻ። ማላዶይሳ ጊና ꬊሌ፥ ዛይቴኔ ዎይኔ ኡሹ ሺሻ። ሄሲካ ጎዳስ ታማን ጹጌቲዲ ሳዎ ቱኑ ጊዛ ያርሾ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","«ሃ ጹጌቲዛ ያርሾይ ዪዛ ዬሌታ ኡባን ጾሳ ዱንካኔዛ ፔንጌን ጎዳ ሲንꬃን ፓጬይ ባይንዳ ያርሼታናስ ኮሼስ። ታኒ ኢንቴናራ ጋጋናይኔ ኔስ ሃሳያናይ ሄንኮ። ");
INSERT INTO gmve_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ቃሴ ሄን ታኒ ኢስራኤሌ ናይታራ ጋጋናኔ ታ ቦንቾይካ ሄ ሶሆዛ ዱማ ሶሆ ሂስታና። ");
INSERT INTO gmve_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","«ሄሳ ጊሻስ ታኒ ጾሳ ዱንካኔዛኔ ያርሺዛሶዛ ዱማሳና፤ ኣሮኔይኔ ኢዛ ናይቲ ታስ ቄሴ ጊዲዲ ኦꬃና ማላ ታኒ ኢስታ ዱማሳና። ");
INSERT INTO gmve_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ሂስታዳ ታኒ ኢስራኤሌ ናይታ ጊዶን ዴኣና፤ ቃሴ ታኒ ኢስታ ጾሳ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ታኒ ኢስታ ጊዶን ዴኣና ማላ ጊብጼፔ ኢስታ ኬሲዳ ጎዳ ኢስታ ጾሳ ጊዲዳይሳ ኢስቲ ኤራና። ኤ፥ ታኒ ጎዳ ኢስታ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«ኤጻኔ ጩዋሲ ያርሺዛሶ ኦዶሮ ሚꬃፌ ጊጊሳ፤ ");
INSERT INTO gmve_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ኢዛስ ኦይዱ ዞዜይ ዴዮ፤ ኣዱሳቴꬃይ ኢሲ ዋꬋ፥ ኣሆቴꬃይ ኢሲ ዋꬋ፥ ꬎቃቴꬃይ ቃሴ ናምኡ ዋꬋ ጊዶ፤ ካጬቲካ ኢዛራ ኢሲ ቦላ ኦይኬቲ ኦሴቴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","ኢዛስ ቦላ ባጋ፥ ኦይዱ ሚሌታኔ ካጬታ ኡባ ዋላካይ ባይንዳ ዎርቃን ቲያ፤ ኢዛ ዩሾንካ ዎርቃ ባልጻንꬅ ዩሻ ኣꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ሄ ባልጻንꬃፌ ጋርሳራ ኤጻኔ ጩዋሲ ያርሺዛሶዛስ ዎርቃፌ ናምኡ ቃንጎታ ኦꬃዳ ሄ ባጋራኔ ሃ ባጋራ ኦይሴꬃ። ሄይቲ ቶኪዛ ዎዴ ቶሆ ሚꬃታ ጌልꬃናሳ። ");
INSERT INTO gmve_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ቶሆ ሚꬃታ ኦዶሮ ሚꬃፌ ኬሳዳ ዎርቃን ቲያ። ");
INSERT INTO gmve_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ሃ ያርሺዛሶዛ ጫቆ ቃላ ማርካይ ኢዛን ዲዛ ታቦታ ሲንꬃን ካቄቲዳ ማጋላሻፔ ካሬ ባጋራ፥ ጫቆ ቃላ ማርካ ቦላን ዲዛ ኣቶ ጌቴቲዛ ሶሆዛ ካማ ጊናራ ዎꬃ። ሄሲካ ታኒ ኔናራ ጋጊዛሶ። ");
INSERT INTO gmve_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","«ኣሮኔይ ማላዶ ማላዶ ጾምፔታ ጊጊሳናስ ዪዛ ዎዴ ሳዊዛ ኤጻኔ ያርሺዛሶዛን ጩዋሶ። ");
INSERT INTO gmve_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","ኣሮኔይ ኦማርሳ ዎዴ ጾምፔታ ፖኢሲዛ ዎዴ፥ ዛሬꬂዲካ ኤጻኔ ጩዋሶ፤ ሂስቲኮ ኤጻኔይ ጎዳ ሲንꬃን ዪዛ ዬሌታስ ኡባ ዎዴ ጩዋታና። ");
INSERT INTO gmve_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","ሃ ያርሺዛሶዛን ሃራ ዲጌቲዳ ኤጻኔካ፥ ዎይኮ ጹጌቲዛ ያርሾ፥ ዎይኮ ካꬃ ያርሾ ያርሾፋ፤ ኡሻ ያርሾካ ኢዛ ቦላ ቲጎፓ። ");
INSERT INTO gmve_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","ኣሮኔይ ላይꬃን ኢሲቶ ናጋራፔ ማሬታናስ ሹኪዛ ሜሄ ሱꬅ ኤኪዲ ሄ ያርሺዛሶዛ ቦላ ዲዛ ካጬታ ቦላ ቲዮ። ሂስቲዲ ጌሾ ዎጋ ፖሎ። ሃ ዎጋይ ሲንꬃራ ያና ዎዴታ ኡባን ላይꬃን ላይꬃን ኦꬄቶ። ሄሳꬆ ሃ ያርሺዛሶዚ ጎዳስ ዱማ ጌዪዳሶ ጊዶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","ሄሳፌ ጉዬ ጎዳይ ሙሴ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«ኔኒ ኢስራኤሌ ኣቱማ ኣሳ ታይቢዛ ዎዴ፥ ኢሲ ኢሲ ኣሲ ታይቤቲዲ ባ ሼምፖ ኣሻናስ ጎዳስ ሚሼ ኢሞ፤ ሂስቲኮ ኔኒ ኢስታ ታይቢዛ ዎዴ ኣሳ ቦላ ቦሻይ ዬና። ");
INSERT INTO gmve_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","ታይቤቲዳ ኣቱማ ኣሳይ ሁኤን ሁኤን ጾሳ ዱንካኔን ኤሬቲዳ ማካ ሚሻ ማላ ኮሺዛ ሚሽ ቃንጾ። ኢሲ ኢሲ ኣሲ ባስ ዲዛ ማላ ኢሞ። ");
INSERT INTO gmve_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ቆዳን ጌሊዛ ኣቱማ ኣሳ ላይꬃይ ናምኡ ታሙ ኩሚዳይኔ ሄሳፌ ቦላይ ዉሪ ጎዳስ ኢሞታ ኤሆ። ");
INSERT INTO gmve_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ኢንቴ ኢንቴ ሼምፖ ኣሻናስ ጎዳስ ኢሞታ ኢሚሺን፥ ዱሬይካ ማንቆይካ ኢሲ ማላ ኢማናፔ ኣቲን፥ ዱሬይ ዳርሲዲ ዎይኮ ማንቆይ ጉꬂዲ ኢሞፎ። ");
INSERT INTO gmve_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ባ ሼምፖ ኣሻናስ ኢሚዛ ሚሼ ኢስራኤሌ ኣሳፔ ኤካዳ ጾሳ ዱንካኔዛ ኦሶስ ፔይሻ። ሃ ሚሻይ ኢንቴ ሼምፖ ዎዛናስ፥ ጎዳ ሲንꬃን ኢስራኤሌ ኣሳ ጊሻስ ሃሳኢሲዛዝ ጊዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","ሄሳፌ ጉዬ ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«ሜቻ ኬሬዛኔ ኬሬዛ ኢዛ ቦላ ዎꬂዛ ሚሽ ጻርቂማላፔ ሜꬋ። ጾሳ ዱንካኔዛፔኔ ያርሺዛሶዛፔ ጊዶን ዎꬃዳ ኢዛን ሃꬅ ቲጋ። ");
INSERT INTO gmve_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ሄ ሃꬃን ኣሮኔይኔ ኢዛ ናይቲ ባ ኩሼኔ ባ ቶሆ ሜጬቴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ኢስቲ ሃይቆንታ ማላ ጾሳ ዱንካኔዛን ጌልሼ ኣይዴካ ሄ ሃꬃን ሜጬቴቶ። ቃሴ ጎዳስ ታማን ያርሾ ያርሻናስ ያርሺዛሶ ማታ ሺቂዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ኢስቲ ሃይቆንታ ማላ ባ ኩሼኔ ባ ቶሆ ሜጬቴቶ። ሃይሲ ኣሮኔሲኔ ኢዛ ዜሬꬃታስ፥ ዪዛ ዬሌታ ኡባስ ሜርና ዎጋ ጊዶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","ጎዳይ ሙሴ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«ሎኦ ቂማሜታ፥ ሄይቲካ ኡሱፑን ኪሎ ጎጊዛ ካርቤ፥ ሄꬑ ኪሎ ሳዊዛ ቃራፋ፥ ሄꬑ ኪሎ ሳዊዛ ጉጫቻ ማታኔ ");
INSERT INTO gmve_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ኡሱፑን ኪሎ ቡርጉዴ ኤካ። ሃይሲ ዉሪካ ጾሳ ዱንካኔን ኤሬቲዳ ሜዛኔን ሜዛኔቲዳ ጊዶ። ሄሳ ቦላካ ኦይዱ ሊቲሮ ዎጋራ ዛይቴ ጉጃ ኤካ። ");
INSERT INTO gmve_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ሄይታንታ ሺቶ ኦꬂዛ ማላ ዋላካዳ ሳዊዛ ጌሻቴꬃስ ቲዬቲዛ ዱማ ዛይቴ ጊጊሳ። ");
INSERT INTO gmve_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ሂስታዳ ጾሳ ዱንካኔዛ፥ ጫቆ ቃላ ማርካይ ኢዛን ዲዛ ታቦታ፥ ");
INSERT INTO gmve_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ጻራጴዛኔ ኢዛን ጎኤቲዛ ሚሻታ ኡባ፥ ጾምፔ ዎꬂዛ ባላኔ ኢዛ ሚሻታ፥ ኤጻኔ ጩዋሲ ያርሺዛሶዛ፥ ");
INSERT INTO gmve_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ጹጌቲዛ ያርሾ ያርሺዛሶዛኔ ኢዛን ጎኤቲዛ ሚሻታ ኡባ፥ ሜቻ ኬሬኔ ኢዛ ዎꬂዛሶዛ ኡባ ቲያ። ");
INSERT INTO gmve_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","ኢስቲ ኬሂ ጌሽ ጊዳና ማላ ኔኒ ኢስታ ዱማሳ፤ ኢስታ ቦቺዛይ ዉሪካ ጌሽ ጊዳናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","«ቃሴካ ኣሮኔይኔ ኢዛ ናይቲ ቄሴ ጊዲዲ ታስ ኦꬃና ማላ ኢስታ ቲያዳ ዱማሳ፤ ");
INSERT INTO gmve_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ኢስራኤሌ ኣሳስ፥ ‹ሃይሲ ቡሮ ያና ዬሌታስካ ቲዬቲዛ ጌሻ ዛይቴ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ሃ ዛይቴዛ ሃራ ኣስ ቲዮፓ፤ ቃሴ ሃራ ዛይቴ ሄሳꬆ ጊጊሶፋ። ኢዚ ዱማ ጊዲዳ ጊሻስ ኢንቴካ ኢዛ ዱማቴꬅ ኤሪቴ። ");
INSERT INTO gmve_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ሃይሳ ማላ ሺቶ ጊግሲዛ ኣሲኔ ቲዬታናስ ቤሶንታ ሃራ ኣስ ቲዪዛ ኣሲ ኦኒካ ባ ኣሳ ጋርሳፌ ꬋዮ› ጋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","ሄሳፌ ጉዬ ጎዳይ ሙሴስ፥ «ሳዊዛ ቂማሜታ፥ ሚꬃ ኡዛስ፥ ሄሌሎን ዲዛ ሺቶ፥ ሳዊዛ ሺዳኔ ሃራራ ዋላኬቶንታ ኤጻኔ ኤካ፤ ኢስታ ኡባ ሜዛኔይካ ኢሲ ጊና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ሺቶ ማላ ዋላኬቲዳ ኤጻኔ ኦꬃዳ ኢስታን ጎኤታ፤ ዋላካይ ባይንዳ ጌሺኔ ዱማ ጊዳና ማላ ኢዛን ማጺኔ ዬጋ። ");
INSERT INTO gmve_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","ኢዛፔ ኤካዳ ሊቂሳ ጫዳ፤ ሂስታዳ ታኒ ኔናራ ጋጊዛ ጾሳ ዱንካኔዛ ጊዶን ጫቆ ቃላ ማርካይ ኢዛን ዲዛ ታቦታ ሲንꬃን ኤጻኔ ጩዋሲ ያርሺዛሶዛ ቦላ ዎꬃ። ኢዚ ኔስ ኡባፌ ኣꬊዳ ጌሽ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ሃይሳ ጊግሲዳይሳꬆ ሃራ ኤጻኔ ጊጊሶፍቴ። ሄሲ ታስ ዱማ ጌሽ ጊዲዳይሳ ኔ ኤራ። ");
INSERT INTO gmve_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ሄሳ ሚሳቲዛዝ ጊግሲዲ ኢዛ ሳዎ ሲንጊዲ ኡፋዬታናስ ኮይዛ ኣሲ ዲኮ ኢዚ ባ ኣሳ ጋርሳፌ ꬋዮ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","ቃሴካ ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«ቤያ፤ ታኒ ዩሁዳ ዜሬꬅ ጊዲዳ ሁሬስ ናዛ ና፥ ኡሬይ ና፥ ባስሊኤሌ ዶራዲስ። ");
INSERT INTO gmve_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ኢዛ ታኒ ታ ኣያናን፤ ሂላቴꬃን፥ ኣኬካኒኔ ኦሶ ኡባ ኦꬂዛ ኤራቴꬃን ኩንꬃዲስ። ");
INSERT INTO gmve_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ሄሲካ ኢዚ ቆፒ ቆፒዲ ሂላቴꬃን፥ ዎርቃፌ፥ ቢራፔኔ ጻርቂማላፔ ዱማ ዱማ ሚሽ ኦꬃናሳ። ");
INSERT INTO gmve_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ሄሳꬆካ ኣልኦ ሹች ማሲ ማሲዲ ጊጊሳናስ፥ ሚꬅ ማሳናሲኔ ሄይታንታ ኡባ ኦꬃናሳ። ");
INSERT INTO gmve_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","«ሄሳ ቦላካ ቃሴ ኢዛ ማዳና ማላ፥ ዳኔ ዜሬꬅ ጊዲዳ ኣሂሳሜኬ ና ኤላቤ ዶራዲስ። ታኒ ኔና ኣዛዚዳይሳ ኡባ ኢስቲ ኦꬃና ማላ፥ ኩሼ ሂላቴꬅ ኤሪዛይታ ኡባስ ኤራቴꬅ ኢማዲስ። ");
INSERT INTO gmve_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ኢስቲ ኦꬃናይሲ ጾሳ ዱንካኔ፥ ጫቆ ቃላይ ኢዛን ዲዛ ታቦታኔ ታቦታዛ ቦላ ዎꬂዛ ኣቶቴꬃ ካማ፥ ጾሳ ዱንካኔዛ ኦꬃናስ ጎኤቲዛ ሚሻታ ኡባ፥ ");
INSERT INTO gmve_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ጻራጴዛኔ ኢዛ ሚሻታ፥ ዋላካይ ባይንዳ ዎርቃፌ ኦሴቲዳ ጾምፔ ኢዛ ቦላ ዎꬂዛ ሚሽ ኡባራ፥ ኤጻኔ ጩዋሲ ያርሺዛሶዛ፥ ");
INSERT INTO gmve_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ጹጌቲዛ ያርሾ ያርሺዛሶዛኔ ኢዛ ሚሻታ ኡባራ፥ ሜጬቲዛ ኬሬኔ ኬራ ኢዛ ቦላ ዎꬂዛ ሚሻራ፥ ");
INSERT INTO gmve_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ዳዴቲ ኦሴቲዳ ጫርቃታ፥ ቄሴ ኣሮኔይ ማይኢዛ ዱማ ማይኦ፥ ኢዛ ኣቱማ ናይቲ ቄሴቴꬃ ኦሶ ኦꬂሼ ማይኣና ማይኦ፥ ");
INSERT INTO gmve_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ቃሴ ቲዬቲዛ ዛይቴኔ ጌሻ ሶዛስ ሳዎ ቱኑ ጊዛ ኤጻኔ። ኢስቲ ሃይሳ ኡባ ታኒ ኔና ኣዛዚዳ ማላ ኦꬃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","ሄሳፌ ጉዬ ጎዳይ ሙሴ፥ ");
INSERT INTO gmve_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«ኔኒ ኢስራኤሌ ኣሳስ፥ ‹ታ ሳምባታ ሎኤꬂ ናጊቴ። ሄሲ ታኒ ጎዳይ ኢንቴና ታስ ዱማ ሂስታዳ ዶሪዳይሳ ቤሲዛዝ ጊዲዲ ያና ዬሌታ ኡባስ ታፔኔ ኢንቴፌ ጊዶን ማላታ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","ኢንቴስ ሄ ጋላሳይ ዱማ ጊዲዳ ጊሻስ ሳምባታ ናጊቴ። ኢዛ ቱኒሲዛ ኣሲ ሙሌ ሃይቃናስ ቤሴስ፤ ሄ ጋላሳን ኦሶ ኦꬂዛይ ኦኒካ ባ ኣሳ ጋርሳፌ ꬋዮ። ");
INSERT INTO gmve_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ኡሱፑን ጋላሳታን ኢንቴ ኦሶ ኦꬂቴ፤ ጊዶ ኣቲን ላፑንꬃ ጋላሳይ ታስ ጎዳስ ዱማቲዳ ሼምፖ ሳምባታ፤ ሄ ጋላሳን ኦꬂዛዴይ ኦኒካ ሙሌራ ሃይቃናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ኢስራኤሌ ኣሳይ ሄ ሳምባታ ጋላሳ ና ናስ ሜርናስ ማላታ ሂስቲዲ ናጎ። ");
INSERT INTO gmve_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ታኒ ኡሱፑን ጋላሳታን ሳሎኔ ሳኣ ሜꬋዳ ላፑንꬃ ጋላሳን ኦሶ ኣጋዳ ሼምፒዳ ጊሻስ፥ ታሲኔ ኢስራኤሌ ናይታስ ጊዶን ሃይሲ ሜርናስ ጫቆ ጊዳና› ጋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ጎዳይ ሙሴራ ሲና ዙማ ቦላ ሃሳይዛይሳ ዉርሲዳ ማላ ኢዚ ባ ቢራꬌን ጻፊዳ ታሙ ኣዛዞታ ኦይኪዳ ናምኡ ማሴቲዳ ሹቻታ ሙሴስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","ሙሴይ ዙማፔ ዎꬎንታ ኬሂ ጋምኢዳይሳ ቤኢዲ ኣሳይ ኣሮኔ ዩሾን ሺቂዲ፥ «ኣኔ ሃያ፤ ኔኒ ኑና ካሌꬂዛ ኤቃ ጾሳታ ኑስ ሜꬋ። ጊብጼ ቢታፌ ኑና ኬሲዳ ሙሴይ ጊዲኮ ኢዚ ዋኒዳኮ ኑ ኤሮኮ!» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","ሂስቲን ኣሮኔይ ኢስታስ፥ «ኢንቴ ማቼታ ሃይꬃን፥ ኢንቴ ኣቱማ ናይታ ሃይꬃኒኔ ማጫ ናይታ ሃይꬃን ዲዛ ዎርቃ ኬሲዲ ታስ ሃ ኤኪ ዪቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","ሄሳፌ ጉዬ ኣሳይ ዉሪ ባ ሃይꬃ ዎርቃ ኬሲዲ ኣሮኔስ ኤሂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ኢዚ ሄሳ ኢስታ ኩሼፔ ኤኪዲ ታማን ሴሪሲዳፔ ጉዬ ቆጺዛ ሚሻን ቆጺዲ ማራ ሚስሌ ሜꬊዴስ። ሄሳፌ ጉዬ ኣሳይካ፥ «ኢስራኤሌ ኣሳዉ! ኑና ጊብጼ ቢታፌ ኬሲዳ ኑ ጾሳቲ ሃይታንታ» ጊዴስ ");
INSERT INTO gmve_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ኣሮኔይ ሄሳ ቤኢዲ ማራ ሚስሌዛ ሲንꬃን ያርሺዛሶ ጊግሲዲ፥ «ዎንቶ ጎዳስ ባኣሌ ጋላስ ጊዳና» ጊ ኣዋጂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ሄሳ ጊሻስ ዎንቴꬃ ጋላስ ኣሳይ ዎንታራ ዴንዲዲ ጹጌቲዛ ያርሾታኔ ኢሲፌቴꬃ ያርሾታ ያርሺዴስ። ሂስቲዲ ኣሳይ ማናሲኔ ኡያናስ ኡቲዴስ። ሚ ኡዪ ሲሚዲ ቃሴ ዱራናሲኔ ጉፓናስ ዴንዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ሂስቲን ጎዳይ ሙሴስ፥ «ኔ ጊብጼፔ ኬሳ ኤሂዳ ኔ ኣሳይ ናጋራ ኦꬂዲ ባናቴꬃ ቱኒሲዳ ጊሻስ ኤሶን ዱጌ ዎꬋ። ");
INSERT INTO gmve_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ታኒ ኢስታ ኣዛዚዳ ኦጌፔ ኢስቲ ኤሶን ሼርኢ ጊቺዳ። ዎርቃ ሴሪሲዳይሳ ማራ ሚሳቲሲዲ፥ ባስ ኤቃ ጾሳታ ሜꬊዲ ኢዛስ ጎይኒዳኔ ያርሺዳ። ቃሴካ፥ ‹ኢስራኤሌ ኣሳዉ! ኑና ጊብጼ ቢታፌ ኬሲዳ ኑ ጾሳቲ ሃይታንታ› ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","«ታኒ ሃ ኣሳ ቤያዲስ፤ ኢስቲ ባንታ ዎዚና ሙሚዳ ኣሳ። ");
INSERT INTO gmve_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ሃኢ ታ ሃንቆይ ኢስታ ቦላ ኤጺ ኬዚን ታኒ ኢስታ ꬋይሳናይሳ ኔኒ ታና ዲጎፋ። ሄሳፌ ቃሴ ታ ኔና ጊታ ካዎቴꬅ ሂስታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ጊዶ ኣቲን ሙሴይ ጎዳ ባ ጾሳ፥ «ኣቤት ጎዶ! ኔኒ ኔ ጊታ ዎልቃኒኔ ኔ ሚኖ ቄሴን ጊብጼፔ ኬሳዳ ኤሂዳ ኔ ኣሳ ቦላ ሄሳꬆ ኣዛስ ሃንቄታይ? ");
INSERT INTO gmve_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","ጊብጼ ኣሳይ፥ ‹ኢዚ ኢስታ ዙማታ ቦላን ዎꬋናሲኔ ቢታፌ ፒቲ ꬋይሳናስ ኢታ ቆፋን ኬሲዴስ› ኣይስ ጌቴታይ? ኔኒ ኔ ዎልቃማ ሃንቆፌ ሲማ፤ ኣሳ ꬋይሳናስ ቆፒዳይሳ ኣጋ። ");
INSERT INTO gmve_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ኔ ኣይሌታ ኣብራሃሜ፥ ዪሳቃኔ ያቆቤ ቆፓ፤ ኔኒ ኢስታስ፥ ‹ታኒ ኢንቴ ዜሬꬅ ሳሎ ጾሊንቴ ማላ ዳርሳና፤ ታኒ ኢንቴስ ኢማና ጊዳ ቢታ ኡባካ ኢንቴ ዜሬꬃታስ ኢማና፤ ኢስቲ ሄ ቢታ ሜርናስ ላታና› ጋዳ ኔኒ ኔ ሱንꬃን ጫቂዳ ቃላ ዩሻ ቆፓ» ጊዲ ጋናቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","ሄሳ ጊሻስ ጎዳይ ባ ኣሳ ቦላ ኢታ ሚሽ ኤሃናስ ቆፒዳይሳ ኣጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ሄሳፌ ጉዬ ሙሴይ ዙማ ቦላፌ ዱጌ ዎꬊሼ ታሙ ኣዛዞቲ ኢስታ ቦላ ናምኡ ባጋራ ጻፌቲ ኡቲዳ ናምኡ ማሴꬃ ሹቻታ ባ ኩሼን ኦይኪ ኤኪ ዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ሄ ማሴቲዳ ሹቻታ ጊግሲዳይ ጾሳ፤ ሹቻታ ቦላ ዎጪዲ ጻፊዳይካ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ኢያሶይ ኣሳይ ዎጫሚዛይሳ ሲዪዲ ሙሴስ፥ «ኣሳይ ዲዛሶን ኦላ ዋሶይ ሲዬቴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","ሙሴይካ ዛሪዲ፥ «ታኒ ሲዪዛይሲ ሃይሲ ዬꬃፌ ኣቲን፥ ኦላን ጾኒዳይታ ቃላ ዎይኮ ጾኔቲዳይታ ቃላ ዴና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","ሙሴይ ዴሬዚ ዲዛሶ ማቲሼ ማራ ሚስሌዛ ሲንꬃን ኣሳይ ዱሪሺኒኔ ጉፒሺን ቤኢዲ ኬሂ ሃንቄቲዲ ማሴቲዳ ሹቻታ ዙማ ጋርሳን ቦላፌ ዬጊዲ ሜንꬄሬꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ኣሳይ ሜꬊዳ ማራካ ኤኪዲ ታማን ጹጊዴስ፤ ሄሳፌ ጉዬ ሊቂሲ ጋጪ ሃꬃን ማꬊዲ ኢስራኤሌ ኣሳይ ኡያና ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","ሄሳፌ ጉዬ፥ ሙሴይ ኣሮኔ፥ «ሃ ኣሳይ ኔና ዎስቲን ኔኒ ኢስታ ሃይሳ ማላ ጊታ ናጋራ ኦꬃና ማላ ካሌꬃዲ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","ኣሮኔይካ ዛሪዲ፥ «ታ ጎዶ፥ ሃንቄቶፋ! ሃይሲ ኣሳይ ኢታ ኦꬃናስ ኣይ ማላ ኮይዛኮ ኔ ኤራሳ። ");
INSERT INTO gmve_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ኢስቲ ታና፥ ‹ኑና ካሌꬂዛ ኤቃ ጾሳታ ኑስ ሜꬋ። ኣይስ ጊኮ ኑና ጊብጼፔ ኬሲ ኤሂዳ ሙሴይ ኢዚ ዋኒዳኮ ኑ ኤሮኮ!› ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ሂስቲን ታኒ ኢስታስ፥ ‹ኢንቴ ቦላ ዲዛ ዎርቃ ኬሲዲ ሃሚቴ› ጋዲስ፤ ሄሳፌ ጉዬ ኢስቲ ታስ ኢሚዳ ዎርቃ ታኒ ታማን ዬጊን ሃይሲ ማራይ ኬዚዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","ኣሮኔይ ኣሳ ላኣ ዬዲ ኣጊን ኣሳይ ባ ሞርኬታ ሲንꬃን ካዉዪዲ ካꬌታናይሳ ሙሴይ ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ሄሳ ጊሻስ ሙሴይ ኣሳይ ዱንካኒዲ ዲዛሶ ጌሊዛ ፔንጌን ኤቂዲ፥ «ጎዳ ባጋ ጊዲዳ ኣሲ ኦኒካ ታኮ ሃ ዮ!» ጊን ሌዌ ቆሞቲ ዉሪ ኢዛኮ ሺቂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ሄሳፌ ጉዬ ኢዚ ኢስታስ፥ «ጎዳ ኢስራኤሌ ጾሳይ፥ ‹ኣሳይ ዉሪ ባ ጊꬃ ማሻ ባ ጼሳን ጼሳን ጊጺዲ ኣሳይ ዱንካኒዳሶን ጋጻፔ ጋጻ ጋካናስ፥ ኣሳ ጊዶን ያኔ ሃ ሲሜሬቲዲ ባ ኢሻ፥ ባ ላጌኔ ባ ሾሮ ዎꬎ› » ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ሌዌ ቆሞቲ ሙሴይ ኣዛዚዳ ማላ ኦꬂዳ፤ ሄ ጋላስ ኣሳፔ ሄꬑ ሺ ጊዲዛ ኣሲ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ሄሳፌ ጉዬ ሙሴይ ሌዌ ቆሞታ፥ «ሃች ኢንቴ ጎዳስ ዱማቲዴታ፤ ኣይስ ጊኮ ኢንቴ ኢንቴ ናይታኔ ኢንቴ ኢሻታ ዎꬋናስ ኣዛዜቲዲ ዎꬊዴታ፤ ሃች ጎዳይ ኢንቴና ኣንጂዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ዎንቴꬃ ጋላስ ሙሴይ ኣሳ፥ «ኢንቴ ጊታ ናጋራ ኦꬂዴታ ሺን ሃኢ ታኒ ጎዳኮ ፑዴ ዙማ ቦላ ኬዛና፤ ታ ኢንቴ ናጋራ ኣቶ ጊሳናኮ ኦኔ ኤሪዛይ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","ሂስቲን ሙሴይ ጎዳኮ ሲሚ ቢዲ፥ «ሃይሲ ኣሳይ ጊታ ናጋራ ኦꬂዴስ፤ ኢስቲ ባስ ዎርቃፌ ኤቃ ጾስ ሜꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ጊዶ ኣቲን ኣቤት ጎዶ! ሃኢ ኢስታ ናጋራ ኣቶ ጋ፤ ኣካይ ጊኮ ኔኒ ጻፊዳ ማዝጋባፔ ታ ሱንꬃ ቁጫ ዲጋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","ሂስቲን ጎዳይ ዛሪዲ ሙሴስ፥ «ታኒ ታ ማዝጋባፔ ታ ቦላ ናጋራ ኦꬂዳ ኣሳታ ሱንꬃ ቁጫና። ");
INSERT INTO gmve_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ሃኢ ባዳ ሃ ኣሳ ታኒ ኔስ ዮቲዳ ሶ ካሌꬃ፤ ታ ኪታንቻይካ ኔና ካሌꬃና፤ ጊዶ ኣቲን ቃጻያና ዎዴይ ጋኪሺን ኢስታ ናጋራ ጊሻስ ታ ኢስታ ቃጻያና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ኣሮኔይ ዎርቃፌ ማራ ሚስሌ ሜꬋና ማላ ኣሳይ ኢዛ ዋዪሲዳ ጊሻሲኔ ኢዚ ሜꬊዳ ጊሻስ ጎዳይ ኢስታ ቦላ ቦሻ ዬዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","ሄሳፌ ጉዬ ጎዳይ ሙሴስ፥ «ኔኒኔ ኔ ጊብጼፔ ኬሲዳ ኣሳይ ሃይሳፌ ዴንዲዲ፥ ‹ታኒ ኢንቴ ዜሬꬃታስ ኢማና› ጋ ዎꬂዳ ቢታ ቢቴ። ሄ ቢታይ ታኒ ኣብራሃሜስ፥ ዪሳቃሲኔ ያቆቤስ ኢማና ጋዳ ካሴ ጫቃ ዎꬂዳይሳ። ");
INSERT INTO gmve_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ታኒ ኢንቴፌ ሲንꬃራ ኪታንቻ ኪታዳ፥ ካናኔታ፥ ኣሞሬታ፥ ሂቴታ፥ ፓሪዜታ፥ ሂዌታኔ ያቡሴታ ጎዳና። ");
INSERT INTO gmve_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ማꬂኔ ኤሲ ጎጊዛ ሄ ቢታ ቢቴ። ጊዶ ኣቲን ኢንቴ ዎዚና ሙሜ ኣስ ጊዲዳ ጊሻስ ታኒ ኢንቴና ኦጌን ꬋይሶንታ ማላ ታ ኢንቴናራ ቢኬ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ኣሳይ ሄሳ ኢታ ዮኦዛ ሲዪዲ ኬሂ ዬኪዴስ። ሄ ዎዴፔ ዶሚዲ ኣሳይ ዉሪካ ኣሌቆስ ኣꬂዛይሳ ኣጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","ጋሶይካ ጎዳይ ሙሴስ፥ «ኢስራኤሌ ኣሳስ፥ ‹ኢንቴ ዎዚና ሙሚዳ ኣሳ። ሃራይ ኣቶሺን ጉꬃ ዎዴ ታ ኢንቴናራ ኢሲፌ ቢዛኮ ታኒ ኢንቴና ꬋይሳና። ሃኢ ኢንቴ ኣሌቆ ኬሲቺቴ፤ ሂስቲኮ ታኒ ኢንቴ ቦላ ኣይ ኦꬃናኮ ኢንቴ ቤያና› ጋ» ጊ ዮቲ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ኢስራኤሌ ኣሳይ ሲና ዙማፔ ዶሚዲ ባ ኣሌቆ ሚሻ ኬሲ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","ሙሴይ ዱንካኔዛ ኤኪ ኤፊዲ ኣሳይ ዱንካኒዳሶፔ ሃሲ ቶሊዴስ። ዱንካኔዚ፥ «ጋይቶቴꬃ ዱንካኔ» ጌቴቲ ሱሚዴስ። ጎዳ ኦይቻናስ ኮይዛይ ዉሪ ሄ ጋይቴꬃ ዱንካኔይ ዲዛሶ ቤስ። ");
INSERT INTO gmve_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","ሙሴይ ሄ ዱንካኔዛኮ ቢዳ ዎዴ ኣይዴካ ኣሳይ ዉሪ ባ ዱንካኔዛ ፔንጌን ፔንጌን ኤቂዲ ሙሴይ ዱንካኔዛን ጌላና ጋካናስ ኢዛ ጼሌስ። ");
INSERT INTO gmve_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ሙሴይ ጋይቴꬃ ዱንካኔዛ ጊዶ ጌሊዳ ዎዴ ቱሳ ማላ ሻራይ ዱጌ ዎꬊን ጎዳይ ሙሴራ ሃሳይሼ ዱንካኔዛ ፔንጌን ጋምኤስ። ");
INSERT INTO gmve_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ቱሳ ማላ ሻራዛ ዱንካኔዛ ፔንጌን ቤኢዳ ኡባ ዎዴ፥ ኣሳይ ዉሪ ባ ፔንጌን ፔንጌን ኤቂዲ ዲዛሶሆን ዲሼ ጎዳስ ጎይኔስ። ");
INSERT INTO gmve_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ኣሲ ባ ላጌራ ሃሳይዛ ማላ ጎዳይ ሙሴራ ሲንꬃን ኤቂዲ ሃሳዬስ። ሄሳፌ ጉዬ ሙሴይ ዱንካኔይ ዲዛሶ ጉዬ ሲሜስ ሺን ኢዛ ማዲዛ ናቴꬃ ና፥ ናዌ ና ኢያሶይ ጋይቶቴꬃ ዱንካኔዛፔ ሻኬቴና። ");
INSERT INTO gmve_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","ሙሴይ ጎዳስ፥ «ኔኒ ታና፥ ‹ሃይሳ ኣሳ ካሌꬃ› ጋዳሳሺን ታናራ ኔኒ ኦና ኪቲዛኮ ታና ኤሪሳቤካ። ኔኒ፥ ‹ታኒ ኔና ኔ ሱንꬃን ኤራይስ፤ ኔኒ ታ ሲንꬃን ሳቤቲዳ ኣሳ› ጋዳሳ። ");
INSERT INTO gmve_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ኔ ሲንꬃን ታ ሳቤቲዳ ጊዲኮ ታኒ ኔና ኤራና ማላኔ ሲንꬃፌካ ኔ ሲንꬃን ሳቤታሼ ዳና ማላ፥ ኔ ኦጌ ታና ታማርሳ። ሃ ኣሳይ ኔ ኣሳ ጊዲዳይሳ ቆፓ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","ሂስቲን ጎዳይ ዛሪዲ፥ «ታኒ ኔናራ ባና፤ ታኒ ኔና ሼምፒሳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","ሂስቲን ሙሴይ ኢዛ፥ «ኔኒ ኑናራ ቦንታ ጊዲኮ ሃይሳፌ ኑና ኬሶፋ። ");
INSERT INTO gmve_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ኔኒ ኑናራ ቦንታ ኢጺኮ ታናኒኔ ኔ ኣሳን ኔኒ ሳቤቲዳይሳ ኣሳይ ዉሪ ዎስቲ ኤራኔ? ቢታ ቦላ ዲዛ ሃራ ኣሳ ኡባፌ ታናኔ ኔ ኣሳ ዱማሲዛይ ሃራ ሚሺ ኣዜ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","ሂስቲን ጎዳይ ሙሴ፥ «ታ ኔናን ሳቤቲዳ ጊሻሲኔ ኔና ኔ ሱንꬃን ኤሪዛ ጊሻስ ኔኒ ታና ኦይቺዳይሳ ቃሴካ ታኒ ኦꬃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","ሂስቲን ሙሴይ፥ «ሂስቲኮ ኔ ጊታ ቦንቾዛ ታና ቤሳርኪ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ጎዳይ፥ «ታኒ ታ ሎኤቴꬃ ኡባ ኔ ሲንꬃራ ኣꬃና፤ ታ ጌሻ ሱንꬃካ ኔ ኣቻን ኣዋጃና። ታኒ ጎዳ፤ ታኒ ማራናስ ኮይዛይታ ማራና፤ ቃሴ ሚሼታናስ ኮይዛይታስካ ሚሼታና። ");
INSERT INTO gmve_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ጊዶ ኣቲን ኔኒ ታ ኣይፌሶ ቤያካ፤ ኣይስ ጊኮ ኦኒካ ታና ቤኢዲ ፓጻ ኣቴና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ሄሳፌ ጉዬ ጎዳይ፥ «ኔኒ ታ ኣቻን ኤቃናስ ዛላ ቦላ ኤቃናሶይ ሃይሳን ዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ታ ቦንቾይ ኣꬊ ቢዛ ዎዴ ታኒ ኔና ዛላ ዛኣ ጊዶን ዎꬃና። ኣꬋና ጋካናስ ታ ኩሼን ኔና ካማና። ");
INSERT INTO gmve_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ሄሳፌ ጉዬ ታኒ ታ ኩሼ ዲጊኮ ኔኒ ታ ዞኮ ቤያናሺን ታ ኣይፌሶይ ቤታናስ ቤሴና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","ጎዳይ ሙሴስ፥ «ኮይሮይታ ሚሳቲዛ ናምኡ ሹቻታ ማሳ ጊጊሳ፤ ሂስቲኮ ታኒ ሄ ማሴቲዳ ሹቻታ ቦላ ካሴ ኔኒ ሜንꬂዳ ሹቻታ ቦላን ዲዛ ቃላታ ጻፋና። ");
INSERT INTO gmve_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","ዎንቶ ማላዶ ፑዴ ሲና ዙማ ቦላ ኬዛናስ ጊጌታ፤ ሂስታዳ ታናራ ሄን ዙማ ቦላን ጋጋ። ");
INSERT INTO gmve_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","ኔናራ ኦኒካ ኬዞፖ፤ ዎይኮ ዙማ ቦላ ኣዋንካ ቤቶፎ፤ ሃራይ ኣቶሺን ዶርሲ ዎይኮ ሜሄ ዉዴይካ ዙማ ሲንꬃን ሄሜቶፎ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ሄሳ ጊሻስ ሙሴይ ኮይሮ ሹቻታ ሚሳቲዛ ናምኡ ሹቻታ ማሲዲ ጎዳይ ኣዛዚዳ ማላ፥ ሹቻታ ባ ኩሼን ኦይኪ ኤኪዲ፥ ማላዶ ዎንታራ ፑዴ ሲና ዙማ ቦላ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","ኬዚን ጎዳይ ሻራራ ዱጌ ዎꬊ ኢዛራ ሄን ኤቂዲ ባ ሱንꬃ፥ «ጎዳ» ጊ ኤሪሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","ጎዳይ ሙሴ ሲንꬃራ፥ «ታኒ ጎዳይ ቃꬌታይኔ ማሮታይ ኩሚዳ ጾሳ፥ ሃንቄታናስ ጋምኢዛ፥ ሜርናስ ሲቂዛኔ ኣማኔቴꬃይ ዳሪዳ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ታኒ ታ ሜርና ሲቆዛ ሺ ዬሌታ ጋካናስ ናጋይስ፤ ኢታቴꬅ፥ ማካላኔ ናጋራ ኣቶ ጋይስ። ጊዲኮካ ሞሪዛዴ ቃጻዮንታ ኣጊኬ፤ ኣዋታ ናጋራ ጊሻስ ናይታኔ ናይታ ናይታ፥ ሄꬓንꬆ ዬሌታኔ ኦይዳንꬆ ዬሌታ ጋካናስ ቃጻያይስ» ጊ ኣዋጂሼ ኣꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","ሂስቲን ሙሴይ ሄራካ ቢታ ቦላ ጉፋኒ ጎይኒዲ፥ ");
INSERT INTO gmve_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","«ኣቤት ጎዶ! ኔኒ ታናን ኡፋዬቲዳ ጊዲኮ ኔ ኑናራ ኢሲፌ ባና ማላ ታ ኔና ዎሳይስ። ሃይሲ ኣሳይ ዎዚና ሙሜ ጊዲኮካ ኑ ኢታቴꬃኔ ኑ ናጋራ ኣቶ ጋዳ ኑና ኔ ኣስ ሂስታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ሂስቲን ጎዳይ፥ «ታኒ ኢንቴናራ ጫቆ ጌላዲስ፤ ሃይሳፌ ካሴ ቢታ ቦላ ዲዛ ካዎቴꬅ ኡባን ሃኒ ኤሮንታ ማላሊሲዛ ሚሽ ኔ ኣሳ ኡባ ሲንꬃን ኦꬃና፤ ታኒ ጎዳይ ኢንቴስ ኦꬂዛ ኦሶይ ኣይ ማላ ማላሊሲዛዛኮ ኔኒ ኢስታ ጊዶን ዲዛ ኣሳይ ቤያና። ");
INSERT INTO gmve_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ሃች ታኒ ኢንቴና ኣዛዚዛ ኣዛዞ ናጊቴ፤ ኢንቴ ሲንꬃፌ ኣሞሬታ፥ ካናኔታ፥ ሂቴታ፥ ፓሪዜታ፥ ሂዌታኔ ያቡሴታ ታኒ ጎዳና። ");
INSERT INTO gmve_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ኢስቲ ኢንቴስ ናርጻ ጊዶንታ ማላ ኢንቴ ቢዛ ቢታን ዲዛ ኣሳራ ጫቆ ጫቄቶፍቴ። ");
INSERT INTO gmve_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","ኢስቲ ያርሺዛሶሆታ ላሊቴ፤ ኢስቲ ጎይኒዛ ሹቻታካ ሜንꬄሬꬂቴ፤ ቃሴ ኣሼሮ ጌቴቲዛ ኢስታ ማጫ ኤቃ ጾሳይ ሚስሌታካ ሜንꬄሬꬂ ዬጊቴ። ");
INSERT INTO gmve_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","ታኒ ጎዳይ ቃናቲዛ ጾሳ ጊዲዛ ጊሻስ ታፔ ኣቲን ሃራ ኤቃ ጾሳታስ ጎይኖፍቴ። ");
INSERT INTO gmve_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","«ሄ ቢታን ዲዛ ኣሳታራ ኣይ ጫቆካ ጫቄቶፍቴ፤ ኣይስ ጊኮ ኢስቲ ታናን ኣማኔቶንታ ኢጺዲ ባ ኤቃታ ካሊዛ ዎዴኔ ኢስታስ ያርሺዛ ዎዴ ኢስቲ ኢንቴና ጼይጊኮ ኢንቴ ኢስታ ያርሾ ማና። ");
INSERT INTO gmve_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ቃሴ ኢንቴ ኢስታ ማጫ ናይታፔ ዶሪዲ ኢንቴ ኣቱማ ናይታስ ኤካና፤ ሄ ዎዴ ሄ ማጫ ናይቲ ታናን ኣማኔቶንታ ኢጺዲ ባ ኤቃ ጾሳ ካሊዲ ኢንቴ ኣቱማ ናይቲ ኢስታ ካላና ማላ ኦꬃና። ");
INSERT INTO gmve_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«ኢንቴስ ጎይናና ኤቃ ጾሳታ ኣዛፔካ ሴሪሲዲ ሜꬎፍቴ። ");
INSERT INTO gmve_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«ኡኬꬃ ባኣሌ ቦንቺቴ፤ ታኒ ኢንቴና ኣዛዚዳ ማላ ላፑን ጋላሳስ ኢርሾይ ጌሎንታ ኡኬቲዳ ኡኬꬅ ሚቴ፤ ሄሳካ ኢንቴ ጊብጼፔ ኬዚዳ ኣቢቤ ኣጊናን ኦꬂቴ። ");
INSERT INTO gmve_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«ኡሎፔ ባይራ ዬሌቲዛ ኣቱማ ናይ ዉሪ ታሳ፤ ኢንቴ ሜሄ ኡባፌካ ቦራ ጊዲን፥ ዎይኮ ዶርሳ ጊዲን ባይራይ ታሳ፤ ");
INSERT INTO gmve_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ኮይሮ ዬሌቲዳ ሃሬ ማር፥ ዶርሳ ላቃራ ላማዳ ዎዛ፤ ዎዞንታ ኢጺኮ ኢዛ ቆꬌ ሚርቃ ዎꬋ። ኔ ናይታፔ ባይራ ዬሌቲዳ ኣቱማ ና ኡባ ዎዛ። «ኦኒካ ኢሚዛ ሚሽ ኦይኮንታ ሜላ ኩሼ ታ ሲንꬃን ቤቶፎ። ");
INSERT INTO gmve_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«ኡሱፑን ጋላስ ኦꬂቴ ሺን ላፑንꬃ ጋላስ ሼምፒቴ፤ ጎሻ ዎዴ ጊዲን ዎይኮ ማጻ ዎዴንካ ላፑንꬃ ጋላሳን ሼምፒቴ። ");
INSERT INTO gmve_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«ጊስቴ ጼራ ኢንቴ ማጺዛ ዎዴ ካꬃ ሺሾ ባኣሌ ቦንቺቴ፤ ሄ ላይꬃ ዉርሴꬃ ካꬅ ሺሺዛ ዎዴካ ዳሴ ባኣሌ ቦንቺቴ። ");
INSERT INTO gmve_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","ኢስራኤሌ ኣቱማ ኣሳይ ዉሪ ጎዳ ኡባ ሃሪዛ ኢስራኤሌ ጾሳ ሲንꬃን ላይꬃን ሄꬑቶ ቤቴቶ። ");
INSERT INTO gmve_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","ዱማ ዱማ ዴሬታ ታኒ ኢንቴ ሲንꬃፌ ዬዴꬃ ኬሳና፤ ሂስታዳ ኢንቴ ዛዋ ታኒ ኣሳና። ጎዳ ኢንቴ ጾሳ ሲንꬃን ኢንቴ ላይꬃን ሄꬓ ቤታናስ ፑዴ ኬዚዛ ዎዴ ኦኒካ ኢንቴ ቢታ ኣሞቴና። ");
INSERT INTO gmve_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«ኢንቴ ታስ ሱꬃ ያርሾ ያርሺዛ ዎዴ ኢርሾ ዬጊዲ ኡኪዳ ኡኬꬃራ ያርሾፍቴ። ፓዚጋ ቦንቺዛ ጋላሳስ ያርሺዳ ያርሾፌ ማላዶስ ኣይኮይካ ኣቶፎ። ");
INSERT INTO gmve_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","«ኢንቴ ጋዴን ባይራ ካጺዳ ካꬃፌ ኮይሮ ጼራ ጎዳ ኢንቴ ጾሳ ኬꬅ ኤሂቴ። «ዴይሻ ላቃ ኢዛ ኣዬይ ማꬃን ዶይሶፍቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","ጎዳይ ሙሴስ፥ «ታኒ ኔናራኔ ኢስራኤሌ ኣሳራ ጫቆ ጫቄቲዛይ ሃ ቃላቲ ጊዛ ማላ ጊዲዳ ጊሻስ ሃ ቃላታ ጻፋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ሙሴይ ካꬅ ሞንታኔ ሃꬄ ኡዮንታ ኦይዱ ታሙ ጋላሲኔ ኦይዱ ታሙ ቃማ ጎዳራ ሄን ጋምኢዲ ጫቆ ቃላ ጊዲዳ ታሙ ኣዛዞታ ማሴቲዳ ሹቻ ቦላ ጻፊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","ሙሴይ ናምኡ ማሴቲዳ ሹቻታ ባ ኩሼን ኦይኪዲ ሲና ዙማፔ ዱጌ ዎꬊዳ ዎዴ፥ ኢዚ ጎዳራ ሃሳይሼ ጋምኢዳ ጊሻስ ኢዛ ኣይፌሶይ ጾልቂዴስ፤ ጊዶ ኣቲን ኢዚ ሄሳ ኤሪቤና። ");
INSERT INTO gmve_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","ኣሮኔይኔ ኢስራኤሌ ኣሳይ ዉሪ ሙሴ ጼሊዲ ኢዛ ኣይፌሶይ ጾልቂዛይሳ ቤኢዲ ኢዛኮ ሺቃናስ ባቢዳ። ");
INSERT INTO gmve_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ጊዶ ኣቲን ሙሴይ ኢስታ ጼይጊን ኣሮኔይኔ ዴሬዛ ካሌꬂዛ ሃላቃቲ ዉሪ ኢዛኮ ዪን ኢዚ ኢስታ ሃሳይሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ሄሳፌ ጉዬ ኢስራኤሌ ኣሳይ ዉሪ ኢዛኮ ሺቂን ጎዳይ ኢዛስ ሲና ዙማ ቦላ ኢሚዳ ኣዛዞታ ኡባ ኢዚ ኢስታስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ሙሴይ ኢስታስ ዮቲ ዉርሲዲ ባ ኣይፌሶ ናጻላን ካሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","ጊዶ ኣቲን ሙሴይ ጎዳ ሲንꬅ ኢዛራ ሃሳያናስ ጋይቶቴꬃ ዱንካኔ ጊዶ ጌሊዛ ዎዴ ናጻላ ባ ኣይፌሶፔ ቃሬስ። ሄፔ ኬዚዲ ጎዳይ ኣዛዚዳይሳ ኢስራኤሌ ኣሳስ ዮቴስ። ");
INSERT INTO gmve_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ሙሴይ ዮቲዛ ዎዴ ኢስራኤሌ ኣሳይ ኢዛ ኣይፌሶይ ጾልቂዛይሳ ቤኢዴስ። ሄሳ ጊሻስ ሙሴይ ጎዳራ ሃሳያና ባና ጋካናስ ባ ኣይፌሶ ዛሬꬂዲካ ናጻላን ካሜስ። ");
INSERT INTO gmve_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ሙሴይ ኢስራኤሌ ኣሳ ኡባ ሺሺዲ፥ «ኢንቴ ኦꬃና ማላ ጎዳይ ኣዛዚዳይሲ ሃይሳፌ ካሊ ዲዛይሳ። ");
INSERT INTO gmve_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ሳሚንታ ጊዶን ኡሱፑን ጋላስ ጻላላ ኦሶ ኦꬂቴ፤ ጊዶ ኣቲን ላፑንꬃ ጋላሳይ ኢንቴስ ዱማ ጋላሳ፤ ጎዳስካ ሼምፖ ሳምባታ። ሄ ጋላስ ኣይ ኦሶካ ኦꬂዛ ኣሲ ኦኒካ ሃይቃናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ሳምባታ ጋላሳን ኢንቴ ሶን ሶን ታማ ኤꬆፍቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ሙሴይ ኢስራኤሌ ማባራስ ኩሜꬃስ፥ «ጎዳይ ኢንቴና ሂዝጊ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ኢንቴስ ዲዛይሳፌ ጎዳስ ኢሞታ ኤሂቴ፤ ጎዳስ ኢሞታ ኤሃናስ ኮይዛይ ኦኒካ ዎርቃ፥ ቢራ፥ ጻርቂማላ፥ ");
INSERT INTO gmve_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ሳሎ ሚሳቲዛ ቃጪና፥ ኦቻ ቴራ ሚሳቲዛ ቃጪና፥ ጼቃ ዞኦ ቃጪናኔ ሊቆ ላይኖ፥ ዴይሻ ኣንታሻ፥ ");
INSERT INTO gmve_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ዞኦ ቃላሜን ጌሊ ኬዚዳ ꬋርሾ ኢቴ፥ ቃጬቲዳ ጋልባ፥ ኦዶሮ ሚꬅ፥ ");
INSERT INTO gmve_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ጾምፔስ ዎጋራ ዛይቴ፥ ቲዬቲዛ ዛይቴኔ ኤጻኔ ሳዊዛ ቂማሜ፥ ");
INSERT INTO gmve_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ኤፉዴኔ ቲራ ኪሴን ዎꬂዛ ማርጊዴ ጌቴቲዛ ሹቻታኔ ሃራ ጾልቂዛ ኣልኦ ሹቻታ ኤሆ። ");
INSERT INTO gmve_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","«ኢንቴ ጊዶን ዲዛ ኩሼ ሂላንቻይ ኡባይ ዪዲ ጎዳይ ኣዛዚዳይሳ ኡባ ኦꬆ። ");
INSERT INTO gmve_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ጾሳ ዱንካኔዛ፥ ዱንካኔዛስ ሶ ባጋራኔ ካሬ ባጋራ ካሚዛ ዱንካኔ፥ ቃጴታ፥ ቶሌ ሚꬃታ፥ ጎርዴ ሚꬃታ፥ ቱሳታኔ ኢስቲ ኢስታን ኤቂዛ ቶሆታ፥ ");
INSERT INTO gmve_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ታቦታኔ ኢዛ ቶኪዛ ቶሆ ሚꬃታ፥ ኣቶ ጌቴቲዛ ካማኔ ታቦታ ካሚዛ ማጋላሻ፥ ");
INSERT INTO gmve_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ጻራጴዛዛ፥ ኢዛ ቶኪዛ ቶሆ ሚꬃታራኔ ኢዛስ ኮሺዛ ሚሻታ ኡባ፥ ጎዳ ሲንꬃን ዎꬂዛ ዱማ ኡኬꬃ፤ ");
INSERT INTO gmve_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ጾምፔ ኢዛ ቦላ ዎꬂዛ ሚሻ ኢዛስ ኮሺዛ ሚሻታራ፥ ጾምፔታ፥ ጾምፔ ዛይቴ፥ ");
INSERT INTO gmve_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ኤጻኔ ጩዋሲዛሶዛኔ ኢዛ ቶኪዛ ቶሆ ሚꬃታ፥ ቲዬቲዛ ዛይቴኔ ሳዊዛ ኤጻኔ፥ ጾሳ ዱንካኔዛ ፔንጌ ማጋላሻ፥ ");
INSERT INTO gmve_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ጹጌቲዛ ያርሾ ያርሺዛሶኔ ጻርቂማላፔ ኦሴቲዳ ዛይዛሬዛ፥ ኢዛ ቶኪዛ ቶሆ ሚꬃታኔ ኢዛስ ኮሺዛ ሚሻታ ኡባ፥ ጻርቂማላፔ ኦሴቲዳ ሜቻ ኬሬኔ ኢዛ ዎꬂዛሶ፥ ");
INSERT INTO gmve_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ዱንካናስ ካሬ ባጋ ዉይጌ ማጋላሻታ፥ ቱሳታኔ ኢስታ ቶሆታ፥ ዱንካናስ ካሬ ባጋ ዉይጌ ጌሊዛ ፔንጌዛ ማጋላሻ፥ ");
INSERT INTO gmve_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ጾሳ ዱንካኔዛ ቶሊዛ ꬊሽኬታ፥ ዱንካናስ ካሬ ባጋ ዉይጌ ꬊሽኬታኔ ኢስታ ዎዶሮታ፥ ");
INSERT INTO gmve_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ቄሴቲ ዱማሶዛን ኦꬂሼ ማይኣናስ ዳዴቲዳ ማይኦታ፥ ቄሴ ኣሮኔይኔ ኢዛ ናይቲ ቄሴቴꬃ ኦሶ ኦꬂሼ ማይኢዛ ማይኦታ ኦꬃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","ሄሳፌ ጉዬ ኢስራኤሌ ኣሳይ ዉሪ ሙሴ ሲንꬃፌ ኬዚ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ኢማናስ ኮዪዳይቲኔ ኢስታ ዎዚናይ ኢስታ ኢማ ኢማ ጊዳይቲ ዉሪ ዪዲ ጾሳ ዱንካኔዛስ፥ ኢዛ ጊዶን ኦሴቲዛ ኦሶሲኔ ጌሻ ማይኦ ኡባስ ኮሺዛ ሚሽ ኡባ ኤሂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ኢማና ኮይዛ ኣቱማይኔ ማጫይ ዉሪ ዪዲ ዎርቃፌ ኦሴቲዳ ኣሌቆታ፥ ሃይꬃ ዎርቃ፥ ሳጋዮ፥ ቆꬌን ኣꬂዛ ጻንጋላታኔ ዎርቃ ኣሌቆታ ኤሂዲ ጎዳስ ያኔ ሃ ቃሴꬂዛ ያርሾ ሂስቲ ሺሺዳ። ");
INSERT INTO gmve_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ሳሎ ሚሳቲዛ ቃጪናይ፥ ኦቻ ቴራ ሚሳቲዛ ቃጪናይ፥ ጼቃ ዞኦ ቃጪናይ፥ ዎይኮ ላይኖ ጌቴቲዛ ሊቆ ቃጪናይ፥ ዎይኮ ዴይሻ ኣንታሻያይ፥ ዞኦ ቃላሜን ጌሊ ኬዚዳ ꬋርሾ ኢቴይ፥ ዎይኮ ቃጬቲዳ ጋልባይ ዲዛ ኣሲ ዉሪ ኤሂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","ቢራ ዎይኮ ጻርቂማላ ኢማናስ ዳንዳይዛይ ዉሪ ባ ኢሞታ ጎዳስ ኢሚዴስ፤ ቃሴ ኦዶሮ ሚꬂ ዲዛ ኣሳይ ዉሪ ዱማ ዱማ ኦሶስ ኦዶሮ ሚꬅ ኤሂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ኩሼ ሂላ ኤሪዛ ማጫሳይ ዉሪ ባ ኩሼን ሱቂዳ ሳሎ ሚሳቲዛ ቃጪና፥ ኦቻ ቴራ ሚሳቲዛ ቃጪና፥ ጼቃ ዞኦ ቃጪናኔ ሊቆ ላይኖ ኤሂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","ቃሴካ ኢሞታ ኢማናስ ኮዪዳ ማጫሳይ ዉሪ ዴይሻ ኣንታሻ ዳዲ ኤሂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ሃላቃቲ ኤፉዴኔ ቲራ ኪሴን ዎꬂዛ ማርጊዴኔ ሃራ ቦንቼቲዳ ሹቻታ ኤሂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ቃሴካ ጾምፔስ፥ ሳዊዛ ኤጻኔሲኔ ቲዬታናስ ዎጋራ ዛይቴኔ ቂማሜ ኤሂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ኢስራኤሌ ኣሳይ ዉሪ ኣቱማይኔ ማጫይ፥ ኢስቲ ኦꬃና ማላ ጎዳይ ሙሴ ባጋራ ኣዛዚዳ ኦሶስ ጊዲዛ ኢሞታ ኡባ ባ ዶሳን ጎዳስ ኤሂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ሙሴይ ኢስራኤሌ ኣሳስ፥ «ቤኢቴ፤ ጎዳይ ዩሁዳ ቆሞፌ ሁሬስ ናዛ ና፥ ኡሬይ ና ባስሊኤሌ ዶሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ጎዳይ ኢዛ ጾሳ ኣያናን፥ ኣꬎ ኤራን፥ ኣኬካኒኔ ኦሶ ኡባ ኦꬂዛ ኤራቴꬃን ኩንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ሄሲካ ሂላን ኦሶ ቆፒ ኬሲዲ ዎርቃፌ፥ ቢራፔኔ ጻርቂማላፔ ዱማ ዱማ ሚሽ ኦꬃናሳ። ");
INSERT INTO gmve_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ሄሳꬆካ ኣልኦ ሹች ማሲ ጊጊሳናሳ፤ ቃሴካ ሚꬅ ማሳናሲኔ ዱማ ዱማ ኦሶ ሂላን ኦꬃናሳ። ");
INSERT INTO gmve_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ሄሳ ቦላካ ቃሴ ኢዛሲኔ ዳኔ ቆሞፌ ኣሂሳሜኬ ና ኤላቤስ፥ ሃራ ኣስ ታማርሲዛ ኤራቴꬅ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ኢስቲ ኡባ ቆሞ ኦሶ ኦꬃና ማላ፥ ሂላን ኦꬂዛይታ፥ ኦሶ ቆፋ ኬሲዛይታ፥ ሳሎ ሚሳቲዛ ቃጪናን፥ ኦቻ ቴራ ሚሳቲዛ ቃጪናን፥ ጼቃ ዞኦ ቃጪናኒኔ ላይኖ ቃጪናን ኣሌቂሲ ዳዲዛይታ ጊዳና ማላ፥ ጎዳይ ኢስታ ኤራቴꬃን ኩንꬂዴስ። ኢስቲ ዉሪካ ኡባ ቆሞ ኦሶ ኤሪዛ ኤራንቻ ጊዲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","«ሄሳ ጊሻስ ባስሊኤሌይ፥ ኤላቤይኔ ጾሳ ዱንካኔ ኦꬃና ማላ ጎዳይ ኤራቴꬅ ኢሚዳ ኣሳይ ዉሪ ጎዳይ ኣዛዚዳ ማላ ኢስቲ ኦꬃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","ሄሳፌ ጉዬ ሙሴይ ባስሊኤሌ፥ ኤላቤኔ ጎዳይ ዱማ ኤራቴꬅ ኢሚዳይታ ኦሶ ኦꬃናስ ያና ኮይዛይታ ኡባ ጼይጊዲ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ሺቂዳይቲ ኢስራኤሌ ኣሳይ ጾሳ ዱንካኔ ኦꬃናስ ኤሂዳ ኢሞታ ኡባ ሙሴፔ ኤኪዳ። ቃሴ ኣሳይ ባ ዶሳን ጮ ኢሚዛ ኢሞታ ማላዶ ማላዶ ጉጂ ጉጂዲ ኤሆ ኣጊቤና። ");
INSERT INTO gmve_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ሂስቲን ጾሳ ዱንካኔዛ ኦꬂዛ ኤራቴꬂ ኩሚዳ ኣሳይ ዉሪ ባ ኦꬂዛይሳ ኣጊ ሙሴኮ ቢዲ፥ ");
INSERT INTO gmve_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","«ኣሳይ ጎዳይ ኣዛዚዳ ኦሶስ ኮሺዛይሳፌ ቦላራ ዳሮ ኤሆን ዴስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","ሂስቲን ሙሴይ ባ ዱንካኔን ዱንካኔን ዲዛ ኣሳስ፥ «ናምኣንꬆ ኦናካ ጊዲን ጾሳ ዱንካኔ ኦሶስ ኢሚዛ ኢሞታ ኤሆፖ» ጊ ዮቲን ኣሳይ ኤሂዛይሳ ኣጋጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ጋሶይካ ኢስቲ ኤሂዳ ኢሞታይ ኦሶ ኡባ ኦꬃናስ ጊዲ ፓላሃና። ");
INSERT INTO gmve_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ኦሶዛ ኦꬂዛይታ ጊዶፌ ሂላ ዳርዛይቲ ዉሪ ሊቆ ላይኖፔኔ ሳሎ ሚሳቲዛ፥ ኦቻ ቴራ ሚሳቲዛኔ ጼቃ ዞኦ ቃጪናፔ ዳዴቲዳ ታሙ ማጋላሻታፔ ጾሳ ዱንካኔዛ ጊግሲዳ። ሄ ማጋላሻታ ቦላ ቦላራ ኢሲ ሂላንቻይ ኪሩቤታ ሚስሌ ሲኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ማጋላሻቲ ዉሪ ኢሲ ጊና ጊዲዲ ኣዱሳቴꬃይ ናምኡ ታማኔ ኦስፑን ዋꬋ፤ ኣሆቴꬃይ ኦይዱ ዋꬋ። ");
INSERT INTO gmve_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ኢቻሹ ማጋላሻታ ኢሲፌ ጋꬂ ሲኪዳ፤ ቃሴ ሃንኮ ኣቲዳ ኢቻሹ ማጋላሻታካ ኢዛꬆካ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ኢሲፌ ጋꬂ ሲኪዳ ማጋላሻታፔ ኢሲ ማጋላሻስ ዉርሴꬃ ጋጻን ሳሎ ሚሳቲዛ ጫርቃፌ ሲꬌ ሜꬊዳ። ቃሴ ኢሲፌ ጋጊ ሲኬቲዳ ሃንኮ ማጋላሻታንካ ሄሳꬆካ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ኢስቲ ኢሲፌ ጋጊዳ ኢሲ ማጋላሻ ቦላ ኢቻሹ ታሙ ሲꬌታ፥ ቃሴ ኢሲፌ ጋጊዳ ሃንኮ ማጋላሻታ ቦላካ ኢቻሹ ታሙ ሲꬌታ ሜꬊዳ። ሄ ሲꬌቲ ዉሪካ ኢሶይ ኢሳራ ጊናን ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ሄሳፌ ጉዬ ዎርቃፌ ኢቻሹ ታሙ ቃጴታ ሜꬊዲ ዱንካኔዚ ኢሲኖ ጊዳና ማላ፥ ሄ ማጋላሻታ ጋጻ ጋጻ ሄ ቃጴታን ጋꬂ ኦይሴꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ጾሳ ዱንካኔዛ ቦላራ ካሚዛ ዱንካኔዛስ ታማኔ ኢሲ ማጋላሻታ ዴይሻ ኣንታሻፔ ዳዲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ታማኔ ኢሲ ማጋላሻቲካ ኢሲ ጊና፤ ኢሲ ኢሲ ማጋላሻስ ኣዱሳቴꬂ ሄꬑ ታሙ ዋꬋ፥ ኣሆቴꬂ ኦይዱ ዋꬋ። ");
INSERT INTO gmve_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ኢቻሹ ማጋላሻታ ኢሲ ባጋራ፥ ኡሱፑን ማጋላሻታ ቃሴ ሃንኮ ባጋራ ጋꬂዲ ሲኪዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ሄሳፌ ጉዬ ጋꬂ ሲኪዳ ማጋላሻታፔ ኢሲ ማጋላሻ ጋጻን ኢቻሹ ታሙ ሲꬌታ ሜꬊዳ። ቃሴካ ጋꬂ ሲኪዳ ሃንኮ ማጋላሻታፔ ዉርሴꬃ ማጋላሻዛ ጋጻን ኢቻሹ ታሙ ሲꬌታ ሜꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ናምኡ ባጋራ ዲዛ ማጋላሻታ ጋꬂ ኢሲ ካማ ኦꬃናስ ጻርቂማላፔ ኢቻሹ ታሙ ቃጴታ ሜꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ሄሳፌ ጉዬ ዱንካኔዛ ካማናስ ዞኦ ቃላሜን ዬጊ ኬሲዳ ꬋርሾ ኢቴ ጊግሲዳ፤ ቃሴ ኢዛ ቦላራ ካማናስ ቃጬቲዳ ጋልባ ጊግሲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ጾሳ ዱንካኔ ቶሌ ሚꬃታ ሉሌ ጊዲዳ ኦዶሮ ሚꬃፌ ኬሲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ኢሲ ኢሲ ቶሌ ሚꬃስ ኣዱሳቴꬃይ ታሙ ዋꬋ፤ ኣሆቴꬃይ ኢሲ ዋꬋኔ ባጋ። ");
INSERT INTO gmve_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ኢሲ ኢሲ ቶሌ ኢሳ ኢሳራ ጋꬂ ኦይሴꬂዛ ናምኡ ቶሌ ሜꬊዳ። ጾሳ ዱንካኔዛ ቶሌ ሚꬃታ ዉርሲካ ሄሳꬆ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ጾሳ ዱንካኔዛስ ቶሆሶ ባጋራ ናምኡ ታሙ ቶሌ ሚꬃታ ሜꬊዲ፥ ");
INSERT INTO gmve_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ኢሲ ኢሲ ቶሌ ሚꬃስ ናምኡ ቶሆ፥ ሙሌራ ኦይዱ ታሙ ቶሆ ቢራፔ ጊግሲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ጾሳ ዱንካኔዛስ ሁኤሶ ባጋራ ናምኡ ታሙ ቶሌ ሚꬃታ ሜꬊዲ፥ ");
INSERT INTO gmve_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ኢሲ ኢሲ ቶሌ ሚꬃስ ናምኡ ቶሆ፥ ሙሌራ ኦይዱ ታሙ ቶሆ ቢራፔ ጊግሲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ጾሳ ዱንካኔዛስ ጉዬ ጋጻን ዱጌ ባጋራ ኡሱፑን ቶሌ ሚꬃታ ሜꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ጾሳ ዱንካኔዛ ጉዬ ጋጻን ዲዛ ዞዜታስ ናምኡ ቶሌ ሚꬃታ ጊግሲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ሃ ናምኡ ዞዜታን ዲዛ ቶሌቲ ጻጶፔ ጼራ ጋካናሼ ናምኡ ጊዲ ቢዲ ጼራን ኢሲ ሳጋዮን ጌሊ ኦይኬቲዳ። ኢስቲ ናምኣይካ ሄሳꬆ ኦሴቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ሄሳ ጊሻስ ኢሲ ኢሲ ቶሌ ሚꬃስ ጋርሳራ ናምኡ ናምኡ ቶሆቲ ዴቴስ፤ ሙሌራ ኦስፑን ጻጋጋቲኔ ቢራፔ ኦሴቲዳ ታማኔ ኡሱፑን ቶሆቲ ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","ቃሴ ኢስቲ ኦዶሮ ሚꬃፌ ታማኔ ኢቻሹ ካሬ ጎርዲዛ ሚꬅ ኬሲዳ፤ ኢስታፌ ጾሳ ዱንካኔዛስ ኢሲ ባጋ ሚሌን ዲዛ ቶሌ ሚꬃታስ ኢቻሹ ጎርዲዛ ሚꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ቃሴ ሃንኮ ባጋ ሚሌን ዲዛ ቶሌ ሚꬃታስ ኢቻሹ ጎርዲዛ ሚꬃታ ጊግሲዳ። ሄሳꬆካ ጾሳ ዱንካኔዛስ ጉዬ ባጋራ ኣርሼይ ዉሊዛ ባጋራ ዉርሴꬃ ጋጻን ዲዛ ቶሌ ሚꬃታስ ኢቻሹ ጎርዲዛ ሚꬃታ ሜꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ጊዶራ ጎርዲዛ ሚꬃቲ ጻጋጋታስ ጊዶ ጊናራ፥ ሃ ጋጻፔ ሄ ጋጻ ጋካናስ ካንꬂ ኬዛና ማላ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ቶሌ ሚꬃ ዎርቃን ቲይዲ ጎርዲዛ ሚꬃቲ ኣꬊዛ ሳጋዮታ ዎርቃፌ ሜꬊዳ፤ ቃሴ ጎርዲዛ ሚꬃታ ዎርቃን ቲይዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","ሳሎ ሚሳቲዛ ቃጪናፔ፥ ኦቻ ቴራ ሚሳቲዛ ቃጪናፔ፥ ጼቃ ዞኦ ቃጪናፔኔ ሊቆ ላይኖፔ ኢሲ ማጋላሻ ኦꬂዳ። ሄ ማጋላሻዛ ቦላ ኢሲ ሂላይ ኪሩቤታ ሚስሌ ሲኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ማጋላሻስ ኦይዱ ቱሳታ ኦዶሮ ሚꬃፌ ጊግሲዲ ዎርቃን ቲይዳ። ሂስቲዲ ዎርቃፌ ካቆታ ኢስታስ ጊግሲዳ። ቃሴ ቱሳታ ኤሲዛ ኦይዱ ቶሆታ ቢራፔ ሜꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","ጾሳ ዱንካኔ ጌሊዛ ፔንጌዛስ ሳሎ ሚሳቲዛ፥ ኦቻ ቴራ ሚሳቲዛኔ ጼቃ ዞኦ ቃጪናፔኔ ሊቆ ላይኖፔ ዳዴቲዳ፥ ጺልፔን ኣሌቄቲዳ ማጋላሻ ጊግሲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ቃሴ ኢስታስ ኢቻሹ ካቆታራ ዲዛ ኢቻሹ ቱሳታ ኦꬂዳ። ቱሳታ ጼራኔ ጪሮ ቃቺዛይታ ዎርቃን ቲይዳ። ቃሴ ቱሳቲ ኤቃና ማላ ኢቻሹ ቶሆ ጻርቂማላፔ ሜꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ባስሊኤሌይ ኦዶሮ ሚꬃፌ ታቦታ ጊግሲዴስ። ታቦታስ ኣዱሳቴꬃይ ናምኡ ዋꬋኔ ባጋ፤ ኣሆቴꬃይ ኢሲ ዋꬋኔ ባጋ፤ ꬎቃቴꬃይ ኢሲ ዋꬋኔ ባጋ። ");
INSERT INTO gmve_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ታቦታ ጊግሲዲ ሶ ባጋኔ ካሬ ባጋ ዋላካይ ባይንዳ ዎርቃን ሜሺዴስ፤ ኢዛ ዩዪ ኣꬋናስ ዳንጮ ዎርቃራ ዩሺ ኣꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ቃሴ ኦይዱ ዎርቃ ሳጋዮታ ሴሪሲዲ ታቦታስ ኦይዱ ቶሆታን፥ ኢሲ ባጋራ ናምኡ ሳጋዮታ፥ ቃሴ ሃንኮ ባጋራ ናምኡ ሳጋዮታ ኣꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ሂስቲዲ ኦዶሮ ሚꬃፌ ቶሆ ሚꬃታ ኬሲዲ ኢስታካ ዎርቃን ሜሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ታቦታ ቶካናስ ታቦታ ሚሌን ዲዛ ሳጋዮታን ቶሆ ሚꬃታ ኣꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ዋላካይ ባይንዳ ዎርቃፌ ናምኡ ዋꬋኔ ባጋ ኣዱቂዛ፥ ኢሲ ዋꬋኔ ባጋ ኣኪዛ ኣቶ ጌቴቲዛ ሶሆዛ ካማ ሜꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","ካማታስ ዉርሴꬃ ናምኡ ባጋ ጋጻን ናምኡ ኪሩቤታ ቆጼቲዳ ዎርቃፌ ሜꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ኢሲ ኪሩቤዛ ኢሲ ባጋ ጋጻን፥ ናምኣንꬆ ኪሩቤዛ ሃንኮ ባጋ ጋጻን፥ ናምኣታካ ካማዛራ ጋꬂ ኦይሴꬂ ሜꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ኪሩቤቲ ባ ቄፌ ዴንꬂዲ ኣቶ ጌቴቲዛ ሶሆዛ ካሚዛ ካማ ባ ቄፌን ካሚ ዎꬂዳ፤ ቃሴ ኢሶይ ኢሳራ ጼሌታና ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","ቃሴ ኣዱሳቴꬃይ ናምኡ ዋꬋ፥ ኣሆቴꬃይ ኢሲ ዋꬋ፥ ꬎቃቴꬃይ ኢሲ ዋꬋኔ ባጋ ጊዲዳ ጻራጴዛ ኦዶሮ ሚꬃፌ ሜꬊዲ፥ ");
INSERT INTO gmve_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ዋላካይ ባይንዳ ዎርቃን ሜሺዴስ። ኢዛ ዩዪ ኣꬋናስ ዎርቃ ኪፋፌ ዩሺ ኣꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ሄሳꬆካ ኣሆቴꬃይ ታꬋኮ ጊዲዛ ኪፋፌ ኢዛ ቦላ ዩሺ ኣꬂዴስ። ሂስቲዲ ኢዛ ዩዪ ኣꬋናስ ዎርቃ ዳንጮ ዩሺ ኣꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ሂስቲዲ ታቦታ ቶካናስ ጊጊዛ ኦይዱ ዎርቃ ሳጋዮታ ሜꬊዲ ኦይዱ ቶሆቲ ቶኬቲዳ ኦይዱ ዞዜታራ ኦይሴꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ጻራጴዛዛ ቶካናስ ቶሆ ሚꬃታ ኢስታ ጊዶራ ኣꬂዛ ሳጋዮቲ ጻራጴዛዛ ጻንጻ ቦላ ሜꬌቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","ጻራጴዛዛ ቶኪዛ ቶሆ ሚꬃ ኦዶሮ ሚꬃፌ ኬሲዲ ዎርቃን ሜሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","ሄሳꬆካ ጻራጴዛ ቦላ ዎꬂዛ ዱማ ዱማ ሚሻታ ዋላካይ ባይንዳ ዎርቃፌ ሜꬊዴስ፤ ሄይቲካ ሳኔታኔ ጪልፋታ፥ ቃሴ ኡሻ ያርሾ ኢስታን ሴሪሲዛ ኬሬታኔ ጹኣታ። ");
INSERT INTO gmve_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ሄሳፌ ጉዬ ባስሊኤሌይ ጾምፔ ዎꬂዛሶዛ ቆጼቲዳ ዋላካይ ባይንዳ ዎርቃፌ ሜꬊዴስ፤ ጾምፔዚ ኢዛን ኤቂዛ ቶሆ፥ ቃሴ ጊዶ ቶማካ ኡባ ቆጼቲዳ ዎርቃፌ ሜꬊዴስ። ኢዛ ኩሬታ፥ ኢዛ ꬌሞታኔ ኢዛ ጪሻታ ኡባ ኢዛራ ኢሲፌ ኦይሴꬂ ሜꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","ሚሌራ ኡሱፑን ባላታ ሜꬊዴስ፤ ሄꬑ ሃጋታ ኢሲ ባጋራ፥ ቃሴ ሄꬑ ሃጋታ ሃንኮ ባጋራ ኬሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ኡሱፑን ሃጋታስካ ሁኤን ሁኤን ኢሲ ኢሲ ꬌሞቲኔ ጪሻቲ ዲዛ፥ ኦቾሎኔ ጪሽ ሚሳቲዛ ዋንጫ ሜꬊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","ጾምፔ ዎꬂዛሶዛስ ጊዶ ቶማይ፥ ꬌሞቲኔ ጪሻቲ ዲዛ ኦቾሎኔ ጪሼ ሚሳቲዛ ኦይዱ ዋንጫን ኣሌቄቲ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ናምኣይ ናምኣይ ኢሲፌ ዋꬃን ዲዛ ሄꬑ ባላታኔ ጋርሳራ ኢሲ ኢሲ ꬌሞይ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ꬌሞቲኔ ሃጋቲ ዉሪ ጾምፔ ዎꬂዛሶዛራ ኢሲፌ ኦይኬቲ ኢሲኖ ጊዲዲ ዋላካይ ባይንዳ ዎርቃፌ ቆጼቲ ሜꬌቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","ኢዚ ቃሴ ጾምፔ ዎꬂዛሶዛስ ላፑን ጾምፔታ፥ ጾምፔ ቶይሲዛ ቃጴታኔ ቃጴታ ዎꬂዛሶ ዋላካይ ባይንዳ ዎርቃፌ ሜꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ጾምፔዛ ዎꬂዛሶዛኔ ኢዛን ጎኤቲዛ ሚሽ ኡባ ሜꬋናስ ሄꬑ ታማኔ ኢቻሽ ኪሎ ጊዲዛ ዋላካይ ባይንዳ ዎርቃ ዉርሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ሄሳꬆካ ቃሴ ኤጻኔ ጩዋሲዛሶዛ ኦዶሮ ሚꬃፌ ሜꬊዴስ። ኢዛስ ኦይዱ ጉላይ ዴስ፤ ኣዱሳቴꬃይ ኢሲ ዋꬋ፤ ኣሆቴꬃይ ኢሲ ዋꬋ፥ ꬎቃቴꬃይ ናምኡ ዋꬋ። ኢዛ ካጬቲካ ኢዛራ ኢሲኖ ጊዲዲ ኦይኬቲ ሜꬌቲዳይታ። ");
INSERT INTO gmve_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ኢዛስ ቦላ ባጋዛ፥ ኦይዱ ሚሌታኔ ኢዛ ካጬታ ዋላካይ ባይንዳ ዎርቃን ሜሺዲ ኢዛ ዩሺ ኣꬃናስ ጻንጻዛ ዎርቃፌ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ሄ ዎርቃ ጻንጻፌ ጋርሳራ ኤጻኔ ጩዋሲዛሶዛስ ዎርቃፌ ናምኡ ሳጋዮታ ሜꬊዴስ፤ ሂስቲዲ ሄ ባጋራኔ ሃ ባጋራ ናምኡ ናምኡ ኦይꬂዴስ። ሄይቲ ቶኪዛ ዎዴ ቶሆ ሚꬃታ ኣꬃናስ ማዳናሳ። ");
INSERT INTO gmve_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ቶሆ ሚꬃታ ኦዶሮ ሚꬃፌ ኬሲዲ ኢስታ ዎርቃን ሜሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ቃሴ ዱማቲዳ ቲዬቲዛ ዛይቴኔ ሳዎ ቱኑ ጊዛ ሎኦ ኤጻኔ ሺቶ ማላ ጊግሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","ኦዶሮ ሚꬃፌ ጹጌቲዛ ያርሾ ያርሺዛሶ ኦꬂዴስ። ሄ ያርሺዛሶዛ ꬎቃቴꬃይ ሄꬑ ዋꬋ፥ ኣሆቴꬃይኔ ኣዱሳቴꬃይ ኢሲ ጊና፥ ኢቻሹ ኢቻሹ ዋꬋ ጊዲዲ ኦይዱ ጉላይ ዲዛይሳ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ኦይዱ ጉላታ ዉርሴꬃ ጼራን ጼራን ኢሲ ኢሲ ካጬ ሜꬊዴስ። ሄ ካጬቲ ያርሺዛሶዛራ ኢሲፌ ኦይኬቲዲ ኦሴቲዳ። ሂስቲዲ ያርሺዛሶዛ ጻርቂማላራ ሜሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","ኢዛን ጎኤቲዛ ሚሻታ፥ ቢዲንꬅ ኬሲዛ ሳኔታ፥ ኣካፋታ፥ ኬሬታ፥ ኣሾ ኮንጬታኔ ቦንቆ ታማ ኦይኪዛ ኮንኣ ኡባ ጻርቂማላፔ ሜꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ሂስቲዲ ጻርቂማላፔ ዛይዛሬ ያርሺዛሶዛስ ጊግሲዲ ያርሺዛሶዛስ ዱጌ ጊዶ ጊናን ዲዛ ጻንጻዛስ ጋርሳ ባጋራ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ጻርቂማላፔ ሜꬊዳ ዛይዛሬዛስ ኦይዱ ጉላን ቶሆ ሚꬃታ ኣꬃናስ ኦይዱ ቃንጎታ ሜꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ኦዶሮ ሚꬃፌ ያርሺዛሶዛ ቶሆ ሚꬃታ ኬሲዲ ጻርቂማላን ሜሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ያርሺዛሶዛ ቶኪዛ ዎዴ ማዳና ማላ ቶሆ ሚꬃታ ናምኡ ሚሌራ ዲዛ ቃንጎታን ኣꬂዴስ። ያርሺዛሶዛ ጊዶ ዶይኣ ኣጊዲ ሳንቃፌ ሜꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ጻርቂማላፔ ሜቻ ኬሬኔ ኬሬዛ ዎꬂዛሶ ሜꬊዴስ፤ ሄ ጻርቂማላዚካ ጾሳ ዱንካኔዛ ፔንጌን ኦꬂዛ ማጫሳቲ ኤሂዳ ጻርቂማላ ማስቶቴፔ ኤኬቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ሄሳፌ ጉዬ ዱቡሻሶዛ ጊግሲዴስ። ዱንካኔዛስ ካሬ ባጋ ዉይጌስ ቶሆሶ ባጋ ኣዱሳቴꬃ ጼቱ ዋꬋ ኦꬂዲ፥ ሊቆ ላይኖፔ ዳዴቲዳ ማጋላሻ ጊግሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ኢዛስ ጻርቂማላፔ ናምኡ ታሙ ቱሳታኔ ቱሳቲ ኢዛን ኤቂዛ ጻርቂማላ ቶሆ ኦꬂዴስ፤ ኢስታ ሁኤን ቃሴ ቢራፔ ሜꬌቲዳ ኢስታ ቦላ ካቂዛይታኔ ቱሳታ ሁኤን ቃቺዛይታ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ዱንካኔዛስ ካሬ ባጋ ዉይጌዛስ ሁኤሶ ባጋ ኣዱሳቴꬃይ ጼቱ ዋꬋ፤ ቃሴ ናምኡ ታሙ ቱሳቲኔ ሄ ቱሳታስ ናምኡ ታሙ ጻርቂማላ ቶሆቲ ዴቴስ። ቃሴካ ቢራፔ ኦሴቲዳ ኢስታ ቦላ ካቂዛይቲኔ ቱሳታ ሁኤን ቃቺዛይቲ ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ኣርሼይ ዉሊዛሶ ባጋራ ዲዛ ዱቡሻ ኣሆቴꬂ ኢቻሹ ታሙ ዋꬋ ጊዲዲ ታሙ ቱሳቲኔ ቱሳታስ ታሙ ቶሆቲ ዲዛ ማጋላሻታ ጊግሲዴስ፤ ሄ ቱሳታ ሁኤን ቢራፔ ሜꬌቲዳ ኢስታ ቦላ ካቆታኔ ቱሳታስ ሁኤን ቃቺዛይታ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ቃሴ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ዱቡሻሶ ኣሆቴꬂ ኢቻሽ ታሙ ዋꬋ። ");
INSERT INTO gmve_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ዱንካኔዛስ ካሬ ባጋ ዉይጌዛ ጌሊዛሶፔ ኢሲ ባጋራ ታማኔ ኢቻሽ ዋꬋ ኣዱቂዛ ማጋላሻቲ፥ ኢስታስ ሄꬑ ቱሳቲኔ ቱሳታስ ሄꬑ ቶሆቲ ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ሄሳꬆካ ዱንካኔዛስ ካሬ ባጋ ዉይጌዛ ጌሊዛሶፔ ሃንኮ ባጋራ ታማኔ ኢቻሹ ዋꬋ ኣዱቂዛ ማጋላሻቲ፥ ኢስታስ ሄꬑ ቱሳቲኔ ቱሳታስ ሄꬑ ቶሆቲ ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ዱንካኔዛስ ካሬ ባጋ ዉይጌዛ ዩሾን ዲዛ ማጋላሻቲ ዉሪ ሊቆ ላይኖፔ ዳዴቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ሄ ቱሳታስ ቶሆይ ጻርቂማላፔ፥ ካቆቲኔ ቱሳታስ ሁኤን ቃቺዛይቲ ቢራፔ ኦሴቲዳ፤ ኢስታ ሁኤይ ቢራን ሜሼቲዴስ። ሄሳ ጊሻስ ዱቡሻሶዛ ዩሾን ዲዛ ቱሳታ ኡባ ሁኤን ቢራፔ ኦሴቲዳ ቃቺዛ ሚሻቲ ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ዱንካኔዛስ ካሬ ባጋ ዉይጌዛ ጌሊዛሶን ካቂዛ ማጋላሻይ ሳሎ ሚሳቲዛ፥ ኦቻ ቴራ ሚሳቲዛኔ ጼቃ ዞኦ ቃጪናፔኔ ሊቆ ላይኖፔ ዳዴቲዲ ጺልፔን ኣሌቂሲ ጊግሲዳዛ። ኢዛስ ኣዱሳቴꬃይ ናምኡ ታሙ ዋꬋ፤ ꬎቃቴꬃይ ዱንካኔዛስ ካሬ ባጋ ዉይጌዛ ማጋላሻታ ማላ ኢቻሹ ዋꬋ። ");
INSERT INTO gmve_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ኢዛስካ ጻርቂማላፔ ኦሴቲዳ ኦይዱ ቱሳቲኔ ቱሳታስ ኦይዱ ቶሆቲ ዴቴስ። ኢስታ ካቆቲኔ ቱሳታስ ሁኤን ቃቺዛ ሚሻቲ ቢራፔ ኦሴቲዳ፤ ኢስታ ጼራቲካ ቢራን ሜሼቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","ጾሳ ዱንካኔዛ ꬊሽኬቲኔ ኢዛ ዩሾን ዲዛ ዱንካኔዛስ ካሬ ባጋ ዉይጌዛ ꬊሽኬቲ ዉሪ ጻርቂማላፔ ኦሴቲዳይታ። ");
INSERT INTO gmve_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","ጾሳ ዱንካኔዛስ ጎኤቲዳ ሚሻታ ሌዌ ቆሞቲ ማዝጋባን ጻፊዳ። ሄ ሚሻታ ቄሴ ኣሮኔ ና ኢታማሬ ዳናቴꬃ ጋርሳን ዲዛ ሌዌቲ ማዝጋባን ጻፋና ማላ ሙሴይ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","ቢኒያሜ ዜሬꬅ ጊዲዳ ኡሬስ ናዛ ና፥ ኡሬ ና፥ ባስሊኤሌይ ጎዳይ ሙሴ ኣዛዚዳይሳ ኡባ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ዳኔ ዜሬꬅ ጊዲዳ ኣሂሳሜኬ ና ኤላቤይ ኢዛራ ዴስ፤ ኢዚ ኩሼ ሂላንቻኔ ኦሶስ ኮይሮ ቆፋ ኬሲዛዴኮ፤ ቃሴ ሳሎ ሚሳቲዛ፥ ኦቻ ቴራ ሚሳቲዛኔ ጼቃ ዞኦ ቃጪናኒኔ ሊቆ ላይኖን ዳዲዲ ጺልፔን ኣሌቂሲዛ ኣሳ። ");
INSERT INTO gmve_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","ጾሳ ዱንካኔዛ ኦሶስ ጎዳስ ያኔ ሃ ቃሴꬂ ሺሺዛ ያርሾስ ኢሜቲዳ ዎርቃይ ጾሳ ዱንካኔን ኤሬቲዳ ሜዛኔን ዎꬂን 1,000 ኪሎ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","ታይቦን ዲዛ ማባራ ኣሳፔ ቤቲዳ ቢራይ ጾሳ ዱንካኔን ኤሬቲዳ ሜዛኔን ዎꬂን 3,430 ኪሎ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ኣሳ ታይቢዛ ዎዴ ታይቤቲዳ ኣቱማሳይ ዉሪ ኢሳዴይ ሁኤን ሁኤን ኢሚዳይሲ ጾሳ ዱንካኔን ኤሬቲዳ ሜዛኔን ዎꬂን ኡሱፑን ጊራሜ ማላ ጊዲዴስ። ታይቤቲዳ ኣሳይ ናምኡ ታሙ ላይꬅ ኩሚዳይኔ ናምኡ ታማፌ ቦላራ ዲዛይ ሙሌራ 603,550። ");
INSERT INTO gmve_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ጾሳ ዱንካኔዛ ማጋላሻታ ኤሲዳ ጼቱ ቶሆቲ 3,400 ኪሎ ጊዲዛ ቢራን ኦሴቲዳ። ሄሲካ ኢሲ ኢሲ ቶሆስ 34 ኪሎ ቲጌቲዛ ቢራ። ");
INSERT INTO gmve_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ኣቲዳ ሄꬑ ታሙ ኪሎ ቢራ ቱሳታ ቦላ ካቆሶ ሜꬋናስ፥ ቱሳታስ ሁኤ ቦላ ሜሻናሲኔ ኢስታ ሁኤን ቃቺዛ ሚሻታ ሜꬋናስ ጎኤቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ሄሳꬆካ ኣሳይ ጎዳስ ያኔ ሃ ቃሴꬂ ሺሻናስ ኤሂዳ ጻርቂማላ ያርሾይ 2,425 ኪሎ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ሄ ጻርቂማላፔ ጾሳ ዱንካኔዛ ጌሊዛሶን ኤቂዛ ቱሳታስ ቶሆይ፥ ጻርቂማላፔ ኦሴቲዳ ያርሺዛሶ ጌቴቲዛ ያርሺዛሶዚ፥ ኢዛ ጊዶን ዎꬂዳ ጻርቂማላ ዛይዛሬይኔ ኢዛ ጊዶን ጎኤቲዛ ዱማ ዱማ ሚሻይ ዉሪ ሜꬌቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ሄሳꬆካ ቃሴ ዱንካኔዛስ ካሬ ባጋ ዉይጌ ዩሾን ዲዛ ዲርሳ ጊዶ ጌሊዛሶ ፔንጌን ኤቂዳ ቶሆይ፥ ቃሴ ጾሳ ዱንካኔዛኔ ኢዛ ዩሾን ዲዛ ዱንካኔዛስ ካሬ ባጋ ዉይጌ ዲርሳይ ቶሌቲዳ ꬊሽኬቲ ዉሪ ሄ ጻርቂማላፔ ሜꬌቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","ቄሴቲ ጾሳ ዱንካኔን ኦꬂዛ ዎዴ ማይኣና ማይኦ፥ ሳሎ ሚሳቲዛ፥ ኦቻ ቴራ ሚሳቲዛኔ ጼቃ ዞኦ ቃጪናፔ ዳዲዳ። ኣሮኔ ቄሴቴꬃ ማይኦካ ጎዳይ ሙሴ ኣዛዚዳ ማላ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ቃሴ ኢስቲ ኤፉዴ ዎርቃፌ፥ ሳሎ ሚሳቲዛ፥ ኦቻ ቴራ ሚሳቲዛኔ ጼቃ ዞኦ ቃጪናፔኔ ሊቆ ላይኖፔ ዳዲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","ኢስቲ ዎርቃ ቆጺ ሌኢሲዲ፥ ኢዛፔ ቃራሪ ቃራሪዲ ቃጪና ኬሲዳ። ሂስቲዲ ሳሎ ሚሳቲዛ፥ ኦቻ ቴራ ሚሳቲዛኔ ጼቃ ዞኦ ቃጪናኔ ሊቆ ላይኖ ጋꬂዲ ኩሼ ሂላንቻቲ ዳዲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ናምኡ ባጋይ ጋጊዲ ኢሲኖ ጊዳና ማላ ናምኡ ሃሼ ቦላ ጋꬂዲ ኦይꬂዛ ጫርቃ ጊግሲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ጎዳይ ሙሴ ኣዛዚዳ ማላ ሂላይ ኣሌቂሲዲ ዳዲዳ ዳንጮይካ ኤፉዴራ ኢሲፌ ጊዲዲ፥ ዎርቃፌ ሳሎ ሚሳቲዛ፥ ኦቻ ቴራ ሚሳቲዛኔ ጼቃ ዞኦ ቃጪናፔኔ ሊቆ ላይኖፔ ዳዴቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ኢስቲ ማርጊዴ ጌቴቲዛ ናምኡ ሹቻታ ጊግሲዲ ዎርቃፌ ሜꬊዳ ሹቹ ኦይኪዛይሳ ቦላ ማራራ ዎꬂዳ። ማታፋ ቦላ ሱንꬅ ዎጪ ጻፊዛ ማላ ሄ ሹቻታ ቦላ ኢስራኤሌ ናይታ ሱንꬅ ዎጪዲ ጻፊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ጎዳይ ሙሴ ኣዛዚዳ ማላ ታማኔ ናምኡ ኢስራኤሌ ቆሞታ ሃሳኢሲዛዝ ጊዳና ማላ፥ ሃ ታማኔ ናምኡ ሹቻታ ኤፉዴዛራ ኦይꬂዲ ሃሼ ካቆዛ ቦላ ዎꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ኢስቲ ቲራን ዎꬂዛ ኪሴ ኩሼ ሂላን ኦꬂዳ። ሄ ቲራን ዎꬂዛ ኪሴዛ ኤፉዴ ዎርቃፌ ዳዲዳ ማላ፥ ሳሎ ሚሳቲዛ፥ ኦቻ ቴራ ሚሳቲዛኔ ጼቃ ዞኦ ቃጪናፔኔ ሊቆ ላይኖፔ ዳዲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","ኢዛስ ኦይዱ ጼራይ ዴስ፤ ꬎቃቴꬃይኔ ኣሆቴꬃይ ኢሲ ኢሲ ታꬋኮ። ");
INSERT INTO gmve_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","ሄሳፌ ጉዬ ኢዛ ቦላ ኦይዱ ማራን ኣልኦ ሹቻታ ዎꬂዳ፤ ኮይሮ ማራን ዎꬂዳ ሹቻይ ሳርዲዮኔ፥ ቶጳዚዮኔኔ ጾልቂዛ ኢንቁ፤ ");
INSERT INTO gmve_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ናምኣንꬆ ማራን ባሉሬ፥ ሲምፔሬ ኣልማዜ ጌቴቲዛ ኣልኦ ሹቻታ፤ ");
INSERT INTO gmve_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ሄꬓንꬆ ማራን ያኪንቴ፥ ኬልቄዶኔኔ ኣሜቴስጺኖሴ፤ ");
INSERT INTO gmve_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ኦይዳንꬆ ማራን ቢሪሌ፥ ማርጊዴኔ ያስጲዴ። ሄይታ ኡባ ዎርቃፌ ኦሴቲዳ ሹቹ ኦይኪዛይሳ ቦላ ዎꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ኢስራኤሌ ናይታ ሱንꬃ ቆዳ ማላ፥ ሹቻታ ቆዳይካ ታማኔ ናምኣ፤ ኢሳይ ኢሳይ ማታሜ ማላ ዎጬቲዲ ታማኔ ናምኡ ቆሞታ ሱንꬂ ሄ ሹቻታ ቦላ ጻፌቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","ቲራን ዲዛ ኪሴዛስ ዎዶሮ ማላ ዶቄቲዳ ሳንሳላታ ዋላካይ ባይንዳ ዎርቃፌ ሜꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ናምኡ ዎርቃፌ ሜꬊዳ ሹቹ ኦይኪዛይታኔ ናምኡ ዎርቃ ሚጊዶታ ሜꬊዲ ቲራን ዎꬂዛ ኪሴዛስ ቆሞ ጋጻ ጼራታ ጋꬂ ኦይꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ሄ ናምኡ ዎርቃ ሳንሳላታታ ቲራን ዎꬂዛ ኪሴዛስ ጼራን ዲዛ ሚጊዶታራ ጋꬂ ኦይሴꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ሄ ሳንሳላታታስ ሃንኮ ባጋ ጼራ ቃሴ ኤፉዴዛስ ሲንꬃ ባጋራ፥ ሃሼ ካቆ ቦላ ዲዛ ሹች ኦይኪዛይታራ ጋꬂ ቃቺዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","ቃሴካ ናምኡ ዎርቃ ሚዲጋታ ሜꬊዲ ኤፉዴፔ ካሊ ዲዛ ቲራ ኪሴዛስ ሶ ባጋራ ዲዛ ናምኡ ጼራታን ኣꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ሄሳꬆካ ዎርቃፌ ሃራ ናምኡ ሚጊዶታ ሜꬊዲ፥ ኤፉዴዛስ ሲንꬃ ባጋራ፥ ሃሼ ካቆዛፔ ጋርሳ ባጋራ ኤፉዴ ጼሳን ቃቺዛይሳፌ ቆሞራ፥ ሲኮይ ጋጊዛሶ ኣቻን ኢስታ ኦይꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ጎዳይ ሙሴ ኣዛዚዳ ማላ ቲራ ኪሴን ዲዛ ሚጊዶታ ኤፉዴዛን ዲዛ ሚጊዶታራ ጋꬂዲ፥ ሳሎ ሚሳቲዛ ሱቄꬃን ቃቺዳ ጊሻስ ቲራ ኪሴዚ ጼሳፌ ቦላራ ዲዛ ጊሻስ ቃሾይ ዶልኤና። ");
INSERT INTO gmve_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ኤፉዴዛፔ ቦላራ ማይኢዛ ቃሚሳ ኢስቲ ሙሌራ ሳሎ ሚሳቲዛ ጫርቃፌ ጊግሲዳ፤ ሄሲካ ሼማኔ ኦሶኮ። ");
INSERT INTO gmve_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ሄ ቃሚሳዛስ ቆꬌ ኣꬂዛሶ ሜꬊዳ፤ ቆꬌሶይ ዳኬቶንታ ማላ፥ ሶ ባጋ ቃላምኢዲ ዩሺ ኣꬂ ሲኪዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","ኢስታ ቃሚሳዛስ ዱጌ ባጋ ማጫራ ዩሾን ሳሎ ሚሳቲዛ፥ ኦቻ ቴራ ሚሳቲዛኔ ጼቃ ዞኦ ቃጪናፔኔ ሊቆ ላይኖፔ ኦሮማኔ ጌቴቲዛ ሚꬃ ኣይፌ ቴራ ሚስሌታ ሜꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ቃሴካ ዎርቃፌ ዳላታ ሜꬊዲ ቃሚሳታስ ዱጌ ባጋ ጼራ ዩሺ ኣꬂዲ ኦሮማኔ ሚስሌታ ጊዶን ኣꬂ ኣꬂ ዋላኪዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","ጎዳይ ሙሴስ ኣዛዚዳ ማላ ኢስቲ ጾሳ ዱንካኔ ኦሶ ኦꬂሼ ማይኣና ማላ ቃሚሳዛስ ዱጌ ባጋ ማጫራ ዩሺ ኣꬂዲ ዳላኔ ኦሮማኔ ቴራ ሚስሌ ዋላኪ ኣꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ጎዳይ ሙሴ ኣዛዚዳ ማላ ኢስቲ ኣሮኔሲኔ ኢዛ ናይታስ ሼማኔይ ዳዲዳ ሊቆ ላይኖፔ ቆሌታ ጊግሲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ቃሴ ሁኤን ጻጺዛ ሻሼታ፥ ቆቤታኔ ጋርሳራ ማይኢዛ ማይኦታ ሊቆ ላይኖፔ ዳዲዲ ጊግሲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ሄሳꬆካ ቃሴ ኢስቲ ሳሎ ሚሳቲዛ፥ ኦቻ ቴራ ሚሳቲዛኔ ጼቃ ዞኦ ቃጪናፔኔ ሊቆ ላይኖፔ ዳዲዲ ኩሼ ሂላን ኣሌቂሲዲ ዳንጮ ጊግሲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ኢስቲ ኣኪሊሌ ሚስሌ ዋላካይ ባይንዳ ዎርቃፌ ሜꬊዲ ማታሜ ቦላ ዎጪዛ ማላ ኢዛ ቦላ፥ «ጎዳስ ጌሽ ጊዲዲ ዱማቲዴስ» ጊዛይሳ ዎጪ ጻፊዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ሄሳፌ ጉዬ ሁኤ ጎሳ ቦላ ካቃና ማላ፥ ጎዳይ ሙሴ ኣዛዚዳ ማላ ሳሎ ሚሳቲዛ ባቄꬅ ኢዛን ኣꬂዲ ቃቺዳ። ");
INSERT INTO gmve_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ጾሳ ዱንካኔዛ ኦሶይ ዉሪ ሙሌራ ፖሌቲዴስ። ኢስራኤሌ ኣሳይ ኡባ ጎዳይ ሙሴ ኣዛዚዳ ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ሄሳፌ ጉዬ ኢስቲ ጾሳ ዱንካኔዛ ሙሌራ ኤኪዲ ሙሴኮ ኤሂዳ፤ ሄሲካ ዱንካኔዛኔ ኢዛ ሚሻዛ ኡባ፥ ቃጴታ፥ ቶሌ ሚꬃታ፥ ፔንጌ ጎርዲዛ ሚꬃታ፥ ቱሳታኔ ኢስቲ ኤቂዛ ቶሆታ፥ ");
INSERT INTO gmve_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ቦላራ ካማናስ ꬋርሾዛ ኢቴ ዞኦ ቃላሜን ዬጊ ኬሲዳይሳ፥ ቃጬቲዳ ጋልባ፥ ጌንꬂዛ ማጋላሻ፥ ");
INSERT INTO gmve_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ጫቆ ቃላ ታቦታ፥ ኢዛ ቶኪዛ ቶሆ ሚꬃታ፥ ኣቶ ጌቴቲዛ ካማ፥ ");
INSERT INTO gmve_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ጻራጴዛኔ ኢዛ ሚሼ ኡባ ጎዳ ሲንꬃን ዎꬂዛ ጌሻ ኡኬꬃ፥ ");
INSERT INTO gmve_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ዋላካይ ባይንዳ ዎርቃፌ ኦሴቲዳ ጾምፔ ዎꬂዛሶዛኔ ኢዛን ማራን ዲዛ ጾምፔታ፥ ኢስታ ሚሻታ ኡባኔ ጾምፔ ዛይቴ፥ ");
INSERT INTO gmve_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ዎርቃፌ ኦሴቲዳ ኤጻኔ ጩዋሲዛሶዛ፥ ቲዬቲዛ ዛይቴ፥ ሳዊዛ ኤጻኔ፥ ጾሳ ዱንካኔ ፔንጌ ማጋላሻ፥ ");
INSERT INTO gmve_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ጻርቂማላፔ ኦꬂዳ ያርሺዛሶዛ፥ ጻርቂማላ ዛይዛሬዛ፥ ኢዛ ቶኪዛ ቶሆ ሚꬅ፥ ኢዛ ሚሻታ ኡባ፥ ሜቻ ኬሬኔ ኬሬዛ ኢዛ ቦላ ዎꬂዛ ሚሻታ፥ ");
INSERT INTO gmve_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ዱንካኔዛስ ካሬ ባጋ ዉይጌ ጎዳ ጌንꬂዛ ማጋላሻታ፥ ኢዛ ቱሳታ፥ ኢስቲ ኤቂዛ ቶሆታ፥ ዱንካኔዛስ ካሬ ባጋ ዉይጌ ጌሊዛ ፔንጌታ ማጋላሻታ፥ ዱንካኔዛስ ካሬ ባጋ ዉይጌ ዎዶሮታኔ ꬊሽኬታ፥ ጾሳ ዱንካኔዛስ ኮሺዛ ሚሻታ ኡባ፤ ");
INSERT INTO gmve_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ቄሴቲ ጌሻ ሶን ኦꬂዲ ማይኣናስ ዳዴቲዳ ማይኦታ፥ ኣሮኔይኔ ኢዛ ናይቲ ቄሴቴꬃን ኦꬂሼ ማይኢዛ ማይኦታ። ");
INSERT INTO gmve_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ኢስራኤሌ ኣሳይ ኦሶዛ ኡባ ጎዳይ ሙሴ ኣዛዚዳ ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","ሙሴይ ኦሶዛ ጾሞሲ ጼሊዲ ኢስታ ጎዳይ ኣዛዚዳ ማላ ኦꬂዳይሳ ቤዪዴስ። ሄሳ ጊሻስ ሙሴይ ኢስታ ኣንጂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ሄሳፌ ጉዬ ጎዳይ ሙሴ፥ ");
INSERT INTO gmve_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«ኮይሮ ኣጊናን ኮይሮ ጋላስ፥ ኔኒ ጾሳ ዱንካኔ ቶላ። ");
INSERT INTO gmve_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ጫቆ ቃላ ታቦታ ኢዛ ጊዶን ዎꬃዳ ታቦታዛ ማጋላሻን ጌንꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ጻራጴዛ ጌልꬃዳ ኢዛ ቦላ ዎꬋናስ ኮሺዛ ሚሻታ ኡባ ኢዛ ቦላ ዎꬃ። ሂስታዳ ጾምፔታ ኢዛ ቦላ ዎꬂዛ ሚሻዛ ሶ ጌልꬃዳ ኢዛ ቦላ ጾምፔታ ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ዎርቃፌ ኦሴቲዳ ኤጻኔ ጩዋሲዛሶዛ ጫቆ ቃላ ታቦታ ሲንꬃን ዎꬃዳ፥ ጾሳ ዱንካኔዛ ጊዶ ጌሊዛ ፔንጌ ማጋላሻዛ ካቃ። ");
INSERT INTO gmve_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","«ጹጌቲዛ ያርሾ ያርሺዛሶዛ ጾሳ ዱንካኔዚ ጌሊዛ ፔንጌ ሲንꬃን ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ኢዛን ሜጬቲዛ ኬሬዛ ጾሳ ዱንካኔዛፔኔ ያርሺዛሶዛፔ ጊዶን ዎꬃዳ ሃꬄ ኢዛን ቲጋ። ");
INSERT INTO gmve_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ጾሳ ዱንካኔዛፔ ካሬራ ዩሻ ኣꬃዳ ዱንካኔዛስ ካሬ ባጋ ዉይጌ ጊጊሳዳ ዱቡሻ ጌሊዛሶን ማጋላሻ ካቃ። ");
INSERT INTO gmve_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«ቲዬቲዛ ዛይቴዛ ኤካዳ ጾሳ ዱንካኔዛኔ ኢዛ ጊዶን ዲዛይሳ ኡባ ቲያ፤ ኢዛኔ ኢዛ ጊዶን ጎኤቲዛ ሚሻታ ኡባ ዱማሳ፤ ሂስቲኮ ኢዚ ጌሽ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ሄሳፌ ጉዬ ጹጌቲዛ ያርሾ ያርሺዛሶኔ ኢዛስ ጎኤቲዛ ሚሻ ኡባ ቲያ፤ ያርሺዛሶዛ ዱማሳ፤ ሂስቲኮ ኢዚ ኡባፌ ኣꬊዳ ጌሽ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","ሜቻ ኬሬዛኔ ኬሬዛ ኢዛ ቦላ ዎꬂዛ ሚሻታ ቲያዳ ኢስታ ዱማሳ። ");
INSERT INTO gmve_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«ኔኒ ኣሮኔኔ ኢዛ ናይታ ጾሳ ዱንካኔዚ ጌሊዛ ፔንጌ ኤሃዳ ሃꬃን ሜጫ። ");
INSERT INTO gmve_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ሄሳፌ ጉዬ ቄሴቴꬃ ማይኦዛ ኣሮኔ ማይዛዳ ኢዚ ታስ ቄሴቴꬃን ኦꬃና ማላ ኢዛ ቲያዳ ዱማሳ። ");
INSERT INTO gmve_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","ኢዛ ኣቱማ ናይታካ ኤሃዳ ቆሌ ማይዛ። ");
INSERT INTO gmve_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ኢስቲ ታስ ቄሴቴꬃን ኦꬃና ማላ፥ ኢስታ ኣዋ ቲይዳ ማላ፥ ኢስታካ ቲያ። ኢስታ ቲዬቴꬃንካ ኢስታኔ ኢስታ ዬሌታይ ዉሪ ቄሴ ጊዲዲ ኦꬃና ማላ ታ ኦꬃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","ሙሴይ ኡባካ ጎዳይ ባና ኣዛዚዳ ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ሄሳ ጊሻስ ጊብጼፔ ኢስቲ ኬዚዳ ናምኣንꬆ ላይꬃን፥ ኮይሮ ኣጊናን ኮይሮ ጋላሳን ጾሳ ዱንካኔይ ቶሌቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","ሙሴይ ጾሳ ዱንካኔዛ ኤሲዛ ዎዴ ዱንካኔዛ ቶሆ ኢስታ ሶሆን ሶሆን ዎꬂዴስ፤ ቶሌ ሚꬃታኔ ቱሳ ኣꬂዴስ፤ ጎርዲዛ ሚꬃታካ ጌልꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ሄሳፌ ጉዬ ሙሴይ ጎዳይ ኣዛዚዳ ማላ ዱንካኔዛ ቶሊዲ ኢዛ ቦላራ ካማ ካሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ሂስቲዲ ታሙ ኣዛዞቲ ጻፌቲዳ ማሴቲዳ ሹቻታ ኤፊዲ ታቦታዛ ጊዶን ዎꬂዴስ፤ ቶኪዛ ቶሆ ሚꬃታ ታቦታን ኣꬂዴስ፤ ማሮቴꬃ ካማካ ታቦታ ቦላ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ሄሳፌ ጉዬ ታቦታዛ ጾሳ ዱንካኔዛ ጊዶ ጌልꬂዴስ፤ ጌንꬂዛ ማጋላሻ ካቂዲ፥ ጎዳይ ኣዛዚዳ ማላ ጫቆ ቃላ ታቦታዛ ካሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ጎዳይ ሙሴ ኣዛዚዳ ማላ፥ ሙሴይ ጻራጴዛዛ ጾሳ ዱንካኔዛን ጌልꬂዲ፥ ማጋላሻፔ ካሬራ ሁኤሶራ ዎꬂዲ፥ ");
INSERT INTO gmve_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ኢዛ ቦላ ጎዳ ሲንꬃን ዎꬂዛ ጌሻ ኡኬꬅ ጊግሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ጎዳይ ሙሴ ኣዛዚዳ ማላ፥ ጾምፔ ዎꬂዛሶዛ ጾሳ ዱንካኔ ጊዶ ጌልꬂዲ፥ ጻራጴዛስ ሲንꬃ ባጋራ፥ ጾሳ ዱንካኔዛስ ቶሆሶራ ዎꬂዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ቃሴ ጾምፔታ ጎዳ ሲንꬃን ኦይꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ጎዳይ ኣዛዚዳ ማላ፥ ዎርቃፌ ኦሴቲዳ ኤጻኔ ጩዋሲዛሶዛ ጾሳ ዱንካኔዛ ጊዶ ጌልꬂዲ ማጋላሻዛስ ሲንꬃ ባጋራ ዎꬂዲ፥ ");
INSERT INTO gmve_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ኢዛ ቦላ ሳዊዛ ኤጻኔ ጩዋሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","ሄሳፌ ጉዬ ጾሳ ዱንካኔዛ ፔንጌን ማጋላሻ ካቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ጹጌቲዛ ያርሾ ያርሺዛሶዛ ጾሳ ዱንካኔ ጌሊዛሶ ፔንጌ ኣቻን ዎꬂዴስ፤ ኢዛ ቦላ ጹጌቲዛ ያርሾኔ ካꬃ ያርሾ ጎዳይ ኣዛዚዳ ማላ ያርሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ሜቻ ኬሬዛ ጾሳ ዱንካኔዛፔኔ ያርሺዛሶዛፔ ጊዶን ዎꬂዴስ። ሂስቲዲ ሜጬታናስ ሃꬄ ኢዛን ቲጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ሙሴይ፥ ኣሮኔይኔ ኢዛ ናይቲ ባ ኩሼኔ ባ ቶሆ ኢዛን ሜጬቲዳ። ");
INSERT INTO gmve_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ጎዳይ ሙሴ ኣዛዚዳ ማላ፥ ኢስቲ ጾሳ ዱንካኔን ጌሊዛ ዎዴ ዎይኮ ያርሺዛሶ ሺቂዛ ዎዴ ኣይዴካ ሜጬቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","ጾሳ ዱንካኔን ያርሺዛሶ ዩሺ ኣꬂዲ ዱቡሻ ጊግሲዴስ፤ ሄ ዱቡሻ ፔንጌን ማጋላሻ ካቂዴስ። ሄሳꬆ ሂስቲዲ ሙሴይ ኦሶዛ ፖሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ሄሳፌ ጉዬ ሻራይ ጾሳ ዱንካኔዛ ካሚዴስ፤ ጎዳ ቦንቾይካ ኢዛ ኩሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ሻራይ ጾሳ ዱንካኔዛ ቦላ ኡቲዳ ጊሻሲኔ ጎዳ ቦንቾይ ኢዛ ጊዶን ኩሚዳ ጊሻስ ሙሴይ ኢዛ ጊዶ ጌላናስ ዳንዳይቤና። ");
INSERT INTO gmve_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ኢስራኤሌ ኣሳይ ባ ኦጌ ኡባን፥ ሄ ሻራይ ጾሳ ዱንካኔዛፔ ዴንዲዛ ዎዴ ኣይዴካ ኢዛ ካሊዲ ቤቴስ። ");
INSERT INTO gmve_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ጊዶ ኣቲን ሄ ሻራይ ዴንዶንታ ኢጺኮ ኢዚ ዴንዳና ጋላሳይ ጋካናስ ኢስቲካ ቃጼቴና። ");
INSERT INTO gmve_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ኢስታ ኦጌ ኡባን ጎዳ ሻራይ ኢስራኤሌ ኣሳይ ዉሪ ቤኢሺን፥ ጋላስ ጋላስ ጾሳ ዱንካኔ ካሜሲኔ ቃማ ቃማ ቃሴ ታማይ ሄ ሻራ ጊዶን ኤጼስ። ");
INSERT INTO gmve_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","ጎዳይ ጋይቶቴꬃ ዱንካኔዛ ጊዶን ዲሼ ሙሴ ጼይጊዲ ሂዝጊ ኣዛዚዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«ኢስራኤሌ ኣሳይ ጎዳስ ያርሾ ሺሺዛ ዎዴ ኢስቲ ናጋና ዎጋይ ሃይሳፌ ካሊዛይሳ፤ ኢሲ ኢሲ ኣሲ ሚዛፔ ጊዲን ዶርሳፌ ዎይኮ ዴይሻፌ ጊዲን ኣይ ቆሞ ያርሾካ ሺሺዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","ሄሲካ ሚዛፔ ኢሳ ጹጌቲዛ ያርሾስ ሺሻናስ ኮይኮ ኢሲ ቦሬይካ ኢዛ ቦላ ባይንዳ ሚርጎ ቦራ ዶሪዲ ኤሆ፤ ሂስቲኮ ኢዚ ጎዳ ኡፋይሲዛ ያርሾ ጊዳና ማላ ጋይቶቴꬃ ዱንካኔዛ ፔንጌን ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ጹጌቲዛ ያርሾ ሺሺዛዴይ ባ ሺሺዛ ቦራ ሁኤ ቦላ ባ ኩሼ ዎꬆ፤ ሄ ያርሾዚካ ኢዛ ናጋራ ዉርሳናስ ጎዳይ ኤኪዛ ሎኦ ያርሾ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","ሄሳዴይ ሚርጎዛ ሄን ጎዳ ሲንꬃን ሹኮ፤ ሂስቲኮ ኣሮኔ ዜሬꬃታፔ ጊዲዳ ቄሴቲ ቦራዛ ሱꬃ ጎዳስ ሺሼቶ፤ ጋይቶቴꬃ ዱንካኔን ጌሊዛ ፔንጌ ባጋራ ዲዛ ያርሾ ያርሺዛሶዛ ቦላ ላንቄራ ዩዪ ኣꬋናስ ሱꬃ ዉጼቶ። ");
INSERT INTO gmve_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ሄሳፌ ጉዬ ሄ ያርሾዛ ሺሺዛይሲ ሄ ሹኬቲዳ ሜሄዛ ጋልባ ሾቂዲ ኬሶ፤ ኣሾዛ ቆሞን ቆሞን ቃንጼሬꬆ። ");
INSERT INTO gmve_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ቄሴ ኣሮኔ ዜሬꬅ ጊዲዳ ቄሴቲ ያርሾ ያርሺዛሶዛ ቦላ ሚꬅ ጎጲዲ ታማ ኤꬄቶ። ");
INSERT INTO gmve_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ቄሴዛ ኣሮኔ ዜሬꬅ ጊዲዳ ቄሴቲ ሄ ሜሄዛ ኣሾዛ ቆሞን ቆሞን ሻኪዲ ሁኤዛኔ ሃንዳዛ ጉጂዲ ያርሾ ሺሺዛሶን ኮሬቲዳ ሚꬃ ቦላ ዎꬄቶ። ");
INSERT INTO gmve_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ሄ ያርሾዛ ሺሺዛይሲ ሄ ሜሄዛ ቃንꬃ ኣሾዛኔ ጉዬ ጌዳታ ሃꬃን ሜጮ፤ ቄሴዚ ያርሾዛ ኡባ ያርሺዛሶዛ ቦላ ጹጎ፤ ሃይሳ ማላ ታማን ጹጌቲዛ ያርሾ ሳዎይ ጎዳ ኡፋይሴስ። ");
INSERT INTO gmve_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","«ኢዛዴይ ባ ዶርሳፌ ዎይኮ ባ ዴይሻፌ ኢሳ ጹጌቲዛ ያርሾስ ሺሻና ኮይኮ ኢሲ ቦሬይ ኢዛ ቦላ ባይንዳ ꬋርሾ ዎይኮ ኦርጌ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","ሄሳካ ያርሾ ሺሺዛሶዛፔ ፑዴሃ ባጋራ ጾሳ ሲንꬃን ሹኮ፤ ኣሮኔ ዜሬꬅ ጊዲዳ ቄሴቲ ሱꬃ ኤኪዲ ያርሾ ያርሺዛሶዛ ቦላ ዩዪ ኣꬋናስ ዉጼቶ። ");
INSERT INTO gmve_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ሄ ያርሻ ሺሺዛዴይ ሄ ሹኪዳ ኣሾዛ ቆሞን ቆሞን ቃንጺ ኬሲዳፔ ጉዬ ሄ ኦሶዛስ ዶሬቲዳ ቄሴይ ሄ ኬሲዳ ኣሾዛ ኡባ ሁኤዛኔ ሃንዳዛካ ኢሲፌ ያርሾ ያርሺዛሶን ጎጴቲዲ ታማን ኤጺዛ ሚꬃ ቦላ ዎꬆ፤ ");
INSERT INTO gmve_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ኣዴዚ ሄ ሜሄዛስ ቃንꬃ ኣሾዛኔ ናምኡ ጌዳታ ሃꬃን ሜጮ፤ ቄሴዚካ ሄሳ ኡባ ጎዳስ ያርሾ ኦꬂ ሺሺዲ ያርሾ ሺሺዛሶዛ ቦላ ኡባ ጹጎ፤ ሄሳ ማላ ታማን ጹጌቲዛ ያርሾ ሳዎይ ጾሳ ኡፋይሴስ። ");
INSERT INTO gmve_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","«ኢሳዴይ ጎዳስ ጹጌቲዛ ያርሾ ካፎፔ ሺሻና ኮይኮ ሃራጴ ጪዬ ዎይኮ ዋኖሴ ጌቴቲዛ ካፎፔ ጊዳናስ ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","ቄሴዚካ ሄ ካፎዛ ኤኪዲ ጌዴ ያርሾዛሶ ሺሺዲ ካፎዛ ቆꬌ ሚርቆ፤ ያርሾዛ ሺሺዳ ታማን ኢዛ ጹጎ፤ ሱꬂካ ያርሾይ ኢዛ ቦላ ሺቂዛይሳ ሚሌራ ዱጌ ጾኬቶ። ");
INSERT INTO gmve_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ባሌዛኔ ቃንꬃ ኣሾዛ ዱማ ሻኪዲ ያርሾ ኢዛ ቦላ ሺሺዛሶዛፔ ኣርሼይ ሞኪዛ ባጋራ ቢዲንꬂ ቆሌቲዛሶን ዬጌቶ። ");
INSERT INTO gmve_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","ቄፌታ ኦይኪዲ ናምኡ ኬሲ ጳልቂዲ ኣሾዛ ሙሌራ ሻኪ ዬጎንታ ዲሼ ያርሾ ሺሺዛሶዛ ቦላ ዲዛ ታማን ሙሌራ ጹጎ፤ ሄሳ ማላ ታማን ጹጌቲዛ ያርሾ ሳዎይ ጎዳ ኡፋይሴስ። ");
INSERT INTO gmve_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«ኣይ ኣሲካ ጾሳስ ካꬃ ያርሾ ሺሺዛ ዎዴ ሊቆ ꬊሌ ሺሻና ቤሴስ፤ ሄ ꬊሌዛ ቦላ ዎጋራ ዛይቴኔ ኤጻኔ ጉጆ፤ ");
INSERT INTO gmve_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ኣሮኔ ዜሬꬃፌ ጊዲዳ ቄሴታኮ ኤኪ ዮ፤ ሄ ዎዴ ኢዛ ኦሶ ታራይ ጋኪዳ ቄሴይ ሄ ꬊሌዛፔ ባ ኩጳ ኩሜꬃ ዛይቴዛኔ ኤጻኔዛ ኤኪዲ ዉሪካ ጾሳስ ሺቂዳይሳ ኤሪሳናስ ያርሾ ሺሺዛይሳ ቦላ ታማን ጹጎ፤ ሄሳ ማላ ካꬃ ያርሾ ሳዎይ ጾሳ ኡፋይሴስ። ");
INSERT INTO gmve_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ካꬃ ያርሾፌ ኣቲዳ ꬊሌይ ኣሮኔ ዜሬꬃፌ ጊዲዳ ቄሴታስ ኢሜቶ፤ ሄሲካ ጾሳስ ሺቂዳ ያርሾፌ ሻኬቲ ኤኬቲዳ ጊሻስ ሃራታፔ ኬሂ ዱማቴስ። ");
INSERT INTO gmve_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","«ያርሾዚ ኡኬꬂ ኡኬቲዛ ባሼን ኡኬቲዳ ጊዲኮካ ኢርሾይ ቦቾንታዝ ጊዶ፤ ኢዚካ ዎጋራ ሚꬃ ዛይቴራ ዋላኬቲዲ ሊቆ ꬊሌራ ኡኬቲዳ ቄሪ ኡኬꬅ ዎይኮ ዛይቴን ጊንዴቲ ኡኬቲዳ ኡኬꬅ ጊዳናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","«ያርሾዚ ታማ ጮጬን ኮምፔቲዳዝ ጊዲኮ ኢርሾይ ቦቾንታ ዎጋራ ሚꬃ ዛይቴይ ጉጄቲዲ ሊቆ ꬊሌፌ ጊጌቲዳዝ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","ኔ ኡኬꬃዛ ባሴሬꬃዳ ኢዛ ቦላ ዎጋራ ሚꬃ ዛይቴ ጉሳዳ ካꬃ ያርሾ ሺሻ። ");
INSERT INTO gmve_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","«ያርሾዚ ቄሪ ባሼን ኡኬቲዳ ኡኬꬃ ማላ ጊዲኮ ዎጋራ ሚꬃ ዛይቴይ ኢዛን ጉጄቲ ሙኑቄቲዳ ሊቆ ꬊሌፌ ጊጊዳዝ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ካꬃ ያርሾ ጾሳስ ኢሜቲዛ ያርሾ ሂስታ ቄሴዛስ ኢማ፤ ቄሴዚካ ያርሾ ያርሺዛሶን ያርሾ። ");
INSERT INTO gmve_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","ቄሴዚ ሄሳ ሄ ያርሾዛፔ ባጋ ኤኪዲ ኡባ ጎዳይ ኢዚ ሺሺዳይሳ ዩሺ ቆፓና ማላ ያርሾ ያርሺዛሶን ዲዛ ታማን ጹጎ፤ ሃይሳ ማላ ታማን ጹጌቲዛ ያርሾ ሳዎይ ጎዳ ኡፋይሴስ። ");
INSERT INTO gmve_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ያርሺሺን ኣቲዳይሲ ቃሴ ቄሴታስ ኢሜቶ፤ ሄሲካ ጎዳስ ሺቂዳ ያርሾፌ ሻኬቲ ኤኬቲዳ ጊሻስ ሃራታፔ ኬሂ ዱማቴስ። ");
INSERT INTO gmve_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","«ጎዳስ ጹጌቲ ያርሼቲዛ ካꬃ ያርሾራ ሺቂዛ ኢርሾ ጊዲን ዎይኮ ኤስ ጊዲኮካ ኔ ታማን ጹጋናስ ቤሶንታ ጊሻስ ኔ ጎዳስ ሺሺዛ ካꬃ ያርሾን ኡባን ኣይኮ ኢርሾይካ ኢዛን ጌሎፖ። ");
INSERT INTO gmve_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","ላይꬃን ላይꬃን ካꬅ ሺሺዛ ዎዴ ኮይሮ ማጼቲዳ ካꬃፌ ጼራ ያርሾ ኦꬂዲ ጎዳስ ኤኪ ዪቴ፤ ሄ ያርሾዚ ያርሾ ያርሺዛሶዛን ታማን ጹጌቶፎ። ");
INSERT INTO gmve_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","ኣይ ቆሞ ካꬃ ያርሾንካ ማጺኔይ ꬋዮፖ፤ ሄሲ ኔኒ ኔ ጾሳራ ጫቄቲዳ ጫቆ ቃላስ ማላታ፤ ሄሳ ጊሻስ ኔ ሺሺዛ ካꬃ ያርሾ ኡባ ማጺኔራ ማልኢንꬃ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","ካꬅ ሺሺዛ ኮይሮ ኣጊናን ካꬃ ጼራ ኔ ሺሺዛ ዎዴ ጫጬቲዲ ሺጌቼቲዳ ቲያ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","ሃይሲ ካꬃ ያርሾ ጊዲዳ ጊሻስ ኢዛ ቦላ ዎጋራ ሚꬃ ዛይቴኔ ኤጻኔ ጉጃ። ");
INSERT INTO gmve_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ቄሴዚካ ሄ ያርሾዛፔ ባጋ ኤኪዲ ኢዚ ጎዳስ ሺቂዳዝ ጊዲዳይሳ ኣኬኪሳና ማላ ዛይቴዛካ፥ ኤጻኔዛካ ኡባ ካꬃራ ኢሲፌ ጹጎ። ");
INSERT INTO gmve_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«ኣይ ኣሲካ ሳሮቴꬃ ጊሻስ ባ ሜሄፔ ጎዳስ ኢሲፌቴꬃ ያርሾ ሺሺዛ ዎዴ ኢዛ ቦላ ዎሶይ ባይንዳ ሚርጎ ዎይኮ ማጫ ሚዝ ዶሪዲ ኤሆ። ");
INSERT INTO gmve_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ያርሾ ኤሂዛዴይ ያርሾስ ኢዚ ሺሺዛ ሜሄዛ ቦላ ባ ኩሼ ዎꬂዲ ጋይቶቴꬃ ዱንካኔ ፔንጌ ማታን ሹኮ፤ ኣሮኔ ዜሬꬅ ጊዲዳ ቄሴቲ ሱꬃ ኢዛፔ ኤኪዲ ያርሾይ ያርሼቲዛሶዛ ሚሌዛ ቦላ ዩዪ ኣꬋናስ ዉጼቶ። ");
INSERT INTO gmve_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","ኢሲፌቴꬃ ያርሾስ ሺቂዛ ያርሾዛፔ ጎዳስ ታማን ጹጌቲዛ ያርሾ ጊዲ ሺቃናይቲ ቃንꬃ ኣሾታ ጎዚ ኦይኪዳ ሃንዳ ኩሜꬅ፥ ");
INSERT INTO gmve_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ኪላሆታኔ ኢስታ ቦላ ዲዛ ሃንዳ ሄሳꬆካ ቲሬ ጎዚ ኦይኪዳ ሃንዳታፔ ዶሬቲዳይታ። ");
INSERT INTO gmve_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","ቄሴቲ ሄሳ ኡባ ሃራ ጹጌቲዛ ያርሾራ ጋꬂ ያርሾ ያርሺዛሶን ጹጌቶ፤ ሄሳ ማላ ታማን ጹጌቲዛ ያርሾ ሳዎይ ጎዳ ኡፋይሴስ። ");
INSERT INTO gmve_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","«ኢሲፌቴꬃስ ሺቂዛ ያርሾይ ዶርሳፌ ዎይኮ ዴይሻፌ ጊዲኮ ኣዴ ዎይኮ ማጫ ጊዲዲ ኢስታ ቦላ ዎሶይ ባይንዳይታ ጊዴቶ። ");
INSERT INTO gmve_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","ኢሲ ኣሲ ጎዳስ ሺሺዛ ያርሾይ ዶርሳ ላቃ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ባ ኩሼዛ ላቃ ሁኤ ቦላ ዎꬂዲ ዱንካኔዛ ፔንጌ ቦላ ሹኮ፤ ቄሴቲ ሱꬃ ኢዛፔ ኤኪዲ ያርሾ ያርሺዛሶዛ ቦላ ሚሌዛ ዩዪ ኣꬋናስ ዉጼቶ። ");
INSERT INTO gmve_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","ኢሲፌቴꬃ ያርሾስ ሺቂዛ ያርሾዛፔ ጎዳስ ታማን ጹጌቲዛ ያርሾ ጊዲ ሺቃናይቲ ሃንዳዛኔ ዞኮ ሜቄꬃ ጋርሳፌ ቃንጼቲዳ ጎይና ኡባ፥ ቃንꬃ ኣሾ ጎዚ ኦይኪዳ ሃንዳ ኡባ፥ ");
INSERT INTO gmve_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ኪላሆታኔ ኢስታ ጎዚ ኦይኪዳ ሃንዳ ኡባ ቃሴ ቲሬ ካሚ ኦይኪዳ ሎኦ ሃንዳ ኡባ፥ ");
INSERT INTO gmve_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ቄሴዚካ ሄሳ ኡባ ጎዳስ ካꬃ ያርሾ ሂስቲ ሺሺዲ ያርሾ ያርሺዛሶዛ ቦላ ጹጎ። ");
INSERT INTO gmve_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","«ኢሲ ኣሲ ጎዳስ ያርሾ ዴይሼ ሺሺዛ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ባ ኩሼ ዴይሻዛ ሁኤ ቦላ ዎꬂዲ ዱንካኔዛ ሲንꬃን ሹኮ፤ ቄሴቲ ሱꬃ ኢዛፔ ኤኪዲ ያርሾይ ያርሼቲዛሶዛ ቦላ ሚሌዛ ዩዪ ኣꬋናስ ዉጼቶ። ");
INSERT INTO gmve_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","ሄ ሹኬቲዳ ኣሾዛፔ ሃይሳፌ ካሊዛ ኣሾ ቆሞታ ካꬃ ያርሾ ኦꬂዲ ጎዳስ ሺሼቶ፤ ሄይቲካ ቃንꬃ ኣሾ ካሚዛ ሃንዳ ኡባ፥ ");
INSERT INTO gmve_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ኪላሆታኔ ኢስታ ጎዚ ኦይኪዳ ሃንዳ፥ ቃሴካ ቲሬ ካሚ ኦይኪዳ ሎኦ ሃንዳዛፔ ኤኬቶ። ");
INSERT INTO gmve_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ቄሴዚካ ሄሳ ታማን ጹጌቲ ሳዊዛ ያርሾ ኦꬂዲ ያርሾ ያርሺዛሶን ጹጎ፤ ሃንዳይ ዉሪ ጎዳስ ሻኬቲዲ ዱማቶ። ");
INSERT INTO gmve_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","ኢስራኤሌ ናይታፔ ሃንዳ ሚዛዴይ ዎይኮ ሜሄ ሱꬅ ኡዪዛዴይ ዶፖ፤ ሄሲ ዉሪ ኢስራኤሌ ናይቲ ዲዛሶኒኔ ኢስቲ ዲዛ ዎዴ ኡባን ሜርናስ ኤቂ ዲዛ ዎጋ ጊዶ።» ");
INSERT INTO gmve_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","ጾሲ ሙሴ ሂዝጊ ኣዛዚዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«ኔኒ ኢስራኤሌ ናይታስ ዮታናይሲ ሃይሳ፤ ኦኒካ ኤሮንታ ባሌቴꬃን ናጋራ ኦꬂኮ ዎይኮ ኤሮንታ ጎዳ ኣዛዞታፔ ኢሳ ሞሪኮ ሃይሳፌ ካሊዛ ዎጋ ናጎ! ");
INSERT INTO gmve_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","«ሄ ዎዴ ቲዬቲዳ ቄሴይ ናጋራ ኦꬂዲ ዴሬዚ ናጋራ ኦꬂዳ ሚሳቲሲ ቤቲኮ ኢዛ ቦላ ኢሲ ዎሶይካ ባይንዳ ኢሲ ሚርጎ ቦራ ኤሂዲ ባ ናጋራ ጊሻስ ጎዳስ ያርሾ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ኮርማዛ ዱንካኔዛ ፔንጌ ኤሂዲ ባ ኩሼ ኢዛ ሁኤ ቦላ ዎꬂዲ ጎዳ ሲንꬃን ሹኮ። ");
INSERT INTO gmve_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ሄሳፌ ጉዬ ቄሴታ ሃላቃይ ሄ ቦራዛ ሱꬃፌ ጉꬃራ ኤኪዲ ጌዴ ዱንካኔዛ ጊዶ ጌሎ፤ ");
INSERT INTO gmve_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ጎዳ ኬꬃ ማጋላሻስ ሲንꬃ ባጋራ ኤቂዲ ባ ቢራꬌ ሱꬃን ጌልꬂ ጌልꬂ ኬሲዲ ላፑንቶ ጋካናስ ዉጾ። ");
INSERT INTO gmve_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ኢዛፔ ጉꬃ ሱꬅ ኤኪዲ ዱንካኔዛ ጊዶን ኤጻኔ ያርሺዛሶዛን ኦይዱ ባጋራ ዲዛ ꬌሞታ ቦላ ዎꬆ፤ ሃንኮ ኣቲዳ ሱꬃ ዱንካኔዛን ጌሊዛ ፔንጌ ባጋራ ጹጌቲዛ ያርሾይ ያርሼቲዛሶ ጋርሳን ጉሶ። ");
INSERT INTO gmve_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","ሄ ሚርጎዛ ሃንዳዛ ኡባ፥ ቃንꬃ ኣሾ ካሚ ኦይኪዳ ሃንዳዛካ፥ ");
INSERT INTO gmve_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ኪላሆታካ ኢስታ ጎዚ ኦይኪዳ ሃንዳዛኔ ሄሳꬆካ ቲሬ ካሚ ኦይኪዳ ሞꬌዛፔ ዶሬቲዳይሳ ኤኮ። ");
INSERT INTO gmve_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ቄሴታ ሃላቃይ ሄሳ ኡባ ኤኪዲ ጹጌቲዛ ያርሾይ ሺቂዛ ያርሾሶዛ ቦላ ጹጎ፤ ኦሶዚካ ኢሲፌቴꬃስ ያርሾይ ሺቂዛ ሜሄዛ ሃንዳፌ ኤኪዲ ጹጌቲዛ ያርሾስ ሺቂዛ ማላ ሃኖ። ");
INSERT INTO gmve_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","ጊዶ ኣቲን ጋልባዛ፥ ኣሾዛ፥ ሁኤዛኔ ቶሆታ፥ ማራጬዛራኔ ቃንꬃ ኣሾ፥ ");
INSERT INTO gmve_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ሄራፔ ጌዴ ካሬ ኬሶ፤ ጌዴ ቢዲንꬅ ኬሲ ቆሊዛሶ፥ ቱኖንታሶ ኤፊዲ ሚꬂ ሺሺዲ ታማን ጹጎ። ");
INSERT INTO gmve_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«ኢስራኤሌ ኣሳይ ኤሮንታ ባላ ኦꬂኮ ዎይኮ ኤሮንታ ጎዳ ኣዛዞፔ ኢሲኖ ሞሪዳ ጊዲኮ ሄ ናጋራይካ ኣሳፔ ጌሚኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ሄ ኦሴቲዳ ናጋራይ ኤሬቲዳ ማላ ሄራካ ዴሬዚ ሄ ናጋራ ጊሻስ ያርሾስ ኢሲ ሚርጎ ኤሆ፤ ኢዛካ ኣሳይ ጋይቶቴꬃ ዱንካኔ ሲንꬄ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","ዴራ ሃላቃቲ ባንታ ኩሼ ሚርጎዛ ሁኤ ቦላ ዎꬂን ሄን ቦራዚ ጎዳ ሲንꬃን ሹኬቶ። ");
INSERT INTO gmve_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","ቲዬቲዳ ቄሴይ ሄ ሚርጎዛ ሱꬃፌ ጉꬃራ ኤኪዲ ጌዴ ዱንካኔዛን ጌሎ፤ ");
INSERT INTO gmve_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ጎዳ ኬꬃ ማጋላሻስ ሲንꬃ ባጋራ ጊዲዲ ባ ኩሼ ቢራꬌታ ላፑንቶ ሱꬃን ጌልꬂ ጌልꬂ ኬሲዲ ጾሳ ሲንꬃን ዉጾ። ");
INSERT INTO gmve_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ቃሴካ ጉꬃ ሱꬅ ኤኪዲ ዱንካኔ ጊዶን ዲዛ ኤጻኔ ኢዛ ቦላ ያርሺዛሶዛስ ኦይዱ ባጋራ ዲዛ ꬌሞታ ቦላ ዎꬆ፤ ኣቲዳ ሱꬃ ቃሴ ጌዴ ዱንካኔን ጌሊዛሶን ጹጌቲዛ ያርሾይ ያርሼቲዛሶዛ ጋርሳን ጉሶ። ");
INSERT INTO gmve_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ሄሳፌ ቃሴ ሄ ሚርጎ ሞꬌዛ ኡባ ኤኪዲ ያርሾ ያርሺዛሶዛ ቦላ ጹጎ። ");
INSERT INTO gmve_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ኦሶዚ ዉሪካ ናጋራ ጊሻስ ሺቂዛ ሚርጎ ያርሺዛይሳꬆ ኦꬄቶ፤ ቲዬቲዳ ቄሴዚ ዴራፔ ናጋራ ዲጋና፤ ዴራሲካ ኣቶ ጌቴታና። ");
INSERT INTO gmve_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ሄሳፌ ጉዬ ሚርጎዛ ኣሳይ ዲዛሶፔ ጌዴ ካሬ ኬሲዲ ባ ናጋራ ጊሻስ ሺሺዳ ሚርጎዛ ካሴ ጹጎይሳꬆ ጹጎ፤ ሄሲካ ዴሬዛ ናጋራፔ ጌሺዛ ያርሾ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«ናጋራ ኦꬂዳዴይኔ ኤሮንታ ዲሼ ባሌቴꬃን ጎዳ ባ ጾሳ ኣዛዞታፔ ኢሲኒዮ ሞሪዳዴይ ኢዚ ዴሬ ካሌꬂዛዴ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ባ ኦꬂዳ ናጋራ ኢዚ ኤሪዳ ማላ ሄራካ ኢሲ ቦሬይ ኢዛ ቦላ ባይንዳ ዴይሻ ኦርጌ ባ ናጋራፔ ማሬታናስ ያርሾ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ባ ኩሼ ዴይሻ ሁኤ ቦላ ዎꬂዲ ያርሾ ያርሺዛሶዛፔ ፑዴሃ ባጋራ ጹጌቲዛ ያርሾስ ሺቂዛ ሜሄቲ ሹኬቲዛሶን ጎዳ ሲንꬃን ሹኮ። ሄሲካ ናጋራ ዲጊዛ ያርሾ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ቄሴዚ ሄ ሹኬቲዳ ሜሄዛ ሱꬃን ባ ቢራꬌታ ጌልꬂ ጌልꬂ ኬሲዲ ኦይዱ ባጋራ ዲዛ ꬌሞታ ቲዮ፤ ኢዛፔ ኣቲዳ ሱꬃ ያርሾይ ያርሼቲዛሶዛ ጋርሳን ጉሶ። ");
INSERT INTO gmve_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ሃንዳዛ ኡባ ያርሾ ያርሺዛሶዛ ቦላ ጹጎ፤ ሄ ኦሶይ ካሴ ኢሲፌቴꬃ ያርሾስ ሺሺዳ ሜሄታ ሃንዳ ጹጎይሳꬆ ኦꬄቶ፤ ሄሳꬆ ቄሴዚ ዴሬዛ ካሌꬂዛዴ ናጋራ ዉርሳናስ ያርሾ ሺሾ፤ ኢዛስካ ኣቶ ጌቴታና። ");
INSERT INTO gmve_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«ናጋራ ኦꬂዳዴይኔ ኤሮንታ ዲሼ ባሌቴꬃን ጎዳ ኣዛዞታፔ ኢሲኒዮ ሞሪዳዴይ ሃንኮ ዴራ ጊዶፌ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ባ ኦꬂዳ ናጋራ ኢዚ ኤሪዳ ማላ ሄራካ ኢዚ ቦላ ኢሲ ቦሬይካ ባይንዳ ማጫ ዴይሽ ባ ናጋራ ጊሻስ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","ባ ኩሼ ሄ ዴይሻይ ሁኤ ቦላ ዎꬆ፤ ያርሾ ያርሺዛሶፔ ፑዴሃ ባጋራ ጹጌቲዛ ያርሾስ ሺቂዛ ሜሄቲ ሹኬቲዛሶን ሹኮ። ");
INSERT INTO gmve_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","ቄሴዚካ ሄ ሹኬቲዳ ዴይሻይ ሱꬃን ባ ቢራꬌታ ጌልꬂ ጌልꬂ ኬሲዲ ኦይዱ ባጋራ ዲዛ ꬌሞታ ቲዮ፤ ኢዛፔ ኣቲዳ ሱꬃ ያርሾይ ያርሼቲዛሶዛ ጋርሳን ጉሶ። ");
INSERT INTO gmve_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","ኢሲፌቴꬃስ ሺቂዛ ያርሾስ ሺቂዛ ሜሄታ ሞꬌ ቦላራ ሾቂ ኬሲዛይሳꬆ ሃይሳ ሃ ሜሄዛ ሞꬌካ ኡባ ቦላራ ሾቂ ዲጎ፤ ሳዎዚ ጎዳ ኡፋይሲዛ ያርሾ ኦꬂዲ ያርሺዛሶዛ ቦላ ጹጎ፤ ሄሳꬆ ቄሴዚ ሄ ኣዴዛ ናጋራ ኢዛፔ ዲጋናስ ያርሾ ሺሾ፤ ኢዛዴስካ ኣቶ ጌቴታና። ");
INSERT INTO gmve_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","«ሄ ኣዴዚ ባ ናጋራፔ ማሬታናስ ያርሾስ ዶርስ ሺሻና ኮይኮ ኢዚ ቦላ ኣይኮ ቦሬይ ባይንዳ ማጫ ዶርስ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","ኢዛዴይካ ዶርሳይ ሁኤ ቦላ ባ ኩሼ ዎꬆ፤ ያርሾ ያርሺዛሶፔ ፑዴሃ ባጋን ጹጌቲዛ ያርሾስ ሺቂዛ ሜሄቲ ሹኬቲዛሶን ሹኮ። ");
INSERT INTO gmve_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ቄሴዚ ቃሴ ዶርሳይ ሱꬃን ባ ቢራꬌ ጌልꬂ ጌልꬂ ኬሲዲ ያርሾ ያርሺዛሶዛስ ኦይዱ ባጋራ ዲዛ ꬌሞታ ሱꬃራ ቲዮ፤ ኢዛፔ ኣቲዳ ሱꬃ ያርሾ ያርሺዛሶ ጋርሳን ጉሶ። ");
INSERT INTO gmve_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","ሄሳፌ ካሊዲ ኢሲፌቴꬃ ያርሾስ ሺቂዛ ሜሄታ ሞꬌ ሾቂ ኤኪዛይሳ ማላ ሃ ዶርሳይ ሞꬌካ ኡባ ሾቂ ዲጎ፤ ሄሳካ ጎዳስ ሺቂዛ ካꬃ ያርሾስ ሺሺዛሶዛ ቦላ ጹጎ፤ ሄሳꬆ ቄሴዚ ሄ ኣዴዛ ናጋራ ኢዛፔ ዲጋናስ ያርሾ ሺሾ፤ ኢዛዴስካ ኣቶ ጌቴታና። ");
INSERT INTO gmve_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","«ኢሳዴይ ባ ቤኢዳ ሚሼ ማርካታና ማላ ፒርዳ ፒርዲዛሶ ጼይጌቲዲ ባ ቤኢዳይሳ ዎይኮ ባ ኤሪዛይሳ ማርካቶንታ ኢጺኮ ሄሲ ኢዛስ ናጋራ ጊዳና፤ ሄሳ ጊሻስ ኢዛዴይ ኦይሼታና። ");
INSERT INTO gmve_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","«ኣይ ኣሲካ ኤሮንታ ዲሼ ዎጋን ዲጌቲዳ ዶኣታ ባዉታ፥ ሜሄታ ባዉታ ዎይኮ ቲራን ቢታራ ጎሼቲዛ ሜꬌቴꬃታ ባዉታ ቦቺዳዴይ ቱኔስ፤ ሄሲካ ኢዛዴስ ናጋራ ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","«ኣይ ኣሲካ ኤሮንታ ዲሺን ኣሳፔ ጎጊ ኬዚዲ ቱኒሲዛ ሚሽ ቦቺኮ ኢዛዴይ ሄሳ ኤሪዳ ጋላሳፌ ዶሚዲ ኢዛስ ናጋራ ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","«ኣይ ኣሲካ ኢታስ ጊዲን ኪያስ ጊዲን ዩሺ ቆፖንታ ጮ ሜላ ኣዲና ኣዲኔቲኮ ኢዛዴይ ኦꬂዳ ሞሮዛ ዛሪ ኣኬኪዳ ዎዴፔ ዶሚዲ ኢዛዴስ ናጋራ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","«ኣይ ኣሲካ ሃይታ ሃ ሚሻታፔ ኢሳን ቆሂ ቤቲኮ ባ ናጋራ ቆንጪሲ ፓጻናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","ኢዛዴይ ባ ናጋራ ጊሻስ ማጫ ዶርስ ዎይኮ ማጫ ዴይሽ ያርሻናስ ኤሆ፤ ቄሴይካ ኢዛፔ ኤኪዲ ኢዛዴ ናጋራ ዉርሳናስ ጎዳ ሲንꬃን ያርሾ። ");
INSERT INTO gmve_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","«ኣይ ኣሲካ ባ ኦꬂዳ ናጋራ ጊሻስ ዶርስ ዎይኮ ዴይሼ ሺሻናስ ዳንዳዮንታዝ ጊዲኮ ናምኡ ሃራጴታ ዎይኮ ሃራጴ ጪዬታ ኤሂዲ ኢሲኒዮ ናጋራ ያርሾስ ናምኣንꬃዮካ ጹጌቲዛ ያርሾስ ጾሳ ሲንꬅ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ኤሂዲ ቄሴዛስ ኢሞ፤ ቄሴዚካ ቆሆ ያርሾስ ሺቂዛ ካፎይ ቆꬌ ቃንጾንታ ሚርቂዲ ቆሆ ያርሾስ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ሱꬃፌ ጉꬃራ ኤኪዲ ያርሾ ያርሾዛሶዛ ቦላ ዩዪ ኣꬋናስ ዉጾ፤ ኣቲዳ ሱꬃ ያርሾ ያርሺዛሶ ጋርሳን ዉጾ፤ ሄሲካ ናጋራ ዉርሶ ያርሾ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ሃንኮ ኣቲዳ ካፎዮ ዲዛ ዎጋ ማላ ጹጌቲዛ ያርሾ ሂስቲ ሺሾ፤ ሄሳꬆ ኦꬂዲ ቄሴዚ ኢዛዴ ናጋራ ዉርሳናስ ያርሾ፤ ኢታ ኦꬂዳዴስ ኢዛ ናጋራይ ኣቶ ጌቴታና። ");
INSERT INTO gmve_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","ኢዛዴይ ናምኡ ሃራጴታ ሺሻናስ ዳንዳዮንታይሳ ጊዲኮ ባ ናጋራ ጊሻስ ኢሲ ኪሎ ሊቆ ꬊሌ ኤሆ፤ ሄሲካ ናጋራ ያርሾስ ጊዲዛ ጊሻስ ዎጋራ ዛይቴይ ዎይኮ ኤጻኔይ ኢዛን ጉጄቶፎ። ");
INSERT INTO gmve_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","ኢዛካ ኤሂዲ ቄሴዛስ ኢሞ፤ ቄሴዚካ ሄ ꬊሌዛፔ ባ ኩሼን ኩጳቲ ኤኪዲ ጎዳስ ሺቂዛ ካꬃ ያርሾራ ኢሲፌ ጋꬂ ሃሳኢሳናስ ያርሾ ያርሺዛሶዛ ቦላ ጹጎ፤ ሄሲካ ናጋራ ጊሻስ ሺቂዛ ያርሾ። ");
INSERT INTO gmve_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ኣይ ኣሲካ ሃይታንታ ማላ ናጋራታፔ ኢሳ ኦꬂኮ ቄሴዚ ሄሳ ማላ ኦꬂዲ ኢዛዴይ ኦꬂዳ ናጋራ ዉርሳናስ ያርሾ ሺሾ፤ ሄሳዴስካ ኣቶ ጌቴታና፤ ሃንኮ ኣቲዳ ꬊሌይ ካꬃ ያርሾይ ቄሴዛስ ኣቲዛ ማላ ኢዛስ ጊዶ።» ");
INSERT INTO gmve_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«ኣይ ኣሲካ ጎዳስ ኢማናስ ቤሲዛይሳ ኤሮንታ ኣጊዲ ኢሞንታ ኣጊኮ ኢዛስ ናጋራ ጊዲዳ ጊሻስ ኢሲ ዎሶይ ኢዛ ቦላ ባይንዳ ꬋርሾ ቆሆስ ጊዲዛ ያርሾ ጎዳስ ሺሾ፤ ኢዛ ዋጋ ሄሬጋይካ ካሴ ጾሳ ኬꬃን ኤሬቲዳ ሄሬጋ ማላ ጊዶ፤ ሄሲካ ቆሆ ጊሻስ ሺቂዛ ያርሾ። ");
INSERT INTO gmve_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ጎዳስ ኢማናስ ቤሲሺን ኢዛዴይ ኢሞንታ ኣጊዳይሳ ጪጎ፤ ሄሳፌካ ቦላራ ሃይሳ ሃ ሄሬጋስ ኢቻሻፔ ኢሲ ኩሼ ጉጂዲ ቄሴዚካ ኢዚ ኤሂዳ ꬋርሻራ ጋጊዲ ናጋራ ያርሾ ኦꬂዲ ኤሂዳዴ ናጋራ ዉርሳና፤ ሄ ሞሮ ኦꬂዳይሲ ኣቶ ጌቴታና። ");
INSERT INTO gmve_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","«ኣይ ኣሲካ ኤሮንታ ዲሼ ጎዳይ ኦꬆፍቴ ጊዳ ኣዛዞታፔ ኢሲኒዮ ሞሪኮ ኢዛዴስ ናጋራ፤ ሄ ናጋራ ጊሻስ ኢዛዴይ ኦይሼታና። ");
INSERT INTO gmve_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","ኢዛዴይካ ባ ሞሪዳ ሞሮዛ ጊሻስ ባ ሜሄታ ጊዶፌ ኢዛ ቦላ ኢሲ ዎሶይ ባይንዳ ꬋርሾ ቄሴዛኮ ኤሆ፤ ኢዚ ኤሂዳይሳ ዎጋይ ካሴ ቆሆ ያርሾስ ጪጊዛ ዋጋ ኬሲዛዝ ጊዶ፤ ቄሴዚካ ሄሳꬆ ኣሲ ኤሮንታ ኦꬂዳ ሞሮዛ ጌሾ፤ ኢዛዴይካ ማሬታና። ");
INSERT INTO gmve_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ሄሲካ ቆሆ ጊሻስ ሺቂዛ ያርሾ፤ ኢዛዴይካ ጎዳ ሲንꬃን ሞሮ ኦꬂዳ ጊሻስ ናጋራንቻ።» ");
INSERT INTO gmve_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«ኦኒካ ኣሲ ኢዛስ ሃዳራ ዎይኮ ታልኤ ኢሚዳ ሚሽ ካዲዲ ባ ላጌ ባሌꬆን ናጋራ ኦꬂዲ ሄሳን ጎዳ ሚሺሲኮ ዎይኮ ኣሳ ሚሼ ቦንቂ ኤኪኮ ዎይኮ ባሌꬂኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ዎይኮ ኣሳፔ ዎꬊ ꬋይዳ ሚሼ ዴሚ ኤኪዲ ታ ቤያቤኬ ጊ ዎርዶራ ጫቂኮ ኣሲ ኦꬂዛ ሃ ሞሮታ ኡባፌ ኢሲኔይን ቆሂኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ኣይ ኣሲካ ሃይሳ ማላ ናጋራ ኦꬂኮ ኢዚ ካይሶን ኤኪዳይሳ ኢዛስ ሃዳራ ኢሜቲዳይሳ ዎይኮ ꬋዪን ዴሚ ኤኪዳይሳ ዛሮ። ");
INSERT INTO gmve_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ዎርዶራ ጫቂ ኤኪዳይሳ ኡባ ቆሆ ያርሾ ሺሺዛ ዎዴ ካሴ ባ ኤኮይሳ ቦላ ኢቻሻፔ ኢሲ ኩሼ ጉጂዲ ዛሮ። ");
INSERT INTO gmve_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ባ ቆሂዳይሳስ ኤዳ ጊዳና ማላ ኢዛ ቦላ ኢሲ ዎሶይ ባይንዳ ꬋርሾ ጎዳስ ያርሻና ማላ ቄሴኮ ኤሆ፤ ኢዛ ዎጋይካ ካሴ ቆሆ ያርሾስ ጪጌቲዛ ዋጋ ኬሲዛዝ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ቄሴዚካ ሄ ኣዴዛ ናጋራ ዲጋና ማላ ጎዳ ሲንꬃን ያርሾ፤ ኢዛዴስካ ኣቶ ጌቴታና።» ");
INSERT INTO gmve_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","ጎዳይ ሙሴ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","«ኔኒ ኣሮኔሲኔ ኢዛ ናይታስ ኢስቲ ናጋና ማላ ኔ ኢስታስ ኢማና ኣዛዞይ ሃይሳፌ ካሊዛይሳ፤ ጹጌቲዛ ያርሾይ ፓጬይ ባይንዳ ጋዴይ ዎንታና ጋካናስ ያርሺዛሶዛ ቦላ ኡባ ዎዴ ታማይ ኤጺሼ ኣቆ። ");
INSERT INTO gmve_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ቄሴዚ ላይኖፔ ዳዴቲዳ ቃሚሳኔ ሱሬ ማይኢዲ ጹጌቲዛ ያርሾዛ ታማይ ሚዳይሳፌ ጉዬ ኣቲዳ ቢዲንꬃ ሄፔ ያርሾ ያርሺዛሶዛፔ ሚሌ ባጋራ ቆሎ። ");
INSERT INTO gmve_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ሄሳፌ ጉዬ ባ ማይኢዳ ማይኦ ላሚዲ ቢዲንꬃዛ ቶኪ ኤኪዲ ኣሲ ዲዛሶፔ ጌዴ ካሬ ኬሲዲ ማራራ ሎኦሶን ቆሎ። ");
INSERT INTO gmve_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","ያርሺዛሶ ቦላ ዲዛ ታማይ ቶኦንታ ኡባ ዎዴ ኤጺሼ ዶ፤ ኣይዴካ ቶኦፖ፤ ቄሴዚካ ዎንታ ዎንታ ታማን ሚꬅ ጉጆ፤ ኢዛ ቦላ ጹጌቲዛ ያርሾ ኡባ ዎዴ ጊግሲ ዎꬂዲ ኢሲፌቴꬃ ያርሾስ ሺቂዛ ሃንዳ ጹጎ። ");
INSERT INTO gmve_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","ያርሾ ያርሺዛሶዛ ቦላ ዲዛ ታማይ ኡባ ዎዴ ቶኦንታ ኤጻናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","«ካꬃ ያርሾ ሺሾ ጊሻስ ዎꬂዳ ዎጋቲ ሃይሳፌ ካሊዛይታ፤ ኣሮኔ ባጋፌ ጊዲዳ ቄሴዚ ካꬃ ያርሾ ያርሺዛሶ ሲንꬃ ባጋራ ጾሳስ ያርሾ። ");
INSERT INTO gmve_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ካሌꬂዲ ዛይቴራ ዲዛ ሊቆ ꬊሌ ኩጳቲ ኤኪዲኔ ካꬃ ያርሾ ቦላ ዲዛ ኤጻኔዛ ኡባ ዴንꬂዲ ጎዳስ ሺሺዳይሳ ኤሪሳና ማላ ያርሾ ሺሺዛሶ ቦላ ጹጎ፤ ሄሳ ሳዎይካ ጎዳ ኡፋይሲዛ ያርሾ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","ሄሳፌ ኣቲዳይሳ ቄሴቲ ሜቶ፤ ኢዛንካ ኢርሾይ ጌሎንታ ዲሺን ኡኪዲ ጎዳይ ዎሴቲዛ ጌሻ ዱንካናሲ ሲንꬃ ባጋራ ዲዛ ዴምባ ቦላ ሜቶ። ");
INSERT INTO gmve_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","ሄሲካ ኢዛን ኢርሾይ ጌሎንታ ኡኬታናስ ቤሴስ፤ ታኒ ጎዳይ ታማን ጹጌቲዛ ካꬃ ያርሾፌ ሃይሳ ኢስታ ጊሻ ሂስታ ኢማዲስ፤ ሄሲካ ናጋራ ጊሻሲኔ ቆሆ ጊሻስ ሺሺዛ ያርሾ ማላ ዉሪካ ኬሂ ዱማቲዳዛ። ");
INSERT INTO gmve_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","ዎዴ ዎዴናስ ኣሮኔ ዜሬꬃፌ ኣቱማ ጊዲ ዬሌቲዳይ ዉሪ ጎዳስ ሺቂዛ ያርሾፌ ሻኬቲዲ ዱማ ኢዛስ ጊሻ ኢሜቲዳይሲ ሄሲ ኢዛስ ጊሻ ጊዲዳ ጊሻስ ኢዚ ባ ጊሻ ማናስ ዳንዳዬስ፤ ኦኒካ ሄሳ ሄ ያርሾዛ ቦቺዳዴይ ጎዳስ ዱማቲዳዴ ጊዳና ቤሴስ።» ");
INSERT INTO gmve_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","«ኣሮኔይ ዎይኮ ኢዛ ዜሬꬃቲ ቄሴቴꬃን ሹሜቲዛ ጋላስ ኢስቲ ጾሳስ ሺሻና ካꬃ ያርሾይ ኡባ ዎዴ ኢሲ ኪሎ ጊዲዛ ሊቆ ꬊሌ ካꬃ ያርሾ ኦꬂዲ ጎዳስ ሺሼቶ፤ ሄሳፌ ባጋ ማላዶ፥ ባጋ ኦማርስ ያርሼቶ። ");
INSERT INTO gmve_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ዛይቴን ሎኤꬂ ሙኑቄቲዲ ባሼን ኡኬቶ። ሄሳፌ ጉዬ ካꬃ ያርሾዛ ባሴሬꬂዲ ሳዎዚ ጎዳ ኡፋይሲዛ ሳዎ ጊዳና ማላ ጾሳስ ሺቆ። ");
INSERT INTO gmve_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","ሃይሳፌ ያና ላይꬃታን ቄሴ ጊዲዲ ኦꬂዛ ኣሮኔ ዜሬꬂ ዉሪካ ሃይሳ ሃ ዎጋ ፖሎ፤ ሃይሲ ጾሳስ ሺቂዛ ያርሾ ጊዲዲ ሙሌራ ጹጌቶ። ");
INSERT INTO gmve_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ቄሴዚ ሺሺዛ ካꬃ ያርሾዚ ኩሜꬅ ጹጌቶ ኣቲን ኣሲ ኢዛፔ ሞፖ።» ");
INSERT INTO gmve_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","ጎዳይ ሙሴ ሂዝጊ ኣዛዚዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","«ኣሮኔሲኔ ኢዛ ናይታስ ኔ ሂዝጋ ዮታ፥ ‹ናጋራ ጊሻስ ያርሼቲዛ ያርሾ ዎጋይ ሃይሳፌ ካሊዛይሳ፥ ጹጌቲዛ ያርሾ ሜሄይ ሹኬቲዛሶን ናጋራ ጊሻስ ያርሼቲዛ ያርሾ ሜሄይካ ሄን ጎዳ ሲንꬃን ሹኬቶ፤ ሄሲካ ኬሂ ዱማ ያርሾ። ");
INSERT INTO gmve_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","ሄ ያርሾዛካ ሺሺዛ ቄሴዚ ዱማቲዳሶን ጋይቶቴꬃ ዱንካኔዚ ዲዛ ጊቤዛ ጊዶን ዲዛ ዴምባን ኣሾዛ ሞ። ");
INSERT INTO gmve_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","ኣስ ጊዲን ሃራ ኣይ ሚሺካ ሄ ኣሾዛ ቦቺኮ ዱማታና፤ ሄ ሜሄዛ ሱꬂ ኢዛ ቦላ ፒንጺዳ ኣይ ማይኦይካ ጾሳስ ዱማቲዳሶን ሜጬቶ። ");
INSERT INTO gmve_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","ሄ ኣሾይ ኢዛን ዶይሴቲዳ ማና ሚሺ ሜቆ፤ ኣሾይ ጻርቂማላ ቢራታን ዶይሴቲኮ ሄ ጻርቂማላ ቢራታዚ ቂጬቲዲ ሃꬃን ሜጬቶ። ");
INSERT INTO gmve_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","ቄሴታ ዜሬꬃፌ ጊዲዳ ኣቱማ ና ኡባይ ሄሳ ሄ ያርሾዛፔ ሞ፤ ሄሲካ ኬሂ ዱማ ያርሾ። ");
INSERT INTO gmve_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","ጊዶ ኣቲን ናጋራ ጌሾስ ኦሴቲዛ ዎጋን ሱꬃይ ጋይቶቴꬃ ዱንካኔ ጊዶ ጌሊዳ ጊዲኮ ሄ ሜሄዛ ኣሾዚ ታማን ጹጌቶ ኣቲን ሜቴቶፎ። ");
INSERT INTO gmve_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","« ‹ኬሂ ዱማ ጊዲዳ ጊሻስ ቆሆ ጋሶን ሺቂዛ ያርሾ ዎጋይ ሃይሳፌ ካሊዛይሳ፥ ");
INSERT INTO gmve_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ቆሆ ያርሾስ ሺቂዳ ሜሄይ ጹጌቲዛ ያርሾስ ሺቂዛ ሜሄቲ ሹኬቲዛሶን ሄን ሹኬቶ፤ ሱꬃካ ያርሾ ያርሺዛሶዛ ቦላ ዩዪ ኣꬋናስ ዉጼቶ። ");
INSERT INTO gmve_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","ሞꬌ ኡባ ሺሾ፤ ሄሲካ ጎይና ሃንዳ፥ ቃንꬃ ኣሾ ጎዚ ኦይኪዳ ሞꬌይ፥ ");
INSERT INTO gmve_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ኪላሆታ፥ ኢስታ ካሚ ኦይኪዳ ሞꬌታኔ ሄሳꬆካ ቲሬ ካሚ ኦይኪዳ ሞꬌታ ኢሲ ቦላ ያርሼቶ። ");
INSERT INTO gmve_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ያርሾ ያርሺዛሶን ዲዛ ሞꬌ ኡባ ቄሴዚ ጾሳስ ታማን ጹጊ ያርሾ፤ ሄሲካ ቆሆ ጊሻስ ሺቂዛ ያርሾ። ");
INSERT INTO gmve_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","ቄሴታ ዜሬꬅ ጊዲዳ ኣቱማ ኣሲ ኡባይ ሄ ያርሾዛ ኣሾ ሞ፤ ጊዶ ኣቲን ሄ ያርሾዚ ዱማ ጊዲዳ ጊሻስ ኢዛስ ዱማ ጊጌቲዳሶን ሞ። ");
INSERT INTO gmve_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","« ‹ናጋራ ዉርሳናስ ሺቂዛ ያርሾሲኔ ቆሆስ ሺቂዛ ያርሾ ጊዶን ናምኣታስካ ኦꬂዛ ኢሲ ዎጋይ ዴስ፤ ሄሲካ ሄ ሹኬቲዛ ሜሄዛ ኣሾይ ያርሾዛ ሺሺዛ ቄሴዛስ ማና ማላ ኢዛስ ኢሜቴስ። ");
INSERT INTO gmve_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ጹጌቲዛ ያርሾስ ሺቂዛ ሜሄዛ ጋልባይ ሾቄቲዲ ያርሾዛ ያርሺዳ ቄሴዛስ ኢሜቴስ። ");
INSERT INTO gmve_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","ታማ ጮጬን ኮምፔቲዳ ካꬃ ያርሾይ ዉሪ ዎይኮ ዶይሲዛ ሚሻን ዶይሴቲዳዚኔ ባሼን ኡኬቲዳ ካꬃ ያርሾ ኡባይ ያርሾ ሺሺዛ ቄሴዛስ ኢሜቶ። ");
INSERT INTO gmve_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ዛይቴን ሙኑቄቲዳዝ ጊዲኮ ዎይኮ ጮ ሙኑቄቶንታ ካꬃ ያርሾ ኡባይ ኣሮኔ ዜሬꬃታፔ ጊዲዳ ቄሴታስ ኡባስ ኢሜቶ፤ ኢስቲካ ኢዛ ባ ጋርሳን ኢሲ ጊና ጊሼቲ ኤኬቶ። ");
INSERT INTO gmve_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","« ‹ኣሲ ጎዳስ ሺሺዛ ኢሲፌቴꬃ ያርሾ ዎጋይ ሃይሳፌ ካሊዛይሳ፤ ");
INSERT INTO gmve_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","ኢሲ ኣሲ ጎዳስ ጋላታ ያርሾ ሺሻና ኮይኮ ባ ኤሂዛ ጋላታ ያርሾዛራ ኢርሾይ ኢዛን ጌሎንታ ዛይቴን ሙኑቄቲ ኡኬቲዳ ኡኬꬅ፥ ኢርሾይ ኢዛን ጌሎንታ ሌኤን ኡኬቲዲ ዛይቴን ቲዬቲዳ ኡኬꬅ፥ ሊቆ ꬊሌፌ ዛይቴን ሙኑቄቲዳ ኡኬꬅ ያርሾ። ");
INSERT INTO gmve_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","ጋላታስ ሺቂዛ ኢሲፌቴꬃ ያርሾዛራ ጋꬂ ኢሞታስ ጊዳና ማላ ኢርሾን ሙኑቄቲ ኡኬቲዳ ኡኬꬅ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ኡኬቲዳ ዱማ ዱማ ቆሞ ኡኬꬃታፔ ኢሲ ኢሲ ኡኬꬅ ጎዳስ ዱማ ያርሾ ሂስቲ ሺሾ፤ ሄ ኢሲፌቴꬃ ያርሾስ ሺቂዛ ሱꬃ ኤኪዲ ያርሾ ሺሺዛሶዛ ዩዪ ኣꬋናስ ዉጺዛ ቄሴዛስ ጊሻ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","ጋላታስ ሺቂዛ ኢሲፌቴꬃ ያርሾዛስ ሺቂዛ ኣሾይ ሄ ያርሼቲዛ ጋላስ ሜቴቶ ኣቲን ሃራ ጋላሳስ ኣቶፎ። ");
INSERT INTO gmve_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","ኢሲ ኣሲ ሺሺዛ ያርሾይ ኣዲና ጋሶ ዎይኮ ባ ዶሳን ጮ ኢሚዛ ኢሲፌቴꬃ ያርሾ ጊዲኮ ሄ ያርሾዚ ሺቂዳ ጋላስ ሜቴቶ፤ ኢዛፔ ኣቲዳ ኡባይ ዎንቴꬃ ጋላስ ሜቴቶ። ");
INSERT INTO gmve_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ሄሳፌካ ቲርፒዲ ሄꬓንꬆ ጋላስ ጋካናስ ኣቲዳ ኣሾይ ታማን ጹጌቶ፤ ");
INSERT INTO gmve_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","ሄꬓንꬆ ጋላስ ጋካናስ ኣቲዳ ኣይ ኣሾይካ ሜቴቲዛ ጊዲኮ ሄ ያርሾዛ ሺሺዳዴ ያርሾዚ ኤኬቴና፤ ያርሾዚ ያርሼቲዳ ማላ ቆዴቴና፤ ሄ ያርሾይካ ቱና ጊዲ ቆዴታና፤ ሄ ኣሾዛ ሚዳዴይ ባ ናጋራን ኦይሼታና። ");
INSERT INTO gmve_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","« ‹ቱና ጊዲዳዛራ ቦሼቲዳ ኣሾይ ታማን ጹጌቶ ኣቲን ሜቴቶፎ፤ ሃንኮ ቱኖንታ ኣቲዳ ኣሾዛ ዎጋ ማላ ባና ጌሻቴꬃን ናጊዳዴይ ሞ። ");
INSERT INTO gmve_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ጊዶ ኣቲን ጌሽ ጊዶንታ ኣይ ኣሲካ ጾሳስ ሺቂዛ ኢሲፌቴꬃ ያርሾ ኣሾዛ ሚኮ ጎዳ ዴራ ጊዶፌ ሻኬቲ ኪቾ። ");
INSERT INTO gmve_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","ኣይ ኣሲካ ጌሽ ጊዶንታ ሚሽ ዎይኮ ሜዶሳታኔ ጎጊዛ ቱና ሚሽ ቦቺዲ ኢሲፌቴꬃስ ሺቂዛ ያርሾ ኣሾ ሚኮ ሄሳዴይ ጎዳ ዴራ ጊዶፌ ሻኬቲ ꬋዮ።› » ");
INSERT INTO gmve_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","ጎዳይ ሙሴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«ኔኒ ኢስራኤሌ ኣሳስ፥ ‹ቦራ ዎይኮ ሚዛ ሞꬌ፥ ዶርሳ ሞꬌ ዎይኮ ዴይሻ ሞꬌ ሞፒቴ። ");
INSERT INTO gmve_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ባዉታ ሃይቂዳ ሜሄ ሞꬌይ ዎይኮ ዶኣይ ዎꬊዳ ሜሄ ሞꬌይ ሃራ ኦሶስ ኤኬቶ ኣቲን ኣይ ኣሲካ ኢዛ ሞፖ። ");
INSERT INTO gmve_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","ጹጌቲ ጎዳስ ያርሾ ሺቂዛ ሜሄ ሞꬌ ሚዛዴይ ኦኒካ ጾሳ ዴራ ጊዶፌ ሻኬቲ ꬋዮ። ");
INSERT INTO gmve_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","ኢንቴ ኣዋን ዲኮካ ኢንቴ ዲዛሶን ካፎ ሱꬅ ዎይኮ ሜሄ ሱꬅ ኡዮፒቴ፤ ");
INSERT INTO gmve_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ሱꬅ ኡዪዛዴይ ኦኒካ ጾሳ ዴሬ ጊዶፌ ሻኬቲ ꬋዮ› ጊ ዮቲዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","ጎዳይ ሙሴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«ኔኒ ኢስራኤሌ ኣሳስ፥ ‹ኣይ ኣሲካ ኢሲፌቴꬃ ያርሾ ሺሺዛ ጊዲኮ ኢዛፔ ባጋ ሻኪዲ ጎዳስ ዱማ ያርሾ ሂስቲ ኤሆ። ");
INSERT INTO gmve_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ሄ ኢዚ ኤሆይሳካ ጎዳስ ጹጌቲዛ ያርሾ ሂስቲ ሺሾ፤ ሞꬌዛካ ኣንጋሶዛራ ጎዳ ሲንꬃን ያኔ ሃ ቃሴꬂ ሺሺዛ ያርሾ ሂስቲ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","ቄሴዚ ቃሴ ሞꬌዛ ያርሾ ያርሺዛሶዛ ቦላ ጹጎ፤ ኣንጋሶዚ ጊዲኮ ቄሴታስ ኢሜቶ። ");
INSERT INTO gmve_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ኢንቴ ኢሲፌቴꬃ ያርሾዛፔ ኡሻቻ ሚሳ ቄሴዛስ ጊሻ ሂስቲ ኢሚቴ፤ ");
INSERT INTO gmve_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ኢሲፌቴꬃ ያርሾዛ ሱꬃኔ ሞꬌዛ ሺሺዛ ቄሴዚ ኡሻቻ ሚሳ ባ ጊሻ ሂስቲ ኤኮ። ");
INSERT INTO gmve_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ኢስራኤሌ ኣሳ ኢሲፌቴꬃ ያርሾፌ ያኔ ሃ ቃሴꬂዳ ኣንጋሶዛኔ ያርሾስ ሺሺዳ ሚሳ ኤካዳ ቄሴ ኣሮኔሲኔ ኢዛ ኣቱማ ናይታስ ኢማዲስ፤ ሄሲካ ኡባ ዎዴ ኢስራኤሌ ኣሳፔ ኢስታስ ጊሻ ጊዳና ማላ ኢማዲስ› ጋዳ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","ሃይሲካ ጎዳይ ኣሮኔኔ ኢዛ ናይታ ቄሴ ሂስቲ ሹሚዳ ጋላስ ጎዳስ ሺቂዲ ጹጌቲዛ ያርሾፌ ቄሴታ ጊሻ ጊዳና ማላ ሻኪዳዛ። ");
INSERT INTO gmve_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ሄ ጋላሲካ ኢስቲ ቲዬቲዳ፤ ጎዳይ ሄሳ ሄ ያርሼቲዛይሳፌ ቄሴታስ ኢማና ማላ ኢስራኤሌ ኣሳ ኣዛዚዴስ፤ ሄሲካ ጉዬፔ ያና ዎዴ ኡባን ኢስራኤሌ ናይታስ ኢስታ ጊሻ ሂስቲ ኢማና ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ሄሳ ጊሻስ ጹጌቲዛ ያርሾ ጊሻሲኔ ካꬃ ያርሾ ጊሻስ፥ ናጋራፔ ማሮቴꬃስ ሺቂዛ ያርሾ ጊሻሲኔ ቆሆ ጊሻስ፥ ኤዳ ያርሾ ጊሻስ፥ ቄሴቴꬃ ጊሻስ ሺቂዛ ያርሾኔ ኢሲፌቴꬃ ያርሾ ፖላናስ ዎꬂዳ ዎጋቲ ሃይታንታ። ");
INSERT INTO gmve_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ሄይቲካ ባዞን ሲና ዙማ ቦላ ኢስራኤሌ ናይቲ ያርሾ ሺሻና ማላ ኣዛዚዳ ዎዴ ሄ ጋላስ ጎዳይ ሙሴስ ሃይታ ኣዛዞታ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","ጎዳይ ሙሴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«ኣሮኔኔ ኢዛ ኣቱማ ናይታ፥ ቄሴቴꬃ ማይኦዛካ፥ ቲዬቲዛ ዛይቴዛ፥ ናጋራ ጌሾስ ሺቂዛ ኮርማ ቦራ፥ ናምኡ ꬋርሾኔ ኢርሾይ ጌሎንታ ኡኬቲዳ ኡኬꬂ ኢዛን ዲዛ ሌማቴዛ ኢስታራ ኤካ ያ። ");
INSERT INTO gmve_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ኩሜꬃ ኢስራኤሌ ናይታ ጼይጋዳ ጋይቶቴꬃ ዱንካኔዛ ፔንጌን ሺሻ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","ሙሴይካ ጎዳይ ኢዛስ ዮቲዳ ማላ ኦꬂዴስ፤ ዴሬይካ ጋይቶቴꬃ ዱንካኔ ፔንጌን ሺቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ሙሴይካ ዴራስ፥ «ኦሴታና ማላ ጎዳይ ኣዛዞይሲ ሃይሳኮ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ሙሴይካ ኣሮኔኔ ኢዛ ኣቱማ ናይታ ዴራ ሲንꬅ ሺሺዲ ሃꬃን ሜጪዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","ኣሮኔ ቃሚሳ ማላ ኣዱሳ ማይኦ ማይዚዲ፥ ካቦርቴካ ኢዛ ቦላ ጎጲ ማይዚዲ ዳንጮ ዳንጪሲዴስ፤ ሄሳ ቦላካ ኤፉዴ ጌቴቲዛ ማይኦ ማይዚዲ ኢዛካ ዱማ ሂላቴꬃን ኦሴቲዳ ቃባቶን ኦይሴꬂዲ ዳንጪዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","ኤፉዴ ጌቴቲዛ ማይኦዛስ ቲራ ቦላ ኪሴይ ሲኬቲዲ ኡሪሜኔ ቱሚሜ ጌቴቲዛይታ ኢዛ ጊዶን ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","ኢዛ ሁኤ ቦላካ ጎሴ ጻጺ ዎꬂዲ ሄ ጻꬃ ጎሳ ቦላ ሲንꬃ ባጋራ ጎዳይ ሙሴስ ዮቲዳ ማላ ዎርቃፌ ኦሴቲዳ ሴሎይ ጌሻቴꬃስ ማላታ ጊዳና ማላ ካላቻ ኢዛ ቦላ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ሄሳፌ ጉዬ ሙሴይ ቲዬቲዛ ዛይቴዛ ኤኪዲ ጋይቶቴꬃ ዱንካኔዛኔ ኢዛን ዲዛ ኡባ ቲይዲ ጎዳ ኦሶስ ዱማሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ዛይቴዛፔ ጉꬃራ ኤኪዲ ያርሾ ያርሺዛሶዛ ቦላ ላፑንቶ ዉጺዴስ፤ ቃሴካ ጎዳ ኦሶስ ዱማታና ማላ ያርሾ ያርሺዛሶዛኔ ኢዛ ኦሶስ ጊጌቲዳ ሚሻታ ኩሜꬃ ቦላ ሄሳꬆካ ኢዛን ሜጬቲዛ ሳኔዛኔ ሳኔዛ ኢዛ ቦላ ዎꬂዛይሳ ቦላካ ዉጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ቲዬቲዛ ዛይቴዛ ኣሮኔ ሁኤን ጉሲዲ ጎዳ ኦሶስ ኢዛ ዱማሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ካሌꬂዲካ ሙሴይ ጎዳይ ኢዛ ኣዛዚዳ ማላ ኣሮኔ ኣቱማ ናይታ ሲንꬅ ሺሺዲ ኣዱሳ ማይኦ ማይዚዴስ፤ ጼሳን ቃባቶ ዳንጪሲዲ ኢስታ ሁኤን ቆቤ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ሄሳፌ ጉዬ ሙሴይ ናጋራ ጊሻስ ያርሻናስ ኮርማ ቦራ ኤሂዴስ፤ ኣሮኔይኔ ኢዛ ናይቲ ኮርማ ቦራዛ ቦላ ባ ኩሼ ዎꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ሙሴይካ ቦራዛ ሹኪዴስ፤ ቦራ ሱꬃን ባ ቢራꬌ ጌልꬂዲ ያርሾ ያርሺዛሶዛስ ኦይዱ ባጋን ዲዛ ꬌሞታ ቲይዲ ጌሺዴስ፤ ሄሳፌ ኣቲዳ ሱꬃ ያርሾ ያርሺዛሶዛ ጋርሳን ጉሲዴስ፤ ሄሳ ማላን ያርሾ ያርሺዛሶዛ ጎዳስ ሻኪ ዱማሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ሙሴይ ሹኬቲዳ ሜሄዛ ቃንꬃ ኣሾዛ ቦላ ዲዛ ሞꬌዛ ኡባ፥ ቲሬ ካሚ ኦይኪዳ ሞꬌዛ፥ ኪላሆታኔ ኢስታ ካሚ ኦይኪዳ ሞꬌዛ ኡባ ኤኪዲ ያርሾ ያርሺዛሶዛ ቦላ ጹጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","ኮርማዛ ኣሾፔ ኣቲዳይሳኔ ማራጬዛ ኤኪዲ ጎዳይ ኢዛ ኣዛዚዳ ማላ ኣሳይ ዲዛሶፔ ጌዴ ሃሲዲ ጹጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ሄሳፌ ጉዬ ሙሴይ ጹጌቲዛ ያርሾስ ሺቂዛ ዶርሳ ꬋርሾ ኤሂን ኣሮኔይኔ ኢዛ ናይቲ ꬋርሾዛ ሁኤ ቦላ ባ ኩሼ ዎꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","ሙሴይካ ꬋርሻ ሹኪዴስ፤ ሱꬃካ ያርሾ ያርሺዛሶዛ ቦላ ዩዪ ኣꬋናስ ዉጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ꬋርሾዛ ኣሻ ቆሞን ቆሞን ቃንጺዲ ኬሲዴስ፤ ሁኤዛ፥ ቆሞን ቆሞን ቃንጼቲዳ ኣሾታኔ ሞꬌዛ ጹጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","ጎዳይ ኢዛ ኣዛዚዳ ማላ ሙሴይ ቃንꬃ ኣሾታኔ ቶሆታ ሃꬃን ሜጪዴስ፤ ሄ ꬋርሾዛ ኣሾ ኡባ ጎዳስ ታማን ጹጌቲ ሳዊዛ ያርሾ ኦꬂዲ ያርሾ ያርሺዛሶዛ ቦላ ጹጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ሄሳፌ ካሊዲ ሙሴይ ቄሴቴꬃ ሱንꬃስ ናምኣንꬆ ꬋርሾዛ ኤሂዴስ፤ ኣሮኔይኔ ኢዛ ኣቱማ ናይቲ ባ ኩሼ ꬋርሻ ሁኤ ቦላ ዎꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ሙሴይ ꬋርሻ ሹኪዴስ፤ ሱꬃፌ ጉꬃራ ኤኪዲ ኣሮኔስ ኡሻቻ ሃይꬃ ጼራ፥ ኡሻቻ ማንꬃ ቢራꬌኔ ኡሻቻ ቶሆ ማንꬃ ቢራꬌ ቲይዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ቃሴካ ኣሮኔ ናይታ ዴራ ሲንꬅ ሺሺዲ ኢስታ ኡሻቻ ሃይꬃታ ጼራኔ ኡሻቻ ኩሼ ማንꬃ ቢራꬌታኔ ኡሻቻ ቶሆታ ማንꬃ ቢራꬌታ ቲይዴስ፤ ሄሳፌ ቲርፒዳ ሱꬃ ያርሾ ያርሺዛሶዛ ቦላ ዩዪ ኣꬋናስ ዉጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ሃንዳ፥ ጎይና፥ ቃንꬃ ኣሾ ካሚ ኦይኪዳ ሞꬌ ኡባ፥ ቲሬ ካሚ ኦይኪዳ ሞꬌ፥ ኪላሆታካ፥ ኪላሆታ ቦላ ዲዛ ሞꬌዛኔ ኡሻቻ ሚሴዛ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ኢርሾይ ቦቾንታ ጎዳስ ዱማ ኡኬꬂ ኢዛን ዲዛ ሌማቴዛፔ ኢሲ ዳቦ ኤኪዴስ፤ ሄሳꬆካ ዛይቴን ሙኑቄቲ ኡኬቲዳ ዳቦይ ኢዛን ዲዛ ሌማቴዛፔ ኢሲ ዳቦኔ ሌኤ ኡኬꬅ ኤኪዲ ሞꬌዛ ቦላኔ ኡሻቻ ሚሳ ቦላ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","ሄ ካꬃ ኡባ ኤኪዲ ኣሮኔ ኩሼኒኔ ኢዛ ናይታ ኩሼን ኦይꬂዴስ፤ ኢስቲካ ኦይኪዲ ያኔ ሃ ቃሴꬂዲ ጎዳስ ያርሾ ሺሺዳ። ");
INSERT INTO gmve_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ሄሳፌ ቃሴ ሙሴይ ኢስታ ኩሼፔ ኤኪዲ ቄሴቴꬃ ያርሾ ጊዳና ማላ ሺቂዲ ጹጌቲዛ ያርሾፌ ቦላራ ዎꬂዲ ያርሾ ያርሺዛሶዛ ቦላ ዎꬂዲ ጹጊዴስ፤ ሄሲካ ኢዛ ሳዎይ ጎዳ ኡፋይሲዛ ካꬃ ያርሾ። ");
INSERT INTO gmve_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ሙሴይ ቃሴካ ኣንጋሶዛ ኤኪዲ ያኔ ሃ ቃሴꬂዲ ጎዳስ ሺሺዴስ፤ ሙሴይ ኡባካ ጎዳይ ኢዛ ኣዛዚዳ ማላ ቄሴቴꬃ ሱንꬅ ሱማናስ ሺሺዛ ꬋርሾፌ ሙሴ ጊሻይ ሄሳ። ");
INSERT INTO gmve_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ሙሴይ ቲዬቲዛ ዛይቴፔኔ ያርሾ ያርሺዛሶዛን ዲዛ ሱꬃፌ ጉꬃራ ኤኪዲ ኣሮኔ ቦላ፥ ኣሮኔ ናይታ ቦላኔ ቃሴካ ኢስታ ማይኦ ቦላ ዉጺዴስ፤ ሄሳ ማላን ሙሴይ ኢስታኔ ኢስታ ማይኦ ኡባ ጎዳስ ዱማሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ሙሴይ ኣሮኔኔ ኢዛ ኣቱማ ናይታስ፥ «ኣሾዛ ጋይቶቴꬃ ዱንካኔ ፔንጌን ዶይሲቴ፤ ኣሮኔይኔ ኢዛ ናይቲ ማና ማላ ጎዳይ ኣዛዚዳይሳ ቄሴቴꬃ ሱንꬅ ሱሚዛ ዎዴ ያርሾ ኢዛራ ሺሺዛ ሌማቴን ዲዛ ኡኬꬃራ ሄን ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ኣሾዛፔ ዎይኮ ኡኬꬃዛፔ ቲርፒኮ ታማን ጹጊቴ። ");
INSERT INTO gmve_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","ኢንቴ ቄሴቴꬃ ሱንꬅ ሱሚዛ ዎጋይ ፖሌታናስ ላፑን ጋላስ ኤኪዛ ጊሻስ ሄ ላፑን ጋላሳይ ዉራና ጋካናስ ጋይቶቴꬃ ዱንካኔዛ ፔንጌፌ ኪቾፍቴ። ");
INSERT INTO gmve_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","ኢንቴና ናጋራፔ ጌሻናስ ሃይሳ ሃች ኑ ኦꬂዳ ዎጋ ፖላና ማላ ጾሳይ ኑና ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ሄሳ ጊሻስ ጎዳይ ኣዛዚዳይሳ ፖላናስ ላፑን ጋላስ ኩሜꬅ ጋላሲኔ ኦማርስ ጋይቶቴꬃ ዱንካኔዛ ፔንጌፌ ኪቾፍቴ፤ ጎዳ ዎጋካ ናጊቴ፤ ሂስቶንታ ኣጊኮ ኢንቴ ሃይቃና፤ ታና ጎዳይ ኣዛዚዳ ዎጋይ ሃይሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","ኣሮኔይኔ ኢዛ ናይቲ ሙሴ ባጋራ ጎዳይ ኣዛዚዳይሳ ኡባ ፖሊዳ። ");
INSERT INTO gmve_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ኦስፑንꬃ ጋላሳን ሙሴይ ኣሮኔ፥ ኢዛ ኣቱማ ናይታኔ ኢስራኤሌ ኣሳ ካሌꬂዛ ጪማታ ጼይጊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ኣሮኔካ፥ «ኢሲ ዎሶይካ ኢስታ ቦላ ባይንዳ ኢሲ ሚርጎኔ ኢሲ ꬋርሾ ኤካዳ ሚርጎዛ ናጋራ ጊሻስ ያርሺዛ ያርሾ ꬋርሾዛ ጹጌቲዛ ያርሾ ሂስታ ጎዳስ ያርሻ። ");
INSERT INTO gmve_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ሄሳፌ ጉዬ ኢስራኤሌ ናይታ ናጋራ ጊሻስ ሺቂዛ ያርሾስ ዴይሻ ኦርጌኔ ኢስታ ቦላ ኣይኮ ዎሶይ ባይንዳ ኢሲ ላይꬃ ማራራኔ ኢሲ ላይꬃ ዶርሳ ላቃ ጹጌቲዛ ያርሾስ ኤሃና ማላ ዮታ። ");
INSERT INTO gmve_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ቃሴካ ኢሲ ኮርማኔ ኢሲ ዶርሳ ላቃ ኢሲፌቴꬃ ያርሾስ ኤሄቶ፤ ሄይታንታ ዛይቴን ጊንዴቲዳ ካꬃ ያርሾራ ጎዳስ ያርሾ ሺሼቶ፤ ሄሳ ኡባ ኦꬄቶ፤ ጋሶይካ ጾሲ ኢስታስ ሃች ቆንጫና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","ኢስቲካ ሙሴይ ኢስታ ኣዛዚዳይሳ ኡባ ዱንካኔዛ ፔንጌ ኤሂዳ፤ ኣሳይ ዉሪካ ጎዳ ሲንꬃን ሺቂ ኤቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","ሙሴይ ኢስታስ፥ «ጎዳ ቦንቾይ ኢንቴስ ቆንጫና ማላ ኢንቴ ኦꬃናስ ጎዳይ ኢንቴና ኣዛዚዳ ኣዛዞይ ሃይሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ቃሴካ ሙሴይ ኣሮኔስ፥ «ጌዴ ያርሾይ ያርሼቲዛሶ ሺቃዳ ኔ ናጋራኔ ዴሬዛ ናጋራ ዉርሳናስ ሺቂዛ ያርሾኔ ጹጌቲዛ ያርሾ ያርሻ፤ ሄሳ ኡባ ጎዳይ ዴሬዛ ናጋራ ዉርሳና ማላ ኢዚ ኔና ኣዛዚዳ ማላ ሺሻ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","ኣሮኔይካ ያርሾ ያርሺዛሶ ቢዲ ኮይሮ ባ ናጋራ ጊሻስ ሺቂዛ ያርሾስ ሺቂዛ ሚርጎዛ ሹኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","ኢዛ ናይቲ ሱꬃ ኢዛስ ኤሂዳ፤ ኢዚካ ሱꬃን ባ ቢራꬌ ጌልꬂ ኬሲዲ ያርሾ ያርሺዛሶዛ ቦላ ዲዛ ꬌሞታ ሱꬅ ቲይዴስ፤ ኣቲዳ ሱꬃ ያርሾ ያርሺዛሶ ጋርሳን ጉሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ሄሳፌ ካሌꬂዲ ሞꬌዛ፥ ኪላሆታኔ ቲሬ ካሚ ኦይኪዳ ሞꬌታ ኤኪዲ ጎዳይ ሙሴ ኣዛዚዳ ማላ ያርሾ ያርሺዛሶዛ ቦላ ጹጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","ኣሾዛኔ ጋልባዛ ቃሴ ኣሳይ ዲዛሶፔ ጌዴ ሃራሶ ሃሲዲ ጹጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ሄሳፌ ጉዬ ኣሮኔይ ጹጌቲዛ ያርሾስ ሹኪዴስ፤ ሂስቲን ኢዛ ናይቲ ሱꬃ ኢዛስ ኤሂዳ፤ ኢዚካ ሱꬃዛ ኤኪዲ ያርሾ ያርሺዛሶዛ ቦላ ዩዪ ኣꬋናስ ዉጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ኢዛ ናይቲ ጹጌቲዛ ያርሾስ ሹኬቲዳ ኣሾዛ ቆሞን ቆሞን ሁኤዛራ ጋꬂ ኢዛስ ኤሂ ኢሚዳ፤ ኢዚካ ሄሳ ኡባ ያርሾ ያርሺዛሶዛ ቦላ ጹጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ሄሳፌ ቃሴካ ቃንꬃ ኣሾዛኔ ጉዬ ቶሆታ ሃꬃን ሜጪዲ ያርሾ ያርሺዛሶዛ ቦላ ጹጌቲዛ ያርሾዛራ ኢሲፌ ጋꬂ ጹጌቲዛሶን ጹጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ሄሳፌ ካሌꬂዲ ኣሮኔይ ዴሬዛ ናጋራ ጊሻስ ሹኬቲዛ ዴይሻ ኦርጌ ኤኪ ሹኪዲ ባ ናጋራ ጊሻስ ያርሺዳይሳꬆ ያርሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ጹጌቲዛ ያርሾዛ ኤሂዲ ካሴ ዲዛ ዎጋ ማላ ያርሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ካꬃ ያርሾዛካ ሺሺዴስ፤ ꬊሌዛፔ ኩጳ ኩሜꬅ ኤኪዲ ያርሾ ያርሺዛሶዛ ቦላ ጹጊዴስ፤ ሄሲካ ጹጌቲዛ ያርሾስ ማላዶ ማላዶ ሺቂዛ ያርሾዛ ቦላ ጉጄቲዲ ሺቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","ኮርማ ቦራኔ ꬋርሾዛ ሹኪዲ ዴሬዛ ጊሻስ ኢሲፌቴꬃ ያርሾ ሺሺዴስ፤ ኢዛ ናይቲካ ሱꬃ ኢዛስ ኤሂዳ፤ ኢዚካ ሱꬃ ኤኪዲ ያርሾ ያርሺዛሶዛ ዩዪ ኣꬋናስ ዉጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ኣሮኔይካ ኮርማ ቦራ ሞꬌዛ፥ ꬋርሻ ሞꬌዛ፥ ኡባካ ጎይና ቶልꬆዛ፥ ቃንꬃ ኣሾ ካሚ ኦይኪዳ ሞꬌዛኔ ቲሬ ካሚ ኦይኪዳ ሞꬌዛ ዶሬቲዳይሳ ቲሬታኔ ኢስታ ቦላ ዲዛ ሞꬌዛ ኤኪዲ፥ ");
INSERT INTO gmve_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ሄ ሜሄታ ኣንጋሶ ጼራ ቦላ ዎꬂዳ፤ ኣሮኔይ ሞꬌዛ ኡባካ ያርሾ ያርሺዛሶዛ ቦላ ጹጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ኣንጋሶታኔ ኡሻቻ ጌዳ ኣሾታ ሙሴይ ኣዛዚዳ ማላ ያኔ ሃ ቃሴꬂዲ ጎዳስ ዱማ ያርሾ ሂስቲ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ኣሮኔይ ናጋራ ጊሻስ ሺቂዛ ያርሾ፥ ጹጌቲዛ ያርሾኔ ኢሲፌቴꬃ ጊሻስ ሺቂዛ ያርሾ ያርሺዳፔ ጉዬ ባ ኩሼ ꬎቁ ሂስቲዲ ዴራ ኣንጂዲ ዎꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","ሙሴይኔ ኣሮኔይ ጋይቶቴꬃ ዱንካኔ ጊዶ ጌሊዳ፤ ሄፔ ኬዚሼ ዴሬዛ ኣንጂዳ፤ ጎዳ ቦንቾይ ኣሳ ኡባስ ቆንጪዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","ኣሳይ ቆፖንታ ዲሺን ጎዳ ኣቻፌ ኪቴቲዳ ታማይ ዪዲ ያርሾ ያርሺዛሶዛ ቦላ ዲዛ ያርሾስ ሺቂዳ ሃንዳዛ ኡባ ሚዴስ፤ ዴሬዚካ ዉሪ ሄሳ ቤኢዲ ኢሊሊ ጊዴሲኔ ዉሪካ ሆኪ ጎይኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","ናዳቤይኔ ኣቢሁ ጌቴቲዛ ኣሮኔ ና ናምኣቲ ኢሶይ ኢሶይ ባስ ባስ ኤጻኔ ጩዋሲዛ ጺና ኤኪዲ ቦንቆ ታማ ኢዛን ጉጂዳ፤ ቃሴካ ኤጻኔካ ኢዛን ጉጂዲ ጎዳስ ሺሺዳ፤ ሄ ኢስቲ ኤኪዳ ታማይ ጎዳስ ዱማቲዳ ታማ ጊዶንታ ጊሻስ ኢስቲ ሄሳ ማላ ታማ ሺሻና ማላ ጎዳይ ኢስታ ኣዛዚቤና። ");
INSERT INTO gmve_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ኢስቲ ቆፖንታ ጾሳ ኣቻፌ ዪዳ ታማይ ኢስታ ሚዳ ጊሻስ ኢስቲ ጎዳ ሲንꬃን ሃይቂዳ። ");
INSERT INTO gmve_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","ሙሴይ ቃሴ ኣሮኔስ፥ «ጎዳይ፥ ‹ታ ሲንꬄ ሺቂዲ ታስ ኦꬂዛይታስ ታኒ ታ ጌሻቴꬃ ቆንጪሳና፤ ታኒካ ታ ዴሬዛ ኣቻን ቦንቼቲዳዴ ጊዳና› ጊዲ ኢዚ ኣሳ ካሴ ቆፍሲዳይሲ ሃይሳ» ጊዴስ። ኣሮኔይካ ኣይ ዛሮካ ኢሞንታ ጮኡ ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","ሙሴይካ ኣሮኔስ ኣዋ ኢሻ ኡዚኤሌ ናይታ ሚሻኤሌኔ ኤልጻፋኔ ጼይጊዲ፥ «ሃ ዪቴ! ሃይሳ ኢንቴ ኢሻታ ኣሃ ጌሻ ዱንካኔፔ ዴንꬂዲ ኣሲ ዲዛሶፔ ጌዴ ሃራሶ ኤፍቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","ኢስቲካ ቄሴቴꬃ ማይኦዛ ሃይቂዳይታ ኣሃ ቦላፌ ኬሶንታ ዲሼ ቢዲ ሙሴይ ኣዛዚዳ ማላ ኣሳታ ኣሃ ኣሳይ ዲዛሶፔ ጌዴ ሃራሶ ኤፊዳ። ");
INSERT INTO gmve_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","ሄሳፌ ካሊዲ ሙሴይ ኣሮኔስ፥ ኢዛ ና ኤልኤዜሬሲኔ ኢታማሬስ፥ «ኢንቴ ሃይቆንታ ማላኔ ጎዳ ሃንቆይ ዴራ ቦላ ዮንታ ማላ ሃይቂዳይታስ ሚሼቲዲ ኢንቴ ሁኤ ቡጮፍቴ፤ ኢንቴ ማይኦካ ዳኮፍቴ፤ ጊዶ ኣቲን ሃንኮ ኢስራኤሌ ናይቲ ጎዳ ኣቻፌ ዪዳ ታማን ሃይቂዳይታስ ዬካና ዳንዳዬቴስ። ");
INSERT INTO gmve_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ኢንቴ ጎዳይ ኣዛዚን ቲዬቲዛ ቲዮ ዛይቴን ቲዬቲዳ ጊሻስ ኢንቴ ሃይቆንታ ማላ ጋይቶቴꬃ ዱንካኔ ፔንጌፌ ካሬ ኬዞፒቴ» ጊዴስ። ኢስቲካ ሙሴይ ኣዛዚዳ ማላ ሃኒዳ። ");
INSERT INTO gmve_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","ጎዳይ ኣሮኔስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«ኔኒኔ ኔ ናይቲ ዎይኔፔ ኦሴቲዳ ኡሹ ዎይኮ ሃራ ማꬆሲዛ ኡሹ ኡዪዲ ጋይቶቴꬃ ዱንካኔዛን ኢንቴ ጌሎንታ ማላ ናጌቲቴ፤ ሂስቶንታ ኣጊኮ ኢንቴ ሃይቃና፤ ሃይሲ ሃ ዎጋዚ ኢንቴፌካ ጉዬን ያና ዬሌታ ኡባ ማታንካ ሜርናስ ናጌታናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ኢንቴ ዱማቲዳይታኔ ዱማቶንታይታ፥ ጌሺኔ ቱና ጊዲዳይታ ጊዶን ዲዛ ዱማቴꬃ ሻኪ ኤራናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ታ ኢንቴስ ሙሴ ባጋራ ኢሚዳ ዎጋ ኡባ ኢስራኤሌ ናይታ ታማርሲቴ።» ");
INSERT INTO gmve_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","ሙሴይካ ኣሮኔኔ ኣቲዳ ኢዛ ና ናምኣታ ኤልኤዜሬኔ ኢታማሬስ፥ «ጎዳስ ታማን ጹጌቲ ሺቂዳ ካꬃፌ ኤኪዲ ኢርሾይ ቦቾንታ ኡኬꬅ ኡኪቴ፤ ኢዚካ ኬሂ ዱማቲዳ ያርሾ ጊዲዳ ጊሻስ ያርሾ ያርሺዛሶዛ ኣቻን ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ጎዳስ ታማን ጹጌቲ ሺቂዛ ካꬃ ያርሾፌ ሻኬቲዲ ኢንቴሲኔ ኢንቴ ናይታስ ኢሜቲዳ ጊሻ ጊዲዳ ጊሻስ ኢንቴ ኢዛ ጎዳስ ዱማቲዳሶን ሚቴ፤ ኢንቴ ሄሳꬆ ሂስታና ማላ ጾሲ ታና ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ጊዶ ኣቲን ያኔ ሃ ቃሴꬆን ዱማ ያርሾ ጊዲዲ ጎዳስ ሺቂዳፔ ጉዬ ቄሴታ ጊሻ ጊዳና ማላ ጌቴቲዳ ጊሻስ ኣንጋሶዛኔ ሚሴዛ ኔኒኔ ኔ ኬꬃን ዲዛ ኔ ማጫ ናይቲ ማንዴታ፤ ሄሳ ሄ ዎጋካ ጎዳስ ዱማቲዳሶን ማንዴታ፤ ሄሲካ ኢስራኤሌ ኣሳይ ኢሲፌቴꬃ ጊሻስ ሺሺዛ ያርሾ ኡባፌ ሻኬቲ ኔሲኔ ኔ ናይታስ ኢሜቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ሺቂዳ ሚሴዛኔ ኣንጋሶዛ ጎዳ ሲንꬃን ያኔ ሃ ቃሴꬂ ሺሺዛ ያርሾዛ ማላ ቃሴꬃናስ ኤሄቶ፤ ሄሲካ ጎዳይ ኣዛዚዳ ማላ ሜርናስ ኔሲኔ ኔ ናይታስ ጊሻ ጊዶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ሙሴይ ናጋራ ጊሻስ ሺቂዳ ያርሾስ ሺቂዳ ዴይሻ ኦይቺ ሲዪዲ ኢዚ ጹጌቲዳይሳ ኤሪዴስ፤ ሄሳ ጊሻስ ሙሴይ ኤልኤዜሬ ቦላኔ ኢታማሬ ቦላ ሃንቄቲዲ፥ ");
INSERT INTO gmve_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«ኢንቴ ናጋራ ጊሻስ ሺቂዳ ያርሾዛ ጾሳስ ዱማቲዳሶን ኣዛስ ሚቤኬቲ? ያርሾዚ ጎዳስ ኬሂ ዱማ፤ ኢዚ ዴሬዛፔ ናጋራኔ ቆሆ ዉርሳና ማላ ጎዳይ ሄሳ ኢንቴስ ኢሚዳዛ። ");
INSERT INTO gmve_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","ሱꬃዚ ጌዴ ጎዳስ ዱማቲዳ ዱንካኔዛን ጌሎንታ ጊሻሲኔ ታ ኢንቴና ኣዛዚዳ ማላ ኢንቴ ሄ ዱማቲዳሶን ሺቂዳ ያርሾዛ ኢንቴ ማናስ ቤሴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","ኣሮኔይካ ሙሴስ፥ «ናጋራ ጊሻስ ሺቂዛ ጹጌቲዛ ያርሾ ሄኮ ሃች ኣሳይ ጾሳ ሲንꬅ ኤኪ ዪዴስ፤ ታናካ ሃይሳ ማላ ሜቶይ ጋኪዴስ፤ ሂስቲን ሃች ናጋራ ጊሻስ ሺቂዛ ያርሾዛ ታ ሚዳኮ ጎዳይ ኡፋዬታናሺን ኣቲዴ?» ጊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","ሙሴይካ ሄሳ ሲዪዲ ኢዚ ዛሪዳ ቃላን ኡፋዬቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","ጎዳይ ሙሴሲኔ ኣሮኔስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«ሃይሳ ኢስራኤሌ ናይታስ ዮቲቴ፥ ‹ቢታ ቦላ ዲዛ ዶኣታፔኔ ሜሄታፔ ኢንቴ ማናይቲ ሃይሳፌ ካሊ ዲዛይታ፥ ");
INSERT INTO gmve_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ቶሆ ቂንጪፊሌይ ጳልቄꬃታኔ ባንቺኪዛይታ ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","« ‹ጊዶ ኣቲን ባንቺኪዛይታ ጊዲ ኡቲዲ ቂንጪፊሌይ ጳልቄቶንታይታ ዎይኮ ባንቺኮንታይታ ጊዲ ኡቲዲ ቂንጪፊሌይ ጳልቄቲዳይታ ሞፒቴ፤ ጋሜላይ ባንቺኬስ ሺን ቂንጪፊሌይ ጳልቄቶንታ ጊሻስ ኢዚ ኢንቴስ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","ጉፓሌይ ባንቺኬስ ሺን ቂንጪፊሌይ ጳልቄቶንታ ጊሻስ ኢዚ ኢንቴስ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","ሃርባይኖይ ባንቺኬሲሺን ቂንጪፊሌይ ጳልቄቶንታ ጊሻስ ኢዚ ኢንቴስ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ጉዱንꬂካ ሞፒቴ፤ ኢዛ ቂንጪፊሌይ ጳልቄꬅ ጊዲኮካ ኢዚ ባንቺኮንታ ጊሻስ ኢንቴስ ቱና ጊዲ ቆዴቶ። ");
INSERT INTO gmve_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ሄይታንቲ ቱና ጊዲዳ ጊሻስ ኢስታ ኣሾ ሞፒቴ፤ ሃራይ ኣቶሺን ኢስታ ኣሃካ ቦቾፍቴ። ");
INSERT INTO gmve_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","« ‹ኣባ ጊዶኒኔ ሻፋ ሃꬃታ ጊዶን ዲዛ ሜꬌቴꬃታ ኣባ ጊዶፌ ቄፌይኔ ፖቆ ማላ ጋልባይ ዲዛ ኡባ ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","ኣባ ጊዶኒኔ ሻፋ ሃꬃ ጊዶን ዲዛ ሜꬌቴꬃታፔኔ ሼምፖራ ፓጻ ዲዛ ሃራ ሜꬌቴꬃታ ኡባ ጊዶፌ ቄፌይኔ ፖቄቲዛ ጋልባይ ባይንዳ ኡባይ ኢንቴስ ቱና ጊዲዳ ጊሻስ ሞፒቴ። ");
INSERT INTO gmve_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","ሄይታንቲ ቱና ጊዲዳ ጊሻስ ኢስታ ኣሾ ሞፒቴ፤ ሃራይ ኣቶሺን ኢስታ ኣሃካ ቦቾፍቴ። ");
INSERT INTO gmve_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","ሄሳ ጊሻስ ሃꬃ ጊዶን ዲዛ ቄፌይኔ ፖቄቲዛ ጋልባይ ኢስታ ቦላ ባይንዳ ሜꬌቴꬃቲ ዉሪካ ኢንቴ ኣቻን ኢጼቲዳይታ ጊዴቶ። ");
INSERT INTO gmve_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","« ‹ካፎታፔ ሃይሳፌ ካሊዛይቲ ቱና ጊዲዳ ጊሻስ ሞፒቴ። ሄይታንቲካ ጎሌ፥ ቆሎ፥ ዎሌ ");
INSERT INTO gmve_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ጺሎ፥ ዱማ ዱማ ቆሞ ጲርጮታ። ");
INSERT INTO gmve_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ዱማ ዱማ ቁሮታ ");
INSERT INTO gmve_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ያንቻ፥ ጫንጬ ጉቶ፥ ሃꬃ ካፎ፥ ጋጬ ዛሬ ኡባ፥ ");
INSERT INTO gmve_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ጉቶ፥ ቢያ፥ ዪንዳሬ ");
INSERT INTO gmve_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ዎይኖ፥ ሃꬃ ካፎ፥ ኣንኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ዚጊሌ፥ ሳቢሳ ካፎ ዛሬ ኡባ፥ ጂንጂላቴ ጌቴቲዛ ካፎኔ ዉርካዉርኮ። ");
INSERT INTO gmve_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","« ‹ቄፌይ ዲሺን ኦይዱ ቶሆራ ቃጺዛ ሜꬌቴꬃቲ ዉሪካ ቱናታ፤ ");
INSERT INTO gmve_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ሄይታንታ ጊዶፌ ጉፓናስ ማዲዛ ጌዳይ ዲዛ ሜꬌቴꬃታ ሚቴ፤ ");
INSERT INTO gmve_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ሄይቲካ ቦሌ ዛሬታ፥ ጺንጎታ ዛሬታኔ ጉምባሮ ዛሬ ኡባ። ");
INSERT INTO gmve_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","ሂንኮ ቄፌይ ዲሺን ኦይዱ ቶሆራ ሄሜቲዛ ሜꬌቴꬃታ ኢንቴ ቱና ማላ ቆዲቴ። ");
INSERT INTO gmve_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","« ‹ሃይሳፌ ካሊ ዲዛይታ ቦቺዳዴይ ዉሪ ኦማርስ ጋካናስ ቱና ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","« ‹ሄይታንታ ኣሃ ዴንꬂዳዴይ ዉሪካ ባ ማይኦ ሃꬃን ሜጮ፤ ሜጪኮካ ኦማርስ ጋካናስ ኢዛዴይ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","« ‹ቂንጪፊሌይ ኢስታስ ዲሺን ጳልቄቶንታይቲኔ ባንቺኮንታ ሜሄይ ዉሪካ ኢንቴስ ቱና ጊዳና፤ ሄይታንታ ቦቺዳዴይ ዉሪካ ቱኔስ። ");
INSERT INTO gmve_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","ኦይዱ ቶሆራ ዲዛይታፔ ቂንጪፊሌይ ባይንዳ ካንቴን ሄሜቲዛይቲ ዉሪካ ኢንቴ ኣቻን ቱናታ ጊዴቶ፤ ኢስታ ኣሃ ቦቺዳዴይ ኦማርስ ጋካናስ ቱና ጊዶ፤ ");
INSERT INTO gmve_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","ሄይታንታ ኣሃ ዴንꬂዳዴይ ዉሪካ ባ ማይኦ ሃꬃን ሜጮ፤ ሜጪኮካ ኦማርስ ጋካናስ ኢዛዴይ ቱና ጊዶ፤ ኢስቲካ ኢንቴ ኣቻን ቱና። ");
INSERT INTO gmve_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","« ‹ቢታራ ጎሼቲዛይታ ጊዶፌ ሃይሳፌ ካሊዛይቲ ኢንቴስ ቱና ጊዴቶ፤ ጊሮይ፥ ኤጬሬይ፥ ዛሬይ፥ ኮርቼይ፥ ሃይላሾይ፥ ጌጌይ፥ ዋካላይኔ፥ ሻቃንቻይ ኢንቴስ ቱና ጊዴቶ። ");
INSERT INTO gmve_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ቢታራ ጎሼቲዛ ኡባታፔ ቱና ጊዲዳይቲ ሃይታንታ፤ ኢስታ ጊዲን ዎይኮ ኢስታ ኣሃ ቦቺዛዴይ ዉሪ ኦማርስ ጋካናስ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","ኢስታ ኣሃይ ኢዛ ቦላ ዎꬊዳ ሚሺ ዉሪካ ቱኔስ፤ ሄሲካ ሚꬃፌ ኦሴቲዳ ሚሻቲ፥ ማይኦቲ፥ ጋልባ፥ ካራጺቴ፥ ኦጎሮኔ ሄይታንታ ሚሳቲዛ ሃራታካ ጉጄስ፤ ኢስታ ኣሃ ቦቺዳ ሚሺ ዉሪካ ሃꬃን ጌሊዲ ጋምኦ፤ ኦማርስ ጋካናስ ቱና ጊዲዲ ሄሳፌ ጉዬ ጌሽ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","ሄይታንታ ኣሃይ ማና ሚሻ ጊዶን ጌሊኮ ሄ ሚሻ ጊዶን ዲዛ ሚሺ ዉሪካ ቱኒዛ ጊሻስ ሄ ማና ሚሻዛ ዎꬊቴ። ");
INSERT INTO gmve_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ሄ ማና ሚሻፌ ሃꬂ ኢዛ ቦላ ጾኬቲዳ ካꬂ ዉሪካ ቱና ጊዴስ፤ ኢዛን ዲዛ ኡዬቲዛ ሚሺካ ቱና ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","ኣይ ኣሃይካ ቦቺዳ ሚሺ ዉሪካ ቱና ጊዲዳ ጊሻስ ኢዛ ኢጺቴ፤ ማኒ ሜꬊዳ ጮጬ ጊዲን ኦቶይ ሜቆ። ");
INSERT INTO gmve_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","ሄይታንታ ኣሃይ ሃራ ኡባ ቱኒሲዛዝ ጊዲኮካ ፑልቶ ሃꬄኔ ሃꬂ ዲዛ ኦላ ቱኒሴና። ");
INSERT INTO gmve_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ዜሬꬃስ ኡቲዳ ካꬃ ቦላ ዎꬊኮ ዜሬꬃይ ቱኔና። ");
INSERT INTO gmve_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ጊዲኮካ ዜሬꬃ ቦላ ሃꬂ ጉኪ ሲሚን ኣሃይ ቦቺኮ ሄ ዜሬꬃይ ሄሳፌ ጉዬ ቱና ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","« ‹ሜቴቲዛ ሜሄ ጋርሳፌ ኣዋይሲካ ሃይቂን ሄ ሃይቄꬃ ቦቺዳዴይ ኦማርስ ጋካናስ ቱና። ");
INSERT INTO gmve_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","ኣይ ኣሲካ ሄ ሃይቄꬃፌ ሚኮ ባ ማይኦ ሜጮ፤ ኦማርስ ጋካናስ ቱና ጊዶ፤ ኣይ ኣሲካ ሄ ሃይቄꬃ ኣሃ ቶኪኮ ባ ማይኦ ሜጮ፤ ጊዲኮካ ኦማርስ ጋካናስ ኢዛዴይ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","« ‹ቢታራ ጎሼቲዛ ኣይ ሜꬌቴꬃቲ ዉሪካ ኢንቴ ኣቻን ሜቴቶንታዚኔ ኢጼቲዳዝ ጊዴቶ። ");
INSERT INTO gmve_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ቲራን ጎሼቲዛ፥ ኦይዱ ቶሆራ ቢዛይታ፥ ዎይኮ ዳሮ ቶሆይ ዲዛይታ ኡባካ ሞፒቴ፤ ኢስቲ ኢንቴ ማታንካ ኢጼቲዳይታ ጊዴቶ። ");
INSERT INTO gmve_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ሄይታንታፌ ኣዋይሳካ ሚዲ ኢንቴና ቱኒሶፒቴ። ");
INSERT INTO gmve_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ታኒ ጎዳ ኢንቴ ጾሳ፤ ታኒ ሃራፔ ዱማ ጊዲዳ ጊሻስ ኢንቴካ ዱማ ጊዲቴ፤ ባ ቲራን ጎሼቲዛይታ ሚዲ ኢንቴርካ ኢንቴና ቱኒሶፒቴ። ");
INSERT INTO gmve_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","ኢንቴስ ጎዳ ጊዳናስ ጊብጼፔ ኢንቴና ካሌꬃ ኬሲዳይ ኢንቴ ጾሳይ ታና፤ ሄሳ ጊሻስ ታኒ ዱማ ጊዲዳ ማላ ኢንቴካ ዱማ ጊዲቴ። ");
INSERT INTO gmve_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","« ‹ሜሄታ፥ ዶኣታ፥ ካፎታ፥ ሃꬃ ጊዶኒኔ ቢታ ቦላ ቲራን ጎሼቲዛ ሜꬌቴꬃታ ኡባ ጊሻስ ኢሜቲዳ ዎጋይ ሃይሳ፤ ");
INSERT INTO gmve_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ዎꬊዳ ዎጋ ማላ ጌሻታኔ ጌሽ ጊዶንታይታ ጊዶን ዲዛ ዱማቴꬅ ሻኪ ኤራናስ ሄሲካ ሜቴቲዛይታኔ ሜቴቶንታይታ ጊዶን ዲዛ ዱማቴꬃ ሻኪ ኤራናስ ኢንቴ ሎኤꬂ ናጌቲቴ።› » ");
INSERT INTO gmve_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«ኢስራኤሌ ኣሳስ፥ ‹ማጫሲ ሻራዳ ኣቱማ ና ዬሊኮ ካሴ ማጫሳ ዎጋይ ኢዚ ቦላ ቤቲዳ ዎዴ ሃኒዛይሳꬆ ላፑን ጋላስ ጋካናስ ኢዛ ቱና ጊዳዉስ። ");
INSERT INTO gmve_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ዬሌቲዳ ናዚ ኦስፑንꬃ ጋላስ ቃጻሬታናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ሄሳፌ ጉዬ ጋጪኖ ሱꬃይ ኢዚፔ ኤቃና ጋካናሲኔ ኢዛ ዬሎሶፌ 33 ጋላስ ጋካናስ ጾሳስ ዱማቲዳ ኣይ ሚሺካ ቦቻናስ ቤሴና፤ ሄሲካ ኢዛ ጌይዛ ዎዴይ ዉሮንታ ዲሺን ጋይቶቴꬃ ዱንካኔ ጊዶ ጌሉፑ። ");
INSERT INTO gmve_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","« ‹ሄሳꬆካ ኢሲ ማጫሲ ማጫ ና ዬሊኮ ካሴ ቦላ ቂታይ ኢዚ ቦላ ቤቲዳ ዎዴ ሃኒዛይሳꬆ 14 ጋላስ ጋካናስ ቱና ጊዳዉስ፤ ሄሳፌ ጉዬ ሱꬃይ ኢዚፔ ሲሚን ኢዛ ዬሎሶፌ 66 ጋላስ ጋካናስ ጋምኡ። ");
INSERT INTO gmve_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","« ‹ኢዛ ጌይዛ ጋላሳቲ ዉሪዛ ዎዴ ኣቱማ ና ጊሻስ ጊዲን ዎይኮ ማጫ ና ጊሻስ ጹጌቲዛ ያርሾስ ኢሲ ላይꬃ ላቃኔ ናጋራፔ ጌያናስ ሺቂዛ ያርሾስ ሃራጴ ዎይኮ ሃራጴ ጪዬ ጋይቶቴꬃ ዱንካኔ ፔንጌ ኤሃዳ ሄን ኦꬂዛ ቄሴስ ኢሙ። ");
INSERT INTO gmve_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ቄሴዚካ ኢዛ ኢሚዛይሳ ኢዚፔ ኤኪዲ ጎዳስ ያርሾ ሺሾ፤ ማጫሳያካ ኢዛ ዬሊሺን ኢዚፔ ጉኪዳ ሱꬃፌ ጌያዉስ፤ ሃይሲ ኣቱማ ና ዎይኮ ማጫ ና ዬሊዛ ማጫሳስ ዎꬊዳ ዎጋ። ");
INSERT INTO gmve_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","ዬሊዳ ማጫሳያ ዶርሳ ላቃ ኤሃናስ ዳንዳዮንታሮ ጊዲኮ ናምኡ ሃራጴታ ዎይኮ ናምኡ ዋኖሴታ ኤሁ፤ ናምኣታፔ ኢሶይ ጹጌቲዛ ያርሾስ፥ ሃንኮይሲ ናጋራ ጌሾስ ያርሾ ሺቆ፤ ቄሴዚካ ኢዞ ናጋራፔ ጌሾ፤ ሄሳፌ ጉዬ ኢዛ ጌሽ ጊዳና› ጌስ።» ");
INSERT INTO gmve_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","ጎዳይ ሙሴሲኔ ኣሮኔስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«ኣይ ኣሲካ ኢዛዴ ቦላ ኪጻይ ዎይኮ ሺምፔይ ዎይኮ ኢሊዋይ ኢዛዴ ቦላ ቤቲዲ ቃቻ ሃርጌ ማላ ካሴፔ ጌዴ ዳሪ ዳሪ ቢኮ ኢዛዴ ጌዴ ቄሴ ኣሮኔኮ ዎይኮ ቄሴ ጊዲዳ ኢዛ ናይታፔ ኢሳኮ ኤፌቶ። ");
INSERT INTO gmve_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ቄሴዚካ ሄ ማዱንꬃ ሎኤꬂ ጼሎ፤ ሄ ማዱንꬃ ሄራን ዲዛ ኢስኬይ ቦጺዛዝ ጊዲኮኔ ማዱንꬃዚ ዱጌ ኦላቲ ቤቲኮ ሄሲ ዳሮ ኢታ ሃራ ኣሳ ቦላ ኣꬊዛ ጋልባ ሃርጌ፤ ቄሴዚ ካሴ ዎጋ ማላ ኢዛዴይ ቱና ጊዲዳይሳ ኣሳስ ኤሪሶ። ");
INSERT INTO gmve_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","ጊዶ ኣቲን ማዱንꬃዚ ቦጺዲ ዱጌ ኦላቶንታ ኣጊኮኔ ኢዛ ሄራን ዲዛ ኢስኬዚካ ቦጾንታ ኣጊኮ ቄሴዚ ሄሳዴ ላፑን ጋላስ ጋካናስ ሶን ካሬ ባ ቦላ ጎርዲ ባርካ ጋምኣና ማላ ኦꬆ። ");
INSERT INTO gmve_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ላፑንꬆ ጋላስ ቄሴዚ ኢዛ ቃሴካ ፓጪ ጼሎ፤ ኢዚ ኢዛ ፓጪሺን ማዱንꬃይ ካሴፔ ኣይኮካ ዱማቴꬅ ቤሶንታ ኣጊኮ ሃኢካ ሃራ ላፑን ጋላስ ኢዚ ባ ኬꬃን ካሬ ባ ቦላ ጎርዲ ኡታና ማላ ኦꬆ። ");
INSERT INTO gmve_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ላፑን ጋላሳፌ ጉዬ ቄሴዚ ኢዛ ቃሴካ ፓጪ ጼሎ፤ ኢዚ ፓጪ ጼሊሺን ማዱንꬃይ ጌዴ ዲች ኣጊዲ ካሴፔ ጉጺ ቤቲኮ ሄ ማዱንꬃይ ዴጾ ጊዶንታይሳ ኢዛስ ዮቲዲ ዎጋን ዲዛይሳ ማላ ኢዚ ጌሽ ጊዲዳይሳ ኢዛ ኤሪሶ፤ ኢዛዴይካ ዎጋይ ጊዛ ማላ ጌያናስ ባ ማይኦዛ ሃꬃን ሜጮ። ");
INSERT INTO gmve_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","ሄሲካ ቄሴዚ ኢዚ ጌሽ ጊዲዳይሳ ፓጪዲ ኢዛዴስ ኤሪሲዳፔ ጉዬ ቃሴካ ማዱንꬃይ ካሴፔ ኣኪ ኣኪ ቢኮ ሄሳዴይ ቃሴካ ቄሴዛኮ ሺቆ። ");
INSERT INTO gmve_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ቄሴዚ ቃሴካ ፓጮ፤ ማዱንꬃይ ካሴፔ ኣኪኮ ኢታ ጋልባ ሃርጌ ጊዲዳ ጊሻስ ዎጋን ዲዛ ማላ ኢዛዴይ ኢታ ጋልባ ሃርጋንቻ ጊዲዳይሳ ኤሪሶ። ");
INSERT INTO gmve_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«ኦኒካ ኢዛዴ ኣሾዛ ጋልባ ቦላ ኬዚዛ ሃርጌይ ኦይኪኮ ሄሳዴ ቄሴኮ ኤሄቶ። ");
INSERT INTO gmve_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ቄሴዚካ ሄ ኢዛዴ ቦላይ ኡዛዚዛኮ ሎኤꬂ ጼሊዲ ኢዛዴ ኣሳቴꬃ ቦላ ዲዛ ኢስኬታ ቦꬂዛ ኪጻ ጊዲኮ ኪጻዚ ኡዛዚዲኔ ሄ ኡዛሳይ ዲዛሶን ዲዛ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ሄሲ ኢታ ቦላ ጋልባ ሃርጌ ጊዲዛ ጊሻስ ቄሴይ ሄ ሃርጋንቻዚ ቱና ጊዲዳይሳ ኢዛስ ዮቶ፤ ኢዚ ቱኒዳይሲ ኤሬቲዳ ጊሻስ ሄሳ ማላ ኣሲ ካሬይ ጎርዴቲን ኬꬃን ጋምኣናስ ቤሴና። ");
INSERT INTO gmve_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","ሄ ጋልባ ሃርጌዚ ኢዛዴ ቦላ ቶሆ ጹጉንꬃፌ ቢዲ ሁኤ ኢስኬ ጋካናስ ኡባ ጋኪኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ቄሴዚ ቃሴካ ፓጪ ጼሊዲ ሃርጌዚ ኢዛዴስ ኩሜꬃ ኣሳቴꬃ ጋኪ ማይኢዳ ጊዲኮ ቄሴዚ ሄሳዴ ዎጋ ማላ ጌሽ ጊዲዳይሳ ኤሪሶ፤ ጋሶይካ ኢዛ ቦላይ ኩሜꬅ ላሜቲዲ ቦꬅ ጊዲዳ ጊሻስ ኢዛዴይ ጌሻ። ");
INSERT INTO gmve_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","ጊዶ ኣቲን ማዱንꬃይ ዛሪ ኡዛዚዲ ዞኦ ኣሾ ጊዶፌ ቤሲኮ ሄሳዴይ ቱና ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ቄሴይ ቃሴካ ዛሪ ፓጪ ጼሊሺን ማዱንꬃይ ኡዛዚሺን ዞኦ ኣሾ ቤይኮ ኢዛዴይ ቱና፤ ኢዚ ቱና ጊዲዳይሳ ኢዛስ ኤሪሶ፤ ጋሶይካ ሃርጌዚ ሃራ ኣሳ ቦላ ኣꬊዛ ሃርጌ ጊዲዳ ጊሻስ ሄሳዴይ ቱና። ");
INSERT INTO gmve_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","ማዱንꬃይ ፓጺዲ ቦቲዛዝ ጊዲኮ ሄሳዴይ ቃሴካ ቄሴኮ ቦ። ");
INSERT INTO gmve_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ቄሴይካ ፓጪ ጼሊዲ ማዱንꬃይ ቦጺ ቤሲኮ ቄሴይካ ሄሳዴይ ጌሽ ጊዲዳይሳ ኢዛስ ዮቶ፤ ኢዛዴይካ ጌሽ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","«ኢሳዴይ ካሴ ኪጻይ ኢዛ ቦላ ኬዚዲ ፓጺኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ቃሴ ጋምኢሼ ካሴ ማዱንꬃይ ዲዛሶን ቦꬃ ኪጻይ ዎይኮ ዞኦ ኢሊዋይ ኬዚኮ ኢዛዴይ ቄሴኮ ቦ። ");
INSERT INTO gmve_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ቄሴዚ ሎኤꬂ ጼሊዲ ማዱንꬃይ ዱጌ ኣሾ ጊዶ ጌሊ ቤቲኮ ኢዛ ሄራን ዲዛ ኢስኬይ ቦጺ ቤሲኮ ሄሳዴይ ቱና ጊዲዳይሳ ኢዛ ኤሪሶ፤ ጋሶይካ ሄሲ ኪጻ ኦይኪዳይሲ ባ ባጋራ ኢታ ጋልባ ሃርጌ። ");
INSERT INTO gmve_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ጊዲኮካ ቄሴዚ ፓጪ ጼሊን ጋልባ ቦላ ዲዛ ኢስኬይ ቦቶንታ ኣጊኮኔ ሃንኮ ኣሳቴꬃ ጋልባፌ ኦላቲ ቤሶንታዝ ጊዲኮ ቃላሜ ዱማቴꬃ ጊሻስ ቄሴይ ሄሳዴይ ላፑን ጋላስ ጋካናስ ካሬይ ጎርዴቲን ኬꬃን ጋምኣና ማላ ኦꬆ። ");
INSERT INTO gmve_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ማዱንꬃይ ዲዛሶይ ካሴፔ ኣኪ ኣኪ ቢኮ ሄሳዴይ ኣሳ ቦላ ኣꬊዛ ኢታ ሃርጌን ኦይኬቲዳ ጊሻስ ኢዚ ቱና ጊዲዳይሳ ኢዛስ ቄሴዚ ዮቶ። ");
INSERT INTO gmve_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ጊዶ ኣቲን ኢሊዋዚ ካሴፔ ኣኪ ኣኪ ቦንታ ኣጊዲ ካሴ ባ ዲዛሶን ዲኮ ካሴ ኪጻይ ፓጺዳሶ ኣቲን ሃርጌ ዴና፤ ቄሴዚ ኢዚ ጌሽ ጊዲዳይሳ ኤሪሶ። ");
INSERT INTO gmve_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","ካሴ ኢዛ ታማይ ሚዳዴይ ዲኮ ሄ ኢዚ ታማን ሜቴቲዳሶይ ቦꬃ ኢሊዋ ዎይኮ ዞኣናዳን ሃኒ ቤሲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ቄሴዚ ኢዛ ፓጪ ጼሎ፤ ሄ ኢሊዋይ ዲዛሶን ሞኪዳ ኢስኬይ ቦꬅ ጊዲኮኔ ሃንኮ ኢዛ ኣቻን ዲዛ ጋልባፌ ዱጌ ኣሾን ጌሊኮ ሄሲ ታማን ጹጌቴꬃ ጋሶን ኣሳፔ ኣሳን ኣꬊዛ ኢታ ጋልባ ሃርጌ፤ ሄሳ ጊሻስ ቄሴይ ሄሳዴይ ቱኒዳይሳ ኢዛስ ኤሪሶ። ");
INSERT INTO gmve_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ኢዛ ቦላ ሞኪዳ ኢስኬዚ ቦꬃ ኢስኬን ላሜቶንታ ኣጊኮኔ ማዱንꬃዚ ዱጌ ኣሾን ጌሎንታ ኣጊዲ ሾሎቲ ሾሎቲ ቢኮ ቄሴዚ ሎኤꬂ ቤኢዲ ላፑን ጋላስ ጋካናስ ካሬ ኢዛ ቦላ ጎርዲ ዎꬆ። ");
INSERT INTO gmve_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ቃሴካ ላፑንꬃ ጋላስ ፓጪ ጼሎ፤ ኢዚ ካሴፔ ኣኪ ኣኪ ቢኮ ሄሲ ኢታ ጋልባ ሃርጌ፤ ሄሳ ጊሻስ ሄሳዴይ ቱና ጊዲዳይሳ ቄሴዚ ኢዛ ኤሪሶ። ");
INSERT INTO gmve_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ማዱንꬃይ ዲዛሶይ ቃሴ ካሴፔ ኣይኮካ ኣኮንታ ኣጊኮኔ ፓጺ ፓጺ ቢኮ ኢዚ ታማይ ሚዳሶ ኣቲን ሃራ ጊዴና፤ ሄሳ ጊሻስ ሄሳዴይ ዎጋ ማላ ጌሽ ጊዲዳይሳ ቄሴይ ኢዛ ኤሪሶ። ");
INSERT INTO gmve_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«ኣዴ ጊዲን ማጫስ ጊዲን ሁኤ ቦላ ዎይኮ ሻጋላ ቦላ ማዱንꬂ ዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ቄሴዚ ሄ ማዱንꬃ ፓጪ ጼሊሺን ማዱንꬃይ ዱጌ ኣሾን ጌሊኮ ኢዛ ቦላ ዲዛ ኢስኬይ ጋላልኦ ማላ ጊዲዲ ሌኢ ቤሲኮ ሄሲ ሁኤ ዎይኮ ቡቻ ቃጪሲ ጎኢሲዛ ዳሮ ኢታ ጋልባ ሃርጌ ጊዲዳ ጊሻስ ሄሳዴይ ቱና ጊዲዳይሳ ቄሴዚ ኢዛ ኤሪሶ። ");
INSERT INTO gmve_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ቃሴካ ቄሴይ ፓጪ ጼሊሺን ማዱንꬃይ ሃንኮ ኢዛ ኣቻን ዲዛ ጋልባፌ ዱጌ ኦላቲ ቤሶንታ ኣጊኮ፥ ኢዛ ቦላ ዲዛ ኢስኬይ ሎኦ ጊዶንታ ኣጊኮ ሄሳዴ ላፑን ጋላስ ጋካናስ ካሬ ጎርዲዲ ኬꬃን ዎꬆ። ");
INSERT INTO gmve_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ላፑንꬆ ጋላስ ቃሴካ ቄሴዚ ኢዛዴ ፓጪ ጼሎ፤ ካሴፔ ኣኪ ኣኪ ቦንታ ኣጊኮ ቆሩማ ሚሳቲዛ ኢስኬይካ ባይንዳ ኣጊኮኔ ማዱንꬃዚ ዱጌ ኣሾን ጌሎንታ ኣጊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ሄሳዴይ ማዱንꬃ ዩዪ ኣꬊ ዲዛ ኢስኬዛ ኡባ ሜዴቶ፤ ቄሴይካ ኢዛ ቃሴካ ላፑን ጋላስ ጋካናስ ካሬይ ኢዛ ቦላ ጎርዴቲን ጋምኣና ማላ ኦꬆ። ");
INSERT INTO gmve_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ላፑንꬆ ጋላስ ቄሴዚ ቃሴካ ሄ ማዱንꬃ ፓጪ ጼሎ፤ ማዱንꬃይ ካሴፔ ኣኪ ኣኪ ቦንታ ኣጊኮኔ ኣሾ ሚ ኦላሶንታ ኣጊኮ ሄሳዴይ ዲዛ ዎጋ ማላ ጊዲዳይሳ ኢዛ ኤሪሶ፤ ኢዛዴይካ ባ ማይኦ ሜጪዲ ጌሽ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ጊዶ ኣቲን ኢዚ ጌሽ ጊዲዳይሳ ቆንጪሲዳፔ ጉዬ ማዱንꬃይ ካሴፔ ኣኪ ኣኪ ቢኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ቄሴዚ ቃሴካ ፓጪ ጼሎ፤ ማዱንꬃይ ኣዳካ ካሴፔ ኣኪዳ ጊዲኮ ኢስኬይ ቆሩሚኮ ዎይኮ ቆሩሞንታ ኣጊኮካ ኢዛዴይ ቱና። ");
INSERT INTO gmve_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ጊዶ ኣቲን ቄሴዚ ቤዪሺን ማዱንꬃይ ካሴፔ ኣኪ ኣኪ ቦንታ ኣጊኮኔ ሎኦ ኢስኬይ ሞኪኮ ማዱንꬃይ ፓጺዳይሳኔ ኢዛዴይ ጌዪዳይሳ ቄሴዚ ኢዛ ኤሪሶ። ");
INSERT INTO gmve_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«ማጫስ ጊዲን ዎይኮ ኣዴ ጊዲን ኢሳዴ ቦላ ኢሊዋይ ኬዚኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ቄሴዚ ሄ ኢሊዋይ ዲዛዴዛ ፓጪ ጼሎ፤ ኢሊዋይ ዲዛሶይ ጮ ሜላ ፑቃ ቦꬅ ጊዶንታ ኣጊኮ ኢዛ ዳሮ ቆሆንታ ጮ ሜላ ቦላራ ጋልባ ቦላ ኬዚዳ ሺምፔ ጊዲዳ ጊሻስ ሄሳዴይ ዲዛ ዎጋ ማላ ኢዚ ጌሻ። ");
INSERT INTO gmve_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","«ኢሳዴስ ሁኤ ኢስኬይ ጉዬ ባጋራ ዎይኮ ሲንꬃ ባጋራ ቦኣቲኮ ሄሳዴ ቦኣይ ኢዛ ቱኒሴና። ");
INSERT INTO gmve_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","ጊዶ ኣቲን ኢዛ ቦኣ ቦላ ዎይኮ ሊጴ ቦላ ዞኢ ቤሲዛ ቦꬃ ማዱንꬂ ቤቲኮ ሄሲ ኢታ ሃራ ኣሳ ቦላ ኣꬊዛ ጋልባ ሃርጌ። ");
INSERT INTO gmve_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ቄሴዚ ሄሳዴ ፓጪ ጼሊሺን ሄሲ ሃራ ኣሳ ቦላ ኣꬊዛ ጋልባ ሃርጌ ሚሳቲዲ ዞኢ ቤሲዛ ቦꬃ ማዱንꬅ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ሄሳዴይ ሃራ ኣሳ ቦላ ኣꬊዛ ኢታ ሃርጌን ኦይኬቲዳ ጊሻስ ኢዛዴይ ቱና ጊዲዳይሳ ቄሴዚ ኢዛዴ ኤሪሶ። ");
INSERT INTO gmve_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","ሄሳ ማላ ሃርጌይ ኢዛ ቦላ ዲዛዴይ ዳኬꬃ ማይኦ ማይኦ፤ ባ ሁኤካ ፒጾፖ፤ ባ ዶና ካሚዲ፥ ‹ታኒ ቱናኮ! ታኒ ቱናኮ!› ጊሼ ዋሶ። ");
INSERT INTO gmve_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ሄ ሃርጌዚ ኢዛ ቦላ ዲዛ ዎዴ ኡባን ኢዚ ቱና፤ ሄሳ ጊሻስ ኢዚ ኣሲ ዲዛሶፔ ጌዴ ሃራሶ ሃኪዲ ባርካ ዴኦ። ");
INSERT INTO gmve_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","48","«ኣሳ ቦላ ሃርጌ ጋꬂዛ ቡቃይ ዶርሳ ኢስኬፌ ኦሴቲዳ ማይኦ ቦላ ዎይኮ ኣይ ቆሞ ማይኦ ቦላካ ሃርፓን ዳዴቲዳ ማይኦ ቦላ ዎይኮ ኩሼን ኦሴቲዳ ጋልባ ማይኦ ዎይኮ ጋልባፌ ኦሴቲዳ ማይኦ ቦላ ቤቲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ሄ ሃርጌዛስ ማላይ ማታ ማላ ጪሊሊ ቤሲኮ ዎይኮ ዞኢ ቤሲኮ ሄሲ ኢሳፌ ኢሳን ኣꬊዛ ሃርጌ ጊዲዳ ጊሻስ ቄሴዚ ኢዛ ቤዮ። ");
INSERT INTO gmve_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ቄሴዚ ሄ ሃርጌዛ ሎኤꬂ ጼሊዲ ሄ ማይኦታ ኡባካ ላፑን ጋላስ ጋካናስ ኢሲ ኬꬃን ጌልꬂ ዱማ ዎꬆ። ");
INSERT INTO gmve_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ላፑንꬆ ጋላስ ቃሴካ ፓጪ ጼሊሺን ኣሳ ቦላ ሃርጌ ጋꬂዛ ቡቃዚ ካሴይሳፌ ዳሪ ቤቲኮ ሄሳ ማላ ማይኦዚ ቱና። ");
INSERT INTO gmve_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ሄሳ ማላ ማይኦ ቡቃይ ኣሳ ቦላ ሃርጌ ጋꬂዛ ጊሻስ ቄሴዚ ሺሺዲ ሄ ቡቃ ማይኦታ ታማን ጹጎ። ");
INSERT INTO gmve_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","54","«ቄሴዚ ዛሪ ፓጪ ጼሊሺን ቡቃዚ ካሴፔ ሃ ዳሮንታ ኣጊኮ ማይኦዛ ሃꬃን ሜጫና ማላ ኣዛዞ፤ ሄ ሜጬቲዳ ማይኦዛ ላፑን ጋላስ ጋካናስ ሻኪ ዎꬆ። ");
INSERT INTO gmve_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ሄሳፌ ቃሴካ ጼሊሺን ካሴፔ ቡቃይ ጉጄቶንታ ኣጊኮኔ ቡቃዛ ሜꬋይ ካሴፔ ላሜቶንታ ኣጊኮ ሃኢካ ኢዚ ቱና፤ ካሴይሳ ቦላ ጊዶራ፥ ካሬራ ቡቃዚ ጉጄቲኮ ሄ ማይኦዚ ታማን ጹጌቶ። ");
INSERT INTO gmve_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ጊዶ ኣቲን ማይኦዛ ሜጪ ሲሚዳፔ ቄሴዚ ቃሴካ ዛሪ ቤኢዛ ዎዴ ቡቃዚ ካሴፔ ዱጌ ጉጺኮ ቡቃዚ ዲዛሶዮ ጻላ ኢታ ማይኦፌ ጊዲን ዎይኮ ኣፋላ ጊዲን ዳኪ ኬሶ። ");
INSERT INTO gmve_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ቡቃዚ ቃሴካ ቤቲኮ ሄሲ ጌዴ ዳሪ ዳሪ ቢዛ ጊሻስ ሄ ማይኦዚ ጹጌቶ። ");
INSERT INTO gmve_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","ኣይ ማይኦኔ ጋልባፌ ኦሴቲዳ ኣይ ሚሽ ሜጪሺን ቡቃዚ ኢዛፔ ꬋይኮ ቃሴካ ሜጮ፤ ሄሳፌ ጉዬ ዎጋይ ጊዛ ማላ ማይኦዚ ጌሽ ጊዳና።» ");
INSERT INTO gmve_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ሃይሲ ዶርሳ ኢስኬፌ ኦሴቲዳ ማይኦ ቦላ ዎይኮ ኣይ ቆሞ ማይኦ ቦላ ዎይኮ ሃርፓን ዳዴቲዳ ዎይኮ ኩሼን ኦሴቲዳ ማይኦ ቦላ፥ ጋልባ ዎይኮ ጋልባፌ ኦሴቲዳ ማይኦ ቦላ ኣሳ ቦላ ሃርጌ ጋꬂዛ ቡቃይ ቤቲኮ ሄ ማይኦዚ ጌሽ ዎይኮ ቱና ጊዲዳይሳ ኤሪሲዛ ዎጋይ ሃይሳፌ ቦላን ዲዛይሳ። ");
INSERT INTO gmve_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«ኢሳዴይ ኣሳቴꬃ ቦላ ዲዛ ኢታ ጋልባ ሃርጌፌ ፓጺዳፔ ጉዬ ጌሾ ዎጋይ ሃይሳፌ ካሊዛይሳ፤ ኢዚ ጌሽ ጊዲዳይሳ ኢዛዴስ ዮቴቲዛ ጋላስ ሄሳዴይ ቄሴኮ ባና ማላ ኢዛስ ዮቴቶ። ");
INSERT INTO gmve_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ሄ ኢዛስ ዮቴቲዳ ቄሴዚ ኣሲ ዲዛሶፔ ጌዴ ሃራሶ ኬሲዲ ባኮ ዪዳይሳ ሎኤꬂ ጼሎ፤ ኢዛዴይ ሃርጌዛፔ ፓጺዳ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ቄሴዚ ፓጻ ዲዛ ናምኡ ጌሻ ካፎታኔ ዚጋ ሚꬅ፥ ዞኦ ጺላታ፥ ሂሶጴ ሚꬃ ሃይꬅ ጉጂ ኤኪ ያና ማላ ኣዛዞ። ");
INSERT INTO gmve_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","ሄሳፌ ጉዬ ቄሴዚ ካፎታፔ ኢሳ ፑልቶ ሃꬂ ኢዛን ዲዛ ጉቃ ኬሬ ቦላ ሹኬታና ማላ ኣዛዞ። ");
INSERT INTO gmve_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","ሃንኮ ፓጻ ዲዛ ካፎዛ ኤፊዲ ዚጋ ሚꬃራ፥ ዞኦ ጺላታራኔ ሂሶጴ ሚꬃ ቦንጮራ ኢሲፌ ጋꬂ ካሴ ሹኬቲዳ ካፎዛ ሱꬃን ጌልꬂ ኬሶ። ");
INSERT INTO gmve_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ሱꬃካ ኣሳቴꬃ ቦላ ዲዛ ጋልባ ሃርጌፌ ፓጺዛዴ ቦላ ላፑንቶ ዉጾ፤ ሄሳፌ ጉዬ ኢዚ ጌሽ ጊዲዳይሳ ኢዛ ኤሪሶ፤ ሃንኮ ፓጻ ዲዛ ካፎዛካ ጌዴ ሃራሶ ኬሲዲ ዴምባን ፒራꬋና ማላ ዬዶ። ");
INSERT INTO gmve_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","«ኢታ ጋልባ ሃርጌፌ ፓጺዳዴይ ባ ማይኦ ሜጮ፤ ባ ቦላ ዲዛ ኢስኬ ኡባ ሜዴቶ፤ ባ ቦላካ ሜጬቶ፤ ዎጋይ ጊዛ ማላ ኢዚ ጌሽ ጊዳና፤ ሄሳፌ ጉዬ ኣሲ ዲዛሶ ጌላናስ ዳንዳዬስ፤ ጊዶ ኣቲን ላፑን ጋላስ ጋካናስ ኢዚ ባ ዱንካናፔ ካሬን ዴኦ። ");
INSERT INTO gmve_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ላፑንꬆ ጋላስ ቃሴካ ባ ሁኤ፥ ባ ቡቺኔ ባ ዴሞ፥ ሃራ ኣዋንካ ባ ኣሳቴꬃ ቦላ ዲዛ ኢስኬ ኡባ ሜዴቶ፤ ባ ማይኦ ሃꬃን ሜጮኔ ባ ቦላካ ሜጬቶ፤ ሄሳፌ ጉዬ ኢዚ ጌሽ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","«ኦስፑንꬃ ጋላስ ኢሲ ዎሶይካ ኢስታ ቦላ ባይንዳ ናምኡ ዶርሳ ላቃታኔ ኢሲ ላይꬃ ኡዞ ኤሆ፤ ካꬃ ያርሾ ጊሻስ ዎጋራ ሚꬃ ዛይቴን ሙኑቄቲዳ ሄꬑ ኪሎ ꬊሌኔ ኢሲ ሊቲሮ ዛይቴስ ሄꬓንꬆ ኩሼ ዎጋራ ሚꬃ ዛይቴ ኤሆ። ");
INSERT INTO gmve_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","ቄሴዚካ ኣዴዚ ኢዚ ኤሂዳ ኡባራ ኢሲ ቦላ ጋይቶቴꬃ ዱንካኔዛ ፔንጌን ጎዳ ሲንꬅ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","«ሄሳፌ ጉዬ ናምኡ ቄሪ ꬋርሾታፔ ኢሳ ኤኪዲ ኢሲ ሊቲሮስ ሄꬓንꬆ ኩሼ ጊዲዛ ዎጋራ ዛይቴራ ኢሲፌ ጋꬂ ኤኪዲ ቆሆ ጊሻስ ሺቂዛ ያርሾ ሂስቲ ሺሾ፤ ቄሴዚ ሄ ያርሾዛካ ያኔ ሃ ቃሴꬂዛ ያርሾ ሂስቲ ጎዳ ሲንꬃን ቃሴꬂ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ላቃዛካ ናጋራ ያርሾሲኔ ጹጌቲዛ ያርሾስ ሹኪዛ ጌሻሶሆን ሹኮ፤ ጋሶይካ ቆሆ ጊሻስ ያርሾይ ናጋራ ዉርሳናስ ሺቂዛ ያርሾ ማላ ቄሴዛስ ጊሻ ጊዳና፤ ኢዚካ ኬሂ ዱማ። ");
INSERT INTO gmve_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","ቄሴዚ ቆሆ ያርሾስ ሺቂዛ ሱꬃፌ ጉꬃራ ኤኪዲ ሄ ጌይዛዴስ ኡሻቻ ሃይꬃ ጼራ ኢዛስ ኡሻቻ ኩሼ ማንꬃ ቢራꬌኔ ኡሻቻ ቶሆ ማንꬃ ቢራꬌ ቲዮ። ");
INSERT INTO gmve_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ቄሴዚ ዎጋራ ሚꬃ ዛይቴዛፔ ጉꬃራ ኤኪዲ ባ ሃዲርሳ ኩሼ ቃኣን ቲጎ። ");
INSERT INTO gmve_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ባ ኡሻቻ ኩሼ ጼራን ጉꬃራ ኤኪዲ ጾሳ ሲንꬃን ላፑንቶ ዉጾ። ");
INSERT INTO gmve_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ባ ኩሼ ቃኣን ኣቲዳ ዛይቴዛፔ ጉꬃራ ኤኪዲ ጌይዛዴስ ኡሻቻ ሃይꬃ ጼራ፥ ኡሻቻ ኩሼ ማንꬃ ቢራꬌኔ ኡሻቻ ቶሆ ማንꬃ ቢራꬌ ቲዮ። ");
INSERT INTO gmve_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","ባ ኩሼ ቃኣን ኣቲዳ ዛይቴዛካ ጌይዛዴ ሁኤን ጉሶ፤ ቄሴይ ኢዛዴ ናጋራ ጌሾ። ");
INSERT INTO gmve_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","«ሄሳፌ ጉዬ ቄሴዚ ባ ቱናቴꬃፌ ጌይዛዴ ናጋራ ዉርሳናስ ሺቂዳ ሜሄ ሹኮ። ");
INSERT INTO gmve_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ቃሴካ ቄሴዚ ሄ ጹጌቲዛ ያርሾዛ ካꬃ ያርሾዛራ ኢሲፌ ያርሾ ያርሺዛሶዛ ቦላ ዎꬂዲ ጹጎ፤ ሄሳ ማላ ኦሶን ኢዛዴ ናጋራፔ ማሪሴስ፤ ኢዛዴይካ ጌሽ ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«ኢዛዴይ ሄሳ ኡባ ኤሃናስ ዳንዳዮንታ ማንቆ ጊዲኮ ጎዳ ሲንꬃን ያኔ ሃ ቃሴꬂዲ ባ ናጋራ ዉርሳናስ ኢሲ ꬋርሾ ላቃ ኤሂዲ ቆሆ ያርሾ ጊሻስ ሺሾ፤ ቃሴ ካꬃ ያርሾዛስካ ዎጋራ ሚꬃ ዛይቴን ሙኑቄቲዳ ኢሲ ኪሎ ሊቆ ꬊሌ ካꬃ ያርሾስ ኤሆ፤ ሄሳꬆካ ኢሲ ሊቲሮስ ሄꬓንꬆ ኩሼ ጊዲዛ ዛይቴ ኤሆ። ");
INSERT INTO gmve_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ቃሴካ ኢዛ ዎልቃይ ዳንዳይዳ ማላ ናምኡ ሃራጴታ ዎይኮ ናምኡ ዋኖሴታፔ ኢሳ ናጋራ ጊሻስ ያርሾስ፥ ናምኣንꬆዛ ቃሴ ጹጌቲዛ ያርሾስ ኤሆ። ");
INSERT INTO gmve_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","«ጌሾ ዎጋይ ፖሌቲዛ ኦስፑንꬃ ጋላስ ሄይታ ኡባ ኤሂዲ ጋይቶቴꬃ ዱንካኔ ፔንጌን ጎዳ ሲንꬃን ቄሴስ ኢሞ። ");
INSERT INTO gmve_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ቄሴዚካ ቆሆ ያርሾስ ሺቂዛ ዶርሳ ላቃኔ ዎጋራ ሚꬃ ዛይቴዛ ኤኪዲ ያኔ ሃ ቃሴꬂዛ ያርሾ ኦꬂ ጎዳ ሲንꬃን ያርሾ። ");
INSERT INTO gmve_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ቆሆ ጊሻስ ሺቂዛ ያርሾስ ሺቂዳ ዶርሳ ላቃ ሹኮ፤ ሱꬃፌ ጉꬃራ ኤኪዲ ጌይዛዴስ ኡሻቻ ኩሼ ማንꬃ ቢራꬌ፥ ኡሻቻ ቶሆ ማንꬃ ቢራꬌኔ ኡሻቻ ሃይꬃ ጼራ ቲዮ። ");
INSERT INTO gmve_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ቄሴዚ ዛይቴዛፔ ጉꬃራ ባ ሃዲርሳ ኩሼ ቃኣን ቲጎ። ");
INSERT INTO gmve_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ባ ኡሻቻ ኩሼ ቢራꬌን ጉꬃራ ቦቺዲ ጾሳ ሲንꬃን ላፑንቶ ዉጾ። ");
INSERT INTO gmve_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ባ ኩሼ ቃኣን ቲጊዳ ዛይቴፔ ጉꬃራ ኤኪዲ ቆሆ ያርሾ ሱꬃን ቦቺዳሶን ሄሲካ ጌይዛዴስ ኡሻቻ ሃይꬃ ጼራ፥ ኡሻቻ ኩሼ ማንꬃ ቢራꬌ ጼራ፥ ኡሻቻ ቶሆ ማንꬃ ቢራꬌ ጼራ ቦሺሶ። ");
INSERT INTO gmve_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","ቄሴዚ ባ ኩሼን ኣቲዳ ዛይቴዛ ኣዴዛ ሁኤን ጉሶ፤ ሄሳꬆ ኦꬂዲ ጌሾ ዎጋ ጎዳ ሲንꬃን ፖሎ። ");
INSERT INTO gmve_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ሄሳፌ ጉዬ ሃራጴታ ዎይኮ ዋኖሴታ ጌይዛዴ ዎልቃይ ጋꬂዳ ኬና ቄሴዚ ያርሾ። ");
INSERT INTO gmve_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ሄይታንታፌ ኢሳ ናጋራስ ሺቂዛ ያርሾስ ናምኣንꬆዛ ቃሴ ጹጌቲዛ ያርሾስ ካꬃ ያርሾራ ጋꬂ ሺሾ፤ ቄሴዚ ኡባካ ሃይሳ ማላን ጌይዛዴ ናጋራፔ ጌሾ። ");
INSERT INTO gmve_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ኣሳፔ ጌዴ ሃራ ኣሳን ኣꬊዛ ኢታ ጋልባ ሃርጌፌ ጌያናስ ኮሺዛ ዎጋ ፖላናስ ዳንዳዮንታ ማንቆ ኣሳስ ዲዛ ዎጋይ ሃይሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","ጎዳይ ሙሴሲኔ ኣሮኔስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«ታኒ ኢንቴስ ኢሚዛ ካናኔ ቢታ ኢንቴ ጌሊዛ ዎዴ ኢሲ ኬꬃን ታኒ ቡቃ ዬጊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ሄ ኬꬃዴይ ቢዲ ቄሴዛ፥ ‹ታሶን ኣይ ኢታ ሃርጌይ ዲዛኮ› ጊዲ ዮቶ። ");
INSERT INTO gmve_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","ሶን ዲዛ ሚሽ ኡባይ ቱና ጌቴቶንታ ማላ ቄሴዚ ሄ ኢታ ሃርጋ ቤያናስ ጌላናፔ ካሴቲዲ ሶን ዲዛ ሚሽ ኡባ ካሬ ኬሳና ማላ ኣዛዞ፤ ሄሳፌ ጉዬ ቄሴዚ ጼላናስ ኬꬃ ጊዶ ጌሎ። ");
INSERT INTO gmve_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ሃርጌዛ ሎኤꬂ ፓጪ ጼሊዛ ዎዴ ኬꬃ ሉኪ ሉኪ ሚዛ ሃርጌዛስ ሜꬋይ ማታ ማላ ጪሊላ ዎይኮ ዞኦ ዎይኮ ፑንጫርካ ሚሳቲ ቤቲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ቄሴዚ ሄ ኬꬃፌ ኬዚዲ ኬꬃይ ላፑን ጋላስ ጋካናስ ጎርዴታና ማላ ኦꬆ። ");
INSERT INTO gmve_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ቄሴዚ ላፑንꬃ ጋላስ ሲሚዲ ቃሴካ ጼሎ፤ ሃርጌዚ ካሴፔ ጌዴ ዳሪ ዳሪ ቢኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ሃርጌይ ኢስታ ቦላ ቤቲዳ ሹቻቲ ኬꬃፌ ዎጬቲ ኬዚዲ ካታማፔ ጌዴ ካሬን ዲዛ ቱና ሚሽ ዬጌቲዛሶን ዬጌታና ማላ ኣዛዞ። ");
INSERT INTO gmve_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ሄሳፌ ጉዬ ኬꬃስ ሶ ባጋ ጊሪዲ ሄ ጊሬꬃዛ ካታማፔ ካሬ ባጋራ ቱና ሚሽ ዬጊዛሶን ዬጋና ማላ ኣዛዞ። ");
INSERT INTO gmve_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ሄሳፌ ጉዬ ካሴ ሹቻታ ሶሆን ሃራ ኦራꬃ ሹቺ ጌሊን ሄ ኬꬃን ሃራ ኦራꬃ ኡርቃይ ሜሼቶ። ");
INSERT INTO gmve_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","«ሹቻቲ ዲጌቲን ቃሴካ ኡርቃካ ቆቆፊዲ ሃራ ኡርቃን ሜሺ ኦራꬂዳፔ ጉዬ ሄ ሃርጌዛ ማላታይ ቃሴካ ሲሚ ቤቲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ቄሴዚ ሲሚ ቢዲ ቤዮ፤ ሃርጌዚ ካሴፔ ጌዴ ኣኪ ኣኪ ቢዛ ማላ ጊዲኮ ሄ ሃርጌይ ኢሳፌ ኢሳን ኣꬊዛ ኢታ ሃርጌ ጊዲዳ ጊሻስ ሄ ኬꬃይ ቱና። ");
INSERT INTO gmve_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ሄሳ ጊሻስ ሄ ኬꬃይ ላሌታናስ ቤሴስ፤ ሄ ኬꬃ ሹቻይ፥ ሚꬃይኔ ሚሺ፥ ኡርቃይ ዉሪካ ካታማፔ ጌዴ ካሬ ቱና ሚሺ ዬጌቲዛሶን ዬጌቶ። ");
INSERT INTO gmve_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","ጎርዴቲዳፔ ጉዬ ሄ ኬꬃን ጌሊዳ ኣሲ ዉሪካ ኦማርስ ጋካናስ ቱና ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ሄ ኬꬃን ኢቺዳዴይ ዎይኮ ካꬅ ሚዳዴይ ባ ማይኦ ሜጮ። ");
INSERT INTO gmve_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","«ኬꬃይ ቃሴካ ኦራጺዲ ሜሼቲዳፔ ጉዬ ቄሴዚ ዪዲ ጼሊሺን ሃርጌዚ ካሴፔ ኣኪ ኣኪ ቦንታ ኣጊኮ፥ ሃርጌዛ ማላታይ ꬋይዳ ጊሻስ፥ ሄ ኬꬃይ ጌሽ ጊዲዳ ጊሻስ ቄሴዚ ኬꬃ ኣዋ ኤሪሶ። ");
INSERT INTO gmve_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ሄ ኬꬃ ጌሻናስ ናምኡ ካፎ፥ ሊባኖሴ ዚጋ፥ ዞኦ ጺላታኔ ሂሶጴ ጌቴቲዛ ሚꬃ ሃይꬅ ኤሆ። ");
INSERT INTO gmve_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ካፎታፔ ኢሳ ፑልቶ ሃꬂ ኢዛን ዲዛ ጉቃ ኬሬን ሹኮ፤ ");
INSERT INTO gmve_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ሄሳፌ ጉዬ ዚጋ ሚꬅ፥ ሂሶጴ ሚꬃ ሃይꬅ፥ ዞኦ ጺላታኔ ፓጻ ዲዛ ካፎዛ ኢሲፌ ጋꬂ ኤኪዲ ጉቃ ኬሬን ዲዛ ፑልቶ ሃꬃኒኔ ሃንኮ ሹኬቲዳ ካፎዛ ሱꬃን ጌልꬂ ኬሲዲ ኬꬃዛ ላፑንቶ ኣራጮ። ");
INSERT INTO gmve_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ቄሴዚ ሄሳꬆ ሂስቲዲ ሄ ኬꬃ ካፎዛ ሱꬃን፥ ፑልቶ ሃꬃን፥ ፓጻ ዲዛ ካፎን፥ ዚጋ ሚꬃን፥ ሂሶጴ ሚꬃ ሃይꬃኒኔ ዞኦ ጺላታን ጌሾ። ");
INSERT INTO gmve_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ሄሳፌ ጉዬ ፓጻ ዲዛ ካፎዛ ኢዚ ፒራꬊ ባና ማላ ጌዴ ዴምባ ኬሲ ዬዶ፤ ሄሳꬆ ኦꬂዲ ኬꬃ ጌሺዛ ዎጋ ፖሊኮ ኬꬃይካ ጌሽ ጊዴስ።» ");
INSERT INTO gmve_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","ሃይሲ ሃ ዎጋዚ ኢሳፌ ኢሳን ኣꬊዛ ጋልባ ቦላ ኬዚዛ ኣይ ሃርጌስ፥ ቃቻ ሃርጌስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ማይኦ ቦላኔ ኬꬃ ቦላ ኢሳፌ ኢሳን ኣꬊ ኣꬊ ዪዛ ሃርጌስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ኪጻ ሃርጌስ፥ ባꬊንቴሲኔ ኢሊዋ ሃርጌስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ሃይሲ ኣይ ሚሺካ ቱና ዎይኮ ጌሽ ጊዲዳይሳ ሻኪ ኤሪሳናሲኔ ኢሳፌ ኢሳን ኣꬊዛ ኢታ ሃርጌ ዎይኮ ቡቃ ጌሻናስ ዲዛ ዎጋ። ");
INSERT INTO gmve_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","ጎዳይ ሙሴሲኔ ኣሮኔስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«ኣይ ኣሳስካ ኢዛዴ ኣሳቴꬃፌ ጎጊዛ ሚሺ ዲኮ ሄሳዴይ ቱና ጋዳ ኢስራኤሌ ኣሳስ ዮታ። ");
INSERT INTO gmve_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ኣሳቴꬃፌ ጎጊ ኬዚዛይሲ ኣጎንታ ኢጺኮ ዎይኮ ጎጌꬃ ኣጊኮካ ሄሳዴይ ቱና። ");
INSERT INTO gmve_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","«ሄሳዴይ ኢዛ ቦላ ኢቺዳ ሂꬂ፥ ኡቲዳ ኣይ ሚሺካ ቱና ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","ሂጻዛ ቦቺዳ ኣይ ኣሲካ ባ ማይኦኔ ባ ቦላ ሃꬃን ሜጮ፤ ጊዲኮካ ሄሳዴይ ኦማርስ ጋካናስ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","ኣሳቴꬃፌ ቱኒሲዛ ሚሺ ጎጊ ኬዚዛ ኣሲ ኡቲዳሶሆን ኡቲዳ ኣይ ኣሲካ ባ ማይኦኔ ባ ቦላ ሃꬃን ሜጮ፤ ጊዲኮካ ሄሳዴይ ኦማርስ ጋካናስ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","«ኣሳቴꬃፌ ቱኒሲዛ ሚሺ ጎጊ ኬዚዛ ኣስ ቦቺዳይ ኣይ ኣሲካ ባ ማይኦኔ ባ ቦላ ሃꬃን ሜጮ፤ ጊዲኮካ ኦማርስ ጋካናስ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","«ኣሳቴꬃፌ ቱኒሲዛ ሚሺ ጎጊ ኬዚዛ ኣሲ ሃንኮ ፓጻ ዲዛ ኣሳ ቦላ ጩች ጩቲኮ ሄ ጩቻይ ኢዛ ቦቺዳ ኣሲ ባ ማይኦኔ ባ ቦላ ሃꬃን ሜጮ፤ ጊዲኮካ ሄሳዴይ ኦማርስ ጋካናስ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","«ኣሳቴꬃፌ ቱኒሲዛ ሚሺ ጎጊ ኬዚዛ ኣሲ ኡቲዳ ኮራ ኡባይ ቱና፤ ");
INSERT INTO gmve_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","ሄሳዴይ ኢዛ ቦላ ኡቲዳ ሚሽ ቦቺዳ ኣሲ ኡባይ ኦማርስ ጋካናስ ቱና፤ ጊዶ ኣቲን ሄ ቱኒዳ ኢሲ ሚሻታፔ ኢሳ ዴንꬂዳ ኣይ ኣሲካ ባ ማይኦኔ ባ ቦላ ሜጮ፤ ጊዲኮካ ኢዚ ኦማርስ ጋካናስ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","«ኣሳቴꬃፌ ቱኒሲዛ ሚሺ ጎጊ ኬዚዛ ኣሲ ባ ኩሼ ሜጬቶንታ ዲሼ ሃራ ቦቺኮ ሄ ቦሼቲዳዴይ ባ ማይኦኔ ባ ቦላ ሃꬃን ሜጮ፤ ጊዲኮካ ኦማርስ ጋካናስ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","ኣሳቴꬃፌ ቱኒሲዛ ሚሺ ጎጊ ኬዚዛ ኣስ ቦቺዳ ማና ሚሺ ሜቆ፤ ሚꬃፌ ኦሴቲዳ ሚሺ ዉሪካ ሃꬃን ሜጬቶ። ");
INSERT INTO gmve_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","«ኣሳቴꬃፌ ቱኒሲዛ ሚሺ ጎጊ ኬዚዛ ኣሲ ሄ ሃርጌዛፔ ፓጺኮ ካሴ ዲዛ ማላ ባ ፓጺዳይሳ ኤሪሳናስ ላፑን ጋላስ ጋካናስ ጋምኢሾ፤ ሄሳፌ ጉዬ ባ ማይኦ ሜጮ፤ ቃሴካ ባ ቦላ ጺሎ ጊዲዳ ፑልቶ ሃꬃን ሜጬቶ፤ ሂስቲዲ ጌሽ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ኦስፑንꬃ ጋላስ ናምኡ ሃራጴታ ዎይኮ ናምኡ ሃራጴ ጪዬታ ጋይቶቴꬃ ዱንካኔ ፔንጌ ኤፊዲ ጎዳ ሲንꬃን ቄሴዛስ ኢሞ። ");
INSERT INTO gmve_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ቄሴዚካ ሃራጴታ ኤኪዲ ኢሳ ናጋራ ዉርሶስ ያርሾ፥ ሃንኮይሳ ቃሴ ጹጌቲዛ ያርሾ ሂስቲ ያርሾ፤ ሄሳꬆ ሂስቲዲ ቄሴዚ ሄሳዴ ጎጊ ኬዚዛ ሚሻስ ጌይዛ ዎጋ ጎዳ ሲንꬃን ፖሎ። ");
INSERT INTO gmve_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","«ኣይ ኣሲካ ኢዛ ኣቱማቴꬃፌ ዜሬꬂ ጉኪኮ ኢዚ ባ ቦላ ሜጬቶ፤ ጊዲኮካ ኦማርስ ጋካናስ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ዜሬꬃይ ኢዛ ቦላ ጉኪዳ ኣይ ማይኦ ጊዲን ዎይኮ ጋልባ ጊዲኮ ሃꬃን ሜጬቶ፤ ጊዲኮካ ኦማርስ ጋካናስ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ኣዴይ ማጫሳራ ዚንኢ ዴንዲዳፔ ጉዬ ናምኣይካ ባንታ ቦላ ሃꬃን ሜጬቴቶ፤ ጊዲኮካ ኦማርስ ጋካናስ ቱና ጊዴቶ። ");
INSERT INTO gmve_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","«ማጫሳስ ኣጊናን ኣጊናን ዪዛ ዎጋይ ቤቲኮ ላፑን ጋላስ ጋካናስ ኢዛ ቱና ጊዱ፤ ኢዞ ቦቺዛ ኣይ ኣሲካ ኦማርስ ጋካናስ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","ማጫሳስ ኣጊናን ኣጊናን ዲዛ ዎጋይ ዪዛ ዎዴ ኢዛ ኡቲዛሶይኔ ኢቺዳሶይ ኡባይ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","ኢዛ ኢቺዳ ሂጻ ቦቺዳ ኣይ ኣሲካ ባ ማይኦኔ ባ ቦላ ሜጮ፤ ጊዲኮካ ኦማርስ ጋካናስ ቱና ጊዶ፤ ");
INSERT INTO gmve_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","ኢዛ ኡቲዳ ኣይ ሚሺካ ቦቺዳዴይ ባ ማይኦኔ ባ ቦላ ሜጮ፤ ጊዲኮካ ኦማርስ ጋካናስ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","ኢዛ ኢቺዳሶ ዎይኮ ኡቲዳሶ ሚሽ ቦቺዳ ኣይ ኣሲካ ኦማርስ ጋካናስ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","ኣጊናን ኣጊናን ቤቲዛ ማጫሳ ዎጋይ ዪዛ ዎዴ ኢዚራ ዚንኢዛ ኣይ ኣዴይካ ኢዚ ማላ ቱና ጊዲዛ ጊሻስ ላፑን ጋላስ ጋካናስ ቱና ጊዶ፤ ኢዚ ኢቺዛ ሂጻይ ቱና ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","ኢሲ ማጫሳስ ኣጊናን ኣጊናን ቤቲዛ ማጫሳ ዎጋይ ጉኪዛ ዎዴፔ ዳሮ ጋላስ ጉኪኮ ዎይኮ ኣጊናን ኣጊናን ቤቲዛ ዎዴዛፔ ቦላራ ኣጎንታ ሱꬂ ጉኪኮ ሄ ሱꬃይ ኤቃና ጋካናስ ኢዛ ቱና ጊዳዉስ። ");
INSERT INTO gmve_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ሄ ዎዴ ኢዛ ኢቺዳ ሂጻ ጊዲን ዎይኮ ኢዛ ኢዛ ቦላ ኡቲዳ ሚሺ ኣጊናን ኣጊናን ቤቲዛ ማጫሳ ዎጋይ ዲዛ ዎዴ ሃኒዛ ማላ ኡባ ዎዴ ቱና። ");
INSERT INTO gmve_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","ሄይታ ቦቺዳ ኣይ ኣሲካ ቱኒዳ ጊሻስ ባ ማይኦኔ ባ ቦላ ሜጮ፤ ጊዲኮካ ኦማርስ ጋካናስ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","«ኢዚፔ ጉኪዛ ሱꬃይ ኤቂኮ ሄ ሱꬃይ ኤቆ ጋላሳፌ ቢዲ ላፑን ጋላስ ጋካናስ ጋምኣዳ ሄሳፌ ጉዬ ዎጋይ ጊዛ ማላ ጌዩ። ");
INSERT INTO gmve_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ኦስፑንꬃ ጋላስ ናምኡ ሃራጴታ ዎይኮ ናምኡ ዋኖሴታ ጋይቶቴꬃ ዱንካኔ ፔንጌ ኤካ ያዳ ቄሴዛስ ኢሙ። ");
INSERT INTO gmve_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ቄሴዚካ ኢሳ ናጋራፔ ጌሺዛ ያርሾስ ናምኣንꬆዛካ ጹጌቲዛ ያርሾስ ሺሾ፤ ሂስቲዲ ሄ ማጫሳዮ ቱናቴꬃፌ ጌሺዛ ዎጋ ፖሎ። ");
INSERT INTO gmve_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","«ሄን ኢስታ ጊዶን ዲዛ ጋይቶቴꬃ ዱንካኔ ቱኒሲዲ ሃይቆንታ ማላ ኢስራኤሌ ናይታ ቱኒሲዛ ሚሻፌ ናጊቴ።» ");
INSERT INTO gmve_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","ቱኒሲዛ ሚሺ ኢዛ ኣሳቴꬃፌ ጎጊ ኬዚዛዴሲኔ ኢዛ ኣቱማቴꬃፌ ዜሬꬂ ጉኪዛዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ቃሴካ ኣጊናን ኣጊናን ቤቲዛ ማጫሳ ዎጋይ ቤቲዛ ማጫሳስ ዎይኮ ኣዴ ጊዲን ማጫ ጊዲን ቱኒሲዛ ሚሺ ኢስታ ኣሳቴꬃፌ ጎጊዛ ዎዴ ዎይኮ ጌዮንታ ማጫሳራ ዚንኢዛ ኣቱማሳስ ዎꬊዳ ዎጋይ ሄሳ። ");
INSERT INTO gmve_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ኣሮኔ ኣቱማ ና ናምኣቲ ቤሶንታ ታማ ጎዳ ሲንꬅ ኤኪ ሺቂዳ ጊሻስ ሃይቂዳ፤ ሄሳፌ ጉዬ ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","«ኔ ኢሻ ኣሮኔይ ታቦታ ቦላን ዲዛ ኣቶ ጊዛሶዛ ካሚዛይሳ ሲንꬃን ማጋላሻፔ ጉዬ ባጋራ ዲዛ ኬሂ ዱማ ጌቴቲዛሶዛ ባ ሼኔ ማላ ኡባ ዎዴ ጌሎንታ ማላ ኢዛስ ዮታ፤ ኢዚ ኡባ ዎዴ ባ ሼኔን ጌሊዛ ጊዲኮ ሃይቃና፤ ጋሶይካ ታኒ ሻራ ጊዶራ ኣቶ ጊዛሶዛ ካማ ቦላ ቆንጫይስ። ");
INSERT INTO gmve_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","«ኣሮኔይ ናጋራፔ ማሬꬂዛ ያርሾስ ኢሲ ሚርጎ ቦራኔ ቃሴ ጹጌቲዛ ያርሾስ ኢሲ ꬋርሾ ኤኪዲ ኬሂ ዱማ ጌቴቲዛሶዛ ጌሎ። ");
INSERT INTO gmve_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","ኣሮኔይ ኬሂ ዱማ ጌቴቲዛሶ ጌላናፔ ካሴ ማይኦቲ ዱማ ጊዲዳ ጊሻስ ባ ቦላ ሜጬቲዲ ቄሴቴꬃ ማይኦ ማይኦ፤ ሄሲካ ላይኖፔ ኦሴቲዳ ቃሚሳኔ ሱሬ ማይኦ፤ ሄሳꬆካ ላይኖፔ ኦሴቲዳ ቃባቶን ጊጾ፤ ላይኖፔ ኦሴቲዳ ጎሴካ ጎዞ። ");
INSERT INTO gmve_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","«ኢስራኤሌ ናይታ ማባራይ ናጋራ ጊሻስ ሺሺዛ ያርሾስ ናምኡ ዴይሻ ኦርጌኔ ጹጌቲዛ ያርሾስ ኢሲ ꬋርሾ ኣሮኔስ ኤሄቶ። ");
INSERT INTO gmve_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","ኣሮኔይ ባሲኔ ባሶ ኣሳ ናጋራ ዉርሳናስ ኢሲ ኮርማ ቦራ ያርሾስ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ሄሳፌ ጉዬ ሄ ናምኡ ዴይሻ ኦርጌታ ጌዴ ጋይቶቴꬃ ዱንካኔዛ ፔንጌን ጎዳ ሲንꬅ ኤፎ። ");
INSERT INTO gmve_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ሂስቲዲ ሄ ናምኡ ኦርጌታ ቦላ ኢዚ ሳማ ዬጎ፤ ሄይታፔ ኢሶይ፥ ‹ጎዳ› ናምኣንꬆዚ፥ ‹ኣዛዜሌ› ጊዛ ማላታይ ዲዛ ሹቻታ ኦርጌታ ቦላ ዬጎ። ");
INSERT INTO gmve_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","ጎዳስ ጊዛ ማላታይ ኢዛ ቦላ ዎꬊዳ ዴይሻዛ ናጋራፔ ጌሺዛ ያርሾስ ሹኮ። ");
INSERT INTO gmve_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ኣዛዜሌስ ጊዛ ማላታይ ኢዛ ቦላ ዎꬊዳ ዴይሻዚ ሹኬቶንታ ፓጻ ጎዳስ ሺቆ፤ ዴሬዛ ናጋራ ቶኪዲ ዱጌ ባዞ ዬዴቶ። ");
INSERT INTO gmve_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","«ኣሮኔይካ ኮርማ ቦራዛ ባ ናጋራ ዉርሳናሲኔ ባሶ ኣሳ ናጋራ ዉርሳናስ ያርሾ ሹኮ። ");
INSERT INTO gmve_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ቃሴ ጎዳ ሲንꬃን ዲዛ ያርሾ ያርሺዛሶፔ ኤጻኔ ጩዋሲዛ ሚሻ ኩሜꬃ ቦንቆኔ ሊቂ ጋጬቲዳ ናምኡ ዞሌ ሳዊዛ ኤጻኔ ኤኪዲ ማጋላሻ ጊዶን ዲዛ ኬሂ ዱማ ጊዲዳ ኪፊሌ ኤሆ። ");
INSERT INTO gmve_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ኤጻኔዛ ሄን ጎዳ ሲንꬃን ታማን ዬጎ፤ ኢዚ ኢዛ ቤኢዲ ሃይቆንታ ማላ ኤጻኔዛ ጩዋይ ታቦታ ካሚዛይሳ ኡባ ጌንꬆ። ");
INSERT INTO gmve_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ኮርማዛ ሱꬃፌ ጉꬃራ ኤኪዲ ኢዛን ባ ቢራꬌ ጌልꬂ ጌልꬂዲ ታቦታ ካማዛ ቦላ ሲንꬃ ባጋራ ኣራጮ፤ ሄሳꬆካ ኢዛፔ ጉꬃራ ጫቆ ቃላ ታቦታ ሲንꬃን ላፑንቶ ዉጾ። ");
INSERT INTO gmve_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","«ሄሳፌ ጉዬ ሃንኮ ዴሬዛ ናጋራ ጊሻስ ሹኬቲዛ ዴይሻ ሹኮ፤ ኢዛ ሱꬃ ኬሂ ዱማ ጌቴቲዛ ኪፊሌዛ ጌልꬂዲ ካሴ ኮርማዛ ሱꬃ ኦꬆይሳꬆ ኣቶ ጊዛሶ ታቦታ ካማዛ ቦላኒኔ ኢዛስ ሲንꬃ ባጋራ ላፑንቶ ዉጾ። ");
INSERT INTO gmve_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ሄሳꬆካ ኦꬂዲ ኬሂ ዱማ ጊዲዳ ኪፊሌዛ ኢስራኤሌ ናይታ ቱናቴꬃፌኔ ኢስታ ናጋራ ኡባፌ ጌሻናስ ጌሾ ዎጋ ፖሎ፤ ካሴ ኢስቲ ቱና ሚሽ ኦꬂሺን ኢስታ ጊዶን ዲዛ ጋይቶቴꬃ ዱንካኔዛካ ሄሳꬆ ጌሾ። ");
INSERT INTO gmve_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","ጌሾ ዎጋ ፖላናስ ኣሮኔይ ኬሂ ዱማ ጌቴቲዛ ኪፊሌዛ ጌሊዲ ባ ናጋራ ጊሻስ፥ ባሶ ኣሳ ናጋራ ጊሻሲኔ ኢስራኤሌ ዴሬ ናጋራ ጊሻስ ያርሾ ሺሺ ማሪሲዲ ኬዛና ጋካናስ ኣይ ኣሲካ ጋይቶቴꬃ ዱንካኔዛ ጊዶን ዶፖ። ");
INSERT INTO gmve_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","ሄሳፌ ካሊዲ ኢዚ ጎዳ ሲንꬃን ያርሾ ያርሺዛሶ ኬዚዲ ጌሾ፤ ኮርማ ሱꬃፌኔ ዴይሻ ሱꬃፌ ጉꬃራ ኤኪዲ ያርሾ ያርሺዛሶዛን ዩዪ ኣꬋናስ ዲዛ ꬌሞታ ቲዮ። ");
INSERT INTO gmve_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","ቃሴ ኢስራኤሌ ናይታ ቱናቴꬃፌ ያርሾ ያርሺዛሶዛ ጌሻናሲኔ ዱማሳናስ ሱꬃፌ ጉꬃራ ኤኪዲ ባ ቢራꬌ ጼራን ያርሾ ያርሺዛሶዛ ቦላ ላፑንቶ ዉጾ። ");
INSERT INTO gmve_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«ኣሮኔይ ኬሂ ዱማ ጌቴቲዛሶ፥ ጋይቶቴꬃ ዱንካኔኔ ያርሾ ያርሺዛሶዛ ጌሾ ዎጋ ፖሊዳፔ ጉዬ ሹኬቶንታ ኣቲዳ ባቃ ዴይሻ ኤኪዲ ጎዳስ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","ባ ኩሼ ናምኣታ ዴይሻ ሁኤ ቦላ ዎꬂዲ ዴሬዛ ናጋራ፥ ኢታቴꬃኔ ማካላቴꬃ ኡባ ፓጾ፤ ዴይሻዛ ሁኤ ቦላ ዩሺ ፒቲሼ ዴራ ናጋራ ኢዛ ቦላ ዎꬆ፤ ሄሳፌ ጉዬ ካሴ ዴይሻዛ ኤፋናስ ጊጌቲ ኡቲዳዴ ቦላ ዱጌ ባዞ ዬዴቶ። ");
INSERT INTO gmve_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ሄሲካ ዴይሻይ ኣሳ ኡባ ናጋራ ኡባ ቶኪዲ ኣይ ኣሲካ ባይንዳሶ ዱጌ ባዞ ሃሲ ዬዶ። ");
INSERT INTO gmve_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","«ኣሮኔይካ ጋይቶቴꬃ ዱንካና ጊዶ ጌሎ፤ ጌዴ ኬሂ ዱማ ጌቴቲዛ ኪፊሌዛ ጌላናፔ ካሴቲዲ ኢዚ ካሴ ማይኢዳ ቄሴቴꬃ ማይኦዛ ሄን ቃሪ ዎꬆ። ");
INSERT INTO gmve_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ባ ቦላ ሄን ጌሻሶሆን ሜጬቲዲ ባ ካሴ ማይኢዛ ማይኦ፤ ሄፔ ኬዚዲ ባ ናጋራ ዉርሳናሲኔ ዴራ ናጋራ ዉርሳናስ ጹጌቲዛ ያርሾ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","ናጋራ ዉርሳናስ ሺቂዳ ሜሄዛ ሞꬌ ያርሾ ያርሺዛሶዛ ቦላ ጹጎ። ");
INSERT INTO gmve_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«ባዞ ዬዴቲዛ ዴይሻ ዱጌ ባዞ ላጊ ኤፊዳዴይ ጉዬ ኣሳይ ዲዛሶ ሲሚ ጌላናፔ ካሴቲዲ ባ ማይኦ ሜጮ፤ ባ ቦላካ ሜጬቶ፤ ሄሳፌ ጉዬ ኣሳይ ዲዛሶ ጌሎ። ");
INSERT INTO gmve_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","ናጋራ ጊሻስ ያርሼታና ሺቂዳይታኔ ናጋራ ጌሻናስ ኢስታ ሱꬂ ኬሂ ዱማ ኪፊሌ ጌቴቲዛሶ ጌሊዳ ኮርማዛኔ ዴይሻዛ ኣሾይ፥ ጋልባዚኔ ቶጬይ ኣቶንታ ኣሲ ዲዛሶፔ ጌዴ ሃራሶ ቢዲ ጹጌቶ። ");
INSERT INTO gmve_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ሄሳ ኡባ ጹጊዛዴይ ጹጊዲ ኣሲ ዲዛሶ ሲሚ ጌላናፔ ካሴቲዲ ባ ማይኦ ሃꬃን ሜጮ፤ ባ ቦላካ ሜጬቶ። ");
INSERT INTO gmve_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«ሃይሳፌ ካሊዲ ኢንቴስ ኢሜቲዛ ዎጋታ ሃይሳፌ ጉዬ ያና ላይꬃታን ኡባን ላሜቶንታ ኤቂ ዲዛ ዎጋ ሂስቲዲ ናጊቴ፤ ላይꬃፌ ላፑንꬃ ኣጊናይ ጌሊዳ ታማንꬆ ጋላስ ኢስራኤሌ ዴሬ ኣሳይኔ ኢስታ ጋርሳን ዲዛ ሃራ ዴሬ ኣሳይ ጾማ ጾማናስ ቤሴስ፤ ሄ ጋላስ ኣይ ኦሶይካ ኦሴቶፎ። ");
INSERT INTO gmve_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ሄ ጋላስ ኢንቴ ናጋራይ ኪቻና ማላኔ ኢንቴ ጌያና ማላ ጌሾ ዎጋይ ፖሌቲዛ ጊሻስ ኢንቴ ጎዳ ሲንꬃን ኢንቴ ናጋራ ኡባፌ ጌዪዳይታ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ሄ ጋላሳይ ጾማ ጋላሲኔ ሼምፖ ሼምፒዛ ሳምባታ ጋላስ ጊዶ፤ ሄሲካ ሜርና ዎጋ ጊዶ፤ ");
INSERT INTO gmve_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","ባ ኣዋ ሶሆን ቄሴታ ሃላቃ ጊዳናስ ቲዬቲዳኔ ሹሜቲዳ ቄሴይ ናጋራ ኡባ ዎጋ ፖላናስ ባ ቄሴቴꬃ ማይኦዛ ማይኢዲ ፖሎ። ");
INSERT INTO gmve_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","ኢዚካ ኬሂ ዱማ ኪፊሌዛ፥ ያርሾ ያርሺዛሶዛ፥ ጋይቶቴꬃ ዱንካኔዛ፤ ቄሴታኔ ኢስራኤሌ ኣሳ ኡባ ናጋራ ዉርሶ። ");
INSERT INTO gmve_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","ኢስራኤሌ ኣሳ ናጋራ ኡባ ዎጋ ኢንቴ ላይꬃን ላይꬃን ኢሲቶ ፖላና ማላ ሄሲ ኢንቴስ ሜርናስ ላሜቶንታ ዎጋ ጊዶ።» ሄሳꬆ ጎዳይ ኢዛ ኣዛዚዳ ማላ ሙሴይ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","« ‹ጎዳይ ኣዛዚዳ ኣዛዞይ ሃይሳ› ጋዳ ኣሮኔስ፥ ኢዛ ናይታሲኔ ኢስራኤሌ ኣሲ ኡባይ ዲዛ ሄራን ዮታ፤ ");
INSERT INTO gmve_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ዎይኮ ባ ዲዛ ሄራፔ ካሬን ቦራ ዎይኮ ዶርስ ዎይኮ ዴይሼ ያርሾ ሹኪዲ፥ ");
INSERT INTO gmve_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ጎዳስ ዱማቲዳሶን ጾሳስ ያርሻናስ ጋይቶቴꬃ ዱንካኔ ፔንጌ ኤሆንታ ኣጊኮ ሄሳዴይ ሱꬃ ጮ ሃዳ ጉሲዳ ማላ ቆዴቲዲ ዴሬ ጊዶፌ ሻኬቲ ጎዴቶ። ");
INSERT INTO gmve_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ሄሳ ጊሻስ ኢስራኤሌ ናይቲ ኣይ ሜሄ ጊዲን ጮ ዴምባን ሹኮንታ ጎዳ ሲንꬅ ጋይቶቴꬃ ዱንካኔ ፔንጌ ኤሄቶ፤ ሜሄታ ዱንካኔ ፔንጌ ኤሂዲ ቄሴዛስ ኢሜቶ፤ ቄሴዚካ ኢሲፌቴꬃ ያርሾ ሂስቲ ሹኮ። ");
INSERT INTO gmve_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","ቄሴዚካ ሱꬃ ጋይቶቴꬃ ዱንካኔ ፔንጌን ዲዛ ጎዳስ ያርሾ ያርሺዛሶዛ ቦላ ዉጾ፤ ጎዳ ኡፋይሲዛ ሎኦ ሳዎ ጊዳና ማላ ሞꬌዛ ታማን ጹጎ። ");
INSERT INTO gmve_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","ኢስራኤሌ ናይቲ ኢስታ ኣማኖፔ ሃሲዛ ዳይዳንꬃታስ ያርሾ ኦꬂዲ ባ ሜሄ ቤቶሶን ቤቶሶን ያርሾስ ሹካናስ ቤሴና፤ ሄሲካ ኢስታሲኔ ኢስታፌ ጉዬ ዬሌታ ኡባስ ሜርና ዎጋ ጊዲ ዴኦ። ");
INSERT INTO gmve_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","9","«ኔ ኢስታስ፥ ‹ኢስራኤሌ ናይታፔ ጊዲን ዎይኮ ኢስታራ ዲዛ ሃራ ዴሬ ኣስ ጊዲን ዱንካኔዛ ፔንጌፌ ኣቲን ሃራሶን ኣዋንካ ጎዳስ ጹጌቲዛ ያርሾ ዎይኮ ሃራ ያርሾ ያርሺኮ ሄሳዴይ ጎዳ ዴሬታራ ቆዴታናስ ቤሴና› ጋ ዮታ። ");
INSERT INTO gmve_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","«ኢስራኤሌ ኣስ ጊዲዳይ ኦኒካ ዎይኮ ኢስራኤሌ ናይታራ ኢሲፌ ዲዛ ሃራ ዴሬ ኣሲ ሱꬅ ኡዪኮ ሄሳዴይ ታ ኣቻን ኢጼቲዳዴ ጊዴስ፤ ታኒ ሄሳዴ ኢዛ ዴሬ ጋርሳፌ ሻካ ꬋይሳና። ");
INSERT INTO gmve_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","ሼምፖራ ፓጻ ዲዛ ሜꬌቴꬅ ኡባስ ሼምፖይ ሱꬃ ጊዶን ዴስ፤ ሄሳ ጊሻስ ኣሳ ናጋራ ዉርሳናስ ጉኪዛ ሱꬂ ዉሪካ ያርሾ ያርሺዛሶዛ ቦላ ጉካና ማላ ኢማዲስ፤ ኣሳ ሼምፖ ናጋራፔ ማሪሲዛይ ሱꬃ። ");
INSERT INTO gmve_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ሄሳ ጊሻስ ኢስራኤሌ ኣሳ፥ ‹ኢንቴፌ ዎይኮ ኢንቴ ጊዶን ዲዛ ሃራ ዴሬ ኣሳፔ ኦኒካ ሱꬅ ኡዮፖ› ጋይስ። ");
INSERT INTO gmve_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","«ኢስራኤሌ ናይታፔ ዎይኮ ኢስታራ ዲዛ ሃራ ዴሬ ኣሳፔ ኦኒካ ኣሾይ ሜቴታና ማላ ኢሜቲዳ ሜሄ ጊዲን ዎይኮ ዎራ ዶኣ ዎይኮ ካፎ ሻንካቲ ኦይኪዲ ኢዛ ሱꬃ ቢታ ቦላ ጉሲዲ ቢታ ኢዛ ቦላ ካሞ። ");
INSERT INTO gmve_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","ጋሶይካ ኣሾ ማይኢዳ ኡባ ሼምፖይ ሱꬃ ጊዶን ዴስ፤ ሄሳ ጊሻስ ታኒ ኢስራኤሌ ኣሳ፥ ‹ኣሾ ማይኢዳ ሜꬌታ ኡባ ሼምፖይ ኢዛ ሱꬃ ጊዶን ዲዛ ጊሻስ ሱꬅ ሞፒቴ፤ ሚዳዴይ ኦኒካ ባ ዴሬ ጊዶፌ ሻኬቲ ꬋዮ› ጋይስ። ");
INSERT INTO gmve_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","«ኢስራኤሌ ናይታፔ ዎይኮ ሃራ ዴሬ ኣሳፔ ኦኒካ ባዉቲ ሃይቂዳዝ ዎይኮ ዶኣይ ዎꬊዳ ሜሄ ኣሾ ሚኮ ባ ማይኦ ሜጮ፤ ባ ቦላ ሜጬቶ፤ ጊዲኮካ ኦማርስ ጋካናስ ቱና ጊዶ፤ ሄሳፌ ጉዬ ጌሽ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ባ ማይኦ ሜጮንታ ኣጊኮኔ ባ ቦላ ሜጬቶንታ ኣጊኮ ሄሳዴይ ናጋራ ኦꬂዳ ጊሻስ ባ ናጋራን ኦይሼታና።» ");
INSERT INTO gmve_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","ጎዳይ ሙሴስ ሂዝጊ ዮቲዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«ኢስራኤሌ ናይታስ፥ ‹ታኒ ጎዳ ኢንቴ ጾሳ፤ ");
INSERT INTO gmve_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","ካሴ ኢንቴ ሄን ዴኢዳ ጊብጼ ቢታ ኣሳይ ዎይኮ ቡሮ ታ ኢንቴና ጌልꬃና ካናኔ ቢታን ዲዛ ዴሬ ኣሳይ ኦꬂዛ ሻቲዛ ኦሶ ኢንቴ ኦꬆፍቴኔ ኢስታ ሃኖ ካሎፍቴ። ");
INSERT INTO gmve_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","ታ ዎጋታ ናጊቴ፤ ታ ኣዛዞታካ ፖሊቴ፤ ታኒ ጎዳ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","ታ ኣዛዞታኔ ዎጋታ ናጊቴ፤ ሄሳንታ ናጊዛ ኣሲ ባ ሼምፖ ኣሻና፤ ታኒ ጎዳ› ጋ ዮታ። ");
INSERT INTO gmve_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","«ኢንቴፌ ኦኒካ ባስ ኣሾ ዳቦራ ላይማቶፖ፤ ታኒ ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","«ኔ ኣዬይራ ላይማታዳ ኔ ኣዋ ካዉሾፋ፤ ኔስ ኣዮ ጊዲዳ ጊሻስ ኢዚራ ላይማቶፓ። ");
INSERT INTO gmve_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","«ኔ ኣዋስ ሃራ ማቼታራካ ላይማታዳ ኔ ኣዋ ዬላቾፋ። ");
INSERT INTO gmve_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","«ኔ ሚቼይራ ላይማቶፓ፤ ሄሳꬆካ ኔናራ ኢሲፌ ዲጪዳሮ ጊዲን ዎይኮ ሃራሶን ዲጪዳሮ ጊዲን ኔ ኣዋይ ዬሊዳ ሃራ ማቺ ና ዎይኮ ኔ ኣያ ሃራ ኣዚናስ ዬሊዳ ማጫ ናይራ ላይማቶፓ። ");
INSERT INTO gmve_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","«ኔስ ዬላ ጊዶንታ ማላ ኔስ ናዛ ናይራ፥ ዎይኮ ኔስ ናይ ናይራ ላይማቶፓ። ");
INSERT INTO gmve_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","«ኔ ኣዋስ ሃራ ማቻ ዬሊዳ ኔ ሚቼይራ ዚንኦፋ፤ ጋሶይካ ኢዛ ኔስ ሚቾ። ");
INSERT INTO gmve_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","«ኔ ኣዋ ሚቼይራ ዚንኦፋ፤ ጋሶይካ ኢዛ ኔስ ሚቾ። ");
INSERT INTO gmve_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","ኔ ኣዬይ ሚቼይራካ ዚንኦፋ፤ ጋሶይካ ኢዛ ኔ ኣዬይስ ኣሾ ዳቦ። ");
INSERT INTO gmve_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","«ኔ ኣዋ ኢሻ ማቺራ ዚንኦፋ፤ ጋሶይካ ኢዛ ኔስ ኣዋ ማቺ ማላ። ");
INSERT INTO gmve_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","«ኔ ናዛ ማቼይራ ዚንኦፋ፤ ኢዛ ኔስ ናዛ ማቾ ጊዲዳ ጊሻስ ኢዚራ ዚንኦፋ። ");
INSERT INTO gmve_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","ኔ ኢሻ ማቼይራ ዚንኦፋ፤ ጋሶይካ ኢዛ ኔስ ኢሻ ማቾ፤ ሄሲ ኔ ኢሻ ካዉሺዛ ሚሻ። ");
INSERT INTO gmve_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","«ኣዬይራኔ ናይራ ዚንኦፋ፤ ኢዚስ ናይ ናዛ ናይራኔ ናይስ ናይ ናይራ ዚንኦፋ፤ ኢስቲካ ኢዛስ ማታ ዳቦ ጊዲዳ ጊሻስ ሄሳꬆ ሃኖይ ካዉሻቴꬃ። ");
INSERT INTO gmve_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","«ኔ ማቺያ ፓጻ ዲሺን ኢዚ ሚቺዮ ዳዉꬅ ኤኮፋ፤ ኢዚራካ ላይማቶፓ። ");
INSERT INTO gmve_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","«ኣጊናን ኣጊናን ቤቲዛ ማጫሳ ዎጋይ ዪዛ ዎዴ ማጫሳራ ዚንኦፋ። ");
INSERT INTO gmve_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","«ሃራ ኣሳ ማቺራ ዚንኣዳ ኔርካ ኔና ቱኒሶፓ። ");
INSERT INTO gmve_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","«ኔ ናይታፔ ኦናካ ሞሎኬ ጌቴቲዛ ኤቃስ ጹጌቲዛ ያርሾ ኦꬃ ኢሞፋ፤ ጋሶይካ ኔ ጾሳ ሱንꬅ ቱኒሶፓ፤ ታኒ ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","«ጎዳ ሲንꬃን ኢጼቲዳ ሚሽ ጊዲዳ ጊሻስ ማጫሳራ ዚንኢዛ ማላ ኣዴራ ዚንኦፋ። ");
INSERT INTO gmve_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","«ኣዴ ጊዲን ዎይኮ ማጫሲ ሜሄራ ፓራቲዲ ባናቴꬃ ቱኒሶፖ፤ ሄሳ ማላ ሃኖይ ካዉሻቴꬃ። ");
INSERT INTO gmve_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","«ጎዳይ ኔና ኢስታ ዴሬ ጌልꬃናስ ኔ ሲንꬃፌ ዲጋና፤ ሃንኮ ኣሳይ ባርካ ባ ኦሶን ባና ቱኒሲዳይሳ ማላ ኢስቲ ኦꬂዛ ኢታ ኦሶታፔ ኢሲኔይንካ ኢንቴና ቱኒሶፒቴ። ");
INSERT INTO gmve_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ኢስታ ኦሶይ ቢታ ቱኒሲዳ ጊሻስ ታኒ ሄ ቢታዮ ኢዚ ናጋራ ጊሻስ ቃጻያዲስ፤ ቢታያካ ባ ጊዶን ዲዛ ኣሳ ኬሳ ጩታዱስ። ");
INSERT INTO gmve_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","ኢንቴ ጊዲኮ ታ ኣዛዞታኔ ታ ዎጋ ናጊቴ፤ ኢስራኤሌ ኣሳፔ ዎይኮ ኢንቴ ጊዶን ዲዛ ሃራ ቢታ ኣሳፔ ኦኒካ ሃይሳ ማላ ኣይ ኦሶካ ኦꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ኢንቴፌ ካሴ ሄ ቢታይን ዲዛ ኣሳቲ ሄይታ ማላ ሃራሲዛ ሚሽ ኦꬂዳ ጊሻስ ቢታያ ቱናዱስ። ");
INSERT INTO gmve_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ኢንቴ ሄሳꬆ ኦꬂኮ ቢታያ ካሴ ኢንቴፌ ሲንꬃን ዲዛ ካዎቴꬃታ ጩቲዳይሳꬆ ኢንቴናካ ጩታና። ");
INSERT INTO gmve_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","«ሃይታ ሃራሲዛ ኢታ ኦሶታፔ ኢሲኔዮካ ኦꬂዛዴይ ባ ዴሬ ኣሳ ጊዶፌ ሻኬቲ ꬋዮ። ");
INSERT INTO gmve_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","ሄሳ ጊሻስ ኢንቴፌ ካሴ ሲንꬃን ቢታ ቦላ ዲዛ ኣሳቲ ኦꬂዳ ቱና ኦሶታ ኡባ ኦꬂዲ ኢንቴ ቱኖንታ ማላ ታ ኣዛዞታ ናጊቴ፤ ታኒ ጎዳ ኢንቴ ጾሳ።» ");
INSERT INTO gmve_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","ጎዳይ ሙሴ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«ሃይሳ ኢስራኤሌ ናይታስ ዮታ፥ ‹ታኒ ጎዳይ ኢንቴ ጾሳይ ዱማ ጊዲዳ ማላ ኢንቴካ ዱማ ጊዲቴ። ");
INSERT INTO gmve_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","« ‹ኢንቴፌ ኦኒካ ኣቶንታ ባ ኣዋኔ ባ ኣዮ ቦንቾ፤ ታ ኢንቴና ኣዛዚዳ ማላ ሳምባታ ጋላሳታ ቦንቾ፤ ታኒ ጎዳ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","« ‹ታና ኣጊዲ ኤቃታስ ጎይኖፍቴ፤ ዎይኮ ኤቃ ጾሳታ ቢራታፔ ሴሪሲዲ ኢንቴስ ሜꬎፍቴ፤ ታኒ ጎዳ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","« ‹ኢንቴ ኢሲፌቴꬃ ያርሾ ጎዳስ ሺሺዛ ዎዴ ሄ ያርሾይ ኢንቴ ጊሻስ ኤኬታና ቤሲዛ ማላ ያርሺቴ። ");
INSERT INTO gmve_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ያርሾዛ ሺሺዳ ጋላስ ዎይኮ ዎንቴꬃ ጋላስ ሜቴታናስ ቤሴስ፤ ሄꬓንꬆ ጋላስ ጋካናስ ጋምኢዳ ያርሾይ ዉሪካ ታማን ጹጌቶ። ");
INSERT INTO gmve_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ሄꬓንꬆ ጋላሳን ኢዛ ሚኮ ሄሲ ቱና፤ ሄሳ ጊሻስ ታኒ ሄ ያርሾዛ ኤኪኬ። ");
INSERT INTO gmve_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ኢዛፔ ሚዳዴይ ኦኒካ ታስ ዱማቲዳይሳ ሃዳ ሚሻ ማላ ቆዲዳ ጊሻስ ኢዚ ባ ናጋራን ኦይሼታና፤ ሄሳዴይ ባ ዴሬ ኣሳ ጊዶፌ ሻኬቲ ꬋዮ። ");
INSERT INTO gmve_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","« ‹ኢንቴ ማጻ ዎዴ ኢንቴ ካꬅ ማጺሺን ጋጻ ቦላ ዲዛ ካꬅ ማጾፒቴ፤ ኢንቴ ማጺሺን ጌዶን ኣቲዳ ፑሼቾ ማጻናስ ጉዬ ሲሞፍቴ። ");
INSERT INTO gmve_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","ኔኒ ኔ ዎይኔ ሚꬃ ኣይፌ ማጺሺን ሃጋ ጊዶን ቆቴቲ ኣቲዳይሳ ዎይኮ ጋዴን ቆቆፌቲዳይሳ ቆራ ኤካናስ ጉዬ ሲሞፋ፤ ሄይታንታ ኡባ ማንቆታሲኔ ቤቴ ዪዳይታስ ኣጋጋ፤ ታኒ ጎዳ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","« ‹ካይሶቶፒቴ፤ ኣስ ባሌꬆፍቴ፤ ዎርዶ ሃሳዮፒቴ፤ ");
INSERT INTO gmve_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","« ‹ታ ሱንꬃን ዎርዶራ ጫቆፍቴ፤ ዎርዶ ጫቂዲ ኢንቴ ጾሳ ሱንꬃ ቱኒሶፒቴ፤ ታኒ ጎዳ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","« ‹ኣስ ባሌꬆፋ፤ ዎይኮ ኣሳ ሚሼ ቦንቃ ኤኮፋ፤ ሚሼ ኢማና ጋዳ ኔ ኦሶ ኦሲሲዳዴስ ሚሻ ኢሞንታ ዳሼ ኔ ኣቻን ኢሲ ቃማካ ኣይሶፋ። ");
INSERT INTO gmve_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","« ‹ሲዬና ጋዳ ቱሌ ጫዮፓ፤ ቆቄይ ꬉጴቲዲ ኩንዳና ማላ ኢዛ ሲንꬃን ꬉጲዛዝ ዎꬆፋ፤ ኔ ጾሳስ ያያ፤ ታኒ ጎዳ ኔ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","« ‹ኔኒ ፒርዳ ፒርዲዛ ዎዴ ፒርዳ ጌላሶፓ፤ ማንቆ ኢዛ ማንቆቴꬃ ጊሻስ ማዳ ፒርዶፋ፤ ጊታ ኣሳታስ ዱማ ቦንቾ ኢሞፋ፤ ዴሬ ኣሳካ ዱማ ማዳ ፒርዶፋ፤ ኣሳ ኡባስ ቱሙ ፒርዳ ፒርዳ። ");
INSERT INTO gmve_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","« ‹ኔኒ ኣሳ ጊዶን ዚጊርስ ኤካዳ ዩዮፓ፤ ኔ ሾሮዛ ሃይቆስ ጋꬂዛ ኣይ ሚሺካ ኦꬆፋ፤ ታኒ ኔ ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","« ‹ኔ ኢሻ ኔ ዎዚናን ኢጾፋ፤ ኢዛ ጋሶን ኔስ ናጋራ ጊዶንታ ማላ ኔ ሾሮዛ ሃንቃ። ");
INSERT INTO gmve_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","« ‹ኣስ ኡባ ኔ ኔና ሲቂዛ ማላ ሲቃ ኣቲን ኣይ ኣሳ ቦላካ ኔ ኡሎን ላንጬ ኦይካዳ ሃሎ ኬሶፋ፤ ታኒ ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","« ‹ታ ኣዛዞታ ናጊቴ፤ ዱማ ዱማ ቆሞ ሜሄታ ኢሲ ቦላ ጋꬂ ሜሄቲሶፍቴ፤ ናምኡ ቆሞ ካꬃ ዜሬꬅ ዋላኪዲ ኢሲ ቦላ ዜሮፒቴ፤ ናምኡ ቆሞ ሚሻፌ ዳዴቲዳ ማይኦ ማይኦፍቴ። ");
INSERT INTO gmve_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","« ‹ኢሳዴይ ሃራ ኣሳራ ጊጌታ ኡቲዳ ኣይሌይራ ላይማቲኮ ኢዛካ ባ ኣይሌቴꬃፌ ዎዜቶንታሮ ጊዲኮ ኢዛዴይ ቃጻዬቶ፤ ጊዲኮካ ኢዛ ዎዜቶንታ ጊሻስ ናምኣይካ ሃይቆፌቶ። ");
INSERT INTO gmve_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ሄሳ ማላ ቆሆ ጋꬂዳዴይ ቆሆ ጊሻስ ሺቂዛ ያርሾስ ኢሲ ꬋርሾ ጋይቶቴꬃ ዱንካኔ ፔንጌ ጎዳ ሲንꬅ ኤሆ። ");
INSERT INTO gmve_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ቄሴዚካ ሄሳዴ ናጋራ ዉርሳናስ ጾሳ ሲንꬃን ቆሆ ያርሾስ ኢሜቲዳ ꬋርሾዛ ሺሾ፤ ኢዛዴ ናጋራይካ ኣቶ ጌቴታና። ");
INSERT INTO gmve_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","« ‹ኢንቴ ካናኔ ጌሊዲ ኣይፌ ኣይፊዛ ሚꬅ ቶኪኮ ሄ ኣይፌ ኣይፊዛ ሚꬃያ ኣይፌ ዶሞሶፌ ቢዲ ሄꬑ ላይꬅ ጋካናስ ኢሚዛ ኣይፌይ ሜቴቶንታ ዲጌቲዳይሳ ኤሪቴ፤ ሄ ላይꬃታን ሄ ሚꬃታ ኣይፌ ሞፒቴ። ");
INSERT INTO gmve_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","ኦይዳንꬆ ላይꬃ ቦላ ሄ ሚꬃ ኣይፌይ ኡባይ ጎዳስ ጋላታስ ሺሺዛ ያርሾ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ኢቻሻንꬆ ላይꬃን ቃሴ ሚꬃ ኣይፌዛ ኢንቴስ ሚቴ፤ ኢንቴ ሄሳꬆ ሂስቲኮ ኣይፌ ኣይፊዛ ኢንቴ ሚꬃይ ዎዴን ዎዴን ኢንቴስ ኢሚዛ ኣይፌይ ካሴፔ ጌዴ ጉጄቲ ጉጄቲ ባና፤ ታኒ ጎዳ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","« ‹ሱꬃራ ዲዛ ኣይ ኣሾካ ሞፒቴ፤ ማሮꬆፍቴኔ ቢታ ቢቶፒቴ። ");
INSERT INTO gmve_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","« ‹ኢንቴ ሁኤ ቢናና ጋርሳራ ዩሺ ኣꬂዲ ቃንጾፍቴ፤ ኢንቴ ቡቻካ ቃንꬃን ቃንጾፍቴ። ");
INSERT INTO gmve_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","« ‹ኢንቴ ኣሳቴꬃ ቦላ ኒቅሴ ጫች ጫዶፍቴ፤ ዎይኮ ኣሲ ሃይቂኮ ኢዛስ ሚሼቲዲ ኢንቴ ቦላ ቃንጺ ማዱንꬆፍቴ፤ ታኒ ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","« ‹ቢታያ ላይማኒኔ ቱናቴꬃን ኩሞንታ ማላ ኔ ናዮ ላይማቴꬃ ኦሶስ ኣꬃ ኢማዳ ካዉሾፋ። ");
INSERT INTO gmve_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","ታ ሳምባታ ጋላሳታ ናጊቴ፤ ታ ኬꬃ ቦንቺቴ፤ ታኒ ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","« ‹ሞይቲሌ ሃሳይሲዛይታ ዎይኮ ኢታ ኣያናታ ሃሳይሲዛይታ ዞሬ ኦይቾፋ፤ ኢንቴ ቱኖንታ ማላ ኢስታ ኮዮፒቴ፤ ታኒ ጎዳይ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","« ‹ኔፔ ጪሚዳዴ ቤይኮ ኔ ኡቲዳሶሆፔ ዴንዳ ኤቃዳ ቦንቻ፤ ታስ ጾሳስ ያሻቴꬃን ኣዛዜታ፤ ታኒ ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","« ‹ሃራ ቢታፌ ዪዲ ኢንቴ ጊዶን ዲዛ ኣሳታ ቆሆፒቴ። ");
INSERT INTO gmve_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","ኢንቴ ኢንቴ ዴሬ ኣሳስ ኦꬂዛ ማላ ኢስታስካ ሎኦ ኦꬂቴ፤ ኢንቴ ኢንቴና ሲቂዛ ማላ ኢስታካ ሲቂቴ፤ ካሴ ኢንቴካ ጊብጼ ቢታን ቤቴታ ጊዲዳይሳ ዩሺ ቆፒቴ፤ ታኒ ጎዳ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","« ‹ማካ ሚሼን ጊዲን ዎይኮ ሜዛኔን ዎይኮ ዋꬋ ሚሻን ኣስ ጪሞፍቴ። ");
INSERT INTO gmve_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ኣስ ጪሞንታ ቱሙ ሜዛኔይ፥ ማካ ሚሺኔ ሚጼ ሚሺ ኢንቴስ ዴኦ፤ ታኒ ኢንቴና ጊብጼፔ ኬሲዳ ጎዳ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","« ‹ታ ኢንቴስ ኢሚዳ ታ ኣዛዞታኔ ታ ዎጋታ ኡባ ናጊቴኔ ኦꬂቴ፤ ታኒ ኢንቴ ጎዳ።› » ");
INSERT INTO gmve_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","ጎዳይ ሙሴ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«ኢስራኤሌ ናይታ፥ ‹ኢንቴና ጊዲኮኔ ኢንቴ ጊዶን ዲዛ ሃራ ዴሬ ኣሳታፔ ኦኒካ ሞሎኬ ጌቴቲ ጼይጌቲዛ ኤቃ ጾሳስ ባ ናይታፔ ኢሳ ኣꬂ ኢሚ ቤቲኮ ኩሜꬃ ኢስራኤሌ ዴሬ ኣሳይ ሄሳዴ ሹቻን ጫዲ ዎꬎ። ");
INSERT INTO gmve_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ኦኒካ ባ ናይታፔ ኢሳዴ ሞሎኬስ ኣꬂ ኢሚዲ ታ ኬꬃ ቱኒሲዳ ጊሻሲኔ ጌሻ ሱንꬃ ታይሳ ካዉሺዳ ጊሻስ ታ ሄሳዴ ቦላ ቂጻቴ ዬዳና፤ ሄሳፌ ጉዬ ታ ኢዛዴስ ሞርኬ ጊዳዳ ዴሬ ጊዶፌ ኢዛ ሻካ ꬋይሳና። ");
INSERT INTO gmve_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ኢዛ ዴሬ ኣሳይ ኢዛዴይ ኦꬆይሳ ኡባካ ዉዴቶንታ ቤሲ ኣጊኮኔ ዎꬎንታ ኣጊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ታኒ ታ ባጋራ ሄሳዴኔ ኢዛዴሶ ኣሳ ቃሴካ ታስ ኣማኔቶንታ ሞሎኬስ ጎይኖን ኢዛራ ኢሲፌ ጊዲዳይታ ኡባ ቦላ ኢታ ሃንቆ ዬዳና፤ ሄሳፌ ጉዬ ሄይታንታ ታኒ ኢስታ ኢስታ ዴሬዛ ጊዶፌ ሻካ ꬋይሳና። ");
INSERT INTO gmve_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","« ‹ኦኒካ ኢስታፌ ዞሬ ኦይቻናስ ሞይቲሌ ጼይጊዛይታኮኔ ማሮታኮ ቢኮ ሄሳዴ ቦላ ታ ኢታ ሃንቆ ዬዳና፤ ሄሳፌ ጉዬ ሄሳዴ ታኒ ኢዛ ዴሬ ጊዶፌ ሻካ ꬋይሳና። ");
INSERT INTO gmve_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","« ‹ኢንቴ ኣሳቴꬅ ኡባ ጌሺቴ፤ ዱማቲቴ፤ ጋሶይካ ታኒ ጎዳ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","ታ ኣዛዞዮ ናጊቴኔ ፖሊቴ፤ ጋሶይካ ታኒ ኢንቴና ታስ ዱማሲዳ ኢንቴ ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","« ‹ባ ኣዋ ዎይኮ ባ ኣዮ ጫዪዛዴይ ሃይቆን ቃጻዬቶ፤ ኢዚ ሃይቆን ቃጻዬቲዛይ ባ ሞሮና። ");
INSERT INTO gmve_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","« ‹ኢሲ ኣሲ ሃራ ኣሳ ማቺራ ላይማቲኮ ሄ ላይማቲዳ ኣዴዛራኔ ማጫሳይራ ናምኣይካ ሃይቆን ቃጻዬቴቶ። ");
INSERT INTO gmve_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","ኢሲ ኣሲ ባ ኣዋ ማቺራ ላይማቲኮ ባ ኣዋ ካዉሺዳ ጊሻስ ሄ ላይማቲዳይቲ ናምኣይካ ሃይቆን ቃጻዬቴቶ፤ ኢስቲ ሃይቆን ቃጻዬቲዛይ ባ ሞሪዳ ሞሮና። ");
INSERT INTO gmve_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","ኢሲ ኣሲ ባስ ናዛ ማቺራ ላይማቲኮ ሄ ላይማቲዳይቲ ናምኣይካ ሃይቆን ቃጻዬቴቶ፤ ኣሾ ዳቦቴꬅ ላይማን ቱኒሲዳ ጊሻስ ኢስቲ ሃይቆን ቃጻዬቲዛይ ባ ሞሪዳ ሞሮና። ");
INSERT INTO gmve_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","« ‹ኢሲ ኣሲ ማጫራ ዚንኢዛ ማላ ኣዴይ ኣዴራ ዚንኢኮ ናምኣይካ ዬላቺዛ ሚሽ ኦꬂዳ ጊሻስ ሃይቆን ቃጻዬቴቶ፤ ኢስቲ ሃይቆን ቃጻዬቲዛይ ባ ሞሪዳ ሞሮና። ");
INSERT INTO gmve_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","« ‹ኢሲ ኣሲ ኣዬዮኔ ናዮ ማቾ ኤኪኮ ሄይታንቲ ኦꬂዳ ሃራሲዛ ሃኖዛ ጊሻስ ሄꬓይካ ታማን ጹጌቲ ሃይቄቶ፤ ሄይታንታ ማላ ኢታ ሃኖይ ኢንቴ ጊዶን ፖሌታናስ ቤሴና። ");
INSERT INTO gmve_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","« ‹ኣይ ኣሲካ ሜሄራ ፓራቲኮ ኢዛዴይኔ ሄ ሜሄዚ ናምኣይ ሃይቄቶ። ");
INSERT INTO gmve_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","« ‹ኢሲ ማጫሲ ሜሄራ ፓራቲኮ ኢዛኔ ሄ ኢዛ ፓራቲዳ ሜሄይ ናምኣይ ሃይቄቶ፤ ኢስቲ ሃይቂዛይ ባ ሞሪዳ ሞሮና። ");
INSERT INTO gmve_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","« ‹ኢሲ ኣሲ ባ ሚቺዮ፥ ባስ ኣዪ ናዮ ዎይኮ ኣዋ ናዮ ማቾ ኤኪኮ ሄሲ ዬላቺዛዛ፤ ሄሳ ጊሻስ ኢስቲ ባንታ ዴሬ ጊዶፌ ሻኬቲ ꬋዬቶ፤ ባ ኦꬂዳ ሞሮ ጊሻስ ባ ቂጻቴ ኤኬቶ። ");
INSERT INTO gmve_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","« ‹ኢሲ ኣሲ ኣጊናን ኣጊናን ቤቲዛ ማጫሳ ዎጋይ ቤቲዳ ማጫሳራ ዚንኢኮ ኢዛዴይ ኢዚ ካሎቴꬅ ቃሪዳ ጊሻሲኔ ኢዛካ ባ ካሎቴꬃ ቃራ ቤሲዳ ጊሻስ ናምኣይካ ባንታ ዴሬ ጊዶፌ ሻኬቲ ꬋዬቶ። ");
INSERT INTO gmve_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","« ‹ኣይ ኣሲካ ባ ኣዋ ሚቺራ ዎይኮ ባ ኣዪ ሚቺራ ዚንኦፎ፤ ሄሳꬆ ኦꬂዛ ጊዲኮ ናምኣይካ ባንታ ዳቦቴꬃ ካዉሺዛ ጊሻስ ባ ሞሪዳ ሞሮን ኦይሼታና። ");
INSERT INTO gmve_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","« ‹ኣይ ኣሲካ ባ ኣዋ ኢሻ ማቺራ ዎይኮ ባ ኣዬይ ኢሻ ማቺራ ላይማቲኮ ባ ኣዋ ኢሻ ማቾ ዎይኮ ባ ኣዪ ኢሻ ዬላሲዳ ጊሻስ ላይማቲዳይቲ ናምኣይካ ኦይሼታናኔ ዬሎይ ባይንዳ ኣታና። ");
INSERT INTO gmve_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","ኣይ ኣሲካ ባ ኢሻ ማቾ ኤኪዛ ጊዲኮ ሄሲ ቱና ኦꬄስ፤ ባ ኢሻዛ ቦንቾ ካዉሺዳ ጊሻስ ናምኣይካ ና ዬሎንታ ኣታና። ");
INSERT INTO gmve_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","« ‹ታ ኢንቴና ኢዚን ጌልꬃና ካናኔ ቢታያ ኢንቴና ጩታ ዲጎንታ ማላ ኢንቴ ታ ኣዛዞታኔ ታ ዎጋታ ናጊቴኔ ፖሊቴ። ");
INSERT INTO gmve_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ታኒ ኢንቴ ሲንꬃፌ ꬋይሲዛ ካዎቴꬃታ ሎሴ ዎጋ ካሎፍቴ፤ ኢስቲ ሄይታንታ ኡባ ኦꬂዳ ጊሻስ ታ ኢስታ ሻቴታዲስ። ");
INSERT INTO gmve_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","ታ ቃሴ ኢዚፔ ማꬂኔ ኤሲ ጎጊዛ ሄ ጪሊላ ቢታዮ ኢንቴና ጌልꬃናስ ጫቃዲስ፤ ኢዞካ ታ ኢንቴስ ኢማና፤ ሃንኮ ዴሬፔ ኢንቴ ታስ ሻኬቲዳይታ ጊዳና ማላ ኦꬂዳይ ታና ጎዳ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","« ‹ሄሳ ጊሻስ ኢንቴ ጌሽ ጊዲዳ ሜሄታኔ ካፎታ ቱና ጊዲዳይታፔ ሎኤꬂዲ ሻኪ ኤሪቴ፤ ታኒ ሃይታንቲ ኢንቴስ ቱና ጋ ዎꬂዳ ሜሄታን፥ ካፎታኒኔ ቢታ ቦላ ቃጺዛ ኣይ ሚሻንካ ኢንቴና ቱኒሶፒቴ። ");
INSERT INTO gmve_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","ኢንቴ ታስ ዱማ ሻኬቲዳይታ ጊዲቴ፤ ጋሶይካ ታኒ ጎዳይ ዱማ ጾሳ፤ ኢንቴ ታ ዴሬታ ጊዳና ማላ ኣይዛቤታ ጊዶፌ ታኒ ኢንቴና ታስ ዱማሳ ሻካዲስ። ");
INSERT INTO gmve_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","« ‹ኣይ ኣሲካ ኢንቴ ጊዶፌ ሞይቲሌ ጼይጊዛ ዎይኮ ማሮቲዛዴ ጊዲኮ ኢዚ ሹቻን ጫዴቲ ሃይቆ፤ ሄሳꬆ ኦꬂዛዴይ ኣይ ኣሲካ ሃይቆን ቃጻዬቲዛይ ባ ኦꬂዳ ሞሮና› ጋ ዮታ።» ");
INSERT INTO gmve_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","ጎዳይ ሙሴስ፥ «ኣሮኔ ናይታስ ቄሴታስ፥ ‹ኢንቴፌ ኦኒካ ባ ዳቦታ ጋርሳፌ ኣሲ ሃይቂኮ ኢዛዴ ኣሃ ቦቺዲ ባና ቱኒሶፖ። ");
INSERT INTO gmve_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ማታ ዳቦታፔ ኣያ ዎይኮ ኣዋይ ዎይኮ ባ ናይ ዎይኮ ባ ኢሻይ ሃይቂኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ሄሳꬆካ ኣዚና ጌሎንታ ኢጻዳ ዲዛ ሚቼያ ሃይቂኮ ኢስታ ኣሃ ቦቻናስ ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","ጊዶ ኣቲን ጌሎኒኔ ኤኮን ዳቦቲዳይቲ ኣሃ ቦቺዲ ባና ቱኒሶፔቶ። ");
INSERT INTO gmve_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","« ‹ቄሴታፔ ኦኒካ ሃይቂዳዴስ ሚሼቲዲ ባ ሁኤ ቢናና ቡጮፖ፤ ባ ቡቼካ ቡጮፖ፤ ባ ቦላካ ቃጪ ማዱንꬆፎ። ");
INSERT INTO gmve_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","ቄሴይ ዉሪካ ታስ ዱማ ጊዶ፤ ባንታ ጾሳ ሱንꬃ ቱኒሶፔቶ፤ ጋሶይካ ኢስቲ ጾሳስ ታማን ጹጌቲዛ ያርሾኔ ጎዳስ ካꬃ ያርሾ ሺሺዛይታ ጊዲዳ ጊሻስ ኢስቲ ጌሽ ጊዴቶ። ");
INSERT INTO gmve_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","« ‹ቄሴ ጊዲዳዴይ ላይማ ማጫስ ዎይኮ ጌላኦቴꬂ ኤኬቲዳ ጌላኦዮ ዎይኮ ጌላ ኬዚዳ ማጫስ ማቾ ኤኮፎ፤ ጋሶይካ ቄሴቲ ጾሳስ ዱማቲዳይታ፤ ");
INSERT INTO gmve_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ቄሴይ ኢንቴ ጾሳስ ካꬃ ያርሾ ሺሺዛይሳ ጊዲዳ ጊሻስ ኢዚ ሃራ ኣሳፔ ዱማ ጊዶ፤ ታኒ ኢንቴና ጌሺዛ ኢንቴ ጎዳይ ጌሻ፤ ኢዚካ ጌሽ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","ቄሴ ማጫ ናይ ላይማቲኮ ኢዛ ባ ኣዋ ካዉሺዳ ጊሻስ ታማን ጹጌታ ሃይቁ። ");
INSERT INTO gmve_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","« ‹ቄሴታ ሃላቃይ ኢዚ ባ ሁኤ ቲዬቲዛ ዛይቴይ ቲዬቲዳ ጊሻሲኔ ቄሴቴꬃ ማይኦ ማይኣና ማላ ዱማቲዳዴ ጊዲዳ ጊሻስ ኣሲ ሃይቂኮ ሃይቂዳዴስ ኢዚ ሚሼቲዛይሳ ኤሪሳናስ ባ ሁኤ ቢናና ቡጮፖ፤ ባ ማይኦካ ዳኮፎ። ");
INSERT INTO gmve_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","ኣሃይ ዲዛሶካ ኢዚ ጌሎፖ፤ ሃራይ ኣቶሺን ባ ኣዋ ዎይኮ ባ ኣዬይ ኣሃካ ቦቺዲ ባና ቱኒሶፖ። ");
INSERT INTO gmve_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","ኢዛ ዱማሳናስ ቲይዳ ጾሳ ዛይቴይ ኢዛ ቦላ ዲዛ ጊሻስ ቄሴይ ጾሳ ኬꬃፌ ኬዚ ቢዲ ጾሳ ኬꬃ ቱኒሶፖ። ");
INSERT INTO gmve_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","« ‹ቄሴይ ኤካና ማቻ ጌላኦ ጊዱ። ");
INSERT INTO gmve_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","ኣዚናይ ሃይቂዳሮ ዎይኮ ጌላ ኬዚዳሮ ዎይኮ ላይማ ማጫስ ኤኮፎ፤ ጌሎንታ ጌላኦ ጻላ ባ ዴሬ ኣሳ ጊዶፌ ዶሪ ኤኮ። ");
INSERT INTO gmve_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ሄሳꬆ ሂስቶንታ ኣጊኮ ኢዚ ባ ዴሬ ጊዶን ባ ናይታ ቱኒሳና፤ ኢዛ ዱማ ሻኪዳ ጎዳይ ታና ጾሳ› ጋ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","ጎዳይ ሙሴ ሂዝጊ ኣዛዚዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«ኣሮኔስ፥ ‹ኔ ቆሞታፔ ኢዛ ኣሳቴꬃ ቦላ ዎሶይ ዲዛዴይ ኦኒካ ታስ ያርሾ ሺሾፎ፤ ሃይሲ ሃ ዎጋይ ቡሮ ሲንꬃፌ ያና ዬሌታን ኡባን ናጌቲ ዴኦ። ");
INSERT INTO gmve_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","ፓጬ ኣሳቴꬂ ዲዛዴይ ኦኒካ ሄሲካ ቆቄይ ዎይኮ ዎቤይ ዎይኮ ሜꬎ ኢታይ ዎይኮ ኣሳቴꬃይ ቦርሲዛዴይ፥ ");
INSERT INTO gmve_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ኩሼይ ዎይኮ ቶሆይ ሲሊዳዴይ፥ ");
INSERT INTO gmve_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ዞኮ ቁናይ ዎይኮ ዲንኬይ፥ ኣይፌይ ሳኪዛዴይ ዎይኮ ኢዛ ቦላ ኡዛዚዛዚ ዲዛዴይ ዎይኮ ሹፋይ ካꬃ ያርሾ ታስ ሺሻናስ ቤሴና። ");
INSERT INTO gmve_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ኣሮኔ ዜሬꬅ ኩሜꬃ ጊዶፌ ኣሳቴꬃ ቦላ ዎሶይ ዲዛ ኣሲ ኦኒካ ጹጌቲዛ ያርሾኔ ያርሾ ባ ጎዳስ ያርሻናስ ዮፖ። ");
INSERT INTO gmve_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","ሄሳ ማላ ኣሲ ናምኡ ቆሞ ካꬃ ያርሾታ ማናስ ዳንዳዬስ፤ ሄይቲካ ዱማቲዳ ካꬂኔ ኬሂ ዱማቲዳ ያርሾ ካꬃ። ");
INSERT INTO gmve_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ጊዲኮካ ኢዛ ኣሳቴꬃን ቦሬይ ዲዛ ጊሻስ ታ ኬꬃ ቱኒሶንታ ማላ ኢዛዴይ ጌዴ ያርሾ ያርሺዛሶ ዎይኮ ጌዴ ማጋላሻኮ ሺቆፖ፤ ጋሶይካ ኢስታ ዱማ ኦꬃ ሻኪዳይ ታና ጾሳ› ጋዳ ዮታ።» ");
INSERT INTO gmve_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","ሙሴይካ ሄሳ ኡባ ኣሮኔሲኔ ኣሮኔ ናይታስ ኩሜꬃ ኢስራኤሌ ዴሬ ኣሳስ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","ጎዳይ ሙሴ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«ኣሮኔሲኔ ኢዛ ናይታስ፥ ‹ኢንቴ ሃራፔ ዱማ ጊዲዳ ታ ሱንꬃ ቱኒሶንታ ማላ ኢስራኤሌ ናይቲ ታስ ዱማሲዲ ሺሺዛ ያርሾ ኡባ ቦንቾራ ኤኪዲ ጌሻቴꬃን ናጊቴ፤ ታኒ ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","« ‹ኢንቴ ዜሬꬃፌ ቱኒዳዴይ ኢስራኤሌ ናይቲ ታስ ዱማ ሻኪ ኢሚዳ ሚሽ ጻላቴꬃን ቦቺዳዴይ ታ ሲንꬃፌ ꬋያና፤ ሃይሲ ሃ ዎጋይ ሃይሳፌ ጉዬ ሲንꬃራ ያና ዬሌታ ኡባን ናጌቶ፤ ታኒ ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","« ‹ኣሮኔ ዜሬꬃታፔ ኣይ ኣሲካ ኢዛ ቦላ ኣሳፔ ኣሳን ኣꬊዛ ጋልባ ሃርጌይ ዲዛዴይ ዎይኮ ኢዛ ኣሳቴꬃፌ ጎጊ ኬዚዛ ሚሺ ዲዛዴይ ኦኒካ ጌያና ጋካናስ ጾሳስ ዱማቲዳ ሚሽ ሞፖ፤ ኣሃይ ቦቺን ቱኒዳ ሚሽ ቦቺዳዴይ ዎይኮ ኢዛ ቦላፌ ዜሬꬃ ሃꬂ ጾኬቲዛዴ ቦቺዳዴይ፥ ");
INSERT INTO gmve_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ሄሳꬆካ ቢታራ ጎሼቲዛይታኔ ኣይ ሚሻንካ ቱኒዳ ኣስ ቦቺዳዴይ፥ ");
INSERT INTO gmve_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ሄሳ ማላ ኣይ ቱና ሚሺካ ቦቺዳዴይ ኦማርስ ጋካናስ ቱና ጊዴስ፤ ሄሳፌ ጉዬ ኢዚ ባ ቦላ ሃꬃን ሜጬቶንታ ዲሼ ጾሳስ ዱማቲዳ ካꬅ ሞፖ። ");
INSERT INTO gmve_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","ኣርሼይ ዉሊዳፔ ጉዬ ቃሴ ኢዚ ጌሽ ጊዴስ፤ ሄሳፌ ጉዬ ዱማ ጊዲዳ ካꬃ ያርሾዛ ኢዛስ ቁማ ጊዲዳ ጊሻስ ማናስ ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","ባዉቲ ሃይቂዳዚኔ ዶኣይ ዎꬊዳ ሜሄ ኣሾ ሞፖ፤ ኢዚ ሄሳ ሚዛዝ ጊዲኮ ቱኔስ፤ ታኒ ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","« ‹ቄሴቲ ታኒ ኢስታስ ኢሚዳ ዎጋ ናጌቶ፤ ኢስቲ ናጎንታ ኣጊኮ ጌሽ ጊዲዳ ታ ኣዛዞታስ ኣዛዜቶንታ ኢጺዳ ጊሻስ ኢስታስ ቆሆ ጊዲን ኢስቲ ሃይቃና፤ ኢስታ ዱማሳ ሻኪዳይ ታና ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","« ‹ታስ ዱማቲዳ ያርሾፌ ማናስ ዳንዳይዛይ ቄሴታኔ ኢስታሶ ኣስ ጻላ ኣቲን ሃራ ኣሲ ኢዛፔ ሞፖ፤ ቄሴራ ኢማꬂ ዎይኮ ኦሶስ ቃጻሬቲዲ ኢዛራ ዲዛዴይካ ሞፖ። ");
INSERT INTO gmve_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ጊዶ ኣቲን ቄሴይ ባ ሚሻን ሻሚዳ ኣይሌይ ዎይኮ ሶን ዬሌቲዳ ኣይሌይ ቄሴዛ ጊሻፔ ሞ። ");
INSERT INTO gmve_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ቄሴ ጊዶንታ ሃራ ኣስ ጌሊዳ ቄሴዛ ናያ ጾሳስ ዱማቲዳ ያርሾፌ ሙፑ። ");
INSERT INTO gmve_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ጊዶ ኣቲን ና ዬሎንታ ዲሺን ኢዚ ኣዚናይ ሃይቂዳራ ዎይኮ ባ ኣዚናፔ ኣንጄታዳ ባ ኣዋ ሶ ሲማዳ ዲዛ ቄሴ ናያ ካሴ ኢዛ ናቴቴꬃ ዎዴ ኦꬂዛ ማላ ባ ኣዋ ጊሻፔ ሙ፤ ጊዲኮካ ቄሴሶ ኣሳፔ ኣቲን ሃራ ኣሲ ዱማቲዳ ያርሾ ካꬃፌ ሞፖ። ");
INSERT INTO gmve_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","« ‹ቄሴሶ ኣስ ጊዶንታዴይ ኦኒካ ኤሮንታ ዲሼ ጎዳስ ዱማቲዲ ኢሜቲዳ ሚሽ ሚኮ ሄ ኢዚ ሚዳይሳ ኩሜꬃ ዎጋ ጼታፔ ናምኡ ኩሼ ጉጂዲ ቄሴዛስ ቃንጾ። ");
INSERT INTO gmve_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","ኢስራኤሌ ናይቲ ጾሳስ ኢሚዛ ዱማ ያርሾታ ቄሴቲ ቱኒሳናስ ቤሴና። ");
INSERT INTO gmve_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ሄሲካ ኢዛፔ ማናስ ቤሶንታዴስ ቄሴቲ ኢሚኮ ሄ ሚዳዴስ ሞሮ ጊዲዲ ኢዛዴ ቦላ ሃንቆ ጋꬃና፤ ኢሞታታ ኡባ ታስ ዱማሲዳይ ታና ጎዳ› ጋ ዮታ።» ");
INSERT INTO gmve_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","ጎዳይ ሙሴ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«ኣሮኔስ ኢዛ ናይታሲኔ ኢስራኤሌ ዴሬ ኡባስ፥ ‹ኢስራኤሌ ኣስ ጊዲዳይ ዎይኮ ኢስራኤሌ ናይታ ጊዶን ዲዛ ኢማꬃ ኣሲ ኣዲና ጋꬃናስ ዎይኮ ኢዚ ጮ ኡፋይሳን ሜላ ኢሚዛ ጹጌቲዛ ያርሾ ሺሺኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ኢዛ ያርሾይ ኤኬታና ማላ ኢሲ ቦሬይ ኢዛ ቦላ ባይንዳ ኮርማ ቦራፔ፥ ꬋርሾፌኔ ዴይሻ ኦርጌፌ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","ኢዛ ቦላ ዎሶይ ዲዛ ሜሄ ኢንቴ ሺሺኮ ጎዳይ ሄሳ ኤኬና። ");
INSERT INTO gmve_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","« ‹ቃሴ ኦና ጊዲኮካ ባ ኣዲና ጋꬃናስ ኢሲፌቴꬃ ያርሾ ጎዳስ ያርሺዛ ዎዴ ዎይኮ ባ ዶሳን ባ ሜሄታፔ ኪያቴꬃ ኢሞታ ኢሚዛ ጊዲኮ ሄ ኢሞታ ኤካና ማላ ኢዚ ኢሚዛ ሜሄዛ ቦላ ኣይኮ ዎሶይ ባይንዳዝ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","ቆቄ ዎይኮ ሜቆ ዎይኮ ቂሻ ዎይኮ ጊይዛ ማዱንꬃራ ዲዛ ዎይኮ ጋራንዳ ዎይኮ ሻቶራ ዲዛ ሜሄ ጎዳስ ያርሾ ሺሾፋ፤ ሄሳንታ ማላ ሜሄ ያርሾ ያርሺዛሶዛን ጹጌቲዛ ያርሾ ሂስታ ያርሾፋ። ");
INSERT INTO gmve_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","ኢዛስ ሜꬌቴꬂ ዎጋይ ባይንዳ ኣዱሳ ዎይኮ ቃንꬅ ጊዲዳ ሜሄ ባ ዶሳን ኢሚዛ ኪያቴꬃ ኢሞታ ጊዲዲ ሺቃናስ ዳንዳዬስ፤ ጊዶ ኣቲን ኣዲና ጋሶስ ሺሻናስ ዳንዳዬና። ");
INSERT INTO gmve_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ሳንጌቲዳ ዎይኮ ꬊቄቲዳ ሜሄ ጎዳስ ያርሾ ሺሾፍቴ፤ ኢንቴ ቢታን ሄይታንታ ማላ ያርሾፍቴ። ");
INSERT INTO gmve_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ኣላጋ ኣሳፔ ኢሜቲዳ ሜሄ ጾሳስ ያርሾ ሺሾፍቴ፤ ሄይታንታ ማላ ሜሄቲ ቦሬይ ዲዛ ማላ ቆዴቲዛ ጊሻስ ኢስቲ ኤኬቴቴና› ጋ ዮታ።» ");
INSERT INTO gmve_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«ሚዛ ማሪ ዎይኮ ዶርሳ ላቃይ ዎይኮ ዴይሻ ላቃይ ዬሌቲኮ ላፑን ጋላስ ጋካናስ ባ ኣይፔ ሻኬቶፎ፤ ጊዶ ኣቲን ኦስፑንꬃ ጋላሳፌ ኦይኪዲ ጹጌቲዛ ያርሾስ ሺቃናስ ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","ሚዝ ኢዚ ማራራ፥ ዶርስ ኢዚ ላቃራ ኢሲ ጋላስ ያርሾስ ሹኮፍቴ። ");
INSERT INTO gmve_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","«ኢንቴ ጎዳስ ጋላታ ያርሾ ያርሺዛ ዎዴ ኢንቴ ሺሺዛ ጋላታዚ ኤኬታና ማላ ኦꬂ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ኢንቴ ሺሺዳይሳፌ ኣይኮካ ዎንቶስ ኣሾንታ ሄ ጋላስ ኡባ ሚቺቴ፤ ታኒ ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«ኢንቴ ታ ኣዛዞታ ናጊቴኔ ኦꬂቴ፤ ታኒ ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","ታ ጌሻ ሱንꬃ ቱኒሶፒቴ፤ ታ ጌሻቴꬃ ኩሜꬃ ኢስራኤሌ ኣሳይ ኤሪዲ ታና ቦንቾ፤ ኢንቴና ዱማሲዳይ ታና ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ኢንቴ ጾሳ ጊዳናስ ኢንቴና ጊብጼ ቢታፌ ኬሲዳይ ታና፤ ታኒ ጎዳ ኢንቴ ጾሳ።» ");
INSERT INTO gmve_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","ጎዳይ ሙሴ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«ኢስራኤሌ ኣሳስ ዱማ ሺቆ ጊ ኣዋጂዲ ኢንቴ ቦንቻናስ ቤሲዛ ዶሬቲዳ ባኣሌቲ ሃይሳፌ ካሊ ዲዛይታ፤ ");
INSERT INTO gmve_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","«ኢንቴ ኢንቴስ ኦꬃናስ ኡሱፑን ጋላሳቲ ዴቴስ፤ ላፑንꬃ ጋላሳይ ጊዲኮ ኢንቴስ ሼምፒዛ ሳምባታ ጋላሳ፤ ሄ ጋላስ ኢንቴ ጾሳ ጎይናናስ ሺቂቴ ኣቲን ኣይ ኦሶካ ኦꬆፍቴ፤ ኢንቴ ዲዛሶ ኡባን ሄሲ ኢንቴ ጾሳ ቦንቻና ሳምባታ ጋላሳ። ");
INSERT INTO gmve_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«ኢስታስ ዎꬊዳ ዎዴን ጌሻ ሺቆ ኦꬂ ኣዋጂዲ ኢንቴ ቦንቻናስ ቤሲዛ ጎዳ ባኣሌቲ ሃይሳፌ ካሊዛይታ፥ ");
INSERT INTO gmve_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ጎዳይ ኢዛን ቦንቼቲዛ ፓዚጋ ባኣሌይ ኮይሮ ኣጊናይ ጌሊዳ ታማኔ ኦይዳንꬆ ጋላስ ኣርሼይ ዉሊን ጋዴይ ሌምኢ ሌምኢሺን ኦይኬቴስ። ");
INSERT INTO gmve_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ሄ ኣጊናዛን ታማኔ ኢቻሻንꬆ ጋላስ ኡኬꬃ ባኣሌይ ኦይኬቴስ፤ ሄሳፌ ጉዬ ላፑን ጋላስ ጋካናስ ኢርሾይ ጌሎንታ ኡኬꬅ ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ሄ ጋላሳታፔ ኮይሮ ጋላስ ጾሳ ጎይናናስ ሺቂቴ፤ ሄ ጋላስ ኢንቴ ኦሶ ኦꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ላፑን ጋላስ ጋካናስ ጹጌቲዛ ያርሾ ጎዳስ ሺሺቴ፤ ኢንቴ ኦሶ ኣጊዲ ላፑንꬃ ጋላስ ጎዳ ጎይናናስ ሺቂቴ።» ");
INSERT INTO gmve_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","ጎዳይ ሙሴ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«ኢስራኤሌ ኣሳስ ታኒ ኢንቴስ ኢሚዛ ቢታ ጌሊዲ ኢንቴ ካꬅ ሺሺዛ ዎዴ ካꬃ ጼራ ቄሴኮ ኤሂቴ። ");
INSERT INTO gmve_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ጎዳ ሲንꬃን ኢንቴ ሺሺዛይሲ ኤኬታና ማላ ቄሴዚ ቃሴ ካꬃ ጼራ ኤኪዲ ያኔ ሃ ቃꬂዛ ያርሾ ሂስቲ ጾሳስ ሺሾ፤ ቄሴዚ ሄ ጼራ ካꬃ ያኔ ሃ ቃሴꬂዛ ያርሾ ሂስቲ ሺሻናስ ቤሲዛይ ሳምባታ ጋላሳፌ ዎንቴꬃ ጋላስ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ኢንቴ ሄ ያርሾ ሺሺዛ ጋላስ ኢዛ ቦላ ቦሬይ ባይንዳ ኢሲ ላይꬃ ꬋርሾ ላቃ ጹጌቲዛ ያርሾ ኦꬂዲ ኢሲ ቦላ ጾሳስ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ኢዛራ ኢሲፌ ዎጋራ ሚꬃ ዛይቴን ሙኑቄቲዳ ናምኡ ኪሎ ጊዲዛ ሊቆ ꬊሌ ካꬃ ያርሾ ሂስቲ ሺሺቴ፤ ሄሲካ ኢዛ ሳዎይ ጎዳ ኡፋይሲዛ ጹጌቲዛ ያርሾ ጊዳና፤ ኢዛራ ኢሲፌ ኢሲ ሊቲሮ ጊዲዛ ዎይኔ ኡሹ ኢሞታ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","ኢንቴ ሄይታ ጎዳስ ኢማናፔ ኮይሮ ጋኪዳ ካꬃ ኣይፌ ቃዬ ጊዲን ዎይኮ ሻሽ ዎይኮ ኡኬꬅ ኡኪዲ ሞፒቴ፤ ሃይሳ ሃ ዎጋዛ ኢንቴ ዲዛሶ ኡባን ጉዬፔ ያና ኢንቴ ዬሌታስ ኤቂ ዲዛ ሜርና ዎጋ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","«ኢንቴ ጎዳስ ያኔ ሃ ቃሴꬂ ሺሺዛ ያርሾ ያርሺዳ ሳምባታ ጋላሳ ዎንቴꬃፌ ዶሚዲ ላፑን ሳምባታ ቆዲቴ፤ ");
INSERT INTO gmve_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ላፑንꬃ ሳምባታፔ ጉዬ ኢቻሽ ታማንꬆ ጋላስ ቃሴካ ሃራ ኦራꬃ ካꬃ ያርሾ ጎዳስ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ናምኡ ኪሎ ጊዲዛ ሊቆ ꬊሌ ኢንቴ ሶፔ ኢርሾን ሙኑቄቲ ኡኬቲዳ ናምኡ ኡኬꬅ ያኔ ሃ ቃሴꬂዛ ያርሾ ሂስቲ ኤኪ ዪቴ፤ ሄሲካ ኦራꬅ ሺቂዛ ካꬃ ጊሻስ ጾሳስ ሺቂዛ ካꬃ ያርሾ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","ሄ ኡኬꬃራካ ኢሲፌ ኢስታ ቦላ ዎሶይ ባይንዳ ኢሲ ላይꬅ ጊዲዛ ላፑን ꬋርሾ ላቃታ ኢሲ ኮርማ ቦራራ ናምኡ ꬋርሾታ ሺሺቴ፤ ካꬃ ያርሾዛራኔ ዎይኔ ኡሻ ያርሾዛራ ኢሲፌ ጎዳስ ጹጌቲዛ ያርሾኔ ሳዎ ቱኑ ጊዛ ያርሾ ሂስቲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ቃሴካ ናጋራ ጊሻስ ሺቂዛ ያርሾስ ኢሲ ዴይሻ ኦርጌ፥ ኢሲፌቴꬃ ያርሾስ ኢሲ ላይꬅ ꬋርሾ ላቃ ናምኣታ ያርሾስ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","ቄሴይ ኡኬꬃ ናምኡ ላቃታራ ያኔ ሃ ቃሴꬂዲ ጎዳስ ዱማ ያርሾ ሂስቲ ሺሾ፤ ሄሲካ ቄሴታ ጊሻ ጊዶ፤ ሄይቲ ሄ ኢሞታቲ ሃራፔ ዱማ ኢሞታ። ");
INSERT INTO gmve_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ሄ ጋላስ ኣዋጃ ኣዋጂዲ ጎዳ ጎይናናስ ኢሲ ቦላ ሺቂቴ ኣቲን ሃራ ኦሶ ኦꬆፍቴ፤ ሃይሲ ኢንቴ ዲዛሶ ኡባን ኢንቴፌ ጉዬራ ዪዛ ዬሌታስ ሜርናስ ኤቂ ዲዛ ዎጋ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","ኢንቴ ኢንቴ ቢታን ካꬅ ሺሺዛ ዎዴ ꬋሳ ቦላ ዲዛ ካꬃ ማጾፒቴ፤ ማጺሺን ጉዬን ኣቲዳይሳ ማጻናስ ጉዬ ሲሞፍቴ፤ ጉዬን ኣቲዳይሲ ማንቆታሲኔ ሃራ ቢታፌ ቤቴ ዪዳ ኣሳታስ ኣቶ፤ ታኒ ጎዳ ኢንቴ ጾሳ።» ");
INSERT INTO gmve_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«ኢስራኤሌ ኣሳስ ላፑንꬃ ኣጊናይ ጌሊዳ ኮይሮ ጋላሳይ ኢንቴስ ሼምፖ ጋላስ ጊዶ፤ ሄ ዎዴ ዛዬይ ፑኔቲሺን ኢንቴ ጎዳ ጎይናናስ ሺቂዛ ዱማ ሺቆ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ሄ ጋላስ ጎዳስ ታማን ጹጌቲዛ ካꬃ ያርሾ ሺሺቴ ኣቲን ሄ ጋላስ ኣይኮካ ኦꬆፍቴ።» ");
INSERT INTO gmve_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«ላፑንꬆ ኣጊናይ ጌሊዳፔ ጉዬ ታማንꬃ ጋላሳይ ናጋራፔ ማሬቴꬃ ጋላሳ፤ ሄ ጋላስ ኣይ ካꬂካ ሞፒቴ፤ ጎዳ ጎይናናስ ሺቂቴ፤ ጾሳስ ታማን ጹጌቲዛ ያርሾ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ሄ ጋላሳይ ጎዳ ኢንቴ ጾሳ ሲንꬃን ኣሳ ናጋራ ዉርሶ ጋላስ ጊዲዳ ጊሻስ ሄ ጋላስ ኣይኮካ ኦꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ሄ ጋላስ ባናቴꬃ ካዉሺዲ ማሬቶንታ ኣይ ኣሲካ ዴራ ጊዶፌ ሻኬቲ ꬋዮ። ");
INSERT INTO gmve_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ሄ ጋላስ ኣይ ኦሶ ጊዲን ኦꬂዛዴ ታኒ ኢዛ ኢዛ ዴራ ጊዶፌ ሻካ ꬋይሳና፤ ");
INSERT INTO gmve_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","ሄሳ ጊሻስ ሄ ጋላስ ኢንቴ ኣይ ኦሶካ ኦꬆፍቴ፤ ሃይሲ ሃ ዎጋዚ ኢንቴ ዲዛሶ ኡባን ኢንቴፌ ጉዬ ያና ኢንቴ ዬሌታስ ኤቂ ዲዛ ሜርና ዎጋ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ሄ ኣጊናይ ጌሊዳ ኡዱፉንꬆ ጋላሳ ኦማርሳፌ ቢዲ ታማንꬆ ጋላሳ ኦማርስ ጋካናስ ኢንቴናቴꬃ ካዉሺዲ ሄ ጋላሳ ሳምባታ ሂስቲ ቦንቺቴ።» ");
INSERT INTO gmve_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«ጎዳስ ዳሴ ባኣሌይ ላፑንꬃ ኣጊናይ ጌሊዳ ታማኔ ኢቻሻንꬆ ጋላሳፌ ዶሚዲ ላፑን ጋላስ ጋካናስ ቦንቼቶ። ");
INSERT INTO gmve_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ሄ ጋላሳታፔ ኮይሮ ጋላስ ጎዳ ጎይናናስ ሺቂቴ ኣቲን ኣይ ኦሶካ ኦꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ላፑን ጋላሳታን ኢሳን ኢሳን ጎዳስ ጹጌቲዛ ያርሾ ሺሺቴ፤ ኦስፑንꬃ ጋላስ ቃሴካ ጎዳ ጎይናናስ ሺቂቴ፤ ጎዳስ ጹጌቲዛ ካꬃ ያርሾ ያርሺቴ፤ ሄ ጋላሳይ ኢንቴ ሺቆዛ ዉርሲዛ ጋላስ ጊዲዳ ጊሻስ ሄ ጋላስ ኣይኮካ ኦꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","«ኢንቴ ታማን ጹጌቲዛ ያርሾኔ ካꬃ ያርሾ ቃሴ ሃራ ያርሾታ ኡባኔ ኡሻ ያርሾ ኮሺዛ ኬና ዎꬂዳ ጋላሳን ጎዳስ ሺሻናስ ኢንቴ ጌሻ ሺቆ ኦꬂዲ ኣዋጃናስ ቤሲዛ ጎዳስ ዶሬቲዳ ባኣሌቲ ሃይታንታ። ");
INSERT INTO gmve_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ሃይቲ ሃ ያርሾቲ ጎዳ ሳምባታ ጋላሳታን ኢንቴ ሺሺዛይታፔ ጾሳስ ኢሚዛ ኢሞታታፔ ኣዲና ጋꬂዛይታፔኔ ኢንቴ ኢንቴ ዶሳን ጮ ኢሚዛይታፔ ቦላራ ጉጂዲ ኢንቴ ኢሚዛ ኢሞታታ። ");
INSERT INTO gmve_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","«ኢንቴ ካꬅ ሺሺዳፔ ጉዬ ላፑንꬃ ኣጊናይ ጌሊዳ ታማኔ ኢቻሻንꬃ ጋላስ ኮይሮራ ሃይሳ ኡፋይሳ ባኣሌዛ ጎዳ ሲንꬃን ላፑን ጋላስ ጋካናስ ቦንቺቴ፤ ኮይሮ ጋላሲኔ ኦስፑንꬃ ጋላሳይ ኢንቴስ ዱማ ሼምፖ ጋላስ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ሄ ኮይሮ ጋላስ ኢንቴ ቢታን ካጺዛ ሎኦ ሚꬃ ኣይፌፔ፥ ዛምባ ሃይꬅ፥ ጪሊላ ሚꬃ ሃጋኔ ሃꬂናጌ ሚꬃ ሃጋ ኦይኪዲ ጎዳ ኢንቴ ጾሳ ሲንꬃን ኡፋዬቲሼ ላፑን ጋላስ ጋካናስ ባኣሌ ኦꬂቴ። ");
INSERT INTO gmve_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ሃይሳካ ላይꬃን ላይꬃን ላፑንꬃ ኣጊናን ላፑን ጋላስ ጋካናስ ጎዳ ሲንꬃን ቦንቺቴ፤ ሃይሲ ሃ ዎጋይ ኢንቴስ ና ና ጋካናስ ሜርና ዎጋ ጊዲ ቦንቼቶ። ");
INSERT INTO gmve_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ኩሜꬃ ኢስራኤሌ ዴሬይ ላፑን ጋላስ ጋካናስ ዳሴን ኡቶ። ");
INSERT INTO gmve_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ሃይሳንካ ታኒ ኢስራኤሌ ናይታ ጊብጼ ቢታፌ ኬሲዳ ዎዴ ኢስቲ ዳሴን ኡታና ማላ ታ ኦꬂዳይሳ ኢንቴፌ ጉዬ ዪዛ ዬሌታይ ኤራና። ታኒ ጎዳ ኢንቴ ጾሳ።» ");
INSERT INTO gmve_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","ሙሴይ ሃይሳꬆ ኦꬂዲ ጎዳ ባኣሌታ ቦንቺዛ ዎጋ ኢስራኤሌ ኣሳ ኤሪሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«ዱንካኔዛን ፓጬይ ባይንዳ ፖኣና ማላ ኦꬃናስ ዎጋራ ሚꬃፌ ጉምኢ ጺሊሲ ኬሲዳ ዛይቴ ኢስራኤሌ ዴሬ ኣሳይ ኔስ ኤሃና ማላ ኣዛዛ። ");
INSERT INTO gmve_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","ኣሮኔይ ኦማርስ ኦማርስ ጾምፔዛ ኦይሴꬆ፤ ሄሲካ ጋይቶቴꬃ ዱንካኔዛ ጊዶን ዲዛ ጫቆ ቃላ ታቦታዛፔ ሲንꬃ ባጋራ ዲዛ ማጋላሻፔ ካሬ ባጋራ ጎዳ ሲንꬃን ጋዴይ ዎንታና ጋካናስ ፖኢሼ ኣቆ፤ ሃይሲ ሃ ዎጋዚ ሲንꬃፌ ያና ዬሌታስ ሜርና ዎጋ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","ኣሮኔይ ሄ ጾምፔታ ዎꬂዛ ዋላካይ ባይንዳ ዎርቃፌ ኦሴቲዳ ባላዛ ቦላ ዲዛ ጾምፔቲ ፓጬይ ባይንዳ ጎዳ ሲንꬃን ፖኣና ማላ ናጎ። ");
INSERT INTO gmve_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«ታማኔ ናምኡ ኪሎ ጊዲዛ ሊቆ ꬊሌ ኤካዳ ታማኔ ናምኡ ኡኬꬅ ኡካ። ");
INSERT INTO gmve_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ኡኬꬃታፔ ኡሱፑናታ ቦላራ ዋላካይ ባይንዳ ዎርቃን ቲዬቲዳ ጻራጴዛ ቦላ ኢሲ ባጋራ ዎꬃ፤ ቃሴ ሃንኮ ኡሱፑናታ ሃንኮ ባጋራ ዲዛ ማዳ ቦላ ማራን ማራን ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ጎዳስ ታማን ጹጌቲ ያርሼቲዛ ካꬃ ያርሾ ጊዲዳይሳ ቆፍሳናስ ሙሩታ ኤጻኔ ናምኡ ባጋራካ ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ሃይሳ ሃ ኡኬꬃዛ ሳምባታን ሳምባታን ኡባ ዎዴ ኣሮኔይ ጎዳ ሲንꬃን ኢስራኤሌ ኣሳ ጊሻስ ዎꬆ፤ ሃይሲ ኢስራኤሌ ኣሳይ ፓጬይ ባይንዳ ኦꬃና ማላ ቤሲዛ ጫቆ ቃላ። ");
INSERT INTO gmve_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ኡኬꬃይ ኣሮኔሲኔ ኢዛ ዜሬꬃታስ ጊሻ ጊዶ፤ ኢስቲ ኡኬꬃ ጎዳስ ዱማቲዳሶን ሜቶ፤ ሄሲካ ጎዳስ ታማን ጹጌቲ ሺቂዛ ያርሾታፔ ኬሂ ዱማቲዳ ኣሮኔሲኔ ኢዛ ዜሬꬃታስ ኢሜቲዳ ጊሻ ጊዶ።» ");
INSERT INTO gmve_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ኣዪ ባጋራ ኢስራኤሌ፥ ኣዋ ባጋራ ጊብጼ ዴሬ ኣስ ጊዲዳ ኢሳዴይ ዴስ፤ ኢዚካ ኢሲ ጋላስ ባ ዲዛ ሄራን ዲዛ ኢሲ ኢስራኤሌ ኣስ ጊዲዳሪራ ኦዬቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ሄ ኣዬይ ባጋራ ኢስራኤሌ ኣስ ጊዲዳይሲ ኦዬቲሼ ጎዳ ሱንꬅ ጫዪዴስ፤ ሂስቲን ኢዛዴ ሙሴኮ ኤሂዳ፤ ሄ ኣዴዛ ኣያ ዳኔ ባጋፌ ጊዲዳ ዲብራዬ ና ሻሎሚቶ ጌቴታዉስ። ");
INSERT INTO gmve_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ኢስቲ ኢዛ ቦላ ኣይ ቂጻቴ ዬጋናስ ቤሲዛኮ ጎዳይ ኢስታስ ዮታና ጋካናስ ኢዛ ቃሾ ኬꬃን ዬጊዳ። ");
INSERT INTO gmve_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«ሄ ኣዴዛ ኣሳይ ዲዛሶፔ ጌዴ ሃራሶ ኬሳ፤ ኢዚ ጾሳ ጫዪሺን ሲዪዳ ኡባይ ሄሳዴይ ሞሮ ኦꬂዳይሳ ማርካታናስ ኢሶይ ኢሶይ ባ ኩሼ ሄ ኣዴዛ ሁኤ ቦላ ዎꬆ፤ ሄሳፌ ካሊዲ ኩሜꬃ ኢስራኤሌ ዴሬይ ኢዛ ሹቻን ጫዲ ዎꬎ። ");
INSERT INTO gmve_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ታና ጾሳ ጫዪዳ ኣይ ኣሲካ ሄሳꬆካ ባ ቂጻቴ ኤኮ። ");
INSERT INTO gmve_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ጎዳ ጫዪዳ ኣይ ኣስ ጊዲንካ ዴሬይ ኡባይ ኢዛ ሹቻን ጫዲ ዎꬎ፤ ኢስራኤሌ ኣስ ጊዲን ዎይኮ ኢስራኤሌ ዴሬ ጋርሳን ዲዛ ሃራ ዴሬ ኣስ ጊዲን ጎዳ ጫዪዳዴይ ሹቻን ጫዴቲ ሃይቆ። ");
INSERT INTO gmve_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","«ኣሴ ዎꬊዳዴይ ኦኒካ ሃይቆን ቃጻዬቶ። ");
INSERT INTO gmve_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ኣሳ ሜሄ ዎꬊዳዴይ ኢዛ ማላ ሜሄ ቃንጾ፤ ሄሲ ሄ ዋጋዚ ሼምፖ ጊሻስ ሼምፖ ቃንጺዛ ዎጋ። ");
INSERT INTO gmve_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","«ኣይ ኣሲካ ሃራ ኣሳ ቦላ ቆሆ ጋꬂኮ ኢዛዴይ ቆሆ ጋꬂዳይሳ ማላ ቆሆይ ሄ ጋꬂዳዴ ቦላ ጋኮ። ");
INSERT INTO gmve_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ሜቄꬅ ሜንꬂዳዴስ ሜቄꬂ ሜቆ፤ ኣይፌ ቶይሲዳዴስ ኣይፌይ ቶኦ፤ ኣች ሜንꬂዳዴስ ኣቺ ሜቆ፤ ሃራ ኣሳ ቦላ ኣይ ቆሆካ ጋꬂዳዴስ ኢዚ ጋꬂዳ ቆሆዛ ማላይ ኢዛ ቦላ ጋኮ። ");
INSERT INTO gmve_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ሜሄ ዎꬊዳዴይ ሜሄ ቃንጾ፤ ኣሴ ዎꬊዳዴይ ጊዲኮ ሃይቆን ቃጻዬቶ። ");
INSERT INTO gmve_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","ሃይሲ ዎጋዚ ኢንቴስ ኢስራኤሌ ናይታስ ጊዲን ዎይኮ ኢንቴ ጊዶን ዲዛ ሃራ ዴሬ ኣሳ ኡባሳ፤ ጋሶይካ ታኒ ጎዳ ኢንቴ ጾሳ።» ");
INSERT INTO gmve_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ሙሴይ ሄሳ ኡባ ዴሬዛስ ዮቲ ፖሊዳፔ ጉዬ ሄ ጾሳ ጫዪዳ ኣዴዛ ኣሲ ዲዛሶፔ ሃራሶ ኬሲዲ ሹቻራ ጫዲ ዎꬊዳ፤ ሄሳꬆካ ኢስራኤሌ ኣሳይ ጎዳይ ሙሴ ኣዛዚዳ ማላ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","ጎዳይ ሲና ዙማ ቦላን ሙሴ ሂዝጊ ኣዛዚዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«ኔ ኢስራኤሌ ኣሳስ፥ ‹ታኒ ኢንቴስ ኢሚዛ ቢታ ኢንቴ ጌሊዛ ዎዴ ላፑንꬃ ላፑንꬃ ላይꬃን ቢታ ጎዮንታ ሻቺ ሼምፒሶን ጾሳ ቦንቺቴ። ");
INSERT INTO gmve_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ኡሱፑን ላያꬅ ኩሜꬅ ጎዪቴኔ ዜሪቴ፤ ዎይኔ ሚꬃይ ሎኤꬂ ኣይፋና ማላ ቂርጺቴ፤ ኣይፌካ ማጺ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ጊዶ ኣቲን ላፑንꬃ ላይꬃይ ታስ ጾሳስ ዱማ ጊዲን ቢታይ ሼምፖ ዴሚዛ ላይꬅ ጊዶ፤ ሄ ላይꬅ ቢታ ጎዮፒቴ፤ ዎይኔ ሚꬃይካ ኣይፋና ማላ ቂርጾፍቴ። ");
INSERT INTO gmve_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","ኢንቴ ዜሮንታ ኣዛባ ጫሪዳ ካꬃ ኢንቴስ ማጺ ሺሾፍቴ፤ ሄ ላይꬃይ ቢታያ ሙሌራ ሼምፒዛ ላይꬃ። ");
INSERT INTO gmve_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","ሄ ላይꬅ ኢዛ ኣይኮካ ጎዮንታ ኣጊኮካ ቢታያ ኢንቴስ ኢንቴ ኣይሌታሲኔ ኢንቴስ ሚሻራ ኦꬂዛይታስ፤ ቃሴካ ሃራ ዴሬፔ ዪዲ ኢንቴናራ ዲዛ ሃራ ዬሌታታስ ሚዛዝ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ኢንቴ ሜሄታሲኔ ኢንቴ ቢታ ቦላ ዲዛ ዶኣታሳራ ሜቴቲዛዝ ቢታያ ኢማና፤ ሄ ኢዛ ኢሚዛይሲ ኡባይ ኢስታስ ሜቴቲዛዝ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","« ‹ላፑንቶ ላፑን ላይꬅ ቆዳ፤ ሄ ላይꬃታ ቆዳይ ኦይዱ ታማኔ ኡዱፉን ላይꬅ ጊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ላፑንꬆ ኣጊናይ ጌሊዳፔ ታማንꬃ ጋላስ ቦንቼቲዛ ናጋራፔ ማሬቴꬃ ጋላስ ኩሜꬃ ቢታ ቦላ ዛዬ ዛያናዴ ዬዲቴ። ");
INSERT INTO gmve_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","ሄሳꬆካ ኢቻሽ ታማንꬆ ላይꬃ ዱማሲ ሻኪዲ ቢታይ ቦላ ዲዛይታስ ኡባስ ዎዜቴꬅ ኣዋጂቴ፤ ሃይሳፌ ካሴ ባይዜቲዳ ጋዴይ ካሴ ባይዚዳዴስ ዎይኮ ኢዛዴ ቆሞስ ሲሞ፤ ኣይሌቴꬃን ባይዜቲዳ ኣይሌይካ ካሴ ባ ኣሳኮ ሲሞ። ");
INSERT INTO gmve_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","ሄ ላይꬅ ጎሼ ጎዪዲ ዜሬꬅ ዜሮፒቴ፤ ዜሬꬅ ዜሮንታ ጮ ኣዛባ ካጺዳ ካꬅ ዎይኮ ቂርጼቶንታ ኣይፊዳ ዎይኔ ሚꬃ ኣይፌ ማጺ ሺሾፍቴ። ");
INSERT INTO gmve_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ሄ ላይꬃይ ኩሜꬅ ኢንቴስ ዱማ ሻኬቲዳ ላይꬅ ጊዶ፤ ካሴ ኢንቴ ዜሮንታ ጮ ባርካ ካጺዳ ካꬅ ጻላ ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","« ‹ሃይሳፌ ካሴ ባይዜቲዳ ጋዴይ ኡባይ ሄ ዎዞ ላይꬃን ጋዳዴስ ሲሞ። ");
INSERT INTO gmve_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","ሄሳ ጊሻስ ኔ ኣሾ ጊዲዳ ኢስራኤሌ ኣሳ ኔኒ ጋዴ ባይዚዳዝ ጊዲኮ ዎይኮ ኔ ሃ ኔስ ሻሚዳዝ ጊዲኮ ጌኔ ኦሶ ኦꬆፋ። ");
INSERT INTO gmve_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","ጋዴዛ ዋጋይ ሄሬጌታናስ ቤሲዛይ ሲንꬃፌ ቢታይ ሲሚዛ ላይꬃይ ጋካናፔ ካሴ ሄ ጋዴይ ኢማና ዳንዳይዛ ካꬃ ቆፒ ሄሬጋናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ላይꬃይ ዳሮ ጊዲኮ ሄሬጋይካ ዳሮ ጊዶ፤ ላይꬃይ ጉꬅ ጊዲኮ ሄሬጋይካ ጉꬅ ጊዶ፤ ጋዴይ ባይዜቲዛ ዋጋይ ጋዴዚ ኢሚዛ ካꬃ ማላ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ኢሲ ኢስራኤሌ ኣሲ ሃራ ኢስራኤሌ ኣስ ቆሆፖ፤ ኢንቴ ኢንቴ ጾሳስ ያዪቴ፤ ታኒ ጎዳ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","« ‹ኢንቴ ኢንቴ ቢታ ቦላ ሳሮን ዴኣና ማላ ጾሳ ዎጋ ኡባ ቦንቺቴ። ");
INSERT INTO gmve_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ቢታያ ኢንቴስ ጊዳና ካꬅ ኢማና፤ ኢንቴካ ኢዚፔ ካላና ጋካናስ ማና፤ ሳሮቴꬃንካ ዴኣና። ");
INSERT INTO gmve_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","« ‹ጊዶ ኣቲን ላፑንꬃ ላይꬃን ጎሼ ጎዮንታኔ ካꬅ ዜሮንታ ማጾንታ ኣይ ማኔ?› ጊዲ ኦይቺዛ ኣሲ ዶንታ ኣጌና። ");
INSERT INTO gmve_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ኡሱፑንꬃ ላይꬃታን ቢታዮ ኣንጃና፤ ሂስቲኮ ኢዛ ኢንቴስ ሄꬑ ላይꬃስ ጊዳና ካꬅ ኢማና። ");
INSERT INTO gmve_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ኦስፑንꬃ ላይꬃንካ ጎሼ ጎዪሼ ኢንቴ ካሴ ሺሺዳ ካꬃ ማና፤ ሄሳ ሄ ካꬃ ኡዱፉንꬃ ላይꬃን ቦኔ ካꬅ ኢንቴ ሺሻና ጋካናስ ኢዛፔ ማና። ");
INSERT INTO gmve_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","« ‹ጋዴይ ዎዜቶንታ ማላ ባይዛናስ ቤሴና፤ ጋሶይካ ቢታይ ታሳ ኣቲን ኢዛ ኢንቴስ ጊዱኩ፤ ኢንቴ ኢማꬃታኔ ቤቴ ኣሳታ ማላ። ");
INSERT INTO gmve_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","« ‹ቢታይ ባይዜቲኮ ሄ ባይዚዛዴይ ሄ ቢታ ዛሪ ዎዛናይሲ ኤሬቲዳዝ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","ኢስራኤሌ ኣሳፔ ኢሳዴይ ሜቶፔ ኣታናስ ባ ጋዴ ባይዚኮ ኢዛስ ማቲዛ ዳቦይ ሄ ባይዜቲዳ ጋዳ ዎዞ። ");
INSERT INTO gmve_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ኢዛስ ዎዚዛ ማታ ዳቦይ ዶንታ ኣጊኮ ኢዛዴይ ጋምኢሼ ሚሼ ዴሚዲ ዛሪ ዎዛናስ ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ሄሳ ዎዛናስ ኢዚ ዳንዳይዛ ዎዴ ባ ባይዚዳ ዎዴዛፔ ዶሚዲ ዲዛ ላይꬃ ቆዲዲ ኣቲዳ ላይꬃታ ሚሻ ሻሚዳዴስ ዛሮ፤ ሄሳፌ ጉዬ ካሴ ባ ጋዴዛ ዛሪ ኤኮ። ");
INSERT INTO gmve_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ቃሴካ ጋዴዛ ዎዛናስ ጊዲዛ ሚሺ ኢዛስ ዶንታ ኣጊኮ ኢዚ ባይዚዳ ጋዴይ ዎዜቲዛ ላይꬃይ ጋካናስ ሻሚዳዴ ኩሼን ዴኦ፤ ዎዜቲዛ ላይꬃይ ጋኪሺን ጋዴይ ጋዳዴስ ሲሞ፤ ጋዳዴይካ ጌዴ ባ ጋዴን ሲሞ። ");
INSERT INTO gmve_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","« ‹ኢሲ ኣሲ ጊምቤይ ጊምቤቲዳ ካታማ ጊዶን ዲዛ ኬꬅ ባይዚዳ ጊዲኮ ኢዚ ባይዚዳፔ ኢሲ ላይꬃ ጋርሳን ዛሪ ዎዛናስ ዳንዳዬስ፤ ኢዚ ዛሪ ዎዛና ዳንዳይዛይ ኢሲ ላይꬃ ጋርሳን ጻላ። ");
INSERT INTO gmve_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ጊዲኮካ ኢሲ ላይꬃ ጋርሳን ዛሪ ዎዛናስ ዳንዳዮንታ ኣጊኮ ሃራ ዎዴ ዛሪ ዎዚሲዛ ዎጋይ ኢዛስ ዴና፤ ኬꬃይ ሻሚዳዴስ ዎይኮ ኢዛ ና ናስ ሃሮ ጊዲ ኣቴስ፤ ባይዜቲዳ ሚሻይ ዎዜቲዛ ላይꬃንካ ባይዚዳዴስ ኬꬃይ ሲሜና። ");
INSERT INTO gmve_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","ጊምቤይ ጊምቤቶንታ ጮ ዴሬ ጋርሳን ዲዛ ኬꬃቲ ባይዜቲዳፔ ጉዬ ጎሻ ቢታ ማላ ቆዴቲዲ ኬꬃ ጎዳይ ዛሪ ዎዛናስ ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","« ‹ጊዶ ኣቲን ሌዌ ናይቲ ባስ ኢሜቲዳ ካታማታን ዲዛ ባ ኬꬃታ ባ ኮዪዳ ኣይ ዎዴካ ዎዛናስ ዳንዳዬቴስ። ");
INSERT INTO gmve_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ሃይቲ ካታማታን ኢሲ ሌዌ ቆሞይ ኬꬅ ባይዚኮ ቃሴ ዛሪ ዎዛናስ ኢዚ ዳንዳዮንታ ኣጊኮ ባይዜቲዳ ሚሽ ዎዞ ላይꬃን ኢዛስ ሲሞ፤ ጋሶይካ ሌዌ ቆሞቲ ባ ካታማታን ኬጺዳ ኬꬃቲ ኢስራኤሌ ናይታ ጊዶን ኣይ ዎዴ ጋካናስካ ኢስታሳ። ");
INSERT INTO gmve_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","ቃሴካ ኢስቲ ካታማታ ዩሾን ዲዛ ሜሄይ ሄሜቲዛ ቢታይ ሙሌካ ባይዜቶፎ፤ ሄ ቢታይ ኣይ ዎዴካ ኢስታሳ። ");
INSERT INTO gmve_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","« ‹ኔ ባጋ ኢስራኤሌ ኣሳፔ ኢሳዴይ ማንቂዲ ባና ኣይሳናስ ዳንዳዮንታዴ ጊዲኮ ኢማꬃ ጊዲዳ ዎይኮ ቤቴ ኣሲ ኔ ኣቻን ዳና ማላ ኔ ማዲዛይሳꬆ ኢዛካ ማዳ። ");
INSERT INTO gmve_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","ኔ ባጋ ጊዲዳ ኢስራኤሌ ኣሲ ኔናራ ዳና ማላ ኢዛፔ ዲች ሞፓ፤ ኔ ጾሳስ ያያ። ");
INSERT INTO gmve_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","ኔ ኢዛስ ታልኤ ኢሚኮ ኢዛፔ ዲች ኦይቾፋ፤ ኔ ካꬅ ኢዛስ ዎꬌራ ባይዞፓ። ");
INSERT INTO gmve_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","ኔና ካናኔ ቢታ ላቲሳናስ ኔስ ጎዳ ጊዳናስ ጊብጼ ቢታፌ ኬሲዳ ጾሳይ ታና። ");
INSERT INTO gmve_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","« ‹ኔ ባጋ ጊዲዳ ኢስራኤሌ ኣሳፔ ኢሳዴይ ማንቆቴꬃፌ ዴንዲዳይሳን ኣይሌ ማላ ኔስ ሃሬታናስ ባና ባይዚኮ ኔ ኢዛ ኣይሌ ማላ ኦሲሶፓ። ");
INSERT INTO gmve_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","ኔ ኢዛ ኔ ማታን ዲዛ ኢማꬃ ማላ ዎይኮ ሚሻስ ኦꬂዛ ኦሳንቻ ማላ ቆዳ፤ ኢዚካ ኢቻሹ ታሙ ላይꬅ ጋካናስ ኔስ ኦꬆ። ");
INSERT INTO gmve_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ሄሳፌ ጉዬ ባ ናይታራ ኔፔ ሻኬቲ ጌዴ ባሶ ኣሳኮኔ ባ ዱሳሶ ሲሞ። ");
INSERT INTO gmve_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","ኢስራኤሌ ኣሳ ታ ጊብጼ ቢታፌ ኬሲዳ ታ ኦሳንቻታ ጊዲዳ ጊሻስ ኢስቲ ኣይሌ ማላ ባይዜቶፌቶ። ");
INSERT INTO gmve_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ኔ ኢስታ ዎልቃራ ሃሮፓ፤ ኔ ጾሳስ ያያ። ");
INSERT INTO gmve_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","« ‹ኔስ ኣቱማኔ ማጫ ኣይሌቲ ዴኣና ማላ ኮይኮ ኔ ዩሾን ዲዛ ኣይዛቤታ ጊዶፌ ሻማ ኤካ። ");
INSERT INTO gmve_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","ቃሴካ ኢንቴ ቢታን ዲዛ ቤቴ ኣሳታፔኔ ኢንቴ ቢታን ዬሌቲዳ ኣሳታፔ ሻማናስ ዳንዳዬታ፤ ኢስቲ ኢንቴስ ሃሮ ጊዴቶ። ");
INSERT INTO gmve_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","ሄይታን ኢንቴ ኢንቴ ናይታ ላቲሳናስ ዳንዳዬታ፤ ኢስቲ ዴኢዛ ላይꬃ ኡባን ኢንቴ ናይታስ ኦꬂዛይታ ጊዳና፤ ኢንቴ ቆሞ ጊዲዳ ኢስራኤሌ ኣስ ዎልቃራ ሃሮፒቴ። ");
INSERT INTO gmve_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","« ‹ኢንቴ ጊዶን ዲዛ ሃራ ዴሬ ኣሳፔ ኢሳዴይ ዱሬ ጊዲኮ ኢንቴ ባጋ ጊዲዳ ኢስራኤሌ ናይታፔ ማንቆ ጊዲዳይ ባና ሃራ ዴሬ ዱሬስ ዎይኮ ኢዛሶ ኣሳፔ ኢሳዴስ ባና ኣይሌቴꬃስ ኣꬂ ኢሚኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ኢዚ ባይዜቲዳፔ ጉዬ ሲሚዲ ናምኣንꬆ ዎዜታናስ ዳንዳዬስ፤ ሄሳ ጊሻስ ኢዛ ኢሻታፔ ኢሳዴይ ኢዛ ዎዞ። ");
INSERT INTO gmve_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ኢዛ ኣዋ ኢሻይ ዎይኮ ኢዛ ኣዋ ኢሻ ናይ ዎይኮ ኢዛስ ማታ ዳቦታፔ ኢሳዴይ ኢዛ ዛሪ ዎዛናስ ዳንዳዬስ፤ ኢዛዴይ ባስ ጊዲዛ ሚሼ ሺሺዳ ጊዲኮ ባ ሚሻራ ዎዜታናስ ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","ኢዚ ባና ሃሪዳዴራ ኢሲፌ ጊዲዲ ኢዚ ባና ባርካ ባይዚዳ ላይꬃፌ ዶሚዲ ዎዜቴꬃ ላይꬃ ጋካናስ ዲዛ ላይꬃ ቆዶ፤ ኢዛ ዎዚሲዛ ሚሻይ ሄ ላይꬃታ ቆዳ ጊዶ፤ ኢዚ ባና ሃሪዛይሳራ ጋምኢዳ ዎዴ ዋጋይ ኢሲ ኣሲ ኦꬂዲ ዴሚዛ ኪራ ሚሻ ኬና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","ዎዞ ላይꬃይ ጋካናስ ቡሮ ዳሮ ላይꬃቲ ኣቲዳ ጊዲኮ ባ ባይዜቲዳ ዋጋፔ ሄ ኣቲዳ ላይꬃ ቆዳን ባና ዎዚዛ ዋጋ ቃንጾ። ");
INSERT INTO gmve_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ሄ ኣቲዳ ላይꬃቲ ጉꬅ ጊዲኮ ባ ሃሬቲን ኣቲዳ ላይꬃ ቆዲዲ ባና ዎዚዛ ዋጋ ቃንጾ። ");
INSERT INTO gmve_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ኢዚ ላይꬃፌ ላይꬅ ጋካናስ ኡኔ ኦꬂዛ ኣሳ ማላ ባና ሃሪዳዴራ ዴኦፔ ኣቲን ኢዛ ዎልቃራ ሃራናስ ቤሴና። ");
INSERT INTO gmve_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","« ‹ሄሳꬆ ሃኒዲ ዎዜታናስ ዳንዳዮንታ ኣጊኮ ሲንꬃፌ ያና ኣይሌቴꬃፌ ዎዜቲዛ ላይꬃን ኢዚኔ ኢዛ ናይቲ ሜላ ዬዴቴቶ። ");
INSERT INTO gmve_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ኢስራኤሌ ኣሳይ ታስ ኣይሌታኔ ታኒ ጊብጼ ቢታፌ ኬሲዳ ታ ኦሳንቻታ፤ ታኒ ጎዳ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","« ‹ኢንቴ ኢዛስ ጎይናና ማላ ኢንቴስ ኣይኮካ ኤቃ ሜꬎፍቴ፤ ሄሳꬆካ ሚስሌ ዎይኮ ሃዉልቴ ዎይኮ ሹቻፌ ማሴቲ ኬዚዳ ቱስ ኤሶፍቴ፤ ታኒ ጎዳ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","« ‹ሳምባታ ጋላሳታ ናጊቴ፤ ታ ኬꬃ ቦንቺቴ፤ ታኒ ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","« ‹ኢንቴ ታ ዎጋን ዲኮኔ ታ ኣዛዞታካ ናጊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ታኒ ኢንቴስ ኢራ ዎዴራ ቡኪሳና፤ ቢታያካ ካꬅ ዳርሳ ኢማና፤ ኣይፌ ኢሚዛ ሚꬃቲካ ዳርሲ ኣይፋና። ");
INSERT INTO gmve_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","ኢንቴ ካꬃይ ኬሂ ዳሮ ጊዲዳ ጊሻስ ኢንቴ ቡሮ ሺሾ ቦላ ዲሺን ዎይኔ ሚꬃ ኣይፌ ቃንጺዛ ዎዴይ ጋካና፤ ኢንቴ ዎይኔ ሚꬃ ኣይፌ ቃንጺዲ ሺሺ ዉርሶንታ ዲሺን ካꬅ ዜሪዛ ዎዴይ ጋካና፤ ኢንቴ ካꬅ ካሊ ማና፤ ኢንቴ ቢታንካ ሳሮቴꬃን ዳና። ");
INSERT INTO gmve_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","« ‹ኢንቴ ቢታስ ሳሮቴꬅ ኢማና፤ ኦናስካ ባቦንታ ኢንቴ ዎፑ ጊ ኣቃና፤ ኢታ ዶኣታ ኢንቴ ዴሬፔ ታ ዲጋና፤ ሃይሳፌ ጉዬ ኢንቴ ዴሬን ኦላይ ዴና። ");
INSERT INTO gmve_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","ኢንቴ ኢንቴ ሞርኬታ ጎዳና፤ ኢስቲካ ኢንቴ ሲንꬃን ማሻን ሃይቃና። ");
INSERT INTO gmve_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","ኢንቴፌ ኢቻሽ ኣሲ ጼቱ ኣስ፥ ጼታይ ቃሴ 10,000 ኣስ ጎዳና፤ ኢንቴ ሞርኬይ ኢንቴ ሲንꬃን ማሻን ዉራና። ");
INSERT INTO gmve_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","« ‹ታኒ ታ ሲንꬅ ኢንቴኮ ዛራና፤ ሂስታዳ ኢንቴና ዳርሳና፤ ታ ኢንቴስ ጌሊዳ ጫቆ ቃላ ናጋና። ");
INSERT INTO gmve_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","ካꬃይ ኢንቴስ ላይꬃፌ ላይꬅ ጋꬃና፤ ሄሳፌ ዴንዲዳይሳን ኦራꬅ ጋኪዳ ካꬅ ጌልꬃናስ ዚላይꬃ ካꬃፌ ኣቲዳይሳ ሃራሶ ኬሴታ። ");
INSERT INTO gmve_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","ታኒ ኢንቴ ጊዶን ዴያና፤ ታ ኢንቴና ሻቴቲኬ። ");
INSERT INTO gmve_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","ታኒ ኡባ ዎዴ ኢንቴ ጊዶን ሲሜሬታና፤ ታኒ ኢንቴ ጾስ ጊዳና፤ ኢንቴካ ታ ዴሬታ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","ኢንቴ ኣይሌቴꬃን ሃሬቶንታ ማላ ጊብጼ ቢታፌ ኢንቴና ኬሲዳይ ታኒ ጎዳ ኢንቴ ጾሳ፤ ታኒ ኢንቴ ኣይሌቴꬃ ቃምባራ ሜንꬃዳ ኢንቴ ꬎቁ ጊዲ ባና ማላ ኦꬃዲስ። ");
INSERT INTO gmve_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","« ‹ጊዶ ኣቲን ኢንቴ ታ ጊዛዝ ሲዮንታ ኢጺኮ ሃ ኣዛዞታ ኡባ ኦꬆንታ ኣጊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ታ ዎጋኔ ታ ኣዛዞታ ኢንቴ ካꬊዛ ጊዲኮ ታ ኢንቴናራ ጫቄቲዳ ጫቆዛ ኢንቴ ላሊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ሄ ዎዴ ታኒ ኢንቴ ቦላ ሃይሳ ኤሃና፤ ጊታ ዳጋማ፥ ጊልቃቴꬅ፥ ኣይፌ ቦልጄሲዛዝ፥ ኣሳቴꬃ ጊልቂሲዛዝ ቆጾ ሃርጌ ታ ኢንቴ ቦላ ኤሃና፤ ኢንቴ ዜሬꬅ ዜራናሺን ጮ ሜላ ሃዳ ጊዳና፤ ጋሶይካ ኢንቴ ዜሪዳይሳ ኢንቴ ሞርኬቲ ማና። ");
INSERT INTO gmve_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","ታኒ ኢንቴ ቦላ ሃንቆን ዴንዲዛ ጊሻስ ኢንቴ ጾኔታና፤ ኢንቴ ኢጺዛ ኢንቴ ሞርኬቲ ኢንቴና ሃራና፤ ኦኒካ ኢንቴና ጎዶንታ ኢንቴ ኢንቴርካ ባቃታና። ");
INSERT INTO gmve_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","« ‹ሄሲ ዉሪካ ኢንቴ ቦላ ጋኪዳፔ ጉዬካ ኢንቴ ታስ ኣዛዜቶንታ ኢጺኮ ታ ኢንቴ ቦላ ዬጋና ቂጻቴዛ ላፑን ኩሼ ዳርሳና። ");
INSERT INTO gmve_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","ኢንቴ ኦቶሮቴꬃ ዎልቃ ታ ሜንꬃና፤ ኢንቴፌ ቦላራ ሳሎዛ ቢራታ ማላ ኦꬃና፤ ኢንቴ ቢታካ ጻርቂማላꬆ ኦꬃና። ");
INSERT INTO gmve_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ኢንቴ ዎልቃይ ጮ ሃዳ ዉራና፤ ጋሶይካ ኢንቴ ቢታይ ካꬅ ኢሜና፤ ሚꬃቲካ ኣይፌቴና። ");
INSERT INTO gmve_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","« ‹ሃኢካ ኢንቴ ታስ ኢጺስ ጊዲ ኣዛዜቶንታ ኣጊኮ ታኒ ኢንቴ ቦላ ኢንቴ ናጋራ ኬና ቂጻቴዛ ላፑን ኩሼ ዳርሳና። ");
INSERT INTO gmve_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","ኢታ ዶኣታ ታ ኢንቴ ጊዶ ዬዳና፤ ሄ ዶኣቲ ኢንቴ ናይታ ዋꬋና፤ ኢንቴ ሚዛታካ ኡባ ꬋይሳና፤ ኢንቴፌ ጉꬃ ኣሳቲ ጻላ ኣታና፤ ካሴ ኢንቴ ሄሜቲዛ ኦጌይ ሳማና። ");
INSERT INTO gmve_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","« ‹ሃይሲ ሃ ቂጻቴዚ ኢንቴ ቦላ ጋኪዳፔ ጉዬካ ኢንቴ ታ ጊዛይሳ ሲዮንታ ኢጺዲ ታ ቦላ ኢንቴ ኤቄቴꬅ ዳርሲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ሄ ዎዴ ታኒካ ኢንቴስ ሞርኬ ጊዳና፤ ኢንቴ ናጋራ ጊሻስ ታ ኢንቴና ላፑን ዳኮ ቃጻያና። ");
INSERT INTO gmve_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","ኢንቴ ታናራ ጫቂዳ ቃላ ላሊዳ ጊሻስ ታ ኢንቴና ቃጻያናስ ኢንቴ ቦላ ኦላ ዬዳና፤ ኢንቴ ኢንቴ ካታማታን ሺቂዛ ዎዴ ታ ኢንቴ ጊዶን ኢታ ሃርጌ ኪታና፤ ኢንቴ ሞርኬታስ ኢንቴ ኣꬊ ኢሜታና። ");
INSERT INTO gmve_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","ኢንቴ ካꬃ ታኒ ꬋይሲዛ ዎዴ ታሙ ማጫሳቲ ዉሪ ኢሲ ባሼን ኡካና፤ ኢዞካ ማካ ሚሻን ጌዳሪ ጌዳሪ ኤካና፤ ኢንቴካ ሚዲ ካሌኬታ። ");
INSERT INTO gmve_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","« ‹ሃይሲ ኡባይ ኢንቴ ቦላ ጋኪን ኢንቴ ታስ ኣዛዜቶንታ ኢጺዲ ታ ቦላ ማካሊ ማካሊ ቢኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ታ ኢንቴ ቦላ ሃንቆን ዴንዳና፤ ኢንቴ ናጋራ ጊሻስ ታ ኢንቴና ላፑን ዳኮ ቃጻያና። ");
INSERT INTO gmve_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","ኢንቴ ኮሻ ዳሮፔ ዴንዲዳይሳን ኢንቴ ናይታ ኣሾ ማና። ");
INSERT INTO gmve_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","ꬎቃሶሆን ዲዛ ኢንቴ ጎይኒዛ ኤቃ ጾሳታ ታኒ ꬋይሳና፤ ኢንቴ ኤጻኔ ያርሾ ኢዛን ሺሺዛሶዛ ታ ላላና፤ ኢንቴ ኣሃ ኢንቴ ኤቃታ ቦላ ታ ዬጋና፤ ታ ሼምፒያ ኢንቴና ሻቴታና። ");
INSERT INTO gmve_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ታ ኢንቴ ካታማታ ላላና፤ ኢንቴ ጎይኒዛሶታ ታ ካይስ ሂስታና፤ ሳዊዛ ኢንቴ ያርሾዛ ታ ኤኪኬ። ");
INSERT INTO gmve_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","ኢንቴ ቢታ ሙሌራ ታ ꬋይሳና፤ ሄን ዲዛ ኢንቴ ሞርኬቲ ማላሌታና ጋካናስ ቢታዮ ታ ኣሲ ባይንዳሶ ሂስታና። ");
INSERT INTO gmve_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","ታ ኢንቴ ቦላ ኦላ ኤሃዳ ኢንቴና ኣይዛቤታ ጊዶን ላላና፤ ታኒ ታ ማሻ ኬሳዳ ኢንቴና ጎዳና፤ ኢንቴ ካዎቴꬃይ ኣሲ ባይንዳ ቢታ ጊዳና፤ ኢንቴ ካታማቲካ ላሌታና። ");
INSERT INTO gmve_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","ኢንቴ ኢንቴ ሞርኬታ ቢታን ዲዛ ዎዴ ኢንቴ ቢታይ ካይስ ጊዲዛ ጊሻስ ሼምፖ ዴማዳ ሳምባታ ላይꬃታን ኡፋዬታና። ");
INSERT INTO gmve_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","ኢንቴ ቢታያ ካሴ ኢንቴ ኢዚን ዲሺን ሳምባታ ዴሞንታራ ኣሳይ ꬋይዳ ዎዴ ኢዛ ሼምፖ ዴማና። ");
INSERT INTO gmve_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","« ‹ኢንቴ ቤቴ ቢታን ዲዛይቲ ዉሪካ ጫርኮይ ቃꬂዛ ቆናሼ ጊሪስ ሲዪዲ ዳጋማን ፒራꬊ ባቃታና ማላ ታ ኦꬃና፤ ሞርኬይ ኦላሶን ጎዲን ዎጺዛ ማላ ኢንቴ ዎጻና፤ ኣይ ሞርኬይካ ኢንቴ ኣቻን ባይንዳ ኢንቴ ꬉጴቲ ኩንዳና። ");
INSERT INTO gmve_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ኦኒካ ኢንቴና ጎዶንታ ኢንቴ ኢንቴርካ ኢሶይ ኢሳራ ቃጼቲ ኩንዳና፤ ኢንቴ ኢንቴ ሞርኬታራ ኤቄቲ ኦሌታናስ ዳንዳዬኬታ። ");
INSERT INTO gmve_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","ኢንቴ ቤቴ ቢዲ ሄ ዴሬን ሃይቃና፤ ኢንቴ ኢንቴ ሞርኬታ ካዎቴꬃን ሚቴቲ ኣታና። ");
INSERT INTO gmve_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","ኢንቴ ሞርኬታ ዴሬን ሃይቆንታ ኣቲዳይቲ ቃሴ ኢንቴ ናጋራኒኔ ካሴ ኢንቴ ኣዋታ ናጋራ ጌዶን ሄን ጊልቂ ኣታና። ");
INSERT INTO gmve_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","« ‹ጊዶ ኣቲን ኢንቴ ታስ ኣማኔቶንታ ኣጊዳይሳኔ ታ ቦላ ማካሊዳ ኢንቴ ናጋራኔ ኢንቴ ኣዋታ ናጋራ ኢንቴ ፓጺኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ታኒ ኢንቴስ ሞርኬ ጊዳዳ ኢንቴና ጌዴ ኢንቴ ሞርኬታ ቢታ ዬዳና ማላ ታና ኦሲሲዳ ኢንቴ ናጋራ ኢንቴ ፓጺኮ ሙሚዳ ኢንቴ ዎዚና ኢንቴ ካዉሺዲ ኢንቴ ናጋራፔ ኢንቴ ሲሚኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ኣብራሃሜራ፥ ዪሳቃራኔ ያቆቤራ ታ ጫቂዳ ጫቆ ቃላ ቆፓና፤ ቢታዮካ ታ ቆፓና። ");
INSERT INTO gmve_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","ኢስቲ ዬጊ ቢዳ ጊሻስ ቢታያ ኣሲ ባይንዳ ባዞ ጊዳዱስ፤ ሄ ዎዴ ኢዚን ኣሲ ባይንዳ ባዞ ጊዳዳ ባ ሳምባታ ኡፋይሳን ቦንቻና፤ ኢስቲ ታ ዎጋኔ ታ ኣዛዞዛ ካዉሺዳ ጊሻስ ኢስቲ ኦꬂዳ ናጋራ ጊሻስ ቃጻዬታና። ");
INSERT INTO gmve_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ጊዲኮካ ኢስቲ ባ ሞርኬታ ዴሬን ዲዛ ዎዴ ኢስታ ሙሌራ ꬋይሲኬ ጋዳ ታ ጫቂዳ ቃላ ማቤኬ፤ ታ ኢንቴና ኣጋጊኬ፤ ታ ኢንቴና ሃራሴቲኬ፤ ታኒ ጎዳ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","ታኒ ኢስታ ጾሳ ጊዳና ጋዳ ኣይዛቤ ኣሳይ ቤዪሺን ጊብጼ ቢታፌ ኬሲዳ ኢስታ ኣዋታራ ጫቂዳ ጫቆዛ ታ ቆፓና፤ ታኒ ጎዳ› ጌስ።» ");
INSERT INTO gmve_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","ኢስራኤሌ ዴራስ ዮታና ማላ ሙሴይ ሲና ዙማ ቦላ ዲሺን ጾሲ ኢዛስ ኢሚዳ ዎጋቲ፥ ማራቲኔ ኣዛዞቲ ሃይታንታ። ");
INSERT INTO gmve_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«ኢስራኤሌ ኣሳስ፥ ‹ኣይ ኣሲካ ጎዳስ ኣስ ኢማናስ ኣዲኔቲን ሄ ኣዲናይ ፖሌቲኮ ሄ ኢማና ጊ ኣዲኔቲዳይሳ ዎዛናስ ኣዲና ዎጋይ፥ ");
INSERT INTO gmve_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ሄሳዴ ላይꬃይ ናምኡ ታማፌ ቢዲ ኡሱፑን ታሙ ኩሚዳ ኣቱማ ኣስ ጊዲኮ ጎዳ ኬꬃን ኤሬቲዳ ሜዛኔን ሜዛኔቲዲ ኢቻሽ ታሙ ጊዲዛ ሳቂሌ ቢራ ቃንጾ። ");
INSERT INTO gmve_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ማጫ ጊዲኮ ሄꬑ ታሙ ሳቂሌ ቢራ ጊዶ፤ ");
INSERT INTO gmve_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ቃሴካ ኢቻሽ ላይꬃፌ ቢዲ ናምኡ ታሙ ላይꬅ ጋካናስ ዲዛ ኣቱማ ና ጊዲኮ ናምኡ ታሙ ሳቂሌ ቢራ፥ ማጫ ና ጊዲኮ ታሙ ሳቂሌ ቢራ ቃንጾ፤ ");
INSERT INTO gmve_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ኢሲ ኣጊናፔ ቢዲ ኢቻሽ ላይꬅ ጋካናስ ዲዛ ኣቱማ ና ጊዲኮ ኢቻሽ ሳቂሌ ቢራ ቃንጾ፤ ሄ ላይꬃታ ጊዶን ዲዛ ማጫ ናስ ጊዲኮ ሄꬑ ሳቂሌ ቢራ ቃንጾ። ");
INSERT INTO gmve_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ሄሳꬆካ ላይꬃይ ኡሱፑን ታማፌ ቦላራ ዲዛ ኣቱማ ኣስ ጊዲኮ ታማኔ ኢቻሽ ሳቂሌ ቢራ፥ ማጫ ጊዲኮ ታሙ ሳቂሌ ቢራ ቃንጾ። ");
INSERT INTO gmve_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","ኣዲና ኣዲኔቲዳዴይ ሃይሳ ሃ ሄሬጌቶይሳ ቃንጻናስ ዳንዳዮንታ ኬሂ ማንቆ ጊዲኮ ኢዚ ባ ኢማና ጊ ኣዲኒዳይሳ ቄሴዛ ሲንꬅ ኤኪ ዮ፤ ቄሴዚካ ኣዲኔቲዳዴ ጼሊ ቤኢዲ ኢዛዴ ዎልቃ ኬና ሄሬጎ። ");
INSERT INTO gmve_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","« ‹ኣዲና ኣዲኔቲዳይሲ ጾሳስ ያርሻናስ ቤሲዛ ሜሄ ጊዲኮ ሄሳ ማላ ሜሄይ ጾሳስ ዱማ ጊዲዳ ጊሻስ ዎዜቴና። ");
INSERT INTO gmve_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ኣዲና ኣዲኔቲዳዴይ ባ ኣዲኔቲዳ ሜሄዛ ሃራ ሜሄን ላሞፎ፤ ጊዶ ኣቲን ኢታዛካ ሎኦ ሜሄን ላሚዛ ጊዲኮ ኢዚ ካሴ ኤሆይሳራ ናምኣይካ ጾሳስ ዱማቲዳይታ ጊዴቶ። ");
INSERT INTO gmve_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ኢዛዴይ ኢሚዛይሲ ጾሳስ ያርሼታናስ ቤሶንታ ሜሄ ጊዲኮ ሄ ሜሄዛ ኤሂዳዴይ ሜሄዛ ቄሴኮ ኤሆ። ");
INSERT INTO gmve_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ቄሴዚ ሄ ሜሄዛ ኢታቴꬂኔ ኢዛ ሎኤቴꬅ ጫዲ ጼሊዲ ኢዚ ኬሳና ዋጋ ዮቶ፤ ሄ ኢዚ ጊዳ ዋጋይ ኢዚ ጊዳ ማላ ሃኖ። ");
INSERT INTO gmve_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ሄ ሜሄዛ ጎዳይ ሜሄዛ ዛሪ ሚሻራ ሻማና ኮይኮ ሄ ሜሄዛ ዋጋ ቦላ ጼታፔ ናምኡ ታሙ ኩሼ ጉጂዲ ሻሞ። ");
INSERT INTO gmve_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","« ‹ኢሳዴይ ባ ኬꬅ ጎዳስ ዱማ ኢሞታ ኢሚኮ ቄሴታ ሃላቃይ ኬꬃይ ኢታኮኔ ሎኦኮ ኢዛ ሃኖቴꬅ ጫዲ ጼሊ ሄሬጊዲ ዋጋ ዮቶ፤ ሄ ቄሴዚ ሄሬጊዳ ዋጋይ ኬꬃስ ሄሬጋ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ካሴ ኬꬃ ጎዳይ ሄ ኬꬃ ዛሪ ዎዛና ኮይኮ ሄሬጌቲዳ ዋጋ ጼታፔ ናምኡ ታሙ ኩሼ ቦላራ ጉጂዲ ኬꬃ ባስ ኤኮ። ");
INSERT INTO gmve_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","« ‹ኢሳዴይ ባ ጋዴፔ ሻኪ ጎዳስ ዱማ ኢሞታ ኢሚኮ ቢታይ ኢሚዛ ካꬃ ማላ ሄሬጌቶ፤ ሄሲካ ኢሲ ኪሎ ባንጋ ጊሻስ ኢቻሽ ታሙ ሳቂሌ ቢራይ ቃንጼቶ። ");
INSERT INTO gmve_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ጋዴዛ ጎዳይ ካሴ ጋዴዛ ኢሚዳይ ዎዞ ላይꬃ ባኣሌፔ ጉዬ ጊዲኮ ጋዴስ ካሴ ዎꬊዳ ዎጋይ ላሜቴና። ");
INSERT INTO gmve_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ኢዛዴይ ጋዳ ኢሚዳይ ኢቻሽ ታማንꬆ ላይꬃፌ ጉዬ ጊዲኮ ቄሴዚ ሄሬጋናይ ዪዛ ኢቻሽ ታማንꬆ ላይꬅ ጋካናስ ዲዛ ኣቲዳ ላይꬃ ቆዲዲ ሄሬጎ፤ ሚሻፌ ኣሺ ጪጎ። ");
INSERT INTO gmve_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ጋዴዛ ኢሚዳዴይ ዛሪ ዎዛና ኮይኮ ካሴ ጋዴዚ ሄሬጌቲዳ ዋጋ ቦላ ጼታፔ ናምኡ ኩሼ ጉጂዲ ዛሪ ዎዞ። ");
INSERT INTO gmve_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ካሴ ጋዴይ ባ ጋዳ ጾሳፌ ሚሻን ዎዛናፔ ሲንꬃን ሃራ ኣሳስ ባይዚዳ ጊዲኮ ቃሴ ሄ ጋዴዛ ናምኣንꬆ ዛሪ ዎዛና ዎጋይ ኢዛስ ዴና። ");
INSERT INTO gmve_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ዎዞ ላይꬃን ጋዴይ ሲሚዛ ዎዴ ሄ ጋዴዚ ጊዲኮ ጎዳስ ዱማቲዲ ቄሴታ ላታ ጋዴ ጊዲ ኣቶ። ");
INSERT INTO gmve_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","« ‹ኢሳዴይ ሃራ ኣሳፔ ሻሚ ኤኪዳ ጋዴ ጾሳስ ኢማና ኮይኮ፥ ");
INSERT INTO gmve_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ካሊ ዪዛ ዎዞ ላይꬅ ጋካናስ ጋዴዚ ኬሳና ዋጋ ቄሴዚ ሄሬጎ፤ ሄ ጋላስ ሄ ሄሬጌቲዳ ሚሽ ጋዳዴይ ቃንጾ፤ ሄ ሚሻይካ ጾሳ ኦሶስ ዱማቲዳዝ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ዎዞ ላይꬃ ባኣሌይ ጋኪዛ ዎዴ ሄ ጋዴዛ ኮይሮ ላታን ኤኪዲ ባይዚዳዴስ ጋዴዚ ሲሞ። ");
INSERT INTO gmve_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","ሄ ሄሬጋዛ ዋጋይ ጎዳ ኬꬃን ኤሬቲዳ ሜዛኔን ሜዛኔቲዲ ናምኡ ታሙ ሳቂሌ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","« ‹ኮይሮ ባይራ ዬሌቲዳ ሜሄይ ኢዚ ካሴካ ጎዳስ ጊዲዳ ጊሻስ ኦኒካ ኢዛ ጾሳስ ሜላ ኪያቴꬅ ኢማናስ ዳንዳዬና፤ ጋሎ ማር ጊዲን ዎይኮ ዶርሳኔ ዴይሻ ላቃቲ ካሴቲዲ ጾሳስ ዱማቲዳይታ። ");
INSERT INTO gmve_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ኢዛ ቦላ ዎሶይ ዲዛ ሜሄኔ ያርሾ ሺሻናስ ቤሶንታ ሜሄ ጊዲኮ ሄ ሜሄዛ ጎዳይ ኢዛ ሄሬጌቲዳ ዋጋ ቦላ ጼታፔ ናምኡ ታሙ ኩሼ ጉጂዲ ዛሪ ዎዚ ኤካናስ ዳንዳዬስ፤ ኢዛ ጎዳይ ዎዚ ኤካናስ ኮዮንታ ኢጺኮ ሄ ሄሬጌቲዳ ዋጋን ሃራ ኣሳስ ባይዜቶ። ");
INSERT INTO gmve_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","« ‹ኢሳዴይ ባ ጎዳስ ባስ ዲዛይሳፌ ኣስ ጊዲን ዎይኮ ሜሄ፥ ጊዲን ዎይኮ ጋዴ ጊዲን ኩሜꬃራ ዱማ ሻኪዳፔ ጉዬ ሙሌካ ባይዛናሲኔ ዛሪ ዎዛናስ ቤሴና። ");
INSERT INTO gmve_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","« ‹ኣሳ ጊዶፌ ሻኬቲዲ ዴያና ማላ ፒርዴቲዳዴይ ዎዜቶፎ፤ ኢዛዴይ ሃይቃናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","« ‹ቢታፌ ሞኪዛ ካꬅ ጊዲን ዎይኮ ሚꬃ ኣይፌ ጊዲን ታማፌ ኢሶይ ጾሳስ ዱማቲዳ ኣስራታ። ");
INSERT INTO gmve_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ሄሳፌ ኣዋይሳካ ባስ ዎዚ ኤካናስ ኮይዛዴይ ሄ ሚሻይ ባይዜቲዛ ዋጋስ ጼታፔ ናምኡ ታሙ ኩሼ ጉጂዲ ሻማናስ ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","ሶ ሜሄታፔ ታማፌ ኢሳይ ጾሳ ጊሻ፤ ሜሄይ ታይቤቲሺን ታማንꬃይ ታማንꬃይ ጎዳስ ዱማ ሻኬቲዳዛ። ");
INSERT INTO gmve_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","ታማንꬃ ሜሄይ ኢታ ጊዲን ዎይኮ ሎኦ ጊዲን ዶሮፖ፤ ዎይኮ ሃራራ ላሞፎ፤ ላሚዛ ጊዲኮ ኮይሮይሲኔ ላሜ ኢሜቲዳይሳራ ናምኣይካ ጎዳስ ዱማቲዳዝ ጊዴቴስ ኣቲን ዛሪ ዎዛናስ ዳንዳዬና› ጋ ዮታ።» ");
INSERT INTO gmve_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ሲና ዙማ ቦላ ጎዳይ ሙሴ ባጋራ ኢስራኤሌ ኣሳ ኣዛዚዳ ኣዛዞቲ ሃይታንታ። ");
INSERT INTO gmve_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ኢስራኤሌ ኣሳይ ጊብጼፔ ኬዚዳ ናምኣንꬆ ላይꬃን ናምኣንꬃ ኣጊናይ ዶሚዳ ኮይሮ ጋላስ ኢስቲ ሲና ባዞን ዲሺን ጎዳይ ጋይቶቴꬃ ዱንካኔ ጊዶን ሙሴራ ጋይቲዲ፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«ኣቱማሳ ኢሳ ኢሳ ሱንꬃን ሱንꬃን ጻፋዳ ኢስራኤሌ ኣሳ ቆሞን ቆሞኒኔ ዛርኬን ዛርኬን ቆዳ። ");
INSERT INTO gmve_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ኔኒኔ ኣሮኔይ ኢስታስ ላይꬃይ ናምኡ ታሙኔ ኢዛፔ ቦላራ ዲዛ ኦሌቲ ዳንዳያና ኣቱማሳታ ኢስታ ማራን ማራን ቆዲቴ። ");
INSERT INTO gmve_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ዱማ ዱማ ዛርኬታፔ ኢስታ ካሌꬂዛ ኢስታስ ኣዋቲዛ ኮራፒኔቲ ኢንቴናራ ጊዴቶ። ");
INSERT INTO gmve_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","ኢንቴና ማዳናይታ ሱንꬂ ሃይሳፌ ካሊ ዲዛይታ፥ ኦሮቤሌ ዛርኬፌ ሻዱሬ ና ኤልጹሬ፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","ሲሞና ዛርኬፌ ጹርሻዳዬ ና ሳሉምኤሌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","ዩሁዳ ዛርኬፌ ኣሚናዳቤ ና ኔኣሶኔ፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ዪሳኮሬ ዛርኬፌ ጹኣሬ ና ናቲናኤሌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ዛቢሎኔ ዛርኬፌ ሄሎኔ ና ኤልያቤ፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ዮሴፌ ናይታፔ ኤፍሬሜ ቆሞቲ ኣሚሁዴ ና ኤልሻማ ሚናሴ ናይታፔ ፔዳጹሬ ና ጋማልኤሌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","ቢኒያሜ ዛርኬፌ ጊዲኦኔ ና ኣቢዳኔ፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","ዳኔ ዛርኬፌ ኣሚሻዳዬ ና ኣሂኤዜሬ፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ኣሴሬ ዛርኬፌ ኦክራ ና ፋጉኤሌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ጋዴ ዛርኬፌ ዳኡኤሌ ና ኤልያሳፌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","ኒፍታሌሜ ዛርኬፌ ኤናኔ ና ኣሂሬ» ጊ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ማባራ ጋርሳፌ ዛርኬፌ ዛርኬፌ ኢስራኤሌ ኣሳ ካሌꬃናስ ዶሬቲዳ ኮራፒኔቲ ሃይታንታ። ");
INSERT INTO gmve_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ሙሴይኔ ኣሮኔይ ሃይታ ባንታ ሱንꬃን ጻፌቲዳይታ ኤኪዳ። ");
INSERT INTO gmve_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ናምኣንꬆ ኣጊናይ ዶሚዳ ኮይሮ ጋላስ ማባራዛ ኩሜꬅ ኢሲ ቦላ ሺሺዲ ዛርኬን ዛርኬኒኔ ዳቦን ዳቦን ሺሺዳፔ ጉዬ ዴሬዛ ቆዲዳ፤ ዬሌቲን ላይꬃይ ናምኡ ታሙ ኩሚዳይታኔ ሄሳፌካ ቦላራ ጊዲዳ ኣቱማሳ ኢስታ ሱንꬃን ሱንꬃን ማዝጋቢ ቆዲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ሄሳꬆካ ሙሴይ ጎዳይ ኣዛዚዳ ማላ ሲና ባዞን ዴሬዛ ቆዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ኦላ ኦሌታናስ ዳንዳይዛይታ ላይꬃይ ናምኡ ታማኔ ሄሳፌካ ቦላራ ዲዛይቲ ባንታ ዛርኬፌ ዛርኬፌ ቆዴቲዳ፤ ኣዴታ ቆዳይ ሃይሳፌ ካሊዛይሳ፤ ");
INSERT INTO gmve_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","ኦሮቤሌ ዛርኬፌ 46,500፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","ሲሞና ዛርኬፌ 59,300፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","ጋዴ ዛርኬፌ 45,650፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","ዩሁዳ ዛርኬፌ 74,600፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","ዪሳኮሬ ዛርኬፌ 54,400፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","ዛቢሎኔ ዛርኬፌ 57,400፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","33","ዮሴፌ ና ኤፍሬሜ ዛርኬፌ 40,500፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","35","ዮሴፌ ና ሚናሴ ዛርኬፌ 32,200፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","ቢኒያሜ ዛርኬፌ 35,400፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","ዳኔ ዛርኬፌ 62,700፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","ኣሴሬ ዛርኬፌ 41,500፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","ኒፍታሌሜ ዛርኬፌ 53,400። ");
INSERT INTO gmve_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","ሙሴይ፥ ኣሮኔይኔ ታማኔ ናምኡ ኢስራኤሌ ዛርኬታ ኮራፒኔቲ ቆዲዳ ኣቱማ ኣሳይ ሃይታንታ፤ ");
INSERT INTO gmve_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ኦላስ ባና ዳንዳይዛ ኣዴቲ ኡባይ ኢስታስ ላይꬃይ ናምኡ ታማኔ ሄሳፌካ ቦላራ ዲዛይቲ ባ ዛርኬን ዛርኬን ቆዴቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ሄይታ ቆዳይ ኢሲ ቦላ 603,550 ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","ጊዶ ኣቲን ሃንኮ ዛርኬታራ ሌዌ ዛርኬቲ ቆዴቲቤቴና። ");
INSERT INTO gmve_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","ካሴ ጎዳይ ሙሴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«ኔ ኢስራኤሌ ኣቱማ ኣሳ ቆዳሼ ሌዌ ዛርኬታ ኢስታራ ጋꬃ ቆዶፓ። ");
INSERT INTO gmve_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ሌዌ ዛርኬቲ ጊዲኮ ጋይቶቴꬃ ዱንካኔኔ ኢዛ ጊዶን ጎኤቲዛ ሚሻ ቦላ ኣላፌቴꬅ ኢማ፤ ኢስቲ ዱንካኔዛኔ ኢዛ ጊዶን ጎኤቲዛ ሚሻታ ኡባ ቶኬቶ፤ ዱንካና ጊዶን ኦꬄቶ፤ ኢዛ ዩሾን ዱንካኒ ኡቴቶ። ");
INSERT INTO gmve_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","ኢንቴ ካሴ ዱንካኒ ዲዛሶፔ ዴንዲ ቢዛ ዎዴ ሌዌ ዛርኬቲ ጻላላ ዱንካኔዛ ሾዲ ላሊዲ ኢስቲ ሼምፒዛ ኦራꬃሶን ኢስታካ ቶኬቶ፤ ኢስታፌ ኣቲን ዱንካናኮ ሺቂዛ ኣይ ኣሲካ ሃይቆን ቃጻዬቶ። ");
INSERT INTO gmve_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ሃንኮ ኣቲዳ ኢስራኤሌ ኣሳይ ባ ቡቴን ቡቴኒኔ ባ ዲዛ ጉታን ጉታን ባ ባንዲራ ባንዲራ ቶኬቶ። ");
INSERT INTO gmve_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","ጊዶ ኣቲን ኣይ ኣሲካ ዱንካናኮ ሺቂዲ ታና ሃንቄꬂዲ ኢስራኤሌ ዴራ ꬋይሲሶንታ ማላ ሌዌ ዛርኬቲ ሄ ዱንካኔዛ ዩሾን ዱንካኒዲ ናጌቶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ሄሳ ጊሻስ ኢስራኤሌ ኣሳይ ጎዳይ ሙሴ ኣዛዚዳ ማላ ኡባካ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","ጎዳይ ሙሴሲኔ ኣሮኔስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«ኢስራኤሌ ኣሳይ ባ ባጋ ባጋ ኣሳ ኤሪሲዛ ማላታኔ ባንታ ዛርኬ ዛርኬ ኤሪሲዛ ባንዲራ ካሊዲ ጋይቶቴꬃ ዱንካኔዛፔ ጉꬃራ ሃኪዲ ኢዛ ዩሾን ዱንካኖ።» ");
INSERT INTO gmve_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","ኣርሼይ ሞኪዛ ባጋራ ዩሁዳ ዛርኬቲ ኡቴቶ፤ ዩሁዳ ዛርኬ ካሌꬃናይ ኣሚናዳቤ ና ኔኣሶኔ። ");
INSERT INTO gmve_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ኢዚ ካሌꬂዛ ኣሳ ቆዳይ 74,600። ");
INSERT INTO gmve_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","ዩሁዳ ዛርኬታፔ ካሊዲ ዪሳኮሬ ቆሞቲ ኢስታ ማታን ዱንካኒ ኡቴቶ፤ ዪሳኮሬ ዛርኬታ ካሌꬃናይ ጹኣሬ ና ናቲናኤሌ። ");
INSERT INTO gmve_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ሄ ኢዛፔ ጋርሳራ ዲዛ ኣሳ ቆዳይ 54,400። ");
INSERT INTO gmve_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ዪሳኮሬ ዛርኬታፔ ካሊዲ ዛቢሎኔ ዛርኬቲ ዱንካኒ ኡቴቶ፤ ዛቢሎኔ ዛርኬታ ካሌꬃናይ ሄሎኔ ና ኤልያቤ። ");
INSERT INTO gmve_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ኢዛስ ዲዛ ኣሳ ቆዳይ 57,400። ");
INSERT INTO gmve_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","ባ ዛርኬን ዛርኬን ጊዲዲ ዩሁዳ ዛርኬቲ ዱንካኒዳ ባጋራ ኡቲዳ ኣሳ ቆዳይ ኩሜꬅ 186,400፤ ኣሳፔ ሲንꬅ ቢዛይ ሃይሳ ሃ ቡቴዛን ዲዛ ኣሳ። ");
INSERT INTO gmve_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","ዱጌሃ ባጋራ ኦሮቤሌ ዛርኬቲ ባ ባጋታ ኤሪሲዛ ማላታ ጋርሳን ዱንካኒ ኡቴቶ፤ ኦሮቤሌ ዛርኬታ ካሌꬂዛይ ሻዱሬ ና ኤልጹሬ። ");
INSERT INTO gmve_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ኢስታ ቆዳይ 46,500። ");
INSERT INTO gmve_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","ኦሮቤሌ ዛርኬታፔ ካሊዲ ሲሞና ዛርኬቲ ዱንካኒ ኡቴቶ፤ ኢስታ ካሌꬃናይ ጹርሻዳዬ ና ሳሉምኤሌ። ");
INSERT INTO gmve_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ኢስታ ቆዳይ 59,300። ");
INSERT INTO gmve_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ኢስታፌ ካሊዲ ጋዴ ዛርኬቲ ዱንካኒ ኡቴቶ፤ ጋዴ ዛርኬታ ካሌꬃናይ ኤራኡኤሌ ና ኤልያሳፌ። ");
INSERT INTO gmve_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ሄይታንታ ቆዳይ 45,650። ");
INSERT INTO gmve_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","ኢስቲ ባ ዛርኬን ዛርኬን ጊዲዲ ኦሮቤሌይ ዱንካኒ ኡቲዳ ባጋራ ዱንካኒዳ ኣሳ ቆዳይ ኩሜꬅ 151,450 ጊዲዴስ፤ ዩሁዳ ቡቴዛፔ ካሊዲ ናምኣንꬆራ ቢዛይ ኦሮቤሌ ቡቴዛ። ");
INSERT INTO gmve_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","ኮይሮ ናምኡ ቡቴታፔኔ ዉርሴꬃ ናምኡ ቡቴታፔ ጊዶን ሌዌ ባጋቲ ጋይቶቴꬃ ዱንካኔዛ ቶኪዲ ቤቶ፤ ኢሲ ኢሲ ቡቴይ ባ ቆሞይ ሻኬቲ ኤሬታና ማላ ዱማ ማላታ ጋርሳን ባንታ ታራ ታራ ናጊዲ ቤቶ። ");
INSERT INTO gmve_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","ኣርሼይ ዉሊዛ ባጋራ ኤፍሬሜ ዛርኬቲ ባ ባጋታ ኤሪሲዛ ማላ ጋርሳን ዱንካኒ ኡቴቶ፤ ኤፍሬሜ ዛርኬ ካሌꬃናይ ኣሚሁዴ ና ኤልሻማ። ");
INSERT INTO gmve_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ኢስታስ ቆዳይ 40,500። ");
INSERT INTO gmve_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","ኤፍሬሜ ዛርኬታፔ ካሊዲ ሚናሴ ዛርኬቲ ዱንካኔቶ፤ ሚናሴ ዛርኬታ ካሌꬃናይ ፔዳጹሬ ና ጋማልኤሌ። ");
INSERT INTO gmve_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ኢስታ ቆዳይ 32,200። ");
INSERT INTO gmve_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","ኢስታፌ ካሊዲ ቢኒያሜ ዛርኬቲ ዱንካኒ ኡቴቶ፤ ቢኒያሜ ዛርኬታ ካሌꬃናይ ጊዲኦኔ ና ኣቢዳኔ። ");
INSERT INTO gmve_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ሄ ኢስታ ቆዳይ 35,400። ");
INSERT INTO gmve_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ኢስቲ ባ ዛርኬን ዛርኬን ጊዲዲ ኤፍሬሜ ዛርኬቲ ዱንካኒ ኡቲዳ ባጋራ ዱንካኒዳ ኣሳ ቆዳይ 108,100 ጊዲዴስ፤ ኦሮቤሌ ቡቴዛ ካሊዲ ሄꬓንꬆን ኤፍሬሜ ቡቴይ ቦ። ");
INSERT INTO gmve_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","ፑዴሃ ባጋራ ዳኔ ዛርኬቲ ባ ባጋታ ኤሪሲዛ ማላታ ጋርሳን ዱንካኒ ኡቴቶ፤ ዳኔ ቆሞታ ካሌꬃና ሃላቃይ ኣሚሻዳዬ ና ኣሂኤዜሬ። ");
INSERT INTO gmve_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ኢስታ ቆዳይ 62,700። ");
INSERT INTO gmve_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","ዳኔ ዛርኬታፔ ካሊዲ ኣሴሬ ዛርኬቲ ዱንካኒ ኡቴቶ፤ ኣሴሬ ዛርኬታ ካሌꬃና ሃላቃይ ኦክራ ና ፋጉኤሌ። ");
INSERT INTO gmve_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ኢስታ ቆዳይ 41,500። ");
INSERT INTO gmve_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","ኢስታፌ ካሊዲ ኒፍታሌሜ ዛርኬቲ ዱንካኒ ኡቴቶ፤ ኒፍታሌሜ ዛርኬታ ካሌꬃና ሃላቃይ ኤናኔ ና ኣሂሬ። ");
INSERT INTO gmve_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ሄይታንታ ቆዳይ 53,400። ");
INSERT INTO gmve_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","ኢስቲ ባ ዛርኬን ዛርኬን ጊዲዲ ዳኔ ዛርኬቲ ዱንካኒ ኡቲዳ ባጋራ ዱንካኒዳ ኣሳ ቆዳይ ኩሜꬅ 157,600 ጊዲዴስ። ሄሳꬆካ ዳኔ ዛርኬቲ ዉርሴꬃን ኦይዳንꬆ ማራን ቤቶ። ");
INSERT INTO gmve_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ኢስራኤሌ ኣሳይ ባሶን ባሶኒኔ ባ ዛርኬን ዛርኬን ማዝጋቤቲዳይታ ቆዳይ ኢሲ ቦላ 603,550 ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","ሌዌ ዛርኬቲ ጊዲኮ ጎዳይ ካሴ ሙሴ ኣዛዚዳ ማላ ሃንኮ ኢስራኤሌ ኣሳራ ቆዴቲቤቴና። ");
INSERT INTO gmve_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","ሄሳ ማላን ኢስራኤሌ ኣሳይ ጎዳይ ካሴ ሙሴ ኣዛዚዳ ማላ ኦꬂዳ፤ ኢስታ ዛርኬታፔ ኢሶይ ኢሶይ ባ ባንዲራ ባንዲራ ካሊ ካሊ ዱንካኒ ኡቲዴስ፤ ኢሶይ ኢሶይ ባ ሶ ኣሳራ ኢሲፌ ሄሜቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","ጎዳይ ሙሴ ሲና ዙማ ቦላ ሃሳይሲዛ ዎዴ ኣሮኔ ዬሌታይኔ ሙሴ ዬሌታይ ሃይሳፌ ካሊ ዲዛይሳ፤ ");
INSERT INTO gmve_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ኣሮኔስ ኦይዱ ኣቱማ ናይቲ ዴቴስ፤ ሄይቲካ ባይራዚ ናዳቤ ጊዲሺን ሃንኮይቲ ኣቢሁ፥ ኤልኤዜሬኔ ኢታማሬ። ");
INSERT INTO gmve_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ሄይቲ ቄሴቴꬃን ኦꬃና ማላ ቲዬቲዳኔ ሱሚዳ። ");
INSERT INTO gmve_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ጊዶ ኣቲን ኢስታ ጋርሳፌ ናዳቤይኔ ኣቢሁይ ሲና ባዞን ጎዳ ሲንꬃን ቤሶንታ ታማ ኤሂዲ ኤꬂዳ ጊሻስ ጎዳ ሃንቆን ቦሼቲ ሃይቂዳ፤ ኢስታስ ናይ ባይንዳ ጊሻስ ኤልኤዜሬይኔ ኢታማሬይ ጻላ ኢስታ ኣዋ ኣሮኔይ ሼምፖራ ፓጻ ዲዛ ዎዴ ኡባን ቄሴቴꬃን ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«ኔኒ ሌዌ ዛርኬታ ሺሻዳ ኢስቲ ቄሴ ኣሮኔ ኦሶን ማዳና ማላ ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","ኢስቲ ኣሮኔኔ ኩሜꬃ ማባራ ጋይቶቴꬃ ዱንካኔዛ ጊዶን ኦꬂ ማዶን ባ ኦሶዛ ኦꬂ ፖሌቶ። ");
INSERT INTO gmve_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ጋይቶቴꬃ ዱንካኔዛ ጊዶን ዲዛ ኦሶ ሚሻታስ ኢስታ ኣላፌ ጊዴቶ፤ ዱንካኔዛ ጊዶን ኢስራኤሌ ኣሳስ ኦሴቲዛ ኦሶ ኦꬂ ፖሌቶ። ");
INSERT INTO gmve_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","ኢስራኤሌ ኣሳ ኡባፌ ኢስቲ ሻኬቲዲ ኣሮኔኔ ኢዛ ናይታ ኦሶን ማዳና ማላ ሌዌ ዛርኬታ ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","ቄሴቴꬃ ኦሶዛ ኢስቲ ፖላና ማላ ኣሮኔኔ ኢዛ ናይታ ኔ ሱንꬃ፤ ኢስታፌ ኣቲን ሃራ ኣሲ ሃይሳ ሃ ኦሶዛ ኦꬃናስ ጋይቶቴꬃ ዱንካኔዛኮ ሺቂዛ ጊዲኮ ኢዛዴይ ሃይቆን ቃጻዬቶ።» ");
INSERT INTO gmve_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","«ሄኮ ሌዌ ቆሞቲ ታስ ሃጋዚዛይታ፤ ታኒ ጊብጼ ዴሬ ኣሳ ባይራ ዉርሳ ዎꬊዳ ዎዴ ኢስራኤሌ ኣሳፔ ኢሳፌ ኢሳፌ ዬሌቲዳ ባይራኔ ኢስታ ሜሄታ ባይራታ ኩሜꬅ ታስ ዱማሳዲስ፤ ጊዶ ኣቲን ሃኢ ቃሴ ባይራ ጊዲ ዬሌቲዳ ኣቱማ ናይታ ሶሆን ሌዌ ዛርኬታ ታኒ ታስ ዶራዲስ፤ ኢስቲ ታስ ኦꬂዛይታ ጊዳና፤ ታኒ ጎዳ።» ");
INSERT INTO gmve_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","ጎዳይ ሙሴስ ሲና ዙማ ቦላ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«ሌዌ ዛሬታ ኢስታ ኢስታ ዛርኬን ዛርኬኒኔ ኢስታ ቆሞን ቆሞን ቆዳ፤ ዬሌቲን ኢዛስ ኢሲ ኣጊና ኩሚዳይሳኔ ሄሳፌ ቦላራ ዲዛ ኣቱማ ና ዉርሳካ ቆዳ።» ");
INSERT INTO gmve_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","ሙሴይካ ጎዳይ ኢዛ ኣዛዚዳ ማላ ቆዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","ሌዌስ ሄꬑ ኣቱማ ናይቲ ዴቴስ፤ ሄይቲካ ጌርሾኔ፥ ቃኣቴኔ ሜራሬ ጌቴቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ጌርሾኔ ዛርኬቲ ሊቢናኔ ሺምኤ ጌቴቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","ቃኣቴ ዛርኬቲ ኣሚራሜ ዪጺሃሬ፥ ኬብሮኔኔ ኡዚኤሌ ጌቴቴቴስ ");
INSERT INTO gmve_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","ሜራሬ ዛርኬቲ ማሂሌኔ ሙሼ ጌቴቴቴስ፤ ሄይታንቲ ባ ሱንꬃን ሱንꬃን ባ ኬꬃ ኣሳስ ኣዋቲዛይታ። ");
INSERT INTO gmve_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","ሊቢናኔ ሺምኤ ኬꬃ ኣሳይ ጌርሾኔ ዛርኬን ቆዴቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ዬሌቲን ኢሲ ኣጊና ጊዲዳ ናፔ ዶሚዲ ማዝጋቤቲዳ ኣቱማሳ ቆዳይ 7,500። ");
INSERT INTO gmve_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","ጌርሾኔ ባጋቲ ዱንካኔዛፔ ጉዬ ባጋራ ኣርሼይ ዉሊዛ ባጋራ ዱንካኒዳ። ");
INSERT INTO gmve_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ጌርሾኔ ባጋታ ካሌꬂዛይ ላኤሌ ና ኤልያሳፌ። ");
INSERT INTO gmve_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","ጋይቶቴꬃ ዱንካኔን ጌርሾኔ ዛርኬታ ኣላፌቴꬂ፥ ጋይቶቴꬃ ዱንካኔዛ ካማታኔ ፔንጌ ቦላ ቃጴቲዛ ማጋላሻታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ጊቤዛ ጊዶ ማጋላሻታ፥ ዱንካኔዛኔ ያርሾ ያርሺዛሶዛ ዩዪ ኣꬊዳ ጊቤዛ ፔንጋ ማጋላሻ ቶሌታኔ ሄሳꬆካ ሄይታንታስ ጊዲዛ ሚሻታ ኡባታ ናጎ። ");
INSERT INTO gmve_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","ኣሚራሜ፥ ዪጺሃሬ፥ ኬብሮኔኔ ኡዚኤሌ ሶ ኣሳይ ቃኣቴ ዛርኬን ቆዴቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ዬሌቲን ኢሲ ኣጊናኔ ሄሳፌ ቦላራ ጊዲዳ ኣቱማሳ ቆዳይ 8,600፤ ሄይታንቲ ጋይቶቴꬃ ዱንካኔዛ ናጌቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","ቃኣቴ ዛርኬቲ ጋይቶቴꬃ ዱንካኔዛፔ ጉዬራ ዱጌሃ ባጋራ ዱንካኒዳ። ");
INSERT INTO gmve_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ቃኣቴ ቆሞታ ካሌꬂዛ ኮራፒኔይ ኡዚኤሌ ና ኤልጻፋኔ። ");
INSERT INTO gmve_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","ኢስታ ኣላፌቴꬂ ጫቆ ቃላ ታቦታ ቦላ፥ ማዳ ኢዛ ቦላ ዎꬂዛ ጻራጴዛ ቦላ፥ ጾምፔ ኢዛ ቦላ ዎꬂዛይሳ ቦላ፥ ያርሾ ኢዛ ቦላ ያርሺዛይሳ ቦላ፥ ቄሴቲ ዱማ ቆልኣዛን ጎኤቲዛ ሚሻታ ቦላ፥ ጌዴ ዱንካኔዛስ ኡባፌ ዱማቲዳ ጊዶ ቆልኣ ጌሊዛሶ ባጋራ ዲዛ ማጋላሻ ጊዲሺን ኩሜꬅ ሃይታ ሃ ሚሻታ ቦላ ኢስታስ ናጋና ኣላፌቴꬂ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ሌዌ ዛርኬ ኡባ ሃላቃይ ቄሴ ኣሮኔ ና ኤልኤዜሬ፤ ኢዚ ዱማቲዳ ቆልኣን ኦꬂዛይታ ኡባ ቦላ ኣላፌ። ");
INSERT INTO gmve_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","ማሂሌ ሶ ኣሳይኔ ሙሼ ሶ ኣሳይ ሜራሬ ዛርኬራ ኢሲኖ ጊዲዳ፤ ሄይቲ ሜራሬ ዛርኬን ቆዴቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","ዬሌቲን ኢሲ ኣጊና ጊዲዳ ጉꬃ ናፔ ዶሚዲ ቆዴቲዳ ኣቱማሳ ቆዳይ ኡሱፑን ታማኔ ናምኡ ጼታ። ");
INSERT INTO gmve_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","ሜራሬ ዛርኬታ ካሌꬂዛይ ጹሪኤሌ ና ኣቢኤሌ፤ ኢስቲ ጋይቶቴꬃ ዱንካኔዛፔ ፑዴሃ ባጋራ ዱንካኒ ኡቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","ኢስታ ኣላፌቴꬂ ዱንካኔዛ ቶሌታ፥ ኮላታታ፥ ቱሳታኔ ቱሳታ ኢስታን ኤሲዛ ቶሆታ፥ ሄሳꬆካ ሃራ ኦሶስ ጎኤቲዛ ሚሻታ ቦላኔ ሄይታንታስ ቤሲዛ ኦሶታ ኦꬃና ኣላፌቴꬂ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ሄሳꬆካ ጊቤዛ ዩሾን ዲዛ ቱሳታ፥ ዱንካኔዛ ቶሌታ፥ ꬊሽኬታኔ ቶሌ ዎዶሮታ ቦላ ኣላፌቴꬂ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","ጋይቶቴꬃ ዱንካኔዛፔ ኣርሼይ ሞኪዛ ባጋራ ዱንካኒ ኡታናይቲ ሙሴ፥ ኣሮኔኔ ኢዛ ናይታ፤ ጋይቶቴꬃ ዱንካኔ ጊዶን ኢስራኤሌ ኣሳ ጊሻስ ኦሴቲዛ ኣይ ኦሶ ጊዲኮካ ሄ ኦሶዛ ዎጋ ፖሊሲዛ ኣላፌይ ኢስታ ጊዴቶ፤ ሃራይ ኦኒካ ጌዴ ጋይቶቴꬃ ዱንካኔ ኬꬃዛኮ ሺቂኮ ሃይቆን ቃጻዬቶ። ");
INSERT INTO gmve_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","ጎዳይ ኢስታ ኣዛዚዳ ማላ ሙሴይኔ ኣሮኔይ ዬሌቲን ኢሲ ኣጊና ጊዲዳ ናፔ ዶሚዲ ኣሳይ ባ ኬꬃን ኬꬃን ማዝጋቢዳ ሌዌ ቆሞታፔ ኣቱማ ናይቲ ኩሜꬅ 22,000 ጊዲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","ጎዳይ ሙሴስ፥ «ኢስራኤሌን ባይራ ጊዲ ዬሌቲዳ ኣቱማ ናይታስ ላይꬃይ ኢሲ ኣጊናኔ ሄሳፌ ቦላራ ጊዲዳይታ ቆዳዳ ኢስታ ሱንꬃ ጻፋ። ");
INSERT INTO gmve_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","ኢስራኤሌ ኣሳ ባይራ ናይታ ኡባ ሳማ ሌዌ ናይታ፥ ሄሳꬆካ ኢስራኤሌ ኣሳ ሜሄ ባይራ ኡባ ሳማ ሌዌ ቆሞታ ሜሄ ኤካ፤ ታኒ ጎዳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","ሙሴይካ ባና ጎዳይ ኣዛዚዳ ማላ ኢስራኤሌ ኣሳ ጋርሳን ባይራ ጊዲ ዬሌቲዳይታ ኡባ ቆዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ኢስቲ ዬሌቲን ኢሲ ኣጊናኔ ሄሳፌ ቦላራ ጊዲዳ ባይራ ኣቱማ ናይታ ኡባ ኢስታ ሱንꬃን ሱንꬃን ቆዲን ኢስታ ቆዳይ 22,273 ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«ሄሳ ጊሻስ ባይራ ጊዲ ዬሌቲዳ ኢስራኤሌ ኣሳ ኣቱማ ናይታ ሶሆን ሌዌታ ኔ ታስ ሻካ፤ ሄሳꬆካ ኢስራኤሌ ኣሳ ሜሄ ባይራ ሶሆን ሌዌታ ሜሄ ታስ ዱማሳ፤ ታኒ ጎዳ። ");
INSERT INTO gmve_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","ኢስራኤሌ ኣሳይ ዬሊዳ ባይራ ናይታ ቆዳይ ሌዌ ቆሞታፔ 273 ጊዲ ዳሪዛ ጊሻስ ሄይታ ቲርፓ ኣቱማ ናይታ ሚሻን ዎዛ። ");
INSERT INTO gmve_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ኢሳ ኢሳ ዎዛናስ ጋይቶቴꬃ ዱንካኔ ሜዛኔዛ ማላ ኢቻሹ ሳቂሌ ቢራ ኤካ፤ ");
INSERT INTO gmve_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ሄ ኣቲዳ ዎዞ ሚሻ ኣሮኔሲኔ ኢዛ ናይታስ ኢማ።» ");
INSERT INTO gmve_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","ሙሴይካ ሌዌ ቆሞታን ዎዜቲዳይታፔ ቦላራ ቲርፒዳ 273 ኣሳታ ጊሻስ ሺቂዳ ዎዞ ሚሻ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ኢስራኤሌ ኣሳ ባይራታፔ ጋይቶቴꬃ ዱንካኔ ሜዛኔዛ ማላ ሚሻ 1,365 ሳቂሌ ቢራ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","ጎዳይ ኣዛዚዳ ማላ ሙሴይ ዎዞ ሚሻ ኣሮኔሲኔ ኢዛ ናይታስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","ጎዳይ ሙሴሲኔ ኣሮኔስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«ሌዌ ናይታ ጊዶፌ ቃኣቴ ዛሬታ ኢስታ ሶ ኣሳን ኣሳን ኢስታ ማታ ዳቦን ዳቦን ቆዳ። ");
INSERT INTO gmve_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ጋይቶቴꬃ ዱንካኔዛን ኦꬃናስ ዳንዳይዛይታ፥ ኢስታ ላይꬂ ሄꬑ ታማፌ ቢዲ ኢቻሹ ታሙ ጋካናስ ዲዛ ኣቱማሳታ ኡባ ማዝጋባ። ");
INSERT INTO gmve_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","ኢስቲ ኦꬃና ኦሶይ ጋይቶቴꬃ ዱንካኔዛ ጊዶን ዲዛ ኡባፌ ዱማ ጌሻ ሚሻታ ናጎ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","ኣሳይ ባ ዲዛሶፔ ዴንዲ ቢሺን ኣሮኔይኔ ኢዛ ናይቲ ዱንካኔዛን ጌሊዲ ጫቆ ቃላ ታቦታዛ ሲንꬃን ዲዛ ማጋላሻ ዱጌ ዎꬂዲ ጫቆ ቃላ ታቦታዛ ኢዛን ጻጼቶ። ");
INSERT INTO gmve_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ኢዛ ካማናስ ቃጬቲዳ ጋልባ ማጋላሻዛ ቦላራ ዎꬂዲ ሄሳ ቦላ ሙሌራ ሳሎ ሚሳቲዛ ካሬꬃ ማይኦ ኢዛ ቦላ ሚጪዲ ማይዜቶ፤ ሂስቲዲ ቶሆ ሚꬃታ ቃላባቴ ሉኮዛን ጌልꬄቶ። ");
INSERT INTO gmve_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","«ጎዳስ ሺቂዛ ዱማ ኡኬꬃ ኢዛ ቦላ ዎꬂዛ ጋባቴዛ ሳሎ ሚሳቲዛ ካሬꬃ ጫርቃን ካሜቶ፤ ጋባቴዛ ቦላ ሼልኤታ፥ ጪልፋታ፥ ጹኣታኔ ዎይኔ ኡሹ ዱቂዛ ሚሻታኔ ኡኬꬅ ኡባ ዎዴ ፓጬይ ባይንዳ ኢዛ ቦላ ዎꬄቶ። ");
INSERT INTO gmve_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ሄሳ ኡባ ዞኦ ጫርቃን ካሚዲ ቦላራ ቃጬቲዳ ጋልባ ማይዜቶ፤ ኢስታን ቶኪዛ ቶሆ ሚꬃታ ቃላባቴ ሉኮዛን ጌልꬄቶ። ");
INSERT INTO gmve_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","«ሳሎ ሚሳቲዛ ካሬꬃ ጫርቃዛ ኤኪዲ ጾምፔ ኢዛ ቦላ ዎꬂዛይሳኔ ጾምፔታ፥ ቃጴታኔ ቢዲንꬅ ዎꬂዛ ኮንኣታ፥ ሄሳꬆካ ዛይቴ ዎꬂዛ ሚሻታ ኡባ ኢሲ ቦላ ካሜቶ። ");
INSERT INTO gmve_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ጾምፔዛኔ ጾምፔዛስ ኮሺዛ ሚሻታ ኡባካ ኢዛ ካሚዛ ጋልባን ጻጺዲ ኢዛራ ቶኪዛ ሃላ ቦላ ዎꬄቶ። ");
INSERT INTO gmve_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","«ካሌꬂዲ ዎርቃፌ ኦሴቲዳ ያርሾ ያርሺዛይሳ ቦላ ሳሎ ሚሳቲዛ ጫርቃን ካሚዲ ቃጬቲዳ ጋልባ ቦላራ ማይዚዲ ቶሆ ሚꬃታ ኢዛን ጌልꬄቶ። ");
INSERT INTO gmve_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","ጋይቶቴꬃ ዱንካኔን ጎኤቲዛ ሚሻታ ኡባ ኤኪዲ ሳሎ ማላ ካሬꬃ ጫርቃን ካሜቶ፤ ቃጬቲዳ ሌኤ ጋልባ ኢዛ ቦላራ ካሚዲ ቶሆ ሚꬃ ቦላ ዎꬄቶ። ");
INSERT INTO gmve_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","ቢዲንꬃዛ ያርሾ ያርሺዛሶዛ ቦላፌ ፒቲዲ ያርሾ ያርሺዛሶዛ ኦቻ ቴራ ሚሳቲዛ ጫርቃን ካሜቶ። ");
INSERT INTO gmve_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ያርሾ ያርሺዛሶዛን ኦꬃናስ ጎኤቲዛ ሚሻታ ሄይቲካ ሁላሌታ፥ ሜንጾታ፥ ታማ ካሺዛ ሚሻታኔ ጉቃ ሳኔታ ኢዛ ቦላ ዎꬄቶ፤ ቃጬቲዳ ሌኤ ጋልባ ኢዛ ቦላ ካሚዲ ቶሆ ሚꬃታ ኢዛን ጌልꬄቶ። ");
INSERT INTO gmve_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","ኢስቲ ባ ዲዛ ሄራፔ ዴንዲ ቢሺን ኣሮኔይኔ ኢዛ ናይቲ ጌሻ ሚሻታኔ ሄ ሚሻቲ ኢስታን ጎኤቲዛ ሚሻታ ኡባካ ካሚዳፔ ጉዬ ቃኣቴ ናይቲ ዪዲ ቶኬቶ፤ ጊዶ ኣቲን ኢስቲ ሃይቆንታ ማላ ሄ ጌሻ ሚሻታ ኩሼን ቦቻናስ ቤሴና፤ ሄሳ ጊሻስ ጋይቶቴꬃ ዱንካኔዚ ዴንዲዛ ዎዴ ሄሲ ዉሪካ ቃኣቴ ናይታ ኣላፌቴꬃ። ");
INSERT INTO gmve_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","«ቄሴዛ ኣሮኔ ና ኤልኤዜሬይ ጾምፔዛ ዛይቴ ሎኦ ሳዎ ሳዊዛ ኤጻኔ፥ ኡባ ዎዴ ሺቂዛ ካꬃ ያርሾዛኒኔ ቲዬቲዛ ዛይቴዛ ቦላ ኢዛስ ኣላፌቴꬂ ዴኦ፤ ሄሳꬆካ ጋይቶቴꬃ ዱንካኔዛኔ ኢዛ ጊዶንካ ዲዛ ጌሻ ሚሻታ ኡባ ናጎ።» ");
INSERT INTO gmve_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","ጎዳይ ሙሴኔ ኣሮኔ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«ቃኣቴ ናይቲ ሌዌ ቆሞታ ጊዶፌ ꬋያና ማላ ኦꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ጌዴ ኡባፌ ዱማ ጌሻ ሚሻታኮ ሺቂዲ ኢስቲ ሃይቆንታ ማላ ኢስታ ኣሮኔይኔ ኢዛ ናይቲ ጋይቶቴꬃ ዱንካኔን ጌሊዲ ኣሳስ ኢሳስ ኢሳስ ኦሶኔ ኢዛዴ ቶሆ ሻኪ ኢሜቶ። ");
INSERT INTO gmve_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ጊዶ ኣቲን ኢስቲ ሃይቆንታ ማላ ቃኣቴ ናይቲ ዱንካኔዛ ጊዶ ጌሊዲ ቤያናስ ጉꬃ ዎዴስካ ጼሎፔቶ።» ");
INSERT INTO gmve_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«ሌዌ ዛርኬታ ጋርሳፌ ጌርሾኔ ናይታ ኢስታ ዳቦን ዳቦኒኔ ኢስታ ዬሌታን ዬሌታን ቆዳ። ");
INSERT INTO gmve_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ጋይቶቴꬃ ዱንካኔዛን ኦꬃናስ ዳንዳይዛይታ ሄꬑ ታሙ ላይꬃፌ ቢዲ ኢቻሹ ታሙ ላይꬅ ጋካናስ ዲዛ ኣቱማሳታ ኡባ ቆዳ። ");
INSERT INTO gmve_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","«ዱማ ዱማ ሚሻታ ቶካና ኣላፌቴꬂ ኢስታስ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ጋይቶቴꬃ ዱንካኔዛ ሶ ባጋራኔ ካሬ ባጋራ ካሚዛ ቦላራካ ኢዛ ቦላ ካሚዛ ቃጬቲዳ ሌኤ ጋልባኔ ጌሎሶ ፔንጌዛካ ቶኬቶ። ");
INSERT INTO gmve_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ሄሳꬆካ ዱንካኔዛኔ ያርሾ ያርሾሶሆ ጊቤዛ ዩዪ ኣꬊዳ ማጋላሻታ፥ ቶሌ ዎዶሮታ፥ ጊቤ ጌሊዛሶ ፔንጌ ማጋላሻታኔ ሄይታንታ ኦꬃናስ ጊጌቲዳ ሚሻታካ ኢስቲ ቶኬቶ፤ ሄይታ ሄ ሚሻታስ ጊዲዛ ኣይ ኦሶካ ኢስቲ ፖሌቶ። ");
INSERT INTO gmve_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ጌርሾኔ ናይቲ ኦꬂዛ ኦሶ ጊዲን ዎይኮ ቶሆ ጊዲን ኣሮኔይኔ ኢዛ ናይቲ ኢስታ ኣዛዚዳ ማላ ኦꬄቶ፤ ኢስቲ ቶካናስ ቤሲዛ ሚሻ ኩሜꬅ ኔ ኢስታስ ጊሻ ኢማ። ");
INSERT INTO gmve_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ጋይቶቴꬃ ዱንካኔዛ ጊዶን ጌርሾኔ ናይታ ኦሶይ ሄሳ፤ ኢስታ ኦሶ ቄሴ ኣሮኔ ና ኢታማሬይ ጼሊ ኦሲሶ። ");
INSERT INTO gmve_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«ሌዌ ዛርኬፌ ጊዲዳ ሜራሬ ናይታ ኢስታ ዛርኬን ዛርኬኒኔ ኢስታ ዬሌታን ዬሌታን ቆዳ። ");
INSERT INTO gmve_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ጋይቶቴꬃ ዱንካኔ ጊዶን ኦꬃናስ ዳንዳይዛይታ ኢስታስ ላይꬃይ 30 ላይꬃፌ ቢዲ 50 ላይꬅ ጋካናስ ዲዛ ኣቱማሳታ ኡባ ቆዳ። ");
INSERT INTO gmve_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","ኢስቲ ቶካናስ ቤሲዛይ ዱንካኔዛ ቶሌታኔ ቶሌታ ጊዶራ ጌሊዛይታ፥ ቱሳታ፤ ዱንካኔዚ ኢዛን ቶሌቲዛ ሚሻታ። ");
INSERT INTO gmve_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ሄሳꬆካ ዱንካኔዛ ዩሾን ዲዛ ዴምባን ኤቂዛ ቱሳታ ቶሆታ፤ ቶሌታ ዎዶሮታኔ ሄይታ ኡባታስ ኮሺዛ ሚሻታ፤ ኢሲ ኢሲ ኣሲ ቶካናስ ቤሲዛ ሚሻይ ኢዛ ሱንꬃን ሱንꬃን ኢዛስ ኡቶ። ");
INSERT INTO gmve_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","ቄሴ ኣሮኔ ና ኢታማሬይ ኦሶዛ ናጌቲ ኦሲሳናስ ጋይቶቴꬃ ዱንካኔ ጊዶን ሜራሬ ናይታ ሶ ኣሳ ኦሶይ ሃይሳ።» ");
INSERT INTO gmve_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","ሙሴይ፥ ኣሮኔይኔ ዴሬዛ ሃላቃቲ ቃኣቴ ዜሬꬃታ ኢስታ ዛርኬን ዛርኬኒኔ ኢስታ ዳቦን ዳቦን ቆዲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","ጋይቶቴꬃ ዱንካኔዛ ጊዶን ኦꬃናስ ኦሶን ጌሊዳይታ ኩሜꬅ 30 ላይꬃፌ ቢዲ 50 ላይꬅ ጊዲዳይታ ቆዲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ቆዴቲዳ ኣሳይ 2,750 ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","ጎዳይ ካሴ ሙሴ ኣዛዚዳ ማላ ጋይቶቴꬃ ዱንካኔዛን ኦꬂዳይቲ ሙሴይኔ ኣሮኔይ ቆዲዳ ቃኣቴ ሶ ኣሳይ ሃይታንታ። ");
INSERT INTO gmve_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","ባ ዛርኬን ዛርኬኒኔ ባ ዳቦን ዳቦን ቆዴቲዳ ጌርሾኔ ናይቲ፥ ");
INSERT INTO gmve_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","ጋይቶቴꬃ ዱንካኔዛን ኦꬃና ጌላናስ ዳንዳይዛይታስ ላይꬃይ ሄꬑ ታማፌ ቢዲ ኢቻሹ ታሙ ላይꬅ ጋካናስ ዲዛይቲ ዉሪካ፥ ");
INSERT INTO gmve_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ናምኡ ሺያኔ ኡሱፑን ጼታኔ ሄꬑ ታማ። ");
INSERT INTO gmve_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","ጎዳይ ሙሴ ኣዛዚዳ ማላ ጋይቶቴꬃ ዱንካኔዛን ኦꬂዳይቲኔ ሙሴይኔ ኣሮኔይ ቆዲዳ ጌርሾኔ ናይቲ ሃይታንታ። ");
INSERT INTO gmve_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","ባ ዛርኬን ዛርኬኒኔ ባ ዳቦን ዳቦን ቆዴቲዳ ሜራሬ ናይቲ፥ ");
INSERT INTO gmve_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","ጋይቶቴꬃ ዱንካኔዛን ኦꬃና ጌላናስ ዳንዳይዛይታስ ላይꬃይ ሄꬑ ታማፌ ቢዲ ኢቻሹ ታሙ ላይꬅ ጋካናስ ዲዛይቲ ዉሪካ፥ ");
INSERT INTO gmve_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ሄꬑ ሺያኔ ናምኡ ጼታ። ");
INSERT INTO gmve_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","ጎዳይ ሙሴ ኣዛዚዳ ማላ ጋይቶቴꬃ ዱንካኔዛን ሃጋዚዛ ሙሴይኔ ኣሮኔይ ቆዲዳ ሜራሬ ናይቲ ሃይታንታ። ");
INSERT INTO gmve_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","ሙሴይ፥ ኣሮኔይኔ ኢስራኤሌ ሃላቃቲ ኢስታ ቆሞን ቆሞኒኔ ኢስታ ዛርኬን ዛርኬን ቆዲዳ ሌዌ ናይቲ፥ ");
INSERT INTO gmve_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ሄꬑ ታሙ ላይꬃፌ ዶሚዲ 50 ላይꬅ ጋካናስ ዲዛይቲ ጋይቶቴꬃ ዱንካኔዛ ጊዶን ኦሶዛ ኦꬃናስ ኦꬂዛ ሚሻታ ቶካናስ ጌሊዳይቲ፥ ");
INSERT INTO gmve_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ሙሌራ ኢስታ ቆዳይ 8,580። ");
INSERT INTO gmve_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","ሄሳ ማላን ኢሲ ኢሲ ኣሲ ጎዳይ ሙሴ ኣዛዚዳ ማላ ቆዴቲዴስ፤ ሄሳꬆካ ጎዳይ ሙሴስ ኢሚዳ ኣዛዞ ማላ ኢሲ ኢሲ ኣሲ ቶካናስ ኣላፌቴꬅ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«ኢንቺራቻ ሃርጌይ ኢዛ ቦላ ዲዛዴ ዎይኮ ኢዛ ቦላፌ ሃꬃ ማላይ ጎጊዛዴ ዎይኮ ኣሃ ቦቺዲ ቱኒዳዴ ኡባ ኢስራኤሌ ኣሳይ ባ ዲዛ ጉታፔ ካሬ ኬሳና ማላ ኣዛዛ። ");
INSERT INTO gmve_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ታኒ ኢስታራ ዲዛ ኢስታ ጉታ ኢስቲ ቱኒሶንታ ማላ ሄይታ ጌዮንታ ኣሳታ ኡባ ኣዴ ጊዲን ማጫ ጊዲን ኢንቴ ጊዶፌ ኬሲ ጎዲቴ።» ");
INSERT INTO gmve_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ጎዳይ ሙሴ ኣዛዚዳ ማላ ኢስራኤሌ ኣሳይ ባ ጉታፔ ኢስታ ኬሲ ጎዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«ኔኒ ኢስራኤሌ ኣሳስ፥ ማጫፌ ጊዲን ኣቱማሳፔ ኣይ ኣሲካ ጎዳስ ኣማኔቶንታዴ ጊዲ ቤቲዲ ኣይ ኣሳ ቦላካ ቆሆ ጋꬂኮ ሄሳዴይ ቆሃንቻ። ");
INSERT INTO gmve_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ኢዚ ባ ናጋራ ፓጾ፤ ባ ቆሆዛ ጊሻስ ቃንጼቲዛ ሚሻ ቦላ ጼታፔ ናምኡ ታሙ ኩሼ ጉጂዲ ቆሄቲዳዴስ ኤሆ። ");
INSERT INTO gmve_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","ጊዶ ኣቲን ሄ ቆሄቲዳዴይ ሃይቂዳ ጊዲኮኔ ኤዳ ኤካናስ ኢዛስ ማታ ዳቦይ ባይንዳ ጊዲኮ ሄ ኤዳይ ጎዳሳ፤ ሄ ኤዳቲዛ ኤዳይ ቆሂዳዴ ናጋራ ዉርሳና ሺቂዛ ያርሾስ ኢሚዛ ꬋርሾዛራ ኢሲፌ ቄሴዛስ ኢሜቶ። ");
INSERT INTO gmve_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","ሄሳ ማላን ኢስራኤሌ ኣሳይ ጎዳስ ኢሚዛ ዱማ ኢሞታይ ዉሪካ ሄ ኢሞታ ኤኪዛ ቄሴዛስ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ኢሲ ኢሲ ኣሲ ጎዳስ ኢሚዛ ዱማ ኢሞታይ ሄ ኢሞታ ኢሚዳዴሳ፤ ጊዶ ኣቲን ኢዚ ቄሴዛስ ኢሚዛ ጊዲኮ ሄ ሚሻይ ቄሴዛሳ።» ");
INSERT INTO gmve_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","ሄሳፌ ጉዬ ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«ኢስራኤሌ ኣሳፔ ኢሳዴ ማቻ ባ ኣዚናስ ኣማኔቶንታ ኣጋዳ ካሬ ካሬ ጊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ሃራ ኣዴራ ዚንኢኮ፥ ቃሴካ ኢዛ ኦꬂዳ ቱና ኦሶይ ቆንጮንታ ኣዚናፔ ጌሚዳ ጊዲኮ፥ ኢዚ ቦላ ማርካቲዛ ኣሲ ቤቶንታ ኣጊን ኢዚ ቱናቴꬃይ ቆንጮንታ ኣጊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ኢዛ ቱኒዳ ጊሻስ ኢዚ ኣዚናይ ኢዞ ሲꬋናስ ዳንዳዬስ፤ ዎይኮ ኢዛ ቱኖንታ ዲሺን ኢዚ ቃናቴን ኩሚዳ ጊሻስ ባ ማቾ ሲꬋና ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ሄሳዴይ ባ ማቺዮ ቄሴኮ ኤኪ ኤሆ፤ ሄ ማጫሳይ ጊሻስ ኮዬቲዛ ኢሲ ኪሎ ባንጋ ꬊሌ ያርሾስ ኤኪ ዮ፤ ሃይሲ ቃናቴስ ሺቂዛ ካꬃ ያርሾይ ቆሆ ቆፍሲዛዝ ጊዲዛ ጊሻስ ዛይቴ ኢዛ ቦላ ጉሶፎ፤ ኤጻኔካ ኢዛ ቦላ ዎꬆፎ። ");
INSERT INTO gmve_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","«ቄሴዚ ማጫሳዮ ኤፊዲ ጎዳ ሲንꬃን ኤሶ። ");
INSERT INTO gmve_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ጌሻ ሃꬅ ጻሮን ዱቂ ኤኮ፤ ጋይቶቴꬃ ዱንካኔ ዉይጌፔ ጉꬃ ቢታ ኤኪዲ ሄ ሃꬃን ጉጆ። ");
INSERT INTO gmve_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ቄሴዚ ማጫሳዮ ጎዳ ሲንꬃን ኤሶ፤ ኢዚ ጎሴ ቢርሾ፤ ቃናቴስ ሺቂዛ ካꬃ ያርሾዛ ኢዚ ኩሼን ዎꬆ፤ ቃሴ ሄ ቄሴዚ ቃንጌꬅ ኤሂዛ ጫሞ ሃꬅ ጻሮራ ባ ኩሼን ኦይኮ። ");
INSERT INTO gmve_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","ቄሴዚ ኢዞ ሂዝጊ ጫቄꬆ፤ ኔኒ ኔ ኣዚናራ ዲሺን ሃራ ኣዴይ ኔናራ ኣቆንታ ጊዲኮኔ ኔኒ ኔና ቱኒሶንታ ጊዲኮ ቃንጌꬅ ኤሂዛ ሃይሲ ጫሞ ሃꬃይ ኔስ ጎሜቶፖ። ");
INSERT INTO gmve_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ጊዶ ኣቲን ኔኒ ኔ ኣዚናፔ ሃራ ኣዴራ ዚንኣዳ ቱኒዳ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","‹ጎዳይ ኔስ ዬላ ኡሎ ሜሊሶኔ ኔ ኡሎ ፑሪሶ! ኔ ዴሬዛ ጋርሳን ኔና ጫቆሲኔ ቃንጌꬃስ ኬሶ። ");
INSERT INTO gmve_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ሃይሲ ሃꬃዚ ጌዴ ኔ ቦላ ጊዶ ጌሊዲ ኔ ኡሎዛ ፑሪሶ! ኔስ ዬላ ኡሎዛ ጉንዲሶ!› ማጫሳያካ፥ ‹ኣሚን! ጎዳይ ታ ቦላ ሄሳꬆ ኦꬆ› ጋ ዛሩ። ");
INSERT INTO gmve_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","«ሄሳፌ ጉዬ ቄሴዚ ሄሳ ሄ ቃንጌꬃ ቃላ ጻꬃ ማጻፋን ጻፎ፤ ሄ ጻፎይሳካ ጫሞ ሃꬃዚ ዲዛ ጻሮዛን ዬጊ ሜጮ። ");
INSERT INTO gmve_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ኢዚ ማጫሳዮ ኢታ ሳኮ ኦይꬂዛ ጫሞ ሃꬃ ኢዞ ኡሻናፔ ሲንꬃን፥ ");
INSERT INTO gmve_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ቄሴዚ ማጫሳይፌ ያርሾ ꬊሌዛ ኤኪዲ ጎዳስ ያኔ ሃ ቃሴꬂ ሺሺዛ ዱማ ያርሾ ጊዳና ማላ ያርሾ ያርሺዛሶዛ ቦላ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ሄሳፌ ጉዬ ካꬃ ያርሾ ኢሲ ዞላ ꬊሌ ኤኪዲ ቆፊሶ ያርሾ ጊዳና ማላ ያርሾ ያርሺዛሶዛ ቦላ ጹጎ፤ ዉርሴꬃን ሄ ማጫሳዮ ሄ ሃꬃ ኡሾ። ");
INSERT INTO gmve_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","ማጫሳያ ባና ቱኒሳዳ ባ ኣዚናስ ዲዛ ኣማኔቴꬃ ፓጪንቺዳ ጊዲኮ ቃንጌꬅ ኤሂዛ ሃꬃ ኢዛ ኡዪዛ ዎዴ ኢዚ ቦላ ጊዶን ዎልቃማ ሳኮ ኤሃና፤ ሄሲካ ኢዚ ኡሎይ ፑራና፤ ኢዚስ ዬላ ኡሎይ ጉንዳና፤ ኢዚ ሱንꬂ ኢዚ ዴሬዛ ጊዶን ቃንጌቲዳዝ ጊዲ ኣታና። ");
INSERT INTO gmve_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ጊዶ ኣቲን ኢዛ ኣይኮ ሞሮካ ኦꬆንታ ጊዲኮ ኢዚ ቦላ ኣይኮ ቆሆይካ ጋኬና፤ ኢዛ ናይታካ ዬላና። ");
INSERT INTO gmve_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","«ኢሳዴይ ባ ማቾ ላይማቴꬃን ሲꬊዛ ዎዴ ኦꬃና ዎጋይ ሃይሳፌ ካሊዛይሳ፤ ኢዛ ካሬ ካሬ ጋዳ ሃራ ኣዴራ ዚንኣዳ ቱኒዳ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ዎይኮ ኢሲ ኣሲ ባ ማቾ ጮ ሜላ ሲꬊዛ ጊዲኮ ኢዛ ጎዳ ሲንꬃን ኤቃና ማላ ኦꬆ። ");
INSERT INTO gmve_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","ኢዚ ኣዚናዚካ ቆሆፔ ጌሽ ጊዳና፤ ማጫሳያ ላይማታ ቤቲዳ ጊዲኮ ቃሴ ኢዛ ባ ቆሆዛ ጋሶን ባ ቦላ ጋኪዛ ፒርዳ ኤካና።» ");
INSERT INTO gmve_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«ኢስራኤሌ ኣሳስ፥ ‹ማጫ ጊዲን ዎይኮ ኣዴ ጊዲን ኣይ ኣሲካ ባና ጎዳስ ዱማሳናስ ኣዲና ኣዲኔቲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ሄሳዴይ ዎይኔ ኡሹ ዎይኮ ሃራ ማꬆሲዛ ኡሹ ኡዮፖ፤ ዎይኔፔ ዎይኮ ሃራፔ ኦሴቲዳ ጫላ ዎይኮ ማꬆሲዛ ኡሹ ኢዚ ኡዮፖ፤ ዎይኔ ሚꬃ ኣይፌፔ ቲያ ጊዲን ዎይኮ ሜላ ጊዲን ሞፖ። ");
INSERT INTO gmve_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","ኢዚ ባና ዱማሲዲ ዲዛ ዎዴን ዎይኔ ሚꬃ ሃጋ ቦላ ዲዛ ኣይፌ ጊዲን ዎይኮ ፖቆ ሞፖ። ");
INSERT INTO gmve_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","« ‹ኢዚ ናዚራዌቴꬃስ ኣዲኔቲዳ ዎዴይ ዉራና ጋካናስ ኢዛዴ ሁኤ ቢናና ማጋላይ ቦቾፎ፤ ኢዚ ባና ጎዳስ ዱማሲዳ ዎዴይ ፖሌታና ጋካናስ ኢዚ ዱማቲዳዴ ጊዲዲ ባ ሁኤ ቢናና ዲቾ። ");
INSERT INTO gmve_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","ኢዚ ናዚራዌ ጊዲ ዲዛ ዎዴ ኡባን ሃይቂዳ ኣሃኮ ሺቆፖ። ");
INSERT INTO gmve_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","ኢዚ ባ ጎዳስ ባና ዱማሲዳ ማላታይ ኢዛ ሁኤ ቦላ ዲዛ ጊሻስ ኢዛስ ኣዋይ ዎይኮ ኣያ ዎይኮ ኢዛስ ኢሻይ ዎይኮ ሚቻ ሃይቂኮ ኢስታ ኣሃ ቦቺዲ ኢዚ ባና ቱኒሶፖ። ");
INSERT INTO gmve_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","ኢዚ ባና ናዚራዌ ኦꬂዳ ዎዴ ኡባን ኢዚ ጎዳስ ዱማቲዳ ኣሳ። ");
INSERT INTO gmve_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","« ‹ኢዚ ቆፖንታ ዲሺን ኢሳዴይ ኢዛ ኣቻን ሃይቂዲ ካሴ ዱማቲ ዲዛ ኢዛ ሁኤ ቢናና ቱኒሲኮ ኢዚ ላፑንꬃ ጋላስ ባ ሁኤ ቢናና ሜዴቲ ቡሉሶ። ");
INSERT INTO gmve_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ኦስፑንꬃ ጋላስ ናምኡ ሃራጴታ ዎይኮ ሃራጴ ጪዬታ ጋይቶቴꬃ ዱንካኔዛ ፔንጌን ዲዛ ቄሴዛኮ ኤሆ። ");
INSERT INTO gmve_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","ቄሴዚካ ኢሲ ሃራጴዛ ናጋራ ያርሾስ ናምኣንꬆዛ ቃሴ ጹጌቲዛ ያርሾስ ሺሾ፤ ጋሶይካ ኢዚ ኣሃ ማታ ሺቂዲ ቱኒዳ ጊሻስ ቄሴዚ ኢዛ ናጋራ ዉርሳና፤ ሄ ጋላሲካ ናዚራዌይ ባ ሁኤ ኢስኬዛ ናምኣንꬆ ጎዳስ ዱማሶ። ");
INSERT INTO gmve_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","ኢዚ ናዚራዌቴꬃን ኦꬃናስ ባና ጎዳስ ናምኣንꬆ ዱማሶ፤ ጎዳስ ዱማቲዳ ሄ ኢዛ ኢስኬዚ ቱኒዳ ጊሻስ ሄሳፌ ካሴ ኢዚ ናዚራዌቴꬃን ጋምኢዳ ዎዴይ ኢዛስ ቆዳን ጌሌና፤ ኢዚ ባ ቆሆዛ ጊሻስ ኢሲ ላይꬃ ꬋርሾ ላቃ ኤሆ። ");
INSERT INTO gmve_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","« ‹ኢሲ ናዚራዌይ ባ ናዚራዌቴꬃ ኣዲና ኡባ ዎዴ ኢዚ ፖላና ዎጋይ ሃይሳፌ ካሊ ዲዛይሳ፤ ኢዚ ጌዴ ጋይቶቴꬃ ዱንካኔን ጌሊዛ ፔንጌዛኮ ቢዲ፥ ");
INSERT INTO gmve_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ሄን ባ ያርሾ ጎዳስ ሺሾ፤ ሄሲካ ጹጌቲዛ ያርሾስ ኢሲ ላይꬅ ኩሚዳ ꬋርሾ ላቃ፥ ናጋራ ያርሾስ ኢሲ ላይꬅ ኩሚዳ ኡዚ ዶርስ፥ ሄሳꬆካ ኢሲፌቴꬃ ያርሾስ ዎሶይ ባይንዳ ꬋርሾ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ቃሴ ካꬃ ያርሾኔ ኡሻ ያርሾ ኢስታራ ኢሲፌ ያርሻናስ ኤሆ፤ ሄ ሌማቴዛን ካꬃ ያርሾይ ኢርሾይ ኢዛን ጌሎንታይሳ ጊዶ፤ ቃሴ ሊቆ ꬊሌ ዛይቴን ሙኑቂ ኡኪዳ ኦርዴ ኡኬꬂኔ ዛይቴን ቲዬቲዳ ሌኤ ኡኬꬅ ኤሆ። ");
INSERT INTO gmve_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","« ‹ቄሴዚካ ሄሳ ኡባ ናጋራ ያርሾኔ ጹጌቲዛ ያርሾ ኦꬂዲ ጎዳ ሲንꬅ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ꬋርሾዛኔ ሌማቴራ ኢርሾይ ኢዛን ጌሎንታ ኡኬꬃታ ኢሲፌቴꬃ ያርሾ ኦꬂዲ ጎዳስ ሺሾ፤ ቃሴ ሄሳራ ኢሲፌ ጋꬂዲ ካꬃ ያርሾኔ ኡሻ ያርሾ ያርሾ። ");
INSERT INTO gmve_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","« ‹ሄሳፌ ጉዬ ጋይቶቴꬃ ዱንካኔዛን ጌሊዛ ፔንጌ ቦላ ሄ ናዚራዌዚ ጎዳስ ኣዲኔቲዳ ባ ሁኤ ቢናና ሜዴቲዲ ኢሲፌቴꬃ ያርሾይ ጹጌቲዛ ታማን ዬጎ። ");
INSERT INTO gmve_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","« ‹ባና ጎዳስ ዱማሲዳ ናዚራዌይ ባ ሁኤ ቢናና ሜዴቲዳፔ ጉዬ ቄሴዚ ዶይሴቲዳ ꬋርሾዛ ሚሳ ኣሾ፥ ኢርሾይ ጌሎንታ ኡኬቲዳ ኦርዴ ኡኬꬂኔ ሌኤ ኡኬꬅ ሌማቴፔ ኤኪዲ ሄ ናዚራዌዛ ኩሼን ዎꬆ። ");
INSERT INTO gmve_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ሄሳፌ ጉዬ ቄሴዚ ኡባ ኤኪዲ ጎዳ ሲንꬃን ያኔ ሃ ቃሴꬂዛ ያርሾ ሂስቲ ሺሾ፤ ሄይቲካ ጎዳስ ዱማቲዳ ያርሾ፤ ሄ ቃሴꬂዳ ኣንጋሶይኔ ሚሳዚ ቄሴዛስ ጊዶ፤ ሄሳፌ ጉዬ ናዚራዌዚ ዎይኔ ኡሹ ኡያናስ ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","« ‹ሄሳ ጊሻስ ጎዳስ ባና ዱማሳናስ ኣዲኒዳ ናዚራዌስ ዎꬊዳ ዎጋይ ባና ጎዳስ ያርሻናስ ኮሺዛ ያርሾታፔ ቦላራ ኣꬂ ጌፒኮ ኢዚ ቃላ ጌሊዳ ማላ ባ ኣዲና ፖላናስ ቤሴስ ጋ ዮታ› ጌስ።» ");
INSERT INTO gmve_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","ጎዳይ ሙሴስ ሂዝጊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«ኣሮኔይኔ ኢዛ ናይቲ ኢስራኤሌ ዴራ ኣንጂሼ ሂዝጊ ኣንጄቶ፥ ");
INSERT INTO gmve_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‹ጎዳይ ኔና ኣንጆ፤ ኢዚ ኔና ናጎ፤ ");
INSERT INTO gmve_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","ጎዳይ ባ ኣይፌሶ ፖኦ ኔስ ቆንጪሶ፤ ኢዚ ኔስ ቃꬌቶ። ");
INSERT INTO gmve_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","ጎዳይ ኔና ባ ማሮቴꬃ ኣይፌን ጼሎ፤ ባ ሳሮቴꬅካ ኢዚ ኔስ ኢሞ› ጋዳ ዮታ።» ");
INSERT INTO gmve_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","ቃሴካ ጎዳይ፥ «ኢስቲ ኢስራኤሌ ኣሳ ታ ሱንꬃን ኣንጂዛ ዎዴ ታኒ ኢስታ ኣንጃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","ሙሴይ ጋይቶቴꬃ ዱንካኔዛ ቶሊ ጊጊዳ ዎዴ ዱንካኔዛኔ ኢዛን ጎኤቲዛ ሚሻታ ኡባ፥ ያርሾ ያርሺዛሶዛኔ ኢዛን ጎኤቲዛ ሚሻታ ቲይዲ ዱማሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ሄሳፌ ጉዬ ኢስራኤሌ ኣሳ ካሌꬂዛይቲ፥ ዴራ ቆዲዛ ዎዴ ኢስታ ቦላ ኣላፌቴꬂ ዲዛ ኮራፒኔቲ ዉሪ ባ ያርሾ ያርሾ ጎዳስ ሺሺዳ። ");
INSERT INTO gmve_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ኢስቲ ሺሺዳ ያርሾቲ ናምኡ ናምኡ ሃላቃታ ሱንꬃን ኢሲ ፓራ-ጋሬ፥ ሄሳꬆካ ኢሲ ኢሲ ሃላቃ ሱንꬃን ኢሲ ኢሲ ቦራ፤ ሄ ኢስቲ ሺሺዳ ያርሾቲ ኢሲ ቦላ ኡሱፑን ፓራ-ጋሬታኔ ታማን ናምኡ ቦራታ፤ ሄይታ ሄ ያርሾታካ ጋይቶቴꬃ ዱንካኔዛ ሲንꬃን ሺሺዳ። ");
INSERT INTO gmve_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«ሃይቲ ሚሻቲ ጋይቶቴꬃ ዱንካኔዛን ዱማ ዱማ ኦሶስ ኢስታን ጎኤታና ማላ ሃይታ ያርሾ ሚሻታ ኢስታፌ ኤካዳ፥ ዱማ ዱማ ኦሶስ ኢስታስ ኮሺዛ ማላ ሻካዳ ሌዌታስ ኢማ።» ");
INSERT INTO gmve_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","ሄሳ ጊሻስ ሙሴይ ፓራ-ጋሬታኔ ቦራታ ኤኪዲ ሌዌታስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ጌርሾኔ ዛርኬታስ ኦሶስ ኮሺዛ ናምኡ ፓራ-ጋሬታኔ ኦይዱ ቦራታ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ቃሴካ ሜራሬ ዛርኬታስ ኦይዱ ፓራ-ጋሬታኔ ኦስፑን ቦራታ ኢሚዴስ፤ ሄይታንታ ኦሶይ ፖሌታናይ ኣሮኔ ና ኢታማሬ ኣላፌቴꬃና። ");
INSERT INTO gmve_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","ኢስታስ ዲዛ ኣላፌቴꬂ ጌሻ ሚሻታ ባ ሃሼን ቶኪዛ ጊሻስ ሙሴይ ቃኣቴ ዛርኬታስ ፓራ-ጋሬታ ጊዲን ዎይኮ ቦራታካ ኢሚቤና። ");
INSERT INTO gmve_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","ያርሾ ያርሺዛሶዛ ሙሴይ ቲይዲ ጌሺዳ ጋላስ ሃላቃቲ ያርሾ ያርሺዛሶዛ ኣንጂሳናስ ባንታ ኢሞታ ኤሂዲ ያርሾ ያርሺዛሶዛ ሲንꬃን ሺሺዳ። ");
INSERT INTO gmve_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ጎዳይ ሙሴስ፥ «ታማኔ ናምኡ ጋላሳታን ታማኔ ናምኡ ሃላቃቲ ፓጬይ ባይንዳ ኢሶይ ኢሶይ ኢሲ ኢሲ ጋላስ ኣንጂሶ ባኣሌስ ጊዲዛ ያርሾ ሁኤን ሁኤን ሺሻና ማላ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ኮይሮ ጋላስ ዩሁዳ ቆሞታ ጋርሳፌ ኣሚናዳቤ ና ኔኣሶኔይ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","ኢዚ ሺሺዳ ያርሾቲካ ሃይሳፌ ካሊዛይታ፤ ኤሬቲዳ ሜዛኔን ዎꬂን 130 ሳቂሌ ቢራፔ ኦሴቲዳ ኢሲ ፒጫ ሳኔኔ 70 ሳቂሌ ኢሲ ጉቃ ሳኔ፥ ናምኣይካ ካꬅ ያርሾ ሺሻናስ ሊቆ ꬊሌፌ ዛይቴን ሙኑቄቲዳ ሙኑቃን ኩሚዳ። ");
INSERT INTO gmve_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ኢዛን ኤጻኔይ ኩሚ ኡቲዳ 10 ሳቂሌ ዎርቃፌ ኦሴቲዳ ጪልፋ። ");
INSERT INTO gmve_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ጹጌቲዛ ያርሾስ ኢሲ ሚርጎ፥ ኢሲ ꬋርሾ፥ ኢሲ ላይꬃ ꬋርሾ ላቃ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ናጋራ ያርሾስ ኢሲ ዴይሻ ኦርጌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ኢሲፌቴꬃ ያርሾስ 2 ቦራታ፥ 5 ꬋርሾታ፥ 5 ዴይሻ ኦርጌታኔ ላይꬅ ኩሚዳ 5 ꬋርሾ ላቃታ፤ ሄይቲ ዉሪ ኣሚናዳቤ ና ኔኣሶኔይ ሺሺዳ ያርሾታ። ");
INSERT INTO gmve_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","ናምኣንꬆ ጋላስ ዪሳኮሬ ዛርኬታ ጋርሳፌ ጹኣሬ ና ናቲናኤሌይ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","ኢዚ ሺሺዳ ያርሾቲካ ሃይሳፌ ካሊዛይታ፥ ኤሬቲዳ ሜዛኔን ዎꬂን ጼታኔ ሄꬑ ታሙ ሳቂሌ ቢራፔ ኦሴቲዳ ኢሲ ፒጫ ሳኔኔ ላፑን ታሙ ሳቂሌ ጉቃ ሳኔ፥ ናምኣይካ ካꬃ ያርሾ ሺሻናስ ሊቆ ꬊሌፌ ዛይቴን ሙኑቄቲዳ ሙኑቃን ኩሚ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ኢዛን ኤጻኔይ ኩሚ ኡቲዳ ታሙ ሳቂሌ ዎርቃፌ ኦሴቲዳ ጪልፋ። ");
INSERT INTO gmve_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ጹጌቲዛ ያርሾስ ኢሲ ሚርጎ፤ ኢሲ ꬋርሾ፥ ኢሲ ላይꬃ ꬋርሾ ላቃ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ናጋራ ያርሾስ ኢሲ ዴይሻ ኦርጌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ኢሲፌቴꬃ ያርሾስ 2 ቦራታ፥ 5 ꬋርሾታ፥ 5 ዴይሻ ኦርጌታኔ ላይꬅ ኩሚዳ 5 ꬋርሾ ላቃታ፤ ሄይቲ ዉሪ ጹኣሬ ና ናቲናኤሌይ ሺሺዳ ያርሾታ። ");
INSERT INTO gmve_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","ሄꬓንꬆ ጋላስ ዛቢሎኔ ዛርኬታ ጋርሳፌ ሄሎኔ ና ኤልያቤይ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","ኢዚ ሺሺዳ ያርሾቲካ ሃይሳፌ ካሊዛይታ፥ ኤሬቲዳ ሜዛኔን ዎꬂን ጼታኔ ሄꬑ ታሙ ሳቂሌ ቢራፔ ኦሴቲዳ ኢሲ ፒጫ ሳኔኔ ላፑን ታሙ ሳቂሌ ጉቃ ሳኔ፥ ናምኣይካ ካꬃ ያርሾ ሺሻናስ ሊቆ ꬊሌፌ ዛይቴን ሙኑቄቲዳ ሙኑቃን ኩሚዳ። ");
INSERT INTO gmve_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ኢዛን ኤጻኔይ ኩሚ ኡቲዳ ታሙ ሳቂሌ ዎርቃፌ ኦሴቲዳ ጪልፋ። ");
INSERT INTO gmve_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ጹጌቲዛ ያርሾስ ኢሲ ሚርጎ፤ ኢሲ ꬋርሾ፥ ኢሲ ላይꬃ ꬋርሾ ላቃ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ናጋራ ያርሾስ ኢሲ ዴይሻ ኦርጌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ኢሲፌቴꬃ ያርሾስ 5 ቦራታ፥ 5 ꬋርሾታ፥ 5 ዴይሻ ኦርጌታኔ ላይꬅ ኩሚዳ 5 ꬋርሾ ላቃታ፤ ሄይቲ ዉሪ ሄሎኔ ና ኤልያቤይ ሺሺዳ ያርሾታ። ");
INSERT INTO gmve_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","ኦይዳንꬆ ጋላስ ኦሮቤሌ ቆሞታ ጋርሳፌ ሻዱሬ ና ኤልጹሬይ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","ኢዚ ሺሺዳ ያርሾቲካ ሃይሳፌ ካሊዛይታ፥ ኤሬቲዳ ሜዛኔን ዎꬂን 130 ሳቂሌ ቢራፔ ኦሴቲዳ ኢሲ ፒጫ ሳኔኔ 70 ሳቂሌ ኢሲ ጉቃ ሳኔ፥ ናምኣንካ ካꬃ ያርሾ ሺሻናስ ሊቆ ꬊሌፌ ዛይቴን ሙኑቄቲዳ ሙኑቃይ ኩሚ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ኢዛን ኤጻኔይ ኩሚ ኡቲዳ ኢሲ ታሙ ሳቂሌ ዎርቃፌ ኦሴቲዳ ጪልፋታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ጹጌቲዛ ያርሾስ ኢሲ ሚርጎ፥ ኢሲ ꬋርሾ፥ ኢሲ ላይꬃ ꬋርሾ ላቃ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ናጋራ ያርሾስ ኢሲ ዴይሻ ኦርጌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ኢሲፌቴꬃ ያርሾስ 2 ቦራታ፥ 5 ꬋርሾታ፥ 5 ዴይሻ ኦርጌታኔ ላይꬅ ኩሚዳ 5 ꬋርሾ ላቃታ፤ ሄይቲ ዉሪ ሻዱሬ ና ኤልጹሬይ ሺሺዳ ያርሾታ። ");
INSERT INTO gmve_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","ኢቻሻንꬆ ጋላስ ሲሞና ቆሞታ ጋርሳፌ ጹርሻዳዬ ና ሳሉምኤሌይ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","ኢዚ ሺሺዳ ያርሾቲካ ሃይሳፌ ካሊዛይታ፥ ኤሬቲዳ ሜዛኔን ዎꬂን 130 ሳቂሌ ቢራፔ ኦሴቲዳ ኢሲ ፒጫ ሳኔኔ 70 ሳቂሌ ኢሲ ጉቃ ሳኔ፥ ናምኣይካ ካꬃ ያርሾ ሺሻናስ ሊቆ ꬊሌፌ ዛይቴን ሙኑቄቲዳ ሙኑቃን ኩሚዳ። ");
INSERT INTO gmve_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ኢዛን ኤጻኔይ ኩሚ ኡቲዳ ኢሲ ታሙ ሳቂሌ ዎርቃፌ ኦሴቲዳ ጪልፋታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ጹጌቲዛ ያርሾስ ኢሲ ሚርጎ፥ ኢሲ ꬋርሾ፥ ኢሲ ላይꬃ ꬋርሾ ላቃ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ናጋራ ያርሾስ ኢሲ ዴይሻ ኦርጌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ኢሲፌቴꬃ ያርሾስ 2 ቦራታ፥ 5 ꬋርሾታ፥ 5 ዴይሻ ኦርጌታኔ ላይꬅ ኩሚዳ ኢቻሹ ꬋርሾ ላቃታ፤ ሄይቲ ዉሪ ጹርሻዳዬ ና ሳሉምኤሌይ ሺሺዳ ያርሾታ። ");
INSERT INTO gmve_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ኡሱፑንꬆ ጋላስ ጋዴ ዛርኬታ ጋርሳፌ ዳኡኤሌ ና ኤልያሳፌይ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","ኢዚ ሺሺዳ ያርሾቲካ ሃይሳፌ ካሊዛይታ፥ ኤሬቲዳ ሜዛኔን ዎꬂን 130 ሳቂሌ ቢራፔ ኦሴቲዳ ኢሲ ፒጫ ሳኔኔ 70 ሳቂሌ ኢሲ ጉቃ ሳኔ፥ ናምኣይካ ካꬃ ያርሾ ሺሻናዉ ሊቆ ꬊሌፌ ዛይቴን ሙኑቄቲዳ ሙኑቃን ኩሚዳ። ");
INSERT INTO gmve_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ኢዛን ኤጻኔይ ኩሚ ኡቲዳ ኢሲ ታሙ ሳቂሌ ዎርቃፌ ኦሴቲዳ ጪልፋታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ጹጌቲዛ ያርሾስ ኢሲ ሚርጎ፥ ኢሲ ꬋርሾ፥ ኢሲ ላይꬃ ꬋርሾ ላቃ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ናጋራ ያርሾስ ኢሲ ዴይሻ ኦርጌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ኢሲፌቴꬃ ያርሾስ 2 ቦራታ፥ 5 ꬋርሾታ፥ 5 ዴይሻ ኦርጌታኔ ላይꬅ ኩሚዳ 5 ꬋርሾ ላቃታ፤ ሄይቲ ዉሪ ዳኡኤሌ ና ኤልያሳፌይ ሺሺዳ ያርሾታ። ");
INSERT INTO gmve_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ላፑንꬆ ጋላስ ኤፍሬሜ ዛርኬታ ጋርሳፌ ኣሚሁዴ ና ኤልሻማይ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","ኢዚ ሺሺዳ ያርሾቲካ ሃይሳፌ ካሊዛይታ፥ ኤሬቲዳ ሜዛኔን ዎꬂን 130 ሳቂሌ ቢራፔ ኦሴቲዳ ኢሲ ፒጫ ሳኔኔ 70 ሳቂሌ ኢሲ ጉቃ ሳኔ፥ ናምኣይካ ካꬃ ያርሾ ሺሻናስ ሊቆ ꬊሌፌ ዛይቴን ሙኑቄቲዳ ሙኑቃን ኩሚዳ። ");
INSERT INTO gmve_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ኢዛን ኤጻኔይ ኩሚ ኡቲዳ ኢሲ ታሙ ሳቂሌ ዎርቃፌ ኦሴቲዳ ጪልፋታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ጹጌቲዛ ያርሾስ ኢሲ ሚርጎ፥ ኢሲ ꬋርሾ፥ ኢሲ ላይꬃ ꬋርሾ ላቃ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ናጋራ ያርሾስ ኢሲ ዴይሻ ኦርጌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ኢሲፌቴꬃ ያርሾስ 2 ቦራታ፥ 5 ꬋርሾታ፥ 5 ዴይሻ ኦርጌታኔ ላይꬅ ኩሚዳ 5 ꬋርሾ ላቃታ፤ ሄይቲ ዉሪ ኣሚሁዴ ና ኤልሻማ ያርሾታ። ");
INSERT INTO gmve_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","ኦስፑንꬃ ጋላስ ሚናሴ ዛርኬታ ጋርሳፌ ፔዳጹሬ ና ጋማልኤሌይ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","ኢዚ ሺሺዳ ያርሾቲካ ሃይሳፌ ካሊዛይታ፥ ኤሬቲዳ ሜዛኔን ዎꬂን 130 ሳቂሌ ቢራፔ ኦሴቲዳ ኢሲ ፒጫ ሳኔኔ 70 ሳቂሌ ኢሲ ጉቃ ሳኔ፥ ናምኣይካ ካꬃ ያርሾ ሺሻናስ ሊቆ ꬊሌፌ ዛይቴን ሙኑቄቲዳ ሙኑቃን ኩሚዳ። ");
INSERT INTO gmve_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ኢዛን ኤጻኔይ ኩሚ ኡቲዳ ኢሲ ታሙ ሳቂሌ ዎርቃፌ ኦሴቲዳ ጪልፋታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ጹጌቲዛ ያርሾስ ኢሲ ሚርጎ፥ ኢሲ ꬋርሾ፥ ኢሲ ላይꬃ ꬋርሾ ላቃ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ናጋራ ያርሾስ ኢሲ ዴይሻ ኦርጌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ኢሲፌቴꬃ ያርሾስ 2 ቦራታ፥ 5 ꬋርሾታ፥ 5 ዴይሻ ኦርጌታኔ ላይꬅ ኩሚዳ 5 ꬋርሾ ላቃታ፤ ሄይቲ ዉሪ ፔዳጹሬ ና ጋማልኤሌ ያርሾታ። ");
INSERT INTO gmve_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","ኡዱፉንꬆ ጋላስ ቢኒያሜ ዛርኬታ ጋርሳፌ ጊዲኦኔ ና ኣቢዳኔይ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","ኢዚ ሺሺዳ ያርሾቲካ ሃይሳፌ ካሊዛይታ፥ ኤሬቲዳ ሜዛኔን ዎꬂን 130 ሳቂሌ ቢራፔ ኦሴቲዳ ኢሲ ፒጫ ሳኔኔ 70 ሳቂሌ ኢሲ ጉቃ ሳኔ፥ ናምኣይካ ካꬃ ያርሾ ሺሻናስ ሊቆ ꬊሌፌ ዛይቴን ሙኑቄቲዳ ሙኑቃን ኩሚዳ። ");
INSERT INTO gmve_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ኢዛን ኤጻኔይ ኩሚ ኡቲዳ ኢሲ ታሙ ሳቂሌ ዎርቃፌ ኦሴቲዳ ጪልፋታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ጹጌቲዛ ያርሾስ ኢሲ ሚርጎ፥ ኢሲ ꬋርሾ፥ ኢሲ ላይꬃ ꬋርሾ ላቃ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ናጋራ ያርሾስ ኢሲ ዴይሻ ኦርጌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ኢሲፌቴꬃ ያርሾስ 2 ቦራታ፥ 5 ꬋርሾታ፥ 5 ዴይሻ ኦርጌታኔ ላይꬅ ኩሚዳ 5 ꬋርሾ ላቃታ፤ ሄይቲ ዉሪ ጊዲኦኔ ና ኣቢዳኔ ያርሾታ። ");
INSERT INTO gmve_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","ታማንꬆ ጋላስ ዳኔ ቆሞታ ጋርሳፌ ኣሚሻዳዬ ና ኣሂኤዜሬይ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","ኢዚ ሺሺዳ ያርሾቲካ ሃይሳፌ ካሊዛይታ፥ ኤሬቲዳ ሜዛኔን ዎꬂን 130 ሳቂሌ ቢራፔ ኦሴቲዳ ኢሲ ፒጫ ሳኔኔ 70 ሳቂሌ ኢሲ ጉቃ ሳኔ፥ ናምኣይካ ካꬃ ያርሾ ሺሻናስ ሊቆ ꬊሌፌ ዛይቴን ሙኑቄቲዳ ሙኑቃን ኩሚዳ። ");
INSERT INTO gmve_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ኢዛን ኤጻኔይ ኩሚ ኡቲዳ ኢሲ ታሙ ሳቂሌ ዎርቃፌ ኦሴቲዳ ጪልፋታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ጹጌቲዛ ያርሾስ ኢሲ ሚርጎ፥ ኢሲ ꬋርሾ፥ ኢሲ ላይꬃ ꬋርሾ ላቃ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ናጋራ ያርሾስ ኢሲ ዴይሻ ኦርጌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ኢሲፌቴꬃ ያርሾስ 2 ቦራታ፥ 5 ꬋርሾታ፥ 5 ዴይሻ ኦርጌታኔ ላይꬅ ኩሚዳ 5 ꬋርሾ ላቃታ፤ ሄይቲ ዉሪ ኣሚሻዳዬ ና ኣሂኤዜሬ ያርሾታ። ");
INSERT INTO gmve_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","ታማኔ ኢሲንꬃ ጋላስ ኣሴሬ ቆሞታ ጋርሳፌ ኦክራ ና ፋጉኤሌይ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","ኢዚ ሺሺዳ ያርሾቲካ ሃይሳፌ ካሊዛይታ፥ ኤሬቲዳ ሜዛኔን ዎꬂን 130 ሳቂሌ ቢራፔ ኦሴቲዳ ኢሲ ፒጫ ሳኔኔ 70 ሳቂሌ ኢሲ ጉቃ ሳኔ፥ ናምኣይካ ካꬃ ያርሾ ሺሻናስ ሊቆ ꬊሌፌ ዛይቴን ሙኑቄቲዳ ሙኑቃን ኩሚዳ። ");
INSERT INTO gmve_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ኢዛን ኤጻኔይ ኩሚ ኡቲዳ ኢሲ ታሙ ሳቂሌ ዎርቃፌ ኦሴቲዳ ጪልፋታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ጹጌቲዛ ያርሾስ ኢሲ ሚርጎ፥ ኢሲ ꬋርሾ፥ ኢሲ ላይꬃ ꬋርሾ ላቃ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ናጋራ ያርሾስ ኢሲ ዴይሻ ኦርጌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ኢሲፌቴꬃ ያርሾስ 2 ቦራታ፥ 5 ꬋርሾታ፥ 5 ዴይሻ ኦርጌታኔ ላይꬅ ኩሚዳ 5 ꬋርሾ ላቃታ፤ ሄይቲ ዉሪ ኦክራ ና ፋጉኤሌ ያርሾታ። ");
INSERT INTO gmve_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","ታማኔ ናምኣንꬃ ጋላስ ኒፍታሌሜ ዛርኬታ ጋርሳፌ ኤናኔ ና ኣሂሬይ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","ኢዚ ሺሺዳ ያርሾቲካ ሃይሳፌ ካሊዛይታ፥ ኤሬቲዳ ሜዛኔን ዎꬂን 130 ሳቂሌ ቢራፔ ኦሴቲዳ ኢሲ ፒጫ ሳኔኔ 70 ሳቂሌ ኢሲ ጉቃ ሳኔ፥ ናምኣይካ ካꬃ ያርሾ ሺሻናስ ሊቆ ꬊሌፌ ዛይቴን ሙኑቄቲዳ ሙኑቃን ኩሚዳ። ");
INSERT INTO gmve_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ኢዛን ኤጻኔይ ኩሚ ኡቲዳ ኢሲ ታሙ ሳቂሌ ዎርቃፌ ኦሴቲዳ ጪልፋታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ጹጌቲዛ ያርሾስ ኢሲ ሚርጎ፥ ኢሲ ꬋርሾ፥ ኢሲ ላይꬃ ꬋርሾ ላቃ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ናጋራ ያርሾስ ኢሲ ዴይሻ ኦርጌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ኢሲፌቴꬃ ያርሾስ 2 ቦራታ፥ 5 ꬋርሾታ፥ 5 ዴይሻ ኦርጌታኔ ላይꬅ ኩሚዳ 5 ꬋርሾ ላቃታ፤ ሄይቲ ዉሪ ኤናኔ ና ኣሂሬ ያርሾታ። ");
INSERT INTO gmve_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ያርሾ ያርሺዛሶዛ ቲይዲ ጌሺዳ ጋላስ ሃላቃቲ ያርሾሶዛ ኣንጂሶ ጋሶን ሺሺዳ ኢሞታይ ሃይታንታ፤ ቢራፔ ኦሴቲዳ 12 ፒጫ ሳኔታ፥ ቢራፔ ኦሴቲዳ 12 ጉቃ ሳኔታኔ ዎርቃፌ ኦሴቲዳ ኢስታን ኤጻኔ ዎꬂዛ 12 ኬሬታ። ");
INSERT INTO gmve_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ቢራፔ ኦሴቲዳ ኢሲ ኢሲ ኬሬይ 130 ሳቂሌ ጊዲ ዴጼስ፤ ቢራፔ ኦሴቲዳ ኢሲ ኢሲ ቁሌ ማላ ሳኔይ 7 ሳቂሌ ጊዲ ዴጼስ፤ ቢራፔ ኦሴቲዳ ኬሬቲኔ ቁሌ ማላ ሳኔቲ ጾሳ ኬꬃ ሜዛኔን ዎꬂዛ ዎዴ ኡባይ ኢሲ ቦላ 2,400 ሳቂሌ ጊዲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ዎርቃፌ ኦሴቲዳ ኤጻኔይ ኢስታ ኩሚ ኡቲዳ ታማኔ ናምኡ ሻቴቲ ጎዳ ኬꬃ ሜዛኔን ዎꬂዛ ዎዴ ኢሶይ ኢሶይ 10 ሳቂሌ ጊዲሺን ኡባይ ኢሲ ቦላ 120 ሳቂሌ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","ካꬃ ያርሾራ ኢሲፌ ጹጌቲዛ ያርሾስ ሺቂዳ ሜሄ ቆዳይ 12 ቦራታ፥ 12 ꬋርሾታኔ ላይꬅ ኩሚዳ 12 ꬋርሾ ላቃታ፤ ቃሴ ኢስቲ ናጋራ ያርሾስ ሺሺዳይ 12 ዴይሻ ኦርጌታ። ");
INSERT INTO gmve_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ኢሲፌቴꬃ ያርሾስ ሺቂዳ ሜሄ ቆዳይ 24 ቦራ፥ 60 ꬋርሾ፥ 60 ዴይሻ ኦርጌኔ ላይꬅ ኩሚዳ 60 ꬋርሾ ላቃ፤ ያርሾ ያርሺዛሶዚ ቲዬቲ ጌዪዳፔ ጉዬ ኣንጂሶ ባኣሌስ ኢሜቲዳ ኢሞታቲ ሃይታንታ። ");
INSERT INTO gmve_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","ሙሴይ ጎዳራ ሃሳያናስ ጌዴ ጋይቶቴꬃ ዱንካኔዛን ጌሊን ኣቶቴꬅ ዴማናስ ሺቂዛሶን ታቦታ ካማ ቦላ ዲዛ ናምኡ ኪሩቤታ ጊዶራ ጎዳይ ኢዛስ ሃሳይዛ ቃላ ሲዪዲ ኢዚካ ኢዛራ ሃሳዬቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","« ‹ኔኒ ኣሮኔስ ላፑን ጾምፔታ ኢስታ ቦላ ዎꬂዛ ዎዴ ጾምፔቲ ጾምፔ ኢስታ ቦላ ዎꬂዛ ባላታስ ሲንꬃ ባጋራ ዲዛሶ ፖኢሳና› ጋዳ ዮታ።» ");
INSERT INTO gmve_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","ኣሮኔይካ ጎዳይ ሙሴ ኣዛዚዳ ማላ ኦꬂዴስ፤ ጾምፔታ ኢስታ ቦላ ዎꬂዛ ባላታፔ ሲንꬃ ባጋራ ዲዛሶዛ ፖኢሳና ማላ ጊግሲ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","ጾምፔታ ኢስታ ቦላ ዎꬂዛ ባላቲ ጋርሳ ቶሆሶፔ ዶሚዲ ጪሼ ሚሳቲዛ ባላታ ጼራ ጋካናስ ቆጼቲዳ ዎርቃፌ ኦሴቲዳ፤ ሄይቲካ ጎዳይ ሙሴ ቤሲዳ ማላ ጾምፔ ኢስታ ቦላ ዎꬂዛ ባላታ ሌሚሶን ኦሴቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«ሃንኮ ኣቲዳ ኢስራኤሌ ዴራ ጋርሳፌ ሌዌ ቆሞታ ዱማ ሻካዳ ጌሻ። ");
INSERT INTO gmve_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","ጌሾ ዎጋስ ጊጌቲዳ ሃꬃን ኢስታ ኣራጫ፤ ኢስቲ ባንታ ቦላ ዲዛ ኢስኬ ኡባ ሜዴታናሲኔ ባ ማይኦካ ሜጪዲ ባና ጌሻና ማላ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ሄሳፌ ካሊዲ ኢሲ ሚርጎኔ ካꬃ ያርሾስ ጊዲዛ ሊቆ ꬊሌፌ ዛይቴን ሙኑቄቲዳ ሙኑቃ ኤኪ ቤቶ፤ ኔካ ናጋራ ያርሾስ ሺቂዛ ኢሲ ሚርጎ ኤካ ባ። ");
INSERT INTO gmve_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ሄሳፌ ጉዬ ኔ ኢስራኤሌ ኣሳ ሺሻዳ ሌዌቲ ጋይቶቴꬃ ዱንካናስ ሲንꬃ ባጋራ ጎዳ ሲንꬃን ኤሳ። ");
INSERT INTO gmve_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","ኢስራኤሌ ኣሳይካ ሌዌታ ሁኤ ቦላ ባ ኩሼ ዎꬆ። ");
INSERT INTO gmve_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ኣሮኔይ ሌዌታ ጎዳ ኦሶ ኦꬃናስ ጊጌቲዳይታ ጊዳና ማላ ኢስራኤሌ ኣሳ ጋርሳፌ ያኔ ሃ ቃሴꬂ ሺሺዛ ያርሾ ኦꬂዲ ኢስታ ጎዳ ሲንꬅ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","«ሄሳፌ ጉዬ ሌዌቲ ባ ኩሼታ ሄ ናምኡ ሚርጎታ ሁኤ ቦላ ዎꬄቶ፤ ኢሳ ናጋራ ዉርሶ ያርሾስ፥ ኢሳ ጹጌቲዛ ያርሾስ ኦꬃዳ ኢስታ ማሪሳናስ ጎዳ ሲንꬃን ያርሻ። ");
INSERT INTO gmve_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","ሌዌታ ያኔ ሃ ቃሴꬂ ሺሺዛ ያርሾ ሂስታዳ ጎዳ ሲንꬅ ሺሻ፤ ኣሮኔኔ ኢዛ ናይታካ ኢስታ ቦላ ሹማ። ");
INSERT INTO gmve_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ሄሳ ማላን ሌዌቲ ታይታ ጊዳና ማላ ሃንኮ ኣቲዳ ኢስራኤሌ ኣሳ ጊዶፌ ኔ ታስ ኢስታ ሻካ። ");
INSERT INTO gmve_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","«ኔኒ ሌዌታ ሻካ ጌሺዳፔኔ ያኔ ሃ ቃሴꬂ ሺሺዛ ያርሾ ሂስቲዳፔ ጉዬ ኢስቲ ጋይቶቴꬃ ዱንካኔዛ ጊዶን ኦꬃና ቤሲዛ ኦሶዛ ፖላናስ ዬቶ። ");
INSERT INTO gmve_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ታኒ ኢስታ ኮይሮ ባይራ ዬሌቲዛ ኢስራኤሌ ኣሳ ኣቱማ ናይታ ኡባ ጊሻስ ታስ ዶራዲስ፤ ኢስራኤሌ ኣሳ ጊዶፌ ኢስቲ ታስ ሙሌራ ቡዞ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","ጊብጼ ቢታን ባይራ ዬሌቲዳ ኣሳፔ ሜሄ ጋካናስ ዲዛይታ ታኒ ዎꬊዳ ዎዴ ኢስራኤሌ ኣሳ ኢሳ ኢሳ ኬꬃን ኣዴ ጊዲዲ ባይራ ዬሌቲዳ ኣሳፔ ሜሄ ጋካናስ ዲዛይታ ኡባ ታስ ዱማሳ ሻካዲስ። ");
INSERT INTO gmve_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","ሃኢ ቃሴ ኢስራኤሌ ኣሳ ባይራ ኣቱማ ናይታ ጊሻስ ሌዌ ዛርኬታ ታስ ሻካዲስ። ");
INSERT INTO gmve_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ኢስቲ ኢስራኤሌ ኣሳ ጊሻስ ጊዲዲ ጋይቶቴꬃ ዱንካኔዛ ጊዶን ታስ ኦꬃና ማላኔ ኢስራኤሌ ኣሳይ ጌዴ ጌሻሶዛኮ ሺቂዲ ቦሻን ቦሼቶንታ ማላ ኢስታ ናጋና ማላ ሌዌታ ኢስራኤሌ ኣሳ ጋርሳፌ ታስ ኢሞታ ማላ ኤካዳ ኣሮኔሲኔ ኢዛ ናይታስ ኢማዲስ።» ");
INSERT INTO gmve_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","ሄሳ ጊሻስ ጎዳይ ሙሴ ኣዛዚዳ ማላ ሙሴይ፥ ኣሮኔይኔ ኢስራኤሌ ኣሳይ ኡባይ ሌዌታ ዱማሲ ሻኪዳ። ");
INSERT INTO gmve_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ሌዌቲ ሜጬቲ ጌዪዳ፤ ባ ማይኦካ ሜጪዳ፤ ኣሮኔይ ኢስታ ያኔ ሃ ቃሴꬂ ሺሺዛ ያርሾ ሂስቲ ጎዳ ሲንꬅ ሺሺዴስ፤ ጌሾ ዎጋካ ኢስታ ጊሻስ ፖሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ጎዳይ ሙሴስ ሌዌታ ጊሻስ ኢሚዳ ኣዛዞዛ ማላ ዴሬዚ ዉሪካ ኦꬂዴስ፤ ሄሳ ማላን ሌዌቲ ኣሮኔኔ ኢዛ ናይታ ኣላፌቴꬃ ጋርሳን ጋይቶቴꬃ ዱንካኔዛ ጊዶን ኦꬃናስ ጊጌቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","25","«ሌዌቲ ኦሶ ዶማናስ ቤሲዛ ዎጋቲ ዬሌቲን ናምኡ ታማኔ ኢቻሹ ላይꬃፌ ቢዲ ኢቻሹ ታሙ ላይꬅ ጋካናስ ዲዛይቲ ዉሪ ጋይቶቴꬃ ዱንካኔዛ ጊዶን ኦꬄቶ፤ ኢቻሽ ታሙ ላይꬅ ኩሚሺን ኦꬆፌቶ። ");
INSERT INTO gmve_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","ሄሳፌ ጉዬ ኢስታ ኢሻቲ ጋይቶቴꬃ ዱንካኔዛ ጊዶን ኦꬂዛ ዎዴ ማዳናስ ዳንዳዬቴስ ኣቲን ባርካ ጻላ ዲኮ ኣይ ኦሶካ ኦꬆፌቶ።» ");
INSERT INTO gmve_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","ኢስራኤሌ ኣሳይ ጊብጼፔ ኬዚዳ ናምኣንꬆ ላይꬃን ኮይሮ ኣጊናን ጎዳይ ሙሴስ ሲና ባዞን ሂዝጊ ዮቲዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«ኢስራኤሌ ኣሳይ ፓዚጋ ባኣሌዛ ኢዚ ቦንቼቲዛ ዎዴን ቦንቾ፤ ");
INSERT INTO gmve_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","ሃይሳ ሃ ኣጊናዛን ታማኔ ኦይዳንꬆ ጋላሳ ኦማርስ ዎጋ ማላኔ ዲዛ ማራ ማላ ቦንቾ።» ");
INSERT INTO gmve_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","ሄሳ ጊሻስ ሙሴይ ፓዚጋ ባኣሌዛ ኣሳይ ቦንቻና ማላ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ኢስቲካ ኮይሮ ኣጊናይ ጌሊዳ ታማኔ ኦይዳንꬆ ጋላስ ጋዴይ ቃሚሺን ሲና ባዞን ፓዚጋ ባኣሌዛ ቦንቺዳ፤ ኢስራኤሌ ኣሳይ ጎዳይ ሙሴ ኣዛዚዳ ማላ ኡባ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","ጊዶ ኣቲን ኢስታ ጋርሳፌ ሃይቂዳ ኣሃ ቦቺዳ ጊሻስ ቱኒዳ ኣሳቲ ኢስታ ጊዶን ዲዛ ጊሻስ ሄ ጋላስ ፓዚጋ ባኣሌዛ ቦንቻናስ ዳንዳይቤቴና፤ ሄሳ ጊሻስ ኢስቲ ሙሴኮኔ ኣሮኔኮ ሺቂዲ፥ ");
INSERT INTO gmve_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ሙሴስ፥ «ኑኒ ኣሃ ቦቺዲ ቱኒዶስ ሺን ሃንኮ ኢስራኤሌ ኣሳፔ ዱማሶን ኑኒ ኢዛ ዎዴን ጎዳስ ያርሾ ሺሾንታ ማላ ኣዛስ ዲጌቲዞኒ?» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","ሙሴይካ ኢስታስ፥ «ታኒ ጎዳፔ ኢዚ ኢንቴ ጊሻስ ኣዛዚዛይሳ ሲያና ጋካናስ ናጊሺቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«ኔኒ ኢስራኤሌ ኣሳስ፥ ‹ኢንቴፌ ጊዲን ዎይኮ ኢንቴ ዜሬꬃፌ ኣሳይ ኣሃ ቦቺዲ ቱኒኮ ዎይኮ ኦጌ ቢዳ ጊዲኮ ኢዛዴይ ጎዳ ፓዚጋ ባኣሌ ቦንቻናስ ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ሄሲካ ናምኣንꬆ ኣጊናይ ጌሊዳ ታማኔ ኦይዳንꬆ ጋላስ ጋዴይ ቃሚሺን ቦንቻናስ ዳንዳዬስ፤ ኢስቲ ቦንቺሼ ፓዚጋ ዶርሳ ኢርሾይ ጌሎንታ ኡኬꬅ ጫሞ ሚꬃ ሃይꬃራ ሜቶ። ");
INSERT INTO gmve_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ጋዴይ ዎንታና ጋካናስ ሄ ካꬃፌ ኣይኮካ ኣሾፌቶ፤ ሹኬቲዳ ሜሄዛ ሜቄꬃፌ ኢሲኔዮካ ሜንꬆፌቶ፤ ኢስታስ ኢሜቲዳ ዎጋ ማላ ባኣሌዛ ቦንቼቶ። ");
INSERT INTO gmve_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","ጌሽ ጊዲዲኔ ኦጌ ቦንታ ኣሲ ኦኒካ ፓዚጋ ባኣሌዛ ቦንቺዛ ጋላስ ቦቾንታዴይ ታ ዴራፔ ሻኬቶ፤ ኢዚ ያርሾዛ ቤሲዛ ዎዴን ያርሾንታ ኣጊዳ ጊሻስ ባ ናጋራስ ቤሲዛ ቂጻቴ ኤኮ። ");
INSERT INTO gmve_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","« ‹ኢንቴ ጊዶን ቤቲ ዪዳ ሃራ ዴሬ ኣሲ ጎዳ ፓዚጋ ባኣሌዛ ቦንቻና ኮይኮ ዲዛ ዎጋ ማላ ኡባ ፖሊ ቦንቻናስ ቤሴስ፤ ዴሬን ዬሌቲዳይሳ ጊዲን ኣሳ ቢታ ኣስ ጊዲን ሃይሳ ዎጋዛ ኢሲ ማላ ፖሎ› ጋዳ ዮታ።» ");
INSERT INTO gmve_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ጋይቶቴꬃ ዱንካኔዚ ቶኬቲዳ ጋላስ ሻራዚ ዱንካኔዛ ጎዚ ኦይኪዴስ፤ ኦማርሳፌ ቢዲ ጋዴይ ዎንታና ጋካናስ ዱንካኔዛ ቦላ ታማ ሚሳቲዛ ሻራይ ካሚ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","ጋላስ ጋላስ ሻራይ ካሚ ኦይኬስ፤ ሄ ሻራዚካ ኦማርስ ኦማርስ ታማ ማላ ፖኤስ። ");
INSERT INTO gmve_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","ሻራዚ ዱንካኔዛ ቦላፌ ዴንዲዛ ዎዴ ኡባን ኢስራኤሌ ኣሳይ ባ ዱንካኒ ዲዛሶፔ ዴንዲ ቤስ፤ ሻራዚ ኤቂዛ ዎዴ ኣሳይካ ባ ዲዛሶን ዱንካኒ ኡቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","ኢስራኤሌ ኣሳይ ባ ዲዛሶፔ ዴንዲ ቢዛ ዎዴ ጊዲን ኢስቲ ሃራሶን ዱንካኒ ኡቲዛ ዎዴ ጎዳይ ኢስታ ኣዛዚዳ ማላ ሃኔቴስ፤ ሻራዚ ዱንካኔዛ ቦላ ዎꬊዲ ካሚ ኦይኪዳ ዎዴ ኡባን ኢስቲ ባንቲ ዱንካኒ ኡቲዳሶሆን ጋምኤቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","ሻራዚ ዱንካኔዛ ቦላ ዳሮ ጋላስ ጋምኢኮካ ኢስቲ ጎዳስ ኣዛዜቴꬃን ሄን ባ ዱንካኒ ዲዛሶን ጋምኤቴስ ኣቲን ኣዋካ ቃጼቴና። ");
INSERT INTO gmve_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","ኢሲ ኢሲ ዎዴ ሻራዚ ዱንካኔዛ ቦላ ጉꬃ ጋላሳታ ጻላ ጋምኤስ፤ ጊዲኮካ ሄን ጋዳን ኢስቲ ጋምኢኮ ዎይኮ ጌዴ ሲንꬄ ቢኮ ጎዳይ ኢስታ ኣዛዚዳ ማላ ሃኔቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","ሻራዚ ኢሲ ኢሲ ዎዴ ጋዴይ ዎንታና ጋካናስ ጻላ ጋምኤስ፤ ጋዴይ ዎንቲሺን ሻራዚ ዴንዲዳ ማላ ሄራካ ሄሜꬅ ዶሜቴስ፤ ዎይኮ ሻራዚ ጋላስ ጊዲን ኦማርስ ዴንዲዛ ዎዴ ኢስቲካ ዴንዲ ቤቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","ናምኡ ጋላስ ጊዲን ዎይኮ ኢሲ ኣጊና ጊዲን ዎይኮ ኢሲ ላይꬂካ ጊዲን ሄሳፌካ ኣዱሳ ዎዴ ሻራዚ ዱንካኔዛ ቦላ ካሚ ኡቲዳ ዎዴ ኡባን ኢስቲካ ባንቲ ዱንካኒ ዲዛሶፔ ቃጼቴና፤ ጊዶ ኣቲን ሻራዚ ዴንዲ ቢዛ ዎዴ ኢስቲካ ዴንዲ ሄሜꬅ ዶሜቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","ኢስቲ ዱንካኒ ኡቲዛይ ዎይኮ ባ ዲዛሶፔ ዴንዲ ቢዛይ ጎዳይ ሙሴስ ኢሚዳ ኣዛዞዛ ማላ። ");
INSERT INTO gmve_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«ዴሬዛ ኢሲ ቦላ ሺሻናስ ጊዲን ዎይኮ ኣሳይ ዱንካኒ ዲዛሶፔ ዴንꬄꬃናስ ፑኒዛ ናምኡ ዛዬታ ቢራፔ ቆጻ ኬሳ። ");
INSERT INTO gmve_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","ናምኡ ዛዬቲ ፑኔቲዛ ዎዴ ኩሜꬃ ማባራይ ጋይቶቴꬃ ዱንካኔዛ ፔንጌን ኔ ዲዛሶ ሺቆ። ");
INSERT INTO gmve_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ኢሲ ዛዬይ ዛዬቲዛ ዎዴ ጊዲኮ ኢስራኤሌ ኣሳፔ ኮራፒኔቲ ጻላ ኔኮ ሺቄቶ። ");
INSERT INTO gmve_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","ዛዬዛ ꬎቁ ሂስቲ ዛይኮ ኣርሼይ ሞኪዛ ባጋራ ዱንካኒ ኡቲዳ ኣሳይ ኮይሮ ሄሜꬅ ዶሞ። ");
INSERT INTO gmve_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ኔ ዛዬዛ ናምኣንꬆ ꬎቁ ሂስታ ፑኒዛ ዎዴ ዱጌሃ ባጋራ ዱንካኒ ኡቲዳ ኣሳይ ሄሜꬅ ዶሞ፤ ዛዬይ ꬎቁ ጊ ዛዬቲዛ ዎዴ ኣሳይ ሄሜꬅ ዶማናስ ማላታ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","ዴራ ኢሲ ቦላ ሺሻናስ ዛዬታ ꬎቂሶንታ ዚቂ ሂስታ ዛያ። ");
INSERT INTO gmve_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","ቄሴ ጊዲዳ ኣሮኔ ናይቲ ዛዬታ ፑኔቶ፤ ሄሲካ ኢንቴስ ና ና ጋካናስ ኤቂ ዲዛ ዎጋ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","«ኢንቴ ዴራ ቦላ ዎራጂዳ ኢንቴ ሞርኬታራ ኢንቴ ኦሌታናስ ኬዚዛ ዎዴ ዛዬታ ꬎቁ ሂስቲ ፑኒቴ፤ ሂስቲኮ ጎዳ ኢንቴ ጾሳይ ኢንቴና ቆፓናኔ ኢንቴ ሞርኬታፔ ኢንቴና ኣሻና። ");
INSERT INTO gmve_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","ሄሳꬆካ ኢንቴ ኡፋይሳ ባኣሌ ጋላስ፥ ሄሲካ ኣጊና ባኣሌታኔ ዱማ ዱማ ኢንቴ ቦንቻናስ ቃቺዳ ባኣሌታ ቦንቺዛ ዎዴ ጹጌቲዛ ያርሾኔ ኢሲፌቴꬃ ያርሾታ ሺሺዛ ዎዴ ዛዬታ ፑኒቴ፤ ሄይቲ ጾሳ ሲንꬃን ኢንቴና ቆፍሳና፤ ታኒ ጎዳ ኢንቴ ጾሳ።» ");
INSERT INTO gmve_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ዴሬዚ ጊብጼ ዴሬፔ ኬዚዳ ናምኣንꬆ ላይꬃን ናምኣንꬆ ኣጊናይ ጌሊዳ ናምኡ ታማንꬆ ጋላስ ማርካቴꬃ ዱንካኔዛፔ ቦላራ ዲዛ ሻራዚ ዴንዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ኢስራኤሌ ኣሳይ ሲና ባዞፌ ዴንዲዲ ሻራዚ ፓራኔ ባዞን ኤቃና ጋካናስ ዱማ ዱማሶን ሼምፒዳ። ");
INSERT INTO gmve_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","ኢስራኤሌ ኣሳይ ጎዳይ ካሴ ሙሴ ኣዛዚዳ ኣዛዞዛ ማላ ኮይሮ ዩሾ ሄሜꬅ ዶሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","ዩሁዳ ቆሞታ ባንዲራ ጋርሳን ዲዛ ኣሚናዳቤ ና ኔኣሶኔይ ካሌꬂን ባ ቡቴ ታራ ናጊዲ ኮይሮ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ዪሳኮሬ ዛርኬታ ካሌꬂዛይ ጹኣሬ ና ናቲናኤሌ። ");
INSERT INTO gmve_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ዛቢሎኔ ዛርኬታ ካሌꬂዛይ ሄሎኔ ና ኤልያቤ። ");
INSERT INTO gmve_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ሄሳፌ ጉዬ ዱንካኔዚ ሾዴቲን ዱንካኔዛ ቶኪዳይቲ ጌርሾኔ ቆሞቲኔ ሜራሬ ዛርኬቲ ቡስ ዶሚዳ። ");
INSERT INTO gmve_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ኢስታ ካሊዲ ኦሮቤሌ ዛርኬታ ባንዲራ ጋርሳን ዲዛይቲ ሻዱሬ ና ኤልጹሬይ ካሌꬂን ባ ታራ ናጊዲ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ሲሞና ዛርኬታ ካሌꬂዛይ ጹርሻዳዬ ና ሳሉምኤሌ። ");
INSERT INTO gmve_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ጋዴ ዛርኬታ ካሌꬂዛይ ዳኡኤሌ ና ኤልያሳፌ። ");
INSERT INTO gmve_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ሄሳፌ ጉዬ ሌዌ ባጋ ኣስ ጊዲዳ ቃኣቴ ዛርኬ ጊዲዳይቲ ጌሻ ሚሻታ ቶኪ ኤኪዲ ቢዳ፤ ኢስቲ ባፔ ሲንꬃ ባጋን ዲዛ ሄራዛ ጋካናፔ ካሴ ጾሳ ዱንካኔዚ ቶሌቲ ኡቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ሄሳፌ ካሊዲ ኤፍሬሜ ዛርኬታ ባንዲራ ጋርሳን ዲዛይቲ ኣሚሁዴ ና ኤልሻማይ ካሌꬂን ባ ታራ ናጊዲ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ሚናሴ ዛርኬታ ካሌꬂዛይ ፔዳጹሬ ና ጋማልኤሌ። ");
INSERT INTO gmve_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ቢኒያሜ ዛርኬታ ካሌꬂዛይ ጊዲኦኔ ና ኣቢዳኔ። ");
INSERT INTO gmve_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ዉርሴꬃን ሃ ቡቴታ ጉዬ ቱቻን ናጊዛ ዳኔ ዛርኬታ ባንዲራ ጋርሳን ዲዛይቲ ባ ታራ ናጊዲ ቢዳ፤ ዳኔ ቆሞታ ካሌꬂዛይ ኣሚሻዳዬ ና ኣሂኤዜሬ። ");
INSERT INTO gmve_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ኣሴሬ ዛርኬታ ካሌꬂዛይ ኦክራ ና ፋጉኤሌ፤ ");
INSERT INTO gmve_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ኒፍታሌሜ ዛርኬታ ካሌꬂዛይ ኤናኔ ና ኣሂሬ። ");
INSERT INTO gmve_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ሄሳ ጊሻስ ኢስራኤሌ ኣሳይ ካሴ ባ ዲዛሶፔ ኬዚዲ ባ ቡቴን ቡቴን ቢዛ ቡሳ ማራይ ሃይሳ ማላ። ");
INSERT INTO gmve_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","ሙሴይ ባ ማቼይ ኣዋ ሚዲያሜ ዴሬ ኣስ ኤራኡኤሌ ና ሆባቤስ፥ «ሄኮ ኑኒ ጎዳይ ኑስ ኢማናስ ካሴ ጫቂዳ ዴሬ ባናስ ጊጌቲዶስ፤ ጎዳይ ኢስራኤሌ ኣሳ ዱሬሳናስ ካሴ ኑስ ጫቂ ዎꬂዴስ፤ ሄሳ ጊሻስ ኔካ ኑናራ ሄꬋ፤ ኑኒ ኔስ ሎኦ ኦꬃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ሆባቤይ፥ «ኣካይ! ካሴ ታኒ ዬሌቲዳ ዴሬኔ ታ ዳቦታኮ ሲማ ባና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","ሙሴይ ኢዛስ፥ «ኔ ኑፔ ሻኬታ ቦፓርኪ! ኑኒ ሃይሳ ባዞ ቢታን ቢሼ ኣዋን ኣዋን ሼምፓና ቤሲዛኮ ኔኒ ኤራሳ፤ ኔኒ ኑና ኦጌ ካሌꬂዛ ኣስ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ኔኒ ኑናራ ቢኮ ጎዳይ ኑስ ኢሚዛ ሎኦ ሚሻ ኡባፌ ኑ ኔስ ሻኪ ኢማና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","ዴሬዚ ጌሻ ዙማይ ዲዛ ሲና ባዞ ዬጊዲ ሄꬑ ጋላሳ ኦጌ ቢዴስ፤ ሄꬑ ጋላሳታን ጎዳ ጫቆ ቃላ ታቦታዚ ኣሳይ ሼምፓናሶ ኮያናስ ኣሳፔ ሲንꬃቲ ቢዴስ፤ ኢስቲ ካሴ ባ ዲዛ ሄራ ዬዳናፔ ካሴቲዲ ኣሳይ ሼምፓናሶ ኮያናስ ጫቆ ቃላ ታቦታዚ ኢስታፌ ሲንꬃን ሲንꬃን ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ኢስቲ ባ ዲዛሶፔ ዴንዲ ዴንዲ ቢሺን ጎዳ ሻራይ ጋላስ ጋላስ ኢስታ ካሚ ኦይኬስ። ");
INSERT INTO gmve_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ጫቆ ቃላ ታቦታይ ባና ዴንዲሺን ዴንዲሺን ሙሴይ፥ «ጎዳዉ! ኔካ ዴንዳ፤ ኔ ሞርኬቲ ላሌቴቶ፤ ኔና ኢጺዛይቲ ዉሪካ ኔ ሲንꬃፌ ኪቼቶ!» ጌስ። ");
INSERT INTO gmve_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","ጫቆ ቃላ ታቦታዚ ኢሲሶ ጋኪ ኤቂዛ ዎዴ፥ «ታ ጎዳዉ! ዳሮ ሺያን ቆዴቲዛ ኢስራኤሌ ኣሳኮ ኔ ኣይፌሶ ሃ ዛራ» ጌስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ኢስራኤሌ ኣሳይ ባ ቦላ ጋኪዳ ሜቶ ኡባ ጊሻስ ጎዳ ቦላ ዙዙሚዴስ፤ ጎዳይ ኣሳ ዙዙንꬃ ዋሶዛ ሲዪዲ ኬሂ ሃንቄቲዴስ፤ ኢስታ ቦላካ ጹጊዛ ታማ ዬዲዴስ፤ ሄ ጎዳ ታማይ ኣሳይ ዱንካኒ ኡቲዳሶሆፔ ጋጻራ ኣማርዳይሳ ሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ኣሳይካ ባና ጎዳራ ጊጊሳና ማላ ሙሴኮ ዋሲዴስ፤ ሙሴይካ ጎዳ ዎሲን ታማዚ ቶኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","ጾሳ ታማይ ሄን ኢስታ ጊዶን ኤጺዳ ጊሻስ ሄ ሶሆይ፥ «ታቤሬ» ጌቴቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ኢስራኤሌ ኣሳራ ዋላኬቲ ኬዚዲ ቢዛ ሃራ ዱማ ዱማ ዴሬ ኣሳይ ኣሾ ማናስ ዳሮ ኣሞቲዴስ፤ ኢስራኤሌ ኣሳይካ፥ «ኑኒ ማና ኣሾ ኣዋፔ ዴሚኖ! ");
INSERT INTO gmve_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ካሴ ኑ ጊብጼን ዲዛ ዎዴ ኣይኮ ሚሽ ቃንጾንታ ጮ ሜላ ሚዛ ሞሌ ኣሾይ፥ ሌሌሄይ፥ ሌሌሄ ሚሳቲዛ ሃቢሃቤይ፥ ዶኖ ሚሳቲዛ ኩራቴይ፥ ሱንኩርቶይኔ ቱሞይ ኑና ላሞꬄስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ሃኢ ጊዲኮ ማና ጻላይ ኑና ሳሌꬂዴስ፤ ቆꬌይካ ካꬅ ኢጺዴስ፤ ማናፌ ኣቲን ሃራ ኑ ቤኢዛ ካꬂ ባዋ» ጊ ዬኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","ማናይ ዴቦ ኣይፌ ማላ ጉꬃ፤ ኢዛስ ሜꬋይ ቦጺ ኤኪዛ ሺዳ ማላ ጊዲዲ ጋላልኦ ሚሳቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ኣሳይ ሄሳ ዩዪ ዩዪ ማጼስ፤ ኢዛ ዎጻን ጋጪዲ ዎይኮ ኡዱላን ጫዲዲ ጉꬃ ጻሮን ሙኑቂዲ ኡኬስ፤ ሚሺን ኢዚ ዶናን ዛይቴራ ጊንዴቲ ኡኬቲዳ ኡኬꬃ ማላ ማልኤስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","ኦማርስ ኦማርስ ኢስቲ ዱንካኒ ዲዛሶ ሄራን ጻዛይ ዎꬊሺን ማናይ ኢዛራ ኢሲፌ ዎꬌስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","ዴሬዚ ዉሪካ ባ ዱንካኔ ፔንጌን ፔንጌን ባሶ ኣሳራ ኣሳራ ኤቂዲ ዬኪሺን ሙሴይ ሲዪዴስ፤ ጾሲ ኢስታ ቦላ ሃንቄቲዳ ጊሻስ ሙሴይ ኬሂ ጬጪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","ኢዚ ጎዳ፥ «ሃይሳ ዴጾ ሜቶ ኔስ ኣይሌ ጊዲዳ ታ ቦላ ኣይስ ኤሃዲ? ኔኒ ሃይሳ ሃ ዴሬዛ ኡባ ዴጾ ቶሆ ታና ኔ ቶሳናስ ታ ኔና ኣይ ሚሺሳዲና? ");
INSERT INTO gmve_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ቡሮ ꬋንꬅ ꬋሚዛ ና ዲቺዛ ሄ ጉꬃ ናዛ ኢዲሚዛ ማላ ታኒ ኢስታ ኢዲማዳ ኔኒ ካሴ ኣዋታስ ጫቂዳ ቢታ ጋꬃና ማላ ኔ ታና ኦꬂዛይ ሃይታንታ ዉርሳ ሻሪዳይ ታኔ? ዎይኮ ኢስታ ታ ዬላዲና? ");
INSERT INTO gmve_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ኢስቲ ታና፥ ‹ኑስ ኣሾ ኢማ› ጊዲ ታኮ ዪዲ ዬኪዛ ጊሻስ ሃይሳ ኣሳ ኡባስ ጊዳና ኣሾ ታ ኣዋፔ ኤሆ? ");
INSERT INTO gmve_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ታኒ ታርካ ሃይሳ ዴራ ካሌꬃናስ ዳንዳይኬ፤ ሃይሲ ኣላፌቴꬃዚ ታና ኬሂ ዴጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ኔ ታና ሃይሳꬆ ዋዪሳናፔ ታኒ ሜቶ ቤኦንታ ማላ ኔ ታስ ሚሼቲዛ ጊዲኮ ኔ ታና ሃኢ ዎꬊዳኮ ታስ ሎኦ» ጊ ዎሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","ጎዳይ ሙሴስ፥ «ዴሬዛ ኣይሳና ዳንዳይዛ ኤሬቲዳ ላፑን ታሙ ጪማታ ዶራ፤ ኔኒ ኢስታ ሺሻዳ ጋይቶቴꬃ ዱንካኔዛኮ ኤሃዳ ኔ ኣቻን ኤሳ። ");
INSERT INTO gmve_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","ታኒካ ሄ ዎꬋዳ ኔናራ ሃሳያና፤ ታኒ ኔስ ኢሚዳ ኣያናፔ ኢስታስ ሻካ ኢማና፤ ሄሳፌ ጉዬ ኢስቲ ዴሬዛ ኔስ ዲዛ ኣላፌቴꬃፌ ሻኪ ኤኪዲ ዴሬዛ ቶሆ ቶኪ ኔና ማዳና፤ ሃይሳፌ ጉዬ ሃይሳ ኣላፌቴꬃ ኔ ጻላ ቶካካ። ");
INSERT INTO gmve_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","ሃኢካ ዴሬዛስ፥ ‹ዎንቶስ ኢንቴና ጌሺቴ፤ ኢንቴስ ማና ኣሾይ ዳና፤ ኢንቴ ኑኒ ማና ኣሾ ኑስ ኦኔ ኢማናይ ጊዲ ዬኪዳይሳኔ ኑስ ጊብጼይ ሎኦ ጊዳይሳ ጎዳይ ሲዪዴስ፤ ሄኮ ሃኢ ኢንቴስ ጎዳይ ኣሾ ኢማና፤ ኢንቴካ ኢዛ ማንዴታ። ");
INSERT INTO gmve_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ኢንቴ ኣሾ ማናይ ኢሲ ጋላስ ዎይኮ ናምኡ ጋላስ ዎይኮ ኢቻሹ ጋላስ ዎይኮ ታሙ ጋላስ ዎይኮ ናምኡ ታሙ ጋላስ ጻላ ጊዴና። ");
INSERT INTO gmve_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ኢዚ ኢንቴና ሳሌꬂዲ ኢንቴስ ሲꬌራ ኬዛና ጋካናስ ኣጊና ኩሜꬅ ኢንቴ ኢዛ ማና፤ ሄሲካ ሃናናይ ኢንቴ ሃይሳ ኢንቴ ጊዶን ዲዛ ጎዳ ካꬊዳ ጊሻሲኔ ኑኒ ጊብጼፔ ካሴ ኬዞንታ ኣጊዳኮ ኑስ ሎኦኮሺን ጊዲ ኢንቴ ዬኪዳ ጊሻሳ› » ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ሙሴይ ጎዳስ፥ «ሄኮ ሃኢ ታኒ ካሌꬂዛይ ኡሱፑን ጼቱ ሺ ኣሳ፤ ‹ኔኒ ኣጊናስ ጊዳና ኣሾ ኢስታስ ኢማና› ጋዳ ቃላ ጌላዳሳ። ");
INSERT INTO gmve_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ሂስቲን ሃይሳ ኣሳስ ኣይ ኬና ሜሄይ ሹኬቲን ጊዳኔ? ኣባ ጊዶን ዲዛ ሞሌይ ኡባይ ኢሲ ቦላ ሺቂዳኮ ጊዳንዴ?» ጊ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","ጎዳይ ሙሴስ፥ «ታስ ጾሳስ ዎልቃይ ጉꬄ? ታ ቃላይ ኢንቴ ኣቻን ፖሌታናኮኔ ኣጋናኮ ኔ ሃኢ ቤኣና» ጊ ዛሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","ሄሳ ጊሻስ ሙሴይ ኬዚዲ ጎዳይ ኢዛስ ጊዳይሳ ኡባ ዴሬዛስ ዮቲዴስ፤ ዴሬዛ ካሌꬂዛይታፔ ላፑን ታሙ ኣስ ኢሲሶ ሺሺዲ ዱንካኔዛ ዩሾን ኤሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","ጎዳይካ ሻራራ ዎꬊዲ ኢዛስ ዮቲዴስ፤ ሙሴስ ኢሚዳ ኣያናፔ ሻኪዲ ዴራ ካሌꬂዛ ላፑን ታሙ ጪማታ ቦላ ዎꬂዴስ፤ ኣያናይ ኢስታ ቦላ ዎꬊን ኢስቲ ባንታ ቃላ ꬎቁ ሂስቲዲ ናቤታ ማላ ቲንቢቴ ሃሳይዳ፤ ኢስቲ ሄሳ ናምኣንꬂቤቴና። ");
INSERT INTO gmve_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ማዝጋቤቲዳ ላፑን ታሙ ዴራ ካሌꬂዛይታ ጊዶፌ ናምኣቲ ኤልዳዴኔ ሜዳዴ ጌቴቲዛይቲ ጌዴ ዱንካኔዛኮ ቦንታ ባንቲ ዲዛ ሄራን ጋምኢዳ፤ ኢስቲ ሄን ዲሺን ኣያናይ ኢስታ ቦላ ዎꬊን ኢስቲካ ባ ቃላ ꬎቁ ሂስቲዲ ናቤታ ማላ ቲንቢቴ ሃሳይዳ። ");
INSERT INTO gmve_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ኢሲ ናቴꬃ ኣሲ ሙሴኮ ዎጺ ቢዲ፥ «ኤልዳዴይኔ ሜዳዴይ ሄን ባንታ ሄራን ዲሼ ቲንቢቴ ሃሳዬቴስ» ጊ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","ናቴꬃፌ ዶሚዲ ሙሴ ኦꬂ ማዲዛ ናዌ ና ኢያሶይ፥ «ታ ጎዳ ሙሴ! ሃይታንቲ ቲንቢቴ ሃሳዮንታ ማላ ቴቃ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ሙሴይካ ኢዛስ፥ «ኔ ታስ ሚሼታዳ ሄሳ ጋይ? ታኒ ጊዲኮ ጾሲ ሃይሳ ዴራ ኡባ ቦላ ባ ኣያና ዎꬂኮኔ ኡባይካ ባ ቃላ ꬎቁ ሂስቲዲ ናቤታ ማላ ቲንቢቴ ሃሳይዳኮ ሄሲ ታስ ኡፋይሳ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ሙሴይኔ ኢስራኤሌ ኣሳ ካሌꬂዛ ላፑን ታሙ ኣሳይ ጌዴ ባ ዲዛሶ ሲሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","ሄሳፌ ጉዬ ጎዳይ ጫርኮ ዴንꬂዲ ኣባ ጊዶፌ ኩራቾ ሚሳቲዛ ካፎ ኣሳይ ዱንካኒ ኡቲዳ ሄራ ኤሂዴስ፤ ሂስቲዲ ሄ ካፎታ ቢታፌ ፑዴ ናምኡ ዋꬋ ኬና ꬎቁ ጊዲ ፒራꬊ ዪዲ ኣሳይ ዱንካኒ ኡቲዳ ሄራ ዩሾን ኢሲ ጋላሳ ኦጌ ኬና ጊዲዛሶን ቢታ ቦላ ማይኢ ኡቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ሄሳ ጊሻስ ሄ ጋላሲኔ ኦማርስ፥ ሄሳꬆካ ዎንቴꬃ ጋላሲካ ዴሬዚ ሄ ካፎታ ኦይኪ ሺሺዴስ፤ ኢሲ ኣሲካ ታሙ ኪሎፔ ፓጬ ኦይኪቤና፤ ኢዚካ ሜላና ማላ ባ ዱንካኒዳ ሄራ ዩሾ ኡባን ሚጪዳ። ");
INSERT INTO gmve_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ጊዶ ኣቲን ኢስቲ ቡሮ ጮሚ ሚቶንታ ዲሺን ጎዳይ ዴራ ቦላ ኬሂ ሃንቄቲዴስ፤ ጎዳይ ጊታ ቦሻካ ዴራ ቦላ ዬዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","ኣሾ ኣሞቲዲ ሃይቂዳ ኣሳ ሄን ጋዳን ሞጊዳ ጊሻስ ሄ ጋዴዛ ሱንꬂ፥ «ኪብሮቴ-ሃታኣቤ» ጌቴቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ኣሳይ ኪብሮቴ-ሃታኣቤ ጌዴ ሃጺሮቴ ቢዲ ሄን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","ሙሴይ ቶጵያፔ ማቾ ኤኪዳ ጊሻስ ማራማኔ ኣሮኔይ ዚጊርሳን ኢዛ ሂዝጊ ካꬊዳ፥ ");
INSERT INTO gmve_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","«ጎዳይ ሙሴ ባጋራ ጻላ ሃሳይዴ? ኑ ባጋራ ሃሳይቤኔ?» ጎዳይ ኢስቲ ጊዳይሳ ኡባካ ሲዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","ሙሴይ ጊዲኮ ቢታ ቦላ ዲዛ ኣሳ ኡባፌ ኣꬊዳ ኣሽኬ ኣሳ። ");
INSERT INTO gmve_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","ሄራካ ጎዳይ ሙሴ፥ ኣሮኔኔ ማራሞ፥ «ኢንቴ ሄꬓይ ጋይቶቴꬃ ዱንካኔኮ ሃ ዪቴ!» ጊዴስ፤ ኢስቲካ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","ሂስቲን ጎዳይ ቱስ ሚሳቲዛ ሻራ ጊዶራ ዎꬊዲ ዱንካኔዛ ፔንጌን ኤቂዲ፥ «ሃይሶ ኣሮኔ! ሃኔ ማራሜ!» ጊ ጼይጊዴስ፤ ናምኣቲካ ጌዴ ኢዛ ሲንꬅ ሺቂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ጎዳይ ኢስታስ፥ «ሄኮ ሃኢ ታ ኢንቴና ጊዛይሳ ኣኬኪ ሲዪቴ! «ኢንቴ ጊዶን ናቤቲ ዲኮ፥ ታኒ ታና ኢስታስ ኣጁታን ቆንጪሳይስ፤ ኣጉሞን ኢስታ ሃሳይሳይስ። ");
INSERT INTO gmve_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","ታኒ ታስ ሃጋዚዛ ሙሴራ ጊዲኮ ሄሳ ማላን ሃሳይኬ፤ ኢዚ ታ ኬꬃን ኣማኔቲዳ ኣሳ። ");
INSERT INTO gmve_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","ሄሳ ጊሻስ ታኒ ኢዛራ ሲንꬃን ቆንጬራ ሃሳያይስ ኣቲን ጉዬራ ቆታን ሃሳይኬ፤ ኢዚ ታ ሜꬋ ቤዬስ፤ ሂስቲን ኢንቴ ታ ኦሳንቻዛ ሙሴ ቦላ ዋኒ ያዮንታ ካꬌ ቃላ ሃሳይዴቲ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","ጎዳ ሃንቆይ ኢስታ ቦላ ታማ ማላ ኤጺ ኬዚዴስ፤ ኢዚካ ኢስታ ሄን ኣጊ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ሻራዚ ዱንካኔዛ ቦላፌ ዴንዲ ቢን ማራማ ኢንቺራቻ ሃርጋንቻ ጊዳዱስ፤ ኢንቺራቻ ሃርጌዚካ ኢዚ ቦላ ሻቻ ማላ ቦꬂዴስ፤ ኣሮኔይ ማራሞ ቤዪሺን ኢዛ ኢዛስ ኢንቺራቻ ሃርጋንቻ ጊዳ ቤታዱስ። ");
INSERT INTO gmve_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ኣሮኔይ ሙሴስ፥ «ታ ጎዶ! ኑኒ ኔ ቦላ ኦꬂዳ ናጋራ ጋሶን ሃይሲ ኢታ ቂጻቴይ ኑ ቦላ ፖሌታና ማላ ኦꬆፋርኪ! ");
INSERT INTO gmve_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ኢዛካ ባ ኣዪ ኡሎን ሃይቃዳ ኢዚስ ባጋ ኣሳቴꬃይ ሜቴቲቺን ዬሌቲዳ ኣዉጫያ ና ማላ ኦꬆፋርኪ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","ሄሳ ጊሻስ ሙሴይ፥ «ጾሳዉ! ኢዞ ፓꬃርኪ!» ጊዲ ፑዴ ጎዳኮ ዋሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","ጎዳይካ ሙሴስ፥ «ኢዚ ኣዋይ ኣይፌሶን ጩች ጩቲዳራካ ዬላታዳ ላፑን ጋላስ ጋካናስ ጋምኣ ኤሬኬ? ሄሳ ጊሻስ ኢዛ ኣሳይ ዲዛ ሄራፔ ኬዛዳ ላፑን ጋላስ ጋካናስ ኣሲ ባይንዳሶን ታካሹ፤ ሄሳፌ ጉዬ ኣሳይ ዲዛሶ ጌላናስ ዳንዳያዉስ» ጊ ዛሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ሄሳ ጊሻስ ማራማ ኣሲ ዲዛ ጉታፔ ካሬ ኬዛዳ ላፑን ጋላስ ጋካናስ ባና ጌንꬃዱስ፤ ኢዛ ሄፔ ሲማና ጋካናስ ዴሬዚ ባ ዲዛሶፔ ሃራሶ ቃጺቤና። ");
INSERT INTO gmve_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ሄሳፌ ጉዬ ኣሳይ ሃጺሮቴፔ ዴንዲዲ ፓራኔ ባዞን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«ታማኔ ናምኡ ኢስራኤሌ ኣሳ ጋርሳፌ ዴሬ ካሌꬂዛይታ ዶራዳ ታኒ ኢስራኤሌ ኣሳስ ኢማና ጊዳ ካናኔ ቢታዮ ጾሞሲ ጼሊዲ ያና ማላ ዬዳ።» ");
INSERT INTO gmve_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","ሙሴይካ ጎዳይ ኢዛ ኣዛዚዳ ማላ ኢስራኤሌ ኣሳ ካሌꬂዛይታ ጊዶፌ ፓራኔ ባዞፌ ታማኔ ናምኡ ኣሳታ ዬዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ሄ ኣሳታ ሱንꬃይካ ሃይሳፌ ካሊዛይሳ፤ ኦሮቤሌ ዛርኬፌ ዛኩሬ ና ሻሙኤ፥ ");
INSERT INTO gmve_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ሲሞና ዛርኬፌ ሆሬ ና ሳፋጼ ");
INSERT INTO gmve_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","ዩሁዳ ዛርኬፌ ዮፊኔ ና ካሌቤ፥ ");
INSERT INTO gmve_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ዪሳኮሬ ዛርኬፌ ዮሴፌ ና ዪጊኣሌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ኤፍሬሜ ዛርኬፌ ናዌ ና ሆሴኤ፥ ");
INSERT INTO gmve_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ቢኒያሜ ዛርኬፌ ኤራፎ ና ፓሊጼ፥ ");
INSERT INTO gmve_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ዛቢሎኔ ዛርኬፌ ሳዴ ና ጋዱኤሌ፤ ");
INSERT INTO gmve_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ዮሴፌ ዛርኬፌ ሚናሴ ባጋ ጊዲዳ ሱሴ ና ጋዴዬ፥ ");
INSERT INTO gmve_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ዳኔ ዛርኬፌ ጋማሌ ና ኣምኤሌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ኣሴሬ ዛርኬፌ ሚካኤሌ ና ሳቱሬ፥ ");
INSERT INTO gmve_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","ኒፍታሌሜ ዛርኬፌ ዋፊሴ ና ናሂቤ፥ ");
INSERT INTO gmve_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ጋዴ ዛርኬፌ ማኬ ና ጋኡኤሌ። ");
INSERT INTO gmve_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ሄይቲ ዴሬዛ ሃኖታ ጾሞሲ ጼሊዲ ያና ማላ ሙሴይ ኪቲዳይታ፤ ናዌ ና ሆሴኤ፥ «ኢያሶ» ጊዲ ኢዛ ሱንꬃ ላሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","ሙሴይ ኢስታ ኪቲ ዬዲሼ፥ «ኢንቴ ቢሼ ኔጌቤ ባጋራ ኣꬊዲ ፑዴ ጌዜ ቢታ ቢቴ። ");
INSERT INTO gmve_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ሄ ዴሬያ ኣይ ሚሳቲዛኮ፥ ኣይ ኬና ኣሲ ኢዚን ዲዛኮ ቃሴካ ኣሳ ሚኖቴꬂ ኣይ ማላኮ ጾሞሲ ጼሊዲ ዪቴ። ");
INSERT INTO gmve_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ሄ ቢታያ ኢታኮኔ ሎኦኮ ኣሳይ ዲዛ ካታማያ ጊምቤታ ኡቲዳኮ ዎይኮ ጊምቤቶንታ ጮ ሜላ ዲዛኮ ጾሞሲ ጼሊቴ። ");
INSERT INTO gmve_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ቢታያ ሞꬎኮኔ ቃላኮ፥ ዎራኮኔ ጮ ዲዛኮ ጾሞሲ ጼሊቴ፤ ሚኒቴ! ሄ ቢታን ዲዛ ሚꬃ ኣይፌታፔ ኤኪ ዪቴ» ጊዴስ፤ ኢስቲ ሄ ቢዳ ዎዴይ ዎይኔ ሚꬃ ኣይፌይ ቴሪዛ ዎዴ። ");
INSERT INTO gmve_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","ሄሳ ጊሻስ ሄ ዎዴ ኣሳይ ፑዴሃ ባጋ ዴሬ ቢዴስ፤ ሄ ዴሬዛን ዲዛ ጺኔ ባዞፌ ዶሚዲ ጌዴ ሃማቴ ኣꬊ ቢዛሶዛ ማታን ዲዛ ኤራሆቤ ጋካናስ ዩዪ ጼሊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ኮይሮ ጌዴ ኔጌቤ ቢዲ ሄራ ኬብሮኔ ጋኪዳ፤ ኬብሮኔይካ፥ «ኤናቄ» ጌቴቲዛ ጌሳኔ ጉባ ጊታ ኣሳታ ዜሬꬅ ጊዲዳ ኣሂማኔ፥ ሻሻዬኔ ታሊማዬ ጌቴቲዛ ዛርኬቲ ዲዛ ቢታ። ኬብሮኔይ ጊብጼን ዲዛ ጻኖሴ ካታማይፔ ላፑን ላይꬅ ሲንꬃታ ኤቃዱስ። ");
INSERT INTO gmve_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ኢስቲ ሄራ ኣꬊዲ ጌዴ ኤሽኮሌ ሾባ ጋኪዳ፤ ሄፔካ ዎይኔ ሚꬃ ኣይፌራ ዲዛ ሃጋ ቃንጺ ኤኪዲ ሄ ዎይኔ ሚꬃ ኣይፌፔ ኢሲ ዉርጮ ኢሳዴይ ባርካ ቶካናስ ዳንዳዮንታ ዴጾ ጊዲዳ ጊሻስ ናምኡ ኣሳቲ ሚꬃን ኣꬂ ቶኪዳ፤ ኢዛራ ኢሲፌ ኦሮማኔ ሚꬃ ኣይፌኔ ባላሴ ሚꬃ ኣይፌ ኤኪ ዪዳ። ");
INSERT INTO gmve_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ሄሲ ሄ ሶሆዚ፥ «ኤሽኮሌ ሾባ» ጌቴቲዳ ጋሶይካ ኢስራኤሌ ኣሳይ ዎይኔ ሚꬃ ኢዛ ኣይፌ ዉርጮዛራ ጋꬂ ቃንጺ ኤኪዲ ዪዳሶ ጊዲዳ ጊሻሳ። ");
INSERT INTO gmve_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ኢስቲ ቢታዮ ኦይዱ ታሙ ጋላስ ጾሞሲ ጼሊዳፔ ጉዬ ኣጊ ሲሚዳ። ");
INSERT INTO gmve_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ፓራኔ ባዞን ቃዴሴን ዲዛ ሙሴኮ፥ ኣሮኔኮኔ ኢስራኤሌ ማባራ ኩሜꬃኮ ሲሚ ዪዲ ባንቲ ቤይዳይሳ ኡባ ቆንጪሲ ዮቲዳ፤ ባንቲ ኤኪ ዪዳ ሚꬃ ኣይፌዛካ ኢስታ ቤሲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","ኢስቲ ሙሴስ፥ «ኑኒ ቢታዮ ጾሞሲ ቤኢዲ ኣዳፌካ ኢዛ ማꬂኔ ኤሲ ኩሚዳ ዱሬ ዴሬ ጊዲዳሮ ሻኪ ኤሪዶስ፤ ሄ ቢታያ ኢሚዛ ኣይፌዛ ሃይሳ ቤያ። ");
INSERT INTO gmve_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","ጊዶ ኣቲን ሄ ዴሬዪን ዲዛ ኣሳይ ዳሮ ሚኖ፤ ሄሳፌ ቦላራ ኢስታ ካታማቲካ ዳሮ ጊታታኔ ጊምቤይ ዩዪ ኣꬊዳይታ፤ ሄሲ ሄሳ ጊዲሺን ኣሳይ ቃሴ ጌሳኔ ጉባ ጊታ ጊዲዳ ኤናቄ ዜሬꬃታ ኑ ቤይዶስ። ");
INSERT INTO gmve_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","ኣማሌቄ ኣሳይ ኔጌቤን ዲሺን፥ ሂቴ ኣሳይ፥ ያቡሴ ኣሳይኔ ኣሞሬ ኣሳይ ቦላ ጌዜ ቢታን ካናኔ ኣሳይ ቃሴ ዮርዳኖሴ ሃꬃ ጋጻኒኔ ሜዲቴራኔ ኣባ ኣቻን ዴቴስ» ጊ ዮቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","ካሌቤይ ቃሴ ሙሴ ሲንꬃን ኣሳ ጮኡ ሂስቲዲ፥ «ኑኒ ኢስታ ጾናናስ ኑስ ጊዲዛ ዎልቃይ ዲዛ ጊሻስ ኑኒ ሃኢ ቢዲ ሄ ቢታዮ ኣኔ ኦይኮስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ካሌቤራ ቢዳ ኣሳቲ ቃሴ፥ «ኑኒ ኢስታ ቦላ ሜቶ ጋꬃናስ ሙሌካ ኑስ ዎልቃይ ባዋ፤ ሄ ዴራን ዲዛ ኣሳይ ኑፔ ዳሮ ሚኖ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","ኢስቲ ጾሞሲ ጼላና ቢዳ ዴሬዛ ጊሻስ ኢስራኤሌ ኣሳስ ኤሂ ዮቲዳ ዮኦይ ኣሳስ ዲዛ ሂዶታ ቃንጺሲዛ ዮኦ፤ ኢስቲ ቃሴካ፥ «ኑኒ ኢዞ ጾሞሲ ጼሊዳ ቢታያ ኢዚን ዳናስ ቢዛ ኣስ ሚቲዛ ቢታ፤ ኑኒ ሄን ቤይዳ ኣሳይካ ጌሳኔ ጉባ ጊታ። ");
INSERT INTO gmve_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ኔፍሌሜ ባጋ ጊዲዳ ኤናቄ ናይታ ኑኒ ሄን ቤይዶስ፤ ኑኒ ኢስታ ኣቻን ቄሪ ጉምባሮ ሚሳቲዶስ፤ ኢስቲካ ኑና ሄሳꬆ ጼሎንታ ኣጌቴና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ዴሬዚ ሄ ጋላሳ ኦማርስ ኩሜꬅ ባ ቃላ ꬎቁ ሂስቲዲ ዋሲሼ ኣቂዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ኩሜꬃ ኢስራኤሌ ማባራይ ሙሴ ቦላኔ ኣሮኔ ቦላ ዙዙሚሼ፥ «ኑኒ ካሴ ሄን ጊብጼን ዲሼ ዎይኮ ሃይሳ ሃ ባዞ ቢታን ሃይቂዳኮ ኑስ ሎኦኮሺን! ");
INSERT INTO gmve_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","ጎዳይ ኑና ሂኖ ሄ ዴሬዮ ኣዛስ ኤፊዜ? ኑኒ ዉሪካ ኦላን ዉራናስ ዶስ፤ ኑ ማቼቲኔ ኑ ናይቲካ ዲኤታና፤ ሄሳፌ ኑኒ ዱጌ ጊብጼ ሲሚኮ ኑስ ሎኣና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","ሄሳ ጊሻስ ኢስቲ ባ ጋርሳን ኢሶይ ኢሳራ፥ «ኣኔ ሃ ዪቴ! ኑና ካሌꬃና ኣስ ዶሪዲ ኣኔ ኣጊ ጉዬ ጊብጼ ሲሞስ» ጊ ሃሳዬቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","ሄ ዎዴ ሙሴይኔ ኣሮኔይ ኩሜꬃ ዴራ ሲንꬃን ቢታ ቦላ ጉፋኒዳ። ");
INSERT INTO gmve_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ቢታዮ ጾሞሳናስ ኪቴቲዳ ኣሳታፔ ናዌ ና ኢያሶይኔ ዮፊኔ ና ካሌቤይ ዮኦዛን ዳሮ ጬጪዲ ባንታ ማይኦዛ ዳኪዳ። ");
INSERT INTO gmve_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ኢስቲ ዴሬዛስ፥ «ኑኒ ቢዲ ዩዪ ጾሞሲ ጼሊዳ ቢታያ ኬሃ ሎኦ ቢታ። ");
INSERT INTO gmve_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","ጎዳይ ኑናን ኡፋዬቲዳ ጊዲኮ ኢዚ ኑና ሄ ኤፋና፤ ኤሲኔ ማꬂ ኢዚን ኩሚዳ ጋሳ ቢታዮ ኢዚ ኑስ ኢማና። ");
INSERT INTO gmve_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","ኢንቴ ጊዲኮ ጎዳ ቦላ ማካሎፍቴ! ሄን ዲዛ ዴሬዛስካ ባቦፍቴ! ኑኒ ኢስታ ቂሶን ጾናና፤ ጎዳይ ኑናራ ዴስ፤ ኢስታ ቦላፌ ኤሾይ ዴንዲቺዳ ጊሻስ ኢንቴ ኢስታስ ሙሌካ ባቦፍቴ!» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ኢስታ ሹቻራ ጫዲ ዎꬋናስ ኩሜꬃ ማባራይ ኢስታ ቦላ ዴንዲዴስ፤ ጊዶ ኣቲን ጎዳ ቦንቾይ ኢስራኤሌ ኣሳ ኩሜꬃስ ጋይቶቴꬃ ዱንካኔዛን ቆንጪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","ጎዳይ ሙሴስ፥ «ሃይሲ ዴሬዚ ኣይዴ ጋካናስ ታና ካꬋኔ? ታኒ ዴሬዛ ሲንꬃን ዳሮ ማላታ ኦꬃዲስ፤ ሂስቲን ዴሬዚ ታናን ኣማኔቶንታ ኣይዴ ጋካናስ ኢጻኔ? ");
INSERT INTO gmve_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","ሄኮ ሃኢ ታኒ ኢታ ሃርጌ ኢስታ ቦላ ኤሃዳ ኢስታ ኡባ ዉርሳና፤ ኔና ጊዲኮ ኢስታፌ ኣꬊዛ ሚኖ ካዎቴꬃስ ኣዋሳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","ሙሴይ ጊዲኮ ጎዳስ፥ «ኔኒ ሃይሳ ዴሬዛ ኔ ዎልቃን ጊብጼፔ ኬሳዳሳ፤ ኔኒ ሃይሳ ኔ ዴሬዛ ቦላ ኦꬂዳይሳ ጊብጼ ኣሳይ ሲዪዳ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ሄሳ ሃኒዳ ዮኦ ኡባ ሃይሳ ዴሬዛን ዲዛ ኣሳ ኩሜꬃስ ኢስቲ ዮታና፤ ሃይቲ ሃ ኣሳቲ ኔኒ ጎዳይ ኑናራ ዲዛይሳኔ ሻራይ ኑፔ ቦላራ ቆንጬን ቤቲዛ ማላ ኔኒ ጋላስ ጋላስ ሻራ ማላ ቱሳን ኦማርስ ኦማርስ ታማ ማላ ቱሳን ጊዳዳ ኑፔ ሲንꬄ ኣꬋ ካሌꬂዛይሳ ሲዪሼ ጋምኢዳ። ");
INSERT INTO gmve_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ሂስቲን ኔ ሃኢ ኔ ኣሳ ዉርሳ ዎꬊኮ ኔ ጎባቴꬃ ሲዪዳ ካዎቴꬅ ኡባይ፥ ");
INSERT INTO gmve_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","ኔና፥ ‹ኢዚ ባ ዴሬዛ ጌልꬃና ጊዲ ካሴ ጫቂዳ ጫቆዛ ፖላናስ ዳንዳዮንታ ኣጊዳ ጊሻስ ኢስታ ባዞን ዎꬊ ꬋይሲዴስ› ጋና። ");
INSERT INTO gmve_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","18","ጎዶ ሃይሳፌ ካሴ ኔኒ፥ ‹ጎዳይ ኤሌ ሃንቄቲ ኤሬና፤ ኢዛ ማሮቴꬃይኔ ኢዛ ሲቆይ ዳሮ፤ ኢዚ ናጋራኔ ጌላቴꬃ ኣቶ ጋና፤ ጊዶ ኣቲን ናይታኔ ኢስታስ ናይታ ናይታ ጋካናስ ኢስቲ ዬሊዳይታ ናጋራ ጊሻስ ታ ኢስታ ቃጻያና› ጊዳ ማላ ፖላዳ ኔ ዎልቃ ቤሳ። ");
INSERT INTO gmve_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","ሃኢካ ጎዶ! ላሜቶንታ ኔ ጊታ ሲቆዛን ኢስቲ ጊብጼፔ ኬዞሶፌ ሃኖ ጋካናስ ኔ ኢስታ ማሪዳ ማላ ሃይሳ ዴራ ናጋራ ኔ ማራና ማላ ታ ኔና ዎሳይስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","ጎዳይካ ሙሴስ፥ «ኔ ታና ኦይቺዳ ማላ ታ ኢስታ ማራዲስ። ");
INSERT INTO gmve_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ጊዶ ኣቲን ታኒ ዴኦን ዲዛ ማላኔ ታ ቦንቾይ ቢታ ኡባን ኩሚዳ ማላ፥ ");
INSERT INTO gmve_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ታኒ ኢስታስ ጊብጼኒኔ ሃይሳ ባዞ ቢታን ኦꬂዳ ጊታ ማላታኔ ታ ቦንቾዛ ቤኢዲ ታስ ኣዛዜቶንታ ኢጺዳይታፔኔ ታሙቶ ታና ፓጪዳ ኣሳታፔ ኦኒካ፥ ");
INSERT INTO gmve_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ታኒ ካሴ ኢስታ ኣዋታስ ኢማና ጋዳ ጫቂዳ ቢታዮ ኢስቲ ሙሌካ ጌሌቴና፤ ታና ካꬊዳይ ኦኒካ ኢዞ ሙሌራ ቤኤና። ");
INSERT INTO gmve_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ጊዶ ኣቲን ታ ኦሳንቻ ካሌቤስ ሃንኮይታፔ ዱማ ቆፋይ ኢዛስ ዲዛ ጊሻሲኔ ኢዚ ታና ኩሜꬃ ዎዚናፔ ካሊዳ ጊሻስ ኢዚ ቢዲ ካሴ ዩዪ ጼሊዳ ቢታዮ ታ ኢዛስ ኢማና፤ ኢዛ ዜሬꬃቲካ ሄ ቢታዮ ላታና። ");
INSERT INTO gmve_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","ኣማሌቄ ዴሬ ኣሳይኔ ካናኔ ዴሬ ኣሳይ ሾባ ጊዶን ዲዛ ጊሻስ ኢንቴ ዎንቶ ጉዬ ሲሚዲ ዞኦ ኣባ ባጋራ ኤፊዛ ኦጌዛራ ጌዴ ባዞ ሲሚ ቢቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","ጎዳይ ሙሴሲኔ ኣሮኔስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«ሃይቲ ኢታ ኣሳቲ ኣይዴ ጋካናስ ታ ቦላ ዙዙማኔ? ሃ ዙዙሜቲዛ ኢስራኤሌ ኣሳይ ታ ቦላ ዙዙሜቲሺን ታ ሲያዲስ። ");
INSERT INTO gmve_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","ኔ ኢስታስ፥ ‹ታኒ ታ ዴኦ ሱንꬃን ጫቃይስ፤ ታኒ ኢንቴ ሃሳይሺን ታ ሃይꬃን ሲዪዳ ማላ ኢንቴ ቦላ ኦꬃና፤ ታኒ ጎዳይ ሃይሳ ዮታዲስ። ");
INSERT INTO gmve_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ኢንቴ ታ ቦላ ዙዙሜቲዳ ጊሻስ ኢንቴ ጋርሳፌ ቆዴቲሺን ላይꬃይ ናምኡ ታሙኔ ኢዛፔ ቦላራ ጊዲዳይታ ኡባ ኣሃይ ሃይሳ ባዞ ቢታን ኩንዲ ኣታና። ");
INSERT INTO gmve_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ኢንቴ ሄ ዴሬዮ ጌሊዲ ዴኣና ማላ ካሴ ታ ኢንቴስ ጫቃዲስ፤ ጊዶ ኣቲን ዮፊኔ ና ካሌቤፔኔ ናዌ ና ኢያሶፔ ኣቲን ኢንቴፌ ኢሳዴይካ ሄ ቢታዮ ጌሌና። ");
INSERT INTO gmve_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","ዲኤቲዲ ኣታና ጌቴቲዳ ኢንቴ ናይታ ኢንቴ ካꬊዳ ቢታዮ ታ ጌልꬃና፤ ሄ ቢታዮ ታ ኢስታ ላቲሳና። ");
INSERT INTO gmve_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","ኢንቴ ኣሃይ ጊዲኮ ሃይሳ ሃ ባዞዛን ኩንዲ ኣታና። ");
INSERT INTO gmve_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","ኢንቴ ናይቲ ኢንቴ ኣማኖንታ ኢጺዳ ጋሶን ኢንቴፌ ዉርሴꬃን ሃይቂዛዴ ኣሃይ ባዞ ቢታን ኩንዲ ኣታና ጋካናስ 40 ላይꬅ ኩሜꬅ ጊታ ሜቶ ኤኪሼ ሃይሳ ሃ ባዞዛን ቶይላታና። ");
INSERT INTO gmve_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","ኢንቴ ሄ ቢታ ጾሞሲ ጼሊዳ 40 ጋላሳ ቆዳን ኢሲ ጋላሳዮ ኢሲ ላይꬅ፥ ሄሲካ ኦይዱ ታሙ ላይꬅ ኩሜꬅ ኢንቴ ኢንቴ ናጋራ ጊሻስ ዋዬታና፤ ታኒ ኢንቴ ቦላ ዴንዲዳይሳ ኢንቴ ሄሳን ኤራና። ");
INSERT INTO gmve_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","ታ ቦላ ዴንዲዳ ኢታ ኣሳታ ቦላ ታኒ ሃይሳ ኡባ ኦꬃና፤ ሃይሳ ባዞዛን ኡባቲካ ዉሪ ዉራና፤ ኡባቲካ ሃይቃና፤ ታኒ ጎዳይ ሃይሳ ዮታዲስ› ጋ ዮታ።» ");
INSERT INTO gmve_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","ሙሴይ ካናኔ ቢታዮ ጾሞሲ ጼላናስ ኪቲ ዬዲዳ ኣሳቲ ቢዲ ቢታዮ ቤዪ ሲሚዳፔ ጉዬ ሄ ቢታይ ጊሻስ ኢታ ዎሬ ኤሂዲ ዴሬዚ ባ ጋርሳን ዙዙሜታና ማላ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ሄ ኣሳቲ ጎዳ ሲንꬃን ቦሻን ሾጬቲ ሃይቂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ሄ ቢታዮ ቢዲ ጾሞሲ ጼሊዳ ኣሳታ ጊዶፌ ናዌ ና ኢያሶይኔ ዮፊኔ ና ካሌቤይ ጻላ ሼምፖራ ፓጻ ኣቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","ጎዳይ ጊዳይሳ ሙሴይ ኢስራኤሌ ኣሳስ ዮቲን ኣሳይ ጫሞ ዬሆ ዬኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","ዎንቴꬃ ጋላስ ዎንታ ማላዶራ ኢስቲ ዴንዲዲ ፑዴ ጌዜቲዛሶ ኬዛናስ ጊጌቲዲ፥ «ኑኒ ናጋራ ኦꬆይሳካ ዛሪ ኣኬኪዶስ፤ ሃኢ ጊዲኮ ኑኒ ካሴ ጾሲ ኑና ጌልꬃና ጊ ሂዶታ ኢሚዳ ዴሬዮ ባናስ ጊጌቲዶስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","ሙሴይ ጊዲኮ ኢስታስ፥ «ሂስቲን ኢንቴ ጎዳስ ሃኢካ ኣይስ ኣዛዜቴኬቲ? ኢንቴ ቆፒዳይሲ ኢንቴስ ሱሬና። ");
INSERT INTO gmve_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","ሄሳ ጊሻስ ኢንቴ ሄ ቦፒቴ፤ ጎዳይ ኢንቴናራ ጊዶንታ ጊሻስ ኢንቴ ሞርኬቲ ኢንቴና ጾናና። ");
INSERT INTO gmve_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","ኣማሌቄ ኣሳይኔ ካናኔ ኣሳይ ኢንቴናራ ሄን ኦሌታና፤ ጊዶ ኣቲን ኢንቴ ጎዳ ኣጊዳ ጊሻሲኔ ኢዚ ኢንቴናራ ባይንዳ ጊሻስ ኢንቴ ሄ ኦላን ሃይቃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ሙሴ ጊዲን ጫቆ ቃላ ታቦታዚ ካሴ ባ ዲዛ ሄራፔ ዴንዶንታ ዲሺን ኢስቲ ፑዴ ጌዜ ቢታዮ ኦላናስ ጻላቴꬃን ዴንዲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","ሄሳፌ ጉዬ ሄ ዴሬን ዲዛ ኣማሌቄ ኣሳይኔ ካናኔ ኣሳይ ኢስታ ቦላ ሜቶ ጋꬂዲ ጾኒዳ ሆርማ ጋካናስ ጎዲ ዬዲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«ኔኒ ኢስራኤሌ ኣሳስ፥ ‹ታ ኢንቴስ ኢማና ቆፒዳ ቢታዮ ኢንቴ ጌሊዳ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ጹጌቲዛ ያርሾስ ዎይኮ ኣዲና ጊሻስ ያርሼታና ያርሾስ ዎይኮ ኣሲ ባ ሎኦ ቆፋፔ ሺሺዛ ያርሾ ጊሻስ፥ ዎይኮ ሎሴ ባኣሌታ ዎዴ ሺቂዛ ያርሾታ ሚዛፔ ዎይኮ ዶርሳፌ ጎዳስ ኢንቴ ሺሻንዴታ፤ ሄሳ ሚሳቲዛ ያርሾይ ጎዳ ሳዊዛ ያርሾ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ሄሳ ጊሻስ ሄሳ ማላ ሺሺዛ ኣሲ ዉሪ ኢሲ ሊቲሮ ጊዳና ዛይቴን ኢሲ ኪሎ ጊዲዛ ሊቆ ꬊሌፌ ሙኑቄቲዳ ካꬃ ያርሾ ሺሻናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ቃሴ ጹጌቲዛ ያርሾስ ዎይኮ ሃራ ያርሾስ ኤሂዛ ኢሲ ኢሲ ዶርሳ ላቃራ ኢሲ ሊቲሮ ዎይኔ ኡሻ ያርሾ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","« ‹ꬋርሾ ያርሾስ ሺሺዛ ዎዴ ቃሴ ናምኡ ኪሎ ꬊሌ ኢሲ ሊቲሮኔ ሳይሶ ጊዲዛ ዎጋራ ዛይቴን ሙኑቂዲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ኡሻ ያርሾስ ኢሲ ሊቲሮኔ ሳይሶ ጊዲዛ ዎይኔ ኡሹ ሺሻ፤ ሄሲ ዉሪካ ሎኦ ጎዳ ሳዊዛዚኔ ኡፋይሲዛዝ ጊዳና፤ ");
INSERT INTO gmve_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","« ‹ኔኒ ኢሲ ሚርጎ ኣዲናስ፥ ዎይኮ ኢሲፌቴꬃ ያርሾስ፥ ዎይኮ ጹጌቲዛ ያርሾስ፥ ዎይኮ ሃራ ያርሾስ ሺሺዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ሄ ሚርጎዛራ ሄꬑ ኪሎ ጊዲዛ ሊቆ ꬊሌፌ ናምኡ ሊቲሮ ዛይቴን ሙኑቄቲዳ ካꬃ ያርሾ ሺሻ። ");
INSERT INTO gmve_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ሄሳꬆካ ኡሻ ያርሾስ ናምኡ ሊቲሮ ጊዲዛ ዎይኔ ኡሹ ሺሻ፤ ሄሲካ ጎዳ ኡፋይሲዛ፥ ሳዊዛዛኔ ጹጌቲዛ ያርሾ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","ሄሳ ጊሻስ ኢሲ ኢሲ ሚርጎ፥ ዎይኮ ኢሲ ኢሲ ꬋርሾ ዎይኮ ꬋርሾ ላቃ ዎይኮ ኮርቤ ላቃ ያርሾስ ሺሺዛ ዎዴ ኢሲፌ ሺቂዛ ካꬃ ያርሾይ ሄሳ። ");
INSERT INTO gmve_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","ኢሲ ሜሄፔ ቦላራ ሺቂዛ ዎዴ ኢዛራ ኢሲፌ ሺቂዛ ካꬃ ያርሾይ ሄሳ ማላ ጉጄቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","ዴሬን ዬሌቲዳ ኢስራኤሌ ኣሳፔ ኢሶይ ኢሶይ ጹጌቲዛ ያርሾኔ ሳዎይ ጎዳ ኡፋይሲዛ ያርሾ ሺሺዛ ዎዴ ሄሳꬆ ኦꬃናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","ሲንꬃፌ ያና ዬሌታን ኢንቴናራ ዲዛ ቤቴ ኣሲ ዎይኮ ኢንቴ ጋርሳን ዲዛ ሃራ ዴሬ ኣሲ ኦኒካ ጹጌቲዛ ያርሾ ዎይኮ ጎዳ ኡፋይሲዛ ካꬃ ያርሾ ጎዳስ ሺሻና ኮይኮ ኢዛዴይካ ኢንቴ ኦꬂዛይሳ ማላ ኦꬃናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","ኢንቴ ኡባቲካ ኢንቴ ጊዶን ዲዛ ኣሳ ዴሬ ኣሳቲካ ሃይሳፌ ያና ላይꬃታን ኡባታን ሃይታ ዎጋታ ኢሲ ማላ ናጋናስ ኢንቴስ ቤሴስ፤ ኢንቴኒኔ ኢስቲ ኡባቲ ጎዳ ሲንꬃን ኢሲኖ። ");
INSERT INTO gmve_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","ኢንቴሲኔ ኢንቴናራ ዲዛ ሃራ ዴሬ ኣሳ ኡባስ ዲዛ ዎጋይኔ ማራይ ኢሲኖ ጊዶ› ጋ ዮታ።» ");
INSERT INTO gmve_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«ኔኒ ኢስራኤሌ ኣሳስ፥ ‹ታ ኢንቴና ካሌꬂዛ ቢታዮ ኢንቴ ጌሊዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ሄ ቢታይን ካጺዛ ካꬅ ኡባ ሚዛ ዎዴ ሄ ካꬃፌ ጎዳስ ኢሞታ ኢሚቴ። ");
INSERT INTO gmve_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ሄሲካ ኮይሮ ꬊሌዛፔ ኡኬꬅ ኡኪዲ ባሌፔ ኢሜቲዳ ያርሾ ኦꬂዲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","ቡሮፔ ያና ዬሌታ ኡባን ኮይሮ ꬊሌዛፔ ኤኪዲ ጎዳስ ኢሞታ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","« ‹ጎዳይ ሙሴስ ኢሚዳ ኣዛዞታፔ ኢሳ ኢንቴ ኤሮንታ ሞሪዛ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ዎይኮ ሲንꬃፌ ያና ዬሌታቲ ሙሴ ባጋራ ኢሜቲዳ ኣዛዞዛ ፖሎንታ ኣጊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ሄሳ ማላ ባላይ ማባራይ ኤሮንታ ሃኒኮ ኢሲ ሚርጎ ኤሂዲ ጎዳ ሳዊዲ ኡፋይሲዛ ያርሾኔ ጹጌቲዛ ያርሾ ኢዛስ ሺሼቶ፤ ዎጋዚ ኣዛዚዛ ማላ ካꬃ ያርሾኔ ኡሻ ያርሾ ኢዛራ ኢሲ ቦላ ጋꬂ ሺሼቶ፤ ሄሳፌካ ቦላራ ኢሲ ዴይሻ ኦርጌ ናጋራ ያርሾስ ሺሼቶ። ");
INSERT INTO gmve_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","ቄሴዚ ኩሜꬃ ኢስራኤሌ ማባራ ናጋራ ዉርሶ፤ ኢስቲ ኤሮንታ ኦꬂዳ ናጋራ ጋሶን ጹጌቲዛ ያርሾኔ ካꬃ ያርሾ ሺሺዳ ጊሻስ ኢስታ ናጋራይ ኣቶ ጌቴታና። ");
INSERT INTO gmve_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ኡባይካ ኤሮንታ ዲሼ ናጋራ ኦꬂዳ ጊሻስ ኢስራኤሌ ኣሳ ዎይኮ ኢስታ ጊዶን ዲዛ ሃራ ዴሬ ኣሳ ናጋራይ ኣቶ ጌቴታና። ");
INSERT INTO gmve_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","« ‹ኢሲ ኣሲ ኤሮንታ ናጋራ ኦꬂኮ ኢሲ ላይꬃ ዴይሻ ላቃ ባ ናጋራ ጊሻስ ያርሾስ ሺሾ። ");
INSERT INTO gmve_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ኤሮንታ ዲሼ ናጋራ ኦꬂዳዴስ ኢዛ ናጋራይ ኣቶ ጌቴታና ማላ ቄሴዚ ጎዳ ሲንꬃን ኢዛ ናጋራ ዉርሶ፤ ኢዛ ናጋራይካ ኣቶ ጌቴታና። ");
INSERT INTO gmve_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ኢስራኤሌ ዴሬን ዬሌቲዳ ኢስራኤሌ ኣሲ ዎይኮ ኢስታ ጊዶን ዲዛ ኣሳ ዴሬ ኣሲ ኤሮንታ ዲሼ ናጋራ ኦꬂዳ ጊዲኮ ኡባስ ዲዛ ዎጋይ ኢሲ ማላ። ");
INSERT INTO gmve_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","« ‹ጊዶ ኣቲን ኢስራኤሌ ዴሬ ኣስ ዎይኮ ሃራ ዴሬፔ ቤቲ ኢስታ ጊዶ ዪዳ ኣሲ ዎዚናይ ኤሪሺን ናጋራ ኦꬂዳ ኣሲ ዉሪካ ጎዳ ሌቂዳ ጊሻስ ዴሬዛፔ ሻኬቲ ꬋዮ። ");
INSERT INTO gmve_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","ኢዛዴይ ጎዳ ሌቂዳ ጊሻሲኔ ኢዛ ኣዛዞታ ኤሪሼ ሞሪዳ ጊሻስ ሙሌራ ꬋዮ፤ ኢዛ ጎሜይ ኢዛራ ቦ› ጋ ዮታ።» ");
INSERT INTO gmve_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ኢስራኤሌ ኣሳይ ባዞን ዲዛ ዎዴ ኢሲ ጋላስ ኢሳዴይ ሳምባታ ጋላስ ሚꬅ ሚጺሼ ኦይኬቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","ሄ ኢዛ ኦይኪዳ ኣሳቲ ኢዛ ኦይኪ ኤኪዲ ሙሴኮ፥ ኣሮኔኮኔ ኩሜꬃ ማባራይ ዲዛሶ ኤፊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ኢስቲካ ኢዛ ዎስታናኮኔ ኤሬቶንታ ኢጺን ጉꬃ ዎዴስ ቃሼቲሻና ማላ ዛቤስ ኢሜቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","ሄሳፌ ጉዬ ጎዳይ ሙሴስ፥ «ሄ ኣዴዚ ሃይቆ! ኩሜꬃ ማባራይ ዲዛሶፔ ኢዛ ካሬ ኬሲዲ ሹቻራ ጫዲ ዎꬎ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","ሄሳ ጊሻስ ኩሜꬃ ማባራይ ባንቲ ዲዛ ጉታፔ ሃራሶ ኤፊዲ ጎዳይ ኣዛዚዳ ማላ ሹቻራ ኩራኪ ዎꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«ኔኒ ኢስራኤሌ ኣሳስ፥ ‹ኢንቴ ማይኢዛ ማይኦስ ማጫራ ኬሲቴ፤ ኢሲ ኢሲ ማጫራይ ሳሎ ሚሳቲዛ ጺላታፔ ጊዶ፤ ሄሳካ ኢንቴ ቡሮፔ ያና ዬሌታ ኡባንካ ኣጎፍቴ። ");
INSERT INTO gmve_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ሄ ማጫራታ ኢንቴ ቤኢዛ ዎዴ ኡባን ታ ኣዛዞታ ሃሳኢ ኤኪዲ ፖሊቴ፤ ሂስቲኮ ኢንቴ ኢንቴ ኣይፌን ቤኢዳይሳኔ ኢንቴ ዎዚናን ኣሞቲዳይሳ ካሊዲ ታፔ ሻኬቴኬታ። ");
INSERT INTO gmve_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ማይኦታ ጼራን ዲዛ ማጫራታ ኢንቴ ቤኢዛ ዎዴ ታ ኣዛዞታ ኡባ ፖላና ማላ ኢስቲ ኢንቴና ቆፍሳና፤ ኢንቴካ ሙሌራ ታስ ሃሬቲዳይታ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","ታኒ ኢንቴ ጎዳ፤ ኢንቴስ ጎዳ ጊዳናስ ኢንቴና ጊብጼፔ ኬሲዳ ጾሳይ ታና› ጋ ዮታ።» ");
INSERT INTO gmve_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","ሌዌ ዛርኬ ቃኣቴ ባጋፌ ዪጺሃሬ ና ቆሬይ፥ ኦሮቤሌ ዛርኬ ኤልያቤ ናይቲ ዳታኔይኔ ኣብራሜይ ቃሴካ ፓሌቴ ና ኦናይ ሜቶ ሜꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ኢስራኤሌ ኣሳ ጋርሳን ኤሬቲዳ ዴሬዛ ካሌꬃናስ ዶሬቲዳ 250 ኣሳታ ባንታ ቦላ ኤኪዲ ሙሴ ቦላ ዴንዲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ኢስቲካ ሙሴ ሲንꬃኒኔ ኣሮኔ ሲንꬃን ሺቂዲ ኢስታስ፥ «ኢንቴ ሙሌካ ዎጋፔ ኣꬊዴታ! ሃይሲ ዴሬዚ ኡባይ ጎዳስ ዱማቲዳ ዴሬ፤ ጎዳይካ ኢስታራ ዴስ፤ ሂስቲን ኢንቴ ጎዳ ዴራ ቦላ ኣዛስ ኢንቴና ꬎቁ ꬎቁ ሂስቴቲ?» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ሙሴይካ ሄሳ ሲዪዳ ማላ ጉፋኒዲ ዎሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ቆሬሲኔ ኢዛ ካሊዛይታስ፥ «ዎንቶ ማላዶ ጎዳይ ኢዛስ ዱማቲዳይቲ ኦናንታኮ ኢዚ ሻኪ ኑና ቤሳና፤ ሄሲካ ባስ ጊዲዛይታኔ ባ ዶሪዳይታ ባስ ኦꬃና ማላ ባኮ ሺሺ ኤካና። ");
INSERT INTO gmve_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","ዎንቶ ማላዶ ኔኒኔ ኔናራ ኢሲፌ ኦꬂዛይቲ ዉሪካ ኢንቴ ኢዛን ኤጻኔ ጩዋሲዛ ጺናዛ ኤኪ ዪቴ። ");
INSERT INTO gmve_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ኢስታ ቦላ ቦንቆ ታማኔ ኤጻኔ ዎꬂዲ ጌዴ ያርሾ ኢዛ ቦላ ያርሺዛሶ ሺሺቴ፤ ሄሳፌ ጉዬ ጎዳይ ኑፔ ኦና ባስ ዶሪዳኮ ኑ ቤያና፤ ኢንቴ ሌዌ ናይቲ ኬሂ ሞሪዴታ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","ቃሴካ ሙሴይ ቆሬስ፥ «ኢንቴ ሌዌቲ ዎዚናን ዎꬂ ሲዪቴ! ");
INSERT INTO gmve_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ኢንቴ ጌዴ ኢዛኮ ሺቂዲ ጋይቶቴꬃ ዱንካኔ ጊዶን ኢንቴ ኢንቴ ኦሶ ፖላና ማላኔ ኢንቴ ኢስራኤሌ ኣሳ ሲንꬃን ኤቂዲ ኢስታስ ኦꬃና ማላ ኢስራኤሌ ጎዳይ ኢንቴና ሃንኮ ኢስራኤሌ ኣሳ ጋርሳፌ ሻኪ ዱማሲዳይሳ ኢንቴ ጮ ሜላ ላፋ ኣይፌን ጼሌቲ! ");
INSERT INTO gmve_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ኢዚ ኢንቴናኔ ሃንኮ ሌዌ ዛርኬታ ባኮ ሺሺዴስ፤ ኢንቴ ጊዲኮ ቄሴቴꬃ ኤካናስ ቃቃቴታ፤ ");
INSERT INTO gmve_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","ሄሳ ጊሻስ ኔኒኔ ኔናራ ዙፔቲዛይቲ ዉሪካ ጎዳ ቦላ ዴንዲዴታ፤ ኢንቴ ኣሮኔ ቦላ ዙዙሜታናስ ኢዚ ኦኔ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","ሄሳፌ ጉዬ ሙሴይ ኤልያቤ ናይታ ዳታኔኔ ኣብራሜ ጼይጊሲዴስ፤ ኢስቲ ጊዲኮ፥ «ኑ ቦኮ! ");
INSERT INTO gmve_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","ኑኒ ባዞን ሃይቃና ማላ ኔ ኑና ኤሲኔ ማꬂ ኩሚዳ ቢታፌ ኬሲዳይሲ ኔስ ጉጺን ሃኢ ቃሴ ኑ ቦላ ሃላቃ ጊዳናስ ኮያይ? ");
INSERT INTO gmve_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ኔኒ ኑና ሎኦ ካꬅ ኢሚዛ ጎሻ ጋዴ ኤሆንታይሲ ዎይኮ ኣታኪልቴራ ዲዛሶ ላቲሶንታይሲ ኤሬቲዳዛ፤ ሃኢ ቃሴ ኔ ኑና ባሌꬃናስ ኮያሳ፤ ሄሳ ጊሻስ ሃኢ ኑ ኔኮ ቦኮ!» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","ሙሴይካ ዳሮ ሃንቄቲዲ ጎዳስ፥ «ሃይቲ ኣሳቲ ኔስ ሺሺዛ ያርሾዛ ኔ ኤኮፋ፤ ታኒ ጊዲኮ ኢስታፌ ኢሳዴካ ቆሃቤኬ፤ ሃራይ ኣቶሺን ኢሲ ሃሬካ ኢስታፌ ኤካቤኬ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","ሙሴይ ቆሬስ፥ «ኔኒኔ ኔናራ ኢሲፌ ዲዛ 250 ኣሳይ ኣሮኔይ ዲዛሶ ጋይቶቴꬃ ዱንካኔኮ ዪቴ። ");
INSERT INTO gmve_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","ኢንቴፌ ኢሳዴይ ኢሳዴይ ኢንቴ ኢንቴ ጺና ኦይኪ ዪቴ፤ ጺናዛ ጊዶን ኤጻኔ ጉጂቴ፤ 250 ጺናታራ ኢንቴ ኢንቴ ኤጻኔዛ ጎዳ ሲንꬃን ሺሻንዴታ፤ ኔኒኔ ኣሮኔይካ ኢንቴ ኢንቴ ኤጻኔ ኤጻኔ ሺሺቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","ሄሳ ጊሻስ ኢስቲ ዉሪካ ኢሶይ ኢሶይ ባ ጺናን ጺናን ኤጻኔ ጉጂ ኤኪዲ ጋይቶቴꬃ ዱንካኔ ፔንጌን ሙሴራኔ ኣሮኔራ ኢሲፌ ኤቂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","ሄሳፌ ጉዬ ቆሬይ ኢስታራ ኤቄቲዲ ባናራ ዙፔቲዛይታ ጋይቶቴꬃ ዱንካኔዛ ፔንጌ ሺሺዳ ዎዴ ጎዳ ቦንቾይ ኩሜꬃ ዴራስ ቆንጪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","ጎዳይካ ሙሴሲኔ ኣሮኔስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«ሃይሳ ዴራ ኣቻፌ ሃኪ ኤቂቴ፤ ታኒ ኢስታ ኢሲቶ ኡባ ꬋይሳና።» ");
INSERT INTO gmve_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","ሙሴይኔ ኣሮኔይ ሲንꬃ ጉꬅ ጉፋኒዲ፥ «ሼምፖራ ዲዛ ሜꬌታ ኡባስ ጎዳ ጊዲዳ ጾሶ! ኢሲ ኣሲ ኦꬂዳ ናጋራ ጌዶን ኔኒ ኩሜꬃ ዴራ ꬋይሳና ጋይ?» ጊዲ ጾሳኮ ዋሲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","24","ጎዳይ ሙሴስ፥ «ቆሬ ዱንካናፔ፥ ዳታኔ ዱንካናፔኔ ኣብራሜ ዱንካናፔ ሃኪ ኤቃና ማላ ኔኒ ዴራስ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","ሄሳፌ ጉዬ ሙሴይ ኢስራኤሌ ኣሳ ካሌꬂዛይታ ካሌꬂ ኤኪዲ ዳታኔኮኔ ኣብራሜኮ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","ዴሬዛስካ፥ «ኢንቴ ሃይታ ማካላ ኣሳታ ዱንካኔታፔ ሃኪ ኤቂቴ፤ ኢስታ ሚሽ ጊዲዳዝ ኣይኮካ ቦቾፍቴ፤ ሂስቶንታ ኣጊኮ ኢስታ ናጋራ ጋሶን ኢንቴ ዉሪካ ኢስታራ ኢሲፌ ፒቴቲ ꬋያና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","ሄሳ ጊሻስ ዴሬዚ ቆሬ ዱንካኔዛፔ፤ ዳታኔ ዱንካኔዛፔኔ ኣብራሜ ዱንካኔዛፔ ሃኪ ኤቂዴስ። ዳታኔይኔ ኣብራሜይካ ባ ማቼታራኔ ባ ናይታራ ባ ዱንካኔዛፔ ካሬ ኬዚዲ ባ ፔንጌን ፔንጌን ኤቂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","ሄ ዎዴ ሙሴይ ዴራስ፥ «ሃይሳ ሃ ኦሶዛ ኦꬃናስ ጎዳይ ታና ኪቲዳይሳኔ ታኒካ ሃይሳ ኦꬂዛይ ታ ሼኔን ጊዶንታይሳ ኢንቴ ሃይሳን ኤራና። ");
INSERT INTO gmve_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ሃይቲ ሃ ኣሳቲ ኣሲ ሃይቂዛ ማላ ሃይቂዛ ጊዲኮ ጎዳይ ታና ኪቲቤና። ");
INSERT INTO gmve_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ጊዶ ኣቲን ኣሲ ሃይꬃን ሲዪ ኤሮንታ ኦራꬃ ሚሽ ጎዳይ ኢስታ ቦላ ኦꬂን ኢስቲ ሼምፖራ ፓጻ ዲሼ ዱጌ ሃይቂዳይቲ ዲዛሶ ዎꬋና ማላ ቢታያ ዶዬታዳ ኢስታኔ ኢስታስ ዲዛዝ ኡባ ሚቲኮ ሃይቲ ኣሳቲ ጎዳራ ኤቄቲዳይሳ ኢንቴ ሄ ዎዴ ኤራና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","ሙሴይ ሄሳ ዮቲዳ ማላ ዳታኔይኔ ኣብሮኔይ ኤቂ ዲዛ ቢታያ ዶዬታዳ፥ ");
INSERT INTO gmve_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ኢስታኔ ኢስታ ሶ ኣሳ፥ ቆሬ፥ ኢዛራ ዙፔቲዛ ኣሳኔ ኢስታስ ዲዛዝ ኡባ ሚታዱስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ሂስቲን ኢስቲ ሼምፖራ ፓጻ ዲሼ ባስ ዲዛ ሚሻራ ዱጌ ዱፎን ጌሊዳ፤ ቢታያ ኢስታ ካማዳ ዴራ ጊዶፌ ꬋይሳዱስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","ሄ ሄራን ዲዛ ኢስራኤሌ ኣሳይ ሄ ኣሳ ዋሶ ሲዪዲ፥ «ሃይሲ ቢታይ ኑናካ ሚቶንታ ኣጌና!» ጊ ዋሲሼ ባቃቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","ቃሴካ ጎዳይ ሳሎፔ ታማ ዬዲዲ ኤጻኔ ጩዋሲዛ 250 ኣሳ ጹጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","ሄሳፌ ጉዬ ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","«ኣሮኔ ና ኤልኤዜሬይ ጻርቂማላፔ ቆጼቲዳ ጺናቲ ዱማ ጊዲዳ ጊሻስ ጹጌቲዛ ኣሳታ ማታፔ ኢስታ ጊዶን ዲዛ ቦንቆ ታማዛ ሃሆሶ ኤፊ ቆላና ማላ ኢዛስ ዮታ፤ ");
INSERT INTO gmve_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ሄ ጺናቲ ጎዳስ ያርሾ ያርሺዛሶዛ ሺቂዳ ዎዴ ጌዪዳ፤ ሄሳ ጊሻስ ባ ናጋራ ጋሶን ሃይቂዳ ኣሳታ ጺና ኤካዳ ሌኢሳ ቆጻ፤ ሂስታዳ ያርሾ ያርሺዛሶዛስ ካማ ኦꬃ፤ ሄይቲካ ኢስራኤሌ ኣሳይ ናጌታና ማላ ኢስታስ ሴራ ማላታ ጊዳና።» ");
INSERT INTO gmve_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","ሄሳ ጊሻስ ኤልኤዜሬይ ጺናታ ኤኪዲ ያርሾ ያርሺዛሶዛስ ካማ ጊዳና ማላ ሌኤን ቆጺ ኬሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ሄሲ ሄ ሃኖዚ ኦኒካ ኣሮኔ ዜሬꬅ ጊዶንታ ኣሲ ጎዳስ ኤጻኔ ጩዋሳናስ ያርሾ ያርሺዛሶዛ ሺቆንታ ማላ ኢስራኤሌ ኣሳይ ኡባይ ናጌታና ማላ ቆፍሲዛ ማላታ ጊዳና፤ ሄሳꬆ ጊዶንታ ኣጊኮ ሄሳ ማላ ኦꬂዛ ኣሲ ኡባይካ ቆሬ ማላኔ ኢዛራ ዙፔቲዳይታ ማላ ꬋያና፤ ሃይሲ ዉሪካ ካሴ ጎዳይ ሙሴ ባጋራ ኢሚዳ ኣዛዞዛ ማላ ፖሌቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","ዎንቴꬃ ጋላስ ኩሜꬃ ኢስራኤሌ ማባራይ፥ «ጎዳ ዴራ ኢንቴ ዎꬊዴታ» ጊዲ ሙሴ ቦላኔ ኣሮኔ ቦላ ጉጉሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ዴሬይ ሙሴራኔ ኣሮኔራ ኤቄታናስ ኢሲ ቦላ ሺቄቲዳ ዎዴ ጋይቶቴꬃ ዱንካኔዛ ሻራይ ካሚ ኦይኪን ጎዳ ቦንቾይ ኢዛን ቆንጪዳይሳ ጉዬ ሲሚ ቤኢዶስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","ሙሴይኔ ኣሮኔይ ዪዲ ጋይቶቴꬃ ዱንካናስ ሲንꬃ ባጋራ ኤቂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","«ሃይታ ሃ ኣሳታፔ ፖቂ ኤቂቴ፤ ታኒ ኢስታ ኢሲቶ ዲፒ ሂስታ ꬋይሳና!» ናምኣቲካ ዱጌ ቢታ ቦላ ጉፋኒዳ። ");
INSERT INTO gmve_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ሙሴይ ኣሮኔስ፥ «ኔኒ ኔ ጺና ኤካዳ ያርሾ ያርሺዛሶዛፔ ቦንቆ ታማ ኢዛ ቦላ ጉጃ፤ ሄ ታማ ቦላ ኤጻኔ ዎꬃ፤ ሄሳፌ ጉዬ ኤሶን ዴራኮ ባዳ ኣሳ ናጋራ ዉርሳ! ሄኮ ጾሳ ሃንቆይ ቆንጪዳ ጊሻስ ዴሬዛ ጊዶን ቦሻይ ዶሚዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","ሄሳ ጊሻስ ኣሮኔይ ሙሴይ ኣዛዚዳ ማላ ባ ጺና ኤኪዲ ሺቄቲ ዲዛ ኣሳ ጊዶ ኤሶን ቢዴስ፤ ቦሻይ ዴራ ጊዶን ዶሚዳይሳ ቤኢዲ ኤጻኔዛ ቦንቆ ታማ ቦላ ዎꬂዲ ኣሳ ናጋራ ዉርሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ኣሮኔይ ፓጻ ዲዛ ኣሳሲኔ ሃይቂዳ ኣሳስ ጊዶን ኤቂዲ ዴራ ቦላ ዪዛ ቦሻ ቴቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","ሄ ዎዴ ሃይቂዳ ኣሳ ቆዳይ ቆሬራ ኢሲፌ ጌላቴꬃን ሃይቂዳይቲ ኣቲን 14,700። ");
INSERT INTO gmve_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ቦሻዚ ኤቂን ኣሮኔይ ጋይቶቴꬃ ዱንካኔዛ ፔንጌን ዲዛ ሙሴኮ ሲሚ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«ኢስራኤሌ ኣሳፔ ዛርኬፌ ዛርኬፌ ኮራፒኔይ ኢሲ ኢሲ ጉፌ ሺሺዲ ታማኔ ናምኡ ጉፌ ኢማና ማላ ኦይቻ፤ ሂስታዳ ኢሳ ኢሳ ሱንꬅ ሄ ጉፌታ ቦላ ጻፋ። ");
INSERT INTO gmve_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","ሌዌ ዛርኬታፔ ሺቂዳ ጉፌታ ቦላ ኣሮኔ ሱንꬅ ጻፋ፤ ኢሲ ኢሲ ዛርኬ ካሌꬂዛዴስ ኢሲ ጉፌይ ሺቆ። ");
INSERT INTO gmve_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","ሄይታካ ጌዴ ጋይቶቴꬃ ዱንካኔዛን ኤፋዳ ታ ኔና ሃሳይሲዛሶን ታቦታዛፔ ሲንꬃ ባጋራ ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ሄሳፌ ጉዬ ታኒ ዶሪዛዴ ጉፌይ ፑርጪዲ ጪሊላና፤ ሄሳን ኢስራኤሌ ኣሳይ ኡባ ዎዴ ኔ ቦላ ዙዙሞንታ ማላ ታ ዲጋና።» ");
INSERT INTO gmve_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","ሄሳ ጊሻስ ሙሴይ ሄሳ ኢስራኤሌ ኣሳስ ዮቲዴስ፤ ዴሬዛ ካሊዛይቲ ኢሶይ ኢሶይ ባ ጉፌ ጉፌ ኤኪዲ ኢዛስ ኢሚዴስ፤ ኢሲ ዛርኬ ጊሻስ ኢሲ ኢሲ ጉፌ ጊዲሺን ኡባይ ኢሲ ቦላ 12 ጉፌይ ሺቂዴስ፤ ሄ ሺቂዳ ጉፌታ ጊዶን ኣሮኔ ጉፌይ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","ሙሴይ ጉፌታ ኡባ ኤኪዲ ጋይቶቴꬃ ዱንካኔዛ ጊዶን ጎዳ ጫቆ ቃላ ታቦታዛ ሲንꬃን ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","ዎንቴꬃ ጋላስ ሙሴይ ጌዴ ጋይቶቴꬃ ዱንካኔዛን ጌሊሺን ሌዌ ቆሞ ሱንꬃን ሺቂዳ ኣሮኔ ጉፌያ ጪሊሊዳሮ ቤኢዴስ፤ ቃሴካ ጪያዳ ካጺዳ ኦቾሎኔ ኣይፌ ኣይፊዳሮ ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","ሙሴይካ ጉፌታ ኡባካ ኤኪ ኤፊዲ ኢስራኤሌ ኣሳ ቤሲዴስ፤ ኣሳይካ ሄሳ ኡባ ቤኢዲ ኢሲ ኢሲ ኮራፒኔቲ ባ ጉፌ ጉፌ ኤኪዳ። ");
INSERT INTO gmve_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","ጎዳይ ሙሴስ፥ «ኣሮኔ ጉፌዛ ዛራዳ ጫቆ ቃላ ታቦታፔ ሲንꬃ ባጋራ ዎꬃ፤ ማካሊዛ ኢስራኤሌ ኣሳይ ታ ቦላ ዙዙሚዛይሳ ኣጎንታ ኢጺኮ ኢስቲ ሃይቃናይሳ ቤሲዛ ማላታ ጊዲ ኡቶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","ሙሴይካ ጎዳይ ኢዛ ኣዛዚዳ ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ኢስራኤሌ ኣሳይ ሙሴስ፥ «ሃይሳ ማላ ጊዲኮ ኑኒ ዉሪካ ዉራናስ ዶስ! ");
INSERT INTO gmve_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","ጋይቶቴꬃ ዱንካኔዛኮ ሺቂዳ ኣሲ ኡባይ ሃይቂዛ ጊዲኮ ኑኒካ ዉሪ ሃይቃናስ ዶስ ጉሴ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","ጎዳይ ኣሮኔስ፥ «ጋይቶቴꬃ ዱንካኔዛ ጊዶን ኦሴቲዛ ሞሮ ኡባ ጊሻስ ኔኒኔ ኔ ናይቲ፥ ሌዌ ቆሞቲ ኣላፌቴꬅ ኤኪዴታ፤ ቄሴቴꬃ ኦሶን ፖሌቲዛ ሞሮ ጊሻስ ጊዲኮ ሄሳ ኣላፌቴꬅ ኤካናይ ኔናኔ ኔ ናይታ ጻላ። ");
INSERT INTO gmve_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","ኔኒኔ ኔ ናይቲ ጋይቶቴꬃ ዱንካኔዛን ኦꬂዛ ዎዴ ኢንቴና ኦሶን ማዳናስ ሌዌ ቆሞ ጊዲዳ ኔ ባጋታ ኤካ። ");
INSERT INTO gmve_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","ኢስቲ ኔ ኣላፌቴꬃ ጋርሳን ዲሼ ጋይቶቴꬃ ዱንካኔዛ ኦሶ ኦꬄቶ፤ ጊዶ ኣቲን ጌሻሶዛን ጎኤቲዛ ሚሻታኮ ያርሾ ያርሺዛሶ ሺቆፔቶ፤ ሄ ሺቂዛ ጊዲኮ ኔኒኔ ኢስቲካ ኢሲ ቦላ ሃይቃና። ");
INSERT INTO gmve_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","ኢስቲ ኡባ ዎዴ ኢንቴናራ ኢሲፌ ኦሶኔ ጋይቶቴꬃ ዱንካኔዛ ጊዶን ኢስታስ ኢሜቲዳ ኦሶ ኡባ ባ ኣላፌቴꬃን ፖላናስ ቤሴስ፤ ጊዶ ኣቲን ሌዌ ቆሞ ጊዶንታ ኣይ ኣሲካ ኦꬃናስ ኢንቴኮ ሺቆፖ። ");
INSERT INTO gmve_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","«ታ ሃንቆይ ቃሴካ ኢስራኤሌ ኣሳ ቦላ ቆንጮንታ ማላ ጌሻሶዛኒኔ ያርሾ ያርሺዛሶዛን ኦሴቲዛ ኦሶዛ ኣላፌቴꬅ ፖላናይቲ ኢንቴናኔ ኢንቴ ናይታ ጻላ። ");
INSERT INTO gmve_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ኢንቴ ባጋ ጊዲዳ ሌዌ ዛርኬታ ኢስራኤሌ ኣሳ ጋርሳፌ ኢንቴስ ዶሪዳ ኢሞታ ሂስታ ኢሚዳይ ታና፤ ኢስቲካ ጋይቶቴꬃ ዱንካኔዛ ጊዶን ባስ ኢሜቲዳ ኦሶ ኦꬃና ማላ ታስ ዱማቲዳይታ። ");
INSERT INTO gmve_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ጊዶ ኣቲን ያርሾ ያርሺዛሶዛኒኔ ማጋላሻፔ ጉዬ ባጋራ ኡባፌ ዱማቲዳ ጊዶ ቆልኣን ኦሴቲዛ ቄሴቴꬃ ኦሶይ ኔሲኔ ኔ ናይታስ ጻላ ቤሴስ፤ ቄሴቴꬃ ኦሶዛካ ታ ኢንቴስ ኢሞታ ሂስታ ኢማዲስ፤ ቄሴ ጊዶንታ ኣይ ኣሲካ ሄ ሺቂኮ ሃይቃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","ሃይሳፌ ጉዬ ጎዳይ ኣሮኔስ፥ «ጹጌቶንታ ጮ ሜላ ታስ ሺቂዛ ያርሾ ኡባ ታ ኔስ ኢሚዳይሳ ዩሻ ቆፓ፤ ሄሲካ ኔሲኔ ኔ ዛሬ ኡባስ ጊሻ ጊዳና ማላ ታኒ ኢማዲስ። ");
INSERT INTO gmve_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ታስ ዳሮ ዱማቲ ሺቂዛ ኢሞታታፔ ታማን ጹጌቶንታ ያርሾይ ኔሲኔ ኔ ናይታስ ጊሻ ጊዳና፤ ሄሲካ ካꬃ ያርሾ ኡባይ፥ ናጋራ ጊሻስ ዎይኮ ቆሆ ጊሻስ ሺቂዛ ያርሾ ኡባይ ኔሲኔ ኔ ናይታስ ጊሻ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","ኢንቴ ሄሳ ጌሻሶዛን ዲሼ ሚቴ፤ ሄሳካ ኣቱማሳይ ኡባይ ሞ፤ ኢዚካ ኬሂ ዱማቲዳዛ። ");
INSERT INTO gmve_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","«ቃሴካ ኢስራኤሌ ኣሳይ ታ ሲንꬃን ያኔ ሃ ቃሴꬂ ያርሺዛ ያርሾይ ኡባይ ኢንቴስ ጊዶ፤ ሃይታንታ ታኒ ኔስ፥ ኔ ማጫ ናይታስ፥ ኔ ኣቱማ ናይታሲኔ ሲንꬃፌ ያና ዬሌታ ኡባስ ኤቂ ዳና ማላ ኢንቴስ ጊሻ ሂስታ ኢማዲስ፤ ኔሶ ኣሳፔ ጌሽ ጊዲዳይ ኦኒካ ማናስ ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","«ኢስራኤሌ ኣሳይ ታስ ኢሚዛ ኦራꬅ ጋኪዛ ካꬃ ጼራፔ ዎጋራ ዛይቴ፥ ዎይኔ ኡሺኔ ካꬃ ቆሞ ኡባፌ ጼራ ታ ኢንቴስ ኢማዲስ። ");
INSERT INTO gmve_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ኢስቲ ባ ጋዴፔ ታስ ጎዳስ ኢሚዛ ካꬃ ጼራይ ኢንቴሳ፤ ሄሳ ኢንቴሶ ኣሳን ጌሽ ጊዲዳ ኣሲ ኦኒካ ማናስ ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","«ኢስራኤሌ ኣሳፔ ታስ ኢሜቲዳ ሚሺ ኡባይ ኢንቴሳ። ");
INSERT INTO gmve_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","ኢስራኤሌ ኣሳይ ታስ ሺሺዛ ሜሄፔ ዎይኮ ኣሳፔ ባይራ ጊዲ ዬሌቲዳይ ኢንቴሳ፤ ጊዶ ኣቲን ኣሳፔ ባይራ ጊዲ ዬሌቲዳይሳ ጊዲኮ ኢስታ ሚሻን ዎዛና ቤሴስ፤ ሄሳꬆካ ጌሽ ጊዶንታ ሜሄታፔ ኮይሮ ዬሌቲዳይሳ ሚሻን ዎዛናስ ዳንዳዬታ። ");
INSERT INTO gmve_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","ኢሲ ኣጊና ናይታ ዎዛናስ ጌሻሶዛን ኤሬቲዳ ሜዛኔ ሊኬን ኢቻሹ ሳቂሌ ቢራ ዎዞ ሚሽ ጪጊዲ ዎዛናስ ዳንዳዬቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","«ሚዛፔ ዎይኮ ዶርሳፌ ዎይኮ ዴይሻፌ ባይራ ጊዲ ዬሌቲዳይሳ ዎዞፍቴ፤ ሄይቲ ሙሌካ ጌሽ ጊዲዳ ጊሻስ ታስ ያርሾ ጊዲ ሺቃናስ ቤሴስ፤ ኢስታ ሱꬃ ያርሾ ያርሺዛሶዛ ቦላ ኣራጪቴ፤ ሃንዳዛካ ታና ሎኦ ሳዎ ሳዋና ማላ ታማን ጹጊቴ። ");
INSERT INTO gmve_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","ያኔ ሃ ቃሴꬂ ሺሺዛ ያርሾ ጊዲዲ ሺቂዛ ኣንጋሶ ማላኔ ኡሻቻ ሚሴ ማላ ኢስታ ኣሾዚ ኔስ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ኢስራኤሌ ኣሳይ ታስ ሺሺዛ ዱማ ዱማ ኢሞታታ ዉርሳካ ታ ኢንቴስ፥ ኢንቴ ኣቱማ ናይታሲኔ ኢንቴ ማጫ ናይታስ ቡሮ ሲንꬃፌ ያና ዎዴታን ኡባን ዎጋ ጊዲዲ ኢንቴስ ጊሻ ጊዳና ማላ ታ ኢንቴስ ኢማዲስ፤ ሄሲካ ታኒ ኢንቴናራኔ ኢንቴ ዜሬꬃታራ ጫቄቲዛ ላሜቶንታ ማጺኔ ጫቆ ማላ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","ጎዳይ ኣሮኔስ፥ «ኔኒ ኔ ዜሬꬃስ ላቲሳናስ ላታ ጋዴይ ኔስ ኢሜቴና፤ ኢስታ ጊዶን ኔና ጋኪዛ ጊሻይ ኣይኮይካ ዴና፤ ኔና ጋኪዛ ላታይ ታና ጾሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","ጎዳይ፥ «ኢስራኤሌ ኣሳይ ታስ ኤሂዛ ኣስራታይ ዉሪ ሌዌ ዛርኬታስ ጊሻ ጊዶ ጋዳ ታ ኢማዲስ፤ ሄሲካ ኢስቲ ጋይቶቴꬃ ዱንካኔ ጊዶን ኦꬂዛ ኦሶዛ ዳሞዛ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ሃንኮ ኢስራኤሌ ኣሳይ ጊዲኮ ባ ቦላ ሃይቆ ቂጻቴ ጋꬆንታ ማላ ናምኣንꬆ ጌዴ ጋይቶቴꬃ ዱንካኔዛኮ ሺቃናስ ቤሴና። ");
INSERT INTO gmve_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","ሃይሳፌ ጉዬ ጋይቶቴꬃ ዱንካኔዛ ጊዶን ኣላፌቴꬅ ኤኪ ኦꬃናስ ቤሲዛይ ሌዌ ዛርኬታ ጻላ ጊዳና፤ ሄን ኦሴቲዛ ሞሮስካ ኢስቲ ኦይሼታና፤ ሄሲካ ኢስታስ ና ና ጋካናስ ላሜቶንታ ዎጋ ጊዳና፤ ሌዌታስ ጺንጾይ ኢስራኤሌ ዴሬን ዴና። ");
INSERT INTO gmve_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ኢስራኤሌ ኣሳይ ታስ ዱማ ያርሾ ኤሂዛ ኣስራታ ታኒ ኢስታስ ጊሻ ሂስታ ኢማዲስ፤ ሄሳ ጊሻስ ኢስታስ ኢስራኤሌ ኣሳ ጊዶን ጺንጾይ ዶንታ ማላ ዮታዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«ኔኒ ሌዌታስ፥ ‹ጎዳይ ኢንቴስ ጊሻ ሂስቲ ኢሚዛ ኣስራታ ኢንቴ ኢስራኤሌ ኣሳ ኩሼፔ ኤኪሼ ኢንቴካ ኢንቴ ባጋራ ሄ ኢንቴ ኤኪዳይሳፌ ኣስራታ ኬሲዲ ጎዳስ ዱማ ያርሾ ሂስቲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","ሄሲ ሄ ዱማ ያርሾዚ ኢሲ ጎሻንቻይ ካꬃ ጼራ ዎይኮ ዎይኔ ኡሹ ኣስራታ ኢሚዛ ማላ ጊዲ ኢንቴስ ቆዴታና። ");
INSERT INTO gmve_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ሄሳ ማላን ኢንቴካ ኢስራኤሌ ኣሳፔ ኤኪዛ ኣስራታ ኡባፌ ጎዳስ ዱማ ያርሾ ሂስቲ ሺሺቴ፤ ኢንቴ ጎዳስ ሺሺዛ ያርሾዛ ቄሴ ኣሮኔስ ኢሚቴ። ");
INSERT INTO gmve_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","ኢንቴ ሃ ኤኪዛ ሚሽ ኡባፌ ዶሬቲዳይሳኔ ሎኦ ጊዲዳይሳ ጎዳስ ጊሻ ሂስቲ ኢሚቴ። ");
INSERT INTO gmve_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","« ‹ጎሻንቻይ ካꬃ ኣይፌፔኔ ዎይኔ ኡሻፌ ዶሬቲዳይሳ ታስ ኢሚዲ ኣቲዳይሳ ባስ ኤኪዛ ማላ ኢንቴካ ዶሬቲዳይሳ ታስ ኢሚዲ ኣቲዳይሳ ኢንቴስ ኤኪቴ። ");
INSERT INTO gmve_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","ሄሲካ ኢንቴ ጋይቶቴꬃ ዱንካኔ ጊዶን ኦꬂዛ ኦሶዛስ ዋጋ ጊዲዳ ጊሻስ ኣቲዳይሳ ኢንቴ ኢንቴሶ ኣሳራ ኣዋንካ ዲዲ ማናስ ዳንዳዬታ። ");
INSERT INTO gmve_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","ዶሬቲዳዝ ኢንቴ ጎዳስ ሺሺዳፔ ጉዬ ኣቲዳይሳ ኢንቴ ሚኮ ኢንቴስ ናጋራ ጊዴና፤ ጊዶ ኣቲን ዶሬቲዳይሳ ኢዛፔ ሻኮንታ ሚዲ ዱማ ጊዲዳ ኢስራኤሌ ኣሳ ኢሞታ ቱኒሶንታ ማላ ናጌቲቴ፤ ቱኒሲዛ ጊዲኮ ኢንቴ ሃይቃና› ጋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","ጎዳይ ሙሴሲኔ ኣሮኔስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«ሃይሲ ታ ኣዛዚዳይሲ ዎጋስ ዲዛ ማራ፤ ኢስራኤሌ ኣሳይ ኢዚ ሞርጌ ቦላ ቃምባራይ ዎꬊ ኤሮንታ ቦሬይ ባይንዳ ኢሲ ዞኦ ሚዛ ኡስ ኢስራኤሌ ኣሳይ ኤሃና ማላ ኣሳስ ዮታ። ");
INSERT INTO gmve_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ሄ ኡሳዮ ቄሴ ኤልኤዜሬስ ኢሚቴ፤ ሄ ኡሳዮ ኣሲ ዲዛሶፔ ጌዴ ካሬ ኬሲኮ ሄን ኢዛ ሲንꬃን ሹኬቱ። ");
INSERT INTO gmve_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ቄሴ ኤልኤዜሬይ ኢዚ ሱꬃፌ ጉꬃራ ኤኪዲ ባ ቢራꬌ ጼራን ላፑንቶ ጌዴ ጋይቶቴꬃ ዱንካኔዛስ ሲንꬃ ባጋራ ፒስቶ። ");
INSERT INTO gmve_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ሄ ኡሳይ ጋልባይ፥ ኣሾይ፥ ሱꬂኔ ቃንꬃ ኣሾይ ዉሪ ቄሴዛ ሲንꬃን ጹጌቶ። ");
INSERT INTO gmve_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ቄሴዚ ሊባኖሴ ዚጋ፥ ሂሶጴኔ ዞኦ ቃጪና ኤኪዲ ኡሳያ ጹጌቲዛ ታማዛን ዬጎ። ");
INSERT INTO gmve_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ሄሳፌ ጉዬ ባ ማይኦ ሜጮ፤ ባ ቦላካ ሃꬄን ሜጬቲዲ ካሴ ባ ዲዛሶ ሲሞ፤ ጊዶ ኣቲን ኦማርስ ጋካናስ ዎጋይ ጊዛ ማላ ቱና ጊዲ ጋምኦ። ");
INSERT INTO gmve_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","ሄ ኡሳዮ ጹጊዳዴይካ ባ ማይኦ ሜጮ፤ ባ ቦላካ ሃꬃን ሜጬቶ፤ ኢዚካ ኦማርስ ጋካናስ ቱና ጊዲ ጋምኦ። ");
INSERT INTO gmve_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","«ሄሳፌ ጉዬ ጌሽ ጊዲዳ ሃራ ኣሲ ሄ ቢዲንꬃ ሺሺ ኤፊዲ ኣሳይ ዲዛሶፔ ጌዴ ኬሲዲ ጌሻሶሆን ዎꬆ፤ ሄንካ ኢስራኤሌ ኣሳይ ሜጬቲዲ ጌያናስ ጎኢዛ ሃꬅ ጊጊሳናሳ፤ ሃይሲ ዎጋዚ ኦሴቲዛይ ኣሳ ናጋራ ዉርሳናሳ። ");
INSERT INTO gmve_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","ቢዲንꬃ ሺሺዳዴይ ባ ማይኦ ሜጮ፤ ጊዶ ኣቲን ኢዚ ኦማርሳ ዎዴ ጋካናስ ቱና ጊዲ ጋምኦ፤ ሃይሲ ዎጋዚ ኢስራኤሌ ኣሳሲኔ ቤቴ ዪዲ ኢስታ ጊዶን ዲዛ ኣሳስ ቡሮፔ ያና ዬሌታ ኡባስ ላሜቶንታ ዎጋ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","«ሃይቂዳ ኣሳ ኣሃ ቦቺዳ ኣሲ ላፑን ጋላስ ጋካናስ ቱና ጊዲ ጋምኦ። ");
INSERT INTO gmve_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ሄꬓንꬆ ጋላሳኒኔ ላፑንꬃ ጋላሳን ጌያናስ ጊጌቲ ዲዛ ሃꬃን ባና ጌሾ፤ ሄሳፌ ጉዬ ኢዚ ጌሽ ጊዳና፤ ሄꬓንꬆ ጋላሲኔ ላፑንꬃ ጋላስ ባና ጌሾንታ ኣጊኮ ኢዚ ጌያናስ ዳንዳዬና። ");
INSERT INTO gmve_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ጌሻናስ ዲዛ ሃꬂ ኢዛ ቦላ ጉኮንታ ኣጊዳ ጊሻስ ኣሃ ቦቺዲ ባና ጌሾንታ ኣሲ ቱኒዳ ማላ ጋምኦ፤ ሄሳ ማላ ኣሲ ጋይቶቴꬃ ዱንካኔዛ ቱኒሴስ፤ ሄሳ ጊሻስ ኢዚ ኢስራኤሌ ኣሳ ጊዶፌ ሻኬቲ ኪቾ። ");
INSERT INTO gmve_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","«ኢሳዴይ ጋይቶቴꬃ ዱንካኔዛ ጊዶን ሃይቂኮ ፖሌታና ዎጋይ ሃይሳ። ኢዚ ሃይቂዳ ዎዴ ሄ ዎዴ ሄን ጋይቶቴꬃ ዱንካኔዛ ጊዶን ዲዛዴይ ዎይኮ ሄ ጌዴ ጋይቶቴꬃ ዱንካኔዛን ጌሊዛዴይ ላፑን ጋላስ ጋካናስ ቱና ጊዲ ጋምኦ። ");
INSERT INTO gmve_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ሄ ጋይቶቴꬃ ዱንካኔዛ ጊዶን ቱቺ ባይንዳ ዲዛ ኦቶይ ዉሪካ ጻሮይካ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","ኣሲ ዎꬊዳ ኣሳ ኣሃ ጊዲን ዎይኮ ሃርጊ ሃይቂዳ ኣሳ ኣሃ ጊዲን ካሬን ኩንዲ ዲዛ ኣሃ ቦቺዳዴይ ዎይኮ ኣሳ ሜቄꬅ ቦቺዳዴይ ላፑን ጋላስ ጋካናስ ቱና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","«ቱኒዳ ኣስ ናጋራፔ ጌሻናስ ጹጌቲዛ ኡሳይ ቢዲንꬃፌ ጉꬃራ ኦቶን ዬጌቶ፤ ጺሊ ኡቲዳ ፑልቶ ሃꬂ ኢዛ ቦላ ጉጄቶ። ");
INSERT INTO gmve_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ካሊዲ ጌሽ ጊዲዳ ሃራ ኣሲ ሂሶጴ ሚꬃ ሃጋ ኤኪዲ ሃꬃን ጌልꬂ ጌልꬂ ኬሲዲ ጋይቶቴꬃ ዱንካኔዛ ቦላ፥ ኢዛ ጊዶን ዲዛ ሚሻታ ቦላኔ ኣሳ ቦላ ኣራጮ፤ ሄሳፌ ጉዬ ኣሳ ሜቄꬅ ዎይኮ ኣሃ ዱፎ ቦቺዳዴ ቦላ ሃꬄ ኣራጮ። ");
INSERT INTO gmve_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ሄꬓንꬃ ጋላሲኔ ላፑንꬃ ጋላስ ጌዪዳዴይ ሃንኮ ጌዮንታዴ ቦላ ሃꬄ ኣራጮ፤ ላፑንꬃ ጋላስ ኢዛ ጌሾ፤ ሄ ጌይዛዴይካ ባ ማይኦ ሜጪዳፔኔ ባ ቦላ ሜጬቲዳፔ ጉዬ ኣርሼይ ዉሊሺን ኢዛዴይ ጌሽ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","«ቱኒዳዴይኔ ባና ጌሾንታዴይ ጌሾ ሃꬃ ባ ቦላ ጉሶንታ ኣጊዳ ጊሻስ ኢዚ ቱኒዳ ማላ ጋምኦ፤ ሄሳ ማላ ኣሲ ጌሻሶዛ ቱኒሲዛ ጊሻስ ማባራ ጊዶፌ ሻኬቲ ኪቾ። ");
INSERT INTO gmve_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ሃይሳ ሃ ዎጋ ቡሮፔ ያና ዬሌታስ ኢንቴ ናጋናስ ቤሴስ፤ ጌሾስ ጎኢዛ ሃꬃ ባ ቦላ ኣራጪዛ ኣሲ ባ ማይኦዛካ ሜጫናስ ቤሴስ፤ ሄ ሃꬃ ቦቺዳዴይ ኦማርስ ጋካናስ ቱና ጊዲ ጋምኦ። ");
INSERT INTO gmve_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","ጌዮንታ ኣሲ ቦቺዳ ሚሺ ኡባይ ቱና ጊዶ፤ ሄ ቱና ሚሻ ቦቺዳ ኣሲካ ኦማርስ ጋካናስ ቱና ጊዶ።» ");
INSERT INTO gmve_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ኮይሮ ኣጊናን ኢስራኤሌ ኣሳይ ኩሜꬅ ጺኔ ባዞን ቃዴሴ ጌቴቲዛሶን ዱንካኒ ኡቲዴስ፤ ማራማ ሃይቂን ሄን ሞጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ኣሳይ ዱንካኒ ኡቲዳሶሆን ሃꬂ ባይንዳ ጊሻስ ሙሴ ቦላኔ ኣሮኔ ቦላ ዴንዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ዴሬዚ፥ «ኑኒ ካሴ ጋይቶቴꬃ ዱንካኔ ሲንꬃን ሃይቂዳ ኢስራኤሌ ኣሳ ማላ ኢስታꬆ ኑኒካ ሃይቂዳኮ ኑስ ሎኦ ጊዳናሺን፤ ");
INSERT INTO gmve_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ኢንቴ ጎዳ ማባራ ሃይሳ ሃ ባዞ ቢታ ኤሂዳይ ኑኒኔ ኑ ሜሄይ ሃይሳን ዉራና ማላ ኦꬃናሴ? ");
INSERT INTO gmve_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ኢንቴ ኑና ጊብጼፔ ኬሲዲ ሃይሳ ኣይኮይ ሞኮንታ ኢታ ባዞ ኑና ኣዛስ ኤሂዴቲ? ሃይሳን ካꬂ፥ ባላሴይ፥ ዎይኔ ኣይፌይኔ ኦሮማኔይ ዴና፤ ሃራይ ኣቶሺን ጋንጺ ኤኪዛ ሃꬂካ ዴና!» ጊዲ ሙሴራ ኦዬቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","ሙሴይኔ ኣሮኔይ ኣሳፔ ሻኬቲዲ ጌዴ ጋይቶቴꬃ ዱንካኔ ፔንጌ ቢዳ፤ ኢስቲ ዱጌ ቢታን ጉፋኒ ዲሺን ጎዳ ቦንቾይ ኢስታስ ቆንጪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«ጫቆ ቃላ ታቦታ ሲንꬃን ዲዛ ጉፌዛ ኤኪዳ ኔኒኔ ኣሮኔይ ኩሜꬃ ማባራ ኢሲ ቦላ ሺሺቴ፤ ኔኒ ሄን ኩሜꬃ ዴራ ሲንꬃን ዲዛ ዛላዚ ሃꬄ ኢማና ማላ ዮታ፤ ኔኒ ሄሳꬆ ኦꬃዳ ዛላዛፔ ኢስታስ ሃꬄ ኬሳ፤ ሂስቲኮ ኢስቲኔ ኢስታ ሜሄይ ሃꬅ ኡዪዲ ኣላና።» ");
INSERT INTO gmve_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","ሙሴይ ጎዳይ ኢዛ ኣዛዚዳ ማላ ቢዲ ጋይቶቴꬃ ዱንካኔዛፔ ባ ጉፌዛ ኤኪ ዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","ኢዚኔ ኣሮኔይ ኩሜꬃ ማባራ ዛላዛ ሲንꬃን ሺሺዳፔ ጉዬ ሙሴይ ዴሬዛ፥ «ኢንቴኖ ማካላንቻቶ! ሃይሳ ሃ ዛላዛፔ ኑ ኢንቴስ ሃꬄ ኬሳኔ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","ሄሳፌ ጉዬ ሙሴይ ባ ጉፌዛን ዛላዛ ናምኣ ዛሪ ሾጪዴስ፤ ዎልቃማ ሃꬂ ዛላፌ ፑልቲዴስ፤ ዴሬዚኔ ሜሄይ ሃꬃ ኡዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","ጊዶ ኣቲን ጎዳይ ሙሴ ቦላኔ ኣሮኔ ቦላ፥ «ኢንቴ ኢስራኤሌ ኣሳ ሲንꬃን ታ ዱማቴꬃ ማላ ታና ቦንቻናስ ኣማኔቲቤኬታ፤ ሄሳ ጊሻስ ታ ኢንቴና ላቲሳና ጋ ጫቂዳ ዴሬዛ ሃይሳ ዴራ ካሌꬂዲ ጌሌኬታ» ጊ ሃንቄቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ኢስራኤሌ ኣሳይ ጎዳራ ኦዬቲዳሶይኔ ኢዚ ባ ዱማቴꬃ ቆንጪሲዳሶይ ማሪባ ጌቴቲዳ ጊሻስ ሃꬃይካ ማሪባ ሃꬅ ጌቴቲ ሱሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","ሙሴይ ኤዶሜ ካዎስ ኪታ ጋꬃና ማላ ቃስታኔ ኣስ ቃዴሴፔ ዬዲዴስ፤ «ኔ ኢሻ ኢስራኤሌይ፥ ‹ኑ ቦላ ጋኪዳ ሜቶዛ ኡባ ኔኒ ሲያዳሳ፤ ");
INSERT INTO gmve_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ቤኒ ኑ ኣዋቲ ዋኒ ዱጌ ጊብጼ ዎꬊዳኮኔ ኑኒካ ጊብጼን ዳሮ ላይꬃታ ዋኒ ዋኒ ዲዳኮ ኔ ኤራሳ፤ ጊብጼ ኣሳይ ካሴ ኑ ኣዋታ ጊዲን ኑናካ ዳሮ ዋዪሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ኑኒካ ኢዚ ኑና ማዳና ማላ ጎዳኮ ዋሲዶስ፤ ኢዚካ ኑ ዋሶዛ ሲዪዲ ጊብጼፔ ኑና ኬሳናስ ባ ኪታንቻ ኑስ ኪቲዴስ፤ ሄኮ ኑኒ ሃኢ ኔስ ꬋሳን ዲዛ ቃዴሴን ዶስ። ");
INSERT INTO gmve_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","ሄሳ ጊሻስ ኑኒ ኔ ቢታራ ኣꬊ ባና ማላ ኑስ ኤሮ ጋርኪ! ኑና ጊዲን ኑ ሜሄይካ ኦጌፔ ካሬ ኬዞኮ፤ ካꬃ ጊዶ ጊዲን ዎይኮ ዎይኔ ሚꬃ ጊዶ ኑ ጌሎኮ፤ ኔ ሃꬃ ኦላፌካ ኡዮኮ፤ ኔ ዴሬፔ ኣꬋና ጋካናስ ኦጌፔ ካሬ ኬዞኮ› ጌስ» ጊ ኪቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ኤዶሜ ኣሳይ ጊዲኮ፥ «ኢንቴ ኑ ዴሬራ ኣꬊ ባና ማላ ኮዮኮ፤ ኢንቴ ኑ ዴሬ ጌላናስ ፓጪኮ ኑ ኢንቴ ቦላ ዎራጃና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ኢስራኤሌ ኣሳይካ፥ «ኑኒ ዋና ኦጌዛፔ ኬዞኮ፤ ኑና ጊዲን ዎይኮ ኑ ሜሄይ ኢንቴ ሃꬃፌ ኡዪኮ ኑ ኢንቴስ ኢዛ ዋጋ ቃንጻና፤ ኑ ዋና ኮይዛይ ኢንቴ ዴሬዛራ ኣꬊ ባናሳ» ጊዲ ኢስታስ ማልꬄ ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","ኤዶሜ ኣሳይ ጊዲኮ፥ «ሄሲ ሃኔና! ኑ ኢንቴና ኣꬂ ዬዶኮ!» ጊዲ ሚኖ ኦላንቻታ ኤኪዲ ኢስራኤሌ ኣሳ ኦላናስ ኬዚዳ። ");
INSERT INTO gmve_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ኤዶሜ ዴሬ ኣሳይ ባ ቢታራ ኣꬂ ዬዶንታይሳ ኤሪዲ ኢስራኤሌ ኣሳይ ባ ቢዛ ኦጌዛ ላሚዲ ሃራሶራ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ኩሜꬃ ኢስራኤሌ ማባራይ ቃዴሴፔ ዴንዲ ሆሬ ዙማኮ ጋኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ሄ ዙማዚ ኤዶሜ ꬋሳን ዴስ፤ ጎዳይ ሄን ሙሴሲኔ ኣሮኔስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«ታኒ ኢስራኤሌ ኣሳስ ኢማና ጋዳ ካሴ ጫቂዳ ዴሬዮ ኣሮኔይ ጌሌና፤ ኢንቴ ዉሪካ ማሪባ ሃꬃ ኣቻን ታ ኣዛዞዛ ቦላ ማካሊዳ ጊሻስ ኣሮኔይ ሃይቃና። ");
INSERT INTO gmve_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","ኣሮኔኔ ኢዛ ናዛ ኤልኤዜሬ ኔናራ ኤካዳ ፑዴ ሆሬ ዙማ ቦላ ኬዛ። ");
INSERT INTO gmve_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ኣሮኔይ ቄሴቴꬃስ ማይኢዳ ማይኦዛ ቃራ ኤካዳ ኤልኤዜሬ ማይዛ፤ ኣሮኔይ ሄን ሃይቃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","ሙሴይካ ጎዳይ ኢዛስ ጊዳይሳ ኡባካ ኦꬂዴስ፤ ኩሜꬃ ማባራይ ኢስታ ጼሊሺን ኢስቲ ፑዴ ሆሬ ዙማ ቦላ ኬዚዳ። ");
INSERT INTO gmve_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","ሙሴይካ ኣሮኔ ቄሴቴꬃ ማይኦዛ ቃሪ ኤኪዲ ኤልኤዜሬ ማይዚዴስ፤ ኣሮኔይ ሄን ዙማ ሁኤን ሃይቂዴስ፤ ሙሴይኔ ኤልኤዜሬይ ዙማ ቦላፌ ዱጌ ሲሚ ዎꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","ኣሮኔይ ሃይቂዳይሳ ኩሜꬃ ዴሬዚ ሲዪዲ 30 ጋላስ ጋካናስ ኢዛስ ሚሼቲዲ ዬኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","ኢዛስ ዱሳሶይ ኔጌቤ ጊዲዳ ካናኔ ዴሬ ካዎ ኣራዴይ ኢስራኤሌ ኣሳይ ኣታራሜ ባጋራ ዪዛይሳ ሲዪዲ ኢስታ ቦላ ኦላ ዴንꬂዲ ኢስታፌ ኣማርዳይታ ዲኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","ሄ ዎዴ ኢስራኤሌ ኣሳይ፥ «ኑኒ ሃይሳ ዴሬዛ ጾናና ማላ ኔ ኑና ማዲኮ ኢስታ ጊዲን ዎይኮ ኢስታ ካታማታ ናምኣንꬆ ዴንዶንታ ማላ ኦꬂዲ ኑ ኢስታ ሙሌራ ዲፒ ሂስታና» ጊዲ ጎዳስ ኣዲኒዳ። ");
INSERT INTO gmve_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","ጎዳይ ኢስታ ዎሳ ሲዪዲ ማዲዳ ጊሻስ ኢስቲ ካናኔ ኣሳ ጾኒ ኦይኪዳ፤ ሄሳ ጊሻስ ኢስራኤሌ ኣሳይ ኢስታኔ ኢስታ ካታማ ሙሌራ ዲፒ ሂስቲ ꬋይሲዳ፤ ኢስቲ ዉሪ ዉሪዳይሳ ኤራናስ ሄሳ ሄ ጋዴዛ፥ «ሆርማ» ጊ ሱንꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ኢስራኤሌ ኣሳይ ኤዶሜ ዴሬ ዩዪ ኣꬊዲ ባናስ ቆፒዳ ሆሬ ዙማፔ ዴንዲዲ ጌዴ ዞኦ ኣባኮ ኤፊዛ ኦጌዛራ ቢዳ፤ ጊዶ ኣቲን ኢስቲ ቡሮ ኦጌን ዲሺን ዴሬዛፔ ዳንዳያይ ዉሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ጎዳ ቦላኔ ሙሴ ቦላ ኢታ ቃላ ኬሲዲ፥ «ሃꬂኔ ካꬂ ባይንዳሶ ሃይሳ ባዞ ቢታን ኑ ሃይቃና ማላ ኑና ጊብጼፔ ኣይስ ኬሲዴቲ? ሃይሲ ሃ ኢታ ካꬃይ ኑና ሳሌꬂዴስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","ሄሳፌ ጉዬ ጎዳይ ኢታ ማርዜራ ዲዛ ሾሽ ዴሬዛ ጊዶ ዬዲዴስ፤ ሄ ሾሻይ ዱኪን ኢስራኤሌ ኣሳፔ ዳሮይ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ዴሬዚካ ሙሴኮ ቢዲ፥ «ጎዳ ቦላኔ ኔ ቦላ ኑ ኢታ ቃላ ሃሳይዳ ጊሻስ ኑኒ ቆሂዶስ፤ ሃኢካ ሃይቲ ዱኪዛ ሾሻቲ ኑፔ ኪቻና ማላ ኔኒ ኑስ ጎዳ ዎሳርኪ!» ጊዳ፤ ሙሴይካ ዴራስ ዎሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","ሄ ዎዴ ጎዳይ ሙሴስ፥ «ኔኒ ጻርቂማላ ሾሽ ቆጻ ኬሳዳ ቱሳ ማላ ኣዱሳ ሚꬃ ቦላ ካቃ፤ ሾሺ ዱኪዳ ኣሲ ዉሪካ ሄሳ ቤኢዲ ኣታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","ሙሴይካ ጻርቂማላፔ ሾሽ ሜꬊዲ ቱሳ ማላ ኣዱሳ ሚꬃ ቦላ ቃጲዴስ፤ ሾሺ ሳጺዳ ኣሲ ኡባይ ሄ ጻርቂማላ ሾሻ ꬎቁ ጊ ጼሊዳይ ጼሊዳይ ፓጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ኢስራኤሌ ኣሳይ ባ ዲዛሶፔ ዴንዲ ቢዲ ኦቦቴን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ሄፔ ዴንዲዲ ሞኣቤፔ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ኢዬ-ኣባሪሜ ባዞን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ሄፔ ዴንዲ ቢዲ ዛራዴ ሾባን ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ሄፔካ ዴንዲ ቢዲ ኣሞሬታ ዴሬራ ካንꬂ ቢዛ ባዞ ኣርኖኔ ሻፋፔ ሄ ፒንꬃን ዲዛ ቢታን ዱንካኒ ኡቲዳ፤ ኣርኖኔ ሻፋዚ ሞኣቤ ዴሬሲኔ ኣሞሬ ዴሬዛስ ጊዶ ꬋሳን ዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","ሄሳ ጋሶን ጎዳይ ካሌꬂን ኦሌቲዳ ኦላ ጊሻስ ዮቲዛ ታሪኬ ማጻፋዛን፥ «ሱፋ ሄራኒኔ ሾባታን ዲዛ ዋሄቤ ካታማን ኣርኖኔን ሃꬂ ባይንዳ ሻፋን፥ ");
INSERT INTO gmve_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ቢዲ ኤሬ ካታማኔ ሞኣቤ ꬋስ ጋካናስ ካንꬂ ቢዛ ዞዜታ» ጌቴቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ሄፔ ዴንዲዲ ቢኤሬ ቢዳ፤ ሄሲካ ጎዳይ ሙሴስ፥ «ዴራ ኢሲ ቦላ ሺሻ፤ ታኒ ኢስታስ ሃꬅ ኢማና» ጊዲ ዮቲዳ ሃꬃ ኦላ። ");
INSERT INTO gmve_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","ሄ ዎዴ ኢስራኤሌ ኣሳይ ሃይሳ፥ «ሃይሶ ፑልቶዞ ፑልታ፤ ኢንቴካ ኢዛስ ዬጺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ካዎቲ ባ ካዎቴꬃ ጉፌን ቦኪዳ፤ ዳናቲ ባ ጉፌን ዚቂሲዳ፤ ሃꬃ ኦላስ ዬጺቴ» ጊዳ። ሄ ባዞዛፔ ዴንዲዲ ጌዴ ማታኔ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ማታኔፔካ ጌዴ ናሃልኤሌራ ካንꬂዲ ጌዴ ባሞቴ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ባሞቴፔ ዴንዲዲ ኣሞኔ ዴሬን ዲዛ ሾባ ቢዳ፤ ሄ ሾባይካ ፒዝጋ ዙማፔ ዳንኤ ባጋራ ባዞዛ ጊናን ዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ሄሳፌ ጉዬ ኢስራኤሌ ኣሳይ ኣሞሬ ዴሬ ካዎ ሲሆኔስ ቃስታኔ ዬዲዲ፥ ");
INSERT INTO gmve_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«ኑኒ ኔ ቢታራ ኣꬊ ባና ማላ ኑና ኣꬃ ዬዳርኪ! ኑኒኔ ኑ ሜሄይ ኦጌፔ ካሬ ኬዞኮ፤ ጌዴ ኔ ካꬃ ጊዶ ጊዲን ዎይኮ ኔ ዎይኔ ሚꬃ ጋርስ ኑ ጌሎኮ፤ ኔ ሃꬃ ኦላፌ ኤኪ ኡዮኮ፤ ኑኒ ኔ ዴሬራ ኣꬊ ባና ጋካናስ ኦጌፔ ሼርኢ ጎኮ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","ሲሆኔይ ጊዲኮ ኢስራኤሌ ኣሳይ ኢዛ ቢታራ ኣꬊ ባና ማላ ኮዪቤና፤ ሃራፔካ ኢዚ ባስ ዲዛ ኦላ ኣሳ ሺሺ ኤኪዲ ያሃጼ ባዞ ዎꬊዴስ፤ ኢስራኤሌ ኣሳራካ ኦላ ኦይኬቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ኢስራኤሌ ኣሳይ ጊዲኮ ኢስታ ጾኒዴስ፤ ኣርኖኔ ሻፋፔ ዶሚዲ ኣሞኔ ዴሬ ꬋስ ጊዲዳ ያቦቄ ሻፋ ጋካናስ ዲዛሶዛ ኦይኪዳ፤ ጊዶ ኣቲን ኣሞኔ ኣሳይ ባ ዛዋ ሚኒ ናጊዛ ጊሻስ ሄ ጌሊቤቴና። ");
INSERT INTO gmve_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ኢስራኤሌ ኣሳይ ሂስቲዲ ኣሞሬ ዴሬ ቢታን ዲዛ ካታማታ ሃሴቦኔኔ ሄ ሄራን ዲዛ ጉꬃ ካታማታካ ኦይኪዲ ዱንካኒ ኡቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","ሃሴቦኔይ ኣሞሬታ ካዎ ሲሆኔይ ካዎቲዳ ካታማ፤ ኢዚካ ካሴ ሞኣቤን ካዎቲዳ ካዎዛራ ኦሌቲዲ ኣርኖኔ ሻፋ ጋካናስ ዲዛ ቢታ ኡባ ኢስታፌ ዎꬂ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","ጊንጾ ጊግሲዲ ዬጺዛይቲ ሄሳ ጊሻስ ዬጺሼ «ሃሴቦኔኮ ሃ ዪቴ! ሃና ካታማያ ጊምቤቱ! ሲሆኔ ካታማያ ኦሶ ዶሜቱ። ");
INSERT INTO gmve_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","ሃሴቦኔፔ ታማይ ኬዚዴስ፤ ላጮይካ ሲሆኔ ካታማፔ ኬዚዴስ፤ ሞኣቤ ዴሬን ኤሬ ጌቴቲዛሶዛ ꬋይሲዴስ፤ ኣርኖኔ ቦላ ጌዜ ቢታን ዲዛ ሃላቃታካ ዲፒ ሂስቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ሃኔ ሞኣቤ ኔስ ኣዬ ኣና! ኢንቴኖ ካሞሼስ ጎይኒዛይቶ! ኢንቴ ዲፒ ጊ ꬋያና፤ ኢንቴ ኣቱማ ናይታ ቤቴስ፥ ኢንቴ ማጫ ናይታካ ዲኤቴꬃስ ኣሞሬ ካዎ ሲሆኔስ ኣꬂ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","ሄሳ ጊሻስ ኢስታ ዜሬꬃይ ሙሌራ ꬋይዴስ፤ ሃሴቦኔፔ ቢዲ ዲቦኔ ጋካናስ ኖፋፔ ቢዲ ሜዴባ ጋካናስ ዲዛ ኡባ ፒስኪ ሂስቲ ላሊዶስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","ሄሳ ጊሻስ ኢስራኤሌ ኣሳይ ኣሞሬ ዴሬን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","ሙሴይካ ኢያዜሬ ቢዲ ጾሞሳና ኣስ ዬዲዴስ፤ ኢስራኤሌ ኣሳይካ ሄ ካታማዮኔ ኢዚ ሄራን ዲዛ ቄሪ ካታማታ ኦሊ ኦይኪዳ፤ ካሴ ሄን ዲዛ ኣሞሬ ኣሳታ ጎዲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ሄሳፌ ጉዬ ኢስራኤሌ ኣሳይ ጉዬ ሲሚዲ ጌዴ ባሳኔ ኤፊዛ ኦጌዛራ ቢዳ፤ ባሳኔ ካዎ ኣጌይ ኤዲራኤን ኢስታራ ኦላ ኦይኬታናስ ባ ኦላንቻታ ኡባ ኤኪ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","ጎዳይ ሙሴስ፥ «ሃይሳ ኣዴዛስ ባቦፋ! ኢዛ ኣሳኔ ኢዛ ዴሬዛ ታ ኔስ ኣꬃ ኢማና፤ ካሴ ሃሴቦኔን ዴኢሼ ኣሞሬታ ሃሪዛ ካዎ ሲሆኔ ቦላ ኔ ኦꬆይሳꬆ ሃይሳ ቦላካ ኦꬃ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","ሄሳ ጊሻስ ኢስራኤሌ ኣሳይ ኣጌ፥ ኢዛ ናይታኔ ኢዛ ዴራ ኡባ ዲፒ ሂስቲዲ ቢታ ባስ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ሄሳፌ ጉዬ ኢስራኤሌ ኣሳይ ዴንዲዲ ኢያርኮ ጊናራ ዮርዳኖሴ ሻፋፔ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ሞኣቤ ዴምባን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ኢስራኤሌ ኣሳይ ኣሞሬታ ቦላ ኦꬂዳይሳ ኡባ ጺፖራ ና ባላቄይ ሲዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ኢስራኤሌ ኣሳይ ኬሂ ዳሮ ጊዲዳ ጊሻስ ሞኣቤ ኣሳይ ኬሂፔ ባቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","ሞኣቤቲ ሚዲያሜ ጪማታስ፥ «ቦራይ ማታ ሚ ꬋይሲዛ ማላ ሃ ማቴ ኣሳይ ኑ ዩሾን ዲዛ ኡባ ዲፒ ሂስቲ ꬋይሳና» ጊዳ። ሄ ዎዴ ሞኣቤ ካዎ ጺፖራ ና ባላቄይ፥ ");
INSERT INTO gmve_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ኣማዋ ቢታን ኤፊራጺሴ ሻፋ ማታን ፓቶሬ ካታማን ዲዛ ቢኦሬ ና ባላሜኮ ቃስታኔ ኪቲዲ፥ «ቤያ! ጊብጼ ቢታፌ ኬዚዳ ኢሲ ዴሬይ ቢታ ማይኢዴስ፤ ሄ ዴሬዚ ኑ ማታን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ኢስቲ ኑፔ ኬሂ ዎልቃማ ጊዲዳ ጊሻስ ዎዜ ኔና ሁ! ሃ ያዳ ታስ ኢስታ ቃንጋርኪ! ኔ ቃንጊዛ ጊዲኮ ታ ኢስታ ጾናዳ ቢታፌ ኬሳናኮ ኦኔ ኤሪዛይ? ኣይስ ጊኮ ኔኒ ኣንጂዳዴይ ኣንጄቲዛይሳ፥ ኔ ቃንጊዳዴይ ቃንጌቲዛይሳ ታ ኤራይስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","ሂስቲን ሞኣቤ ጪማቲኔ ሚዲያሜ ጪማቲ ቃንጊሳናስ ኤኪ ቢዳ ሚሻ ባላሜስ ኢሚዲ ባላቄ ኪታ ዮቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","ባላሜይ ኢስታስ፥ «ኢንቴ ሃች ሃን ኣቂኮ ጎዳይ ታስ ዮቲዳይሳ ኡባ ታ ኢንቴስ ዎንቶ ማላዶ ዮታና» ጊዴስ፤ ሂስቲን ሞኣቤ ጪማቲ ባላሜ ማታን ኣቂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ጾሲ ባላሜኮ ዪዲ፥ «ሃይቲ ኔናራ ዲዛ ኣሳቲ ኣይ ኣሴ?» ጊዲ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","ባላሜይካ ጾሳስ፥ «ሞኣቤ ካዎ ጺፖራ ና ባላቄይ፥ ");
INSERT INTO gmve_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‹ጊብጼፔ ኬዚዳ ዴሬይ ቢታ ዪ ማይኢዴስ፤ ኔኒ ያዳ ታስ ኢስታ ቃንጊዛ ጊዲኮ ታ ኢስታ ኦላ ጾናዳ ቢታፌ ኬሳናኮ ኦኔ ኤሪዛይ!› ጊ ኪቲዳ ኣሳታ» ጊ ዛሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ጾሲ ቃሴ ባላሜ፥ «ኔኒ ሃይታ ሃ ኣሳታራ ቦፓ፤ ኢስራኤሌ ዴሬይ ኣንጄቲዳ ዴሬ ጊዲዳ ጊሻስ ኔኒ ኢስታ ቃንጎፋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","ዎንቴꬃ ጋላስ ማላዶራ ባላሜይ ዴንዲዲ ባላቄይ ኪቲዳ ጪማታስ፥ «ታኒ ኢንቴናራ ቦንታ ማላ ጎዳይ ዲጊዳ ጊሻስ ኢንቴ ቢታ ሲሚቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","ሂስቲን ሞኣቤ ጪማቲ ባላቄኮ ሲሚዲ ባላሜይ ኢስታራ ዮንታ ኢጺዳይሳ ኢዛስ ዮቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","ሄሳፌ ጉዬ ዛሪዲካ ባላቄይ ካሴ ኪቴቲዳይታፔ ኣꬊ ቦንቼቲዳኔ ቆዳን ዳሮ ጪማታ ባላሜኮ ኪቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ኢስቲካ ባላሜኮ ቢዲ፥ «ጺፖራ ና ባላቄይ ኔና፥ ‹ኔኒ ታኮ ዮንታ ማላ ኣይ ሚሺካ ኔና ቴቆፎ! ");
INSERT INTO gmve_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ታ ኔስ ኢዛ ኩሼ ዛራና፤ ኔ ታና ኦይቺዳ ኡባ ታ ኔስ ኢማና፤ ሄሳ ጊሻስ ሃ ዴሬዛ ያዳ ኔ ታስ ቃንጋና ማላ ታ ኔና ሾባይስ!› ጊዴስ» ጊ ዮቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","ጊዶ ኣቲን ባላሜይ ኢስታስ፥ «ባላቄይ ባ ካዎቴꬃ ኬꬃን ዲዛ ቢራኔ ዎርቃ ኡባ ኢዚ ታስ ኢሚዛኮካ ጎዳይ ታና ኣዛዚዳ ኣዛዞዛ ሜንꬃዳ ታኒ ታፔ ኣይ ሚሺካ ጉጃናስ ዎይኮ ፓጪንቻናስ ዳንዳይኬ። ");
INSERT INTO gmve_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ጎዳይ ታስ ዮቲዛ ሃራ ሚሺ ዲኮ ታ ኤራናሼ ጋካናስ ኢንቴካ ካሴይታꬆ ሃቻ ኦማርስ ሃን ኣቂቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ሄ ጋላሳ ኦማርስ ጾሲ ባላሜኮ ዪዲ፥ «ሃ ኣሳቲ ኔና ጼይጋና ዪዳ ጊሻስ ዴንዳዳ ኢስታራ ባ፤ ጊዲኮካ ታ ኔስ ዮቲዛዝ ጻላ ኦꬃ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","ሂስቲን ዎንቴꬃ ጋላስ ባላሜይ ባ ሃሬ ኮሪ ቶጊ ኤኪዲ ሞኣቤ ሃላቃታራ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","ባላሜይ ባ ሃሬ ቶጊ ኤኪዲኔ ባ ኣይሌታፔ ናምኣታ ካሌꬂዲ ቢሺን ጎዳ ሃንቆይ ኢዛ ቦላ ታማ ማላ ኤጺ ኬዚዴስ፤ ሂስቲን ጎዳ ኪታንቻይ ኢዛ ቴቃናስ ኦጌ ቦላ ኣꬊ ኤቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","ሃሬያ ጎዳ ኪታንቻይ ጊꬃ ማሻ ኦይኪዲ ኤቂዳይሳ ቤያዳ ኦጌፔ ሃራሶ ኬዛዱስ። ባላሜይ ሃሬዮ ኦጌን ዛራናስ ኢታ ሾች ሾጪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ሂስቲን ጎዳ ኪታንቻይ ናምኡ ባጋራ ዎይኔይ ቶኬቲዛሶሆፔ ጊዶን ያ ባጋራኔ ሃ ባጋራ ጊምቤይ ጊምቤቲ ኡቲዳ ኡንኦሶን ኤቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","ሃሬያ ጎዳ ኪታንቻዛ ቤኢዳ ማላ ጊምቤዛኮ ሺቃዳ ባላሜ ቶሆዛ ጊምቤዛራ ዳራጻዱስ፤ ሂስቲን ባላሜይ ሃሬዮ ናምኣንꬆ ቡካ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ሄሳፌ ጉዬ ጎዳ ኪታንቻይ ጌዴ ሲንꬄ ኣꬊ ቢዲ ናምኡ ባጋራ ኣꬊዛሶይ ባይንዳ ጹንꬃ ኦጌን ኤቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","ሃሬያ ጎዳ ኪታንቻዛ ቤኣዳ ባላሜይ ቶጊ ዲሺን ቢታን ኢቻዱስ፤ ሄሳ ጊሻስ ባላሜይ ባ ጉፌራ ኢዞ ቡኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","ሄ ዎዴ ጎዳይ ሃሬይስ ሃሳያናስ ዶና ዶዪን ኢዛ ባላሜስ፥ «ታ ኔስ ኣይ ኢታ ኦꬃዲና? ሄꬑቶ ኔ ታና ኣይስ ሾጫዲ?» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","ባላሜይካ ኢዚስ፥ «ኔ ታና ኬሃ ካኢዳ ጊሻሳ! ታ ኩሼን ማሻይ ዲዛኮ ታ ኔና ዎꬎ ዎꬋናሺን!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ሃሬያካ ባላሜስ፥ «ሃኖ ጋካናስ ኔ ቶጊዛ ታ ኔ ሃሬዮ ጊዲኪና! ሃይሳፌ ካሴ ሃኒꬆ ሃና ኤራዚና?» ጋዱስ። ባላሜይ ኢዚስ ዛሪዲ፥ «ሙሌካ ሃይሳꬆ ሃና ኤራካ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ሄ ዎዴ ጎዳይ ባላሜ ኣይፌታ ዶዪን ጎዳ ኪታንቻይ ጊꬃ ማሻ ሾዲ ኦይኪዲ ኦጌን ኤቂዳይሳ ቤኢዲ ባላሜይ ቢታ ቦላ ጉፋኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","ጎዳ ኪታንቻዚ ኢዛስ፥ «ኔ ሃሬዮ ኣይስ ሄꬑቶ ሾጫዲ? ታኒ ያዳ ኔ ኦጌ ጎርዲዳይ ኔ ቢዛ ኦጌዚ ጌላ ጊዲዳ ጊሻስ ኔና ዛራናሳ። ");
INSERT INTO gmve_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ኔ ሃሬያ ታና ቤኣዳ ሄꬑቶ ታ ሲንꬃፌ ባቃታዱስ፤ ኢዛ ባቃቶንታኮ ታ ኢዞ ኣጋዳ ኔና ዎꬋይቻናኮሺን» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","ባላሜይ ጎዳ ኪታንቻስ ዛሪዲ፥ «ቱሙካ ታ ናጋራ ኦꬃዲስ፤ ኔ ታና ቴቃናስ ኦጌ ቦላ ኤቂዳይሳ ታ ኤራቤኬ፤ ሃኢካ ኔ ታ ቡሳ ዶሶንታ ጊዲኮ ታኒ ጉዬ ታሶ ሲማና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","ጎዳ ኪታንቻይ ባላሜስ፥ «ኔ ሃ ኣሳታራ ባ ሺን ታኒ ኔስ ዮቲዛይሳ ጻላ ዮታ» ጊዴስ፤ ሂስቲን ባላሜይ ባላቄይ ኪቲዳ ሃላቃታራ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","ባላቄይ ባላሜይ ዪዛይሳ ሲዪዲ ኢዛ ሞካናስ ሞኣቤ ባዞን ኣርኖኔ ሻፋ ኣቻን ዲዛ ኤሬ ካታማ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","ባላቄይ ባላሜ፥ «ኮይሮ ታ ኔኮ ኪቲዳ ኣሳታራ ኣዛስ ዮንታ ኢጻዲ? ታ ኔና ቦንቾንታ ኣስ ሚሳቲኔ?» ጊ ኢዛ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","ባላሜይካ ባላቄስ፥ «ጊዲኮካ ሃኢ ታኒ ኔኮ ያዲስ፤ ሃኢካ ታስ ኣይ ዎልቃይ ዲዜ? ታ ሃሳያና ዳንዳይዛይ ጾሲ ታስ ዮቶሮ ጻላ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","ሄሳ ጊሻስ ባላሜይ ባላቄራ ጌዴ ቂሪያቴ ሁጾቴ ካታማ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ባላቄይ ሄን ሜሄ ሹኪሲዲ ሄ ኣሾዛፔ ጉꬅ ሄን ባናራ ዲዛ ዴሬ ካሌꬂዛይታሲኔ ባላሜስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ዎንቴꬃ ጋላስ ማላዶ ባላቄይ ባላሜ ኢስራኤሌ ኣሳፔ ባጋይ ቤቲዛሶ ፑዴ ባሞቲ ባኣሌ ጌቴቲዛ ዙማ ቦላ ኬሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","ባላሜይ ባላቄ፥ «ኔ ታስ ሃይሳን ላፑን ያርሾ ያርሻናሶታ ኦꬃ፤ ቃሴካ ላፑን ኮርማ ቦራታኔ ላፑን ዶርሳ ꬋርሾታ ታስ ሃ ኤካ ያ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","ባላቄይ ባላሜይ ኢዛስ ዮቲዳ ማላ ኦꬂዴስ፤ ኢስቲ ናምኣይ ያርሾ ያርሺዛሶሆታ ቦላ ኢሲ ኢሲ ኮርማ ቦራኔ ኢሲ ኢሲ ꬋርሾ ያርሾ ሺሺዳ። ");
INSERT INTO gmve_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ሄሳፌ ጉዬ ባላሜይ ባላቄስ፥ «ጾሲ ሃ ታኮ ያናኮኔ ዮንታኮ ታኒ ጌዴ ባዳ ኤራና ጋካናስ ኔኒ ሃይሳን ጹጌቲዛ ያርሾዛ ኣቻን ኤቃሻ፤ ጎዳይ ታስ ቆንጪሲኮ ሄሳ ታ ኔስ ዉርሳ ዮታና» ጊዴስ፤ ሄሳፌ ጉዬ ባላሜይ ባርካ ፑዴ ꬎቃሶ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ሄን ጾሲ ኢዛራ ጋይቲዴስ፤ ባላሜይካ፥ «ታኒ ላፑን ያርሾ ያርሺዛሶሆታ ጊጊሳዲስ፤ ያርሾ ያርሺዛሶሆታ ኢሳ ኢሳ ቦላ ኢሲ ኢሲ ኮርማ ቦራኔ ኢሲ ኢሲ ꬋርሾ ያርሻዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","ጎዳይካ ባላሜይ ባላቄስ ዮታናስ ቤሲዛ ኪታ ኢዛስ ዮቲዳፔ ጉዬ ባላቄኮ ሲሚ ባና ማላ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","ኢዚካ ጉዬ ሲሚ ቢሺን ባላቄይ ሞኣቤ ኣይሲዛ ዳናታ ኡባራ ኢሲፌ ሄ ጹጌቲዛ ያርሾዛ ኣቻን ኤቂዳ ማላ ዴሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","ሄሳፌ ጉዬ ባላሜይ ሃሳያ ዶሚዲ፥ «ሞኣቤ ካዎ ባላቄይ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ዙማቲ ዲዛ ኣራሜፔ ታና ጼይጊ ኤሂዴስ፤ ኢዚ ታና፥ ‹ሃ ያዳ ኢስራኤሌ ኣሳ ታስ ዶቃርኪ! ኢስቲ ꬋያና ማላ ታስ ኢስታ ቃንጋርኪ!› ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ሂስቲን ታኒ ጾሲ ቃንጎንታዴ ዎስታ ቃንጎ? ጾሲ ሂሎንታዴ ታኒ ዎስታ ሂሎ? ");
INSERT INTO gmve_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ታኒ ኢስታ ሃይታ ጊታ ዛላታ ቦላ ዳሼ ዴማይስ፤ ꬎቃ ዙማታ ቦላ ዳሼ ታ ኢስታ ጼላይስ፤ ኢስቲ ባርካ ዲዛ ካዎቴꬅ፤ ኢስቲ ባና ሃራ ካዎቴꬃራ ጋꬂ ቆዶንታይሲ ታስ ቤቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ጉዱላ ማላ ጮሪዳ ያቆቤ ዜሬꬃ ቆዲ ዳንዳያናይ ኦኔ? ዎይኮ ኢስራኤሌስ ጪጎዛካ ቆዲ ካንꬃናይ ኦኔ? ጺሎ ኣሳታ ሃይቆ ታ ሃይቃና፤ ታ ዉርሴꬃይካ ኢስታ ዉርሴꬃ ማላ ጊዶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","ባላቄይ ባላሜስ፥ «ሃይሲ ኔ ታ ቦላ ኦꬂዳይሲ ኣዜ? ታኒ ኔና ሃ ኤሂዳይ ኔ ታ ሞርኬታ ቃንጋናሳ፤ ኔኒ ጊዲኮ ኢስታ ኣንጆ ኣንጃዳሳ ኣቲን ቃንጋቤካ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","ባላሜይካ ዛሪዲ፥ «ጎዳይ ታስ ቆንጪሲዳይሳ ጻላ ታ ዮታናስ ቤሴኔ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ባላቄይ ባላሜስ፥ «ኢስራኤሌ ኣሳ ኩሜꬃ ጊዶንታ ኢስታፌ ጉꬃቲ ኔስ ቤቲዛሶ ጌዴ ሃራሶ ታናራ ኢሲፌ ባዳ ኔ ኢስታ ሄን ታስ ቃንጋርኪ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","ሄሳፌካ ፑዴ ፒዝጋ ዙማ ሁኤን ዲዛ ጾፊሜ ዴምባ ኤፊዴስ፤ ሄንካ ላፑን ያርሾ ያርሺዛሶ ጊግሲዲ ኢሲ ኢሲ ያርሺዛሶዛ ቦላ ኢሲ ኢሲ ኮርማ ቦራኔ ꬋርሾ ያርሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","ባላሜይ ባላቄስ፥ «ኔኒ ሃይሳ ጹጌቲዛ ያርሾዛ ማታን ኤቃሻ፤ ታኒ ጎዳራ ጋይታና ጌዴ ባይስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","ጎዳይካ ባላሜራ ሄን ጋይቲዴስ፤ ኢዚ ዮታና ኪታ ኢዛስ ዮቲዲ ኔኒ ባላቄኮ ሲማ ባዳ ሃይሳ ሃ ኪታ ኢዛስ ዮታ። ");
INSERT INTO gmve_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","ኢዚ ሲሚ ቢሺን ባላቄይ ሞኣቤ ዴሬዛ ካሌꬂዛይታራ ሄ ጹጌቲዛ ያርሾዛ ማታን ኤቂዳ ማላ ዴሚዴስ፤ ባላቄይካ ጎዳይ ኢዛስ ኣይ ዮቲዳኮ ኢዛ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","ባላሜይካ ኢዛስ ሃሳያ ዶሚሼ፥ «ጺፖራ ና ባላቄ! ሃ ሺቃ! ታኒ ኔስ ዮቲዛይሳ ሲያ። ");
INSERT INTO gmve_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ጾሲ ኣሳ ማላ ዎርዶቴና፤ ኢዛ ቆፋይ ኣሳ ቆፋ ማላ ላሜቴና፤ ኢዚ ባ ኢሚዳ ሂዶታ ኡባ ፖሌስ፤ ኢዚ ባ ዮቲዳ ኡባ ኦꬄስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ኢዚ ታስ ታ ኣንጃና ማላ ዮቲዴስ፤ ጾሲ ኣንጂዳ ቃላ ታኒ ላማናስ ዳንዳይኬ። ");
INSERT INTO gmve_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","ያቆቤ ዜሬꬃ ቦላ ሜቶይ ጋኬና፤ ኢስራኤሌ ኣሳ ቦላካ ዋዬይ ጋኮንታይሲ ታስ ቤቴስ፤ ጎዳይ ኢስታራ ዴስ፤ ጾሲ ካዎ ጊዲዳይሳ ኢስቲ ቆንጬን ዮቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ጾሲ ኢስታ ጊብጼፔ ኬሲዴስ፤ ኢዚ ኢስታስ ሜንꬃ ማላ ቃይጫና። ");
INSERT INTO gmve_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","ያቆቤ ናይታ ቦላ ኣይ ቢታይ፥ ኢስራኤሌ ቦላ ኣይ ሙሬኖይካ ኦꬄና፤ ሄኮ ሃኢ ያቆቤሲኔ ኢስራኤሌስ፥ ‹ጾሲ ኢስቲ ኣይ ኦꬂዳኮ ኣኔ ጼሊቴ!› ጌቴታና። ");
INSERT INTO gmve_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ኢስራኤሌ ኣሳይ ማጫ ጋሞ ማላ ዴንዳና፤ ባ ሻንካቲ ኤሂዳይሳ ሞንታ፥ ሱꬃካ ኡዮንታ ዲሼ ሼምፖንታ ጋሞ ማላ ዴንዳና» ጊ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","ሄሳፌ ጉዬ ባላቄይ ባላሜስ፥ «ኔኒ ኢስራኤሌ ኣሳ ቃንጎንታ ኢጺዳ ማላ ኢስታ ኣንጆካ ኣንጆፋ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","ባላሜይካ፥ «ታኒ ካሴ ኔስ ጎዳይ ታስ ዮቶሮ ጻላ ታ ኦꬃና ጋዳ ዮታቤኪና?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","ባላቄይካ፥ «ሃ ያ ኣኔ ሃይሳፌ ሃራሶ ቦስ፤ ኦኔ ኤሪዛይ ኔኒ ሄን ዳዳ ሃይሳ ዴሬዛ ታስ ቃንጋና ማላ ጾሲ ኔስ ኤሮ ጎንታ ኣጌና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","ሄሳ ጊሻስ ባላቄይ ባላሜ ጌዴ ባዞ ጊናራ ዲዛ ፔኦሬ ዙማ ሁኤ ኤኪ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","ባላሜይካ ኢዛ፥ «ሃይሳን ታስ ላፑን ያርሾ ያርሺዛሶ ጊጊሳ፤ ላፑን ኮርማ ቦራታኔ ላፑን ꬋርሾታ ሃ ታስ ኤካ ያ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","ባላቄይካ ባላሜይ ኢዛስ ዮቲዳ ማላ ኦꬂዴስ፤ ያርሾ ያርሺዛሶዛ ቦላ ኢሲ ኢሲ ኮርማ ቦራኔ ኢሲ ኢሲ ꬋርሾ ያርሾ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","ባላሜይካ ጎዳይ ኢስራኤሌ ኣሳ ኣንጃናስ ዶሲዳይሳ ኤሪዳ ዎዴ ካሴ ኢዚ ኦꬂዛይሳ ማላ ሙሬኖ ኦሶ ኦꬃናስ ኮዪቤና፤ ባ ሲንꬃካ ዱጌ ባዞ ዛሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ኢስራኤሌ ኣሳይ ባ ቆሞን ቆሞን ማራራ ዱንካኒ ኡቲዳይሳ ቤኢዴስ፤ ጾሳ ኣያናይ ኢዛ ቦላ ዎꬊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ሂስቲን ኢዚ ቲንቢቴ ሃሳያ ዶሚዲ፥ «ቢኦሬ ና ባላሜይ ሃሳይዛ ቲንቢቴ ቃላይ፥ ኢዛ ኣይፌቲካ ዶዬቲዳዴይ፥ ");
INSERT INTO gmve_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ጾሳ ቃላ ሲዪዛዴይ ኢዚ ኩንዲ ዲሺን ኢዛ ኣይፌቲ ዶዬቲን ኡባ ዳንዳይዛ ጾሳ ኣጁታ ቤኢዛዴ ኪታይ ሃይሳ። ");
INSERT INTO gmve_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","ያቆቤ ኔ ዱንካኔቲ ኢስራኤሌ ኔ ዲዛሶቲ ኣይ ማላ ሎኦ? ");
INSERT INTO gmve_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","ኢስቲካ ሚጬቲዳ ዙሌታ ማላ፤ ቃሴካ ሻፋ ዶናን ዲዛ ኣታኪልቴሶሆታ ማላ፤ ጎዳይ ቶኪዳ ጎዳሬ ኡꬃ ማላ፤ ዎይኮ ሻፋ ዶናን ዲዛ ሊባኖሴ ዚጋ ማላ። ");
INSERT INTO gmve_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","ኢራይ ኡባ ዎዴ ኢስታስ ቡኪዛ ጊሻስ ኢስታ ሃꬂ ኩሚ ፓላሄስ፤ ዜሬꬃ ዎዴ ኢስታስ ጊዲዛ ሃꬂ ዴስ፤ ኢስታ ካዎይ ኣጋጌፔ ኣꬌꬅ ጊዳና፤ ኢስታ ካዎቴꬂ ꬎቁ ꬎቁ ጋና። ");
INSERT INTO gmve_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","ኢስታ ጊብጼፔ ኬሲዳ ጾሲ ኢስታስ ሜንꬃ ማላ ኦሌታና፤ ኢስታ ሞርኬ ጊዲዳ ካዎቴꬃታ ኢዚ ፑዜሬꬂ ዬጋና፤ ኢዚ ኢስታ ሜቄꬃታ ሊቂሳና፤ ኢስታ ዎንዳፌታካ ሜንꬄሬꬂ ዬጋና። ");
INSERT INTO gmve_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","ሃይሲ ካዎቴꬃይ ጋሞ ማላ ዛማዲ ኡቲዴስ፤ ማጫ ጋሞ ማላካ ዙጊ ኡቲዴስ፤ ኢስቲ ዛማዲ ኡቲዳሶሆፔ ኢስታ ዴንꬃና ዳንዳይዛይ ኦኔ? ኔና ኣንጂዛዴይ ኣንጄቶ፤ ኔና ቃንጊዛዴይካ ቃንጌቶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","ባላቄይ ሃንቆን ባ ኩሼ ባቂዲ ባላሜስ፥ «ታኒ ኔና ታ ሞርኬታ ቃንጋናስ ጼይጋዲስ፤ ጊዶ ኣቲን ኔኒ ኢስታ ሄꬑቶ ኣንጃዳሳ። ");
INSERT INTO gmve_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ሃኢ ጊዲኮ ኤሶን ጌዴ ኔሶ ባ! ታ ኔስ ዳሮ ሚሽ ኢማና ጋ ቃላ ጌላዲስ፤ ጊዶ ኣቲን ኔ ሄ ሚሻ ዴሞንታ ማላ ጾሲ ጎርዲዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","ባላሜይ ባላቄስ ዛሪዲ፥ «ኔኒ ታኮ ኪቲዳ ኣሳታስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‹ባላቄይ ባስ ዲዛ ቢራኔ ዎርቃ ኡባ ኢዚ ታስ ኢሚዛኮካ ታኒ ታ ሼኔን ኢታ ጊዲን ዎይኮ ሎኦ ኦꬃናስ ጎዳ ቃላፔ ኣꬋናስ ዳንዳይኬ፤ ታኒ ዮታናይ ጎዳይ ታስ ዮቶሮ ጻላ› ጋዳ ካሴ ታ ኢስታስ ዮታቤኪና?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ዉርሴꬃን ባላሜይ ባላቄስ፥ «ሃኢ ታኒ ጌዴ ታ ዴሬ ሲማ ባይስ፤ ጊዶ ኣቲን ታ ባናፔ ካሴታዳ ኢስራኤሌ ኣሳይ ኔ ዴሬ ኣሳ ቦላ ጋꬃናይሳ ኔስ ቆንጪሳናስ ኮያይስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","ሄሳፌ ጉዬ ኢዛስ ቲንቢቴ ዮቶ ዶሚዲ፥ «ኢዛ ኣይፌይ ዶዬቲዳዴይ፥ ቢኦሬ ና ባላሜይ ዮቲዛ ቲንቢቴ ቃላይ ሃይሳ፤ ");
INSERT INTO gmve_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ጾሳ ቃላ ሲዪዛዴ፥ ኢዚ ኩንዲ ዲሺን ኢዛ ኣይፌቲ ዶዬቲን ዎልቃማ ጾሳፌ ኤራቴꬅ ዴሚዳዴ፥ ኡባ ዳንዳይዛ ጾሳ ኣጁታ ቤኢዛዴ ኪታይ ሃይሳ። ");
INSERT INTO gmve_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","ታኒ ኢዛ ቤኣይስ፤ ጊዶ ኣቲን ሃኢ ጊዴና፤ ታ ኢዛ ጼላይስ፤ ጊዲኮካ ሃኢ ማታን ጊዴና፤ ጾሊንቴይ ያቆቤፔ ቤታና፤ ካዎቴꬃ ጉፌይ ኢስራኤሌፔ ኬዛና፤ ሞኣቤ ዜሬꬃኔ ሴቴ ዜሬꬃታ ኡባ ዲፒ ሂስቲ ꬋይሳና። ");
INSERT INTO gmve_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ኤዶሜይ ጾኔታና፤ ኢዛ ሞርኬ ሴይሬይካ ኢዛስ ሃሬታና፤ ኢስራኤሌ ዴሬይ ጾኖይ ጾኖሺን ዳና። ");
INSERT INTO gmve_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","ያቆቤፔ ዴሬ ኣይሲዛዴይ ኬዛና፤ ኢዚ ካታማ ጊዶን ኣቲዳይታ ፒቲ ꬋይሳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ሄሳፌ ጉዬ ባላሜይ ጌዴ ኣማሌቄ ዛሪ ጼሊዲ፥ «ኣማሌቄይ ኡባፌ ኣꬊዛ ዎልቃማ ካዎቴꬅ፤ ጊዶ ኣቲን ኢዚ ዉርሴꬃን ሜርናስ ꬋያና» ጊ ቲንቢቴ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ጌዴ ቄናዌ ዴሬ ኣሳኮ ሲሚ ጼሊዲ፥ «ኔ ዱሳሶይ ኣማኔቲዳሶ ሚሳቲኮካ፥ ኔ ኬꬃይ ዛላፌ ዎጬቲ ኬጼቲዳ ጊዲኮካ፥ ");
INSERT INTO gmve_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ኢንቴኖ ቄናዌ ዴሬቶ! ኣሶሬይ ኢንቴና ጾኒዲ ዲኢ ኤፊዛ ዎዴ ኢንቴ ዉሪ ዉራና» ጊ ቲንቢቴ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","ዉርሴꬃን ባላሜይ፥ «ጾሲ ሃይሳ ኦꬂሺን ኦኔ ሼምፖራ ፓጻ ዳናይ? ");
INSERT INTO gmve_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","ኦላስ ዎራጂዛ ኣሳይ ማርካቤራ ቆጲሮሴፔ ያና፤ ኢስቲካ ኣሶሬኔ ኤቦሬ ꬋይሳና፤ ኢስቲካ ባ ሁኤስ ሜርናስ ꬋያና» ጊ ቲንቢቴ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ሄሳፌ ጉዬ ባላሜይ ዴንዲዲ ጌዴ ባ ዴሬ ቢዴስ፤ ባላቄይካ ባሶ ሲሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","ኢስራኤሌ ኣሳይ ሺጺሜ ሾባን ዲዛ ዎዴ ኣዴቲ ሄን ዲዛ ሞኣቤ ዴሬ ማጫሳታራ ላይማቲዳ፤ ");
INSERT INTO gmve_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ሄ ሞኣቤ ማጫሳቲ ኤቃ ጾሳታስ ያርሺዛ ያርሾ ካꬃፌ ማና ማላ ኢስራኤሌ ኣሳ ጼይጊን ኢስቲካ ሄ ካꬃፌ ሚዲ ኤቃ ጾሳስ ጎይኒዳ። ");
INSERT INTO gmve_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ኢስራኤሌ ኣሳይ ባኣሊ-ፔኦሬ ጌቴቲዛ ኤቃ ጾሳስ ጎይኒዳ ጊሻስ ጾሲ ኢስታ ቦላ ሃንቄቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","ጎዳይ ሙሴስ፥ «ኢስራኤሌ ኣሳ ቦላ ኤጺዳ ታ ሃንቆይ ዶቻና ማላ ኢስራኤሌ ኣሳ ካሌꬂዛይታ ኡባ ኤካዳ ሴታ ጋላስ ሱሊዛ ኣዋን ዴሬዚ ቤኢሺን ካቃ ዎꬋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","ሙሴይካ ኢስራኤሌ ኣሳ ቦላ ፒርዲዛ ዳናታስ፥ «ኢንቴ ኢሶይ ኢሶይ ኢንቴ ዛርኬፌ ዛርኬፌ ባኣሊ-ፔኦሬ ጌቴቲዛ ኤቃ ጾሳዛስ ጎይኒዳ ኣስ ኡባ ዎꬊቴ» ጊዲ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ሙሴይኔ ኩሜꬃ ማባራይ ጋይቶቴꬃ ዱንካኔ ፔንጌን ሺቂዲ ዬኪሺን ኢስራኤሌ ኣሳ ጋርሳፌ ኢሳዴይ ኢሲ ሚዲያሜ ማጫሳዮ ኤኪዲ ዴራ ሲንꬃራ ኣꬊ ጌዴ ባሶ ኣሳኮ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","ቄሴ ኣሮኔስ ናዛ ናይ፥ ኤልኤዜሬ ና ፊኒሃሲ ሄሳ ቤኢዲ ካሴ ባ ኡቲዳሶሆፔ ፑሱኩ ጊ ዴንዲዲ ቶሆራ ኤኪዲ ዴሬዛ ጊዶፌ ኬዚ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ሄ ኣዴዚኔ ማጫሳያ ኢዛን ዲዛ ዱንካኔን ጌሊዴስ፤ ናምኣታካ ኢሲ ቦላ ቶራራ ጫዲ ዎꬊዴስ፤ ሂስቲን ኢስራኤሌ ኣሳ ቦላ ዪዳ ቦሻይ ሲሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ቦሻይ ሲማና ጋካናስ ሲንꬃን ሃይቂዳ ኣሳይ 24,000 ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«ቄሴ ኣሮኔስ ናዛ ና፥ ኤልኤዜሬ ና ፊኒሃሲ ኢስራኤሌ ኣሳ ጊዶን ታኒ ታ ቦንቾስ ኤቄቲዛ ማላ ኢዚ ኤቄቲዳ ጊሻስ ኢስታ ቦላ ታ ሃንቄቲዳ ሃንቆይ ዶቺዴስ፤ ሄሳ ጊሻስ ታኒ ታ ሃንቆዛን ኢስራኤሌ ኣሳ ꬋይሳቤኬ። ");
INSERT INTO gmve_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","ሄሳ ጋሶን ታኒ ኢዛስ ሜርና ሳሮቴꬃ ጫቆ ቃላ ጌሊዳይሳ ኔ ኢዛስ ዮታ። ");
INSERT INTO gmve_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","ኢዚ ባ ጎዳ ቦንቾስ ኤቂዳ ጊሻሲኔ ዴራ ናጋራ ኢዚ ዉርሲዳ ጊሻስ ኢዚኔ ኢዛ ዜሬꬃቲ ኡባይ ሜርናስ ቄሴ ጊዳና።» ");
INSERT INTO gmve_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ሄ ሚዲያሜ ማጫሳይራ ኢሲፌ ሃይቂዳ ኢስራኤሌ ኣዴዛ ሱንꬂ ሳሉ ና ዚሚሬ ጌቴቴስ፤ ኢዚካ ሲሞና ዛርኬታስ ኮራፒኔ። ");
INSERT INTO gmve_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","ሄ ማጫሳያ ኮዜቦ ጌቴታዉስ፤ ኢዚ ኣዋይ ጹሬ ጌቴቴስ፤ ኢዚካ ባናራ ኢሲፌ ዲዛ ኣማርዳ ሚዲያሜ ቆሞታስ ኮራፒኔ። ");
INSERT INTO gmve_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«ኢንቴ ሚዲያሜ ኣሳ ሞርኬ ማላ ቆዲዲ ዲፒ ሂስቲ ꬋይሲቴ። ");
INSERT INTO gmve_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ጋሶይካ ኢስቲ ፔኦሬን ኢንቴ ቦላ ጌኔ ኦꬂዳ ጊሻሲኔ ሄን ዎꬊዳ ቦሻ ጌዶን ሃይቂዳ ኢስታ ሃላቃ ናዮ ኮዜቢ ባጋራ ባሌꬂዲ ኢንቴ ቦላ ሞርኬቴꬃ ኦሶ ኦꬂዳ ጊሻሳ።» ");
INSERT INTO gmve_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ሄ ቦሻዚ ኣጊዳፔ ጉዬ ጾሲ ሙሴሲኔ ቄሴ ኣሮኔ ና ኤልኤዜሬስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«ኩሜꬃ ኢስራኤሌ ማባራን ኢሳዴ ኬꬃን ኬꬃን ኢስታስ ላይꬂ 20 ኩሚዳይታኔ ሄሳፌካ ቦላራ ጊዲዲ ዎታዳሬቴꬃን ኦꬃናስ ዳንዳይዛ ኣቱማ ናይታ ኡባ ቆዲቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","ሙሴይኔ ቄሴ ኤልኤዜሬይ ዮርዳኖሴ ሻፋ ማታን ኢያርኮ ጊናራ ዲዛ ሞኣቤ ዴምባን ዴሬዛ ሺሺዲ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«ጎዳይ ሙሴስ ኣዛዚዳ ማላ ናምኡ ታሙ ላይꬂኔ ሄሳፌካ ቦላራ ዲዛ ኣሳ ኡባ ቆዲቴ» ጊዳ። ጊብጼ ዴሬፔ ኬዚዳ ኢስራኤሌ ኣሳይ ሃይሳፌ ካሊዛይታ፤ ");
INSERT INTO gmve_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ያቆቤስ ባይራ ናዛ ኦሮቤሌ ዛርኬፌ ዬሌቲዳይቲ ሄኖኬኔ ኢዛ ዜሬꬃታ፥ ፓሉኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ሄጺሮሜኔ ኢዛ ዜሬꬃታ፥ ካርሜኔ ኢዛ ዜሬꬃታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ኦሮቤሌ ዛርኬፌ ቆዴቲዳይቲ 43,730። ");
INSERT INTO gmve_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ፓሉ ናይ ኤልያቤ፤ ");
INSERT INTO gmve_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ኤልያቤ ናይቲ ናሙኤሌ፥ ዳታኔኔ ኣብራሜ፤ ዳታኔይኔ ኣብራሜይ ዴሬዛን ዶሬቲዳይታ ጊዲ ኡቲዲ ቆሬራኔ ኢዛ ካሊዛይታራ ዙፔቲዲ ጎዳ ቦላ ማካሊዲ ሙሴኔ ኣሮኔ ፓጪዳ። ");
INSERT INTO gmve_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ኢስታካ ቢታያ ዶዬታዳ ቆሬራ ኢሲ ቦላ ጋꬃ ሚታዱስ፤ ኢስቲካ ሃይቂን ሳሎፔ ዎꬊዳ ታማይ 250 ኣሳ ጹጊዴስ፤ ሂስቲን ኢስታ ቃጻዬቴꬂ ሃራ ኣሳስ ማላታ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","ቆሬ ዜሬꬃቲ ጊዲኮ ሃይቂቤቴና። ");
INSERT INTO gmve_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","ሲሞና ዛርኬፌ ዬሌቲዳይቲ ናሙኤሌኔ ኢዛ ዜሬꬃታ፥ ያሚኔኔ ኢዛ ዜሬꬃታ፥ ያኪኔኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ዛራሄኔ ኢዛ ዜሬꬃታ፥ ሳኦሌኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ሲሞና ዛርኬታፔ ቆዴቲዳይቲ 22,200 ኣዴታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","ጋዴ ዛርኬፌ ዬሌቲዳይቲ ጺፎኔኔ ኢዛ ዜሬꬃታ፥ ሃጌኔ ኢዛ ዜሬꬃታ፥ ሹኔኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ኦሲናኔ ኢዛ ዜሬꬃታ፥ ኤሬኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ኣሮዴኔ ኢዛ ዜሬꬃታ፥ ኣርኤሌኔ ኢዛ ዜሬꬃታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ጋዴ ዛርኬታፔ ቆዴቲዳይቲ 40,500 ኣዴታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","ዩሁዳ ዛርኬፌ ዬሌቲዳይቲ፥ ኤራኔ ኦናኔ፤ ኢስቲ ካናኔ ቢታን ሃይቂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","ሃንኮ ኣቲዳ ዩሁዳ ዛርኬፌ ዬሌቲዳይቲ ሴሎሜኔ ኢዛ ዜሬꬃታ፥ ፓሬሴኔ ኢዛ ዜሬꬃታ፥ ዛራሄኔ ኢዛ ዜሬꬃታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ፓሬሴ ዜሬꬃቲ ሄጺሮሜኔ ኢዛ ባጋታ፥ ሃሙሌኔ ኢዛ ዜሬꬃታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ዩሁዳ ዛርኬፌ ቆዴቲዳይቲ 76,500 ኣዴታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ዪሳኮሬ ዛርኬፌ ዬሌቲዳይቲ ቶላ ኢዛ ዜሬꬃታ፥ ፑዋኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ያሹቤኔ ኢዛ ዜሬꬃታ፥ ሺሚሮኔኔ ኢዛ ዜሬꬃታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ዪሳኮሬ ዛርኬታፔ ቆዴቲዳይቲ 64,300 ኣዴታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ዛቢሎኔ ዛርኬፌ ዬሌቲዳይቲ፥ ሴሬዴኔ ኢዛ ዜሬꬃታ፥ ኤሎኔኔ ኢዛ ዜሬꬃታ፥ ያሂሌኤሌኔ ኢዛ ዜሬꬃታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ዛቢሎኔ ዛርኬፌ ቆዴቲዳይቲ 60,500 ኣዴታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","ዮሴፌ ዛርኬፌ ዬሌቲዳይቲ፥ ሚናሴኔ ኢዛ ዜሬꬃታ፥ ኤፍሬሜኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","ሚናሴ ናይታ ዜሬꬅ ማኪሬይ ጋላኣዴ ዬሊዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","ጋላኣዴ ናይቲ ኤዜሬኔ ኢዛ ዜሬꬃታ፥ ሄሌቄኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ኣሲራኤሌኔ ኢዛ ዜሬꬃታ፥ ሴኬሜኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ሻሚዳኔ ኢዛ ዜሬꬃታ፥ ሄፌሬኔ ኢዛ ዜሬꬅ። ");
INSERT INTO gmve_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ሄፌሬ ና ጺሎፋዴይ ማጫ ናይታ ጻላ ዬሊዴስ፤ ሄይቲካ ማሂሎ፥ ኖኦ፥ ሆጊሎ፥ ሚልኮኔ ቲርጾ ጌቴቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ሚናሴ ቆሞታፔ ቆዴቲዳይቲ 52,700 ኣዴታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ኤፍሬሜ ዛርኬፌ ዬሌቲዳይቲ፥ ሹቱላኔ ኢዛ ዜሬꬃታ፥ ቤኬሬኔ ኢዛ ዜሬꬃታ፥ ታሃኔኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ሹቱላ ና ኤራኔኔ ኢዛ ዜሬꬃታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ኤፍሬሜ ዛርኬታፔ ቆዴቲዳይቲ 32,500 ኣዴታ፤ ዮሴፌ ዛርኬፌ ባ ባጋን ባጋን ቆዴቲዳይቲ ሃይታንታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","ቢኒያሜ ዛርኬፌ ዬሌቲዳይቲ፥ ቤላኔ ኢዛ ዜሬꬃታ፥ ኣሺቤሌኔ ኢዛ ዜሬꬃታ፥ ኣሂራሜኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ሻፋሜኔ ኢዛ ዜሬꬃታ፥ ሁፉሜኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","ቤላ ዛርኬፌ ኣራዴኔ ኢዛ ዜሬꬃታ፤ ናኢማኔኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ቢኒያሜ ዛርኬፌ ቆዴቲዳይቲ 45,600 ኣዴታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","ዳኔ ዛርኬታፔ ዬሌቲዳይቲ፥ ሹሃሜኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","ሹሃሜ ዜሬꬃታ ቆዳይ 64,400 ኣዴታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ኣሴሬ ዛርኬታፔ ዬሌቲዳይቲ ዪሚኔኔ ኢዛ ዜሬꬃታ፥ ዪሺዌኔ ኢዛ ዜሬꬃታ፥ ባሪሄኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","ባሪሄ ናይታፔ ሄቤሬኔ ኢዛ ዜሬꬃታ፥ ማልኪኤሌኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","ኣሴሬስ ሴራሆ ጌቴቲዛ ማጫ ናይ ዳዉስ። ");
INSERT INTO gmve_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ኣሴሬ ዛርኬታፔ ቆዴቲዳይቲ 53,400 ኣዴታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","ኒፍታሌሜ ዛርኬፌ ዬሌቲዳይቲ፥ ያሂጼሌኔ ኢዛ ዜሬꬃታ፥ ጉኔኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ዬጺሬኔ ኢዛ ዜሬꬃታ፥ ሼሌሜኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ኒፍታሌሜ ዛርኬታፔ ቆዴቲዳይቲ፥ 45,400 ኣዴታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ኩሜꬅ ቆዴቲዳ ኢስራኤሌ ኣቱማሳይ 601,730 ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«ቢታዮ ኢስታ ሱንꬃ ሱንꬃ ቆዳ ማላ ዛርኬታስ ጺንጾ ጊዳና ማላ ሻካ ሻካዳ ኢማ። ");
INSERT INTO gmve_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","ቆዳን ዳሪዛ ዛርኬታስ ኣሳ ኢማ፤ ቆዳን ጉጺዛይታስ ጹንꬃ ኢማ፤ ቢታ ጊሾይ ኣሳ ቆዳ ጮራቴꬃ ማላ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ጊዲኮካ ጊሾዚ ሳማን ጊዶ፤ ሳማዚካ ዬጌታናይ ኢዛዴ ዛርኬን ዛርኬና። ");
INSERT INTO gmve_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","ሳማዚ ዬጌታናይ ቆዳን ዳሮ ዜሬꬃታ ጊዶኒኔ ቆዳን ጉꬃ ዜሬꬃታ ጊዶን ጊዶ።» ");
INSERT INTO gmve_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ሌዌ ዛርኬፌ ዬሌቲዳይቲ ጌርሾኔኔ ኢዛ ዜሬꬃታ፥ ቃኣቴኔ ኢዛ ዜሬꬃታ፥ ሜራሬኔ ኢዛ ዜሬꬃታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ቃሴካ ሊቢና ዜሬꬃታ፥ ኬብሮኔ ዜሬꬃታ፥ ማሂሌ ዜሬꬃታ፥ ሙሼ ዜሬꬃታ፥ ቆሬ ዜሬꬃታ፥ ቃኣቴይ ኣሚራሜ ማኤ። ");
INSERT INTO gmve_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ኣሚራሜይ ጊብጼን ዬሌቲዳ ሌዌ ናዮ ዮካቤዶ ማቾ ኤኪዴስ፤ ኢዛካ ኣሮኔኔ ሙሴ ጌቴቲዛ ናምኡ ኣቱማ ናይታኔ ማራሞ ጌቴቲዛ ኢሲ ማጫ ና ዬላዱስ። ");
INSERT INTO gmve_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","ኣሮኔስ ናዳቤ፥ ኣቢሁ፥ ኤልኤዜሬኔ ኢታማሬ ጌቴቲዛ ኦይዱ ኣቱማ ናይቲ ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","ናዳቤይኔ ኣቢሁይ ጾሳ ሲንꬃን ቤሶንታ ታማ ሺሺዳ ጊሻስ ቦሻን ሃይቂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","ኢስታስ ላይꬃይ ኢሲ ኣጊናኔ ኢዛፔ ቦላራ ጊዲዳ ሌዌ ዛርኬፌ ኣዴታ ቆዳይ 23,000 ጊዲዴስ፤ ሄይቲካ ሃንኮ ኢስራኤሌ ኣሳፔ ዱማ ማዝጋባን ጻፌቲ ኡቲዳ፤ ጋሶይካ ኢስታስ ኢስራኤሌ ዴሬን ጺንጾስ ጊዲዛ ኣይኮ ጋዴይ ኢሜቶንታይሳሳ። ");
INSERT INTO gmve_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","ሙሴይኔ ኤልኤዜሬይ ኢያርኮ ጊናራ ዮርዳኖሴ ሻፋ ማታን ዲዛ ሞኣቤ ዴምባን ኢስራኤሌ ኣሳ ቆዲዳ ዎዴ ኢስቲ ጻፊ ኦይኪዳ ኢስራኤሌ ኣሳ ቆዳይ ሃይሳፌ ቦላን ዲዛይታ። ");
INSERT INTO gmve_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","ሙሴይኔ ኣሮኔይ ኮይሮ ሲና ባዞን ዴራ ቆዲዳ ዎዴ ቆዴቲዳ ኣቱማሳፔ ሼምፖራ ፓጻ ኣቲዳይ ባዋ። ");
INSERT INTO gmve_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","ሄሲ ሄሳꬆ ሃኒዳይ ጎዳይ ካሴ ኢስታስ፥ «ኢስቲ ዉሪካ ባዞ ቢታን ሃይቃና!» ጊዳ ጊሻሳ፤ ጊዶ ኣቲን ዮፊኔ ና ካሌቤይኔ ናዌ ና ኢያሶይ ኣታፌ ኡባይካ ሃይቂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","ዮሴፌይ ሚናሴ ዬሊዴስ፤ ሚናሴይ ማኪሬ ዬሊዴስ፤ ማኪሬይ ጋላኣዴ ዬሊዴስ፤ ጋላኣዴይ ሄፌሬ ዬሊዴስ፤ ሄፌሬይ ጺሎፋዴ ዬሊዴስ፤ ጺሎፋዴስ ማሂሎ፥ ኖኦ፥ ሆጊሎ፥ ሚልኮኔ ቲርጾ ጌቴቲዛ ማጫ ናይቲ ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ኢስቲካ ጋይቶቴꬃ ዱንካኔዛ ፔንጌኮ ቢዲ ኩሜꬃ ማባራኔ ዴሬዛ ካሌꬂዛይቲ ዲዛሶን ሙሴኔ ኤልኤዜሬ ሲንꬃን ኣꬊ ኤቂዲ፥ ");
INSERT INTO gmve_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«ኑ ኣዋይ ኢሲ ኣቱማ ናካ ዬሎንታ ባዞ ቢታን ሃይቂዴስ፤ ኢዚ ጎዳ ቦላ ማካሊዳ ቆሬ ካሊዛይታራ ኢሲፌ ዙፔቲቤና፤ ጊዶ ኣቲን ኢዚ ባ ናጋራ ጋሶን ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ሂስቲን ኢዚ ኣቱማ ና ዬሎንታ ኣጊዳ ጋሶን ጻላ ኑ ኣዋ ሱንꬂ ኢስራኤሌ ኣሳ ጊዶፌ ቁጬቲ ꬋያናስ ቤሲዜ? ሄሳ ጊሻስ ኑስ ቤሲዛ ጺንጾ ጋዴ ኑ ኣዋ ዳቦታ ጊዶን ኢሚቴ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","ሙሴይ ኢስታ ኦይሻ ጎዳ ሲንꬅ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","ጎዳይካ ኢዛስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«ጺሎፋዴ ማጫ ናይቲ ኦይቺዳ ኦይሻይ ሊኬ፤ ሄሳ ጊሻስ ኔ ኢስታ ኣዋ ዳቦታ ጊዶን ኢስታስ ጺንጾ ጋዴ ኢማ፤ ካሴ ኢስታ ኣዋ ጋዴይ ጌዴ ኢስታስ ኢሜቶ። ");
INSERT INTO gmve_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","ኣቱማ ና ዬሎንታ ሃይቂዳዴይ ዲኮ ኢዛ ማጫ ናይ ሄ ኢዛስ ዲዛዝ ላታናስ ዳንዳይዛይሳ ኢስራኤሌ ኣሳ ኤሪሳ። ");
INSERT INTO gmve_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","ኢዛስ ማጫ ናይካ ባይንዳዝ ጊዲኮ ኢዛስ ዲዛዝ ኢዛ ኢሻቲ ላቴቶ። ");
INSERT INTO gmve_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ኢሻይካ ዶንታ ኣጊኮ ኢዛ ኣዋ ኢሻቲ ላቴቶ። ");
INSERT INTO gmve_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ኢዛስ ኣዋ ኢሻይ ዶንታ ኣጊኮ ኢዛስ ማታቲዛ ዳቦይ ኢዛ ኣቆታ ላቲዲ ጎኤታናስ ዳንዳዬስ፤ ታኒ ጎዳይ ኔና ኣዛዚዳ ማላ ኢስራኤሌ ዴሬ ኣሳይ ሃይሳ ሃ ዎጋዛ ባስ ኤቂ ዲዛ ዎጋ ሂስቲ ናጎ።» ");
INSERT INTO gmve_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ጎዳይ ሙሴስ፥ «ኔኒ ፑዴ ኣባሪሜ ዙማታ ቦላ ኬዛዳ ታኒ ኢስራኤሌ ኣሳስ ኢማናስ ቆፒዳ ቢታ ኡባ ዩሻ ጼላ። ");
INSERT INTO gmve_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","ኔኒ ኢዛ ቤይዳፔ ጉዬ ኔ ኢሻ ኣሮኔይ ሃይቆይሳꬆ ኔካ ሃይቃና፤ ");
INSERT INTO gmve_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ኢንቴ ናምኣቲካ ጺኔ ጌቴቲዛ ባዞን ታ ኣዛዞ ቦላ ማካሊዴታ፤ ኩሜꬃ ማባራይ ማሪባ ሃꬃ ኣቻን ዲሼ ታ ቦላ ማካሊዳ ዎዴ ኢንቴ ኢስራኤሌ ኣሳ ሲንꬃን ታ ዱማቴꬃ ማላ ታና ቦንቻናስ ኣማኔቲቤኬታ» ጊዴስ፤ ማሪባይ ጺኔ ባዞን ቃዴሴን ዲዛ ፑልቶ ሃꬃ። ");
INSERT INTO gmve_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","ሙሴይካ ጎዳኮ ሂዝጊ ዎሲዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«ኣስ ኡባስ ዴኦ ኢሚዳ ጎዳዉ! ሃይሳ ዴራ ሄሚዛ ኣስ ኔኒ ዶራ፤ ");
INSERT INTO gmve_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ጋሶይካ ሃይሳ ኔ ዴሬዚ ሄሚዛይ ባይንዳ ዉዴ ማላ ጊዶንታ ማላ ኢዚ ዴራ ኬሲዛዴኔ ጌልꬂዛዴ፥ ዴሬዛካ ካሌꬂዛዴ ጊዳና።» ");
INSERT INTO gmve_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","ጎዳይካ ሙሴስ፥ «ሎኦ ኣያናይ ኢዛን ዲዛ ናዌ ና ኢያሶ ኔኮ ኤካዳ ኔ ኩሼ ኢዛ ቦላ ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ቄሴዛ ኤልኤዜሬ ሲንꬃኒኔ ኩሜꬃ ኢስራኤሌ ኣሳ ሲንꬃን ኔ ኢዛ ኤሳዳ ኢዚ ኔ ኦላ ዶሬቲዳይሳ ኣሳ ኤሪሳ። ");
INSERT INTO gmve_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","ኩሜꬃ ኢስራኤሌ ማባራይ ኢዛስ ኣዛዜታና ማላ ኔስ ዲዛ ማታፔ ኢዛስ ሻካ ኢማ። ");
INSERT INTO gmve_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ቄሴ ኤልኤዜሬይ ኡሪሜን ጎዳ ሼኔ ሻኪ ኤሪዛ ጊሻስ ኢዚ ኢያሶ ማዳና፤ ሄሳ ጊሻስ ኢያሶይኔ ኩሜꬃ ኢስራኤሌ ማባራይ ኤልኤዜሬ ኣዛዞን ኬዛናኔ ጌላና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","ሙሴይካ ጎዳይ ኢዛ ኣዛዚዳ ማላ ኦꬂዴስ፤ ኢያሶካ ኤፊዲ ቄሴ ኤልኤዜሬ ሲንꬃኒኔ ኩሜꬃ ኢስራኤሌ ኣሳ ሲንꬃን ኤሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ጎዳይ ኢዛ ኣዛዚዳ ማላ ሙሴይ ባ ኩሼ ኢያሶ ቦላ ዎꬂዲ ኢዛ ባሶሆዛን ዶሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","ጎዳይ ሙሴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«ኔኒ ኢስራኤሌ ኣሳስ፥ ‹ኢዛ ሳዎይ ቱኑ ጊ ታና ኡፋይሳና ማላ ጹጌቲዛ ካꬃ ያርሾ ዎዴን ዎዴን ናጊዲ ኢስቲ ታስ ሺሻና ማላ ኔ ኢስታ ኣዛዛ› ጋ ዮታ። ");
INSERT INTO gmve_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","ቃሴካ ኢስታስ፥ ‹ታማን ጹጌቲዲ ታስ ሺቃና ያርሾይ ሃይሳፌ ካሊዛይሳ፤ ኢስታ ቦላ ዎሶይ ባይንዳ ላይꬅ ጊዲዛ ናምኡ ꬋርሾ ላቃታ ጋላስ ጋላስ ሺቂ ጹጌቲዛ ያርሾስ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ኢሲ ላቃ ማላዶ ናምኣንꬆዛ ኦማርሳ ዎዴ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ኢሲ ኢሲ ላቃራ ኢሲ ኪሎ ጊዲዛ ሊቆ ꬊሌ ኢሲ ሊቲሮ ጊዲዛ ዎጋራ ዛይቴን ሙኑቄቲዲ ካꬃ ያርሾ ጊዲ ሺቆ። ");
INSERT INTO gmve_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","ሄሲካ ጋላስ ጋላስ ሺቂዛ ጹጌቲዛ ያርሾ፤ ሄሳ ማላ ያርሾ ሳዎይ ታና ጎዳ ኡፋይሲዛ ያርሾ ጊዲዲ ኮይሮ ሲና ዙማ ቦላ ሺቃና ማላ ዎጋይ ዎꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","ኮይሮ ላቃዛራ ሺቂዛ ኡሻ ያርሾይ ኢሲ ሊቲሮ ጊዲዛ ሚኖ ኡሹ ጌሻሶዛን ጎዳስ ጉሲቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","ኦማርሳ ዎዴ ናምኣንꬆ ላቃዛ ኮይሮይሳꬆካ ኡሻ ያርሾዛ ጉጂዲ ሺሺቴ፤ ሄሳ ሳዎይካ ጎዳ ኡፋይሲዛ ካꬃ ያርሾ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","« ‹ሳምባታ ጋላስ፥ ላይꬅ ጊዲዳ ዎሶይ ኢስታ ቦላ ባይንዳ ናምኡ ꬋርሾ ላቃታ፥ ኡሻ ያርሾራኔ ናምኡ ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂዲ ካꬃ ያርሾ ሂስቲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","ሃይሲ ሃ ያርሾዚ ኡሻ ያርሾዛፔኔ ጋላስ ጋላስ ጹጌቲዛ ያርሾዛፔ ሳምባታ ጋላስ ጋላስ ሺቂዛ ሃራ ጹጌቲዛ ያርሾ። ");
INSERT INTO gmve_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","« ‹ኣጊናን ኣጊናን ኮይሮ ጋላስ ጋላስ ኢስታ ቦላ ዎሶይ ባይንዳ ናምኡ ሚርጎታ፥ ኢሲ ꬋርሾኔ ላይꬅ ኩሚዳ ላፑን ꬋርሾ ላቃታ ጎዳስ ጹጌቲዛ ያርሾ ሂስቲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ኢሲ ኢሲ ሚርጎራ ካꬃ ያርሾስ ሄꬑ ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂዲ ሺሺቴ፤ ቃሴ ꬋርሾዛራ ካꬃ ያርሾስ ናምኡ ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂ ሺሺቴ፤ ");
INSERT INTO gmve_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ኢሲ ኢሲ ꬋርሾ ላቃራ ካꬃ ያርሾስ ኢሲ ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂ ሺሺቴ፤ ሄ ጹጌቲዛ ያርሾታ ኡባ ሳዎይ ጎዳ ኡፋይሲዛ ካꬃ ያርሾ ጊዲ ሺቆ። ");
INSERT INTO gmve_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ኢሲ ኢሲ ሚርጎራ ናምኡ ሊቲሮ ጊዲዛ ዎይኔ ኡሹ፥ ꬋርሾዛራ ኢሲ ሊቲሮኔ ሳይሶ ጊዲዛ ዎይኔ ኡሹኔ ኢሲ ኢሲ ላቃራ ኢሲ ሊቲሮ ጊዲዛ ዎይኔ ኡሹ ያርሾስ ሺሺቴ፤ ሄሲካ ኣጊናን ኣጊናን ላይꬅ ኩሜꬅ ሺቂዛ ጹጌቲዛ ያርሾ። ");
INSERT INTO gmve_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","ጋላስ ጋላስ ጹጌቲዛ ያርሾኔ ኢዛራ ሺቂዛ ኡሻ ያርሾዛ ቦላ ዴይሻ ኦርጌ ናጋራ ጊሻስ ያርሾ ጊዳና ማላ ጎዳ ሲንꬅ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","« ‹ጎዳስ ፓዚጋ ባኣሌ ኮይሮ ኣጊናይ ጌሊዳ ታማኔ ኦይዳንꬆ ጋላስ ቦንቺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ሃ ኣጊናይ ጌሊዳ ታማኔ ኢቻሻንꬆ ጋላሳፌ ዶሚዲ ኡኬꬃ ባኣሌ ቦንቺቴ፤ ሄ ጋላሳፌ ቢዲ ላፑን ጋላስ ጋካናስ ኡኬꬅ ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ባኣሌዛስ ኮይሮ ጋላስ ጎይናናስ ሺቂቴ፤ ሄ ጋላስ ኣይ ኦሶካ ኦꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","ኢስታ ቦላ ዎሶይ ባይንዳ 2 ሚርጎታ፥ ኢሲ ꬋርሾኔ ላይꬅ ኩሚዳ ላፑን ꬋርሾ ላቃታ ጹጌቲዛ ያርሾ ሂስቲ ጎዳስ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","ኢሲ ኢሲ ሚርጎራ ካꬃ ያርሾስ ሄꬑ ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂዲ ሺሺቴ፤ ቃሴ ꬋርሾዛራ ካꬃ ያርሾስ ናምኡ ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ኢሲ ኢሲ ꬋርሾ ላቃራ ካꬃ ያርሾስ ኢሲ ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","ቃሴካ ናጋራ ዉርሳናስ ዴይሻ ኦርጌ ናጋራ ያርሾስ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","ሄይቲ ዉሪካ ሺቃናይ ኡባ ዎዴ ማላዶ ማላዶ ጹጌቲ ሺቂዛ ያርሾራ ኢሲፌ ሺቄቶ። ");
INSERT INTO gmve_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","ጎዳ ሳዎ ቱኑ ጊዲ ኡፋይሲዛ ካꬃ ያርሾ ላፑን ጋላስ ኩሜꬅ ኢሲ ማላን ሺሺቴ፤ ሄሳካ ጋላስ ጋላስ ሺቂዛ ጹጌቲዛ ያርሾ ቦላኔ ኡሻ ያርሾ ቦላ ጉጂዲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ላፑንꬆ ጋላስ ጎይናናስ ሺቂቴ፤ ሄ ጋላስ ኣይ ኦሶካ ኦꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","« ‹ካꬃ ሺሾን ባኣሌ ቦንቺዛ ኮይሮ ጋላስ ኢንቴ ኦራꬅ ጋኪዛ ካꬃፌ ጼራ ጎዳስ ሺሺዛ ጋላስ ጎይናና ሺቂቴፔ ኣቲን ሃራ ኣይ ኦሶካ ኦꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","ናምኡ ሚርጎታ፥ ኢሲ ꬋርሾኔ ላይꬅ ኩሚዳ ላፑን ꬋርሾ ላቃታ ሳዎ ቱኑ ጊዲ ጎዳ ኡፋይሲዛ ጹጌቲዛ ያርሾ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ኢሲ ኢሲ ሚርጎራ ካꬃ ያርሾስ ሄꬑ ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂዲ ሺሺቴ፤ ቃሴ ꬋርሾዛራ ካꬃ ያርሾስ ናምኡ ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂ ሺሺቴ፤ ");
INSERT INTO gmve_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ኢሲ ኢሲ ꬋርሾ ላቃራ ካꬃ ያርሾስ ኢሲ ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","ቃሴካ ናጋራ ዉርሳናስ ዴይሻ ኦርጌ ናጋራ ያርሾስ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","ሄሳ ሄ ያርሾዛ ኡባ ኡሻ ያርሾራ፥ ሄ ጋላስ ሺቂ ጹጌቲዛ ያርሾዛኔ ካꬃ ያርሾዛ ቦላ ጉጂዲ ሺሺቴ፤ ሄ ያርሾ ሜሄቲ ዎሶይ ባይንዳይታ ጊዲዳይሳ ሻኪ ኤሪቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","« ‹ላፑንꬃ ኣጊናይ ጌሊዳ ኮይሮ ጋላስ ጎይናናስ ሺቂቴ፤ ሄ ጋላስ ኣይ ኦሶካ ኦꬆፍቴ፤ ሄ ጋላሳይ ዛዬይ ፑኔቲዛ ጋላሳ። ");
INSERT INTO gmve_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","ኢስታ ቦላ ዎሶይ ባይንዳ ኢሲ ሚርጎ፥ ኢሲ ꬋርሾኔ ላይꬅ ኩሚዳ ላፑን ꬋርሾ ላቃታ ሳዎይ ቱኑ ጊዲ ጎዳ ኡፋይሲዛ ጹጌቲዛ ያርሾ ያርሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ኢሲ ሚርጎዛራ ካꬃ ያርሾስ ሄꬑ ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂዲ ሺሺቴ፤ ቃሴ ꬋርሾዛራ ካꬃ ያርሾስ ናምኡ ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ኢሲ ኢሲ ꬋርሾ ላቃራ ካꬃ ያርሾስ ኢሲ ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","ቃሴካ ናጋራ ዉርሳናስ ዴይሻ ኦርጌ ናጋራ ያርሾስ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ኢንቴ ሃይሳ ሃ ያርሾዛ ጋላስ ጋላሲኔ ኣጊናን ኣጊናን ኮይሮ ጋላስ ሺቂ ጹጌቲዛ ያርሾዛ፥ ካꬃ ያርሾዛኔ ኡሻ ያርሾዛ ቦላ ጉጂዲ ሺሺቴ፤ ሄይታንቲካ ሳዎ ቱኑ ጊዲ ጎዳ ኡፋይሲዛ ጹጌቲዛ ያርሾታ። ");
INSERT INTO gmve_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","« ‹ላፑንꬆ ኣጊናይ ጌሊዳ ታማንꬃ ጋላስ ጎይናናስ ሺቂቴ፤ ሄ ጋላስ ጾሚቴ፤ ኦሶካ ኦꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","ኢስታ ቦላ ዎሶይ ባይንዳ ኢሲ ሚርጎ፥ ኢሲ ꬋርሾኔ ላይꬅ ኩሚዳ ላፑን ꬋርሾ ላቃታ ሳዎይ ቱኑ ጊዲ ጎዳ ኡፋይሲዛ ጹጌቲዛ ያርሾ ያርሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","ኢሲ ሚርጎዛራ ካꬃ ያርሾስ ሄꬑ ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂዲ ሺሺቴ፤ ቃሴ ꬋርሾዛራ ካꬃ ያርሾስ 2 ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ኢሲ ኢሲ ꬋርሾ ላቃራ ካꬃ ያርሾስ ኢሲ ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","ናጋራ ዉርሳናስ ሺቂዛ ያርሾስ፥ ካꬃ ያርሾፌ፥ ኡሻ ያርሾፌኔ ጋላስ ጋላስ ሺቂ ጹጌቲዛ ያርሾፌ ሃራ ዴይሻ ኦርጌ ጉጂዲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","« ‹ላፑንꬃ ኣጊናይ ጌሊዳ ታማኔ ኢቻሻንꬆ ጋላስ ጎይናናስ ሺቂቴ፤ ሄ ጋላስ ኣይ ኦሶካ ኦꬆፍቴ፤ ላፑን ጋላስ ጋካናስ ጎዳስ ዳሴ ባኣሌ ቦንቺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","ሃ ኮይሮ ጋላስ ኢስታ ቦላ ዎሶይ ባይንዳ 13 ሚርጎታ፤ ናምኡ ꬋርሾታኔ ላይꬅ ኩሚዳ ታማኔ ኦይዱ ꬋርሾ ላቃታ ሳዎ ቱኑ ጊዲ ጎዳ ኡፋይሲዛ ጹጌቲዛ ያርሾ ሂስቲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","ኢሲ ኢሲ ሚርጎራ ካꬃ ያርሾስ 3 ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂዲ ሺሺቴ፤ ቃሴ ኢሲ ኢሲ ꬋርሾራ ካꬃ ያርሾስ 2 ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ኢሲ ኢሲ ꬋርሾ ላቃራ ካꬃ ያርሾስ ኢሲ ኪሎ ጊዲዛ ሊቆ ꬊሌ ዎጋራ ዛይቴን ሙኑቂ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","« ‹ናጋራ ዉርሳናስ ሺቂዛ ያርሾስ፥ ካꬃ ያርሾፌ፥ ኡሻ ያርሾፌኔ ጋላስ ጋላስ ሺቂ ጹጌቲዛ ያርሾፌ ሃራ ዴይሻ ኦርጌ ጉጂዲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","« ‹ናምኣንꬆ ጋላስ ኢስታ ቦላ ኣይ ዎሶይ ባይንዳ 12 ሚርጎታ፥ 2 ꬋርሾታኔ ላይꬂ ኩሚዳ 14 ꬋርሾ ላቃታ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","ሚርጎታራ፥ ꬋርሾታራኔ ꬋርሾ ላቃታራ ኢሲፌ ሺቂዛ ካꬃ ያርሾዛኔ ኡሻ ያርሾዛ ካሴ ዎጋን ዎꬊዳ ቆዳ ማላ ያርሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","ናጋራ ዉርሳናስ ሺቂዛ ያርሾስ፥ ካꬃ ያርሾፌ፥ ኡሻ ያርሾፌኔ ጋላስ ጋላስ ሺቂ ጹጌቲዛ ያርሾፌ ሃራ ዴይሻ ኦርጌ ጉጂዲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","« ‹ሄꬓንꬆ ጋላስ ኢስታ ቦላ ዎሶይ ባይንዳ ታማኔ ኢሲ ሚርጎታ፥ ናምኡ ꬋርሾታኔ ላይꬂ ኩሚዳ ታማኔ ኦይዱ ꬋርሾ ላቃታ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","ሚርጎታራ፥ ꬋርሾታራኔ ꬋርሾ ላቃታራ ኢሲፌ ሺቂዛ ካꬃ ያርሾዛኔ ኡሻ ያርሾዛ ካሴ ዎጋን ዎꬊዳ ቆዳ ማላ ያርሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","ናጋራ ዉርሳናስ ሺቂዛ ያርሾስ፥ ካꬃ ያርሾፌ፥ ኡሻ ያርሾፌኔ ጋላስ ጋላስ ሺቂ ጹጌቲዛ ያርሾፌ ሃራ ዴይሻ ኦርጌ ጉጂዲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","« ‹ኦይዳንꬆ ጋላስ ኢስታ ቦላ ዎሶይ ባይንዳ ታሙ ሚርጎታ፥ ናምኡ ꬋርሾታኔ ላይꬂ ኩሚዳ ታማኔ ኦይዱ ꬋርሾ ላቃታ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ሚርጎታራ፥ ꬋርሾታራኔ ꬋርሾ ላቃታራ ኢሲፌ ሺቂዛ ካꬃ ያርሾዛኔ ኡሻ ያርሾዛ ካሴ ዎጋን ዎꬊዳ ቆዳ ማላ ያርሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","ናጋራ ዉርሳናስ ሺቂዛ ያርሾስ፥ ካꬃ ያርሾፌ፥ ኡሻ ያርሾፌኔ ጋላስ ጋላስ ሺቂ ጹጌቲዛ ያርሾፌ ሃራ ዴይሻ ኦርጌ ጉጂዲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","« ‹ኢቻሻንꬆ ጋላስ ኢስታ ቦላ ዎሶይ ባይንዳ ኡዱፉን ሚርጎታ፥ ናምኡ ꬋርሾታኔ ላይꬂ ኩሚዳ ታማኔ ኦይዱ ꬋርሾ ላቃታ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","ሚርጎታራ፥ ꬋርሾታራኔ ꬋርሾ ላቃታራ ኢሲፌ ሺቂዛ ካꬃ ያርሾዛኔ ኡሻ ያርሾዛ ካሴ ዎጋን ዎꬊዳ ቆዳ ማላ ያርሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","ናጋራ ዉርሳናስ ሺቂዛ ያርሾስ፥ ካꬃ ያርሾፌ፥ ኡሻ ያርሾፌኔ ጋላስ ጋላስ ሺቂ ጹጌቲዛ ያርሾፌ ሃራ ዴይሻ ኦርጌ ጉጂዲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","« ‹ኡሱፑንꬆ ጋላስ ኢስታ ቦላ ዎሶይ ባይንዳ ኦስፑን ሚርጎታ፥ ናምኡ ꬋርሾታኔ ላይꬅ ኩሚዳ ታማኔ ኦይዱ ꬋርሾ ላቃታ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","ሚርጎታራ፥ ꬋርሾታራኔ ꬋርሾ ላቃታራ ኢሲፌ ሺቂዛ ካꬃ ያርሾዛኔ ኡሻ ያርሾዛ ካሴ ዎጋን ዎꬊዳ ቆዳ ማላ ያርሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","ናጋራ ዉርሳናስ ሺቂዛ ያርሾስ፥ ካꬃ ያርሾፌ፥ ኡሻ ያርሾፌኔ ጋላስ ጋላስ ሺቂ ጹጌቲዛ ያርሾፌ ሃራ ዴይሻ ኦርጌ ጉጂዲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","« ‹ላፑንꬃ ጋላስ ኢስታ ቦላ ዎሶይ ባይንዳ ላፑን ሚርጎታ፥ ናምኡ ꬋርሾታኔ ላይꬅ ኩሚዳ ታማኔ ኦይዱ ꬋርሾ ላቃታ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","ሚርጎታራ፥ ꬋርሾታራኔ ꬋርሾ ላቃታራ ኢሲፌ ሺቂዛ ካꬃ ያርሾዛኔ ኡሻ ያርሾዛ ካሴ ዎጋን ዎꬊዳ ቆዳ ማላ ያርሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","ናጋራ ዉርሳናስ ሺቂዛ ያርሾስ፥ ካꬃ ያርሾፌ፥ ኡሻ ያርሾፌኔ ጋላስ ጋላስ ሺቂ ጹጌቲዛ ያርሾፌ ሃራ ዴይሻ ኦርጌ ጉጂዲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","« ‹ኦስፑንꬃ ጋላስ ኢሲ ቦላ ጎይናናስ ሺቂቴ፤ ሄ ጋላስ ኣይ ኦሶካ ኦꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","ኢስታ ቦላ ዎሶይ ባይንዳ ኢሲ ሚርጎ፥ ኢሲ ꬋርሾኔ ላይꬅ ኩሚዳ ላፑን ꬋርሾ ላቃታ ሳዎ ቱኑ ጊዲ ጎዳ ኡፋይሲዛ ጹጌቲዛ ያርሾ ሂስቲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","ሚርጎታራ፥ ꬋርሾታራኔ ꬋርሾ ላቃታራ ኢሲፌ ሺቂዛ ካꬃ ያርሾዛኔ ኡሻ ያርሾዛ ካሴ ዎጋን ዎꬊዳ ቆዳ ማላ ያርሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","ናጋራ ዉርሳናስ ሺቂዛ ያርሾስ፥ ካꬃ ያርሾፌ፥ ኡሻ ያርሾፌኔ ጋላስ ጋላስ ሺቂ ጹጌቲዛ ያርሾፌ ሃራ ዴይሻ ኦርጌ ጉጂዲ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","« ‹ኢንቴስ ዎꬊዳ ባኣሌ ጋላሳታን ጎዳስ ሺሺቴ፤ ሄሲካ ኢንቴ ኣዲኔቲዲ ሺሺዛ ያርሾፌኔ ኢንቴ ኢንቴ ዶሳን ሺሺዛ ያርሾፌ ጹጌቲዛ ሃራ ያርሾ፥ ካꬃ ያርሾ፥ ኡሻ ያርሾኔ ኢሲፌቴꬃ ያርሾ ሺሺቴ› ጋ።» ");
INSERT INTO gmve_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","ሙሴይካ ጎዳይ ኢዛ ኣዛዚዳ ማላ ኢስራኤሌ ኣሳስ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","ሙሴይ ኢስራኤሌ ኣሳ ካሌꬂዛ ኮራፒኔታስ፥ «ጎዳይ ኣዛዚዳ ኣዛዞይ ሃይሳፌ ካሊዛይሳ፥ ");
INSERT INTO gmve_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","ኢሲ ኣሲ ጎዳስ ኢሲ ሚሽ ኦꬃናስ ኣዲኔቲኮ ዎይኮ ኢሳዴይ ጫቂ ጌፒዲ ባና ባርካ ባ ቃላን ቃቺኮ ኢዚ ባ ጌሊዳ ቃላ ኡባ ፖላና ቤሴስ ኣቲን ባ ጊዳይሳ ኣጋናስ ቤሴና። ");
INSERT INTO gmve_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","«ኢሲ ጌላኦያ ባ ኣዋ ሶን ዳሼ ጎዳስ ኢሲ ሚሽ ኦꬃናስ ኣዲኔቲኮ ዎይኮ ጫቃ ጌፓዳ ባና ባርካ ባ ቃላን ቃቺዛ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ኢዚ ኣዋይ ሄሳ ሲዪዲ ኢዞ ዲጎንታ ኣጊኮ ኢዛ ባ ኣዲኔቲዳይሳ ዎይኮ ባ ጫቃ ጌፒዳ ቃላዛ ፖላናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","ኢዚ ኣዋይ ሄ ዮኦዛ ሲዪዲ ኢዞ ዲጊዛ ጊዲኮ ኢዛ ኣዲኔቲዳ ኣዲናይ ዎይኮ ኢዛ ጫቃ ጌፒዳ ቃላይ ኢዚስ ጎሜ ጊዴና፤ ጋሶይካ ኢዚ ኣዋይ ኢዞ ዲጊዳ ጊሻስ ጎዳይ ኢዞ ማራና። ");
INSERT INTO gmve_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","«ኣዚና ጌሎንታ ማጫሲ ኣኬካዳ ዎይኮ ኣኬኮንታ ኣዲና ኣዲኔታ ኡታዳ ዎይኮ ጫቃ ጌፓዳ ባና ባርካ ባ ቃላን ቃቻ ዎꬃዳ ኣዚና ጌሊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ኢዛ ጌሊዳ ኣዚናዚ ሄ ዮኦዛ ሲዪዲ ኢዞ ዲጎንታ ኣጊኮ ኢዛ ባ ጊዳይሳ ኡባ ፖላናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ኢዚ ኣዚናይ ሄ ዮኦዛ ሲዪዲ ኢዞ ዲጊዛ ጊዲኮ ኢዛ ኣዲኔቲዳ ኣዲናይ ዎይኮ ኢዛ ጫቃ ጌፒዳ ቃላይ ኢዚስ ጎሜ ጊዴና፤ ጋሶይካ ኢዚ ኣዚናይ ኢዞ ዲጊዳ ጊሻስ ጎዳይ ኢዞ ማራና። ");
INSERT INTO gmve_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","«ኣዚናይ ሃይቂዳ ማጫሲ ዎይኮ ኣዚናይ ኣንጂ ዬዲዳ ማጫሲ ኢሲ ሚሽ ኦꬃናስ ኣዲኔቲኮ ዎይኮ ጫቃ ጌፓዳ ባና ባርካ ባ ቃላን ቃቺዳ ጊዲኮ ኢዛ ባ ጌሊዳ ቃላ ፖላናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","«ኣዚና ጌሊዳ ማጫሲ ኢሲ ሚሽ ኦꬃናስ ኣዲኔቲኮ ዎይኮ ጫቃ ጌፓዳ ባና ባርካ ባ ቃላን ቃቺዳ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","ኢዛ ጌሊዳ ኣዚናዚ ሄ ዮኦዛ ሲዪዲ ኢዞ ዲጎንታ ኣጊኮ ኢዛ ባ ጊዳይሳ ኡባ ፖላናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","ኢዚ ኣዚናይ ሄ ዮኦዛ ሲዪዲ ኢዞ ዲጊዛ ጊዲኮ ኢዛ ኣዲኔቲዳ ኣዲናይ ዎይኮ ኢዛ ጫቃ ጌፒዳ ቃላይ ኢዚስ ጎሜ ጊዴና፤ ጋሶይካ ኢዚ ኣዚናይ ኢዞ ዲጊዳ ጊሻስ ጎዳይ ኢዞ ማራና። ");
INSERT INTO gmve_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","ኢዚ ኣዚናይ ኣይ ኣዲና ዎይኮ ጫቃ ጌፓዳ ባና ባርካ ቃቺዳ ቃላ ዲጋናስ ዎይኮ ፖሊሳናስ ኢዛስ ማታይ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","ኢዚ ኣዚናይ ሄ ዮኦዛ ሲዪዳ ማላ ዎንቴꬃ ጋላስ ኣይኮካ ቃቶንታ ጮኡ ጊኮ ኢዛ ባ ጊዳይሳ ኡባ ፖላናስ ቤሴስ፤ ሄ ዮኦዛ ሲዪዳ ማላ ኣይኮካ ቃቶንታ ጮኡ ጊኮ ሄሲ ኢዚ ኤሮ ጊዳይሳ ቆንጪሴስ። ");
INSERT INTO gmve_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","ጊዶ ኣቲን ኢዚ ኣዚናይ ጋምኢዲ ሄ ኢዚ ኣዲናዛ ዲጊዛ ጊዲኮ ኣላፌቴꬃን ኦይሼታናይ ኢዛ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ጌላኦይኔ ጌሊዳ ማጫሲ ኣዲና ኣዲኔቲኮ ዎይኮ ጫቃ ጌፓዳ ባርካ ባና ባ ቃላን ቃቺዳ ጊዲኮ ኢዚ ኣዋስ ዎይኮ ኢዚ ኣዚናስ ዲዛ ኣላፌቴꬃኔ ማታ ጊሻስ ጎዳይ ሙሴስ ኢሚዳ ዎጋይ ሃይሳ። ");
INSERT INTO gmve_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","ጎዳይ ሙሴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«ሚዲያሜ ኣሳይ ኢስራኤሌ ኣሳ ቦላ ጋꬂዳ ቆሆዛ ጊሻስ ኔኒ ሚዲያሜ ኣሳ ሃሎ ኬሳ፤ ሄሳ ኦꬂዳፔ ጉዬ ኔኒ ሃይቃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","ሄሳ ጊሻስ ሙሴይ ዴሬዛስ፥ «ሚዲያሜ ኣሳይ ጎዳ ቦላ ካሴ ኦꬂዳ ቆሆዛ ጊሻስ ኢንቴ ሃሎ ኬሳናስ ኦላስ ጊጌቲቴ። ");
INSERT INTO gmve_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ኢስራኤሌ ኣሳ ዛርኬፌ ዛርኬፌ ኢሲ ኢሲ ሺ ኣቱማስ ዶሪዲ ጌዴ ኦላስ ዬዲቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","ሄሳ ጊሻስ ኢስራኤሌ ዛርኬታፔ ኢሲ ኢሲ ሺ ኣስ ኬሲ ኢሚን 12,000 ኣሲ ኦላስ ጊጼቲዲ ጊጌቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","ሙሴይካ ኢሲ ኢሲ ዛርኬፌ ኢሲ ኢሲ ሺ ኣሲ ቄሴ ኤልኤዜሬ ና ፊኒሃሴ ካሌꬆን ኦላስ ዬዲዴስ፤ ፊኒሃሲካ ጌሻሶዛፔ ዱማ ሚሻታኔ ኦላስ ዴንꬄꬂዛ ዛዬታ ባ ኩሼን ኦይኪዲ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","ኢስቲካ ጎዳይ ሙሴ ኣዛዚዳ ማላ ሚዲያሜ ኣሳ ኦሊዲ ኣቱማሳ ሙሌራ ዎꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","ሃይቂዳይታ ጊዶን ሚዲያሜ ካዎ ኢቻሻቲ ኤዋይ፥ ኤሬቄሜይ፥ ጹሬይ፥ ኡሬይኔ ኤሬባኤይ ዴቴስ፤ ቢኦሬ ና ባላሜካ ማሻን ዎꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ኢስራኤሌ ኣሳይ ሚዲያሜ ማጫሳታኔ ጉꬃ ናይታ ዲኢዲ ኢስታ ሜሄታኔ ኢስታ ኣቆታ ኡባ ፒቲ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","ኢስቲ ዲዛ ካታማታኔ ኢስቲ ዲዛ ጉታታ ኡባ ታማን ጹጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","ኢስታ ኣሳ፥ ሜሃኔ ዲኢዳ ሚሽ ኡባ ኤኪዳ። ");
INSERT INTO gmve_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ዮርዳኖሴ ሻፋፔ ሄ ፒንꬃ ጊናራ ዲዛ ሞኣቤ ዴምባን ዱንካኒ ኡቲዳ ሙሴኮ፥ ቄሴ ኤልኤዜሬኮኔ ኩሜꬃ ኢስራኤሌ ማባራኮ ኤሂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","ሙሴይ ቄሴ ኤልኤዜሬይኔ ማባራ ካሌꬂዛይቲ ኦላ ኣሳ ሞካናስ ጌዴ ኬዚዳ። ");
INSERT INTO gmve_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","ሙሴይ ጊዲኮ ኦላሶፔ ሃ ሲሚዛ ኦላ ኣሳ ኣዛዚዛ ሻላቃታ ቦላኔ ማቶ ሃላቃታ ቦላ ሃንቄቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","ኢዚካ ኢስታስ፥ «ሃይሳ ማጫስ ኡባ ኣዛስ ዎꬎንታ ሼምፖራ ፓጻ ኣጊዴቲ? ");
INSERT INTO gmve_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","ኑኒ ካሴ ፔኦሬን ዲሺን ሃይቲ ባላሜ ዞሬ ኤኪዲ ኢስራኤሌ ኣሳይ ባ ጎዳፔ ሃካና ማላኔ ቦሻን ዉራና ማላ ኦꬂዳይ ኢስታ ጊዴቴኔ! ");
INSERT INTO gmve_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ሄሳ ጊሻስ ኣቱማ ናይታ ኡባኔ ኣዴራ ጋይቲዳ ማጫሳታ ኡባ ዎꬊቴ። ");
INSERT INTO gmve_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","ጊዶ ኣቲን ኣዴራ ጋይቲ ኤሮንታ ጌላኦታ ዎꬎንታ ኢንቴስ ኣሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","«ኢንቴ ጋርሳን ኣስ ዎꬊዳዴይ ዎይኮ ኣሃ ቦቺዳ ኣሲ ዉሪካ ላፑን ጋላስ ጋካናስ ኣሲ ዲዛሶፔ ሃራሶን ጋምኦ፤ ሄꬓንꬃ ጋላሲኔ ላፑንꬃ ጋላስ ኢንቴናኔ ኢንቴ ዲኢ ኤሂዳ ማጫሳታ ጌሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","ሄሳꬆካ ኣይ ማይኦ ዎይኮ ጋልባፌ፥ ዴይሻ ኢስኬፌኔ ሚꬃፌ ኦሴቲዳ ሚሽ ኡባ ጌሺቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ቄሴ ኤልኤዜሬይ ኦላፔ ሲሚዳ ኣቱማሳስ፥ «ጎዳይ ሙሴስ ኢሚዳ ዎጋቲ ሃይሳፌ ካሊዛይታ፤ ");
INSERT INTO gmve_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","ዎርቃይ፥ ቢራይ፥ ጻርቂማላይ፥ ቢራታይ፥ ቆርቆሮይኔ ኢርሳሴይ፥ ");
INSERT INTO gmve_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ሄሳꬆካ ታማይ ኢስታ ቆሆንታይቲ ታማ ጊዶራ ኣꬊዲ ጌያናስ ቤሴስ፤ ታማ ዳንዳዮንታ ኣይ ሚሺካ ካሴ ዎꬊዳ ዎጋ ማላ ጌሾስ ጊጌቲዳ ሃꬃን ጌሺቴ። ");
INSERT INTO gmve_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ኢንቴ ኢንቴ ማይኦ ላፑንꬃ ጋላስ ሜጪቴ፤ ሄሳፌ ጉዬ ኢንቴ ጌሽ ጊዲዛ ጊሻስ ሲሚዲ ካሴ ኢንቴ ዱንካኒ ዲዛሶ ጌላናስ ዳንዳዬታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«ኔኒ ቄሴ ኤልኤዜሬይኔ ዴራ ካሌꬂዛ ኮራፒኔታራ ጊዲዲ ዲኤቲ ዪዳ ኣሳኔ ሜሃ ቆዲቴ። ");
INSERT INTO gmve_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","ናምኡ ኬሲ ሻኪዲ ባጋ ኦላሶ ቢዳ ዎታዳራታስ ኣቶይሳ ሃንኮ ማባራስ ኢሚቴ። ");
INSERT INTO gmve_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","ዎታዳራታ ጊሻፔ ዲኤቲዳ ኣሳፔ፥ ሚዛታፔ፥ ሃሬታፔ ዶርሳታፔኔ ዴይሻታፔ ኢቻሹ ጼታፔ ኢሲኖ ታስ ጎዳስ ዱማ ኢሞታ ሂስቲ ሻኪቴ። ");
INSERT INTO gmve_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","ሄ ኢንቴ ታስ ጎዳስ ሻኪዳይሳ ታ ጊሻዛ ቄሴ ኤልኤዜሬስ ኢሚቴ። ");
INSERT INTO gmve_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ሂንኮ ማባራስ ኢሜቲዳ ጊሻፔ፥ ኣሳፔ፥ ሚዛፔ፥ ዶርሳታፔ፥ ዴይሻታፔኔ ሃሬታፔ ኢቻሽ ታማፌ ኢሲኖ ጋይቶቴꬃ ዱንካኔን ኣላፌቴꬃን ኦꬂዛ ሌዌታስ ኢሚቴ።» ");
INSERT INTO gmve_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","ሙሴይኔ ኤልኤዜሬይ ጎዳይ ኢስታ ኣዛዚዳይሳ ኡባ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","ዎታዳራቲ ባንታስ ኤኪሺን ኣቲዳይሲ፥ 675,000 ዶርሳታኔ ዴይሻታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","ላፑን ታማኔ ናምኡ ሺ ሚዛታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","ኡሱፑን ታማኔ ኢሲ ሺ ሃሬታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ሄꬑ ታማኔ ናምኡ ሺ ኣዴ ኤሮንታ ጌላኦታ። ");
INSERT INTO gmve_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","ዲኤቲ ዪዳይሳፌ ባጋይ ኦሌቲ ዪዳይታስ ኢሜቲዴስ፤ ሄሲካ 337,500 ዶርሳታ። ");
INSERT INTO gmve_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ኢስታፌ 675 ጎዳስ ዱማ ኢሞታ ጌቴቲ ሻኬቲዳይታ። ");
INSERT INTO gmve_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ሚዛቲ 36,000፤ ኢስታፌ ጎዳስ ዱማ ኢሞታ ጊዲ ሻኬቲዳይቲ ላፑን ታማኔ ናምኣ። ");
INSERT INTO gmve_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","ሃሬቲ 30,500፤ ኢስታፌ ጎዳስ ዱማ ኢሞታ ጊዲ ሻኬቲዳይቲ ኡሱፑና። ");
INSERT INTO gmve_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","ኣዴ ኤሮንታ ጌላኦቲ 16,000፤ ኢስታፌ ጎዳስ ዱማ ኢሞታ ጊዲዲ ሻኬቲዳይቲ ሄꬑ ታማኔ ናምኣ። ");
INSERT INTO gmve_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","ሄሳ ጊሻስ ሙሴይ ጎዳይ ኢዛ ኣዛዚዳ ማላ ጎዳስ ዱማ ኢሞታ ሂስቲ ሻኪዳይሳ ቄሴ ኤልኤዜሬስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","ሃንኮ ኢስራኤሌ ማባራ ጊሻይ ኦላስ ኪቴቲዳ ዎታዳራታ ጊሻራ ኢሲ ጊና። ");
INSERT INTO gmve_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ሄሲካ 337,500 ዶርሳታኔ ዴይሻታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ሄꬑ ታማኔ ኡሱፑን ሺ ሚዛታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ሄꬑ ታሙ ሺያኔ ኢቻሹ ጼቱ ሃሬታ፥ ");
INSERT INTO gmve_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ታማኔ ኡሱፑን ሺ ኣዴ ኤሮንታ ጌላኦታ። ");
INSERT INTO gmve_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","ሄሳ ጊሻስ ሙሴይ ኢቻሽ ታማፌ ኢሲኖ ጎዳይ ኢዛ ኣዛዚዳ ማላ ጋይቶቴꬃ ዱንካኔን ኣላፌቴꬃን ኦꬂዛ ሌዌ ዛርኬታስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ሄሳፌ ጉዬ ኦላ ኣሳ ኣዛዚዛይቲ ሻላቃቲኔ ማቶ ሃላቃቲ ሙሴኮ ሺቂዲ፥ ");
INSERT INTO gmve_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","«ኑኒ ኔ ኦሳንቻቲ ኑፔ ጋርሳራ ኣዛዜቲዛ ዎታዳራታ ኡባ ቆዲዶስ፤ ኢስታፌ ኢሶይካ ፓጪቤና፤ ");
INSERT INTO gmve_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","ሄሳ ጊሻስ ኑኒ ኢሶይ ኢሶይ ኤኪዳ ዎርቃ ኣሌቆታ፥ ቶሆ ጊሞታ፥ ኩሼ ሳጋዮታ፥ ቢራꬌ ሚዲጋታ፥ ሃይꬃ ጉቲቻታ፥ ቆꬌን ኣꬊዛ ማጪፋራታ ኡባ ኑ ናጋራ ዉርሳናስ ጎዳስ ያርሾ ኢማናስ ኤኪ ዪዶስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","ሙሴይኔ ቄሴ ኤልኤዜሬይ ዎርቃፌ ኦሴቲዳ ኣሌቆታ ኡባ ኤኪዳ። ");
INSERT INTO gmve_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","ሻላቃታፔኔ ማቶ ሃላቃታፔ ኤኪዲ ሙሴይኔ ቄሴ ኤልኤዜሬይ ጎዳስ ኢሞታ ሂስቲ ሺሺዳ ዎርቃ ኣሌቆቲ 16,750 ሳቂሌ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","ጋርሳራ ዲዛ ዎታዳራቲ ጊዲኮ ባ ዲኢዳይሳ ባስ ባስ ኤኪ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","ሄሳ ጊሻስ ሙሴይኔ ቄሴ ኤልኤዜሬይ ሻላቃታፔኔ ማቶ ሃላቃታፔ ኤኪዳ ዎርቃ ኣሌቆታ ጎዳ ሲንꬃን ኢስራኤሌ ዴራ ሃሳኢሳና ማላ ጌዴ ጋይቶቴꬃ ዱንካኔዛኮ ኤኪ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","ኦሮቤሌ ዛርኬታሲኔ ጋዴ ዛርኬታስ ኬሂ ዳሮ ሜሄይ ዴስ፤ ኢያዜሬ ዴሬይኔ ጋላኣዴ ዴሬይ ሜሄስ ዳሮ ሎኦ ጊዲዳይሳ ቤይዳ። ");
INSERT INTO gmve_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ሄሳ ጊሻስ ኢስቲ ሙሴኮ፥ ቄሴ ኤልኤዜሬኮኔ ሃንኮ ማባራ ካሌꬂዛይታኮ ቢዲ፥ ");
INSERT INTO gmve_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","«ጎዳይ ኢስራኤሌ ኣሳን ጾኒሲዳ ኣጻሮቴ ዴሬይ፥ ዲቦኔ ዴሬይ፥ ኢያዜሬ ዴሬይ፥ ኒምራ ዴሬይ፥ ሃሴቦኔ ዴሬይ፥ ኤልኤሌ ዴሬይ፥ ሲቢማ ዴሬይ፥ ኔቦ ዴሬይኔ ባኦኔ ዴሬይ ሜሄስ ሎኦ፤ ኑስካ ዳሮ ሜሄይ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","ኢንቴ ኑስ ሎኦ ቆፒኮ ሃይሳ ሃ ዴሬዛ ኑስ ኢንቴ ኦሳንቻታስ ዳናሶ ሂስቲ ኢሚቴ ኣቲን ኑኒ ዮርዳኖሴ ፒናና ማላ ኦꬆፍቴ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","ሙሴይካ ኢስታስ፥ «ኢንቴ ኢሻቲ ኦላስ ቢሺን ኢንቴ ሃን ኣታናስ ኮዬቲ? ");
INSERT INTO gmve_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ኢስራኤሌ ኣሳይ ዮርዳኖሴ ፒኒዲ ጎዳይ ኢስታስ ኢሚዳ ዴሬዛ ጌሎንታ ማላ ኢንቴ ኣሳ ሂዶታ ኣዛስ ቃንጺሴቲ? ");
INSERT INTO gmve_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","ሃኖ ቢታዮ ጾሞሳና ማላ ቃዴሴ ባሪኔፔ ታኒ ካሴ ኢንቴ ኣዋታ ዬዲን ሃይሳꬆካ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","ኢስቲ ኤሽኮሌ ሾባ ጋካናስ ቢዲ ሄ ቢታዮ ጾሞሲ ጼሊዳ፤ ጊዶ ኣቲን ሄፔ ሲሚዲ ኢስራኤሌ ኣሳይ ጎዳይ ኢስታስ ኢሚዳ ዴሬዛ ጌሎንታ ማላ ሂዶታ ቃንጺሲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","11","ሄ ጋላስ ጎዳይ ኬሂ ሃንቄቲዲ፥ ‹ኢስቲ ኩሜꬃ ዎዚናፔ ታና ካሎንታ ኢጺዳ ጊሻስ ጊብጼፔ ኬዚዳ ኣሳፔ ላይꬃይ ናምኡ ታሙ ኩሚዳይቲኔ ሄሳፌ ቦላራ ጊዲዳይቲ ኡባይ ታኒ ኣብራሃሜስ፥ ዪሳቃሲኔ ያቆቤስ ኢማና ጋዳ ካሴ ጫቂዳ ቢታ ኢስቲ ሙሌካ ጌሎንታ ማላ ጫቃዲስ› ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","ሃይሲ ጎዳይ ጫቂ ቃቺዳ ቃላዚ ጎዳ ኩሜꬃ ዎዚናፔ ካሊዳ ቄናዜ ዴሬ ኣስ ዮፊኔ ና ካሌቤፔኔ ናዌ ና ኢያሶፔ ኣቲን ሃንኮ ኣሳ ኡባካ ቦቼስ። ");
INSERT INTO gmve_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","ጎዳይ ኢስራኤሌ ዴሬዛ ቦላ ሃንቄቲዳ ጊሻስ ሄ ኢዛ ሃንቄꬂዳ ዬሌታቲ ኡባይ ዉራና ጋካናስ ኢስቲ ባዞ ቢታን ኦይዱ ታሙ ላይꬅ ቶይላታና ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","ኢንቴኖ ናጋራንቻ ዬሌታቶ! ጎዳይ ኢስራኤሌ ዴሬ ቦላ ጉጂ ሃንቄታና ማላ ሃኢካ ኢንቴ ኢንቴ ኣዋታꬆ ኦꬄታ። ");
INSERT INTO gmve_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","ኢንቴ ኦሮቤሌ ዛርኬቲኔ ጋዴ ዛርኬቲ ጎዳ ካሎንታ ኢጺኮ ኢዚ ሃ ዴራ ኡባ ባዞን ኣጋጋና፤ ኢስታ ቦላ ጋኪዛ ሜቶ ኡባን ኢንቴ ኦይሼታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ኢስቲካ ሙሴኮ ሺቂዲ፥ «ኑኒ ኑ ሜሄታስ ኣቆሶ፥ ኑ ማቼታሲኔ ኑ ናይታስ ዱሳሶ ኦꬃና ኮዮስ። ");
INSERT INTO gmve_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ጊዶ ኣቲን ኑ ባጋ ኢስራኤሌ ኣሳይ ባስ ዱሳሶ ጊዲዳ ቢታዮ ጌሊዲ ኡታና ጋካናስ ኑ ኡባፌ ሲንꬃቲ ኦላስ ኬዛናስ ጊጌቲ ኡቲዶስ፤ ኑኒ ሄሳ ፖሊዲ ሲማና ጋካናስ ኑ ናይቲኔ ኑ ማቼቲ ሃይሳ ሃ ዴሬዛን ዲዛ ኣሳፔ ኢስታ ቦላ ቆሆይ ጋኮንታ ማላ ጊምቤቲዳ ካታማን ሂርጋይ ባይንዳ ዲሼቶ። ");
INSERT INTO gmve_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ኢስራኤሌ ኣሳይ ኡባይ ባስ ባስ ጊጌቲዳ ቢታ ኤካና ጋካናስ ኑኒ ኑሶ ሲሞኮ። ");
INSERT INTO gmve_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ኑኒ ኑ ጊሻ ዮርዳኖሴፔ ኣርሼይ ሞኪዛ ባጋራ ኤኪዳ ጊሻስ ፒንꬃፌ ኢስታ ጋኪዛ ጊሻፔ ኑ ኣይኮካ ኤኮኮ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","ሙሴይካ ኢስታስ፥ «ሃይሲ ኢንቴ ጊዳይሲ ቱሙ ጊዲኮ ኢንቴ ጎዳ ሲንꬃን ኦላ ባናስ ኢንቴ ጊጌቲዳ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ቃሴካ ጎዳይ ባ ሞርኬታ ባ ሲንꬃፌ ዬዴꬂ ኬሳና ጋካናስ ኢንቴ ኡባቲካ ጎዳ ሲንꬃን ኦላስ ጊጌቲዳይታ ጊዲዲ ዮርዳኖሴ ሻፋ ፒኒኮ፥ ");
INSERT INTO gmve_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ቢታያካ ጎዳስ ሃሬቲዳፔ ጉዬ ኢንቴ ሲማና ዳንዳዬታ፤ ሄ ዎዴ ኢንቴ ጎዳሲኔ ኢስራኤሌ ኣሳስ ኦꬃናስ ቤሲዛ ኣላፌቴꬅ ፖሊዳፔ ጉዬ ሃራ ኣይኮካ ኦይሼቴኬታ፤ ሄሳፌ ጉዬ ሃ ቢታያ ኢንቴስ ጺንጾ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","«ኢንቴ ኢንቴ ጊዳ ቃላ ናጎንታ ኣጊኮ ኢንቴ ጎዳ ቆሄታ፤ ኢንቴ ናጋራ ጊሻስ ቂጻቴይ ኢንቴ ቦላ ጋካናይሳ ኤሪቴ። ");
INSERT INTO gmve_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","ሄሳ ጊሻስ ኢንቴ ማቼታሲኔ ኢንቴ ናይታስ ዱሳሶ፥ ኢንቴ ሜሄታስካ ኣቆሶ ኦꬂቴ፤ ኢንቴ ጫቆ ጌሊዳ ቃላካ ፖሊቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ጋዴ ዛርኬቲኔ ኦሮቤሌ ዛርኬቲ ሙሴስ፥ «ኑኒ ኔ ኦሳንቻቲ ኔኒ ኑ ጎዳይ ኑና ኣዛዚዳይሳ ኑ ኦꬃና። ");
INSERT INTO gmve_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","ኑ ማቼቲ፥ ኑ ናይቲኔ ኑ ሜሄቲ ሃይሳን ጋላኣዴ ካታማታን ጋምኤቶ። ");
INSERT INTO gmve_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","ጊዶ ኣቲን ኑኒ ኔ ኦሳንቻቲ ኦላ ኦሌታናስ ጊጼቲዳይቲ ዉሪካ ጎዳ ሲንꬃን ኦሌታናስ ኑ ጎዳይ ኔኒ ኑና ኣዛዚዛ ማላ ጌዴ ሄ ፒንꬅ ኑ ፒናና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","ሄሳ ጊሻስ ሙሴይ ቄሴ ኤልኤዜሬስ፥ ናዌ ና ኢያሶሲኔ ኢስራኤሌ ማባራ ካሌꬂዛ ኮራፒኔታስ ኢስታ ጊሻስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","«ጋዴ ዛርኬቲኔ ኦሮቤሌ ዛርኬቲ ዮርዳኖሴ ፒኒዲ ጎዳ ሲንꬃን ኦላስ ጊጌቲዲ ኢስቲ ኢንቴና ማዲን ቢታያ ኢንቴ ኩሼን ጌሊዛ ዎዴ ጋላኣዴ ኢንቴ ኢስታስ ጺንጾ ሂስቲ ኢሚቴ። ");
INSERT INTO gmve_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","ኢስቲ ኢንቴናራ ዮርዳኖሴ ሻፋ ፒኒ ቢዲ ኦሌቶንታ ኣጊኮ ኢስቲካ ኢንቴናራ ኢሲፌ ካናኔፔ ጊሼቲ ኤኬቶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ጋዴ ዛርኬቲኔ ኦሮቤሌ ዛርኬቲ፥ «ኑኒ ኔ ኦሳንቻቲ ጎዳይ ኑና ኣዛዚዳይሳ ኡባ ኦꬃና። ");
INSERT INTO gmve_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ኑ ኦላስ ጎዳ ሲንꬅ ጌዴ ካናኔ ፒናና፤ ኑ ላታና ቢታይ ጊዲኮ ዮርዳኖሴ ሻፋፔ ሃ ፒንꬃን ኣርሼይ ሞኪዛ ባጋና» ጊ ዛሪዳ። ");
INSERT INTO gmve_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","ሄሳ ጊሻስ ሙሴይ ኣሞሬ ዴሬ ካዎ ሲሆኔይ ሃሪዛ ዴሬታኔ ባሳኔ ዴሬ ካዎ ኣጌይ ሃሪዛ ዴሬን ዲዛ ካታማታ፥ ኢስታ ዩሾን ዲዛ ካታማታኔ ዴሬታ ኡባ ኦሮቤሌ ቆሞታስ፥ ጋዴ ቆሞታሲኔ ሚናሴ ቆሞታፔ ባጋይታስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","ጋዴ ቆሞቲ፥ ዲቦኔ፥ ኣጻሮቴ፥ ኣሮኤሬ፥ ");
INSERT INTO gmve_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","ኣጻሮቴ-ሶፋኔ፥ ኢያዜሬ፥ ዮጊባሃ፥ ");
INSERT INTO gmve_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","ቤቲ-ኒሚሬኔኔ ቤቲ-ሃራኔ ዩዪ ኣꬋናስ ጊምቤ ጊምቢዳ፤ ባ ሜሄታስካ ኣቆሶ ኬጺዳ። ");
INSERT INTO gmve_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","ኦሮቤሌ ዛርኬቲ ሃሴቦኔ፥ ኤልኤሌ፥ ቂሪያታይሜ ካታማታ ዛሪ ጊምቢዳ። ");
INSERT INTO gmve_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","ሄሳꬆካ ጉዬፔ ኢስታስ ሱንꬃይ ላሜቲዳ ኔቦ፥ ባኣሊ-ሜኦኔኔ ሴባማ ካታማታ ዛሪ ጊምቢዳ፤ ሄ ካታማታ ኡባታስ ኦራꬃ ሱንꬅ ሱንꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","ሚናሴ ና ማኪሬ ዜሬꬃቲ ጋላኣዴ ኦሊ ኦይኪዲ ካሴ ሄን ዲዛ ኣሞሬ ኣሳታ ዬዴꬂ ኬሲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","ሄሳ ጊሻስ ሙሴይ ጋላኣዴ ዴሬ ሚናሴ ና ማኪሬ ዜሬꬃታስ ኢሚዴስ፤ ኢስቲካ ባንታስ ሄን ዱሳሶ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","ሚናሴ ዛርኬፌ ጊዲዳ ያኢሬይ ኢሲ ኢሲ ጉታታን ሜቶ ጋꬂዲ ባስ ኤኪዴስ፤ ኢስቲካ፥ «ሃቦት-ያኢሬ» ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","ኖባሄይ ቃሴ ቄናቴኔ ኢዛ ዩሾን ዲዛ ጉታታ ኦሊ ኦይኪዲ ባ ሱንꬃን፥ «ኖባሄ» ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ኢስራኤሌ ኣሳይ ባ ዛርኬን ዛርኬን ሻኬቲ ሻኬቲ ሙሴይኔ ኣሮኔይ ካሌꬂን ጊብጼፔ ኬዚዳፔ ጉዬ ዱማ ዱማ ዎዴ ኢስቲ ዱንካኒ ኡቲዳሶሆቲ ሃይሳፌ ካሊዛይታ፤ ");
INSERT INTO gmve_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","ኢስቲ ዱማ ዱማ ዎዴ ዱንካኒ ኡቲዳሶሆታ ሱንꬃ ጎዳይ ኣዛዚዳ ማላ ሙሴይ ጻፊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","ኢስራኤሌ ኣሳይ ኮይሮ ኣጊናይ ጌሊዳ 15 ጋላስ ፓዚጋ ባኣሌፔ ዎንቴꬅ ጊብጼ ኣሳይ ኡባይ ኢስቲ ጼሊሺን ያዮንታ ኤራሚሴ ካታማ ዬጊ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","ሄ ዎዴ ጊብጼ ኣሳይ ኢስታ ጊዶፌ ጎዳ ቦሻን ሃይቂዳ ባይራታ ባይራታ ሞጎን ዴቴስ፤ ሄ ዎዴ ጎዳይ ኢስታ ኤቃ ጾሳታ ቦላካ ፒርዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ኢስራኤሌ ኣሳይ ኤራሚሴፔ ዴንዲ ቢዲ ሱኮቴን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","ሱኮቴፔ ዴንዲዲ ባዞ ጋጻ ቦላ ዲዛ ኤታሜን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ኤታሜፔ ዴንዲዲ ባኣሊ-ጻፎኔፔ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ፒሃሂሮቴ ሲሚዲ ሚጊዶሌ ሄራን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","ፒሃሂሮቴፔ ዴንዲዲ ዞኦ ኣባ ፒኒዲ ኤታሜ ባዞ ቢዴስ፤ ኤታሜ ባዞን ሄꬑ ጋላስ ጋካናስ ቢዲ ማራ ጋኪ ዱንካኒዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","ማራፔ ዴንዲዲ ታማኔ ናምኡ ሃꬃ ፑልቶቲኔ ላፑን ታሙ ታሚሬ ሚꬃቲ ዲዛሶ ኤላሜ ጋኪ ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ኤላሜፔ ዴንዲዲ ዞኦ ኣባ ማታን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ዞኦ ኣባ ማታፔ ዴንዲዲ ሲና ባዞን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","ሲና ባዞፌ ዴንዲዲ ዱፊቃን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ዱፊቃፔ ዴንዲዲ ኣሉሼን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","ኣሉሼፔ ዴንዲዲ ኡሻ ሃꬂ ባይንዳሶን ኤራፊዲሜን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","ኤራፊዲሜፔ ዴንዲዲ ሲና ባዞን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","ሲና ባዞፌ ዴንዲዲ ኪብሮቴ-ሃታኣቤን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","ኪብሮቴ-ሃታኣቤፔ ዴንዲዲ ሃጺሮቴን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","ሃጺሮቴፔ ዴንዲዲ ኤሬቲማን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","ኤሬቲማፔ ዴንዲዲ ኤሬሞን-ፔሬዜን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","ኤሬሞን-ፔሬዜፔ ዴንዲዲ ሊቢናን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","ሊቢናፔ ዴንዲዲ ኤሪሳን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","ኤርሳፔ ዴንዲዲ ቃሃላቴን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","ቃሃላቴፔ ዴንዲዲ ሼፌሬ ዙማን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","ሼፌሬ ዙማፔ ዴንዲዲ ሃራዳን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","ሃራዳፔ ዴንዲዲ ማቂሃሎቴን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","ማሃሎቴፔ ዴንዲዲ ታሃቴን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","ታሃቴፔ ዴንዲዲ ታራን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","ታራፔ ዴንዲዲ ሚቲቃን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","ሚቲቃፔ ዴንዲዲ ሃሼሞኔን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","ሃሼሞኔፔ ዴንዲዲ ሞሴሮቴን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","ሞሴሮቴፔ ዴንዲዲ ቤኒ ያቂኔን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","ቤኒ ያቂኔፔ ዴንዲዲ ሆሪ-ሃጊዲጋን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","ሆሪ-ሃጊዲጋፔ ዴንዲዲ ዮጽባቴን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","ዮጽባቴፔ ዴንዲዲ ኣብሮኔን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","ኣብሮኔፔ ዴንዲዲ ኤጺዮን-ጋቢሬን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ኤጺዮን-ጋቢሬፔ ዴንዲዲ ጺኔ ባዞን ዲዛ ቃዴሴን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","ቃዴሴፔ ዴንዲዲ ኤዶሜ ዴሬ ꬋሳን ዲዛ ሆሬ ዙማን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","ቄሴ ኣሮኔይ ጎዳ ኣዛዞን ፑዴ ሆሬ ዙማ ቦላ ኬዚዴስ፤ ሄን ኢስራኤሌ ኣሳይ ጊብጼፔ ኬዚዳ ኦይዱ ታማንꬃ ላይꬃን ኢቻሻንꬆ ኣጊናይ ጼሪዳ ኮይሮ ጋላስ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","ኣሮኔይ ሆሬ ዙማ ቦላ ሃይቂዛ ዎዴ ኢዛ ላይꬃይ ጼታኔ ናምኡ ታማኔ ሄꬓ። ");
INSERT INTO gmve_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","ካናኔ ቢታን ኔጌቤን ዲዛ ካናኔ ኣስ ኣራዴ ካዎይ ኢስራኤሌ ኣሳይ ዪዛይሳ ሲዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","ዴሬዚካ ሆሬ ዙማፔ ዴንዲዲ ጼሊሞናን ዱንካኒ ኡቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","ጼሊሞናፔ ዴንዲዲ ፓኖኔን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","ፓኖኔፔ ዴንዲዲ ኦቦቴን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ኦቦቴፔ ዴንዲዲ ሞኣቤ ꬋሳን ዲዛ ኢዬ-ኣባሪሜን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","ኢዬ-ኣባሪሜፔ ዴንዲዲ ዲቦን-ጋዴን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","ዲቦን-ጋዴፔ ዴንዲዲ ኣልሞን-ዲቢላታዬን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","ኣልሞን-ዲቢላታዬፔ ዴንዲ ኔቦ ማታን ዲዛ ኣባሪሜ ዙማታ ቦላ ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","ኣባሪሜ ዙማታፔ ዴንዲዲ ኢያርኮፌ ዮርዳኖሴ ፒንꬃን ዲዛ ሞኣቤ ዴምባን ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","ሄን ዮርዳኖሴ ማታን ሞኣቤ ዴምባን ቤቲ-ያሺሞቴፔ ቢዲ ኣቤሊ-ሹቲሜ ጋካናስ ዱንካኒ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","ኢያርኮ ጊናራ ዮርዳኖሴ ፒንꬃን ሞኣቤ ዴምባን ኢስቲ ዲሺን ኢስራኤሌ ዴሬዛስ ዮታና ማላ ጎዳይ ሙሴስ ሃይሳፌ ካሊዛ ዎጋ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","ኔኒ ኢስራኤሌ ኣሳስ፥ «ኢንቴ ካናኔ ዴሬ ጌላናስ ዮርዳኖሴ ፒኒዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ሄ ቢታን ዲዛ ኣሳ ኡባ ኢንቴ ሲንꬃፌ ጎዲ ኬሲቴ፤ ሹቻፌኔ ቢራታፔ ኦሴቲዳ ኢስታ ኤቃ ጾሳታ ሜንꬄሬꬂ ዬጊቴ፤ ሄሳꬆካ ꬎቃሶሆታን ዲዛ ኢስቲ ጎይኒዛሶታካ ላሊቴ። ");
INSERT INTO gmve_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ታኒ ሄ ቢታዮ ኢንቴስ ኢሚዳ ጊሻስ ላቲዲ ኢንቴ ኢዚን ዲቴ። ");
INSERT INTO gmve_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","ቢታዮ ኢንቴ ዛርኬን ዛርኬን ጊሼቲ ኤኪቴ፤ ቆዳን ዳሪዛ ዛርኬስ ዳልጋ ጋዴ ኢሚቴ፤ ቆዳን ጉጺዛ ዛርኬታስ ጹንꬃ ጋዴ ኢሚቴ፤ ኢሶይ ኢሶይ ባ ዛርኬን ዛርኬን ቢታዮ ኣይ ጊዲንካ ሳማይ ጋꬂዳ ማላ ባስ ላታ ጋዴ ሂስቲ ኤኮ። ");
INSERT INTO gmve_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","«ካሴ ሄ ቢታን ዲዛ ኣሳታ ኡባ ጎዲ ኬሶንታ ኢስታፌ ሻኪ ኣሺኮ ኢስቲ ኢንቴ ኣይፌ ጫዲ ቶይሲዛ ፒልቄ ማላ ጊዳና፤ ሚሌ ጫዲዛ ኣጉንꬃ ማላ ጊዲዲ ኢስቲ ኢንቴና ዋዪሳና፤ ኢንቴ ዲዛ ዴሬዛን ኢስቲ ኡባ ዎዴ ኦላ ዴንꬂ ዴንꬂ ኢንቴና ሜቶꬃና። ");
INSERT INTO gmve_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","ኢንቴ ሄሳꬆ ኦꬆንታ ኣጊኮ ታኒ ኢስታ ꬋይሳና ጋ ቆፖይሳ ኢንቴ ቦላ ዛራ ፖላና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«ኢስራኤሌ ኣሳ፥ ‹ታኒ ኢንቴስ ኢሚዛ ካናኔ ቢታዮ ኢንቴ ቢዲ ጌሊዛ ዎዴ ኢዚ ዩሾን ዲዛ ዴሬቲ ሃይሳፌ ካሊዛይታ፤ ");
INSERT INTO gmve_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","ዱጌሃ ባጋራ ጺኔ ባዞፌ ዴንዲዲ ኤዶሜ ባዞ ኣቻራ ካንꬂ ቢዲ ኣርሼይ ሞኪዛ ባጋራ ሃይቆ ኣባፌ ዱጌሃ ባጋ ጼራ ቦላራ ዶሚዲ፥ ");
INSERT INTO gmve_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","ኣቅራቢሜ ፑርዴራ ካንꬂ ኣꬊዲ ጺኔ ጋኪዲ ዱጌሃ ባጋራ ቃዴሴ ባሪኔ ጋኬስ፤ ሄሳፌ ሃጻሬ-ኣዳሬ ካንꬂዲ ኣጺሞኔ ጋኬስ። ");
INSERT INTO gmve_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","ኣጺሞኔፔ ዶሚዲ ሃꬂ ባይንዳ ጊብጼ ሻፋታራ ዩዪ ኣꬊዲ ሜዲቴራኔ ኣባን ኤቄስ። ");
INSERT INTO gmve_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","« ‹ኣርሼይ ዉሊዛ ባጋራ ሜዲቴራኔ ኣባይ ዛዋ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","« ‹ፑዴሃ ባጋራ ዲዛ ዛዋይ ሜዲቴራኔ ኣባፌ ቢዲ ኡሬ ዙማ ጋኬስ። ");
INSERT INTO gmve_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ኡሬ ዙማፔ ቢዲ ሃማቴራ ኣꬊ ቢዲ ጼዳዴ ጋኬስ። ");
INSERT INTO gmve_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ጌዴ ዚፒሮኔ ፒኒዲ ሃጻሬ-ኤናኔ ጋኪ ኤቄስ፤ ሃይሲ ኡባይ ኢንቴስ ፑዴሃ ባጋራ ዲዛ ዛዋ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","« ‹ኣርሼይ ሞኪዛ ባጋራ ሃጻሬ-ኤናኔፔ ቢዲ ሻፋሜ ጋካናስ ማላታ ዎꬂቴ። ");
INSERT INTO gmve_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","ዛዋዚ ሻፋሜፔ ዶሚዲ ኣዪኔፔ ኣርሼይ ሞኪዛ ባጋራ ኤሬቢላ ካንꬂ ኣꬊዲ ጋሊላ ኣባፌ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ዞዜታራ ካንꬂዲ፥ ");
INSERT INTO gmve_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ዮርዳኖሴ ሻፋ ዎꬌስ፤ ሄራ ቢዲ ዉርሴꬃዚ ሃይቆ ኣባ ጊዳና፤ ሃይቲ ኢንቴ ቢታዮ ዩዪ ኣꬊዛ ዛዋታ ጊዳና› ጋዳ ኣዛዛ።» ");
INSERT INTO gmve_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","ሙሴይ ኢስራኤሌ ኣሳ፥ «ሳማ ዬጊዲ ኢንቴ ላታና ማላ ኡዱፉን ዛርኬታሲኔ ሚናሴ ዛርኬፌ ባጋይታስ ሄ ቢታይ ኢሜታና ማላ ጎዳይ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","ኦሮቤሌ ዛርኬቲ ጋዴ ዛርኬቲኔ ሚናሴስ ባጋ ዛርኬቲ ባስ ኢሜቲዳ ቢታ ላቲዳ። ");
INSERT INTO gmve_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ኢስቲካ ዮርዳኖሴፔ ሄ ፒንꬃን ኢያርኮ ጊናራ ኣርሼይ ሞኪዛ ባጋራ ባና ጋኪዛ ጺንጾዛ ኤኪዳ» ጊ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","«ቄሴ ኤልኤዜሬይኔ ናዌ ና ኢያሶይ ጋዴዛ ዴሬዛስ ጊሼቶ። ");
INSERT INTO gmve_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","ኢስቲ ቢታ ጊሺዛ ዎዴ ኢስታ ማዳናስ ዛርኬፌ ዛርኬፌ ኮራፒኔ ኤካ። ");
INSERT INTO gmve_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","ሄ ኔ ኤካና ኣሳታ ሱንꬂ ሃይሳፌ ካሊዛይሳ፤ ዩሁዳ ዛርኬፌ ዮፊኔ ና ካሌቤ፥ ");
INSERT INTO gmve_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","ሲሞና ዛርኬፌ ኣሚሁዴ ና ሳሜላ፥ ");
INSERT INTO gmve_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","ቢኒያሜ ዛርኬፌ ኪሳሎኔ ና ኤልዳዴ፥ ");
INSERT INTO gmve_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","ዳኔ ዛርኬፌ ዮጊሌ ና ቡቃ፥ ");
INSERT INTO gmve_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","ዮሴፌ ዛርኬፌ ሚናሴ ባጋ ሱፊዴ ና ሃንኤሌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ዮሴፌ ዛርኬፌ ኤፍሬሜ ባጋ ሺፊጼ ና ቃሙኤሌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ዛቢሎኔ ዛርኬፌ ፔሪናኬ ና ኤልጻፋኔ፥ ");
INSERT INTO gmve_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ዪሳኮሬ ዛርኬፌ ሆዛ ና ፓልቲኤሌ፥ ");
INSERT INTO gmve_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","ኣሴሬ ዛርኬፌ ሴሌሜ ና ኣሁዴ፥ ");
INSERT INTO gmve_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","ኒፍታሌሜ ዛርኬፌ ኣሚሁዴ ና ፔዳሄሌ።» ");
INSERT INTO gmve_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","ሃይታንቲ ኢስራኤሌ ኣሳስ ካናኔን ቢታ ጊሺ ኢማና ማላ ጎዳይ ዶሪዳ ኣሳታ። ");
INSERT INTO gmve_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","ኢያርኮ ጊናራ ዮርዳኖሴ ሻፋፔ ሄ ፒንꬃን ዲዛ ሞኣቤ ዴምባ ቦላ ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","«ኢስራኤሌ ኣሳይ ባ ጊሻፔ ጊሻፔ ሌዌ ዛርኬቲ ዳና ካታማታኔ ሄ ካታማታ ዩሾን ኢስቲ ባ ሜሄ ኢዛን ሄማና ጋዴ ኢማና ማላ ዮታ። ");
INSERT INTO gmve_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","ሄ ካታማቲካ ሌዌ ዛርኬታስ ዱሳሶ ጊዳና ጊዴስ፤ ሜሄ ሄሚዛሶሆቲ ኢስታ ሜሄይ ፔኢዛሶ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","ካታማታ ዩሾን ኢንቴ ሌዌ ዛርኬታስ ኢማና ሜሄ ሄንꬃ ጋዴዛ ኣኮቴꬃይ ካታማ ጊምቤዛፔ ዶሚዲ ኦይዱ ባጋራካ 1,000 ዋꬋ ዋꬋ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","ሄሳ ማላን ካታማዛ ጊዶ ኣꬂዲ ኦይዱ ባጋራካ ጉላፔ ቢዲ ጉላ ጋካናስ 2,000 ዋꬋ ጊዶ፤ ሄሳ ሌዌ ቆሞቲ ባስ ሜሄ ሄንꬃሶሆ ሂስቴቶ። ");
INSERT INTO gmve_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","«ሌዌ ቆሞታስ ኢንቴ ኢሚዛ ካታማታፔ ኡሱፑናቲ ኣስ ዎꬊዳ ኣሲ ባቃቲ ኣቲዛ ካታማታ ጊዴቶ፤ ሄይታፔ ሃራ 42 ካታማታ ጉጂ ኢሚቴ። ");
INSERT INTO gmve_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","ኢስቲ ሜሄ ሄሚዛሶሆታራ ጉጂን 48 ካታማቲ ኢሜቴቶ። ");
INSERT INTO gmve_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","ኢስራኤሌ ዛርኬቲ ላቲዳ ጋዴፔ ኢስታ ጋዴ ጋዴ ዳልጋቴꬃ ማላ ዳልጋ ጋዴ ኦይኪዳይታፔ ዳልጋ፥ ጹንꬃ ጋዴ ኦይኪዳይታፔ ጹንꬅ ኤኪዲ ሌዌ ዛርኬታስ ኢሚቴ።» ");
INSERT INTO gmve_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","ጎዳይ ሙሴስ ሂዝጊ ዮቲዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«ኔኒ ኢስራኤሌ ኣሳስ፥ ‹ኢንቴ ካናኔ ዴሬ ጌላናስ ዮርዳኖሴ ሻፋ ፒኒዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ኢሲ ኣሲ ኤሮንታ ዲሼ ኣስ ዎꬊኮ ሄሳዴይ ባቃቲ ቢዲ ኣታና ካታማታ ኔ ዶራ። ");
INSERT INTO gmve_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","ሄ ካታማቲ ሼምፖ ዎꬊዳዴይ ፒርዳስ ሺቆንታ ዲሺን ሃይቂዳዴ ዳቦይ ኢዛ ዎꬎንታ ማላ ኢዚ ባቃቲ ኣቲዛ ካታማታ ጊዴቶ። ");
INSERT INTO gmve_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","ሃይቲ ኢንቴ ሌዌታስ ኢሚዳ ኡሱፑን ካታማቲ ኤሮንታ ሼምፖ ዎꬊዳ ኣሲ ባቃቲ ኣቲዛ ካታማታ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","ሄ ካታማታፔ ሄꬓቲ ዮርዳኖሴ ሻፋፔ ሄ ፒንꬃን ኣርሼይ ሞኪዛ ባጋራ ሃንኮ ሄꬓቲ ቃሴ ካናኔ ቢታን ጊዴቶ። ");
INSERT INTO gmve_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ሃ ኡሱፑን ካታማቲ ኤሮንታ ዲሼ ኣስ ዎꬊዳ ኢስራኤሌ ኣሲ፥ ኢማꬃቲኔ ኢንቴ ጊዶን ዲዛ ሃራ ዴሬ ኣሳቲ ባቃቲ ኣቲዛሶ ጊዴቶ። ");
INSERT INTO gmve_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","« ‹ኢሲ ኣሲ ቢራታፔ ኦሴቲዳዛን ኣስ ዎꬊዳ ጊዲኮ ሄ ሼምፖ ዎꬊዳዴይ ኢዚካ ኣሳ ኩሼን ሃይቆ። ");
INSERT INTO gmve_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","ኢሲ ኣሲ ሹቻን ጫዲዲ ኣስ ዎꬊዳ ጊዲኮ ሄ ሼምፖ ዎꬊዳዴይ ኢዚካ ኣሳ ኩሼን ሃይቆ። ");
INSERT INTO gmve_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","ኢሲ ኣሲ ሚꬃን ጫዲ ኣስ ዎꬊዳ ጊዲኮ ሄ ሼምፖ ዎꬊዳዴይካ ኣሳ ኩሼን ሃይቆ። ");
INSERT INTO gmve_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","ሄ ሃይቂዳይሳስ ማታ ዳቦይ ሱꬅ ኣዛራናስ ዳንዳይዛ ጊሻስ ኣዋንካ ዴሚኮ ዎꬋናስ ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","« ‹ኢሲ ኣሲ ኦዲዲ ኣስ ሱጊ ዬጊ ዎꬊኮ ዎይኮ ጌማሶን ኡቲዲ ኢሲ ሚሻን ጫዲ፥ ");
INSERT INTO gmve_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ዎꬊኮ ሞርኬቴꬃን ዴንዲዲ ኢጪ ዎꬊኮ ኢዚ ሼምፖ ዎꬊዳ ጊሻስ ኢዚካ ኣሳ ኩሼን ሃይቃናስ ቤሴስ፤ ሄ ሃይቂዳይሳስ ማታ ዳቦይ ሱꬅ ኣጫናስ ዳንዳይዛ ጊሻስ ኣዋንካ ዴሚኮ ዎꬋናስ ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","« ‹ጊዶ ኣቲን ኢሲ ኣሲ ኤሮንታ ዲሼ ኣስ ሱጊ ዎꬊኮ ዎይኮ ቆፖንታ ዲሼ ኢሲ ሚሻን ጫዲ ዎꬊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ዎይኮ ኤሮንታ ዲሼ ሹች ኢዛ ቦላ ዬጊ ዎꬊዛ ጊዲኮ ሄሳዴይ ኢዛ ቆሃናስ ኦዲ ኦꬆንታ ጊሻስ፥ ");
INSERT INTO gmve_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ዴሬዚ ሄ ዎꬊዳይሳ ጊዶኒኔ ሃይቂዳይሳ ዳቦታ ጊዶን ኢሜታና ፒርዳይ ሃይሳፌ ካሊዛይሳ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","ኤሮንታ ዲሼ ኣስ ዎꬊዳዴይ ሱꬅ ኣጪዛ ኣሳ ኩሼፔ ዴሬዚ ኣሺዲ ኢዚ ባቃቲ ኣቲዳ ካታማ ዛሮ፤ ዛይቴን ቲዬቲዳ ቄሴታ ሃላቃይ ሃይቃና ጋካናስ ኢዚ ሄን ጋምኦ። ");
INSERT INTO gmve_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","« ‹ኣስ ዎꬊዲ ካሳሴቲዳይሲ ባቃቲ ኣቲዛ ካታማፔ ካሬ ኬዚዛ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ሱꬃ ኣጪዛዴይ ዴሚዲ ኢዛ ዎꬊኮ ሱꬃ ኣጮን ኦይሼቴና። ");
INSERT INTO gmve_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","ኣስ ዎꬊዲ ካሳሴቲዳይሲ ቄሴታ ሃላቃይ ሃይቃና ጋካናስ ባቃቲ ኣቲዛ ካታማን ጋምኦ፤ ቄሴታ ሃላቃዚ ሃይቂዳፔ ጉዬ ኢዚ ባሶ ሲማና ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","« ‹ሃይሲ ሃ ዎጋዚ ኢንቴ ዲዛ ዴሬ ኡባን ኢንቴሲኔ ኢንቴ ዜሬꬃታስ ኤቂ ዲዛ ዎጋ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","« ‹ሼምፖ ዎꬊዳ ኣይ ኣሲካ ሃይቆ ፒርዳ ፒርዴታናስ ዳንዳይዛይ ኢዛ ቦላ ናምኡ ማርካይ ዎይኮ ኢዛፔ ቦላራ ማርካቲኮ ኣቲን ኢሲ ማርካን ጻላ ሃይቆ ቂጻቴ ኤኬና። ");
INSERT INTO gmve_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","ሼምፖ ዎꬊን ሃይቆ ፒርዳይ ኢዛ ቦላ ፒርዴቲዳ ኣሲ ሃይቃና ቤሴስ ኣቲን ባ ዎꬊዳ ሼምፖ ጊሻስ ሚሼ ቃንጺ ኣታናስ ዳንዳዬና። ");
INSERT INTO gmve_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","ኢዛን ባቃቲ ኣቲዛ ካታማ ባቃቲዳ ኦናፔካ ቄሴታ ሃላቃይ ሃይቃናፔ ካሴ ኢዚ ጉዬ ሲሚዲ ባ ቢታን ዴኣና ማላ ጊዲ ሱꬃ ቃንጾ ኤኮፍቴ። ");
INSERT INTO gmve_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","ኢንቴ ሄሳꬆ ኦꬂዛ ጊዲኮ ኢንቴ ቢታ ቱኒሴታ፤ ጋሶይካ ኣሳ ሱꬅ ጉሲዛይሲ ቢታ ቱኒሴስ፤ ሄ ቢታይ ጌያናይ ኣሳ ሱꬅ ጉሲዳዴ ሱꬃይ ጉኪን ኣቲን ሃራን ጌዬና። ");
INSERT INTO gmve_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","ታኒ ኢንቴ ጎዳ ጊዲዳ ጊሻሲኔ ኢንቴናራ ኢስራኤሌ ዴሬዛ ጊዶን ዲዛ ጊሻስ ታኒ ኢዛን ዲዛ ቢታ ቱኒሶፒቴ› ጋ ዮታ።» ");
INSERT INTO gmve_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","ዮሴፌ ና ሚናሴይ ዬሊዳ ማኪሬ ና ጋላኣዴ ዛርኬታ ካሌꬂዛ ሃላቃቲ ሙሴኮኔ ኢስራኤሌ ኣሳ ካሌꬂዛይታኮ ሺቂዲ፥ ");
INSERT INTO gmve_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","«ኔኒ ሃኖ ቢታዮ ኢስራኤሌ ዴሬዛስ ሳማን ጊሻና ማላ ጎዳይ ኔና ኑ ጎዳዛ ኣዛዚዴስ፤ ሄሳꬆካ ኑ ኢሻ ጺሎፋዴ ጊሻ ኢዛ ማጫ ናይታስ ኢማና ማላ ኔና ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","ጊዶ ኣቲን ኢስቲ ጌሊዛ ኣዚናቲ ሃራ ቆሞፌ ጊዲኮ ኢስታ ጊሻ ጋዴይ ኑ ዛርኬታ ጺንጾፌ ቃንጼቲዲ ሄ ኢስቲ ጌሊዳ ኣዚናታ ዛርኬታስ ጉጄቲዛ ጊሻስ ኑ ዛርኬታ ጺንጾዚ ካሴ ኤኬቶይሳፌ ፓጬ ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","ዎዞ ላይꬃይ ጋኪዛ ዎዴ ኢስታ ጊሻዚ ኢስቲ ጌሊዳ ዛርኬስ ጉጄቴስ፤ ሄሳ ጊሻስ ኢስታ ጺንጾይ ኑ ዛርኬታ ጺንጾ ፓጪንቼስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","ሄሳፌ ጉዬ ሙሴይ ጎዳይ ኢዛስ ዮቲዳ ማላ ኢስራኤሌ ኣሳስ፥ «ሚናሴ ዛርኬቲ ጊዳይሲ ዉሪካ ሊኬ። ");
INSERT INTO gmve_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","ሄሳ ጊሻስ ጎዳይ ጺሎፋዴ ማጫ ናይቲ ባ ዛርኬታ ጊዶፌ ባ ዶሲዳዴ ጌላናስ ዳንዳዬቴስ። ");
INSERT INTO gmve_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ሄሳ ማላን ኢስራኤሌ ኣሳ ጺንጾይ ኢሲ ዛርኬፌ ሃራ ዛርኬን ኣꬎፎ፤ ኢስራኤሌ ኣሳይ ካሴ ባ ኣዋታፔ ላቲዳ ቢታ ሚንꬂ ኦይኮ። ");
INSERT INTO gmve_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","ኢስራኤሌ ኣሳ ዛርኬታ ጊዶን ባ ኣዋ ጋዴ ላቲዳ ማጫሲ ኦኒካ ባ ቆሞ ጌላናስ ቤሴስ፤ ሄሳ ማላን ኢስራኤሌ ኣሳይ ኡባይ ባ ኣዋታ ጺንጾ ናጋናስ ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","ሄሳ ጊሻስ ጋዴዚ ኢሲ ዛርኬ ኩሼፔ ሃራ ዛርኬ ኩሼን ኣꬋናስ ዳንዳዬና፤ ዉሪካ ባ ዛርኬን ዛርኬን ባ ቢታ ኦይኪ ናጎ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","ጺሎፋዴ ማጫ ናይቲ ጎዳይ ሙሴ ኣዛዚዳ ማላ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","ጺሎፋዴ ማጫ ናይቲ ማሂሎ፥ ቲርጾ፥ ሆጊሎ፥ ሚልኮ፥ ኖኦ፤ ሄይታንቲ ባ ኣዋ ኢሻታ ናይታ ጌሊዳ። ");
INSERT INTO gmve_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","ዮሴፌ ና ሚናሴ ዛርኬታ ጊዶን ኣዚና ጌሊዳ፤ ሄ ኢስታ ቢታይ ኢስታ ኣዋታ ዛርኬ ሱንꬃን ሚኒ ኣቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","ኢስራኤሌ ኣሳይ ኢያርኮ ጊናራ ዮርዳኖሴ ሻፋፔ ሄ ፒንꬃን ሞኣቤ ዴምባን ዲሺን ጎዳይ ሙሴ ባጋራ ኢስታስ ኢሚዳ ዎጋቲኔ ኣዛዞቲ ሃይታንታ። ");
INSERT INTO gmve_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","ሃይሳ ሃ ማጻፋን ዲዛ ቃላይ ዉሪካ ዮርዳኖሴ ሻፋፔ ሄ ፒንꬃን ኣርሼይ ሞኪዛ ባጋራ ዲዛ ባዞን ኢስቲ ዲሺን ሙሴይ ኢስራኤሌ ናይታስ ዮቲዳ ቃላ። ሙሴይካ ሃ ቃላ ዮቲዛ ዎዴ ኢስቲ ሱፌ ጌቴቲዛሶ ጊናራ ፓራኔ ካታማፔ ቃሴካ ሃራ ባጋራ ቶፔሌ፥ ላባ፥ ሃጺሮቴኔ ዲዛሃቤ ጌቴቲዛ ካታማታ ጊዶን ዲዛ ዮርዳኖሴ ሾባን ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","ሲና ዙማፔ ዴንዲዲ ቃዴሴ ባሪኔ ጋካናስ ኤዶሜ ዙማታ ቦላራ ኤፊዛ ቶሆ ኦጌራ ቢኮ ታማኔ ኢሲ ጋላስ ኤኬስ። ");
INSERT INTO gmve_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","ጊብጼፔ ኢስቲ ኬዚዳፔ ኦይዱ ታማንꬆ ላይꬃን ታማኔ ኢሲንꬃ ኣጊናይ ጌሊዳ ኮይሮ ጋላስ ሙሴይ ዴሬዛስ ኤሪሳና ማላ ጎዳይ ኢዛስ ዮቲዳ ቃላ ኡባ ኢስታስ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","ሄሲካ ሃኒዳይ ሃሴቦኔ ካታማን ካዎቲ ሃሪዛ ኣሞሬ ዴሬ ካዎ ሲሆኔኔ ኣስታሮቴን፥ ኤዲራኤ ካታማን ኡቲዲ ሃሪዛ ባሳኔ ካዎ ኣጌ ጾኒዳፔ ጉዬና። ");
INSERT INTO gmve_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","ኣሳይ ዮርዳኖሴፔ ኣርሼይ ሞኪዛ ባጋራ ሞኣቤ ዴሬን ዲሺን ሙሴይ ሃይሳፌ ካሊ ዲዛ ጎዳ ዎጋ ቆንጪሴꬅ ዶሚዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","«ኑኒ ሲና ዙማ ቦላ ዲዛ ዎዴ ጎዳ ኑ ጾሳይ ኑስ፥ ‹ሄኮ ኢንቴ ሃይሳ ዙማ ቦላ ዳሮ ጋምኢዴታ፤ ");
INSERT INTO gmve_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","ሃይሳፌ ጉዬ ኢንቴ ዲዛሶፔ ዴንዲ ጌዴ ጌዜቲዛ ኣሞሬታ ዴሬ፥ ኢስታ ሄራን ዲዛ ኣራቤ ዴሬን ዲዛ ጌዜኔ ጋꬋ፥ ኔጌቤ ዴሬ፥ ሜዲቴራኔ ኣባ ላንቄራ፥ ካናኔ ዴሬኔ ሊባኖሴ ባጋራ ካንꬂዲ ጊታ ሃꬃ ኤፊራጺሴ ሻፋ ጋካናስ ካንꬂ ቢቴ። ");
INSERT INTO gmve_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","ሄኮ ታኒ ሃ ቢታዮ ኢንቴስ ኢማዲስ፤ ኢንቴካ ቢዲ ኢንቴ ኣዋታስ ኣብራሃሜስ፥ ዪሳቃስ፥ ያቆቤሲኔ ኢስታፌ ጉዬን ያና ኢስታ ዜሬꬃታስ ኢማናስ ጎዳይ ጫቂዳ ቢታዮ ላቲቴ› ጊዴስ» ጊዲ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","ሙሴይ ዴሬዛስ፥ «ሄ ዎዴ ታኒ ኢንቴስ፥ ‹ታኒ ታርካ ኢንቴና ካሌꬃናስ ዳንዳይኬ። ");
INSERT INTO gmve_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","ኢንቴ ጎዳይ ኢንቴ ቆዳ ሳሎ ጾሊንቴ ማላ ዳርሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","ሃኢካ ኢንቴ ኣዋታ ጾሳይ ካሴ ኢንቴስ ኢሚዳ ሂዶታ ቃላ ማላ ሺ ዳኮ ጉጂዲ ኢንቴና ኣንጆ። ");
INSERT INTO gmve_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","ጊዶ ኣቲን ሃኢ ኢንቴ ጋርሳን ዲዛ ፓላማ፥ ኦሻኔ ኢንቴ ሜቶዛ ታኒ ታርካ ዎስታ ቢርሻና ዳንዳያዚና? ");
INSERT INTO gmve_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","ኢንቴ ኢንቴ ቆሞፌ ቆሞፌ ኣኬካይ፥ ኣꬎ ኤራቴꬂ ዲዛይታኔ ኦꬂ ሎሲዳይታ ዶሪቴ፤ ታኒካ ኢስታ ኢንቴ ቦላ ሹማና› ጋ ዮታዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","«ኢንቴካ፥ ‹ኔ ሺሺዳ ቆፋይ ሎኦ› ጊ ኤኪዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","ሄሳ ጊሻስ ኢሲ ኢሲ ቆሞፌ ኢንቴ ዶሪዳይታ ኦሶ ሎሲዳይታ፥ ኣꬎ ኤራንቻታኔ ኣኬኪዛይታ ኢንቴፌ ኤካዳ ባጋይታ ሻላቃታ፥ ባጋይታ ማቶ ሃላቃታ፥ ባጋይታ ሃምሳ ሃላቃታኔ ኣሲራ ሃላቃታ፥ ባጋይታ ቆሞታ ካሌꬂዛ ሃላቃ ሂስታ ሹማዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","«ታ ሄ ዎዴ ኢስታስ፥ ‹ኢንቴ ዴራ ጋርሳን ዴንዲዛ ፓላማኔ ኦሽ ኤኪ ጌላይ ባይንዳ ሱሬ ፒርዳ ፒርዲቴ፤ ኢንቴ ዴራ ጊዶን ዎይኮ ሃራ ዴሬፔ ዪዲ ኢንቴ ጊዶን ዲዛ ኣሳስ ጌላይ ባይንዳ ሱሬ ፒርዳ ፒርዲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","ኢንቴ ጌላ ፒርዳ ፒርዶፍቴ፤ ጉꬅ ጊዲን ጊታ ጊዲን ማዶ ፒርዳ ፒርዶፍቴ፤ ፒርዳይ ጾሳስ ጊዲዳ ጊሻስ ኣይ ኣሳስካ ባቦፍቴ፤ ኢንቴፌ ቦላ ጊዲዳይሳ ኡባ ታኮ ኤሂቴ፤ ሄሳ ታኒ ፒርዳና› ጋዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","ኢንቴ ኦꬃናስ ቤሲዛይሳ ታ ኢንቴስ ሄ ዎዴ ሎኤꬃ ዮታዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","«ሄሳፌ ጉዬ ኑ ጎዳይ ኑና ኣዛዚዳ ማላ ሲና ዙማፔ ዴንዲዲ ኢንቴ ቤኢዳ ኢታ ባዞዛራ ካንꬂዲ ኣሞሬ ዴሬን ሻራ ሜንꬆራ ኣꬊ ቢዲ ቃዴሴ ባሪኔ ጋኪዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","ታኒ ኢንቴስ፥ ‹ጾሳይ ኑና ላቲሳናስ ቃላ ጌሊዳ ሻራ ሜንꬆ ጊዲዳ ኣሞሬ ዴሬ ሄኮ ጋኪዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","ሄ ዴሬዮ ሃኖ ቤኢቴ! ጎዳይ ኑ ኣዋታ ጾሳይ ቤኒ ኣዛዚዳ ማላ ኢንቴ ጌሊዲ ኢዞ ላቲቴ፤ ባቦፍቴኔ ሂዶታ ቃንጾፍቴ› ጋ ዮታዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","«ኢንቴ ኡባቲካ ታኮ ዪዲ፥ ‹ሄ ቢታይን ዲዛ ካታማቲ ኣይ ማላኮ ቃሴ ኑና ሄ ጋꬃና ኦጌይካ ኣይ ማላ ኦጌኮ ቢ ዎቺ ሲሚዲ ኑስ ዮታና ኣሳታ ኑ ጋርሳፌ ኣኔ ዶሮስ› ጊዲ ታና ኦይቺዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","«ሄሳ ሂስታናይሲ ታስ ሎኦ ሚሳቲ ቤቲን ኢንቴ ጋርሳፌ ቆማፌ ቆማፌ ኢሲ ኢሲ ኣስ ዶራዳ ታማኔ ናምኡ ኣሳታ ዬዳዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","ኢስቲካ ሻራ ሜንꬆ ዴራራ ካንꬂ ቢዲ ኤሽኮሌ ሾባ ጋካናስ ዩዪ ጾሞሲ ጼሊዳ። ");
INSERT INTO gmve_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","ኢስቲካ ሄን ባ ቤኢዳ ሚꬃ ኣይፌፔ ኣማርዳይሳ ኤኪ ዪዲ ጎዳ ኑ ጾሳይ ኑስ ኢማና ቆፒዳ ቢታያ ኬሃ ሎኦ ቢታ ጊዲዳይሳ ኑስ ቆንጪሲ ዮቲዳ። ");
INSERT INTO gmve_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","«ጊዶ ኣቲን ጎዳ ኢንቴ ጾሳ ኣዛዞ ቦላ ማካሊዳ ጊሻስ ሄ ቢታዮ ጌላናስ ኮዪቤኬታ። ");
INSERT INTO gmve_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","ኢንቴ ኢንቴ ዱንካኔን፥ ‹ጾሲ ኑና ኢጺዴስ፤ ኢዚ ኑና ጊብጼፔ ኬሲዳይ ሃይታ ኣሞሬ ኣሳታን ኑና ዎꬊሳናሲኔ ኢስታ ኩሼን ኑና ኣꬂ ኢማናሳ፤ ");
INSERT INTO gmve_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","ሂስቲን ኑ ሄ ኣዛስ ቢዞኒ? ኑኒ ባቦስ፤ ኑኒ ኪቲዳ ኣሳቲ ሄን ዲዛ ኣሳይ ዉሪካ ሚኖኔ ኬሂ ኣዱሳታ ጊዲዳይሳ ቃሴካ ኢስቲ ዲዛ ካታማታ ጊምቤይ ሳሎ ጋኪዳይሳ ኑስ ዮቲዳ፤ ኬሂ ኣዱስ ጊዲዳ ኤናቄ ናይታ ቤኢዳ› ጊዲ ዙዙሚዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","«ጊዶ ኣቲን ታኒ ኢንቴስ፥ ‹ሃይታ ሃ ኣሳታስ ባቦፍቴኔ ዳጋሞፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","ኢንቴፌ ሲንꬃራ ቢዛ ጎዳ ኢንቴ ጾሳይ ካሴ ኢንቴ ኣይፌን ቤኢሺን ጊብጼታ ቦላ ኦꬆይሳ ማላ ሃኢካ ኢዚ ኢንቴ ጊሻስ ኦሌታና። ");
INSERT INTO gmve_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ኣዋይ ባ ና ኣልኢሲዛ ማላ ኢንቴ ቢዛ ባዞ ቢታ ኡባን ኢዚ ኢንቴና ካሌꬂሼ ኢንቴና ሳሮን ሃይሳ ዎስቲ ጋꬂዳኮ ኢንቴ ቤዪዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","33","ሃ ኡባ ታ ዮቲንካ ኢንቴ ዱንካናና ሶሆዛ ቤሳናሲኔ ኢንቴ ባና ኦጌ ቤሳናስ ኦማርስ ቱሳ ታማን፥ ጋላስ ቱሳ ማላ ሻራን ኢንቴና ካሌꬂዳ ኢንቴ ጎዳን ኣማኔቲቤኬታ። ");
INSERT INTO gmve_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","«ኢንቴ ዙዙሚዳ ዙዙንꬃ ጾሲ ሲዪዲ ሃንቄቲዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","ሄሳ ጊሻስ፥ ‹ታኒ ካሴ ኢንቴ ኣዋታስ ኢማና ጋዳ ጫቂዳ ሄ ሎኦ ቢታዮ ሃ ኢታ ዬሌታፔ ኢሶይካ ጌሌና። ");
INSERT INTO gmve_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ዮፊኔ ና ካሌቤይ ጻላ ሄ ቢታዮ ጌላና፤ ኢዚካ ኩሜꬃ ዎዚናፔ ኣማኔቲ ቤቲዳ ጊሻስ ሄ ኢዚ ቤኢዳ ቢታዮ ኢዛሲኔ ኢዛ ዜሬꬃታስ ታ ኢማና› ጊ ጫቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","«ኢንቴ ጋሶን ጎዳይ ታና ሃንቄቲዲ፥ ‹ሙሴ ኔኒካ ሄ ዴሬዮ ጌላካ። ");
INSERT INTO gmve_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","ጊዶ ኣቲን ኔና ማዲዛ ናዌ ና ኢያሶይ ሄ ቢታዮ ጌላና፤ ሄ ቢታዮካ ላታና ማላ ኢስራኤሌ ናይታ ካሌꬃናይ ኢዛ ጊዲዳ ጊሻስ ኔ ኢዛ ሚንꬄꬃ› ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","«ቃሴካ ጎዳይ ኢንቴስ፥ ‹ኢንቴ ኑ ናይቲ ዲኤታና› ጊዳ ኢታኔ ኪያ ሻኪ ኤሮንታ ቂ ናይቲ ጻላ ሄ ቢታዮ ጌላና፤ ታኒ ሄ ቢታዮ ኢስታስ ኢማና፤ ኢስቲካ ሄ ቢታዮ ላታና። ");
INSERT INTO gmve_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","ኢንቴ ጊዲኮ ሲሚዲ ዞኦ ኣባኮ ኤፊዛ ኦጌዛራ ዱጌ ባዞ ቢቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","«ኢንቴካ፥ ‹ሙሴ! ኑኒ ኑ ጎዳ ቆሂዶስ፤ ሃኢ ጎዳይ ኑ ጾሳይ ኑና ኣዛዚዳ ማላ ኑ ኦሌታና› ጊዴታ፤ ሄ ሻራ ሜንꬆ ዴሬዮ ዎራጆይ ካዉሻ ሚሽ ሚሳቲ ቤቲን ኢሶይ ኢሶይ ኦላስ ጊጌቲዴታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","ጎዳይ ጊዲኮ፥ «ታ ኢንቴናራ ኬኦንታ ጊሻስ ኦላስ ኬዞፒቴ፤ ኢንቴ ኢጺስ ጊ ኬዚኮ ኢንቴ ሞርኬቲ ኢንቴና ጾናና» ጊዲ ታስ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","ታኒካ ጎዳይ ታስ ዮቶይሳ ኢንቴስ ዮታዲስ ሺን ኢንቴ ኢጺዴታ። ኢዛ ቦላካ ማካሊዴታ፤ ኦቶሮ ዳሮፔ ዴንዲዳይሳን ኢንቴ ሄ ሻራ ሜንꬆ ቢታዮ ኦላናስ ቢዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","ሄ ዙምቡላታ ቦላ ዲዛ ኣሞሬ ዴሬ ኣሳቲ ኢንቴናራ ኦላ ኦይኬቲዳ፤ ኢስታ ኦላንቻቲ ማꬃ ማላ ኢንቴ ቦላ ዪዲ ሆርማ ጋካናስ ኢንቴና ዬዴꬂዳ፤ ዙምቡላቲ ዳሪ ኡቲዳ ኤዶሜ ዴሬን ኢንቴና ጾኒዳ። ");
INSERT INTO gmve_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","ሄሳ ጊሻስ ኢንቴ ሲሚ ዪዲ ጎዳ ሲንꬃን ዬኪዴታ፤ ጊዶ ኣቲን ኢዚ ኢንቴ ዬሆዛኔ ዋሶዛ ሲዪዲ ኢንቴና ማዳናስ ኮዪቤና። ");
INSERT INTO gmve_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","ሂስቲን ኢንቴ ቃዴሴን ዳሮ ዎዴ ጋምኢዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","ሄሳፌ ጉዬ ጾሲ ኣዛዚዳ ማላ ጌዴ ዞኦ ኣባኮ ኤፊዛ ኦጌዛራ ጉዬ ሲሚ ዱጌ ባዞ ቢታ ቢዶስ፤ ኑኒ ሄን ቶይላቲሼ ሻራ ሜንꬆ ኤዶሜ ዴሬን ዳሮ ዎዴ ጋምኢዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","ሄሳፌ ጉዬ ጎዳይ ታስ ሂዝጊ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","«ኢንቴ ሃ ሻራ ሜንꬆ ዴሬታን ዳሮ ዎዴ ቶይላቲዴታ፤ ሃኢ ፑዴሃ ባጋ ሲሚ ቢቴ። ");
INSERT INTO gmve_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","ዴራ፥ ‹ኢንቴ ዳቦ ኤሳዌ ዜሬꬃቲ ዲዛ ኤዶሜ ዴሬራ ኣꬊ ባና፤ ኢስቲ ኢንቴስ ያያና፤ ጊዲኮካ ኢንቴ ኬሂ ናጌቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","ሻራ ሜንꬆን ዲዛ ኤዶሜ ቢታ ታ ኤሳዌስ ጺንጾ ሂስታ ኢሚዳ ጊሻስ ኢስታ ቢታፌ ቶሆይ ዬꬊዛሶካ ታ ኢንቴስ ኢሚዳ ኢስታ ቦላ ኦላ ዴንꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","ኢንቴስ ኮሺዛ ካꬅ ጊዲን ሃꬅ ሚሻን ሻሚ ኤኪቴ› ጋ ኣዛዛ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","ጎዳ ኢንቴ ጾሳይ ኢንቴ ኦꬂዳ ኡባ ኢንቴስ ኬሂ ኣንጂዴስ፤ ኢንቴ ሃይሳ ዎልቃማ ባዞዛራ ካንꬂ ቢዛ ዎዴ ኢሻልሲ ኦይኪዴስ፤ ሃ ኦይዱ ታሙ ላይꬅ ኩሜꬃን ጎዳ ኢንቴ ጾሳይ ኢንቴናራ ዲዛ ጊሻስ ኣይኮይካ ኢንቴስ ፓጪቤና። ");
INSERT INTO gmve_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","ሄሳ ጊሻስ ኑኒ ኑ ኢሻ ኤሳዌ ዜሬꬃቲ ዲዛ ኤዶሜ ቢታራ ካንꬂ ቢዶስ፤ ቃሴ ኤላቴፔኔ ኤጺዮን-ጋቢሬ ካታማፔ ዪዛ ኦጌዛራ ኣራቤ ኦጌዛራ ሞኣቤ ባዞ ሲሚ ቢዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","ጾሳይካ ታስ፥ «ሎጼ ዜሬꬅ ሞኣቤ ኣሳታ ዋዪሶፒቴ፤ ኢስታራ ኦሌታናስ ኢስታ ዴንꬄꬆፍቴ፤ ታኒ ኤሬ ካታማ ኢስታስ ዱሳሶ ሂስታ ኢሚዳ ጊሻስ ኢስታ ጺንጾፌ ኣይኮካ ኢንቴስ ኢሚኬ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","ኤሚሜ ጌቴቲዛ ዎልቃማ ዳሮ ዴሬይ ኤሬን ዴስ፤ ሄይቲካ ኤናቄ ዜሬꬃ ማላ ጉባኒኔ ጌሳን ጊታታ። ");
INSERT INTO gmve_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","ኢስቲ ኤናቄ ኣሳታ ማላ ኤራፋይሜታ ጌቴቲ ጼይጌቴቴስ፤ ሞኣቤ ኣሳይ ቃሴ ኢስታ ኤሚሜታ ጊ ጼይጌስ፤ ሃንኮ ሞኣቤ ኣሳይ ቃሴ ኢስቲ ኢማሜታ ጊ ጼይጌቴስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","ሆሬ ኣሳይ ካሴ ኤዶሜ ቢታን ዴስ፤ ጊዶ ኣቲን ኢስራኤሌ ኣሳይ ላታና ማላ ጎዳይ ኢስታስ ኢሚዳ ቢታን ኢስቲ ኦꬆይሳꬆ ኤሳዌ ዜሬꬃቲ ኡሬ ኣሳ ጎዲ ꬋይሲዲ ኢስታ ቢታን ኬጺ ኡቲዳ። ");
INSERT INTO gmve_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","ሄሳፌ ጉዬ ጎዳይ ኑስ ዮቲዳ ማላ ዛራዴ ጌቴቲዛ ሻፋ ፒኒዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","ኑኒ ቃዴሴ ባሪኔፔ ቢዲ ዛራዴ ሻፋ ፒናናስ ሄꬑ ታማኔ ኦስፑን ላይꬂ ኣꬊዴስ፤ ሄ ዎዴ ጎዳይ ኢስታ ጊሻስ ካሴ ጫቂዳ ማላ ሄ ዬሌታፔ ኦላስ ጋኪዳ ኣቱማ ኣሳይ ኡባይ ዉሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","ኢስቲ ኡባይ ዉራና ጋካናስ ጎዳ ኩሼይ ኢስታ ቦላ ዴጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","ኦላስ ጋኪዳ ኣቱማ ኣሳይ ኡባይ ዉሪዳፔ ጉዬ፥ ");
INSERT INTO gmve_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","ጎዳይ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","«ሞኣቤ ዴሬስ ቲጻ ቦላ ዲዛ ኤሬ ቢታራ ኢንቴ ሃች ካንꬂ ባናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","ሄሳፌ ካሊዲ ሎጼ ዜሬꬅ ጊዲዳ ኣሞኔ ኣሳታ ዋዪሶፒቴ፤ ኢስታራ ኦሌታናስ ኢስታ ዴንꬄꬆፍቴ፤ ታኒ ኣሞኔ ቢታ ኢስታስ ዱሳሶ ሂስታ ኢሚዳ ጊሻስ ኢስታ ጺንጾፌ ኣይኮካ ኢንቴስ ኢሚኬ።» ");
INSERT INTO gmve_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","ሄ ቢታይ ካሴ ሄን ዲዛ ኣሳይ ጼይጊዛ ሱንꬃን ኤራፋይሜታ ቢታ ጌቴቲዲ ጼይጌቴስ፤ ቃሴ ኣሞኔ ኣሳይ ዛሚዙሜታ ጊ ጼይጌስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","ኢስቲካ ኤናቄ ዜሬꬃ ማላ ጉባኒኔ ጌሳን ጊታታ፥ ዎልቃማኔ ዳሮ ዴሬ፤ ጊዶ ኣቲን ጎዳይ ኢስታ ꬋይሲን ኣሞኔቲ ኢስታ ቢታ ላቲዲ ሄን ኬጺ ኡቲዳ። ");
INSERT INTO gmve_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","ጎዳይ ኤዶሜን ዴኢዛ ኤሳዌ ዜሬꬃታስ ኦꬂዳ ማላ ኢስታስካ ኦꬂዴስ፤ ሄሲካ ኢዚ ሄ ቢታን ዴኢዛ ሆሬታ ꬋይሲን ኤሳዌ ዜሬꬃቲ ኢስታ ቢታ ላቲዲ ሃች ጋካናስ ሄን ኬጺ ኡቲዳ። ");
INSERT INTO gmve_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","ጋዛ ጋካናስ ዴኢዛ ሄራታን ዲዛ ኣዌ ዴሬ ኣሳታ ካፍቶሬ ጌቴቲዛ ቢታፌ ዪዳ ካፍቶሬ ኣሳቲ ኢስታ ꬋይሲዲ ኢስታ ቢታን ኬጺ ኡቲዳ። ");
INSERT INTO gmve_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","ኑኒ ሞኣቤ ኣቻራ ኣꬊዳፔ ጉዬ ጾሲ ኑስ፥ «ሃኢ ዴንዲዲ ኣርኖኔ ሻፋ ፒኒቴ፤ ሃሴቦኔን ኡቲዲ ሃሪዛ ኣሞሬታ ካዎ ሲሆኔኔ ኢዛ ዴራካ ታኒ ኢንቴስ ኣꬃ ኢማዲስ፤ ኢንቴ ኢዛ ኦሊዲ ኢዛ ቢታ ላቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","ሃቻፌ ጉዬ ኣዋንካ ዲዛ ዴሬ ኣሳይ ኢንቴስ ባባና ማላ ታ ኦꬃና፤ ኦኒካ ኢንቴ ጊሻስ ሲዪዲ ዉሪካ ሂርጋን ኮኮራና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","ሄሳፌ ጉዬ ሳሮካ ኪታ ኣሳ ቦላ ቂዲሞቴ ባዞፌ ጌዴ ሃሴቦኔ ካዎ ሲሆኔኮ ኪታዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","«ኑ ኢንቴ ዴሬራ ኣꬊ ባና ማላ ኑና ዲጎፋ፤ ኑ ኦጌፔ ካሬ ኬዞንታ ሲቲ ጊ ባና። ");
INSERT INTO gmve_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","ኑኒ ማና ካꬂኔ ሃꬅ ኑ ሚሻን ሻሚ ኤካና፤ ኑኒ ኔ ቢታራ ካንꬂ ቢሺን ኔ ኑና ዲጎንታ ማላ ጻላ ኮዮስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","ኤዶሜን ዲዛ ኤሳዌ ዜሬꬃቲኔ ኤሬን ዲዛ ሞኣቤ ዜሬꬃቲ ኑ ኢስታ ዴሬራ ኣꬋና ማላ ኑስ ኤሮ ጊዳ ማላካ ዮርዳኖሴ ሻፋ ፒኒዲ ጾሳይ ኑና ላቲሳና ቢታዮ ኑኒ ጋካናሼ ጋካናስ ኑኒ ኦጌራ ጻላ ኣꬊ ባና ማላ ኑስ ኤሮ ጋርኪ!» ");
INSERT INTO gmve_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","ካዎ ሲሆኔይ ቃሴ ኑኒ ኢዛ ዴሬራ ኣꬊ ባና ማላ ኮዪቤና፤ ጋሶይካ ጎዳ ኢንቴ ጾሳይ ሃች ኢንቴ ቤኢዛይሳ ማላ ኢዛ ኢንቴ ኩሼን ኣꬂ ኢማናስ ኢዛ ዎዚና ሙሚሲዲ ኦቶራንቻ ኬሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","ሄሳፌ ጉዬ ጎዳይ ታስ፥ «ኣኔ ጼላ፥ ታኒ ካዎ ሲሆኔኔ ኢዛ ቢታ ኔ ኩሼን ኣꬃ ኢማዲስ፤ ኢንቴ ኢዛ ቢታ ላቲዲ ሄን ዴኢቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","ካዎ ሲሆኔይ ባስ ዲዛ ኦላንቻታ ኡባ ኤኪዲ ያሃጼ ካታማ ኣቻን ኑናራ ኦሌታናስ ዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","ጊዶ ኣቲን ጎዳ ኑ ጾሳይ ኢዛ ኑ ኩሼን ኣꬂ ኢሚዳ ጊሻስ ኢዛ፥ ኢዛ ናይታኔ ኢዛስ ዲዛ ኦላንቻታ ኡባ ኑ ዲፒ ሂስቲዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","ሄ ዎዴ ኑኒ ኢዛ ካታማታ ኡባ ዎራጂ ኦይኪዲ ካታማታ ኡባ፥ ኢስታን ዲዛ ኣቱማሳታራ፥ ማጫሳታራኔ ናይታራ ኢሲፌ ꬋይሲዶስ፤ ኣይኮካ ኣሾንታ ኡባ ዲፒ ሂስቲዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","ኢስታ ሜሄታኔ ኑ ዎራጂዳ ካታማታፔ ዲኢዳ ሚሻታ ኑስ ኤኪዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","ኑኒ ኣርኖኔ ሾባ ጋጻ ባጋራ ዲዛ ኣሮኤሬ ካታማፔኔ ሄን ዙሌዛን ዲዛ ካታማፔ ዶሚ ቢዲ ጋላኣዴ ጋካናስ ኑናራ ኤቄታና ዳንዳይዛ ኢሲ ካታማይካ ቤቲቤና። ጎዳ ኑ ጾሳይ ኡባ ኑስ ኣꬂ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","ጊዶ ኣቲን ኑኒ ኣሞኔ ዴሬ፥ ዎይኮ ያቦቄ ሻፋ ማታ፥ ሻራ ሜንꬆ ቦላ ዲዛ ካታማታኮኔ ጎዳ ኑ ጾሳይ ኑኒ ባና ማላ ኣዛዞንታ ሶሆ ኡባኮ ሺቂቦኮ። ");
INSERT INTO gmve_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","ሄሳፌ ጉዬ ኑኒ ሲሚዲ ባሳኔ ኤፊዛ ኦጌዛራ ኬዚዶስ፤ ካዎ ኣጌይ ባ ኦላንቻታ ኡባ ኤኪዲ ኑናራ ኦሌታናስ ኤዲራኤ ካታማ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","ጊዶ ኣቲን ጎዳይ ታስ፥ «ካዎ ኣጌስ ባቦፋ! ታኒ ኢዛ፥ ኢዛ ዴራኔ ኢዛ ቢታ ኔ ኩሼን ኣꬃ ኢማዲስ፤ ሃሴቦኔን ኡቲዲ ሃሪዛ ኣሞሬታ ካዎ ሲሆኔ ቦላ ኦꬆይሳ ማላ ኔኒ ኢዛ ቦላካ ኦꬃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","ሄሳ ጊሻስ ጎዳ ኑ ጾሳይ ካዎ ኣጌኔ ኢዛ ኦላንቻታ ኡባ ኑ ኩሼን ኣꬂ ኢሚዴስ፤ ኑኒካ ኢስታፌ ኢሲ ኣሲካ ኣሾንታ ኡባ ꬋይሲዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","ሄ ዎዴ ኢዛ ካታማታ ኡባ ኦይኪዶስ፤ ኑ ኦይኮንታ ኣቲዳ ኢሲ ካታማይካ ዴና፤ ሄሳꬆካ ባሳኔ ካዎ ኣጌይ ኣርጎባ ዴሬን ኣይሲዛ ኡሱፑን ታሙ ካታማታካ ኦይኪዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","ሄ ካታማቲ ዉሪ ጊምቤን ጊምቤቲዳ፤ ፔንጌቲካ ኮላታታን ጎርዴቴቴስ፤ ኢስታ ዩሾን ዲርሳይ ባይንዳ ጮራ ማንዳራቲ ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","ሃሴቦኔ ካዎ ሲሆኔፔ ኑ ኤኪዳ ካታማታ ቦላ ኑ ኦꬂዳይሳꬆ ሃ ካታማታካ ኡባ ꬋይሲዶስ፤ ኣቱማ ኣሳ፥ ማጫሳኔ ናይታካ ኣሾንታ ኡባ ꬋይሲዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","ሜሄታ ኡባ ዲኢዶስ፤ ካታማታን ዲዛ ሚሽ ኡባ ሊምኢ ሂስቲዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","ሄ ዎዴ ኑኒ ዮርዳኖሴ ሻፋፔ ቢዲ ኣርሼይ ሞኪዛ ባጋራ፥ ኣርኖኔ ዙሌፌ ቢዲ ሄርሞኔ ዙማ ጋካናስ ዲዛይሳ ኦይኪዶስ፤ ሃይታ ኣሞሬ ዴሬ ካዎታፔ ዎꬂ ኤኪዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","ሄርሞኔ ዙማዛ ሲዶና ኣሳይ፥ «ሲሪዮኔ» ጊዛይሳ ኣሞሬ ኣሳይ፥ «ሳኒሬ» ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","ኑኒ ጌዜ ቢታን ዲዛ ካታማታ ኡባ፥ ጋላኣዴ ቢታ ኡባ፥ ባሳኔ ቢታ ኡባኔ ባሳኔ ቢታን ኣጌይ ሃሪዛ ሳላካኔ ኤዲራኤ ካታማታ ጋካናስ ዲዛሶሆታ ኦይኪዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","ኤራፋይሜታ ባጋፌ ካዎ ኣጌይ ዉርሴꬃ ካዎ፤ ኢዚ ኢቺዛ ኣልጋይ ሚኖ ቢራታፔ ኦሴቲዴስ፤ ኣልጋስ ኣዱሳቴꬃይ ኦስፑን ዋꬋ ጊዲሺን ጎምፓይ ኦይዱ ዋꬋ፤ ሄ ኣልጋዚ ኤራባ ጌቴቲዛ ኣሞኔታ ካታማን ሃኢ ጋካናስ ቤቴስ። ");
INSERT INTO gmve_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","ሄ ቢታዮ ኑኒ ላቲዳፔ ኣርኖኔ ሻፋ ኣቻን ዲዛ ኣሮኤሬ ካታማፔ ዶሚዲ ፑዴሃ ባጋን ዲዛ ዴሬዛኔ ጌዜ ቢታን ዲዛ ጋላኣዴ ዴራፔ ባጋ ሄን ዲዛ ካታማታራ ኦሮቤሌ ዜሬꬃታሲኔ ጋዴ ዜሬꬃታስ ኢማዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","ጋላኣዴ ዴሬፔ ኣቲዳ ቢታኔ ኣጌይ ሃሪዛ ባሳኔ ቢታ ኡባ፥ ሄሲካ ኣርጎባ ካዎቴꬃ ሚናሴ ዜሬꬃታፔ ባጋይታስ ኢማዲስ። (ሄ ባሳኔ ቢታ ኡባይ ኤራፋይሜታ ቢታ ጌቴቲ ጼይጌቴስ። ");
INSERT INTO gmve_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","ሚናሴ ቆሞ ጊዲዳ ያኢሬይ ኣርጎባ ዴሬ ኩሜꬃ ላቲዴስ፤ ሄሲካ ጌሹሬታኔ ማኢካቴ ዛዋ ጋካናስ ዲዛ ባሳኔ፤ ሄ ቢታያካ ኢዛ ሱንꬃን ጼይጌታዱስ፤ ሄሳ ጋሶን ሃኢ ጋካናስ ኢስቲ ያኢሬ ካታማታ ጌቴቴቴስ።) ");
INSERT INTO gmve_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","ቃሴ ጋላኣዴ ቢታካ ሚናሴ ቆሞ ማኪሬ ዜሬꬃታስ ኢማዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","ኦሮቤሌ ቆሞታሲኔ ጋዴ ቆሞታስ ጋላኣዴፔ ቢዲ ኣርኖኔ ሻፋ ኣቺ ጋካናስ ዲዛ ዴሬዛ ኢማዲስ፤ ዱጌሃ ባጋራ ኢስታ ዛዋይ ኣርኖኔ ሻፋ፤ ፑዴሃ ባጋ ዛዋይ ቃሴ ኣሞኔታ ዴሬን ዛዋ ቦላ ዲዛ ያቦቄ ሻፋዛ። ");
INSERT INTO gmve_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","ኣርሼይ ዉሊዛ ባጋራ ኢስታ ዛዋይ ኣራቤን ዴኢዛ ዮርዳኖሴ ሻፋ ጋኬስ፤ ሄሲካ ኪኔሬቴ ኣባፌ ዶሚዲ ፒዝጋ ዙማ ጋርሳን ዲዛ ማጺኔ ኣባ ጋካናሳ። ");
INSERT INTO gmve_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","ሄ ዎዴ ኢስታ ካሌꬃና ማላ ሃይሳፌ ካሊዛ ዎጋታ ታ ኢንቴስ ኢማዲስ፤ ጎዳ ኑ ጾሳይ ዮርዳኖሴፔ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ቢታ ኢንቴ ላታና ማላ ኢንቴስ ኢሚዴስ፤ ሄሳ ጊሻስ ኢንቴ ኢንቴ ኦላንቻታ ጊጺሲዲ ሃንኮ ኢስራኤሌ ኣሳይ ባንታ ጺንጾ ላታና ጋካናስ ኢስታፌ ሲንꬃቲ ኦሌታናስ ኣꬊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","ኢንቴስ ዳሮ ሜሄይ ዲዛይሳ ታ ኤራይስ፤ ሄሳ ጊሻስ ኢንቴ ማቼቲ፥ ናይቲኔ ሜሄቲ ጻላ ሃን ኣቴቶ፤ ኢስቲ ታኒ ኢንቴስ ኢሚዳ ካታማታን ዴቶ። ");
INSERT INTO gmve_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","ኢንቴ ጎዳይ ሃይሳን ኢንቴና ሼምፒሶይሳꬆ ኢንቴ ኢሻንታካ ዮርዳኖሴፔ ኣርሼይ ዉሊዛ ባጋራ ጎዳይ ኢስታስ ኢሚዛ ቢታዮ ጌሊዲ ሳሮቴꬃን ሼምፓና ጋካናስ ኢንቴ ኢስታ ማዲቴ፤ ሄሳፌ ጉዬ ታኒ ኢንቴስ ኢሚዳ ቢታዮ ሃ ሲማናስ ዳንዳዬታ። ");
INSERT INTO gmve_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","ሃይሳፌ ጉዬ ታኒ ኢያሶ፥ «ጎዳ ኢንቴ ጾሳይ ሴዎኔኔ ኣጌ ጌቴቲ ጼይጌቲዛ ናምኡ ካዎታ ቦላ ኦꬆይሳ ኢንቴ ኢንቴ ኣይፌራ ቤኢዴታ፤ ኢንቴ ኢስታ ቢታ ላቲዛ ዴሬ ኡባ ቦላ ሃይሳ ማላ ኦሶ ዛሪ ኦꬃና። ");
INSERT INTO gmve_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","ኢንቴስ ኦሌታናይ ጎዳ ኢንቴ ጾሳ ጊዲዳ ጊሻስ ኢንቴ ኢስታስ ባቦፍቴ» ጋ ዞራዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","ሄ ዎዴ ታኒ ኬሃ ዎሳሼ፥ ");
INSERT INTO gmve_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","«ኡባፌ ꬎቃ ጎዳዉ! ኔ ጊታቴꬃኔ ኔ ሚኖ ቄሴዛ ታስ ኔ ኣይሌዛስ ቤሶ ዶማዳሳ፤ ኔኒ ኦꬂዛ ጊታኔ ዎልቃማ ኦሶታ ኦꬂዛ ሃራ ጎዳይ ሳሎንካ ሳኣንካ ዴና። ");
INSERT INTO gmve_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","ጎዶ! ታኒ ዮርዳኖሴ ሻፋ ፒናዳ ሄ ፒንꬃን ዲዛ ሎኦኔ ሻራ ሜንꬆሶን ዲዛ ጪሊላ ቢታዮኔ ሊባኖሴ ዙማ ታ ቤኣናይሳ ታና ዲጎፋርኪ!» ጋዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","ጊዶ ኣቲን ኢንቴ ጋሶን ጎዳይ ታ ቦላ ሃንቄቲዲ ታ ዎሳ ሲያናይሳ ኢጺዲ፥ «ሂኣ ኔስ ጊዳና! ሃይሳ ናምኣንꬆ ዴንꬆፋ! ");
INSERT INTO gmve_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","ሄሳ ኣጋዳ ዴንዳዳ ፑዴ ፒዝጋ ዙማ ቦላ ኬዛ፤ ሂስታዳ ኔ ኣይፌይ ዴማናስ ዳንዳይዛ ኬና ዴሬይሲ ፑዴሃኔ ዱጌሃ ባጋ፥ ኣርሼ ሞኪዛ ባጋኔ ዉሊዛ ባጋ ዩሻ ጼላ፤ ጋሶይካ ኔኒ ዮርዳኖሴ ፒና ባና ማላ ኔስ ፒቃዴይ ኢሜቲቤና። ");
INSERT INTO gmve_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","ጊዶ ኣቲን ኔኒ ኢያሶስ ኣዛዞ ኢማ፤ ኢዛ ጻሊሳኔ ሚንꬄꬃ፤ ጋሶይካ ኢዚ ዴራ ካሌꬂዲ ዮርዳኖሴ ሻፋ ፒንꬃና፤ ሃኖ ኔ ቤኢዛ ቢታዮ ኢዚ ኢስታ ላቲሳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","ሄሳ ጋሶን ቤቲ-ፔኦሬ ካታማፔ ሲንꬃ ባጋራ ዲዛ ሾባን ጋምኢዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","ሄሳፌ ጉዬ ሙሴይ ኣሳስ፥ «ሃኢካ ኢስራኤሌ ኣሳዉ! ኢንቴ ዴኦን ዳና ማላኔ ጎዳ ኢንቴ ኣዋታ ጾሳይ ኢንቴስ ኢሚዛ ቢታ ኢንቴ ላታና ማላ ታኒ ኢንቴና ታማርሲዛ ዎጋኔ ማራ ሲዪቴ! ቃሴካ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","ታ ኢንቴስ ኢሚዛ ዎጋ ቦላ ኣይኮካ ጉጆፍቴ፤ ኣይኮካ ኢዛፔ ፓጪንቾፍቴ፤ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ታ ባጋራ ኢሚዳ ዎጋስ ኣዛዜቲዛይታ ጊዲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","ጎዳይ ባኣሊ-ፔኦሬ ዙማ ቦላ ኦꬆይሳ ኡባካ ኢንቴ ኢንቴ ኣይፌራ ቤኢዴታ፤ ኢዚ ሄ ዙማ ቦላ ባኣሌ ጌቴቲዛ ኤቃ ጾሳስ ጎይኒዛይታ ኡባ ኢንቴ ጊዶፌ ꬋይሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","ኢንቴ ጊዲኮ ጎዳ ኢንቴ ጾሳስ ኣማኔቲ ኤቂዳይታ ጊዲዳ ጊሻስ ሃች ጋካናስ ሼምፖራ ፓጻ ዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","«ጎዳ ታ ጾሳይ ታ ኢንቴስ ዮታና ማላ ታና ኣዛዚዳ ዎጋኔ ማራ ኡባ ኢንቴና ታማርሳዲስ፤ ኢንቴ ጌሊዲ ላታና ቢታይን ሄ ኣዛዞታ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","ኢንቴ ኢስታ ናጊቴኔ ፖሊቴ፤ ኢንቴ ሄሳꬆ ኦꬂዛ ጊዲኮ ኢንቴ ኣይ ኬና ኣꬎ ኤራንቻታኔ ኣኬኪዛይታ ሃራ ዴሬ ኣሳይ ኢንቴና ቤኣና፤ ኢስቲ ሃ ኣዛዞታ ሲዪዛ ዎዴ፥ ‹ቱሙካ ሃ ጊታ ካዎቴꬃይ ኣꬎ ኤራንቻኔ ኣኬካንቻ ዴሬ› ጋና። ");
INSERT INTO gmve_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","ጎዳ ኑ ጾሳይ ኑ ዎሲሺን ማታ ጊዲዳ ማላ ኢዛ ጎዳይ ኢዛስ ማታ ጊዲዳ ሃራ ጊታ ካዎቴꬂ ኦኔ? ");
INSERT INTO gmve_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","ታኒ ሃች ኢንቴ ሲንꬃን ዎꬂዛ ሃ ኣዛዞዛ ማላ ሱሬኔ ሊኬ ጊዲዳ ዎጋይኔ ማራይ ዲዛ ሃራ ኣይ ጊታ ካዎቴꬂ ዲዜ? ");
INSERT INTO gmve_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","«ሂስቲኮ ኢንቴ ዲዛ ዎዴ ኡባን ሃይሳ ኢንቴ ኢንቴ ኣይፌራ ቤኢዳይሳ ኡባ ባሎንታ ማላኔ ኢንቴ ዎዚናፔ ꬋዮንታ ማላ ናጌቲቴ፤ ኢንቴ ናይታኔ ኢንቴ ናይታ ናይታካ ታማርሲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","ሲና ዙማ ቦላ ጎዳ ኢንቴ ጾሳ ሲንꬃን ኢንቴ ኤቂዳ ዎዴ ኢዚ ታና፥ ‹ኢንቴ ዴኢዛ ዎዴ ኡባን ኢስቲ ታስ ያሻቴꬅ ታማራና ማላ፥ ባንታ ናይታካ ታማርሳና ማላኔ ታ ቃላ ሲያና ማላ ዴራ ታኮ ሺሻ› ጊዳይሳ ኣኬኪቴ። ");
INSERT INTO gmve_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","«ሳሎ ጋኪዛ ታማ ላጮይኔ ꬊፒ ጊዳ ጩዋይኔ ሻራይ ኢዛ ጎዚ ኦይኪዳ ዙማ ጋርሳን ሺቂ ኤቂዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","ሄሳꬆካ ጎዳይ ታማ ላጮ ጊዶን ዲሼ ኢንቴስ ሃሳይዴስ፤ ሂስቲን ኢዚ ሃሳይዛ ቃላ ሲዪዴታ ኣቲን ኢዛ ሜꬋ ሙሌካ ቤኢቤኬታ። ");
INSERT INTO gmve_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","ኢንቴ ኦꬃናስ ቤሲዛ ባ ጫቆ ቃላ ኢንቴስ ቆንጪሲዴስ፤ ሄሲካ ማሴቲዳ ናምኡ ሹቻታ ቦላ ጻፌቲዳ ታሙ ኣዛዞታ። ");
INSERT INTO gmve_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","ኢንቴ ጌሊ ላታና ቢታይን ዲሼ ኢንቴ ኦꬃናስ ቤሲዛ ዎጋታኔ ማራታ ታ ኢንቴና ታማርሳና ማላ ጎዳይ ታና ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","«ጎዳይ ሲና ዙማ ቦላን ታማ ላጮ ጊዶፌ ኢንቴስ ሃሳይዛ ጋላስ ኣይ ሜꬋካ ቤኦንታ ጊሻስ ኬሂፔ ናጌቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","ሄሲካ ኣዴ ዎይኮ ማጫ ሚሳቲሲ ኤቃ ሚስሌ ሜꬊዲ ኢዛን ኢንቴ ቱኖንታ ማላሳ። ");
INSERT INTO gmve_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","ቢታ ቦላ ዴኢዛ ሜሄኔ ዶኣ ሌሚሶ ዎይኮ ሳሎ ጉፋንꬆን ፒራꬊዛ ካፎ ጊዲን፥ ");
INSERT INTO gmve_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","ዎይኮ ቢታ ቦላራ ቲራን ጎሼቲዛ ሜꬌቴꬃታኔ ሞሌ ሚስሌታ ኢንቴስ ኦꬂዲ ጎይኖፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","ቃሴ ሳሎ ፑዴ ጼሊዲ ኢንቴ ጎዳይ ኣሳ ኡባስ ኢሚዳ ኣርሼ፥ ኣጊና፥ ጾሊንቴኔ ሳሎ ሜꬌታ ኡባ ቤኢዲ ኢንቴ ኢስታስ ጎይኒዲ ባሎንታ ማላ ናጌቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","ኢንቴ ጊዲኮ ታማይ ኢዛን ኤጺዛ ቢራታ ጮጬ ሚሳቲዛ ጊብጼፔ ኢንቴና ጎዳይ ሾዲ ኬሲዳይ ኢንቴ ኢዛስ ዱማ ዴሬ ጊዳና ማላሳ። ");
INSERT INTO gmve_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","«ጎዳይ ኔ ጋሶን ታ ቦላ ሃንቄቲዲ ዮርዳኖሴ ሻፋ ታ ፒና ቦንታ ማላኔ ኢዚ ኢንቴና ላቲሲዛ ሄ ጪሊላ ቢታዮ ታ ቤኦንታ ማላ ታስ ጫቂ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","ሄሳ ጊሻስ ታኒ ዮርዳኖሴ ሻፋ ፒኖንታ ሃኒን ሃይቃና ዳይስ፤ ኢንቴ ጊዲኮ ፒኒዲ ሄ ቢታዮ ላታና። ");
INSERT INTO gmve_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","ሄሳ ጊሻስ ጾሳይ ኢንቴናራ ጌሊዳ ጫቆ ቃላ ኢንቴ ባሎንታ ማላ ሻኪ ኤሪቴ፤ ጎዳ ኢንቴ ጾሳይ ኢንቴና ኦꬆፍቴ ጊዲ ኣዛዚዳ ኤቃ ሚስሌታ ኣይ ሜꬋንካ ሚሳቲሲ ኦꬂ ኬሶፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","ጋሶይካ ጎዳ ኢንቴ ጾሳይ ጹጊዛ ታማኔ ቃናቲዛ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","«ኢንቴ ሄ ቢታይን ናይታኔ ናይታ ናይታ ዬሊዲ ኡፋይሳን ዴኢዛ ላይꬅ ኡባን ኢንቴናቴꬃ ቱኒሲዲ ኣይ ሜꬋን ጊዲኮካ ሚስሌ ሚሳቲሲ ሜꬊዲ ጎዳ ኢንቴ ጾሳ ሲንꬃን ሄሳ ማላ ኢታ ኦꬂዲ ኢዛ ሃንቄꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","ኢንቴ ሄሳ ኦꬂኮ ዮርዳኖሴ ሻፋ ፒኒዲ ላታና ቢታይን ዳሮ ላይꬅ ጋምኦንታይሳኔ ኢንቴ ሙሌራ ꬋያናይሳ ታኒ ሃች ኢንቴ ቦላ ሳሎኔ ሳኣ ማርካ ዎꬃ ዮታይስ። ");
INSERT INTO gmve_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","ጎዳይ ኢንቴና ሃራ ካዎቴꬃታ ጊዶን ላላና፤ ኢንቴ ቢ ላሌቲዳሶን ኢንቴፌ ኣማርዳይቲ ጻላ ኣታና። ");
INSERT INTO gmve_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","ሄን ኢንቴ ሚꬃፌኔ ሹቻፌ ኣሳ ኩሼን ኦሴቲዲ ጼሎንታ፥ ሲዮንታ፥ ሞንታኔ ሲንጎንታ ኤቃ ጾሳታስ ጎይናና። ");
INSERT INTO gmve_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","ጊዶ ኣቲን ኢንቴ ሄን ዲሼ ጎዳ ኢንቴ ጾሳ ኩሜꬃ ዎዚናፔኔ ኩሜꬃ ሼምፖፌ ኮይኮ ኢንቴ ኢዛ ዴማና። ");
INSERT INTO gmve_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","ሃ ኡባ ሜቶይ ኢንቴና ጋኪን ኢንቴ ሜቶቲሼ ዉርሴꬃን ጎዳ ኢንቴ ጾሳኮ ሲሚዲ ቃሴካ ኢዛስ ኣዛዜታና። ");
INSERT INTO gmve_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","ጎዳ ኢንቴ ጾሳይ ማሪዛ ጾሳ ጊዲዳ ጊሻስ ኢንቴና ሙሌራ ኣጌና፤ ኢንቴና ኡባካ ꬋይሴና፤ ካሴ ኢንቴ ኣዋታራ ጌሊዳ ጫቆ ቃላ ሙሌካ ባሌና። ");
INSERT INTO gmve_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","«ጾሳይ ኣሴ ቢታ ቦላ ሜꬎሶፌ ዶሚዲ ኢንቴ ዬሌታናፔ ካሴ ኣꬊዳ ዎዴታ ጾሞሲቴ፤ ቢታ ጋጻፔ ጋጻ ጋካናስ ፒልጊ ጼሊቴ፤ ሃይሳፌ ካሴ ሃይሳ ማላ ጊታ ሚሺ ሙሌካ ሃኒ ኤሪዜ? ዎይኮ ሲዬቲ ኤሪዜ? ");
INSERT INTO gmve_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","ታማ ላጮ ጊዶራ ጾሳይ ሃሳዪን ሲዪዲ ኢንቴ ꬋዮንታ ሼምፖራ ፓጻ ዴኦን ዲዛ ማላ ጾሳይ ሃሳዪን ሲዪዲ ሼምፖራ ፓጻ ዴኦን ዲዛ ሃራ ኣሲ ዲዜ? ");
INSERT INTO gmve_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","ዎይኮ ጎዳ ኢንቴ ጾሳይ ኢንቴ ጼሊሺን ጊብጼ ቢታን ኢንቴስ ኦꬂዛይሳꬆ ፓጬን፥ ማላታን፥ ማላሊሲዛ ሚሻን፥ ኦላን፥ ሚኖ ቄሴኒኔ ሚጬቲዳ ኩሼን፥ ቃሴ ያሺሲዛ ባ ዎልቃን ሃራ ካዎቴꬃታ ጊዶ ጌሊዲ ኢሲ ካዎቴꬅ ባስ ኤካናስ ባጼቲዳ ሃራ ጾሲ ዲዜ? ");
INSERT INTO gmve_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","ጎዳይ ኢዛ ጻላ ጊዲዳይሳ ኢንቴ ኤራና ማላ ሃይሳ ኢዚ ኢንቴና ቤሲዴስ፤ ኢዛፔ ኣቲን ሃራ ጾሲ ዴና። ");
INSERT INTO gmve_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","ኢዚ ኢንቴና ታማርሳናስ ኮዪዳ ጊሻስ ባ ጬንጉርሳ ሳሎፔ ሲሲዴስ፤ ቃሴካ ሳኣ ቦላ ያሺዛ ጊታ ታማ ኢንቴና ቤሲዴስ፤ ሄ ታማዛ ጊዶፌ ኢዛ ጬንጉርሳ ሲዪዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","ኢዚ ሄሳꬆ ኦꬂዳይ ኢንቴ ኣዋታ ዶሲዳ ጊሻሲኔ ኢስታ ዜሬꬃታ ዶሪዳ ጊሻስ ባ ጊታ ዎልቃን ኢንቴና ጊብጼፔ ኬሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","ሃች ኢንቴ ቤኢዛ ማላ ኢንቴና ጌልꬃናሲኔ ኢስታ ቢታ ጺንጾ ኦꬂ ኢንቴስ ኢማናስ ኢንቴፌ ዳሪዛይታኔ ዎልቃቲዛ ካዎቴꬃታ ኢንቴ ሲንꬃፌ ጎዲ ኬሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","«ሄሳ ጊሻስ ሳሎንካ ሳኣንካ ጎዳይ ኢዚ ጻላ ጾስ ጊዲዳይሳኔ ኢዛፔ ሃራ ጾሲ ባይንዳይሳ ኤሪቴ፤ ኢንቴ ዎዚናን ዎꬂቴ። ");
INSERT INTO gmve_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","ኢንቴሲኔ ኢንቴፌ ጉዬን ያና ኢንቴ ዜሬꬃስ ሎኦ ጊዳና ማላ ቃሴ ጎዳ ኢንቴ ጾሳይ ሜርናስ ኢንቴስ ኢሚዛ ጺንጾይን ኢንቴ ላይꬂ ኣዱቃና ማላ ታኒ ሃች ኢንቴና ኣዛዚዛ ዎጋኔ ማራ ናጊቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","ሄሳፌ ጉዬ ሙሴይ ዮርዳኖሴ ሻፋፔ ሄ ፒንꬃን ኣርሼይ ሞኪዛ ባጋራ ሄꬑ ካታማታ ሻኪ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","ኢዚ ሄሳꬆ ኦꬂዳይ ካሴ ሞርኬቴꬂ ባይንዳ ኤሮንታ ዲሼ ኣስ ዎꬊዳ ኣይ ኣሲካ ሄ ካታማታፔ ኢሲኔይን ባቃቲ ቢዲ ባ ሼምፖ ኣሻና ማላሳ። ");
INSERT INTO gmve_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","ሄሳ ጊሻስ ኦሮቤሌ ቆሞታስ ዙምቡላቲ ኡቲዳ ባዞን ዲዛ ባጺራ፥ ጋዴ ቆሞታስ ጋላኣዴን ዲዛ ኤራሞቴኔ ሚናሴ ቆሞታስ ባሳኔን ዲዛ ጎላኔ ካታማታ ሻኪ ሻኪ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","ሙሴይ ኢስራኤሌ ዴራስ ኢሚዳ ጎዳ ዎጋይ ሃይሳ። ");
INSERT INTO gmve_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","ጊብጼፔ ኬዚዳ ዎዴ ሙሴይ ዴራስ ዮቲዳ ኣዛዞይ፥ ዎጋይኔ ማራይ ሃይሳ ቦላን ጻፌቲዳይሳ። ");
INSERT INTO gmve_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","ሄይታንታ ኢዚ ኣዋጂዳይ ዮርዳኖሴ ሻፋፔ ኣርሼይ ሞኪዛ ባጋራ ቤቲ-ፔኦሬ ዙሌስ ሲንꬃ ባጋራ ዲዛ ኣሞሬታ ካዎይ ዲዛ ሃሴቦኔ ዴሬን፥ ሙሴይኔ ኢስራኤሌቲ ጊብጼፔ ኬኢ ኦሌቲዲ ጾኒዳ ሲሆኔ ዴሬና። ");
INSERT INTO gmve_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","ሄ ዎዴ ኢስቲ ኢዛ ቢታኔ ሄሳꬆካ ዮርዳኖሴፔ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ባሳኔ ዴሬ ሃሪዛ ኣሞሬ ካዎ ኣጌ ቢታ ላቲዳ። ");
INSERT INTO gmve_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","ሄ ቢታይ ኣርኖኔ ሻፋ ዶናን ዲዛ ኣሮኤሬ ካታማፔ ቢዲ ሲሪዮኔ ዙማ ጋኬስ፤ ሲሪዮኔ ጌቴቲዛ ዙማዚ ሄርሞኔ ዙማ። ");
INSERT INTO gmve_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","ሄ ቢታይካ ዮርዳኖሴ ሻፋፔ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ኣራቤ ዴሬ ኡባ ኤኪዲ ፒዝጋ ዙማ ጋርሳን ዲዛ ሃይቆ ኣባ ጋኬስ። ");
INSERT INTO gmve_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","ሙሴይካ ኢስራኤሌ ኣሳ ኡባ ኢሲ ቦላ ጼይጊዲ፥ «ኢስራኤሌ ኣሳዉ! ታኒ ሃች ኢንቴስ ኢሚዛ ዎጋኔ ማራ ኣኔ ዎዚናን ዎꬂ ሲዪቴ፤ ኢስታ ሎኤꬂ ታማርቴኔ ሚንꬂ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","ጎዳ ኑ ጾሳይ ሲና ዙማ ቦላ ኑናራ ጫቆ ቃላ ጌሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","ኢዚ ኑ ኣዋታራ ጻላ ጊዶንታ ሃኢ ሼምፖራ ፓጻ ዲዛ ኑናራካ ጫቄቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","ሄን ሄ ዙማ ቦላ ኤጺዛ ታማ ጊዶን ዲሼ ጎዳይ ኢንቴና ቆንጬራ ሃሳይሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","ኢንቴ ታማዛስ ባቢዲ ፑዴ ዙማ ቦላ ኬዛናስ ያዪዳ ጊሻስ ታኒካ ሄ ዎዴ ጎዳይ ጊዛይሳ ኡባ ኢንቴስ ዮታናስ ኢንቴሲኔ ጎዳስ ጊዶን ኤቃዲስ። «ኢዚካ ታስ፥ ");
INSERT INTO gmve_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","‹ኔኒ ካሴ ኣይሌቴꬃን ሃሬታ ዲዛ ጊብጼ ዴሬፔ ኔና ዎዛ ኤኪዳይ ታና ጎዳ ኔ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","« ‹ታፔ ኣቲን ሃራ ጾሲ ኔስ ዶፖ። ");
INSERT INTO gmve_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","« ‹ሳሎን ጊዲን ሳኣን፥ ዎይኮ ቢታ ጋርሳን ዲዛ ሃꬃ ጊዶን ዲዛይታፔ ኣዎይሳካ ኔስ ሚስሌ ሜꬋዳ ጾሳ ማላ ጎይኖፋ። ");
INSERT INTO gmve_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","ታኒ ጎዳ ኔ ጾሳይ ኬሃ ቃናቲዛ ጾሳ፤ ሄሳ ጊሻስ ማሴቲ ኦሴቲዳ ኣይ ኤቃ ጾሳታስካ ጎይኖፋኔ ዚጎፋ፤ ታኒ ታና ኢጺዛይታ ዉርሳ ቃጻያይስ፤ ኢስታ ዜሬꬃታካ ሄꬓንꬆኔ ኦይዳንꬆ ዬሌታ ጋካናስ ታኒ ቃጻያና። ");
INSERT INTO gmve_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","ታና ዶሲዛይታሲኔ ታ ኣዛዞታ ናጊዛይታስ ጊዲኮ ሺ ዬሌታ ጋካናስ ታ ኪያቴꬃኔ ታ ሲቆ ታ ኢስታ ቤሳና። ");
INSERT INTO gmve_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","« ‹ታና ኔ ጎዳ ሱንꬃ ሃዳን ጼይጎፓ፤ ታ ሱንꬃ ሃዳን ጼይጊዛይታ ታ ቃጻዮንታ ኣጊኬ። ");
INSERT INTO gmve_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","« ‹ታኒ ጎዳይ ኔ ጾሳይ ኔና ኣዛዚዳ ማላ ሳምባታ ጋላሳ ዱማሳዳ ቦንቻ። ");
INSERT INTO gmve_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","ኔኒ ኦꬂዛ ኦሶ ኡባ ኡሱፑን ጋላሳታን ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","ላፑንꬆ ጋላሳይ ጊዲኮ ታስ ኔ ጎዳስ ዱማ ሼምፖ ጋላሳ፤ ሄ ጋላስ ኣይ ኦሶካ ኦꬆፋ፤ ኔና ጊዲን ዎይኮ ኔ ናይታ ጊዲን ኔስ ኦꬂዛይቲካ፥ ኔ ሜሄይካ፥ ኔ ዴሬን ቤቴ ኣሳታ ጊዲኮካ ሄ ጋላስ ኣይኮካ ኦꬆፍቴ፤ ኔ ሼምፒዛይሳꬆ ኢስቲካ ሼምፔቶ። ");
INSERT INTO gmve_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","ኔኒ ጊብጼ ቢታን ዴኢዛ ዎዴ ኣይሌ ጊዳዳ ዴኢዳይሳ ኣኬካ፤ ቃሴካ ጎዳ ኔ ጾሳይ ባ ሚኖ ቄሴኒኔ ባ ሚጬቲዳ ኩሼን ኔና ሄፔ ኬሲዳይሳ ዶጎፓ፤ ሳምባታ ጋላሳ ኔ ቦንቻና ማላ ጎዳ ኔ ጾሳይ ኣዛዚዳይ ሄሳሳ። ");
INSERT INTO gmve_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","« ‹ታኒ ጎዳ ኔ ጾሳይ ኔና ኣዛዚዳ ማላ ኔ ኣዋኔ ኔ ኣዮ ቦንቻ፤ ኔ ሄሳꬆ ኦꬂኮ ጎዳ ኔ ጾሳይ ኔስ ኢሚዛ ቢታይን ኔ ላይꬂ ኣዱቃናኔ ኔስ ኢንጄታና። ");
INSERT INTO gmve_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","« ‹ኣስ ዎꬎፓ፤ ");
INSERT INTO gmve_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","« ‹ላይማቶፓ፤ ");
INSERT INTO gmve_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","« ‹ካይሶቶፓ፤ ");
INSERT INTO gmve_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","« ‹ኦና ቦላካ ዎርዶ ማርካቶፋ፤ ");
INSERT INTO gmve_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","« ‹ኣሳ ማቾ፥ ኣሳ ኬꬅ፥ ኣሳ ጺንጾ፥ ኣሳ ኦሳንቻታ፥ ኣሳ ሜሄ፥ ኣሳ ሃሬ ጊዲን ሃራ ኣይ ኣቆታካ ኡባ ኣሞቶፋ› ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","«ኢንቴ ኢሲ ቦላ ሺቂዳሶን ጎዳይ ዙማ ቦላ ዲሼ ኢንቴስ ኡባስ ኢሚዳ ኣዛዞቲ ሃይታ፤ ታማን፥ ጊርዲ ጊዳ ꬉማኒኔ ሻራ ጊዶን ዲሼ ጊታ ጬንጉርሳን ኢዚ ኢንቴስ ዮቲዳ ኣዛዞቲ ሃይታ ጻላ፤ ኢዚ ሄይታካ ናምኡ ሹቻታ ቦላ ዎጪ ጻፊዲ ታስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","«ዙማዚ ታማን ጹጌቲዛ ዎዴኔ ꬉማ ጊዶፌ ጬንጉርሳ ኢንቴ ሲዪዳ ዎዴ ኢንቴና ካሌꬂዛይቲኔ ኢንቴ ኮራፒኔቲ ታኮ ዪዲ፥ ");
INSERT INTO gmve_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","‹ጎዳ ኑኒ ጾሳ ጬንጉርሳ ታማ ጊዶፌ ሲዪዳ ዎዴ ጎዳ ኑ ጾሳይ ባ ጊታቴꬂኔ ባ ቦንቾ ኑና ቆንጬን ቤሲዴስ፤ ጾሲ ኣሳራ ሃሳይዳፔ ጉዬን ኣሲ ሃይቆንታ ሼምፖራ ፓጻ ዴኣና ዳንዳይዛይሳ ኑ ሃች ቤይዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","ሃይሳፌ ጉዬ ጎዳ ኑ ጾሳ ጬንጉርሳ ኑ ሲዪዛ ጊዲኮ ኑ ሃይቃና፤ ሄ ዎልቃማ ታማይ ኑና ꬋይሳና ዳንዳዬስ፤ ሂስቲን ኑኒ ኣይስ ሃይቂዞኒ? ");
INSERT INTO gmve_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","ዴኦ ጾሳይ ታማ ጊዶን ዲሼ ዮቲን ኑ ሲዪዳ ማላ ኢዛ ጬንጉርሳ ሲዪዲ ሃይቆንታ ሼምፖራ ፓጻ ኣቲዳ ኣሲ ዳኔ? ");
INSERT INTO gmve_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","ሄሳ ጊሻስ ኔኒ ኢዛኮ ሺቃዳ ጎዳ ኑ ጾሳይ ጊዛይሳ ኡባ ሲያ፤ ሄሳፌ ጉዬ ኔ ሲዪዳይሳ ኡባ ኑስ ያዳ ዮታ፤ ኑኒካ ኢዛ ሲዪዲ ኣዛዜታና› ጊዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","«ጾሳይካ ኢንቴ ሄሳ ጊሺን ሲዪዲ ታስ፥ ‹ሃ ኣሳቲ ኔስ ዮቲዳይሳ ኡባ ታኒ ሲያዲስ፤ ኢስቲ ጊዳይሲ ኡባይ ሊኬ። ");
INSERT INTO gmve_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","ኢስታሲኔ ኢስታ ዜሬꬃታስ ሜርናስ ኡባ ሚሺ ሎኦ ጊዳና ማላ ኢስቲ ታስ ያያናሲኔ ታ ኣዛዞታ ኡባ ዎዴ ናጋናስ ሃይሳ ማላ ዎዚናይ ዲዛኮ ኣይ ማላ ሎኦሻ! ");
INSERT INTO gmve_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","ሃኢካ ኔኒ ባዳ ኢስቲ ባ ዱንካኔን ዱንካኔን ሲማና ማላ ኢስታስ ዮታ። ");
INSERT INTO gmve_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","ኔኒ ጊዲኮ ሃን ታ ኣቻን ኤቃ፤ ታኒ ታ ዎጋታ፥ ኣዛዞታኔ ማራታ ኡባ ኔስ ኢማና፤ ታኒ ኢስታስ ኢሚዛ ዴሬዪን ኢስቲ ሃ ኣዛዞታ፥ ዎጋታኔ ማራታ ናጋና ማላ ዴሬዛ ታማርሳ› ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","«ኢስራኤሌ ኣሳዉ! ጎዳ ኢንቴ ጾሳይ ኢንቴና ኣዛዚዳይሳ ኡባ ፖላናስ ጊጌቲቴ፤ ኢስታፌ ኢሲኖዮካ ሜንꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","ኡባ ሚሺ ኢንቴስ ሎኦ ጊዳና ማላኔ ኢንቴ ላታና ቢታይን ኢንቴስ ላይꬃይ ኣዱቃና ማላ ጾሲ ኢንቴና ኣዛዚዳይሳ ኡባ ፖሊቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","ኢንቴ ፒኒ ቢዲ ላታናስ ቢዛ ቢታን ኢንቴ ኦꬃና ማላኔ ታኒ ኢንቴና ታማርሳና ማላ ጎዳ ኢንቴ ጾሳይ ታና ኣዛዚዳ ኣዛዞቲ፥ ዎጋቲኔ ማራቲ ሃይታ። ");
INSERT INTO gmve_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","ኢንቴ ሄ ቢታይን ኣዱሳ ላይꬅ ዳና ማላ ኢንቴ፥ ኢንቴ ናይቲኔ ኢንቴ ናይታ ናይቲ ባንቲ ዲዛ ዎዴ ኡባን ጾሳስ ያያናሲኔ ታ ኢሚዳ ኣዛዞታ፥ ማራታኔ ዎጋታ ኡባ ናጋናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","ኢንቴኖ ኢስራኤሌ ኣሳዉ! ኡባ ሚሺ ኢንቴስ ሎኦ ጊዳና ማላ፥ ጎዳ ኢንቴ ኣዋታ ጾሳይ ኢንቴስ ጊዳይሳꬆ ማꬂኔ ኤሲ ጎጊዛ ቢታን ኢንቴ ኬሂ ጮራታና ማላ ሃ ኣዛዞታ ሲዪቴኔ ሚኒ ኦꬂቴ። ");
INSERT INTO gmve_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","ኢስራኤሌ ኣሳቶ! ኢንቴ ሃይሳ ኣኬኪቴ! ጎዳ ኑ ጾሳይ ኢዚ ጻላ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","ጎዳ ኔ ጾሳ ኔ ኩሜꬃ ዎዚናፔ፥ ኔ ኩሜꬃ ሼምፖፌኔ ኔ ኩሜꬃ ዎልቃፌ ሲቃ። ");
INSERT INTO gmve_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","ሃች ታ ኔና ኣዛዚዳ ኣዛዞታ ዎዚናን ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","ሃይታ ኣዛዞታ ኔ ናይታ ታማርሳ፤ ኔኒ ኔሶን ኡቲዛ ዎዴ ጊዲን ኦጌ ባሼካ፥ ኢቺዛ ዎዴ ጊዲን ቤጊዛ ዎዴ ኡባን ሃይታንታ ኣኬካሼ ዩሻ ቆፓ። ");
INSERT INTO gmve_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","ኔስ ማላታ ጊዳና ማላ ኔ ኩሼ ቦላ ቃቻ ቃሴካ ኔ ፒꬌ ቦላ ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","ኔ ኬꬃ ቆሲላꬃ ቦላኔ ጊቤ ፔንጌ ቦላ ጻፋ። ");
INSERT INTO gmve_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","ጎዳ ኢንቴ ጾሳይ ካሴ ኢንቴ ኣዋታስ ኣብራሃሜስ፥ ዪሳቃሲኔ ያቆቤስካ ጫቂዳ ቃላ ማላ ኢንቴና ኢዚ ሄ ቢታዮ ጌልꬂዛ ዎዴ ካሴ ኢንቴ ኬጾንታ ጊታኔ ሎኢዛ ካታማቲ ዲዛ ቢታዮ ላቲሳና። ");
INSERT INTO gmve_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","ኢንቴ ላታናይ ኢንቴ ኬጾንታ ሎኦ ሚሻን ኩሚዳ ኬꬃታ፥ ኢንቴ ቦኮንታ ሃꬃ ኦላታ፥ ኢንቴ ቶኮንታ ዎይኔ ሚꬃታኔ ዎጋራ ሚꬃታ፤ ሄይታንታ ኢዚ ኢንቴስ ኢሚዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","ካሴ ኢንቴ ኣይሌቴꬃን ዴዪዳ ጊብጼ ዴሬፔ ኢንቴና ዎዚ ኬሲዳ ጎዳ ኢንቴ ባሎንታ ማላ ናጌቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","ኢንቴ ጎዳ ጾሳስ ያዪቴ፤ ኢዛስ ጻላ ጎይኒቴኔ ኢዛ ሱንꬃን ጻላ ጫቂቴ። ");
INSERT INTO gmve_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","ኢንቴ ዩሾን ዲዛ ሃራ ዴሬ ኣሳይ ጎይኒዛ ኤቃ ጾሳታስ ጎይኖፍቴ፤ ");
INSERT INTO gmve_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","ጋሶይካ ኢንቴ ጊዶን ዴኢዛ ጎዳ ኢንቴ ጾሳይ ቃናቲዛ ጾሳ፤ ሄሳ ጊሻስ ኢዛ ሃንቆይ ኢንቴ ቦላን ታማ ማላ ኤጺ ኬዛና፤ ኢዚካ ኢንቴና ቢታ ቦላፌካ ሙሌራ ዲፒ ሂስቲ ꬋይሳና። ");
INSERT INTO gmve_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","ካሴ ኢንቴ ማሳን ኦꬂዳይሳꬆ ጎዳ ኢንቴ ጾሳ ፓጮፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","ኢዚ ኢንቴና ኣዛዚዳ ኣዛዞታ፥ ዎጋታኔ ማራታ ኡባ ሎኤꬂ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","ኢንቴስ ኡባ ሚሺ ሎኦ ጊዳና ማላ ጎዳ ሲንꬃን ኢንቴ ሱሬኔ ሎኦ ኦꬂቴ፤ ሂስቲኮ ኢንቴስ ኢማናስ ጎዳይ ኢንቴ ኣዋታስ ቃላ ጌሊዳ ሄ ሎኦ ቢታዮ ኢንቴ ላታና። ");
INSERT INTO gmve_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","ኢዚ ኢንቴስ ሂዶታ ቃላ ጌሊዳ ማላ ኢንቴ ኢንቴ ሞርኬታ ጎዲ ꬋይሳና። ");
INSERT INTO gmve_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","ጉዬፔ ያና ዎዴታን ኢንቴ ናይቲ፥ «ጎዳ ኑ ጾሳይ ሃይታ ኣዛዞታ፥ ዎጋታኔ ማራታ ቢርሼꬃይ ኣዜ?» ጊ ኦይቻና። ");
INSERT INTO gmve_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","ሄ ዎዴ ኢንቴ ቃሴ ኢስታስ፥ «ካሴ ኑኒ ጊብጼ ካዎስ ኣይሌቲዶስ ሺን ጾሳይ ኑና ባ ጊታ ዎልቃን ዎዚ ኬሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","ጊብጼ ኣሳ፥ ኢስታ ካዎዛኔ ኢስታ ሹሜታ ኬሂ ቆሂዛ ጊታ ማላታታ ኢዚ ኦꬂዛይሳ ኑኒ ኑ ኣይፌራ ቤኢዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","ካሴ ኑ ኣዋታ ላቲሳናስ ኢሚዳ ሂዶታ ቃላ ማላ ኑና ሃ ቢታዮ ላቲሳናስ ጊብጼፔ ዎዚ ኬሲዲ ሃ ኤሂዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","ሄሳፌ ጉዬ ሃች ሃኒዳይሳꬆ ኑስ ኡባ ዎዴካ ሎኦ ጊዳና ማላኔ ኑኒ ሼምፖራ ፓጻ ዴኣና ማላ፥ ኑኒ ኣዛዞታ፥ ዎጋታኔ ማራታ ናጋና ማላኔ ጎዳ ኑ ጾሳስ ያያና ማላ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","ጎዳ ኑ ጾሳይ ኑና ኣዛዚዳ ማላ ኢዛ ኣዛዞታ ኡባ ኑ ናጊኮ ሄሲ ኑስ ጺሎቴꬅ ጊዳና» ጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","ጎዳ ኢንቴ ጾሳይ ኢንቴ ላታናስ ቢዛ ቢታዮ ኢንቴና ጌልꬂዛ ዎዴ ቃሴካ ኢንቴፌ ዎልቃሚዛኔ ሚኒዛ ላፑን ካዎቴꬃታ ሄይቲካ ሂቴታ፥ ጌርጌሴታ፥ ኣሞሬታ፥ ካናኔታ፥ ፓሪዜታ፥ ሂዌታኔ ያቡሴታ ኢንቴ ሲንꬃፌ ꬎቃሊ ꬋይሳና። ");
INSERT INTO gmve_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","ጎዳ ኢንቴ ጾሳይ ሄ ዴሬታ ኢንቴ ኩሼን ኣꬂ ኢሚን ኢንቴ ኢስታ ጾኒዛ ዎዴ ኢስታ ኩሜꬅ ሱፑ ሂስቲ ꬋይሲቴ ኣቲን ኢስታራ ኣይ ቃላካ ጌሎፒቴኔ ኢስታስ ቃꬌቶፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","ኢስታራ ኤኬቶፍቴኔ ጌሌቶፍቴ፤ ኢንቴ ማጫ ናይታ ኢስታ ኣቱማ ናይታስ ኢሞፍቴ፤ ኢስታ ማጫ ናይታካ ኢንቴ ኣቱማ ናይታስ ኤኮፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","ጋሶይካ ኢንቴ ሄሳꬆ ኦꬆንታ ኣጊኮ ኢስቲ ኢንቴ ናይታ ጎዳ ካሊዛሶፔ ቤቲሲዲ ኤቃ ጾሳታ ካላና ማላ ኦꬃና፤ ሄ ዎዴ ጎዳ ሃንቆይ ኤጺ ኬዛናኔ ኢዚ ኢንቴና ሄራካ ኤሶን ꬋይሳና። ");
INSERT INTO gmve_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","ሄሳ ጊሻስ ኢንቴ ኢስቲ ያርሾ ያርሺዛሶዛ ላሊቴ፤ ኢስቲ ጎይኒዛ ቱሳ ማላታ ሹቻታ ኪንቼሬꬂ ዬጊቴ፤ ኣሼሮ ጌቴቲዛ ኤቃ ጾሳይ ሚስሌዛ ቲንቼሬꬂ ዬጊቴ፤ ማሴቲ ጊጊዳ ኤቃ ጾሳታ ሚስሌታካ ታማን ጹጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","ጋሶይካ ጎዳ ኢንቴ ጾሳይ ኢንቴና ባስ ጊዳና ማላ ዶሪዳ ዱማ ዴሬ፤ ቢታ ቦላ ዲዛ ዴሬ ኡባፌ ኢንቴ ኢዛስ ዱማ ዴሬ ጊዳና ማላ ዶሬቲዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","ጎዳይ ኢንቴና ሲቂዳይኔ ዶሪዳይ ኢንቴ ሃራ ኣሳፔ ቆዳን ዳሪዛ ጊሻስ ጊዴና፤ ኢንቴ ሃራ ዴራፔ ቆዳን ኬሂ ጉꬃታ። ");
INSERT INTO gmve_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","ጊዶ ኣቲን ጎዳይ ኢንቴና ሲቂዳ ጊሻሲኔ ካሴ ኢንቴ ኣዋታስ ጌሊዳ ሂዶታ ቃላ ናጋናስ ኮዪዳ ጊሻስ ኢዚ ኢንቴና ጊብጼ ካዎስ ኣይሌቴꬃን ዲዛ ጊብጼ ቢታፌ ባ ጊታ ዎልቃን ዎዚዲ ኬሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","ሄሳ ጊሻስ ጎዳ ኢንቴ ጾሳይ ሙሌራ ኣማኔቲዳ ጾሳ ጊዲዳይሳ ኢንቴ ዩሺ ቆፒቴ፤ ኢዚ ባ ጫቂዳ ቃላ ናጌስ፤ ኢዛ ዶሲዛይታሲኔ ኢዛ ኣዛዞ ፖሊዛይታስ ኡባስ ሺ ዬሌታ ጋካናስ ኢዚ ባ ሜርና ሲቆ ቤሳና። ");
INSERT INTO gmve_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","ጊዶ ኣቲን ባና ኢጺዛይታ ባ ሃሎ ኬሳና፤ ኢስታ ቦላ ባ ሃሎ ኬሳናስ ጋምኤና። ");
INSERT INTO gmve_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","ሄሳ ጊሻስ ታ ሃች ኢንቴና ኣዛዚዛ ኣዛዞታ፥ ዎጋታኔ ማራታ ሎኤꬂ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","ኢንቴ ሃ ኣዛዞታ፥ ዎጋታኔ ማራታ ሲዪዲ ሎኤꬂ ናጊኮ ጎዳ ኢንቴ ጾሳይ ካሴ ኢንቴ ኣዋታስ ጌሊዳ ጫቆ ቃላኔ ባ ሜርና ሲቆ ኢንቴስካ ሚንꬃና። ");
INSERT INTO gmve_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","ኢዚ ኢንቴና ሲቃና፤ ኣንጃናኔ ቆዳን ዳርሳና፤ ቃሴካ ኢዚ ኢንቴ ኣዋታስ ጫቂዳ ቢታይን ኢንቴ ዬሎታ፥ ኢንቴ ቢታይ ኢሚዛ ኣይፌታ፥ ካꬃ፥ ዎይኔኔ ዎጋራ ዛይቴ፥ ኢንቴ ሜሄታኔ ዶርሳ ዉዴታ ኡባ ዳርሲዲ ኣንጃና። ");
INSERT INTO gmve_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","ኢንቴ ማላ ኣንጄቲዳ ዴሬይ ኣላሜ ቦላ ሙሌካ ዴና፤ ኢንቴ ጊዶፌ ማጫ ጊዲን ዎይኮ ኣቱማስ ጊዲን ሄሳꬆካ ኢንቴ ሜሄታ ጊዶን ማይኔይ ቤቴና። ");
INSERT INTO gmve_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","ጎዳይ ሃርጌ ኡባፌ ኢንቴና ናጋና፤ ኢንቴ ካሴ ጊብጼን ዲሼ ቤኢዳ ኢታ ሃርጌታፔ ኣዎይሳካ ኢንቴ ቦላ ኤሄና፤ ጊዶ ኣቲን ኢዚ ባና ኢጺዛይታ ቦላ ሄ ሃርጌታ ኤሃና። ");
INSERT INTO gmve_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","ጎዳ ኢንቴ ጾሳይ ኢንቴ ኩሼን ኣꬂ ኢሚዳ ዴሬታ ኡባሲካ ቃꬌቶንታ ꬋይሲቴ፤ ኢንቴስ ዎጺማዴ ጊዶንታ ማላ ኢስታ ኤቃ ጾሳታስ ጎይኖፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","ኢንቴ ኢንቴ ዎዚናን፥ «ሃ ካዎቴꬃቲ ኑፔ ሚኔቴስ፤ ሂስቲን ኑ ኢስታ ዎስቲ ꬋይሳኔ?» ጊዲ ቆፖንታ ኣጌኬታ። ");
INSERT INTO gmve_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","ጊዶ ኣቲን ኢንቴ ኢስታስ ያዮፍቴ፤ ጎዳ ኢንቴ ጾሳይ ጊብጼ ካዎ ቦላኔ ሄ ዴሬ ኣሳ ኡባ ቦላ ኦꬂዳይሳ ዩሺ ቆፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","ጎዳ ኢንቴ ጾሳይ ኢንቴና ጊብጼፔ ኬሲዛ ዎዴ ኦꬂዳ ጊታ ቦሻታ፥ ማላታታ፥ ማላሊሲዛ ሚሻታ፥ ኢዛ ሚኖ ቄሴታኔ ሚጬቲዳ ኩሼታ ኢንቴ ኢንቴ ኣይፌን ቤኢዴታ፤ ሃኢ ኢንቴ ያዪዛ ኣሳ ኡባ ቦላንካ ጎዳ ኢንቴ ጾሳይ ሄሳꬆ ኦꬃና። ");
INSERT INTO gmve_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","ጎዳ ኢንቴ ጾሳይ ኢስታ ጊዶን ሺሮ ዴንꬃና፤ ኢንቴፌ ባቃቲዲ ቆቴቲዳይቲካ ሄራ ꬋያና። ");
INSERT INTO gmve_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","ሄሳ ጊሻስ ሄ ዴሬታስ ባቦፍቴ፤ ጎዳ ኢንቴ ጾሳይ ኢንቴናራ ዴስ፤ ኢዚ ጊታኔ ያሺሲዛ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","ጎዳ ኢንቴ ጾሳይ ሃይታ ካዎቴꬃታ ጉꬃራ ጉꬃራ ሾዲ ኬሳና፤ ኢንቴ ኢስታ ኡባ ኢሲቶ ꬋይሶፍቴ፤ ኢንቴ ኢሲቶ ꬋይሲኮ ቢታ ቦላ ዶኣይ ዳሪዲ ኢንቴና ዋዪሳና። ");
INSERT INTO gmve_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","ጎዳ ኢንቴ ጾሳይ ኢንቴ ሞርኬታ ኢንቴ ኩሼን ኣꬂ ኢማና፤ ኢስቲ ኡባይ ዉራና ጋካናስ ኢዚ ኢስታ ጋርሳን ሺሮ ዴንꬃና። ");
INSERT INTO gmve_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","ቃሴካ ኢስታ ካዎታ ኢዚ ኢንቴ ኩሼን ኣꬂ ኢማና፤ ኢንቴ ኢስታ ሱንꬃ ሙሌራ ቢታፌ ꬋይሳና፤ ኢንቴ ኢስታ ꬋይሳና ጋካናስ ኢንቴናራ ኤቄቲ ዳንዳያና ኣይ ኣሲካ ዴና። ");
INSERT INTO gmve_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","ኢስታ ኤቃ ጾሳታ ኡባ ታማን ጹጊቴ፤ ሄ ኤቃ ጾሳታ ቦላ ዲዛ ዎርቃኔ ቢራ ኣሞቲዲ ኢንቴስ ኤኮፍቴ፤ ጎዳ ኢንቴ ጾሳይ ኤቃ ጾሳታስ ጎይኖ ኢጺዛ ጊሻስ ኢንቴ ኤኪኮ ኢዚ ኢንቴስ ዎጺማዴ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","ሃ ቱኒዳ ኤቃ ጾሳታ ኢንቴሶ ጌልꬆፍቴ፤ ኢንቴ ኢንቴሶ ጌልꬂኮ ኢስቲ ꬋይዛይሳꬆ ኢንቴካ ꬋያና፤ ኢስቲ ꬋያናስ ቤሲዛ ጊሻስ ኢንቴ ኢስታ ኢጺቴኔ ሃራሴቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","ኢንቴ ሼምፖራ ፓጻ ዳና ማላ፥ ኢንቴ ቆዳይ ዳራና ማላኔ ጎዳይ ካሴ ኢንቴ ኣዋታስ ኢማናስ ጫቂዳ ቢታዮ ላታናስ ኢንቴ ዳንዳያና ማላ ሃች ታ ኢንቴስ ኢሚዛ ኣዛዞዮ ኣማኔቲዲ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዳ ኣዛዞታ ኢንቴ ናጊዛኮኔ ናጎንታኮ ኢንቴ ዎዚናን ዲዛ ቆፋ ኤራናስ፥ ኢንቴና ፓጫናሲኔ ኢንቴና ኣሽኬሳናስ ኦይዱ ታሙ ላይꬅ ኩሜꬅ ሜቶ ጊዶራ ኣꬂዲ ኢዚ ኢንቴና ዎስቲ ዎስቲ ካሌꬂዳኮ ኣኔ ዩሺ ቆፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","ኣሲ ጾሳ ዶናፔ ኬዚዛ ቃላን ኣቲን ካꬃን ጻላ ሼምፖራ ፓጻ ዳናስ ዳንዳዮንታይሳ ታማርሳናስ ኢንቴና ጋፊሲዴስ፤ ኢንቴኒኔ ኢንቴ ኣዋቲ ኤሮንታ ማና ሚዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","ሄ ኦይዱ ታሙ ላይꬃታ ጋርሳን ኢንቴ ማይኢዳ ማይኦይ ዉሪቤና፤ ሄሜꬃ ዳሮን ኢንቴ ቶሆይ ኪጺቤና። ");
INSERT INTO gmve_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","ኣዋይ ባ ና ሴሪዛይሳꬆ ጎዳ ኢንቴ ጾሳይ ኢንቴና ሴሪዛይሳ ዩሺ ቆፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","ኢዛ ካሊሼኔ ኢዛስ ያዪሼ ጎዳ ኢንቴ ጾሳ ኣዛዞታ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","ጋሶይካ ጎዳ ኢንቴ ጾሳይ ኢንቴና ሾባፌኔ ዙምቡላታፔ ፑልቲ ጎጊዛ ቄሪ ሻፋቲኔ ፑልቲዛ ፑልቶቲ ዲዛ ሎኦ ቢታ ጌልꬃናስ ኤሂዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","ሄ ቢታያ ጊስቴይኔ ባንጋይ፥ ዎይኔይኔ ባላሴይ፥ ኦሮማኔይኔ ዎጋራ ኣይፌይ፥ ቃሴካ ኤሲ ኩሚዳ ቢታ። ");
INSERT INTO gmve_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","ሄ ቢታያካ ኢንቴ ፓጬይ ባይንዳ ካꬅ ሚዛ ቢታኔ ኢንቴስ ኣይኮይካ ፓጮንታ ቢታ፤ ሄ ቢታይን ዲዛ ሹቻታፔ ቢራታይ፥ ዙምቡላፌ ጻርቂማላይ ቤቴስ። ");
INSERT INTO gmve_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","ኢንቴ ሚዲ ካላና፤ ሂስቲዲ ኢዚ ኢንቴስ ኢሚዳ ሎኦ ቢታይ ጊሻስ ጎዳ ኢንቴ ጾሳ ኢንቴ ጋላታና። ");
INSERT INTO gmve_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","ኢንቴ ጎዳ ኢንቴ ጾሳ ዶጊዲ ታኒ ሃች ኢንቴስ ኢሚዛ ኣዛዞታ፥ ዎጋታኔ ማራታ ሞሮንታ ማላ ናጌቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","ኢንቴ ሚዲ ካሊዛ ዎዴኔ ሎኦ ኬꬅ ኬጺ ኡቲዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ሚዚኔ ዶርሳይ፥ ቢራይኔ ዎርቃይ ቃሴካ ሃራ ኣቆታቲ ኢንቴስ ዳሪዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","ኢንቴ ዎዚናይ ኦቶሬቶንታ ማላኔ ኢንቴ ጊብጼፔ ኣይሌቴꬃ ቢታፌ ኢንቴና ዎዚ ኬሲዳ ጎዳ ኢንቴ ጾሳ ባሎንታ ማላ ናጌቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","ማርዜ ሾሻይኔ ማሲማሶይ ኩሚዳ ኬሂ ሂርጊሲዛ ባዞራ ኢንቴና ካሌꬂዴስ፤ ኢዚ ኢንቴስ ሜላ ባዞን ሚኖ ዛላፌ ሃꬄ ፑልቲሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","ኢንቴና ኣሽኬሳናሲኔ ፓጫናስ ዉርሴꬃንካ ሎኦ ጊዳና ማላ ካሴ ኢንቴ ኣዋቲ ሚ ኤሮንታ ማና ባዞ ቢታን ኢንቴስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","ሄሳ ጊሻስ፥ «ኑኒ ኑ ዎልቃኒኔ ኑ ሚኖቴꬃን ዱሬቲዶስ» ጊ ቆፖፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","ኢንቴ ዱሬታና ማላ ኢንቴስ ዎልቃኔ ሚኖቴꬅ ኢሚዳይ ጎዳ ኢንቴ ጾሳ ጊዲዳይሳ ዩሺ ቆፒቴ፤ ኢዚ ሄሳꬆ ኦꬂዳይ ካሴ ኢንቴ ኣዋታስ ጌሊዳ ጫቆ ቃላ ሚንꬃናሳ። ");
INSERT INTO gmve_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","ጎዳ ኢንቴ ጾሳ ኢንቴ ዶጊዲ ኤቃ ጾሳታስ ጎይኒኮ፥ ኢስታስ ሃጋዛናስ ኢንቴ ሲንꬅ ኢንቴ ኢስታኮ ዛሪኮ፥ ኣዳካ ኢንቴ ꬋያናይሳ ሃች ታ ኢንቴና ሃራ ኤሪሳይስ። ");
INSERT INTO gmve_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","ጎዳ ኢንቴ ጾሳስ ኢንቴ ኣዛዜቶንታ ኢጺኮ ኢንቴ ጌዴ ሲንꬄ ሲንꬄ ቢሺን ኢንቴ ሲንꬃን ዲዛ ካዎቴꬃታ ꬋይሲዛይሳ ማላ ኢንቴናካ ꬎቃሊ ꬋይሳና። ");
INSERT INTO gmve_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","ኢንቴኖ ኢስራኤሌ ዴሬ ኣሳዉ! ሲዪቴ፤ ኢንቴ ኢንቴፌ ጊታቲዛኔ ዎልቃሚዛ ካዎቴꬃታ ቃሴ ኢስታስ ዲርሳ ጊምቤይ ሳሎ ጋኪዳ ጊታ ካታማታካ ላታናስ ሃች ዮርዳኖሴ ፒኔታ። ");
INSERT INTO gmve_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","ሄ ቢታን ዲዛ ኣሳይ ጌሳኔ ጉባ ጊታታኔ ኬሂ ሚኖታ፤ ኢስታስ፥ «ኦኒኔ ኤናቄ ዜሬꬃታራ ኤቄታናስ ዳንዳዬና» ጊሺን ኢንቴ ሲዪዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","ጊዶ ኣቲን ታማ ማላ ጹጊዛ ጎዳ ኢንቴ ጾሳይ ኢዚ ኢንቴፌ ሲንꬃራ ቢሺን ኢንቴ ሃች ቤኣና፤ ኢንቴ ጌዴ ሲንꬄ ሲንꬄ ጉጂሺን ኢዚ ኢስታ ጾኒ ጾኒ ባና፤ ሄሳ ጊሻስ ኢዚ ኢንቴስ ኢሚዳ ሂዶታ ቃላ ማላ ኢንቴ ኢስታ ꬎቃሊዲ ኤሶን ጎዲ ꬋይሳና። ");
INSERT INTO gmve_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","ጎዳ ኢንቴ ጾሳይ ኢስታ ኢንቴ ሲንꬃፌ ጎዲዳፔ ጉዬ ኢንቴ፥ «ጎዳይ ኑና ሃ ቢታ ኤሂዳይ ኑኒ ሎኦ ኦሶ ኦꬂዳ ጊሻሳ» ጊዲ ቆፖፍቴ፤ ጎዳይ ኢስታ ኢንቴ ሲንꬃፌ ጎዲ ኬሲዛይ ኢስታ ኢታቴꬃ ጊሻሳ። ");
INSERT INTO gmve_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","ኢንቴ ኢስታ ቢታ ላታና ማላ ጎዳ ኢንቴ ጾሳይ ኢስታስ ኣꬂ ኢሚዛይ ኢንቴ ጺሎኔ ሱሬ ኦꬂዳ ጊሻስ ጊዴና፤ ኢስቲ ኢታታ ጊዲዳ ጊሻሲኔ ጾሳይ ካሴ ኢንቴ ኣዋታስ ኣብራሃሜስ፥ ዪሳቃሲኔ ያቆቤስ ኢሚዳ ሂዶታ ቃላ ናጋናስ ኮዪዳ ጊሻስ ኢስታ ሾዲ ጎዳና። ");
INSERT INTO gmve_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","ጎዳ ኢንቴ ጾሳይ ሃ ሎኦ ቢታ ኢንቴና ላቲሲዛይ ኢንቴ ጺሎቴꬃ ጊሻስ ጊዴና፤ ጋሶይካ ኢንቴ ዎዚናይ ሙሜ። ");
INSERT INTO gmve_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","ጎዳ ኢንቴ ጾሳ ባዞን ኢንቴ ዎስቲ ሃንቄꬂዳኮ ባሎፒቴ፤ ኢንቴ ጊብጼፔ ኬዚዳ ጋላሳፌ ዶሚዲ ሃኖ ጋካናስ ኢንቴ ጎዳ ኢንቴ ጾሳ ቦላ ማካሊዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","ሲና ባዞን ኢዚ ኢንቴና ꬋይሳናስ ዴንዳና ጋካናስ ጎዳ ኬሂ ሃንቄꬂዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","ጎዳይ ኢንቴናራ ጫቄቲዳ ቃላይ ኢስታ ቦላ ጻፌቲዳ ሹቻታ ኤካናስ ታኒ ፑዴ ዙማ ቦላ ኬዛዳ ሄን ኣይኮካ ሞንታኔ ኡዮንታ ኦይዱ ታሙ ጋላሲኔ ኦይዱ ታሙ ቃማ ጋማኣዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","ሄሳፌ ጉዬ ኢንቴ ሄ ዙማ ጋርሳን ሺቂን ጎዳይ ታማ ጊዶፌ ሃሳይሺን ኢንቴ ሲዪዳ ቃላ ኢዚ ባ ኩሼራ ኢስታ ቦላ ጻፊዳ ናምኡ ሎቻ ሹቻታ ታስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","ኦይዱ ታሙ ጋላሳፌኔ ኦይዱ ታሙ ኦማርሳፌ ጉዬ ጎዳ ጫቆ ቃላይ ኢስታ ቦላ ጻፌቲዳ ናምኡ ሎቻ ሹቻታ ታስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","ሄሳፌ ጉዬ ጎዳይ ታስ፥ «ኔ ኤሶን ዙማ ቦላፌ ዱጌ ዎꬋ፤ ኔኒ ጊብጼፔ ካሌꬃ ኬሲዳ ኣሳይ ኢታ ሚሽ ኦꬂዲ ቱኒዴስ፤ ታ ኢስታስ ኢሚዳ ኣዛዞታፔ ኤሶን ካሬ ኬዚዲ ባንታስ ጎይናናስ ኤቃ ጾሳታ ሜꬊዳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","ቃሴካ ጎዳይ ታስ፥ «ሃይሲ ዴሬዚ ዎዚና ሙሜኔ ማካላ ጊዲዳይሳ ታ ኤራይስ። ");
INSERT INTO gmve_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","ታኒ ኢስታ ꬋይሳናይሳኔ ኢስታ ሱንꬃካ ቢታ ቦላፌ ቁጫ ꬋይሳናይሳ ታና ዲጎፋ፤ ኔና ኢስታፌ ሚኒዛይሳኔ ጮራቲዛ ካዎቴꬅ ኬሳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","ሄሳ ጊሻስ ጫቆ ቃላዚ ጻፌቲዳ ናምኡ ሎቻ ሹቻታ ናምኡ ኩሼን ኦይኪዳ ማላ ዙማ ቦላፌ ሲማዳ ዱጌ ዎꬋዲስ፤ ሄ ዎዴ ታማ ላጮይ ዙማ ቦላ ላጬስ። ");
INSERT INTO gmve_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","ኢንቴካ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዳ ኣዛዞታ ሜንꬂዲ ካሬ ኬዚዴታ፤ ዎርቃፌ ሴሪሲዲ ሜꬊዳ ማራ ሚስሌዛ ኢንቴስ ኤቃ ጾስ ኦꬂዴታ፤ ሄሳን ኢንቴ ኢንቴ ጎዳ ቦላ ማካሊዳይሳ ታ ቤኣዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","ሄሳ ጋሶን ኣዛዞቲ ኢስታ ቦላ ጻፌቲዳ ሎቻ ሹቻታ ታ ኢንቴ ሲንꬃን ቦላፌ ዬጋዳ ሜንꬄሬꬃዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","ሄሳፌ ጉዬ ኢንቴ ኬሂ ኢታ ናጋራ ኦꬂዲ ጎዳ ሃንቄꬂዳ ጋሶን ታኒ ኦይዱ ታሙ ጋላሲኔ ኦይዱ ታሙ ቃማ ጋካናስ ኣይኮካ ሞንታኔ ኡዮንታ ጎዳ ሲንꬃን ጉፋናዳ ጋምኣዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","ኢዚ ኢንቴና ኬሂ ሃንቄቲዲ ꬋይሳናስ ዴንዲዳ ጊሻስ ጎዳይ ሃንቂዛ ጊታ ሃንቆዚ ታና ባቢሲዴስ፤ ጊዲኮካ ጎዳይ ዛሪዲ ታ ዎሳ ሲዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","ጎዳይ ኣሮኔካ ꬋይሳናስ ኢዛ ቦላ ኬሂ ሃንቄቲዴስ፤ ሄሳ ጊሻስ ኢዛስካ ዎሳዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","ታኒ ኢንቴ ሜꬊዳ ሄ ናጋራን ኩሚዳ ማራ ሚስሌዛ ኤካዳ ታማን ጹጋዲስ፤ ኢዛካ ኪንቼሬꬃ ጉዱላ ማላ ሊቂሳዳ ዙማ ቦላፌ ዱጌ ጎጊዛ ሃꬃን ዬጋዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","ኢንቴ ቃሴካ ታቤሬን፥ ማሳኒኔ ኪብሮቴ-ሃታኣቤን ኢንቴ ጎዳ ሃንቄꬂዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","ጎዳይ ኢንቴና፥ «ቢቴ! ታ ኢንቴስ ኢሚዳ ሂዶታ ቢታዮ ላቲቴ» ጊዲ ኢንቴና ቃዴሴ ባሪኔፔ ኪቲዳ ዎዴ ኢንቴ ኢዛ ቦላ ማካሊዴታ ኣቲን ኢዛን ኣማኔቲቤኬታ፤ ኢዛ ቃላስካ ኣዛዜቲቤኬታ። ");
INSERT INTO gmve_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","ታ ኢንቴና ኤሮሶፌ ሃኖ ጋካናስ ኢንቴ ጎዳ ቦላ ማካሊዳ ማላ ዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","ጎዳይ፥ «ታኒ ኢስታ ꬋይሳና» ጊዲ ዮቲዳ ጊሻስ ታኒ ሄ ኦይዱ ታሙ ጋላሳታኔ ኦይዱ ታሙ ቃማታ ጎዳ ሲንꬃን ጉፋናዳ ጋምኣዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","ታኒ ዎሳሼ፥ «ኡባፌ ꬎቃ ጎዳዉ! ኔኒ ኔ ጊታ ዎልቃኒኔ ኔ ሚኖ ቄሴን ዎዛዳ ጊብጼፔ ኬሲዳ ኔ ዴሬዛ ꬋይሶፋርኪ! ");
INSERT INTO gmve_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","ካሴ ኔ ኦሳንቻታ ኣብራሃሜ፥ ዪሳቃኔ ያቆቤ ቆፓርኪ፤ ሃይሳ ዴራ ዎዚና ሙሜቴꬃ፥ ኢታቴꬃኔ፤ ናጋራ ኡባ ቆዶፓርኪ!» ጋ ዎሳዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","ኔ ሂስቶንታ ኣጊኮ ኑና ሄ ዴሬ ኣሳይ፥ «ጎዳይ ኢስታ ጌልꬃና ጊዲ ሂዶታ ኢሚዳ ቢታዮ ጌልꬃናስ ዳንዳዮንታ ጊሻሲኔ ኢዚ ኢስታ ኢጺዳ ጊሻስ ባዞ ቢታን ኢስታ ዎꬋናስ ኬሲዴስ» ጊዲ ሚጫና። ");
INSERT INTO gmve_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","ጊዶ ኣቲን ሃ ኣሳይ ኔኒ ኔ ጊታ ዎልቃኒኔ ኔ ሚኖ ቄሴን ኔስ ጊዳና ማላ ኔ ዶራ ኬሲዳ ዴሬ። ");
INSERT INTO gmve_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","ሄሳፌ ጉዬ ጎዳይ ታና፥ «ሃይሳፌ ካሴ ሜቂዳ ሎቻ ሹቻታ ማላ ሃራ ናምኡ ሹች ማሳ ጊጊሳ፤ ኢስታ ዎꬃናስ ታቦታ ሚꬃፌ ሜꬋ፤ ሂስታዳ ፑዴ ሃ ዙማ ሁኤ ኬዛ። ");
INSERT INTO gmve_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","ኔ ካሴ ሜንꬂዳ ሎቻ ሹቻታ ቦላ ጻፌቲዳ ኣዛዞታ ቃሴካ ታኒ ኢዛራ ጻፋና፤ ኔኒካ ኢስታ ታቦታዛ ጊዶን ዎꬃ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","ሄሳ ጊሻስ ታኒ ኦዶሮ ሚꬃፌ ታቦታ ጊጊሳዲስ፤ ካሴይታ ሚሳቲዛ ናምኡ ሎቻ ሹቻታ ማሳ ኤካዳ ፑዴ ዙማ ቦላ ኬዛዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","ኢንቴ ዙማ ጋርሳን ሺቂ ዲሺን ጎዳይ ታማ ጊዶን ዲሼ ኢንቴስ ቆንጪሲዳ ታሙ ኣዛዞታ ካሴይሳꬆካ ሃኢ ሎቻ ሹቻታ ቦላ ጻፊዲ ታስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","ሄሳፌ ጉዬ ታኒ ዙማ ቦላፌ ዱጌ ዎꬋዳ ጎዳይ ታና ኣዛዚዳ ማላ ሄ ማሴቲዳ ሎቻ ሹቻታ ታ ጊግሲዳ ታቦታ ጊዶን ዎꬃዲስ፤ ሄ ጋላሳፌ ሃኖ ጋካናስ ሄን ኢዛ ጊዶን ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","ኢስራኤሌ ኣሳይ ቢኤሮቲ-ቤኒ-ያቂኔ ኣሳታስ ሃꬃ ኦላይ ዲዛሶፔ ሞሴሬ ቢዳ፤ ኣሮኔይካ ሃይቂዲ ሄን ሞጌቲዴስ፤ ኢዛሶሆን ኢዛ ና ኤልኤዜሬይ ቄሴ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","ኣሳይ ሄሳፌ ዴንዲዲ ጌዴ ጉዲጎዳ ቢዴስ፤ ሄፔካ ዮጽባቴ ጌቴቲዛ ጎጊዛ ሃꬂ ዲዛሶ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","ሄ ዎዴ ሌዌ ቆሞቲ ጫቆ ቃላ ታቦታ ቶካና ማላ፥ ጎዳ ሲንꬃን ኤቂዲ ኢዛስ ኦꬃና ማላኔ ኣሳካ ጎዳ ሱንꬃን ኣንጃና ማላ ሹሚዴስ፤ ሃች ጋካናስ ሌዌ ቆሞታ ኦሶይ ሄሳ። ");
INSERT INTO gmve_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","ሄሳ ጋሶን ሌዌ ቆሞቲ ሃንኮ ቆሞታራ ጊሼታናስ ጺንጾይ ኢሜቶንታይሲ ሄሳሳ፤ ኢንቴ ጎዳይ ኢስታስ ዮቲዳ ማላካ ኢስታ ጺንጾይ ጎዳ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","ታኒ ካሴይሳꬆ ዎሳሼ ኦይዱ ታሙ ጋላሲኔ ኦይዱ ታሙ ቃማ ጋካናስ ጋምኣዲስ፤ ጎዳይ ሃኢካ ታ ዎሳ ሲዪዲ ኢንቴና ꬋይሶንታ ሼምፖራ ፓጻ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","ሄሳፌ ጉዬ ኢዚ ታና፥ «ሃኢ ኔ ባ! ታኒ ካሴ ኢስታ ኣዋታስ ኢሚዳ ሂዶታ ቃላ ማላ ኢስቲ ሄ ቢታዮ ላታና ማላ ዴራ ካሌꬃ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","ኢስራኤሌ ኣሳዉ! ጎዳይ ኢንቴፌ ኮይዛይ ሃይሳፌ ካሊዛይሳ፤ ጎዳ ኢንቴ ጾሳ ያዪቴ፤ ኢዛ ኦጌ ካሊቴ፤ ኢዛ ሲቂቴ፤ ኩሜꬃ ዎዚናፔኔ ኩሜꬃ ሼምፖፌ ኢዛስ ኦꬂቴ። ");
INSERT INTO gmve_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","ኢንቴስ ሎኣና ማላ ታኒ ሃች ኢንቴስ ኢሚዛ ጎዳ ኣዛዞታኔ ዎጋታ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","ሳሎይኔ ሳሎፔ ቦላን ዲዛ ሳሎቲ፥ ቢታይኔ ቢታ ቦላ ዲዛ ኡባይ ጎዳሳ። ");
INSERT INTO gmve_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","ጎዳይ ካሴ ኢንቴ ኣዋታ ኬሂ ሲቂዳ ጋሶን ኢንቴና ኣይዛቤታ ጊዶፌ ዶሪዴስ፤ ኢንቴካ ሃች ጋካናስ ኢዛስ ዶሬቲዳ ዴሬ ጊዲዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","ሄሳ ጊሻስ ኣኔ ሃይሳፌ ጉዬ ኢንቴ ዎዚና ሙሚሶፒቴኔ ኢንቴ ዎዚና ኢታቴꬃ ዲጊዲ ጎዳስ ኣዛዜቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","ጎዳ ኢንቴ ጾሳይ ጾሳ ጌቴቲዛ ኡባፌ ቦላ፤ ጎዳታስ ጎዳ፤ ኢዚ ጊታ፥ ሚኖኔ ያሺዛ ጾሳ፤ ኢዚ ማዲ ፒርዶንታ ጾሳኔ ማጋንጾ ኤኮንታ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","ኢዚ ዪኦታሲኔ ኣምኤታስ ፒርዴስ፤ ኢዚ ዴራ ጊዶን ዲዛ ቤቴ ኣሳታ ዶሲዛ ጊሻስ ካꬂኔ ማይኦ ኢስታስ ኢሜስ። ");
INSERT INTO gmve_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","ሄሳꬆካ ኢንቴ ካሴ ጊብጼ ቢታን ቤቴ ኣስ ጊዲዳ ጊሻስ ኢንቴካ ኢንቴ ጊዶን ዲዛ ቤቴ ኣሳታ ሲቂቴ። ");
INSERT INTO gmve_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","ጎዳ ኢንቴ ጾሳስ ያዪቴ፤ ኢዛስ ጻላ ጎይኒቴ፤ ኢዛን ኣማኔቲዲ ኢዛ ሱንꬃን ጫቂቴ። ");
INSERT INTO gmve_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","ኢንቴ ጾሳይ ኢዛ፤ ኢዚ ኢንቴስ ኦꬂዳ ጊታኔ ማላሊሲዛ ሚሻታ ኡባ ኢንቴ ኢንቴ ኣይፌን ቤኢዳ ጊሻስ ኡባ ዎዴ ኢዛ ጋላቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","ቤኒ ኢንቴ ኣዋቲ ዱጌ ጊብጼ ዎꬊዛ ዎዴ ኢስታስ ቆዳይ ላፑን ታሙ ጻላ፤ ሃኢ ጊዲኮ ጎዳ ኢንቴ ጾሳይ ኢንቴ ቆዳ ሳሎ ጾሊንቴ ማላ ዳርሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","ሄሳ ጊሻስ ጎዳ ኢንቴ ጾሳ ሲቂቴ፤ ኢዚ ኢንቴፌ ኮይዛ ኢዛ ዎጋ፥ ማራኔ ኣዛዞታ ኡባ ዎዴ ፖሊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","ጎዳ ኢንቴ ጾሳ ሴራዛ ሄሲካ ኢዛ ጊታቴꬃ፥ ኢዛ ዎልቃኔ ኢዛስ ዲዛ ማታ ቤኢዳይኔ ኤሪዛይ ኢንቴ ናይታ ጊዶንታ ኢንቴና ጊዲዳይሳ ዩሺ ቆፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","ማላታታኔ ኢዚ ጊብጼ ካዎ ቦላኔ ኩሜꬃ ዴራ ቦላ ኦꬂዳ ጊታ ኦሶታ ኢንቴ ኢንቴ ኣይፌራ ቤኢዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","ቃሴ ኢስቲ ኢንቴና ካሊዲ ዬዴꬂዳ ዎዴ ጎዳይ ጊብጼ ቢታ ኦላንቻታ፥ ኢስታ ፓራታኔ ፓራ-ጋሬታ ዞኦ ኣባን ሚቲሲዲ ሃች ጋካናስ ኢስታ ሙሌራ ꬋይሲዳይሳ ቤኢዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","ኢንቴ ባዞፌ ዴንዲዲ ሃ ሃይሳ ጋካናስ ጎዳይ ኢንቴስ ኣይ ኦꬂዳኮ ኢንቴ ኤሬታ። ");
INSERT INTO gmve_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","ኦሮቤሌ ቆሞታፔ ኤልያቤ ና ዳታኔኔ ኣብራሜ ቦላ ኢዚ ኦꬆይሳ ዩሺ ቆፒቴ፤ ኢስራኤሌ ናይቲ ቤዪሺን ቢታያ ዶዬታዳ ኢስታ፥ ኢስታሶ ኣሳ፥ ኢስታ ዱንካኔኔ ኢስታ ሃሮ ኡባ ሚታዱስ። ");
INSERT INTO gmve_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","ጎዳይ ኦꬂዳ ሃ ጊታ ኦሶታ ኡባ ኢንቴ ኢንቴ ኣይፌራ ቤኢዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","ሂስቲኮ ኢንቴ ፒኒዲ ላታና ቢታዮ ኦይካናስ ኢንቴ ዎልቃ ዴማና ማላ ታኒ ሃች ኢንቴስ ኢሚዛ ኣዛዞታ ኡባ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","ኢንቴ ኢዛ ኣዛዞታ ናጊኮ ጎዳይ ካሴ ኢንቴ ኣዋታሲኔ ኢስታ ዜሬꬃታስ ኢማናስ ጫቂዳ ኤሲኔ ማꬂ ኩሚዳ ሄ ሎኦ ቢታይን ኢንቴ ዳሮ ላይꬅ ዳና። ");
INSERT INTO gmve_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","ኢንቴ ላታናስ ጌላና ቢታያ ኢንቴ ኬዚዲ ዪዳ ጊብጼ ቢታ ማላ ጊዱኩ፤ ጊብጼን ኢንቴ ካꬅ ዜሪዳፔ ጉዬ ሃꬂ ካꬃ ጊዶ ባና ማላ ዛራዛ ኢንቴ ቶሆን ዬꬊ ዬꬊ ቤሴታ። ");
INSERT INTO gmve_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","ጊዶ ኣቲን ኢንቴ ዮርዳኖሴ ሻፋ ፒኒዲ ላታና ቢታያ ኢዚን ዙማቲኔ ሾባቲ ዲዛ ጊሻስ ኢዛ ኢራ ሃꬅ ኡዪዛ ቢታ። ");
INSERT INTO gmve_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","ሃኖ ሃ ቢታዮ ሎኤꬂ ኦይኪዛይኔ ላይꬅ ኩሜꬅ ናጊዛይ ጎዳ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","ሄሳ ጊሻስ ጎዳ ኢንቴ ጾሳ ሲቂቴ፤ ኩሜꬃ ዎዚናፔኔ ኩሜꬃ ሼምፖፌ ኢዛስ ኦꬂቴ፤ ታኒ ሃች ኢንቴስ ኢሚዛ ኣዛዞታ ፖሊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","ኢንቴ ሄሳꬆ ኦꬂኮ ኢንቴ ካꬃ፥ ዎይኔኔ ዛይቴ ፓጬይ ባይንዳ ሺሻና ማላ ጎዳይ ኢንቴስ ባꬌሳ ኢራኔ ባልጎ ኢራ ዎዴን ዎዴን ቡኪሳና። ");
INSERT INTO gmve_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","ጎዳይ ኢንቴ ሜሄታስ ማታ ዳርሳና፤ ኢንቴስ ኮሺዛ ካꬅ ኢሚን ኢንቴ ካላና። ");
INSERT INTO gmve_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","ኢንቴ ጎዳፔ ሃኪዲ ኤቃ ጾሳታስ ኦꬃናሲኔ ጎይናናስ ጉዬ ሲሞንታ ማላ ናጌቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","ኢንቴ ናጌቶንታ ኣጊኮ ጎዳ ሃንቆይ ኢንቴ ቦላ ኤጺ ኬዛና፤ ኢራይ ቡኮንታ ማላኔ ቢታይ ካꬅ ኢሞንታ ማላ ኢዚ ሳሎ ጎርዳና፤ ኢንቴካ ጎዳይ ኢንቴስ ኢሚዳ ሎኦ ቢታይፌ ኤሶን ꬋያና። ");
INSERT INTO gmve_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","ኢንቴ ሃ ኣዛዞታ ኡባ ዎዴ ኢንቴ ዎዚናኒኔ ኢንቴ ቆፋን ዎꬂቴ፤ ኢንቴስ ማላታ ጊዳና ማላ ኢስታ ኢንቴ ቄሴን ቃቺቴ፤ ቃሴካ ኢንቴስ ሊጴ ቦላካ ኦይꬂቴ። ");
INSERT INTO gmve_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","ኢንቴ ናይታ ታማርሲቴ፤ ኢንቴሶን ኡቲሼ ዎይኮ ኦጌን ሄሜቲሼካ ዎይኮ ሼምፒዛሶን ጊዲንካ ዎይኮ ኦሶ ኡባን ኢስታ ጊሻስ ሃሳዬቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","ኢንቴ ኬꬃ ፔንጌ ቆሲላꬃ ቦላኔ ኢንቴ ጊቤ ፔንጌ ቦላ ጻፊ ዎꬂቴ። ");
INSERT INTO gmve_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","ኢንቴ ሄሳꬆ ኦꬂኮ ኢንቴ ጎዳይ ካሴ ኢንቴ ኣዋታስ ኢማናስ ጫቂዳ ቢታይ ቦላ ኢንቴ ላይꬃይኔ ኢንቴ ናይታ ላይꬃይ ሳኣፔ ቢዲ ሳሎ ጋካና ኬና ኣዱቃና። ");
INSERT INTO gmve_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","ጎዳ ኢንቴ ጾሳ ሲቃናስ፥ ኢዛ ኦጌ ኡባ ካላናሲኔ ኢዛን ኣማኔታናስ ታኒ ሃች ኢንቴስ ኢሚዛ ኣዛዞታ ሚንꬂዲ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","ኢንቴ ሄሳꬆ ኦꬂኮ ጎዳይ ሃይታ ኢንቴ ሲንꬃን ዲዛ ካዎቴꬃታ ኡባ ኬሲ ጎዳና፤ ኢንቴኒካ ጮራቴꬃኒኔ ዎልቃን ኢንቴፌ ሚኖ ጊዲዳ ዴሬታ ቢታ ላታና። ");
INSERT INTO gmve_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","ኢንቴ ቶሆን ኢንቴ ዬꬊዳ ቢታይ ዉሪካ ኢንቴስ ጊዳና፤ ኢንቴ ዛዋይ ዱጌሃ ባጋራ ዲዛ ባዛፌ ቢዲ ፑዴሃ ባጋራ ዲዛ ሊባኖሴ ዙማ ጋካና፤ ቃሴካ ኣርሼይ ሞኪዛ ባጋራ ኤፊራጺሴ ሻፋፔ ቢዲ ኣርሼይ ዉሊዛ ባጋራ ዲዛ ሜዲቴራኔ ኣባ ጋካና። ");
INSERT INTO gmve_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","ኢንቴናራ ኣይ ኣሲካ ኤቄታናስ ዳንዳዬና፤ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዳ ሂዶታ ቃላ ማላ ኢንቴ ቢዛሶ ኡባን ኣሳይ ኢንቴና ቤኢዲ ዳጋማና ማላኔ ያያና ማላ ኦꬃና። ");
INSERT INTO gmve_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","ሄኮ! ታኒ ሃች ኣንጆፌኔ ቃንጌꬃፌ ኢሳ ኢንቴ ዶራና ማላ ኢንቴ ሲንꬃን ዎꬃዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","ታ ሃች ኢንቴስ ኢሚዛ ጎዳ ኢንቴ ጾሳ ኣዛዞታ ናጊኮ ኢንቴ ኣንጄታና። ");
INSERT INTO gmve_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","ጊዶ ኣቲን ታኒ ኢንቴና ሃች ኣዛዚዛ ጎዳ ኢንቴ ጾሳ ኣዛዞታ ናጎንታ ኢጺዲ ኢንቴ ኤሮንታ ሃራ ኤቃ ጾሳታ ጎይናናስ ኢዛ ኦጌፔ ካሬ ኬኢዛ ጊዲኮ ኢንቴ ቃንጌታና። ");
INSERT INTO gmve_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","ጎዳ ኢንቴ ጾሳይ ኢንቴ ላታና ቢዛ ቢታዮ ላቲሲዳ ዎዴ ኣንጆዛ ጋሪዛኔ ዙማ ቦላ ቃሴካ ቃንጌꬃ ኤባሌ ዙማ ቦላ ኣዋጃ። ");
INSERT INTO gmve_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","ሄ ዙማቲ ዮርዳኖሴ ሻፋፔ ኣርሼይ ዉሊዛ ባጋራ ኣራቤን ዲዛ ካናኔ ቢታን ጌልጌላ ካታማፔ ሲንꬃ ባጋራ ዲዛ ሞሬ ሚꬃ ኣቻን ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","ኢንቴ ሄን ዳና ማላ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዳ ቢታዮ ላታናስ ኢንቴ ዮርዳኖሴ ሻፋ ፒኒዲ ላቲዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","ታ ኢንቴስ ሃች ኢሚዛ ዎጋኔ ማራ ኡባ ሎኤꬂ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","ጎዳ ኢንቴ ኣዋታ ጾሳይ ኢንቴስ ኢሚዛ ቢታ ቦላ ዲዛ ዎዴ ኢንቴ ናጋና ዎጋቲኔ ማራቲ ሃይታንታ፤ ");
INSERT INTO gmve_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","ኢንቴ ላታና ቢታይን ዲዛ ካዎቴꬃይ ዙማታ ቦላ፥ ዙምቡላታ ቦላኔ ዳሻ ሚꬃታ ጋርሳን ባንታ ኤቃ ጾሳታስ ጎይኒዛሶታ ሙሌራ ꬋይሲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","ኢስቲ ያርሾ ያርሺዛሶሆታ ላሊ ꬋይሲቴ፤ ሹቻፌ ኦሴቲዲ ቱሳ ማላ ኤቂዳ ኤቃ ጾሳታ ኡባ ሊቂሲቴ፤ ኣሼሮ ጌቴታ ጼይጌቲዛ ኤቃ ጾሳይ ሚስሌታ ኡባ ታማን ጹጊቴ፤ ማሴቲ ጊጊዳ ኢስታ ኤቃ ጾሳታ ኡባ ሜንꬄሬꬂ ዬጊቴ፤ ኢስታ ሱንꬃካ ቢታፌ ꬋይሲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","ኢንቴ ጎዳ ኢንቴ ጾሳስ ኣይዛቤቲ ባንታ ኤቃ ጾሳታስ ጎይኒዛይሳꬆ ጎይኖፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","ጎዳ ኢንቴ ጾሳይ ዳናሲኔ ኢዛ ሱንꬃይ ሄን ጼይጌታና ማላ ኡባ ቆሞታ ጊዶን ኢዚ ዶሪዳሶዛ ኮዪዲ ሄ ቢቴ። ");
INSERT INTO gmve_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","ጹጌቲዛ ያርሾታ፥ ሃራ ያርሾታ፥ ኢንቴ ኣስራታ፥ ኢንቴ ሙጹዋታ፥ ኢንቴ ኣዲኔቲዳ ኣዲናታ፥ ኢንቴ ዶሲዲ ኢሚዛ ኢሞታታኔ ኢንቴ ሜሃፔ ባይራታ ሄ ኤሂቴ። ");
INSERT INTO gmve_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","ሄን ጎዳ ኢንቴ ጾሳ ሲንꬃን ኢንቴ ማና፤ ቃሴ ኢንቴ ኢንቴ ዎልቃን ኦꬂ ኬሲዳ ኡባኒኔ ጎዳ ኢንቴ ጾሳይ ኢንቴና ኣንጂዳ ኡባን ኢንቴ ኢንቴሶ ኣሳራ ኡፋዬታና። ");
INSERT INTO gmve_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","ኢንቴ ሃኖ ጋካናስ ኢንቴ ሼኔ ማላ ኦꬂሼ ጋምኢዴታ፤ ሄ ዎዴ ሄሳꬆ ኦꬄኬታ። ");
INSERT INTO gmve_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚን ኢንቴ ሼምፒዲ ዳና ቢታዮ ቡሮ ጌሊቤኬታ። ");
INSERT INTO gmve_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢማና ቢታይን ዳናስ ኢንቴ ዮርዳኖሴ ሻፋ ፒናና፤ ኢንቴ ዩሾን ዶዲ ኡቲዳ ሞርኬታፔ ኢንቴና ኢዚ ሼምፒሳና፤ ኢንቴካ ሄን ዎፑ ጊ ዳና። ");
INSERT INTO gmve_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","ሄ ዎዴ ጎዳ ኢንቴ ጾሳይ ባ ሱንꬃይ ጼይጌታና ማላ ዶሪዳሶ ታኒ ኢንቴና ኣዛዚዛ ኡባ፥ ጹጌቲዛ ያርሾታ፥ ሃራ ያርሾታ፥ ኢንቴ ኣስራታ፥ ኢንቴ ሙጹዋታ፥ ኢንቴ ኣዲኔቲዳ ኣዲና ኡባ ኤሃንዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","ኢንቴ ማጫ ናይታራኔ ኢንቴ ኣቱማ ናይታራ፥ ኢንቴስ ኦꬂዛ ማጫሳታራኔ ኣቱማሳታራ፥ ኢንቴናራ ጺንጾ ጊሼቲ ኤኮንታ ባንታ ባንታ ካታማን ካታማን ዲዛ ሌዌ ቆሞታራ ጎዳ ኢንቴ ጾሳ ሲንꬃን ኢንቴ ኡፋዬታና። ");
INSERT INTO gmve_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","ኢንቴ ጾሳስ ጹጊ ያርሺዛ ያርሾ ቤቶሶን ጮ ያርሾንታ ማላ ናጌቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","ኢንቴ ኢንቴ ዜሬꬃቲ ዲዛሶ ኡባፌ ኢሳን ጎዳይ ዶሪዳሶን ጻላ ጹጌቲዛ ያርሾ ያርሺቴ፤ ታኒ ኢንቴና ኣዛዚዛ ሚሽ ኡባካ ሄን ኦꬂቴ። ");
INSERT INTO gmve_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","ጊዲኮካ ጎዳ ኢንቴ ጾሳይ ኢንቴና ኣንጂዳ ኬና ኢንቴ ካታማታፔ ኣዋይሳንካ ኢንቴ ሜሄፔ፥ ዎይኮ ጋራፔ ዎይኮ ጌኔሳፌ ሹኪዲ ኢንቴ ኮዪዳ ኬና ማና ዳንዳዬታ፤ ሃ ኣሾዛፔ ዎጋይ ጊዛ ማላ ጌዪዳ ኣሲ ጊዲን ዎይኮ ጌዮንታ ኣሲ ኡባይ ማና ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","ጊዶ ኣቲን ኢስታ ሱꬅ ሞፒቴ፤ ሱꬃዛ ሃꬃ ማላ ዱጌ ጋዴን ጉሲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","ኢንቴ ኢንቴ ካꬃፌ፥ ዎይኔ ኡሻፌኔ ዎጋራ ዛይቴፔ ኢሚዛ ኣስራታ፥ ኢንቴ ሚዛታፔ፥ ዶርሳታፔ፥ ዴይሻታፔ ባይራ፥ ጎዳስ ኢንቴ ኢማናስ ኣዲኔቲዳ ኣዲና ኡባኔ ኢንቴ ኢንቴ ዶሳን ሚሽ ኡባካ ኢንቴ ዲዛሶ ኣዋንካ ሞፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","ጎዳ ኢንቴ ጾሳይ ዶሪዳሶን ኢንቴ ማጫ ናይታራኔ ኣቱማ ናይታራ፥ ኢንቴ ማጫ ኣይሌታራኔ ኣቱማ ኣይሌታራ፥ ሄሳꬆካ ኢንቴ ካታማታን ዲዛ ሌዌ ቆሞታራ ኢሲፌ ጎዳ ኢንቴ ጾሳ ሲንꬃን ሚቴ፤ ኢንቴ ዳቡርዲ ሺሺዳ ሚሽ ኡባን ጎዳ ኢንቴ ጾሳ ሲንꬃን ሄን ኡፋዬታና። ");
INSERT INTO gmve_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","ኢንቴ ኢንቴ ቢታን ዲዛ ዎዴ ኡባን ሌዌ ቆሞታ ዬጊ ኣጎንታ ማላ ናጌቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","ጎዳ ኢንቴ ጾሳይ ኢንቴስ ጫቂዳ ቃላ ማላ ኢንቴ ዛዋ ኣሲዛ ዎዴ ኢንቴና ኣሾ ኣሞሲኮ ኢንቴ ኮዪዳ ኬና ማና ዳንዳዬታ። ");
INSERT INTO gmve_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","ጎዳ ኢንቴ ጾሳይ ባ ሱንꬃይ ጼይጌታና ማላ ዶሪዳሶይ ኢንቴፌ ሃኮን ዲኮ ኢንቴና ኢዚ ኣዛዚዳ ማላ ሚዛታፔ፥ ዶርሳታፔ ሹኪዲ ኢንቴ ዲዛ ካታማታን ኢንቴ ኮዪዳ ኬና ኣሾዛ ማና ዳንዳዬታ። ");
INSERT INTO gmve_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","ዎጋይ ጊዛ ማላ ጌሻ ኣስ ጊዲን ዎይኮ ጌዮንታ ኣስ ጊዲን ኦኒካ ጋራ ኣሾ ዎይኮ ጌኔሳ ኣሾ ሚዛ ማላ ሄ ኣሾዛ ማናስ ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","ጊዶ ኣቲን ሼምፖይ ሱꬃን ዲዛ ጊሻስ ሱꬃራ ዲዛ ኣሾ ሞንታ ማላ ናጌቲቴ፤ ሄሳ ጊሻስ ሼምፖ ሱꬃራ ጋꬂ ሞፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","ሱꬃ ጋዴን ጉሲቴ ኣቲን ሞፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","ኢንቴሲኔ ኢንቴ ናይታስ ሎኦ ጊዳና ማላ ሱꬅ ሞፒቴ፤ ኢንቴ ሄሳꬆ ኦꬂኮ ጾሲ ኡፋዬታና። ");
INSERT INTO gmve_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","ሄሳ ጊሻስ ኢንቴ ጎዳ ኢንቴ ጾሳስ ኢማናስ ዱማሲዳይሳኔ ኣዲኔቲዳይሳ ኤኪዲ ዶሬቲዳሶ ኤፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","ጹጌቲዛ ያርሾዛ፥ ኣሻኔ ሱꬃ ኡባ ጎዳ ኢንቴ ጾሳስ ያርሾ ያርሺዛሶዛ ቦላ ሺሺቴ፤ ሱꬃዛ ጎዳ ኢንቴ ጾሳስ ያርሾ ያርሺዛሶሆታ ቦላ ጉሲቴ፤ ኣሾዛ ጊዲኮ ኢንቴ ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","ኢንቴሲኔ ኢንቴ ናይታስ ሜርናስ ሎኦ ጊዳና ማላ ኢዚ ኢንቴና ኣዛዚዛ ኣዛዞታ ሎኤꬂ ናጊቴ፤ ኢንቴ ሄሳꬆ ኦꬂኮ ጎዳ ኢንቴ ጾሳ ሲንꬃን ሎኦኔ ሱሬ ጊዲዳ ኦሶ ኦꬄታ። ");
INSERT INTO gmve_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","ኢንቴ ላታናስ ቢዛ ካዎቴꬃታ ጎዳ ኢንቴ ጾሳይ ኢንቴ ሲንꬃፌ ꬋይሲዛ ዎዴኔ ኢንቴካ ኢስታ ቢታ ላቲዲ ዴኢዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","ኢስቲ ኢንቴ ሲንꬃፌ ꬋይዳፔ ጉዬ፥ «ሃይቲ ሃ ካዎቴꬃቲ ባንታ ኤቃ ጾሳታስ ዎስቲ ጎይኒዞ? ኑኒካ ኢስታይሳꬆ ኦꬃና» ጊዲ ዎጺማዴን ኦይኬቶንታ ማላ ናጌቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","ኢንቴ ጎዳ ኢንቴ ጾሳስ ጎይኒዛ ጎይኖይ ኣይዛቤቲ ጎይኒዛ ጎይኖ ማላ ጊዳናስ ቤሴና፤ ኢስቲ ባ ኤቃ ጾሳታስ ጎይኒሼ ኦꬂዛ ኦሶቲ ኡባይ ኬሂ ሻቲዛዚኔ ጎዳ ማታን ኢጼቲዳዛ፤ ጋሶይካ ኢስቲ ባ ዬሊዳ ናይታካ ባንታ ኤቃ ጾሳታስ ያርሾ ኦꬂዲ ታማን ጹጌቴስ። ");
INSERT INTO gmve_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","ሄሳ ጊሻስ ታ ኢንቴና ኣዛዚዳ ኣዛዞ ኡባ ኦꬂቴ፤ ኢስታ ቦላ ኣይኮካ ጉጆፍቴ፤ ቃሴካ ኢስታፌ ኢሲኖካ ፓጪሶፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","ኢንቴ ጊዶፌ ካዪዛ ኣሲ ዎይኮ ኣጉሞ ኣጉሜቲዛ ኣሲ፥ «ታኒ ጊታ ማላታ ዎይኮ ማላሊሲዛ ሚሽ ኦꬃና» ጊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","ኢዚ ዮቲዳ ጊታ ማላታይኔ ማላሊሲዛ ሚሽ ኡባይ ቱሙካ ፖሌቲን ኢዚ ኢንቴና፥ «ኣኔ ኢንቴ ኤሮንታ ሃራ ጾሳታስ ጎይኖስ» ጊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","ጎዳ ኢንቴ ጾሳይ ኢንቴ ኢዛ ኩሜꬃ ዎዚናፔኔ ኩሜꬃ ሼምፖፌ ዶሲዛኮ ኤራናስ ኮዪዲ ሄ ካዪዛይሳ ዬዲዳ ጊሻስ ኢዚ ጊዛይሳ ሙሌካ ሲዮፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","ጎዳ ኢንቴ ጾሳ ካሊቴ፤ ኢዛስ ጻላ ያዪቴ፤ ኢዛ ኣዛዞታ ናጊቴ፤ ኢዛ ቃላ ሲዪቴ፤ ኢዛስ ጻላ ጎይኒቴ፤ ኢንቴስ ኢዛራ ዲዛ ኢሲፌቴꬂ ሚኖ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","ካሴ ኢንቴ ኣይሌቴꬃን ዲዛ ጊብጼፔ ኢንቴና ዎዚ ኬሲዲ ኣሺዳ ጎዳ ኢንቴ ጾሳ ቦላ ኢንቴ ማካላና ማላ ኣጉሞ ዮቲዛዴ ዎይኮ ታ ናቤ ጊዛ ኡባ ዎꬊቴ፤ ሄሳ ማላ ኣሳቲ ጎዳ ኢንቴ ጾሳይ ኢንቴና ሚኒ ኤቃና ማላ ኣዛዚዳ ኦጌፔ ካሬ ኬሳናስ ቆፔቴስ፤ ሄሳ ጊሻስ ሃይታ ኢታታ ኢንቴ ጊዶፌ ዲጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","ኢንቴ ኣዪ ና ኢሻይ፥ ኢንቴ ኣቱማ ናይቲኔ ኢንቴ ማጫ ናይቲ፥ ኢንቴ ሲቂዛ ኢንቴ ማቼቲ፥ ኢንቴ ሲቂዛ ኢንቴ ላጌቲ ኢንቴና፥ «ካሴ ኢንቴኒኔ ኢንቴ ኣዋቲ ጎይኒ ኤሮንታ ጾሳስ ኣኔ ጎይኖስ» ጊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","ቢታስ ሃ ጋጻፔ ሄ ጋጻ ጋካናስ ዲዛ ኢንቴ ዩሾ ኡባን ማታኒኔ ሃኮን ዲዛ ኡባ ኣሳይ ጎይኒዛ ጾሳታስ፥ «ቢዲ ኣኔ ኢስታስ ጎይኖስ» ጊዲ ባሌꬂኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","ኢንቴ ሄሳ ማላ ኣሳታስ ኤኖ ጎፒቴ፤ ኢስቲ ጊዛይሳካ ሲዮፒቴ፤ ሄሳ ማላ ኣሳታስ ቃꬌቲዲ ኢስታ ኣሻናስ ዳፌቶፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","ሲꬎንታ ኢስታ ዎꬊቴ፤ ሄሳ ማላ ኣስ ኮይሮቲዲ ኢንቴ ጫዲቴ፤ ሃራቲ ኢንቴፌ ካሊዲ ሹቻራ ጫዴቶ። ");
INSERT INTO gmve_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","ኢንቴ ካሴ ጊብጼ ቢታን ኣይሌቴꬃን ዲዛሶፔ ኢንቴና ዎዚ ኬሲዳ ጎዳ ኢንቴ ጾሳፌ ኢንቴና ሃሳናስ ኮዪዳ ጊሻስ ሄሳዴይ ሃይቃና ጋካናስ ሹቻን ኩራኪቴ። ");
INSERT INTO gmve_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","ሄሳፌ ጉዬ ኢስራኤሌ ኣሳይ ኡባይ ሄሳ ሲዪዲ ባባና፤ ሄሳ ጊሻስ ሄሳ ማላ ኢታ ኦሶ ናምኣንꬆ ኦኒካ ኦꬄና። ");
INSERT INTO gmve_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","ጎዳ ኢንቴ ጾሳይ ኢንቴ ዳና ማላ ኢንቴስ ኢሚዛ ካታማታፔ ኢሳን ኢንቴ ዲዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","ኢንቴ ኣሳ ጊዶፌ ኢታቲ ዴንዲዲ ኣሳ፥ «ኣኔ ቢዲ ኢንቴ ኤሮንታ ጾሳታስ ጎይኖስ» ጊዲ ባሌꬂሺን ሲዪኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","ኢንቴ ሄሳ ሄ ዮኦዛ ኦይቺቴ፤ ሚንꬂካ ቆሪቴ፤ ሃይሲ ኢታ ሃኖይ ኢንቴ ጊዶን ኦሴቲዳይሲ ቱሙ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","ሄ ካታማይን ዲዛ ኣሳ ኡባ ማሻን ሲፊ ꬋይሲቴ፤ ሄ ካታማዮኔ ኢዚን ዲዛ ሜሃ ኩሜꬅ ኣሾንታ ꬋይሲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","ሄ ካታማይን ዲዛ ኣሳ ኣቆታ ኡባ ኤኪዲ ሄ ካታማይ ጊዶን ዲዛ ዱቡሻን ሺሺ ዶሪቴ፤ ሂስቲዲ ጎዳ ኢንቴ ጾሳስ ያርሾ ኦꬂዲ ታማን ጹጊቴ፤ ሄ ካታማያ ናምኣንꬆ ሲማ ኤቆንታ ማላ ሜርናስ ላሌታ ኣቱ። ");
INSERT INTO gmve_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","ፒላ ሚሻፌ ኣይኮይካ ኢንቴ ኩሼን ቤቶፎ፤ ሂስቲኮ ጎዳይ ባ ዎልቃማ ሃንቆፌ ሲሚዲ ኢንቴና ማራና፤ ኢዚ ኢንቴስ ቃꬌታና፤ ካሴ ኢንቴ ኣዋታስ ጌሊዳ ቃላ ማላ ኢንቴ ቆዳ ዳርሳና። ");
INSERT INTO gmve_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","ጋሶይካ ታኒ ሃች ኢንቴና ኣዛዚዛ ኣዛዞ ኡባ ኢንቴ ናጊዲ ጎዳ ኢንቴ ጾሳስ ኣዛዜቲኮ፥ ቃሴ ጎዳ ኢንቴ ጾሳ ሲንꬃንካ ሱሬ ኦሶ ኦꬂኮ ሄ ኢዚ ጌሊዳ ሂዶታ ቃላይ ኢንቴስ ቱሙ ፖሌታና። ");
INSERT INTO gmve_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","ኢንቴ ጎዳ ኢንቴ ጾሳ ናይታ፤ ሄሳ ጊሻስ ሃይቂዳ ኣሳስ ሚሼቲዲ ኢንቴ ቦላ ቃጪ ማዱንꬆፍቴ፤ ኢንቴ ሁኤ ቢናናካ ቡጮፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","ጋሶይካ ኢንቴ፥ ጎዳ ኢንቴ ጾሳስ ዱማ ዴሬ፤ ጎዳይ ቢታ ቦላ ዲዛ ዴሬ ኡባፌ ኢንቴ ኢዛስ ዱማ ዴሬ ጊዳና ማላ ኢዚ ኢንቴና ባስ ዶሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","ቱና ጊዲዳዝ ኣይ ሚሼካ ሞፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","ሄሳ ጊሻስ ማና ማላ ኢንቴስ ኢሜቲዳ ሜዶሳቲ ሄኮ ሃይሳፌ ካሊ ዲዛይታ፤ ካጬራ ዲዛይታፔ ሚዝ፥ ዶርሲኔ ዴይሽ፥ ");
INSERT INTO gmve_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","ጌኔሳ፥ ዶጌ፥ ዉሻ፥ ዎራ ዴይሽ፥ ጮፎሾ፥ ጋራ፥ ጫጎኔ ቢሆሬ ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","ቂንጪፊሌይ ጳልቄቲዳይታኔ ባንቺኪዛይታ ኡባ ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","ጊዶ ኣቲን ቂንጫፊሌይ ጳልቄቶንታይታኔ ባንቺኮንታይታ ሞፒቴ፤ ሄይቲካ ጋሜላ፥ ሃርባይኖኔ ጉፓሌ ሞፒቴ፤ ሄይታንታ ማላ ሜዶሳቲ ባንቺኪዛ ጊዲኮካ ኢስታ ቂንጪፊሌይ ሙሜ ጊዲዳ ጊሻስ ቱና ጊዲ ቆዴቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","ጉዱንꬃ ቂንጪፊሌይ ጳልቄꬅ ጊዲኮካ ባንቺኮንታ ጊሻስ ኢዚ ሃንኮ ቱናታራ ኢሲፌ ቆዴቴስ፤ ሃይታንታ ማላ ሜዶሳታ ሞፒቴኔ ኢስታስ ኣሃካ ቦቾፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","ሃꬃ ጊዶን ዲዛ ሜꬌቴꬃ ኡባፌ ቄፌራ ዲዛይታኔ ፖቆይ ዲዛይታ ኡባ ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","ጊዶ ኣቲን ሃꬃ ጊዶን ሜꬌቴꬃ ኡባፌ ቄፌይኔ ፖቆይ ባይንዳይታ ሞፒቴ፤ ሄይቲ ኢንቴስ ቱና ጊዴቶ። ");
INSERT INTO gmve_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","ካፎታፔ ጌሻታ ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","ሜቴታናስ ቤሶንታይቲ ጎሌ፥ ቆሎ፥ ኣንኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","ዱማ ዱማ ጺሎታኔ ዎሌታ፥ ");
INSERT INTO gmve_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","ዱማ ዱማ ቁሮታ፥ ");
INSERT INTO gmve_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","ያንቻ፥ ጫንጬ ጉቶ፥ ሃꬃ ካፎ፥ ጋጬ ዛሬ ኡባ፥ ");
INSERT INTO gmve_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","ጉቶ፥ ሃዞ፥ ዎዪኖ ");
INSERT INTO gmve_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","ባዞ ጉቶ፥ ኣንኮ፥ ቢያ፥ ");
INSERT INTO gmve_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","ዚጊሌ፥ ሳቢሳ ጌቴቲዛ ካፎ ዛሬ ኡባ፥ ጂንጂላቴ ጌቴቲዛ ካፎኔ ዉርካዉርኮ። ");
INSERT INTO gmve_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","ቄፌራ ዲዛ ቄሪ ሜꬌቴꬃቲ ኡባይ ኢንቴስ ቱና ጊዲዳ ጊሻስ ኢስታ ሞፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","ጊዶ ኣቲን ኢስታ ጊዶፌ ጌሻታ ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","ጎዳ ኢንቴ ጾሳስ ኢንቴ ዱማቲዳ ዴሬ ጊዲዳ ጊሻስ ባዉቲ ሃይቂዳ ሜሄ ኣሾ ሞፒቴ፤ ሃራ ዴሬፔ ዪዲ ኢንቴ ጊዶን ዲዛይቲ ማና ጊኮ ዲጎፍቴ፤ ዎይኮ ሃራ ዴሬ ኣሳስ ባይዛና ዳንዳዬታ። ዴይሻ ላቃ ኢዛ ኣዬይ ማꬃን ዶይሶፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","ኢንቴ ላይꬃን ላይꬃን ጎዪዲ ዴሚዛ ካꬃፌ ታማፌ ኢሲ ኩሼ ዱማ ሻኪ ዎꬂቴ። ");
INSERT INTO gmve_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","ኢንቴ ኡባ ዎዴ ጎዳ ኢንቴ ጾሳ ቦንቾ ታማራና ማላ ኢዚ ባ ሱንꬂ ጼይጌታና ማላ ዶሪዳሶን ኢንቴ ካꬃ፥ ዎይኔ ኡሻኔ ዛይቴ ኣስራታ፥ ኢንቴ ዶርሳታፔኔ ሜሄታፔ ኮይሮ ዬሌቲዳይታ ጎዳ ኢንቴ ጾሳ ሲንꬃን ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","ጎዳ ኢንቴ ጾሳይ ባ ሱንꬂ ጼይጌታና ማላ ዶሪዳሶዚ ኢንቴ ዲዛሶፔ ኬሂ ሃሆ ጊዲኮ ጎዳ ጾሳይ ኢንቴና ኣንጃና ማላ ኢንቴ ኢንቴ ኣስራታ ሄ ቶኪ ኤኪዲ ባናስ ዳንዳዮንታ ኢጺኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","ሄ ኢንቴ ኬሲዳ ኣስራታ ባይዚዲ ሚሼዛ ጎዳይ ዶሪዳሶዛ ኤኪዲ ቢቴ። ");
INSERT INTO gmve_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","ሂስቲዲ ሄን ሄ ኣስራታ ሚሻራ ኢንቴ ኮዪዳ ሚሽ፥ ሚዝ ጊዲን ዎይኮ ዶርስ፥ ዎይኔ ኡሹ ጊዲን ዎይኮ ሎኦ ሚኖ ኡሹ ኢንቴ ኮዪዳ ማላ ሻሚዲ ኢንቴሶ ኣሳ ኡባራ ሚሼ ጎዳ ኢንቴ ጾሳ ሲንꬃን ኡፋዬቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","ሄሳ ኢንቴ ኦꬂዛ ዎዴ ኢንቴ ካታማን ዲዛ ሌዌ ቆሞታ ጊሻን ጋኪዳ ጺንጾይ ባይንዳ ጊሻስ ኢንቴ ኢስታ ዬጊ ኣጎፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","ሄꬓንꬆ ላይꬃን ላይꬃን ኡባ ዎዴ ኢንቴ ካꬃፌ ኬሲዛ ዱማ ኣስራታ ኢንቴ ዲዛ ካታማታን ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","ሄሳካ ኢንቴ ካታማታን ዲዛ ጺንጾይ ባይንዳ ሌዌቲ፥ ቤቴቲ፥ ኣዋይ ባይንዳ ናይቲኔ ኣምኤቲ ዪዲ ሜቶ፤ ኢንቴ ሄሳꬆ ኦꬂዛ ጊዲኮ ጎዳ ኢንቴ ጾሳይ ኢንቴ ኦሶ ኡባን ኢንቴና ኣንጃና። ");
INSERT INTO gmve_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","ላፑንꬃ ላፑንꬃ ላይꬃ ዉርሴꬃን ኢንቴፌ ታልኢዳይታስ ኣጮዛ ኢስታስ ኣጋጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","ኣጊሼ ሂስቲ ኣጊቴ፤ ባ ባጋ ኢስራኤሌ ኣሳስ ሚሼ ታልኢዳዴይ ዉሪ ባ ታልኢዳይሳ ኢዛዴስ ማሮ፤ ጎዳይ ኣጮይ ማሬቲዛ ላይꬃ ጊዲ ኣዋጂዳ ጊሻስ ባ ታልኢዳ ሚሻ ዛሪ ኤካናስ ኮዮፖ። ");
INSERT INTO gmve_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","ሃራ ካሬ ዴሬ ኣሳስ ኢንቴ ታልኢዳ ሚሼይ ዲኮ ኢንቴስ ዛራና ማላ ኦይቻና ዳንዳዬታ፤ ኢንቴስ ኢሻ ኢስራኤሌ ኣሳታፔ ኢንቴፌ ሚሼ ታልኢዳይ ዲኮ ኢስታስ ኣጋጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","5","ሃች ታ ኢንቴና ኣዛዚዛ ኣዛዞታ ኡባን ጎዳ ኢንቴ ጾሳስ ኢንቴ ኣዛዜቲዛይታ ጊዲኮ ጎዳ ኢንቴ ጾሲ ኢንቴና ኬሂ ኣንጃና ጊሻስ ኢዚ ኢንቴስ ጺንጾ ሂስቲ ኢሚዛ ቢታይን ኢንቴ ጋርሳን ማንቆይ ዴና። ");
INSERT INTO gmve_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","ጎዳ ኢንቴ ጾሳይ ኢንቴስ ሂዶታ ቃላ ማላ ኢንቴና ኣንጃና፤ ኢንቴ ዳሮ ዴሬታስ ታልኣናሺን ኢስታፌ ኦናፔካ ታልኤ ሃ ኤኬታ፤ ቃሴካ ኢንቴ ካዎቴꬃታ ሃራና ኣቲን ኦኒካ ኢንቴና ሃሬና። ");
INSERT INTO gmve_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዛ ቢታን ኢንቴ ዲዛ ካታማታ ኡባን ኢስራኤሌ ኣሳፔ ኢሳዴይ ሜቶቲሺን ቤኢኮ ኢዚ ኢንቴ ባጋ ጊዲዳ ጊሻስ ኢዛስ ሜቄꬅ ኢቶፒቴ፤ ቃሴ ኢዛ ማዳናፔ ኢንቴ ኩሼ ጉዬ ኤኮፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","ኢንቴ ኩሼ ሚጪዲ ኢዛስ ኮሺዛዝ ኡባ ሞꬌቶንታ ታልኢቴ። ");
INSERT INTO gmve_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","«ኣጮ ቃንጾፌ ማሪዛ ላፑንꬃ ላይꬃይ ጋኪዴስ» ጊዲ ሜቶታንቻ ኢንቴ ኢሻታ ታልኤ ዲጎፍቴ፤ ሄሳ ማላ ኢታ ቆፋይ ኢንቴ ዎዚናን ጌሎፖ፤ ማንቆ ጊዲዳ ኢንቴ ኢሻታስ ኢንቴ ታልኦንታ ኢጺኮ ኢስቲ ፑዴ ጾሳኮ ዋሲን ኢንቴስ ጎሜ ጊዶንታ ማላ ናጌቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","ኢንቴ ኢዛስ ጮ ኪያቴꬅ ኢሚቴ፤ ኢንቴ ኢዛስ ኢሚሼ ኢንቴ ዎዚናን ሞꬌቶንታ ኢሚቴ፤ ሂስቲኮ ኢንቴ ኦሶ ኡባኒኔ ኢንቴ ኩሼይ ቦቺዳ ሚሽ ኡባን ጎዳ ኢንቴ ጾሳይ ኢንቴና ኣንጃና። ");
INSERT INTO gmve_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","ኣይ ዎዴ ጊዲንካ ቢታ ቦላ ሜቶታንቻይኔ ማንቆይ ዲዛ ጊሻስ ኢንቴ ዴሬን ዲዛ ማንቆታሲኔ ሜቶታንቻታስ ኢንቴ ኪያቴꬅ ኦꬃና ማላ ታ ኣዛዛይስ። ");
INSERT INTO gmve_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","ኣዴ ጊዲን ማጫ ጊዲን ኔ ባጋ ጊዲዳ ኢስራኤሌ ኣሳፔ ኢሲ ኣሲ ኣይሌታናስ ባና ኔስ ባይዚኮ ኢዚ ኔስ ኡሱፑን ላይꬅ ኦꬂዳፔ ጉዬ ላፑንꬃ ላይꬃን ኢዛ ኣይሌቴꬃፌ ኬሳ ዬዳ። ");
INSERT INTO gmve_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","ኔኒ ኣይሌቴꬃፌ ኢዛ ኬሳ ዬዲዛ ዎዴ ሜላ ኩሼ ዬዶፋ። ");
INSERT INTO gmve_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","ጎዳ ኔ ጾሳይ ኔስ ኢሚዳ ኣንጆፌ፥ ዶርሳታፔ፥ ካꬃፌኔ ዎይኔ ኣይፌፔ ኢዛስ ኪያቴꬃን ኢማዳ ዬዳ። ");
INSERT INTO gmve_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","ኢንቴካ ካሴ ጊብጼ ቢታን ኣይሌ ጊዲዳይሳኔ ጎዳ ኢንቴ ጾሳይ ኢንቴና ሄፔ ዎዚዳይሳ ዶጎፕቴ፤ ታኒ ኢንቴና ሃች ኣዛዚዛይ ሄሳሳ። ");
INSERT INTO gmve_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","ጊዶ ኣቲን ሄ ኣይሌዚ ኔናኔ ኔሶ ኣሳ ዶሲዳ ጊሻሲኔ ኔናራ ዱሲ ኢዛስ ሎኦ ጊዲዳ ጊሻስ፥ «ታ ኔፔ ሻኬታና ኮይኬ» ጊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","ኔኒ ኢዛ ኔሶ ፔንጌ ኤፋዳ ኢዛ ሃይꬃ ኔ ፔንጌ ሳንቃ ቦላ ዎꬃዳ ዎስፌራ ሉካ፤ ሄሳፌ ጉዬ ኢዚ ባ ዴኦ ላይꬅ ኡባን ኔስ ኣይሌ ጊዶ፤ ቃሴካ ኣይሌ ጊዲዛ ማጫሳስካ ሄሳꬆ ኦꬃ። ");
INSERT INTO gmve_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","ኔ ኢዛ ኣይሌቴꬃፌ ኬሳ ዬዲዛ ዎዴ፥ «ሃይሲ ታስ ቆሆ» ጋዳ ቆፖፋ፤ ጋሶይካ ኢዚ ሃ ኡሱፑን ላይꬃን ሚሻስ ኦꬂዛ ኣሲ ኦꬂዛ ኦሶፔ ዳኮ ዳርሲዲ ኔስ ኦꬂዴስ፤ ሄሳ ጊሻስ ኔ ሄሳꬆ ኦꬂኮ ጎዳ ኔ ጾሳይ ኔ ኦꬂዛ ኦሶ ኡባን ኔና ኣንጃና። ");
INSERT INTO gmve_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","ኔኒ ኔ ሜሃፔኔ ኔ ዶርሳ ዉዳፔ ባይራ ዬሌቲዳ ኣዴ ኡባ ጎዳ ኔ ጾሳስ ዱማሳ፤ ኢስታ ኣይኮስካ ጎኤቶፋ፤ ሄሳꬆካ ዶርሳ ዉዳፔ ባይራ ዬሌቲዳይታ ኢስኬካ ቃንጾፋ። ");
INSERT INTO gmve_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","ኔኒኔ ኔሶ ኣሳይ ጎዳ ኔ ጾሳይ ዶሪዳሶሆን ጎዳ ኢንቴ ጾሳ ሲንꬃን ላይꬃን ላይꬃን ሄይታ ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","ጊዶ ኣቲን ኔ ያርሺዛ ሜሄታ ቦላ ዎሶይ ቤቲኮ፥ ሄሲካ ቶሆ ሲላ ዎይኮ ቆቄ፥ ቃሴካ ሃራ ኢታ ቦሪዛዚ ኢስታ ቦላ ዲኮ ሄሳንታ ጎዳ ኔ ጾሳስ ያርሾ ሺሾፋ። ");
INSERT INTO gmve_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","ሄይታንታ ማላ ሜሄታ ሄን ኢንቴሶን ማናስ ዳንዳዬታ፤ ዎጋይ ጊዛ ማላ ጌሻ ኣስ ጊዲን ዎይኮ ቱና ኣስ ጊዲን ጌኔሳ ኣሾኔ ጋራ ኣሾ ሚዛ ማላ ማና ዳንዳዬታ። ");
INSERT INTO gmve_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","ጊዶ ኣቲን ኢስታ ሱꬃ ሃꬃ ማላ ዎራ ጉሲቴ ኣቲን ሞፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","ጎዳ ኢንቴ ጾሳይ ኢንቴና ኣቢቤ ኣጊናን ኦማርሳራ ጊብጼፔ ኬሲዴስ፤ ሄሳ ጊሻስ ኣቢቤ ኣጊናን ጎዳ ኢንቴ ጾሳ ፓዚጋ ባኣሌ ቦንቺቴ። ");
INSERT INTO gmve_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","ጎዳ ኢንቴ ጾሳይ ባ ሱንꬂ ጼይጌታና ማላ ዶሪዳሶን ኢንቴ ኢዛ ቦንቻና ማላ ኢንቴ ሜሄፔ፥ ዎይኮ ዶርሳፌ ኢሳ ፓዚጋ ባኣሌን ያርሾ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","ሄ ያርሾ ካꬃ ኢንቴ ሚዛ ዎዴ ኢርሾይ ኢዛን ጌሊዳ ካꬅ ሞፒቴ፤ ሄሳꬆካ ካሴ ኢንቴ ኤሶን ጊብጼፔ ኬዚዛ ዎዴ ኦꬆይሳ ማላ ላፑን ጋላስ ጋካናስ ኢርሾይ ኢዛን ጌሎንታ ዋዬ ኡኬꬅ ሚቴ፤ ሄሲካ ኢንቴ ዳሮ ሜቶ ቤኢዲ ጊብጼ ቢታፌ ኬዚዳ ጋላሳ ኢንቴና ቆፍሳና። ");
INSERT INTO gmve_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","ላፑን ጋላስ ጋካናስ ኢንቴ ዴሬን ኣይ ኣሳ ኬꬃንካ ኢርሾይ ዶፖ፤ ኢንቴ ኮይሮ ጋላሳ ኦማርስ ያርሾስ ሹኪዳ ኣሾ ኡባይ ሄ ጋላስ ሜቴቲ ዉራና ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","ኢንቴ ፓዚጋ ያርሾ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዛ ኣይ ካታማታንካ ጮ ሹኮፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","ጊዶ ኣቲን ጎዳ ኢንቴ ጾሳይ ባ ሱንꬃይ ጼይጌታና ማላ ዶሪዳሶን ጻላ ሹኪቴ፤ ሹኪሼ ኣርሼይ ዉሊዛ ዎዴ ኢንቴ ካሴ ጊብጼፔ ኬዚዳ ጋላሳዮኔ ሳቴዮ ናጊዲ ሹኪቴ። ");
INSERT INTO gmve_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","ሄ ሹኪዳ ኣሾዛ ጎዳ ኢንቴ ጾሳይ ዶሪዳሶን ጺጺ ሚቴ፤ ዎንቴꬃ ጋላስ ጌዴ ኢንቴ ዱንካኔን ዱንካኔን ሲሚቴ። ");
INSERT INTO gmve_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","ኡሱፑን ጋላስ ኢርሾይ ኢዛን ጌሎንታ ኡኬꬅ ሚቴ፤ ላፑንꬆ ጋላስ ጎዳ ኢንቴ ጾሳስ ጎይናናስ ኢሲሶ ሺቂቴ፤ ሄ ጋላስ ኣይ ኦሶካ ኦꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","ኢንቴ ካꬅ ሺሻናስ ኮይሮ ዶሚዳ ጋላሳፌ ቢዲ ላፑን ሳሚንታ ኩሜꬅ ቆዲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","ሄሳፌ ጉዬ ጎዳ ኢንቴ ጾሳይ ኢንቴና ኣንጂዳ ኬና ኢንቴ ኢንቴ ዶሳን ኢሞታ ኤሂዲ ጎዳ ኢንቴ ጾሳስ ካꬃ ሺሾ ባኣሌ ቦንቺቴ። ");
INSERT INTO gmve_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","ሄሳን ኢንቴ ኢንቴ ኣቱማ ናይታራኔ ኢንቴ ማጫ ናይታራ፥ ኢንቴ ኣቱማ ኣይሌታራኔ ማጫ ኣይሌታራ፥ ኢንቴ ካታማን ዲዛ ሌዌታራኔ ቤቴ ኣሳታራ፥ ኢንቴ ጊዶን ዲዛ ዪኦታራኔ ኣምኤታራ ኡባይ ጎዳ ኢንቴ ጾሲ ባ ሱንꬂ ጼይጌታና ማላ ዶሪዳሶን ኡፋዬቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","ካሴ ኢንቴ ጊብጼን ኣይሌ ጊዲዳይሳ ዩሺ ቆፒዲ ሃይታ ዎጋታ ሎኤꬂ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","ኢንቴ ካꬅ ባሌፔ ጌልꬂዳፔ ጉዬ ቃሴካ ዎይኔ ጉምኢዛሶሆፔ ኤኪዳፔ ጉዬ ላፑን ጋላስ ጋካናስ ዳሴ ባኣሌ ቦንቺቴ። ");
INSERT INTO gmve_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","ሄሳን ኢንቴ፥ ኢንቴ ኣቱማ ናይታራኔ ኢንቴ ማጫ ናይታራ፥ ኢንቴ ኣቱማ ኣይሌታኔ ማጫ ኣይሌታራ፥ ኢንቴ ካታማን ዲዛ ሌዌታራኔ ቤቴ ኣሳታራ፥ ኢንቴ ጊዶን ዲዛ ዪኦታራኔ ኣምኤታራ ኡባይ ኡፋዬቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","ጎዳ ኢንቴ ጾሳይ ዶሪዳሶን ላፑን ጋላስ ጋካናስ ኢዛስ ባኣሌ ቦንቺቴ፤ ጎዳ ኢንቴ ጾሳይ ኢንቴ ካꬃኔ ኢንቴ ኦꬂዛ ኦሶ ኡባን ኢንቴና ኣንጃና፤ ኢዛን ኢንቴ ኡፋዬታና። ");
INSERT INTO gmve_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","ኢንቴ ቢታን ዲዛ ኣቱማ ኣስ ጊዲዳ ኡባይ ላይꬃን ሄꬑቶ ፓዚጋ ባኣሌ ዎዴ፥ ካꬃ ሺሾ ባኣሌ ዎዴኔ ዳሴ ባኣሌ ዎዴ ጎዳ ኢንቴ ጾሳይ ኢዚ ዶሪዳሶ ኢዛ ሲንꬅ ሺቆ፤ ባኣሌዛ ቦንቻና ዪሼ ኦኒካ ጮ ሜላ ኩሼ ጎዳ ሲንꬅ ዮፖ። ");
INSERT INTO gmve_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","ኢሲ ኢሲ ኣሲ ኤኪ ያና ኢሞታይ ጎዳ ኢንቴ ጾሳይ ኢዛዴ ኣንጂዳ ኬና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","ኢንቴ ዛሬቲ ኡባይ ጎዳ ኢንቴ ጾሳይ ኢሚዛ ካታማታን ኡባን ኢንቴ ዳናታኔ ሃላቃታ ሱንꬂቴ፤ ኢስቲካ ኣሳስ ጺሎ ፒርዳ ፒርዴቶ። ");
INSERT INTO gmve_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","ፒርዳ ጌላሶፓ፤ ኣሳ ኣይፌሶ ቤያዳ ማዳ ፒርዶፋ፤ ባሌꬆፋ፤ ማጋንጾ ሞፓ፤ ጋሶይካ ማጋንጾይ ኣꬎ ኤራንቻታ ኣይፌ ቆቂሴስ፤ ጺሎታ ቃላካ ቦኪሴስ። ");
INSERT INTO gmve_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","ኢንቴ ሼምፖራ ፓጻ ዳና ማላኔ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዛ ቢታ ኢንቴ ላታና ማላ ጺሎኔ ሱሬ ፒርዳ ፒርዲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","ጎዳ ኢንቴ ጾሳስ ኢንቴ ያርሺዛሶ ኣቻን ሚꬃፌ ኦሴቲዳ ኣሼሪ ሚስሌ ኤሶፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","ቃሴካ ጎዳ ኢንቴ ጾሳይ ኢጺዛ ጎይኖ ሹች ኤሶፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","ኢንቴ ኢንቴ ሜሄ ጋርሳፌ ዎሶይ ዎይኮ ፓጬይ ዲዛዝ ቦራ ጊዲን ዎይኮ ዶርሳ ጎዳ ኢንቴ ጾሳስ ያርሾ ሺሾፍቴ፤ ሄሲ ጎዳ ኣቻን ኢጼቲዳ ሚሻ። ");
INSERT INTO gmve_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","ኢንቴ ጎዳይ ኢንቴስ ኢሚዛ ካታማታፔ ኢሲኔይን ዲዛ ማጫ ጊዲን ኣዴ ጊዲን ጫቆ ቃላ ሜንꬂዲ ጎዳ ኢንቴ ጾሳ ሲንꬃን ኢታ ሚሽ ኦꬂ ቤቲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","ቃሴካ ታ ኣዛዞ ዬꬊ ኣꬊዲ ሃራ ጾሳታስ ጎይኒኮ ዎይኮ ኣርሼስ፥ ኣጊናሲኔ ጾሊንቴታስ ጎይኒኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","ሄይታንታ ማላ ሃኖታ ኢንቴ ሲዪኮ ሄ ዮኦዛ ፒልጊ ቆሪቴ፤ ሄሳ ማላ ኢታ ዮኦቲ ኢስራኤሌ ኣሳ ጊዶን ኦሴቲዳይሲ ቱሙ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","ሄ ኢታ ኦꬂዳዴ ዎይኮ ኦꬂዳሮ ካታማ ጊዶፌ ጌዴ ሃራሶ ኤፊዲ ሹቻን ኩራኪ ዎꬊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","ሄሲካ ናምኡ ማርካይ ዎይኮ ሄꬑ ማርካይ ኢዛዴ ቦላ ማርካቲዳፔ ጉዬ ጊዶ፤ ጊዶ ኣቲን ኢሲ ኣሲ ጻላ ማርካቲዳ ማርካን ኣይ ኣሲካ ሃይቆፎ። ");
INSERT INTO gmve_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","ማርካቲ ኮይሮቲዲ ሹቻን ጫዴቶ፤ ሄሳፌ ጉዬ ሃንኮ ዴሬ ኡባይ ጫዶ፤ ሄሳꬆ ኦꬂዲ ኢንቴ ጊዶፌ ኢታ ኡባ ዲጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","ኢንቴ ኢንቴ ካታማታን ፒርዳናስ ኬሂ ዴጺዛ ሼምፖ ጊሻስ ሺቂዛ ሞቶ፥ ሾቻ ሞቶ፥ ቃሴ፥ «ታስ ቤሴስ» ጊዛ ኣቆታ ሞቶ ጊዲንካ ዴንዲኮ ሄ ዎዴ ጎዳ ኢንቴ ጾሳይ ዶሪዳሶ ኤሶን ኤሂቴ። ");
INSERT INTO gmve_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","ሌዌ ቆሞታፔ ቄሴ ጊዲዳይታሲኔ ሄ ዎዴ ዳና ጊዲዲ ፒርዲዛይሳስ ዮኦዛ ሺሺቴ፤ ሄ ዮኦዛ ኢስቲ ፒርዴቶ። ");
INSERT INTO gmve_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","ጎዳይ ዶሪዳሶን ጊዲዲ ኢስቲ ኢንቴስ ፒርዲዛ ፒርዳ ማላ ኦꬂቴ፤ ኢንቴ ፖላና ማላ ኢስቲ ኢሚዛ ኣዛዞታ ናጌቲ ፖሊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","ኢስቲ ኢንቴና ታማርሲዳ ዎጋኔ ፒርዳ ማላ ኦꬂቴ፤ ኢስቲ ፒርዲዳ ፒርዳፌ ሃዲርሲኔ ኡሻች ጎፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","ጎዳ ኢንቴ ጾሳስ ኦꬂዛ ዳናስ ዎይኮ ቄሴስ ኣዛዜቶንታ ኢጺዲ ኦቶሬቲዛ ኣሲ ዲኮ ሄሳዴይ ሃይቆ፤ ሄሳꬆ ኦꬂዲ ሄይታንታ ሚሳቲዛ ኢታ ሚሻታ ኡባ ኢስራኤሌ ዴራ ጊዶፌ ዲጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","ሄሳፌ ጉዬ ኣሲ ዉሪ ሄሳ ሲዪዲ ባባና፤ ናምኣንꬆ ሄሳ ማላ ኢታ ኦሶ ኦꬃናስ ጻላና ኣሲ ዴና። ");
INSERT INTO gmve_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዛ ቢታዮ ጌሊ ላቲዲ ሄን ዱስ ዶሚዛ ዎዴ፥ «ኑና ዩዪ ኣꬊዳ ካዎቴꬃታስ ካዎይ ዲዛይሳꬆ ኑኒካ ኑስ ካዎ ካዎꬃና» ጊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","ኢንቴ ካዎꬃናይ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ዶሪዳዴ ጊዲዳይሳ ኤሪቴ፤ ሄሲ ኢንቴ ኣሳ ጊዶፌ ዶሬቲዳይሳ ጊዶፌ ኣቲን ሃራ ቢታ ኣስ ኢንቴ ቦላ ካዎሶፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","ሄ ካዎዚ ዳሮ ፓራ ባስ ሺሻናስ ቤሴና፤ ጎዳይ ኣሳይ ጊብጼ ሲሞንታ ማላ ኣዛዚዳ ጊሻስ ሄፔ ፓራ ሻማናስ ኣሳ ዬዶፎ። ");
INSERT INTO gmve_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","ኢዛ ዎዚና ባሌꬆንታ ማላ ካዎይ ጮራ ማቾ ኤኮፎ፤ ዎርቃኔ ቢራካ ዳርሲ ሺሾፎ። ");
INSERT INTO gmve_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","ኢዚ ባ ካዎቴꬃ ኣልጋን ኡቲዛ ዎዴ ጾሳ ዎጋ ማጻፋ ሌዌ ቆሞ ጊዲዳ ቄሴታ ማታፔ ባስ ዱቂ ኤኮ። ");
INSERT INTO gmve_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","ሄ ማጻፋዛ ባ ማታን ዎꬂዲ ባ ዴኦ ላይꬅ ኡባን ናባቦ፤ ኢዚ ሂስቲኮ ጎዳ ባ ጾሳ ቦንቾኔ ሄ ማጻፋን ጻፌቲዳ ዎጋታኔ ማራታ ኬሂ ናጌቲዲኔ ኣማኔቲዲ ፖሎ ታማራና። ");
INSERT INTO gmve_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","ሂስቲኮ ኢዚ ባ ዎዚናን፥ «ታኒ ታ ላጌታፔ ኣꬋይስ» ጊዲ ኢስራኤሌ ኣሳ ቦላ ኦቶሬቴና፤ ጎዳ ባ ጾሳ ዎጋፔ ሃዲርሲኔ ኡሻች ጌና፤ ኢዚ ዳሮ ላይꬅ ካዎታና፤ ኢዛ ናይቲካ ኢስራኤሌ ቢታን ዳሮ ላይꬅ ካዎታና። ");
INSERT INTO gmve_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","ሌዌታፔ ቄሴቲኔ ቃሴካ ኩሜꬃ ሌዌ ቆሞቲ ሃንኮ ኣቲዳ ኢስራኤሌ ኣሳራ ቢታ ጊሼቲዛ ዎጋይ ኢስታስ ባይንዳ ጊሻስ ኢስቲ ጎዳስ ያርሻናስ ሺሺዛ ያርሾፌ ሚዲ ዴቶ። ");
INSERT INTO gmve_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","ኢስታ ኢሻታ ኢስራኤሌ ኣሳ ጋርሳን ኢስታስ ጺንጾ ጋዴይ ዶፖ፤ ኢዚ ኢስታስ ኢሚዳ ሂዶታ ቃላ ማላ ጎዳይ ኢስታስ ጺንጾ። ");
INSERT INTO gmve_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","ዎፋኖ ጊዲን ዎይኮ ዶርሳ ያርሾስ ሺሺዛ ዎዴ ቄሴቲ ሚሳታ፥ ባንቂላታኔ ጋንጄታ ኤኬቶ። ");
INSERT INTO gmve_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","ኢንቴ ካꬃፌ ጼራ፥ ዎይኔ ኡሻፌኔ ዎጋራ ዛይቴፔ ጼራ፥ ዶርሳ ኢስኬፌ ኮይሮ ቃንጼቲዳይሳ ኢስታስ ኢሚቴ። ");
INSERT INTO gmve_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","ሜርናስ ቄሴቴꬃን ኦꬃና ማላ ሃራ ቆሞታ ጊዶፌ ጎዳ ኢንቴ ጾሳይ ሌዌ ቆሞታ ባስ ዶሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","ሌዌ ቆሞታፔ ኢሲ ኣሲ ካሴ ባ ዲዛ ኢስራኤሌ ካታማፔ ጎዳይ ዶሪዳሶ ባናስ ዳሮ ኣሞይ ኢዛስ ዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","ቢዲ ሄን ካሴ ሃጋዚዛ ሌዌ ቆሞቲ ኦꬂዛይሳꬆ ኢዚካ ጎዳ ሲንꬃን ኦꬆ። ");
INSERT INTO gmve_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","ቃሴ ባ ኣዋ ኣቆ ባይዚን ባና ጋኪዳይሳ ኤኪዳ ጊዲኮካ ቄሴቲ ጎኤቲዛይሳ ኡባ ኢስታራ ጊና ጊሼቲ ኤኮ። ");
INSERT INTO gmve_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዛ ቢታ ኢንቴ ጌሊዛ ዎዴ ሄ ቢታን ዲዛ ካዎቴꬃይ ኦꬂዛ ቱና ኦሶ ኦꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","ባ ኣቱማ ና ዎይኮ ማጫ ና ያርሾስ ጊዲ ታማን ጹጊዛ ኣይ ኣሲካ ኢንቴ ጊዶን ዶፖ፤ ቢቲዛይ፥ ማራጬ ጼሊዛይ፥ ሙሬኒዛይኔ ማሮይ ኢንቴ ጊዶን ዶፖ። ");
INSERT INTO gmve_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","ቃሴካ ዳጋሚዛዴይ (ጎጂዛይ)፥ ዎይኮ ሞይቲሌ ጼይጊዛዴይ ዎይኮ ኢታ ኣያናታራ ሃሳይዛዴይ፥ ዎይኮ ሃይቂዳ ኣሳታ ኣያናራ ሃሳይዛዴይ ኢንቴ ጊዶን ዶፖ። ");
INSERT INTO gmve_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","ሄሳንታ ማላ ኦꬂዛ ኣይ ኣሲካ ጎዳ ማታን ኢጼቲዳዴ፤ ኢስቲ ሄሳ ማላ ቱና ኦꬂዳ ጊሻስ ጎዳ ኢንቴ ጾሳይ ሄ ካዎቴꬃታ ኢንቴ ሲንꬃፌ ꬎቃሊ ꬋይሳና። ");
INSERT INTO gmve_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","ጎዳ ኢንቴ ጾሳ ሲንꬃን ሙሌራ ኢንቴ ኣማኔቲዛይታ ጊዳናስ ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","ሃ ኢንቴ ላታናስ ቢዛ ቢታን ዲዛ ካዎቴꬃቲ ሙሬኒዛይቲኔ ማራጬ ጼሊዛይቲ ዮቲዛይሳ ሲዪዛይታ። ኢንቴ ጊዲኮ ሄሳꬆ ኦꬆንታ ማላ ጎዳ ኢንቴ ጾሳይ ኢንቴና ዲጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","ጎዳ ኢንቴ ጾሳይ ኢንቴ ዛሬፔ ታ ማላ ናቤ ዴንꬃና፤ ኢንቴ ኢዚ ኢንቴስ ዮቲዛይሳ ሲዪዲ ኣዛዜቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","ኢንቴ ሲና ዙማ ቦላ ሺቂዳ ዎዴ ጎዳ ኢንቴ ጾሳ፥ «ኑኒ ሃይቆንታ ማላ ጎዳ ኑ ጾሳ ጬንጉርሳ ዛሪ ሲዮኮ፤ ቃሴካ ሃ ዎልቃማ ታማካ ናምኣንꬆ ቤኦኮ» ጊዲ ኦይቺዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","ሄሳ ጊሻስ ጎዳይ ታስ፥ «ኢስቲ ኦይቺዛ ኦይሻይ ሊኬ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","ታኒ ኢስታ ዛሬታ ጊዶፌ ኢስታስ ኔ ማላ ናቤ ዴንꬃና፤ ኢዚ ሃሳያና ቃላ ታ ኢዛስ ኢማና፤ ታ ኣዛዚዛይሳ ኡባ ኢዚ ኢንቴስ ዮታና። ");
INSERT INTO gmve_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","ታ ሱንꬃን ዮቲዛ ሄ ናቤዛ ቃላ ሲዮንታ ኣስ ታ ቃጻያና። ");
INSERT INTO gmve_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","ጊዶ ኣቲን ታ ኢዛ ኣዛዞንታ ጻላቴꬃን ታ ሱንꬃን ዮቲዛ ናቤይ ዎይኮ ኤቃ ጾሳታ ሱንꬃን ዮቲዛ ናቤይ ሃይቆ። ");
INSERT INTO gmve_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","ኢንቴ፥ «ናቤይ ዮቲዛ ቲንቢቴ ቃላይ ጎዳፔ ጊዶንታይሳ ታ ኣዛን ሻካ ኤራኔ?» ጊ ኦይቻና ዳንዳዬታ። ");
INSERT INTO gmve_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","ሄ ናቤዚ ዮቲዳይ ጎዳ ሱንꬃን ዮቲን ኢዚ ዮቲዳ ቃላይ ፖሌቶንታ ኣጊኮ ሄሲ ጎዳይ ዮቶንታይሳ ጊዲዳይሳ ኤሬታ፤ ሄ ናቤዚ ዎርዶ ሃሳይዳ ጊሻስ ኢዛስ ያዮፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዛ ቢታን ዲዛ ካዎቴꬃታ ꬋይሲዲ ኢንቴ ኢስታ ካታማታኒኔ ኬꬃታን ዴኦ ዶሚዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","ጎዳ ኢንቴ ጾሳይ ኢንቴስ ጺንጾ ኦꬂዲ ኢሚዛ ቢታን ዲዛ ካታማታፔ ሄꬑ ካታማታ ኢንቴስ ሻኪቴ። ");
INSERT INTO gmve_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","ጎዳ ኢንቴ ጾሳይ ኢንቴስ ጺንጾ ኦꬂዲ ኢሚዛ ቢታ ሄꬑ ኬሲ ሻኪቴ፤ ሂስቲዲ ኣሴ ዎꬊዳ ኣሲ ኦኒካ ሄ ካታማታፔ ኢሳን ባቃቲ ኣታና ማላ ሄ ኤፊ ጋꬂዛ ኦጌ ጊግሲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","ኢሲ ኣሲ ካሴ ኢዛራ ሞርኬቴꬂ ባይንዳዴ ዎꬋና ጊ ቆፖንታ ዲንጋቴ ኣስ ዎꬊኮ ሄሳዴይ ካታማታፔ ኢሲኔይን ቢ ጌሊዲ ባ ሼምፖ ኣሾ። ");
INSERT INTO gmve_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","ሌሚሶስ ናምኡ ኣሳቲ ሚꬅ ቃንጻና ቢዳሶን ኢስቲ ሚꬅ ቃንጺሺን ሚꬃ ቃንጺዛ ቤዪጼዚ ዎይኮ ካልታዚ ቱቴዛፔ ቆፖንታ ኮሌቲ ቢዲ ኢዛራ ዲዛዴዛ ዎꬊኮ፥ ሄ ቤዪጼይ ኢዛ ኩሼፔ ኮሌቲ ቢ ዎꬊዳዴዚ ሄ ሄꬑ ካታማታፔ ኢሲ ካታማዮ ቢ ጌሊ ባ ሼምፖ ኣሾ። ");
INSERT INTO gmve_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","ቆቴቲ ኣቲዛ ካታማይ ኤሶን ጋኬቶንታ ሃኮሶን ዲዛ ጊዲኮ ኦጌይ ኣዱቂዳ ጋሶን ሱꬅ ኣዛሪዛዴይ ኬሂ ሃንቄቲዲ ጎዲ ጋኪዲ ሃይቃናስ ቤሶንታይሳ ዎꬋናስ ዳንዳዬስ፤ ጋሶይካ ኢዚ ባ ሾሮ ዎꬊዳይ ሞርኬቴꬂ ዲዛ ጊሻስ ጊዴና። ");
INSERT INTO gmve_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","ኢንቴ ሄꬑ ካታማታ ዱማ ሻካና ማላ ታ ኢንቴና ኣዛዚዛይ ሄሳ ጊሻሳ። ");
INSERT INTO gmve_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","ጎዳ ኢንቴ ጾሳይ ካሴ ኢንቴ ኣዋታስ ጌሊዳ ሂዶታ ቃላ ማላ ኢዚ ኢንቴ ዛዋ ኣሲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","ሃች ታ ኢንቴና ኣዛዚዳይሳ ኡባ ኢንቴ ፖሊኮ፥ ጎዳ ኢንቴ ጾሳካ ሲቂኮ ቃሴ ኢዛ ኦጌን ቢኮ ኢዚ ኢንቴስ ሃኖ ቢታዮ ኢሚዛ ጊሻስ ኣሲ ኢስታን ባቃቲ ቢዲ ኣታና ማላ ሃራ ሄꬑ ካታማታ ጉጂ ጊግሲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","ኢንቴ ሄሳꬆ ኦꬂዛ ጋሶይካ ኢንቴ ኢዚን ዳና ማላ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ጺንጾ ሂስቲ ኢሚዛ ቢታይን ጺሎ ሱꬂ ጉኮንታ ማላኔ ኢንቴካ ሱꬃ ኣጮን ኦይሼቶንታ ማላሳ። ");
INSERT INTO gmve_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","ጊዲኮካ ኢሲ ኣሲ ሞርኬቴꬃን ዴንዲዲ ጌማን ዛማዲ ኡቲዲ ቃꬌታይ ባይንዳ ኣስ ዎꬊዳፔ ጉዬ ባ ሼምፖ ኣሻናስ ሄ ካታማታፔ ኢሲኔይን ባቃቲ ቢኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","ኢዚ ዲዛ ካታማ ጪማቲ ኢዚ ባቃቲ ቢዳ ካታማፔ ኣስ ኪቲ ኤሂሲዲ ሃይቂዳይሳ ሱꬅ ኣዛሪዛዴስ ኣꬂ ኢሜቶ። ");
INSERT INTO gmve_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","ኢዛስ ኣይኮካ ቃꬌቶፍቴ፤ ኢንቴስ ኡባ ሚሺ ሎኦ ጊዳና ማላ ሼምፖ ዎꬊዛይታ ኢስራኤሌ ጊዶፌ ꬋይሲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዛ ጺንጾን ቤኒ ኣሳቲ ኢንቴሲኔ ኢንቴ ሾሮስ ጊዶን ኤሲዳ ዛዋ ሾዶፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","ኣሲ ሞሪዳ ሞሮ ሻኪ ኤራናስ ኢሲ ማርካይ ጻላ ጊዴና፤ ናምኡ ዎይኮ ሄꬑ ማርካይ ማርካታና ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","ኢሲ ኢታ ኣሲ ሃራ ኣስ ዎርዶራ ሞቲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","ናምኣቲካ ሄ ዎዴ ጎዳ ሲንꬃን ኦꬂዛ ቄሴታ ሲንꬃኒኔ ፒርዲዛ ዳናታ ሲንꬃን ኤቄቶ። ");
INSERT INTO gmve_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","ሄ ፒርዲዛይቲካ ሄ ዮኦዛ ሎኤꬂ ፒልጊ ጼሌቶ፤ ሄ ማርካቲዛዴዚ ባ ኢሻዛ ቦላ ዎርዶራ ማርካቲዳይሲ ቱሙ ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","ኢዚ ሄ ሞቶዛ ባ ኢሻ ቃጻይሳናስ ቆፒዳ ቂጻቴዛን ባ ሁኤስ ቃጻዬቶ፤ ሂስቲዲ ሄሳ ማላ ኢታ ኦꬂዛይሳ ኢንቴ ጊዶፌ ዲጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","ሂስቲኮ ሃራ ኣሳይ ሄሳ ሲዪዲ ባባና፤ ሄሳ ማላ ኢታ ኦሶይ ኢንቴ ጊዶን ኦሴቴና። ");
INSERT INTO gmve_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","ሄሳ ማላ ኢታ ኦꬂዛይታስ ሙሌካ ቃꬌቶፍቴ፤ ሼምፖ ዎꬊዳዴ ዎꬊቴ፤ ኣይፌ ቶይሲዳዴስ ኣይፌ ቶይሲቴ፤ ኣች ሜንꬂዳዴስ ኣች ሜንꬂቴ፤ ኩሼ ሜንꬂዳዴስ ኩሼ ሜንꬂቴ፤ ቶሆ ሜንꬂዳዴስ ቶሆ ሜንꬂቴ። ");
INSERT INTO gmve_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","ኢንቴ ኢንቴ ሞርኬታ ኦላና ቢሺን ፓራ-ጋሬቲኔ ቶጋ ኣሳቲ ኢንቴፌ ዳሮ ጊዲኮ ሄሳ ቤኢዲ ዳጋሞፍቴ፤ ጋሶይካ ኢንቴና ጊብጼፔ ኬሲዳ ጎዳ ኢንቴ ጾሳይ ኢንቴናራ ዲዛ ጊሻስ ባቦፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","ኢንቴ ኦላ ዶማናፔ ሲንꬃቲዲ ቄሴዚ ኦላ ኣሳኮ ሺቂዲ፥ ");
INSERT INTO gmve_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","«ኢስራኤሌ ኣሳዉ! ሃ ኤዝጊቴ! ኢንቴ ሃች ኢንቴ ሞርኬታራ ኦሌታናስ ቤታ፤ ኢንቴ ዎዚናይ ዳጋሞፎኔ ባቦፎ፤ ኢስታ ሲንꬃን ኮኮሮፒቴኔ ሺሮቶፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","ጎዳ ኢንቴ ጾሳይ ኢንቴ ሞርኬታ ኦላናስ ኢንቴናራ ቢዛ ጊሻስ ኢዚ ኢንቴና ጾኒሳና» ጎ። ");
INSERT INTO gmve_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","ሄሳፌ ካሊዲ ኦላ ኣሳ ካሌꬂዛይቲ ኦላንቻታስ፥ «ኦራꬃ ኬꬅ ኬጺዲ ጌሎንታ ኣሲ ኢንቴ ጋርሳን ዲኮ ኢዚ ኦላሶ ቢ ሃይቂን ሃራ ኣሲ ኢዛ ኬꬃን ጌሎንታ ማላ ባሶ ጉዬ ሲሞ። ");
INSERT INTO gmve_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","ዎይኮ ዎይኔ ቶኪዲ ኢዛ ኣይፌ ሺሾንታ ኣሲ ዲኮ ኢዚ ኦላን ሃይቂን ሃራ ኣሲ ኢዛ ዎይኔ ኣይፌ ባስ ሺሺዲ ኡፋዬቶንታ ማላ ኢዚ ባሶ ሲሞ። ");
INSERT INTO gmve_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","ማቾ ኤካና ጊግሲ ዎꬂዳ ኣሲ ኦላን ሃይቂን ሃራ ኣሲ ኢዞ ኤኮንታ ማላ ኢዚ ባሶ ሲሞ» ጌቶ። ");
INSERT INTO gmve_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","ኦላ ኣሳ ካሌꬂዛይቲ፥ «ዎዚናይ ባቢዛ ኣሲ ኢንቴ ጋርሳን ዲኮ ሃንኮ ኦላ ኣሳ ዎዚና ሂርጊሶንታ ማላ ኢዚ ባሶ ሲሞ» ጌቶ። ");
INSERT INTO gmve_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","ኦላ ኣሳ ካሌꬂዛይቲ ሄሳ ዮቲ ዉርሲዳፔ ጉዬ ኦላ ኣሳ ቡቴን ቡቴን ሻኪዲ ኢሲ ኢሲ ቡቴስ ካሌꬂዛይታ ዶሬቶ። ");
INSERT INTO gmve_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","ኢሲ ካታማ ኦላናስ ቢዲ ኢንቴ ኢስታኮ ማቲዛ ዎዴ ኮይሮቲዲ ሳሮን ኢስቲ ኩሼ ኢማና ማላ ኦይቺቴ። ");
INSERT INTO gmve_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","ኢስቲ ኢንቴና ሳሮን ሞኪ ኤኪዲ ባንታ ጊምቤ ፔንጌ ዶይዲ ኢንቴና ጌልꬂኮ ሄ ካታማን ዲዛ ኣሳይ ኡባይ ኢንቴስ ሃጋዞኔ ዴጾ ኦሶ ኦꬆ። ");
INSERT INTO gmve_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","ጊዶ ኣቲን ሄ ካታማ ኣሳይ ኢንቴስ ሳሮን ባ ኩሼ ኢሞንታ ኢጺዲ ኢንቴናራ ኦሌታና ኮይኮ ኢስታ ካታማ ዶዲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","ጎዳ ኢንቴ ጾሳይ ሄ ካታማዮ ኢንቴ ኩሼን ኣꬂ ኢሚዛ ዎዴ ሄ ካታማይን ዲዛ ኣቱማሳ ኡባ ዎꬊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","ጊዶ ኣቲን ማጫሳታኔ ጉꬃ ናይታ፥ ሜሄኔ ሄ ካታማይን ዲዛ ኣቆታ ኡባ ኢንቴስ ዲኢ ኤኪቴ፤ ቃሴ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዛ ኢንቴ ሞርኬታ ኣቆታ ኢንቴስ ጎኤቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","ቃሴካ ኢንቴ ዲዛሶፔ ሃኪ ዲዛ ካታማታካ ኢንቴ ኦይኪዛ ዎዴ ሃይሳፌ ካሊዛይሳ ኦꬂቴ። ");
INSERT INTO gmve_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኣꬂ ኢሚዳ ቢታ ቦላ ኣሳ ኢንቴ ኦሊ ኦይኪዛ ጊዲኮ ኣሳ ኡባ ዎꬊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","ጎዳይ ኢንቴ ጾሳይ ኢንቴና ኣዛዚዳ ማላ ሂቴታ፥ ኣሞሬታ፥ ካናኔታ፥ ፓሪዜታ፥ ሂዌታኔ ያቡሴታ ኡባ ዎꬊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","ኢንቴ ሂስቶንታ ኣጊኮ ኢስቲ ባንታ ኤቃ ጾሳታስ ጎይኒዛ ቱና ኦሶ ኢንቴ ኦꬃና ማላ ኢንቴና ታማርሳና፤ ሄሳን ጎዳ ኢንቴ ጾሳ ቦላ ናጋራ ኦꬃና። ");
INSERT INTO gmve_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","ኢንቴ ካታማ ኦይካናስ ዶዲ ዳሮ ጋላስ ኦሌቲሼ ጋምኢዛ ዎዴ ኢዛን ዲዛ ኣይፌ ኢሚዛ ሚꬃታ ኣይፌ ኢንቴ ማና ዳንዳይዛ ጊሻስ ኢስታ ቃንጾፍቴ፤ ኢስቲ ኣይፌ ኣይፊዛ ሚꬃፌ ኣቲን ኣሳራ ኦሌቲዛ ኣስ ጊዴቴና፤ ሄ ዴምባን ዲዛ ሚꬃታ ቃንጾፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","ሃንኮ ኣይፌ ኣይፎንታ ሚꬃታ ጊዲኮ ኢስታ ቃንጼሬꬂ ዬጊዲ ሄ ካታማያ ኩንዳና ጋካናስ ጊዶꬂ ናጋና ዳንዳዬታ። ");
INSERT INTO gmve_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","ኢንቴ ላታና ማላ ጎዳ ኢንቴ ጾሲ ኢንቴስ ኢሚዛ ቢታይን ኦኒ ዎꬊዳኮ ኤሬቶንታ ኣሳ ኣሃይ ጮ ዴምባን ኩንዲ ቤቲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","ኢንቴ ዳናቲኔ ኢንቴ ጪማቲ ቢዲ ኣሃዚ ዲዛሶፔ ዶሚዲ ሄ ሄራን ዲዛ ካታማታ ጋካናስ ዲዛ ሃሆቴꬃ ዋꬌቶ። ");
INSERT INTO gmve_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","ሄሳፌ ጉዬ ኣሃዚ ዲዛሶስ ማቲዛ ካታማይን ዲዛ ካሌꬂዛይቲ ኦሶስ ጋኮንታ ቡሮ ቃምባራይ ኢዚ ሞርጌ ቦላ ዎꬎንታ ኢሲ ኡሱ ዶሬቶ። ");
INSERT INTO gmve_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","ሄ ኡሲዮ ሙሌካ ጎዬቲ ኤሮንታሶ፥ ኣይ ኣታኪልቴይ ቶኬቲ ኤሮንታሶኔ ጎጊዛ ሃꬂ ዲዛ ሾባ ኤፊዲ ሄን ኡሳይ ሞርጌ ሚርቂ ሜንꬄቶ። ");
INSERT INTO gmve_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","ሂስቲዲ ጎዳ ኢንቴ ጾሳይ ባ ሲንꬃን ኦꬃና ማላ፥ ባ ሱንꬃን ኣንጃና ማላ፥ ሞቶኔ ሼምፖ ዳፋ ጌሊዲ ሻኪ ፒርዳና ማላ ጎዳ ኢንቴ ጾሳይ ሌዌ ናይታፔ ዶሪዳ ቄሴቲ ኣሃዚ ዲዛሶ ማታ ቤቶ። ");
INSERT INTO gmve_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","ሄሳፌ ጉዬ ኣሃዚ ዲዛሶ ማታን ዲዛ ካታማዮ ካሌꬂዛ ጪማቲ ሞርጌ ሚርቂ ሜንꬂዳ ኡሳይ ቦላ ባንታ ኩሼ ሜጬቴቶ። ");
INSERT INTO gmve_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","ሂስቲዲ፥ «ሃይሳ ኑ ዎꬊቤኮ፤ ኦኒ ዎꬊዳኮካ ኑ ቤዪቤኮ። ");
INSERT INTO gmve_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","ጎዳዉ! ኔኒ ጊብጼፔ ዎዛዳ ኬሲዳ ኔ ዴሬ ኢስራኤሌ ናጋራ ዉርሳ፤ ኑናካ ማራ፤ ሃይሳ ጉኪዳ ጺሎ ሱꬃ ጊሻስ ኑና ኦይቾፋ» ጌቶ። ");
INSERT INTO gmve_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","ኢንቴ ጎዳ ሲንꬃን ሱሬ ሚሽ ኦꬂዲ ጺሎ ሱꬂ ጉኪዳ ናጋራ ኢንቴ ጊዶፌ ዲጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","ኔ ሞርኬታራ ኔ ኦሌታናስ ኬዚን ጎዳ ኔ ጾሲ ኢስታ ኔ ኩሼን ኣꬂ ኢሚን ኔ ኢስታ ዲኢዳ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","ሄ ዲኤቲዳይታ ጊዶን ማላ ሎኦ ማጫስ ዴማዳ ኢዞ ኔስ ማቾ ኤካናስ ኮይኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","ኢዞ ኔኒ ኔሶ ኤሂኮ ኢዛ ባ ሁኤ ሜዴቱ፤ ቃሴ ባ ጹጉንꬅ ኢሩ። ");
INSERT INTO gmve_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","ካሴ ኢዛ ዲኤታ ያሼ ማይኢዳ ማይኦ ላሙ፤ ኢሲ ኣጊና ጋካናስ ኔሶን ኡታዳ ኦላን ሃይቂዳ ባ ኣይሲኔ ባ ኣዋስ ዬኩ፤ ሄሳፌ ጉዬ ኢዞ ኔስ ማቾ ኤካ። ");
INSERT INTO gmve_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","ጉዬፔ ኔኒ ኢዚን ኡፋዬቶንታ ኣጊኮ ኢዞ ኣንጃ ዬዳናስ ዳንዳያሳ፤ ካሴ ኢዞ ዎልቃራ ኤኪዳይ ኔና ጊዲዳ ጊሻስ ዛራዳ ባይዛናሲኔ ኣይሌ ማላ ቆዳናስ ቤሴና። ");
INSERT INTO gmve_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","ኢሲ ኣሲ ናምኡ ማቾ ኤኪዲ ኢስታፌ ኢሲኔዮ ዶሲዲ ኢሲኔዮ ኢጺኮ ሄ ናምኣቲካ ኢዛስ ኣቱማ ናይታ ዬሊኮ ሄ ዬሌቲዳ ናይታፔ ባይራዚ ኢዚ ኢጺዛሪ ና ጊዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","ኢዚ ባ ሃሮ ባ ናይታስ ጊሺዛ ዎዴ ኢዚ ኢጺዛሪፔ ዬሌቲዳ ባይራ ናዛ ባይራቴꬃ ካꬊዲ ባ ዶሲዛሪፔ ዬሌቲዳ ናዛስ ማዲዲ ኣꬂ ኢማናስ ቤሴና። ");
INSERT INTO gmve_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","ባይራ ናዚ ኢዚ ሲቆንታ ማቼይፌ ዬሌቲኮካ ኢዚ ኢዛስ ኮይሮ ዬሎ ጊዲዳ ጊሻስ ሃንኮ ናይታፔ ናምኡ ኩሼ ኣꬂ ኢሚዲ ኢዚ ባይራ ጊዲዳይሳ ኤሪሶ። ");
INSERT INTO gmve_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","ኣዋሲኔ ኣዪስ ኣዛዜቶንታ ኢጺዲ ኢስቲ ሙሪንካ ሲሞንታ ኢጺዳ ማካላንቻኔ ዎዚና ሙሜ ናይ ኢስታስ ዲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","ኣያኔ ኣዋይ ባንቲ ዲዛ ካታማታ ጋርሳን ጪማቲ ፒርዲዛሶ ኤኪ ቤቶ። ");
INSERT INTO gmve_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","«ሃይሲ ኑ ናዚ ዎዚና ሙሜ፤ ማካላንቻ፤ ኑስ ኣዛዜቴና፤ ማꬆቴሲኔ ሚሽ ጮ ꬋይሴስ» ጊ ጪማታስ ዮቴቶ። ");
INSERT INTO gmve_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","ሄ ካታማይን ዲዛ ኣቱማ ኣሳይ ኡባይ ኢዛ ሹቻን ጫዲ ዎꬌቶ፤ ኢንቴ ሄሳꬆ ሂስቲኮ ኢንቴ ጋርሳፌ ኢታ ሚሺ ꬋያና፤ ኢስራኤሌ ዴሬን ዲዛይ ዉሪ ሄሳ ሲዪዲ ያያና። ");
INSERT INTO gmve_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","ኢሲ ኣሲ ባ ኦꬂዳ ጊታ ሞሮ ጋሶን ሚꬃ ቦላ ካቄቲ ሃይቃና ማላ ፒርዴቲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","ሚꬃ ቦላ ካቄቲ ሃይቂዳ ኣሲ ጾሲ ቃንጊዳዴ ጊዲዳ ጊሻስ ኢዛ ኣሃይ ሚꬃ ቦላ ካቄቲ ኣቆፖ፤ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዛ ቢታ ቱኒሶንታ ማላ ሃይቂዳ ኣሃዛ ሄ ጋላስ ሞጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","ኢስራኤሌ ኣሳ ቦራይ ዎይኮ ዶርሲ ꬋይዲ ዎራ ቢሺን ኢንቴ ዴሚኮ ጮኡ ጊ ኣꬎፍቴ፤ ኢዛ ጎዳስ ላጋ ኤፋ ኢማ። ");
INSERT INTO gmve_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","ጊዶ ኣቲን ሜሃዴይ ዲዛሶይ ሃሆ ጊዲኮ ዎይኮ ሄ ሜሃዴይ ኦናኮ ኔ ኤሮንታ ኣጊኮ ሜሄዛ ኔሶ ኤካዳ ባ፤ ሜሃዴይ ኮዪሼ ዪኮ ኢዛይሳ ኢዛስ ዛራ። ");
INSERT INTO gmve_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","ማይኦ ጊዲን ዎይኮ ሃሬ ጊዲን ዎይኮ ሃራ ኣይ ሚሺካ ኔ ባጋ ኢስራኤሌ ኣሳፔ ꬋዪን ኔ ዴሚዳ ጊዲኮ ዛራዳ ኢዛዴስ ኢማ። ");
INSERT INTO gmve_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","ኔ ባጋ ኢስራኤሌ ኣሳስ ሃሬይ ዎይኮ ቦራይ ኦጌን ኩንዲን ኔ ቤኢዳ ጊዲኮ ማዳዳ ዴንꬃ ኣቲን ቤኣሼ ዬጋ ኣꬎፋ። ");
INSERT INTO gmve_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","ጎዳ ኢንቴ ጾሳይ ሄሳꬆ ኦꬂዛይታ ኢጺዛ ጊሻስ ማጫቲ ኣቱማሳታ ማይኦ፥ ኣቱማሳቲ ማጫሳታ ማይኦ ማይኦፌቶ። ");
INSERT INTO gmve_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","ኔ ኦጌ ቢሺን ካፎይ ባ ኬꬃን ሚꬃ ቦላ ዎይኮ ቢታ ቦላ ዬሊዳ ጪዬታ ዎይኮ ጱጱሌ ሃጳ ዲዛ ካፎ ኔ ዴሚዳ ካፎዮ ጪዬታራ ጋꬃ ኔሶ ኤፎፓ። ");
INSERT INTO gmve_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","ጪዬታ ኔሶ ኤካ ባናስ ዳንዳያሳ፤ ኣዬዮ ጊዲኮ ኢዛ ፒራꬋ ባና ማላ ዬዳ፤ ኔኒ ሄሳꬆ ኦꬂኮ ኔስ ሎኦ ጊዳናኔ ኔ ዳሮ ላይꬅ ዳና። ");
INSERT INTO gmve_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","ኔ ኦራꬃ ኬꬅ ኬጻሼ ሄ ኬꬃ ካራፔ ኣሲ ኩንዲዲ ሱꬃ ኣጮን ኔና ኦይሺሶንታ ማላ ኬꬃ ካራ ቦላ ቴቄ ዎꬃ። ");
INSERT INTO gmve_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","ኔኒ ዎይኔ ሚꬅ ቶካሼ ኢዛ ጊዶን ሃራ ዜሬꬅ ዜሮፓ፤ ኔ ሃራ ዜሪኮ ዎይኔ ሚꬃ ኣይፌፔ ጊዲን ዎይኮ ሃራ ኔ ዜሮ ካꬃፌ ጎኤታናስ ዳንዳያካ። ");
INSERT INTO gmve_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","ቦራኔ ሃሬ ኢሲፌ ኢሲ ቃምባራን ዋጻ ጎዮፓ። ");
INSERT INTO gmve_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","ሱፌፔኔ ፑቶፌ ዋላኬቲ ዳዴቲዳ ማይኦ ማይኦፋ። ");
INSERT INTO gmve_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","ኔ ማይኣና ማይኦስ ኦይዱ ባጋራካ ማጫራ ሜꬋ። ");
INSERT INTO gmve_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","ኢሲ ኣሲ ማቾ ኤኪዳ ማላ ኢዚራ ኣቂ ሲሚዲ ኢዞ ኢጺኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","«ሃኖ ማጫሳዮ ኤካዲስ ሺን ኢዚስ ጌላኦቴꬃ ዎጋይ ባዋ» ጊዲ ዎርዶራ ኢዚ ሱንꬁ ሞሪኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","ሄ ናዮ ዬሊዳይቲ ናያ ጌላኦ ጊዲዳይሳስ ማርካ ኤሂዲ ሄ ካታማን ዲዛ ጪማታ ቤሴቶ። ");
INSERT INTO gmve_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","ናይ ኣዋይ ኢስታስ፥ «ታኒ ታ ናዮ ሃይሳ ኣዴዛስ ኢማዲስ ሺን ሃኢ ኢዚ ኢዞ ኢጺዳይሳ ቆንጪሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","‹ኔ ናይስ ጌላኦቴꬂ ባዋ› ጊዲ ታ ናይ ሱንꬁ ሞሪዴስ፤ ታ ናይስ ጌላኦቴꬂ ዲዛይሳስ ሃይሲ ማርካ» ጊዲ ሄ ዴሬ ካሌꬂዛይታ ሲንꬃን ኢዚ ኢዞ ኤኪሺን ማይኦ ቦላ ጉኪዳ ሱꬃራ ዲዛ ማላታ ጫርቃዛ ቤሶ። ");
INSERT INTO gmve_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","ሄ ካታማዮ ካሌꬂዛይቲ ኣዴዛ ሾጪ ቃጻዬቶ። ");
INSERT INTO gmve_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","ቃሴካ ኢዚ ኢስራኤሌ ናይታፔ ጌላኦቴꬃራ ዲዛ ኢሲኔይ ሱንꬁ ሞሪዳ ጊሻስ ኢሲ ጼቱ ሳቂሌ ቢራ ናይ ኣዋስ ማጋጮ ቃንጾ፤ ሄሳፌ ጉዬ ናያካ ኢዛስ ማቾ ጊዱ፤ ኢዚ ሼምፖራ ፓጻ ዲዛ ላይꬅ ኡባን ኢዞ ኣንጂ ዬዳናስ ዳንዳዬና። ");
INSERT INTO gmve_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","ጊዶ ኣቲን ኢዚ ጊዳይሲ ቱሙ ጊዲ ቤቲኮ ቃሴ ኢዛ ጌላኦ ጊዲዳይሳ ቆንጪሲዛ ማላታይ ባይንዳ ኣጊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","ኢዛ ባ ኣዋ ሶን ዳሼ ላይማታዳ ኢስራኤሌ ኣሳ ዬላቺዛ ኦሶ ኦꬂዳ ጊሻስ ኢዞ ኢዚ ኣዋ ኬꬃ ካሬ ኤፌቶ፤ ሄ ካታማን ዲዛ ኣሳይ ኢዞ ሹቻራ ጫዲ ዎꬎ፤ ሄሳꬆ ሂስቲዲ ኢንቴ ጊዶፌ ኢታ ሚሽ ዲጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","ኢሲ ኣሲ ሃራ ኣሳ ማቺራ ዚንኢ ቤቲኮ ናምኣይካ ሃይቄቶ፤ ሄሳꬆ ሂስቲዲ ኢንቴ ጊዶፌ ኢታ ሚሽ ዲጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","ኣይ ኣሲካ ካታማ ጊዶን ኣዚና ጌላና ጊጋ ኡቲዳ ጌላኦይራ ዚንኢዲ ቤቲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","ናምኣታካ ሄ ካታማይፔ ካሬ ኬሲዲ ሹቻን ጫዲ ዎꬊቴ፤ ጌላኦያ ካታማ ጊዶን ዳሼ፥ «ታና ኣሺቴ» ጋዳ ዋሶንታ ጊሻስ ሃይቃናስ ቤሴስ፤ ቃሴ ኣዴዚ ሃራ ኣሳራ ጊጋ ዲዛሪራ ዚንኢዲ ዎጋ ሜንꬂዳ ጊሻስ ሃይቃናስ ቤሴስ፤ ሄሳꬆ ሂስቲዲ ኢንቴ ጊዶፌ ኢታ ሚሽ ዲጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","ኢሲ ኣሲ ሃራ ኣሳስ ጊጋ ኡቲዳ ጌላኦዮ ኢዛ ዲዛ ካታማፔ ሃራሶን ዴሚ ዎልቃꬂዲ ኢዚ ጌላኦቴꬃ ኤኪዳ ጊዲኮ ሄሳዴይ ጻላ ሃይቆ። ");
INSERT INTO gmve_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","ናያ ሃይቆስ ጋꬂዛ ናጋራ ኦꬆንታ ጊሻስ ኢዞ ቦቾፍቴ፤ ሃይሳ ማላ ኦሶይ ኢሲ ኣሲ ጌኔራ ባ ላጌዛ ሼምፖ ዎꬊዛይሳራ ኢሲ ጊና። ");
INSERT INTO gmve_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","ሄሲካ ሄ ኣዴዚ ሃራ ኣሳስ ጊጌታ ኡቲዳ ጌላኦያ ባ ዲዛ ካታማፔ ካሬን ዲሺን ዴሚዲ ኢዞ ኦይኪዳ ጊሻሲኔ ኢዛ ዋሲዳኮካ ኢዞ ኣሻና ኣሲ ባይንዳ ጊሻሳ። ");
INSERT INTO gmve_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","ኣይ ኣሲካ ሃራ ኣሳራ ጊጌቶንታ ጌላኦይራ ዚንኢሼ ኦይኬቲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","ናይ ኣዋስ ኢቻሽ ታሙ ሳቂሌ ቢራ ቃንጺዲ ኢዞ ባስ ማቾ ሂስቶ፤ ዎልቃን ኢዚራ ዚንኢዳ ጊሻስ ሃይቃና ጋካናስካ ኢዞ ኣንጂ ዬዳናስ ዳንዳዬና። ");
INSERT INTO gmve_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","ኦኒካ ባ ኣዋ ማቾ ኤኪዲ ዎይኮ ኢዚራ ዚንኢዲ ባ ኣዋ ዬላሶፖ። ");
INSERT INTO gmve_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","ሳንጌቲዳ ኣሲ ዎይኮ ቃራቴቲዳ ኣሲ ጎዳ ዴሬ ዱላታን ቤቶፎ። ");
INSERT INTO gmve_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","ላጌꬆን ዬሌቲዳይኔ ኢዛ ዜሬꬂ ቢዲ ታማንꬆ ጋካናስ ጎዳ ኣሳ ሺቆን ጌሎፖ። ");
INSERT INTO gmve_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","ኣሞኔኔ ሞኣቤ ዜሬꬃቲ ዉሪካ ታማንꬃ ዬሌታ ጋካናስ ጎዳ ኣሳ ዱላታን ጌሎፔቶ። ");
INSERT INTO gmve_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","ጋሶይካ ኢንቴ ጊብጼፔ ኬዚዲ ዪሺን ኢስቲ ኢንቴና ካꬂኔ ሃꬅ ዲጊዳ፤ ቃሴ ሜስጴጾሚያ ቢታን ፓቶሬ ካታማን ዲዛ ቢኦሬ ና ባላሜይ ኢንቴና ቃንጋና ማላ ሚሻን ሻሚዳ። ");
INSERT INTO gmve_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","ጊዶ ኣቲን ጎዳ ኢንቴ ጾሳይ ኢንቴና ሲቂዛ ጊሻስ ባላሜይ ቃንጊዛ ቃንጌꬃ ሲዪቤና፤ ኢዚ ቃንጊዳ ቃንጌꬃ ኣንጆን ላሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","ሄ ዴሬ ኣሳቲ ዱሬቲዲ ሳሮን ዳና ማላ ኢስታ ማዶፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","ኢስቲ ኢንቴስ ዳቦ ጊዲዳ ጊሻስ ኤዶሜ ኣሳ ካꬊዲ ኢጾፍቴ፤ ቃሴ ኢንቴ ጊብጼ ቢታን ካሴ ቤቴ ጊዲዲ ዴኢዳ ጊሻስ ጊብጼ ኣሳታካ ኢጾፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","ኢስታ ዜሬꬂ ሄꬓንꬆ ዬሌታፔ ዶሚዲ ጎዳ ኣሳ ሺቆን ዋላኬታና ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","ኢንቴ ኦላስ ኬዚዲ ዱንካኒ ኡቲዳሶሆን ኢንቴና ቱኒሲዛ ሚሻፌ ናጌቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","ኢሲ ኣሲ ኦማርስ ኣጉሞራ ማላይ ኢዛ ቦላ ጉኪኮ ኣሲ ዲዛ ሄራፔ ሃራሶ ቢዲ ሄን ታኮ። ");
INSERT INTO gmve_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","ኦማርሳ ዎዴ ባ ቦላ ሜጬቲዲ ኣርሼይ ዉሊሺን ካሴ ባ ዲዛሶ ሲሞ። ");
INSERT INTO gmve_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","ሼሽ ኡቲዛሶ ኢንቴ ዲዛሶ ሄራፔ ካሬን ጊግሲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","ኢንቴ ሼሽ ኡታናሶ ቦካናሲኔ ቢታ ዛሪ ካማናስ ጎኢዛ ሚሽ ኢንቴ ኦላ ማሳራራ ጋꬂ ኢሲፌ ኦይኪቴ። ");
INSERT INTO gmve_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","ጋሶይካ ጎዳ ኢንቴ ጾሳይ ኢንቴና ናጋናሲኔ ኢንቴ ሞርኬታ ኢንቴ ኩሼን ኣꬂ ኢማናስ ኢንቴ ጉታ ጊዶን ሄሜቴቲዛ ጊሻስ ኢዛ ሻቲዛ ሚሽ ቤኢዲ ጉዬ ሲሞንታ ማላ ኢንቴ ዲዛ ሄራይ ጌሽ ጊዳና ቤሴስ። ");
INSERT INTO gmve_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","ባ ጎዳፔ ባቃቲዲ ኔኮ ዪዳ ኣይሌ ዛራዳ ኢዛ ጎዳስ ኢሞፋ። ");
INSERT INTO gmve_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","ኢዚ ኢንቴ ካታማታፔ ባ ኮዪዳሶን ኢንቴናራ ዴኦ፤ ኢዛ ኡንኤꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","ኢስራኤሌ ኣሳፔ ኦኒኔ ኣቱማ ጊዲን ዎይኮ ማጫ ጊዲን ኤቃ ጾሳታስ ጎይኒዛይቲ ኦꬂዛይሳ ማላ ላይማቶፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","ጎዳ ኢንቴ ጾሳይ ላይማ ኢጺዛ ጊሻስ ኣዴ ጊዲን ዎይኮ ማጫሲ ላይማቴꬃን ዴሚዳ ሚሽ ኣዲና ጋሶ ጊዲ ጎዳ ኢንቴ ጾሳ ኬꬅ ኤሆፔቶ። ");
INSERT INTO gmve_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","ኔ ዛሬ ጊዲዳ ኢስራኤሌ ኣሳስ ሚሼ፥ ካꬅ ዎይኮ ሃራ ሚሽ ታልኣዳ ዛራሼ ዲች ኤኮፋ። ");
INSERT INTO gmve_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","ሃራ ቢታ ኣሳፔ ዲቻ ኤካናስ ዳንዳያሳ፤ ጊዶ ኣቲን ኔ ባጋ ጊዲዳ ኢስራኤሌ ኣሳስ ዲቻስ ታልኦፋ፤ ሂስቲኮ ኔ ባዳ ላታና ቢታይን ጎዳ ኔ ጾሳይ ኔና ኡባ ባጋራካ ኣንጃና። ");
INSERT INTO gmve_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","ጎዳ ኔ ጾሳስ ኔ ኢማና ጋዳ ኣዲኔቲዳ ሚሽ ጋꬃናስ ጋምኦፋ፤ ኔ ጊዳ ቃላ ኔ ፖላና ማላ ጎዳ ኔ ጾሲ ኮዬስ፤ ኔ ኣዲኔቲዳ ቃላ ጋꬆንታ ኢጺኮ ሄሲ ኔስ ናጋራ ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","ጎዳ ኔ ጾሳስ ኔ ኢማና ጋዳ ኣዲኔቶንታ ኣጊኮ ሄሲ ኔስ ናጋራ ጊዴና። ");
INSERT INTO gmve_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","ጊዶ ኣቲን ጎዳ ኔ ጾሳስ ኔ ዶሳን ኢማና ጋዳ ኔ ጌሊዳ ማላ ኔ ኢንጻርሳፌ ኬዚዳይሳ ፖላ። ");
INSERT INTO gmve_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","ኣሲ ቶኪዳ ዎይኔ ሚꬃ ጊዶራ ካንꬃ ባሼ ኔ ኮዪዳ ኬና ኢዛፔ ማናስ ዳንዳያሳ፤ ጊዶ ኣቲን ኣይ ሚሻንካ ዬጋዳ ኔሶ ኤፎፓ። ");
INSERT INTO gmve_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","ኣሳ ካꬃ ጊዶራ ኣꬋ ባሼ ቲያፔ ጹጳ ማና ዳንዳያሳ፤ ጊዶ ኣቲን ማጻ ኤካዳ ኔሶ ቦፓ። ");
INSERT INTO gmve_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","ኢሲ ኣሲ ማቾ ኤኪ ሲሚዳፔ ጉዬ ኢዚ ቦላ ኢሲ ኢታ ሚሽ ዴሚዲ ኢዞ ኢጺኮ ኢዞ ኣንጂ ዬዲሼ ኢዚስ ዋራቃታ ጻፊ ኢሚዲ ዬዶ። ");
INSERT INTO gmve_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","ኢዛሶፔ ኬዛዳ ሃራ ኣዚና ጌሊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","ሄ ናምኣንꬆ ኣዚናይካ ኢዞ ዶሶንታ ኢጺዲ ኢዚስ ዋራቃታ ጻፊ ኢሚዲ ባ ሶፔ ኢዞ ኬሲ ዬዲኮ፥ ዎይኮ ኢዞ ኤኪዳ ሄ ናምኣንꬆ ኣዚናዚ ሃይቂኮ፤ ");
INSERT INTO gmve_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","ኢዛ ቱኒዳ ጊሻስ ኮይሮ ኣንጂ ዬዲዳ ኣዚናዚ ናምኣንꬆ ኢዞ ዛሪዲ ኤኮፎ፤ ሄሲ ጎዳ ማታን ኢጼቲዳይሳ፤ ቃሴ ኢንቴካ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዳ ቢታን ሃይሳ ማላ ናጋራ ኦꬆፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","ማታ ዎዴ ማቾ ኤኪዳ ኣሲ ኦላስ ቦፖ፤ ሃራ ዴጾ ኦሶካ ኢዛ ኦሲሶፒቴ። ኢሲ ላይꬂ ኣꬋና ጋካናስ ባሶን ጋምኢዲ ባናኔ ባ ኤኪዳ ማቺዮ ኡፋይሶ። ");
INSERT INTO gmve_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","ኔኒ ኢሳዴስ ሚሼ ታልኤ ታልኣሼ ካꬅ ጋጪዛ ዎጻ ዎይኮ ዎጻ ማይዴ ኢዛፔ ኦይꬆ ኤኮፋ። ሄሳꬆ ኦሶይ ኣሳ ሼምፖ ኦይሶራ ጊና። ");
INSERT INTO gmve_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","ባ ኢሻ ጊዲዳ ኢስራኤሌ ኣሳ ጋርሳፌ ꬋንካ ባርሲ ኤፊዲ ባስ ኣይሌ ኦꬂዛይ ዎይኮ ሃራ ኣሳስ ኣይሌቴꬃስ ኣꬂ ባይዚዛዴይ ኦኒካ ሃይቆ። ሄሳꬆ ሂስቲዲ ኢታ ኦሶ ኢንቴ ጊዶፌ ዲጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","ኢሳፌ ኢሳን ኣꬊዛ ጋልባ ሃርጌፌ ኬሂ ናጌቲቴ፤ ታኒ ኢስታ ኣዛዚዳ ማላ ሌዌ ቆሞ ጊዲዳ ቄሴቲ ኢንቴስ ኢሚዛ ዎጋታ ሎኤꬂ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","ኢንቴ ጊብጼፔ ኬዚ ዪሺን ጎዳ ኢንቴ ጾሲ ማራሚ ቦላ ኦꬂዳይሳ ዩሺ ቆፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","ኔኒ ኢሳዴስ ኢሲ ሚሼ ታልኤ ኢማሼ ኢዚ ኔና ኦይꬂዛ ሚሽ ኤካናስ ኢዛዴ ሶ ጌሎፓ። ");
INSERT INTO gmve_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","ኔኒ ካሬን ዲሺን ኢዛዴይ ባ ኩሼራ ኔስ ኦይሶ ኤሆ። ");
INSERT INTO gmve_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","ኢዛዴይ ማንቆ ጊዲኮ ኔ ኦይሶ ኤካዳ ኢዛ ኣፋላ ኔ ሶን ኣይሶፋ። ");
INSERT INTO gmve_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","ኢዚ ማይኢ ኣቃና ማላ ኣርሼይ ዉሎንታ ዲሺን ኢዛስ ዛራ፤ ኢዚካ ኔና ጋላታና፤ ሄሲ ኔስ ጎዳ ኔ ጾሳ ኣቻን ጺሎቴꬃን ቆዴታና። ");
INSERT INTO gmve_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","ኔ ባጋ ጊዲዳ ኢስራኤሌ ኣሳፔ ጊዲን ዎይኮ ሃራ ዴሬፔ ቤቴ ዪዲ ሜቶቲዳ ማንቆ ኣሲ ኔስ ኦꬂኮ፥ ኢዛዴ ዎልቃ ጮ ሜላ ኔስ ጎኤቶፋ። ");
INSERT INTO gmve_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","ኢዚ ሃች ኦꬂዳይሳ ሃች ኤካናስ ሚንꬂ ኮይዛ ጊሻስ ኣርሼይ ዉሎንታ ዲሺን ቃንጻ፤ ሂስቶንታ ኣጊኮ ሜቶታንቻይ ኔፔ ዴንዶይሳን ጎዳስ ዋሲኮ ኔስ ናጋራ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","ናይቲ ሞሪዳ ሞሮን ዬሊዳይቲ፥ ቃሴ ዬሊዳይቲ ሞሪዳ ሞሮን ኢስታ ናይቲ ሃይቆን ቃጻዬታናስ ቤሴና፤ ኢሶይ ኢሶይ ባ ሞሪዳ ሞሮዛ ጊሻስ ሃይቆን ቃጻዬቶ። ");
INSERT INTO gmve_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","ሃራ ቢታ ኣሳታሲኔ ዪኦ ናይታስ ፒርዳ ጌላሶፓ፤ ኣምኤይ ማይኦ ኢዛ ታልኤ ኤኪዳ ሚሻ ጊሻስ ጋዳ ኦይሶ ኤኮፋ። ");
INSERT INTO gmve_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","ካሴ ኢንቴ ጊብጼ ቢታን ኣይሌቴꬃን ዴኢዳይሳኔ ኢንቴ ጎዳ ጾሳይ ኢንቴና ዎዚ ኬሲዳይሳ ዩሺ ቆፒቴ፤ ታኒካ ሃይታ ሃ ኣዛዞታ ኢንቴስ ኢሚዛይ ሄሳሳ። ");
INSERT INTO gmve_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","ኔኒ ማጺዳ ካꬃ ሺሺን ባሌቲ ጉዬ ኣቲዳ ሚርቄይ ዲኮ ኢዛ ኤካናስ ጉዬ ሲሞፋ፤ ሄሳ ሃራ ቢታፌ ዪዳ ቤቴ ኣሳታስ፥ ዪኦታሲኔ ኣምኤታስ ሄን ኣጋጋ። ኔ ሄሳꬆ ኦꬂኮ ኔ ኦꬂዛ ኦሶ ኡባን ጎዳ ኔ ጾሳይ ኔና ኣንጃና። ");
INSERT INTO gmve_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","ኔኒ ዎጋራ ሚꬃ ኣይፌ ኢሲቶ ማጺዳፔ ጉዬ ጌዶን ኣቲዳይሳ ኤካናስ ናምኣንꬆ ጉዬ ሲሞፋ። ሄሳ ሃራ ቢታፌ ቤቴ ዪዳይታስ፥ ዪኦ ናይታሲኔ ኣምኤታስ ኣጋጋ። ");
INSERT INTO gmve_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","ኔኒ ዎይኔ ሚꬃ ኣይፌ ኢሲቶ ማጺዳፔ ጉዬ ጌዶን ኣቲዳይሳ ኤካናስ ናምኣንꬆ ጉዬ ሲሞፋ፤ ሄሳ ሃራ ቢታፌ ቤቴ ዪዳይታስ፥ ዪኦ ናይታሲኔ ኣምኤታስ ኣጋጋ። ");
INSERT INTO gmve_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","ኔካ ካሴ ጊብጼ ቢታን ኣይሌ ጊዲዳይሳ ባሎፓ፤ ታኒካ ሃይታ ሃ ኣዛዞታ ኢንቴስ ኢሚዛይ ሄሳሳ። ");
INSERT INTO gmve_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","ናምኡ ኣሳቲ ባ ጋርሳን ፓላሜቲዲ ፒርዳሶ ቢኮ ቆሄቲዳይሳ ኔ ጺሎ፤ ቆሂዳይሳ፥ «ኔ ዎርዶ» ጊዲ ፒርዲዛይቲ ፒርዴቶ። ");
INSERT INTO gmve_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","ቆሂዳይሲ ጋራፌቲ ቃጻዬታናስ ቤሲዛ ጊዲኮ ፒርዲዛይቲ ኢዚ ዛቁሊዲ ጋራፌታና ማላ ኣዛዜቶ፤ ሄሳፌ ጉዬ ሞራንቻይ ፒርዲዛይታ ሲንꬃን ባ ሞሮ ኬና ጋራፌቶ። ");
INSERT INTO gmve_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","ኢዚ ኦይዱ ታሙቶ ሾጬቶ ኣቲን ሄሳፌ ኣꬎ ሾጬታናስ ቤሴና፤ ሄሳፌ ቦላራ ጋራፌቲኮ ኔ ኢሻዚ ኔ ሲንꬃን ካዉያና። ");
INSERT INTO gmve_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","ካꬅ ቦራን ቡካሼ ቡኪዛ ቦራ ዶና ቃቾፋ። ");
INSERT INTO gmve_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","ኢሲፌ ዴኢዛ ኢሻንታፌ ኢሶይ ና ዬሎንታ ሃይቂኮ ኢዛ ማቻ ካሬ ባዳ ኣላጋ ኣስ ጌሉፑ፤ ኢዚ ኣዚና ኢሻይ ኢዞ ላቲዲ ኢዚስ ኮሺዛ ኡባ ኩንꬆ። ");
INSERT INTO gmve_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","ቃሴካ ኢስታፌ ዬሌቲዳ ኮይሮ ናይ ኢስራኤሌ ቢታን ሃይቂዳዴ ሱንꬃይ ꬋዮንታ ማላ ካሴ ሃይቂዳ ኢሻስ ና ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","ጊዶ ኣቲን ኢዚ ባ ኢሻ ማቼዮ ኣይሳናስ ኮዮንታ ኣጊኮ ኢዛ ካታማ ፔንጌን ኡቲዳ ጪማታኮ ባዳ፥ «ታ ኣዚና ኢሻይ ባ ኢሻ ሱንꬂ ኢስራኤሌን ዴኣና ማላ ኮዪቤና፤ ታና ኤኪኬ ጊዲ ታስ ኮሺዛ ሚሽ ኩንꬆንታ ኢጺዴስ» ጋዳ ማጋኑ። ");
INSERT INTO gmve_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","ሄሳፌ ጉዬ ሄ ካታማዮ ካሌꬂዛ ጪማቲ ኣዴዛ ባኮ ጼይጊዲ ኢዛ ኦይቼቶ። ኢዚ ሃኢካ ማጫሳዮ ኤኮንታ ኢጺኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","ሄ ሃይቂዳይሳ ማቼያ ሄ ካታማዮ ካሌꬂዛ ጪማታ ሲንꬂ ሺቃዳ ሄ ኣዴዛ ቶሆፔ ኢሲ ጫማ ሾዳዳ ኢዛ ኣይፌሶን ጩች ጩታዳ፥ «ባ ኢሻስ ዜሬꬂ ዴኣና ማላ ኮዮንታ ኣሳ ቦላ ሃይሳ ማላ ካዉሻቴꬂ ጋካናስ ቤሴስ» ጉ። ");
INSERT INTO gmve_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","ሄ ኣዴዛ ዛሬይ ኢስራኤሌ ኣሳ ጊዶን፥ «ኢዛ ቶሆፔ ጫማይ ሾዴቲዳዴ ሶ ኣሳታ» ጌቴቲ ካዉሻን ጼይጌቲሼ ዴኣና። ");
INSERT INTO gmve_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","ናምኡ ኣሳቲ ዋꬌቲሺን ኢስታፌ ኢሳ ማቼያ ያዳ ባ ኣዚና ኣሻናስ ባ ኩሼ ዬዳዳ ሃንኮይሳ ኣቱማቴꬃ ኦይኪኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","ሄ ማጫሳይ ኩሼይ ማሮይ ባይንዳ ቃንጼቶ። ");
INSERT INTO gmve_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","ኣስ ባሌꬃናስ ጊታኔ ጉꬅ ጊዲዳ ናምኡ ቆሞ ጌዳራ ሚሺ ኔ ማታን ዶፖ። ");
INSERT INTO gmve_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","ኣስ ባሌꬃናስ ኣዱሴኔ ቃንꬅ ጊዲዳ ናምኡ ቆሞ ዋꬋ ሚሺ ኔ ሶን ዶፖ። ");
INSERT INTO gmve_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","ጎዳ ኔ ጾሳይ ኔስ ኢማና ቢታይን ኔኒ ኣዱሳ ዎዴ ዴኣና ማላ ኣማንꬂዛኔ ሊኬ ጊዲዳ ጌዳራ ሚሺኔ ዋꬋ ሚሺ ኔስ ዶ። ");
INSERT INTO gmve_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","ጌዳራ ሚሻኒኔ ዋꬋ ሚሻን ዎርዶራ ኣስ ባሌꬂዛ ኣሳታ ኡባ ጎዳ ኔ ጾሳይ ኢጼስ። ");
INSERT INTO gmve_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","ኢንቴ ጊብጼ ቢታፌ ኬዚ ቢሺን ኣማሌቄ ኣሳይ ኢንቴ ቦላ ጋꬂዳ ቆሆዛ ባሎፒቴ። ");
INSERT INTO gmve_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","ኢስቲ ጾሳስ ያዮንታ ኣሳ፤ ኢንቴ ኦጌን ኢንቴናራ ኤቄቲዳ፤ ኢንቴ ሄሜቲሺን ዳቡርዲ ጉዬ ኣቲዳ ኣሳ ኡባ ዎꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","ሄሳ ጊሻስ ጎዳ ኢንቴ ጾሳይ ሄ ቢታዮ ኢንቴና ላቲሲዲ ኢንቴና ዩዪ ኣꬊዳ ኢንቴ ሞርኬታ ኡባፌ ሼምፒሲዛ ዎዴ ኣሲ ኢስታ ቢታ ቦላ ዛሪ ቆፖንታ ማላ ኣማሌቄ ኣሳ ዉርሳ ꬋይሳ፤ ሄሳ ሙሌካ ባሎፓ። ");
INSERT INTO gmve_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","ጎዳ ኔ ጾሳይ ኔና ላቲሳና ቢታዮ ኔ ጌላ ኡቲዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","ጎዳ ኔ ጾሳይ ኔስ ኢሚዛ ቢታን ሞኪዳ ካꬅ ኡባፌ ጼራ ኬሼራ ጎዳ ኔ ጾሳይ ባ ሱንꬂ ሄሳን ጼይጌታና ማላ ዶሪዳሶ ኤካ ባ። ");
INSERT INTO gmve_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","ሂስታዳ ሄ ዎዴን ኣዋቴꬃን ኦꬂዛ ቄሴዛኮ ባዳ፥ «ጎዳ ኔ ጾሳይ ኑስ ኢማና ጊዲ ካሴ ኑ ኣዋታስ ጫቂዳ ቢታዮ ታ ጌሊዳይሳ ኔ ጎዳ ሲንꬃን ሃች ማርካታይስ» ጋ። ");
INSERT INTO gmve_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","ቄሴዚካ ካꬃራ ዲዛ ኬሼዛ ኤኪዲ ጎዳ ኔ ጾሳስ ያርሾ ሺሺዛሶዛስ ሲንꬃ ባጋን ዎꬆ። ");
INSERT INTO gmve_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","ሄሳፌ ጉዬ ኔኒ ጎዳ ኔ ጾሳ ሲንꬃን፥ «ታ ኣዋይ ካሴ ጮ ዩዪ ዩዪ ዲዛ ኣራሜ ዴሬ ኣሳ፤ ኢዚ ቆዳን ጉꬃ ኣሳታራ ጊብጼ ዎꬊዲ ዴኢሼ ሄን ጊታ ዎልቃማኔ ቆዳን ጮራ ካዎቴꬅ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","ጊብጼ ኣሳይ ጊዲኮ ኑስ ሜቄꬅ ኢቲዲ ኑና ኡንኤꬂዳኔ ዴጾ ኦሶ ኑ ቦላ ጫኒዳ። ");
INSERT INTO gmve_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","ሂስቲን ኑኒ ጎዳ ኑ ኣዋታ ጾሳኮ ዋሲዶስ፤ ኢዚካ ኑ ዋሶዛ ሲዪዲ ኑ ዋዬዛ፥ ኑ ዳቡራዛኔ ኑኒ ቆሄቲዳይሳ ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","ሂስቲዲ ጎዳይ ባ ዎልቃማ ቄሴኒኔ ባ ሚጬቲዳ ኩሼን፥ ጊታ ዳጋማን፥ ማላታኒኔ ማላሊሲዛ ኦራꬃ ሚሽ ኦꬂዲ ጊብጼ ቢታፌ ኑና ኬሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","ኑና ሃ ሃይሳ ኤሂዲ ሃኖ ማꬂኔ ኤሲ ኢዚን ኩሚዳ ሞꬎ ቢታዮ ላቲሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","ሄሳ ጊሻስ ሄኮ ታኒካ ኢዚ ታስ ኢሚዳ ጋዴን ካጺዳ ካꬃፌ ጼራ ኢዛስ ኤካ ያዲስ» ጋዳ ኬሼዛ ዎꬃዳ ጎዳ ኔ ጾሳ ሲንꬃን ሆካ ጎይና። ");
INSERT INTO gmve_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","ኔሲኔ ኔ ሶ ኣሳስ ጎዳ ኔ ጾሳይ ኢሚዳ ሎኦ ሚሻን ኡፋዬቲዲ ጎዳ ጋላቲቴ፤ ሌዌቲኔ ኢንቴ ጊዶን ዴኢዛ ቤቴ ኣሳቲ ኡባይካ ኢንቴናራ ኡፋዬቴቶ። ");
INSERT INTO gmve_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","ኣስራታ ኬሲዛ ሄꬓንꬆ ላይꬃን ላይꬃን ሞኪዳ ካꬅ ኡባፌ ኣስራታ ኬሳ ዉርሲዳፔ ጉዬ ኔ ካታማን ዴኢዛ ሌዌታስ፥ ቤቴ ኣሳታስ፥ ዪኦታሲኔ ኣምኤታስ ኔ ካታማን ኢስቲ ካሊ ማና ማላ ኢማ። ");
INSERT INTO gmve_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","ሄሳፌ ጉዬ ጎዳ ኔ ጾሳ ሲንꬃን፥ «ኔ ኣዛዚዳ ማላ ታኒ ታሶፔ ኔስ ዱማቲዳይሳ ሌዌ ቆሞታስ፥ ቤቴ ኣሳታስ፥ ዪኦታሲኔ ኣምኤታስ ኢማዲስ፤ ታኒ ኔ ኣዛዞታፔ ኢሲኖካ ሜንꬃቤኬ፤ ቃሴ ኢሲኖካ ዶጋ ኣጋቤኬ። ");
INSERT INTO gmve_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","ኣሲ ሃይቂን ካዮታሼ ኢዛፔ ማቤኬ፤ ታኒ ጌዮንታ ዳሼ ኢዛፔ ኣይኮካ ማቤኬ፤ ሃይቂዳ ኣሳ ጊሻስ ሺቂዛ ያርሾስካ ኢዛፔ ኣይኮካ ሺሻቤኬ። ታኒ ጎዳ ታ ጾሳስ ኣዛዜታዲስ፤ ቃሴ ኔኒ ታና ኣዛዚዳ ኡባ ፖላዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","ኔኒ ሳሎን ዴኢዛ ጌሻ ሶሆፔ ሃ ዱጌ ጼላ፤ ኔ ዴሬ ኢስራኤሌኔ ካሴ ኑ ኣዋታስ ኔ ኢማና ጋዳ ጫቂዳ ማላ ኑስ ኢሚዳ ሃ ማꬂኔ ኤሲ ጎጊዛ ቢታዮ ኣንጃ» ጋ። ");
INSERT INTO gmve_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","ጎዳ ኔ ጾሳ ዎጋታኔ ማራታ ኔ ናጋና ማላ ሄኮ ሃች ኔና ኣዛዚዴስ፤ ሄሳ ጊሻስ ኔኒ ኩሜꬃ ሼምፖፌኔ ኩሜꬃ ዎዚናፔ ናጋ። ");
INSERT INTO gmve_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","ጎዳይ ኔስ ጾሳ ጊዲዳይሳ ኔ ኢዛ ኦጌን ባናይሳ፥ ኢዛ ዎጋ፥ ኢዛ ኣዛዞታኔ ኢዛ ማራ ኔኒ ፖላናይሳ ሃች ኤሪሳዳሳ። ");
INSERT INTO gmve_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","ቃሴ ጎዳይካ ባ ጌሊዳ ቃላ ማላ ኔኒ ኢዛስ ዱማ ኣስ ጊዲዳይሳ፥ ኢዛስ ጺንጾ ጊዲዳይሳኔ ኔኒ ኢዛ ኣዛዞ ኡባ ናጋናይሳ ኤሪሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","ኔኒ ሄሳ ኦꬂኮ ኢዚ ሜꬊዳ ኣሳ ኡባፌ ቦላራ ጋላታን፥ ሱንꬃኒኔ ቦንቾን ጊታ ካዎቴꬅ ኦꬃና፤ ኢዚ ጌሊዳ ጫቆ ቃላ ማላ ኢዛስ ዱማ ዴሬ ኦꬃናይሳ ኔስ ኤሪሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","ሄሳፌ ጉዬ ሙሴይ ኢስራኤሌ ኣሳ ካሌꬂዛይታራ ዴሬዛስ፥ «ታኒ ኢንቴስ ሃች ኢሚዛ ኣዛዞታ ኡባ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","ኢንቴ ዮርዳኖሴ ሻፋ ፒኒዲ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዛ ቢታዮ ጌሊዛ ዎዴ ኣማርዳ ጊታ ሹቻታ ኤሲዲ ኢስታ ኖራ ቲዪቴ። ");
INSERT INTO gmve_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","ካሴ ጎዳ ኢንቴ ኣዋታ ጾሳይ ኤሲኔ ማꬂ ኩሚዳ ቢታዮ ኢንቴስ ኢማናስ ጫቂዳ ቃላ ማላ ሄ ቢታዮ ኦይካናስ ኢንቴ ፒኒዳ ዎዴ ሃ ዎጋ ቃላታ ሎቻ ሹቻታ ቦላ ጻፍቴ። ");
INSERT INTO gmve_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","ኢንቴ ዮርዳኖሴ ሻፋ ፒኒዲ ታ ኢንቴና ሃች ኣዛዚዳ ማላ ሄ ሹቻታ ኤባሌ ዙማ ቦላ ኤሲዲ ኢስታ ቦላ ኖራ ቲዪቴ። ");
INSERT INTO gmve_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","ሄን ጎዳ ኢንቴ ጾሳስ ቢራታይ ቦቾንታ ሹቻታ ኤኪዲ ያርሾ ያርሺዛሶ ጊግሲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","ጎዳ ኢንቴ ጾሳስ ያርሾ ያርሺዛሶ ማሴቶንታ ሹቻፌ ኦꬂዲ ኢዛ ቦላን ጎዳ ኢንቴ ጾሳስ ጹጌቲ ሺቂዛ ያርሾ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","ኢሲፌቴꬃ ያርሾ ሺሺዲ ሄን ጎዳ ኢንቴ ጾሳ ሲንꬃን ኡፋዬቲሼ ሚቴ። ");
INSERT INTO gmve_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","ሄ ሹቻታ ቦላ ጾሳ ዎጋታ ኡባ ናባቤታና ማላ ቆንጪሲ ጻፍቴ» ጊ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","ሙሴይካ ሌዌ ቆሞታፔ ቄሴታራ ጊዲዲ ኢስራኤሌ ኣሳ ኡባስ፥ «ኢስራኤሌ ኣሳዉ ታኒ ጊዛይሳ ዎዚናን ዎꬃ ሲያ፤ ሄኮ ሃች ኔኒ ጎዳ ኔ ጾሳ ዴሬ ጊዳዳሳ። ");
INSERT INTO gmve_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","ሄሳ ጊሻስ ታኒ ኔስ ሃች ኢሚዛ ኣዛዞታኔ ዎጋታ ኔ ዉርሳ ናጋዳ ጎዳ ኔ ጾሳ ቃላስ ኣዛዜታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","ሄ ጋላስ ሙሴይ ኢስራኤሌ ዴራ ሂዝጊ ኣዛዚዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","«ኢንቴ ዮርዳኖሴ ፒኒዳፔ ጉዬ ዴሬዛ ኣንጃናስ ጋሪዛኔ ዙማ ቦላ ኤቃናስ ቤሲዛይቲ ሲሞና፥ ሌዌ፥ ዩሁዳ፥ ዪሳኮሬ፥ ዮሴፌ ቆሞታኔ ቢኒያሜ ቆሞታ። ");
INSERT INTO gmve_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","ዴሬዛ ቃንጋናስ ኤባሌ ዙማ ቦላ ኤቃናስ ቤሲዛይቲ ኦሮቤሌ፥ ጋዴ፥ ኣሴሬ፥ ዛቢሎኔ፥ ዳኔ ቆሞታኔ ኒፍታሌሜ ቆሞታ።» ");
INSERT INTO gmve_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","ሌዌ ቆሞቲ ባ ቃላ ꬎቁ ሂስቲዲ ሃይሳፌ ካሊዛ ቃላ ኢስራኤሌ ኣሳ ኡባስ ጌቶ። ");
INSERT INTO gmve_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","«ጎዳይ ኤቃ ጾሳታስ ጎይኖ ኢጺዛ ጊሻስ፥ ሚꬃፌ ማሲዲ ሹቻፌ ቆጺዲኔ ቢራታ ሴሪሲዲ ኤቃ ጾስ ጊግሲዲ ጌማን ጎይኒዛዴይ ኦኒካ ቃንጌቲዳዴ ጊዶ!» ዴሬዚ ዉሪካ፥ «ኣሚን!» ጎ። ");
INSERT INTO gmve_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","«ባ ኣዋ ዎይኮ ባ ኣዮ ካዉሺዛዴይ ቃንጌቲዳዴ ጊዶ!» ዴሬዚ ዉሪካ፥ «ኣሚን!» ጎ። ");
INSERT INTO gmve_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","«ꬋስ ሾዲዛዴይ ዉሪ ቃንጌቲዳዴ ጊዶ!» ዴሬዚ ዉሪካ፥ «ኣሚን!» ጎ። ");
INSERT INTO gmve_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","«ቆቄ ኣስ ሃዲርሳ ኦጌ ካሌꬂዛ ኡባይ ቃንጌቲዳዴ ጊዶ!» ዴሬዚ ዉሪካ፥ «ኣሚን!» ጎ። ");
INSERT INTO gmve_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","«ቤቴ ኣሳታ፥ ዪኦ ናይታኔ ኣምኤታ ፒርዳ ጌላሲ ፒርዲዛ ኡባይ ቃንጌቲዳዴ ጊዶ!» ዴሬዚ ዉሪካ፥ «ኣሚን!» ጎ። ");
INSERT INTO gmve_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","«ባ ኣዋ ማቺራ ዚንኢዲ ባ ኣዋ ቦንቾ ካዉሺዛ ኡባይ ቃንጌቲዳዴ ጊዶ!» ዴሬዚ ዉሪካ፥ «ኣሚን!» ጎ። ");
INSERT INTO gmve_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","«ኣይ ሜሄራካ ፓራቲዛዴይ ቃንጌቲዳዴ ጊዶ!» ዴሬዚ ዉሪካ፥ «ኣሚን!» ጎ። ");
INSERT INTO gmve_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","«ባ ሚቼይራ ዎይኮ ባ ኣዪ ናይራ ዎይኮ ባ ኣዋ ናይራ ዚንኢዛ ኡባይ ቃንጌቲዳዴ ጊዶ!» ዴሬዚ ዉሪካ፥ «ኣሚን» ጎ። ");
INSERT INTO gmve_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","«ባ ቦሎቴይራ ዚንኢዛ ኡባይ ቃንጌቲዳዴ ጊዶ!» ዴሬዚ ዉሪካ፥ «ኣሚን» ጎ። ");
INSERT INTO gmve_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","«ጌማሶን ዛማዲ ኡቲዲ ኣሴ ዎꬊዛ ኡባይ ቃንጌቲዳዴ ጊዶ!» ዴሬዚ ዉሪካ፥ «ኣሚን!» ጎ። ");
INSERT INTO gmve_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","«ሚሻን ሻሜቲዲ ጺሎ ሼምፖ ዎꬊዛ ኡባይ ቃንጌቲዳዴ ጊዶ!» ዴሬዚ ዉሪካ፥ «ኣሚን!» ጎ። ");
INSERT INTO gmve_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","«ሃይታ ሃ ዎጋ ቃላታ ናጎንታ ኡባይ ቃንጌቲዳዴ ጊዶ!» ዴሬዚ ዉሪካ፥ «ኣሚን!» ጎ። ");
INSERT INTO gmve_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","ኔኒ ጎዳ ኔ ጾሳስ ኣዛዜቲኮ ሃች ታ ኔስ ኢሚዛ ኣዛዞታ ኔ ኡባ ኣማኔታዳ ናጊኮ ኢዚ ኔና ቢታ ቦላ ዲዛ ካዎቴꬃታ ኡባፌ ቦላራ ꬎቁ ꬎቁ ሂስታና። ");
INSERT INTO gmve_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","ኔኒ ጎዳ ኔ ጾሳስ ኣዛዜቲኮ ሃይሳፌ ካሊዛ ኣንጆቲ ዉሪካ ኔይታ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","ኔኒ ካታማኒኔ ጋጻሬን ኣንጄቲዳ ኣስ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","ኔ ናይቲ፥ ኔ ቢታን ዲዛ ካꬃ ኣይፌይ፥ ኔ ሚዛቲ፥ ዶርሳቲኔ ዴይሻቲ ኡባይ ኣንጄታና። ");
INSERT INTO gmve_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","ኔ ካꬃ ጎታራይኔ ማዳይ ኣንጄታና። ");
INSERT INTO gmve_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","ኔኒ ጌላዳካ ኬዛዳካ ኣንጄታና። ");
INSERT INTO gmve_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","ኔ ሞርኬቲ ኔ ቦላ ሜቶ ጋꬂዛ ዎዴ ጎዳይ ኢስታ ኔ ሲንꬃን ኩንዲሳና፤ ኢስቲ ኔ ቦላ ኢሲ ባጋራ ያና፤ ጊዶ ኣቲን ላፑን ኦጌራ ኔፔ ባቃታና። ");
INSERT INTO gmve_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","ጎዳይ ኔ ኩሼይ ኦይኪዳ ኡባኔ ኔ ጎታራ ኡባ ኣንጃና፤ ቃሴ ኢዚ ኔስ ኢሚዳ ቢታንካ ኔና ኣንጃና። ");
INSERT INTO gmve_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","ኔኒ ጎዳ ኔ ጾሳስ ኣዛዜቲኮኔ ኔ ኢዛ ኣዛዞታ ኡባ ፖሊኮ ኢዚ ኔስ ጫቂዳ ቃላ ማላ ኢዚ ኔና ባስ ዱማ ሻኬቲዳ ዴሬ ሂስታና። ");
INSERT INTO gmve_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","ሄሳፌ ጉዬ ቢታ ቦላ ዲዛ ዴሬይ ዉሪካ ጎዳ ሱንꬂ ኔናን ጼይጌቲዛይሳ ቤኢዲ ኔስ ያያና። ");
INSERT INTO gmve_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","ጎዳይ ኔስ ኢማናስ ካሴ ኔ ኣዋታስ ጫቂዳ ቢታ ቦላ ኔስ ዳሮ ናይታ፥ ዳሮ ሜሄኔ ኬሂ ዳሮ ካꬅ ኢማና። ");
INSERT INTO gmve_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","ኔ ኩሼ ኦሶ ኡባ ኣንጃናሲኔ ጎዳይ ኔ ቢታስ ኢራ ዎዴራ ቡኪሳናስ ባ ሚንጃ ኬꬃ፥ ሳሎ ፔንጌ ኔስ ዶያና፤ ቃሴ ኔኒ ዳሮ ካዎቴꬃታስ ታልኣናፔ ኣቲን ኦፔካ ሃ ታልኤ ኤካካ። ");
INSERT INTO gmve_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","ጎዳይ ኔና ሁኤ ሂስታናፔ ኣቲን ጎይና ሂስቴና፤ ሃች ታኒ ኔስ ኢሚዛ ኔ ጎዳ ኣዛዞ ሲያዳ ሄሳ ኔኒ ሚንꬃዳ ካሊኮ ኔኒ ኡባፌ ቦላ ጊዳናፔ ኣቲን ጋርሴ ጊዳካ። ");
INSERT INTO gmve_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","ታኒ ኔስ ሃች ኢሚዳ ሃ ኣዛዞታፔ ካሬ ኬዛዳ ኤቃ ጾሳታስ ጎይናናሲኔ ኢስታስ ኦꬃናስ ቤሴና። ");
INSERT INTO gmve_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","ቃሴ ኔኒ ጎዳ ኔ ጾሳስ ኣዛዜቶንታ ኢጺኮ፥ ታኒ ኔስ ኢሚዛ ዎጋታኔ ኣዛዞታ ኔ ኣማኔታዳ ናጎንታ ኢጺኮ ሃይሳፌ ካሊዛ ቃንጌꬃቲ ኔ ቦላ ጋካናኔ ኔና ኤኪ ባና። ");
INSERT INTO gmve_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","ኔኒ ካታማኒኔ ጋጻሬን ቃንጌቲዳዴ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","ኔ ካꬃ ጎታራይኔ ማዳይ ቃንጌቲዳዝ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","ኔ ናይቲ፥ ኔ ቢታን ዲዛ ካꬃ ኣይፌይ፥ ኔ ሚዛቲ፥ ዶርሳቲኔ ዴይሻቲ ኡባይ ቃንጌቲዳዝ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","ኔኒ ጌላዳካ ኬዛዳካ ቃንጌቲዳዴ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","ኔኒ ኢታ ኦሶን ጎዳ ኣጊዳ ጊሻስ ኔ ኦꬂዛ ኦሶን ኡባን ኔ ሙሌራ ꬋያና ጋካናስ ቃንጌꬅ፥ ሂርጋኔ ካዉሻቴꬅ ጎዳይ ኔ ቦላ ኤሃና። ");
INSERT INTO gmve_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","ኔኒ ላታናስ ጌላና ቢታይፌ ኔና ሙሌራ ꬋይሳና ጋካናስ ኔፔ ኪቾንታ ኢታ ሃርጌ ጎዳይ ኔ ቦላ ዬዳና። ");
INSERT INTO gmve_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","ጎዳይ ኔና ጊልቃቴꬃን፥ ሚሾኒኔ ቆጾን፥ ማዱንꬃን፥ ጹጊዛ ኣዋኒኔ ኮሻን ꬋይሳና፤ ኔ ካꬃ ꬋይሳናስ ኩቱልኤኔ ሎቤ ኔ ቦላ ዬዳና። ");
INSERT INTO gmve_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","ኔፔ ቦላራ ኔ ጊናን ዴኢዛ ሳሎይ ጻርቂማላ ጊዳና፤ ኔ ቢታይካ ቢራታ ማላ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","ጎዳይ ኔ ቢታን ቡኪዛ ኢራ ቡሄኔ ጉዱላ ኬሳና፤ ኔኒ ቢታፌ ꬋያና ጋካናስ ጉዱላይ ሳሎፔ ዱጌ ቡካና። ");
INSERT INTO gmve_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","ጎዳይ ኔ ሞርኬታ ሲንꬃን ኔኒ ጾኔታና ማላ ኦꬃና፤ ኔኒ ኢስታ ቦላ ኢሲ ኦጌራ ባናሺን ኢስታፌ ኣታናስ ላፑናሶራ ባቃታና፤ ቢታ ቦላ ዲዛ ካዎቴꬃቲ ኡባይ ኔ ቦላ ጋኪዛይሳ ቤኢዲ ሂርጋን ኮኮራና። ");
INSERT INTO gmve_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","ኔ ኣሃይ ሳሎ ካፎታሲኔ ባዞ ዶኣታስ ቁማ ጊዳና፤ ኢስታ ጎዳና ኣሲካ ዴና። ");
INSERT INTO gmve_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","ጎዳይ ኔና ፓጾንታ ጊብጼ ዴሬ ሃርጌን፥ ኪጻን፥ ጊዪዛ ማዱንꬃኒኔ ፑሶ ሃርጌን ሾጫና። ");
INSERT INTO gmve_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","ጎዳይ ኔና ጎሻን፥ ቆቄቴꬃኒኔ ዳጋማን ዬጋና። ");
INSERT INTO gmve_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","ጋላሳ ሴታን ኔኒ ቆቄይ ታታፌቲዛ ማላ ታታፌታና፤ ኔ ኦꬂዛ ኡባይ ኔስ ጊጎንታ ኢጻና፤ ኔኒ ኔ ዴኦ ኡባን ኡንኤታሼኔ ቦንቄታሼ ዳና፤ ኔና ማዲዛ ኣሴካ ዴማካ። ");
INSERT INTO gmve_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","ኔኒ ማቾ ኤካናስ ጌላኦ ጊጊሳና፤ ጊዶ ኣቲን ሃራ ኣሲ ኢዞ ዳፊ ኤካና፤ ኔ ኬꬅ ኬጻናሺን ኢዛን ዳካ፤ ኔኒ ዎይኔ ሚꬅ ቶካናሺን ኢዛ ኣይፌ ጎኤታካ። ");
INSERT INTO gmve_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","ኔ ኣይፌይ ጼሊሺን ኔ ሜሄ ሃራ ኣሲ ሹካና፤ ጊዶ ኣቲን ሄ ኣሾዛፔ ኣይኮካ ማካ፤ ኔ ሃሬይ ኔፔ ቦንቄቲ ኤኬታና፤ ጊዶ ኣቲን ኔስ ጉዬ ሲሜና፤ ኔ ዶርሳቲ ኔ ሞርኬስ ኢሜታና፤ ሄሳፌ ኣሻናስ ኔና ማዳናይ ዴና። ");
INSERT INTO gmve_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","ኔ ኣይፌ ሲንꬃን ኔ ኣቱማ ናይቲኔ ማጫ ናይቲ ሃራ ካዎቴꬃስ ኢሜታና፤ ኢስቲ ሲሚን ቤኣና ጋዳ ኔ ጼሊሺን ኔ ኣይፌይ ዶልጁማና፤ ሄሳ ዲጋናስ ኔስ ኣይ ዎልቃይካ ዴና። ");
INSERT INTO gmve_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","ኔ ቢታ ካꬃ ኣይፌኔ ኔ ዳቡራ ኬሲዳ ኡባ ሃራ ዴሬ ኣሲ ማና፤ ኔኒ ኔ ዴኦ ኡባን ኡንኤቲዳዴኔ ቆሄቲዳዴ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","ኔኒ ኣይፌን ቤኢዛ ኡባይ ኔና ጎሻና። ");
INSERT INTO gmve_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","ጎዳይ ኔስ ቶሆ ጹጉንꬃፌ ቢዲ ሁኤ ቢናና ጋካናስ ሚዛ ፓጾንታ ኢታ ማዱንꬃኒኔ ኪጻን ኔ ሱሌኔ ኔ ዎዲራ ሾጫና። ");
INSERT INTO gmve_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","ጎዳይ ኔናኔ ኔኒ ኔ ቦላ ካዎሳና ካዎዛ ሃ ቢታፌ ዴንꬂዲ ካሴ ኔኒኔ ኔ ኣዋቲ ኤሮንታ ሃራ ካዎቴꬅ ኤፋና፤ ኢንቴ ሄን ሚꬃፌኔ ሹቻፌ ኦሴቲዳ ኤቃ ጾሳታስ ጎይናና። ");
INSERT INTO gmve_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","ጎዳይ ኔኒ ላሌታ ቢዛ ካዎቴꬃታ ኡባ ጊዶን ኔና ቂልጫስ፥ ሚቻሲኔ ካꬌስ ኬሳና። ");
INSERT INTO gmve_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","ኔ ጋዴን ኔ ዳሮ ካꬅ ዜራና ሺን ቦሌይ ሚሺን ኣቲዳ ጉꬃ ካꬅ ሺሻና። ");
INSERT INTO gmve_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","ኔኒ ዎይኔ ሚꬅ ቶካናሺን ኢዛ ኣይፌዛ ጎኤታካ፤ ጋሶይካ ጉጹኔይ ኢዛ ማና። ");
INSERT INTO gmve_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","ኔ ዴሬን ኣዋንካ ዎጋራ ሚꬂ ሞካናሺን ዎዴይ ጋኮንታ ዲሺን ኣይፌ ቆቆፋና፤ ሄሳ ጊሻስ ዎጋራ ዛይቴይ ኔስ ዴና። ");
INSERT INTO gmve_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","ኔኒ ማጫ ናይታኔ ኣቱማ ናይታ ዬላናሺን ኢስቲ ኦላን ዲኤቲ ቢኮ ኔ ሜላ ኣታና። ");
INSERT INTO gmve_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","ኔ ጋዴን ዲዛ ሚꬃኔ ካꬃ ኡባ ቦሌይ ማና። ");
INSERT INTO gmve_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","ኔ ዎልቃይ ዳቡሪ ዳቡሪ ቢሺን ኔ ዴሬን ዲዛ ቤቴ ኣሳ ዎልቃይ ሚኒ ሚኒ ባና። ");
INSERT INTO gmve_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","ኔ ዴሬን ዲዛ ቤቴ ኣሳይ ኔስ ታልኤ ኢማና ኣቲን ኔ ኢስታስ ታልኣካ፤ ኢስቲ ኔስ ሁኤ ጊዳና፤ ኔኒ ጊዲኮ ኢስታስ ጎይና ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","ኔኒ ጎዳ ኔ ጾሳስ ኣዛዜቶንታ ኢጺዳ ጊሻሲኔ ኢዚ ኔስ ኢሚዳ ዎጋታኔ ኣዛዞታ ኔኒ ናጎንታ ኢጺዳ ጊሻስ ኔኒ ሙሌራ ꬋያና ጋካናስ ሃይቲ ሃ ቃንጌꬃቲ ኡባይ ኔ ቦላ ጋካና። ");
INSERT INTO gmve_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","ሃ ቃንጌꬃቲ ኡባይ ጾሲ ኔ ቦላኔ ኔ ዜሬꬃታ ቦላ ቂጻቴስ ዬጊዳ ሜርናስ ማላታኔ ማላሊሲዛዝ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","ጎዳ ኔ ጾሳይ ኔና ዳሮ ባጋራ ኣንጂዴስ፤ ጊዶ ኣቲን ኔ ጋላታሼ ኡፋይሳን ኢዛስ ኦꬃቤካ። ");
INSERT INTO gmve_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","ሄሳ ጊሻስ ኔኒ ጋፋን፥ ሳሞን፥ ካሎቴꬃኒኔ ሜቶ ኡባን ጎዳይ ኔ ቦላ ዬዲዛ ኔ ሞርኬታስ ኔ ሃሬታና፤ ጎዳይ ኔና ꬋይሳና ጋካናስ ኔ ሞርጌን ቢራታ ቃምባራ ዋጻና። ");
INSERT INTO gmve_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","ጎዳይ ኔ ኢስታ ቃላ ኤሮንታ ካዎቴꬅ ሃኮ ዴሬፔ ኔ ቦላ ኤሃና፤ ኢስቲካ ጎሌ ካፎ ማላ ኔ ቦላ ዎꬋና። ");
INSERT INTO gmve_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","ኢስቲ ሜንጼ ኢታታ፥ ጪሚዳ ኣሳ ቦንቾንታይታኔ ጉꬃ ናይታስ ሚሼቶንታይታ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","ኢስቲ ኔ ሜሄኔ ኔ ካꬅ ኡባ ፒቲ ሚዛይታ ጊዲዳ ጊሻስ ኔኒ ሃይቃና ጋካናስ ኮሻን ዋያና፤ ኢስቲ ኔ ꬋያና ጋካናስ ኔ ካꬃፌ ኢሲ ኣይፌ፥ ኔ ሜሄፔ ጉꬃ ማሪ፥ ኔ ዶርሳፌ ጉꬃ ላቃ፥ ዎይኔፔኔ ዎጋራ ሚꬃ ኣይፌፔ ቂ ፓላካ ኣሼቴና። ");
INSERT INTO gmve_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","ኔ ቢታን ዴኢዛ ኔኒ ኢስታን ኣማኔቲዛ ኣዱሳኔ ሚኖ ዲርሳቲ ኡባሶራ ላሌታና ጋካናስ ኔ ካታማታ ኡባ ዩሾን ዶዲዲ ኔና ኡንኤꬃና። ጎዳ ኔ ጾሳይ ኔስ ኢሚዳ ቢታ ኡባ ዩሾን ዶዲ ኔ ሚጻታ ዲፒ ሂስቲ ꬋይሳና። ");
INSERT INTO gmve_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","ኔ ሞርኬቲ ኔ ካታማታ ዶዲዲ ኔና ኡንኤꬂን ኔስ ሚዛዚ ꬋዪን ኔ ሜቶቲዛ ዎዴ ጎዳ ኔ ጾሳይ ኔስ ኢሚዳ ኔ ኡሎፔ ዬሌቲዳ ማጫ ናይታኔ ኣቱማ ናይታ ኣሾ ዶሳይ ባይንዳ ኔ ማና። ");
INSERT INTO gmve_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","ኔ ጊዶን ሃራይ ኣቶ ካሴ ኪያኔ ኢንጄ ዱሲ ዴስ ጌቴቲዛ ኣሲካ ባ ኢሻስ፥ ባ ሲቂዛ ማቼይሲኔ ባ ዬሊዳ ናይታስ ቃꬌቴና። ");
INSERT INTO gmve_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","ጉዬን ካታማ ዶዲዲ ኡንኤꬂዳ ጋሶን ማና ሚሺ ሃራይ ባይንዳ ጊሻስ ባ ሚዛ ባ ናይታ ኣሾፔ ሃራስ ኦናስካ ኢሜና። ");
INSERT INTO gmve_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","ኔ ጊዶን ካሴ ኢንጄን ዴኣዉስ ጌቴቲዳራ ባ ኢንጄ ዱሳፌ ዴንዶይሳን ሳኣ ዬꬋናስ ሻቴቲዛ ማጫሳያካ ባ ሲቂዛ ኣዚናሲኔ ባ ናይታስ ቃꬌቱኩ። ");
INSERT INTO gmve_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","ሞርኬይ ኢዛ ዴኢዛ ካታማ ዶዲዲ ኢዞ ኡንኤꬂዳ ጊሻሲኔ ቱጋሲዳ ጊሻስ ኢዚስ ሚዛ ሚሺ ሃራይ ኣይኮይካ ዴና፤ ሄሳ ጊሻስ ኢዛ ባ ዬሊዳ ዪꬋኔ ዶኣ ባ ሲቂዛ ኣዚናኔ ባ ናይታ ጋꬆንታ ኡዜታዳ ጌማን ባርካ ማና። ");
INSERT INTO gmve_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","ሃይሳ ሃ ማጻፋን ጻፌቲዳ ጾሳ ዎጋ ኢንቴ ሎኤꬂ ናጎንታ ኣጊኮ ቃሴ ማላሊሲዛኔ ያሺሲዛ ጎዳ ኢንቴ ጾሳ ሱንꬃ ኢንቴ ቦንቾንታ ኣጊኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","ጎዳይ ኢንቴ ቦላኔ ኢንቴ ናይታ ቦላ ባቢሲዛ ቦሻ፥ ሲሞንታ ባሺኔ ፓጾንታ ዴጾ ሃርጌ ዬጋና። ");
INSERT INTO gmve_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","ኔኒ ጊብጼ ቢታ ቦላ ዎꬊን ቤያዳ ሂርጊዳ ሄ ኢታ ሃርጌዛ ኡባ ኢዚ ኔ ቦላ ዬዳና፤ ኔካ ሄ ሃርጌዛፔ ፓጻካ። ");
INSERT INTO gmve_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","ጎዳ ዎጋቲ ጻፌቲዳ ሃ ማጻፋን ጻፌቶንታ ሃራ ቦሻታ ኢንቴና ኡባ ዉርሳና ጋካናስ ኢንቴ ቦላ ዬዳና። ");
INSERT INTO gmve_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","ጎዳ ኢንቴ ጾሳስ ኢንቴ ኣዛዜቶንታ ኢጺዳ ጊሻስ ሳሎ ጾሊንቴ ማላ ዳሪዳ ኢንቴፌ ጉꬃቲ ጻላ ኣታና። ");
INSERT INTO gmve_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","ጎዳይ ኢንቴና ዱሬሳናሲኔ ኢንቴ ቆዳ ዳርሳናስ ዶሲዳ ማላ ቃሴካ ኢንቴና ጉꬂሼኔ ቢታፌ ꬋይሲሼ ኢዚ ኡፋዬታና፤ ኢንቴካ ላታናስ ቢዛ ቢታይፌ ሾዴታና። ");
INSERT INTO gmve_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","ጎዳይ ኔና ኩሜꬃ ኣላሜን ዲዛ ኣሳ ጊዶን ቢታስ ጋጻፔ ጋጻ ጋካናስ ላላና፤ ሄን ኔኒኔ ኔ ኣዋቲ ካሴ ጎይኒ ኤሮንታ ሚꬃፌኔ ሹቻፌ ኦሴቲዳ ኤቃ ጾሳታስ ኢንቴ ጎይናና። ");
INSERT INTO gmve_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","ሄ ካዎቴꬃታ ጊዶን ኢንቴ ዎፓ ዴሜኬታ፤ ኢንቴ ቶሆ ጫማይ ዬꬊዛ ሶሆ ኬና ጋዴይካ ኢንቴስ ዴና፤ ሄሳን ጎዳይ ኢንቴስ ሜቶ ቆፋን ጻላ ኩሚዳ ሁኤ፥ ኣሞን ጻላ ዳቡርዳ ኣይፌኔ ሂዶታ ቃንጺዛ ዎዚና ኢማና። ");
INSERT INTO gmve_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","ኢንቴስ ዱሳይ ኡባ ዎዴ ዋዬ ጻላ ጊዳና፤ ዱሳይ ኣማንꬆንታ ጊሻስ ኢንቴ ቃማኔ ጋላስ ሂርጊሼ ዳና። ");
INSERT INTO gmve_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","ኢንቴ ዎዚናን ኩሚዳ ሂርጋፌኔ ኢንቴ ኣይፌን ቤኢዛ ፓላፔ ዴንዲዳይሳን ጋዴይ ዎንቲሺን ኢንቴ፥ «ኣይዴ ቃማኔሻ!» ቃሴ ጋዴይ ቃሚሺን፥ «ኣይዴ ዎንታኔሻ!» ጋና። ");
INSERT INTO gmve_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","ታኒ ኢንቴና፥ «ናምኣንꬆ ሃ ኦጌዛራ ቤኬታ» ጊዳ ኦጌዛራ ጎዳይ ኢንቴና ዛሪዲ ማርካቤን ጉዬ ጊብጼ ዬዳና። ሄን ኢንቴ ኣይሌ ጊዳናስ ኢንቴ ሞርኬታስ ኢንቴና ባይዛናስ ኮያና፤ ጊዶ ኣቲን ኢንቴና ኣይሌሳናስ ሻሚዛ ኣስ ዴሜኬታ። ");
INSERT INTO gmve_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","ጎዳይ ኮሬቤን ኢስራኤሌ ኣሳራ ጫቄቲዳ ጫቆ ቃላፔ ሃራ ሞኣቤ ዴሬን ናምኣንꬆ ጫቄታናስ ሙሴ ኣዛዚዳ ጫቆ ቃላቲ ሃይሳፌ ካሊዛይታ። ");
INSERT INTO gmve_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","ሙሴይ ኢስራኤሌ ኣሳ ኡባ ጼይጊዲ፥ ጎዳይ ጊብጼ ካዎ ቦላ፥ ኢዛ ሹሜታ ቦላኔ ኡባ ዴራ ቦላ ኢዚ ኦꬂዳይሳ፥ ");
INSERT INTO gmve_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","ሄ ኢታ ሜቶታ፥ ጊታ ማላታታኔ ማላሊሲዛ ሚሻታ ኢንቴ ኢንቴ ኣይፌራ ቤኢዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","ጊዶ ኣቲን ሃች ጋካናስ ጎዳይ ኢንቴስ ኣኬኪዛ ዎዚና፥ ጼሊዛ ኣይፌኔ ሲዪዛ ሃይꬅ ኢሚቤና። ");
INSERT INTO gmve_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","ታኒ ኢንቴና ኦይዱ ታሙ ላይꬅ ኩሜꬅ ባዞን ካሌꬂሺን ኢንቴ ማይኦይ ጬጊቤና፤ ኢንቴ ቶሆን ኣꬂዳ ጫማይካ ዉሪቤና። ");
INSERT INTO gmve_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","ኢንቴ ኡኬꬅ ሚቤኬታ፤ ዎይኔ ኡሹ ጊዲን ዎይኮ ማꬆሲዛ ኡሹ ኡዪቤኬታ። ታኒ ሄሳꬆ ኦꬂዳይ ታኒ ጎዳ ኢንቴ ጾሳይ ኢንቴ ጾሳ ጊዲዳይሳ ኢንቴ ኤራናሳ። ");
INSERT INTO gmve_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","ኢንቴ ሃይሳ ሃ ጋኪዳ ማላ ሃሴቦኔ ካዎ ሲሆኔይኔ ባሳኔ ካዎ ኣጌይ ኑና ኦላናስ ዪን ኑኒ ኢስታ ጾኒዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","ኑኒ ኢስታ ቢታ ኑስ ኤኪዶስ፤ ኦሮቤሌ ቆሞታስ ጋዴ ቆሞታሲኔ ሚናሴ ቆሞታፔ ባጋይታስ ሻኪ ሻኪ ኢስታስ ጺንጾ ጊዳና ማላ ኢሚዶስ። ");
INSERT INTO gmve_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","ሄሳ ጊሻስ ኢንቴ ኦꬂዛ ኦሶ ኡባይ ኢንቴስ ኣንጄታና ማላ ሃይታ ጫቆ ቃላታ ኡባ ሚኒ ካሊቴ። ");
INSERT INTO gmve_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","10","ኢንቴ ኡባቲ፥ ኢንቴና ካሌꬂዛይቲኔ ኢንቴ ሃላቃቲ፥ ኢንቴ ጪማቲኔ ኢንቴ ሹሜቲ፥ ሄሳꬆካ ሃንኮ ኢስራኤሌ ኣሳይ ኡባይካ ኢንቴ ሃች ጎዳ ኢንቴ ጾሳ ሱንꬃን ኤቂዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT29_11","006_29_11","DEU","29","11","11","ኢንቴ ናይቲኔ ኢንቴ ማቼቲ ኢንቴስ ሚꬅ ቃንጺሼኔ ሃꬄ ዱቂሼ ኢንቴናራ ዲዛ ቤቴ ኣሳታራ ኢሲፌ ኤቂዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","ጎዳ ኢንቴ ጾሳራ ኢንቴ ጫቄቲዳ ቃላዛ ሚንꬃናስ ሃች ሃይሳን ሺቂዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","ጾሲ ኢንቴና ሃች ባ ዴሬ ሂስቲ ሚንꬃና፤ ኢንቴሲኔ ቤኒ ኢንቴ ኣዋታስ፥ ኣብራሃሜስ፥ ዪሳቃሲኔ ያቆቤስ ጌሊዳ ጫቆ ቃላ ማላ ኢዚ ኢንቴስ ጾስ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","ታኒ ሃይሳ ጫቆ ቃላ ጌሊዳይ ኢንቴናራ ጻላ ጊዴና። ");
INSERT INTO gmve_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","ጎዳ ኑ ጾሳይ ሃይሳ ሃ ጫቆ ቃላ ጌሊዛይ ኢዛ ሱንꬃን ኤቂዳ ኑናራ ጻላ ጊዶንታ ሃች ሃይሳን ዶንታ ቡሮ ያና ዬሌታ ኡባሳራ ጫቄስ። ");
INSERT INTO gmve_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","ኑኒ ጊብጼን ዋኒ ዴኢዳኮኔ ኑ ሃይሳ ሃ ዪሼ ኢሲ ኢሲ ካዎቴꬃራ ዋኒ ካንꬂ ዪዳኮ ኢንቴ ኡባይካ ሄሳ ኤሬታ። ");
INSERT INTO gmve_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","ኢስታ ጊዶን ዲዛ ሃራሲዛ ሚሻታ ሚꬃፌ፥ ሹቻፌ፥ ቢራፔኔ ዎርቃፌ ኦሴቲዳ ኤቃ ጾሳታ ኢንቴ ቤኢዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","ሃ ኢንቴፌ ኦኒኔ ኣቱማ ጊዲን ዎይኮ ማጫ ጊዲን ኢሲ ኬꬃ ኣስ ጊዲን ዎይኮ ቆሞ ጊዲን ጎዳ ኑ ጾሳፌ ሼርኢ ጊዲ ሃራ ካዎቴꬃታ ጾሳታስ ጎይኖንታ ማላ ናጌቲቴ፤ ኢንቴ ጋርሳን ሄሳ ማላ ጫሞኔ ማርዜ ጊዲዳ ሚሽ ኦꬂዛ ኣሲ ዶንታ ማላ ናጌቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","ሃ ጫቆ ቃላ ሲዪዲ ባ ዎዚናን፥ «ታኒ ታ ሼኔ ማላ ዲኮካ ታስ ሳሮይ ዴስ» ጊዲ ባና ጪሚኮ ሄሳ ማላ ኣሲ ሎኦታ ቦላኔ ኢታታ ቦላ ባሽ ኤሃና። ");
INSERT INTO gmve_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","ሄሳ ማላ ኣስ ጎዳይ ሙሌካ ማሬና፤ ጎዳ ሃንቆይ ኢዛዴ ቦላ ታማ ማላ ኤጻና፤ ሃይሳ ሃ ማጻፋን ጻፌቲዳ ቃንጌꬂ ኢዛዴ ቦላ ዎꬋና፤ ሳሎ ጋርሳፌ ኢዛ ሱንꬃ ጎዳይ ꬋይሳና። ");
INSERT INTO gmve_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","ሃይሳ ዎጋ ማጻፋን ጻፌቲዳ ቃንጌꬃ ቃላ ማላ ጎዳይ ኢዛዴ ኢስራኤሌ ኣሳ ኡባ ጋርሳፌ ዱማ ሻኪ ꬋይሳና። ");
INSERT INTO gmve_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","ሲንꬃፌ ያና ዬሌታይ፥ ኢንቴ ዛሬይኔ ሃሆ ዴሬፔ ያና ሃራ ቢታ ኣሳይ ጎዳይ ኢንቴ ቦላ ኤሂዳ ቦሻኔ ሜቶዛ ቤኣና። ");
INSERT INTO gmve_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","ሄ ቢታያ ሙሌራ ጹጌቲዳ ማጺኔኔ ዲኔ ጌቴቲዛ ቢዲንꬅ ጊዳና፤ ኢሲ ሚሺካ ኢዚን ቶኬቴና፤ ኣይ ሚሺካ ኢዚን ሞኬና፤ ኢዚን ፑዴ ዲጪዛ ሚሺ ቤቴና፤ ኢዚ ቦላ ጋካና ኩንዴꬂ ጎዳይ ኬሂ ሼኔቲዲ ሙሌራ ꬋይሲዳ ሶዶሜ ማላኔ ጋሞራ ማላ፥ ኣዳማ ማላኔ ጻቦይሜ ማላ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","ካዎቴꬃቲ ኡባይ፥ «ጎዳይ ሃ ቢታ ቦላ ሃይሳ ኣዛስ ጋꬂዴ? ሃ ዎልቃማ ሃንቆዛስ ጋሶ ጊዲዳይ ኣዜ?» ጊ ኦይቻና። ");
INSERT INTO gmve_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","ኣሳይ ኢዛስ ዛሪዲ፥ «ካሴ ኢስታ ኣዋታ ጾሳይ ኢስታ ጊብጼ ዴሬፔ ኬሲዳ ዎዴ ኢስታራ ፓጬቲ ጫቆዛ ኣሳይ ኣጊዳ ጊሻሳ። ");
INSERT INTO gmve_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","ቃሴ ኢስቲ ቢዲ ካሴ ባ ኤሮንታ ጾሳታሲኔ ኢዚ ኢስታስ ጎይኖፍቴ ጊዳ ኤቃ ጾሳታስ ጎይኒዳ። ");
INSERT INTO gmve_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","ሄሳ ጊሻስ ጎዳይ ሃንቄቲዲ ሃ ማጻፋን ጻፌቲዳ ቃንጌꬅ ኡባ ኢስታ ቦላ ኤሂዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","ጎዳይ ዎልቃማ ሃንቆኒኔ ኢታ ቦሻን ኢስታ ኢስታ ዴሬፔ ሾዲዴስ፤ ሄሳ ጊሻስ ኢስቲ ሃች ጋካናስ ሄን ዴቴስ» ጋና። ");
INSERT INTO gmve_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","ጹራ ዮኦቲ ጎዳ ኑ ጾሳሳ፤ ጊዶ ኣቲን ኑኒ ሃ ዎጋ ቃላ ናጋና ማላ ቆንጪዳ ዮኦቲ ሜርናስ ኑሲኔ ኑ ናይታሳ። ");
INSERT INTO gmve_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","ናምኣታፔ ኢሳ ኢንቴ ዶራና ማላ ሃች ታ ኢንቴ ሲንꬃን ኣንጆኔ ቃንጌꬅ ዎꬃዲስ፤ ጎዳ ኢንቴ ጾሳይ ኢንቴና ካዎቴꬃታ ጊዶን ዲሼ ኢንቴ ኢዛ ዩሺ ቆፒዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","ኢንቴኒኔ ኢንቴ ናይቲ ጎዳ ኢንቴ ጾሳኮ ሲሚዲ ኩሜꬃ ዎዚናፔኔ ኩሜꬃ ሼምፖፌ ታኒ ሃች ኢንቴና ኣዛዚዳ ቃላስ ኣዛዜቲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","ጎዳ ኢንቴ ጾሳይ ኢንቴስ ቃꬌታናኔ ኢንቴፌ ዲኤቲዳ ኢንቴ ሚሻ ኢንቴስ ዛራና፤ ኢንቴ ካሴ ላሌቲ ዲዛ ዴሬፔ ዛሪ ኤሂዲ ቃሴካ ዱሬሳና። ");
INSERT INTO gmve_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","ኢንቴ ቢታ ጋጻ ጋካናስ ላሌቲኮካ ሄፔ ጎዳ ኢንቴ ጾሳይ ኢንቴና ኢሲ ቦላ ሺሺዲ ዛሪ ኤሃና። ");
INSERT INTO gmve_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","ሄሳꬆ ሃኒዲ ካሴ ኢንቴ ኣዋታ ቢታ ኢንቴ ዛሪ ላታና፤ ኢዚካ ኢንቴና ካሴ ኢንቴ ኣዋታፔ ኣꬂ ዱሬሳናኔ ኢንቴ ቆዳ ዳርሳና። ");
INSERT INTO gmve_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","ኢንቴ ዴኦን ዳና ማላኔ ጎዳ ኢንቴ ጾሳ ኢንቴ ኩሜꬃ ዎዚናፔኔ ኩሜꬃ ሼምፖፌ ሲቃና ማላ ኢዚ ኢንቴሲኔ ኢንቴ ናይታስ ኣዛዜቲዛ ዎዚና ኢማና። ");
INSERT INTO gmve_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","ጎዳ ኢንቴ ጾሳይ ሃይታ ሃ ቃንጌꬃታ ኡባ ኢንቴ ሞርኬታ ቦላኔ ኢንቴና ኢጺዛይታ ቦላ ዛራና። ");
INSERT INTO gmve_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","ኢንቴካ ዛሪዲ ኢንቴ ጎዳስ ኣዛዜታና፤ ታ ኢንቴስ ሃች ኢሚዛ ኢዛ ኣዛዞታ ኢንቴ ናጋንዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","ሄሳፌ ጉዬ ኢንቴ ኦꬂዛ ኦሶ ኡባን ጎዳ ኢንቴ ጾሳይ ኢንቴና ዱሬሳና፤ ኢዚ ኢንቴስ ናይታ፥ ሜሄ፥ ካꬂኔ ሚꬃ ኣይፌ ዳርሳና፤ ጎዳ ኢንቴ ጾሳይ ካሴ ኢንቴ ኣዋታ ዱሬሲዲ ኡፋዬቲዳ ማላ ኢንቴናካ ዱሬሲዲ ኡፋዬታና። ");
INSERT INTO gmve_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","ኢዚ ሄሳꬆ ኦꬃናይካ ሃይሳ ዎጋ ማጻፋን ጻፌቲዳ ኣዛዞታኔ ዎጋታ ኢንቴ ኩሜꬃ ዎዚናፔኔ ኩሜꬃ ሼምፖፌ ናጊዲ ጎዳ ኢንቴ ጾሳኮ ኢንቴ ሲሚኮና። ");
INSERT INTO gmve_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","ታኒ ሃች ኢንቴስ ኢሚዛ ኣዛዞይ ኬሂ ዴጾ ዎይኮ ኢንቴፌ ሃኪዳዝ ጊዴና። ");
INSERT INTO gmve_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","«ኑኒ ኢዛ ሲዪዲ ኣዛዜታና ማላ ፑዴ ሳሎ ቢ ኤሂዲ ኑስ ዮታናይ ኦኔ?» ጊዲ ኢንቴ ኦይቾንታ ማላ ሃይሲ ዎጋዚ ቦላ ሳሎፔ ቤቴና። ");
INSERT INTO gmve_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","«ኑኒ ኢዛ ሲዪዲ ኣዛዜታና ማላ ኣባ ፒኒ ቢ ኤሂዲ ኑስ ዮታናይ ኦኔ?» ጊዲ ኢንቴ ኦይቾንታ ማላ ኢዚ ኣባ ፒንꬃፌ ቤቴና። ");
INSERT INTO gmve_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","ኢዛ ቃላይ ኢንቴ ማታን ዴስ፤ ኢንቴ ኢዛ ናጋና ማላ ኢዚ ኢንቴ ዶናኒኔ ኢንቴ ዎዚናን ዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","ኔኒ ዶራና ማላ ታኒ ሃች ኔስ ዴኦኔ ሎኤቴꬅ፥ ዎይኮ ሃይቆኔ ባሽ ኔ ሲንꬃን ዎꬃዲስ። ");
INSERT INTO gmve_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","ጎዳ ኢንቴ ጾሳ ሲቃና ማላ፥ ኢዛ ኦጌን ሄሜታና ማላኔ ኢዛ ኣዛዞታ፥ ማራታኔ ኢዛ ዎጋታ ናጋና ማላ፥ ታኒ ሃች ኢንቴስ ኢሚዛ ጎዳ ኢንቴ ጾሳ ኣዛዞታ ኢንቴ ናጊኮ ኢንቴ ሼምፖራ ፓጻ ዴኣናኔ ጮራታና፤ ቃሴ ኢንቴ ላታናስ ጌሊዛ ቢታን ጎዳ ኢንቴ ጾሳይ ኢንቴና ኣንጃና። ");
INSERT INTO gmve_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","ጊዶ ኣቲን ኢንቴ ኢንቴ ዎዚና ጾሳፌ ሃሲዲ ኢዛ ቃላ ሲዮንታ ኢጺኮ፥ ሃራ ኤቃ ጾሳታስ ጎይኒኮኔ ኢስታስ ኦꬂኮ፥ ");
INSERT INTO gmve_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","ኢንቴ ሙሌራ ꬋያናይሳ ሃች ታ ኢንቴስ ዮታይስ፤ ኢንቴ ዮርዳኖሴ ሻፋ ፒኒዲ ላታና ቢታይን ዳሮ ላይꬅ ጋምኤኬታ። ");
INSERT INTO gmve_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","ታኒ ኢንቴ ሲንꬃን ዴኦኔ ሃይቆ፥ ኣንጆኔ ቃንጌꬅ ዎꬂዳይሳስ ሃች ሳሎኔ ሳኣ ኢንቴ ቦላ ማርካሳይስ፤ ሄሳ ጊሻስ ኢንቴኒኔ ኢንቴ ዛሬቲ ዴኦን ዴኣና ማላ ዴኦ ዶሪቴ። ");
INSERT INTO gmve_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","ጎዳ ኢንቴ ጾሳ ሲቂቴ፤ ኢዛ ቃላ ሲዪቴ፤ ኢዛኮ ሺጲ ጊቴ፤ ሄሳꬆ ሃኒኮ ጎዳይ ካሴ ኢንቴ ኣዋታስ፥ ኣብራሃሜስ፥ ዪሳቃሲኔ ያቆቤስ ኢማናስ ጫቂዳ ቢታን ኢንቴኒኔ ኢንቴ ናይቲ ኣዱሳ ላይꬅ ዴኣና። ");
INSERT INTO gmve_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","ሙሴይ ሃይሳ ቃላ ኡባ ኢስራኤሌ ኣሳስ ዮቲዳፔ ጉዬ፥ ");
INSERT INTO gmve_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","ኢስታስ፥ «ሄኮ ሃኢ ታስ 120 ላይꬅ ጊዲዳ ጊሻስ ሃይሳፌ ጉዬን ታ ኢንቴና ካሌꬃናስ ዳንዳይኬ፤ ሄሳፌካ ቦላራ ታኒ ዮርዳኖሴ ሻፋ ፒኖንታ ማላ ጎዳይ ታስ ዮቲ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","ጎዳ ኢንቴ ጾሳይ ኢንቴፌ ሲንꬃራ ቢሼ ኢንቴና ካሌꬃና፤ ሄን ዲዛ ካዎቴꬃታ ኡባ ኢዚ ꬋይሲን ኢንቴ ኢስታ ቢታ ላታና፤ ጎዳይ ዮቲዳ ማላ ኢያሶይ ኢንቴና ካሌꬃና። ");
INSERT INTO gmve_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","ጎዳይ ኣሞሬ ዴሬ ካዎታ ሲሆኔኔ ኣጌ ጾኒዲ ኢስታ ቢታ ꬋይሲዳ ማላ ኢስታ ቦላካ ሄሳꬆ ኦꬃና። ");
INSERT INTO gmve_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","ጎዳይ ኢስታ ኢንቴስ ኣꬂ ኢማና፤ ኢንቴኒካ ታ ኢንቴና ኣዛዚዳ ማላ ኢስታ ቦላ ኦꬃና። ");
INSERT INTO gmve_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","ኢንቴስ ሙርታቴꬂኔ ጻላቴꬂ ዴኦ፤ ኢስታስ ሙሌካ ባቦፍቴኔ ዳጋሞፍቴ፤ ጎዳ ኢንቴ ጾሳይ ኢንቴናራ ዴስ፤ ኢዚ ኢንቴና ዬጊ ኣጌና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","ሄሳፌ ጉዬ ሙሴይ ኢያሶ ባኮ ጼይጊዲ ኩሜꬃ ኢስራኤሌ ኣሳ ሲንꬃን፥ «ሚና፤ ባቦፋ፤ ጎዳይ ካሴ ኢስታ ኣዋታ ላቲሳና ጊዲ ጫቂዳ ቢታዮ ላታና ማላ ዴሬዛ ካሌꬃ ጌልꬃዳ ላቲሳናይ ኔና። ");
INSERT INTO gmve_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","ጎዳይ ኔናራ ጊዲዲ ኢዚ ኔና ካሌꬃና፤ ኢዚ ኔና ዬጌና፤ ሙሌካ ኣጌና፤ ሄሳ ጊሻስ ባቦፋ፤ ሂዶታካ ቃንጾፋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","ሄሳፌ ጉዬ ሙሴይ ዎጋ ጻፊዲ ጫቆ ቃላ ታቦታ ቶኪዛ ቄሴ ጊዲዳ ሌዌ ናይታሲኔ ኢስራኤሌ ጪማታ ኡባስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","ሙሴይካ ኢስታስ፥ «ኣጮ ኡባ ማሪዛ ላፑንꬃ ላይꬃን ዉርሴꬃ ቦላ ቦንቼቲዛ ዳሴ ባኣሌዛን፥ ");
INSERT INTO gmve_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","ጎዳ ኢንቴ ጾሳ ሲንꬃን ኢዚ ካሴ ዶሪዳሶን ኢዛስ ጎይናናስ ኢስራኤሌ ኣሳይ ኡባይ ሺቂዛ ዎዴ ሃይሳ ዎጋዛ ኢስታ ሲንꬃን ናባቢቴ። ");
INSERT INTO gmve_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","ኢስቲ ኡባይካ ሄሳ ሲዪዲ ጎዳ ኢንቴ ጾሳስ ያሻቴꬅ ታማራና ማላኔ ሃይሳ ዎጋ ቃላታ ኡባ ሎኤꬂ ናጋና ማላ ማጫሳታ፥ ኣዴታ፥ ናይታኔ ኢንቴ ዴሬን ዲዛ ቤቴ ኣሳታ ኡባ ኢሲ ቦላ ሺሺቴ። ");
INSERT INTO gmve_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","ሄሳ ማላን ጎዳ ኢንቴ ጾሳ ዎጋ ካሴ ሲዪ ኤሮንታ ኢንቴ ዜሬꬃቲ ኡባይካ ሲዬቶ፤ ቃሴ ኢንቴ ዮርዳኖሴ ሻፋ ፒኒዲ ላታና ቢታን ዲዛ ዎዴ ኡባን ኢስቲ ጾሳስ ኣዛዜቴꬅ ታማሬቶ» ጊ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","ሄሳፌ ጉዬ ጾሳይ ሙሴስ፥ «ኔስ ሃይቆ ዎዴይ ጋኪዴስ፤ ኢዚ ካላና ዎጋታ ኢዛስ ታ ኢማና ማላ ኢያሶ ጼይጋዳ ኢዛራ ጌዴ ጋይቶቴꬃ ዱንካኔዛኮ ሺቂቴ» ጊዴስ። ሙሴይኔ ኢያሶይ ኢሲፌ ጌዴ ጋይቶቴꬃ ዱንካኔዛኮ ሺቂዳ። ");
INSERT INTO gmve_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","ጎዳይካ ኢስታስ ዱንካኔዛ ፔንጌን ቱሳ ማላ ኤቂዳ ሻራን ቆንጪዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","ጎዳይ ሙሴስ፥ «ኔኒ ማታ ዎዴ ሃይቃዳ ኔ ኣዋታን ጋይታና፤ ሄሳፌ ጉዬ ሃይሲ ኣሳዚ ታ ኢዛራ ጫቄቲዳ ቃላ ላላና፤ ኢስቲ ታና ኣጋጊዲ ላይማ ማጫሳ ማላ ሄ ኢስቲ ላታና ቢታን ዲዛ ኤቃ ጾሳታስ ጎይናና። ");
INSERT INTO gmve_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","ሄሳꬆ ሃኒዛ ዎዴ ታኒ ኢስታ ቦላ ሃንቄታዳ ኢስታፌ ሻኬታና፤ ታ ኢስታስ ዞኮ ዛራና፤ ኢስቲካ ኡባይ ꬋያና፤ ኢስታ ቦላ ኢታ ሜቶይኔ ቦሻይ ያና፤ ሄ ዎዴ ኢስታስ፥ ‹ሃይሲ ሜቶዚ ኑ ቦላ ጋኪዳይ ኑ ጾሳይ ኑ ጊዶን ዶንታ ኣጊን ጊዴኔ?› ጋና። ");
INSERT INTO gmve_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","ኢስቲ ኤቃ ጾሳታስ ጎይኒዲ ኢስቲ ኦꬂዳ ናጋራ ጊሻስ ታኒ ሄ ዎዴ ኢስታስ ዞኮ ዛራና። ");
INSERT INTO gmve_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","«ሃይሳ ዬꬃ ጻፋዳ ኢስራኤሌ ኣሳ ታማርሳዳ ኢስቲካ ዬጻና ማላ ኦꬃ፤ ሃይሲ ዬꬃዚ ኢስታ ቦላ ታስ ማርካ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","ታኒ ቤኒ ኢስታ ኣዋታስ ጫቂዳ ጫቆ ቃላ ማላ ኤሲኔ ማꬂ ኩሚዳ ቢታዮ ታ ኢስታ ጌልꬃና፤ ኢስቲ ሄን ሚዲኔ ኡዪዲ ካሊዳፔኔ ዱሬቲዳፔ ጉዬ ታና ዬጊ ኣጋና፤ ታ ጫቆ ቃላካ ዬጊ ኣጊዲ ኤቃ ጾሳታስ ጎይናና። ");
INSERT INTO gmve_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","ዳሮ ሜቶይኔ ባሺ ኢስታ ቦላ ጋኪዛ ዎዴ ሃ ዬꬃይ ኢስታ ናይታ ዶናፔ ኪቼና ጊሻስ ኢስታ ቦላ ማርካ ጊዳና። ጋሶይካ ታኒ ጫቂዳ ቢታ ኢስታ ቡሮ ጌልꬆንታ ዳሼ ሃራካ ኢስቲ ቆፒዛ ቆፋ ኤራይቻዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","ሙሴይ ሄ ጋላስ ዬꬃዛ ጻፊዲ ኢስራኤሌ ኣሳ ታማርሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","ሄሳፌ ጉዬ ጾሳይ ናዌ ና ኢያሶ፥ «ሚና፤ ጻላ ጊዳ፤ ኔኒ ኢስራኤሌ ኣሳ ካሌꬃዳ ታ ካሴ ኢስታስ ኢማና ጋ ጫቂዳ ቢታዮ ጌልꬃና፤ ታኒካ ኔናራ ጊዳና» ጊ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","ሙሴይካ ሃይሳ ዎጋ ቃላታ ኮይሮፔ ቢዲ ዉርሴꬅ ጋካናስ ኡባ ጻፊዳፔ ጉዬን፤ ");
INSERT INTO gmve_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","ጎዳ ጫቆ ቃላ ታቦታ ቶኪዛ ሌዌ ቆሞታ ሂዝጊ ኣዛዚዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","«ጎዳ ዎጋይ ኢዛን ጻፌቲዳ ማጻፋ ኤኪዲ ጎዳ ኢንቴ ጾሳ ጫቆ ቃላ ታቦታዛ ኣቻን ዎꬂቴ፤ ሄን ኢዚ ባ ዲዛሶን ዲሼ ዴሬዛ ቦላ ማርካ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","ኢስራኤሌ ኣሳይ ኣይ ማላ ማካላንቻኮኔ ዎዚና ሙሜኮ ታ ኤራይስ፤ ታኒ ሼምፖራ ፓጻ ኢስታራ ዲሺን ኢስቲ ጎዳ ቦላ ማካሊዛይቲ ታኒ ሃይቂዳፔ ጉዬ ኬሂ ማካላንቻታ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","ሄሳ ጊሻስ ታ ኢስታስ ሃይሳ ኡባ ዮታና ማላ ኮራፒኔታኔ ዴሬ ሃላቃታ ታስ ሺሺቴ፤ ታኒ ኢስታ ቦላ ሳሎኔ ሳኣ ማርካ ጊዳና ማላ ጼይጋና። ");
INSERT INTO gmve_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","ታኒ ሃይቂዳፔ ጉዬ ታ ኢንቴና ኣዛዚዳ ኣዛዞፔ ካሬ ኬዚዲ ቱና ኦሶ ኢንቴ ኦꬃናይሳ ታ ኤራይስ፤ ጎዳ ሲንꬃን ኢታ ኦሶ ኦꬂዲ ኢንቴ ኢዛ ሃንቄꬂኮ ኢዚ ኢንቴ ቦላ ቦሻ ዬዳና።» ");
INSERT INTO gmve_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","ሄሳፌ ጉዬ ሙሴይ ኩሜꬃ ኢስራኤሌ ኣሳ ሲንꬃን ሃይታ ዬꬃ ቃላታ ኮይሮፔ ቢዲ ዉርሴꬅ ጋካናስ ዮቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","ሳሎቶ! ታኒ ዮቲዛይሳ ኤዝጊ ሲዪቴ፤ ሳኣዞ ታ ዶናፔ ኬዚዛ ቃላ ሲያ። ");
INSERT INTO gmve_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","ታ ኢሚዛ ቲሚርቴይ ኢራ ማላ ቡኮ፤ ታ ሃሳያይካ ጻዛ ማላ ጾኬቶ፤ ማታ ቦላ ሎዲ ጊ ቡኪዛ ኢራ ማላ ቡኮ፤ ካꬃ ጫሬቻ ቦላ ፑሴ ማላ ዎꬎ። ");
INSERT INTO gmve_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","ታኒ ጎዳ ሱንꬅ ኣዋጃይስ፤ ኑ ጾሳ ጊታቴꬅ ኢንቴ ዮቲቴ። ");
INSERT INTO gmve_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","«ኢዚ ኑስ ሚጻ፤ ኢዛ ኦሶቲካ ኩሜꬃ፤ ኢዛ ኦጌቲ ዉሪካ ሱሬ፤ ኢዚ ባሌቶንታ ኣማኔቲዳ ጾሳ፤ ኢዚ ሱሬኔ ጺሎ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","«ኢስቲ ኢዛ ሲንꬃን ኢታ ኦꬂዳ፤ ኢስቲ ባንታ ኢታቴꬃፌ ዴንዲዳይሳን ሃይሳፌ ጉዬ ኢዛ ናይታ ጊዴቴና፤ ኢስቲ ቦካኔ ጌላ ዬሌታታ። ");
INSERT INTO gmve_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","«ኢንቴኖ ኤያቶ! ቃሴካ ዎዚናይ ባይንዳይቶ! ኢንቴ ጎዳስ ኢሚዛ ዛሮይ ሃይሴ? ኢንቴና ሜꬊዳ ኢንቴ ኣዋይ ኢዛ ጊዴኔ? ኢንቴና ሜꬊዲ ሃይሳስ ጋꬂዳይ ኢዛ ጊዴኔ? ");
INSERT INTO gmve_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","«ካሴ ቤኒ ዎዴዛ ዩሺ ቆፒቴ፤ ዳሮ ዬሌታታ ላይꬃካ ኣኬኪቴ፤ ኢንቴ ኣዋታ ኦይቺቴ፤ ኢስቲ ኢንቴስ ዮታና፤ ካሴ ጪማታካ ኦይቺቴ፤ ኢስቲ ኢንቴስ ቆንጪሲ ዮታና። ");
INSERT INTO gmve_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","«ኡባፌ ꬎቃ ጾሳይ ካዎቴꬃታስ ቢታ ጊሼቺዳ ዎዴ፥ ኣሳ ናይታ ኢስታ ዛሬን ዛሬን ሻኪዳ ዎዴ፥ ኢስራኤሌ ኣሳ ቆዳ ኬና ካዎቴꬃታስ ꬋስ ዎꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","«ኢስራኤሌይ ጎዳስ ጊሻ፤ ያቆቤይካ ኢዛስ ቡዞ ሚሻ። ");
INSERT INTO gmve_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","«ኣይኮይካ ባይንዳ ባዞን ጫርኮይ ፑኒዛ ቢታን ኢዛ ዴሚዴስ፤ ኢዛስ ጎንዳሌ ጊዲዴስ፤ ባ ኣይፌ ጪሮ ማላ ኢዛ ናጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","ጎሌ ካፎይ ባ ጪዬታ ፒራꬎ ታማርሲዛ ማላ፥ ባ ቄፌ ሚጫዳ ጋካ ኦይካ ኣሺዛ ማላ፥ ጎዳይ ባ ቄፌን ሃጵዲ ኢስታ ኣሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","ሃራ ኤቃ ጾሳቲ ኢዛራ ባይንዳ ጎዳይ ኢዛ ባርካ ካሌꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","«ꬎቃ ሶሆን ኢዛ ዎꬂዴስ፤ ቢታፌ ሞኪዳ ካꬃ ኣይፌ ኢዛ ሚዚዴስ፤ ዛላፌ ቤቲዳ ኤስ ኡሺዴስ፤ ሹቻ ቢታን ሞኪዳ ዎጋራ ዛይቴ ሚዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","ሚዛፔ ዶርሳፌኔ ዴይሻ ዉዴፔ ቤቲዛ ማꬃኒኔ ኦይስ ባሳኔ ዴሬፔ ቤቲዛ ኦሃላ ላቃታ፥ ሞꬎ ꬋርሾታ፥ ዎፋኖታኔ ዴይሻታ፥ ሎኦ ጊስቴ ዳቦራ ኢስታ ሚዚዴስ። ኢንቴ ኢዛ ዴሬቲ ዞኦ ዎይኔ ሚꬃ ኣይፌፔ፥ ጊጊዳ ዎይኔ ኡሹ ኡዪዴታ። ");
INSERT INTO gmve_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","«ኢስራኤሌ ኣሳይ ኦርዲዴሲኔ ማካሊዴስ። ዳሮ ሚዲ ሞꬊዴሲኔ ሞላቲዴስ፤ ባና ሜꬊዳ ጾሳ ኣጊዴስ፤ ባና ኣሺዳይሳካ ካዉሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","ኢስቲ ኤቃ ጾሳታስ ጎይኒዲ ጾሳ ሚሺሲዳ፤ ባንታ ኢታ ኦሶንካ ኢዛ ሃንቄꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","ሃይሳፌ ካሴ ባ ኤሮንታይታስ፥ ጾስ ጊዶንታ ዳይዳንꬃታስ፥ ማታ ዎዴ ዪዳ ጾሳታስ፥ ቤኒ ኢስታ ኣዋቲ ኢስታስ ጎይኖንታ ኤቃታስ፥ ኢስቲ ያርሾ ሺሺዳ። ");
INSERT INTO gmve_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","ኢስቲ ባስ ዴኦ ኢሚዳ ዛላ ዶጊዳ፤ ባና ሜꬊዳ ጾሳካ ባሊዳ። ");
INSERT INTO gmve_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","«ጎዳይ ሄሳ ቤኢዲ ኢስታ ቦላ ሃንቄቲዴስ፤ ኢስታ ማጫ ናይታኔ ኢስታ ኣቱማ ናይታ ዲጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","‹ታኒ ታ ኣይፌሶ ኢስታፌ ጌንꬃና፤ ኢስቲ ጌላኔ ኣማኔቶንታ ዴሬ ጊዲዳ ጊሻስ ኢስታ ዉርሴꬂ ኣይ ጊዳናኮ ታ ጮኡ ጋ ቤያና።› ");
INSERT INTO gmve_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","ቱሙ ጊዶንታ ጾሳታን ታና ሚሺሲዳ፤ ጎኣይ ባይንዳ ባ ኤቃ ጾሳታን ታና ሃንቄꬂዳ። ታኒካ ኢስታ ካꬌቲዳ ካዎቴꬃታ ኢስቲ ሚጌታና ማላ ኦꬃና። ታ ኢስታ ኣኬኮንታ ዴሬታን ሃንቄꬃና። ");
INSERT INTO gmve_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","ታ ሃንቆይ ታማ ማላ ኤጻና፤ ቢታኔ ቢታ ቦላ ዲዛ ኡባ ጹጋና፤ ሄ ታማይ ሲኦሌ ጪማ ጋካናስ ኤጻና፤ ታማዚ ዙማስ ዮች ጋካናስ ማና። ");
INSERT INTO gmve_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","ታኒ ኢስታ ቦላ ዛሬꬃ ዛሬꬃ ቦሻ ኤሃና፤ ታስ ዲዛ ዎንዳፌ ታ ኢስታ ቦላ ዉርሳና። ");
INSERT INTO gmve_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","ታ ኡባ ዉርሲዛ ኮሻ ኢስታ ቦላ ዬዳና፤ ኢሳፌ ኢሳን ኣꬊዛ ኢታ ሃርጌኒኔ ቦሻን ኢስቲ ዉራና፤ ሜቶ ጋꬂዛ ኢታ ዶኣታኔ ዱኪዛ ማርዜራ ዲዛ ሾሻታ ታ ኢስታ ቦላ ዬዳና። ");
INSERT INTO gmve_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","ኦጌ ኡባን ኢስታ ናይታ ኦላይ ዉርሳና፤ ኢስታ ኬꬃ ጊዶንካ ሂርጋይ ኩማና፤ ፓንꬃቲኔ ጌላኦቲ፥ ጉꬃ ናይቲኔ ጪማቲ ኡባይ ዉራና። ");
INSERT INTO gmve_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","ታኒ ኢስታ ኡባ ላላና፤ ሄሳፌ ጉዬ ኢስታራ ሃሳኣና ኣሲ ዴና። ");
INSERT INTO gmve_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","ጊዶ ኣቲን ኢስታ ሞርኬቲ፥ ‹ኑኒ ኑ ዎልቃን ኢስታ ጾኒዶስ ኣቲን ጾሴ ጊዴና› ጊዲ ኦቶሬቴꬃን ጬቄቲዲ ታና ሃንቄꬃናኮ ጋዳ ቆፓይስ። ");
INSERT INTO gmve_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","ኢስራኤሌ ኣሳይ ዩሺ ቆፖንታ ካዎቴꬅ፤ ኢስታስ ኣኬካይ ዴና። ");
INSERT INTO gmve_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","ኢስቲ ኤራታ ጊዲዳኮ ሃይሳ ኢስቲ ካሴቲዲ ቆፓና፤ ባንታ ዉርሴꬃንካ ሃናናይሳ ዩሺ ቆፓናሺን! ");
INSERT INTO gmve_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","ኢስታ ሜꬊዳይሲ ኢስታ ኣꬂ ኢሞንታኮ፥ ጎዳይ ኢስታ ዬጊ ኣጎንታኮ፥ ኢሳዴይ 1,000 ኣስ ዎስቲ ጎዳንዴ? ዎይኮ ናምኣቲ 10,000 ኣስ ዎስቲ ጎዳኔ? ");
INSERT INTO gmve_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","ሃራይ ኣቶሺን ኑ ሞርኬቲ ኢስታ ጾሳይ ላፋ ጊዲዳይሳኔ ኢስራኤሌ ጾሳ ማላ ጊዶንታይሳ ኤሬቴስ። ");
INSERT INTO gmve_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","ኑ ሞርኬቲ ሶዶሜኔ ጋሞራ ዴሬ ኣሳ ማላ ቱና፤ ኢስቲካ ጫሞኔ ማርዜራ ዲዛ ኣይፌ ኣይፊዛ ዎይኔ ሚꬃ ማላ። ");
INSERT INTO gmve_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","ኢስታ ዎይኔ ኡሻይ ሾሻ ማርዜ ማላ፤ ቃሴካ ሃሶ ሾሻ ማርዜ ማላ። ");
INSERT INTO gmve_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","«ሃይሳ ታኒ ዶጋዲና? ታ ማዝጋባን ጻፌቲ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","ኢስታ ሞርኬታ ቦላ ሃሎ ኬሳናይ ታና፤ ኡባሲካ ታ ኢስታ ኦሶ ኦሶ ማላ ኢማና፤ ኢስታስ ꬋዮ ጋላሲ ጋኪዳ ጊሻስ ኢስቲ ꬉጴታና፤ ኤሶንካ ꬋያና።» ");
INSERT INTO gmve_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","ኢስታስ ዎልቃይ ዳቡርዳይሳኔ ኢስታካ ማዲዛይ ባይንዳይሳ ቤኢዲ፥ ጎዳይ ባ ኣሳስ ፒርዳና፤ ባ ኣይሌታስካ ቃꬌታና። ");
INSERT INTO gmve_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","ጎዳይ ባ ኣሳ፥ «ኢስቲ ኣማኔቲዛ ኢስታ ጾሳቲ ኣዋን ዲዞ? ኢስቲ ባቃቲ ኣቲዛ ዛላቲ ኣዋን ዲዞ?» ጊ ኦይቻና። ");
INSERT INTO gmve_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","ኢስቲ ያርሾስ ሺሺዛ ቶልꬆዛ ሚዳይቲ፥ ኢስታ ዎይኔ ኡሻ ያርሾዛ ኡዪዳ ኢስታ ኤቃ ጾሳቲ ኣኔ ሃኢ ኢንቴና ዴንዲ ማዴቶ፤ ቃሴካ ኢንቴስ ዱሳሶ ኢሜቶ። ");
INSERT INTO gmve_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","«ታኒ ጻላ ጾስ ጊዲዳይሳ ኤሪቴ፤ ታፔ ሃራ ጾሲ ዴና፤ ዎꬊዛይካ ፓጻ ዎꬂዛይካ ታና፤ ታኒ ማዱንꬃይሲኔ ፓꬃይስ፤ ታ ኩሼፔ ኦኒካ ኢንቴና ኣሼና። ");
INSERT INTO gmve_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","ታኒ ታ ኩሼ ፑዴ ሳሎ ዴንꬃዳ፥ ‹ታ ሜርናስ ዴኣይስ። ");
INSERT INTO gmve_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","ዋዋጪ ጊዛ ታ ጊꬃ ማሻ ሌፋና፤ ታ ኩሼይ ፒርዳስ ኦይካና፤ ታ ሞርኬታ ቦላ ሃሎ ኬሳና፤ ታና ኢጺዛይታስ ታ ኢስታ ኦሶ ማላ ኢስታስ ኢማና። ");
INSERT INTO gmve_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","ሞርኬታ ሃላቃታ፥ ማዱንጺዳይታኔ ዲኤቲዳይታ ሱꬃን ታ ዎንዳፌታ ታ ማꬆሳና፤ ታ ጊꬃ ማሻቲካ ታ ሞርኬታ ኣሾ ማና› ጋ ጫቃና። ");
INSERT INTO gmve_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","«ኢንቴኖ ካዎቴꬃቶ! ጎዳይ ባ ኦሳንቻታ ሱꬅ ኣጫና፤ ሞርኬታ ቦላ ሃሎ ኬሳና፤ ባና ኢጺዛይታ ቃጻያና፤ ባ ዴሬዛ ናጋራ ዉርሳና፤ ቢታዮካ ቱናቴꬃፌ ጌሻና፤ ሄሳ ጊሻስ ኢንቴ ኢዛ ኣሳራ ኢሲፌ ኡፋዬቲቴ» ጊዲ፥ ");
INSERT INTO gmve_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","ሙሴይኔ ናዌ ና ኢያሶይ ዴሬዚ ሲዪሺን ሃ ዬꬃዛ ዮቲዳ። ");
INSERT INTO gmve_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","ሙሴይ ሃይታ ሃ ቃላታ ኩሜꬃ ኢስራኤሌ ኣሳ ሲሲዳፔ ጉዬ፥ ");
INSERT INTO gmve_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","ኢዚ፥ «ሃይሳ ዎጋ ቃላ ኡባ ኢንቴ ናይቲ ሎኤꬂ ናጋና ማላ፥ ኢስቲ ኦꬃና ማላኔ ኢንቴ ናይታ ኢንቴ ኣዛዛና ማላ ሃች ታ ኢንቴስ ማርካቲዛ ቃላ ኡባ ኢንቴ ዎዚናን ዎꬂቴ። ");
INSERT INTO gmve_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","ሃ ቃላይ ኢንቴስ ዴኦፔ ኣቲን ጮ ሜላ ቃላ ጊዴና፤ ሃ ቃላ ናጊኮ ኢንቴ ዮርዳኖሴ ፒኒዲ ላታና ቢታንካ ኣዱሳ ላይꬅ ኢንቴ ዴኣና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","ሄ ጋላስ ጎዳይ ሙሴስ ሂዝጊዴስ፥ ");
INSERT INTO gmve_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","«ሞኣቤ ዴሬን ኢያርኮ ካታማ ጊናራ ዲዛ ኣባሪሜ ዙማታ ጊዶፌ ኔቦ ዙማ ቦላ ኬዛ፤ ሂስታዳ ታኒ ኢስራኤሌ ኣሳስ ኢማና ጊዳ ካናኔ ቢታ ሄ ፒንꬃን ጼላ። ");
INSERT INTO gmve_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","ኔ ኢሻ ኣሮኔይ ሆሬ ዙማ ቦላ ሃይቂዲ ካሴ ሃይቂዳ ባ ኣሳታን ጋይቲዳ ማላ ኔካ ሄ ዙማ ቦላ ሃይቃዳ ኔ ኣሳታን ጋይታና። ");
INSERT INTO gmve_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","ኢንቴ ናምኣይካ ኢስራኤሌ ኣሳ ሲንꬃን ታስ ኣማኔቲቤኬታ፤ ጺኔ ባዞን ቃዴሴ ካታማ ማታን ዲዛ ማሪባ ሃꬃ ኣቻን ታ ጌሻቴꬃ ኢስራኤሌ ኣሳ ቤሲቤኬታ። ");
INSERT INTO gmve_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","ሄሳ ጊሻስ ኔኒ ሄ ቢታዮ ሃሆን ዳሼ ቤኣና ኣቲን ታኒ ኢስራኤሌ ኣሳ ላቲሳና ቢታዮ ኔኒ ጌላካ።» ");
INSERT INTO gmve_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","ጾሳ ኣስ ሙሴይ ሃይቃናፔ ካሴቲዲ ኢስራኤሌ ኣሳስ ዎꬂዳ ባሴ ቃላይ ሃይሳፌ ካሊ ዲዛይሳ፤ ");
INSERT INTO gmve_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","ሙሴይ፥ «ጎዳይ ሲና ዙማፔ ዪዴስ፤ ኤዶሜፔ ኣዋ ኣርሼይ ኑ ቦላ ፖኢዴስ፤ ፓራኔ ዙማ ቦላፌካ ኑስ ጾልቂዴስ፤ ኢዛስ ኡሻቻ ባጋራ ታማ ላጮይ ዴስ፤ ቆዳይ ባይንዳ ኪታንቻቲ ኢዛራ ኢሲፌ ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","ጎዳዉ! ኔኒ ዴራ ኬሃ ሲቃሳ፤ ጌሻቲ ኡባይካ ኔ ኩሼን ዴቴስ፤ ኔ ቶሆ ጋርሳን ጉልባቲ ጎይኔቴስ፤ ሂስቲዲ ኔፔ ኣዛዞ ኤኬቴስ። ");
INSERT INTO gmve_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","ሙሴይ ኢሚዳ ዎጋይ ኢስራኤሌ ኣሳስ ላታ ጺንጾ። ");
INSERT INTO gmve_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","ኢስራኤሌ ቆሞቲ ኡባይኔ ዴራ ሃላቃቲ ሺቂን ጎዳይ ባ ዴሬ ኢስራኤሌ ኣሳ ቦላ ካዎቲዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","ኦሮቤሌ ቆሞታ ጊሻስ ሙሴይ፥ «ኦሮቤሌ ቆሞቲ ዴቶ ኣቲን ሃይቆፌቶ፤ ኢስታ ቆዳይካ ፓጮፎ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","ዩሁዳ ቆሞታ ጊሻስ ሙሴይ፥ «ጎዳዉ፥ ዩሁዳ ቆሞታ ዋሶ ሲያ፤ ኢስቲ ባ ዳቦታራ ኢሲፌቴꬃን ዳና ማላ ኦꬃ፤ ኢስታስ ጊታ ዎልቃ ኢማ፤ ኢስቲ ባ ሞርኬታራ ኦሌቲሺን ኔኒ ኢስታ ማዳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","ሌዌ ቆሞታ ጊሻስ ሙሴይ፥ «ጎዳዉ! ኔኒ ኢስታ ማሳን ፓጫዳሳ፤ ማሪባ ሃꬃ ኣቻን ኢስታራ ፓላሜታዳሳ፤ ሄሳ ጊሻስ ቱሚሜይኔ ኡሪሜይ ኔ ዶሲዳ ኔ ኦሳንቻታስ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","ኔ ጊሻስ ጊዲ ኢስቲ ባና ዬሊዳይታ ባሊዳ፤ ባ ዳቦታፔ ሻኬቲዳ፤ ባ ኢሻታፔ ሻኬቲዳ፤ ባ ናይታ ኣጊዳ፤ ኔ ቃላ ቦንቺዳ፤ ኔ ኢሚዳ ጫቆ ቃላካ ናጊዳ። ");
INSERT INTO gmve_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","ኢስቲ ኔ ዎꬂዳ ማራ ያቆቤ፥ ኔ ዎጋካ ኢስራኤሌ ኣሳ ታማርሴቴስ፤ ኢስቲ ኔ ሲንꬃን ኤጻኔ ጩዋሴቴስ፤ ጹጌቲዛ ያርሾካ ያርሾ ያርሺዛሶዛ ቦላ ሺሼቴስ። ");
INSERT INTO gmve_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","ጎዳዉ! ኔ ኢስታ ዴኦ ኣንጃ፤ ኢስቲ ኦꬂዛ ኦሶ ኡባን ኔ ኡፋዬታ፤ ኢስታ ሞርኬታ ሻያ ኔ ዱꬃ፤ ኢስታ ኢጺዛይቲ ናምኣንꬆ ዴንዶንታ ማላ ዲጋ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","ቢኒያሜ ቆሞታ ጊሻስ ሙሴይ፥ «ጎዳይ ሲቂዳ ኣሲ ኢዛን ኣማኔቲ ዴስ፤ ኡባ ጋላስ ኢስታ ኢዚ ናጌስ፤ ባ ሃሼን ቶኪዲ ሼምፒሴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","ዮሴፌ ቆሞታ ጊሻስ ሙሴይ፥ «ጎዳይ ሳሎፔ ቡኪዛ ኢራን፥ ቢታፌ ፑዴ ኬዚዛ ፑልቶን ኢንቴ ቢታ ኣንጆ። ");
INSERT INTO gmve_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","ኣዋ ዎዴ ካጺዛ ሎኦ ኣይፌ ኢሞ፤ ዎዴን ዎዴን ካጺዛ ካꬃ ኣይፌን ኩሞ። ");
INSERT INTO gmve_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","ቤኒሶፌ ዲዛ ኢስታ ዙማቲኔ ዙምቡላቲ ጮራኔ ሎኦ ኣይፌን ኣንጄቴቶ። ");
INSERT INTO gmve_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","ኢስታ ቢታይ ሎኦ ሚሻን ኩሞ፤ ጹጌቲዛ ቱሻ ጊዶፌ ቆንጪዳ ጎዳ ኪያቴꬂ ዳሮ፤ ዮሴፌይ ባ ኢሻታ ጊዶን ሃላቃ ጊዲዳ ጊሻስ ሃ ኣንጆቲ ኡባይ ኢዛ ጋኬቶ። ");
INSERT INTO gmve_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","ዮሴፌ ቴማይ ኮርማ ቦራ ማላ ያሺሶ፤ ኢዛ ካጬቲ ሜንꬃ ካጬ ማላ ሚኖ ጊዴቶ፤ ኢዛ ካጬቲ ሺያን ቆዴቲዛ ሚናሴ ዛሬታኔ ታሙ ሺያን ቆዴቲዛ ኤፍሬሜ ዛሬታ፤ ሄ ካጬታን ኢዚ ካዎቴꬃታ ቃይጫና፤ ቢታ ጋጻ ጋካናስ ኢስታ ኢዚ ጎዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","ዛቢሎኔ ቆሞታ ጊሻሲኔ ዪሳኮሬ ቆሞታ ጊሻስ ሙሴይ፥ «ዛቢሎኔ! ኔኒ ኔ ኬሳን ኡፋዬታ፤ ዪሳኮሬ! ኔኒካ ኔ ዱንካኔ ጊዶን ኡፋዬታ። ");
INSERT INTO gmve_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","ኢስቲ ዴሬዛ ፑዴ ዙማ ቦላ ጼይጊዲ ሄን ጺሎቴꬃ ያርሾ ያርሻና፤ ባንታስ ኣቆታኔ ዱሬቴꬅ ኣባፌኔ ሻሚንታፌ ዴማና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","ጋዴ ቆሞታ ጊሻስ ሙሴይ፥ «ጋዴ ቆሞታ ዛዋ ኣሲዳ ጾሳይ ጋላቴቶ፤ ጋዴይ ሞርኬታ ሜንꬄሬꬃናስ ጋሞ ማላ ሻንካቴስ። ");
INSERT INTO gmve_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","ሃላቃታስ ቤሲዛ ቢታዚ ኢዛ ናጌስ፤ ኢዚካ ሎኦ ቢታ ባስ ዶሪዴስ፤ ዴራ ካሌꬂዛይቲ ሺቂዳ ዎዴ ኢዚ ጎዳ ሼኔኔ ጺሎ ፒርዳ ፒርዲዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","ዳኔ ቆሞታ ጊሻስ ሙሴይ፥ «ዳኔይ ባሳኔፔ ጉፒ ኬኢዛ ዎዳላ ጋሞ ማላ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","ኒፍታሌሜ ቆሞታ ጊሻስ ሙሴይ፥ «ኒፍታሌሜይ ጎዳ ማታን ዶሴቲዴስ፤ ጎዳ ኣንጆንካ ኩሚዴስ፤ ኢዛ ዛዋይ ኣባፌ ኣꬊዲ ዱጌሃ ባጋ ጋኪዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","ኣሴሬ ቆሞታ ጊሻስ ሙሴይ፥ «ኣሴሬ ቆሞቲ ሃራ ቆሞታፔ ኣꬊ ኣንጄቲዳይታ ጊዴቶ፤ ኢስቲ ባ ኢሻታ ጊዶን ዶሴቲዳይታ ጊዴቶ፤ ኢስታ ቢታይ ዛይቴን ኩሞ። ");
INSERT INTO gmve_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","ኢስታ ካታማታ ፔንጌቲ ቢራታኒኔ ጻርቂማላን ሚኒ ጎርዴቴቶ፤ ባ ዲዛ ላይꬅ ኡባን ኢስቲ ዎልቃማ ጊዴቶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","ኢስራኤሌ ኣሳዉ! ሳሎፔ ኢንቴና ማዳናስ ባ ቴማራ ሻራ ቦላ ሄሜቲዛ ኢንቴ ጾሳ ማላ ሃራ ጾሲ ዴና። ");
INSERT INTO gmve_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","ሜርና ጾሳይ ኢንቴስ ዱሳሶ፤ ሜርናስ ዲዛ ኢዛ ቄሴቲ ኢንቴፌ ጋርሳራ ዲዲ ካፌቴስ፤ ኢንቴ ሞርኬታ ኢዚ ኢንቴ ሲንꬃፌ ጎዳና፤ ኢንቴ ኢስታ ꬋይሳና ማላ ኢዚ ኢንቴና ማዳና። ");
INSERT INTO gmve_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","ሄሳ ጊሻስ ኢስራኤሌ ኣሳይ ሳሎፔ ኢራይ ኢዚን ቡኪዛ ቢታይን፥ ካꬂኔ ዎይኔ ኡሺ ኢዚን ኩሚዳ ቢታይን ሂርጋይ ባይንዳ ሳሮን ዴኣና። ");
INSERT INTO gmve_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","ኢስራኤሌ ኣሳዉ! ኢንቴ ኣይ ማላ ኣንጄቲዳ ዴሬ! ጎዳይ ኣሺዳ ኢንቴ ማላይ ኦኔ? ኢዚ ኢንቴስ ጎንዳሌኔ ኢንቴና ማዲዛይሳ፤ ኢዛን ኢንቴ ጾኒዛ ጊꬃ ማሻ፤ ኢንቴ ሞርኬቲ ኢንቴ ሲንꬃን ጉፋናና፤ ኢንቴካ ኢስቲ ጎይኒዛሶታ ላላና። ");
INSERT INTO gmve_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","ሙሴይ ሞኣቤፔ ዴንዲ ፑዴ ኔቦ ዙማ ቦላ ኬዚዴስ፤ ኢያርኮፌ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ፑዴ ፒዝጋ ዙማ ጼራ ጋኪዴስ፤ ኢዚ ሄን ዲሺን ጎዳይ ጋላኣዴፔ ቢዲ ዳኔ ጋካናስ ዲዛ ቢታ ኡባ ቤሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","ኒፍታሌሜ ቢታ፥ ኤፍሬሜኔ ሚናሴ ቢታ ኡባ ኣርሼይ ዉሊዛ ባጋራ ዲዛ ዎጋ ጊታ ኣባ ጋጻ ጋካናስ ዲዛ ዩሁዳ ቢታ፥ ");
INSERT INTO gmve_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","ኔጌቤኔ ዛምባይ ዲዛ ኢያርኮ ሾባፌ ቢዲ ዞኣሬ ጋካናስ ዲዛሶ ኡባ ቤሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","ጎዳይ ሙሴስ፥ «ኣብራሜስ፥ ዪሳቃሲኔ ያቆቤስ፥ ‹ታ ኢንቴ ዜሬꬃታ ላቲሳና› ጋ ጫቂዳ ቢታያ ሃኖኮ! ሄኮ ኔኒ ኔ ኣይፌራ ቤኣና ማላ ኦꬃዲስ፤ ጊዶ ኣቲን ኔ ጌላካ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","ሄሳ ጊሻስ ጎዳ ኦሳንቻ ሙሴይ ሞኣቤ ቢታን ዲሼ ጎዳይ ኢዛስ ዮቲዳ ማላ ሄን ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","ጎዳይ ሙሴ ኣሃ ሞኣቤ ዴሬን ዲዛ ቤቲ-ፔኦሬ ካታማፔ ሲንꬃን ዲዛ ሾባን ሞጊዴስ፤ ጊዶ ኣቲን ኢዚ ሞጌቲዳሶ ሻኪ ኤሪዛ ኣሲ ሃች ጋካናስ ቤቲቤና። ");
INSERT INTO gmve_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","ሙሴይ ሃይቂሺን ኢዛስ ላይꬃይ 120፤ ጊዶ ኣቲን ኢዛ ኣይፌይ ዶልጁሚቤና፤ ኢዛ ዎልቃይካ ዳቡርቤና። ");
INSERT INTO gmve_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","ኢስራኤሌ ኣሳይ ሙሴስ ሚቻይ ኣꬋና ጋካናስ ሄꬑ ታሙ ጋላስ ጋካናስ ሞኣቤ ዴምባን ካዮቲሼ ዬኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","ባ ኦላን ኢዚ ኦꬃና ማላ ሙሴይ ናዌ ና ኢያሶ ቦላ ባ ኩሼ ዎꬂዲ ሹሚዳ ጊሻስ ኢያሶይ ኣꬎ ኤራቴꬃኒኔ ኣያናን ኩሚዴስ፤ ኢስራኤሌ ኣሳይ ኢያሶስ ኣዛዜቲዴስ፤ ጎዳይ ሙሴ ባጋራ ኢስታስ ኢሚዳ ኣዛዞዛካ ናጊዳ። ");
INSERT INTO gmve_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","ኣሲ ኣሳራ ሃሳይዛ ማላ ጎዳራ ሃሳይዳ ሙሴ ማላ ናቤይ ኢስራኤሌ ቢታን ዴንዲቤና። ");
INSERT INTO gmve_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","ጎዳይ ጊብጼ ካዎዛኮ፥ ኢዛራ ኦꬂዛ ሃላቃታኮኔ ኩሜꬃ ኣሳኮ ዬዲዲ ኢዛ ባጋራ ኦራꬂኔ ማላሊሲዛ ሚሽ ኡባ ኦꬂዳ ሙሴ ማላ ሃራ ናቤይ ኦኒካ ዴና። ");
INSERT INTO gmve_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","ሙሴይ ኢስራኤሌ ኣሳ ኡባ ሲንꬃን ኦꬂዳይሳ ማላ ዎልቃማኔ ባቢሲዛ ማላታታ ኦꬂዳ ሃራ ናቤይ ሙሌካ ዴና። ");
INSERT INTO gmve_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","ጎዳ ኣይሌ ሙሴይ ሃይቂዳፔ ጉዬ ጎዳይ ሙሴ ማዲዛ ናዌ ና ኢያሶስ፥ ");
INSERT INTO gmve_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","«ሄኮ ታ ኣይሌ ሙሴይ ሃይቂዴስ፤ ሃኢ ኔኒኔ ሃይሲ ዴሬዚ ዴንዲቴ፤ ታኒ ካሴ ኢስራኤሌ ኣሳስ ኢማና ጊዳ ቢታ ጌላናስ ዮርዳኖሴ ሻፋ ፒኒቴ። ");
INSERT INTO gmve_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","ታኒ ካሴ ሙሴስ ኢሚዳ ሂዶታ ማላ ኢንቴ ቶሆይ ዬꬊዛ ቢታ ኡባ ታ ኢንቴስ ኢማና። ");
INSERT INTO gmve_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","ኢንቴ ቢታ ዛዋይ ባዞፌ ዶሚዲ ሊባኖሴ፥ ዎጋ ሻፋ ኤፊራጺሴፔ ቢዲ ሂቴ ዴሬ ኡባ ኦይኪዲ ኣርሼይ ዉሊዛ ባጋራ ቢዲ ዎጋ ኣባ ጋካናሳ። ");
INSERT INTO gmve_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","ኔኒ ዲዛ ዎዴ ኡባን ኔናራ ኦኒካ ኤቄታና ዳንዳዬና፤ ታኒ ካሴ ሙሴራ ጊዲዳ ማላ ኔናራካ ጊዳና፤ ሙሌካ ታ ኔና ዬጊኬኔ ኣጊኬ። ");
INSERT INTO gmve_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","«ሚና! ጻላ ጊዳ፤ ታኒ ካሴ ኢስታ ኣዋታስ ኢማና ጋዳ ጫቂዳ ቢታ ሃ ዴሬዛ ካሌꬃዳ ላቲሳናይ ኔና ጊዲዳ ጊሻስ ሚና። ");
INSERT INTO gmve_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","ኣይኮይ ባ፤ ኔኒ ሚኖ ጻላ ሚና፤ ታ ኣይሌ ሙሴይ ኔስ ኢሚዳ ዎጋዛ ኡባ ሎኤꬃ ኣዛዜታ፤ ኔ ቢዳሶ ኡባን ጊጋ ጊዳና ማላ ሃዲርስ ኡሻች ጎፓ። ");
INSERT INTO gmve_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","ሃይሲ ዎጋ ማጻፋይ ኔ ዶናፔ ሻኬቶፎ፤ ኢዛ ጊዶን ዲዛይሳ ኔ ሎኤꬃ ናጌታዳ ፖላና ማላ ጋላስ ጊዲን ኦማርስ ዛራ ዛራ ቆፓ፤ ኔ ሄሳꬆ ኦꬂኮ ኔ ቆፒዳ ኡባይ ኔስ ሱራናኔ ሃናና። ");
INSERT INTO gmve_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","ኔኒ ቢዛሶን ኡባን ጎዳ ኔ ጾሳይ ኔናራ ዲዛ ጊሻስ ኣይኮይ ባ፥ ሚና፥ ያዮፋ፥ ዳጋሞፋ ጋዳ ታ ኔና ኣዛዛቤኪና!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","ሄሳፌ ካሊዲ ኢያሶይ ኢስራኤሌ ኣሳ፥ ");
INSERT INTO gmve_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","«ኢንቴ ጌዴ ኣሳይ ዲዛሶ ቢዲ፥ ‹ኢንቴ ሄꬑ ጋላሳፌ ጉዬ ካሴ ጎዳ ኢንቴ ጾሳይ ኢንቴና ላቲሳናስ ኢንቴስ ኢሚዛ ቢታዮ ላታናስ ዮርዳኖሴ ፒናና ጊሻስ ኢንቴስ ሺንቄ ጊግሲቴ› ጊ ዮቲቴ» ጊ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","ኢያሶይ ኦሮቤሌ ቆሞታስ፥ ጋዴ ቆሞታስ፥ ሄሳꬆካ ሚናሴ ቆሞታፔ ባጋይታስ፥ ");
INSERT INTO gmve_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","«ጎዳ ኣይሌ ሙሴይ፥ ‹ጎዳ ኢንቴ ጾሳይ ኢንቴና ሼምፒሳና፤ ሃኖ ቢታዮካ ኢዚ ኢንቴስ ኢማና› ጊ ኢሚዳ ኣዛዞዛ ኣኬኪቴ። ");
INSERT INTO gmve_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","ኢንቴ ማቼቲ፥ ኢንቴ ናይቲኔ ኢንቴ ሜሄቲካ ካሴ ሙሴይ ኢንቴስ ዮርዳኖሴ ሻፋፔ ሄ ፒንꬃን ኢሚዳሶን ሄን ዲሼቶ፤ ጊዶ ኣቲን ኢንቴ ኦላ ኣሳይ ኡባይ ኩሜꬅ ኦላ ሚሻራ ኢንቴ ባጋታ ኢስራኤሌ ኣሳ ማዳናስ ካሴቲዲ ዮርዳኖሴ ፒኔቶ፤ ኢንቴካ ኢንቴ ኢሻታራ ኢሲፌ ኦላስ ኬዚቴ። ");
INSERT INTO gmve_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","ሄሲካ ጎዳይ ኢስታ ሼምፒሳና ጋካናሲኔ ኢንቴስ ኢዚ ኦꬆይሳꬆ ኢስቲካ ጎዳ ኢንቴ ጾሳይ ኢስታስ ኢሚዳ ቢታ ጋኪ ላታና ጋካናሳ፤ ሄሳፌ ጉዬ ኢንቴ ሲሚ ዪዲ ኣርሼይ ሞኪዛ ባጋራ ዮርዳኖሴ ሻፋፔ ሄ ፒንꬃን ጎዳ ኣይሌ ሙሴይ ኢንቴስ ኢሚዳ ቢታ ኢንቴ ላታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","ኢስቲካ ኢያሶስ፥ «ኔኒ ኑስ ዮቶይሳ ኑኒ ኡባ ፖላና፤ ኔ ኪቲዛሶ ኣዋካ ባና። ");
INSERT INTO gmve_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","ኑኒ ሙሴስ ኡባ ዎዴ ኣዛዜቲዳ ማላ ኔስካ ኣዛዜታና፤ ጎዳ ኔ ጾሳይ ካሴ ሙሴራ ጊዲዳ ማላ ኔናራካ ኢዚ ጊዶ! ");
INSERT INTO gmve_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","ኔናራ ኤቄቲዛዴይኔ ኔስ ኣዛዜቶንታዴ ኡባይ ሃይቆ፤ ኔ ሚና፤ ኣይኮይ ባ፥ ኔ ሚኖ ሚና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","ናዌ ና ኢያሶይ ቢታ ዎቺዛ ናምኡ ኣሳታ ሺጺሜ ጌቴቲዛሶፔ ቆታን ኪቲዴስ፤ ኪቲሼ ኢስታስ፥ «ቢቴ፤ ቢዲ ቢታ ዎቺቴ፤ ሃራፔካ ኢያርኮ ካታማ ዱማሲ ዎቺቴ» ጊዴስ። ሂስቲን ኢስቲ ቢዲ ኤራኣቦ ጌቴቲዛ ላይማ ማጫሳይ ሶ ጌሊዲ ኣቂዳ። ");
INSERT INTO gmve_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","ሂስቲን ኢያርኮ ካዎይ፥ «ኢስራኤሌ ኣሳፔ ኪቴቲዳይቲ ሃ ቢታ ዎቻናስ ኦማርስ ዪዳ» ጊዛ ዮኦ ሲዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","ኢያርኮ ካዎይ ኤራኣቢኮ፥ «ኔ ሶ ዪ ጌሊዳ ኣሳታ ኬሳ ኢማ። ኣይስ ጊኮ ኢስቲ ቢታ ኡባ ዎቻናስ ዪዳ» ጊዛ ኪታ ዬዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","ጊዶ ኣቲን ሚሺሬያ ሄ ናምኡ ኣሳታ ቆታ ዎꬃዳ፥ «ኤ ኣሳቲ ታኮ ዪዳኮሺን ኢስቲ ኣዋፔ ዪዳኮ ታ ኤራቤኬ። ");
INSERT INTO gmve_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","ኦማርስ ካታማ ፔንጌ ጎርዳና ጊዛ ዎዴ ኢስቲ ኬዚ ቢዳ፤ ኢስቲ ኣዋ ቢዳኮ ታ ኤሪኬ፤ ኤሶቲዲ ካሊዛ ጊዲኮ ኢንቴ ኢስታ ኦይካና» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","ጊዶ ኣቲን ኤራኣባ ኣሳታ ፖቄ ማላ ኦሴቲዳሶ ኬሳዳ ሚጬቲዳ ታልባ ቡጻ ጊዶን ኢስታ ቆታ ዎꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","ኣሳቲ ጾሞሲዛይታ ኮያናስ ኬዚዲ ዮርዳኖሴ ሻፋ ፒንꬅ ኤፊዛ ኦጌ ኦይኪዲ ቢዳ፤ ኮይዛይቲ ካታማፔ ኬዚዳ ማላ ካታማ ፔንጌይ ጎርዴቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","ዎቺዛይቲ ꬊስካናፔ ካሴታዳ ኢዛ ኢስታኮ ፑዴ ኬዛዳ ኢስታስ፥ ");
INSERT INTO gmve_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","«ጎዳይ ሃ ቢታ ኢንቴስ ኢሚዳይሳ፥ ኢንቴስ ያሻቴꬂ ኑናን ኩሚዳይሳኔ ሃ ቢታን ዴኢዛ ኣሳ ዎዚናይ ኢንቴስ ሂርጋን ሴሪዳይሳ ታ ኤራይስ። ");
INSERT INTO gmve_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","ጊብጼ ቢታፌ ኢንቴ ኬዚዳ ዎዴ ኢንቴ ሲንꬃን ዞኦ ኣባ ጎዳይ ዎስቲ ሜሊሲዳኮ ኑኒ ሲዪዶስ፤ ቃሴ ዮርዳኖሴ ሻፋፔ ኣርሼ ኬሳሶ ባጋራ ዲዛ ኣሞሬ ቢታ ካዎታ ናምኣታ፥ ሲሆኔኔ ኣጌ ኢንቴ ዎስቲ ኡባ ꬋይሲዳኮ ኑ ሲዪዶስ። ");
INSERT INTO gmve_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","ኑ ሄሳ ሲዪዳ ማላ ኑ ዎዚናይ ሴሪዴስ፤ ኢንቴስ ያሻቴꬃፌ ዴንዲዳይሳን ሺሮቶንታ ኣሲ ዴና፤ ጎዳ ኢንቴ ጾሳይ ቦላ ሳሎንካ ጋርሳ ቢታንካ ኢዚ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","ሄሳ ጊሻስ ታኒ ኢንቴስ ኪዪዳ ማላ ኢንቴካ ታ ኣዋ ኬꬃ ኣሳስ ኪያና ማላ ታስ ጎዳን ጫቂቴ፤ ሄሳስካ ኣማንꬂዛ ማላታ ታስ ኢሚቴ። ");
INSERT INTO gmve_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","ታ ኣዋኔ ታ ኣዪዮ፥ ታ ኢሻታኔ ታ ሚቼታ ኢስታስ ሼምፖራ ዲዛ ኡባ ዎꬎፒቴ፤ ኑና ሃይቆፔ ኣሺቴ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","ሄ ኣሳቲ፥ «ኑ ኔስ ጫቂዳ ቃላ ማላ ፖሎንታ ኣጊኮ ጾሲ ኑና ዎꬎ! ኑ ኦꬂዳይሳ ኔ ኦናስካ ዮቶንታ ኣጊኮ፥ ጎዳይ ሃኖ ቢታዮ ኑስ ኢሚዛ ዎዴ ኑ ኔስ ሎኦ ኦꬃና ማላ ጫቆስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","ኤራኣባ ዲዛ ኬꬃይ ካታማ ዲርሳራ ኦይኬቲ ኬጼቲ ኡቲዳ ጊሻስ ኣሳታ ዎዶሮን ቃቻዳ ማስኮቴራ ዱጌ ዎꬃዱስ። ");
INSERT INTO gmve_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","ኤራኣባ ኢስታስ፥ «ኢንቴና ኮይዛይቲ ዴሞንታ ማላ ፑዴ ዙምቡላታ ቦላ ኬዚዲ ሄን ሄꬑ ጋላስ ቆቴቲቴ፤ ሄሳፌ ጉዬ ኢንቴ ባናሶ ቢቴ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","18","ኣሳቲካ ኢዚስ፥ «ኑኒ ኔ ቢታ ጌሊዛ ዎዴ ሃ ዞኦ ዎዶሮዛ ኔኒ ኑና ኬሲዳ ማስኮቴ ቦላ ቃቾንታ ኣጊኮ ኔ ኣዋ፥ ኔ ኣዪዮ፥ ኔ ኢሻታኔ ኔሶ ኣሳ ኡባ ኔሶ ኤሆንታ ኣጊኮ ኔኒ ኑና ጫቂሲዳ ጫቆይ ኑስ ጎሜቴና። ");
INSERT INTO gmve_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","ኦኒካ ኔ ኬꬃፌ ካሬ ኬዚ ኦጌ ቦላ ቤቲ ሃይቂኮ ሄሲ ኢዛ ጎሜ፤ ኑኒ ሄሳን ኦይሼቶኮ፤ ጊዶ ኣቲን ኔናራ ሶን ኢሲፌ ዲዛይ ኦኒካ ቦሼቲኮ ኢዛ ሱꬃ ጎሜይ ኑና ጋኮ። ");
INSERT INTO gmve_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","ኑ ኦꬂዛይሳ ኔ ሃራስ ዮቲዛ ጊዲኮ ኔኒ ኑና ጫቄꬂዳ ጫቆይ ኑስ ጎሜቴና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","ኢዛካ፥ «ኢንቴ ጊዳ ማላ ሃኖ» ጋዳ ኢስታ ሞይዛዱስ፤ ኢስቲ ቢዳፔ ጉዬ ዞኦ ዎዶሮ ባ ማስኮቴ ቦላ ቃጳዱስ። ");
INSERT INTO gmve_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","ኢስቲ ፑዴ ዙምቡላታኮ ቢዳ፤ ጎዴꬂዛይቲ ኢያርኮ ሲማና ጋካናስ ሄን ሄꬑ ጋላስ ቆቴቲዳ። ጎዴꬂዛይቲ ኦጌ ኡባን ኮዪዳ ሺን ኢስቲ ዴሚቤቴና። ");
INSERT INTO gmve_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","ሄሳፌ ጉዬ ሄ ናምኡ ኣሳቲ ዙምቡላታፔ ዎꬊ ዮርዳኖሴ ሻፋ ፒኒዲ ናዌ ና ኢያሶኮ ቢዲ ባና ጋኪዳ ኡባ ኢዛስ ዮቲዳ። ");
INSERT INTO gmve_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","ኢስቲ ኢያሶስ፥ «ጎዳይ ቱማፔ ቢታ ኡባ ኑስ ኣꬂ ኢሚዴስ፤ ቃሴ ሄ ቢታን ዲዛ ኣሳይ ዉሪ ኑስ ያሻቴꬃፌ ዴንዲዳይሳን ኢስታ ዎዚናይ ሴሪዳይሳ ኑ ቤኢዶስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","ኢያሶይኔ ኢስራኤሌ ኣሳይ ማላዶ ዎንታራ ዴንዲዳ፤ ኢስቲ ሺጺሜ ጌቴቲዛሶፔ ዴንዲዲ ዮርዳኖሴ ሻፋኮ ቢዲ ፒኖንታ ሄን ታኪዳ። ");
INSERT INTO gmve_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","ሄꬑ ጋላሳፌ ጉዬ ኦላ ጋዳዋቲ ኢስቲ ዱንካኒዳሶን ጌሊዲ፥ ");
INSERT INTO gmve_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","ኣሳስ፥ «ጎዳ ኢንቴ ጾሳ ጫቆ ቃላ ታቦታኔ ኢዛ ቶኪዳ ሌዌ ዛሬ ቄሴታ ቤኢዛ ዎዴ ኢንቴ ዱንካኒዳሶፔ ዴንዲዲ ኢስታ ካሊቴ። ");
INSERT INTO gmve_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","ኢንቴ ካሴ ሄ ኦጌራ ቢ ኤሮንታ ጊሻስ ኢንቴ ባና ኦጌ ኢስቲ ኢንቴና ቤሳና፤ ጊዶ ኣቲን ጫቆ ቃላ ታቦታኮ ሺቆፒቴ፤ ጫቆ ቃላ ታቦታፔ 2,000 ዋꬋ ጊዲዛይሳ ማላ ሃሆን ኤቂቴ» ጊ ኣዛዞ ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","ኢያሶይ ኣሳ፥ «ጎዳይ ዎንቶ ኢንቴ ጊዶን ማላሊሲዛዝ ኦꬃና ጊሻስ ኢንቴ ጌይቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","ቃሴካ ኢያሶይ ቄሴታስ፥ «ኢንቴ ጫቆ ቃላ ታቦታ ቶኪዲ ኣሳፔ ሲንꬄ ኣꬊቴ» ጊ ዮቲዴስ፤ ኢስቲ ጫቆ ቃላ ታቦታ ቶኪዲ ዴራፔ ሲንꬄ ሲንꬄ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","ጎዳይ ኢያሶስ፥ «ታኒ ሙሴራ ጊዲዳ ማላ ኔናራ ጊዳናይሳ ኢስራኤሌ ኣሳይ ዉሪ ኤራና ማላ ሃች ኢስታ ሲንꬃን ታኒ ኔና ꬎቁ ꬎቁ ኦꬃናስ ዶማና። ");
INSERT INTO gmve_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","ኔኒ ጫቆ ቃላ ታቦታ ቶኪዛ ቄሴታ፥ ‹ዮርዳኖሴ ሻፋ ዶና ጋኪዛ ዎዴ ሃꬃን ጌሊዲ ኤቂቴ› ጋዳ ኣዛዛ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","ኢያሶይ ኢስራኤሌ ኣሳ፥ «ሃ ዪቴ፤ ዪዲ ጎዳ ኢንቴ ጾሳ ቃላ ሲዪቴ። ");
INSERT INTO gmve_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","ዴኦ ጾሲ ኢንቴ ጊዶን ዲዛይሳኔ ኢዚ ቱማፔ ካናኔታ፥ ሂቴታ፥ ሂዌታ፥ ፓሪዜታ፥ ጌርጌሴታ፥ ኣሞሬታኔ ያቡሴታ ኢንቴ ሲንꬃፌ ኬሳናይሳ ኢንቴ ሄሳን ኤራና። ");
INSERT INTO gmve_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","ሳኣ ኡባ ጎዳ ጫቆ ቃላ ታቦታይ ኢንቴፌ ሲንꬃቲዲ ዮርዳኖሴ ሻፋ ጌላና። ");
INSERT INTO gmve_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","ሃኢ ኢስራኤሌ ዛሬታፔ 12 ኣሳታ ዶሪቴ፤ ኢሲ ኢሲ ዛሬፔ ኢሲ ኢሲ ኣስ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","ሳኣ ኡባ ጎዳ ጫቆ ቃላ ታቦታ ቶኪዳ ቄሴታ ቶሆይ ዮርዳኖሴ ሃꬃ ቦቺዳ ማላ ፑዴሃፔ ዱጌ ጎጊዛ ዮርዳኖሴ ሃꬂ ሄራካ ጎጌꬃ ኣጋጋና፤ ዶሬ ማላ ጊዲ ኤቃ ጋና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","ኣሳይ ዮርዳኖሴ ሻፋ ፒናናስ ባ ዱንካኔፔ ኬዚዳ ዎዴ ጫቆ ቃላ ታቦታ ቶኪዳ ቄሴቲ ኣሳፔ ሲንꬃቲ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","ካꬃ ሺሾ ዎዴን ኡባን ዮርዳኖሴ ሻፋይ ኪጼስ፤ ጊዲኮካ ጫቆ ቃላ ታቦታ ቶኪዳ ቄሴቲ ዮርዳኖሴ ሻፋ ጋኪዲ ኢስታ ቶሆይ ሃꬃ ጋጻ ዬꬊዳ ማላ፥ ");
INSERT INTO gmve_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","ጎጊዛ ሃꬃይ ኤቂዴስ፤ ሄን ዳሮ ሃሆሶን ጳርታኔ ማታን ዲዛ ኣዳሜ ጌቴቲዛ ካታማ ጋካናስ ኢሲሶ ሺቂዲ ዶሬቲዴስ፤ ዱጌ ኣራቤ ጋꬋን ዲዛ ማጺኔ ኣባን ጎጊዛ ሃꬂ ኡባይ ዱጺ ኣቲዴስ፤ ሂስቲን ኣሳይ ኢያርኮ ካታማ ጊናራ ፒኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","ኢስራኤሌ ኣሳይ ሜላ ቢታ ዬꬊ ፒኒዛ ዎዴ ኣሳይ ዉሪ ፒናና ጋካናስ ጎዳ ጫቆ ቃላ ታቦታ ቶኪዳ ቄሴቲ ዮርዳኖሴ ሻፋ ጊዶን ሜላ ቢታን ኤቃ ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","ካዎቴꬃይ ዉሪ ዮርዳኖሴ ሻፋ ፒኒዳፔ ጉዬ ጎዳይ ኢያሶ፥ ");
INSERT INTO gmve_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","«ኢስራኤሌ ኣሳፔ 12 ኣሳታ ዶራ፤ ኢሲ ኢሲ ቆሞፌ ኢሲ ኢሲ ኣስ ጊዶ። ");
INSERT INTO gmve_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","ሂስታዳ ኢስታስ፥ ‹ዮርዳኖሴ ሻፋ ጊዶን ቄሴታ ቶሆይ ኤቂዳሶፔ 12 ሹቻታ ኤኪቴ፤ ሄ ሹቻታ ቶኪ ኤፊዲ ሃች ኢንቴ ኣቂዛሶን ዎꬂቴ› ጋዳ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","ሄሳ ጊሻስ ኢያሶይ ኢስራኤሌ ቆሞታፔ ኢሲ ኢሲ ኣስ ኤኪዲ ታማኔ ናምኡ ዶሬቲዳይታ ጼይጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","ሂስቲዲ ኢስታስ፥ «ጎዳ ኢንቴ ጾሳ ጫቆ ቃላ ታቦታይ ዲዛሶሆ ዮርዳኖሴ ሻፋ ጌሊቴ፤ ኢስራኤሌ ቆሞታ ቆዳን ዉሪካ ኢሲ ኢሲ ሹች ኢንቴ ሃሼን ሃሼን ቶኪቴ። ");
INSERT INTO gmve_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","ሃ ሹቻቲ ጎዳይ ሃች ኦꬂዳይሳ ኢንቴና ሃሳኢሲዛ ማላታ ጊዳና፤ ዎዴፔ ኢንቴ ናይቲ ኢንቴና፥ ‹ሃ ሹቻቲ ኣዜ?› ጊዲ ኦይቺዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","ኢንቴ፥ ‹ጎዳ ጫቆ ቃላ ታቦታይ ፒኒዛ ዎዴ ዮርዳኖሴ ሻፋይ ጎጊዛይሳ ኣጊ ኤቂዴስ፤ ሃ ሹቻቲ ሄ ሶሆን ሃኒዳይሳ ኡባ ሜርናስ ኢስራኤሌ ኣሳ ሃሳኢሲዛይታ› ጊዲ ኢስታስ ዮቲቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","ኢስራኤሌ ኣሳይ ኢያሶይ ኣዛዚዳ ማላ ኦꬂዴስ፤ ጎዳይ ኢያሶስ ዮቲዳ ማላ ኢስራኤሌ ቆሞታ ቆዳን 12 ሹቻታ ዮርዳኖሴ ሻፋ ጊዶፌ ኤኪዳ፤ ቶኪ ኤሂዲ ባ ኣቂዳ ሶሆን ዎꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","ኢያሶይ ጫቆ ቃላ ታቦታ ቶኪዳ ቄሴታ ቶሆይ ዮርዳኖሴ ሻፋ ጊዶን ኤቂዳሶን 12 ሹቻታ ኤሲዴስ፤ ሄ ሹቻቲ ሃች ጋካናስ ሄን ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","ጎዳይ ኢያሶ ኣዛዚዳይሳ ኡባ ኣሳይ ፖላና ጋካናስ ጫቆ ቃላ ታቦታ ቶኪዳ ቄሴቲ ዮርዳኖሴ ሻፋ ጊዶን ኤቂ ጋምኢዳ፤ ሙሴይ ኢያሶ ኣዛዚዳ ኣዛዞይካ ሄሳ፤ ኣሳይ ኤሶቲዲ ሻፋ ፒኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","ኣሳይ ዉሪ ፒኒዳፔ ጉዬ ጎዳ ጫቆ ቃላ ታቦታይኔ ቄሴቲ ኣሳይ ኢስታ ጼሊሺን ፒኒዳ። ");
INSERT INTO gmve_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","ሙሴይ ኣዛዚዳ ማላ ኦሮቤሌ ዛሬቲ፥ ጋዴ ዛሬቲኔ ሚናሴ ዛሬታፔ ባጋይ ኦላ ሚሻ ኦይኪዲ ኢስራኤሌ ኣሳፔ ሲንꬃቲዲ ፒኒዳ። ");
INSERT INTO gmve_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","ቆዳን 40,000 ጊዲዛ ኣሳይ ቶራኔ ጎንዳሌ ኦይኪ ኦላስ ጊጌቲዲ ጎዳ ሲንꬃን ኢያርኮ ማታን ዲዛ ዴምባ ፒኒዳ። ");
INSERT INTO gmve_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","ሄ ጋላስ ጎዳይ ኢያሶ ኢስራኤሌ ኣሳ ኡባ ሲንꬃን ꬎቁ ꬎቁ ሂስቲዴስ፤ ኣሳይ ሙሴ ቦንቺዳ ማላ ኢያሶካ ኢዚ ዲዳ ላይꬅ ኡባን ቦንቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","ሄሳፌ ጉዬ ጎዳይ ኢያሶስ፥ ");
INSERT INTO gmve_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","«ጫቆ ቃላ ታቦታ ቶኪዳ ቄሴቲ ዮርዳኖሴ ሻፋፔ ኬዛና ማላ ኣዛዛ» ጊ ዮቲን፥ ");
INSERT INTO gmve_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","ኢያሶይ ቄሴታ፥ «ዮርዳኖሴ ሻፋፔ ኬዚቴ» ጊ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","ጎዳ ጫቆ ቃላ ታቦታ ቶኪዳ ቄሴቲ ዮርዳኖሴ ሻፋ ጊዶፌ ኬዚዲ ሜላ ቢታ ኢስቲ ዬꬊዳ ማላ ሄራካ ዮርዳኖሴ ሃꬃይ ካሴ ማላ ሻፋ ኩሚዲ ጎጌꬅ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","ኣሳይ ኮይሮ ኣጊናን ታማንꬃ ጋላሳን ዮርዳኖሴ ሻፋ ፒኒዲ ኢያርኮን ኣርሼይ ሞኪዛሶ ባጋራ ዛዋቲዛ ጌልጌላን ዱንካኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","ኢያሶይ ዮርዳኖሴ ሻፋፔ ኤሂዳ 12 ሹቻታ ጌልጌላን ኤሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","ኢስራኤሌ ኣሳስ፥ «ዎዴፔ ኢንቴ ዛሬቲ ባ ኣዋታ፥ ‹ሃ ሹቻቲ ኣዜ?› ጊ ኦይቺዛ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","‹ኢስራኤሌ ኣሳይ ዮርዳኖሴ ሻፋ ሜላ ቢታ ዬꬊዲ ፒኒዳይሳ ሃሳኢሲዛይሳ› ጊዲ ዮቲቴ። ");
INSERT INTO gmve_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","ኑኒ ፒናና ጋካናስ ጎዳ ኑ ጾሳይ ዞኦ ኣባ ካሴ ኑ ሲንꬃን ሜሊሲዳ ማላ ኢንቴካ ፒናና ጋካናስ ጎዳ ኢንቴ ጾሳይ ዮርዳኖሴ ሻፋ ኢንቴ ሲንꬃን ሜሊሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","ሄሳꬆ ኢዚ ኦꬂዳይ ሳኣን ዲዛ ኣሳይ ዉሪ ጎዳ ዎልቃይ ኣይ ማላ ጊታኮ ኤራናሲኔ ኢንቴካ ጎዳስ ኢንቴ ጾሳስ ሜርናስ ያያናሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","ዮርዳኖሴ ሻፋፔ ኣርሼይ ዉሊዛ ባጋራ ዲዛ ኣሞሬታ ካዎቲኔ ሜዲቴራኔ ኣባ ላንቄ ላንቄ ኦይኪዲ ዲዛ ካናኔታ ካዎቲ ዉሪ ኢስራኤሌ ኣሳይ ፒናና ጋካናስ ጎዳይ ዮርዳኖሴ ሻፋ ሃꬃ ሜሊሲዳይሳ ሲዪዳ ዎዴ ኢስታ ዎዚናይ ባቦን ሴሪዴስ። ሂስቲን ኢስቲ ኢስራኤሌ ኣሳራ ኤቄታናስ ጻሊቤቴና። ");
INSERT INTO gmve_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","ሄ ዎዴ ጎዳይ ኢያሶስ፥ «ሳሎ ሹቻ ቃራ ኤካዳ ቃጻሬቶንታ ኢስራኤሌ ኣቱማ ኣሳ ናምኣንꬆ ቃጻራ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","ሂስቲን ኢያሶይ ሳሎ ሹች ቃራሲዲ ጊቢኣዜ ኤሎቴ ጌቴቲዛሶን ኢስራኤሌ ኣቱማሳ ቃጻሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","ኢዚ ሄሳ ኦꬂዳ ጋሶይካ ጊብጼፔ ኬዚዳ ኣሳን ላይꬃይ ኦላስ ጋኪዳ ኣቱማ ኣሳይ ዉሪ ጊብጼፔ ኬዚዳፔ ጉዬ ባዞን ኦጌ ቦላ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","ጊብጼፔ ኬዚዳ ኣቱማ ኣሳይ ዉሪ ቃጻሬቲዴስ፤ ጊዶ ኣቲን ባዞን ዩዪዛ ዎዴ ዬሌቲዳ ኣቱማ ናይታፔ ኢሶይካ ቃጻሬቲቤና። ");
INSERT INTO gmve_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","ኢስራኤሌ ካዎቴꬃይ ጎዳስ ኣዛዜቶንታ ኢጺዳ ጊሻስ ጊብጼፔ ኬዚዛ ዎዴ ላይꬃይ ኦላስ ጋኪዳ ኣቱማ ኣሳይ ዉሪ ሃይቂዲ ዉራና ጋካናስ ባዞን 40 ላይꬅ ዩዪዴስ፤ ሄሳን ጎዳይ ኢስታስ፥ «ኤሲኔ ማꬂ ጎጊዛ ኣራዳ ቢታ ታኒ ካሴ ኢንቴ ኣዋታስ ኢማና ጊዳ ሄ ቢታ ኢንቴ ቤዬኬታ» ጊዳ ቃላይ ፖሌታናሳ። ");
INSERT INTO gmve_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","ሄሳ ጊሻስ ጎዳይ ኢስታ ናይታ ኢስታሶሆን ዴንꬂዴስ፤ ኢያሶይ ቃጻራ ጌልꬂዳይቲ ሄይታንታ፤ ኢስቲ ኦጌ ቦላ ሄሜቲሼ ዲዛ ጊሻስ ቃጻሬቲቤቴና። ");
INSERT INTO gmve_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","ካዎቴꬃይ ዉሪ ቃጻሬቲዳፔ ጉዬ ማዱንꬃይ ፓጻና ጋካናስ ባ ዱንካኒ ዲዛሶን ታኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","ጎዳይ ኢያሶስ፥ «ሃች ታኒ ጊብጼታ ቦሬ ኢንቴፌ ጌንዴሪሳ ዲጋዲስ» ጊዴስ፤ ሂስቲን ሄ ሶሆዛ ሱንꬃይ ሃች ጋካናስ ጌልጌላ ጌቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","ኢስራኤሌ ኣሳይ ኢያርኮ ዴምባን ጌልጌላን ዱንካኒ ዲሼ ኣጊናይ ጌሊን ታማኔ ኦይዳንꬃ ጋላሳ ኦማርስ ፓዚጋ ባኣሌ ቦንቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","ፓዚጋፔ ጉዬ ዎንቴꬃ ጋላስ ቢታን ሞኪዳ ካꬃ ኣይፌፔ ኢርሾይ ጌሎንታ ኡኬቲዳይሳኔ ጫጬቲዳ ቲያ ሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","ሄ ቢታን ሞኪዳ ካꬃ ኣይፌ ሚዳ ጋላስ ማናይ ዩስ ኣጊዴስ፤ ሄሳፌ ጉዬ ኢስራኤሌ ኣሳስ ማናይ ዪቤና፤ ጊዶ ኣቲን ሄ ዎዴፔ ዶሚዲ ኢስቲ ካናኔን ሞኪዳ ካꬅ ሚሼ ዴኢዳ። ");
INSERT INTO gmve_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","ኢያሶይ ኢያርኮ ማታን ዲሼ ꬎቁ ጊ ጼሊዲ ጊꬃ ማሻ ሾዲ ኦይኪዳ ኢሲ ኣሲ ኢዛ ሲንꬃን ኤቂዳይሳ ቤኢዴስ፤ ኢያሶይ ኢዛኮ ሺቂዲ፥ «ኔኒ ኑ ባጋዬ ኑ ሞርኬታ ባጋ?» ጊ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","ኢዚካ፥ «ታ ኦና ባጋካ ጊዲኬ፤ ጊዶ ኣቲን ታኒ ጎዳ ኦላንቻታ ጋዳዋ ጊዲዳ ጊሻስ ያዲስ» ጊ ዛሪዴስ። ኢያሶይካ ሳኣን ጉፋኒ ጎይኒዲ፥ «ታ ጎዳዉ! ታስ ኔ ኣይሌዛስ ኔ ኣይ ዮታኔ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","ጎዳ ኦላንቻታ ጋዳዋይ፥ «ኔኒ ኤቂዳሶይ ጌሽ ጊዲዳ ጊሻስ ኔ ቶሆፔ ጫማ ኬሳ» ጊዴስ፤ ሂስቲን ኢያሶይ ኢዚ ኣዛዚዳ ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","ኢስራኤሌ ኣሳስ ያዪዳ ጋሶን ኢያርኮ ካታማ ዲርሳ ፔንጌቲ ጎርዴቲዳ፤ ካታማ ጌላናሲኔ ካታማፔ ኬዛናስ ዳንዳይዛይ ኦኒካ ዴና። ");
INSERT INTO gmve_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","ጎዳይ ኢያሶስ፥ «ሄኮ ታኒ ኢያርኮ ካታማዮ ኢዚ ካዎዛራ ኢዚ ሚኖ ኦላንቻታራካ ኔ ኩሼን ኣꬃ ኢማዲስ። ");
INSERT INTO gmve_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","ኔኒኔ ኔ ኦላንቻቲ ጪፍሪዲ ኡሱፑን ጋላስ ጋካናስ ሃች ሃች ካታማ ዲርሳ ኢሲቶ ዩዪ ኣꬊቴ። ");
INSERT INTO gmve_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","ቃሴ ላፑን ቄሴቲ ላፑን ዛዬታ ኦይኪዲ ጎዳ ጫቆ ቃላ ታቦታ ሲንꬅ ኣꬌቶ፤ ላፑንꬃ ጋላስ ቄሴቲ ዛዬታ ፑኒሺን ኦላንቻቲ ጪፍሪዲ ኢሲፌ ካታማዮ ላፑንቶ ዩዪ ኣꬌቶ። ");
INSERT INTO gmve_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","ሄሳፌ ጉዬ ዛዬይ ቃንጾይ ባይንዳ ፑኔቲዛይሳ ሲዪዳ ማላ ኣሳይ ዉሪ ባ ቃላ ꬎቁ ሂስቲ ዋሶ፤ ሂስቲዳ ማላ ካታማይ ጊምቤይ ላሌታና፤ ኣሳይ ዉሪ ላዉሁ ጊ ኬኢዲ ካታማይ ጊዶ ሲቲ ጊ ጌላና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","ናዌ ና ኢያሶይ ቄሴታ ጼይጊዲ፥ «ጎዳ ጫቆ ቃላ ታቦታ ቶኪቴ፤ ኢንቴፌ ላፑን ቄሴቲ ላፑን ዛዬታ ኦይኪዲ ጫቆ ቃላ ታቦታፔ ሲንꬄ ኣꬊ ቢቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","ዴሬዛካ፥ «ጌዴ ሲንꬄ ቢቴ፤ ካታማ ዩዪ ኣꬊቴ፤ ኦላንቻቲካ ጎዳ ጫቆ ቃላ ታቦታፔ ሲንꬃቲ ቤቶ፤ ካታማዮካ ዩዪቴ» ጊዲ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","ኢያሶይ ኣሳስ ሃሳይዳ ማላ ላፑን ቄሴቲ ላፑን ዛዬታ ጎዳ ሲንꬃን ኦይኪዲ ፑኒሼ ሲንꬃቲ ቢዳ፤ ቃሴ ጎዳ ጫቆ ቃላ ታቦታይ ኢስታ ካሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","ኦላስ ጊጌቲዳይቲ ዛዬታ ፑኒዛ ቄሴታፔ ሲንꬃራ ቢሺን ጉዬራ ናጊዛ ኦላንቻቲ ጫቆ ቃላ ታቦታ ካሊዳ፤ ሄ ዎዴ ዛዬይ ቃንጾይ ባይንዳ ፑኔቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","ጊዶ ኣቲን ኢያሶይ ኣሳ፥ «ታኒ ኢንቴና፥ ‹ዋሲቴ!› ጋና ጋላሳይ ጋካናስ ኦላ ዋሶ ዋሶፍቴ፤ ኢንቴ ቃላይ ሲዬቶፎ፤ ኢሲ ቃላካ ቃቶፍቴ፤ ታ ዋሲቴ ጊኮ ሄ ዎዴ ዋሲቴ!» ጊ ኣዛዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","ሄሳ ጊሻስ ጎዳ ጫቆ ቃላ ታቦታይ ቶኬቲዲ ሄ ካታማ ኢሲቶ ዩዪ ኣꬋና ማላ ኦꬂዴስ፤ ሄሳፌ ጉዬ ኣሳይ ባ ዱንካኒዳሶ ሲሚዲ ኦማርስ ሄን ኣቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","ዎንቴꬃ ጋላስ ኢያሶይ ዎንታቲ ዴንዲዴስ፤ ቄሴቲካ ጎዳ ጫቆ ቃላ ታቦታ ቶኪዳ። ");
INSERT INTO gmve_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","ላፑን ዛዬታ ኦይኪዳ ላፑን ቄሴቲ ሲንꬄ ኣꬊዲ ዛዪሼ ጎዳ ጫቆ ቃላ ታቦታፔ ሲንꬄ ሲንꬄ ቢሼ ዛዬዛ ቃንጾይ ባይንዳ ፑኒዳ፤ ኦላስ ጊጊዳይቲ ኢስታፌ ሲንꬃራ ቢሺን ጉዬራ ናጊዛ ኦላንቻቲካ ጎዳ ጫቆ ቃላ ታቦታ ካሊ ቤቴስ፤ ሄ ዎዴ ቄሴቲ ቃንጾይ ባይንዳ ዛዬ ዛዬቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","ናምኣንꬆ ጋላስ ካታማ ኢሲቶ ዩዪ ኣꬊዲ ባ ዱንካኒዳሶ ሲሚዳ፤ ኡሱፑን ጋላስ ጋካናስ ሄሳꬆካ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","ላፑንꬃ ጋላስ ባዞይ ዞኢሺን ዴንዲዲ ካሴይሳꬆካ ካታማዮ ላፑንቶ ዩዪ ኣꬊዳ፤ ሄ ጋላስ ጻላ ካታማዮ ላፑንቶ ዩዪ ኣꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","ላፑንꬆ ዩዪሼ ቄሴቲ ዛዬታ ፑኒሺን ኢያሶይ ዴራ፥ «ጎዳይ ሃኖ ካታማዮ ኢንቴስ ኣꬂ ኢሚዳ ጊሻስ ዋሲቴ! ");
INSERT INTO gmve_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","ካታማያኔ ካታማይ ጊዶን ዲዛ ኡባይ ጎዳስ ዱማ ጊዲዳ ጊሻስ ኢዞ ሙሌራ ꬋይሲቴ፤ ኑኒ ቢታዮ ዎቻናስ ኪቲዳ ኣሳታ ቆታ ኣሺዳ ጊሻስ ላይማ ማጫስ ኤራኣባኔ ኢዚ ሶን ኢዚራ ኢሲፌ ዲዛ ኣሲ ጻላ ኣታና። ");
INSERT INTO gmve_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","ጊዶ ኣቲን ኢንቴ ጎዳስ ዱማቲዳይሳፌ ኣይኮካ ኤኮንታ ማላ ኢንቴ ሁኤስ ናጌቲቴ፤ ኢንቴ ሂስቶንታ ኣጊኮ ኢስራኤሌቲ ዱንካኒዳሶ ኢታስ ኣꬂ ኢማና፤ ሂስቲዲ ሄ ሶሆዛ ቦላ ሜቶ ጋꬃና። ");
INSERT INTO gmve_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","ቢራይኔ ዎርቃይ ዉሪ ቃሴ ጻርቂማላፔኔ ቢራታፔ ኦሴቲዳ ሚሻቲ ኡባይ ጎዳስ ዱማ ጊዲዳ ጊሻስ ጎዳ ሚንጃ ኬꬅ ጌሎ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","ሄሳ ጊሻስ ዛዬይ ፑኔቲን ኣሳይ ዋሲዴስ፤ ዛዬዚ ፑኔቲሺን ዴሬዚ ባ ቃላ ꬎቁ ሂስቲዲ ዋሲን ካታማ ዲርሳይ ላሌቲዴስ፤ ሄሳፌ ጉዬ ኣሳይ ዉሪ ሲቲ ጊዲ ጌዴ ካታማዮ ጌሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","ካታማን ሼምፖራ ፓጻ ዲዛይታ ኡባ ኦይኪዲ ማጫ፥ ኣቱማ፥ ናይታ፥ ጪማታ፥ ሚዝ፥ ዶርሳኔ ሃሬ ኡባ ቃራ ማሻን ዎꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","ኢያሶይ ቢታ ዎቻናስ ኪቴቲዳ ናምኡ ኣሳታ፥ «ላይማ ማጫስ ኤራኣቢ ሶ ቢቴ፤ ሂስቲዲ ኢንቴ ኢዚስ ጫቂዳ ማላ ኣኔ ኢዞኔ ኢዚ ሶ ኣሳ ኡባ ቆሪ ኬሲቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","ሄሳ ጊሻስ ቢታ ዎቺዳ ኣሳቲ ቢዲ ኤራኣቦ፥ ኢዚ ኣዋ፥ ኢዚ ኣዪዮ፥ ኢዚ ኢሻታኔ ኢዚ ዳቦታ ኡባ ቆሪ ኬሲዳ፤ ኢስራኤሌ ኣሳይ ዱንካኒ ዲዛሶፔ ጋጻራ ዎꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","ሄሳፌ ጉዬ ካታማዮኔ ኢዚ ጊዶን ዲዛ ኡባ ታማን ጹጊዳ፤ ጊዶ ኣቲን ቢራኔ ዎርቃ፥ ጻርቂማላፔኔ ቢራታፔ ኦሴቲዳ ሚሻታ ጎዳ ሚንጃ ኬꬃን ዎꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","ቃሴ ኢያሶይ ላይማ ማጫስ ኤራኣቦ ኢዚ ኣዋ ሶ ኣሳኔ ኢዚራ ዲዛ ዳቦታ ኡባ ኣሺዴስ፤ ጋሶይካ ኢያሶይ ኢያርኮ ካታማዮ ዎቻናስ ኪቴቲዳ ኣሳታ ኢዛ ካሴ ቆታዳ ኣሺዳ ጊሻሳ፤ ኢዚ ዛሬቲ ሃች ጋካናስ ኢስራኤሌ ቢታን ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","ሄ ዎዴ ኢያሶይ፥ «ሃኖ ካታማዮ ዛሪ ኤሲዛ ኣሲ፥ «ጎዳ ሲንꬃን ቃንጌቲዳዴ ጊዶ። ዮች ዬጊዛ ዎዴ ኢዛስ ባይራ ናይ ꬋዮ። ጊምቤታ ኤሲሺን ዉርሴꬃ ናይ ꬋዮ» ጊዲ ቃንጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","ሃ ኡባን ጎዳይ ኢያሶራ ጊዲዴስ፤ ኢያሶ ጎባቴꬃ ዎሬይ ቢታ ኡባ ጋኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","ኢስራኤሌ ኣሳይ ጎዳስ ኣማኔቶንታ ኢጺዲ ፒላ ሚሽ ኤኪዴስ፤ ሄሳ ኤኪዳይ ኣካኔ፤ ኣካኔይ ካርሜ ና፤ ካርሜይ ዚሚሬ ና፤ ዚሚሬይ ዩሁዳ ቆሞፌ ዛራሄ ና፤ ሂስቲን ጎዳ ሃንቆይ ኢስራኤሌ ኣሳ ቦላ ኤጺ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","ኢያሶይ ቤቴሌ ካታማፔ ኣርሼይ ሞኪዛ ባጋራ ቤቲ-ኣዌኔ ማታን ዲዛ ኣዬ ካታማ ኢያርኮፌ ኣስ ኪቲዲ፥ «ጌዴ ኬኢቴ፤ ቢታዮካ ዎቺቴ» ጊዴስ። ኣሳቲካ ቢዲ ኣዬ ካታማ ዎቺዳ። ");
INSERT INTO gmve_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","ዎቺዳ ኣሳቲ ኢያሶኮ ሲሚ ዪዲ፥ «ኣዬ ካታማ ኦላናስ ኡባ ኣሳይ ባናስ ኮሼና፤ ናምኡ ዎይኮ ሄꬑ ሺ ኣስ ዬዳ፤ ኣዬን ጉꬃ ኣሲ ዲዛ ጊሻስ ኣሳይ ዉሪ ዳቡሮፖ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","ሂስቲን 3,000 ጊዲዛ ኣሳይ ኦሌታናስ ኣዬ ካታማ ቢዴስ፤ ጊዶ ኣቲን ኣሳይ ኣዬ ካታማ ኣሳ ሲንꬃፌ ባቃቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","ኣዬ ካታማ ኣሳይ ኢስራኤሌ ኣሳ ካታማ ጊምቤ ፔንጌፌ ቢዲ ሺባርሜ ጋካናስ ዱጉንꬃን ጎዲሼ ሾጪዴስ፤ ኢስታፌ 36 ኣስ ዎꬊዳ፤ ሄሳን ኣሳ ዎዚናይ ሴሪዲ ሃꬃ ማላ ጉኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","ሄሳፌ ጉዬ ኢያሶይ ባ ማይኦ ዳኪዴስ፤ ሂስቲዲ ጎዳ ታቦታ ሲንꬃን ኦማርስ ጋካናስ ጉፋኒዴስ። ኢስራኤሌ ጪማቲካ ሄሳ ማላ ሃኒዳ፤ ባ ሁኤንካ ጉዱላ ማኪዳ። ");
INSERT INTO gmve_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","ሂስቲን ኢያሶይ፥ «ኣዬ ኣና! ኡባ ሃሪዛ ጎዳዉ! ኑና ኣሞሬ ኣሳስ ኣꬃ ኢማዳ ዉርሲሳናስ ኣይስ ዮርዳኖሴ ሻፋ ፒንꬃዳ ኤሃዲ? ኑ ፒኖንታ ሄን ኣቲዳኮ ኣዜ ዲዛይሺን! ");
INSERT INTO gmve_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","ኣቤት ጎዳዉ! ኢስራኤሌ ኣሳይ ጾኔቲዲ ባ ሞርኬታ ሲንꬃፌ ባቃቲዳይሳ ታኒ ኣይ ጎ? ");
INSERT INTO gmve_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","ካናኔ ኣሳይኔ ሃ ቢታን ዲዛ ሃራ ኣሳይ ዉሪ ሃ ዮኦዛ ሲዪዲ ኑና ዶዳና፤ ቢታ ቦላፌ ኑ ሱንꬅ ꬋይሳና፤ ሂስቲን ኔ ጊታ ሱንꬃ ጊሻስ ጋዳ ኔ ኣይ ኦꬃኔ?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","ጎዳይ ኢያሶ፥ «ዴንዳ ኤቃ! ኣይስ ጉፋናዲ? ");
INSERT INTO gmve_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","ኢስራኤሌ ኣሳይ ናጋራ ኦꬂዴስ፤ ታኒ ኢስታራ ጫቄቲዳ ታ ጫቆዛ ሜንꬂዴስ፤ ኢስቲ ፒላ ሚሻታፔ ኤኪዳ፤ ካይሶቲዳ፤ ዎርዶቲዳ፤ ቃሴ ባንቲ ኤኪዳይሳ ባንታ ሚሻራ ዋላኪዳ። ");
INSERT INTO gmve_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","ኢስራኤሌ ኣሳይ ባንታ ሞርኬታራ ኤቄታናስ ዳንዳዮንታይ ሄሳ ጋሶና፤ ኢስቲ ꬋዮስ ኣꬊ ኢሜቲዳ ጊሻስ ባንታ ሞርኬታ ሲንꬃፌ ጉዬ ሲሚ ባቃቲዳ፤ ፒላ ሚሽ ኢንቴ ጊዶፌ ኢንቴ ꬋይሶንታ ኣጊኮ ሃይሳፌ ጉዬ ታኒ ኢንቴናራ ጊዲኬ። ");
INSERT INTO gmve_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","«ዴንዳ! ኣሳ ጌሻ፤ ኢስታስ፥ ‹ጎዳ ኢስራኤሌ ጾሳይ ኢንቴና፡ ኢስራኤሌቶ! ፒላ ሚሺ ኢንቴ ጊዶን ዴስ፤ ኢንቴ ሄሳ ኢንቴ ጊዶፌ ዲጋና ጋካናስ ኢንቴ ሞርኬታ ሲንꬃን ኤቃናስ ዳንዳዬኬታ፤ ዎንቶስ ኢንቴና ጊጊሳናስ ኢንቴና ጌሺቴ። ");
INSERT INTO gmve_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","ዎንቶ ማላዶ ኢንቴ ቆሞን ቆሞን ሺቂቴ፤ ጎዳይ ሻኪዳይሲ፥ ዛሬን ዛሬን፥ ዛርኬን ዛርኬን፥ ኬꬃን ኬꬃኒኔ ሁኤን ሁኤን ሲንꬄ ኬዛና። ");
INSERT INTO gmve_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","ሄሳፌ ጉዬ ፒላ ሚሺ ኢዛ ኣቻን ቤቲዳዴይኔ ኢዛስ ዲዛ ኡባይ ታማን ጹጌታና። ጋሶይካ ጎዳ ጫቆ ቃላ ላሊዲ ኢስራኤሌ ጊዶን ዬላቺዛ ኦሶ ኦꬂዳ ጊሻሳ› ጋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","ኢያሶይ ዎንቴꬃ ጋላስ ዎንታራ ዴንዲዲ ኢስራኤሌ ኣሳይ ባ ቆሞን ቆሞን ሺቃና ማላ ኦꬂዴስ፤ ሄሳፌ ጉዬ ዩሁዳ ቆሞይ ሻኬቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","ዩሁዳ ቆሞይ ሺቂን፥ ዛራሄ ዛሬይ ሻኬቲዴስ፤ ዛራሄ ዛሬይ ሺቂን፥ ዚሚሬ ሶ ኣሳይ ሻኬቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","ዚሚሬ ሶ ኣሳይ ሺቂን፥ ዉርሴꬃን ዚሚሬ ና፥ ካርሜ ና ኣካኔይ ሻኬቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","ሂስቲን ኢያሶይ ኣካኔ፥ «ታ ናዞ! ጎዳ ኢስራኤሌ ጾሳ ቦንቻ፤ ኢዛስ ፓጻ፤ ኣኔ ኔኒ ኦꬂዳይሳ ቆቶንታ ዳሼ ታስ ዮታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","ኣካኔይካ ኢያሶስ፥ «ኤ ቱማ! ታኒ ጎዳ ኢስራኤሌ ጾሳ ቆሃዲስ፤ ታኒ ኦꬂዳይ ሃይሳ፤ ");
INSERT INTO gmve_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","ዲኤቲ ዪዳ ሚሻ ጊዶፌ ታኒ ኢሲ ሎኢዛ ሳናኦሬ ካባ፥ ናምኡ ጼቱ ሳቂሌ ቢራኔ ባጋ ኪሎ ጊዲዛ ዎርቃ ቤኣዳ ኣሞቲዳ ጊሻስ ኤካዲስ። ሂስታዳ ታ ዱንካኔ ጊዶን ቦካዳ ቢራ ጋርሳራ ሂጻ ሞጋዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","ሂስቲን ኢያሶይ ኣስ ኪቲዴስ፤ ኢስቲ ኢዛ ዱንካኔኮ ዎጺ ቢዲ ቢራዚ ጋርሳራ ሂጼቲ ሃንኮ ሚሻታራ ሞጌቲዳይሳ ዴሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","ኪቴቲ ቢዳ ኣሳቲ ሚሻ ዱንካኔዛ ጊዶፌ ኤኪዲ፥ ኢያሶኮኔ ኢስራኤሌ ኣሳኮ ኤሂዲ ጎዳ ሲንꬃን ዎꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","ሄሳፌ ጉዬ ኢያሶይኔ ኢስራኤሌ ኣሳይ ኡባይ ኢሲፌ ዛራሄስ ናዛ ና ካርሜ ና ኣካኔ፥ ቢራ፥ ካባ፥ ዎርቃ፥ ኢዛ ኣቱማ ናይታኔ ማጫ ናይታ፥ ኢዛ ሚዛ፥ ሃሬታኔ ዶርሳታ፥ ኢዛ ዱንካኔኔ ኢዛስ ዲዛይሳ ኡባ ኤኪዲ ኣኮሬ ዙሌ ኤሂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","ኢያሶይ ኣካኔ፥ «ሃይሳ ማላ ሜቶ ኑ ቦላ ኣይስ ኤሃዲ? ጎዳይ ሃች ኔ ቦላካ ሜቶ ኤሃና» ጊዴስ። ሂስቲን ኢስራኤሌ ኣሳይ ዉሪ ኣካኔኔ ኢዛ ሶ ኣሳ ሹቻን ኩራኪ ዎꬊዲ ኢዛስ ዲዛ ኡባ ታማን ጹጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","ኢስቲ ኣካኔ ቦላን ሃች ጋካናስ ዲዛ ዳሮ ሹች ኮሪዳ። ሄሳፌ ጉዬ ጎዳይ ያሺሲዛ ባ ሃንቆዛ ዛሪዴስ፤ ሄሳ ጊሻስ ሃች ጋካናስ ሄ ሶሆይ ኣኮሬ ዙሌ ጌቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","ጎዳይ ኢያሶስ፥ «ያዮፋ፤ ዳጋሞፋ! ኦላንቻታ ኡባ ኔናራ ኤካዳ፥ ኣዬ ካታማ ባዳ ኦላ። ሄኮ ኣዬ ካታማ ካዎ፥ ኢዛ ዴራ፥ ኢዛ ካታማኔ ኢዛ ቢታ ታኒ ኔ ኩሼን ኣꬃ ኢማዲስ። ");
INSERT INTO gmve_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","ኔኒ ኢያርኮ ካታማኔ ኢዛ ካዎዛ ꬋይሲዳ ማላ ኣዬ ካታማኔ ኢዛ ካዎዛካ ꬋይሳና። ጊዶ ኣቲን ቦንቂዳ ሃሮዛኔ ዲኢዳ ሜሄዛ ኢንቴስ ኤኪቴ። ካታማፔ ጉዬ ባጋራ ዛማዲ ናጊዛ ኦላንቻታ ዎꬃ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","ሂስቲን ኢያሶይኔ ኦላንቻቲ ኡባይ ኣዬ ኦላናስ ዴንዲዳ። ኢያሶይ ባ ኦላንቻታ ጊዶፌ 30,000 ጊዲዛ ሚኖ ኦላንቻታ ዶሪዲ ቃማራ ዬዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","ኢያሶይ ኢስታስ፥ «ሲዪቴ፥ ካታማፔ ጉዬ ባጋራ ዛማዲ ናጊቴ፤ ካታማፔ ሃኮፍቴ፤ ኡባይካ ሚኒ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","ታኒኔ ታናራ ዲዛ ኣሳ ኡባይ ካታማይኮ ሺቃና፤ ሄ ዎዴ ኣዬ ካታማ ኣሳይ ካሴይሳꬆካ ኑናራ ኦሌታና ጊዲ ኑኮ ኬዚሺን ኑኒ ኢስታፌ ባቃታና። ");
INSERT INTO gmve_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","ካታማፔ ኢስቲ ኡባይ ኬዛና ጋካናስ ኑኒ ኢስታ ሲንꬃፌ ባቃታና፤ ሂስቲዳ ማላ ኢስታስ፥ ‹ካሴይሳꬆ ኢስራኤሌቲ ኑ ሲንꬃፌ ባቃቴቴስ› ጊሼ ኑ ኢስታ ካሌꬂዲ ሃሲ ኤፋና ጋካናስ ኢስቲ ኑና ካላና፤ ኑኒካ ኢስታፌ ባቃታና። ");
INSERT INTO gmve_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","ሄ ዎዴ ኢንቴ ቆቴቲዳሶፔ ኬዚዲ ካታማዮ ኦይካንዴታ፤ ጎዳ ኢንቴ ጾሳይ ካታማዮ ኢንቴስ ኣꬂ ኢማና። ");
INSERT INTO gmve_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","ካታማዮ ኦይኪዳፔ ጉዬ ጎዳይ ኣዛዚዳ ማላ ታማን ጹጊቴ፤ ቤኢቴ ታኒ ኢንቴና ኣዛዛዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","ሂስቲዲ ኢያሶይ ኦላንቻታ ዬዲዴስ፤ ኢስቲ ቢዲ ኣዬ ካታማፔ ኣርሼይ ዉሊዛሶ ባጋራ ዲዛ ቤቴሌሲኔ ኣዬስ ጊዶን ዛማዲ ናጊዳ፤ ጊዶ ኣቲን ኢያሶይ ሄ ጋላሳ ኦማርስ ኣሳራ ኢሲፌ ኣቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","ኢያሶይ ዎንቴꬃ ጋላስ ዎንታራ ዴንዲዲ ኦላንቻታ ኡባ ሺሺዴስ፤ ኢዚኔ ኢስራኤሌ ጋዳዋቲ ኦላ ኣሳ ካሌꬂዲ ኣዬ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","ኢዛራ ዲዛ ኦላንቻቲ ኡባይ ካታማይስ ሲንꬅ ቢ ማቲዳ፤ ሄሳፌ ጉዬ ቃሴ ኣዬ ካታማፔ ፑዴሃ ባጋራ ዲዛ ሾባፌ ሄ ፒንꬃን ዱንካኒዳ። ");
INSERT INTO gmve_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","ኢያሶይ 5,000 ጊዳና ኦላንቻታ ኤኪዲ ካታማይፔ ኣርሼይ ዉሊዛ ባጋራ ቤቴሌፔኔ ኣዬፔ ጊዶን ዛማዲ ኡታና ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","ካታማይፔ ፑዴሃ ባጋራ ዲዛ ኦላንቻታኔ ካታማይፔ ኣርሼይ ዉሊዛ ባጋራ ዛማዲ ኡቲዳ ኦላንቻታ ኡባ ሶሆ ሶሆ ኦይꬂዴስ። ሄ ጋላሳ ኦማርስ ኢያሶይ ዱጌ ሾባ ዎꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","ኣዬ ዴሬ ካዎይ ሄሳ ቤኢዲ ኢዚኔ ኢዛ ኦላንቻቲ ኡባይ ኢስራኤሌ ኣሳ ኦላናስ ኣራቤፔ ሲንꬃ ባጋራ ዲዛሶሆ ዪዳ። ጊዶ ኣቲን ካዎዚ ካታማይፔ ጉዬ ባጋራ ዛማዲ ናጊዛይቲ ዲዛይሳ ኤሪቤና። ");
INSERT INTO gmve_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","ኢያሶይኔ ኢስራኤሌ ኣሳይ ኡባይ ጾኔቲዳ ሚሳቲዲ ባዞ ሲሚ ባቃቲዳ። ");
INSERT INTO gmve_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","ኣዬ ኣሳይ ኡባይ ኢስታ ዬዴꬃናስ ጼይጌቲዳ፤ ኢያሶካ ዬዴꬂዳ፤ ሄሳꬆ ኦꬂዲ ኣዬ ኣሳይ ካታማፔ ሃካና ማላ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","ኢስራኤሌ ኣሳ ዬዴꬃናስ ኣዬፔኔ ቤቴሌፔ ኬዞንታ ኣቲዳ ኣቱማሲ ዴና፤ ካታማዮ ዶያ ዬጊዲ ኢስራኤሌ ዬዴꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","ሄሳፌ ጉዬ ጎዳይ ኢያሶስ፥ «ካታማዮ ታ ኔ ኩሼን ኣꬃ ኢማና፤ ኔ ኦይኪዳ ቶራ ኣዬ ቦላ ጾንጋናስ ማላ ጼላ» ጊዴስ። ሂስቲን ኢያሶይ ባ ቶራ ካታማኮ ዛሪዲ ማሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","ኢያሶይ ቶራ ሄ ዛሪ ማሊዳ ማላ ካሴ ዛማዲ ኡቲዳ ኦላንቻቲ ባንቲ ቆቴቲዳሶፔ ኤሶን ኬዚዳ። ዎጺ ጌሊዲ ኦይኪዳ፤ ሄራካ ኢዞ ታማን ጹጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","ኣዬ ኣሳይ ጉዬ ሲሚዲ ጼሊሺን ካታማይፔ ጩዋይ ሳሎ ኬዚዛይሳ ቤኢዳ። ባዞ ባቃቲዳ ኢስራኤሌ ኣሳይ ኢስታ ቦላ ሃ ሲሚ ዎꬊዳ ጊሻስ ኢስታስ ቢዛሶይ ꬋይዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","ኢያሶይኔ ኢስራኤሌ ኣሳይ ኡባይ ዛማዲ ኡቲዳ ኦላንቻቲ ካታማ ኦይኪዳይሳኔ ጩዋይ ሳሎ ኬዚዳይሳ ቤኢዳ ማላ ጉዬ ሲሚዲ ኣዬ ኣሳ ቦላ ሜቶ ዬጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","ዛማዲ ኡቲዳ ኦላንቻቲካ ካታማይፔ ኢስታ ቦላ ኬዚዳ። ሄሳ ጊሻስ ኢስራኤሌ ኦላንቻቲ ኢስታ ያራ ሃራ ጊዶꬂዲ ዲፒ ሂስቲዳ፤ ኢሲ ኣሲካ ኣቲቤና። ");
INSERT INTO gmve_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","ጊዶ ኣቲን ኣዬ ካዎ ጻላ ሼምፖራ ፓጻ ኦይኪዲ ኢያሶኮ ኤሂዳ። ");
INSERT INTO gmve_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","ኢስራኤሌ ኣሳይ ኣዬ ኣቱማ ኣሳ ኡባ ዬዴꬂዳ ዴምባኒኔ ባዞን ኢሳ ኢሳ ቃራ ማሻን ዎꬊ ዉርሲዳፔ ጉዬ ሲሚዲ ካታማዮ ቢዲ ሄን ቤቲዳ ኣስ ኡባ ዎꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","ሄ ጋላስ ኣዬ ኣሳይ ኡባይ ሃይቂዴስ፤ ሃይቂዳ ኣሳ ኡባ ቆዳይ 12,000 ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","ኢያሶይ ኣዬ ካታማይን ዲዛ ኣሳ ሙሌራ ꬋይሳና ጋካናስ ካታማኮ ማሊ ዎꬂዳ ቶራ ዱጌ ዎꬂቤና። ");
INSERT INTO gmve_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","ጊዶ ኣቲን ጎዳይ ኢያሶ ኣዛዚዳ ማላ ኢስራኤሌ ኣሳይ ሄ ካታማይን ዲዛ ሜዶሳታኔ ዲኢዳ ሚሻታ ባስ ኤኪዳ። ");
INSERT INTO gmve_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","ኢያሶይ ኣዬ ካታማ ጹጊዴስ፤ ሃች ጋካናስ ቤቲዛ ማላ ሜርናስ ቢዲንꬃ ዶሬኔ ቡላ ኬሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","ኣዬ ዴሬ ካዎ ሚꬃ ቦላ ካቂዴስ፤ ኢዛ ኣሃዛ ኦማርስ ጋካናስ ሄ ሚꬃ ቦላ ኣጋጊዴስ፤ ኣርሼይ ዉሊሺን ኢያሶይ ኢዛ ኣሃ ካታማ ፔንጌ ቦላ ዬጋና ማላ ኣዛዚዴስ፤ ኢዛ ቦላ ዳሮ ሹች ኮሪዳ፤ ሹቻይ ሃች ጋካናስ ሄ ሶሆን ዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","ሄሳፌ ጉዬ ኢያሶይ ኤባሌ ዙማ ቦላ ጎዳስ ኢስራኤሌ ጾሳስ ያርሾ ያርሺዛሶሆ ጊግሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","ጎዳ ኣይሌ ሙሴይ ኢስራኤሌ ኣሳ ኣዛዚዳ ማላኔ ሙሴ ዎጋ ማጻፋን ጻፌቲዳ ማላ ያርሺዛሶሆዚ ማሴቶንታኔ ቢራታይ ቦቾንታ ሹቻፌ ኬሌቲዴስ። ኢዛን ጎዳስ ጹጌቲዛ ያርሾኔ ኢሲፌቴꬃ ያርሾ ያርሺዳ። ");
INSERT INTO gmve_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","ኢያሶይ ሙሴይ ጻፊዳ ዎጋ ማጻፋ ኢስራኤሌ ኣሳይ ጼሊሺን ሹቻ ቦላ ዎጪ ጻፊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","ኢስራኤሌ ኣሳይ ኡባይ፥ ቤቴ ኣሳቲ፥ ጪማቲ፥ ሹሜቲኔ ዳናቲ ኡባይ ጎዳ ጫቆ ቃላ ታቦታ ቶኪዳ ሌዌ ዛሬ ጊዲዳ ቄሴታ ሲንꬃን ጫቆ ቃላ ታቦታፔ ኡሻቻ ባጋራኔ ሃዲርሳ ባጋራ ኤቂዳ። ጎዳ ኣይሌ ሙሴይ ካሴ ኣዛዚዳ ማላ ኢስራኤሌ ኣሳ ኣንጃናስ ኢስታፌ ባጋ ኣሳይ ጋሪዛኔ ዙማኮ፥ ባጋ ኣሳይ ኤባሌ ዙማኮ ሲሚ ኤቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","ሄሳፌ ጉዬ ዎጋ ማጻፋን ጻፌቲዳ ማላ ኢያሶይ ዎጋ ቃላ ኣንጆኔ ቃንጌꬅ ኡባ ናባቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","ሙሴይ ኣዛዚዳ ኡባፌ ኢያሶይ ናባቦንታ ኣጊዳ ኢሲ ቃላይካ ዴና። ኩሜꬃ ኢስራኤሌ ዴራስ፥ ማጫሳስ፥ ናይታሲኔ ኢስታ ጊዶን ዲዛ ቤቴ ኣሳታስ ኡባስ ናባቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","ዮርዳኖሴ ሻፋፔ ኣርሼይ ዉሊዛ ባጋራ ፑዴ ጌዜን ዲዛ ዴሬይ፥ ጋꬋን ዲዛ ዴሬይ ሊባኖሴ ጋካናስ ዲዛ ጊታ ኣባ ጋጻን ዲዛ ሂቴታ፥ ኣሞሬታ፥ ካናኔታ፥ ፓሪዜታ፥ ሂዌታኔ ያቡሴታ ካዎቲ ኡባይ ኢስራኤሌ ኣሳይ ጾኒዳይሳ ሲዪዳ። ");
INSERT INTO gmve_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","ሂስቲዲ ኢያሶኔ ኢስራኤሌ ኣሳ ኦላናስ ኢሲ ቦላ ዴንዲ ዪዳ። ");
INSERT INTO gmve_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","ጌባኦኔ ኣሳይ ጊዲኮ ኢያሶይ ኢያርኮ ካታማኒኔ ኣዬ ካታማን ኦꬂዳይሳ ሲዪዳ ዎዴ፥ ");
INSERT INTO gmve_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","ባሌꬃናስ ኮዪዲ ጋልኣ ኦጎሮኔ ዎይኔ ኡሹ ኢዛን ዎꬂዛ ሲኬቲዳ ሉካሞ ሃሬን ጫኒዳ። ");
INSERT INTO gmve_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","ኣሳቲ ጋልኣኔ ሲኬቲዳ ጫማ ኣꬂዳ፤ ጋልኣ ማይኦካ ማይኢዳ፤ ሜሊዲ ቡቂዳ ሺንቄ ኦይኪዳ። ");
INSERT INTO gmve_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","ሄሳፌ ጉዬ ኢስቲ ኢያሶይ ዱንካኒዳሶ ጌልጌላ ቢዲ ኢያሶሲኔ ኢስራኤሌ ኣሳስ፥ «ኑኒ ሃሆ ቢታፌ ዪዶስ፤ ሃኢ ኑናራ ጫቄቲቴ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","ኢስራኤሌ ኣሳይ ሂዌታስ፥ «ኢንቴ ኑ ማታን ዲዛ ኣሳኮ ኑ ኣይ ኤሪዲ ኢንቴናራ ጫቄታኔ?» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","ኢስቲ ኢያሶስ፥ «ኑኒ ኔ ኣይሌታ» ጊዳ። ኢያሶይ፥ «ኢንቴ ኦኔ? ኣዋፔ ዪዴቲ?» ጊዲ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","ኢስቲካ፥ «ኑኒ ኔ ኣይሌቲ ጎዳ ኔ ጾሳ ጊታቴꬅ ሲዪዲ ዳሮ ሃሆ ቢታፌ ዪዶስ። ኢዛ ጊታቴꬃኔ ኢዚ ጊብጼ ቢታን ኦꬂዳይሳ ኡባ ሲዪዶስ። ");
INSERT INTO gmve_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","ቃሴ ዮርዳኖሴ ሻፋፔ ሄ ፒንꬃን ዲዛ ኣሞሬ ካዎታ ናምኣታ፥ ሄይቲካ ሃሴቦኔ ካዎ ሲሆኔ፥ ኣስታሮቴ ሃሪዛ ባሳኔ ካዎ ኣጌ ቦላ ኢዚ ኦꬂዳይሳካ ኑ ሲዪዶስ። ");
INSERT INTO gmve_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","ኑ ዴሬ ጪማቲኔ ኑ ቢታን ዲዛ ኣሳይ ኡባይ ኑና፥ ኢንቴስ ኦጌ ሺንቄ ኦይኪዲ ኢስታራ ቢዲ ጋይቲቴ፤ ኢስታስ፥ ‹ኑኒ ኢንቴስ ኣይሌታ ጊዳና፤ ኢንቴ ኑናራ ጫቄቲቴ› ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","«ኑኒ ኢንቴኮ ያናስ ኑ ሶፔ ሃይሳ ሺንቄዚ ሆኦ ዲሺን ኤኪ ዪዶስ፤ ጊዶ ኣቲን ሜሊዳይሳኔ ቡቂዳይሳ ሃይሳ ቤኢቴ! ");
INSERT INTO gmve_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","ሃይቲ ኤሳ ሉካሞቲ ኑኒ ኩንꬂዛ ዎዴ ኦራꬃ፤ ጊዶ ኣቲን ሃኢ ኢስቲ ዋኒ ዳኬቲዳኮ ቤኢቴ! ኑ ሃሆ ኦጌ ሄሜቲዳ ጊሻስ ኑ ማይኦይኔ ጫማይ ዉሪዴስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","ጎዳ ኦይቾንታ ኢስራኤሌ ኣሳይ ኢስታ ሺንቄፌ ጉꬃራ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","ኢያሶይ ኢስቲ ሳሮን ዴኣና ማላ ኢስታራ ጫቄቲዴስ፤ ዴራ ካሌꬂዛይቲካ ሄ ጫቆዛ ሚንꬃናስ ቃላ ጌሊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","ኢስታራ ጫቄቲዳ ሄꬓንꬆ ጋላሳፌ ጉዬ ሄ ኣሳቲ ኢስታ ዶꬅ ጊዲዳይሳ ኢስራኤሌቲ ሲዪዳ። ");
INSERT INTO gmve_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","ኢስራኤሌ ኣሳይ ሄꬑ ጋላስ ሄሜቲዲ ጌባኦኔ፥ ካፊሬ፥ ቢኤሮቴኔ ቂሪያቴ-ዪኣሪሜ ጌቴቲዛ ካታማታ ጋኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","ጊዲኮካ ዴራ ካሌꬂዛይቲ ጎዳ ኢስራኤሌ ጾሳ ሱንꬃን ጫቂዳ ጊሻስ ኢስራኤሌቲ ኢስታ ኦሊቤቴና፤ ኩሜꬃ ማባራይካ ኢስታ ቦላ ዙዙሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","ጊዶ ኣቲን ዴራ ካሌꬂዛይቲ፥ «ኑኒ ጎዳ ኢስራኤሌ ጾሳ ሱንꬃን ጫቂዳ ጊሻስ ሃኢ ሲሚዲ ኢስታ ቦላ ሜቶ ጋꬃናስ ዳንዳዮኮ። ");
INSERT INTO gmve_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","ኑኒ ኢስታስ ኦꬃና ዳንዳይዛይ ኢስታስ ጌሊዳ ጫቆ ቃላ ሜንꬂን ሃንቆይ ኑ ቦላ ጋኮንታ ማላ ኢስታ ዎꬎፒቴ። ");
INSERT INTO gmve_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","ጊዶ ኣቲን ኢስቲ ኩሜꬃ ማባራስ ሚꬅ ሚጺሼኔ ሃꬅ ዱቂሼ ዴቶ» ጊ ዛሪዳ። ሄሳ ጊሻስ ማባራ ካሌꬂዛይቲ ጌሊዳ ቃላይ ናጌቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","ኢያሶይ ጌባኦኔ ኣሳታ ጼይጊዲ፥ «ኢንቴ ሃን ኑ ማታን ዴኢሼ፥ ‹ኑኒ ኬሂ ሃሆ ቢታፌ ዪዶስ› ጊዲ ኣይስ ኑና ባሌꬂዴቲ? ");
INSERT INTO gmve_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","ሄሳ ጊሻስ ሃኢ ኢንቴ ቃንጌቲዳይታ፤ ጉꬃቲ ታ ጎዳ ኬꬃን ሚꬅ ሚጺዛኔ ሃꬅ ዱቂዛ ኣይሌታ ጊዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","ኢስቲ ኢያሶስ፥ «ኑኒ ኔ ኣይሌቲ ጎዳ ኔ ጾሳይ ሃ ቢታ ኡባ ኢንቴስ ኢማናይሳኔ ኢዛን ዲዛ ኣሳ ኡባ ኢንቴ ሲንꬃፌ ꬋይሳናስ ባ ኣይሌ ሙሴ ኣዛዚዳይሳ ጌሺ ሲዪዶስ። ሄሳ ጊሻስ ኢንቴፌ ዴንዶይሳን ኑ ሼምፖስ ሂርጊዲ ሃይሳ ኦꬂዶስ። ");
INSERT INTO gmve_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","ሄኮ ሃኢ ኑኒ ኔ ኩሼን ዶስ፤ ኔስ ሎኦኔ ሱሬ ሚሳቲ ቤቲዳ ማላ ኑ ቦላ ኦꬃ» ጊ ዛሪዳ። ");
INSERT INTO gmve_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","ሂስቲን ኢያሶይ ጌባኦኔ ኣሳታ ኢስራኤሌታ ኩሼፔ ኣሺዴስ፤ ኢስቲካ ዎꬊቤቴና። ");
INSERT INTO gmve_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","ሄ ጋላስ ኢያሶይ ጌባኦኔ ኣሳታ ኢስራኤሌ ማባራሲኔ ጎዳይ ዶሪዳሶሆን ኤቂዳ ያርሾሶዛስ ኢስቲ ሃች ጋካናስ ሚꬅ ሚጻናሲኔ ሃꬅ ዱቃና ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","ኢያሶይ ካሴ ኢያርኮ ካታማ ኦሊ ꬋይሲዲኔ ኢስታ ካዎዛ ዎꬊዳ ማላ፥ ኣዬ ካታማ ኦሊዲ ኡባ ꬋይሲዳይሳኔ ኢስታ ካዎዛካ ዎꬊዳይሳ ዬሩሳላሜ ካዎ ኣዶኒ-ጼዴቄይ ሲዪዴስ። ቃሴ ጌባኦኔ ኣሳይ ኢስራኤሌ ኣሳራ ሳሮን ዴኣናስ ጫቄቲዳይሳኔ ሃኢ ኢስታራ ኢሲፌ ዲዛይሳ ሲዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","ሄሳን ኢዚኔ ዴሬዚ ዳጋሚዳ፤ ጋሶይካ ጌባኦኔይ ካዎታ ካታማ ማላ ካታማታ ኡባፌ ጊታ ካታማ፤ ጎምፓይ ኣዬ ካታማይፔ ዳሬስ፤ ኢዚን ዲዛ ኣሳይካ ሚኖ ኦላንቻ። ");
INSERT INTO gmve_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","ሄሳ ጊሻስ ዬሩሳላሜ ካዎይ ኣዶኒ-ጼዴቄይ፥ ኬብሮኔ ካዎ ሆሃሜስ፥ ያርሙቴ ካዎ ጲርኣሜስ፥ ላኪሼ ካዎ ያፊኣሲኔ ኤጊሎኔ ካዎ ዳቢሬይ፥ ");
INSERT INTO gmve_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","«ጌባኦኔ ካታማ ኣሳይ ኢያሶራኔ ኢስራኤሌ ኣሳራ ሳሮ ዴያናስ ጫቄቲዳ ጊሻስ ኢስታራ ኦሌታናስ ዪዲ ታና ማዴርኬቲ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","ሄሳፌ ጉዬ ኣሞሬታ ካዎቲ ኢቻሻቲ ዬሩሳላሜ ካዎይ፥ ኬብሮኔ ካዎይ፥ ያርሙቴ ካዎይ፥ ላኪሼ ካዎይኔ ኤጊሎኔ ካዎይ ባ ኦላንቻታ ኢሲፌ ጋꬂዲ ኡባ ኤኪ ቢዲ፥ ጌባኦኔ ካታማ ዶዲ ኦይኪዲ ኦሊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","ጌባኦኔ ኣሳይ ጌልጌላን ዱንካኒዳ ኢያሶኮ ኪቲዲ፥ «ኑና ኔ ኣይሌታ ኣጎፋ፤ ኤሶን ኑኮ ያዳ ኑና ኣሻ። ጌዜ ዴሬን ዲዛ ኣሞሬታ ካዎቲ ዉሪ ኑና ኦላናስ ባ ኦላንቻታ ኡባ ሺሺ ኤኪዲ ዪዛ ጊሻስ ኑና ኔ ኣይሌታ ማዳ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","ሄሳ ጊሻስ ኢያሶይ ባ ኦላንቻታኔ ሚኖ ኣሳታ ኡባ ሺሺ ኤኪዲ ጌልጌላፔ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","ጎዳይ ኢያሶ፥ «ኔ ኢስታስ ያዮፋ፤ ታኒ ኢስታ ኔ ኩሼን ኣꬃ ኢማዲስ፤ ኢስታፌ ኢሳዴይካ ኔናራ ኤቄታናስ ዳንዳዬና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","ሄሳፌ ጉዬ ኢያሶይ ጌልጌላፔ ኦማርሳራ ሄሜቲሼ ኣቂዲ ኢስቲ ኣኬኮንታ ዲሺን ኢስታ ቦላ ዎራጂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","ጎዳይ ኢስራኤሌ ኣሳ ሲንꬃን ኣሞሬታ ቦላ ሺሮ ዬዲዴስ፤ ኢስራኤሌ ኣሳይ ኢስታፌ ዳሮ ኣሳ ጌባኦኔን ዎꬊዴስ። ኢስራኤሌ ኣሳይ ኢስታ ቤቲ-ሆሮኔ ኤፊዛ ኦጌ ፑዱንꬃን ካሊዴስ፤ ኣዜቄፔ ቢዲ ማቄዳ ጋካናስ ዬዴꬂ ዎꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","ቤቲ-ሆሮኔፔ ዱጌ ኣዜቄ ኤፊዛ ኦጌ ኦይኪዲ ኢስቲ ኢስራኤሌ ኣሳ ሲንꬃፌ ባቃቲሺን ጎዳይ ዎልቃማ ሻች ሳሎፔ ኢስታ ቦላ ቡኪሲዴስ። ሂስቲን ኢስራኤሌ ኣሳይ ማሻን ዎꬊዳ ኣሳፔ፥ ሻቻይ ዎꬊዳ ኣሳይ ኬሂፔ ዳሮ። ");
INSERT INTO gmve_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","ጎዳይ ኣሞሬታ ኢስራኤሌ ኣሳ ኩሼን ኣꬂ ኢሚዳ ጋላስ ኢስራኤሌ ኣሳ ሲንꬃን ኢያሶይ ጎዳስ፥ «ኣርሼይ ጌባኦኔን ኤቆ፤ ኣጊናይካ ኣያሎኔ ሾባን ኤቁ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","ሄሳ ጊሻስ ኢስራኤሌ ካዎቴꬃይ ባ ሞርኬታ ቦላ ሃሎ ኬሳና ጋካናስ ኣርሼይ ኤቂዴስ። ኣጊናይካ ቃጻቤኩ። ሄሲካ ያሻሬ ማጻፋን ጻፌቲዴስ፤ ኣርሼይ ሳሎስ ጊዶ ኣዳን ኤቂዴስ፤ ኢሲ ጋላስ ኩሜꬅ ኣርሼይ ዉሎንታ ፔኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","ጎዳይ ኣሳ ቃላ ሲዪዳ ሄሳ ማላ ጋላሲ ሄሳፌ ካሴካ ጉዬካ ሃኒቤና። ቱሙካ ጎዳይ ኢስራኤሌ ጊሻስ ኦሌቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","ሄሳፌ ጉዬ ኢያሶይኔ ኢስራኤሌ ኦላንቻቲ ኡባይ ባ ዱንካኒዳሶ ጌልጌላ ሲሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","ሄ ዎዴ ኣሞሬታ ካዎቲ ኢቻሻቲ ባቃቲ ቢዲ ማቄዳን ጎንጎሎ ጊዶን ቆቴቲዳ። ");
INSERT INTO gmve_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","ኢያሶይካ ኢቻሽ ካዎቲ ማቄዳን ጎንጎሎ ጊዶን ቆቴቲ ዲዛይሳ ሲዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","ኢያሶይ፥ «ጊታ ሹቻታ ጌንዴሪሲ ኤፊዲ ጎንጎሎዛ ጎርዲቴ፤ ሂስቲዲ ናጋና ዛቤታ ሄን ዎꬂቴ። ");
INSERT INTO gmve_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","ኢንቴ ሞርኬታ ዬዴꬂቴ ኣቲን ኣዛሎፍቴ፤ ኢስታ ካሊ ካሊ ሜቶ ጋꬂቴ፤ ኢስቲ ባ ካታማ ቢ ጌሎንታ ማላ ዲጊቴ፤ ሄኮ ጎዳ ኢንቴ ጾሳይ ኢስታ ኢንቴ ኩሼን ኣꬂ ኢሚዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","ሄሳ ጊሻስ ኢያሶይኔ ኢስራኤሌ ኣሳይ ኢስታ ሙሌራ ዲፒ ሂስቲዳ፤ ኢስታፌ ኣቲዳ ጉꬃቲ ካሴ ባ ዲዛ ጊምቤቲዳ ካታማታ ሲሚ ጌሊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","ሄሳፌ ጉዬ ኣሳይ ኡባይ ሳሮን ሲሚዲ ኢያሶይ ዱንካኒ ዲዛሶ ማቄዳ ዪዴስ፤ ኢስራኤሌ ኣሳ ቦላ ኢሲ ቃላካ ሃሳይዳ ኣሲ ዴና። ");
INSERT INTO gmve_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","ኢያሶይ ኢስታስ፥ «ጎንጎሎዛ ዶይዲ ሄ ኢቻሽ ካዎታ ኬሲዲ ታስ ሃ ኤኪ ዪቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","ኢስቲካ ሄ ኢቻሽ ካዎታ ዬሩሳላሜ ካዎ፥ ኬብሮኔ ካዎ፥ ያርሙቴ ካዎ፥ ላኪሼ ካዎኔ ኤጊሎኔ ካዎ ኬሲዲ ኢዛኮ ኤሂዳ። ");
INSERT INTO gmve_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","ኢስቲ ሄ ካዎታ ኢያሶኮ ኤሂን ኢያሶይ ኢስራኤሌ ኣቱማ ኣሳ ኡባ ባኮ ጼይጊዲ ባናራ ዲዛ ኦላ ጋዳዋታ፥ «ሃ ዪዲ ሃይታ ካዎታ ቆꬌ ቦላ ዬꬊ ኤቂቴ» ጊዴስ። ኢስቲካ ሲንꬅ ኣꬊዲ ባ ቶሆን ካዎታ ቆꬌ ቦላ ዬꬊ ኤቂዳ። ");
INSERT INTO gmve_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","ኢያሶይካ ኢስታስ፥ «ባቦፍቴ፤ ዳጋሞፍቴ፤ ሚኒቴኔ ጻሊቴ፤ ኢንቴናራ ኦሌቲዛ ኢንቴ ሞርኬታ ኡባታ ቦላ ጎዳይ ሃይሳꬆ ኦꬃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","ሄሳፌ ጉዬ ኢያሶይ ኢቻሽ ካዎታ ዎꬊዲ ኢቻሽ ሚꬃ ቦላ ኢስታ ኣሃ ካቂዴስ፤ ኦማርሲ ጋካናስ ኢስታ ኣሃይ ሚꬃ ቦላፌ ዎꬊቤና። ");
INSERT INTO gmve_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","ኣርሼይ ዉላና ሃኒሺን ኢያሶይ ኣዛዚን ሚꬃ ቦላፌ ካዎታ ኣሃ ዎꬂዲ ካሴ ኢስቲ ቆቴቲዳ ጎንጎሎዛን ኤፊ ዬጊዳ። ሂስቲዲ ጎንጎሎዛ ጊታ ሹቻታን ቱጪዳ፤ ሄ ሹቻቲ ሃች ጋካናስካ ሄን ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","ሄ ጋላስ ኢያሶይ ማቄዳ ካታማ ኦይኪዴስ፤ ካታማዮኔ ኢዚ ካዎዛ ጊꬃ ማሻን ሲፊዴስ፤ ኢዚ ጊዶን ዲዛ ኣሳፔ ኢሲኖካ ኣሾንታ ዲሼ ዲፒ ሂስቲዴስ፤ ኢያርኮ ካዎ ቦላ ኦꬂዳይሳꬆካ ማቄዳ ካዎ ቦላካ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","ሄሳፌ ጉዬ ኢያሶይኔ ኢዛራ ዲዛ ኢስራኤሌ ኣሳይ ኡባይ ማቄዳፌ ሊቢና ቢዲ ኦሊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","ጎዳይ ሄ ካታማዮኔ ኢዚ ካዎዛ ኢስራኤሌ ኣሳ ኩሼን ኣꬂ ኢሚዴስ፤ ኢያሶይ ካታማዮኔ ኢዚ ጊዶን ዲዛ ኡባ ኢሲኖካ ኣሾንታ ጊꬃ ማሻን ዲፒ ሂስቲዴስ፤ ኢያርኮ ካዎ ቦላ ኦꬆይሳꬆካ ሊቢና ካዎ ቦላካ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","ሄሳፌ ጉዬ ኢያሶይኔ ኢዛራ ዲዛ ኢስራኤሌ ኣሳይ ኡባይ ሊቢናፔ ላኪሼ ቢ ዶዲ ኦሊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","ጎዳይ ላኪሼ ኢስራኤሌ ኣሳ ኩሼን ኣꬂ ኢሚዴስ፤ ኢያሶይ ሄ ካታማዮ ናምኣንꬆ ጋላሳን ኦይኪዴስ፤ ኢዚ ሊቢናን ኦꬆይሳꬆካ ሃኖ ሃ ካታማዮኔ ኢዚ ጊዶን ዲዛ ኡባ ጊꬃ ማሻን ሲፊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","ሄ ዎዴ ጌዜሬ ካዎ ሆራሜይ ላኪሼ ካዎ ማዳናስ ዪዴስ፤ ጊዶ ኣቲን ኢያሶይ ኢዛካ ኢዛ ኣሳካ ኢሲኖ ኣሾንታ ኡባ ዲፒ ሂስቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","ሄሳፌ ጉዬ ኢያሶይኔ ኢዛራ ዲዛ ኢስራኤሌ ኣሳይ ኡባይ ላኪሼፔ ኤጊሎኔ ቢዲ ሄ ካታማ ዶዲ ኦይኪ ኦሊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","ሄ ጋላስ ኤጊሎኔ ኦሊ ኦይኪዲ ጊꬃ ማሻን ꬋይሲዳ፤ ካሴ ላኪሼን ኦꬂዳ ማላ ኤጊሎኔ ካታማን ዲዛ ኣሳ ሙሌራ ꬋይሲዳ። ");
INSERT INTO gmve_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","ሄሳፌ ጉዬ ኢያሶይኔ ኢዛራ ዲዛ ኢስራኤሌ ኣሳ ኡባይ ኤጊሎኔፔ ኬዚ ቢዲ ኬብሮኔ ኦሊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","ሄ ካታማዮኔ ካታማይ ጊዶን ዲዛ ሚሽ ኡባ ኢሲኖካ ኣሾንታ ጊꬃ ማሻን ዲፒ ሂስቲዳ፤ ካሴ ኤጊሎኔን ኦꬂዳ ማላ ሃኖ ካታማይ ጊዶን ዲዛ ኡባ ሙሌራ ዲፒ ሂስቲዳ። ");
INSERT INTO gmve_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","ሄሳፌ ጉዬ ኢያሶይኔ ኢዛራ ዲዛ ኢስራኤሌ ኣሳይ ኡባይ ጉዬ ሲሚዲ ዳቢሬ ኦሊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","ካታማዮኔ ኢዚ ካዎዛ፥ ኢዚ ሄራን ዲዛ ቄሪ ካታማታካ ኡባ ጊꬃ ማሻን ሲፊዳ፤ ኢዚ ጊዶን ዲዛይሳፌ ኢሲኖካ ኣሾንታ ኡባ ዲፒ ሂስቲዳ፤ ካሴ ሊቢናኒኔ ሊቢና ካዎ ቦላ ኦꬂዳ ማላ፥ ኬብሮኔ ቦላ ኦꬆይሳꬆካ ዳቢሬ ቦላኔ ኢዚ ካዎዛ ቦላ ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","ሄሳꬆካ ኢያሶይ ዙምቡላቲ ዳሪዛ ቢታ፥ ኔጌቤ፥ ኣርሼይ ዉሊዛ ባጋራ ዲዛ ጋꬋ ቢታኔ ዙማ ላዴታ፥ ቢታ ኡባ ካዎታራ ጋꬂ ኦይኪዴስ። ጎዳ ኢስራኤሌ ጾሳይ ኣዛዚዳ ማላ ቢታ ቦላ ሼምፖራ ዲዛ ኡባ ዲፒ ሂስቲዴስ፤ ኣይኮካ ሼምፖራ ፓጻ ኣሺቤና። ");
INSERT INTO gmve_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","ኢያሶይ ኢስታ ቃዴሴ ባሪኔፔ ቢዲ ጋዛ ጋካናስ፥ ቃሴ ጎሼኔ ቢታፌ ዶሚዲ ጌባኦኔ ጋካናስ ኡባ ጾኒ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","ኢያሶይ ኢሲቶ ኦላ ኬዚዲ ሄ ካዎታኔ ኢስታ ቢታ ኡባ ጾኒዴስ። ሄሲካ ሃኒዳይ ጎዳ ኢስራኤሌ ጾሳይ ባ ዴራስ ኦሌቲዳ ጊሻሳ። ");
INSERT INTO gmve_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","ሄሳፌ ጉዬ ኢያሶይኔ ኢስራኤሌ ኣሳይ ኡባይ ባ ዱንካኒዳሶ ጌልጌላ ሲሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","ሃጾሬ ካዎ ያቢኔይ ኢስራኤሌ ኣሳይ ጾኒዳይሳ ሲዪዳ ዎዴ፥ ሜዶኔ ካዎ ዮባቤስ፥ ሺሚሮኔ ካታማስ፥ ኣኪሻፌ ካዎስ ኪታ ዬዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","ሄሳꬆካ ፑዴሃ ባጋራ ሻራ ሜንꬆን ዲዛ ካዎታስ፥ ዱጌሃ ባጋን ኣራቤ ካዎታስ፥ ኣርሼይ ዉሊዛ ባጋራ ዲዛ ጋꬋ ካዎታሲኔ ኣርሼይ ዉሊዛ ባጋራ ዶሬ ዙማን ዲዛ ካዎታስ ኪቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","ቃሴ ኣርሼይ ኬዚዛ ባጋራኔ ዉሊዛ ባጋራ ዲዛ ካናኔታስ፥ ኣሞሬታስ፥ ሂቴታስ፥ ፓሪዜታስ፥ ሻራ ሜንꬆን ዲዛ ያቡሴታሲኔ ሚጺጳ ቢታን ሄርሞኔ ዙማፔ ጋርሳ ባጋራ ዲዛ ሂዌ ካዎታስ ኪቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","ሂስቲን ኢስቲ ባ ኦላንቻታ ኡባ ዴንꬂዲ ዳሮ ፓራታኔ ፓራ-ጋሬታ ኢሲፌ ኢስራኤሌ ኦላናስ ኤኪ ዪዳ። ኢስታስ ቆዳይ ኣባ ዶናን ዲዛ ኣንጮ ማላ ጮራ። ");
INSERT INTO gmve_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","ሄ ካዎቲ ዉሪ ኢሲፌ ባ ዎልቃ ሚንꬂዲ ኢስራኤሌ ኦላናስ ሜሮሜ ሃꬃ ማታን ዱንካኒዳ። ");
INSERT INTO gmve_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","ጎዳይ ኢያሶስ፥ «ኔኒ ኢስታስ ባቦፋ! ታኒ ዎንቶ ሃኒ ዎዴ ኢስታ ኡባ ሃይቂዳ ኣሳ ማላ ሂስታ ኢስራኤሌ ኩሼን ኣꬃ ኢማና። ኔኒ ኢስታ ፓራታ ኡባ ጊልዳያና፤ ኢስታ ፓራ-ጋሬታካ ታማን ጹጋና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","ሂስቲን ኢያሶይኔ ኢዛ ኦላንቻቲ ኡባይ ኢስቲ ቆፖንታ ዲሺን ሜሮሜ ሃꬃ ማታን ኢስታ ቦላ ፑቱ ጊዲ ኢስታ ኦሊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","ጎዳይ ኢስታ ኢስራኤሌታ ኩሼን ኣꬂ ኢሚዴስ፤ ሂስቲን ኢስራኤሌቲ ኢስታ ጾኒዲ ጊታ ሲዶና ቢታ ኤፊዛ ኦጌራ፥ ማሲራፎቴ-ማይማ ጋካናስ ቃሴካ ኣርሼይ ሞኪዛ ባጋራ ሚጺጳ ሾባ ጋካናስ ዬዴꬂዳ። ኢስታፌ ኢሲ ኣሲካ ሼምፖራ ፓጻ ኣቲቤና። ");
INSERT INTO gmve_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","ኢያሶይ ጎዳይ ኢዛ ኣዛዚዳይሳ ኡባ ኢስታ ቦላ ፖሊዴስ፤ ኢስታ ፓራታካ ጊልዳይዴስ፤ ኢስታ ፓራ-ጋሬታካ ታማን ጹጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","ሄ ዎዴ ኢያሶይ ጉዬ ሲሚዲ ሃጾሬ ካታማ ኦይኪዴስ፤ ሄ ካታማ ካዎዛካ ጊꬃ ማሻን ሲፊዴስ፤ ሃጾሬ ካታማስ ሄ ዎዴ ዲዛ ካዎቴꬃታ ኡባ ቦላ ኣላፌቴꬂ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","ሄ ካታማን ዲዛ ኣሳ ኡባ ጊꬃ ማሻን ሲፊዳ፤ ሼምፖራ ፓጻ ዲዛ ኡባ ኢሲኖካ ኣሾንታ ዎꬊዳ፤ ካታማዮካ ታማን ጹጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","ጎዳ ኣይሌ ሙሴይ ኣዛዚዳ ማላ ኢያሶይ ሄ ካታማታኔ ኢስታ ካዎታ ኡባ ꬋይሲዴስ፤ ጊꬃ ማሻንካ ሲፊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","ጊዲኮካ ኢያሶይ ሃጾሬ ካታማ ጹጎይሳፌ ኣቲን ኢስራኤሌ ኣሳይ ዙማታ ቦላ ኬጼቲዳ ካታማታ ጹጊቤና። ");
INSERT INTO gmve_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","ኢስራኤሌ ኣሳይ ሄ ካታማታፔ ቦንቂዳ ሚሽ ኡባኔ ሜሄ ኡባ ባንታስ ኤኪዳ፤ ጊዶ ኣቲን ኣሳ ጊꬃ ማሻን ꬋይሲዳ፤ ሼምፖራ ፓጻ ዲዛ ኢሲኖካ ኣሺቤቴና። ");
INSERT INTO gmve_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","ጎዳይ ባ ኣይሌ ሙሴ ኣዛዚዳ ማላ ሙሴይካ ኢያሶ ኣዛዚዴስ። ሂስቲን ኢያሶይካ ኣዛዞዛ ፖሊዴስ፤ ጎዳይ ሙሴስ ኣዛዚዳ ኡባፌ ኢዚ ኦꬆንታ ኣጊዳ ኣይ ሚሺካ ዴና። ");
INSERT INTO gmve_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","ሄሳꬆ ሂስቲዲ ኢያሶይ ሄ ቢታ ኡባ ጌዜ ቢታ፥ ኔጌቤ ቢታ፥ ጎሼኔ ቢታ፥ ኣርሼይ ዉሊዛሶ ባጋራ ዲዛ ጋꬋኔ ኣራቤ ቢታ ቃሴካ ኢስራኤሌ ጌዜኔ ጋꬋ ኡባ ሺሺ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","ሄሲካ ሴይሬ ጋካናስ ዲዛ ሃላቄ ዙማፔ ቢዲ ሄርሞኔ ዙማፔ ዳንኤ ባጋራ ሊባኖሴ ዙሌን ባኣሊ-ጋዴ ጋካናስ ዲዛ ቢታ ኡባ ጋኪዴስ። ኢስታ ካዎታካ ኡባ ኦይኪዲ ዎꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","ኢያሶይ ዳሮ ዎዴ ሄ ካዎታ ኡባራ ኦሌቲሼ ጋምኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","ጌባኦኔን ዲዛ ሂዌታፔ ኣቲን ሃራ ካታማይ ኢሶይኔ ኢስራኤሌታራ ሳሮቴꬃን ዴኣና ጫቄቲቤና፤ ኢስራኤሌቲ ኡባታካ ኦሊ ኦይኪዳ። ");
INSERT INTO gmve_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","ጎዳይ ሙሴ ኣዛዚዳ ማላ ኢያሶይ ኢስታስ ቃꬌቶንታ ኡባ ዎꬊዴስ። ጋሶይካ ኢስቲ ኢስራኤሌታራ ኦሌታና ማላ ጎዳይ ኢስታ ዎዚና ዳሚሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","ሄ ዎዴ ኢያሶይ ቢዲ፥ ጌዜ ቢታን ኬብሮኔ ካታማን፥ ዳቢሬ ካታማን፥ ኣናቤ ካታማን፥ ዩሁዳኒኔ ኢስራኤሌ ጌዜ ቢታ ኡባን ዲዛ ኤናቄ ዛሬታ ኡባኔ ኢስታ ካታማ ኡባ ꬋይሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","ኢስታፌ ጉꬃቲ ጻላ ጋዛን፥ ጌቴኒኔ ኣሽዶዴን ኣቲዳ፤ ጊዶ ኣቲን ኢስራኤሌን ሼምፖራ ፓጻ ኣቲዳ ኤናቄ ዜሬꬂ ዴና። ");
INSERT INTO gmve_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","ጎዳይ ሙሴ ኣዛዚዳ ማላ ኢያሶይ ቢታ ኡባ ኦይኪዴስ፤ ሂስቲዲ ኢስራኤሌ ኣሳስ ኢስታ ቆሞን ቆሞን ሻኪ ኢሚዴስ፤ ሄሳፌ ጉዬ ቢታይ ኦላፔ ሼምፒዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","ኢስራኤሌ ኣሳይ ዮርዳኖሴ ሻፋፔ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ኣራቤ ቢታ ኡባ ኦይኪዲ ኣርኖኔ ዙሌራ ቢዲ ሄርሞኔ ዙማ ጋካናስ ዲዛ ሄ ዴሬ ካዎታ ጾኒዲ ዎꬂ ኤኪዴስ። ሄ ጾኔቲዳ ካዎቲ ሃይሳፌ ካሊ ጻፌቲዳይታ። ");
INSERT INTO gmve_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","ሃሴቦኔ ካታማን ኡቲዲ ኣይሲዛ ኣሞሬታ ካዎይ ሲሆኔ። ኢዚ ኣርኖኔ ሾባ ላንቄን ዲዛ ኣሮኤሬ ዙሌራ ካንꬂ ቢዲ ኣሞኔታ ዛዋ ያቦቄ ሻፋ ጋካናስ ሃሪዴስ፤ ሄሲ ጋላኣዴ ቢታፌ ባጋ ጉጂ ኤኬስ። ");
INSERT INTO gmve_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","ቃሴካ ኣርሼይ ሞኪዛ ባጋራ ዮርዳኖሴ ሾባፌ ቢዲ ጋሊላ ኣባ ጋካናስ፥ ቤቲ-ያሺሞቴ ባጋራ ቢዲ ማጺኔ ኣባፌ ዱጌሃ ባጋራ ዲዛ ፒዝጋ ዙማስ ዳንኤ ባጋ ጋካናስ ዲዛሶዛ ሃሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","ኣስታሮቴኒኔ ኤዲራኤን ኡቲዲ ሃሪዛ ኤራፋይሜ ዜሬꬃታፔ ዉርሴꬃ ቦላ ካዎቲዳይ ባሳኔ ካዎ ኣጌ። ");
INSERT INTO gmve_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","ኢዚ ሄርሞኔ ዙማ፥ ሳላካ፥ ባሳኔ ቢታ ኡባ፥ ቢዲ ጌሹሬታኔ ማኢካቴ ዛዋ ጋካናስ፥ ቃሴካ ጋላኣዴ ቢታፌ ባጋ ኤኪ ቢዲ ሃሴቦኔ ካዎ ሲሆኔ ዛዋ ጋካናስ ሃሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","ጎዳ ኣሽካራ ሙሴይኔ ኢስራኤሌ ኣሳይ ሃ ካዎታ ጾኒዳ፤ ሂስቲዲ ጎዳ ኣይሌ ሙሴይ ኢስታ ቢታ ኦሮቤሌ ቆሞታስ፥ ጋዴ ቆሞታሲኔ ሚናሴ ቆሞታፔ ባጋይታስ ጺንጾ ጊዳና ማላ ሻኪ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","ኢያሶይኔ ኢስራኤሌ ኣሳይ ዮርዳኖሴ ሻፋፔ ኣርሼይ ዉሊዛ ባጋን ዲዛ ካዎታ ኡባ ጾኒዳ። ሄይቲ ሃሪዛ ዛዋይ ሊባኖሴ ሾባን ዲዛ ባኣሊ-ጋዴፔ ዶሚዲ ሴይሬን ሃላቄ ዙማ ጋኬስ፤ ኢያሶይ ሄ ቢታታ ሻኪዲ ኢስራኤሌ ቆሞታስ ጺንጾ ሂስቲ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","ሄ ቢታቲ፥ ጌዜ ዴሬ፥ ኣርሼይ ዉሊዛሶ ባጋን ዲዛ ዙምቡላታ ላዴ፥ ኣራቤ ዙማታ ላዴ፥ ባዞ ቢታኔ ኔጌቤ ቢታ። ሄ ቢታቲ ካሴ ሂቴቲ፥ ኣሞሬቲ፥ ካናኔቲ፥ ፓሪዜቲ፥ ሂዌቲኔ ያቡሴቲ ዴኢዛ ቢታ። ");
INSERT INTO gmve_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","ኢስራኤሌ ኣሳይ ጾኒዳ ካዎቲ ሃይሳፌ ካሊ ዲዛይታ፤ ኢያርኮ ካዎ፥ ቤቴሌ ማታን ዲዛ ኣዬ ካዎ፥ ");
INSERT INTO gmve_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","ዬሩሳላሜ ካዎ፥ ኬብሮኔ ካዎ፥ ");
INSERT INTO gmve_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","ያርሙቴ ካዎ፥ ላኪሼ ካዎ፥ ");
INSERT INTO gmve_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","ኤጊሎኔ ካዎ፥ ጌዜሬ ካዎ፥ ");
INSERT INTO gmve_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","ዳቢሬ ካዎ፥ ቤቲ-ጋዴራ ካዎ፥ ");
INSERT INTO gmve_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","ሆርማ ካዎ፥ ኣራዴ ካዎ፥ ");
INSERT INTO gmve_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","ሊቢና ካዎ፥ ኣዱላሜ ካዎ፥ ");
INSERT INTO gmve_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","ማቄዳ ካዎ፥ ቤቴሌ ካዎ፥ ");
INSERT INTO gmve_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","ታጱሄ ካዎ፥ ሄፌሬ ካዎ፥ ");
INSERT INTO gmve_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","ኣፌቄ ካዎ፥ ላሻሮኔ ካዎ፥ ");
INSERT INTO gmve_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","ሜዶኔ ካዎ፥ ሃጾሬ ካዎ፥ ");
INSERT INTO gmve_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","ሺሚሮኔ-ሚሮኔ ካዎ፥ ኣኪሻፌ ካዎ፥ ");
INSERT INTO gmve_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","ታኢናኬ ካዎ፥ ማጊዶ ካዎ፥ ");
INSERT INTO gmve_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","ቃዴሴ ካዎ፥ ቃርሜሎሴን ዲዛ ዮቂናኣሜ ካዎ፥ ");
INSERT INTO gmve_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","ዙምቡላታ ቦላ ዲዛ ዶሬ ካዎ፥ ጌልጌላን ዲዛ ጎይሜ ካዎ፥ ");
INSERT INTO gmve_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","ቲርጻ ካዎ። ሄይቲ ኢሲ ቦላ 31 ካዎታ። ");
INSERT INTO gmve_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","ኢያሶይ ጪሚን ኢዛስ ላይꬃይ ኬሂ ቢዳ ዎዴ ጎዳይ፥ «ኔኒ ኬሃ ጪማዳሳ፤ ላይꬃይካ ኔስ ኬሂ ቢዴስ፤ ጊዶ ኣቲን ቡሮ ኦይኬቶንታ ዳሮ ቢታይ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","ቡሮ ኦይኬቲቤና ቢታቲ ሃይታ፤ ፊሊስጼሜታ ቢታኔ ጌሹሬታ ቢታ ኡባታ፥ ");
INSERT INTO gmve_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","ጊብጼፔ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ሺሆሬ ሻፋፔ ዶሚዲ፥ ፑዴሃ ባጋራ ዲዛ ኣቃሮኔ ዛዋ ጋካናስ ዲዛ ቢታቲ ዉሪ ካናኔ ቢታ ማላ ቆዴቴቴስ። ኢቻሽ ፊሊስጼሜ ካዎቲ ሃሪዛ ካታማቲ ጋዛ፥ ኣሽዶዴ፥ ኣስቄሎና፥ ጌቴኔ ኣቃሮኔ ጌቴቲዛይታ ጊዲሺን ሄይቲካ ኣዌታ ቢታ። ");
INSERT INTO gmve_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","ዱጌሃ ባጋራ ካናኔታ ቢታይ ዉሪ፥ ሲዶናታስ ዲዛ ማኣሬ ጌቴቲዛሶፔ ዶሚ ቢዲ ኣሞሬታ ቢታን ዲዛ ኣፌቄ ካታማ ጋካናስ፥ ");
INSERT INTO gmve_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","ጌባሌታ ቢታ፥ ኣርሼይ ሞኪዛ ባጋራ ባኣሊ-ጋዴፔ ቢዲ ሄርሞኔ ዙማስ ዳንኤ ባጋራ ኣꬊ ቢዲ ሃማቴ ፑርዴ ጋካናስ ዲዛ ሊባኖሴ ቢታ ኡባ። ");
INSERT INTO gmve_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","«ሊባኖሴፔ ቢዲ ማሲራፎቴ-ማይማን ዲዛ ጌዜ ዴሬን ሲዶናታ ቢታይካ ኦይኬቲቤና። ታኒ ታ ሁኤስ ኢስራኤሌ ኣሳ ሲንꬃፌ ኢስታ ጎዳ ኬሳና። ታኒ ኔና ኣዛዚዳ ማላ ኔኒ ሃ ቢታታ ኢስራኤሌ ኣሳስ ጺንጾ ሂስታ ሻካ። ");
INSERT INTO gmve_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","ኔኒ ሃ ቢታ ኡዱፉን ቆሞታሲኔ ሚናሴ ቆሞታፔ ባጋይታስ ጊሻ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","ሚናሴ ቆሞታፔ ባጋቲ፥ ኦሮቤሌ ዛሬቲኔ ጋዴ ዛሬቲ ጎዳ ኣይሌ ሙሴይ ዮርዳኖሴ ሻፋፔ ሄ ፒንꬃን ኣርሼይ ሞኪዛሶ ባጋራ ኢስታስ ኢሚዳ ቢታ ኤኪዳ። ");
INSERT INTO gmve_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","ኢስታ ቢታይ ኣርኖኔ ሾባ ላንቄን ዲዛ ኣሮኤሬ ካታማፔ ዶሚዲ ሄ ሾባ ጊዶን ዲዛ ካታማ ኦይኪዲ ሜዴባ ጌቴቲዛ ጌዜ ዴሬ ካንꬂ ቢዲ ዲቦኔ ጋኬስ። ");
INSERT INTO gmve_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","ቃሴ ሃሴቦኔን ኡቲዲ ኣሞኔታ ዛዋ ጋካናስ ሃሪዳ ኣሞሬታ ካዎ ሲሆኔ ካታማታ ኡባ ጋꬂ ኦይኬስ። ");
INSERT INTO gmve_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","ሄሳꬆካ ጋላኣዴ ቢታ፥ ጌሹሬታ ቢታ፥ ማኢካቴ ቢታ፥ ሄርሞኔ ዙማ ኡባ፥ ባሳኔ ቢታ ቢዲ ሳላካ ጋካናስ ኦይኬስ። ");
INSERT INTO gmve_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","ሄሲካ ኣስታሮቴ ካታማኒኔ ኤዲራኤ ካታማን ዲሼ ሃሪዳ ኣጌ ካዎቴꬃ ኡባ ኦይኬስ፤ ኣጌይ ዉርሼ ኣቲዳ ኤራፋይሜ ዛሬታፔ ኢሳ። ሙሴይ ሄ ኣሳ ጾኒ ጎዲዲ ኢስታ ቢታ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","ጊዶ ኣቲን ኢስራኤሌ ኣሳይ ጌሹሬ ኣሳኔ ማኢካቴ ኣሳ ኬሲ ጎዶንታ ኣጊዳ ጊሻስ ኢስቲ ሃች ጋካናስ ኢስራኤሌ ኣሳ ጊዶን ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","ሙሴይ ሌዌ ቆሞታስ ጺንጾ ኢሚቤና፤ ጎዳይ ሙሴስ ጊዳ ማላ፥ ጎዳስ ኢስራኤሌ ጾሳስ ታማን ጹጌቲዛ ያርሾይ ኢስታስ ጺንጾ። ");
INSERT INTO gmve_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","ሙሴይ ኦሮቤሌ ቆሞታስ ኢስታ ዛርኬን ዛርኬን ጊሼሬꬂ ኢሚዳ ቢታይ ሃይሳፌ ካሊ ዲዛይሳ። ");
INSERT INTO gmve_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","ኢስታ ዛዋይ ኣርኖኔ ሾባ ላንቄን ዲዛ ኣሮኤሬ ካታማፔኔ ሄ ሾባ ጊዶን ዲዛ ካታማ ኦይኪዲ፥ ሜዴባ ጌዜ ዴሬ ካንꬂ ቢዲ፥ ");
INSERT INTO gmve_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","ሃሴቦኔኔ ጌዜ ዴሬን ዲዛ ካታማታ ኡባ፥ ቃሴ ዲቦኔ፥ ባሞቲ ባኣሌ፥ ቤቲ-ባኣሊ-ሜኦኔ፥ ");
INSERT INTO gmve_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","ያሃጼ፥ ቂዲሞቴ፥ ሜፋኣቴ፥ ");
INSERT INTO gmve_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","ቂሪያታይሜ፥ ሴባማ ሾባ ጊዶን ዲዛ ዙምቡላ ቦላ ዲዛ ጼሬቴ-ሻሃሬ፥ ");
INSERT INTO gmve_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","ቤቲ-ፔኦሬ፥ ፒዝጋ ዱጉንꬃታኔ ቤቲ-ያሺሞቴ። ");
INSERT INTO gmve_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","ሄሲካ ጌዜ ቢታን ዲዛ ካታማታ ኡባኔ ሃሴቦኔ ካታማን ኡቲዲ ሃሪዳ ኣሞሬታ ካዎ ሲሆኔ ቢታ ኡባ ኦይኬስ። ሙሴይ ካዎ ሲሆኔኔ ሄ ቢታን ዲዛ ዳናታ፥ ኤዋ፥ ኤሬቄሜ፥ ጹሬ፥ ኡሬኔ ኤሬባኤ ጌቴቲዛ ሚዲያሜ ሃላቃታ ኦሊ ጾኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","ኢስራኤሌ ኣሳይ ኦላን ዎꬊዳ ኣሳፔ ሃራ፥ ቢኦሬ ና ማሮ ባላሜካ ማሻን ሲፊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","ኦሮቤሌ ቆሞታ ዛዋይ ዮርዳኖሴ ሻፋ። ኦሮቤሌ ቆሞቲ ባ ዛርኬን ዛርኬን ጊሼቲ ኤኪዳ ካታማቲኔ ጉታቲ ሄይታ። ");
INSERT INTO gmve_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","ሙሴይ ጋዴ ቆሞታስ ኢስታ ዛርኬን ዛርኬን ጊሼሬꬂ ኢሚዳ ቢታይ ሃይሳፌ ካሊ ዲዛይሳ። ");
INSERT INTO gmve_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","ኢስታ ዛዋይ ኢያዜሬ፥ ጋላኣዴ ካታማታ ኡባ ኤራባ ኣቻን ዲዛ ኣሮኤሬ ጋካናስ ዲዛ ኣሞኔታ ቢታፌ ባጋ፥ ");
INSERT INTO gmve_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","ሃሴቦኔፔ ቢዲ ኤራሞቴ-ሚጺጳኔ ቤጾኒሜ፥ ማሃናይሜፔ ቢዲ ዳባሬ ዛዋ፥ ");
INSERT INTO gmve_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","ኣርሼይ ሞኪዛ ባጋራ ዲዛ ዮርዳኖሴ ሾባስ ጊዶን ሃሴቦኔ ካዎ ሲሆኔ ካዎቴꬃፌ ኣቲዳይታ፥ ቤቲ-ሃራሜ፥ ቤቲ-ኒሚሬ፥ ሱኮቴኔ ጻፎኔ ጌቴቲዛ ካታማታ ኢሲፌ ጋꬂ ኦይኬስ። ");
INSERT INTO gmve_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","ጋዴ ቆሞቲ ባ ዛርኬን ዛርኬን ጊሼቲ ኤኪዳ ካታማቲኔ ጉታቲ ሄይታ። ");
INSERT INTO gmve_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","ሙሴይ ሚናሴ ቆሞታፔ ባጋይታስ ኢስታ ዛርኬን ዛርኬን ጊሼሬꬂ ኢሚዳ ቢታይ ሃይሳፌ ካሊ ዲዛይሳ። ");
INSERT INTO gmve_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","ኢስታ ዛዋይ ማሃናይሜፔ ዶሚዲ ባሳኔ ቢታ ኡባ ጉጂዲ ባሳኔን ዲዛ 60 ያኢሬ ካታማታ ኡባ ኤኪዲ ባሳኔ ካዎ ኣጌይ ሃሪዛሶ ኡባ ጊዲሺን፥ ");
INSERT INTO gmve_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","ጋላኣዴፔ ባጋኔ ባሳኔን ኣጌ ካዎቴꬃስ ዋና ካታማታ ኣስታሮቴኔ ኤዲራኤ ጋኬስ። ሄይቲ ሚናሴ ና ማኪሬ ዛሬታስ ኢሜቲዳይታ ጊዲሺን ሄይቲካ ማኪሬ ናይታፔ ባጋይታስ ኢስታ ዛርኬን ዛርኬን ኢሜቲዳይታ። ");
INSERT INTO gmve_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","ዮርዳኖሴፔ ሄ ፒንꬃን፥ ኢያርኮፌ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ሞኣቤ ዴምባን ዲዛ ዎዴ ሙሴይ ሻኪዲ ኢሚዳ ቢታይ ሄሳ። ");
INSERT INTO gmve_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","ጊዶ ኣቲን ሙሴይ ሌዌ ቆሞታስ ጺንጾ ኢሚቤና፤ ካሴ ጎዳ ኢስራኤሌ ጾሳይ ኢስታስ ዮቲዳ ማላ ኢዚ ኢስታ ጺንጾ። ");
INSERT INTO gmve_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","ቄሴ ኤልኤዜሬይ፥ ናዌ ና ኢያሶይኔ ኢስራኤሌ ዛሬታ ኮራፒኔቲ ጊሼቺ ኢሚን ኢስራኤሌ ኣሳይ ጊሼቲ ኤኪዲ ላቲዳ ቢታይ ሃይሳፌ ካሊዛይሳ። ");
INSERT INTO gmve_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","ጎዳይ ሙሴ ባጋራ ኣዛዚዳ ማላ ኢስቲ ጊሼቲ ኤኪዳ ቢታይ ኡዱፉን ቆሞታሲኔ ባጋይታስ ሳማን ጋኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","ሙሴይ ናምኡ ቆሞታሲኔ ባጋታስ ዮርዳኖሴ ሻፋፔ ሄ ፒንꬃን ኣርሼይ ሞኪዛ ባጋራ ዲዛ ጋዴዛ ኢስታስ ጺንጾ ሂስቲ ኢሚዴስ፤ ጊዶ ኣቲን ሌዌ ቆሞታስ ኢስታ ጊዶን ጺንጾ ኢሚቤና። ");
INSERT INTO gmve_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","ዮሴፌ ናይቲ ሚናሴኔ ኤፍሬሜ ጌቴቲዲ ናምኡ ዛርኬ ጊዲዳ። ሙሴይ ሌዌ ቆሞታስ ላታ ቢታ ኢሚቤና፤ ጊዶ ኣቲን ሌዌ ቆሞታስ ኢስቲ ዲዛ ካታማታኔ ኢስቲ ባ ሜሄኔ ዶርሳ ሄሚዛሶሆ ጻላ ኣቲን ሃራ ጋዴይ ኢስታስ ኢሜቲቤና። ");
INSERT INTO gmve_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","ሄሳ ጊሻስ ጎዳይ ሙሴ ኣዛዚዳ ማላ ኢስራኤሌ ኣሳይ ቢታ ጊሼቲ ኤኪዳ። ");
INSERT INTO gmve_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","ኢሲ ጋላስ ዩሁዳ ኣሳይ ኢያሶኮ ጌልጌላ ሺቂዴስ፤ ኢስታፌ ቄናዜ ዴሬ ኣስ ዮፊኔ ና ካሌቤይ ኢያሶስ፥ «ኑኒ ቃዴሴ ባሪኔን ዲሺን ጎዳ ኣስ ሙሴስ ኔ ጊሻሲኔ ታ ጊሻስ ዮቲዳይሳ ኔ ኤራሳ። ");
INSERT INTO gmve_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","ጎዳ ኣይሌ ሙሴይ ቢታዮ ዎቻዳ ያና ማላ ቃዴሴ ባሪኔፔ ታና ኪቲዛ ዎዴ ታስ ላይꬃይ 40። ሄ ዎዴ ታኒ ኢዛስ ኣማንꬂዛ ዮኦ ኤካ ያዲስ። ");
INSERT INTO gmve_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","ታናራ ቢዳ ኣሳቲ ዴራ ዎዚና ሂርጋን ኩንꬂዳ፤ ታኒ ጊዲኮ ጎዳ ታ ጾሳ ኩሜꬃ ዎዚናፔ ካላዲስ። ");
INSERT INTO gmve_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","ሄ ጋላስ ሙሴይ፥ ‹ኔኒ ጎዳ ታ ጾሳ ኩሜꬃ ዎዚናፔ ካሊዳ ጊሻስ ኔ ቶሆይ ዬꬊዳ ቢታይ ሜርናስ ኔሲኔ ኔ ዜሬꬃስ ላታ ቢታ ጊዳና› ጊዲ ታስ ጫቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","«ጎዳይ ሃ ዮኦዛ ሙሴስ ዮቶሶፔ ዶሚዲ ኢስራኤሌ ኣሳይ ባዞ ቢታን ቶይላቲሺን ታና 45 ላይꬅ ናጊዲ ሼምፖራ ፓጻ ዎꬂዴስ፤ ሃኢ ታ ላይꬃይ 85 ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","ጊዲኮካ ሃኢ ታስ ዲዛ ሚኖቴꬃይ ቤኒ ሙሴይ ታና ኪቲዛ ዎዴ ዲዛ ሚኖቴꬃ ማላ። ታስ ሃኢካ ኦሌታና ባናስ ቤኒ ዎልቃይኔ ሚኖቴꬂ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","ሄሳ ጊሻስ ጎዳይ ታስ ኢማና ጊዳ ሃ ጌዜ ቢታ ሃኢ ታስ ኢማ። ሄ ዎዴ ኤናቄቲ ሄ ቢታን ዲዛይሳኔ ኢስታ ካታማቲካ ጊታኔ ጊምቤቲዳይታ ጊዲዳይሳ ኔ ሲያዳሳ፤ ጊዶ ኣቲን ጎዳይ ታናራ ጊዲኮ ኢዚ ጊዳ ማላ ታኒ ኢስታ ሄ ቢታፌ ዬዴꬃና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","ሄሳፌ ጉዬ ኢያሶይ ዮፊኔ ና ካሌቤ ኣንጂዲ ኬብሮኔ ኢዛስ ጺንጾ ሂስቲ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","ጎዳ ኢስራኤሌ ጾሳ ኢዚ ኩሜꬃ ዎዚናፔ ካሊዳ ጊሻስ ሄ ጋላሳፌ ዶሚዲ ኬብሮኔይ ቄናዜ ዴሬ ኣስ ዮፊኔ ና ካሌቤስ ጺንጾ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","ኬብሮኔይ ካሴ ኤናቄታ ኡባፌ ባይራ ጊዲዳ ኣርባኤ ሱንꬃን ቂሪያቴ-ኣርባኤ ጌቴታ ጼይጌታዱስ። ሄሳፌ ጉዬ ሄ ቢታያ ኦላፔ ሼምፓዱስ። ");
INSERT INTO gmve_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","ዩሁዳ ቆሞታስ ኢስታ ዛርኬን ዛርኬን ሳማ ዬጊን ጋኪዳ ጋዴይ ቢዲ ኤዶሜራ ዛዋቲዲ፥ ዱጌሃ ባጋ ጋጻን ዲዛ ጺኔ ጌቴቲዛ ባዞ ጋኬስ። ");
INSERT INTO gmve_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","ዱጌሃ ባጋራ ኢስታ ዛዋይ ማጺኔ ኣባስ ዱጌሃ ባጋ ጼራፔ ዶሜስ። ");
INSERT INTO gmve_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","ኣኪራቢሜ ፑርዴራ ካንꬂዲ፥ ጺኔ ባዞራ ቢዲ ቃዴሴ ባሪኔ ዱጌሃ ባጋ ጋኬስ። ቃሴ ሄሳፌ ሄጺሮሜራ ካንꬂ ፑዴ ኣዳሬ ጋኪዲ ቃርቃኮ ሲሜስ። ");
INSERT INTO gmve_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","ኣጺሞኔራ ካንꬂ ቢዲ ሃꬂ ባይንዳ ጊብጼ ሻፋን ጋኪዲ ሜዲቴራኔ ኣባን ዛዋቴስ። ዱጌሃ ባጋራ ዲዛ ዩሁዳ ዛዋይ ሃይሳ። ");
INSERT INTO gmve_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","ኣርሼይ ሞኪዛሶ ባጋራ ዲዛ ዛዋይ ማጺኔ ኣባ ጊዲሺን ሄሲካ ዮርዳኖሴ ሻፋይ ኢዛን ቢ ጌሊዛሶ ጋኬስ። ፑዴሃ ባጋራ ዲዛ ዛዋይ ዮርዳኖሴ ሻፋይ ማጺኔ ኣባን ጌሊዛሶፔ ዶሚዲ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","ፑዴ ቤቲ-ሆጊሌ ኬዚዲ ዮርዳኖሴ ሾባፌ ጋና ባጋራ ካንꬂዲ ኦሮቤሌ ና ቦሃኔ ሹቻን ዛዋቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","ሂስቲዲ ዛዋዚ ኣኮሬ ሾባፌ ዳቢሬ ካታማ ፑዴ ኬዚዲ፥ ሾባፌ ዱጌ ባጋራ ዲዛ ኣዱሚሜ ፑርዴፌ ሲንꬃራ ካንꬂዲ ፑዴሃ ባጋ ጌልጌላኮ ሲሜስ። ቃሴ ኤን-ሼሚሼ ጌቴቲዛ ፑልቶዛራ ካንꬂ ቢዲ ፑዴ ኤን-ሮጌሌ ጌቴቲዛሶ ኬዜስ። ");
INSERT INTO gmve_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","ሄሳፌ ሄኖሜ ና ሾባራ ካንꬂ ቢዲ ያቡሴታ ካታማ ዬሩሳላሜይ ዲዛሶ ዱጌሃ ባጋራ ካንꬂዲ ኤራፋይሜ ሾባስ ፑዴሃ ባጋ ጼራራ ካንꬂ ቢዲ ሄኖሜ ሾባስ ኣርሼይ ዉሊዛ ባጋራ ዲዛ ዙምቡላ ጼራ ጋኬስ። ");
INSERT INTO gmve_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","ሄፔካ ዙምቡላ ጼራፔ ዶሚዲ ኔፍቶ ፑልቶታራ ካንꬂዲ ኤፍሮኔ ዴሬን ዲዛ ካታማታኮ ጋኬስ። ሄሳፌ ቃሴ ዱጌ ባኣላ ዎይኮ ቂሪያቴ-ዪኣሪሜ ጌቴቲዛ ካታማኮ ዎꬌስ፤ ");
INSERT INTO gmve_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","ባኣላፔ ኣርሼይ ዉሊዛ ባጋራ ዲዛ ሴይሬ ዙማኮ ሚርቄቲዲ ኪሳሎኔ ጌቴቲ ጼይጌቲዛ ዪኣሪሜ ዙምቡላስ ፑዴሃ ባጋራ ዲዛ ዱጉንꬃራ ዱጌ ቤቲ-ሼሚሼ ዎꬊዲ ቴሚና ፒኔስ። ");
INSERT INTO gmve_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","ቃሴ ኣቃሮኔስ ፑዴሃ ባጋራ ዲዛ ዱጉንꬃራ ካንꬂዲ ሺካሮኔኮ ሚርቄቲዲ ባኣላ ዙማ ቦላራ ኣꬊ ቢዲ ያቢንኤሌ ጋኬስ፤ ሄሳፌ ጉዬ ዛዋይ ቢዲ ኣባን ኤቄስ። ");
INSERT INTO gmve_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","ኣርሼይ ዉሊዛ ባጋራ ዲዛ ዛዋይ ሜዲቴራኔ ኣባ ጋጻ ጋኬስ። ዩሁዳ ቆሞቲ ባ ዛርኬን ዛርኬን ኤኪዳ ዛዋቲ ሃይታንታ። ");
INSERT INTO gmve_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","ጎዳይ ኢዛ ኣዛዚዳ ማላ ኢያሶይ ዩሁዳ ጊሻፔ ሻኪዲ ኬብሮኔ ጌቴቲዛሮ ቂሪያቴ-ኣርባኤ ዮፊኔ ና ካሌቤስ ኢሚዴስ፤ ኣርባኤይ ኤናቄ ኣዋ። ");
INSERT INTO gmve_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","ካሌቤይካ ኤናቄ ዛሬ ሄꬓታ፥ ሻሻዬ፥ ኣሂማኔኔ ታሊማዬ ኬብሮኔፔ ኬሲ ጎዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","ሄሳፌ ጉዬ ዳቢሬ ዴሬ ቦላ ኦላስ ዴንዲዴስ፤ ዳቢሬ ካታማይ ካሴ ቂሪያቴ-ሴፌሬ ጌቴታዉስ። ");
INSERT INTO gmve_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","ካሌቤይ፥ «ቂሪያቴ-ሴፌሬ ኦሊዲ ኦይኪዛዴስ ታኒ ታ ናዮ ኣኪሳ ኢማና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","ሄሳ ጊሻስ ካሌቤ ኢሻ ቄናዜ ና ኦቲንኤሌይ ሄ ካታማ ኦሊዲ ኦይኪዴስ፤ ሂስቲን ካሌቤይ ባ ናዮ ኢዛስ ማቾ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","ኣኪሳይ ኦቲንኤሌ ጌሊዳፔ ጉዬ ኢዚ ኣዋይ ኢዚስ ጋዴ ኢማና ማላ ባ ኣዋ ዎሳና ማላ ባ ኣዚናስ ሚንꬃ ዮታዱስ፤ ኢዛ ሃሬዛ ቦላፌ ዎꬊን ካሌቤይ ኢዞ፥ «ታ ኔስ ኣይ ኦꬃና ማላ ኮያይ?» ጊ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","ኢዛካ ዛራዳ፥ «ታስ ሎኦ ኦꬃርኪ! ኔኒ ካሴ ታስ ኔጌቤን ጋዴ ኢሚዳይሳꬆ ሃኢካ ፑልቶ ሃꬃራ ዲዛ ጋዴ ታስ ኢማ» ጋዱስ። ሂስቲን ካሌቤይ ኢዚስ ፑዴራኔ ዱጌራ ዲዛ ፑልቶ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","ዩሁዳ ቆሞታስ ኢስታ ዛርኬን ዛርኬን ጊሻስ ኢሚዳ ቢታይ ሃይሳፌ ካሊ ዲዛይሳ። ");
INSERT INTO gmve_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","ኔጌቤ ሄራን ኤዶሜ ዛዋ ጼራን ዲዛ ዱጌሃ ባጋራ ዲዛ ዩሁዳ ቆሞታ ካታማቲ ቃብጺኤሌ፥ ኤዴሬ፥ ያጉሬ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","ቂና፥ ዲሞና፥ ኣዳዳ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","ቃዴሴ፥ ሃጾሬ፥ ዩቲናኔ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","ዚፌ፥ ቴሌሜ፥ ባኣሎቴ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","ሃጾሬ-ሃዳታ፥ ሄጺሮሜ ጌቴቲዛ ቂሪያቴ-ሃጾሬ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","ኣማሜ፥ ሼማኤ፥ ሞላዴ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","ሃጻሬ-ጋዳ፥ ሄሽሞኔ፥ ቤቲ-ጳሌጼ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","ሃጻሬ-ሹኣሌ፥ ቤርሳቤሄ፥ ቢዚዮቲያ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","ባኣላ፥ ኢዩሜ፥ ኤጼሜ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","ኤልቶላዴ፥ ኪሲሌ፥ ሆርማ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","ጺጊላጌ፥ ማዲማና፥ ሳንሳና፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","ሌባዎቴ፥ ሺሊሂሜ፥ ኣዪኔኔ ኣርሞኔ። ካታማቲኔ ጉታቲ ኢሲ ቦላ ናምኡ ታማኔ ኡዱፉና። ");
INSERT INTO gmve_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","ኣርሼይ ዉሊዛ ባጋራ ዙምቡላታ ቶሆሶራ ዲዛይቲ ኤሽታኦሌ፥ ጾራኣ፥ ኣሺና፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","ዛኖሄ፥ ኤን-ጋኒሜ፥ ታጱሄ፥ ኤናሜ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","ያርሙቴ፥ ኣዱላሜ፥ ሶኮ፥ ኣዜቄ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","ሻኢራይሜ፥ ኣዲታይሜ፥ ጋዴሬኔ ጋዴሮታይሜ። ካታማቲኔ ጉታቲ ኢሲ ቦላ ታማኔ ኦይዳ። ");
INSERT INTO gmve_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","ቃሴ ጺናኔ፥ ሃዳሻ፥ ሚጊዳላ-ጋዴ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","ዲልኣኔ፥ ሚጺጳ፥ ዮቂቲኤሌ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","ላኪሼ፥ ቦጺቃቴ፥ ኤጊሎኔ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","ካቦኔ፥ ላሂማሴ፥ ኪቲሊሼ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","ጋዴሮቴ፥ ቤቲ-ዳጎኔ፥ ናኢማኔ ማቄዳ። ካታማቲኔ ጉታቲ ኢሲ ቦላ ታማኔ ኡሱፑና። ");
INSERT INTO gmve_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","ቃሴ ሊቢና፥ ኤቴሬ፥ ኣሻኔ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","ዮፍታሄ፥ ኣሺና፥ ኒጺቤ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","ቂኢላ፥ ኣኪዚቤኔ ማሬሻ። ካታማቲኔ ጉታቲ ኢሲ ቦላ ኡዱፉና። ");
INSERT INTO gmve_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","ኣቃሮኔይ ባ ሄራን ዲዛ ጉታታራ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","ሄሳꬆካ ኣቃሮኔፔ ኣርሼይ ዉሊዛ ባጋራ ዲዛ ኣሽዶዴ ጋካናስ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","ቃሴ ኣሽዶዴይ ባ ሄራን ዲዛ ጉታታራኔ ጋዛፔ ቢዲ ሃꬂ ባይንዳ ጊብጼ ሻፋ ጋካናሲኔ ሜዲቴራኔ ጋጻፔ ሃ ሲሚን ዲዛ ካታማታኔ ጉታታ። ");
INSERT INTO gmve_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","ዙምቡላታ ቦላ ዲዛ ካታማቲካ ሻሚሬ፥ ዬቲሬ፥ ሶኮ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","ዳና፥ ቂሪያቴ-ሲና ዎይኮ ዳቢሬ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","ኣናቤ፥ ኤሽታሞ፥ ኣኒሜ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","ጎሼኔ፥ ሆሎኔኔ ጊሎ፤ ሄይቲ ታማኔ ኢሲኔቲ ኢስታ ካታማታኔ ኢስታ ጉታታ። ");
INSERT INTO gmve_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","ቃሴ ኣራቤ፥ ዱማ፥ ኤሻኔ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","ያኒሜ፥ ቤቲ-ታጱሄ፥ ኣፌቄ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","ሁሚጻ፥ ኬብሮኔ ዎይኮ ቂሪያቴ-ኣርባኤኔ ጺኦሬ፤ ሄይቲ ኡዱፉናቲ ኢስታ ካታማታኔ ኢስታ ጉታታ። ");
INSERT INTO gmve_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","ቃሴካ ማኦኔ፥ ቃርሜሎሴ፥ ዚፌ፥ ዩጻ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","ኢዝራኤሌ፥ ዮቂዲኣሜ፥ ዛኖሄ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","ቃይኔ፥ ጊቢኣኔ ቴሚና፤ ሄይቲ ታማቲ ኢስታ ካታማታኔ ኢስታ ጉታታ። ");
INSERT INTO gmve_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","ቃሴ ሃሊሁሌ፥ ቤቲ-ጹሬ፥ ጋዶሬ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","ማራቴ፥ ቤቲ-ኣኖቴኔ ኤልቲቆኔ፤ ሄይቲ ኡሱፑናቲ ኢስታ ካታማታኔ ኢስታ ጉታታ። ");
INSERT INTO gmve_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","ሄሳꬆካ ቂሪያቴ-ዪኣሪሜ ጌቴቲዳራ ቂሪያቴ-ባኣሌኔ ኤራባ፤ ሄይቲ ናምኣቲ ኢስታ ካታማታኔ ኢስታ ጉታታ። ");
INSERT INTO gmve_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","ባዞን ዲዛይቲ ሃይሳፌ ካሊዛይታ፤ ቤቲ-ኣራቤ፥ ሚዲና፥ ሲካካ፥ ");
INSERT INTO gmve_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","ኒቢሻኔ፥ ማጺኔ ካታማኔ ኤን-ጋዴ፤ ሄይቲ ኡሱፑናቲ ኢስታ ካታማታኔ ኢስታ ጉታታ። ");
INSERT INTO gmve_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","ጊዶ ኣቲን ዩሁዳ ኣሳይ ዬሩሳላሜን ዲዛ ያቡሴታ ኢስቲ ዲዛሶፔ ኬሲ ጎዳና ዳንዳይቤቴና፤ ሄሳ ጊሻስ ያቡሴቲ ሃች ጋካናስካ ዩሁዳ ኣሳራ ኢሲፌ ዬሩሳላሜን ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","ዮሴፌ ዛሬታ ጋኪዳ ቢታይ ኢያርኮ ማታን ዮርዳኖሴ ሻፋፔ ዶሚዲ ኢያርኮ ፑልቶታፔ ኣርሼይ ሞኪዛ ባጋራ ባዞ ካንꬂዲ ጌዜቲዛ ቢታራ ኣꬊዲ ቤቴሌ ጋኬስ። ");
INSERT INTO gmve_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","ሎዛ ጌቴቲዛ ቤቴሌፔ ዴንዲዲ ኣጻሮቴ ጌቴቲዛ ኣርኬታ ቢታ ጋኬስ። ");
INSERT INTO gmve_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","ሄሳፌ ኣርሼይ ዉሊዛ ባጋራ ዲዛ ያፋሌጼታ ቢታ ዱጉንꬃ ዱጌ ቤቲ-ሆሮኔ ዎꬊዲ ጌዜሬራ ካንꬂ ቢዲ ጊታ ኣባን ጌሌስ። ");
INSERT INTO gmve_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","ዮሴፌ ቆሞ ሚናሴ ዛሬቲኔ ኤፍሬሜ ዛሬቲ ባንታና ጋኪዛ ቢታ ላቲዳ። ");
INSERT INTO gmve_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","ኤፍሬሜ ዛሬታ ኢስታ ዛርኬን ዛርኬን ጋኪዳ ቢታይ ሃይሳፌ ካሊዛይሳ፤ ኢስታ ዛዋይ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ኣጻሮቴ-ኣዳሬፔ ቢዲ ጋና ቤቲ-ሆሮኔ ጋኬስ። ");
INSERT INTO gmve_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","ሄፔ ቢዲ ዎጋ ኣባን ጌሌስ። ቃሴ ፑዴሃ ባጋራ ዲዛ ዛዋይ ሚኪማታቴፔ ኣርሼይ ሞኪዛሶ ባጋ ታናቴ-ሺሎራ ሚርቄቲ ሲሚዲ፥ ኣርሼይ ሞኪዛሶ ባጋራ ዲዛ ያኖኬ ጋኬስ። ");
INSERT INTO gmve_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","ያኖኬፔ ዱጌ ኣጻሮቴኔ ናራቴ ዱጉንꬃ ዎꬊዲ ኢያርኮራ ካንꬂ ቢዲ ዮርዳኖሴ ሻፋን ጌሌስ። ");
INSERT INTO gmve_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","ዛዋዚ ታጱሄፔ ኣርሼይ ዉሊዛ ባጋራ ቢዲ ቃና ሻፋራ ዎꬊ ቢዲ ሜዲቴራኔ ኣባን ጌሌስ። ኤፍሬሜ ዛሬቲ ባ ዛርኬን ዛርኬን ላቲዳ ቢታይ ሃይሳ። ");
INSERT INTO gmve_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","ሄሲ ሚናሴ ዛሬታ ቢታፌ ኤፍሬሜ ዛሬታስ ኢሚዳ ካታማታኔ ኢስታ ጉታታ ኡባ ጋꬂ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","ሃይሲ ኡባይ ሃኒንካ ኤፍሬሜ ዛሬቲ ጌዜሬ ካታማን ዲዛ ካናኔ ኣሳታ ኬሲ ጎዲቤቴና። ካናኔ ኣሳቲ ሃች ጋካናስ ኤፍሬሜ ዛሬታራ ኢሲፌ ዴቴስ። ጊዶ ኣቲን ኤፍሬሜ ዛሬቲ ኢስታ ዎልቃራ ኦሲሴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","ሚናሴይ ዮሴፌስ ባይራ ና ጊዲዳ ጊሻስ ኢዛ ዛሬታ ሳማን ጋኪዳ ቢታይ ሃይሳፌ ካሊ ዲዛይሳ፤ ሚናሴስ ባይራ ናዚ ማኪሬይ ጋላኣዴታ ኣዋይ ሚኖ ኦላንቻ ጊዲዳ ጊሻስ ጋላኣዴይኔ ባሳኔይ ኢዛስ ጊሻ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","ሄሳ ጊሻስ ሄ ቢታዚ ሃንኮ ኣቲዳ ሚናሴ ዛሬታስ ኣቢኤዜሬስ፥ ሄሌቄስ፥ ኣሲራኤሌስ፥ ሴኬሜስ፥ ሄፌሬስ፥ ሻሚዳስ ኢሜቲዴስ፤ ዮሴፌ ና ሚናሴ ዛርኬ ጊዲዳ ኣቱማቲ ሃይሳፌ ካሊ ዲዛይታ። ");
INSERT INTO gmve_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","ጺሎፋዴይ ሄፌሬ ና፤ ሄፌሬይ ጋላኣዴ ና፤ ጋላኣዴይ ማኪሬ ና፤ ማኪሬይ ሚናሴ ና። ጺሎፋዴስ ማጫ ናይታፔ ኣቲን ኣቱማ ናይ ዴና፤ ኢዛ ማጫ ናይቲ ማሂሎ፥ ኖኦ፥ ሆጊሎ፥ ሚልኮኔ ቲርጾ ጌቴቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","ኢስታ ቄሴ ኤልኤዜሬኮ፥ ናዌ ና ኢያሶኮኔ ሃላቃታኮ ሺቂዲ፥ «ኑኒ ኑ ኢሻታራ ጋዴ ጊሼቲ ኤካና ማላ ጎዳይ ሙሴ ኣዛዚዴስ» ጊዳ። ሄሳ ጊሻስ ጎዳይ ኣዛዚዳ ማላ ኢያሶይ ኢስታ ኣዋ ኢሻታሳራኔ ኢስታሳራ ጊሼቺ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","ሚናሴስ ጋላኣዴፔኔ ባሳኔፔ ሃራሶን ታሙ ኬዚ ጊሼቲዛ ቢታይ ዮርዳኖሴፔ ኣርሼይ ሞኪዛ ባጋራ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","ሚናሴ ዛሬታፔ ማጫ ናይቲካ ኣቱማ ናይታራ ኢሲፌ ቢታ ጊሼቲ ኤኪዳ ጊሻስ ጋላኣዴ ቢታይ ኣቲዳ ሚናሴ ዛሬታስ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","ሚናሴ ዛሬታ ቢታ ዛዋይ ኣሴሬ ቢታፌ ዶሚዲ፥ ሴኬሜፔ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ሚኪማታቴ ጋኬስ። ሄ ዛዋይ ሄሳፌ ቢዲ ዱጌሃ ባጋራ ካንꬂዲ ኤን-ታጱሄን ዲዛ ዴሬዛካ ጉጄስ። ");
INSERT INTO gmve_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","ታጱሄ ቢታይ ሚናሴሳ፤ ጊዶ ኣቲን ሚናሴ ዛዋን ዲዛ ታጱሄ ካታማያ ካሴ ኤፍሬሜ ዛሬታሳ። ");
INSERT INTO gmve_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","ሄሳፌ ካሊዲ ኢዛ ዛዋይ ቢዲ ቃና ሻፋን ጌሌስ። ሚናሴ ካታማታ ጊዶን ኤፍሬሜ ካታማቲካ ዴቴስ፤ ጊዶ ኣቲን ሚናሴ ዛዋይ ቃና ሻፋፔ ፑዴሃ ባጋራ ቢዲ ሜዲቴራኔ ኣባን ጌሌስ። ");
INSERT INTO gmve_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","ዱጌሃ ባጋራ ዲዛ ቢታይ ኤፍሬሜሳ፤ ፑዴሃ ባጋራ ዲዛ ቢታይ ቃሴ ሚናሴሳ። ሚናሴ ቢታ ዛዋይ ቢዲ ሜዲቴራኔ ኣባ ጋኬስ፤ ፑዴሃ ባጋ ዛዋይ ኣሴሬ ጋኬስ፤ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ዛዋይ ዪሳኮሬ ጋኬስ። ");
INSERT INTO gmve_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","ዪሳኮሬ ቢታኒኔ ኣሴሬ ቢታን ቤቲ-ሻኣኔይ፥ ዪቢላኣሜይ፥ ዶሬ ኣሳይ፥ ኤን-ዶሬይ፥ ታኢናኬይኔ ማጊዶይ ባ ዩሾን ጉታታራ ኢሲፌ ሚናሴሳ፤ ሄꬓንꬆዚ ናፎቴ። ");
INSERT INTO gmve_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","ጊዶ ኣቲን ሚናሴ ዛሬቲ ሄ ካታማታ ጾኒ ኦይካና ዳንዳይቤቴና። ጋሶይካ ካናኔ ኣሳይ ባ ኦይኪዳ ቢታ ዬዶኮ ጊ ሙርቲዳ ጊሻሳ። ");
INSERT INTO gmve_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","ኢስራኤሌ ኣሳይ ሚኒዳ ዎዴ ካናኔ ኣሳታ ባንታስ ሃጋዚሲዳ ኣቲን ቢታፌ ኢስታ ኡባ ኬሲ ጎዲቤቴና። ");
INSERT INTO gmve_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","ዮሴፌ ዛሬቲ ኢያሶ፥ «ጎዳይ ኑና ኣንጂን ኑኒ ቆዳን ጮራ ጊዲሺን ላታ ቢታ ሻኮን ኑስ ኣይስ ኢሲ ጊሻ ጻላ ኢማዲ?» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","ኢያሶይካ ኢስታስ፥ «ኢንቴ ጮራ ጊዲኮ ኤፍሬሜ ጌዜይ ፓሪዜቲኔ ኤራፋይሜቲ ዲዛ ቢታ ቢዲ ዎራ ኢንቴስ ቄጺቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","ዮሴፌ ዛሬቲ፥ «ጌዜ ቢታዚ ኑስ ጊዴና፤ ሄሳ ቦላካ ዴምባን ዲዛ ቤቲ-ሻኣኔኔ ሄ ሄራን ዲዛይቲ፥ ቃሴ ኢዝራኤሌ ሾባን ዲዛ ካናኔታስ ቢራታ ፓራ-ጋሬቲ ዴቴስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","ኢያሶይ ዛሪዲ ዮሴፌ ዛሬታስ ኤፍሬሜ ቆሞታሲኔ ሚናሴ ቆሞታስ፥ «ኢንቴ ጮራኔ ኬሂ ዎልቃማ፤ ኢንቴስ ኢሲ ጊሻ ጻላይ ጊዴና። ");
INSERT INTO gmve_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","ሄሳ ጊሻስ ጌዜ ቢታይካ ኢንቴሳ፤ ቢዲ ቄጺቴ፤ ዉርሴꬃ ጋጻ ጋካናስ ዲዛይሲ ኢንቴስ ጊዳና፤ ካናኔታስ ቢራታ ፓራ-ጋሬቲ ዲኮካ፥ ኢስቲ ሚኖ ጊዲኮካ ኢንቴ ኢስታ ሄፔ ኬሳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","ኢስራኤሌ ማባራይ ዉሪ ሴሎን ሺቂዳ፤ ጋይቶቴꬃ ዱንካኔ ሄን ቶኪዳ፤ ቢታያካ ጮኡ ጋዳ ኢስታስ ሃሬታዱስ። ");
INSERT INTO gmve_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","ጊዶ ኣቲን ኢስራኤሌ ኣሳፔ ጋዴ ጊሻይ ጋኮንታ ኣቲዳ ላፑን ቆሞቲ ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","ሄሳ ጊሻስ ኢያሶይ ኢስራኤሌ ኣሳ፥ «ጎዳ ኢንቴ ኣዋታ ጾሳይ ኢንቴስ ኢሚዳ ቢታ ላቶንታ ኣይዴ ጋካናስ ኣዛሌቲ? ");
INSERT INTO gmve_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","ኢሲ ኢሲ ቆሞፌ ሄꬑ ሄꬑ ኣሳታ ዶሪቴ። ቢታ ዩዪ ጼሊዲ ኢሲ ኢሲ ቆሞ ጋካናይሳ ታስ ጻፊ ኢማናይታ ታ ኪታና፤ ኢስቲካ ታኮ ሃ ሲሚ ያና። ");
INSERT INTO gmve_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","ኢስቲ ሄ ቢታዮ ላፑን ኬሲ ሻካና። ዱጌሃ ባጋራ ዩሁዳይ፥ ፑዴሃ ባጋራ ዮሴፌይ ባስ ጺንጾ ሂስቲ ኦይካና። ");
INSERT INTO gmve_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","ሃ ላፑን ኬዚ ሻኬቲዳ ቢታ ሃኖታ ጻፊዳፔ ጉዬ ታኮ ኤኪ ዪኮ ታኒ ጎዳ ኑ ጾሳ ሲንꬃን ኢንቴስ ሳማ ዬጋና። ");
INSERT INTO gmve_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","ሌዌ ዛሬቲ ጾሳስ ኦꬂዛ ኦሶይ ኢስታስ ጺንጾ ጊዲዳ ጊሻስ ኢንቴናራ ኢስቲ ቢታ ጊሼቴቴና። ጋዴ ዛሬቲ፥ ኦሮቤሌ ዛሬቲኔ ሚናሴ ዛሬታፔ ባጋይ ዮርዳኖሴ ሻፋፔ ኣርሼይ ሞኪዛሶ ባጋራ ጎዳ ኣይሌ ሙሴይ ኢስታስ ኢሚዳ ቢታ ካሴቲ ላቲዳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","ኣሳይ ቢታ ሃኖታ ፒልጊ ጼላናሲኔ ጻፋናስ ቡስ ዶሚሺን ኢያሶይ፥ «ቢዲ ቢታይ ሃኖታ ፒልጊ ጼሊዲ ፓቲ ጻፊዳፔ ጉዬ ሃ ታኮ ሲሚ ዪቴ። ሃይሳን ሴሎን ጎዳ ሲንꬃን ታ ኢንቴስ ሳማ ዬጋና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","ሄሳ ጊሻስ ኣሳይ ቢታ ዩዪ ጼሊዴስ፤ ካታማታራ ኢሲፌ ላፑን ኬሲ ሻኪዲ ጻꬃ ዋራቃታን ጻፊዳ፤ ሄሳፌ ጌዴ ኢያሶኮ ሴሎ ሲሚ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","ኢያሶይ ጎዳ ሲንꬃን ሴሎን ኢስታስ ሳማ ዬጊዴስ፤ ቢታዮ ኢስራኤሌ ኣሳስ ኢስታ ቆሞ ኬና ጊሼቺ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","ኮይሮ ጊሻይ ቢኒያሜ ቆሞታ ኢስታ ዛርኬን ዛርኬን ጋኪዴስ። ሳማን ኢስታ ጋኪዳ ቢታይ ዲዛሶይ ዩሁዳ ዛሬታ ቢታፌኔ ዮሴፌ ዛሬታ ቢታፌ ጊዶን ጊዲሺን ሃይሳፌ ካሊዛይሳ፤ ");
INSERT INTO gmve_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","ፑዴሃ ባጋራ ኢስታ ዛዋይ ዮርዳኖሴ ሻፋፔ ዶሚዲ፥ ኢያርኮ ፑዱንꬃራ ኣꬊ ቢዲ ኣርሼይ ዉሊዛ ባጋራ ꬎቃ ቢታራ ኦይኪዲ ቤቲ-ኣዌኔራ ካንꬄስ። ");
INSERT INTO gmve_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","ሄሳፌ ዱጌሃ ባጋራ ሎዛ ጌቴቲዛ ቤቴሌ ፑዱንꬃራ ካንꬂዲ ዱጌ ባጋራ ዲዛ ቤቲ-ሆሮኔፔ ዱጌሃ ባጋራ ዲዛ ዙማ ኣቻራ ካንꬂ ቢዲ ዱጌ ኣጻሮቴ-ኣዳሬ ጋኬስ። ");
INSERT INTO gmve_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","ዱጌሃ ባጋራ ዲዛ ዛዋይ ቤቲ-ሆሮኔስ ሲንꬃ ባጋራ ዲዛ ዙምቡላፌ ዶሚዲ፥ ኣርሼይ ዉሊዛ ባጋራ ዱጌሃ ባጋ ሚርቄቲዲ ዩሁዳ ቆሞታ ካታማ ጊዲዳ ቂሪያቴ-ባኣሌ ዎይኮ ቂሪያቴ-ዪኣሪሜራ ካንꬂ ቤስ፤ ሄሲ ኣርሼይ ዉሊዛ ባጋስ ዛዋ። ");
INSERT INTO gmve_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","ዱጌሃ ባጋራ ዛዋይ ቂሪያቴ-ዪኣሪሜፔ ዶሚዲ ኔፍቶ ፑልቶ ሃꬃራ ካንꬄስ። ");
INSERT INTO gmve_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","ሄ ዛዋዚ ኤራፋይሜ ሾባፌ ፑዴሃ ባጋራ ዲዛ ሄኖሜ ና ሾባ ጊናራ ዲዛ ዙምቡላ ቶሆሶ ዎꬌስ፤ ሄፔ ያቡሴታ ካታማፔ ዱጌሃ ባጋራ ዲዛ ዱጉንꬃራ ሄኖሜ ዙሌ ዎꬊዲ ኤን-ሮጌሌራ ካንꬄስ። ");
INSERT INTO gmve_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","ቃሴ ፑዴሃ ባጋ ሚርቄቲዲ ኤን-ሼሚሼራ ቢዲ ጌሊሎቴራ ካንꬄስ፤ ሄሳፌ ኣዱሚሜ ፑርዴ ጊናራ ዲዛ ኦሮቤሌ ና ቦሃኔ ሹቻኮ ዱጌ ዎꬌስ። ");
INSERT INTO gmve_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","ሄሳፌ ቤቲ-ኣራቤ ፑዱንꬃራ ካንꬂዲ ዱጌ ኣራቤ ዎꬌስ። ");
INSERT INTO gmve_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","ሄሳፌ ቃሴ ቤቲ-ሆጊሌ ፑዱንꬃፌ ፑዴሃ ባጋራ ካንꬂዲ፥ ዮርዳኖሴ ሻፋይ ጎጊ ጌሊዛሶ ማጺኔ ኣባፌ ጋና ባጋ ጋጻ ጋኬስ። ሄሲ ዱጌሃ ባጋስ ዛዋ። ");
INSERT INTO gmve_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","ኣርሼይ ሞኪዛሶ ባጋራ ዮርዳኖሴ ሻፋይ ዛዋ። ቢኒያሜ ዛሬቲ ላቲዳ ቢታ ኡባሲካ ዛዋቲ ሄይታንታ። ");
INSERT INTO gmve_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","ቢኒያሜ ዛሬቲ ባ ዛርኬን ዛርኬን ኤኪዳ ካታማቲ ኢያርኮ፥ ቤቲ-ሆጊሌ፥ ኣሜቅ-ኬጺጼ፥ ");
INSERT INTO gmve_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","ቤቲ-ኣራቤ፥ ዛማራይሜ፥ ቤቴሌ፥ ");
INSERT INTO gmve_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","ኣዊሜ፥ ፓራ፥ ኦፊራ፥ ");
INSERT INTO gmve_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","ካፌር-ኣሞናዬ፥ ኦፊናኔ ጌባ። ሃይቲ ባንታ ጉታታራ 12 ካታማታ። ");
INSERT INTO gmve_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","ቃሴ ጌባኦኔ፥ ኤራማ፥ ቢኤሮቴ፥ ");
INSERT INTO gmve_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","ሚጺጳ፥ ካፊሬ፥ ሞጻ፥ ");
INSERT INTO gmve_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","ኤሬቄሜ፥ ዪርጲኤላ፥ ቴራላ፥ ");
INSERT INTO gmve_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","ጼላ፥ ሄሌፋ፥ ያቡሴታ ካታማ ዬሩሳላሜ፥ ጊቢኣኔ ቂሪያቴ-ዪኣሪሜ። ሃይቲ ባንታ ጉታታራ 14 ካታማታ። ቢኒያሜ ቆሞቲ ባንታ ዛርኬን ዛርኬን ላቲዳ ቢታይ ሃይታ። ");
INSERT INTO gmve_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","ናምኣንꬆ ሳማይ ሲሞና ቆሞታ ኢስታ ዛርኬን ዛርኬን ጋኪዴስ። ኢስታ ጋኪዳ ቢታይ ዩሁዳ ቆሞቲ ላቲዳ ቢታይ ኢስቲ ላቲዳ ቢታ ጊዶꬂ ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","ኢስቲ ላቲዳ ካታማቲ ቤርሳቤሄ፥ ሼባኤ፥ ሞላዴ፥ ");
INSERT INTO gmve_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","ሃጻሬ-ሹኣሌ፥ ባላ፥ ኤጼሜ፥ ");
INSERT INTO gmve_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","ኤልቶላዴ፥ ባቱሌ፥ ሆርማ፥ ");
INSERT INTO gmve_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","ጺጊላጌ፥ ቤቲ-ማርካቦቴ፥ ሃጻሬ-ሱሳ፥ ");
INSERT INTO gmve_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","ቤቲ-ላባኦቴኔ ሻሩሄኔ። ሄይቲ ኡባይ 13 ካታማታኔ ኢስታ ዩሾን ዲዛ ጉታታ። ");
INSERT INTO gmve_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","ቃሴ ኣዪኔ፥ ኣርሞኔ፥ ኤቴሬኔ ኣሻኔ ጌቴቲዛ ኦይዱ ካታማታኔ ኢስታ ዩሾን ዲዛ ጉታታ። ");
INSERT INTO gmve_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","ባኣላቴ-ባኤሬ ዎይኮ ኔጌቤን ዲዛ ኣራማቴሜ ጋካናስ ዲዛ ካታማታ ዩሾን ዲዛ ጉታታ ኡባ ላቲዳ። ሲሞና ቆሞቲ ባ ዛርኬን ዛርኬን ጊሼቲ ኤኪዳ ቢታቲ ሄይታንታ። ");
INSERT INTO gmve_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","ዩሁዳ ቆሞቲ ኦይኪዳ ጺንጾይ ኬሂ ኣኮ ጊዲዳ ጊሻስ ሲሞና ቆሞታስ ጺንጾ ጊዲ ኢሜቲዴስ፤ ሄሳ ጊሻስ ሲሞና ቆሞቲ ዩሁዳ ቆሞታ ጊሻፔ ጊሼቲ ኤካና ዳንዳይዳ። ");
INSERT INTO gmve_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","ሄꬓንꬆ ሳማይ ዛቢሎኔ ቆሞታስ ኢስታ ዛርኬን ዛርኬን ጋኪዴስ። ኢስቲ ላቲዳ ቢታ ዛዋይ ሳሪዴ ጋኬስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","ቃሴ ሄሳፌ ቢዲ ኣርሼይ ዉሊዛሶራ ማራላ ባጋራ ካንꬂ ቤስ፤ ዳባሼቴ ማታራ ዮቂናኣሜ ኣቻን ዲዛ ሻፋን ቢ ጌሌስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","ሃራ ባጋራ ቃሴ ሳሪዴ ካታማፔ ኣርሼይ ሞኪዛሶ ባጋ ሲሚዲ ኪሲሎቴ-ታቦሬራ ካንꬂ ቢዲ ዳቢራቴራ ጌዴ ያፊኣ ቤስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","ሄራ ጌዴ ኣርሼይ ሞኪዛ ባጋራ ጌት-ሄፌሬኔ ኤቲ-ቃጺኔ ካንꬂ ቤስ፤ ሄፔካ ጌዴ ኣርሞኔ ጋኪዲ ኒኣ ባጋ ሚርቄቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","ፑዴሃ ባጋራ ሃናቶኔ ሲሚዲ ዪፍታሂኤሌ ሾባን ጋኪ ኤቄስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","ቃሴካ ቃጻቴ፥ ናሂላሌ፥ ሺሚሮኔ፥ ኢዳሌኔ ቤቴሊሄሜ ጌቴቲዛ ካታማቲካ ዴቴስ። ኢስቲ ዉሪ 12፤ ኢስታ ዩሾን ዲዛ ጉታቲካ ኢስታን ጉጄቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","ሃይቲ ዛቢሎኔ ቆሞታስ ጺንጾ ጊዲዲ ኢስታ ዛርኬን ዛርኬን ጊሻን ጋኪዳ ካታማታኔ ጉታታ። ");
INSERT INTO gmve_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","ኦይዳንꬆ ሳማይ ዪሳኮሬ ቆሞታ ኢስታ ዛርኬን ዛርኬን ጋኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","ኢስታ ቢታቲ ሃይሳፌ ካሊዛይታ፤ ኢዝራኤሌ፥ ካሱሎቴ፥ ሱኔሜ፥ ");
INSERT INTO gmve_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","ሃፋራኢሜ፥ ሺኦኔ፥ ኣናሃራቴ፥ ");
INSERT INTO gmve_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","ኤራቢቴ፥ ቂሶኔ፥ ኣቤጼ፥ ");
INSERT INTO gmve_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","ኤሬሜቴ፥ ኤን-ጋኒሜ፥ ኤን-ሃዳኔ ቤቲ-ጳጼጼ። ");
INSERT INTO gmve_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","ሄ ቢታታ ዛዋይ ታቦሬ፥ ሻሃጹሜኔ ቤቲ-ሼሚሼ ቦቺ ቢዲ፥ ዮርዳኖሴ ሻፋን ጌሌስ። ኢስቲ ኡባይ ታማኔ ኡሱፑን ካታማታ፤ ኢስታ ዩሾን ዲዛ ጉታቲካ ኢስታን ጉጄቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","ሃይቲ ዪሳኮሬ ቆሞታስ ጺንጾ ጊዲዲ ኢስታ ዛርኬን ዛርኬን ጊሻን ጋኪዳ ካታማታኔ ጉታታ። ");
INSERT INTO gmve_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","ኢቻሻንꬆ ሳማይ ኣሴሬ ቆሞታ ኢስታ ዛርኬን ዛርኬን ጋኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","ኢስታ ቢታቲ ሃይሳፌ ካሊዛይታ ሄልቃቴ፥ ሃሌ፥ ቤጼኔ፥ ኣኪሻፌ፥ ");
INSERT INTO gmve_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","ኣላሜሌኬ፥ ኣማዴኔ ሚሻሌ። ኣርሼይ ዉሊዛሶ ባጋራ ቃርሜሎሴራኔ ሺሆሬ-ሊቢናቴራ ዛዋቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","ቃሴ ኣርሼ ኬሳሶ ባጋ ሲሚ ቤቲ-ዳጎኔኮ ሚርቄቲዲ፥ ዛቢሎኔ ቢታኔ ዪፍታሂኤሌ ሾባራ ካንꬂ ቢዲ ካቡሌ ሃዲርሳ ቦላ ዬጊዲ ፑዴሃ ባጋራ ቤቲ-ኤሜቄኔ ናኢኤሌ ቤስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","ሄሳፌ ቃሴ ኤቢሮኔ፥ ኤራሆቤ፥ ሃሞኔኔ ቃና ፑዱንꬃ ኬዚዲ ጊታ ሲዶና ጋኬስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","ዛዋይ ኤራማ ሲሚዳፔ ጊምቤቲዳ ጺሮሴ ካታማኮ ሚርቄቲ ጌዴ ሆሳ ሲሚዲ ኣኪዚቤ ባጋራኔ ማሂሌቤ ጌዴ ሜዲቴራኔ ኣባን ጋኪ ጌሌስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","ሄን ኡማ፥ ኣፌቄኔ ኤራሆቤ ጌቴቲዛ ካታማቲካ ዴቴስ። ኢስቲ ኡባይ 22፤ ኢስታ ዩሾን ዲዛ ጉታቲካ ኢስታን ጉጄቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","ሃይቲ ኣሴሬ ቆሞታስ ጺንጾ ጊዲዲ ኢስታ ዛርኬን ዛርኬን ጊሻን ጋኪዳ ካታማታኔ ጉታታ። ");
INSERT INTO gmve_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","ኡሱፑንꬃ ሳማይ ኒፍታሌሜ ቆሞታ ኢስታ ዛርኬን ዛርኬን ጋኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","ኢስታ ዛዋይ ሄሌፌፔኔ ዛናኒሜን ዲዛ ጊታ ዎላፔ ዶሚዲ ኣዳሜ-ኔቄቤ፥ ያቢንኤሌኔ ላቁሜ ካንꬂ ቢዲ ዮርዳኖሴ ሻፋ ጌሌስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","ዛዋዚካ ኣርሼይ ዉሊዛ ባጋራ ኣዚኖቴ-ታቦሬኮ ሚርቄቴስ፤ ሄሳፌ ቃሴ ሁቆቄ ሲሚዲ ዱጌሃ ባጋራ ዛቢሎኔ ቢታኒኔ ኣርሼይ ጌሊዛ ባጋራ ኣሴሬ ቢታን ዛዋቲዲ ኣርሼይ ኬዚዛ ባጋራ ዮርዳኖሴ ሻፋን ጌሌስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","ጊምቤቲዳ ካታማቲካ ጺዲሜ፥ ጼራ፥ ሃማቴ፥ ኤራቃቴ፥ ኪኔሬቴ፥ ");
INSERT INTO gmve_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","ኣዳማ፥ ኤራማ፥ ሃጾሬ፥ ");
INSERT INTO gmve_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","ቃዴሴ፥ ኤዲራኤ፥ ኤን-ሃጾሬ፥ ");
INSERT INTO gmve_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","ዪሮኔ፥ ሚጊዳልኤሌ፥ ሆሬሜ፥ ቤቲ-ኣናቴኔ ቤቲ-ሼሚሼ። ኢስቲ ዉሪ 19፤ ኢስታ ዩሾን ዲዛ ጉታቲካ ኢስታን ጉጄቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","ሃይቲ ኒፍታሌሜ ቆሞታስ ጺንጾ ጊዲዲ ኢስታ ዛርኬን ዛርኬን ጊሻን ጋኪዳ ካታማታኔ ኢስታ ዩሾን ዲዛ ጉታታ። ");
INSERT INTO gmve_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","ላፑንꬆ ሳማይ ዳኔ ቆሞታ ኢስታ ዛርኬን ዛርኬን ጋኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","ኢስቲ ላቲዳ ቢታቲ ጾራኣ፥ ኤሽታኦሌ፥ ኢር-ሼሜሼ፥ ");
INSERT INTO gmve_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","ሻኣልቢኔ፥ ኣያሎኔ፥ ዪታላ፥ ");
INSERT INTO gmve_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","ኤሎኔ፥ ቴሚና፥ ኣቃሮኔ፥ ");
INSERT INTO gmve_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","ኤልቴቄ፥ ጋባቶኔ፥ ባኣላቴ፥ ");
INSERT INTO gmve_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","ዩሁዳ፥ ባኔ-ባራቄ፥ ጌት-ኤርሞኔ፥ ");
INSERT INTO gmve_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","ሜያርቆኔ፥ ኤራቆኔኔ ዮጴ ካታማ ዩሾን ዲዛ ሄራታ ኡባ ኦይኬስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","ጊዶ ኣቲን ዳኔ ቆሞታስ ኢሜቲዳ ጺንጾይ ኢስታስ ጊዶንታ ኣጊዳ ጊሻስ ላይሻ ካታማ ኦሊ ኦይኪዳ፤ ሄ ካታማን ዲዛ ኣሳ ጊꬃ ማሻን ሲፊ ዉርሲዲ ካታማ ባስ ኤኪዲ ሄን ኡቲዳ። ሄ ካታማ ሱንꬃካ ላሚዲ ባ ኣዋ ዳኔ ሱንꬃን ጼይጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","ሃይቲ ዳኔ ቆሞታስ ጺንጾ ጊዲዲ ኢስታ ዛርኬን ዛርኬን ጊሻን ጋኪዳ ካታማታኔ ጉታታ። ");
INSERT INTO gmve_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","ኢስራኤሌ ኣሳይ ባንታና ጋኪዳ ቢታ ኤኪዳፔ ጉዬ ናዌ ና ኢያሶስ ባንታ ቢታፌ ጺንጾ ጋዴ ኢሚዳ፤ ");
INSERT INTO gmve_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","ጎዳይ ኣዛዚዳ ማላኔ ኢያሶይ ኮይዛ ማላ ኤፍሬሜ ጌዜ ዴሬን ዲዛ ቴሚናቴ-ሴራሃ ጌቴቲዛ ካታማ ኢዛስ ኢሚዳ። ኢዚካ ካታማዮ ሎኤꬂዲ ባስ ዱሳሶ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","ቄሴ ኤልኤዜሬይ፥ ናዌ ና ኢያሶይኔ ኢስራኤሌ ቆሞታ ኮራፒኔቲ ሴሎን ጋይቶቴꬃ ዱንካኔዛ ፔንጌን ጎዳ ሲንꬃን ሳማ ዬጊዲ ጊሺዳ ጺንጾ ቢታይ ሃይሳ። ኢስቲ ቢታ ጊሼሬꬂ ጊጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","ሄሳፌ ጉዬ ጎዳይ ኢያሶ፥ ");
INSERT INTO gmve_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","«ታኒ ሙሴ ባጋራ ዮቲዳ ማላ ኣሲ ባቃቲ ኣቲዛ ካታማታ ሻካና ማላ ኢስራኤሌ ኣሳስ ዮታ፤ ");
INSERT INTO gmve_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","ኣይ ኣሲካ ኤሮንታኔ ኣኬኮንታ ኣስ ዎꬊኮ ሄ ባቃቲ ቢዲ ሱꬃ ኣጮፔ ኣታና። ");
INSERT INTO gmve_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","ኣስ ዎꬊዳይ ሄ ካታማታፔ ኢሳኮ ባቃቲ ቢዲ ካታማ ጌሊዛ ፔንጌን ኤቂዲ፥ ሃኒዳይሳ ሄ ካታማ ጪማታስ ዮቶ። ኢስቲካ ባንታ ካታማ ኤፊዲ ኢዚ ዴኣናሶ ኢሚኮ ኢዚ ኢስታራ ሄን ዴኦ። ");
INSERT INTO gmve_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","ሱꬅ ኣዛራና ኮይዛይ ኢዛ ካሊዲ ዪኮ ሄ ካታማ ጪማቲ ኢዛ ኣꬂ ኢሞፌቶ። ጋሶይካ ባ ሾሮዛ ኢዚ ኦዲ ሞርኬቴꬃ ጊሻስ ዎꬊቤና። ");
INSERT INTO gmve_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","ዴራ ሲንꬃን ፒርዳስ ኢዚ ኤቃና ጋካናሲኔ ሄ ዎዴን ዲዛ ቄሴታ ሃላቃይ ሃይቃና ጋካናስ ሄ ካታማን ዴኦ። ሄሳፌ ጉዬ ባቃቲዲ ኬዚዳ ካታማ ጉዬ ሲሚዲ ባ ሶ ጌሎ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","ሂስቲን ኢስራኤሌ ኣሳይ ኒፍታሌሜ ጌዜ ዴሬ፥ ጋሊላን ዲዛ ቃዴሴ፥ ኤፍሬሜ ጌዜ ዴሬን ዲዛ ሴኬሜን ዲዛ ሻራ ሜንꬆ ቦላኔ ዩሁዳን ሻራ ሜንꬆን ዲዛ ቂሪያቴ-ኣርባኤ ዎይኮ ኬብሮኔ ዱማሲዳ። ");
INSERT INTO gmve_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","ዮርዳኖሴ ሻፋፔ ሄ ፒንꬃን፥ ኢያርኮፌ ኣርሼይ ሞኪዛ ባጋራ ኦሮቤሌ ቆሞታ ጺንጾ ጊዶን ባዞን ꬎቃሶ ቦላ ዲዛ ባጺራ፥ ጋዴ ቆሞታ ጺንጾፌ ጋላኣዴን ዲዛ ኤራሞቴኔ ሚናሴ ቆሞታ ጺንጾፌ ባሳኔን ዲዛ ጎላኔ ዱማሲዳ። ");
INSERT INTO gmve_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","ኢስራኤሌ ኣስ ኡባሲኔ ኢስታ ጊዶን ዲዛ ቤቴታስ ዱማሲዳ ካታማቲ ሃይታ፤ ኤሮንታ ዲሼ ኣስ ዎꬊዳ ኣይ ኣሲካ ዴራ ሲንꬃን ኤቃና ጋካናስ ሱꬅ ኣዛራና ኮይዛዴ ኩሼን ሃይቆንታ ማላ ሄ ካታማታፔ ኢሳኮ ባቃታናስ ዳንዳዬስ። ");
INSERT INTO gmve_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","ሌዌ ዛርኬታ ካሌꬂዛይቲ ቄሴ ኤልኤዜሬኮ፥ ናዌ ና ኢያሶኮኔ ኢስራኤሌ ዛሬታ ኣዋታኮ ሺቂዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","ካናኔ ቢታን ዲዛ ሴሎን ኢስታስ፥ «ኑኒ ዴኣና ካታማታኔ ኑ ሜሄ ሄንꬃሶሆታ ኢንቴ ኑስ ኢማና ማላ ጎዳይ ካሴ ሙሴ ባጋራ ኣዛዚ ዎꬂዴስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","ሂስቲን ጎዳይ ኣዛዚዳ ማላ ኢስራኤሌ ኣሳይ ሌዌ ቆሞታስ ባ ላቲዳ ጺንጾታፔ ሃ ካታማታኔ ሜሄ ሄንꬃሶሆታ ቃንጺ ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","ኮይሮ ሳማይ ቃኣቴ ዜሬꬃታስ ኢስታ ዛርኬን ዛርኬን ኬዚዴስ። ቄሴ ኣሮኔ ዛሬ ጊዲዳ ሌዌታስ ዩሁዳፔ፥ ሲሞናፔኔ ቢኒያሜ ቆሞታፔ 13 ካታማቲ ሳማን ጋኪዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","ሃንኮ ኣቲዳ ቃኣቴ ዜሬꬃታስ ኤፍሬሜፔ፥ ዳኔፔኔ ሚናሴስ ባጋ ቆሞታፔ 10 ካታማቲ ሳማን ጋኪዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","ጌርሾኔ ዜሬꬃታስ ዪሳኮሬፔ፥ ኣሴሬፔ፥ ኒፍታሌሜፔኔ ባሳኔን ዲዛ ሚናሴስ ባጋ ቆሞታፔ 13 ካታማቲ ሳማን ጋኪዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","ሜራሬ ዜሬꬃታስ ኢስታ ዛርኬን ዛርኬን ኦሮቤሌፔ፥ ጋዴፔኔ ዛቢሎኔ ቆሞታፔ 10 ካታማቲ ሳማን ጋኪዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","ጎዳይ ሙሴ ባጋራ ኣዛዚዳ ማላ፥ ኢስራኤሌ ኣሳይ ሃ ካታማታኔ ሜሄ ሄንꬃሶሆታ ሌዌታስ ሳማን ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","ዩሁዳፔኔ ሲሞና ቆሞታፔ ሃይሳፌ ካሊ ዲዛ ካታማታ ሳማን ጋꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","ኮይሮ ሳማይ ሌዌ ቆሞ ቃኣቴፔ ዬሌቲዳ ኣሮኔ ዛሬታስ ኬዚን ኢስታስ ኢሜቲዳ ካታማቲ ሃይሳፌ ካሊዛይታ። ");
INSERT INTO gmve_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","ሄይቲካ ዩሁዳ ቢታን ጌዜቲዛሶን ዲዛ ኬብሮኔ ጌቴቲዛ ቂሪያቴ-ኣርባኤኔ ኢዛ ዩሾን ዲዛ ሜሄ ሄንꬃሶሆታ ኢስታስ ኢሚዳ። (ኣርባኤይ ኤናቄ ኣዋ።) ");
INSERT INTO gmve_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","ጊዶ ኣቲን ሄ ካታማ ዩሾን ዲዛ ሜሄ ሄንꬃሶሆታኔ ሞꬃታ ዮፊኔ ና ካሌቤስ ጺንጾ ሂስቲ ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","ቄሴ ኣሮኔ ዛሬታስ ኣስ ዎꬊዳ ኣሲ ባቃቲ ቢዲ ኣቲዛ ኬብሮኔኔ ሊቢና ካታማታ ኢስታ ሜሄ ሄንꬃሶሆራ ኢሲፌ ጋꬂ ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","ዬቲሬኔ ኤሽታሞኣ፥ ");
INSERT INTO gmve_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","ሆሎኔኔ ዳቢሬ፥ ");
INSERT INTO gmve_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","ኣዪኔ፥ ዩጻ፥ ቤቲ-ሼሚሼኔ ኢስታ ሜሄ ሄንꬃሶሆራ ኢሲፌ ጋꬂ ኢሚዳ። ሃይቲ ኡዱፉን ካታማቲ ዩሁዳ ቆሞታፔኔ ሲሞና ቆሞታ ጺንጾፌ ጊሼቲ ኢሜቲዳይታ። ");
INSERT INTO gmve_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","ቢኒያሜ ቆሞታፔ ጌባኦኔ፥ ጌባ፥ ");
INSERT INTO gmve_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","ኣናቶቴ፥ ኣልሞኔ ጌቴቲዛ ኦይዱ ካታማታኔ ኢስቲ ሜሄ ሄሚዛሶሆራ ኢሲፌ ጋꬂ ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","ቄሴ ኣሮኔ ዜሬꬃታስ ሜሄ ሄንꬃሶሆራ ኢሲፌ ጋꬂዲ 13 ካታማታ ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","ሃንኮ ኣቲዳ ሌዌ ና ቃኣቴ ዛሬታስ ኤፍሬሜ ቆሞታፔ ሃይሳፌ ካሊ ዲዛይሲ ሳማን ጋኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","ኤፍሬሜ ጌዜ ዴሬን ዲዛ ኣስ ዎꬊዳ ኣሲ ባቃቲ ቢዲ ኣቲዛሶ ሴኬሜኔ ጌዜሬ፥ ");
INSERT INTO gmve_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","ቂቢጻይሜ፥ ቤቲ-ሆሮኔኔ ኢስታ ሜሄ ሄንꬃሶሆራ ኢሲፌ ጋꬂዲ 4 ካታማታ ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","ዳኔ ቆሞታፔ ኤልቴቄ፥ ጋባቶኔ፥ ");
INSERT INTO gmve_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","ኣያሎኔ፥ ጌት-ኤርሞኔኔ ኢስታ ሜሄ ሄንꬃሶሆራ ኢሲፌ ጋꬂ 4 ካታማታ ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","ሚናሴ ቆሞታስ ባጋታፔ ታኢናኬ፥ ጌት-ኤርሞኔ ሜሄ ሄንꬃሶሆታራ ኢሲፌ ጋꬂ 2 ካታማታ ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","ሃይቲ 10 ካታማቲ ኡባይ ሜሄ ሄንꬃሶሆታራ ኢሲፌ ሃንኮ ኣቲዳ ቃኣቴ ዛሬታስ ኢሜቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","ሚናሴ ዛሬታ ባጋታፔ ኣስ ዎꬊዳ ኣሲ ባቃቲ ቢዲ ኣቲዛ፥ ባሳኔን ዲዛ ጎላኔ ካታማ ሜሄ ሄንꬃሶሆራ ባኤሽቲራ ሜሄ ሄንꬃሶሆራ፥ ናምኡ ካታማታ ኡባ ኤኪዲ፥ ጌርሾኔ ዛሬ ጊዲዳ ሃራ ሌዌታስ ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","ዪሳኮሬ ዛሬታፔ ቂሶኔ ሜሄ ሄንꬃሶሆራ፥ ዳቢራቴ ሜሄ ሄንꬃሶሆራ፥ ");
INSERT INTO gmve_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","ያርሙቴ ሜሄ ሄንꬃሶሆራ፥ ኤን-ጋኒሜ ሜሄ ሄንꬃሶሆራ፥ ኦይዱ ካታማታ ኡባ ኤኪዲ ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","ኣሴሬ ዛሬታፔ ሚሻሌ ሜሄ ሄንꬃሶሆራ፥ ኣብዶኔ ሜሄ ሄንꬃሶሆራ፥ ");
INSERT INTO gmve_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","ሄልቃቴ ሜሄ ሄንꬃሶሆራኔ ኤራሆቤ ሜሄ ሄንꬃሶሆራ፥ ኦይዱ ካታማታ ኡባ ኤኪዲ ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","ሄሳꬆካ ኒፍታሌሜ ዛሬታፔ ኣስ ዎꬊዳ ኣሲ ባቃቲ ቢዲ ኣቲዛ ጋሊላን ዲዛ ቃዴሴ ሜሄ ሄንꬃሶሆራ፥ ሃሞቲ-ዶሬ ሜሄ ሄንꬃሶሆራ፥ ቃርታ ሜሄ ሄንꬃሶሆራ፥ 3 ካታማታ ኡባ ኤኪዲ ኢስታስ ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","ጌርሾኔ ዛሬታ ካታማቲኔ ኢስታ ሜሄታ ሄንꬃሶሆቲ ኡባይ ታማኔ ሄꬓ። ");
INSERT INTO gmve_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","ኣቲዳ ሜራሬ ዛሬ ጊዲዳ ሌዌታስ ኢሜቲዳ ቢታቲ ዛቢሎኔ ዛሬታፔ ዮቂናኣሜ ሜሄ ሄንꬃሶሆራ፥ ቃርታ ሜሄ ሄንꬃሶሆራ፥ ");
INSERT INTO gmve_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","ዲሚና ሜሄ ሄንꬃሶሆራ፥ ናሂላሌ ሜሄ ሄንꬃሶሆራ፥ ኦይዱ ካታማታ ኡባ ኤኪዲ ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","ኦሮቤሌ ዛሬታፔ ባጺራኔ ሜሄ ሄንꬃሶሆታ፥ ያሃጼኔ ሜሄ ሄንꬃሶሆታ፥ ");
INSERT INTO gmve_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","ቂዲሞቴኔ ኢዚ ሜሄ ሄንꬃሶሆታ፥ ሜፋኣቴኔ ሜሄ ሄንꬃሶሆታ፥ ሃይታ ኦይዱ ካታማታ ኡባ ኤኪዲ ኢስታስ ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","ቃሴ ጋዴ ዛሬታፔ ኣስ ዎꬊዳ ኣሲ ባቃቲ ቢዲ ኣቲዛ፥ ጋላኣዴን ዲዛ ኤራሞቴ ሜሄ ሄንꬃሶሆራ፥ ማሃናይሜ ሜሄ ሄንꬃሶሆራ፥ ");
INSERT INTO gmve_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","ሃሴቦኔ ሜሄ ሄንꬃሶሆራ፥ ኢያዜሬ ሜሄ ሄንꬃሶሆራ፥ ሃይታ ኦይዱ ካታማታ ኡባ ኤኪዲ ኢስታስ ኢሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","ሜራሬይ ዛሬ ጊዲዳ ሃራ ሌዌታስ ጊሻን ጋኪዳ ካታማቲ ኡባይ ታማኔ ናምኣ። ");
INSERT INTO gmve_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","ኢስራኤሌ ኣሳይ ላቲዳ ቢታን ዲዛ ሌዌታስ ኢሜቲዳ ካታማቲ ኢስታ ሜሄ ሄንꬃሶሆራ ኡባይ ኢሲ ቦላ ኦይዱ ታማኔ ኦስፑና። ");
INSERT INTO gmve_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","ሄ ካታማታ ኡባ ዩሾን ሜሄ ሄሚዛሶሆቲ ዴቴስ። ሜሄ ሄሚዛሶሆይ ባይንዳ ካታማይ ዴና። ");
INSERT INTO gmve_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","ሄሳꬆ ኦꬂዲ ጎዳይ ኢስታ ኣዋታስ ኢማናስ ጫቂዳ ቢታ ኡባ ኢስራኤሌ ኣሳስ ኢሚዴስ፤ ሂስቲን ኢስቲ ላቲዲ ሄን ዴኢዳ። ");
INSERT INTO gmve_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","ጎዳይ ኢስታ ኣዋታስ ጫቂዳ ማላ ኢስታ ዩሾን ዲዛ ኡባታፔ ኢስታ ሼምፒሲዴስ። ጎዳይ ኢስታ ሞርኬታ ኡባ ኢስታስ ኣꬂ ኢሚዳ ጊሻስ ኢስታ ሞርኬታፔ ኢሶይካ ኢስታራ ኤቄታናስ ዳንዳይቤና። ");
INSERT INTO gmve_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","ጎዳይ ኢስራኤሌ ኣሳስ ኢማና ጊዳ ሎኦ ቃላ ኡባ ፖሊዴስ ኣቲን ኢሶይኔ ሳኣን ዎꬊ ኣቲቤና። ");
INSERT INTO gmve_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","ሄሳፌ ጉዬ ኢያሶይ ኦሮቤሌ ቆሞታ፥ ጋዴ ቆሞታኔ ሚናሴ ቆሞታፔ ባጋታ ጼይጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","ሂስቲዲ፥ «ጎዳ ኣይሌ ሙሴይ ኢንቴና ኣዛዚዳይሳ ኡባ ናጊዴታ፤ ቃሴ ታኒካ ኣዛዚዳይሳ ሙሌራ ፖሊዴታ። ");
INSERT INTO gmve_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","ዳሮ ዎዴፔ ዶሚዲ ሃች ጋካናስ ኢንቴ ኢንቴ ኢሻታ ዬጊቤኬታ፤ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዳ ሃዳራ ፖሊዴታ። ");
INSERT INTO gmve_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","ሄኮ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዳ ሂዶታ ቃላ ማላ ኢንቴ ኢሻታ ሼምፒሲዴስ። ሄሳ ጊሻስ ጎዳ ኣሽካራ ሙሴይ ኢንቴስ ዮርዳኖሴ ሻፋፔ ሄ ፒንꬃን ኢሚዳ ላታ ቢታን ዲዛ ኢንቴ ሶ ሶ ሲሚቴ። ");
INSERT INTO gmve_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","ጎዳ ኣይሌ ሙሴይ ኢንቴና ኣዛዚዳ ኣዛዞዛኔ ዎጋ ኢንቴ ናጊቴ። ጎዳ ኢንቴ ጾሳ ሲቂቴ፤ ኢዛ ኦጌታ ኡባን ሲሜሬቲቴ፤ ኢዛ ኣዛዞታ ፖሊቴ፤ ኢዛካ ሚንꬂ ኦይኪቴ፤ ኢንቴ ኩሜꬃ ዎዚናፔኔ ኩሜꬃ ሼምፖፌ ኢዛስ ኦꬃና ማላ ኢዚ ኢሚዳ ኣዛዞታኔ ዎጋታ ሚንꬂ ናጊቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","ሄሳፌ ጉዬ ኢያሶይ ኢስታ ኣንጂ ዬዲን ኢስቲካ ባንታ ሶ ሶ ሲሚ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","ሙሴይ ሚናሴ ቆሞፌ ባጋታስ ባሳኔ ቢታን ጺንጾ ኢሚዴስ፤ ሃንኮ ኣቲዳ ባጋታስ ኢያሶይ ዮርዳኖሴፔ ኣርሼይ ዉሊዛ ባጋፌ ኢስታ ኢሻታ ጊዶን ኢስታስ ጺንጾ ኢሚዴስ። ኢያሶይ ኢስታ ባንታ ሶ ሶ ሲማና ማላ ሞይዚዛ ዎዴ ኢስታ ኣንጂሼ፥ ");
INSERT INTO gmve_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","«ቤኢቴ፥ ኢንቴ ሃኢ ዳሮ ኣቆታ ኤኪዲ፥ ዳሮ ሜሄ ዉዴ፥ ቢራ፥ ዎርቃ፥ ጻርቂማላ፥ ቢራታኔ ዳሮ ማይኦ ኤኪዲ ኢንቴ ሶ ሲሚቴ። ሄሳ ጊሻስ ኢንቴ ሞርኬታፔ ዲኤቲዳይሳ፥ ኢንቴ ኢሻታራ ጊሼቲ ኤኪቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","ሄሳ ጊሻስ ኦሮቤሌ ቆሞቲኔ ጋዴ ቆሞቲ ሄሳꬆካ ሚናሴ ቆሞፌ ባጋቲ ኢስራኤሌ ኣሳ ካናኔን ዲዛ ሴሎን ኣጊዲ ካሴ ሙሴ ባጋራ ጎዳ ኣዛዞን ላታ ኤኪዳ ጺንጾን ጋላኣዴ ሲሚ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","ኦሮቤሌ ቆሞቲ፥ ጋዴ ቆሞቲኔ ሚናሴ ቆሞታፔ ባጋቲ ዮርዳኖሴ ሻፋ ማታን ካናኔ ቢታን ዲዛ ጋላኣዴ ዪዳ ዎዴ ሻፋ ማታን ጊታ ያርሾሶሆ ጊግሲዳ። ");
INSERT INTO gmve_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","ሂስቲን ኢስቲ ኢስራኤሌ ቢታን፥ ካናኔ ዛዋን፥ ጋዴን ጊታ ያርሾሶሆ ጊግሲዳይሳ ሃራ ኢስራኤሌ ኣሳይ ሲዪዳ ዎዴ ");
INSERT INTO gmve_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","ኩሜꬃ ኢስራኤሌ ኣሳይ ኢስታ ኦላና ባናስ ሴሎን ኢሲፌ ሺቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","ሂስቲዲ ኢስራኤሌ ኣሳይ ቄሴ ኤልኤዜሬ ና ፊኒሃሴ፥ ጋላኣዴ ቢታን ዲዛ ኦሮቤሌ ቆሞታኮ፥ ጋዴ ቆሞታኮኔ ሚናሴ ቆሞታፔ ባጋታኮ ኪቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","ኩሜꬃ ኢስራኤሌ ቆሞታ ባ ቆሞታ ሃላቃታፔ ኢሲ ኢሲ ኣስ ዶሪዲ፥ ታሙ ኣስ ፊኒሃሴራ ጋꬂ ዬዲዴስ። ሃይቲ ኢሶይ ኢሶይ ኢስራኤሌ ቆሞታፔ ዪዳ ባንታ ዛርኬን ዛርኬን ዶሬቲዳ ሃላቃታ። ");
INSERT INTO gmve_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","ኢስቲ ኦሮቤሌ ቆሞቲ፥ ጋዴ ቆሞቲኔ ሚናሴ ቆሞታፔ ባጋቲ ዲዛ ጋላኣዴ ቢታ ቢዲ ኢስታስ፥ ");
INSERT INTO gmve_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","«ጎዳ ኣሳይ ኩሜꬅ ኢንቴና፥ ‹ኢስራኤሌ ጾሳ ቦላ ኣይስ ሃይሳ ማላ ኢታ ኦꬂዴቲ? ዋኒዲ ኢንቴ ሃራ ያርሾ ያርሺዛሶ ኢንቴስ ጊግሲዴቲ? ጎዳ ቦላ ዋኒ ማካሊዴቲ? ኢዛ ካሊዛይሳካ ዋኒዲ ኣጊዴቲ? ");
INSERT INTO gmve_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","ፔኦሬን ኑኒ ኦꬂዳ ናጋራይ ኑስ ጊዴኔ? ኢስራኤሌ ዴራ ቦላ ቦሻይ ዎꬊዳ ጊዲኮካ ሃች ጋካናስካ ኑኒ ሄ ናጋራፔ ጌዪቦኮ። ");
INSERT INTO gmve_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","ኢንቴ ሃኢካ ጎዳ ካሊዛይሳ ኣጊዲ ጉዬ ጉዬ ጌቲ? « ‹ኢንቴ ሃች ጎዳ ቦላ ማካሊኮ ኢዚ ዎንቶ ኩሜꬃ ኢስራኤሌ ዴራ ሃንቄታና። ");
INSERT INTO gmve_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","ኢንቴ ላቲዳ ቢታይ ቱኒዳ ጊዲኮ ጎዳ ዱንካኔይ ኤቂዳ ጎዳ ቢታ ሃ ዪዲ፥ ኑናራ ጋዴ ጊሼቲ ኤኪቴ። ጊዶ ኣቲን ካሴፔ ዲዛ ጎዳ ኑ ጾሳ ያርሾሶፔ ሃራ ያርሾሶሆ ጊግሲዲ ጎዳ ቦላ ዎይኮ ኑ ቦላ ማካሎፍቴ። ");
INSERT INTO gmve_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","ዛራሄ ና ኣካኔይ ፒላ ጊዲዳይሳ ኤኪዲ፥ ናጋራ ኦꬂዳ ጊሻስ፥ ኩሜꬃ ኢስራኤሌ ዴራ ቦላ ጎዳ ሃንቆይ ዎꬊቤኔ? ኢዛ ናጋራ ጋሶን ሃይቂዳይ ኢዛ ጻላላ ጊዴና› ጌቴስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","ሂስቲን ኦሮቤሌ ቆሞቲ፥ ጋዴ ቆሞቲኔ ሚናሴ ቆሞታፔ ባጋቲ ኢስራኤሌ ቆሞታ ሃላቃታስ ዛሪዲ፥ ");
INSERT INTO gmve_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","«ጎዳይ ዎልቃማ ጾሳይ! ጎዳይ ዎልቃማ ጾሳይ! ኑኒ ሃይሳ ኣይስ ኦꬂዳኮ ኢዚ ኤሬስ! ኑኒ ኣይስ ኦꬂዳኮ ኢንቴካ ኤራና ማላ ኮዮስ። ኑኒ ሃይሳ ኦꬂዳይ ማካላቴꬃኒኔ ጎዳስ ኣዛዜቴꬃ ኢጾን ጊዲኮ፥ ሃች ኑና ማሮፒቴ። ");
INSERT INTO gmve_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","ኑኒ ጎዳ ካሊዛይሳ ኣጊዲ ጹጌቲዛ ያርሾ፥ ካꬃ ያርሾኔ ኢሲፌቴꬃ ያርሾ ያርሻናስ ቆፒዲ ጊግሲዳ ጊዲኮ፥ ጎዳይ ኑ ቦላ ባ ሃሎ ኬሶ። ");
INSERT INTO gmve_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","ኑኒ ሄሳꬆ ኦꬂዳይ ሲንꬃፌ ያና ኢንቴ ዜሬꬃቲ ኑ ዜሬꬃታ፥ ‹ጎዳ ኢስራኤሌ ጾሳራ ኢንቴስ ኣዛ ጋይቶቴꬂ ዲዜ? ");
INSERT INTO gmve_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","ኢንቴኖ ኦሮቤሌኔ ጋዴ ቆሞቶ፥ ጎዳይ ኑ ጊዶኒኔ ኢንቴ ጊዶን ዮርዳኖሴ ሻፋን ዛዋ ዛሪዳ ጊሻስ፥ ጎዳን ኢንቴና ጋꬂዛ ሚሺ ዴና› ጊዲ ኢንቴ ዛሬቲ ኑ ዛሬታ ጎዳስ ጎይኖንታ ማላ ቴቆንታ ኣጌቴና ጊ ሂርጊዶስ» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","«ሄሳ ጊሻስ፥ ‹ኑኒ ኑ ጊዶን ያርሾ ያርሺዛሶሆ ኣኔ ኦꬆስ፤ ጊዶ ኣቲን ጹጌቲዛ ያርሾስ ዎይኮ ሃራ ያርሾስ ጊዴና› ጊዳይ ሄሳሳ። ");
INSERT INTO gmve_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","ኑኒ ያርሾሶሆ ጊግሲዳይ ጹጌቲዛ ያርሾ፥ ኢሲፌቴꬃ ያርሾኔ ሃራ ያርሾ ያርሺዲ፥ ጎዳስ ኢዛ ዱንካኔን ጎይኒዛይሳ ሃይሲ ያርሾሶሆዚ ኑ ጊዶኒኔ ኢንቴ ጊዶን፥ ቃሴ ኑፔ ካሊዛ ዬሌታታ ጊዶን ማርካ ጊዳና። ዎዴፔ ኢንቴ ዜሬꬃቲ ኑ ዜሬꬃታ፥ ‹ኢንቴና ጎዳን ጋꬂዛይ ኣይኮይካ ዴና› ጋናስ ዳንዳዬቴና። ");
INSERT INTO gmve_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","ኢስቲ ኑና ዎይኮ ኑ ዜሬꬃታ ዎዴፔ ሄሳꬆ ጊኮ ኑኒ ኢስታስ ዛሪዲ፥ ‹ሄኮ! ኑ ኣዋቲ ጎዳሲ ያርሺዛሶሆ ሌሚሶ ኦꬂዳይሳ ቤኢቴ። ሃይሳ ኑ ኣዋቲ ጹጌቲዛ ያርሾኔ ሃራ ያርሾ ያርሻናስ ጊዶንታ፥ ኢንቴፌኔ ኑፔ ጊዶን ማርካ ጊዳና ማላ ጊግሲዳ› ጋና። ");
INSERT INTO gmve_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","ጎዳ ኑ ጾሳ ዱንካኔዛ ሲንꬃን ኤቂዳ ያርሾ ያርሺዛሶሆፔ ሃራ፥ ጹጌቲዛ ያርሾ፥ ካꬃ ያርሾኔ ሃራ ያርሾ ያርሺዛሶሆ ጊግሲዲ ጎዳ ቦላ ማካሎይ ኑፔ ሃኮ!» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","ቄሴ ፊኒሃሲኔ ኢዛራ ዲዛ ኢስራኤሌ ቆሞታ ሃላቃቲ፥ ኦሮቤሌ፥ ጋዴኔ ሚናሴ ቆሞቲ ዮቲዳይሳ ሲዪዲ፥ ኬሂ ኡፋዬቲዳ። ");
INSERT INTO gmve_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","ቄሴ ኤልኤዜሬ ና ፊኒሃሲ ኦሮቤሌ፥ ጋዴኔ ሚናሴ ቆሞታስ፥ «ጎዳይ ኑ ጊዶን ዲዛይሳ ኑኒ ሃች ኤሪዶስ፤ ኣይስ ጊኮ ሃ ዮኦዛ ኢንቴ ጎዳ ቦላ ማካላናስ ኦꬂቤኬታ። ኢንቴ ሃኢ ጎዳ ሃንቆፌ ኢስራኤሌ ኣሳ ኣሺዴታ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","ሄሳፌ ጉዬ ቄሴ ኤልኤዜሬ ና ፊኒሃሲኔ ዴራ ካሌꬂዛይቲ ጋላኣዴን ዲዛ ኦሮቤሌኔ ጋዴ ቆሞታራ ሃሳዬቲዳፔ ጉዬ ካናኔን ዲዛ ኢስራኤሌ ኣሳኮ ሲሚዳ፤ ሂስቲዲ ሃኒዳይሳ ኢስታስ ዮቲዳ። ");
INSERT INTO gmve_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","ኢስራኤሌ ኣሳይ ሄሳ ሲዪዲ ኡፋይሳን ጾሳ ጋላቲዴስ። ቃሴ ኦሮቤሌ ቆሞቲኔ ጋዴ ቆሞቲ ዲዛ ቢታ ኦሊ ꬋይሳናስ ባና ጊዳይሳ ኣጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","ኦሮቤሌይኔ ጋዴ ቆሞቲ፥ «ጎዳይ ኢዚ ጾሳ ጊዲዳይሳስ ሃይሲ ኑ ጊዶን ማርካ» ጊዲ ያርሾሶሆዛ፥ «ማርካ» ጊ ሱንꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","ዳሮ ዎዴስ ጎዳይ ኢስራኤሌ ኣሳ ኢስታ ዩሾን ዲዛ ሞርኬታ ኡባፌ ሼምፒሲዴስ። ሄ ዎዴ ኢያሶይ ጪሚዲ ኬሂፔ ዎዴ ሱጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","ኢያሶይ ኢስራኤሌ ኣሳ ኡባ፥ ጪማታ፥ ሹሜታ፥ ዳናታኔ ፒርዲዛይታ ኢሲፌ ጼይጊ ሺሺዲ፥ «ታኒ ጪማዲስ፥ ዎዴይካ ታስ ኬሂ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","ጎዳ ኢንቴ ጾሳይ ኢንቴ ጊሻስ ሃ ካዎቴꬃታ ቦላ ኦꬂዳ ኡባ ሚሽ ኢንቴ ኢንቴ ኣይፌን ቤዪዴታ። ኢንቴ ጊሻስ ኦሌቲዳይ ጎዳ ኢንቴ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","ቤኢቴ፥ ዮርዳኖሴ ሻፋፔ ዶሚዲ ኣርሼይ ዉሊዛሶ ባጋን ሜዲቴራኔ ኣባ ጋካናስ ዲዛሶታ ኡባ፥ ኢንቴ ጾኒዳ ካዎቴꬃታፔ ኢንቴ ቡሮ ላቶንታ ቢታታ ታኒ ኢንቴ ቆሞታስ ሳማን ሳማን ዎስታ ጊሺዳኮ ኣኬኪቴ። ");
INSERT INTO gmve_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","ጎዳ ኢንቴ ጾሳይ ኢስታ ኢንቴ ሲንꬃፌ ኢስቲ ዲዛሶዛፔ ኢስታ ዬዴꬃና፤ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዳ ሂዶታ ቃላ ማላ ኢንቴ ኢስታ ቢታ ላታና። ");
INSERT INTO gmve_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","«ሚኒቴ! ሃዲርሲኔ ኡሻች ጎፒቴ፤ ሙሴ ዎጋ ማጻፋን ጻፌቲዳ ኡባ ናጋናሲኔ ኦꬃናስ ኬሂፔ ሚኔቲቴ። ");
INSERT INTO gmve_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","ሃይታ ኢንቴ ጊዶን ኣቲዳ ካዎቴꬃታራ ኢሲፌቶፍቴ፤ ኢስታ ኤቃ ጾሳታ ሱንꬃ ጼይጎፒቴ፤ ኢስታ ሱንꬃን ጫቆፍቴ፤ ኢስታስ ኦꬆፍቴኔ ጎይኖፍቴ። ");
INSERT INTO gmve_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","ጊዶ ኣቲን ሃች ጋካናስ ኢንቴ ኦꬂዳ ማላ ጎዳ ኢንቴ ጾሳ ሚንꬂ ኦይኪቴ። ");
INSERT INTO gmve_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","«ጎዳይ ጊታኔ ሚኖ ካዎቴꬃታ ኢንቴ ሲንꬃፌ ጎዲ ኬሲዴስ፤ ሃች ጋካናስ ኦኒካ ኢንቴናራ ኤቄታናስ ዳንዳይቤና። ");
INSERT INTO gmve_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዳ ሂዶታ ቃላ ማላ ኢዚ ኦሌቲዛ ጊሻስ ኢንቴፌ ኢሲ ኣሲ ሺ ኣስ ዬዴꬃና። ");
INSERT INTO gmve_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","ሄሳ ጊሻስ ጎዳ ኢንቴ ጾሳ ሚኒ ሲቂቴ። ");
INSERT INTO gmve_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","ጊዶ ኣቲን ኢንቴ ጉዬ ሲሚዲ ሃንኮ ኣቲዳ ኢንቴናራ ዲዛ ካዎቴꬃታራ ኢንቴ ኢሲፌቲኮ፥ ኤኮን ጌሎን ኢስታራ ኢሲፌ ዋላኬቲኮ፥ ");
INSERT INTO gmve_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","ጎዳ ኢንቴ ጾሳይ ሃይሳፌ ጉዬ ኢንቴ ሲንꬃፌ ኢስታ ኬሲ ጎዶንታይሳ ኢንቴ ኤራናስ ቤሴስ፤ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዳ ሃ ሎኦ ቢታይፌ ኢንቴ ꬋያና ጋካናስ ኢስቲ ኢንቴስ ዎጺማዴኔ ያርዴ ጊዳና፤ ኢንቴ ዞኮስ ሊሶ፥ ኢንቴ ኣይፌሲካ ኣጉንꬅ ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","«ቤኢቴ ታስ ሃኢ ሃይቆ ዎዴይ ጋኪዴስ፤ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዳ ሎኦ ሂዶታ ኡባፌ ኢሲኖካ ኢዚ ኣሾንታይሳ ኢንቴ ኩሜꬃ ዎዚናፔኔ ኩሜꬃ ሼምፖፌ ኤሬታ፤ ኢዚ ኢንቴስ ኢማና ጊዳ ሂዶታይ ፓጬይ ባይንዳ ሙሌራ ፖሌቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","ጊዶ ኣቲን ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዳ ሎኦ ሂዶታ ኡባይ ሙሌራ ፖሌቲዳ ማላ ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዳ ሎኦ ቢታይፌ ኢንቴና ꬋይሳና ጋካናስ ኢታ ሚሽ ኢንቴ ቦላ ኤሃና። ");
INSERT INTO gmve_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","ጎዳ ኢንቴ ጾሳይ ኢንቴስ ኢሚዳ ጫቆ ቃላ ኢንቴ ላሊዛ ጊዲኮ፥ ቢዲ ሃራ ኤቃ ጾሳታስ ሃጋዚኮኔ ጎይኒኮ ጎዳ ሃንቆይ ኢንቴ ቦላ ታማ ማላ ኤጺ ኬዛና፤ ኢዚ ኢንቴስ ኢሚዳ ሎኦ ቢታይፌ ኢንቴ ኤሶን ꬋያና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","ሄሳፌ ጉዬ ኢያሶይ ኢስራኤሌ ቆሞታ ኡባ ሴኬሜን ሺሺዴስ። ጪማታ፥ ካሌꬂዛይታ፥ ዳናታኔ ፒርዲዛይታ ኡባ ጼይጊዴስ፤ ኢስቲካ ጾሳ ሲንꬅ ሺቂዳ። ");
INSERT INTO gmve_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","ኢያሶይ ዴራ ኡባስ፥ «ጎዳ ኢስራኤሌ ጾሳይ፥ ‹ካሴ ኢንቴ ኣዋቲ ኣብራሃሜኔ ናኮሬ ኣዋ ታራ ጉጂዲ ኤፊራጺሴ ሻፋፔ ሄ ፒንꬃን ዴኢዳ፤ ኢስቲ ሃራ ኤቃ ጾሳታስ ጎይኒዳ። ");
INSERT INTO gmve_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","ታኒ ጊዲኮ ኢንቴ ኣዋ ኣብራሃሜ ኤፊራጺሴ ሻፋስ ሄ ፒንꬃፌ ኤሃዲስ፤ ካናኔ ቢታንካ ካሌꬃዲስ። ኢዛ ዜሬꬃታካ ዳርሳዲስ፤ ዪሳቃካ ኢዛስ ኢማዲስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","ዪሳቃስካ ያቆቤኔ ኤሳዌ ኢማዲስ። ኤሳዌስ ጌዜቲዛ ሴይሬ ቢታ ጺንጾ ሂስታ ኢማዲስ፤ ያቆቤይኔ ኢዛ ናይቲ ጊዲኮ ዱጌ ጊብጼ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","« ‹ሄሳፌ ጉዬ ሙሴኔ ኣሮኔ ኪታዲስ፤ ታ ኤሂዳ ቦሻን ጊብጼታ ኡንኤꬃዳ ኢንቴና ሄፔ ኬሳዲስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","ታኒ ኢንቴ ኣዋታ ጊብጼፔ ኬሲን ዞኦ ኣባኮ ዪዴታ፤ ጊብጼቲ ፓራ-ጋሬታኒኔ ቶጋ ኣሳታን ኢንቴና ዞኦ ኣባ ጋካናስ ኦይካና ካሊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","ኢንቴ ኣዋቲ ማዶ ዴማናስ ታኮ ዋሲዳ፤ ታኒ ኢስታፌኔ ጊብጼታፔ ጊዶን ꬉማ ዬጋዲስ፤ ሂስታዳ ኣባይ ኢስታ ቦላ ሲማና ማላኔ ኢስታ ሚታና ማላ ኦꬃዲስ። ታኒ ጊብጼታ ቦላ ኦꬂዳይሳ ኢንቴ ኢንቴ ኣይፌን ቤኢዴታ። ኢንቴካ ባዞን ዳሮ ዎዴ ዴኢዴታ። ");
INSERT INTO gmve_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","« ‹ሄሳፌ ጉዬ ዮርዳኖሴ ሻፋፔ ኣርሼይ ሞኪዛሶ ባጋራ ዲዛ ኣሞሬታ ቢታ ታኒ ኢንቴና ኤሃዲስ። ኢስቲ ኢንቴናራ ኦሌቲን ታኒ ኢስታ ኢንቴ ኩሼን ኣꬃ ኢማዲስ፤ ታኒ ኢስታ ኢንቴ ሲንꬃፌ ꬋይሳዲስ፤ ቃሴ ኢንቴ ኢስታ ቢታ ላቲዴታ። ");
INSERT INTO gmve_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","ሄሳፌ ጉዬ ሞኣቤ ቢታ ካዎ ጺፖራ ና ባላቄይ ኢስራኤሌ ኦላናስ ዴንዲዴስ፤ ኢንቴና ዪዲ ዶቃና ማላ ቢኦሬ ና ባላሜስ ኪታ ዬዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","ታኒ ጊዲኮ ባላሜ ሲያና ኮያቤኬ፤ ሄሳ ጊሻስ ኢዚ ኢንቴና ዛሪ ዛሪ ኣንጂዴስ፤ ታኒካ ኢንቴና ባላቄ ኩሼፔ ኣሻዲስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","« ‹ሄፔ ኢንቴ ዮርዳኖሴ ሻፋ ፒኒዲ ኢያርኮ ዪዴታ፤ ኣሞሬቲ፥ ፓሪዜቲ፥ ካናኔቲ፥ ሂቴቲ፥ ጌርጌሴቲ፥ ሂዌቲኔ ያቡሴቲ ኢንቴናራ ኦሌቲዳ ማላ ኢያርኮ ኣሳይ ኢንቴናራ ኦሌቲዴስ፤ ጊዶ ኣቲን ታኒ ኢስታ ኢንቴ ኩሼን ኣꬃ ኢማዲስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","ኢንቴፌ ሲንꬄ ካዤ ኪታዳ ኢስታኔ ኣሞሬ ካዎ ናምኣታ ኢንቴ ሲንꬃፌ ጎዳዲስ። ሃይሲ ኡባይ ሃኒዳይ ኢንቴ ማሻኒኔ ኢንቴ ዎንዳፌን ጊዴና። ");
INSERT INTO gmve_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","ኢንቴ ዳቡሮንታ ቢታኔ ኢንቴ ኬጾንታ ካታማታ ታኒ ኢንቴስ ኢማዲስ፤ ሄኮ ኢንቴ ቶኮንታ ዎይኔ ኣይፌኔ ዎጋራ ኣይፌ ሜታ› ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","«ሄሳ ጊሻስ ሃኢካ ጎዳስ ያዪቴ፤ ኩሜꬃ ዎዚናፔ ኣማኔቴꬃን ኢዛስ ሃሬቲቴ፤ ካሴ ኢንቴ ኣዋቲ ኤፊራጺሴ ሻፋፔ ሄ ፒንꬃኒኔ ጊብጼ ቢታን ጎይኒዳ ኤቃ ጾሳታ ኢንቴፌ ሃሲቴ፤ ጎዳስ ጻላ ጎይኒቴ። ");
INSERT INTO gmve_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","ጎዳስ ጎይኖይ ኮሾንታ ሚሽ ሚሳቲ ኢንቴስ ቤቲኮ ካሴ ኢንቴ ኣዋቲ ሻፋፔ ሄ ፒንꬃን ዲሼ ጎይኒዳ ኤቃ ጾሳታ ዎይኮ ሃኢ ኢንቴ ዲዛ ኣሞሬቲ ጎይኒዛ ጾሳታ ጎይናና ጊዲኮ ኢንቴ ጎይናናይሳ ሃች ዶሪቴ፤ ታኒኔ ታ ኬꬃ ኣሳይ ጊዲኮ ጎዳስ ጎይናና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","ሂስቲን ኣሳይ ዛሪዲ፥ «ጎዳ ኣጊዲ ሃራ ኤቃ ጾሳታስ ጎይኖይ ኑፔ ሃኮ! ");
INSERT INTO gmve_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","ጊብጼ ኣይሌቴꬃ ቢታፌ፥ ኑናኔ ኑ ኣዋታ ኬሲዲ ኤሂዳይ፥ ሄ ጊታ ማላታታ ኑ ሲንꬃን ኦꬂዳይ፥ ኑ ቢዛ ኦጌ ኡባኒኔ ኑ ካንꬂዳ ካዎቴꬃታ ኡባ ጊዶን ኑና ናጊዳይ ጎዳ ኑ ጾሳ። ");
INSERT INTO gmve_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","ቃሴ ጎዳይ ሄ ቢታን ዲዛ ኣሞሬታራ ጉጂን ዴራ ኡባ ኑ ሲንꬃፌ ጎዲዴስ፤ ሄሳ ጊሻስ ኑኒ ጎዳስ ጎይናና፤ ኢዚ ኑ ጾሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","ኢያሶይካ ዴራስ፥ «ኢንቴ ጎዳስ ጎይናናስ ዳንዳዬኬታ፤ ኢዚ ጌሻ ጾሳ፤ ኢዚ ቃናቲዛ ጾሳ፤ ኢዚ ኢንቴ ማካላቴꬃኔ ኢንቴ ናጋራ ኣቶ ጌና። ");
INSERT INTO gmve_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","ኢንቴ ጎዳ ኣጊዲ ኣላጋ ጾሳታስ ጎይኒኮ ኢዚ ኢንቴስ ሎኦ ኦꬂዳፔ ጉዬ ሲሚ ዎꬊዲ ኢዚ ኢንቴ ቦላ ኢታ ኦꬃናኔ ኢንቴና ꬋይሳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","ሂስቲን ዴሬዚ ኢያሶ፥ «ኣካይ ኑኒ ጎዳስ ጻላ ጎይናና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","ሄሳፌ ጉዬ ኢያሶይ ዴራስ፥ «ኢንቴ ጎዳስ ጎይናናስ ዶሪዳ ጊሻስ ኢንቴ ሁኤስ ኢንቴ ማርካ» ጊዴስ። ኢስቲካ ዛሪዲ፥ «ኤ ኑኒ ማርካ!» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","ኢያሶይ፥ «ሂስቲኮ፥ ኢንቴ ጊዶን ዲዛ ኣላጋ ጾሳታ ዲጊቴ፤ ኢንቴ ዎዚና ጎዳ ኢስራኤሌ ጾሳኮ ዛሪቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","ዴሬዚካ ኢያሶስ፥ «ኑኒ ጎዳ ኑ ጾሳስ ጎይናና፤ ኢዛስካ ኣዛዜታና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","ሄ ጋላስ ኢያሶይ ዴሬዛ ጫቄꬂዴስ፤ ኢስቲ ካላና ዎጋኔ ማራ ሄን ሴኬሜን ኢስታስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","ኢያሶይ ሄ ቃላታ ጾሳ ዎጋ ማጻፋን ጻፊዴስ። ሄሳፌ ጉዬ ኢሲ ጊታ ሹች ኤኪዲ ጌሽ ጊዲዳ ጎዳ ዱንካኔዛ ማታን ዲዛ ዎላ ጋርሳን ኤሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","ኢያሶይ ኩሜꬃ ዴራስ፥ «ቤኢቴ፤ ጎዳይ ኑስ ሃሳይዳ ቃላ ኡባ ሃ ሹቻይ ሲዪዳ ጊሻስ ኢዚ ኑ ቦላ ማርካ ጊዳና። ኢንቴ ጾሳ ቦላን ማካሊኮ ሃ ሹቻይ ኢንቴ ቦላ ማርካ ጊዳና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","ሄሳፌ ጉዬ ኢያሶይ ዴራ ኡባ ባ ጺንጾን ጺንጾን ሲማና ማላ ሞይዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","ሄሳፌ ጉዬ ጎዳ ኣይሌ፥ ናዌ ና ኢያሶስ ላይꬃይ 110 ጊዲን ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","ኣሳይ ጋኣሼ ዙማፔ ፑዴሃ ባጋን፥ ሻራ ሜንꬆን ዲዛ ኤፍሬሜ ዴሬን ዲዛ ኢዛ ጺንጾን ቴሚናቴ-ሴራሃን ሞጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","ኢያሶይ ፓጻ ዲዛ ዎዴ ኡባን፥ ኢያሶፔ ሲሚን ዴኢዳ ኣሳቲኔ ጎዳይ ኢስራኤሌታስ ኦꬂዳ ኦሶ ኡባ ኤሪዛ ጪማቲ ዲዛ ዎዴ ኡባን ኢስራኤሌ ኣሳይ ጎዳስ ጎይኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","ኢስራኤሌ ኣሳይ ጊብጼ ቢታፌ ኤሂዳ ዮሴፌ ሜቄꬃ ሴኬሜን ሞጊዳ። ሄ ሶሆዛ ያቆቤይ ሴኬሜ ኣዋ ኤሞሬፔ 100 ሳቂሌ ቢራን ሻሚዴስ፤ ሂስቲን ጉዬፔ ዮሴፌ ዜሬꬃታስ ጺንጾ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","ቃሴካ ኣሮኔ ና ኤልኤዜሬይ ሃይቂዴስ፤ ኢዚካ ሻራ ሜንꬆን ዲዛ ኤፍሬሜ ዴሬን ኢዛ ናዛ ፊኒሃሴ ሳማን ጋኪዳ ጊቢኣ ካታማን ሞጌቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","ኢያሶይ ሃይቂዳፔ ጉዬ ኢስራኤሌ ኣሳይ፥ «ካናኔ ቢታ ኣሳ ኦላናስ ኑ ዛሬታፔ ኮይሮቲዲ ኬዛናይ ኦኔ?» ጊዲ ጎዳ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","ሂስቲን ጎዳይ፥ «ዩሁዳ ዛሬቲ ኮይሮቲ ኬዜቶ፤ ታኒ ቢታ ኢስታ ኩሼን ኣꬃ ኢማዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","ዩሁዳ ኣሳይ ባንታ ዳቦታ ጊዲዳ ሲሞና ዛሬታ፥ «ኑኒ ካናኔታራ ኦሌታና ማላ ኑና ሻኪን ጋኪዳሶ ኑናራ ኣꬊቴ። ሄሳፌ ጉዬ ኢንቴና ሻኮን ጋኪዳሶ ኢንቴናራ ኢሲፌ ባና» ጊዳ፤ ሂስቲን ሲሞና ዛሬቲኔ ዩሁዳ ዛሬቲ ኦላስ ኢሲፌ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","ሂስቲን ጎዳይ ካናኔታኔ ፓሪዜታ ኢስታ ኩሼን ኣꬂ ኢሚዴስ፤ ቤዜቄን 10,000 ኣስ ዎꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","ቤዜቄ ጌቴቲዛሶን ኣዶኒ-ቤዜቄ ዴሚዲ ኢዛራ ኦሌቲዳ፤ ሂስቲዲ ካናኔታኔ ፓሪዜታ ጾኒዳ። ");
INSERT INTO gmve_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","ኣዶኒ-ቤዜቄይ ባቃቲሺን ጎዲ ኦይኪዲ፥ ኢዛስ ኩሼ ማንꬃ ቢራꬌታኔ ቶሆ ማንꬃ ቢራꬌታ ቃንጺ ቃንጺ ዬጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","ሂስቲን ኣዶኒ-ቤዜቄይ፥ «ኩሼ ማንꬃ ቢራꬌታኔ ቶሆ ማንꬃ ቢራꬌታ ታኒ ቃንጻ ቃንጻ ዬጊዳ ላፑን ታሙ ካዎቲ ታ ማዳፌ ዎꬊዳ ሱፓ ማጺ ሺሺዲ ሜቴስ። ካሴ ኢስታ ቦላ ታ ኦꬂዳ ጌኔ ማላ ጾሲ ታ ቦላ ኦꬂዴስ» ጊዴስ። ኢዛ ዬሩሳላሜ ኤሂን ሄን ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","ዩሁዳ ኣሳይ ዬሩሳላሜ ኦሊ ኦይኪዴስ፤ ሂስቲዲ ኣሳ ጊꬃ ማሻን ቡሳኪ ዉርሲዲ ካታማ ታማን ጹጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","ሄሳፌ ጉዬ ዩሁዳ ኣሳይ ጌዜን፥ ኔጌቤኒኔ ሄ ዴሬ ጋꬋን ዲዛ ካናኔታ ኦላናስ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","ሂስቲዲ ካሴ ቂሪያቴ-ኣርባኤ ጌቴቲዛ ኬብሮኔ ካታማን ዲዛ ካናኔታ ኦሊዳ፤ ቃሴ ሻሻዬ፥ ኣሂማኔኔ ታሊማዬ ጌቴቲዛ ቆሞታ ጾኒዳ። ");
INSERT INTO gmve_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","ሄሳፌ ዴንዲዲ ዩሁዳ ኣሳይ ዳቢሬ ጌቴቲዛ ካታማን ዲዛ ኣሳ ኦላናስ ቢዴስ፤ ዳቢሬ ካታማይ ካሴ፥ «ቂሪያቴ-ሴፌሬ» ጌቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","ካሌቤይ፥ «ቂሪያቴ-ሴፌሬ ኦሊዲ ኦይኪዛዴስ ታኒ ታ ናዮ ኣኪሳ ኢማና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","ሂስቲን ካሌቤስ ካሎ ኢሻ ቄናዜ ና ኦቲንኤሌይ ሄ ካታማ ኦሊዲ ኦይኪዴስ፤ ካሌቤይካ ባ ናዮ ኣኪሳ ኢዛስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","ኣኪሳይ ኦቲንኤሌ ጌሊዛ ዎዴ፥ ኢዛ ባ ኣዋፔ ጋዴ ኦይቻ ኤካና ማላ ኦቲንኤሌይ ኢዞ ዞሪዴስ፤ ሂስቲን ኢዛ ባ ቶጊዳ ሜሄ ቦላፌ ዎꬋዱስ፤ ሂስቲን ካሌቤይ ኢዞ፥ «ታ ኔስ ኣይ ኦꬆ?» ጊዲ ኦይቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","ኢዛካ፥ «ካሴ ኔ ታስ ኢሚዳ ጋዴይ ሃꬂ ባይንዳሶ ጊዲዳ ጊሻስ ፑልቶ ሃꬃራ ዲዛ ጋዴ ታስ ኢማርኪ!» ጋዱስ። ሂስቲን ካሌቤይ ኢዚስ ፑዴ ባጋራኔ ዱጌ ባጋራ ፑልቶራ ዲዛ ጋዴታ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","ሙሴ ቦሎ ቄናዌዛ ዜሬꬃቲ ዩሁዳ ኣሳራ ዛምባይ ዳሪ ዲዛ ኢያርኮ ካታማፔ ዴንዲዳ፤ ሂስቲዲ ኣራዴ ጌቴቲዛ ካታማፔ ዱጌሃ ባጋራ፥ ኔጌቤን ዲዛ ዩሁዳ ባዞ ቢዳ፤ ሂስቲዲካ ሄን ዲዛ ኣሳ ጊዶን ኡቲዳ። ");
INSERT INTO gmve_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","ዩሁዳ ኣሳይ ሲሞና ኣሳራ ኢሲፌ ቢዲ፥ ጻፋቴ ጌቴቲዛ ካታማን ዲዛ ካናኔታ ኦሊ ጾኒዴስ፤ ካታማዮካ ሙሌራ ꬋይሲዴስ። ሂስቲዲ ሆርማ ጊዲ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","ዩሁዳ ኣሳይ ጉጂዲ ጋዛ፥ ኣስቄሎናኔ ኣቃሮኔ ካታማታ ኢስታ ዩሾን ዲዛ ዴሬታካ ኦሊ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","ጎዳይ ዩሁዳ ኣሳራ ዲዛ ጊሻስ፥ ዙማቲ ዳርዛሶ ጌዜ ቢታ ኢስቲ ኦይኪዳ፤ ጊዶ ኣቲን ጋርስ ዴምባቲ ኡቲዳ ቢታን ዲዛ ኣሳታስ ቢራታፔ ኦሴቲዳ ኦላ ፓራ-ጋሬቲ ዲዛ ጊሻስ፥ ዩሁዳ ኣሳይ ኢስታ ዴንꬂ ጎዳናስ ዳንዳይቤና። ");
INSERT INTO gmve_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","ሙሴይ ጊዳ ማላን ኬብሮኔ ካታማ ካሌቤስ ኢሚዳ፤ ሂስቲን ካሌቤይ ኤናቄ ዛሬ ሄꬑ ቆሞታ ዴራፔ ዴንꬂ ጎዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","ጊዶ ኣቲን ቢኒያሜ ዛሬቲ ዬሩሳላሜን ዲዛ ያቡሴ ኣሳታ ዴራፔ ዴንꬂ ጎዶንታ ኣጊዳ ጊሻስ ሃች ጋካናስ ያቡሴቲ ቢኒያሜ ዛሬታራ ዬሩሳላሜን ኢሲፌ ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","ዮሴፌ ቆሞቲ ቤቴሌ ኦላናስ ዎራጂዳ፤ ጎዳይካ ኢስታራ ዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","ኢስቲካ ቤቴሌ ካታማ ዩዪ ጾሞሲዛ ኣሳታ ኪቲዳ፤ ካሴ ሄ ካታማይ ሱንꬂ ሎዛ ጌቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","ኪቲን ኢስቲ ካታማፔ ኬዚ ቢዛ ኢሲ ኣዴዛ ዴሚዲ፥ «ካታማ ጊዶ ዋኒ ጌላናስ ዳንዳዬቲዛኮ ኑና ቤሳ፤ ኔ ቤሲኮ ኑኒ ኔስ ኪያና» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","ሂስቲን ኢዚ ኢስታ ቤሲዴስ፤ ሄሳፌ ጉዬ ካታማን ዲዛ ኣሳ ጊꬃ ማሻን ቡሳኪዳ፤ ጊዶ ኣቲን ሄ ኣዴዛኔ ኢዛሶ ኣሳ ኡባ ሼምፖ ኣሺዳ። ");
INSERT INTO gmve_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","ጉዬፔ ሄ ኣዴዚ ሂቴ ጌቴቲዛ ዴሬ ቢዲ፥ ሄን ካታማ ኤሲዴስ፤ ሄ ካታማይ ሱንꬃ ሎዛ ጊ ሱንꬂዴስ፤ ሄ ካታማያካ ሃች ጋካናስ ሄ ሱንꬃን ጼይጌታዉስ። ");
INSERT INTO gmve_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","ሚናሴ ዛሬቲ፥ ቤቲ-ሻኣኔ፥ ታኢናኬ፥ ዶሬ፥ ዪቢላኣሜኔ ማጊዶ ካታማታኒኔ ኢስታ ዩሾን ዲዛ ሞꬃታን ዲዛ ኣሳታ ኬሲ ጎዶንታ ኣጊዳ ጊሻስ ካናኔቲ ሄን ባንታ ዴኦ ሚንꬂ ኦይኪዳ። ");
INSERT INTO gmve_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","ኢስራኤሌ ኣሳይ ሚኒዳ ዎዴ ካናኔታ ባስ ዎልቃን ኦሲሲዳ፤ ጊዶ ኣቲን ኢስታ ሙሌራ ቢታፌ ኬሲ ጎዲቤቴና። ");
INSERT INTO gmve_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","ኤፍሬሜ ዛሬቲካ ጌዜሬ ጌቴቲዛ ካታማን ዲዛ ካናኔታ ኬሲዲ ጎዶንታ ኣጊዳ ጊሻስ ካናኔ ኣሳቲ ሄን ኢስታራ ኢሲፌ ዱስ ዶሚዳ። ");
INSERT INTO gmve_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","ዛቢሎኔ ዛሬቲ ቂቲሮኔ ካታማኒኔ ናሂላሌ ካታማን ዲዛ ኣሳታ ኬሲ ጎዶንታ ኣጊዳ ጊሻስ ካናኔቲ ሄን ኢስታራ ኢሲፌ ዴኢዳ፤ ጊዶ ኣቲን ዛቢሎኔ ዛሬቲ ኢስታ ባስ ዎልቃን ኦሲሲዳ። ");
INSERT INTO gmve_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","ኣሴሬ ዛሬቲካ ኣኮን፥ ሲዶናን፥ ኣሂላቤን፥ ኣኪዚቤን፥ ሄልቤን፥ ኣፌቄኒኔ ኤራሆቤን ዲዛ ኣሳታ ኬሲ ጎዲቤቴና። ");
INSERT INTO gmve_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","ካናኔቲ ኬዞንታ ኣጊዳ ጊሻስ ኣሴሬ ዛሬቲ ኢስታራ ሄን ኢሲፌ ዴኢዳ። ");
INSERT INTO gmve_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","ኒፍታሌሜ ዛሬቲካ ቤቲ-ሼሚሼ ካታማኒኔ ቤቲ-ኣናቴ ካታማን ዲዛ ኣሳታ ኬሲዲ ጎዲቤቴና፤ ጊዶ ኣቲን ካናኔታራ ሄን ኢሲፌ ዴኢሺን ቤቲ-ሼሚሼኔ ቤቲ-ኣናቴ ካታማ ኣሳታ ባስ ዎልቃን ኦሲሲዳ። ");
INSERT INTO gmve_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","ኣሞሬቲ ዳኔ ዛሬታ ፑዴ ዙማቲ ዲዛሶ ጌዜፌ ዱጌ ዴምባሶ ዎꬎንታ ማላ ዲጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","ኣሞሬቲ ሃሪ-ሄሬሴ ዴሬን፥ ኣያሎኒኔ ሻኣልቢሜ ጌቴቲዛ ካታማታን ዴኦ ሚንꬂዳ፤ ጊዶ ኣቲን ኤፍሬሜ ዛሬቲኔ ሚናሴ ዛሬቲ ሚኒ ሚኒ ቢዲ ባንታስ ዎልቃን ኦሲሲዳ። ");
INSERT INTO gmve_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","ኣሞሬታ ዴሬ ዛዋይ ኣኪራቢሜ ጌቴቲዛሶራ ኣꬊ ቢዲ ሴላራ ካንꬂዲ ሄራ ኣꬊ ቤስ። ");
INSERT INTO gmve_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","ጎዳ ኪታንቻይ ጌልጌላፔ ቦኪሜ ቢዲ ኢስራኤሌ ኣሳስ፥ «ታኒ ኢንቴና ጊብጼፔ ኬሳዳ ቤኒ ኢንቴ ኣዋስ ኢማና ጋዳ ታ ጫቂዳ ቢታ ኢንቴና ጌልꬃዲስ፤ ሂስታዳ ታ ኢንቴስ፥ ‹ታኒ ኢንቴናራ ጫቂዳ ጫቆ ቃላ ሙሌካ ላሚኬ። ");
INSERT INTO gmve_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","ኢንቴ ሃ ቢታን ዲዛ ኣሳታራ ጫቆ ጫቄቶፍቴ፤ ኢስቲ ያርሺዛሶታ ላሊቴ› ጋዲስ፤ ጊዶ ኣቲን ኢንቴ ታስ ኣዛዜቲቤኬታ፤ ኣይስ ሄሳꬆ ሃኒዴቲ? ");
INSERT INTO gmve_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","ሄሳ ጊሻስ ታኒ ኢንቴና፥ ‹ኢስታ ታኒ ኢንቴ ሲንꬃፌ ኬሳ ጎዲኬ፤ ኢስቲ ኢንቴስ ሞርኬ ጊዳና፤ ኢስታ ኤቃ ጾሳቲካ ኢንቴስ ናርጻ ማላ ጊዳና› ጋዲስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","ጎዳ ኪታንቻይ ሄሳ ኢስራኤሌ ኣሳ ኡባስ ዮቲዳ ዎዴ ኣሳይ ባ ቃላ ꬎቁ ሂስቲዲ ዬኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","ሄ ሶሆዛ ቦኪሜ ጊዲ ሱንꬂዴስ፤ ሂስቲዲ ሄ ሶዛን ጾሳስ ያርሾ ያርሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","ኢያሶይ ኢስራኤሌ ኣሳ ዬዲዳፔ ጉዬ ኣሳይ ኢሶይ ኢሶይ ሻኪን ባና ጋኪዛ ቢታ ኤካናስ ቢዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","ኢያሶይ ሼምፖራ ፓጻ ዲዛ ላይꬃ ኡባን ኣሳይ ጎዳስ ኦꬂዴስ፤ ኢዚ ሃይቂዳፔ ጉዬ ጎዳይ ኢስራኤሌ ኣሳስ ኦꬂዳ ጊታ ኦሶ ኡባ ቤኢዳ ጪማታ ዎዴ ኡባንካ ጎዳስ ጎይኒዛይሳ ኣጊቤና። ");
INSERT INTO gmve_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","ጎዳ ኣይሌ ናዌ ና ኢያሶስ ላይꬃይ 110 ጊዲን ሃይቂዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","ጋኣሼ ዴሬፔ ፑዴሃ ባጋን ኤፍሬሜ ዴሬን ቦላ ጌዜ ቢታን ቴሚናቴ-ሴራሃ ጌቴቲዛሶን ዲዛ ኢዛ ጋዴን ኢዛ ሞጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","ሄ ዬሌታ ኡባይ ሃይቂዳፔ ጉዬ ጎዳኔ ኢዚ ኢስራኤሌ ኣሳስ ኦꬂዳ ሎኦ ኦሶ ኡባ ኤሮንታ ኦራꬃ ዬሌታይ ዴንዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","ሄሳፌ ጉዬ ኢስራኤሌ ኣሳይ ጎዳ ሲንꬃን ኢታ ሚሽ ኦꬂዴስ፤ ባኣሌ ጌቴቲዛ ኤቃታስ ጎይኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","ጊብጼ ቢታፌ ኢስታ ኬሲዳ ጎዳ፥ ባንታ ኣዋታ ጾሳ ኣጋጊዳ፤ ባንታ ሄራን ዲዛ ኣሳቲ ጎይኒዛ ኤቃታኮ ሲሚዲ ኢስታስ ጎይኒዳ፤ ሄሳን ጎዳ ሃንቄꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","ጎዳካ ኣጊዲ ባኣሌሲኔ ኣስታሮቴስ ጎይኒዳ። ");
INSERT INTO gmve_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","ሄሳ ጊሻስ ጎዳ ሃንቆይ ኢስራኤሌ ኣሳ ቦላ ኤጺ ኬዚዴስ፤ ዎራጂዛይቲ ቦንቃና ማላ ኢስታ ሞርኬታ ኩሼን ኣꬂ ኢሚዴስ፤ ኢስታ ሄራን ዲዛ ሞርኬታስ ኢስታ ኣꬂ ኢሚዴስ፤ ሄሳፌ ጉዬ ኢስቲ ባንታ ሞርኬታራ ኤቄታናስ ዳንዳይቤቴና። ");
INSERT INTO gmve_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","ኢስቲ ኦላስ ኬዚዛ ዎዴ ኡባን ጎዳይ ካሴ ኢስታስ ጫቂ ዮቶይሳꬆ ኢስቲ ጾኔታና ማላ ኢዚ ኢስታ ቦላ ዴንዲዴስ፤ ሄሳፌ ዴንዶይሳን ኢስቲ ኬሂ ዋዬቲዳ። ");
INSERT INTO gmve_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","ሄሳፌ ጉዬ ጎዳይ ኢስራኤሌ ኣሳ ቦላ ዎራጂዛይታ ኩሼፔ ኢስታ ኣሺዛ ዳናታ ኢስታስ ዴንꬂዴስ፤ ");
INSERT INTO gmve_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","ጊዶ ኣቲን ኢስራኤሌ ኣሳይ ኢስታስ ፒርዲዛ ዳናታስ ኣዛዜቲቤና፤ ኢስቲ ጎዳስ ኣማኔቶንታ ኢጺዳ፤ ኤቃ ጾሳታኮ ሲሚዲ ኢስታስ ጎይኒዳ፤ ካሴ ባንታ ኣዋታ ኦጌፔ ካሬ ኬዚዳ፤ ኢስታ ኣዋቲ ጎዳስ ኣዛዜቲዳ ማላ ኢስቲ ኣዛዜቲቤቴና። ");
INSERT INTO gmve_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","ጎዳይ ኢስታስ ፒርዲዛ ዳናታ ዳናሲዳ ዎዴ ኡባን ኢዚ ሄ ፒርዲዛ ዳናታራ ኢሲፌ ዲዛ ጊሻስ ሄ ዳናቲ ሼምፖራ ፓጻ ዲዛ ላይꬅ ኡባን ኢስታ ሞርኬታ ኩሼፔ ኢስታ ኣሺዴስ። ዋዬይኔ ቱጋይ ኢስታ ቦላ ዳሪዳ ጋሶን ኢስቲ ዋሲዛይሳ ሲዪዲ ጎዳይ ኢስታስ ቃꬌቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","ጊዶ ኣቲን ኢስታ ካሌꬂዛ ዳናቲ ሃይቂዳ ዎዴ ኡባን ኣሳይ ጉዬ ሲሚዲ፥ ኤቃ ጾሳታ ካሎን፥ ኢስታስ ሃጋዞኒኔ ኢስታ ጎይኖን ካሴ ኢስታ ኣዋቲ ኦꬂዳ ኢታ ኦሶፔ ኣꬊዳ ኢታ ኦሶን ሲሚ ጌሊዳ፤ ባንታ ኢታ ኦሶኔ ጌላ ኦጌ ኣጎንታ ኢጺዳ። ");
INSERT INTO gmve_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","ሄሳ ጋሶን ጎዳ ሃንቆይ ኢስራኤሌ ካዎቴꬃ ቦላ ኤጺ ኬዚዴስ፤ ጎዳይ፥ «ሃ ኣሳይ ታኒ ካሴ ኢስታ ኣዋታራ ጌሊዳ ጫቆ ቃላ ዬꬊ ኣꬊዳ ጊሻሲኔ ታስ ኣዛዜቶንታ ኢጺዳ ጊሻስ፥ ");
INSERT INTO gmve_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","ሃቺፌ ዶሚን ኢያሶይ ሃይቂዳ ዎዴ ቢታ ቦላን ኣቲዳ ካዎቴꬃታፔ ኢሳዴካ ታኒ ኢስታ ሲንꬃፌ ኬሳ ጎዲኬ። ");
INSERT INTO gmve_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","ሃ ኢስራኤሌ ኣሳይ ካሴ ባንታ ኣዋታ ማላ ታ ኦጌ ካሊዛኮኔ ካሎንታኮ ታኒ ኢስታ ፓጫናስ ሃይሳ ሃ ዴሬታ ታስ ኦላ ማሳራ ኦꬃዳ ኢስታን ጎኤታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","ሄሳ ጊሻስ ጎዳይ ሄ ካዎቴꬃ ኣሳይ ኬዞንታ ጋምኣና ማላ ኦꬂዴስ። ኢዚ ኢስታ ኤሶን ዬዴꬂ ኬሲቤና፤ ኢያሶስካ ኢስታ ኣꬂ ኢሚቤና። ");
INSERT INTO gmve_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","ሄ ዎዴ ካናኔን ኣይ ኦላካ ኦሌቲ ኤሮንታ ኢስራኤሌ ካዎቴꬃ ፓጫና ማላ ጎዳይ ሃ ኣሳታ ኣሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","ኢዚ ሄሳ ኦꬂዳይ ሃይሳፌ ካሴ ኦላ ኦሌቲ ኤሮንታ ኢስራኤሌ ዬሌታ ኦላ ታማርሳናሳ። ");
INSERT INTO gmve_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","ሄ ቢታን ኣቲዳ ኣሳቲ፥ ፊሊስጼሜ ካታማታ ሃሪዛ ኢቻሻታ፥ ካናኔታ ኡባ፥ ሲዶና ካታማ ኣሳታኔ ባኣሊ-ሄርሞኔ ጌቴቲዛ ዴሬፔ ዶሚዲ ሃማቴ ጋካናስ ሊባኖሴ ዙማታ ቦላ ዲዛ ሂዌታ። ");
INSERT INTO gmve_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","ጎዳይ ሙሴ ባጋራ ካሴ ኢስራኤሌ ኣዋታስ ኢሚዳ ኣዛዞ ኢስቲ ኣዛዜቲዛኮኔ ኣዛዜቶንታኮ ሻኪ ኤራናስ ኢስታስ ፓጬ ጊዳና ማላ ሄ ኣቲዳ ኣሳታ ሄን ኣሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","ሄሳ ጊሻስ ኢስራኤሌ ኣሳይ ካናኔታራ፥ ሂዌታራ፥ ኣሞሬታራ፥ ፓሪዜታራ፥ ሂቴታራኔ ያቡሴታራ ኢሲፌ ዴኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","ኢስታ ማጫ ናይታ ባስ ማቾ ኤኪዳ፤ ባንታ ማጫ ናይታካ ኢስታ ኣቱማ ናይታስ ኢሚዳ፤ ኢስታ ኤቃ ጾሳታስካ ጎይኒዳ። ");
INSERT INTO gmve_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","ኢስራኤሌ ኣሳይ ጎዳ ሲንꬃን ኢታ ሚሽ ኦꬂዴስ፤ ኢስቲ ጎዳ ባንታ ጾሳ ኣጊዲ ባኣሌኔ ኣሼሮ ጌቴቲዛ ኤቃ ጾሳታስ ጎይኒዳ። ");
INSERT INTO gmve_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","ሄሳ ጊሻስ ጎዳ ሃንቆይ ኢስራኤሌ ኣሳ ቦላ ኤጺ ኬዚዴስ፤ ጎዳይ ማሶጴጾምያ ቢታ ካዎ ኩሻን-ኣሪሻታዬ ኩሼን ኢስታ ኣꬂ ኢሚዴስ፤ ኢስቲካ ኢዛስ ኦስፑን ላይꬅ ሃሬቲዳ። ");
INSERT INTO gmve_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","ጊዶ ኣቲን ኢስራኤሌ ኣሳይ ጎዳስ ዋሲዳ ዎዴ ጎዳይ ኢስታ ኣሻናስ ኣሺዛዴ ኪቲዴስ፤ ኢዚካ ካሌቤስ ካሎ ኢሻ ቄናዜ ና ኦቲንኤሌ ጌቴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","ጎዳ ኣያናይ ኢዛ ቦላ ዎꬊን ኢዚ ኢስራኤሌ ዴሬ ኣይሲዛ ዳና ጊዲዴስ፤ ኢዚ ኦላስ ኬዚዳ ዎዴ ጎዳይ ማሶጴጾምያ ቢታ ካዎ ኩሻን-ኣሪሻታዬ ኢዛ ኩሼን ኣꬂ ኢሚን ኢዛ ጾኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","ሄሳ ጊሻስ ቄናዜ ና ኦቲንኤሌይ ሃይቃና ጋካናስ ቢታይ ኦይዱ ታሙ ላይꬅ ኩሜꬅ ዎፓ ዴሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","ኢስራኤሌ ኣሳይ ዛሬꬂዲካ ጎዳ ሲንꬃን ኢታ ሚሽ ኦꬂዴስ፤ ሄሳ ጊሻስ ጎዳይ ሞኣቤ ካዎ ኤጊሎኔይ ኢስራኤሌ ቦላ ዎልቃማና ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","ኤጊሎኔይ ኣሞኔታኔ ኣማሌቄታ ባናራ ዴንꬂ ኤኪ ቢዲ ኢስራኤሌ ኣሳ ኦሊ ጾኒዴስ፤ ዛምባ ካታማ ጌቴቲዛ ኢያርኮ ካታማካ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","ኢስራኤሌ ኣሳይካ ሞኣቤ ካዎ ኤጊሎኔስ ታማኔ ኦስፑን ላይꬅ ሃሬቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","ኢስራኤሌ ኣሳይ ጎዳኮ ዛሪ ዋሲዳ ዎዴ፥ ኢስታ ኣሺዛ ኣስ ኪቲዴስ፤ ኢዚካ ቢኒያሜ ዛሬፔ ጌራ ና ኤሁዴ ጌቴቴስ፤ ኢዚ ሃዲርሳ ኩሼን ኦꬂዛ ኣሳ፤ ኢስራኤሌ ኣሳይ ኤሁዴ ሞኣቤ ካዎ ኤጊሎኔኮ ጊራራ ኪቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","ኤሁዴይ ናምኡ ባጋራ ቃራቲዳ ኢሲ ዋꬋ ጊዲዛ ጊꬃ ማሻ ባስ ጊግሲዴስ፤ ኡሻቻ ሚሌ ባጋራ ማይኦ ጊዶን ጊጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","ሄሳፌ ጉዬ ሞኣቤ ካዎ ኤጊሎኔስ ጊራ ኤኪ ኤፊዲ ኢሚዴስ፤ ኤጊሎኔይ ኬሂ ኦርዴ ኣሳ። ");
INSERT INTO gmve_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","ኤሁዴይ ጊራዛ ካዎዛስ ኢሚዳፔ ጉዬ ጊራ ቶኪዲ ቢዳ ኣሳታ ሞይዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","ጊዶ ኣቲን ኤሁዴይ ጌልጌላ ማታን ዲዛ ማሴቲ ኤቂዳ ሹቻታ ማታፔ ኤጊሎኔኮ ጉዬ ሲሚ ቢዲ፥ «ካዎንቶ! ታኒ ኢንቴስ ዮታና ጹራ ሚሺ ዴስ» ጊዴስ። ሂስቲን ካዎይ፥ «ጮኡ ጋ!» ጊዴስ፤ ኢዛ ናጊዛይቲ ኡባይ ካሬ ኬዚዳ። ");
INSERT INTO gmve_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","ሄ ዎዴ ካዎይ ፖቄን ዲዛ ኢሲ ጫርኪዛ ኪፊሌን ባርካ ኡቲ ዲሺን ኤሁዴይ ኢዛኮ ሺቂዲ፥ «ጾሲ ኔስ ዬዲዳ ኪታይ ዴስ» ጊዴስ፤ ካዎዚካ ባ ኡቲዳሶሆፔ ዴንዲ ኤቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","ኤሁዴይ ሃዲርሳ ኩሼ ዬዲዲ ኡሻቻ ባጋ ሚሌፌ ጊꬃ ማሻ ሾዲዲ ካዎዛስ ኡሎን ዬዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","ሂስቲን ጊꬃ ማሻስ ቱቴይ ኣቶንታ ኡሎ ጊዶ ጌሊዲ ዞኮራ ካንꬂ ኬዚዴስ፤ ሞꬌዚካ ማሻ ማይኢዴስ፤ ኤሁዴይ ማሻ ሾዶንታ ሄን ኣጋጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","ሄሳፌ ጉዬ ኤሁዴይ ካሬ ኬዚዲ ኬꬃ ካሬ ኢዛ ቦላ ጎርዲ ቁልፒዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","ኤሁዴይ ቢዳፔ ጉዬ ካዋ ኣይሌቲ ዪዲ ፔንጌይ ጎርዴቲዳይሳ ቤኢዳ፤ ጊዶ ኣቲን ካዎይ ጊዶ ኪፊሌን ሼሻስ ኡቶንታ ኣጌና ጊዲ ቆፒዳ። ");
INSERT INTO gmve_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","ሳሌታና ጋካናስ ካሬን ኤቂ ናጊዳ፤ ጊዶ ኣቲን ካዎይ ፔንጌ ዶዮንታ ኢጺን ቁልፔ ኤኪዲ ፔንጌዛ ዶይዳ፤ ኢስታ ጎዳ ኣሃይ ዉይጌ ቦላ ፖርጩ ጊ ዲዛይሳ ቤኢዳ። ");
INSERT INTO gmve_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","ኣሽካራቲ ሄን ፔንጌ ቦላ ናጎን ዲሺን ኤሁዴይ ኬሲ ኤኪዲ ማሴቲ ኤቂዳ ሹቻሶራ ኣꬊዲ ሴይሬ ጌቴቲዛሶ ባቃቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","ኢዚ ሄ ጋኪዳ ዎዴ ኤፍሬሜ ዴሬን ቦላ ጌዜዛን ኢስራኤሌ ኣሳይ ኦላስ ሺቃና ማላ ዛዬ ፑኒዴስ፤ ኣሳይካ ኢዛ ካሊዲ ሄፔ ዱጌ ዎꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","ኢዚ ኢስታስ፥ «ታና ካሊቴ፤ ኣይስ ጊኮ ጎዳይ ኢንቴ ሞርኬታ፥ ሞኣቤታ ኢንቴ ኩሼን ኣꬂ ኢሚዴስ» ጊዴስ። ሂዝጊን ኢዛ ካሊ ዎꬊዲ ዮርዳኖሴ ሻፋፔ ጌዴ ሞኣቤ ፒንꬂዛ ፑርዴዛ ኦይኪዲ ኢሳዴይካ ሄራ ካንꬆንታ ማላ ዲጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","ሄ ዎዴ ሞኣቤ ኣሳፔ ታሙ ሺ ጊዲዛ ዶሬቲዳ ሚኖ ኦላንቻታ ዎꬊዳ፤ ኢሲ ኣሲካ ኬሲ ኤኪ ኣቲቤና። ");
INSERT INTO gmve_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","ሄ ጋላስ ኢስራኤሌ ኣሳይ ሞኣቤ ኣሳ ኦሊ ጾኒዴስ፤ ሄሳ ጋሶን ቢታይ ኦስፑን ታሙ ላይꬅ ጋካናስ ዎፓ ዴሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","ኤሁዴፔ ጉዬ ኣናቴ ና ሻምጋሬይ ዴንዲዴስ፤ ፊሊስጼሜ ዴሬፔ ኡሱፑን ጼቱ ኣስ ጪካ ጉፌን ዎꬊዲ ኢስራኤሌ ኣሳ ኣሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","ኤሁዴይ ሃይቂዳፔ ጉዬ ኢስራኤሌ ኣሳይ ጎዳ ሲንꬃን ዛሬꬂዲካ ኢታ ሚሽ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","ሄሳ ጊሻስ ጎዳይ ሃጾሬ ጌቴቲዛ ካታማን ካዎቲዳ ካናኔ ካዎ ያቢኔስ ኢስታ ኣꬂ ኢሚዴስ፤ ኢዛ ኦላንቻታ ካሌꬂዛ ሲሳሪ ሃሮሼ-ሃጎዬ ጌቴቲዛ ካታማን ዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","ያቢኔይ ቢራታፔ ኦሴቲዳ ኡዱፉን ጼቱ ፓራ-ጋሬቲ ኢዛስ ዲዛ ጊሻሲኔ ኢዚ ኢስራኤሌ ኣሳ ናምኡ ታሙ ላይꬅ ኩሜꬅ ኬሂ ኡንኤꬂዳ ጊሻስ ኢስቲ ማዶ ዴማናስ ጎዳኮ ዋሲዳ። ");
INSERT INTO gmve_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","ሄ ዎዴ ላፒዶታ ማቻ ናቤ ዲቦራይ ቲንቢቴ ዮቲዛራ ኢስራኤሌ ዴራ ፒርዲዛ ዳና። ");
INSERT INTO gmve_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","ኢዛካ ኤፍሬሜ ዴሬን ቦላ ጌዜን፥ ኤራማ ካታማፔኔ ቤቴሌ ካታማፔ ጊዶን ዲዛ ዲቦራ ዛምባ ጋርሳን ኡታዳ ፒርዳዉስ፤ ኢስራኤሌ ኣሳይ ባ ዮኦ ፒርዲሳናስ ኢዚኮ ዬስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","ኢሲ ጋላስ ዲቦራ ኣቢኖኣሜ ና ባራቄ ኒፍታሌሜ ቢታን ዲዛ ቃዴሴ ካታማፔ ኪታዳ ጼይጊሳዱስ፤ «ጎዳ ኢስራኤሌ ጾሳይ ኔና፥ ‹ኒፍታሌሜ ዛሬፔኔ ዛቢሎኔ ዛሬፔ ታሙ ሺ ኣስ ኤካዳ ታቦሬ ዙማ ቦላ ኬዛ። ");
INSERT INTO gmve_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","ያቢኔ ኦላንቻታ ካሌꬂዛ ሲሳራ ፓራ-ጋሬታኔ ኦላንቻታ ኤኪዲ ቂሶኔ ሻፋን ኔናራ ኦላ ጋይታናስ ያና ማላ ታኒ ኢዛ ዴንꬄꬃና፤ ታኒ ኢዛ ኔስ ኣꬃ ኢማና› ጊ ኣዛዜስ» ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","ባራቄይካ ኢዚስ፥ «ኔኒ ታናራ ቢኮ ታኒ ባና፤ ኔኒ ታናራ ቦንታ ኣጊኮ ታኒካ ቢኬ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","ዲቦራይካ፥ «ኤሮ፥ ቡሳ ታ ኔናራ ባና፤ ጊዶ ኣቲን ጎዳይ ሲሳራ ማጫሳ ኩሼን ኣꬂ ኢማና ጊሻስ ታ ቡሳይ ኔስ ቦንቾ ጊዴና» ጋዱስ፤ ሄሳፌ ጉዬ ዲቦራይ ዴንዳዳ ባራቄራ ኦላስ ቃዴሴ ባዱስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","ባራቄይ ኒፍታሌሜኔ ዛቢሎኔ ዛሬታ ቃዴሴ ጼይጊን ታሙ ሺ ኣሳይ ኢዛ ካሊ ኬዚዴስ፤ ዲቦራይካ ኢዛራ ባዱስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","ሄ ዎዴ ቄናዌ ዴሬ ኣስ ሄቤሬ ጌቴቲዛይሲ ሙሴ ቦሎ ሆባቤ ናይታ ቄናዌ ዴሬ ኣሳፔ ሻኬቲዴስ፤ ሂስቲዲ ቃዴሴኮ ሺቂዲ ዛናኒሜን ጊታ ዎላ ጋርሳን ባ ዱንካኔ ቶኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","ኣቢኖኣሜ ና ባራቄይ ታቦሬ ዙማ ቦላ ቢዳይሳ ሲሳሪ ሲዪዲ፥ ");
INSERT INTO gmve_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","ሲሳሪካ ቢራታፔ ኦሴቲዳ ኡዱፉን ጼቱ ፓራ-ጋሬታኔ ባናራ ዲዛ ኦላንቻታ ኡባ ጼይጊሲዲ ሃሮሼ-ሃጎዬፔ ቂሶኔ ሻፋ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","ዲቦራይ ባራቄ «ዴንዳ! ሄኮ ሃች ጎዳይ ሲሳራ ኔ ኩሼን ኣꬂ ኢሚዛ ጋላሳ። ቤያ! ጎዳይ ኔፔ ሲንꬃቲ ቤስ» ጋዱስ፤ ባራቄይ ታሙ ሺ ኣሳ ካሌꬂዲ ታቦሬ ዙማ ቦላፌ ዎꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","ጎዳይ ሲሳራ ኢዛ ፓራ-ጋሬታ ኡባኔ ኢዛ ኦላንቻታ ኡባ ቃራ ጊꬃ ማሻን ባራቄ ሲንꬃፌ ባቃቲሲዴስ፤ ሄሳ ጊሻስ ሲሳሪ ባ ፓራ-ጋሬፔ ዎꬊዲ ቶሆራ ባቃቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","ባራቄይካ ሲሳራ ፓራ-ጋሬታኔ ኦላንቻታ ሃሮሼ-ሃጎዬ ጋካናስ ዬዴꬂዴስ፤ ሲሳራ ኦላንቻታፔ ኢሳዴይካ ኣቶንታ ኡባይካ ጊꬃ ማሻን ዉሪዳ። ");
INSERT INTO gmve_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","ሄ ዎዴ ሃጾሬ ካዎ ያቢኔሲኔ ቄናዌ ዴሬ ኣስ ሄቤሬ ዜሬꬃታ ጊዶን ሎኦ ጋይቶቴꬂ ዲዛ ጊሻስ ሲሳሪ ቶሆን ባቃቲዲ ቄናዌ ዴሬ ኣስ ሄቤሬ ማቺዮ ያኤሊ ዱንካኔ ጊዶ ዎጺ ጌሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","ያኤላ ሲሳራ ሞካናስ ኬዛዳ፥ «ታ ጎዳዉ፥ ጌላ፤ ሃ ጌላ፤ ያዮፋ» ጋዱስ፤ ኢዚ ዱንካኔ ጊዶ ኢዚኮ ጌሊን ኢዛ ባ ቡሉኮን ካማ ቆታዱስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","ሲሳሪ፥ «ታና ሳሜስ፤ ኡዪዛ ጉꬃ ሃꬅ ኢማርኪ!» ጊዴስ፤ ማꬅ ኦቶፔ ቲጋ ኡሻዱስ፤ ሂስታዳ ሲሳራ ኢዛ ዛራ ካማ ቆታዱስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","ሄሳፌ ጉዬ ኢዚ ኢዞ፥ «ዱንካኔዛ ፔንጌን ኤቃ፤ ኣይ ኣሲካ ዪዲ፥ ‹ሃይሳን ኣሲ ዲዜ?› ጊዲ ኔና ኦይቺኮ፥ ‹ባዋ› ጋ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","ሲሳሪ ኬሂ ዳቡርዳ ጊሻስ ꬊስኮ ሴሪዴስ፤ ሂስቲን ሄቤሬ ማቺያ ያኤላ ቆይጼኔ ዱንካኔ ꬊሽኬ ኤካዳ ሎዳራ ኢዛኮ ሺቃዱስ፤ ꬊሽኬዛካ ሃይꬃ ጮርጮሮን ኤሳዳ ዱጌ ቢታራ ሲካ ꬊሺኪን ሲሳሪ ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","ባራቄይ ሲሳራ ኮዪሼ ዪን ያኤሌ ኢዛ ሞካናስ ካሬ ኬዛዳ፥ «ሃ ያ፤ ኔኒ ኮይዛ ኣዴዛ ታኒ ኔና ቤሳና» ጋዱስ፤ ኢዚራ ዱንካኔ ጊዶ ጌሊዲ ሲሳራ ሃይꬃ ጮርጮሮን ꬊሽኬይ ꬊሼኬቲን ኢዛ ኣሃይ ቢታ ቦላ ፖርጩ ጊ ዲዛይሳ ቤኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","ሄ ጋላስ ጾሲ ኢስራኤሌ ኣሳይ ካናኔ ካዎ ያቢኔ ጾናና ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","ኢስራኤሌ ኣሳይ ካናኔ ካዎ ያቢኔ ቦላ ሚኒ ሚኒ ቢዲ ዉርሴꬃን ኢዛ ꬋይሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","ሄ ጋላስ ዲቦራይኔ ኣቢኖኣሜ ና ባራቄይ ሃይሳፌ ካሊዛ ዬꬃ ዬጺዳ። ");
INSERT INTO gmve_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","«ካሌꬂዛይቲ ኢስራኤሌ ካሌꬂሺን፥ ዴሬይካ ባ ሼኔን ሃሬቲሺን ጎዳ ጋላቲቴ! ");
INSERT INTO gmve_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","«ኢንቴኖ ካዎቶ! ሃይሳ ሲዪቴ! ኢንቴኖ ዴሬ ሃሪዛይቶ! ኤዝጊቴ! ታኒ ጎዳስ ዬጻና፤ ኢስራኤሌ ጎዳስ ጋላታ ማዛሙሬ ዬጻና። ");
INSERT INTO gmve_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","«ኣቤት ጎዳዉ! ኔኒ ሴይሬ ዴሬፔ ዴንዲዳ ዎዴ፥ ኔኒ ኤዶሜ ቢታፌ ኬዚዳ ዎዴ፥ ቢታይ ቃጺዴስ። ሳሎፔ ኢራይ ቡኪዴስ፤ ኤ፥ ኢራይ ሻራታፔ ዱጌ ቡኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","ጎዳ ኢስራኤሌ ጾሳ ሲንꬃኒኔ ሲና ጎዳ ሲንꬃን ዙማቲ ቃጺዳ። ");
INSERT INTO gmve_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","«ኣናቴ ና ሻምጋሬ ዎዴኒኔ ያኤሌ ዎዴን ኦጌይ ሳሚዴስ፤ ዛልኣንቻቲካ ሄ ቢታራ ካንꬂ ቤቴና። ኦጌዛራ ቢዛይቲካ ኦጋ ኣጊዲ ሃራሶራ ቢዳ። ");
INSERT INTO gmve_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","ኢስራኤሌ ማንዳራቲ ኣሲ ዶንታ ባዞ ጊዲዳ። ታኒ ዲቦራይ ኢስራኤሌ ኣሳስ ኣዮ ጊዳዳ ዴንዳና ጋካናስ ጾኒዲ ኣቲዳይ ባዋ። ");
INSERT INTO gmve_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","ኢስራኤሌ ኣሳይ ኣላጋ ጾሳታ ዶሪዳ ዎዴ፥ ቢታን ኦላይ ዴንዲዴስ፤ ኦይዱ ታሙ ሺ ኢስራኤሌ ኦላንቻታ ጊዶን ኢሲ ጎንዳሌይ ዎይኮ ኢሲ ቶራይ ቤቲቤና። ");
INSERT INTO gmve_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","ታ ዎዚናይ ኢስራኤሌ ዳናታራ ዴስ፤ ኣሳ ጊዶን ዶሳን ባና ኣꬂ ኢሚዳይታራ ዴስ። ጎዳይ ጋላቴቶ! ");
INSERT INTO gmve_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","«ኢንቴኖ ኮሬቲዳ ቦꬃ ሃሬ ቶጊዛይቶ! ኢንቴኖ ሎኦ ኣራታን ኡቲ ኣሌቄቲዛይቶ! ኢንቴኖ ቶሆን ሄሜቲዛይቶ! ");
INSERT INTO gmve_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","ሃꬃ ፑልቶታ ሄራን ዬጼቲዛ ዬꬃ ሲዪቴ፤ ኢስታ ጎዳይ ጾኒዳይሳ ኣኬኪሴስ፤ ቃሴ ኢስራኤሌ ኣሳይ ጾኒዳይሳ ናሼስ። «ጎዳ ኣሳይካ ካታማ ጌሊዛ ፔንጌታኮ ዱጌ ዎꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","‹ዲቦራ! ቤጋ! ቤጋ! ቤጎታዳ ዬꬃ ዬጻ። ኔኖ፥ ኣቢኖኣሜ ና ባራቄ፥ ዴንዳ! ኔ ዲኢዳይታ ኤካዳ ሲንꬄ ጉጃ።› ");
INSERT INTO gmve_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","«ሄሳፌ ጉዬ ኣቲዳ ኣሳቲ ሃላቃታኮ ዱጌ ዎꬊዳ። ጎዳ ኣሳቲ ኦሌታናስ ጊጊዲ ባራቄኮ ዪዳ። ");
INSERT INTO gmve_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","ካሴ ኣማሌቄ ዛሬቲ ዲዛሶን ዲዛ ኤፍሬሜ ኣሳፔ ኢሲ ኢሲ ኣሳቲ ዪዳ። ቃሴ ሃራቲ ቢኒያሜ ዜሬꬃታፔ ኢስታ ካሊዳ። ማኪሬ ዛሬታፔ ዳናቲ፥ ዛቢሎኔ ዛሬታፔ ካዎቴꬃን ኡቲዛይቲ ዪዳ። ");
INSERT INTO gmve_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","ዪሳኮሬ ዜሬꬃፌ ዳናቲ ዲቦሪራ ዪዳ፤ ኤ፥ ዪሳኮሬይኔ ባራቄይካ ዪዳ፤ ኢስቲካ ባራቄ ካሊዲ ዱጌ ዙሌዛ ዎꬊዳ። ጊዶ ኣቲን ኦሮቤሌ ዛሬቲ ቆፋን ሻኬቲ ዎꬊዳ፤ ያናኮኔ ዮንታኮ ሲꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","ኔ ኣይስ ዶርሳ ዪሬ ጊዶን ኡታዲ? ዶርስ ሄሚዛይታ ዋይቄꬅ ሲያናስ ኡታዲ? ኦሮቤሌ ዛሬቲ ቆፋን ሻኬቲ ዎꬊዳ፤ ያናኮኔ ዮንታኮ ሲꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","ጋላኣዴ ዛሬቲ ዮርዳኖሴ ሻፋፔ ሄ ፒንꬃን ኣቲዳ፤ ዳኔ ዛሬቲ ኣይስ ማርካቤ ጊዶን ጋምኢዶ? ኣሴሬ ዛሬቲ ባ ዲዛሶን ኣቲዳ፤ ሜዲቴራኔ ኣባ ላንቄንካ ዴኢዳ። ");
INSERT INTO gmve_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","ዛቢሎኔ ዛሬቲ ባንታ ሼምፖ ሃይቆስ ኣꬂ ኢሚዳ። ኒፍታሌሜ ዛሬቲካ ኢስታꬆካ ኦላ ዴምባን ኦꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","«ካዎቲ ዪዲ ማጊዶ ፑልቶታ ማታን ዲዛ ታኢናኬን ኦላ ኦይኬቲዳ። ካናኔ ካዎቲካ ሄን ኦሌቲዳ፤ ዲኢ ኤካናስ ኣይኮ ሚሺካ ዴሚቤቴና። ");
INSERT INTO gmve_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","ሳሎ ጾሊንቴቲ ኢዛራ ኦሌቲዳ። ባንታ ሃኖታን ሲሳራራ ኦላ ቃቃጱ ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","ቤኒ ቂሶኔ ሻፋ ኪጻይ ኢስታ ዴንꬂ ኤፊዴስ፤ ኢስቲካ ሃሮን ሜጬቲ ꬋይዳ፤ ታ ሼምፖዬ ሚና፤ ዎልቃንካ ሲንꬅ ጉጃ። ");
INSERT INTO gmve_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","ሄሳፌ ጉዬ ቶጋ ኣሳቲ ቶጋን ኣዳራሲ ዪዳ። ቶጋ ፓራታ ጊሪሳይ ዳዳ ጊሪሳ ማላ። ");
INSERT INTO gmve_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","ጎዳ ኪታንቻይ፥ ‹ሜሮዜ ቃንጊቴ! ሄን ዲዛ ኣሳ ኢሲፌ ቃንጊቴ! ጋሶይካ ኢስቲ ጎዳ ኣሳ ኦላን ማዶንታ ኢጺዳ። ዎልቃማ ኢስታ ሞርኬታራ ኦሌታናስ ኬዚቤቴና› ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","«ቄናዌ ዴሬ ኣስ ሄቤሬ ማቺያ ያኤላ ማጫሳ ኡባፌ ኣንጄቲዳሮ ጊዱ። ዱንካኔ ጊዶን ዲዛ ማጫሳ ኡባፌ ኢዛ ኣንጄቲዳሮ ጊዱ። ");
INSERT INTO gmve_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","ሲሳሪ ኢዞ፥ ‹ታና ሃꬅ ኡሻ› ጊ ዎሲዴስ፤ ኢዛ ጊዲኮ ሜቃ ማꬅ ሺሻዱስ፤ ሎኦ ዋንጫን ኢዛስ ኢማዱስ። ");
INSERT INTO gmve_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","ኢሲ ኩሼን ዱንካና ꬊሽኬ፥ ኡሻቻ ኩሼን ኦሳንቻታ ቆይጼ ኦይካዱስ፤ ሲሳራ ሁኤን ꬊሺካዱስ፤ ሃይꬃ ጮርጮሮራ ሉካ ኬሳዱስ። ");
INSERT INTO gmve_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","ቦልቁ ጊ ኩንዲዴስ፤ ኢዚ ቶሆ ጋርሳንካ ጉፋኒዴስ፤ ሄ ኩንዲዳ ሶሆን ሃይቂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","«ሲሳራ ኣዬያ ማስኮቴራ ቤኣዱስ፤ ማስኮቴ ጾኤራካ ቲሺ ሂስታ ጼላሼ፥ ‹ታ ናዛ ፓራ-ጋሬይ ኣይስ ጋምኢዴ? ፓራ-ጋሬቲ ኤሶቲዲ ኣይስ ሲሚቤቴኔ?› ጋዳ ዋሳ ኦይቻዱስ። ");
INSERT INTO gmve_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","ኣꬎ ኤራቴꬂ ዲዛ ኢዚ ማጫሳቲ ኢዚ ኦይሻ ዛሪዳ፤ ጊዶ ኣቲን ኢዛ ባ ቆፋን ባስ፥ ");
INSERT INTO gmve_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","‹ኢስቲ ዲኢዲ ኤሂዳይሳ ጊሼቲ ኤኪሺን ኢሳዴ ኢሳዴ ኢሲ ኢሲ ጌላኦይ ዎይኮ ናምኡ ናምኡ ጌላኦቲ ጋኬቴስ። ሲሳራስ ኢስቲ ዱማ ዱማ ቃላሜን ኦሴቲዳ ኣሌቆ ማይኦ ኢማና፤ ቃሴ ታስካ ቆꬌን ጻጻናስ ጺሊፌን ኣሌቂዲ ሎኢዛ ማይኦታ ኤሃና› ጋዱስ። ");
INSERT INTO gmve_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","«ኣቤት ጎዳዉ! ኔ ሞርኬቲ ኡባይ ሄሳꬆ ሃይቄቶ! ጊዶ ኣቲን ኔ ሲቆቲ ማላዶ ሞኪዛ ኣርሼዳ ጶሌቶ።» ሄሳፌ ጉዬ ቢታይ ኦይዱ ታሙ ላይꬅ ዎፓ ዴሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","ኢስራኤሌ ኣሳይ ጎዳ ሲንꬃን ዛሬꬂዲ ኢታ ሚሽ ኦꬂዴስ፤ ሄሳ ጊሻስ ጎዳይ ኢስታ ሚዲያሜ ኣሳስ ኣꬂ ኢሚዴስ፤ ኢስቲካ ላፑን ላይꬅ ኩሜꬅ ሃሬቲዳ። ");
INSERT INTO gmve_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","ሚዲያሜ ኣሳይ ኢስራኤሌ ኣሳ ቦላ ሚኒዳ ጊሻስ ኢስራኤሌ ኣሳይ ኢስታፌ ቆቴቲ ኣታናሶ ጎንጎሎኔ ሚጻ ጊግሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","ኢስራኤሌ ኣሳይ ካꬅ ዜሪዛ ዎዴ ኡባን ሚዲያሜ ኣሳይ፥ ኣማሌቄ ኣሳይኔ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ኣሳይ ኢስታ ቦላ ዎራጂ ዎራጂ ሜቶ ጋꬄቴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","ኢስቲ ሄ ቢታን ዱንካኒዲ ጋዛ ካታማ ጋካናስ ቢታ ኡባ ቦላን ሞኪዳይሳ ꬋይሴቴስ፤ ዶርሳታ፥ ሚዛታኔ ሃሬ ዉዴታ ዲኢ ኤፊዛ ጊሻስ ኢስራኤሌ ኣሳስ ኣይኮካ ኣሺ ኤሬቴና። ");
INSERT INTO gmve_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","ባንታ ሜሄታኔ ባንታ ዱንካኔታ ኤኪዲ ቦሌይ ዪዛ ማላ ዳሪዲ ዬቴስ፤ ኢስታኔ ኢስታ ጋሜላታ ቆዳናስ ዳንዳዬቴና፤ ኢስታ ዩሳይካ ቢታ ꬋይሳናሳ። ");
INSERT INTO gmve_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","ሚዲያሜ ኣሳይ ኢስራኤሌ ኣሳ ቦላ ሜቶ ጋꬂዳ ጊሻስ ኢስራኤሌ ኣሳይ ማዶ ዴማናስ ጎዳኮ ዋሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","ሚዲያሜ ኣሳይ ጋꬂዳ ቆሆዛ ጋሶን ኢስራኤሌ ኣሳይ ጎዳኮ ዋሲን፥ ");
INSERT INTO gmve_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","ጎዳይ ኢስታኮ ኢሲ ናቤ ኪቲዴስ፤ ሄ ናቤዚ ኢስታስ ጎዳ ኢስራኤሌ ጾሳፌ ኤሂዳ ኪታይ፥ «ታ ኢንቴና ጊብጼ ኣይሌቴꬃፌ ኬሳዲስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","ታኒ ኢንቴና ጊብጼ ኣሳ ኩሼፔኔ ዋዪሲዛ ኣሳ ኡባ ኩሼፔ ኣሻዲስ፤ ኢንቴ ሲንꬃፌካ ኢስታ ጎዳ ኬሳዳ ኢስታ ቢታ ኢንቴስ ኢማዲስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","ታኒ ኢንቴና፥ ‹ታኒ ጎዳ ኢንቴ ጾሳ፤ ኢንቴ ኢስታ ቢታ ላቲዳ ኣሞሬታ ጾሳታስ ጎይኖፍቴ› ጋዳ ዮታዲስ፤ ጊዶ ኣቲን ኢንቴ ታ ቃላ ሲዮንታ ኢጺዴታ» ጌስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","ሄሳፌ ጉዬ ጎዳ ኪታንቻይ ኦፊራ ጌቴቲዛሶን ዲዛ ኣቢኤዜሬ ዜሬꬃፌ ኢዮኣሳ ዎላ ጋርሳን ዪ ኡቲዴስ፤ ሄ ዎዴ ኢዮኣሳ ና ጌዶኒ ሚዲያሜ ኣሳፔ ቆቴታናስ ዎይኔ ጉምኢዛሶሆን ጊስቴ ቡኬስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","ሄን ጎዳ ኪታንቻይ ኢዛስ ቆንጪዲ፥ «ሃይሶ ኔኖ፥ ሚኖ ኦላንቻዞ! ጎዳይ ኔናራ ዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","ጌዶኒካ ኢዛ፥ «ታ ጎዶ! ጎዳይ ኑናራ ዲዛ ጊዲኮ ሃ ሜቶ ኡባይ ኑና ኣይስ ጋኪዴ? ኑ ኣዋቲ፥ ‹ጎዳይ ኑና ጊብጼ ቢታፌ ኬሲዴስ› ጊዲ ኑስ ዮቲዳ ማላሊሲዛ ኢዛ ኦሶቲ ኡባይ ኣዋን ዲዞ? ሃኢ ጊዲኮ ጎዳይ ኑና ሙሌካ ኣጊዴስ፤ ሚዲያሜ ኣሳ ኩሼንካ ኣꬂ ኢሚዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","ሄሳፌ ጉዬ ጎዳይ ኢዛኮ ሲሚዲ፥ «ኔስ ዲዛ ጊታ ዎልቃን ባዳ ኢስራኤሌ ኣሳ ሚዲያሜ ኣሳ ኩሼፔ ኣሻዳ ኬሳ ኤካ፤ ኔና ኪቲዳይ ታና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","ጌዶኒ፥ «ታ ጎዳዉ፥ ታ ዛሬይ ሚናሴ ዛሬ ኡባፌ ኣꬊዳ ላፋ፤ ታኒካ ኑሶ ኣሳ ኡባፌ ጉꬃ፤ ሂስቲን ታኒ ኢስራኤሌ ኣሳ ዎስታዳ ኣሻናስ ዳንዳያዚና?» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","ጎዳይካ፥ «ቱማፔ ታኒ ኔናራ ጊዳና፤ ኢሲ ኣስ ሾጪዛ ማላ ኔኒ ሚዲያሜ ኣሳ ሾጫዳ ጾናና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","ጌዶኒካ «ኔኒ ታናን ኡፋዬቲዳ ጊዲኮ ታናራ ሃሳይዛይ ኔና ጊዲዳይሳ ኤሪሲዛ ማላታ ታና ቤሳ። ");
INSERT INTO gmve_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","ታኒ ጉዬ ሲማ ባዳ ኔስ ያርሾ ሚሽ ኤካ ያና ጋካናስ ሃኒፌ ሃራሶ ቦፓ» ጊዴስ። ጎዳይካ፥ «ኔኒ ሲማና ጋካናስ ታኒ ሃይሳን ናጋና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","ጌዶኒ ባሶ ቢዲ ዴይሻ ላቃ ሹኪዲ ካꬂዴስ፤ ኢሲ ታሙ ኪሎ ጊራሜ ጊዲዛ ꬊሌ ኤኪዲ ኢርሾይ ኢዛን ጌሎንታ ኡኬꬅ ኡኪዴስ፤ ኣሾዛ ሌማቴን ዎꬂዲ ጫምባዛ ኬሬን ቲጊዴስ፤ ኡባካ ኤኪ ኤፊዲ ዎላ ጋርሳን ኡቲዳ ጎዳ ኪታንቻዛስ ሺሺዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","ጾሳ ኪታንቻይ ኢዛ፥ «ኣሾዛኔ ኢርሾይ ኢዛን ጌሎንታ ኡኬꬃዛ ኤካዳ ሃ ሹቻ ቦላ ዎꬃ፤ ጫምባዛካ ኢዛ ቦላ ቲጋ» ጊዴስ፤ ጌዶኒካ ኢዚ ኣዛዚዳ ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","ጎዳ ኪታንቻይ ባ ኩሼን ኦይኪዳ ጉፌ ጼራን ኣሾዛኔ ኡኬꬃዛ ቦቺዴስ፤ ሂስቲን ታማይ ሹቻ ጊዶፌ ኬዚዲ ኣሾዛኔ ኡኬꬃዛ ሚዴስ፤ ሄሳፌ ጉዬ ጎዳ ኪታንቻይ ኢዛ ሲንꬃፌ ጌሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","ጌዶኒ ቤይዳይ ጎዳ ኪታንቻ ጊዲዳይሳ ኣኬኪዳ ዎዴ፥ «ኡባ ሃሪዛ ጎዳዉ! ታኒ ጎዳ ኪታንቻ ታ ኣይፌን ቤኢዳ ጊሻስ ታስ ኣዬ ኣና!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","ጊዶ ኣቲን ጎዳይ፥ «ሳሮይ ኔስ ጊዶ! ያዮፋ! ኔ ሃይቃካ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","ጌዶኒካ ጎዳስ ያርሾ ያርሺዛሶ ሄን ጊግሲዲ ሄ ሶሆዛ፥ «ጎዳይ ሳሮ ጾሳ» ጊዲ ሱንꬂዴስ፤ ሄ ያርሾ ያርሺዛሶይ ኣቢኤዜሬ ዜሬꬃታስ ጊዲዳ ኦፊራን ሃች ጋካናስ ኤቂ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","ሄ ጋላሳ ኦማርስ ጎዳይ ጌዶኔ፥ «ኔ ኣዋ ሚዛታ ጊዶፌ ሃራ ላፑን ላይꬃ ኮርማ ቦራ ኤካ፤ ኔ ኣዋይ ባኣሌ ጌቴቲዛ ኤቃስ ያርሾ ያርሺዛሶዛ ላላ፤ ኢዛ ላንቄን ዲዛ ኣሼሮ ጌቴቲዛ ማጫ ጾሳይ ሚስሌዛካ ቲፋ ሜንꬄሬꬃ ዬጋ። ");
INSERT INTO gmve_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","ሄ ቲፌቲ ዶሬቲዳ ሚስሌዛ ቦላ ጎዳ ኔ ጾሳስ፥ ያርሾ ያርሺዛሶ ሎኤꬃ ጊጊሳ፤ ሄሳፌ ጉዬ ኔኒ ሜንꬄሬꬂዳ ኣሼሮ ጌቴቲዛ ጾሳይ ሚስሌዛ ቄራ ኤꬃዳ ናምኣንꬆ ቦራዛ ሙሌራ ጹጊዛ ያርሾ ኦꬃዳ ያርሻ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","ጌዶኒካ ባ ኣይሌታፔ ታማታ ኤኪዲ ጎዳይ ኢዛስ ዮቲዳ ማላ ኦꬂዴስ፤ ጊዶ ኣቲን ኢዚ ባ ኣዋ ሶ ኣሳሲኔ ካታማን ዲዛ ኣሳስ ያዪዳ ጊሻስ ሄሳ ጋላስ ኦꬃናይሳ ኣጊዲ ኦማርስ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","ማላዶ ዎንታን ካታማ ኣሳይ ዴንዲዳ ማላ ባኣሌ ጌቴቲዛ ኤቃስ ያርሾ ያርሺዛሶይ ላሌቲቺዳይሳኔ ኢዛ ላንቄን ዲዛ ኣሼሪ ሚስሌይ ሜቄሬቲ ዎꬊዳይሳ ቤኢዴስ፤ ቃሴ ኢስቲ ያርሾ ያርሺዛሶይ ጊጊዳይሳኔ ኢዛ ቦላ ናምኣንꬆ ቦራይ ያርሼቲዳይሳ ቤይዳ። ");
INSERT INTO gmve_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","ባንታ ጊዶን፥ «ሃይሶ ሃይሳ ኦꬂዳይ ኦኔ?» ጊዲ ኢሶይ ኢሳ ኦይቺዳ፤ ኢስቲ ዩዪ ዩዪ ኦይቺዲ ሄሳ ኦꬂዳይ ኢዮኣሳ ና ጌዶኔ ጊዲዳይሳ ኤሪዳ። ");
INSERT INTO gmve_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","ሄሳፌ ጉዬ ካታማ ኣሳይ ኢዮኣሳ፥ «ባኣሌ ጌቴቲዛ ኤቃስ ያርሾ ያርሺዛሶዛ ላሊዳ ጊሻሲኔ ኢዛ ላንቄን ዲዛ ኣሼሪ ሚስሌዛ ሜንꬄሬꬂ ዬጊዳ ጊሻስ ኑኒ ኢዛ ዎꬋና ማላ ኔ ናዛ ሃ ኬሳ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","ኢዮኣሲ ባ ቦላን ዴንዲዳ ኣሳ ኡባ፥ «ኢንቴ ባኣሌስ ሞቴቴቲ? ዎይኮ ኢንቴ ኢዛ ኣሻኔ? ኢዛ ጊሻስ ሞቴቲዛ ኣሲ ዲኮ ሳኣይ ዎንታናሺን ኢዛዴይ ሃይቆ! ባኣሌይ ጾሳ ጊዲኮ ኢዛስ ያርሾ ያርሺዛሶዛ ላሊዳዴራ ኢዚ ባርካ ሞቴቶ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","ሄሳ ጊሻስ ሄ ጋላስ ኣሳይ ጌዶኔ ሱንꬃ ዬሩባኣሌ ጊ ሱንꬂዳ፤ ቢርሼꬃይ ባኣሌይ ባ ጊሻስ ሞቴቶ ጉሳ፤ ጋሶይካ ላሌቶይሲ ኢዛስ ያርሾ ያርሺዛሶ ጊዲዳ ጊሻሳ። ");
INSERT INTO gmve_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","ሄሳፌ ጉዬ ሚዲያሜ ቢታ ኣሳይ፥ ኣማሌቄ ቢታ ኣሳይኔ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ኣሳይ ኡባይ ኢሲፌ ሺቂዲ ዮርዳኖሴ ሻፋ ፒኒዳ፤ ኢዝራኤሌ ጌቴቲዛ ሾባን ዱንካኒዳ። ");
INSERT INTO gmve_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","ሄሳፌ ጉዬ ጎዳ ኣያናይ ጌዶኔ ቦላ ዎꬊዴስ፤ ኣቢኤዜሬ ዛሬቲ ኡባይ ባና ካላና ማላ ኢስታ ሺሻናስ ዛዬ ፑኒዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","ሚናሴ ዛሬ ኡባስ ኣስ ኪቲዲ ባና ካላና ማላ ኢስታካ ጼይሲዴስ፤ ሄሳꬆካ ኣሴሬ ዛሬታስ፥ ዛቢሎኔ ዛሬታሲኔ ኒፍታሌሜ ዛሬታስ ኣስ ኪቲዴስ፤ ኢስቲካ ኢዛራ ኦላሶ ባናስ ኬዚዳ። ");
INSERT INTO gmve_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","ሄሳፌ ጉዬ ጌዶኒ ጾሳ፥ «ታኒ ኢስራኤሌ ኣሳ ኣሻና ማላ ኔኒ ታና ዶሪዳይሳ ታስ ዮታዳሳ። ");
INSERT INTO gmve_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","ቤያ፥ ጊስቴ ቡኪዛ ባሌን ዶርሳ ኢስኬ ታኒ ዎꬃና፤ ጻዛይ ሄ ዶርሳ ኢስኬ ቦላ ጻላ ዲዲ ቢታ ቦላ ዶንታ ኣጊኮ ኔኒ ዮቲዳ ማላ፥ ኢስራኤሌ ኣሳ ታ ኩሼን ኔ ኣሻናይሳ ታ ኤራና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","ኢዚካ ጊዳ ማላ ሃኒዴስ፤ ዎንቴꬃ ጋላስ ማላዶ ዎንታራ ዴንዲዲ ዶርሳ ኢስኬ ጉምኢዳ ዎዴ ኢሲ ሳኔ ጊዲዛ ሃꬂ ኢዛፔ ኬዚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","ጌዶኒ ቃሴካ ጾሳ፥ «ዎዜ ኔና ዛይ! ታና ሃንቄቶፋ! ኢሲቶ ታ ኔና ዛራ ኦይቻይስ፤ ዶርሳ ኣጎዛ ቦላ ሃራ ማላታ ቤሳና ማላ፤ ሄሲካ ዶርሳ ኣጎዛይ ሜላ ጊዲን ቢታይ ሃጺዲ ጻዛታና ማላ ኦꬃርኪ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","ሄ ጋላሳ ኦማርስ ጾሲ ሄ ማላታዛ ኦꬂዴስ፤ ዎንቴꬃ ጋላስ ማላዶ ዶርሳ ኣጎዛይ ሜላ ጊዲን ቢታ ኡባይ ሃጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","ዎንቴꬃ ጋላስ ማላዶ ዎንታራ ዬሩባኣሌ ጌቴቲዛ ጌዶኒኔ ኢዛራ ዲዛ ኣሳይ ኡባይ ዎንታ ማላዶራ ዴንዲ ቢዲ ሃሮዳ ጌቴቲዛ ፑልቶ ሃꬃ ኣቻን ዱንካኒዳ። ሚዲያሜ ቢታ ኣሳቲካ ኢስታፌ ፑዴሃ ባጋራ ሞሬ ጌቴቲዛ ዙማ ማታን ዲዛ ዙሌን ዱንካኒዳ። ");
INSERT INTO gmve_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","ጎዳይ ጌዶኔ፥ «ሚዲያሜ ዴሬ ኣሳ ታኒ ኢንቴ ኩሼን ኣꬃ ኢሞንታ ማላ ኔናራ ዲዛ ኣሳይ ዳሪዴስ፤ ኢስራኤሌ ኣሳይ፥ ‹ኑ ዎልቃን ኣቲዶስ› ጊዲ ታ ቦላ ጬቄቶንታ ማላ ሚዲያሜ ዴሬ ኣሳ ታኒ ኢስታስ ኣꬃ ኢሚኬ። ");
INSERT INTO gmve_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","ሄሳ ጊሻስ ሃኢ ኣሳስ፥ ‹ዎዚናይ ሂርጊዛዴይኔ ባቢዛዴይ ዲኮ ጋላኣዴ ዙማፔ ጉዬ ሲሚዲ ባሶ ባሶ ቦ› ጋዳ ኣዋጃ» ጊዴስ። ሄሳፌ ዴንዶይሳን 22,000 ኣሳይ ጉዬ ሲሚን 10,000 ኣሲ ጻላ ኣቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","ሄሳፌ ጉዬ ጎዳይ ጌዶኔ፥ «ሃኢካ ኣሳይ ዳሪዴስ፤ ኔኒ ኢስታ ዱጌ ሃꬃ ሻፋ ዎꬃ፤ ሄን ታ ኢስታ ኔስ ፓጫዳ ሻካና፤ ታኒ፥ ‹ሃይሲ ኔናራ ቦ› ጊዛይሲ ኔናራ ቦ፤ ‹ሃይሲ ኔናራ ቦፖ› ጊዛይሲ ቦፖ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","ሄሳ ጊሻስ ጌዶኒ ኣሳ ሃꬃኮ ኤፊዴስ፤ ጎዳይ ጌዶኔ፥ «ሃ ኣሳ ጊዶፌ ጉልባቲዲ ሃꬅ ኡዪዛይታኔ ካና ማላ ኤቆን ሃꬅ ኢንጻርሳን ላማጪ ላማጪ ሂስቲዲ ኡዪዛይታ ሻካ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","ባንታ ኩሼን ሃꬃ ኤቆን ኩጳቲ ኡዪዛይታ ቆዳይ ሄꬑ ጼታ፤ ጊዶ ኣቲን ኣቲዳይቲ ኡባይ ሃꬃ ኡያናስ ጉልባቲዳ። ");
INSERT INTO gmve_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","ጎዳይ ጌዶኔ፥ «ባንታ ኩሼን ሃꬃ ኩጳቲ ኤቆን ዲሼ ኡዪዳ ሄꬑ ጼቱ ኣሳታን ታኒ ኢንቴና ኣሻና፤ ሚዲያሜ ኣሳታ ኢንቴስ ኣꬃ ኢማና፤ ሃንኮ ኣቲዳ ኣሳይ ጊዲኮ ጉዬ ባሶ ባሶ ሲሞ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","ሄሳ ጊሻስ ጌዶኒ ጉዬ ሲሚዛ ኢስራኤሌ ኣሳ ሺንቄኔ ዛዬ ኤኪዲ 300 ኣሳታስ ኢሚዲ ሃንኮ ኣቲዳ ኣሳ ኡባ ኢስታ ሶ ኢስታ ሶ ዬዲዴስ፤ ሃ ኡባይ ሃኒዛ ዎዴ ሚዲያሜ ኦላንቻቲ ኢስታፌ ዱጌ ባጋራ ዙሌን ዱንካኒዲ ኡቲዳ። ");
INSERT INTO gmve_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","ሄ ጋላሳ ኦማርስ ጎዳይ ጌዶኔ፥ «ታኒ ኔስ ኣꬃ ኢሚዳ ጊሻስ ዴንዳ ባዳ ኢስቲ ዱንካኒዳሶን ኢስታ ኦላ። ");
INSERT INTO gmve_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","ኔኒ ባዳ ኦላናስ ያዪኮ ኔ ኣይሌ ፑራ ኔናራ ኤካዳ ኢስቲ ዱንካኒ ዲዛሶ ዱጌ ባ፤ ");
INSERT INTO gmve_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","ኢስቲካ ጊዛይሳ ሲያ፤ ሄሳፌ ጉዬ ኔኒ ኢስታ ሂርጋይ ባይንዳ ኦላና» ጊዴስ። ሄሳ ጊሻስ ጌዶኒ ባ ኣይሌ ፑራ ካሌꬂ ኤኪዲ ሞርኬቲ ዱንካኒ ዲዛሶ ሄራ ዎꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","ሄ ዎዴ ቦሌ ማላ ጮራቲዳ ሚዲያሜ ኣሳይ ኣማሌቄ ኣሳይኔ ኣርሼ ኬሳ ባጋራ ዲዛ ኣሳይ ኡባይ ሾባ ጊዶን ዱንካኒ ኡቲዴስ። ኢስታ ጋሜላቲ ኣባ ዶናን ዲዛ ኣጬ ማላ ቆዳፔ ዳሮ። ");
INSERT INTO gmve_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","ጌዶኒ ሄ ጋኪዳ ማላ ኢሲ ቢታኔይ ባ ኣጉሜቲዳ ኣጉሞ ባ ላጌዛስ ዮቲሺን ሲዪዴስ፤ ሄ ኣጉሞዚካ፥ «ኢሲ ባንጋ ኡኬꬃያ ኤꬖታዳ ሚዲያሜ ኦላንቻቲ ዱንካኒ ዲዛሶ ያዳ ዱንካና ዴቻዱስ፤ ዱንካናይካ ላሌቲ ሚጬቲዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","ኢዛ ላጌዚካ ዛሪዲ፥ «ሄሲ ኢስራኤሌ ዴሬ ኣስ ኢዮኣሳ ና ጌዶኔ ጊꬃ ማሻፌ ኣቲን ሃራ ጊዴና፤ ጾሲ ሚዲያሜ ዴሬ ኣሳኔ ኑ ኦላ ኣሳ ኡባ ጌዶኔስ ኣꬂ ኢሚዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","ጌዶኒካ ሄ ቢታኔዛ ኣጉሞዛኔ ኣጉሞዛ ቢርሼꬃ ሲዪዳ ዎዴ ጉልባቲዲ ጾሳስ ጎይኒዴስ፤ ሄሳፌ ጉዬ ኢስራኤሌ ኣሳይ ዱንካኒዳሶ ጉዬ ሲሚዲ፥ «ዴንዲቴ! ጎዳይ ሚዲያሜ ኦላንቻታ ኢንቴ ኩሼን ኣꬂ ኢሚዴስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","ሄꬑ ጼቱ ኣሳ ሄꬑ ቡቴን ሻኪዴስ፤ ኢስታስካ ሁኤን ሁኤን ኢሲ ኢሲ ዛዬኔ ጊዶን ኤጺዛ ጾምፔ ኦይኪዳ ኢሲ ኢሲ ጻሮ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","ጌዶኒካ ኢስታስ፥ «ታኮ ሃ ጼሊዲ ታኒ ኦꬂዛይሳ ኦꬂቴ፤ ታኒ ሚዲያሜ ኦላንቻቲ ዱንካኒዳሶ ማታ ጋካዳ ኦꬂዛ ማላ ኢንቴካ ኦꬂቴ። ");
INSERT INTO gmve_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","ታኒኔ ታናራ ዲዛይቲ ኡባቲ ዛዬ ፑኒዛ ዎዴ ኢንቴካ ኢስቲ ዱንካኒዳሶ ዩዪ ኣꬊዲ ኢንቴ ዛዬ ፑኒዲ፥ ‹ጎዳ ኦላኔ ጌዶኔ ኦላ!› ጊዲ ዋሲቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","ጊዲ ጊዶꬅ ጊዳና ጊሺን ናጊዛ ዛቤቲ ላሜቲዳፔ ጉዬ ጌዶኒኔ ኢዛራ ዲዛ ጼቱ ኣሳቲ ቢዲ ሚዲያሜቲ ዱንካኒዳሶ ማታ ጋኪዲ ባ ኦይኪዳ ዛዬ ዛዬ ፑኒዳ፤ ባ ኦይኪዳ ጻሮታካ ኡባ ሜንꬄሬꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","ሃራ ባጋራ ዲዛ ናምኡ ቡቴቲካ ባ ዛዬ ዛዬ ፑኒዲ ባ ኦይኪዳ ጻሮታካ ሜንꬄሬꬂዳ፤ ሃዲርሳ ኩሼን ኤጺዛ ጾምፔ፥ ኡሻቻ ኩሼን ዛዬ ኦይኪዲ ፑኒሼ፥ «ጎዳ ኦላኔ ጌዶኔ ኦላ!» ጊዲ ዋሲዳ። ");
INSERT INTO gmve_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","ኣሳይ ኡባይ ሚዲያሜ ኣሳቲ ዱንካኒዳሶ ዩሾን ባ ናጊዛሶን ናጊዛሶን ኤቂዳ፤ ሚዲያሜ ኦላንቻቲካ ኡባይ ዋሶ ጹሌꬂሼ ባቃቲዳ። ");
INSERT INTO gmve_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","ሄꬑ ጼቱ ጌዶኔ ኣሳይ ባ ዛዬ ዛዬ ፑኒዳ ዎዴ ሞርኬታ ኦላንቻቲ ባንታ ጊꬃ ማሻን ኢሶይ ኢሳ ዎꬋና ማላ ጎዳይ ኦꬂዴስ፤ ሄሳ ጊሻስ ኣቲዳ ኦላንቻቲ ዜሬራ ባጋራ ጌዴ ቤቲ-ሲጼ ጌቴቲዛ ካታማራ ኣꬊ ቢዲ ጻባታ ማታን ዲዛ ኣቤሊ-ማሆሌ ጋካናስ ባቃቲዳ። ");
INSERT INTO gmve_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","ሄሳፌ ጉዬ ጌዶኒ ኒፍታሌሜ ዛሬፔ፥ ኣሴሬ ዛሬፔኔ ሚናሴ ዛሬ ኡባፌ ኣሳ ጼይጊ ኬሲን ኢስቲካ ሚዲያሜ ዴሬ ኣሳ ዬዴꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","ኤፍሬሜ ጌዜን ዲዛ ኣሳ ኡባኮ ጌዶኒ ኣስ ኪቲዲ፥ «ሚዲያሜ ኣሳ ኦላናስ ዱጌ ዎꬊቴ፤ ቤቲ-ባሬ ጋካናስ ዲዛ ዮርዳኖሴ ሻፋ ኢስታፌ ሲንꬃቲ ኦይኪዲ ኦጌ ዱꬂቴ» ጊዴስ። ኤፍሬሜ ኣሳይካ ኡባይ ጼይጌቲ ሺቂዲ ኢዚ ጊዳይሳꬆ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","ኦሬቤኔ ዛኤቤ ጌቴቲዛ ሚዲያሜ ኦላ ኣሳ ካሌꬂዛ ናምኡ ኦላ ቃራታ ኦይኪዳ፤ ኦሬቤ፥ «ኦሬቤ ዛላ» ጌቴቲዛሶን ዎꬊዳ፤ ዛኤቤ ቃሴ፥ «ዛኤቤ ዎይኔ ጉምኢዛሶሆ» ጌቴቲዛሶን ዎꬊዳ። ሄሳፌ ጉዬካ ኣቲዳ ሚዲያሜቲ ዬዴꬂዲ ኦሬቤ ሁኤኔ ዛኤቤ ሁኤ ቆꬌፔ ቃንጺ ቃንጺ ኤኪዲ ጌዶኔኮ ኤሂዳ። ሄ ዎዴ ጌዶኒ ዮርዳኖሴ ሻፋፔ ሄ ፒንꬃን ኣርሼይ ሞኪዛሶ ባጋራ ዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","ሄሳፌ ጉዬ ኤፍሬሜ ኣሳይ ጌዶኔ፥ «ሚዲያሜታ ኦላናስ ባሼ ኑና ኣይስ ጼይጋቤኪ? ኑና ኣይስ ሃይሳ ማላ ኦꬃዲ?» ጊዲ ኬሂ ዋላሲዳ። ");
INSERT INTO gmve_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","ጊዶ ኣቲን ጌዶኒ ዛሪዲ፥ «ታኒ ኦꬂዳይሳፌ ኢንቴ ኦꬂዳይ ኣꬌኔ? ታ ቆሞቲ ዉሪ ኦꬂዳ ኦሶፔ ኤፍሬሜ ኣሳፔ ጉꬃቲ ኦꬂዳ ኦሶይ ኣꬌኔ? ኤፍሬሜይ ፑሼቺ ሺሺዳይሲ ኣቢኤዜሬይ ማጺ ሺሾይሳፌ ኣꬌኔ? ");
INSERT INTO gmve_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","ሚዲያሜ ኦላ ኣሳ ካሌꬂዛ ኦላ ቃራታ ኦሬቤኔ ዛኤቤ ጾሲ ኢንቴ ኩሼን ኣꬂ ኢሚዴስ። ሂስቲን ታ ሄሳራ ጊናቲዛ ኦሶ ኣይ ኦꬃዲና?» ጊዴስ፤ ሄሳፌ ጉዬ ኢስታ ሃንቆይ ኢርጺዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","ጌዶኒኔ ኢዛራ ዲዛ 300 ኣሳይ ዮርዳኖሴ ሻፋ ዪዲ ፒኒዳ፤ ኢስቲ ኣይ ዳቡርኮካ ባንታ ሞርኬታ ዬዴꬆ ኣጊቤቴና። ");
INSERT INTO gmve_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","ጌዶኒ ሱኮቴ ካታማ ጋኪዲ ሄ ካታማ ኣሳታስ፥ «ታኒ ሚዲያሜ ካዎታ ዜባሃኔ ጻልሙና ዬዴꬆ ቦላ ዳይስ፤ ታናራካ ዲዛ ኣሳይ ዳቡርዳ ጊሻስ ኢንቴና ሾቢስ፥ ሚዛ ካꬂ ዲኮ ኢሜርኬቲ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","ሱኮቴ ካታማ ኣይሲዛይቲ፥ «ኑኒ ኔና ካሊዛ ኦላ ኣሳስ ካꬅ ኢማና ማላ ዜባሃይኔ ጻልሙናይ ኔ ኩሼን ጌሊዶ?» ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","ጌዶኒ ኢስታስ ዛሪዲ፥ «ሎኦ፥ ኣይኮይ ባዋ! ጎዳይ ዜባሃኔ ጻልሙና ታ ኩሼን ኣꬂ ኢሚዛ ዎዴ ታኒ ባዞ ኣጉንꬃኒኔ ጋሞን ኢንቴና ዋꬋና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","ሄሳፌ ጉዬ ፓኑኤሌ ጌቴቲዛሶ ቢዴስ፤ ሱኮቴ ኣሳ ኦይቾይሳꬆ ኦይቺዴስ፤ ፓኑኤሌ ኣሳይካ ሱኮቴ ካታማ ኣሳይ ጎይሳꬆካ ጊ ዛሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","ኢዚካ ፓኑኤሌ ኣሳስ፥ «ታኒ ጾናዳ ሳሮ ሲሚዛ ዎዴ ኢንቴ ኢንቴ ካታማ ኢዛ ቦላ ኡቲዲ ናጊዛ ጊምቤዛ ታ ላላና» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","ዜባሃይኔ ጻልሙናይ ኣርሼ ኬሳ ባጋፌ ዪዳ ኦላንቻታፔ ኣቲዳ 15,000 ኦላንቻታራ ቃሪቆሬ ጌቴቲዛ ካታማን ዴቴስ፤ ሃንኮ 120,000 ጊዲዛ ኦላ ማሳራ ኦይኪዳ ኦላንቻቲ ኦላን ሃይቂ ዉሪዳ። ");
INSERT INTO gmve_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","ጌዶኒ ኖባሄፔኔ ዮጊባሃፔ ኣርሼይ ሞኪዛ ባጋራ ዲዛ ባዞ ጋጻ ኦጌራ ቢዲ ሄሳን ዲዛ ኦላንቻታ ቦላ ኢስቲ ኣኬኮንታ ዲሺን ኦላ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","ኢስቲካ ኡባይ ዳጋሚዳ፤ ሚዲያሜ ካዎቲ ዜባሃይኔ ጻልሙናይ ናምኣይካ ባቃቲዳ፤ ጊዶ ኣቲን ጌዶኒ ኢስታ ዬዴꬂ ጋኪዲ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","ኢዮኣሳ ና ጌዶኒ ኦላፔ ሄሬሴ ፒኒዛሶራ ሲሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","ሱኮቴፔ ኢሲ ናቴꬃ ኣስ ኦይኪዲ ፒልጊ ኦይቺዴስ፤ ኢዚካ ሱኮቴ ኣይሲዛይታኔ ጪማታ ላፑን ታማኔ ላፑናታ ሱንꬃ ጻፊዲ ኢዛስ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","ሄሳፌ ጉዬ ጌዶኒ ሱኮቴ ኣሳኮ ዪዲ፥ « ‹ዜባሃኔ ጻልሙና ኔኒ ዲኣቤካሺን ዳቡርዳ ኔ ኦላንቻታስ ኣይስ ካꬅ ኢማኔ?› ጊዲ ኢንቴ ታና ቂልጪዴታ፤ ሃኢ ጊዲኮ ዜባሃኔ ጻልሙና ሃይታ ቤኢቴ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","ሄሳፌ ጉዬ ባዞ ኣጉንꬃኒኔ ኪንዲቾን ዋꬊዲ ሱኮቴ ካታማ ኣይሲዛይታ ቃጻይዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","ቃሴ ፓኑኤሌን ኢዛ ቦላ ኡቲዲ ካታማ ናጊዛ ጊምቤዛ ላሊዲ ካታማን ዲዛ ኣቱማሳ ዎꬊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","ሂስቲዲ ጌዶኒ ዜባሃኔ ጻልሙና፥ «ኢንቴ ታቦሬን ዎꬊዳ ኣሳቲ ኣይ ማላ ኣሴ?» ጊዲ ኦይቺዴስ፤ ኢስቲ፥ «ኔ ማላ፤ ኢስቲ ኡባይካ ካዎ ናይታ ሚሳቴቴስ» ጊ ዛሪዳ። ");
INSERT INTO gmve_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","ጌዶኒ፥ «ኢስቲ ታ ኢሻንታ፤ ኢስቲ ታ ኣዬይ ናይታ፤ ጾሲ ቤዪን ኢንቴ ኢስታ ዎꬎንታኮ ታኒካ ኢንቴና ዎꬊኬ ሺን» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","ሄሳፌ ባስ ባይራ ናዛ ዬቴሬ፥ «ዴንዳ ኤቃዳ ሃይታ ዎꬋ!» ጊዴስ፤ ዮቶሬይካ ቡሮ ዬላጋ ና ጊዲዳ ጊሻስ ያዪዲ ባ ጊꬃ ማሻ ሾዲቤና። ");
INSERT INTO gmve_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","ሄሳፌ ጉዬ ዜባሃይኔ ጻልሙናይ ጌዶኔ፥ «ሃይቆይ ኣቶንታሼ ዴንዳዳ ኑና ኔኒ ዎꬋ» ጊዳ፤ ሄሳ ጊሻስ ጌዶኒ ዴንዲዲ ኢስታ ዎꬊዴስ፤ ኢስታ ጋሜላታ ቆꬌን ዲዛ ኣሌቆ ሚሻታ ኡባ ኤኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","ሄሳፌ ጉዬ ኢስራኤሌ ኣሳይ ጌዶኔ፥ «ኔኒ ኑና ሚዲያሜ ኣሳፔ ኣሺዳ ጊሻስ ኔኒ ኔፔ ጉዬ ኔ ናይኔ ኔ ና ናይ ኑና ሃሪቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","ጌዶኒካ፥ «ታኒ ኢንቴና ሃሪኬ፤ ታ ናይካ ኢንቴና ሃሬና፤ ጎዳይ ኢንቴና ሃሮ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","ኢስማኤሌ ኣሳ ማላ ሚዲያሜ ቢታ ኣሳቲካ ሃይꬃን ዎርቃ ኣꬄቴስ፤ ሄሳ ጊሻስ ኢዚ ኢስታስ፥ «ኣኔ ታኒ ኢንቴና ኢሲ ሚሽ ኦይቻይስ፤ ኢንቴ ኡባይ ዲኢዲ ኤሂዳ ሃይꬃ ዎርቃ ታስ ኢሚቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","ኢስራኤሌ ኣሳይ ዛሪዲ፥ «ኤሮ፥ ኑ ኢማና» ጊዲ ኣፋላ ሚጪዳ፤ ኣሳይ ኡባይ ባ ዲኢዳ ሃይꬃ ዎርቃ ሄ ሚጬቲዳ ኣፋላን ዬጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","ሄሲካ ሃራ ኣሌቆታ፥ ቆꬌን ኣꬂዛ ጎዝዳታ፥ ሚዲያሜታ ካዎቲ ማይኢዛ ኦቻ ቴራ ሚሳቲዛ ማይኦታኔ ኢስታ ጋሜላታ ቆꬌፔ ኤኬቲዳ ኣሌቆታ ጉጆንታ ጌዶኒ ኤኪዳ ሃይꬃ ዎርቃይ 20 ኪሎ ጊራሜ ጊዲዛዛ። ");
INSERT INTO gmve_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","ጌዶኒ ዎርቃፌ ኤፉዴ ሚስሌ ጊግሲዲ ባ ዲዛ ኦፊራ ካታማን ዎꬂዴስ፤ ጉዬፔ ኢስራኤሌ ኣሳይ ኡባይ ጎዳ ኣጊዲ ሄ ኤፉዴ ሚስሌዛስ ጎይኒዴስ፤ ጌዶኔሲኔ ኢዛ ሶ ኣሳስ ሄሲ ኢስታ ኦይኪዛ ናርጻ ጊዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","ሄሳ ማላ ሃኒዲ ሚዲያሜ ኣሳይ ኢስራኤሌ ኣሳስ ሃሬቲዴስ፤ ኢስቲ ኢስራኤሌ ኣሳ ቦላ ናምኣንꬆ ዴንዲቤቴና። ጌዶኒ ሼምፖራ ፓጻ ዲዛ ኦይዱ ታሙ ላይꬅ ኩሜꬅ ቢታይ ዎፓ ዴሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","ኢዮኣሳ ና ዬሩባኣሌ ጌቴቲዛ ጌዶኒ ባ ሶ ጉዬ ቢዲ ባ ኬꬃን ዴኢዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","ጌዶኒ ጮራ ማጫሳ ኤኪዳ ጊሻስ ኢዛስ 70 ኣቱማ ናይቲ ዴቴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","ቃሴ ሴኬሜ ካታማን ዲዛ ላጌꬆ ማጫሳያ ኢዛስ ኣቱማ ና ዬሊን ሱንꬃ ኣቢሜሌኬ ጊ ሱንꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","ኢዮኣሳ ና ጌዶኒ ኬሂ ጪሚዲ ሃይቂዴስ፤ ባ ኣዋ ኢዮኣሳ ዱፎን ሞጌቲዴስ፤ ሄ ዱፎዚ ኣቢኤዜሬ ቆሞቲ ዲዛ ኦፊራ ካታማን ዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","ጌዶኒ ሃይቂዳፔ ጉዬ ኢስራኤሌ ኣሳይ ጎዳፔ ጉዬ ሲሚዲ ባኣሌ ጌቴቲዛ ኤቃ ጾሳታስ ጎይኒዴስ፤ ባኣሊ-ቢሪታ ባንታስ ጾስ ሂስቲ ጎይኒዳ። ");
INSERT INTO gmve_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","ሂስቲዲ ኢስራኤሌ ኣሳይ ኢስታ ዩሾን ዲዛ ሞርኬታ ኡባፌ ኢስታ ኣሺዳ ጎዳ ባንታ ጾሳ ዶጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","ቃሴ ጌዶኒ ኢስራኤሌ ኣሳስ ኦꬂዳ ሎኦ ኦሶ ኡባ ኣኬኮንታ ኣጊዲ ኢዛ ኬꬃ ኣሳስ ሎኦ ኩሼ ዛሪቤቴና። ");
INSERT INTO gmve_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","ጌዶኔ ና ኣቢሜሌኬይ ሴኬሜ ካታማን ዲዛ ባ ኣዬይ ዳቦታኮ ቢዲ ኢስታሲኔ ባ ኣዬይ ቆሞታ ኡባስ፥ ");
INSERT INTO gmve_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","«ኣኔ ሴኬሜ ካታማን ዲዛ ኣሳ ኡባ፥ ‹ጌዶኔ ናይቲ ላፑን ታማቲ ኡባይ ኢንቴና ሃሪኮ ሎኦዬ? ዎይኮ ኢሲ ኣሲ ሃሪኮ ሎኦ?› ጊዲ ኦይቺቴ። ታኒ ኢንቴስ ኣሾ ዳቦ ጊዲዳይሳ ዶጎፒቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","ኢዛ ኣዬይ ዳቦቲ ሃ ቃላ ኡባ ኢዛ ዶና ጊዲዲ ሴኬሜ ካታማ ኣሳስ ዮቲዳ፤ ኣቢሜሌኬይካ ኢስታስ ዳቦ ጊዲዳ ጊሻስ ሴኬሜ ኣሳይ ኢዛ ካላናስ ቆፋ ቃቺዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","ኢስቲ ባኣሊ-ቢሪታ ኤቃ ኬꬃፌ 70 ሳቂሌ ቢራ ኤኪዲ ኢዛስ ኢሚዳ። ኣቢሜሌኬይ ሄ ቢራን ሹፉሮታኔ ቦንቂዛይታ ኦይኪዲ ባና ካላና ማላ ኦꬂዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","ኦፊራ ጌቴቲዛሶን ዲዛ ባ ኣዋ ሶ ቢዲ ባ ኢሻታ፥ ዬሩባኣሌ ናይታ ላፑን ታማታ ኢሲ ሹቻ ቦላን ሹኪዴስ፤ ጊዶ ኣቲን ጌዶኔስ ዉርሴꬃ ካሎ ናዚ ኢዮኣታሜይ ቆቴቲዲ ሃይቆፔ ኣቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","ሄሳፌ ጉዬ ሴኬሜ ኣሳይኔ ቤቲ-ሚሎ ኣሳይ ኢሲፌ ሺቂዲ ሴኬሜን ጎይኔቲዛ ዛላ ማታን ዲዛ ጊታ ሚꬃ ጋርስ ቢዲ ሄን ኣቢሜሌኬ ካዎꬂዳ። ");
INSERT INTO gmve_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","ኢዮኣታሜይ ሄሳ ሲዪ ቢዲ ጋሪዛኔ ዙማ ሁኤ ኬዚዲ ባ ቃላ ꬎቁ ሂስቲዲ፥ «ኢንቴኖ ሴኬሜ ኣሳቶ! ኢንቴ ታ ጊዛይሳ ሲዪዛ ጊዲኮ ጾሲ ኢንቴ ጊዛይሳ ሲያና። ");
INSERT INTO gmve_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","ኢሲ ጋላስ ሚꬃቲ ኡባይ ሺቂዲ ባንታ ቦላ ካዎ ካዎꬃናስ ቢዳ፤ ሂስቲዲ ዎጋራ ሚꬅ፥ ‹ሃ ያ፥ ኑ ቦላ ካዎታ› ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","«ጊዶ ኣቲን ዎጋራ ሚꬃይ፥ ‹ታኒ ኤቃ ጾሳታኔ ኣሳታ ቦንቺሲዛ ታ ዛይቴ ኢሚዛይሳ ኣጋዳ ሚꬃታ ቦላ ካዎቶ?› ጊ ዛሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","«ሄሳፌ ጉዬ ሚꬃቲ ባላሴ ጌቴቲዛ ሚꬃ፥ ‹ሃ ያ፥ ኑ ቦላ ካዎታ› ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","ጊዶ ኣቲን ባላሴ ሚꬃይ፥ ‹ታኒ ማልኢዛ ሎኦ ኣይፌ ኣይፊዛይሳ ኣጋዳ ሚꬃታ ቦላ ካዎታናስ ቦ?› ጊ ዛሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","«ሄሳ ጊሻስ ሚꬃቲ ዎይኔ ቱራ፥ ‹ሃ ያ፥ ኑ ቦላ ካዎታ› ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","ጊዶ ኣቲን ዎይኔ ሚꬃይ፥ ‹ታኒ ጾሲኔ ኣስ ኡፋይሲዛ ዎይኔ ኡሻ ኢሚዛይሳ ኣጋዳ ሚꬃታ ቦላ ካዎታና ቦ?› ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","«ሄሳ ጊሻስ ዉርሴꬃን ሚꬃቲ ኡባይ ኣጉንꬅ፥ ‹ሃ ያ፥ ኑ ቦላ ካዎታ› ጊዳ። ");
INSERT INTO gmve_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","ኣጉንꬃይካ፥ ‹ኢንቴ ቱማፔ ታና ኢንቴ ቦላ ካዎꬃናስ ኮይኮ ሃ ዪዲ ታ ኩዋን ሼምፒቴ፤ ሄሳ ኢንቴ ኢጺኮ ኣጉንꬃፌ ታማይ ኬዚዲ ሊባኖሴ ዚጋታ ሞ!› ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","«ኣቢሜሌኬ ኢንቴ ካዎꬂዛይ ቱማቴꬃኒኔ ሱሬቴꬃኔ? ጌዶኒ ኢንቴስ ኦꬂዳይሳ ኣኬኪዲ ኢዛሶ ኣሳስ ኢዚ ኢንቴስ ኦꬂዳይሳስ ሎኦ ኩሼ ዛሪዴቲ? ");
INSERT INTO gmve_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","ታ ኣዋይ ኢንቴስ ኦሌቲዳይሳ ኣኬኪቴ፤ ሚዲያሜ ኣሳፔ ኢንቴና ኣሻና ጊዲ ባ ሼምፖ ሃይቆስ ኣꬂ ኢሚዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","ጊዶ ኣቲን ኢንቴ ሃች ታ ኣዋ ሶ ኣሳ ቦላ ዴንዲዲ 70 ኢዛ ናይታ ኢሲ ሹቻ ቦላ ሹኪዴታ፤ ጌዶኒ ኣይሌይፌ ዬሊዳ ኣቢሜሌኬይ ኢንቴስ ዳቦ ጊዲዳ ጊሻስ ሴኬሜን ካዎሲዴታ። ");
INSERT INTO gmve_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","ሃኢ ሲሚ ጌዶኔሲኔ ኢዛ ኬꬃ ኣሳታስ ኢንቴ ኦꬂዳ ኦሶይ ቱማቴꬃኒኔ ሱሬቴꬃን ጊዲኮ ኣቢሜሌኬራ ኢሲፌ ኡፋዬቲቴ፤ ኢዚካ ኢንቴናራ ኡፋዬቶ። ");
INSERT INTO gmve_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","ሄሳꬆ ጊዶንታ ኣጊኮ ኣቢሜሌኬፌ ታማይ ኬዚዲ ሴኬሜ ኣሳኔ ቤቲ-ሚሎ ኣሳ ሞ፤ ሄሳꬆካ ሴኬሜ ኣሳፔኔ ቤቲ-ሚሎ ኣሳፔ ታማይ ኬዚዲ ኣቢሜሌኬ ሞ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","ኢዮኣታሜይካ ባ ኢሻ ኣቢሜሌኬስ ያዪዳ ጊሻስ ባቃቲዲ ቢኤሬ ጌቴቲዛሶ ቢዲ ሄን ኡቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","ኣቢሜሌኬይ ኢስራኤሌ ቢታን 3 ላይꬅ ካዎቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","ሄሳፌ ጉዬ ጾሲ ኣቢሜሌኬሲኔ ሴኬሜ ኣሳ ጊዶን ኢታ ኣያና ኪቲዴስ፤ ሴኬሜ ኣሳይካ ኣቢሜሌኬ ቦላ ማካሊ ዴንዲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","ጾሲ ሄሳ ኦꬂዳይ ኣቢሜሌኬይ ላፑን ታሙ ባ ኢሻታ ዎꬊዳ ጊሻሲኔ ኢዚ ኢስታ ሱꬃ ጉሳና ማላ ሴኬሜ ኣሳይ ኢዛ ሚንꬄꬂዳ ጊሻስ ሃሎ ኬሳናሳ። ");
INSERT INTO gmve_vpl VALUES ("JG9_25","008_9_25","JDG","9","25","25","ሴኬሜ ኣሳይ ኣማርዳ ኣሳ ዶሪዲ ዙማ ሁኤን ኣቢሜሌኬ ዎꬋናስ ዛማዲ ኡታና ማላ ኦꬂዴስ፤ ሄ ኡቲዳይቲ ኦጌራ ካንꬂዛ ኣሳ ኡባ ቦንቂዳ፤ ኣቢሜሌኬይካ ሄሳ ኡባ ሲዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_26","008_9_26","JDG","9","26","26","ሄሳፌ ጉዬ ኤቤዴ ና ጋኣሌይ ባ ኢሻታራ ሴኬሜ ዪዴስ፤ ሴኬሜ ኣሳይካ ኢዛን ኣማኔቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_27","008_9_27","JDG","9","27","27","ኡባይካ ባ ጋዴ ጋዴ ቢዲ ዎይኔ ቴራ ማጺዳ፤ ዎይኔ ኡሻ ኣጊዲ ጊታ ባኣሌ ቦንቺዳ፤ ባንታ ኤቃ ኬꬃ ጌሊዲ ሄን ሚሼኔ ኡዪሼ ኣቢሜሌኬ ጫዪዳ። ");
INSERT INTO gmve_vpl VALUES ("JG9_28","008_9_28","JDG","9","28","28","ኤቤዴ ና ጋኣሌይ ሴኬሜ ኣሳስ፥ «ኣቢሜሌኬይ ኢዚ ኦኔ? ኑ ሴኬሜ ኣሳይ ኢዛስ ኣዛስ ሃሬቲዞኒ? ኢዚ ጌዶኔ ናኔ ኢዛስ ኦላ ኣሳ ካሌꬂዛይ ዬሩባኣሌ ጊዴኔ? ሂስቲን ኑኒ ኢዛስ ኣዛስ ኣዛዜታኔ? ሃሬቲዛ ጊዲኮ ሴኬሜ ኣዋ ኤሞሬስ ሃሬታና። ");
INSERT INTO gmve_vpl VALUES ("JG9_29","008_9_29","JDG","9","29","29","ሃ ኣሳ ካሌꬂዛይ ታና ጊዲዳኮ ታኒ ኣቢሜሌኬ ዲጋናኮሺን። ኣቢሜሌኬ ጼይጋዳ፥ ‹ኔ ኦላንቻታ ዳርሳ ኤካዳ ኦሌታናስ ሃ ያ› ጋዳ ዮታናኮሺን!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_30","008_9_30","JDG","9","30","30","ኤቤዴ ና ጋኣሌይ ጊዳ ማላ ካታማ ሃሪዛ ዛቡሌይ ሲዪዳ ማላ ኬሂ ሃንቄቲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_31","008_9_31","JDG","9","31","31","ሄሳፌ ጉዬ ኣቢሜሌኬኮ ኣስ ጉዬራ ኪቲዲ፥ «ኤቤዴ ና ጋኣሌይኔ ኢዛ ኢሻቲ ሴኬሜ ዪዲ ካታማን ዲዛ ኣሳ ኔ ቦላ ዴንꬄꬄቴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_32","008_9_32","JDG","9","32","32","ሄሳ ጊሻስ ኔኒኔ ኔናራ ዲዛ ኣሳይ ኦማርሳራ ዴንዲዲ ጌዴ ካሬ ኬዚዲ ጌማሶን ዛማዲ ናጊቴ። ");
INSERT INTO gmve_vpl VALUES ("JG9_33","008_9_33","JDG","9","33","33","ዎንቶ ማላዶ ኣርሼይ ሞኪሺን ኢስቲ ኣኬኮንታ ካታማ ዎራጂቴ፤ ጋኣሌይኔ ኢዛራ ዲዛ ኣሳይ ኢንቴና ኦላናስ ኬዚዛ ዎዴ ኢንቴስ ዳንዳዬቲዳ ማላ ሚኒዲ ኦሌቲቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_34","008_9_34","JDG","9","34","34","ኣቢሜሌኬይኔ ኢዛራ ዲዛ ኣሳይ ኡባይ ኦማርስ ዴንዲዲ ሴኬሜፔ ካሬራ 4 ቡቴን ሻኬቲዲ ዛማዲ ኡቲዳ። ");
INSERT INTO gmve_vpl VALUES ("JG9_35","008_9_35","JDG","9","35","35","ኣቢሜሌኬይኔ ኢዛራ ዲዛ ኣሳይ ኤቤዴ ና ጋኣሌይ ኬዚዲ ካታማ ጌሊዛ ፔንጌን ኤቂዳይሳ ቤኢዲ ቆቴቲዳ ሶሆፔ ኬዚዳ። ");
INSERT INTO gmve_vpl VALUES ("JG9_36","008_9_36","JDG","9","36","36","ጋኣሌይ ኣሳ ቤኢዳ ዎዴ ዛቡሌ፥ «ጼላ! ኣሳይ ዙማ ሁኤፔ ዎꬌꬃ ቦላ ዴስ» ጊዴስ። ዛቡሌይካ፥ «ሄይቲ ኣስ ጊዴቴና፤ ዙማታ ኤሾይ ኣሳ ሚሳቲዛይሳ ቤኣዳ ጋሳ» ጊዲ ዛሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_37","008_9_37","JDG","9","37","37","ጋኣሌይ ቃሴካ፥ «ጼላ! ኣሳይ ዙማስ ጊዶ ኣዳራ ዱጌ ዎꬌꬃን ዴስ፤ ሃራ ቡቴይ ቃሴ ሙሬኖ ዎላ ጌቴቲዛሶራ ዬስ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_38","008_9_38","JDG","9","38","38","ሄሳ ጊሻስ ዛቡሌይ ጋኣሌ፥ « ‹ኑኒ ኢዛስ ሃሬታናስ ኣቢሜሌኬይ ኦኔ?› ጊዳ ኔ ዶናይ ሃኢ ኣዋ ቢዴ? ሃይቲ ኔኒ ካꬊዳ ኣሳታ ጊዴቴኔ? ሃኢ ኬዛዳ ኢስታራ ኦሌታ!» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_39","008_9_39","JDG","9","39","39","ጋኣሌይ ሴኬሜ ኣሳ ካሌꬂ ኬዚዲ ኣቢሜሌኬራ ኦሌቴꬅ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_40","008_9_40","JDG","9","40","40","ኣቢሜሌኬይ ዬዴꬂን ጋኣሌይ ባቃቲዴስ፤ ካታማ ጌሊዛ ፔንጌ ጋካናስ ዳሮቲ ጫዴቲዲ ኩንዲዳ። ");
INSERT INTO gmve_vpl VALUES ("JG9_41","008_9_41","JDG","9","41","41","ኣቢሜሌኬይ ኣሩማን ዴኢዴስ፤ ዛቡሌይ ጊዲኮ ጋኣሌኔ ኢዛ ኢሻታ ሴኬሜፔ ጎዴሬꬂ ኬሲዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_42","008_9_42","JDG","9","42","42","ዎንቴꬃ ጋላስ ሴኬሜ ኣሳይ ባ ጎሻሶ ጎሻሶ ኬዚዳይሳ ኣቢሜሌኬይ ሲዪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_43","008_9_43","JDG","9","43","43","ሄሳፌ ጉዬ ባ ኣሳ ካሌꬂ ኬዚዴስ፤ ኣሳካ 3 ቡቴን ሻኪዲ ጌማሶን ዛማዲ ናጋና ማላ ኦꬂዴስ፤ ሴኬሜ ኣሳይካ ካታማፔ ኬዚዛይሳ ቤኢዲ ኢስታ ዎꬋናስ ቆቴቲዳሶፔ ኬዚዳ። ");
INSERT INTO gmve_vpl VALUES ("JG9_44","008_9_44","JDG","9","44","44","ኣቢሜሌኬይኔ ኢዛራ ዲዛ ቡቴይ ሲንꬅ ዎጺ ቢዲ ካታማ ጌሊዛ ፔንጌን ኤቂዳ፤ ኣቲዳ ናምኡ ቡቴቲ ጎሻሶን ዲዛ ኣሳ ኡባ ዎꬊዳ። ");
INSERT INTO gmve_vpl VALUES ("JG9_45","008_9_45","JDG","9","45","45","ጋላሳ ኩሜꬅ ኣቢሜሌኬይ ካታማ ኣሳራ ኦሌቲዲ ካታማዮ ኦይኪዴስ፤ ሄን ዲዛ ኣሳ ኡባ ዎꬊ ዉርሲዴስ፤ ካታማዮካ ላሊዲ ኢዚን ማጺኔ ዜሪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_46","008_9_46","JDG","9","46","46","ሴኬሜ ጊምቤ ጊዶን ዲዛ ኣሳይ ኡባይ ሄሳ ሲዪዲ ኤሊ-ቢሪታ ጌቴቲዛ ኤቃ ጾሳ ኬꬃይ ዲዛሶ ሚጻ ጊዶ ጌሊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_47","008_9_47","JDG","9","47","47","ኢስቲ ሄ ሶሆን ሺቂዳይሳ ኣቢሜሌኬይ ሲዪዲ፥ ");
INSERT INTO gmve_vpl VALUES ("JG9_48","008_9_48","JDG","9","48","48","ኢዚኔ ኢዛራ ዲዛ ኣሳይ ኡባይ ጻልሞኔ ጌቴቲዛ ዙማ ቦላ ፑዴ ኬዚዳ፤ ኣቢሜሌኬይ ካልታ ኤኪዲ ሚꬃ ታሼ ቃንጺዲ ባ ሃሼን ቶኪዴስ፤ ባናራ ዲዛ ኣሳታካ፥ «ታኒ ኦꬂሺን ቤይዳይሳ ኢንቴካ ኤሶን ሃኢ ኦꬂቴ» ጊዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_49","008_9_49","JDG","9","49","49","ኣሳይ ኡባይካ ሚꬃ ታሼ ቃንጺ ኤኪዲ ኣቢሜሌኬ ካሊዴስ፤ ሄ ታሼታ ሚጻ ፔንጌ ቦላ ኮሪዲ ኣሳይ ኢዛ ጊዶን ዲሺን ታማ ኦይꬂዳ፤ ሄሳ ጊሻስ ሚጻ ጊዶን ዲዛ ኣሳይ ኡባይ ሃይቂ ዉሪዴስ፤ ሄን ሃይቂዳ ኣቱማ ኣሳኔ ማጫሳ ቆዳይ 1,000 ጊዳና። ");
INSERT INTO gmve_vpl VALUES ("JG9_50","008_9_50","JDG","9","50","50","ሄሳፌ ጉዬ ኣቢሜሌኬይ ቴቤሴ ጌቴቲዛ ካታማ ቢዲ ካታማ ጊዶꬂ ኦይኪዴስ። ");
INSERT INTO gmve_vpl VALUES ("JG9_51","008_9_51","JDG","9","51","51","ሄ ካታማ ጊዶን ኢዛ ቦላ ኡቲዲ ናጊዛ ኢሲ ጊ