﻿USE sofia;
DROP TABLE IF EXISTS sofia.gmvRNT_vpl;
CREATE TABLE gmvRNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gmvRNT_vpl WRITE;
INSERT INTO gmvRNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Dawute naa, Abrahaame naa gidida Yesus Kirstoosa yeletetha zarkey hayssafe kaallizayssa; ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahaamey Yisaaqa yelides; Yisaaqi Yaqoobe yelides; Yaqoobey Yuhudanne iza ishata yelides; ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuhuday Timaarippe Faareesanne Zaara yelides; Faareesay Esroome yelides; Esroomey Araame yelides; ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Araamey Aminadabe yelides; Aminadabey Ne7asoone yelides; Ne7asooney Salomoone yelides; ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salomoonka Bo7eeze Era7aabippe yelides; Bo7eezey Urutippe Iyoobeede yelides; Iyoobeedey Isseye yelides; ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isseyey kawo Dawute yelides; Dawutey Ooriyo macheyfe Solomoone yelides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoonka Robi7aame yelides; Robi7amey Abbiya yelides; Abbiyayka Aasafe yelides; ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aasafey Yoosapixe yelides; Yoosapixey Iyooraame yelides; Iyooraamey Ooziya yelides; ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ooziyaney Iyoo7aatame yelides; Iyoo7aatamey Akaze yelides; Akazey Hiziqaase yelides; ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hiziqaasi Minaase yelides; Minaasey Amoxe yelides; Amoxeykka Yoosiyaasa yelides; ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yoosiyaasi Babiloone di7o layth Ikonyaanenne iza ishata yelides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babiloone di7oppe guye Ikonyaaney Salatiyaale yelides; Salatiyaaleyka Zerubaabele yelides; ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubaabeley Abiyoode yelides; Abiyoodey Eliyaqeeme yelides; Eliyaqeemey Azaare yelides; ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azaarey Saadooqe yelides; Saadooqey Akime yelides; Akimeykka Eliyoode yelides; ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyoodey Alazaare yelides; Alazaarey Maataane yelides; Maataaney Yaqoobe yelides; ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yaqoobeyka Kirstoosa geetettidayssa Yesusa yelida Maaramo ekkana giigissida Yoosefe yelides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Hessa gish Abrahaameppe yiidi Dawute gakkanaas tammanne oyddu yeleteth; qasse Dawuteppe Babiloone di7o wode gakkanaas tammanne oyddu yeleteth; Babiloone di7oppe Kirstoosa yeleteth gakkanaas tammanne oyddu yeleteth gidees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesus Kirstoosa yeletetha taarikey hayssafe kaalli dizayssa; iza aaya Maarama Yoosefes giigetta dishin izi izira gayttonta Xillo Ayanan qanthatada beettadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Izo giigissida Yoosefey xillo as gidida gish Maaramo asaa sinthan qonce kessonta qotara agganas ba woznara qachchides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Hayssa izi qoppishin Xoossa kiitanchay agumora izas qoncidi “Dawute naa Yoosefe! Ne giigissida Maarama qanthatiday Xillo Ayanan gidida gish izo neso efanaas babbofa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iza attuma naa yelana; izi asa nagarappe ashshanadde gidida gish iza sunth ne ‘Yesusa’ ga sunthana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Goday nabe Isayaasa duunan “Hekko! Gela7oy qanthatana; attuma naakka yelana; naaza sunthayka Amanu7eela geetettana; hessa birsheththika ‘Xoossi nunara dees’ geetettidi xaafettidayssi polettana mala hayssi wurikka hanides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yoosefeykka dhiskofe beeggidi Goda kiitanchay iza azazida mala Maaramo baso efides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Gido attin baada iza koyro naaza yelana gakkanaas izo ekibenna. Yeletida guutha naaza suntha “Yesusa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Kawo Herdoosa wode Yesusi Beeteleme Yuhudan yeletidappe guye awa arshey mokkiza baggafe eranchati Yerusalame yiidi ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Yeletida Ayhuda kawoy awan dizee? Awa arshey mokkiza baggara iza xoolinteza beyidi izas goynnana yidos” giidi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kawo Herdoosi hessa siydi daggammides; Yerusalamen diza asay wuri izara daggammides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Izikka Qeeseta halaqatanne woga tamarsizayta ubba shiishshidi “Kirstoosi awan yelettanee?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","6","Istika izas “Nabey ‘Yuhuda biittan dizaare hanne Beeteleme! Ta dere Isra7eele naagizadey neeppe kezana gish hanko Yuhuda haarizaytappe aazanka guuxakka’ giidi xaafida gish izi Beeteleme Yuhudan yelettana” giidi yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hessafe guye Herdoosi he eranchata geemara xeygisidinne ista hasayssidi xoolintezi istas bettida wodeyo shaakki erides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Eranchata Beeteleme yeddidi “Biidi guutha naaza koyite, takka baada izas goynnana mala demmida mala ha taakko simmidi izi awan dizaakkon taas yootite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Eranchatikka kawoy istas gidayssa siyidappe guye simmi bida; awa arshey mokkiza baggara istas bettida xoolintey ista kaaleththidi guutha naazi dizaso gaththides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Isti xoolinteza beyida wode daro ufayetida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Keeththe gelidi guutha naaza iza aayo Maaramira demmidinne gulbatidi izas goynnida; ba saaxine saaxine dooydi worqa, exaanenne karbe giza miish izas immida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Isti Herdoosakko simmonta mala agumon keehi naagettana mala geetettida gish hara ogera ba dere simmida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Eranchati bidappe guye Goda kiitanchay Yoosefes agumora beettidi “Herdoosi guutha naaza wodhana koyiza gish ne simmana wode ta nena erissana gakkanaas dendada guutha naaza aayeyra ekkada duge Gibxe biitta baqatada heen daashsha” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Hessa gish Yoosefey dendidi aayiyo naazara ekkidi gidoththara duge Gibxe biitta bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Herdoosi hayqqana gakkanaas heen de7ides. Hessanka “Ta naaza ta Gibxe biittafe xeeygadis” giidi Goday kase nabe duunan haasayidayssi polettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Eranchati iza baleththidayssa erida wode Herdoosi keehi hanqettides. Eranchati izas kase yootida mala ba as kiittidi nam7u laythanne nam7u layth kumontayta Beetelemeninne Beetaleme yuushon diza guutha attuma nayta ubba wodhisides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Hessan “Yeehoynne gita waaso giirisay Eraaman siyettides; Ira7eela ba naytas yeekkadus; nayti wuri wurida gish minnanas dandayonta ixadus” geetettidi nabe Ermaasan yootettidays polettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herdoosi hayqqidappe guye Goda kiitanchay agumora Yoosefes Gibxe biittan beettidi, ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Dendada guutha Naazanne iza aayiyo ekkada Isra7eele biitta simma; Naaza wodhana koyizayti hayqqida” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yoosefey dendidi naaza aayiyra ekkidi Isra7eel biitta simmides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Gido attin Arkalawosi ba aawa Herdoosa soon Yuhudan kawotidayssa siydinne he baanas babbides; Goday agumora izi he boonta mala yootida gish Galila awurajja bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Naazirete geetettiza katamayo biidi heen duus oykkides. Hessanka kase nabetan “Naazirete as geetettana” geetettidi kasetidi sinthafes hasayettidayssi kumides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","He wode xammaqiza Yohannisi asaas “Salo kawotethi matida gish inte nagarappe simmite” gi sabakishe Yuhuda bazzora yides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","“Goda oge ooththite, wogga ogezakka lo7ethite gishe bazzo biittan waassiza qaala” geetettidi kase nabe Isayaasan yootetidayssi Yohannisa gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohannisi gaamella isikefe oosettida may7o may7ees. Ba xeessan dafo gixxees; izi miza qumay degera essanne boole. ");
INSERT INTO gmvRNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yerusalameppe, kumeththa Yuhudappenne Yordanoose shaafa matan diza dere asay wuri Yohannisakko wodhdhidi, ");
INSERT INTO gmvRNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ba nagarakka izas paaxishe Yordaanoose Shaafan iza kushen xammaqettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Daro Farsaaweetinne Saduqaaweti izi xammaqizaso yishin beyidi Yohannisi “Inteno shooshato! Inte sinthara diza hanqofe attana mala intena ooni bessidee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Inte inte nagarappe simmidayssa bessiza ooso ooththite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","‘Nu aaway Abrahaamey nuus dees’ gizayssan interka intena baleththofte; ta intes Xoossi hayta shuchchatappe Abrahaames naa ooththi denthanas dandayees gays. ");
INSERT INTO gmvRNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hekko kaltay qanxanaas mithata garsan giigeti uttides; hessa gish lo7o ayfe ayfonta mithi wuri qanxettananne taman yeggettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Tani maarotethas haaththan xammaqays; haray atto shin ta iza caamma tookkanas bessontadey taappe aadhdhiza minoy guyera yaana; izikka Xillo Ayananinne taman intena xammaqana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kath suragiza pithay iza kushen dees; izikka ba kaththa baleza pitti geeshshana; ba gistezakka kaththa di7en qolana; happa gidikko to7onta taman xuugana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","He wode Yesusi Yohannisan xammaqettanas Galilappe Yordanoose shaafa bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Gido attin Yohannisi “Hayssi hanenna; tani nenan xammaqettana bessishin neni waanada taakko yay?” giidi izara marshettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesusikka “Aykkoy baawa, ero garkii? Hayssa ooththidi nuni xilloteth ubba polanas nuus bessees” gides. Yohansikka iza qofa ero gi ekides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesusi xammaqetidi haaththafe kezida mala heerakka saloy doyettin Xoossa Ayanay haraphe kafo misatidi iza bolla wodhdhishin beyides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Saloppekka “Tani izan ufayetiza Naazinne ta siiqiza ta Naazi hayssa” giza qaalay siyettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Hessafe guye Xillo Ayanay Xala7en paacettana mala Yesusa duge bazzo biitta efides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Oyddu tammu gallassinne oyddu tammu qamma xoomidappe guye Yesusi gafides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Paacizayssi Yesusakko shiiqidi “Ne Xoossa Naa gidikko ane hayta shuchchata uketh gidana mala azaza” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesusikka “ ‘Asi Xoossa duunappe keziza qaalanpe attin kaththan xalla deenna’ geetetti xaafettides” giidi izas zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Qasseka Xala7ey Yesusa geeshsha katamayo efi Xoossa Keeththa quste bolla kessidi, ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Ne Xoossa Naa gidikko ane hayssafe duge guppa; ayssi giikko ‘Ne tohoy shuchchan dhuphetonta mala kiitanchati ba kushera nena oykki denthana mala ne gish Xoossi ba kiitancha kiittana’ geetetti xaafettides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesusikka “Geeshsha Maxaafan ‘Ne Goda Xoossa paacofa’ geetetti xaafettides” giidi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Qasseka Xala7ey Yesusa keehi dhoqa zuma bolla kessidi salo gupanthon diza kawoteththa bonchozara ubba ehi bessidi, ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Ne kundada taas goynnikko hayssa ubba ta nees immana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesusi “Haysso Xala7e! Ta sinthafe haakka! ‘Neni ne Godas Xoossas goynna; izas xalala azazeta’ geetetti Geeshsha maxaafan xaafettides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Hessafe Xala7ey iza aggidi bides; kiitanchatikka yiidi iza maaddida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesusi, Yohannisi qashetidayssa siydi gede Galila simmides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Naazirete katama aggidi Zaabiloone Niftaaleme heeran abba matan diza Qifirnahoome kataman duus oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","16","“Hessan Zaabilooneninne Niftaaleme biittan, Yordanooseppe he pinthan abba lanqera efiza oge matan diza Ayzaabe gidida Galila dere asay, dhuman diza derey wolqama poo7o beyides. Hayqo kuwa giddon diza deres poo7oy poo7ides” geetettidi nabe Isayaasa duunan kasetidi hasayettidayssi polettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yesusi he wodeppe ha simmin “Salo kawotethi matides, maarota gelite” giidi sabbako oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesusi Galila Abba lanqera aadhdhishe nam7u ishanta; heytikka Phexroosa geetettiza Simoonanne iza isha Indiraasa beyides. Istika mole oykkizayta gidida gish mole oykkiza gite abban yeggishe deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesusi ista “Haa yiite! Tana kaallite! Ta intena as oykkiza as kessana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Isti heerakka mole oykkiza giteza yeggi aggidi Yesusa kaallida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Guuth sinthe bishe hara nam7u ishanta Zabidoosa naa nam7ata Yaqoobenne Yohannisa beyides; istika ba aawa Zabidoosara wogolo giddon mole gite lo7ethettes. Yesusikka ista xeygin; ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","isti heerakka wogolozanne ba aawa aggidi kaallida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesusi Ayhudata ista Woosa Keeththan tamarsishenne kawoteththa Mishiraachcho qaala sabbakishe qasse dere giddon ay hargeyka sakizayta pathishe kumeththa Galilan yuuyides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Hessa geedon lo7o nashoy kumeththa Sooriya biittan siyettides; dereyka dumma dumma sakon daro waayetizayta, daydanthi istan gelidayta, bollafe biittan yeggiza hargey dizaytanne silidayta izakko ehin ubbaakka pathides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Hessafe dendidayssan Galilappe, tammu katamatappe, Yerusalameppenne Yuhudappe, Yordanoose shaafa pinthafe yida daro asay iza kaallides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Daro derey shiiqidayssa beyidi Yesusi pude zuma bolla kezi uttides; iza kaallizaytikka izakko yida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Izikka ista hizgi tamarso oykkides; ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ayanan bana kawushshizayti anjettidayta; ayssi giikko Salo Kawoteth istassa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Qadhetizayti anjettidayta, ayssi giikko isti minettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ashketi anjettidayta; ayssi giikko isti biitta laattana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Xilloteth gafetizaytinne saamotizayti anjettidayta; ayssi giikko isti kallana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Asas lo7o ooththizayti anjettidayta; ayssi giikko istaska lo7oy oosettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wozina xilloti anjettidayta; ayssi giikko isti Xoossa beyana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Saroteth ooththizayti anjettidayta; ayssi giikko isti Xoossa nayta geetetti xeeygettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Xillotetha gish goodettizayti anjettidayta; ayssi giikko salo kawotethi istassa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ta geedon asay intena cayikko, goodikkonne iita yo7o wordora inte bolla haasayikko inte anjettidayta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Inte ha biitta asas maxine mala. Maxiney ba mal7otetha yeddiza gidikko gede kare yegettidi yedhetethafe attin, zaaridi demmanas dandayizee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Inte deres poo7o. Zuma bolla diza katamaya qotetanas danda7ukku. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Asi xompe oythidi keeththan diza asaa kumeththas poo7ana mala dhoqason woththes attin geema soon woththi erenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hessathoka asay inte lo7o ooso beyidi salon diza inte Aawa bonchana mala inte poo7oy asa sinthan poo7o. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Tani Muse woganne nabeta qaala shaarana yida intes misatoppo; polanas yadis attin shaaranas yabeekke. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ta intes tumu gays; saloynne sa7ay aadhdhana gakkanaas Muse wogay wuri polettana attin wogappe issi pidaleykka woykko qeerinyakka shaaretukku. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Hessa gish oonikka ha azazotappe guuxizaro gidikkoka ooththonta yeggi aadhdhikko, hankoytaka yedhi aadhdhana mala tamarsikko salo kawoteththan hessadey guuth geetetti xeeygettana; gido attin hayta azazota ooththi polishe hankoyta polana mala tamarsikko hessadey Salo Kawoteththan gita geetettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ta intes gays, inte xillotethi Farsaaweetappenne Muse woga tamarsizayta xillotethappe aadhdhonta aggikko Salo Kawoteth gelana dandayekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kase asatas ‘Wodhoppa; wodhidade bolla pirdettana’ geetettidayssa inte siyideta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ta qasse intes gizay ba isha bolla ogey baynda hanqettizade bolla pirdettana; oonikka ba isha ‘Nappay’ gizaddey duulata sinthan oyshettana. ‘Eeyay’ gizade Gaanname tama pirday naages. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Hessa gish neni yarsho shiishshizason Xoossas yarshana gishin ne ishay ne bolla mishetidazi nees qoppetikko, ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ne yarshizayssa heen yarshoson aggagada koyro baada ne ishara giiga; hessafe guye simmada ne yarshoza Xoossas shiishsha. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nena mootida ne morkey ne bolla pirdisonta mala, pirdiza daannay qachizayssas nena aaththi immonta mala, qasho keeththan ne wodhdhonta mala buro oge bolla dashe ne morkera elela giigaycha. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ta nees tumu gays; izi pirdisi wursida gidikko wursetha santiyo qanxana gakkanaas qashoppe birshetaka. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ ‘Laymatoppa’ gizayssa inte siyideta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tani gidikko intena hizgays; macasa amo ayfera xeellidadey wuri ba woznan izira laymatides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nagara ooththanas ne ushacha ayfey nees gaaso gidikko neeppe kessa wora yegga; ne asatethay kumeth gede Gaanname taman yegetanappe ne asatethafe issina paccikko lo7o. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ne ushachcha kushey nagara oosos gaaso gidikko neeppe qanxa digga; ne asatethay kumeth Gaannamen yegetanayssafe ne asatethafe issi billitey nees pacce gidikko lo7o. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“ ‘Macho anji yeddizadey pirma waraqata izis immana bessees’ geetettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tani qasse intena hizgays, hara asara laymatishin beyonta dishe ba macho anjizadey wuri iza laymatana mala ooththes. Hessathoka anjettidaro ekizadeyka laymatida mala qoodetes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kase asatas ‘Wordo caaqofa; Xoossa sinthan ne caaqidayssa naaga’ geetettidayssa inte siyideta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ta qas intena aykkokka caaqofte gays; saloy Xoossas uttiza alga gidida gish salon caaqofte. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Biittay Xoossa tohoy yedhizaso gidida gish biittanka caaqofte. Wogga kawo katama gidida gish Yerusalamenka caaqofte. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Inte hu7enka caaqofte; inte hu7e binanappe issineyokka booth woykko kareth histanas dandayekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Hessa gish inte inte giddon haasayettishin inte haasayay “Ee” gaanaz gidikko “Ee” giite “Akay” gaanaz gidikko “Akay” giite; hessafe kare gididay wuri iita asappe yizaza. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ ‘Ayfe gishas ayfe achcha gishas achcha’ geetettidayssa inte siyideta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ta qasse intes gizay iita ooththidadera eqetoppite; gido attin nees ushachcha shagala baqqizades hankoyssakka yuusha bessa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Issi asi ne giddora may7idayssa neeppe ekkanas nena mootikko bollara may7idayssakka gujada izas imma. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Issi asi nena issi saate oge ne baana mala wolqathikko issife nam7u dakko gidana oge izara ba. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nena woossizades imma; neeppe tal7e ekkanas koyizades zokko zaaroppa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ ‘Ne lagge siiqa; ne morke ixxa’ geetettidayssa siyideta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ta qas intena inte morketa dosite; intena goodizaytas woossite gays. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Inte hessatho ooththikko inte salo Aawas nayta gidana. Izi awa arshe iitatassinne lo7otas issi bolla gaththi imees. Irakka xillotassinne nagaranchatas issi bolla bukises. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Intena dosizayta xalala inte dosikko intes aaza go7ay dizee? Qaraxa qanxisizyti hessatho ooththetennee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Inte ishata xalla inte sarotikko hankoytappe aazan lo7etii? Ammanontaytikka hessatho ooththetes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hessa gish inte salo Aaway wosoy bayndayta gidida mala inteka wosoy bayndade gidite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Asi intena beyana mala asa sinthan lo7o ooththonta mala naagettite; hessatho ooththikko inte salo Aawappe go7a demmeketa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Inte manqotas maado immiza wode asi tana beyo giidi asa sinthan bonchetanas ogeninne Ayhuda Woosa Keeththan xurumba punisiza qoodheppe qommon hanizaytatho ooththofte. Ta intes tumu gays; isti ba waaga ubba haan ekkichida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Inte manqotas immishin ushachcha kushey ooththiza hadirisa kushey eroppo. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Inte imoy geeman gido; qotan oosettidayssa beyiza inte Aawayka inte waaga intes immana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Inte woossishe qoodheppe qommon hanizayta mala hanoppite; isti asi beyana mala Ayhuda woosa keeththataninne oyddu oge bolla eqqidi woossanas dossettes. Ta intes tumu gays; isti kumeththa waaga ekichida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ne woossana geliza ne kifile gela; karekka ne bolla gordada geeman diza ne Aawakko woossa. Geeman oosettidayssa beyiza ne Aaway ne ooso mala nees immana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ammanonta asay issi qaala zaari zaari woossikko istas siyetiza misatin isti zaari zaari gizayssatho inteka woossishe issi qaala zaari zaari gooppite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Gido attin inte Aaway inte woossanappe kasetidi intes aazi koshshizakkone eriza gish inte ista misatoppite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Inte woossishe ‘Salon diza nu Aawawu! Ne sunthi anjeto. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ne kawotethi haayo; ne sheney salon gidida mala sa7anka hano. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hachchis gidiza kath nuus hachchi imma. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nu nuna qohidaytas atto giza mala nekka nu qoho nuus atto ga. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Iitappe nuna ashsha attin nuna paacen gelthofa; bonchoy merpe merna gakkanaas neyssa. Amiin’ gi woossite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Inte intena qohidaytas atto giikko inte salo Aaway intes atto gaana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Qasse inte asa nagara atto gonta ixikko inte Aawayka inte nagara atto geenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Inte xooma xoomishe qoodheppe qommora xoomizaytatho shullofte. Isti ba xoomizayssa asi erana mala ba ayfeso iissetes. Ta tumu gays; hessatho ooththizayti ba waaga kumeth ekkichida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Neni xooma xoomashe ne ayfeso meeceta, ne hu7e tiyetta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Hessatho ne xoomikko geeman diza ne Aaway xalala erizazinne asi oonikka eronta qotan gidana. Qotan oosettidayssa beyiza ne Aawayka ne waaga nees immana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Bilay mizason buuqidinne shiydi mooretizason kaysoy bookkidi kaysanas dandayizason, ha biitta bolla intes miishe shiishofte. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Gido attin bilay maanas, buuqidi woykko shiydi mooretontason, kaysoy bookki ekkana dandayontason heen salon intes miishi shiishshite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ne miishay dizason ne woznay heen dees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ayfey asatethas poo7o; hessa gish ne ayfey paxa gidikko, ne kumeththa asatethayka poo7o gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ne ayfey hargancha gidikko, ne kumeththa asatethayka dhuma xalla gidana. Histikko nenan diza poo7oy dhuma gidikko, qasse dhumay waanida gird gida dhuma gidandee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Issi asi nam7u godas ooththana dandayenna. Issa ixidi nam7anthoza dosana; woykko issa bonchidi nam7antha leqqana; Xoossassinne miishas nam7atas gaththi ooththanas dandayettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Hessa gish ta intena inte duussa gish ay miinoo? Ay uyinoo? Ay may7inoo? giidi hirgofte gays. Shempoy qumappe, ashoy may7oppe aadhdhenee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ane salo kafota xeellite! Zerettenna, maxettenna, di7en qoletenna shin inte salo Aaway ista mizees. Inte istafe keehi aadhdheketii? ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ane intefe daro waayettidi baas imettida laytha bolla hara issi gallas gujana dandayiza asi dizee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Qasse may7o gish aazas hirgetii? Ane coo denban diza ciishshata xeellite; daaburetenna woykko suqetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Hessa gish ta intena gizay haray atto shin kawo Solomoonikka ba bonchora ha ciishshatappe issiney mala lo7o may7ibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Inteno pace ammanoy dizayto! Hachchi asa ayfen beettidi wonto taman wodhdhana maata hayssatho mayziza Xoossi intena hessafe lo7ethi aaththi mayzanas dandayenee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Hessa gish nu ay maanee? Ay uyanee? Ay may7anee? giidi hirgofte. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Hanko ammanonta asay hayssa demmanas daro qoppees. Hayssi wuri intes koshshizayssa inte salo Aaway erees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Harappe sinthatidi Xoossa Kawoteththa xilloteth koyite; hayti wuri intes gujettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hessa gish wontos keehi qoppofte; wonto metoy wontos aqo; issi issi gallassay baassi gidiza metora dees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Inte bolla pirdetonta mala hara asa bolla pirdofte. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Inte pirdida mala inte bollakka pirdettana. Inte makkida miishara intes makettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ne ayfen diza gita mitha beyonta dashe ne isha ayfen diza qeeri buura aazas xeellay? ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ne ayfen gita mithi dishin ne isha ‘Ane ta ne ayfeppe qeeri buurayo kessays’ gaanas waana dandayay? ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Neno qoodheppe qommon hanizaysso kasetada ne ayfen diza gita mitha kessaycha. Hessafe kaallada ne isha ayfen diza buura kessanas lo7etha xeellandasa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ba tohon yedhonta malanne simmidi intena saxi daakerethonta mala anjettidayssa kanata sinthan yeggofte; qasse inte worqakka guddunthata sinthan yeggofte. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Woossite intes imettana; koyite inte demmana; kare qoxite intes doyettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Woossida ubbas imettana; koyiza asi demmana; qoxizades karey doyettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Inte giddofe issades nay uketh woossikko shuch immiza aaway dandee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Woykko mole woossikko shoosh immizadey dandee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Histin inte iitata gidi uttidi inte naytas lo7o miish imo erizayta gidikko inte salo Aaway iza woossizaytas waanidi aadhdhiza lo7o miish imenee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Hessa gish hara asi intes ooththana mala inte koyizayssa, inteka haratas ooththite. Muse wogaynne nabeti hayssan kuuyettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Xuuntha pengera gelite; dhayoso efiza ogey gita; pengeykka aaho; daro asay he pengezara gelees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","De7os gaththiza ogey gidikko xuuntha; pengeykka xuuntha; gelanaytikka guuthata xalala. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Istas giddo baggay Kana suyte mala gidi uttidinne dorsa ite may7idi inte giddo gelidi giddora ooththiza wordo nabetappe naagettite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Inte ista, ista ooson erandeta. Aguntha worappe woyney, kindicho agunthafe balase ayfey maxetizee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Hessathoka lo7o mithi wuri lo7o ayfees; iita mithika iita ayfe ayfees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Lo7o mithi iita ayfe ayfanas dandayontayssa mala iita mithi lo7o ayfe ayfanas dandayenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Lo7o ayfe ayfonta mithi wurikka qanxetananne taman yegettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Hessa gish inte ista isti ayfiza ayfen shaakki erana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Salon diza ta Aawa shene polonta dishe tana ‘Godo! Godo!’ gizay wuri Salo Kawoteth gelenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","He gallas daroti ‘Godo! Godo! Nuni ne sunthan tinbite yootibekonii? Ne sunthan daydanthi kessibekonii? Ne sunthan daro malata ooththibekonii?’ gaana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","He wode ta istas ‘Ta intena mulekka erikke! Inte iitati taappe haakkite’ gaada qoncera ta istas yootana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Histikko hayssa ta qaala siydi ooson peyshizadey ba keeththe zaalla bolla keexizade misatees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Deexo iray bukkin; haroyka harottides; carkoyka carkides; keeththaka sugides shin zaalla bolla keexettida gish kundibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Hayssa ta qaala siydi ooththontadey gidikko ba keeththe ace bolla keexida eeya asa mala. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Deexo iray bukkin haroyka harottides; carkoyka carkides; he keeththaka sugides; keeththayka iita kundeth kundides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesusi tamarsi wursin asay iza timirtezan malalettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Gaasoyka Muse woga tamarsizayta mala gidonta izi godateththi diza asa mala tamarsides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesusi zuma bollafe wodhdhin daro derey iza kaallides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Issi inchiracha hargey dizaddey Yesusakko shiiqidi iza sinthan gulbatidi “Godo! Ne koykko tana pathanas dandayassa” gides ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesusi ba kushe yeddidi “Ta dosadis; paxa!” giin addezi he hargezappe heerakka paxides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Qasseka Yesusi addeza “Ne paxidayssa oonaska yootoppa; gido attin baada nena Qeeses bessa. Isti azazida yarshoza gaththa; hessika istas marka gidana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesusi Qifirnahoome gakkida mala mato halaqay izakko shiiqidi iza hizgi woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Godo! Ta ashkaray keehi sakettidi keeththan ichchidi dees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesusikka izas “Ta baada pathana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mato halaqay izas zaaridi “Ta nena ta keeththe gelthanas bessizadde gidikke; gido attin ne haan daada issi qaala xalla giikko ta ashkaray paxana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Taaska tana azaziza halaqati taappe bollara deettes; qasseka taas azazettiza wotadarati taappe garsara deettes; istafe issa ‘Ba!’ giikko bees; qasse issa ‘Haaya!’ giikko yees; ta ashkara ‘Hessa ooththa!’ giikko ooththes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesusi iza zaarozan malaletidi bana kaallizaytas “Ta intes tumu gays; haray attoshin Isra7eeleta giddon hayssa mala ammanoy dizadde issadeka demmabekke. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ta intes yootays; daroti awa arshey mokkiza baggafenne wulliza baggafe yaana. Salo Kawoteththa maaddan Abrahaamentara Yisaaqantaranne Yaqoobentara issife uttana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Salo Kawotethi istas gidana bessiza asati heen kare dhuman yegettana. Heenka yeehoynne achcha garcech gidana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesusikka mato halaqas “Ne ba ne ammano mala nees hano” gides; ashkarazi heerakka paxides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesusikka buro Phexroosa keeththe gelshin Phexroosa bolloteya misho harge saketada ichchidaaro beyides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Izi kushe Yesusi bochchin misho hargey aggides. Izakka dendada Yesusa mokkadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","He gallasa omaris daydanthi oykkida daro asata Yesusakko ehida. Izikka tuna ayanata ba qaalara istafe kessides; harganchataka ubba pathides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Isayaasi “Izi nu harge ekkides; nu sakokka tookkides” gida qaalay hayssan polettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Daro asay iza giddoththidayssa biyidi Yesusi asaa abbafe he pinth pinana mala azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hessa wode issi Ayhuda ammano tamarsizadey izakko shiiqidi “Astamaare! Ne bizaso awakka ta nena kaallana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesusikka izas zaaridi “Workanatas ollay dees; salo kafotas keeththi dees; taas Asa Naas gidikko hu7e gelthizasoy baawa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Iza kaalliza issi hara asi qasse “Godo! Koyro baada ta aawa moogoo?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Izi qasse “Hayqidayti ba hayqeth moogeto; neni gidikko tana kaalla” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Hessafe guye Yesusikka wogolon gelin iza kaallizaytikka izara issife bida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Qopponta abba giddon dambalay dendidi wogoloyo mittana gakkanaas ista waayssides. Hessi wuri hanishin Yesusi dhiskides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Iza kaallizayti iza beegoththidi “Godo! Nu dhayoos; nuna ashsha!” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesusikka ista “Inteno ammanoy paccidayto! Aazas hayssa mala babbetii?” gides. Hessafe dendidi carkozanne abba dambala izi hanqin heerakka sirph gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Istika “Hayssi abbaynne carkoyka izas azazettizaddey izi waanidadee?” giidi malaletida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Izi abba pinnidi Gergesenoone geetettiza dere gakkida mala daydanthi oykkida nam7u as dayti ba diza dufoppe kezidi izara gaaggida. Asi he ogezara aadhdhanas dandayetonta mala asas daro keehi meto gidi deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Istika “Xoossa Nawu! Nees nunara aaza issifeteth dizee? Nu wodey gakkonta dishin nuna xuugana yadii?” giidi waassida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Heen istafe guuth haakkidi daro gudduntha wudey issi bolla heemetes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Daydanthati Yesusa “Ne nuna kessana gidikko haytan daro guddunthatan nu gelana mala nuus piqaade imma” giidi woossida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesusikka ista “Biite!” gides. Daydanthatikka istafe kezidi guddunthatan gelida. Guddunthati wurikka ba dizaso aafora bicharshe abban gelidi haaththan mitettidi hayqqida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Gudduntha heemmizayti elelidi katamay dizaso biidi guddunthay hanoyssanne daydanthi ista oykkida asata bolla hanidayssa ubba asas yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Katama asay wuri Yesusara gagganas kezides. Yesusa beyidinne ista dere yeddi baana mala iza woossida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Hessafe guye Yesusi abba bolla wogolora pinnidi kase ba diza katama yides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Heen issi gunda addeza, asay halara tookkidi Yesusakko ehides. Yesusikka ista ammano beyidi gunda addeza “Aykkoy ba; haysso naazo! Ne nagaray atto geetettides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","He wode Muse woga tamarsizayti “Hayssi Xoossa cashsha” giidi ba woznan qoppida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesusi ista qofa eridi “Inte woznan iita yo7o aazas qoppetii? ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘Ne nagaray atto geetettides’ guussafenne ‘Dendada ba!’ guussafe awayssi kawushshee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Gido attin Asa Naas biitta bolla ase nagarappe maaranas sheney dizayssa erana malassa” giidi gunda addeza “Denda! Ne hala ekkada gede neso ba” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Gunda addezikka dendidi baso bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Dereyka hessa beyidi malaletethaninne babon kumidi hayssa sire godateththi asas immida Xoossa galatides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesusi heeppe dendidi bishe issi Matoosa geetettizadey qaraxa qanxisizason uttidayssa beyidi “Tana kaalla!” giin, dendidi iza kaallides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesusi Matoosason maadda bolla dishin daro qaraxa qaraxizytinne nagaranchati izakko yiidi izaranne iza kaallizaytara issife maanas uttida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farsaaweeti hessa biyidi Yesusa kaallizayta “Intena tamarsizayssi qaraxa qanxisizaytaranne nagaranchatara wosti istara issife kath mizee?” gi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesusikka isti gizayssa siydi ista “Aakkimey koshshizay saketidaytas attin saketonta paxatas gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hessa gish ‘Inte biidi yarsho gidonta maaroteth dosays’ giza qaala birsheth tamarite. Nagaranchata xeeygana yadis attin xillota xeeyganas yabekke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Xammaqiza Yohannisa kaallizayti Yesusakko yiidi “Nuninne Farsaaweeti xoomishin nena kaallizayti aazas xoometenee?” gi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesusi istas “Mishiraa laggeti mishirazi istara dishin muuzotana bessizee? Mishiray istafe ekettana wodey yaana; isti he wode xoomana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Gal7a may7o bolla ooratha woso woththi sikkiza asi deenna. Gal7a bolla oorath woththi sikkikko oorathazi gala7aza peedherethidi ha daassi darissanna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Oonikka ooratha woyne cajje gal7a lukkamon gujenna. Gujiza gidikko lukkamozi dhuuqana; woyne cajjezikka gukkana; lukkamozikka go7ay bayndazi gidana. Gido attin ooratha woyne cajjey ooratha lukkamozan gujjetees. Hessa malara woyne cajjezinne lukkamozi lo7o naagettidi gam7ana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesusi asaa haasaysson dishin issi shuumey iza sinthan kundidi “Taas naa daara hayqqana gawus. Iza paxa daana mala yaada ne kushe izi bolla wotharkii?” giin, ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesusi dendidi izara bides; Yesusa kaallizaytikka izara bida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tammanne nam7u layth kumeth izippe suuthi gukkiza issi macassi Yesusappe guyera yaada iza afala macara bochchadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Iza hessa ooththiday “Ta izas afaala macara bochidakko paxana” giza ammanoy izi woznan diza gish bochadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesusikka guye simmi xeelidi macasayo “Aykkoy ba, ta naye; nena ne ammanoy pathides” giin macasaya heerakka paxaagadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesusikka shuumeza so mata gakkishin derey zayeranne dinkera waassishe yeekkizayssa be7idi, ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Kichchite! Naya dhiskadus attin hayqqabeekku” giin isti iza bolla miicida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Derey wuri keeththafe kezin izi keeththe gelidi nay kushe oykkides; nayakka denda eqadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iza goobatethi he dere ubban seetettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesusikka heeppe bishin nam7u qooqeti “Dawute Nawu! Nuna maarariki!” giidi waassishe iza geedo kaallida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Qooqetikka Yesusi gelida keeththa iza kaallidi gelida. Yesusikka ista “Ta inte ayfe pathana danda7izayssa ammanetii?” giidi oychides. Istika “Ee, Godo!” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hessafe guye Yesusi ista ayfe bochidi “Inte ammano mala intes hano!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ista ayfeykka xeellides. Yesusikka “Hayssa oonikka eronta mala” giidi minthi yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Gido attin isti biidi, heera ubbason Yesusa gish woresida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Isti heeppe kezishin daydanthi oykkida issi duuna duude as Yesusakko ehida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Daydanthazi kezidappe guye he duuna duude addezi haasaya oykkides; derezikka malaletidi “Hayssa mala hanoy Isra7eele biittan hanin nu beyi erokko” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Gido attin Farsaaweeti zaaridi iza “Daydanthi kessizay daydanthata halaqanna” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesusi Ayhudata Woosa Keeththan Ayhudata tamarsishenne Xoossa Kawoteththa Mishiraachcho qaala yootishe qasseka harge ubbaafe asa paathishe gutatan gutatan yuuyides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Asay wuri heemizadey baynda dorsa mala keehi metotettidi xeellizay bayndade gididayssa beyida wode istas daro mishettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Bana kaallizaytaska “Maxa gakkida kaththay daro shin maxi shiishshizayti guuthata. ");
INSERT INTO gmvRNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Hessa gish kaththa Goday kaththako oosanchata yeddana mala woossite!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesusi bana kaalliza tammanne nam7ata baako xeygidi, isti tuna ayanata kessana mala qasseka sakoppenne hargefe pathana mala istas godateth immides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tammanne nam7u Hawaareta sunthay hayssafe kaallizayssa; koyro Phexroosa geetettiza Simoona, iza isha Indiraasa, Zabidoosa naa Yaqoobenne iza isha Yohannisa, ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Piliphoosanne Bartelemoosa, Toomaasanne qaraxa shiishshiza Matoosa, Ilfiyoosa naa Yaqoobenne Tadoosa, ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ba baggas mishetiza Simoonanne guyeppe Yesusa hayqos aaththi immida Asqoroonto Yuhuda. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Hayta tammanne nam7ata ubba “Gede Ayzaabeta gaath booppite; Samaariya asaa katama geloppite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Gido attin Isra7eele deraa garsafe dhayida dorsatakko biite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Biidinne ‘Salo kawoteth matides!’ giidi sabakite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Harganchata paathite, hayqqidayta hayqoppe denthite, inchiracha hargizayta geeshshite; daydanthata kessite; inte mela ekidayssa mela immite; ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","worqa, bira woykko xarqimala gidin inte kiisen oykkofte. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Oosanchas hachchis hachchis gidizazi koshshiza gish inte oges giidi shinqe, koshshonta may7o, caamma woykko guufe eki booppite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Issi katama woykko issi guta inte geliza wode intena mokkanade koyi demmidi iza keeththan shempite; heeppe kezana gakkanaas heen diishshite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Inte oona keeththika gelishe ‘Saro’ giite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","He keeththay sarotay bessiza keeththe gidikko inte sarotay he keeththas gido; sorotay bessonta keeththe gidikko inte sarotay aggidi intes simmo. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ay asikka intena mokki ekkanasinne inte giza siyanas koyontade gidikko hessade keeththafe woykko he katamappe kezishe ista bolla yiza gomeppe inte attidayssas marka gidana mala inte toho bolla diza gudula pittidi kezite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ta intes tumu gays; pirda gallas he katamay bolla gakkana pirday Soddome bollan Gamoora bolla gakkida pirdafe deexo gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ta intena dorsa mala kana suyteta giddora kiittays. Hessa gish shoosha mala cincatanne haraphe mala ashketa gidite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Asay intena oykkidi pirdiza duulatas shiishana; Ayhudati ba Woosa Keeththan intena garafana; hessa gish istafe naagettite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ta geedon dere haarizaytakkonne kawotakko intena efana; ista sintheninne ammanonta asata sinthan inte marka gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Intena isti oykkiza wode ‘Nu ay gi haasayinoo? Wozgi zaaro imminoo?’ gi hirgofte. He wode inte gaanazi intes imettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Intenan haasayanay inte Aawa Ayanappe attin intena gidekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ishay ba isha hayqos aaththi immana; aaway ba naa bolla, nayti bana yelidayta bolla makalatethan dendidi hara asan wodhisana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ta gish asi wurikka intena ixana. Gido attin wurseth gakkanaas miqnni eqiday izi attana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Asay intena inte diza heerappe gooddikko haraso kichchite! Ta intes tumu gays; inte Isra7eele katama ubba gakkonta dishin ta Asa Nay yaana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ashkaray godappe woykko kaallizadey kaalethizadefe aadhdhenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tamarey bana tamarsizayssa mala woykko ashkaray goda mala gidikko hessi izas gidana. Keeththa aawa ‘Bi7elizeebula’ giikko so asaa ayssi hessafe iita geetenne! ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Hessa gish istas babbofte; geemetiday qonconta qotetiday geesh kezonta attenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ta intes dhumara yootidayssa poo7on haasayite; haythan siyidayssa qoncen haasayite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Asho wodhikkofe attin shempo wodhanas dandayontaytas babbofte; hessafe ashonne shempo gathi Gaanname taman dhayssanas dandayizayssas babbite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Issi santen bayzettiza nam7u siine kafotappe issiniyakka inte salo Aawa sheney baynda coo kunda attuku. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Haray atto shin inte hu7e binanaykka tayibon dees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Hessa gish babbofte. Daro siine kafotappe inte waagay aadhdhi bonchettidaza. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Asa sinthan taas markattizades takka salon diza ta Aawa sinthan izades markatana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Qasse asa sinthan tana kadidade takka salon diza ta Aawa sinthan iza kadana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ta biitta bolla saroteth ehanas yida intes misatoppo; mashsha ehanas attin saroteth ehanas yabeekke. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tani yiday naa aawappe, maca naa aayippe, naa macho bollotippe shaakanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Asas morkey so asa gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Taappe aaththidi ba aawa woykko ba aayo siiqizadey taas gidanas bessenna. Taappe aaththidi ba attuma naa woykko, maca naa siiqizadey taas gidanas bessenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ba masqale tookkidi tana kaallonta asi taas gidanas bessenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ba shempo aashshanas koyizadey dhaysses; ba shempo ta gish aaththi immizadey ashshees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Intena mokki ekizadey tanakka mokki ekkees. Tana mokki ekkizadey tana kiittidadekka mokki ekkees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Issi nabe nabetethan mokki ekkizadey he nabeza waaga demmana. Xillo as iza xillotetha gish mokki ekkikko he xilloza waaga ekkana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Hessa gish ta intes tumu gays; oonikka hayta guuthatappe tana kaallizade gidida gish issi xu7a irxa haath ushshikko hinniska waagay dhayenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesusikka bana kaalliza tammanne nam7u asatas azazo immi wursidappe guye tamarsanassinne sabakanas Galilan diza katamata bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Yohannisi qasho keeththan dishe Kirstoosas ooththiza hanota siydi bana kaallizayta izakko yeddidi “Asi ashshizaddey yaana geetettiday neneyee? Hara naaginoo?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesusikka zaaridi “Biidi inte sidayssanne inte beyidayssa Yohannisas yootite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Qooqeti xeellettes; wobeti hammutettes; inchracha hargizayti paxettes; tulleti siyettes; hayqidayti hayqoppe paxi dendettes; manqotas Mishiraachcho qaalay yootettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tanan dhuphetontadey anjettidade” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yohannisa kaallizayti bidappe guye Yesusikka asas Yohannisa gish “Ay beyanas duge bazzo bidetii? Carkoy qaathiza shomboqo beyanas yidetii? ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Woykko ay beyanas kezidetii? Lo7o may7o may7idi lo7i uttidade beyana yidetii? Lo7o may7o may7idi lo7izayti kawota keeththan deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Histin ay beyana kezidetii? Nabe beyana kezidetii? Ee, ta intes gays nabeppe aadhdhizayssa beyanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“ ‘Ne bana oge nees giigissanadde neeppe kaseta ta nees kiittana geetettidi iza gish kase xaafettidadey izakko!’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ta intes tumu gays; macasape yeletida asappe xammaqiza Yohannisa misatiza asi biitta bolla dendibenna. Gidikkoka Xoossa Kawoteththan as ubbafe laafa asi Yohannisappe aadhdhana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Xammaqiza Yohannisa wodeppe ha simmin ha7i gakkanaas Salo Kawoteththaya daro baaxeta bolla dawus. Mino asati xalla izo demmana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nabetikka Muse wogaykka wuri Yohannisa wode gakkanaas buroppe hananayssa yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Histikko inte ekkana koykko izi yaana geetettida Elaasi izakko! ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Siyiza haythi diza as siyo! ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","“Hayssa ha wode asaa aazan leemisoo? Giyan uttidi ba laggeta ‘Nu intes diiththi diixxin inte durbeekketa! Yeeho zilalth zilalin yeekkibeekketa!’ giza nayta misatetes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yohannisi muussafenne ushshafe naagetidi yida gish ‘Izi daydanthara dees’ gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ta Asa Nay mashenne uyashe yiin ‘Hayssi miidi kallonta asa, ushshancha, qaraxa shiishshizaytassinne nagaranchatas laggekko!’ gida. Gido attin Xoossa eratethi ba ooson xilladus” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","21","Hessafe guye Yesusi izi malatata ooththida katama asay maarotethan gelonta aggida gish “Kuraziinenne Betesayda! Intena aayye ana! Inte bolla oosettida malatay Xiroose bollanne Sidoona bolla oosettidakko isti maaqa may7idinne bidinthan uttidi beni beni maarotethan gelanakoshin. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Hessa gish tani intes gizay pirda gallas intefe aadhdhi Xiroosessinne Sidoonas qixaatey kawuyana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Hanne Qifirnahoome pude salo dhoqu dhoqu gaanas koyadii? Gido attin neni duge Si7oole wodhandassa; ne bolla oosettida malatay Soddomen oosettidakko Soddomey hachchi gakkanaas daanakkoshin. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Hessa gish ta nena gizay pirda gallas qixaatey neeppe Soddomes kawuyana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","He wode Yesusi “Salonne sa7a Godo! Ta Aawawu! Hayssa daro eranchataappene cincatappe qotada qeeri naytas ne qoncisida gish ta nena galatays. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ta Aawawu! Ee hayssi ne sinthan lo7o ne shene gididi beettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Wurikka ta Aawappe taas imettides; Aawappe attin Naaza gish eriza as baawa; qasse Naazappenne Naazi ba shenen qoncisida asappe haray aawa eriza as baawa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Toohoy deexxidayto, daaburidayto inte wurikka taakko ha yiite; takka intes shempo immana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ta qambara tookkite; taappekka tamarite; tani ta woznan aadanne ashke; inte shempos inte shempo demmana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ta qambaray shaykonne ta toohoy kawushsha” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Hessafe guye Yesusi Sambata gallas kaththa giddora aadhdhi bides. Iza kaallizaytikka gafida gish tiya duuththidi shigechi muus oykkida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farsaaweeti hessa beyidi Yesusa “Hekko nena kaallizayti Sambata gallas ooththetanas bessontayssa ooththetes” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Izikka istas zaaridi “Dawuteynne izara diza asati gafida wode izi ay ooththidakkone nababibeekketii? ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Xoossa Keeththe gelidi Qeesetappe attin Dawuteynne izara dizayti bochchanas bessonta dummatida uketh mides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Qasse Qeeseti Sambata shaaridi Xoossa Keeththa giddon ooso ooththikko mooro gidontayssa Muse wogappe nababibeekketii? ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Gidikkoka ta intes gizay Xoossa Keeththafe aadhdhizadey haan dees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‘Tani yarsho gidonta maaroteth dosays’ giza qaalay ay guussikkone inte erizakko xillota bolla pirdeketakkoshin. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Asa Nay Sambatas Goda” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Heeppe izi gede aadhdhishe Ayhudata Woosa Keeththan gelides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Henka issi kushe silidadey dees. Yesusa mootanas gaaso koydi “Sambata gallas pathanas bessizee?” giidi iza oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Izikka ista “Intefe issade dorsi Sambata gallas ollan gelikko ba dorsa izi gelidi ollafe goochchi kessi erenee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Histikko asi dorsafe keehi aadhdhenee? Hessa gish Sambata gallas lo7o oosoy digettenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Qasseka addeza “Ne kushe piddisa!” gides; addezikka ba kushe piddisin hinko kusheza mala paxa gidides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Gido attin Farsaaweeti heeppe kezidi, Yesusa wosti oykki wodhanakonne ba giddon zoretida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesusi ista qofa eridi heeppe haraso sher7i gides. Daro derey iza kaallides; harganchatakka ubba pathides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Izi oonakkone asas yootonta mala ista azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","21","Hessika haniday nabe Isayaasan “Ta dooridaynne ta izan ufayettiza ta nay hayssakko! Ta Ayanappe ta iza bolla wothana; izikka ammanonta deretas tumu pirda awajjana; marshettenna; woykko waassenna. Izas qaalaykka karen siyettenna; tuma pirda xoonos gaththana gakkanaas dincetti uttida shomboqokka menthenanne cuwattiza muqadakka toyssenna; Ayzaabeti iza ufayssan naagana” geetetti yootettida tinbite qaalay polettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Hessafe guye daydanthi oykkin xeellanassinne haasayanas dandayonta issi as Yesusakko ekki yida. Yesusikka iza pathin addezi xeellanassinne haasayanas dandayides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Asay wurikka malaletidi “Hayssi addezi Dawute naashaa?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Gido attin Farsaaweeti hessa siyida wode “Hayssi addezi daydanth kessizay daydantha halaqa Bi7elizeebula wolqan xalla gidanas bessees” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesusikka ista qofa eridi “Ba giddon issoy issafe shaakettiza kawotethi wurikka kundana; ba giddon shaakettiza katamay woykko keeththa asi minnenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Xala7ey Xala7e kessiza gidikko Xala7ey ba giddon shaakettides guussa. Hessatho hanikko iza kawotethi waani minnana dandayizee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Tani Bi7elizeebula wolqan kessiza gidikko inte nayti aaza wolqan kessanee? Hessa gish inte nayti inte bolla pirdana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Gido attin tani daydanth kessizay Xoossa Ayanan gidikko Xoossa Kawotethi inteko yides guussa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Woykko issi as wolqara dizadde keeththe gelidi miishe bonqana koyko kasetidi he wolqara diza addeza oykki qachonta wosti bonqanee? Qachidappe guye bonqana dandayees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Tanara gidontadey tanara eqettees; tanara issife shiishonta asi wurikka laalles. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Hessa gish ta intes tumu gays; nagara oosoynne cashshi wuri asas atto getettana shin Xillo Ayana cayidadey maarettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ay asikka asaa naa bolla haasayiza iita qaala gish maarettana shin, Xillo Ayana bolla haasayiza iita qaalay gidikko hayssa ha woden gidin woykko buro yaana woden gidin maaroy deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Mithi wuri ayfen eretizayssa mala inte lo7o ayfe demmanas intes lo7o mithi do; intes iita mithi diza gidikko inte iita ayfe ekkana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Inteno mardzera diza shooshato! Inte iitata gidi uttidi wosti lo7o haasayanas dandayetii? Ulo giddon kumidazi duunara hasayettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","“Lo7o asi ba woznan kunthi woththida lo7o qofappe lo7o haasayees; iita asikka ba woznan kunthi woththida iitatethafe iita yo7o kessees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Gido attin ta intes gizay asay ba haasayida hada qaala ubba gish pirda gallas wurikka oyshettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gaasoyka ne qaalappe dendidayssan ne xillada attananne ne qaalappe dendidayssan ne bolla pirdettana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Hessafe guye issi issi Muse woga tamarsizaytinne Farsaaweeti Yesusa “Astamaare! Nu neeppe malalisiza malata beyanas koyoos” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Izi istas zaaridi “Ha iitanne layma yelettay malata oychees; gido attin nabe Yoonaasa malatappe attin hara malatay immetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yoonaasi gita mole ulo giddon heedzdzu qammanne heedzdzu gallas gam7ida mala Asa Naykka heedzdzu gallassinne heedzdzu qamma biitta garsan gam7ana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nanawe asay pirda gallas hayssa ha yelettara dendidi ha yeletta bolla pirdana; gaasoyka Nanawe asay Yoonaasa markatethan maaroteth gelida gishassa. Hekko Yoonaasappe aadhdhizadey haan dees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Dugeha dere kawoya Solomoone erateth siyanas biitta gaxappe dendada yida gish pirda gallas iza hayssa yeletethara dendada ha yeletetha bolla pirdana. Hekko Solomooneppe aadhdhizadey hayssan dees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Tuna ayanay asappe kezidi shempo demmanas haaththi baynda mela biittan daaburees. Gido attin ba koyiza shempo demmenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Hessafe qasse kase ta dizaso simma baana giidi beeniso izi simmishin kase izi dizasoy aykkoynne baynda mela keeththe gididi geeyedayssanne giigeti dizayssa demmees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Hessafe biidi hara baappe iitiza laapun iita ayanata banara ekkidi yees. Istika he addezan gelidi de7ana. He addezas kase duussafe guye duussay iita gidana. Hayssa iita yeletethaska hessa mala hanana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesusi asaas yootishin iza aayeyanne ishati iza yoochana koydi karen eqqida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Issi asi “Hekko ne aayanne ne ishati nena haasayissanas karen eqqidi nena koyeettes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesusikka “Ta aaya oonee? Ta ishatich, isti oonantee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ba kushera bana kaallizaytakko malatidi “Ta aayanne ta ishati haytanta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Salon diza ta Aawa shene ooththizayti wurikka taas isha, michonne aayo” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","He gallassi Yesusi keeththafe kare kezidi abba lanqen uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Daro derey iza yuuyi aadhdhi giddoththida gish asaa abba gaxan aggidi wogolo gido geli uttidi, ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","daro yo7o leemisora “Issi goshshanchay zereth zeranas kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Izi zerishin issi issi zerethi oge duunan wodhdhin kafoti yiidi maxi mida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Issi issi zerethi melanne shuchchatiza biitta bolla wodhdhin biittay mela biitta gidida gish elle caarides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Gido attin away awattin shullidinne xapho yeddonta aggida gish melides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Issi issi zerethay aguntha giddon wodhdhides; agunthayka diccidi caarechcha cuullides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Hara zerethikka lo7o orde biittan wodhdhidi ayfeka ayfides; issoy xeetu, issoy usuppun tammu issoy heedzdzu tammu ayfe immides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Siyiza haythi dizadey siyo!” gi yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Hessafe iza kaallizayti izakko shiiqidi “Aazas leemisora yootay?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Izikka istas “Salo Kawoteththa xuura eroy intes imettides; istas gidikko imettibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Dizaddes dizayssa bolla gujettananne darana shin bayndadefe hinna dizaarakka eketaychana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ta hayssatho leemisora yootizay isti siyishe ezgonta gishshinne xeellishe demmoonta gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","“Isayaasi ‘Inte sisa siyanashin yuushi qoppeketa; xeelo xeellana shin woznan wotheketa; dereza woznay muumides; ista haythayka siyenna; xeellonta mala ba ayfe qilm7ida; hessi bayndakko isti ba ayfera beyidinne ba haythara siydi ba woznan yuushi qoppidi taakko ha simmin ta ista pathana shin’ gida tinbite qaalay istan polettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Inte ayfey xeelliza gishshinne inte haythati siyiza gish inte anjettidayta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ta intes tumu gays; daro nabetinne daro xillo asati ha7i inte beyizayssa beyanassinne ha7i inte siyizayssa siyanas amottida shin istas hanibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Histikko ha7i zeretha leemisoza birsheth siyite: ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kawoteththa qaala siydi yuushi qopponta ay asa woznappekka Xala7ey yiidi zerettida zeretha eeson maxichana. Hessika oge bolla wodhdhida zeretha. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Shuchcha bolla zerettidayssi qaala siyida mala ufayssan siydi heerakka ufayssan ekizade misatees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Gido attin xapho yeddanas dandayonta aggida gish daro gam7onta qaala geedon metoynne goodeteththi yiza wode eleli dhuphetes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Aguntha giddon zerettida zerethay qaala siydi hayssa ha alamezas daro metotethanne duretetha qofan balettidinne cuulettidi ayfe immoonta asa mala. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Lo7o biittan zeretida zerethay qasse qaala siydi yuushi qoppizade misatees; tummu ayfe ayfees; issoy xeetu, issoy usuppun tammu, issoy heedzdzu tammu ayfe immides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesusi qasseka hara leemiso istas “Salo Kawotethi ba goshsha gaden lo7o zereth zeridade misatees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Gido attin asi wuri ichchida wode morkey yiidi gisteza giddon leeshsho zeridi bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Gistezi diccidi ayfe ayfiza wode leeshshoyka izara issife beettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Katha goda ashkarati godazakko shiiqidi ‘Godo! Neni ne goshshan lo7o zereth zerabeekii? Hayssi leeshshoy awappe yidee?’ gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Izikka istas ‘Hessa morkey ooththides’ gides. Ashkaratikka ‘Nu biidi leeshshoza shoddana mala koyay?’ gi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Izikka istas, ‘Akay hanenna; gaasoyka inte leeshshoza shoddishe gistezara gaththi shoddana; ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","aggite! Maxa wodey gakkanaas issife dicco; he wode maxizayti leeshshoza kasetidi qori maxidi taman xuuganas mirqen mirqen qachite; gisteza qasse shiishshidi gootaran gelthite’ gaada ta intes yootana” gi yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Hara leemiso istas “Salo Kawotethi issi asi ba gade giddon zerida barzaafe mitha ayfe mala. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Barzaafe mitha ayfey hara mitha ayfe ubbaafe daro laafa gidikkoka diccada mitha ubbaafe gita gidawus. Salo kafotikka izi hagga bolla keexxidi daana gakkanaas gita mithi gidawus” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ha7ikka hara leemiso istas “Salo Kawotethi macassi liixey dendana mala liixe giddon gujida guutha irsho misatawus” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesusi hayssa ubba asas leemisora yootides. Leemisoy baynda issinokka yootibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Hessanka kase nabe duunan “Ta duuna ta leemison doyana; alamey medhetosappe ha simmin qotetidayssa ta haasayana” geetetti yootettidays polettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Hessafe Yesusi asaa aggidi so gelides. Iza kaallizayti izakko shiiqidi “Katha giddon diza leeshshoza gish ne yootida leemisoza birsheth nuus yoota” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Izikka istas zaaridi “Lo7o zereth zeriday Asa Naa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Goshshay hayssa alameza; lo7o zerethay Kawoteththa nayta gididayssa bessees; leeshshoy qasse Xala7e nayta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Leeshshoza zeridi bida morkey Daabuloosa. Maxa wodey alame wursethi gidishin maxizayti Xoossa kiitanchata. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Leeshshoy qoretidi taman xuugetizayssa mala alame wursethan hessatho hanana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Asa Nay ba kiitanchata kiittana; istika nagaras gaaso gididaytanne iita ooththizayta iza Kawoteththa giddofe ubba qori kessana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Yeehoy dizasonne ach garcizason daro wolqama taman ista yeggana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Hessa wode xilloti ba Aawa Kawoteththan awa arshe mala poo7ana. Siyiza haythi dizadey siyo! ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Salo Kawotethi gade giddon qotetida miishe misatees. Issi as he miishayo demmidi zaari qottides. Ufayssafe dendidayssan biidi baas dizazi ubba bayzidi he miishiya diza biitta shamides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Hessathoka Salo Kawotethi al7o worqa koyiza zal7ancha misatees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Daro al7o gidida inqo giza shuchcha demmida mala biidi baas dizazi ubba bayzidi shamides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Qasseka Salo Kawotethi abba giddon yegettidi dumma dumma mole oykkida mole gite misatees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mole oykkizayti gitey kumin goochchidi abba lanqe kessida. Heen uttidi lo7o lo7o mole qoridi keeshen gujida. Iita moleta wora yeggida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Alame wursethan hessatho hanana. Kiitanchati yiidi nagaranchata xillotappe shaakkidi yeekkizasonne ach garcizaso gede to7onta taman yeggana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Yesusi ista hayssi wuri intes gelidee?” gides. Istika “Ee” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Izikka zaaridi “Hessa gish Salo Kawoteththa xuuray gelida Muse woga tamarsizadey oonikka izas minji woththida al7o miishafe oorathanne kase gal7a miish kessizade misatees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesusikka hayta leemisota yooti wursidi heeppe haraso bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Gede ba dere biidi Ayhudata Woosa Keeththan asa tamarso oykkides. Istika malalettidi “Hayssi addezi hayssa eratethanne hayta malatata ooththana wolqa awappe demmidee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Hayssi anaxeza naa dennee? Iza aayey sunthi Maaramo gidenee? Iza ishati Yaqoobe, Yoosefe, Simoonanne Yuhuda gidettennee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Micheti nunara dizayta gidettennee? Histin hayssi addezi hayssa ubba awappe ekidee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Hessa gish isti izi gizayssa ekkibeetenna. Yesusikka istas “Nabey ba dereninne ba keeththan bonchettenna attin harason bonchettes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Isti ammanonta aggida gish daro malatata heen ooththibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","He wode Galila dere haariza Herdoosi asay Yesusa nashizayssa siydes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herdoosi ba ashkaratas “Hessa gidikko, Xammaqiza Yohannisi hayqoppe dendidi yides guussakka! Hayssi wuri gita malatay iza kushen oosettizay hessassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herdoosi ba isha Piliphoosa macho Herodiyadi gaason Yohannisa oythidi qasho keeththan yeggides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Gaasoyka Yohannisi Herdoosa “Ne izo ekkana mala woga gidenna gida gishassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herdoosikka Yohannisa wodhanas koyishin asay Yohannisa nabe mala xeelliza gish babbides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","7","Herdoosi ba yeletetha gallas Herodiyadi naya yethan iza ufayssida gish naya iza oychidaz ubba immanas izis caaqides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nayakka aayey zoren “Xammaqiza Yohannisa hu7e keren wothada ha7i hannin taas imma” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","He wode kawozi izas mishettides. Gido attin caaqida gishshinne izara diza imathata gish giidi nay oyshoy polettana mala azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kiittidinne Yohannisa woyne keeththan dishin qoodhe qanxisides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Qanxetida hu7eza keren woththidi nays immida. Nayakka ekkada ba aayeys immadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yohannisa kaallizayti iza aha ekkidi moogidinne hanidayssa ubba Yesusas yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Hessa siyida mala Yesusi kase ba dizaso aggidinne wogolon gelidi barka hara asi bayndaso bides. Dereyka hessa siydi katamay dizasoppe tohora iza kaallides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesusikka wogolozappe wodhdhishe daro asa beyidi asas mishettides. Saketizaytaka pathides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Gadey qammi qammi bizayssa beyidi iza kaallizayti izakko shiiqidi “Hayssi nu dizasoy bazzo; gadeyka qammi qammi biza gish gede gutatan gutatan biidi baasi maanaz shammana mala asaa yedda” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Gido attin Yesusikka ista “Inte asas maanaz immite attin asay baanas koshshenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Istika izas zaaridi “Hayssan nuus ichashu ukethinne nam7u moleppe attin haray baawa” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Izikka ista “Ane heyta dizayta haa taas ekki yiite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Qasseka asay maata bolla uttana mala azazides. Ichashu ukethanne nam7u moleta ba kushen oykkidi ba ayfe pude salo dhoqu histi galatidi, uketha menthi bana kaallizaytas immides. Istika asaas immida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Asay wurikka miidi kallides. Hessafe guye iza kaallizayti asaappe mishin attidayssa tammanne nam7u leemate kumeth shiishida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mida asay macasattinne guutha nayti gujettonta attumasay xalala ichashu shi gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Heerakka iza kaallizayti wogolon gelidi gede pinth izappe kasetidi pinana mala azazidi asa moyzanas baassi guye attides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Dereza moyzidappe guye woossa woossanas barka zuma bolla kezides. Gadey dhuminka yaan zuma bolla barka dees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Hessa wode wogoloya abba kantha bishin dambalay dendidi daro metotho oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Qamappe koyro kuttoy baqqishin Yesusi abba bollara hamutidi iza kaallizayti dizaso yides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yesusa kaallizaytikka izi abba bollara hamuti yishin beyi babbida gish iza moytile giidinne waassida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesusi heerakka “Aykkoy ba! Tanakko; babbofte!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Phexroosi “Godo! Nena gidikko ta abba bollara hamutada neekko baana mala tana azaza” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesusi iza “Haaya!” gides. Phexroosikka wogolozappe wodhdhidi haaththa bollara hamutidi Yesusakko yides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Gido attin carkoza wolqa biyidi babbida gish haaththan miteteth oykkidi “Godo! Tana ashsha!” gi waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesusi heerakka ba kushe yeddi oykkidi “Neno, ammanoy paccidaysso! Aazas sidhadii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yesusinne Phexroosi wogolozan gelida mala carkoy sirph gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Hessafe guye wogolon dizayti “Neni tumu Xoossa Naa!” giidi izas goynnida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesusinne iza kaallizayti abba pinnidi Gensereexe geetettizaso gakkida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Heen dizayti Yesusa gididayssa eridi, he heeran yuuyi aadhdhanas diza asaas kiita yeddida. Asaykka harganchata ubba Yesusakko ehides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Harganchati iza afala xeera xalala bochchana mala Yesusa woossida. Bochchidayti wurikka paxida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Qasseka Yerusalameppe yida Farsaaweetinne Muse woga tamarsizayti Yesusakko shiiqidi ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nena kaallizayti kase nu aawata woga aazas dhayssizoo? Quma maanas kushe mecetetenna” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesusikka istas “Inte inte wogas giidi Xoossa azazo ays shaaretii? ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Xoossi ‘Ne aayiyonne ne aawa boncha; ba aawa bolla woykko ba aayi bolla iita qaala haasayidaddey hayqo!’ gi azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","inte gidikko ay asikka ba aawa woykko ba aayo ‘Ta intes ooththanas bessizaz ay miishekka Xoossas yarsho ooththa shiishadis’ giikko, ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","‘He addezi ba aawa woykko ba aayo bonchides’ geeta; hessa gish inte woga gish Xoossa qaala shaareta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","9","Inteno, qoodheppe qommon hanizayto! Isayaasi inte gish yootishe ‘Hayssi derey tana duunan xalala bonchees; woznay gidikko taappe haakkides; mela hada tana goynnees; ista timirteykka asi woththida woga’ gididi sinthafe hananayssa yootidayssi tumakko” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesusi asaa baako xeygidi “Siyite woznan woththite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","As tunisizay izaade duunara ha kezizayssafe attin duunara duge gelizay tunisenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Qasse iza kaallizayti izakko shiiqidi “Farsaaweeti ne gidayssa siydi hanqettidayssa eradii?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Izi istas “Ta Aawa saloyssi tokkonta mithi wurikka dhoqallettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ista aggagite isti qooqeti kaalethiza qooqeta gidida gish, qooqeti qooqe kaalethikko nam7ay issoy issara oyketidi aafon wullana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Phexroosi Yesusa “Ne yootida leemisoza nuus birsha” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Izikka “Inte ha7i gakkanaska eribeekketa guussee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Duunara gelizay wuri duge qanthe kanthidi gede kare kezizayssa ereketii? ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Duunara kezizay gidikko woznappe pultees. As tunisizay hessa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Iita qofay, shempo wodhoy, laymay, laymatanas qaaqatoy, kaysoy, wordo markatethinne asa sunth mooroy wuri woznappe pultees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","As tunisizay haytantafe attin kushe mecetonta muusi as tunisenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesusi heeppe kezidi gede Xiroosenne Sidoona geetettiza dere bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Issi Kanaane macassi dizaara he heerappe kezada Yesusakko yaada “Godo, Dawute nawu! Taas miisheta! Ta naya tuna ayanay oykkin keeha waayawus” gaada waassadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Gido attin izi issi qaalakka izis zaaribenna. Histin he wode iza kaallizayti izakko shiiqidi “Nuna kaalla kaalla waayssiza gish ne izo moyzikkochii?” giidi iza oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Izikka istas “Tani Isra7eele keeththafe dhayida dorsatakko xalala kiitetadis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Macasayakka Yesusa toho bolla kundada “Godo! Tana maaddarki!” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Izikka izis zaaridi “Nayta kath ekkidi kana butulatas yegganas bessenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Izakka “Ee Godo; butalatikka ba goda maaddappe gaden wodhdhida kath maxi meettes” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Hizgin Yesusikka macasayo “Hanne macasaye, ne ammanoy gita! Ne koyda mala nees hano” gides. Macasay nayakka heerakka paxadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesusi heeppe dendidi Galila Abba lanqe biidi heen diza issi zuma bolla kezi uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Qoodan daro derey wobeta, qooqeta, silata, haasayonta duudeta harataka daro harganchata ehidi iza sinthan woththides; izikka ista pathides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Duudey haasayishin, toho silay paxishin, wobey siti giidi hamutishin, qooqey xeellishin beyidi asay malalettides; Isra7eele Godakka galatides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesusi bana kaallizayta xeygidi “Asay tanara heedzdzu gallas gam7ida gishshinne maana kaththi baynda gish asay tana michees. Oge bollan gafan daaburidi kundonta mala mela ulora yeddanas koyikke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Iza kaallizayti “Hayssan aykkoykka baynda bazzo biittan hayssa keena dere mizanas gidiza quma nu awappe demmanee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesusi ista “Intes aappun ukethi dizee?” gi oychin istika “Laapun ukethinne qii guutha moleti deettes” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Izikka derezi gaden uttana mala azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Laapun ukethanne moleza ba kushen oykkidi galatidappe guye menthidi bana kaallizaytas immides; istika deraas gishida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Asay wurikka miidi kallides; Yesusa kaallizayti asaappe attidayssa laapun leemate kumeth shiishida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Midaytikka naytinne macasay baynda addeti xalala oyddu shi gidida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesusi dereza moyzidappe guye wogolon gelidi Megidoone geetettizaso bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farsaaweetinne Saduqaawe geetettizayti Yesusakko shiiqidi iza paacanas “Saloppe malata bessa” giidi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Izikka istas “Omarsa wode saloy zo7ikko ‘Gadey awattana’ geeta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Wonta bolla ‘Saloy deexikko deexides; hachchi iray bukkana’ geeta; salo medha xeelidi shaakki ereeta shin ta yaana wode malata shaakki eranas dandayekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Hayssi iitanne layma yelettay malata koyees; gido attin Yoonaasa malatappe attin hara malatay izas imettenna” gides. Yesusi ista heen aggagidi haraso bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Abba pinnida mala Yesusa kaallizayti quma oykkanayssa balettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesusikka “Qoppite; Farsaaweeta irshofenne Saduqaaweta irshofe naagettite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Isti qasse ba giddon “Nuni kath oykkonta gish hessa gides” giidi issoy issara haasayettida ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesusikka ista qofa eridi “Inteno ammanoy paccidayto! Kath oykkonta gish aazas issoy issara haasayetetii? ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ichashu ukethi ichashu shi asas gididi aapun leematey tirpin inte denthidakkonne yuushi qoppeketii? ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Hessathoka laapun ukethi oyddu shi asas gididi aapun leematey tirpin inte denthidakkonne woznan woththibeekketa guussee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Histin ta intes yootiday kaththa gish gidontayssa waandi yuushi qoppeketii? Ha7ikka Farsaaweeta irshofenne Saduqaaweta irshofe naagettite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ha7i izi ista qofisizay bukeeso denthanas gujiza irsho gish gidonta Farsaaweetanne Saduqaaweta timirtefe naagettana mala gididayssi istas gelides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesusi Qisaariya Piliphisiyoose geetettiza biitta gakkida wode bana kaallizayta “Asay tana Asa Naa oona gizee?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Istika “Issi issi asay ‘Xammaqiza Yohannisa’ gees; bagga asay ‘Elaasa’ gees; baggay ‘Ermaasa woykko nabetappe issade gidonta aggenna’ gees” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Izikka ista “Inte tana oona geetii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoona geetettiza Phexroosi “Neni Kirstoosa de7o Xoossa Naa gidikkii?” giidi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesusi “Yoona naa Simoona neni anjettidade! Nees hayssa qoncisiday salon diza ta Aawappe attin ashonne suuthi gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Neni zaalla; hayssa zaalla bolla tani ta Woosa Keeththe keexxana; Gaanname pengetikka izo xoonetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Salo Kawoteththa qulpeta ta nees immana; neni biitta bolla hano gizay wuri salonikka hanana. Biitta bolla ne hanoppo gidayssi wurikka salonikka hanenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Qasseka izi Kirstoosa gididayssa isti oonaska yootonta mala bana kaallizaytas lo7ethi yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Hessafe ha simmin Yesusi Yerusalame baanayssa, heen dere cimatan, Qeeseta halaqataninne Muse woga tamarsizayta kushen waaye ekkanayssa, hayqqanayssanne heedzdzantho gallas hayqoppe dendanayssa bana kaallizaytas qoncisidi yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Phexroosi Yesusa gede issi bagga zaaridi “Godo! Hayssi ne bolla gakkofo!” giidi hanqides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesusi Phexroosakko shiiqidi “Haysso Xala7e! Hayssafe kichcha! Neni asazappe attin Xoossa yo7oy ne wozna giddon baynda gish ne taas dhuphe gidadasa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Qasseka Yesusi bana kaallizaytas “Tana kaallanas dosiza asi bana kado; ba masqale tookkidi tana kaallo. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ba shempo ashshana koyiza asi wuri dhayssana; gido attin ba shempo ta gish dhayssizadey ashshana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Asi alamen dizaz kumeth haarid ba shempo dhayssikko iza ay maaddanee? Woykko asi ba shempo gish qanxana dandayizazi aazee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Asa Nay ba Aawa bonchoranne salo kiitanchatara yaana; issas issas iza ooso mala izaade waaga immana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ta intes tumu gays; hayssan eqqida asata giddofe Asa Nay ba kawoteththara yishin beyana gakkanaas hayqoy ista bochonta asati deettes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Usuppun gallassafe guye Yesusi Phexroosanne Yaqoobe qasseka Yaqoobe isha Yohannisa banara ekkidi istara xalala issi dhoqa zuma bolla kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Isti heen dishin Yesusa medhay laamettides; iza ayfesoy Awa arshe mala poo7ides; iza may7oykka poo7o mala xolqides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Heerakka Museynne Elaasi Yesusara haasayishe istas beettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Phexroosi Yesusa “Godo! Nu hannin dizaakko nuus lo7okko! Ne shene gidikko issi daase nees, issi daase Muses, issi daase Elaasas heedzdzu daase ooththoo?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Izi buro haasayan dishin poo7iza shaaray ista kammides; shaara gaaththara “Tani izan ufayettiza ta dosiza ta nay hayssa; izi gizaz siyite” giza qaala giiris siyettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iza kaallizaytikka hessa siyida wode dagammidi biitta bolla gufannida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesusi istako shiiqi ista ba kushen bochidi “Dendite; babbofte!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Isti dhoqu gi xeellishin Yesusappe attin izara hara as oonakka be7ibeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Isti zuma bollafe wodhdhishin Yesusi “Asa Nay hayqoppe dendana gakkanaas inte beyoyssa oonaska yootonta mala” gi azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yesusa kaallizayti “Histin Muse woga tamarsizayti, Elaasi kasetidi yaana bessees aazas gizoo?” giidi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Izikka istas “Tumakko; Elaasi yiidi wursikka giigissana giidi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ta intes gizay Elaasi yides; gido attin asay ba koyda mala iza bolla ooththides attin iza erbeenna; hessathoka Asa Nay ista kushen waaye beyana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","He wode Yesusa kaallizayti Yesusi istas yootizays Xammaqiza Yohannisa gish gididayssa erida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","15","Yesusinne iza kaallizayti asaakko simmida mala issi asi Yesusakko shiiqidi iza sinthan gulbatidi “Godo! Ta naa dayssa bollafe yeggiza hargey daro waayssiza gish taas maarariki! Daro wode taman kundees; haaththanka gellees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Tani naaza nena kaallizaytakko ehadis shin isti iza pathana dandayibeetenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesusi “Neno ammanonta geella yelettazo! Ayde gakkanaas ta intenara daanee? Qasse ayde gakkanaas ta intena dandayanee? Ane naaza ha taakko ehite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Hessafe guye Yesusi daydantha seeridi naazappe kessides; naazikka he saateppe simmidi paxides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yesusa kaallizayti xalala izakko shiiqidi “Nuni daydantha kessanas aazas dandaybeykkonii?” giidi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Izikka istas “Intes ammanoy pace gidida gish dandaybekketa; ta intes tumu gays; qeeri gaashe ayfe mala ammanoy inte bolla dizaakko hayssa zuma ‘Hayssafe dendada gede ba!’ inte gidakko izi intes baana. Intena xoonanay deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Hayssa malay gidikko xoomaninne woossan attin haran kezenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Isti Galilan issife dishin Yesusi ista “Tana Asa Naa asas aaththi immana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Istika iza wodhana; izikka heedzdzantho gallas dendana” giin iza kaallizayti keehi mishettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesusinne iza kaallizayti Qifirnahoome geetettizaso gakkidappe guye Xoossa Keeththa giira ekkizayti Phexroosakko shiiqidi “Inte astamarey Xoossa Keeththa giira nam7u dinareza ays qanxenee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Izikka istas “Qanxees” gides. Phexroosi so gelida mala Yesusi kasetidi “Simoona dere kawoti giira gidin woykko qaraxa gidin ba naytappe ekkizoyee? Haratappe ekkiza misatizee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Phexroosikka “Haratappe ekkettes” gides. Yesusi “Histikko nayta bolla accoy ba guussaka! ");
INSERT INTO gmvRNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Histikkokka ista nu dhuphethonta mala ne mole oykkiza gite ekka baada abban yegga; koyro oykkida moleza duuna ne pooqada demmiza miisha ekkada ta suntharanne ne sunthara giira qanxa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","He wode Yesusa kaallizayti izakko shiiqidi “Salo Kawoteththan nu garasan ubbafe aadhdhanadey oonee?” gi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","Yesusi issi naa xeygi ehidi ista giddon essidi “Ta intes tumu gays; inte simmonta ixikkonne guutha nayta mala hanonta ixikko mulekka Salo Kawoteth gelekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hessa gish ha naaza mala bana ziqqisizadey Salo Kawoteththan ubbafe aadhdhana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Hayssa mala guutha naa ta sunthan ekkizadey tana ekkees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Gido attin tana ammaniza guuthatappe issade dhuphethizay deexo woxa shuch ba qoodhen qashettidi abba ciimman yegettidi mitettikko izas lo7o gidana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Hanna alameya asi dhuphana gaaso gidida gish izis aayye-ana! Dhuphey yuus aggenna shin dhuphezas gaaso gidizaddes aayye-ana! ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ne kushey woykko ne tohoy nena dhuphanas gaaso gidikko neeppe qanxa digga! Ne nam7u kushera woykko nam7u tohora gede merna taman yegettanappe wobe woykko toho sila gidada he gede de7oy dizaso geloy nees lo7ana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Hessathoka ne ayfey nees dhuphe gidikko neeppe kessa yegga! Nam7u ayfera gede Gaanname taman ne yegetanappe issi ayfera de7oy dizaso ne gelizaysi nees lo7o. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Hayta guuthata giddofe issiniyoka inte kadhonta mala naagettite! Ta intes tumu gays; salon diza ista kiitanchati salon ta Aawa ayfeso ubba gallas xeelletes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Asa Nay dhayidayta ashshanas yides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ane taas yootite issades xeetu dorsi diikko qasse istafe issina dhaykko, hanko uddufun tammanne uddufunata zuma bolla yeggidi dhayidaro koyana bi erennee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ta intes tumu gays; hanko dhayonta attida uddufun tammanne uddufun dorsatappe aaththidi beettida dorsayn ufayetees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hessathoka ha guuthata giddofe issoy dhayana mala salon diza inte aawa shene gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ne ishay nena qohikko izakko baada iza xalala nenara ekkada iza mooro izas yoota; izi ne giza siyikko ne isha ne as ooththassa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Izi ne gizayssa siyonta ixikko yo7oy wuri nam7u markan woykko heedzdzu markan ladhdhiza gish issade woykko nam7u as nenara ekka baada iza hasayssa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Izi istaka siyonta ixikko Woosa Keeththas yoota; Woosa Keeththayokka siyonta ixikko izaade ne ammanontade malanne yootin simmonta iita asa mala qooda. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ta intes tumu gays; inte biitta bolla qachiday wurikka salonikka qashettida gidana; inte biitta bolla birshidazi salonikka birshettidayssa gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Qasseka ta intes tumu gays; inte biitta bolla nam7u gididi ay miishikka ero ero giidi inte oychikko salon diza ta Aaway intes immana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nam7u woykko heedzdzu gididi ta sunthan inte shiiqizason heen inte giddon ta daana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Hessa wode Phexroosi Yesusakko shiiqidi “Godo! Ta ishay tana qohikko ta izas aapunto atto goo? Laapunto atto goo?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesusikka izas zaaridi “Laapun tammuto laapun attin laapunto xalala ga, giikke; ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Hessa gish Salo Kawotethi ashkara bolla diza miishe shiishana koyda kawo misatawus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Miisha qooda oykkida mala iza ashkaratappe daro milone bira accoy iza bolla dizadde ekki yida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ashkaraykka iza bolla diza accoza qanxoy xoonda gish izikka iza machiyakka iza naytinne izas dizazi wuri bayzettidi miishay qanxettana mala iza goday azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","He wode ashkarazi godaza toho bolla kundidi ‘Tani ta bolla diza accoza wursi nees qanxana gakkanaas taas guutha wode immarki!’ giidi woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Iza godayka izas mishettidi iza accoza wursi maaridi yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“He ashkaraykka ba goda achchafe kezida mala guutha accoy iza bolla diza ba lagge demmidinne ‘Ne bolla diza ta miishayo ha7i hannin qanxa’ giidi cuulli oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","He iza lagge ashkaray ‘Taas guutha wode immarki! Ta nees qanxana’ giidi iza toho bolla kundidi woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Gido attin izas guutha wode immanas koyonta ixidi iza laggezi ba bolla diza accoza qanxana gakkanaas qasho keeththan yeggides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Hessa izi ooththishin beyida asaynne hanko iza lagge ashkarati daro mishettida. Biidikka hanidayssa wursi ba godas yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","33","“He wode godazi he ashkara xeygisi ehidi, haysso neno! Iitazo, ne tana woossin ne bolla diza accoza ta nees aggadisishin ta nena maarida mala nekka ne laggeza maaranas bessenee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Giidi iza bolla diza accoza izi wursi qanxana gakkanaas qachana mala qachizaytas aaththi immides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Hessa gish inte issoy issa woznappe maaronta aggikko salon diza ta Aawayka intena maarenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesusi yooti wursidappe guye Galila aggidi Yordanoose pinthan diza Yuhuda awurajja bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Daro derey iza heen kaallin izikka harganchata pathides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farsaaweeti iza paccanaas izakko shiiqidi ay gaasonka “Asi ba macho anji yeddana bessizee?” giidi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Izikka istas “Xoossi koyroppe macanne adde medhdhidayssa nababibeykketii? gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Qasseka ‘Asi aawanne aayo aggidi ba machira issife gides. Nam7aykka issi asho gidettes’ geetettidayssi hayssa geedon gidenee? gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nam7ay issi asho attin sinthafe nam7u gidettenna. Hessa gish Xoossi gaththi waaxidayssa asi shaakkofo” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Istika izas “Histin Musey ‘Asi ba macho anji yeddida anjo waraqata izis immi yeddo’ giidi aazas azazidee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesusikka istas “Musey inte wozna muumeteth beyidi macheta inte anjana mala piqaade intes immides attin koyroppe hessa mala gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","“Ta intes tumu gays; ba azinappe harara laymatonta dishin ba macho anjidi hara macho ekizadey wuri laymatees. Anjettidarokka ekkizadey izira laymatees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yesusa kaallizayti izas “Machi wogaynne azina wogay hayssa mala gidikko macho ekkonta agoy lo7o” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Gido attin Yesusi istas “Issi issi imettida asatappe attin hayssa timirteza oonikka ekkanas dandayenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Gaasoyka issi issi asay ba aayi uloppe yelettishe shuufa gididi yelettees; issi issi asay asa kushen qaaratettidi gundulees; issi issi asay Salo Kawoteththas giidi bana barka gundula ooththiza asikka dees. Hayssa ekkanas dandayizaddey ekko” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","He wode Yesusi ista bolla ba kushe woththidi woossana mala guutha nayta izakko ekki ehida; gido attin iza kaallizayti nayta ehida asata bolla hanqettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesusi “Nayti haa taakko yeeto; diggofte; Salo Kawotethi haytanta malassa!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ba kushe nayta bolla woththidi anjidappe guye heeppe dendi bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Hessafe guye issadey Yesusakko shiiqidi “Astamaare! Merna de7o demmanas tani lo7o ooso ay ooththoo?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesusikka “Tana aazas lo7o gish oychay? Lo7oy issi Xoossa xalala; gede de7oy dizaso ne gelana koykko azazota naaga” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","19","Addezi “Azazoti awaytee?” giidi oychides. Yesusikka zaaridi “As wodhoppa; laymatoppa; kaysotoppa; wordo markatofa; ne aawanne ne aayo boncha; ne shooro ne mala siiqa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Naatethazi zaaridi “Hayssa wursa ta naagadis; haray aazi taas paccidee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesusikka zaaridi “Ne mule xillana koykko baada ne haaridaz wursa bayzada miisha wursa manqotas imma; neni salon miish demmandasa; hessafe guye simma yaada tana kaalla” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Addezi hessa siydi izas daro miishi diza gish keehippe mishetishe bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesusi bana kaallizayta “Ta intes tumu gays; dureti Salo Kawoteth gelanayssi daro meto. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Qasseka tani intes gizay durey Salo Kawoteth gelanayssafe gaamellay narpe lukkora aadhdhethi kawuyana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Hessa siyida iza kaallizayti daro qoppidi “Histin ooni attanas dandayizee?” giidi Yesusa oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesusikka ista xeelidi “Hayssi asa achchan dandayettenna; Xoossa achchan gidikko wurikka dandayettes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Phexroosi izas zaaridi “Nu wursikka aggidi nena kaallidos; histin ha7i nu ay demmaneshaa?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesusikka istas “Ta intes tumu gays; Asa Nay buro yaana ooratha alamen ba boncho alga bolla uttiza wode inte tana kaallidayti tammanne nam7u alga bolla uttidi tammanne nam7u Isra7eele nayta bolla pirdana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ta suntha gish giidi ba keeththe, ba ishata, ba micheta, ba aawa, ba aayonne ba nayta, woykko ba biitta aggiza asi wuri xeetu kushe dakko ekkana; medhina de7okka laattana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Gido attin daro sinthe gidida asati guye gidana; daro guyen diza asati sinthatana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Salo Kawotethi ba woyne atakilte giddon ooththiza oosanchata qaxaranas maaladora kezida issi atakiltey diza gadadde misatawus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Issi gallasa damoza gidizaz hasayettidi giigidappe guye oosanchata woyne atakilte ooso oythides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Maalado heedzdzu saaten kezidi oosoy baynda mela giyay eqqizason eqqida hara asata demmides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘Inte biidi ta woyne giddon ooththite; ta intes bessiza miishe immana’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Istika bida. Qasseka gallassafe usuppun saateninne uddufun saate bolla kezidi hara oosanchata ooson gelthides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Omarsa wode tammanne issi saate gidiza wode kezidi coo eqqidayta harata demmidi ‘Inte kumeththa gallas oosoy baynda aazas hayssan eqqetii?’ giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Istika ‘Nuna ooththisiza asi dhayida gish eqqidos’ gida. Izikka ista ‘Inteka biidi ta woyne atakilte giddon ooththite’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Gadey qammishin woyne atakilteza goday oosanchata alafezas ‘Guyeppe yidaytappe oykkada koyro yidayta gakkanaas diza oosanchata wursi xeeygada ista ooso waaga qanxa’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tammanne issintha saate bolla ooson gelidayti yiidi issoy issoy kumeththa gallasa waaga ekkida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","“Koyro ooson gelidayti yishe ba woznara hinkoytappe bollara daro demmana gi qoppishin istaska hinkoytara gina immides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Miisha ekkishe qanxizade bolla ‘Hayti wursethan ooson gelidi issi saate xalala ooththidayti kumeththa gallas ooson duuridinne awan xuugetidi pe7ida nuussara wosta istas issi gina qanxay?’ gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","14","“Izikka istafe issades ‘Ta jalawu! Nena qohabeekke; issi gallassas gidiza damozan ooththanas tanara giigabeykii? Ha7i hehi ne gisha ekkada ba; nees immidayssa mala wursethan yidayssaska ta immana koyays. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Histin ta miishan ta dosidazi ooththanas danda7ikkinaa? Woykko ta kiya gididayssi nena qanatisizee?’ ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Guyen dizayti sinthe, sinthen dizayti guye aadhdhana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesusi Yerusalame bishe bana kaalliza tammanne nam7ata dumma shaakki ekkidi ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Hiya nuni Yerusalame baana goos; Asa Nay Qeeseta halaqasinne Muse woga tamarsizaytas aadhdhi imettana; istika izi hayqqana mala iza bolla pirdana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Iza bolla qidhi ka7anassinne garafana mala, wodhana malakka deretas aaththi immana; heedzdzantho gallas izikka hayqoppe dendana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Hessafekka Zabidoosa nayta aaya ba naytara Yesusakko shiiqada iza sinthan gulbatada Yesusi izis issi miish ooththana mala woossadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Izikka izo “Ay koyay?” gides; izakka “Hayti ta naa nam7ati ne kawoteththan issoy ne ushachara, issoy ne hadirsara uttana mala ooththarki!” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesusikka zaaridi “Inte woossizaz erekketa; tani uyiza xu7a inte uyana dandayanee?” gides. Istika “Ee dandayoos” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Izikka “Ta xu7appe tumu inte uyanashin ta ushachaninne ta hadirsan utethi ta Aaway giigissidadentas attin tani immizaz deenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tammati hessa siydi nam7u ishata bolla hanqettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesusi ista issi bolla xeygidi “Ayzaabe halaqati ba haariza dere bolla godatizayssa mala godateththi dizayti wolqara haarizayssa inte ereeta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Inte giddon hessa mala hananas bessenna; intefe gita gidana koyizadey intes ooththizade gido. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Intefe bolla gidanas koyizadey intefe gars gido. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Asa Nay asay izas ooththana mala gidonta asas ooththanassinne ba shempo darota gish aaththi immanas yides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesusi bana kaallizaytara Iyarkofe kezidi bishin daro derey iza kaallides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Heen ayfey qooqida nam7u asati oge duunan utti deettes. Yesusi aadhdhi bizayssa siydi “Godo! Dawute nawu nuna maara!” giidi waassida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Derezi “Hayzite!” giidi hanqides; gido attin isti darsi waassishe “Godo! Dawute nawu nuna maara!” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesusikka eqqidi ista xeygidi “Ta intes ay ooththana mala koyetii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Istika “Nu ayfey xeellana mala koyoos” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesusi istas mishettidi ista ayfetakka ba kushera boshechin heerakka xeelidi iza kaallida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Isti Yerusalame matan Dabrazayte zuma bolla diza Betefaage geetettizaso gakkida mala Yesusi bana kaallizaytappe nam7ata kiittides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Hanno inte matan diza gutayo biidi inte he gakkida mala issi hare dizaara ba gutteyra qasheta dishin inte demmana. Birshidi ha taakko ekki yiite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Oonikka intena ‘Ays hayssatho ooththetii?’ giikko ‘Goday ista koyees’ giite; intena oychizadey heerakka yeddana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","“Hayssika hanizay kase naben Xiyoonis hizgite ‘Hekko! Ne kawoy ashke gididi hareyonne harey gutteyo togidi neekko yaana’ geetettidayssi poletanassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Iza kaallizayti Yesusi istas yootida mala ooththida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Hareyo izi gutteyra ehidi ba may7o ista bolla woththin izikka hareta toggides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Deraappe dariza baggay ba may7o oge bolla micides; bagga asay mitha bonco duuththi duuththi oge bolla aaththi aaththi yeggides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Izappe sinthara biza dereynne guyera kaalliza dereyka ba qaala dhoqu histidi “Hoosana! Dawute nay galattetto! Goda sunthan yiday anjettidade! Xoossi galattetto!” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Izi Yerusalame gelida wode katama asay wuri “Hayssi oonee?” giidi yark yarkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Iza kaallidi yida dereyka “Hayssi Galila giddon diza Naazireteppe yida Nabe Yesusa gidenee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","13","Hessafe Yesusi Xoossa Keeththa gelidi Xoossa Keeththa kare giddon gaaththan bayzizaytanne shamizayta goodides. Miish laammizayta xaraphezatanne haraphe bayizizayta oyde shiri shiri yeggidi “ ‘Ta Keeththay Woosa Keeththe geetettes’ geetettidi xaafettides; inte qasse bonqizayta gongolo histideta” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ayfe qooqetanne tohoy silida asata Yesusakko Xoossa Keeththe ehida. Izikka ista pathides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Gido attin Qeeseta halaqatinne Muse woga tamarsizayti izi ooththida malatata beyidayssaninne guutha nayti “Woze kawo, galatay Dawute naas gido!” giidi waassizayssa siyida gish daro hanqettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Istika Yesusa “Hayti nayti gizayssa siyay?” gida; Yesusikka istas “Ee siyadis; nayta duunappenne dhammiza qeeri nayta duunan tani galata giigissadis gizaso mulerakka nababi ereketii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ista yeggi aggidi he katamappe kezidi Bitaaniya geetettizaso biidi heen aqides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesusi wontetha gallas maalado guye katama simmishin iza gafisides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Oge matan issi balase geetettiza mithi beyidi gede izikko shiiqishin hayth xalalappe attin ayfey bayndayssa beyidi “Hiyappe guye ne bolla ayfey dooppo!” giin balase mithaya heerakka meladus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yesusa kaallizayti hessa beyidinne malaletidi “Hanna balaseya waanada heerakka meladee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesusikka ista “Ta intes tumu gays; intes ammanoy diikkonne inte sidhonta aggikko balase mithay bolla hanidayssa mala xalala gidonta hayssa zuma ‘Hayssafe dhoqalletada duge abban gela’ inte gidakkokka izi gelana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Intes ammanoy diikko inte woossan oychida miish wursikka ekkana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesusi Xoossa Keeththe gelidi tamarsishin Qeeseta halaqatinne dere cimati izakko shiiqidi “Hayssa wursa oona shenen ooththay? Hayssa ooththanas shene nees ooni immidee?” giidi iza oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesusikka istas zaaridi “Takka intena issino oychays; inte taas zaarikko takka hayta ooththizayta oona shenen ooththizakkonne intes yootana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohannisa xinqatey awappe yidee? Saloppe yideyee? Asappee?” gides. Istika “Nu ‘Saloppe yides’ giikko ‘Histin aazas ammanibekketii?’ gaana giidi ba giddon issoy issoy issara zorettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Qasse nu ‘Asappe’ giikko, asay wurikka Yohannisa nabe giidi ammaniza gish nu babboos” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hessa gish Yesusas “Nu erokko” giidi zaarida. Izikka istas “Hayta ta ooththizayta oona shenen ooththizakkonne takka intes yootikke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesusi ista “Intes ay misatizee? Nam7u attuma nay diza issadey dees; izikka koyro naazakko biidi ‘Ta naazo! Hachchi gede woyne mithaso baada ooththa’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Naazi qasse ‘Biikke!’ giidinne guyeppe muuzottidi bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Nam7antho naazakka kaseyssathoka ‘Ba!’ giin naazi ‘Ero!’ giidi boonta aggagides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hayta nam7atappe aawa shene poliday awayssee?” giidi oychida. Istika “Koyro naaza!” gida. Yesusikka istas, “Ta intes tumu gays; qaraxa qanxisizaytinne laymatizayti Salo Kawotethi intefe sinthan gelana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","“Xammaqiza Yohannisi intena xillotetha oge bessanas inteko yides shin inte izi gizayssa ammanibekketa; gido attin qaraxa qanxisizaytinne laymatizayti gidikko ammanida; izi hanidayssa inte beyi simmidikka maarotethan gelidi ammanibekketa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Hara leemisokka siyite; woyne mithi tokkizasoy dizaddey he woynezas birda yuushi aaththidi woyneza ayfe gum7anas olla bokkides. Woyneza naaganas mitha bolla shako giigissides. Hessafe guye gadeza woyne mithara goyzaytas kira immidi hara dere bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Boney gakkishin woyne mithaza ayfe ekkanas ba ashkarata gadeza goyzaytakko yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Gadeza goyzayti ashkarata oykkidi issa wodhida; issa qasse shuchchan caddida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Gadaa goday kaseytappe aadhdhiza hara ashkarata yeddides. Goyzayti ha7ikka kaseyta bolla ooththidayssa malakka ista bollakka polida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Wursethan ooni erize ‘Isti iza bonchanakkonne’ giidi ba naa aaththi yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Gido attin gadaa goyzayti naaza beyida mala ‘Hayssi iza laattanayssakko! Ane haa yiite, iza wodhidi gadaa laattoos’ gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Naaza oykkidi woyney tokkettidasoppe gede kare kessidi wodhida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ero! Woyneza goday yiza wode he gadaa goyiza asata wostana intes misatizee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Istika “Heytanta iitata daro waayssi wodhidi woyney tokkettiza gadappe bessiza woyne ayfe wodera izas immiza hara gade goyzaytas kirasana” giidi izas zaarida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesusikka istas “Geeshsha Maxaafan ‘Gimbe keexxizayti iita giidi wora yeggida shuchchay keeththas maazanne bolla wodhdhiza shuch gidides; Xoossi hayssa ooththides; iza oosoykka nu ayfes malalisizaz’ geetetti xaafetidayssa nababibekketii? ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Hessa gish ta intes Xoossa Kawotethi intefe eketada ayfe ayfiza deretas imettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Hayssa shuchcha bolla kundizay meqana; shuchchay iza bolla wodhizadeykka liiqana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Qeeseta halaqatinne Farsaaweeti iza leemisoy ista gish gididayssa erida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Gido attin isti iza oykki qachonta mala asay Yesusa nabe mala xeelliza gish babbida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Qasseka Yesusi hara leemiso ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Salo Kawotethi ba naas sarge giigissida issi kawo misatawus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kawoykka diggissas yootidayta xeeyganas ba ashkarata yeddides; xeeygettidaytikka ‘Nu bookko’ gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Qasseka hara ashkarata ‘Kase istas yootidayta hekko ta sanga booratanne modhida meheta shukada diggisa giigissadis; wurikka giigettida gish sargeso haa yiite!’ giidi yootite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Xeeygettidayti gidikko iza xeeyssa wudan yeggonta aggidi issoy ba goshshaso, issoy ba zal7eso bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Hanko attidayta, ashkarati oykkidi daro waayssidi wodhida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Kawoykka hanqettidi wotadarata yeddidi ashkara wodhidayta dhayssides; ista katama xuugides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ba ashkarataka ‘Sargeza diggisey giigides; gido attin sargezaso xeeygettidayti sarges bessizayta gidibeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Gede oge bolla kezidi inte demmida as wursi ha sarge diggisses xeygite’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ashkaratikka oge bolla kezidi ba demmidayta lo7otaka iitataka wursi shiishshidi sargezaso imath kunthida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Kawoykka xeeygettida imatha beyanas so geliza wode sarge may7o may7onta as demmides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Haysso! Sarge may7o may7onta waanada hayssa gelanas dandayadii?’ gi oychin addezas zaarana qaalay dhayides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kawoykka ba ashkarata ‘Hayssa addeza tohonne kushe shiishshi qachidi heen karen diza dhuman kessi olite; heen yeehonne achcha garcech gidana.’ ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Xeeygettidayti darota; doorettidayti gidikko guuthata” gi yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Hessafe guye Farsaaweeti kezi bishe “Iza duunappe bala qaala wosti demmi oykkinoo?” giidi zorettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bana kaallizayta Herdoosa asatara izakko kiittidi “Astamare! Neni tumanchanne Xoossa oge tumappe tamarsizade gididayssanne oonaska dumma maado ooththonta wursaka issi mala ne xeellizayssa nu eroos. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nees ay misatizakkone ane nuus yootaa? Qeesares giira qanxanas bessizee? Bessenee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesusikka ista gene qofa eridi “Inteno qoodheppe qommon hanizayto tana yo7on baleththi oykkanas aazas koyetii? ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Inte giira qanxiza miisha ane tana bessite” giin istika issi dinare geetettiza miish izas ehida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Izikka “Hayssa miisha bolla diza misileynne xaafettida sunthay oonayssee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Istika izas “Qeesareyssa” gida. Izikka istas zaaridi “Qeesareyssa Qeesares, Xoossayssa Xoossas immite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hessa siyida wode malaletidinne iza aggi bida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","“Hayqqidaytas dendoy baawa” giidi ammaniza Saduqaaweti he gallas Yesusakko shiiqidi, ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Astamaare! Musey ‘Issadey macho ekkidi naa yelonta hayqqikko iza ishay hayqqidayssa macho ekkidi ba isha laattiza naa izas yelo’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nu achchan laapun ishati deettes shin koyro ishay macho ekkidi naa yelonta hayqqida gish kaalo ishay iza macheyo ekides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nam7antho ishayka hayqqida ishaatho naa yelonta hayqqides; hessathoka hanishin macasaya laapuntha isha geladus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Wursethan macasaya hayqqadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Hessa gish laapunati wurikka izo ekkida shin hayqoppe dentha gallas macasaya laapuntappe awayssa macho gidanee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesusikka istas zaaridi “Geeshsha Maxaafatanne Xoossa wolqa inte eronta gish baletteta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Hayqoppe dendidappe guye asay salo kiitanchata mala gidana attin eketettenanne geletenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Hayqqidayta dentha gish gidikko Xoossi ‘Tani Abrahaame Xoossa, Yisaaqa Xoossa, Yaqoobe Xoossa’ giidi intes yootoyssa nababibekketii? Xoossi paxata Xoossa attin hayqethata Xoosse gidenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Dereyka hessa siydi iza timirtezan malalettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesusi Saduqaaweta co7u histidayssa siydi Farsaaweeti issi bolla shiiqettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Ista giddofe issi Muse woga lo7ethi erizadey Yesusa paaccanaas koydi “Aastamare! Muse wogata giddon ubbafe aadhdhizay awayssee?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Izikka zaaridi “ ‘Ne Goda Xoossa ne kumeththa woznappe, ne kumeththa shempofe, ne kumeththa qofappe dosa.’ ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hayssi koyronne ubbafe aadhdhiza azazo. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nam7anthoykka iza misatees, hessika ‘Ne shooro ne hu7e mala dosa’ gizayssa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Muse wogaynne nabeta timirtey wurikka hayta nam7u azazotan qashettes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farsaaweeti issi bolla shiiqeti dishin Yesusi ista, ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Kirstoosa gish inte ay geetii? Izi oona naa?” gi oychides; Istika izas zaaridi “Izi Dawute naa” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Izikka istas “Histin Dawutey Xillo Ayana wolqan ‘Xoossay ta Goda’ giidi waani xeygidee? ‘Ta ne morketa ne toho giddon gulbatissana gakkanaas ne ta ushachan utta!’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Hessa gish Dawutey iza ‘Ta Goda’ giidi xeygikko waanidi izas naa gidana dandayizee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Izas issi qaala zaarana dandayida asi woykko he gallassafe simmin iza oysho oychana xalida asi oonikka bettibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Qasseka Yesusi derezassinne bana kaallizaytas, ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Muse woga tamarsizaytinne Farsaaweeti Muse wombara bolla uttida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Hessa gish isti intes yootizayssa wursi ooththitenne naagite; gido attin isti duunan haasayizayssa mala ooson bessonta gish inte ista ooso kaallofte. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","“Hessathoka asi tookkanas dandayonta deexo tooho qachidi asa hashe bolla wothettes shin baassi gidikko biradhdhe xeeranka bochettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ista ooso wursi asi beyana mala ooththetes; ba ashenkitabe Geeshsha Maxaafa giddofa xaafi ekkida issi issi xiqiseta kitabe sikidi liiphe bolla woykko kushen qachizaz ooththetes. Ba may7o macara adussettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Diggisay dizason boncho so Ayhuda Woosa Keeththanka sinthara uttana doossettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Hessathoka giya giddon saro geetettanassinne asay ista ‘Astamaare!’ gaana mala koyettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Inte gidikko ‘Astamaare’ geetetti xeeygetofte. Inte Astamarey issa xalala gidishin inte wurikka issoy issas ishanta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Salon intes issi Aaway xalala diza gish biitta bolla oonakka ‘Aawawu!’ giidi xeeygoppite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Inte astamarey issi Kirstoosa xalla gidida gish inte ‘Astamareto!’ geetetofte. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Inte giddon ubbafe aadhdhizaddey intes ooththizade gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Bana dhoqisizadey kawuyana; bana kawushshizadey bonchettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Inteno qoodheppe qommon hanizayto, Muse woga tamarsizayto, inteno Farsaaweeto! Asay Xoossa kawoteth gelonta mala asa bolla inte penge gordiza gish intena aayye-ana! Inte intes geleketanne gelanas koyizaytaka geltheketa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Inteno qoodheppe qommon hanizayto, Muse woga tamarsizayto, qasseka Farsaaweeto! Intes aayye-ana! Azinay baynda macasata keeththa kallosishe asa ayfe sinthan adussa woossa inte woossiza gish inte iita pirda pirdettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Inteno qoodheppe qommon hanizayto, Muse woga tamarsizayto, qasseka Farsaaweeto! Issi as Ayhuda ammanon gelthanas abba bollaranne biitta bollara yuuyi daburdinne ammanthida asa intefe nam7u kushe aaththidi Gaanname naa inte kessiza gish intena aayye-ana! ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Inteno! Intes qooqi uttidi harata kaalethizayto! Intes aayye-ana! ‘Oonikka Xoossa Keeththan caaqikko aykkoy ba’ gido attin ‘Xoossa Keeththa giddon diza worqan caaqikko caaqo gomey gakkana’ geeta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Inteno qooqidayto! Balettidayto, worqafenne worqa dummasida Xoossa Keeththafe awayssi aadhdhizee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Hessathoka ‘Oonikka yarsho yarshizaso bolla caaqikko aykkoy baawa; shin yarshizason diza yarsho bolla caaqikko caaqoy gomees’ geeta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Inteno qooqeto! Yarshoppenne yarsho shiishshizasoppe awaysse aadhdhizay? ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Hessa gish yarsho shiishshizaso bolla caaqizadey yarshosoza bollanne yarshizaso bolla diza ubba miishan caaqees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Hessathoka Xoossa Keeththaza bolla caaqiday Xoossa Keeththaninne iza giddon aqizaysan caaqees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Salon caaqizadeykka Xoossa alganinne alga bolla uttidayssan caaqqees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Inteno qoodheppe qommon hanizayto, Muse woga tamarsizayto, Farsaaweeto! Intena aayye ana! Aasutappe, aanugappenne katkal7afe tammafe issino immeeta shin wogatappe waannatizayta heytikka tuma pirda, maarotethinne ammanetteth gidikko kadhideta. Heyta aggonta dishe haytanta inte ooththanas intes bessees shin aggideta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Inteno qooqi uttidi kaalethizayto! Uu7e gaccidi uyeeta shin gaamella muume mitteeta! ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Inteno qoodheppe qommon hanizayto, Muse woga tamarsizaytonne Farsaaweeto! Intes aayye-ana! Xu7assinne keres bolla bagga qucceeta shin iza giddon dizayssa inte bonqaninne uuzetethan shiishshideta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Neno qooqe Farsaawezo! Koyrottada xu7assinne keres giddo bagga geeshsha! Hessafe guye kare baggay geesh gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Inteno qoodheppe qommon hanizayto, Muse woga tamarsizayto, qasse Farsaaweeto! Bolla baggay noorara meeshettidi lo7izayti giddoy gidikko hayqqidayta meqethinne daro tunanetethan kumida duufota misatiza gish intena aayye-ana! ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Inteka bolla baggara asas xillo asata misateta; inte giddoy gidikko cimoninne iitatethan kumides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Inteno duunan cimmizayto! Muse woga astamareto, qasseka Farsaaweeto! Intes aayye-ana! Nabeta duufo lo7ethizayto, xillo asata duufo hawultera giigissizayto! ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nu aawati nabeta wodhiza wode nu dizakko istara zuppetokkokko shin, ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","inte nabeta wodhida asata nayta gididayssa inte duunara interka inte inte bolla markattetta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Histikko oosettidi poletonta oge bolla diza inte aawata ooso polite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Inteno dukkiza iita shoosha nayto! Gaanname tama pirdafe inte waani attanee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Hessa gish nabetanne eranchata astamaretaka ta intes yeddana. Inte ista giddofe issi issi asata wodhana. Baggayta inte kaqqana; baggayta inte Ayhuda Woosa Keeththan garafananne ha katamappe hara inte gooddana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hessa gish xillo Aabeele suuthafe ha simmin Xoossa Keeththaninne yarsho yarshizaso giddon inte wodhida Barakiyo naa Zakaraasa sutha gakkanaas biitta bolla gukkida xillota sutha ubbas inte oyshettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ta intes tumu gays; kase aadhdhidaa yo7o ubbas hayssi ha yelettay oyshettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Hanne Yerusalame! Nabeta wodhizare! Neekko kiitettidayta shuchchara caddizare! Hanne Yerusaleme kutto aaya ba ciyeta ba qefe giddo shiishshiza mala ta ne nayta shiishshanaas aapun wode koyadinashin ne gidikko koyabakka. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Hekko inte keeththi kays gidi attana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ta intes tumu gays; inte Goda sunthan yizadey anjettidade gaana wodey gakkanaas nam7antho tana beyekketa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesusi Xoossa Keeththafe kezi bishin iza kaallizayti Xoossa Keeththazi shuchchan keexxettidayssa bessana koydi Yesusakko shiiqida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Izikka istas “Hayssa wursi xeelletii? Ta intes tumu gays; hayssi inte beyiza issoy issa bolla diza shuchchay laalettonta issi shuchchikka hayssatho deenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Izi Dabrazayte geetettiza zuma bolla utti dishin iza kaallizayti xalala izakko shiiqidi “Ane nuus yoota; hayssi ne gizayssi ayde hananee? Ne yussassinne wode wursethas malatay aazee?” gi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesusikka zaaridi “Oonikka intena baleththonta mala naagettite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Buro daroti ‘Ta Kirstoosa’ gishe ta sunthan yaana; darotaka baleththana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Olanne ola gish haasayettiza wore inte siyana. Ha yo7oti wurikka wolqara polettana shin wursethi buro gidida gish inte hayssan daggamonta mala naagettite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Derey dere bolla, kawoy kawo bolla dendana; dumma dumma deren koshaynne biitta qaathi hanana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Hessi wurikka miixas leesso mala. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","He wode intena waayes aaththi immana; intena wodhana; ta suntha geedon dere ubban inte ixettidayta gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","“He wode daro asay dhuphettana; issoy issa aaththi aaththi immananne ba giddon ixettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Daro wordo nabeti dendananne darota baleththana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Iitatethi dariza gish darotappe siiqoy irxana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wurseth gakkanaas minnidadey attana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Dere ubbas marka gidana mala hayssi kawoteththa Mishiraachcho qaalay kumeththa alamen yootettana; hessafe guye wursethi yaana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Hessa gish nabe Daanelan yootettidayssa mala ‘Harassiza tunatethi’ anjettidason eqqidayssa inte beyiza wode nababizadey woznan wotho. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","He wode Yuhudan dizayti pude zuma bolla gangetto. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Keeththa kaara bolla dizaddey oonikka ba miish keeththafe kessana giidi duge wodhdhofo. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Gade giddon dizaddey oonikka ba may7o ekkana giidi so simmofo. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","He gallasatan qanthara diza macasatassinne naa dhanthiza aayetas aayye-ana! ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Hessa gish inte gangoy balgo woykko Sambata gallas gidonta mala woossite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","He wode alamey medhetosappe hachchi gakkanaas hani eronta miishi sinthafekka iza misatizay baynda wolqama metoy hanana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","He gallassati qaammontakko asho may7ida asi wuri attenna shin doorettidayta gish he gallassati qaammana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“He wode oonikka ‘Hekko Kirstoosi hayssan dees!’ Woykko ‘Hessan dees’ gizade ammanoppite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Wordo Kirstoosanne wordo nabeti buro dendidi istas dandayettikko doorettidayta baleththanas giidi wolqama malatatanne kase oosetti eronta miish ooththana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","“Hekko hayssa ta intes kaseta yootays. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Hessa gish ‘Hekko hirki bazzon dees’ giidi intes yootikko he kezoppite; ‘Hekko ilpinen dees’ giikko ammanoppite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Wolqanthi awa arshey mokizasora wolqamidi awa arshey wullizaso gakkanaas poo7izayssa mala Asa Naa yuussaykka hessatho hanana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ahay dizaso anko kafoy shiiqqees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Heerakka he iita meto gallassatappe guye awa arshey dhumana; aginay ba poo7o diggana; xoolinteti saloppe qoqofettana; salo wolqamatikka qaaxana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“He wode asa naa malatay salo bolla bettanna. Biitta bolla diza derey wuri yeekkana; Asa Naykka salo shaara bolla daro wolqaranne gita bonchora yishin asay beyana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kiitanchataka daro wolqama xurumba giirissara yeddana. Istika doorettidayta oyddu ma7izeneppe salos ha bagga gaxappe he gaxa bagga gaxa gakkanaas wursi issi so shiishana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Balase geetettiza mithafe hayssa tamarite; balase mithays unquloy cililiza wode iza hayth kessishin boney matidayssa inte ereeta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hessatho hayta inte beyiza wode izi penge matidayssa inte erana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ta tumu gays; hayssi wuri polettana gakkanaas ha yelettay aadhdhenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Saloynne sa7ay aadhdhana shin ta qaalay gidikko mulekka aadhdhenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“He gallassayonne he saateyo Aawappe attin salo kiitanchata gidinka Naaza gidinka oonikka erenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nohe wode hanidayssa mala Asa Naa yuussi hessa mala gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Dhayssiza haaththafe kase Nohey markaben geliza gallas gakkanaas asay mishenne uyishe, ekkishenne gelishe gam7ides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","He wodey gakkanaas aazi hananakkonne asay erontanne qopponta bashsha haaththay yiidi mitidayssa mala ta Asa Nay yiza wodeykka hessatho hanana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“He wode nam7u asati issife goshshan pe7ana shin istafe issadey ekettana; issadey attana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nam7u macasati woxan issife gaaccana shin istafe issineya ekettana issineya attana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Histikko inte Goday yaana gallasa inte eronta gish beeggidi naagite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Hayssa woznan woththite; kaysoy qammafe aafuntha saate bolla yaanakkonne erizakko iza miish kaysoy ekkonta mala keeththa aaway beeggidi naagana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Asa Naykka inte qopponta saate bolla yaana; inteka hessatho giigettidayta gidite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Wodera so asa quma mizana mala goday ba keeththa asa bolla shuumida ammanettiza cinca oosanchay oonee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Keeththa aaway simmidi yiza wode izas immida hadara ooththi polishe beettida oosanchay anjettidayssa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ta intes tumu gays; goday iza ba haarida ubba bolla shuumees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Gido attin he oosanchay iita gididi ‘Ta goday gam7idi yaana’ gi qoppidi, ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","dendi hanko oosanchata wadha oykikko mathottizaytara miikkonne uyikko, ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","izi qopponta gallassaninne saaten iza goday yiidi, ");
INSERT INTO gmvRNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","iza qanxethi kaa7ana; iza exxa qoodheppe qommon hanizaytara ooththana. Henka yeehoynne achcha garcechi hanana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“He wode Salo Kawotethi mishira mokkanas xompe oykkidi kezida tammu gela7ota misatawus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","He tammatappe ichashu gela7oti eeyata, hanko ichashati qasse cincata. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Eeyati kuraze xompe oykkida shin wurikko gujana hara naage lamba oykkibetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Cincati gidikko ba kurazezara wurikko gujana lamba hara xarmusen oykkida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Machiyo ekkana mishiray yoonta gam7in dhiskoy deexxin asay wurikka dhiskides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Leela gidoth gidishin ‘Mishirazi yees! Kezidi mokki ekkite!’ giza xeeyssa qaalay siyettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Hessa wode gela7oti wurikka dendidi ba xompe xompe oysethonne giigeteth oykkida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Eeyati cincata ‘Nu xompey to7ana giza gish inte lambappe nuus immite’ gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Cinca gela7oti istas zaaridi ‘Nuus diza lambay nuussaranne intessara gidonta gish biidi lamba bayzizaytappe intes shammite’ gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Isti lamba shammana bi kichchin mishirazi gakki wodhdhides. Kase giigeti uttida gela7oti bulachaso izara gelida; kareykka gordettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Guuth gam7ishe hanko gela7oti yiidi ‘Godo! Godo! Kare nuus doya!’ gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Izikka zaaridi ‘Ta intes tumu gays; ta intena erikke!’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Hessa gish yaana gallasa woykko saateza inte eronta gish giigettidi naagite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Xoossa Kawotethi baassi dizazi wursi ba ashkaratas hadara immidi hara dere baana dendida issi as misatees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ashkaratas issas issas ista wolqa mala giigissidi issas ichashu shi bira, issas nam7u shi bira, hankoyssas qasse issi shi bira immidi bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ichashu shi bira ekkida addezi heerakka miishan zal7e oykkidi hara ichashu shi bira wodhisides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Qasseka nam7u shi bira ekkidayssi hara nam7u shi bira wodhisides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Issi shi bira ekkidayssi ba goda bira biittan moogidi qottides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ashkarata goday ba bidason daro wode gam7i simmidi miisha istara sala7ettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ichashu shi bira ekkida ashkaray hara ichashu shi bira wodhisidayssa ekki yiidi ‘Godo! Ne taas ichashu shi bira immadasa shin hekko hayssa ta hara ichashu shi bira wodhisadis’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Iza godayka ‘Lo7o ooththadasa; neno lo7o ammanettida ashkarazo! Ne guutha miishan ammanettida as gidida gish ta nena daro miisha bolla shuumana; gede ne goda ufayssaso gela’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Hessathoka nam7u shi bira ekkidayssi godazakko shiiqidi ‘Godo! Ne taas nam7u shi bira immadasa shin hekko hara nam7u shi bira wodhisadis’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Godazikka ‘Lo7ethadassa; haysso lo7onne taas ammanettida ashkarazo! Neni guuthan ammanettidade gidida gish ta nena daro miisha bolla shuumays; gede ne Goda ufayssaso gela’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Issi shi bira ekkida ashkaray shiiqidi ‘Godo! Neni zerontasoppe maxizadenne laallontasoppe shiishshiza menxe iita as gididayssa ta erays. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Hessa gish ta babbada biitta bokkada ne bira bookkida ollan moogada qottadis; ne miish hessa beya!’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Iza goday zaaridi ‘Haysso iita azalla ashkarazo! Tani zerontasoppe maxizade laallontasoppe shiishshizade gididayssa ne eray? ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Histin ta simma yiza wode ta miisha yelora ta ekkana mala tirpisi zal7iza asas ne immanas besseeseshin’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“ ‘Ane ha7i izappe shi bira ekkidi tammu shi biray dizaddes immite. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Dizaddes gujettananne dari dari baana; bayndadefe he diza guuththayakka izappe eketaychana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Hayssa go7ay baynda ashkara gede yeekkizasonne achchey garcettizaso hen karen diza dhuman kessi yeggite’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Asa Nay ba kiitanchata ubbara bonchon yiza wode ba boncho alga bolla uttana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Derey wuri iza sinthi shiiqana; izikka mehe heemmizadey deyshi dorsafe qori shaakkiza mala asa issa issafe qori shaakana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Dorsata izas ushacha baggara, deyshata hadirsa baggara essana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","He wode kawoy ushacha baggara dizayta ‘Inteno! Ta Aaway intena anjidayti haa yiite! Alamey medhetosappe intes giigetida kawoteththa laattite! gaana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gaasoyka tani gafin tana mizideta; ta saametin tana ushshideta; ta imatha gidada yiin tana mokki ekkideta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ta kallottin tana mayzideta; ta sakettin tana hargisideta; ta qashetin tana oychideta’ gaana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Xillotikka zaaridi ‘Godo! Ne gafin nu nena ayde mizidonii? Woykko ne saamotin ayde beyidi nu nena ushshidonii? ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nu ayde nena beyidi imathateth mokkidonii? Woykko ayde ne kallottin beyidi nena mayzidonii? ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Hessathoka ne saketin woykko qashetin ayde beyidi nena oychidonii?’ gaana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kawoykka zaaridi ‘Ta intes tumu gays; hayta laafa gidida ta ishatappe issades ooththidayssi inte taas ooththida mala’ gaana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Qasseka hadirsa baggara dizaytas; ‘Inteno qangetidayto! Taappe shaaketidi Dabulossassinne iza kiitanchatas giigetida merna taman biite gaana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gaasoyka ta gafin tana mizibeekketa; ta saamotin tana ushshibeekketa; ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","tana imathateth mokibeekketa; ta kallottin tana mayzibeeketa; ta sakettininne qashettin tana oychibeekketa’ gaana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Istika zaaridi ‘Godo, ne gafin woykko ne saamotin woykko ne imath gidin woykko ne kallottininne ne saketin woykko ne qashetin nu nena beyidi ayde nees gakkibekkonii?’ gaana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“He wode izikka istas zaaridi ‘Ta intes tumu gays; hanta laafa ta ishatappe issades inte ooththonta aggidayssi taas inte ooththonta aggida mala’ gaana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Heyti gede merna pirdan baana; xilloti gidikko merna de7okko baana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Yesusi hessa haasayi wursidappe guye bana kaallizaytas “Nam7u gallassafe guye Paaziga gididayssa ereetii? Asa Nay kaqettanas aadhdhi imettana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","4","Hessafe guye Qeeseta halaqatinne dere cimati Qayaafa geetettiza Qeeseta halaqa gibben shiiqidi hiillara Yesusa oythidi wodhisanas maqettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Gido attin “Asa giddon ooshi dendonta mala ba7aale gallas gidoppo” giidi qachida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesusi Bitaaniyan inchiracha hargera diza Simoona geetettizade soon dishin, ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","issi macassi dizaara waagay keehi al7o gidida albasxiroose geetettiza shitto bilqaaxe kumeth oykkada Yesusakko shiiqada izi maaddan uttidishin iza hu7e bolla shittoza guussadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Iza kaallizayti “Hessa beyidi hayssi aazas mela morettizee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Shittozi daro waagas bayzettidi miishay manqotas imettizakkochii?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesusi hessa eridi “Hanno macasayo aazas waayssetii? Iza taas lo7o ooththadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Manqoti ubba wode intenara deettes; ta gidikko ubba wode intenara diikke gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Iza shittoza ta bolla gussidayssi tana moogos giigissanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ta intes tumu gays; hayssi Mishiraachcho qaalay sabakettiza alame yuushon awanka iza ooththidayssi izo qofisizaz gididi hasayettana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Hessafe guye tammanne nam7atappe issoy Asqoroonto Yuhuda geetettizayssi Qeeseta halaqatakko biidi, ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Ta intes iza aaththa immikko inte taas ay immanee?” gides. Istika izas heedzdzu tammu bira iza kushen tayibi immida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","He gallassafe simmidi Yuhuday Yesusa istas aaththi immanas inje wode naagishe gam7ides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Uketha ba7aale geetettiza ba7aale gallas iza kaallizayti Yesusakko shiiqidi “Ne Paaziga maanaso awan giigissana mala koyay?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Izikka istas zaaridi gede katama biidi ebelo geetettiza as “Astamarey ‘Ta wodey matida gish tana kaallizaytara Paaziga ta ne keeththan bonchana gides’ giidi yootite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Iza kaallizaytikka Yesusi ista azazida mala Paaziga kawo giigissida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Gadey omarsishin Yesusi tammanne nam7atara maaddan uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Isti muussan dishin izi istas “Ta tumu gays; intefe issoy aaththi immana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Istika keehi muuzottidi taran taran “Godo taneshaa?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Izikka zaaridi “Tana aaththi immanaddey keren tanara kushe yeddizade. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Iza gish kase xaafettidayssa mala Asa Nay baana; gido attin Asa Naa aaththi immizades aayye-ana! Hessadey yeletonta attidakko izas lo7okkoshin” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Iza aaththi immana Yuhuday “Astamaare! Taneshaa?” gides. Izikka “Ee, ne gida mala” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Isti muussan dishin Yesusi miza qumappe ekkidi anjides. Menthidinne bana kaallizaytas immidi “Heyite miite; hayssi ta ashokko” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Qasseka ushsha denthidi galatidinne bana kaallizaytas immidi “Wurikka hayssafe uyite; ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","daro asa nagarappe maarana gukkiza ta ooratha caaqo suuthay hayssa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ta intes gizay ta Aawa Kawoteththan ta intenara ooratha woynen ushshaza uyana gakkanaas hayssafe sinthan hayssa woyne ushsha intenara uyikke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mazamure yexidappe guye pude Dabrazayte geetettiza zuma bolla kezida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesusi istas “Inte wuri hachchi omarsi tanan dhuphettidi tana yeggi baana; ‘Heemmizayssa ta shocana; mehetinne laalettana’ geetettidi kase xaafettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Gido attin tani dendidappe guye intefe sinthatada gede Galila baana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Phexroosi zaaridi “Hankoyti wuri ne geedon dhuphetikkokka tani mulekka dhuphetikke!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesusikka izas zaaridi “Tumu gays; hachchi qamma kuttoy waassonta kasetada heedzdzuto ne tana kadana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Phexroosi qasse “Nenara ta hayqqana koshikkokka mulekka ta nena kadikke!” gides. Yesusa kaalliza hankoytikka kumeth izayssathoka gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Hessafe guye Yesusi bana kaallizaytara gede Getesemaane geetettizaso bides. Istaka “He baada ta woossishin inte hayssan uttishiite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Phexroosara Zabidoosa nayta nam7ata banara ekki biidi muuzotethinne daro qofo oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hessafekka “Ta shempoya hayqqana gakkanaas daro muuzotadus; tanara minnidi hannin takkite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Istafe guuth gede haakki bi gupandi “Ta Aawawu! Nees dandayettikko hayssi metoy taappe aadhdho; gido attin tani koyda mala gidonta neni koyda mala hano” gi woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Hessafe simmidi bana kaallizaytakko yiidi isti dhiskishin demmides. Phexroosakka “Hayto asato! Inte tanara issi saatekkone minnanas xoonidee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Paacen inte gelonta mala minnidi woossite; ayanay giigettides shin ashoy gidikko daburancha” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Qasseka nam7antho biidi “Ta Aawawu! Hayssa uyanasi taas attonta miish gidikko ne sheney poletto” giidi woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Qasseka izi yishin ista ayfen dhiskoy deexida gish ichchidayta beyides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ista aggidi qasseka biidi heedzdzantho kase woossida qaala zaari woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Hessafe bana kaallizaytakko simmidi “Ha7ikka shempidi dhiskidetii? Hekko ha7i saatey matides; Asa Nay nagaranchata kushen aadhdhi imettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Dendite ane boos! Tana aaththi immizadey yuussa bolla dees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Izi haasayishin tammanne nam7atappe issoy Yuhuday yides. Qeeseta halaqatinne dere cimati yeddida daro asay tooranne durqa oykkidi Yuhudara issife dees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yuhudaykka “Ta yeerizadey iza gidida gish oykkite” giidi kase yooti woththides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Siti gi Yesusakko biidi “Astamaare! Saro” gishe Yesusa yeerides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesusikka “Ta lagge! Ne yida qofa pola” gides. Heerakka asay shiiqetidi Yesusa oykkidi qachides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yesusara dizaytappe issoy giththa mashsha shoddidi Qeeseta halaqaza ashkara hayth qanxides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesusikka “Ane ne mashsha koohon zaara geltha; mashsha shoddizayti mashshan dhayana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Koshshikko tani ta Aawa oychizakko daro shiyen qoodettiza oliza kiitancha taas yeddonta aggana misatizee? ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Hessatho ooththikko qasse Geeshsha Maxaafatan hanana geetettidayssi waani poletanee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","He wode Yesusi asa “Panga oykkiza asatho mashshanne durqa ekkidi tana oykkana yidetii? Wontin wontin Xoossa Keeththan uttada ta tamarsishin kase oykkibeekketa shin. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Gido attin hayssi wurikka hanidayssi kase nabeti Geeshsha Maxaafatan yootidayssi poletanassa” gides. He wode Yesusa kaallizayti iza yeggidi dhayida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","He wode Yesusa oykkidi asati Muse woga astamaretinne dere cimati issife shiiqidason Qeeseta halaqa Qayaafakko efida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Gido attin Phexroosi Qeeseta halaqa gibbe gakkanaas hahora Yesusa kaallides. Gibbe giddo gelidi hanizayssa wurseth beyanas, gibbe naagizaytara uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","He wode Qeeseta halaqatinne Ayhudata duulatay kumeth Yesusa wodhisanas wordo marka koyides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Wordo markati daroti shiiqikkokka bessiza markateth demmibeetenna; gido attin guyeppe nam7u as dayti shiiqidi “Hayssi addezi ‘Ta Xoossa Keeththa laallada heedzdzu gallassara zaarada keexana dandayays’ gides” giidi markattida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Hessa siyida Qeeseta halaqay utethafe dendi eqqidi “Hayti asati ne bolla markattizayssas aykkokka zaarikii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesusikka co7u gides. Qeeseta halaqay “Ta nena de7o Xoossa sunthan oychays! Neni Kirstoosa, Xoossa naa gidikko taas yoota!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesusikka “Ne goyssakka mala; gido attin intes ubbas ta yootizay sinthafe Asa Nay Wolqamaza ushachan uttidi salo shaarara yiza wode inte beyana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","He wode Qeeseta halaqay ba may7o daakkidi “Xoossa bolla cashsha qaala haasayides; nuus hayssafe aadhdhiza hara aaza marka koshshize! Xoossa bolla cashsha qaala izi haasayishin inte inte haythara siyideta. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Intes ay misatizee?” gides. Istika zaaridi izas “Hayqoy bessees” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","He wode Yesusa ayfeson cuttishe iccida; baggayti baqqishe, ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Kirstoosa! Ne nena nabe gaasashin nena baqqiday oonakkonne ane nuus yoota” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Hessafe guye Phexroosi Qeeseta halaqa gibben utti dishin issi keeththa giddon ooththiza macas dizaara izakko shiiqada “Nenikka Galila Yesusara dizadde!” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Izi qasse “Ne ay gizakkonne ta erikke!” giidi ubba asa sinthan kadides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Gibbezappe keziza penge izi bishin issi hara oosanchaya iza xeellada heen gadaan dizaytas “Hayssi addezi Naazirete Yesusara dizaddekko!” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Izikka “Ta iza erikke!” giidi nam7antho kadides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Guuth gam7ishin heen eqqida asati shiiqidi Phexroosa “Ne haasayay ne haytara dizayssa qoncisees; tumappe ne ista bagga asa” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Izikka caaqishenne amatishe hessa addeza “Ta erikke!” gides. Heerakka kuttoy waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Hessa wode Yesusi kase Phexroosas “Kuttoy waassanas ne tana heedzdzuto kadana” giidi yootida qaalay qofetin, Phexroosi kare kezidi camo yeeho yeekkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Maalado wontara Qeeseta halaqatinne dere cimati wurikka Yesusa wodhana oge zorettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yesusa qachi efidi gazhe Philaxoosas aaththi immida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","4","Iza aaththi immida Yuhudaykka Yesusa bolla pirdettidayssa beyidi “Aaththa immoonta aggarkina” giidi ba ekkida heedzdzu tammu bira Qeeseta halaqatassinne dere cimatas zaari immidi “Xillo as aaththa immida gish ta mooradis” gides. Istika “Histin nuus ay meto! Ne era ekka!” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hessa gish Yuhuday bira efidi Xoossa Keeththa giddon yeggidi kezi biidi cuuletti hayqqides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Qeeseta halaqati bira denthidi “Suutha waaga gidida gish Xoossa Keeththa miishan gujanas bessenna” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ba giddon zorettidi imath gidida asatas duufo gidana mala issi urqa miish medhiza hiillaza gade shammida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hessa gish he gadey hachchi gakkanaas suutha gade geetettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Izas waaga gidana mala “Isra7eele nayti heregida heedzdzu tammu bira qoodi ekkida. Xoossi tana azazida mala urqa medhiza hiillaza gades immida” geetettidi nabe Ermaasa duunan yootettidayssi polettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","He wode Yesusi dere haarizayssa sinth shiiqides. Dere haarizayssika “Neni Ayhuda kawoo?” giidi oychides. Yesusikka “Ne gida mala gido” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Qeeseta halaqatinne dere cimati iza mootishin Yesusi istas aynne zaaribenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","He wode Philaxoosi Yesusa “Aapun yo7on nena mootizakkonne siyikkii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Dere haarizayssi keehi malalettana gakkanaas Yesusi issi qaalakka zaaribenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Dere haarizayssas ba7aale gallas derey qasho asappe “Ebeloy nuus birshetto!” gi oychikko issade birshiza wogay dees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","He wode gene ooson erettida Barbaane geetettiza issi qasho asi dees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Derey shiiqida mala Philaxoosi “Barbaaneppenne Kirstoosa geetettiza Yesusappe ta intes oona birshana mala koyetii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Philaxoosi isti coo qanates aaththi immidayssa erishe oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Izi pirda alga bolla utti dishin iza macheya “Iza geedon hachchi tani agumora daro metotadis; hessa xillo addeza bolla ne aykkokka ooththonta mala” giza kiita Philaxoosas yeddadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Gido attin Qeeseta halaqatinne cimati istas Barbaaney birshettana malanne qasse Yesusa wodhana mala woossanas dereza qaalay gaaggana mala ooththida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Dere haarizayssi “Nam7atappe oona birshana mala koyetii?” gi oychin, isti “Barbaane birsha!” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Philaxoosikka “Histikko Kirstoosa geetettiza Yesusa wostoo?” gides. Wurikka “Kaqetto!” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Philaxoosikka ayssii? “Ay iita ooththidee?” giidi ista oychides. Istika qasse keehi waassidi “Kaqetto!” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Philaxoosi hanizayssi wurikka asay ba giddon bul7aketethafe attin hara ay go7ay bayndayssa yuushi xeelidi “Hayssa addeza suutha gomeppe ta geeshsha; hayssafe guye inte shene” giidi haaththi ehisidi dereza sinthan ba kushe mecettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Derey wuri “Iza suuthi nu bollanne nu nayta bolla gakko” giidi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","He wode Barbaane istas birshidi Yesusa garafissidappe guye kaqqana mala aaththi immides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Hessafe wotadarati Yesusa gede dere haarizayssa gibbe ekki biidi wuri shiiqidi Yesusa giddo aaththida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Iza may7o qaaridi hara zo7o may7o mayzida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Aguntha aklile xaaxidi giigissida; iza hu7e bolla woothida; shomboqo guufe ushacha kushen oythidinne iza sinthan gulbatidi “Ayhuda kawo! Intes too!” giidi iza qidhida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Iza bolla cuttida, shomboqo guufeza iza kusheppe ekkidi Yesusa hu7en zaari zaaridi shocida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Iza bolla qidhi ka7idayssafe guye qasseka zo7o may7oza qaari ekkidinne kase iza may7oza zaari mayzidi kaqqanaso ekki bida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Isti ekki bishin Qareena geetettizasoppe yida Simoona geetettizayssa demmidi masqaleza iza wolqara toossida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","34","Birshechay “Hu7e guuge” geetettiza Golgota gakkishin ciyera walakettida woyne cajje “Uya” giidi immida; gido attin izi gaanxi ekkidi uyana koybenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Iza kaqidappe guyen iza may7oza bolla saama yeggidi gishettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Heen uttidi iza naagida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","“Hayssi Ayhuda kawo Yesusa” giza mooto qaala iza hu7eppe bollara woththida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nam7u wombadetappe issoy Yesusappe ushacha baggara, issoy hadirsa baggara izara issife kaqettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Ogera aadhdhi biza asay cayishenne hu7e qaathishe “Xoossa Keeththa laallada heedzdzu gallassan hara keexana gizayso! Ane nena ashsha, ne Xoossa Naa gidikko ane masqale bollafe wodhdha” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Qeeseta halaqati dere cimatara gididi iza bolla qidhishe; ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Hara asa ashshides shin bana ashshanas dandaybenna; izi Isra7eele kawo gidikko ane ha7i masqale bollafe wodhdho; nukka iza ammanana. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Xoossan ammanettides; bana Xoossa Naa gida mala Xoossi iza dosiza gidikko ane ha7i iza asho” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Izara issife kaqettida pangatikka hessatho cashsha qaala iza bolla qoqofida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Gallassafe usuppun saateppe biidi uddufun saate gakkanaas kumeththa biittay dhumides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Uddufun saate gidishin Yesusi qaala dhoqu histidi “Eelohe! Eelohe! Lama sabaqitan” giidi waassides. Hessa guussas birsheththay “Ta Xoosso! Ta Xoosso! Tana ayssi aggadii?” guussa. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Heen gadaan eqqida asatappe issi issi asati iza waasoza siydi “Elaasa xeeygesko!” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Istafe issadey woxxi biidi zandza misatiza sefinege geetettiza miish ekkidi caalida woyne cajjen yeggi caphisidinne shomboqo geetettiza mitha xeeran qaaphidi uyana mala Yesusa duunakko shiishshides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Hanko asay qasse “Aggagite ane, Elaassi yiidi iza ashshin beyana” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesusi qasseka dhoqa qaalan waassidi shempo kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","He wode Xoossa Keeththa magalashay bolla hu7era duge simmi daakkettidi nam7u kezides; biittay qaaxides; zaallati za77ida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Duufoti doyettida; kase hayqqida Xoossa asappe daro baggay dendides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Duufoppe kezidi Yesusa denthafe guye gede geeshsha katama gelidi darota ayfen bettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mato halaqaynne izara issife Yesusa naagizayti biitta qaathanne hanidayssa wursi beyidi daro babbida. Qasse “Hayssi tumappe Xoossa Naakko!” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Galilappe yiidi Yesusa koshshizazan ooththi maadanas kaalliza daro macasati hanizayssa wursikka hahora xeellishe heen deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ista giddon Magdaleppe yida Maaramiranne, Yaqoobenne Yoosefe aayo Maaramira, qasseka Zabidoosa nayta aayeyira issife deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Gadey omarsishin Yoosefe geetettiza issi dure adde dayssi Armatiyasa geetettizasoppe yides. Izikka ba baggara Yesusa kaallizade. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Izi Philaxoosa sinthi shiiqidi Yesusa aha izas immana mala woossin Philaxoosikka izas immana mala azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yoosefey aha ekkidi geeshshiza moogo afalan xaaxides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Shuch woocidi baassi giigissida duufon efi woththidi gita shuch gendersidi duufoza gordides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Hessa wode Magdale Maaramiranne hara Maaramira duufoza ginan uttida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sambatas giigettiza wontetha gallas Qeeseta halaqatinne Farsaaweeti Philaxoosa sinth shiiqidi, ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Godo! He wordoy kase paxa dishe ‘Heedzdzu gallassafe guye ta dendana’ gida qaalay nu woznan turchu gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Hessa gish iza kaallizayti iza aha kaysoti ekkidi deres ‘Izi hayqoppe dendides’ giidi woresonta mala heedzdzantho gallas gakkanaas duufoy naagettana mala azaza; akay giikko kaseyssafe guye balay aadhdheth gidana” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Philaxoosi “Intes naagizayti deettes; biidinne intes erettida mala naagisite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Istika biidi duufoza dunna maatamen gordidi naagana zabe essida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sambatay aadhdhidappe guye saamintappe koyro gallas buro saloy zo7ishin Magdale Maaramanne hara Maarama duufoza beyana bida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Qopponta dishin gita biitta qaathi hanides; Goda kiitanchaykka saloppe wodhdhi duufakko biidi shuchcha gendersidi iza bolla uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kiitanchas medhay wolqantha poo7o mala; may7oykka shachcha mala bootha. ");
INSERT INTO gmvRNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Duufo naagizayti kiitanchazas babbidi kokkoridinne hayqeth misatida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","6","Kiitanachay macasata “Babbofte; inte kaqettida Yesusa koyizayssa ta erays; izi ha7i haan baawa; izi kase yootida mala hayqoppe dendides; ha yiidi izi ichidaso beyte. ");
INSERT INTO gmvRNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ha7ikka eleli biidi iza kaallizaytas ‘Hayqoppe dendides. Intefe kasetidi Galila bees; inte iza heen demmana’ giidi yootite. Hi7a ta intes yootadis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Macasatikka baboninne ufayssan kumidi iza kaallizaytas yootanas elelidi wothan duufoy dizaso yeggi aggidi bida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Heerakka Yesusi ista demmidi “Hayto saro” gides. Istika Yesusakko shiiqidinne iza toho oykkidi izas goynnida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesusi ista “Babbofte! Biidinne isti Galila baana mala ta ishatas yootite. Isti tana heen beyana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Macasati buro oge bolla dishin naagizaytappe guutha baggati katama biidi hanidayssa wursi Qeeseta halaqatas yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Qeeseta halaqatikka dere cimatara shiiqettidi zorettida; wotadaratas gidiza miish immidi “ ‘Nuni dhisikidaashin iza kaallizayti qammara yiidi kaysoti efida’ gite gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hayssi worey dere haarizayssa matan siyetikkokka nuni izas lo7ethi yootana; aykko iitayka inte bolla gakkonta mala nu ooththana” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wotadaratikka miisha ekkidi isti gida mala ooththida; hayssi yo7ozi hachchi gakkanaas Ayhudata achchan daroson yootettishe dees. ");
INSERT INTO gmvRNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Hessafekka Yesusa kaalliza tammanne issineti Yesusi ista bessida Galilan diza zuma bolla kezida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Yesusa beyida mala izas goynnida, ista garasafe guuxiza baggati sidhida. ");
INSERT INTO gmvRNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","20","Yesusikka bana kaallizaytakko shiiqidi “Saloninne sa7an godateththi taas imettides. Hessa gish biidi dere ubba Aawa, Naazanne Xillo Ayana sunthan xammaqishe; tana kaallizayta ooththite; ta intena azazidayssa wursi naagana mala tamarsite. Takka alame wurseth gakkanaas ta intenara days” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Xoossa Naa Yesus Kirstoosa koyro Mishiraachchoy hayssa; ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","nabe Isayaasa baggara “Hekko nees oge lo7ethanade ta kiittanade neeppe sinthara yeddana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","‘Godas oge giigissite; izi baana oge suurisidi ooththite’ gishe bazzo biittan waassiza giiris” geetetti xaafettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Hessathoka Xammaqiza Yohannisi asa xamaqishenne “Inte nagarappe simmidi xammaqettite, Xoossi inte nagara atto gaana” gi awajjishe bazzora kezi wodhdhides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yuhuda derey kumeth Yerusalame asay wuri Yohannisakko bi biidi ba nagara nagara paaxi paaxi Yordaanoose Shaafan Yohannisa kushen xammaqettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","He wode Yohannisi may7izay gaamella isikeppe oosettida may7o; qasse ba xeessan dafo gixxees. Izi miza qumay boolenne degera eessa. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Izi “Tani hokkada iza caamma qasho birshanas bessontadey, taappe aadhdhizadey taappe guyera yaana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Tani intena haaththan xammaqays izi gidikko intena Xillo Ayanan xammaqana” giidi sabakides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","He wode Yesusi Galila giddon diza Naazirete geetettiza katamaype Yordanoose Shaafa yiidi Yohannisa kushen xammaqettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesusi xammaqettidi haaththafe kezida mala saloy doyettin Xillo Ayanay iza bolla haraphe kafo misatidi wodhdhishin beyides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Qasseka “Ta dosiza Nay nena, nenan ta ufayetays” giza qaala giirisi pude saloppe seetettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Heerakka Xillo Ayanay iza duge bazzo kaalethi efides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Heen bazzonka oyddu tammu gallas gakkanaas Xala7era paacettishe gam7ides. Do7atara issife de7ides. Kiitanchatikka iza maaddida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","15","Yohannisi qasho keeth gelidayssafe guye Yesusi Xoossa Mishiraachcho qaala sabakishe gede Galila biidi “Wodey gakkides; Xoossa Kawotethi matides; nagarappe simmite, Mishiraachcho qaalan ammante” giidi sabakides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesusi Galila Abba achchara aadhdhin Simoonaynne iza isha Indiraassi mole oykkizayta gidida gish isti mole oykiza gite abban yeggishin beyides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesusi ista “Haa yite! Tana kaallite; inte mole oykki shiishshiza mala ta intena as oykkizayta ooththana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Isti heerakka mole giteza yeggi aggidi Yesusa kaallida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Guuth gede sinthe aadhdhidi Zabidoosa naa Yaqoobeynne iza isha Yohannisi wogolon uttidi mole gite giigissishin beyidinne heerakka ista xeygides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Istika ba aawa Zabidoosas qaxarettidi ooththiza asatara issife wogoloza giddon aggidi Yesusa kaalli bida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Heeppeka Qifirnahoome bida. Heerakka Yesusi Ayhudata Sambata gallas Ayhudata Woosa Keeththe gelidi tamarso oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Xaafeta mala gidonta godateththara diza asa mala izi tamarsin asay wuri iza timirtezan malalettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","He wode Ayhudata Woosa Keeththan diza tuna ayanay iza bolla diza issi addey ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Naazirete Yesusa ne nuuppe aazi koyay? Nuna dhayssana yadii? Ne oonakkonne ta nena erays; neni Xoossa geeshshaza” giidi waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesuasikka tuna ayanaza “Co7u gaada izappe keza!” giidi hanqides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tuna ayanay addeza gendersidi izi qaketishin izappe waassishe kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Derey wuri “Aso hayssi aaza palaa? Hayssi godateththara diza ooratha timirte; tuna ayanatakka azaazees; istika izas azazettetes” gi malalettishe asay ba giddon issoy issa oyshecho oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Heerakka iza ooso worey kumeth Galila yuushon diza dere ubban siyettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ayhudata Woosa Keeththafe kezida mala Yaqooberanne Yohannisara issife gede Simoonasonne Indiraasaso gelida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","He gelida mala Simoona bolloteya misha harge sakettada ichchidayssa izas yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Hessa gish Yesusi iziikko shiiqidi izi kushe oykidi denthides. Mishay aggin iza dendada ista mokkadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Awa arshey wullidappe guye gadey dhumishin asay harganchatanne daydanthi oykkida asaa wursi Yesusakko ekki yides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","He katamayin diza asay wuri keeththa karen shiiqides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Izikka dumma dumma hargen sakettidayta darota pathides. Daro daydanthataka kessides. Gido attin daydanthati Yesusi oonakkonne eriza gish daydanthati haasayana mala Yesusi koybeenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Bazzoy zo7onta malado wontara Yesusi dendidi issi asi bayndaso biidi heen woossa oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simooninne izara dizayti Yesusa koyana kezi bida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Isti iza demmidi asi wuri nena koshshan dees gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesusikka “Ta yiday tamarsanas gidida gish ane Mishiraachcho qaala yootanas matan diza gutata boos” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Hessa gish Ayhudata Woosa Keeththan geli geli sabakishenne daydanthi kessishe Galila kumeththan yuuyides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Issi inchiracha hargizadey Yesusakko shiiqidinne iza sinthan gulbatidi “Ne shene gidikko ne tana paththana dandayassa” gi woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesusikka addezas mishettidi ba kushe yeddi iza bochidinne “Ta ne paxana mala koyays; paxa!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Heerakka addeza inchiracha hargey aggin, addezi paxides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yesusikka addezas “Oonaska hayssa ne haasayonta mala naageta; gido attin baada Qeeses nena bessa. Derezas marka gidana mala ne paxxidayssas Musey azazida yarshoza shiisha” giidi keehi minth yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Gido attin addezi kezi biidi ba bida ubbason wore darsi dharcides. Hessa geedon Yesusi ay katamanka qoncera gelanas dandaybenna. Hessafe dendidayssan katamappe karera asi bayndason duus oykkides. Asay gidikko dumma dummasoppekka izakko yides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Guutha gallassafe guye “Yesusi Qifirnahoome simmidi soon dees” giza wore asay siyides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Hessa gish keeththara karera uttizasoy dhayana gakkanaas daro derey shiiqides. Izikka Xoossa qaala asas sabakides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Oyddu as dayti issi tohoy silida as tookkidi izakko ehida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Asa daroteththafe dendidayssan Yesusi dizaso gaththanas dandayonta gish Yesusi diza ginara kaara qaaridi harganchaza izi ichida halara Yesusa sinth duge woththida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesusi asata ammano beyidi tohoy silida addeza “Ta naazo! Ne nagaray atto geetettides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Heen gadaan uttida issi issi Muse woga xaafeti ba woznara hayssi addezi wosti hayssatho gizee? “Xoossa bolla cashsha qaala haasayees. Issi Xoossafe attin nagara maarana dandayizay oonee?” giidi qoppida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesusi heerakka isti ba woznan qoppidayssa ba Ayanan eridi “Inte wosti hayssatho qoppetii? ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tohoy silida addeza, ‘Ne nagaray atto geetettides’ guussafenne ‘Dendada ne hala tookkada ba guussafe awayssi matizee?’ ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Gido attin Asa Naas biitta bollan nagara maarana godateththi dizayssa inte erana mala” giidi toho sila addeza; ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Dendada ne tookketta yida hala tookkada neso ba” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Izikka dendidi asay wuri beyishin hala tookkidi bides. Heen gadaan diza asay wuri hanozan malaletidi “Kase hayssa malay hanin beybookko” giidi Xoosse galatides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Qasseka Yesusi Galila Abba lanqe bides. Daro derey izakko yiin izikka yida asa tamarsides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Izi ogera aadhdhi bishin Ilfiyoosa naa Lewey qaraxa shiishshizason uttidayssa beyidi “Haaya tana kaalla” gides. Izikka dendidi Yesusa kaallides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Hessafe guye Leewe soon kaththa maaddan utti dishin qaraxa shiishshiza daro asatinne nagaranchati izara kaalli yida gish isti Yesusaranne iza kaallizaytara issife maaddan uttida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Farsaaweeta baggafe gidida Muse woga tamarsizayti Yesusi nagaranchataranne qaraxa shiishshizaytara mishin beyidi iza kaallizayta “Qaraxa qanxissizaytaranne nagaranchatara aazas mizee?” giidi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesusikka isti gizayssa siydi “Aakimey harganchatas koshshes attin hargontaytas gidenna. Takka nagaranchata xeeyganas yadis attin xillota xeeyganas yabeekke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yohannisa kaallizaytinne Farsaaweeti xooma xoomettes. Issi issi asati Yesusakko yiidi “Yohannisa kaallizaytinne Farsaaweeta kaallizayti xoomettes shin nena kaallizayti aazas xoomettenee?” gi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesusikka istas “Mishiray istara dishin mishira laggeti xoomi erizoo? Mishiray istara dishin xoomi eretenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mishiray istafe ekettana wodey yaana. He wode isti xoomana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Gal7a may7o bolla ooratha woso woththi sikkizadey oonikka deenna; hessatho ooththikko oorathazi gal7a daakki daakki yeggees; daakkeththaykka kaseppe gede aadhdhi iitees. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hessathoka ooratha woyne cajje gal7a lukkamon woththizadey deenna. Wothiza gidikko woyne cajjezi gal7a lukkamoza dhuussees; woyne cajjezinne lukkamozi nam7ay morettetes. Hessa gish ooratha woyne cajjey daanas bessizay ooratha lukkamonna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yesusi Ayhudata Sambata gallas giste tiya giddora aadhdhishin iza kaallizayti izara issife bishe tiya xupho oykkida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farsaaweeti “Nena kaallizayti Sambata gallas diggettida miish aazas ooththizoo?” giidi Yesusa oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Izikka istas “Dawutey gafidi miza miish koyda wode izara issife dizaytara izi ooththidayssa nabebibeekketii? ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiyatarey Qeeseta halaqatethan dishin izi Xoossa Keeththe gelidi Qeeseti xalala maanas bessiza dumma kaththa baassi miidinne banara dizaytas immides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Qasseka Yesusi istas “Sambatay asas medhettides attin asi Sambatas medhetibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hessa gish ta Asa Nay Sambata goda” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Hara gallas Yesusi Ayhuda Woosa Keeththe gelides. Henka kushey silidadey dees. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yesusa mootanas gaaso koyiza asati izi Ayhudata Sambata gallas pathanakkonne giidi pathishin beyana koyda. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Izikka kushey silida addeza “Heen shiiqi uttida asa sinthan denda eqqa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Hessafe guye Yesusi asa “Sambata gallas bessizay lo7o oosoyee? Iita oosoo? Asa shempo ashoyee? Woykko shempo wodhoo?” giidi oychides. Istika co7u gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ista wozna shuchchatethan mishetidi iza giddoththidi yuuyi aadhdhi eqqida asa hanqora xeelidi addeza “Ne kusheza piddisa!” gides. Addezikka ba kushe piddisin kushezi mulera pathides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farsaaweeti kezi biidi iza wosti dhayssanakkonne Herdoosa bagga gidida asatara zoretida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesusi bana kaallizaytara abbako bides. Galilappenne Yuhudappe yida daro derey iza kaallides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Izi ooththizayssa siydi asay Yuhudappe, Yerusalameppe, Edoomeppe, Yordanoose pinthan diza deretappe qasse Xirooseppenne Sidoona heerappe izakko yides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Asay darida gish iza un7ethonta mala guutha wogolo isti giigisana mala bana kaallizayta azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Izi daro harganchata pathida gish sakoy waayssizayti wuri iza ba kushera bochchanas dafettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tuna ayanatikka Yesusa beyida mala iza sinthan kundidi “Neni Xoossa Naa” giidi waassida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Gido attin izi oonakkonne tuna ayanati qoncisonta mala keehippe hanqides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesusi pude zuma bolla kezidi ba koyizayta baako yaana mala xeygides, istika izakko yida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Izara issife gidana malanne sabakanas yeddana mala tammanne nam7ata “Hawaareta” gi sunthides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Asaappe daydanthata kessana mala istas godateththi immides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Izi sunthida tammanne nam7ata sunthi hayssafe kaallizayssa; Phexroosa geetettida Simoona, ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Bi7orinegeese woykko daada nayta geetettida Zabidoosa nayta Yaqoobenne Yohannisa, ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Indiraasa, Piliphoosa, Bartelemoosa, Matoosa, Toomaasa, Ilfiyoosa naa Yaqoobe, Tadoosa, ba baggas mishettiza Simoona, ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yesusa aaththi immida Asqoroonto Yuhuda. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Hessafe guye Yesusi issi so gelides. Izinne iza kaallizayti kath maana wodey istas dhayana gakkanaas derey qasseka dari shiiqides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Iza hanota siyida iza dabboti “Gooyonta aggenna” giidi banara ekki baanas izi dizaso gakkida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yerusalameppe yida xaafetikka “Bi7elizeebula geetettiza daydanthata halaqay iza bolla dees. Izi daydanthata kessizay daydanthata halaqa wolqanko!” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Izikka ista xeygidi leemisora “Xala7ey asappe Xala7e wosti kessanee? ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ba giddon shaakoy diza kawotethi minnanas dandayenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Issi keeththa asikka ba giddon shaaketikko eqqanaas dandayenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Hessathoka Xala7ey ba garasan issoy issara shaakettikkonne ixettikko minni eqqanaas dandayenna. Hessika izas wurseth gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Hessa geedon issadey koyrottidi wolqama as qachonta dishe wolqamazaso gelanassinne iza miishe bonqanas dandayenna; iza aqo bonqanas dandayettizay wolqamaza qachikko xalala. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ta intes tumu gays; asa naytas nagaraynne cashshi wuri maarettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Gido attin Xillo Ayana bolla cashsha qaala haasayiza asa ubbas mernaas nagara acco gidana attin maarettenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Hessa izi giday isti iza “Ne bolla tuna ayanay dees” gida gishasa. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hessafe guye iza aayeyanne iza ishati kare yi eqqidinne ase izakko kiitti xeygisida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Iza yuuyi aadhdhi uttida daro asay “Hekko ne aayeyanne ne ishati karen eqqidi nena koyeettes” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Izikka zaaridi “Ta aaya oonee? Ta ishati oonantee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Iza yuuyi uttida asaako xeelidi “Ta aayeyanne ta ishati haytantakko! ");
INSERT INTO gmvRNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Xoossa shene ooththizay wuri izi ta isha, ta michonne ta aayo” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Qasse Yesusi hara wode abba achchan tamarso oykkides. Izakko keehi daro derey shiiqida gish abba giddon diza wogolo dizaarin gelidi uttides; asayka wuri abba achchan shiiqides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Izikka daro yo7ota leemiso hizgi tamarsides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Siyite! Issadey zereth zeranas kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Izi zerishin issi issi zerethi oge bolla wodhdhides. Oge bolla wodhdhida zeretha kafoti maxi mida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Baggay mela biittan wodhdhides. He biittay mela gidida gish heerakka caarides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Gido attin awa arshey kezida mala shullidi xapho yeddonta gish melides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Qasse issi zerethi aguntha giddon wodhdhides; agunthayka diccidi cuullida gish ayfibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Hara zerethi qasse lo7o orde biitta bolla wodhdhida gish caaridi diccides; ayfeka ayfides; Issoy heedzdzu tammu, issoy qasse usuppun tammu, issoy qasse xeetu ayfides.” ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesusi qasseka “Siyiza haythi dizadey siyo!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesusi barka dishin tammanne nam7atinne kase izara diza asay izi yootida leemisoza gish iza zaari oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Izikka istas “Intes Xoossa Kawoteththa xuura eroy gelides shin karen dizaytas gidikko yo7oy wuri leemisora yootettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Hessika kase ‘Isti beyidi beyidayssa akeekonta malanne simonta mala, qasseka ista nagaray maaretonta malakko’ ” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Qasseka Yesusi “Hayssi leemisoy intes gelibenee? Histin hara leemiso inte wosti erannee? ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Zerizadey qaala zerees. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Issi issi asati oge bolla wodhdhida zeretha misatettes; isti qaala siyiza wode Xala7ey yiidi heerakka isti siyida qaala ista woznappe ekkichees. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Hessathoka harati mela biitta bolla wodhdhida zeretha misatetes. Isti qaala siydi ufayssan ekketes. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Gido attin isti xapho yeddonta gish guutha wode gam7ishin qaala geedon metoy woykko goodetay asata bolla yiza wode heerakka dhuphetetes. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Harati qasse aguntha giddon wodhdhida zeretha misatettes; isti qaala sisi siyeetes. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Gido attin ha biitta metoy, miisha siiqoynne hara amoy isti siyida qaala cuullidi ayfe ayfonta mala diggees. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Hankoyti lo7o biittan zeretida zeretha misatettes; heytikka qaala siydi ekkizadenne heedzdzu tammu ayfe, usuppun tammu ayfenne xeetu ayfe ayfizayta” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Qasseka Yesusi “Xompe oythidi geemason woykko arsa giddon woththi eretii? Poo7ana mala qonceson wotheeta gidenee? ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Hessa gish qotettidi qonce kezontay, poo7on kezonta geeman attanay baawa. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hessa gish siyiza haythi dizaddey siyo!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Gujidikka “Inte siyizayssa woznan woththite; inte makkiza miishara intes makettana; hessafekka daroy gujettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Dizaddes gujettana shin bayndadefe izas dizaarakka ekketichana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Qasseka Yesusi “Xoossa kawotethi zereth zeriza issi as misatawus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Zeridadey omars dhisikees. Wontishin dendees; gido attin izi eronta dishin zerettida kaththay mokkidi diccees. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Gadeyaka koyro caarech, kaalethada pudhe, qsseka pudheza bolla lo7o ayfe immawus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kathay kaxxidappe guye boney gakkin keeththa aaway heerakka maxa oykkes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesusi “Xoossa Kawoteth nu aazara ginisanee? Aazara leemisanee? ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Biitta bolla ubbafe laafa gidida sanafice ayfe misatawus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Zeretada diccidappe guye qas atakilteta ubbafe aadhdhiza gish kafoti yiidi he atakiltey haggata kuwa giddon shempeetes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesusikka asay ekkanas dandayizayssa keena hayta misatiza hara daro leemisora istas yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ay miish gidikkokka asas leemisoy baynda yooti erenna. Izinne iza kaallizayti xalla diza wode gidikko wursi birsh yootees. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","He gallas gadey qammishin bana kaallizayta “Ane gede he pinth pinnoos” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Isti asa heen aggagidi izi utti diza wogolozara Yesusa ekki bida. Hara wogolotikka istara issife deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","He wode wolqama dambalay abba bolla dendidi wogoloza haaththi kumana gakkanaas dambalay shocechides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Gido attin Yesusi borkoth borkottidi wogolozas guye baggan ichides. Istika iza denthidi “Astamare! Nuni dhayishin nena metenee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Izikka dendidi carkoza “Co7u ga!” abbaka “Woppu ga!” gides; carkoykka co7u gides; mulekka co7u gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bana kaallizaytaka “Hayssatho aazas babbidetii? Hayssa gakkanaas intes ammanoy bawee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Istika keehi babidi ba giddon issoy issara “Carkoynne abbay izas azazettizay hayssi oonee?” geetettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Abba pinnidi gede Gergesenoone geetettizaso bida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesusi wogoloyippe wodhdhida mala tuna ayanay iza bolla dizaddey duufoppe kezidi Yesusara gaaggana izakko yides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Hayssi addezi duufoson dizaddenne haray attoshin oonikka iza sansalatanka qachanas dandaybenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Daro wode toho birataranne sansalatara qashetees. Gido attin kushe sansalata duuththethi yegees; toho birataka mentherethi yeges; oonikka iza oykidi teqanas dandaybenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Gallassinne qamma duufota giddoninne zumata bolla yuuyi yuuyi waassishe ba bolla shuchchara qanxerethidi madunthees. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Izikka Yesusa hahon beyida mala wothan izakko yiidi iza sinthan gulbatidi goynnides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Keehi waassidi “Haysso wogga Xoossa Naa Yesusa, nees tanara aazi dizee? Xoossa sunthan ta nena woossays tana waaysoppa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Izi hessa giday Yesusi kase “Neni tuna ayanay hayssafe keza” gida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Hessafe qasse Yesusi iza “Ne sunthi oonee?” giidi oychides. Izikka “Nuni darota gidida gish ta sunthi Leegone geetettes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","He dereppe kessi yeddonta mala Yesusa keehi woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Heen matan zuma bolla daro guddunthi heemettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tuna ayanati “Nu guddunthatan gelana mala nuus ero garkii?” giidi Yesusa woossida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Izikka istas “Ero” gides. Tuna ayanatikka addezappe kezidi guddunthatan gelida. Nam7u shi gidida guddunthay wuri aafozara dugeththa genderetti wodhdhidi abban mitettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Gudduntha heemmizayti baqatidi hanidayssa katamaninne dere giddon yootida. Dereyka hanidayssa beyanas ba dizasoppe dizasoppe kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesusakko yiidi daro daydanthi iza bolla diza addeza woznay izas simmin may7o may7idinne wogara uttidayssa yida asay beyidi babbides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hayssa beyida asay daydanthi iza bolla diza addeza gishshinne guddunthati hanoyssa derezas yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hessafe guye he dere asay Yesusi ista dere yeddidi baana mala woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesusi wogolon gelishin daydanthati izappe kezida addezi Yesusara daanas woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesusi qasse izi oychidayssa akay giidinne “Neni gede ne so ba, Goday nees ay mala gita miish ooththidakkonne izi nees ooththida maarotetha ne so asas yoota” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Addezikka baso biidi Yesusi izas ooththida gita miish wursi tammu katama geetettiza deren yootin siyiday wurikka malalettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Qasseka Yesusi wogolon gelidi gede pinth pinnidi abba achchan dishin daro asay iza achchi shiiqidinne iza giddoththides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ayhudata Woosa Keeththa halaqatappe issoy Iya7iroosa geetettizayssi izi dizaso biidi Yesusa demmida mala iza toho bolla kundidi ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Taas guutha naa dizaara hayqqana gawus. Iza hayqqonta paxa daana mala ne ha yaada ne kushe izi bolla wotharkii?” giidi keehi woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesusikka izara issife bides. Daro asay iza un7ethana gakkanaas kaallides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tammanne nam7u layth kumeth suuthi izi bollafe gukkiza macas dizaara heen asaara dawus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Iza baassi diza miish wursa ongana gakkanaas akimeppe akime laamon daro daburadus. Gido attin sakoy izis gede darides attin aykkokka lo7ibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Iza Yesusa gish siyida mala asa giddora Yesusa guyera kaallada iza may7o bochchadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Gaasoyka “Ta ay hanadakka iza may7o kushera bocho bochidakkoka ta paxana” gaada qoppida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Gukkiza suuthay heerakka eqi aggides; izakka paxidayssa ba asatethan eradus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Bappe wolqay kezidayssa Yesusi eridi gede asaakko simmidi “Ta may7o oone bochiday?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Iza kaallizayti qasse “Hayssi derey un7etidi sugetishin beyashe waanada ‘Tana bochiday oonee?’ gay” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesusi hessa ooththiday oonakkonne beyanas yuushi xeellides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Macasayakka baas aazi waanidakkone erada babbashenne kokkorashe yaada Yesusa sinthan gufannada hanida tuma wursa izas yootadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Izikka “Ta naye! Ne ammanoy nena ashshides. Saron ba! Ne waayeppe paxa!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesusi buro haasayan dishin Ayhudata Woosa Keeththe halaqa Iya7iroosa soppe yiidi Iya7iroosas “Ne naya hayqadus, Goda mela aazas daaburissay?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Gido attin Yesusi ista haasaya lepi histidi Ayhudata Woosa Keeththa halaqaza “Ne ammano xalla ammana attin babbofa!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Phexroosa Yaqooberanne Yaqoobe isha Yohannisappe attin haray oonikka iza kaallana mala koybenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Gede Ayhudata Woosa Keeththa halaqa so gakkida mala asay waassishe camo yeeho yeekkizayssa beyides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","So gelidi “Hayssi wuri aaza waasonne aaza yeehoo? Naya dhiskadus attin hayqqabeykku” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Qasse asay wuri iza bolla miicides; asa wursikka keeththafe kessidi nay aawanne nay aayiyo qasseka izara issife yidayta iza kaallizayta xalla kaaleththidi naya diza so gelides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nay kushekka oykkidi “Xaabita kum!” gides. “Xaabita kum” guussas birsheththi “Hanne naye, denda” guussa. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nayakka heerakka denda eqqadus; heenne haane hamutadus. Iziska laythay tammanne nam7u laytha; asaykka he hanozan daro malalettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesusi hayssa oonikka eronta mala keehi minthi yootides; “Nays maana quma immite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Hessafe guye Yesusi heeppe dendidi gede ba dere bides. Iza kaallizaytikka izara bida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ayhudata Sambatay gakkin Ayhudata Woosa Keeththe gelidi tamarsishin siyida asay “Hayssi addezi hayssa wursi aawappe ekkidee? Hayssi izas imettida eratethay aazee? Qasse hayti izi ooththiza malatati waani iza kushen hanizoo?” gishe malalettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“Hayssi anaxeza gidenee? Maarami naa Yaqoobenta Yoosanta, Yuhudantanne Simoonanta isha gidenee? Iza micheti nunara haan nu matan dizayta detenee?” giidi hessafe dendidayssani izan ufayettibetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesusikka istas “Nabey bonchettontay ba deren ba dabbota giddoninne baso asa achchan xalla” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Heen guutha harganchata bolla kushe woththi pathorippe attin hara aykko malataka ooththanas dandaybenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Istas ammanoy bayndayssa beyidi malalettides. Hessafekka Yesusi gutan gutan yuuyi yuuyi tamarsides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tammanne nam7ata baako xeygidi nam7u nam7u histi kiittishe tuna ayanata bolla istas godateththi immides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Izi “Oges gidiza guufe attin oge shinqe woykko korojo woykko miishe oykkofte. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Caamma aaththite gido attin laammana may7o oykkofte. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Issi keeththe inte gelikko he katamappe inte kezana gakkanaas he keeththan diite. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Awanka oonikka intena mokki ekkonta ixikko heeppe kezishe he dereta bolla marka gidana mala inte toho bolla diza gudulla qoqofte” giidi azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Istika heeppe kezidi derey maarotethan gelana mala sabakida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Daro daydanthata kessida; daro harganchata zayte tiyi tiyidi pathida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesusa sunthi kaseppe ereti ereti bishin kawo Herdoossi hessa siyides. Issi issi asati “Hayssa mala malatata ooththiza Xammaqiza Yohannisi hayqoppe dendinikko” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Baggayti “Elaasa” geettes; bagga asay qasse “Kase nabetappe issa misatees” geettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herdoossi yo7oza siydi “Ta iza qoodhe qanxisida Yohannisi hayqoppe paxi dendides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herdoossi ba isha Piliphoosa macho Herodiyado ekkida geedon oyketidi qashettana mala azazidi Yohannisa qasho keeththe gelthides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohannisi Herdoosa “Ne isha macho ne ekkonta mala wogay nena diggees” gida gish qachides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodiyada hessa gish hoollotada iza wodhisanas koyadus shin dandayabekku. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Gaasoyka Yohannisi xillonne geeshsha as gididayssa Herdoossi eriza gish Yohannisas babbessinne iza naagees. Yohannisi yootizayssa Herdoossi siydi hirgiza gidikkokka izi yootizayssa woznappe siyees. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herdoosa yeletta gallas bonchanas dhoqa shuumetas; olla wotadarata azaziza waannatassinne Galila biittan keehi erettiza gita asatas gibira kessides; hessika Herodiyadis giiga gallas gidides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodiyadi maca naya gelada asa sinthan yeth yexin Herdoosanne izi xeygida asa izi yethay ufaysidees. Kawoykka nayo “Ne koyiza miish wursa tana oycha ta nees immana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Qasseka ta kawoteththa bagga gididakkokka ne oychikko wursa ta nees immana giidi izis caaqides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nayakka elela kezada ba aayeyo “Kawo ay oychoo?” gadus. Aayiyakka “Xammaqiza Yohannisa hu7e qanxada imma ga” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nayakka elela kezada kawozakko gelada “Xammaqiza Yohannisa hu7e keren wothada ne taas immana mala koyays” ga oychadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kawoy he yo7ozan daro modhettides; gido attin xeeygetida imatha gishinne caaqida qaala gish izis akay gaanas koybeenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hessa gish wotadaratappe issa eeson kiittidi Yohannisa qoodhe qanxidi iza hu7e ekki yaana mala azazides; izikka biidi qasho keeththa giddon Yohannisa qoodhe qanxides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Hu7eza kerera ehidi nays immides; nayakka ba aayeyssi immadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yohannisa kaallizaytikka hessa siyida mala yiidi Yohannisa aha ekki efidi moogida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Hessafe guye Hawaareti simmidi Yesusa achchan yuuyi aadhdhi ba ooththidayssanne ba tamarsidayssa wursi izas yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Daro asay yishenne bishe giza gish quma miza wodeykka bettibenna; “Ane inte xalla tanara asi bayndaso biidi ane guuth shempi ekkite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Hessa gish isti barka wogolon gelidi issi asi bayndaaso bida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Isti bishin daroti beyidi tohora wothan istafe sinthe aadhdhida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesusi wogolozappe wodhdhiza wode daro derey shiiqi uttidayssa beyides. Heemmizadey baynda mehe mala gidida gish asas qadhettides. Daro yo7okka tamarso oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","He wode gadey qammi qammi biza gish iza kaallizayti izakko shiiqidi “Hayssi nu dizasoy bazzokko, gadeykka qammides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Hayssa heeran asi dizaso biidi asay baas miza kath shami maana mala asa yedda” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Izi istas zaaridi “Asaas miza miish inte immite” gides. Istika malalettidi “Nuni biidi nam7u xeetu dinarera kath shamidi hayssa asas immizakko gidandee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Izikka istas “Intes ay lagge ukethi dizakonne ane biidi xeellite” giin isti bi xeelidi “Ichashu ukethinne nam7u moley dees” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hessafe kaallidi asaa cilila maata bolla oyddan oyddan uttisana mala azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Asaykka xeetu xeetunne ichashu tammu ichashu tammu gididi oyddan uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Izikka ichashu ukethanne nam7u moleta ba kushen oykidi pude salo xeelidi anjidinne uketha menthi menthi asas gishana mala bana kaallizaytas immides; nam7u moletaka ubba asas shaakerethides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Asay wurikka miidi kallides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Yesusa kaallizayti asay kalli miin attidayssa tammanne nam7u pitha kumeth shiishida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kath mida asaappe attumasay xalla ichashu shi. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Heerakka izi asaa moyzishe iza kaallizayti sinthatidi gede pinth Betesayda geetettizso pinnana mala azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Heeppeka ista aggagidi woossanas pude zuma bolla kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Gadey qammin wogoloy abba giddon dishin izi barka biitta bolla dees. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Abba bolla carkoy keehi metida gish iza kaallizayti abba shiri shiri wogolo laaggiza miishara baaxetishin Yesusi beyides. Wonta bolla istako yides; yiidinne ista achchara aadhdhi baanatho hanides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Gido attin aadhdhi bana hanishin iza beyida mala moytile beyida misatin wurikka waassida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Wurikka iza beyidi daggammida; izikka heerakka ista yoochidinne “Aykkoy ba; tanakko dagammofte!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Izikka wogolon istako gelin carkoy co7u gides, istika daro malalettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kase izi ukethan ooththida malata birsheth isti eronta gish ista woznay doccides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Abba pinnidi Gensereexe geetettizaso gakkida; wogolappe wodhdhidi wogoloza heen qachidi aggi bida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Isti wogoloppe wodhdhida mala asay Yesusa erides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Wurikka ba dizaso dizaso woxerettidi harganchata halan tookki tookki ekkidi Yesusi dizaso ehida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Izi gakkida gutan woykko katama giddon woykko dere giddon gidin harganchati izi aadhdhishin iza woossidinne iza may7o bochidi paxana mala shiishshi shiishshi dubbushshay dizaason woththida. Izi aadhdhi bishin iza may7o bochidayti wuri paxida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Hessafe guye Farsaaweetinne Yerusalameppe yida issi issi xaafeti Yesusa lanqen yuuyi aadhdhida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yesusa kaallizaytappe baggayti mecetonta qita kushera kath mishin beyida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farsaaweetinne kase cima Ayhuda asati kase dere woga naaganas kushe lo7ethi meecetonta kath mi erettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Giya bi simmikkokka bolla meeceti geeyonta dishe kath mi erettenna. Hessathoka wancakka, otokka, kerekka, ichchiza hiithekka meecha malata hara wogatakka naagettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Farsaaweetinne xaafeti Yesusa “Nena kaallizayti kase aawata woga mala duus aggidi aazas kushe meecetonta kath mizoo?” giidi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Izikka istas “Isayaassi qoodheppe qommon haniza inte gish ‘Hayssi derey ba metershan xalala tana bonches; woznay gidikko taappe haakkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Taas mela hada goynnetes; ista timirteykka asi woththida woga xalla’ giidi yootidays tuma” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Xoossa woga aggidi asi woththida woga naagettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Qasseka “inte wogas giidi Xoossa woga inte aggagiza cincateththa ogey intes dees. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ays giikko Musey ‘Ne aayonne ne aawa boncha; ba aayonne ba aawa cayizaddey mulekka hayqqo’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Gido attin inte qasse ‘Issi asi ba aawa woykko ba aayo inte taappe demmanas koshshiza maado ta Xoossas immadis’ giikko; ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Inte qasse hayssadey ba aawaska ba aayeyssi hara aykkokka ooththana mala koyekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hessa gish inte woga naagana giidi Xoossa qaala laammeta. Heytanta misatiza darota ooththeta.” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Qasseka Yesusi asa baako xeygidi “Wurikka ta giza siyitenne woznan woththite. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kareppe ulo gido gelidi as tunisiza issi miishikka deenna. Harappeka ase tunisizay keeththa aawappe gede kare keziza miisha. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Siyiza haythi dizay siyo!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Izi asa karen aggidi keeththe gelin iza kaallizayti izi yootida leemisoza birsheth Yesusa oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Izikka ista “Inteska yo7oy gellenee? Kareppe gelidi ase tunisiza miishi aazikka deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kareppe gelizay gede woznan gidonta; duge qantha gido gelees qasse heeppe izaade asatethafe gede kare kezees.” Yesusi hessa giday asi miza kaththi wurikka geesh gididayssa qoncisanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kaalethidikka “Asappe kezizazi ase tunises. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Asa wozna giddofe kezizay iita qofata, layma amonne kaysoteth, ase wodho, laymateth, ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Yiiqeteth, iitateth, baleththo, layma kaas, qanatetteth, asa sunth mooro, otoretethinne azalla. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Hayti iita hanoti wuri asappe kezeetessinne ase tuniseetes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesusi heeppe kezidi Xiroose geetettiza dere bides. Heen issade keeththe gelidi izi heen dizayssa asi eronta mala koyides. Gido attin izi heen iza duussay qotettanas dandayettibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Heerakka issi tuna ayanay oykkida guutha naa dizaari aaya Yesusi heen dizayssa siyada izakko yaada iza toho bolla kundadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Macasaya Ayhuda gidonta Girike qaala haasayiza macasashin iza yelettidasoy Sirofinqe geetettes. Izakka Yesusi naype tuna ayana kessana mala woossadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesusi zaaridi izis “Nayta quma ekki kanas yegganas bessonta gish koyro nayti mi kalletto” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Izakka zaarada “Ee Godo! Kanatikka maadda matan de7idi nayta kusheppe gaden wodhdhidayssa meetesikko” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Izikka “Histikko neni hessa gida gish ba! Daydanthay ne naype kezides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Iza simmada so bishin naya daydanthay yeddin paxada hiixan ichchidaro demmadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Hessafe Yesusi Xiroose biittafe dendidi Sidoona gizasora aadhdhi tammu katama gizasora kanthidi gede Galila Abbako gakkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Asay issi haytha tullenne ayfe qooqe asi izakko he ekki yiidi Yesusi iza bolla ba kushe wothana mala woossida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesusikka iza asappe shaakki ekki biidi ba kushe biradhdheta addeza haythan gelthides; qasseka cuchch cuttidi addeza inxarsa bochides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pude salo xeelidinne tookki shempidi “Efita” gides. Hessika “Pogeta” guussa. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Heerakka addeza haythati pogettida; inxarsaykka birshettin geeshshi haasayides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesusi hayssa beyidayti oonaska yootonta mala azazides; gido attin asay izi azazizadayssafe bollara keehi gujidi yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Derezikka wogappe aaththi malalettidi “Izi ooththidayssi wuri lo7o; tulleti siyana mala, duuna duudeti haasayana mala ooththides” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","He wode qasse daro asi shiiqides. Shiiqida asas miza kaththi baynda gish Yesusi bana kaallizayta xeygidi, ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Hayti asati tanara heedzdzu gallas gakkanaas gam7ida gishshinne qasseka istas miza kaththi baynda gish tana miichetes. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Istafe issi issi asati hahoppe yida gish hayssa gafara ta ista so yeddikko daaburidi oge bolla kundana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Iza kaallizaytikka zaaridi “Hayssa bazzon hayssa mala dere mizana quma awappe demmanee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Izikka ista “Intekon aapun ukethi dizee?” gi oychides. Istika “Laapun ukethi dees” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Izikka asay gaden uttana mala azazides; laapun uketha ba kushen oyki galatidinne menthidi asas gishechana mala bana kaallizaytas immin istika derezas gishida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Qasseka heen diza qeeri guutha moleta gish Xoossa galatidi guutha moleta asaas gishechana mala bana kaallizayta azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Dereyka miidi kallides. Hessafekka iza kaallizayti maaddafe palahida kath laapun pitha kumeth denthida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","Hessa mida asay oyddu shi gidana. He asa moyzidi bana kaallizaytara wogolon gelidi gede Dalmanuuta geetettizaso bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farsaaweeti yiidi Yesusara palameteth oykkida. Iza paacanas koyiidi bana saloppe malata bessana mala oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Izikka tookki shempidi “Hayssi yelettazi aazas malata koyizee? Ta intes tuma gays; hayssa yelettas issi malataykka imettenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ista heen aggidinne wogolon gelidi he pinth pinnides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Iza kaallizayti kath oykkonta balettida gish issi uketh attin wogolo giddon hara ay kaththikka deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesusi ista “Farsaaweeta irshofenne Herdoosa irshofe naagetite” giidi azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Isti qasse ba giddon issoy issara “Izi nuna hayssa gizay nuus kath baynda gishassa” gi yootettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Qasse Yesusi ista qofa eridi “Nuus kaththi baynda gish gaasa giidi inte giddon aazas hasayettetii? Ha7ikka yuushi qoppeketii? Woznanka wotheketii? Woykko inte woznay shuchchatidee? ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Intes ayfey dees shin xeelleketii? Haythi dees shin siyekketii? Akeekekketii? ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ichashu uketha ichashu shi asaas ta mentha immin aapun pitha kumeththa kath denthidetii?” gides. Istika zaaridi “Tammanne nam7u” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Izikka “Laapun uketha oyddu shi asas ta mentha immin aapun pitha kumeththa kath denthidetii?” gi oychin istika “Laapun” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Izikka ista “Histin ha7i gakkanaas yuushi qoppibeekketakka!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Hessafe gede Betesayda geetettizaso bida. Guutha asatikka issi ayfe qooqe asi Yesusakko ehidi Yesusi iza bochchana mala woossida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Izikka he qooqeza kushe oykki goochchidi asi dizasoppe gede kare kessi addeza ayfen cuttidinne ba kushe iza bolla woththidi “Ha7i nees aazi bettizee?” gi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Izikka dhoqu gi xeelidi “Asay mith misatidi qaxettishe beettes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Qasseka Yesusi ba kusheta iza ayfeta bolla woththides; heerakka iza ayfeti xeellida; poo7oyka izas simmin wursikka geeshshi xeellides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Qasse “Ha gutata giddo geloppanne oonaska yootoppa” giidi iza gede izaso yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesusi bana kaallizaytara Qisaariya Piliphisiyoose geetettiza dere achchan diza gutata bides; isti oge bolla dishin bana kaallizayta “Tana asay oona gizee?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Istika zaaridi nena “Xammaqiza Yohannisa gizaytikka deettes, baggati qasse Elaasa geettes, harati qas nabetappe issade geettes” giidi yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kaaleththidikka intech tana oona geetii? giidi oychides. Phexroosi “Neni Kirstoosa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesusikka ba gish oonaska isti yootonta mala minthi yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Hessafe Yesusi bana kaallizayta, “Asa Nay daro waaye beyanayssanne dere cimatan, Qeeseta halaqaninne xaafetan kadhettanayssa asa kushen hayqqanayssa, hayqoppe heedzdzantho gallas dendanas bessees” giidi tamarso oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Izikka hessa istas qoncisi yootides, Phexroosikka iza dumma shaakki efidi “Hessatho gooppa!” giidi hanqides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesusi qasse bana kaallizayta yuushi xeellishe Phexroosa “Haysso Xala7e ne taappe gede guye ba! Neni asazappe attin Xoossaz qoppakka!” giidi hanqides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Hessafe guye asa bana kaallizaytara issife baako xeygidi “Tana kaallanas dosizadey diikko bana kaddo; ba masqale tookkidi tana kaallo. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ba shempo ashshana dosizaddey dhayssana shin ta gishshinne ta Mishiraachcho qaala gish ba shempo dhayssizadey wurikka ashshana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Asi alame kumeth haarikkonne ba shempofe dhayssiko iza ay go7anee? ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Woykko asi ba shempo gish laame ekkanay aazi dizee? ");
INSERT INTO gmvRNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Hayssa laymanne nagarancha yeletta giddon dishe tananinne ta qaalan yellatiza asi wuri ta Asa Nay ta Aawa bonchoranne Geeshsha Kiitanchatara yiza wode izan yeellatana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kaalethidikka Yesusi “Ta intes tuma gays; hayssan eqqida asappe Xoossa kawotethi wolqara yishin beyana gakkanaas hayqqonta gam7ana issi issi asati deettes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Usuppun gallassafe guye Yesusi Phexroosa Yaqoobenne Yohannisa banara kaalethi ekkidi issi gita zuma bolla kezides. Isti barka dishin ista sinthan iza medhay laameti wodhdhides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Izi may7ida may7oy biitta bolla oonikka may7o meecidi hessa mala boothanas dandayonta booth boottides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","He wode Elaassinne Musey Yesusara hasayettishe istas beettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Phexroosi Yesusa “Astamare! Nuni haan hayssan dizaakko nuus lo7o; nees issi daase, Muses issi daase, qasse Elaasas issi daase, heedzdzu daaseta nu oothikkochii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Daro babbida gish Phexroosi ba gizayssa eridi gibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Heerakka shaaray ista kammin shaara giddora “Hayssi ta dosiza ta naazakko! Izi giza siyite” giza qaala giirisi yides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Heerakka isti yuushi xeellin Yesusappe attin oonikka hara as istara deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Isti zuma bollafe duge wodhdhishin Asa Nay hayqoppe dendana gakkanaas hayssa isti beyidayssa oonaska yootonta mala azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Istika baas yootida qaala ba woznan oykkida shin “Hayqoppe dendo guussi ay guussakkonne” giidi ba giddon haasayettida ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Qasse isti Muse woga tamarsizayti “Kasetidi Elaassi yaana koshshees aazas gizoo?” giidi iza oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesusi istas “Tumukka Elaassi kaseti yiidi wursikka giigissana. Histinka Asa Nay daro waaye ekkanassinne kadhettanas bessees geetetti xaafettidayssi intes ay misatizee? ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Gido attin ta intes gizay Elaassi gidikko yides shin asaykka iza gish xaafettida mala bana koshshida mala iza bolla ooththides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Duge giddon attida Yesusa kaallizaytakko isti simmi yishin daro asay ista giddoththin Muse woga tamarsizayti istara palamettizayssa beyida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Derey iza demmida mala malalettidi sarokanas izakko woxxides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Izikka ista “Inte istara aaza gish palametettii?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Asaa giddofe issadey “Astamare! Tuna ayanay izan gelin duuna duudida ta naa dayssa ta neekko ekka yadis. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ayanazi dendiza wode bollafe yeggees; duunara gopponto kessi kessi yeggees; achchakka garcees; asatethakka zoodisses. Tuna ayana kessetto gaada nena kaallizayta ta oychin istika dandayibeetenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesusikka istas zaaridi “Inteno ammanonta yelettato, ayde gakkanaas ta intenara daanee? Qasse ayde gakkanaas ta intena dandayanee? Ane naaza ha ehite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Asaykka naaza izakko ehides, tuna ayanay Yesusa beyida mala naaza heerakka gaden gendersidi kokkorsidinne duunara gopponto coppu histides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesusi naaza aawa “Hayssi hargey iza ayidesappe oykkidee?” gides. Naaza aawaykka “Naatethafe doommidi” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Iza wodhanas koydi daro wode tamanka haaththanka yeggees. Nees dandayettikko nuus mishetanne nuna maadda” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesusi qasse “ ‘Nees dandayettikko’ gay? Ammanizades wurikka dandayettes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Naaza aaway heerakka “Ta ammanays shin ta ammanoy laafa, tana maaddarikii?” giidi waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Asay wocamishe buuretti ekkidi izakko yizayssa Yesusi beyidi “Haysso tullenne duude ayanazo! Hayssa naazappe keza, ne qasse simmada gelonta mala ta nena azazays” giidi tuna ayana seerides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tuna ayanazikka keehi waassides; naazikka keehi qaketidappe guye naazappe kezides. Daroti hayqqides gaana gakkanaas naazi aha misatides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Gido attin Yesusi naaza kushe oykki denthides. Naazikka dendi eqqides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesusi so gelidappe guye iza kaallizayti “Nu izappe tuna ayana kessanas aazas dandayibeykkonii?” giidi iza oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Izikka istas “Hayssa malay kezana dandayizay woossaninne xooman xalla” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Heeppe dendi Galila baggara aadhdhi bida. Yesusi ba dizaso oonikka erana mala koybenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Gaasoyka Yesusi bana kaallizaytas “Asa Nay asa kushen aadhdhi imettana istika iza wodhana, heedzdzantho gallassafe guye izi dendana” giidi ista tamarsiza gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Gido attin izi gizayssi istas gelibenna; iza oychanaska babbida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hessafe guye Qifirnahoome bida. Izi keeththe gelidi “Inte yishe oge bolla aaza gish palametidetii?” gi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Isti qas oge bolla “Nu giddon nuuppe ubbafe aadhdhizay oonee?” giidi palametida gish wurikka co7u gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Izi uttidappe guye tammanne nam7ata xeygidi “Koyro gidana koyizadey ubbafe wursethinne ubbatas ashkara gido” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Qii guutha naa ehidi ista giddon essides. Idimmidinne ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Hayta guutha naytappe issade ta sunthan mokki ekkizadey tanakka mokki ekkees. Tana mokki ekkizadey wuri tana xalala gidonta tana kiittidayssakka mokki ekkees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohannisikka “Astamare! Issadey ne sunthan daydanthi kessishin nu beydos. Izi nuna kaallonta gish kessonta mala diggidos” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesusi qasse “Diggofte; oonikka ta sunthan malata ooththidi eesotidi ta bolla iita haasayanas dandayenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nunara eeqettontay wuri nunara dees. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ta intes tumu gays; inte tiyettida Kirstoosas gidida gish ta sunthan issi wanca haath intena ushshidadey wuri ba oosoys waaga dhayenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Hayta tana ammaniza ha guuthatappe issades dhuphe gidizay wuri deexxo woxa shuchchi iza qoodhen qashetin duge abba gido olettidakko izas lo7o gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Hessa gish ne kushey nena baleththikko neeppe qanxa yegga; nam7u kushera daada gede Gaanname taman ne baanayssafe kushe duuxa gidada gede de7on geloy nees lo7o gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Gaannamen guxuney hayqqenna, tamaynne to7enna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nena ne tohoy baleththikko neeppe qanxa digga; nam7u tohora daada gede Gaanname taman yegettanappe ne wobe gidada gede de7oso geloy nees lo7o. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Gaannamen guxuney hayqqenna, tamaynne to7enna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nena ne ayfey baleththikko wooca kessada neeppe digga; nam7u ayfera daada gede Gaannamen yegetanappe issi ayfera Xoossa Kawoteth geloy nees lo7o. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Gaannamen guxuney hayqqenna tamaynne to7enna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Buro asi wuri taman paacettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Maxiney lo7o; gido attin maxiney ba maxinetetha yeddiko inte wosti iza mal7o eranee? Inte asatethan maxiney de7o. Inte inte giddon dosettite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesusi heeppe dendidi gede Yuhuda geetettiza derenne Yordanoose shaafappe pinthan diza dere bides. Dereyka qasse iza yuuyi aadhdhin izi kase ba ooththiza mala asa tamarsides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Issi issi Farsaaweeti izakko yiidi “Asi ba macho anji yeddanas bessizee?” giidi iza paace oysho oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Izikka istas “Musey intena ay gi azazidee?” giidi zaari oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Istika izas “Musey ta izo anja yeddadis giza waraqata xaafi immidi anjo gides” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesusikka zaaridi ista “Musey hayssa mala woga xaafidayssi inte woznay minnida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Gido attin koyro Xoossi medhishe macanne adde ooththi medhides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Hessa gish asi ba aawanne ba aayo aggidi ba machira waaxettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nam7ay issi asho gideettes; hessa gish isti nam7ay issinoppe attin nam7u deettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hessa gish Xoossi gaththi waaxidayta asi shaakkofo.” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Qasseka isti so gelin iza kaallizayti he yo7oza gish zaari iza oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Izi istas “Oonikka ba macho anji yeddidi hara macas ekkiko he macasay bolla layma ooththes. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Macasayakka ba azina aggada hara adde gelikko izakka laymatawus” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yesusi ba kushe wothana mala asay nayta izakko ehides. Iza kaallizayti qasse ehida asa bolla hanqettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesusi hessa beyi hanqettidi “Nayti taakko yeto; diggofte; Xoossa Kawotethi haytanta malassa. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ta intes tumu gays; Xoossa Kawoteth hayssa guutha nayta mala ekkontadey izin mulekka gelenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nayta idimmidi ista bolla ba kushe woththidi anjides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Heeppe buro oge kezishin issadey wooxishe izakko gakkidinne iza sinthan gulbatidi “Kiya astamareento! Tani merna de7o demmana mala ay ooththana taas bessizee?” gi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesusikka “Aazas tana kiya gay? Issi Xoossafe attin kiyay ba” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","“Neni azazota eray? ‘Wodhoppa; laymatoppa; kaysotoppa; wordo markatofa; as baleththofa; ne aawanne ne aayo boncha’ gizayta” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Addezikka zaaridi “Astamare! Ta hayta wursa naatethafe oykkada naagadis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesusi iza xeelidinne dosidi “Histikko ha7i nees issi miishi paccees. Baadanne nees diza wursa bayza, miisha manqotas imma; neni salon shiiqida miish demmandassa; histadanne haaya tana kaalla” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Addezikka hessa siydi daro yiillottides. Izas daro haroy diza gish muuzottishe bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesusi yuushi aaththi xeelidi bana kaallizayta “Duretas Xoossa Kawoteth geloy ay mala deexo!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iza kaallizaytikka iza haasayan malalettida. Yesusi qasse zaaridi “Nayto! Xoossa Kawoteth geloy ay mala deexo miishe! ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Durey Xoossa kawoteth gelanayssafe gaamellay narpe lukkora aadhdhanayssi kawuyana!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Iza kaallizaytikka darsi malalettidi ba giddon issoy issa “Histin ooni attana dandayizee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesusi ista xeelidinne “Hayssi asas dandayettenna; Xoossa matan gidikko hessa mala gidenna. Xoossas wurikka dandayettes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Phexroosi qasse “Hekko; nuni wursikka aggidi nena kaallidos” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesusikka zaaridi “Ta intes tumu gays; ta gishshinne Mishiraachcho qaala gish giidi ba keeththe, woykko ba ishata, woykko ba micheta, woykko ba aayo, woykko ba aawa, ba nayta, woykko ba gade aggida as wuri, ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","hayssa ha wodezan ha7i goodeteththara keeththata, ishata, micheta, aayeta, naytanne gadekka xeetu kushe aaththi ekontaynne buro yaana alamezanka merna de7o laattontadey deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Gido attin sinthatida daroti guyettana; guyetidayti sinthatana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Isti Yerusalame efiza oge bolla dishin Yesusi istafe sinthe sinthe bees. Iza kaallizayti iza buussan malalettida. Hanko iza geedon diza asay qas izas babbides. Qasseka tammanne nam7ata derezappe dumma shaakkidi ba bolla aazi gakkanakkonne istas hizgi yootides; ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Nuni Yerusalame kezana; Asa Nay Qeeseta halaqatassinne Muse woga tamarsizaytas aadhdhi imettana; istika iza bolla hayqo pirda pirdananne dere asas aaththi immana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Iza bolla qidhi ka7ana; iza bolla cuttana; izakka garafananne wodhana shin izi heedzdzu gallassafe guyen hayqoppe dendana.” ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Qasse Zabidoosa nayti Yaqoobeynne Yohannisi izakko shiiqidi “Astamare! Nuni nena woossidayssa ne nuus wursa ooththana mala nu koyoos” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Izikka istas “Ta intes ay ooththana mala koyetii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Istika “Neni ne kawoteththa boncho wode nuuppe issadey ne ushachan issadey ne hadirsan uttana mala nuus ero garkii?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesusikka “Inte oychizayssa erekketa. Tani uyana ushsha uyanassinne tani xammaqettiza xinqata xammaqettanas dandayandetii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Istika zaaridi “Ee, dandayoos” gida. Yesusikka “Ta uyiza ushsha inte uyananne ta xammaqettiza xinqata inte xammaqettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Gido attin ta ushachara woykko ta hadirisara utethi Xoossi istas giigissidaytas attin ta immana miish gidenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tammati hessa siydi Yaqoobenne Yohannisa bolla hanqettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesusikka issi bolla shiishshidi “Dere halaqa geetettizayti dere haarizayssa mala ista shuumeti ista bolla ba godateth bessizayssa inte ereeta. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Gido attin inte giddon gita gidana koyiza ubbay ashkara gido. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Sinthe aadhdhana koyizay wurikka ubbas aylle gido. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Asa Nay gidikko asas ooththanassinne ba shempo darota gish aaththi immanas yides attin ase oosisanaas yibenna.” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Heeppe gede Yarko bida. Yesusinne iza kaallizayti hara daro asatara Iyarkofe kezishin Ximoosa naa Barxemoosa geetettiza ayfe qooqey oge bolla uttidi woosses. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Izikka yizay Naazirete Yesusa gididayssa siydi “Dawute naa Yesusa tana maara” giidi keehi waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Daroti izi co7u gaana mala hanqida; gido attin izi “Dawuteno! Tana maara” giidi keehi waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesusikka eqqidi “Iza ha xeygite” gides. Istika qooqeza “Aykkoy ba denda nena xeeyges” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Izikka ba may7o qaari yeggidi pusukku gi dendi eqqidi Yesusakko yides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesusikka “Ta nees ay ooththana mala koyay?” gides. Qooqezikka “Aastamareento! Ta xeellanawu koyays” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesusikka zaaridi “Ba nena ne ammanoy pathides” gides. Heerakka iza ayfey xeellides. Izikka Yesusa kaalli bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Isti gede Yerusalamen Dabrazayte geetettiza zuma achchan diza Betefaagenne Bitaaniya geetettizaso matida wode Yesusi bana kaallizaytappe nam7ata hizgi kiittides, ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Gede inte sinthan diza gutayo biite. Inte he gelida mala heen asi togi eronta qashon diza hare gutte inte demmana; birshidi iza ha ekki yiite. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Oonikka intena ‘Hayssa ays ooththetii?’ giikko Godas koshshees giidi yootite; izikka intes eeson zaari yeddana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Istika biidi issi keeththa karen oge bolla qasheti diza hare gutte demmidi birshida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Heen eqqida issi issi asati “Hare gutteza aazas birshetii?” gi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yesusa kaallizayti Yesusi istas gida mala asatas yootin ero eki biite gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Guttezakka Yesusakko ehidi ba may7o iza zokko bolla yeggin Yesusi iza toggides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Daro asay ba may7o kessi kessi oge bolla micides. Bagga asay cilila mitha hayth qanxi qanxidi oge bolla laallides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yesusappe sintharanne guyera diza asay qaala dhoqu histidi “Hoosana; Goda sunthan yizadey anjettidade. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Hanna yizara nu aawa Dawute kawoteththaya anjettidaro; hoosana! Bolla salon Xoossi bonchetto” gishe waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesusi Yerusalame gakkidi hessafekka Xoossa Keeththe gelides. He heeran dizayssa wursi xeelidi gadey qammida gish tammanne nam7atara gede Bitaaniya kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wontetha gallas isti Bitaaniyappe kezi bishin Yesusi gafides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Izi issi haythi cililida balase geetettiza mithi hahon beyidi ayfey daanakkonne giidi iziikko yides. Gido attin balase mithi ayfonta wode gidida gish haythafe attin issi ayfekka izippe demmibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Hessa gish mithayo “Hannife guye mernas oonikka neeppe ayfe mooppo!” gides. Iza kaallizaytikka izi gizayssa siyida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Gede Yerusalame bida; heeppeka gede Xoossa Keeththe gelidi heen bayzizaytanne shamizayta kessi goodo oykkides. Miishe laammizayta xaraphezanne haraphe bayzizayta oyde gufanthi gufanthi yeggides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Oonikka ay miish tookkidi Xoossa Keeththe gibbe giddora aadhdhonta mala diggides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Istaka tamarsishe “Ta keeththi dere ubbas Woosa Keeththe gidana geetetti xaafettibenee? Gido attin inte qasse kaysota gongolo kessideta” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Qeeseta halaqatinne Muse woga tamarsizayti hessa siydi iza wosti dhayssanakkonne oge kosh oykkida. Gido attin dereyka iza timirtezan malalettida gish izas babbida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Istika gadey qammin katamaype kezi bida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wontetha gallas maalado isti ogera aadhdhi bishin balase mithaya xaphoppe melidaro beyida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yo7ozi iza woznan akeeketin Phexroosi Yesusa “Astamare! Hekko, hanna ne qangida balaseya meladus” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Izikka zaaridi “Xoossa ammante. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ta intes tumu gays; ‘Oonikka hayssa zumaza ne dhoqalletada gede abban gela’ gizakkonne hessaka woznan sidhonta ammanidakko izaades hanana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hessa gish inte woossan oychidaz wursi ekkida mala ammanikko intes hanana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Hessathoka inte woossas eqqiza wode inte Salo Aaway inte nagara atto gaana mala inteka intena qohidayta nagara wursi atto giite. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Inte atto goonta ixikko inte salo aawaykka inte nagara atto geenna.” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Qasseka Yerusalame yida. Yesusi Xoossa Keeththe kare giddon gedene haane yuuyetishin Qeeseta halaqati, Muse woga tamarsizaytinne dere cimati izakko shiiqidi, ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Hayssa ne ooththizay ay godatetharaa? Hayta ne ooththana mala hayssa mala godateth nees ooni immidee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesusikka istas zaaridi “Ane takka intena issi oysho oychays inteka taas zaarikko takka ha yo7ota ay godateththara ooththizakkonne intes yootana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yohannisa xinqatey Xoossafeyee? Asappee? Ane taas zaarite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Istika ba giddon issoy issara “Nu saloppe giikko izi nuna ‘Histin aazas iza ammanibeyketii?’ gaana; ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‘Nu asappe’ giikko” Yohannisi tumu nabe gididayssa derey wuri ammaniza gish hessatho gaana babbida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hessa gish “Nu erokko” giidi Yesusas zaarida. Yesusikka “Histikko ta hayta aaza godateththara ooththizakkonne takka intes yootikke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Qasse istas leemisora yootishe “Issadey ba woyne mith tokkides. Keela yuushi aaththi keelides; woyne mitha ayfe gum7ana olla bokkides. Naage keeththekka keexides. Hessafe goshshanchatas kira immidi hara dere bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mithay ayfiza wode woyne mitha ayfe ekkada ya giidi ashkaratappe issade goshshanchatakko yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Goshshanchati ashkaraza oykki shocidi coo mela kushe yeddida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nam7anthokka hara ashkara yeddides. Goshshanchati ha7ikka ashkara oykkidi izas hu7etara qoo7idinne kawushshidi zaari yeddida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ha7ikka zaaridi hara ashkara yeddides. He yeddoyssakka wodhida; hara darota giddofe issi issi asata qoxida; baggayta wodhida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ha7ikka kiittonta attiza haray dees; izikka aaway dosiza iza naaza. ‘Ta naaza isti boossana’ gi qoppidi wursethan ba naaza yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Goshshanchati qas ba giddon ‘Hayssi waanna iza laattana naaza; ha yiite nu iza wodhikko biittay nuus gidana’ gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hessa gish heen oykki wodhidi woyne mithaya dizasoppe haraso kessi yeggida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Histin woyne mitha goday intes ay ooththana misatizee? Izi yaana; goshshanchatakka wodhana; woyne mitha haratas immana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Geeshsha Maxaafan ‘Shuchcha keeththe keexizayti hanenna giidi wora yeggida shuchchay keeththa maazanes bolla hu7e gidides; hessaka Goday ooththides. Hessika nu ayfes malalisizaz geetettidi xaafettidayssa nabebibeekketii?’ ” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Izi istas leemisoza yootiday ista gish gididayssa Ayhuda halaqati erida gish iza oykkanas koyda. Gido attin asas babbida gish aggi bida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yesusa yo7on qaxana mala Farsaaweetappenne Herdoosa baggatappe guutha asata dooridi izakko yeddida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Istika izakko yiidi “Astamare! Neni mooroy baynda as gididayssa nu eroos; ne oonaska babbada wordo maaddakka; Xoossa oge xalala tumu tamarsassa. Oroome kawo Qeesares giira qanxanas bessizeyee? Bessenee? Nu qanxinoyee? Qanxofinoo?” ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yesusi ista oyshoy qoodheppe qommo gididayssa eridi “Aazas tana qaxana koyetii? Ane issi dinare hammite ta beyays” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Istika miisha ehin “Hayssi iza bolla diza misilezi oona misilee? Iza bolla xaafetidayssi oona gizee?” gides. Istika “Qeesareyssakko” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesusikka “Qeesareyssa Qeesares, Xoossayssa Xoossas immite” gides. Istika iza zaaron malalettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hessafe guye hayqqidaytas hayqoppe denthi baawa giza Saduqaaweti izakko yiidi iza hizgi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Astamare! Issi asi macho ekkidi naa yelonta hayqqikko hayqqidayssa ishay iza macheyo ekkidi izas laata naa yelana mala kase Musey nuus xaafides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Gido attin laapun ishanti deettes; istafe bayray macho ekkidi naa yelonta hayqqides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kaalozi he macasayo ekkidi ha7ikka naa yelonta hayqqides; heedzdzanthoyka yelonta hayqqides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Laapunatikka he macasayo ekkidi laata yelibeetenna wursethan macasayakka hayqqadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Histin laapunatikka izo ekkidashin hayqoppe dendoy diza gidikko ha macasaya istafe oona macho gidanee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesusikka istas “Inte balettizay Geeshsha Maxaafatanne Xoossa wolqa eronta gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Hayqqidayti dendiza wode Salo Kiitanchata mala gidana attin ekkettettenanne gelettettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Hayqqidayta dentha gishas gidikko Muse maxaafan hessika qeeri wora giddon eexxiza tama giddofe Xoossi ‘Tani Aabrahaame Xoossa; Yisaaqa Xoossa; Yaqoobe Xoossa’ gizayssa nababibeekketii? ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Xoossi paxata Xoossa attin hayqethata Xoossi gidenna. Hessa gish inte daro balettideta” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Isti palaman dishin xaafetappe issadey ista palama siydinne Yesusi oyshetidayssas lo7eth zaaridayssa akeekidi “Ero! Azazotappe ubbafe aadhdhizay awayssee?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesusi izas hizgides “Ubbafe aadhdhizay hayssa ‘Isra7eele siya! Goda Xoossi issi Goda, ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nekka Goda ne Xoossa ne kumeththa woznappe, ne kumeththa shempofe, ne kumeththa qofappe, ne kumeththa wolqafe dosa.’ ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nam7anthoykka ‘Ne lagge ne hu7e mala dosa’ ha nam7atappe aadhdhiza azazoy baawa.” ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Xaafezikka “Aastamare, lo7o gadasa, ‘Xoossi issino gididayssanne izappe haray bayndayssa’ ne yootidayssi likke. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Iza ne kumeththa woznappe ne kumeththa qofappe ne kumeththa wolqafe dosoy qasseka ne lagge ne hu7e mala dosoy xuugetiza yarshofenne hara yarsho ubbafe aadhdhees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesusikka addezi yuushi qoppidi zaaridayssa beyidi “Neni Xoossa Kawoteththafe hahon daakka” gides. Hessafe guye iza oychanas xalidadey bettibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesusi Xoossa Keeththe gaaththan tamarsishe “Muse woga tamarsizayti aazas ‘Kirstoosa Dawute naa’ gizoo? ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawutey Xillo Ayanan haasayishe ‘Goday ta Goda ne morketa ta ne toho gars aaththana gakkanaas ta ushachchan utta gides’ gees. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Histin Dawutey ba duunara iza ‘Goda’ giikko waanidi simmi izas naa gidanee?” gides. Daro dereyka izi gizayssa ufayssara siyides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Izi tamarsishe “Muse woga tamarsizaytappe naagettite, gadera gooshettiza aduussa may7o may7idi yuush yuuyana doosettes; awanka aadhdhi aadhdhi asi istas boncho sarota immana mala koyettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ayhudata Woosa Keeththan dhoqaso, gibirasokka bonchoso koyeettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Isti azinay baynda macasa keeththa kallosettes; qasseka bana bessanas adussa woossa woossetes. Haytanti iita pirda pirdettana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesusikka asay muxuwata yeggizason uttidi daro asati immizayssa Xoossa Keeththa miisha shiishshiza saaxinen yeggizayssa xeellides. Daro dureti daro miish yeggida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Issi azinay baynda am7e dizaara issi sikinafe daronta xarqimala biratappe oosettida nam7u miish yeggadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesusi bana kaallizayta xeygidi “Ta intes tumu gays; saaxinezan yeggida ubbafe hanna manqo am7eya aadhdheth yeggadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Hayti wuri baas diza tirpa miishafe yeggidashin hanna qasse ba manqotethafe baas dizayssa sinthafe izo koshizayssara wursa immadus” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Izi Xoossa Keeththafe kezishin iza kaallizaytappe issoy “Astamare! Hayssi keeththaynne keeththay keexettida shuchchay ay mala lo7izakkonne hayssa beyay?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesusikka zaaridi “Hayta gita keeththata xeellay? Shuchchati issoy issa bolla diza mala deettenna; wurikka laalettana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesusi Xoossa Keeththa ginara Dabrazayte zuma bolla uttidishin Phexroosi, Yaqoobi, Yohannissinne Indiraassi xalla izakko shiiqidi, ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Hayssi ayde hananakkonne nuus yoota. Hayssi wursethan poletanas malatay aazee?” gi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesusikka istas “Oonikka intena baleththonta mala naagettite. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Buro daroti ‘Ta Kirstoosa’ gishe ta sunthan yaana; darotaka baleththana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Inte olanne ola wore siyiza wode daggammofte. Hessi hananayssi attenna. Wursethi gidikko burona. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Derey dere bolla kawoy kawo bolla dendana, daroson biitta qaathinne koshay hanana; heyti wuri miixas leeso mala. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Inte intes naagettite. Buro intena dere duulatan aaththi immana. Isti intena Ayhudata Woosa Keeththan garafana. Inte ta markata gidana mala ta gish dere daannata sinthaninne kawota sinthan eqqana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Koyrottidi Mishiraachcho qaalay dere ubbas sabakettana bessees. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Inte oyketidi pirdas shiiqiza wode hinno he saateyin intes imettizaro haasayite attin biidi nu ay giinoo? giidi kaseti hirgofte. Haasayanay Xillo Ayanappe attin intena gidekketta. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ishay isha, aaway ba naa hayqos aaththi immana; nayti bana yelidayta bolla makalananne wodhana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ta geedon inte asa ubban ixettidayta gidana. Wurseth gakkanaas minni eqqidadey gidikko attana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Inte harassiza tunatethi izas bessontason eqqidashe beykko nababizadey woznan wotho; Yuhudan dizayti pude zuma bolla baqatetto. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Keeththa karen dizaddey so geloppo; ba miish kessana giidi keeththe geloppo. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Goshshason dizaddey ba may7o ekkanas guye simmofo. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","He gallasatan shaara macasatassinne naa dhanthizaytas aayye-ana! ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Hessika balgon gidonta mala Xoosse woossite. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Koyro Xoossi medhetetha wursi medhosoppe ha7i gakkanaas woykko hayssafe guye iza misatizay baynda gita metoy hanana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Goday he gallassata qaanthontakko oonikka attenna shin baassi doorettidayta gish he gallassata qaanthides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“He wode oonikka hekko Kirstoosi hayssan dees; giikko woykko hekko heen dees giikko ammanoppite. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Wordo Kirstoosatinne wordo nabeti buro dendidi malatatanne kase hani eronta pala miish ooththana. Istas dandayettikko haray atto shin doorettidaytakka baleththana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Hessa gish naagettite; he wodey gakkonta dishin haara hayssa wursa ta intes yootadis. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“He wode he metozappe kaallidi awa arshey dhumana; aginaykka poo7usuku. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Xoolinteti saloppe qoqofettana, salon diza wolqamati qaaxana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","He wode Asa Nay gita wolqaranne bonchora salo shaarara yishin asay iza beyana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Izikka kiitanchata yeddidi oyddu baggafe biitta gaxappe gaxa gakkanaas diza baas doorettidayta shiishana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Leemisoza balase mithafe tamarite. Unquloy cililiza wode haythi kessishin boney matidayssa inte ereeta. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hessathoka hayti ta gidayti poletishin inte beykko wodey mati yiidi penge gakkidayssa erite. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ta intes tumu gays; ha yo7oti polettana gakkanaas hayssi ha yelettay aadhdhenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Saloynne sa7ay aadhdhana shin ta qaalay gidikko aadhdhenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Qasse he gallassay gish woykko he saatey gish ta Aawappe attin Salo Kiitanchata gidinka Naaza gidinka oonikka erenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Hessa gish wodey aydekkonne inte eronta gish nagettite, minnitenne woossite. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Hessika ba keeththe ashkaratas aggidi ashkarata issa issa ooso oythidi penge naagizayssi beggidi naagana mala azazidi bida asa misatees. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Histikko keeththa aaway ayde yaanakkonne woykko qamma leela gidoth yaanakonne woykko koyro kuttoy baqishin yaanakkonne woykko wonta bolla bazzoy zo7ishin yaanakko inte eronta gish beggidi naagite. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Inte qopponta dishin izi yiidi inte dhiskidishin intena demmofo. ");
INSERT INTO gmvRNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“Ta intes yootizayssa asa ubbas yootays; minnidi naagite! gays” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Paaziganne uketha muussa ba7aale gallassay bonchetanas nam7u gallassi attishin Qeeseta halaqatinne Muse woga tamarsizayti Yesusa baleththi oykidi wodhana oge koyda. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Gido attin “Asay meto medhonta mala ba7aale gallasatan gidoppo” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Izi Bitaaniya geetettiza soon issi inchiracha hargancha gidida Simoona soon quma bolla dishin waagay daro al7o gidida nardoose geetettiza shittoy kumi uttida albasxiroose bilqaaxe oykkida issi macasaya bilqaaxeza menthada shittoza Yesusa hu7e bolla gussadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Heen gadaan diza asatappe issi issi asati “Hayssi shittozi aazas wogay baynda gukkizee?” giidi ba giddon hanqettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","“Shittozi bayzo bayzidakko heedzdzu xeetu dinareppe bollara bayzettidi manqotas imetteneshin” giidi macasayokka kadhida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Gido attin Yesusi istas “Aggite! Hanno macasayo aazas waayssetii? Iza taas lo7o miish ooththadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Manqoti ay wodekka intenara deettes. Inte koyda wode aydekka ista maaddanaas dandayeta shin ta gidikko ubba wode intenara diikke. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Hanna ba ooththanas dandayizaari keena ooththadus. Taas moogos gidana mala ta asho kaseta tiyadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ta intes tumu gays; hayssi Mishiraachcho qaalay alame kumeththan sabaketizason awanka iza ooththidayssi izo hassa7issizaz gididi hasayettana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Hessafe guye tammanne nam7atappe issoy Asqoroonto Yuhuday Yesusa aaththi immanas Qeeseta halaqatakko bides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Istika hessa siydi ufayettida; izas miishe immanas izara giigida. Hessa gish Yesusa aaththi immanas inje wode naagishe gam7ides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Paaziga dorsi shukettiza uketha muussa bonchiza koyro gallas Yesusa kaallizayti Yesusakko shiiqidi “Paaziga kawo maanaso awan giigisana mala koyay?” gi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Izikka bana kaallizaytappe nam7ata “Gede katama biite; inte bishin haaththe otora tookkida issadey intenara gaaggana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Izi biidi gelizaso gakkanaas iza kaallite. Keeththadezas ‘Astamarey nena tana kaallizaytara Paaziga kawo maanas taas gidiza imatha shemposoy awayssee? gides’ giite. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Izikka bolla pooqe bolla diza giigi uttida aaho so intena bessana; heen izan giigissite” gi kiittides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Iza kaallizaytikka kezidi gede katama bida. Wurikka Yesusi gida mala hani beettides; Paazigakka heen giigissida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Gadey qammishin Yesusi bana kaalliza tammanne nam7atara gakkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Isti maaddan dishin “Ta intes tumu gays; inte giddofe issoy izikka tanara issife mizayssi tana aaththi immana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Istika muuzotidi “Taneshaa? Taneshaa?” giidi issoy issoy Yesusa oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Izikka istas “Tammanne nam7atappe issoy tanara ba kushe keren yeddizade. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kase xaafettida mala Asa Nay iza gish hayqqana shin asa naa aaththi immizades aayye-ana! Hessadey kase yeletonta aggidakko izas lo7okkoshin!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Isti mishin uketha ekki anjidinne menthidi bana kaallizaytas “Hayssa ta asho heyte” gi immides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ushshakka denthi galatidi istas immin isti wurikka uyida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Qasse Yesusi “Hayssi darota gish gukkana ta ooratha caaqo suutha. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ta intes tumu gays; ooratha woyneppe giigida ushsha Xoossa Kawoteththan ta uyana wode gakkanaas nam7antho hayssa uyikke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hessafe guye mazamure issife yexidi pude Dabrazayte zuma bolla kezida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesusi “ ‘Ta heemmizayssa shocana he wode iza dorsati laalettana’ geetetti xaafettidayssa mala inte wurikka tanan duphettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ta dendidayssafe guye gidikko ta intefe kasetada Galila baana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Phexroosikka “Asay wuri dhuphetikkokka tani dhuphetikke!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesusikka “Ta nees tumu gays; hachchi qamma kuttoy nam7uto waassana gakkanaas neni tana heedzdzuto kadana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Phexroosi qas “Ta nenara hayqqizakkoka mulekka nena kadikke” giidi keehi minthi yootides. Hankoytikka wuri izayssatho gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hessafe guye Getesemaane geetettizaso bida Yesusikka bana kaallizayta “Tani woossishin inte hayssan gam7ishshite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Phexroosa, Yaqoobenne Yohannisa banara ekki bides. Keehi qoppidessinne metottides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Qasseka istas “Ta shempoya daro metottadus inte haan diishshite. Dhiskonta naagite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ista achchafe guuth gede pooqidi biitta bolla gufannidi hanko he saateya izappe aadhdhana mala woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Ta Aawawu! Nees wuri dandayettes; hayssa waaye xu7a taappe haassa. Gidikkoka ne sheneppe attin ta sheney hanoppo” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Izi heeppe simmi yishin iza kaallizayti dhisikkidayta beyides. Phexroosakka “Simoona dhiskadii? Haray atto shin issi saatekka minnada naagoy nena xoonidee? ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Inte paacen gelonta mala beggidi woossitenne minnite. Ayanay giigeti uttides shin ashoy gidikko daburancha” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Qasseka biidi koyroyssatho woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Izi nam7antho simmi yishin ista ayfen dhiskoy deexxin dhiskidayta demmides shin isti izas ay zaaranakkonne eribetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Heedzdzantho yiidi “Ha7ikka inte ichchidi shempetii? Ha7i gidana, saateyakka gakkadus; hekko Asa Nay nagaranchata kushen aadhdhi imettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ane eqqite boos; tana aaththi immanaddey yides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesusi buro haasayan dishin tammanne nam7atappe issoy Yuhuday yides. Izara issife Qeese halaqatappenne Muse woga tamarsizaytappe kiitettida daro asay giththa mashshanne durqa oykidi yides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Iza aaththi immana Yuhuday istas “Asa giddofe ta yeerizadey iza gidida gishas oykidi lo7ethi naagi efite” giidi kaseti malata immi woththides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Gakkida mala Yuhuday Yesusakko shiiqidi “Astamare!” giidi yeerides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Asatikka Yesusa oykkida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Iza achchan eqqida issoy mashsha koohoppe shoddi Qeeseta halaqa ashkara hayth qanxides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesusikka istas “Panga mala tana oykkana mashshanne durqa oykidi yeetii? ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wontin wontin Xoossa Keeththan tamarsashe ta intenara dishin oykibeekketa shin kase xaafetidayssi polettana mala hayssi hanides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hessa wode iza kaallizayti wuri iza yeggi aggi bida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ba kalloteth qeeri naxalan kammida issi nay Yesusa kaallishin asay iza oykin, ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Naazi naxala yeggidi kallo kichchides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yesusakka gede Qeeseta halaqakko efida. Qeeseta halaqati, dere cimatinne Muse woga tamarsizayti heen issife wuri shiiqida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Phexroosikka Yesusa hahora kaallishe Qeeseta halaqa gibbe gakkanaas bides. Izi heen uttidi hara asatara tama ho7ishin, ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Qeeseta halaqatinne dere cimati wuri Yesusa wodhanas markattana as koyda shin demmanas dandayibeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Daroti iza bolla wordora markattikkokka markata qaalay oykketibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Issi issi markati dendidi wordora, ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Hayssi addezi ‘Ta asa kushen keexettida Xoossa Keeththa laallada asa kushey bochontaz hara Xoossa Keeththa heedzdzu gallassara ta keexxana’ gishin nu siyidos” gi markattida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Gido attin ista markatethi issi bolla wodhdhibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Qeeseta halaqayka ista sinthan eqqidi “Hayti ne bolla markattizaysi aazee? Ne aazas duuna zaarikii?” giidi Yesusa oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Gido attin Yesusi istas aykkokka zaaronta co7u gides. Qeeseta halaqay qasseka “Anjettida Xoossa Nay Kirstoosi nenee?” gi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesusikka zaaridi “Ee; tanakko! Asa Nay wolqama Xoossa ushachchan uttishininne salo shaarara yishin inte iza beyana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Qeeseta halaqay ba may7o daakkidi “Nuus hara aaza marka koshshizee? ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Izi cashsha qaala Xoossa bolla hasayshin inte siyideta; ha7ich intes ay misatizee?” gides. Istika “Izas hayqoy bessees” giidi wurikka issi qaalan pirdida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hessa wode issi issi asati iza bolla cuch cuttida; iza ayfe goozi oykidi iccishe “Ane tinbite yoota” gida. Baggayti qasse shagalan baqqishe efida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Phexroosi duge baggara heen gibbe giddon dishin Qeeseta halaqa garadetappe issiniya yadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Phexroosi tama ho7ishin tishshi hista xeellada “Neni Naazirete Yesusara daassa gidikkii?” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Izi qas “Ne gizayssade ta erikke; ne gizyssi taas gelenna” giidi kadides. Hessafe gede penge pooqi eqqi dishin heerakka kuttoy waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","He garadeya iza beyida mala heen eqqida asatas “Hayssi addezi izara diza asatappe issadekko!” gaada qasseka haasayadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Izi qasseka kadides. Guutha wode gam7ishin heen eqqida asati Phexroosa “Neni Galila asa, hessa gish tumappe ne istafe issade” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Gido attin izi qas “Inte gizadde ta erikke!” gishe caaqonne bana qangeth oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Heerakka kuttoy nam7antho waassides. Phexroosikka “Kuttoy nam7a waassanas ne tana heedzdza kadana” gida Yesusa qaalay izas qofetin hiqqimidi yeekkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Maalado wontara Qeeseta halaqati, dere cimatinne Muse woga tamarsizayti kumeththa shango alafetara issife zoretidi Yesusa qachi ekki efidi Philaxoosas aaththi immida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Philaxoosikka Yesusa “Ne Ayhudata kawoo?” gi oychides. Yesusikka “Ee, ne gida mala” giidi izas zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Qeeseta halaqatikka daro yo7o iza bolla shiishshi mootida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Philaxoosi qas “Ne aazas oysha zaarikii? Hekko nena daro yo7on mootetes” giidi qasseka oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Gido attin Yesusi ha7ikka izas aykkokka zaaro immonta gish Philaxoosikka malalettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Paaziga ba7aale gallas Philaxoosi derey birshana mala oychidade birshi yeddiza wogay kase dees. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Iita ooson dere bolla dendidi shempo wodhida asatara issife qashettida Barbaane geetettiza issadey dees. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Dereyka yiidi kase lose gididayssa izi ooththana mala Philaxoosa woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Philaxoosikka istas “Ta intes Ayhuda kawo birshana mala koyetii?” gi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Philaxoosi hessatho oychiday kase Qeeseta halaqati Yesusa qanaten aaththi immidayssa eriza gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Qeeseta halaqati qas “Iza exa Barbaaney birshetto!” gi oychana mala dereza dentheththida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Philaxoosi “Histikko inte Ayhuda kawo giza addeza wostana mala koyeti” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Isti qasseka “Kaqqa! Kaqqa!” gi waassida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Philaxoosikka “Ay iita ooththidee?” gi ista oychides. Isti qas “Kaqqa! kaqqa!” giidi kaseppe aaththi waassida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Philaxoosikka dereza ufayssana giidi Barbaane istas birshides. Yesusa garafidi kaqqanas aaththi immides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Wotadarati Yesusa dere haarizayssa gibbe ekki biidi attida wotadarata wursi shiishida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Yesusa zo7o may7o mayzida; aguntha aklile xaaxidi iza hu7en woththida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Hessafekka “Ayhuda kawo saroy nees gido!” gishe iza sarothida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Iza hu7e guufera shocida; iza bollakka cuttida gulbatidi izas goynnida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Iza bolla qidhi ka7idappe guye kase mayzida zo7o may7oza qari ekkidi kase iza may7oza zaari mayzidi kaqqanaso eki bida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Alakisandrosanne Ruufoosa aawa Simoona geetettiza issi Qareena dere asi dereppe katama yizayssa Yesusa masqale wolqara oykki toossida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Hessafe guye Yesusa Golgota geetettizaso efida; izas birsheththay “Asa hu7e guuge” guussa. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Karbe geetettiza camora walaketida woyne cajje uyana mala izas immin izi ekkonta ixxides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Hessafe guye iza kaqqida, iza may7o issade issade awayssi gakkanakkonne giidi saama yeggidi gishettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Isti iza kaqishin wontafe heedzdzu saate gidides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Isti masqale bolla xaafi shiishida mooto qaalay “Ayhuda kawo” giza qaala. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Izara issife nam7u pangata issa izappe ushachara issa hadirsara kaqqida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Hessanka kase maxaafay “Iitatara issife taybettides” gida tinbite qaalay polettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ogera aadhdhi bizaytikka ba hu7e qaathishe “Oy! Oy! Xoossa Keeththa laallada heedzdzu gallassan keexxanay nenee?” giidi iita cashshe cayishe; ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","“Ane ha7i masqale bollafe wodhdhada nena ashsha” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Hessathoka Qeeseta halaqatinne Muse woga tamarsizayti ba giddon issoy issas “Harata ashshides shin bana ashshana dandaybenna” giidi iza qidhida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","“Nu iza beyidi ammanana mala ane hayssi Kirstoosi Isra7eeleta kawoy ha7i masqaleppe wodhdho” gida. Izara kaqettidaytikka iza bolla cashshe korida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Usuppun saateppe oykkidi uddufun saate gakkanaas biittay wuri dhumides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Uddufun saate bolla Yesusi “Eelohe! Eelohe! Lama sabaqitane” giidi qaala dhoqu histidi waassides. Hessas birsheththay “Ta Xoosso! Ta Xoosso! Ne tana aazas aggadii?” guussa. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Heen gadaan eqqida asappe issi issi asati hessa siydi “Elaasa xeeygesko” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Hessafe issi asi eleli biidi caalida woyne cajje isponje mala miishan gelthi kessidi mitha xeeran oythidi uyana mala Yesusas shiishshides. Hessafe qasse “Ane aggagite; Elaassi yiidi iza kaqqoppe woththishin nu beyana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Hessafe Yesusi qaala dhoqu histi waassidi shempo kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Xoossa Keeththe magalashay hu7era duge nam7u kezi daakkettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Yesusa ginara eqqida issi mato halaqay Yesusi hessatho gita qaalara waassidi shempo kezishin beyidi “Hayssadey tumu Xoossa naakkoshin” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Hessa wode macasati hanizayssa hahon diidi xeellida. Ista giddofe Magdaleppe yida Maaramanne kaalotiza Yaqoobenne Yoosa aayo Maaramira qasseka Saloomira issife deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Heyti macasati Galilan Yesusa kaallishenne izas ooththishe gam7idayta. Istarakka issife hara daro macasati Yerusalame bida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Gadey qammi qammi bishin Sambatas giigettiza gallassi gakkides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Dere cimata giddon bonchettida issi Armatiyasa dere as Yoosefe geetettizayssi Xoossa Kawoteth naagishe dizaddey babbonta Philaxoosakko biidi Yesusa aha woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Philaxoosikka izi hinni wode ellera hayqqidayssa siydi malalettides. Mato halaqa xeygisdi “Izi hayqqi gam7idee?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Izi hayqqidayssa mato halaqay geeshshi eridappe guye Yesusa aha Yoosefes immides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yoosefekka moogo may7o shamidi aha masqaleppe woththidi moogo may7on xaaxidi shuchchafe woocetida duufon moogides. Duufa duuna shuchchara gordides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdaleppe yida Maaramiranne Yoosefe aayo Maaramira Yesusa aha awan moogidakkone beyida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sambatay aadhdhidappe guye Magdale Maarama, Yaqoobe aayo Maaramiranne Saloomira issife biidi Yesusa aha tiyanas shitto shammida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Saamintafe koyro gallas maalado wontara buro awa arshey kezida mala Yesusa duufokko buro bishin, ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","“Duufoza duunappe shuchcha nuus ooni gendersanee?” giidi ba giddon haasayettida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Isti dhoqu gi xeellishin daro gita shuchchay duufoza duunappe genderidayssa beyida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Gede duufoza giddo gelida mala issi bootha may7o may7ida paanthi ushachcha baggara uttidayssa beyidi dagammida. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Izi qas istas “Dagammofte! Inte kaqettida Naazirete Yesusa koyeeta; izi dendides haan deenna, isti iza woththidaso hayssa beyte. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Gido attin inte biidi iza kaallizaytassinne Phexroosas kase intes yootida mala intefe kasetidi izi Galila baana. Inte iza heen demmana giidi istas yootite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Macasatikka malalettishenne kokkorshe duufappe kezi baqattida. Babbida gish oonaska aykkokka qaattibetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Saamintafe koyro gallas Wogga wonta maaladora izi hayqoppe dendidappe guye Yesusi izippe laapun daydanthi kessida Magdale Maaramis koyro beettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Izakka baada kase izara dizayti kayotishenne yeekkishe dishin demmada yootadus. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Isti Yesusi paxa dizayssanne iza ta Yesusa beyadis gidayssa siydi ammanbeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hessafe guye iza kaallizaytappe nam7ati gede dere gars bishin Yesusi istas hara as misati beettides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Istika simmidi hessa iza kaallizaytappe attidaytas yootida. Gido attin iza kaallizayti siydi ammanbeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Hessafe guye tammanne issineti maadda bolla dishin Yesusi istas qoncides. Izi hayqoppe dendin iza beyida asati istas yootin siydi ammanonta aggida gish istas ammanoy bayndayssanne ista wozna muumetetha gish ista borides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Istasika “Alame ubbaso biite, Mishiraachcho qaala medhetetha ubbas sabakite. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ammandaynne xammaqettiday attana. Ammanontay gidikko pirdettana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tana ammanizayta hayti malatati kaallana. Isti ta sunthan daydanthata kessana, ooratha qaalanka haasayana. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Isti shooshata ba kushera oykkana; wodhiza marze uyikkokka ista qohenna. Ba kushe harganchata bolla woththi woossikko harganchati paxana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Goda Yesusi hessa yootidappe guye pude salo dendi biidi Xoossa ushachan uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Iza kaallizayti hessafe kezidi ubbason aadhdhi aadhdhi sabakida. Godayka istara ooththides. Ista timirteza ekkidi ooththizaytas ba yootida qaalakka malata ooththi ooththi minthides.");
INSERT INTO gmvRNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Boncho Tofilosa nu achchan hanida yo7ota gish daro asati baassi hanida mala xaafida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","He taarikezikka koyroppe denthidi ba ayfera beyida markatinne Xoossa qaala yootidayti nuus aaththidayssa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Takka ta baggara xaphoppe denthada keeha naagetadanne paaca xeellada taarikeza wursa sinthe xaafetanas bessizayssa sinthasada kaallidi xaafetanas bessizayssa kaalethada naagetada nees xaafana mala taas lo7o gidi beettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Hayssa wursisa ta ooththizay ne tamaridayssi tuma gididayssa nena ero guussassa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","6","Herdoossi Yuhuda biittan kawotida wode Aabiya geetettiza Qeeseta halaqa baggafe Qeesetetha ooso taray iza gakkida Zakaraasa geetettiza issi Qeesey dees. Iza macheyakka Elisabeexo geetetawus, izakka Aarone bagga asa. Nam7atikka Goda azazonne iza woga wosoy baynda naagidi dizaytanne Xoossa sinthan xillo asa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Gido attin Elisabeexa naa yelonta makkara gidida gish istas nay baawa; nam7atikka wodey sugetida asa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zakaraassi Xoossa sinthan Qeesetetha ooso taray iza gakkin izi ooththishin ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Qeesetas diza woga mala Xoossa Keeththan gelidi exane cuwassana mala exay iza gakkides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Exaney cuwattishin asay wurikka karen diidi woosses. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Goda kiitanchay exaney cuwattiza soppe ushachcha baggara eqqidi Zakaraasas beettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakaraasikka iza beyidi keehi daggammidi babbides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kiitanchay Zakaraasas “Babbofa! Ne woossay seetettides, ne macheya Elisabeexa nees attuma naa yelana iza sunthaka ne Yohannisa gaada sunthana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Iza yelettan neni daro ufayettana; Daro asaykka ufayettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Goda sinthan izi gita gidana. Woyneppe oosettida cajje gidinka hara mathosiza ushsha gidinka izi uyenna; izi buro ba aayey qanthan dishe Xillo Ayanan kumana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Isra7eele asappe darota ista Xoossako zaarana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Aawata wozna ista naytaakko, azazetontaytikka gede Xillota cincateththakko zaarana malanne Godas bessiza dere giigissana mala Elaasa Ayananne iza wolqan Godappe sinthara izi baana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaraassi kiitanchas, “Tani cima; ta macheyakka cimmadus; tani hayssa aazan eranee?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kiitanchaykka zaaridi “Tani Xoossa sinthan eqqiza Gabrelle. Tanikka ha Mishiraachchoza nees gaththanas kiitetada yadis. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Hekko neni ba woden polettana ta qaala ammanonta ixida gish ne duunay duudana, nenikka haasayana dandayakka” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","He wode derey Zakaraassi “Xoossa Keeththafe kezonta aazas gam7idakko” giidi modhetishe naagides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Izi Xoossa Keeththafe kezidi asa haasayissanas dandaybenna. Malati malati besoppe attin haasayanas dandayonta aggin asay izi Xoossa Keeththan Xoossafe ooratha miish beyidayssa erides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakaraasikka ba ooso taray poletidappe guyen baso simmides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hessafe kaallin iza macheya Elisabeexa naa qanthatadus, ichashantho aginay gakkanaas asi bana beyonta mala qotetadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Izakka Goday ba maarotan ta leqettidayssa asa giddofe digganas ha wodezan hayssa taas ooththides gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elsabeexa qanthatida usuppuntha aginan, Xoossi ba kiitancha Gabrelle, Galila biittan diza, Naazirete giza katama yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Izikka kawo Dawute zereth gidida Yoosefe geetettiza asas giiga uttida Maaramo geetettiza geela7oykko kiitettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Yiidinne iza dizaaso gelidi “Hanne Xoossi nena anjidare saro Xoossi Goday nenara dees nenka anjettidaaro” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maarama kiitancha haasayan keeha daggammada, “Hayssi ay giza sarotaa?” gaada yo7oza keeha qoppadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kiitanchaykka Maaramo “Xoossi nenan ufayetiza gish babbofa! ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Neni qanthatana; attuma naaka yelana, sunthaka Yesusa gaada sunthana; ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Izikka gita gidana; ubbafe bolla Xoossa naa geetettana, Goda Xoossi iza aawa Dawute kawoteththa izas immana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Izi Isra7eele nayta bollan mernas kawotana; iza Kawotethasikka wursethi deenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maaramakka kiitanchas “Tani adde gelabeekke, shin hayssi waani hananee?” gaada oychadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kiitanchaykka Maaramisi “Xillo Ayanay ne bolla wodhana wursofe bolla Xoossa wolqay ne bolla kuwasana; Hessa gish yelettana naazi Geeshsha Xoossa naa geetettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Asi yeluku iza makkara giidi haasayiza ne dabboya Elisabeexa cimateththan attuma naa qanthatada yelanas usuppuntho agina oykkadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Xoossassi hanonta miishi baawa” ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maaramakka zaarada “Hekko tani Xoossa aylle diikkina; ne gida mala taas hano” giin kiitanchay izippe shaakatidi bides. Maarama Elisabeexo beyana badus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Maaramakka he wode matara eesota dendada pude gezze deren diza issi Yuhuda katama badus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zakaraasa keeththe gelada Elisabeexo sarotadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabeexa Maarami sarotha siyida mala qanthan diza naazi izi qanthan guppides, Elisabeexinka Xillo Ayanay kumides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Izakka ba qaala dhoqu ooththada “Macasa ubbafe ne anjettidaaro; Ne qanthan diza naazikka anjettidayssa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ta Goda aaya taakko yaada tana oychanas tani oonee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ne saroka qaala ta siyida mala ta ulo giddon diza nay ufayssa guppides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Polettana giidi Goday izis yootidayssa ammanidara iza anjettidaro” gadus ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","49","Maaramakka “Izi ba aylle kawushshatetha xeellida gish ta shempiya Goda dhoqu ooththada bonchawus. Ta Ayanaykka tana ashshiza ta Xoossan ufayetawus. Wolqama Goday taas gita miishe ooththida gish hachchife sinthan asi wuri tana anjettidaro gaana. Iza sunthaykka geeshsha. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Iza maaroy izas babbizaytas naa naa gakkanaas daana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ba wolqan daro mino ooso ooththides; ba wozna qofan otoretizayta laallides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kawota kawoteththafe woththides, ashketa qasse dhoqu dhoqu histides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Gafidayta lo7o miishan kalthides; dureta gidikko mela kushe yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Kase nu aawatas Abrahaamessinne iza qommotas gida qaala naaganas ba maaretetha yuushi qoppidi ba aylle Isra7eele maaddides” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maaramakka Elisabeexi achchan heedzdzu agina sire gam7ada baso simmadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabeexis yelo gallassay gakkin attuma naa yeladus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Izi gutatinne dabbottikka Goday izis gita maaretetha ooththidayssa siydi izira issife ufayetida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yeletida ospuntha gallas qaxxaras yida. Iza aawa sunthan Zakaraasa giidi sunthana koyda. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Gido attin aaya “Hanenna, iza sunthi Yohannisa geetetto” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Istika izis “Ne dabbotappe Yohannisa geetettidi xeeygetida asi oonikka baawa” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aaway Zakaraassi “Naaza oona giidi sunthana koyidakkonne” malatan oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakaraaska xaafiza miishe izas immana mala oychi ekkidi sunthay “Yohannisa” giidi xaafin asay wurikka malalettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Heerakka Zakaraasa duunay pogetidi inxarsi birshettin Xoossa galata oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Iza gutati wuri daro babbida. Hayssi wurikka dhoqa gezze biittan Yuhuda deren, ubbason haasayettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Hayssaka siyida asi wurikka “Ha guutha nay ay hananeshshaa?” giidi hanoza wursikka ba woznan oykkides. Goda kushey tumappe izara issife dees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Naaza aaway, Zakaraassi Xillo Ayanan kumidi tinbite haasayishe ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Yiidi ba asa ashshida gish Isra7eele Xoossi galattetto. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","Beni wode ba geeshsha nabeta duunan haasayettidayssa mala ba aylle Dawute keeththan ashshiza wolqa nuus denthides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Izi nuna nu morketappenne, nuna ixizayta kusheppe ashshees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Hayssa izi ooththiday nu aawatas ba maaretetha bessanassa, ba geeshsha caaqqoza yuushi qoppanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Kase nu aawa Abrahaames caaqidayssa qoppana malanne nu morketa kusheppe izi nuna kessin nuni izas babboy baynda ooththanassinne nu diza wode ubban ba sinthan nuna geeshshatethanne xillotethan essanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Goda oge giigissanas ne izappe sinthara biza gish ta naazo neni woga Xoossa nabe geetettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Asay ba nagarappe maarettida gish deres atotetha erateth ne immana mala ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","nu Xoossa lo7o maaretethafe dendidayssan Saloppe nuus away kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Hessika dhuman dizaytassinne hayqo kuwa giddon dizaytasikka poo7isana malanne nu tohotakka sarotetha oge kaalethanassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Guutha naazikka diccides; Ayananikka minnides. Isra7eele asas qoncen beettana gakkanaas bazzo biittan de7ides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","He wode biitta bollan diza asi wurikka tayibettidi xaafettana mala Oroome kawo Awuggisxossappe awajjay kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Hessika Qerenewoosa geetettizayssi Sooriya geetettiza dere haariza wode hanida koyro dere taybo. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Hessa gish asi wuri xaafettanas ba dere dere bides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yoosefeykka asho dabboteththan Dawute baggafe gidida gish Galila awurajja giddon diza Naazirete katamappe Yuhuda awurajja Beeteleme geetettiza Dawute katamappe yides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Izi xaafettana bishin izas giigetta dashe yelana matida Maaramira bides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Istika heen dishin izis yelo wodey gakkides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Izakka koyro attuma naa yelidayssafe guye imaththi aqiza keeththan aqizasoy baynda gish naaza carqara xaaxada miiza sinthan ishissadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Beetaleme achchan dorsa heemiza asati dorsa naagishe qammara karen aqizayti deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Goda kiitanchaykka istako yides; Goda boncho poo7oykka ista lanqen yuuyi aadhdhanas poo7ides. Istika keehi dagammida gish, ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kiitanchay ista “Babofte! Tani asa ubbas gidiza gita ufayssa mishiraachcho ekka yadis. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hach kawo Dawute katama Beetalemen shempo dhaley yelettides. Izikka Goda Kirstoosa geetettes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Carqara xaaxeti ichchida gacino naa demmandeta hessika intes malata gido” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Izarakka hara daro salo kiitanchati beettida. Xoossa galatishe, ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Bolla salon Xoossas bonchoy gido sarotethika biitta bollan izi dosiza asa ubbas gido” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kiitanchati istafe shaaketidi salo simmin dorse heemizayti ba giddon issoy issa “Ane ha yiite Goday nuus qoncisidayssanne hanidayssa Beeteleme katama biidi beyoos” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Istika elelli biidi Maaramira, Yooseferanne miiza sinthan ichchida naaza demmida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Beydayssafe guyen Goda kiitanchay naaza gish istas yootidayssa wursi zaari yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Heemizayti yootidayssa siyida asay wuri keehi malalettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Gido attin Maarama yo7oza wursa ba woznan wotha dentha qoppashe gam7adus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Heemizaytikka handays wurikka kiitanchay istas yootida mala gididi beettida gish siydayssassinne beyidayssas ubbas Xoossa galatishenne bonchishe simmida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Naazi yeletin ospuntha gallassan qaxxarettiza wodey gakkin aayeya iza qanthatanappe kase kiitanchay gida mala Yesusa geetettidi summides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Muse woga mala isti geeyiza wodey wurin Yoosefeynne Maarama guutha naa Yesusa Goda Xoossa sinthe shiishshanaas ekkidi Yerusalame kezida. Hessika Goda wogan koyro yeletiza attuma nay wuri Godas dumma gidana geetettidi xaafettidayssa polanassinne ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","qasseka Goda wogan nam7u haraphphe kafotanne woykko nam7u haraphphe kafo ciyeta geetettiddayssa mala yarsho shiishshanaassa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","He wode Yerusalame kataman xillonne Xoossa babbiza issi Simoona geetettiza asi dees; izikka Isra7eele nayta atotetha naagiza asanne Xillo Ayanay iza bolla shempida asa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Qasseka Kirstoosa beyonta dishe hayqqonta mala Xillo Ayanay izas qoncides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Izikka he wode Xillo Ayanay kaalethin Xoossa Keeththe lasha gaath gelides. Naaza aayeyiranne aawara Muse wogan bessizayssa polanas guutha naa Yesusa ekkidi gelida wode, ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simooni naaza ekki idimmidi Xoossa galatishe, ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","“Godo! Ne caaqida qaala mala ha7i tani ne aylley ne ashshizayssa ta ayfera beyida gish hi7a tana saron ekka; asa ubba sinthan ne giigissida atotetha ha7i tani ta ayfera beyadis. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Hayssika ubba deres geemmettidayssa qoncisiza poo7o, ne dere Isra7eelesikka boncho” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Iza aawaynne aaya iza gish haasayettida yo7ozan malalettida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simoonikka ista anjides; Maaramokka “Daro asa wozna qofay qoncana mala hayssi Isra7eelen diza darotas dhayossinne atotethassa; Iza ixizaytas qasse malata gidana mala doorettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Qasseka darota wozna qofay qoncana mala naaza mishay qara mashsha mala ne wozna phalqana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Qasseka Aasseere baggafe Fanu7eele naa Haana geetettiza cimmida nabey dawus; izakka ba koyro azinara laapun layth kumeth de7adus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Laythay izis osupun tammanne oyddu layth gidana gakkanaas qammanne gallas xoomashenne woossashe Xoossa Keeththafe shaaketonta am7etethan gam7adus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","He wodekka shiiqada Xoossa galatadus. Yerusalame wozeteth naagishe dizaytas ubbas guutha naaza gish yootadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yooseferanne Maaramira Goda wogan azazettidayssa polidi Galila awurajjan diza baso Naazirete katama simmida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Guutha naazikka diccidi minni minni bides; aadhdho eratethan kumides; Xoossa aadhdho kiyatethayka iza bolla dees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Iza aawaynne aaya laythan laythan Paaziga bonchanas Yerusalame beettes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Naazas laythay tammanne nam7u layth kumida wode kase lose gididayssa mala Paaziga bonchana kezida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Paaziga ba7aaleza bonchidi baso simmishin Yesusi Yerusalamen attides. Yelidaytikka izi attiddayssa eribeyttenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Banara issife biza oge asara dees gishe issi gallassa oge bida. Gido attin izi istara bayndayssa eridi ba dabbota achchaninne laggeta achchan dizaakkonne giidi koyda. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Koyi koydi beettonta ixin Yerusalame simmida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Heedzdzu gallassafe guye Xoossa Keeththan tamarsizayta giddon uttidi siyishe, asata oychishenne ista oysha zaarishe Xoossa Keeththan dishin demmida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Siyidayti wuri Yesusa akeekkaninne iza zaarozan daro malalettida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Yoosefeynne Maarama iza beyida wode malalettida. Maaramakka “Ta naazo ays hayssa mala ooththadii? Ne aawaynne taninne nena koyishe keehi metottettidos” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Izikka zaaridi “Tana ays koyidetii? Tani ta aawa keeththan daanas bessizayssa eribeekketi” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Gido attin istas izi yootidayssi gelibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Heeppe simmin istara issife Naazirete wodhdhidi istas azazettishe de7ides. Iza aaya Maaramakka he hanida miisha wursa ba woznan naagashe gam7adus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesusi aadhdho eratethan, geesaninne saban Xoossa sinthaninne asa sinthan diccides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Xibiraadoose geetettizays Qeesarey kawotida tammanne ichashantho laythan Phanxoosa Philaxoosa gizayssi Yuhuda biitta haariza wode, Herdoossi Galila biitta haariza wode, iza ishay Piliphoosi, Ixuriyaasanne Xirakondoose biitta haariza wode, Lisanoosikka Abloone biitta haariza wode, ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Haanaynne Qayaafay Qeeseta halaqa gidida wode Xoossa qaalay bazzo biittan diza Zakaraasa naa Yohannisakko yides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohannisi Yordanoose shaafa achchan diza dereta “Inte nagara atto gaanas nagarappe simmidi xammaqetite” giidi yootides ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Hessika qasse nabe Isayaassi “Bazzon hizgidi waassiza asa kooshinchi ‘Godas oge giigissite baasidikka lo7ethite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Shoobba biittay wuri kumana; zumatinne zumbullati wuri ziqqi gaana; geella ogey sitti gaana; moorettida ogey lo7o gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Asa zereth ubba ashshiza Xoossa wolqa beyana’ giidi bazzon waassiza asa qaala giiris” giidi ba maxaafan xaafida mala. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yohannisikka iza kushen xammaqettana yiza asas “Inteno ha shoosha nayto! Yaana diza Xoossa hanqofe haakkana mala ooni intena zoridee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Inte nagara oosoppe simmidayssa erisiza ooso ooththite ‘Nu aaway Abrahaamey nuus dees’ guus aggite gides. ‘Xoossi baas giikko ha shuchchatappe Abrahaames naa ooththi denthanas danda7izayssa erite’ ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kaltay mith qanxanas mitha xaphon dees. Lo7o ayfe ayfonta iita mithi wuri qanxettidi taman yeggettana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Asaykka “Histin ay ooththonii?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohannisikka asas “Nam7u may7oy dizay issi may7oy baynda asas immo; qasseka qumay dizayka bayndades shaakkidi immo” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Qaraxa shiishshizaytikka xammaqetanas yiidi “Astamaare! Nu ay ooththinoo?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Izikka “Inte azazettidayssafe bollara qaraxa shiishoppite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wotadaratikka “Nuni qasse ay ooththinoo?” giidi oychida. Izikka “Oona miishekka gidin wolqan ekkofte; qasseka oonanne wordon mootoppite; inte damozay intes gidana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Asay Yohannisa beyidi “Hayssi Kirstoosee?” giidi ba woznan sidhides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohannisikka ubbas “Tani intena haaththan xammaqays; gido attin ta iza caamma birshanas bessonta taappe aadhdhizaddey yaana. Izi intena Xillo Ayananinne taman xammaqana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Balezan diza kathaa gafezappe geeshshaas kath suragiza pithay iza kushen dees. Baleza kumeththa geeshshana; gisteza qasse di7en qolana; gafezakka to7onta taman xuugana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohannisi asa hara dumma dumma zore qaalara minithethi zorishe Mishiraachcho qaala yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Gido attin Galila biitta haariza Herdoossi ba isha macho Herodiyado ekkida gishshinne hara daro iita ooththida gish Yohannisi iza hanqida gish, ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","kase mooro bolla hara gujjidi Herdoossi Yohannisa qasho keeththan yeggides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Asay xammaqettidappe guye Yesusikka xammaqettides; izi woossishin saloy doyettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Xillo Ayanaykka haraphe misatidi iza bolla wodhdhides. “Saloppe ta dosiza nay nena; Nenan tani ufayettays” giza qaalay yides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesusi Xoossa ooso oykkishin laythay izas heedzdzu tammu laytha mala gidana. Asaykka izi Yoosefe naa, Eelle naa, ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Maate naa, Lewe naa, Milka naa, Yuhuda naa, Yoosefe naa, ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matotiyo naa, Amoxe naa, Naahoome naa, Isilime naa, Naage naa, ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maate naa, Matotiyo naa, Semeye naa, Yoosefe naa, Yuhuda naa, ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoonane naa, Reese naa, Zerubaabele naa, Selatiyaale naa, Neere naa, ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Milka naa, Hade naa, Yoosa naa, Qoosaame naa, Elimodaame naa, Eera naa, ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Iyaaso naa, Eli7azaare naa, Yoorame naa, Maate naa, Eele naa, ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simoona naa, Yuhuda naa, Yoosefe naa, Yoona naa, Eliyaqeeme naa, ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meeliya naa, Maynaane naa, Maxaate naa, Naatane naa, Dawute naa, ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Iseeye naa, Iyoobeede naa, Bo7eeze naa, Solomoone naa, Naasoone naa, ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Amnadaabe naa, Aarame naa, Aarone naa, Esroome naa, Faareese naa, Yuhuda naa, ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yaqoobe naa, Yisaaqa naa, Abrahaame naa, Taara naa, Naakoore naa, ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seerohe naa, Raaguwe naa, Faaleqe naa, Abeere naa, Saala naa, ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Qayineme naa, Aarfakiside naa, Seeme naa, Nohe naa, Laamehe naa, ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Matusaala naa, Henooke naa, Yaareede naa, Malali7eele naa, Qayiname naa, ");
INSERT INTO gmvRNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Henoose naa Seete naa Addame naa, Xoossa naa, misatides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesusi Xillo Ayanan kumidi Yordanoose shaafappe simmida mala Xillo Ayanay iza kaaleththidi bazzo biitta efides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Heenka Xala7en oyddu tammu gallas paacettides. He paacettiza gallassatan aykkokka moonta gish wursethan gafides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Xala7eykka Yesusa “Ne Xoossa naa gidikko ane hayssa shuchcha kath gidana mala azaza” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesusikka zaaridi “Asi kaththan xalla deenna geetettidi xaafettides” giidi Xala7es zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Hessafe kaallidi Xala7ey Yesusa issi dhoqa zuma bolla kessidi salo gufanthon diza kawotetha qiphida ayfey xeellanas bessidinne, ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Hayssi ne beyiza biitta kawota godateththaynne bonchoy wurikka taas imettides; takka ta dosizaddes immanas dandayiza gish neeska immana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","“Hessa gish neni kundada taas goynnikko hayssi wurikka nees gidana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesusikka zaaridi “Ne Goda Xoossas kundada izas xalla goynna geetettidi xaafettides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Hessafekka Yesusa Yerusalamen Xoossa Keeththa xeera kessi essidi Xoossa Maxaafan “Nena naagana mala Xoossi ne gish ba kiitancha azazana; ‘Ne tohoy shuchchan dhuphetonta mala kiitanchati ba kushera nena dhoqu histi oykkana’ geetettidi xaafettida gish ane ne Xoossa Naa gidikko hayssafe duge kunda” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesusikka “Ne Goda Xoossa paacofa” geetettides giidi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Xala7eykka ba paacanayssa wursidappe guyen hara baas inje wodey bettanashshe Yesusappe shaakettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesusikka Xillo Ayana wolqan Galila simmides. Iza goobateththay Galila achchan diza deretan siyettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Izikka Ayhudata Woosa Keeththan tamarsishin iza timirtey lo7in asay wurikka iza galattides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Heeppe ba yelettida katama Naazirete yiidi kase Sambata gallas Ayhuda Woosa Keeththe geliza mala gelidi Xoossa Maxaafa nababanas dendi eqqides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nabe Isayaasa Maxaafay izas imettin maxaafa doyida mala. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“Goda Ayanay ta bolla dees; manqotas Mishiraachcho qaala yootana mala tana tiyides; qashetidaytas birsheteth, qooqeti xeellana oge ta awajjana mala, metotettidayta aashshana mala, dossettida Goda laytha awajja ta yootana mala tana kiittides” giza so demmi nababidinne. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Maxaafakka gordidi Ayhuda Woosa Keeththe naagizayssas zaari immidi uttides. Ayhudata Woosa Keeththan dizayti wurikka iza tishshi ooththi xeellida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Izikka istas “Hayssi inte inte haythara siyida maxaafa qaalay hachchi polettides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Asay wurikka iza gish lo7o xalala hasayeettes. Qasseka iza duunappe keziza lo7o qaalappe dendidayssan malalettidi “Hayssi Yoosefe naa gidennee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Izikka “Dhale Godo nerka nena patha. Qifirnahoomen neni ooththishin nu siyidayssa hayssan ne katamanka ooththa giza leemiso inte ta bolla malatanayssas sidhey baawa” giidi istas yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Qasseka “Ta intes tuma gays nabey ba yeletida deren bonchetti erenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","“Gido attin ta intes tuma gays heedzdzu laythinne bagga gakkanaas saloy gordettin wolqama koshay biitta bolla hanida Elaasa wode he laythatan azinay baynda daro macasati Isra7eele biittan deettes shin Elaasay istafe issineykkoka kiitettibenna. Gido attin Sidoona geetettiza biittan Seraphita geetettiza kataman diza issi azinay baynda macaseykko kiitettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nabe Elisa7e wode Isra7eele deren daro inchiracha hargizayti deettes shin Sooriya biitta asa gidida Ni7imaaneppe attin he darotappe oonikka inchiracha hargefe paxibenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ayhudata Woosa Keeththan dizayti wurikka hessa siydi daro hanqettida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ba uttidasoppe dendi eqqidi Yesusa katamappe kare kessidi duge zaari yeddanas ista katamaya oosettida zuma bolla aafotizason oosettidaso ekki efida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Gido attin izi ista giddora shaakki yeggidi aadhdhi bides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Heeppeka Galila awurajjan diza Qifirnahoome geetettiza katama wodhdhides. Heenka Sambata gallas daro asa tamarso oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Izi Godateththara haasayiza gish iza timirtezan malalettida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ayhudata Woosa Keeththan tuna ayanay oykkida addey dees. Izikka ba qaala dhoqu histidi ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Naazirete Yesusa ha7i ta waanoo? Nenara tana aazi gaththidee? Ne yiday nuna dhayssanasee? Ne oonakkonne ta erays ne Xoossa Xillo gidikii?” giidi waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesusikka tuna ayanaza ha addezappe “Co7u gaada keza” giidi seerides. Tuna ayanayka daro asa sinthan addeza bollafe yeggidi issi qohokka gathonta yeddidi kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Asay wurikka malalettidi ba giddon issoy issara “Aso hayssi ay giza timirtee? Godateththaranne wolqara iita ayanan azazes; istika kezeettes” giidi haasayettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yesusa goobateththayka ubbas gakkides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Hessafe guye Yesusi Ayhuda Woosa Keeththafe kezidi Simoona keeththe gelides. Simoona bolloteya wolqama misho hargey oykin saketada dishin Yesusa izo patharkii giidi woossida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesusikka izikko shiiqidi misho hargeza seerides. Misha hargeykka yeddin heerakka denda eqqada imathata mokadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Awa arshey wullana gishin dumma dumma hargey oykkida asa wursi izakko ekki yida. Izikka hargiza asata ubba bolla ba kushe woththidi pathides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tuna ayananti qasseka Yesusa “Neni Xoossa naa” gishenne waassishe daro asatappe kezida; gido attin izi ista seerides; tuna ayananti izi Kirstoosa gididayssa eriza gish isti issinoka haasayana mala koybenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Gadey wonitishin Yesusi issi asi bayndaso bides. Daro asaykka iza koyishe izi diza so gakkides. Izi istafe shaakatidi boonta mala digganas koyda. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Gido attin istas “Gede hara katama baada Xoossa Kawoteththa Mishiraachcho qaala yootanas taas bessees; tani kiitettida gita qofay hessakko” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Izikka Yuhudan Ayhuda Woosa Keeththan qaala gujji yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Yesusi Gensereexe Abba lanqen eqqidi Xoossa qaala tamarsishin siyiza asay iza un7ethides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","He wode nam7u wogoloti abba achchan dishin Yesusi beyides. Mole oykkizayti wogolotappe wodhdhidi mole giteta meceettes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesusi wogolotappe Simoona wogolon gelidi biittafe gede abba gido shiishana mala oychidinne wogolo giddon uttidi asaa tamarsides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tamarsi wursidappe guye Simoona “Abbay ciimmatizaso shiiqa mole oykkanas inte giteza abba gido yeggite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoonay Yesusas zaaridi “Godo! Qamma kumeth daaburi aqqidi issinokka oykkibookko; gido attin ne qaalan giteza yeggana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yeggida wode daro mole oykkida. Giteyka daakkettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hara wogolon dizayti yiidi ista maaddana mala kushera wutti xeygida. Istika yiidi nam7u wogolota mole kunthida. Wogolotikka duge mitetteth oykkida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoona geetettiza Phexroosi hessa beyidi Yesusa toho bolla kundidi “Godo! Ta nagarancha gidida gish ta achchafe kichcha” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Izi hessa giday izinne izara dizayti oykkida daro molezan malalettida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Qasseka Simoona laggeti Zabidoosa nayti Yaqoobeynne Yohannisikka wuri malalettida. Yesusikka Simoona “Babbofa! Hayssafe guye ne as oykkizade gidana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Istika wogolota biittakko shiishshidi wursikka yeggi aggidi Yesusa kaallida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesusi katamatappe issineyin dishin inchiracha hargey bolla wursi oykkida issi asi he kataman dees. He addezikka Yesusa beyidi iza sinthan kundidi “Godo! Ne koykko tana pathana dandayassa” giidi woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesusi ba kushe yeddi bochchidi “Ta dosadis, paxa” gides. Inchiranchay heerakka dhayides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesusi izas “Hayssa oonaska yootoppa; Gido attin baada nena Qeese halaqas bessa; istas marka gidana mala ne geeyidayssas Musey azazida yarshoza shiisha” giidi azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Gido attin iza gish asay haasayiza worey kaseppe aakki aakki bides. Keehi daro asay iza haasaya siyanassinne bana sakiza hargefe paxanas izakko shiiqides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yesusi daro wode asi bayndaso biidi woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yesusi tamarsishin asay Galilappenne Yuhudappe qasseka Yerusalameppe yida Farsaaweetinne woga tamarsizayti heen uttida. Izi pathana mala Goda wolqay izara dees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","He wode asay issi kumeththa bollay silidi qaaxonta hargancha halara tookki ekki yiidi keeththe gelthidi Yesusa sinthan wothanas paacida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Asa daroteththafe dendidayssani keeththe gelthanas xoonettida gish pude keeththa kaara bolla kezidinne kaara qaaridi hargancha halara tookki ehidi asa giddora Yesusa sinthan woththida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesusi ista ammano beyidi “Haysso neni ne nagarappe maarettadasa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Muse woga xaafizaytinne Farsaaweeti “Hayssi Xoossa bolla xalatethan hayssatho haasayizay izi oonee? Issi Xoossafe attin nagara maaranas ooni dandayizee?” giidi qoppida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesusi ista qofa erida gish “Inte inte woznan ays hessatho qooppetii? ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘Neni nagarappe maarettadasa’ guussafenne ‘Dendada ba’ guussafe awayssi kawushee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Gido attin ta hayssa giday asa naas biitta bolla asa nagarappe maaranas godateththi dizayssa inte erana mala” gides. Qasseka he sila addeza “Nena gays! Denda eqqa! Ne hala tookkada ba!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Izi heerakka ista sinthan dendi eqqides. Kase ba ichida hala tookkidi Xoossa galatishe baso bides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","He wode asi wuri malalettides. Xoossa galatishe “Hach malalisizaz beydos” giidi daro babbida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hessafe guye Yesusi heeppe kezi bides. Lewe giza issi qaraxa qanxisizayssi qaraxa qanxizason uttidayssa beyidi “Tana kaalla” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Izikka wursi aggidi iza kaallides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Leweykka Yesusasi ba keeththan gita diggisa diggisides. Qaraxa qanxisiza daro asatinne hara asatikka istara issife maaddan uttida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farsaaweetinne ista Xaafeti “Qaraxa qanxisizaytaranne nagaranchatara issife aazas meetii?” giidi Yesusa kaallizayta bolla zuuzumetida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesusikka istas “Harganchatas attin paxa asas aakkime koshshenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Takka nagaranchata maarotethakko zaaranas yadis attin xillota xeeyganas yabeekke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Istika zaaridi “Yohannisa kaallizayti daro wode xoomettessinne woossettes. Farsaaweeta kaallizaytikka izatho ooththettes. Nena kaallizayti gidikko ubba wode meettessinne uyeettes” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesusikka istas zaaridi “Mishiray issife dishin diggissas xeeygettidayta xoomisanas bessizee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Gido attin mishiray istafe shaakettana wodey yaana isti he wode xoomana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Istas “Oorath may7oppe qanxi ekkidi gal7a may7o bolla woththi sikkizadey deenna; woththi sikkikko oorathazi gal7ara gaaggonta gish gal7aza daakkanna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Woyneppe oosettida ooratha cajje gal7a lukkamon kunthidi woththiza asi oonikka baawa; woththiza gidikko woyneppe oosettida ooratha cajjey gal7aza daakkana. Woyne cajjezikka biittan gukkana; gal7a lukkamoy sinthafe go7ontaz gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Hessa gish ooratha woyne cajjey ooratha ogoron gujettanas bessees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Histikko caala woyne cajje uyidappe guye caalontazi uyana koyizay ooninne deenna gaasoyka caalay lo7o giza gishassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Issi Sambata gallas Yesusi kaththa giddora aadhdhi bishin iza kaallizayti tiya xuphi ekkidi ba kushen shigichi mishin, ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Farsaaweetappe issi issi asati “Sambata gallas ooththanas bessontayssa ayssi ooththetii?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesusikka istas “Dawutey izara diza asati gafida wode izi ooththidayssa nababibeekketii? ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Izi Xoossa Keeththe gelidi Qeeseti xalla maana mala azazettida dumma uketha baassi miidi banara dizaytas immides” giidi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Qasseka Yesusi “Asa Nay Sambata Goda” giidi istas yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Yesusikka hara Sambata gallas Ayhuda Woosa Keeththe gelidi tamarsishin ushacha kushey silida issi asi heen dees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Muse woga tamarsizaytinne Farsaaweeti Yesusa mootanas gaaso koydi ane izi Sambata gallassan addeza pathiko beyana giidi naagishe gam7ida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesusikka ista wozna qofa eridi kushey silida addeza ubba sinthan “Denda eqqa” gides. Addezikka dendi eqqides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesusikka ista “Ta intena issi miish ane oychays; Sambata gallas ooththanas bessizay lo7o oosoyee? Iita oosoo? Shempo asho woykko dhayssoo?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Qasseka Yesusi ba yuushon diza wursi yuushi xeellidappe guyen addeza “Ne kushe piddisa” gides. Addezikka Yesusi gida mala ooththides. Iza kusheykka paxides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Gido attin asati hanqettida; Yesusa bolla ay ooththanas koshshizakkonne ba giddon zoretida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","He gallassatappe issi gallas Yesusi woossanas zuma bolla kezidi qamma kumeth Xoossa woossishe aqides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Gadey wontishin bana kaallizayta xeygidi istafe tammanne nam7ata doorides. Istaka “Hawaareta” giidi sunthides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Istika Phexroosa giidi sunthida Simoonanne iza isha Indiraasa, Yaqoobe, Yohannisa, Piliphoosa, Bartelemoosa, ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matoosa, Toomaasa, Ilfiyoosa naa Yaqoobe, ba baggas mishettiza Simoona, ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yaqoobe naa Yuhudanne Yesusa aaththi immida Asqoroonto Yuhuda. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesusikka istara issife zuma bollafe duge wodhdhidi denbason eqqides. Iza kaallizaytappe daro asay heen dees, Yuhudappenne Yerusalameppe, qasseka Xirooseppenne Sidoona Abba achchafe yida keehi daro asaykka heen dees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Istika yiday Yesusi gizayssa siyanassinne hargefe paxanassa. Tuna ayanaykka waayssizayti wuri paxida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wolqaykka izappe kezidi darota pathiza gish asay wuri iza bochchanas yides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesusikka bana kaallizaytas “Xoossa Kawoteththay intes gidida gish inteno manqotoo! Inte anjettidayta; ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Inte guyeppe kallana gish ha7i gafizayto! Inte anjettidayta; inte guyeppe miicana gish inteno ha7i yeekkizayto! Inte anjettidayta; ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","asay ta gish intena ixishin ba giddofe shaakkishin, borshininne intena iita sunthara xeygishin inte anjettidayta; ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Intes salon gita woytoy diza gish he wode ufayssan guppite; ays giikko ista Aawati nabeta bolla hessatho ooththida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Gido attin inteno dureto inte ha7i ufayettida gish intena aayye-ana! ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Inteno ha7i kallidayto intena aayye ana! Inte guyeppe gafana; inteno ha7i miicizayto! Intes aayye ana! Inte guyeppe mishetananne yeekkana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Asi wuri inte gish lo7o haasayiza wode intens aayye-ana! Ays giikko ista aawati wordo nabetas hessa mala ooththida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Gido attin ta yootizayssa siyizayto tani intes yootizay inte morketa siiqite; intena ixizaytas lo7o ooththite; ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","intena qangizayta anjite; intena qohizaytas woossite; ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Issi shagalan baqqikko, nam7antho shagala gujja bessa; ooninne ne bollara may7idayssa qaari ekkikko gaaththara may7idayssakka diggofa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Nena woossiza ubbas imma; ne miisha ekkida asi zaari immana mala oychofa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","“Asi intes ooththana mala inte koyizayssatho inteka hara asas ooththite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nagaranchatikka bana siiqizayta siiqiza gish inte intena siiqizayta xalla siiqikko intes ay dumma anjoy dizee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Inte intes lo7o ooththizaytas xalala lo7o ooththikko intes ay dumma anjoy dizee? Ayssi giikko nagaranchatikka hessatho ooththiza. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tal7e ekkidi zaarana dandayettes gizaytas xalla inte tal7ikko inte hara ay dumma anjo demmanee? Ayssi giikko nagaranchatikka isti tal7idayssa sire zaaridi ekkanas nagaranchatas tal7etes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Gido attin Xoossi bana galatontaytassinne iitatas kiya gidida mala inte morketa siiqite; lo7o ooththite; guyeppe zaaridi ekkanas qopponta dishe tal7e immite; hessanka intes kushe zaaroy gita gidana; qasseka inte wogga Xoossa naa gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Inte aaway kiya gidida mala inteka kiyata gidite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Inte harata bolla pirdofte inte bollakka pirdetenna; inte bolla pirday daronta mala harata bolla pirda darsofte; Asas atto gite inteska atto geetettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Immite! Inteska imettana; intes inte makida miishan simmidi makettana; harappeka naaqi baqqettidi yiggeti kumidi wora gukkanashe lo7o makiza miishan makettidi intes imettana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Qasseka Yesusi istas leemison “Qooqey qooqe kaalethanas dandayizee? Kaalethikkokka nam7ati issoy issara oyketidi ollan gelettennee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tamarey bana tamarsizadefe aadhdhenna, gido attin lo7ethi tamarida asi wuri ba astamare mala gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ne ayfe giddon diza tuussa xeellonta dashe ne isha ayfe giddon diza buura ays xeellay? ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ne ayfen diza tuussa beyonta ne isha ‘Tani ne ayfen diza buura ane kessays gaanas wosta dandayay?’ Neno qoodheppe qommon hanzaysso koyrottada ne ayfen diza tuussa kessa; hessafe guye ne isha ayfen diza buura kessanas lo7etha xeellandassa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Lo7o mithi iita ayfe ayfenna; qasseka iita mithi lo7o ayfe ayfenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mithi wurikka ba ayfen ayfen erettes; Agunthafe Balase geetettiza mitha ayfey maxettenna; laadeppe woyne ayfey qanxetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Lo7o asi ba wozna kumida lo7o miish kesses; iita asikka ba wozna kumida iita miishafe iita kesses; asi wurikka ba wozna kumi palahidayssa ba duunan haasayees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Tani gizayssa ooththeketa shin ays tana ‘Godo! Godo!’ geetii? ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Taakko yiidinne ta qaala siydi polizay wuri oona misatizakkonne ta intena bessana; keeththe keexanas ziqqi ooththi bookkidi shuchcha bollan ba keeththa keexida asa misatees. Haro haaththi yiidi he keeththa sugides; gido attin minni keexettida gish qaathanas dandaybenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Gido attin ta qaala siydi polonta asi ba keeththe lo7ethi baasontanne giddon shuch yeggonta keexida asa misatees; haroyka keeththa sugin keeththay heerakka kundidi iita laaleth laalettides” gi yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesusi hessa wursikka dere sinthan yooti wursidayssafe guye Qifirnahoome gizaso bi gelides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Heen Qifrnahoomen mato halaqay dees; he addezas izi siiqiza ashkaray hargidi hayqos shempo bolla dees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Izikka Yesusa gish siydi “Ba ashkara pathana mala Yesusa woosseriketii!” giidi issi issi Ayhuda bagga asatappe cimata Yesusakko yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kiitettidi bida asati Yesusakko yiidi “Hayssa addeza gish ne ashkaraza pathana bessees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ays giikko hayssi addezi nu asa daro dosees; Nuuska Ayhuda Woosa Keeththe keexisiday iza” giidi minthi woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesusikka istara bides. Yesusi addeza keeththakko matiza wode addezi ba laggeta Yesusakko yeddidi “Godo! Ne ta keeththe gelanaas bessenna; takka nena ta keeththe gelthanas bessiza asi gidonta gish haa yashe daaburoppa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Tani ne sinthan beettanas bessonta asa gidida gish neekko babeykke; hessa gish neni heen daada qaala xalla giikko ta ashkaray paxana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Taaska tana azaziza asi taappe bollara dees. Taappe garsara tani azaziza wotadarati deettes. Issa ‘Haaya!’ giikko yees; issa ‘He ba!’ giikko bees; ashkkaraykka ‘Hessa ooththa!’ giikko azazettidayssa ooththes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesusikka addezi gidayssa siydi addeza hanotethan malalettides. Guye simmidi bana kaalliza deraas “Ta intes gizay hayssa mala gita ammano haray atto shin Isra7eele nayta giddonka demmabekke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yesusakko kiitettida asati guye kiittida halaqaso simmida wode ashkaraya paxidayssa beyida ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hessafe guyen Yesusi gam7onta dishe Nayne geetettiza katama bana kaallizaytaranne daro derera issife bides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Izi biidi katama geliza miixa gakkishin he katamaype daro asay aha tookki ekkidi kezi wodhdhides. Hayqqidays ba aayeys izi mexi issino. Aayeyska azinay baawa; katamappe daro asay izira issife dees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Godayka izo beyida wode izis michetidi “Aykkoy baawa; yeekkofa!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Shiiqidinne aha tookkida hala bochchin aha tookkidayti sitti gi eqqida. Yesusikka “Haysso naazo nena gays denda!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Hayqqida naazikka suuri uttidi haasaya oykkides. Yesusikka naaza aayeys efi immides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Asay wurikka keehi babbidi Xoossa galatishe “Gita nabey nu giddofe dendides; Xoossikka hayssa dereza yiidi beydes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hayssi Yesusa gish haasayettiza lo7o haasayay kumeththa Yuhudaninne Yuhuda yuushon diza deretan kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Xammaqiza Yohannisa kaallizaytikka hayssa wursi Yohannisas yootida. Yohannisikka ista giddofe nam7ata xeygidi, ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“Izi yaana geetettidi haasayettizays neneyee? Hara as naaginoo? gi oychite” giidi Godakko yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bida asati Yesusakko gakkidi “Xammaqiza Yohannisi ‘Izi yaana geetettidi haasayettizayssi neneyee? Hara as naaginoo?’ giidi neekko nuna yeddides” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","He wode Yesusi daro asa waayeppe, hargefenne tuna ayanatappe pathides. Daro qooqeta ayfeykka xeellees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yohannisi kiittin izakko yidayta “Biidi inte inte ayfera beyidayssanne siyidayssa Yohannisas yootite. Ayfe qooqeti xeelletes; toho wobeti suure hamutettes; inchiracha hargizayti paxida; tulleti siyida; hayqqidayti hayqoppe dendida; manqotas Mishiraachcho qaalay yootettes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tanan dhuphetonta asi wurikka anjettidayssa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yohannisi kiittida asati Yesusa achchafe bidayssafe guye Yesusi daro asas Yohannisa gish “Inte ay beyanas bazzo kezidetii? Carkoy heenne haane qathethiza shomboqo beyanassee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ay beyanas kezidetii? Lo7iza may7o may7ida as beyana kezidetii? Lo7o may7o may7idi warix gizayti ishalo duussa dizayti kawo keeththan deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Histikko ay beyanas kezidetii? Nabe beyanassee? Ee ta intes tuma gays; inte keziday nabeppe aadhdhizadde beyanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Xoossa qaalan ‘Ne baana oge nees baasi lo7ethana kiitettida as ta neeppe sinthara yeddana’ geetettidi iza gish xaafettidays izakko. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Tani intes gizay macasappe yeletida asa giddon Yohannisappe aadhdhizadey oonikka deenna; Xoossa Kawoteththan gidikko asa ubbafe guuth geetettida asi Yohannisappe aadhdhana” gi yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Qaraxa qanxisizaytikka attonta hayssa Yesusa qaala siyidayti wurikka Yohannisa kushen xammaqettidi Xoossas bessiza boncho immida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Farsaaweetinne Muse woga eranchati Yohannisa kushen xammaqettonta gish Xoossi istas waanna qofa ooththidi shiishidayssa hiraayssida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Qasseka Yesusi zaaridi “Histikko ha7i yeletta aazan leemiso? Isti ay misatizoo? ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Giyan uttidi ba giddon issoy issara xeeygettidi ‘Intes nuni diith diixxidos shin duribeekketa; zilalis zilalidos shin yeekkibeekketa; giza nayta misateetes’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ays giikko Xammaqiza Yohannisi kath moontanne woyneppe oosettida cajje uyonta yiin ‘Daydanthi iza bolla dees’ gideta. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Asa nay qasse mishenne uyishe yiin ‘Ganjamanne ushshancha; qaraxa shiishshizaytaranne nagaranchatara laggetees’ gideta. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Hessa gish eratetha tumatethay izi nayta ubbata achchan ammanettides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Hessafe guye Farsaaweetappe issi asi Yesusa quma maanas ba keeththe xeygin Yesusi xeygida Farsaawe keeththa biidi uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","He kataman diza issi nagarancha macas dizaara Yesusi Farsaawe keeththan quma maadda bollan dizayssa siyada issi albasxiroose bilqaaxe shitto ekka yadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yaadanne Yesusappe guyera iza toho achchan eqqada yeekkashenne ba afunthan iza toho caphisada ba hu7e binanara quccashenne yeerashe shitto tiyadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yesusa qumas xeeyssida Farsaaweykka hessa beyidi “Hayssi addezi nabe gididakko hanna iza bochchida macasaya iza oonakkonne ay ooththiza asakkone eranakko shin; iza nagaranchakko shin” giidi ba woznan qoppides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesusi “Simoona! Nees ta yootanazi dees” gides. Simoonaykka “Astamaare! Ero yoota” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesusi zaaridi “Issi miishe tal7e immizaddefe tal7e ekkida nam7u asati deettes; istafe issa bolla ichashu xeet dinarey dees; nam7anthoza bolla ichashu tammu dinarey dees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Istas qanxiza miishi dhayin tal7e immidayssi nam7ata accoza wursikka maarides. Histikko ha nam7atappe ha tal7e immidayssa darsi dosanay awayssee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoonaykka zaaridi “Daro acoy maarettidayssa gaada qoppays” gides. Yesusikka “Tumu pirdadassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","He macasaykko yuuyidi Simoona “Hanno macasayo xeellay? Ta ne keeththe gelin ne ta tohos haaththe shiishabeekka; iza gidikko ta toho ba afunthan caphisada ba hu7e binanara quccadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Neni ubbakka tana yeerabeekka; iza gdikko ta gelosoppe oykkada ta toho yeero aggabeekku. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ne ta hu7e zayte tiyabeekka shin iza gidikko ta toho shitto tiyadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","“Hessa gish ta nena gizay iza tana keeha dosida gish iza ba daro nagarappe maarettadus; guuthara maarettiza asa siiqoykka guutha” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesusi macasayo “Ne nagarappe maarettadasa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Izara issife maaddan uttida imathatikka “Hayssi nagara maarizay izi oonee?” giidi ba woznara qoppida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesusikka macasayo “Nena ne ammanoy ashshides; saron ba!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Hessafe guye Yesusi Xoossa Kawoteththa Mishiraachcho sabakishe dumma dumma katamata giddoranne gutata giddora aadhdhides. Aadhdhidi biza wode iza kaalliza tammanne nam7ati izara deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Qasseka tuna ayanappenne iita hargefe paxida issi issi macasati izara deettes. Istika laapun tuna ayanay izippe kezida Magdale getettiza dereppe yida Maaramo, ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Kawo Herdoosason ooththiza Kuza macho Yohaano qasseka Soosinonne hara daro macasati deettes. Istika baas diza miishara Yesusas ooththizayta. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Daro derey issife shiiqidi dishin qasseka asay dumma dumma katamappe izakko wodhdhiza wode Yesusi leemisora tamarsishe, ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Issi goshshanchay zerethi zeranas kezides; izi zerishin baggay ogen wodhdhidi asa tohon yedhettides; salo kafotikka yiidi maxi mida; ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Issi zerethay shuchcha gaden wodhdhidi heerakka caarides; gadezikka mela gade gidida gish elle melichides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Qasseka hara zerethi aguntha giddon wodhdhides; agunthayka izara issife diccidi caarechchaykka dicconta mala cuullides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Qasseka hara zerethay lo7o aradda gaden wodhdhides; caarida wodekka xeetu kushe ayfides” gides. Yesusi haasaya wursidi qaala dhoqu histidi “Siyiza haythi diza asi siyo!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesusa kaallizayti “Zeretha leemisozas birsheth imma” giidi oychin, ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Izikka istas “Xoossa Kawoteththa xuura eroy intes imettides; haratas gidikko leemisora yootays qasseka harati beyidi woznan woththonta malanne siydi yuushi qopponta mala hanides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Zeretha leemisoykka hayssa; zereth geetettidaysi Xoossa qaala. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Oge lanqen wodhdhidayssi qaala siyizayta; giddo attin isti ammanidi attonta mala Xala7ey yiidi qaala ista woznappe ekkichizayta. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Shuchcha bolla wodhdhidaytikka qaala siydi ufayssara ekkizayta; istika ha7is ammanettes attin metoy ista bolla gakkiza wode xapho yeddonta gish ellera ammano kaddizayta. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Aguntha giddon wodhdhidayti qaala siyizayta; heytikka hayssa ha alame qofaninne aqotan, hayssa biitta bolla duussa lo7etethan cuulettidi lo7ethi ayfe imettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Aradda biittan wodhdhidayssi qaala suureninne lo7o woznan siydi naagizaytanne dandayan minnidi ayfe ayfizayta. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Poo7o poo7isidi baatha giddon woykko arsa giddon woththiza asi baawa; gido attin keeththe geliza asas poo7ana mala qonceson wothettes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Qotettidi qonce kezontay; poo7on kezidi eretontta geeman attana miishi deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Hessa gish inte siyizayssa naageti siyite; diza asas gujettana bayndades ubbafe izas diza misatizarakka ekettaychana” gi zarides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Hessafe guye Yesusa aayanne iza ishati Yesusakko yida. Gido attin asa daroteththafe dendidayssan izakko shiiqanas dandayibeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","He wode asay Yesusas “Ne aayeyanne ne ishati nena beyanas koydi karen eqqida” giidi yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesusikka zaaridi “Ta aayanne ta ishati Xoossa qaala siydi naagizayta” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Issi gallas Yesusi bana kaallizaytara wogolo giddo gelidi “Abbafe he pinth pinnoos” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Istika pinnishin abba bolla dambalay dendidi waayssiza wode Yesusi dhiskides. Haaththayka wogoloza giddo gelin asay daro metotettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yesusa kaallizayti izakko shiiqidi “Godo! Godo! Nu wurana hanoos” giidi Yesusa dhiskofe denthida. Izikka beeggidi carkozanne abba dambala seerin carkoynne abba dambalay co7u gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Izikka bana kaallizayta “Inte ammanoy awa bidee?” gides. Istika ba giddon babbishenne malalettishe “Carkonne haaththe azazizay; istika Izas azazettizay izi oonee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Izappe guye Galilappe he pinthan diza Gergesenoone geetettiza dere wogolora pinnida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesusi wogolozappe gaden wodhdhida wode daydanthi iza bolla diza issadey katamappe kezidi iza demmides. He addezi daro wode may7o may7onta kallo dizaddenne keeththan aqonta duufo baas aqoso ooththida asa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Yesusa beyida wode waassishe Yesusa sinthan kundides; qaala dhoqu histidi “Boncho Xoossa Naa Yesusa! Taasinne nees ay gaytoteththi dizee? Ne tana waayssonta mala ta nena woossays” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tuna ayanay hessa gaanas dandayiday addezappe kezana mala Yesusi azazida gishassa. Tuna ayanazikka woden woden dendiza gish addezi sansalataninne biratan toho qachchi naaginka qashetida sansalata duuthereththidi iza bolla diza daydanthay iza duge bazzo zaari efees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesusi “Ne sunthi oonee?” giidi oychides; izikka daro daydanthati izan gelidi diza gish ta sunthi “Leegone” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Daydanthatikka bana wursethi baynda ciimma ollan yeggonta mala minthidi woossida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Henka zuma bolla daro guddunthi heemettes; daydanthatti “Gudduntha wudezan gelite” giidi azazana mala woossin Yesusi “Ero gelite!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Daydunthati addezappe kezidi guddunthatan gelida. Guddunthati aafoza dugunthara bicharshe biidi abban gelidi abban mitettida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Heemizayti hanidayssa beyida wode beerotti biidi katama asassinne dere asas yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Handayssa beyana giidi asay ba dizasoppe Yesusakko yides. Daydanthay izappe kezida addezikka woznay kahay simmin afala ma7idi Yesusa toho giddon uttidayssa beyidi babbida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Daydanthan oyketida addezi paxishin beyidayti izi waani paxidakkonne derezas yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gergesenoone matan diza asay keehi babbida gish Yesusa “Hayssafe kichcha!” giidi woossida; Izikka wogolozan gelidi simmi bides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Daydanthay izappe kezida addezi Yesusara issife daana mala woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Gido attin Yesusi iza “Neso simmada Xoossi nees ooththida gita miish yoota” giidi moyzides. Addezikka Yesusi izas ooththida gita miish ba kataman diza asas ubbas qoncen yootishe bides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Asay wuri Yesusa yuussa naagishe gam7ida gish izi simmishin ufayssan mokki ekkida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","He wode Iya7iroosa geetettiza Ayhuda Woosa Keeththe halaqay yiidi Yesusa toho bolla kundidi baso baana mala woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Izi hessatho oychiday izas tammanne nam7u layth kumida issi maca nay sakettada shempo bolla diza gishassa. Izi hee buussan dishin derey daridi ba giddon sugettidi iza keehi un7isides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tammanne nam7u layth suuthi izippe gukkishin diza issi macasaya baas diza miisha wursa dhale eriza asatas imma wursin izo pathanas dandayida asi issadeyka baawa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Izakka guyera shiiqada Yesusa afala macarata bochchadus; izippe gukkiza suuthay heerakka eqqi aggides ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesusikka “Tana bochchiday oonee?” gides. Wurikka nuni bochchibeekko gi kadida wode Phexroosi zaaridi “Godo! Asi wuri yuuyi aadhdhidi nena suggerethidi un7isees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Gido attin Yesusi “Asi tana bochchides; wolqay taappe kezidayssa ta erays” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Macasaya eretonta qotettada baanas dandayontayssa erada kokkorashe yaada Yesusa sinthan kundadus. Izakka Yesusa waana bochchidakkonne qasseka ellera waana paxidakko ubba asa sinthan yootadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Izikka “Ta naye! Ne ammanoy nena pathides; saron ba!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesusi buro macasays haasaya bolla dishin Ayhuda Woosa Keeththe halaqa Iya7iroosa keeththafe issi asi Iya7iroosas “Ne naya hayqqadus; hessa gish hayssafe guye astamareza mela daabursofa!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesusi hessa siydi Iya7iroosa “Aykkoy ba; babbofa! Ammana attin ne naya paxana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesusi Iya7iroosa keeththe geliza wode Phexroosa, Yohannisanne Yaqoobe qasseka nay aawappenne aayeyippe attin haray oonikka izara gelana mala koybenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","He wode asay wuri nays “Wuu wuy!” gi waassi yeekkishin Yesusi “Yeekkofte iza ichchadus attin hayqqabeekku” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Asaykka naya hayqqidayssa eriza gish Yesusa bolla miicides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Gido attin izi nay kushe oykkidi “Ta naye! Denda!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nays shempoykka simmides. Heerakka denda eqqadus; Yesusikka izis miza miish immana mala azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nayo yelidaytikka malalettida. Gido attin izi hanidayssa oonaska yootonta mala azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesusikka tammanne nam7u Hawaareta issife xeygidi daydanthata kessana malanne hargefe pathana mala istas wolqanne godateth immides: ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Qasseka Xoossa Kawoteththa yootanassinne hargizayta pathanas ista kiittides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Istas “Oge bishe guufe woykko, qaraxite woykko, quma woykko, miishe woykko nam7u may7o oykki baanas koshshenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Inteka he katamaype kezana gakkanaas koyro gelida oona keeththanka gidin heen gam7ite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Katama asay intena mokki ekkonta ixikko he katamaype kezidi intena mokkontaytas marka gidana mala inte tohon diza gudulla pittidi kezite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Istika Goday gida mala kezidi Mishiraachcho qaala yootishenne harganchata pathishe gutan gutan yuuyida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","He wode issi issi asati “Yohannisi hayqoppe dendides” baggayti “Elaassi kezidi beettides.” Qasse baggayti “Beni nabetappe issoy hayqoppe dendides” giidi haasayettiza gish Yuhuda biitta haariza Herdoossi hessa siydi haniza miishan ba woznan metotettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herdoosikka “Tani iza qoodhe qanxida Xammaqiza Yohannisi hayqides. Histin iza gish hayssa mala haasayettishin ta siyizays izi oonee?” giidi iza ba ayfera beyana koydes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Hawaaretikka simmidi isti ooththidayssa wursi Yesusas yootida. Izikka ista xalla banara ekkidi Betesayda geetettiza pooqethan diza katama bides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Gido attin daro asay hessa eridi ista kaallides. Izikka ista mokki ekkidi Xoossa Kawoteththa gish yootides. Qasseka hargefe pathanas bessizayta pathides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Gadey lem7ishin tammanne nam7u Hawaareti izakko shiiqidi “Nuni dizay bazzo biittan gidida gish asay biidi baas aqanasonne miza miish koyana mala asa moyza” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Gido attin izi istas zaaridi “Inte istas mizaz immite” gides. Istika “Nuus ichashu ukethafenne nam7u moleppe haray ba. Ha asas gidiza kath koshshikko shammanaas bessees” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Yesusikka bana kaallizayta “Asa ichashu tammu, ichashu tammu histi shaakki shaakki utisite” gides. Heenka ichashu shi gidiza attumasay dees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yesusa kaallizaytikka Yesusi azazida mala asa wursi utisida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesusikka ichashu ukethanne nam7u moleta oykidi pude salo xeelidi Xoossa galatides. Izikka uketha menthidi asa gaththana mala bana kaallizaytas immides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Asay wurikka miidi kaallides. Yesusa kaallizaytikka asappe attida tammanne nam7u leemate kumeth maaddafe denthida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Issi gallas Yesusi barka woossishin iza kaallizayti izakko yida. Izikka ista “Asay tana oona gizee?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Istika izas “Issi issi asay Xammaqiza Yohannisa; baggayti Elaasa; harati qasse beni nabetappe issoy hayqoppe dendides geetes” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Izikka ista “Intech tana oona geetii?” giidi oychides. Phexroosikka “Neni Xoossafe kiitettida Kirstoosa” giidi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesusikka ista “Hayssa oonaska yootoppite” giidi minthi yootidi ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Qasseka “Asa Nay daro waaye ekkanas bessees; dere cimatan, Qeese halaqataninne Muse woga xaafizaytan ixettananne ista kushen hayqqanassinne heedzdzantho gallassan hayqoppe dendana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","24","Qasseka ubbas “Ba shempo ashshana giza asi wuri dhayssana shin ba shempo ta gish giidi dhaysiza asi ashshana. Hessa gish tana kaallana koyiza asi diikko bana kaddo; ubba gallas ba masqale tookkidi tana kaallo. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Asi alame go7a mule demmidi ba shempo dhayssikko aaza go7ay dizee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Oonikka tananinne ta qaalan yeelattikko Asa Nay ba bonchora, Aawa bonchoranne Geeshsha kiitanchata bonchora yiza wode tani izan yeelatana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ta intes tumu gays; hayssan eqqida asappe hayqqanappe sinthan Xoossa Kawoteth beyana issi issi asati deettes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesusi hessa gida osupun gallassa malappe guye woossanas zuma bolla kezides. Bishe banara Phexroosa, Yohannisanne Yaqoobe ekki bides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Izi woossishin iza ayfesoy laamettides. Iza medhaykka wolqantha mala xoliqidi boottiides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nam7u asati Museynne Elaassi izara haasayettida ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Istika bonchora qoncidi Yerusalamen polettana diza Yesusa hayqo gish haasa7ettida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Phexroosanne izara dizayta deexo dhiskoy oykkides. Istika dhiskofe beeggidi Yesusa bonchonne nam7u asi izara eqqidayta beyida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","He nam7u asati Yesusappe shaaketi bishin Phexroosi Yesusa “Godo! Issi daase nees, issi daase Muses, issi daase Elaasas ooththidi haan dizaakko nuus lo7okko! Shin” gides. Gido attin Phexroosi ba gizayssa eronta gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Izi hessa haasayishin shaaray yiidi ista geenthides. Shaara giddo gelidi babbida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Shaara giddofekka “Tani doorida ta nay hayssa; iza siyite” giza qaalay seetettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Qaalay seetettida wode Yesusi xalla beettides. Yesusa kaallizaytikka hanida miisha wursi ba woznan oykkida attin oonaska yootibeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wontetha gallas isti zuma bollafe wodhdhin daro asay yiidi Yesusara gaaggides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","He wode asa giddofe issadey qaala dhoqu histidi “Tamarisizaysso! Taas issi nay xalla diza gish iza ne xeellana mala ta nena woossays. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Iza iita ayanay oykkishin hassa7ay baynda waasses; qaketishe duunara gopponto kessees; qoho gaththidappe guye daro waayssidi aggees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nena kaallizayti naazappe kessana mala ista ta woossadis; gido attin kessana dandayibeetenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesusikka istas zaaridi “Ammanonta ha wode wobe asato! Tani intenara ayde gakkanaas daanee? Intenaka ayde gakkanaas dandayanee? Naaza ane ha eha!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Naazi yishin iita ayanay iza bollafe yeggin qaketides. Yesusikka iita ayanaza seeridi naaza pathidi naaza aawas immides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Asaykka wuri Xoossa gitateththan malalettides. Izi ooththidayssan asay wuri malaletishin Yesusi bana kaallizayta ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Asa nay asa kushen aadhdhidi imettana; inteka ha yo7oza baloppite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Gido attin izi gizayssi istas gelibeenna. Ays giikko isti akeekkonta mala yo7ozi istafe geemettides; zaaridikka oychonta mala babbida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Iza kaallizayti “Ooni oonappe aadhdhizee?” giidi ba giddon palamettida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesusikka ista wozna qofa eridi guutha naa ekki yiidi ba matan essidi ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Ha guutha naa ta sunthan ekkizaddey oonikka diikko tana ekkees; tana ekkizaddeyka tana kiittidayssa ekkees. Inte ubbafe guutha asi izi ubbaafe aadhdhees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohannisikka “Godo! Issi asi ne sunthan daydanth kessishin beydos. Gido attin izi nunara kaallonta gish digganas koydos” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesusikka “Intena ixonta asi wuri inte bagga gidida gish diggofte” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesusi salo biza wodey matida gish Yerusalame baanas dendides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Izikka sinthathidi ase kiittides. Istika koshshiza miish giigissanappe kasetidi Samaariya biittan diza issi guta bida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Gido attin derey izi Yerusalame bizayssa erida gish mokki ekkibeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Iza kaallizaytappe Yaqoobeynne Yohannisi hanizayssa beyidi “Godo! Elaassi ooththoyssatho ‘Tamay saloppe wodhdhidi ista dip histo!’ giidi azazana mala koyay?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Gido attin Yesusi Istako yuuyidi “Intes ay mala ayanay dizakkonne erekketii? Asa Nay yiday asa shempo ashshanas attin dhayssanas gidenna” giidi ista seerides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Isti wurikka hara guta bida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Istika birshin issi asi istako shiiqidi “Tani neni biza ubbaso nena ta kaallana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesusi “Workenatas aqiza ollay, kafotas qasse aqiza kafo keeththi dees; gido attin asa naas ba hu7e ayssizasoykka baawa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesusikka hinkoyssa “Tana kaalla” gides. He addezikka “Godo! Ta kaseta baada ta aawa moogoo?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesusikka “Aggaga, hayqqidayti hayqqidayta moogeto. Neni gidikko baada Xoossa Kawoteththa asas yoota” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Qasseka hara asi “Godo! Ta nena kaallana shin koyro soo baada ta keeththa asa saro gaada yo7oo?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Gido attin Yesusi “Boora kaso oykkidi goyishe guye zaari xeellizadey oonikka Xoossa Kawoteththas bessenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hessafe guye Goday hara laapun tammanne nam7u as dooridi sunthides. Istaka nam7u nam7u histidi izi baana sohotanne katamata wursikka isti kasetidi baana mala kiittides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","“Maxa gakkida kaththay daro; kaththa maxi shiishshizayti guuthata hessa gish kaththa Goday kaththa maxidi shiishshizayta kaththay dizaso yeddana mala woossite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Hessa gish biite dorsati kana suyte giddora biza mala ta intena yeddays. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Korojo woykko qaraxite woykko caamma ekkofte; oge bolla oonakka saro gooppite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Inte oona keeththika geliza gidikko koyrottidi ‘Keeththa aso saro!’ giite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","He keeththan saro dosiza asi diikko inte sarotay he keeththan shempana; saro dosiza asi doonta aggikko inte sarotay intes simmana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Intes maana shiishida kath wursi miishenne uyishe he inte gelida keeththan uttite; ooththizades ba wolqa waaga ekkanas izas bessees. Ha keeththafe he keeththe yuuyoppite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Inte ay katamakka gakkiza wode asay intena mokki ekkikko isti intes aaththida quma miite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","He kataman diza harganchata pathidi Xoossa Kawotethi inteko matides giidi yootite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Gido attin inte biidi issi katama gelishin he katama asay intena mokki ekkonta ixikko he katama asay shiiqiza dubbushsha kezidi; ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nu toho bolla diza inte katama gudulla intes marka gidana mala nu toho bollafe pittoos shin Xoossa Kawoteththay inteko matidayssa erite’ giite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ta intes yootays pirda gallas he katama pirdafe Soddome katama pirday kawushshe gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kuraziine nena aayye-ana! Betesayda nena ayye ana! Intenan oosettida malatati Xirooseninne Sidoonan oosettidakko istika may7o may7idinne bidinth gorpettidi he wode beni maarettanashin. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gido attin pirda wode intefe Xiroosessinne Sidoonas kawuyana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Hanne Qifirnahoome pude salo dhoqu dhoqu gadii? Neni duge Si7oole wodhdhana, ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Inte gizayssa siyiza asi tana siyees; intena ekkonta asi tanakka ekkenna; tana ekkontaykka tana kiittidayssa ekkenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Laapun tammanne nam7atikka ufayetishe simmidi “Godo! Haray atto shin daydanthatikka ne sunthan nuus haarettida” giidi yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Izikka istas “Xala7ey wolqantha mala saloppe kundishin ta beyadis. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","“Histikko shooshanne masimaso inte yedhana mala morke wolqa ubba bolla intes godateth immadis; intena qohiza issi miishika deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Inte sunthay salon xaafettida gish ufayettite attin tuna ayanati intes haarettida gish ufayettofte” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","He wode Yesusi Xillo Ayanan ufayettidi “Salossinne sa7as Goda gidida abbo hayssa wursaka aadhdho eranchatappenne erachatappe qottada qeeri guutha naytas ne qoncisida gish tani nena galatays; ee, ta Aawawu! Hayssi ne lo7o sheney hanides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Wuri ta Aawa matappe taas imettides; qasseka iza nay oonakkonne Aawappe attin erizay baawa. Aaway oonakkonne Naazappe attin woykko Naazi izas qoncisanas dosidadeppe attin erizadey baawa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Bana kaallizaytakko simmidi istas dumma “Inte beyizayssa beyiza ayfeti anjettidayta. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ta intes tuma gays daro nabetinne kawoti inte ha7i beyizayssa beyanas koydi beybeetenna; inte ha7i siyizayssakka siyanas koydi siybeetenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Issi gallas Muse woga tamarsiza issi asi Yesusa paacanas koydi “Tamarisizaysso tani merna de7o laattanas ay ooththoo?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesusikka zaaridi “Woga maxaafan ay geetetti xaafettidee? Izappe nees geliday aazee?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Addezi zaaridi “Ne Goda Xoossa ne kumeththa woznappe, ne kumeththa shempofe, ne kumeththa wolqafenne, ne kumeththa qofappe siiqa; ne laggeka ne hu7e mala siiqa gees” giidi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesusikka “Lo7o zaaradasa. Nenikka hessatho ooththikko merna de7o demmana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Addezi bana xillisanas koydi “Histin ta laggey oonee?” giidi Yesusa oychides ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesusikka zaaridi “Issi addezi Yerusalameppe Iyarko wodhdhishin pangati demmidi iza may7o qaari ekkida; keehi qoxerethidi hayqoppenne paxappe giddon yeggi aggidi bida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Issi Qeesey he ogera baassi duge wodhdhishe aamunsonta he qoxettida addeza demmidi pooqethara yeggi aadhdhides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Qasseka issi Lewe bagga asappe issi addezi he ogera aadhdhishe qoxetida addeza beyidi ha7ikka pooqidi aadhdhides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Issi Samaariya biitta asi he ogera aadhdhi bishe qoxettida addeza bolla gakki wodhdhides; Addeza beyidinne keehi mishettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Addezakko shiiqidinne maduntha dhallana mala wogara mitha zaytenne woyne caje maduntha bolla gussidi qachchides; Addeza ba Hare togisidi imaththi shempizaso efidi lo7ethi xeellides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Wontetha gallas imaththi shempiza keeththa godas nam7u dinare immidinne ‘Nena hara miisha kessisikko ta simmashe nees immana; neeppe kessada lo7etha naaga’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Histikko ha heedzdzu asatappe pangatan qoxettidi hayqoppenne paxappe giddon yegettidades keehi mata laggey nees awayssa misatizee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Muse woga tamarsizaysikka “Heesi ne michetidayssanne maaddidayssa!” gides. Yesusikka izas “Nekka baada izayssatho ooththa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesusinne iza kaallizayti oge bishin Yesusi issi guta gelides; Marta geetettiza issi macasiya bason Yesusa mokka ekkadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Izis Maaramo geetettiza issi micheya dawus. Maaramakka izappe qaala siyashe Goda toho garsan uttadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Gido attin Martay ooso daroppe dendidayssan daaburada Yesusakko shiiqada “Godo! Ta michiya ooso wursa ta bolla aggada uttishin neni co7u gay? Iza tana maaddana mala izis yoota attin” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Gido attin Goday “Hanne Martane! Neni daro miisha gish qofa daraasa; dirbataasa; tuggataasa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Koshshizay gidikko issi miish xalla; Maaramakka lo7o exa dooradus; hessika izippe ekettenna.” ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Issi gallas Yesusi issison woossides; izi woossa wursishin iza kaallizaytappe issoy “Godo! Xammaqiza Yohannisi bana kaallizayta woossa tamarsidayssatho nekka nuna woossa tamarsa!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Izikka istas “Woossishe ‘Nu Aawawu! Ne sunthi anjetto; ne kawotethi haayo; ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","hachchis gidiza quma nuus imma; ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","nuna qohidayta nu maariza mala nuna maara; paacenka nuna gelthofa’ gi woossite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Qasseka “Intefe issaddes laggey diikko leela gidoth he laggezaso biidi ‘Taas issi imaththi ogeppe yiin mizana kath baynda gish heedzdzu solloy diikko taas tal7arikii?’ ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Laggezikka zaaridi ‘Tana waaysoppa; kareykka gordettides; tanikka naytara ichchadis. Ha7i dendada immanas dandaykke’ gaandee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Takka intes yootays laggetetha gish dendidi immonta aggikkokka izi oychon salethida gish dendidi koyizayssa wursi immides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Hessa gish tani intes gizay; woossite intes imettana; koyite inte demmenna; kare qoxite intes doyettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ays giikko woossizay wuri ekkana; koyizaykka demmenna kare qoxizadeska doyettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Intefe aawa gidi uttidi izi yelida nay mole oychikko shoosh immizay daandee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Woykko phuuphulle oychikko masimaso immizay daandee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Inte iitata gidishe inte naytas lo7o imota imo erikko; salon diza inte Aaway bana woossizaytas Xillo Ayanan wosti darsi immenee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Issi gallas Yesusi haasayssonta duude daydanth kessides. Daydanthazikka kezidappe guye duuna duude addezi haasaydes; beyida asatikka darsi malalettida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Gido attin issi issi asati “Bi7elizeebula geetettiza daydanthata halaqan daydanthata kessees” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Issi issi asay iza paacanas “Saloppe malata bessa” giidi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Gido attin Yesusi ista qofa eridi “Ba giddon shaakettiza kawotethi wuri dhayana; ba giddon sigay baynda keeththikka kundana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Inte tana ‘Bi7elizebulan daydanthata kessees’ giidi haasayeta shin Xala7eykka ba giddon issoy issafe shaaketikko iza kawotethi waani minnanee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Histikko tani daydanthata Bi7elizeebula kessikko inte nayti oonan kessandetoo? Hessa gish inte nayti inte bolla pirdizayta gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Gido attin tani daydanthata kessizay Xoossa wolqan gakkides; Xoossa Kawoteththay inteko matidaro erite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mino asi lo7ethi gixxettidi ba keeththe naagikko keeththan diza miishi lo7on naagettes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Gido attin izappe hara mino asi yiidi xoonikko izi ammanettida ola miishata woththi ekkidi izas diza haarozakka wursi haras gishanna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Tanara gidontay tanara eqettes; tanarakka shiishontadey laalles, ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Tuna ayanay asappe kezida wode shemposo koyishe haaththi baynda mela soon waayetees; shemposoy dhaykko ‘Tani kase kezidaso guye simmana’ gees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Izappe simmidi yishin kase izi aggi bida keeththay pitettidinne giigi uttidayssa demmees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Hessafe simmi biidi baappe iitiza hara laapun daydanthata banara ekkidi yees; istika gelidi heen daana; Hessadeska koyroyssafe guyeyssi keehi iita gidana” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesusi hessa haasayiza wode asa giddofe issi macas dizaara ba qaala dhoqu ooththada “Nena tookkida qanthinne ne dhammida dhanthati anjettidayta” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Gido attin izi “Anjettidayti Xoossa qaala siydi azazettizayta” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Daro derey Yesusakko shiiqida wode Yesusi “Hayssi yelettay iita yeletta; gita malata beyanas koyees. Gido attin Yoonaasa malatappe hara dumma malatay imettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Gaasoyka Yoonaassi Nanawe asas malata gidida mala asa nay tani ha yelettas malata gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Dugeha dere maca kawoya Solomoone erateth beyanas biitta gaxappe dendada yida gish pirda wode iza ha yelettara dendada pirdana; hekko Solomooneppe aadhdhizaddey haan dees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Yoonaassi sabakishin siydi Nanawe asay ba nagarappe maarottida gish ha yelettara issife dendidi pirdana. Gido attin Yonaasappe aadhdhizay haan dees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Xompe oythidi kareppe geliza asas poo7ana mala qonceson wothetes attin geemason woththiza asi deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ne asatethas poo7oy ne ayfe; ne ayfey paxa gidikko ne kumeththa asatethay po7o gidana. Ne ayfey saketikko ne kumeththa asatethay dhuma gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hessa gish nenan diza poo7oy dhumonta mala naagetta. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Histikko ne asatethay poo7o gidikko dhumida asatethi deenna aggikko ne kumeththa asatethay xompe lo7ethi poo7iza mala lo7i beettanna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesusi haasaya wursida mala issi Farsaawey banara quma maanas Yesusa xeygides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yesusi quma maana kushe mecetonta aggidayssa beyidi malalettida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Goday izas “Ha7i inte Farsaaweeti xu7assinne keres bolla bagga meeci geeshsheta; inte gido baggazi uzetethaninne iitatethan kumides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Inteno eeyato! Kare bagga medhdhiday gido bagga medhibenee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yo7on gidikko giddon dizayssa muxuwata immite; he wode wurikka intes geesh gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Inteno Farsaaweeto! Intes ayye ana! Anugappenne xalotappe qasseka dumma dumma kathafe tammafe issino kesseeta; gido attin tuma pirdanne Xoossa dosanayssa aggi aadhdheta. Yo7on gidikko inte aggi aadhdhanas bessenna. Hankoyssa aggonta inte ooththana bessizaytikka hayta. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Inteno Farsaaweeto! Intes aayye-ana! Ayhuda Woosa Keeththan uttanas boncho oyde koyeeta; giya giddonka asay inte sinthan hokkana mala doseeta. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Asi eronta iza bollara biza qotetti diza duufo inte misattiza gish intena aayye-ana!” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Muse woga erizaytappe issoy zaaridi “Astamaare! Ne hessatho haasayiza wode nunakka cayaassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesusikka zaaridi “Inteno Muse woga erizaytto inteska aayye-ana! Asi tookkanas dandayonta deexo tooho asa toosseta. Inte gidikko intes biradhdhe xeeranikka bochchekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Inte Aawati wodhida nabeta duufo inte lo7ethiza gish intes ayye ana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Histikko inte inte aawata ooso minthiza markata; isti nabeta wodhida; inteka ista duufo lo7etheeta. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Hessa gish Xoossa erateth hizgadus ‘Nabetanne Hawaareta ta istas yeddana; istika istafe issa issa wodhana; haratakka gooddana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Hessa gish ha yelettay biittay medhettosoppe ha7i gakkanaas gukkida nabeta ubba suutha gish oyshettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aabeele suuthafe oykkidi yarshizasoppenne Xoossa Keeththa giddon gukkida Zakaraasa suutha gakkanaas koyeettes.’ Ee ta intes gizay ha yelettay hayssas oyshettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Inteno woga erizayto! Intes aayye-ana! Eratetha penge qulfe wolqara woththi ekkidi inteska gelibeekketa; gelanaytaka diggeeta” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesusi heeppe kezidappe guye Xaafetinne Farsaaweeti eqettishe oyshan shempo diggida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Iza duunappe keziza qaalan iza qaxanas naagettida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","He wode daro derey ba giddon issoy issara yedhettana gakkanaas shiiqi uttidashe Yesusi bana kaallizayta “Farsaaweeta irshofe naagettite; hessika qoodheppe qommo hano. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Qonconta kamettidi attanaynne erettonta qotan attana miishi deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hessa gish inte geeman haasayidazi wuri qonce kezana; qasseka inte qol7an haythan sasuketi haasayidazi wuri dere sinthan yootettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ta laggeto! Ta intes gizay asho xalla wodhanappe attin hara aykkokka ooththanas dandayontaytas babbofte. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Gido attin inte babbanas bessizay oonakkonne ta intena bessana; asho wodhidappe guye ashonne shempo issife gaththi Gaanname taman yegganas dandayizayssas babbite. Ee izas babbite gays. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Siine kafo ichashati nam7u santes bayzettetes; gido attin istafe issiniyoka Xoossi dogenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Inte hu7e binanay kumeth taybon dees. Hessa gish babbofte; daro Siine kafotappe inte aadhdheta. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ta intes yootays ta gish asa sinthan markattiza asa ubbas Asa Nay qasseka Xoossa kiitancha sinthan iza gish markattana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Gido attin asa sinthan tana kaadidadey Xoossa Kiitancha sinthan kaadettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Asa Naa bolla kawushsha qaala haasayizades nagaray wuri maarettana shin Xillo Ayana cayizadey maarettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Asay intena oykkidi dere haarizaytakkonne godattizaytakko, Ayhuda Woosa Keeththe oykki efikko ‘Ay gi zaarinoo? Ay giinoo?’ giidi hirgofte. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ays giikko inte haasayanas bessizayssa Xillo Ayanay he wode intena tamarsana.” ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Daro asa giddofe issadey “Astamaare! Ta ishay nu aawa laata miishafe tana gakkizayssa taas immana mala izas yoota” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesusikka “Haysso! Tana inte bolla pirdiza daanna ooththiday oonee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Qasseka istas “Asas daro miish diikkokka shempoy he duretethan doonta gish naagettite; yiiqetethafe intena keehi naagite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Zaarethidikka istas “Lo7ethi kath immiza gade goda gidida issi dure asi dees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","He addezikka ba woznan ‘Ta kaththa shiishada woththizassoy baynda gish ay ooththoo?’ giidi qoppides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Addezikka ‘Taas diza gootarata laallada hara aakkizaz keexana; histada taas diza kathaanne taas dizaz wursa izan shiishana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ta shempoyokka ta shempoye! Daro wodes gidiza kath shiishida gish shempa uttada ma; uya; ufayeta’ gaana gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Gido attin ‘Xoossi haysso eeyazo! Ne shempoyo hachchi omars neeppe ekkana koyeettes; hessa gish ne nees shiishidays oonas gidanee?’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Hessa gish Xoossa achchan dure gidonta baas miishe shiishshiza asa wursethikka hessa mala” gi leemison yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Hessafe guye Yesusi bana kaallizaytas “Intes ta yootays inte duussas ‘Ay maanakkonne woykko inte bollas ay may7anakkonne’ giidi ceecoppite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ays giikko shempoy kathafe asatethi qasse may7oppe aadhdhees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Quurota xeellite zeretenna; maxetenna; kath shiishshiza gootaray istas baawa shin Xoossi ista mizees. Histikko inte istafe keehi aadhdheketii? ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Gido attin intefe darsi qoppidi ba laytha bolla issi gallas gujjana dandayizay oonee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Histikko guutha miish oosoy intes dandayettontashe ays hara miishas keehi qoppetii? ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ciishshati waanidi diccizaakkonne ane xeellite; waayettenna; suqetenna; gido attin ta intes yootays; Solomooneykka gita asa shin istafe issineytho may7ibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Histikko Xoossi hachchi beettidi wonto taman wodhdhana maata hayssatho mayziza gidikko inteno ammanoy paccidayto! Intena wosti aaththi mayizenee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Hessa gish ‘Ay miinoo? Ay may7inoo?’ giidi inte woznay darsi qoppofo. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Biitta bollan diza asi wuri hayssa koyees; gido attin hayssi wuri intes koshshizayssa inte Salo Aaway erees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ubbafekka koyrothidi Xoossa kawoteth koyite; hayssi wuri intes gujeti imettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Inteno guutha wude mehe mala gididayto! Kawoteth intes immanas inte Aawas lo7o qofa gidida gish babbofte. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Intes dizayssa bayzidi manqotas immite; kaysoy ekkontason, bilay moontason, cimmoonta korojon wuronta miish salon shiishshite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Inte woznay inte miishi dizason daana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Qanthan gixxidi giigetite, inte poo7oykka poo7o, ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ista goday bulacha diggisappe simmidi yaanashe naagetizaytanne izi yiidi penge qoxishin elle doyanas giigi uttida asata misatite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ista goday yiza wode dhiskonta naagidi uttida ashkarati isti anjettidayta; ta intes tumu gays; ista goday baas qanthan gixxi eqqidi ista maaddan uttissidi muzana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Omars woykko leela gidoththan yiidi isti dhiskonta dishin demmikko he ashkarati anjettidayta. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kaysoy ay wode yaanakkon eriza gididakko keeththa goday kaysoy bookkishin co7u giidi bessontayssa erite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Asa Nay inte qopponta woden yaanayssa eridi inteka giigettidi naagite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Phexroosikka “Godo! Hayssa leemiso ne yootizay nuus xallayee? Ubba asassaraa?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Godayka “Histikko baso asas koshshiza woden quma immana mala keeththadey keeththa asa bolla woththiza ammanettida woznama asi oonee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Goday simmishin hessatho ooththishe beettizaddey izi anjettidade. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ta intes tumu gays; baas diza miish ubba bolla hessade godassana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Gido attin ‘Izadey ta goday elle yeenna gam7ana’ giidi qoppidi adde ashkaratanne maca ashkarata bukkikko, qasseka koyda mala miidinne uyidi mathotikko, ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","hessade goday izi qopponta gallassan yaana giidi ezugonta saaten yaana. Yiidikka iza qanxerethi yeggidi iza exa ammanontaytara issife ooththana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ba goda qofa eridi giigetontaynne goda shene ooththonta ashkaray iita shoch shocettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Gido attin eronta dishe shochas bessiza mooro ooththida ashkaray guuthara shocettana. Daro imettida asa ubbafe daroy koyeettes; daro hadara ekkidadefe daroy koyeettes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Tani yiday biitta bollan tama eethanassa. He tamay ha7i eexxi kezidakko tana daro ufayssana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Gido attin tani xammaqettana xinqatay dees; he xinqatay polettanashe tani keeha metottettadis. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Intes tani biitta bolla saro ehana yida misatizee? Gidenna; ta intes yootays tani yiday issa issafe shaakanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Hayssafe sinthan issi keeththan ba giddon shaaketida ichashu asati daana. Nam7ati heedzdzata bolla heedzdzati nam7ata bolla dendidi ba giddon shaakettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aaway ba attuma naa bolla, attuma naykka ba aawa bolla, aaya ba maca nay bolla maca nayakka ba aayey bolla, bollota ba naa mach bolla, naa machaka ba bolloti bolla dendidi ba giddon shaakettana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Qasseka derezas “Inte awa arshey mokiza baggara shaaray kezishin beyidi ‘Elleraka iray yaana’ gees geeta; inte gida malaka hanees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Dugeha baggara pudeha carkishin gallassay ho7o gidana geeta; inte gida malaka hanees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Inteno! Lo7o misatiza iitato; saloyssanne sa7a medha beyidi hananayssa ereeta shin histin ha wodeza eroy intena waani xoonizee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Histikko inte ays tuma pirdeketii? ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","“Ne morkera daanna sinthan eqqana bishin buro oge bollan dashe izara giigana oge koya; ne histonta aggikko izi nena goochchidi daanna sinth efana; daannaykka nena aaththidi halaqas immana; halaqayka nena woynen yeggana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ta nees yootays; daannay pirdida wursetha santimeyo qanxa wursana gakkanaas heeppe kezakka.” ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","He wode issi issi asati Yesusakko yiidi “Philaxoosi ista suuthi ista yarshora gaththi walakkida Galila asata” gish Yesusas yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Izikka zaaridi “Histin hessa mala metoy ista bolla gakkida asati hanko waayey gakkonta attida Galila asa ubbafe aadhdhida nagarancha gidida gish giidi qoppetii? ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Gidenna! Ta intes yootays inte maaretonta ixikko inte wurikka he asata mala dhayana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Woykko Salhoomen gimbey ista bolla kundin hayqqida tammanne osupun asati Yerusalamen diza asa ubbafe nagarancha gidida gish giidi qoppetii? ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Gidenna! Ta intes yootays inte maaretonta ixikko inte wurikka he asata mala dhayana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Qasseka istas “Issi asi woyne tokkizason tokkettida issi Balase giza mithi dawus; he balase mithaykko ayfe koyana yiidi issi ayfeka demmibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Woyine atakilte ooththizayssas ‘Hekko tani ayfe demmanna gaada hachchira heedzdzu layth ha Balaseykko simereta yaada issi ayfeka demmabeekke; hessa gish izo qanxa digga; aazas coo biitta xunxazee?’ giidi leemiso yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Izikka zaaridi ‘Godo! Tani izi xaphon osha yeggada oosetha xeellana mala halaythas aggaggarkii? ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Yiza laythas iza ayfikko lo7o; ayfonta ixikko qanxandassa’ ” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesusi Sambata gallas issi Ayhuda Woosa Keeththan tamarsishin; ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","tammanne osupun layth kumeth iita ayanay oykkidi asateth paccisida issi macasaya heen dawus; izakka zokkoy quunnida gish mulekka dhoqu gaanas danda7ukku. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesusi izo beyidappe guye xeygidi “Hanne macasaye! Neni nena sakkiza hargezappe paxadasakko” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yesusi ba kushe izi bolla woththin iza heerakka siti gaada eqqadus; Xoossakka galatadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ayhudata Woosa Keeththa halaqazikka Sambata gallas pathidayssas Yesusa bolla hanqettidi izakko yiza dereza “Oosos bessiza usuppun gallassati diza gish he ooso gallassatan yiidi paxite attin Sambata gallas yooppite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Godayka zaaridi “Inteno qoodheppe qommon haasayizayto! Inte giddofe issadey ba boora woykko ba hare Sambata gallas bason qashetidasoppe birshidi haaththe ushshanas efi erennee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Histin hanna macasaya Abrahaame naa gidada tammanne osupun layth kumeth Xala7ey qachchin dizasoppe Sambata gallas birshettanas izis bessennee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesusi hizgi oychida wode izara eqettizayti wurikka yeellatida; gido attin derey wurikka izi oychida malalisiza oyshan ufayettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Qasseka Yesusi zaaridi “Xoossa Kawotethi ay misatizee? Izo aazara leemisoo? ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Issi asi Sanafice geetettiza mitha ayfe ba gaden tokkin mokka diccada gita gidin kafoti izi hagga giddon duussaso giigissana gakkanaas diccida sanafice mith misatawus” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Qasseka “Xoossa Kawotethi aazara leemiso? ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Issi macassi munuqa caalisanas daro dhiillera walakkida guutha irsho misatawus” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Hessafe guye Yesusi Yerusalame bishe kanthi biza katamaninne gutatan asa tamarsishe aadhdhishin, ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","issadey izakko shiiqidi “Godo! Pirdafe guutha asati xalla attanee?” giidi oychides. Izikka zaaridi “Xuuntha pengeyra gelanas baaxetite; daroti gelanaas koyeettes shin istas hanenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Keeththa goday dendidi ba kare gordi gidin inte karen eqqidi ‘Godo! Kare doyarki!’ giidi penge qoxana shin izi zaaridi ‘Inte oonakkonne awappe yidakkonne ta intena erikke’ gaana gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Intenikka izas zaaridi ‘Nuni nenara issife midossinne issife uyidos; nu dubbushshan nuna ne tamarsadassa’ gaana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Izikka zaaridi ‘Intena inte oonakkonne inte awappe yidakko ta intena erikke; inte makalati wurikka taappe haakkite’ gaana gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Inte Abrahaame, Yisaaqa, Yaqoobenne nabeta ubbata Xoossa Kawoteththan beyiza wode inte karen yegeti attikko he wode intes yeehonne achcha garcech gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Asay awa arshey mokkiza baggafenne wulliza baggafe pudehappenne dugehappe yiidi Xoossa Kawoteththa maaddan uttana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Hekko guyen dizaytappe baggayti sinthe aadhdhana sinthan dizaytappe baggati guye aadhdhanayti deettes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","He wode Farsaaweetappe issi issi asi yiidi “Herdoossi nena wodhanas koyiza gish hayssafe denda kichcha” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesusi istas “Tani buro ‘Hachchinne wonto daydanthata asappe kessana; hargizaytaka pathana; heedzdzantho gallas ta qofaso ta gaththana’ gides giidi he workanas yootite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Gido attin nabey Yerusalameppe karen hayqqanas bessonta gish hachchinne wonto wontoppeynka ta sinthe buus gujjana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Hanne Yerusalame nabeta wodhizare neekko kiitettidayta shuchchara caddizare! Kuttoy ba ciyeta ba qefe gars shiishshiza mala ne nayta shiishshanaas aappun wode koyadinashin ne gidikko akay gadasa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Hekko inte keeththay kayzides; ta intes yootays, ‘Goda sunthan yizadey anjettides’ inte gaana wodey gakkanaashe nam7antho tana beyekketa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Issi gallas Yesusi quma maanas Farsaaweeta halaqatappe issa so gelida wode asay wuri Yesusa ay ooththanakkonne giidi ayfe iza bolla tokki xeellides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Heenka asatethay izas puurin waayettiza issi asi iza sinthan dees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesusikka Muse woga erizaytanne Farsaaweeta “Sakettizade Sambata gallas pathanas koshshizeyee? Koshshennee?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Istika co7u gida; izikka addeza bochchidi pathi yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Qasseka “Intefe issi asas Sambata gallas nay woykko booray kundidi ollan gelikko eeson heerakka kessontadey oonee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Istika oyshas aykko zaaroka demmanas dandayibetenna ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Xeeygettida asati uttanas boncho so koyishin Yesusi beyidi leemisora istas, ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Issi asi nena sarges xeeyssikko bonchoson uttofa; neeppe bollara bonchettizaddey xeeyssetikko; ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","intena nam7ataka xeygidadey yiidi ‘Ne uttidasoza hayssades yedda’ gaana; nenikka yeellatashe ziqaso baandasa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Gido attin ne xeeyssettida wode ziqaso xeellada utta; nena xeygidadey yiidi ‘Ta laggezo! Haaya dhoqason utta’ gaandes; nenikka he wode nenara maaddan uttida asa ubba sinthan bonchettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ays giikko bana dhoqu histizaddey wuri ziqqi gaana; bana ziqqi histizaddey wuri dhoqu gaana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesusikka xeygidadeza “Quma woykko kawo mizanas xeeyssikko neyssatho nena xeeyssidi mizonta mala ne laggeta woykko ne ishata, ne dabbota woykko dureta woykko dure gutata xeeygoppa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Gido attin asa xeeyssada mizana koykko manqota, kushey, tohoy baynda wobettanne qooqeta xeeyssa; neni anjettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Xeeyssettidayti kushe zaaranas dandayonta gish xillota dentha wode nees kushey zaarettana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Maaddan Yesusara issife uttidaytappe issoy hayssa siydi “Xoossa Kawoteththan shiiqidi maaddafe miza asi anjettidade” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesusikka “Issi asi wolqama diggise giigissidi daro as xeygides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","“Diggise maana wodeykka gakkin xeeygettida imathata, ‘Wurikka giigida gish haa yiite!’ giidi xeeygana mala ba ashkara yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Gido attin wurikka baasi hara gaaso shiishshidi issoy ‘Ha7i gade shamadis; ta baada beyanas bessees; hachchis tana lancofa’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Hankoysikka ‘Tani ichashu waaxa boora shamadis. Ista paaca xeellana gish hachchi tana lancofa’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Qasse hara issadeykka ‘Tani buro mishiratethan days; baanas dandaykke’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Oosanchayka kiitettidasoppe simmidi heedzdzati gidayssa ba godas yootides. He wodekka diggisa giigissidayssi hanqettidi oosancha ‘Elella oyddu oge kezada manqota, kusheynne tohoy baynda wobeta qomaxatanne ayfey baynda qooqeta ha geltha’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Oosanchazikka zaaridi ‘Ta Godo! Ne tana azazidayssa wursa poladis; ha7ikka hara utethasoy dees’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Godazikka oosanchaza ‘Gede oyddu oge kezada ta keeththe kumana mala pudenne duge aadhdhizayta wolqara ha geltha. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tani tuma gays; diggisa maana xeeyssetidaytappe issadeykka duunan gelthenna’ ” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Daro derey izara issife bizayssa Yesusi beyidinne guye simmi ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Taakko yizay wuri ba aawa, ba machonne nayta, ba ishatanne micheta, ba shempo gidin ixonta aggikko tana kaallizade gidanas dandayenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ba masqale tookkidi tana kaallontay tana kaallizade gidanas dandayenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Intefe issi asi keeththe keexanas koykko polanas dandayanakkonne dandayontakko koyrottidi baas diza bira qoppontay oonee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Keeththa keexana doommidi wursanas hanonta ixikko beyida asi wuri iza bolla miicana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Istika ‘Hayssi addezi keeththe keexo oykkides shin polibenna’ gi miicana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Woykko issi kawoy hara kawora olas giigettidi nam7u tammu shi asi ekki yiza kawo zaaranas tammu shi ola asara zaaranakkonne uttidi qoppontay oonee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ola zaaranas dandayetonta misatidi beettikko buro hahon dishin maqaynanas gaana yeddees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Hessathoka intefe oonakka gidin baas dizayssa aggontay tana kaallizade gidanas dandayenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Maxiney lo7oshin ba maxinetetha mal7o yeddikko zaaridi waani mal7ana dandayizee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Gaden yeggin aradisonta gish coo kare wora yegettes; siyiza haythi diza asi siyo!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Issi gallas qaraxa shiishshizaytinne nagaranchati wuri Yesusappe siyanas iza achchi shiiqida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farsaaweetinne Xaafeti “Hayssi addezi nagaranchata ixenna; istarakka mees” giidi ba giddon zuuzumetida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesusikka istas leemiso hizgi yootides; ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Inte giddofe issades xeetu dorsi diikko he xeetu dorsatappe issina dhaykko attida uddufun tammanne uddufunata denban yeggidi dhayidayssa demmana gakkanaas koyana boontay oonee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Demmidi ufayssara hashen tookki ekkidi, ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","baso simmes, ba laggetanne guta asata issi bolla xeygidi ‘Dhayida ta dorsayo demmadis; tanara issife ufayettite’ gaana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ta intes yootays ‘Hessathoka maaroteth koshshonta uddufun tammanne uddufun xillotappe maaretethan geliza issi nagaranchan salon ufays gidana.’ ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Woykko issi tammu bira santimey diza macasaya he tammafe issineya dhaykko xompe oythada demmana gakkanaas keeththa gars pittada lo7etha koyonta macas oonee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Izakka demmida wode ba laggetanne ba gutata issife xeeygada ‘Taappe dhayda bira santimeyo demmida gish tanara issife ufayettite’ gaandus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ta intes yootays ‘Hessathoka maarotan geliza issi nagarancha asan Xoossa kiitanchata achchan ufays gidana.’ ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","“Issides nam7u nayti deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Istafekka kaalo naazi ba aawa ‘Aabo! Nees diza miishafe ta gisha taas imma’ gides. Aawaykka baas diza miisha ba naytas gishides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Daro wode gam7onta dishe kaalo naazi ba miisha wursi shiishshi ekkidi haaho biitta bides. Heenka baas diza miisha go7ay baynda coo mela dhayssides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Izikka baas dizayssa wursi dhayssidappe guyen he biittan iita koshay dendin daro waayettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hessa gish he deren diza asappe issaadekko shiiqides. Izaadeyka ba guddunth heemmana mala gudduntha heemizaso yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Naazikka guddunthati miza harqozappe maanas amottides shin hessaka immizadey beettibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Gido attin iza woznay simmida wode ‘Ta aawa ashkarata aappunatappe kathi tirpize shin tani hayssan gafan hayqqana matadinaa? ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Dendada ta aawa so baada, aabo! Salon Xoossa, sa7an ta nena qohadis.’ ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Hayssafe guye ‘Tani ne naa geetettada xeeygettanas taas bessenna; ne ashkaratappe issa mala tana qooda’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Hessa gish dendidi ba aawakko bides. Gido attin buro izi hahora yishin aaway beyidi mishettidinne izakko woxxi biidi idimmi oykkidi yeerides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Naazikka ‘Aabo! Salon Xoossa, sa7an ta nena qohadis; hayssafe guye ta ne naa geetettada xeeygettanas taas bessenna’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Gido attin aaway ashkaratas ‘Eesottidi ubbafe doorettida may7o ehidi mayzite; iza biradhen migda, iza tohonka caamma aaththite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Modho mirgo boora ehidi shukite; miidi ufayetoos. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Hayssi ta naazi hayqqides shin paxides; dhayides shin beettides’ gides; hessafe guyen ufayeteth oykkida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Hessi haniza wode bayra naazi goshshason dees; heeppeka simmidi so matida wode diiththa duris siydes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Izikka ashkaratappe issa xeygidi ‘Hessi aazee?’ gi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ashkarazikka ‘Ne ishay yides; izi saroninne lo7on simmida gish ne aaway modho mirgo boora shukides’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Bayra ishazikka hanqettidi so gelanaska koybenna. Aawaykka kare kezidi izi so gelana mala woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Gido attin izikka zaaridi aawas ‘Hekko tani hayssa gakkanaas nees aylle mala ooththadis; ne azazoppe issinokka paccisabeekke; gido attin tani ta laggetara ufayettana mala ne taas issi deysha laaqakka immabeekka. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Gido attin hayssi ne naazi nees dizayssa wursi laymatizaytara wursidi yishin modho mirgo boora izas shukadasa’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Aawaykka ‘Ta naazo ne ubba wode tanara daasa; taas gididay wurikka neessa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Hayssi ne ishay hayqqides shin paxides; dhayides shin beettides; hessa gish nuni ufayetanas bessees’ ” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesusi bana kaallizaytas “Issi dure adde dayssas iza keeththa ayssiza issi asi dees; izi he dure addeza miisha ogey baynda laallizayssa worey ha dure addeza haythan wodhdhides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Dure addezi he addeza xeygidi ‘Haysso ta siyzayssi hessi aazee? Hayssafe doommada ne ta keeththas ayssizadde gidanas dandayonta gish ne alafetetha giddon diza miisha oykkida mazgaba taas zaara’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Keeththa ayssiza addezi ba woznara ‘Ta goday tana ta alafetethafe gooddana gees; goya maanas taas wolqay baawa; woossanas yeellatays; hessa gidida gish ay ooththoo?’ giidi, ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","tani alafetethafe kezikko asay tana mokki ekkana mala ooththana oge ta erays. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Hessa gish iza goda accoy ista bolla diza asata issa issa xeygides. Koyro yidayssa ‘Ne bolla goda acoy aapunee?’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“ ‘Issi xeetu xaaro kumeththa zaytey ta bolla dees’ gides. Alafezi zaaridi kase ne faramida waraqata heyi ekka uttada elle ichashu tammu xaaro gaada xaafa gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Kaallidi hankoyssa ‘Nech ne bolla aappun dizee?’ gides. ‘Xeetu ogoro gistey dees’ gides. Alafezi zaaridi ‘Kase ne tal7ashe faramida waraqata hey osupun tammu ogoro gaada xaafa’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Godazikka shocechiza alafezi ooththida cincateththa gish iza nashshides. Ha alame nayti bana misatizaytara diza gaaggoteththan poo7o naytappe aadhdhida cincata. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Hessa gish tani intena gizay ha biitta miishay wurida wode merna keeththan inte ekettana mala ha7i intes diza miishara intes lagge medhite gays. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Guutha miishan ammanettizadey daro miishanka ammanettana; guutha miishan ammanettontadey daro miishanka ammanettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Histikko inte ha biitta miishan ammanettonta ixikko tuma miisha hadara oykkite giidi ooni intes immanee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Asa miishan inte ammanettonta ixikko intes buzo gidana miish ooni immanee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Nam7u godas issito issi bolla azazettana dandayizadey oonikka deenna; woykko issa dosidi issa ixees woykko issakko shiiqidi hankoyssa leqqees. Xoossasinne miishas issife gaththi haarettanas dandayekketa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Miish darsi siiqiza Farsaaweeti hessa wursi siydi Yesusa qidhida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesusikka istas “Inte intena asa achchan xilliseta; gido attin Xoossi inte wozna erees. Asa achchan bonchettidadey Xoossa sinthan tuna” giidi istas yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Muse wogaynne nabeti Yohannisi yaana gakkanaas yootishe gam7ida. Hessa kaallidi qasse Xoossa Kawoteththa Mishiraachcho qaalay sabakettides. Asi wurikka hee gelanas wadhettes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Gido attin Muse wogappe issi qeerina kunda attanayssafe saloynne sa7ay aadhdhanayssi kawushsha gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ba macho anji yeddidi hara macho ekkiza asi wurikka laymattes; ba azinappe anjetta bidaro ekkidayssikka laymattes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Qasseka Yesusi istas ‘Lo7o may7o may7idi gallas gallas lo7o duussa ufayssan diza issi dure asi dees’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","He addeza pengen kumeththa bollay madunth xalla gidida issi Alazaare geetettiza manqo adde dizayssi ichchidi dees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Izikka he dure addeza keeththan asay kath mishin maaddafe gaden wodhdhiza suupa maxi maanas amottes. Kanatikka iza maduntha laacettes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ha manqo addezi hayqqin Salo Kiitanchati Abrahaame ki7o ekki bida; qasse dure addezikka hayqqidi moogettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Izi Si7oolen waayettishe dhoqu giidi haahon Abrahaame xeellides; Alazaarekka ba ki7on oykki dishin beydes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Dure addezi ‘Aawa Abrahaame! Hayssan waayettiza taas michettarkii! Gi Alazaarey ba biradhe xeera irxa haaththan bochchidi ta inxars irxisana mala ha yeddarki!’ giidi waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Gido attin Abrahaamey ‘Ta naazo neni biitta bolla dashe lo7o duus de7idayssa mala Alazaarey kase waaye beyidayssa ne qoppa; gido attin ha7i izi ufayettishin neni waayetasa’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hessi wuri hanishin haan diza asi haappe hee inteko aadhdhonta mala qasseka intekon dizay haa nuukko aadhdhana koyizadey haa aadhdhonta mala intessinne nuus giddon gita aafoy giigettides gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“Dure addezi qasse ‘Aabo! Hessi hessa gidikko neni Alazaare duge ta aawaso yeddana mala ta nena woossays; taas ichashu ishati deettes; hayti hayssa ha waayeso yoonta mala biidi istas lo7ethi yootana mala Alazaare yeddarkii?’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abrahaamey izas zaaridi ‘Museynne nabeti heen ista achchan diza gish istafe siyeto’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Izikka zaaridi ‘Aawa Abrahaame hessa mala gidenna; hayqida asappe issidey hayqoppe dendi biikko isti Xoossa maarotethan gelana’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Abrahaameyka zaaridi ‘Museynne nabeti gizayssa siyonta ixikko hayqqida asappe issadey dendidakkokka isti amanettenna’ ” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesusi bana kaallizayta “Asa dhuphidi nagaran yeggiza miishi yoonta aggenna; gido attin yaana dhuphezas gaaso gidizaddes aayye-ana! ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","He addezi ha guuthatappe issas dhuphe gidanappe woxa shuchchi iza qoodhen qashetin abba gido izi yegetizakko izas lo7o gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Hessa gish inte hu7es naagetite. ‘Ne ishay nena qohikko hanqeta; izi ba mooro eridi simmikko maara.’ ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Issi gallassan laapunto zaari zaari qohidi laapun tokka zaari zaari ‘Maara giikko maara’ ” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Hawaaretikka “Godo! Nuus ammano gujja” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Godaykka “Gaashe ayfe lagge ammanoy intes diikko hayssa ‘Eththa dhoqalleta baada abban gela tokketa’ inte giikko izi intes azazettana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","8","Qasseka Yesusi “Inte giddofe issi asas goshshanchay woykko dorsa heemiza ashkaray diikko izi goshshasoppe simmishin ‘Taas maana kawo giigissa; ta maada uyana gakkanaas gixetada taas ooththa; hessafe guye baggan maandassanne uyandassa’ gees attin ha7i quma maana ha aadhdha gizee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Histikko he ashkara goday izi iza azazo polida gish iza galati erizee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Hessa gish intenikka inte azazettidayssa wursi polida wode ‘Nuni go7ay baynda oosanchata nuus ooththanas bessizayssa poli ooththidos’ gite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Hessafe guye Yesusi Yerusalame bishe Samaariyaranne Galila achchara aadhdhides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Issi guta gelida wode inchiracha hargiza tammu asati iza demmida. Istika haahon eqqidi; ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ba qaala dhoqu histidi “Yesusa! Godo! Nuus mishetarki!” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Izikka ista beyidi “Biite! Intena Qeesetas bessite” gides. Istika buro bishe oge bolla paxida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Istafe issoy ba paxidayssa beyidi ba qaala dhoqu histidi Xoossa bonchishe simmides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Izaadeyka Yesusa toho bolla kundidi galattides; izikka Samaariya biitta asa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesusikka addeza “Paxidayti tamm as deettenee? Histin uddufunati awa bidoo? ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hayssa dumma dere addezappe attin Xoossa galatizay baawa guussee?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Addezakka zaaridi “Dendada ba! Nena ne ammanoy pathides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","“Xoossa Kawotethi ayde yaanee?” giidi Farsaaweeti Yesusa oychida wode Yesusi “Xoossa kawotethi beettiza malatatan yuukku. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Asay Xoossa kawotethi haan dawus woykko heen dawus gaanas dandayettenna; Xoossa kawotethi inte giddon dawus” giidi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Bana kaallizaytaska “Asa Naa gallassatappe issi gallassayo beyanas inte amottana wodey yaana; gido attin inte beyekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Asay intes ‘Haan dawus’ woykko ‘Heen dawus’ gaana shin inte ista kaallidi booppite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gaasoyka wolqanthi wolqamidi ha gaxappe he gaxa gakkanaas poo7isiza mala Asa Nay yiza gallas iza mala hanana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Gido attin hayssi wuri hananappe koyro Asa Nay daro meto ekkanasinne hayssa ha yeletethan kadhettanas bessees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Nohe wode hanidayssa mala Asa Naa wodenka hessatho hanana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nohey markaben gelana gallas gakkanaas asay mishininne uyishin; ekkishininne gelishin dhaysiza haaththi yiidi wursikka dhayssides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Looxe wodekka iza mala hanides; asay meessinne uyees; bayizessinne shamees; tokkizaz tokkees; keeththika keexetes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Gido attin Looxey Soddomeppe kezida gallas shuchinne mith qoronta diine tamay saloppe bukkidi wursi dhayssides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Asa Nay qonciza gallas hessatho hanana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","He wode ba keeththa bolla dizaddey oonikka keeththa giddon diza miish ekkana giidi duge wodhdhofo; hessathoka goshsha soon diza asi guye so simmofo. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Looxe macho qoppite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ba de7o gam7isana koyizay wuri dhayssana; ba shempo aaththi immizaddey gam7isana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ta intes gizay he wode omars nam7u asi issi hiixan ichchana; issoneya ekettana; issoy attana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nam7u macasati issife gaaccishin issineya ekettana; hankoora attana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nam7u asi issife goshshason daana; issoy ekettana; issoy attana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","“Istika zaaridi ‘Godo! Isti awa ekettanee?’ gida. Izikka ahay dizason ankoti shiiqana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Bana kaallizayti azallonta ubba wode woossanas bessizaysa erisanas Yesusi ha leemisoza istas yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Issi kataman Xoossas yayonta asinne bonchonta issi daannay dees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","He katamanka issi am7e macassi dawus. Izakka “Ta balgarara taas mootoy diza gish pirdarkii?” gashe izakko simeretadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Daannazikka daro wode gakkanaas izis pirdibenna; gido attin guyeppe ba woznan “Xoossas yayonta asekka bonchonta aggikko, ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","hanna am7e macasaya tana waayssiza gish ta izis pirdana Hessa histonta aggikko ubba wode simeretada iza tana daabbursana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","“Godayka “Makalancha daannay gidayssa siyite; ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Xoossi qamma, gallasinne omars izakko waassiza doorettidaytas pirdeneyee? Tana ay metide! giidi ba maado gam7issandee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ta intes gays; istas elle pirdana; gido attin Asa Nay yiza wode biitta bolla ammano demmandeshaa?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Bana xillo asa mala qoodidi ceeqettizaytassinne harata leqo ayfen xeellizaytas leemisora, ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Nam7u asati woossanas Xoossa Keeththe bida; issoy Farsaawe, hinkoyssi qaraxa shiishshizade. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farsaaweezikka eqqidi ba gish ‘Xoosso! Tani hara asa mala bonqizadde, makalizade, laymatizade harappeka hayssa qaraxa shiishshizadde mala gidonta aggida gish ta nena galatays. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Saamintan nam7a xoomays; taas diza tammafe issa immays’ giidi woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Gido attin qaraxa shiishshizaddezi haahon eqqidi pude salo dhoqu giidi xeellanas koybenna; gido attin ba tira iccishe ‘Xoosso! Tana nagaranchaza maararki!’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ta intes yootays; Xoossa sinthan Farsaawezi xillotethi demmibenna shin hayssi qaraxizayssi xillidi baso simmides. Bana dhoqusizay wuri ziqqi gaana; bana ziqqisizay gidikko dhoqu gaana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yesusi bosherethana mala asay guutha nayta izakko ehides. Iza kaallizaytikka hessa beyidi hanqettida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Gido attin Yesusi guutha nayta baako xeygidi “Guutha nayti taakko yaanayssa diggofte; Xoossa kawotethi haytanta malatassa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ta intes tumu gays; Xoossa kawotethi guutha naa mala ekkontay wuri izin gelenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ayhudata halaqatappe issoy “Kiya astamare! Merna de7o laattanas ta ay ooththoo?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesusikka “Aazas tana kiya gay? Issi Xoossafe attin hara kiyay deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","‘Laymatoppa; wodhoppa; kaysotoppa; wordo markattofa; ne aawa boncha’ giza azazozata ne eraasa” gi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Addezikka “Hayta gidikko guutha natetethafe doomada naagadis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesusikka hessa siydi “Histikko nees issi miishi paccees; nees dizazi wursa bayizada manqotas imma; salo mazgaban demmandasa; izappe guye yaada tana kaalla” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Gido attin addezi hessa siyida wode daro haaroy izas diza gish keehi mishettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesusikka addeza xeelidi “Daro miishi diza asati Xoossa kawotethi gelanayssi ay mala meto! ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Durey Xoossa kawoteth gelanayssafe Gaammelay narpe lukkora aadhdhanayssi matana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hessa siyida asay “Histin ooni attana dandayizee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesusikka asa achchan dandayetontay Xoossa achchan dandayettes gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Phexroosikka “Hekko nuni nuus dizaz ubba aggidi nena kaallidos” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesusikka istas “Ta intes tumu gays; Xoossa Kawoteththa gish giidi ba keeththe, ba macho, ba ishanta woykko bana yelidayta woykko ba nayta aggidadey, ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ha7i wode daro dakko kushe ekkontaynne yiza wode qasse merna de7o ekkontay oonikka deenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesusikka bana kaalliza tammanne nam7ata dumma efidi “Ha7i nuni Yerusalame kezana goos; nabeti asa naa gish xaafidayssi wuri polettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Dere asas aaththi immana; istika iza qidhi ka7ananne waayssana; iza bolla cuttana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","garafana; hessafekka zaaridi wodhana; Izikka heedzdzantho gallas hayqoppe dendana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Iza kaallizayti gidikko hessa ubbafe issinoka eribeyttenna. Iza gizayssikka istas gelibenna. Izi aaza gish haasayidakkonne eribeyttenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesusi Iyarko geetettizaso matida wode issi qooqe addey oge duunan uttidi woosses. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","He qooqe addezikka daro asay ogera aadhdhizayssa siydi “Hessi aazee?” gi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Istika izas “Naazirete Yesusi hayssara aadhdhees” giidi yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Izikka “Dawute naa Yesusa taas qadheta” gi waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yesusappe sintheti bizayti “Co7u ga!” giidi hanqettida. Gido attin izi “Dawute nawu! Taas qadheta” giidi darsi waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesusikka eqqidi addeza izakko ehanna mala azazides; izikka izakko shiiqida wode ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ta nees ay ooththana mala koyay?” giidi oychides. Qooqezikka “Godo xeellanas koyays” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesusikka “Nena ne ammanoy pathides xeella” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Addezi heerakka xeellides; Xoossakka bonchishe Yesusa kaallides. Hessa beyida derey wuri Xoossa galattides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesusi Iyarko geetettizasora aadhdhi bishin, ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Zekkiyoosa geetettiza issi asi heen Yesusi biza oge bolla dees. Izikka dere qaraxa qanxisizaytas halaqanne keehi dure asa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Izi Yesusa geetettizayssi awayssakkonne beyanas koyishin qaantha asa gidida gishshinne daro derey Yesusa kaalliza gish Yesusa beyanas dandaybenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yesusi he ogera aadhdhishin sinthe aadhdhidi oge bolla diza issi eththa mitha bolla kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesusi eththa gars gakkidi dhoqu histi xeelidi “Zekkiyoosa! Hach ta ne keeththan pe7anas bessees. Elela wodhdha” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Izikka elle wodhdhidi ufayssan mokki ekkides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","He wode heen izara diza asay hessa beyidi “Nagarancha asa keeththan imato maana gees” giidi wurikka ba giddon zuuzumettida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Gido attin Zekkiyoossi eqqidi “Godo! Tani taas diza miishe ubbafe bagga shaakada manqotas immana; tani oonappekka wordora bonqa ekkidazi diikko oyddu kushe gujjada izaades immana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesusikka “Ha addezi Abrahaame naa gidida gish hach ha keeththas paxatethi yides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Hayssas gaasoyka Asa Nay haa yiday dhayidayssa koyanassinne ashshanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Asay hayssa siyishin leemisora haasaya oykkides; gaasoyka izi Yerusalame gakkanaas matida gishshinne asatas Xoossa Kawoteth qoncana haniza misatida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hessa gish “Issi kawo nay ba kawoteththa shuumeteth ekki yaanas haaho biitta bides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ba ashkarata giddofe tammata xeygidi tammu minane istas immidi ‘Ta simmada yaana gakkanaas hayssa miishan zal7ite’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“He dere asati qasse iza ixida gish ‘Hayssi addezi nu bolla kawotana mala koyokko’ giidi as iza geedora kiita aaththi yeddida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Gido attin ha kawo naazi kawo gididi guye ba dere simmides. Kase bishe tammu minane immida tammu ashkarati izi immida biran zal7idi ay keena tirfisidakkonne eranas ista xeygides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Istafe koyroy shiiqidi ‘Godo! Ne taas immida tammu minaney hara tammu yelides’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Godazikka iza ‘Ne ammanettida ashkara; lo7o ooththadasa. Ne guutha miishan amanettida gish tammu katamata ne haarana mala nees immadis’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Nam7anthozikka izakko shiiqidi ‘Godo! Ne taas immida minaneppe hara ichashu minaney wodhdhides’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Iza godazi izas zaaridi ‘Neni ayssana mala tammu katamati nees imettida’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","“Qasseka hanko oosanchay shiiqidi ‘Godo! Neni woothontasoppe ekkizadde; zerontasoppe maxizadenne menxe iita as gidida gish ta nees babbada curqan xaaxa woththida ne minaneyo hey ekka’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","“Iza godazi zaaridi izas ‘Haysso iita oosanchazo! Ta ne qaalan nena zaara pirdays. Tani wothontasoppe ekkizaddenne zerontasoppe maxiza menxe iita as gididayssa eraasashin tani ta miisha yelora ekkana mala he miishan ooththana asatas aazas immabeekii?’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Iza “Godazikka heen eqqida asata ‘Iza kusheppe minaneza ekkidinne tammu minaney dizayssas immite’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Istika zaaridi ‘Godo! Izas tammu minaney deessikko’ gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","27","“Izikka zaaridi ‘Dizades ubbas haray gujjettana; bayndades kase dizayssi izappe ekettichana. Gido attin tani ista bolla kawotonta mala koydayta hayta ta morketa taakko haa ehidi ta sinthan shukite’ ” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Hessa haasayi simmidi Yesusi Yerusalame kezanas istafe sinthati bides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","31","Dabrazayte geetettiza zuma bolla diza Betefaagenne Bitaaniya geetettiza katamatako matida wode bana kaallizaytappe nam7ata “Heeni inte sinthan diza qeeri katamayo biite; biidi katamayo inte gelishin oonikka togi eronta issi qasheti diza Hare gutte inte demmenna; iza birshidi haa taas ekki yiite; intena oonikka ‘Aazas birshetii?’ giidi oychikko ‘Godas koshshees gite’ ” gi kiittides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kiitetidaytikka biidi izi istas yootida mala hare gutteza demmida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Isti gutteza birshin gutteza godati beyidi “Aazas birshettii?” giidi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Istika “Godas koshshees” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Hare gutteza Yesusakko ehidi ba may7o wursi gutteza bolla yeggidi Yesusa Hare gutteza togisida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Asay wurikka ba afala Yesusi biza oge bolla micides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","38","Dabrazayte zuma bollara duge woththiza ogezakko matida wode qooday baynda derey ba beyida malata gish wurikka ufayssara ba qaala dhoqu histidi “Goda sunthan yiza kawoy anjettidayssa; saroy salon bonchoy saloppe bolla salon gido” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Deretappe issi issi Farsaaweeti Yesusa “Astamaare! Ha nena kaalliza asay gizayssa goonta mala hanqa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Izikka istas zaaridi “Hayti co7u gidakkonne shuchchatikka waassana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","43","Yesusi Yerusalame matishe katamayo beyidi izis yeekkides. “Nees saro gidizaz hachchi ne eridakko aaze dizay? Ha7i ne ayfeppe qotettida gish ne morketi heera haara nena giddoththidi un7ethana wodey yaana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nenanne ne gibbe giddon nenara diza ne nayta wursi biitta kessana. Shuchchakka shuchcha bollafe laalonta aggettenna. Hessi wurikka Xoossi nena koyishin neni eronta aggida gishassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Hessafe kaallidi Yesusi Xoossa Keeththe gelidi Xoossa Keeththa giddon zal7izayta kessides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Qasseka “Ta keeththay Woosa Keeththa gidana geetettidi xaafettides; inten gidikko pangay diza gongolo histideta” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Wontin wontin Xoossa Keeththan izi tamarisishin Xaafetinne dere halaqati iza wodhanas koyda. ");
INSERT INTO gmvRNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Gido attin derey wurikka izara oyketidi izi tamarsizayssa kaalliza gish ooththanazi istas kirqi gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Issi gallas Yesusi asaa Xoossa Keeththan tamarsishinne Mishiraachcho qaala sabakishin Qeese halaqati Xaafetinne dere Cimati shiiqettidi izakko yida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Hayssa ne ooththizay oona shenenee? Nees shene immiday oonee?” giidi iza oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Izikka istas “Takka intena issi oysho oychays; ane taas zaarite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohannisa xinqatay saloppeyee? Asappee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Istika ba giddon issoy issara “Nu ‘Yohannisa xinqatay saloppe’ giikko izi nuna ‘Histin aazas ammanibeekketii?’ gaana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","‘Asappe’ giikko asay wuri Yohannisi nabe gididayssa ammaniza gish nuna shuchchara caddana” gi zorettida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hessa gish “Izi awappekkonne nu erokko” giidi zaarida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesusikka histikko “Takka aaza wolqan ooththizakkonne intes yootikke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Qasseka Yesusi asaas leemisora “Issadey woyne mith tokkides; gade goyizaytas kira immidinne hara dere biidi heen gam7ides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kaxiza bone wode kathafe ekki yaana mala ba ashkaratappe issade gadeza goyda asatakko yeddin gadaa goyizayti kiita bidayssa qoxidi mela kushe yeddida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kaalethidikka hara ashkara yeddin goshshanchati ha7ikka oykki qoxidinne kawushshidi mela yeddida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ha7ikka kaaleththidi heedzdzantho ashkara yeddin goshshanchati izakka qoxerethi madunthidi gede kare kessi yeggida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Woyne mitha goday ‘Ha7i ay ooththoo? Oone erizay ta keeha siiqiza ta naaza yeddidakko iza bonchandettoshaa?’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Gido attin biitta goyizayti naaza beyida mala ba giddon ‘Hayssi iza laattana naaza gidennee? Haa yiite iza wodhidi biitta laattoos’ giidi zoretida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Woyine mitha tokkidasoppe gede kare kessidi naaza wodhida. Histikko ha7i woyne mitha goday ha asata wostanee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yiidinne he goshshanchata dhayssana; woyne mitha tokkizasoza haratas immana” gides. Dereyka hessa izi gidayssa siydi “Hayssa malay hanoppo” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesusikka “Istako xeelidi ‘Histin shuchchan keeththe keexiza asati leqqi aggida shuchchay keeththas waanna hu7e gidana” geetettidi xaafettida leemisozas birsheththay aazee?’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ha shuchcha bolla kundiday wuri shuchchan qoxettana; shuchchaykka iza bolla wodhdhidadey wurikka liiqana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Xaafetinne Qeeseta halaqati hessi leemisozi ista bolla haasayettidayssa eridi heerakka iza oykkanas koyda shin derezas babbida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yesusa wolqara haarizaytas aaththi immanas iza duunappe keziza bala qaala demmidi oykkanas kaalli kaalli naagidanne xillo asa misatidi iza kaalli iza duunappe yo7o naagiza asata izakko yeddida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Iza duunappe yo7o koyiza asati Yesusa “Astamare! Neni tuma haasayizayssanne tuma tamarsizayssa qasseka Xoossa oge ne tumu tamarsizayssanne oonakka shaaka maadontayssa nu eroos. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Gido attin Qeesares giira giiranas bessizee? Bessennee?” giidi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Izikka istas diza gene qofa eridi, ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ane issi dinare tana bessite, hayssi iza bolla diza medhazinne Xaafetoyssi oonayssee?” gides. Istika “Qeesareyssa” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Izikka zaaridi istas “Qeesareyssa Qeesares, Xoossayssa Xoossas immite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hessa gish izi haasayida qaalappe ekkidi asa sinthan iza qaxanas dandaybeetenna; izi immida qaalan malalettidi co7u gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Hayqqidayta denthi baawa giza Saduqaawetappe issi issi asati Yesusakko yiidi oysho shiishida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Godo! ‘Issadey macho ekkidi naa yelonta hayqqikko he hayqqidayssa macheyo iza ishay ekkidi ba isha laattana naa izas yelo’ giidi Musey nuus xaafides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Histin laapun ishati deettes shin istafe bayray machidi naa yelonta hayqqides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Iza kaalozikka izatho hayqqides; ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","heedzdzanthozikka izo ekkidees; laapunati wurikka he macasayo ekkidi wurikka naa yelonta hayqqida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Wursethan macasaya hayqqadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Laapunatikka ha macasayo ekkida shin ha macasaya wursethan hayqqidayti dendiza wode iza awayssa macho gidanee?” ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesusi istas “Ha dere nayti geleettessinne ekkettes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Buro yaana alamen hayqqidayta dentha demmanas bessizayti gidikko gelettenanne ekkettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Isti Kiitanchata mala gidana gish hessafe guye hayqqettenanne hayqoppe dentha nayta gidida gish isti Xoossa nayta. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Musey qeeri wora gish xaafettida taarikezan Goda ‘Abrahaame Xoossa, Yisaaqa Xoossa Yaqoobe Xoossa’ guussan hayqqidayti dendanayssa bessees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Wurikka izas de7oy diza gish izi paxata Xoossafe attin hayqqethata Xoosse gidenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Issi issi xaafeti “Astamare! Lo7o gadasa” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Hessafe guye ay asikka iza oychanas xaalibeenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Hessafe guye Yesusi “Asay Masihe waanidi izi Dawute naa gizee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Gaasoyka Dawutey ba xaafida mazamure maxaafatan ‘Ta ne morketa ne toho gars aaththana gakkanaas Goday ta Goda ne ta ushachan utta’ waanidi gidee? ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Histikko Dawutey iza ‘Goda’ gi xeygishe waani izas naa gidanee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Derey wuri siyishin bana kaallizaytas ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Gooshettiza aduussa qamse may7idi yuushshe dosizaytappenne giyay dizason saroketeth koyizaytappenne Ayhuda Woosa Keeththan dhoqa oydenne diggisason bonchoso koyizaytappe xaafetappe naagettite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Haytanti am7eta keeththa kallosizayta. Asi ista beyana mala woossa aduussetes; heytanta iita pirday naages” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesusi dhoqu gi xeellishin dure asati Xoossa Keeththen muxuwata izan shiishshizayssa giddon muxuwata yeggishin beydes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Qasseka issi am7o dizaara nam7u sikina gidiza nam7u xarqimala he muxuwata izan shiishshizayssan yegishin xeelidi, ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“Ta intes tumu gays; hanna am7eya ubba asappe bollara aadhdheth immadus gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Hayti asati immiday baas diza tirpafe gidishin iza gidikko baas baynda wolqafe baas dizaronne ba duussas koshshizaro wursa yeggadus” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","6","Iza kaallizaytappe issi issi asati Xoossa Keeththay lo7o shuchchaninne asay immida imotan ay mala lo7i keexettidakko giidi ba giddon haasayettishin Yesusi siydi “Hayssi inte beyizayssi wuri laalettonta shuchchi shuchcha bolla keelettida mala attonta wodey yaana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Istika iza “Astamaare! Hayssi wuri ayde hananee? Qasse hayssi hananayssas malatay aazee?” giidi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Izikka istas “Inte balettonta mala naagettite; daroti bana ‘Ta Kirstoosakko! Wodeykka matides’ gishe ta sunthara yaana shin inte ista kaallofte. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ola gishshinne dere makalatetha gish siyiza wode daggamofte. Hessi wuri kasetidi hananas bessees; wursethi gakkides; gido attin heerakka hanenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Qasse “Derey dere bolla, kawoy kawo bolla dendana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Biittay wolqama qaath qaaxana; koshaynne boshay dumma dummason hanana; daro babissizazinne saloppe gita malatay beettanna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Hessi wuri hananappe kasetidi asay intena oykkananne gooddana; Ayhuda Woosa Keeththinne qasho keeththe gelthana; kawota sinthinne daannata sinth shiishana. Hessi wuri ta suntha gish inte bolla gakkana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Hessi wurikka markattanas lo7o qaada gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Hessa gish nuna oychizaytas nu ay zaarinoo? giidi kasetidi hirgonta mala hayssa woznan woththite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Inte morketappe oonikka intenara eqettanassinne baleththanas dandayonta qaalanne cincateth ta intes immana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Intena yelidaytinne inte ishati, inte dabbotinne inte laggeti wuri intena aaththi immana; intefe baggata wodhana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ta suntha gish ubba asa achchan inte ixettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Gido attin inte hu7e binanatappe issinaka dhayukku. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Inte minni eqqikko inte shempo inte ashshana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ola asay Yerusalame giddoththishin beykko izis dhayiza wodey matidayssa erite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","He wode Yuhudan dizayti pude zuma bolla gangetto; kataman dizaytikka katamappe kezite; dere giddon dizaytikka he katamayo geloppetto. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Xaafettidays wuri polettanas hanna halo kessiza wode. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Biitta bolla gita metoy hanana; hayssa dereza bolla hanqoy yaana; hessa gish he wode qanthara diza macasatassinne dhanthiza aayetas aayye ana! ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bagga asay mashshan hayqqana; ba dereppe hara dere di7ettana; Yerusalameykka Xoosse eronta dereta wodey polettana gakkanaas, Xoosse eronta asatan yedhetidaro gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Awa arshe bolla, agina bollanne xoolinte bolla malatay beettana; Abbafenne abba dambala giirissafe dendidayssan biitta bolla diza derey hirgananne metottettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Salo wolqamati qaaxiza gish asay biitta bolla aaze hananesha guussaninne naagon xalla daaburana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","He wode Asa Nay wolqara, gita bonchoranne shaarara yishin beyana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Inteka hayti ha ta gidayti poleteth oykkishin intes atetha wodey matida gish siti gi eqqite; inte ayfe pude dhoqu histite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Kaalethidi “Balase mithinne hara mithata wursi xeellite; he mithati haythe kessishin inte beyiza wode boney matidayssa inte ereeta. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Hessathokka haytanti geetettidayti polettishin inte beyiza wode Xoossa Kawotethi inteko matidayssa erite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ta intes tumu gays; hayssi wuri polettana gakkanaas ha yelettay aadhdhenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Saloynne sa7ay aadhdhana shin ta qaalay aadhdhenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Histikko wogay baynda duussan, daro ushshaninne duussas hirgan inte woznay daaburopo; hessa ooththonta ixikko he gallassay inte qopponta narxa mala inte bolla gakkonta mala naagettite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Hayssi biitta bollan diza asa ubba bolla gakkana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Hessa gish buro yaanayssafe inte kessi ekkana malanne Asa Naa sinthan eqqanas dandayana mala ubba gallas minnidi woossite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesusi gallas gallas Xoossa Keeththan tamarsi tamarsidi omars omars Dabrazayte geetettiza zuma bolla kezi kezi aqqees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Asay wurikka izappe siyanas maalado wontara Yesusakko Xoossa Keeththe yees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","He wode Paaziga geetettiza ukethara bonchettiza ba7aaley mati uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Qeeseta halaqatinne Xaafeti hanko dere asaas babbiza gish Yesusa dhayssana oge koyda. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yesusa kaalliza tammanne nam7atappe Asqoroonto dere asa Yuhuda geetettizayssan Xala7ey gelides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuhudaykka Qeeseta halaqatakkonne Xoossa Keeththa alafetakko biidi istas Yesusa wost aaththi immanakkonne istara haasayettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Istika hessan ufayettidi miishe immanas izara giigida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","7","Yuhudaykka ista qofa dossides; Yesusa istas asi beyonta aaththi immanas inje wode naagishin Paaziga dorsa shukidi ukethara bonchiza ba7aale gallas gakkides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesusikka bana kaallizayta “Paaziga kawo maanas biidi nuus giigissite” giidi Phexroosanne Yohannisa kiittides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Istika “Nu awan giigissana mala koyay?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Izikka zaaridi “Inte gede Yerusalame katama gelishin haaththa oto tookkida asi intena demmenna; inteka izi biidi geliza keeththe gakkanaas iza kaallite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Keeththadezas ‘Astamarey tana kaallizaytara Paaziga kawo maanas imatha keeththi awan dizee?’ gees giite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Izikka imathas giigettida aahoso intena bessana; izi bessiza soon giigissite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Istika biidi Yesusi gida mala keeththa demmidi Paaziga heen giigissida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","15","Wodey gakkida mala Yesusi Hawaaretara quma maaddan uttidi “Ta waaye beyanappe kasetada hayssa Paaziga intenara issife maanas keehi amottadis. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ta intes tumu gays; Xoossa Kawoteththan hayssa birsheththi polettana gakkanaas hayssa Paaziga nam7antho ta intenara miikke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Woyneppe oosettida ushsha xu7ara ekkidinne Xoossa galati simmidi “Heyte; wurikka izappe uyte” giidi istas immides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","“Ta intes tumu gays; hayssafe guye Xoossa Kawotethi yaana gakkanaas nam7antho ha woyne ushshafe uyikke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Uketha ekkidi Xoossa galatides. Izappe istas menthi immidi “Hayssi inte gish imettana ta asho leemiso gidiza gish hayssa ubba wode tana qoppanas ooththite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Izathoka kawoppe guye ushsha xu7a denthidi “Hayssi ushshay inte gish ta suuthan hanana oorath caaqo woga. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Gido attin tana aaththi immanade kushey ta kushera issife maaddan dees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Asa Nay kasetidi iza gish hananayssi wuri uttida mala izi baana; gido attin iza aaththi immizades aayye-ana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Istika hessa ooththanay oonee? giidi ba giddon issoy issa oysherethida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Qasseka “Ooni oonappe aadhdhizakkonne” giidi ba giddon issoy issara palamettida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesusikka ista “Dere haariza kawoti ba dere asa wolqara haarettessinne istika lo7o kawota geetettidi xeygettetes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","“Inte gidikko hessatho hanoppite; intefe gita gididadey woykko ta ooppekka aadhdhays giza asi ubbafe qeeri naa mala gido; haarizaddey haarettizade mala gido. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Quma eqqidi mizidadefenne uttidi mizadefe ooni aadhdhizee? Uttidi mizade gidennee? Tani qasse inte giddon ashkara mala days. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Inten gidikko taappe shaaketonta ta waayishin ta matan eqqidayta. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ta Aaway tana kawothidayssa mala tanikka ta kawoteththan intena kawoththana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Hessika ta kawoteththan ta maaddafe inte maana malanne uyana mala. Qasseka ta kawoteththa algan uttidi tammanne nam7u Isra7eele nayta bolla pirdanassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Qasseka Yesusi Simoona xeygidi “Simoona! Xala7ey intena giste mala suraganas woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Gido attin tani neeppe ammanoy dhayonta mala ne gish Xoossa woossadis; nekka simmida wode ne ishata minthetha” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simoonikka zaaridi “Godo! Ta nenara qashettanassinne hayqqanas giiga uttadis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesusikka zaaridi “Phexroosa hach kuttoy issito waassanas ‘Ta iza erikke’ gaada heedzdzuto ne tana kaadana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Qasseka Yesusi ista “Ta intena kase caammay, korojoynne qaraxite baynda kiittida wode intes aazi paccidee?” giidi oychides. Istika “Aykkoykka paccibenna” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Izikka zaaridi “Ha7i gidikko korojokka qaraxiteyka dizadey oykko; giththa mashshay bayndadey ba may7o bayzidi shamo. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ta intes tuma gays ‘Makalatara izi issife taybettides’ geetetti kase xaafettida qaalay ta bolla polettana bessees; ta gish xaafettidayssas poloy tumappe gakkides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Iza kaallizayti qasse “Godo! Hekko nam7u giththa mashshati hayssan deettes” gida. Izikka iza gish “Hayssi gidana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kase izas lose gidida mala pude Dabrazayte geetettiza zuma bolla kezi bides. Iza kaallizaytikka iza kaalli bida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hee gakkida mala “Inte paacen gelonta mala woossite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yesusi bana kaallizaytappe asi shuch olidi gaththanaso mala haakki biidi gulbati woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ta Aawawu! Ne shene gidikko hanno metoyo taappe digga; gido attin ne sheney hanoppe attin ta sheney hanoppo” giidi woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Saloppe Kiitanchay qoncidi Yesusa minthethides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Izikka keehi xuugettidi woossishin iza asatethafe caway suutha mala gukkides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Woosappe dendidi bana kaallizaytakko bides. Istika izas mishetidi qoppishin dhiskoy efidashe Yesusi istako yiidi, ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","“Ays dhisikeetii? Inte paacen gelonta mala ha7i dendidi woossite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Izi buro haasayan dishin Yesusa kaallizaytappe issoy Yuhuda geetettizayssi banara daro asa kaalethi ekki yiidi Yesusa yeeranas izakko shiiqides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Gido attin Yesusi iza “Yuhuda! Tana Asa Naa yeeron aaththa immay?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesusa yuuyi aadhdhi diza asay hanoza lo7ethi xeelidi “Godo! Haytanta mashshara buththinoo?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Istafe issoy Qeeseta alafe ashkara ushacha haythe mashshara qanxides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesusi ista “Inte ha7i taas aggite!” giidi ashkara haytha bochchidi pathides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Qasseka iza oykkana yida Qeeseta halaqata Xoossa Keeththa alafetanne cimata “Panga oykkiza asa mala giththa mashshanne durqa ekkidi yidetii? ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Gallas gallas ta intenara Xoossa Keeththan dishin ta bolla kushe woththibeekketa; hayssi dhumay kawotida inte wode” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Hessafe guye Yesusa oykki ekkidi Qeeseta halaqaso gelida; Phexroosikka Yesusa hahora kaallides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Asay Qeeseta halaqa gaathan tama eethidi ho7ishe issi bolla uttidashe Phexroosikka istara issife uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Issi garadeya Phexroosi tama ho7izaytara uttidayssa beyadanne tishshi ooththa xeellada “Hayssi addezikka Yesusara dees!” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Phexroosikka “Hanne macasaye! Ta iza erikke” giidi kadides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Guuth gam7ishin hara issadey iza beyidi “Nekka izara dizaytappe issa gidikii?” gides. Phexroosikka “Haysso tani istara diikke!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Issi saate mala gam7ishin hara asi qasseka “Galila as gidiza gish sidhey baynda hayssi izara dees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Phexroosikka qasse “Haysso ne gizadde ta erikke!” gides. Hinno gi kessonta dishin kuttoy waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Godayka Phexroosakko yishe xeellin Phexroosi “Hach kuttoy waassanas ne tana heedzdzuto kaadana” giidi Goday kase yooto qaalay iza woznan karp gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Phexroosikka kare kezidi hiqqimidi yeekkides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yesusa qachchidi naagiza asatikka iza bolla qidhi qidhi kaa7ishe shocerethida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Iza ayfe goozidi “Ne nabe gidikko nena shociday oonakkone ane era!” giidi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hara daro cashsha qaalara kawushshida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Gadey wontin dere Cimati, Qeeseta halaqatinne Muse woga tamarsizayti duulata shiiqidi Yesusa duulatakko shiishida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Istika Yesusa “Ne Kirstoosee? Ane nuus yoota” gida. Yesusikka “Ta intes yootidakkokka tana ammanekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ta intena oychidakko taas zaarekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Gido attin ha7ippe doommidi Asa Nay wolqama Xoossa ushachan uttana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","He wode wurikka “Histin ne Xoossa Naa?” giidi oychida. Izikka “Ta Xoossa Naa gididayssa inteka geeta” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Istika “Hekko izi ba duunara markatishin nu haythara siydos; hayssafe hara marka aazas koshshizee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Heen shiiqida asay wuri dendidi Yesusa Philaxoosakko ekki bides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","“Ays nu asay Qeesares giira giironta mala baleththishenne bana ‘Tani Kirstoosi kawo’ giidi baleththishin hayssa addeza demmidos” giidi mootida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Philaxoosikka Yesusa “Neni Ayhudata kawoo?” giidi oychides. Yesusikka zaaridi “Ne gida mala” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Philaxoosikka Qeeseta halaqatassinne shiiqida asas “Hayssa addeza bolla iza mootisiza iita yo7o demmabekke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Isti zaaridi “Hayssi addezi Galilappe hayssa gakkanaas kumeththa Yuhuda waayiso bolla dees” giidi minthi yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Philaxoosi asay gizayssa siydi “Yesusi Galila asakkone giidi lo7ethi eranas” oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yesusi Herdoosa Kawoteththa giddon dizayssa shaakki eridi he wode Herdoossi Yerusalamen diza gish izakko Yesusa yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herdoossika kase Yesusa beyanas daro koyishe diza gish Yesusa beyidi keehi ufaydes. Iza gish kase siydi izi ooththishin beyanas koydi ufayettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Daro oyshataka iza oysherechides shin Yesusi iza oysha zaaribenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Qeese halaqatinne Xaafeti heen iza matan eqqidi keehi wordo mooto mootida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herdoosikka ba wotadaratara issife iza kadhida; kawo may7o mayzidi gede Philaxoosakko zaari yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herdoossinne Philaxoosi kase ba giddon issoy issara oosha shin he gallas giigida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Philaxoosi Qeeseta halaqatara, dere daannataranne dere asa shiishshidi, ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Hayssi addezi asay wuri makalana mala dentheththes giidi inte taakko ehin ta qorn iza oythiza issi iita miishikka demmabekke. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Qasseka Herdoossi issi iita miishikka iza bolla demmonta aggida gish ha nuukko zaari yeddides. Ha7i inte beyiza mala iza hayqos gaththiza issi iita miishikka ooththibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hessa gish qaxayada ta iza yeddana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Izi hessa giday ista ba7aale gallas qashettida asappe issade birshiza wogay diza gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Derey wurikka issi bolla “Barbaane birshada hayssa addeza digga!” giidi waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barbaaney katama giddon asa makala yo7on dentheththidi as wodhi qashettida asa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Philaxoosikka Yesusa birshanas koyda gish qasseka zaaridi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Asay zaaridi iza “Kaqqa! Kaqqa!” giidi waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Philaxoosi heedzdzanthokka “Aazas kaqqoo? Hayssi addezi ay iita ooththidee? Tani iza hayqos gaththiza iita ooso iza bolla beyabeekke; hessa gish qaxayada ta iza birsha yeddana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Asaykka qaala dhoqu histidi Yesusi kaqqettana mala Philaxoosa keehi woossishe waassida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Hessa gish Philaxoosi ista oyshoy polettana mala azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Asa makalisidi shempo wodhdhida gish qashettidayssa birshana mala isti woossidade birshidi qasseka Yesusa isti dossida mala ooththeto giidi deraas aaththi immides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Istika Yesusa oykkidi ekki bishin Qareena geetettiza katamappe issi Simoona geetettiza addey hahoppe yizayssa demmida Yesusi kaqqettana masqale koca izi tookkidi Yesusa kaallana mala wolqathida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Daro derey ba tira icci icci yeekkiza macasati, ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesusappe guyera iza kaallida. Yesusi istako simmi xeelidi “Inte Yerusalame macasay intessinne inte naytas yeekkite attin taas yeekkofte. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","‘Sinthafe inte hekko makkara gidida macasati, yelonta ulotinne nay dhammonta dhanthati anjettidayta!’ gaana wodey sinthara yees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","He wode asay ‘Zumato! Nu bolla woddite; qeeri zumatikka nuna qottite!’ gaana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Histin qaye mitha bolla hayssatho ooththidayti mela mitha bolla wostaneshaa?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Izara issife hayqqana mala hara nam7u iita ooththida asata izara efida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Qaaraaniyo geetettizaso gaththidi kaqqida. Iita ooththidaytappe issa ushacha baggara issa hadirsa baggara kaqqida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesusikka “Ta Aawawu! Hayti ba ooththizayssa eridi ooththonta gish istas atto ga!” gides. Istika iza may7oza saama yeggidi ba giddon gishetti ekkida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Hessi hanishin asay wuri eqqi xeellides; daannatikka “Izi hara asa ashshides shin Xoossafe doorettida Kirstoosi iza gidikko ane ha7i bana asho” giidi qidhida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Wotadaratikka shiiqidi woyneppe aggettida caala ushsha ushshidi iza qidhida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Neni Ayhuda kawo gidikkii? Ane ha7i nena ashsha” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Iza hu7eppe bolla baggara masqale koca bolla “Hayssi Ayhudata kawo” giza qaala xaafi qaaphida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Iita ooththidi kaqqettida asatappe issoy cashsha qaala Yesusa bolla qoqofides. “Ne Kirstoosa gidikii? Ane nenakka nunakka ashsha” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Iita oosidaytappe issoy “Neni nees bessiza pirda ekkashe Xoossas babbikkii? ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nuni nu ooththida iita oosos bessizayssa ekkoos; hayssi addezi gidikko issi iitakka ooththibenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Yesusa “Neni ne kawoteththara yiza wode tana qoppa!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesusikka zaaridi “Ta nees tumu gays; hach ne tanara Gannaten daana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hessa wode gadey seeta gallas shin biidi uddufun saate gakkanaas kumeththa biitta bolla dhumay dhumides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Awa arshe poo7oy diggettides. Xoossa Keeththa magalashaykka dakkettidi nam7u kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesusikka keehi waassidi “Ta aawawu! Tani ta shempo ne kushen immays” gida mala shempo kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mato halaqay hessa beyidi “Hayssi addezi tumappe xillo asakkoshin” giidi Xoossa galatides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Hessa beyanas heen shiiqidi derey wuri he hanidayssa beyidi tira icci icidi simmides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Gido attin Yesusa kase lo7ethi erizayti wuri qasseka Galilappera iza kaalliza macasati hessa xeellishe haakki eqqida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ayhudata duulata asappe issoy izikka Yoosefe geetettizayssi issi daro kiyanne xillo asa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Izikka kase asay Yesusa bolla duulatishin he duulatan deenna; izikka issi Armatiyasa geetettiza Ayhudata katama asa shin Xoossa Kawotethi yaanayssa naagishe gam7ides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Izikka Philaxoosakko biidi Yesusa aha baas immana mala Philaxoosa woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Philaxoosi izas ero gin Yoosefey aha masqale kocappe woththida mala xaaxidi shuchchafe woocettida kase hara asi moogettonta duufon efidi woththides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","He gallassay asay Sambatas giigettiza gallas gidida gish Sambatay gelana hanees. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilappe dendidi Yesusara yida macasatikka Yoosefe kaalli biidi duufoza beyida. Yesusa aha wost woththidakkone beyida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Heeppe simmidi shittonne tiyiza miish giigissida. Wogay giza mala Sambata gallas shempida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Wogga wonta maaladora macasati ba giigissida shittoza ekkidi Yesusa woththida duufozakko bida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Shuchchaykka duufoza duunappe genderidi dizayssa beyida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Gido attin giddo gelidi Yesusa aha demmonta aggida gish, ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","istas hanzaazi dhayin isti tollu gidashe qopponta xoliqettiza may7o may7ida nam7u asati ista achchan eqqida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Macasatikka keehi babbidi duge biitta xeellishin “He asati paxidi dendidayssa hayqqethata giddon ays koyetii? ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Izi dendides! Haan baawa. Qasseka izi Galilan dishe intes kase ay gidakkonne ane qopite. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Asa Nay nagaranchata kushen aadhdhi imettanassinne kaqettanas, hayqoppeka heedzdzantho gallas dendanas bessees” giidi yooti woththides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Macasatikka he wode kase izi gida qaala haasayida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Macasati duufosoppe simmidi hessa wursi Yesusa kaalliza tammanne issinetassinne haratas yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Hessaka Hawaaretas yootiday Magdale gizasoppe yida Maaramonne Yohaano geetettizarira Yaqoobe Maaramonne istara issife diza hara macasata. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Gido attin istas macasati yootidayssi agumo misatin ammanibeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Gido attin Phexroosi wothan Yesusa duufokko gakkidinne hokkidi duufo giddo xeellishin iza aha xaaxida may7oy xalla dizayssa beyidi keehi malalettishe baso simmides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","He gallas iza kaallizaytappe nam7ati Yerusalameppe tammanne issi kilometire haakkiza Emahoose geetettiza katama beettes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bishe isti he wode hanida Yesusa hayqo gish ba giddon haasayetettes. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Isti haasayettishin Yesusi istako shiiqidi istara issife bishin, ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","isti iza eronta mala ista ayfey oykettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesusi ista “Hayssi oge hamuttishe inte inte giddon haasayettizayssi aazee?” gides. Istika dagamara modhettishe siti gi eqqagida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ista giddofe issoy Qaliyoopha geetettizayssi zaaridi “Ha mata gallassatan Yerusalamen hanidayssa eronta imatha asi nena xallaa?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Izikka istas zaaridi “Aazi hanidee?” giin isti qasse zaaridi “Xoossa sinthaninne ubba asa sinthan oosoninne qaalan mino nabe gidida Naazirete Yesusa gish” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Izakka Qeeseta halaqatinne daannati hayqo pirdas aaththi immidanne kaqqida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nuni gidikko “Isra7eele woznay iza giidi ufayettidosishin harappeka hessi hanin qasse hach heedzdzantho gallassa. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Qasse nu giddofe issi issi macasati nuna keehi malalisida; istika maalado wontara gede iza duufokko biidi, ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","iza ahay beettonta ixin yiidi izi paxa dizayssa istas yootin Kiitanchata beyidayssa nuus yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nuupekka issi issi asi iza duufokko biidi macasati gida mala beyida attin Yesusa demmibeetenna” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Izikka istas “Inte woznan wothontayto! Inte woznay kase nabeti yootidayssa ammananappe takkidayto! ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Xoossafe kiitettidayssi ha metoza ekkanassinne gede ba bonchoso gelanas bessennee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Museppenne nabetappe doommidi Geeshsha Maxaafatan iza gish xaafettidayssa istas lo7eth yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Isti ba bizaso matida wode Yesusi aadhdhi biza misatides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Istika qasse “Gadey qammiza gish nunara aqa” giidi iza keehi woossin istara aqanas gelides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Istara issife maaddan uttidi uketh ba kushen oykkidi istas menthi menthi immides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hessa wode ista ayfey doyettin iza gididayssa erida; izikka ista ayfeppe geemides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Istika “Nu yishe oge bolla dishin nuna haasayisidi Geeshsha Maxaafataka qoncisidi nuus gelanashe yootin nu woznay tama mala xuugettibenee?” giidi issoy issara haasayettida ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Heerakka dendidi Yerusalame simmi bida. Tammanne issinetinne istara issife dizaytikka issi bolla shiiqi dizayta demmida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Istika ba giddon issoy issas “Goday tumu dendides! Simoonaska beettides” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Iza kaallizaytappe nam7ati oge bolla hanidayssanne Yesusi uketha menthi menthi immida wode isti wost eridakko istas yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Hessa gish isti ba giddon haasayettishin Yesusi ista giddon eqqidi “Saroy intes gido!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Gido attin isti moytile beyida misatin keehi daggamida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Izikka istas “Aazas daro qoppetii? Aazas inte woznara sidheetii? ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ta kushetanne ta tohota haa xeellite tanakko; qasseka tana oykki beyite; tana inte beyizayssa mala moytiles ashoynne meqethi deenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Hessa gi simmidi ba tohotanne ba kusheta ista bessides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Istika ufayssa daroppenne malaletethafe dendidayssan buro ammanonta dishin Yesusi “Hessan aykko mizazi dizee?” giidi ista oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Istika mole xiixa issi bars izas immida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Izikka ekkidi ista sinthan mides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Izikka “Intenara ta diza wode ‘Muse wogan nabetaninne Mazamure Maxaafatan ta gish xaafettidayssi wurikka polettanas bessees’ gaada ta intes yootida ta qaalay hayssakko” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","He wode Geeshsha Maxaafata isti erana mala wozna istas doyides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Istaska “Kirstoosi waaye beyana; heedzdzantho gallas hayqoppe dendana geetettidi xaafettides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Yerusalameppe doommidi ubba deres nagarappe simoynne maarotethi iza sunthan yootettana. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Inteka hayssas markata. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Takka ta Aaway immida ufayssa intes yeddana; inte qasse wolqa bollafe may7ana gakkanaas Yerusalame kataman takkite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Hessafe guye ista ekkidi Bitaaniya geetettizaso kezides. Ba kushetaka denthidi ista anjides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ista anjishe istafe shaakattidi pude salo bides. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Istika izas hokki goynnida; keehi ufayettishe Yerusalame simmida. ");
INSERT INTO gmvRNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ubba wode Xoossa Keeththan Xoossa galatishe gam7ida.");
INSERT INTO gmvRNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Qaalay kase koyro dees. Qaalaykka Xoossa achchan dees. He qaalaykka Xoossa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Izi koyro Xoossa achchan dees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Medhetethi wuri izan medhettides. Medhettidazan izi baynda medhettiday issinaka duukku. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","De7oy izan dawus. Hanna de7oya asas poo7o. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Poo7oy dhuman poo7ises. Dhumay poo7o mulekka xoonenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Xoossafe kiitettida Yohannisa geetettiza issadey dees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Iza markatethan asi wuri ammanana mala Poo7os marka gidi yides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Izi poo7o gish markattana yides attin izi ba hu7es poo7o gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Asa ubbas poo7o immiza tumu poo7oy hayssa ha alamezan Yesusan dees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Qaalaykka kase alamen dees. Alameyka medhettiday izanna. Gido attin alamey iza eribenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Izi ba baggatakko yiin iza baggati iza ekkibeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Gido attin iza ekkidayti iza sunthan ammanidayti isti Xoossa nayta gidana mala maata istas immides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Istika Xoossa nayta gididay Xoossafe yelettida gish attin asa zerethafe hessika asa wogan woykko asho shenen gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Qaalaykka as gidides. Xoossa kiyatethaninne tuman kumidi nunan aqides; issi naas aawa matan diza boncho misatiza iza boncho nu beydos. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohannisikka “Taappe guyera yizayssi taappe aadhdhees. Gaasoyka izi taappe kasekka dees gaada ta intes yootidayssi hekko hayssi izakko!” gi markattides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iza kumeththa kiyatethan nu wuri kiyatetha bolla kiyateth ekkidos. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Wogay Muse baggara imettides; kiyatethinne tumay gidikko Yesus Kirstoosa baggara nuus yides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Xoosse beyiday oonikka baawa. Gido attin Xoossa Aawa matan diza Xoossa Naa issoy xalala iza qoncisides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ayhudata daannati Yerusalameppe Qeesetanne Lewe nayta Yohannisakko kiittidi “Ne oonee?” giidi oychishin, ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohannisi “Tani Kirstoosa gidikke” giidi geeshshi markattides attin markattanas ixibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Istika “Histin ne oonee? Ne Elaasaa?” giidi oychida. Izikka “Gidikke” giidi istas zaarides. Istika “Izi yaana geetettida nabey nenee?” gida. Izikka “Akay tana gidikke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Isti qas “Histin ne oonee? Nuna kiittida asas nu yootana mala ne nena oona gay?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Izikka “Nabe Isayaassi yootida mala tani ‘Xoossa oge suurisite’ gishe bazzo biittan waassizade qaala giirisa” gides ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Farsaaweetappe kiitettida issi issi asati ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Hessa gish “Ne Xoossi kiittidade woykko buro yaana geetettida nabey nena gidonta gidikko histin aazas nuna xammaqay?” giidi iza oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohannisikka istas “Ta haaththan xammaqays; gido attin inte erontaddey inte giddon eqqides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Taappe guyera yaanayssi iza. Ta iza caamma qasho birshanas bessizade gidikke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Hayssi wuri haniday Yohannisi xammaqiza Yordanoose shaafappe he pinthan diza Bitaaniya geetettiza katamanna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Wontetha gallas Yohannisi Yesusi baako yishin beyidi “Dere nagara biittafe diggana Xoossa dorsi hekko hayssich! ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","‘Taappe guyera yaanayssi izi taappe kasekka diza gish taappe aadhdhees’ gaada ta intes yootizay hayssich! ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Takka ta baggara iza erabeekke shin gidikkokka izi Isra7eele deres qoncana mala ta haaththan xammaqashe yadis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kaalethidikka Yohannisi hizgi markattides “Xillo Ayanay haraphe kafo misatdi saloppe wodhdhishininne iza bolla uttishin beyadis. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ta ta baggara iza erike shin ta haaththan xammaqana mala tana kiittidadey ‘Xillo Ayanay iza bolla wodhdhi shempishin ne beyanaddey Xillo Ayanan meecanay iza’ giidi taas yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Takka hessa beyadis. Hessa gish izi Xoossa naa gididayssa ta markatays” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Wontetha gallas Yohannisi bana kaalliza nam7atara heen eqqides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yesusi iza achchara aadhdhishin Yohannisi beyidi “Xoossa dorsi hekko hayssich!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yohannisa kaalliza nam7ati hessa siydi Yesusa kaallida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Isti iza kaallishin Yesusi guye yuuy xeelidi “Ay kooyetii?” gides. Istika “Astamare! Ne duussasoy awaa?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Izikka ista “Ha yiidi beyte” gides. Hessa gish biidi izi awan dizaakko beyidanne he gallas izara issife pe7ida. Wodeykka gede tammu saateso bides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yohannisi yootida qaala siydi Yesusa kaallida nam7atappe issoy Simoona Phexroosa isha Indiraasa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Indiraassi koyro ba isha Simoonakko biidinne “Xoossi kiittida Kirstoosa nu demmidos!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Hessafe guye Indiraassi Simoona Yesusakko ekki yides. Yesusikka iza tishshi histi xeelidi “Haysso! Ne Yoona naa Simoona; hayssafe guye ne Keefa geetettana.” Keefa gussi Phexroosa guussa woykko zaalla shuch guussa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Wontetha gallas Yesusi Galila baanas koydes. Piliphoosakka demmidi “Tana kaalla” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Piliphoosikka Indiraasa malanne Phexroosa mala Betesayda katama asa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Piliphoosi Natina7eele demmidi “Musey woga maxaafan qasse nabetikka buroppe hananayssa yootiza ba maxaafatan iza gish xaafida addeza nu demmidos. Izikka Yoosefe naa Naazirete Yesusakko!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natina7eeley qas “Naazireteppe lo7o miishi beetti erizee?” gi oychin Piliphoosi iza “Haa yaada beya” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natina7eeley Yesusa beyana yishin Yesusi beyidi iza “Hekko! Geney baynda tumu Isra7eele asa!” giidi iza gish yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natina7eeleykka zaaridi “Tana wosta eradii?” gi oychin Yesusikka “Piliphoosi nena xeeyganappe kase balase mitha garsan ne dishin ta nena beyadis” gi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natina7eeley “Astamare! Ne Xoossa naa; Ne Isra7eele kawo” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesusikka izas “Ne ammaniday; ta nena ‘Balase mitha garsan beyadis’ gida gishee? Ne buro hessafe aadhdhiza daro miish beyana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Gujidikka ta intes tumu gays; buro saloy doyettin Xoossa Kiitanchati Asa Naa bolla wodhdhishininne kezishin inte beyana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Heedzdzantho gallas Galila giddon diza Qaana geetettiza Kataman sargey dees. Yesusa aayeyakka heen dawus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesusinne iza kaallizaytikka sargezaso xeeygettida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Sargezason woyneppe agettida ushshay wurin Yesusa aaya Yesusa “Woyne ushshay wurdes” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesusikka izo “Aaye! Taas nenara aazi dizee? Ta wodey gakkibeenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","He wode Yesusa aayeya Maarama heen gadezan diza oosanchata “Izi intena gizayssa ooththite” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ayhudatas geesho wogay diza gish usuppun shuchchafe medhettida baathati heen gadan deettes. Istika issoy issoy nam7u oto woykko heedzdzu oto haaththe oykketes. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesusi oosanchata “Baaththata haaththe kunthite” giin istika baaththata duuna gakkanaas silti histi kunthida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Hessafe qasseka oosanchata “Ane ha7i duuqqidi sargeza alafezas izappe immite” gides. Istika duuqqi duuqqi immida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Alafezikka woyne ushshan laamettida haaththa gaanxi xeelidi izi awappe yidakkonne eribeenna. Haaththa duuqqidayti gidikko ereetes. Hessa gish sargeza alafey mishiraza xeygidi, ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Asi wuri sargeson koyro lo7o ushshi shiishshees; asay mathotidappe guye iita ehees; gido attin ne gidikko lo7o ushshi hanno gakkanaas wothagadassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesusi hessa malalisiza malata ubbafe koyro Galila geetettiza deren Qaana kataman ooththides. Ba bonchoka hessa malan qoncisides. Iza kaallizaytikka izan ammanida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Hessafe guye Yesusi ba aayeyra ba ishataranne bana kaallizaytara duge Qifirnahoome wodhdhidi heen guutha wode takkida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ayhudata Paaziga ba7aaley matida gish Yesusi Yarusalame bides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Xoossa Keeththa gibbe giddon boorata, dorsatanne harapheta bayzizayta qasseka miishe laammizayti miishe laammishin demmides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hessa beyidi wodoro xurqafeppe dooqqi ekkidi asanne booratakka Xoossa Keeththa gibbefe kessides; miish laammizayta miishakka dharcidi ista xaraphezatakka shiri shiri yeggides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Haraphe bayziza asaaka “Hayssa wursi gede diggite! Ta aawa keeththa zal7e keeththe histofte” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","He wode iza kaallizayti “Ne keeththa miishay tana tama mala xuugees” geetetti xaafetida qaala haasayida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Hessafe guye Ayhuda asa halaqati Yesusa “Ne hayssa wursa ooththanas sheney nees dizayssa qoncisanas ne nuna ay malalisiza malata bessanee?” gi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesusikka istas “Ane hayssa Xoossa Keeththa laallite; ta iza heedzdzu gallassara zaara keexana” gi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Istika iza “Hayssa Xoossa Keeththa keexanas kase oyddu tammanne usuppun layth ekides; histin neni heedzdzu gallassara keexa kunthanee?” gi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Gido attin Yesusi “Xoossa Keeththa” giday ba asatetha gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hessa gish Yesusi hayqqi dendin iza kaallizayti he yo7oza yuushi qoppidi eridanne hayssa kase maxaafan xaafetidaysanne Yesusi istas kaseti yootida qaala ammanida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Paaziga ba7aale gallas Yesusi Yerusalamen dishe ooththida malatata beyidi daro asay iza ammanides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Qasse Yesusi asa wursi eriza gish oonakka ammanibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Izi asa woznan diza wursi eriza gish oonikka izas asa gish yootanas koshshibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Farsaaweeta bagga as gidida Ayhudata halaqatappe issi Niqodimoosa geetettiza asi dees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Izi qamara Yesusakko biidi “Astamare! Xoossi izara dizadde gidikkofe attin hayta ne ooththiza malalisiza malatata ooththanas dandayizaddey deenna. Hessa gish ne Xoossa achchafe yida astamare gididayssa nu eroos” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesusikka izas zaaridi “Ta nees tumu gays; asi nam7antho yeletonta aggikko Xoossa kawoteth beyanas dandayenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Niqodimoosikka zaaridi “Histin asi cimmidappe guye waanidi nam7antho yelettana dandayizee? Qasseka gede ba aayi ulon simmi gelidi yelettanee?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesusikka izas “Ta nees tumu gays; asi haaththafenne Xillo Ayanappe yeletonta dishe Xoossa kawoteth gelanas dandayenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Asappe yeletiday asa. Ayanappe yeletiday Ayana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Hessa gish ‘Inte nam7antho yelettanas koshshees’ ta nena gida gish malaletofa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Carkoy ba koyda bagga carkees. Ne carkos giiris siyasa attin izi awappe yizakkonne awa bizakko erakka. Ayanappe yeletidaykka hessa mala” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Niqodimoossi “Hayssi waani hanana danda7izee?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesusikka izas “Isra7eele astamare gida uttada hessa ne erikii? ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ta nees tumu gays; nuni nu erzayssa yootoos. Nu beyidayssa markattos gido attin inte nu markateth ekekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ta intes hayssa ha biitta yo7o yootin ammanonta ixikko salo miish yootikko wosti inte ammananee? ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Saloppe duge wodhdhida asa Naappe attin pude salo keziday haray oonikka deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Bazzo biittan Musey shoosh dhoqu histi kaqqidayssatho hessathoka Asa Nay dhoqason kaqettanas bessees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Hessika izan ammanizadey wurikka merna de7o demmanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Xoossa Naa ammanizay wuri merna de7o demmanappe attin dhayonta mala Xoossi hayssa alameza daro siiqida gish ba mexi issi naaza immides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Xoossi ba naaza ha duge alame kiittiday alame asay izan ammanidi attana malasa attin izi alame asa bolla pirdanas gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Iza ammanizade bolla pirdetenna. Iza ammanontadey gidikko Xoossa Naa issinezan ammanonta gish kasekka pirdeti uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Pirdayka hayssa mala, poo7oy ha alame yides shin asas oosoy iita gidida gish asay poo7oppe daro dhuma dosides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Iita ooththizadey wurikka poo7o dossenna. Izi ooththiza iita oosoy qonci kezonta mala izi ba hu7es poo7oy dizaso kezenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tumu ooththizadey gidikko poo7oy dizaso yees. Izi poo7oy dizaso yiza gaasoy Xoossa azazo mala izi ooththida oosoy qoncana malassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Hessafe kaallidi Yesusi bana kaallizaytara Yuhuda dere bides; henka asa xammaqishe istara guutha wode gam7ides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","He wode Saalime achchan Henoone geetettizason daro Haaththi diza gish Yohannisi asa xammaqishin asikka izakko biidi xammaqetides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Hessa wode Yohannisi buro qasho keeththe gelibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","He wode Yohannisa kaallizayta giddoninne issi issi Ayhuda asata giddon Ayhudata geesho woga gish gita palamay dendides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yohannisa kaallizayti izakko shiiqidi “Astamare! Nenara Yordanoose shaafa pinthan issife dishin ne iza gish markatto addezi hekko xammaqees; asikka izakko bees” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohannisikka istas “Oonaska Xoossafe imettonta dishin aykkoykka daana dandayenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","“Tani izappe sinthata kiitetadis attin yaana gida Kirstoosi tana gdikke gaada ta intes yootoyssas inte inte hu7era ta markata. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Sarge wode ekkana mishiray dizaddey izikka mishira. Mishira laggey gidikko mishiraza achchan eqqidi mishirazi gizaz siyees. Mishiraza xalla siydi ufayetes. Hessa gish ta ufayssi ha7i polettides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Izi dhoqu dhoqu gaana mala takka ziqqi ziqqi gaana koshshees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Pudeppe yizadey ubbafe bolla. Garsa Biittafe yidadey izi biittafenne biittazi yootees. Saloppe yizadey izi ubbafe bolla. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Izi ba beyidazinne ba siyidaz markatees. Gido attin iza markateth ekkizadey deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Iza markateth ekkizadey gidikko Xoossa tumancha gididayssa qoncisees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Xoossi kiittidadey Xoossa qaala yootees. Xoossika izaades ba Ayana makki immenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","“Aaway ba naa dosees. Haniza yo7o wursi iza kushen aaththi imees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Naazan ammanizades merna de7oy dees. Naazan ammanontay gidikko Xoossa hanqoy iza bolla daana attin de7o demmenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","He wode Yesusi Yohannisappe bollara daro asa bana kaallizadey ooththizayssanne xammaqizayssa Farsaaweeti siyida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Gido attin xammaqizayti iza kaallizaytappe attin izi xammaqibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Iza gish haasayettizayssa Farsaaweeti siyda Yesusi eridi Yuhuda dere aggidi Galila dere simmi bides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Izi hee bishin Samaariyara aadhdhi baanayssi izas attontaz gidides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Hessa gish Sikaaro geetettizaso Samaariya katama bides. Sikaara Yaqoobey ba naa Yoosefes immida biitta achchan dawus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Henka Yaqoobe haaththa ollay dees. Yesusi oge hamutti daaburida gish he ollay achchan uttides. Wodeykka gallassafe usuppun saate mala. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Hessa wode issi Samaariya dere macas dizaara haaththe duuqqanas he haaththa ollakko yadus. Yesusikka izo “Tana haaththe ushsha” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Hessi hanishin Yesusa kaallizayti quma shammana katama bida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Hinna Samaariya macasaya Yesusa “Ne Ayhuda as gida uttada waanada tana Saamariya macas ‘Haaththe ushsha’ ga oychay?” gadus. Iza hessa giday Ayhuda asassinne Samaariya asas gaaggoteththi doonta gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesusikka Izis “Xoossa immotaynne nena ‘Tana haaththe ushsha’ gizadey izi oonakkonne ne erizakko ne iza woossanas bessees. Izikka nees de7o haaththe immanakkoshin” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Izakka izas “Godo! Nees haaththe duuqqiza miishi deenna; haaththa ollayka daro ciimma; histin ne de7o haaththi awappe demmanee? ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ne hayssa haaththa ollaza nuus immida nu aawa Yaqoobeppe aadhdhay? Izinne iza nayti iza mehetikka hayssa ha ollafe haaththe uyida” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesusi izis “Hayssa ha haaththafe uyizay wuri nam7antho saamotidi zaari hara uyanashin. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ta immiza haaththe uyizadey gidikko mernas mulekka saamotenna. Gaasoyka ta immiza haaththe uyizades merna de7os pultiza pulto haaththe gidana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Macasayakka “Godo! Hayssafe guye tana haaththe saamonta malanne qasseka ta haaththe duuqqana ha yoonta mala hessa ne giza haaththa mala haaththe taas immarkii?” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesusikka izo “Baadanne ne azina xeeyga ekkada ya” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Macasayakka zaarada “Taas azinay deenna” gadus. Izi hizgin Yesusi “ ‘Ne taas azinay deenna’ guussay tumukko. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Gaasoyka kase nees ichashu azinati deettes. Qasse ha7i nenara dizayssi ne azina gidenna. Hessa gish ne tumu gadasa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Macasaya izas “Godo! Neni nabe gididayssa ta ha7i eradis. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kase nu Aawati hayssa zuma bolla goynnida. Inte qasse ‘Asay goynnanas bessizasoy Yerusalamenko!’ geeta” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesusikka izis “Hanne macasaye, Xoossa aawas hayssa zuma bolla woykko Yerusalamen inte goynnonta wodey yaanayssa ammana; ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Inte inte eronta Xoossas goynneta. Nu gidikko asas atotethi Ayhudappe gidida gish nuni nu eriza Xoossas goynnoos. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Gido attin tumu goynnizayti Xoossa Aawas Ayananinne tuman goynniza wodey buro yaana. Haray attoshin ha7ikka yides. Xoossa aawayka koyizay hessa mala goynnizayta. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Xoossi ba hu7es Ayana; iza goynnizayti aynaninne tuman goynnanas bessees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Macasayakka “Kirstoosi yaanayssa ta erays; izi yiidi hanizaz wursi nuus yootana” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesusikka izis “Ha7i nenara haasayizay ta iza” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hessi hanishin iza kaallizayti ba bidasoppe simmida. Yesusi Macasara haasayizayssa malaletida. Gido attin “Hanne ay koyay? Woykko hannira aazas haasayay?” giidi oonikka oychibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hessafe guye macasaya otoza heen aggagada gede katama baada asas; ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ta ooththidaz wursi taas yootidade haa yiidi beyte. Oone erizay Xoossi tiyida Kirstoosi izakkone!” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Aska katamappe kezidi Yesusakko bides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","He wode Yesusa kaallizayti Yesusa “Astamare! Quma ma” giidi woossida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Izi qas “Inte erontay ta miza qumay taas dees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Hessa gish iza kaallizayti “Aykko miza kath asi izas ehideshaa?” giidi ba giddon haasayettida ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesusikka istas zaaridi “Ta qumay tana kiittida ta Aawa shene oosonne iza ooso polo. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Inte qas ‘Kaththa maxay gakkanaas buro oyddu aginay attides’ geeta gidekketii? Qas ta gidikko intena ‘Dhoqu giidi kaththay maxa gakkidayssa xeellite’ gays. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Maxizadey ba damoza ekkana. Mernas gidiza ayfe shiishana. Hessa gish zerizadeynne maxizadey issife ufeyettana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Hessa gish issadey zerana; Hara asi maxana geetettiza leemisoy tuma. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ta intena inte daaburontayssa maxana mala yeddadis. Harati ooson daaburida. Gido attin inte ista daabursan go7ettideta” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Macasaya “Ta ooththidazi wursi taas izi yootides” gaada asas markattida mala katamappe daro Samaariya asay izan ammanides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hessa gish Samaariya asay Yesusakko yiidinne izi istakon gam7ana mala woossida. Izikka nam7u gallas heen gam7ides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Iza qaala siydi daro asay iza ammanides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Macasayokka “Ha7i nu iza ammanizay ne yootida qaala gish xalla gidonta nukka nu baggara izappe siyida gishshinne tumappe izi dere ashshizade gididayssa erida gishassa” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesusi Samaariyan nam7u gallas gam7idappe guye Galila bides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Izi ba baggara “Nabey ba deren bonchettenna” gi yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Gido attin izi Galila biin Galila asay iza lo7ethi mokki ekkides. Gaasoyka Paaziga ba7aale bonchana Yerusalame bidason heen dishin izi ooththidaysa wursi beyida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Hessafe guye Yesusi haaththe woyne cajje ooththida Galila dere giddon diza Qaana geetettiza katama nam7antho bides. He wode Qifirnahoomen izas nay saketida issi kawo shuumey dees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Izikka Yesusi Yuhuda dereppe gede Galila yidayssa siydi Yesusakko bides. Yesusi duge Qifirnahoome wodhdhana malanne daro saketidi hayqqana giza naaza pathana mala Yesusa woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesusikka izas “Inte gita malatatanne malalisizaz beyonta aykkokka ammanekketa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Shuumezikka zaaridi “Godo, ta naazi hayqqonta elela wodhdharki!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesusikka iza “Neni neso ba! Naazi paxides” gides. Addezikka Yesusi izas yootida qaala ammanidi so simmi bides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Izi so bishin iza ashkarati izara ogen gaaggidi “Ne naazi paxides” giidi izas yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Shuumezikka naazi ay saaten paxidakkone ista zaari oychides. Istika izas “Qamma gallassafe laapun saaten iza michizayssi aggides” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Naaza aawayka Yesusi “Ne naazi paxides” giday he isti izas yootiza wode gididayssa erides. Hessa gish he gallassafe oykkidi izinne iza so asay wuri Yesusa ammanida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Hayssi malatay Yesusi Yuhudappe Galila yiidi ooththida nam7antho malata. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Hessafe kaallidi Ayhudata ba7aaley diza gish Yesusi Yerusalame bides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusalamen dorsi geliza penge achchan Ibraaweeta qaalara “Betesayda” geetettiza issi pultofe shiiqidi eellida haaththi dees. Izappe bollara kamay diza ichashu ogeti deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Daro harganchati, ayfe qooqeti, toho wobetinne toho silati oge bolla ichchidi haaththay qaaxettana gakkanaas naagetes. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Issi issi wode Goda kiitanchay haaththan wodhdhidi haaththa qaathees. Haatha qaathafe kaallidi koyrottidi haaththan geliza harganchay bana sakiza ay hargefekka paxees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Heen gadaan heedzdzu tammanne osupun layth kumeth saketida issadey dees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesusi addeza heen ichchidayssa beyidinne izi daro layth saketidayssa eridi “Ne paxana koyay?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Harganchazikka zaaridi “Godo! Haaththay qaaxetiza wode tana haaththan gelthiza asi deenna; ta buro baana gishin haray taappe kaseti haaththan geeles” gides ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesusikka iza “Denda! ne ichchida alga tookkada ba!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Addezikka heerakka paxides. Ba alga tookki ekkidi bides. Hessi haniday Ayhudata Sambata gallassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Hessa gish Ayhudata halaqati paxida addeza “Hach Sambatara ne alga tookkana mala Muse wogay azazenna” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Izikka istas “ ‘Ne ichchida alga tookkada ba’ gi yootides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Istika “Nena alga tookkada ba giday oonee?” gi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Derey darida gishshinne Yesusi heeppe haakki bida gish iza ooni pathidakkonne addezi eribenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Hessafe guye Yesusi addeza Xoossa Keeththan demmidi “Hekko ha7i ne paxadasa; kaseyssafe aadhdhiza iita miishi ne bolla gakkonta mala nam7antho nagara ooththofa” gides ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Addezikka biidinne iza pathiday Yesusa gididayssa Ayhudata halaqatas yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Addeza Sambata gallas pathida gish Ayhudata daannati Yesusa oykkana yedethida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesusikka istas “Ta Aaway ubba wode ooththes, takka ooththana” gides; ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Hessa gaason Ayhudata daannati Yesusa wodhana mala kaseppe aaththi dentheththida. Qasse izi Sambata moorida gish xalla gidonta “Xoossi ta Aawa” gida gishshinne bana Xoossara ginisida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesusi istas “Ta intes tumu gays; Aaway ooththishin beyidayssa oosoppe attin naazi ba shenen aynne ooththenna. Aaway ooththizayssa iza nay hessathoka ooththes. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Gaasoyka Aaway naaza dossees. Ba ooththizayssakka wursi iza bessees; inte malalettana mala hayssafeka aadhdhiza ooso buro bessana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Aaway hayqqidayta denthizayssathonne de7o immizayssatho naazikka hessatho ba koyidades de7o immana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aaway oona bollaka pirdenna. Gido attin pirda maata wursi ba naazas immides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Izi hessatho ooththiday asay wuri Aawa bonchana malanne qasseka naazakka bonchana malassa. Naaza bonchontay naaza kiittida Aawakka bonchenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ta intes tuma gays, ta qaala siyizadessinne tana kiittidaden ammanizades merna de7oy dees. Izaadey hayqoppe gede de7on pinnides attin iza bolla pirdetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ta intes tuma gays, kase hayqqida asati Xoossa naa qaala siyiza wodey yaana; he wodeyakka hanno; siyizayti wuri de7on deana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Gaasoyka Aaway ba baggara de7oy diza mala naazikka ba baggara de7oy daana mala ooththides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Izi asa naa gidida gish pirdana mala godateth izas immides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Hayssan aykkokka malalettofte. Gaasoyka buro kase hayqqidi duufon dizayti wuri iza qaala giiris siyiza wodey yaana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Lo7o ooththidayti hayqoppe dendidi paxana. Gido attin iita ooththidayti hayqoppe dendidi pirdettana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ta ta shenen aykkokka ooththanas dandayikke; gido attin ta aawappe ta siyida mala pirdays. Tana kiittidayssa shene ooththays attin ta shenen ta ooththonta gish ta pirdan balay baawa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tani ta gish tarka markattikko ta markay tumu gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Gido attin ta gish markattizadey haray dees. Izikka ta gish markatizade markatethay tumu gididayssa ta erays. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Inte Yohannisakko ase kiittideta shin izikka tumu markatides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ta hayssa gizay inte attana mala attin taas hara markateth koshshida gish gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohannisi eexidi poo7isiza poo7o mala. Inteka guutha wode iza poo7on ufayettana koyideta. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Taas gidikko Yohannisa markatethafe aadhdhiza markay dees. Ta markaykka ta Aaway taas immida ooso. Hessika ta ooththiza oosoy ta Aaway tana kiittidayssa taas markatees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tana kiittida ta Aawayka ba hu7era taas markatides. Inte gidikko iza qaala giiris mulekka siybeeykketa. Izas medhaaka mulera beybeekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Izi kiittidaden inte ammanonta gish iza qaalay inte achchan deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Intes Geeshsha Maxaafatappe merna de7o demmanas misatin maxaafata piligeeta; maxaafatikka ta gish markattettes. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Gido attin inte de7o demmanas taakko ha yaana koyekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ta asappe boncho koyikke. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ta intena erays; Xoossa siiqoy intenan bayndayssakka erays. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Tani ta Aawa sunthan yadis shin inte tana mokki ekkibeekketa. Hara asi qasse ba sunthan yiikko inte iza mokki ekkeeta. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Inte inte giddon issoy issafe boncho koyizayto! Issi Xoossafe beettiza boncho koyontayto inte waanidi tana ammanana dandayetii? ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ta Aawa sinthan intena mootanay intes tana misatoppo. Intena mootanay inte iza hidota ooththiza Muse; ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Musey ta gish xaafidayssa ammanidakko inte tana ammanana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Izi xaafidayssa inte ammanonta aggikko qasse ta qaala inte waani ammananee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Hessafe guye Yesusi Xibiraadoose geetettizaso Galila Abbafe he pinth pinnides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yesusi harganchata pathida malata beyida gish daro asay iza kaallides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesusi bana kaallizaytara pude zuma bolla kezi uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","He wode Ayhudata Paaziga ba7aaley mati uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","He wode daro derey izakko yizayssa Yesusi dhoqu gi xeelidi Piliphoosa “Hayssa deraas gidana quma awappe shammana dandayizonii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesusi Piliphoosa hessatho oychiday iza paacanas giidippe attin izi ba ooththanayssa erees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Piliphoosikka izas “Issi issades issi bars gidiza kath shamizakkokka nam7u xeetu dinaren shammida kaththikka hayssas gidenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yesusa kaallizaytappe issoy Simoona Phexroosa isha Indiraassi, ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ichashu banga ukethinne nam7u mole oykkida issi nay hayssan dees. Gido attin hanna hayssa ha derezas ay gidanee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesusikka zaaridi “Asa ubba uttissite” gides. Heen gadaan daro maatay diza gish asay uttides. Asa qoodaykka ichashu shi gidizaza. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Hessafe guye Yesusi uketha ekkidi galata woossa woossidi uttida asas gishides. Molezakka hessathoka gishechchides. Asay wurikka baas gidizaz demmides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Asay wurikka kalli min Yesusi bana kaallizayta “Maaddan attida kaththa issinoka ashshonta shiishshite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Istika asay mishin ichashu ukethafe attida tammanne nam7u leemate kumeth shiishida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Asatikka Yesusi ooththida malata beyidi “Hayssadey tumappe ha alame yaana nabezakko!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Asay qasse wolqara Yesusa kawoththana qoppidayssa eridi Yesusi qasseka istafe haakki biidi zuma bolla kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Gadey qammishin Yesusa kaallizayti duge abbako wodhdhida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Wogolon gelidi Qifirnahoome baana kezida. Isti kezishin gadey dhumides. Yesusi hessa gakkanaasikka istako yibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Wolqama carkoy carkiza gish abbay keehi qaaxides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Iza kaallizayti bagga saate oge mala wogoloza laagidappe guye Yesusi abba bollara tohora hamutti wogolozakko matishin demmidi babbida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Izikka istas “Tanakko! Babbofte!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Istika iza ufayssara gede wogoloza giddo ekkana koyda. Heerakka wogolozikka isti baanaso gakkides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Abbafe he pinthan attida asay wontetha gallas abba bolla issi wogoloy xalla dizaaro beyides. Yesusa kaallizayti kase barka bidayssanne Yesusi istara wogolon gelontayssa erida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Gido attin hanko wogoloti Xibiraadooseppe dendidi Yesusi galata woossa woossin asay kaththa midaso yida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Asatika Yesusi woykko iza kaallizayti heen bayndayssa beyidi he wogolotan gelidi Yesusa kosh Qifirnahoome bides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Abbafe he pinthan iza demmidi “Astamare! Ne ayde hayssa yadii?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesusikka istas “Ta intes tuma gays inte tana koyizay kath mi kaallida gish attin malata beyida gish gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Dhayana kaththas ooththofte. Gido attin hessafe aaththidi Xoossa aaway ammanthiza maatame iza bolla shocida gish Asa Nay intes immiza merna de7os gidiza kaththas ooththite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Istika iza “Histin Xoossa ooso ooththanas nu ay ooththinoo?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesusikka “Xoossa oosoy Xoossi kiittida iza naazan ammano” giidi istas zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Istika izas “Nu beyidi nena ammanana mala ne nuna ay malata bessanee? Qasseka ay ooththanee? ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","‘Isti maana mala istas quma saloppe immides’ geetetti xaafetida mala kase nu aawati bazzo biittan manna geetettiza kath mida” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesusi istas “Ta intes tumu gays; saloppe wodhdhida quma intes immiday Muse gidenna. Tumu quma saloppe intes immizay ta Aawa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Gaasoyka Xoossa qumay saloppe wodhdhidi alames de7o immizayssa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Hessa gish asay “Godo hessa mala quma nuus ubba wode immarki!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesusikka istas “De7o qumay tana; taakko yiza asi mulekka gafettenna; tana ammanizadey aydekka saametenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kase ta intes gida mala inte tana beydeta shin ammanibeeyketa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ta Aaway taas immizay wurikka taakko yaana. Taakko yizade ta gede kare goodikke. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Gaasoyka ta saloppe wodhdhiday tana kiittidayssa shene ooththanas attin ta shene ooththanas gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tana kiittidayssa sheney taas immidaytappe issadeka dhayssonta wursetha gallas ta denthana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ee ta sheney naaza beyidi iza ammanizadey wuri merna de7o demmanassa. Tanikka wurseththa gallas iza hayqoppe denthana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Hessa gish Yesusi “Saloppe wodhdhida qumay tana” gida gish Ayhudati iza bolla zuuzumettida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Hayssi Yoosefe naa Yesusa gidenee? Iza aawanne iza aayo nu erokkonii? Histin ha7i izi ‘Saloppe wodhdhadis’ waani gizee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesusikka istas “Inte inte giddon zuuzumeta. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tana kiittida ta Aaway xeygidadefe attin taakko yaana dandayizaddey oonikka deenna. Barka taakko yaana dandayizay oonikka deenna. Taakko yizadekka wursetha gallas ta iza hayqoppe denthana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nabeta maxaafatan asay wuri Xoossafe tamaridade gidana geetetti xaafetides. Hessa gish Aawappe siydi tamarida asi wuri taakko yaana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Hessa gussi aawa beyida asi dees gussi gidenna. Aawa beyiday Xoossa achchafe yidayssa xalla. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ta intes tuma gays; tanan ammanida asas merna de7oy dees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Tani de7o quma. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kase inte aawati bazzo biittan manna mida. Gido attin wurikka hayqqida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Saloppe wodhdhida qumay hayssa. Hayssa mizadey mulekka hayqqenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Saloppe wodhdhida de7o qumay tana. Hayssa ha qumappe mizadey wurikka mernas daana. Alames de7o gidana mala ta immiza qumay ta ashoza” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Hessa wode Ayhudati “Hayssi addezi nu iza asho maana mala wosti immanee?” giidi ba giddon palametida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Hessa gish Yesusi ista “Ta intes tumu gays; Asa Naa asho inte moonta aggikko, iza suuthikka uyonta aggikko intes de7oy deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ta asho mizadessinne ta suuth uyizades ubbas merna de7oy dees. Takka izaade wursetha gallas hayqoppe denthana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Gaasoyka ta ashoy tumu quma. Ta suuthaykka tumu ushsha. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ta asho mizaynne ta suuth uyizay wuri tanan daana. Takka izaaden daana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","De7o Aaway tana kiittida malanne takka izan de7on diza mala hessathoka ta asho mizadey wuri tanan de7on daana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Hessa gish saloppe wodhdhida qumay hayssa. Izikka kase inte aawati midayssa mala gidenna. Gaasoyka he quma midayti hayqqida. Ha quma mizayti gidikko mernas daana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesusi hayssa Qifirnahoomen Ayhudata Woosa Keeththan tamarsiza wode yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iza kaallizaytappe darizayti hessa siydi “Hayssi yo7ozi deexxo; hayssa ooni ekkana dandayizee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesusikka iza kaallizayti hessa yo7oza gish zuuzumetidayssa ba woznan eridi “Hayssi intena deexizee? ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Asa Nay Kirstoosi ba dizaso simmi kezishin beykko inte ay gaanee? ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Asas de7o immizay Xoossa Ayanakko! Asa wolqay qasse ayne go7enna; ta intes yootida qaalay de7o immiza ayana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Gido attin inte giddon issi issi ammanonta asati deettes” gides. Yesusi istas hessa giday koyroppe doommidi ista giddon ammanontayti oonantakkonne qasse iza aaththi immanaddeyka oonakkone eriza gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kaalethidikka Yesusi “Aawa sheney baynda taakko ha yaana dandayizaddey deenna gaada ta intes yootiday hessassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Hessafe dendidayssan iza kaallizaytappe daroti guye simmida. He gallassafe doommidi Yesusa kaallo aggida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Hessa gish Yesusi bana kaalliza tammanne nam7ata “Inteka baana kooyetii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Hessa wode Simoona geetettiza Phexroosi “Godo nees merna de7oy qaalay dishin nu oonakko baanee? ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ne geeshsha Xoossa naa gididayssa eridi nuni ammanidos” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesusikka ista “Ta intena tammanne nam7ata doorabeekkinaa? Histin intefe issoy Xala7e” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Izi hessa giday Simoona naa Asqoroonto Yuhuda gishassa. Ayssi giikko Yuhuday tammanne nam7atappe issa gididakkokka Yesusa aaththi immanay iza gidida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Hessafe guye Yesusi Galila giddon yuuyetides. Gido attin Yuhudan yuuyanas koybenna. Gaasoyka Ayhudati iza wodhdhana koyiza gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","He wode Ayhudata daase ba7aaley mati uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Hessa gish Yesusa ishati izakko shiiqidi “Nena kaallizayti ne ooththiza oosoza beyana mala ne hayssafe dendada Yuhuda dere ba; ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","gaasoyka qoncen erettana koyizadey ba ooso geeman ooththenna. Nekka haytanta wursa ooththashe nena alamen qoncisana koshshees” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Isti hessa gida gaasoy iza ishataka gidin izan ammanontayta gidida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesusikka istas “Ta wodey buro gakkibeenna; inte wodey gidikko ubba wode intes giigakko. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Derey intena ixana dandayenna. Tana gidikko ixees; gaasoyka ta alame oosoy iita gididayssa izas markattiza gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ha7i inte gede ba7aalezaso biite. Taas wodey gakkonta gish hayssa ha ba7aalezaso ta biikke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hessa giidi Yesusi Galilan attides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Gido attin iza ishati ba7aalezaso bidappe guye Yesusi qoncera gidonta qotara ba7aalezaso bides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ayhudati “Izi awan dizee?” gishe ba7aalezason koyda. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Dereyka iza gish giddora sasuki haasayettides. Issi issi asati “Izi lo7o asa” gishin baggay qasse “Lo7o gidenna. Izi dere baleththees” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Gido attin Ayhudata daannatas babbiza gish oonikka iza gish qoncen haasaybenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ba7aalezi wurana bagga gakkishin Yesusi Xoossa Keeththe biidi tamarso oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ayhudati “Hayssi addezi tamaronta dishe hayssa wursi wosti eridee?” giidi malaletida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Hessa gish Yesusi “Ta tamarsiza timirtey tana kiittida ta Aawappe taas imettides attin taappe gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tana kiittidayssa shene ooththana koyizadey diikko hayssi ha timirtey Xoossafe beettidayssa woykko ta taappe hasaydayssa gidikkokka erana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Bappe haasayizaddey ba boncho koyees. Kiittidade boncho koyizadey gidikko izi tumancha. Wordoy iza bolla deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musey intes woga immides gidennee? Gidikkoka inte giddon woga naagi polidadey oonikka deenna. Inte aazas tana wodhana koyetii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Dereyka iza “Ne bolla daydanthi dees! Nena wodhana koyizay oonnee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesusikka istas “Ta issi ooso ooththadis; inte wurikka hanno ha oosoyn malaleteta. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musey intes qaxara woga immides; he wogaykka imettiday kase aawatappe beettides attin Museppe gidenna. Histin hekko inteka Sambata gallasikka as qaxxareta. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Histikko Muse wogay shaaretonta mala asi Sambata gallas qaxxaretizaz gidikko histin ta Sambata gallas asas kumeththa asateth pathin aazas ta bolla hanqettetii? ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Suure pirda pirdite attin asa ayfeso xeelidi maado pirda pirdofte” gi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yerusalame asappe issi issi asati “Isti wodhana koyiza addezi hayssa gidenee? ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hekko izi qoncen hasayes shin isti iza aykkokka gibeetenna. Hays Xoossi kiittidade gididayssa daannati tumu erizoshaa? ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Histin hayssi addezi awa asakkone nu eroos. Xoossi kiittidadey yishin qasse izi awappekkonne erizadey oonikka deenna” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Hessa gish Yesusi Xoossa Keeththan tamarsishe ba qaala dhoqu histidi “Inte tana tumu ereeta. Ta Aawappe yidakkonne inte ereeta. Qasse tani ta shenen yabeekke. Tana kiittidayssi izi tumancha. Gido attin inte qasse iza erekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ta gidikko iza achchafe yida gishshinne izi tana kiittida gish ta iza erays” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hessa wode iza oykkanas koyda; Gido attin buro wodey gakkibeenna gish oonikka oykkibeenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Gidikokka derezappe daroy izan ammanides. Asay “Xoossi kiittidadey yiza wode hayssi addezi ooso malatappe bollara hara ooththanee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Asay Yesusa gish garsara sasuketi haasayettishin Farsaaweeti siyida. Hessa gish Qeeseta halaqatinne Farsaaweeti Yesusa oykkanas Xoossa Keeththa penge naagizayta yeddida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","He wode Yesusi “Ta intenara guuththa wode daashshana; Hessafe guye tana kiittidayssako ta simma baana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Inte tana koyana shin demmekketa. Inte ta dizaso yaanas dandayekketa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Hessa gish Ayhudata daannati ba giddon issoy issara “Hayssi addezi nu demmonta mala awa baaneshaa? Oone erizay Giriketa giddo laaletti diza Ayhudatakko biidi Giriketa tamarsaneshaa? ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Izi ‘Inte tana koyana shin demmekketa; Ta dizaso inte yaanas dandayekketa’ gishin hessi ay guussee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Gita ba7aaleza wursetha gallas Yesusi dendi eqqidinne ba qaala dhoqu histidi “Haath saamettidadey diikko ha taakko yiidi uyo. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Geeshsha Maxaafay gida mala tana ammanizadefe de7o haaththa pultoy pultana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Izi hessa giday izan ammanizayti buroppe ekkana Xillo Ayana gishassa. Gaasoyka Yesusi bonchettiza wodey buro gakkonta gish Xillo Ayanay imettibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Hessa gish derezappe issi issi asati he qaala siydi “Yaana giza nabey tumappe hayssa” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Harati “Hays Xoossi kiittidade” gida. Baggayti qasse “Xoossi kiittidadey Galilappe waani yaanee? ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Xoossi kiittidadey Dawute zerethafe yelettanayssanne Dawute katama Beetelemeppe yaanayssi kase Geeshsha Maxaafan xaafetibenee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Hessa gish iza gaason derey ba giddon shaaketi wodhdhides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Istafe issi issi asati iza oykkana koyda. Gido attin oonikka iza oykkibeenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Hessafe guye Xoossa Keeththe naagizayti Qeeseta halaqatakkonne Farsaaweetakko simmidi bida. Istika “Aazas iza ekkonta yidetii?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wotadaratikka zaaridi “Ha addezi haasayizayssa mala ay asikka haasayi erenna” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farsaaweeti ista “Inteka balettidetii? ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Daannatappe woykko Farsaaweetappe iza ammanidayti dizoshaa? ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Hayssi Muse woga eronta derey tumappe qangetidayssa” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Hayssafe kase Yesusakko bida Farsaaweetappe issa gidida Niqodimoossi istas ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nu wogan issi mootetizadey ba mootos zaaro immin siyontanne izi ay ooththidakkone eretonta dishin pirday pirdeti erizee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Istika “Nekka Galila asee? Galilappe nabey dendontayssa pilgada gakka era” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Hessafe guye issoy issoy baso bides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Hessafe guye Yesusi Dabrazayte bides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Wontetha gallas maalado wontara Xoossa Keeththe simmi yides. Dereyka wuri izakko yiin izi uttidi ista tamarso oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Muse woga tamarsizaytinne Farsaaweeti issi laymatashe oykkettida macas dizaaro ekki yiidi dere sinthan essida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yesusakka “Astamare! Hekko hanna macasaya laymatashe oyketadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Hanni mala macassi shuchchan cadeta hayqqana mala Musey nu wogan nuna azazides; Nenich hanni gish ay gay?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Isti iza hessa giday iza bolla mootos gidiza gaaso demmanassinne iza paacana koyda gishassa. Gido attin Yesusi hokkdi biitta bolla ba biradhdhera xaafo oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Isti iza zaari zaari oychin dhoqu giidi “Inte giddofe nagaray baynda asi koyro shuchchi izi bolla olo” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Hessafe qasseka hokkidi biitta bolla xaafides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","10","Istika hessa siydi cimatappe oykkidi wurikka issoy issoy bides. Hessa gish Yesusi heen eqqida macasayra xalla attides. “Mootizayti awan dizoo? Ne bolla pirdiday oonikka dennee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Izakka “Godo oonikka baawa” gadus. Yesusikka “Takka ne bolla pirdikke; ba! Nam7antho nagara ooththofa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Qasse Yesusi “Tani alames poo7o. Tana kaallizadey wuri de7o poo7o demmana. Dhuman simeretenna” giidi istas yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farsaaweeti “Neni ne gish markattasa; Ne markay tumu gidenna” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesusikka istas “Tani ta gish ay markattikkokka ta awappe yidakkonne qasse ta awa baanakkonne ta eriza gish ta markateth tuma. Inte gidikko ta awappe yidakkonne qasse awa baanakkonne erekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Inte asho qofa mala pirdeeta. Ta gidikko oona bollaka pirdikke. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ta pirdikkokka ta pirday tumu pirda. Gaasoyka ta tarka pirdikke; Tana kiittida ta Aawayka tanara dees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nam7u asata markay tumu gididayssi inte wogan xaafetides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Hessa gish tani ta gish markatays; tana kiittida ta Aawayka taas markattes” gi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Istika “Ne Aaway awan dizee?” giidi iza oychida. Yesusikka istas “Tana gidin ta aawakka gidin inte erekketa; inte tana erizako ta Aawakka eranakoshin” giidi istas zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesusi hessa istas yootiday Xoossa Keeththa gibben miishe woththiza saaxine achchan tamarsishe yootides shin izas oyketiza wodey gakkonta gish oonikka iza oykkibeenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesusi qasseka “Ta baana shin inte tana koyananne inte inte nagarara hayqqana attin ta bizaso baana dandayekketa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ayhudatikka ba giddon issoy issara izi “ ‘Ta bizaso inte baana dandayekketa’ gizay barka bana wodhanaseshaa?” geetettida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Izi qasse ista “Inte garsa asa; tani bolla asa; inte hayssa alame asa; tani ha alameppe gidikke. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Inte ta oonakkonne eridi ammanonta aggikko inte inte nagarara hayqqana gish ta inte inte nagarara hayqqana giday hessa gishassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Istika iza “Ne oonnee?” gida. Yesusikka istas “Ha7i gakkanaas ta intes iza gish yootizadey tana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ta inte bolla haasayanayssinne pirdaza yo7oy daroy dees. Gido attin tana kiittidadey ammanettidade; takka izappe siyidayssa ha alamezas yootays” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Izi istas Aawa gish yootizayssa akeekibettena. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hessa gish Yesusi “Inte Asa Naa dhoqu histidi kaqqida wode tani iza gidadey tana gididayssa inte erana. Aaway tana tamarsidayssa yootadis attin tani ta shene mala aykkokka ooththontayssa inte akeekana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tana kiittidayssi izi tanara dees. Ay wodekka ta ufayssizaz ooththiza gish izi tana xalala yeggi aggibenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Izi hessa yootida mala daro asay izan ammanides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesusi bana ammanida Ayhudata “Inte tumu ta qaalan diikko inte tumappe tana kaallizayta gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Tumay aazakkone inte erananne tumaykka intena wozana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Istika izas zaaridi “Nuni Abrahaame naytakko! Nu oonaska aylleti erokko. Histin ne nuna waanada inte wozettana gay?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesusikka istas “Ta intes tumu gays; nagara ooththizadey wuri nagaras aylle; ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ay wodekka aylley soon luxi dee7enna. Yeloy gidikko aydekka soon dees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Histikko naazi intena wozikko inte wozetidayta gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Inte Abrahaame nayta gididayssa ta erays. Gido attin ta qaala inte ero gi ekkonta gish tana wodhanas koyeeta. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Tani ta Aawa achchan beyidayssa intes yootays. Inte qasse inte aawappe siyidayssa ooththeta” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Istika izas “Nu aaway Abrahaame” giidi zaari yootin, Yesusi istas “Inte Abrahaame naa gididakko Abrahaametho ooththana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Inte gidikko ta Xoossafe siyida tuma intes yootin tana wodhanas gixxi dendideta. Gido attin Abrahaamey hessatho ooththibeenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Inte inte aawatho ooththeta” gides. Istika zaaridi “Nu layman yeletida naa gidokko. Nu aaway issi Xoossa xalala” giidi izas zaarida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesusi istas “Inte Aaway Xoossa gididakko takka Xoossafe keza yida gish inte tana dosanakkoshin; tana izi kiittides attin ta tarka ta shenen yabeekke. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ta yootizayssa ays yuushi qoppeketii? Gaasoyka inte ta qaala siyana koyonta gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Inte inte aawa Xala7e nayta; Inte aawa amo polana koyeeta; izi kasekka shempo wodhidade. Iza achchan tumay doonta gish izi tuman eqqibenna. Izi ba hu7es wordanchanne wordo aawa gidida gish izi wordo haasaya bappe medhi ekkidi haasayees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ta qasse tumu haasayiza gish inte tana ammanekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Inte giddofe tana ne hanno nagara ooththadasa giidi markara laththanas mootana dandayizadey dizee? Ta tumu haasayizade gidikko histin aazas tana ammanekketii? ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Xoossafe gidida asi Xoossi giza siyees. Inte gidikko Xoossafe gidonta gish Xoossa qaala siyekketa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayhudatikka zaaridi “Nu nena ne ‘Samaariya asa; ne bolla daydanthi dees’ gidays tumu dennee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesusi istas “Tani ta Aawa bonchays attin daydanthi ta bolla baawa. Inte gidikko tana kawushsheeta. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Tani taas boncho koykke. Ta bonchettana mala koyizadey qasse dees. Izikka pirda pirdanade. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ta intes tumu gays; oonikka ta qaala naagikko hayqo mulekka hayqqenna” gi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ayhudati iza “Ne bolla daydanthi dizayssa ha7i nuni eridos. Abrahaamey hayqqides; nabetikka izatho hayqqida. Ne qasse ‘Oonikka mule hayqo beyenna’ ga yootasa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ne nu aawa Abrahaameppe aadhdhay? Izi hayqqides; nabetikka hayqida histin ne nena oona gaana koyadii?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesusikka istas “Ta tarka tana bonchikko ta bonchoy hada. Tana bonchizaddey gidikko inte ‘Izi nu Xoossa’ gizay ta Aawa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Inte iza eronta aggikkokka ta qasse erays. Ta iza erike giikko, takka inte mala wordancha gidays. Ta qasse iza erays, iza qaalakka naagays. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Inte aawa Abrahaamey ta gallas beyanas amottidi beydessinne ufayetides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ayhudati qasse “Nees buro ichashu tammu layth kumonta neni Abrahaame beyadii?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesusikka “Ta intes tumu gays; Abrahaamey yelettanappe kasekka tani days” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ayhudati heerakka iza caddanas wuri shuch denthida. Gido attin Yesusi ista matappe qotettidi Xoossa Keeththafe kezi bides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesusi ogera aadhdhi bishe ba aayey uloppe yeletosafe ayfe qooqidade beyides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Iza kaallizayti iza “Astamaare! Hayssi addezi qooqe gidi yellettana mala nagara ooththiday oonnee? Iza yelidayti ooththidoyee? Izi ooththidee?” giidi Yesusa oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesusikka istas “Iza gidinka iza yelidaytikka nagara ooththibetenna. Izi hessatho haniday Xoossa oosoy iza bolla qoncanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Gallassara tana kiittidade ooso ooththanas taas bessees. Buro oonikka ooththanas dandayonta qammay yaana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ha biitta bolla diza wode ha Biittas poo7oy tana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Hessa gi simmidi biitta bolla cuch cuttidi ba cuchchan urqa shugisidi addeza ayfeza he urqa tiyidi, ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Baada Selihoomen asay xammaqettizason meeceta” gides. Selihoome guussi kiitettidayssa guussa. Addezikka biidi meecettidinne xeellishe simmi yides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Iza dooththatinne kase izi heen woossishin beyida asay “Hayssadey kase uttidi woossiza addeza dennee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Istafe issi issi asati “Ee izakko” gida. Baggayti “Iza deenna” gida. Izi qasse “Ta izakko” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Istika “Histin ne ayfey waani xeellidee?” giidi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Izikka zaaridi “Yesusa geetettiza asi biitta bolla urqa munuqidi ta ayfeza he urqa tiyidinne tana ‘Baada Selihoomen meeceta’ gi yootin ta baada meecetada xeellanas dandayadis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Istika “Histin hessadey ha7i awan dizee?” gida. Izikka “Ta erike” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Istika he kase ayfe qooqe addeza Farsaaweetakko efida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesusi urqa munuqidi addeza ayfe pathida gallassay Ayhudata Sambata gallasa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Hessa gish Farsaaweeti addeza izi wosti xeellidakkonne iza oychida. Addezikka zaaridi “Izi ta ayfen urqa tiyides; takka meecetadis; hekko ha7i xeelladis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farsaaweetappe issi issi asati “Hayssi addezi Sambata bonchontadde gidida gish izi Xoossafe gidenna” gida. Baggay qasse “Nagaranchay hayssa mala malata waani ooththana dandayzee?” gida. Hessa gish ista giddon palamay medhettides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Histin kase ayfe qooqe addezako simmidi “Ha ne ayfe pathida addeza gish ne ay gay?” gida. Addezi zaaridi “Izi nabekko!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ayhudati addeza yelida aayeyranne aawara xeygisi ehisana gakkanaas addezi kase qooqe gididayssa ammanibetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Istika yelidayta “Inte ‘nuus qooqe nay yeletides’ giza naazi hayssee? Histin ha7i waanidi xeellana dandayidee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Yelidaytikka hizgi zaarida “Izi nu naa gididayssanne qooqe gididi yeletidayssa eroos. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ha7i qasse izi waani xeellana dandayidakkonne iza ayfe ooni pogidakkonne nu erokko. Izi bana dandayiddade gidida gish izi ba gish yootanas Dandayees; iza oychite” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Iza yelidayti hessatho giday oonikka Yesusa izi Kirstoosa giidi markattiday wuri Ayhudata woossa keeththafe goodettana mala Ayhudati kase seera ooththida gish Ayhudatas babbidi gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Hessa gish “Iza yelidayti izi bana dandayiddade gidida gish iza oychite” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kase qooqe addeza qasseka xeygidi “Haysso ne tumayo yootada Xoossa boncha. Hayssi addezi nagarancha gididayssa nu eroos” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Izikka “Izi nagarancha gidin ta erike. Gido attin ta kase qooqe gididaronne qasse ha7i ta xeellizaro hanno xalla erays” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Isti qasse iza “Izi nees ay ooththidee? Ne ayfeza wosti pogidee?” giidi oychida ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Izikka “Ta intes kase yootin woznan woththi siybekketa shin ha7i qasse aazas zaarethi siyana koyetii? Inteka iza kaallizayta gidana koyetii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Hessafe guye iza “Nu Muse kaallizadenta; ne iza kaallizade gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kase Xoossi Musera haasayettidayssa nu eroos. Hayssi addezi awappe yidakkonne nu erokko” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Addezikka istas “Izi awappekkonne inte erontayssi malalises. Gido attin ta ayfe xeelisidadey iza. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Xoossi baas yayyizadessinne iza shene ooththizades attin nagarancha as siyontayssa nu eroos. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ayfe qooqidi yeletidade ayfey xeellides gizayssa alamey medhetosappe oonikka siyi erenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Hayssadey Xoossafe gidontakko hayssa ooththanas dandayenna” gi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Istika iza “Neni nees mule asatethay nagaran munuqetin yeletidayssi nuna tamarsana waana xaladii?” giidi iza goodida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Addeza goodidayssa Yesusi siydes. Iza demmidinne “Ne Asa Nan ammanay?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Addezikka “Godo! Ta izan ammanana mala izi oonnee?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesusikka “Ne iza beyadasa; ha7i nenara haasayizay izakko!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Addezikka “Godo! Iza ammanadis” giidi izas hokki goynnides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesusikka “Qooqeti xeellana malanne xeellizayti qooqana mala pirdanas ta hayssa ha alame yadis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Izara diza Farsaaweetappe issi issi asati hessa siydi “Hessi ay guussee? Histin nukka qooqee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesusikka ista “Inte qooqeta gididakko intes nagara gidenna shin inte ha7i ‘Nu xeelloos’ giza gish inte nagarancha gidida mala daana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesusi, “Ta intes tumu gays; dorsata yire pengerappe attin hara baggara guppi gelizay kaysonne bonqizade. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pengera gelizadey izi dorsata heemmizade. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Penge naagizadey izas pengeza doyees. Dorsatikka iza qaala siyeetes. Ba dorsata sunthara sunthara xeygi kessees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Bayta wursi kessidappe guye ista sinth aadhdhidi kaaleththees. Dorsatikka iza qaala eriza gish iza kaallettes. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Imatha asa qaala eronta gish izappe baqattettes attin mulekka iza kaallettenna.” ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesusi hessa leemisoza istas yootides shin isti qasse izi istas yootidayssa aykkokka eribetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Hessa gish Yesusi qasseka istas “Ta intes tumu gays; dorsata pengey tana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Taappe kase yidayti wuri kaysonne bonqizayta. Dorsati gidikko isti giza siybetenna ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Pengey tana. Ta baggara gelizadey wuri attana; gelananne kezana; heemmetizasoka demmana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kaysoy kaysotana, wodhanassinne dhayssanas xalla yees. Ta gidikko intes de7oy daana malanne intes keehi darana mala yadis. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ta lo7o heemmizade; lo7o heemmizadey ba shempo ba dorsata gish aaththi imees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Miishera qaxarettidi heemmizadey gidikko dorsati izas gidonta gish kana suytey yiza wode dorsata yeggidi baas baqatees. Kana suyteykka dorsata dafi dafi meessinne laalles. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Baqatizaddey miishan qaxarettidade gidida gishshinne dorsatas mishetonta gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Lo7o henthanchay tana. Tani ta dorsata erays; Istika tana erettes. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Hessika Aaway tana erizayssa mala tani ta shempo dorsata gish aaththa immana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Hayssa ha dorsa yiren gelontayti taas hara dorsati deettes; ta istaka haa ehanas taas bessees. Istika ta qaala siyananne issi mehe gidana. Heemmizayssika issade gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ta zaarada denthanas ta shempo ta aaththa immiza gish ta Aaway tana dosees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tani ta shempo ta dosara aaththa immadis attin oonikka taappe woththi ekkenna; ta aaththa immanas gidin woykko zaara denthanas gidin sheney taassa; hessa he azazoza tani ta Aawappe ekkadis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Hessa he qaalappe dendidayssan Ayhudata giddon qasseka shaaketethi medhetides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Daro asay “Iza bolla daydanthi diza gishshinne goosh gidida gish inte izi gizayssa ays siyeetii?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Baggayti qasse “Daydanthi dizaddey hayssa mala deenna. Daydanthi qooqida ayfe pathi erizee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yerusalamen Xoossa Keeththa ooratho ba7aale boncho wodey gakkides; he wodeykka balgo. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesusi Xoossa Keeththa gibbe giddon Solomoone simeretethasora aadhdhishin, ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ayhudati iza giddo aaththidi “Ne ayde gakkanaas nu wozna hirgan gam7isanee? Ne Xoossi kiittidade gidikko nuus qoncisa yoota” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesusikka istas “Ta intes yootadisko shin inte qasse ammanibeyketa. Ta Aawa sunthan ta ooththiza malatati ta gish yootetes. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Inte qasse ta dorsata gidonta gish tana ammanekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ta dorsati ta qaala siyeetes. Takka ista erays; istika tana kaallettes. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ta istas merna de7o immana; mulekka ista dhayetenna; ista ta kusheppe woththi ekkanas dandayanaddey oonikka deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Taas ista immida ta Aaway ubbafe aadhdhees. Ta Aawa kusheppe ista oonikka bonqanas dandayenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Taninne ta aaway nu issino” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ayhudati iza caddanas qasseka shuch denthida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesusikka “Aawappe gidida daro gita malatata ta intena bessadis. Histin ha ta bessidaytappe awaari gish tana shuchchara caddetii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ayuhudatikka “Nu nena shuchchara caddizay ne coo as gida uttada nena nerka Xoosse kessada cashsha qaala ne haasayida gishassafe attin ne lo7o ooththidaysa gish deenna” giidi izas zaarida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesusikka istas “Inte woga giddon ‘Ta intena Xoossata gadis’ geetetti xaafetibenee? ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Xoossa qaalay istas yida asata ‘Xoosse giikkone Maxaafay shaaretanas dandayonta gidikko’ ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","histin ‘Ta Xoossa naa’ gida gish Aaway ba shaakki dummasidayssanne ha duge alame kiittidayssa inte ‘Ne cayadassa’ giidi tana wordora aazas mootetii? ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ta Aaway ooththizayssa ta ooththonta aggikko tanan ammanoppite. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ta izatho ooththiza gidikko inte tana ammanonta aggikkokka ta Aaway tanan dizayssa takka izan dizayssa inte erana malanne yuushi qoppana mala izi ooththida malatan ammanite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Qasseka isti iza oykkanas koyda shin izi ista kusheppe kessi ekki bides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Hessafe guye Yesusi, Yohannisi kase xammaqizaso gede Yordanooseppe he pinth simmidi heen gam7ides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Daro asay izakko yides; Isti qasse “Yohannisi issi malataka ooththibenna; gido attin hayssa addeza gish izi yootidayssi wurikka tumuko” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Henka daro asay Yesusan ammanides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Bitaaniya geetettizason Maaramanne Martay diza gutan Alazaare geetettizadey sakettides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Izi isha Alazaarey saketida Maarama kase Yesusa toho bolla shitto gussada Yesusa toho ba hu7e binanan quccidarokko. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Michetikka “Godo! Ne dosizayssi saketides” giidi as Yesusakko kiittida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesusi hessa siydi “Ha sakoy Xoossa nay izan bonchettana malanne Xoossi bonchettanassafe attin iza hayqos gaththizaz deenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesusi Marta izi micheyo Maaramonne Alazaare siiqees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Gido attin Alazaarey saketidayssa siyi woththidi heen ba dizason nam7u gallas gam7ides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Hessafe guye bana kaallizayta “Ane Yuhuda biitta simmi boos” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Istika “Astamare! Guutha wodeppe kase asay nena shuchchara caddana koyetteskoshin; ne qasse ha7i he simma baanee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesusi istas “Issi gallassan tammanne nam7u saatey dees denee? Gallasara hamuttiza asi ha alameza poo7on simeretiza gish dhuphetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Dhuphetizadey gidikko izi qamara hamutizade. Gaasoyka poo7oy baynda gishassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Hessa istas yootidappe guye “Nu lagge Alazaarey dhiskides; takka iza dhiskofe denthana bays” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Iza kaallizayti iza “Godo! izi dhiskida gidikko dendana” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesusi istas hessa yootiday Alazaare hayqo gishassa shin iza kaallizaytas qasse dhisko gish yootida misatides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Hessa gish qoncera istas “Alazaarey hayqqides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Inte ammanana mala ta heen doonta aggidayssi inte gish tana ufaysses; ha7i gidikko ane gede izakko boos” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Qasse Didimoosa geetettiza Toomaassi hanko Yesusa kaallizayta “Ane nukka biidi izara issife hayqos” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesusi bi gakkishin Alazaarey hayqqi moogetin oyddu gallas gidides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bitaaniyay Yerusalameppe bagga saate oge haakkees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ista ishay hayqida gish Maramonne Marta minthethanas daro Ayhuda asay istako shiiqides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Yesusa yuussaa Martay siyada iza mokka ekkana badus; Maarama gidikko soon uttadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martay Yesusa “Godo! Ne haan dizaakko ta ishay hayqqenakkoshin. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ha7ikka gidikko ne woossida wursi Xoossi nees immanayssa ta erays” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesusikka izis “Ne ishay dendana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martay qasse “Wursethan dentha wode izi dendanayssa takka erays” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesusikka izis “Dendoynne de7oy tana; tana ammanizadey hayqqikkoka paxa daana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tanan dizaddeynne tana ammanizadey mulekka hayqqenna; hessa ne ammanay?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Izakka zaarada “Ee Godo! Neni duge ha alameza kiitettida Xoossa Naa gididayssa ta ammanays” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Hessa gaadanne simmada ba micheyo Maaramo dumma xeeyga kessada “Astamarey nena koyees” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maaramakka hessa siyida mala elela dendada izakko badus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Hessa gakkanaas Yesusi Martara gaaggidason dees attin gede guta giddo gelbenna ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Maaramo minthethishe izira soon diza Ayhudatikka Maarama pusuku ga denda eqqada kezidayssa beyidi iza Alazaare duufo achchan yeekkana biza misatin izo kaallida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maarama Yesusi dizaso gakka iza demmida mala iza toho bolla gufannada “Godo! Ne haan dizaakko ta ishay hayqqenakkoshin” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Izanne izo kaalli yida Ayhudati yeekkizayssa Yesusi beyidi daro mishetidi ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Iza awan moogidetii?” giidi oychides; Istika “Godo! Haa yaada beya” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesusikka afunxides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ayhudatikka “Izi iza ay mala siiqizako beyte” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ista giddofe issi issi asati “Hayssi qooqe addeza ayfe pogdayssi hayssadey hayqqonta mala ooththanas dandayenee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesusi iza woznay mishetin gede duufokko bides; duufozikka shuchchara gordettida gongolo. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Izikka ista “Shuchchaa denthite!” gides. Hayqqidayssa micheya Martay “Godo! Izi hayqqin hachchi oyddu gallas gidida gish xinqanakko!” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesusikka “Ne ammaniza gidikko Xoossa boncho beyandasa gaada nees ta yootabeykkinaa?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Hessa gish shuchcha denthida; Yesusikka pude salo xeelidi “Ta Aawawu! Ne ta gizaz siyida gish ta nena galatays. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ne ubba gallas ta gizaz siyizayssa ta erays; gido attin ta hessa giday hayssan eqqida asati ne tana kiittidayssa ammanana malassa.” ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesusi hessa gidappe kaalethidi qaala dhoqu histidi “Alazaare! Ha keza!” giidi xeygides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Hayqqida Alazaareyka kumeththa asatethay moogo may7on xaaxettida mala duufoppe kezides. Yesusikka “Birshi yeddite bo!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Hessa gish Maaramo minthethana yida Ayhudatappe daro asay Yesusi ooththidaysa beyidi izan ammanides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Istafe baggati biidi Yesusi ooththidaysa Farsaaweetas yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Hessa Qeeseta halaqatinne Farsaaweeti Ayhudata duulata shiiqana mala xeygidi “Ha addezi daro dumma dumma malatata ooththidade gidida gish nu ay ooththikko lo7oo? ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nu co7u giikko asi wuri izan ammanananne Oroome asikka yiidi hayssa nu biittanne nu asa nuuppe ekkana” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ista giddofe issadey he layth Qeesetas waanna halaqa Qayaafay “Inte aykkokka erekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Derey wuri dhayanappe dere gish issi asi hayqqikko lo7o gidanayssa gish yuushi qoppeketii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Izi hessa bappe gidonta he layth izi Qeesetas halaqa gidida gish Yesusi Ayhuda dere gish sinthafe hayqqanayssa yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Izi hayqqanay he dere asas xalala gidonta kase laalettida Xoossa naytaka issi bolla shiishshanaassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","He gallassafe haa simmin iza wodhanas maqettida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hessa gish Yesusi he gallassafe haa simmin Ayhudata giddon qoncera simeretibenna. Gido attin duge bazzo biitta matan diza Efireeme geetettiza katamay dizaso biidi bana kaallizaytara heen takkides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ayhudati Paaziga ba7aaley matida mala ba7aaley gakkanappe kase geesho woga ooththanas daro asay dumma dumma dereppe Yerusalame yides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Asay Yesusa koyishe Xoossa Keeththan eqqidi ba giddon issoy issara “Intes ay misatizee? Ba7aalezas yeenneshaa?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Qeeseta halaqatinne Farsaaweeti qasse Yesusa oykkanas izi awan dizaakkonne erizadey istas malatana mala kase azazi woththida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Paaziga ba7aales buro usuppun gallassi attishin Yesusi hayqoppe denthida Alazaarey dizaso Bitaaniya bides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Heen Yesusas kawo kaththidi Martay iza kawo mizishin izara issife maaddan uttidaytappe issoy Alazaare. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maarama daro al7o waagara shametida bagga litro gidiza geeshsha nardoose shitto ekka yaada Yesusa toho bolla guussada tohoza ba hu7e binanara quccadus. Keeththakka shitto sawoy kumides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yesusa kaallizaytappe issoy Yesusa aaththi immana Asqoroonto Yuhuday, ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Hayssi shittozi heedzdzu xeetu dinares bayzettidi miishay aazas manqotas imettibenee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Izi hessa giday miisha shiishshiza karaxite oykkizadey iza gidida gish shiiqiza miishafe baas shiishshidi go7ettizade gidida gishassa attin manqotas mishetidi gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesusi qasse “Hayssi shittozi taas moogo gallassas qofetidaz gidida gish he wode gakkanaas iza ba achchan naagu, bochchofte. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Manqoti ay wodekka intenara deettes. Gido attin inte tana ubba wode demmekketa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","He wode daro Ayhuda asati Yesusi heen dizayssa eridi izakko yida; yidaytikka Yesusa xalala kosh gidonta Yesusi hayqoppe denthida Alazaareka beyanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hessa gish Qeeseta halaqati Yesusara Alazaareka gaththi wodhanas ba giddon zoretida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Hessika Alazaare geedon daro Ayhuda asay Yesusakko bi biidi iza ammaniza gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Wontetha gallas ba7aaleza bonchana yida derey Yesusi Yerusalame yizayssa siydes. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Zamba hayth ekkidi Yesusa mokkana kezides; derey qaala dhoqu histidi “Hoosana! Goda sunthan yiza Isra7eele kawoy anjettidayssa!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Beni “Hanne! Xiyoone naye, babbofa! Hekko ne kawoy Hare gutte togidi yees” geetetti xaafetida mala Yesusi Hare gutte demmidi togides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Iza kaallizayti hessa wursi koyro woznan woththibettena. Iza gish xaafetidaysanne izas oosettida hanokka wursi Yesusi hayqoppe dendidappe guye erida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Alazaare duufoppe xeygidi hayqoppe denthida wode izara issife diza asay iza dentha gish markattida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Daro asikka izi hessa mala gita malata ooththidaysa siydi iza mokkana kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Hessa gish Farsaaweeti ba giddon issoy issa “Histin nuni ay ooththana dandayizonii? Beyte! Kumeththa derey attonta iza kaallees” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Goynnanas ba7aalezas shiiqida asa giddon Girike dere asatikka deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Istika Galila giddon diza Betesayda geetettiza dere as Piliphoosa geetettizadeko biidi “Godo! Nu Yesusa beyana koyoos” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Piliphoosikka Indiraasas yootides. Indiraassinne Piliphoosi biidi Yesusas yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesusikka istas “Hekko Asa Nay bonchettiza saatey gakkides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ta intes tumu gays; giste ayfey biittan wodhdhada hayqqonta co7u ga uttikko barka attawus. Iza hayqqiza gidikko hara daro ayfawus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ba shempo dosizaddey dhaysses. Hayssa Biitta bolla ba shempo ixizadey gidikko merna de7o demmees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Taas ooththana koyizadey tana kaallo; Taas ooththizadey ta dizason daana; Taas ooththizade ta Aaway iza bonchana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Qasseka Yesusi “Hekko ta shempoya metotadus ‘Ta Aawawu! Ha saateype tana ashsha gooshaa?’ Ta hizgonta mala ta yiday hanno ha meto saateyssa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“Ta Aawawu! Ne ne suntha boncha” gides. Hessafe kaallidi “Tani ta suntha bonchadis; qasseka gujja bonchana” giza qaalay saloppe yides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Heen gadaan eqqida asay hessa siydi “Daday dadates” gida. Baggayti qasse “Kiitanchakko haasayizay” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesusi “Hayssi giirissay yiday inte gishassa attin ta gish gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Hayssi alamey pirdettana wodey hayssa; hayssa dereza haariza Xala7ey ha7i gede kare yegettana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Tani dhoqu gaada kaqettiza wode asa wursa taakko zaarana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesusi hessa yootiday izi ay mala hayqo hayqqanakko erissanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Asay qasse “Nu wogan xaafetiday ‘Xoossi kiittidadey mernas daana’ gees; Histin ne qasse waanada ‘Asa Nay dhoqu gi kaqqettana bessees’ gay? Ne giza Asa Nay awayssee?” giidi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesusi istas “Ha7i guutha wodes intenara poo7oy dees; gadey dhumonta poo7ora hammuttite; Qamara hamuttizaddey izi awa bizakkonne erenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Inte poo7o nayta gidana mala poo7oy dishin poo7on ammanite” gides. Yesusi hessa gidappe guye biidi ista ayfeppe geemmides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesusi istas hessa mala malata ista sinthan ooththinka Ayhudati izan ammanibeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Hessi haniday nabe Isayaassi “Godo! Nu markatetha ammaniday oonnee? Xoossa qaalay oonas qoncidee?” gida mala. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Hessa gish ammananas dandaybetenna; gaasoyka nabe Isayaassi kase, ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Isti ba ayfen beyidi, ba woznan yuushi qoppidi, simmonta malanne izi ista pathonta mala Xoossi ista ayfe qooqisides; ista woznakka muumisides” gi xaafida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isayaassi hessa giday Xoossi kiittidade boncho beyida gishassa; Hessa gish Yesusi yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Gidikkoka Ayhudata halaqatappe daro asay Yesusa ammanides. Gido attin ista Ayhudata Woosa Keeththafe goodonta mala Farsaaweetas babbidi ba ammano qoncen markatibeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Isti hessatho haniday istas Xoossafe imettiza bonchofe aaththidi asappe imettiza boncho dosida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesusi ba qaala dhoqu histidi “Tana ammanizadey tanan xalala gidonta tana kiittidayssanka ammanees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tana beyidaddey tana kiittidayssakka beyana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Tana ammanizay wuri dhuman doonta mala ta poo7o gidada hayssa ha alameza yadis. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ta qaala siydi ooththontade bolla pirdanay tana gidikke. Gaasoyka ta yiday alame ashshanas attin alame bolla pirdanas gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tana koyontadenne ta qaala ekkontade bolla pirdanadey dees; ta izas yootida qaalay wurseththa gallas iza bolla pirdana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Gaasoyka tani coo ta shenen yootabeykke; ta gizayssanne ta yootiza azazo taas immiday tana kiittida ta Aawa ");
INSERT INTO gmvRNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Iza azazoy merna de7o gididayssa ta erays; Hessa gish ta yootizay wuri Aaway taas yootidayssa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","He wodeykka Ayhudata Paaziga ba7aaleppe kase Yesusi hayssa alameza yeddidi Aawakko baana saatey gakkidayssa erides; hayssa alamezan diza ba baggata wursi siiqides. Wursethi gakkanaasikka dosides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesusinne iza kaallizayti issife kawo miishin Simoona nay Asqoroonto Yuhuday Yesusa aaththi immana mala Xala7ey iza woznan iita qofa gelthides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesusi Aaway izas godateth wursi immidayssanne izi Xoossa achchafe kezidi yidayssa, qasse simmidi Xoossako baanayssa erees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Hessa gish maadda bollafe dendidinne may7o qaari woththidi pooxa ekkidi xeessan gixxides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Toho meeciza gongen haaththe gujjidi bana kaallizayta toho meeche oykkides; Ba gixxida pooxanka meecida tohoza quccides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yesusi Simoona geetettiza Phexroosakko shiiqin Simoona geetettiza Phexroosi iza “Godo! Ne ta toho meecanee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesusikka “Tani ooththizayssa ne ha7i eraka guyeppe qasse ne erandasa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Phexroosikka “Ne ta toho mulekka meecakka” gides. Yesusi qasse “Ta ne toho meeconta aggikko neessinne taas issifetethi deenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoona geetettiza Phexroosikka zaaridi “Godo hessa gidikko taas toho xalala gidonta kushera hu7era wursa meeca” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesusi qasse “Ba asatethi meecettidades kumeththa bollay geesh gidida gish izas toho meechafe attin hara koshshenna. Inte geeshsha shin ubbata deekketa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesusi “Inte ubbatikka geesh deekketa” giday iza aaththi immanaddey oonakkonne eriza gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ista toho meecidappe guye ba may7o ekki may7idi kase ba uttidason simmi uttides. Qasse istas “Ta intes ay ooththidakkonne woznan woththidetii? ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Inte tana Astamarenne Goda geeta; Ta qas Astamarenne Goda gidida gish inte guussay tumukko. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Histikko ta intes Godanne astamare gidashe inte toho meeciza gidikko inteka inte giddon issoy issa toho meecana bessees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ta intes ooththidaysa mala inteka ooththana mala ta intes leemiso bessadis. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ta intes tumu gays; ashkaray godappe aadhdhenna; kiitettidadey kiitidadefe aadhdhenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Inte hayssa eridi ooson peyshshikko inte anjettidayta. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ta hayssa gizay inte ubbata gish deenna. Tani ta dooridayta wursa erays; gido attin ‘Ta kath midadey ta morke gididi ta bolla dendides’ giza maxaafa qaalay poletanas koshshees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ta hayssa ha7ira intes yootizay izi poletiza wode ta oonakkonne inte ammanana mala. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ta intes tumu gays; ta kiittidade ekkizadey tana ekkees; tana ekkizadey tana kiittidade ekkees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesusi hessa gi simmidi keehi qofan gelidinne “Ta intes tumu gays; inte giddofe issadey tana aaththi immana” giidi qoncen yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Iza kaallizayti hessa izi oona gish gidakkonne eronta gish ba giddon issoy issara xeeletida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Iza kaallizayta giddofe Yesusi siiqiza issoy Yesusa achchan uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoona geetettiza Phexroosi Yohannisa som7i bessidi “Izi oona gish gizakkonne ane iza oycha” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Hessa gish izi ba qoodhe gede Yesusa haythako shiishshidi “Godo! Izi oonnee?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesusikka zaaridi “Izaadey ta ha7i budena woxen dhim7ada barsizadde” gides. Hessa gi simmidi budena woxen dhim7i ekkidi Asqoroontofe yida Simoona naa Yuhuda barsides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuhuday iza baadhida mala heerakka Xala7ey izan gelides. Yesusikka Yuhuda “Ne ooththanas qoppidayssa elela ooththa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yesusi hessa aazas gidakkone maaddan uttida asappe yo7oy gelidadey oonikka deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yuhuday miish oykkizade gidida gish Yesusa kaallizaytappe baggati Yesusi Yuhuda “Ba7aalezas koshshizayssa shama woykko manqotas muxuwata imma” gida misatides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yuhudaykka budena baadhida mala heerakka kezidi bides. Izi bishin gadey qamakko. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuhuday kezi bidappe guye Yesusi “Asa Nay ha7i bonchettides; Iza gaason Xoossika bonchettides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Xoossi iza gaason bonchettiza gidikko Xoossika iza bonchana; heerakka gam7onta bonchana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ta nayto, ta intenara daro wode gam7ikke; inte tana koyana, ta kase Ayhudata halaqataska ‘Ta bizaso inte yaana dandayekketa’ gaada yootida mala ha7ikka inteska hessatho yootays. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Inte inte giddon issoy issara siiqettana mala ta intes ooratha azazo immays. Ta intena siiqida mala inte inte giddon issoy issara siiqetite. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Inte inte giddon siiqetikko inte tana kaallizayta gididayssa asi wuri erana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Hessafe guye Simoona geetettiza Phexroosi Yesusa “Godo! Ne awa baanee?” giidi oychides. Yesusi qasse “Ta bizaso ne ha7i tana kaallana dandayakka shin guyeppe ne tana kaallana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Phexroosi “Godo! Ta nena ha7i kaallanas ays dandayikkinaa? Haray attoshin tani ta shempoka ne gish aaththa immana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesusikka zaaridi “Neni ne shempo ta gish aaththa immanee? Ta nees tumu gays; hach kuttoy waassanappe kasetada ne tana heedzdzuto kadana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kaaleththidka Yesusi “Inte woznay metotoppo; Xoosse ammanite; tanaka ammanite. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ta Aawa achchan daro duussasoy dees; hessa gidontakko ‘Intes daanaso giigissanas ta baana’ gaanashin. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Baada ta intes so giigissidappe guye inte ta dizason daana mala ta simma yaada intena ekkana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ta biza oge inte ereeta” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toomaassi “Godo! Ne awa bizakkonne nu erokkoshin, ogeza nu wosti eranas dandayizonii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesusikka izas “Ogeynne, tumay, de7oyka tana; ta baggara gidikkofe attin oonikka Awakko baana asi deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Inte tana erizako ta Aawakka eranakoshin; ha7i hayssafe guye inte iza erana; iza be7okka beydeta” gi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Piliphoosi “Godo! Ne nuna Aawa bessikko nuus gidana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesusikka izas “Piliphoosa! Hayssa gakkanaas ta intenara de7inka ne tana erikii? Tana beyidadey Aawakka beydes; histin neni waanada ‘Nuna Aawa bessa gay? ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Tani ta Aawan, ta Aawayka tanan dizayssa ammanikkii? Ta intes yootiza qaala yootizay ta shene mala deenna; gido attin oosoza wursi ooththizay tanan diza ta Aawa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tani Aawan diza mala, Aawayka tanan dizayssa inte ammanite; akay giikko ta ooththiza oosota gishikka tana ammanite. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ta intes tumu gays; tana ammanizadey ta ooththiza ooso ooththana; hessafeka aaththi ooththana; gaasoyka tani Aawakko baana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Aaway naaza gaason bonchettana mala inte ta sunthan woossidayssa ta intes wursa ooththana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Inte ay miishika ta sunthan woossidayssa ta wursa ooththana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Inte tana dosiza gidikko ta azazoyo naagite. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Tani Aawa woossana; Izikka intenara mernas daana mala hara intena minthethanade intes immana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Hayssi minthethiza Ayanay dere asay iza beyi eronta gish alamey ekkanas dandayonta Tumu Ayana; gido attin inte iza ereeta; gaasoyka izi intenara diza gishshinne izi inte gaaththan diza gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Aawaynne aaya baynda nayta mala ta intena xalala aggikke; ta simmada ha inteko yaana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Guuththa wodeppe guye dere asay tana beyenna shin inte gidikko beyandeta; tani de7on diza gish inteka de7on daandeta. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tani ta Aawan diza mala inteka tanan dizayssanne takka intenan dizayssa inte he wode erandeta. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ta azazo ekkidi ooththizadey tana dosees; tana dosizaddekka ta Aaway doosees; Takka iza dosana; Tanaka izaades qoncisana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Asqoroonto Yuhuda gidonta hanko Yuhuday “Godo! Neni alame asas gidonta nuus wosta qoncisanee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesusikka izas “Tana siiqizadey ta qaala naagana; ta Aawayka iza dosana; nuni izakko yaana; yiidikka izaadera issife daana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tana dosontaddey ta qaala naagenna; hayssi inte siyiza qaalay tana kiittida ta Aawa qaalappe attin ta qaala gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Tani ha7i intenara dashe hayssa intes yootadis. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Aaway ta sunthan yeddana minthethiza Xillo Ayanay qas haniza wursi intena tamarsana; ta intes yootoyssaka wursi inte woznan wothana mala maaddana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ta intes saroteth gido aggada bays; ta sarotethikka ta intes immana; ta intes immiza sarotethi alamey immiza sarotetha mala deenna. Inte woznay hirgofonne babbofo. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“ ‘Ta baana; Baadakka inteko simma yaana’ gaada ta intes kase yootidayssa siyideta; inte tana dossizakko tani ta Aawakko bizayssi intena ufayssanakkoshin. Gaasoyka Aaway taappe aadhdhees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Hayssi haniza wode inte ammanana mala hayssa intes kaseta yootadis. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Hayssa alameza haariza Xala7ey yiza wodey gakkida gish ha7i ta intenara daro haasaykke; izi ta bolla aykkokka ooththanas izas wolqay deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Gido attin tani Aawa dosizayssa alamey erana mala Aaway tana azazidayssa ta wursa polana. Ane hayssafe boos; dendite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Qasseka Yesusi “Tumu woyne mitha anoy tana; atakilteza oosanchay ta Aawa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ta bolla dishe ayfe immonta hagga wursi ta Aaway qanxi diggana; ayfiza hagga gujji ayfana mala qirxi geeshshana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ta intes yootida qaala gaason inte ha7i geeshshata. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tanan diite; takka intenan daana; haggay woyne ano bolla doonta aggikko barka ayfe ayfana dandayontayssa mala inteka tanan doonta aggikko ayfe ayfanas dandayekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Tani woyne mithas ano; inte qas haggata; daro ayfe ayfizadey tanan dizaddenne takka izan dizadde; gaasoyka ta baynda inte aykkokka ooththanas dandayekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tanan bayndadey qanxettidi wora yegetida hagga mala kare yegettidi heen melana; heyta mala haggati issi bolla shiiqidi taman yeggetananne eexana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Inte tanan diikko ta qaalayka intenan diikko inte koyidayssa oychikko demmana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Daro ayfe inte ayfishin ta Aaway bonchettes; inte tana kaallizayta gididayssi hessan erettana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Aaway tana dosidayssatho takka intena dosadis; hessa gish inte ta siiqon diite. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tani ta Aawa azazo polada iza siiqon dida mala inteka ta azazo polikko ta siiqon daana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Hayssa ta intes yootizay ta ufayssi intenan gidana malanne inte ufaysika kumeth gidanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ta intes immiza azazoy ta intena siiqida mala inteka inte giddon issoy issara siiqetanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Asi ba lagges ba shempo aaththi immoppe aadhdhiza siiqoy deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ta Intena azazizayssa ubba inte polikko inte ta laggeta. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ashkaray goday ooththizayssa eronta gish hayssafe guye ta intena ashkarata giikke. Gido attin tani ta Aawappe siyidayssa wursa intes qoncisida gish ta intena ta laggeta gadis. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ta intena dooradis attin inte tana dooribekketa; inte biidi daro ayfe ayfana mala inte ayfey eqqi daana mala ta intena wothadis; hessa gish inte ta sunthan woossidayssa wursi Aaway intes immana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Hessa gish inte inte giddon issoy issara siiqettana mala ta intena azazays. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Kaalethidikka Yesusi intena alamey ixikko intefe kase tana ixidayssa erite. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Inte ammanonta alame asa gidikko alame asay ba bagga gididadde dosees. Gido attin inte alame bagga gidonta gish ta intena alameppe shaakada doorida gish derey intena ixees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‘Ashkaray godappe aadhdhenna’ gaada ta kase intes yootoyssa yuushi qoppite; isti tana goodizayti intenaka gooddana; Isti ta qaala naagizakko inte qaala naagana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Isti tana kiittidade eronta gish ta gaason inte bolla hessa wursi ooththana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ta yaada istas yootontakko istas nagara gidenna. Ha7i qas ista nagaras hanno giza gaasoy baawa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tana ixizadey ta aawakka ixees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Hara asi ooththonta ooso ta ista giddon ooththontako istas nagara gidennashin; ha7i isti hessa wursi beyidappe guye tanaka ta Aawakka ixida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Hessika haniday kase ‘Tana gaasoy baynda dishin ixida’ geetettidi ista wogan xaafetida qaalay poletanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Gido attin Aawappe kezidi yaanays takka ta Aawa achchafe intes yeddanays Tuma Ayanay minthethizays yiidi izi ta gish markattana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Inte koyroppekka tanara diza gish taas inteka markatandeta” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Qasseka Yesusi “Hekko hayssa wursa ta intes inte ammanoy yark yarkofo gaada yootadis. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Isti intena ba keeththafe gooddana; haray attoshin intena wodhizadey wuri Xoossas ooththizade misatiza wodey yaana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Isti hessatho ooththizay tanaka ta Aawakka eronta gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ta hayssa intes hara yootiza wode inte ta intes gidayssa qoppanassa” gides. Kaaleththidika Yesusa “Hayssa wursa ta intes yootonta aggiday ta intenara issife diza gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ha7i qasse tana kiittidayssako baana gays; gido attin intefe oonikka ‘Ne awa baanee?’ giidi oychanay baawa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Gido attin hayssa wursa ta intes yootida gish inte woznay muuzotes. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ta qasse intes tumu gays; ta buussi intes go7a gidana; gaasoyka ta boonta aggikko minthethiza Ayanay inteko yeenna. Ta bidappe guye iza inteko yeddana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Izi yiidi asa nagara gishshinne xillotetha gish qasseka pirda gish erisana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Asa nagara gish izi erisanay asay tana ammanonta gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Xillotetha gish izi asa erisanay tani ta Aawakko biza gishshinne qasse nam7antho inte tana beyonta gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Pirda gish izi erisanay hayssa alameza haarizayssa bolla pirdetida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ta intes buro yootana daro yo7oy dees; gido attin ha7i intena deexxana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tuma Ayanay yiidi intena tumay dizaso kaaleththana; gaasoyka izi siyidayssa yootana attin bappe gidonta gish izi sinthafe hanana yo7ota intes yootana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Taas dizayssafe ekkidi izi intes yootiza gish tana bonchana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Aawas gididay wurikka tayssa, ‘Taas gididayssafe ekkidi izi intes yootana’ ta giday hessassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesusi gujjidi “Guuththa wodeppe guye inte tana beyekketa; qasseka guuththa wodeppe guye inte tana beyana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Iza kaallizaytappe baggati ba giddon “ ‘Hayssi nuus guuththa wodeppe guye inte tana beyekketa; qasseka guuththa wodeppe guye inte tana beyana; Qasse ta Aawakko baana’ guussi ay guussee?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Histin hayssi ‘Guuththa wodeppe guye’ gizayssi izi aazee? izi yootizayssi nuus eretenna” giidi ba giddon zaari zaari oyshettida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Isti iza oychanayssa Yesusi eridi istas hizgides “Inte inte giddon issoy issara oyshetizay ta intes ‘Guuththa wodeppe guye inte tana beyekketa; qasseka guuththa wodeppe guye inte tana beyana’ gida gishassee? ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ta intes tuma gays, inte waassananne yeekkanashin alamey gidikko ufayettana. Inte muuzotishin inte muuzoy ufayssan laamettana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Macassi yelo wodey gakkishin miixas hirgawus shin naa yela yeggidappe guye biitta bolla nay yeletida gish ufayssafe dendidayssan kase ba waaydayssa zaara qopuku. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Hessatho inteka ha7i muuzoteta; qasse ta intena beyana inte woznaykka ufayettana; inte ufaysa zaari ekanadey deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Inte he wode taappe aykkoka woosseketa; Ta intes tumu gays; ta sunthan ta aawa woossikko izi intes wursikka immana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hanno gakkanaas inte ta sunthan aykkokka woossi erekketa; woossite inte ekkana; inte ufayssaykka kumeth gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ha7i gakkanaas ta intes leemisora yootadis shin hayssafe guye ta leemisora yootonta wodey yaana. Gido attin Aawa gish intes wursa qoncisa yootana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","He wode inte ta sunthan woossana; Takka ‘Aawa inte gish woossana’ giikke. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Gaasoyka Aaway ba baggara intena dosiza gishassa. Aaway intena dosizay inte tana dosiza gishassinne ta Xoossa achchafe yida inte ammanida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tani Aawa achchafe kezada hayssa ha alame yadissinne qasseka ha alameza aggada Aawakko ta simma baana” gides ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Iza kaallizayti “Hekko ne ha7i leemiso gidonta nuus qoncera yootadasa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ne wursa eriza malanne oonikka nena oychanas koshshontayssa ha7i nu eridos. Hessa gish ne Xoossa achchafe kezidayssa nu ammanoos” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesusi istas “Inte ha7i ammanideta; ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","gido attin inte inte baggara baggara laalettidi tana xalla aggana wodey gakkides; he saateyakka ha7i gakkadus. Gido attin Aaway tanara gidida gish ta tarka diikke. ");
INSERT INTO gmvRNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ta hayssa intes yootizay inte tanan de7in intes sarotethi daana mala gaada yootays. Inte ha alamen dishin intes waayey dees; gido attin aykkoy ba ta alame xoonadis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesusi hessa gidappe guye pude salo dhoqu gi xeelidi “Ta Aawawu! Hekko ha7i saatey gakkides; ne nay nena bonchana mala neni ne naaza boncha. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ne bonchanaykka ne izas immidaytas izi merna de7o immana mala ne izas asa ubba bolla godateth immida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Merna de7oyka ne xalala tumu Xoossanne Ne kiittida Yesus Kirstoosa ero guussa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ne taas immida ooso tani wursada ha biitta bolla nena bonchadis. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ta Aawawu! Alamey medhetanappe kase taas nenara diza bonchon ha7ikka tana ne achchan boncharki. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Hayssa alame asappe ne taas doorada immida asatas ne oonakkonne ta istas nena qoncisadis; isti kasekka neyta shin ne taas immadasa; istika ne qaala naagida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ne taas immidayssi wurikka neeppe gididayssa isti ha7i erida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ne taas immida qaalataka istas immadis; istika ekkida; ta ne achchafe yidayssa isti tumappe erida; ne tana kiittidayssakka isti ammanida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ta istas woossays; heyti ne taas immidayti isti neyta gidida gish ta istas woossays; gido attin hanko alame asas woossikke. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Taas gididay wurikka neyssa; neyssi wurikka tayssa; takka istan bonchettana. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Hayssafe guye tani hayssa alame bolla diikke; isti gidikko ha alame bolla deettes. Ha7i ta neekko bays; Geeshsha ta Aawawu! Hayta ne taas immidayta isti nu mala ba giddon issino gidana mala ne taas immida ne sunthan ista naaga. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ta istara issife dashe ne taas immida ne sunthan ta ista naagadis; hessa gish kase xaafetida Geeeshsha Maxaafa qaalay polettana mala izi kasekka dhayoos diza naazappe attin istafe oonikka dhaybenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ta qasse ha7i neekko bays; ta ha alameza bolla dashe hayssa yootizay ta ufayssi istan polettana mala gaada yootays. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Tani ne qaala istas immadis; tani ha alame as gidontayssa mala istika ha alame as gidettenna. Hessa gish ha alame asay ista ixxides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ne ista iitappe naagana mala ta nena woossays attin ne ista ha alameppe dentha efana mala ta nena woossikke. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tani alame as gidontayssa mala istika ha alame as gidettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ne ista ne tuman nees shaaka; ne qaalayka tumu qaala. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ne tana ha alame kiittoyssatho takka ista alameza bolla kiittadis. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Isti tumappe nees dumma as gidida mala tanikka tana ista gish dummassays. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ista qaala markatethan tana ammananayta gishara ta nena woossays attin ta nena ista gish xalala woossikke. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ta woossizay isti wurikka issino gidana malassa. Ta Aawawu! Qasseka ne tanan diza mala istika nunan gidana malanne ne tana kiittidayssa ha alamey ammanana mala ta nena woossays. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nuni nu giddon issino gidida mala istika ba giddon issino gidana mala ne taas immida bonchoza takka istas immadis. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ta nena woossizay ta istan; nekka tanan gidida mala istika kumeth issino gidana malassa. Qasseka neni tana kiittida malanne tana ne siiqida mala istaka ne siiqidaysa alame asay eranaassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ta Aawawu! Ne tana hayssi alamey medhetanappe kase dossida gish ne taas immida ta bonchoza isti beyana mala hayta ne taas immidaytikka ta dizason tanara daana mala dosays. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Xillo gidida ta Aawawu! Nena alamey eribenna; Ta gidikko nena erays; haytikka ne tana kiittidayssa erida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ne tana siiqida siiqoy istan gidana malanne takka istan gidana mala istikka nena erana mala ooththadis. Qasseka isti erana mala ooththana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Hessa wursi yootidappe guye Yesusi bana kaallizaytara Qediroone geetettiza shoobba pinnidi atakilte giddo gelides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesusinne iza kaallizayti kasekka he gadeyin daro wode issife shiiqiza gish Yesusa aaththi immida Yuhuday he gadeyo kasekka erees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Hessa gish Yuhuday wotadarata, Qeeseta halaqatanne Farsaaweetappe kiitetti yida ashkarata wursi kaalethi ekkidi he isti shiiqizaso yides. Izara yida asay paanose, xompe, mashshanne toora oykkidi yides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesusi ba bolla gakkanayssa wursi eridi yida asaakko biidi “Oona koyetii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Isti qasse “Naazirete Yesusa koyoos” gida. Izikka istas “Tani iza” gides. Istas aaththi immida Yuhuday istara issife eqqides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesusi “Ta iza” gida mala asati guye gandigaridi biitta bolla kundida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesusi ha7ikka “Oona koyetii?” giidi oychin isti zaaridi “Naazirete Yesusa koyoos” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Izikka zaaridi “Tani izakko! Histin inte koyizay tana gidikko hayti betto bochchofte” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Hessi haniday “Ta Aawawu! Ne taas immidaytappe issadekka ta dhayssabeykke” gida qaalay polettana malassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoona geetettiza Phexroosi giththa mashsha oykkida gish mashsha koohoppe shoddidi issi Qeeseta halaqa ashkara dizayssa haythe mashshara qanxi yeggides. He ashkaraza sunthi “Malkoosa” geetettes. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesusi qasse Phexroosa “Ne mashsha gede koohon zaara geltha. Aaway taas immida waaye ushsha ta uyonta aggana misatizee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Hessafe guye wotadarati, ista azazizayssinne Ayhudata ashkarati Yesusa oykkidi qachida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Koyro he laythan Qeesetas halaqa Qayaafa bollo Haannakko efida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Qayaafay “Dere gish issadey hayqqikko lo7o” giidi Ayhudata daannata kase zoridade. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoona geetettiza Phexroosinne Yesusa kaallizaytappe issadey Yesusa kaallida. Hessadey Qeeseta halaqa achchan keehi eretidade. Hessa gish Yesusara issife Qeeseta halaqaza gibbe gelides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Phexroosi gidikko pengefe kare baggara eqqides. Qeeseta halaqa achchan keehi eretidi Yesusa kaallizayssi yiidinne pengen diza garadeya Phexroosa gibbe giddo gelthana mala yootidi Phexroosa ekki gelides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Penge naagiza garadeya Phexroosa “Nekka hessa addeza kaalliza asatappe issa diikkii?” gadus. Izi qasse “Tani iza kaallizade gidikke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Wodey meeggiza wode gidida gish oosanchatinne ashkarati tama eththidi eqqon ho7ettes. Phexroosikka istara eqqidi ho7ees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","He wode Qeeseta halaqay Yesusa iza kaallizayta gishshinne izi tamarsida timirte gish oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesusikka izas “Ta asa ubbas qoncen yootadis; Ayhudati shiiqiza ista Woosa Keeththan gidinka Xoossa Keeththan tamarsadis; ta qotan haasayidazi aykkoykka deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Histin ne tana oychizay aazee? Ta yootishin siyidayta oycha; ta yootidayssa isti ereetes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesusi hessa gida mala heen eqqida ashkaratappe issoy “Qeeseta halaqas hayssatho wosta zaaray” gishe Yesusa shagalan baqa shaayides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesusikka zaaridi “Ta iita haasayida gidikko ane ta gooyssa ne markata; Ta yootiday likke gidikko tana aazas baqqay?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hessafe guye Haannay Yesusa qachida mala Qeeseta halaqa Qayaafakko yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","He wode Simoona geetettiza Phexroosi eqqidi tama ho7ishin hanko asay iza haysso! Ne Yesusa kaallizaytappe issa diikkii?” gida. Izikka zaaridi “Ta iza kaallizade diikke” giidi kadides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kase Phexroosi iza hayth qanxidayssa dabboy Qeeseta halaqa ashkaratappe issoy “Wona ta nena atakilteson istara dishin beyabekkinaa?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Phexroosi qasseka kadides; heerakka kuttoy waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Hessafe guye Yesusa Qayaafa keeththafe dere ayssiza kawoza gibbe malado wontara ekki bida. Ayhuda asas Paaziga ba7aale dorsa asho miza wode gidida gish bana tunisonta mala giidi maladora dere ayssizayssa gibbe giddo gelibetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Hessa gish Philaxoosi gede istako kezidi “Hayssa addeza inte aazas mootetii?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Isti qasse “Hayssi addezi iita ooththontade gididakko nu iza nees aaththi immokkoshin” gida ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Philaxoosika “Inte iza ekki biidi inte woga mala pirdite” gides. Ayhudata ayssizayti qasse zaaridi “Nu asi wodhana mala nuus piqadey imettibenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Hessika haniday Yesusi kase istas izi waani hayqqanakkonne yootida qaalay polettana gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Philaxoosi qasseka guye gibbe giddo gelidi Yesusa xeygisidi “Ne Ayhudata kawoo?” giidi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesusikka zaaridi “Ne hessa gizay neeppeyee? woykko hara asati ta gish nees yootidoo?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Philaxoosikka “Ta Ayhuda asee? Nena taas aaththi immidayti ne baggatanne Qeeseta halaqatakko; ne ay ooththadii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesusikka “Ta kawotethi hayssa ha alame bolla gidenna. Ta kawotethi hayssa ha alame bolla gididakko Ayhudata daannata kushen ta kundonta mala ta ashkarati ta gish olettanakkoshin ta kawotethi gidikko ha alame bolla gidenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Philaxoosika “Histin ne kawoo?” gides; Yesusi qasse “Tani ne gidayssa mala ee kawo; ta yeletidaynne ha biitta yiday tuma gish markattanassa. Tumappe gididay wuri ta qaala siyees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Philaxoosikka “Tumay aazee?” gides. Hessafe guye Philaxoosi nam7antho Ayhudatakko kezidi “Ta iza bolla aykko bala beyabekke. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Gido attin kasekka ta intes Paaziga ba7aale gallas issi qasho asi birshiza mala hayssa Ayhudata kawo intes birshana mala koyeetii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Isti gidikko “Nuus Barbaane birsha attin hayssa deenna!” giidi waassida. Barbaaney ba hu7es panga. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Hessafe guye Philaxoosi Yesusa efidi garafissides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Wotadaratikka aguntha zawude xaaxidi Yesusa hu7en woththida; zo7o kaabaka mayzida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Izakko shiiqi shiiqidi “Ayhuda kawo saro! saro!” gi giidi iza shagalan baqqida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Philaxoosi qasseka kare kessidi “Hekko ta iza bolla aykko mooroka demmontayssa inte erana mala ta iza intes haa kare kessana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Hessa gish Yesusi aguntha zawude hu7en woththi ekkidinne zo7o kaaba may7idi kare kezides. Philaxoosika istas “Hekko addezi hayssich!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Qeeseta halaqatinne ista ashkarati Yesusa beyidi “Ne iza kaqqa! Kaqqa!” gishe waassida. Philaxoosi qasse “Ta ta baggara iza bolla issi mooroka demmabekke; koykko inte efidi kaqqite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ayhuda asati qasse “Nuus wogay dees; hayssi addezi bana Xoossa naa giza gish nu woga mala izas hayqoy bessees” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Philaxoosi hessa isti gizayssa siydi daro babbides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Gede gibbe gelidi Yesusa “Ne awappe yadii?” giidi oychides. Yesusi qasse izas ay zaaroka immibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Hessa gish Philaxoosi “Ne taas yootikii? Ta nena kaqqanas woykko birsha yeddanas godateththi taas dizayssa erikii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesusikka izas zaaridi “Sheney nees Xoossafe imettontako nees ta bolla ay godateththika deennashin; gido attin tana nees aaththi immidade bolla gita nagaray dees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Philaxoosi hessa Yesusa haasaya siyidappe guye iza birshi yeddana koyides shin Ayhudatas babbida gish isti “Ne hayssa addeza birshikko Oroome Kawo Qeesare bagga gidakka; gaasoykka bana barka kawothizadey wuri Qeesares morke” gishe wurikka waassida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Philaxoosi hessa siyida mala Yesusa gede kare kessidi “Lochcha shuch” geetettiza soon pirda womboran uttides. He pirdasoy Ayhudata qaalara “Gabata” geetettes. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","He wode gadey asi Paaziga ba7aales giigettiza gallassa. Wodeykka gallassafe usuppun saate mala gidides. He wode Philaxoosi Ayhudata “Hekko inte kawoy hayssich!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Gido attin isti qas “Gede digga! Gede digga! Kaqqa!” gishe waassida. Philaxoosika “Ta inte kawo kaqqoo?” gides. Qeeseta halaqati zaaridi “Nuus Qeesareppe hara kawoy deenna” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hessafe simmidi Philaxoosi Yesusa kaqqana mala istas aaththi immides. Istika Yesusa oykki ekki efida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Hessafe guye Yesusi ba kaqqettana masqaleza tookkidi “Asa hu7e guuge” geetettizaso kezides. Hesoy Ayhudata qaalara “Golgota” geettettes. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Iza heen kaqqida. Yesusa giddo gelthidi hara nam7u asata izatho hadirisaranne ushachara kaqqida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Philaxoosi “Naazirete Yesusi Ayhudata kawo” giza qaala xaafidi iza masqale bolla izas hu7esora qaaphides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yesusi kaqqettidasoy katamas mata gidida gish daro Ayhuda asay Philaxoosi xaafidayssa nabebides. Xaafetidaysikka Ayhudata qaalara, Laatine geetettiza qaalaranne Girike qaalara. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ayhudata Qeeseta halaqati Philaxoosa “Ne iza Ayhudata kawo” gaada xaafoppa. Gido attin “ ‘Hayssi addezi bana ta Ayhudata kawo gides’ gaada xaafa” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Philaxoosi qas “Ta xaafidayssa xaafadis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Wotadarati Yesusa kaqqidappe guye iza may7oza ekkidi wotadarata issa issa gakkana mala oyddu kessi shaakerethida. Garsara may7iza may7ozakka hessatho shaakerethida. Gido attin giddora may7iza may7ozi siketonta pudeppe duge gakkanaas coo yeda dees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Hessa gish wotadarati ba giddon “Gishan oona gakkanakkonne erana mala iza bolla saama yeggana attin daakkokko” gida. Hessika haniday kase “Ta may7o isti gishetti ekkida, ta bollara may7iza may7oza bolla saama yeggida” geetettida Geeshsha maxaafa qaalay polettana malassa. Wotadaratikka hessa ooththida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesusa masqale achchan iza aayeyanne aayeyi micheya Qaliyoopha macha Maaramanne Meg dale geetettizasoppe yida Maarama heen eqqida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesusi ba aayeyonne izi siiqiza iza kaallizayssi ba achchan eqqidayta beyidi, ba aayeyo “Aayee! Ne naaza hessa beya” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Hessafe kaaleththidi bana kaallizayssa “Ne aayo hinno beya” gides. Hinno he saateyppe simmin he iza kaallizayssi aayeyo baso efides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Hessafe guye Yesusi ha7i wurikka poletidayssa eridi Geeshsha Maxaafan xaafetidayssi polettana mala “Tana saamees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Heen gadaan caala phanqida ushshi kumi uttida issi xaaro malay dees. Hessa gish heen gadaan dizayti he caala ushsha zandza misatiza safnage geetettizayssara hisophe geetettiza mitha xeeran qaaphidi iza duunakko shiishida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesusi he caala ushsha xunxi xeelidi “Polettides!” gides. Ba hu7e duge ziqqisidi shempo kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Hessafe guye Ayhudata daannati kaqettida asata meqeth wodirappe menthidi isti iza masqale bollafe wothana mala Philaxoosa woossida. Isti hessa ooththiday Ayhudati sambatas giigettiza gallas gidida gishshinne he sambataykka daro gita ba7aale gidida gish Sambata gallas ahay masqale bolla gam7onta mala koyda gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Hessa gish wotadarati biidi Yesusara kaqettida asata meqeth wodirappe wodirappe menthida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Isti Yesusakko biin izi kasetidinne hayqqidayssa beyidi iza wodira meqeth menthibeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Gido attin wotadarata giddofe issadey toorara iza millen caddin heerakka suuthinne haaththi gukkides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Hessa beyidaddey inte izan ammanana mala markattides. Iza markaykka tuma. Izi yootizaykka tumu gididayssa izi erees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Hessika haniday “Iza meqethafe issinaka meqquku” geetettida Geeshsha maxaafa qaalay poletanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Qasseka Geeshsha Maxaafan harason “Isti ba cadidade beyana” gees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ayhudata daannata babbidi qotan Yesusa kaalliza Armatiyasa geetettizasoppe yida Yoosefey Yesusa aha ekkanas Philaxoosa woossin Philaxoosikka izas ero gides. Hessa gish Yoosefey biidi Yesusa aha ekkides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Kase Yesusakko qamara yida Niqodimoosikka bagga kilo gidiza karbenne godare uuthara walaketida shitto ekki yides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","He nam7u asati Yesusa aha ekkidi Ayhudati aha xaaxiza mala shiito puukkidi lee7e may7ora xaaxida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesusi kaqqettidason issi atakiltesoy dees. He atakiltezason oonikka moogetonta ooratha duufoy dees. ");
INSERT INTO gmvRNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ayhudata sambatas giigetiza gallas gidida gishshinne duufoykka matan diza gish Yesusa aha heen moogida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Wogga gallas wonta malado buro bazzoy zo7ishin Magdale Maarama Yesusa duufokko badus. Iza he gakkishin kase Yesusa duufo izara gordida shuchchay duufoza duunappe dendidi genderidayssa beyadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Hessa gish iza Yesusa kaallizaytappe Simoona geetettiza Phexroosakko Yesusi dosiza hanko iza kaallizayssako woxxa baada “Goda duufoppe kessi ekkidi awan woththidakkone nu erokko” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Heerakka Phexroosinne Yesusa kaalliza hinko issoy kezidi gede duufoy dizaso bida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nam7aykka issife woxxida. Gido attin Yesusa kaalliza hinkoyssi Phexroosappe pilati woxxidi kaseti duufoy dizaso gakkides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Duufoza hokki xeelidi ahay izan xaaxettida may7oy xalla dizayssa beyides; gido attin gede duufoza giddo gellibeenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoona geetettiza Phexroosikka iza kaalli gakkidi duufoza giddo gelides; ahay izan xaaxettida carqay heen dizayssa beyides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Yesusa hu7ey xaaxettida carqay hanko xaaththa carqatara gidonta dumma harason xaaxetti dizayssa beyides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Koyrotti gakkida Yesusa kaallizayssika duufoza giddo geli beyidi ammanides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Gaasoyka “Izi hayqoppe dendana bessees” giza maxaafa qaala isti buro haasayibeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hessafe guye nam7atikka simmidi baso baso bida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Magdale Maarama yeekkashe Yesusa duufoppe karera eqqada hokka duufoza giddo xeelladus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Yesusa ahay dizason bootha may7o may7ida nam7u kiitanchatappe issoy hu7eson issoy tohoson uttidayta beyadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Istika Maaramo “Hanne macasaye! Aazas yeekkay?” gida. Izakka “Isti ta Goda efidi awan woththidakkone ta erike” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Iza hinno gaada guye yuuyishin Yesusi eqqidayssa demmadus shin izi Yesusa gididayssa erabeyku. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesusi izo “Hanne macasayee! Aazas yeekkay? Qasse oona kooyay?” gides; izikka izis atakilte naagizade misatin “Godo! Ne ekkida gidikko ne woththidaso taas yootarki; Ta iza taas ekkana” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesusi izo “Maarame!” gides; izakka gede izakko simmada Ayhudata qaalara “Rebuune!” gadus; Hessa birsheththi “Astamaree!” guussa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesusi qas “Ta buro pude ta Aawakko kezabeekke; tana bochofa; gido attin ne ha7i ta ishataako baada ‘Tani ta Aawakkone inte Aawakko, ta Xoossakkonne inte Xoossako kezana gides’ gaada istas yoota” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Hessa gish Magdale Maarama Yesusa kaallizaytakko baada iza Yesusa beyidayssanne izi izis yootidayssa istas yootadus. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","He gallas wogga omars Yesusa kaallizayti Ayhudata daannatas babbidi kare ba bolla goordidi keeththa giddon shiiqon dishin karey doyettonta Yesusi iza kaallizayti shiiqi diza keeththa gelides; ista giddon eqqidi “Saroy intes gido!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Hessa gi simmidi ba kushetanne ba mille ista bessides; iza kaallizaytikka Goda beyidi keehi ufayetida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Hessafe guye qasseka Yesusi ista “Intes saroy gido! Ta Aaway tana kiittida mala takka intena kiittays” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Hessa gi simmidi ista bolla ufu giidi “Inte Xillo Ayana ekkite. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Inte asa nagara atto giikko istas atto geetettana; inte asa nagara atto goonta ixikko qas intes atto geetettenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesusi bana kaallizaytakko yida wode tammanne nam7atappe issoy Didimoosa geetettiza Toomaassi istara deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Hessa gish hanko Yesusa kaallizayti Toomaasa “Nu Goda beydos” gida. Toomaassi qas “Misimaaren cadettida iza kusheta tani ta ayfera beyonta dashe, qasseka ta biradhdhe misimaarey gelidason geltha xeellonta dashenne ta kushe iza mille madunthan geltha xeellonta dashe ammanikke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Hessafe kaallin osupun gallassafe guye iza kaallizayti qasseka keeththa giddon dishin; Toomaaska istara issife dishin; kareykka gordan dishin Yesusi yiidi ista giddon eqqidi “Saroy intes gido!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Hessafe guye Toomaasa “Ne biradhdhe ha ehada ta kusheta beya. Ne kushe ha ehada ta millen geltha ammana attin ammanontade gidoppa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toomaassi “Ta Godo! Ta Xoosso!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesusikka Toomaasa “Neni tana beyida gish ammanadasa; tana beyonta ammanizayti gidikko isti anjettidayta” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Hayssa maxaafan xaafetonta daro malatata bana kaallizayta sinthan Yesusi ooththides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Gido attin Yesusi izi Masihe, Xoossa naa gididayssa inte erana malanne inte iza sunthan ammanidi de7o demmana mala hayssi xaafetides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Hessafe guye Yesusi Xibiraadoose Abba achchan bana kaallizaytas qasseka beettides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoona geetettiza Phexroosi, Didimoosa geetettiza Toomaassi, Galila Qaana as gidida Natina7eeley, Zabidoosa naytikka Yesusa kaallizaytappe hara nam7atikka wuri issife dishin ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoona geetettiza Phexroosi istas “Ta mole oykkana bays” gides; istika izas “Nukka nenara baana” gida. Izara kezi biidi wogolon gelida shin he gallas omars issi molekka oykkibetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Gadey wontishin Yesusi abba achchan eqqides; iza kaallizayti qas izi Yesusa gididayssa eribeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesusi ista “Nayto moley dizee?” gides; istika “Aykkoyka baawa” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Izikka “Giteza wogolozappe ushacha baggara abban yeggite; inte demmana” gida gish giteza abba giddo yeggidanne daro moley oyketida gish giteza molezara goochana dandaybeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Hessa wode Yesusa kaallizaytappe izi siiqiza issoy Phexroosas “Hessi Godakko!” gides. Simoona geetettiza Phexroosi “Hessi Godakko!” giza qaala siyida mala kase ooso diggofo giidi may7o qaari woththidi kallo diza gish heerakka may7o ekki may7idi abba giddo guppi gelides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yesusa kaalliza hankoyti qas biittafe xeetu metre mala haakki diza gish moley kumi diza giteza goochchi ekkidi wogolora gakkida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Isti wogolozappe wodhdhishin moley iza bolla diza bonqo tammanne ukethi beyida. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesusi ista “Ha7i inte oykkida molezappe ane ha ekki yiite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Hessa gish Simoona geetettiza Phexroosi wogoloza giddo gelidi xeetanne ichashu tammanne heedzdzu wogga gita moleti kumida giteza abbafe gede gade bolla goochchides. Hessa mala daro molera diinka gitezi daakkettibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Hessafe guye Yesusi ista “Ha yiidi miite” gides. Izi Goda Yesusa gididayssa wuri erida gish iza kaallizaytappe issadeykka “Ne oonnee?” gi oychanas xalidadey baawa. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesusi yiidi ukethanne moleza ekkidi istas immides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesusi hayqoppe dendin iza kaallizayti iza beyishin hayssi heedzdzantho. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Isti mi giigishin Yesusi Simoona Phexroosa “Yoona naa Simoona! Haytantafe ne tana aaththa tana dosay?” gides. Izikka “Ee ta Godo! Ta nena dosizayssa nekka eraasa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesusi iza “Ta dhammizayta heemma” gides; nam7anthokka “Yoona naa Simoona! Ne tana dosay?” gides; Izikka zaaridi “Ee Godo! Ta nena dosizayssa nekka eraasa” gides; Yesusi qasseka “Laaqqata naaga” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Heedzdzantho “Yoona naa Simoona! Ne tana dosay?” gides. Izi heedzdzantho “Ne tana dosay?” gida gish Phexroosi michetidinne “Godo! Ne wursa eraasa ta nena dosizayssakka ne eraasa” gides; Yesusikka qasseka “Ta dorsata heemma. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ta nees tumu gays; ne naatethan dashe ne giththe nerka gixxada ne koyidaso baasashin; ne cimmiza wode gidikko neni ne kusheta piddisin hara asi nena gixxisananne ne dosontaso nena efana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesusi iza hessatho giday Phexroosi ay mala hayqon Xoosse bonchanakkone izas erisanassa; hessafe guye Phexroosa “Ne tana kaalla” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Phexroosi yuushi xeelidi Yesusi dosizayssi iza kaallishin beyides; hessadey kase isti kawo miishin Yesusa haythako shiiqidi “Godo! Nena aaththi immanadey izi oonnee?” gi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Phexroosi iza beyidi “Godo! Hayssadey waanandee?” giidi Yesusa oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesusikka izas “Ta ha simma yaana gakkanawu ta iza paxa woththikko nena aazi gaththidee? Ne tana kaalla” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Hessa gaason ishata giddon “Izi hayqo hayqqenna” giza worey laalettides. Gido attin Yesusi “Ta yaana gakkanaas paxa daana mala ta koykko nena aaze gaththiday?” gides attin “Hayqqaka” gibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","He yo7ota gish markattidaynne xaafiday ha Yesusa kaallizayssa; iza markatethikka tumu gididayssa nuni eroos. ");
INSERT INTO gmvRNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesusi ooththida hara daroti deettes. Taas misatiza mala izi ooththida miishata wursi issi bolla xaafizakko xaafetiza maxaafata hayssi alamey tookkana dandayenna.");
INSERT INTO gmvRNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tofiloosa, Yesusi ooththanassinne tamarsanas oykkidayssa wursa ta nees koyro maxaafan xaafadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Hessika izi pude dentha gallas gakkanaas ba doori kiittidaytas Xillo Ayana baggara izi istas immida azazokko. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Izi daro waaye beyidappe guye Istako shiiqidi hayqoppe dendanayssa istas daro markara qoncisishe oyddu tammu gallas gakkanaas istas gallas gallas beettishe Xoossa Kawoteththa gish yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Istara issife maaddan utti dishe ista “Yerusalameppe kezoppite; gido attin ta intes yootishin inte siyidayssa ta Aaway immida ufayssa naagite. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohannisi haaththan xammaqides shin inte qas guuththa wodeppe guye Xillo Ayanan xammaqettana” giidi azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Istika issi bolla shiiqeti dishe “Godo! Ne Isra7eeleta kawoteth zaarada ha7i essanee?” gi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Izikka istas “Aaway ba shenen woththida wode eroy intes imettibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Gido attin Xillo Ayanay inte bolla wodhdhida wode inte wolqa ekkana. Yerusalamenka, Yuhudanikka, Samaariyanka ubbason biitta gaxa gakkanaas inte taas markata gidana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Hessa gi yootidappe guye isti xeellishin pude salo dendides. Salo shaaraykka ista ayfeppe iza geenthides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Izi bishin isti iza tishshi histi pude salo xeellishin booththa may7o may7ida nam7u asati qopponta ista achchan eqqidi; ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Inteno Galila asato! Inte pude salo xeellishe hayssan aazas eqqidetii? Hayssi inte matappe pude salo dendishin inte beyiza Yesusi salo kezishin inte beyida mala hessathoka izi ha simmi yaana” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Hessafe guye Dabrazayte geetettiza zuma bollafe wodhdhidi Yerusalame simmida. He zumaykka Yerusalameppe issi kilo metre mala haakkees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Gede katamayo gelida wode kase ba diza keeththa Pooqe bolla kezida; heytikka Phexroosa, Yohannisa, Yaqoobe, Indiraasa, Piliphoosa, Toomaasa, Bartelemoosa, Matoosa, Ilfiyoosa naa Yaqoobe, ba bagga maaddizade geetettiza Simoonanne Yaqoobe naa Yuhuda. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Heyti wurikka macasatappe Yesusa aayo Maaramira hessathoka iza ishatara issi woznan issi bolla qanxonta minni woossida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","He gallasatan Phexroosi xeetanne nam7u tammu ammaniza asa giddon eqqidi, ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Ta ishato! Yesusa oykkida asata kaalethi ehida. Yuhuda gish Xillo Ayanay kasetidi Dawute duunan haasayida Geeshsha maxaafa qaalay polettana koshshees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Izikka nuuppe issade mala taybettidi hayssa ha oosozan gellanas qaada demmides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Gidikkoka hayssadey ba iita ooson demmida miishan gade shamides; henka ba liiphen gufanni kundin iza asatethay giddofe phalqeti wodhdhides; iza maracey biitta bolla zaazetides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Hessika Yerusalamen diza asas ubbas siyettides. Biittaykka ista qaalara “Akeldama” geetettides; hessas birsheththayka suutha biitta guussa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Gujjidikka Phexroosi “Mazamure maxaafan ‘Iza gadey mela atto, izan ay asikka dooppo; qasseka iza daannateth hara asi ekko’ geetetti xaafettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Hessa gish Goda Yesusi nunara diza wode ubban nunara issife dizayta giddofe nu issade dooranas koshshees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Hessika Yohannisa xinqateppe haa simmin Yesusi nuuppe shaaketi dendi baana gakkanaas nunara dizadde gidanas bessees. Gaasoyka ha asatappe issadey nunara Yesusa denthas marka gidana koshshees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Hessa gish Barsabaasa woykko Yosxoosa geetettiza Yoosefenne Maatiyaasa nam7ata shiishshidi, ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","“Godo! Ne asa ubba wozna eraasa; hayta nam7ata giddofe ne oona dooridakko issade nuna bessa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Yuhuday yeggi bidason ha oosa ooththanadenne Hawaare gidanadde ne doora” gi woossida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Hessafe saama yeggin saamay Maatiyaasas kezides. Izikka tammanne issi Hawaaretara issife tayibettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Phenxaqoste geetettiza ba7aale gallassi gakkida wode asay wurikka issi soon shiiqi dishin; ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","qofay baynda daro mino gote carko mala giirissi yides; asay diza keeththakka kumides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tama laco inxarsa malay asas beettidi shaaketi shaaketi issi issi asa bolla uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ammanizayti wuri Xillo Ayanan kumidi Ayanay istas haasayanas immidayssa keena hara qaalara haasaya oykkida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","He wode salo gufanthon diza dereppe yida Xoossas babbiza Ayhudati Yerusalamen deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","He giirissa siydi derey shiiqides. Issi issi asay ba qaalara haasayizayssa siydi malalettida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Malaletidinne gaanazi dhayin “Hayti haasayizayti wurikka Galila as deettenee? ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Histin nuni nu yeletida nu dere qaalara isti haasayishin wosti siyizonii? ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nuni Pharteena asay, Meede asay, Eelaame asay, Mesopotoomiyan, Yuhudan, Qophodooqiyan, Phanxoosan, Iisiyan, ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Firgiyan, Phinfiliyan, Gibxen, Qareena achchan diza Liibiyappenne Oroomeppe yidayti ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ayhudatinne gede Ayhudatethan gelida Qarxeese asanne Araabe asata gidishin Xoossa wolqama oosoza hayti nu qaalara haasayishin nu siyoos” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wurikka keehi malalettidinne gaanazi dhayin ba giddon “Hayssi aazeshaa?” geetettida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bagga asay “Hayti daro woyne cajje uyida” giidi ista qidhida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","He wode Phexroosi tammanne issinetara eqqidinne ba qaala dhoqu histidi deraas hizgides “Inteno Yuhuda asato! Yerusalamen dizayto! Inte wurikka hayssa issi miish eritenne ta gizayssa siyite. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ha7i gadey wontin buro heedzdzu saate gidida gish inte qoppiza mala hayti asati mathotibeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Gido attin hayssi kase nabe Iyu7eelen hizgi yootetida qaalay poletanassa, ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Xoossi Wursetha gallas ta Ayana asho may7ida ubba bolla ta gussana; inte maca naytinne inte attuma nayti tinbite haasayana; yelaga nayti ajjuta beyana; Cimati agumo agumettana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","He wode ta maca ashkarata bollanne ta attuma ashkarata bolla ta Ayanappe ta gussana. Istika tinbite haasayana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Bolla Salon malalisiza hanota ta bessana, garsa sa7an malatata ta bessana; suuthi, tamaynne tulalay hanana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Gitanne boncho gidida Goda gallassi yaanappe kasetidi awa arshey dhumana; Aginaykka suuth misatana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Goda sunth xeygizay wuri attana’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Isra7eele nayto! Hayssa qaala siyite; inte inte baggara erizayssa mala inte giddon malatanne asi siyi eronta miishata iza kushen ooththidi Xoossi Naazirete Yesusas markatides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Xoossi kase ba qachidayssa izas beni eratetha mala hayssade inte kushen aaththi immides. Inteka iita asata kushen kaqeti hayqqana mala ooththideta. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Gido attin Xoossi iza bollafe hayqo wolqa diggidi hayqoppe denthides. Hayqoyka iza oykki ashshanas dandaybenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawuteykka iza gish ‘Tani Goda ubba wode ta sinthan beyays; izi ta ushachan dees; mulekka hirgike. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Hessa gish ta woznay ufayetees; ta duunaykka galatees; ta ashoy ufayssan daana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ne ta shempoyo Duufon aggaka; ne naa geeshshaza wooqana mala aggaggakka. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ne de7o oge ta erana mala ooththadasa. Ne tanara diza gish ta ufayssay kumeththa’ ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Ta ishato! Beni aawatappe Dawutey hayqqi moogetiddayssanne iza duufoy hach gakkanaas nu achchan dizayssa babbonta ta intes yootana danda7ays. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Izi nabe gidida gish Xoossi iza zerethafe issade iza kawoteththa alga bolla wothanayssa kase caaqo qaalan yootidayssa erides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Hessa kasetidi erida gishshinne iza ashoy wooqi Duufon attonta doorettida Kirstoosa dentha gish haasayides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","He Yesusa Xoossi hayqoppe denthides. Nukka wuri hayssas markata. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Hessa gish izi Xoossa ushachchan dhoqu dhoqu gidappe guye Xillo Ayana ufaysa ba aawappe ekkidi ha7i inte beyizayssanne siyizayssa duge gussides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Dawutey pude salo kezibenna; izi ba duunan ‘Goday ta Godas “Ta ne morketa ne toho garsan yedhissana gakkanaas ta ushachchan utta” gides.’ ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Hessa gish Xoossi inte kaqqida Yesusa Godanne Kirstoosa histidayssa Isra7eele asay wuri lo7ethi ero” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Derey hessa siyida mala woznay boshettides. Phexroosanne hanko Yesusi kiittidayta “Nu ishato! Histin nu ay ooththinoo?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Phexroosikka “Maarotethan gelite; inte nagaray maarettana mala intefe issi issi asi Yesus Kirstoosa sunthan xammaqettite; izi immiza Xillo Ayana inte ekkana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ufayssa qaalay intessinne inte naytassa; qasseka Goda Xoossi baako xeygiza haahon dizaytassara ubbassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Hara daro qaalara istas markatishe “Hayssa geella yeletethafe intena ashshite” giidi ista qofisides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","He gallas qaala ekkidaytinne xammaqetidayti heedzdzu shi mala asay kaseyta bolla gujettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Istika Hawaareta timirten, issife quma muussaninne woossan minnida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Hawaareta kushen daro malatati oosettida gish asi ubbay istas babbides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ammanidayti wurikka issife de7ida; baas dizazikka ubba issi bolla go7ettida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Baas diza miishenne mehe bayzi bayzi ba giddon koshshida mala gishechchida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Gallas gallas Xoossa Keeththan issife shiiqetes. Ba keeththanka quma issife ufayssaninne suure woznara meetes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Isti Xoossa galatishe dere sinthan bonchettida. Godayka ista bolla gallas gallas oorath ammanizayta gujjides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Issi wode gallassafe uddufun saate bolla Phexroosinne Yohannisi woossa saaten Xoossa Keeththe baana kezida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Issi yeletosappe doommidi tohoy silidade Xoossa Keeththe geliza asappe miishe woossana mala asay gallas gallas tookki efidi woththin issi “Lo7o” geetettiza Xoossa Keeththa pengen woossizadey dees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Izikka Phexroosinne Yohannisi Xoossa Keeththe gelishin beyida istafe miishe woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Phexroosinne Yohannisi iza tishshi histi xeellida. Phexroosikka iza “Ane haa nuna xeella” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Addezikka istafe aykko demmana giidi ista tishshi histi xeellides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Gido attin Phexroosi izas zaaridi “Taas biraynne worqay deenna; gidikkokka taas dizaz ta nees immays; Naazirete Yesus Kirstoosa sunthan dendada ne tohora hamuta” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Izas ushachcha kushe oykkidi denthides. Heerakka addeza tohoynne toho qirphey minnides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Guppi dendi eqqidi hamuth oykkides. Yaanne haanne hamutishenne guppishe Xoossaka galatishe istara issife Xoossa Keeththa gibbe gelides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Izi Xoossa galatishe yaanne haane simerettishin asay beyides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Hayssadey hannife kase “Lo7o” geetettiza Xoossa Keeththa pengen uttidi miishe woossizay iza gididayssa erides. Iza bolla hanidayssafe dendidayssan asay keehi malaletides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ha paxida woossanchay Phexroosakonne Yohannisakko shiph giidi istara oykketi dishin derey wuri malaletidi istako “Solomoone simeretethaso” geetettizaso wothan yides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Phexroosi he asa beyidi “Inteno Isra7eele dereto! Hayssan aazas malaletetii? Qasseka hayssa addeza nuni nu wolqan woykko nuni nu xillotethan pathidi hamutissida mala qoodidi nuna aazas tishshi histi xeelletii? ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nu aawanta Abrahaamenta, Yisaaqanta, Yaqoobenta Xoossi ba naaza Yesusa bonchides. Inte qas iza hayqos aaththi immideta; Philaxoosi izi birshana koynka inte ‘Koyokko’ gideta. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Geeshshanne xilloza inte kadidi shempo wodhizayssi birshettana mala woossideta. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","De7o immizade inte wodhideta; gido attin Xoossi iza hayqoppe denthides; hessas nuni marka. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Hayssi inte beyizayssinne inte erizayssi minni eqqiday Yesusa sunthan ammanida gishassa. Inte wurikka beyiza mala izi kumeththa paxa demmiday Yesusa sunthaninne iza sunthan beettiza ammanona. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ha7ikka ta ishato! Inte hessa ooththiday inte halaqata mala eronta gididayssa ta erays. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Gidikkoka Kirstoosi waaye ekkanayssa Xoossi kase nabeta duunan haasayidayssa polides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Hessa gish inte nagaray qucceti dhayana mala maarotethan gelite. Inte biza ogeppe simmite; Goda matappe inte ooraxana wodey intes yaana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Qasseka Xoossi kase intes doori woththida Yesus Kirstoosa izi intes yeddana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Xoossi kase geeshsha nabeta duunan haasayidayssa mala hanizayssa wursi ooraxissana wodey gakkanaas izi salon gam7anas koshshees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Museykka ‘Inte Goda Xoossay inte giddofe ta mala nabe intes denthana. Izi intes yootizayssa siyite. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","He nabeza siyonta ixida shempoy wuri dere giddofe shaaketi dhayo’ ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Tumappe Sameelappe ha simmin dendida nabeti wuri hayta wodeta gish haasayida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Inteka nabeta nayta. Qasseka Xoossi Abrahaames ‘Ne zerethan biitta asi wuri anjettana’ giidi izi caaqida caaqoza inte laattana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Xoossi naaza denthida wode intena issa issa inte iitatethafe zaaridi anjana mala kasetidi inteko kiittides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Phexroosinne Yohannisi asas haasayan dishin Qeeseta Halaqatinne Xoossa Keeththa naagizayta halaqay qasseka Saduqaaweti akekonta istako yida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Yiidinne Hawaareti asa tamarsizayssassinne Yesusa baggara bettida hayqqidayta dentha gish sabakizayssas keehi hanqettida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Phexroosanne Yohannisa gadey qammishin oykidi wontana gakkanaas qasho keeththan ayssida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Gido attin qaala siyida asappe dariza baggay ammanides. Ammaniza attuma asata qooday gede ichashu shi gakkanaas dhoqu gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Wontetha gallas ista halaqatinne cimati qasseka Muse woga tamarsizayti Yerusalamen shiiqida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ista Qeeseta halaqa Haanaynne Qayaafay, Yohannisi, Iskindirosinne Qeeseta halaqaso asay wuri he gadaan bettida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Istika Phexroosanne Yohannisa ba giddon aaththi essidi “Hayssa inte ooththizay aaza wolqanee? Woykko oona sunthanee?” giidi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","He wode Phexroosi Xillo Ayanan kumidi “Inteno dere halaqato! Dere cimato! ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Inte hach ha toho sila addezas oosettida lo7o oosoy waani izi paxidakko inte nuna oychiza gidikko, ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","inte kaqqin Xoossi hayqoppe denthida Naazirete Yesus Kirstoosa sunthan izi paxidayssanne inte sinthan izi eqidayssa inteka Isra7eele dere asay wuri hayssa erite. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Izikka inte keeththa hiillati leqqi aggida shuchchay ginbe keeththas gula bolla bollara woththiza shuch gidides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Atotethi hara oonanka ba; saloppe garsa baggara nu asa nayti attana mala nuus imettiday hayssafe hara sunthi deenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ayhudata duulata asaykka Phexroosinne Yohannisi hessatho xali haasayizayssa beyidi isti tamaronta as gididayssa eridi malaletidanne isti kase Yesusara dizayta gididayssa akeekida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","He paxida addezi istara eqqidishin beyida gish istas hara ooththanas gaasoy dhayides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Hessa gish ista duulatappe kessana mala azazida. Hessafe qasseka shiiqetidi ba giddon zoretida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ba giddon “Hayta asata wostinoo? Yerusalamen diza asay wuri ista kushen hanida gita malata erides. Hessa gish nu ha yo7oza asa baleththanas dandayokko. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Gido attin hayssi yo7ozi dere giddon keehi aakkonta malanne hayti asati nam7antho hayssa ha sunthan hara oonaska yootonta mala istas lo7ethi yootana” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ista xeygidinne mulekka Yesusa sunthan haasayonta malanne tamarsonta mala azazida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Phexroosinne Yohannisi qasse zaaridi “Nuni Xoossafe bollara intes azazettanas bessizakonne ane inte Xoossa sinthan pirdite. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nuni nu beyidayssanne nu siyidayssa haasayanappe guye gookko” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Qasseka ista bolla mandidi yeddida. Gaasoyka hanko derey wuri hanida yo7oza gaason wurikka Xoosse galatiza gish ista qaxayanas dandaybetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","He gita malatan paxida addezas laythi oyddu tammafe bolla. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Phexroosinne Yohannisi qashoppe birshettidi gede ba asatakko simmidi Qeeseta Halaqatinne Dere cimati ista gidayssa wursika yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Istika hessa siyida mala ba qaala dhoqu histidi issife Xoossakko “Wogga Godawu! Neni salonne sa7a, abbanne abba giddon dizayta wursa medhadassa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ne ashkara nuus aawa Dawute duunara Xillo Ayanan ‘Dere asay aazas hanqetti dendidee? Derey aazas mela maqetizee? ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Biitta kawoti issife gaaggidi biitta haarizayti issi bolla shiiqettidi Goda bollan ne dooretti tiyettidayssa bolla duulatida’ giidi waassida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Tumappe Herdoossinne Phanxoosa Philaxoosi Isra7eelataranne hara dere asara hanno katamayn ne doora tiyida geeshsha naaza Yesusa bolla yo7o qachanas shiiqetida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Hayssanka ne wolqaninne ne shenen kase ne qoppidayssa isti polida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Godo! Ha7ikka ista mandeza ne beya; nuni ne aylleti ne qaala babbonta kumeththa xalatethara yootana mala dandayissa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pathanas ne kushe micca. Ne naa geeshshaza sunthan gita malata ooththa” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Isti woossidappe guye isti dizasoy qaaxides. Wurikka Xillo Ayanan kumidi Xoossa qaala xalatethan yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ammanizayti wurikka issi woznaninne issi qofan gaaggi deettes. Istas dizay wuri issi bolla dees attin baas dizaz “Hayssi taas buzo miisha” gizaddey deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Hawaaretikka Goda Yesusa dentha gita wolqan markateth oykkida. Ubba bolla gita Xoossa kiyatethi dees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ista giddon metotanchay issadeykka baawa. Gaasoyka gade gidin keeththe gidin baas diza wursi bayzi bayzi shiishida miish ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Hawaareta kushen woththidi issi issades izas koshshiza mala gisheettes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Qophiroose geetettizason diza Yoosefe geetettizadey issi Lewe bagga asi dees. Izikka Hawaaretan “Barnabaasa” geetetti summides. Hessas birsheththay “Minthetho naa” guussa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Izikka ba gade bayzida miisha ehidi Hawaareta kushen woththides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Issi Hananiya geetettiza asi Saphphira geetettiza ba macheyra ba gade bayzides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Macheya Saphphiray lo7etha erishin gadeza bayzida miishafe bagga shaakki ashshidi bagga ehidi Hawaareta kushen immides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","4","Qasse Phexroosi “Haysso Hananiya! Neni Xillo Ayana bolla wordotanassinne gade miishafe ashshana mala Xala7ey ays ne woznan gelidee? Bayzanappe kase gadezi neyssa gidenee? Ne bayzidappe guye qasse miishay ne kushen deenee? Histin ne hayssa mala wosta ne woznan qoppadii? Ne Xoossa bolla wordotadassa attin asa bolla gidenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hessa siyida mala Hananiyay kundi hayqqides. Hessa siyida asay wuri daro babbides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Attumasay dendidi aha xaaxidinne heerakka efidi moogides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Heedzdzu saateppe guye macheya izi waanidakkonne eronta dashe yadus. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Phexroosikka “Ane taas yoota; inte gadeza bayzida waagay hanno xallaa?” gides. Izakka “Ee hanno ha waagayn bayzidos” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Phexroosikka “Inte Xoossa Ayana paacanas aysi issi duuna gididetii? Hekko ne azina moogida asati moogi simmidi karen penge bolla deettes. Isti nenakka kessi ekki efana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Iza siyida mala heerakka iza toho bolla kundada hayqqadus. Attumasaykka soo gelida mala hayqqidaro beyidi kessi efidi izi azina achchan moogida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kumeththa Woosa Keeththa asaynne hessa siyida asay wuri daro babbides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Hawaaretikka dere giddon daro malatanne malalisiza miish ooththida. Ammanizayti wuri “Solomoone simeretethaso” geetettiza pengen shiiqeetes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Istas babbida gish oonnikka istara walakketanas koyibenna. Gido attin derey ista keehi bonches. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Daro macasattinne addeti wodeppe woden Godan ammani ammani ista bolla gujettida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Hessa gaason Phexroosi aadhdhishin haray attin iza eeshoy harganchatappe bagga harganchata bolla wodhdhana mala hargizayti ichchiza alga bollanne hala bolla karen ishiseetes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yerusalame yuushon diza katamatappe hargizaytanne tuna ayanay waayssizayta ehin wuri paxida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Hessa wode Qeeseta Halaqaynne izara diza Saduqaaweta baggati wurikka qanate qanatizayta xalla gidida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Hawaareta oykkidi qasho keeththe gelthida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Gido attin Goda kiitanchay qamara qasho keeththa kare doyidi ista kessidi, ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Biidi Xoossa Keeththa gibbe giddon eqqidi hayssa de7o qaala ubba deres yootite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Gadey wontida mala istas yootidayssa Xoossa Keeththa gibbe gelidi dereza tamarso oykkida; Qeeseta halaqaynne izara dizayti yiidi Ayhudata duulatanne Isra7eele dere cimata kumeth issi bolla shiishida. Hawaareta qasho keeththafe ekki yaana mala as yeddida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kiiteti bida asati biidi ista qasho keeththan demmibeetenna; simmidinne ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Qasho keeththay lo7ethi qulfeti dees; naagizaytikka penge bolla eqqi dishin beyidos; gido attin nu doy gelishin qas keeththan oonikka ba” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Xoossa Keeththi naagizayta halaqaynne Qeeseta Halaqatika hessa siyida mala hanozan daro malaletidanne istas hanoy wuri tikki gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Heerakka issi asi yiidi “Hekko inte qasho keeththe gelthida asati Xoossa Keeththa gibbe giddon eqqidi dere tamarson deettes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Xoossa Keeththe naagizayta halaqay ba oosanchatara biidi ista oykki ekki yides. Oykki ehidaytti asay bana shuchchara caddonta mala babbidi wolqathonta loddara ehida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","28","Hawaareta ehidi Ayhuda duulata sinthan essida. Qeeseta halaqaykka ista “Hayssa ha sunthan inte tamarsonta mala intes lo7ethi yootidoskoshin inte inte timirteza Yerusalame ubban kuntheta. Qasse nunakka ha addeza suuthas oyshetizayta histanas gixxi dendideta” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Phexroosinne hanko Hawaaretikka zaaridi “Nuni asappe aaththidi Xoossas azazettanas bessees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","“Inte iza mitha bolla kaqqi wodhida Yesusa nu aawanta Xoossay iza hayqoppe denthides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Izikka Isra7eele naytas nagarappe simmidi maarettana mala Xoossi iza ubbafe bollanne ashshizade histidi ba ushachchan dhoqu dhoqu histides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nunikka hayssas markata. Qasseka Xoossi baas azazettiza oonaska immida Xillo Ayanaykka marka” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Asati hessa siydi iita hanqo hanqettida. Wodhanakka koyda. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Gido attin dere achchan keehi bonchettida issi woga astamare, izikka Gamalyaale geetettiza Farsaaweeta baggay dere cimata giddon dendi eqqidi Hawaareti guuththa wode karen gam7ana mala azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Dere cimatas hizgides “Isra7eele asato! Inte hayta asata bolla ooththanayssa daro akeekkara ooththanas bessees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Hayssafe kase issi Tewoodaasa geetettizadey bana gita as histi qoodi dendin oyddu xeetu derey iza kaallides. Gido attin izi asa kushen hayqqides. Iza kaallizaytikka coo laalettin iza hanoy coo mela attides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Izappe guyekka derey taybetiza wode Galila Yuhuday dendidi daro dere banara kaalethides. Bana kaallizaytaka demmides shin izikka dhayides. Iza kaallizaytikka wuri dhayida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Hessa gish ta ha7i intena gizay hayta asata aggite, bochchofte. Ista qofay woykko ista oosoy asappe gidikko dhayana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Xoossafe gidikko qas inte ista teqanas dandayekketa. Oone erizay inte Xoossara oyeetishe beettanakkonne” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Istika iza zoreza ekkidi Hawaareta xeygidi garafissida. Nam7antho Yesusa sunthan haasayonta mala azazidi yeddida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Hawaaretikka iza suntha gish kawuyanas bessiza gish daro ufayetishe dere cimata achchafe kezi bida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Gallas gallas Xoossa Keeththaninne issa issa keeththan Yesusi izi Xoossi dooridade gididayssa tamarsofenne sabakoppe mulekka guye gibeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ammanizayta qooday dari dari biza wode Girike biittafe yida Ayhuda asati Yuhudan diza Ayhuda asa guyera zigirettida. Gaasoyka ubba wode miza kath gishishe am7eta wudetonta aggida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Hessa gish nu tammanne nam7u Hawaareti ammaniza harata issi bolla shiishshidi “Nuni kaththa gishon gelidi Xoossa qaala tamarso agganas bessenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hessa gish nu ishato! Inte giddofe eranchata, Xillo Ayanan kumidaytanne lo7o markateth diza laapun asata doorite; hayssa alafeteth nu istas immana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nuni gidikko woossaninne qaala yooton minnana” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Isti gida yo7oy siyidayta ufaysides; Ammanoninne Xillo Ayanan kumidayti Istifanoose, Piliphoosa, Phirosqoroosa, Niqaroona, Ximoona, Pharmenanne Yuhudatethan gelida Anxokiya dere as Niqoloosa doorida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Heyta ehidi Hawaareta sinth shiishida. Istika ba kushe ista bolla woththidi istas woossida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Xoossa qaalay akki akki bides. Ammanizayta qooday Yerusalamen dari dari bides. Qeesetappe daroti ammanida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","He wode Istifanoossi Xoossa immotethaninne wolqan kumidi dereza giddon gita malalisiza malatata ooththides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Wozeti kezida geetetti xeeygetizasoppe Ayhudata Woosa Keeththafe yida as gidida Qareenappenne Iskindiriyappe; qasseka Kilqiyappenne Iisiya awurajjatappe yida asatikka wuri Istifanoosera marshetida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Gido attin eratethan izi haasayiza haasayanne izan diza Ayana eqqetanas dandayibeetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Hessa gish “Istifanoossi Musenne Xoosse cayishin nu siyidos” giza asata guyera giigissida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","He wode dereza, dere cimatanne woga tamarsizayta dentheththidine Istifanoose oythidi dere duulatakko shiishida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Iza bolla “Hayssi addezi hayssa Xoossa Keeththa bollanne woga bolla cashsha qaala haasaya mulekka aggibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Gaasoyka hayssi addezi ‘Naazirete Yesusi hayssa Xoossa Keeththa dhayssana’ gishininne ‘Nu Museppe ekkida woga laammana’ gi haasayishin nu siyidos” gi wordora markattiza asata shiishshidi markasida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Duulata uttida asay wuri Istifanoose tishshi histi xeellishin iza ayfesoy istas kiitancha ayfeso misati beettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Qeeseta halaqay Istifanoose “Hayssi ne bolla shiiqida yo7ozi tumee?” gi oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Istifanoossika hizgides “Ta ishato! Ta aawato! Ta gizayssa siyite! Nu aawa Abrahaamey Kaarane geetettizaso yaanappe kase buro Mesopotoomiyan dishin boncho Goday izas qoncidi, ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Ne dereppenne ne dabbofe shaaketada ta nena bessizaso ba’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Izikka Kaldaweta biittafe kezidi Kaarane geetettiza biittan uttides. Iza aaway hayqqidappe guye inte ha7i dizaso ha dere iza ehides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Haray attoshin issi tohoy eqqiza gadey izas hayssafe immetibenna. Gido attin he wode izas issi naykka baynda dishin izinne izappe guyen iza zerethi Biittayo laattana mala Xoossi izas caqqides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Qasseka Xoossi izas hizgi yootides ‘Ne zerethi allaga biittan bete as gidana. Oyddu xeetu layth aylletetha qambara giddon waayettana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Gido attin ista aylle mala haariza dere ta qaxayana. Hessafe guye isti he biittafe kezidi hanno ha soyn taas goynnana’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Hessafe guye qaxxara woga caaqo izas immides. Abrahaameyka Yisaaqa yelidi iza ospuntha gallas qaxxarides. Yisaaqaykka Yaqoobe yelides. Yaqoobeykka tammanne nam7u qommota yelides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“He qommota aawati Yoosefe bolla qanatidi iza aylletethas duge Gibxe bayzida. Gido attin Xoossi izara dees; ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","meto ubbafe iza ashshides. Gibxe kawo Paaroone sinthan boncho immides. Paarooney iza Gibxe biittaninne ba keeththa asa ubba bolla alafetethan shuumides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“He wode Kanaaneninne Gibxen daro meto ehida gita koshay dendides. Nu aawataska miza kaththi dhayides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yaqoobey Gibxe deren kaththi dizayssa siydi nu aawata koyro Gibxe yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Isti nam7antho biza wode Yoosefey izi oonakkonne bana ba ishatas qoncisides. Paarooneykka Yoosefe ishata erides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Hessafe guye Yoosefey kiittidi ba aawa Yaqoobenne laapun tammanne ichashu gidiza ba dabbota kumeth ehisides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yaqoobey duge Gibxe wodhdhides. Izikka nu aawatikka wuri heen hayqqida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ista ahaykka Seekeme geetettizaso efin Abrahaamey Eemoore naytappe ba miishan shammida duufon moogetides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Xoossi Abrahaames caaqida qaalay poletiza wodey matishin Gibxen diza nu asa qooday dari dari bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Hessafe guye Gibxe biittan Yoosefe eronta hara kawoy kawotides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Izikka nu asa ba gene ooson metothides. Buro yelettida guutha nayti hayqqana malanne yelida nayta kare kessi wora yeggana mala wolqathides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","He wode Musey yeletides. Izikka Xoossa achchan dosettida mala lo7o naa gidides. Ba aawa keeththan heedzdzu agina al7isson diccides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Izi gede wora yegetida wode kawo Paaroone maca naya demmada baas ekkadus. Ba naa mala ooththada dichchadus. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Museykka Gibxeta aadhdho eratetha wursi tamarides. Yo7on era; oosonka mino gidides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Muse laythi oyddu tammu gidida wode Musey ba ishata Isra7eele nayta beyanas ba woznan qoppides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Izikka issi Gibxe asi Muse bagga asappe issade bolla qoho gaththishin beyidi ba bagga addeza maadides; he Gibxe addeza wodhidi he qohetidayssa halo kessides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Muses Xoossi iza kushen ista wozanayssa iza asay akeekkiza misatides. Gido attin isti hessa yuushi qoppibetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Wontetha gallas qasseka Isra7eele naytappe nam7ati ba giddon oyeetishin gakkidi oyeetizayta giigissanas koydi ‘Hayto! Asato inte inte giddon ishantakko; inte waanidi issoy issa qoheetii?’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","28","“Ba laggeza bolla qoho gaththidayssi Muse sugi yeggidi ‘Nena nu bolla nuna haarizadenne nu bolla pirdizade ooththi shuumiday oonee? Woykko qamma Gibxe addeza wodhoyssatho tanakka wodhana koyay?’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musey hessa siyida mala Midiyaame biitta beettidi heen bete as gidi de7ides; Yaanka nam7u attuma naa yelides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Hessafe oyddu tammu laythafe guye Siina zuma achchan diza bazzo biittan qeeri wora giddon eexiza tama lacon kiitanchay izas beettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","Museykka iza beyida mala malaletides. Azakkonne shaakki eranas izi heen izakko shiiqishin Goda qaalay ‘Tani ne aawanta Xoossa Abrahaame, Yisaaqanne Yaqoobe Xoossa’ gishin siydes. Museykka daro daggamides; xeellanaska xalibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","34","“Godayka izas ‘Hayssi ne eqqidasoy geeshshaso gidida gish ne tohoppe caamma shodda. Gibxen diza ta dereta waaye ta tumappe beyadis; isti waassiza waaye waasoza ta siyada ista ashshanas wodhdhadis. Ne ha7ikka haaya; ta nena duge Gibxe zaarada kiitana’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Histin heyti ‘Nu bolla nena haarizadenne pirdizade histi ooni shuumidee?’ giidi asay kase kadhida Muse Xoossi qeeri wora giddon izas bettida kiitancha baggara ista haarizadenne ashshizade histidi istako zaari yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Izikka ista kaalethidi Gibxeppe kessides. Gibxen, Zo7o Abbaninne bazzo biittan oyddu tammu laythi daro malalisiza miishatanne gita malatata istas ooththides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Isra7eele naytas ‘Ta mala nabe Xoossi inte giddofe denthana’ gidayssi hayssa Musekko! ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Izikka Siina zuma bolla haasayida kiitancharanne bazzo biittan nu aawatara dere duulata giddon dees. De7o qaalakka ha nuus aaththanas ekkides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Nu Aawati gidikko izara eqqetida attin izas azazettanas koyonta gish ba woznara guye Gibxe simmida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aaroneska ‘Nu sinthara biza eeqa nuus giigissa! Nuna Gibxeppe kaalethi kessida Musey waanidakko nu erokko’ gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","He wode mara misile medhidi eeqas yarsho shiishida. Barka medhdhida ba kushe ooson ufayetidi guppida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“Gido attin Xoossi istas zokko zaarides. Isti salo xoolintetas goynnana mala aaththi immides. Hessika nabeta maxaafan ‘Inteno Isra7eele nayto! Inte bazzo biittan oyddu tammu layth diza wode intefe yarshonne muxuwata taas shiishshi eretii? ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Harappeka inte goynnanaso ooththida eeqa Molooke dunkananne inte eeqa Rafaanne xoolinte misileza dhoqu dhoqu histi oykkideta. Hessa gish ta intena inte dizasoppe denthada Babiloonera aaththa yeddana’ geetettidi xaafettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Xoossi Muse bessida leemisoza malanne azazidayssa mala oosettida Xoossi asara gaaggiza dunkaneya nu aawatara bazzo biittan de7adus. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nu Aawati dunkaneyo ekkidayssafe guye Xoossi Iyaaso kaaleththin kase ista gooddida dereta laattida wode dunkaneyo ekki geellida. Dawute wode gakkanaas dunkaneya he biittan de7adus. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawuteykka Xoossa sinthan boncho demmidi Yaqoobe Godas aqoso giigissanas woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Gido attin Solomooney izas aqqoso keexxides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","50","“Gido attin wogga Goday asa kushey keexida keeththan deenna. Hessika nabey kase Geeshsha maxaafan xaafetida mala ‘Saloy ta uttiza alga; biittaykka ta tohon yedhdhizaso; histin inte taas ay mala keeththe keexxetii? woykko ta shempanasoy awayssee? Hayssa wursi ta kushey ooththibenee?’ gees Goday Xoossay. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Inteno wozna muumeto! Haytha tulleto! Inteka inte aawata mala ubba wode Xillo Ayanara eqetteta. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nabetappe inte Aawati gooddonta nabey oonee? Xilloza Yohannisa kaseti yootida nabetaka wodhida; inteka ha7i iza aaththi immidetanne wodhideta. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kiitancha baggara intes imettida woga ekkideta attin naagibeekketa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Duulatan diza asay hessa siyida mala daro hanqettidi, iza bolla ba achchi garcides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","56","Gidinka Istifanoosi Xillo Ayanan kumidinne pude salo tishshi histi xeellishin Xoossa bonchon Yesusi Xoossa ushachchan eqqidayssa beyidi “Hekko ta saloy doyettidayssanne Asa Nay Xoossa ushachchan eqqidayssa beyays” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Hessa wode asay qaala dhoqu histi waassishe ba haythe tucci oykidi izakko issife woxxides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Istifanoose oykkidi katamappe gede kare olida. Shuchchan cach oykkida. Hessi wuri hanishin markatikka ba may7o Sawule geetettiza paantha achchan woththida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Isti shuchchara iza caddishin Istifanoossi “Ta Goda Yesusaa ta shempoyo neekko ekka” giidi woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Qasseka gulbatidi dhoqa qaalan “Godo! Haytanta nagara qoodoppa” giidi waassides. Hessa gidappe guye hayqqides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sawuleykka Istifanoose hayqon istara qofan gaaggides. He wode Yerusalamen diza ammanizayta bolla gita goodeteththi dendides. Hawaareti attaafe ammanizayti wuri Yuhuda awurajjaninne Samaariya awurajjan ubban laalettida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ayana ooson minni eqqida asati Istifanoose moogidi, izas daro yeekkida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sawuley qasse Woosa Keeththa dhayssanas gixxi dendides. Ammaniza asa issa issa keeththe gelidi macatanne addeta goochchi goochchi kessidi qasho keeththan gelthides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Laalettidayti wuri ba bidason bidason Xoossa qaala yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Piliphoosikka Samaariya geetettiza katama wodhdhidi asas Kirstoosa sabakides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Daro derey Piliphoosi ooththiza malata beyidi izi yootiza qaala woznappe lo7ethi siydes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tuna ayanatikka daro asappe waassi waassi kezida. Daro toho silatinne wobetikka paxida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Hessa gish he katama asay daro ufayetides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Gido attin hessafe kase he katamayin maro marotidi Samaariya asa daro malalisizaz ooththiza issi Simoona geetettiza maroy dees. Izikka bana gita asa mala qoodizade. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Asay wuri guuthatappe gitata gakkanaas wurikka “Hayssi addezi gita wolqama geetettiza Xoossa wolqa” gishe izi gizayssa wursi woznappe siyees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Daro wode ba marotetha ooson asa malalisida gish asay iza woznappe kaallishe gam7ides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Gido attin Piliphoosi Xoossa Kawoteththa gishshinne Yesus Kirstoosa gish sabakidayssa siydi ammanida macasaynne attumasay xammaqetides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simoonikka ammanidi xammaqetides. Piliphoosakka kaalli biidi haniza gita malata beyidi malalettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yerusalamen diza Hawaareti Samaariya asay Xoossa qaala ekkidi ammanidayssa siydi Phexroosanne Yohannisa Istako kiittida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Istika Samaariya gakkidi ammanida asay Xillo Ayana ekkana mala asas woossida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Gaasoyka he wode isti coo Yesusa sunthan xammaqetida attin buro Xillo Ayanay istafe issade bollakka wodhdhibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Hessa gish Phexroosinne Yohannisi ba kushe asa bolla woththin asay Xillo Ayana ekkides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoonikka Hawaareti kushe woththi woossin Xillo Ayanay imettizayssa beyidi Phexroosasinne Yohannisas miishe ekki yiidi, ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Ta iza bolla ta kushe woththizadey wuri Xillo Ayana ekkana mala hayssa mala godateth taaska immite” giin, ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Phexroosi izas zaaridi “Xoossa imota ne miishan shammana qoppida gish neni ne miishara issife dhaya. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ne woznay Xoossa sinthan suure gidonta gish nees hayssa ha oosozan gishay woykko qaaday deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Hayssa ne iitatetha gish ha7i elle maarotethan gela; ne wozna qofa nees atto gaanakkonne nees Goda woossa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gaasoyka neni iitatethan kumidayssinne makalan qasheta uttidayssi taas beettees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoonikka zaaridi “Inte gida yo7otappe aykkoykka ta bolla gakkonta mala taas Goda woossite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Phexroosinne Yohannisi Goda qaala markattidayssafenne qoncisi yootidayssafe guye daro Samaariya gutatan mishiraachcho qaala sabakishe Yerusalame simmida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Goda kiitanchay Piliphoosa “Denda! Yerusalameppe duge baggara gede Gaaza efiza bazzo ogara ba” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Izikka dendi bides. Hindeko geetettiza Tophiyappe gidida kawoya ba keeththaninne ba kawoteththan diza ubba miisha bolla alafetethan woththida issi Tophiya gundula asi izara gaaggides. He addezi Xoossas goynnana Yerusalame bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Izi heeppe simmishe para-gaaren uttidi nabe Isayaasa maxaafa nababes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ayanay Piliphoosa “Ba! Gede para-gaarezakko shiiqa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Piliphoosikka eesotidi para-gaarezakko biidi addezi nabe Isayaasa maxaafa nababishin siydi “Hessi ne nababizayssi nees gelizee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Gundula addezikka “Tana erisiza asi baynda ta wosta eroo?” gides. Izikka gede iza gaarezan geldi iza achchan uttana mala woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Izi nababiza maxaafay “Izi dorsa mala shukettana laagettides; dorsa laaqay isike qanxizayssa sinthan co7u giza mala hessathoka izi ba duuna pogibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bana kawushshidi pirday bayndade gidides. Iza shempoy biitta bollafe diggettides. Iza yeletetha gish haasayana dandayizay oonee?” gees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Gundula addezikka zaaridi Piliphoosa “Nabezi hayssa oona gish gizee? Ba gish gizeyee? Woykko hara asa gish gizee? Hayana, taas yootarki!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Piliphoosikka ba duuna doydi he maxaafappe doommidi Yesusa Mishiraachcho qaala gish markattides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Isti issife bishe haaththi dizaso gakkida. Addezikka “Hekko haaththi hayssan dees; histin ta xammaqetonta mala diggizay aazee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Piliphoosikka “Ne kumeththa woznappe ammanikko xammaqettana dandayassa” gides. Addezikka “Yesus Kirstoosi Xoossa Naa gididayssa ammanays” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Addezi para gaarezi eqqana mala azazin nam7ay issife haaththan wodhdhin Piliphoosi addeza xammaqides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Isti haaththafe kezishin Xoossa Ayanay Piliphoosa denthi efides. Addezi hessafe guye iza beybenna. Gido attin ufayssan ba oge bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Hessafe guye Piliphoosi Azaxoone geetettizason beettides. Qisaariya geetettizaso gakkanaas izi biza oge bolla kataman ubban mishiraachcho qaala sabakides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sawuley Goda ammaniza asa wodhanas ceeqqettishe Qeeseta halaqakko bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Goda oge kaallizayta macasatanne addeta demmi qachidi Yerusalame ekki yaanas Damasqo geetettizason diza Ayhudata Woosa Keeththas babdaabe xaafana mala Qeeseta halaqa woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Damasqo gakkana matishin qopponta saloppe poo7oy iza yuushon pol7u gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Izikka heerakka biitta bolla kundidi saloppe “Sawule, Sawule, tana aazas goodday?” giza qaala siydes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sawuleyka “Godo! Ne oonee?” gides. Izikka izas “Tani ne goodeththiza Yesusakko!” ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Ne ha7i dendada gede katama gela; ne ooththanas bessizaz nees ta yootana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sawulera issife biza asati qaala giiris sissafe attin oonakka beyonta gish ba duuna oykki eqqida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sawuley ba kundidasoppe dendidi ayfe doyi xeelliza wode aykkokka demmanas dandaybenna. Hessa gish izara diza asati iza kushe oykkidi kaalethi ekkidi Damasqo efida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Heedzdzu gallas gakkanaas qooqidinne kath haaththe beybenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasqon issi Hananiya geetettiza ammanizadey dees. Izas Goday ajjutan “Hananiya” giidi xeygides; izikka “Yee Godo!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Godayka iza “Denda! Suure geetettiza ogeyra Yuhuda geetettizaso ba. Heen Sawule geetettiza issi Xarseese asi woossishe dees; ne iza koya demma. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Gaasoyka Hananiya geetettizayssi Sawuley dizaso yiidi izi xeellana mala iza bolla ba kushe woththishin ajjutan beyides.” ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Hananiyaykka zaaridi “Godo! Hayssadey Yerusalamen diza geeshshata bolla ay mala iita meto gaththidakkonne ta daro asappe siyadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Izi haa yiday ne suntha xeygizayta wursi qachanas Qeeseta halaqatappe godateth ekkidikko” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Godayka izas “Ne ba! Hayssi addezi Ayzaabeta sinthaninne kawota sinthan hessathoka Isra7eele dere sinthan ta sunth tookkana mala izi taas doorettidayssa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Izi ta suntha gish ay mala waaye beyanakko ta iza bessana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hananiyay biidi izas yootetidaso gelides. Sawule bolla ba kushe woththidi “Ta isha Sawule ne ha yishin nees oge bolla qoncida Goda Yesusi ne ayfey xeellana malanne neni Xillo Ayanan kumana mala tana neekko kiittides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Heerakka Sawule ayfeppe poqo malay poqeti wodhdhin izi xeellana dandayidessinne dendidi xammaqetides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kaththikka miidi minnides. Undena wode ammanizaytara Damasqon gam7ides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Heerakka Yesusi Xoossa Naa gididayssa Ayhudata Woosa Keeththatan tamarso oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Siyida asay wuri “Hayssi Yerusalamen ha suntha xeygizayta dhayissiza addeza gidenee? Qasse izi ha yiday he asata qachi ekki Qeeseta Halaqatakko efanas deenee?” gishe malaletida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sawuley kaseppe minni minni bides. Damasqon diza Ayhudatas Yesusi izi Xoossi kiittidade gididayssa ammanthishe asa duuna oythides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Daro gallassatappe guye Ayhudati Sawule wodhanas duulatida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Izikka ista qofa erides. Istika iza wodhanas katama gelthiza ogen gallassinne qamma naagida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ammanizayti gidikko iza gidoth katama yuushon diza maskotezara keeshen duge woththida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sawuley Yerusalame yiidi ammanizaytara walakkettana koyin izi tumu ammanizade gididayssa isti ammanetonta gish izas babbida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Gido attin Barnabaassi iza Hawaaretakko efin Sawuley izi Damasqo oge bolla Goda wosti beyidakko, Godayka izas ay yootidakkonne qasseka Damasqon dishe izi ay mala xalateththara Yesusa sunthan sabakidakko istas yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Hessa gish Sawuley istara dides. Yerusalamen yuuyi yuuyi as babbonta Goda sunthan tamarsides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Girike dereppe yida Ayhudatara haasayshe palametides; gido attin asaykka iza wodhanas koyides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ammanizayti hessa eridi duge Qisaariya geetettizaso woththidi Xarseese yeddida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Hessa wode Yuhudaninne Galilan, Samaariyanka diza ammanizayti saron diidi kaseppe minnida. Qasseka Xoossa yashshatethan simeretishe Xillo Ayanan minetidanne kaseppe qoodan dari dari bida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Phexroosi dereppe deren yuuyishe Liida kataman diza ammanizayta beyanas duge wodhdhides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Heen Eniya geetettizayssa osupun layth hiixan qasheti uttida issi gunda as demmides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Phexroosikka “Haysso Eniya! Yesus Kirstoosi nena pathana; denda ne hiixa dentha!” gides. Eniyay heerakka pusuku gi dendides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Liidaninne Saroonan diza asay wuri iza beyidi Godan ammanides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Iyophphe geetettizason Xaabita geetettiza issi ammanizara dawus. Izi suntha birsheththi Girike qaalara “Dorqa” geetettes. Iza ubba wode lo7o ooso minna ooththashenne manqota maaddashe dawus. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","He wode iza hargada hayqqin asay aha meeci pude pooqen kessi woththides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Liiday Iyophphes mata gidida gish ammanizayti Phexroosi Liidan dizayssa siydi nam7u asata kiittidi “Elle ha yarki!” gi woossida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Phexroosikka dendidi kiitettida asatara gakkida wode iza pude he pooqe bolla kessida. Am7etikka wuri iza yuuyi aadhdhi eqqidi Dorqay paxa dashe istara ooththida qamisetanne may7ota bessishe yeekkida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Phexroosikka asa wursi kiflezappe kessidi gulbati woossides. Ahakko simmidi “Hanne Xaabita denda!” gides. Izakka ba ayfe doyada xeelladus. Phexroosakka beyada denda uttadus. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Izikka izi kushe oykki denthides. Ammanizaytanne am7eta xeygidi izo istas pathidi immides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","He hanoy kumeththa Iyophphen eretidesinne daro asayka Goda ammanides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Phexroosikka issi Simoona geetettiza galba qaacizadera Iyophphen daro wode de7ides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Qisaariya geetettiza deren “Xaalane wotadarata” issi butte giddon mato halaqa gidida issi Qornoloosa geetettizayssi dees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Izikka ba keeththa asa kumeththara Ayana hanon minonne Xoosse babbizadde; manqotaska daro muxuwata immizadenne daro wode Xoosse woossiza asa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Issi gallas gallassafe uddufun saate bolla Xoossa kiitanchay izas ajjutan beettidi izakko yiidi “Qornoloosa” gi xeygishin qoncen beyides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Qornoloosikka dagamara tishshi histi xeellishe “Godo hayssi aazee?” gides. Kiitanchaykka zaaridi “Ne woossaynne ne muxuwatay qofetanas pude Xoossa sinth gakkides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ne ha7i as Iyophphe yedada Phexroosa geetettiza Simoona xeygisa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Izikka abba matan diza galba qaaciza Simoona soon imathateth dees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Qornoloosa haasayssida kiitanchay izappe shaaketidi bidappe guye ba ashkaratappe nam7ata qasse Ayana yo7os minone izas daro ammanettiza wotadaratappe issa xeygisidi, ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","izi beyidayssa wursi istas yootidi Iyophphe kiittides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kiitettida asati wontetha gallas gede katamaykko matishin Phexroosi usuppun saate bolla woossana pude Pooqe bolla kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","Hessa wode izi gafida gish qumay buro kaxxishin dhisko mala liphiphi histin ajjutara saloy doyettin issi gita xaaxettida may7o malay oyddu baggara oyketidi duge biittan wodhdhishin beyides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","He may7oza bolla oyddu tohoy diza dumma dumma do7ati biittara gooshettiza medhetethatinne salo bolla piradhiza kafoti deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Hessa wode “Phexroosa denda hayta shukada ma” giza qaalay izas siyetides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Phexroosi qasse “Godo hayssi hanenna! Geesh gidontayssa woykko tuna miisha ta mulerakka ma erikke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","He kase qaalay qasseka nam7antho izakko yiidi “Xoossi geeshshidayssa ne tuna mala qoodoppa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Hessika heedzdzuto shireti shireti izakko yidappe guye may7o misatizayssi heerakka pude salo bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Phexroosikka ba beyida ajjutaza birsheththa eranas daro metotidi keehi qofo bolla dishin Qornoloosi kiittida asati Simoona keeththe koyishe demmidi pengen eqqida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Qaala dhoqu histidi “Phexroosa geetettiza Simooni dizasoy hayssan awanee?” gi oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","20","Phexroosi ba beyidayssa keehi qoppishin Xillo Ayanay iza “Hekko heedzdzu asati nena koyeetes. Denda! Duge wodhdhada ista yeddiday tana gidida gish sidhey baynda istara ba” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Phexroosikka duge wodhdhidi “Hekko inte koyizadey tanakko! Inte yiday aazasee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Istika izas “Nuni mato halaqa Qornoloosa matappe yidos. Izikka Xoossas babbiza xillo asanne Ayhuda asa ubba matan daro bonchettida asa. Nekka iza keeththe baana malanne ne gizayssa izi siyana mala geeshsha kiitanchay izas yootides” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Phexroosikka asata ba dizason mokki ekkidi ayssides. Phexroosikka wontetha gallas dendidi istara bides. Iyophphefe yida issi issi ammaniza asati izara issife bida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Qornoloosikka ba dabbotanne mata laggeta ba soon shiishshidi naago bolla dishin izi nam7antho gallas Qisaariya gakkides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Phexroosikka gede Qornoloosa keeththe gelin Qornoloossi iza mokki ekkidi iza toho bolla hokki goynnides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Gido attin Phexroosi “Takka ne mala asakko! Denda” giidi denthides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Phexroosikka iza haasayssishe izara so gelishin daro derey shiiqi uttidayssa beyides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Izikka istas “Ayhuda asi hara dere asara gaaggonta mala woykko hara dere as gididayta mata shiiqonta mala nu wogay diggizayssa inte ereeta. Gido attin ta oonakka tuna woykko izi geesh deenna goonta mala Xoossi taas qoncisides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Hessa gish ta xeeygetida wode hekko sidhonta yadis. Histin inte tana aazas xeygidakkone erana koyays” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Qornoloosikka “Oyddu gallassafe kase likke hanni wode gallassafe uddufun saaten tani ta soon woossishin qopponta booththa may7o may7ida asi yiidi ta sinthan eqqidi ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","tana ‘Qornoloosa! Ne woossay siyetides; ne manqotas immiza muxuwatay Xoossa sinthi gakkides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Hessa gish Iyophphe katama as kiittada Phexroosa geetettiza Simoona ehissa. Izi abba achchan galba qaaciza Simoona keeththan imathateth dees’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Takka heerakka neekko as kiittadis. Ne yuussaykka lo7o. Histikko Goday nena azazidayssa ne nuus yootikko Xoossi yootidayssa neeppe siyanas nu wurikka hayssan Xoossa sinthan doos” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Phexroosikka “Xoossi oonaka shaakki maadontayssa ta tumappe eradis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Gido attin Xoossas babbizaytanne xillo ooththizayta wursi oona baggafe gidinka izi ekkees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Xoossi ubbas Goda gidida Yesus Kirstoosa baggara Isra7eele asas kiittida sarotetha Mishiraachcho kiitay hayssa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yohannisi xinqata gish sabakidappe guyen Galilappe doommidi kumeththa Yuhudan hanidayssa inte ereeta. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Xoossi Naazirete Yesusa Xillo Ayananinne wolqan tiyides. Izikka Xoossi izara diza gish ba gakkidason ubban lo7o ooththishe Xala7e godateththa giddon dizayta wursi pathides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Izi Ayhudata dereninne Yerusalame kataman ooththidayssa ubbas nu marka. Qasseka asay iza mitha bolla kaqqi wodhides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Gido attin Xoossi iza heedzdzantho gallas heyqoppe denthidessinne asi iza beyana mala ooththides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Izi qonciday asa ubbas gidonta hayqoppe dendin izara midaytassinne izara uyidaytas Xoossi koyro doorida nuus iza markatassa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Izi nu derezas sabakana malanne hayqqidayta bollanne paxa dizayta bolla pirdanas Xoossi shuumiday iza gididayssa nu markattana mala nuna azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Iza ammanidadey wuri iza sunthan nagara maaretidi geeyanayssa nabeti izas markatettes” gi yooto doommides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Phexroosi hessa haasayishin qaala siyizayta ubba bolla Xillo Ayanay wodhdhides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Qaxxaretidayta baggafe Phexroosara yida ammanizayti Xillo Ayana imotethi Ayzaabeta bolla wodhdhishin beyidi malaletida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Hessika isti dumma qaalan haasayishininne Xoossa galatishin siyida gishassa. He wode Phexroosi, ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Hayti asati nu mala Xillo Ayana ekkida gish isti haaththan xammaqetonta mala ista digganay oonnee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Hessa gish Yesus Kirstoosa sunthan xammaqettana mala azazides. Hessafe guye Phexroosi guuththa wode istara daana mala woossida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Hawaaretinne Yuhudan diza ammanizayti Ayzaabeti Xoossa qaala ekkidayssa siyida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Hessa gish Phexroosi pude Yerusalame kezin qaxxaretida Ayhudappe ammanizayti Phexroosa, ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ne qaxxaretonta asata keeth gelada istara kath madasa” giidi walassida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Phexroosi qasse istas gelana mala maarara hizgi yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Tani Iyophphe kataman woossishin dhisikko mala tana liphiphi histidi ajjutan gita may7o misatiza miishi oyddu baggara oyketidi saloppe ta dizaso wodhdhishin beyadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ta tishshi hista xeellishin oyddu tohora diza meheta, wora do7ata, biitta bolla gooshettiza medhetethatanne salo bolla piradhiza kafota beyadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Heerakka tana ‘Phexroosa denda! Hayssa shukada ma’ giza qaala siyadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Takka ‘Godo hessi hanenna; tani tuna woykko geesh gidontayssa mulekka ta duunakko shiisha erikke’ gadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“He kase qaalay qasseka ‘Xoossi geeshidayssa ne tunisoppa’ giidi saloppe taas yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Hessika heedzdzuto shireti shireti yootetidappe guye wurikka simmidi pude salo bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Qisaariyappe taakko kiitettida heedzdzu asati heerakka he saateyn yi gakkidi ta diza keeththa karen eqqida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ta aynne sidhonta istara baana mala Xillo Ayanay taas yootides. He usuppun ishati tanara issife biidi addeza keeththe geldos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Izikka Xoossa kiitanchay iza keeththan eqqidi izas beettidayssanne ‘Iyophphe geetettizaso as yeddada Phexroosa geetettiza Simoona xeygisa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Izi yiidi nenanne neso asa wursi ashshana qaala yootana’ gidayssa nuus yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Takka baada buro yooto oykkishin koyro Xillo Ayanay kase nu bolla wodhdhoyssatho ista bollaka wodhdhides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kase Goday nuus yootishe ‘Yohannisi haaththan xammaqides shin inte Xillo Ayanan xammaqettana’ gida qaalay heerakka taas qofetides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Hessa gish nuni Goda Yesus Kirstoosa ammanishin nuus immida Xillo Ayana Xoossi istas immikko histin Xoossara eqqetanas tani oonee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Isti hessa siyida wode istas gizazi dhayin co7u gi simmidi “Hayssa mala gidikko Ayzaabetikka ha ooratha de7okko yaana mala Xoossi asas maaroteth immides guussa” giidi Xoossa galatida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Istifanoose bolla dendida goodeteththa gaason laalettida ammaniza asay qaala Ayhudatas xalala yootishe Pinqe, Qophiroosenne Anxokiya geetettizaso gakkanaas kanthi bida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Qophirooseppenne Qareenappe yida issi issi asati Anxokiya biidi Giriketasikka Goda Yesusa Mishiraachcho qaala yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Goda maadoykka istara dees; Qoodan keehi daro asay ammanidi Godakko simmides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Hessa woreykka Yerusalamen diza Woosa Keeththa asa haythan wodhdhin Woosa Keeththaya Barnabaasa Anxokiya yeddadus. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Izikka he bi gakkidi Xoossi ba aadho kiyateth deraas immidayssa beyidi ufayetidessinne asay wurikka kumeththa woznappe Goda ammanon minnana mala zorides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Izikka Xillo Ayananinne ammanon kumida lo7o asa. Daro derey Goda ammanon gujettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Hessafe kaallidi Barnabaassi Sawule koyana Xarseese bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Iza demmidi Anxokiya ekki yides. Nam7aykka heen diza Woosa Keeththa asara gididi layth kumeth daro dere tamarsida. Heen Anxokiyan ammanizayti koyro “Kirsaane” geetetti xeeygetida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","He wode issi issi nabeti Yerusalameppe duge Anxokiya wodhdhida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ista giddofe issoy Agaboossa geetettizayssi dendi eqqidi Xillo Ayanay iza bessin alame ubban gita koshay dendanayssa yootides. Hessika Oroome kawo Qalawodosa Qeesare geetettizayssa kawoteththa wode poletides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ammanizayti wuri issoy issoy ba wolqa keena miishe kesettidi Yuhudan diza ammaniza ishata maaddanas qachida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Maado miisha kesettidi Barnabaasanne Sawule kushen cimatas gaththana mala yeddida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","He wode kawo Herdoossi issi issi ammaniza asa gooddi gooddi metothides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yohannisa isha Yaqoobe mashshan wodhisides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Izikka hessa ooththiday Ayhudata ufaysidayssa beyidi Phexroosakka oythides. Hessika haniday Ayhudatas uketha ba7aale geetettiza ba7aale gallassa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Phexroosakka qasho keeththe gelsidappe guye oyddu oyddu wotadarati taran taran naagana mala giigettida wotadaratas immides. Izi hessatho ooththiday Paaziga ba7aaley aadhdhida mala kessidi derey pirdana mala shiishanaasa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Hessa gish Phexroosa qasho keeththe gelsidi naagetes. Gido attin Woosa Keeththa asay izas keehi mino woossa woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herdoossi Phexroosa dereza sinth shiishana qoppi utti dishin he qamma gidoth nam7u sansalatan qashetidi nam7u wotadarata giddon ichchides. Qasho keeththa naagizayti keeththa penge bolla eqqi naagishin, ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Goda kiitanchay ezigonta istas beettides. Isti diza kifilen poo7oy poo7ides. Kiitanchazikka Phexroosa mille bochchi beeggoththidi “Elle denda!” gides. Heerakka sansalatay iza kusheppe gaden wodhdhides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kiitanchazi iza “Ne may7o may7a! Caammakka aaththa!” giin Phexroosikka azazettida mala ooththides; qasseka kiitanchay “Ne gaabe may7ada tana kaalla” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Phexroosikka qasho keeththafe iza kaalli kezides. Gido attin izas agumo beyiza misatides attin kiitanchazi ooththizayssi tumu gididayssa eribenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Koyro zabetappenne nam7antho zabetappe aadhdhidi gede katama kessiza oge bolla diza birata pengako gakkida. Pengeykka barka doyetti wodhdhides. Isti kezi bida. Isti qeeri oge dizaaro aadhdhida mala kiitanchazi izappe shaaketides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Phexroosas kahay simmishin “Goday ba kiitancha kiittidi iza Herdoosa kusheppenne Ayhudati ta bolla qoppida ubbafe tana kessidayssa ta ha7i tumappe eradis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Hessa akeekki eridappe guye daro asay issi bolla shiiqetidi woossiza Marqoosa geetettiza Yohannisa aayo Maaramiso bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Izi he biidi kare penge qooxin issi Roodo geetettiza garadeya kare ooni qoxxizakkonne eranas kare mata badus. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Qaalay Phexroosayssa gididayssa erada keeha ufayetida gish kare doyonta wothan guye simmada “Phexroosi Karen penge bolla eqqides” gadus. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Asaykka izo “Hanne gooyay!” gida. Iza qas zaara zaara istas yootin “Histikko hessi iza naagiza kiitancha gidonta aggenna” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Phexroosi qas penge qoth gujjides. Istika penga doydi iza beyida mala malalettida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Izikka isti co7u gaana mala ba kushen malati bessidi Goday iza qashosoppe wosti kessidakkonne lo7ethi yootides. “Hayssa wursi Yaqoobesinne hanko ammanizaytas yootite” gides. Hessafekka gede haraso bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Wontetha gallas wontara wotadarati “Phexroosi waanidee?” gishe ba giddon bul7akettida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herdoossi Phexroosa as yeddi koysidi izi dhayida gish naagizayta lo7ethi oychidappe guye ista wodhana mala azazides. Hessafe guye Herdoossi Yuhudappe duge Qisaariya wodhdhidi heen uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herdoosikka Xiroose asaranne Sidoona asara oosha. He dere asay kath demmizay Herodossa dereppe gidida gish he dere kawo xeellizade Bilasxoosappe maado qaala demmida mala issi bolla gididi Herdoosara maqaynthanas oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Giigana barettida gallas Herdoossi kawoteththa may7o may7idi kawoteththa algan uttidi deraas haasayides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Derezikka “Hayssi Xoossa qaalappe attin asa qaala deenna!” gi waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herdoosikka Xoossas boncho immoonta aggida gish Goda kiitanchay heerakka Herdoosa shoci yeggin guxuni hayqqides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Xoossa qaalay gidikko diccidi akki akki bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabaassinne Sawuley ba ekki bida kiita polidi Yerusalame simmidi Marqoosa geetettiza Yohannisaka banara ekki simmida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Anxokiyan diza Woosa Keeththan nabetinne astamareti deettes. Heytikka Barnabaassinne Negeere geetettiza Simoonara, Qareena dere as Luqiyoosara, Herdoosara issife dicida Minaheranne Sawulera wuri issife deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Heyti wuri Godas goynnishenne xoomishe dishin Xillo Ayanay “Barnabaasanne Sawule ta ista xeygida oosos taas shaakki kessite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Istika xoomi woossidi ba kushe ista bolla woththidappe guye moyzida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnabassinne Sawuley Xillo Ayana kiitan duge Selawuqiya wodhdhida; heeppeka markaben geellidi Qophiroose bida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salmeena geetettizaso gakkidi Ayhudata Woosa Keeththatan Xoossa qaala sabakida; Marqoosa geetettiza Yohannisikka istara biidi ista maaddides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Abba giddon diza biitta Qophiroose geetettiza dereyo ha gaxappe he gaxa gakkanaas kanthi kezidi Phaafa geetettizaso gakkishin issi Ayhuda asa shin maronne wordo nabe Bar-Yesusa geetettiza as demmida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Izikka issi Sargoosa Phawuloosa geetettiza woznama dere ayssizayssara issife dees. Ha dere ayssiza addezi Xoossa qaala siyana koydi Barnabaasanne Sawule xeygisides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Marozi Ellimaassi ba suntha birsheththa mala dere ayssizayssi ammanonta mala dhuphanas koydi istara eqqetides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Phawuloosa geetettida Sawuley Xillo Ayanay izan kumin maroza tishshi histi xeelidi, ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Neno xillotetha ubbas morkezo! Geneynne iitatethi nenan kumidaysso haysso dabuloosa nawu! Goda suure oge geellaseththafe shempikii? ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Hekko ha7i Goda kushey ne bolla dees. Ne qooqana; hannife guye awa arshe poo7o Issinokka beyakka” gides. Heerakka shaarumaynne dhumay iza bolla wodhdhides. Kushe oykki bana kaalethanade koshshi yaanne haanne gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Dere ayssizayssi ha hanida yo7oza beyidi goda gish siyida timirten malaletidi ammanides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Phawuloosinne izara dizayti Phaafappe dendidi Phinfiliya geetettizason diza Phergene geetettizaso markaben geli bida; Yohannisi istafe shaaketidi guye Yerusalame simmides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Isti gidikko Phergeneppe dendidi Phissidiya giddon diza gede Anxokiya bida; Sambata gallas Ayhudata woossa keeth geli uttida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Muse woga maxaafatinne nabeta maxaafati nababetidappe guye Ayhudata Woosa Keeththa halaqati “Nu ishato! Intes hayssa asa zorana qaalay diikko haasayte” giidi istako ase yeddida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Phawuloosika dendi eqqidi ba kushera malatidi “Inteno Isra7eele asato! Qasseka inteno Xoossas yayyiza Ayzaabeto! siyite. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ha Isra7eele dere Xoossay kase nu aawata doorides; isti Gibxe deren dishin ista dhoqu dhoqu histides. Ba wolqama qesera heeppe ista kessides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Oyddu tammu layth kumeth ista bazzo biittan dandayides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kanaane biittan dizayta laapun kawota dhayssidi ista biitta ba deretas gade histi laattissides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Hessi wuri poletiday oyddu xeetanne ichashu tammu laythata giddonna. Hessafe guye nabe Sameela wode gakkanaas ista pirdiza daannata immides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Hessafe guye derey ba bolla kawo kawoththana mala Sameela woossides; Xoossayka Biniyaame baggafe Qiise naa Sa7oole istas immides. Izikka ista oyddu tammu layth haarides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Sa7oole shaaridappe guye Dawute kawothides; iza gish ‘Ta wozna mala hanizayssanne ta koyidayssa wursi ooththiza Iseeye naa Dawute ta demmadis’ giidi Dawute gish Xoossi markattides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Xoossika ba caaqo qaalatho ha addeza zerethafe as ashshizayssa Yesusa Isra7eeles ehides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesusi yaanappe kase Yohannisi Isra7eele derey wuri maarotethan gelidi xammaqettana mala sabakides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohannisi ba kiitettidayssa polo bolla dishe ‘Ta intes oona misatazinaa? Ta kiitettidayssa gidikke haray attoshin ta izas toho caamma kire birshanas bessontayssi taappe guyera yaana’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Inteno Abrahaame zerethafe yeletida nu ishato! Qasseka inte giddonka Xoossas yayyizayti wuri hayssi atotetha kiitay kiitettiday nuus ubbatassa! ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yerusalame asatinne ista halaqati Yesusa eribetenna; gido attin isti iza bolla pirdida; hessanka sambatan sambatan nababetiza kase nabeta qaalay iza bolla polettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Iza hayqos gaththiza issi gaasokka isti demmoonta aggikkokka Philaxoosi iza bolla hayqo pirda pirdana mala woossida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Iza gish xaafetidayssa isti wursi polidappe guye iza kaqqettida mitha bollafe gaden woththidi duufon moogida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Gido attin Xoossi iza hayqoppe denthides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Galilappe Yerusalame gakkanaas banara dizaytas daro wode beettides; heytikka ha7i iza gish deretas markata. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Nukka kase Xoossi nu Aawatas caaqida Mishiraachcho qaala intes sabakoos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Yesusa kiittidi istas caaqida qaala nuus ista naytas polides; hessika mazamure maxaafan nam7antho shempon ‘Ne ta naaza; ta nena hach yeladis’ geetetti xaafetides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Qasseka izi wooqontayssanne Xoossi iza hayqoppe denthidayssa shaakki erana mala ‘Anjettidayssanne ammanettida Dawute anjo ta intes immana’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Hessa gish harasonka ‘Ne geeshshay hayqqi wooqana mala ne koyakka’ gees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Dawutey ba woden Xoossa shene mala ooththidappe guye hayqides; kase ba aawatara moogetin iza ashoy wooqides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Xoossi iza hayqoppe denthidayssi izi gidikko wooqibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Hessa gish ta ishato! Nagaras maarotethi beettizay Yesusa baggara gididayssi intes sabaketidayssa erite. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Iza ammanizadey wuri kase Muse woga baggara demmoonta xilloteth demmana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Hessa gish kase nabeti ‘Inteno qidhizayto xeellite, malaletitenne, dhayite, intes oonikka yootin ammananas intena metiza miish ta inte woden ooththana’ gida qaalay inte bolla gakkonta mala naagetite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Phawuloosinne Barnabaassi Ayhudata Woosa Keeththafe kezishin asay ista hessa isti yootida qaala kaalliza Sambata gallas zaari yootana mala woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Shiiqoy laalettidappe guye daro Ayhudatinne Ayhudata ammanon gelidi Xoosse goynniza asati Phawuloosanne Barnabaasa kaallida. Phawuloosantika ista qofsishe isti Xoossa kiyatethan minni daana mala zorida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Kaalliza Sambata gallas katama asappe guuththati xalala attin dariza baggay wuri Goda qaala siyana shiiqides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ayhudatikka daro dere beyidi qanatetethan kumida. Phawuloosa haasaya eqqetishe iza cayida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","47","Phawuloosinne Barnabaassi babbonta xalateththan “Xoossa qaalay koyro intes yootetanas bessees. Gido attin inte qaala leqqideta. Intes merna de7oy bessontayssa interka inte bolla pirdida gish ha7i nuni gede Ayzaabetakko baana koyoos. Qasseka Goday nuna ‘Asas atotetha qaala biitta gaxa gaththana mala ta nena Ayzaabetas poo7o hista kiittadis’ gi azazides” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ayzaabeti hessa siydi daro ufayetida. Goda qaalasikka boncho immida. Merna de7os giigettida derey wuri ammanides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Goda qaalay heeran diza dere ubbaso gakkides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ayhudati qas Ayana hanon kaseppe minnizaytanne duussan bonchettida macasata hessathoka kataman diza gita asata dentheththidi Phawuloosa bollanne Barnabaasa bolla goodeteththi denthidi ba dereppe kessi gooddida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Phawuloosinne Barnabaasi asay ista ixidayssa bessanas ba toho bolla diza gudulla pittidi Iqoniyoone geetettizaso bida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ammaniizayti ufayssaninne Xillo Ayanan kumida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iqoniyoonen Phawuloosinne Barnabaassi issife Ayhudata Woosa Keeththe gelida. Henka isti asa lo7eth tamarsida gish Girike asappenne Ayhuda asappe daroy ammanides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Hinko ammanonta Ayhuda asay Ayzaabeta ista bolla dentheththidi asay ammanizayta ixana mala ooththides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Phawuloosinne barnabaassi Goda gish xalatethara asas yootishe heen daro wode gam7ida. Godayka isti yootiza iza qaala gita malataranne wolqama ooson qoncisi markattides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Katama asay ba giddon nam7u kezi shaaketidi baggay Ayhudata bagga baggay Phawuloosanta bagga gidides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","He wode Ayhudatinne Ayzaabeti bana kaaleththizaytara issife gididi ista waayssanassinne shuchchan caddanas koyda. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Istika hessa erida mala Listiranne Derbeene geetettizaso gede Liqa7ooniya katamatanne he heeran diza dere baqatida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Henka mishiraachcho qaala sabako doommida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listiran yeeletosappe ba tohora hamuti eronta issi toho sila addey dees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","10","Hessadey Phawuloosi sabakishin utti siyees; Phawuloosikka izakko tishshi histi xeelidi addeza pathana ammanoy iza bolla dizayssa beyidinne qaala dhoqu histidi “Sitti gaada ne tohon eqqa!” gides. Addezi heerakka guppi dendidi hamuth oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Asay Phawuloosi ooththidayssa beyidi Liqa7ooniya qaalara “Eeqa Xoossati as misatidi ha nuukko wodhdhida” giidi waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnabaasa “Diya” gida Phawuloosakka haasayiza waannay iza gidida gish “Hermeene” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Katamappe asi bayndason diza Diya geetettiza eeqa keeththa Qeesey kormatanne xaaxeti giigida ciish gede katama geliza oge bolla efidi derezara issife gididi Phawuloosasinne Barnabaasas yarshana koyides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Hawaareti Barnabaassinne Phawuloosi hessa siyida mala ba may7o daakkidi gede dereza giddo woxxida; ba qaala dhoqu histidi hizgida; ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Hayto asato! Hayssa aazas ooththetii? Nukka inte mala assako! Inteka qasse hayssa mela hada yo7oppe haakkidi salonne sa7a, abbaka, abbata giddon dizayta wursi medhdhida de7o Xoossakko inte simmana mala intes mishiraachcho qaala sabakoos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Izi kase aadhdhida yeletethaynne derey wurikka ba koyda mala hananas yeddi bessides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Gido attin Xoossi saloppe iranne hessaththokka kaththi kaxxiza wodeta immidi inte wozna kaththaninne ufayssa kunthides; ufayssaka intena kalthidi lo7o ooson bana markay baynda aggibenna” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hessa wursi haasayidi asay istas yarshonta mala waaydi diggida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ayhudati qas Anxokiyappenne Iqoniyooneppe yida asay asa zoridi Phawuloosa shuchchan caddana mala ammanthida. Phawuloosakka shuchchan caddidinne hayqqides gi goochchidi katamappe gede kare kessida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Gido attin ammanizayti iza yuuyi aadhdhi naagishin Phawuloosi dendidi gede katama gelides. Wontetha gallas Barnabaasara issife Derbeene geetettizaso bida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Phawuloosinne Barnabaasi Darbeen mishiraachcho qaala sabakida daro asa ammanthidappe guye gede Listira, Iqoniyoonenne Anxokiya simmida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ammanzayta wozna minthethishe isti ammanon minni daana mala zorishe “Nu Xoossa kawoteth gelanas daro meto giddora aadhdhanaas koshshees” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Hessafe guye dumma dumma Woosa Keeththatan cimata dooridappe guye xoomaninne woossan ammanettida Godas hadara aaththi immida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Phissidiyara aadhdhidi Phinfiliya simmida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Phergenen qaala sabakidi duge Axaaliya geetettizaso wodhdhida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Axaaliyappekka ha7i gakkanaas isti ooththida oosoza hadara istas imettida katama Sooriyan diza Anxokiya markaben gelidi simmida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","He gakkida mala Woosa Keeththa asa wursi shiishshidi Xoossi istara ooththidayssa qasseka Ayzaabetas ammano pengey waani doyettidakkonne wursi yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Heen ammanizaytara daro wode gam7ida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Issi issi asati Yuhudappe duge Anxokiya wodhdhidi “Inte Muse woga mala qaxxaretonta aggikko oonikka attanas dandayekketa” giidi ammanizayta tamarso doommida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Hessika Phawuloosanne Barnabaasa gita palamaninne oosha giddo gelthides; hessa gish Phawuloosinne Barnabaassi hara issi issi ammaniza asatara Yerusalame kezidi ha yo7oza gish cimatanne Hawaareta oychana mala geetettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Hessa gish Woosa Keeththaya ista Yerusalame baana mala kiittin isti Pinqeranne Samaariyara aadhdhi bishe heen diza asa Ayzaabeti ammanon simmidayssa yootida; he wode ammanizayti hessa siydi keehi ufayettida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Isti Yerusalame gakkin Woosa Keeththa asay Hawaaretinne cimati ista mokki ekkida; kiitetti bidaytikka Xoossi istara gididi ooththidayssa wursi istas yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Farsaaweeta bagga asatappe ammanida issi issi asati dendidi “Ayzaabeti qaxxaretanassinne Muse woga naagana mala istas yootanas bessees” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Hawaaretinne cimati he yo7oza giddo lo7eth xeellanas shiiqida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Daro palamappe guye Phexroosi dendi eqqidi, “Ta ishato! Guuththa wodeppe kase Xoossi tana inte giddofe dooridi Ayzaabeti ta duunappe mishiraachcho qaala siydi ammanana mala ooththidayssa inte ereeta. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Asa wozna eriza Xoossi nuus immidayssa mala istaska Xillo Ayana immidi ista baas ekkidayssa markatides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ista woznakka ammanon geeshshidi nu giddoninne ista giddon aykko shaakkokka ooththibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Hessa gish nu aawatinne nukka tookkanaas dandayonta qambara ammanizayta toossanas inte aazas Xoosse paacetii? ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nu attiday likke istaththokka Goda Yesusa aadho kiyatethan gididayssa ammanoos” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Shiiqida asay wurikka co7u giin Barnabaassinne Phawuloosi Xoossi ista baggara Ayzaabeta giddon ooththida gita malatata gish yootishin malaletidi lo7ethi siyides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Isti yooti wursishin Yaqoobey dendi eqqidi hizgides “Ta ishato! Ta gizayssa siyite; ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Xoossi Ayzaabetappe baas gidana dere kasetidi izi wosti xeygi woththidako Simooni nuus lo7ethi yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Kase nabetan hizgi xaafetida qaalay hayssara gaggees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Hayssafe guye ta simmada laaletida Dawute keeththe keexana; laalettidayssa zaara essana; zaaradakka keexana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Hessika attida asay Goda koyana malanne ta sunthan xeeygettida Ayzaabeti tana koyana mala gees wursi ooththida Xoossi; ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Hayssa koyroppekka ersida Xoossi tana’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Hessa gish ha Xoossako simmida Ayzaabeta nu metothonta mala hayssi ta baggara taas qasho. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Gido attin eeqas yarshettidi tunida kath mooppite; laymappe haakkite; bawuti hayqqida mehe asho mooppite; suuth uyoppite giidi nu istas xaafana bessees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Muse wogay gidikko benisofe Sambata Sambata gallas Ayhudata Woosa Keeththan nabebetishenne katamay dizason sabaketishe dees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","He wode Hawaaretinne cimati kumeththa Woosa Keeththa asara gididi ba giddofe issi issi asata dooridi Phawuloosaranne Barnabaasara gaththi Anxokiya yeddanas qachida. Ammaniza asa giddofe waannatizayta Barsabaasa geetettiza Yuhudanne Sillase doorida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ista kushen immi yeddida dabdaabezi “Inte ishatappe, Hawaaretappe, cimatappe, Ayzaabetappe ammanida Anxokiyaninne Sooriyan, Kilqiyanka diza ammanizaytas nu sarokay intena gakko. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Issi issi asati nuuppe gidonta ba baggara nu achchafe biidi ba haasayan inte wozna yaanne haanne qaathidayssanne intena bul7akkidayssa nu siyidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Hessa gish guutha asata dooridi dosettida Barnabaasaranne Phawuloosara inteko yeddanas nu wurikka qaala gaaggidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Isti Goda Yesus Kirstoosa gish ba shempo aaththi immidayta. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Hessa gish nu intes xaafidayssa isti intes ba duunara lo7ethi yootana mala Yuhudanne Sillase inteko yeddidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Hayta intes koshshiza yo7otappe hara deexo tooho nu inte bolla wothonta mala nussinne Xillo Ayanas lo7o misati beettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Hessika inte eeqas shukettida ashoppe, suuthafe, bawuti hayqqida mehe ashoppenne laymappe inte hakkana mala; inte hayta misatizaytappe haakkikko intes lo7o; saron diite” gees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kiitettida asati moyzetidi duge Anxokiya wodhdhida; heen ammanizayta wursi shiishshidi ehida dabdaabeza istas immida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Dereyka nababidi minthethiza qaalan ufayetides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuhudaynne Sillassi nabeta gidida gish daro zoridi ammanizayta minthethida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Heen guutha wode gam7idi ammaniza asay moyzin guye bana kiittidaytakko simmida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sillassi qas heen attanas koyides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Phawuloosinne Barnabaassi hara daro asatara gididi Goda qaala tamarsishenne sabakishe Anxokiyan gam7ida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Phawuloosi guutha wode gam7idi Barnabaasa “Nu kase Goda qaala yootida ubba katamata biidi ammanzayti ay mala dizaakkonne ane yuuyi beyoos, denda” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabaasikka Marqoosa geetettiza Yohannisi istara baana mala koyides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Phawuloosi qas iza ekki baanas koybenna; gaasoyka kase Marqoossi istafe shaaketidi Phinfiliya gizason guye attidi istara oosos sinth kezonta aggida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Histin daro palamay ista giddon medhetida gish ba giddon shaaketi wodhdhida; hessa gish Barnabaassi Marqoosa ekkidi markaben gelidi Qophiroose bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Phawuloosi qas Sillase doorides. Ammanzaytikka Phawuloosa Goda aadho kiyatethas hadara immidappe guye izi istafe shaaketidi bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ammanizayta minthethishe Sooriyaranne Kilqiyara aadhdhi bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Phawuloosi Derbeene geetettizasone Listira gakkidi iza aaway Girike as, aayiya qas Ayhuda as gidida Ximtoosa geetettiza issi ammanizade heen demmides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Izikka Listiraninne Iqoniyoon ammaniza asa achchan lo7o markateth dizadde. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Phawuloosikka Ximtoosa banara ekki baanas koyides. Hessa gish he heeran Ayhudata gish giidi Ximtoosa qaxxarides. Gaasoyka Ayhudati Ximtoosa aaway Girike as gididayssa eriza gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Isti issi katamappe hara katama aadhdhi aadhdhi bishe Hawaaretinne Yerusalame Woosa Keeththa cimati yeddida kiita asay ekkidi naagana mala ammaniza asas immi immi aadhdhida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Woosa keeththa asay ammanon minni minni bides; qasse asaykka qoodan gallas gallas gujetti gujetti bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Phawuloosinne izara diza zatati qaala Iisiyan sabakonta mala Xillo Ayanay diggida gish Pirgiyaranne Galatiya derera aadhdhi bida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Isti Miisiya geetettizaso gakkana matishe Bitiniya geetettizaso gelana qoppin Yesusa Ayanay ista diggides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Hessa gish Miisiyara aadhdhidi Xiro7aada geetettizaso wodhdhida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Issi Maqidooniya asi eqqidi Phawuloosa ha Maqidooniya pinnada nuna maadda gishin Phawuloosi omars ajjutan beyides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Izikka he ajjuta beyidi Xoossi nu istas Mishiraachcho qaala yootana mala xeygides gi qachidi nu heerakka gede Maqidooniya baana koyidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Markabera Xiro7aada geetettizasoppe dendidi siti giidi Samotiraaqe geetettizaso bidos. Wontetha gallas Naaphule gizaso sinth hamuth gujjidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Heeppeka Oroome asay tooran haarida dere gidida Maqidooniya dere waanna katama gidida Piliphisiyoose geetettizaso gelidos. Heenka undena wode uttidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sambata gallas woossa woossizaso koyishe katama gelizaso penge kezidi duge shaafa wodhdhos; nu heen uttidi shiiqi diza macasas qaala yootidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Qaala lo7ethi siyiza macasatappe issi Lidiya geetettizara izakka Xoosse goynzaronne Tiyaxiroone katamappe yaada zo7o Hare may7o zal7izaro Phawuloosi yootiza qaala iza woznan wotha siyana mala Goday izi wozna doyides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Izanne iziso asaykka xammaqettidappe guye iza ista ta Xoosse ammanidi inte tumu erida gidikko ha taso yiidi guutha wode diishshite gaada ista mintha woossadus. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Issi gallas nu woossaso bishin kayo kayotta marotza issi garade naa dizaara nuna demmadus. Izakka ba maroteththan bana ayssizaytas daro miish gelthawus. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Hanna garade naya Phawuloosanne nuna kaalla kaalla “Hayti asati intes inte attana oge yootizayti wogga Xoossa oosanchata” ga ga waassadus. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Hessaka daro gallas shira shira gadus. Gido attin Phawuloosi ha Izi qaalan daro metotida gish izikko simmidi izi duunara haasayiza tuna ayanaza “Ne izippe kezana mala ta nena Goda Yesus Kirstoosa sunthan azazays” gides. He ayanay heerakka yeggi izippe kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Izo ayssiza asati istas miishe demmiza ogey duuxxin ista ufayssi qanxettidayssi istas gelin Phawuloosanne Silase oykkidi biittara goochchidi waannati dizaso giya giddo efida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Dere ayssiza waannatakko shiishshidi “Hayti asati baas Ayhuda as gidi uttidi nu katama bulakketes; ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","qasse nu Oroome asati ekkanas woykko ooththanas nuus bessonta woga nu asa giddon laalettes” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Dereyka issi bolla gididi Phawuloosa bollanne Sillase bolla dendides. Deraa ayssizayti Phawuloosanta may7o qaari ekkidi durqara qoxana mala azazida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Iita buka bukkidi gede qasho keeththan yeggida. Qasho keeththa naagizayssika ista lo7ethi naagana mala azazida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Izikka hessa mala mino azazo ekkidi qasho keeththas waanna giddo kifile gelthidi ista toho gita durumara shiishshi qachides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Giddi gidoth gidishin Phawuloosinne Sillassi woossaninne mazamuren Xoossa galatishin qasho asay ista yethanne galata ezgi siyides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Hassa7ay baynda dingate qasho keeththa xaphoppe qaathiza mino biitta qaathi hanides; heerakka qasho keeththa pengeti doyettida. Qashetida ubba asa qashoy birshettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Qasho keeththa naagizayssi dhiskofe beeggidi qasho keeththa pengeti doya dizayssa beyidi qasho asay wuri kessi ekkida misatin bana wodhana mashsha shoddides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Phawuloosi qas ba qaala dhoqu histidi “Nu wuri haan doos! Ne bolla ayne iita ooththofa” gi waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Qasho keeththa nagizayssi xompe woossi ekkidi gede giddo guppi gelides; kokkorshe Phawuloosa toho bollanne Sillase toho bolla kundides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ista ekki kare kezidi “Ha asato! Ta attana mala ay ooththoo?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Istika izas “Goda Yesusa ammana; nekka neso asaykka inte wuri attana” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Hessafe guye izassinne izason diza asas ubbas Goda qaala yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Qasho keeththa naagizayssi heerakka he gallas qamara efidi ista maduntha meecides. Heerakka izinne izaso asay wuri xaamaqetida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Qasho keeththa naagizayssika ista ba keeththe efidi istas kath aaththides. Baso asa ubbara Xoossa ammanida gish addezi daro ufayides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Gadey wontishin dere ayssizayti “Heyta asata birsha yedda” giidi ba shuumeta qasho keeththa naagizayssako yeddida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Qasho keeththa naagizayssika istas “Dere ayssizayti inte birshettana mala azazida; hessa gish ha7i saron kezi biite” giidi Phawuloosas yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Phawuloosi qas “Nu Oroome yeleteth gidishin pirday baynda dere sinthan durqara bukkidinne qasho keeththan yeggida. Histin ha7i qas nuna qotara asi eronta kessana koyizoo? Hessi hanenna; isti yiidi barka birshetto!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Shuumeti he izi gida qaala dere ayssizaytas yootida istika Phawuloosinne Sillassi Oroome yeletta gididayssa siydi daggammida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Yiidi istafe maareteth oychidi woyneppe kessida. Isti he katamayo aggidi haraso baana mala ista woossida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Phawuloosinne Sillassi qasho keeththafe kezidi Lidiyaso bida. Henka diza ammanizayti ista daro minthethidi heeppe kezi bida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Phawuloosinne Sillassi Anfiphoolanne Apholooniya geetettiza derera aadhdhidi Tasolonqe geetettiza dere bida. Henka Ayhudata Woosa Keeththi dees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Phawuloosikka izas dose gidida mala Ayhudata Woosa Keeththe gelides. Heedzdzu saaminta kumeth qaalappe ekki ekki istara haasayettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kirstoosi waaye ekkanassinne hayqqi dendanas bessizayssa qoncisi ammanthon “Hayssi ta sabakiza Yesusi izi kiitetti yaana geetettidayssakko!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ayhudatappe issi issi asay ba siyidayssa ammanidi Phawuloosaranne Sillasera issife gidides. Qasseka daro derey Xoosse babbiza Giriketappe daro eretida macasati ba siyida qaalan ammanidi istara issino gidida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ayhudati qasse ista qanatidi giyan diza wordo asata shiishshidi kumetha dereza ista bolla dentheththidi kataman shiro medhdhida. Phawuloosanne Sillase shiishshidi deraa sinthan essanas issi Iyaasoone geetettizayssaso koyanas elleli bida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Gido attin ista Iyasoone keeththan demmoonta aggida gish Iyaasoonenne hara ammaniza asata katama daannata sinthara goochchishe “Hayti asati dere wursi bul7akki ka7iishe gam7idi qasse ha7i ha yida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Iyaasooneyka ista ba keeththan woththides. Hayti asati wuri ‘Yesusa geetettiza hara kawoy dees’ giidi Qeesare woga ekketenna” gishe waassida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Dereynne he katama daannati hessa siydi ba giddon buqqettida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Iyaasoonenne harataka waase xeygisidi yeddida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ammanizayti heerakka Phawuloosanne Sillase qammara Beeriya yeddida. Istika he gakkida mala Ayhudata Woosa Keeththe gelida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beeriya asay Tasolonqe asaappe aadhdhidi akeekara diza asa. Gaasoyka hayssi yo7ozi tumeshaa? gi giidi Geeeshsha Maxaafata qaala wontin wontin pilgi xeelidi ufayssan ekkides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Hessa gish istafe daro asay ammanides. Qasseka istara qoodan daroti bonchettida Girike dere macasatinne addetikka ammanida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tasolonqen diza Ayhuda asati Phawuloosi Xoossa qaala Beeriyanka sabakizayssa erida mala dereza dentheththanas qasseka gede istako bida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","He wode ammanzayti Phawuloosa ellesidi gede abba achchi yeddida. Sillasinne Ximtoossi heen attida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Phawuloosa moyizida asati iza Atena gaththida. Qasseka Sillassiinne Ximtoossi izakko elleeli gakkana mala giza kiita Phawuloosappe ekkidi simmida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Phawuloosi Atenan ista naagishin Atena kataman eeqati kumidayssa beyidi daro shenetides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Hessa gish Ayhudata Woosa Keeththan Ayhudataranne Xoossas yayyiza Girike asara qasseka giyay dizason gallas gallas banara gaggiza asara haasayettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Efiqoroosenne Istoykko geetettiza eranchata bagga gididayti Phawuloosakko shiiqidi izara haasayettida Istafe issi issi asati “Hayssi lom7u lom7ay ay gaana koyizee?” gida. Baggati qasse Yesusa gishshinne hayqoppe iza dentha mishiraachcho izi sabakishin siydi “Heyssi hara ooratha eeqata gish yootiza misatees” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Iza oykkidi Ariosfaagoose geetettiza dere duulata sinth efidi “Ha ne tamarsiza ooratha timirtey azzakkonne nu erana mala ne koyay?” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Qasse ne nuna nu haythan sisiza yo7oy nu eronta oorath gidida gish izi azzakkonne nu erana koyoos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atena asay kumeth qasseka haan diza hara dere asaykka baas wode aaththanas ooratha yo7o haasayaninne sissan attin hara miishan aaththettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Hessa gish Phawuloosi Ariyosfaagoose geetettiza duulatan shiiqida dereza sinthan eqqidi “Hayto Atena asato! Inte beetto miish wursi ammanizayta gididayssa ta beyays. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ta yaane ha yuuyishin inte istas gooynniza miishata ta xeellishin ‘Eretonta Xoosse’ geetetti xaafetidayssa issi yarshoso demmadis; hessa gish hessa inte eronta gooyinnizayssa ta intena erissana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Hayssa alamezanne iza giddonka dizayssa wursi medhdhida Xoossi izi salonne sa7a Goda. Hessa gish izi asa kushen keexxettida keeththan deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Izi asa ubbas de7onne shempo; qasseka hara wursi immizayssa gidida gish izas paccizazi doonta gish izi asa kusheppe maado ekkenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Asa zeereth wursi issadefe medhidi asi biitta bolla daana mala ooththides; asay daana wodenne wursetha dhas woththides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Hessika asi Xoosse koydinne pilgidi demmanakkonne giidi woththides; hessi hessa gidikkokka izi nuuppe issi issadefe haakki diza gish gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Nu de7o demmiday, dizaynne qaaxetizay izanna; inte deren yeth kessiza issi issi asati ‘Nukka iza nayta’ gida mala. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Histikko nu Xoossa nayta gidikko Xoossi asa erateththan medhi kessida worqa woykko bira woykko shuch misatees giidi nu qoppanas bessenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Kasetidi Xoossi hayssa mala hanota asay eronta ooththidayssa dandayan aadhdhides; ha7i gidikko asi wuri ba dizason dizason maarotethan gelana mala azazees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Izi ba doosiddadde baggara biitta bolla xillotethan pirdana gallas bare woththides. Izakka hayqoppe denthidi asa ubbas hayssa tumatetha erissides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Istika hayqqidayta dentha gish siyida mala issi issi asati iza qidhida; baggati qas “Hayssa qasseka neeppe hara gallas siyana koyoos” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Heerakka Phawuloosi ista giddofe kezi bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Issi issi asati qasse Phawuloosa kaallidanne ammanida; heytappeka Diyonassiyoosa geetettiza Ariyosfaagoose duulata keeththa Abaale gidida Demarisso geetettiza macasayanne haratikka issife deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Hessafe guye Phawuloosi Atenappe dendidi Qorontoose katama bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Henka Phanxoosan yeeletida Aqqila geetettiza Ayhuda as demmides; izikka Ayhudati wuri Oroomeppe kezana mala Qalawodoosa geetettiza Oroome kawoy azazida mala ba macheyo Phirsiqillara mata wode Ixaaliya dereppe yidayssa beyanas Phawuloosi he istako bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Izikka istaththo dunkane sikkizade gidida gish ista achchan uttidi dunkane sikkon gelides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sambata Sambata gallas Ayhudata Woosa Keeththan ayuhudetaranne Girike asatara hasayetishe ista ammanthanas baaxetides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sillassinne Ximtoossi Maqidooniyappe duge izakko wodhdhin Phawuloosi sabakon minnidi Yesusi izi Kirstoosa gididayssa Ayhudatas markattides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Gido attin isti izara eqqetidi iza cayida gish Phawuloosi ba may7o qoqofidi “Ta intefe xillo; inte pirdettanay inte mooron gidida gish ta inte suutha gomen oyshetikke; hessa gish ta gede Ayzaabetakko bays” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Heeppe kezidi Titoosa Iyosxoosa geetettiza Xoosse woossizayssaso bides; he addeza keeththay Ayhudata Woosa Keeththa achchan dees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ayhudata Woosa Keeththa halaqay Qerisphoossi baso asa ubbara Goda ammanides; Phawuloosi yootishin siyida daro Qorontoose katama asay ammanidi xaammaqeetides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Goday qaman ajjutan Phawuloosa “Babbofa; Yoota; co7u gooppa; ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ta nenara days; oonikka ne bolla dendi nena qohanas dandayenna; hanno ha katamayn taas daro asi dees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Hessa gish Phawuloosi Xoossa qaala asa tamarsishe issi laythinne bagga istara uttides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galyoosa geetettiza dere ayssizayssi Akaayan diza wode Ayhudati issife gididi Phawuloosa bolla dendida; pirda wombora sinth shiishshidi, ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Hayssi addezi wogappe karera asay Xoossas goynnana mala asa baleththees” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Phawuloosi haasayana buro duuna doyishin Galyoossi Ayhudata “Inteno Ayhuda asato! Inte shiishida yo7oy dere dentheththo woykko dere gita meton yeggiza yo7o gididakko ta woznappe siyanashin. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Gido attin inte palamay issi issi qaalata gishshinne issi issi sunthata gish qasseka inte woga gishas gidida gish inte heen inte baggara wursite; ta hessa mala yo7o pirdanas koyikke” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Hessa gish pirda wombora sinthafe ista kessides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","He wode wurikka Ayhuda Woosa Keeththa halaqa Sostineese geetettizayssa oykkidi pirda keeththa sinthan bukkida; Galyoossi gidikko hessa wudanka yeggibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Hessafe guye Phawuloosi Qorontoose kataman daro wode gam7ides. Heeppeka ammaniza asay moyzin Phirsiqillaranne Aqilara issife markaben gelidi Sooriya geetettizaso bides; adina dizayssa gaththanas Kinkira7oose geetettizason ba hu7e meedettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Efesoone gakkida mala Phirsiqillanne Aqila heen aggagidi Phawuloosi Ayhudata Woosa Keeththe gelidi Ayhudatara haasayettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Banara gam7ana mala isti oychin izi “Akay” giidi ixxides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Gido attin izi istafe shaaketishe “Xoossa shene gidikko ta simmada yaana” gides; Efesooneppe dendidi markaben gelidi bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Qisaariya geetettizaso gakkidappe guye kezidi ammanizayta saro giidi heeppe Anxokiya wodhdhides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Anxokkiyan guuththa wode takkidappe guye heeppe dendidi Galatiya baggaranne Firgiya geetettiza deretara yuuy aadhdhidi ammanzayta minthethides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","He wode issi Iskindiriya kataman yeletida Aphilosa geetettiza issi Ayhuda asi Efesoone yides; izikka tamaridadenne Geeshsha Maxaafata lo7ethi erizade. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Izi Goda oge tamaridadenne Yesusa gish balay baynda haasayizadenne Xillo Ayanan xuugetishe tamarsizade; gido attin izi lo7ethi erizay Yohannisa xinqate xalala. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Izikka Ayhuda Woosa Keeththan babbonta yooto oykkides; Phirsiqillaynne Aqqilay izi gizayssa siydinne iza gede baso efidi Xoossa oge iza kaseppe lo7ethi erissida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Aphilossi gede Akaaya baanas koyin ammanizayti iza minthethida; heen diza ammaniza asaykka iza mokki ekkana mala izas dabdaabe xaafida; izi he gakkida mala izas diza immotappe dendidayssan ammanizayta daro maaddizade gidides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Geeshsha Maxaafata yayssa hayssara gaththi markasi markasi Yesusi izi Kirstoosa gididayssa Ayhudatara daro palametidi dere sinthan ista laththides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Aphilossi Qorontoosen diza wode Phawuloosi pudeha bagga derera kanthidi Efesoone yiidi heen diza issi issi ammaniza asata demmidi ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","“Inte ammanida wode Xillo Ayana ekkideti?” gides; Istika “Ekkibeykko haray attoshin Xillo Ayanay dizaakkonne nu sibeykko” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Phawuloosikka ista “Histin inte aazan xammaqetidetii?” gides; Istika izas “Yohannisa xinqatan xammaqetidos” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Phawuloosikka istas “Yohannisa xinqatay gidikko asay maarotethan simmidayssa bessiza xinqatakko! Yohannisi ba baggara asay izappe guyera yiza Yesusa ammanana mala yootides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Istika hessa siyidappe guye Goda Yesusa sunthan xammaqetida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Phawuloosikka ista bolla ba kushe woththida mala Xillo Ayanay ista bolla wodhdhin isti dumma dereta qaalara haasayida; tinbitekka yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","He asati wurikka tammanne nam7u gidizayta. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Phawuloosi Ayhudata Woosa Keeththe gelidi Xoossa Kawoteththa gish hasayettishenne ista ammanthishe heedzdzu agina kumeth oonaska babbonta asaas qoncisi yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Issi issi asay palama xin7i giidi ammananas koybenna; Goda oge qonccen ixida; hessa gish Phawuloosi ista aggidi haraso bides; ammanizaytaka dumma shaakki kessidi Xiranoose timirte keeththan gallas gallas istara haasayettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Hessa mala ooson nam7u layth gam7ida gish Iisiya awurajjan diza Ayhudatinne Girike asay wuri Goda qaala siyana dandayides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Xoossi Phawuloosa baggara daro malalisiza malata ooththides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Maarabe woykko iza asateth bochchida carqa efidi harganchata bochchikko hargey yeddees; tuna ayanatikka ba oykkida asappe kezeettes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Yuuyi yuuyi asappe daydanthi kessiza issi issi Ayhuda asati “Phawuloosi sabakiza Yesusa sunthan inte kezana mala azazays” giidi Goda suntha tuna ayanati oykkida asata bolla xeeygana paacida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Issi Ayhudatappe gidida Qeeseta halaqa Asqewes attuma naa laapunati hessatho ooththida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Tuna ayanaykka “Ta Yesusakka erays; Phawuloosakka erays shin inte qas oonantee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Qasseka tuna ayanay iza oykkidadey guppidi asata oykkides; ista bolla wolqatidi daro minnin madunxidi keeththafe mela kaallo baqatida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Hessika Efesoonen diza Ayhudata achchaninne Girike asa ubba achchan eretin wurikka babbida; hessanka Goda Yesusa sunthi bonchettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ammanida asappe daroy shiiqidi ba iita ooso qoncen paaxides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Maro marotizaytappe daroti ba marotiza maxaafa shiishshidi dere sinthan taman xuugida; maxaafa waagay shiishshi qoodin ichashu tammu shi bira mala gidides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Hayssa malan Goda qaalay keehi diccishenne xooni xooni bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Hayssi wuri hanidappe guye Phawuloosi Maqidooniyaranne Akaaya baggara aadhdhidi Yerusalame baanas qofa qachidi “Ta he gakkidappe guye ta Oroome qasseka beyana koshshees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Bana maaddizaytappe nam7ata Ximtoosanne Erisxoosa gede Maqidooniya geetettizaso kiittidi baas Iisiya awurajjan guutha wode heen de7ides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","He wode Goda oge gish daro shiroy medhetides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Dimexiroosa geetettiza issi bira qoxizayssi Arxemise geetettiza eeqa misile birappe seeris medhi medhi hiillanchatas wodhe miishe demmises. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Izikka he hiillanchatan hessa mala ooson aqizayta hara asata issi bolla shiishshidi “Aso! Hayssi oosozi nuus miish kessizayssa inte ereeta; ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","hayssi Phawuloosa geetettizayssi Efesoonen xalla gidonta kumeththa Iisiya awurajjan diza daro dereza ammanthi ammanthi baleththizayssa inte wurikka beyizayssa malanne siyizayssa mala ‘Asa kushen oosettida eeqati mulekka Xoosse gidetenna’ gi yootees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Hayssa nu oosozas lo7o suntha hiraayssizayssafe bollara kumeththa Iisiyaynne kumeththa alamey gooynniza wogga Arxemisse eeqa keeththaykka go7ay bayndayssa gidana; qasseka keehi dhoqu gida izi bonchoykka kawuyana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Asay hessa siydi iita hanqo hanqettidi “Efesoone Arxemissa wogga gita!” giidi waasso doommides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Heerakka kumeththa katamay shirotides; dereyka wuri issi bolla gididi Maqidooniya asa gididaytanne Phawuloosara issife yuuyiza iza laggeta Gayiyoosanne Arisxirokoosa oykkidi derey kase ka7izaso wothan gelida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Phawuloosikka kare kezidi asa sinth shiiqana koyin ammanizayti diggida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","He awurajja daannatappe issi issi Phawuloosa laggeti Phawuloosi asay kase ka7izaso xalidi gellonta mala as kiittidi woossida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Shiiqida asay un7etidi issadey issi miish haasayishin haray qas hara hasayessinne asay wuri waassetes; dariza bagga asay aazas heen shiiqidakkonne erenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ayhuda asay Iskindirosa geetettizayssa deraa giddofe sugereth gede sinth kessida wode issi issi asati ba gish izi haasayana mala waassida; izikka ista gish palamettana koydi asay co7u gaana mala malati bessides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Gido attin izi Ayhuda as gididayssa erida wode wurikka issi bolla “Efesoone Arximissa wogga; gita!” gishe nam7u saate mala asay waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","He katamas waanna xaafey asa co7u histidi “Inteno Efesoone asato! Gita Arxemisi eeqa keeththaynne saloppe wodhdhida izi misile naagizay Efesoone katama asa gididayssa erontay oonee? ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Hessa gish hayssi ha tumay kadettana dandayettontayssa mala inte guuthi yuushi qoppanassinne loddu gaanas bessees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Hayta asata Xoossa Keeththa bonqonta woykko nu xoosse gididayssa bolla cashsha qaala denthonta dishin inte oykkidi ha gaththanas coo ehideta. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","“Hessa gish Dimoxiroossinne izara diza bira seerisi ooththiza hiillanchati oona bollaka mootiza yo7oy diikko pirda keeththay istas doya dees; daannatikka deettes; koyidade mootanas dandayees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Hayssafe hara gaanas inte koykko wogay diza shiiqoson beyetto. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Hessi attikko hach hanida shiroy nuna mootisonta mala hirgisees; mootos gathiza gaasoy baynda gish ha hanida shiroza gish nu oyshetikko gaanazi nuus deenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Izi hessa gidappe guye shiiqoy laalettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Asay co7u gidappe guye Phawuloosi ammanizayta issi bolla xeygidi ista minthethiza qaalara zoridappe guye ista sarokidi Maqidooniya baana kezides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Izi aadhdhi biza deren diza ammaniza asa lo7eth zoren minthethishe Girike dere bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Giriken heedzdzu agina takkidappe guye markabera Sooriya geetettiza dere baanas qoppides shin Ayhuda asati iza bolla iita ooththana zoretidayssa eridi Maqidooniya baggara baana qofa qachides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Beeriyappe Phariyoosa naa Sophaxiroosa, Tasolonqefe Arisxirokoosanne Sikondoosa, Derbeeneppe Gayiyoossinne Ximtoossi Iisiyappe Xirofimoossinne Tiqiqoossi Phawuloosara issife bida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Heyti wuri nuuppe kasetidi Xiro7aadan nuna naagida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nu qas uketha ba7aaleppe guye Piliphisiyooseppe markaben isti dizaso Xiro7aada geetettizaso ichashantha gallas gakkidi heen laapun gallas gam7idos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Saamintafe koyro wogga gallas issife kath maanas nu shiiqi dishin Phawuloosi wonto baanas koshshiza gish shiiqida asas qaala yootishin izi yo7oza leela gidoth gakkanaas adussides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Bolla fooqen daro poo7oy dizason nu shiiqidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Awuxekise geetettiza issi natetha nay maskote bolla utti dishin Phawuloosi yo7oza adussidayssafe dendidayssan iza dhiskoy ekki bides; wolqama dhiskon xoonetidi bolla heedzdzantho fooqeppe duge kundin asay denthiza wode hayqqidi beettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Gido attin Phawuloosi duge wodhdhidi naaza bolla hokki idimmidinne “Hayqibenna paxa dees, daggammofte!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Phawuloosi hessafe pude fooqe kezidi uketha menthidi ammanizaytara mides; gadey wontana gakkanaas asatara hasayettishe gam7idi bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Asaykka hayqoppe paxida naaza gede izaso efidi wurikka ufayetides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nu Phawuloosa Markaben gelthana koyda gish kasetidi markaben Asosa geetettizaso bidos; nu hessa ooththiday Phawuloosi Asosa gakkanaas tohora baana koyda gishassinne nu gede sinth baana mala izi azazida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nu izara Asosan gaaggidi izi markaben gelin izara issife Mixiline bidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Wontetha gallas heeppe dendidi sinthara diza Ki7oose geetettizaso gakkidos; qasse wontetha gallas Saamoose geetettizaso pinnidi heeppe wontetha gallas Miliixe gakkidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Phenxaqoste geetettiza Ayhudata Paaziga ba7aale baas dandayettida mala bonchana Yerusalamen bettana koydi izi Iisiyan wodey aadhdhonta dishin Efesoone aadhdhi baanas koydes. Iisiyan izas wodey aadhdhonta mala Efesoone yeggi aadhdhana koyides. Izi hessatho ooththana koyiday Phenxaqoste ba7aales Yerusalamen bettanas koyda gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Phawuloosi Miliixeppe Efesoone Woosa Keeththa cimata ase kiittidi xeygisides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Istika yiin Phawuloosi ista “Ta Iisiya gelida gallassafe ha simmin ubba wode ta intenara waana waana de7idakkonne inte ereeta. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ayhudati ta bolla asa denthidi hilida geedon daro metoy ta bolla gakkikkoka ta kumeththa ashketetharanne afunthara Godas ooththadis. Coo denbanka inte inteson ta intena tamarsashe go7izayssa wursa intes yootadis attin intena go7iza miishafe aykkokka ashshabekke. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","21","Ayhuda asata gidinka Girike asa gidinka maarotethan gelidi Xoossako simmana malanne Goda Yesusan ammanana mala lo7etha yootadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Ha7ikka ta he gakkishin ta bolla aazi gakkanakkonne erikeshin Xillo Ayanay tana azazida mala Yerusalame bays. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Heen dumma dumma tana qashoynne metoy naagizayssa Xillo Ayanay taas yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Gido attin Goda Yesusi taas immida wotha woxxa wursana gakkanaassinne ooso ta polana gakkanaas tani ta shempos mishetikke; taas imettida oosoykka Xoossa mishiraachcho qaala yootokko. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ha7i gakkanaas ta inte giddon simeretashe Xoossa kawoteth sabakadis; Sima hayssafe guye intefe oonnikka mule ta ayfeso beyontayssa ta erays. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Hessa gish intefe issadeykka dhaykko ta oyshetontayssa hach ta intena erisays. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ayssi giikko ta Xoossa qofa wursa intes yootadis attin aykkokka ta yootonta ashshidayssi deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Xillo Ayanay intena Xoossa dorsata heemmanas shuumides; hessa gish inte hu7essinne Xoossa dorsatas naagetite; Goday ba suuthan wozida Woosa Keeththayo naagite. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ta bidappe guye Xoossa dorsatas michetonta iita asati inte gars gellanayssa ta erays. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Hessathoka issi issi asati inte giddofe dendidi geella yo7o intena tamarsidi ammaniza asappe darota gede baako zaarana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Hessa gish intena issa issa heedzdzu layth qammanne gallas afunxa zoridayssa yuushi qoppitenne naagetite. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Ha7ikka intena Xoossas minthi essanassinne ammanizayta giddon intes laataso immanas dandayiza iza aadho kiyatetha qaalas ta hadara immadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ta oona birakka worqa woykko may7o ammotabekke. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ta ta kushen ooththa ooththada taas maaddetada tanara dizayitaka maaddidayssa inteka ereeta. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","‘Ha ekkizadefe gede immizadey anjetidade’ giza Goda Yesusa qaala nu yuushi qoppidi nurka nu kushera nu ooththi demmidi hara daaburanchata gede maaddanas nuus bessizayssa ta intena daro dumma dumma ogera besadis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Hessafe guye Phawuloosi ubba asara gulbatidi woossides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Asay wuri yeekkidi Phawuloosa idimmi oykkidi yeerides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Harappeka isti daro mishetiday izi “Hayssafe guyen inte nam7antho tana beyekketa” gida gishassa; heeppeka iza markabekko gakkanaas moyzida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nu istafe shaaketidinne markaben gelidi siti giidi Qoose geetettiza abba giddon diza dere bidos; wontetha gallas hara Erodoose geetettiza abba giddon diza dere gakkidos. Heeppeka issi Phaxira geetettiza katama bidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Heen gede Pinqe geetettizaso biza markabe dizaaro demmidinne izin gelidi bidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Abba giddon diza Qophiroose geetettiza dereppe hadirsa baggan yeggidi Sooriya geetettiza dere biidi Xiroose geetettiza abba achchan diza dere bidos; hessas gaasoy markabeya ba caanettida caana heen wothanas koshshiza gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Heen ammanzayta koyi demmidi istara laappun gallas gam7idos; istika Xillo Ayana kaalethon Phawuloosa “Yerusalame booppa” giidi yootida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nu heen gam7ana wodey wurin istafe shaaketidi nu oge bidos. Isti wuri ba machetaranne ba naytara issife katamappe kare kezana gakkanaas nuna moyizida; abba achchan nu wuri gulbatidi woossidappe guye dendidi issoy issara saroketidi shaaketidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Hessafe guye nu markaben gelin isti gede baso simmida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nu Xirooseppe dendidi gede Phixilamaysse geetettizaso gakkidos. Henka ammaniza asara gaggidi saroketidi heen ista achchan issi gallas gam7idos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Wontetha gallas heeppe kezidi Qisaariya geetettizaso bidos; Qisaariyan laapun daaqonetappe issa wongelaawe Philphoosaso gelidi iza achchan shempidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Izas nabe gidida oyddu gelonta geella7o nayti deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Daro gallas nu heen gam7in issi Agaboossa geetettiza nabey Yuhuda dereppe yides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","He nabey nuukko shiiqidinne Phawuloosa danco ekkidi ba tohonne ba kushe qachidi “Xillo Ayanay hayssa dancaa goda Yerusalamen diza Ayhuda asati hayssatho qachidi Ayzaabetas aaththi immana gees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Hessa siydi nukka nunara diza asaykka Phawuloosi Yerusalame boonta mala woossidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Qas Phawuloosi “Inte aysi yeekki yeekkidi ta wozna aazas menthetii? Tani Goda Yesusa suntha gish Yerusalamen qasho xalala gidonta hayqqanaska giigetadis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Izi nu zore ekkonta ixin “Histikko Goda sheney hano” giidi aggagidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Nu heen guuththa gallassata gam7idappe guye nu miishe wursi giigissidi ekki Yerusalame bidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Qisaariyan diza issi issi ammanzayti nunara issife yida; istika nuni Minasoone keeththan daana mala nuna izaso kaalethida; Minasooni kasetidi ammanida Qophiroose dere asa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nu Yerusalame gakkida mala ammanzayti nuna ufayssan mokki ekkida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Wontetha gallas Phawuloosi nunara Yaqoobekko bides; he wode Woosa Keeththa cimati heen deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Phawuloosi asa wursi sarothidappe guye Xoossi iza baggara Ayzaabeta giddon ooththidayssa wursi issino ashshonta yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Hessa siydi asay wuri Xoosse galatides; Phawuloosikka “Nu ishazo daro shiyan qoodetiza ammanizayti Ayhudata giddon dizayssanne wurikka Muse woga woznappe naagizayta gididayssa nekka eraasa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Neni Ayzaabeta giddon diza Ayhudata Inte nayta qaxxaroppite woykko wogata ooththofte gaada ne tamarsida asay Muse woga shaarana mala ooththes giza wore asay siydes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Histin ha7i aaze lo7oy? Ha7i ne yuussa asay siyonta aggenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Hessa gish nu nena gizayssa ooththa; nu achchan tasala gaththana yida oyddu asati deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ne ista nenara ekkada istara gidada nena geeshsha; asati ba hu7e meedettana malanne Xoossa Keeththan imettiza muxuwata miisha ne istas qanxa; ne hessatho ooththikko ne bolla woretidayssi wuri mela gididayssanne nekka Muse woga pola naagizade gididayssa asay wuri erana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Hinko Ayzaabetappe ammanidayta gish gidikko ‘Eeqqas shukettidi tunidayssa mooppite, suuthika uyoppite, bawuta hayqqida mehe asho mooppite, laymafe haakkite’ giidi cimati qachida qaala dabdaabe xaafidi nu istas yeddidos.” ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Hessafe guye Phawuloosi he oyddu asata banara ekkidi wontetha gallas istara bana geeshshides; isti geeyiza gallassati aapun gallassikkonne issade issade gish imettiza miish immiza wodey aydekkonne erisanas Xoossa Keeththe gelides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Laapun gallas kumana maatishin Iisiya dereppe yida Ayhuda asay Phawuloosa Xoossa Keeththan beyidi deraa iza bolla dentheththidi iza oykkida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“Isra7eele asato! Nuna maaddite! Nu asanne nu woga hayssa nu dizasoza cayishenne derey dizason ubban asa tamarsizayssi hayssi izakko! Hessika gidenna giidi Ayzaabeta Xoossa Keeththe gelthidi hayssa geeshsha soza tunisides” gishe waassida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Isti hessa gida gaasoy hayssafe kase Efesoone yeletta gidida Xirofimosa izara issife katama giddon beyida gish iza Phawuloosi Xoossa Keeththe ekki gelida misatida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kumeththa katamay ba giddon shirotides; derey wuri issife woxxi koydi Phawuloosa oykki ekkidi Xoossa Keeththa gibbefe gooshechi kessides; Xoossa Keeththa pengeti heerakka gordettida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Asay Phawuloosa wodhana koyishin “Yerusalame diza kumeththa derey ba giddon shirotides” giza kiitay Oroome wotadarata azazizayssakko gakkides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Hessa gish izi wotadaratanne mato halaqata kaaleththidi eeson woxxishe asay dizaso bides; asay olanchata azazizayssa beyidi Phawuloosa buka aggida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mato halaqazi izakko shiiqidi Phawuloosa oykkidi nam7u sansalatan qashettana mala azazidi izi oonakkonne ayy ooththidakone eranas iza oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Dereyka ba giddon baggay hessa, baggay hayssa gides; Mato halaqazi dereza waasoppe dendidayssan tumay awayssakonne eranas dandayettonta ixin Phawuloosa gede wotadarati dizaso efana mala azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Phawuloosi pude dhoqaso gakkishin derey daro hanqon iza bolla meto gaththanas koyda gish wotadarati iza hashen tookki efida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Dereyka “Izi hayqqo! Hayqqo” gi waassishe iza kaallides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Wotadarati Phawuloosa ba dizaso gelthana maatishin Phawuloosi wotadarata azazizayssa “Ta nees issi miish yootana mala dosay?” gides. Mato halaqazikka “Ne Girike qaala eray?” ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Histin ha7i mata dere giddon meto dentheththida shempo wodhdhida oyddu shi asa ekkada bazzo baqatida Gibxe addezi nena diikkii?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Phawuloosikka “Tani Kilqiya giddon daro eretida Xarseese kataman yeletida Ayhuda asa; hayssa asas tana yoocharki” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Izi haasayana mala ero giin Phawuloosi dhoqason eqqidi asay co7u gaana mala ba kushera malatides; asay co7u giin Isra7eeleta qaalara, ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Ta ishato! Ta aawato! Ta bolla wordo woththidayssas ta intes immiza zaaro siyite!” ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Izi Ayhudata qaalara haasayishin siydi kaseppe asay co7u gides; Phawuloosikka haasaya gujjidi hizgides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Tani Kilqiya giddon diza Xarseese kataman yeeletida Ayhuda asa; tani dicciday gidikko hannin Yerusalamena; ta nu aawata woga wursa Gamalyaaleppe lo7etha tamaradissenne inte hach ooththizayssatho Xoossas suure woznappe ooththashe de7adis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Hayssa ha ogeza kaalliza asata ubba wodhana gakkanaas goodaththiza asakkoshin; macatanne addeta qacha qacha qasho keeththe yeddizadekkoshin. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Hayssi wuri tumu gididayssa Qeeseta halaqatinne dere cimatikka wuri taas markattana; haray attoshin Damasqon diza ammaniza asa qacha Yerusalame ehada qaxayssanas Damasqon dizaytas xaafetida dabdaabe Qeeseta halaqataappenne dere cimatappe ekkadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Tani Damasqo bishininne katama gelana matishin seeta gallas ta qopponta dishin saloppe wolqama poo7oy tana yuuy aadhdhi poo7ides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","He wode tani biitta bolla kundada Sawule! Sawule! Ne tana aazas goodday? giza qaala siyadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Takka ‘Godo ne oonee?’ gadis; izikka ‘Ta neni gooddiza Naazirete Yesusa’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Tanara issife diza asati poo7oza beyida attin izi tanara haasayishin qaala siybetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Takka ‘Godo ta ayy ooththoo?’ gadis. Godayka ‘Dendada Damasqo ba, ne ooththanayssa isti nees heen yootana’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Poo7oza xolqetetha daroppe dendidayssan ta xeellanas dandayabekke; tanara diza asati ta kushe oykki goochchidi tana Damasqo gaththida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Hananiya geetettiza issadey heen dees; Hananiyay Damasqon diza Ayhudata achchan daro galattettidayssanne woga bonchiza asa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Izi ta ach shiiqi eqqidi ‘Ta isha Sawule ne ayfey qasseka xeello’ gides; heerakka ta ayfey iza xeellides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Izikka tana ‘Nu aawanta Xoossi ne iza shene erana mala, iza xilloza ne beyana malanne izi gizayssa ne siyana mala nena kaseti doorides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Izi hessa ooththiday ne beyidayssanne siyidayssa asa ubba sinthan izas ne markattanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Histin ha7i aazas gam7ay? Dendada iza sunth xeeygada xammaqeta; ne nagarappekka meeceta’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Hessafe guye ta Yerusalame simmada Xoossa keeththan woossishin ajjutay taas beettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Godayka taas qoncidi ‘Ne ta gish immana markateth isti ekkonta gish ne gam7onta dashe Yerusalameppe ellela keza!’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Takka izas ‘Godo ta Ayhudata Woosa Keeththati dizaso baada nena ammanizayta ubba qachada ista bukkidayssa ba baggara istika eretes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ne gish markatiza Istifanoose asay wodhiza wode takka he wodhiza asata achchan eqqada isti wodhizayssa takka dosadissenne wodhizayta may7okka naagadis’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Godayka ‘Hahon diza Ayzaabetakko ta nena kiittiza gish dendada ba!’ ” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Asay hinno gakkanaas Phawuloosa haasaya woznappe lo7ethi siyishe aggidi ba qaala dhoqu histidi “Hayssa mala asi nu biittafe dhayo; hayssa mala asi nu biittan shempora daanas bessena” gishe waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Asay waassishe ba may7o qaari qaari wuxxishenne biitta pude salo dharcides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Mato halaqazi hessa beyidi Phawuloosa wotadarati dizaso gelthana mala azazides; dereyka iza bolla aazas hessa mala waassizakko erana mala iza garafidi paaxisana mala azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Gido attin dafon waaxi qachidi iza garafana giigetishin Phawuloosi ba achchan eqqida issi mato halaqas “Oroome as pirday baynda garafanas intes fiiqadey dizee?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Mato halaqay hessa siyida mala gede halaqata azazizayssakko biidi “Ay ooththana gay? hayssi addezi Oroome asakko!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Hessa gish halaqata azazizayssi Phawuloosakko shiiqidi “Ane taas yoota, ne Oroome asee?” gides; izikka “Ee ta Oroome asa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Azazizaysikka “Ta Oroome asa gidanas daro miishe qanxada shaamadis” giin Phawuloosi “Tani gidikko Oroomen yelettadis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Hessa gish iza maramaranas giigettida asati heerakka iza achchafe haakkida; azazizaysikka izi Oroome as sansalatan qachidayssa yuush qoppidi babbides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Wontetha gallas azazizayssi Ayhudati Phawuloosa mootiza ayfe yo7oy azakkonne eranas koyides; Qeeseta halaqatinne Ayhudata shango duulata asay wuri issadeykka attonta kumeth shiiqana mala azazides; Phawuloosakka qashoppe birshidi shiiqida asa sinth shiishshi essides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Phawuloosi duulata asa tishshi histi xeelidi “Ta ishato! Hach gakkanaas ta Xoossa sinthan lo7o qofara dayssi” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Qeeseta halaqa Hananiyay qasse Phawuloosa duunan shocana mala iza achchan eqqidayta azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Heerakka Phawuloosi Hananiya “Haysso aannora tiyettida keeththazo! Nenakka Xoossi shocana; wogara pirdana uttada wogay baynda tana shocana mala azazay?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","He wode heen diza asay Phawuloosa “Xoossa Qeeseta halaqa cayay?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Phawuloosikka istas “Ta ishato! Izi Qeeseta halaqa gididayssa ta erabeykke. gaasoyka ‘Ne dere halaqa bolla iita qaala gooppa’ gizayssi xaafetides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Phawuloosi heen diza asappe baggay Saduqaaweta, baggay Farsaaweeta gididayssa eridinne “Ta ishato! Ta Farsaaweeppe yelettadissinne; takka Farsaawe; hekko ha7i ta pirdettana shiiqiday hayqqidayti dendanayssa ta ufays ooththiza gishassa” giidi ba qaala dhoqu histidi duulata asa sinthan yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Phawuloosi hessa yootida mala Farsaaweeta giddoninne Saduqaaweta giddonka ooshi dendin duulatay nam7u shaaketi wodhdhides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Gaasoyka Saduqaaweti “Hayqqidaytas denthi deenna; kiitanchaykka baawa; Ayanaykka deenna gizayta; Farsaaweeti qasse heyti wurikka deettes” gi ammanizayta. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Hessa wode daro shiroy asa giddon hanides; Farsaaweeta baggata gidida issi issi Muse woga tamarizayti dendidi “Nu hayssa addeza bolla aykkokka iita miish demmibekko; ayanay woykko kiitanchay izas yootida gidana; nu ay erizoni?” giidi palametida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Palamay minni minni bida gish asay Phawuloosa tarsherethonta mala babbidi halaqata azazizayssi “Duge wodhdhidi Phawuloosa asa giddofe ha kessi ekki yiidi gede wotadarati dizaso efite!” giidi wotadarata halaqata azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Wontetha gallas leela gidoth Goday Phawuloosa achchan eqqidi “Aykkoy ba ne Yerusalamen taas markattidayssatho Oroomenka ne taas markattanas bessees” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Gadey wontin Ayhuda asati shiiqetidi “Nu Phawuloosa wodhonta dishe kath mookko; haathika uyokko” gi caaqettida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Hessa he maqozan issife gidida asa qooday oyddu tammafe bollara dees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Istika Qeeseta halaqatakkonne dere cimatakko biidi istas “Nu Phawuloosa wodhonta dishe kath moonta mala minthi caaqidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Hessa gidida gish inte dere cimatara zoretidi iza keehi marammariza misatidi isti intes Phawuloosa ehana mala azazizayssa oychite; nukka izi ha hanno gakkanappe kasetidi iza wodhana giigettidos” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Gido attin issi Phawuloosas michi nay hessa ista maqoza siyida gish wotadarati dizaso bi geellidi yo7oza Phawuloosas yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Phawuloosikka Mato halaqatappe issa baako xeygidi “Hayssi naazi wotadarata azazizayssas yootiza yo7oy diza gish gede izakko efa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mato halaqay naaza waana azazizayssakko ekki geellidi “Qashetida Phawuloosi tana baako xeygidi hayssi naazi nees yootiza yo7oy diza gish ta iza neekko shiishana mala tana woossides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Azazizaysikka naaza kushe oykki ekkidi haraso pooqidi “Ne taas yootanayssi aazee?” giidi iza dumma oychides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Naazikka “Ayhuda asati Phawuloosa yo7oza lo7ethi maaramarizade misatissidi wonto ne iza istas shiishana mala oychanas qachi woththida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Gido attin ne istas ero gooppa; gaasoyka ‘Nu iza wodhonta dishe kath mokko haathika uyokko’ giidi caaqqettidayti oyddu tammafe bolla gidiza asi iza wodhanas oge bolla zugges; ha7i isti naagizay ne zaaro xalala” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Azazizaysikka “Ne hayssa taas yootidayssa hara oonakka erissofa” giidi naaza moyizides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Hessafe guye wotadarata azazizayssi mato halaqatappe nam7ata xeygidi “Qammafe heedzdzu saate gidishin Qisaariya geetettizaso bana mala nam7u xeetu wotadarata, laapun tammu toganchatanne nam7u xeetu toora asa giigissite; ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Phawuloosasikka para giigissidi dere haariza Filkisekko lo7on gakkana mala ooththite” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Dabdabe hizgi xaafides; ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Dere haariza boncho Filkises, Qalawodosa Lusiyoosappe; saroy nees gido. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Hayssa addeza Ayhuda asati oykki wodhana gishin izi Oroome asi gididayssa ta gakka erida gish wotadaratara gakkada ashshadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Isti iza aazas mootizakkonne ta erana koyada dere duulatakko shiishadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Isti iza bolla shiishida mootoy ba woga gish gididayssa eradis; gido attin iza hayqos woykko qashos gaththiza miishi deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Hayssa addeza wodhanas asay maqetidayssa ta siyada heerakka siyida mala nekko yeddadis; mootizaytikka heen ne sinthan ba mooto shishshana mala istas yootadis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Hessa gish wotadarati ba azazettida mala Phawuloosa qammara efidi Antiphaxxirose geetettizaso gaththida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Wontetha gallas toganchati Phawuloosara baana mala ooththidi isti qas guye so simmida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Toganchati gede Qisaariya gakkidi dabdaabeza dere haarizayssas immidi Phawuloosa iza sinth shiishida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Dere haarizayssi dabdaabeza nababidinne Phawuloosa “Ne awa dereppe yadii?” gi oychides. Izi Kilqiya dere as gididayssa eridi; ");
INSERT INTO gmvRNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“Nena mootizayti yishin ta ne yo7o siyana” gides; Herdoosa gibbe gaaththan izi naagettana mala azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ichashu gallassafe guye Qeeseta halaqa Hananiyay issi issi cimataranne Xarxuloosa geetettiza xabaqara Qisaariya bides; istika dere ayssiza Filkisekko shiiqidi Phawuloosa mootida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Phawuloosi xeeygeti shiiqin Xarxuloossi iza hizgi mootides “Boncho Filkise! Nu ne baggara daro saroteth demmidos; ne lo7o aysonka nu deres lo7etethi beettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","“Hessa ne lo7o oosoza nu awan gidin aydekka dhoqu gida bonchoranne galatara ekkoos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ta ha7i nena gam7isontanne daaburissonta qaanthara nees yootizayssa kiyatethan ne nu gizayssa siyana mala woossos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Hayssi addezi nuus iita harge gidides; alamen diza Ayhudata ubba bolla meto medhees, Naaziraawe geetettiza wordo asata waanna kaalethizadey izakko. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Izi Xoossa Keeththe tunisana gishin nu iza oykkidos. Nu woga mala nu iza bolla pirdana qoppidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Gido attin wotadarata halaqata azazizayssi Lusiyoossi gakkidi nu kusheppe iza wolqara woththi ekkides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Iza mootiza asaykka neekko yaana mala azazides. Hayssi nu iza bolla shiishida mootozi wuri tumu gididayssa ne ne baggara iza oycha gakkanaas dandayassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Hinko Ayhuda asatikka “Ee hayssi yo7ozi wurikka tumukko” giidi ammanettida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Dere ayssiza Filikkisey Phawuloosi haasayana mala ba kushera malati besides; Phawuloosikka “Ne daro wodesoppe hayssa dereza ayssizadde gididayssa ta eriza gish ta bolla shiiqida mootozas ta nees ufayssa zaaro shiishays. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ta Xoossas goynnanas Yerusalame biin hachchi tammanne nam7u gallassafe darontayssa ne ne baggara eranas dandayassa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Xoossa Keeththan gidin Ayhudata Woosa Keeththan woykko katama giddon ta oonarakka palametishin woykko dere giddon meto medhishin tana demmibetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ha7i ta bolla isti shiishida mootozas ay markaka shishshanas dandayettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Gido attin ta nees qoncisana koyizay isti wordo giza Goda ogera nu aawanta Xoossas gooynayssinne Muse woganne nabeta maxaafan xaafetidayssaka ubba ammanays. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Istika ufays ooththiza mala takka nagaranchatinne xilloti hayqoppe dendanayssa Xoossan ammanettays. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Hessa gish Xoossa sinthaninne asa sinthan sidhey baynda hanoy taas daana mala ubba wode minnays. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Ta Yerusalameppe kezin taas daro layth gididappe guye ta dere asas maado miishenne Xoossas imettiza miishe ekka yadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Tana isti Xoossa Keeththan demmiday ta hessa gaththishinna; he wode ta geeyza woga polishin tanara daro asi deenna; ooshinne shiroykka deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Gido attin Iisiyappe yida issi issi Ayhuda asati deettes; istasika tana mootos gaththizazi diza gidikko ne sinthan tana mootetto. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Hessafe guye ta duulata sinth shiiqikko ta ooththida qohoy diikko he asati yooteto. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Tana hayssas gaththida gaasoy ta ista giddon eqqada ‘Hayqqidaytas denthi dees ga yootida gish hach pirdas inte sinth shiiqadis’ ta gaada qaala dhoqu hista yootadis attin hara ta ooththida miishi deenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Filkisey Goda oge lo7ethi eriza gish “Wotadereta halaqata azazizayssa Lusiyoossi yiza wode ta inte yo7oza gish qasho gidiza yo7o immana” giidi ista yeddides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Phawuloosa naagiza mato halaqay “Iza daro waayssonta lo7etha naaga; iza laggeti izas koshshiza miishi ekki yiikko diggofa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Guuththa wodeppe kaallidi Filkisey Ayhuda as gidida ba macheyo Durissillara yides; Phawuloosakka xeygidi Yesus Kirstoosan ammano gish izi yootishin siydes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Phawuloosi xillotetha gish, asi barka bana haaro gishshinne buroppe yaana pirda gish yootin Filkisey babbidi “Ha7i ne ba; hara wode taas giigishin ta nena xeeyga ekkana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Filkisey Phawuloosappe gubbo ekkanas ufaysi ooththi naagida gish daro wode gakkanaas xeygi xeygi hasayssides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Nam7u laythafe guye Phorqiyossa Fisxoossi Filkise ollan shuumettides; Filkisey Ayhudata ufayssanas koydi Phawuloosa qashoson aggagides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fisxoossi ba ayssiza dere Qisaariya gelidi heedzdzu gallas aqetidi heeppe Yerusalame bides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","3","Heen diza Qeeseta halaqatinne issi issi Ayhudata giddofe gita gita asati Phawuloosa bolla ba mooto shiishida; “Phawuloosa ha Yerusalame ehidi nuus lo7o ooso ooththarki!” giidi woossida; isti hessa giday Phawuloosa naagidi oge bolla wodhanas koyda gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Gido attin Fisxoossi “Phawuloosi Qisaariyan qasho keeththan naagetes; takka ha7i elle simmada he izakko baana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Inte giddofe daannateththi dizayti tanara Qisaariya betto; Phawuloosi ooththida qohoy diza gidikko heen mooteto” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fisxoossi osupun woykko tammu gallassafe daronta wode istara gam7idappe guye Qisaariya bides; he gakkida mala wontetha gallas pirda wombora bolla uttidi Phawuloosa izakko shiishana mala azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Phawuloosi iza sinth shiiqin Yerusalameppe yida Ayhudati Phawuloosa giddoththidi markay baynda daro deexo mooto iza bolla shiishida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Phawuloosikka “Tani Ayhuda woga bolla gidin Xoossa Keeththa bolla woykko Oroome Kawo Qeesare bollaka gaththida qohoy deenna” giidi ista mootoza shaariza zaaro istas immides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Gido attin Fisxoossi Ayhudata ufayssanas koydi Phawuloosa “Ne Yerusalame baada hayssa yo7oza heen ta sinthan pirdettana koyay?” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Phawuloosi qasse hizgidi izas zaarides “Hekko ta pirdettanas taas bessiza Qeesare pirda wombora sinthan eqqadis; nekka lo7etha eriza mala ta Ayhudata bolla ooththida aykko qohoykka deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ta qohida gidikko woykko tana hayqos gaththiza qoho ta ooththida gidikko ta hayqoppe attana giikke; gido attin isti shiishshiza mootoy mela hada gidikko oonikka tana istas aaththi immanas dandayenna; takka ta yo7oy Qeesare sinth shiiqana mala ‘Yigibayne’ gadis.” ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Hessa wode Fisxoossi bana zorizaytara hasayettidi “Ne Qeesarekko ‘Yigibayne’ giza gidikko Qeesarekko baandasa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Guuththa gallassatappe guye kawo Agirphaynne Barniqey Fisxoosa “Hashshu lo7on yadassa” gi mokkanas gede Qisaariya bida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Isti heen daro gallas uttida gish Fisxoossi Phawuloosa yo7oza Kawo Agirphas hizgi yootides “Filkisey qasho keeththan yeggi aggida issadey haan dees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ta Yerusalamen diza wode Qeeseta halaqatinne Ayhudata ciimati ha addeza yo7o taakko ehidi ta iza bolla pirdana mala oychida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ta qasse ‘Mootetidadey mootizayta sinthan eqqidi bana mootiza yo7ozas bessiza zaaro immoonta dishin mootetidade aaththi imoy Oroome kawoteththas woga gidenna’ gaada zaaradis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Hessa gish iza mootizayti shiiqetidi yida mala heerakka wontetha gallas pirda womboran uttada Phawuloosa ta sinth shiishana mala azazadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Iza mootizayti iza achchan eqqida wode isti iza bolla shiishida mootoy ta baggara izi iita oosonta aggenna gaada qoppida mala gidibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Gido attin isti izara mootetizay ba ammano gishshinne Phawuloosi issi hayqqidayssa ‘Paxa dees’ giza Yesusa gish gidides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Takka hessa mala yo7o qora xeellanas tana metida gish Phawuloosa ‘Ne Yerusalame baada hessa yo7oza heen pirdettana koyay?’ gadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Hizgin izi qasse yo7ozi Oroome kawo sinthan beyettana mala koydi ‘Ta yo7oy Qeessare sinth shiiqana mala oychays’ gida gish iza yo7o Qeesarekko ta yeddana gakkanaas izi qasho keeththan gam7ana mala azazadis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agirphay Fisxoosa “Takka izi giza siyana koyays” gides. Fisxoosikka “Wonto siyandassa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Hessa gish wontetha gallas Agirphaynne Barniqey kawoti may7iza mayo may7idinne daro bonchora wotadarata halaqataranne he kataman diza gita asatan azhabetti yiidi pirda keeththe gelida. Hessafe guye Fisxoossi Phawuloosa xeygisides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fisxoossi hizgides “Kawo Agirpha, qas nunara diza asato! Ayhuda asati wuri ‘Hayssi addezi hayssafe guye paxa daana bessenna’ giidi waassishe Yerusalamenka haanka iza bolla pirdettana mala isti tana oychizay hayssa inte beyiza addeza gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ta ta baggara iza hayqos gaththiza issi balakka iza bolla demmabekke. Izi ‘Ta yo7oy Oroome kawo sinth shiiqi beyetto’ gida gish ta iza he yeddanas qachadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","“Gido attin iza gish tani ta godas xaafana giza erettida yo7oy deenna; hessa gish iza issi issi paace oyshota oychikko taas xaafanayssi daanakkonne gaada inteko, harappeka kawo Agirpha neekko shiishadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Gaasoyka qasho asi pude bollatiza dhoqa daannakko bishin izi mootetiza yo7o qoncisonta aggoy asa eeya kessizayssi taas beettides” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agirphi Phawuloosa “Neni ne gish haasayanas dandayassa” gides. Phawuloosikka ba kushe denthidi zaaro hizgi immides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Kawo Agirpha! Tana Ayhudati mootiza yo7o ubbas hach ta ne sinthan tana maaddana zaaro immiza gish tana daro ufaysses. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Gaasoyka ne Ayhudata woganne ista palama ubba lo7etha eraasa; hessa gish ne ta giza ubba dandayada siyana mala ta nena woossays. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Tani guuththa natetha wodeppe doommada waana de7idakko Ayhuda asati eretes. Koyroppe ha7i gakkanaas tani ta dere asa giddoninne Yerusalamen ta de7ida duussi asay erees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Qasseka isti markattana koykko nu ammano gish ta keeha mintha woga naagiza Farsaawe bagga gidada gam7iddadde gididayssa isti koyroppe denthidi eretes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ha7i qasse pirdas tana hayssan essiday Xoossi kase nu aawatas immida caaqo qaala ufaysa gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ha ufayssakko gakkanaas nu zarketi tammanne nam7ati Xoossa gallassinne qamma goynnishe naagida. Kawo intes hoola! Ayhudati tana mootizay ha yo7oza gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Xoossi hayqqidayta denthanayssi waanidi Ayhuda gidida inte achchan ammanetibenee? ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Takka ta baggara Naazirete Yesusa sunthas eqqetanas bessees gaada qoppadis shin; ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","tani Yerusalamen ooththidaykka hessakoshin; Qeeseta halaqatappe ta ekkida godateththara ammanizaytappe darota qasho keeththan yeggiissadis; ista wodhishin wodhizaytara issife days. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Daro wode Ayhudata Woosa Keeththati dizason awanka isti qaaxayettana malanne ba ammano kadana mala ooththadis; ista bolla daro hanqetadakka Isra7eeleppe karen diza hara katamataka baada ammanizayta gooddadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Hayssa ha yo7ozas Qeeseta hallaqatappe kumeththa godateththinne azazo ekkada Damasqo geetettizaso ta bishin; ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kawo intes hoola! Buro ta ogen dishin gadey seeta gallas gidishin awa arshe poo7oppe aadhdhiza poo7o beyadis; he poo7oy tananne tanara biza asata yuuy aadhdhidi saloppe poo7ides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nu wurikka biitta bolla kundi dishin Ayhudata qaalara ‘Sawule! Sawule! Tana aazas goodday? Neni qara mashsha bolla eqqiikko nerka nena qohassa’ giza qaala siyadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Takka ‘Godo! Ne oonee?’ gadis; Godayka ‘Tani ne, gooddiza Yesusakko! ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ha7i dendada ne tohon eqqa; ta nees qonciday ne tana ha7i beyidayssaninne sinthafe ta nena bessanayssan ne taas markattizade gidana mala ta nena shuumana koyadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Isra7eele asa kusheppenne ta nena istako kiittiza Ayzaabeta kusheppekka ashshana. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ne ista ayfe doyana malanne dhumappe poo7on kessana mala qasseka Xala7es haarettizasoppe Xoossakko ne zaarana mala ooththana; istika tana ammanida gish ba nagarappe maarettana qasse doorettidayta giddon isti laata gade demmana’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Hessa gish kawo Agirpha! Saloppe taas imettida ajjutaas ta azazettadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Gido attin ta kasetada Damasqon diza asa kaalethada Yerusalameninne Yuhuda deren ubban dizayta qasseka Ayzaabetikka nagara ogeppe Xoossakko simmidi maarettana mala erisadis; isti nagarappe simmidayssa bessizazi ooththana mala ta istas yootadis. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Hessa gaason Ayhudati ta Xoossa Keeththan dishin tana oykkidi wodhana koyda. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Hachchi gakkanaaska taas Xoossafe maadoy pacci erenna. Hessa gish guuththaska gitaska markatashe hayssan eqqadis. Nabetinne Musey kasetidi hayssa malay hanana gidayssa yootoppe attin ta hara aykkokka yootabeykke. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Istika yootidayssi ‘Xoossi kiittidadey meto beyana. Hayqoppe dendon koyro gididi asi attana poo7o Isra7eele deressinne Ayzaabetas qoncana’ gizayssa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Phawuloosi hessa yootishin Fisxoossi “Phawuloosa! Ha7i ne gooyonta aggaka; ne daro tamaridayssi nena gooshshides” gi waassides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Phawuloosi gidikko izas “Boncho Fisxoosa! Ta nees tuma erada yootays attin gooyabeykke. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ta iza sinthan qoncera yootida kawoy hayssa yo7oza erees; hayssika qotara ooththetontayssa gidida gish kawoy eranayssa ta ammanettays. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kawo Agirpha! Nabeta ammanasa gidikkii? Ne ammanizayssa ta erays” gi zaarides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agirphayka Phawuloosa “Hekko ne tana hanno guuththa wode giddon ammanthana koyasa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Phawuloosikka izas zaaridi “Guuththa woden gidinka woykko daro woden ne xalla gidonta dishin hach ta yootidayssa siyiday wuri hanno ta qashetethaya atta wurikka ta mala gidana mala ta Xoossa woossays” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Hessafe guye kawoy, dere ayssizayssi, Barniqeynne istara uttida asaykka wuri dendides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Isti heeppe kezi bishe ba giddon “Hayssi addezi hayqos woykko qashos gaththiza miishe aykkokka ooththibenna” gida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agirphayka Fisxoosa “Hayssi addezi yo7oza Qeesares shiiqo goontakko aykko wosoy baynda mela yedetanako shin” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nuni Xaalane dere markaben baana mala geetetti qashettida gish Phawuloosanne hara qasho asataka kawo Awugisxoosa wotadaratappe gidida Yuuliyoosa geetettiza mato halaqas aaththi immida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Iisiya abba achchan diza dereta biza markaben gelidi bidos. Tasolonqen diza issi Maqidooniya as Arisxirokoosa geetettizayssi nunara dees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Wontetha gallas Sidoona gizaso gakkidos; Yuuliyoossi Phawuloosas lo7o gidida gish Phawuloosi ba laggetakko biidi asay izas koshshiza maado ooththana mala piqade immides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Heeppe dendi nu bishin sintha baggara carkoy nu bolla carkiza gish abba giddon diza Qophiroose deren gemmetidi gede sinthe bidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kilqiya gizasonne Phinfiliya geetettiza dere achchan diza abba pinnidi Looqiya deren diza Muura geetettiza katama gakkidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Heen mato halaqay Ixaaliya dere biza Iskindiriya dere markabe demmidi nuna izan gelthides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Daro gallas loddu gi gi biidi daro waayetidi Qandoose geetettiza katama achchi gakkidos; carkoykka nu sinth boonta mala diggin Salmoona achchara aadhdhidi Qarxeese geetettiza abba giddon diza deren gemettidi bidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Daro waayetidi lanqe lanqe oykki nu aadhdhidappe guye Laasiya geetettiza katama achchan diza “Lo7o” geetettiza markabey eqqizaso gakkidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nu biza oge bolla daro daaburan xooma wodey aadhdhida gish ha7i abba bolla baanas daro meto gidida gish Phawuloosi banara diza asay naagettana mala hizgides; ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Aso! Hayssafe nu kaallidi baana buussay daro metora dizayssi taas bettes; markabezan diza caanaaza bollanne markabeza bolla xalala gidonta asa shempo bollaka gita qohoy gakkana.” ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Mato halaqay qas Phawuloosa zoreppe bollara markabeza laaggiza waannazinne marakabeza goday gizayssa siydes. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","He markabey eqqizasoy balgoy aadhdhana gakkanaas markabes lo7o shemposo gidonta gish dariza bagga asay “Hammutha sinth gujjanas dandayettikko awa arshey wullizasoppe dugeha baggaranne pudeha baggara diza Finqe geetettizaso Qarxeese markabe shemposo nu gakkidi balgo heen aaththoos” giidi ba qofa shiishida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Dugeha baggara guuththa carkoy carkishin beyidi isti qoppida mala hanana misatin baana kezida; markabey eqqizasoppe baana dendidi Qarxeese achchara lanqe lanqe oykkidi aadhdhi bida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Gido attin guuththa wodeppe guye “Awa arshey mokizasoppe pudehappe yiza gote carko” geetettiza iita wolqama carkoy abba giddon diza dereyippe dendidi istako abba giddo yides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Markabeza carkoy sugin carkara eqqeettanas dandayonta ixin nu co7u giidi carkoy efizaso bidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Qeedda geetettiza abba giddonko diza dere dizaarin geemettidi nu bishin daro waayetidi markabeza qeeri wogoloyin oykkidi essanas dandayidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Markabeza laagizayti qeeri wogoloyo markabezako goochchi kessidi markabeza wodorora xaaxida. Markabezikka Sirtise geetettiza abba accey dari dizason kundonta mala babbidi iza bolla diza shara woththidi carkon laageti bida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Gote carkoy minni bida gish wontetha gallas markabezan caanettida miishata issa issa abba giddo yegeth oykkida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Heedzdzantho gallas markabezas koshshiza miishataka ba kushera kessi kessi yeggida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Daro wode gakkanaas awa arsheka xoolinteka beyonta aggida gishshinne carkoyka kaseppe minni minni biza gish hayssafe guye nu attana dandayokko giza qofan ufays qanxidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Asay kath moonta daro gallas uttides. Hessa gish Phawuloosi asa giddon eqqidi “Ha asato! Inte ta gizayssa siydi Qarxeeseppe dendontakko ha qohoynne ha dhayoy inte bolla gakkenakkoshin. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ha7ikka markabezi xalla qohettana attin intefe issade shempoykka dhayenna. Hessa gish aykkoy baawa; babbofte gaada intena zorays. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Qamma omars ta izas gidida ta goynniza Xoossay kiittida kiitanchay ta achchan eqqidi ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘Phawuloosa! Babbofa! ne Qeesare sinthan eqqana bessees; hekko nenara issife bizayta wursi Xoossi ne gish hayqoppe ashshana’ giidi taas yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Hessa gish inteno ha asato aykkoy baawa; Xoossi taas hayssa yootidayssa polanayssa ta ammanays. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Gidikkoka hayssi gote carkozi gede issi abba giddon diza dere achchi efidi nuna yeggana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Tammanne oydantho qamma Andiriya Abba giddon carkoy nuna waayssishin bishe leela giddoth markabeza laaggizaytas abbafe biitta bolla gakkida misatides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Hessa gish abba ciimmateththi eranas abban yeggi xeelliza wodoro isti yeggi xeellishin; abba ciimmateththi oyddu tammu metre keena gidi beettides; gam7ishe Ha7ikka yeggin heedzdzu tammu metre keena ciimma gididayssa demmida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Nu diza markabey abba gaxan diza zaalla shuchchara icetonta mala babbidi markabezappe guye baggara markabey qaaxonta mala naagiza dhishikke duge abba giddo yeggida. Hessafe guye istas qamay wontana mala woossa oykkida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Markabeza laagizayti markabezappe kezidi baqatana koyda gish markabezappe sintha baggara markabe naagiza dhishikke yeggiza misatidi markabeza bolla diza qeeri wogoloyo duge abba giddo yeggida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Hessa wode Phawuloosi mato halaqanne wotadarata “Hayti markabezan diza asati markabeza bolla shempidi uttonta aggikko inteka attana dandayekketa” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Hessa gish wotadarati wogoloyo oykkida wodoroza qanxi yeggin iza abba bolla tokkettana mala yeddi aggida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Gadey wontana gishin wurikka kath maana mala Phawuloosi ista hizgi woossides “Inte aazi hananesha giidi hirgan kath moonta aggin hachchi tammanne oydantho gallasa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Hessa gish inte kath maana mala ta intena woossays. Inte miikko minnana; mulekka aykko qohoykka inte bolla gakkenna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Izi hessa gidappe guye kath ekkidi Xoosse galatidi asa ubba sinthan kathi muus oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Hessa wode wurikka minetidi kath mida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Markabeza giddon diza asay wuri nam7u xeetanne laapun tammanne usuppuna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Wurikka mi kaallidappe guye markaban caanettida gisteza duge abba giddo yeggidi markabeza deexo kawushshida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Gadey wontin ba dizaso eribeetenna. Gido attin accey dizaso abba kurqunthu demmida. Istas dandayettizakko markabeza he sugi shishshana qoppida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Markabeza oykkiza dhishikke qanxidi abba giddo yeggida. He wode markabe laggiza miisha oykkida wodorota birshida. Ha baggara diza shaara carko bagga dhoqu histidi kezana abba gaxa bida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Gido attin markabezi daro accey koretti uttidayssara icetidi duge gufannides; sintha bolla duge gufanni dhishikketidi qaaxontayssa gidides. Qas abba dambalay daroppe dendidayssan guye baggara meqereteth oykkides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Qasho asappe issadeyka abban wodhdhidi kessi ekkonta mala wotadarati wodhana qoppida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Mato halaqay qas Phawuloosa ashshanas koyda gish ista qofa ekkana koybenna. Gido attin haathe wodhdhi erizayti markabezappe duge abban guppi guppi wodhdhidi gede biitta bolla kezana mala azazides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Hanko attidayti meqi wodhdhida sanqa bolla abba pinnana mala azazides; hessatho hanidi wurikka saron abba giddofe biitta bolla gakkida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nu Biittay dizaso sarotethan gakkidappe guye nu gakkida abba giddon diza derey Melaaxiya geetettiza dere gididaro eridos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","He dereyin diza asay daro malalisiza kiyateth nuus ooththides. He wode iray bukkida gishshinne meeggo gidida gish tama eththidi nuna mokki ekkida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Phawuloosi afira giza mithi shiishshidi taman gujin tama seelappe dendidayssan shooshi kezidi iza kushe bolla xaaxxetides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Malta asay shooshi Phawuloosa kushe bolla xaaxxetidayssa beyidi “Hayssi addezi shempo wodhidade; gaasoyka abba dambalappekka izi attidi yikkokka pirdiza Xoossafe kessi ekkidi paxa daana dandaybenna” giidi ba giddon haasayettida ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Phawuloosi qas shoosha duge taman qoqof yeggidi aykkokka hanibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Asaykka “Aydeppe ayde iza asatethay kixxanesha; woykko qopponta kundidi hayqqana” giidi naagides; gido attin isti daro wode naagishin iza bolla aykkoynne hanontayssa beyidi ba qofa lammidi “Hayssi addezi xoossa!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","He nu dizaso matan abba giddon diza dereyo ayssiza Puppulyoosa geetettizades gadey dees; he addezi nuna mokki ekkidi bason heedzdzu gallas gakkanaas lo7ethi imattides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Heen Puppulyoosa aawa miishaynne guso hargey sakkin ichchidi dees; Phawuloosi izakko gelidi izas woossidessinne iza bolla ba kushe woththidi pathides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Hessi hessatho hanidappe guye he dereyn diza hara harganchati yiidi paxida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Asaykka nuus daro miish ehidi nuna bonchizayssa nuna bessida; nu markaben baana dendin nuus koshshizayssa markaben wursi caanida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Nu Milixinen heedzdzu agina gam7idappe guye balgoy aadhdhana gakkanaas abba giddon diza dereyin gam7idi Iskindiriyappe yiza markaben gelidi baana dendidos; he markabeza bolla Diyossiqoroosa geetettiza nam7u mente eeqata misiley dees. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Gede Sirakuuse geetettiza katama gakkidi heen heedzdzu gallas gam7idos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Heeppe abba bollara biidi Regiyoome geetettiza katama gakkidos; heen issi gallas aqidi duge baggara yiza carkoy carkida gish nam7antho gallas Puttiyoloose geetettizaso bidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Heen ammanizayta demmidi istara nu laapun gallas gakkanaas uttana mala nuna woossida. Heeppe qasse Oroome bidos. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Oroomen diza ammaniza asay nu gish siydi Apiyoose geetettiza giyanne “Heedzdzu Aqosota” geetettizaso gakkanaas nuna mokkana yida; Phawuloosaykka ista beyidi Xoosse galatidessinne minetides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nuni Oroome gelida wode Phawuloosa naaganas issi wotadaray izas imettin Phawuloosi barka daana mala izas fiiqadey imettides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Heedzdzu gallassafe guye Phawuloosi Oroomen diza Ayhudatappe gita asata baako xeygisides; istika izakko shiiqin “Ta ishato! Tani Isra7eele dere bollanne nu aawata woga bolla ooththida issi qohoykka deenna; gido attin Yerusalamen tana qachidi Oroome asatas aaththi immida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Oroome asati tana qori oychidappe guye tana hayqos gaththiza miish demmoonta aggida gish birshi yeddana koyda. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Gido attin Ayhuda asay ta bolla issi wosoy baynda yeddetonta mala eqqettin ta yo7oy Qeesare sinth shiiqidi beetto gaanas taas gidde gidides. Gido attin tani ta dereta mootiza gaasoy taas deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ta qas ha7i intena xeygisiday intena beyanassinne hanno intes yootanassa. Hayssa sansalatan tani qashetiday Isra7eele naytas imettida ufaysa gaasonna” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Istika izas “Ne gish Yuhuda dereppe xaafetida debiddabbey nuna gakkibeenna. Ha yida asatappe oonikka ne gish iita haasayiday baawa. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Hayssa ne kaalliza ammanoza gish awanka asay iita haasayizayssa nu eroos. Hessa gish ne qofay azakkonne nu siyana koyoos” gi zaarida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Bare izas immidi hara gallas kushe kumidi izi diza keeththe yida. Izikka maladoppe omars gakkanaas Xoossa Kawoteththa gish markatethan ba qofa istas qoncisides. Muse wogappenne nabeta maxaafatappe xaqasi xaqasi Yesusa gish istas qoncisi yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Istafe issi issi asati izi yootida qaala ammanida; baggayti qas ammanibetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Istika ba giddon issoy issara qofan gaggonta shaaketida; Phawuloosi wursethan yootishe “Xillo Ayanay nabe Isayaasa baggara kase inte aawatas yootidayssi tumakko! ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Izi yootida qaalay, ‘Hayssa derakko baada inte sisi siyana shin yuushi qoppeketa, ayfera beyana shin woznan wotheketa gaada yoota. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Gaasoyka he asata woznay muumides, ista haythayka tullides; ista ayfey qooqides. Hessatho hanontakko isti ba ayfera beyidi ba haythara siydi ba woznan yuushi qoppidi taakko ha simmananne takka ista pathanashin’ gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Histikko Xoossi as ashshiza kiitay Ayzaabetaska kiitettidayssa inte erite; istika ero giidi ekkettes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Phawuloosi hessa yootidappe guye Ayhuda asati ba giddon daro palametishe kezi bida. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Phawuloosi kiratida keeththan nam7u layth kumeth de7ides; baako yiza as wursi mokki ekkides. ");
INSERT INTO gmvRNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Xoossa kawoteth sabakon Goda Yesus Kirstoosa gish oonikka iza diggonta xalatethara asa tamarsides.");
INSERT INTO gmvRNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Yesus Kirstoosa ayllenne Hawaare gidanas xeeygetida Mishiraachcho qaala yootanas Phawuloosappe kiitettida kiita. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","He mishiraachcho qaala gish kase nabeta baggara Geeshsha Maxaafatan ufaysi imettides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Mishiraachcho qaalaykka ba naaza gish izi asho baggara Dawute zerethafe gididayssa yootiza gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Hessathoka nu Goda Yesus Kirstoosi ba geeshshatetha Ayanan hayqoppe dendidayssi izi Xoossa naa gididayssi gita wolqan qoncides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kirstoosa suntha gish ammanonta derey ammanana malanne azazettana mala iza baggara nuni hawaratethas gaththiza kiyateth ekkidos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Inteka Yesus Kirstoosayta gidana mala xeeygetidaytara deeta. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Xoossan dosettidaytanne geeshshata gidanas xeeygetida Oroome biittan diza intes ubbas nu Aawa Xoossafenne nu Goda Yesus Kirstoosappe kiyatethinne sarotethi intes gido. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Inte ammanoy alame kumeththan siyetida gishshinne inte gish ta Goda Xoossa Yesus Kirstoosa baggara galatays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ta inte gish ubba wode ay mala qoppizakkone Xoossa naa mishiraachcho sabakon ta kumeththa woznappe izas ooththiza Xoossay taas marka. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Tani ta woossan ubba wode intena qoppays. Ha7i qasse wursethan Xoossa shene gidikko ta inteko baana mala Xoossi taas oge doyana mala woossays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Inte minnana mala maaddiza Ayana imotethi ta intes gishanassinne intena ayfera beyanas laamotays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Hessika intenne tani issoy issara ammanon minettanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ta ishato! Harason ammanontayta matan taas hanida mala inte matanka taas ooso ayfey bettana mala daro wode qoppadis shin hanno gakkanaas ta diggettada dizayssa inte erana mala koyays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Tamaridaytas gidin tamarontaytaska; eratasinne eeyatas ubbas ta bolla tamarsana accoy dees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Intes Oroomen dizaytassikka ta mishiraachcho qaala yootanas ta amottizay hessassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ammanzayti wuri attana mala Xoossa wolqa gidida gish ta mishiraachcho qaalan yeelatikke; hessikka koyro Ayhudatas kaallidi Ayzaabetassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","“Xilloy Xoossa ammanon dees” geetettidi kase xaafettida mala Xoossa xilloteth mishiraachcho qaalan qoncinna; he xillotethi koyroppe wurseth gakkanaas ammanon hanana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Tuma ba iitatethaninne makalan tucci oykkizayta iitatetha bollanne ista makalatetha ubba bolla Xoossa hanqoy saloppe qoncana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Isti eranas bessizazi Xoossi wursi istas qoncisida gish isti Xoosse eranaas qonce. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Alamey medhetosoppe haa simmin asa ayfen beetti eronta Xoossa hanotethi hessikka izas diza merna wolqaynne Xoossatethay izi medhdhida medhetethan qoncen beettees. Hessa gish asay shiishana gaasoy deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Isti Xoosse erikkoka iza Xoossatetha mala bonchibettenanne galatibettenna. Gido attin ista qofay mela go7ay bayndazi gididessinne yuushi qopponta mala ista woznay dhumides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Isti bana “Era” gizayta gidikkoka eeyata gidida. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Merna Xoossa boncho hayqqiza asaninne kafotan; mehetaninne biitta bolla gooshettiza medhetethatan misatissidi laammida. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Hessa gish Xoossi ista ba giddon issoy issara barka ba asatethan tuna ooso ooththana mala geeshshatethi baynda laymatethas aaththi immides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Isti Xoossa tumateth wordon laammida; medhdhida Xoossa aggidi medhetethas goynnidanne istas ooththida. Medhdhida Xoossi izi mernas galattettidayssa. Amiin. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Hessa geedon Xoossi ista yellachiza amotethas aaththi immides. Isti macasati banara zin7anas bessontaytara zin7ana mala bana aaththi immida. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Hessathoka attuma asay baasi bessiza macasatara zin7anas bessishin addey addera zin7anas amon xuugetidi macasatara zin7iza mala addey addera zin7idi pala miishi ooththida. Heytanti barka ba ooththida iita oosozas bessiza qixaate ba bolla ehida. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Qasseka isti ba qofara Xoosse eroy nuna maaddenna gida gish isti ooththanas bessontayssa ooththana mala Xoossi ista go7onta qofas aaththi immides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ubba baggara makalanne iitateth, yiiqenne iita ooson xalala kumida; qanatetethan, shempo wodhon, ooshan, baleththoninne genen kumidayta qasseka zigirzayta gidida. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Asa sunth moorizayta, Xoossa ixizayta, as cayzayta, otoranchatanne ceeqqettizayta gidida, ubba wode iita ooththanas oge koyizayta, bana yelidaytas azazettontayta, ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","yushi qoppontayta, gida qaala zaari laallizayta, asas mishetontayta; menxe iitata. ");
INSERT INTO gmvRNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Hessa “Ooththizayti wurikka hayqqanas bessees” giza Xoossa woga isti erishe heytanta baasi ooso xalala gidonta hessathoka ooththizaytaka minthethetes. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Hessa gish neno hara bolla pirdizaysso neni ta hanni geedon ooththadis giza gaasoy nees deenna. Ne hara asa bolla pirdizayssan nerka nees kunane ekkaasa. Gaasoyka hara asa bolla ne pirdizayssa nekka zaarada iza ooththiza gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Hayta malata ooththiza asata bolla Xoossa pirday likke gididayssa nu eroos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Hessa gish ne asa bolla pirdashe he ne pirdizayssa zaara ooththizade gidikko ne Xoossa pirdafe kessa ekka attana nees misatizee? ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Woykko Xoossa kiyateth nena maarotethakko kaalethizayssa shaaka eronta dashe iza gita kiyatethanne iza dandaya duretetha ne leqqay? ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Gido attin neni ne wozna muumetethaninne maaroteth koyonta ne wozna geedon tuma Xoossa pirday qonciza wode Xoossa hanqo gallassas ne bolla daro hanqo shiishasa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Xoossi issas issas iza ooso mala immana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Lo7o ooso aggonta ooththidi boncho sabanne merna de7o koyizaytas merna de7o immana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Gido attin barka bana dosizaytassinne tuma aggagidi iita kaallizayta bolla pirdaynne hanqoy gakkana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Iita ooththiza ay asa bolla koyro Ayhuda asa bolla kaallidi Ayzaabeta bolla waayeynne metoy gakkana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Gidikkoka lo7o ooththizades oonaska Ayhuda asas gidin Ayzaabetas sabay, sarotethinne bonchoy gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Xoossi oonakka shaakki maaddenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Kase wogay eqonta wode nagara ooththida asay wurikka wogay baynda dhayana; wogay eqi simmin nagara ooththidayti wogan oyketidi pirdettana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Ayssi giikko Xoossa achchan xillo geetettizayti eqqida wogas azazetizaytappe attin woga sisi siyizayta xalla gidetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Wogay baynda Ayzaabeti wogay yootizayssa coo mela hanotethafe eridi ooththishin istas wogay baynda aggikkokka istas medhetetha wogay diza gish isti ba ooththanayssa ereetes. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ista woznay istas markattiza gishshinne ista qofay ista mootiza gish qasseka ista maaddiza gish wogay yootizay ista woznan xaafettidayssa ereetes. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Hessika ta Mishiraachcho qaalan tamarsiza mala Xoossi asa woznan qotetidayssa Kirstoosa baggara pirdiza gallassan qoncisana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ne nena Ayhuda as giikko wogan ammanettasanne nees Xoossara diza issifetethan ceeqqettasa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Woga kaalliza gish Xoossa shene erada kumeth gidizaz shaaka erida gidikko, ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ne qooqeta kaaleththizade; dhuman dizaytas poo7o gididayssa ne ammanettidade gidikko ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","wogappe ne demmida eratethaninne tumatethan hanko erontayta zorizade, guutha nayta tamarsizade gidikko ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","histikko neni harata tamarso agada ne hu7es aazas tamarikii? Ne hara asi kaysotoppa ga sabakashe nees kaysotay? ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ne hara asay laymatonta mala yootashe nees laymatay? Nees eeqa ixasashin Xoossa Keeththa miisha bonqay? ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Nees wogan ceeqqettasa shin woga ne baggara ooththonta aggada Xoossa kawushshay? ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Hessika “Inte geedon Xoossa sunthi Ayzaabeta achchan cayeettes” geetetti xaafettida mala hanides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ne woga naaga polizade gidikko qaxxaras go7ay dees. Ne woga ooththontade gidikko qasse ne qaxxaray coo hada. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Qaxxaretonta dishe wogay gizayssa polikko qaxxaretidadera gina qoodetenee? ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Nees xaafettida wogaynne qaxxaray nees diikko diza woga ne naagontade gidikko hanko qaxxaretonta dashe wogas azazettiday ne bolla pirdana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Issadey coo mela sunthas asa ayfen ta Ayhuda as gidana giikko izi Ayhuda asi gidenna. Tumappe qaxxeretethi coo karera asho ayfen beettiza qaxxara gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Gidikkoka issi asi Ayhuda as gidanas dandayizay izas gaaththa baggara Ayhuda as gidishinna. Qaxxaraykka qaxxara gidizay xaafettida woga xalala gidonta Ayanan woznappe gidida qaxxara gidikkokko! Hessa mala asi galata asappe gidonta Xoossafe demmees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Histikko Ayhuda as gideththas aaza go7ay dizee? Qaxxaray ay go7izee? ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Awarakka gidin go7ay daro. Harappe koyro Xoossa qaalay hadara Ayhudatas imettides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Istafe issi issades ammanoy baynda aggikko Xoossa ammanoteth diggizee? ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Mulekka diggenna! Asi wurikka wordancha “Neni ne qaalappe dendidayssan tumancha; pirdanka xoonizade gidaasa” hessatho geetetti xaafettida mala Xoossi qasse tumancha. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Nu makala oosoy Xoossa xilloteth qoncen bessizayssa gidikko histin nu ay ganee? Coo asa woga mala palametanas Xoossi ba hanqo nu bolla ehizaysi nuus bessenna ganeyee? Hessaka ta gizay asatho qofanna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Tumappe hessatho hanenna. Hessatho haniza gidikko Xoossi alame bolla wosti pirdandee? ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ta wordoteth Xoossa tumateth qoncisizayssan iza boncho gede gujizayssa gidikko histin ha7i gakkanaas wosti ta bolla nagarancha mala pirdetizee? giidi palamettana asi daana dandayees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Hessa guussi “Lo7oy yaana mala ane iita ooththoos” geettes giidi issi issi asati nu bolla woresizayssa mala. Hayta asata bolla gakkiza pirday tumu pirda. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Histin nu ay giinoo? Nuni istafe aadhdhizonii? Mulekka aadhdhokko. Ayhudata gidikkoka Ayzaabeta gidikkoka wurikka nagarappe garsa baggara diza gish ta wursaka kasetada istas yootadis. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","“Xilloy oonikka deenna; issadeykka deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Yuushi qoppizadey baawa; Xoosse koyizay issadeyka baawa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Wurikka balettidanne issi bolla go7ontayta gidida. Lo7o ooththizay oonikka baawa; issadeykka deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Ista duunay doya diza duufo mala; ista duunay ubba wode baleththo haasayees; ista metershay shoosha marzera dees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Ista duunan qangethinne camo miish kumides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Ista tohoy suuth gussanas eesotes. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Ista ogen dhayoynne laafateth dees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Isti sarotetha oge erettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ista ayfeson Xoossas baboy baawa” geetetti xaafettida mala. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Hessa gish duunay wurikka gordettana mala derey kumeth Xoossas zaaro immana mala wogay gizay wurikka wogappe giddora dizaytas gididayssa nu eroos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Hessa gish wogay nagaray aazakkone erisees attin woga naagon oonikka iza achchan xillo geetettanas dandayenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ha7i qasse woga kase nabeti izas markattidays wogappe karera gidida Xoossa xillotethi qoncides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Hessi Xoossa xillotethi Yesus Kirstoosa ammanon dummatethi baynda beettiza xillotetha. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Gaasoyka asi wurikka nagara ooththides. Xoossa bonchoyka asa naas paccides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Asay Yesus Kirstoosi asa naa gish ooththida kiyatethafe dendidayssan coo mela xillides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Iza suuthan gidida ammanon nagarappe maarettana yarsho histidi Xoossi Yesusa shiishshides. Izi hessa ooththiday kasetidi poletida nagara qaxayonta dandayan aadhdhida ba xilloteth bessanasa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Izi hessa ha wodezan ooththiday ba xillotetha hessikka ba baggara xillo gidida Yesus Kirstoosan ammanizade xillisizayssa bessanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Histin nuni izan ceeqqettiza miishi aazi dizee? Aykko miishanka ceeqqettokko. Nu ceeqqettana gaasoy aazee? Woga naagiza gishee? Gidenna, ammanonna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Ay assikka ammanon attin woga naagon attontayssa nu geeshshi yootoos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Xoossi Ayhudata Xoosse xalalaa? Ayzaabetaska Xoosse gidenee? Ee Ayzaabetaska izi Xoossa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Qaxxaretidayssa ammanon qasse qaxxaretontayssakka he ammanonka xillisizaykka izi issi Xoossa xalla. ");
INSERT INTO gmvRNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Histin hessi hessa gidikko ammano geedon woga go7ay baynda miish ooththinoo? Mulekka hessatho hanenna; Woga nu minthana attin. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Hessa gish qasse nu Abrahaamey hayssafe ay go7a demmide giinoo? ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Abrahaamey ba ooson xillidakko izi ceeqqettanazi izas deessko shin; izi Xoossa sinthan ceeqqettanas dandayenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Geeshsha Maxaafay “Abrahaamey Xoosse ammanidesinne iza ammanoy izas xillotethan qoodettides” gees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Issadey ooso ooththikko izi ekiza miishay izas coo kiyateth imettizaz gidonta izaades ooso waaga gides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Gido attin ooso ooththonta nagarancha asi xillo kessiza Xoossan ammanizades iza ammanoy izas xillotethan taybetes. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Dawuteykka xillotethi izades qoodetizay lo7o ooson gidonta asa gish, ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Istas ista bala oosoy atto geetettidaytinne nagarappe maaretidayti anjettidayta! ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","iza nagara Goday mulekka qoodontadey izi anjettidayssa!” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Ha anjozi qaxxaretidaytas xalalayee? Woykko qaxaretontaytassaraa? “Kase koyro nu aawa Abrahaame ammanoy izas xillotethan qoodettides” gidos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Histin waani izas hessatho qoodettidee? Izi qaxxaretidappe guyee? Woykko qaxxaretanappe kasee? Izas xillotethan qoodettiday izi qaxxaretanappe sinthanna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Izi kase qaxxaretanappe kase demmida xillotethay qaxxaras malata gidana mala xillotethas maatame ekides. Hessa gish qaxxaretonta ammanizaytas xilloteth qoodettanna mala ubbatas izi aawa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Izi qaxxaretidaytaska aawa; qaxxaretidaytas xalala gidonta nu aawa Abrahaamey kase qaxxaretanappe sinthe izas diza ammano geedo kaallizaytas ubbassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Izi alame laattizade gidana mala Abrahaameynne iza zerethati ufaysa qaala ekiday woga baggara gidonta ammanon gidida xillotethana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Woga naagizayti laattizayta gidikko ammanos go7ay deenna; hidotayka coo hada gidanashin; ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","wogay hanqo kaaleththes. Wogay bayndason wogappe aadhdheth deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Hessa gish hidotay ammanon yides. Hessika iza hidotay iza kiyatethan gidana malanne Abrahaame zerethas ubbas ammanettizayssa gidana mala hanides. Hessika wogan izayta gididaytas xalala gidonta ammanon Abrahaame nayta gididaytas ubbatassa. Izikka nuus ubbaska aawa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Hessika “Ta nena daro dere aawa ooththadis” geetetti xaafettida mala hanides. Izikka hayqqidaytas de7o immizaden bayndayssa qasse diza mala ooththizaden ammanida Xoossa sinthan izi nuus aawa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Kase izas “Ne zerethi hessatho hanana” geetettida mala aykko hidotayka baynda dishin Abrahaamey Xoossi hanana gidayssa ammanidi daro dere aawa gidides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abrahaames yeletin xeetu layth gidichin Abrahaamey ba asatethay hayqetha mala gididayssanne Saaras yelo wodey aadhdhi bidayssa erishekka ammanon lepibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Gede gujjidi ammanon minnidi Xoossas boncho immides attin Xoossi gida qaala sidhibenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Xoossi izas immida hidotay poletanayssa kumeththa woznappe ammanides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Hessa gish izas xillotethan qoodetides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","“Izas xillotethan qoodettides” giza qaalay xaafettiday izas xalala gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Gido attin Xoossi nu xillotetha iza baggara tayibiza nu Goda Yesusa hayqoppe denthidayssan ammaniza nuussara. ");
INSERT INTO gmvRNT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Izi nu nagara gish hayqqanas aadhi imettides. Izi nuna xillisanas hayqoppe dendides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Histikko nuni ammanon xillida gish nu Goda Yesus Kirstoosa baggara nuus Xoossara saroteth dees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Hayssa ha ammanozan minni diza kiyatethan nuni geliday iza baggara gidida gish ufayssan Xoossa boncho gishetti ekizayta gidida gish nu ufayoos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Hayssan xalala gidonta nuna gakkiza waayenka ufayeettoos. Gaasoyka waayey dandayan gaththizayssa nu eroos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Dandayay paacen minoteth imees; paacen minoteth hidota imees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","He hidotay qasse nuna yellachenna. Xoossi nuus immida Xillo Ayanan ba siiqo nu woznan gussida gish he hidotay nuna yellan gaththenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Nu daburanchata gidi dishin Xoossa wodey gakkida mala Kirstoosi nu nagara gish hayqqides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Xillo asa gish hayqqana asi betanayssi daro metees. Lo7o asa gish hayqqanas xalana asi oonee erizay bettana dandayees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Gido attin nu buro nagarancha gidi dishin Kirstoosi nu gish hayqqides. Hessika Xoossi nuna siiqiza ba siiqo hessan bessees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Nuni iza suuthan geeyidayta gidikko harappeka iza baggara Xoossa hanqofe attana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Nu Xoossas morketa gidi dishin iza naaza hayqon izara giigidayta gidikko nu izara giigidappe guye iza naaza de7o baggara nuni paxidayssi waani keehi darene! ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Hessa xalala gidenna; qasseka nuni ha7i izara giiga demmida nu Goda Yesus Kirstoosa baggara Xoossanka ufays ooththoos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Hessa gish nagaray issade gaason duge ha alameza yida mala hayqoyka nagara gaason yides. Hayqoyka hessa baggara asa ubbakko yides. Hessas gaasoy asi wurikka iza baggara nagara ooththida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Wogay imettanappe kase nagaray biitta bolla dees shin wogay bayndason nagaray nagara gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Gido attin Addameppe ha simmin Muse wode gakkanaas diza woden Addame mala woga menthidi nagara ooththontayta bollaka hayqoy kawotides. Addamey buro yaana Kirstoosas leemiso. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Gidikkoka iza kiyatetha imotay asa qoho mala gidenna. Issadey mooridayssan daro asay hayqqikkoka Xoossa kiyatethaninne issi asi Yesus Kirstoosa kiyatethan yida imotay darotas keehi dari imettides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","17","Qasseka Xoossa imotay issade baggara yida nagarappe beettida ayfe mala gidenna. Gaasoyka iza pirday issade nagara kaallidi pirda ekki yides. Iza imotay qasse daro qoho gaason xilloteth ehides. Hayqoy issade baggara kawotidayssa gidikko daro tirpa gidida Xoossa kiyatethinne xillotetha imota ekkidayti issade baggara hessikka Yesus Kirstoosa baggara xoondi de7on daana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Histikko issade qoho geedon pirday asa ubba bolla gakkida mala hessathoka issade xillotetha ooson as ubbas de7o immiza xillotethi beettides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Issadey azazettonta ixida gish daro asay nagarancha gidida mala issade azazetethan qasse daroti xillana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Wogay yiin mooroy darides. Gido attin nagaray daroyssafe bollara Xoossa kiyatethi keehi darides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Hessika haniday nagaray hayqo bolla kawotidayssa mala Yesus Kirstoosa baggara qasse merna de7oy bettana mala iza kiyatethi xillotethan kawotanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Histin nu ay giinoo? Xoossa kiyatethi darana mala nagara gujji ooththinoo? ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Mulekka gidenna. Nuni nagaras hayqqidos. Histin hayssafe guye nu waani nagaran daanee? ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Nuni Yesus Kirstoosara issino gidana mala xammaqetidayti iza hayqon nu issife gidanas xammaqetidayssa hayssa inte ereketii? ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Hessa gish Kirstoosi ba Aawa bonchon hayqoppe dendida mala nunikka hessatho ooratha de7on daanas xinqaten hayqqidi izara moogetidos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Nuni hessa mala hayqon izara issino gidikko qasse denthanka izara issino gidoos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Hayssafe guye nu nagaras aylle gidonta mala nagara asatethay kichchana mala kase nu ceega asatethay izara issife kaqettidayssa nu eroos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Gaasoyka hayqqida asi nagarappe shempides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Nuni Kirstoosara hayqqidayta gidikko nu izara issife daanayssa ammanos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kirstoosi hayqoppe dendida gish nam7antho izi hayqqontayssanne iza bolla hayqos wolqay bayndayssa nu eroos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Izi hayqqida wode issito wursi nagara gish hayqqides. Gido attin Xoossas paxa duus dees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Hessathoka inte nagaras hayqqidi Xoossas Yesus Kirstoosa baggara paxa dizayssa erite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Hessa gish iita ooththana koyiza iita asho qofa koydi hayqqida inte asatetha bolla nagaray kawotana mala ooththofte. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Inte asateth iita ooso ooththiza miish ooththi nagaras haarisofte. Hessa mala ooththanappe hayqoppe gede de7on pinnida asata mala intena Xoossas haarisite. Inte asatetha xillotetha miisha mala Xoossas haarisite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Inte Xoossa kiyatetha garsan deeta attin woga garsan doonta gish intena nagaray haarenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Histin ay ooththinoo? Woga garsan gidonta nuni Xoossa kiyatetha garsan diza gish nagara ooththinoo? Mule ooththanas bessenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Inte intena aylle mala shiishshiza wode inte azazettizades aylle gididayssa ereeta. Hessathoka gede hayqokko efiza nagaras woykko xillotethako gaththiza azazetethas inte aylle gididayssa ereketii? ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Inte kase nagaras aylleta gidikko intes imettida timirtezas inte woznappe azazetida gish Xoossi galatetto. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Inte nagarappe wozetidi xillotethas aylle gidideta. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Hayssa ta asa qaalan intes qonccen yootizay inte yeletethan daburancha gidida gishassa. Inte kase wode inte asatetha aylletethasinne kaseppe aadhdhi iitana mala ooththi immeta shin ha7i qasse gede geeshshatethakko efiza xillotethas aylle histi haariste. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Inte kase nagaras aylletidi diza wode inte xillotethafe mela attideta shin; ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ha7i qasse inte yellatiza miishatappe he wode ay go7a demmidetii? Hessa he hanoza go7ay hayqo. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ha7i qasse inte nagarappe wozetidi Xoossa aylleta gidideta. Hessika intena gede geeshshatethakko kaalethees. Wursethaykka merna de7o. ");
INSERT INTO gmvRNT_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Nagara waagay hayqo; gido attin Xoossa imotay gidikko Goda Yesus Kirstoosa baggara merna de7o. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Ta ishato! Tani woga eriza asatas yootays. Wogay shempora paxa diza asa xalala haarizayssa inte ereketii? ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Issi macassi azina gelikko ba azinara iza wogan qashetizay azinay paxa diza wode gakkanaassa. Azinay hayqqikko iza macho gidiza wogappe anjettawus. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Gido attin azinay paxa dishin iza hara azina gelikko layma geetettawus. Azinay hayqqikko qasse hara asi gelikko kase azina wogappe anjettadus attin “Layma” geetetuku. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Hessa gish ta ishato! Inteka Yesus Kirstoosa asatetha baggara wogas hayqqideta. Inte hayqoppe dendida Kirstoosa bagga gidin nuni Xoossas ayfe ayfanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Nagarancha medhetetha shenen nu diza wode hayqos gathiza ayfe nu ayfana mala wogay dentheththida nagara amoy nu bolla ooththides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ha7i gidikko kase nuna waaxi qachida wogas hayqqida gish he wogappe wozetidos. Hessika kase ceega wogan xaafettidayssan gidonta dishe ooratha Ayana ogen nuni ooththanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Histin nu ay giinoo? Ba hu7es wogay nagaraa? Mulekka gidenna. Woga baggara gidontakko nagaray azakkonne nu erokkokko shin; wogay “Amottofa!” goontakko amoy azakkonne tumappe ta erikke. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Nagaray qasse wogappe kezida azazoy bessida ogen go7ettidi ta giddon dumma dumma iita amo dentheththides. Wogay yaanappe kase nagaray hayqqidaza. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Wogay baynda kase tani paxa dayssishin wogay yiin qasse nagaray paxa gidides. Ta gidikko hayqqadis. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","As ashshana qofetida azazoykka hayqo ekii yidayssa eradis. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Nagaray woga baggara beettida gaason go7ettidi tana baleththidesinne azazon wodhides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Hessa gish wogay ba baggara geeshsha. Azazoykka geeshsha; xillonne lo7o. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Gido attin lo7os hanidayssi taas hayqos gididee? Mulekka gidenna. Gido attin nagaray ba nagaratethan erettana mala lo7o gidida hano baggara ta bolla hayqo ehides. Hessika nagaray azazo baggara kaseppe aaththi nagara darsides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Wogay Ayana yo7o gididayssa nu eroos. Ta qasse nagaras aylle mala bayzettida asa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Tani ta ooththizayssa erike. Ta ooththana koyizayssa ooththa erike shin ta ixiza miish ooththays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ta ooththana koyonta miish ooththiza gidikko wogay lo7o gididayssa ta markatays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Hessa ooththizay tana gidonta ta gaaththan diza nagaray ooththes. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Tanan hessikka nagarancha gidida ta medhetetha giddon aykko lo7o miish bayndayssa ta erays. Lo7o ooththanas taas amoteth dees shin pola ooththa erikke. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Ta ooththizay ooththana gaada koyiza lo7o ooso gidenna. Gido attin ta ooththana koyonta iita ooso ooththays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Tani ooththanas koyontayssa ooththiza gidikko hessa ooththizay tana gidonta ta giddon diza nagara. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Hessa gish hayssi wogay ooson dizayssi taas gelides. Hessika tani lo7o ooththana koyaysishin iita ooththays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Tani ta gaaththara Xoossa wogan ufayetays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Gido attin ta asatetha giddon ooththiza nagara wogay tana qachi oykidi ta qofa wogara olettiza hara wogay ta asatetha giddon ooththishin beyays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ta ay mala laafa asee! Hayssa hayqos imettida asatethafe tana ashshanay oonee? ");
INSERT INTO gmvRNT_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Nu Goda Yesus Kirstoosa baggara galatay Xoossas gido. Histikko tani ta baggara ta qofan Xoossa wogas aylle gidashe tani ta medhetetha wogan nagara wogas aylle. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Hessa gish Yesus Kirstoosa ammanizayta bolla pirday deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Gaasoyka de7o Ayana wogay Yesus Kirstoosa baggara nagarappe ista geeshida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Nagarancha ashoppe dendidayssan wogay polanas dandayontayssa Xoossi ba naaza nagarancha asa leemison nagaras yarshettana mala yeddidi polides. Histidi nagara iza ashon pirdides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Hessika nuni ashon gidonta Ayanan simeretiza nuuppe wogay koyiza xillotetha polanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Asho shene mala daana koyiza asata woznay ashoy koyiza miishan shempees. Ayana shene mala dizayti qasse ba wozna Ayanay koyiza miisha bolla wothetes. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Ashos xalala qofay hayqo gidishin Ayana yo7os qofay gidikko de7onne sarotetha. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Nagaras haarettiza woznay Xoossara oosha. Gaasoyka izi Xoossa wogas haarettennanne haarettanas dandayenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Asho shene mala diza asatikka Xoosse ufayssas dandayettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Inte qasse Xoossa Ayanay intenan diza gidikko ashon gidonta Ayanan deeta. Kirstoosa Ayanay iza bolla bayndadey Kirstoosas gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Kirstoosi inte giddon diikko qasse inte asatethay nagara geedon hayqeth gidikkoka inte Ayanay qasse xillotetha gaason de7on dees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Yesusa hayqoppe denthida iza Ayanay inte bolla diza gidikko Kirstoosa hayqoppe denthidayssi inte giddon diza iza ayanay hayqqanas diza inte asatethas de7o immana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Hessa gish ta ishato! Hessika hananay dosan gidenna shin nu asho shene mala daanas ashos gidokko. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Asho shene mala diza gidikko inte hayqqana; asho ooso iitaza inte Ayanan wodhikko inte de7on daana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Xoossa Ayanan kaallizayti isti Xoossa nayta. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Inte ekkida Ayanay zaaridi intena aylletethan haariza ayana gidonta “Nu Aawawu” gi xeygisiza natetha Ayana ekideta. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Nuni Xoossa nayta gididayssa; he Ayanay ba baggara nu ayanara issife nuus markatees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Nuni Xoossa nayta gidikko iza laattizayta. Nu Kirstoosa bonchoza laattizayta gidana mala addafekka izara iza metoza gishettizayta gidikko nu Xoosse laattizayta; Kirstoosarakka issife laattizayta. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Ha7i nu ekiza waayey buro nuus sinthan giigi uttida bonchozara gaththi xeellishin aykkokka gidenna gays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Medhetethay wurikka Xoossa nayti qoncanayssa laamotethan naagon dees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Medhetethi wurikka mela hada gidana mala pirdetides. Hessika ba dooron gidonta sinthafes haarettana mala izi ba shene mala haarisida gishassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Hessika medheteth wurikka dhayssa aylletethafe wozetidi Xoossa naytas gidida gede bonchettida shene mala dizaso gakkanaassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Ha7i gakkanaas medhetethi wurikka daro waayen miixatishe dizayssa nu eroos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Iza xalala gidonta koyro Xillo Ayana imota demmida nunikka nu asatethay attana; nu iza naa gidanayssakka laamotishenne woznara miixattishe doos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Hayssa ha hidotan xalala attidos. Hidotay qasse ayfen beettiza miish gidikko buroppe naagiza miish gidenna; ha7i ba ayfen beyiza miishi buroppes naagiizay oonee? ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Gido attin nuni buro nu ayfen beyonta miish hidotan naagizaz gidikko saletay baynda naagoos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Hessathoka qasse nu daaburishin Ayanay nuna maaddes. Nuni woossa wosti woossanakkone eronta gish Ayanay nuni qaalan qoncisanas dandayettonta qaalara nuus woosses. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Nu wozna paaci eriza Ayanay izi Ayana qofa eres. Gaasoyka Ayanay Xoossa shene mala ammaniza asas nuus woosses. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Xoossi bana dosizaytassinne iza shene mala xeeygetidaytas ubbas ooththiza miish wursikka lo7os ooththizayssa nu eroos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Xoossi kaseppe ba erizayta isti iza naaza misatana mala kasekka doori woththides. Hessika daro ba ishata giddofe izi bayra gidanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Kase koyroppe ba dooridayta ista xeygides. Qasseka xeygidayta xillisides. Ba xillisidaytakka bonchides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Histin hessa nu ay giinoo? Xoossi nunara gidikko nunara eqetanas dandayizay oonee? ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Ba naazas mishetonta nu gish aaththi immiday iza. Histin ubba miish nuus izara kiyatethan wursi aazas imenee? ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Xoossi dooridayta mootizay oonee? Xillisizay Xoossa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Histin pirdizay oonee? Hayqqidi hayqoppe dendidi Xoossa ushachchan uttida Yesus Kirstoosi nu gish gaannates. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Nuna Kirstoosa siiqoppe shaakanay oonee? Metoyee? Waayee? Woykko goodeteththee? Woykko gafaa? Woykko kallotethee? Woykko qopponta gakkiza metoyee? Mashshaa? ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Hessika kase “Ne gish nu shukettiza dorsa mala qoodetidos. Gallas kumeth ne gish nuni hayqora baaxettana” geetetti xaafettidayssa mala. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Nuna aazika izappe shaakenna. Hayssa ubban nuna siiqidayssan xoonizaytappekka nu aadhdhos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Hessa gish hayqo gidin, de7o gidin, kiitanchata gidin, woykko ha7i diza miish gidin, buro yaana miish gidin, woykko ay wolqama gidin, ");
INSERT INTO gmvRNT_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","dhoqa gidin woykko ziqa gidin, woykko ay medheteth gidin Goda Yesus Kirstoosa baggara nuus diza Xoossa siiqoppe nuna shaakana dandayiza miishi bayndayssa ta shaaka eradis. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ta Yesusa sunthan tumu gays; wordotikke; ta woznaykka Xillo Ayana baggara taas markatees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Taas woznappe kichchonta gita qofaynne miishay dees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Ta dabbota gish ta qangetadanne Kirstoosappe shaaketada wora wodhdhidakko dosays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Istika Isra7eele nayta; isti Xoossa naa gidana mala Xoossa bonchoynne caaqo qaalay, wogaynne Xoossa Keeththa woga hidotay istas imettides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Kase Aawatikka ista bagga Kirstoosi ista zeretha zarken qoodetes. Izikka ubbafe bolla gidida mernas galattettida Xoossa. Amiin. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Gido attin hessa guussi Xoossa qaalay attides gussi gidenna. Isra7eeleppe yeletiday wuri Isra7eele as gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Abrahaameppe yeletidayti izappe yeletida gish wurikka iza nayta gidettennashin “Ne zereth Yisaaqa baggara xeeygettana” geetettida mala hanides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Hessa guussikka Xoossa naa geetettidayti isti ashon yelidayta gidettenna; gido attin naa gidanayti hidota qaalan yooteti uttidayta. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","“Yiza layth hanni wode ta ha simmana; Saaraykka nees attuma naa yelana” geetetidi izas hidota qaalay imettides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Hessa xalalaka gidenna. Irbiqa nayti issade naakko! Izikka nu aawa Yisaaqa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Menteti yeletidi buro iita woykko lo7o ooththonta dishin Xoossa qofay minnana mala, ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ooson gidonta xeygidayssafe gidida gish “Bayray kaalozas haarettana” geetettidi Irbiqas yootetides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Hessika “Ta Yaqoobe dosadis; Eesawe ixadis” geetetti kase xaafettida mala hanides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Histin nu ha7i ay giinoo? Xoossi bessonta ogera maaddi erizee? Mulekka maaddi erenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Xoossi Muses “Ta maarana koyidade maarana; ta mishettana koyizadeska mishettana” gees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Hessa gish asi koyda mala gidonta woykko asa daburan gidonta Xoossi maarida mala hanees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Geeshsha Maxaafay Faaroone “Ta wolqay ne bolla bettana malanne ta sunthi biitta ubba bolla yootettana mala ta nena hayssas denthadis” gees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Hessa gish Xoossi maarana koyizade maarees. Iza wozna muumisana koyizade wozna muumises. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Intefe issadey “Histin hanoy hessa mala gidikko nuna hanno gakkanaas aazas waayssizee? Gaasoyka iza shene diggana dandayizay oonee?” gaada ne oychonta aggaka. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Gido attin Xoossas zaaro zaara immizay ne oonee? “Oosetida miish zaaridi ooththidayssa ne tana aazas hayssatho ooththadii?” gi erizee? ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Urqa medhizadey he urqafe bagga bonchos bagga qasse coo hiraaysso oosos medhanas iza shene gidenee? ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Xoossika ba hanqo besanasinne ba wolqa erisanas koydi iza hanqo qoncisizayta, dhayanas giigettidayta dhayssonta aggagikkochi! ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Koyro bonchos giigissida iza maaroteth bessizaytaas iza boncho duretethay erettana mala izi ooththanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Xeeygidadey Ayhudata baggafe xalala gidonta Ayzaabeta baggafe gidida nunakka ashshonta xeygides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Hose7e maxaafan “Ta dere gidontayta tani ‘Ta dereta’ ga xeeygana; dosettontayta ista ta ‘Dosettidayta’ gaada xeeygana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Qasseka ‘Inte ta dere deekketa’ geetetti yootetidason heenka ‘Isti de7o Xoossa nayta’ geetetti xeeygettana.” ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Isayaassikka Isra7eele nayta gish “Isra7eele nayta qooday abba ace mala darikkoka guuthati xalala attana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Goday ba pirda biitta bolla elle pirdana” gi yootides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Hessika “Wogga Goday nuus zereth ashshontakko nukka soddome katama malanne Gamoora katama mala dhayanashin” geetettidi kase Isayaasa duunan yootidayssa mala hanides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Histin nu ay giinoo? Ammanon beettida xilloteth demmanas Ayzaabey daaburonta demmides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Gido attin xillotetha woga kaalliza Isra7eele nayti demmibettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Hessi aazas hessatho hanidee? Isti ammanon gidonta ooson demmana kaallida gishassa. Istika dhuphe shuchchan dhuphetida. ");
INSERT INTO gmvRNT_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Hessika “Hekko asa dhuphiza shuch ista kundisiza zaalla Xiyoone bolla ta wothana; izan ammanizadey yeellatenna” geetettidi kase Geeeshsha Maxaafan xaafettidayssa mala hanides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Ta ishato! Isra7eele nayta gish ta amoynne ta Xoosse woossizay isti dhayonta attanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Isti Xoossa yo7os mishetizayta gididayssa ta ista gish markattana dandayays; ista mishetethi gidikko eratethan gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Xoossi as xillisiza oge eronta aggidi ba xillotethas oge kaallida attin Xoossa xillotetha oge kaallibettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Ammaniza asa ubba xillisanas Kirstoosi woga ubba polides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Musey woga baggara beettiza xillotetha gish erisishe “Hayta wogata poli ooththizadey ha wogatan daana” gizayssa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Ammanon beettiza xillotethi qasse hizgees “Ne woznara pude salo oonee kezanay? gooppa” hessatho guussi Kirstoosa saloppe duge ha wothana guussa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Woykko “ ‘Duge ciimman oonee wodhdhanay?’ Gooppa!” hessikka Kirstoosa hayqoppe buro denthana guussa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Gido attin qaalay ay gizee? “Qaalay ne achchan dees.” Ne duunaninne ne woznan dees. Nuni ammano gish sabakiza qaalay hayssa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Neni ne duunara “Yesusi Goda” gaada markattikko Xoossi iza hayqoppe denthidayssa ne woznan ne ammanikko attana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Neni xillanay woznan ammanikkonne attanay ne duunara markatiinna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Geeshsha Maxaafay giza mala “Izan ammanizay wurikka yeellatenna.” ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Ayhudata giddoninne Ayzaabeta giddon dummateththi deenna; issi Goday ubbaska Goda; iza woossizayta gujji anjees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","“Goda sunth xeygizayti wurikka attana” geetetti Geeshsha Maxaafan xaafetides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Histin iza ammanontayti iza wozgi xeeyganee? Qasse iza gish siyonta dishe wosti ammananee? Saabakey baynda dishin wosti siyanee? ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Kiitetonta wosti sabakandetoo? Hessika “Mishiraachcho qaala ekkii yizayta yuussi ay mala lo7o” geetetti Geeshsha Maxaafan xaafettida mala hanides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Gido attin siyidayti wurikka Mishiraachcho qaala ekibettenna; Isayaassi “Godo nu yootidayssa ooni ammanidee?” gida mala hanides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Hessa gish ammanoy beettizay yootiza qaala siyethanna. Yootetiza qaalaykka Kirstoosa gish yootiza qaalappe. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Gido attin asay siybeneshaa? gaada ta oychays; tumappe asay siydes; Geeshsha Maxaafan xaafettida mala “Ista qaalay biitta ubbaninne alame gaxa gakkanaas siyetides.” ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Ta qasseka oychays; Isra7eele nayti qaala eribeteneshaa? Koyro Musey istas “Ta dere gidontaytan ta ista amosisana; yuushi qopponta deretan ta ista yiillochana” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Isayaassikka xalatethan “Tana koyontaytas ta bettadis; tana oychontaytas tana qoncisadis” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Isra7eele gish qasse “Taas azazetonta derekkonne taas eeno goonta derekko kumeththa gallas ta kushe micadis” gees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Histin Xoossi ba dereta yeggi aggidee? Gaada ta oychays; mulekka aggibenna; takka ta baggara Biniyaame zarike, Abrahaame zereth gidida Isra7eele asa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Xoossi koyroppe ba erida dereza yeggibenna. Elaassi Isra7eele nayta bolla mooto Xoossakko wosti shiishshidakkonne Geeshsha Maxaafay iza gish ay gizakko inte ereketii? ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Godo! Isti ne nabeta wodhida. Nees yarshizasotakka laallida. Qasse tani tarka attadis. Tanaka wodhana geetes” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Xoossi izas “Ba7aale geetettiza Eeqas goynontayta laapun shi as tani taas ashshadis” gi zaarides ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Hessa malaka ha7i ha wodezanka Xoossa kiyatethan Isra7eele asappe dooretti attida guuthati deettes. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Histin hessi Xoossa kiyatethan gidikko asa ooson gidenna. Asa ooson gididakko Xoossa kiyatethi kiyateth gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Histin ay gaanee? Isra7eele nayti lo7ethi koyidayssa demmibettenna. Xoossan doorettidayti gidikko demmida. Hanko attidayta woznay muumides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Kase “Ista ayfey xeellonta mala, ista haythayka siyonta mala Xoossi hanno gakkanaas istas doccissiza Ayana immides” geetetti Geeshsha Maxaafan xaafettida mala. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Dawuteykka “Ista maadday ista oykiza narxanne yarde; istas dhuphizazinne qixaate gido. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Ista ayfey xeellofo; goozzetto; ista zokkoy mernas kuunno” gides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Ane qasse ta zaara oychays; Isra7eele asay nam7antho kundethafe dendennee? Dendana. Harappeka Isra7eele nayta qanatissana gish ista mooro gaason atotethi Ayzaabetas gakkides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Gido attin qasse ista mooroy Ayzaabetas anjo gidides. Ista kundethikka qasse Ayzaabetas anjo gidikko isti simmi attidakko ay mala gita anjo gidandeshin! ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Ayzaabeto! Ta intes yootays, ta Ayzaabetas kiitettidade gidida gish ta oosoza minnada polana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Hessika ta bagga asati amozana mala denthethada istafe guutha asata ashshanas ufayssa ooththays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Xoossi ista aggida Ayzaabeti Xoossara giigikko Xoossi Isra7eele nayta zaaridi ekkiza wode intes aazi hanana misatizee? Hessa guussi “Hayqoppe dendides” guussa mala. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Koyro bukeesoy lo7o gidikko hanko izappe oosettizays wurikka lo7o gides. Hessathoka issi mitha xaphoy lo7o gidikko hanko iza bolla diza haggatikka lo7o gidettes. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Keeththa matan diza wogara mitha haggata malati inte meqqi wodhdhin hanko woran diza wogara mithata misatiza Ayzaabeti inte kichchosan gididi inte haaronne inte anjo shaakki ekkizadenta gidikko; ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","heyta he meqqi wodhdhida haggata bolla otoretofa. Inte ista bolla otoretikko qasse hanno woznan woththite. He mitha tookkiday nena gidakka. Mithay nena tookkides attin. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Histikko “He haggati meqqi wodhdhiday nuni isti kichchosan gelana malassa” goonta aggeketa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Tumu gideta shin isti meqiday ammano paceppe dendidayssanna. Inte qas ammanon eqideta. Babbite attin otoretofte. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Xoossi koyroppe diza haggatas mishetontade gidikko inteska mishetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Hessa gish Xoossa kiyatethinne iza menxe iitatetha ane xeella. Iza menxe iitatethay kundidayta bolla. Iza kiyatethay qasse inte iza qadhetetha garsan diza wode gakkanaas xalala. Hessi baynda aggikko inteka qanxettana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Isti ammanonta minni eqidasoppe simmikko kase baso simmi gelana. Xoossika ista zarsi gelthana dandayes. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Inte bazzo wogara mithafe qanxetidayti kase inte medhetethafe gidonta lo7o mithan inte gelana dandayikko koyroppe ba medhetetha haggata gididayti heyti kase iza bolla diza wogara mithan simmi geloy istas waani hannenee? ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ta ishato! Inte cinca as gididayssa intes misatonta mala hayssa gido xuura yo7oza inte eronta attana mala ta koyikke. Hessika Ayzaabetappe xeeygetidayti wuri ammanana gakkanaas Isra7eele nayta woznay muumides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Hessa gish Isra7eele nayti wurikka attana. “Ashshizaddey Xiyooneppe yaana; Yaqoobeppeka iitateth diggana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Tani ista nagara wursa dhayssidappe guye ta istara caaqon geliza qaalay hessa” geetettidi kase Geeshsha Maxaafan xaafettida mala hanides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Intes Ayzaabetas Mishiraachcho qaalay gakkana mala Isra7eele nayti Xoossan ixettida as gidida. Gidikkoka kase dooro mala gidikko ba aawata baggara isti dosettidayta. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Xoossi dooridappenne ba kiyateth immidappe guye ba ooththida miishan simmidi modhetenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Inteka kase azazettontaytakko! Isti azazettonta ixin ha7i intena maaridayssatho; ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Xoossi intena maarida geedon istika maarettana mala ha7i azazettontayta gidida. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Xoossi wursikka maaranas asi wurikka azazettonta mala gordides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Xoossa duretethay, aadho eratethaynne iza eratethay ay mala ciimma! Iza pirday ay malakkonne paacetenna. Izi aadhdhida geedoyka eretenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","“Goda wozna eriday oonee? Izas zore immiday oonee? ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Xoossi zaari immana mala izas tal7e immiday oonee?” geetetti xaafettida mala. ");
INSERT INTO gmvRNT_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Wurikka izappe, izan, izassa; izas bonchoy mernappe mernas gido! Amiin. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Hessa gish ta ishato! Inte asatetha geeshshinne Xoosse ufayssiza de7o yarsho ooththidi inte shiishana mala ta intena Xoossa qadhetan woossays. Hessika woznama asa mala inte Xoossas ooththiza ooso. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Lo7o, ufaysizazinne kumeth gidida Xoossa sheney aazakkonne inte paaci erana mala inte qofan oraxidi laametite attin hayssa alame asa misatoppite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Intes Xoossi immida ammano mala interka intena paaci xeellite attin ha7i dizayssafe bollara intena dhoqisi xeellonta mala tani taas imettida Xoossa kiyatethan intena issa issa zorays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Nuuppe issi issi asas issi asatetha bolla daro billiteti diza mala heytikka he billiteti issi mala ooso ooththontayssatho; ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","hessathoka nuni darota gidi uttidi Kirstoosan issi asho; nuni issoy issas asho. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Nuus imettida imota mala dumma dumma imotethi dees. Issades buroppe hananaz yooto gidikko izaades imettida ammano mala yooto. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Ooththi maaddizadey ooththi maaddo; tamarsizadeykka tamarso. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Zorizadey gidikko zoro; bayndaytas immizadey gujji immo. Ayssizaddey minni aysso. Maarizadeykka ufayssan maaro. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Inte siiqotethi qoodheppe qommon gidoppo. Iita gididayssa wursikka ixite. Lo7o gididayssara issife oyketite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Inte inte garsan issoy issara ishata mala lo7ethi siiqetite. Issoy issa bappe aaththi bonchizayta gidite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Godas ooththana Ayanan xuugetizayta gidite attin hessa he minotethafe guye gooppite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Hidotan ufayetizayta gidite; meto dandayite; woossan minnite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Ammanishe waayetizaytas intes dizayssafe shaakki immite. Imath mokkite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Intena qangizayta anjite attin qangofte. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Ufayetizaytara ufayetite; muuzotizaytara muuzotite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Inte inte garsan doseteththan diite. Manqotara issifetethan daanas koyite attin otoretofitenne ceeqqettofte. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Oonaska iita gish iita zaaroppite. Asa ubba achchan lo7o miish ooththanas minnite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Intes dandayettikko inte inte baggara asa ubbara saron diite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Ta siiqoto! Inte halo Xoossi kesso attin interka halo kessofte “Halo kessanay tana gees Goday” geetetti Geeshsha Maxaafan xaafettides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Halo kessanappe “Neni ne morkey gafikko miza; izi saamotikko ushsha; ne hessatho ooththikko tama bonqo iza bolla koraasa” geetettidi Geeeshsha Maxaafan xaafetides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Iita lo7o ooson xoona attin iitan xoonetofa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Ay assikka bana ayssiza daannatas haarettanas bessees. Xoossafe imettonta dishin daannatethi deenna. Ha7i diza daannati Xoossafe daannattidayta. ");
INSERT INTO gmvRNT_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Hessa gish daanna bolla makaliday Xoossa woga bolla makalees. He makalizaytikka ba bolla pirda eheetes. ");
INSERT INTO gmvRNT_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Dere ayssizayti iita ooththizayta babisettes attin lo7o ooththizayta babisettenna. Ne dere aysizades babbonta aggana koyay? Histikko lo7o ooththa; izikka nena galatana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Izi nees lo7o ooththanas Xoossa oosancha. Gido attin ne iita ooththida gidikko izas babba. Gaasoyka izi mashsha coo mela gixxibenna; izi iita ooththizade qaxayanas Xoossa oosancha. ");
INSERT INTO gmvRNT_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Hessa gish iza qixaates babo xalala gidonta ne qofanka daannattizades azazettanas bessees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Inte giira immizay hessassa. Ayssizayta hessa he oosoza bolla Xoossi ista woththides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Istafe issas issas bessizayssa immite. Giira immana bessizaytas giira immite; qaraxa qanxanas bessizaytas qaraxa qanxite; babbanas bessizaytas babbite; bonchanas bessizayta bonchite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Inte garsan issoy issara siiqetethafe attin oona bollaka accoy dooppo. As siiqiza asi izi woga polides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","“Laymatoppa, wodhoppa, amottofa” gizaytinne hara azazoti diikkokka “As ubbakka ne mala siiqa” giza hanno issi wogan wurikka kuuyettides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Siiqoy asa bolla iita ooththenna; hessa gish siiqoy woga ubbas kuushsha. ");
INSERT INTO gmvRNT_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Hayssa wodeza caddi xeelidi hessa ooththite. Ha7i hanna inte dhiskofe dendiza wode. Nu kase ammanosappe haa simmin ha7i nuus attiza wodey matides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Qamay aadhdhin wontana gees. Hessa gish ane nu dhuma ooso wora yeggidi poo7o ola miishi may7os. ");
INSERT INTO gmvRNT_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Gallassara hammuttiza mala ane wogara hammuttos. Magulthaninne mathon gidoppo; layma amoninne layman gidoppo; qanatetethaninne palaman gidoppo. ");
INSERT INTO gmvRNT_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Hessa aggidi Yesus Kirstoosa may7ite. Asho amo polanas qoppofte. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Inte garsan ammanon buro minnontade shiishshi ekkite attin iza qofa bolla pirdofte. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Issi issi asi beettidayssa wursi maanas ammanoy dees. Qasse ammanon minnontadey atakilte xalala mees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Bettidayssa wursi mizadey wursi moontade kadhoppa. Moontadey qasse mizade bolla pirdofo. Xoossi ubbakka ekides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Hanko ooththizade bolla pirdizadey ne oonee? Izaadey kundikko woykko eqikkoka Godassa. Goday iza essanas dandayiza gish izi eqandes. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Issadey “Gallassatappe issi gallas hara gallassafe aaththidi baasi dumma gallas” gi qoppees. Hara asi qasse “Gallassati wurikka issi gina” gi qoppees. Issi issi asi ba woznan ammanida mala ooththo. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Issi gallassi hara gallassafe dummassi qoppizadey izi hessa ooththizay Goda bonchos gidikko mizadeyka Goda bonchos giidi mees. Miidi Xoosse galattees. Montadeyka Goda bonchos giidi muus aggessinne Xoossas galata imees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Nuuppe oonikka baasi dizaddeynne bappe baasi hayqqizaddey deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Nu diikkoka Godas doos. Hayqqikkoka Godas hayqos. Hessa gish diikkoka woykko hayqqikko nu Godassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Hessa gish hayqqidaytassinne paxa dizaytas Goda gidanas Kirstoosi hayqqidi hayqoppe paxi dendides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Histin ne aazas ne isha bolla pirday? Aazas ne isha leqqay? Nu wurikka Xoossa pirda wombora sinth shiiqos doos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","“Ta paxa days. Gulbatey wurikka taas gulbatana. Inxarsi wuri Xoossas markattana” geetetti kase Geeshsha Maxaafan xaafettides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Hessa gish nuni issi issi asi Xoossa sinth shiiqidi nu ooso gish izas zaaro immana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Hessa gish nuni nu garsan issoy issa bolla pirdanappe ane naagetos. Hessa aggidi nu ishas dhuphe gidizayssa woykko iza oykiza narxa wothonta mala ane nu naagetos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Tani Goda Yesusan ammanada miza kaththan tunay bayndayssa eradis. Gido attin issadey issi miish tuna gi qoppikko he miishay izaadesi tuna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Neni ne isha miza kaththa geedon dhuphe gidikko siiqon simeretabakka. Kirstoosi iza gish hayqqida ne isha ne miza kaththa gaason wodhoppa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Inte lo7o giidi qoppiza miish iita getettana mala ooththofte. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Xoossa kawotethi Xillo Ayanan beettida xilloteth, sarotethinne ufayssafe attin muussa yo7onne ushsha yo7o gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Hayssatho Kirstoosas ooththizadey Xoosse ufayssessinne asa achchanka galattettes. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Hessa gish sarotethi beettiza ogenne nuni nu garsan lo7onas bessiza oge ane koyoos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Nuni miza kaththa gish giidi Xoossa ooso ane laallokko. Kaththi wurikka geeshsha. Gido attin hara asas dhuphe gidiza kath muussi bala ooso. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Ne ishas dhuphe gidizazi gidikko ashokka maanappenne woyne cajje uyanappe woykko ay miishikka ne ooththonta aggikko lo7o. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Hessa gish, haytanta misatiza miishatas nees diza ammanoy ne giddoninne Xoossa giddon de7o. “Hayssi likkeko” giidi ammanon ekkida miishan barka ba bolla pirdontadey izaadey anjettidade. ");
INSERT INTO gmvRNT_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Gido attin woznara sidhishe miikko izi ammanon moonta gish iza bolla pirdetides. Ammanon ooththontazi wurikka nagara. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Nuni ammanon minnidayti hanko ammanon minnotayta meto tookkanas bessees attin nu xalla ufayetizayta gidanas bessenna. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Nuni wurikka hara asi ba ammanon minnana mala iza go7izazinne ufaysiza miish ane ooththoos. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kirstoosi bana ufaysibenna; harappeka “Asay nena cayida cashshay tana gakkides” geetetti kase Geeshsha Maxaafan xafetidaysi poletides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Nuni Geeshsha Maxaafatappe demmiza dandayaynne minotethi nuus daana mala koyroppe xaafettidayssi wurikka nu izappe nuus timirte demmana mala xaafettides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Minotethinne dandaya immiza Xoossi inte Yesus Kirstoosa kaallishin intes inte giddon Ayana issifeteth immo. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Hessika inte issi woznaninne issi duuna gididi nu Goda Yesus Kirstoosa Aawa Xoossa bonchanassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Hessa gish Xoossi intena Xoossa bonchon mokki ekkida mala inteka issoy issa ufayssan mokki ekkite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Kase aawatas imettida hidota qaala polanas Xoossa tumatethi erettana mala Kirstoosi Ayhudatas ooththizade gididayssa ta intes yootays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Hessathoka Ayzaabeti iza maarotetha gish Xoosse galatana mala; hessikka “Ta nena dere giddon galatana; ne sunthaska galata yeth yexana” geetetti Geeshsha Maxaafan xaafettida mala. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Qasseka “Ayzaabeto! Inteka Xoossa deretara ufayetite” geetetti Geeshsha Maxaafan xaafetides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Nam7anthokka “Ayzaabeti inte wurikka Goda galattite; derey wuri iza sabbite” geetetti Geeshsha Maxaafan xaafettides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Hessatho Isayaasan “Ba dere asa bolla kawotiza Iseeye nay yaana. Alame asa ayssizaddey dendana; istika izan ufayettana” gees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Inte izan ammaniza gish hidota Xoossi intenan ufaysinne saroteth kuntho. Hessika Xillo Ayana wolqa hidota intes daranassa. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Ta ishato! Inte lo7etethan; erateth ubban kumidaytanne harata zoranas eray dizayta gididayssa ta addafe shaaka eradis. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Ta Xoossafe ekkida imotetha gina qasseka intena qofisanas issi issi yo7ota xalatethan intes xaafadis. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Hessa he kiyatethay imettiday tani Xoossa Mishiraachcho qaala hanko deretas yootana mala; qasseka Qeese mala gidida Yesus Kirstoosas ooththanassa; hessa gish hanko dere asay Xillo Ayanan dummatidi Xoosse ufaysiza yarsho gididi shiiqana mala ooththays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Hessa tani Xoossas ooththiza gish Yesus Kirstoosan ceeqqettays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Ta yootidayssaninne ta ooththidayssan hanko dere asay Xoossas azazettana mala Kirstoosi tanan gididi ooththidazappe attin hara haasayana xalikke. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Hessika haniday Xillo Ayana wolqan malatata baggara hanides. Hessa malanka Yerusalameppe Ilwaqoore gakkanaas ta Kirstoosa Mishiraachcho qaala sabakadis. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Hara asi kase ooththidason ta gelonta mala gaada kase Kirstoosa sunthi xeeygeti erontason Mishiraachcho qaala sabakanayssi taas amo. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Harappeka “Iza gish istas yootetontayti iza beyana; siyi erontayti haasa7ana” geetetti kase Geeshsha Maxaafan xaafettida mala hanides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Hessa geedon ta inteko boonta mala daro wode diggettadis. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Ha7i qas taas haan oosoy baynda gish daro laythatappe haa simmin intena beyanas ta daro laamotadis. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Hayssa ta qofa tani Ispene biza wode polanas qoppays. Heera aadhdhashe intena beyanassinne intenara guutha wode gam7ada laamota aaththida mala inte tana maaddana gaada hidota ooththays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Ha7i qas ammanizaytas imettiza maado gish ekkada Yerusalame bays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Gaasoyka Maqidooniyaninne Akaayan diza manqota maaddana dendides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Hayssa ha maadoza isti ba dosan immiday isti ooththanas bessiza gishassa; Ayzaabeti Ayhudatara issife Ayana anjo ekkizayta gidikko istika baasi diza biitta anjon Ayhudata maaddanas bessees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Hessa gish hayssa shiiqida maado miisha Yerusalame immidappe guye inte achchan ta Ispene baana. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Ta he inteko bashe intes Kirstoosa anjo kuntha eka baanayssa ta erays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Ta ishato! Tani Xoossa woossan baaxetiza mala inteka tanara baaxettana mala ta intena Goda Yesus Kirstoosaninne Xillo Ayana siiqon woossays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Tani Yuhudan diza ammanonta asa kusheppe attana malanne Yerusalamen diza ta ooththoykka heen ammanizayta achchan ekettana mala taas woossite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Hessika Xoossa shene mala he inteko ta ufayssara baana malanne intenara issife shempana mala. ");
INSERT INTO gmvRNT_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Sarotetha Goday intenara ubbatara gido. Amiin. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Kinkira7oose Woosa Keeththan ooththiza ammanettida micheyo Pebeeno intes hadara gays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Ammaniza asas bessiza mokko inte izo Goda sunthan mokki ekkana malanne iza intefe koyiza ay miishanka inte izo maaddana mala ta intena qofisays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Kase tanara Goda Yesus Kirstoosas issife ooththida Phirsiqillassinne Aqilas ta sarokka gaththite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Isti ta gish hayqqana gakkanaas bana aaththi immida; tana xalala gidonta Ayzaabetappe ammanidaytikka ista galatetes. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Ista keeththan diza ammaniza asaaka saro giite. Iisiyappe koyro Kirstoosan ammanida ta siiqoza Ephenexoose saro giite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Intes daro daaburidaro Maaramo saro giite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Tanara issife qashetida Andiraqonenne Yuniyase saro giite. Heytanti Hawaareta garsan lo7o sunthara dizaytanne Kirstoosa taappe kase ammanidayta. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Tani Goda baggara daro siiqiza Philyaxone saro giite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Kirstoosa ooso tanara issife ooththiza Irobanoonenne ta siiqiza Senxakekka saro giite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Kirstoosan iza ammanoy paacetidi galattettida Exessenesses ta sarokka gaththite. Arsixabaloso asaska ta sarokka gaththite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Ta dabbo Herodiyaana saro giite. Godan diza Niriqaasoso asa saro giite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Godan gididi minotethan ooththiza macasata Tirofimoononne Xirofimoono saro giite. Godas ooson daro daaburidaris Kirstoosan tani izo siiqiza Xarsidis ta sarokka gaththite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Godan doorettida Ruufoones, taassinne izas aayo gididaris ta sarokka yootite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Asqeroonessi, Afilasoonessi, Heromeenessi, Phaxirobaanessi, Hermaanessinne istara diza ishata ubbatas ta sarokka gaththite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Filegoones, Yuuliyaas, Neeriyassinne iza micheys hessathoka Alxoones, istara diza ammanizaytaska ta sarokka gaththite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Issoy issa yeeri yeer ekkidi saroketite. Kirstoosan ammaniza Woosa Keeththa asay wurikka intena saro gees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Ta ishato! Asa garsan shaaketethi medhizaytappenne inte tamarida timirta ekkonta ixon intes dhuphe gidiza asatappe inte naagetite. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Heytanta mala asati Yesus Kirstoosas ooththizayta gidonta ba qantha kaththa gish ooththizayta. Shugo qaalara haasayaninne wozna kiya asata baleththetes. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Inte mishiraachcho qaalas azazettizayta gididayssa asi wuri siydes. Hessika tana daro ufaysides. Gidikkoka inte lo7o hanos cincata qasse iita oosos eeyata gidana mala ta koyays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Sarotetha Goday Xala7e eeson inte toho gars aaththi dincereththana. Goda Yesus Kirstoosa kiyatethi intenara gido. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Tanara issife ooththiza Ximtoossi qasseka ta dabbo Luqiyoossi, Iyaasooneynne Susiphexiroossi intena saro saro geetes. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Hayssa kiita xaafiday tani Xerixiyoossi intena Goda sunthan saro gays. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Taninne hayssan diza kumeththa Woosa Keeththa asay mokki ekkiza Gayiyoossikka intena saro gees; katama miishsha oykkiza Erisxoossinne nu isha Qo7axiroossi intena saro geettes. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Goda Yesus Kirstoosa kiyateth intenara ubbatara gido. Amiin. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Tani yootiza Mishiraachcho qaalay Yesus Kirstoosa gish yootetiza kiitaynne beni wodeppe doommidi qotan gam7idi ha7i qasse qoncida tuma xuura baggara izi intena ammanon essanas dandayees. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Ha7i qasse hayssi tumay qoncides. Merna Xoossa azazon wurikka ammanidi azazettana mala nabeta maxaafa baggara dereti wurikka iza erana mala hanides. ");
INSERT INTO gmvRNT_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Izi xalala era gidida Godas Yesus Kirstoosa baggara merna bonchoy izas gido. Amiin.");
INSERT INTO gmvRNT_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Xoossa shenen Yesus Kirstoosas kiitetanas xeeygetida Phawuloosappenne nu isha Sostineeseppe; ");
INSERT INTO gmvRNT_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Qorontoosen diza Xoossa Woosa Keeththas; Goda Yesus Kirstoosas dummatidaytasinne istassara nuussara Goda gidida Goda Yesus Kirstoosa suntha awan awanka xeygiza ammanizaytara gidanas xeeygetida asa ubbas. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Nu Aawa Xoossafenne Goda Yesus Kirstoosappe kiyatethinne saroy intes gido. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Goda Yesus Kirstoosa baggara intes imettida Xoossa kiyatetha gish ubba wode inte gishikka tani Xoossa galatays. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Gaasoy ay yo7onka; hessikka haasayan gidin eratetha inte ubban duretideta. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Kirstoosa gish nu intes markattidayssi inte achchan minnides. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Hessa gish inte Yesus Kirstoosi qoncana gallas naagishin Ayana imotethatappe aykkoykka intes paccenna. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Goda Yesus Kirstoosi nam7antho yaana gallassan inte inte bolla boroy baynda bettana mala wurseth gakkanaas izi intena lo7eth naagana. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Izi ba naaza nu Goda Yesus Kirstoosa issifetethako intena xeygida Xoossi izi ammanettida Xoossa. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Ta ishato! Inte garsan shaaketethi doonta mala intes issi woznaynne issi qofay daana mala inte inte garsan issino gidana mala Goda Yesus Kirstoosa sunthan ta intena woossays. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Ta ishato! Inte garsan palamay dizayssa ta Qaalo7e so asappe siyadis. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Yo7ozikka hayssa mala; inte garsan issi issi asay “Ta Phawuloosa bagga” gees; baggay qasse “Ta Aphilosa bagga” gees; baggay qasse “Ta Keefa bagga” gishin haray qasse “Ta Kirstoosa bagga” gees. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Histikko Kirstoosi shaaketi wodhdhidee? Inte gish Phawuloosi kaqettidee? Woykko Phawuloosa sunthan xammaqetidetii? ");
INSERT INTO gmvRNT_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Inte giddofe Qerisphoosappenne Gayiyoosappe attin hara oonakka ta xammaqonta gish Xoossa galatays. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Hessa gish oonikka “Ta Phawuloosa sunthan xammaqetadis” gaana asi deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Tumukka Istifanoose so asa xammaqadis. Heytappe hara ta xammaqidakkone ta erizadey deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Kirstoosi tana kiittiday Mishiraachcho qaala yootanas attin xammaqanas gidenna. Kirstoosa masqaley hada gidonta mala ta asappe gidida cincateththan sabakikke. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Masqaleza kiitay dhayana dizaytas eeyateththa. Gido attin attana diza nuus gidikko Xoossa wolqa. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","“Cincata cincatethi ta istafe dhayssana; eranchata eratetha ta hada ooththana” geetetti Geeshsha Maxaafan xaafettides. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Cincay awan dizee? Tamarida eray awan dizee? Hayssa wodeza pilgi erizay awan dizee? Xoossi ha alameza erateth, eeyateth ooththibenee? ");
INSERT INTO gmvRNT_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Xoossa eratethafe dendidayssan alamey ba eratetha gaason Xoossa eroy xoonin sabako eeyateththan ammanizayta ashshanas Xoossa shene gidides. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Ay wodekka Ayhudati dumma malata koyettes. Girike asati qasse erateth koyettes; ");
INSERT INTO gmvRNT_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Nuni gidikko kaqettida Kirstoosa sabakoos. Hessika Ayhudatas dhuphe; Ayzaabetas qasse eeyateththa. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Xoossi xeygidaytas isti Ayhudata gidin woykko Girike dere asa gidikkoka Kirstoosi Xoossa wolqanne Xoossa eratetha. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Gaasoyka asa erappe Xoossa eeyateththi aadhdhida eratetha; asa minotethafe Xoossa laafatethi aadhdhees; ");
INSERT INTO gmvRNT_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Ta ishato! Kase inte xeeygetiza wode inte ay mala asakkonne ane qoppite. Asa qofa mala gidikko intefe darizayti erata gidekketa. Intefe daroti wolqay bayndayta; darotikka gita keeththa asappe yeletibekketa. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Gido attin Xoossi erata yeelachanas deraappe eeyata doorides; Xoossi minota yeelachanas alamezappe daburanchata doorides. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Xoossi hanko ammanonta asa achchan deettes geetetti erettiza miishata baynda miisha mala ooththana hayssa alamezan leqettidaytanne kawuyidayta laafata doorides. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Hessakka izi ooththiday oonikka iza sinthan ceeqqettonta mala. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Intena qasse Xoossi Yesus Kirstoosara issifetethi daana mala ooththides. Hessa gish Xoossi Yesus Kirstoosa nu erateth, nu xilloteth, nu geeshshatethinne nuna ashshizade gidana mala ooththides. ");
INSERT INTO gmvRNT_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Hessa gish kase “Ceeqqiza asi Godan ceeqo” geetetti Geeshsha Maxaafan xaafettida mala. ");
INSERT INTO gmvRNT_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Ta ishato! Ta inteko Xoossa xuura qoncisana biday taas duuna qaratethi woykko era daroy diza gish gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Ta inte giddon diza wode kaqettida Yesus Kirstoosappe attin hara eronta mala ta baggara murtadis. ");
INSERT INTO gmvRNT_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Ta inteko daro daaburan, yashshatethaninne daro kokkorashe badis. ");
INSERT INTO gmvRNT_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Ta qaalaynne sabakoykka Ayana wolqa qoncisethanppe attin cimoninne era daron gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Hessika inte ammanoy Xoossa wolqanppe attin asa cincateththa bolla xaphonta mala hanides. ");
INSERT INTO gmvRNT_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Nu kaha kunthida asata achchan era haasaya hasayos; gido attin hayssa ha alameza erateth gidenna; woykko dhayana diza ha alameza haarizayta erateth gidenna. ");
INSERT INTO gmvRNT_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Gido attin nu haasayizay kase qoteti diza Xoossa xuura eratetha; he eratethay Xoossi daro wodeppe kase nuna bonchos kasetidi wursi woththidayssa. ");
INSERT INTO gmvRNT_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Ha alameza haarizaytappe oonikka ha eratetha eribenna; eridako isti boncho Goda kaqettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Gido attin Geeshsha Maxaafan “Asa ayfey beyontaz, asa haythi siyontaz, asa woznaykka qoppontaz Xoossi ba dosizaytas giigissides” gees. ");
INSERT INTO gmvRNT_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Xoossi gidikko hessa ba Ayana baggara nuus qoncisides. Ayanaykka Xoossas diza ciimma yo7o ashshonta wursi pilgi xeelles. ");
INSERT INTO gmvRNT_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Asa garsan izaades diza ayanappe attin izaade wozna erizay oonee? Hessathoka Xoossa Ayanappe attin Xoossa qofa erizay oonikka deenna. ");
INSERT INTO gmvRNT_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Xoossafe nuus imettidayssa nuni erana mala Xoossa Ayanay nuus imettides attin nuni hayssa ha alameza ayana ekibeekko. ");
INSERT INTO gmvRNT_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Nu yootizay hayssa; nu asappe tamarida qaala gidonta Ayanappe tamarida qaala hasayos. Ayana tumatethakka nu qoncisizay Ayana qaalanna. ");
INSERT INTO gmvRNT_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Xoossa Ayanay izan baynda asi Xoossa Ayanappe gididaz ekkanas dandayenna; Gaasoyka hessa mala yo7oy izas eeyateththa; izi baasi Ayanan paacetizade gidida gish izi eranas dandayenna. ");
INSERT INTO gmvRNT_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Xoossa Ayanay izan dizadey qas wursikka paaces attin baasi oonanka paacettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Hessika “Goda qofa eranas dandayizay oonee? Iza zoranas dandayizay oonee?” geetetti kase Geeshsha Maxaafan xaafettida mala; nuus gidikko Kirstoosa woznay dees. ");
INSERT INTO gmvRNT_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Ta ishato! Ta intena inte Kirstoosan buro guutha nayta malanne buro ammanoy gelonta asa malappe attin Ayanan kumida asa mala gaada intes haasayanas dandayabekke. ");
INSERT INTO gmvRNT_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Inte buro minnonta gish ta intena maath paahadis attin buro mino kath mizabekke; ha7ikka gidikko inte burokko! ");
INSERT INTO gmvRNT_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Inte ha7ikka buro ammanon minnontayta gidida gish inte giddon qanatetethinne palamay dees; histin inte buro ammanon minnonta asa mala gidekketii? Inte oosoy coo mela asi ooththizayssa mala gidenee? ");
INSERT INTO gmvRNT_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Gaasoyka inte garsafe issoy “Ta Phawuloosassa” hankoys qas “Ta Aphiloosassa” giikko inte coo asho qofan xalala diza asa mala gidekketii? ");
INSERT INTO gmvRNT_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Ero! Gido attin Aphiloossi aazee? Phawuloosikka aazee? Isti Goday istas issas issas immida mala ooththiza ooththanchata; inteka ista baggara ammanideta. ");
INSERT INTO gmvRNT_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Ta tokkadis; Aphiloossi haaththe ushshides; dichchiday gidikko Xoossa. ");
INSERT INTO gmvRNT_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Hessa gish dichchizay Xoosse attin tokkizadeykka, haaththe ushshizadeykka aykkokka gidettenna. ");
INSERT INTO gmvRNT_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Tokkizade gidin woykko ushshizade gidin isti issino; istafe issadey issadey ba ooso mala woyto ekkana. ");
INSERT INTO gmvRNT_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Gaasoyka nu Xoossara issife ooththizayta. Inteka Xoossa goshsha gadenne Xoossa Keeththata. ");
INSERT INTO gmvRNT_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Xoossafe taas imettida imotetha gina Keeththe keexxiza hiilla mala keeththay eqqanas lo7etha giigissadis; iza bolla hara asi keeththa keexana. Gido attin keeththa keexxizadey wosti keexanakone naagetanas bessees. ");
INSERT INTO gmvRNT_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Gaasoyka keeththay keexeteth oyketidappe guye hara woththi qasse keexana dandayizadey oonikka baawa; hessikka keeththas koyroy Yesus Kirstoosa. ");
INSERT INTO gmvRNT_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Oonikka keeththay koyro keexettidayssa bolla worqan woykko biran bonchettida shuchchan woykko mithaninne maatan woykko maqan keexxikko, ");
INSERT INTO gmvRNT_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","izaade oosoy ay mala pirda gallas qoncana. Gaasoyka he gallassay iza ha poo7oy dizaso kessana. He oosoy taman paacettana gish issade issade oosoy ay mala buro taman paacettana. ");
INSERT INTO gmvRNT_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Oonikka keexxida keeththi minni eqqiza gidikko hessadey ba woyto ekkana. ");
INSERT INTO gmvRNT_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Iza oosoy xuugetidadey gidikko woytoy izas deenna shin izaadey ba hu7es attana. Gido attin izaade atethi tamappe asi waaydi attiza atetha mala gidana. ");
INSERT INTO gmvRNT_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Inte inte hu7es Xoossa Keeththe gididayssanne Xoossa Ayanay inte giddon dizayssa ereketii? ");
INSERT INTO gmvRNT_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Oonikka Xoossa Keeththe laallikko Xoossi izaade laallana. Xoossa Keeththi geeshsha. Hessika intenakko! ");
INSERT INTO gmvRNT_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Oonikka barka bana baleththofo; intefe oonikka hayssa ha alamezan bana erancha mala qoppikko izaadey erancha gidana mala bana barka eeya mala qoodo. ");
INSERT INTO gmvRNT_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Hayssa ha dereza eratethi Xoossa achchan eeyateththa. Kase Geeshsha Maxaafan “Izi eranchata ista gene ooso geedon zaaridi oykkana” geetetti xaafettides. ");
INSERT INTO gmvRNT_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Qasseka harason “Eranchata qofay mela hada gididayssa Goday erees” geetetti xaafettides. ");
INSERT INTO gmvRNT_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Hessa gish wurikka intes gidida gish oonikka asan ceeqqettofo. ");
INSERT INTO gmvRNT_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Phawuloosa gidin, Aphlossa gidin, woykko Keefa gidin, alame gidin, de7o gidin, woykko hayqo gidin, ha7i dizaz gidin, woykko buro yaana miish gidin, wurikka intessa. ");
INSERT INTO gmvRNT_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Inteka Kirstoosayta; Kirstoosikka Xoossayssa. ");
INSERT INTO gmvRNT_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Hessa gidida gish asi wurikka nuna Kirstoosa oosanchata malanne Xoossa xuura qoncisanas hadara ekkida asa mala qoodanas bessees. ");
INSERT INTO gmvRNT_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Hadara ekidaytika ammanettidayta gidanas bessees. ");
INSERT INTO gmvRNT_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Ta bolla inte pirdinka woykko duulata asay pirdinka ta baggara taas aykkoy baawa. Haray attoshin tarka ta bolla pirdikke. ");
INSERT INTO gmvRNT_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","“Ta eriza mala tani ta woznara sidhiza miishi baawa; gido attin hessa guus ta bolla mooroy baawa” guus gidenna. Buro ta bolla pirdanay Goda. ");
INSERT INTO gmvRNT_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Hessa gish pirdana wodey gakkonta haara ay yo7okka pirdofte. Goday yaana gakkanaas naagite; izi dhuma giddon qotetidayssa buro qonce kessana. Asa wozna giddon diza qofakka qonce kessana. He wode issi issi asi baasi bessiza galata Xoossa achchafe ekkana. ");
INSERT INTO gmvRNT_vpl VALUES ("C14_6","076_4_6