﻿USE sofia;
DROP TABLE IF EXISTS sofia.glwl_vpl;
CREATE TABLE glwl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES glwl_vpl WRITE;
INSERT INTO glwl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kakaɗ tǝghǝr kǝ hulfa Yesu Kǝristi, zǝra Dauda kwa ghǝravaan ndakwani zǝra Ibrahim. ");
INSERT INTO glwl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahim wa yaa Ishaku, ya nǝ Ishaku kǝ Yakuba, ya nǝ Yakub kǝ Yahuda ard zaraabahaana. ");
INSERT INTO glwl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ya nǝ Yahuda kǝ Ferez ard Zera. Babbaatǝr Tamara. Ya nǝ Ferez kǝ Hezron, ya nǝ Hezron kǝ Aram, ");
INSERT INTO glwl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ya nǝ Aram kǝ Amminadab, ya nǝ Amminadab kǝ Nashon, ya nǝ Nashon kǝ Salmon. ");
INSERT INTO glwl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ya nǝ Salmon kǝ Bowaz, ɗaaga babbaan Rahab. Ya nǝ Bowaz kǝ Obed, ɗaaga babbaan Rut. Ya nǝ Obed kǝ Yesse, ");
INSERT INTO glwl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ya nǝ Yesse kǝ Tlǝkes Dauda. Ya nǝ Dauda kǝ Saluman, ɗaaga babbaan Betshaba, kwandza uusa Uri wura. ");
INSERT INTO glwl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ya nǝ Saluman kǝ Rehobowam, ya nǝ Rehobowam kǝ Abija, ya nǝ Abija kǝ Asa, ");
INSERT INTO glwl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ya nǝ Asa kǝ Yehoshafat, ya nǝ Yehoshafat kǝ Yoram, ya nǝ Yoram kǝ Uzziya, ");
INSERT INTO glwl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ya nǝ Uzziya kǝ Yotam, ya nǝ Yotam kǝ Ahaz, ya nǝ Ahaz kǝ Hezekaya, ");
INSERT INTO glwl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ya nǝ Hezekaya kǝ Manasse, ya nǝ Manasse kǝ Aman, ya nǝ Aman kǝ Yosiya, ");
INSERT INTO glwl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ya nǝ Yosiya kǝ Yekoniya ard zaraabahaan sartakwa hutsavtǝra nǝ uudah damma Babila kiyava ɛɛva. ");
INSERT INTO glwl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tǝhalakwa lanngavtǝrda nǝ iitǝr damma Babila, kaa yigayig nǝ Yekoniya kǝ Shayeltiyel, ya nǝ Shayeltiyel kǝ Zerubbabela, ");
INSERT INTO glwl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ya nǝ Zerubbabel kǝ Abihud, ya nǝ Abihud kǝ Eliyakim, ya nǝ Eliyakim kǝ Azor, ");
INSERT INTO glwl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ya nǝ Azor kǝ Zadok, ya nǝ Zadok kǝ Akim, ya nǝ Akim kǝ Eliyud, ");
INSERT INTO glwl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ya nǝ Eliyud kǝ Eliyazar, ya nǝ Eliyazar kǝ Mattan, ya nǝ Mattan kǝ Yakub, ");
INSERT INTO glwl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ya nǝ Yakub kǝ Isuvu zhiila Maryam, Maryam wa yaayig kǝ Yesu kwa ɗahav dǝ Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Baɗǝm nǝ hulfaatǝr ciigǝt tǝ Ibrahim dat Dauda, hulf kǝlawa tar uufaɗa, ciigǝt tǝ Dauda damma sarta kwa hutsavtǝra nǝ yaa Izraˈila damma Babila kiyava ɛɛva, hulf kǝlawa tar uufaɗa, ciigǝt ma sarta ɛɛvǝr ma Babila da tǝ sarta yiga Kǝristi, hulf kǝlaawa tar uufaɗa. ");
INSERT INTO glwl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Wan nǝ ɗuuli yava nǝ Yesu Kǝristi. Ma sartǝn ndza ɓǝlghara nǝ Isuvu kǝ dzǝgwambǝr kǝ Maryam babba Yesu. Lakuti kǝsgaan kiyava uusa, kaa dlǝghǝgadlǝghǝg kǝ iin kǝ huɗ tǝdvad Shǝɗǝkwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nahabi nǝ Isuvu jambuwaan kǝ tsǝgar zhǝru mataataka uudah biya, aɗaba uuda jiirjiir nǝ iina. Kaa ɓaa dabariya tagwav kǝ iin dǝ vakaiy ma ɗyamɗyamǝra. ");
INSERT INTO glwl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Masartǝn ba ndzǝgaan nǝ iin ba dzamaghǝra, kaa tlǝgaraatlǝg zǝrɓǝlga Yaazhigǝl ma sǝnnga, aiyama taa kǝ iina, “Isuvu zǝra Dauda, gǝdzbi kǝ kǝssa Maryam kiyava uusagh biya, aɗaba huɗɗǝn dǝvakai nǝ iinna dǝga Shiɗkwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Da yigaan kǝ zǝra, agha da farva kǝ ɗaag Yesu, aɗaba iin wada katta uudahaan sagal ma haipahaatǝra.” ");
INSERT INTO glwl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Dzǝghardzǝg wanahaan baɗǝm mbakyarvad righǝvant nǝ dǝgiti tagada nǝ Yaazhigǝl tǝdvad tlayang taakiya, ");
INSERT INTO glwl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Pakwara dǝghwa da dlǝghgaan kǝ huuɗa, da ya kǝ zǝra, da fǝvarva ɗaag Immanuela.” Dǝgiti tuuk vakai nǝ Immanuela, “Daadamazhigǝl ǝmtaɗ dǝ kǝmiyamma.” ");
INSERT INTO glwl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ciyit ba nǝ Isuvu ma haara, kaa gatǝgaan kǝ iin kǝ dǝgiti taga nǝ zǝrbǝlga Yaazhigǝla. Kaa kǝsguukǝsǝg nǝ Isuvu kǝ Maryam nal kǝ uusaana. ");
INSERT INTO glwl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Farabi kǝ dzaghǝr biya, bamma tǝhala kwa yaa nǝ iin kǝ zǝraana, farva kǝ iin kǝ ɗaag Yesu. ");
INSERT INTO glwl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tǝhalakwa yava nǝ Yesu ma kǝssa Bitalahami ma larda Yahudiya ma zamana Tlǝkǝs Hirudus, kaa sagat kǝ lii sǝrgasǝrǝg kǝ dǝgit tǝghǝr kwadladl dagat damma Wurshalima. ");
INSERT INTO glwl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Kaa ndavǝg kǝ iitǝr taakiya, “Mǝr nǝ tlǝksa Yahudahǝn kwa yavan ni? Aɗaba kǝmnda nǝghǝga kwadladlaan sagat dǝ sǝga, iin wa kǝmaa sagau nǝmnd sa ɓagarnǝs kwatnahǝra.” ");
INSERT INTO glwl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Cinngha ba nǝ Tlǝkǝs Hirudus ǝndkwana, kaa ba uushig kǝ ghǝrana, baz uudaha Wurshaliim baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kaa dzahgantdzahǝg kǝ iin kǝ maalmaalah ma zhiila kǝsuufah ard lii tsaga adzahadzaha Muusa, ndavtǝru kǝ iin kǝ vakavaki da yaav dǝ Kǝristina. ");
INSERT INTO glwl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Am nǝ iitǝr taa kǝ iina, “Ma kǝsa Bitalahamiya, malarda Yahudiya. Aɗaba vinda bandkwah nǝ tlayanng taakiya, ");
INSERT INTO glwl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Kǝgh Bitalahami ma larda Yahud ndakwani, agha ǝnkykwah bi nǝng ma lii kwara Yahud biya. Aɗaba da sagal ma kǝgh nǝ dadda kwarga, kwada piya uudahar Izraila.’ ” ");
INSERT INTO glwl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kaa ɗahtǝrǝtɗahǝg kǝ Hirudus kǝ lii sǝrgasǝrg kǝ dǝgitǝn damma dlǝmmbaava, kaa nǝghǝgaakanǝghǝg kǝ iin vakaatǝr kǝ kalkala sarti nǝghara nǝ iitǝr kǝ kwadladlǝna. ");
INSERT INTO glwl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kaa ɓǝltǝrǝtɓǝlǝg kǝ iin damma Baitalahami amaa, “Damdǝg ndan ndavamndavǝg bad hǝnkal kǝ vakavaki dǝ zǝriina, tǝhala kwama tlamaraatlǝga, am saas am tagǝwana, ghǝravar ndakwani ǝn dagal da ɓagarnǝs kwatnaha.” ");
INSERT INTO glwl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ghyǝngara ba nǝ iitǝr kǝ cinnga ǝlbǝga tlǝkǝsna, kaa dagalaatǝr kǝ iitǝra, dlaɓa ka dagal kǝ iitǝr gata kwadladlǝn nǝghara nǝ iitǝr tǝvuukwatǝra, tangw da vakavakǝn ghaca nǝ iin tǝghǝr kǝ zǝriina. ");
INSERT INTO glwl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nǝghara ba nǝ iitǝr kǝ kwadladlǝna, kaa hwaɗag kǝ iitǝr ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Daragha ba nǝ iitǝr damma hǝnyahiina, kaa nǝghǝganǝghǝg kǝ iitǝr kǝ zǝriina ard babbaan Maryam, ar kǝla kǝ ghunj tǝvuukwana ar ɓaganǝs kǝ kwatnaha. Tǝhalakwaha, ar palna kǝ kadlangngahaatǝr ar vǝlar kǝ adawana ard tǝrshan lubban ard mur. ");
INSERT INTO glwl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kaa gwiyaghǝra daas kǝ iitǝr damma kǝsaatǝr tǝ ɗuuli tlǝrna, aɗaba ɓǝlatǝraaɓǝlǝg nǝ Daadamazhigǝl kǝ magi ma sǝnng taakiya, aa gwiya darbi daa da vak Hirudus biya. ");
INSERT INTO glwl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Daral ba nǝ iitǝra, kaa tsǝgwatsug kǝ zǝrbǝlga Daadamazhigǝl vak Isuvu ma sǝnnga amaa, “Ciiga, kǝsantkǝsǝg kǝ zǝrna ard babbaana ǝmndǝramǝmndǝrǝg damma haaya Masara. Ndzamandzǝg vaakwaha, bamma tagankuratag lakuti am gwiyaghǝra saasa, aɗaba da gatǝgaan nǝ Hirudus kǝ zǝrǝn kiyava tsǝgaana.” ");
INSERT INTO glwl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kaa ciig kǝ Isuvu kavǝɗa, kǝsant kǝ zǝrna ard babbaana, kaa dagal kǝ iin damma haaya Masara. ");
INSERT INTO glwl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ndza kǝ iin vaakwaha tangwa damma sarta kwa ǝmtsa nǝ Hirudusa. Kwana dzǝghaar mbakyarvad righǝvant nǝ dǝgiti tagada nǝ Yaazhigǝl tǝdvad tlayanng taakiya, “Ɗahanant saa ma Masar kǝ zǝrara.” ");
INSERT INTO glwl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nǝghaaka ba nǝ Hirudus taakiya, ɗyamɗyamǝr wa marararda lii sǝrga dǝgitna, kaa badza ǝrviɗmahuɗ kǝ iin ba vaivaiya. Kaa ba ɓǝlgantɓǝlg kǝ iin kǝ uudah da ciɓa zaraa ghwalvaha kwama Bitalahami baɗǝmma ard kǝsahaanǝn hǝrz dǝ iina, ciigǝt tǝ zǝr vuunj dat zǝra hǝi buwa, kalkal dǝ sartǝn tagarar nǝ lii sǝrgasǝrgǝn kǝ ǝlbǝg tǝghǝr kǝ zǝriina. ");
INSERT INTO glwl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ma sarta kwahiin wa righavant nǝ dǝgiti tagavda tǝdvad tlayang Irmi taakiya, ");
INSERT INTO glwl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Cinngavacinng nǝ huulǝg ma Rama, huulǝga badzǝga ǝrviɗmahuɗ ba vaivaiya, kats Rahil wa tuug mbakyarvad zarhaana, lawalǝg baz fa ǝrviɗya aɗaba zarhaani ǝmtsaharaǝmtsahǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tǝhala ǝmtsǝga Hirudusa, kaa tsugwatsug kǝ zǝrɓǝlga Yaazhigǝl vak Isuvu ma sǝnng ma Masara, ");
INSERT INTO glwl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","amaa, “Ciiga kǝsantkǝsant kǝ zǝrna ard babbaana, gwig da damma haaya Izraila, adaba lii gata tsa shifǝga zǝrna, ǝmtsaharaǝmtsahǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kaa ba ciig kǝ iin kǝsant kǝ zǝrna ard babbaana, kaa daas kǝ iin damma Izraila. ");
INSERT INTO glwl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Cinngha ba nǝ iin taakiya Arkilayus zǝra Hirudus guyugwig kǝ daddaana, kwara larda Yahuda, kaa gǝdzǝg kǝ gwuya daas da vaakwaha. Bǝlavara ba nǝ magi ma sǝnnga, kaa kyǝha daas kǝ iin damma Galili. ");
INSERT INTO glwl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kaa dagal kǝ iin ndza ma kǝsiin kwa ɗahav dǝ Nazarata. Righavant ǝndkwan nǝ dǝgiti tagara nǝ tlayangah taakiya, “Da ɗahav dǝ uuda Nazarata.” ");
INSERT INTO glwl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ma hǝnngahaatsa, sǝghalsǝg nǝ Yuhwan dadda tsuufǝg da taa ǝlbǝg maraw ma tǝghala ma larda Galili, ");
INSERT INTO glwl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","taakiya, “Pǝlampǝlǝg kǝ ghǝra aɗaba tlǝksǝra Daadamazhigǝl ba hǝrza.” ");
INSERT INTO glwl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kwan wa ndza taga nǝ tlayang Ishay kǝ ǝlbǝg tǝghǝrǝna, taakiya, “Mǝng nǝ uud ɗaag ma tǝghala, amaa, ‘Ɓadlamarnaɓadlǝg kǝ ɗuul kǝ Yaazhigǝla, am ɓadlarna kǝ ɗuulaan ba ndǝɗɗa.’ ” ");
INSERT INTO glwl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Sǝɗavi tsǝguv nǝ Yuhwan ɓagava dǝ guja adlugwama, dǝga ndzǝɗa huɗaana ɓagava dǝ hǝluwa. Dǝgzǝgaana ndza ayayuwa ard yuwa mamma. ");
INSERT INTO glwl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kaa ba sagau kǝ uudaha Wurshslim ard uudaha larda Yahudiya baɗǝmma, baz lii ma lardǝn dǝ Zaagha Judan da vakaana. ");
INSERT INTO glwl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kaa tagaan kǝ iitǝr kǝ haipahaatǝra, ɓagtǝra kǝ iin kǝ tsuufǝg ma Zaagha Judan. ");
INSERT INTO glwl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nǝgha ba nǝ iin kǝ Farisah ard Sadukiyah ba ɗyak da vakaan kiyava ɓagtǝr tsuufǝga, kaa amaa taa kǝ iitǝra, “Kuram faɗǝga ghavalahaan dǝ gurna! Warwaa ghudkura harɗa ngǝdlgarwa kǝ dlaɗa Daadamazhigǝlǝn sagauni? ");
INSERT INTO glwl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ɓagamɓag kǝ dǝgitahi da mardamarg taaki pǝlamapǝlǝg kǝ ghǝra. ");
INSERT INTO glwl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tsam bi kǝ kusǝgh taakiya, ‘Ibrahim nǝ daadamnd biya.’ Ən tagkurtaga, virɗigaravirɗig nǝ Daadamazhigǝl kǝ zarh kǝ Ibrahim dǝ kwanahaan kǝ akuraha. ");
INSERT INTO glwl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bavǝtbǝg nǝ hiil tǝ suuha uufa, badǝm nǝ uufi lawalǝg kǝ yazǝr marawa, ghudvars ɓǝlǝvdǝm damma kaara. ");
INSERT INTO glwl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ən ɓagkur dǝ yu nai kǝ tsuufǝg kiyava mara taaki pǝlamapǝlǝg kǝ ghǝra, mǝng nǝ dadda kwa jakwaraajig dǝ ndanngǝr da sagau tǝ halara, tlanalbi nai aanji kǝ kǝssa kimbakaan biya. Da ɓagkur dǝ Shǝɗkwa Daadamazhigǝla, ard kaar nǝ iin kǝ tsuufǝga. ");
INSERT INTO glwl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kuwa bǝgaan bamma dǝvaana, da bǝggrzha kǝ hǝiyaana, da hutsǝdaan kǝ hǝiyaan damma kuvǝraana, da haars kǝ kaar kǝ hyahya dǝ kaari maay ǝmtsǝg biya.” ");
INSERT INTO glwl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sagha ma kwahiin kǝ sart nǝ Yesu saama Galili, kaa dagal kǝ iin damma zaagha Wurdǝn kwakyarvad ɓagara nǝ Yuhwan kǝ tsuufǝga. ");
INSERT INTO glwl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Naha tsǝharvatsǝg nǝ Yuhwana, amaa taa kǝ iina, “Kai ndakwi mana naa magha ɓagwi nǝng kǝ tsuufǝga, agha sagau ndar dlaɓ nǝng sa vakari?” ");
INSERT INTO glwl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ngugharangu nǝ Yesu amaa, “Aandz bandkwah ndakwana, aɗaba kalkalaan righvant nǝ dǝgiti naag nǝ Daadamazhigǝla.” Kaa haigaranthaig kǝ Yuhwana. ");
INSERT INTO glwl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tǝhalakwa ɓagavara nǝ tsuufǝg kǝ Yesu, bad sagalaan ma yuwa, kaa wurgǝtwurg kǝ ghǝrazhigǝla, dlaɓa kaa nǝghǝganǝghǝg kǝ Shiɗǝkwa Daadamazhigǝl saay da tǝghǝr kǝ iin band garava kakura. ");
INSERT INTO glwl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kaa cinngvacinnga nǝ ghai sii ma ghǝrazhigǝl taakiya, “Kwana iin nǝ zǝrara, ǝn waigaana dlaɓa ǝn cinngaan kǝ ǝmtakǝraan ba vaivaiya.” ");
INSERT INTO glwl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ngal langaan nǝ Shiɗǝkwa Daadamazhigǝl kǝ Yesu damma tǝghala, kiyava fǝshgaan kǝ Shatanaha. ");
INSERT INTO glwl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tǝhala kǝsgaana Yesu kǝ adǝla hǝng kwul uufaɗ ard vang kwul uufaɗa. Tǝhalakwaha kaa njǝkǝnjiig kǝ waiya. ");
INSERT INTO glwl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kaa sagau kǝ Shatanaha, amaa taa kǝ iina, “Magha ba zǝra Daadamazhigǝla, nǝdalnǝg ci kǝ akurǝn kǝ bruudiya.” ");
INSERT INTO glwl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kaa ngwangug nǝ Yesu amaa, “Vindavavindǝg ma kakaɗ Daadamazhigǝl taakiya, “ ‘Dǝgzǝg kalti bi wa hǝkya shifǝga uudbiya, bamma ǝlbǝgahi sagal vak Daadamazhigǝl baɗǝmma.’ ” ");
INSERT INTO glwl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kaa lanngaan kǝ Shatanah kǝ Yesu damma Wurshalima kǝss ɗyak caccuwanacaccuwana. Ngal lanngdit dat ghǝra vǝgya Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Aiyama taa kǝ iina, “Magha ba zǝra Daadamazhigǝla, dzǝvǝg ndan daaya. Aɗaba vindavavindǝg taakiya, “‘Da tagarta nǝ Daadamazhigǝl kǝ zǝrɓǝlgahaan, ar da tsǝkǝs kǝ dǝv haik kǝ tsǝgaan kǝ shigahagh tǝ akura.’ ” ");
INSERT INTO glwl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ngugharangug nǝ Yesu, taa kǝ iina, “Vindavavindǝg dlaɓ taakiya, ‘Fǝsh bi kǝ Yaazhigǝl Daadamazhigǝlagh biya.’ ” ");
INSERT INTO glwl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ngal gwiya lanngaan nǝ Shatanah damma ghǝra aghw ba kyakkwa, kaa margardmarg kǝ iin kǝ tlǝksǝraha duni ard ndangǝrahaatǝr baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Aiyam nǝ shatanah taa kǝ iina, “Ən vǝlakvǝlǝg kǝ kwanahaan baɗǝmma akwama kǝlghakǝlǝg kǝ ghwunj tǝvuukwara, agha ɓagwǝs kǝ kwatnahǝra.” ");
INSERT INTO glwl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ngugharangug nǝ Yesu amaa, “Yagh vaakwan Shatanaha, aɗaba vindavavindǝg taakiya, “ ‘Ɓagarɓag kǝ kwatnahǝr kǝ Yaazhigǝl Daadamazhigǝlagha, ba iin pall wagha da ɓagarnǝs nǝng kǝ kwatnahǝra.’ ” ");
INSERT INTO glwl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kaa dagalaan kǝ Shatanaha, kaa sagau kǝ zarabǝlga ar mǝlaruwa. ");
INSERT INTO glwl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Cinngha ba nǝ Yesu taaki viyavǝtviig nǝ Yuhwana, ngal dagal kǝ iin damma Galili. ");
INSERT INTO glwl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ɗuwars kǝ iin kǝ Nazarat kaa dagal da ndzǝga ma Kafarnahum, kwandza tǝvǝgh kǝ yuwahaiya, tǝ ghaala dǝ larda Zebulun ard Naftali. ");
INSERT INTO glwl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tǝdvadkwan kǝ ɗuul wa righǝvant nǝ dǝgiti tagada nǝ tlayang Ishai taakiya, ");
INSERT INTO glwl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Larda Zebulun ard larda Naftali ma Galili, larda lii ar Yahudah biya. Lardǝn hǝrz dǝ yuwahayin tangw damma gyilga zaagha Wurduna. ");
INSERT INTO glwl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Uudahi ar ndzǝgama gurtla nǝgharanǝghǝg kǝ parakrakǝr ba vaivaiya, lii ndzǝga ma shiɗkwa ǝmtsǝg dlaɓa, sǝghawisǝg nǝ parak da tǝghǝr kǝ iitǝra.” ");
INSERT INTO glwl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ciigǝt tǝ kwahiin kǝ sart wa fǝgharzha nǝ Yesu kǝ taa ǝlbǝg maraw taakiya, “Pǝlampǝlǝg kǝ ghǝra aɗaba tlǝkǝsǝra ghǝrazhigǝl ba hǝrza.” ");
INSERT INTO glwl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tǝ ɗuula dagal nǝ Yesu tǝvǝgh kǝ Yuwahaiya Galili, kaa nǝghǝganǝghǝg kǝ iin kǝ zarha baabah buwa, Siman kwa ɗahav dǝ Bitrusa, ard zǝra babbaan Andrawusa, ar ɓǝla amshiya vaiya kilfatǝr ma yuwahaiya, aɗaba ar lii vaiya kilf nǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Am Yesu taa kǝ iitǝra, “Gatamkwagatǝga, ǝnda nǝkurdalnǝg kǝ lii vaiya uudah da vakara.” ");
INSERT INTO glwl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Batwatsǝra ar ɗuwars kǝ dǝgaha vaiya kilfaatǝra, kaa gata Yesu kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tǝghǝrdǝga dagala, kaa gwuya nǝghǝganǝghǝg kǝ iin kǝ zarha baabah buwa, Yakuba ard zǝra babbaan Yuhwana zarha Zabadi. Ar ma pɛrayu ǝmtaɗ dǝ daddaatǝr Zabadi, ar ɓadla amshiya vaiya kilfatǝra, kaa ɗahtǝrǝt kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Batwatsǝra kaa ɗuugarsɗuug kǝ iitǝr kǝ pɛrayuwaatǝr ard daddaatǝra, kaa gata Yesu kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Gwaivagwaig nǝ Yesu ma Galili baɗǝmma, tsagtǝr dǝgit ma guda dzugwazhigǝla, dlaɓa taa ǝlbǝg marawa tlǝkǝsǝra Daadamazhigǝla, mbahǝgaan dlaɓ aanji hulfa kwar kǝ kuzaha, ard lii yang biya. ");
INSERT INTO glwl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Cinngalcinng nǝ ǝlbǝg tǝghǝr kǝ iin baɗǝmma ma haaya Suuriya. Kaa ba lanngaan kǝ uudah kǝ lii dǝ kuzah baɗǝmma, ard lii yangbiyah shahshaha, ard lii hǝɓa dlaɗa, ard makwayaha, ard lii ciɓǝg nǝ Shatanah baz lii ǝmtsamtsan nǝ vǝgh mbahavtǝrambahǝg baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kaa gatǝgaan kǝ dzahava uudah ba ɗyaka ma Galili, dlaɓa ard lii ma larda Dikafulis ard Wurshalima, ard lii ma larda Yahudiya baz lii gyilga zaagha Wurdǝna. ");
INSERT INTO glwl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nǝghgha ba nǝ Yesu kǝ dzahava uudah baɗyaka, kaa dagat kǝ iin damma ghwaa, cǝhura kǝ iina. Kaa ba dagau kǝ mbǝrzahaan da vakaana. ");
INSERT INTO glwl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ngal farzha kǝ iin tsagtǝr dǝgita. ");
INSERT INTO glwl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ar dǝ bark nǝ lii sǝrgasǝrg kǝ hǝtsǝgalhǝtsǝgaatǝr ma gata Daadamazhigǝla, aɗaba tlǝksǝra ghǝrazhigǝl dǝgaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ar dǝ bark nǝ lii dǝ badzǝga rǝviɗmahuuɗa, aɗaba da tagǝvtǝrtag nǝ dzǝgwagha. ");
INSERT INTO glwl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ar dǝ bark kanadiyaha, aɗaba ar da gwigaan kǝ duniya. ");
INSERT INTO glwl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ar dǝ bark nǝ lii kǝma ɓa dǝgiti naag Daadamazhigǝla, aɗaba ar da baghǝga. ");
INSERT INTO glwl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ar dǝ bark nǝ lii mara zhuwadaala, aɗaba da marvǝtǝrmarǝg nǝ zhuwadaala. ");
INSERT INTO glwl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ar dǝ bark nǝ lii caɗaɗ nǝ ǝrviɗmahuda, aɗaba ar da nǝghǝganǝhǝg kǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ar dǝ bark nǝ lii fa gabǝra, aɗaba da ɗahvǝtǝrɗahǝg dǝ zarha Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ar dǝ bark nǝ lii hǝɓa dlaɗ kwakyarvad ɓa hɛrǝrra, aɗaɓa tlǝkǝsǝra ghǝrazhigǝla dǝgaatǝra.” ");
INSERT INTO glwl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Am dǝ bark nǝ uurama, akwama ar ɗaava kuram nǝ uudaha, ar vǝlkur kǝ dlaɗa, dlaɓa ar ɓagkura kǝ dǝga kǝlaadǝrah shahshah mbakyarvad kaiya. ");
INSERT INTO glwl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Dlayamdlaiga am hwaɗag ba vaivaiya, mbakyarvad am da tlǝkǝnatlǝg kǝ dǝgshigaru baɗyak ma ghǝrazhigǝla. Aɗaba vǝlartǝr bandkwah nǝ uudah kǝ dlaɗ kǝ tlayanngahi sarǝv lakuti kǝskurama. ");
INSERT INTO glwl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kuram nǝ iizha duniya. Akwama maadlai nashnash nǝ iizh biya, da gwiya gwivdaa ndar nǝ nashnashani? Maadlai tlǝraan biya, bamma ɗivda dagala, hapǝna nǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kuram parak duniya. Akwama favafǝg nǝ kǝs tǝ gavala shiɓvǝna biya. ");
INSERT INTO glwl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Maay mbiyav nǝ kaara jahuramba humbvara kǝghai biya, bamma hǝrtǝvǝt tǝ dǝga hǝrtǝgaan vakavaki da ba parakrak kǝ uudahi hǝnnyah baɗǝma. ");
INSERT INTO glwl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bandkwah dlaɓa, parakaruwa aandz ba pǝripǝri tǝvuukwa uudaha, kiyava nǝghǝganǝghǝg kǝ iitǝr kǝ dǝgitah marawi am ɓag nǝ uurama, ar da fǝgaarafǝg kǝ Daadaruwi ma ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Tlatlam bi taakiya sanhi mbakyarvad ǝn kalarwut kǝ Adzahadzah Musa ard tsaga tlayanngah nai biya, sanhi mbakyarvad ǝn righanta. ");
INSERT INTO glwl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ba jiirjiir wan tagkurtaga, lakuti ghyǝng nǝ zhigǝla ard haaya, maay nǝ dǝgit aanji ba hǝɗikǝn ma vindǝga Adzahadzaha Muus kwada nig biya, bamma righavantrighǝg baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mbakyarvad kwaha baɗǝm daddakwa kǝladakǝlǝg aanji ba pal ma adzahadzahahaan hǝɗikǝnna, tsagtǝru dlaɓ kǝ kǝla adzahadzahahaan kǝ uudaha, da ɗahav nǝ iin daddakwa ǝnkykwah ma tlǝkǝsǝra ghǝrazhigǝla. Baɗǝm nǝ daddakwa gatǝgaan kǝ adzahadzahiina, dlaɓa tsagartsag kǝ uudaha, da ɗahav nǝ iin dǝ uud maamal ma tlǝkǝsǝra ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ən tagkurtaga, akwama jamtǝruubi kǝ lii tsaga adzahadzaha Muus ard Farisah dǝ jiir biya, am dǝgaa bi damma tlǝkǝsǝra ghǝrazhigǝl biya. ");
INSERT INTO glwl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Cinngamacinng ndza tagavtǝrdatag kǝ daadijaharu taakiya, ‘Tsǝbi kǝ shifǝg biya, baɗǝm daddakwa tsǝga shifǝga, da tǝvartǝg nǝ shariya.’ ");
INSERT INTO glwl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Aiciya ǝn tagkurtaga, baɗǝm nǝ daddakwa nguɗa ǝrviɗmahuɗ dǝ zǝraabaana, da tǝvartǝg nǝ shariya. Daddakwa ɗahgarva zǝraabaan taakiya maay nǝ dǝgiti agha tuukvakai biya, da lanngav damma guda ta shariya, dlaɓa daddakwa ɗahgarva zǝraabaan dǝ dlaga, dlaiyaan ɓǝlǝvdǝm damma kaara faiya. ");
INSERT INTO glwl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Kwakyarvad kwaha, akwamagha ɗiya baiku tǝ bagadiya kyulǝga, kaa dzamnadzamǝg kǝskǝgh taakiya hǝkyakahǝkyig nǝ zǝraabagh ma ǝrviɗmahaɗaana, ");
INSERT INTO glwl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","faffǝg kǝ baikuwaghǝn tǝvuukwa bagadi ndana, dǝga agha ɓaga kǝ gabǝrǝr dǝ zǝraabagh bazǝngwa. Ka sagau kǝskǝgh da ɗiya baikuwagha. ");
INSERT INTO glwl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Akwama da ɗiya ghunjagh nǝ uudana, ɓag kǝ gabǝrǝr dǝ iin tǝ watswats tǝghǝrdǝg lakuti damma guda ta shari. Akwama maay ǝndkwah biya, da langaklang davak alkali, alkali dlaɓa da langaklang davak yaa dela, ar ɓǝlkadǝm ma guda bǝrfina. ");
INSERT INTO glwl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Bak jiira wan tagaktaga, lakuti sǝkadasǝg nǝ uud vaakwaha, bamma pǝlghapǝlǝg kǝ kwaɓi gatak nǝ uud baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Cinngamacinng ndza tagavdatag taakiya, ‘Ɓagam bi kǝ gwaragwar biya.’ ");
INSERT INTO glwl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Aiciya ǝn tagkurtag, baɗǝm nǝ daddakwa vazǝna dǝkhǝra, dlaɓa kaa kǝmgaan kǝ iina, ɓagaaɓag kǝ gwaragwar dǝ vakai ma ǝrviɗmahuɗaana. ");
INSERT INTO glwl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Akwama fǝkaa kǝ ɓa haip nǝ gyiya dǝvaakaffagha, tǝdatǝɗǝga agha ɓǝldana. Ngulǝm maay ba nǝ uuɓiya vǝghagh pal tǝghǝr kwada ɓǝlǝvdǝm nǝ vǝghagh baɗǝm damma kaara faiya. ");
INSERT INTO glwl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Akwama fǝkaa kǝ ɓa haip nǝ dǝvaakaffagha, ghwudaghudǝga agha ɓǝldana. Ngulǝm maay ba nǝ uuɓiya vǝghagh pal tǝghǝr kwada ɓǝlǝvdǝm nǝ vǝghagh baɗǝm damma kaara faiya. ");
INSERT INTO glwl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Tagavdatag dlaɓ taakiya, ‘Daddakwa tagwavatagw dǝ uusaana, barari ghudara kǝ kakaɗa tagwavǝgh dǝ iina.’ ");
INSERT INTO glwl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Aiciya dǝgiti ǝn tagkurnaiya in taakiya, akwama tagwavatagw nǝ uudan dǝ uusaan kwakyarvad haipa gwaragwar biya, fadǝmfǝg ma ɗuula ɓa gwaragwara. Baɗǝm daddakwa kǝsguukǝsǝga, ɓa ba gwaragwar dǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Gwaastaana, cinngamacing tagavtǝratag kǝ daadijaharu taakiya, ‘Kǝldabi kǝ lanngiyagh biya, bamma agha righant kǝ langiyi tǝghara nǝnng kǝ Yaazhigǝla.’ ");
INSERT INTO glwl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Aiciya dǝgiti ǝn tagkurnaiya in taakiya, zambi kǝ ngwaɗǝg ba linnglinng biya, aanji dǝ ghǝrazhigǝl biya aɗaba vaka ndzǝgana Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Zambi dlaɓ kǝ ngwaɗǝg dǝ haay biya, aɗaba vaka fa shiga Daadamazhigǝla, bi dǝ Wurshalima aɗaba iin nǝ kǝssa Tlǝkǝs ɗyaka. ");
INSERT INTO glwl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Zǝbi dlaɓ kǝ ngwaɗǝg dǝ ghǝragh biya aɗaba agha nǝdalbi kǝ guja ghǝragh aanji pall kǝ maɗukwa bi gyangw biya. ");
INSERT INTO glwl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Dǝgiti ɓagaaɓaga kǝ maraw kǝ taga iin taakiya, ‘Aana,’ bi ‘Əndkwah biya’, majuujig ma kwana, aasǝgal vak shatanaha. ");
INSERT INTO glwl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Cinngamacinng tagavdatag taakiya, ‘Gyiya dlakulva gyiya, tlǝrɗ dlaɓa dlakulva tlǝrɗa.’ ");
INSERT INTO glwl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Dǝgiti ǝn tagkur naiya, akwama naa ɓa dǝgit ghwaɗ nǝ uudan tǝ kǝgha, ɓagarbi kǝ uushav biya, ma ɓǝlakaɓǝlǝg nǝ uudan kǝ mahupeng tǝ uumǝla dǝvaakaffa, agha guyarant ghyaba kwah palla. ");
INSERT INTO glwl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Akwama ɗiyakaaɗiig nǝ uudan kǝ ghunnj kwakyarvad kǝskava kǝ angyuwagha, agha vǝlar baz amugdiyagha. ");
INSERT INTO glwl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Akwama fakaafǝg nǝ gwarǝɗ kǝ dagala mil palla, dǝgdagal ǝmtaɗ dǝ iin kǝ dǝga mil buwa. ");
INSERT INTO glwl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Akwama ghalaaghalǝg nǝ uudan kǝ dǝgit vakagha, agha vǝlara. Dlaɓa ma sǝghǝvsǝg nǝ uudan sa kǝla gǝmau vakagha, piyarda biya. ");
INSERT INTO glwl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Cinngamacinng tagavdatag taakiya, ‘Waig kǝ zǝraabagha, agha ɗuwant kǝ tlǝghumagha.’ ");
INSERT INTO glwl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Aiciya, ǝn tagkurtaga, wayamwaig kǝ tlǝghumaharuwa, dzǝgwamtǝrdzǝgw kǝ zhigǝl kǝ lii vǝlkur dlaɗa ");
INSERT INTO glwl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tǝdvad ɓakwan wam da nǝg nǝ uuram kǝ zarha Daadaru kwama ghǝrazhigǝla, kwa fǝgara kǝ faci kǝ ɓa parakrakǝr tǝghǝr kǝ yaa dadda jiira ard lii ɓa kǝlaadǝra, hyitǝrhyig dlaɓ kǝ yu kǝ yaa dadda jira ard yaa dadda kǝlaadǝra. ");
INSERT INTO glwl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Akwamam waiya ba lii waiya kuram nǝ uurama, auci nǝ dǝgshigi am da tlǝkǝna nǝ uurami? Aanji lii dzaha hadam ndakwi ar ɓagaan bandkwana. ");
INSERT INTO glwl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Akwamam tagtǝr bak zaraabaharu nǝ uuram kǝ uusa, auci gǝrgǝraru dǝ kyalma uudahi? Aanji kǝrdiyah ndakwi ar ɓagaan bandkwaha. ");
INSERT INTO glwl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mbakyarvad kwaha, namalnǝg kǝ yaa dadda jiira band Daadaru kwama ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Famfǝg kǝ hyǝmiya aa nal bi nǝ gata Daadamazhigǝlaru kǝ dǝga nǝgha gyi biya, aɗaba ma ɓagamaɓag ǝndkwaha, am da tlǝkna bi kǝ dǝgshigaru vak Daadaruwi kwama ghǝrazhigǝl biya. ");
INSERT INTO glwl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Mbakyarvad kwaha, akwamagha da vǝlgar dǝgit kǝ uuda, kutbi ma ghai bandkwa ɓag nǝ muniyah ma guda dzǝgwazhigǝl ard dǝ ɗuulah kiyava dlǝbǝvtǝrǝt biya, ba jiirjiira wan tagkurtaga, cauwaracaug kǝ dǝgshigaatǝr ba ma kwahiina. ");
INSERT INTO glwl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Akwma agha da mǝlgaru kǝ dadda kwa maay dǝ vakai biya, aa sǝrabi nǝ dǝvaa ghyaɓagh kǝ dǝgiti ɓag nǝ dǝvaa kafagh biya. ");
INSERT INTO glwl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Aɗaba dǝgaha jiirjiiri kwa ɓagha nǝnng shiɓashiɓana, nǝghǝganǝghǝg daadagh baɗǝm kǝ dǝgitah ɓagha nǝng shiɓashiɓana, da vǝlakvǝlǝg kǝ dǝgshǝgagha. ");
INSERT INTO glwl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Akwamam da dzǝgwazhigǝla, ɓagam bi ǝndkwa ɓag nǝ muniyah biya, aɗaba ar naaba dzǝgw vaka ghacgan kǝ zhigǝla ma guda dzǝgwazhigǝla ard barama ɗuula kiyava nǝghtǝrnǝghǝg kǝ uudaha. Ba jiir wan tagkurtaga, tlarkǝnatlǝg kǝ dǝgshigaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Akwamagha da dzǝgwazhigǝla, dǝg daadama gudagha, agha hǝdarduwa. Agha dzǝgwa kǝ zhigǝl kǝ Daadaghi kwa nǝghva biya, Daadaghi kwa nǝghǝganǝghǝg kǝ dǝgiti ɓagav shiɓashiɓana, da vǝlakvǝlǝg kǝ dǝgshigagha. ");
INSERT INTO glwl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Akwamam dzǝgwazhigǝla, gwayamars bi ǝnd lii sǝrgabi kǝ Daadamazhigǝl biya, aɗaba ar tlatla taaki ma dzǝgwaradzǝgw kǝ zhigǝl tlaɗɗa da cinngtǝrnuu ǝndkwah nǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ɓagam bi ǝnd dǝgaatǝr biya, Aɗaba sǝrgasǝrg nǝ Daadaru kǝ dǝgiti am naag nǝ uuram lakuti am ghalgaana. ");
INSERT INTO glwl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Dzǝgwamdzǝgw kǝ zhigǝl ǝndkwana. “ ‘Daadamnd kwama ghǝrazhigǝla, aa fǝvaarafǝg nǝ ɗaagagha, ");
INSERT INTO glwl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","tlǝksǝragha aasasǝga, dǝgiti agha naag nǝng aa ɓagvǝnaɓag ma duni bandkwa ɓagav ma ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Vǝlkǝmndvǝlǝg kǝ dǝgzǝg haniina dlaɓa ba kǝlahǝnga. ");
INSERT INTO glwl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ɓǝshkǝmndanaɓǝshig kǝ haipahamnda, bandkwa kǝm ɓǝshtǝr nǝmnd kǝ lii ɓagkǝmnd haipaha. ");
INSERT INTO glwl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Langkǝmnd bi da vaka fǝshig biya, katkǝmndkatǝg vak Shatanaha.’ ");
INSERT INTO glwl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Aɗaba ma ɓǝshamtǝrnaɓǝshig kǝ lii ɓagarkura haipa, Daadaruwi ma ghǝrazhigǝl ndakwi da ɓǝshkurnaɓǝshiga. ");
INSERT INTO glwl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Akwama ɓǝshamtǝrnaa bi kǝ haipahaatǝr kǝ uudah biya, da ɓǝshkurna bi dlaɓ nǝ Daadaru kǝ haipaharu biya. ");
INSERT INTO glwl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Akwamam da kǝsa andǝla, badzam bi kǝ huɗvǝgaru ǝnd kwa ɓag muniyah biya, ar badzǝda kǝ huɗvǝgaatǝr kiyav sǝrvan taakiya ar kǝsa andǝla, bak jiirjiira wan tagkur naiya, tlarkǝnatlǝg kǝ dǝgshigahaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Akwamagha kǝsa andǝla, agha barda kǝ huɗvǝgagha, agha massa kǝ wal tǝ ghǝragha, ");
INSERT INTO glwl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","aɗaba aa nǝghvaakai taakiya agha kǝsa andǝl biya. Daadaghi kwa nǝghǝva biya, dlaɓa kwa nǝghǝganǝghǝg kǝ dǝgǝti ɓagav shiɓashiɓana, da vǝlakvǝlǝg kǝ dǝgshigagha. ");
INSERT INTO glwl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Dzahamar bi kǝ alman kǝ ghǝraru ma duni biya, vakavaki da badzǝdabadzǝg nǝ agatla ard kwalaviyavi biya, ɗlaɓa ard vakavaki da dǝgaadǝg nǝ gǝlah ar ghǝluwa. ");
INSERT INTO glwl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Bammam dzaharu kǝ alman kǝ ghǝraru ma ghǝrazhigǝla, vakavaki da badzǝda bi nǝ agatla ard kwalaviyavi biya, dlaɓa vakavaki da dǝgaa bi nǝ gǝlah ar da ghǝlu biya. ");
INSERT INTO glwl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Aɗaba vakavaki da almanagha, dzamaghǝragh ndakwi ba vaakwaha. ");
INSERT INTO glwl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Gyiya band kaara jahurammb nǝ iin kǝ vǝgha, akwama ba lapi nǝ gyiyahagh, baɗǝm nǝ vǝghagh da ba parak ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Akwama yang bi nǝ gyiyahagh biya, baɗǝm nǝ vǝghagh ba gurtla. Akwama nalnǝg nǝ paraka vǝghagh kǝ gurtla, ba jiirjiira da ba ɗyak ba vaivai nǝ gurtlǝna! ");
INSERT INTO glwl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Maay wa ɓagarnǝsɓag kǝ kwatnahǝr kǝ dadda hǝnyahah bu biya, bi ɗuwant kwa palla, nahant kwa palla, bi hǝkyina kǝ palla nenna kǝ palla, ɓaga bi taakiya am nahant kǝ Daadamazhigǝla am nahant kǝ kwaɓ biya. ");
INSERT INTO glwl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Mbakyarvad kwaha, ǝn tagkurtaga ndavam bi kǝ dǝgiti am da zǝgaru nǝ uuram kǝ shifǝgaru biya, ard dǝgiti am da hǝɓǝg nǝ uuram biya, dlaɓa ard ɗuuli am da tlǝkǝna nǝ uuram kǝ sǝɗav dat vǝgharu biya. Mbats juu bi nǝ shifǝg kǝ dǝgzǝg biya? Nii juu bi ha nǝ vǝgh kǝ sǝɗavahi? ");
INSERT INTO glwl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Vazamvazǝg kǝ ɗiikah ndana, ar maay riig biya, ar maay ghuda hǝi biya, ar maay dlaɓ dzaagaan damma kuvǝr biya, bakǝvakwaha gǝltǝrgǝlǝg Daadaruwi kwama ghǝrazhigǝla, jamtǝru bi nǝ uuram kǝ iitǝr dǝ ndangǝr biya? ");
INSERT INTO glwl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","War ma kuram mbakyarvad dzama dǝgiti tǝ ghǝraan fǝgarnaafǝg kǝ hǝnngah aanji ba hǝɗikǝn kǝ ghǝraani? ");
INSERT INTO glwl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Aujilbǝg kǝskuram dzama sǝɗavi am da nguɗǝg nǝ uurami? Vazamvazǝg kǝ ɗuuli ghubarǝg nǝ kwadladlah ndana, ar maay ɓa tlǝra aanji haa sǝɗav biya. ");
INSERT INTO glwl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bakǝvakwaha ǝn tagkurtaga, aanji Saluman ma ndzǝgana ndangǝraan ndakwi tapghǝnai kǝ caɗvacaɗǝg ǝnd palǝraatǝr biya ");
INSERT INTO glwl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Aitsaa, akwama caɗnacaɗǝg Daadamazhigǝl kǝ kazhakwa tǝghal ǝndkwana, kwar mǝng haniina dlakadur ɓǝlvǝtǝrdǝm damma kaara, kyakaɗaava kuram ha wada vǝlkur bi nǝ iin kǝ sǝɗav hi? Kuram lii hǝtsahǝtsan fadghǝrna. ");
INSERT INTO glwl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Mbakyarvad kwaha, ndavam bi taakiya, ‘Auwa kǝm da zǝg nǝmndi?’ Bi ‘Auwa kǝmnda hǝɓɓǝg nǝmndi?’ Bi ‘Auwa nǝ dǝgiti kǝmnda nguɗǝg nǝmndi?’ ");
INSERT INTO glwl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Aɗabad kwaha lii sǝrga bi kǝ Daadamazhigǝl biya, iitǝr lii gata kwanahaan kǝ dǝgitah baɗǝmma. Sǝrgasǝrǝg nǝ Daadaru kwama ghǝrazhigǝl taakiya am naagaan kǝ kwanahaan kǝ dǝgitaha. ");
INSERT INTO glwl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Gatamgatǝg kǝ tlǝkǝsǝra Daadamazhigǝl ba zǝnngwa, ard dǝgiti naag nǝ iina. Da vǝlkurvǝlǝg kǝ kwanahaan kǝ dǝgitah baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mbakyarvad kwaha, ndavambi kǝ dlakadur biya, aɗaba dlakadur sagau bad dlaɗaana, dlaɗa hinan ndakwi tlaltlǝg kwakyarvad haniina. ");
INSERT INTO glwl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Tar bi kǝ shari kǝ uudah biya. Akwama ɓaghiniɓaga, ar da taktǝg nǝ uudaha kǝ shariya. ");
INSERT INTO glwl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aɗaba hulfa shariyi am tǝgar nǝ uuram kǝ uudaha, da tǝkur bandkwah nǝ uud kǝ shariya, kuwǝn am kurgar nǝ uuram kǝ uudah dǝ vakaiya, da kurkur bad vakai nǝ uuda. ");
INSERT INTO glwl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Aujilbǝg agha vaza zǝr afǝsafǝsa dǝga dakari ma gyiya zǝraabagh kwal fataaɗ kǝskǝgh tǝ gugyǝmba dakari ma gyiyaghi? ");
INSERT INTO glwl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Agha tagar ndar kǝ zǝraabagh taakiya, ‘Ən sǝkadasǝg kǝ zǝr afǝsafǝsa dǝga dakarǝn ma gyiyaghǝn,’ mbats kǝgh ndakwani gugyǝmba dakar wa ma gyiyaghi? ");
INSERT INTO glwl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kǝgh muunina, kǝsdakǝsǝg kǝ gugyǝmba dakarǝn ma gyiyaghǝn ndana, kiyava nǝghǝganǝghǝg kǝskǝgh ba caɗaɗɗa lakuti agha da kǝsa zǝr afǝsagǝsa dǝga dakarǝn ma gyiya zǝraabaghǝna. ");
INSERT INTO glwl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Vǝlamtǝr bi kǝ ghǝgyah kǝ dǝgiti caccuwanacaccuwanan biya, aɗaba ar da gwiyav ar tahkurdana. Vǝlamtǝr bi dlaɓ kǝ jindararu kǝ ghavzah biya, aɗaba ar da hapgaana. ");
INSERT INTO glwl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ghalamghalǝga, da vǝlǝkurvǝlǝg nǝ uuda, gatamgatǝga, am da tlǝkǝnatlǝga, ngadlamngadlǝga, da wurkurwurǝg nǝ uud kǝ ghaiya wakyagha. ");
INSERT INTO glwl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aanji kwar kǝ dadda ghalǝga vǝlvarvǝlǝga, aanji kwar kǝ dadda gatǝga tlǝkǝnatlǝga, aanji kwar kǝ dadda ngadla wakyagha da wurvarwurǝg nǝ wakyagha. ");
INSERT INTO glwl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","War ma kuram daadaha, akwama ghalaaghalǝg nǝ zǝraan kǝ bruudi, vǝlar kǝ akuri?. ");
INSERT INTO glwl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nii ma ghalaaghalǝg nǝ zǝran kǝ kilfa, vǝlar kǝ ghaval dlakulvaan hi? ");
INSERT INTO glwl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Akwama kurami dangw huɗaharu am sǝrgasǝrǝg kǝ vǝlǝga dǝgit maraw kǝ zarharuwa, kyakaɗava daadaruwi ma ghǝrazhigǝli kaci wa da vǝltǝr bi kǝ dǝgitah maraw kǝ lii ghalǝgan biya! ");
INSERT INTO glwl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Baɗǝm nǝ dǝgitahi am naag nǝ uuram ɓagkura nǝ uudaha, kuram ndakwani ɓagamtǝrɓaga. Aɗaba kwan wa tagada nǝ adzahadzaha Muus ard tlayanha. ");
INSERT INTO glwl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Tamtǝg kǝ ghaiya wakyaghǝn jǝghwna, aɗaba ɗuula daas da vaka ǝmtsǝga ba bahahha, dlaɓa kwanǝn kǝ ɗuula ba tsalalla. Lii tǝgaana ar ba dyaka. ");
INSERT INTO glwl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ɗuula tlǝkǝna shifǝga. Ba jǝghwa nǝ iina, dlaɓa dladlaɗ nǝ tǝgaana. Lii tǝgaana ar maay ɗyak biya. ");
INSERT INTO glwl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Famfǝg kǝ hyǝmmi tǝ tlayangaha fiidfiida kwar sahasagaw da vakaru dǝ garava tughaha, ma huɗmahuɗa ar jagajagaan band ghǝgyaha tǝghala. ");
INSERT INTO glwl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Am da nǝghǝtǝraakanǝghǝg tǝdvad tlǝrahaatǝra. Cagvacag nǝ zarha inabi tǝ uufa takka? Nii cagvacag ha nǝ zǝra ghǝgyiv tǝ zaz hi? ");
INSERT INTO glwl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Bandkwah dlaɓ makwar kǝ uufi marawa yaa ba zǝr marawa, uufi ghwaɗa, ya zǝr ghwaɗa. ");
INSERT INTO glwl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Maay nǝ uufi maraw ya zǝr ghwaɗ biya, dlaɓa uufi ghwaɗa yiga bi kǝ zǝr maraw biya. ");
INSERT INTO glwl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Baɗǝm nǝ uufi maay ya zǝr maraw biya, aa ghudvarsghudǝga, ɓǝlvdǝm damma kaara. ");
INSERT INTO glwl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mbakyarvad kwaha am da nǝghǝgaakanǝghǝg kǝ tlayanngaha fiidfiid tǝdvad tlǝrahaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ɗǝm bi dadda kwa taa kǝskai ‘Yaazhigǝl, Yaazhigǝl’ da daas damma tlǝksǝra ghǝrazhigǝl biya, bamma dadda kwa ɓagaaɓag kǝ dǝgiti naag nǝ Daadar kwama ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Daghuvala ta shariya, ar da tagwatag nǝ uudaha baɗyak taakiya, ‘Yaazhigǝl, Yaazhigǝl, tagamnda bi kǝ ǝlbǝg maraw ma ɗaagagh biya? Lagwamndada bi kǝ shatanah ma ɗaagagh biya? Ɓagamda bi kǝ dǝgaha jappǝr baɗyak ma ɗaagagh biya?’ ");
INSERT INTO glwl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tǝhala kwaha, ǝnda tagtǝrtag taakiya, ‘Ən sǝrkur bi ba dǝm biya. Yagham vakar kǝlaadahaana.’ ");
INSERT INTO glwl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Mbakyarvad kwaha baɗǝm daddakwa cinnghacinng kǝ ǝlbǝgara, dlaɓa ɓagaan kǝ tlǝr dǝ vakaiya, da nǝg band dadda dabari kwa ndǝraa vǝgyaan tǝ akurna. ");
INSERT INTO glwl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Hyiyaa ba nǝ yuwa, kaa righǝtrighǝg nǝ zaagha kǝla saasa, fǝɗ ndakwi tsa saas dat hǝnyahiina, bakǝvakwaha dlǝghana biya, aɗaba ndǝrava tǝ akura. ");
INSERT INTO glwl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Baɗǝm daddakwa cinnghacinng kǝ ǝlbǝgara, dlaɓa ɓagaa bi kǝ tlǝr dǝ vakai biya, ba kalkal dǝ dlagǝn kwa ndǝraa hǝnyahaan tǝ sǝghǝla. ");
INSERT INTO glwl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Hyiyaa ba nǝ yuwa, righǝtrighǝg nǝ zaagha, fǝd ndakwi tsa saas dat hǝnyahiin, kaa dlǝga, dlagaadlag bafakya.” ");
INSERT INTO glwl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ghyǝnga ba nǝ Yesu tagtǝr kwanahaan kǝ dǝgitaha, kaa ba ɓa jappǝr kǝ uudah dǝ tsagaanana. ");
INSERT INTO glwl_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Aɗaba tsagatǝr band daddakwa dǝ ndzǝɗa, gǝrgǝr dǝ tsaga lii tsaga adzahadzaha Muusa. ");
INSERT INTO glwl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sahi ba nǝ Yesu sii ma aghwa, kaa gatǝgaan kǝ uudaha baɗyaka ");
INSERT INTO glwl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kaa sagau kǝ dadda vǝc da vakaana, kǝla kǝ iin kǝ ghunj tǝvuukwaana amaa, “Yaazhigǝla, ma haighanthaiga, mbǝkwimbǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kaa vǝlla dǝv kǝ Yesu tapǝna kǝ dadda vǝcna amaa, “Haiyananthaiga, mbambǝga.” Batwatswatsǝra, kaa mbǝgambǝg kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Aiyam nǝ Yesu taa kǝ iina, “Faffǝg kǝ hyǝmmiya tagar bi aanji kǝ war kǝ dǝgiti aa dzǝgardzǝgǝn biya, dǝg mardamarǝg kǝ ghǝragh vak zhiila kǝsuufa, agha vǝlda kǝ baiku bandkwa tagada na adzahadzaha Musa. Ɓagnaɓag kwana kiyava fadghǝr kǝ dlamakǝlaawa taakiya mbǝghambǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Dagha ba nǝ Yesu damma Kafarnahum, ngal dagau kǝ tlauja Rum maamal da vakaan da ghalgaan taakiya, ");
INSERT INTO glwl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Yaazhigǝla, kwatnahar hǝngan hǝnyah ǝmtsamtsan nǝ vǝgha, hǝɓa dlaɗ ba vaivaiya.” ");
INSERT INTO glwl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Aiyam Yesu taa kǝ iina, “Ən dagau da mbǝgaana.” ");
INSERT INTO glwl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kaa ngugwamgug kǝ tlauj maamalna amaa, “Yaazhigǝla, tlanal bi nai kǝskǝgh kǝ sagau sa vǝgyar biya, tagdatag ba kǝ ǝlbǝg kalti kwatnahar da mbǝga. ");
INSERT INTO glwl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Aɗaba kai dǝghǝrar ndakwani ǝn mazhangyil kǝ kwarǝga uuda, mǝng dlaɓ tlaujah mazhangyil kǝskaiya, ǝn tagardatag kǝ pallaatǝr taakiya, ‘Dǝga,’ kaa dagauwa. Kwatlǝrǝn dlaɓ ǝn ɗaagantdaaga taakiya, ‘Sawa,’ sagauwa, Akwama taganartag dlaɓ kǝ kwatlǝrǝna, ‘Ɓagnaɓag kǝ dǝgit ǝntkwaha,’ kaa ɓagaana.” ");
INSERT INTO glwl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Cinngha ba nǝ Yesu ǝndkwaha, kaa ɓa jappǝr kǝ iina, aiyama kǝ lii gatǝgaana, “Ən tagkurtag kǝ jiira, tapanna bi kǝ tlǝkǝnatlǝg kǝ uud dǝ fadghǝr ǝndkwan ma Izrail biya. ");
INSERT INTO glwl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ən tagkurtaga, baɗyak nǝ uudah ar da sii dǝ sǝga ard sagat dǝ sǝga ar da cihurgan ǝmtaɗ dǝ Ibrahim ard Ishaku ard Yakub vaka za kaffa hwaɗag ma tlǝkǝsǝra ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Aɗaba uudahi ɓadlavtǝrna kǝ iitǝr nǝ tlǝksǝra ghǝrazhigǝla, da ɗiivtǝrdǝm damma gurtla, vakavaki ar da tuug nǝ iitǝr ard ghwada dǝv dǝ tlǝrɗa.” ");
INSERT INTO glwl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aiyam nǝ Yesu taa kǝ tlauja maamalǝna, “Dǝgdaasa, da ɓagakɓag nǝ uud mbakyarvad fadghǝragha.” Kaa mbǝg nǝ kwatnaha nǝ iina batwatsǝra. ");
INSERT INTO glwl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Dagha ba nǝ Yesu da vǝgya Bitrusa, kaa nǝghǝganǝghǝg kǝ iin kǝ babba uusa Bitrus ɓǝlgan njǝkǝn fǝɗa. ");
INSERT INTO glwl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tapǝna kǝ iin kǝ dǝva uusiina, kaa mbǝgambǝg kǝ iin tuuk kǝ fǝɗiina, ngal ciiga ɓagtǝra kǝ dǝgzǝga. ");
INSERT INTO glwl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ɓǝlaa ba hwaasa, kaa sǝdǝvsǝga kǝ uudah kǝ lii ciɓǝg shatanah baɗyak da vak Yesu, tagada ba ǝlbǝg kalti, ngal sagal shatanahahaan ma vǝghaatǝra, mbahǝnan baz lii yangbiya. ");
INSERT INTO glwl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tǝdvad kwan wa righavant nǝ dǝgiti tagavda tǝdvad tlayang Ishay taakiya, “Kǝsakiyamaarakǝsǝg kǝ kuzahamiyama, dlaɓa kǝskiyamaaran kǝ yangbiyahamiyama.” ");
INSERT INTO glwl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nǝgha ba nǝ Yesu kǝ uudah baɗyak faɗǝga tǝghǝr kǝ iina, ngal tagartag kǝ iin kǝ mbǝrzahaan maraa dzǝva dagal dat ghyaba kwah kǝ ghaiya yuwa haiya. ");
INSERT INTO glwl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ngal sagau kǝ dadda tsaga adzahadzah da vakaana, amaa taa kǝ iina, “Dadda tsaga dǝgita, ǝn gatakgatǝg badǝm vakavaki agha dagal nǝnga.” ");
INSERT INTO glwl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ngugharangug nǝ Yesu amaa, “Mbayakaha ar da afkahaatǝra, ɗiikaha dlaɓa mǝng vakavaka hǝnnganahaatǝra, Zǝra Uuda maay vaka hǝnnganan biya.” ");
INSERT INTO glwl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Am nǝ pall ma mbǝrzahaan taa kǝ iina, “Yaazhigǝla, ǝn dǝgaadǝg ndan ǝn hǝɗnan kǝ daadara.” ");
INSERT INTO glwl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Aiyam nǝ Yesu taa kǝ iina, “Gatkwagatǝga, aa hǝɗarhǝɗǝg lii ǝmtsaharaǝmtsahǝg kǝ zaraabahaatǝri ǝmtsaraǝmtsǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Dagha ba nǝ Yesu damma pɛrayuwa, kaa gatǝgaan kǝ mbǝrzahaana. ");
INSERT INTO glwl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kaa ciig kǝ ghabag ard fǝɗ ma yuwahaiya, fǝgharzhafǝg baz yu ghubǝɗa saas damma pɛrayuwa, Yesu dlaba hǝnahaara. ");
INSERT INTO glwl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kaa dagau kǝ mbǝrzahaan ar ciyanta, am nǝ iitǝra, “Yaazhigǝla, katkǝmndkatǝga wakǝm tǝ ɗuula ǝmtsǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Aiyama taa kǝ iitǝra, “Aujilbǝg kǝskuram gǝdzǝg ǝndkwani, kuramǝn dǝ fadghǝr hǝɗiikǝna?” Kaa ciig kǝ iin cagara kǝ gyi kǝ fǝɗǝn ard ghubǝɗǝga yuwa, kaa kyaɓalǝgakyaɓalǝga. ");
INSERT INTO glwl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kaa ɓa jappǝr kǝ mbǝrzahaana, aiyam nǝ iitǝra, “Hulfakwar kǝ uud wana, baz fǝɗ ard ghubǝɗǝga yu ar cinngarnucinngni?” ");
INSERT INTO glwl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tsǝgwa ba nǝ Yesu ma haaya Garisaha, kaa sagau kǝ uudah bu kwa ciɓtǝr shatanah sa vak Yesu, gǝdzǝvtǝrgǝdzǝg ba vaivaiya, aɗaba ar ndzǝga bamma gǝtlaha, maay wa ta kwahiin kǝ ɗuul biya. ");
INSERT INTO glwl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kaa huulǝg kǝ iitǝr ar taakiya, “Au lambagh dǝ kǝmnd Zǝra Daadamazhigǝli? Agha sa vǝlkǝmnd dlaɗ ba sart ndakwani ɓagaa biya?” ");
INSERT INTO glwl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mǝng nǝ maandala agyaragyara ghavzah ar piig kǝ dagalaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ngal ba ghalgaan kǝ shatanahaan kǝ Yesu taakiya, “Akwama sǝghkǝmndadasǝga, ɗiikǝmndarsɗiig damma gyǝɗya ghavdzahaana.” ");
INSERT INTO glwl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Aiyama taa kǝ iitǝra, “Damdǝg ciya,” Kaa daas kǝ iitǝr damma ghavzahiina. Baɗǝm gyǝɗya ghavzǝn kaa ǝmdǝra daay kǝ iitǝr bawatswats damma yuwahaiya, ngal ruug kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kaa ǝmndǝra daas kǝ lii piya ghavzahaana. Daragha ba nǝ iitǝr damma kǝssa, kaa tagaan kǝ iitǝr kǝ dǝgitahi dzǝghaar dǝ lii ciɓtǝr nǝ shatanahǝn baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ngal sagal kǝ uudah ma kǝsiin baɗǝm da tlǝgaraa Yesu. Nǝghara ba nǝ iitǝra, kaa ghalgaan kǝ iitǝr maa ɗuwars kǝ lardaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kaa daas kǝ Yesu damma pɛrayuwa, ngal dagal tǝghǝra yu damma Kafarnahum, kǝssi ghubara nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kaa sagau kǝ uudah dǝ daddakwa ǝmtsamtsan nǝ vǝgha hǝngan tǝ kǝjja, nǝghǝgha ba nǝ Yesu kǝ fadghǝratǝra, aiyama kǝ daddakwa ǝmtsaǝmtsan nǝ vǝghǝna “Zǝrara, ndavbiya, ɓǝshakanaɓǝshǝg nǝ uud kǝ haipahagha.” ");
INSERT INTO glwl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Cinngara ba nǝ lii tsaga adzahadzaha ǝndkwaha, kaa takǝvatag kǝ iitǝr mataatakaatǝr taakiya, “Kwanǝn kǝ uuda badza ɗaaga Daadamazhigǝla!” ");
INSERT INTO glwl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nǝghakanǝghǝg nǝ Yesu kǝ dzamaghǝraatǝra, amaa kǝ iitǝra, “Aujibǝg am dzama kǝlaadǝr ma ǝrvidmahuɗaruwi? ");
INSERT INTO glwl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kwar wa tsaftsaf kǝ taga, taakiya, ‘Bǝshakanaɓǝshǝg nǝ uud kǝ haipahagha nii ciiga dǝgdagalhi?’ ");
INSERT INTO glwl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ən naagaan am sǝran taakiya Zǝra Uuda dǝ ndzǝɗa ɓǝsha haipah ma duniya.” Kaa amaa taa kǝ daddakwa ǝmtsamtsan nǝ vǝghna, “Ciig kǝssǝg kǝjjagha dǝg daas dahǝnyaha.” ");
INSERT INTO glwl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tǝhalakwaha, kaa ciig kǝ uudanǝna, ngal daas kǝ iin da vǝgyaana. ");
INSERT INTO glwl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nǝghara ba nǝ dzahava dlamakǝlaawa ǝndkwaha, kaa gǝdzǝg kǝ iitǝra, ar gala Daadamazhigǝla kwa vǝlgar hulfa kwan kǝ ndzǝɗ kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ɗughars ba nǝ Yesu kǝ vakavaka kwahiina, kaa nǝghǝganǝhǝg kǝ iina kǝ uuda nǝ iin kwa ɗahav dǝ Matiyu cihurgan vaka cauwa hadama. Am Yesu taa kǝ iina “Gatkwagatǝga” ngal ciig kǝ iin kaa gatǝgaana. ");
INSERT INTO glwl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tǝhalakwaha, kaa za kaf kǝ Yesu ma vǝgya Matiyu, ngal sagau kǝ lii cauwa hadama ard yaa dadda haip ba ɗyaka ar cihuran buud za kaf kǝ iitǝr dǝ iina ard mbǝrzahaana. ");
INSERT INTO glwl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nǝghǝra ba nǝ Farisiyah ǝntkwaha, ngal am nǝ iitǝr taa kǝ mbǝrzahaana, “Aujibǝg kǝ dadda hǝnyaharu za kaf ǝmtaɗ dǝ lii cauwa hadama ard yaa dadda haipi?” ");
INSERT INTO glwl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Cinngha ba nǝ Yesu ǝntkwaha, aiyama, “Lii yanga maay lambatǝr dǝ dadda mba uud biya, bamma lii yang biya. ");
INSERT INTO glwl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Damdǝg tsagamtsag kǝ dǝgiti tuuk vakai wanǝna, ‘Zhuwadaal wan naag nai vakaruwa kyulǝgg biya.’ Sanhi da ɗaa lii jiir bi nai biya, sanhi mbakyarvad yaa dadda haipa.” ");
INSERT INTO glwl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kaa dagau nǝ mbǝrzaha Yuhwana dadda tsuufǝg davak Yesu, am nǝ iitǝra, “Aujilbg kǝskǝmnd ard Farisiyah kǝm kǝsgaan ka andǝla, kwakyarvadau kǝ mbǝrzahah ar maay kǝsgani?” ");
INSERT INTO glwl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Aiyam nǝ Yesu taa kǝ iitǝra, “Ar badzǝgaan nǝ tsaghwaha zhiila ghuula kǝ ǝrvidmahuɗ ma bar ǝmtaɗ dǝ zhiila ghuula? Da sagau sarta kwa da kǝsav zhiila ghuula dagal vakatǝra, ar da kǝssǝg ma kwah sarta nǝ iitǝra kǝ andǝla. ");
INSERT INTO glwl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Maay wa ghudgǝtghudǝg kǝ daala sǝɗav tlappant tǝ ǝnghura sǝɗav biya aɗaba da tǝhgaan kǝ ǝnghura sǝɗav na, tǝhgaana, da jǝguujǝg kwa ndza wura. ");
INSERT INTO glwl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Maay wa ɗiya daala yuwa inabi damma ǝnghura ambǝla hǝllu biya, akwama ɗiyavdǝmɗiiga, ciɓgaan kǝ ǝnghura ambǝla hǝllwuna, ɗiya dagal nǝ yuwa inabiya badzǝgaan kǝ ambǝla hǝlluwa. Daala yuwa inabi ɗiyav bamma daala ambǝla hǝlluwa tǝvad kwah wa da ɗiigal bi nǝ iin biya dlaɓa ciɓǝgai nǝ ambǝla hǝllu biya.” ");
INSERT INTO glwl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ma sarta taa kwanǝn kǝ Yesu, kaa sagau nǝ maala ma guda dzǝgwazhigǝla da vakaana, kǝla kǝ ghuunj tǝvuukwana, amaa, “Dǝghwar aa ǝmtsǝga ba ndakwana, asǝg tapnatapǝg da ciiga.” ");
INSERT INTO glwl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kaa dagal kǝ Yesu ard mbǝrzahaan gata uuda nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mǝng nǝ uusiin viigaan kǝlawa tar buwa kǝla avǝza, ka dagau kǝ iina gyilga Yesu tapǝna kǝ ghaiya sǝɗavaana. ");
INSERT INTO glwl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Amaa ma ǝrviɗmahuɗaana, “Akwama tapannatapǝg aanji ba ghaiya sǝɗavaan kaltiya, ǝn da mbǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Gwiyavǝt ba nǝ Yesu kaa nǝghǝganǝghǝga, aiyama, “Ndav bi dǝghwar biya, fadghǝragha mɓakanambǝga.” Batwatsǝra, kaa mbǝga kǝ uusina. ");
INSERT INTO glwl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Dagha ba nǝ Yesu da vǝgya maala ma guda dzǝgwazhigǝlǝna, kaa nǝhganǝhǝg kǝ iin kǝ lii fǝrta faakila ard dzahava dlamaa kǝlaaw ar tuuga. ");
INSERT INTO glwl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Aiyam nǝ Yesu, “Ciyamciig vaakwana, ǝmtsabi nǝ dughwiin biya, hǝnnahaara.” Kaa ɓagar ghuɓasǝga nenneg kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lagwavtǝrda ba nǝ uudah da gyǝmala, kaa daas kǝ iina hǝkyinan kǝ dǝva dughwiina, ngal ciiga. ");
INSERT INTO glwl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kaa cinngalcinng nǝ ǝlbǝg tǝghǝr kǝ iin aanji taakwara. ");
INSERT INTO glwl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ɗughars ba nǝ Yesu kǝ vakavak kǝ iina, kaa ba gatǝgaan kǝ gulfah buwa ar ɗaag bad halavuwa ndzǝɗaatǝr ar taakiya, “Zhukǝmndaalazhug, Zǝra Dauda!” ");
INSERT INTO glwl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Dagha ba nǝ Yesu damma kwatlǝrǝn kǝ hǝnyaha, kaa daas kǝ gulfah bu da vakaana, aiyama taa kǝ iitǝra, “Famdǝghǝrtfǝg taakiya ǝn mbǝkurambǝga?” Aiyam nǝ iitǝra, “Aana, Yaazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tǝhala kwaha, kaa tapǝna kǝ iin kǝ gyiyahaatǝra aiyama, “Tǝdvad fadhǝraruwa, mbǝkurmbǝg nǝ uuda?” ");
INSERT INTO glwl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ngal wurǝg kǝ gyiyahaatǝra, tǝhala kwaha ka ɓǝltǝra nǝ Yesu kǝ magi ba vaivaiya amaa, “Tagamarbi aanji kǝ war biya.” ");
INSERT INTO glwl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Daral ba nǝ iitǝra, kaa ba kutǝgaan kǝ iitǝr kǝ ǝlbǝgǝn tǝghǝr kǝ iin aanji takwar ma lardiina. ");
INSERT INTO glwl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ar tǝ ɗuula sagala, kaa sǝvardǝvsǝg nǝ daddakwa mamghant nǝ shatanaha kǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Savda ba nǝ Satanahna, kaa fǝgarzhafǝg kǝ uuda nǝ iin kǝ taa ghaiya, kaa ɓa jappǝr kǝ dzahava dlama kǝlaawa, aiyam nǝ iitǝra, “Ba dǝm tapavnai kǝ nǝghǝganǝghǝg kǝ hulfa kwan kǝ dǝgit ma Izrail biya.” ");
INSERT INTO glwl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aiyam Farisiyaha, “Abi lagw dǝ ndzǝɗa maala Shatanah nǝ iin kǝ shatanaha.” ");
INSERT INTO glwl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tǝhala kwaha, kaa gwaivagwaig kǝ Yesu ma kǝssaha ard gǝdzǝr kǝssaha, tsagtǝrtsag ma guda dzugwazhigǝla, tagtǝr ǝlbǝg maraw tǝghǝr kǝ tlǝkǝsǝra Daadamazhigǝla, mbahtǝran dlaɓ kǝ uudahi dǝ kuzah shahshaha ard lii yang biya. ");
INSERT INTO glwl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nǝgha ba nǝ iin kǝ dzahava dlamaa kǝlaaw baɗyaka, kaa zhutǝrdalaazhuuga. Aɗaba ar hǝɓa dlaɗa maay wa mǝltǝrumǝlǝg biya, ar band tughwahǝn kwal dadda piiga. ");
INSERT INTO glwl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aiyama taa kǝ mbǝrzahaana, “Tlǝra ghuda hǝi ba ɗyaka, dlaɓa lii ɓa tlǝra ar ba ǝnkykwahha. ");
INSERT INTO glwl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mbakyarvad kwaha, ghalamghalǝg kǝ dadda guhha maa dzǝgaraa kǝ lii ɓaa tlǝra, maraa ghudara kǝ hǝiya.” ");
INSERT INTO glwl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kaa ɗahtǝrantɗahǝg nǝ Yesu kǝ mbǝrzahaan kǝlaawa tar buwa. Vǝlatǝrvǝlǝg kǝ ndzǝɗa lagwa shatanaha ar mbaha kuzah shahshaha ard lii yang biya. ");
INSERT INTO glwl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Wan nǝ ɗaagaha mbǝrzah kǝlaawa tar buna. Dǝga zǝnngwa iin nǝ Siman kwa ɗahav dǝ Bitrus ard dǝ zǝra babbaan Andrawus ard Yakubu zǝra Zabadi ard zǝra babbaan Yuhwana, ");
INSERT INTO glwl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ard Filigus ard Batalomi ard Tuma ard Matiyu dadda cauwa hadama ard Yakubu zǝra Halfa ard Taddiyus, ");
INSERT INTO glwl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Siman kwa naagaan kǝ za vukwa kǝsaana, ard Yahuda Iskariyoti kwa zuu langiya Yesu. ");
INSERT INTO glwl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ɓǝlatǝrǝtɓǝlǝg nǝ Yesu kǝ mbǝrzahaan kǝlaawa tar buna, amaa taa kǝ iitǝra, “Dam bi davak lii ar Yahudah biya, ɗlaɓa dam bi damma kǝssa Samariyah biya. ");
INSERT INTO glwl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Dlakulva kwaha damdǝg da vak tughaha uudaha Izraila kwa zaharazahǝga. ");
INSERT INTO glwl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Damdǝg tagamtǝrtag kǝ ǝlbǝg marawa taakiya, ‘Tlǝksǝra ghǝrazhigǝla hǝrzǝthǝrzǝga.’ ");
INSERT INTO glwl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mbahamtǝrmbahǝg kǝ lii yang biya, ciyamtǝrciig kǝ lii ǝmtsaharaǝmtsahǝga, mbahamtǝrmbahǝg kǝ magyagulfaha, lagwamlagw kǝ Shatanaha. Tlamkǝna ba gyaagyaana vǝlamtǝrvǝlǝg ba gyaagyaana. ");
INSERT INTO glwl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kǝsam bi kǝ adawana, aanji agwalɛl, aanji vǝrzhagan ma ambǝlaru biya. ");
INSERT INTO glwl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kǝsam bi kǝ ambǝl mam dagal biya, aanji sǝɗav buwa, aanji kimbak aanji zad biya, aɗaba dadda ɓa tlǝra dlaikǝndlaig nǝ dǝgshigaana. ");
INSERT INTO glwl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Baɗǝm nǝ kǝsa ard gǝdzǝr kǝssahi am dǝgaa nǝ uurama, gatamgatǝg kǝ uuda jiirjiir am ndzan ma vǝgyaana tangw damma sarti am da ciig nǝ uurama. ");
INSERT INTO glwl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Akwama damaghan da hǝnyahiina, tagamtǝrtag taakiya, ‘Gabǝrǝr tǝghǝr kǝskurama.’ ");
INSERT INTO glwl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Akwama uudaha jiirjiir wa ma hǝnyahiina, gabǝraruwa aa ndzandzǝg tǝghǝr kǝ iitǝra, akwama uudaha jiirjiir biya, gabǝraruwa gwiya saa kǝskurama. ");
INSERT INTO glwl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Baɗǝm daddakwa lawalǝg kǝ dlǝgha kurama, ard cinnga ǝlbǝgaruwa, pangamdapang kǝ alagwat tǝ shigaharuwu akwamam da ɗuwa kǝsaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Bak jiir wan tagkur naiya, da zhuvtǝrdaala kǝ uudaha Sadum ard Gumara tǝghǝr kǝ uudaha kǝssiin daghuvala ta shariya. ");
INSERT INTO glwl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Wan ɓǝlkurɓǝlǝg band tuughwah ma taataka ghǝgyaha tǝghala, mbakyarvad kwaha ndzamandzǝg ba ɗyamɗyam band ghavala, dlaɓa am nal kalaliyah band kakuura. ");
INSERT INTO glwl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Famfǝg kǝ hyǝmmi dǝ uudah aɗaba ar da langkurlang damma guda ta shariya, ar da ɓalkura kiiɓ ma guda dzǝgwazhigǝlaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ar da langkurlang da tǝvuukwa maamaalah ard tlǝkǝssah mbakyarvad kaiya, kiyava taa ǝlbǝg maraw kǝskuram tǝvuukwatǝra ard tǝvuukwa lii ar yahudah biya. ");
INSERT INTO glwl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Akwama langarkurdalanga, ndavam bi kǝ dǝgiti am da tag nǝ uuram biya, ard ɗuuli am da tag nǝ uuram biya, aɗaba da vǝlkurvǝlǝg nǝ uud kǝ dǝga tagga. ");
INSERT INTO glwl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Aɗaba kuram bi wada taaghai biya, shǝɗkwa Daadaru wa da taaghai mbakyarvad kurama. ");
INSERT INTO glwl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Zǝraaba da za lanngiya zǝraabaan da tsǝvana, daada da za lanngiya zǝraana, zarha ar da ciitǝrant kǝ yaatǝra da ciɓǝvtǝrana. ");
INSERT INTO glwl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Uudah baɗǝm ar da naakur bi mbakyarvad ɗaagara, dlaɓa baɗǝm daddakwa ghacaghacig dat ghalaana, da tlǝkǝnatlǝg kǝ katǝga. ");
INSERT INTO glwl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Akwamar vǝlkur dlaɗ ma kwatlǝrǝn kǝssa, ǝmndǝraǝmdǝrga damma kǝssi tǝvuukwa, jiira wan takur naiya lakuti am tsǝgarvaratsǝg kǝ kǝsaha Izraila baɗǝmma, da saaya nǝ Zǝra Uuda. ");
INSERT INTO glwl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Daddakwa tsaga dǝgit vak kǝ uuda jiguubi kǝ dadda tsagar dǝgit biya, jiguubi dlaba nǝ kwatnah kǝ dadda hǝnyahaan biya. ");
INSERT INTO glwl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tlǝgaltlǝg nǝ dadda tsaga dǝgit vak kǝ uuda, nal band dadda tsagar dǝgita, dlaɓa kwatnah band dadda hǝnnyahaana. Akwamar ɗaag dǝ Baˈalzabul kǝ dadda hǝnnyaha, ar da ɗaatǝr dǝ kwa juujig kǝ Baˈalzabul kǝ uudahi ma hǝnnyahiina. ");
INSERT INTO glwl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Mbakyarvad kwaha, gǝdzamtǝr biya, aɗaba maay nǝ dǝgiti hǝɗahǝdan kwa da maay wurav biya, dlaɓa maay nǝ dǝgiti shiɓashiɓan kwa da sǝrvaaka biya. ");
INSERT INTO glwl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Dǝgiti taagankur nai magurtla, tagamtag bat ɓalaɓala, dǝgiti cinngama nǝ uram da gǝlagǝla, tlǝhamtlǝhǝg tǝ ghǝra guda. ");
INSERT INTO glwl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Gǝdzam bi kǝ lii tsǝgatsǝg kǝ vǝgha biya aɗaba ar maay dǝ ndzǝɗa tsa shifǝg biya, gǝdzamgǝdzǝg kǝ dadda kwa tsǝgatsǝg kǝ vǝgh ard shifǝg ma kaarafaiya. ");
INSERT INTO glwl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Maay kwan vǝlav nǝ caakwah bu tǝ kwaɓ pal biya? Bakǝvakwaha maay aanji pallǝratǝr ɓǝladagal da tǝ haay kwal sǝrga bi kǝ daadaru biya. ");
INSERT INTO glwl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Baz guujaha ghǝraharu ndakwani kǝdlakǝdlana. ");
INSERT INTO glwl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mbakyarvad kwaha, ndavam biya, jamujig nǝ uuram kǝ caakwah baɗyak dǝ ndanngǝra. ");
INSERT INTO glwl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Baɗǝm daddakwa haiyakuthaig kǝskai tǝvuukwa uudaha, kai ndakwi ǝn da haiganthaiga dǝ iin tǝvuukwa Daadar kwa ma ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Aiciya, badǝm daddakwa haiyakut bi tǝvuukwa uudah biya, kai ndakwani ǝn da haigant bi dǝ iin tǝvuukwa Daadar kwa ma ghǝrazhigǝl biya. ");
INSERT INTO glwl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Tlatlam bi taakiya sanhi kwakyarvad ǝn vǝlkur kǝ gabǝrǝr nai damma duni biya, maaya, sanhi kwakyarvad ǝn vǝlkur kǝ gabǝrǝr biya, ba tagwazhatagwazha. ");
INSERT INTO glwl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Sandi tagwazhatagwazha, adaba “ ‘zǝra da ɓa dau dǝ daddaana, dughwa da ɓa dau dǝ babbaana, ghuul dlaɓa dǝ ɓa dau dǝ jikkan uusa. ");
INSERT INTO glwl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Uudaha hǝnnyahaan kǝ uudan war da ɓa dau dǝ iina.’ ");
INSERT INTO glwl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Badǝm nǝ daddakwa waiya daddaan bi babbaana tǝghǝr kǝskaiya, tlǝgal bi kǝ nǝg kǝ dǝgar biya. Dlaɓa baɗǝm nǝ daddakwa waiya zǝraan bi dǝghwaana tǝghǝr kǝskaiya tlǝgal bi kǝ nǝg kǝ dǝgar biya. ");
INSERT INTO glwl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Badǝm nǝ daddakwa kǝsǝghanti kǝ tlaɓahǝrtǝgaan ngal gata kai biya, tlǝgal bi kǝ nǝg kǝ dǝgar biya. ");
INSERT INTO glwl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Baɗǝm nǝ daddakwa naa kata shifǝgaana, ɓǝlgaan dagala. Baɗǝm nǝ daddakwa ɓǝlda shifǝgaan kwakyarvad kaiya aa fǝgabadfǝga. ");
INSERT INTO glwl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Baɗǝm nǝ daddakwa dlǝghakuradlǝghǝga, dlǝghakwidlǝghǝg kǝskaiya, baɗǝm nǝ daddakwa dlǝghakwidlǝghǝga, dlaghaadlǝghǝg kǝ daddakwa ɓǝlkwadi kaiya. ");
INSERT INTO glwl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Baɗǝm nǝ daddakwa dlaghaadlǝghǝg kǝ tlayanga kwakyarvad tlayang nǝ iina, da tlǝkǝnatlǝg kǝ dǝgshiga tlayanga. Dlaɓa badǝm nǝ daddakwa dlaghaadlǝghǝg kǝ uuda jirjira kwakyarvad uuda jirjira nǝ iina, da tlǝkǝnatlǝga kǝ dǝgshiga uuda jirjiira. ");
INSERT INTO glwl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Baɗǝm nǝ daddakwa vǝlgar kuwa yu lǝmcikcik kǝ pall ma lii hǝɗiikǝn kwakyarvad mbǝrzar nǝ iina, ǝn takurtaga da pilwai nǝ dǝgshigaan biya.” ");
INSERT INTO glwl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ghyǝnga ba nǝ Yesu kǝ tagtǝr dǝgitah kǝ mbǝrzahaan kǝlaawa tar buwa, kaa dagal kǝ iin damma kǝsaha Galili da tsagtǝr dǝgitah ard taa ǝlbǝg maraw kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ma sarta kwahiina Yuhwan dadda tsuufǝga ndza ma guda birfǝna, cinngha ba nǝ iin kǝ dǝgitahi ɓag nǝ Yesu, kaa ɓǝlgantɓǝlǝg kǝ iin kǝ mbǝrzahaan da vakaana. ");
INSERT INTO glwl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ar ndavaru taakiya, “Kǝgh wagha da saayin nii, kǝm paka kwatlǝrǝnhi?” ");
INSERT INTO glwl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Am nǝ Yesu taa kǝ iitǝra, “Gwiyamagwig daas am tagar kǝ Yuhwan kǝ dǝgiti amaa nǝghǝga nǝ uurama, ard dǝgiti amaa cinnga nǝ uurama. ");
INSERT INTO glwl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Gulfaha ar nǝghǝganǝghǝga, ghurɗikaha ar dagala, yaa dadda vǝca mbahavtǝrambahǝga matanngaha ar cinngacinnga, uudahi ǝmtsaharaǝmtsahǝga ciyavtǝrǝtciiga, dlaɓa tagǝvtǝrtag nǝ ǝlbǝg marawa kǝ talagaha. ");
INSERT INTO glwl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Dǝ bark nǝ daddakwa tǝrɗa bi tǝ ɗuul mbakyarvad kai biya.” ");
INSERT INTO glwl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ar tǝghǝrdǝga ciya dagal nǝ mbǝrzaha Yuhwana, kaa fǝgarzhafǝg kǝ Yesu kǝ taa ǝlbǝg tǝghǝr kǝ Yuhwan vak dlamakǝlaawa, “Au wamaa dagal nǝ uuram da vazǝgaan ma tǝghali? Amaa da vaza kazhakwahaanǝn tlaɗtlaɗǝn kwa gajag nǝ fǝɗ na? ");
INSERT INTO glwl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Au kaci wa damal nǝ uuram da vazǝgaani? Daddakwa caɗva ma sǝɗav marawna? Udahi ndzǝga ma vǝgya tlǝkǝsa iitǝr wa nguɗa sǝɗavah marawa. ");
INSERT INTO glwl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Au kaci wa damal nǝ uuram da vazǝgaani? Tlayannga? Ən tagkurtaga, juujig vavvaan kǝ tlayannga. ");
INSERT INTO glwl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kwan wa vindava nǝ ǝlbǝg tǝghǝr taakiya, “ ‘Ən da ɓǝlgaan kǝ zǝrɓǝlgar tǝvuukwagha, kwada ɓadlak ɗuul lakuti agha da saaya.’ ");
INSERT INTO glwl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Ən tagkurtag kǝ jiira, ma huɗa uudah kwa yaa nǝ ǝnghwasaha, maay wa juujig kǝ Yuhwan dadda tsuufǝg dǝ ɗyakǝr biya. Bakǝva kwaha, daddakwa ǝngykwah ma tlǝksǝra ghǝrazhigǝl juujig kǝ iin dǝ ɗyakǝra. ");
INSERT INTO glwl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Cigǝt ma zamana Yuhwan dadda tsuufǝga damma kwanǝn kǝ zamana, tlǝksǝra ghǝrazhigǝl hǝɓa ba dlaɗ ma dǝva kǝlaadaha, lii vǝlgar dlaɗɗiina, iitǝr wanaa pǝrɗa tlǝksǝra ghǝrazhigǝl bad ndzǝɗa. ");
INSERT INTO glwl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Aɗaba adzahadzaha Muusa ard kakaɗa tlayanngaha baɗǝm tagardatag kǝ tlayanngǝr tǝghǝr kǝ tlǝksǝra ghǝrazhigǝl lakuti saay nǝ Yuhwana. ");
INSERT INTO glwl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Dlaɓa akwamam haiyamanthaig dǝ kwanǝna, Ili wa ndza tagavda nǝ ǝlbǝg tǝghǝr taakiya da saayna, iin nǝ Yuhwana. ");
INSERT INTO glwl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Dadda kwad hyǝmmiya, aa cinnga. ");
INSERT INTO glwl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ən da gǝrǝg dau nai kǝ kwanǝn kǝ zamani? Ar band zarhah cihurgan tǝ ɓala kasukwa ar ɗaa ghǝrahaatǝr ar taakiya, ");
INSERT INTO glwl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ ‘Kǝm fǝrtǝkura kǝ faakila, lamwalǝg kǝ shakalga, kǝm ɓǝlkura kǝ ǝngsa taa dzǝgwagha, lamwalǝg kǝ tuuga.’ ");
INSERT INTO glwl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Sahi ba nǝ Yuhwan dadda tsuufǝga maay zǝgaana maay hǝɓǝgaan biya, aiyam nǝ uurama, ‘Shatanah wa ma vǝghaana.’ ");
INSERT INTO glwl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Sahi ba nǝ Zǝra Uuda zǝgaana hǝɓǝgaana, ar taakiya, ‘Wayam dadda tlǝhuɗa ard dadda hǝɓa kya, tsaghwa lii cauwa hadama ard yaadadda haipaha.’ Bakǝvakwaha nǝghvaakanǝghǝg nǝ dabariya Daadamazhigǝl tǝdvad tlǝrahaana.” ");
INSERT INTO glwl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kaa cagtǝraacag nǝ Yesu kǝ gyi kǝ kǝsahi kwa ɓagaa nǝ iin kǝ dǝgaha jappǝr baɗyaka, aɗaba pǝlar bi kǝ ghǝr biya. ");
INSERT INTO glwl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Dǝga zhuwadaal kǝ sǝkǝgh Korazin! Dǝga zhuwadaal kǝ sǝkǝgh Betsaida! Akwama ɓagava ma Taya ard Sidun nǝ dǝgaha jappǝrahaanǝn ɓagavǝna vakaruwǝna, ma pǝlara bawur kǝ ghǝra. Maa tsǝgwarǝvtsǝgw kǝ akacakaca ar kutǝr kǝ aftsa. ");
INSERT INTO glwl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Aici wan tagkurtaga, daghuvala ta shariya da zhutǝrdaala kǝ Taya ard Sidun nǝ Daadamazhigǝla tǝghǝr kǝ sǝkurama. ");
INSERT INTO glwl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kǝgh Kafarnahuma! Magha tlǝg nǝng da fǝkaarafǝg nǝ uud damma ghǝrazhigǝla? Maaya! Da fǝkaara bi nǝ uud biya, agha dii ba kǝ kaara faya, akwama ɓagava ma Sadum nǝ tlǝra jappǝrahaan ɓagav ma kǝsaharuwǝna, maa ba ndzǝgaan gwastaana. ");
INSERT INTO glwl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aiciya wan tagkurtaga, daghuvala ta shariya, da zhuvardaala kǝ Sadum tǝghǝr kǝskǝgha.” ");
INSERT INTO glwl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ma sarta kwaha wa tagaa nǝ Yesu taakiya, “Ən tagak uus Daada, Yaazhigǝla ghǝrazhigǝl ard duniya, aɗaba shiɓǝghtǝrvashiɓǝg kǝ dǝgitahaanǝn kǝ lii dǝ dabariya ard lii sǝrgasǝrga, kaa martǝrdamarǝg kǝskǝghǝg kǝ zǝr zarhaha. ");
INSERT INTO glwl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Bandkwah, Daada, aɗaba kwan nǝ dǝgiti ɓagakaɓag kǝ marawa. ");
INSERT INTO glwl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Badǝm nǝ dǝgitaha, vǝlghwavǝlǝg nǝ Daadara. Maay wa sǝrgasǝrǝg kǝ Zǝriin biya bamma Daada. Dlaɓa maay wa sǝrgasǝrǝg kǝ Daadiin biya, bamma Zǝriina ard kwa haigant Zǝriin marardana. ");
INSERT INTO glwl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Asamasǝg sa vakara, baɗǝmaru lii kuɗaralkuɗǝga ard lii sǝpa kadlannga, ǝn kǝskuraran am tlǝkkǝna kǝ diyakuɗǝga. ");
INSERT INTO glwl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Cinngamcinng kǝ dǝgiti ǝn tagkur naiya, bandkwa bǝlvar nǝ zuuki ma kungy kǝ kawa uusǝga, am tsagaan dlaɓa vakara. Aɗaba kaiya ǝn kalaliya ǝn maay naaghǝr biya, dlaɓa am tlǝknatlǝg kǝ gabǝr ma ǝrviɗmahuɗaharuwa. ");
INSERT INTO glwl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Aɗɗaba zuukiyara ba tsaftsafa, kadlanngahara maay ɗǝmɗǝm biya.” ");
INSERT INTO glwl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Daghuvala faciya ngiiga Yahudaha, ghudadagal nǝ Yesu ard mbǝrzahaan ma guha hǝiya, ngal fǝgharzafǝg nǝ mbǝrzahaan kǝ kala ghǝra hǝiya ar zǝggaana aɗaba njǝtǝr waiya. ");
INSERT INTO glwl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nǝghara ba nǝ Farisiyah ǝndkwaha, am nǝ iitǝr taa kǝ Yesu, “Zharga, mbǝrzahagh ar ɓa dǝgiti dzah kǝ ɓagaan daghuvala ngiiga.” ");
INSERT INTO glwl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Aiyam nǝ Yesu taa kǝ iitǝra, “Mbats karantamabi kǝ dǝgiti ɓagaa nǝ Dauda ard lii ǝmtaɗ dǝ iin ma sartakwa ndza njitǝr nǝ waiy biya? ");
INSERT INTO glwl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kaa daas kǝ iin damma vǝgya Daadamazhigǝla kǝsant kǝ iin kǝ bǝruudi kwa favtǝra ba kǝrkangyǝkwa kǝ zhiila kǝsa uufah zuwa, vǝltǝr baz lii ǝmtaɗ dǝ iin kwa dzah zǝgaan kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nii karantamabi ha ma Adzahadzaha Muus kwa kǝlarda nǝ zhiila kǝssufah kǝ adzahadzaha ngiig ma vǝgya Daadamazhigǝla, mbats nal bi kǝ haip kǝ iitǝr biya? ");
INSERT INTO glwl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ən tagkurtaga, wan nǝ daddakwa juujig kǝ vǝgya Daadamazhigǝl vaakwana. ");
INSERT INTO glwl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Akwamamaa sǝrgasǝrǝg kǝ dǝgiti tuuk vakai nǝ ǝlbǝgahaan kwa taakiya, ‘Zhuwadaal wan naag naiya, kyuulǝg biya, mamaa maay ghaza daddakwa maay dǝ haip biya.’ ");
INSERT INTO glwl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Aɗaba Zǝra Uuda iin yaazhigǝla faciya ngiiga.” ");
INSERT INTO glwl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kaa ɗugarsɗuug kǝ Yesu kǝ vakavakintsa, ngal daas kǝ iin damma guda dzǝgwazhigǝlatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ndza mǝng nǝ uuda nǝ iin ǝmtsamǝmtsan nǝ dǝv vakwahiina, kaa ndavgarundavǝg kǝ iitǝr kǝ Yesu, taakiya, “Haighanthaig nǝ adzahadzah mbǝvna nǝ uuda daghuvala Faciya Ngiiga?” Ndavararu kwakyarvad ar tlǝkǝna kǝ iin dǝ haipa. ");
INSERT INTO glwl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Aiyama taa kǝ iitǝra, “Akwama mǝng nǝ daddakwa dǝ tuugh pal makurama, ma dahi damma afǝkka daghuvala Faciya Ngiiga, mbats maay kǝsgaan nǝ dadda tuughǝn sagat biya? ");
INSERT INTO glwl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Abi ndanng ba nǝ uud tǝghǝr kǝ tuugha. Mbakyarvad kwaha kalkalan ɓagvǝna nǝ harǝr daghuvala Faciya Ngiiga.” ");
INSERT INTO glwl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aiyama taa kǝ uudanena, “Vǝlǝg kǝ dǝvaagha.” Kaa vǝlgaan kǝ iin kǝ dǝvaana, ngal mbǝg kǝ dǝvaan bandkwa pallna. ");
INSERT INTO glwl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kaa dagal kǝ Farisah da diya sawariya ma taatakatǝra tǝghǝr kǝ ɗuuli ar da tsǝg nǝ iitǝr kǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nǝghǝghaaka ba nǝ Yesu ǝndkwaha, ngal ɗuugarsɗuug kǝ iin kǝ vakavakiina, kaa gatǝgaan kǝ uudah badyaka, mbahtǝra kǝ lii yanng bi baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ɓǝltǝra kǝ magi taakiya, aa tagarar bi aanji ǝndwar biya. ");
INSERT INTO glwl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tǝdvad kwan wa righavant nǝ dǝgiti tagada nǝ tlayang Ishaya taakiya, ");
INSERT INTO glwl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Wan kwatnahar kwa kǝsanaaka naiya, ǝn waigaana, ǝn cinngaan kǝ ǝmtakǝraan ba vaivaya. Ən da righǝgaan dǝ shǝɗkwara, iin wada tagtǝr ǝlbǝga shariya jiir kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Da maay ɓala agajaw bi taa ǝlbǝg dǝ caagyi biya, da cinngvabi nǝ ghaiyaan tǝ ɗuul biya. ");
INSERT INTO glwl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Da maay kǝla ghuvi hǝrzh kǝ kǝlǝg biya, da maay ǝmtsa kaara jahurambi kwa hǝrz kǝ ǝmtsǝg biya, bamma da fǝgharaafǝg kǝ jira zuu kǝ fiira. ");
INSERT INTO glwl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Fantara uuda dǝgshiga ba tǝ ɗaagaana.” ");
INSERT INTO glwl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kaa sǝdǝvsǝg nǝ uudah kǝ makwai kwa mamghant nǝ shatanaha dlaɓa gulfa da vak Yesu, ngal mbǝnan kǝ iin kǝ uuda nǝ iina, farhza kǝ taaghai kaa nǝghǝganǝgha. ");
INSERT INTO glwl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kaa ɓa japǝr kǝ dlamaa kǝlaaw baɗǝmma, aiyam nǝ iitǝra, “Aitsa Zǝra Dauda bi wan kwanya?” ");
INSERT INTO glwl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Cinngara ba nǝ Farisiyah ǝndkwaha, aiyam nǝ iitǝra, “Abi lagw dǝ ndzǝɗa Baˈalzabul tlǝkǝsa shatanaha nǝ uudanǝn kǝ shatanaha.” ");
INSERT INTO glwl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nǝghaakanǝghǝg nǝ Yesu kǝ dzama ghǝraatǝra, aiyama taa kǝ iitǝra, “Baɗǝm nǝ tlǝksǝri tagwazhatagw hutsǝg buwa ar ɓa tlǝghum dǝ ghǝrahaatǝra, kwanǝn kǝ tlǝksǝr da zǝlma biya, bandkwah dlaɓ nǝ kǝsa bi hǝnnyah ma tagwazhatagw hutsǝg buwa, ar ɓa tlǝghum dǝ ghǝrahaatǝra da badzǝga. ");
INSERT INTO glwl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Akwama lagwan nǝ shatanah kǝ shatanaha, ɓa uushav dǝ ghǝraana, da ɓag ndar kaci nǝ tlǝksǝraan kǝ ndzǝɗi? ");
INSERT INTO glwl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Akwaman lagw dǝ ndzǝɗa Baˈalzabul nai kǝ shatanaha, mbǝrzaharuwum? Ar lagw dǝ ndzaɗa wari? Mbǝrzaharuwa wa da tǝkur shari tǝghǝr kwanǝnna. ");
INSERT INTO glwl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Akwaman lagw dǝ ndzǝɗa Shiɗkwa Daadamazhigǝla nai kǝ shatanaha, mbats tlǝksǝra Daadamazhigǝla sǝghawiisǝg da tǝghǝr kǝskurama. ");
INSERT INTO glwl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Maay wa dǝgaadǝg da vǝgya dadda ndzǝɗ hutsavarvan nǝ almanan biya, ba zǝnngwa bamma takwasavant nǝ dadda ndzǝɗǝna, lakuti hutsǝvarvahutsǝg nǝ almanana. ");
INSERT INTO glwl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Daddakwa maay ǝmtaɗ dǝ kai biya, tlǝghumar nǝ iina, dlaɓ daddakwa mǝlghwad bi kǝ dzahgaan biya, kwazǝg bad kwazǝga. ");
INSERT INTO glwl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mbakyarvad kwaha, ǝn tagkurtaga, da ɓǝshivtǝrnaɓǝshig kǝ uudah aanji hulfa kwar kǝ haip ard badza ɗaaga kwa ɓagara nǝ iitǝra, aiciya, daddakwa badza ɗaaga Shiɗǝkwa Daadamazhigǝl da ɓǝshvarna biya. ");
INSERT INTO glwl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Akwama tagadatag nǝ uudan kǝ ǝlbǝga nennig tǝ Zǝra Uuda da ɓǝshvarnaɓshiga, aiciya, baɗǝm nǝ daddakwa nǝnna Shiɗkwa Daadamazhigǝla da ɓǝshvarna bi ba dǝm biya. ");
INSERT INTO glwl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Uuf marawa yaa zǝr marawa, uufi ghwaɗa yaa ba zǝr ghwaɗa, ma kwar kǝ uufa nǝghvaakanǝghǝg tǝdvad zarhaana. ");
INSERT INTO glwl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kuram faɗǝga ghavalahaan kǝlaadahna, am da tag ndar nǝ uuram kǝ dǝgitah maraw kuram ndakwani am kǝladahi? Abi, dǝgiti ma ǝrviɗmahuɗ wa tag nǝ ghaiya. ");
INSERT INTO glwl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Uuda jiira ba jiir wa sagal ma ǝrviɗmahuɗaana, uudi kǝlaada ba kǝlaadǝr wa sagal ma ǝrviɗmahuɗaana. ");
INSERT INTO glwl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ən takurtaga, baɗǝm nǝ ǝlbǝgah ghwaɗ kwa tagarda nǝ uudaha, ar da tagaan daghuvala ta shariya. ");
INSERT INTO glwl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Aɗaba tǝdvad ǝlbǝgahagh wada tak nǝ uud kǝ shariya, bi da maay nǝ uud ghazakghazǝg biya, bi da ghazǝka nǝ uuda.” ");
INSERT INTO glwl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Am kyalǝma lii tsaga adzahadzah ard Farisiyah taa kǝ Yesu, “Dadda tsaga dǝgita, makǝmaa naagaan magha markǝmndadan kǝ dǝga sǝrga.” ");
INSERT INTO glwl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ngwatǝrangug nǝ Yesu amaa, “Uudaha zamana ar kǝlaadaha, dlaɓa ar za lanngiya Daadamazhigǝla. Ar gata maa marǝvtǝrda nǝ dǝga sǝrga, maay watlǝrǝn kǝ dǝga sǝrgi da marǝvtǝrmarǝg biya, bamma dǝga tlayang Yunana. ");
INSERT INTO glwl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bandkwa ɓagaa nǝ Yunan kǝ hǝng hǝkǝrɗ baz avǝɗ baz faci ma huɗa kilfa. Da bandkwah dlaɓ nǝ Zǝra Uud da ɓa hǝng hǝkǝrɗ baz avǝɗ baz faci ma kusǝgha haaya. ");
INSERT INTO glwl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Daghuvala ta shariya, uudaha Neneva ar da ciig ǝmtaɗ dǝ uudaha zamana, ar martǝrda kǝ uudaha zamanǝn taakiya ar ghazaghazana, aɗaba pǝlara mbakyarvad ǝlɓǝg marawǝn tagada nǝ Yunan nǝ iitǝr kǝ ghǝra. Wan ci, nǝ daddakwa juujig kǝ Yunan vaakwana. ");
INSERT INTO glwl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Daghuvala ta shariya, da ciig nǝ tlǝkǝssa Sheba uusa ǝmtaɗ dǝ uudaha zamanǝna. Martǝrdan taakiya ghazaraghazǝga, aɗaba ghǝravaana sal vaka bǝtky sa cinnga dabariya Salumana. Wan ci, daddakwa juujig kǝ Salumana vaakwana.” ");
INSERT INTO glwl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Akwama salsǝg nǝ Shatanah ma vǝgha uuda, kaa gwaiyav kǝ iin gata vakavaka ɗiyakudǝg tlakǝna biya, aɗaba maay nǝ yu vakavaka kwahiin biya. ");
INSERT INTO glwl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ngal ba tagan taakiya, ‘Ən guya daas da vakavaki sanal naiya.’ Akwama guyaagwig daasa, tlǝgharaatlǝg kǝ hǝnyahǝn maay aanji ǝndwar biya, dlaɓa hyaɗahyɗana ɓadlaɓadlana. ");
INSERT INTO glwl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kaa dagal kǝ iin dzǝgdaan kǝ kwatlǝrǝn kǝ shatanah uuɗiffa kwa jaruujig kǝ iin dǝ kǝlaadǝra, kaa daas kǝ iitǝr ar ndzan vaakwaha. Tǝhalakwaha ndzǝgana uudanǝna, da jǝguujig kǝ ndzǝganaanǝn ndza wurǝn kǝ badzǝga. Da bandkwah dlaɓ nǝ uudaha zamanǝn dǝ kǝlaadǝra.” ");
INSERT INTO glwl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tǝghǝrdǝga tagtǝr ǝlbǝg nǝ Yesu kǝ uudaha, kaa sagau kǝ babbaana ard zarha babbaan ar ghacan gyimala, ar naa taaghai dǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Am nǝ uuda nǝ iin taa kǝ Yesu, “Wai baabagha ard dǝ zarhabaabagh ar ghacga gyimala, ar naa taaghai dǝ kǝgha.” ");
INSERT INTO glwl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Aiyam nǝ Yesu taa kǝ uudanǝnna, “War nǝ baabara ard zarha baabarni?” ");
INSERT INTO glwl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kaa maraa mbǝrzahaan kǝ iin dǝ dǝva aiyama, “Wan nǝ baaba ra ard zaraabahar vaakwana. ");
INSERT INTO glwl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Baɗǝm nǝ daddakwa ɓa dǝgiti naag nǝ daadar kwa ma ghǝrazhigǝla, iin zǝraabara, ard dǝghwa baabara ard baabara.” ");
INSERT INTO glwl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ba daghuvala kwahiin kǝ faciya, kaa sǝgalsǝg nǝ Yesu hǝnyahiina, ngal dagal kǝ iin cǝhuran tǝ ghaiya yuwa haiya. ");
INSERT INTO glwl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kaa faɗav kǝ uudah baɗyak sa tǝghǝr kǝ iina, mbakyarvad kwaha kaa daas kǝ iin damma pɛra yuwa cǝhurana. Kaa ghacgaghacǝg kǝ uudah tǝ ghaiya gardza. ");
INSERT INTO glwl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kaa tagtǝrtag kǝ iin kǝ dǝgitah baɗyak dǝ garava, amaa, “Mǝng dadda riig kwa dal da riiga. ");
INSERT INTO glwl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Riig nǝ iina, kaa ɓalgalɓalǝg kǝ kyalǝma hulf dat ɗuula, kaa caguucag kǝ ɗiikaha. ");
INSERT INTO glwl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kyalǝm ɓalal dat caccahǝlaw vakavaki maay nǝ haay ɗyak biya, kaa laghǝr ba watswatsa aɗaba maay nǝ haay ɗyak biya. ");
INSERT INTO glwl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ghwut ba nǝ faciya, ngal fuug kǝ iitǝra, aɗaba baharabi kǝ tlali vaivai biya, kaa ghulǝg kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kyalǝm ɓalal damma takka, kaa ghwubararaa nǝ takka, tsarva kǝ ɓǝlauwa. ");
INSERT INTO glwl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kyalm ɓalal dat haay marawa, kaa ya zǝr dǝrmǝkka, kyalǝm kul ǝngkwaha, kyalǝm dlaɓ kul hǝkǝrɗa. ");
INSERT INTO glwl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Dadda kwad hyǝmiya cinngaana aa cinnga.” ");
INSERT INTO glwl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kaa dagau kǝ mbǝrzah davakaan ar ndavaru taakiya, “Aujibǝg agha tagtǝr bad garav kǝ ǝlbǝg kǝ uudahi?” ");
INSERT INTO glwl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kaa ngutǝraangug kǝ Yesu, amaa, “Haiyakuranthaig nǝ uud am sǝra kǝ dǝgiti shǝɓashǝɓan ma tlǝkǝsǝra Daadamazhigǝla, kiyava iitǝra vǝlavtǝr biya. ");
INSERT INTO glwl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aɗaba baɗǝm dadda kwad dǝgita, da fǝvarnaafǝga baɗyaka, dlaɓa da jǝguujig tǝ iin ba vaivaiya, dadda kwa maay dǝ vakai biya, da kǝsvarǝvkǝssǝg aanji ba hǝɗikǝni dǝ vakai nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","In wan tagtǝr nai kǝ ǝlbǝg dǝ garavna, “ ‘Aanji ar vazǝgaana ar nǝghǝga biya, aanji ar cinngaana, ar cinnga biya dlaɓa ar nǝghǝgaaka biya.’ ");
INSERT INTO glwl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Righǝtrighǝg nǝ tlayangngǝra Ishaya tǝghǝr kǝ iitǝr taakiya, “ ‘Am da cinngaana am da cinngaaka biya, am da vazǝgaana, ba dǝm am da nǝghǝgaaka biya. ");
INSERT INTO glwl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Aɗaba uudahaan ba dǝkdǝk nǝ ǝrvidmahuɗaatǝra, ar cinnga ba dlah dǝ hyǝmiyahaatǝra, dlaɓa ar hǝɗardu kǝ gyiyahaatǝra. Maa maay ǝndkwah biya, maraa nǝghǝganǝg dǝ gyiyahaatǝra, maraa cinngacinng dǝ hyǝmiyahaatǝra dlaɓa maa nǝgharaakanǝghǝg ma ǝrvidmahuɗaatǝra ar pǝla kǝ ghǝra ǝn mbǝtǝrnana.’ ");
INSERT INTO glwl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Bark nǝ gyiyaharuwa aɗaba ar nǝghǝganǝghǝga, dlaba hyimmǝyaharu ar cinngacinnga. ");
INSERT INTO glwl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Bak jiira ǝn tagkurtaga, tlayangaha ard uudaha jirjira ba ɗyaka, naharnahǝg kǝ vazza dǝgiti nǝghama nǝ uurama, nǝghara biya, ard dǝgiti cinngama nǝ uurama, cinngara biya. ");
INSERT INTO glwl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Wan nǝ dǝgiti tuuk vakai nǝ garava dadda riigna. ");
INSERT INTO glwl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Badǝm dadda kwa cinnghacinng kǝ ǝlbǝg tǝghǝr kǝ tlǝksǝra, dlaɓa nǝghaaka biya. Kaa sagau kǝ shatanaha ghǝldan kǝ ǝlbǝgǝn sagal ma ǝrviɗmahuɗaana, kwanǝn kǝ hulfa iin wa ɓalal dat ɗuula. ");
INSERT INTO glwl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Hulfǝn ɓalal dat caccahǝlawna, iin garava uudahanǝn cinngaracinng kǝ ǝlbǝgna, dlaɓa dlǝgharadlǝghǝg bad hwaɗǝga. ");
INSERT INTO glwl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Aɗaba baabi kǝ tlali biya, fadghǝraan ba dǝga sart hǝɗiikǝna, sǝghǝv ba dlaɗ kwakyarvad ǝlbǝgiina, kaa tagwzhatagw kǝ iin dǝ fadghǝrana. ");
INSERT INTO glwl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Hulfǝn kwa ɓalal damma takkǝna, iin garava uudi cinnghacinnga kǝ ǝlbǝga Daadamazhigǝla, dzama kadlannga duniya ard hyahǝra, tsǝgharvatsǝg kǝ ɓǝlauwa yaa bi kǝ zǝr biya. ");
INSERT INTO glwl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Hulfǝn riyava tǝ haay marwna iin garava dadda kwa cinnghacinnga kǝ ǝlbǝga Daadamazhigǝla dlaɓa nǝghǝghaakanǝghǝga, ngal yaa kǝ zǝra, kwana dǝrmǝkka, kwana kul unkwaha, kwana kul hǝkǝrɗa.” ");
INSERT INTO glwl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Vǝlatǝrvǝlǝg nǝ Yesu kǝ kwatlǝrn ke garava, amaa, “Da gǝrav nǝ tlǝksǝra ghǝrazhigǝl dǝ uudi riiya hulf maraw ma guhaana. ");
INSERT INTO glwl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma sartǝn hǝnna haar nǝ uudah baɗǝmma, kaa dagal kǝ dadda tlǝghuman riiyars kǝ dlǝgh miizhangyil hǝiyina, ngal dasaana. ");
INSERT INTO glwl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ghubara ba nǝ hǝiya yaak kǝ zǝra, dlǝgh ndakwani ghubaraghubarga. ");
INSERT INTO glwl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Kaa sagau kǝ kwatnahahaan ar tagar kǝ dadda hǝnyahaatǝr taakiya, ‘Dadda hǝnyaha, mbats hulf maraw bi wa riigha nǝng ma guhaghǝn biya? Aa sǝga ndar ka ci nǝ dlǝghi?’ ");
INSERT INTO glwl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Aiyama taa kǝ iitǝra, ‘Dadda tlǝghum wa ɓagaa kwaha.’ “Aiyam nǝ kwatnahaan taa kǝ iin, ‘Agha naagaan kǝm taɗdan kǝ dlǝghahaana?’ ");
INSERT INTO glwl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Amaa taa kǝ iitǝra, ‘Taɗam biya, aa nali vaka taɗa dlǝgh kǝskuram am taɗdan baz hǝi biya. ");
INSERT INTO glwl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Aɗuwamtǝrɗuug aa ghubararghubarg ba ǝmtaɗ tangw damma sarta ghuda hǝiya, ma kwah kǝ sarta ǝn da tagtǝrtag nai kǝ lii ghuda hǝiya ar da farzha aghwa dlǝgha ar ngwaɗant aɗagwal aɗagwala hǝvars kaara, dzahvant nǝ hǝiya ɗiivǝdǝm damma kuvǝra.’ ” ");
INSERT INTO glwl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Vǝlatǝrvǝlǝg nǝ Yesu kǝ kwatlǝrn kǝ garava, amaa, “Tlǝksǝra ghǝrazhigǝla band hulfa zǝra mastad kwa riiya nǝ uudan ma guhaana. ");
INSERT INTO glwl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Iin wa mishish ma hulfah badǝmma, akwama ghubaraghubarga, juguujig kǝ dǝgitahi riiva ma ɗyaghar baɗǝmma kaa nǝg kǝ uufa, kaa ɓa vǝgyahaatǝr kǝ ɗiikah tǝ dǝvahaana.” ");
INSERT INTO glwl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Gwiya vǝlatǝrvǝlǝg nǝ Yesu kǝ kwatlǝrn kǝ garava amaa, “Tlǝksǝra ghǝrazhigǝla band yista kwa kǝɗghant nǝ uusiin dǝ taasa ahupi hǝkǝrɗa, kaa uushigǝtuushig kǝ ahupiyin baɗǝm dǝ yistina.” ");
INSERT INTO glwl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tagatǝrtag nǝ Yesu kǝ dzahava uudah baɗǝm kǝ dǝgitah dǝ garava. Maay nǝ dǝgiti tagatǝr nǝ iin kwal garav biya. ");
INSERT INTO glwl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tǝdvad kwan wa rǝghvant nǝ dǝgiti tagada nǝ tlayang Ishaya taakiya, “Ən da tagaan kǝ ǝlbǝg dǝ garavaha, dǝgiti ndza shǝɓashǝɓan gwil fǝgarzha duni, ǝn da tagaana.” ");
INSERT INTO glwl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kaa ɗutǝrǝsɗuug nǝ Yesu kǝ dzahava uudaha, kaa daas kǝ iin da hǝnyaha. Ngal tlǝgaraatlǝg kǝ mbǝrzahaana, am nǝ iitǝr taa kǝ iina, “Tagkǝmndtag kǝ dǝgiti tuuk vakai nǝ garava dlǝgh ma guhna.” ");
INSERT INTO glwl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kaa ngutǝrangug nǝ Yesu amaa, “Dadda kwa riiya hulf marawa, iin Zǝra Uuda. ");
INSERT INTO glwl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Guhna iin nǝ duniya, hulf marawna, iin zarha tlǝksǝra Daadamazhigǝla. Dlǝghna iitǝr zarha shatanah. ");
INSERT INTO glwl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Dadda tlǝghumǝn riiya dlǝghna, iin shatanaha. Sarta ghwuda hǝina, iin ghyǝnnga duniya, lii ghuda hǝiya iitǝr nǝ zarhaɓǝlga Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Bandkwa dzahav nǝ dlǝgh hǝvars nǝ kaara, da band kwah daghuvala ghyǝnnga duniya. ");
INSERT INTO glwl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Da ɓǝlgaan Zǝra Uud kǝ zarhaɓǝlgaana, ar da dzahaant baɗǝm kǝ dǝgitahi fǝgara uudah kǝ ɓa haipa, baz lii ɓa tlǝra kǝlaɗǝr baɗǝmma, ar da lagwtǝrda dagal ma tlǝksǝraana. ");
INSERT INTO glwl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ar da ɗiitǝrdǝm damma kaara faaya, vakwaha ar da tuuga ar da ghwada dǝv dǝ tlǝrɗa. ");
INSERT INTO glwl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tǝhalakwaha ar da mbiig band faciya nǝ uudaha jiirjiira ma tlǝksǝra daddaatǝra. Dadda kwa dǝ hyǝmiya cinngaana aa cinnga. ");
INSERT INTO glwl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Tlǝksǝra ghǝrazhigǝla band almani kwa shiɓavǝna ma guuha, kwa tlǝkǝna nǝ uudana ngal gwiya shiɓnanna, mbakyarvad ɗyakǝra hwaɗaga kaa valǝt kǝ dǝgahaani dǝvakai nǝ iin baɗǝmma, ngal sǝgwa kǝ guuhiina. ");
INSERT INTO glwl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Gwastǝna, tlǝksǝra ghǝrazhigǝla band zǝra kasǝkwa, kwa gata akura ndannga. ");
INSERT INTO glwl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tlǝkǝna ba nǝ iin kǝ akurǝn ndanng pal ba vaivaina, ngal valǝt kǝ dǝgahaan baɗǝm sǝgwa kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Gwastǝna dlaɓa, tlǝksǝra ghǝrazhigǝla band amshiya vaiya kilfa kwa ɓǝlavdǝm damma yuwahaiya, vaiyitvaig kilfah shahshaha. ");
INSERT INTO glwl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Righǝt ba nǝ iina, ngal tǝɗdatǝɗǝg kǝ yaa dadda vaiya kilf dat ghaiya gardza, ar dzǝraakan kǝ kilfahi marawa, ar ɗiivǝdǝm damma alghwa ɗiivǝdan nǝ wa maraw biya. ");
INSERT INTO glwl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Da band kwah daghuvala ghyǝnnga duniya, ar da sagau nǝ zarhaɓǝlga Daadamazhigǝla, ar da tagwtǝrzha kǝ kǝlaadah sagal ma uudaha jiirjiira. ");
INSERT INTO glwl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ar da ɗiitǝrdǝm kǝ kǝlaadah damma kaara faiya, vakavaki ar da tuug nǝ iitǝra ar ghwada dǝv dǝ tlǝrɗa.” ");
INSERT INTO glwl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Am nǝ Yesu taa kǝ iitǝra, “Nǝghamaakanǝghǝg kǝ kwanahaan baɗǝmma?” Kaa ngug kǝ iitǝra takiya, “Aana.” ");
INSERT INTO glwl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aiyama taa kǝ iitǝra, “Mbakyarvad kwaha baɗǝm dadda tsaga adzahadzaha kwa nalnǝg kǝ mbǝrz ma tlǝksǝra ghǝrazhigǝla, band dadda hǝnyaha kwa sadda daala almana ard ǝnghura alman vaka fǝgaana.” ");
INSERT INTO glwl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ghyǝnng ba nǝ Yesu tagtǝr dǝgitah dǝ garava, kaa dagalaan kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Dagha ba nǝ Yesu damma kǝssana, kaa fǝgarzhafǝg kǝ iin tsagtǝr dǝgit kǝ uudah ma guda dzǝgwazhigǝlaatǝra, kaa ɓa jappǝr kǝ iitǝra, ar taakiya, “Aa tlǝkǝna mǝr nǝ uudanǝn kǝ hulfa kwan kǝ dabari ard dǝ ndzǝɗa ɓa tlǝraha jappǝrni? ");
INSERT INTO glwl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Zǝra kafintini wan kwan biya? Babbaani wa ɗahav dǝ Maryam biya? Zarhaababani nǝ Yakuba, Isuvu, Siman ard Yahud biya? ");
INSERT INTO glwl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Dughwaha babbaan bi wa ǝmtaɗ dǝ kǝmyamǝn biya? Tlakǝnamǝr kaci nǝ iin kǝ kwanahaan baɗǝmmi?” ");
INSERT INTO glwl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kaa badzǝg kǝ ǝrvidmahuɗatǝra. Am Yesu taa kǝ iitǝra, “Bamma kǝsaana ard hǝnyhaan wa maay nǝ tlayanng dǝ ndanng biya.” ");
INSERT INTO glwl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ɓagaa bi nǝ iin kǝ dǝgaha jappǝr ɗyak vakwah biya, adaba ar maay dǝ fadghǝr biya. ");
INSERT INTO glwl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ma sarta kwah wa cinngha nǝ Tlǝkǝs Hirudus kǝ ǝlbǝg tǝghǝr kǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Amaa taa kǝ kwatnahahaana, “Kwan kǝ uuda, Yuhwan dadda tsuufǝg waa ciigǝt ma gǝtlaha, iin waa tlǝkǝna nǝ iin kǝ ndzǝɗa ɓa dǝgaha jappǝrahaana.” ");
INSERT INTO glwl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Aɗaba ndza viyǝtviig nǝ Hirudus kǝ Yuhwana, takwasanta, ɓǝldǝm damma guda bǝrfin kwakyarvad Hirudiya, uusa zǝra babbaan Filigusa. ");
INSERT INTO glwl_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Aɗaba ndza tagartag nǝ Yuhwan kǝ Hirudus taakiya, kalkalaan bi kǝ iin kǝssa Hirudiya biya. ");
INSERT INTO glwl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Bakǝvakwaha nahanahǝg nǝ Hirudus kǝ tsa Yuhwana, ndza gǝdza gyiya uudaha, aɗaba haiyaranthaig nǝ uudah taakiya tlayanga nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sǝgha ba nǝ sarta ɓa kwaanda Hirudusa, kaa shakalǝg kǝ dughwa Hirudiya tǝ vuukwa ghulabaha, fǝgharaafǝg kǝ Hirudus kǝ cinnga ǝmtaakǝr ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tǝgharatǝg kǝ langyiya baz zǝgara gwaɗǝg taakiya, da vǝlǝgarvǝlǝg kǝ dǝgiti ghalǝg nǝ iin baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ngal diigaradiig nǝ babbaan kǝ sawariya dǝgiti da tag nǝ iina, amaa, “Aa vǝlwavǝlǝg nǝ uud kǝ ghǝra Yuhwan dadda Tsuufǝg bandakwan ma kwatama.” ");
INSERT INTO glwl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Cinnguu bi nǝ tlǝkǝs kǝ ǝmtakǝra ǝlbǝgiin biya, aɗaba mbakyarvad ngwaɗǝgi zaa nǝ iin tǝvuukwa ghwulabahaana, ngal tagaan kǝ iin taaki aa vǝlvarvǝlǝg nǝ dǝgiti naag nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ɓǝlant kǝ uud damma guda bǝrfina ghudva ghǝr tǝ Yuhwana. ");
INSERT INTO glwl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Sǝvdaa nǝ ghǝraan ma kwatama, vǝlǝvar kǝ dughwiina, kaa lanngardaa kǝ iin kǝ babbaana. ");
INSERT INTO glwl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kaa sagau kǝ mbǝrzaha Yuhwana ar kǝssant kǝ tlǝwa vǝghaan ar hǝɗǝnana, tǝhala kwaha ngal daagal kǝ iitǝr ar tagar kǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Cinngha ba nǝ Yesu ǝndkwaha, kaa daas kǝ iin damma pɛra yuwa, ngal dagal da vakavaki maay aanji ǝndwar biya, ndzan ba daghuvaana. Cinngara ba nǝ uudaha, kaa sagal kǝ iitǝr ma kǝssahaatǝra, ngal dagal kǝ iitǝr gatǝgaana. ");
INSERT INTO glwl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sǝghal ba nǝ iin ma pɛra yuwa, kaa nǝghǝganǝghǝg kǝ iin kǝ uudah ba ɗyaka. Ngal zhutǝrdaalazhuuga, dlaɓa mbǝhtǝra kǝ lii yang bi ma iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Dǝm ba faci kǝ ɓǝladaaya, kaa dagau kǝ mbǝrzahan da vaakana, am nǝ iitǝra, “Kwan kǝ vakavaka maay aanji ndǝwar biya, dlaɓa hǝrz faci kǝ ɓǝladaaya. Ɗutǝrsɗuug kǝ uudaha kiyava dagal kǝ iitǝr damma kǝsah ar gatu kǝ dǝgzǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Aiyama nǝ Yesu taa kǝ iitǝra, “Maay nǝ tlǝra dagalaatǝr biya. Vǝlamtǝrvǝlǝg nǝ uuram kǝ dǝgzǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Am nǝ iitǝra taa kǝ iina, “Dǝgiti vakamnd vaakwana, ba bǝruudi dlǝɓa ard kilf bu kaltiya.” ");
INSERT INTO glwl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Aiyama, “Anakam da vakara.” ");
INSERT INTO glwl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ngal tagtǝrtag kǝ iin kǝ uudah aa cahwararacahwarǝg tǝ kazhakwa, kaa kǝsgantkǝsǝg kǝ iin kǝ bǝruudi dlǝɓ ard kilf buwa, dzǝgant kǝ iin kǝ ghǝraan damma ghǝrzhigǝla, tagar kǝ uus kǝ Daadamazhigǝla. Tǝhalakwaha, lahǝna kǝ bǝruudina vǝltǝr kǝ mbǝrzahana ar tagwtǝrna kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Baɗǝmmaatǝr zaruuzǝga tlatǝrtlǝga, ar dzahaant nǝ mbǝrzahaan kǝ ghwadǝgahaani tǝmaatǝmga, righantrighǝg kǝ alghw kǝlaawa tar buwa. ");
INSERT INTO glwl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Uudahi zaruuzǝga tamaha ghwalvah alfu dlǝɓa, maay ba nǝ zǝrha ard ǝnghwasah biya. ");
INSERT INTO glwl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Bad ghyǝngaatǝr waha, kaa fǝtǝraafǝg nǝ Yesu kǝ mbǝrzahaan damma pǝra yuwa, kiyava dagal kǝ iitǝr zungw tǝghǝr kǝ iin dat ghyaba kwah kǝ gardza, aɗaba paka salama uudah nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tǝhalakwa salamada nǝ iin kǝ uudaha, ngal dagat kǝ iin da dzǝgwazhigǝla ma aghw ba daghuvaana, ɓǝlgharaaɓǝlǝg baz avǝɗ vaakwah ba daghuvaana. ");
INSERT INTO glwl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ma kwahiina sarta ndza ma taataka yuwahaiya nǝ pɛrayuwa, kaa tsǝgaan kǝ fǝɗ kǝ ghubǝɗǝga yu dat pɛrayuwa, aɗaba ndza ba gyar nǝ fǝɗ dǝ pɛrayuwa. ");
INSERT INTO glwl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tamaha karfe hǝkǝrɗa avǝɗa, kaa happa dagal kǝ Yesu tǝghǝra yuwa da vak mbǝrzahaana. ");
INSERT INTO glwl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nǝghara ba nǝ mbǝrzahaan kǝ iin happa dagal dǝ shig tǝghǝra yuwa, kaa gǝdzǝg kǝ iitǝra. Ar hulǝg mbakyarvad dladlawa ar taakiya, “Dadda kwa sǝgal tǝ afka.” ");
INSERT INTO glwl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bat watsǝra, kaa tagtǝrtag kǝ Yesu taakiya, “Ndavam biya, ba kaiya, gǝdzam biya.” ");
INSERT INTO glwl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kaa ngug kǝ Bitrus amaa, “Yaazhigǝla, akwama ba kǝgha, ɗaakwaɗaag sa vakaagh tǝghǝra yuwa.” ");
INSERT INTO glwl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Aiyam nǝ Yesu, “Asǝga.” Kaa sagal kǝ Bitrusa ma pɛrayuwa, farzha kǝ dagal tǝghǝra yuwa da vak Yesu. ");
INSERT INTO glwl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nǝghǝgha ba nǝ iin kǝ fǝɗ ciyǝtciig bad ndzǝɗa, kaa gǝdzǝg kǝ iina aɗaba fǝgharzhafǝg nǝ yu kǝ ndǝgaana. Kaa huulǝg kǝ iin amaa, “Katkwakatǝg, Yaazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Bat watsǝra kaa vǝlǝgaan kǝ Yesu kǝ dǝvaan viyita, aiyama “Kǝgh dadda hǝtsahǝtsan nǝ fadghǝrna, aujilbǝg agha ɓa ndawndawi?” ");
INSERT INTO glwl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Daragha ba nǝ iitǝra damma pɛrayuwa, kaa kyaɓalgakyaɓalǝg kǝ fǝdna. ");
INSERT INTO glwl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kaa ɓagarnǝsɓag nǝ lii ma pɛrayuwǝn kǝ kwatnahǝr kǝ Yesu, ar taakiya, “Bak jiijiira agha Zǝra Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Dzǝvara ba nǝ iitǝr kǝ yuwa haiya, ar tsugwa ma Janisarat. ");
INSERT INTO glwl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nǝgharaaka ba nǝ uudaha kǝsiin kǝ Yesu, kaa bǝla ghai kǝ iitǝr damma kǝsahi tǝghǝr kǝ iitǝr baɗǝmma, ar sardǝv kǝ lii yang bi badǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kaa ghalgaan kǝ iitǝr maa ɗuutǝrnaa kǝ lii yang bi maraa tapnan aanji ghaaya sǝɗavaana, baɗǝm lii taparnatapǝga mbaharambahǝga. ");
INSERT INTO glwl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tǝhalakwaha kaa sagau kǝ kyalǝma Farisiyaha ard lii tsaga adzahadzah sagal ma Wurshalim da vak Yesu am nǝ iitǝra, ");
INSERT INTO glwl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Aujilbǝg kǝ mbǝrzahagh ar kǝlla dǝga daadijaha tlǝvuukwahi? Aɗaba ar maay bara dǝv lakwti ar da zaa kaf biya.” ");
INSERT INTO glwl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Aiyam nǝ Yesu taa kǝ iitǝra, “Kuramǝm, aujilbǝg kǝskuram am kǝlla adzahadzaha Daadamazhigǝl kwakyarvad dǝga daadijahawi? ");
INSERT INTO glwl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Am nǝ Daadamazhigǝla, ‘Faarafǝg kǝ daadagh ard baabagha,’ dlaɓa ‘Baɗǝm dadda ɗaava daddaana bi babbaana, barari tsavva.’ ");
INSERT INTO glwl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kuram am tsagtǝrtsag kǝ uudah taakiya, akwama mǝng nǝ uudani dǝ dǝgit kwada mǝlgaru kǝ daddaana bi babbaana, ngal tagaan taakiya, ‘Baɗǝm nǝ dǝgiti mammaa da tlǝkǝna nǝ uuram vakara, fanarafǝg kǝ Daadamazhigǝla.’ Mbakyarvad kwaha fǝghaara bi kǝ daddaan ard babbaan dǝvakai biya. ");
INSERT INTO glwl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mbakyarvad dǝgaha daadijaruwa, namdalnǝg nǝ uuram kǝ ǝlbǝga Daadamazhigǝl kǝ dǝga lakǝra. ");
INSERT INTO glwl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kuram muuniyahaana! Mbats ba jiir nǝ tlayanngǝrǝn tagada nǝ Ishaiya tǝghǝr kǝskuram taakiya, ");
INSERT INTO glwl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Udahaana, ar fǝkwara bat vaa ghai kalti, ǝrviɗmahuɗaatǝr bitky dǝ kaiya. ");
INSERT INTO glwl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ar ɓaggwa ba gyaan kǝ kwatnahǝra, ar tsaga adzahadzaha uudah tǝghǝr kǝ ǝlbǝga Daadamazhigǝla.’” ");
INSERT INTO glwl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ɗahatǝrǝtɗahǝg nǝ Yesu kǝ dzahava uudah da vakaana, amaa taa kǝ iitǝra, “Cinngamcinnga am nǝghaakana. ");
INSERT INTO glwl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Dǝgiti daadamma ghaiya kǝ uud bi wa fǝgara kwadlambǝr kǝ uud tǝvuukwa Daadamazhigǝl biya. Bamma dǝgiti sagal ma ghaiyaana.” ");
INSERT INTO glwl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kaa sagau kǝ mbǝrzahaan da vak Yesu am nǝ iitǝra, “Agha sǝrgasǝrg taaki aandzaa badzgalbadzǝg nǝ ǝrviɗya Farisiyah sarta kwaraa cinnga nǝ iitǝr kǝ ǝlbǝgna?” ");
INSERT INTO glwl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Aiyam nǝ Yesu taa kǝ iitǝra, “Baɗǝm nǝ riigi kwa riiya nǝ Daadari ma ghǝrazhigǝl biya, da taɗava. ");
INSERT INTO glwl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Aaɗuwamtǝrɗuuga. Ar gulfah nǝ iitǝra, lii taɗa gulfaha. Akwama gulf wa taɗa gulfa, ba bǝrkuɗaatǝr ar mbǝɗa daay damma afǝka.” ");
INSERT INTO glwl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Aiyam nǝ Bitrus taa kǝ iina, “Tagkǝmndtagg kǝ dǝgiti tuuk vakai nǝ garavna.” ");
INSERT INTO glwl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Aiyam nǝ Yesu taa kǝ iitǝra, “Mbats gwaastǝn nǝghamaaka biya? ");
INSERT INTO glwl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Baɗǝm nǝ dǝgiti zǝguu nǝ uuda, ba zǝnngw da bak ghaiyaana, kaa damma huɗaana, tǝhala kwaha kaa sagal ma vǝghaana. ");
INSERT INTO glwl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Dǝgiti aa sagal ma ghaiya uuda, aa sǝgal bamma ǝrviɗmahuɗaana. Iin wa fǝgara ndzǝgaana kwadlambǝr kǝ uud tǝvuukwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Aɗaba sagal bamma ǝrviɗmahuuɗ nǝ dzama dǝgit ghwaɗa, ndǝ tsa sifǝga, ɓa gwaragwara, ɓa gǝlla, shiida fiida, ard badza ɗaaga. ");
INSERT INTO glwl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kwanahaan wa fǝgaraa ndzǝgaana kwadlambǝr kǝ uud tǝvuukwa Daadamazhigǝla, za kaf kwaal bara dǝv bi wa fǝgaraa ndzǝgan kwadlambǝr kǝ uud tǝvuukwa Daadamazhigǝl biya.” ");
INSERT INTO glwl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ɗughars ba nǝ Yesu kwahiin kǝ vakavaka, ngal dagal kǝ iin damma larda Taya ard Sidon, ");
INSERT INTO glwl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kaa huula saas kǝ uusa yaa Kanˈana, amaa, “Zhukwadalaazhuug, Yaazhigǝla, Zǝra Dauda. Mǝng nǝ dǝghwar kwa vǝlgar nǝ shatanah kǝ dlaɗ ba vaivaiya.” ");
INSERT INTO glwl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tagghar bi nǝ Yesu aanji ndau biya, kaa ba sagau kǝ mbǝrzahaa da ghalgaana, aiyam nǝ iitǝra, “Lagwarslagw kǝ uusna, aɗaba gata kǝmyamma dlaɓa mbakiyammbǝg dǝ huulǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ngwatǝrangug nǝ Yesu amaa, “Ɓǝlakwadi mbakyarvad tughwaha Israˈilǝn zaharazahǝgǝn nǝ uuda, mbakyarvad uudahi tlǝrǝn biya.” ");
INSERT INTO glwl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ngal sagau kǝ iin kǝlla kǝ ghunnj tǝvuukwana amaa, “Yaazhigǝla, mǝlwadmǝlga.” ");
INSERT INTO glwl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Aiyamaa, “Kalkalaan bi kǝ kǝsvant nǝ kaffa zarh ɓǝlǝvtǝrda kǝ ghǝgyah biya.” ");
INSERT INTO glwl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Amaa, “Aana, bandkwah, Yaazhigǝla, aanji ghǝgyaha ar cagaan kǝ pashpasha kaffi ɓalgal vaka zǝg kǝ dadda hǝnyahaatǝra.” ");
INSERT INTO glwl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kaa ngugarangugg kǝ Yesu amaa, “Uusǝna, fadghǝragh ndzǝɗandzǝɗana, tsakatsǝg nǝ uud kǝ puutagha.” Bat watsǝr kaa mbǝgambǝg kǝ dǝghwaana. ");
INSERT INTO glwl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ciyit ba vaakwahiin nǝ Yesu kaa ta ghaiya Yuwa haiya Galili. Ngal dagat kǝ iin dat kungula aghwa, cǝhurana. ");
INSERT INTO glwl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kaa sagau kǝ uudah baɗyak da vakaan dǝ ghurɗikaha, gulfaha, lii ǝmtsamtsan nǝ uuɓiya, makwayaha, ard uudahi tlǝrǝn baɗyaka, ar ɗiitǝra tǝvuukwana. Ngal mbahtǝrana. ");
INSERT INTO glwl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nǝghgha ba nǝ uudah kǝ makwayah ar taa ghaiya, lii ǝmtsamtsan nǝ uuɓiya, uuɓiyatǝr nalnǝg balapiya, ghurɗikah ar dagala, gulfah dlaɓ ar nǝghǝganǝghǝga. Kaa galla Daadamazhigǝla yaa Izraˈila kǝ iitǝr baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tǝhala kwaha, ngal ɗahtǝrǝtɗahǝg nǝ Yesu kǝ mbǝrzahaan amaa, “Ən ɓa zhuwadaala kwanǝn kǝ uudaha, hǝngah hǝkǝrɗ wan kwana ar ba ǝmtaɗ dǝ kaiya, ba kwal dǝgzǝga. Ən naay kǝ ɗutǝrǝsɗuug daas dǝ wai biya, aɗaba haik ɗiya haar kǝ iitǝr tǝghǝrdǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Am nǝ mbǝrzah taa kǝ iina, “Da tlǝvkǝna mǝr nǝ dǝgzǝgǝn da tlǝtǝraara kǝ uudahaan ma tǝghal vaakwani?” ");
INSERT INTO glwl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Kaa ndavtǝruundavǝg kǝ Yesu taakiya, “Ɗummba bruudi ngwɛn wa vakaruwi?” Aiyam nǝ iitǝra, “Uuɗiifa ard mishish kilf hǝɗiikǝna.” ");
INSERT INTO glwl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kaa fǝtǝraafǝg kǝ iin kǝ dlamakǝlaaw cahwargan tǝ haaya. ");
INSERT INTO glwl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kǝsant kǝ iin kǝ ɗummba bruudi uuɗiifǝn ard kilfna, tagar kǝ iin kǝ uus kǝ Daadamazhigǝla lahnana. Vǝltǝr kǝ iin kǝ mbǝrzahaana, kaa vǝltǝr nǝ mbǝrzahaan kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Baɗǝmaatǝr zaruuzǝga, tlatǝrtlǝga, kaa dzahgantdzahǝg nǝ mbǝrzahaan kǝ ghwadgahaan ar rɛghant kǝ alǝghwah uuɗiifa. ");
INSERT INTO glwl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Uudahi zaruuzǝga, tamaha damma ghwalvah alfu uufaɗa, maay ba nǝ ǝnghwasah ard zarh biya. ");
INSERT INTO glwl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Salamada ba nǝ iin kǝ uudaha, kaa damma pɛra yuwa, ngal dagal damma haaya Magadan. ");
INSERT INTO glwl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Sarǝvsǝg nǝ Farisiyaha ard Sadukiyah da vak Yesu kiyava fishǝgaan kǝ iitǝra, kaa ghalgaan kǝ iitǝr ma martǝrdan kǝ dǝga sǝrǝg kwa da mara taakiya, sǝghhi vak Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ngutǝrnaguga, amaa, “Akwama ɓǝlaaɓǝlǝg nǝ hwaasa, ma nǝghǝmanǝghǝg kǝ zhigǝla ba kyanga, am tagaan taakiya da maraw nǝ kǝs dlakaduura. ");
INSERT INTO glwl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Akwama nǝghamanǝghǝg kǝ zhigǝl ba kyanga dlakaduur wur ciyitciig nǝ ghabaga, am tagaan taakiya, ‘Da hyiyav nǝ yuwa hiinanna.’ Am nǝghǝgaakanǝghǝg tsau kǝ ndzǝgana zhigǝla. Ɗǝmakurvaa ndar kaci nǝghǝgaaka ndzǝgan kwanǝn kǝ zamani? ");
INSERT INTO glwl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Uudaha zamana ar maay dǝ jiir tǝvuukwa Daadamazhigǝl biya, dlaɓa ar kǝladaha. Ar nagan mara nǝgha kǝ dǝga sǝrga, da maay marvǝtǝrmarǝg nǝ watlǝrn kǝ dǝga sǝrǝg biya, bamma dǝga sǝrǝga Yunana.” Kaa ɗuutǝrsɗuug kǝ iin ngal dagalaana. ");
INSERT INTO glwl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Daral ba nǝ mbǝrzahaan dat ghyaba kwah kǝ gardza yuwa haiya, mbats viyaatǝraviig nǝ kǝsa bruudiya. ");
INSERT INTO glwl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Aiyam nǝ Yesu taa kǝ iitǝra, “Famfǝg kǝ hyǝmiya, dlaɓa am fǝgaan kǝ taaɗ tǝ yista Farisiyah ard Sadukiyaha.” ");
INSERT INTO glwl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kaa fagarzhafǝg kǝ iitǝr tagaan ma taatakatǝr taakiya, “Mbakyarvad kǝsyamant bi kǝ bruudi nii?” ");
INSERT INTO glwl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nǝghghaaka ba nǝ Yesu ǝndkwana, aiyama, “Kuuram lii hǝtsahǝtsan nǝ fadghǝra, aujilbǝg am taaki am maay dǝ bruudi biyi? ");
INSERT INTO glwl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mbats gwastǝn nǝghamaaka biya? Viiyakuraviig nǝ ɗuuli gǝlantǝrǝt nai kǝ uudah alfu dlǝɓ dǝ ɗummba bruudi dlǝɓa? Alghwa ngwɛn wa dzahamant nǝ uurami? ");
INSERT INTO glwl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nii ma sarta kwa gǝlantǝrǝt nai kǝ uudah alfu uufaɗ dǝ ɗummba bruudi uudifna, alghw ngwɛn wa dzahamant nǝ uurami? ");
INSERT INTO glwl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Aujibǝg nǝghǝghaamaka bi taakiya ǝn tag tǝghǝr kǝ bruudi bi nai kǝ ǝlbǝgǝn biyi? Amaaya, famfǝg kǝ hǝnkal tǝ yista Farisiyaha ard Sadukiyaha.” ");
INSERT INTO glwl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tǝhalakwah wa nǝgharaaka nǝ mbǝrzahaan taakiya, tagtǝr taaki aa farfǝg kǝ hǝnkal tǝ yistin kwa ɗiiyav ma bruudiyin biya, mbats tagtǝr taakiya aa farfǝg kǝ hǝnkal dǝ tsagaana Farisiyaha ard Sadukiyaha. ");
INSERT INTO glwl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sǝghal ba nǝ Yesu damma larda Kaisariya Filibi, kaa ndavtǝrundavǝg kǝ iin kǝ mbǝrzahaana, amaa, “War nǝ Zǝra Uud mar tagaan nǝ uudahi?” ");
INSERT INTO glwl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Aiyam nǝ iitǝra, “Kyalm ar taakiya Yuhwan dadda tsuufǝga, kyalmah ar taakiya, tlayanga Iliya, kyalmah dlaɓa ar taakiya Irimiya bi pal ma tlayangaha.” ");
INSERT INTO glwl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aiyama taa kǝ iitǝra, “Kuramǝm ǝn war nai mam tlǝg nǝ ghǝraruwi?” ");
INSERT INTO glwl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Kaa ngwangug kǝ Siman Bitrusa taakiya, “Kǝgh nǝ Kǝristi, Zǝra Daadamazhigǝla kwa dǝ shifǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Aiyam nǝ Yesu taa kǝ iina, “Agha dǝ bark nǝng, Siman zǝra Yunana, aɗaba uud bi wa markada kwanǝn biya, aa markada nǝ Daadar ma ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ən tagaktaga, agha Bitrus nǝnga, agha band akur kwa ndǝra nǝ uudan kǝ hǝngah tǝ vakaiya, ǝn da ɓaatlǝr dǝ kǝgh nai kǝ fǝtǝrna ndzǝɗ kǝ yaa dadda gata kaiya, kwa da maay nǝ ǝmtsǝg dǝ ndzǝɗa tǝghǝr kǝ iitǝr biya. ");
INSERT INTO glwl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ən da vǝlakvǝlǝg kǝ dǝga wura tlǝksǝra ghǝrazhigǝla, dlaɓa badǝm nǝ dǝgiti agha ngwuɗǝgant nǝng ma duniya, da ngwuɗav ma ghǝrazhigǝla, baɗǝm dǝgiti agha pǝlnanǝng ma duniya, da pǝlav ma ghǝrazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ɓǝlatǝraaɓǝlǝg nǝ Yesu kǝ magyi kǝ mbǝrzahaan ba vaivai aa tagarar bi aanji ndǝwar taakiya kai nǝ Kǝristi biya. ");
INSERT INTO glwl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ciigǝt ma kwahiin kǝ sart wa tagatǝr nǝ Yesu kǝ mbǝrzahaan taakiya, barari dagal damma Wurshalima, da hǝɓuu kǝ dlaɗa shahshaha, ma dǝv kǝ maalaha ard maala zhiila kǝssufah ard lii tsaga adzahadzaha, da tsǝvana, tǝ hǝng hǝkǝrɗa da ciivant dǝ shifǝga. ");
INSERT INTO glwl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ngal tǝɗant nǝ Bitrus damma dlǝmmbaava, cagaraa kǝ gyiya, amaa, “Aa tsanttsǝg nǝ Daadamazhigǝla, Yaazhigǝla, da dzǝgaar bi nǝ wan dǝ kǝgh ba dǝm biya.” ");
INSERT INTO glwl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kaa gwiyav nǝ Yesu da vak Bitrus, amaa, “Yagh vakar Shatanaha, agha akura mbǝɗa uud tǝ ɗuul nǝng vakara, agha dzamaghǝr band uuda dǝg shiga ndǝ Daadamazhigǝl biya.” ");
INSERT INTO glwl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Aiyam nǝ Yesu taa kǝ mbǝrzahaana, “Baɗǝm dadda kwa na gata kaiya, bamma ɗugharsɗuug kǝ ghǝraana, kǝsant kǝ tlaɓa hǝrtǝgaana, gatǝkwagatǝga. ");
INSERT INTO glwl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Aɗaba baɗǝm dadda kwa na kata shifǝgaana, da ɓǝgaan dagala, Badǝm nǝ daddakwa ɓǝlda shifǝgaan mbakyarvad kaiya da tlǝknatlǝga. ");
INSERT INTO glwl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Au peɗaan kǝ uud akwama tlakǝnatlǝg kǝ duni baɗǝmma, tǝhalakwaha ɓǝldan kǝ shifǝgaani? Nii auwa da vǝlǝda nǝ uudan dlakulva shifǝgaani? ");
INSERT INTO glwl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Zǝra Uuda da sii dǝ zǝrɓǝlgahaan ma ndangǝra Daddaana, da vǝlgarvǝlg kǝ dǝg shigaan aanji war kalkala dǝgiti ɓagaa nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ən takurtaga, mǝng nǝ kyalma uudahi ghaciga vakwanǝnna ar da maay ǝmtsǝg biya bamma nǝghǝgharanghǝg kǝ saay Zǝra Uuda ma tlǝkǝsǝraana.” ");
INSERT INTO glwl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tǝhala hǝngah ǝngkwaha kaa langtǝrdǝtlang nǝ Yesu kǝ Bitrus, ard Yakubu, ard zǝrababba Yakub, kwa iin nǝ Yuhwan, dagat damma ghǝra aghwa ba kyakw ba daghuvaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kaa gwivǝtgwiig nǝ ndzǝganan tǝvuukwatǝra, baz huɗǝvǝgaan ndakwi mbiig band faciya, sǝdavaan ndakwi kaa nǝg kǝ maɗǝkw ba tǝlla. ");
INSERT INTO glwl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Batwatsǝra kaa tsǝgwatsugw kǝ tlayang Musa ard tlayang Iliya. Kaa taa ghai kǝ iitǝr dǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Aiyam Bitrus taa kǝ Yesu, “Yaazhigǝla, marawa nǝ ndzǝgana miyam vaakwana. Akwama haighanthaiga ǝn tafǝgan kǝ tsakwamah hǝkǝrɗa, pal kǝskǝgha, pal kǝ Musa, pal kiyava Iliya.” ");
INSERT INTO glwl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ma sartǝn ba ndzǝgaan taa ghai nǝ Bitrusa, kaa hǝɗtǝrduhǝɗǝg nǝ akummba, kaa cinngvacinng nǝ ghai sagal ma akumb taakiya, “Kwana iin zǝrara, kwan waig naiya, ǝn cinngaan kǝ ǝmtakǝraan ba vaivaiya. Cinngamarnucinnga.” ");
INSERT INTO glwl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Cinngara ba nǝ mbǝrzahaan ǝndkwaha, kaa gǝdzǝgǝtgǝdzǝg kǝ iitǝr ba vaivaiya, baz mbǝɗa damma haay kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kaa sagau kǝ Yesu taptǝrnana amaa, “Ciyamciiga, gǝdzam biya.” ");
INSERT INTO glwl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kaparant ba nǝ iitǝr kǝ ghǝra, nǝghara bi aanji ndǝwar biya, nǝghara ba Yesu daghuvaana. ");
INSERT INTO glwl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ar tǝghǝrdǝga saay nǝ iitǝr ma aghwa, am nǝ Yesu taa kǝ iitǝra, “Tagamarbi aanji kǝ war kǝ dǝgiti amaa nǝghǝga nǝ uuram biya, bamma ciyavantciig Zǝra Uud ma gǝtlah dǝ shifǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kaa ndavgarundavǝg nǝ mbǝrzahaan taakiya, “Aujibǝg kǝ lii tsaga adzahadzaha Muus ar taakiya, barari bamma tlayang Iliya wada saay ba zǝnngwi?” ");
INSERT INTO glwl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Kaa ngutǝrangug kǝ Yesu taakiya, “Ba pakatta da saay nǝ Iliya, da ɓadlǝna kǝ dǝgitah ba ɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ən tagkurtag ciya, sahi ba wur nǝ iliya, nǝgharaaka bi kǝ iin biya, baz ɓagar dǝgitahi naaghant nǝ ghǝraatǝra. Bandkwah dlaɓa Zǝra Uud da hǝɓgaan kǝ dlaɗ mizha dǝvaatǝra.” ");
INSERT INTO glwl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ngal nǝghǝgaakanǝghǝg kǝ mbǝrzahaan taakiya, tagtǝr tǝghǝr kǝ Yuhwan dadda tsuufǝga. ");
INSERT INTO glwl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Daral ba nǝ iitǝr da vaka dzahava dlamaa kǝlaawa, kaa sagau kǝ uuda nǝ iin da vak Yesu kǝla kǝ iin kǝ ghunnj tǝvuukwana, ");
INSERT INTO glwl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","amaa, “Yaazhigǝla, zhuwardaalazhuug yagh kǝ zǝrara, tsagwara nǝ shiɗkwa shatanaha, hǝɓgaan dlaɓ kǝ dlaɗ ba vaivaiya. Shiga ngwɛn wan ba ɓalgaan damma kaara ard yuwa. ");
INSERT INTO glwl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Langandalang davak mbǝrzahagha, pǝletǝrvaapileg nǝ mbǝgaana.” ");
INSERT INTO glwl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kaa ngugarangug nǝ Yesu amaa, “Kuram uudaha zamanna, am maay dǝ fadghǝr biya, am ɓa kǝlaadǝra, ǝn da zǝlma ǝmkyangar nai dǝ kurami? Ən da zǝlma ǝmkyangar nai ɓǝshkur kwanahaani? Ayakam kǝ zǝriin sa vaakwana.” ");
INSERT INTO glwl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kaa cagaraacag nǝ Yesu kǝ gyi kǝ shiɗkwa Shatanhna, kaa ɗugarsɗuug kǝ shiɗkwa shatanah kǝ zǝriina, batwatsǝra ngal mbǝg kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kaa sagau kǝ mbǝrzah sa vak Yesu ma sartǝn maay aanji ndǝwar vakaan biya, am nǝ iitǝr taa kǝ iina, “Aujilbǝg kǝskǝmnd pǝlekǝmndvaa lagwa shiɗkwa Shatanahiini?” ");
INSERT INTO glwl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Aiyam nǝ Yesu taa kǝ iitǝra, “Kwakyarvad hǝtsalhǝtsǝg nǝ fadghǝraruwa, ǝn tagkurtag kǝ jiira, akwamaa mǝng nǝ fadghǝraru ba hǝɗikǝn band zǝra mastada, mammaa tagardatag kǝ aghwǝn taakiya, ‘Ciig vaakwana, dǝg da vaakwaha,’ maa ciiga. Maa maay nǝ dǝgiti pilkurvaapilǝg biya. ");
INSERT INTO glwl_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Lagwguvda bi nǝ hulfa kwanahaan biya, bamma tǝdvad dzǝgwazhigǝla ard kǝsa andǝla.” ");
INSERT INTO glwl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Dzaharvǝt ba nǝ mbǝrzahǝn ma Galili, kaa tagtǝrtag nǝ Yesu taakiya, “Da vǝlav Zǝra Uud damma dǝv kǝ uudaha, ");
INSERT INTO glwl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ar da tsǝgaana. Tǝ hǝnga hǝkǝrɗ ta ciivant dǝ shifǝga.” Kaa tsǝtǝratsǝg kǝ vǝgh ba vaivai kǝ mbǝrzahaana. ");
INSERT INTO glwl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Daragha ba nǝ Yesu ard mbǝrzahaan damma Kafarnahum, kaa tlǝgaraatlǝg nǝ lii cauwa hadam kwakyarvad vǝgya Daadamazhigǝl kǝ Bitrusa, am nǝ iitǝr taa kǝ iina, “Maay nǝ dadda kwa tsagkur dǝgit ɗiya hadam kwakyarvad vǝgya Daadamazhigǝl biya?” ");
INSERT INTO glwl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Aiyam nǝ Bitrusa, “Ɗigaana.” Dagha ba nǝ Bitrus da hǝnyaha, kaa fǝgarzhafǝg nǝ Yesu kǝ tagar ghaiy taakiya, “Au wagha nǝghǝga nǝng tǝghǝr kǝ ndavǝgni? Ar caug vak war nǝ tlǝksaha duni kǝ hadam, ar caug vak zarhaatǝr nii, ar caug vak uudahi tlǝrǝn hi?” ");
INSERT INTO glwl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ngwa ba nǝ Bitrus taakiya, “Vak uudahi tlǝrna.” Aiyam nǝ Yesu taa kǝ iina, “Mbats maay nǝ zarhaatǝr ɗigaan biya. ");
INSERT INTO glwl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bakǝvakwaha, haik badza ǝrviɗmahuɗ kǝ iitǝr dǝ kǝmya, dǝg damma yuwa haiya ɓǝlǝg kǝ kwanjara, agha wurant kǝ ghaiya kilfi agha fǝgarzha nǝng kǝ vigaana, agha da tlǝknatlǝg kǝ kwaɓi da tlǝgaltlǝg kǝ pǝlgaana, agha kǝsant kǝ kwaɓiina, agha ɗiya kǝ hadamagh ard dǝgara.” ");
INSERT INTO glwl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ma kwahiin kǝ sarta, kaa sagau kǝ mbǝrzah da ndavgaru kǝ Yesu taakiya, “War kaci wa juujig baɗǝm kǝ ɗyakǝr ma tlǝkǝsǝra ghǝrazhigǝli?” ");
INSERT INTO glwl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kaa ɗahant kǝ iin kǝ zǝrzǝriin sa vakaana, ghacnan ma taatakaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Aiyama, “Bak jiira wan tagkurtaga, akwama namal bi band zǝrzarhǝn biya, am tapna bi kǝ daa damma tlǝkǝsǝra ghǝrazhigǝl biya. ");
INSERT INTO glwl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mbakyarvad kwaha, baɗǝm daddakwa fǝsauna ghǝraan band zǝrzǝrǝna, iin wa ɗyak ma tlǝkǝsǝra ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Baɗǝm dadda kwa dlǝghaadlǝghǝg kǝ zǝrzǝr ndǝ kwanǝn ma ɗaagara, dlǝghakwidlǝghǝg kǝskaiya. ");
INSERT INTO glwl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Baɗǝm nǝ daddakwa fǝgara pal ma zarhahaan kwar fadghǝr tǝ kai kǝ ɓa haipa, da ngulǝm ba nguɗvardǝm nǝ akura vaar ɗyak ma kuungy ɓǝlvdǝm damma yuwa haiya kiyava ndǝgaana. ");
INSERT INTO glwl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Dǝga zhuwadaal kǝ duniya kwakyarvad dǝgitahi fǝgaraa uudah kǝ ɓa haipa, barari sagau nǝ dǝgitahi da fǝgaraa uudah kǝ ɓa haipa, dǝga zhuwadaal kǝ dadda kwa sagau tǝdvad iina. ");
INSERT INTO glwl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Akwama fǝkaa kǝ ɓa haip nǝ dǝvagh bi shigagha, ghuddaghudǝg agha ɓǝldana. Da ngulǝm agha tlǝkkǝna kǝ shifǝga damma zǝrazǝr dǝ dǝv palla bi shig palla, tǝghǝr kwa da ɓǝlvdǝm nǝ uud damma kaara fai dǝ dǝvahagh buwa ard shigahagh buwa. ");
INSERT INTO glwl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Akwama gyiyagh wa fǝkaa ɓa haipa, tǝɗdatǝɗǝg agha ɓǝldana. Da ngulǝm agha tlǝkǝna kǝ shifǝga damma zǝrazǝr dǝ gyi palla, tǝghǝr kwada bǝlkadǝm nǝ uud damma kaara faiya dǝ gyiyahagh ba bǝrkuɗa. ");
INSERT INTO glwl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Famfǝg kǝ hyimiya, nɛnnɛmbi aanji kwar pal ma zarhahaan biya. Ən tagkurtaga, zǝrɓǝlgahaatǝr ba kǝlaa hǝnng ma ghǝraazhigǝla ar nǝghǝganǝghǝg kǝ huɗvǝga Daadar ma ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Aɗaba sahi ba kǝrkangyakw nǝ Zǝra Uud da kata lii zaraazǝga. ");
INSERT INTO glwl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mam tlǝg nǝ uuram, akwama dǝ tuughah dǝrmǝk nǝ uudana, kaa zaazǝg pallaatǝra, abi ɗuugaan kǝ kul vaslaambaɗ tar vaslaambaɗǝn vaka piig kaa dagal da gata pallǝn aa zaazǝgǝn? ");
INSERT INTO glwl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Bak jiir wan tagkur naiya, akwama tlakǝnatlǝg kǝ tuugh na zǝgazǝgna, hwaɗagaana juujig kǝ kul vaslambaɗ tar vaslambaɗǝn kwa zahara bi na. ");
INSERT INTO glwl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Band kwah dlaɓa nǝ Daadaru ma ghǝrazhigǝla naabi zaan aanji pall ma zǝrzarhahaan biya. ");
INSERT INTO glwl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Akwama ɓagakaɓag nǝ zǝraabagh kǝ haipa, tagarnaatag kǝ haipaana, aandz ba kǝghar dǝ iina. Akwama cinngakanaacinnga gwighǝdaagwiig kǝ ndzǝganaru dǝ zǝraabagha. ");
INSERT INTO glwl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Akwama cinngakanaa biya, agha gwiya dagal dǝ uud pal bi uudah buwa, kiyava cinngva nǝ ǝlbǝg tǝdvad shida uudah buwa bi hǝkǝrɗa. ");
INSERT INTO glwl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Akwama lawalǝg nǝ zǝraabagh kǝ cinngtǝrcinnga, agha tagtǝr kǝ yaa dadda gata Yesu, akwama lawalǝg kǝ cinngtǝrcinnga, nǝdalnǝg band kǝrdiya bi band dadda dza hadama. ");
INSERT INTO glwl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Bak jiir wan tagkur naiya, badǝm nǝ dǝgiti am nguɗǝgant nǝ uuram ma duniya, nguɗanguɗa ma ghǝrazhigǝla, dǝgiti am pǝlna nǝ uuram ma duniya, da pǝlav ma ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ən gwiya tagkurtaga, akwama haiyaranthaig nǝ uudah bu ma kuram kǝ ghala dǝgit ma duniya, da ɓagtǝrɓag nǝ Daadar kwama ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Baɗǝm vakavaki dzahvǝt nǝ uudah buwa bi hǝkǝrɗa ma ɗaagara, ǝn ba ǝmtaɗ dǝ iitǝra.” ");
INSERT INTO glwl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kaa sagau kǝ Bitrus da vak Yesu, amaa taa kǝ iina, “Yaazhigǝla, da ɓagwi shig ngwɛɛn nǝ zǝraabar kǝ haip lakuti ǝn ɓǝsharnaani? Ɓagaɓag damma shig uuɗiffa?” ");
INSERT INTO glwl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Aiyam nǝ Yesu taa kǝ iina, “Shig uuɗif kalti biya, shig uuɗif damma kul uuɗifa. ");
INSERT INTO glwl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Mbakyarvad kwaha, da gǝrav nǝ tlǝksǝra ghǝrazhigǝl dǝ tlǝksa kwa naa kǝdla dǝgahaan kwama dǝv kǝ kwanahahaana. ");
INSERT INTO glwl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Fǝgharzha ba nǝ tlǝks kǝ kǝdlǝgaana, kaa sǝvardǝvsǝg nǝ uudi gatǝg nǝ iin tǝ ambǝla adawan alfu kǝlaawa. ");
INSERT INTO glwl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pilgharvaa ba nǝ pǝlgaana, kaa tagaan kǝ tlǝkǝsǝn taakiya, aa vǝlvǝtvǝlǝg baz iina baz uusaana baz zarhaana baz dǝgitahi dǝ vakai nǝ iin baɗǝmma kiyava pǝlgaana. ");
INSERT INTO glwl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kaa ghalgaan kǝ kwatnahaanǝn kǝla kǝ ghunnj tǝvuukwana, aiyama, ‘Fǝwifǝg kǝ huɗa ǝn da pǝlakpǝlǝg baɗǝmma.’ ");
INSERT INTO glwl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","“Kaa zhugardaalazhuug nǝ dadda hǝnyahaan kǝ kwatnahǝn ɓǝsharna kǝ gǝmauwaan ba ɗǝmma ɗuwars dagalaana. ");
INSERT INTO glwl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Bad sagala kwatnahǝn waha, kaa nǝghǝganǝghǝg kǝ iin kǝ tsaghwa tlǝraan kwa gatǝg nǝ iin tǝ gǝmauwa sǝll kǝlaawa, ngal viyit kǝ iin hǝkyarna kǝ mbakulera, amaa, ‘Pǝlwipǝlǝg kǝ gǝmauwi ǝn gatak naiya.’ ");
INSERT INTO glwl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ngal kǝlgakǝlǝg nǝ tsaghwa tlǝraanǝn kǝ ghunnj tǝvuukwan ghalgaana, amaa, ‘Fǝwifǝg kǝ huɗa ǝn da pǝlakpǝlga.’ ");
INSERT INTO glwl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Lawalǝg nǝ kwatnahǝn kǝ cinngaana, ngal ɓǝldǝm kǝ iin damma guda bǝrfina, bamma pǝlaapǝlǝg kǝ gǝmauwaana. ");
INSERT INTO glwl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Cinngara ba nǝ tsaghwaha tlǝraan kǝ dǝgiti dzǝghaardzǝgna, cinngaru bi kǝ ǝmtakǝraan biya, kaa dagal kǝ iitǝr ar tagar kǝ dadda hǝnyahaatǝr kǝ dǝgiti dzǝghaardzǝg baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kaa ɗahgantɗahǝg nǝ dadda hǝnyahǝn kǝ kwatnahǝna, amaa taa kǝ iina, ‘Agha kǝlaada kwatnah nǝnnga, ɓǝshankanaaɓǝshig nai kǝ gǝmauwǝn baɗǝm mbakyarvad ghalgagha. ");
INSERT INTO glwl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mbats kalkalaan bi kǝskǝgh agha zhuwardaala kǝ tsaghwa tlǝragh band kwana zhuukadaala naiyin biya?’ ");
INSERT INTO glwl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tsaatsǝg nǝ ǝrviɗmahuuɗ kǝ tlǝks ba vaivaiya, vǝlda kiyava vǝlgar dlaɗa, bamma pǝlaapǝlǝg kǝ gǝmauwiin baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Da ɓagtǝr bandkwan nǝ Daadar kwa ma ghǝrazhigǝl kǝ lii larwalǝg kǝ ɓǝshtǝrna kǝ zǝraabahaatǝr bad ǝrviɗmahuɗ palla.” ");
INSERT INTO glwl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ghyǝnnga ba nǝ Yesu kǝ taa kwanahaan kǝ dǝgitaha, kaa ɗugarsɗuug kǝ iin kǝ larda Galili damma larda Yahuda, kwa tǝ gyaba kwah kǝ Zaagha Judan. ");
INSERT INTO glwl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kaa gatǝgaan kǝ uudah baɗyaka, dlaɓa mbahghanambahǝg kǝ lii dǝ kuzah vaakwaha. ");
INSERT INTO glwl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kaa sagau kǝ kyalma Farisiyah da fishgaana, am nǝ iitǝr taa kǝ iina, “Tǝdvad tsagaana Muusa, kalkalaan kǝ uudan tagwavǝgha dǝ uusaan aanji tǝghǝr kǝ hulfa kwar kǝ dǝgiti ɓaga nǝ iina?” ");
INSERT INTO glwl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Kaa ngutǝrangug kǝ Yesu amaa, “Mbats, karantama bi taakiya, bamma daa zǝnngwa, Dadda Virɗiga, ‘ndǝraandǝrǝg kǝ ghwalva ard uus biya?’ ");
INSERT INTO glwl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Amaa dlaɓa, ‘Mbakyarvad kwaha, ɗuugaan nǝ uud kǝ daddaana ard babbaan ǝmtsǝvǝt tǝ uusaana, ba bǝrkuɗ ar da nǝg kǝ vǝgh palla.’ ");
INSERT INTO glwl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ar madlai vǝgh buwa biya, naralnǝg kǝ vǝgha palla, dǝgiti aa matlǝgant nǝ Daadamazhigǝla, aa tagw bi nǝ uud biya.” ");
INSERT INTO glwl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Aiyam nǝ iitǝra kǝ iina, “Ma ba ǝndǝkwah tsauwa, aujilbǝg kǝ Musa taga taakiya, barari ghudvara nǝ kakaɗa tagwavǝgh kǝ uusa, dlaɓa lagwvarsi?” ");
INSERT INTO glwl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Aiyam nǝ Yesu taa kǝ iitǝra, “Mbakyarvad dǝkdǝka ghǝraruwa wa haiyakurant musa taakiya, aa ghudvarghudǝg nǝ kakkaɗa tagwavǝgh kǝ uusa, ndza ǝndkwah bi ma daa zǝnngw biya. ");
INSERT INTO glwl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ən tagkurtaga, baɗǝm daddakwa tagwvǝgha dǝ uusaana, ma maay kwakyarvad gwaragwar biya, ma kǝsuukǝsǝg kǝ kwatlǝrn kǝ uusa, ɓaa ba gwaragwar dǝ iina.” ");
INSERT INTO glwl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Aiyam nǝ mbǝrzah taa kǝ iina, “Akwama bandkwan nǝ ndzagana zhiila ard uusa, mbats ndzǝga kwal kǝsa uusa wa marawa.” ");
INSERT INTO glwl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Am Yesu taa kǝ iitǝra, “Ɗǝm bi nǝ uudahi haiganthaig kǝ ǝlbǝgǝn biya, bamma lii haitǝrant nǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mǝng nǝ lii yavvǝtǝra kǝɓkya, ar da kǝsguu bi kǝ uus biya, mǝng nǝ lii datlatǝrǝt nǝ uudaha, mǝng dlaɓ nǝ lii hayarant nǝ iitǝr bad ghǝraatǝr taakiya, ar maay da kǝsa uus mbakyarvad gata tlǝksǝra ghǝrazhigǝl biya. Baɗǝm daddakwa haiganthaig kǝ ǝlbǝgna aa haiyanthaiga.” ");
INSERT INTO glwl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tǝhalakwaha, kaa sǝgardǝvsǝg nǝ uudah kǝ zarhaha kǝ Yesu kiyava fǝtǝra dǝva, dlaɓa dzǝgwtǝra kǝ zhigǝla. Nǝghara ba nǝ mbǝrzahaan ǝndkwaha, kaa cagtǝraacag kǝ iitǝr kǝ gyi kǝ lii sarardǝvsǝgna. ");
INSERT INTO glwl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Am nǝ Yesu taa kǝ iitǝra, “Ɗuwamtǝrɗuug kǝ zarha sa vakara, tsamtǝrǝva biya, aɗaba tlǝksǝra ghǝrazhigǝla dǝga hulfa kwan kǝ zarha.” ");
INSERT INTO glwl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Fatǝrnaa ba nǝ iin kǝ dǝva, ngal mǝla dagalaana. ");
INSERT INTO glwl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mǝng nǝ uuda nǝ iina sǝghǝv sa vak Yesu amaa “Dadda tsaga dǝgita, awan nǝ dǝgit maraw ǝn da ɓag nai ǝn tlǝkna kǝ shifǝga tangw damma zǝrazǝri?” ");
INSERT INTO glwl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Aiyama nǝ Yesu taa kǝ iina, “Aujilbǝg agha ndavakai tǝghǝr kǝ dǝgiti marauwi? Ba Daadamazhigǝla pal wa marauwa. Akwama agha naagaan agha tlǝkna kǝ shifǝga tangw damma zǝrazǝra, tsufanttsufǝg kǝ kwanahaan kǝ adzahadzahaha.” ");
INSERT INTO glwl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Aiyama taa kǝ Yesu, “Kwar kǝ adzahadzahahi?” Am Yesu taa kǝ iina, “‘Tsǝbi kǝ shifǝga biya, ɓag bi kǝ gwaragwar biya, ɓag bi kǝ gǝl biya, ghudars bi dlaɓ kǝ fiid kǝ uud biya, ");
INSERT INTO glwl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","faarafǝg kǝ daadagha ard baabagha,’ dlaɓa ‘agha wayant kǝ tlǝgharaawakyaghagh band ghǝragha.’ ” ");
INSERT INTO glwl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Am nǝ daala zǝrǝn taa kǝ Yesu, “Tsufananttsufǝg baɗǝm kǝ kwanahaana, au dlaɓ wa tǝmgwani?” ");
INSERT INTO glwl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Aiyam nǝ Yesu taa kǝ iina, “Akwama agha naagaan agha nal kǝ uuda jiijiira, valǝtvalǝg kǝ dǝgahagh baɗǝmma, agha tagwarda kǝ talagaha, agha da tlǝkǝnatlǝg kǝ dǝgshigah ma ghǝrazhigǝla, kaa gatkwagatǝg kǝskǝgha.” ");
INSERT INTO glwl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Cinngha ba nǝ daala zǝrǝn kǝ ǝlbǝgna, kaa badzǝdabadzǝg kǝ iin kǝ ǝrviɗmahuɗa, aɗaba dadda hyah nǝ iin ba vaivaiya, kaa ba mǝla dagalaana. ");
INSERT INTO glwl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Aiyam nǝ Yesu kǝ mbǝrzahaana, “Ən takurtaga, da dǝgaa ba dlah nǝ dadda hyah damma tlǝksǝra ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ən gwiya tagkurtaga, da tsaftsaf kǝ adlǝgwam dagal tǝ ɗuula liipǝr tǝghǝr kǝ dadda hyah daa damma tlǝksǝra Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Cinnghara ba nǝ mbǝrzahaan ǝndkwaha, kaa ɓa jappǝr kǝ iitǝra, ba vaivaiya aiyam nǝ iitǝra, “Ma ba ǝndkwan tsaa, war kaci wada tlǝkǝna katǝgi?” ");
INSERT INTO glwl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ngal zhartǝrzharǝg kǝ Yesu, amaa taa kǝ iitǝr, “Kwan kǝ dǝgita ɓaga bi vak uud biya, vak Daadamazhigǝla ɓagaɓag nǝ wanahaan baɗǝmma.” ");
INSERT INTO glwl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Aiyam Bitrus taa kǝ iina, “Wai ci, ɗuwamndarɗug kǝ dǝgahamnd baɗǝmma kwakyarvad gata kǝgha. Au ci wa kǝmnda tlǝkna nǝmndi?” ");
INSERT INTO glwl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Am Yesu taa kǝ iitra, “Jiir wan tagkur naiya, ma zamanǝn kwa da sagauna, Zǝra Uuda da cihurga tǝ avǝda kwargaan ma tlǝksǝraan kwa ndanga, kuramǝn gatamkwagatǝgna, kuram wam da cihurga tǝ avǝdah kǝlaawa tar buwa, kiyava kwara kuɗigaha yaa Izraila kǝlaawa tar buwa. ");
INSERT INTO glwl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Baɗǝm nǝ dadda kwa ɗugars vǝgyaha, bi zǝraabahaana, bi dughaha babbaana, bi daddaana bi babaana bi uusaana, bi zarhaana ard guhah kwakyarvad kaiya, da tlǝkǝnatlǝg juujig kwah shig dǝrmǝkka, da tlǝkna dlaɓa kǝ shifǝg tangw damma zǝrazǝra. ");
INSERT INTO glwl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Da baɗyaka nǝ uudaha zǝnngwa ar da nǝg kǝ dǝga hala, dǝga hala dlaɓa ar da nǝg kǝ dǝga zǝnngwa. ");
INSERT INTO glwl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Tlǝksǝra ghǝrazhigǝla da band dadda hǝnyhiin kwa dal ba wurkǝs da gata bariyamah kiyava ɓa tlǝr ma guha inabiyaana. ");
INSERT INTO glwl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kaa tagvatag kǝ iitǝr kǝ gana kwab kwa ɗivar kǝ baryam ma vannga, ngal lanngtǝrdan damma guhaana. ");
INSERT INTO glwl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Tamaha karfi vaslambaɗa dlakadura, kaa gwiya dagal kǝ iin dlaɓa, kaa nǝghǝganǝghǝg kǝ iin kǝ uudahiin ar ghacga ba gyagyaan tǝ ɓalla kasukwa. ");
INSERT INTO glwl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Aiyama taa kǝ iitǝra, ‘Kuram ndakwani damdǝg damma guhara, ǝn da ɗiikurɗiig ba marauwa.’ ");
INSERT INTO glwl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kaa dagal kǝ iitǝra. “Kaa gwiya dagal kǝ iin dǝ vaci tǝghǝra, dlaɓa ard kalkala karfi hǝkǝrɗa hwaasa, ɓagtǝra bandkwa ɓagatǝra nǝ iin kǝ uudahaatsa. ");
INSERT INTO glwl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Damma karfi dlǝɓa hwaasa, kaa gwiya dagal tlǝtǝraa kǝ uudahiin ar ghacga ba gyagyaana, amaa taa kǝ iitǝra, ‘Aujilbǝg bǝrnif vanng am ndzǝga ba gyagyaani?’ ");
INSERT INTO glwl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Aiyam nǝ iitǝr taa kǝ iina, ‘Aɗaba maay dadda kwa vǝlkǝmnd tlǝra ɓag biya.’ “Amaa taa kǝ iitǝra, ‘Kuram ndakwani damdǝg da ɓatlǝr ma guhara.’ ");
INSERT INTO glwl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ɓǝlaa ba nǝ hwaasa, kaa ba tagartag nǝ dadda guhǝn kǝ daddakwa mǝlgaru kǝ fa hyimmi tǝ guhna, ‘Ɗahtǝrantɗahǝg kǝ lii ɓa tlǝrǝn agha ɗiitǝra kǝ kwaɓa tlǝraatǝra, farzhafǝg dǝ dǝga hala dat dǝga zǝnngwa.’ ");
INSERT INTO glwl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Lii dalar tamaha damma karfi dlǝɓa hwaasana, ma waratǝr dlǝgha dǝgiti diivar kǝ baryam ma vannga. ");
INSERT INTO glwl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Lii fararzha dagal ba zǝnngwna, tlatlar taakiya da jiguujig nǝ kwaɓatǝr kǝ dǝga kyalma uudaha, ghǝravaatǝr ndakwani ma waraatǝr dlǝgha ba dǝgiti diivar kǝ baryam ma vannga. ");
INSERT INTO glwl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Cauwara ba nǝ iitǝra, kaa zavgarǝv ghaiy kǝ iitǝr kǝ dadda guha. ");
INSERT INTO glwl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ar taakiya, ‘Lii araa sǝgal tǝhalǝna, araa ɓaga ba tlǝra aawa palla, agha ɗiikǝmnda ba kalkal dǝ iitǝra, kǝmǝndi kǝma vannga ba ɓa tlǝra, aɗuug ci kǝ dlaɗa faciyi kǝmnda hǝɓguu nǝmnda.’ ");
INSERT INTO glwl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Kaa ngwarangug kǝ iin kǝ pall ma taatakaatǝra, amaa, ‘Tsaghwara zangku biya, tagikǝvai kǝ gan taakiya, ǝn da ɗiyak kwaɓi ɗiivar kǝ baryam ma vanga biya? ");
INSERT INTO glwl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Cauwacaug kǝ dlayagha dǝg daasagha, na naagant ba nai kǝ diitǝr kǝ lii aa sǝgal tǝhala kalkal dǝgiti na vǝlak naiya. ");
INSERT INTO glwl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mbats ǝn maay dǝ ndzǝɗa ɓa dǝgiti na naagant nǝ ghǝrar dǝ kwaɓar biya? Nii agha shilg kwakyarvad ǝn ɓa hɛrǝr ba vaivaihi?’ ");
INSERT INTO glwl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Ar da nǝg band kwan nǝ dǝga hal kǝ dǝga zǝnngwa, dǝga zǝnngwa ar da nǝg kǝ dǝga hala.” ");
INSERT INTO glwl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tǝ ɗuula dagat damma Wurshalim nǝ Yesu ard mbǝrzahaana, kaa ɗahtǝrǝtɗahǝg damma gyaba, amaa taa kǝ iitǝra, ");
INSERT INTO glwl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kiyam dagat damma Wurshalima vakavaki da vǝlav nǝ Zǝra Uuda damma dǝv kǝ maalah ma zhiila kǝsuufah ard lii tsaga adzahadzaha, ar da ghudara kǝ sharia ǝmtsǝga. ");
INSERT INTO glwl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tǝhalakwaha ar da vǝltǝr damma dǝv kǝ lii Yahudah biya, ar da nengaana ar da kalaakana, da hǝrtǝvǝta, tǝ hǝnga hǝkǝrɗ da civanta.” ");
INSERT INTO glwl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kaa sagau nǝ babba zarha Zabadi dǝ zarhaan da ghalǝg vak Yesu, kǝla kǝ iin kǝ ghunj tǝvuukwaana ngal ghala dǝgit vakaana. ");
INSERT INTO glwl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Aiyama taa kǝ iina, “Au wa nag nǝngi?” Am nǝ uusiin taa kǝ Yesu, “Haiyanthaig yaan kǝ zarharǝn buna ma pal cǝhura tǝ dǝva kafagha, pal tǝ dǝva ghyaɓagh ma tlǝksǝragha.” ");
INSERT INTO glwl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Am nǝ Yesu taa kǝ zarhahina, “Am sǝrgai kǝ dǝgiti am ghalǝg nǝ uuram biya. Am hǝɓgahǝɓǝg kǝ dlaɗǝn ǝn da hǝɓǝg naina?” Aiyam nǝ iitǝra, “Kǝm hǝɓgahǝɓǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Amaa taa kǝ iitǝra, “Ba pakat am da hǝɓǝgahǝɓǝg kǝ dlaɗara, ndzǝgan tǝ dǝvaa kafara ma dǝva ghyaɓara kai bi wa dǝ ndzǝɗa vǝlgaan biya, kwanahaan kǝ vakavakaha, ɓadlavtǝrna kǝ lii dzǝratǝraaka nǝ Daadar kwa ma ghǝrazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Cinnghara ba nǝ mbǝrzahaan kǝlaawǝn ǝndkwaha, kaa badzǝdabadzǝg kǝ iitǝr kǝ ǝrviɗmahuɗ dǝ zarhabaabahǝn buwna. ");
INSERT INTO glwl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kaa ɗahtǝrǝtɗahǝg nǝ Yesu baɗǝmmaatǝra, amaa, “Am sǝrgasǝrg taakiya tlǝksahi kwar Yahudah biya ar fǝtǝra ngǝɗǝp kǝ uudahatǝra, maalahatǝr ndakwani ar martǝr ndzǝɗa kǝ uudahatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Da ǝndkwah bi ma taatakaru biya. Dlakulvakwaha, badǝm daddakwa naa nǝg kǝ maal ma kurama, barari nal kǝ kwatnaharuwa. ");
INSERT INTO glwl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Dlaɓa baɗǝm nǝ dadda kwa naa nǝg kǝ maal ma kurama, barari naal kǝ ɛɛvaruwa. ");
INSERT INTO glwl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bandkwah dlaɓ nǝ Zǝra Uuda sahi bi mbakyarvad ɓagvarnǝs kwatnahǝr biya, sahi mbakyarvad ɓa kwatnahǝra, vǝlda dlaɓ kǝ shifǝgaan kiyava vara uudah baɗyaka.” ");
INSERT INTO glwl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ar tǝ ɗuula ɗuwa Yariku nǝ Yesu ard mbǝzahaana, kaa gatǝgaan kǝ uudah baɗyak dagala. ");
INSERT INTO glwl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mǝng nǝ gulfah bu ar cihurga tǝ ghyaba ɗuula, cinngara ba nǝ iitǝr taakiya Yesu wa ghuda dagala, kaa dzǝgantdzǝg kǝ iitǝr kǝ ghaiya, am nǝ iitǝra, “Yaazhigǝla, Zǝra Dauda! Zhukǝmdaalazhuuga!” ");
INSERT INTO glwl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kaa cagtǝraacag nǝ uudah kǝ gyiya, ar tagtǝr taaki aa ndzarandzǝg ba ɗǝwa. Ar gwiya dzǝgant kǝ ghai bad halavuwa ndzǝɗahatǝr ar taakiya, “Yaazhigǝla, Zǝra Dauda! Zhukǝmndaalazhuuga!” ");
INSERT INTO glwl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kaa ghacgaghacig kǝ Yesu, ɗahtǝrǝt amaa taa kǝ iitǝra, “Auwam nag nǝ uuram ǝn ɓagkurani?” ");
INSERT INTO glwl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Aiyam nǝ iitǝra, “Yaazhigǝla, kǝm naa magha wurkǝmndant kǝ gyiyahamnda.” ");
INSERT INTO glwl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ngal zhutǝrdaalazhuug kǝ Yesu, tapnan kǝ gyiyahaatǝra, batwatsǝra kaa wurgǝtwurǝg kǝ gyiyahaatǝra, ngal gata Yesu kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Hǝrzarǝt ba nǝ Yesu ard mbǝrzahaan damma Bǝtafaji gǝdzǝrkǝsa kwa hǝrz dǝ Wurshalima vaka Aghwa Uufaha Zaitun, kaa ɓǝlgantɓǝlǝg kǝ iin kǝ mbǝrzah buwa. ");
INSERT INTO glwl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Amaa taa kǝ iitǝra, “Damdǝg daadamma kǝsǝn tǝvuukwaruna. Bad daasaruwa am da nǝghǝganǝghǝg ka aghyunngw nguɗgan dǝ zǝraan tǝvǝgha, pǝlamtǝrdaapǝlǝg am sǝtǝrdaa sa vaakara. ");
INSERT INTO glwl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Akwama ndavakurundavǝg nǝ uudana, tagamartag taakiya, Yaazhigǝl wa naatǝrnaaga, da gwiya saas dǝ iitǝr ba ndakwana.” ");
INSERT INTO glwl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dzaghaar kiyava righa dǝgiti tagada nǝ tlayanng taakiya, ");
INSERT INTO glwl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Tagamtǝrtag kǝ uudaha Wurshalima, ‘Wayam nǝ tlǝksaru da vakaaruwa, kalaaliya uuda nǝ iina, dagal tǝ aghyunngwa, zǝra aghyunngw wa dagal nǝ iin tǝ vakaiya.’ ” ");
INSERT INTO glwl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kaa dagal kǝ mbǝrzahaana ar ɓagnan bandkwa tagatǝr nǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ar sardǝv kǝ aghyunngwiin baz zǝraana, ar ɓala kǝ sǝɗavahaatǝr tǝ iitǝra, kaa ba ɗalgaan kǝ Yesu cihura tǝ vakaiya. ");
INSERT INTO glwl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kaa ɓala sǝɗavahaatǝr nǝ uudah ba ɗyak tǝ ɗuula, kyalmah dlaɓa ar kala kǝ aabayah tǝ uuf ar ɓala kǝ iitǝr tǝ ɗuula. ");
INSERT INTO glwl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Uudahi mǝlara dagal tǝvuukaana ard lii gatǝg mahala ar dzǝgant kǝ ghai ar taakiya, “Galyamgalǝg kǝ Zǝra Dauda. Barǝk kǝ dadda kwa sagau ma ɗaaga Yaazhigǝla! Galyamgalǝg kǝ Daadamazhigǝla!” ");
INSERT INTO glwl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Dagha ba nǝ Yesu damma Wurshalima, kaa cigǝtciig kǝ hǝnkala uudah baɗǝm ma kǝsiin ar taakiya, “War wa nǝ iin kǝ uudi?” ");
INSERT INTO glwl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aiyam nǝ uudahǝn dagal gata Yesuwǝn taa kǝ iitǝra, “Kwan iin nǝ tlayang Yesu, kwa sǝghal ma Nazarat ma Galili.” ");
INSERT INTO glwl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Dagha ba nǝ Yesu damma gaagazaiya vǝgya Daadamazhigǝla, lagwatǝrda kǝ lii vǝla dǝgitah ard lii sagwa dǝgitah ma vakai baɗǝmma, tlagars kǝ iin kǝ tibǝra lii mɓǝɗa kwaɓa ard avǝdaha lii vǝla takalamasara. ");
INSERT INTO glwl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Amaa taa kǝ iitǝra, “Vindavavindǝga taakiya, “ ‘Vǝgyar da ɗahav dǝ Vǝgya Daadamazhigǝla,’ namdalnǝg nǝ uuram kǝ ‘zazza shiɓa gǝlaha.’ ” ");
INSERT INTO glwl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kaa sagau kǝ gulfah ard ghurɗikaha da vakaan ma Vǝgya Daadamazhigǝla, mbǝttǝrana. ");
INSERT INTO glwl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nǝghara ba nǝ maalah ma zhiila kǝsuufah ard lii tsaga adzahadzah kǝ dǝga japǝrǝn ɓǝgaa nǝ Yesu na, ard ɗiya cauwa zarh ma gaagazaiya Vǝgya Daadamazhigǝla, ar taakiya, “Galiyamgalǝg kǝ Zǝra Dauda.” Kaa badza ǝrviɗmahuɗ kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Aiyam nǝ iitǝr taa kǝ Yesu, “Agha cinngacinng kǝ dǝgiti ar tag nǝ zarhahaan kwana?” Kaa ngwangug nǝ Yesu amaa, “Mbats tapamnai kǝ karantǝgaan ma kaɗkaɗa ǝlbǝga Daadamazhigǝl vindavindan taakiya, “ ‘Yaazhigǝla, kǝgh wa tagh taaki agha ɗaag tǝdvad ghaiya zarhaha ard vuunjah nǝng kǝ galgagh sagal biya’?” ");
INSERT INTO glwl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tǝhalakwaha, kaa ɗuutǝrsɗuug kǝ iin ma kǝsiina, kaa ba mǝla dagal damma Betani, ngal hǝnng kǝ iin vaakwaha. ");
INSERT INTO glwl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Wurraa ba nǝ kǝsa, kaa gwiyaghǝra saas kǝ Yesu damma Wurshalima ngal njǝkǝnnjiig kǝ wai tǝ ghǝrdǝga. ");
INSERT INTO glwl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nǝghgha ba nǝ Yesu kǝ uufa ghǝgyiv tǝ ghaiya ɗuula, kaa dagau kǝ iin da tǝvǝgh kǝ uufina, tlakǝna bi aanji dau tǝvakai biya, ba hyǝmiya. Amaa taa kǝ uufiina, “Ba dǝm agha maadlai gwiya ya zǝr biya.” Tǝhala kwaha kaa ghulǝg kǝ uufiina. ");
INSERT INTO glwl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nǝghara ba nǝ mbǝrzahaan ǝndkwana, kaa ɓaa jappǝr kǝ iitǝr ba vaivaya. Aiyam nǝ iitǝra, “Aujilbǝg kǝ uufǝn aa ghulgal ba watswatsi?” ");
INSERT INTO glwl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Kaa ngutǝrang kǝ Yesu, amaa, “Bak jiir wan tagkurtaga, akwamamma mǝng dǝ fadghǝra, dlaɓa am maay ɓaa ndaundau biya, mammaa ɓagaɓag kwa juujigg kǝ dǝgiti na ɓagara nai kǝ uuffa ghǝgyivna, am tagardatag dlaɓ kǝ aghwǝn taakiya, ‘Ciig vaakwana dǝg damma yuwa haiya,’ maa ciiga. ");
INSERT INTO glwl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Akwama famdǝghǝrǝtfǝga, baɗǝm nǝ dǝgiti am ghalga nǝ uurama vak Daadamazhigǝla ma dzǝgwazhigǝla, am tlǝkǝnatlǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Dagha ba nǝ Yesu damma gaagazaiya Vǝgya Daadamazhigǝla, kaa tsagtǝr dǝgit kǝ uudah, ngal sagau kǝ maalah ma zhiila kǝsuufah ard maalah tǝghǝr kǝ dlamaa kǝlaaw da vakaana, am nǝ iitǝr taa kǝ iina, “Agha ɓag dǝ kwar kǝ ndzǝɗ nǝng kǝ kwanahaan kǝ dǝgitahi? Dlaɓa vǝlakak war kǝ ndzǝɗi?” ");
INSERT INTO glwl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kaa ngutǝrangug kǝ Yesu taakiya, “Ən ndavkurundavǝg ghǝravar kǝ ndavǝg palla. Akwama tagamwitaga, ghǝravar ndakwani ǝn tagkurtag kǝ ndzǝɗi ǝn ɓag nai kǝ tlǝr dǝ vakaiya. ");
INSERT INTO glwl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ndzǝɗǝn ndza dǝ vakai Yuhwan dadda tsuufǝgǝn tsaa, vǝlghar nǝ Daadamazhigǝl nii uudhi?” Kaa tagkǝvatag kǝ iitǝr mataatakatǝra, taakiya, “Akwama tagiyamatag taakiya, ‘Sahi vak Daadamazhigǝla,’ da tagaan taakiya, ‘Aujilbǝg ci famdǝghǝrǝt bi tǝ iin biyi?’ ");
INSERT INTO glwl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Akwama tagiyamatag taakiya, ‘Vak uuda,’ kiyam gǝdza dǝgǝti ar da ɓagkiyam nǝ uudaha, aɗaba baɗǝm nǝ uudah haiyaranthaig taakiya ndza tlayanga nǝ Yuhwana.” ");
INSERT INTO glwl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kaa ngugarangug kǝ iitǝr kǝ Yesu taakiya, “Sǝramdai kǝ vakavaki sal dǝ ndzǝɗiin biya.” Am Yesu taa kǝ iitǝra, “Ghǝravar ndakwani ǝn maay tagkurtag, kǝ ndzǝɗi ǝn ɓag nai kǝ kwanahaan kǝ dǝgitah biya. ");
INSERT INTO glwl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Au wamaa tlǝg uurami? Mǝng nǝ uuda nǝ iin dǝ zaraa ghwalvah buwa, kaa dagau da vak kǝ dǝga zǝnngwa, amaa taa kǝ iina, ‘Zǝrara, dǝg da ɓa ɓatlǝr ma guha inabi hinana.’ ");
INSERT INTO glwl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Aiyam nǝ zǝrǝn taa kǝ iina, ‘Ən maay dagal biya,’ tǝhalakwaha, kaa ɗayaghǝr kǝ iin kaa ba dagala. ");
INSERT INTO glwl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ngal dagau kǝ daadiin da vak kǝ dǝga buwa, tagar kǝ iin kǝ dǝgiti taghar nǝ iin kǝ zǝngwna, kaa ngwangug kǝ zǝriin taakiya, ‘Iiya, ǝn dagau, daada,’ tǝhalakwaha lǝwa kǝ dagala. ");
INSERT INTO glwl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Ma iitǝr buna tsaa, warwa ɓagaa dǝgiti naag daddaatǝri?” Aiyam nǝ iitǝra, “Dǝga zǝnngwa.” Am nǝ Yesu taa kǝ iitǝr dlaɓa, “Bak jiira ǝn tagkurtaga, lii cauwa hadahama ard tandaha ar da dǝgaa nǝ iitǝr damma tlǝksǝra Daadamazhigǝl tǝghǝr kǝskurama. ");
INSERT INTO glwl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Aɗaba sahisǝg nǝ Yuhwan da markurd ɗuula jiirjiira, famdǝghǝrǝt bi nǝ uuram tǝ iin biya. Lii cauwa hadama ard tandaha fardghǝrǝtfǝg tǝ iina. Bakǝvakwaha, ndzaa tǝhala nǝghǝganǝghǝgaru kwana, lamwalǝg kǝ pǝlaghǝr am fǝdghǝrǝt tǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Kaa tagtǝrtag kǝ Yesu kǝ garava. Mǝng nǝ uuda nǝ iin kwa ɓagaa guha inabi, ɓǝlaraa kǝ ghǝrgha, tǝfa kǝ vaka pǝrtsa zǝra inabi, dlaɓa ndǝrǝt kǝ gud ba tlaɗ kiyava dadda uufakyauwa. Vǝltǝr kǝ mbuucaan kǝ yaa dadda uusǝga, kaa dagal kǝ iin damma lardi tlǝrna. ");
INSERT INTO glwl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ɓagaa ba sarta caa zǝra inabi, kaa ɓǝlgantɓǝlǝg kǝ iin kwatǝnahahaan davak lii cauwar mbuuca guhǝna, kiyava sǝgarda zarha inabi ma guha. ");
INSERT INTO glwl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ngal viigǝtviig nǝ lii cauwar mbuucin kǝ kwatnahahaana, ar kalaaka kǝ palla, ar tsa kǝ palla, ar ɗawala kǝ kwah dǝ akura. ");
INSERT INTO glwl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Gwiya ɓǝlant kǝ kwatlǝrn kǝ kwatanahah baɗyaka kwa jarujig kǝ lii ndza zǝnngwa, ngal ɓagaan kǝ lii cauwar mbuucin band kwa ɓagartǝra nǝ iitǝra kǝ lii ndza zǝnngwa. ");
INSERT INTO glwl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tǝhalakwah baɗǝmma, kaa ɓǝlgantɓǝlǝg nǝ dadda guhǝn kǝ zǝraan da vak lii cauwara mbuucna, amaa, ‘Mbatak ar da fǝgaarafǝg kǝ zǝrarna.’ ");
INSERT INTO glwl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Nǝghara ban lii cauwara mbuuca guhǝn kǝ zǝrna, kaa tagkǝvatag kǝ iitǝr mataatakatǝr taakiya, ‘Wan ci dadda kwada gwigaana, na tsiyamatsǝga, kiyava nǝg guhiin kǝ dǝga miyamma.’ ");
INSERT INTO glwl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ar viyǝt, ar ɗuuldan da gyilga ghǝrgha, ar tsana. ");
INSERT INTO glwl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Aitsaa, akwama saghaasǝg nǝ dadda guhǝna, au kaci wa da ɓagtǝr nǝ iin kǝ lii cauwara mbuuca guhni?” ");
INSERT INTO glwl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Am nǝ iitǝr taa kǝ iina, “Da ciɓan kǝ kǝlaadahaan vǝlatǝr nǝ iin kǝ mbuuca guhna, da vǝltǝr kǝ guhiin kǝ uudahitlǝrn kwar da vǝlgar dlaiyaan ma kadlannga guhiina.” ");
INSERT INTO glwl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Am nǝ Yesu taa kǝ iitǝra, “Mbats tapamnai karantǝgaan ma kakkaɗa Daadamazhigǝl biya? “ ‘Akuri ɗuwarars nǝ yaa dadda ndǝrga, iin wa nal kǝ akura nɗǝrǝg marawa. Kwana tlǝra Yaazhigǝla, dǝga jappǝr dlaɓ ma gyiyahaamnda.’ ");
INSERT INTO glwl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Mbakyarvad kwaha, ǝn tagkurtaga, da cauwav nǝ tlǝksǝra Daadamazhigǝl vakaruwa, da vǝlǝvtǝr kǝ uudahi tlǝrǝn kwar da ɓa dǝgitahi naag nǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Baɗǝm daddakwa mbǝɗǝga da tuuk kwanǝn kǝ akurna, kalǝg ba hwɛɓhwɛɓa, dlaɓa uudani ɓǝlhi na akurǝn da tǝghǝr kǝ iina, ɗǝgaan ba tukwtukwa.” ");
INSERT INTO glwl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Cinngara ba nǝ maalah ma zhiila kǝsuufah ard Farisiyah kǝ garavahaan tagada nǝ iina, kaa nǝghǝgaakanǝghǝg kǝ iitǝr taakiya tag tǝghǝr kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kaa gata ɗuula viigaan kǝ iitǝra, gǝdzar gyiya uudaha, aɗaba kǝsarantkǝsǝg nǝ uudah kǝ iin taakiya tlayannga. ");
INSERT INTO glwl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Gwiya tagatǝrtag nǝ Yesu kǝ kwatlǝrǝn kǝ garava, amaa, ");
INSERT INTO glwl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Tlǝksǝra ghǝrazhigǝl band tlǝks kwa ɓagghara hwaɗaga kǝsa uus kǝ zǝraana. ");
INSERT INTO glwl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kaa ɓǝlgantɓǝlǝg kǝ iin kwatnahahaan da tagtǝr kǝ lii ɗahavtǝrɗahǝgǝn da vaka hwaɗaga kǝsa uusna, larwalǝg nǝ uudahiin kǝ sagauwa. ");
INSERT INTO glwl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ngal gwiya ɓǝltǝrǝtɓǝlǝg kwatlǝrǝn kǝ kwatnahah amaa, ‘Tagamtǝrtag kǝ uudahaan ɗahavtǝrɗahgǝn taakiya, “Wa ɓadlannaɓadlǝg nǝ dǝgzǝga, haravahǝrǝg nǝ kauwaha ard tlah ngatlangatlana, wa gyǝnngavagyǝnng ɓadla dǝgitah baɗǝmma. Aa sarasǝg sa vaka hwaɗagiina.” ’ ");
INSERT INTO glwl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Far bi nǝ iitǝr kǝ hyǝmi biya, kaa mǝla dagalaatǝra. Kwana dal damma guhaana, kwatlǝrǝn dal da ɓa kasukwana. ");
INSERT INTO glwl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kyalǝmah dlaɓa ar vaitǝrǝt kǝ kwatnahahaana, ar kaltǝraakana, ar ciɓtǝrana. ");
INSERT INTO glwl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kaa badza ǝrviɗmahuuɗ kǝ tlǝksǝn ba vaivaiya. Ngal ɓǝlgantɓǝlǝg kǝ iin kǝ tlaujahaana, ar vaitǝrǝta, ar ciɓtǝra kǝ lii ciɓara shifǝgna, ar haar kǝ kaar kǝ kǝsaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Tǝhalakwaha, amaa taa kǝ kwatnahahaana, ‘Ghyǝnngavaghyǝng nǝ ɓadla vaka hwaɗga kǝssa uusna, lii ɗahantǝr nai da vaka hwaɗaga kǝsa uusna, maa dlaitǝr bi kǝ sagau biya. ");
INSERT INTO glwl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mbakyarvad kwaha, tamtǝg kǝ baabura, ɗahamatǝrɗahǝg kǝ uudahi am tlǝgara nǝ uuram baɗǝmma, aa sarsǝg da vaka hwaɗaga kǝsa uusa.’ ");
INSERT INTO glwl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kaa ba dagal kǝ kwatnahaanǝn tǝ baabur baabur ar ɗahant kǝ uudahi tlararaa nǝ iitǝra baɗǝmma, lii kǝlaadaha ard lii ɓa dǝga jiijiira, righǝtrighǝg nǝ vaka hwaɗag dǝ ghulabaha. ");
INSERT INTO glwl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Daghan ba nǝ tlǝksǝn da vaza ghulabaha vaka hwaɗaga, kaa nǝghǝganǝghǝg kǝ iin kǝ uuda nǝ iin kwa tsǝguv bi kǝ sǝɗava hwaɗag biya. ");
INSERT INTO glwl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Aiyama taa kǝ uuda nǝ iina, ‘Tsaghwa, aghaa sǝgaa ndar nǝng da vaka hwaɗagǝn ba kwal tsǝguv sǝɗava hwaɗaga kǝsa uusi?’ Pilgharvaapilǝg nǝ dǝga tag kǝ uuda nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Am tlǝksǝn taa kǝ kwatnahahaana, ‘Ngwaɗamnanguɗǝg kǝ dǝvaahaan ard shigahaana, ɓǝlamdaɓǝlǝg da gyimala, damma gurtla, vaakwaha da tuug ǝmtaɗ dǝ ghwada dǝv dǝ tlǝrɗa.’ ");
INSERT INTO glwl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Baɗyak nǝ uudahi ɗahavtǝrantɗahǝga, ba hǝɗiikǝn nǝ lii dzǝravtǝraakadzǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kaa ɗiya sawari kǝ Farisiyaha tǝghǝr kǝ ɗuuli ar da ngar nǝ iitǝr kǝ dlǝgǝd kǝ Yesu tǝdvaɗ ǝlbǝgahi da tag nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kaa ɓǝlgantɓǝlǝg kǝ iitǝr kǝ mbǝrzahaatǝr ard kyalma uudaha Hirudus da vak Yesu, am nǝ iitǝra, “Dadda tsaga dǝgit, kǝm sǝrgasǝrǝg taakiya agha uuda jiirjiira, agha tsaga ɗuula Daadamazhigǝl ba jiirjiira, agha maay dlaɓ fa dagar ma uudah biya, kǝsghankǝsǝg kǝ uudah ba kalkala. ");
INSERT INTO glwl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tagkǝmndtag kǝ jiira, kalkalaan nii kǝskǝmnd ɗiigar hadam kǝ Kaisara kalkalaaan bi hii?” ");
INSERT INTO glwl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nǝghaakanǝghǝg nǝ Yesu kǝ kǝlaadǝraatǝra, amaa taa kǝ iitǝra, “Kuram muniyahaana, aujilbǝg am fǝsha kaiyi? ");
INSERT INTO glwl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Maramwadamarǝg ndan kǝ kwaɓiin ɗiyav dǝ hadamna.” Ngal ar sardǝv kǝ kwaɓiina. ");
INSERT INTO glwl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Aiyama taa kǝ iitǝra, “Dzakǝva wara ard ɗaaga war wa nǝ iin tǝvakaini?” ");
INSERT INTO glwl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kaa ngug kǝ iitǝra, “Dǝga Kaisara.” Aiyam nǝ Yesu taa kǝ iitǝra, “Vǝlamarvǝlǝg kǝ Kaisar kǝ dǝga Kaisar, am vǝlar kǝ Daadamazhigǝl kǝ dǝga Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Cinngara ba nǝ iitǝr ǝndkwaha, kaa ɓa jappǝr kǝ iitǝra, ar ɗuwarsa. Kaa mǝla dagalaatǝr kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ba daghuvala kwahiina, mǝng nǝ kyalma Sadukiyaha, iitǝr wa fardghǝrǝt bi taaki mǝng ciig ma gǝtlah biya, sarǝv sa vak Yesu dǝ ndavǝga, ");
INSERT INTO glwl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","am nǝ iitǝra, “Dadda tsaga dǝgita, vindakǝmndavindǝg Musa taakiya, akwama ǝmtsaaǝmtsǝg nǝ uudan kwal yiga kǝ zǝr dǝ uusaana, kǝsgaan nǝ zǝrababbaan kǝ uusiin kiyav yaagar zarh kǝ zǝra babbaana. ");
INSERT INTO glwl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ndza mǝng nǝ zarha baabah uudif ma taatakamnda, kǝsuu nǝ yag kǝ uussa, ǝmtsan ba kwal yiga kǝ zǝra, kaa kǝsguukǝsǝg kǝ zǝra babbaan kǝ uusaana. ");
INSERT INTO glwl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Dzǝghaar bandkwah dǝ zǝra buwa, baz zǝra hǝkǝrɗa, tanngw dat zǝra uuɗiifa. ");
INSERT INTO glwl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tǝhalakwaha kaa ǝmtsǝgaǝmtsǝg nǝ uusiina. ");
INSERT INTO glwl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aici tsaa, da nǝg kǝ uusa warkaci nǝ iin pal ma iitǝr daghuvala ciig ma ghǝtlah? Aɗaba uuɗiffa ǝmtaɗaatǝr kǝsarukǝsǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Am nǝ Yesu taa kǝ iitǝra, “Dzamaghǝraru kalkal biya, aɗaba am sǝrgai kǝ ǝlbǝga Daadamazhigǝl vinndavinndan biya, dlaɓa am sǝrgai kǝ ndzǝɗa Daadamazhigǝl biya. ");
INSERT INTO glwl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Daghuvala ciig ma gǝtlaha, da maay nǝ ghwalvah kǝsa uuss biya, da maay dlaɓ pǝghwav nǝ dǝghwah da vǝgya zhiil biya. Ar da nǝg band zarha ɓǝlga Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Dlaɓa tǝghǝr kǝ ciig ma gǝtlaha, karantama bi kǝ dǝgiti tagakur nǝ Daadamazhigǝl taakiya, ");
INSERT INTO glwl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Kai nǝ Daadamazhigǝla Ibrahim, Daadamazhigǝla Ishaku, ard Daadamazhigǝla Yakub biya’? Daadamazhigǝla lii dǝ shifǝg nǝ iina, dǝga lii ǝmtsaharaǝmtsahǝg biya.” ");
INSERT INTO glwl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Cinngara ba nǝ uudah ǝndkwana, kaa ɓa jappǝr kǝ iitǝr tǝdvad tsagaanaana. ");
INSERT INTO glwl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Cinngara ba nǝ Farisiyah taakiya piletǝvaatag nǝ dǝga tag kǝ Sadukiyah vak Yesu, kaa dzahav kǝ iitǝr. ");
INSERT INTO glwl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mǝng nǝ dadda tsaga adzahadzaha Mus ma taatakatǝr kwa fǝsha Yesu dǝ ndavǝga. ");
INSERT INTO glwl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Amaa, “Dadda tsaga dǝgit, kwar ka adzahadzah wa juujig ma adzahadzah baɗǝmmi?” ");
INSERT INTO glwl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ngugharangug nǝ Yesu amaa, “ ‘Wayantwaig kǝ Yaazhigǝl Daadamazhigǝlagh bad ǝrviɗmahuɗagh baɗǝmma, baz shifǝgagh baɗǝmma, baz hǝnkalagh baɗǝmma.’ ");
INSERT INTO glwl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kwana iin nǝ adzahadzaha zǝnngwa, dlaɓ iin wa juujig baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Dǝga bu ndakwi band dǝga zǝnngwa, ‘Waiyantwaig kǝ tlǝgharaawakyaghagh band ghǝragha.’ ");
INSERT INTO glwl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Baɗǝm nǝ adzahadzaha Musa ard tlayangngaha araa haciga bat kwanahaan ka adzahadzah buna.” ");
INSERT INTO glwl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Dzaharvǝt ba nǝ Farisihyah vak palla, kaa ndavtǝruundavǝg nǝ Yesu, ");
INSERT INTO glwl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","amaa, “Auwa tlatlǝg nǝ ghǝraru tǝghǝr kǝ Kǝristi? Zǝra war ni nii?” Aiyam nǝ iitǝr taa kǝ iina, “Zǝra Dauda.” ");
INSERT INTO glwl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Am nǝ Yesu taa kǝ iitǝra, “Ɓagaa ndar ci nǝ Daud tǝdvad ndzǝɗa Shiɗǝkw Daadamazhigǝl ɗaha dǝ, ‘Yaazhigǝli’? Am nǝ Dauda, ");
INSERT INTO glwl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Am nǝ Yaazhigǝl taa kǝ Yaazhigǝlara, “Cihuracihurǝg tǝ dǝvaa kafara bamma nandalnǝg kǝ tlǝghumahagh da mizhangyil kǝ shigahagha.” ’ ");
INSERT INTO glwl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Akwama ɗaag dǝ Kǝristi nǝ Daud kǝ ‘Yaazhigǝl tsaa,’ Nǝgal ndar kaci nǝ Kǝristi kǝ zǝraani?” ");
INSERT INTO glwl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Maay wa ngugharangug biya. Ciigǝt daghuvala kwahiina maay wa gwiya shughana gyiya ndavgharundavǝg biya. ");
INSERT INTO glwl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Am Yesu taa kǝ dzaha dlamaa kǝlaawa ard mbǝrzahaana, ");
INSERT INTO glwl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Vǝlavtǝr kǝ lii tsaga adzahadzaha ard Farisiyah nǝ ndzǝɗa tsaga adzahadzaha Musa. ");
INSERT INTO glwl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mbakyarvad kwaha, famfǝg kǝ hǝnkal kǝ ɓa dǝgitahi ar tsagkur nǝ iitǝra, ɓagam bi kǝ dǝgiti ar ɓag nǝ iitǝr biya. Aɗaba ar maay ɓa dǝgiti ar tsag nǝ iitǝr biya. ");
INSERT INTO glwl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ar ngwaɗant kǝ kadlanngah kwa ɗǝmɗǝma, ar faatǝra kǝ uudah ma ghǝra, ghǝravaatǝr ndakwani ar maay mǝltǝrumǝlǝg aanji dǝ zǝra dǝv pal biya. ");
INSERT INTO glwl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Baɗǝm nǝ dǝgitahi ar ɓag nǝ iitǝra, ar ɓag ba kiyava nǝghǝganǝghǝg kǝ uudaha, ar mbaghant kǝ ǝlbǝga Daadamazhigǝl ba maandala, ar ngwaɗǝt tǝ ghaiya uuvǝgaatǝra, dlaɓa ar kutǝr kǝ sǝɗav kwada apatsapats ba tlaɗ tlaɗ tuuk ghaiyaana. ");
INSERT INTO glwl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ar naa ba vǝlvǝtǝr vaka ndzǝgan marawa vaka ɓa hwaɗaga, ard dǝga ndzǝgan ndannga ma guda dzǝgwazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ar naa ba fǝvtǝraaran dǝ taa uus ma kasukwa, dlaɓa ar naa ba ɗahvǝtǝr dǝ ‘Dadda Tsaga Dǝgita’. ");
INSERT INTO glwl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Aiciya, aa ɗaakur bi nǝ uud dǝ ‘Dadda Tsaga Dǝgiti’ biya, aɗaba Dadda Tsagkur Dǝgit ba palla, am ba zaraabah baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ɗahambi aanji war dǝ ‘Daada,’ ma duni biya, aɗaba ba pal nǝ Daada kǝskurama, kwama ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Aa ɗahkur bi dlaɓ nǝ uud dǝ ‘Tlǝvuukw’ biya, aɗaba ba pal nǝ Tlǝvuukw kǝskurama, iin nǝ Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Baɗǝm nǝ dadda kwa ɗyak ma kuurama, aa nǝdalnǝg kǝ ghǝraan kǝ kwatnahaaruwa. ");
INSERT INTO glwl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Baɗǝm dadda kwa fǝgaara ghǝrana da nenneva, dadda kwa nenna ghǝraana, da fǝvaarafǝga. ");
INSERT INTO glwl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Dǝga zhuwadaal kǝsǝkuram lii tsaga adzahadzaha Musa ard Farisaha, muniyaha! Hǝɗamarduhǝɗǝg nǝ uuram kǝ ɗuula daa damma tlǝksǝra ghǝrazhigǝla. Kuram dǝ ghǝravaru ndakwi damagha biya, dlaɓa ɓǝlamtǝrnaa bi kǝ lii naa daas biya. ");
INSERT INTO glwl_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Dǝga zhuwadaal kǝ sǝkuram lii tsaga adzahadzaha Musa ard Farisiyaha, muuniyaha! Am naa ba zaa kadlanga ǝngwasahi ruuwa zaalahatǝra, am naa ba dzǝgwazhigǝl ba tlaɗa kiyava nǝghǝkurnǝghǝg kǝ uuda, mbakyarvad kwaha, da vǝlkurvǝlǝg nǝ uud kǝ dlaɗ ba vaivaya. ");
INSERT INTO glwl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Dǝga zhuwadaal kǝ sǝkurama lii tsaga adzahadzaha ard Farisiyaha, muuniyaha! Am dahadagal damma kǝsah shahshah dlaɓa am dzava yuwa haiya kiyava tlǝkna dadda pǝlaghǝr aanji ba palla, akwama tlamkǝnatlǝga, am nǝdal kǝ zǝra kaara fai juujig kǝskurama. ");
INSERT INTO glwl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Dǝga zhuwadaal kǝskuram gulfaha lii martǝr ɗuul kǝ uudaha! Am taakiya, ‘Baɗǝm nǝ dadda kwa zaazǝg kǝ ngwaɗǝg dǝ vǝgya Daadamazhigǝla maay nǝ dǝgit tǝ vakai biya, baɗǝm nǝ dadda kwa zaazǝg kǝ ngwaɗǝg dǝ adawan kwa ma vǝgya Daadamazhigǝla, barari viigaan nǝ ngwaɗǝga.’ ");
INSERT INTO glwl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kuram dlagah gulfaha, kwar wa juujig dǝ ɗyaka, adawan nii, vǝgya Daadamazhigǝli kwa ɗǝfghaaka adawanhi? ");
INSERT INTO glwl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Am taagaan taakiya, ‘Baɗǝm dadda kwa zǝgga ngwaɗǝg dǝ bagadiya, maay dǝgit tǝ vakai biya, aɗaba baɗǝm dadda kwa zǝgga ngwaɗǝg dǝ vǝlga gyagyaan kwa ɗiyav tǝ bagadiya, barari viigaan nǝ ngwaɗǝga.’ ");
INSERT INTO glwl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kuram gulfahaana, kwar wa juujig kǝ ɗyakǝra! Vǝlga gyagyaan nii bagadi kwa pǝsha vǝlga gyagyaan hi? ");
INSERT INTO glwl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mbakyarvad kwaha, baɗǝm dadda kwa zǝgga ngwaɗǝg dǝ bagadiya kyulǝga, zaazǝg kǝ ngwaɗǝg dǝ vakaiya ard dǝgitahi tǝ vakai baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Baɗǝm dadda kwa zǝgga ngwaɗǝg dǝ vǝgya Daadamazhigǝla, zaazǝg kǝ ngwaɗǝg dǝ vakaiya ard Daadamazhigǝl kwa ndzǝga ma vakaiya. ");
INSERT INTO glwl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Baɗǝm daddakwa zǝgga ngwaɗǝg dǝ ghǝrazhigǝla, zaazǝg kǝ ngwaɗǝg dǝ avǝda kwarga Daadamazhigǝla ard dadda kwa cihurga tǝ vakaiya. ");
INSERT INTO glwl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Dǝga zhuwadaal kǝ sǝkuram lii tsaga adzahadzaha ard Farisiyaha, muuniyahaana! Am sagal dǝ pal ma kǝlaaw ma kadlangaha caccakuram ǝnd kyimba, araariya ard mbakila, lamwalǝg kǝ ɓaa dǝgitah kwa juujig kǝ maraw ma adzahadzaha, ǝnd jiira, zhuwadaala ard fadghǝra, kwanahaan wa maa dlaiyaan kǝskuram kǝ ɓagaan ba kwal ɗugars kǝskuram kǝ ɓaa kyalmahaana. ");
INSERT INTO glwl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kuuram gulfaha lii martǝr ɗuul kǝ uudaha, am rahgarzharahǝg kǝ dǝgiti ǝngykwah ǝnd dǝg pǝghyiga, bakǝvakwaha, am ndǝgaan kǝ adlǝgwama. ");
INSERT INTO glwl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Dǝga zhuwadaal kǝskuram lii tsaga adzahadzaha ard Farisiyaha, muuniyaha! Am bar ba ilgaan kǝ kuwa ard dafa, aɗaba mahuɗmahaɗa righarighan dǝ dlǝrmǝg ard naaghǝra. ");
INSERT INTO glwl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kǝgh gulfa zhiila Farisiya, farzhafǝg kǝ bara huɗa kuwa ard huɗa dafa, aɗaba ilgaan ndakwani nal ba cuwaɗaɗɗa. ");
INSERT INTO glwl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Dǝga zhuwadaal kǝskuram lii tsaga adzahadzah ard Farisiyaha, muuniyaha! Am band gǝtlah kwa masavǝt nǝ dǝgit tǝll tǝ vakaiya, kwa maraw kǝ vazǝg tǝ ɓalaɓala, mahuɗmahuɗa righarighan dǝ tlatla uudahi ǝmtsaharaǝmtshǝga ard dǝgitahi ghwaɗghwaɗa. ");
INSERT INTO glwl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Am band kwah ghǝravaruwa, mar zharkurzharǝg nǝ uudah tǝ ɓalaɓala, am band uudaha jirjira, mbats mahuɗmahuɗa, am righarighan dǝ muuniyira ard kǝlaadǝra. ");
INSERT INTO glwl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Dǝga zhuwadaal kǝskurama, lii tsaga adzahadzaha ard Farisiyah, muuniyaha! Aɗaba am ndara gǝtlaha tlayanngaha, dlaɓa am caɗa gǝtlaha uudaha jiirjiira. ");
INSERT INTO glwl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Am tagaan dlaɓ taakiya, ‘Akwama kǝmnda ndza mǝng nǝmnd ma zamana daadijahamnda, maa mǝlamntǝrubi kǝ ɗiya avǝza tlayanngah biya.’ ");
INSERT INTO glwl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tǝdvad kwah wa maramda nǝ uuram taakiya, kuram zarha lii ciɓara tlayanngha. ");
INSERT INTO glwl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Bam zavukw dǝ ghyǝnnga tlǝraha kǝlaadǝrǝn kwa fǝgharzha nǝ daadijaru kǝ ɓagaana. ");
INSERT INTO glwl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kuram ghavalahaana, kuram faɗǝga ghavalahaan dǝ gurna! Am da ngǝdlgarwa ndandar nǝ uuram kǝ kaara faiyi? ");
INSERT INTO glwl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mbakyarvad kwah wan ɓǝlkur nai kǝ tlaiyangaha ard lii ɗyamɗyamǝr ard lii tsaga adzahadzaha Musa, am da ciɓgaan kǝ kyalmaha, am da hǝrtǝt kǝ kyalmaha, dlaɓa am da ɓaltǝra kǝ tsǝg kǝ kyalmah ma guda dzǝgwazhigǝlaruwa, baz gatǝrgatǝg kǝskuram damma kǝssaha, am vǝltǝr dlaɗa. ");
INSERT INTO glwl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Aɗabad kwaha, da gwiya daa damma kunngyaru nǝ avǝza uudaha jiijiir kwa ciɓava ma duniya, ciigǝt tǝ avǝza Habil uuda jiirjiir tangw da tǝ avǝza Zakariya zǝra Berekiya, kwa tsama nǝ uuram ma taataka bagadi ard vǝgya Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Bak jiirjiir wan tagkur naiya, baɗǝm nǝ wanahaan da dzǝgaardzǝg dǝ uudaha zamana. ");
INSERT INTO glwl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Au wan Wurshalima, Wurshalima! Lii ciɓa tlaiyannga Daadamazhigǝla, lii ɗawala lii ɓǝlavant da vakaruwa, shig ngwan kǝskai na dzaha kuram band kwa dzahǝg nǝ ghwacik kǝ zarhaan damma dlambakaana, lamwalǝg nǝ uurama. ");
INSERT INTO glwl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Waici, ɗuwakurna ɗuug nǝ uud kǝ vǝgyaru nalnǝg kǝ kwazaha. ");
INSERT INTO glwl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Wan tagkurtag ciya, am da maadlai nǝghkwanǝghǝg biya, da ba daghuvala kwam da taag nǝ uuram taakiya, ‘Dǝ bark nǝ dadda kwa sagau ma ɗaaga Yaazhigǝla.’ ” ");
INSERT INTO glwl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Sǝghal ba nǝ Yesu ma Vǝgya Daadamazhigǝla, kaa mǝla dagalaana, kaa margardamarǝg nǝ mbǝrzahaan kǝ vǝgya Daadamazhigǝl ndǝrandǝrana. ");
INSERT INTO glwl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aiyam nǝ Yesu taa kǝ iitǝra, “Am nǝghǝganǝghǝg ba ɗǝmma nǝ wanahaan ndǝrandǝranna? Bak jir wan tagkur naiya, maay na akur aanji pal da Ɗuuvars tǝghǝr kǝ zǝrabaan biya. Da tlagav saaya baɗǝmma.” ");
INSERT INTO glwl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Cihurgan nǝ Yesu ta Aghwa Zaituna, kaa dagau kǝ mbǝrzahaan da vakaana ba daghuvaatǝra, aiyam nǝ iitǝra, “Takǝmndtaga da dzǝgaar hǝr nǝ wanǝn kǝ dǝgiti? Au nǝ dǝgiti kǝm da sǝrgaaka nǝmnd taakiya agha hǝrzh saaya ard ghyinnga zamani?” ");
INSERT INTO glwl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ngwatǝrangug nǝ Yesu, amaa taa kǝ iitǝra, “Famfǝg kǝ hyǝmiya, aa valkurdai nǝ uud biya. ");
INSERT INTO glwl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Aɗaba uudah ba ɗyaka ar da sagau ma ɗaagara ar taakiya, iitǝr nǝ Kǝristiya, ar da valgaan kǝ uudah ba ɗyaka. ");
INSERT INTO glwl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Am da cinngacinng kǝ ǝlbǝga ghwaava ard dlahalǝg ghwaava, gǝdzam biya, aɗaba kwanahaan kǝ dǝgitaha barari bamma dzǝghardzǝga, halavuwaana sǝghǝvbi ndan biya. ");
INSERT INTO glwl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Larda da dǝgaradǝg kǝ kwatlǝrn kǝ Larda dǝ ghwaava. Tlǝksǝra da dǝgara kǝ kwatlǝrn kǝ tlǝksǝr dǝ ghwaava. Da sagau nǝ waiya, haay ndakwani da gajagav vakavak shahshaha. ");
INSERT INTO glwl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Baɗǝmma wanahaan ba fǝgarzhan ndana. ");
INSERT INTO glwl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tǝhala kwaha ar da vaikurvaiga, ar da vǝlkur kǝ dlaɗa, ar da ciɓkurana, ar da naakur bi nǝ uudah mbakyarvad ɗaagar biya. ");
INSERT INTO glwl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ma kwahiin kǝ sarta da ba dyak nǝ uudahi da ɗuwa fadghǝraatǝra, ar da zuu kǝ langyiya zǝraabaahatǝra, dlaɓa ar da naabi kǝ zarabahaatǝr biya. ");
INSERT INTO glwl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tlayannga fiidfiidah ar da sagau badyaka, ar da valda kǝ uudah baɗyaka. ");
INSERT INTO glwl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mbakyarvad ɗyakǝra kǝlaadǝra, wayakǝva uudah baɗyak da maadlaiya. ");
INSERT INTO glwl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Baɗǝm daddakwa ɓǝshgaan tanngw dat halavuwana da tlǝkǝnatlǝg katǝga ");
INSERT INTO glwl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kwan kǝ ǝlbǝg marawa tlǝksǝra ghǝrazhigǝlna da tagav aanji takwar ma duniya, kwakyarvad nal kǝ shiid kǝ uudah baɗǝmma, tǝhalakwaha kaa da sagau nǝ halavuwana. ");
INSERT INTO glwl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Akwama nǝghamanaghǝg kǝ dǝgit dzah kwada sa dǝ ǝmtsǝg ghaciga ma vǝgya Daadamazhigǝla, bandkwa tagada nǝ tlayang Daniyela, dadda karantǝgaana aa nǝghaakanǝghǝga, ");
INSERT INTO glwl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","lii ndzǝga ma Yahudiya, aa mdǝrarǝmdǝrǝg damma aghwaha. ");
INSERT INTO glwl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Dadda kwa tǝghǝra guda, aa sabi saay sa kǝssa dǝgit hǝnnyah biya. ");
INSERT INTO glwl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Dadda kwa ma guuh dlaɓa, aa gwi bi saas sa kǝssa sǝdavaan biya. ");
INSERT INTO glwl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Da dǝga zhuwadaal kǝ ǝngwasahi ǝnhuɗa ard lii dǝ zar ma dlaaga ma kwanǝn kǝ sarta. ");
INSERT INTO glwl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dzǝgwamdzǝgw kǝ zhigǝla aa sabi nǝ ǝmdǝrgǝn ma sarta akuhya ard sarta faciya ngiig biya. ");
INSERT INTO glwl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Aɗaba ma kwahiin kǝ sarta da hǝɓav nǝ dlaɗ ba vaivaiy kwa tapavnai hǝɓgaan gwil fazha duni tangw samma haniina, da maadlabi hǝɓav hulfaan biya. ");
INSERT INTO glwl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","“Maa maay mbakyarvad gulavnagulǝg hǝnngahǝn biya, maa maay nǝ uuda dǝgshig tǝmǝg dǝ shifǝg biya, mbakyarvad uudahaan dzǝravtǝraakaanǝna, da gulav nǝ hǝngaha. ");
INSERT INTO glwl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ma sarta kwahiina, akwama tagakuratag nǝ uud taakiya, ‘Wanam Kǝristi vaakwana!’ bi ‘Wai vaakwaha!’ haiyamant biya! ");
INSERT INTO glwl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Aɗaba da sagau nǝ Kǝristiya fiidfiida ard tlayanngaha fiidfiida, ar da ɓagaan kǝ dǝgaha sǝrga ard dǝgaha jappǝr baɗyak kiyava vala uudaha, akwama ɓagaaɓaga baz lii dzǝravtǝraakana. ");
INSERT INTO glwl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Aiciya, wa tagankurtag bamma sarta. ");
INSERT INTO glwl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Mbakyarvad kwaha, akwama tagakurtag nǝ uud taakiya, ‘Wai nǝ iin ma tǝghala,’ dambi dagal biya. Akwma tagakuratag nǝ uud taakiya, ‘Wai nǝ iin ma huɗa guda,’ haiyamant biya. ");
INSERT INTO glwl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bandkwa wukyiɗǝg nǝ zhigǝl sagatsǝg ba parakrak tanngw dagata. Da band kwah nǝ saaya Zǝra Uuda. ");
INSERT INTO glwl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Vakavaki dǝ dǝgiti ǝmtsaǝmtsana, ar dzahav vaakwah guumbaha. ");
INSERT INTO glwl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Tǝhala hǝɓa dlaɗa nǝghǝgaraa gyina, “ ‘Da ba niknik nǝ faciya, kyil dlaɓa da maay mara parakaan biya, da ɓala saay nǝ kwadladlah tǝ zhigǝla, da gajagav nǝ dǝgitah ɗyak ɗyak tǝ zhigǝla.’ ");
INSERT INTO glwl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Tǝhala kwaha, da nǝghvanǝghǝg nǝ dǝga sǝrga Zǝra Uud tǝ zhigǝla. Baɗǝm nǝ uudaha duniya ar da tuug mbakyarvad dladlawa. Ar da nǝghǝganǝghǝg kǝ Zǝra Uud sii ma akumba dǝ ndzǝɗa ard dǝ ndanngǝr ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Da ɓǝlgaan kǝ zarha ɓǝlgaan da fǝrta dǝraw kwa tuug ba vaivaiya, ar da dzahant kǝ lii dzǝravtǝraaka sagatsǝga, dii dǝ dǝga, saa dǝ sǝga, dagal dǝ dǝga ciigǝt ma ngyila zhigǝl dat ghaalaana. ");
INSERT INTO glwl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Tsagamtsag kǝ ndzǝgana uufa ghǝgiva. Akwama fǝgharzgafǝg nǝ dǝvahaan kǝ ɗa daala ndaɗa, dlaɓa farzha kǝ daala hyǝmiya, sǝramasǝrǝg taakiya hǝrz nǝ madara. ");
INSERT INTO glwl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bandkwah dlaɓ akwama nǝghamanǝghǝg kǝ dǝgitahaan tagankur nai baɗǝmma, sǝramasǝrǝg taaki hǝrzǝthǝrzǝg nǝ sart ba mbɛv dǝ ghaiya guda. ");
INSERT INTO glwl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Bak jiir wan tagkur naiya, uudaha zamanǝnna ar da maay ǝmtsǝg biya, bamma dzǝghardzǝg nǝ wanahaan kǝ dǝgit baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Zhigǝla ard haaya ar da ghyinnga, ǝlbǝgara da maay ghyinng biya. ");
INSERT INTO glwl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Maay wa sǝrgasǝrǝg kǝ sart ma faciyi da dzǝgaar wanǝn kǝ dǝgit biya, aanji Zarha ɓǝlga Daadamazhigǝli ma zhigǝla ma zǝraana, ba Daadiin kaltiya. ");
INSERT INTO glwl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Bandkwa ɓagava ma zamana Nuhu, da dzǝgaar bandkwah daghuvala saaya Zǝra Uuda. ");
INSERT INTO glwl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Band ma kwah kǝ sart lakwti kǝ sagaw kǝ yu kǝlg ɗyaka, ar zǝgaan nǝ uudaha, ar hǝɓgaana, ar gaan nǝ ghwalvah kǝ uusa, pǝghwav dlaɓ nǝ dǝghwaha da vǝgya zhiila, tanngw damma sarti dagha nǝ Nuhu damma pɛrayuwa. ");
INSERT INTO glwl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Lakuti ar nǝghǝgaakanǝghǝg kǝ dǝgiti dagala, nǝghar bak tlǝtǝraatlǝg nǝ ghavala yu kǝlg ɗyak hutstru ba ɗǝmma. Da band kwah dlaɓ nǝ saaya Zǝra Uuda. ");
INSERT INTO glwl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ma kwahiin kǝ sarta, da nǝghvanǝghǝg nǝ uudah bu ɓatlǝr ma guha, da kǝsvant palla, da Ɗuuvars wa palla. ");
INSERT INTO glwl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Da nǝghvanǝghǝg nǝ ǝnghwasah bu ar haiya vaar ǝmtaɗa, da kǝsvant palla, da Ɗuuvars wa palla. ");
INSERT INTO glwl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Mbakyarvad kwaha ndzamandzǝg ba ɓadlaɓadlana, aɗaba am sǝrgai kǝ sarti da saay nǝ Yaazhigǝlaru biya. ");
INSERT INTO glwl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Sǝramasǝrǝg taakiya, akwamaa sǝrgasǝrǝg nǝ dadda hǝnyah kǝ sart da sagau nǝ gǝl da vǝgyaan kavǝɗa, maa maay hǝna haar biya, dlaɓa maa ɗugarnaai kǝ gǝlǝn da vǝgyaan biya. ");
INSERT INTO glwl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mbakyarvad kwaha, kuram ndakwani ɓadlamvǝghaɓadlǝga, aɗaba am sǝrgai kǝ sarti da sii nǝ Zǝra Uud biya. ");
INSERT INTO glwl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“War kaci kwatnahǝn kwa fǝvdǝghǝrǝtfǝgǝna, kwad dabari, kwa fǝghardǝm nǝ dadda hǝnnyahaan kǝ vǝgyaan ma dǝvaan kiya fa hyimi kǝ iin tǝ vakaiyana, dlaɓ vǝltǝr kǝ kaf kǝ kyalma kwatnah bamma sarti? ");
INSERT INTO glwl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Dǝ bark nǝ kwatnahǝn kwada tlǝgara nǝ dadda hǝnyahaan ɓa tlǝr ma sǝghaasǝga. ");
INSERT INTO glwl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Bak jiir wan tagkur naiya, da fǝgardǝmfǝg kǝ kadlanngahaan baɗǝm damma dǝvaan kǝ kiyava fa hyimmi tǝ vakaiya. ");
INSERT INTO glwl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mbatak dadda nguɗi kwatanahǝna, dlaɓa tagaratag kǝ ghǝraan taakiya, ‘Da maay dadda hǝnnyahar saas wats biya,’ ");
INSERT INTO glwl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","da farzha kǝ iin kǝ kala tsaghwaha tlǝraana, dlaɓa zǝgaan kaa hǝɓgaan dǝ lii hǝɓa kya. ");
INSERT INTO glwl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Akwama ɓagaaɓag ǝndkwaha, da saas dadda hǝnnyahaan daghuvali maay ma taɗaan biya dlaɓa ma sarti sǝrgabi nǝ iin biya. ");
INSERT INTO glwl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Da tlǝkǝntlǝgg nǝ dadda hǝnyahaan dǝ tsǝg ba vaivaiya, dlaɓa da vǝlar kǝ dlaɗ ǝmtaɗ dǝ muuniyaha, vaakwaha da tuug nǝ uuda ǝmtaɗ dǝ ghwada dǝv dǝ tlǝrɗa. ");
INSERT INTO glwl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ma kwahiin kǝ sarta, da gǝrav nǝ tlǝksǝra ghǝrazhigǝl dǝ dǝghwah kǝlaawa kwa kǝsarant kaaraha jahuramb da vaka dlǝgha zhiila ghuula. ");
INSERT INTO glwl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Dlǝɓ ma iitǝra ar dlagaha, dlǝɓ dlaɓa ar ɗyamɗyama. ");
INSERT INTO glwl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ma sarta kwa kǝsarant nǝ dlagahaan kǝ kaaraha jahurambatǝra, kǝsarantbi kǝ wal vakaatǝr biya. ");
INSERT INTO glwl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Lii ɗyamɗyamna kǝsarantkǝsǝg kǝ kaaraha jahuramb baz wal ma mǝrt vakaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Zǝlamazǝlmǝg nǝ zhiila ghuulǝn lakwti sagauwa, kaa njitǝrnjiig kǝ haara, ngal ba tsǝtǝratsǝg kǝ haara. ");
INSERT INTO glwl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ma kyakyaka avǝɗa, ngal cinngvacinng nǝ ɗaag taakiya, ‘Wanam zhiila ghuula! Asama sa dlǝghgaana.’ ");
INSERT INTO glwl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kaa ba ciig kǝ dǝghwahaan kǝlaaw ǝmtaɗaatǝra, ar ɓadlǝna kǝ kaaraha jahurammbatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Am nǝ dlagahaan taa kǝ lii ɗyamɗyamna, ‘Gamkǝmndugǝg yaru kǝ wal ba hǝɗiikǝna, aɗaba naa ǝmtsǝg nǝ kaaraha jahurambamnda.’ ");
INSERT INTO glwl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Aiyam nǝ lii ɗyamɗyamǝn taa kǝ iitǝra, ‘Maaya, da tlǝkiyamaara biya. Ngulǝm dam da vak lii vǝlgaan am sǝgwa kǝ dǝgaruwa.’ ");
INSERT INTO glwl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Daral ba nǝ iitǝr da sǝgwa walna, lakwti saas kǝ iitǝra, sǝghaasǝg nǝ zhiila ghuula, kaa daas kǝ lii ɓadlarvǝghaɓadlǝg ǝmtaɗ dǝ iina da vaka hwaɗaga, kaa hǝɗvarduhǝɗǝg nǝ wakyagha. ");
INSERT INTO glwl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Tǝhalakwaha, kaa sǝgaasǝg kǝ dlaga dǝghwahaan dlǝɓna, am nǝ iitǝra, ‘Dadda ndannga, Dadda ndannga, wurkǝmndantwurg kǝ wakyagha!’ ");
INSERT INTO glwl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kaa ngutǝrangug nǝ zhiilaghuulǝn taakiya, ‘Bak jiira wan tagkur naiya, Ən sǝrkur biya.’ ");
INSERT INTO glwl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Mbakyarvad kwaha ndzamandzǝg ba ɓadlaɓadlana, aɗaba am sǝrgai kǝ faciya ma sart biya. ");
INSERT INTO glwl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Tlǝksǝra Daadamazhigǝla band garava uudi kwada dagal dǝ dǝga, kaa ɗahtǝrǝt kǝ kwatnahaan fǝtǝrdǝm kǝ dǝgahaan da mizha dǝvaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Vǝlar kǝ pall kǝ adawan alfu dlǝɓa, pall dlaɓ vǝlar kǝ adawan alfu buwa, vǝlar dlaɓ kwatlǝrǝn kǝ adawan alfu palla, makwaraatǝr vǝlghar ba kalkala ndzǝɗaana, Kaa dagalaana. ");
INSERT INTO glwl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kaa fǝgarzhafǝg kǝ dadda kwa cauwa adawan alfu dlǝɓǝn kǝ mbǝɗa dǝv bat watsǝra, kaa ba tlǝnatlǝg kǝ iin kǝ yu alfu dlǝɓ tuuk vakaiya. ");
INSERT INTO glwl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bandkwah dlaɓ dadda kwa cauwa adawan alfu buna, tlakǝna kǝ yu alfu bu tuuk vakaiya. ");
INSERT INTO glwl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kiyava dadda kwa cauwa adawan alfu pallǝna, nǝghǝghar bak kwaɗǝgakwaɗǝg kǝ affǝk hǝɗnan kǝ kwaɓa dadda hǝnyahaanǝna. ");
INSERT INTO glwl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Tǝhala zǝlmazǝlmǝga, kaa gwiyaghǝra saas kǝ dadda hǝnyaha kwatnahahaan kiyava sǝrgasǝrǝg kǝ dǝgiti ɓagara nǝ iitǝr dǝ kwaɓiina. ");
INSERT INTO glwl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kaa sagau kǝ dadda kwa cauwa adawan alfu dlǝɓǝn dǝ kwatlǝrǝn kǝ alfu dlǝɓa amaa, ‘Dadda hǝnyaha, adawan alfu dlǝɓ wa vǝlghwa nǝnnga. Wan nǝ yu alfu dlǝɓ naa tlǝkǝna nai tuuk vakaiya.’ ");
INSERT INTO glwl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Am nǝ dadda hǝnyahaan taa kǝ iina, ‘Uusa, kwatnaha jiijiira, kwa fǝvdǝghǝrǝtfǝg tǝ vakaiya. Fǝvdǝghǝrǝtfǝg tsau dǝ kǝgh tǝghǝr kǝ zǝr dǝgit hǝdikǝna, ǝn da vǝlakvǝlǝg kǝ tlǝri juujig kwana. Asǝg sa dlaig ǝmtaɗ dǝ kaiya.’ ");
INSERT INTO glwl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Kaa sagau kǝ dadda kwa cauwa alfu buwa adawana, amaa, ‘Dadda hǝnyaha, alfu buwa adawan wa vǝlghwa nǝnnga. Wan nǝ yu alfu bu naa tlǝkǝna nai tuuk vakaiya.’ ");
INSERT INTO glwl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Am nǝ dadda hǝnyahaan taa kǝ iina, ‘Uus, kwatnaha jiijiira, kwa fǝvdǝghǝrǝtfǝg tǝ vakaiya. Fǝvdǝghǝrǝtfǝg tsau dǝ kǝgh tǝghǝr kǝ dǝgit hǝdikǝna, ǝn da vǝlakvǝlǝg kǝ tlǝri juujig kwana. Asǝg sa dlaig ǝmtaɗ dǝ kaiya.’ ");
INSERT INTO glwl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Kaa sagau kǝ dadda kwa cauwa alfu adawan pallna, amaa, ‘Dadda hǝnyaha, ǝn sǝrgasǝrg mbǝlɛmbǝlɛn ɓagakǝv dǝ kǝgha, agha ghuda hii vakavaki riigha biya. Agha vai ba dzaha dǝgit vakavaki kutgha biya. ");
INSERT INTO glwl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Iin wa gǝdzakut kaiya, ǝn kwaɗa kǝ afka ǝn hǝɗnanna. Na kǝ dǝgagha.’ ");
INSERT INTO glwl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Am nǝ dadda hǝnyahaan taa kǝ iina, ‘Kǝgh, kwatnahǝn kǝlaadna, mandǝlghna! Mbats agha sǝrgasǝrǝg taakiya ǝn ghuda hii vakavaki riyana biya, dlaɓa ǝn vai ba dzaha dǝgit vakavaki kutana biya. ");
INSERT INTO glwl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Maa fǝghwifǝg kǝ kwaɓar ma banka, maa bad saasar ǝn tlǝkǝna kǝ yu tuuk vakaiya! ");
INSERT INTO glwl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mbakyarvad kwaha, cauwamarvacaug kǝ alfuwa adawan pallna am vǝlar kǝ dadda kwad alfu kǝlaawna. ");
INSERT INTO glwl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Aɗaba baɗǝm nǝ daddakwa dǝ dǝgita, da fǝvarnaafǝga tlǝkna baɗyaka. Kwa maay dǝ vakai biya, aanji hǝɗikǝni dǝ vakai nǝ iina, da cauwav vakaana. ");
INSERT INTO glwl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ɓǝlamdǝmɓǝlǝg kǝ kǝlaada kwatnahǝn damma gurtla. Vaakwaha da tuug ǝmtaɗ dǝ ghwada dǝv dǝ tlǝrɗa.’ ");
INSERT INTO glwl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ma Sarti da saay nǝ Zǝra Uud ma ndanngǝraan ǝmtaɗ dǝ zarha ɓǝlga Daadamazhigǝl baɗǝmma, ngal da cihura tǝ avǝd ndanng ma tlǝkǝsǝraana. ");
INSERT INTO glwl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Da dzahvant nǝ uudaha duni badǝm da tǝvuukwana, da wahtǝrzha kǝ uudah hutsǝg buwa, bandkwa wahgarzh nǝ dadda piya alman kǝ tughah ard aagwaha guja. ");
INSERT INTO glwl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Da dzant kǝ tughah damma dǝvaa kafaana, aagwah da tǝ dǝvaa ghyaɓaana. ");
INSERT INTO glwl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Tǝkalakwah da tagtǝrtag nǝ tlǝkǝs kǝ lii tǝ dǝvaa kafaanǝn taakiya, ‘Asamasǝg nǝ uuramǝn fakura nǝ Daadar kǝ barkna! Na dlǝghamadlǝghǝg kǝ tlǝksǝrǝn ɓadlakurna Daadamazhigǝl bamma fazha duniya. ");
INSERT INTO glwl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Aɗaba sarta kwandza njǝkwa nǝ waiya, vǝlamwavǝlǝg nǝ kǝ dǝga zǝga. Sarta kwandza njǝkwa nǝ andǝla, gamwadgǝg kǝ yuwa hǝɓǝga. Ndzan ghulaba, dlǝghamkwidlǝghǝga. ");
INSERT INTO glwl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ndzan maay dǝ sǝɗav biya, vǝlamwavǝlǝg kǝ sǝɗava. Ndzan yang biya, famwufǝg kǝ hyimiya. Ndzan ma guda bǝrfina, nǝghamwanǝghǝga.’ ");
INSERT INTO glwl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Tǝhalakwaha, kaa da ngugarngug nǝ uudaha jiijiir taakiya, ‘Yaazhigǝl, nǝghamnd kak hǝr nǝmnd njak wai kǝm vǝlak kǝ dǝga zǝgi? Bii njak nǝ andǝl kǝm gǝgku kǝ yuwa hǝɓǝgi? ");
INSERT INTO glwl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nǝghamnd kak hǝr nǝmnd agha ghulab kǝm dlǝghkani? Bii agha maay dǝ sǝɗav kǝm vǝlak kǝ saɗavi? ");
INSERT INTO glwl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nǝghamnd kak hǝr nǝmnd agha yangbiya, bii agha ma guda bǝrfin kǝm nǝghkaani?’ ");
INSERT INTO glwl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Kaa da ngutǝrangug nǝ tlǝsksǝn taakiya, ‘Ba jiir wan tagkur naiya, ɓagamaraɓag tsau kǝ daddakwa hǝɗiikǝn pall ma kwanahaan kǝ zaraabaharna, bakalkal amaa ɓagwi ba kǝskaiya.’ ");
INSERT INTO glwl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Tǝhakwah da tagtǝrtaag kǝ lii tǝ dǝvaa ghyaɓaan taakiya, ‘Yagham vakar lii tlafatlafanǝnna, damdǝg damma kaara fai kwa maay ghyinng ba dǝm biya, kwa ɓadlavarna kǝ Shatanah ard zarha ɓǝlgaana. ");
INSERT INTO glwl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aɗaba ndza njǝkwa nǝ waiya, vǝlamwa bi kǝ dǝga zǝg biya. Ndza njikwa nǝ andǝla, gamwad bi kǝ yu biya. ");
INSERT INTO glwl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ndzan ghulaba, dlǝghamkwi biya, ndzan maay dǝ sǝɗav biya, vǝlamwabi kǝ sǝɗav biya, ndzan yang biya, dlaɓa ndzan ma guda bǝrfina nǝghamwa biya.’ ");
INSERT INTO glwl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ghǝravaatǝr ndakwani ar da ngug taakiya, ‘Yaazhigǝla, nǝghamnd kak hǝr nǝmnd agha ɓǝsha wai, bi njak nǝ andǝl, bi agha ghulaba, bi agha maay dǝ sǝɗav, bi agha yang biya, bi agha ma guda bǝrfina kǝm lǝwa kǝ fǝku hyǝmiyi?’ ");
INSERT INTO glwl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Kaa da ngutǝrngug taakiya, ‘Bak jiir wan tagkur naiya, ɓagamara bi tsau kǝ dadda kwa hǝɗiikǝn pall ma uudahaanǝn biya, ɓagamwi bi kǝskai biya.’ ");
INSERT INTO glwl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Kwanahaan kǝ uudaha, ar da hǝɓa dlaɗ tangw damma zǝrazǝra, uudaha jiikiira ar damma shifǝga tangw damma zǝrazǝra.” ");
INSERT INTO glwl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ghyǝnnga ba Yesu kǝ tagtǝr kwanahaan kǝ dǝgitah baɗǝmma, aiyama taa kǝ mbǝrzahaana, ");
INSERT INTO glwl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Am sǝrgasǝrǝg taakiya tǝmaa ba hǝnng bu kǝ Hwaɗaga Haarakǝsa Dzava Hǝnyaha, da vǝlǝvda dlaɓ nǝ Zǝra Uuda da hǝrtǝvǝta.” ");
INSERT INTO glwl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kaa dzahav kǝ maalah ma zhiila kǝsauufah ard tlǝvuukwah tǝghǝr kǝ uudaha ma vǝgya maal ba tingting ma zhiila kǝsauufah, kwa ɗahav dǝ Kayafa. ");
INSERT INTO glwl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kaa ba ɗiya sawariya viya Yesu kǝ iitǝr da gǝlagǝl kiyava tsǝgaan kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Aiyam nǝ iitǝra, “Ɓag yam bi sarta hwaɗag biya, haik kǝ ciya hǝnkal kǝ uudaha.” ");
INSERT INTO glwl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ma sartǝn ndza ma Bitani nǝ Yesu ma vǝgya Siman kwandza njakǝn vǝcca. ");
INSERT INTO glwl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Kaa sagau nǝ uusiin da vak Yesu dǝ mǝrta kwa ɓagava dǝ akura onis, righarighan dǝ tǝrshǝn bǝtbǝt kwa ba pir ganan ɗiyarǝt dat ghǝr ma sartǝn ndza zaa dǝga zǝg nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nǝghǝghara ba nǝ mbǝrzahǝn ǝndkwaha, kaa badzǝg kǝ ǝrviɗmahuɗatǝra, aiyam nǝ iitǝra ma taatakatǝra, “Badza ba dǝgiti nǝ wanna. ");
INSERT INTO glwl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Maa vǝlavu nǝ tǝrshinna, maa tlavkǝnatlǝg nǝ kwaɓ ba ɗyaka maa vǝlavtǝrvǝlǝg kǝ talagaha.” ");
INSERT INTO glwl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Sǝrghaakasǝrǝg tsau nǝ Yesu kǝ dǝgiti ar tag nǝ iitǝra aiyama taa kǝ iitǝra, “Aujilbǝg am gaghya uusǝn ǝndkwani? Abi dǝgit maraw wa ɓagwi nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ba kǝlaa hǝnga am ba ǝmtaɗ dǝ talagaha, ǝn maay nai ǝmtaɗ dǝ kuram kǝlaa hǝnng biya. ");
INSERT INTO glwl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kwan kǝ tǝrshinǝn aa ɗaigǝt nǝ iin tǝ vǝgharna, aa ɓag kwakyarvad ɓadla hǝɗa kaiya. ");
INSERT INTO glwl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Bak jiijiir wan tagkur naiya, baɗǝm nǝ vakavaki da tagav nǝ ǝlbǝg maraw ma duni baɗǝmma, da ba tagav nǝ dǝgiti ɓagaa nǝ uusǝn kiyava dzamgaana.” ");
INSERT INTO glwl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kaa ba dagal kǝ pal ma mbǝrzah kǝlaawa tar buwna, kwa ɗahav dǝ Yahuda Iskariyuti, da vak maalah ma zhiila kǝsauufaha. ");
INSERT INTO glwl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Aiyama, “Awam da vǝlgwa nǝ uuram, akwama vǝlankurvǝlǝgi?” Ar vǝlar kǝ sǝl kul hǝkǝrɗa. ");
INSERT INTO glwl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ciigǝt tǝ kwahiin kǝ sarta wa fǝgharzha nǝ iin kǝ gata ɗuul vǝltǝr Yesu. ");
INSERT INTO glwl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Daghuvala zǝngwa Hwaɗaga Haara kǝssa bǝruudi kwal yista, kaa sagau nǝ mbǝrzahaan da vak Yesu, am nǝ iitǝr taa kǝ iina, “Vaakwar wagha naag nǝng ma kǝmǝnda ɓadlkana kǝ dǝgazǝg Hwaɗaga Haara kǝssa dzava hǝnyah kiyava zǝgaan kǝskǝghi?” ");
INSERT INTO glwl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Aiyama, “Damdǝg damma huɗa kǝsa da vak uuda nǝ iina, tagamartaga, ‘Daada tsaga dǝgiti, waa taakiya, ɓagaaɓag nǝ sart kwan da zǝg nai kǝ dǝga zǝga Hwaɗaga Haarakǝsa Dzava Hǝnyah ma vǝgyagh ǝmtaɗ dǝ mbǝrzahaara.’ ” ");
INSERT INTO glwl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kaa ɓagaan kǝ mbǝrzahaan bandkwa tagatǝr nǝ Yesu kǝ ɓagaana, kaa ɓadlnaɓadlǝg kǝ iitǝr kǝ dǝga zǝga Hwaɗaga Haarakǝsa Dzava Hǝnyaha. ");
INSERT INTO glwl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ɓǝlaa ba hwaasa, ngal cihuran da za dǝga zǝga ǝmtaɗ dǝ mbǝrzahaan kǝlaawa tar buwa. ");
INSERT INTO glwl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ar tǝghǝrdǝga za dǝga zǝga, am nǝ Yesu taa kǝ iitǝra, “Bak jiijiir wan tagkur naiya, palla ma kurama da vǝla kaiya.” ");
INSERT INTO glwl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kaa njitǝrnjiig ba vaivaiya, ar farzha kǝ ndavgarundavǝg ba da palla palla ar taakiya, “Kai ni, Yaazhigǝla?” ");
INSERT INTO glwl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kaa ngutǝranguga amaa, “Daddakwa za dǝga zǝg ǝmtaɗ dǝ kaiya ma kuwa, iin wa da vǝla kaiya. ");
INSERT INTO glwl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Zǝra Uuda da ǝmtsǝg bandkwa vindava ma kakkaɗa Daadamazhigǝl tǝghǝr kǝ iina. Dǝga zhuwadaal kǝ daddakwa da vǝla Zǝra Uuda! Ngulǝn maa yava bi nǝ uuda nǝ iin biya.” ");
INSERT INTO glwl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Aiyam nǝ Yahud kwa vǝlǝt Yesu na, “Kai ni, dadda tsaga dǝgita?” Aiyam nǝ Yesu taa kǝ iina, “Kǝgh ndakwani taghǝdataga.” ");
INSERT INTO glwl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ar tǝghǝrdǝga za dǝga zǝga, kaa kǝsgantkǝsǝg nǝ Yesu kǝ bǝruudiya, tagar kǝ uus kǝ Daadamazhigǝla, lahnan vǝltǝr kǝ mbǝrzahaana, amaa, “Namamma zamzǝga, kwana iin nǝ vǝghara.” ");
INSERT INTO glwl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kaa kǝsgantkǝsǝg kǝ iin kǝ kuwa yuwa inabiya, tagar kǝ uus kǝ Daadamazhigǝla, vǝltǝra amaa, “Hǝɓamhǝɓǝg baɗǝmaruwa. ");
INSERT INTO glwl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kwana iin nǝ avǝzara dǝga righa lanngiya kwa ɗiyavda mbakyarvad uudah baɗyaka, kiyava ɓǝsha haipahaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ən tagkurtaga, ǝn madlai da gwiya hǝɓa yuwa inabiyin biya, bamma daghuvali ǝn da hubǝg nai kǝ daalaan ǝmtaɗ dǝ kuram ma tlǝksǝra Daadara.” ");
INSERT INTO glwl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ɓǝlara ba Yesu ard mbǝrzahaan kǝ ǝngsa, kaa sagal kǝ iitǝra, ngal ba dagat kǝ iitǝr damma Aghwa kwa dǝ Uufaha Zaitun. ");
INSERT INTO glwl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Am nǝ Yesu taa kǝ iitǝra, “Bamma huɗa avǝɗna, baɗǝmaru am da mbǝɗǝg ma fadghǝraru am da ɗukusa, mbakyarvad dǝgiti da dzǝgaar dǝ kaiya, aɗaba ba vindavindan taakiya, “ ‘Ənda tsǝgaan kǝ dadda piiya almana, da kwazǝg nǝ agyaragyara tughwaha.’ ");
INSERT INTO glwl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Tǝhala kwama da ciyakutciig nǝ uud dǝ shiifǝga, ǝn da dǝgaa nai tǝghǝr kǝskuram damma Galili.” ");
INSERT INTO glwl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Am nǝ Bitrus taa kǝ iina, “Aanji ar mbǝɗan ma fadghǝraatǝr baɗǝm mbakyarvad dǝgiti da dzǝgaar dǝ kǝgha, ǝn da maay nai biya.” ");
INSERT INTO glwl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Am nǝ Yesu taa kǝ iina, “Bak jiir wan tagak naiya, bamma huɗa avǝɗna, lakuti wiig kǝ ghwatkala, agha da ɓagaan kǝ agajawa sǝrkwai shig hǝkǝrda.” ");
INSERT INTO glwl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Aiyam nǝ Bitrus taa kǝ iina, “Aanji ǝn da ǝmtsǝg ǝmtaɗ dǝ kǝgha, ǝn da maay ɓagaan kǝ agajawa sǝra kǝgh biya.” Tagarar bandkwah dlaɓ nǝ mbǝrzah baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kaa dagal kǝ Yesu ard mbǝrzahaan damma Getsamani, aiymaa taa kǝ mbǝrzahaana, “Ndzamandzǝg vaakwana, ǝn dagal da dzǝgwazhigǝl vaakwaha.” ");
INSERT INTO glwl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kaa ba dagal kǝ iin dǝ Bitrus ard zarha Zabadi buwa, ngal mbǝkǝnmbǝga dlaɓa kaa badza ǝrviɗmahuud kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Amaa dlaɓ taa kǝ iitǝra, “Badzǝga ǝrvidmahuɗǝn ǝn dǝvakai naina, anǝgha ba tsakwitsǝga. Ndzamandzǝg vaakwana, uufamuufǝg ǝmtaɗ dǝ kaiya.” ");
INSERT INTO glwl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Gavǝt ba nǝ iin dagal da tǝvuukw hǝɗiikǝna, ngal tsǝɗi kǝ iin kǝ ghǝraan damma haay dzǝgwa kǝ zhigǝla, amaa, “Daadara, akwama ɓagaaɓaga, kǝswaarakǝssǝg kǝ kwanǝn kuwa dlaɗa, bakǝvakwaha, gat bi kǝ dǝgiti ǝn naag nai biya, bamma dǝgiti agha naag nǝnnga.” ");
INSERT INTO glwl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sagha ba nǝ iin savak mbǝrzahaana, tlatǝra hǝna haara, amaa taa kǝ Bitrusa, “Mbats am uufǝgabi kǝ dǝga aau pal ǝmtaɗ dǝ kai biya. ");
INSERT INTO glwl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Uufamuufǝga am dzǝgwaan dlaɓ kǝ zhigǝl haik dagau kǝskuram damma fǝshiga, shiɗǝkw naagaana, vǝgh wa ɗǝmɗǝma.” ");
INSERT INTO glwl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kaa gwiya dagal kǝ iin kǝ dǝga buwa, dzǝgwa kǝ zhigǝl amaa, “Daadara akwama da ghudkwaarabi nǝ wan kǝ dlaɗ bamma hǝɓanuuhǝɓǝga, aandzandzǝg bat naagagha.” ");
INSERT INTO glwl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Gwiyaghǝra ba nǝ iin saasa, tlatǝra ba hǝna haara, Aɗaba haar wa ma gyiyaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kaa gwiya ɗutǝrǝsɗuug kǝ Yesu, ngal ba gwiya dagal da dzǝgwazhigǝl kǝ dǝga hǝkǝrɗa, kaa gwiya tagaan kǝ iin kǝ ǝlbǝgi tagada nǝ iin wura. ");
INSERT INTO glwl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kaa saas kǝ iin da vak mbǝrzahaan amaa taa kǝ iitǝra, “Gwaastǝn am badlaɓ ba hǝnahaar am ɗiya kuɗga? Wa ɓagaaɓag ci nǝ sart kwada vǝlav nǝ Zǝra Uuda damma dǝv kǝ yaa dadda haipa. ");
INSERT INTO glwl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ciyamciiga, jiyam dagala. Wa sǝghaasǝg nǝ dadda vǝla kaiya.” ");
INSERT INTO glwl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ba ndzǝgaan Yesu ba taa ghaiya, ka sagau kǝ Yahuda pall ma kǝlaawa tar buwna, ǝmtaɗ dǝ dzahava dlamaa kǝlaaw baɗyak dǝ katsakarah ard dǝ zadaha, ɓǝlartǝr nǝ maalah ma zhiila kǝsauuf ard dǝ tlǝvuukwaha. ");
INSERT INTO glwl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aɗaba tagatǝrdatag daddakwa da vǝlgaanǝn kǝ dǝga sǝrgi da marg nǝ iin taakiya, “Dadda kwanda ɓǝrhug nai na, iin nǝ uuda nǝ iin viyamviiga.” ");
INSERT INTO glwl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Bad saasaana, kaa dagau kǝ iin da tǝvǝgh kǝ Yesu amaa taa kǝ iina, “Uus, dadda tsaga dǝgita!” Kaa bǝrhugaan kǝ Yahuda. ");
INSERT INTO glwl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Aiyam nǝ Yesu taa kǝ iina, “Tsaghwa, ɓag kǝ dǝgiti aa sǝkadsǝga.” Kaa sagau kǝ uudahiin, ar viyit kǝ Yesu ar hǝkynana. ");
INSERT INTO glwl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nǝghǝgha ba nǝ pal ma lii ǝmtaɗ dǝ Yesu ǝntkwaha, ngal tǝɗda kǝ katsakaraan ghudarda kǝ hyimmi kǝ kwatnaha maal ba tingting ma zhiila kǝsauufaha. ");
INSERT INTO glwl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Am nǝ Yesu taa kǝ iina, “Gwidǝmgwiig kǝ katsakaragh damma kumbǝghaana, aɗaba baɗǝm daddakwa tǝɗda katsakara, da tsǝg ba katsakara. ");
INSERT INTO glwl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mam tlǝg nǝ uuram ǝn ɗahgant bi kǝ Daadar, tlǝgwadi ba watswats kǝ zarha ɓǝlg kwa juujig kǝ dakwala tlaujah kǝlaawa tar bu biya? ");
INSERT INTO glwl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ai ci tsaa, da righav ndandar wa tagada nǝ Əlbǝga Daadamazhigǝl vindavindan taaki ba pakat wanǝn kǝ dǝgit dzǝgardzǝgi?” ");
INSERT INTO glwl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ma kwahiin kǝ sarta amaa taa kǝ uudahiina, “Amaa sagau dǝ katsakarah ard dǝ zadah da viya kai bandgi ǝn dadda zaa ɗuula? Ba kǝla hǝnnga ǝn bamma gaagazaiya Vǝgya Daadamazhigǝl ǝn tsaga dǝgita, viyamkwa biya. ");
INSERT INTO glwl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Baɗǝm wanahaan dzǝghaar ba kiyava righa dǝgiti vindara nǝ tlayanngah ma Əlbǝga Daadamazhigǝl vindavindana.” Cinngaraba nǝ mbǝzahaan kwanǝnna, kaa ta dagalaatǝr kǝ iitǝr baɗǝm ar ɗuwarsa. ");
INSERT INTO glwl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kaa lanngaan kǝ lii viyarǝt Yesu dagal da vak Kayafa, zhiila kǝsauuf maamaala, vakavaki dzaharvǝt nǝ maalaha lii tsaga adzahadzah ard tlǝvuukwaha. ");
INSERT INTO glwl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Kaa gatǝrgatǝg kǝ Bitrus mahal mahal ba bitky tangw dat ghaiya wakyagha zhiila kǝsauuf maamaala, kaa daas kǝ iin damma gaagazayan cihura ǝmtaɗ dǝ lii uufa wakyagh kiyava vaza dǝgiti da dzǝgardzǝga ");
INSERT INTO glwl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kaa ba gata shiidaha fiid kwada tagav tǝghǝr kǝ Yesu nǝ zhiila kǝsauufah maamaal ard lii ma gyiɗ baɗǝmma, kiyava tsǝgaan kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tlarkǝna biya, bakǝvakwaha mǝng nǝ kyalma uudah ba ɗyak sarǝv sa ɓa shiida fiida. Tǝhalakwaha kaa sagau kǝ uudah buwa ");
INSERT INTO glwl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","aiyam nǝ iitǝra, “Kwan kǝ uuda wa taga taaki, ‘Ən dlagnadlag kǝ vǝgya Daadamazhigǝla, ǝn gwiya ndǝrǝt bamma hǝng hǝkǝrɗa.’ ” ");
INSERT INTO glwl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kaa ciig kǝ maal ba tingting ma zhiila kǝsauufaha, amaa taa kǝ Yesu, “Agha maay dǝ ǝlbǝg biya? Shiidǝn tag nǝ uudahaan tǝghǝr kǝskǝghǝnmi?” ");
INSERT INTO glwl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mbǝɗabi Yesu kǝ ghaiyaan biya. Aiyam maal ba tingting ma zhiila kǝssauufah taa kǝ iina, “Aɗabad Daadamazhigǝl kwad shifǝga, tagkǝmndtag akwama kǝgh Kǝristi, Zǝra Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Aiyam nǝ Yesu taa kǝ iina, “Band kwagha tagda nǝnnga. Ən tagkurtag baɗǝmma, ciigǝt ndakwana am da nǝghǝganǝghǝg kǝ Zǝra Uuda cihurgan tǝ dǝvaa kafa Dadda Ndzǝɗa, sii ma akumba zhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kaa tahdatahǝg kǝ maal ba tingting ma zhiila kǝsauufah kǝ sǝɗavaan mbakyarvad badzǝga ǝrviɗmahuuɗ amaa, “Badzadabadzǝg kǝ ɗaaga Daadamazhigǝla! Kwar kaci kǝ shiid wa kiyam gwiya naag nǝmyami? Amaa cinngacinng aa badza ɗaaga Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Au wamaa nǝghǝga nǝ uurami?” Kaa ngugangug kǝ iitǝr taakiya, “Tlaltlǝg maa tsǝvana!” ");
INSERT INTO glwl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kaa tafgarvatafǝg kǝ iitǝr kǝ ashaghwvai ma huɗvǝga, ar dlaghara kǝ tsǝga, ar ɓalara kǝ mahupennga, ");
INSERT INTO glwl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ar taakiya, “Tagkǝmndtag kǝ tlayanngǝra, akwama ba kǝgh nǝ Kǝristiya, tag kǝ dadda kwa tsaktsǝga!” ");
INSERT INTO glwl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ma kwaniin kǝ sarta, ndza cihurgan ma gaagazaya hǝnnyahiina Bitrusa, kaa sagau nǝ dǝghwiin ɓatlǝr hǝnyahiin da vakaan amaa taa kǝ iina, “Abi ghǝravagh ndakwi agha ǝmtaɗ dǝ Yesu uuda Galilin!” ");
INSERT INTO glwl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kaa ɓala gajau kǝ Bitrus tǝvuukwatǝr baɗǝmma, amaa, “Ən sǝrgabi nai kǝ dǝgiti agha tag nǝng tǝghǝr biya.” ");
INSERT INTO glwl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Saal ba nǝ iin samma bǝrcama, kaa nǝghǝganǝghǝg nǝ dughwi tlǝrǝn kwa ɓa tlǝr ma hǝnyahiina, amaa taa kǝ lii ghacga vaakwahiina, “Kwanǝn kǝ uud araa ndzaa ǝmtaɗ dǝ Yesu uuda Nazarat!” ");
INSERT INTO glwl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kaa gwiya ɓala agajau kǝ Bitrus baz zaha ngwaɗǝg taakiya, “Ən sǝrga bi var kǝ uudanǝn biya.” ");
INSERT INTO glwl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tǝhala zǝlam ba hǝɗikǝna, kaa sagau kǝ lii ghacga vaakwahiin davak Bitrusa, am nǝ iitǝra, “Ba pakat kǝgh ndakwani agha pal nǝng ma iitǝr yaana. Ghayi agha tag nǝng wa markadamarǝga.” ");
INSERT INTO glwl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ngal farzha kǝ tlafa ghǝraana, ndaha ngwaɗǝga, taakiya, “Ən sǝrgai var kǝ uudanǝn biya.” Tǝhala kwaha kaa wiig kǝ ghwatkala. ");
INSERT INTO glwl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kaa dzamnadzamǝg Bitrus kǝ ǝlbǝgi tagghar Yesu taakiya, “Lakuti wiig nǝ ghwatkal hinana, agha da ɓagaan kǝ agajawa sǝrkwai shig hǝkǝrɗa.” Kaa dagal kǝ Bitrus da gyimal ngal tuug kǝ iin ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Wura ba kǝssa, kaa ɗǝya sawariya tsa Yesu kǝ maalaha zhiila kǝsauufa ard tlǝvuukwaha dlamaa kǝlaawa badǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ar ngwaɗarna kǝ dǝva, kaa langan kǝ iitǝr dagala, ar vǝlar kǝ gumna Bilatus. ");
INSERT INTO glwl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nǝghǝgha ban Yahud kwa vǝlǝt Yesu taakiya, ghudavardaghudǝg shariya ǝmtsǝg kǝ Yesu, kaa mbǝkǝnmbǝg ma ǝrviɗya, ngal daas kǝ iin davak lii maamal ma zhiila kǝsauufah ard tlǝvuukwaha, gwitǝrdan kǝ sǝl kul hǝkǝrɗa adawanǝn cauwa nǝ iinna. ");
INSERT INTO glwl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Amaa, “Ɓaganaɓag kǝ haipa kwa vǝlanǝt nai kǝ dadda kwa maay dǝ haipǝn kiyava tsǝgga.” Aiyam nǝ iitǝra, “Au lambamǝndi? Waigagh kǝskǝgha.” ");
INSERT INTO glwl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ɗiida kǝ iin kǝ kwaɓa adawanǝn ma Vǝgya Daadamazhigǝla, ngal dagal hǝrtǝt kǝ ghǝraana. ");
INSERT INTO glwl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ar cagant maalaha zhiila kǝsauufahǝn kǝ kwaɓǝna, amaa nǝ iitǝra, “Dzah laɓa kwaɓiin dǝ kwaɓ Vǝgya Daadamazhigǝla, aɗaba kwaɓa avǝza.” ");
INSERT INTO glwl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kaa ɗiya sawari kǝ iitǝr tǝghǝr kwaɓiina, ar sǝgwa kǝ vakavak vak lii ndǝra shakka, aɗaba nal kǝ vaka hǝɗa zǝr ndzǝgaha. ");
INSERT INTO glwl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kwakyarvad kwan wa ɗahav nǝ iin gwastaan dǝ vaka avǝzna. ");
INSERT INTO glwl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tǝdvad kwan wa righavant nǝ dǝgiti tagada nǝ tlaiyanng Irmi taakiya, “Kǝsavantkǝsǝg nǝ sǝl kwul hǝkǝrɗa adawana, kwaɓi haiyarant nǝ uudaha Israil kǝ ɗiigaan tǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ar sǝgwa kǝ vakavaka vak lii ndǝra shak dǝ vakaiya, bandkwa tagghwa Yaazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ma sartǝn ghacgan nǝ Yesu tǝvuukwa gumna, kaa ndavgarundavǝg kǝ gumǝn taakiya, “Kǝgh nǝ tlǝkessa Yahudaha?” Aiyam nǝ Yesu taa kǝ iina, “Bandkwa agha tagda nǝnnga.” ");
INSERT INTO glwl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kaa ghwadgarnǝs ǝlbǝg kǝ maalaha zhiila kǝsauufah ard tlǝvuukwaha, tagatǝr bi nǝ Yesu aanji ndau biya. ");
INSERT INTO glwl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Aiyam nǝ Bilatus taa kǝ iina, “Agha cinnga bi kǝ ǝlbǝgahaan ar tag nǝ iitǝr tǝghǝr kǝskǝghǝn biya?” ");
INSERT INTO glwl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ngughara bi Yesu kǝ ndavǝg aanji pal biya, kaa ba ɓa jappǝr kǝ gumǝn ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ma kwar kǝ sarta Hwaɗaga Haarakǝsa Dzava Hǝnyaha, nǝtnǝg gumǝn kǝ ɓǝla uud pal sagal ma guda bǝrfin kwa naag nǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma kwahiin kǝ sart ndza mǝng nǝ ɛɛvya kwa sǝrvasǝrg ba vaivai ma guda bǝrfin ɗaagaan Barabbas. ");
INSERT INTO glwl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Dzaharvǝt ba dlamaa kǝlaawa, kaa ba ndavtǝrundavǝg kǝ Bilatus taakiya, “War wam naag nǝ uuram ǝn ɓǝlkurǝsi? Barabbas nii Yesu kwa ɗahav dǝ Kristiyinhi?” ");
INSERT INTO glwl_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Aɗaba sǝrghaakasǝrǝg Bilatus taakiya kwakyarvad shilǝg wa vǝlarda nǝ iitǝr kǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Cihurgan tǝ avǝda ta shari Bilatusa, kaa ɓǝlgantɓǝlǝg nǝ uusaan kǝ ghaiya amaa, “Aa tap bi kǝ uuda jiijiirǝn biya, aɗaɓa mbakwambǝg nǝ dlaɗ ma sǝng haniin tǝghǝr kǝ iina.” ");
INSERT INTO glwl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kaa shahtǝrshahǝg kǝ maalaha zhiila kǝsuufah kǝ dlamakǝlaaw aa tagartag taakiya aa ɓǝlvarsɓǝlǝg nǝ Barabbas, aa tsǝvatsǝg nǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kaa gwiya tagtǝrtag kǝ gumnǝn taakiya, “Kwar ma uudahaan buna wam naag nǝ uuram ǝn ɓǝlkurnǝsi?” Aiyam nǝ iitǝra “Barabbas.” ");
INSERT INTO glwl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Aiyam nǝ Bilatus taa kǝ iitǝra, “Auci wanda ɓag nai dǝ Yesu kwa ɗahav dǝ Kǝristini?” Kaa ngugangug kǝ iitǝr baɗǝm taakiya, “Aa hǝrtǝvǝthǝrtǝga!” ");
INSERT INTO glwl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Am nǝ Bilatusa, “Kwakyarvad auwi? Au nǝ haipi aa ɓaga nǝ iini?” Bakǝvakwaha, gwiya fararaa bad fǝg nǝ uudah kǝ ɗiya cauwa, ar taakiya, “Aa hǝrtǝvǝthǝrtǝga!” ");
INSERT INTO glwl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nǝghǝgha ba nǝ Bilatus taakiya maay nǝ dǝgiti da ɓagaɓag nǝ iin biya, dlaɓa uudaha ar naa ciya jaaga, kaa gǝt kǝ iin kǝ yu barda kǝ dǝvahaan tǝvuukwa uudaha, amaa, “Zhigǝlaa dǝvar ma kunngya, tlǝkwibi nǝ avǝza uuda jiijiirǝn biya. Ba kwa vakaruci waha.” ");
INSERT INTO glwl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kaa ngugangug kǝ uudah baɗǝmma, am nǝ iitǝra, “Dǝgshiga avǝzaana aa dǝg damma kungyamnda ard zarhamnda!” ");
INSERT INTO glwl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kaa ɓǝltǝrnǝsɓǝlǝg kǝ iin kǝ Barabbas. Tǝhalakwa dlaghavaru kiiɓ kǝ Yesu, vǝlda kǝ iin kiyava hǝrtǝvǝta. ");
INSERT INTO glwl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tǝhalakwaha, kaa langaan kǝ tlaujaha gumǝn damma gaagazaiya vǝgya gumna, ar dzaharaa kǝ dakwala tlaujah baɗǝm da tǝghǝr kǝ iina, ");
INSERT INTO glwl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ar sǝɗardan kǝ sǝɗava, ar tsugɗǝm ma sǝɗav kyang hulfa dǝga tlǝksaha. ");
INSERT INTO glwl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ar ɓagara kǝ dzakwa kwarǝg dǝ dǝga taka, ar farǝm maghǝra, ar faraa kǝ hǝkya zad ma dǝvaa kafaana, tǝhalakwaha ar kǝla kǝ ghunj tǝvuukwan ar nenigaan ar taakiya, “Kǝm ma barkagh tlǝksa Yahudaha!” ");
INSERT INTO glwl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ar tafarva kǝ ashaghwvaiya, ar cauwarva kǝ zadiina, kaa kalgaan kǝ iitǝr dǝ zad maghǝra. ");
INSERT INTO glwl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ghyǝngara ba nǝ iitǝr kǝ nenigaana, ar sǝɗardan kǝ sǝɗavǝn kyangna, ar tsugwardǝm kǝ sǝɗavahaana. Kaa langaan kǝ iitǝr kiyava hǝrtǝga. ");
INSERT INTO glwl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ar tǝghǝrdǝga dagala, kaa fadzaghǝr kǝ iitǝr dǝ zhiila Sayirin, ɗaagaan Siman, kaa fǝraafǝg kǝ iitǝr kǝsa tlaɓa hǝrta Yesu bad ndzǝɗa. ");
INSERT INTO glwl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Daral ba nǝ iitǝr da vakavaki ɗahav dǝ Golgota, dǝgiti tuukvakai nǝ Golgota, iin kuwa ghǝra. ");
INSERT INTO glwl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kaa vǝlgarvǝlǝg kǝ iitǝr kǝ yuwa inabi laɓalaɓan dǝ dǝgit ɗyahɗyaha kiyava hǝɓgaana, tapghana ba nǝ iina, lǝwa kǝ hǝɓgaana. ");
INSERT INTO glwl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hǝtaret ba nǝ iitǝra, kaa ba tagwnatagw kǝ iitǝr kǝ sǝɗavahaan tǝdvad tsa tsatsa. ");
INSERT INTO glwl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tǝhalakwaha, kaa cahwarga cahwarǝg kǝ iitǝr vaakwahiin ar uufǝgaana. ");
INSERT INTO glwl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kaa bǝgǝtbǝg kǝ iitǝr kǝ haipaan vindavindan tǝvaghǝraan taakiya, “KWANA IIN NƏ YESU TLƏKSA YAHUDAHA.” ");
INSERT INTO glwl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kaa hǝtǝvǝthǝrtǝg dlaɓ nǝ gǝlah bu ǝmtaɗ dǝ iina, pal tǝ dǝvaa kafaana, pal tǝ dǝvaa ghyaɓaana. ");
INSERT INTO glwl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Uudahi ar tǝ ɗuula dagala ar nenigaana, ar gajaga ghǝra, ");
INSERT INTO glwl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ar taakiya, “Kǝghi tagh taakiya agha dlagnadlag kǝ Vǝgya Daadamazhigǝl agha gwiya ndǝrǝt bamma hǝng hǝkǝrɗa, katǝgci kǝ ghǝragha, akwamma agha ba zǝra Daadamazhigǝla, asǝgci saay tǝ tlaɓa hǝrtǝgǝn ndana!” ");
INSERT INTO glwl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nenner bandkwah dlaɓ nǝ maalaha zhiila kǝsauufaha ard lii tsaga adzahadzaha Muusa ard tlǝvuukwaha, ar taakiya, ");
INSERT INTO glwl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Katghantkatǝg kǝ uudahi tlǝrna, pilgharvaapilǝg kata ghǝraana. Akwama ba iin nǝ tlǝksa yaa Israˈila, aa sasǝgci saay ndan tǝ tlaɓa hǝrtǝgna, lakwti kǝmnda fǝdghǝrǝtfǝg dǝ iina ");
INSERT INTO glwl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tsaghǝr tǝ Daadamazhigǝl tsauwa, aa katǝgci nǝ Daadamazhigǝl ndakwana, akwama ba naagaana, aɗaba tagadatag taakiya, ‘Ən Zǝra Daadamazhigǝla.’ ” ");
INSERT INTO glwl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bandkwah dlaɓ nǝ gǝlah buna kwa hǝrtavtǝrǝt ǝmtaɗ dǝ iina, ghǝravatǝr ndakwani nenǝrnenga. ");
INSERT INTO glwl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ciigǝt dǝ vaci tǝghǝra, tangw damma karfe hǝkǝrɗa hwaasa, hǝɗgharduhǝɗǝg nǝ gurtl kǝ lard baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tamaha karfe hǝkǝrɗa faciya hwaasa kaa dzǝghantdzǝg nǝ Yesu kǝ ghaiya, amaa, “Eloi, Eloi, lama sabaktani?” Iin taakiya, “Daadamazhigǝlara, Daadamazhigǝlara, fiighkwada kwakyarvadawi?” ");
INSERT INTO glwl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Cinngaraba nǝ kyalma uudahi ghaciga vaakwahiin ǝndkwaha, am nǝ iitǝra, “Iliya wa ɗaag nǝ uudanǝnna.” ");
INSERT INTO glwl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Bat watswatsǝra kaa ǝmndǝrg kǝ pallǝraatǝra sǝdaa kǝ abarabara, rǝmndaa kǝ iin ma yuwa zǝra inabi kwarekreka, fǝt tǝ zad vǝlar kiyava hǝɓga. ");
INSERT INTO glwl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Am kyalma, “Ɗuwamarsɗuug ndana, vaziyamvazǝg mbatak da sii nǝ Iliya da katǝgaana.” ");
INSERT INTO glwl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kaa gwiya dzǝgantdzǝg nǝ Yesu kǝ ghai bad halavuuwa ndzǝɗaana, tǝhalakwaha vǝlda kǝ shifǝgaana. ");
INSERT INTO glwl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Bamma kwahiin kǝ sart wa tǝhǝm ɓǝlɛɓǝlɛ kwama Vǝgya Daadamazhigǝl hutsǝg buwa, ciigǝt maghǝr damma suuha. Kaa gajagav kǝ haaya, akurah dlaɓa caɓaracaɓǝga. ");
INSERT INTO glwl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kaa wargǝtwarǝg kǝ gǝtlaha, baɗyak nǝ uudaha jiijiiri ǝmtsaharaǝmtsahǝga, ciyarǝtciig dǝ shifǝga, ");
INSERT INTO glwl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","saharalsahǝg ma gǝtlahaatǝra. Tǝhala ciiga Yesu ma gǝtlaha kaa daas kǝ iitǝr damma gǝdǝrkǝs caccuwanacaccuwana, nǝghartǝrnǝghǝg nǝ uudah baɗyaka. ");
INSERT INTO glwl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ma sartǝn nǝghǝgha nǝ tlauja Roma maamaalǝn ard lii uufa Yesu kǝ gajagava haaya ard dǝgiti dzǝghaardzǝg baɗǝmma, kaa gǝdzǝg kǝ iitǝr ba vaivaiya, aiyam nǝ iitǝra, “Ba pakata, ndza Zǝra Daadamazhigǝla!” ");
INSERT INTO glwl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mǝng dlaɓ nǝ kyalǝma ǝngwasah baɗyak kwa gatar Yesu kǝsantaan ma Galili ar ba mǝlgarumǝlga. Kaa ghacigaghacig kǝ iitǝr ba ndzaɗɗa, ar vaza dǝgiti dzǝgaardzǝga ");
INSERT INTO glwl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ma iitǝra mǝng nǝ Maryam Magadala, ard Maryam babba Yakuba ard Isuvu, dlaɓa ard babba zarha Zabadi. ");
INSERT INTO glwl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ɓǝlaa ba hwaasa, kaa sagau kǝ dadda hyahiina, zhiil Arimatiya, ɗaagaana Isuvu, gharavaan ndakwani mbǝrza Yesu. ");
INSERT INTO glwl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kaa dagau kǝ iin davak Bilatus da ghala tluuwa vǝgha Yesu. Ngal ba vǝlgavǝlǝg nǝ Bilatus kǝ ɗuula kǝsgaana. ");
INSERT INTO glwl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kaa kǝsgantkǝsǝg nǝ Isuvu kǝ tlǝwa vǝgha Yesu, faɗant ma kǝlpakan kwal laliya. ");
INSERT INTO glwl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Fǝdǝm kǝ iin ma daala gǝtlaana, kwa hurghana nǝ iin ma kura. Hǝɗardu kǝ iin kǝ ghaiya gǝtliin dǝ maandala akura, kaa ba dagalaana. ");
INSERT INTO glwl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maryam Magadala, ard kwa pal kǝ Maryam ar cuhurgan ba gyakaɗ dǝ gǝtliina. ");
INSERT INTO glwl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Wurga kǝsaana, tǝhala Faciya Ɓadlavǝgha kaa dzahvǝtdzahǝg nǝ maalaha zhiila kǝsauufah ard Farisah tǝvuukwa Bilatus, ");
INSERT INTO glwl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Aiyam nǝ iitǝra, “Kǝm ma barkagha. Dzamamndnadzamǝg kǝ dǝgiti taga dadda vala uudǝn sarta kwan ndza dǝ shifǝg nǝ iin amaa, ‘Ən da ciig dǝ shiifǝg tǝhala hǝng hǝkǝrɗa.’ ");
INSERT INTO glwl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mbakyarvad kwaha, fǝtǝraafǝg kǝ uudah da uufa gǝtlǝn ba vaivaiya tangw dat hǝng hǝkǝrɗa, haik kǝ dagal kǝ mbǝrzahaan da ghǝla tluuwa vǝghaana, aɗaba ar da tagtǝrtag kǝ uudah taaki ciyitciig ma gǝtlaha. Valga hala da jǝguujig kǝ valga zǝngw ba vaivaiya.” ");
INSERT INTO glwl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Aiyam Bilatus taa kǝ iitǝra, “Dzǝgamǝtdzǝg kǝ tlaujaha, damdǝg da uufǝgaana, ɓagamɓag kǝlaa ndzǝɗaruwa.” ");
INSERT INTO glwl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kaa dagal kǝ iitǝr da uufa gǝtliina, ar tsǝt kǝ dǝga sǝrga tlǝkǝs tǝ akura gǝtliina, dlaɓa ar fǝtǝraa kǝ tlaujah kǝ uufǝgaana. ");
INSERT INTO glwl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Dal ba faciya ngiiga Yahudaha, daghuvala laad ba wur kǝsa, kaa dagal kǝ Maryam Magdaliya ard kwa pallǝn kǝ Maryam da zhara gǝtla. ");
INSERT INTO glwl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kaa gajagvǝtgajag haay baɗyakɗyaka, aɗaba zǝr ɓǝlga Daadamazhigǝl wa sahi ma zhigǝl da tlǝgarwa akurǝn kwa hǝɗavardu dǝ gǝtlna, cihura tǝvakaiya. ");
INSERT INTO glwl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ndzǝganan mbiig band wukyiɗǝga. Sǝɗavaan maɗǝkw ba tǝll band tluuzha. ");
INSERT INTO glwl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nǝghǝghara ba lii uufǝgaana, kaa gǝdzgǝtgǝdzǝg kǝ iitǝr ba vaivaiya, tǝg nǝ vǝghaatǝra, ar mbǝɗa damma haay bandgi ǝmtsaharaǝmtsahǝga. ");
INSERT INTO glwl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Am Zǝr ɓǝlga Daadamazhigǝlǝn taa kǝ ǝnghwasahaana, “Gǝdzam biya, ǝn sǝrgasǝrǝg am gata Yesu kwa hǝrtavǝtta. ");
INSERT INTO glwl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Maay vaakwan biya, ciyitciiga band kwa tagada nǝ iina, wan vakavaki hǝnngavna nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Damdǝg ba watswatsa tagamtǝrtag kǝ mbǝrzahaan taakiya, ‘Ciyitciig ma gǝtlaha, wada dǝgaa nǝ iin tǝghǝr kǝskuram damma Galili, am da nǝghǝga vaakwaha.’ Əna sǝgga bak tagkur kwanǝnna.” ");
INSERT INTO glwl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kaa hadzala dagal kǝ ǝngwasahiin vaka gǝtliina, gǝdzarǝtgǝdzǝga bakǝvakwaha ar dlaig ba vaivaiya, kaa ǝmdǝra daas kǝ iitǝr ar tagtǝr kǝ mbǝrzaha Yesu. ");
INSERT INTO glwl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kaa tlǝtǝraatlǝg kǝ Yesu bad ghǝraana, amaa taa kǝ iitǝra, “Gabǝr tǝghǝr kǝskurama!” Kaa gavva daas kǝ iitǝr ba mbɛɛv da tǝvǝgh kǝ iina, ngal bǝrhwa shigahaan kǝ iitǝr ar ɓagarnǝs kwatnaha. ");
INSERT INTO glwl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Am nǝ Yesu taa kǝ iitǝra, “Gǝdzam biya. Damdǝg tagamtǝrtag kǝ zaraabahar aa dardǝg damma Galili, ar da nǝghǝkwa vaakwaha.” ");
INSERT INTO glwl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ar tǝghǝrdǝga daas nǝ ǝnghwasahiina, kaa daas kǝ kyalǝma lii uufa gǝtlahǝn damma kǝssa, kaa tagtǝrtag kǝ iitǝr kǝ dǝgiti dzǝghaardzǝg baɗǝm kǝ maalah ma zhiila kǝsauufaha. ");
INSERT INTO glwl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Dzahavǝt ba nǝ maalah ma zhiila kǝsauufah ard tlǝvuukwaha dlamaa kǝlaawa, kaa ɗǝya sawari kǝ iitǝr ar vǝltǝr kǝ kwaɓ baɗyak kǝ tlaujaha. ");
INSERT INTO glwl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Aiyam nǝ iitǝra, “Tagamtǝrtag kǝ uudah taaki, ‘Mbǝrzahaan wa ghǝlarda kavǝɗ ma sarta kwa tsakǝmnda haara.’ ");
INSERT INTO glwl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aanji dǝm nǝ ǝlbǝgǝn damma hyǝmmi kǝ gumna, kǝm da tagartag nǝmnd kǝ ǝlbǝga, am da maay hǝɓa dlaɗ biya.” ");
INSERT INTO glwl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kaa caugacaug kǝ tlaujah kǝ kwaɓiina, ar tagda band kwaa tagavtǝra. Kwanǝn kǝ ǝlbǝga, gwastaan ar ba kutgaan Yahudaha. ");
INSERT INTO glwl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kaa dagal kǝ mbǝrzahaan kǝlaawa tǝmkikǝn damma Galili, damma aghwǝn tagatǝr nǝ Yesu taaki aa dzarghǝradzǝga. ");
INSERT INTO glwl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nǝghara ba nǝ iitǝra, kaa ɓagar kwatnahǝr kǝ iitǝra, bakǝvakwaha, kyalmatǝr ɓagar ndaundauwa. ");
INSERT INTO glwl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kaa saas kǝ Yesu sa tǝvǝgh kǝ iitǝr amaa, “Vǝlghwavǝlǝg nǝ uud kǝ ndzǝɗ baɗǝm ma ghǝrazhigǝla ard duniya. ");
INSERT INTO glwl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mbakyarvad kwaha, damdǝg namtǝrdanǝg kǝ uudaha duni kǝ mbǝzahar baɗǝmma, am ɓagtǝra kǝ tsuufǝg ma ɗaaga Daada, ma ɗaaga Zǝra, ard Shiɗkw Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tsagamtǝrtsag kǝ dǝgitahi tagankur nai baɗǝm aa faraarafǝga. Ba pakata ǝn ba ǝmtaɗ dǝ kuram ba kǝlaa hǝnnga tangwa damma ghyinnga zamana.”");
INSERT INTO glwl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kwanǝnna iin nǝ ǝlbǝg maraw tǝghǝr kǝ Yesu Kǝristi, Zǝra Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Bandkwa fǝgharzha nǝ tlayang Ishay kǝ vindǝgaan ma kakkaɗaan taakiya, “Am Daadamazhigǝla, ‘Ənda ɓǝlgaan kǝ zǝr ɓǝlgar kiyava ɓadlak ɗuul lakuti aghada saaya.’ ");
INSERT INTO glwl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Uudana ɓǝla tlǝhǝg ma tǝghala taakiya, ‘Ɓadlamarnaɓadlǝg kǝ ɗuulaan kǝ Yaazhigǝl ba ndǝɗɗa.’ ” ");
INSERT INTO glwl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tsugwa ba nǝ Yuhwan dadda tsufǝg ma tǝghala, kaa tagtǝr ǝlbǝga Daadamazhigǝl kǝ uudaha. Amaa taa kǝ iitǝra, pǝlampǝlǝg kǝ ghǝra ɓag kura nǝ uud kǝ tsuufǝga, dlaɓa ɓǝshkurna Daadamazhigǝl kǝ haipaharuwa. ");
INSERT INTO glwl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kaa ba sagau kǝ uudah baɗyak ma haiya Yahudiya, ard uudah ma kǝssa Wurshalim da vak Yuhwana. Ar tagaan kǝ haipahatǝra, ɓagtǝra kǝ iin kǝ tsuufǝg ma zaagha Judan. ");
INSERT INTO glwl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Sǝɗavi tsuguv Yuhwan ɓagava dǝ guja adlǝgwama. Dǝga ndzǝɗa huɗaana ɓagava dǝ hǝluwa, dlaɓa dǝga zǝgaana, ndzaba ayayuwa ard yuwa mamma. ");
INSERT INTO glwl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kaa tagtǝrtag kǝ iin kǝ uudah taakiya, “Daddakwa da sagau tǝ halara jakwaraajig dǝ ndangǝra, kwa tlanalbi nai kǝ ngǝghrangǝg da pǝla aanji zawwa kimbakaan biya. ");
INSERT INTO glwl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kai ǝn ɓagkur dǝ yu kǝ tsuffǝga, iina da ɓagkur dǝ Shǝɗǝkwa Daadamazhigǝl kǝ tsuffǝga.” ");
INSERT INTO glwl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Makwahiin kǝ sarta, sǝghaasǝg nǝ Yesu saama kǝssa Nazarat ma haaya Galili. Kaa ɓagaraɓag kǝ Yuhwan kǝ tsuffǝg ma zaagha Judan. ");
INSERT INTO glwl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bad sagal Yesu ma yuwa, kaa nǝghǝganǝghǝg kǝ ghǝrazhigǝl wurga, dlaɓa kaa tsugwatsugw Shiɗǝkwa Daadamazhigǝl saay da tǝghǝr kǝ iin band garava kakura. ");
INSERT INTO glwl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kaa cinngalcinng nǝ kungy sii ma ghǝrazhigǝl taakiya, “Kǝgh zǝrara, ǝn wayakwaig ba vaivaiya.” ");
INSERT INTO glwl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Zǝlamai tǝhala kwah biya, kaa langaan kǝ Shǝɗǝkwa Daadamazhigǝl kǝ Yesu damma tǝghala, ");
INSERT INTO glwl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","hǝngaan kwul uufaɗ ba vaakwaha, fǝshgaan Shatanaha. Yesu ndzar ǝmtaɗ dǝ dǝg tǝghalaha, dlaɓa zarha ɓǝlga Daadamazhigǝla sarǝvsǝg da mǝlgarumǝlga. ");
INSERT INTO glwl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tǝhalakwa ɓǝlavdǝm Yuhwan ma guda bǝrfina, kaa dagal kǝ Yesu damma Galili taa ǝlbǝg maraw tǝghǝr kǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Amaa, “Ɓagaaɓag sarta. Tlǝkǝsǝra Daadamazhigǝl hǝrzǝthǝrzǝg saaya. Pǝlampǝlǝg kǝ ghǝra, am fǝdghǝrǝt tǝ ǝlbǝg marawǝna.” ");
INSERT INTO glwl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ghuda dagal nǝ Yesu tǝvǝgh kǝ yuwahaiya Galili, kaa nǝghǝganǝghǝg kǝ iin kǝ Siman ard zǝrababbaan Andrawus, ar bǝla amshiyaha vaiya kilf ma yuwahaiya aɗaba ar ya dadda vaiya kilf nǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Am Yesu taa kǝ iitǝra, “Gatamkwagatǝga, ǝn da nǝkurdalnǝg kǝ lii ɗaha uudah sa vakara.” ");
INSERT INTO glwl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bat watswatsǝra, kaa ɗugarsɗuug kǝ iitǝr kǝ amshiyaha vaiya kilfatǝra, kaa gatǝgaan kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Gavǝt ba nǝ iin da tǝvukw hǝɗikǝnana, kaa nǝghǝganǝghǝg kǝ iin kǝ zarha Zabadi, Yakuba ard Yuhwana. Ar ma pɛrayuwa, ar ɓadla amshiyaha vaiya kilfaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Bat watswatsǝra kaa ɗahtǝrǝt kǝ iina, kaa ɗugarsɗuug kǝ iitǝr kǝ daddaatǝr Zabadi ma pɛrayu ǝmtaɗ dǝ lii hutsarant nǝ iitǝr kǝ ɓa tlǝra, kaa gataa Yesu kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu ard lii gatǝgaan daragha damma kǝssa Kafarnahuma. Ɓagaa ba Faciya Ngiiga, kaa daas kǝ iin damma guda dzahava Yahudaha, kaa farzha tsagtǝr dǝgit kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kaa ɓa jappǝr kǝ iitǝr dǝ tsagaanana, aɗaba tsagatǝr dǝgit ba kalkala, gǝrgǝr dǝ ɗuuli tsag nǝ lii tsaga adzahadzaha Musa. ");
INSERT INTO glwl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Maay ma taaɗatǝr biya, kaa dǝgaadǝg kǝ uuda nǝ iin kwa dǝ shǝɗǝkw ghwaɗ damma guda dzahava, huulǝg taakiya, ");
INSERT INTO glwl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Au lambagh dǝ kǝmnd Yesu Uuda Nazaret? Agha sagau da ghyǝhha kǝmnda? Ən sǝrgasǝrga magha war nǝngnga. Kǝgh daddakwa Caccuwanacaccuwanan sahi vak Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kaa cagaraacag nǝ Yesu kǝ gyi kǝ shǝɗǝkw ghwaɗǝna, amaa taa kǝ iina, “Ɗǝw amǝnga. Assagal ma uudanǝna.” ");
INSERT INTO glwl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kaa gajagantgajag ba dladlaɗ nǝ shǝɗǝkw ghwaɗǝn kǝ uudanǝna. Kaa huulǝg kǝ iin dlaɓa kaa tsugwa dagalaana. ");
INSERT INTO glwl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Baɗǝm nǝ uudahi ndzar vaakwahiin ar ɓa jappǝr ba vaivaiya, baz ndava ghǝrahaatǝr kǝ iitǝr taakiya, “Au wa nǝ iini? Kwar kǝ daala tsaga dǝgit wanii? Tsaga dǝgit ba kalkala. Baz fǝtǝraafǝg kǝ iin kǝ shǝɗǝkw ghwaɗah kǝ ɓa dǝgiti naag nǝ iina.” ");
INSERT INTO glwl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Caaricaari nǝghar bak cinngalcinng nǝ ǝlbǝg tǝghǝr kǝ iin aanji taakwar mahuɗa haaya Galili. ");
INSERT INTO glwl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ba dǝ Sagala Yesu ǝmtaɗ Yakub ar dǝ Yuhwana ma guda dzahava, kaa daas kǝ iitǝr da vǝgyaz Bitrus ar dǝ Andrawus. ");
INSERT INTO glwl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Babba uusa Bitrus hǝngan njǝkǝn fǝɗa. Bat watswatsǝra, kaa tagartag kǝ iitǝr kǝ Yesu kǝ ǝlbǝg tǝghǝra. ");
INSERT INTO glwl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kaa dagau kǝ iin da vakaana, hakyǝnan kǝ dǝvaan ciyanta. Kaa ɗugarsɗuug fǝɗiina, tǝhalakwaha bagtǝra nǝ uusǝn kǝ dǝgzǝga. ");
INSERT INTO glwl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Dǝghwaasa, tǝhala daaya faciya, kaa sǝdǝvsǝg kǝ uudah kǝ lii yangbi baɗǝm ard lii dǝ shǝɗkw ghwaɗ ma vǝghahaatra. ");
INSERT INTO glwl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kaa dzahav kǝ lii ma kǝsiin baɗǝm tǝghaiya hǝnyahiina, ");
INSERT INTO glwl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","kaa mbahnambahǝg nǝ Yesu kǝ lii dǝ kuzah shahshaha. Lagudan baz shǝɗǝkw ghwaɗ mavǝgh kǝ uudaha ba ɗyaka. Ɗuwatǝrnai kǝ shǝɗkw ghwaɗah kǝ taaghai biya, aɗaba ar sǝrgasǝrg ghǝravaatǝr taaki ma war nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Dlakadur ba wurra, lakuti cag nǝ kǝsa, ciyitciig nǝ Yesu ɗugharsɗuug kǝ hǝnyaha, kaa dagal kǝ iin da vakavaki maay band war biya. Dzugwa kǝ iin kǝ zhigǝl vaakwaha. ");
INSERT INTO glwl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kaa dagal kǝ Siman ǝmtaɗ dǝ tsaghwaha dagalaan da gatǝgaana. ");
INSERT INTO glwl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tlararaa ba nǝ iitǝra, kaa tagaratag kǝ iitǝr taakiya, “Baɗǝm nǝ uudah ar gatakǝgha.” ");
INSERT INTO glwl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ngwangwug nǝ Yesu amaa, “Jiyam dagal damma gǝdzǝr kǝssahi kwa hɛffa, kiyava da taa ǝlbǝg maraw kǝskai vaakwah dlaɓa. Aɗaba sanhi mbakyarvad kwah naiya.” ");
INSERT INTO glwl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tǝhala kwaha kaa gwaivagwaig kǝ iin baɗǝm ma haaya Galili, taa ǝlbǝga Daadamazhigǝla ma guda dzahavaatǝra. Lagwdaan dlaɓ kǝ shǝɗkw ghwaɗah ma vǝgha uudaha. ");
INSERT INTO glwl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mǝng nǝ uuda nǝ iin njǝkǝn vǝca sǝv sa vak Yesu, kǝla kǝ iin kǝ ghunja kaa ghalgaan taakiya, “Ma haighanthaiga, agha mbǝkwimbǝgga.” ");
INSERT INTO glwl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kaa zhugardaalazhug kǝ Yesu, ɓǝlaraa kǝ dǝva, amaa taa kǝ iina, “Haiyanant haiga, mbambǝgga.” ");
INSERT INTO glwl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Bat watswatsǝra kaa ɗugarsɗuug kǝ kuza vǝciina, kaa mbǝgambǝg kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kaa ɓǝlgaraɓǝlǝg nǝ Yesu kǝ magiya ba vaivaiya, ɓǝlars kǝ iin dagala. ");
INSERT INTO glwl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Tagarbi aanji ndǝwar kǝ dǝgiti aa dzǝgardzǝg biya. Dǝga agha marda kǝ ghǝragh vak zhiil kǝsuufa, agha ɓaga kǝ kyulǝg bandkwa tagada Musa taakiya aa ɓagavɓag mbakyarvad caccuwagha. Ɓagnaɓag kwana kiyava fadghǝr kǝ uudah taakiya mbǝghambǝga.” ");
INSERT INTO glwl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Dlakulva kwaha, kaa ba dagal kǝ ghwalvǝn kutǝgaana kǝ ɗuuli mbavǝna dǝ iina. Kwan wa fǝghǝra shǝɓav kǝ Yesu akwama dagal damma kwatlǝrǝn kǝ kǝssa, kaa ndza kǝ iin vakavaki maay ndǝwar biya. Bakǝvakwaha, ar fǝgarna ba sagau nǝ uuda da vakaan aanji takwara. ");
INSERT INTO glwl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tǝhala hǝnngaha, kaa gwiya daas dlaɓ kǝ Yesu damma Kafarnahuma, kaa cinngacinng kǝ uudah taaki, sǝghaasǝg sa hǝnnyaha. ");
INSERT INTO glwl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Uudahi dzaharvǝt vaakwahiina, ndzar baɗyak ba vaivaiya, rǝghǝtrǝghǝg vak mbakyarvad uudah hǝnnyaha, baz tǝghaiya wakyagh ndakwani, maadlai vakavak biya. Kaa tagtǝr ǝlbǝg maraw kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kaa lanngaan kǝ uudah uufaɗ kǝ uuda nǝ iin ǝmtsaǝmtsan nǝ vǝgha da vakaana. ");
INSERT INTO glwl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pletǝrvapilǝg daas dǝ vakai da vak Yesu mbakyarvad ɗyakǝra uudaha, kaa ba hurnahurg kǝ iitǝr kǝ ɗuul tǝ ghǝra gud kalkal dǝ Yesu. Wurarant ba nǝ iitǝr kǝ ghǝra gudǝna, kaa ɓǝlgaan kǝ iitǝr kǝ uudanǝn sii tǝ kǝjaana. ");
INSERT INTO glwl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nǝghǝgha ba Yesu kǝ fadghǝratǝra, amaa taa kǝ daddakwa ǝmtsaǝmtsa nǝ vǝghna, “Zǝrara, ɓǝshakanaɓǝshig nǝ uud kǝ haipahagha.” ");
INSERT INTO glwl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ndza mǝnng lii tsaga adzahadzaha Musa cihurgan vaakwahiina, ar dzama dǝgit ma ǝrviɗmahuɗahaatǝra, ");
INSERT INTO glwl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ar taakiya, “Aujilbǝg kǝ uudanǝn taaghai ǝndkwani? Kǝsghantkǝsǝg kǝ ghǝraan band Daadamazhigǝla. Warwa dǝ ndzǝɗa ɓǝsha haipah mamai ba Daadamazhigǝl pall biyi?” ");
INSERT INTO glwl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Batwatswatsǝra, sǝrghaakasǝrg nǝ Yesu ma ǝrviɗmahuɗaana kǝ dǝgiti ar ɗunngɗunng nǝ iitǝr ma ǝrviɗmahuɗatǝra, amaa taa kǝ iitǝr, “Aujilbǝg kǝ sǝkuram dzama kwanahaanii? ");
INSERT INTO glwl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kwarwa juujiga, ngulǝm tagvar kǝ dadda kwa ǝmtsaǝmtsa nǝ ghyaba vǝgh pallǝn, taakiya, ‘Ɓǝshakanaɓǝshig nǝ uud kǝ haipahagh nii, nii taakiya, ciig kǝsantkǝsǝg kǝ kǝjagh dǝgdagalhi?’ ");
INSERT INTO glwl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Manaa naagan mammaa sǝraaka taakiya Zǝra Uuda mǝnng dǝ ndzǝɗa ɓǝsha haipah ma duniya.” Mbakyarvad kwaha, amaa taa kǝ daddakwa ǝmtsaǝmtsa nǝ vǝghǝna, ");
INSERT INTO glwl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Amai kǝsǝkǝgha, ciiga, kǝssant kǝsǝg kǝ kǝjagha dǝg daas da hǝnnyaha.” ");
INSERT INTO glwl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kaa ciig kǝ iina, kǝssant kǝ kǝjaana, kaa mǝla dagalaana. Baɗǝm nǝ uudaha ar vazǝgaana. Kwan wa fǝgharaa aanji war kǝ ɓa ajappǝra, kaa gala Daadamazhigǝl kǝ iitǝra ar taakiya, “Tapamndnabi kǝ nǝghǝg kǝ dǝgit ǝnd kwan biya.” ");
INSERT INTO glwl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kaa gwiya dagal kǝ Yesu dat ghaiya yuwa haiya Galili. Kaa sagau kǝ uudah baɗyak da vakaana, dlaɓa kaa tsagtǝrtsag kǝ iin kǝ dǝgitaha. ");
INSERT INTO glwl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tǝghǝrdǝga dagala, kaa nǝghǝganǝghǝg kǝ iin kǝ Lawi zǝra Halfa cihurga vaka cauwa hadama. Am Yesu taa kǝ iina, “Gatkwagatǝga.” Ngal ba cigǝtciig kǝ iina, kaa gatarsa. ");
INSERT INTO glwl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Davalitlǝrna, ndza kaf nǝ Yesu vǝgya Lawi. Kaa zǝgaan kǝ kyalǝma lii cauwa hadama ard kyalma yaa dadda haipah kǝ kaf ǝmtaɗ dǝ ii ard mbǝrzahaana, baɗyak ndzar gata Yesu. Ar cuhwaran ar zuu kaf ǝmtaɗ dǝ iina ar dǝ mbǝrzahaana, aɗaba uudah baɗyak wa gatargatǝga. ");
INSERT INTO glwl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nǝghara ba lii tsaga adzahadzaha Musa kwar Farisah kǝ Yesu za kaf dǝ yaa dadda haipaha ard lii dza hadama. Kaa ndavgarundavǝg kǝ iitǝr kǝ mbǝrzahaan taakiya, “Aujilbǝg kǝ iin za kaf dǝ lii dza hadama, ard yaa dadda haipahi?” ");
INSERT INTO glwl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Cinngha ba nǝ Yesu ǝnd kwana, amaa taa kǝ iitǝra, “Mai lamba lii yanng dǝ dakut biya, bamma lii yanng biya. Sanhi sa ɗa lii dǝ jiir bi nai biya, sanhi mbakyarvad yaa dadda haipaha.” ");
INSERT INTO glwl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mbǝrzaha Yuhwan dadda tsuufǝga ard dǝga Farisah ar kǝssa ndǝla. Kaa sagau kǝ uudahiin sa ndava Yesu taakiya, “Aujilbǝg kǝ mbǝrzaha Yuhwan ard dǝgaha Farisah ar kǝssa andǝla, kwakyarva dau kǝ dǝgahagh ar maay kǝssa andǝl biyi?” ");
INSERT INTO glwl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ngwatǝrangug Yesu amaa, “Kǝsgaan nǝ tsaghwaha zhiila ghwuul kǝ andǝl akwamar ǝmtaɗ dǝ zhiila ghwuula? Maba ar ǝmtaɗ dǝ zhiila ghwuula ar maay kǝssa ndǝl biya. ");
INSERT INTO glwl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mǝng sarti da sagauwa kwada kǝssav zhiila ghwuul dagal vakaatǝr ɗuuvtǝrsa. Ar da kǝssǝg ma sarta kwah nǝ iitǝr kǝ andǝla. ");
INSERT INTO glwl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Maay wa ghuda daala sǝɗav tlapant tǝ ǝnghura sǝɗava biya. Akwama dzǝghardzǝga, tǝhgaan daala sǝɗavǝn kǝ ǝnghura sǝɗaviina, badzǝgaan da jǝguujig kwandza wura. ");
INSERT INTO glwl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Maay wa ɗiya daala yuwa inabi ma ǝnghura ambǝla hǝlǝw biya. Akwama ɗiyavdǝmɗiiga, kaa ciig kǝ yuwa inabiyin ciɓna kǝ hǝluwǝn, da ɗiya dagal nǝ yuwa inabi, dlaɓa ambǝla hǝluwǝn da badzǝga. Daala yuwa inabi ɗǝyav bamma daala ambǝla hǝlǝwa.” ");
INSERT INTO glwl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Daghuvala faciya ngiiga Yahudaha, Yesu ar dǝ mbǝrzahaan ar ghudadagal ma guha hǝiya. Kaa kalgaan kǝ mbǝrzahaan kǝ kyalma ghǝra hǝiya tǝ ghǝrdǝga. ");
INSERT INTO glwl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Am Farisiyah taa kǝ Yesu, “Zharga, aujilbǝg kǝ mbǝrzahagh ɓa dǝgiti dzah kǝ ɓagaan davala ɗǝyakuɗǝgi?” ");
INSERT INTO glwl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ngwatǝranngug Yesu amaa, “Mbats, tapamnabi karanta dǝgiti ɓaga nǝ Dauda sartakwa mbakǝn waiy ard tsaghwahaan dlaɓa maay dǝgzǝg vakatǝr biya? ");
INSERT INTO glwl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ma zamani ndza Abiyatar nǝ maal ba tinngtimng ma zhiila kǝsuufaha, kaa daas kǝ Dauda damma Vǝgya Daadamazhigǝla, zuu kǝ bruudi kwa favaan ba kǝngǝɗa, hǝyu kǝ zǝgaan aanji wara, bamma zhiila kǝsuufaha. Dlaɓa vǝltǝr baz tsaghwaha dagalaana” ");
INSERT INTO glwl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aiyam nǝ Yesu taa kǝ iitǝra, “Ɓagava kwakyarvad dǝ uud nǝ faciya ngiiga, ndǝrava bi nǝ uud kwakyarvad faciya ngiig biya. ");
INSERT INTO glwl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aɗabad kwaha, Zǝra Uuda, iin Yaazhigǝl baz dǝga faciya ngiiga.” ");
INSERT INTO glwl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Gwiya dagha ba nǝ Yesu damma guda dzahava. Vaakwahiina ndza mǝng nǝ uuda nǝ iin ǝmtsaǝmtsan dǝv palla. ");
INSERT INTO glwl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma uudahi ndzar vaakwahiina, kyalmahaatǝra ndzarandzǝg ba ɗewwa ar zhargaan mbatak da mbǝgaan kǝ uuda nǝ iin daghuvala faciya ngiiga, kiyava tlǝkǝtlǝg kǝ iitǝr dǝ haipa. ");
INSERT INTO glwl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Am Yesu taa kǝ daddakwa ǝmtsaǝmtsan dǝvaana, “Assagal ghacaghacig tǝvuukw vaakwana.” ");
INSERT INTO glwl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kaa ndavtǝru ndavǝg kǝ Yesu amaa, “Haiyakiyamanthaig nǝ adzahadzaha Muus kǝ ɓa dǝgit maraw davala ngiig nii ɓagvǝna kǝladǝrhi? Ngǝdlǝvǝna shifǝgnii tsǝvanhi?” Maay wa mbǝɗghant ghaiyan biya. ");
INSERT INTO glwl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kaa vaztǝrvazǝg kǝ Yesu ba da palla pal dǝ badzǝga rǝviɗmahuda, kaa hǝrsa rǝviɗ kǝ iin mbakyarvad dǝgdǝgka ǝrviɗ mahuɗaatǝra. Aiyama taa kǝ daddakwa ǝmtsaǝmtsa dǝvna, “Vǝllǝg kǝ dǝvagha.” Kaa vǝlgaan kǝ iina, kaa mbǝgambǝg kǝ dǝvaan ba fakya. ");
INSERT INTO glwl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kaa ba dagal kǝ Farisiyaha da ɓa dabari ǝmtaɗ dǝ uudaha Hirudus kǝ ɗuuli ar da tsǝg nǝ iitǝr kǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kaa ciya dagal kǝ Yesu ar dǝ mbǝrzahaan ma kǝsiina, da tǝ ghaiya dǝlva Galili ba davaatǝra, dlaba kaa gatǝgaan kǝ uudah ba ɗyaka vaivaiya ma haaya Galili, ");
INSERT INTO glwl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ma kǝsa Wurshalima, ma Idumiya, ar dǝ lii kilga zaagha Judan, ar dǝ uudaha Taya ar dǝ Sidun. Aɗaba cinngaracinng kǝ dǝgitahi ɓag nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mbakyarvad ɗyakǝra uudaha, kaa tagtǝrtag nǝ Yesu kǝ mbǝrzahaana, aa sarardǝvsǝg kǝ perayu kwa ngyikwaha, haik kǝ tlagaan kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mbakyarvad mbǝghanambǝg kǝ uudah ba ɗyaka, baɗǝm lii dǝ kuzaha ar tlagakǝva kiyava tapǝgaana. ");
INSERT INTO glwl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Baɗǝm sarti ar nǝghǝga shǝɗǝkw ghwaɗaha, ar nǝghaghǝr ba kǝ mbǝɗǝg tǝvuukwana ar huulǝg ar taakiya, “Agha Zǝra Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kaa ɓǝltǝraɓǝlǝg kǝ iin kǝ magi ba vaivai kǝ shǝɗǝkw ghwaɗah taakiya, aa tagararbi kǝ uudah man war nai biya. ");
INSERT INTO glwl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tǝhala kwaha, kaa dagat kǝ Yesu damma aghwa, ɗahant kǝ lii naag nǝ iina, kaa da vakaan kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kaa dzǝrgaaka dzǝrǝg kǝ iin kǝ kǝlawa tar bu ma taatakatǝra (kwa ɗaatǝr nǝ iin dǝ Zǝrɓǝlgahaana). Aɗaba kiyava ndzǝgaan kǝ iitǝr ǝmtaɗ dǝ iina dlaɓa ɓǝltǝrǝt da taa ǝlbǝg marawa. ");
INSERT INTO glwl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Da vǝltǝr dlaɓ kǝ ndzǝɗa lagwa shǝɗǝkw ghwaɗaha. ");
INSERT INTO glwl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wan kǝlawatar buna dzǝrghaaka nǝ iina. Siman, (kwa fǝgharva Yesu kǝ ɗaag Bitrus) ");
INSERT INTO glwl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakubu zǝra Zabadi ar dǝ zǝrababaan Yuhwana, (kwa fatǝrva nǝ iin kǝ ɗaag Buwarnajis, zarha karazhigǝla) ");
INSERT INTO glwl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrawus, Filigus, Bartilumi, Matiyu, Tuma, Yakub zǝra Halfa, Tadiyus, Siman, kwa naagaan kǝ zaa vuukwa kǝssaana, ");
INSERT INTO glwl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yahuda Iskariyuti, kwa vǝlǝt Yesu. ");
INSERT INTO glwl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tǝhala kwaha kaa daas kǝ Yesu da hǝnnyaha, kaa gwiya dzahav dlaɓ kǝ uudaha baz za kaf pǝletǝrvaapilǝg kǝ Yesu ar dǝ mbǝrzahaana. ");
INSERT INTO glwl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Cinngara ba nǝ yaatǝr ndǝkwana, kaa dagau kǝ iitǝr da saa dǝ vakaiya, aɗaba yaatǝr ar taaki, “Nalnǝg kǝ valaaga.” ");
INSERT INTO glwl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Am nǝ lii tsaga adzahadzaha Muusi saral ma Wurshalima, “Mǝng Baˈalzabul, Maala Shatanah ma vǝghaana. Tlakǝna vakaan kǝ ndzǝɗa lagwa shǝɗkw ghwaɗaha.” ");
INSERT INTO glwl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kaa ɗahtǝrantɗahǝg Yesu kǝ uudahiin, kaa tagtǝr kǝ ǝlbǝg dǝ garav taakiya, “Lagwalagw Shatanah kǝ zǝraabaan Shatanaha?” ");
INSERT INTO glwl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Abi, ma tagwavǝmtagw nǝ kwarǝg hutsǝg buwa, kwan kǝ kwarǝga ghaciga biya. ");
INSERT INTO glwl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Band kwah dlaɓa, ma tagwavǝmtagw hǝnnyah hutsǝg buwa, kwan kǝ hǝnnyaha ghacig biya. ");
INSERT INTO glwl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Dlaɓa akwama cigharantciig shatanah kǝ ghǝraana tagwvǝm hutsǝg buwa, ghacig biya. Sǝghaasǝgga halavuwan. ");
INSERT INTO glwl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Maay wa dzugwantdzugw kǝ daas damma vǝgya dadda ndzǝɗ hutsarva kǝ kadlangahaan biya, bamma viyit kǝ uudanǝn nguɗǝnan, Lakuti hutsǝgarvahutsǝg kǝ kadlangaha vǝgyaana. ");
INSERT INTO glwl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ən tagkurtag kǝ jiira, da ɓǝshǝvtǝrnaɓǝshǝg aanji hulfa kwar kǝ haipahi ɓagara nǝ uudaha, ar dǝ ǝlbǝga nenegahi ɓagarara nǝ iitǝr kǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ai ciya, baɗǝm dadda kwa tagǝda ǝlbǝga nenǝg tǝ Shǝɗǝkw Daadamazhigǝla, da ɓǝshvarnaabi ba tangw damma zǝrazǝra biya. Ɓagaaɓag kǝ haipi kwada ɓǝshvarnaabi ba tangw damma zǝrazǝr biya.” ");
INSERT INTO glwl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tagaatag Yesu kwan mbakyarvad ar taakiya, “Dǝ shǝɗkw ghwaɗ nǝ iina.” ");
INSERT INTO glwl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kaa sagau kǝ babba Yesu ar dǝ zarha babbaan. Ar ghacan gyimala ar ɓǝlant kǝ uud da ɗaagaana. ");
INSERT INTO glwl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ndza mǝng nǝ uudah ba ɗyaka ar cahwargan faɗagaan tǝghǝr kǝ iina, am nǝ uuda nǝ iin taa kǝ iina, “Wai baabagh ard zarha baabagh ar ghacǝga gyimala ar naa nǝgha kǝgha.” ");
INSERT INTO glwl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kaa ndavgaru ndavǝg kǝ Yesu taakiya, “War baabara, ard zarha baabarni?” ");
INSERT INTO glwl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kaa vaztǝrvazǝg kǝ iin kǝ lii cahwarga tǝvǝgh kǝ iina, aiyama, “Wan nǝ baabara ard zaraabahara. ");
INSERT INTO glwl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ba ɗǝm daddakwa ɓa dǝgiti naag Daadamazhigǝla, iin zǝraabara, iin nǝ dǝghwa baabara, iin dlaɓ baabara.” ");
INSERT INTO glwl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kaa gwiya tsagaan kǝ Yesu dlaɓ tǝ ghaiya dǝlva Galili. Uudahi faɗarvǝt da tǝghǝr kǝ iina ndzar ba ɗyaka, aɗabad kwaha, iin wa fǝghara daas kǝ iin damma pɛrrayiu cihuran ma vakaiya. Dzahava uudaha ar ghacigan tǝ ghaiya gardza zaagha. ");
INSERT INTO glwl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kaa tsagtǝrtsag kǝ iin kǝ dǝgitah baɗyak tǝdvad garava. Amaa taa kǝ iitǝra, ");
INSERT INTO glwl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Cinngamcinnga, dadda uusǝg dal da riig ma guhaana. ");
INSERT INTO glwl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Riig nǝ iina, kaa ɓalgalɓalǝg kyalma hulf da tǝ ɗuula, kaa sagau kǝ ɗiikah ar caggu. ");
INSERT INTO glwl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kyalma hulfah ɓalal dat caccahǝlawa vakavaki maay haay ɗyak biya. Kaa laghǝra sagal kǝ iitǝr ba watswatsa aɗaba maay haay ɗyak vaakwahiin biya ");
INSERT INTO glwl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ghut ba faciya, kaa fuugalfuug kǝ hǝiy ghulala, aɗaba badi bi kǝ tlali biya. ");
INSERT INTO glwl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kyalǝm ɓalal damma takka, kaa ghubargaraa ghubarg kǝ takka kaa zǝgǝtzǝg kǝ takka tsarva kǝ ya zǝra. ");
INSERT INTO glwl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kyalǝm ɓalal dat haay marawa. Kaa laghǝra sagala kǝ iitǝr ar ghubaran ba marawa, kyalǝmaan yaa zǝr kulhǝkǝrɗ-kulhǝkǝrɗ, kwatlǝrǝn kul ǝngkwah ǝngkwaha, kyalǝm dlaɓa zǝr dǝrmǝk-dǝrmǝka.” ");
INSERT INTO glwl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tǝhala kwaha amaa, “Baɗǝm dadda kwad dǝ hyimya cinngaana aa cinnga.” ");
INSERT INTO glwl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ma sarta kwandza cǝhurgan nǝ Yesu ba daghwvǝna, kaa ghalgaan kǝ mbǝrzahaan kǝlawa tar buwa ard lii gatǝgaan maa tagtǝr kǝ dǝgiti tuuk vakai garavǝna. ");
INSERT INTO glwl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Aiyama taa kǝ iitǝra, “Hayakuranthaig nǝ uud am sǝra kǝ dǝgiti shǝɓashǝɓan tǝghǝr kǝ tlǝkǝssǝra Daadamazhigǝla. Lii maay makuram biya, aanji kwar kǝ dǝgita taggǝvtǝr bad garava. ");
INSERT INTO glwl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Iin wa nǝ iina, “ ‘Aanji ar ba vazǝgaana, ar nǝghǝga biya. Aanji ar cinngaana, ar nǝghǝgaaka biya. Aɗaba haik kǝ nǝghǝgaakanǝghǝg kǝ iitǝra, ar pǝla kǝ ghǝra ɓǝshivtǝrnana.’” ");
INSERT INTO glwl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Aiyam Yesu taa kǝ iitǝra, “Mbats nǝghamakai kǝ garavǝn biya? Am da nǝghǝgaaka ndar kaci kǝ kyalǝmani? ");
INSERT INTO glwl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Dadda riigna, ǝlbǝga Daadamazhigǝl wa riig nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Hulfǝn ɓalal da tǝ ɗuulǝna, iitǝr garava lii cinngaracinng kǝ ǝlbǝga Daadamazhigǝla. Cinngara ba nǝ iitǝra, kaa sagau kǝ Shatanah hutsdan kǝ ǝlbǝgǝn riiyava ma rǝviɗ ma huɗaatǝrna. ");
INSERT INTO glwl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Band kwah dlaɓ hulfǝn ɓalal dat caccahǝlawǝna, iin garava lii bad cinngacinngaatǝr kǝ ǝlbǝgǝna, kaa dlǝghgadlǝgh kǝ iitǝr bad ǝrviɗ ma huɗ palla. ");
INSERT INTO glwl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Aɗaba ar maay tsau dǝ tlali biya, zǝlarmai vaivai biya. Akwama ciyitciig dlaɗ mbakyarvad ǝlbǝga Daadamazhigǝla, bat watswatsǝr kaa gwiya damma haal kǝ iitǝra ");
INSERT INTO glwl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Hulfi ɓalal damma takka, iin garava uudahi cinngaracinng kǝ ǝlbǝgiina. ");
INSERT INTO glwl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Bakǝva kwaha kǝmma dǝga duniya, ard naa hyahha, ard kǝmma kyalǝma dǝgitaha, dagha damma ǝrviɗ ma huɗɗaatǝr tsatǝrvatsǝg kǝ ghubarg ba kwal yiiga kǝ zǝra. ");
INSERT INTO glwl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Hulfǝn ɓalal da tǝ haay marawna, iin garava lii cinngaracinng kǝ ǝlbǝga Daadamazhigǝla, ar dlǝghan, kaa ɓagaan iitǝr kǝ tlǝr dǝ vakaiya, kaa tlǝknatlǝg kǝ iitǝr kǝ yu tuuk vakaiya kyalǝm kul hǝkǝrɗ-kul hǝkǝrɗ, kwatlǝrǝn kul ǝngkwah ǝngkwaha, kyalǝm dlaɓa zǝr dǝrmǝk-dǝrmǝka.” ");
INSERT INTO glwl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Am Yesu taa kǝ iitǝra, “Am sagau dǝ kaara jahuramb am humbara kǝ taas nii? Nii am fǝg mazha ngyil kǝ piin hii? Abi am hǝrtǝg tǝ dǝga hǝrtǝggaan nǝ uuram kǝ kaara jahuramb? ");
INSERT INTO glwl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Maay dǝgiti shǝɓashǝɓan kwa da sǝrvaaka biya. Dlaɓa maay nǝ dǝga gǝlgǝli kwada maay sagal dat ɓalaɓal biya. ");
INSERT INTO glwl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Baɗǝm dadda kwad dǝ hyǝmmiya cinngaana, aa cinngacinnga.” ");
INSERT INTO glwl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Amaa taa kǝ iitǝr dlaɓa, “Cinngamcinng ba maraw dǝgiya” “Darami agha kurǝg nǝng dǝ vakaiya, da kurak dǝ vakai nǝ uuda, da fǝkarna nǝ uuda. ");
INSERT INTO glwl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Baɗǝm dadda kwa dǝ dǝgita, fǝvarnaafǝga, kwa maay nǝ dǝgaan biya, aanji hǝɗikǝnǝn vakaana da kǝsvarǝvkǝsǝga.” ");
INSERT INTO glwl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kaa za vuukw kǝ Yesu taakiya, “Band kwan nǝ ndzǝgana tlǝkǝsǝra Daadamazhigǝla. Band uudi riiya hulf ma guhaana. ");
INSERT INTO glwl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tǝhala hǝngngaha, kaa fǝtsǝgalfǝtsǝg kǝ hulfǝn ghubarana, sǝrghai nǝ uuda nǝ iin kǝ dǝgiti ɓagavanǝn biya. ");
INSERT INTO glwl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Haay sagal dǝ dǝgwaiya bad ghǝraana, ba zǝngwa ɓagga kǝ ghuuva, kaa ɓa ghǝra, tǝhala kwah kaa dǝg kǝ zǝr tǝ vakaiya ");
INSERT INTO glwl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ma tǝhaltǝhǝg nǝ dǝgwaiya, kaa kǝssant kǝ iin kǝ hǝvva kiyava ghudgaana, aɗaba ɓagaaɓag sarta ghudgaana.” ");
INSERT INTO glwl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kaa gwiya tagaan kǝ Yesu taakiya, “Kiyam da kurǝg dau kǝ tlǝkǝssǝra Daadamazhigǝli? Nii kiyam da gǝrǝg dǝ kwar kǝ garav kǝ ndzǝganani? ");
INSERT INTO glwl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Da band dzakǝva hulfa zǝra mastad kwa iin wa mishshish ma hulfaha baɗǝm kwa riiyav damma haaya. ");
INSERT INTO glwl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Bakǝva kwaha, akwama riyavariiga, ghubarǝg juujig kǝ kyalǝma uufahi ma ɗyaghaara guha, dǝvahaan ɓa ba maandala, baz ɗiikah ar tsug ma shǝɗkwaana.” ");
INSERT INTO glwl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tagatǝr dǝ garav nǝ Yesu kǝ ǝlbǝga Daadamazhigǝla ba ɗyak, kalkal dǝ ghaala nǝghǝgaakanǝghǝgaatǝra ");
INSERT INTO glwl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Maay nǝ dǝgiti tagatǝra nǝ iin kwal garav biya. Sarti ar ǝmtaɗ dǝ mbǝrzahaan ba davaatǝra, tagtǝr ba tǝ ɓalaɓal kǝ dǝgitaha. ");
INSERT INTO glwl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ba daghuvalaa nǝ iina, hǝrzǝt ba faci kǝ ɓǝla daaya, am Yesu taa kǝ mbǝzahaana, “Jiyam da tǝ kwah kǝ ghyabba yuwa haiya” ");
INSERT INTO glwl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kaa ɗugarsɗuug kǝ iitǝr kǝ dzahava uudaha, kaa dagal kǝ iitǝr ma pɛrrayiwiin band ndzǝganaani ndza ma vakai nǝ iina. Mǝng dlaɓ kyalma pɛrra yuwah ǝmtaɗ dǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kaa cigǝtciig kǝ kalangasa, fǝgharaafǝg baz yu ciya damma zhigǝla, dlaɓa kaa tsǝgaan kǝ iin kǝ pɛrra yuwa, kaa ghubǝɗa saas kǝ yu samma vakaiya hǝrz pɛrra yuwǝn kǝ righǝgga. ");
INSERT INTO glwl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ndza hǝnna haar nǝ Yesu ma hala pɛra yuwa, ɓǝla kǝ ghǝraan tǝ dǝga ɓǝla ghǝra. Ar ciyant mbǝrzahaana, am nǝ iitǝra, “Dadda tsaga dǝgita, wa kiyam ruuga, kats maay lambagh biya?” ");
INSERT INTO glwl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kaa ciig kǝ Yesu cagara kǝ gyi kǝ fǝɗa, amaa taa kǝ yuwa haiyina, “Ɗew amǝnga! Ndzandzǝgga!” Kaa ghacigaghacig kǝ fǝɗa, baɗǝm vaka ndzaandzǝg ba ɗewwa. ");
INSERT INTO glwl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Amaa taa kǝ mbǝzahaana, “Aujilbǝg kǝskuram gǝdzǝg ndǝkwani? Gwastǝn am maay dǝ fadghǝr biya?” ");
INSERT INTO glwl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kaa gǝdzǝgǝtdzǝg kǝ iitǝr ba vaivaiya, am nǝ iitǝr taa kǝ ghǝrahaatǝra, “War wan kǝ uudi? Baz fǝɗa ar dǝ yu ndakwani ar cinngarnucinngi?” ");
INSERT INTO glwl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Dzǝvaradzǝvǝg Yesu ard mbǝzahaan kǝ yuwa haiya kwa ma larda Garisinaha ");
INSERT INTO glwl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Bad tsugwa Yesu wah sagal ma pɛrra yuwa, kaa sagau nǝ uuda nǝ iin kwad dǝ shǝɗkwa shatanah ma gǝtlah da vakaana. ");
INSERT INTO glwl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kwanǝn kǝ uuda hǝnna bamma gǝtlaha. Maay wa ngwaɗnangwaɗǝg aanji da tsavitsavi biya. ");
INSERT INTO glwl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Aɗaba wura ndza ɗiyav nǝ atsaviyatsavi tǝ dǝvahaan ard shǝgahaan ba ngadlǝgaana. Maaydla wa dǝ ndzǝɗɗa gwiya ngwaɗɗǝgaan biya. ");
INSERT INTO glwl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ba kǝlla hǝng baz faci baz avǝɗ gwayav ma gǝtlaha, baz ma aghwa tsaha huulǝgga harra vǝghaan dǝ akura. ");
INSERT INTO glwl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kǝsgharu ba nǝ iin kǝ gyi kǝ Yesu saas vaka bitkya, kaa ǝmndǝra dagau kǝ iin kǝlla kǝ ghwunj tǝvukwaana. ");
INSERT INTO glwl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Kaa huulǝg kǝ iin bad halavuwa ndzǝɗaana amaa, “Au lambagh dǝ kai, Yesu Zǝra Daadamazhigǝl kwa jujig dǝ ndangǝri? Ən ghala kǝgh ma ɗaaga Daadamazhigǝl, vǝlwabi kǝ dlaɗ biya.” ");
INSERT INTO glwl_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Taggaa mbakyarvad tagghartag Yesu taakiya, “Ɗuwarsɗuug kǝ uudanǝn, kǝgh shǝɗǝkwa shatanahna!” ");
INSERT INTO glwl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kaa ndavgarundavǝg Yesu taakiya, “War ɗaagaghi?” Kaa ngwangug kǝ iina amaa, “Ɗaagara baɗyaka, aɗaba kǝm baɗyaka.” ");
INSERT INTO glwl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kaa ba ghala Yesu kǝ iin baɗyakɗyak haik kǝ lagwtǝrlagw dagal ma lardiina. ");
INSERT INTO glwl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Hǝrz dǝ kwahiin kǝ vakavaka mǝng maandala giɗɗya ghavzah piig tǝ kungula aghwiina ");
INSERT INTO glwl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kaa ghala Yesu kǝ shǝɗkwa shatanahǝn taakiya, “Ɗukǝmndǝsɗuug magha ɓǝlkǝmndǝs daadama ghavzahaana.” ");
INSERT INTO glwl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Haiyatǝranthaig nǝ Yesu. Kaa ba sagal kǝ shǝɗukwa shatanahǝn ar dǝm ma ghavzahaan. Mǝng damma alfu bu nǝ ghavzah ma gyiɗɗǝna, kaa ǝmdǝra daay kǝ iitǝr damma yuwa haiy ar ruwana. ");
INSERT INTO glwl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nǝgharaba lii piya ghavzahaan kǝ dǝgiti dzǝghardzǝgǝna, kaa ǝmdǝra daas kǝ iitǝr da kutǝgaan ma kǝssahaatǝra ard gǝdzǝr kǝssaha. Kaa ba sagau kǝ uudah sa vazza dǝginǝn dzǝghardzǝgǝna. ");
INSERT INTO glwl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Saragha ba nǝ iitǝr da vak Yesu, kaa nǝghganǝghǝg kǝ iitǝr kǝ uudanǝn kwa ndza cǝɓǝg shǝɗkwa shatanahǝn, cǝhurgan tsagwatsagwan ma sǝɗav sǝghaasǝg samma hǝnkalaan balapiya, kaa gǝdzǝgǝtgǝdzǝg kǝ iitǝra ");
INSERT INTO glwl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Uudahi dzǝghaar vakatǝr wanǝnna, kaa ba kutǝgaan kǝ iitǝr kǝ dǝgiti dzǝghaar dǝ daddakwa cǝɓǝg shǝɗkwa shatanaha ar dǝ ghavzaahaana. ");
INSERT INTO glwl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kaa fǝgarzhafǝg kǝ uudah kǝ ghala Yesu maa ɗuwars kǝ haayatǝra. ");
INSERT INTO glwl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tǝ ghǝrdǝga daas Yesu damma pɛrayuwa, kaa ghalgaan kǝ daddakwa ndza tsǝg shǝɗkwa shatanahǝn maa hayarant maa dagal ǝmtaɗ dǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Haigharant bi Yesu biya. Amaa taa kǝ iina, “Dǝg daa da hǝnyah vak zaraabahagha, agha tagtǝr kǝ ɗyakǝra dǝgitahi ɓagaka Yaazhigǝla, baz ɗuuli zhuwakadaala nǝ iina.” ");
INSERT INTO glwl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kaa daas kǝ uudanǝn, farzha kǝ kutǝgaan kǝ dǝginǝn dzǝghardzǝg ma larda Kǝsah Kǝlaw tǝghǝr kǝ dǝgitahaan ɗyakɗyakahaan ɓaghara Yesu. Baɗǝm nǝ uudah kaa ɓa jappǝra. ");
INSERT INTO glwl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Gwiya dzǝva ba Yesu da tǝ kwah kǝ ghyaba yuwa hai ma pɛrayiwa, kaa dzahav kǝ uudah baɗyak da vakaana. Bamma sartǝn ndza ba tǝghaiya yuwa haiy nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kaa dagau kǝ pal ma maalah tǝghǝr kǝ guda dzugwazhigǝla kwa ɗahav dǝ Yayirus. Nǝggha ba nǝ iin kǝ Yesu, kaa mbǝɗǝgambǝɗǝg kǝ iin tǝvuukwana. ");
INSERT INTO glwl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Kaa ghalgaan kǝ iin ba vaivai, taakiya, “Zǝr dǝghwar tǝgherdǝga ǝmtsǝga. Ən ghala kǝgh magha dagau agha tapnan maa mban ndzan dǝ shifǝga.” ");
INSERT INTO glwl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kaa ba dagau kǝ Yesu ǝmtaɗ dǝ iina. Kaa gatgarsgatǝg kǝ uudah baɗyak ar jagwaana. ");
INSERT INTO glwl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ndza mǝng nǝ uus vaakwahiin viigaan kǝlaw tar buwa ba kǝla vǝzza. ");
INSERT INTO glwl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Hǝɓuhǝbǝg kǝ dlaɗ ba vaivai mazha dǝva lii ɓa kǝrgun ba ɗyaka baz kwaɓaan tsatsǝg baɗǝmma. Dlakulva ɓa ngulma, gwiya mbǝrǝg bad mbǝrǝgga. ");
INSERT INTO glwl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ndza cinnghacinng kǝ ǝlbǝg tǝghǝr kǝ Yesu, mbakyarvad kwaha, kaa daas kǝ iin damma uudah kyilgaana, tapnan kǝ sǝɗavaana, ");
INSERT INTO glwl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","dzamgaan ma irǝviɗmahuɗaan taakiya, “Aanji ba sǝɗavaan wan tapna naiya ǝn mbǝga.” ");
INSERT INTO glwl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ba tǝvakaitǝvakai, kaa ghacigaghacig kǝ avǝziin kǝlgiina, dlaɓa cinnghacinng ma vǝghaan taakiya mbavnambǝga. ");
INSERT INTO glwl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ma kwahiin kǝ sarta kaa nǝghǝgaakaa-nǝghǝg kǝ Yesu taakiya mǝng ndzǝɗ aa dǝgal ma vǝghaan, kaa gwivǝtgwiig kǝ iin, amaa, “Warwa tapa sǝɗavari?” ");
INSERT INTO glwl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Am mbǝrzahaan taa kǝ iina, “Awɗa! Agha nǝghǝganǝghǝg kǝ kirfkirf uudah ndǝkwantsǝm, ‘Warwa tapaktapǝg amǝnga?’ ” ");
INSERT INTO glwl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kaa ɓalla gyi kǝ Yesu vazza daddakwa ɓa kwanǝna. ");
INSERT INTO glwl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nǝghaakanǝghǝg nǝ uusǝn kǝ dǝgiti ɓagavaran tsauwa, kaa saas kǝ iin da tǝvuukwa Yesu ma dladlawur dlaɓa vǝghaan tǝgga, mbǝɗa kǝ iin tǝvuukwanna, tagar kǝ iin kǝ jiiraan baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Aiyama taa kǝ iina, “Dǝghwara, fadghǝragha mbakambǝga. Dǝg ma gabǝrǝrra, mbǝghambǝg tuuk kǝ kuzagha.” ");
INSERT INTO glwl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ba ndzǝgaan Yesu ba taaghai, kaa am nǝ uudahi saral ma vǝgya Yayirus, am nǝ iitǝra, “Abi, ǝmtsaaǝmtsǝg nǝ dǝghwiina, gwiya gargyabi kǝ dadda tsagadǝgit biya.” ");
INSERT INTO glwl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Fabi nǝ Yesu kǝ taaɗ tǝ dǝgiti taggar nǝiitǝr biya, amaa kǝ maal tǝghǝr kǝ guda dzǝgwazhigǝlna, “Gǝdz biya, fǝdghǝrǝtfǝga.” ");
INSERT INTO glwl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tsatǝrvatsǝg kǝ gatǝgaan kǝ kyalma uudaha ba Bitrusa, Yakuba ar dǝ Yuhwan zǝrababba Yakuba. ");
INSERT INTO glwl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Daragha ba nǝ iitǝr da ma vǝgya Yayirus, kaa nǝghǝganǝghǝg nǝ Yesu kǝ uudah uushit uushig ghǝratǝr ar tuuga ar huulǝga. ");
INSERT INTO glwl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Dagha ba nǝ iin damma hǝnnyahiina, amaa taa kǝ iitǝra, “Aujilbǝg kǝ sǝkuram am tuug am huulǝg ndǝkwana? Abi, hǝnna haar dǝghwiina au mtsamtsǝga?” ");
INSERT INTO glwl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kaa ɓagar ghwuɓasga neneg kǝ iitǝra. Tǝhalakwaha laguda kǝ iin kǝ uudah da gimala, ɗahant kǝ iin kǝ dadda dǝghwiina, ar dǝ babbaana ar dǝ mbǝrzahaani mtaɗ dǝ iina, ngal daas kǝ iin da vakavaki dǝ dǝghwiina. ");
INSERT INTO glwl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Viyit kǝ iin kǝ dǝva dǝghwna, amaa taa kǝiina, “Talita kumi,” Iin taakiya “Zǝr dǝghwa, ciiga.” ");
INSERT INTO glwl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ba tǝ watsǝra kaa ciig kǝ dǝghwǝn kaa dagala. Viiga dǝghwna kǝlawa tar buwa. Kwan fatǝraafǝg kǝ ɓa jappǝr ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kaa ɓǝltǝrɓǝlǝg Yesu kǝ maggi taakiya aa cinngabi nǝ uudah kǝ dǝginǝn aa dzǝgardzǝgǝn biya, tagtǝr dlaɓ taakiya aa vǝlaralvǝlg kaffa. ");
INSERT INTO glwl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ɗughars ba Yesu kǝ vakava kǝ iin kaa gwiya daas kǝ iin damma kǝsaana, kaa daas kǝ iin ǝmtaɗ dǝ mbǝrzahaana. ");
INSERT INTO glwl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ɓagaa ba sarta ngiiga Yahudaha, kaa farzha kǝ iin kǝ tsagar dǝgit kǝ uudah ma guda dzǝgwazhigǝla. Baɗyak lii cinngaracinnga, ar ɓa jappǝra taakiya, “Tlakǝna mǝr nǝ uudanǝn kwanahaani? Hulfa kwar kǝ sǝrgasǝrgǝr wa vǝlavarvǝlǝg baz dǝga jappǝr ndakwi ɓaagaani?” ");
INSERT INTO glwl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“Abi kafintǝn wanǝn? Zǝra Maryam, zǝrabaz Yakub, ard Isuvuu, Yahuda ar dǝ Siman biya? Abi yigahaan ngwasah wan ǝmtaɗ dǝ kǝmyamǝn?” Kaa za vǝgha dǝ iin kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Aiyam Yesu taa kǝ iitǝra, “Aanji ba war fǝgaarafǝg kǝ tlayang, maay ba nǝ uudaha kǝsaan ard zaraabahaan ard lii vǝgyaan biya.” ");
INSERT INTO glwl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ɓagaabi Yesu kǝ dǝga jappǝr vaakwahiin biya, mbǝghana ba uudah hǝɗikǝn tǝdvad fǝtǝra dǝva. ");
INSERT INTO glwl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kaa ɓa jappǝr kǝ iin tǝdvad maayrǝrra fadghǝghǝratǝra. Kaa gwaivagwaig kǝ Yesu ma kyalma gǝdzǝr kǝssah tsagtǝr dǝgita. ");
INSERT INTO glwl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kaa ba ɗahtǝrǝtɗahǝg kǝ iin kǝ kǝlawa tar buna, ɓǝltǝrǝt kǝiin bu-buwa, vǝltǝr dlaɓ kǝ ndzǝɗ tǝghǝr kǝ shiɗkwa shatanaha. ");
INSERT INTO glwl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ɓǝltǝra kǝ maggi taakiya, “Kǝsam bi kǝ dǝgit kwakyarvad dagalaru biya, aanji dǝgzǝga, ma jilada, bi kwaɓ ma mbǝlaharu biya, ba zad kalti wam kǝssǝg nǝ uurama. ");
INSERT INTO glwl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Famfǝg ba kǝ kimbaka, kǝsambi kǝ kwatlǝrn kǝ sǝɗav biya aandzǝg ba wa tǝ vǝgharuwa. ");
INSERT INTO glwl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Baɗǝm hǝnyahi am dǝgaa nǝ uurama, am ndza vaakwah tangw damma sarti am da ɗuug nǝuuram kǝ kǝssiina ");
INSERT INTO glwl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Baɗǝm vakavaki dlǝghakura bi nǝ uud biya, mam da ciiga am pangda kǝ alagwat tǝ shigahaaru kiyava nǝg kǝ shidaharuwa.” ");
INSERT INTO glwl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kaa ciya dagal kǝ iitǝr, ar tagtǝr ǝlbǝga Daadamazhigǝla kǝ uudah taakiya aa pǝlarpǝlg kǝ ghǝra. ");
INSERT INTO glwl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Lagwardalagw kǝ shiɗkwa shatanah baɗyaka, ar mastǝra kǝ wal kǝ lii yangbi baɗyaka, dlaɓa ar mbahtǝrana. ");
INSERT INTO glwl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kaa cinngacinng kǝ tlǝkkǝs Hirudus kǝ ǝlbǝg tǝghǝr kǝ Yesu, aɗaba cinngalcinng nǝ ɗaagaan aanji takwara. Baz tagaan kǝ kyalǝma uudah taakiya, “Yuhwan dadda tsufǝg wa ciyavant ma gǝtlaha, iin wa nǝ iin dǝ ndzǝɗa ɓaa dǝgaha jappǝr nǝ iin ǝnd kwana.” ");
INSERT INTO glwl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Aiyam kyalma uudaha, “Tlayang Iliya.” Am kyalma, “maaya, kwatlǝrn kǝ tlayang shah, ma tlayangahi ndza wura.” ");
INSERT INTO glwl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Cinngha ba nǝ Hirudus kǝ ǝlbǝgna, aiyama, “Abi, Yuhwan, kwa ghudananai kǝ ghǝr tǝ vakai wa ciyavant ma gǝtlaha!” ");
INSERT INTO glwl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Aɗaba wura ndza Hirudus ba dǝ ghǝraan wa taga taakiya aa viivǝtviig Yuhwan nguɗvǝnan ma guda bǝrfina. Ɓagaaɓag Hirudus ndǝkwan mbakyarvad Hirudiya, uusa zǝraabaan Filigus, kwa kǝsuu Hirudus. ");
INSERT INTO glwl_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Aɗaba ndza taghartag Yuhwan kǝ Hirudus taakiya, “Kalkalaan bi kǝssa uusa zǝrabaabagh biya.” ");
INSERT INTO glwl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mbats, Hirudiya hǝkyaghanahǝkyag kǝ Yuhwan ma ǝrviɗmahuudaana, nahanahǝg maa tsǝvaan, bakǝva kwaha tlakǝna bi kǝ ɗuuli biya, ");
INSERT INTO glwl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","aɗaba Hirudus gǝdzgaan kǝ Yuhwaana. Sǝrgasǝrg nǝ iin taakiya uuda jiirjiir nǝ iina, dlaɓa ba cuwaɗaɗɗa, iin wa fǝghara kǝ Hirudus kǝ hǝkya Yuhwan ba marawwa. Ba cukw sarti taag Yuhwan kǝ ghaiya dǝ vakaiya, mbǝkǝnmbǝg ma ǝrviɗmahuɗaana, bakǝva vakwaha cinngaan kǝ ǝmtakǝra ǝlbǝgaana. ");
INSERT INTO glwl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tǝhalakwaha kaa tlǝkkǝnatlǝg kǝ uusiin kǝ ɗuula, daavala ɓa kwaanda Hirudus, kwa dzahghant nǝ iin kǝ ajanaha ar dǝ tlǝksaha ghwavahaana, ar dǝ uudahi maamaalah ma Galili kwakyarvad hwaɗaga kwandaana. ");
INSERT INTO glwl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Dal ba nǝ dǝghwa Hirudiya da shakalǝg tǝvuukwa Hirudus ar dǝ ghulabahaana, cinngaracinng kǝ mtakǝr ba vaivaiya. Aiyama, “Au wagha naagnǝngi? Baɗǝm dǝgiti aa ghalga nǝng ǝn vǝlakvǝlǝga”. ");
INSERT INTO glwl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Baz zangwaɗǝga, am tlǝkǝssa taa kǝ dǝghwna, “Baɗǝm dǝgiti aa ghalga nǝng ǝn vǝlakvǝlǝga, aanji kyalma tlǝkǝssǝrara.” ");
INSERT INTO glwl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kaa dagal kǝ dǝghwǝn tagar kǝ babbaan, “Awanda ghalg naayi?” Aiyam babbaana, “Ghǝra Yuhwan dadda tsuufǝgga.” ");
INSERT INTO glwl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ba tǝ watsǝr kaa ǝmndǝra da vak tlǝkǝs kǝ iin amaa, “Ən naagan banda kwan ndakwan aa vǝlwavǝlǝg nǝ uud kǝ ghǝra Yuhwan dadda tsuufǝg tǝ pǝlaiya.” ");
INSERT INTO glwl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Cinngha ba nǝ iin kwana, kaa njikǝnjiig ba vaivaiya, amaa mbakyarvad ngwaɗǝgi zuu nǝ iina, ar dǝ ghwulabahaana, naabi kǝ pigardapiig biya. ");
INSERT INTO glwl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kaa bǝlgantɓǝlǝg kǝ iin kǝ kapupuwaan taakiya aa sǝvardaasǝg ghǝra Yuhwan. Kaa dagau kǝ iin damma guda bǝrfin ghwudda kǝ ghǝra Yuhwana. ");
INSERT INTO glwl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Sǝdaa kǝiin tǝ pǝlaiya, vǝlar kǝ dǝghwiina, dǝghwǝn dlaɓa vǝlar kǝ babbaana. ");
INSERT INTO glwl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Cinngaraba mbǝrzaha Yuhwana, kaa dagau kǝ iitǝr ar kǝsant kǝ tluwaana, ar hǝɗnana. ");
INSERT INTO glwl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Gwiyaragwiig dlakulva gyiya Yesu kwa ɓǝlatǝrǝt nǝ iinǝn saasa vakaana, ar tagar kǝ dǝgitahi ɓagara nǝ iitǝr baɗǝmma, ar dǝ dǝgiti tsagaar nǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aɗaba uudah baɗyaka ba kwan daasa kwan sagala, bandva kaffa tlarkǝnai zǝrɓǝlgahaan kǝ ɗuula zǝgaan biya, aiyama taa kǝ iitǝra, “Jiyam dagal da vakavaki maay aanji ndǝwar biya, am ɗiida kuɗǝg hǝɗikǝna.” ");
INSERT INTO glwl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kaa dǝgǝdmǝg kǝ iitǝr damma pɛrrayiwa ar dal da vakavaki maay aanji ndǝwarbi ba iitǝr davaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nǝghara ba nǝ uudah baɗyak kǝ ciya dagalatǝra, dlaɓa nǝghartǝraakanǝghǝga. Kaa ǝmndǝra dagal kǝ iitǝr ba dǝ shǝg sagal ma kǝsah baɗǝmma, kaa tsugwatsug kǝ iitǝr lakuti sagau kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tsugwa ba nǝ Yesu kaa nǝghǝganǝghǝg kǝ uudah faɗǝgaan ba baɗyaka, zhutǝrdaala kǝ iina, Aɗaba ar band tuughah kwal dadda piiga. Kaa tsagtǝrtsag kǝ iin kǝ dǝgitah baɗyaka. ");
INSERT INTO glwl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Hǝrz faci ɓǝladaya kaa sagau kǝ mbǝrzahaan da vakaana, am nǝ iitǝr taa kǝ iina, “Vaakwana maay ndǝwar biya. Faci dlaɓa hǝrz ɓǝladayaana. ");
INSERT INTO glwl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ɓǝlarsɓǝlǝg kǝ uudah maraa dal damma gǝdzǝrkǝssaha ar dǝ kǝssahaan mbɛvmbɛvǝn, maraa sagwa kǝ dǝgitahi da zǝ nǝ iitǝr.” ");
INSERT INTO glwl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ngwatǝrangwug Yesu amaa, “Vǝlamtǝrvǝlǝg nǝ uuram kǝ dǝg zǝgga.” Aiyam nǝ iitǝr taa kǝ iina, “Kǝm sugudasug kǝ dǝgzǝg kalkal dǝ kwaɓi ɗivar kǝ baryam dǝga kyil tǝhs, kǝm vǝltǝr ar zuwa?” ");
INSERT INTO glwl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Amaa taa kǝ iitǝra, “Bruudi ngwen wa vakaruwi? Dam da vazǝgaana.” Vazarna ba nǝ iitǝra, aiyam nǝ iitǝra, “Bruudi dlǝɓa, ar dǝ kilf buwa.” ");
INSERT INTO glwl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kaa tagtǝrtag Yesu kǝ mbǝrzahaan aa tagartǝrtag kǝ uudah ar cahwara dakwal dakwala tǝ kazhakw dǝ gyiya. ");
INSERT INTO glwl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kaa cahwargacahwarǝg kǝ iitǝr dakwal dakwala, kyalǝm dǝrmǝk-dǝrmǝka, kyalǝm kul dlǝɓ kul dlǝɓa. ");
INSERT INTO glwl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kǝsghant ba nǝ iin kǝ ɗummba bruudi dlǝɓa, ar dǝ kilf buwna, dzǝgaan kǝ iin kǝ ghǝraan damma zhigǝl, tagar kǝ uus kǝ Daadamazhigǝla, lahnana kǝ iin kǝ ɗummbahaana vǝltǝr kǝ mbǝzahaana, ar vǝlar kǝ uudaha. Tagwtǝrnan dlaɓ kǝ kilf buuna kǝ mbǝrzahaan ar valtǝr kǝ uudah ba ɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Baɗǝmma zaruuzǝg tlatǝrtlǝga, ");
INSERT INTO glwl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ar dzahant kǝ lahgaha bruudi ar dǝ kilfiina, tlavkǝna nǝ alghw kǝlawa tar buwa righarighan. ");
INSERT INTO glwl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ɗyakǝra uudahi zaru kwanǝn kǝ dǝgzǝga ghwalvah alfu dlǝɓa. ");
INSERT INTO glwl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ba tǝ watsǝra kaa fǝtǝraafǝg nǝ Yesu kǝ mbǝrzahaan damma perrayiwa maraa tsugwa ma Betsaida lakwti dagau kǝ iina, iin dlaɓa ɗiitǝrs kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tǝhalakwa ɗiyatǝrǝs nǝ iin kǝ uudaha, kaa dagat kǝ iin dat kungula aghw da dzugwazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ɓǝlaa ba hwaasa, pɛrrayuna ndza ma taataka yuwahaiya. Ndza ba dlaɓ nǝ Yesu tǝ ghaiya gardz ba daghwvaana. ");
INSERT INTO glwl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nǝgha ba nǝ iin kǝ dlaɗa ɗuulǝgaanaatǝr kwakyarvad ɓagavanaatǝr dǝ fǝɗa, band garava karfi hǝkǝrɗa avǝɗa. Kaa dagal kǝ iin tǝghǝra yu da vakaatǝra. Zǝkk amaa bandgi da ghuda dagala. ");
INSERT INTO glwl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nǝghara ba nǝ iitǝr dagal tǝ ghǝra yuwa, am nǝ iitǝr ndakwani daddkwa sǝgal tǝ afka, kaa huulǝg kǝ iitǝra, ");
INSERT INTO glwl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","aɗaba baɗǝm nǝgharanǝghǝga, kaa gǝdzǝg kǝ iitǝra. Kaa tagtǝrtag kǝ iin taakiya, “Ndavam biya! Ba kaiya, gǝdzam biya!” ");
INSERT INTO glwl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kaa daas kǝ iin damma pɛrrayu ǝmtaɗ dǝ iitǝr, kaa ghacgaghacig kǝ fǝɗiina. Kaa ɓa jappǝr kǝ iitǝr ba vaivaiya, ");
INSERT INTO glwl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","aɗaba ar sǝrgai kǝ dǝgiti tuuk vakai nǝ gǝlla uudah alfu dlǝɓǝn biya, kwakyarvad irrǝviɗmahuɗaatǝra dǝkdǝka. ");
INSERT INTO glwl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Dzǝvara ba nǝ iitǝr kǝ yuwa haiya, ar tsugwa ma Janisarat, ar nguɗǝna kǝ pɛrrayuwiin tǝ ghaiya yuwahaiya. ");
INSERT INTO glwl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ba sagalaatǝr wah ma pɛrrayuwa, caaricaari kaa sǝrgaakasǝrǝg kǝ uudah taaki, mbats Yesu. ");
INSERT INTO glwl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kaa ɓala ǝmdǝrg kǝ iitǝr aanji takwar ma haiyin, kaa ba langarlang kǝ iitǝr kǝ lii yang bi tǝ dǝga hǝnganaatǝr da vakavaaki ar cinnga nǝ iitǝr taakiya vaakwah Yesu. ");
INSERT INTO glwl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Baɗǝm vakavaki dǝgal nǝ iina, bi kǝs ɗyaka, ma zǝr kǝssa, bi ɓalaɓalaha, ar hǝngna kǝ lii ya yangbi tǝ ghaiya kasukwa, ar ghalǝg mbakyarvad lii yangbi maraa tappǝnan aanji ba ghaiya sǝɗavaana. Baɗǝm lii taparnatapǝgga mbaharambahǝgga. ");
INSERT INTO glwl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisiyaha ar dǝ kyalma lii tsaga adzahadzaha Musa lii saral ma Wurshalima faɗarvǝt vak Yesu. ");
INSERT INTO glwl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kaa nǝghǝganǝghǝg kǝ iitǝr kǝ kyalǝma mbǝrzahaan ar zaa kaf kwal barga dǝva, tǝdvad adzahadzahaatǝra ar maay dǝ caccu biya. ");
INSERT INTO glwl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Aɗaba Farisiyaha ard Yahudaha baɗǝm ar maay za kaf ǝndkwah biya, bamma bararabarǝg kǝ dǝvahaatǝra, tǝdvad adzahadzaha daadijahaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ma saraghasǝg saa ma kasukwa, ar maay za kaf ndan biya bamma bararabarga. Mǝng dlaɓ watlǝrǝn kǝ adzahadzaha daadijah baɗyak kwa gwiyaru nǝ iitǝra, dlaɓa ar tsuufǝgaana, band bara kuwa hǝɓɓa yuwa, shakaha, ar dǝ tǝfuwa. ");
INSERT INTO glwl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kaa ndavgarundavǝg kǝ Farisiyaha ar dǝ lii tsaga adzahadzaha Musa kǝ Yesu, “Aujilbǝg kǝ mbǝrzahagh ar maay gata adzahadzaha daadijah ar za kaf dǝ dǝv bakwal caccuwi?” ");
INSERT INTO glwl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ngwatǝrangug taakiya, “Mbats ba kalkal nǝ tlayanngǝra tagga nǝ Ishay tǝghǝr kǝskuram taakiya am muniya! Bandkwa vindava taakiya, “Am Daadamazhigǝla, ‘Ar fǝkwaara bad ghai nǝ uudah kǝskaiya, irrǝviɗmahuɗatǝr biky dǝ kaiya. ");
INSERT INTO glwl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ar ɓagwa ba gyagyaan kǝ kwatnahǝra. Ar tsagtǝr adzahadzaha uudaha, dlakulva ǝlbǝga Daadamazhigǝla.’ ” ");
INSERT INTO glwl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Ɗuwamarsɗuug nǝ uuram kǝ adzahadzaha Daadamazhigǝl kwa tagaa nǝ iin taaki aa gatavgatǝga am gata dǝga daadiij uudaha.” ");
INSERT INTO glwl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Amaa taa kǝ iitǝra, “Am sǝrgasǝrg kǝ ɗuwa adzahadzaha Daadamazhigǝla mbakyarvad am gata dǝga daadijaharuwa! ");
INSERT INTO glwl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Aɗaba tagaatag Musa taakiya, ‘Faarafǝg kǝ daadagha ar dǝ baabagha,’ dlaɓa, ‘Dadda kwa ɗaava daddana bi babbaana barari tsavva.’ ");
INSERT INTO glwl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Am ɗuugarsɗuug nǝ uuram kǝ uudi maay tsa puuta daddaana ar dǝ babbaan biya, farwut taakiya baɗǝm nǝ dǝgit mamma ndza da tlǝkkǝna nǝ uuram vakara fanarafǝg kǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tsamarva ndǝkwah nǝ uuram kǝ mǝlgaru kǝ daddana ard babbaana. ");
INSERT INTO glwl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tǝdvad kwan wam neneg nǝ uuram kǝ ǝlbǝga Daadamazhigǝl mbakyarvad dǝga daadijahi am tsagtǝr nǝ uuram kǝ uudaha. Am ɓag band kwah dlaɓ nǝ uuram kǝ dǝgitah baɗyaka.” ");
INSERT INTO glwl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kaa gwiya ɗahtǝrǝtɗahǝg nǝ Yesu kǝ dlamakǝlaaa, amaa taa kǝ iitǝra, “Cinngamwacinng baɗǝmma, am nǝghaaka dlaɓ ba marauwa. ");
INSERT INTO glwl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Dǝgiti dǝgaa damma vǝgh kǝ uud bi wa fǝgara ndzǝga kwal caccu tǝvuukwa Daadamazhigǝl biya, dǝgiti sagal ma vǝgh kǝ uud wa fǝgaraa ndzǝga kwal caccu tǝvuukwa Daadamazhigǝla.”  ");
INSERT INTO glwl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Daddakwad hyimiya cinngaana aa cinngacinnga. ");
INSERT INTO glwl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tǝhala tagwavaan dǝ uudaha, kaa daas kǝ iin da hǝnyaha, kaa ndavgarundavǝg kǝ mbǝrzahaan kǝ dǝgiti tuuk vakai nǝ wanǝn kǝ garava. ");
INSERT INTO glwl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ngwatǝrangugga amaa, “Mbats kuram ndakwi nǝghamaaka biya? Nǝghamaaka bi taakiya Dǝgiti dǝgaa damma vǝgh kǝ uud bi wa fǝgaraa ndzǝga kwal caccu tǝvuukwa Daadamazhigǝl biya, ");
INSERT INTO glwl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","aɗaba aa dǝhi damma rǝviɗyan biya, aa dǝhi ba damma huɗaana, tǝhalakwaha kaa sagal ma vǝghaana.” (Vaakwana maradamarǝg Yesu taakiya makwar kǝ dǝgzǝga bad caccuwa.) ");
INSERT INTO glwl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kaa zavuukw dǝ taakiya, “Dǝgiti sagal ma vǝgh kǝ uud iin wa fǝgaraa uud ndza kwal caccuwa ");
INSERT INTO glwl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kwakyarvad sagal ma rǝviɗmahuɗa uud nǝ dzama ɓa kǝladǝra, shiɓǝlga, ɓa gǝla, tsa shifǝgga ar dǝ ɓa gwaragwara, ");
INSERT INTO glwl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ard dlǝrmǝga, kǝlaadǝra, valla uudaha, ar dǝ kǝmma dǝga tsa zhǝrwa, ar dǝ shilga, ar dǝ badza ɗaaga, ar dǝ naaghǝra ar dǝ dlagǝra ");
INSERT INTO glwl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Baɗǝm wanahaan kǝ dǝga kǝlaadǝra sagal bamma rǝviɗmahuɗuuda, badzǝgaan kǝ ndzǝgana uuda.” ");
INSERT INTO glwl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kaa ciya dagal kǝ Yesu vaakwahiin damma larda Taya ard Sidon. Kaa daas kǝ iin da vǝgya uudana, nahabi nǝ iin maa sǝran aanji ndǝwar biya. Bakǝvakwaha pǝlewapǝlǝg kǝ shǝɓga. ");
INSERT INTO glwl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Cinngha ba nǝ uusiin kwa tsaag shiɗkwa shatanaha kǝ zǝr dǝghwaan kǝ ǝlbǝg tǝghǝra, caaricaari kaa dagau mbǝɗan tǝvuukwana. ");
INSERT INTO glwl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Uusna dǝghwa Helenaha. Yavva ma larda Finikiya ma haiya Suriya. Kaa ghalla Yesu kǝ iin maa lagwda kǝ shatanahǝn ma vǝgha dǝghwaana. ");
INSERT INTO glwl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Am Yesu taa kǝ iina, “Aazaruuzǝg zarh ndan tlǝtǝra, kalkalbi kǝsvant kaf vǝlǝvtǝr kǝ ghǝgyah biya.” ");
INSERT INTO glwl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ngwangug nǝ uusǝna amaa, “Aana, bandkwah, dadda tsaga dǝgita, abi, zǝgaan nǝ ghǝgyah kǝ kafi ɓalgal vaka zǝgaa kǝ zarǝh.” ");
INSERT INTO glwl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aiyam Yesu taa kǝ iina, “Mbakyarvad ngwuggi aghaa ngugga nǝngna, dǝg daas da hǝnyaha, ɗuugharɗuug shatanahiin kǝ dǝghwagha.” ");
INSERT INTO glwl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kaa gwiya daas kǝ iin da hǝnyaha, tlǝghara hǝnga tǝ piin kǝ dǝghwaana, ɗuugharsɗuug shatanaha. ");
INSERT INTO glwl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ɗuughars ba nǝ Yesu kǝ larda Taya, kaa ghuda dagal dǝ Sidon lakutti gwiya daas damma yiwahaiya Galili, ar dǝ ghaiya kǝs kǝlawa Dikapolis. ");
INSERT INTO glwl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Vaakwaha ar sardǝv nǝ uudah kǝ matangng kwa tagǝda dlah kǝ ghaiya. Kaa ghalgaan kǝ iitǝr maa tappǝna kǝ uudanǝn maa mbanna. ");
INSERT INTO glwl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ɗahant kǝ iin kǝ matangǝn damma dlǝmmbaava vakavaki maay ndwar biya, kaa fahardǝm kǝ iin kǝ zarha dǝvaan damma hyemyahaana, dlaɓa tǝfa kǝ ashavaiya, tapǝna kǝ aryahaana da ashavayiina. ");
INSERT INTO glwl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kaa vazza damma zhigǝl kǝ Yesu kaa ɗǝya shifǝg kǝ iin bad ndzǝɗa, amaa taa kǝ iina, “Iffata!” Iin taakiya, “Wurga!” ");
INSERT INTO glwl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tagaa ba nǝ iin kwaha, kaa wurǝg kǝ hyimiyahaana, dǝgiti hǝkyǝghani aryahaana plǝmpǝlga, kaa tagaan kǝ iin kǝ ghai ba marawwa. ");
INSERT INTO glwl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ɓǝlatǝraaɓǝlǝg nǝ Yesu kǝ maggi aa tagarar bi aanji war biya, bakǝvakwaha kaa kutgaan kǝ iitǝr kǝ dǝgiti dzǝghardzǝgǝn. ");
INSERT INTO glwl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kaa ɓa jappǝr kǝ uudah ba vaivaiya, am nǝ iitǝra, “Ɓagaaɓag kǝ dǝgit baɗǝm bakalkala! Baz lii matang ndza cinngacinng kǝ ǝlbǝga, lii hatstǝruu hyǝmiya ar tagaan kǝ ghaiya.” ");
INSERT INTO glwl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Makwahiin kǝ sarta, kaa gwiya faɗǝgǝtfaɗǝg kǝ uudah ba ɗyaka. Maay tsau nǝ dǝgzǝg vakatǝr biya, kaa ɗahgantɗahǝg nǝ Yesu kǝ mbǝrzahaan amaa taa kǝ iitǝra, ");
INSERT INTO glwl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ən ɓa zhuwadaala uudahaana, hǝnga hǝkǝrɗ wan kwan ar ba vakar bakwal dǝgzǝga. ");
INSERT INTO glwl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Akwama ɗiiyantǝrǝsɗiiga daas da hǝnnyaha dǝ waiya, ar da mbasda biya. Aɗaba kyalǝm saral vaka bǝtkya.” ");
INSERT INTO glwl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Am mbǝrzahaana, “Da tlǝvkǝna mǝr nǝ dǝga zǝg makwanǝn kǝ tǝghal kwada tlǝgaara kǝ uudahaani?” ");
INSERT INTO glwl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kaa ndavatǝrundavǝg kǝ Yesu taakiya, “Bruudi ngwen wa vakaruwi?” Aiyam nǝ iitǝra, “Uuɗifa.” ");
INSERT INTO glwl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kaa tagtǝrtag kǝ iin kǝ uudah aa cahwararacahwarǝg tǝ haiya. Kǝsant kǝ iin kǝ bruudiin uuɗifna, kaa tagar uus kǝ Daadamazhigǝla, lahnana, vǝltǝr kǝ mbǝrzahaan kiyava tagwar kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mǝng dlaɓ kilf mishish hǝɗiikǝn vakaatǝra. Faraa kǝ iin kǝ barka, amaa tagwamtǝrnatagw kǝ uudaha ");
INSERT INTO glwl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Zaruuzǝg nǝ uudaha, tlatǝrtlǝga, ar dzahant nǝ mbǝrzahaan kǝ tǝmgaan alghw uuɗifa. ");
INSERT INTO glwl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Lii zaruuzǝg ar mǝng damma alfu uufaɗa. Kaa ɗiitǝrǝs kǝ iin dagal kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Bat watsǝr kaa dǝgǝmdǝg kǝ iin damma pɛrrayu dǝ mbǝzahaan, ngal dagal kǝ iin damma larda Dalmanuta. ");
INSERT INTO glwl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kaa sagau kǝ Farisiyah sa ɓalagajau dǝ Yesu, Sarsaa fǝshgaana, kaa ghalgaan kǝ iitǝr maa martǝrda kǝ dǝga jappǝr kwada nǝg kǝ dǝga sǝrg saay ma ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kaa dǝya shifǝg kǝ iin bad ndzǝɗɗa, amaa, “Aujilbǝg kǝskuram uudaha zaman am gata dǝga sǝrgi? Ən tagkurtag kǝ jiira, maay watlǝrǝn kǝ dǝga sǝrǝgi da marvǝtǝr kǝ uudaha zamanǝn biya.” ");
INSERT INTO glwl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tǝhalakwaha kaa ɗuutǝrǝsɗuug kǝ iina, kaa daas kǝ iin damma perrayuwa, kaa dzǝva dagal kǝ iin dat ghyaba kwaha. ");
INSERT INTO glwl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Viyatǝraavig kǝsa bruudi kǝ mbǝrzaha Yesu, ba pal wa vakatǝr ma pɛrrayuwa. ");
INSERT INTO glwl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kaa ɓǝlaatǝraɓǝlǝg nǝ Yesu kǝ maggiya, amaa, “Famfǝg kǝ hyǝmmi dǝgiya, dlaɓa am fǝgaan kǝ taaɗ tǝ yista Farisiyaha ar dǝ dǝga Hirudus.” ");
INSERT INTO glwl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kaa tagkǝvaatag kǝ mbǝrzah ma taatakaatǝr taakiya, “Mbakyarvad kiyam maay dǝ bruudi ha waa taag nǝ iin ndǝkwahini?” ");
INSERT INTO glwl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nǝghaakaba nǝ iin kǝ dǝgiti ar taag nǝ iitǝra, kaa ndavtrundavǝg kǝ iina, “Aujibǝg am taakiya am maay dǝ bruudi? Mbats, gwastǝn nǝghamaaka biya? Dlaɓa sǝramaaka biya? Mbats dǝkdǝk ghǝraruwa? ");
INSERT INTO glwl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Am dǝ gyiyaha, am nǝghǝga biya? Am dǝ hyǝmmiyaha, am cinnga biya? Mbats dzamamna biya? ");
INSERT INTO glwl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ma sartakwa lahantǝru nai kǝ bruudi dlǝɓ kǝ uudah alfu dlǝɓna, alghw ngwen wa dzahamant nǝ uuram kǝ tǝmngaani?” Kaa ngugangug kǝ iitǝr taakiya, “Alghw kǝlawa tar buwa.” ");
INSERT INTO glwl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Bruudi uuɗifǝn kwa lahantǝru nai kǝ uudahna, maandala alghwah ngwen wa dzahamant nǝ uuram righarighan dǝ ghwadgahaanii?” Am nǝ iitǝr taa kǝ iina, “Alghw uuɗiffa.” ");
INSERT INTO glwl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Aiyam Yesu taa kǝ iitǝra, “Gwaastǝn nǝghamaaka bi kǝ ǝlbǝgar biya?” ");
INSERT INTO glwl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Daragha ba nǝ iitǝr damma Betsaida, kaa sǝvardasǝg nǝ uudan gulf kǝ Yesu, kaa ghalgaan kǝ iitǝr maa tapna kǝ gulfiina. ");
INSERT INTO glwl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Viyiit kǝ iin kǝ dǝva gulfǝna, taɗda kǝ iin dagal da gyilga kǝssa. Tǝfgharvaba nǝ iin kǝ ashavai kǝ uudanǝn magyiya, tapna kǝ iina. Ndavaru kǝ iin taakiya, “Agha nǝghǝganǝghǝg kǝ dǝgita?” ");
INSERT INTO glwl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Kaa dzǝgantdzǝg kǝ gulfǝn kǝ ghǝran damma zhigǝl, amaa, “ǝn nǝghǝganǝghǝg kǝ uudaha, ǝn nǝghtǝr band uufaha, ar gwayaiva.” ");
INSERT INTO glwl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kaa gwiya tapgaan kǝ Yesu kǝ gyiyaana. Ngal wurgǝtwurǝg nǝ gyi tǝvakaiya, mbana, kaa nǝghǝganǝghǝg kǝ dǝgit ba marauwa. ");
INSERT INTO glwl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kaa ɓǝlgarsɓǝlǝg Yesu daas da hǝnyaha, amaa taa kǝ iina, “Gwiya tǝbi kǝ zǝrkǝss biya.” ");
INSERT INTO glwl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu ard mbǝrzahaan daral damma zǝrkǝssah ma Kaisariya Filibi. Tǝghǝrdǝga kaa ndavtǝrundavǝg kǝ iin kǝ mbǝrzahaan taakiya, “Ən war nai ma tag nǝ uudahi?” ");
INSERT INTO glwl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kaa ngugangug kǝ iitǝr taakiya, “Kyallǝm ar taaki, agha Yuhwan dadda tsuufǝga, kyallǝm ar taakiya, agha Iliya tlayanga, kyallǝm dlaɓ ar taakiya, agha pal ma tlayangaha.” ");
INSERT INTO glwl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kaa ndavtǝruundavǝg kǝ iina, “Kuramǝm, ǝn warnai mam tlǝg nǝ uurami?” Ngwaangug nǝ Bitrus taakiya, “Kǝgh nǝ Kǝristi.” ");
INSERT INTO glwl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kaa ɓǝltǝra kǝ maggi kǝ mbǝrzahaan aa tagararbi aanji ndǝwar kǝ ǝlbǝg tǝghǝr kǝ iin biya. ");
INSERT INTO glwl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Makwanǝn kǝ sarta, kaa fǝgarzhafǝg kǝ Yesu tsagtǝr dǝgit tǝghǝr kǝ ɗuuli da hǝɓǝg Zǝra Uud kǝ dlaɗ shah-shaha. Ar da naabi nǝ maalah tǝghǝr kǝ dlamaa kǝlawa ard maalaha zhiila kǝssa uufah, ard lii tsaga adzahadzaha Muusa, da tsǝvaana, tǝhala hǝng hǝkǝrɗ da ciig dǝ shiifǝgga. ");
INSERT INTO glwl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Taggada bat ɓalaɓal kǝ kwanǝn kǝ ǝlɓǝga. Kaa ɗahanat nǝ Bitrus kǝ Yesu damma dlǝmmbaava, buuraraana. ");
INSERT INTO glwl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kaa gwivǝt kǝ yesu vazǝna kǝ mbǝrzahaana, ngal caa gyi kǝ iin tǝ Bitrus taakiya, “Yagh vakar, shatanahna! Dzamaghǝragha band uuda duniya, band dzamaghǝra Daadamazhigǝl biya.” ");
INSERT INTO glwl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tǝhalakwaha ɗahant kǝ iin kǝ uudah ar dǝ mbǝrzahaan ba hǝrz dǝ iina, amaa taa kǝ iitǝra, “Baɗǝm daddakwa naa gata kaiya, ɗuwant kǝghǝraana, kǝssant kǝ tlaɓa hǝrtǝgaan kaa gatǝkwagatǝgga. ");
INSERT INTO glwl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Baɗǝm daddakwa naa fa shifǝggaana, da tlǝkǝna biya. Dlaɓa baɗǝm daddakwa ɓǝlda shifǝggaan mbakyarvad kaiya, ar dǝ ǝlbǝga marawa, aafǝga ba dǝ fǝga. ");
INSERT INTO glwl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Au payɗaan akwama tlakkǝnatlǝg nǝ uudan kǝ dǝga duni ba ɗǝm ɓǝlda kǝ shifǝggaani? ");
INSERT INTO glwl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Dlaɓ au wada vǝlda nǝ uudan dlakulva shifǝggaani? ");
INSERT INTO glwl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Baɗǝm daddakwa cinnga zhirwara ard dǝ ǝlbǝgar ma kwanǝn kǝ zamana kwa maay jiir mavakai biya dlaɓa dǝ haipah ba ɗyaka, Zara Uud ndakwi da cinngaan kǝ zhǝruwan ma sartǝn da saggau nǝ iin ma ndangǝra Daddaana ǝmtaɗ dǝ zǝrɓǝlgah kwar caccuwanacaccuwana.” ");
INSERT INTO glwl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Amaa dlaɓ taa kǝ iitǝra, “Ən tagkurtag kǝ jiira, mǝng lii ar ghacǝga vaakwan ar maay da ǝmtsǝg biya, bamma nǝgharanǝghǝg kǝ sagauwa tlǝksǝra Daadamazhigǝl bad ndzǝɗɗa.” ");
INSERT INTO glwl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tǝhala hǝngah ǝngkwaha kaa kǝsgankǝsǝg Yesu kǝ Bitrus, ard Yakuba, ard Yuhwana, kaa langtǝrdǝt kǝ iin dagat damma aghwa ba kyakkwa, ar ndzan ba davaatǝra vaakwahiina. Kaa gwivǝtgwiig kǝ ndzǝganaan tǝvuukwatǝra, ");
INSERT INTO glwl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","sǝɗvaan ndza maɗǝkw batǝl ar mbiiga, maay dadda bara kadlangi bardabarǝg ndkwah ma duni biya. ");
INSERT INTO glwl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kaa tsǝgwatsug tlayang Iliya ard tlayang Musa vakaatǝr ar taaghai dǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Am Bitrus taa kǝ Yesu, “Dadda tsagadǝgita, maraw ndzǝganamiyam vaakwanǝna, kǝm tafgatafǝg kǝ tsakwamah hǝkǝrɗ, pal kǝskǝgha, pal kǝ tlayang Musa, pal dlaɓ kǝ tlayang Iliya.” ");
INSERT INTO glwl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Sǝrgabi kǝ dǝgiti da tag nǝ iin biya, aɗaba gǝdzarǝtgǝdzǝga ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kaa saay kǝ akumb hǝɗtǝrdu, kaa ba cinngalcinng kǝ kungy ma akumbiina, taakiya, “Kǝgh zǝrarra, kwan waig naiya. Cinngamarnuucinnga!” ");
INSERT INTO glwl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Maay ma taaɗatǝr biya, kaa ɓala gyi kǝ iitǝra nǝgharabi ndǝwar biya, ba Yesu kalti wa ǝmtaɗ dǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tǝghǝrdǝga saayatǝr maghwa, kaa ɓǝltǝr maggi kǝ Yesu aa tagararbi aanji ndǝwar kǝ dǝgiti aa nǝghǝga nǝ iitǝr biya, bamma ciyitciig Zǝra Uud ma gǝtlah ndanna. ");
INSERT INTO glwl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ar ɗuwars kǝ ǝlbǝgǝn bamma taatakaatǝra, kaa ndava zaraabahaatǝr kǝ iitǝr taaki auwa tlatlǝg nǝ Yesu dǝ “Ciig ma gǝtlah”. ");
INSERT INTO glwl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tǝhalakwaha kaa ndavǝgarundavǝg kǝ iitǝr taakiya, “Aujilbǝgci kǝ lii tsaga adzahadzaha Musa ar taaki ba tlayang Iliya wada fǝgharzha saay ba zǝngwa, tǝhalakwaha kaa Yaazhigǝli?” ");
INSERT INTO glwl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ngwangug Yesu taakiya, “Ba jiira tlayang Iliya wada fǝgarzha saaya ba zǝngwa mbakyarvad ɓadla dǝgitah baɗǝmma. Bakǝvakwaha vindavindan taakiya Zǝra Uuda da hǝɓgaan kǝ dlaɗ shah-shaha, dlaɓa ar da naa biya. Nii ǝnd kwah bi hii? ");
INSERT INTO glwl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Abi, sahisǝg nǝ Iliya, ɓagarraɓag nǝ uudah kǝ iin kǝ dǝgitah baɗǝm kwa naag nǝ ghǝratǝr baɗǝmma, band kwa vindavindan da dzǝgardzǝga.” ");
INSERT INTO glwl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Gwiyarghǝra ba nǝ Yesu ar dǝ mbǝrzah hǝkǝrɗǝn savak kyalma mbǝrzaha, kaa nǝghǝganǝghǝg kǝ iitǝr kǝ uudah baɗyak faɗǝga tǝghǝr kǝ iitǝr. Lii tsaga adzahadzaha Musa dlaɓa ar ɓalla agajau dǝ iitǝr. ");
INSERT INTO glwl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nǝgharaba nǝ iitǝr kǝ Yesu kaa ɓa jappǝr ba vaivai kǝ dlamaa kǝlaw baɗǝmma, kaa ǝmdǝra da tagar uus kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kaa ndavatruundavǝg nǝ Yesu kǝ mbǝrzahaana amaa, “Agajawaw wam ɓag nǝ uuram dǝ iitǝri?” ");
INSERT INTO glwl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kaa ngwangug kǝ uuda nǝ iin ma dlamaa kǝlaw, amaa, “Dadda tsaga dǝgita, wan zǝrar naa sǝkadǝv naiya, kwa ciɓǝg nǝ shatanaha dlaɓa tsǝgharvatsǝg kǝ taaghaiya. ");
INSERT INTO glwl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ba tuukw sarti tsǝgwaraa nǝ iina, tlavgaarǝttlavǝg da tǝ haaya. Faraa kǝ kubǝg ma ghaiya, baz kǝrɗa tlǝrɗa, ghularant kǝ vǝgh ba dzǝghǝgha. Ɗahanɗahǝg kǝ mbǝrzahagh da lagwana, pilatǝrvaapilga.” ");
INSERT INTO glwl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ngwatǝrangug nǝ Yesu amaa, “Kuram uudaha zamana, am maay dǝ fadghǝr biya, ǝn da zǝlma ǝmkyangar nai dǝ kurami? Dlaɓa ǝnda ɓǝshkur hǝr nai kwanahaanii? Ayakam kǝ zǝriin da vakara.” ");
INSERT INTO glwl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kaa sǝgardǝvsǝg kǝ iitǝr kǝ zǝriina, nǝgha ba nǝ shatanahǝn kǝ Yesu, bat watsǝra kaa tlǝvgaarǝttlǝvǝg kǝ iin kǝ zǝriin dat tǝ haaya, kaa tǝg kǝ vǝghaana, gudɓǝlɓǝlga, baz kubǝg sagal ma ghaiyaana. ");
INSERT INTO glwl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kaa ndavgarundavǝg Yesu kǝ daddaana, “Fǝgharzha hǝr nǝ dǝginǝn kǝ ɓagarɓagi?” Aiyam nǝ daddaana, “Fǝgharzha bamma zarhǝra. ");
INSERT INTO glwl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ɓalgaan damma kaara ar dǝ yuwa, kiyava tsǝgaana. Akwama mǝng nǝ dǝgiti agha ɓaggnanǝnga, zhukǝmndalazhug agha mǝlkǝmndu.” ");
INSERT INTO glwl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Aiyam nǝ Yesu taa kǝ iina, “Aujilbǝg agha ndava taakiya mbatak ǝn ɓagnaɓagi? Abi, makwar kǝ dǝgit ɓagaɓag vak dadda fadghǝra.” ");
INSERT INTO glwl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Caaricaari kaa dzǝgantdzǝg kǝ dadda zǝrǝn kǝ kungy amaa, “Fandghǝrǝtfǝga, mǝlwadmǝlǝg ǝn farna kǝ fadghǝra!” ");
INSERT INTO glwl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nǝghaba Yesu kǝ uudah ar ba sagau dǝ ǝmdǝrga, kaa cagaraacag kǝ iin kǝ gyi kǝ shatanahǝn amaa, “Kǝgh shatanahǝn tsǝgharǝva kǝ zǝrǝn matang makwai kǝ taaghaiya ard cinngacinnga, assagal ma vǝghaana, gwiya dǝbi dlaɓ damma vǝghaan biya.” ");
INSERT INTO glwl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kaa huulǝg kǝ shatanahna, kaa gajagaan kǝ iin kǝ zǝrǝn ba vaivaiya dlaɓa kaa dagalaana. Kaa hǝngahǝng kǝ zǝrǝn band daddakwa ǝmtsaǝmtsana, baz tagaan kǝ kyalm taaki, “Abi, ǝmtsaǝmtsǝga.” ");
INSERT INTO glwl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kaa hǝkynan nǝ Yesu kǝ dǝvaan ciyanta, ghacana. ");
INSERT INTO glwl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Dagha ba nǝ Yesu da hǝnyaha, kaa ndavgaruundavǝg kǝ mbǝrzahaan ma dlǝmmbaava, taakiya, “Aujilbǝg kǝskǝmnd pilekǝmndvaa lagwa shatanahiini?” ");
INSERT INTO glwl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Kaa ngwanguga kǝ Yesu, amaa, “Hulfa kwan kǝ shatanaha laguvda biya bamma dǝ dzǝgwazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kaa ciya dagal kǝ Yesu ar dǝ mbǝrzahaan vaakwaha, Kaa ghudadagal kǝ iitǝr ma huɗa Galili. Nahaabi Yesu sǝrvaaka vakavaki dǝ iitǝr biya, ");
INSERT INTO glwl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","aɗaba ndza tsaggtǝr dǝgit kǝ mbǝrzahaan taakiya, “Zǝra Uuda da vǝlvtǝr damma dǝv kǝ uudaha, da tsǝvana. Tǝhala hǝngah hǝkǝrɗa da ciiga.” ");
INSERT INTO glwl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nǝgharaakai kǝ dǝgiti tag nǝ iin biya, dlaɓa ar gǝdzǝg kǝ ndavgaana. ");
INSERT INTO glwl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Daragha ba nǝ iitǝr damma Kafarnahuma. Kaa daas kǝ Yesu da hǝnyaha kaa ndavtrundavǝg kǝ iin kǝ mbǝrzahaan amaa, “Agajawaw wamaa ɓag nǝ uuram tǝ ghǝrdǝgi?” ");
INSERT INTO glwl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mbǝɗar bi kǝ ghaiyatǝr biya, aɗaba ɓalarɓalǝg kǝ agajaw tǝghǝrdǝg taaki war maal mataatakaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kaa cuhwurgacuhurg kǝ Yesu, ɗahant kǝ kǝlawa tar bu na, amaa taa kǝ iitǝra, “Baɗǝm wanaa nǝg kǝ dǝga zungwa, barari nal kǝ dǝga haal baɗǝmma, naal dlaɓ kǝ kwatnaha uudah baɗǝmma.” ");
INSERT INTO glwl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sǝddan kǝ zǝrzǝra, ghacna ma taatakaatǝra. Hǝkyna hǝɓǝk tǝvǝgh kǝ vǝghaana, amaa taa kǝ iitǝra, ");
INSERT INTO glwl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Baɗǝm daddakwa dlǝghǝga zǝrzǝr ǝndkwan mbakyarvad ɗaagara, dlǝghakwidlǝghǝg kǝskaiya. Dadda kwaa dlǝghkwi kai dlaɓa, kaibi wa dlǝghkwi nǝ iin biya, aa dlǝghǝga daddakwa ɓǝlakwadi kaiya.” ");
INSERT INTO glwl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Am Yuhwan taa kǝ iina, “Dadda tsaga dǝgita, mǝng nǝ uud kǝmnda nǝghǝgga nǝmnd lagwa shatanah ma ɗaagaha, kǝm tsarvana, aɗaba maay ma kǝmyam biya.” ");
INSERT INTO glwl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aiyam Yesu taa kǝ iitǝra, “Tsamarǝv biya, maay wa ɓa dǝga jappǝr ma ɗaagar tǝhalakwaha kaa taa ǝlbǝg ghwaɗ tǝ kai biya. ");
INSERT INTO glwl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Baɗǝm wa maay ɓa tlǝghum dǝ kǝmyam biya, ǝmtaɗ dǝ miyama. ");
INSERT INTO glwl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ən tagkurtag kǝ jiira, baɗǝm waa vǝlkur yuwa hǝɓɓǝg, aanji ba kwu palla aɗaba am dǝga Kǝristi, ǝn tagkurtag kǝ jiira, da pilwabi nǝ dǝgshigaan biya.” ");
INSERT INTO glwl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Baɗǝm daddakwa fǝgaraa pal ma zǝrzarhahaan fadghǝraatǝr tǝ kaiyǝn kǝ ɓa haipa, da nǝg kǝ dǝga zhuwadaala. Da ngulǝm nguɗvardǝm nǝ akura vaar ma kungy, ɓǝldǝm damma dǝlva. ");
INSERT INTO glwl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Akwama fǝkaa ɓa haip nǝ dǝvagha, agha ghuddana. Ngulǝm agha tlǝkkǝna kǝ shifǝgga damma zǝrazǝr dǝ dǝv palla, tǝghǝr kǝ damma kaar fai dǝ dǝvahagh bǝkurɗa, vakavakǝn da tsǝvabi nǝ kaarǝn biya.  ");
INSERT INTO glwl_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kwaɗyahanǝn kwar zǝtǝrzǝg vaakwahiina, ar maay ǝmtsǝg biya, dlaɓa tsǝva bi nǝ kaariin biya. ");
INSERT INTO glwl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Akwama shǝgahagha wa fǝkaa kǝ ɓa haipa, agha ghuddana. Ngulǝm agha tlǝkǝna shifǝga tangw damma zǝrazǝr dǝ shǝg pal, tǝghǝr kǝ damma kaara fai dǝ shǝgahagh bǝrkuɗa.  ");
INSERT INTO glwl_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kwaɗyahanǝn kwa zǝtǝrzǝg vaakwahiina, ar maay ǝmtsǝg biya, kaarǝn dlaɓ tsǝva biya. ");
INSERT INTO glwl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Akwama fǝkaa ɓa haip gyiyagha, ngulǝm agha tǝddana. Ngulǝm agha tlǝkǝna kǝ tlǝkǝsǝra Daadamazhigǝl dǝ gyi pal tǝghǝr kǝ damma kaara fai dǝ gyiyahagh ba bǝrkuɗa ");
INSERT INTO glwl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","vaakwahiina, ‘Kwaɗyahaan zǝtǝrzǝgna, ar maay ǝmtsǝg biya, Kaariin dlaɓa tsǝva biya.’ ");
INSERT INTO glwl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Da fǝshav aanji kwar kǝ uuda dǝ kaara, bandkwa fǝshav nǝ kyullǝg dǝ iizhamalaha. ");
INSERT INTO glwl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Iizhamalaha dǝgit marraw nǝ iina, akwma tagwazhatagw nǝ iizh dǝ yamyamana, am da gwida ndari? Aandz mǝng nǝ iizh ma kuram, am ndzan ma gabǝrǝr dǝ zaraabahaaruwa.” ");
INSERT INTO glwl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kaa ɗuwa vakavak kǝ iin kǝ Yesu, kaa ciya dagal damma larda Yahudiya, kaa dzǝva kǝ iitǝr dat ghyaba zaagha Jodan. Uudah baɗyaka dlaɓ gwiya dzaharvǝtdzahǝg vakaana, kaa gwiya tsagtǝrtsag bandkwa nǝt nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kyalma Farisah sarǝvsǝg sa fǝshgaana, kaa ndavgarundavǝg kǝ iitǝr taakiya, “Ma adzahadzaha Muusa, kalkalaan kǝ uudan lagwars kǝ uusaana?” ");
INSERT INTO glwl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Kaa ngutǝrangug Yesu amaa, “Auwa tagakur na adzahadzaha Muus ɗaa?” ");
INSERT INTO glwl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ngwarangugga aiyam nǝ iitǝra, “Haighanthaig nǝ Muus taakiya agha vinndara kǝ kakkaɗa tagwavǝgh dǝ uusagha, dlaɓa agha lagwarsa.” ");
INSERT INTO glwl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Am Yesu taa kǝ iitǝra “Vindakura mbakyarvad dǝkdǝka ghǝraru nǝ Muus kwanǝn kǝ adzahadzaha. ");
INSERT INTO glwl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bamma da zǝngwa, ndǝraandǝrg ‘Daadamazhigǝl kǝ uudaha ghwalva ar da uusa.’ ");
INSERT INTO glwl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mbakyarvad kwaha, ɗuugaan uud kǝ daddaan ar dǝ babbaan ǝmtsǝvǝt tǝ uusaana. ");
INSERT INTO glwl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ba bǝrkuɗ ar nal kǝ vǝgh palla. Tangw da tǝvuukwa ard ndzǝga band uud palla, maadlai uud bu biya. ");
INSERT INTO glwl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Aɗabad kwaha, dǝgiti aa matlǝgant Daadamazhigǝla, aa tagw bi nǝ uudan biya.” ");
INSERT INTO glwl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Gwiyara ba nǝ iitǝr da hǝnyaha, kaa ndavgarundavǝg nǝ mbǝrzahaan kǝ Yesu tǝghǝr kwanǝn kǝ ǝlbǝga. ");
INSERT INTO glwl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Aiyamaa taa kǝ iitǝra, “Baɗǝm nǝ uudi lagwda uusaana, gak kwatlǝrǝn kǝ uusa, ɓagagharaɓag kǝ haipa gwaragwar kǝ uusa zǝngwa. ");
INSERT INTO glwl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Akwama uus dlaɓ wa ɗuugars zhiilan kǝsuu kwatlǝrǝn kǝ zhiila, ɓagaaɓag kǝ haipa gwaragwara.” ");
INSERT INTO glwl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kaa ba langarlang kǝ uudah kǝ zǝr zarh kǝ Yesu kiyava fǝtǝra barka, kaa burǝgaraaburǝg nǝ mbǝrzahaan kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nǝgha ba Yesu, kaa badzǝg nǝ rǝviɗmahuuɗa, amaa taa kǝ iitǝra, “Aɗuwamtǝrɗuug kǝ zarǝh da vakara, tsamtǝrǝv biya. Aɗaba tlǝkǝsǝra Daadamazhigǝla dǝga jǝbba iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ən tagkurtag kǝ jiira, baɗǝm daddakwa dlǝghabi kǝ tlǝkǝsǝra Daadamazhigǝl band kwa dlǝghǝg zǝrzǝr biya, dǝgaabi damma vakai biya.” ");
INSERT INTO glwl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sǝtǝrdaa kǝ zarhiin da vakaan hǝkytǝrna ba hǝɓǝkka, fahtǝraa kǝ dǝva, dlaɓa fǝtǝraa kǝ barka. ");
INSERT INTO glwl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tǝghǝrdǝga ciyadagal Yesu vaakwahiina, kaa sagau kǝ uuda nǝ iin dǝ ǝmndǝrga, kǝlla kǝ iin kǝ ghwunj tǝvuukwana, kaa ndavarundavǝg kǝ iin taakiya, “Dadda tsagaa dǝgita jiijiira, awan da ɓag nai ǝn tlǝkkǝna kǝ shifǝga tangw damma zǝrazǝri?” ");
INSERT INTO glwl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Aiyam Yesu taa kǝ iina, “Aujilbǝg kǝskǝgh ɗa kai dadda jiiri? Au mǝng dadda jiira, ba Daadamazhigǝl palla. ");
INSERT INTO glwl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Abi agha sǝrgasǝrǝg kǝ dǝgiti taag na adzahadzaha, ‘Tsǝbi kǝ shiffǝg biya. Ɓagbi kǝ gwaragwar biya. Ɓagbi kǝ gǝl biya. Ɓagbi kǝ shiida fiid biya. Ɓagbi kǝ mbaɗiira biya. Agha faara kǝ daadagha ar dǝ baabagha.’ ” ");
INSERT INTO glwl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Am daala zǝrna, “Dadda tsaga dǝgita, abi tsufananttsuufǝg kwanahaan ciigǝt bamma zarhǝra.” ");
INSERT INTO glwl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Kaa vazǝgaan kǝ Yesu dǝ vazǝga wayakǝvǝra, amaa taa kǝ iina, “Ba dǝgit pal wa tǝmkaana. Dǝg valǝtvǝlǝg kǝ dǝgiti agha dǝ vakai nǝng baɗǝm, agha vǝltǝr kǝ talagaha, agha tlǝkkǝna kǝ hyah ba ɗyak ma ghǝrazhigǝla. Tǝhalakwha agha sagau da gatkwagtǝga.” ");
INSERT INTO glwl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Bad cinngacinngaan wah kǝ ǝlbǝgna kaa badza huɗvǝg kǝ iina, kaa gwiya daas kǝ iin ma badzǝga ǝrviɗmahuɗa, aɗaba dadda hyah nǝ iin ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kaa vaztǝrvazǝg Yesu kǝ mbǝrzahaan, amaa taa kǝ iitǝra, “Da dǝga ba dlah yaa dadda hyah damma tlǝksǝrra Daddamazhigǝla!” ");
INSERT INTO glwl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kaa ɓa jappǝra kwanǝn kǝ ǝlbǝg kǝ mbǝrzahaana. Kaa gwiya tagǝtǝrtag kǝ Yesu, “Kuram zarhara, da dǝgaa ba dlah, nǝ uud damma tlǝksǝra Daadamazhigǝla! ");
INSERT INTO glwl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Da tsaftsaf ba kǝ adlǝgwam dagal tǝ ɗuula liipǝr, tǝghǝr kǝ dadda hyah daadamma tlǝksǝrra Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Cinngara ba nǝ mbǝrzahaan ǝndkwaha, kaa gwiya fǝgarna ɓa jappǝr kǝ iitǝr ar ndava ghǝrahaatǝr taakiya, “Mabba ndǝkwaha, warwa da tlǝkǝna katǝgi?” ");
INSERT INTO glwl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kaa vaztǝraavazǝg kǝ Yesu amaa, “Vak kǝ uudaha, mbǝlembǝlena. Vak Daadamazhigǝla mbǝle biya. Aɗaba makwar kǝ dǝgit ɓagaɓag vak Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Aiyam nǝ Bitrus taa kǝ iina, “Ɗuwamndarsɗuug nǝmnd kǝ dǝgahaamnd baɗǝm kiyava gata kǝgha.” ");
INSERT INTO glwl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Aiyam nǝ Yesu, “Ən tagkurtag kǝ jiira, daddakwa ɗuugars vǝgyaana, bi zǝrha babbaana, bi dǝghwaha babbaana, bi babbaana, bi daddaana, bi zarhaana, bi guhahaana mbakyarvad kaiya ard ǝlbǝg marawa, ");
INSERT INTO glwl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","dǝgiti da tlǝkǝna nǝ iin ma kwanǝn kǝ zamana, da jǝguujig shǝg dǝrmǝkka, tǝghǝr kǝ tlǝkna hǝnyaha, ard zarha baabaha, ard ɗughwaha baabaha, ard yahha, ard zarha, ard guhaha, bakǝva kwaha da tlǝkǝna bamma dlaɗa. Tǝhalakwaha ma zamanǝn da sagauna, da tlǝkna kǝ shifǝgga damma zǝrazǝra. ");
INSERT INTO glwl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Baɗyak nǝ uudahi ar dǝga zǝngwa, ar da nǝg kǝ dǝga halla. Dǝga halla ar da nǝg kǝ dǝga zǝngwa.” ");
INSERT INTO glwl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ar tǝghǝrdǝga dagat damma Urshalima, Yesu tǝvuukwa mbǝrzahaan ar gatǝg tǝ halla ar ɓaa jappǝra. Uudahi gattǝr tǝ hal dlaɓa ar gǝdzǝga. Kaa ɗahtǝrǝtɗahǝg nǝ Yesu kǝ kǝlawa tar buna damma dlǝmmbaava, kaa gwiya tagǝtǝrtag kǝ iin kǝ dǝgiti da dzǝgaar dǝ iina. Amaa, ");
INSERT INTO glwl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Kiyam dagat damma Urshalima. Da vǝlvtǝrvǝlǝg nǝ Zǝra Uuda damma dǝv kǝ maalah ma zhiilakǝsuufah ar dǝ lii tsaga adzahadzaha Musa. Ard ghwudarda kǝ shariya ǝmtsǝga, ard vǝltǝr kǝ lii ar Yahudah biya. ");
INSERT INTO glwl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ar da nenegaana, ard tafarva kǝ ashavaiya, ar da kalaakan dǝ kiiɓa, ar da tsana. Tǝhala hǝnga hǝkǝrɗa da ciyit dǝ shifǝgga.” ");
INSERT INTO glwl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tǝhala kwaha, kaa sagau kǝ zarha Zabadi, Yakubu ard Yuhwana, davak kǝ Yesu, am nǝ iitǝr taa kǝ iina, “Dadda tsaga dǝgita, kǝm naa ghala dǝgit vakagha.” ");
INSERT INTO glwl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Aiyama taa kǝ iitǝra, “Au wam naag nǝ uuram ǝn ɓagkurani?” ");
INSERT INTO glwl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Aiyam nǝ iitǝra, “Kǝm ghala kǝgha mada dǝghaghan damma ndangǝra kwargagha, pallamnd maa ndzan tǝ dǝvaa kaffagha, pal tǝ dǝvaa ghyaɓɓagha.” ");
INSERT INTO glwl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Am Yesu taa kǝ iitǝra, “Am sǝrgai kǝ dǝgiti am ghalǝg nǝ uuram biya. Am hǝɓɓǝgahǝɓǝg kǝ dlaɗǝn ǝn da hǝɓǝg naina? Nii am dzugwantdzug ɓagkura nǝ uud kǝ hulfa tsuufǝgi da bagǝwa nǝ uuda?” ");
INSERT INTO glwl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ngwaraangug taakiya, “Aana, kǝm dzugwantdzugwa.” Am nǝ Yesu taa kǝ iitǝra, “Aana, am da hǝɓɓǝgahǝɓǝg kǝ dlaɗi ǝn da hǝɓǝg naiya, da ɓagkura dlaɓ nǝ uud kǝ tsuufǝg dǝ hulfa tsuufǝgi da ɓaggwa nǝ uuda. ");
INSERT INTO glwl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ndzǝgga tǝ dǝvaa kaffara, bi tǝ dǝvaa ghyaɓara, tlǝrar bi nǝ wah biya. Dǝgaha lii ɓadlavǝtǝrna mbakyarvad iitǝr nǝ wah kǝ vakavaka.” ");
INSERT INTO glwl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Cinngaraba nǝ kyalma mbǝrzah kǝlawǝn kwana, kaa badza ǝrviɗmahuɗ kǝ iitǝr dǝ Yakub ard Yuhwana. ");
INSERT INTO glwl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kaa ɗahtǝrǝtɗahǝg kǝ Yesu da vak palla amaa taa kǝ iitǝr, “Am sǝrgasǝrǝg ma lii Yahudah biya, lii sǝrǝvtǝrsǝrg dǝ kwarga, ar martǝr ndzǝɗ kǝ uudahaatǝra, uudah maamaalatǝr ndakwani ar martǝr ndzǝɗ kǝ uudahaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Da maay ǝndkwah ma taatakaru biya. Mbakyarvad kwaha, baɗǝm daddakwa naa nǝg kǝ maal ma kurama, barari ɓagarnǝs kǝ kwatnahǝr kǝ kyalǝma. ");
INSERT INTO glwl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Dlaɓa baɗǝm daddakwa naanǝg kǝ maal ma kurama, barari naal ɛɛva uudah baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aɗaba Zǝra Uuda sahi mbakyarvad ɓagvarnǝs kwatnahǝr biya, sahi da ɓa kwatnah nǝ iina, dlaɓa vǝlda kǝ shiffǝgaan kiyava varra uudah baɗyaka.” ");
INSERT INTO glwl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Daragha ba nǝ iitǝr damma Yariko. Ba iin ndakwani saggal ma Yariko dǝ mbǝrzahaana, ǝmtaɗ dǝ uudah baɗyaka, ndza mǝng nǝ uuda nǝ iin gulf cǝhurgan ma ghyaba ɗuul ghalga. Ɗaagaan Bartmawus, zǝra Timawus. ");
INSERT INTO glwl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Cinngha ba nǝ iin taakiya Yesu zhiil Nazaret wa ghuda dagala, dzǝgant kǝ iin kǝ kungy taakiya, “Yesu, zǝra Dauda, zhukwadaalazhuga!” ");
INSERT INTO glwl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kaa burǝgaraaburǝg kǝ uudah baɗyak, ar taakiya “Ndzandzǝga,” bakǝva kwaha gwiya dzǝgant kǝ iin kǝ ghai baɗyaɗyaka amaa, “Zǝra Dauda, zhukwadaalazhuga!” ");
INSERT INTO glwl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kaa ghacgaghacǝg kǝ Yesu amaa, “Ɗahamwantɗahǝga.” Ar ɗahant kǝ iitǝr kǝ gulfna, am nǝ iitǝr taa kǝ iina, “Ciiga, dlaiga wa ɗaa kǝgh nǝ Yesu.” ");
INSERT INTO glwl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bǝlda kǝ nuurana, bǝrhwaat kaa ciig kǝ iin davak kǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kaa ndavǝgarundavǝg kǝ Yesu taakiya, “Au wagha naag nǝng ǝn ɓagkani?” Am gulfǝn taa kǝ iina, “Dadda tsaga dǝgita, manaa naa nǝghaganǝghǝgga.” ");
INSERT INTO glwl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Aiyam Yesu taa kǝ iina, “Dǝga, fadghǝragha mbakambǝga.” Caaricaari kaa nǝghǝganǝghǝg kǝ iina, kaa gata Yesu kǝ iin dagal tǝ ɗuula. ");
INSERT INTO glwl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hǝrzarǝt ba nǝ iitǝr daadamma Wursalima, kaa ghacǝgagacǝg kǝ iitǝr ma Betafaji ard Betani, vaka Gaval kwa dǝ Uufaha Zaituna, kaa ɓǝlgantɓǝlǝg nǝ Yesu kǝ mbǝrzahaan buwa, ");
INSERT INTO glwl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Amaa taa kǝ iitǝra, “Damdǝg damma gǝdzǝrkǝsǝn tǝvuukwaruna. Baɗ daasaruwa am da nǝghǝganǝghǝg kǝ gǝlaaɓa aghyungngw nguɗanguɗana, kwa tapavǝnai ɗalgaan biya. Pǝlamdaapǝlga ");
INSERT INTO glwl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Akwama ndavakurundavǝg nǝ uud taakiya, ‘Aujilbǝg kǝskuram pǝlgaani?’ ‘Am tagar taakiya, Yaazhigǝl wa naagaana, da gwiigaan saas bandakwan ndakwana.’ ” ");
INSERT INTO glwl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kaa dagal kǝ iitǝra, ar nǝgha kǝ gǝlaaɓa aghyungngw nguɗǝga tǝ ghaiya hǝnnyaha tǝ ɗuula. Ar tǝghǝrdǝga pǝlgaana, ");
INSERT INTO glwl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","am lii ghacǝga vaakwahiin taa kǝ iitǝra, “Am pǝllǝg damǝr kǝ aghyungwini?” ");
INSERT INTO glwl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kaa ngwangug kǝ mbǝrzahaan buna bakalkal bandkwa tagatǝr Yesu, kaa ɗuutǝrǝsɗuug kǝ uudahiin dagal dǝ aghyungngwiina. ");
INSERT INTO glwl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sarardǝv ba nǝ iitǝr kǝ aghyungngwǝn kǝ Yesu, ar ɓalǝt kǝ sǝɗavahaatǝr tǝ vakaiya, kaa ɗalgaan kǝ Yesu cǝhura tǝ vakaiya. ");
INSERT INTO glwl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kaa ɓalgaɓalǝg kǝ uudah kǝ sǝɗavahaatǝr baɗyak tǝ ɗuula, kyalǝmah dlaɓa ɓalara dǝva uufahi ghwadarda nǝ iitǝr saama guhaha. ");
INSERT INTO glwl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Lii tǝvuukwana ard lii tǝ halaana ar ɗiyaru kǝ cau taakiya, “Galyamgalǝg kǝ Daadamazhigǝla! Bark kǝ daddakwa saay ma ɗaaga Yaazhigǝla! ");
INSERT INTO glwl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bark kǝ tlǝkǝsǝrǝn da saayǝn kwa dǝga daadamnd Dauda. Galyamgalǝg kǝ Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Dagha ba nǝ Yesu damma Wurshalima, kaa daas kǝ iin damma gaagazaiya vǝgya Daadamazhigǝl vazǝna kǝ dǝgitah badǝmma, ɓǝlaaɓǝlǝg tsau ba hwaasa, kaa gwiyaghǝra daas ǝmtaɗ dǝ mbǝrzahaam damma Betani. ");
INSERT INTO glwl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ciyarǝt ba nǝ iitǝr ma Betani dlakaduraana, kaa njǝkǝnjiig nǝ wai kǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nǝgha ba nǝ iin kǝ uufa ghǝgyiv kwad hyimiya, kaa da vazgaan mbatak tlǝkǝnatlǝg kǝ zǝr tǝ vakaiya. Dagha ba nǝ iin da tǝvǝgha, tlakǝnabi aanji ndau tǝ vakai biya, ba hyimiya, aɗaba sarta yaa zǝra ghǝgyiv biya. ");
INSERT INTO glwl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Amaa taa kǝ uuffa ghǝgyivǝna, “Ba ɗǝmma aa gwiya zǝbbi nǝ uud kǝ zǝr tǝ kǝgh biya!” Cinngaracinng mbǝrzahaan kǝ dǝgiti tagada nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Dagha ba nǝ Yesu damma wurshalima, kaa daas kǝ iin damma gaagazaiya Vǝgya Daadamazhigǝla farzha kǝ lagwa lii sagwa dǝgitah ard lii vǝlgaana. Kaa tlagars dlaɓ baz tebǝraha lii mbǝɗa kwaɓa baz avǝdaha lii valla takalamasara. ");
INSERT INTO glwl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tsarva kǝ uudah kǝ ghwadadagal dǝ dǝgitah ma gaagazaiya Vǝgya Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kaa ba tsagtǝrtsag kǝ iin kǝ uudah amaa, “Vindavavindǝg taakiya, “ ‘Da ɗahav nǝ vǝgyar dǝ Vǝgya dzǝgwazhigǝla dlamakǝlaaw baɗǝmma.’ Namdalnǝg nǝ uuram kwan kǝ ‘vakka shǝɓɓa gǝlaha.’ ” ");
INSERT INTO glwl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Cinngaraba nǝ maalah ma zhiilakǝsuufah ar dǝ lii tsaga adzahadzaha Muus kǝ kwanǝn kǝ ǝlbǝga, kaa fǝgarzhafǝg kǝ iitǝr kǝ gata ɗuula tsǝgaana, aɗaba ar gǝdzǝgaana, kwakyarvad baɗǝm dzahava dlamakǝlaawǝn ar ɓa jappǝra tsagaanana. ");
INSERT INTO glwl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ɓǝlaa ba hwaasa, kaa mǝlla dagal kǝ Yesu ard Mbǝzahaan ma kǝssiina. ");
INSERT INTO glwl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Dlakadur bawur ar ghudadagala, kaa nǝghǝganǝghǝg kǝ iitǝr kǝ ghǝgyivvǝn ghulalghulǝg tangw dat tlaliyaana. ");
INSERT INTO glwl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Dzamghanidzamǝg Bitrusa, amaa taa kǝ Yesu, “Dadda tsaga dǝgita, zharga! Ghǝgyivvǝn tlafgha nǝngǝn ghulalghulǝgga!” ");
INSERT INTO glwl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ngwatǝrangug nǝ Yesu amaa, “Famdǝghǝrǝtfǝg tǝ Daadamazhigǝla! ");
INSERT INTO glwl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Bak jiir wan tagkurtaga, akwama fǝdghǝrǝtfǝg nǝ uud tǝ Daadamazhigǝla, tagardatag kǝ aghwǝn taakiya ciig ɓǝldǝmɓǝlg kǝ ghǝragh ma yiwahaiya. Akwama ɓagaabi kǝ ndaundawur ma ǝrviɗmahuɗaan tǝghǝr kǝ dǝgiti aa tag nǝ iin biya, da ɓagvarɓaga. ");
INSERT INTO glwl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mbakyarvad kwaha wan tagkurtaga, baɗǝm nǝ dǝgiti am ghalǝg nǝ uuram ma dzǝgwazhigǝla, famdǝghǝrǝtfǝga taakiya tlamkǝnatlǝga, da nǝg kǝ dǝgaruwa. ");
INSERT INTO glwl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Dlaɓa makwar kǝ sarti am ciigǝt nǝ uuram da dzugwazhigǝla, akwama mǝng dadda kwamma hǝkyna nǝ uuram ma ǝrviɗya, am ɓǝsharnana, aɗaba ghǝrava Daadaruwi maghǝrazhigǝl ndakwani da ɓǝshkurna kǝ haipaharuwa.” ");
INSERT INTO glwl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Aiciya, akwamam maay ɓǝstǝrnaɓǝshǝg kǝ haipahaatǝr kǝ uudah biya, daadaruwi ma ghǝrazhigǝl ndakwani da maay ɓǝshkuranaaɓishǝg biya. ");
INSERT INTO glwl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kaa gwiya daas kǝ iitǝr damma Wurshalima. Kaa gwaiyav kǝ Yesu ma gaagazaiya vǝgya Daadamazhigǝla, kaa sagau kǝ lii maalah ma zhiilakǝsuufaha, ard lii tsaga adzahadzaha Muusa, ard maalah tǝghǝr kǝ vǝgya Daadamazhigǝla sa vakaana. ");
INSERT INTO glwl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Am nǝ iitǝr taa kǝ iina, “Agha ɓag dǝ kwar kǝ ndzǝɗ nǝng kwanahaan kǝ dǝgitahi? Warwa vǝlakak ndzǝɗa ɓaagaani?” ");
INSERT INTO glwl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Am Yesu taa kǝ iitǝra, “Mǝng nǝ ndavǝgi ǝn na ndavkuru naiya. Am nguwi ghǝravaruwa, kai ndakwi ǝnda tagkurtag ma hulfa kwar kǝ ndzǝɗ wan ɓag nai kǝ tlǝr dǝ vakaiya. ");
INSERT INTO glwl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tagamwataga, ndzǝɗǝn ɓagga Yuhwan kǝ tsufǝg dǝ vakaiyǝntsa, vǝlghar Daadamazhigǝl nii uudhi?” ");
INSERT INTO glwl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kaa fǝgarzhafǝg kǝ iitǝr kǝ agajaw ma taatakaatǝr, taakiya, “Akwama tagǝyamatag taaki, ‘Vak Daadamazhigǝla,’ da tagkiyamtag taakiya, ‘Aujilbǝg famdǝghǝrǝt bi tǝ iin biyi?’ ");
INSERT INTO glwl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kiyam tagatag taaki, ‘Vak kǝ uud kwana?’” (Ar gǝdza dǝgiti da ɓagtǝr nǝ uudaha, aɗaba baɗǝm nǝ uudah kǝsarantkǝsǝg taakiya tlayanga Daadamazhigǝl nǝ Yuhwana.) ");
INSERT INTO glwl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kaa ngugarangug kǝ iitǝr kǝ Yesu taakiya, “Kǝm sǝrga biya.” Aiyam Yesu taa kǝ iitǝra, “Kai ndakwi ǝn maay tagkurtag kǝ ndzǝɗi ǝn ɓag nai kǝ tlǝr dǝ vakai biya.” ");
INSERT INTO glwl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kaa zavuukw kǝ Yesu dǝ tagtǝr garava. Amaa, “Ndza mǝng nǝ uuda nǝ iin kwa ndza ɓagaa guuha inabiya, ngal tsarvaara kǝ iin dǝ hǝrgha takka, kwaɗa kǝ vakka pǝrtsa zǝraana, ndǝra kǝ iin kǝ gud kiyava dadda uufǝgaana. Vǝltǝr kǝ mbuucaan kǝ yaa dadda uusǝgga, kaa dagal kǝ iin damma kwatlǝrǝn kǝ larda. ");
INSERT INTO glwl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ɓaggaa ba sarta caa zǝra inabi, kaa ɓǝlgantɓǝlg kǝ dadda guhǝn kǝ kwatnahaan davak lii cauwara mbuca guhna, kiyava sǝgarda kyallǝma zarha inabi ma guha. ");
INSERT INTO glwl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kaa viigǝtviig kǝ lii cauwara mbuucǝna, ar kalaakan, ar lagwars dagal bad dǝvaan dlǝɓa. ");
INSERT INTO glwl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kaa gwiya ɓǝltǝrant kǝ kwatlǝrn kǝ kwatanaha. Kaa tsǝgaan kǝ iitǝr kǝ uudanǝn ma ghǝra, ar vǝlar kǝ dlaɗa. ");
INSERT INTO glwl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Gwiya ɓǝlant kwatlǝrǝna, ar tsan lii cauwara mbuuca guhna. Ɓǝltǝrant dlaɓ kǝ kyalǝm baɗyaka, kaa kalgakalǝg nǝ lii cauwara mbuuca guhǝn kǝ kyallǝma, ar ciɓa kǝ kyallǝmahaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Gwastǝn badlaɓ nǝ uud pall kwada ɓǝlǝg nǝ iina, iin nǝ zǝraana, kwa waig nǝ iina. Tǝhalakwaha kaa bǝlgaan kǝ iin da vakaatǝra, kaa tagaan kǝ iin taakiya, ‘Mbatak, ar da fǝgaarafǝg kǝ zǝrara.’ ");
INSERT INTO glwl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ar takkǝva lii cauwara mbuuca guhhǝn matatakatǝra, ‘Wanci nǝ dadda gwiya guhna, na tsiyamatsǝgga, kiyava nǝg guhiin kǝ dǝga miyama.’ ");
INSERT INTO glwl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kaa viigǝtviig kǝ iitǝra, ar tsana, ar ɗuuldan kǝ tluwa vǝghaan da gyǝlga ghǝrgha. ");
INSERT INTO glwl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Kaa ndavtǝrundavǝg kǝ Yesu, amaa, ‘Awa da ɓag nǝ dadda guhinii? Da sagau da cǝɓa kǝ lii cauwara mbuuca guhǝna, da vǝltǝr kǝ guhiin kǝ uudahitlǝrna. ");
INSERT INTO glwl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mbats tapamnabi kǝ karanta kwanǝn kǝ vindǝga ǝlbǝga Daadamazhigǝlǝn biya? Aɗaba vindavindan taakiya, “ ‘Akuri ɗuwarars yaa dadda ndǝrga, Iin wa naal kǝ akura ndǝrǝg kwa juujig kǝ marawa. ");
INSERT INTO glwl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kwanna tlǝra Yaazhigǝla, dlaɓa dǝga jappǝr vakamiyama.’ ” ");
INSERT INTO glwl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kaa gata ɗuula viigaan kǝ maalaha Yahudaha, mbakyarvad nǝgharaakanǝghǝg taakiya tag tǝghǝr kǝ iitǝr kǝ garavǝna. Aɗaba gǝdzar uudaha. Mbakyarvad kwaha ar ɗuwars, kaa dagal kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tǝhala zǝlam hǝɗiikǝna, ar ɓǝlant kǝ kyalǝma Farisiyah ard uudaha Hirudusa, kiyava ngarant dlǝgǝd kǝ Yesu ma ǝlbǝgahi da tag nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tsugwara ba nǝ-iitǝra, am nǝ iitǝr taa kǝ iina, “Dadda tsaga dǝgita, kǝm sǝrgasǝrǝg agha dadda jiira. Ba dǝgit pal nǝ uudah vakagha, aɗaba agha maay fa dagar ma uudah biya. Dlaɓa agha tsagaan kǝ ɗuula Daadamazhigǝl bak jiira. Magha tlǝg nǝng kalkalaan kǝskǝmnd ɗiigar hadam kǝ Kaisar tlǝkǝssa Ruma ɗyaka nii kalkalaan bihi? ");
INSERT INTO glwl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kǝm ɗiigaan nii, kǝm maay hii?” Nǝghaakanǝghǝg Yesu kǝ muniyaatǝra, amaa taa kǝ iitǝra, “Aujilbǝg kǝskuram fǝsha kaiyi? Anakam kwabiin ɗiyav hadamiin dǝ vakaiyǝn ndana.” ");
INSERT INTO glwl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kaa sǝgardaasǝg kǝ iitǝra, amaa taa kǝ iitǝr, “Garava war ard ɗaaga war wa tǝ vakaini?” Aiyam nǝ iitǝra, “Dǝga Kaisara.” ");
INSERT INTO glwl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Am Yesu taa kǝ iitǝra, “Dǝga Kaisar am vǝlar kǝ Kaisara. Dǝga Daadamazhigǝl dlaɓa am vǝlar kǝ Daadamazhigǝla.” Kaa ɓaa jappǝraan kǝ iitǝr ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sarǝvsǝg nǝ kyalǝma Sadukiyah sa vak kǝ Yesu. Iitǝr wa taakiya maay ciig ma gǝtlah biya. Kaa ndavgarundavǝg kǝ iitǝr taakiya, ");
INSERT INTO glwl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Dadda tsaga dǝgita, vindakǝmndavindǝg nǝ Muusa taakiya akwama ǝmtsaaǝmtsǝg nǝ uudan kwal yigga kǝ zǝr dǝ uusaana, barari kǝsgaan nǝ zǝraabaan kǝ uusiina, yahara kǝ zarah kǝ zǝraabaana. ");
INSERT INTO glwl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ndza mǝng zarhabaabah uuɗiffa, kǝsuukǝsǝg yag kǝ uus mtsan bakwal yigga kǝ zǝra. ");
INSERT INTO glwl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kaa kǝsguukǝsǝg kǝ zǝra bu kǝ uusiina, ghǝravaan ndakwi ǝmtsaa bakwal zǝra. Dǝga hǝkǝrɗ ndakwani band kwaha. ");
INSERT INTO glwl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bandkwah dlaɓa uuɗif ǝmtaɗaatǝra, ǝmtsahara bakwal zǝra. Tǝhalakwaha kaa ǝmtsǝg kǝ uusiina. ");
INSERT INTO glwl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Aitsa, da nǝg kǝ uusa warci pal ma iitǝr davala ciig magǝtlahi? Aɗaba uuɗifamtaɗatǝr kǝssarukǝsǝga.” ");
INSERT INTO glwl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ngwatǝrangug nǝ Yesu, amaa, “Dzamaghǝraru kalkal biya mbakyarvad am sǝrgabi kǝ Əlbǝga Daadamazhigǝl vindavindan biya, am sǝrgabi dlaɓ kǝ ndzǝɗa Daadamazhigǝl biya. ");
INSERT INTO glwl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Masartǝn da ciig lii ǝmtsaharaǝmtsahǝg tǝ faaya, ar da maay ghwalvah kǝssa uus biya, ǝnghwasah ndakwani ar maay da kǝssa zhiil biya, ar da nǝg band zǝrɓǝlgah kwa ma ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tǝghǝr kǝ ciig ma gǝtlaha, tapamnabi kǝ karantǝgaan ma kakaɗa Muus tǝghǝr kǝ kaar zǝg tǝ uuf ma suuy, taakiya, ‘Kai Daadamazhigǝla Ibrahima, ard dǝga Ishaku, ard dǝga Yakubu biya’? ");
INSERT INTO glwl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Iina, Daadamazhigǝla lii ruwaraaruug biya, dǝga lii dǝ shiffǝga. Tǝkamaatǝkǝg ba linglinga.” ");
INSERT INTO glwl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Pall ma lii tsaga adzahadzaha Muus tlatǝraatlǝg ar ɓalagajawa ma taatakaatǝra. Nǝghaaka ba nǝ iin taakiya ngwatǝrangug Yesu ba kalkala, kaa ndavǝgarundavǝg kǝ iin taakiya, “Kwar kǝ adzahadzah wa juujig ba vaivayi?” ");
INSERT INTO glwl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ngugharangug nǝ Yesu amaa, “Kwa juujig baɗǝmma iin taakiya, ‘Cinngamcinng, uudaha Israˈla, Yaazhigǝl Daadamazhigǝlamiyama, Yaazhigǝl ba palla. ");
INSERT INTO glwl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Waig kǝ Yaazhigǝl Daadamazhigǝlagh dǝ ǝrviɗmahuɗagh baɗǝmma, ard shifǝggagh baɗǝmma, ard dzamaghǝragh baɗǝmma, ard ndzǝɗagh baɗǝmma.’ ");
INSERT INTO glwl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Dǝga bu iin taakiya, ‘Waig kǝ tlǝghaarawakyaghagh band kwagha naag nǝng kǝ ghǝragh.’ Maay nǝ watlǝrn kǝ dzahadzahi juujig kǝ kwanahaan biya.” ");
INSERT INTO glwl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Aiyam dadda tsaga adzahadzahǝn taa kǝ Yesu, “Tagghǝdatag bakalkal dadda tsagadǝgita, Daadamazhigǝl ba palla, maay watlǝrn biya ba iina. ");
INSERT INTO glwl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Aa waiyavwaig bad rǝviɗmahuuɗ palla, ard dzamaghǝragh baɗɗǝmma, ard ndzǝɗagh baɗɗǝmma, agha waiyant kǝ tlǝghaarawakyaghagh band ghǝragha, juujig baɗǝm kǝ kyulǝgga ǝmcagga ard kyulǝgga hǝrga.” ");
INSERT INTO glwl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nǝgha ba nǝ Yesu kǝ ɗuuli ngwaa nǝ iin dǝ dabariya, aiyama taa kǝ iina, “Aghaba hɛɛf dǝ tlǝksa Daadamazhigǝla.” Tahalakwaha maadlai wa gwiya shughaana gyiya ndavgaru dǝgiti tlǝrn biya. ");
INSERT INTO glwl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ma sarta kwandza tsaga dǝgit nǝ Yesu ma vǝgya Daadamazhigǝla, kaa ndavtǝruundavǝg kǝ iin taakiya, “Ar tag ndar nǝ lii tsaga adzahadzah taakiya Kǝristi zǝra Daudi? ");
INSERT INTO glwl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","“Dauda kataghǝran ndakwi, tǝdvad Shǝɗɗǝkw Daadamazhigǝl tagaatag taakiya, “ ‘Am Yaazhigǝl taa kǝ Yaazhigǝlara, Ndzandzǝg tǝ dǝvaa kaffara, Bamma fantǝraafǝg kǝ tlǝghumahagh da mazhangyil kǝ shǝgahagha.’ ” ");
INSERT INTO glwl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Ba Dauda kataghǝran ndakwi ɗahaɗahǝg kǝ iin dǝ ‘Yaazhigǝla’. Da nǝg ndar kaci kǝ zǝr vak Daudi?” Cinngaraba nǝ uudah kǝ ǝlbǝgǝn taggada nǝ Yesuna, kaa dlaig kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ma tsagaanaana, am Yesu, “Famfǝg kǝ hǝnkal dǝ lii tsaga adzahadzaha Musa, ar naa ba gwaiyav ma sǝɗav ɗyakɗyaka. Dlaɓa ar naa ba tagvǝtǝr nǝ uuss ma kasukwa. ");
INSERT INTO glwl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ar naa ba vǝlǝvtǝr nǝ dǝga ndzǝganah ndang ma guda dzǝgwazhigǝla, ard dǝga ndzǝgaan maraw vakka hwaɗaga. ");
INSERT INTO glwl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Iitǝr nǝ lii za kadlanga ǝnghwasahi ǝmtsahara zalahaatǝra. Dlaɓa ar dzǝgwazhigǝl tlaɗɗa kiyava nǝghǝvtǝrnǝghǝgga. Da vǝlǝvtǝrvǝlǝg dlad ba vaivaiya.” ");
INSERT INTO glwl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Cǝhurga ma guda dzǝgwazhigǝla nǝ Yesu vaka cauwa ndzayau, vazza ɗuuli ar diig nǝ uudah kǝ kwaɓatǝr ma dǝga ɗǝya ndzayau. Kyalǝma yaa dadda hyahha baɗyaka ar ɗiigaan kǝ kwaɓ baɗyaka. ");
INSERT INTO glwl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kaa sagau kǝ wagiggiin talaga, ɗǝya kǝ kalami buwa, kwa dǝt bi nǝ pallǝraan dat kwaɓ biya. ");
INSERT INTO glwl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kaa ɗahgantɗahǝg nǝ Yesu kǝ mbǝrzahaana, amaa kǝ iitǝra, “Ba jiirjiira, wan tagkurtaga, kwabǝn aa ɗiiga nǝ wagigǝn ma dǝga ɗǝya ndzayauna, juujig kǝ dǝga kyalma uudah baɗǝma. ");
INSERT INTO glwl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Baɗǝmmaatǝr vǝlarda bamma ɗyakǝra dǝgiti ar dǝvakai nǝ iitǝra, wagyigna, ma ndzǝgana talagǝraana vǝladavǝlǝg kǝ dǝgiti dǝvakai nǝ iin baɗǝmma, baz dǝgiti tsaghǝr nǝ iin tǝ vakaiya.” ");
INSERT INTO glwl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tǝɗuula Sagal nǝ Yesu ma vǝgya Daadamazhigǝla, am pal ma mbǝrzahaan taa kǝ iina, “Dadda tsagga dǝgita, vazǝg kǝ maandala akurahaan ard ndǝrgahaana, dǝgaha jappǝra!” ");
INSERT INTO glwl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Am Yesu taa kǝ iina, “Agha nǝghǝganǝghǝg kǝ maandala hǝnyahahaana? Da dlagav baɗǝmma. Da maay ɗuwav nǝ akur aanji pal tǝghǝr kǝ zǝraabaan biya.” ");
INSERT INTO glwl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Cihurgan nǝ Yesu tǝ Aghwa Zaitun kwar vazakav magyimagyi dǝ Vǝgya Daadamazhigǝla, kaa ndavgarundavǝg kǝ Bitrusa, Yakuba, Yuhwana, ard Andrawus ba daghuvaatǝr taakiya, ");
INSERT INTO glwl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tagkǝmndtaga, da dzǝgaar hǝr wanahaan kǝ dǝgitahi? Au nǝ dǝga sǝrgi da nǝghǝvaaka nǝ iin tǝ vakai akwama hǝrz sarta dzǝgardzǝgaani?” ");
INSERT INTO glwl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Aiyam Yesu taa kǝ iitǝra, “Famfǝg kǝ hyǝmiya, aa valkurdai nǝ uudah biya. ");
INSERT INTO glwl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Uudah baɗyak ar da sagau ma ɗaagara, ar da taakiya, ‘Kai nǝ iina,’ ar da valtǝrda kǝ uudah baɗyaka. ");
INSERT INTO glwl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Akwama cinngamacinnga kǝ ǝlbǝga ghwaava ard dlaghalgaana, gǝdzam biya. Barari da dzǝgardzǝg wanahaana, bakǝvakwaha ghaalaan ndakwani sǝghǝv bi ndan biya. ");
INSERT INTO glwl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Uudaha kǝssi tlǝrna, ar da dǝgaradǝg kǝ uudaha kǝssi tlǝrǝn dǝ ghwaava, kwarga ar da ɓa ghwaav dǝ kwarga. Da gajagav nǝ haay vakavak shahshaha, da mǝng baz waiya. Baɗǝm wanahaana iin bi gyigyiya dlaɗiin biya. Ba fǝgarzhaana. ");
INSERT INTO glwl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Famfǝg kǝ hyimmi tǝ ghǝraharuwa, aɗaba da langkurlang nǝ uuda damma guda shariya, da kalkuraaka nǝ uud ma guda dzahava Yahudaha. Da langkurlang nǝ uud da tǝvuukwa tlǝvuukwaha ard tlǝkǝsaha mbakyarvad dǝ ɗaagara, am da tagǝda kǝ shiid maraw tǝghǝr kǝskai tǝvuukwatǝra. ");
INSERT INTO glwl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Lakuti sagau nǝ halavuwaana, barari tagǝvtǝra nǝ ǝlbǝg maraw kǝ uudaha duni baɗǝma. ");
INSERT INTO glwl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ba kǝlaa sarti viikurǝt nǝ uuda, akwama dakurdaadǝg da vaka ta shariya, ndavambi kǝ dǝgiti am da tag nǝ uuram biya. Ndzaa ba tagamtag kǝ dǝgi da vǝlkur nǝ Daadamazhigǝl ma kwahiin kǝ sarta, aɗaba kurambi wa taaghaiy biya, Shǝɗǝkwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Zǝraaba da vǝlda kǝ zǝraabaan da tsǝvana, daad dlaɓa da vǝlda kǝ zǝraana. Zarh dlaɓ ar da ciyarant kǝ yaatǝra kwa da fǝgara cǝɓǝvtǝra nǝ yaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Baɗǝm nǝ uudaha ar da naakur bi mbakyarvad ɗaagar biya, Baɗǝm nǝ daddakwa ghacaghacǝg dat ghalaana, da katavva.” ");
INSERT INTO glwl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Akwama nǝghamanaghǝg kǝ dǝgit dzah ma vǝgya Daadamazhigǝla, kwada fǝgara uudah kǝ ɗuwa vakavakina, (Aa nǝghaakanǝghǝg dadda karantǝgaan taakiya) lii ma larda Yahudiya aa ǝmdǝrarǝmdǝrǝg dagat damma aghwaha. ");
INSERT INTO glwl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kwa tǝ ghǝragud dlaɓa, aa sǝbbi saay samma hǝnyah da kǝssa dǝgit biya.” ");
INSERT INTO glwl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Dadda kwama guh dlaɓa, aa sǝbi saasa hǝnyah da kǝssa sǝɗavan biya. ");
INSERT INTO glwl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Dǝga zhuwadaal kǝ ǝnghwasahi ǝnhuɗa ard lii dǝ zǝr ma dlaaga ma kwanǝn kǝ sarta! ");
INSERT INTO glwl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dzǝgwamdzǝg kǝ zhigǝl aa dzaarbi wanahaan kǝ dǝgitah ma sarta viyakǝsa biya. ");
INSERT INTO glwl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ma kwahiin kǝ sarta, da hǝɓav dlaɗ ba vaivai kwa tapavǝnabi kǝ hǝɓgaan ciigǝt ma sarta kwa vǝrɗya nǝ Daadamazhigǝl kǝ duni biya, tangw damma kwanǝn kǝ sarta. Da maadlai gwiya dzǝgardzǝg hulfa kwan kǝ dlaɗ ba dǝm biya. ");
INSERT INTO glwl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Maa maay kwakyarvad gulghanigulǝg nǝ Yaazhigǝl kǝ hǝngahin biya, maa maay nǝ uuda dǝgshigi da ngǝdlǝg biya. Mbakyarvad uudahaan dzǝrghaaka nǝ iina, kaa gulǝnagulǝg kǝ iin kǝ hǝngaha. ");
INSERT INTO glwl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ma kwahin kǝ sarta baɗǝm daddakwa tagkur taakiya, ‘Vazǝga, wai nǝ Kǝristi vaakwana!’ bi, ‘Vazǝg, wai nǝ iin vaakwaha!’ Haiyamant biya. ");
INSERT INTO glwl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Aɗaba kǝristiya fiidfiida ard tlayangaha fiidfiida ar da sagala, ar da ɓa dǝga sǝrǝga ard dǝgaha jappǝrha, kiyava vala uudaha, akwama ɓagaɓaga, baz lii dzǝravtǝraakadzǝrga. ");
INSERT INTO glwl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mbakyarvad kwaha famfǝg kǝ hyǝmiya! Tagankuratag kǝ dǝgitah baɗǝm bamma sarta.” ");
INSERT INTO glwl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Aiciya, ma kwahiin kǝ sarta, tǝhala dlaɗǝn da sagauna, “ ‘Faci da ba niknikka. Kyil dlaɓa da maay ɓa parakrak biya. ");
INSERT INTO glwl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kwadladlah ar da ɓala saay ma ghǝrazhigǝla. Da gajagav nǝ dǝgitahi ɗyakɗyak tǝ zhigǝla.’ ");
INSERT INTO glwl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Tǝhala kwaha da nǝghǝvanǝghǝg Zǝra Uud saay ma akumba dǝ ndzǝɗa ard ndanggǝra. ");
INSERT INTO glwl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tǝhala kwaha da bǝldi kǝ zǝrɓǝlǝgahaan ar da dzahant kǝ lii dzǝrghaaka nǝ iin sagatsǝga, ard dagatdǝga, ard dagaldǝga ard saadǝsǝga, cigǝt tǝ ngyilla duniya dat ghaala zhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Tsagamtsag kǝ ndzǝgana uufa ghǝgiva. Akwama fǝgharzhafǝg nǝ dǝvahaan kǝ ɓa ndaɗa, dlaɓa farzha kǝ ɗa daala hyǝmiya, sǝramasǝrǝg taakiya hǝrz nǝ madara. ");
INSERT INTO glwl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bandkwah dlaɓ akwama nǝghamanǝghǝg kwanahaan kǝ dǝgitah dzǝgaardzǝga, sǝramasǝrǝg taakiya hǝrz sarta, ba hɛɛf dǝ ghaiya wakyagha. ");
INSERT INTO glwl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Bak jiijiira wan tagkurtaga, uudaha kwanǝn kǝ zamana ar da maay ǝmtsǝg biya, bamma dzǝghardzǝg wanahaan kǝ dǝgitah baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ghǝrazhigǝla ard haaya ar da ghyǝnga, ǝlbǝgara badǝmma da maay ghyǝng biya. ");
INSERT INTO glwl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Kwan kǝ faciya ard sarta Maay wa sǝrgasǝrǝg biya, aanji, zǝrɓǝlgahi ma ghǝrazhigǝla, aanji Zǝriina, bamma Daad palla. ");
INSERT INTO glwl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Famfǝg kǝ hyǝmiya, am ɓadlǝvǝghana, aɗaba am sǝrga bi kǝ faciya ard sarti da dzǝgaar wanǝn biya. ");
INSERT INTO glwl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Band uudi kwa tǝghǝrdǝga dagala, akwama ɗuugharsɗug kǝ hǝnyaha fǝtǝrdǝm ma dǝv kǝ ɛɛvahaana, ma kwaratǝr bad tlǝri da ɓag nǝ iina. Tǝhalakwaha tagar kǝ dadda uuffa hǝnyaha taakiya aa ɓadlǝvaɓadlǝgga. ");
INSERT INTO glwl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mbakyarvad kwaha, ndzamandzǝg ba ɓadlaɓadlana, aɗaba am sǝrgabi kǝ sarti da saas daddahǝnyah biya, ma da saa dǝghwaasa, ma mahuɗa vǝɗɗa, bi sarta wiiga ghwatǝkala, bi dlakadur ba wurra. ");
INSERT INTO glwl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Aa da tlǝkuraabi gahragw am hǝnahaar biya. ");
INSERT INTO glwl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Dǝginǝn ǝn tagkur naina, ǝn tagtǝr kǝ uudah baɗǝma, ‘Ndzamandzǝg ba ɓadlaɓadlana!’ ” ");
INSERT INTO glwl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tǝmmaa ba hǝng bu kǝ Hwaɗaga Haarakǝssa Dzava Hǝnyaha ard Hwaɗaga Haarakǝssa Bruudi Kwal Yista, kaa gata ɗuula viiya Yesu kǝ maalah ma zhiilakǝsuufah ard lii tsaga adzahadzaha Musa dǝ gǝlgǝla, kiyava tsǝgaan kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ar taakiya, “Aa ɓagavbi daghuvala hwaɗagga haarakǝs biya, aɗaba aa da ciyarantbi nǝ uudah kǝ uushav biya.” ");
INSERT INTO glwl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ma sartǝn ndza ma Bitani nǝ Yesu, za kaf ma vǝgya Siman kwa njikǝn vǝcca, kaa saas kǝ uussiin dǝ mǝrta wala tǝrshan reghareghaan kwa ba pir ganaan ɓagava dǝ nardi, cǝɓnan ɗiyarǝm kǝ iin ma ghǝra. ");
INSERT INTO glwl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kaa Badza ǝrviɗ kǝ uudahi ndzar vaakwahiina, am nǝ iitǝr ma taatakaatǝra, “Aa badzǝvda kiyavau wallǝn tǝrshin ǝndkwani? ");
INSERT INTO glwl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Akwmaa vǝlavǝt nǝ iina, maa tlavkǝnatlǝg nǝ kwaɓa bariyam kwa juujig kǝ dǝga viig palla, maa velvtǝr kwaɓiin kǝ talagaha!” Kaa caagyi kǝ iitǝr tǝghǝr kǝ uusiin ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Aiyam nǝ Yesu taa kǝ iitǝra, “Ɗuwamarsɗuugga. Am gargya kiyavauwi? Abi, dǝgit maraw waa ɓagwi nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ba kǝlaahǝnga am ba ǝmtaɗ dǝ talagaha. Mam naagaan am ɓagtǝraaɓag kǝ hɛrǝr aanji ba hǝra, aɗaba kaiya ǝn maay kǝlaahǝng ǝmtaɗ dǝ kuram biya. ");
INSERT INTO glwl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ɓagaaɓag kǝ kǝlaa ndzǝɗaana. Ɗaighwaaɗaig nǝ iin kǝ walla tǝrshǝn tǝ vǝghaar lakuti kǝ da hǝɗakai kǝ uuda. ");
INSERT INTO glwl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Bak jiirjiira wan tagkurtagga, baɗǝm vakavaki da tagav nǝ ǝlbǝg marawǝn ma duniya, da dzamav nǝ uussǝn kwakyarvad dǝgiti aɓaga nǝ iina.” ");
INSERT INTO glwl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tǝhalakwaha, kaa dagau kǝ Yahuda Iskariyoti pal ma mbǝrzah kǝlawa tar buna davak maalah ma zhiilakǝsuufah kiyava vǝltǝru Yesu. ");
INSERT INTO glwl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Cinngaraba nǝ iitǝr ǝndkwana, kaa dlaig kǝ iitǝr ba vaivaiya, dlaɓa ar tara kǝ langiya vǝlgar kwaɓa. Kaa fǝgarzhafǝg kǝ Yahud kǝ gata ɗuula vǝlgaana. ");
INSERT INTO glwl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Daavala faciya zunngwa hwaɗaga haarakǝssa bruudi kwal yista, kaa harra mbaklaka kǝ iitǝr bandkwa narǝt nǝ daadijahaatǝr kǝ ɓagaan kiyava hwaɗaga haarakǝssa dzava hǝnyaha, kaa ndavgarundavǝg nǝ mbǝrzahaan kǝ Yesu taakiya, “Vaakwar wa magha naag nǝng ma kǝmnda ɓadlǝkana kǝ vaki agha da zǝg nǝng kǝ haarakǝssa dzava hǝnyahi?” ");
INSERT INTO glwl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kaa ɓǝlgantɓǝlg kǝ iin kǝ mbǝrzahaan buwa, amaa taa kǝ iitǝra, “Damdǝg damma huɗakǝssa. Am da nǝghǝganǝghǝg kǝ uudan dǝ tǝfuwa yuwa. Gatamarsgatǝga. ");
INSERT INTO glwl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Aanji kwar kǝ hǝnyah wa dǝgaa nǝ iina, am tagar kǝ dadda hǝnyahiin taakiya, ‘Dadda tsaga dǝgit wa ndava taaki mǝr nǝ gudi ǝn da zǝg nai ard mbǝrzahar kǝ kaffa Hwaɗaga Haarakǝssa Dzavgaara Hǝnyahi?’ ");
INSERT INTO glwl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Da markurdamarǝg nǝ iin kǝ maandala gud tǝghǝr kǝ guda sharaw kwa ɓadlavǝna mbakyarvad haarakǝssiina. Am da ɓadlkiyamna vaakwah kǝ dǝgzǝga.” ");
INSERT INTO glwl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kaa dagal kǝ mbǝrzahaan damma huɗakǝssa, tlararatlǝg kǝ dǝgitah bandkwa tagatǝr Yesu. Kaa ɓadlǝna kǝ iitǝr kǝ dǝgzǝga Hwaɗagga Haarakǝssa Dzavgaara Hǝnyaha. ");
INSERT INTO glwl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bagaa ba hwaasa, kaa saas kǝ Yesu ard mbǝrzahaan kǝlawa tar buwa da hǝnyahiina. ");
INSERT INTO glwl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ar tǝghǝrdǝgga za kaffa, kaa am Yesuwa, “Bak jiirjiira wan tagkurtaga, pal makuram da vǝlkwavǝlga, kwa bandakwan za kaf ǝmtaɗ dǝ kaiya.” ");
INSERT INTO glwl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Cinngarubi nǝ mbǝrzahaan kǝ ǝmtakǝra ǝlbǝgǝn biya, kaa ba ndavǝg kǝ iitǝr ba da pallapalla, “Kai nii?” ");
INSERT INTO glwl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ngwatǝrangug nǝ Yesu amaa, “Pal ma kuram kǝlawa tar buwna, kwa kǝm zǝg nǝmnd kaf ma kuu palla. ");
INSERT INTO glwl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Da ǝmtsǝg nǝ Zǝra Uuda, bandkwa vindava tǝghǝr kǝ iina. Da dǝga zhuwadaal kǝ daddkwa da vǝlla Zǝra Uuda! Ngulǝm maa yaavabi vaani.” ");
INSERT INTO glwl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ar tǝghǝrdǝgga za kaffa, kaa kǝsǝgankǝsǝg nǝ Yesu kǝ bruudiya, tagar kǝ uus kǝ Daadamazhigǝla, lahǝnan vǝltǝr kǝ mbǝrzahaana, amaa, “Cauwamcauga, kwana iin nǝ vǝghara.” ");
INSERT INTO glwl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tǝhala kwan dlaɓa, kǝsant kǝ iin kǝ kuwa yuwa inabi, tagar kǝ uus kǝ Daadamazhigǝla, vǝltǝra. Kaa hǝɓguhǝɓǝg kǝ iitǝr baɗǝmmaatǝra. ");
INSERT INTO glwl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Aiyama taa kǝ iitǝra, “Kwana iin nǝ avǝzara. Avǝza rǝgha langiya. Kwa da ɗǝyav dagal mbakyarvad uudah baɗyaka. ");
INSERT INTO glwl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Bak jiijiir wan tagkurtaga, ǝn maadlai da hǝɓɓa yuwa inabi biya, bamma daghuvali ǝn da hǝɓɓǝg nai kwatlǝrǝn kǝ daalaan ma tlǝkǝssa Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ɓǝlaraa ba nǝ iitǝr kǝ ǝngsa, tǝhala kwaha kaa dagal kǝ iitǝr dat Gaval kwa dǝ Uufaha Zaituna. ");
INSERT INTO glwl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Am Yesu taa kǝ mbǝrzahaana, “Baɗǝmmaruw am da ǝmndǝrga am da ɗuukwaɗuuga, bandkwa vindava taakiya, ‘Ən da tsǝggaan kǝ dadda piigga, dlaɓa ar da tadagal nǝ tuughwaha.’ ");
INSERT INTO glwl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Tǝhala ciigar ma gǝtlaha, ǝn da dǝgaa nai zǝngw tǝghǝr kǝskuram damma Galili.” ");
INSERT INTO glwl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Aiyam Bitrus taa kǝ iina, “Aanji ar ǝmndǝra baɗǝm ar ɗuukǝssa, ǝn da ɗuukǝs bi nai biya.” ");
INSERT INTO glwl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Am nǝ Yesu taa kǝ Bitrus, “Bak jiirjiir wan tagaktaga, haniina, lakuti wiig kǝ ghwatǝkal shǝg bu ma huuda vǝɗɗa, aghada ɓaggaan kǝ agajawa sǝrkwabi shǝg hǝkǝrɗa.” ");
INSERT INTO glwl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kaa ba gwaigarsgwaig kǝ Bitrus ba vaivai taakiya, “Aanji da tsǝkwatsǝg nǝ uud ǝmtaɗ dǝ kǝgha, ǝn maay da ɓala gajawa sǝrak bi ba dǝm biya.” Baɗǝmaatǝr tagar band kwaha. ");
INSERT INTO glwl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kaa dagal kǝ iitǝr da vakavakin kwa ɗahav dǝ Getsemani, aiyam nǝ Yesu taa kǝ mbǝrzahaana, “Ndzamandzǝg vaakwana. Ən dagal da dzǝgwazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kaa dagal kǝ iin ǝmtaɗ dǝ Bitrusa, ard Yakuba, ard Yuhwana. Tǝhalakwaha kaa mbǝkǝnmbǝg nǝ dlaɗǝn da hǝɓɓǝg nǝ iin ba vaivaiya, dlaɓa tsǝgharatsǝg kǝ vǝgha. ");
INSERT INTO glwl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Aiyama taa kǝ iitǝra, “Shifǝgara hǝɓɓa dlaɗa ba vaivaiya bandgi na tsǝkwatsǝgga. Ndzamadzǝg vaakwana, famfǝg kǝ hyǝmiya, uufamuufǝgga.” ");
INSERT INTO glwl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Gavǝt ba nǝ iin da tǝvuukw hǝɗiikǝnan, kǝlla kǝ ghunji tǝ haiya, Kaa dzǝgwazhigǝl taaki akwama ɓagaɓaga, maa kǝsvaaran nǝ dlaɗna. ");
INSERT INTO glwl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Amaa, “Abba, Daada, aanji kwar kǝ dǝgita ɓagaɓag vakagha. Kǝswaarakǝssǝg kǝ kuwa dlaɗna. Bakǝvakwaha, ɓag kǝ dǝgiti agha naag nǝnga, dǝgiti ǝn naag nai biya.” ");
INSERT INTO glwl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sagha ba nǝ iina, kaa tlǝtǝraatlǝg kǝ iin kǝ mbǝrzahaan hǝnahaara, amaa taa kǝ Bitrusa, “Bitrus, agha hǝnahaara? Mbats agha dzǝgwanti kǝ fahyǝmi aanji dǝga aw pall biya? ");
INSERT INTO glwl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Famfǝg kǝ hyǝmiya, am dzǝgwan kǝ zhigǝla haik kǝ mbǝɗǝg kǝsuram tǝɗuula fǝshǝga. Bak jiijiira, naaghantnaag nǝ shǝɗǝkwa, vǝgh wa maay ndzǝɗ biya.” ");
INSERT INTO glwl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kaa gwiya dagal kǝ iin da dzǝgwazhigǝla, gwayaars bak kwahiin kǝ dzǝgwazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Gwiyaghǝra ba nǝ iin saassa, tlatǝraa ba hǝnahaara mbakyarvad haar ma gyiyaatǝr ba vaivaiya. Pǝletǝrvapelǝg nǝ dǝgiti ar da tagar nǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Gwiyaa ba nǝ iin da vakaatǝr kǝ dǝga hǝkǝrɗa, amaa taa kǝ iitǝra, “Gwaastǝn am ba ndzǝggaan hǝnahaar am ɗǝya kuɗǝgga? Atlanama! Wa ɓagaaɓag sarta kwada vǝlav Zǝra Uud damma dǝv kǝ yaa dadda haipaha. ");
INSERT INTO glwl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ciyamciiga, jiiyam dagala! Wa sǝghǝvsǝg daddakwa da vǝla kaiya!” ");
INSERT INTO glwl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ba ndzǝggaan Yesu ba taa ghaiya, kaa sagau kǝ Yahud pal ma mbǝrzahaan kǝlawa tar buwna, sarǝv ǝmtaɗ dǝ uudah ba ɗyaka dǝ katsakarah ard zadah vakaatǝra, ɓǝlartǝrǝt nǝ maalah ma zhiilakǝsuufaha, ard lii tsaga adzahadzaha Muusa, ard tlǝvuukwaha. ");
INSERT INTO glwl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tagatǝratag nǝ Yahud kǝ ɗuuli da vǝlǝg nǝ iin kǝ Yesu, amaa, “Daddakwa ǝn da bǝrhuug naiya, iin nǝ uud nǝ iina. Viiyamǝtviiga, langamlanga, hǝkyamnahǝkyig ba marawa.” ");
INSERT INTO glwl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Bad dagauwa Yahud wah da vak Yesu, amaa taa kǝ iina, “Dadda tsagadǝgit!” Kaa bǝrhugaan kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kaa viigǝtviig kǝ uudahiin kǝ Yesu, ar hǝkinan ba marawa. ");
INSERT INTO glwl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kaa tǝɗdatǝɗǝg nǝ pal ma mbǝrzaha Yesu kwandza ghacǝga tǝvǝgh kǝ iina, kǝ katsakaraana, ghudarda kǝ hyǝmi kǝ kwatǝnah maala zhillakǝsuufa. ");
INSERT INTO glwl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Am Yesu taa kǝ iitǝra, “Amaa sagal dǝ katsakarah ard zadah sa viiya kai bandgi ǝn dadda zaa ɗuula? ");
INSERT INTO glwl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ba kǝlahǝnga ǝn ba ǝmtaaɗ dǝ kuram ma gaagazaiya vǝgya Daadamazhigǝl ǝn tsagadigita, viiyamkwa biya. Barari righǝvant nǝ dǝgiti vindava ma kakaɗa Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tǝhalakwaha baɗǝm mbǝrzahaan ɗuwarǝsɗuga, ǝmndraraǝmndrǝga. ");
INSERT INTO glwl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ndza mǝng nǝ daala zǝriin gata Yesu tǝhala, maay nǝ sǝɗav tǝ vǝghaan biya, ba nuura kalti. Naha viiyarviig nǝ uudaha, ");
INSERT INTO glwl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Kaa ɗugarǝsɗug kǝ sǝɗavan ma dǝvaatǝra, kaa ǝmdǝradagal bad suuha. ");
INSERT INTO glwl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kaa lanngaan kǝ iitǝr kǝ Yesu da vǝgya maal batingting ma zhiilakǝsuufa, kaa dzahvǝtdzahǝg kǝ maalah ma zhiilakǝsuufaha, ard tlǝvuukwaha, ard lii tsaga adzahadzaha Musa da vaakwahiina. ");
INSERT INTO glwl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Kaa gatǝgaan kǝ Bitrus kǝ Yesu tǝhal tǝhala, ba bǝtky tagwavaatǝra. Gatǝgharsgatǝg ba tangw damma huɗa gaagazaiya vǝgya zhillakǝsuuf ba tingtinga. Cǝhura kǝ iin ǝmtaɗ dǝ lii uuffa hǝnyaha, ɗiira kaara. ");
INSERT INTO glwl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Gatargatǝg nǝ maalaha ma zhillakǝsuufaha ard gyiɗa maalah badǝm kǝ dǝgiti maraa da tlǝkǝna nǝ iitǝr kǝ shiid tǝghǝr kǝ Yesu taakiya, ɓagaɓag kǝ haipa kiyava tsǝgaan kǝ iitǝra, bakǝvakwaha, viiyarǝti dǝ haip biya. ");
INSERT INTO glwl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ghwadararsghwadǝg nǝ uudah ba ɗyak kǝ fiid kǝ Yesu, bakǝvakwaha ndzaabi ghaiyatǝr tǝ dǝgit pal biya. ");
INSERT INTO glwl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tǝhalakwaha kaa gwiya ciig kǝ kyǝlǝm uudaha, ar ghwudars kǝ fiid kǝ Yesu taakiya, ");
INSERT INTO glwl_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Cinngamndacinng tagadatag taakiya, ‘Ən dlagnadlag kǝ vǝgya Daadamazhigǝlǝn kwa ndǝraran nǝ uudaha, ǝn ndǝrant kwatlǝrǝn bamma hǝng hǝkǝrɗa, kwa ndǝrg uud biya.’ ” ");
INSERT INTO glwl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bakǝvakwah ǝlbǝgahaatǝr ndzaabi tǝ dǝgit pal biya. ");
INSERT INTO glwl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kaa ciig kǝ maal batinting ma zhillakǝsuufah ghacan mataatakaatǝra, kaa ndavǝgarundavǝg kǝ iin kǝ Yesu, amaa, “Agha maay dǝ ǝlbǝg biya? Əlbǝgahaan aa tagav tǝghǝr kǝskǝgh nǝm?” ");
INSERT INTO glwl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bakǝvakwaha mbǝɗabi nǝ Yesu kǝ ghaiyan biya, ndza kǝ iin ba ɗǝwa. Kaa gwiya ndavgarundavǝg kǝ maal batingting ma zhillakǝsuuf taakiya, “Kǝgh haa nǝ Kǝristi, Zǝra Daddakwa dǝ barkna?” ");
INSERT INTO glwl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ngwangw nǝ Yesu taakiya, “Aana ba kaiya. Am da nǝghanǝghǝg kǝ Zǝra Uuda ndzǝgan tǝ dǝvaa kaffa Daadamazhigǝl ǝmkyaɗaka, dlaɓa da saay ma akumba zhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kaa tahnatahǝg kǝ maal batingting ma zhillakǝsuuf kǝ sǝɗavahaana, amaa, “Kwar kǝ shiid dlaɓ wa kiyam naag nǝ miyami? ");
INSERT INTO glwl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Cinngamacing dlaɓa ghǝravaru kǝ badza ɗaaga Daadamazhigǝl aa tag nǝ iina! Auwam nǝ urami?” Kaa ghudgardaghud nǝ uudahi ndzar vaakwahiin baɗǝm kǝ shariya taakiya aa tsǝvatsǝgga. ");
INSERT INTO glwl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kaa fǝgarzhafǝg nǝ kyalǝmah kǝ tafgarǝv ashavaiya, ar mbuusaaraka kǝ gyiya, dlaɓa ar dlagharaa kǝ tsǝgga, am nǝ iitǝr taa kǝ iina, “Tagga kǝ daddakwa tsakǝgha!” Lii uuffa wakyagh dlaɓa ndakwani kaa kalgaan kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ndza mangyila gaagazaiya hǝnyaha nǝ Bitrusa, kaa sagau kǝ dǝghwiin pal ma kwatnaha maal batingting ma zhiilakǝsuuf da vaakwahiina. ");
INSERT INTO glwl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nǝgha ba nǝ iin kǝ Bitrus ɗiira kaara, kaa vazǝgaan kǝ iin ba marawa, amaa taa kǝ iina, “Kǝgh ndakwi agha ǝmtaɗ dǝ Yesu zhilla Nazareta!” ");
INSERT INTO glwl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kaa ɓalla gajau kǝ Bitrusa, amaa, “Ən sǝrgabi var kǝ dǝgiti agha tag nǝng biya. Nǝghanaakabi ba lingiling biya!” Tagada ba nǝ iin kǝ kwaha, Kaa ciya dagal kǝ iin damma bǝrcama hǝnyahiina, kaa wiig kǝ ghwatkala tǝhala kwaha. ");
INSERT INTO glwl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Gwiiya nǝgha ba nǝ dǝghwǝn kǝ Bitrus vaakwaha, kaa tagatǝrtag kǝ iin kǝ lii ghacǝga vaakwahiina, “Kwan ndakwani pal ghǝravaan ma iitǝra.” ");
INSERT INTO glwl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kaa gwiiya ɓalla gajau kǝ Bitrus dlaɓa. Tǝhala zǝlam hǝɗiikǝnana, aiyam lii ghacǝga tǝvǝgh kǝ Bitrus taa kǝ iina, “Bak jiijiira agha pal nǝng yan miitǝra. Aɗaba agha zhiil Galili nǝ ghǝravagha.” ");
INSERT INTO glwl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kaa fǝgarzhafǝg kǝ Bitrus ɗaava ghǝraana, dlaɓa kaa tlafa ghǝran baz ndaha waɗǝg tǝvukwatǝr taakiya. “Ən sǝrgai var kǝ uudanǝn am tag nǝ uuram kǝ ǝlbǝg tǝghǝrǝn biya.” ");
INSERT INTO glwl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Batwatswatsǝra kaa wiig kǝ ghwatǝkala kǝ dǝga buwa. Kaa dzamnadzamǝg nǝ Bitrus kǝ ǝlbǝgi taghar nǝ Yesu taakiya, “Lakwti wiig nǝ ghwatǝkala shig buwa, agha da ɓallǝgaan kǝ agajauwa sǝrkwabi shig hǝkǝrd biya.” Dzamghana ba nǝ iin kwan kǝ ǝlbǝga. Kaa ɓǝlaru kǝ iin kǝ tuuga. ");
INSERT INTO glwl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Dlakadur bawura, kaa ɗiya sawari kǝ maalaha zhiil kǝsauufaha, ard tlǝvuukwah ard lii tsaga adzahadzaha Musa, ard dzahava lii ma gyiɗ baɗǝmma. Kaa ngwaɗǝnangwaɗǝg kǝ iitǝr kǝ Yesu, ar langda da tǝvuukwa Bilatusa, ar fardǝm ma dǝva. ");
INSERT INTO glwl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kaa ndavgaruundavǝg nǝ Bilatus kǝ Yesu taakiya, “Kǝgh tlǝkǝssa Yahudaha?” Ngwugharangug Yesu amaa, “Aana, bandkwa tagǝda nǝnga.” ");
INSERT INTO glwl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kaa ghwadgarǝva ǝlbǝgah ba ɗyak nǝ maalaha zhiila kǝsauufaha. ");
INSERT INTO glwl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kaa gwiya ndavgarundavǝg nǝ Bilatus taakiya, “Agha maay mbǝɗa ghai biya? Cinng kǝ dǝgitahi ar tag nǝ iitǝr tǝghǝr kǝskǝgh ba ɗyaka.” ");
INSERT INTO glwl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Gwastǝna, mbǝɗabi Yesu kǝ ghaiyan biya, kwana vǝlgharvǝlǝg kǝ Bilatus kǝ dǝga jappǝr. ");
INSERT INTO glwl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Dǝgiti nǝt tlǝkǝs kǝ ɓagaan sarta hwaɗaga iin taakiya, ɓǝlars kǝ uud palla kwa ghalga nǝ uudah sagal ma guda bǝrfina. ");
INSERT INTO glwl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mǝng nǝ uuda nǝ iin ɗaagaan Barabbas kwa ɓǝlaavdǝm ma guda bǝrfina, ǝmtaɗ dǝ lii dzagwara dlagwam kwa tsara uuda ma sartǝn ciyit nǝ dlagwamǝna. ");
INSERT INTO glwl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kaa sagau kǝ dzahava dlamakǝlaaw da ghala Bilatus maa ɓagtǝra kǝ dǝgiti nǝt nǝ iina kǝ ɓagaana. ");
INSERT INTO glwl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ngwatǝrangug nǝ Bilatus amaa, “Am naagaan ǝn ɓǝlkurnǝs kǝ tlǝkǝssa Yahudaha?” ");
INSERT INTO glwl_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Aɗaba nǝghaakanǝghǝg nǝ Bilatus taakiya, ba shilǝg wa fatǝra maalah zhiilakǝsauufah kǝ vǝlla Yesu damma dǝvaana ");
INSERT INTO glwl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Maalaha zhiilakǝsauufah wa shaharant uudah kǝ taakiya aa ɓǝlkǝmndarsɓǝlǝg nǝ uud kǝ Barabaas tǝghǝr kǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kaa ndavtǝrundavǝg nǝ Bilatus taakiya, “Au kaci wanda ɓag nai dǝ kwam ɗaag nǝ uuram dǝ tlǝkǝssa Yahudahni?” ");
INSERT INTO glwl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ar ɗǝyaru kǝ iitǝr kǝ cau ar taakiya, “Aa hǝrtǝvǝthǝrtǝgga!” ");
INSERT INTO glwl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Aiyam nǝ Bilatus taa kǝ iitǝra, “Mbakyauwi? Au nǝ haipaani?” Ar gwiya dzǝgant kǝ kungy ar taakiya, “Aa hǝrtǝvǝthǝrtǝgga!” ");
INSERT INTO glwl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Naagaan tsau nǝ Bilatus hǝngtǝrna kǝ ǝrviɗmahuɗaatǝra, ɓǝltǝrnǝs kǝ Barabaas. Tǝhalakwa fǝgharaa nǝ iin kǝ uudah kǝ dlaghgaru kiiɓ kǝ Yesu, kaa vǝltǝr kǝ iin kiyava hǝrtǝgga. ");
INSERT INTO glwl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kaa dadǝg nǝ tlaujah kǝ Yesu damma gaagazaiya vǝgya gumna. Ar dzahant kǝ tlaujah baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ar tsǝgwardǝm kǝ sǝdav kyang hulfa dǝga tlǝkǝssaha, dlaɓa ar ɓagara kǝ dzakwa takka, ar fardǝm ma ghǝra. ");
INSERT INTO glwl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ar farzha kǝ tagar uus taakiya, “Kǝm ma barkagh tlǝkǝssa Yahudaha!” ");
INSERT INTO glwl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kaa kalgaan kǝ iitǝr dǝ zad ma ghǝra, ar tafarǝva kǝ ashavaiya. Tǝhalakwaha ar kǝlla kǝ ghunj tǝvuukwana am nǝ iitǝra ar fǝgaaradfǝga. ");
INSERT INTO glwl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ghyǝngara ba nǝ iitǝr kǝ nenegaana, ar sǝɗarda kǝ sǝɗava tlǝksǝna, ar tsagwɗǝm ma sǝɗavahaana. Tǝhalakwaha ar langda dagal da gyǝmal kiyava hǝrtǝgaana. ");
INSERT INTO glwl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ar tǝghǝrdǝga dagala, kaa nǝghǝganǝghǝg kǝ iitǝr kǝ uuda nǝ iin ghwudadagal, kwa ɗahav dǝ Siman, zhiila Sayirina, daddaatǝr kǝ Alekzanda ard Rufus, saas ma gǝdzǝr kǝssa, ar faraa baɗ ndzǝɗ kǝ kǝssa tlaɓa hǝrta Yesu. ");
INSERT INTO glwl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ar langda kǝ Yesu da vakavakiin kwa ɗahav dǝ Golgata, (dǝgiti tuuk vakai nǝ iina “Vakka kuwa ghǝra”). ");
INSERT INTO glwl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Vǝlarar vaakwahiin nǝ iitǝr kǝ yuwa innabi laɓalaɓan dǝ mur, luwa kǝ hǝɓgaana. ");
INSERT INTO glwl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ar hǝrtǝtta. Ar tagwna dlaɓ kǝ sǝɗavahaan ma taatakaatǝra, kaa tsa tsats kǝ iitǝr tǝghǝr kiyava vaza dǝgiti aa tlǝkǝna aanji waratǝra. ");
INSERT INTO glwl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Hǝrtarǝt ma sarta vaslambaɗa dlakadura. ");
INSERT INTO glwl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ar vinda tǝ tlaɓa hǝrtǝg kǝ ǝlbǝgi ghwudararva nǝ iitǝr taakiya, “TLƏKƏSSA YAHUDAHA.” ");
INSERT INTO glwl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ar hǝrtǝt kǝ gǝlah buwa ǝmtaɗ dǝ iina, pal tǝ dǝvaa kaffaana, pal dlaɓ tǝ dǝvaa ghyaɓɓaana.  ");
INSERT INTO glwl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kwan iin nǝ righǝgga tlayangǝr kwa tagaa taakiya, “Kǝdlavǝna ma lii haipaha.” ");
INSERT INTO glwl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Uudahi ghudadagal ar tagar ǝlbǝga nenega, ar gajaga ghǝr ar taakiya, “Caa! Kǝghi agha dlagǝnadlag kǝ vǝgya Daadamazhigǝla, dlaɓa agha da gwiya ndǝrant bamma hǝng hǝkǝrɗa, ");
INSERT INTO glwl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","katǝg ci kǝ ghǝragha, agha sii bi dlaɓ tǝ tlaɓa hǝrtǝg biya!” ");
INSERT INTO glwl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bandkwah dlaɓ nǝ maalah ma zhiilakǝsauufah ard lii tsaga adzahadzaha Musa, kaa nenegaan kǝ iitǝr ma taatakaatǝr ar taakiya, “Katǝghankatǝg kǝ kyalǝma, pilgharvaapilǝg kata ghǝraana! ");
INSERT INTO glwl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Aa sasii ci ndan Kǝristi tlǝkǝssa Israˈilǝn ndakwan tǝ tlaɓa hǝrtǝgǝna, kiyava nǝghǝganǝghǝg kǝskǝmnd kǝm fǝdghǝrǝta!” Baz gǝlahǝn hǝrtavǝt ǝmtaɗ dǝ iinǝn ndakwani kaa taa ǝlbǝgahi ghwaɗghwaɗ kǝ iitǝr tǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Bad vacci tǝghǝra, kaa hǝɗgarduhǝɗǝg nǝ gurtl kǝ lard baɗǝma, tangw damma hǝkǝrɗa hwassa. ");
INSERT INTO glwl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tǝhalakwaha, sarta hǝkǝrɗa hwaasa, kaa dzagantdzǝg nǝ Yesu kǝ kuungy bad halavuwa ndzǝɗaan, amaa, “Eloi, Eloi, lama sabaktani?” Iin taakiya, “Daadamazhigǝl Daadamazhigǝla, agha fiikwada daɓawi?” ");
INSERT INTO glwl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Cinngara ba nǝ lii ghaciga vaakwahiin kwaha, aiyam nǝ iitǝra, “Wai nǝ iin ɗaa tlaiyang Iliya.” ");
INSERT INTO glwl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kaa ǝmdǝrǝg kǝ pallǝraatǝra, rǝmda kǝ abarabar dǝ yuwa inabi kwarekreka tǝ zadda, vǝlar kǝ Yesu kiyava hǝɓɓǝga, aiyama, “Vazyamvazǝg ndana! Mbatak da sagau nǝ tlayang Iliya da sii dǝ vakaiya.” ");
INSERT INTO glwl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kaa dzǝgantdzǝg Yesu kǝ kungy bad halavuuwa ndzǝɗaana, tǝhalakwaha, kaa ɗiya shifǝgga halavuuwana, ǝmtsana. ");
INSERT INTO glwl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kaa tǝhgǝmtǝhǝg kǝ ɓǝlyaɓǝlya Vǝgya Daadamaazhigǝl hutsǝg buwa ciigǝt ma ghǝraan tangw damma suhwaana. ");
INSERT INTO glwl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nǝgha ban nǝ tlaujin ndza ghaciga tǝvuukwa Yesu kǝ ɗuuli ǝmtsa nǝ iina, aiyama, “Ba pakat uudanǝn Zǝra Daadamazhigǝla!” ");
INSERT INTO glwl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kyalma ǝnghwasaha, ghaccara ba ndzaɗɗa ar vazǝggaana. Ma iitǝra mǝng Maryam Magadala, ard Maryam babba Yakub kudǝrkudǝra ard Isuvuwa, ard Salomi. ");
INSERT INTO glwl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Gatarars ciigǝt sagat ma Galili nǝ ǝnghwasahaan ar ba mǝlgarumǝlga. Dlaɓa baɗyak nǝ kyalǝma ǝnghwasah kwa darǝt ǝmtaɗ dǝ iin ma Wurshalim ndakwi ndzar ba vaakwaha. ");
INSERT INTO glwl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ɗǝm ba faciya hwaasa, kaa ɓadlav kǝ uudaha, aɗaba dlakaduraan Faciya Ngiiga. ");
INSERT INTO glwl_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Kaa sagal kǝ uuda nǝ iin ma Arimatiya ɗaagaan Isuvuwa. Pall ma gyiɗya lii maalmala nǝ iina, dlaɓa fǝvaarafǝga, kwa pakka saaya tlǝkkǝssǝra Daadamazhigǝla. Shughanashug kǝ gyi da vak Bilatus, da ghala ma vǝlvar nǝ tlǝwa vǝgha Yesu. ");
INSERT INTO glwl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Cinngha ba nǝ Bilatus taakiya ǝmtsaǝmtsǝg nǝ Yesu, vǝlgharvǝlǝg kǝ dǝga ajappǝra. Ɗahant kǝ iin kǝ maala tlaujiin ndavaru taakiya bak jiirjiira ha ǝmtsaǝmtsǝg nǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Cinngha ba nǝ iin vak maala tlaujin taakiya band kwaha, kaa vǝlar kǝ iin kǝ Isuvu kǝ tlǝwa vǝgha Yesu. ");
INSERT INTO glwl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kaa sǝgwdaasǝgw nǝ Isuvu kǝ kǝlpakana, sǝddi kǝ iin kǝ tlǝwa Yesu tǝ tlaɓa hǝrtǝgga, faɗant ma kǝlpakana, fǝdǝm kǝ iin ma gǝtl kwa kwaɗava ma kura. Tǝhala kwaha, hutambardi kǝ akura hǝɗardu kǝ iin kǝ ghaiyan dǝ vakaiya. ");
INSERT INTO glwl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nǝghǝranǝghǝg nǝ Maryamu Magadala ard Maryamu babba Isuvu kǝ vakavaki fava dǝ tlǝwa vǝgha Yesu. ");
INSERT INTO glwl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Dal ba faciya ngiigga, kaa sǝgwasǝgw kǝ Maryam Magadala, ard Maryam babba Yakub, ard Salomi kǝ tǝrshan kiyava dzuupǝg tǝ tlǝwa Yesu. ");
INSERT INTO glwl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Davala faciya zǝngw ma maaka, kaa dagal kǝ iitǝr damma gǝtlah ba dlakaduur wur kǝssa. ");
INSERT INTO glwl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tǝghǝrdǝgga dagala, am nǝ iitǝr mataatakaatǝra, “War wada tlǝkkiyamarwatlǝg kǝ akuriin tuuk kǝ ghaiya gǝtli?” ");
INSERT INTO glwl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Daragha ba nǝ iitǝr da vaakwahiina, dzǝgarant ba nǝ iitǝr kǝ ghǝraatǝra, kaa nǝghǝganǝgh kǝ iitǝr mbats tlǝgavarwatlǝg nǝ akuriin dagala. Akuriin ndza maanda. ");
INSERT INTO glwl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Daragha ba nǝ iitǝr damma gǝtliina, kaa nǝghǝgaanǝghǝg kǝ iitǝr kǝ daala zǝr tsagwatsagwan ma sǝɗav maɗǝkwa cǝhurga tǝ ghyaɓa dǝvaakaffa, kaa gǝdzǝgǝtgǝdzǝg kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Am daala zǝrǝn taa kǝ iitǝra, “Ɓagambi kǝ ajappǝr biya. Am gata Yesu uuda nazare kwa hǝrtavǝtǝna? Abi, ciyitciiga. Maay vaakwan biya. Wan vakavaki hǝngavna nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Damdǝga, am tagar kǝ mbǝrzahaana, ard Bitrus, taakiya da dǝga nǝ iin tǝghǝr kǝ iitǝr damma Galili, ar da nǝghǝga vaakwah nǝ iitǝr bandkwa tagatǝr nǝ iina.” ");
INSERT INTO glwl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kaa ǝmndǝra saggal kǝ ǝnghwasahahaana, ar ɓa jappǝr dlaɓa tǝg nǝ vǝghatǝra. Tagararbi aanji ndǝwar kǝ ǝlbǝg biya, aɗaba gǝdzarǝtgǝdzǝgga.  ");
INSERT INTO glwl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ciyit ba nǝ Yesu ma gǝtlah dlakadur ba wur davala faciya zǝngw ma maaka, marda kǝ ghǝraan ba zǝngw vak Maryamu Magadala, kwa lagwgharda nǝ iin kǝ shatanah uuɗiif ma vǝghaana. ");
INSERT INTO glwl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kaa daas kǝ iin tagtǝr kǝ uudahi ndzar ǝmtaɗ ba bawur dǝ iina, lii taa dzǝgwagha ar tuuga. ");
INSERT INTO glwl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Cinngaraba nǝ iitǝr taakiya dǝ shifǝg nǝ Yesu, dlaɓa nǝghghanǝghǝg nǝ Maryama kǝ iina, fardghǝrǝt biya. ");
INSERT INTO glwl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tǝhalakwaha, kaa mbǝɗvǝghambǝɗǝg nǝ ndzǝgana vǝgha Yesu, kaa mardamarǝg kǝ ghǝraan vak mbǝrzah buwa masarta kwa ndzar tǝ ɗuula dagal damma gǝdzǝrkǝsa. ");
INSERT INTO glwl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kaa gwiyadaas kǝ lii buna ar tagar kǝ kyalmaha, bakǝvakwaha larwalǝg kǝ fadǝghǝr tǝ ǝlbǝgiina. ");
INSERT INTO glwl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tǝhalakwaha, kaa mardamarǝg nǝ Yesu kǝ ghǝran vak kǝlawa tǝmkikǝn ma sarta kwa ndzar za kaffa. Kaa cagtǝraacag kǝ iin kǝ gyi tǝghǝr kǝ maira fadghǝraatǝra ard dǝkdǝka ghǝraatǝra, aɗaba fadghǝrǝtbi dǝ lii nǝgharanǝghǝg tǝhala ciigaan biya. ");
INSERT INTO glwl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Amaa taa kǝ iitǝr dlaɓa, “Damdǝg damma duni baɗǝmma, tagamtǝrtag kǝ ǝlbǝg maraw kǝ uudah dǝshiga. ");
INSERT INTO glwl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Baɗǝm daddakwa fadghǝrǝtfǝga, dlaɓa ɓagvara nǝ tsuufǝgga, da tlǝkkǝnatlǝg kǝ katǝgga. Baɗǝm daddakwa fadghǝrǝt biya da vǝlǝvtǝr dlaɗa. ");
INSERT INTO glwl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wan nǝ dǝgiti da ɓag lii gata kaiya kiyava marra fadǝghǝratǝra. Ar da lagwan kǝ shatanah ma ɗaagara, ar da tagaan dlaɓa kǝ ǝlbǝg dǝ daala ghaiyaha. ");
INSERT INTO glwl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ar da kǝssǝggaan kǝ ghavalah dǝ dǝvahaatǝra. Ma hǝɓaruhǝɓǝg kǝ gurra, maay nǝ dǝgiti da ɓagtǝr nǝ iin biya. Ar da fǝgaan dlaɓa kǝ dǝvahaatǝr tǝ lii yangbiya, ar da mbǝgga.” ");
INSERT INTO glwl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tǝhala kwa tagatǝra nǝ Yaazhigǝl Yesu kǝ kwanǝn kǝ ǝlbǝga, kaa kǝsvantkǝsǝg dǝvdǝt damma ghǝrazhigǝla, ndza kǝ iin tǝ dǝvaa kaffa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kaa dagal kǝ mbǝrzahaana, kaa taa ǝlbǝg maraw kǝ iitǝr aanji takwara. Ɓagaɓag nǝ Yaazhigǝl kǝ tlǝr ǝmtaɗ dǝ iitǝra, dlaɓa mara jiira ǝlbǝgahatǝr tǝdvad dǝgaha sǝrgah kwa vǝlla jappǝr fatǝraa nǝ iin kǝ ɓaggaan ǝmtaɗ dǝ ǝlbǝgahiina.");
INSERT INTO glwl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Bamma zunngwura ndza mǝng nǝ ǝlbǝga, ǝlbǝgna ndza ǝmtaɗ dǝ Daadamazhigǝla, ǝlbǝgna Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Iin wandza ǝmtaɗ dǝ Daadamazhigǝl bamma zǝnngwura. ");
INSERT INTO glwl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Baɗǝm nǝ dǝgitah ɓaggava ba tǝdvad iina. Maay nǝ dǝgitahi ɓagavnan kwal tǝdvad iin biya. ");
INSERT INTO glwl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Əlbǝgǝn iin gyigyiya shifǝga, shifǝgna iin wa vǝlgar parakrakǝr kǝ uudah baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kwanǝn kǝ parakka ba parakrak ma gurtla, gurtlǝn tsǝgarva bi kǝ parak kǝ ɓa parakrakǝr biya. ");
INSERT INTO glwl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ndza mǝng nǝ uuda nǝ iin ɗahav dǝ Yuhwana kwa ɓǝladi Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Sahi sa taggar ǝlbǝg jiir kǝ uudah tǝghǝr kǝ parakna, aɗaba maraa fǝdghǝrǝt nǝ uudah baɗǝmma tǝdvad iina. ");
INSERT INTO glwl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yuhwan bi nǝ parakǝn biya, sahi kwakyarvad tagtǝr kǝ ǝlbǝg tǝghǝr kǝ parakǝn kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tagatǝrdagag nǝ Yuhwan taakiya, Parak jiijiira da sii sa ma duniya da vǝltǝr kǝ parak kǝ uudah baɗǝma. ");
INSERT INTO glwl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Kwanǝn kǝ uuda iin parakka ndza bamma duniya, virɗyava tǝdvad iin nǝ duniya, bakǝvakwaha sǝraraaka bi nǝ-uudah biya. ");
INSERT INTO glwl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Sǝghǝv ba nǝ iin savak uudahaana, larwalǝg nǝ uudahaan kǝ dlǝghǝggaana. ");
INSERT INTO glwl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Aiciya, baɗǝm nǝ uudahi dlǝgharadlǝghǝg kǝ iina, dlaɓa ar fǝdghǝrǝt tǝ iina, vǝlatǝrvǝlǝg kǝ ndzǝɗɗa nǝg kǝ zarha Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Naral bi kǝ zarha Daadamazhigǝl tǝdvad uuda dǝgshig biya, bi tǝdvad camarakǝv biya, bi tǝdvad dzamaghǝra uud biya, bamma yavva tǝdvad naaga Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kwanǝn kǝ ǝlbǝga nalnǝg kǝ uuda, ndzaandzǝg mataatakamiyama. Nǝghamndanǝghǝg kǝ ndanngǝraana, Ndangǝra Zǝraan pal ba nǝ iin kwa sahi vak Daada, righarighan dǝ hɛrrǝr ǝmtaɗ dǝ jiira. ");
INSERT INTO glwl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Tagadatag nǝ Yuhwan kǝ ǝlbǝg tǝghǝr kǝ iin vak kǝ uudah bad halavuwa ndzǝɗaan taakiya, “Kwanǝn kǝ uud wa tagaan nai kǝ ǝlbǝg tǝghǝr taakiya, ‘Kwada sagau tǝhalara jakwaarajig dǝ ɗyakǝr ba vaivaiya, aɗaba lakuti kǝskaiya ba mǝng nǝ iina.’ ” ");
INSERT INTO glwl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tǝdvad ɗyakǝra hɛrǝraan wa tlǝyamkǝna nǝmyam kǝ hɛrǝr tǝghǝr kǝ hɛrǝra. ");
INSERT INTO glwl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Vǝlada tǝdvad Muus nǝ Daadamazhigǝl kǝ adzahadzaha, dlaɓa vǝlada hɛrǝr ard jiir tǝdvad Yesu Kristi. ");
INSERT INTO glwl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Maay nǝ uudi tapghanitapǝg kǝ nǝghǝgga Daadamazhigǝl dǝ gyi biya, bamma Zǝriin palla, kwa ghǝravaan ndakwi Daadamazhigǝla. Kwa cǝhurga ǝmtaɗ dǝ Daadamazhigǝla iinwa marakiyamnda iina, dlaɓa kaa fǝkiyamafǝg kǝ sǝrgasǝrg kǝskǝmyam kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Wan nǝ ǝlbǝgi tagada nǝ Yuhwan masarta kwa bǝlartǝrǝt nǝ maalah Yahudah kǝ zhiila kǝssa-uufah ard lii fa hyimi tǝ vǝgya Daadamazhigǝl kwa saral ma Wurshalima sa ndavgaru taakiya, “Agha war nǝngi?” ");
INSERT INTO glwl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ɓalla bi nǝ Yuhwan kǝ agajau biya, tagadatag bat ɓalaɓal taakiya, “Kai bi nǝ Kristi biya”. ");
INSERT INTO glwl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kaa ba ndavgarundavǝg kǝ iitǝr taakiya, “Agha war nǝngi? Kǝgh nǝ Iliya?” Ngal ba ngutǝrangug kǝ iin taakiya, “Kai biya.” “Kǝgh tlayangǝn kǝm pakǝg nǝmndna?” “Kai bi, awarama.” ");
INSERT INTO glwl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tǝhala kwaha, am nǝ iitǝr taa kǝ iina, “Agha war kaci nǝnngi? Tagkǝmndtag magha war nǝnnga aɗaba kǝm sǝra kǝ dǝgiti kǝmnda tagtǝr nǝmnd kǝ liiya ɓǝla kǝmnda. Agha ɗaag dǝ war kaci nǝnng kǝ ghǝraghi?” ");
INSERT INTO glwl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ngwatǝrangwug nǝ Yuhwan tǝdvad ǝlbǝgaha tlayang Ishaya taakiya, “Kai nǝ ghai kwa ɓǝla tlǝhǝg ma tǝghala, ‘Ɓadlamarnaɓadlǝg kǝ ɗuulan kǝ Yaazhǝgǝla!’ ” ");
INSERT INTO glwl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kyalma lii ɓǝlavtǝrǝtɓǝlgna ndzar Farisiyaha. ");
INSERT INTO glwl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Kaa ndavgarundavǝg kǝ iitǝr kǝ Yuhwan taakiya, “Akwama kǝgh bi nǝ Kǝristi biya, kǝgh bi nǝ Ili biya, dlaɓa kǝgh bi tsau nǝ Tlayangǝn biya, Kwar kǝ ndzǝɗ kaci wagha dǝ vakai nǝng agha ɓagtǝr tsuufǝg kǝ-uudahi?” ");
INSERT INTO glwl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ngal ngutǝrangug Yuhwan taakiya, “Ən ɓagtǝr dǝ yu nai kǝ tsuufǝg kǝ uudaha, bandakwan bamma taatakaruwa mǝng nǝ daddakwam sǝrga bi nǝ uuram biya. ");
INSERT INTO glwl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Iin wa taggan nai taakiya da sagau tǝhalara, kwa tlanal bi nai kǝ pǝla zauwa kimmbakaan biya.” ");
INSERT INTO glwl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Baɗǝm wanahaan dzǝghaar ma Betani, kilga zaagha Yudan, vakavaki ɓagatǝr nǝ Yuhwan kǝ tsuufǝg kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Dlakaduraana, kaa nǝghganǝghǝg Yuhwan kǝ Yesu da vakaan amaa, “Wayam, nǝ Zǝr tuugha Daadamazhigǝl kwada kǝsa haipa uudaha duniya ");
INSERT INTO glwl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Kwanǝn wa taggan nai kǝ ǝlbǝg tǝghǝr taakiya, ‘Mǝng wa da saggau tǝhalara kwa jakwarajig kǝskaiya, aɗaba mǝng nǝ iin lakwti yikwayig nǝ uuda.’ ");
INSERT INTO glwl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Dzan sǝrgabi ghǝravar kǝ iin wur biya. Tsuufǝgǝn ɓagan nai dǝ yu na, ɓaggan mbakyarvad marǝvtǝrda nǝ iin kǝ uudaha yaa Israˈal bat ɓalaɓala.” ");
INSERT INTO glwl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kaa tagdatag kǝ Yuhwan kǝ shiid tǝghǝr kǝ iin taakiya, “Nǝghananǝghǝg kǝ Shǝɗǝkw Daadamazhigǝl band garava kakur sii ma ghǝrazhigǝl, ngal tsǝgwatsǝgw tǝghǝr kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ndzan sǝrgai nai kǝ iin wur biya, bamma Daadamazhigǝli ɓǝllakut kai da ɓa tsuufǝg dǝ yu, iinwa taghwatag taakiya, ‘Uudi agha nǝghǝgga nǝng kǝ shǝɗǝkw sii sa tǝghǝr kǝ-iin dlaɓa ndzan tǝghǝr kǝ iina, iin dadda ɓa tsuufǝg dǝ Shǝɗǝkw Daadamazhigǝla.’ ");
INSERT INTO glwl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ba kai dǝ ghǝrara nǝghananǝghǝg kwana, ǝn tagkurtaga, kwanǝn kǝ uuda zǝra Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Wurga kǝsaana, Yuhwan ghacǝgan vaaakwahiina ǝmtaɗ dǝ mbǝrzahaan buwa. ");
INSERT INTO glwl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kaa nǝghǝganǝghǝg kǝ iin kǝ Yesu ghuda dagala, amaa, “Vazamvazǝga, wayam nǝ Zǝr mbaklaka Daadamazhigǝla!” ");
INSERT INTO glwl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Cinngara ba nǝ mbǝrzahaan buna kǝ Yuhwan taa ghaiya, kaa gata Yesu kǝ iitǝr dagala. ");
INSERT INTO glwl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ɓǝlaa ba nǝ Yesu kǝ gyi dat hala, kaa nǝghǝganǝghǝg kǝ iitǝr ar gatǝgaana, kaa ndavtǝrundaavǝg taakiya, “Awam gatǝg nǝ uurami?” Aiyam nǝ iitǝr taa kǝ iina, “Rabbi” iin taaki dadda tsaga dǝgita, “Agha ndzǝga mǝri?” ");
INSERT INTO glwl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Aiyam Yesu taa kǝ iitǝra, “Asamasǝga am da nǝghǝganǝghǝga.” Kaa dagal kǝ iitǝr ar vazzǝna kǝ vakavaki ndzǝga nǝ iina, ar cahwaran ǝmtaɗ dǝ-iin vaakwahiina. Kwan kǝ dǝgita dzǝghaar kalkala karfi uufaɗa hwasa. ");
INSERT INTO glwl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Pal nǝ Andrawus zǝra babba Siman Bitrus ma uudahaan buwǝn gatar Yesu tǝhala kwa cinngara nǝ iitǝr kǝ ǝlbǝga vak Yuhwan tǝghǝr kǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Dǝgiti ɓagaa nǝ Andrawus ba zǝnngwa fǝgharzh gata zǝra babbaan Siman, amaa taa kǝ iina, “Tlamndkǝnatlǝg kǝ Tlǝkatǝgna,” Iin nǝ Kristi. ");
INSERT INTO glwl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Sǝdǝv kǝ-iin kǝ Siman da vak Yesu. Kaa vazǝggaan nǝ Yesu kǝ Siman amaa taa kǝ-iina, “Kǝgh nǝ Siman zǝra Yuhwana? Da ɗahak dǝ Kefas nǝ-uuda.” (Dǝgiti tuuk vakai nǝ Kefas ard Bitrusa ba dǝgit palla, iin na akura). ");
INSERT INTO glwl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Dlakaduraana fadǝmfǝg nǝ Yesu ma ǝrviɗmahuɗaan dagal damma Galili. Kaa tlǝgaratlǝg kǝ iin kǝ Filigus taakiya, “Gatkwagatǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filigus uuda kǝsa Betsaid nǝ iina, vakavaki saral nǝ Andrawus ard Bitrusa. ");
INSERT INTO glwl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tlǝghara ba nǝ Filigus kǝ Nataniyela, amaa taa kǝ iina, “Tlamndkǝnatlǝg kǝ uudanǝn kwa vinda nǝ Muus ma kakaɗa adzahadzah taakiya da saaya. Dlaɓa vindaravindǝg nǝ tlayangngah kǝ ǝlbǝg tǝghǝr band kwaha. Iin nǝ Yesu Uuda Nazarat, Zǝra Isuvu.” ");
INSERT INTO glwl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Kaa tagaan kǝ Nataniyel taakiya, “Nazarata? Sǝgalsǝg dǝgit maraw ma Nazarata?” Aiyam nǝ Filgus taa kǝ-iina, “Saw na vaznavazǝgga.” ");
INSERT INTO glwl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nǝgha ba nǝ Yesu kǝ Nataniyel sagau sa vakaana, aiyama, “Wayam nǝ uuda jiijira yaa Israila, kwa maay nǝ fiid ma ghaiyan biya.” ");
INSERT INTO glwl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Kaa ndavgarundavǝg nǝ Nataniyel kǝ Yesu taakiya, “Sǝrghkwa ndari?” Ngal ngugara-nggug kǝ Yesu taakiya, “Nǝghankak bamma sartǝn ndza agha miizhangyil kǝ uufa ghǝgyivvǝna, lakwti ɗahakɗahǝg kǝ Filigusa.” ");
INSERT INTO glwl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Am Nataniyel taa kǝ Yesu, “Dadda tsagga dǝgita, kǝgh Zǝra Daadamazhigǝla! Kǝgh nǝ Tlǝksa Israila!” ");
INSERT INTO glwl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Kaa ndavgarundavǝg nǝ Yesu kǝ Nataniyel taakiya, fǝghdǝghǝrǝt mbakyarvad tagankak taakiya nǝghankak miizha ghǝgyivva? Agha da nǝghǝganǝghǝg kǝ dǝgiti juujig kǝ kwaha. ");
INSERT INTO glwl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kaa gwiya tagtǝrtag kǝ Yesu taakiya, “Ən tagkurtag kǝ jiira, am da nǝghǝganǝghǝg kǝ ghǝrazhigǝl wurawurana, Zarha ɓǝlga Daadamazhigǝla ar dagat ar saay tǝ Zǝra uuda.” ");
INSERT INTO glwl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Daghuvala hǝnnga hǝkǝrɗa, ndza mǝnng nǝ hwaɗaga kǝsa uus ma Kana kwama Galili. Babba Yesu ndakwi ndza ba vaakwahiina. ");
INSERT INTO glwl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Baz Yesu ard mbǝrzahaan ndakwi ɗahavtǝrǝɗahǝg da vaka hwaɗaga kǝsa uusiina. ");
INSERT INTO glwl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ghyǝnnga ba nǝ yuwa inabiya, kaa tagartag nǝ babbaan kǝ Yesu taakiya, “Maadlabi nǝ yuwa inabiyaatǝr biya.” ");
INSERT INTO glwl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Aiyam nǝ Yesu taa kǝ babbaana, “Baaba, aujilbǝg agha taggǝwa kwan kǝskayi? Bagaa bi nǝ sartar ndan biya.” ");
INSERT INTO glwl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Am nǝ babba Yesu taa kǝ lii ɓa tlǝra, “Baɗǝm nǝ dǝgiti tagkur nǝ iina, ɓagamɓaga.” ");
INSERT INTO glwl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Vaakwahiina mǝnng nǝ ndǝghwah ǝngkwah kwa ndǝrava dǝ akura hulfa kwa ɗiyav nǝ yu mavakaiya, ar bara vǝghatǝr nǝ Yahudah dǝ yuwiin kwakyarvad dǝga daadijahaatǝra. Makwar kǝ ndǝghwa hǝɓa dǝfuu ǝnkwaha. ");
INSERT INTO glwl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Am nǝ Yesu taa kǝ lii ɓa tlǝrna, “Reghamantreghǝg kǝ ndǝghwahaana dǝ yuwa.” Kaa reghǝgantreghǝg kǝ iitǝr ba pɛkapɛkan. ");
INSERT INTO glwl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Aiyam nǝ Yesu taa kǝ iitǝra, “Gahamgahǝg ci ndakwana, gamǝtgǝga damardadǝg kǝ zhiilghuu.” Kaa gǝtgǝg kǝ iitǝr ar dardana. ");
INSERT INTO glwl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tapghana ba zhilghuu kǝ yuwǝn kwa gwiyavǝt damma yuwa inabi, sǝrghabi kǝ vakavaki tlavkǝna nǝ iin biya lii ɓa tlǝra ar sǝrgasǝrga. Ɗahant kǝ iin kǝ zhiila ghuul damma dlǝmmbaava. ");
INSERT INTO glwl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Amaa taa kǝ iina, “Abi, aanji ba war saggal dǝ yuwa inabi marawǝn ba zǝngwa, akwama tlatǝrtlǝg kǝ uudaha, kaa saggal kǝ uud dǝ dlǝmndalaana. Agha shǝɓna nǝng kǝ yuwa inabi marawǝn agha da sagal tǝhal nǝng dǝ vakaiya!” ");
INSERT INTO glwl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kwan nǝ dǝga jappǝri ɓagaa nǝ Yesu ba zǝnngwa ma Kǝsa kana kwama haaya Galili. Marada ndkwan kǝ ndangǝrana, kaa fadghǝr kǝ mbǝrzahaan tǝ vakaiya. ");
INSERT INTO glwl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tǝhala kwaha kaa di damma kǝssa Kafarnahum kǝ Yesu dǝ babbaana ard zarha babbaana ǝmtaɗ dǝ mbǝrzahaana. Ar gahha kǝ hǝnngah hǝɗiikǝn vaakwaha. ");
INSERT INTO glwl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Hǝrzǝt ba nǝ sarta haarakǝsa dzava hǝnnyaha Yahudaha, kaa dagat kǝ Yesu damma Wurshalima. ");
INSERT INTO glwl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kaa daas kǝ-iin damma vǝgya Daadamazhigǝla, tlǝtǝra kǝ uudah vǝlla tlaha, aagwaha, takalamasaraha. Dlaɓa nǝghǝganǝghǝg kǝ kyalma uudah ar cihurgan tǝvǝgh kǝ tebǝrahaatǝr ar mbǝɗǝgar kwaɓ kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kaa ndǝrgandǝrǝg kǝ iin kǝ zauwa kiiɓa, lagwtǝrda dagal baɗǝm ma vǝgya Daadamazhigǝla, baz tuughwaha baz tlaha. Tlagars kǝ teburaha lii mbǝɗa kwaɓa, kwaztǝrda kǝ kwaɓatǝr da tǝhaaya. ");
INSERT INTO glwl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Am nǝ Yesu taa kǝ-lii vǝla takalamasarna, “Hutsamndahutsǝg kwanahaan dagal vaakwana! Lamdal bi kǝ vǝgya daadar kǝ kasukwa biya.” ");
INSERT INTO glwl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Dzǝghaar ba nǝ wanǝnna, kaa dzamnadzamǝg kǝ mbǝrzahaan kǝ dǝgiti vindava ma kakkaɗa Daadamazhigǝl taakiya, “Waigǝn ǝn waig nai kǝ vǝgyaghna zǝkwazǝg tǝ ǝrviɗmahud band kaara”. ");
INSERT INTO glwl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kaa ndavgarundavǝg kǝ tlǝvuukwaha Yahudah kǝ Yesu, taakiya, “Kwar kǝ dǝga jappǝr wagha da markǝmndada nǝng kwada mara taakiya agha dǝ ndzǝɗa ɓa kwanahaan kǝ dǝgitah baɗǝmmi?” ");
INSERT INTO glwl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Aiyam nǝ Yesu taa kǝ-iitǝra, “Dlagamnadlag kǝ Vǝgya Daadamazhigǝlna, ǝn ndǝrgaan nai bamma hǝngah hǝkǝrɗa.” ");
INSERT INTO glwl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Am nǝ iitǝr taa kǝ Yesu, “Viig kul uufaɗ tar ǝnkwah kǝ uud ndǝra vǝgya Daadamazhigǝlna, aitsǝm ǝn ndǝrgandǝrǝg bamma hǝngngah hǝkǝrd amǝngnga?” ");
INSERT INTO glwl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Vǝgyǝn tag nǝ iin kǝ ǝlbǝg tǝghǝrǝna, vǝghaana. ");
INSERT INTO glwl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Tǝhalakwa ciyavant nǝ Yesu ma gǝtlaha, kaa dzamnadzamǝg kǝ mbǝrzahaan kǝ dǝgiti tagga nǝ Yesu, kaa fadghǝr kǝ iitǝr tǝ ǝlbǝga Daadamazhigǝl vindavindana, ard ǝlbǝgahi taggada Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Sarta kwandza ma Wurshalim nǝ Yesu mbakyarvad haarakǝssa dzava hǝnnyaha, uudaha baɗyaka fardǝghǝrǝtfǝg tǝ iin mbakyarvad garava dǝgaha jappǝri nǝghara nǝ iitǝr kwa ɓag nǝ-iina. ");
INSERT INTO glwl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Hayatǝrǝt bi nǝ Yesu dǝ iitǝr biya, aɗaba sǝrgasǝrg kǝ dǝgitahi ma ǝrviɗmahuɗa uudah baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Maay wa tagardatag kǝ ǝlbǝg tǝghǝr kǝ uuda dǝshig kǝ iin biya, aɗaba sǝrǝgasǝrǝg kǝ dǝgit ma ǝrivǝɗ uuda. ");
INSERT INTO glwl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ndza mǝng nǝ zhiila Farisiyin ɗaagaan Nikodimus, pal ma tlǝvuukwa Yahudaha. ");
INSERT INTO glwl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kwanǝn kǝ uuda sǝvsa vak Yesu kavǝɗɗa, amaa, “Dadda tsagga dǝgita, kǝm sǝrgasǝrǝg taakiya agha dadda tsagga dǝgit kwa ɓǝladi nǝ Daadamazhigǝla, aɗaba maay wa ɓagnaɓag kǝ kwanahaan kǝ dǝgit biya bamma daddakwa ǝmtaɗ nǝ Daadamazhigǝl dǝvakaiya.” ");
INSERT INTO glwl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Kaa ngugarangug kǝ Yesu taakiya, “Bak jiira wan tagaktaga, maay wa dǝgaadǝg damma tlǝkǝssǝra Daadamazhigǝl biya, bamma gwiya yavayiga.” ");
INSERT INTO glwl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Kaa ndavgarundavǝg nǝ Nikodimus kǝ Yesu taakiya, “Da gwiya yaav ndar nǝ uud ma nalnǝg kǝ malahi? Gwiya daadamma huɗɗa babbaan da yiva kǝ dǝga bunii?” ");
INSERT INTO glwl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Aiyam nǝ Yesu taa kǝ iina, “Bak jiira, ǝn tagaktagga, maay wada dǝggaadǝg damma tlǝkǝssǝra Daadamazhǝggǝl biya, bamma gwiya yavayig tǝdvad yuwa ard shǝdkwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Uuda dǝgshiga yaba uud nǝ-iin kalti, akwama yaayig nǝ shǝɗkwa Daadamazhigǝl kǝ uuda, kwah kǝ-uuda daba ǝmtaɗ dǝ shǝɗkwa. ");
INSERT INTO glwl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Aa nali kǝ dǝga jappǝr vakagh wanaa taggak nai taakiya, ‘Barari bamma gwiya yakurayig nǝ-uud biya.’ ");
INSERT INTO glwl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Fǝɗa dagal da vavaki naag nǝ iina, agha cingaciing kǝ tlaavaana, bakǝvakwaha agha tagdai kǝ vakavaki aa sǝgga dǝ iin biya bi vavaki dagal nǝ-iin biya. Bandkwah dlaɓa agha tagdai kǝ ɗuuli yav nǝ uud tǝdvad shǝɗkwa Daadamazhigǝl biya.” ");
INSERT INTO glwl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kaa ndavgaru ndavǝg nǝ Nikodimus kǝ Yesu taakiya, “Da dzǝggaar ndar wan kǝ dǝgitahi?” ");
INSERT INTO glwl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ngal nguggarangug kǝ Yesu amaa, “Kǝgh agha dadda tsagga dǝgit maamaala ma Israˈala, gwaastǝn nǝghaakai kǝ dǝgitahaan biya? ");
INSERT INTO glwl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Bak jiira ǝn tagaktagga, dǝgiti kǝm sǝrga nǝmnd wa kǝm tagkur nǝmnda, ard dǝ dǝgiti nǝghamnda nǝmnda, bakǝvakwaha lamwalǝg kǝ haigant dǝgiti tagamndkur nǝmnda. ");
INSERT INTO glwl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tagankurtag kǝ ǝlbǝg tǝghǝr kǝ dǝgaha duniya, famdǝghǝrǝt biya, am da fǝdghǝrǝt ndar kaci akwama taggankurtag kǝ dǝggit tǝghǝr kǝ dǝgaha ghǝrazhǝggǝli? ");
INSERT INTO glwl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Maay wa tapghani dagat dama ghǝrazhǝggǝl biya ba Zǝra Uud pal wa sahi ma ghǝrazhǝggǝla.” ");
INSERT INTO glwl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Band kwa dzǝgghant nǝ Muus kǝ ghavala vǝrzhagan ma tǝghala, Zǝra-uud ndakwi barari dzǝgvanta. ");
INSERT INTO glwl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Baɗǝm dadda kwa fǝdghǝrǝtfǝg tǝ-iina, tlǝkǝnatlǝg kǝ shifǝgga damma zǝrazǝra. ");
INSERT INTO glwl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Waighantwaig Daadamazhigǝl kǝ duni ba vaivaiya vǝlda kǝ zǝraan pal ba nǝ iina, baɗǝm dadda kwa fǝdghǝrǝtfǝg tǝ iina da maay ǝmtsǝg biya, da tlǝknatlǝg kǝ shifǝgga tangw damma zǝrazǝra. ");
INSERT INTO glwl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ɓǝladi bi nǝ Daadamazhǝggǝl kǝ zǝraan damma duni kwakyarvad ghazǝna kǝ duni biya, ɓǝladi kwakyarvad tlǝkkǝna nǝ duni kǝ katǝg tǝdvad iina. ");
INSERT INTO glwl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Baɗǝm nǝ dadda kwa fǝdghǝrǝtfǝg tǝ Zǝra Daadamazhigǝla, maay da ghazav biya. Dlaɓa baɗǝm nǝ dadda kwa lawalǝg kǝ fadghǝr tǝ iina, ghazaghazana, aɗaba fadghǝrǝt bi nǝ-iin tǝ ɗaaga Zǝra Daadamazhigǝl pal ba nǝ-iinǝn biya. ");
INSERT INTO glwl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kwakyarvad kwan wa tǝghara nǝ Daadamazhigǝl kǝ shari kǝ uudaha. Paraka sǝghawisǝg saama duniya, bakǝvakwaha uudaha ar waiya gurtl dlakulǝva paraka, aɗaba tlǝra kǝlaadǝr war ɓag nǝ-iitǝra. ");
INSERT INTO glwl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Baɗǝm nǝ dadda ɓa kǝlaadǝra naabi kǝ parakǝn biya, maay vaan sagau sa tǝvǝgh kǝ parakiin biya, haik kǝ marazha saggal kǝ tlǝrahaana. ");
INSERT INTO glwl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Dadda kwa ɓa dǝga jiira sagau savak kǝ parak, kiyava nǝghǝva-nǝghǝg bat ɓalaɓal taakiya dǝgiti ɓag nǝ-iina ɓag bad mǝlgarumǝlga Daadamazhigǝl.” ");
INSERT INTO glwl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tǝhala kwaha, kaa ba dagal kǝ Yesu ard mbǝrzahaan damma larda Yahudiya. Zǝlarmazǝlg ar ba ǝmtaɗ vaakwah ɓagtǝr tsuufǝg kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yuhwan dlaɓa ndza tsuufǝg ma Ainun hǝrǝz dǝ Salim aɗaba mǝng nǝ yu ba ɗyak vaakwaha. Uudaha ar sahasagawa sa vakaana kaa ɓagtǝrɓag kǝ iin kǝ tsuufǝga. ");
INSERT INTO glwl_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Dzǝghaardzǝg nǝ wan lakuti ɓǝlav nǝ Yuhwan ma guda bǝrfina. ");
INSERT INTO glwl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kaa ciigǝtciig ka gajau ma taataka mbǝrzaha Yuhwan ard zhiila Yahudaha tǝghǝr kǝ bara vǝgha lakwti kǝ ɓa kwatǝnahǝra. ");
INSERT INTO glwl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kaa dagau kǝ mbǝrzahǝn da vak Yuhwan am nǝ iitǝr taa kǝ iina, “Dadda tsagga dǝgita, uudanǝn ndzam ǝmtaɗ nǝ uuram kilga zaagha Yudana, kwa ba kǝgh dǝ ghǝragh ndakwani vǝlghǝdavǝlǝg kǝ shiid tǝghǝr kǝ-iin taakiya iin Kǝristi, wai nǝ-iin ɓagar tsuufǝg kǝ uudaha, aanji ba war daggau da vakaana.” ");
INSERT INTO glwl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kaa ngwanggug nǝ Yuhwana taakiya, “Maay wa tlǝknatlǝg aanji ndau biya, bamma vǝlgardi nǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ghǝravaru ndakwani am shidahara aɗaba taganatag taakiya, ‘Kai bi nǝ Kǝristi biya, ɓǝlakutɓǝlǝg nǝ uud lakuti saay nǝ iina.’ ");
INSERT INTO glwl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Daddakwa kǝsguu ghuula, iin nǝ zhiila ghuula. Tsaghwa zhiila ghuula paka ba taakiya maa cinnga kǝ kungya zhiila ghuula. Dlaig ba vaivai akwama cingngacing kǝ ghaiya zhiila ghuula. Mbakyarvad kwana reghǝt-reghǝg nǝ dlaigara aɗaba sahisǝg nǝ zhiila ghuula.” ");
INSERT INTO glwl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Mbakyarvad kwaha barari kǝ uudanǝn fǝgara ba ndangǝra, kai dlaɓ ǝn gulǝg dǝ gulǝga. ");
INSERT INTO glwl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Uudi sahi ma ghǝrazhigǝla juujig kǝ uudah baɗǝmma. Uudi sal ma duniya ba dǝga duniya, dlaɓa tag band uudi aasǝgal ma duni kǝ ǝlbǝga. Uudi sahi ma ghǝrazhigǝla juujig kǝ uudah baɗǝm. ");
INSERT INTO glwl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Taa dǝgitahi cinngha nǝ iin ard dǝgiti nǝgha nǝ iina, bakǝvakwaha maay wa haighanthaig dǝ ǝlbǝgaan biya. ");
INSERT INTO glwl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Baɗǝm daddakwa haighanthaig kǝ ǝlbǝgaana, haighanthaig taakiya dadda jiir nǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Aɗaba kwa ɓaladi nǝ Daadamazhigǝlna, ǝlbǝga Daadamazhigǝl wa tagga nǝ-iina, aɗaba vǝlgharvǝlǝg nǝ Daadamazhigǝl kǝ shǝɗkwaan kwa maay nǝ ghalaan biya. ");
INSERT INTO glwl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Waigaan nǝ Daad kǝ Zǝraana, vǝlgharvǝlǝg kǝ dǝgitah badǝm damma dǝvaana. ");
INSERT INTO glwl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Baɗǝm dadda kwa fadghǝrǝfǝg tǝ Zǝriina, dǝ shifǝga damma zǝrazǝra. Baɗǝm daddakwa naay kǝ zǝriin biya, tlǝkna bi kǝ shifǝg biya. Da ɗiigaan Daadamazhigǝl kǝ ǝrviɗmahudaan tǝ iina. ");
INSERT INTO glwl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Sǝrghaakasǝrǝg nǝ Yesu taakiya cinngaracinng nǝ Farisiyah taakiya ɓagtǝr tsuufǝg nǝ Yesu kǝ-uudaha, dlaɓa tlǝkkǝnatlǝg kǝ mbǝrzah juujig dǝga Yuhwana. ");
INSERT INTO glwl_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Bakǝvakwaha, Yesu kataghǝraan bi wan ndza ɓagatǝr tsuufǝg kǝ uudah biya, ndza mbǝrzahaana.) ");
INSERT INTO glwl_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Aɗabadkwaha, kaa ɗugarsɗuug nǝ Yesu kǝ haaya Yahudi, kaa gwiya damma haaya Galili kǝ-iina. ");
INSERT INTO glwl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Nalnǝg kǝ barari kǝ Yesu ta haaya Samariya. ");
INSERT INTO glwl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kaa daas kǝ-iin damma kǝsiin ma Samariya kwa ɗahav dǝ Saikar. Kwanǝn kǝ kǝsa ba hǝrz dǝ guhǝn vǝlghar nǝ Yakub kǝ zǝraan Isuvu ba wura. ");
INSERT INTO glwl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Uuva Yakuba ndza vaakwaha, dlaba kuɗɗalkuɗǝg nǝ Yesu mbakyarvad dǝ dagala, cǝhura kǝ iin tǝ ghaiya uuviina. Kwanǝnna dzǝghaar dǝ vaci tǝghǝra. ");
INSERT INTO glwl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kaa sagau kǝ uusiina, dǝghwa Samariyah sa ga yuwa. Am nǝ Yesu taa kǝ uusiina, “Kwats yagh kǝ yuwa hǝɓǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Makwahiin kǝ sarta, mbǝrzaha Yesu daral bawur da sǝgwa dǝgzǝg ma huɗa kǝsa. ");
INSERT INTO glwl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Aiyam nǝ uusa Samariyahǝn taa kǝ Yesu, “Kǝgha agha zhiil Yahuda, kai kwana ǝn uusa Samariyah agha ghallǝg ndar kaci kǝ yuwa hǝɓɓǝg vakari?” Aɗaba Yahudah ard Samariyaha ar nahakǝv biya. ");
INSERT INTO glwl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ngugharangug nǝ Yesu amaa, “Akwamaghaa sǝrgasǝrǝg kǝ gyagyaana na Daadamazhǝggǝla, ard daddakwa ghala yuwa hǝɓǝg vakaghǝna, maa ghalǝghaghallǝg kǝ iina, da vǝlakakvǝlǝg kǝ yu kwa da vǝlak shifǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Aiyam nǝ uusǝn taa kǝ Yesu, “Dadda ndannga, tiidl ndakwi maay vakagh biya, uuvǝn ndakwi ba tlaɗɗa, agha da tlǝkkǝna mǝr kaci nǝng kǝ yuwǝn kwa vǝla shifǝg ni? ");
INSERT INTO glwl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jighaarajig nǝng kǝ daadamnd Yakuba, kwa ɗuwakǝmndars uuviina? Ba iin dǝ ghǝraana, ard zarhaan, baz almanahaan hǝɓaruhǝɓɓǝg kǝ yu ma vakaiya?” ");
INSERT INTO glwl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Am nǝ Yesu taa kǝ iina, “Baɗǝm dadda kwa hǝɓǝguu kwanǝn kǝ yuwa, gwiya tsǝgaan nǝ andǝla ");
INSERT INTO glwl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Aɗaba baɗǝm dadda kwa hǝɓǝguu yuwi ǝn da vǝlgar naiya, maadlai gwiya tsǝgaan nǝ andǝl ba dǝm biya. Yuwǝn ǝn da vǝlgar naina da ndzǝga bamma vǝghaan band njamar kwada za vukw dǝ kǝlga, nal kǝ shifǝga tangw damma zǝrazǝr kǝ-iina.” ");
INSERT INTO glwl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Aiyam nǝ uusǝn taa kǝ iina, “Dadda ndannga, kwats kǝ yuwiina, haik gwiya njikwanjiig andǝl kǝskaiya, dlaɓa haik gwiya saggau kǝskai da gayu vaakwana.” ");
INSERT INTO glwl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Aiyam nǝ Yesu taa kǝ iina, “Dǝg ɗahantɗahǝg kǝ zhiilagh sa vaakwana.” ");
INSERT INTO glwl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kaa ngwangug kǝ uusiin aiyama, “Maay nǝ zhiilar biya.” Am nǝ Yesu taa kǝ iina, “Bak jiira agha maay dǝ zhiil biya, ");
INSERT INTO glwl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","dǝgiti agha tagda nǝnngna ba jiira, aɗaba zaalah dlǝɓ wa kǝsghu nǝnnga, kwam ǝmtaɗ nǝ uuram ndakwana zhiilagha biya.” ");
INSERT INTO glwl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Aiyama taa kǝ Yesu, “Dadda ndannga, man tlǝg nai agha tlayannga. ");
INSERT INTO glwl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Daadijahamnd ɓagararnǝsɓag kǝ kwatnahǝr kǝ Daadamazhigǝl tǝ kwanǝn kǝ aghwna. Kuram Yahudaha am taakiya bamma ɓagvar ma Wurshalim kwatnahǝr kǝ Daadamazhigǝla awaram nǝ uurama.” ");
INSERT INTO glwl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Kaa ngwarangug nǝ Yesu taakiya, “Uusǝn, fǝdghǝrǝtfǝg tǝ dǝginǝn ǝn tagak naina, aɗaba da sagau nǝ sart kwada maadlai ɓagvar nǝ kwatnahǝr kǝ Daada tǝ kwanǝn kǝ aghwǝn aanji ma Wurshalim biya. ");
INSERT INTO glwl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kuram uudaha Samariya am ɓagar kwatnahǝr kǝ dǝgiti am sǝrga bi nǝ-uuram biya, kǝmnd Yahudaha, kǝm ɓagar kǝ Daadamazhigǝli kǝm sǝrga nǝmnd kǝ kwatnahǝra, aɗaba katǝg sǝghal tǝdvad Yahudaha. ");
INSERT INTO glwl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mǝng sart da sagauwa, bandakwan ndakwani ɓagaaɓaga, lii ɓa kwatnahǝra jiira arda ɓaggar kwatnahǝr kǝ Daad ma Shiɗǝkw Daadamazhigǝla ard jiira, aɗaba, hwulfaatǝr wa gatǝg nǝ Daad kǝ ɓagarnǝs kwatnahǝra. ");
INSERT INTO glwl_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Daadamazhigǝl Shiɗǝkw nǝ-iina, lii ɓagar kwatnahǝr dlaɓa barari ar ɓagar ma Shiɗǝkwa ard jiira.” ");
INSERT INTO glwl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Am nǝ uusiin taa kǝ Yesuwa, “Ən sǝrgasǝsǝrg taaki da saay nǝ Tlǝkatǝg kwa ɗahav dǝ Kǝristi. Akwama da sahisǝga da tagkǝmndtag kǝ dǝgitah baɗǝmma.” ");
INSERT INTO glwl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Am nǝ Yesu taa kǝ uusǝna, “Kaiyin ǝn taaghai dǝ kǝghna, ba kai nǝ iina.” ");
INSERT INTO glwl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Bad ghyǝngaghyǝngaan kǝ taa ghaiya, kaa sǝgaasǝg kǝ mbǝrzahaan, kaa ɓa jappǝr kǝ-iitǝr aɗaba tlarara taaghai dǝ uusa. Maay wa ndavgharu kǝ uusiin taakiya, “Auwagha naag nǝng biya?” Bii kwa ndavgharu kǝ-iin taakiya, “Aujilbǝg kǝskǝgh taaghai dǝ uusǝn biya?” ");
INSERT INTO glwl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tǝhala kwah kaa ɗuugarsɗuug nǝ uusǝn kǝ tǝfuwa yuwan vaakwaha, kaa daas kǝ iin damma huɗɗa kǝssa da tagtǝr kǝ uudah taakiya, ");
INSERT INTO glwl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Sawam na vazamvazǝg kǝ uudi aa taguwa dǝgitahi ɓagana naiya baɗǝmma. Mbatak ɓagaɓag iin nǝ Kǝristina?” ");
INSERT INTO glwl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kaa ba sahasagal kǝ uudah ma huɗɗa kǝss da vakavaki dǝ Yesuwa. ");
INSERT INTO glwl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tǝghǝrdǝga ɓa kwan nǝ uuda, kaa ghalla Yesu kǝ mbǝrzahaan taakiya, “Dadda tsagadǝgita, zǝg kaffa.” ");
INSERT INTO glwl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Aiyam nǝ Yesu taa kǝ-iitǝra, “Mǝng nǝ dǝg zǝg vakar kwam sǝrgai nǝ uuram kǝ dǝgit tǝghǝr biya.” ");
INSERT INTO glwl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kaa ndavǝg kǝ mbǝrzahaan ma taatakaatǝr taakiya, “Mǝng nǝ daddakwa sǝgardǝv dǝga zǝg nii?” ");
INSERT INTO glwl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Aiyam nǝ Yesu, “Kaffar iin taakiya ǝn ɓagna kǝ dǝgiti naag daddakwa ɓǝlakwadi kaiya, dlaɓa ǝn ghyǝngna kǝ tlǝraana. ");
INSERT INTO glwl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Abi am tagaan taakiya, tǝmma kyil uufaɗ lakuti kǝ saa dǝ dǝgwai? Wan tagkurtag ciya, vazamvazǝg kǝ dǝgwai tǝhaltǝhǝga, dlaɓa tlaral tlǝg kǝ ghudǝga. ");
INSERT INTO glwl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Dadda ghudǝgaana tlǝkǝnatlǝg kǝ dǝg shǝgaana, dzahgaan dlaɓ kǝ dǝgwai kiyava shifǝga tangw damma zǝrazǝr, kiyava hwaɗag kǝ dadda riig ǝmtaɗ dǝ dadda ghudǝggaana. ");
INSERT INTO glwl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kwakyarvad kwaha, bak jiir nǝ ǝlbǝg dǝghurǝn kwa taga taakiya, ‘Shah dadda kwan riiyaariiga, shah nǝ dadda ghudgaana.’ ");
INSERT INTO glwl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ɓǝlankurǝt da ghuda dǝgiti hǝɓamuubi nǝ uuram kǝ dlaɗa riigaan biya. Uudahi tlǝrǝn wa hǝɓaru dlaɗa, kuram wa za dlaiva dlaɗaatǝra.” ");
INSERT INTO glwl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Baɗyak nǝ uudaha yaa Samariya ma kwahiin kǝ kǝsa, fardǝghǝrǝtfǝg tǝ Yesu mbakyarvad ǝlbǝgǝn kwa tagga nǝ uusǝn taakiya, “Taghwatag kǝ dǝgitahi ɓagana nai baɗǝmma.” ");
INSERT INTO glwl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Saral ba nǝ uudaha Samariyah da vak Yesu, kaa ghalgaan kǝ iitǝr maa ndzan vakaatǝra. Kaa ndzanganzǝg kǝ hǝng buwa. ");
INSERT INTO glwl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Uudah baɗyak fardghǝrǝtfǝg tǝ Yesu mbakyarvad ǝlbǝgahaana. ");
INSERT INTO glwl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tǝhala kwaha kaa tagartag kǝ uudaha Samari kǝ uusǝn taakiya, “Ndakwana famdǝghǝrǝtfǝga, aanji mbakyarvd dǝgiti taghǝda nǝngǝn biya, kǝmnd ndakwi cinngamndacinng bad hyǝmiyamnda, dlaɓa kǝm sǝrgasǝrǝg ba pakat taakiya kwanǝn kǝ uuda, iin wada kata uudaha duniya.” ");
INSERT INTO glwl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tǝhala hǝnng buwa, kaa ciya dagal damma haaya Galili kǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Aɗaba ndza tagadatag nǝ Yesu bad ghǝraan taakiya, “Tlayangnga maay dǝ ndang ma kǝssaan biya.” ");
INSERT INTO glwl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Dagha ba nǝ iin damma haaya Galili, kaa ba dlǝghga-dlǝghǝg kǝ lii ma Galili bad dǝva buwa aɗaba ghǝravaatǝr ndakwani daral da vakka hwaɗaga haara kǝssa dzava hǝnnyah ma Wurshalima, nǝghara nǝghǝg kǝ dǝgitahi ɓagaa nǝ Yesu baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kaa gwiya daas kǝ Yesu damma Kana ma Galili, vakavaki gwighant nǝ iin kǝ yu damma yuwa inabi. Vakwahiina ndza mǝng nǝ uudaniina kwa ɓagar tlǝr kǝ tlǝkǝsa ma Kafarnahum yang bi nǝ zǝraan biya. ");
INSERT INTO glwl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Cinngha ba nǝ uudanǝn taakiya gwiya saghasǝg nǝ Yesu saama Yahudiya damma Galili, kaa dagau kǝ iin da vak Yesu da ghalgaan taakiya maa dagau maa mbǝna kǝ zǝraan kwa tǝ ghǝrdǝgga ǝmtsǝga. ");
INSERT INTO glwl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Am nǝ Yesu taa kǝ iina, “Akwama nǝghamabi kǝ dǝga sǝrǝg ard tlǝraha jappǝr biya, am maay fadghǝr aanji hǝɗikǝn biya.” ");
INSERT INTO glwl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Am nǝ daddakwa ɓagar tlǝr kǝ tlǝkǝsǝn taa kǝ Yesu, “Asǝg naji dagal lakuti ǝmtsǝg kǝ zǝrraa.” ");
INSERT INTO glwl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Am nǝ Yesu taa kǝ iina, “Dǝgaa, da mbǝg nǝ zǝriina.” Fǝdghǝrǝtfǝg nǝ uudanǝn dǝ dǝginǝn taghar nǝ Yesuna, kaa ba daasan kǝ-iina. ");
INSERT INTO glwl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tǝghǝrdǝga daas nǝ iin da hǝnnyaha, kaa fadzaghǝr kǝ iin dǝ kyalǝma kwatnahaana, am nǝ iitǝr taa kǝ iina, “Mbaambǝg nǝ zǝriina.” ");
INSERT INTO glwl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kaa ndavgaan kǝ iin kǝ kalkala sarti fǝgharzha nǝ iin kǝ ngulmǝga. Kaa tagartag kǝ iitǝr taaki, “Dahukwa kalkala karfi palla faciya wa ɗughars fǝɗiina.” ");
INSERT INTO glwl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kaa nǝghǝgaakanǝghǝg kǝ dadda zǝriin taakiya ba kalkala kwahiin kǝ sart wa tagghar nǝ Yesu taakiya, “Da mbǝg nǝ zǝragha.” Ngal fǝdghǝrǝtfǝg nǝ ghwalvǝn ard yahaan baɗǝmma tǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kwana iin nǝ tlǝra jappǝra buwa kwa ɓagaa nǝ Yesu tǝhala kwa ɗughars nǝ-iin kǝ Yahudi kǝ dagal damma Galili. ");
INSERT INTO glwl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tǝhala kwaha, kaa dagat kǝ Yesu damma Wurshalima davaka hwaɗaga haarakǝsa Yahudaha. ");
INSERT INTO glwl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ma Wurshalima, tǝvǝgh kǝ ghaiya guda tughwaha, mǝng nǝ dǝlva kwa ɗahav dǝ Betasda ma ghaiya Yahudaha, tsavarvaara dǝ tsakwamah dlǝɓa. ");
INSERT INTO glwl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ma tsakwamahaan mǝng nǝ lii yang biya narǝtnǝg kǝ hǝnnga mavakaiya ndǝ gulfaha, ard ghurɗikaha ard lii ǝmtsaǝmtsan nǝ vǝgha. Ar paka uushvant nǝ yuwa, ");
INSERT INTO glwl_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","aɗaba kǝ sart kǝ sart sahasagau nǝ zǝr ɓǝlga Yaazhigǝl da uusha yuwiina. Baɗǝm nǝ dadda kwa dǝhi zǝngw damma yuwǝn tǝhala uushgaana, da mbǝg aanji tuuk kwar kǝ kuzahi njǝkǝnjiig baɗɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mǝng nǝ uuda nǝ iin ndza vaakwaha, viigaan kulhǝkǝrɗ tar tǝhǝs ba yang biya. ");
INSERT INTO glwl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nǝgha ba nǝ Yesu hǝnngan vaakwahiina, nǝghaakanǝghǝg taaki zǝlamazǝmǝg tuuk kǝ kwanǝn kǝ kuza, aiyama taa kǝ iina, “Agha naagaan kǝ mbǝga?” ");
INSERT INTO glwl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Am nǝ dadda kuzzǝn taa kǝ iina, “Dadda ndannga, ǝn maay dǝ daddakwa da mǝlgwadmǝlǝg kǝ di damma dǝlvǝn ma sartǝn uushivant nǝ yuwǝn biya. Ma sartǝn ǝn ɓag nai kǝ kǝlla ndzǝɗar kǝ daay damma vakaiya, ba jǝkwaara nǝ uuda.” ");
INSERT INTO glwl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Aiyam nǝ Yesu taa kǝ iina, “Ciiga, kǝssant kǝssǝg kǝ kǝjagh, dǝg dagalagha.” ");
INSERT INTO glwl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Bat vakaitǝvakai, kaa mbǝgambǝg kǝ uudanǝn, kaa kǝsgantkǝsǝg kǝ iin kǝ kǝjaana kaa farzha kǝ dagala. Kwanǝn kǝ dǝgita dzǝghaar davala faciya ngiiga Yahudaha. ");
INSERT INTO glwl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mbakyarvad kwaha am nǝ maalaha Yahudah taa kǝ daddakwa mbavnambǝgna, “Hinana faciya ngiiga kalkalbi kǝskǝgh ɓa tlǝr biya, haiyakant bi nǝ adzahadzah kǝsa kǝjagh biya.” ");
INSERT INTO glwl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kaa ngutǝrangug kǝ uudanǝn taakiya, “Daddakwa mbǝkwii kai wa taggwa taaki kǝssǝg kǝ kǝjagha dǝgdagala.” ");
INSERT INTO glwl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kaa ndavgarundavǝg kǝ-iitǝr taakiya, “Kwar kǝ-uud wa tagak taaki kǝsǝg kǝ kǝjagh dǝgdagalni?” ");
INSERT INTO glwl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Uudanǝn mbavnanǝn sǝrgabi kǝ daddakwa mbǝghani-mbǝg biya, aɗaba mǝng nǝ uudah baɗǝyaka vaakwahiina, zǝgharaazǝg nǝ Yesu ma taataka uudaha. ");
INSERT INTO glwl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tǝhala zǝlam hǝɗiikǝna, kaa tlǝgaratlǝg nǝ Yesu ma vǝgya Daada ma zhigǝla, amaa taa kǝ-iina, “Agha, yagh mbǝghambǝga. Gwiyarzharabi kǝ ɓa haip biya, aɗaba aa gwiya tlǝka bi nǝ dǝgiti ghwaɗ kwa juujig kwanǝn biya.” ");
INSERT INTO glwl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kaa dagal kǝ uudanǝn tagtǝr kǝ maalaha Yahudah taakiya, “Yesu wa mbaghanimbǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mbakyarvad ɓag daghuvala faciya ngiig nǝ Yesu kǝ kwanahaana, kaa fǝgarzhafǝg kǝ maalaha yaa Yahudah kǝ pǝcca ghaiyaana. ");
INSERT INTO glwl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Aiyam nǝ Yesu taa kǝ iitǝra, “Daadar ba kǝlaa hǝng ɓa tlǝra, ghǝravar ndakwi ǝn ɓag band kwaha.” ");
INSERT INTO glwl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kwakyarvad kwanǝn wa fatǝra kǝ maalaha yaa Yahudah kǝ zavukw dǝ gata ɗuula tsa Yesu. Am nǝ iitǝra, “Aɗuug yagh kǝ adzahadzaha ngiigǝn kǝlada nǝ iinǝn biyin ndakwani, ɗa Daadamazhigǝla dǝ daddaana, aɗabad kwaha gǝrra ghǝraan kalkal dǝ Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Am nǝ Yesu taa kǝ iitǝra, “Bak jiira wan tagkurtaga, maay nǝ dǝgiti ɓagnaɓag nǝ zǝriin dǝ ndzǝɗa ghǝraan biya, bamma dǝgiti nǝghǝga nǝ iin kǝ daddaan ɓagaan kalti. Aɗaba baɗǝm nǝ dǝgiti ɓag nǝ daadiin, iin wa ɓag nǝ zǝriina. ");
INSERT INTO glwl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Aɗaba waigaan nǝ daadiin kǝ zǝrana, dlaɓa marghardamarg kǝ dǝgitahi ɓag nǝ iin baɗǝmma. Dlaɓa, da margarmarg baz tlǝrahi juujiig kwanahaan kiyava ɓa jappǝr kǝskurama. ");
INSERT INTO glwl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bandkwa ciig nǝ daad kǝ uudah ma gǝtlaha vǝltǝr kǝ shifǝga, band kwah dlaɓ nǝ zǝriin vǝlgarvǝlǝg kǝ shifǝg kǝ daddakwa waig nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Daad dǝ ghǝraan maay tǝgar shari kǝ uud biya. Vǝlgharvǝlǝg kǝ ndzǝɗa ta shari baɗǝmma damma dǝva zǝraana. ");
INSERT INTO glwl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kiyava fǝgaarafǝg kǝ uudah baɗǝm kǝ zǝriina, bandkwar fǝgaara nǝ iitǝr kǝ Daadiina. Baɗǝm nǝ daddakwa fǝghaarabi kǝ Zǝriin biya, fǝghaarabi kǝ Daadi ɓǝladi iin biya. ");
INSERT INTO glwl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Bak jiira, wan tagkurtaga, baɗǝm nǝ daddakwa cinnga ǝlbǝgara, fǝdghǝrǝtfǝg dlaɓ dǝ daddakwa ɓǝlakwadi kaiya, dǝ shifǝga damma zǝrazǝra. Maay da tǝvar shari biya, dzǝvaadzǝvǝg kǝ ǝmtsǝg damma shifǝgga. ");
INSERT INTO glwl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Bak jiir wan tagkurtaga, mǝng sart da sagauwa, bandakwan ndakwi ɓagaaɓaga, lii ǝmtsaharaǝmtsahǝg arda cinnngacinnng kǝ ghaiya Zǝra Daadamazhigǝla, lii cinngaracinnga arda tlǝkǝnatlǝg kǝ shifǝga. ");
INSERT INTO glwl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Bandkwa gyigyiya shifǝg nǝ Daadna nǝdal dlaɓ kǝ gyigyiya shifǝg kǝ zǝraana, ");
INSERT INTO glwl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Vǝlgharvǝlǝg dlaɓ kǝ ndzǝɗa ta shari aɗaba Zǝra Uud nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ɓagambi kǝ ajappǝra kwanǝn kǝ ǝlbǝg biya, aɗaba da sagau nǝ sarta, baɗǝm nǝ lii ma gǝtlaha ar da cinngacinng kǝ ghaiyaana, ");
INSERT INTO glwl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ar da sagal ma gǝtlaha. Lii ɓagaraɓag kǝ dǝgitah marawa ar da ciiga ar tlǝkǝna kǝ shifǝg damma zǝrazǝra. Lii ɓagara dǝgitahi ghwaɗa, da ghudǝvtǝrda nǝ shariya. ");
INSERT INTO glwl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ən maay ɓa dǝgit tǝdvad ghǝrar biya, ǝn taa shari kǝ uudah bandkwa tagghwa nǝ Daadamazhigǝl taaki ɓaga. Mbakyarvad kwaha shariyara ba kalkala, aɗaba naaga ghǝrarbi wan ɓag nai biya, naaga daddakwa ɓǝlakwadi kaiya. ");
INSERT INTO glwl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Akwama kai wan taa ǝlbǝg tǝghǝr kǝ ghǝrara, ǝlbǝgara da haivant biya. ");
INSERT INTO glwl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mǝng nǝ daddakwa taa dǝgit tǝghǝr kǝskaiya, ǝn sǝrgasǝrǝg dlaɓ taakiya dǝgiti tag nǝ iin ba jiira. ");
INSERT INTO glwl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Am ɓǝlant kǝ uudah davak Yuhwana, iin dlaɓa tagakurtag kǝ jiira. ");
INSERT INTO glwl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Bakǝvakwaha, ǝn maay nai fadghǝr dǝ shiida uuda dǝgshig biya. Ən tagkur mbakyarvad am tlǝkna kǝ katǝga. ");
INSERT INTO glwl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yuhwana ndza kaara jahuramb kwa mbiig ba parakaraka, haiyamanthaig nǝ uuram kǝ cinnga ǝmtakǝra parakaan kǝ dǝga sart hǝɗiikǝna. ");
INSERT INTO glwl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ən mǝng nai dǝ shiid kwa juujig kǝ dǝgiti tagaa Yuhwan tǝghǝr kǝskaiya. Tlǝrahi vǝlghwa nǝ Daadar mana mbasnana, iin wan ɓag naiya. Iitǝr shiidar taakiya Daada wa ɓǝlakwadi kaiya. ");
INSERT INTO glwl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Dlaɓa Daadi ɓǝlakwadi kaiya ba iin dǝ ghǝraan shidara. Tapamnabi kǝ cinnga ghaiyaan biya, dlaɓa tapamnabi kǝ nǝghǝga ndzǝgana huɗvǝgaan biya. ");
INSERT INTO glwl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Əlbǝgaan dlaɓ ndzaabi ma ǝrviɗmahuɗaharu biya, aɗaba famdghǝrǝtbi tǝ dadda kwa ɓǝladi nǝ iin biya. ");
INSERT INTO glwl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Am hǝgaan kǝ shiga ǝlbǝgaha Daadamazhigǝl vindavindana, mam tlǝg nǝ uuram am da tlǝkkǝnatlǝg kǝ shifǝg damma zǝrazǝr ma iitǝra. Kwan kǝ ǝlbǝgaha iin shiid tǝghǝr kǝskaiya. ");
INSERT INTO glwl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Bakǝvakwaha lamwalǝg kǝ sa vakar am tlǝkkǝna kǝ shifǝga. ");
INSERT INTO glwl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Maay nǝ lambar dǝ galga uudah biya. ");
INSERT INTO glwl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ən sǝrkursǝrga, am maay nǝ uuram waiya Daadamazhigǝl ma ǝrviɗyaharu biya. ");
INSERT INTO glwl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Sanhi ma ɗaaga Daadara dlǝghamkwi biya, akwama sǝgǝv ma ɗaaga ghǝraan nǝ uudanna, am dlǝghgaan ba dǝ ǝrviɗmahuɗ pala. ");
INSERT INTO glwl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Am da fǝdghǝrǝt ndarndar kaci tǝ kaiyi am haigara ba dlǝbǝg mataatakaruwa. Am naay kǝ dlǝbgǝn kwa sagal vak Daadamazhigǝl kwa pal ba nǝ iinǝn biya? ");
INSERT INTO glwl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tlatlam bi taaki ǝn da kǝla ghunnjaru vak Daad biya. Mǝng wada kǝla ghunnjaruwa, iin nǝ Muusa, kwam tlǝg nǝ uuram da mǝlkurumǝlga. ");
INSERT INTO glwl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Akwama famdghǝrǝtfǝg tǝ Muusa, maa famdghǝrǝtfǝg tǝ kaiya, aɗaba vindavindǝg Muus tǝghǝr kǝskaiya. ");
INSERT INTO glwl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Haiyamant bi tsau kǝ dǝgiti vinda nǝ iin biya, am da haigant ndar kaci kǝ ǝlbǝgari?” ");
INSERT INTO glwl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tǝhala kwanahaana, kaa dzǝva yuwa haiya Galili kǝ Yesu, kwa ɗahav dǝ Tibariya. ");
INSERT INTO glwl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kaa gatǝgaan kǝ uudah baɗyaka, aɗaba ar nǝghǝganǝghǝg kǝ dǝgaha jappǝri ɓagtǝr nǝ-iin kǝ lii yang biya. ");
INSERT INTO glwl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kaa dagat kǝ Yesu ard mbǝrzahaan damma aghwa ar cahwarana dǝ mbǝrzahaana. ");
INSERT INTO glwl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Hǝrzǝt ba nǝ sarta haarakǝssa dzava hǝnyaha yaa Yahuda. ");
INSERT INTO glwl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Dzǝghant ba nǝ Yesu kǝ ghǝra kaa nǝghǝganǝghǝg kǝ iin kǝ dzahava uudah sagau sa vakaana, kaa ndavgarundavǝg kǝ iin kǝ Filigusa, “Kiyam da sǝgwdaa mǝr kǝ bruudi kwada tlǝtǝrara kǝ uudahaani?” ");
INSERT INTO glwl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ndava kiyava fǝsha Filigus nǝ Yesu, aɗaba sǝrgasǝrǝg kǝ dǝgiti da ɓag nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ngugharangug nǝ Filigus taakiya, “Aanji bruudiya kwaɓa hǝngah tlǝra bariyam dǝrmǝk buwa, tlǝgǝti bi tǝ iitǝr aanji ba hǝɗikǝn hǝɗikǝn biya.” ");
INSERT INTO glwl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Aiyam pal ma mbǝrzahaan kwa ɗahav dǝ Andrawus, zǝra babba Siman Bitrus taa kǝ Yesu, ");
INSERT INTO glwl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Mǝng nǝ zǝriin vaakwan dǝ ɗummba bruudi dlǝɓa kwa ɓagava dǝ ahupiya bale ard kilf buwa. Da tlǝtǝraara mǝr kaci kǝ uudah ɗyak ǝndkwani?” ");
INSERT INTO glwl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Am nǝ Yesu taa kǝ mbǝrzahaana, “Tagamtǝrtag kǝ uudah taaki aa cahwararacahwarga.” Mǝng nǝ kazhakwa ba ɗyak vaakwahiina. Kaa cahwargacahwarǝg kǝ uudaha, ghwalvahi ndzar vaakwaha ar mǝng damma alfu dlǝɓa. ");
INSERT INTO glwl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kaa kǝsgantkǝsǝg nǝ Yesu kǝ ɗuumbaha bruudiina, tǝhala tagar uus kǝ Daadamazhigǝla, vǝlatǝrvǝlǝg kǝ digiti da tlǝtǝraaratlǝga. Ɓagaa band kwah dlaɓ dǝ kilfa. ");
INSERT INTO glwl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tǝhalakwa zaru nǝ uudah dlaɓa tlatǝrtlǝga, amaa taa kǝ mbǝrzahaana, “Dzahamantdzahǝg kǝ ghwadgahaan kwa tǝmgatǝmgani aada badzalbi bagya biya.” ");
INSERT INTO glwl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kaa dzahghantdzahǝg kǝ mbǝrzah kǝ tǝmga ghwadgahaa bruudi dlǝɓǝn kwa jatruu kǝ zǝga kwa ɓagava dǝ ahupiya bale, kaa righantrighǝg kǝ iitǝr kǝ alǝghw kǝlawa tar buwa. ");
INSERT INTO glwl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nǝghara ba nǝ-uudah kǝ dǝga jappǝra sǝrgǝn ɓagaa nǝ Yesu na, aiyam nǝ iitǝra, “Ba pakat iin nǝ tlayangǝn kwa kiyam pakkǝg nǝmyam kǝ saayan sama duniya.” ");
INSERT INTO glwl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nǝghaaka ba nǝ Yesu taaki ar na ɓa dabariya nǝdal kǝ tlǝkǝs bad ndzǝɗa, kaa ghǝlvalghǝlǝg kǝ iin ba daghuvaan damma aghwa. ");
INSERT INTO glwl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ɓagaa ba nǝ hwaasa, kaa sii samma dǝlva kǝ mbǝrzaha Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ma kwahiina kǝ Sarta dǝmdǝg nǝ gurtla, Yesu dlaɓa sǝvbi sa vakaatǝr ndan biya. Kaa dǝgǝmdǝg kǝ mbǝrzah damma pɛra yuwa kiyava dzǝva dagal damma Kafarnahum. ");
INSERT INTO glwl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kaa fǝgarzhafǝg kǝ fǝɗ ɓǝlǝg bad ndzǝɗa, kaa ghubǝɗǝg kǝ yuwa. ");
INSERT INTO glwl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tǝhalakwa darant nǝ iitǝr kǝ dǝga mil hǝkǝrɗa bi uufaɗa, kaa nǝghǝganǝghǝg kǝ iitǝr kǝ Yesu dagal tǝ yuwa sagau sa tǝvǝgh kǝ pɛra yuwiina, Kaa gǝdzǝgǝtgǝdzǝg kǝ iitǝra ");
INSERT INTO glwl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Aiyam nǝ Yesu taa kǝ iitǝra, “Gǝdzam biya, ba kaiya.” ");
INSERT INTO glwl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kaa haiganthaig kǝ iitǝr ar ɓǝlarna kǝ damma pɛrayuwa caaricaari kaa tsugwatsugw kǝ pɛrayuwǝn vakavaki ar dagal nǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Cagaa ba nǝ kǝsa kaa nǝghǝgaakanǝghǝg nǝ kyalǝma uudahaanǝn ndzar faɗǝga tǝghaiya gardza dǝlva taakiya mbats ndza ba pal nǝ pɛrayu ndza vaakwaha, dlaɓa nǝgharaakanǝghǝg taakiya dagha bi nǝ Yesu damma pɛrayu ǝmtaɗ dǝ mbǝrzahaan biya, daral ba daghuvaatǝr nǝ mbǝzahaana. ");
INSERT INTO glwl_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ndza mǝng nǝ pɛrayuwah kwa saragha ma Tibariya ar ghacan hǝrǝz dǝ vakavaki zar nǝ uudah kǝ bruudi tǝhala kwa taghar nǝ Yesu kǝ uus kǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nǝgharaaka ba nǝ uudah taakiya Yesu ard mbǝrzahaan ar maay vaakwah biya, ka dǝgǝmdǝg kǝ iitǝr damma pɛrayuwah kaa dagal kǝ iitǝr damma Kafarnahum da gata Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tlararaa ba nǝ iitǝr tǝ ghyaba kwah kǝ ghaiya dǝlva, am nǝ iitǝr taa kǝ iina, “Dadda tsaga dǝgita, agha sǝgaa hǝr sa vaakwani?” ");
INSERT INTO glwl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Aiyam nǝ Yesu taa kǝ iitǝra, “Bak jiira wan tagkurtaga, am gatǝkwa mbakyarvad dǝga sǝrgi ajappǝri nǝghama nǝ uuram biya, am gatǝkwa mbakyarvad zaamuzǝg kǝ bruudi tlakurtlǝga. ");
INSERT INTO glwl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Hǝɓam bi kǝ dlaɗ tǝghǝr kǝ gata kaf kwa badzǝg biya, hǝɓamhǝɓǝg kǝ dlaɗ tǝghǝr kǝ dǝgazǝg kwa zǝlmazǝlǝg tangw damma zǝrazǝra. Kwan kǝ dǝgazǝg wada vǝlkur nǝ Zǝra Uuda. Aɗaba Zǝra Uud wa vǝlghar nǝ Daad Daadamazhigǝl kǝ ndzǝɗa ɓa kwanahaana.” ");
INSERT INTO glwl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kaa ndavgaru-ndavǝg nǝ uudah kǝ Yesu taakiya, “Auwa kǝmnda ɓag nǝmd kiyava ɓa tlǝrahi naag nǝ Daadamazhigǝli?” ");
INSERT INTO glwl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Kaa ngutǝrangug kǝ Yesu taakiya, “Wan nǝ tlǝri naag nǝ Daadamazhigǝla, famdǝghǝrǝtfǝg tǝ daddakwa ɓǝladi nǝ-iina.” ");
INSERT INTO glwl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kaa ndavgaru-ndavǝg nǝ uudahiin kǝ Yesu am nǝ-iitǝra, “Kwarci kǝ garava dǝgasǝrg wagha da ɓag nǝng kiyava fadghǝr kǝskǝmnd tǝ kǝghi? Au wagha da ɓag nǝngi? ");
INSERT INTO glwl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Daadijahamiyam zaruuzǝg kǝ manna ma tǝghala, band kwa vinndava ma kakkaɗa Daadamazhigǝl taakiya, ‘Vǝlatǝrvǝlǝg kǝ dǝgazǝg siima ghǝra zhigǝl kiyava zǝgga.’ ” ");
INSERT INTO glwl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tǝhala kwaha, kaa ngutǝrangug kǝ Yesu amaa, “Bak jiir wan tagkurtaga, Muus bi wa vǝlakurdi bruudi sii ma ghǝrazhigǝl biya, Daadar wa vǝlakurdi bruudiya jiir sii ma ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Aɗaba bruudiya Daadamazhigǝl iin bruudi kwa saay ma ghǝrazhigǝla vǝlgar shifǝg kǝ duniya.” ");
INSERT INTO glwl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Kaa am nǝ-iitǝr taa kǝ-iina, “Dadda ndangnga, ndzaa ba vǝlkǝmnd-vǝlǝg kǝ bruudiyin bakǝlaa hǝngnga.” ");
INSERT INTO glwl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kaa ngutǝraangug kǝ Yesu taakiya, “Kai nǝ bruudiya shifǝga, dadda kwa sǝgǝv sa vakar maadlai wai da njǝkǝn-njiig biya. Dadda kwa fadghǝr tǝ kaiya maadlai nǝ andǝl da njǝkǝn-njiig biya. ");
INSERT INTO glwl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bandkwa tagankur naiya, nǝghamkwanǝghǝga, bakǝvakwaha am lǝwa kǝ fadghǝr tǝ kaiya. ");
INSERT INTO glwl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Baɗǝm lii vǝlgwa nǝ daada, ar da sagau sa vakara, daddakwa sǝgǝv sa vakara dlaɓa, ǝn maay lagwan biya. ");
INSERT INTO glwl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sanhi sa ɓa dǝgiti naag ghǝrar bi nai mazhigǝl biya, sanhi mbakyarva ɓa dǝgiti naag daddkwa ɓǝlakwadi kaiya. ");
INSERT INTO glwl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Naaga daddakwa ɓǝlakwadi kai iin takiya, aa zannai aanji pal mali vǝlghwa nǝ-iin biya, ǝn ciitǝrǝt davala ghyǝngnga duniya. ");
INSERT INTO glwl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Aɗaba kwan nǝ naaga Daadar taakiya, baɗǝm nǝ daddakwa vazza dat Zǝrna, dlaɓa fadghǝr tǝ iina, da tlǝkkǝnatlǝg kǝ shifǝga damma zǝrarǝra, kai dlaɓa ǝn da ciigaan davala ghyǝngnga duniya.” ");
INSERT INTO glwl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Kaa zavaghai kǝ Yahudah tǝghǝr kǝ Yesu aɗaba tagada taakiya, “Kai nǝ bruudiyin sahi ma ghǝrazhigǝlna.” ");
INSERT INTO glwl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Am nǝ-iitǝra, “Abi Yesu, zǝra Isuvu, bakwa kǝm sǝrga nǝmnd kǝ daddaana ard babbaanǝn ɗang? Tag ndar kaci taaki, ‘Sanhi ma ghǝrazhigǝli?” ");
INSERT INTO glwl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Am nǝ Yesu taa kǝ iintǝra, “Ɗuwamarsɗuug kǝ zavaghai ma taatatakaruwa. ");
INSERT INTO glwl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Maay wa dzǝgwantdzǝgw sa vakar biya, bamma sǝdda nǝ Daad kwa ɓǝlakwadi kaiya, ǝn da ciyant nai kǝ uudanǝn davala ghyǝgnga duniya. ");
INSERT INTO glwl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Vinndava-vinndǝg ma kakkaɗa tlaiyangngah taakiya, ‘Baɗǝmaatǝr da tsagtǝr ba nǝ Daadamazhigǝla.’ Baɗǝm daddakwa cingngharnu-cingng kǝ Daadiina dlaɓa tsagaan vakaana, da sagau sa vakara. ");
INSERT INTO glwl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Maay wa ɗǝyit gi tǝ Daad biya bamma daddakwa sahi vak Daadamazhigǝla, ba iin pal wa nǝghgha Daadiina. ");
INSERT INTO glwl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Bak jiir wan tagkurtagga, baɗǝm daddakwa fadghǝrǝt-fǝga, mǝng dǝ shifǝga damma zǝrazǝra. ");
INSERT INTO glwl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kai nǝ bruudiya shifǝga. ");
INSERT INTO glwl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Dadijaha dadijaharu zaruzǝg kǝ mana ma tǝghal, bakǝvakwaha ruwararuuga. ");
INSERT INTO glwl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Wan nǝ bruudi kwa sii ma zhigǝla, baɗǝm dadda kwa zǝguu bruudina, maay ǝmtsǝg biya. ");
INSERT INTO glwl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Kai nǝ bruudiya shifǝg kwa sahi ma ghǝrazhigǝla. Baɗǝm dadda kwa zǝguu bruudina, tlǝknatlǝg kǝ shifǝga damma zǝrazǝra. Kwan kǝ bruudiya vǝghara, kwan da vǝlda nai kiyava tlǝkkǝna shifǝg kǝ uudaha duniya.” ");
INSERT INTO glwl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Kaa fǝgarzhafǝg kǝ Yahudah kǝ ɓala agajau ma taatakaatǝr ba dladlaɗa, taakiya, “Vǝlkiyam ndar nǝ uudanǝn kǝ tluwa vǝghaan kiyava zǝggi?” ");
INSERT INTO glwl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Aiyam nǝ Yesu taa kǝ-iitera, “Bak jiijiira ǝn tagkurtaga bamma zamuzǝg kǝ tluw Zǝra Uuda, dlaɓa am hǝɓɓu kǝ avǝzaana, am maay dǝ shifǝg ma kuram biya. ");
INSERT INTO glwl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Baɗǝm nǝ daddakwa zǝguu tluwa vǝghara, hǝɓɓu dlaɓ kǝ avǝzara, mǝng dǝ shifǝgga damma zǝrazǝra, ǝnda ciigaan davala ghyǝngnga duniya. ");
INSERT INTO glwl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Aɗaba tluwa vǝghara iin nǝ dǝgazǝga jiirjiira. Avǝzar ndakwi iin nǝ dǝga hǝɓɓǝga jiirjiira. ");
INSERT INTO glwl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Baɗǝm nǝ daddakwa za tluwa vǝghara, dlaɓa hǝɓɓǝgaan kǝ avǝzara, ndzǝga ma kaiya, kai dlaɓ ma vǝghaana. ");
INSERT INTO glwl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bandkwan ndzǝgan nai mbakyarvad Daada dadda shifǝg kwa ɓǝlakwadi kaiya, bandkwah dlaɓ nǝ daddakwa zǝg tǝ kaiya, da ndzǝga mbakyarvad kaiya. ");
INSERT INTO glwl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kai nǝ bruudiyin sahi ma ghǝrazhigǝlna. Daadijaha daadijaharu zaruzǝg kǝ mana, bakǝvakwaha ruwararuuga, baɗǝm nǝ daddakwa zǝguu kwanǝn kǝ bruudiya da ndzǝga bad shifǝga damma zǝrazǝra.” ");
INSERT INTO glwl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tagada ma Kafarnahum nǝ Yesu kwan kǝ ǝlbǝg ma sarta kwandza tsaga dǝgit ma guda dzǝgwazhigǝl Yahudaha. ");
INSERT INTO glwl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Cinngara ba nǝ-iitǝr ndǝkwana, kaa ba taggaan kǝ kyalǝma mbǝrzahaan taakiya, “Kwanǝn kǝ ǝlbǝga mblemlen kǝ nǝghǝgaakanǝhǝga, warwa haiganthaigi?” ");
INSERT INTO glwl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nǝghǝghaaka ba nǝ Yesu taakiya zavaghai nǝ mbǝrzahaan tǝghǝr kǝ ǝlbǝgna, kaa amaa taa kǝ-iitǝra, “Badzakurda-badzǝg kǝ ǝrviɗy nǝ wanǝn kǝ ǝlbǝga? ");
INSERT INTO glwl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Da ndzǝga ndar kaci nǝ ǝrivǝɗmahuɗaru akwama nǝghamanǝghǝg kǝ Zǝra uuda dagat da vakavaki sahi nǝ-iini? ");
INSERT INTO glwl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Shiɗǝkw iin wa vǝla shifǝga. Maay nǝ vǝgh dǝ ndzǝɗa ɓa aanji ndau biya. Əlbǝgahaan tagankur naina sǝghal vak Shiɗǝkwa dlaɓa vǝla shifǝga. ");
INSERT INTO glwl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mǝng nǝ kyalmaruwi fardghǝrǝt biya.” Bamma facta sǝrgasǝrg nǝ Yesu kǝ lii fardghǝrǝt bi tǝ-iin biya, sǝrghasǝrǝg dlaɓ kǝ daddakwa da vǝlgaana. ");
INSERT INTO glwl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kaa gwiya tagaan kǝ Yesu taakiya, “Iin wa tagankur naiya, ‘Maay wa dzǝgwantdzǝgw sa vakar biya, bamma vǝlgharvǝlǝg nǝ Daad kǝ ndzǝɗa.’ ” ");
INSERT INTO glwl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tǝhala ǝlbǝgahaan taga Yesu na, kaa gwiya dat hal kǝ mbǝrzahaan ba ɗyak ar ɗuwars dlaɓa ar lǝwa kǝ gwaiyav ǝmtaɗ dǝ-iina. ");
INSERT INTO glwl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kaa ndavtǝrundavǝg nǝ Yesu kǝ kǝlawa tar buna taakiya, “Baz kuram ndakwani amnaa dagalaruwa?” ");
INSERT INTO glwl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Kaa ngwangug nǝ Siman Bitrus taakiya, “Yaazhigǝla, kǝmnda vak wari? Kǝgh wagha taa ǝlbǝga vǝla shifǝga tangw damma zǝrazǝra. ");
INSERT INTO glwl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Famdghǝrǝtfǝg nǝmnd dlaɓa kǝm sǝrgasǝrǝg taakiya, kǝgh Caccuwanacaccuwananǝn kwa sahi vak Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kaa ngngwagug nǝ Yesu amaa, “Dzǝrankuraakadzǝrga baɗǝmaru kǝlawa tar buna, bakǝvakwaha pal ma kuram shatanaha uuda.” ");
INSERT INTO glwl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tag tǝghǝr kǝ Yahuda, zǝra Siman Iskariyoti, aɗaba iin wada vǝla Yesu, bakǝvakwaha pal nǝ-iin ma lii kǝlawa tar buna. ");
INSERT INTO glwl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tǝhalakwaha kaa gwaivagwaig kǝ Yesu ma haaya Galili, naha bi kǝ damma haaya Yahud biya, aɗaba ar gata ɗuula tsǝgaan nǝ maalaha Yahudah vaakwaha. ");
INSERT INTO glwl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Hǝrzǝt ba nǝ sarta haarakǝssa taha babramaha yaa Yahuda, ");
INSERT INTO glwl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","kaa tagartag kǝ zaraabahaan kǝ Yesu taakiya, “Marawuraana magha dagal damma Yahudiya, kiyava nǝghǝganǝghǝg kǝ mbǝrzahaghi vaakwah kǝ dǝgaha jappǝri agha ɓag nǝnga. ");
INSERT INTO glwl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Abi lii naa sǝrvtǝr ar maay shǝɓa dǝgiti ar ɓag nǝ-iitǝr biya. Nalnǝg tsau taaki agha ɓagaan kǝ kwanahaan kǝ dǝgitaha, agha margaan kǝ ghǝragh kiyava sǝraksǝrg kǝ duniya.” ");
INSERT INTO glwl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Aɗaba aanji zarha babbaan kǝ Yesu ndakwi fardghǝrit bi tǝ iin biya. ");
INSERT INTO glwl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Am Yesu taa kǝ iitǝra, “Ɓagaa bi sartar ndan biya, vakaruwa aanji kwar kǝ sarta, ba kalkala. ");
INSERT INTO glwl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Da ɗuukurǝs bi nǝ duni kǝskuram biya, kai wa ɗuukus nǝ iina. Aɗaba ǝn tagar tlǝraha kǝladǝri ɓag nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Damdǝg nǝ uuram dagal da vaka haarakǝssiina, ǝn maay nai dagal biya, aɗaba ɓagaa bi nǝ sartar ndan biya.” ");
INSERT INTO glwl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tǝhalakwa tagatǝrda nǝ Yesu kwanǝn kǝ ǝlbǝga, kaa ndzǝgandzǝg kǝ iin ndan ma Galili. ");
INSERT INTO glwl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Daral ba nǝ zarha babba Yesu da vaka hwaɗaga haara kǝsna, kaa ba dagal kǝ Yesu tǝhalaatǝr kwal sǝrgasǝrgaatǝra, kwal nǝghǝga kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Kaa gatǝgaan kǝ maalaha Yahudah vaka haara kǝssǝna, ar ndava taaki, “Mǝr nǝ uuda nǝ iini?” ");
INSERT INTO glwl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kaa ba ɗung kǝ uudah mataatakaatǝr vaka dzahavǝn tǝghǝr kǝ Yesu. Kyalǝm ar taakiya, “Uuda jiijiir nǝ iina.” Kyalǝm dlaɓ ar taakiya, “Maaya, abi vala ba uudaha.” ");
INSERT INTO glwl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Maay wa shughana gyi kǝ taaghai tǝghǝr kǝ Yesu tǝ ɓalaɓal biya, aɗaba ar gǝdza maalaha Yahudaha. ");
INSERT INTO glwl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Davǝm ba damma ghadghada haara kǝsna, Kaa daas kǝ Yesu damma vǝgya Daadamazhigǝl kaa farzha kǝ tsagtǝr dǝgit kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kaa ɓa jappǝr kǝ Yahudahi ndzar vaakwah ar ndava taakiya, “Tsaguu ndar nǝ uudanǝn kǝ dǝgit ǝndkwan bakwal dǝgal damma makaranti?” ");
INSERT INTO glwl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kaa ngwangug kǝ Yesu amaa, “Dǝginahaan ǝn tsag naina, dǝgar biya dǝga daddakwa ɓǝlakwaadi kaiya. ");
INSERT INTO glwl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Baɗǝm daddakwa kǝsghaakakǝsǝg kǝ ɓa dǝgiti naag Daadamazhigǝla, da nǝghǝgaakanǝghǝg taakiya tsagaanara sǝghawi vak Daadamazhigǝla, vakar biya. ");
INSERT INTO glwl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Daddakwa tsaga dǝga ghǝraana, tsag mbakyarvad faara kǝ ghǝraana. Daddakwa naa fǝgaara kǝ daddakwa ɓǝladi iina, taa ba jiira, maay nǝ fiid ma ghaiyan biya. ");
INSERT INTO glwl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Abi Muus wa vǝlakur adzahadzah? Bakǝvakwaha maay ma kuram wa tsuufǝghant adzahadzahiin biya. Aujilbǝg ci kǝskuram am naa tsakayi?” ");
INSERT INTO glwl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kaa ngwangug kǝ uudah taakiya, “Mǝng nǝ shatanah ma vǝghagha. Yaar dlaɓ wanaa tsakǝghi?” ");
INSERT INTO glwl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Kaa ngutǝrangug kǝ Yesu taakiya, “Ba dǝga jappǝr pal wa ɓagana nai davala ngiiga, baɗǝmmaru ɓagamaɓag kǝ ajappa. ");
INSERT INTO glwl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Vǝlakurvǝlǝg nǝ Muus kǝ adzahadzaha ɓa guvaca, bakǝvakwaha iin bi wa fǝgharzhafǝg biya, fararzha daadijaha daadijaharuwa. Am ɓagaan kǝ aguvac aanji daghuvala ngiiga. ");
INSERT INTO glwl_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Akwama ɓagvaraɓag nǝ aguvac kǝ zǝr daghuvala faciya ngiigga kiyava tsuufa tsagaana Muusa, aujilbǝg ci kǝskuram am nguɗa ǝrivǝɗ dǝ kai mbakyarvad uudi mbanna nai daghuvala ngiigi? ");
INSERT INTO glwl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ɓagam bi kǝ shari nǝgha gyi biya, ɓagamɓag kǝ shariy tǝdvad jiirjiira.” ");
INSERT INTO glwl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Makwahiin kǝ sarta, kaa ndavǝg kǝ kyalǝma uudahi kwar ndzǝga ma Wurshalima taakiya, “Abi, kwan kǝ-uud war naa tsǝg nǝ-iitǝr? ");
INSERT INTO glwl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Iin ɗang wan taaghai bat ɓalaɓalǝn? Tagarar bi aanji ndau biya. Nii mbatak hayaranthaig maalah taakiya iin Kǝristiyin hii? ");
INSERT INTO glwl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ghwalvǝn kiyam sǝrgasǝrǝg kǝ vakavaki sǝghsal dǝ iina, akwama da sǝghawisǝg nǝ Kǝristi jiirjiira, maay wada sǝrgasǝrg kǝ vakavaki sǝghal dǝ-iin biya.” ");
INSERT INTO glwl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ba ndzǝgaan ba tsagtǝr dǝgit nǝ Yesu kǝ uudah ma vǝgya Daadamazhigǝla, kaa dzǝgantdzǝg kǝ iin kǝ kunngy amaa, “Aana am sǝrkwasǝrga, am sǝrgasǝrǝg dlaɓ kǝ vakavaki sanal naiya. Sanhi dǝ ndzǝɗa ghǝrar biya, aɗaba Daadamazhigǝli ɓǝlakwadi kaiya dadda jiir nǝ iina, kuram am sǝrgabi nǝ uuram kǝ-iin biya. ");
INSERT INTO glwl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ən sǝrgasǝrǝg nai kǝ-iina aɗaba sanhi vakkaana, iin dlaɓa wa ɓǝlakwadiɓǝlǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tagada ba nǝ Yesu kǝ kwanǝn kǝ ǝlbǝga, kaa gata viigaan kǝ uudaha. Maay wa fǝt dǝv tǝ vakai biya aɗaba ɓagaa bi sartaan biya. ");
INSERT INTO glwl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bakǝvakwaha uudah ba baɗyaka ma dlammakǝlaw fardghǝrǝtfǝg tǝ Yesu, ar taakiya, “Aitsaa, ma sartǝn da saay nǝ Kǝristiyin tsaa, da ɓagaan ni kǝ dǝga jappǝrah kwa juujig kwa ɓagaa nǝ ghwalvǝna?” ");
INSERT INTO glwl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Cinngaraba nǝ Farisiyah kǝ uudah taa ghaiy tǝghǝr kǝ Yesu ma haay ma haaya, Kaa ɓǝlgantɓǝlǝg kǝ maalaha Zhilla kǝsuufah ard Farisiyah kǝ lii uufa vǝgya Daadamazhigǝl da viigaana. ");
INSERT INTO glwl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Aiyam nǝ Yesu taa kǝ iitǝra, “Tǝmma ba hǝɗiikǝn sarta ndzǝganar vakaru, tǝhala kwaha ǝn da gwiya daas da vak dadda kwa ɓǝlakwadiɓǝlga. ");
INSERT INTO glwl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Am da gatkwagatǝgga am da tlǝkwi biya. Vakavaki dǝ kai am da sǝgǝv biya.” ");
INSERT INTO glwl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Aiyam nǝ Yahudah ma taatakaatǝra, “Naa da dagal da vaakwar nǝ uudanǝn kwada tlǝvaraa bi ni? Mbatak da dagal da vak Yahudahǝn kwazaral ar ndzǝgan dǝ Helenahǝn kiyava tsagtǝr kǝ Helenah vaakwah hi? ");
INSERT INTO glwl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Auwa tlatlǝg nǝ-iin dǝ taakiya, ‘Am da gatkwagatǝg, am da tlǝkwi bi ni’? Au dlaɓ wa tlatlǝg nǝ-iin taakiya, ‘Vakavaki dǝ kai am da sǝgǝv bi nii’?” ");
INSERT INTO glwl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Daghuvala ghyǝngnga haara kǝssa, iin faci kwa juujig baɗǝmma, kaa ghacigaghacig kǝ Yesu dzǝgant kǝ ghaiyaan amaa, “Baɗǝm daddakwa njikǝn nǝ andǝla aa sasǝg sa vakar da hǝɓuwa. ");
INSERT INTO glwl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Baɗǝm daddakwa fadghǝr tǝ kaiya, bandkwa taga nǝ ǝlbǝga Daadamazhigǝl vinda-vinndana taakiya, njamara yuwa kwa vǝla shifǝga da kǝla sagal ma ǝrviɗyana.” ");
INSERT INTO glwl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tag tǝghǝr kǝ Shiɗǝkwa Daadamazhigǝl nǝ Yesu, kwada dlǝghǝg lii fadghǝr tǝ iina, aɗaba ma kwanǝn kǝ sarta vǝlavda bi nǝ Shiɗǝkw Daadamazhigǝl ndan biya, aɗaba favvaara bi nǝ Yesu ndan biya. ");
INSERT INTO glwl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Cinngara ba nǝ kyalǝma uudah kǝ ǝlbǝgǝn tagaa nǝ Yesu na, kaa am nǝ-iitǝra, “Ba pakat kwanǝn kǝ uuda Tlayanga.” ");
INSERT INTO glwl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Am nǝ kyalma, “Iin nǝ Kǝristi.” Gwastǝna kyalǝm ar ndava taakiya, “Ɓaga ndar nǝ Kǝristi sagal ma Galili? ");
INSERT INTO glwl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Abi tagatag nǝ ǝlbǝga Daadamazhigǝl vindavindan taakiya Kǝristi da sagal ma kuɗiga Dauda? Dlaɓa ma Bitalahami kǝssǝn kwa ndzaa nǝ Daudǝn biya?” ");
INSERT INTO glwl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Aɗabad kwaha, kaa tagwvǝmtagw nǝ araja uudah tǝghǝr kǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Kyalǝm nahar viyarviiga, bakǝvakwaha, maay wa fǝt dǝv tǝ-iin biya. ");
INSERT INTO glwl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Gwiyara ba nǝ lii uufa vǝgya Daadamazhigǝlǝn daada vak maalaha zhiila kǝssauufah ard maalaha Farisiyaha, kaa ndavtǝruundavǝg nǝ maalahaan taakiya, “Aujilbǝg samdaabi?” ");
INSERT INTO glwl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Am nǝ-lii uufǝgǝna, “Maay nǝ uudi tapghana taaghai ndǝ ghwalvǝn biya.” ");
INSERT INTO glwl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Am nǝ Farisah taa kǝ-lii uufǝgǝna, “Caa, baz kuram ndakwani valakurda valǝga? ");
INSERT INTO glwl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nii mǝng ha nǝ uud maamal ma uudah bi ma Farisiyah kwa fadǝghǝrǝt tǝ-iin hii? ");
INSERT INTO glwl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Maaya, bamma uudahaan kwar sǝrgai kǝ dǝgit tǝghǝr kǝ tsaga Muus biya. Tlafatǝratlafǝg nǝ Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimus kwandza dal da vak Yesu wura, dlaɓa palma dakwalaatǝra, kaa ndavǝg kǝ-iin taakiya. ");
INSERT INTO glwl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Tagadai kwan nǝ adzahadzaha miyam taakiya, kimya maay tǝgar shari kǝ uud, bamma cingngavacing nǝ dǝgit ɓaga nǝ iin ma ghaiyaan biya?” ");
INSERT INTO glwl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kaa ngugarangug kǝ-iitǝr taakiya, “Kǝgh ndakwi agha uuda Galiliya? Hahǝg dan kǝ shigaan ma kakkaɗa Daadamazhigǝl vinnda-vinndana, aghada nǝghǝgaaka-nǝghǝg taakiya maay nǝ tlayangngi sǝghal ma Galili biya.” ");
INSERT INTO glwl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kaa daas kǝ uudah da vǝgyahaatǝra. ");
INSERT INTO glwl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kaa dagal dat gavala uufaha zaitun. ");
INSERT INTO glwl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Dlakadur bawura kaa daas kǝ Yesu damma vǝgya Daadamazhigǝla. Kaa dzahvǝtdzahǝg kǝ uudah vakaana, cǝhuran kaa tsagtǝrtsagga. ");
INSERT INTO glwl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kaa sǝdǝvsǝg kǝ lii tsaga adzahadzaha muus ard Farisah kǝ uusiin kwa viyavǝt ɓaa gwaragwara, ar ghacinan mataatakatǝra. ");
INSERT INTO glwl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kaa tagartag kǝ iitǝr kǝ Yesu taakiya, “Dadda tsaga dǝgit, uusǝn aa vivǝt ɓa gwaragwara. ");
INSERT INTO glwl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tagakǝmndatag nǝ adzahadzaha Muus taakiya aa ɗawalav-ɗawalǝg nǝ hulfa kwan kǝ uudah da akura bamma ǝmtsara-ǝmtsǝgga. Auci amǝng?” ");
INSERT INTO glwl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ɓagar kwakyarvad ar ngarant kǝ dlǝgǝd nǝ-iitǝr kǝ ndavǝgna, dlaɓa maraa tlǝkǝna kǝ haipani ar da ɗiig nǝ-iitǝr kǝ ghunnjana. Kaa ngǝghǝrangǝg kǝ Yesu farzha kǝ vindǝg tǝ haay dǝ zǝra dǝva. ");
INSERT INTO glwl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mbǝraras ba nǝ iitǝr kǝ Yesu dǝ ndavǝgaha, kaa cigǝtciig kǝ iin ghacan amaa taa kǝ iitǝra, “Baɗǝm nǝ daddakwa maay dǝ haip ma kuram biya aa farzhafǝg kǝ ɗuulǝgaan da akura.” ");
INSERT INTO glwl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kaa gwiya ngǝghrangǝg kǝ Yesu, ngal vindǝg tǝ haaya. ");
INSERT INTO glwl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Cinngara ba nǝ iitǝr ǝndkwaha, kaa fǝgarzhafǝg kǝ iitǝr ciyadagal vaakwahiin ba da palapala, ciggǝt tǝ maalatǝr dat lii ngyikwah ngyikwaha, tǝmma ba nǝ Yesu ard uusǝn ghaciga tǝvuukwana. ");
INSERT INTO glwl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kaa cigǝtciig kǝ Yesu ghacan, ndavaru kǝ uusǝn amaa, “Uusǝn ar mǝr nǝ iitǝri? Maay wa ghaza kǝgh biya?” ");
INSERT INTO glwl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kaa ngwangug kǝ uusǝn taakiya, “Daada ndangnga, maay aanji ndǝwar biya.” Kai ndakwani ghazanka biya, “Dǝga gwiyarzhara bi kǝ ɓa haip biya.” ");
INSERT INTO glwl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tǝhala kwaha kaa gwiya tagtǝrtag nǝ Yesu kǝ ǝlbǝg kǝ uudaha amaa, “Kai nǝ paraka duniya. Baɗǝm daddakwa gata kaiya tapnai kǝ dagal ma gurtl biya, da tlǝkǝnatlǝg kǝ paraka shifǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Am nǝ Farisiyah taa kǝ Yesu, “Agha ɓagar shiid kǝ ghǝragha, shidaghǝn maay wa haiganthaig biya.” ");
INSERT INTO glwl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ngwatǝrangug nǝ Yesu taakiya, “Aanji ǝn ɓaga kǝ shiid tǝghǝr kǝ ghǝrara, shidar ba jiira, ǝn sǝrgasǝrǝg kǝ vakavaki sanal naaya ard vakavaki ǝnda gwiya daas naiya, aɗaba am sǝrgai nǝ uuram kǝ vakavaki sanal nai ard vakavaki ǝnda gwiya daas nai biya. ");
INSERT INTO glwl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Am taa shariya nǝgha gyiya nǝ uurama. Ən maay nai tǝgar shari aanji kǝ war biya. ");
INSERT INTO glwl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Aanji mana da tǝgaan kǝ shariya, shariyara ba jiijiira, aɗaba kai pal biya, kǝm ǝmtaɗ dǝ Daadar kwa ɓǝlakwadi kaiya. ");
INSERT INTO glwl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ma dzahadzaharuwa vindavavindǝg taakiya akwama tagaratag shidah bu kǝ dǝgit palla, barari dlǝghav nǝ shidaatǝra. ");
INSERT INTO glwl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Kaiya ǝn shiida ghǝrara, dǝga buwa iin nǝ Daadari bǝlakwadi ɓǝlga.” ");
INSERT INTO glwl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kaa ndavgarundavǝg kǝ itǝr taakiya, “Vaakwar nǝ Daadaghini?” Kaa ngutǝrngug kǝ Yesu taakiya, “Am sǝrkwa bi kǝskai biya, Daadar ndakwi am sǝrga biya. Akwamammaa sǝrkwasǝrga, mammaa sǝrgasǝrg kǝ Daadara.” ");
INSERT INTO glwl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tagada ma sarta kwandza tsag nǝ iin kǝ dǝgit tǝvǝgh kǝ vakavaki ɗiyav nǝ kwaɓa baiko ma vǝgya Daadamazhigǝla. Bakǝvakwaha maay wa viyitviig biya, aɗaba ɓagaa bi nǝ sartaan ndan biya. ");
INSERT INTO glwl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Kaa gwiya tagtǝrtag Yesu kǝ uudahaan dzaharvǝtǝn taakiya, “Ən da dagalara, am da gatkwagatǝga, am da ǝmtsǝg ma haipaharuwa. Vakavaki ǝn da dagal naiya, am da dǝgal biya. ");
INSERT INTO glwl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mbakyarvad kwan wa tagar nǝ maalaha Yahudah taakiya, “Da tsa ghǝran ni kwa taga nǝ iin taakiya, ‘Vakavaki ǝn da dagal naiya, am da dǝgal bina’?” ");
INSERT INTO glwl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ka zavukw kǝ Yesu taakiya, “Kurama am dǝga duni nǝ uurama, kai sanhi maghǝrazhigǝla. Kuram am dǝga duunina, kaiya ǝn dǝga duuniyin biya. ");
INSERT INTO glwl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Iinwa tagankur nai taaki am da ǝmtsǝg ma haipaharuna. Aɗaba akwama famdǝghǝrǝt bi taakiya, kai wa tagankur nai taaki kaiyin nǝ iin biya, bak jiirjiir am da ǝmtsǝg ma haipaharuwa.” ");
INSERT INTO glwl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kaa ndavgarundavǝg kǝ-iitǝr kǝ Yesu taakiya, “Agha war nǝngngi?” Kaa ngutǝrangug kǝ Yesu taakiya, “Ba kai wandza tagankur nai bawur taakiya, bakaiya. ");
INSERT INTO glwl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mǝng nǝ dǝgitah baɗyak kwan tagdatag nai tǝghǝr kǝskurama, dlaɓa ǝn tǝkura kǝ shari tǝghǝra. Daddakwa ɓǝlakwadi kaiya, ǝlbǝgaana tlaltlǝg fǝvdǝghǝrǝta. Dǝgiti cingananai vakaana, iin wan tagtǝr nai kǝ uudaha duniya.” ");
INSERT INTO glwl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nǝgharaakai nǝ uudah taakiya tag tǝghǝr kǝ Daddaan kǝ ǝlbǝg biya. ");
INSERT INTO glwl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Iin wa nǝ iin tagatǝr nǝ Yesu taakiya, “Sartǝn am da kapgant nǝ uuram kǝ Zǝra Uuda, am da nǝghǝgaaka sartaan taakiya kai nǝ-iina, dlaɓa maay nǝ dǝgiti ǝn ɓag nai kataghǝrar biya, ǝn taa ba dǝgiti tsagghwad nǝ Daadar kaltiya. ");
INSERT INTO glwl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Daddakwa ɓǝlakwadi kaiya ǝmtaɗ dǝ kaiya, ɗuwakus bi nǝ-iin daghuvar biya. Ən ɓa ba dǝgiti naag nǝ-iin ba kǝla hǝnnga.” ");
INSERT INTO glwl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ma sarta taa kwanahaan kǝ Yesu uudah ba ɗyak fardghǝrǝtfǝg tǝ iina. ");
INSERT INTO glwl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Am nǝ Yesu taa kǝ Yahudahǝn fardǝghǝrt tǝ-iinna, “Mam ba zǝgaan kǝ vukw dǝ hǝkya dǝgiti ǝn tsagkur naiya, am mbǝrzahara ba jiijiira. ");
INSERT INTO glwl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Am da sǝrgasǝrg kǝ jiira, kwanǝn kǝ jiira iin wada vǝlkur kwarga ghǝraruwa.” ");
INSERT INTO glwl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kaa ngwangug kǝ iitǝr taakiya, “Kǝm zhigha Ibrahim nǝmnda, tapamndnai kǝ nǝg kǝ ɛɛva aanji war biya. Aujilbǝg ci kǝskǝgh taaki kǝmnda tlǝkǝnatlǝg kǝ kwarga ghǝramndi?” ");
INSERT INTO glwl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Kaa ngutǝrangug kǝ Yesu amaa, “Bak jiira wan tagkurtaga, baɗǝm daddakwa fadǝmfǝg kǝ ghǝraan ma ɓa haipa ɛɛva haip nǝ-iina. ");
INSERT INTO glwl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Maay nǝ ɛɛvǝ ndzǝga hǝnnyah tangw damma zǝrazǝr biya, zǝran kǝ dadda hǝnyaha, ǝndzǝgan ba hǝnyah tangw damma zǝrazǝra. ");
INSERT INTO glwl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kwakyarvad kwaha, akwama tlamkǝnatlǝg kǝ kwargaghǝraru vak Zǝriina, am da tlǝkǝnatkǝg kǝ kwaraghǝra jiijiira. ");
INSERT INTO glwl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ən sǝrgasǝrg taaki samal am kuɗiga Ibrahima, bakǝvakwaha am naa tsakai nǝ-uurama, aɗaba dlǝghamabi kǝ ǝlbǝgar ma ǝrviɗmahuɗaharu biya. ");
INSERT INTO glwl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ən tagkur dǝgiti nǝghana nai vak Daadara, kuram am ɓa dǝgiti cingngama nǝ-uuram vak daadaruwa.” ");
INSERT INTO glwl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Kaa ngwarangug kǝ iitǝr taakiya, “Daadamnd nǝ Ibrahim.” Aiyam nǝ Yesu taa kǝ iitǝr, “Akwa mammaa zarha Ibrahim, maa ɓagamaɓag kǝ dǝgitahi ɓagaa nǝ Ibrahima. ");
INSERT INTO glwl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kaiya ǝn taa ba jiira dǝgiti cinngananai vak Daadamazhigǝla, kuram ghulamvaghulǝg kǝ naa tsa kaiya. Abi ɓagaabi nǝ Ibrahim kǝ hulfa kwanahaan kǝ dǝgitahaan biya. ");
INSERT INTO glwl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Aɗaba am ɓa ba dǝgiti ɓag nǝ Daadaruwa.” Aiyam nǝ Yahudaha, “Kǝm masagwah bi nǝmnd biya. Daadamazhigǝl nǝ Daadamnda, ba iin dlaɓ pal nǝ Daadi kǝm dǝ vakai nǝmnda.” ");
INSERT INTO glwl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Am nǝ Yesu taa kǝ-iitǝra, “Akwamaa Daadaru nǝ Daadamazhigǝla, mammaa waikwawaiga, aɗaba sanhi vak Daadamazhigǝl naiya. Kai wan kwan vaakwana, Daadamazhigǝl wa ɓǝlakwadiɓǝlga, sanhi dǝ ndzǝɗa ghǝrar biya. ");
INSERT INTO glwl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Aujilbǝg ci nǝghamaaka bi kǝ ǝlbǝgari? Aɗaba am dzǝgwantbi kǝ cinnga ǝlbǝgar biya. ");
INSERT INTO glwl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Am dǝga daadaru shatanaha, am naa ba ɓa ɗagiti naag daadaruwa. Dadda tsa shifǝg nǝ-iin bamma fakta, maay dlaɓ lammban dǝ jiir biya, aɗaba maay nǝ jiir ma ghaiyaan biya. Ba cukw sarti tag nǝ-iin kǝ fiida mara hǝnkalaana, aɗaba iin dadda taa fiid nǝ-iina, daada fiidah dlaɓa. ");
INSERT INTO glwl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kwakyarvad ǝn taa jiira, famdǝghǝrǝt bi tǝ kai biya. ");
INSERT INTO glwl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kwar ma kuram wa margwadamarǝg kǝ haipi tapannanai kǝ ɓaagaani? Akwama jiir wan tag naiya, aujilbǝg kaci famdǝghǝrǝt bi tǝ kai biyi? ");
INSERT INTO glwl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Baɗǝm nǝ daddakwa dǝga Daadamazhigǝla, cinngaan kǝ dǝgit tag nǝ Daadamazhigǝla. Kuram haiyamant bi nǝ-uuram dǝ dǝgiti tag nǝ Daadamazhigǝl biya aɗaba am dǝga Daadamazhigǝl biya.” ");
INSERT INTO glwl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Kaa ngugarangug nǝ Yahudah taakiya, “Mbats bak jiir wa tagamnd nǝmnd taakiya agha zhiil Samari dlaɓa shiɗǝkw ghwaɗ ma vǝghagh biya?” ");
INSERT INTO glwl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Aiyam nǝ Yesu, “Ən maay nai dǝ shiɗǝkw ghwaɗ biya. Daadar wan fǝgaara naiya, kuram lamwalǝg kǝ fǝkwaarafǝga. ");
INSERT INTO glwl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kaibi wa gatgar ndangngǝr kǝ ghǝrar biya, mǝng wa gatgwagatǝga, iin dlaɓ nǝ dadda ta shariya. ");
INSERT INTO glwl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Jiir wan tagkur naiya, daddakwa fǝghaarafǝg kǝ ǝlbǝgara maay ǝmtsǝg badǝm biya.” ");
INSERT INTO glwl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kaa am nǝ maalaha yaa Yahuda taa kǝ-iina, “Kǝm sǝrgasǝrǝg ndakwanci taakiya bak jiir agha dǝ shiɗǝkw ghwaɗa. Abi ǝmtsaǝmtsǝg nǝ Ibrahim, bandkwah dlaɓ nǝ tlayangngah ǝmtsahara-ǝmtsahǝga. Bakǝvakwaha kǝgh agha taaki, ‘Baɗǝm nǝ daddakwa fǝghaarafǝg kǝ ǝlbǝgagh da maay ǝmtsǝg badǝm biya.’ ");
INSERT INTO glwl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Magha tlǝg nǝng jighaarajig nǝng kǝ daadamnd Ibrahima? Ghǝravaan ndakwani ǝmtsaǝmǝga, tlayangngah ndakwi ǝmtsaharaǝmtsǝhǝga. Magha tlǝg nǝng agha war nǝngi?” ");
INSERT INTO glwl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ngwatǝrangug nǝ Yesu taakiya, “Akwama fanarafǝg kǝ ghǝrara, kwanǝn kǝ ndangngǝra maay tuuk ǝlbǝg biya. Daadari kwa kǝsamant nǝ-uuram taakiya iin nǝ Daadamazhigǝlaruwa iin wa fǝkwaraafǝga. ");
INSERT INTO glwl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Am sǝrgai nǝ uuram kǝ-iin biya, kaiya ǝn sǝgasǝrǝg kǝ-iina. Maa tagankur nai taaki ǝn sǝrga biya, maa nanalnǝg kǝ dadda fiid band kurama. Ən sǝrgasǝrg nai kǝ-iina, ǝn cingngarnucing dlaɓ kǝ dǝgit tag nǝ-iina. ");
INSERT INTO glwl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Daadaru Ibrahim dzamadzamǝg maa nǝghan kǝ zamanara, nǝghanǝghǝga dlaɓa dlaiyadlaiga.” ");
INSERT INTO glwl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Am nǝ Yahudah taa kǝ Yesuwa, “Kǝgh kwana gwastǝn ɓaghabi kǝ viig kuldlǝb ndan biya, agha gwiya taaki nǝghanǝghǝg kǝ Ibrahima?” ");
INSERT INTO glwl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Aiyam nǝ Yesu taa kǝ iitǝra, “Bak jiir wan tagkur naiya, yavva bi nǝ Ibrahim ndakwani ǝn ba mǝng naiya,” ");
INSERT INTO glwl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tagada ba nǝ Yesu kǝ kwanǝn kǝ ǝlbǝga kaa cagantcag kǝ-iitǝr ka akur kiyava tsǝgaana. Shiɓvǝgha nǝ Yesu, kaa ba dagal kǝ-iin ma vǝgya Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tǝghǝrdǝga dagal Yesu, kaa nǝghǝganǝghǝg kǝ-iin kǝ uuda nǝ-iin kwa yavva gulfa. ");
INSERT INTO glwl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ngal ndavgarundavǝg nǝ mbǝrzahaan taakiya, “Dadda tsaga dǝgit, haipa war wa nadal ghwalvǝn yavan gulfni? Haipaan nii, dǝga daddaan ard babbaanhi?” ");
INSERT INTO glwl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Am nǝ Yesu taa kǝ-iitǝra, “Kwakyarvad haipa uudanǝn biya, bii haipa daddaana bii babbaan bi wa yavva nǝ-iin gulf biya, yavvayig nǝ-iin ǝndkwaha kwakyarvad marvda ndzǝɗa Daadamazhigǝl tǝ-iina. ");
INSERT INTO glwl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Badlaɓ tsaw faciya, barari kiyam zǝgaan kǝ vukw dǝ ɓa tlǝra daddakwa ɓǝlkwadiɓǝlga, aɗaba sagaw nǝ avǝɗa maay wa da ɓagaɓag aanji kwar kǝ tlǝr biya. ");
INSERT INTO glwl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Akwama ban ma duniya, ba kai paraka duniya.” ");
INSERT INTO glwl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tagada ba nǝ-iin kwaha, kaa tǝffa kǝ-iin kǝ ashavai dat haaya, kǝɗant kǝ haay dǝ vakaiya, kaa ghudǝt kǝ-iin kǝ haayǝn kǝtghant nǝ-iin da ashavayǝna, masara tǝ gyiya kǝ uudanǝna. ");
INSERT INTO glwl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Amaa taa kǝ uudanǝna, “Dǝga, bardabarǝg kǝ gi ma dǝlva Siluwan.” Dǝgiti tuuk vakai nǝ Siluwana inn nǝ “Ɓǝlga”. Kaa dagau kǝ uudanǝn barda kǝ gyiyaana, sǝghaasǝg dǝ gyiyaan nǝghǝganǝghǝga. ");
INSERT INTO glwl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kaa ndavǝg kǝ tlǝgharawakyaghahaan ard lii narǝtnǝg kǝ nǝghǝganǝghǝg ghalǝg taakiya, “Abi ba ghwalvǝn wandza cǝhurga vaakwan ghalgǝn?” ");
INSERT INTO glwl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Am nǝ kyalma “Iina.” Am nǝ kyalmaha, “Iin biya, dzakǝvaana.” Iina ǝmtsǝtǝmtsǝg taakiya, “Ba kaiyina.” ");
INSERT INTO glwl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kaa ndavgarundavǝg kǝ-iitǝr taakiya, “Mbaa ndar kaci giyaghi?” ");
INSERT INTO glwl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ngwaangwug amaa, ghwalvǝn kwa ɗahav dǝ Yesuwǝn wa kǝɗghant haay maswadǝm ma gyiya. Amaa taa kǝskaiya, dǝg bardabarǝg ma dǝlva Siluwam. Danal ba naya ǝn bardana, kaa nǝghǝganǝghǝg kǝskaiya. ");
INSERT INTO glwl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kaa ndavgarundavǝg kǝ-iitǝra, “Mǝr nǝ uuda nǝ-iini?” Aiyama taa kǝ-iitǝra, “Ən sǝrga biya.” ");
INSERT INTO glwl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kaa langaan nǝ uudah kǝ ghwalviin kwandza gulf ba wurǝn davak Farisiyaha. ");
INSERT INTO glwl_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Aɗaba ndza daghuvala faciya ngiig wa kǝɗghant nǝ Yesu kǝ haay mbǝna kǝ gyiya uudanǝna. ");
INSERT INTO glwl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kaa ndavgarundavǝg nǝ Farisiyah kǝ ɗuuli mbaa gyiyaana. Aiyam nǝ uudanǝna, “Haay wa kǝɗghant nǝ-iin maswadǝm ma gyiya, kaa barda kǝskaiya, ndakwana ǝn nǝghǝganǝghǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kaa tagaan kǝ kyalǝma Farisiyah taaki, “Sahi vak Daadamazhigǝl bi nǝ ghwalvǝn biya, aɗaba maay tsuufa faciya ngiig biya.” Ngal ndavǝg kǝ kyalǝmah taakiya, “Ɓagǝna dau nǝ dadda kwad haip kǝ hulfa kwanahaa kǝ dǝgaha jappǝrahi?” Buud taghwzhataghw kǝ dzamaghǝraatǝra. ");
INSERT INTO glwl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kaa gwiya ndavgaruundavǝg kǝ-iitǝr kǝ uudanǝn taakiya, “Au kaci nǝ wagha nǝghǝgaaka nǝng tǝghǝr kǝ uudanǝn, iin tsau wa wurakant gi?” Kaa ngutǝrangug nǝ uudanǝn amaa, “Tlayang nǝ-iina.” ");
INSERT INTO glwl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Fardǝghǝrǝt bi nǝ maalaha Yahudah taakiya ndza gulf nǝ uudanǝn wura biya, ndakwana nǝghǝganǝghǝga. Aɗabad kwaha, kaa ɗahǝgantɗahǝg kǝ iitǝr kǝ daddaana ard babbaana ");
INSERT INTO glwl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Kaa ndavtǝru-ndavǝg kǝ-iitǝr taakiya, “Zǝraru wana? Ndza yavva gulf am nǝ uurama? Aaɓaga ndar kaci nǝghǝganǝghǝg ndakwani?” ");
INSERT INTO glwl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","“Kǝm sǝrgasǝrǝg taaki zǝramnd nǝ zǝrna, dlaɓa yavva gulfa. ");
INSERT INTO glwl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kǝm sǝrgai kǝ ɗuuli nǝghǝga nǝ iin ndakwan biya, dlaɓa kǝm sǝrgai kǝ daddakwa mbǝghǝnimbǝg biya. Ndavamarundavǝga, zarh bi nǝ-iin biya, tagdatag nǝ iin bad ghaiyaana.” ");
INSERT INTO glwl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tagardatag nǝ daddaan ard babbaan ǝndkwana, mbakyarvad ar gǝdza maalaha Yahudaha. Nguɗarant ba wur nǝ maalaha Yahudah kǝ ǝlbǝgaatǝr taakiya, baɗǝm daddakwa tagadatag taaki Yesu iin nǝ Kǝristi, ar lagwaan dagal ma guda dzǝgwazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iin wa tagar nǝ daddaana ar dǝ babbaan taakiya, “Zarh bi nǝ-iin biya, ndavamarundavǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kaa gwiya ɗaha uudanǝn ndza gulf wurǝn kǝ Farisaha, am nǝ-iitǝr taa kǝ-iina, “Tag kǝ jiira aɗaba agha faara kǝ Daadamazhigǝla, kǝm sǝrgasǝrǝg kǝ uudanǝn dadda haipa.” ");
INSERT INTO glwl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Aiyama, “Aanji dadda haip nǝ-iin ǝn sǝrga bi nai biya. Dǝgiti pal ǝn sǝrga naiya, wura ndzan gulfa, ndakwana ǝn nǝghǝganǝghǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kaa gwiya ndavgarundavǝg kǝ-iitǝr taakiya, “Aukaci wa ɓagaka nǝ-iin? Wurakant ndarci kǝ gi?” ");
INSERT INTO glwl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ngwatǝrangug amaa, “Tagankurdataga lǝmwalǝg kǝ cingngaana. Aujilbǝg kǝskuram naa gwiya cingngaani? Nii am naa nǝg kǝ Mbǝrzahaanhi?” ");
INSERT INTO glwl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ngal ba ɗahgarv-ɗahǝg kǝ-iitǝr taakiya, “Kǝgh nǝ mbǝrzaana, kǝm Mbǝrzaha Muus nǝmnda. ");
INSERT INTO glwl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kǝm sǝrgasǝrg taakiya tagaatag nǝ Daadamazhigǝl kǝ ghai dǝ Muusa, kiyava kwan kǝ uuda, kǝm sǝrgai vavvaan kǝ vakavaki sal dǝ-iin biya.” ");
INSERT INTO glwl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kaa ngutǝrangug nǝ uudanǝn taakiya, “Wanam nǝ dǝga jappǝr haniina! Am sǝrgai kǝ vakavaki sal nǝ-iin biya, waici mbǝghwanimbǝg kǝ gyiyara, ");
INSERT INTO glwl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kiyam sǝrgasǝrǝg maay Dadamazghigǝl cingtǝrnucing kǝ yaa dadda haipah biya. Cingtǝrnuciing kǝ lii ɓagarnǝs kwatǝnahǝra baɗǝmma, dlaɓa ar ɓa dǝgit naag nǝ-iina. ");
INSERT INTO glwl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Maay wa tapghanatapǝg ba dǝm kǝ cingaciing kǝ daddakwa wurgharant gyi uud yava gulf biya. ");
INSERT INTO glwl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Akwamaa sahi vak Daadamazhigǝl bi nǝ uudanǝn biya, maa ɓagna bi bandau biya.” ");
INSERT INTO glwl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Cinngaraba nǝ-iitǝr ǝndkwaha, aiyam nǝ-iitǝr taa kǝ-iina, “Dali kǝghii yakka bamma gyigyiya haip nǝ uud wagha naa tsagkǝmnd dǝgita?” Ngal lagwarslagw kǝ-iitǝra. ");
INSERT INTO glwl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Cinngha ba nǝ Yesu taaki lagwararslagw kǝ uudanǝna, ngal tlǝgaratlǝg kǝ-iina, ndavaru taakiya, “Fǝghǝdǝghǝrǝtfǝg tǝ Zǝra Uuda?” ");
INSERT INTO glwl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kaa ngwangug kǝ uudanǝna, aiyama, “Dadda ndangnga, warwahiini? Tagwataga kiyava fadghǝr kǝskai tǝ-iina.” ");
INSERT INTO glwl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ngugharangug nǝ Yesu, taakiya, “Nǝghǝghanǝghǝg ghǝravagha, abi iin wa taaghai dǝ kǝghǝna.” ");
INSERT INTO glwl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Aiyam nǝ uudanǝna, “Yaazhigǝla, fandǝghǝrǝtfǝga.” Kaa ɓagarnǝs kǝ-iin kǝ kwatnahǝra. ");
INSERT INTO glwl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Aiyam nǝ Yesu, “Sanhi mbakyarvda taa shari nai sama duniya, aɗaba gulfaha ar nǝghana, dlaɓa lii nǝghǝganǝghǝga ar da nal kǝ gulfa.” ");
INSERT INTO glwl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Cinngara ba nǝ Farisahǝn ndza tǝvǝgh kǝ-iinǝn ǝntkwana, aiyam am nǝ-iitǝr taa kǝ-iina, “Matlǝg-ghǝragh kǝmnd ndakwi, kǝm gulfaha?” ");
INSERT INTO glwl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Am nǝ Yesu taa kǝ-iitǝra, “Akwa mammaa gulfa, mammaa maay dǝ haip biya, kǝm nǝghǝganǝghǝg tsau am nurama, haipaharuwa ndzǝga ba tǝghǝr kǝskurama. ");
INSERT INTO glwl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Bak jiir wan tagkurtag Farisiyaha, baɗǝm dadakwa dagha bi damma agɛɛragɛɛra dǝ ghaiy gud biya, bakǝvakwaha kaa tlǝlla ɗulla dass kǝ-iin tǝ kwatlǝrǝn kǝ ghyǝba, gǝlla dlaɓa gwarǝɗ nǝ-iina. ");
INSERT INTO glwl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","“Dadakwa dǝgaa dǝ ghaiya wakyagha, iin dadda piiya tuughwaha. ");
INSERT INTO glwl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Dadda uufa ghaiya wakyagha wurgarwurǝgga kǝ-iina. Tuughwah dlaɓa ar cingarnucinga kǝ kungya dada piiga. Ɗahǝtǝrɗaga kǝ tuughwahaan dǝ ɗagahaatǝra, ngal langtǝrlang dagal da gyǝmǝlla. ");
INSERT INTO glwl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tǝhala kwama dadal kǝ tuughwahaan baɗǝm da gyǝmǝlla, kaa dal kǝ-iin tǝvukwatǝra, tuughahah dlaɓa ar gatǝgaan tǝhaltǝhala, aɗaba ar sǝrǝgasǝrǝg kǝ ghaiyaana. ");
INSERT INTO glwl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ar tapǝnaiy kǝ gata ghullab badǝm biya, ba kǝ jiirra ar hǝdla dagal vakaana, aɗaba ar dzǝgaakaiy kǝ ghaiya ghullab biya.” ");
INSERT INTO glwl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tagatǝrdatag nǝ Yesu kǝ uudaha kǝ kwanǝn kǝ ǝlbǝg dǝghura, bakǝvakwaha nǝghǝnǝgharaakai kǝ dǝgit tagtǝr nǝ-iin biya. ");
INSERT INTO glwl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Aɗabadkwaha am Yesu kǝ-iitǝr gwiiyadalla, “Bak jiijiira, ǝn tagkurtaga, kaiy nǝ ghaiya gudlǝgha tuughwaha. ");
INSERT INTO glwl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Baɗǝm lii sarǝva lakwti ǝn sagau naiya ar gǝllaha dlaɓa ar gwarǝɗɗaha, tuughwahahin ndakwi ar cingtǝrnu biya. ");
INSERT INTO glwl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kaiy nǝ ghaiya wakyagha, baɗǝm dadakwa dǝga tǝdǝvad kaiya da katava. Ar da saasa dlaɓa ar da dagala, ar da tlǝkǝnatlǝg vaka piig marawa. ");
INSERT INTO glwl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Gǝla sagau kwakyarvad ɓa gǝl kaltiya ard tsa shifǝga dlaɓa ard ghyǝhǝga, kaiya sanǝv taakiya ar tlǝkǝna kǝ shifǝga, dlaɓa ar tlǝkǝnan bajar righǝrighaana. ");
INSERT INTO glwl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Kaiy nǝ dadda piig marawa. Dadda piig marawa iin wa vǝlla shifǝgaan kwakyarvad tuughwaha. ");
INSERT INTO glwl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Suuniya iin bi nǝ dadda piig biya, dlaɓa tuughwaha dǝgaan biya. Aɗabadkwaha bamma sarti ma nǝghǝghanǝghǝg kǝ ghǝygya tǝghal sagauwa, kaa ɗuwaras kǝ-iin kǝ tuughwaha ngal hǝdla dagalaana. Ghǝgya tǝghal da dǝtraadǝg kǝ giɗya tuughwaha dlaɓa kwazǝtǝrdana. ");
INSERT INTO glwl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Əmdǝradagala nǝ uuddanǝn aɗaba suuniya nǝ-iina ɓa tlǝra kwaɓa, maay lamban dǝ tuughwaha biya. ");
INSERT INTO glwl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Kaiy nǝ dadda piiga marawa. Ən sǝrǝgasǝrǝg kǝ tuughwahara, tuughwahara ar sǝrkwasǝrǝga. ");
INSERT INTO glwl_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Bandkwan sǝrkwa nǝ Daada, kai dlaɓ ǝn sǝrgasǝrǝga kǝ iina. Dlaɓa ǝn vǝlgaan kǝ shiifǝgara kwakyarvad tuughwahaha. ");
INSERT INTO glwl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ən mǝng nai dǝ kyǝlǝma tuughwaha kwar dǝga kwanǝn kǝ agɛɛragɛɛra biya. Iitǝr ndakwi barari ǝn sǝtǝrddana. Ghǝravaatǝr ndakwi ar da ciingaan kǝ kungyara, ar da nal kǝ agɛɛragɛɛra palla, dadda piig palla. ");
INSERT INTO glwl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Kwakyarvad kwah wa waikwa Daddara, aɗaba ǝn vǝldavǝlǝg kǝ shifǝgara, dlaɓa ǝn gwiidagwiiga. ");
INSERT INTO glwl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Maay nǝ dadakwa kǝsǝgwavakǝsǝg kǝ shifǝg biya, aɗaba kaiy wan vǝlǝgaan dǝ naaga ghǝrara. Ən dǝ ndzǝɗa vǝldavǝlga, ǝn ndzǝɗa gwiidagwiga sǝddan dlaɓa. Kwan kǝ dǝgit wa taghwa nǝ Daddara kǝ ɓagaana.” ");
INSERT INTO glwl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kwakyarvad kwan kǝ ǝlbǝggǝn tagada nǝ Yesu, gwiya sadasǝg kǝ taagwavǝgh mataataka Yahudaha. ");
INSERT INTO glwl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Baɗyak ma iitǝra, ar taakiya, “Shatanaha wa ma vǝghaana, iin wa ɓag nǝ-iin kǝ valaagǝrna. Aaujilǝbǝg am ciingarnuciingi?” ");
INSERT INTO glwl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bakǝvakwaha am kyǝlǝmaha, “Kwanahaan kǝ ǝlbǝga tagdai nǝ daddakwad shiɗǝkwa ghwaɗ mavǝghaan biya. Kats wurǝgarantwurǝg shiɗǝkwa ghwaɗ kǝ gyi kǝ gulǝfa?” ");
INSERT INTO glwl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Masarta kwaha ndza akwhya vakka, ɓa hwaɗaga dzama hyaɗa vǝgya Dadamazhigǝl nǝ-uud ma wurushalima. ");
INSERT INTO glwl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu ndza gwayav ma gagaazaya Sulemanu ma vǝgya Dadamazhǝgǝla. ");
INSERT INTO glwl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Kaa dzahvǝtdzahǝg kǝ Yahudaha tǝghǝr kǝ-iina, kaa ndavgarundavǝg kǝ iitǝr taakiya, “Agha ɗukǝmǝndars ndar ma dzamaghǝr tǝghǝr kǝskǝgh mbǝrdakwani? Maba kǝgh nǝ Kǝristi tagkǝmǝndtag bat ɓalaɓala.” ");
INSERT INTO glwl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ngwatǝrangug nǝ Yesu kǝ iitǝra, “Tagankurdatag bawura, famdǝghǝrǝt biya. Tlǝrahaan ǝn ɓag naay ma ɗaaga Daadarna, iitǝr shidahara. ");
INSERT INTO glwl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kurama famdǝghǝrǝt biya, aɗaba am tuughwahar bi nǝ-uuram biya. ");
INSERT INTO glwl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tuughwahara ar cinngacinng kǝ ǝlbǝgara ǝn sǝrǝtǝrsǝrǝga, dlaɓa ar gatkwagatǝga. ");
INSERT INTO glwl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ən vǝltǝr shifǝga tangw damma zǝrazǝra, ar da tapǝnay kǝ ǝmǝtsǝg biya, maay dlaɓa wa da hutsǝrvahutsǝg sagal miizha dǝvvar biya. ");
INSERT INTO glwl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Daadara, kwa vǝlǝghwavǝlǝg kǝ tughwahaana jujig dǝ ndzǝd baɗǝma, maay wa da hutsǝtǝrdahutsǝg sagal miizha dǝva Daadar biya ");
INSERT INTO glwl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kaiya ard Daada kǝmba palla.” ");
INSERT INTO glwl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kaa gwiya cagantcag kǝ yaa Yahuda kǝ akurah kiyavva ɗawalǝgaana. ");
INSERT INTO glwl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Aiyam Yesu taa kǝ-iitǝra, ɓagankuraɓag kǝ tlǝrah maraw baɗyak vak Daada, am da ɗawalkwa kwakyarvad kwar kaci nǝ-uurami?” ");
INSERT INTO glwl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Aiyam yaa Yahuda, kǝm ɗawalǝk kwakyarvad tlǝr marawǝn ɓagha nǝng biya, kwakyarvad badza ɗaaga Daadamazhigǝla. Kǝgha agha uud ba gyaagyaana a gǝra ghǝragh dǝ Dadamazhǝgǝla. ");
INSERT INTO glwl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Aiyam Yesu taa kǝ iitǝra, “Vindavai kwan ma adzahadzhaharu taakiya, ‘Amaiya am ghǝlaha biya’? ");
INSERT INTO glwl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Am sǝrǝgasǝrǝg taakiya, ǝlbǝga Dadamazhǝgǝl vindavindana ndzǝga bat jiir ba kǝlaa hǝnga. Akwama ɗahavtǝr dǝ ‘Ghǝlaha’ nǝ lii cauwara ǝlbǝga Yaazhigǝla, ");
INSERT INTO glwl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","aujilbǝgci kǝskuram am taakiya ǝn badza ɗaaga Daadamazhigǝl mbakyarvad naa tagda taakiya Kaiy nǝ zǝra Daadamazhigǝli? Maay ba wah ndakwi kai wa fakwi nǝ Dadda ba kǝrkangyakwa, dlaɓa ɓǝlakwadiɓǝllǝg sama duniya. ");
INSERT INTO glwl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Akwama tlǝra Daadar bi wan ɓag nai biya, famdǝghǝrǝt bi tǝ kaiy biya. ");
INSERT INTO glwl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Akwama iitǝr wan ɓag naiya, aanji famdǝghǝrǝt bi tǝ kaiy biya, famdǝghǝrǝtfǝg tǝ tlǝrahara, aɗaba am sǝrana, dlaɓa am nǝghǝghaaka taakiya, Daada ma kaiya, kaiy dlaɓa ma iina.” ");
INSERT INTO glwl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kaa gwiya ɓaa kǝla ndzǝɗatǝr kǝ viigaana, bakǝvakwaha ngǝdlatǝrvangǝdlǝg nǝ Yesu ma dǝvvatǝra. ");
INSERT INTO glwl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tǝhala kwaha kaa gwig kǝ Yesu damma hal dzǝva kǝ zaagha Urudun, da vavaki ɓaga nǝ Yuhwana kǝ tsuufǝg ba zǝngwa, ndza kǝ-iin vakwaha. ");
INSERT INTO glwl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Uudaha baɗyaka sarǝvǝsǝg sa vakaana, kaa ba tagaan kǝ-iitǝr taakiya, “Tapǝghanaiy nǝ Yuhwana kǝ ɓa dǝga japǝr biya, bakǝvakwaha baɗǝm nǝ dǝgiti taga nǝ-iin tǝghǝr kǝ uudanǝna ba jirra.” ");
INSERT INTO glwl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Lii ndzar vakwah dlaɓa baɗyaka fardǝghǝrǝtfǝg tǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ndza mǝng nǝ uuda nǝ iin ɗaagaan Liyazaru kwa ndza yanng biya, ndzǝga ma Betani, gǝdzǝr kǝsaatǝr kǝ Maryam ard dǝghwa babbaan Marta. ");
INSERT INTO glwl_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ba kwaniin kǝ Maryam wa yanng bi zǝra babbaan Lazarusa, iin wa ɗaighara wala tǝrshin bǝtbǝt tǝ shigahaha Yaazhigǝla, dlaɓa masardan dǝ guja ghǝraana. ");
INSERT INTO glwl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kaa ɓǝlgantɓǝlǝg kǝ dǝghwaha babbaan buna kǝ ghai davak Yesu taakiya, “Yaazhigǝla, dadda kwagha waig nǝngna, yanng biya.” ");
INSERT INTO glwl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Cinngha ba nǝ Yesu ǝndkwaha, aiyama, “Kwan kǝ yanngbiyǝra da tsǝgabi kǝmtsǝg biya. Bakǝvakwaha, da saa dǝ ndanngǝr nǝ wan kǝ Dadamazhigǝla, dlaɓa fǝvvaara Zǝraana.” ");
INSERT INTO glwl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Waigaan nǝ Yesu kǝ Martla ard dǝghwa babbaan Maryama ard Liyazaru. ");
INSERT INTO glwl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Cinngha ba Yesu taakiya yanng bi nǝ Liyazaru biya, kaa gwiya gaha kǝ hǝngah bu vakavaki ndza dǝ iina. ");
INSERT INTO glwl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tǝhala kwaha, aiyama taa kǝ mbǝrzahaana, “Gwiya jiyam daadama haaya Yahudiya.” ");
INSERT INTO glwl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Aiyam nǝ mbǝrzahaana taa kǝ iina, “Dadda tsaga dǝgita, bamma hǝnngahaan dalna, Yahudah ɓagarɓag kǝlaa ndzǝɗaatǝr kǝ ɗawala kǝgh da akur kiyava tsa kǝgha, aitsǝm agha naa gwiya daada vaakwaha?” ");
INSERT INTO glwl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Kaa ngutǝrangug Yesu taakiya, “Abi au kǝlaawa tarbu ma vanng pal? Baɗǝm daddakwa dagal dǝ vaciya, maay tsǝgaan nǝ mɓǝdǝg biya, kwakyarvad nǝghǝganǝghǝg kǝ paraka duniya. ");
INSERT INTO glwl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Daddakwa dagal kavǝɗa, tsǝgaan nǝ mbǝɗga, kwakyarvad maay nǝ parak vakaan biya. ");
INSERT INTO glwl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tǝhala kwa tagada nǝ iin kwaha, kaa gwiya tagtǝrtag kǝ iin taakiya, “Tsaghwa miyam Liyazaru tsaatsǝg haara, ǝn dagal da ciigaana.” ");
INSERT INTO glwl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Aiyam mbǝrzahaan taa kǝ iina, “Yaazhigǝla, ma ba haara wa tsǝgatsǝga da mbǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Taga taakiya ǝmtsaaǝmtsǝg Liyazaru nǝ Yesu, mbǝrzahaan tlatlar ba taakiya ba haara jiijiir wa hǝnng nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kaa ba tagtǝrdatag kǝ Yesu bat ɓalaɓal taakiya, “Əmǝtsaaǝmtsǝga Liyazaru. ");
INSERT INTO glwl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ən dlaiga nai kwakyarvad kurama aɗaba ndzan maay vakwah biya, kiyava fadǝghǝr kǝskurama. Ciyamciiga, jiyam dagal da vakaana.” ");
INSERT INTO glwl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Am Toma, kwa ɗahav Didimus taa kǝ kyalǝma mbǝrzaha, “Jiyam dagal ghǝrava miyama, kiyam ǝmtsan ǝmtaɗ dǝ iina.” ");
INSERT INTO glwl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tsǝgwa ba Yesu vaakwahiina, cinnghacinng taakiya, ǝmtsaaǝmtsǝg Liyazaru, hǝngaan uufaɗ ma gǝtla. ");
INSERT INTO glwl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani ndza ba hyɛf dǝ Wurshalima dǝt bi dat mil bu taatakatǝr biya. ");
INSERT INTO glwl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Baɗyak Yahudahi sarǝv saa tagar dzǝgwagh ǝmtsǝga zǝra babbaatǝr kǝ Martla ard Maryama. ");
INSERT INTO glwl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Cinngha ba Martla taakiya sagau Yesu, kaa dagal kǝ iin da tlǝgaraatlǝga. Maryam dlaɓa ndzǝga ma hǝnyaha. ");
INSERT INTO glwl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Aiyam nǝ Martl taa kǝ Yesu, “Yaazhigǝla, magha ndza mǝng nǝng vaakwana, maa ǝmtsa bi zǝra baabar biya. ");
INSERT INTO glwl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Aanji ba ndakwan ndakwi ǝn sǝrgasǝrga taakiya baɗǝm nǝ dǝgit agha ghalga nǝng vǝlakvǝlǝg Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Am Yesu taa kǝ iina, “Da gwiya ciig zǝra baabagha.” ");
INSERT INTO glwl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Kaa ngugarangug Martl taakiya, “Ən sǝrgasǝrga da ciig dǝ shiifǝg ma gǝtlah daghwvala ghyǝnga duniya.” ");
INSERT INTO glwl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Aiyam Yesu taa kǝ iina, “Kai ciig ma gǝtlah ard shiifǝga. Daddakwa fǝdghǝrǝtfǝg tǝ kaiya, aanji ǝmtsana da ciig dǝ shiifǝga. ");
INSERT INTO glwl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Baɗǝm nǝ daddakwa ndzǝgan tǝdvad fadghǝr tǝ kaiya, da tapnai kǝ ǝmtsǝg biya. Fǝghǝdǝghǝrǝtfǝg tǝ kwanna?” ");
INSERT INTO glwl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Aiyam Martla taa kǝ iina, “Aana, Yaazhigǝla, fandǝghǝrǝtfǝg taakiya kǝgh nǝ Kǝristi, Zǝra Daadamazhigǝl kwa da sii samma duniya.” ");
INSERT INTO glwl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tagada ba Martl kwana, kaa daas kǝ iin ɗahant kǝ dǝghwa babbaan Maryam damma dlǝmmbaava, amaa, “Wa sǝghǝvsǝg dadda tsaga dǝgita, wai nǝ iin ndava kǝgha.” ");
INSERT INTO glwl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Bad cinngacinnga Maryam waha, kaa ciya dagal kǝ iin ba watswats da vak Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Dagha bi nǝ Yesu damma gǝdzǝrkǝs ndan biya, ba ndzǝgaan vakavaki tlǝghara nǝ Martla. ");
INSERT INTO glwl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yahudahi kwa ndzar ǝmtaɗ dǝ Maryam ma hǝnyah ar tagar dzǝgwagha, nǝghara ba nǝ iitǝr kǝ ciya dagala Maryam ba watswatsa, kaa gatǝgaan kǝ iitǝr dagala, matlǝg ghǝraatǝr ndakwi dagal damma gǝtlaha da tuug vakwaha. ");
INSERT INTO glwl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Dal ba nǝ Maryam da vakavaki dǝ Yesu, nǝghǝgha ba nǝ iina, kaa mbǝɗgambǝɗǝg kǝ iin tǝ vukwana, amaa taa kǝ iina, “Yaazhigǝla, magha mǝng nǝnga vaakwana, maa ǝmtsa bi nǝ zǝra baabaar biya.” ");
INSERT INTO glwl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nǝghǝgha ba Yesu kǝ Maryam tuuga, ard Yahudahi salar ǝmtaɗ dǝ iin ndakwi ar tuuga, kaa ngǝrɗkǝngǝrɗǝg kǝ Yesu ma ǝrviɗyana ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kaa ndavtǝrundavǝg kǝ Yesu taakiya, “Hǝɗama vaakwari?” Am nǝ iitǝr taa kǝ iina, “Yaazhigǝla, aasǝg saa vazgaana.” ");
INSERT INTO glwl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Kaa tuug kǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kwakyarvad kwaha, kaa tagaan kǝ Yahudah taakiya, “Vazamvazǝg kǝ ɗuuli waiga nǝ iina.” ");
INSERT INTO glwl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Aiyam kyalǝm ma iitǝr taa kǝ ghǝrahaatǝra, “Wurgharantwurǝg kǝ gyi kǝ gulfa. Maa tsǝgarvai dlaɓ kǝ uudanǝn kǝ ǝmtsǝg biya?” ");
INSERT INTO glwl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Kaa gwiya mbǝkǝnmbǝg ma ǝrviɗan kǝ Yesu ba vaivaiya, ngal dagal kǝ iin damma gǝtliina. Gǝtliin huravna ma kura, kaa hǝɗvarduhǝɗǝg ghaiyan dǝ akura. ");
INSERT INTO glwl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Am Yesu taa kǝ iitǝra, “Tlǝgamarwatlǝg kǝ akurna.” Aiyam Martla dǝghwa babba uudanǝn ǝmtsaaǝmtsǝgǝn taa kǝ Yesu, “Yaazhigǝla, abi shiig ndakwana, aɗaba hǝngaan uufaɗ hinanan ba vaakwaha.” ");
INSERT INTO glwl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Aiyam Yesu taa kǝ iina, “Tagan kaki taakiya akwama fǝghǝdǝghǝrǝtfǝga, agha da nǝghǝganǝghǝg kǝ ndangǝra Daadamazhigǝl biya?” ");
INSERT INTO glwl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kaa tlǝgarwatlǝg kǝ iitǝr kǝ akurǝna. Kaa dzǝgantdzǝg kǝ Yesu kǝ ghǝran damma ghǝrazhigǝla amaa, “Ən tagak uusa, Daada, kwakyarvad cinnghwanacinnga. ");
INSERT INTO glwl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ən sǝrgasǝrǝg agha cinngwanacinng ba kǝlaa hǝnga, na tagda kwakyarvad uudahaan ghacga vaakwanǝn ar fǝdghǝrǝt taakiya, kǝgh wa ɓǝlǝghkwadi kaiya.” ");
INSERT INTO glwl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tǝhala kwa tagada nǝ Yesu kǝ kwaha, kaa dzǝgantdzǝg kǝ iin kǝ ghaiya baɗyakɗyaka amaa, “Liyazaru, asǝg sagala!” ");
INSERT INTO glwl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kaa ba sagal kǝ uudanǝn ǝmtsaǝmtsanǝna, faɗafaɗan ma kǝlpakan baz dǝvvahaan ard shigahaana, huɗvǝgaan dlaɓa kutakutan ma kǝlpakanǝn hǝɗana dǝvakaina. Aiyam Yesu taa kǝ iitǝra, “Futamaarafutǝga, aa dǝg dagala.” ");
INSERT INTO glwl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Aɗabad kwaha, baɗyak yaa Yahudah kwa salar sa nǝghǝgara kǝ Maryama, dlaɓa nǝghǝgharanǝghǝg kǝ dǝgit ɓagaa nǝ Yesu, kaa fǝdghǝrǝtfǝg kǝ iitǝr tǝ iina. ");
INSERT INTO glwl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bakǝvakwaha kaa dagal kǝ kyalmaatǝr davak Farisiha, ar tagtǝr kǝ dǝgit ɓagaa nǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Aɗabad kwaha, kaa ɗahgantɗahǝg kǝ maalaha zhiila kǝsauufah ard Farisih kǝ dzahava gyiɗya. Ar ndavaru kǝ ghǝrahatǝra am nǝ iitǝra, “Auwa kiyam da ɓag nǝ miyammi? Vazǝg kǝ uudanǝn za ba vukw dǝ ɓa dǝgaha ajappǝr baɗyaka! ");
INSERT INTO glwl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Akwama ɓǝlyamarnaaɓǝlg kǝ ɓa kwanahaana, baɗǝm nǝ uudaha ar da fadghǝr tǝ iina. Kaa da sagau kǝ Romah ar da kǝsuu kǝ Vǝgya Daadamazhigǝla miyamma ard dlamaa kǝlaawa miyama.” ");
INSERT INTO glwl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pal ma iitǝra kwa ɗahav dǝ Kayafa, kwandza maal ba tingting ma zhiila kǝsauufah ma kwaha kǝ viiga, amaa taa kǝ iitǝra, “Kuram am sǝrgai ba ndau biya. ");
INSERT INTO glwl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nǝghamaaka biya, abi ngulǝm ǝmtsa nǝ uud pal kwakyarvad uudaha, tǝghǝr kwada ruuga nǝ dlamakǝlaaw baɗǝm?” ");
INSERT INTO glwl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tagada dǝ naaga ghǝran bi nǝ Kayaf kǝ kwah biya, aɗaba ndza iin maal ba tingting ma zhiila kǝsauufah makwaha kǝ viiga, tagadatag kǝ tlayangǝr taakiya, da ǝmtsǝg Yesu kwakyarvad dlamaa kǝlaawa Yahudaha, ");
INSERT INTO glwl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","mbakyarvad Yahudah kalti biya, dlaɓa kiyava dzaha zarha Daadamazhigǝl kwa kwazarakwazǝg aanji takwara, ar nal kǝ palla. ");
INSERT INTO glwl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ciigǝt daghuvala kwahiin kǝ sarta, kaa ɗiya sawariya tsa shifǝga Yesu kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kwakyarvad kwaha gwiya bi Yesu gwayav ma taataka dlamaa kǝlaawa Yahudah tǝ ɓalal biya, dlakulva kwaha kaa ɗuugharsɗug kǝ iin kǝ vakavakina, kaa ba dagal kǝ iin damma lard kwa hyɛf dǝ tǝghala, kaa daas damma gǝdzǝr kǝs kwa ɗahav dǝ Ifrayim, vakavaki ndza nǝ iin dǝ mbǝrzahaana. ");
INSERT INTO glwl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Hǝrzǝt ba nǝ Haarakǝsa Dzǝva Hǝnyaha Yahudaha, kaa dagat kǝ lii ma gǝdzǝrkǝs baɗyak damma Wurushalima kiyava pǝsha ghǝraatǝr lakwti kǝ haarakǝs bandkwa tagaa nǝ dǝga daadijahaatǝra. ");
INSERT INTO glwl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tlatǝr ba gata Yesu, kaa daas kǝ iitǝr damma gaagazaiya Vǝgya Daadamazhigǝl ar ghacan ar ndava zarabahaatǝr taakiya, “Au wam tlatlǝg nǝ uuram? Da ba sagau nǝ iin kwan damma haarakǝsa?” ");
INSERT INTO glwl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Aɗaba ndza tagardatag nǝ maalaha zhiila kǝsauufah ard Farisiyah ba wur taakiya, baɗǝm daadakwa sǝrgasǝrǝg kǝ vakavaki dǝ Yesu, aa sasǝg sa tagaana, kiyava vigaan kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tǝmma ba hǝnng ǝngkwah kǝ haarakǝsa Dzava Hǝnnyaha, kaa ba dagal kǝ Yesu damma Betani vakavaki dǝ Liyazaru, kwa ciighant Yesu dǝ shiifǝga. ");
INSERT INTO glwl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kaa tǝvaratǝg kafa hwaas kǝ Yesu. Martl wa tagwa kafa, pal Liyazaru ma uudahi ndzar zaa kaf ǝmtaɗ dǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kaa ba kǝsgantkǝsǝg kǝ Maryam kǝ ghǝndǝka sǝmtala tǝrshǝna nardi, kwaba pir ganana, ɗayarǝt tǝ shigaha Yesu, dlaɓa masaradan kǝ shigahaan dǝ guja ghǝrana. Kaa ba gǝgagǝg kǝ shiiga tǝrshinǝn kǝ hǝnyah baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Bakǝvakwaha, am Yahuda Iskariyoti, pal ma mbǝrzahaan kwa da vǝlǝgaana, ");
INSERT INTO glwl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Auwjilbǝg maa vǝlavǝt bi nǝ tǝrshinǝn tǝ kwaɓ kwa tlǝkǝna nǝ bariyam ma vannga dǝrmǝk hǝkǝrɗ, tǝhala kwaha vǝlvtǝr kǝ talagah biyi?” ");
INSERT INTO glwl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tagada kwakyarvad naa mǝltǝru kǝ talagah bi nǝ Yahud kǝ kwah biya, aɗaba gǝl nǝ iina. Dlaɓa iin dadda hǝkya kwaɓaatǝra, ɓaa gǝl sagal ma vakaiya. ");
INSERT INTO glwl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Aiyam nǝ Yesu, “Aɗuuga, ndza fa kwakyarvad daghuvali kwada hǝɗkwa nǝ uuda. ");
INSERT INTO glwl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Am ba kǝlaa hǝnng ǝmtaɗ dǝ talagaha, aɗaba am maay kǝlaa hǝnng ǝmtaɗ dǝ kai biya.” ");
INSERT INTO glwl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ciingara ba dzahava Yahudah baɗyak taakiya vakwan Yesu, kaa sagau kǝ iitǝra, sarǝv kwakyarvad Yesu kalti biya, aɗaba ar vaznan baz Liyazaru kwa cighant Yesu dǝ shiifǝga. ");
INSERT INTO glwl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kaa ɗiiya sawariya kǝ maalaha zhilla kǝsauufaha, kiyava tsǝgaan kǝ iitǝr baz Liyazaru, ");
INSERT INTO glwl_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","aɗaba tǝdvad Liyazaru wa ɗuwarars Yahudah baɗyak kǝ zhilla kǝsauufahaatǝr ar fadghǝr tǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Wurga kǝsaana, cinngaracinng nǝ uudah baɗyak kwa sarǝv sa vaka Hwaɗaga Haarakǝsa Dzava Hǝnnyah taakiya, tǝghǝrdǝga dagat damma Wurshalim Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kaa cagantcag kǝ iitǝr kǝ apayapaya njuura, kaa dagal kǝ iitǝr da vakaana, ar dzǝgant kǝ ghai ar ɗiyaru kǝ cawa, ar taakiya, “Hosanna! Bark kǝ daddakwa sagauw ma ɗaaga Yaazhigǝla! Barka kǝ tlǝkǝsa yaa Israila!” ");
INSERT INTO glwl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Tlǝghaara ba Yesu kǝ zǝra aghyungwa, kaa ɗalgaan kǝ iina, bandkwa vindava taakiya, ");
INSERT INTO glwl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Gǝdz bi Dǝghwa Sihiyon biya; vazǝg kǝ tlǝksagh saas cǝhurga tǝ zǝra aghyungwa”. ");
INSERT INTO glwl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ba zǝngwa nǝgharaaka bi mbǝrzahaan kǝ kwan kǝ dǝgit biya, da nǝgharaaka tǝhalakwa favaara Yesu, kaa dzamgaan kǝ iitǝr taakiya, vindavavindǝg nǝ wan kǝ dǝgitaha tǝghǝr kǝ iina, dlaɓa dǝginahaan dzǝghaardzǝg bakalkalla bandkwa viindavana. ");
INSERT INTO glwl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Uudahi ndzar ǝmtaɗ dǝ iin masarta kwa ɗahghant nǝ iin kǝ Liyazaru sagal magǝtla, dlaɓa ciyan kǝ iin dǝ shiifǝga, kaa zavukw kǝ iitǝr dǝ tagtǝr dǝgitahi ɓagatǝra Yesu kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Daral nǝ uudah baɗyak da dlǝgha Yesu kwakyarvad cinngaracinng kǝ dǝga ajapǝri ɓagaa nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Aiyam Farisiyaha ma taatakatǝra, “Wayamciya, maay vakavaki langkiyam wan biya. Vazamzǝg kǝ ɗulli gatǝg duni kǝ iin baɗǝmma.” ");
INSERT INTO glwl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ndza mǝng kyalma Helenaha ma lii daral da ɓa kwatǝnahǝr ma sarta hwaɗaga haarakǝsa. ");
INSERT INTO glwl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Kaa sagau kǝ iitǝr sa vak Filigus uuda Betsaida ma haaya Galili, kaa ndavgarundavǝg kǝ iitǝr taakiya, “Dadda ndanga, ma kǝmnda naagaan ma kǝmnda nǝghǝgha kǝ Yesu.” ");
INSERT INTO glwl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Kaa dagal kǝ Filigus da tagar kǝ Andrawus, kaa dagal kǝ iitǝr ba bǝrkuɗaatǝr ar tagar kǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Aiyam Yesu taa kǝ iitǝr, “Ɓagaaɓag sart kwada fǝvaara Zǝra Uuda. ");
INSERT INTO glwl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Bak jiijiira, ǝn tagkurtaga, ma riiyava bi zǝra hǝi damma haay ǝmtsan biya, ndzǝga ba njakǝɗinjaana. Akwama ǝmtsaaǝmtsǝga, yiigaan kǝ zǝrh baɗyaka. ");
INSERT INTO glwl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Baɗǝm daddakwa waiya shifǝgaana da ɓǝlgaan dagala, baɗǝm daddakwa ɗuugant shifǝgaan ma duunina, da tlǝknatlǝg kǝ shifǝga tangw damma zǝrazǝra. ");
INSERT INTO glwl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Baɗǝm daddakwa da ɓaguwa tlǝra, barari gatkwagatǝga. Baɗǝm vakavaki dǝ kaiya, da ndzǝga ba ǝmtaɗ dǝ kai nǝ daddakwa ɓaguwa tlǝra. Da fǝgaarafǝg Daadar kǝ daddakwa ɓaguwa tlǝra.” ");
INSERT INTO glwl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ndakwana mbakwambǝg ma ǝrviɗyara. Au ci wan da tag naiyi? Ən taakiya, ‘Daada, katkwakatǝg ma kwan kǝ sart nii?’ Maaya, sanhi ba kǝrkangyǝkw kwakyarvad kwan kǝ sarta. ");
INSERT INTO glwl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Daada, faarafǝg kǝ ɗaagagha.” Kaa sii kǝ ghai sii ma ghǝrazhigǝla amaa, “Fanaarafǝga, dlaɓa ǝn da gwiya fǝgaarafǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ciingara ba nǝ uudahaan ghacga vakwahǝn kǝ ghaiya, am nǝ iitǝra, “Karazhigǝl waa tlaava.” Am kyǝlǝm dlaɓa, “Zǝrɓǝlg waa tagar ghaiya.” ");
INSERT INTO glwl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Am Yesu taa kǝ iitǝra, “Kwan kǝ ghai sahi kwakyarvad mǝlkuruwa, kwakyarvad kai biya. ");
INSERT INTO glwl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Da tǝvar ndakwan nǝ shari kǝ duniya, da lagwav ndakwan dlaɓ nǝ dadda kwara duunina. ");
INSERT INTO glwl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mada tsǝgwakuttsǝgw nǝ uud ma duniya, ǝn da tǝɗda kǝ uudah baɗǝm sa vakara.” ");
INSERT INTO glwl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tagada kwakyarvad marda nǝ Yesu kǝ hulfa ǝmtsǝgi da ǝmtsǝg nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Aiyam nǝ uudah taa kǝ Yesu, “Tagakǝmǝndatag nǝ adzahadzah taakiya, da ndzǝga bad shiifǝg nǝ Kǝristi ba ɗǝmma. Agha tag ndandar kaci taakiya barari nǝ zǝr uuda da tsǝgwavi? War nǝ Zǝr Uudiini?” ");
INSERT INTO glwl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Aiyam nǝ Yesu taa kǝ iitǝra, “Parakǝrǝn ǝmtaɗ dǝ kuramna, da zǝlma bi vaivai biya. Damdagal bamma sartǝn mǝng nǝ parak ǝmǝtaɗ dǝ kurama, aa tlǝkuraa bi gurtl biya. Daddakwa dagal ma gurtla sǝrgai kǝ vakavaki dagal nǝ iin biya. ");
INSERT INTO glwl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Famdǝghǝrǝtfǝg tǝ parakǝna, bamma sarti am ǝmtaɗ dǝ iina, aɗaba am nal kǝ zǝrha paraka.” Tǝhala tagdatag kǝ Yesu kǝ kwan kǝ ǝlbǝga, kaa dagal kǝ iin shǝɓvana. ");
INSERT INTO glwl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Baaba dǝgaha jappǝrǝn ɓagaa Yesu tǝvukwatǝrna, bakǝvakwha larwalǝg kǝ fadǝghǝr tǝ iina. ");
INSERT INTO glwl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Dzǝghaar kwakyarvad righǝvant nǝ dǝgit taga nǝ tlayang Ishaya wannǝn taakiya, “Yaazhigǝla, warwa fǝdghǝrǝtfǝg tǝ ǝlbǝgamndi, dlaɓa margharda kǝ war nǝ Yaazhigǝl kǝ dǝgiti ɓagaa nǝ dǝvaani?” ");
INSERT INTO glwl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kwakyarvd kwan nǝ iin wa fardghǝrǝt bi nǝ iitǝr biya, bandkwa tagada nǝ Ishaya vakavaki tlǝrǝn taakiya, ");
INSERT INTO glwl_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Gulfǝghantgulfǝg kǝ gyiyahaatǝra, dlaɓa naatǝrdalnǝg kǝ ǝrviɗyatǝr ba dǝkdǝka, haik kǝ nǝghǝganǝghǝg kǝ iitǝr dǝ gyiyahaatǝra, dlaɓa haik kǝ nǝghǝgaakanǝghǝg ma ǝrviɗyatǝra, haik gwiya sa vakar kǝ iitǝra, ǝn mbǝtǝranana.” ");
INSERT INTO glwl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Tagada kwakyarvad nǝghanǝghǝg nǝ Ishaya kǝ ndangǝra Yesu, dlaɓa tagda kǝ ǝlbǝg tǝghǝr kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Bakǝvakwaha, uudah baɗyak fardǝghǝrǝtfǝg tǝ Yesu, baz maalahatǝr baɗyak fardghǝrǝtfǝg tǝ iina. Kwakyarvad gǝdza Farisiyaha, tagarai taakiya fardghǝrǝtfǝg biya, haik lagwtǝrlagw sagal ma guda dzǝgwazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Aɗaba ar waiya ba galǝg vak uudaha tǝghǝr kǝ galǝg vak Dadamazhǝgǝla. ");
INSERT INTO glwl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kaa dzǝgantdzǝg Yesu kǝ ghaiya, amaa, “Baɗǝm daddakwa fadghǝr tǝ kaiya, fadghǝr tǝ kaiy kalti biya, fadghǝr tǝ dadakwa ɓalakwadi kaiya. ");
INSERT INTO glwl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Baɗǝm daddakwa vaza dat kaiya, nǝghǝganǝghǝg kǝ daddakwa ɓǝlakwadi kaiya. ");
INSERT INTO glwl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Sanhi band parak nai samma duniya, aɗaba haik kǝ ndzǝgan kǝ daddakwa fadghǝr tǝ kai baɗǝm ma gurǝtla. ");
INSERT INTO glwl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Baɗǝm dadakwa cinnghacinng kǝ ǝlbǝgahara, dlaɓa tsuufghant biya, kai bi dadda tǝgar shari biya. Sanhi kwakyarvad tǝgar shari kǝ duni nai biya, aɗaba ǝn katant kǝ duniya. ");
INSERT INTO glwl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Daddakwa ɗuwakusɗuuga, dlaɓa haighant bi kǝ ǝlbǝgar biya, mǝng daddakwa tǝgar shariya, ǝlbǝgǝn taganda naina, iin wa da tǝgar shari daghuvala ghyǝnga duniya. ");
INSERT INTO glwl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Dǝginahaan ǝn tag nai sagal vakar biya, Daada kwa ɓǝlakwadi kai iin wa taghwatag kǝ dǝgiti ǝn da tag naiya. ");
INSERT INTO glwl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ən sǝrgasǝrǝg dlaɓa shifǝga tangw dama zǝrazǝra tlǝvǝkǝna tǝdǝvad dǝgiti tag Daada. Kwakyarvad kwaha baɗǝm nǝ dǝgit naa tagda naiya, naa tagda ba kalkal bandkwa taghwa Daada taakiya aa tagantaga.” ");
INSERT INTO glwl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Lakwti ɓag sarta Hwaɗaga Haarakǝsa Dzǝva Hǝnnyaha, sǝrghaakasǝrǝg Yesu taakiya ɓaagɓag sartaan kwada ɗuug nǝ iin kǝ duni kiyava gwiya daas da vak Daada. Waighantwaig tsau Yesu kǝ uudahaan ma duniya, dlaɓ maratǝrdamarǝg kǝ waiyakǝvaan tangw dat ghaalaana. ");
INSERT INTO glwl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Lakwti za kafa hwaas kǝ Yesu ard mbǝrzahaana, fagharafǝg Shatanah kǝ Yahuda, zǝra Saminu Iskariyoti kǝ vǝla Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Sǝrgasǝrǝg Yesu taakiya, fadǝmfǝg Daad kǝ dǝgitah miizha dǝvaan baɗǝmma, dlaɓa sǝrgasǝrǝg sahi vak Daadamazhigǝla, da gwiiya daas da vak Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ma sartǝn ar za kafna, kaa ciigǝtciig Yesu, tsugda kǝ sǝɗavaani gyimala, kǝsant kǝ patkara sǝɗav nguɗǝs tǝ ngyilaana. ");
INSERT INTO glwl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tǝhala kwaha gǝt kǝ iin kǝ yu ma kuwa, farzha kǝ bara shigaha mbǝrzahaana, dǝrda kǝ shigahaatǝr dǝ patkara sǝɗav kwa nguɗǝs nǝ iin tǝ ngyilaanna. ");
INSERT INTO glwl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kaa sagauw kǝ Yesu da vak Bitrus. Am Bitrus taa kǝ iina, “Yazhǝgǝla, kǝgh wa da bargwa shigahara?” ");
INSERT INTO glwl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Kaa ngugangug Yesu taakiya, “Agha sǝrga bi kǝ dǝgit ǝn ɓag nai ndakwan biya, agha da nǝghǝgaaka tǝ hala.” ");
INSERT INTO glwl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Aiyam Bitrus taa kǝ iina, “Maaya! agha tapna bi kǝ bargwa shigahar biya.” Kaa ngugarangug kǝ Yesu, amaa, “Ai ciya, akwama barankada biya, agha maay ǝmtaɗ dǝ kai biya.” ");
INSERT INTO glwl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Aiyam Bitrus taa kǝ iina, “Yazhigǝla, aa ɗuug kǝ shigahar kalti biya, baz dǝvvahara ard ghǝrara.” ");
INSERT INTO glwl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Am Yesu taa kǝ iina, “Akwama baraabarǝg nǝ uuda, baɗǝm nǝ vǝghaan ba cuwaɗaɗɗa. Madlai lambaan dǝ barg biya, bamma barda kǝ shigahaan kaltiya. Aɗaba am ba cuwaɗaɗɗa, bakǝvakwaha, ɗǝmaru biya.” ");
INSERT INTO glwl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Aɗaba sǝrgasǝrǝg kǝ daddakwa da za langyiyaana, iinwa tag nǝ iin taakiya, “Kuram ɗǝm bi wa cuwaɗaɗ biya.” ");
INSERT INTO glwl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ghyǝnnga ba nǝ iin bartǝr shiggahatǝra, kaa gwiya tsǝgwǝv kǝ sǝɗɗavaana, kaa gwiiya kǝ iin davak ndzǝggaanana. Kaa ndavǝtǝrndavǝg kǝ iina amaa, “Nǝghǝghamakanǝghǝg kǝ dǝgit ǝnna ɓagkur naiya? ");
INSERT INTO glwl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Am ɗaa kai dǝ dadda tsaga dǝgita, dlaɓa Yazhǝgǝla. Ba kalkalla, aɗaɓa ǝn band kwaha naiya. ");
INSERT INTO glwl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ən Yazhǝgǝlaruwa ard Daddatsaga dǝgitaru tsauwa, barrankurdabarǝg kǝ shiga, kats kuram ndakwi barari am barrgarbarrǝg kǝ shig kǝ zaraabahaaruwa. ");
INSERT INTO glwl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Marankurdamarǝg kǝ garav kǝyavva ɓagaan kǝskuram band kwana ɓakura naiya. ");
INSERT INTO glwl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Bak jiijiira ǝn tagkurtaga, kwatnaha jigubi kǝ daddahǝnǝhya biya, zǝrɓǝllǝg dlaɓa jiguwi kǝ daddakwa ɓǝllǝgaan biya. ");
INSERT INTO glwl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ndakwanna am asǝrgasǝrg tsau kǝ kwannahaan kǝ dǝgitaha, akwaman ɓagaana am da dǝ barka. ");
INSERT INTO glwl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ən tag tǝghǝr kǝsskuram ɗǝm biya. Ən sǝrgasǝrǝg kǝ uudahi dzǝrantǝraaka naiya. Kwannǝn dlaɓa kwakyarvad righǝvant nǝ dǝgit ma kakaɗa Dadamazhǝgǝla taakiya, ‘Daddakwa kǝm zaa kaf ǝmǝtaɗa nalnǝg kǝ tlǝghumara.’ ");
INSERT INTO glwl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ən tagkurtag ndakwana lakuti dzǝgaadzǝga, aɗaba ma da dzǝghaardzǝga, famdǝghǝrǝtfǝg taakiya ba kaiyina. ");
INSERT INTO glwl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Bak jiijiira ǝn tagkurtaga, daddakwa dlǝghadlǝg kǝ daddakwana ɓǝlgant nai bad rivǝɗmahuɗ palla, dlǝghaakwidlǝg kǝsskaiya. Dlaɓa daddakwa dlǝghaakwidlǝg kǝsskaiya dlǝghaadlǝg kǝ daddakwa ɓallakwadi kaiya.” ");
INSERT INTO glwl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tǝhala tagdataga Yesu kwanen kǝ ǝlbǝga, mbakǝnmbǝg ma ǝrivɗyana. Kaa tagaan kǝ iin bat ɓallaɓal taakiya, “Bak jiijiira, ǝn tagkurtaga, pallaruwa da vǝlkwavǝlǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kaa vazakǝv kǝ mbǝrzahaan mataatakaatǝra, aɗaba ar sǝrgai kǝ mbǝrzi tag nǝ Yesu kǝ ǝlbǝg tǝghǝr biya. ");
INSERT INTO glwl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pal ma mbǝrzahaana, kwa waig nǝ iina, ndzǝgaan bahyǝf dǝ inna, ");
INSERT INTO glwl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Wiika am nǝ Bitrus dǝ dǝv taa kǝ mbǝrzǝna, ndavarundavǝg kǝ Yesu tag tǝghǝr kǝ warra. ");
INSERT INTO glwl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kaa dǝngzharva kǝ mbǝrzǝn tǝvǝgh kǝ Yesu ndavaruwa amaa, “War wahiin, Yazhigǝli?” ");
INSERT INTO glwl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Aiyam nǝ Yesu taa kǝ iina, “Ən da hǝgaan kǝ ghudǝga bruudi damma taasa. Dadakwan da vǝlga naiya, iin nǝ uuda nǝ iina.” Kǝssghant ba nǝ Yesu kǝ ghudǝga bruudin hǝdǝmma, kaa vǝlla kǝ iin kǝ Yahuda zǝra siman Iskariyoti. ");
INSERT INTO glwl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Cauwa ba nǝ iin kǝ ghudǝga bruudi kaa dass kǝ shatanah dama vǝghaana bawatswatsa. Kaa am Yesu kǝ Yahuda, “Dǝginǝn aghanaa ɓag nǝngnaa ɓag bawatswatsa.” ");
INSERT INTO glwl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Maay ma lii za kafǝn wa nǝghǝghakanǝghǝg kǝ dǝgit tuuk vakaiy wa taghar nǝ Yesu kǝ iin biya. ");
INSERT INTO glwl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yahuda tsau wa hǝkya ambǝlla kwaɓatǝra, kyǝlǝma mbǝrzaah tlatlar ba taakiya tagghar aa sǝgwasǝgw kǝ dǝgit naahaava kwakyarvad haarakǝssa nǝ Yesu, bi vǝllǝtǝr kǝ dǝgit kǝ talaggaha. ");
INSERT INTO glwl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Cauwa ba nǝ iin kǝ ghudǝga bruudina, kaa dagalaana. Masarta kwaha ndza avǝɗ vakka. ");
INSERT INTO glwl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tǝhala kwa dagal Yahuda, am Yesu, “Aa fǝvvaara ndakwan nǝ Zǝr Uuda, dlaɓa faavaarafǝg nǝ Dadamazhǝgǝl tǝdǝvad iina. ");
INSERT INTO glwl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Akwama fǝvaarafǝg nǝ Dadamazhǝgǝl tǝdǝvad iina, Dadamazhǝgǝl da fǝgaarafǝg kǝ zǝraan bad ghǝraana, dlaɓa da fǝgaarafǝga bawatswatsa. ");
INSERT INTO glwl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Kuram Zarhara, tǝmma bahǝɗiikǝn nǝ ndzǝgana ǝmǝtaɗ dǝ kurama. Am da gatkwagatǝga, bandkwa tagantǝr nai kǝ yaa Yahud taakiya, ‘Ən tagkurtag bandakwanna, Vakavaki ǝn da dagal naiya am da sǝgǝv biya.’ ");
INSERT INTO glwl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Dalla adzahadzah wan vǝllǝkur naiya, waiyamwaig kǝ uuda. Bandkwan waiyankurǝt naiya, kuram ndakwi waiyamwaig kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tǝdǝvad kwamam waigaan kǝ uuda da sǝrǝggasǝrǝg aanji war taakiya am mbǝrzahaara.” ");
INSERT INTO glwl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ndavǝgharundavǝg Siman Bitrus kǝ Yesu amaa, “Yaazhigǝla, agha da dagal da vakwari?” Ngughaarangug nǝ Yesu amaa, “Ndakwana vakavaki ǝn da dagal naiya agha da gatkus biya, tǝhala agha da gatkusgatǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Aiyam Bitrus taa kǝ iina, “Yazhigǝla, aujilbǝg ǝn gatkǝsi ndakwan biyi? Ən da vǝlgaan kǝ shifǝgar kwakyarvad kǝgha.” ");
INSERT INTO glwl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Aiyam nǝ Yesu taa kǝ iina, “Aaya, agha da vǝlgaan kǝ shifǝgagh kwakyarvad kaiya? Bak jiijiira, ǝn tagkataga, lakwti wiig ghwatkal agha da ɓalgaan kǝ agajauwa sǝrkwa bi shig hǝkǝrɗa.” ");
INSERT INTO glwl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Ndavǝm biya, famdǝghǝrǝtfǝg tǝ Dadamazhǝgǝla, dlaɓa famdǝghǝrǝtfǝg tǝ kaiya. ");
INSERT INTO glwl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ma vǝgya Daadara mǝng nǝ vaka ndzǝgaan baɗyaka. Akwamaamaay ndkwaha biya manaa maay tagkurtag kwan biya. Ən dagal da vakwaha kwakyarvad ǝn ɓadlkurnan kǝ vakavaka. ");
INSERT INTO glwl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Akwama danǝt ɓadlankurnaɓadlǝg kǝ vaka, ǝn da saaya ǝn dǝkurda da vakara, aɗaba kuram ndakwi am ndzan vavaki dǝ kaiya. ");
INSERT INTO glwl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ghǝravaru ndakwi am sǝrǝggasǝrǝg kǝ ɗuula daa da vakavaki ǝn dagal naiya.” ");
INSERT INTO glwl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Am Toma taa kǝ Yesu, “Yaazhigǝla, kǝm sǝrǝgai kǝ vavaki agha dagal nǝng biya, kǝm da sǝrga ndandar kaci kǝ ɗuuli?” ");
INSERT INTO glwl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ngugharangug nǝ Yesu taakiya, “Kai ɗuula, kai jiira, kai dlaɓa ǝn shiifǝga. Maay wa dǝgaadǝg da vak Daada biya bamma tǝdǝvad kaiya. ");
INSERT INTO glwl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Akwama maa sǝrkwasǝrga, mammaa sǝrgasǝrǝg kǝ Daadara. Ma ndakwanǝrna ndakwana am sǝrgasǝrǝga, dlaɓa nǝghǝghamakanǝghǝg kǝ iina.” ");
INSERT INTO glwl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Aiyam Filigus taa kǝ iina, “Yazhigǝla, akwama marghǝkǝmdadamarǝg kǝ Daadiina, tsǝghatsǝg kǝ puutamnda.” ");
INSERT INTO glwl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Am Yesu taa kǝ iina, “Zǝlanmazǝlmǝg ǝmtaɗ dǝ kurama, gwastǝn agha sǝrkwa bi Filibus biya? Baɗǝm daddakwa nǝghakwanǝghǝga, nǝghǝghanǝghǝg kǝ Daadiina. Agha tag ndarndar kaci, ‘Marwadamarǝg kǝ Daadiini’? ");
INSERT INTO glwl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Fǝghǝdǝghǝrǝt bi taakiya kai ǝn ma Daada, dlaɓa Daada ma kaiy biya? Əlbǝgahahaan ǝn tagkur naina dǝ ndzǝɗa ghǝrar biya, Daadǝn ndzǝga ma kai na iin wa ɓa tlǝrahaaana. ");
INSERT INTO glwl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Famdǝghǝrǝtfǝg tǝ kaiya masartǝn ǝn tag nai ǝn ma Daadna, Daadiin dlaɓ ma kaiya, aanji ba kwakyarvad tlǝraha japǝrǝn ǝn ɓag naiy na famdǝghǝrǝtfǝg tǝ kaiya. ");
INSERT INTO glwl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Bak jiijiir ǝn tagkurtaga, baɗǝm nǝ daddakwa fadǝghǝrǝtfǝg tǝ kaiya, da ɓagaan kǝ tlǝrahaan ǝn ɓag naiyna. Da ɓagaan baz kwa jujig kǝ kwannahaan kǝ tlǝraaha aɗaba ǝn daa da vak Daada. ");
INSERT INTO glwl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Baɗǝm nǝ dǝgiti am ghalǝg nǝ uuram ma ɗagara ǝn ɓagkurɓaga, aɗaba Daadina fǝvaaran tǝdǝvad Zǝra. ");
INSERT INTO glwl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Aanji aau wam ghallǝg nǝ uuram ma ɗagara, ǝn ɓagkurɓaga. ");
INSERT INTO glwl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Akwama mam waikwawaiga, gatamgatǝg kǝ adzahadzahara. ");
INSERT INTO glwl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ən da ghalgaan kǝ Daada, iin dlaɓa da vǝlkurvǝlǝg kǝ daddakwa da mǝlkurmǝlǝg ndzan ǝmǝtaɗ dǝ kuram tangw damma zǝrazǝra. ");
INSERT INTO glwl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iin shǝɗkwa jiijiira, kwa lawa duni kǝ tlǝghǝgaana aɗaba nǝghǝghǝga biya bi sǝrǝga kǝ iin biya. Kurama am sǝrgasǝrǝg kǝ iina, aɗaba ndzǝga ǝmǝtaɗ dǝ kurama, dlaɓa da ndzǝga ma ǝrivɗyaruwa. ");
INSERT INTO glwl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ən ɗukurǝs bi ǝnd taaghah biya, ǝn da sagau sa vakaruwa. ");
INSERT INTO glwl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Gǝɗya ba sart hǝɗikǝna da madlai duni nǝghǝkwanǝghǝg biya, amaa kurama am da nǝghkwanǝghǝga. Aɗaba ǝn dǝshiifǝga, kuram dlaɓa am da bad shiifǝga. ");
INSERT INTO glwl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Daghuvala kwaniin kǝ faci wam da sǝrga nǝ uuram taakiya kaiya ǝn ma Daad, kuram dlaɓa am ma kaiya, kaiya dlaɓa ǝn ma kurama. ");
INSERT INTO glwl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Baɗǝm nǝ dadakwa sǝrgasǝrǝg kǝ adzahadzahara, dlaɓa gatǝgaana, iin wa waiya kaiya. Daddakwa waikwawaiga dlaɓa, Daadara da waiyǝgaan kǝ iina, kaiy dlaɓa ǝn da waigaan kǝ iina ǝn marda kǝ ghǝrar vakana.” ");
INSERT INTO glwl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Am Yahud taa kǝ iina, kwa Yahuda Iskariyoti biya, “Yazhigǝla, aaujilǝbǝg da mara ghǝragh vakamǝnd, kwal margar kǝ duuniyi?” ");
INSERT INTO glwl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Kaa ngugwarangug kǝ Yesu amaa taa kǝ iina, “Baɗǝm nǝ daddakwa waikwawaiga, da tsuufǝgaan kǝ ǝlbǝgara, Daada dlaɓa da waiyǝgaan kǝ iina, kǝm da sagau saa vakana kǝm ndzan ǝmǝtaɗ dǝ iina. ");
INSERT INTO glwl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Daddakwa maay waiya kaiy biya, maay tsuufa ǝlbǝgar biya. Əlbǝgǝn am cinng nǝ uuramǝna dǝgar biya, dǝga Daddakwa ɓǝlakwadi kaiya. ");
INSERT INTO glwl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Tagankurdatag kwanahaan kǝ digitah bama sartǝn ndzan ǝmǝtaɗ dǝ kurama. ");
INSERT INTO glwl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Dadda mǝlgaru kǝ uuda, Shǝɗkw Daadamazhigǝla, kwa da ɓǝllǝg nǝ Daada ma ɗagara, iin wa da tsakur dǝgit baɗǝma, dlaɓa da dzamkurǝs baɗǝm kǝ dǝgit tangaankurda naiya. ");
INSERT INTO glwl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Gabǝrǝr wanaa ɗukurǝs naiya, vǝllankurvǝllǝg kǝ gabǝrara. Ənna vǝllǝkur ndǝkwa vǝllǝkur nǝ duni biya. Ndavambiya, dlaɓa gǝdzam biya. ");
INSERT INTO glwl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Cinngamacinng nǝ uuram kǝskai taakiya ǝn dagata, ǝn da gwiiya saay da vakaru dlaɓa. Akwamamma waikwawaig mamma dlaig kwakyarvad ǝn daddavak Daada, aɗaba Daadara jakwarajiga. ");
INSERT INTO glwl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ndakwanna tagankurdataga lauti da dzǝgardzǝga, aɗaba mada dzǝghaardzǝga famdǝghǝrǝtfǝga. ");
INSERT INTO glwl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ən da madlai gwiiya taaghaiy ɗyak biya, aɗaba dadda kwara duunina sagauwa, maay dǝ ndzǝɗ tǝghǝr kǝskai biya. ");
INSERT INTO glwl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ən ɓa dǝgit ba kalkal kwa taghwa Daada ǝn ɓagaan aɗaba sǝran nǝ duni taakiya ǝn waigaan kǝ Daada. Ciiyamciiga ɗuyamantɗug kǝ vavakǝna.” ");
INSERT INTO glwl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kaiy nǝ gyigyiya uuffa inabi, Daadar dlaɓa iin dadda uusǝga. ");
INSERT INTO glwl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Aanji kwar kǝ dǝv uuf tǝ kai kwa maay yaa zǝr biya, ghudarsa. Aanji kwar kǝ dǝva uuf kwa yaayig kǝ zǝra gwiya ɓadlav kiyavva gwiya yigaan kǝ zǝr baɗyaka. ");
INSERT INTO glwl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Aanji bandakwan am ba cǝwaɗaɗa kwakyarvad ǝlbǝgǝn tagaankurda naina. ");
INSERT INTO glwl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ndzamandzǝg ma kaiya, kai dlaɓa ma kurama. Bandkwa yiga bi nǝ dǝva uufa inabi kǝ zǝr dǝ ghǝran biya, bamma ndzǝga tǝ uuffa inabi, ghǝravaru ndakwi bandkwah am yiga bi kǝ zǝr biya, ba mam ndzǝga tǝ kaiya. ");
INSERT INTO glwl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Kai ǝn uuffa inabi, kuram nǝ dǝvvahana. Daddakwa ndzǝga ma kaiya, kai dlaɓa ma iina, iin wa da ya zǝr baɗyaka. Aɗaba mam maay ǝmtaɗ dǝ kai biya, am ɓaga bi aanji ndau biya. ");
INSERT INTO glwl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Baɗǝm daddakwa ndza bi ma kaiy biya, band dǝva uuf kwa ɓǝlavdan ghulal, hulfakwah kǝ dǝva uufa dzaavanta ɗiivǝdǝm damma kaara, dlaɓa zuu. ");
INSERT INTO glwl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ma ndzamandzǝg ma kaiya, ǝlbǝgar dlaɓa ndzandzǝg ma kurama, am da ghalǝgaan baɗǝm kǝ dǝgit am naag nǝ uurama, am da tlǝkǝnatlǝga. ");
INSERT INTO glwl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ndzamandzǝg dǝ hǝnkala marawa kwada mardamarǝg taakiya kuram am mbǝrzahaara, band uuff kwa ya zarh marawa, aɗaba kwannahaan wa fǝgaara Daadara. ");
INSERT INTO glwl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Bandkwa waiyakut nǝ Daada, ǝn waiykur band kwah dlaɓa naiya. Ndzamandzǝg ma waiyavǝr bandkwa marankur da naiya. ");
INSERT INTO glwl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kaiya fanaarafǝg kǝ adzahadzaha Daadara, dlaɓa ǝn ndzǝga ma waiyavaana. Bandkwah dlaɓa, akwamamam fǝgaarafǝg kǝ adzahadzara am ndzǝga ma waiyavara. ");
INSERT INTO glwl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Tagkurdatag kǝ kwanna kwakyarvad dlaig ǝrviɗmahuɗara aa ndzandzǝg ma kurama, dlaiga ǝrivɗmahuɗaru dlaɓa aandz ba righǝgharighana. ");
INSERT INTO glwl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kwanǝn iin na adzahadzahara, waiyamwaiyig kǝ zaraabahagh band kwa waiyankurǝt naiya. ");
INSERT INTO glwl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Maay nǝ waiyavi jujig kǝ kwanǝn biya, taaki uuda vǝllada kǝ shiifǝgaan kwakyarvad tsaghwaana. ");
INSERT INTO glwl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Am tsaghwahahara akwama ɓagaan kǝ dǝgit tag naiya taakiya ɓagamɓaga. ");
INSERT INTO glwl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ən madlaiy gwiiya ɗakurɗag dǝ kwatanah biya, aɗaba kwatǝnaha sǝrǝgai kǝ dǝgiti ɓag nǝ daada biya. Dlakulǝva kwaha ǝn ɗakur dǝ tsaghwahaha aɗaba tagaankurtag kǝ dǝgiti cinngana naiy baɗǝm vak Daadara. ");
INSERT INTO glwl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kurambi wa kǝssamkwakǝssǝg biya, kai wa kǝssankuraakǝsǝga ǝn fankura kǝ dagal da yaa zǝr maraw kwa da zǝlmazǝlmǝga. Tǝhala kwaha da vǝllǝkurvǝllǝg Daad kǝ dǝgiti am ghalga nǝ uuram ma ɗagaan baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kwanna iin nǝ adzhadzahara waiyamwaig kǝ zaraabaha. ");
INSERT INTO glwl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Akwama ɗuwakursɗuug duniya, sǝramasǝrǝg taakiya ɗuwakwi kaiya lauti ɗuwa kurama. ");
INSERT INTO glwl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Akwamamma dǝga Duniya, duni ma waigaan kǝ dǝgaana, aɗaba am dǝga duni biya, dlaɓa kǝsankurakakǝsǝg ma duniya, iin wa nǝ iin ɗuuwakursɗug duniya. ");
INSERT INTO glwl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Dzamamdzamǝg kǝ ǝlbǝgahi tangankur naiya, ‘Kwatǝnah jigu bi kǝ dadda hǝnnyahaan biya.’ Akwama mbarkwambǝga, kuram ndakwi arda mbkurmbǝga. Akwama faraarafǝg kǝ tsagaanara, ar da fǝgaarafǝg kǝ ǝlbǝgaru dlaɓa. ");
INSERT INTO glwl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ar da ɓagkurɓag kǝ kwanahaana kǝ dǝgit baɗǝmma kwakyarvad ɗaagara, aɗaba ar sǝrǝga bi kǝ dadakwa ɓǝlakwadiɓǝlǝg biya. ");
INSERT INTO glwl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Akwama ndza sanhi bi ǝn tagtǝr kǝ ǝlbǝg biya, maraa ndzaa maay dǝ haip biya. Amaa ndakwanna, am maay dǝ ɗuula kyavaɗǝgv tǝghǝr kǝ haipahaatǝr biya. ");
INSERT INTO glwl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Daddakwa ɗuwakwiɗuuga ɗuugharsɗug kǝ baz Daadara. ");
INSERT INTO glwl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Bagannaɓag kǝ tlǝrah baɗyak ma iitǝra maay daddakwa tapghanitapǝg kǝ ɓagaan biya. Akwama ndza ɓaganna bi kǝ tlǝrahaan biya, maraa ndza maay dǝ haip biya. Ndakwanna nǝghǝghaaranǝghǝg kǝ dǝgit ǝn ɓaga naiya, bakǝva kwaha ɗuuwarkwiɗuga, dlaɓa ɗuuranɗug kǝ Daadara. ");
INSERT INTO glwl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Dzǝghardzǝg wanǝn kwakyarvad righǝvant nǝ ǝlbǝgǝn viindavan ma adzahadzah taakiya, ɗuuwarkwiɗug bagyaana. ");
INSERT INTO glwl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Mada sǝghawisǝg nǝ dadda mǝlkurmǝlǝga kwan da mǝllǝg naiya davakruwa vak daada, shǝɗkwa jiira, kwa sagal vak daada iin wa da ɓa shiid tǝghǝr kǝskaiya. ");
INSERT INTO glwl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kuram ndakwi am shiidaha, aɗaba bama daa zǝnngwa am ǝmǝtaɗ dǝ kaiya. ");
INSERT INTO glwl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Tagaankurtag kǝ kwanahaan kǝ dǝgitah baɗǝma haik da mɓǝg kǝskuram ma fadghǝraruwa. ");
INSERT INTO glwl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ar da lagwkurlagw sagal ma guda dzahavaha. Bak jijirra sagau nǝ sarta baɗǝm daddakwa tsa kurama da tlatlǝgaan taakiya ǝn ɓa kwatǝnahǝr kǝ Dadamzhigǝla. ");
INSERT INTO glwl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ar da ɓagkurɓag nǝ nndah kǝ kwannahaan kǝ dǝgitah aɗaɓa ar sǝrǝgai kǝ Daada bi kaiya biya. ");
INSERT INTO glwl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tagankurdatag kǝ kwannahaan kǝ dǝgitaha, aɗaba mada ɓagaɓag nǝ sarta, am da dzamnan taakiya tagankurdataga. Tagaankurdai kwan ma daa zǝngw biya aɗaba ndzan ǝmǝtaɗ dǝ kurama. ");
INSERT INTO glwl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Amaa ndakwanna ǝn dagat davak daddakwa ɓǝlakwadiɓǝlga. Bakǝvakwaha ma kurama maay nǝ daddakwa ndavghwadndavǝg taakiya, ‘Agha dagal da vakwar biya?’ ");
INSERT INTO glwl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Aɗaba naa tagankurdatag kǝ kwannahaan kǝ dǝgitaha, kaa badzaǝrivǝɗ kǝskurama. ");
INSERT INTO glwl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Bak jiir wan tagkur naiya, daasar wa maraw kǝsskurama, aɗaba ma danagha biya, maay da saay nǝ dadda kwada mǝlkurumelgǝn biya. Akwama danaghana ǝn da ɓǝllǝgaan saavakaruwa. ");
INSERT INTO glwl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Mada sǝghawisǝg nǝ dadda mǝlkurmǝlǝgna, da margarmarǝg kǝ duni taakiya kalkal bi nǝ dzamaghǝraatǝr tǝghǝr kǝ haip, jira, ard tǝghǝr sharriya. ");
INSERT INTO glwl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Dzamaghǝraatǝr tǝghǝr kǝ haipa kalkal biya aɗaba larwalǝg kǝ fadǝghǝr tǝ kaiya. ");
INSERT INTO glwl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Dzamaghǝraatǝra kalkal bi tǝghǝr kǝ jir biya, aɗaba ǝn daa da vak Daadara, dlaɓa am da madlai gwiiya nǝghǝghkwanǝghǝg biya. ");
INSERT INTO glwl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Dzamaghǝraatǝr tǝghǝr kǝ sharriya, aɗaba ɓagavaraɓag nǝ sharri kǝ dada kwarra kwan kǝ duni bawurra. ");
INSERT INTO glwl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Mǝng nǝ dǝgitah ǝn naa tagkur nai baɗyak ndana, am da dzǝgwanti ndakwan biya. ");
INSERT INTO glwl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mada sǝghawisǝg nǝ shiɗkwa jijiira, da mǝlkurumǝlǝg baɗǝm ma jiira, aɗaba da taa ǝlbǝga ghǝraan biya, da taa ba dǝgita aa ciingga nǝ iin kaltiya, dlaɓa da tagkurtag kǝ dǝgitah da dzǝgaaradzǝga. ");
INSERT INTO glwl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Da fǝkwarafǝg kǝskaiya, aɗaba da dlǝghgaan kǝ ǝlbǝgara dlaɓa da tagkur kǝskurama. ");
INSERT INTO glwl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Baɗǝm nǝ digiti dǝvakai nǝ Daada ba dǝgara, kwakyarvad kwah wanaa tag nai da dlǝghgaan nǝ shǝɗkw vakara da markurdana. ");
INSERT INTO glwl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Tǝhala sart hǝɗikǝna am da madlaiy nǝghkwanǝghǝg biya, tǝhala sart hǝɗikǝn dlaɓa am da nǝghkwanǝghǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Am kyǝlǝma mbǝrzah taa kǝ ghǝrahaatǝra, “Au nǝ dǝgiti tuuk vakai wa tag nǝ iin, ‘Tǝhala sart hǝɗikǝn am da madlai nǝghǝghkwanǝghǝg biya, tǝhala sart hǝɗikǝn dlaɓa am da gwiiya nǝghǝghkwanǝghǝgi?’ Dlaɓa au wa tlatlǝg nǝ iin dǝ taakiya, ‘Aɗaba ǝn daa da vak Daadarni’?” ");
INSERT INTO glwl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Kaa zavukw kǝ iitǝr dǝ ndavǝg taakiya, “Aauw wa tlatlǝg nǝ iin dǝ taakiya, ‘tǝhala sart hǝɗikǝni’? Kiyam sǝrgai kǝ dǝgit tlatlǝg nǝ iin biya.” ");
INSERT INTO glwl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Sǝrghaakasǝrǝg Yesu taakiya ar naa ndavagarundavǝg mbǝrzahaan tǝghǝr kǝ kwanǝn kǝ ǝlbǝga, amaa taa kǝ iitǝra, “Am ndavǝgaru kǝ ghǝraharu kǝ dǝgiti ǝn tlatlǝg nai dǝ taakiya, ‘Tǝhala sart hǝɗikǝna am da nǝghǝghkwa biya, tǝhala sart hǝɗikǝn dlaɓa am da nǝghǝghkwanǝghǝga’? ");
INSERT INTO glwl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Bak jiijiira ǝn tagkurtaga, sarti am da tuug dǝ badzǝga ǝrivǝɗmahuɗna, iin sarti da dlaig nǝ duniya, badzǝga ǝrivǝɗmahuɗaruwa da nǝg kǝ dlaiga. ");
INSERT INTO glwl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Akwama tsugwgharaatsug kungula yiig kǝ uusa mbǝkǝnmbǝg nǝ dlaɗ ba vaivaiya, aɗaba sart yigaan ɓagaaɓaga. Ma yaayig kǝ zǝra, kaa vigaraaviig kǝ dlaɗan aa mbakǝnmbǝgǝna aɗaba dlaiga kwakyarvad yaayig kǝ zǝr sama duniya. ");
INSERT INTO glwl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Bandkwaha vakaruwa. Ndakwana am badzǝga ǝrivǝɗa, amaa am da gwiya nǝghǝkwanǝghǝga dlaɓa tǝhala kwaha am da dlaiga, maay wa da kǝskurvakǝssǝg kǝ dlaigaru biya. ");
INSERT INTO glwl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ma kwahiin kǝ sarta kwahiina am da maay ghalgaan aanji ndau vakar biya. Bak jiir ǝn tagkurtaga, Daada da vǝllǝkurvǝllǝg baɗǝm kǝ dǝgit am ghallǝga nǝ uuram ma ɗagaara. ");
INSERT INTO glwl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Gwasǝtaan ghalamai aanji ndauw ma ɗagara biya. Ghalamghalǝga, am da tlǝkǝnatlǝga, aɗaba dlaigaruwa aandz ba righǝgharighaana.” ");
INSERT INTO glwl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Aanji tagankur bad ǝlbǝg dǝghur kǝ ǝlbǝga. Da sagau nǝ sarta kwan da madlaiy batlǝr dǝ hulfa kǝ ghaiy biya. Dlakulǝva kwaha, ǝn da tagkurtag bat Ballaɓala tǝghǝr kǝ daadara. ");
INSERT INTO glwl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ma kwahiina kǝ am da ghalǝg ma ɗaagara. Kai bi wada ghallǝgaan kǝ Daada ma guufkaru biya. ");
INSERT INTO glwl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Aɗaba Daadiin dǝ ghǝraana waiyakurwaiyga, kwakyarvad waiyamkutwaiyǝg kǝskaya, dlaɓa famdǝghǝrǝtfǝga taakiya sanhi vak Dadamazhǝgǝl naiya. ");
INSERT INTO glwl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Sanhi vak Daadiin naiya, dlaɓa sanhisǝg sama duniya, ndakwan dlaɓa ǝn ɗuugaan kǝ duniya ǝn gwiiya daddavak Daddina.” ");
INSERT INTO glwl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Aiyam mbǝrzahaana, ndakwan wagha tag nǝng kǝ tsalal ǝlbǝg bat ɓallaɓalla maay dǝ ǝlbǝg dǝghur biya. ");
INSERT INTO glwl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ndakwana nǝghamndakanǝghǝg taakiya agha sǝrgasǝrǝg kǝ dǝgitah baɗǝma. Agha sǝrgasǝrǝg kǝ ngugǝg ba kalkal lakwati ndavakndavǝg kǝ uuda. Kwanǝn waa fakǝmndafǝg kǝ fadǝghǝr taakiya sǝghi vak Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Kaa Nguwatǝrangug nǝ Yesu taakiya, “Kats! famdghǝrǝtfǝg ndakwanna? ");
INSERT INTO glwl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Sagau nǝ sarta, bak jirra ɓagaaɓaga kwamda kwazǝg nǝ uuram aanji kwararu da ǝmdrǝg daa da vǝgyaana am da ɗuukus kǝskai ba daavara. Bakǝvakwaha ǝn davar biya, aɗaba ǝmǝtaɗ dǝ kai nǝ Daada. ");
INSERT INTO glwl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tagaankurdatag kǝ kwannahaan kǝ dǝgitah, aɗaba ma kaiya am tlǝkǝna kǝ gabǝrǝra. Mahuɗa duuninna hǝbamuhǝɓǝg kǝ dlaɗa, ndzamandzǝg dǝ fǝrivǝɗ mahuɗa aɗaba zaanuzǝg kǝ firr tǝghǝr kǝ duniya.” ");
INSERT INTO glwl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tǝhala kwa tagada Yesu kǝ kwannahaan kǝ dǝgitaha, kaa dzǝgant kǝ ghǝraan daa kǝ ghǝrazhigǝl dzǝgwa kǝ zhigǝla amaa, “Daada, ɓagaaɓag sarta. Faarafǝg kǝ Zǝragh kwakyarvad iin ndakwi fǝkaarana. ");
INSERT INTO glwl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kwakyarvad vǝlghavǝlǝg kǝ ndzǝɗ kǝ Zǝr tǝghǝr kǝ uudah baɗǝmma, aɗaba vǝlda kǝ shiifǝga tangw damma zǝrazǝra kǝ lii vǝllǝgha nǝnga. ");
INSERT INTO glwl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Shiifǝga tangw damma zǝrazǝra iin taakiya, sǝrak nǝ uudaha, kǝgh Daadamazhigǝla jiira palba nǝnnga, dlaɓa ar sǝran kǝ Yesu Tlǝkatǝga kwa ɓǝlghǝdi nǝnnga. ");
INSERT INTO glwl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Fankaarafǝg ma duniya ghyinganaghyǝng tsau kǝ tlǝr vǝlghwa nǝnnga kǝ ɓagaana. ");
INSERT INTO glwl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ndakwan ciya, fǝkwaraafǝg Daada dǝ ndangǝri ndzan dǝ dǝvakaiy nai vakagh lakwti fǝvarzhafǝg nǝ duniya. ");
INSERT INTO glwl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Marankadamarǝg vak lii vǝlghwa nǝng ma duniya. Ba gwil wur ndzar ba dǝgagha, vǝlghwavǝlǝg nǝnng kǝ iitǝra, dlaɓa fararfǝg kǝ ǝlbǝgagha. ");
INSERT INTO glwl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ndakwana ar sǝrǝggasǝrǝg taakiya baɗǝm nǝ dǝgit vǝlghwa nǝngga sǝghal vak agha. ");
INSERT INTO glwl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kwakyarvad ǝlbǝgahaan tagghwa nǝngǝna tagantǝrtaga, dlaɓa dlǝgharadlǝga. Sǝraraakasǝrǝg bak jiijiira sanhi vakagha, dlaɓa fardǝghǝrǝtfǝg bakǝgh pal wa ɓǝlghkwadiɓǝlǝga. ");
INSERT INTO glwl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ən dzǝgwazhǝgǝl kwakyarvad iitǝra. Kwakyarvad uudaha duni biya, amaa kwakyarvad uudahi vǝllǝghwa nǝnnga, aɗaba ar dǝgha. ");
INSERT INTO glwl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Baɗǝm nǝ dǝgit ǝn dǝvakai naiya ba dǝgagha, dlaɓa baɗǝm nǝ dǝgit agha dǝvakai nǝnnga dǝgara. Dlaɓa maravdamarǝg nǝ ndangǝrara tǝdǝvad iitǝra. ");
INSERT INTO glwl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ndakwana ǝn da madlai ndzǝga ma duni biya, amma iitǝra ar bamma duniya, kai dlaɓa ǝn daas da vakagha. Daad Caccuwanacaccuwananna, katǝrkatǝg tǝdvad ndzǝɗa ɗaagagha, ɗaaga kwa vǝllǝghwa nǝngga, aɗaba ar nal kǝ palla, band kwa ki pal nǝmi dǝ kǝgha. ");
INSERT INTO glwl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ma sartǝn ndzan ǝmtaɗ dǝ iitǝra, katanrǝtkatǝg dǝ ndzǝɗa ɗaagagha, ɗaagǝn kwa vǝlghwa nǝngna. Katantrǝtkatǝga, maay wa zaazǝg aanji pal biya, ba kwapakǝna, aɗaba righǝvant nǝ ǝlbǝga Daadamazhigǝl viindaviinda. ");
INSERT INTO glwl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ndakwana ǝn daa da vakagha. Amaa ǝn ghala kwanǝn kǝ dǝgitah bamma sarti ǝn ba ndzǝgaan ma duniya kiyava righǝgh kǝ hwaɗagar ba vaivai ma ǝrivɗmahuɗaruwa. ");
INSERT INTO glwl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Tagaantǝrdatag kǝ ǝlbǝgha. Gwiyatǝrdagwig duni kǝ ilga, aɗaba ar dǝga duni biya, bandkwa kwan ǝn dǝga duni bi nai biya. ");
INSERT INTO glwl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ghalgaara iin bi taakiya agha hutsǝtǝrda dagal ma duuniyin biya, amaa ǝn ghalgara iin taakiya magha katǝrǝt vak tlǝkǝlaadǝna. ");
INSERT INTO glwl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Iitǝra ar dǝga duni biya, bandkwa kai ndakwi ǝn dǝga duni biya. ");
INSERT INTO glwl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pǝshtǝrapǝshig tǝdǝvad jiira, aɗaba ǝlbǝgaha iin jiira. ");
INSERT INTO glwl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Bǝlantǝrǝtɓǝlǝg damma duniya, bandkwa ɓǝlghkwadi nǝng kǝskaiya. ");
INSERT INTO glwl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ən pǝshig kwakyarvad iitǝra kǝ ghǝrara, aɗaba iitǝr ndakwi pǝshivtǝra bak jiira.” ");
INSERT INTO glwl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ghalgara kwakyarvad iitǝr kalti biya. Ən dzǝgwazhigǝl dlaɓa kwakyarvad lii fadǝghǝr tǝ kaiya tǝdǝvad ǝlbǝgaatǝra. ");
INSERT INTO glwl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Aɗaba baɗǝmaatǝra maraa nal kǝ palla, bandkwa agha ma kai nǝnga, kai dlaɓa ǝn ma kǝgha, ǝn ghalga iitǝr ndakwi maraa ndza ma kǝmiya, kwakyarvad uudaha duniya ar fǝdǝghǝrǝta taakiya kǝgh wa ɓǝlghkwadibǝlga. ");
INSERT INTO glwl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kaiya vǝllantǝrvǝllǝg kǝ uudah kǝ ndangǝr kwa vǝllǝghwa nǝngga, aɗaba ar nal kǝ pal band kwakǝyi pal nǝmiya. ");
INSERT INTO glwl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kai ma iitǝra, kǝgh dlaɓa ma kaiya, aɗaba ar nal kǝ pal ba vaivaiya, aɗaba sǝran nǝ duni taakiya kǝgh wa ɓǝlghkwadiɓǝlga, dlaɓa ar sǝran waightǝrantwaiga bandkwa waighkut nǝnnga. ");
INSERT INTO glwl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Daada, manaa naagaan maraa ndza nǝ uudahaan vǝlghwa nǝnngǝn ǝmǝtaɗ dǝ kai vakavaki dǝ kaiya, ǝn naagaan maraa nǝgha kǝ ndangǝragha, kwa vǝlghwa nǝnnga kwakyarvad agha waikwawaig lakwati virɗyav duniya. ");
INSERT INTO glwl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Daada, dadda jirra, uudaha duniya ar sǝrak biya, kaiya ǝn sǝraksǝrǝga, kwanǝn kǝ uudah dlaɓa ar sǝrǝgasǝrǝg taakiya kǝgh wa ɓǝlkwadiɓǝlǝga. ");
INSERT INTO glwl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Marantǝrdamarǝg kǝ ɗagagha, dlaɓa ǝn da zaavukw dǝ maratǝrmaraga, kwakyarvad waiyav kwa agha ɓagwa nǝng aa ndzan ma iitǝra, kai dlaɓa ǝn ndza ma iitǝra.” ");
INSERT INTO glwl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ghyǝnga ba Yesu dzǝgwazhigǝla, kaa dzǝva dlara Kidron kǝ iin ǝmtaɗ dǝ mbǝrazahaan da tǝ kwah ghyaba. Gyilga dlariina ndza mǝng ɗyaghaara guuha, kaa daas kǝ iin ǝmtaɗ dǝ mbǝrzahaan damma vakaiya. ");
INSERT INTO glwl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Sǝrgasǝrǝg Yahud kwa vǝlǝt Yesu kwahiin kǝ vakavaka, aɗaba nǝtnǝg Yesu kǝ dzahav dǝ mbǝrzahaan vakwahiina. ");
INSERT INTO glwl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kaa sagau kǝ Yahud dǝ dakwala tlauja ard lii uufakyawa Vǝgya Daadamazhigǝl kwa ɓǝlartǝrǝt mallaha zhiilakǝsuufah ard Farisiyaha, kaa dagal kǝ iitǝr damma ɗyaghaara guhiina, ar hakyahakya dǝ kaara jahuramba, ard zadah ard kadlanga ghwaava. ");
INSERT INTO glwl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Sǝrgasǝrg tsau Yesu kǝ dǝgitahi da dzǝgaar dǝ iin baɗǝmma, kaa sagal kǝ iina, amaa taa kǝ iitǝra, “War wam gatǝg nǝ uurami?” ");
INSERT INTO glwl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kaa ngwangug kǝ iitǝr, taakiya, “Yesu zhiila Nazaret.” Am Yesu taa kǝ iitǝra, “Kai nǝ iina.” (Yahuda kwa vǝlǝt Yesu ndakwi ghacǝga ǝmǝtaɗ dǝ iitǝra.) ");
INSERT INTO glwl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tagatǝr ba Yesu taakiya, “Kai nǝ iina,” kaa hazha da tǝ hal kǝ iitǝra, ar mɓǝɗa da tǝ haaya. ");
INSERT INTO glwl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kaa gwiya ndavǝtǝrundavǝg Yesu, amaa, “Am gata wari?” Aiyam nǝ iitǝr taa kǝ iina, “Yesu zhiila Nazareta.” ");
INSERT INTO glwl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kaa ngugangug kǝ Yesu amaa, “Ən naa ndza tagkurtag taakiya, ba kai nǝ iina. Akwamam gata ba kaiya, ɗuwamtǝrǝsɗug kǝ uudahaan dagala.” ");
INSERT INTO glwl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Dzǝghaar kwakyarvad righǝvant nǝ ǝlbǝgi tagada Yesu taakiya, “Ma uudahaan vǝlǝghwa nǝnngna, maay wa zaazǝg aanji pall biya.” ");
INSERT INTO glwl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Siman Bitrus kwa ndza dǝ katsakara, tǝɗadatǝɗǝg kǝ katsakar ghudarda kǝ hyimiya dǝvakaf kǝ kwatǝnaha maal ba tingting ma zhiilakǝsuufaha. Ɗaaga kwanǝn kǝ kwatǝnaha Malkus. ");
INSERT INTO glwl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Am Yesu taa kǝ Bitrusa, “Gwidaagwig kǝ katsakaragh damma kumbǝghaana. Ən maay da hǝɓǝgaan ma kuwǝn kwa vǝlǝghwa Daad ǝn hǝɓu biya?” ");
INSERT INTO glwl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kaa vigǝtviig dakwala tlauja ard tlǝvukwatǝra, ard lii uufakyawa Vǝgya Daadamazhigǝla Yahudah kǝ Yesu, ar nguɗǝnana. ");
INSERT INTO glwl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kaa lanngaan kǝ iitǝr ba zunngw da vak Hannana, dadda uusa Kayafa. Kayafa wa ndza maal ba tingting ma zhiilakǝsuufah ma kwahiin kǝ viiga. ");
INSERT INTO glwl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa wa ɗiyatǝra sawari kǝ Yahudah taakiya, ngulǝm ǝmǝtsa nǝ uud pall dlakulva kyalǝma uudaha. ");
INSERT INTO glwl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Kaa gata Yesu kǝ Siman Bitrus ard kwatlǝrǝn kǝ mbǝrz tǝ halaa. Kwanǝn kǝ mbǝrza, sǝrǝgasǝrǝg maal ba tingting ma zhiilakǝsuufahǝn kǝ iina, kaa daas kǝ iin damma huɗa gaagazaiya vǝgya maal ba tingting ma zhiilakǝsuufahǝn ǝmǝtaɗ dǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Kaa ghacǝgaghacǝg kǝ Bitrus tǝ ghaiya wakyagha. Kaa gwiya sagal kǝ mbǝrzǝn kwa sǝrǝgasǝrǝg maal ba tingting ma zhiilakǝsuufahǝn da taa ghai dǝ dǝghwa hǝnyaha zhiilakǝsuufǝn tǝ ghaiya wakyagha, tǝhala kwaha, sǝdaa kǝ Bitrusa. ");
INSERT INTO glwl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Aiyam nǝ dǝghwǝn uufa wakyaghǝn kǝ Bitrusa, “Agha maay kwan nǝnng pall ma mbǝrzaha uudanǝn biya?” Ngwangug nǝ Bitrus amaa, “Ən maay ma iitǝr biya.” ");
INSERT INTO glwl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ndza akuhy vakka, kaa mbiigantmbiig kǝ kwatǝnahah ard lii uufakyawa kǝ kaara ghuvǝr ar ghacaraan ar cinnga hurfakaana, Bitrus ndakwi ndza ghacǝgan ǝmtaɗ dǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kaa ndavǝgarundavǝg maal ba tingting ma zhiilakǝsuufah kǝ Yesu tǝghǝr kǝ mbǝrzahaana ard tsagaanana. ");
INSERT INTO glwl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Kaa ngughwarangug Yesu taakiya, “Tagandatag kǝ ǝlbǝg ba tǝ ɓalaɓal tǝvukwa uudah baɗǝmma, dlaɓa tlakwatlǝg tsagaan ma guda dzahavaha ard Vǝgya Daadamazhigǝla, vakavaki dzahavǝt Yahudah baɗǝmma. Tappana bi kǝ taa dǝgiti shǝɓashǝɓan biya. ");
INSERT INTO glwl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Iyau, agha ndavǝgwa da ɓaw kaci kǝ ndavǝgahi? Ba agha ndavtǝru kǝ lii cinngaracinng kǝ dǝgiti tagantǝr nai kǝ ndavgahaana, aɗaba ar sǝrgasǝrǝg kǝ dǝgiti taganda naiya.” ");
INSERT INTO glwl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tagada ba Yesu kǝ kwaha, kaa tsǝgaan kǝ pall ma lii uufakyau kwa ghacǝganǝn dǝ mahupeng kǝ Yesu, amaa, “Agha ngugugar ndkwan kǝ maal ba tingting ma zhiilakǝsuufaha?” ");
INSERT INTO glwl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Kaa ngwangug kǝ Yesu taakiya, “Akwama mǝng dǝgiti kwa naa tagǝda nai ghwaɗa, marwadamarǝg kǝ ghwaɗǝraana. Akwama ba jiir nǝ dǝgiti naa tagda naiya, aujilbǝg kaci agha tsa kaiyi?” ");
INSERT INTO glwl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kaa ɓǝlgantɓǝlǝg Hannana kǝ uudah dagal dǝ Yesu nguɗanguɗan da vak Kayaf maal ba tingting ma zhiilakǝsuufaha. ");
INSERT INTO glwl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Gwastaan ba ndzǝganaan Bitrus ba ghacǝga vakwah tǝghǝr kǝ kaara cinnga hurǝfaka. Kaa ndavǝgarundavǝg kǝ kyalmah taakiya, “Aayaa, agha maay nǝnng kwan pall ma mbǝrzahaan biya?” Kaa ɓala gajau kǝ Bitrus amaa, “Ən maay ma iiter biya.” ");
INSERT INTO glwl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Am pall ma kwatǝnaha maal ba tingting ma zhiilakǝsuufaha. Yiiga kwa ghudǝgharda Bitrus kǝ hyimi na, amaa taa kǝ Bitrusa, “Mbats nǝghankak bi ǝmtaɗ dǝ iin ma guhiin kwan biya?” ");
INSERT INTO glwl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kaa gwiya ɓala gajau kǝ Bitrusa. Tǝhala kwaha, kaa wiig kǝ ghwatkala. ");
INSERT INTO glwl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kaa sǝdasǝg kǝ tlǝvuukwa Yahudah kǝ Yesu sagal ma vǝgya Kayafa da vǝgya gumǝna Roma. Ma sartǝn lanngar nǝ iitǝrna, cagaacag nǝ kǝsa. Kaa lǝwalǝg kǝ iitǝr daa damma huɗa gaagazaiya, hai kǝ ndzǝgana kwadlambǝr kǝ iitǝr tǝvuukwa Daadamazhigǝl kwa da tsava iitǝr kǝ zaa kafa hwaɗaga haarakǝsa dzava hǝnnyaha. ");
INSERT INTO glwl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mbakyarvad kwaha, kaa sǝgalsǝg kǝ Bilatus saa vakaatǝr gyimala, amaa, “Hulfa kwar kǝ ɗiya ghunj wa maa sǝdǝv nǝ uuram tǝghǝr kǝ kwan kǝ uudi?” ");
INSERT INTO glwl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kaa ngugwangug kǝ iitǝr taakiya, “Akwama dadda haip bi nǝ iin biya, ma kǝmnda maay lanngaan saa vakagh biya.” ");
INSERT INTO glwl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Am Bilatus taa kǝ iitǝra, “Lanngamlanng dagal ba dǝ ghǝraruwa, am ghudarda kǝ sharri kalkal dǝ adzahadzaharuwa.” Aiyam Yahudah taa kǝ iina, “Vǝlakǝmnd bi nǝ uud kǝ ndzǝɗa ghudǝgarda tsa shifǝg kǝ uud biya.” ");
INSERT INTO glwl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Dzǝghaar kwakyarvad righǝvant nǝ ǝlbǝgi tagada Yesu tǝghǝr kǝ hulfa ǝmtsǝgi da ǝmtsǝg nǝ iina.) ");
INSERT INTO glwl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kaa gwiya daas kǝ Bilatus daa damma gaagazaiya tlǝkǝsa, tǝhala kwaha kaa ɗagantɗaag kǝ iin kǝ Yesu ndavaru amaa, “Kǝgh Tlǝkǝsa yaa Yahuda?” ");
INSERT INTO glwl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Kaa ngugwarangug Yesu amaa, “Kwan kǝ ndavǝg aa sǝgal ma ghǝragh nii, uudahi tlǝrn ha wa tagakaktag kǝ ǝlbǝg tǝghǝr kǝskaiyi?” ");
INSERT INTO glwl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Kaa ngungangug Bilatus amaa, “Ən zhiila Yahudah naiya? Sarkadǝv zarabahagh Yahudah ard maal ba tingting ma zhiilakǝsuufah saa vakara. Au waghaa ɓaga nǝnngi?” ");
INSERT INTO glwl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Aiyam Yesu taa kǝ iina, “Tlǝkǝsǝrara dǝga kwan kǝ duni biya. Akwama dǝga kwan kǝ duni tlǝkǝsǝrara, maraa ɓagaan kwatǝnahar kǝ ghwaav maa hai kǝ vikwaviig kǝ Yahudaha. Amma tlǝkǝsǝrar vakavaki tlǝrna.” ");
INSERT INTO glwl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Aiyam Bilatus taa kǝ iina, “Kats agha tlǝkǝsa?” Kaa ngugwarangug kǝ Yesu amaa, “Kǝgh dǝ ghǝragh waa tagda taakiya ǝn tlǝkǝsa. Yaakwi kwakyarvad kwan nǝ uuda, dlaɓa sanhi kwakyarvad kwan sa ma duniya, aɗaba ǝn ɓaga kǝ shiida jiijiira. Dlaɓa baɗǝm daddakwa dǝga jiira, cinngaan kǝ ǝlbǝgara.” ");
INSERT INTO glwl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Kaa ndavǝgarundavǝg kǝ Bilatus amaa, “Au jiiri?” Ndavǝgharu ba nǝ iin kwan kǝ ndavǝga, kaa gwiya sagal kǝ iin sa vak Yahudaha amaa taa kǝ iitǝra, “Viyanǝt bi nai dǝ haip biya. ");
INSERT INTO glwl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Amma mǝnng nǝ dǝga daadijaharuwa, akwama ɓagaaɓag sarta hwaɗaga haarakǝsa dzǝva hǝnnyaha, ǝn ɓǝlkursɓǝlg kǝ uud pall ma guda bǝrfǝnga. Am naagaan ǝn ɓǝlkurnǝs kǝ tlǝkǝsa Yahudaha?” ");
INSERT INTO glwl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kaa gwiya ngugǝg kǝ iitǝra, ar ɗiyaru kǝ cauw ar taakiya, “Maaya kwan biya, Barabbas wa kǝm naag nǝmnda.” (Barabbas ndza dadda zaaɗuula.) ");
INSERT INTO glwl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kaa vǝldavǝlǝg Bilatus kǝ Yesu kiyava kalǝga. ");
INSERT INTO glwl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kaa faɗgafaɗǝg tlaujah kǝ dzakwa tlǝkǝs kwa ɓagava dǝ dǝva taka ar tsǝgwardǝm maghǝr kǝ Yesu, tǝhalakwah ar tsǝgwardǝm kǝ sǝɗav kyanng hulfa dǝga tlǝkǝssaha. ");
INSERT INTO glwl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ar gwayashig sa vakaana, ar ɓalgar mahupennga, ar taakiya, “Kǝm ma barkagha, tlǝkǝsa Yahudaha!” ");
INSERT INTO glwl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Kaa gwiya sagal kǝ Bilatusa, amaa kǝ Yahudahi faɗǝga vakwahiina, “Waiyam ciya ǝn lanngkurlanng kǝ Yesu sagala, kwakyarvad ǝn naagaan am sǝra taakiya viyanǝti dǝ haip biya.” ");
INSERT INTO glwl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kaa sagal kǝ Yesu dǝ dzakwa tlǝkǝs dzakwa tak ma ghǝraan dlaɓa dǝ sǝɗav kyannga. Aiyam Bilatus taa kǝ iitǝra, “Waiyam nǝ uuda nǝ iina.” ");
INSERT INTO glwl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nǝghǝghaara ba maalah ma zhiilakǝsuufah ard lii uufakyawa Vǝgya Daadamazhigǝl kǝ Yesu, kaa ɗiya cau kǝ iitǝr ar taakiya, “Aa hǝrtǝvǝthǝrtǝga! Aa hǝrtǝvǝthǝrtǝga!” Am Bilatus taa kǝ iitǝra, “Damdagal am hǝrtǝt bad ghǝraruwa, aɗaba tlankǝna bi nai kǝ iin dǝ haip biya.” ");
INSERT INTO glwl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Kaa ngugarangug kǝ Yahudah taakiya, “Kǝm da adzahadzaha, dlaɓa tǝdvad adzahadzahamnda, barari tsǝvana, aɗaba nadalnǝg kǝ ghǝraan kǝ Zǝra Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Cinngha ba Bilatus kǝ kwanǝn kǝ ǝlbǝga, kaa gwiya gǝdzǝg kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kaa gwiya daas kǝ iin damma huɗa vǝgyaana, ndavaru kǝ Yesu taakiya, “Agha sagal vakwari?” Amma lawalǝg Yesu kǝ ngugarngugga. ");
INSERT INTO glwl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Aiyam Bilatus taa kǝ iina, “Lǝghwalǝg kǝ taa ghai dǝ kaiya? Agha sǝrǝgai taakiya ǝn dǝ ndzǝɗa ɓǝlǝkǝsɓǝlǝga ard ndzǝɗa hǝrtǝkǝthǝrtǝg biya?” ");
INSERT INTO glwl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Am Yesu taa kǝ iina, “Agha maay dǝ ndzǝɗ tǝghǝr kǝskai akwama vǝllakaki nǝ uud sii ma ghǝrazhigǝl biya. Kwakyarvad kwaha daddakwa fakwadǝm ma dǝvvagha jakujig dǝ haipa.” ");
INSERT INTO glwl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tǝhala kwanǝn kǝ ǝlbǝga, kaa ba gata ɗuula ɓǝlgaars Yesu nǝ Bilatus, amma Yahudaha ar za ba vukw dǝ ɗiya cau ar taakiya, “Akwama ɓǝlgharǝsɓǝlǝg kǝ kwan kǝ uuda agha madlai tsaghwa Kaisar biya. Baɗǝm daddakwa nadalnǝg kǝ ghǝraan kǝ tlǝkǝsa, ciigar hǝnkal kǝ Kaisara.” ");
INSERT INTO glwl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Cinngha ba Bilatus kǝ dǝgiti tagar nǝ iitǝra, kaa sagal kǝ iin dǝ Yesu, kaa cǝhurgacǝhurǝg Bilatus tǝ avǝda shari tǝ akur hahaana. Dǝ ghaiya Yahudaha ɗahav dǝ Gabbata. ");
INSERT INTO glwl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Daghuvala kwahina, ndza faciya ɓadlava hwaɗaga haarakǝsa dzava hǝnnyaha, tamaha faci tǝghǝra. Aiyam Bilatus taa kǝ Yahudaha, “Waiyam Tlǝkǝsaruwa!” ");
INSERT INTO glwl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Kaa ɗiya cau kǝ Yahudaha ar taakiya, “Aa tsǝvatsǝɡa! Aa tsǝvatsǝga! Aa hǝrtǝvǝthǝrtǝga!” Kaa ndavtǝrundavǝg kǝ Bilatus amaa, “Am naagaan ǝn hǝrtǝt kǝ Tlǝkǝsaruwa?” Kaa ngugangug kǝ maalah zhiilakǝsuufaha, am nǝ iitǝra “Kǝm maay dǝ kwatlǝrǝn kǝ tlǝkǝs biya, ba Kaisara.” ");
INSERT INTO glwl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tǝhala kwaha, kaa vǝldavǝlǝg Bilatus kǝ Yesu kiyava hǝrtǝga. Kaa daddǝg kǝ tlaujah kǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tǝghǝrdǝga sagal Yesu ma kǝsiin kǝsa tlaɓa hǝrtǝgaan ba dǝ ghǝraan da vakavakǝn kwa ɗahav dǝ kuwa ghǝra. (Dǝ ghaiya Yahudaha ɗahav dǝ Golgota nǝ wanǝn kǝ vakavaka. ");
INSERT INTO glwl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hǝrtavǝt vaakwahiin Yesu, ǝmtaɗ dǝ uudah buwa, pal tǝ dǝvva kafaana, pal dlaɓa tǝ dǝvva ghyaɓaana, iin ma taataka. ");
INSERT INTO glwl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Vindavindǝg Bilatus kǝ ǝlbǝga, kwa favva tǝ tlaɓa hǝrtǝga. Dǝgiti vindavana, iin taakiya “YESU ZHIILA NAZARET, TLƏKƏSA YAHUDAHA.” ");
INSERT INTO glwl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Karantarakarantǝg Yahudah ba ɗyak kǝ kwanǝn kǝ ǝlbǝga aɗaba vakavakǝn hǝrtavǝt dǝ Yesu na, ba hyaf dǝ kǝs ɗyaka. Kwanǝn kǝ vindǝg dlaɓa vindava ma ghaiya Yahudaha, ard ghaiy Romaha, ard Heleniyaha. ");
INSERT INTO glwl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Aiyam maalah ma zhiilakǝsuufaha Yahudah taa kǝ Bilatusa, “Vind bi taaki, ‘Tlǝkǝsa Yahudah,’ biya, vindavindǝg taakiya, ‘Am nǝ uudanǝnna, ǝn Tlǝkǝsa Yahudaha.’ ” ");
INSERT INTO glwl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kaa ngutǝranngug Bilatus taakiya, “Dǝgiti naa vinndǝga naiya, ndzandzǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Hǝrtarǝt ba tlaujah kǝ Yesu, ar hutsu kǝ sǝɗavahaana, ar tagwnan hutsǝg uufaɗa, aanji kwar kǝ tlauja kǝsuukǝsǝg kǝ hutsǝg palla. Ar kǝsuu baz sǝɗavaani tlaɗ kwama huɗmahuɗa, kwa havǝt dǝ hǝgga ciigǝt ma ghǝr ba dǝtl da tǝ haaya. ");
INSERT INTO glwl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Aiyam nǝ iitǝr kǝ ghǝrahaatǝra, “Tahǝyamna bi kǝ sǝɗavǝn biya, tsǝyamtsǝg kǝ tsats tǝghǝra, kiyam vazǝgaan kǝ dadakwa da zǝgaana.” Dzǝghardzǝg wannǝn kwakyarvad righǝvant nǝ dǝgiti vindava ma kakkaɗa Daadamazhigǝla taakiya, “Tagwarutagw kǝ sǝɗavahar ma taatakaatǝra, ar tsak kǝ tsats tǝghǝr kǝ sǝɗavahara.” Dǝgiti ɓagara tlaujah waha. ");
INSERT INTO glwl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Lii ghacara tǝvǝgh kǝ tlaɓahǝrta Yesu, iitǝr naz Babbaana, batlǝrɗaana, ard Maryam uusa Kilobas, ard Maryamu Magadala. ");
INSERT INTO glwl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nǝghǝgha ba Yesu kǝ babbaana ard mbǝrzǝn kwa waig nǝ iin ghacǝga ba hyafa, aiyama taa kǝ babbaana, “Uusǝna, wan zǝragha!” ");
INSERT INTO glwl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Aiyama kǝ mbǝrzǝn tǝ hala kwaha, “Nalnǝg nǝ uusǝn kǝ baabagha!” Ciigǝt ma kwahiin kǝ sarta, kaa lanngaan kǝ mbǝrzǝn kǝ babba Yesu da vǝgyaana. ");
INSERT INTO glwl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Sǝrghasǝrǝg Yesu taakiya, ma kwahiin kǝ sarta ghyǝnnghanaghyǝnng kǝ ɓa dǝgitah baɗǝmma, kwakyarvad righǝvant nǝ dǝgiti vindava ma kakkaɗa Daadamazhigǝla, aiyama, “Njakwanjiig nǝ andǝlla.” ");
INSERT INTO glwl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Vakwahiin ndza mǝng nǝ ɗagw righarighaan dǝ yuwa inabi kwarekrekka fǝgana. Kaa rǝmnarǝmng kǝ iitǝr kǝ abarabar ma yuwa inabi kwarekrekka, ar fǝt tǝ zadda izob ar kapanta ar farǝt tǝ ghai kǝ Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Dlǝghaa ba Yesu kǝ yuwǝn kwarekerek na, amaa, “Ghyǝnngaghyǝnnga!” Tǝhala kwaha tsǝdi kǝ ghǝraana, vǝlda kǝ shifǝgaana. ");
INSERT INTO glwl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ndza daghuvala ɓadlav tsauwa, dlaɓa dlakadurana faciya ngiiga kwa shah dǝ kyalma faciya ngiiga. Aɗaba ar naay tlǝvuukwa Yahudah kǝ ɗuwa tluwa vǝghaha uudah tǝ tlaɓa hǝrtǝg daghuvala faciya ngiig biya, kaa ghalla Bilatus kǝ Yahudaha maa kalǝvana shigahaatǝra, dlaɓa maa sǝvdi tluwa vǝghahaatǝr tǝ tlaɓa hǝrtǝga. ");
INSERT INTO glwl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kaa sagau kǝ tlaujah ar kalna kǝ shigaha uuda zunngw kwa hǝrtavǝt ǝmtaɗ dǝ Yesu, ard shigaha daddakwa pallǝna. ");
INSERT INTO glwl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Amma sarǝv ba nǝ iitǝr da vak Yesu, kalarna bi kǝ shǝgaan biya aɗaba tlarara ǝmtsaaǝmǝtsǝga. ");
INSERT INTO glwl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kaa ghwugaan kǝ pal ma tlaujah kǝ Yesu dǝ guup ma dlǝmbǝla, kaa sagal kǝ avǝz ard yu ba watswatsa. ");
INSERT INTO glwl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Daddakwa nǝghǝghanǝghǝga kǝ dǝgitahi dzǝghaardzǝg wa vǝlada shiida, shiidi vǝlada nǝ iinaa ba jiira. Ba Iin dǝ ghǝraan ndakwi sǝrǝgasǝrǝg taakiya jiir wa tag nǝ iina, vǝlada kwakyarvad am fǝdghǝrǝta. ");
INSERT INTO glwl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Dzǝghaar kwakyarvad rǝghǝvant nǝ dǝgitahi vindava ma Kakkaɗa Dadamazhǝgǝla, “Maay aanji pal ma tlatlaan wa da kǝlav biya.” ");
INSERT INTO glwl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Band kwa vindava vakavaki tlǝrǝn ma Kakkaɗa Dadamazhigǝl taakiya, “Ar da vazǝgaan kǝ daddakwa ghwara nǝ iitǝra.” ");
INSERT INTO glwl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tǝhala kwaha, am nǝ Isuvu zhiil Arimatiya mbǝrza Yesu, amma shǝɓashǝɓan kwakyarvad gǝdza tlǝvuukwaha Yahudaha, kaa ghala Bilatus maa vǝlar kǝ tluwa vǝgha Yesu. Haigharanthaig Bilatusa, kaa dagal kǝ iin kǝssant kǝ tluwa vǝgha Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimus kwa tapghana sa vak Yesu kavǝɗa, daral ǝmǝtaɗ dǝ Isuvu, sadǝvsǝg kǝ tǝrshana mur ard alos uushauushana, tamaha kilo kulhǝkǝrɗa. ");
INSERT INTO glwl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kaa kǝsǝgantkǝsǝg kǝ uudahaan buwǝn kǝ tluwa vǝgha Yesu ar ngwaɗnan ma kǝlǝpakan ard kadlannga tǝrshǝn bǝtbǝta kwakyarvad dǝga daadijatǝr kǝ Yahudah akwa mar hǝɗa uuda. ");
INSERT INTO glwl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Vakavakǝn hǝrtavǝt nǝ iinna, ndza mǝnng ɗyaghaara guuha, ma ɗyaghara guuhiina dlaɓa ndza mǝng nǝ daalla gǝtl kwa tapavnai hǝɗa uud ma vakaiy biya. ");
INSERT INTO glwl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ndza daghuvala faciya ɓadlava Yahudah tsauwa, dlaɓa ba hyaf gǝtl dǝ iitǝra, ar fǝdǝm kǝ tluwa vǝgha Yesu ma vakaiya. ");
INSERT INTO glwl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Dlakadur ba wur daghuvala hǝnnga zunngw ma maaka, lakwti cag kǝsa, kaa ba dagal kǝ Maryamu magadala damma gǝtlaha, nǝghǝgha ba tlǝgavarwatlǝg nǝ akur tǝ ghaiya gǝtla Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kaa ǝmndǝra saas kǝ iin da vak Siman Bitrus ard mbǝrz kwa waig Yesu, amaa taa kǝ iitǝra, “Kǝsavdakǝsǝg Yazhigǝl sagal ma gǝtla, kǝm sǝrga bi kǝ vakavaki araa fǝga nǝ iitǝr biya.” ");
INSERT INTO glwl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kaa sagal kǝ Siman Bitrus ard mbǝrzǝn ar viyǝt kǝ ɗuula dagal damma gǝtla. ");
INSERT INTO glwl_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kaa ǝmndǝra dagal kǝ iitǝr ba bǝrkuɗaatǝra, jighaarajig mbǝzǝn pallǝn kǝ Siman Bitrus dǝ ǝmndrǝga, dlaɓa dagha nǝ iin tǝghǝr kǝ Siman Bitrus da vaka gǝtla. ");
INSERT INTO glwl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ngǝghǝra kǝ iin vazanan damma vakaiya, kaa nǝghǝghgaanǝghǝg kǝ iin kǝ kǝlpakan ɓǝlgana, amma dagha bi damma gǝtliin biya. ");
INSERT INTO glwl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kaa sagau kǝ Siman Bitrus tǝ halaana, kaa ba daas kǝ iin damma gǝtla, kaa nǝghǝganǝghǝg kǝ iin kǝ kǝlpakan ɗiigana. ");
INSERT INTO glwl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Nǝghǝghanǝghǝg dlaɓ kǝ sǝɗavǝn kwa faɗavan dǝ ghǝra Yesu ɗiigaan vakavaki tlǝrǝn shah dǝ kǝlpakana. ");
INSERT INTO glwl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kaa dǝgaadǝg baz mbǝrzǝn kwa tsugwa ba zunngw tǝghǝr Siman Bitrus damma vakaiya. Nǝghǝgha ba nǝ iina, kaa fǝdǝghǝrǝtfǝga. ");
INSERT INTO glwl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Gwaastǝn nǝgharaaka bi kǝ dǝgiti vindava ma kakkaɗa Daadamazhigǝl kwa taakiya, barari da ciig Yesu dǝ shifǝga.) ");
INSERT INTO glwl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kaa gwiya daas kǝ mbǝrzahaan da vaka ndzǝganaatǝra. ");
INSERT INTO glwl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ghacaghacǝg Maryam tǝ ghaiya gǝtl gyǝmala, tuuga. Ba tuug nǝ iina, kaa ngǝghǝrangǝg zhara damma gǝtla, ");
INSERT INTO glwl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Kaa nǝghǝghgaanǝghǝg kǝ inn kǝ zarha ɓǝlg buw ar ma sǝɗav maɗǝkw ar cǝhurgan vakavaki ndza dǝ tluwa vǝgha Yesu. Zǝrɓǝlǝg palla cǝhurga vaka ghǝra, kwah dlaɓ cǝhurga vaka shǝgahaana. ");
INSERT INTO glwl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kaa ndavǝgarundavǝg kǝ Zǝrha ɓǝlgah taakiya, “Uusǝna, au wagha tuug nǝngi?” Aiyama taa kǝ iitra, “Kǝsavuukǝssǝg Yaazhigǝlara, ǝn sǝrǝgai kǝ vakavaki aa fǝvva dǝ iin biya.” ");
INSERT INTO glwl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tagada ba nǝ iin kǝ ǝlbǝgna, kaa gwivǝtgwiga nǝghǝgha ba Yesu ghacǝgana, amma nǝghǝghaaka bi taakiya iin biya. ");
INSERT INTO glwl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Kaa ndavǝgarundavǝg kǝ Yesu taakiya, “Uusǝna, aaujilǝbǝg kǝskǝgh tuugi? War wagha gatǝg nǝnngi?” Ma tlǝg nǝ iin daddakwa ɓa tlǝr ma ɗyaghaara guhiina, aiyama taa kǝ iina, “Dadda hǝnnyaha, akwama kǝgh wagha kǝsǝgantkǝsǝga, tagwatag kǝ vakavaki agha fǝga nǝnnga, kwakyarvad ǝn kǝsanta.” ");
INSERT INTO glwl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Aiyam Yesu taa kǝ iina, “Maryama!” Kaa gwivǝt kǝ iin da vak Yesu amaa kǝ iin dǝ ghaiya Yahudaha, “Rabboni!” Dǝgiti tuuk vakaiya nǝ iina, dadda tsaga dǝgita. ");
INSERT INTO glwl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Am Yesu taa kǝ iina, “Hǝkykwa biya, aɗaba danǝti davak Daad ndan biya. Amma dǝg davak zaraabahar tagtǝrtag taakiya, ǝn dagat da vak Daadara, dlaɓa Daadaruwa, Daadamazhigǝlara, dlaɓa Daadamazhigǝlaruwa.” ");
INSERT INTO glwl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kaa dagal kǝ Maryam Magadala da tagtǝr kǝ mbǝrzaha, amaa “Nǝghananǝghǝg kǝ Yaazhigǝla.” Tagtǝr dlaɓ kǝ dǝgiti taghar Yesu. ");
INSERT INTO glwl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ɓǝlaa ba hwaas daghuvala hǝnnga zǝngw ma maaka, kaa dzahvǝtdzahǝg kǝ mbǝrzaha vak palla, dlaɓa ar ngahant kǝ ghaiya gudah mbakyarvad tlǝvuukwa Yahudaha. Kaa tsugwatsugw kǝ Yesu ma taatakaatǝr amaa, “Gabǝr tǝghǝr kǝskurama.” ");
INSERT INTO glwl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tǝhala kwa tagada nǝ iin kǝ kwanǝn kǝ ǝlbǝga, kaa martǝrdamarǝg kǝ iin kǝ dǝvvahaan ard dlǝmbǝlaana. Kaa dlaiga kǝ mbǝrzah nǝghǝghara ba nǝ iitǝr kǝ Yazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Am nǝ Yesu taa kǝ iitǝr gwiya daala, “Gabǝr tǝghǝr kǝskurama! Bandkwa ɓǝlakut Daada, kai ndakwi ǝn ɓǝlkur bandkwaha.” ");
INSERT INTO glwl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tagada ba nǝ iin kwaha, kaa fǝrtǝrdǝm kǝ shifǝgaana, amaa taa kǝ iitǝra, “Dlǝghamdlǝghǝg kǝ Shǝɗkwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Baɗǝm dadda kwam ɓǝshgarnaa nǝ uuram kǝ haipahaana, ɓǝshavarnaɓǝshiga, dlaɓa baɗǝm dadda kwa ɓǝshamarnaa biya, ɓǝshvarnaa biya.” ");
INSERT INTO glwl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tuma kwa ɗahav dǝ ghwalaha, pall ma mbǝrzah kǝlaawa tar buwa, ndza, maay ǝmǝtaɗ dǝ iitǝr ma sartǝn sagha Yesu biya. ");
INSERT INTO glwl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Am kyalǝma mbǝrzahan taa kǝ iina, “Nǝghamdanǝghǝg kǝ Yaazhigǝla!” Aiyam Tum taa kǝ iitǝra, “Akwama nǝghana bi kǝ ɗuula amsams ma dǝvvahaan biya, ǝn fǝm kǝ zǝra dǝvvar ma ɗuula amsams biya, dlaɓa ǝn fǝm kǝ dǝvvar ma dlǝmbǝlaan vaka ghuga guup biya, ǝn fǝdǝghǝrǝt biya.” ");
INSERT INTO glwl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tǝhala maaka, kaa gwiya dzahvǝtdzahǝg kǝ mbǝrzaha vak palla ma hǝnnyahiina, dlaɓa Tuma ǝmǝtaɗ dǝ iitǝra. Ghaiya gudah ndakwi ngahangahana, kaa tsugwatsugw Yesu ma taatakaatǝr amaa, “Gabǝr tǝghǝr kǝskurama.” ");
INSERT INTO glwl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tǝhala kwah amaa taa kǝ Tuma, “Faffǝg kǝ zǝra dǝvvagh vaakwana, vazǝg kǝ dǝvvahara. Vǝlǝg kǝ dǝvvagh faffǝg damma dlǝmbǝlara. Ɓag bi kǝ ndaundau biya, fǝdǝghǝrǝtfǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Am Tum taa kǝ iina, “Yaazhigǝlara ard Daadamazhigǝlara!” ");
INSERT INTO glwl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kaa tagartag Yesu taakiya, “Aɗaba aghaa nǝghǝkwadnǝghǝg iin wagha fǝghǝdǝghǝrǝt nǝnnga. Bark kǝ lii nǝgharkwa biya dlaɓa fardǝghǝrǝtfǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ɓagaaɓag Yesu kǝ dǝga sǝrgah ba ɗyak ma gyiyaha mbǝrzahaana, kwa viindava bi ma kwanǝn kǝ kakkaɗ biya. ");
INSERT INTO glwl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Vindavavindǝg wanahaan kwakyarvad am fǝdǝghǝrǝt taakiya Yesu iin Kǝristi, Zǝra Daadamazhigǝla. Dlaɓa tǝdvad fadghǝr ma ɗagaana am tlǝkǝna kǝ shiifǝga. ");
INSERT INTO glwl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tǝhala kwaha kaa gwiya tsǝgwatsǝgw kǝ Yesu vak mbǝrzahaan tǝ ghaiya dǝlva Tibariya. Dlaɓa wan ɗuuli marrada nǝ iin kǝ ghǝrana. ");
INSERT INTO glwl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Siman Bitrus, ard Tum kwa ɗahav dǝ Ghwallaha, ard Nataniyel kwama Kana ma Galili, ard dǝ zarha Zabadi, ard kyalǝma mbǝrzah buwa baɗǝmma ar ǝmtaɗa. ");
INSERT INTO glwl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Am Bitrusa, “Ən dagal da vaiya kilfa.” Aiyam kyǝlǝma mbǝrzaha, “Kǝmnd ndakwani kǝm dagal ǝmǝtaɗ dǝ kǝgha.” Kaa sagal kǝ iitǝr ar dǝm damma pɛrayuwa, kaa dagal kǝ iitǝra. Amma ma huɗa kwahiin kǝ avǝɗa, viyarǝti aanji ndau biya. ");
INSERT INTO glwl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Dlakadur ba wurra, ghacǝgan Yesu tǝ ghaiya dǝlva, amma nǝghǝgharaaka bi mbǝrzahaan taakiya Yesu biya. ");
INSERT INTO glwl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Aiyam Yesu taa kǝ iitǝra, “Daala zarha, tlamkǝnatlǝg kǝ kilfa?” Kaa ngugwanguw kǝ iitǝr taakiya “Maaya.” ");
INSERT INTO glwl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Am Yesu taa kǝ iitǝra, “Ɓǝlamɓǝlǝg kǝ amshi damma dǝvvaa kaffa pɛrayuwa, am da tlǝkǝnatlǝga.” Kaa ɓǝlgaan kǝ iitǝr bandkwa tagatǝr Yesu, ar vaiyit kǝ kilf ba ɗyaka, pelatǝrvaapelǝg baz tǝɗa amshi damma pɛrayuwa. ");
INSERT INTO glwl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Am mbǝrzǝn waig Yesuwǝn taa kǝ Bitrusa, “Abi Yaazhigǝla!” Cinngha ba Siman Bitrus taakiya Yaazhigǝla, kǝsant kǝ sǝɗavan tsǝgwǝvva, aɗaba ndza ba dǝ kusǝgha. Tǝhalakwa, kaa dzǝva daay kǝ iin damma yuwa. ");
INSERT INTO glwl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kaa ba sagau kyalǝma mbǝrzah da tǝ ghaiya dǝlǝv ma pɛrayuwa, ar tǝɗa amshiya vaiya kilf righarighaan dǝ kilfa. Aɗaba ndzar maay bǝtky dǝ ghaiya dǝlviin biya, tamaha shig dǝrǝmǝk hǝkǝrɗa. ");
INSERT INTO glwl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ba dǝ sagalaatǝr wah sa tǝ ghaiya gardza, nǝghara ba ghuvǝra kaar dǝ kilf ɓǝlga tǝ vakai ard bruudiya. ");
INSERT INTO glwl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Aiyam Yesu taa kǝ iitǝra, “Anaagham kǝ kyalǝma kilf ma kwanahaan amaa vaigǝt nǝ uuram ndakwanǝnna.” ");
INSERT INTO glwl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kaa ba daas kǝ Siman Bitrus damma pɛrayuwa, tǝɗda kǝ amshiya vaiya kilf da tǝ ghaiya gardza. Amshiya vaiya kilfǝn dlaɓa righarighaan dǝ maandala kilf dǝrmǝk dǝ kuldlǝɓ tar hǝkǝrɗa. Bakǝvakwaha, ndzǝgana ɗyakǝra kilfǝna, tǝhghana bi kǝ amshiya biya. ");
INSERT INTO glwl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Am Yesu taa kǝ iitǝra, “Asamasǝg naa ziyamzǝg kǝ kaffa dlakaduura.” Maay wa shughana gyi ma mbǝrzahaan kǝ ndavǝgarundavǝg taakiya ma war nǝ iin biya, aɗaba ar sǝrgasǝrǝg taakiya Yaazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Kaa sagau kǝ Yesu kǝssant kǝ bruudiyin vǝlǝtǝra, ɓagaa band kwah dlaɓ dǝ kilfa. ");
INSERT INTO glwl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Dǝga hǝkǝrɗ wan kǝ Yesu tsugwatsug vak mbǝrzahaan tǝhala ciigaan ma gǝtlaha. ");
INSERT INTO glwl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ghyǝnngara ba nǝ iitǝr za kaffa, kaa ndavǝgarundavǝg Yesu kǝ Siman Bitrus taakiya, “Siman zǝra Yuhwanna, agha waikwawaig juujig kǝ kwannahaana?” Kaa ngwarangug kǝ Bitrus amaa, “Aana, Yaazhigǝla, agha sǝrǝgasǝrǝg taakiya ǝn wayakwaiga.” Am Yesu taa kǝ iina, “Gǝlǝg kǝ tuughahara.” ");
INSERT INTO glwl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kaa gwiya ndavǝgarundavǝg Yesu kǝ dǝga buwa amaa, “Siman zǝra Yuhwanna, agha waikwawaiga?” Kaa ngugarangug kǝ iina, “Aana, Yaazhigǝla agha sǝrǝgasǝrǝg taakiya ǝn waiyakwaiga.” Am nǝ Yesu taa kǝ iina, “Faffǝg kǝ hyimi tuuk kǝ tuughahara.” ");
INSERT INTO glwl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kaa gwiya ndavgarundavǝg Yesu kǝ dǝga hǝkǝrɗ amaa, “Siman zǝra Yuhwanna, agha waikwawaiga.” Kaa badza huɗvǝg kǝ Bitrusa, aɗaba kwa ndavgharu Yesu kǝ dǝga hǝkǝrɗǝn taakiya, “Agha waikwawaiga?” Iin dlaɓ ngugharangug taakiya, “Yaazhigǝla, agha sǝrgasǝrǝg kǝ dǝgitah ba ɗǝmma, agha sǝrgasǝrǝg taakiya ǝn waiyakwaiga.” Am Yesu taa kǝ iina, “Gǝlǝg kǝ tuughahara. ");
INSERT INTO glwl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Bak jiijiira, ǝn tagaktaga, ma sartǝn agha daalla zǝra agha fǝgaan kǝ sǝɗɗav bad ghǝragha agha dagal da vakavaki agha naaga nǝnnga, amma ma nǝghalnǝg kǝ malaha, agha talgaan kǝ dǝvvagh uudi tlǝrǝn wa fak sǝɗava, dǝkada da vakavaki agha naay kǝ dagal biya.” ");
INSERT INTO glwl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tagadatag Yesu kwannǝn kǝ ǝlbǝga kwakyarvad marvǝda hulfa ǝmǝtsǝgi da ǝmtsǝg Bitrus kwa da saa dǝ ndanngǝr kǝ Daadamazhigǝla. Tǝhala kwan kǝ ǝlbǝga, am Yesu taa kǝ Bitrus, “Gatǝkwagatǝga.” ");
INSERT INTO glwl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Kaa gwivǝtgwig kǝ Bitrus vaza da tǝ halla, kaa nǝghǝganǝghǝg kǝ iin kǝ mbǝrzǝn kwa waig Yesu gata iitǝr tǝ halla. Kwan kǝ mbǝrz wandza dǝngǝzhiga tǝ Yesu ma sarta za kaffa hwaɗaga haarakǝssa dzava hǝnnyaha. Iin wa ndavǝgharu kǝ Yesu taakiya, “Yaazhigǝla, war wa da vǝla kǝghi?.” ");
INSERT INTO glwl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nǝghǝgha ba Bitrus kǝ iina, kaa ndavǝgarundavǝg kǝ iin kǝ Yesu amaa, “Yaazhigǝla, uudanǝn mi?” ");
INSERT INTO glwl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Aiyam Yesu taa kǝ iina, “Akwaman naagaan ndzan dǝ shiifǝga bamma gwiyanghǝragwig saaya, auw lambaghi? Gatǝkwagatǝg aska nǝnnga.” ");
INSERT INTO glwl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Aɗabad kwaha, kwannǝn kǝ ǝlbǝg kutalkutǝg ma yaa dadda gata Yesu taakiya, kwan kǝ mbǝrz da maay ǝmtsǝg biya. Amma tagada bi Yesu taakiya, da maay ǝmǝtsǝg biya, tagada ba taakiya, “Akwaman naagaan ndzan dǝ shiifǝg bamma gwiyanghǝragwig saaya, au lambaghi?” ");
INSERT INTO glwl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Kwan kǝ mbǝrz wa ɓaga shiid tǝghǝr kǝ kwanahaan kǝ dǝgitaha, iin dlaɓ wa vindavindǝga. Kǝm sǝrgasǝrǝg taakiya shiidaana ba jiijiira. ");
INSERT INTO glwl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Mǝng nǝ dǝgitah ba ɗyak kwa ɓaga Yesu, akwama taakiya aa vindavvindǝg baɗǝmma, man tlǝg naiya aanji duni dǝ ghǝraana ma kǝssgant bi kǝ kakkaɗahaan akwama viindav biya.");
INSERT INTO glwl_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Bulus, kwatnaha Kǝristi Yesu, kwa ɗahavant kiyava nǝg kǝ zǝr ɓǝlga Yesu, dlaɓa favan ba kǝrkangyakw kiyava taa ǝlbǝg Marawa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Kwanǝn kǝ ǝlbǝg Maraw na, iin wa taa Daadamazhigǝl kǝ langiyaan ba wur tǝdvad tlayangngahaana, band kwa vinndǝga ma Kakkaɗa Daadamazhigǝl Cacuwanacacuwana. ");
INSERT INTO glwl_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Kwan kǝ Əlbǝg Maraw tǝghǝr kǝ Zǝraan na, kwa tǝdvad ndzǝganaan ma duniya, sǝghal ma hulfa Dauda, ");
INSERT INTO glwl_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","amma tǝdvad ndzǝgana cacuwuraaan ma shiɗǝkwa, favdǝghǝrǝtfǝg taakiya Zǝra Daadamazhigǝl nǝ iin tǝdvad ciigaan ma gǝtlaha. Favdǝghǝrǝtfǝg tǝ Yesu Kǝristi dlaɓ taaki Yaazhigǝla miyam nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Tlankǝna tǝdvad Kǝristi Yesu nai kǝ hɛrǝr kiyava nǝg kǝ zǝr ɓǝlgaana, kwakyarvad fǝvaara ɗagaana, dlaɓa ǝn ɗahant kǝ kǝrdiyah baɗǝm ar hayant dǝ iina, ar faarana. ");
INSERT INTO glwl_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Kuram ndakwi am ma kǝrdiyahi ɗahavtǝrant kiyava nǝg kǝ dǝga Yesu Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ən vindkur kǝskuram baɗǝmmaru lii ma Ruma, kurami waikur Daadamazhigǝla, dlaɓa kiyava nǝg kǝ uudahaan cacuwanacacuwana, hɛrǝrra, ard gabǝra Daadamazhigǝl Daada miyama ard dǝga Yaazhigǝl Yesu Kǝristi, aa ndzandzǝg tǝghǝr kǝskurama. ");
INSERT INTO glwl_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ba zunngwa, ǝn tagar uus kǝ Daadamazhigǝlar tǝdvad Yesu Kǝristi mbakyarvad kuram baɗǝmma, aɗaba tagavdatag nǝ ǝlbǝga fadghǝraru tǝ iin aanji takwar ma duniya. ");
INSERT INTO glwl_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Daadamazhigǝl kwan ɓagar nai kǝ tlǝr bad ǝrvidmahuɗ pall tǝdvad taa ǝlbǝg marawa Zǝraana, iin shidar taakiya ǝn dzamkurdzamǝg ba kǝlaa hǝnnga, ");
INSERT INTO glwl_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ba tuuk sarti ǝn dzugw nai kǝ zhigǝla, ǝn ghalgaan kǝ Daadamazhigǝl taakiya, akwama haighanthaiga, ma ɓaga ndandara, ma naa tlǝkǝna kǝ ɗuula da vakaru ndakwana. ");
INSERT INTO glwl_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ən naagaan ǝn nǝghǝkuraan mbakyarvad ǝn vǝlkur kǝ gyagyaan kwa tlǝvkǝna tǝdvad shiɗǝkw kiyava fǝkurna ndzǝɗa. ");
INSERT INTO glwl_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Naagara, iin taakiya, baɗǝmmamiyam ma kiyama faraa kǝ ndzǝɗ kǝ ghǝramiyama, ǝn fǝkura kǝ ndzǝɗ dǝ fadghǝrarra, kuram dlaɓa, am fǝwa kǝ ndzǝɗ dǝ dǝgaruwa. ");
INSERT INTO glwl_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Zaraabaha, ǝn naagaan am sǝran taakiya, shiga ngwǝn wana, ǝn naa da vakaruwa, bakǝvakwaha tsakwavatsǝg nǝ uuda, kwan naag nai kǝ da vakaruuna, aɗaba ma naa tlǝkǝna kǝ lii pǝla ghǝr ma kuram bandkwa ɓagana nai vakavakahi tlǝrǝn ma lii ar yahudah biya. ");
INSERT INTO glwl_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Dlaiyar kǝskai taa ǝlbǝg maraw ma gǝdǝrkǝsa ard gǝdzǝrkǝsa, kǝ lii ɗyamɗyam ard dlagaha. ");
INSERT INTO glwl_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Iin wa kǝman nai ba vaivai kǝ tagkur ǝlbǝg maraw kǝskuram lii ma Ruma. ");
INSERT INTO glwl_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Əlbǝg Maraw na dǝga zhǝru bi nǝ iin kǝskai biya, aɗaba iin ndzǝɗa Daadamazhigǝl kwa saa dǝ katǝg aanji kwar kǝ dadda fadǝghǝra, dǝga zunngwa Yahudaha, tǝhala kwaha lii ar Yahudah biya. ");
INSERT INTO glwl_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Aɗaba maradamarǝg nǝ Əlbǝg Maraw kǝ ɗulli ɓadlǝghana Daadamazhigǝl kǝ ndzǝganaan ǝmtaɗ dǝ uudaha, kwanna tlǝvkǝna ba tǝdvad fadǝghǝr kaltiya, bandkwa vindavindan ma Kakkaɗ taakiya, daddakwa ɓadlǝghanaɓadlǝg kǝ ndzǝganaan dǝ Daadamazhigǝla, da ndzǝga ba tǝ fadǝghǝra. ");
INSERT INTO glwl_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Aɗaba maradamarǝg Daadamazhigǝl kǝ badzǝga ǝrvidmahuɗaan sii ma ghǝrazhigǝl da tǝghǝr kǝ lii maay gǝdza Daadamazhigǝl biya, ar lii ɓa tlǝra kǝlaadǝr nǝ iitǝra, dlaɓa tsaraa kǝ shig kǝ jiir tǝdvad kalaadǝratǝra. ");
INSERT INTO glwl_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Dǝgiti maa sǝrvasǝrg tǝghǝr kǝ Daadamazhigǝl ba tǝ ɓalaɓal nǝ iin tsaw vakaatǝra, aɗaba maratǝrdamarǝg Daadamazhigǝl kǝ dǝgitaha. ");
INSERT INTO glwl_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Ndzǝgana Daadamazhigǝla ard ndzǝɗaan tangw damma zǝrazǝra dǝgitahi nǝghvanǝghǝg dǝ gyi biya. Aɗaba bamma sarti vǝrɗyava duniya maravdamarǝg wanahaan kǝ dǝgitah ba tǝ ɓalaɓala, nǝghǝvtraakanǝghǝg dlaɓ wanahaan tǝdvad dǝgitahi vǝrɗya nǝ iina. Mbakyarvad kwaha, ar maay nǝ uudah dǝ ɗuula farwut biya. ");
INSERT INTO glwl_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Aanji ba war sǝrgasǝrǝg kǝ Daadamazhigǝla, bakǝvakwaha faraara bi band Daadamazhigǝl biya, dlaɓa tagarar bi kǝ uus biya. Dlakulva kwaha dzamaghǝraatǝra nalnǝg ba gyaana, dlaɓa ǝrviɗmahuɗatǝra nalnǝg ba dǝkdǝka. ");
INSERT INTO glwl_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Aanji bar taakiya, ar yaa dadda dabariya, amma ar dlagaha. ");
INSERT INTO glwl_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Mbǝɗarnambǝɗǝg kǝ ndangǝra Daadamazhigǝl kwa maay ǝmtsǝg dǝ dzakǝva dǝgit band uud kwa ǝmtsǝga, ard ghǝlahi kwa dzakǝva ɗiikaha, ard almanaha ard azahulǝmba. ");
INSERT INTO glwl_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Mbakyarvad kwaha ɗuwatǝrnaaɗug Daadamazhigǝl kǝ kǝma dǝgaha kǝlaadǝri naghant nǝ ǝrvidmahuɗatǝr kǝ ɓagaana, dlaɓa ar ɓa dǝga tsa zhǝruw dǝ vǝghahaatǝra ma taatakatǝra. ");
INSERT INTO glwl_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Mbǝɗarnambǝɗǝg kǝ jiira Daadamazhigǝl kǝ fiida, ar ɓagar kwatnahǝr kǝ dǝgitahi vǝrɗya nǝ iina, baz ɓagar tlǝr kǝ iitǝr dlakulva kwa maraa ɓagar nǝ iitǝr kǝ Daadamazhigǝla, iin wa tlaltlǝg kǝ galǝg ba tangw damma zǝrazǝra. Aandz bandkwaha. ");
INSERT INTO glwl_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Mbakyarvad kwaha ɗuwatǝrnaaɗug Daadamazhigǝl kǝ kǝmma ɓaa dǝgaha tsa zhǝruwa. Ənghwasahaatǝr ndakwani ɗuuwarasɗug kǝ camarakav dǝ ghwalvah kwa iin tanngaraan ba sagalaan ma daadija, kaa ba caamarakav kǝ iitǝr dǝ vǝgahaatǝr kwa kalkal bi sagalaan bamma daati. ");
INSERT INTO glwl_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ghwalvah ndakwi ɗuwarasɗuug kǝ camarakǝv dǝ ǝnghwasah kwa in wa kalkal sagalaan bamma daati. Ghwalǝva ard ghwalva ar ɓa dǝga tsa zhǝruwa, sardaa ndǝkwah nǝ iitǝr kǝ dlaɗ da tǝ ghǝraatǝr kwa ba kalkal dǝ tlǝraha kǝlaadǝraatǝra. ");
INSERT INTO glwl_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Larwalǝg tsau kǝ sǝrgasǝrǝg kǝ Daadamazhigǝla, kaa ɗuutǝrǝsɗug Daadamazhigǝl dǝ dzamaghǝra dlagǝraatǝr kiyava ɓa dǝgitahi kalkal bi kǝ ɓag biya. ");
INSERT INTO glwl_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ar righarighan aanji dǝ hulfa kwar kǝ dǝga kǝlaadǝra, dǝ dlǝrmǝga, dauwa, ar righarighan dǝ shilga, tsa shifǝga, uushava, ard vala uuda, ard dangwǝra huɗa, ar yaa dadda hwatsa amaha, ");
INSERT INTO glwl_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","lii badza ɗaaga, lii ɓa tlǝghum dǝ Daadamazhigǝla, lii ɗaava uuda, lii naa ghǝra, lii ar fǝgaara kǝ ghǝraatǝra, lii ɓa ba dǝga kǝlaadǝra, lii maay fǝgaara kǝ daddaatǝr ard babbaahaatǝr biya. ");
INSERT INTO glwl_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Lii nǝghǝgaaka biya, lii maay righa lanngyi biya, ar maay waiyakǝv biya, dlaɓa ar maay ɓa zhuwadaal biya. ");
INSERT INTO glwl_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ar sǝrgasǝrǝg kǝ adzahadzaha Daadamazhigǝl taakiya, baɗǝm lii ɓa kwanahaan kǝ dǝgita, dlaitǝrdlaig nǝ ǝmtsǝga, kwanahaan kǝ dǝgitah kalti bi war ɓag nǝ iitǝr biya, baz tlahtǝr ilǝg kǝ iitǝr kǝ lii ɓa kwanahaana. ");
INSERT INTO glwl_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Mbakyarvad kwaha, kǝgh dadda tǝgar shari kǝ uuda, aanji agha war nǝnga, agha maay dǝ farwut biya, ma sartǝn agha tǝgar nǝng kǝ shari kǝ uuda, agha ghaza ghǝragha, aɗaba haipǝn agha zharǝg nǝng kǝ uud dǝ vakaina, iin wa ɓag nǝng ghǝravagha. ");
INSERT INTO glwl_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Kiyam sǝrgasǝrǝg taakiya shariya Daadamazhigǝl ba jiijiira tǝghǝr kǝ lii ar ɓa kwanahaan kǝ dǝgita. ");
INSERT INTO glwl_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Kǝgh uuda! ba kǝgh dǝ ghǝragh ndakwani agha ɓagan kǝ haipǝn kwa agha vazǝg nǝng kǝ uud dǝ vakaina! Ma tlǝg ghǝragh agha da ngǝdlǝgharwangǝdlǝg kǝ shariya Daadamazhigǝla? ");
INSERT INTO glwl_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Nii agha nenna dyakǝra hɛrǝrra Daadamazhigǝla, ard fa ǝrvidmahuɗaana, ard kwa maay nǝ iin nguɗa ǝrvidmahuɗ watswats dǝ kǝghǝn hi? Mbats, agha sǝrga bi taakiya, hɛrǝrra Daadamazhigǝl wa fakaafǝg kǝ pǝlaghǝr biya? ");
INSERT INTO glwl_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Amma mbakyarvad dǝkdǝka ghǝr ard dǝkdǝka ǝrvidmahuɗi agha dǝ vakai nǝnnga, agha dzagharu shari kǝ ghǝragha kwa paka kǝgh davala badzǝga ǝrvidmahuɗa Daadamazhigǝla, ma sartǝn da tav shari tǝdvad jiira Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Da vǝlgarvǝlǝg Daadamazhigǝl kǝ dǝg shigan aanji kwar kǝ uud kalkala dǝgiti ɓagaa nǝ iina ");
INSERT INTO glwl_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Kiyava lii ghularvaghulǝg kǝ ɓa tlǝra hɛrrǝr kǝ gata ndanngǝra ard ɗyakǝr ard shifǝga kwa maay ghyǝnng biya, da vǝltǝrvǝlǝg Daadamazhigǝl kǝ shifǝg tangw damma zǝrazǝra. ");
INSERT INTO glwl_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Amma lii naa ghǝraatǝra, ard lii naay kǝ jiir biya, dlaɓa ar ɓa tlǝra kǝlaadira, da ɗigaan Daadamazhigǝl kǝ ǝrviɗmahuɗaan tǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Dlaɗa ard mbahǝl wa paka aanji kwar kǝ uudi ɓa tlǝra kǝlaadǝra, ba zunngwa Yahudaha, tǝhala kwaha lii ar yahudah biya. ");
INSERT INTO glwl_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Baɗǝm daddakwa ɓa dǝgit marawa, da tlǝkǝnatlǝg kǝ ndanghǝra ard dyakǝra ard gabǝrǝra, ba zunngwa Yahudaha, tǝhalakwaha lii ar Yahudah biya. ");
INSERT INTO glwl_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Aɗaba maay Daadamazhigǝl fa dagar ma uud biya. ");
INSERT INTO glwl_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Baɗǝm lii ɓa haip kwal sǝrga adzahadzaha Muusa, ar da ruug ba kwal adzahadzaha, amma baɗǝm lii ɓa haip dǝ sǝrgasǝrgǝraatǝr kǝ adzahadzaha, da tǝvtǝr tǝdvad adzahadzaha shariya. ");
INSERT INTO glwl_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Aɗaba tǝdvad cinnga dǝgiti tag nǝ adzahadzah kalti bi wa da fǝgaraa uudah kǝ nǝg uudaha jiir tǝvuukwa Daadamazhigǝl biya, bamma lii ɓa tlǝr dǝ dǝgiti tag nǝ adzahadzaha, iitǝr wada ɗahvǝtǝr dǝ uudaha jiirjiira. ");
INSERT INTO glwl_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Lii ar Yahudah biya, ar maay dǝ adzahadzaha Muus biya, bakǝvakwaha ar ɓagaan kǝ dǝgiti tag adzahadzaha ma ǝrvidmahuɗatǝr daghuvaliitlǝrna. Mbats lii tsagavtǝru bi nǝ adzahadzah biya, ar dǝ adzahadzaha ghǝraatǝra. ");
INSERT INTO glwl_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Marardamarǝg taakiya, dǝgiti naag nǝ adzahadzaha vindavindan ma ǝrviɗmahuɗaatǝra, dlaɓa dzamaghǝraatǝra nalnǝg kǝ shid kǝ iitǝra, davalitlǝrna dzamaghǝraatǝr tagtǝrtag taakiya ɓagara bi kalkal biya, davalitlǝrn dlaba dzamaghǝraatǝr tagtǝrtag taakiya ɓagarabag ba kalkala. ");
INSERT INTO glwl_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Mbakyarvad kwaha, bandkwa tag nǝ ǝlbǝg marawǝn kwan tag nai kǝ ǝlbǝgaanna, da nǝg bandkwah daghuvali da tǝg Daadamazhigǝl kǝ shariyaan tǝdvad Kǝristi Yesu tǝghǝr kǝ dǝgitahi shiɓashiɓan baɗǝm ma ǝrviɗmahuɗa uudaha. ");
INSERT INTO glwl_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Kǝgh ci dadda taakiya ǝn zhiil Yahud na, agha tsa ghǝr tǝ adzahadzaha Muusa, dlaɓa agha tsa kusǝgh taaki agha ba hweɗ dǝ Daadamazhigǝla, ");
INSERT INTO glwl_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","agha taakiya, ǝn sǝrgasǝrǝg kǝ dǝgiti tlatlǝg Daadamazhigǝl am nǝnnga, dlaɓa agha sǝrgasǝrǝg kǝ adzahadzaha Muusa ard ɗuuli agha da kǝsgaaka nǝnng kǝ dǝgiti kalkallaana. ");
INSERT INTO glwl_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Akwama agha sǝrgasǝrǝg taakiya, agha dadda taɗa gulfa, dlaɓa parak kǝ lii ma gurtla, ");
INSERT INTO glwl_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","dadda kwartǝr degit kǝ dlagaha, dlaɓa dadda tsaga dǝgit kǝ zarha. Aɗaba fǝghǝdǝghǝrǝtfǝg nǝnng taakiya, agha sǝrgasǝrǝg kǝ dǝgit ba maraw ard jiir ma adzahadzaha Muusa. ");
INSERT INTO glwl_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ai ciya, kǝgh dadda tsagtǝr kǝ uudaha, tsagarutsag kǝ ghǝragh ndana! Kǝgh dadda taa ǝlbǝg marawi agha taakiya aa ɓagav bi gǝl biya, agha maay ghǝravǝgh ɓa gǝl biya? ");
INSERT INTO glwl_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Kǝgh dadda taaki aa ɓagav bi gwaragwar biya, agha maay ghǝravǝgh ɓa gwaragwar biya? Kǝgh dadda caɗa ǝrviɗ tǝvǝgh kǝ ghǝla, agha maay ghǝravagh ɓa gǝl ma guda gǝliv biya? ");
INSERT INTO glwl_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Kǝgh dadda tsa kusǝgh dǝ adzahadzaha Muusa, agha maay badza ɗaaga Daadamazhigǝl tǝdvad kǝlgarwut adzahadzahaan biya? ");
INSERT INTO glwl_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Bandkwa vindava ma Kakkaɗa Daadamazhigǝl taakiya, “Badzav mbakyarvad kuram Yahudah nǝ ɗaaga Daadamazhigǝl ma lii ar Yahudah biya.” ");
INSERT INTO glwl_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Akwama agha fǝgaarafǝg kǝ adzahadzaha Muusa, ɓa aguvacagh mǝng nǝ tlǝraana, akwama fǝghaara bi kǝ adzahadzaha Muus biya, nalnǝg bandǝgi ɓagaka bi nǝ uud kǝ aguvac biya. ");
INSERT INTO glwl_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Akwa mar tsuufǝgan lii ɓagavtǝra bi nǝ aguvac kǝ dǝgiti tag nǝ adzahaadzaha Muus taaki aa ɓagavɓaga, mbats da nǝtǝrdal bi Daadamazhigǝl band lii ɓagavtǝra nǝ aguvac biya? ");
INSERT INTO glwl_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Akwamar mar tsuufǝgan nǝ lii ɓagavtǝra bi nǝ aguvac kǝ dǝgiti tag nǝ adzahadzah taakiya aa ɓagavɓaga, ar da taktǝg kǝ shari kǝskǝghǝn agha dǝ aguvacǝn dlaɓa agha dǝ adzahadzaha Muus vindavindanna, aɗaba kǝlghǝdakǝlǝg kǝ adzahadzaha. ");
INSERT INTO glwl_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Agha nǝgal bi kǝ zhiil Yahuda jiijiir kwakyarvad ɓagakaɓag nǝ uud kǝ aguvac kalti biya, aguvaca jiijiira iin bi nǝ aguvaca vǝgh zhiilǝr biya. ");
INSERT INTO glwl_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Dlakulva kwaha, Zhiil Yahuda jiijiira iin Zhiil Yahuda kwama ǝrviɗmahuɗa, dlaɓa aguvaca jiijiira iin nǝ aguvaca ǝrviɗmahuɗa, dǝgiti ɓag Shiɗǝkwa Daadamazhigǝl tǝdvad adzahadzahi vindavindan biya, hulfa kwan kǝ uuda, Daadamazhigǝl kataghǝraan wa dlǝbgaana, uuda dǝgshig biya. ");
INSERT INTO glwl_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Au kaci tlǝra taakiya agha zhiil Yahudi? Au ci tlǝra ɓa guvaci? ");
INSERT INTO glwl_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Mǝng nǝ iin kǝ mǝnga, aanji ta kwar kǝ ɗuula! ba zunngwa, Yahudah wa vǝlatǝr Daadamazhigǝl ba dǝ ghǝraan kǝ langyiya ǝlbǝgaana. ");
INSERT INTO glwl_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Akwama mar dǝ maayra fadǝghǝr kyalmatǝr biyim? Da nǝgalnǝg kaci taakiya jiira Daadamazhigǝl maay tlǝran biya? ");
INSERT INTO glwl_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Maaya! Dzǝgaar dau ɗa! Daadamazhigǝl dadda jiira, bakvakwaha aanji kwar kǝ uuda ba dadda fiida. Bandkwa vindava ma kakkaɗa Daadamazhigǝla taakiya, “Kiyava fǝvdǝghǝrǝtfǝg tǝ jiira ǝlbǝgagha, dlaɓa agha zǝgaan kǝ fiir akwama tak shari nǝ uuda.’’ ");
INSERT INTO glwl_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ai tsa, akwama maira jiira miyam wa nalnǝg kǝ ɗuula mara jiira Daadamazhigǝl ma, au wa kiyam da tag nǝ miyammi? Kiyam da taaki maay Daadamazhigǝl dǝ jiir akwama ɗiyadaɗiig kǝ ǝrviɗmahuɗaan tǝ kǝmiyami ciya? “Ən taa kwan naiya bandkwa tag tlǝmadauwa.” ");
INSERT INTO glwl_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Maaya! Dzǝgaar dau ɗa, ma bandkwaha, da tǝg ndandar ka ci Daadamazhigǝl kǝ shari kǝ duuniyi? ");
INSERT INTO glwl_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Akwama maira jiirar wa fǝghara jiira Daadamazhigǝl sagal da tǝ ɓalaɓal ba vaivaiya, nalnǝg dlaɓ kǝ dǝga fǝgara ndangǝr kǝ Daadamazhigǝla, iyau, kwakyarvadau ci gwastaan da vǝlgwa dlaɗ nǝ uud taakiya ǝn dadda haipi? ");
INSERT INTO glwl_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Akwama bandkwaha, ba kiyam zavukw dǝ ɓa kǝladǝr kiyava nǝg kǝ ɗuula tlǝkǝna hɛrǝr kǝskǝmiyam biya? kyalma uudah dlaɓa, ar taa ǝlbǝga badzaa ɗaaga miyama ar taakiya kiyam tag ndǝkwaha awarama. Da ghazǝvtǝrghazǝg nǝ uudahaan ba kalkal band kwa da ghazǝvǝtǝra. ");
INSERT INTO glwl_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Aitsa, auwa kiyam da tag nǝ miyami? jiyamuujig nǝ miyam Yahudah kǝ kyalma uudaha? Maaya! dzǝgaar dau ɗa! Tagiyamdatag taakiya baz Yahudaha ard lii Yahudah biya, baɗǝmmaatǝra tǝkaratǝkǝga, dlaɓa baɗǝmmaatǝra ar ba mizhangyil kǝ ndzǝɗa haipa. ");
INSERT INTO glwl_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Bandkwa vindavindan ma kkakaɗa Daadamazhigǝl taakiya, “maay dadda jiir biya, maay, aanji pall biya. ");
INSERT INTO glwl_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Maay daddakwa nǝghǝgakanǝghǝg biya, maay daddakwa gata Daadamazhigǝl biya. ");
INSERT INTO glwl_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Baɗǝmmaatǝr guyarardagwig kǝ ilǝg kǝ Daadamazhigǝla, ar madla bi tu kǝ ǝlbǝg biya, maay daddakwa ɓa dǝga jiijiir biya, maay aanji pall biya. ");
INSERT INTO glwl_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Mbakulyaraatǝr band gǝtl wurawurana, aryahatǝra nalnǝg kǝ dǝga vala uuda. Əlbǝgahi ar tag nǝ iitǝra, band gura ghaval kwa kǝlaada. ");
INSERT INTO glwl_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Əlbǝgahi sagal ma ghaiyahatǝra, ba ɗaava ard ǝlbǝg ɗyahɗyaha. ");
INSERT INTO glwl_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Ar ɓa watswats tǝdvad tsa shifǝga, ");
INSERT INTO glwl_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Ar dǝgal ba takwara, tlǝratǝr ba ciɓa uuda ard danngura huɗɗa. ");
INSERT INTO glwl_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ar sǝrga bi kǝ ɗuula gabrǝr biya. ");
INSERT INTO glwl_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Maay gǝdza Daadamazhigǝl ma gyiyatǝr biya ");
INSERT INTO glwl_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Kiyam sǝrgasǝrǝg taakiya baɗǝm dǝgiti tag nǝ adzahadzaha Muusa, tagtǝr kǝ lii mizhanngyil kǝ adzahadzaha. Nalnǝg nǝ iin ǝndkwaha mbakyarvad tsǝtǝrva kǝ lii gata farwut baɗǝmma, dlaɓa marvǝdan taakiya baɗǝm duniya ar ba mizhanngyil kǝ shariya Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Aɗaba tǝ kwaha, maay wada tlǝvkǝnatlǝg kwal haip tǝvuukwa Daadamazhigǝl tǝdvad tsufa dǝgiti tag nǝ adzahadzah taaki aa ɓagavɓag biya. Tlǝri ɓag nǝ adzahadzah iin taakiya, mararda kǝ haipaan kǝ uuda. ");
INSERT INTO glwl_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ndakwan ciya, tagavdatag watlǝrin kǝ ɗuula tlǝkǝna jiira Daadamazhigǝla, kwan kǝ jiira tlǝfǝkǝna tǝ ɗuula adzahadzaha Muus biya, bakǝvakwaha tagadatag nǝ adzahadzaha Muusa ard tlayanngah kǝ shiid tǝghǝra. ");
INSERT INTO glwl_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Kwan kǝ jiira Daadamazhigǝl na, tlǝfkǝna tǝdvad fadǝghǝr tǝ Yesu Kǝristi kǝ lii fardǝghǝrǝtfǝg baɗǝmma. Maay wahazhawahazh ma taataka Yahudaha ard lii Yahudah biya, ");
INSERT INTO glwl_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Baɗǝm nǝ uudaha ɓagaraɓag kǝ haipa, dlaɓa hǝtsalarhǝtsǝg da tǝ ndangǝra Daadamazhigǝla, ");
INSERT INTO glwl_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Amma kwakyarvad hɛrǝrri ɓagaa Daadamazhigǝl ba gyagyaan aanji kǝ wara, ma ba war tlakǝnatlǝg kǝ ndzǝgan kwal haip tǝvuukwa Daadamazhigǝl tǝdvad vargi varakiyama Kǝristi Yesu ");
INSERT INTO glwl_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","Vǝladavǝlǝg Daadamazhigǝl kǝ Yesu kiyava kyuulǝg mbakyarvad kǝsa haipahamiyama, aɗaba tǝdvad avǝza kyuulǝgaan wada mɓishǝvǝtǝrna haipahatǝr kǝ uudah tǝdvad fadǝghǝraatǝra. Ɓagaaɓag Daadamazhigǝl kwan mbakyarvad marda kǝ jiiraana, ma sarta kwa ndza wura, faffǝg Daadamazhigǝl kǝ ǝrvidmahuɗ ɓǝlatǝrnaɓǝlǝg kǝ haipahatǝra. Marada ndǝkwah Daadamazhigǝl kǝ jiiran ma kwan kǝ sarta, vǝladavǝlǝg kǝ Yesu ǝmtsan mbakyarvad haipahamiyama, dlaɓa baɗǝm daddakwa fadǝghǝrǝtfǝg tǝ Yesu da tlǝkǝnatlǝg kǝ ndzǝga kwal haip tǝvuukwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Aitsa, kiyam da tǝɗǝg tuuk au kaci kǝ fǝɗyavǝghi? Maaya, tsavda tǝ kwar kǝ ɗuul nǝ tǝɗa fǝɗyavǝghi? tsavda tǝdvad tsufa adzahadzaha Muusa? ǝndkwah biya, tsavda tǝdvad fadǝghǝra. ");
INSERT INTO glwl_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Aɗaba haiyamanthaig taakiya, tlǝfkǝna tǝdvad fadǝghǝr nǝ ndzǝga kwal haip tǝvuukwa Daadamazhigǝla, tǝdvad tsuufa adzahadzaha Muus biya. ");
INSERT INTO glwl_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Daadamazhigǝlǝn tsa, Daadamazhigǝl ba kǝ Yahudah kaltiya? Mbats maay Daadamazhigǝlaatǝr kǝ lii ar Yahudah biya? ba pakatta Daadamazhigǝl baz kǝ lii ar Yahudahǝn biya, ");
INSERT INTO glwl_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Aɗaba Daadamazhigǝl ba palla. Da fǝtǝraafǝg kǝ lii ɓagavtǝraɓag nǝ aguvac kǝ ndzǝga kwal haip tǝvuukwan tǝdvad fadǝghǝra, bandkwah dlaɓ lii ɓagavtǝra bi nǝ aguvac biya, ar da tlǝkǝna tǝdvad fadǝghǝr kǝ ndzǝga kwal haipa. ");
INSERT INTO glwl_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Aitsa, ɗiyamdaddaɗiigi kaci kǝ adzahadzaha Muus mbakyarvad kwan kǝ fadǝghǝra? ǝndkwah biya, dlakulva kwaha, hakyamdǝvǝthakyig tǝ vakaiya. ");
INSERT INTO glwl_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Kiyam da taaw kaci tǝghǝr kǝ Ibrahim, daadiija daadijamiyam tǝdvad ndzǝgana vǝghǝghi? auwa nǝghǝghaaka nǝ iin tǝghǝr kǝ ǝlbǝga fadǝghǝri? ");
INSERT INTO glwl_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Akwama tlakǝna tǝdvad tlǝraan nǝ Ibrahim kǝ ndzǝga kwal haip tǝvuukwa Daadamazhigǝla, mǝng dǝgiti da tǝɗǝg nǝ iin kǝ fǝɗyavǝgh dǝ vakaiya, amma tǝvuukwa Daadamazhigǝl biya. ");
INSERT INTO glwl_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Auwam kakkaɗa Daadamazhigǝli? “Fadǝghǝrǝtfǝg nǝ Ibrahim tǝ Daadamazhigǝla, ka ba ɗagaan Daadamazhigǝl dǝ uuda jiijiira.” ");
INSERT INTO glwl_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Dadda kwa ɓa tlǝra, caug gyagyaan bi kǝ kwaɓ biya, cauwa dǝgshiga tlǝrana. ");
INSERT INTO glwl_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Daddakwa maay tsaghǝr tǝ tlǝraan biya, tsaghǝr ba tǝ Daadamazhigǝl kwa nǝdalnǝg kǝ yaa dadda haip ar tlǝkǝna kǝ ndzǝgan kwal haip tǝvuukana, da nǝdal kǝ fadǝghǝra uudanǝn kǝ jiira. ");
INSERT INTO glwl_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Daud ndakwi taga band kwah ma sarta kwa taga nǝ iin kǝ ǝlbǝg tǝghǝr kǝ barka, hayatǝrǝthaig Daadamazhigǝl ba kwal vaza dǝga jiijiiri ɓagara nǝ iitǝra, ");
INSERT INTO glwl_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Dǝ bark nǝ uudi ɓishavarna dǝgitahi ɓaga nǝ iina, dlaɓa ɓishǝvarna haipahaana. ");
INSERT INTO glwl_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Dǝ bark nǝ uudani kwa madlai nǝ Yaazhigǝl fa haipahaan tuuk kǝ uupǝɗ biya,” ");
INSERT INTO glwl_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Kwan kǝ bark tsa, ba kǝ lii dǝ aguvac kalti nii baz lii maay dǝ aguvac hi? Abi dǝgiti kǝm tag nǝmnd ba vindavindan ma kakkaɗa Daadamazhigǝl taakiya, “Hayavaranthaig kǝ Ibrahim kwakyarvad fadǝghǝraan taakiya dadda jiir nǝ iina.” ");
INSERT INTO glwl_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Aitsa, ma sarta kwar wa tagavara kǝ Ibrahim taakiya dadda jiir nǝ iin ni? tǝhala kwa ɓagavara nǝ aguvac nii lakwuti ɓagǝvarɓag hi? lakwuti ɓagǝvarɓaga. ");
INSERT INTO glwl_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ɓagavara ba nǝ aguvac kǝ Ibrahim, nalnǝg kǝ dǝga sǝrǝg kǝ iin taakiya, dadda jiir nǝ iin tǝdvad fadǝghǝraan lakwuti ɓagvarɓag nǝ aguvaca. Mbakyarvad kwaha nalnǝg nǝ Ibrahim kǝ Daad kǝ lii fardǝghǝrǝtfǝg tǝ Daadamazhigǝla, kiyava kǝdlǝvǝtǝrkǝdlǝg ma lii dǝ jiir aanji ba ɓagavtǝrabi nǝ aguvac biya. ");
INSERT INTO glwl_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Nal bandkwah dlaɓ nǝ Ibrahim kǝ Daad kǝ lii ɓagavtǝra nǝ aguvaca, kwa aguvac kalti bi war dǝvakai nǝ iitǝr biya, ar gatǝgaan baz hulfa garava fadǝghǝri dǝ vakai nǝ Ibrahim lakwuti ɓagvar nǝ aguvaca. ");
INSERT INTO glwl_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Langyi kwa tavara kǝ Ibrahim ard hulfaan taakiya da gwigaan kǝ duniya, tavara tǝdvad gata adzahadzaha Muus biya, tavara kwakyarvad jiira kwa tlǝvkena tǝ ɗuula fadǝghǝra. ");
INSERT INTO glwl_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Akwama lii gata adzahadzaha Muus wa da gwiya duniya, mbats fadǝghǝra uud nalnǝg ba gyaagyana, dlaɓa maay nǝ tlǝra langyiya Daadamazhigǝl biya. ");
INSERT INTO glwl_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Aɗaba adzahadzaha saa dǝ badzga ǝrvidmahuɗa Daadamazhigǝla, vakavaki maay nǝ adzahadzah biya, kǝlvarwut bi nǝ adzahadzah biya. ");
INSERT INTO glwl_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Mbakyarvad kwaha, sagau tǝdvad fadǝghǝra nǝ langyiya. Kwana nalnǝg kwakyarvad hɛrǝrra Daadamazhigǝla, dlaɓa kiyava haivǝtǝrant kǝ hulfa Ibrahim baɗǝmma, kiyava lii gata adzahadzaha Muus kalti biya, baz lii fardǝghǝrǝtfǝg bandkwa ɓagaa nǝ Ibrahim. Aɗaba Ibrahim nǝ daadamiyam baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Bandkwa vindavindan ma kakkaɗ taakiya, “Nankadalnǝg kǝ Daad kǝ jibah ɗyakka,” Aɗaba righavantrighǝg langyi na. Daadamiyam nǝ Ibrahim tǝvuukwa Daadamazhigǝl aɗaba fǝdghǝrǝtfǝg tǝ Daadamazhigǝla, kwa iin dlaɓ wa vǝlla shifǝg kǝ lii ma ghǝtlaha. Iin dlaɓ wa dǝ ndzǝɗa ɗaha dǝgitahi kwa ndza maaya, ar dzaara. ");
INSERT INTO glwl_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ndza maay nǝ Ibrahim dǝ fantaara taakiya da tlǝkǝnatlǝg kǝ zarǝh biya, bakǝvakwaha, fadǝghǝrǝtfǝg nǝ Ibrahim tǝ Daadamazhigǝla za ba vuuk dǝ fantaar bandkwa taghaar Daadamazhigǝl taakiya “Hulfagha da ba ɗyakka.” ");
INSERT INTO glwl_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ma sarta kwahiina, ndza tamaha viig dǝrmǝk nǝ Ibraahima, ma vazǝg nǝ inna nalnǝg kǝ malah kǝ ya zǝra, dlaɓa uusan Saratu yiga bi kǝ zǝr biya, ba sǝrgasǝrǝg nǝ Ibrahim kǝ kwanahaan, bakǝvakwaha kǝlghardǝm bi kǝ ɓǝj ma vǝgh tǝdvad fadǝghǝraan biya. ");
INSERT INTO glwl_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Tapǝghǝna bi nǝ Ibrahim kǝ ɓa ndaundawa taakiya da maay Daadamazhigǝl righa langyiyan biya. Ɗuughars bi kǝ fadǝghǝraan biya, dlakulva kwaha gwiya fǝgharabadfǝg kǝ ndzǝɗ ma fadǝghǝraana, gala Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Dlaɓa ndzǝga ba dǝ fadǝghǝr nǝ iin taakiya mǝng Daadamazhigǝl dǝ ndzǝɗa righa langyiya ");
INSERT INTO glwl_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Mbakyardvad fadǝghǝraan kǝ Ibrahima, iin wa fadǝm Daadamazhigǝl kǝ jiiraan ma kǝdlakula. ");
INSERT INTO glwl_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Kwa ɗaha Daadamazhigǝl kǝ Ibrahim taakiya, “Dadda jiir na,” vindava kwakyarvad iin pall biya. ");
INSERT INTO glwl_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Vindava baz kǝmiyam wan kǝ ǝlbǝga, kǝmiyam ndakwi da fǝkiyamfǝg Daadamazhigǝl ma kǝdlakula uudaha jiijiira, kǝmiyamǝn fiyamndǝghǝrǝt tǝ daddakwa ciighant Yesu Yaazhigǝlamiyam ma gǝtlaha. ");
INSERT INTO glwl_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Vǝlavda mbakyarvad haipahamiyam Yesu kiyava ǝmtsǝga, civant dlaɓ dǝ shifǝg mbakyarvad kiyam tlǝkǝna kǝ ndzǝgan kwal haip tǝvuukwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Mbakyarvad kwaha, nakiyamdalnǝg tsaw Daadamazhigǝl ba kalkal tǝvuukwaan tǝdvad fadǝghǝra, kiyam dǝ gabǝrǝr dǝ Daadamazhigǝl tǝdvad Yaazhigǝlamiyam Yesu Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Tlǝyamkǝna tǝdvad iin kǝ ɗuula hɛrǝrr kwa kiyam ndzǝga nǝ miyam ma vakai tǝdvad fadǝghǝramiyama. Dlaɓa kiyam da tsa kusǝgh mbakyarvad kiyam dǝ fantaar ma ndangǝra Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ba kwah kalti biya, baz tsa kusǝgh kǝskǝmiyam ma dlaɗi kiyam hǝɓǝg nǝ miyama, aɗaba kiyam sǝrgasǝrǝg taakiya, saa dǝ ɓǝshgaana. ");
INSERT INTO glwl_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Ɓǝshgaan saa dǝ hǝnkala marawa, hǝnkal maraw dlaɓa, saa dǝ fantaara. ");
INSERT INTO glwl_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Da fǝkiyamdǝmbi fantaar ma zhiru biya, aɗaba fadǝmfǝg Daadamazhigǝl kǝ waiyavan ma ǝrviɗmahuɗamiyam tǝdvad Shǝɗǝkwaan kwa vǝlakiyam Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Ba kalkala sartǝn pǝlyakiyamva mǝlgaru kǝ ghǝramiyama, ǝmtsaǝmtsǝg Kǝristi mbakyarvad kǝmiyama, kǝmiyamǝn kiyam maay gǝdza Daadamazhigǝlǝn biya. ");
INSERT INTO glwl_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Tlǝvkǝna ba dlah nǝ uudi ǝmtsǝgamtsǝg kwakyarvad uuda jiijiira, bakǝvakwaha mbatak mǝng daddakwa dzugwandzugw kǝ ǝmtsǝg mbakyarvad kanaadiya uuda. ");
INSERT INTO glwl_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Marakiyamdamarǝg Daadamazhigǝl kǝ ɗyakǝra waiyavana, bamma sartǝn kiyam ba ndzǝgaan bamma haipahamiyama, ǝmtsaǝmtsǝg Kǝristi mbakyarvad kǝmiyamma. ");
INSERT INTO glwl_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Tlǝyamkǝnatlǝg tsaw kǝ ndzǝga kalkal tǝvuukwa Daadamazhigǝl tǝdvad avǝza Kǝristi, kyakaɗava ndakwani kaciya, da katǝkiyamkatǝg nǝ uud sagal ma badzǝga ǝrvidmahuɗa Daadamazhigǝl tǝdvad Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Bamma sartǝn ndza kiyam ɓa tlǝghum dǝ Daadamazhigǝla, ɓadlavǝnaɓadlǝg taatakamiyam dǝ Daadamazhigǝl tǝdvad ǝmtsǝga zǝraana, kyakaɗava ndakwani ɓadlavǝnaɓadlǝg taatakamiyam dǝ Daadamazhigǝli kaciya, da katǝkiyamkatǝg nǝ uud tǝdvad ndzǝgana zǝraana. ");
INSERT INTO glwl_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Maay ba wah ndakwani, baz tsa kusǝgh kǝskǝmiyam tǝ Daadamazhigǝl mbakyarvad dǝgiti ɓaga nǝ iin tǝdvad Yaazhigǝlamiyam Yesu Kǝristi, kwa tǝdvad iin wa ɓadlavǝna taatakamiyam dǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Bandkwa sǝgha haip samma duuni tǝdvad uud palla, haipǝn wa sadaa ǝmtsǝga, sǝgha ǝndkwah nǝ ǝmtsǝg da tǝ uuda dǝgshig baɗǝmma, aɗaba aanji ba wara ɓagaaɓag kǝ haipa. ");
INSERT INTO glwl_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Lakuti sagaw kǝ adzahadzaha Muusa, ndza ba mǝng haip ma duuniya. Ndza maay fav ma kǝdlakul haip vakavaki maay nǝ adzahadzah biya. ");
INSERT INTO glwl_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Bakǝvakwaha, ndza ba ǝmtsǝg wandza kwara uudah baɗǝmma ciigǝt ma zamana Adamu tangw damma zamana Muusa, baz kwara lii haipahaatǝr dǝga kǝla adzahadzah bi ǝndkwa kǝlada nǝ Adamu biya. Adamu garava daddakwa da sagaw na. ");
INSERT INTO glwl_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Gyagyana Daadamazhigǝl kwa vǝlada nǝ iin tǝdvad Yesu, gǝrgǝr dǝ dǝga Adamu kwa kǝllada adzahadzaha Daadamazhigǝla. Tǝdvad adzahadzahǝn kǝllada nǝ uud pallna, iin wa sǝgharda ǝmtsǝg kǝ uudah ba ɗyaka. Aɗaba hɛrǝrra Daadamazhigǝl wa juujig kǝ ɗyaka, kwakyarvad gyagyanǝn vǝlada nǝ iin tǝdvad hɛrǝrra uud pallna, kwa iin Yesu Kǝristi, yighantyig kǝ bark ba ɗyak da tǝghǝr uudaha. ");
INSERT INTO glwl_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Ba pakatta, gyagyana Daadamazhigǝl gǝrgǝr dǝ haipa uud pallna. Shariyi da sagaw tǝhalla haipa uud pallna iin ghazǝga, amma gyagyana Daadamazhigǝli vǝlada nǝ iina, iin wa nakiyamdal ba kalkal tǝvuukwana, aanji ba ɓagiyamaɓag kǝ haip ba ɗyaka. ");
INSERT INTO glwl_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Tǝdvad haipa uud palla, Adamuwa, ǝmtsǝg wa ndza kwarǝga, kwan kǝ kwarǝg maay dǝgiti tuuk vakai nǝ iin biya, akwama gǝravnagǝrǝg dǝ kwa sadaa Yesu Kǝristi! baɗǝm lii dlǝgharadlǝghǝg kǝ hɛrǝra Daadamazhigǝl ɗyaka ar ba kalkal tǝvuukwan ar da kwarǝg tǝdvad Yesu nǝ iitǝr ma ndzǝganatǝra. ");
INSERT INTO glwl_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Mbakyarvad kwaha, bandkwa sadaa haipa uud pall kǝ ghazǝg da tǝghǝr kǝ uudah baɗǝmma, bandkwah dlaɓ tǝdvad tlǝra uuda jiijiira, nadalnǝg kǝ uudah ba kalkal baɗǝm tǝvuukwa Daadamazhigǝla ar tlǝkǝna kǝ daala shifǝga. ");
INSERT INTO glwl_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Bandkwa naral nǝ uudah ba ɗyak kǝ yaa dadda haip tǝdvad uud pall kwa fǝghaarabi kǝ Daadamazhigǝl biya. Ar da nǝg bandkwah nǝ uudah ba ɗyak ba kalkal tǝvuukwa Daadamazhigǝl tǝdvad uud pall kwa fǝghaarafǝga. ");
INSERT INTO glwl_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Vǝlavdavǝlǝg nǝ adzahadzaha Muusa kiyava mara haipa. Ma sartǝn fǝgarabadfǝg nǝ haipa, hɛrǝrra Daadamazhigǝl wa jujig kǝ fǝgarafǝga. ");
INSERT INTO glwl_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Bandkwa kwarǝg nǝ haip kǝ uudah tǝdvad ǝmtsǝga, kwarǝg bandkwah dlaɓ nǝ hɛrǝrra Daadamazhigǝl kǝ uudah tǝdvad uuda jiira, kiyava langkiyamlang da tlǝkǝna shifǝga tangw damma zǝrazǝr tǝdvad Yesu Kǝristi Yaazhigǝlamiyama. ");
INSERT INTO glwl_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Auci wa kiyam da tag nǝ miyammi? Kiyam ba za vuuk dǝ ɓa haip kiyava fǝgarafǝg kǝ hɛrǝrra Daadamazhigǝl nii? ");
INSERT INTO glwl_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Maaya! Əndkwah biya! Kiyam ǝmtsaǝmtsan tǝdvad ɓa haipa, kiyam da ɓaga ndandar kaci kǝ za vuuk dǝ ndzǝga ma haipi? ");
INSERT INTO glwl_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Mbats, am sǝrgabi taakiya baɗǝmmamiyamǝn ɓagakiyamaɓag nǝ uud kǝ tsuufǝg damma Kǝristi Yesu, ɓagakiyamaɓag nǝ uud kǝ tsuufǝg damma ǝmtsǝgaan biya? ");
INSERT INTO glwl_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Hǝɗakiyamahǝɗǝg nǝ uud ǝmtaɗ dǝ iin tǝdvad tsuufǝga miyama, niyamalnǝg kǝ uud pall dǝ iin tǝdvad ǝmtsǝgaana, bandkwa ciyavant Kǝristi ma gǝtlah tǝdvad ndzǝɗa ndangǝra Daada, kǝmmiyam ndakwani, ɓagiyamɓag kǝ daala ndzǝgana. ");
INSERT INTO glwl_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Niyamalnǝg tsaw kǝ uud pall dǝ iin tǝdvad ǝmtsǝgaana, ba pakatta, kiyam da nǝg kǝ uud pall band iin ma ciigaan ma gǝtlaha. ");
INSERT INTO glwl_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Kiyam sǝrgasǝrǝg taakiya, hǝrtavǝthǝrtǝg nǝ ǝnghura ndzǝgana miyam ǝmtaɗ dǝ iina, mbakyarvad kalǝvda ndzǝɗa haipǝn kwa ma vǝghamiyama. Kwanǝnna, ɓagava haik da madlabi keskǝmiyam ma ɛɛva haip biya. ");
INSERT INTO glwl_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Aɗaba akwama ǝmtsaǝmtsǝg nǝ uuda, tlakǝnatlǝg kǝ kwara ghǝra sagal ma izhangyil kǝ ndzǝɗa haipa. ");
INSERT INTO glwl_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Akwama ǝmtsiyamaǝmtsǝg ǝmtaɗ dǝ Kǝristi, fiyamdǝghǝrǝtfǝg kiyam da ndzǝga ǝmtaɗ dǝ iina. ");
INSERT INTO glwl_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Aɗaba kiyam sǝrgasǝrǝg taakiya ciyavantciig Kǝristi ma gǝtlaha, da madlabi ǝmtsǝg biya, dlaɓa da maay nǝ ǝmtsǝg dǝ ndzǝɗ tǝghǝr kǝ iin biya. ");
INSERT INTO glwl_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Əmtsǝgaana, ǝmtsaa ba shig palla gwiya fǝgharnaa biya, kaladakalǝg kǝ ndzǝɗa haipa, ndzǝgani ɓagaa nǝ iina, ndzǝgani naag Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Kuram ndakwi kǝsamantkǝsǝg kǝ ghǝraru bandgi am ǝmtaǝmtsan kǝ ndzǝɗa haipa. Aɗaba am dǝ shifǝg vak Daadamazhigǝl tǝdvad Kǝristi Yesu. ");
INSERT INTO glwl_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Mbakyarvad kwaha, ɓǝlamarnabi kǝ haip kwara vǝgharu kwa ǝmtsǝgǝn biya, haik da fǝkura kǝmma ɓa dǝgitahi ghwaɗa. ");
INSERT INTO glwl_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ɓǝlamarnaabi kǝ uuɓiya vǝghaharu kǝ haip nal kǝ kadlangaha ɓa tlǝra kǝlaadǝr biya. Bamma am vǝlar kǝ ghǝraru kǝ Daadamazhigǝl band lii ngdlavtǝra tuuk kǝ ǝmtsǝga damma shifǝga. Ɗlaɓa vǝlamdavǝlǝg kǝ uuɓiya vǝghaharu kiyava nǝg kǝ kadlanga ɓa tlǝra jiijiir kǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Aɗaba da madlabi haip kwara kuram biya, mbakyarvad am madlabi ma izhangyil kǝ adzahadzaha Muus biya, am ma izhangyil kǝ hɛrǝrra Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Ndandar kaci? Ba kiyam ɓagaan kǝ haip aɗaba kiyam madlabi ma izhangyil kǝ adzahadzaha, kiyam ma izhangyil kǝ hɛrǝrra Daadamazhigǝla? Maaya! Əndkwah biya! ");
INSERT INTO glwl_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Am sǝrgabi taaki akwama vǝlamdavǝlǝg kǝ ghǝraru kǝ uudana, namalnǝg kǝ ɛɛva dadda kwama fǝgaara nǝ uuram biya? Namalnǝg kǝ ɛɛva haipa, kwa saa dǝ ǝmtsǝga, bii ɛɛva fǝgaara kǝ Daadamazhigǝl, kwa langa uud da tǝ ɗuul kalkala. ");
INSERT INTO glwl_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Gangal bark kǝ Daadamazhigǝla, aanji ndzam ba ɛɛva haip wura, amma ndakwan am fǝgaarafǝg ba dǝ ǝrviɗmahuɗ pall kǝ tsagi famdǝm nǝ uuram ghǝraru ma vakaiya. ");
INSERT INTO glwl_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","varakurdavarǝg nǝ uud sagal ma haipa, namalnǝg kǝ ɛɛva ɓa tlǝr kalkala. ");
INSERT INTO glwl_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Ən tagkur kwan kǝ ghai bandkwa tag nǝ uuda dǝgshig kǝ ghaiya, mbakyarvad hǝtsǝgalhǝtsǝgaru tǝdvad ndzǝgan uudǝra. Band kwa namǝt nǝ uuram wur kǝ vǝla uuɓiya vǝghaharu kiyava ɓa kwatǝnahǝr kǝ dǝgitahi ghwaɗa, ard ɓa tlǝra kǝlaadǝr kwa fǝgaraabadfǝg kǝ zaa vuuk ba vaivaiya, amma ndakwan ciya, vǝlamdavǝlǝg kǝ uuɓiya vǝghaharu kiyava ɓa ɛɛvǝr ba kalkal tǝvuukwa Daadamazhigǝla. Kiyava nǝg kǝskuram kǝ lii cacuwanacacuwan kwa favtǝran ba kǝrkagyakw kǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ma sartǝn ndzam ɛɛva haip nǝ uurama, ndza maay lambaru dǝ tlkǝna ndzǝgana kalkal tǝvuukwa Daadamazhigǝl biya. ");
INSERT INTO glwl_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Au kaci paiɗa dǝgiti tlamkǝna nǝ uuram ma dǝgitahaan kwa nalnǝg kǝ dǝga zhǝru kǝskuram ndakwani? Dǝgshiga kwanahaan kǝ dǝgitah ǝmtsǝga! ");
INSERT INTO glwl_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ndakwan ciya varakurdavarǝg nǝ uud sagal ma haiparuwa, namalnǝg ɛɛvaha Daadamazhigǝla. Dǝgitahi am tlǝkǝna nǝ uuram ma kwanǝnna, iin wa sakurda samma ndzǝgan cacuwanacacuwana, kwa da vǝlkur shifǝg tangw damma zǝrazǝra. ");
INSERT INTO glwl_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Aɗaba dǝgshiga haipa ǝmtsǝga, gyaagyaana Daadamazhigǝla, iin shifǝg tangw damma zǝrazǝr tǝdvad Kǝristi Yesu Yaazhigǝlamiyama. ");
INSERT INTO glwl_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Am sǝrgabi zaraabah biya, ǝn taa kǝ lii sǝrgasǝrǝg kǝ adzahadzaha Muusa, adzhadzaha Muusa dǝ ndzǝɗ ba tǝghǝr kǝ daddakwa dǝ shifǝga. ");
INSERT INTO glwl_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Band garava, tǝdvad adzahadzaha Muusa, maba ma vǝgya zhiil nǝ uusa, ba ma izhangyil kǝ kwarǝga zhiilaan akwama ba dǝ shifǝg zhiilaana. Akwama ǝmtsaǝmtsǝg zhiilaana, madlabi ma kwarǝga adzahadzah biya. ");
INSERT INTO glwl_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Mbakarvad kwaha, akwama kǝsuukǝsǝg kǝ zhiili tlǝrn ma ba dlaɓ nǝ zhiilan dǝ shifǝga, da ɗahav dǝ dadda gwaragwara, akwma ǝmtsaǝmtsǝg nǝ zhiilaana, tlakǝnatlǝg kǝ kwara ghǝraan tǝdvad adzahadzaha kǝssa zhiilla. Tǝhalakwaha, akwama gwiya kǝsuukǝsǝg kǝ zhiila, dadda gwaragwar biya. ");
INSERT INTO glwl_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Zaraabahara, kwanǝn kǝ garav tǝghǝr kǝskurama. Tǝdvad matla vǝgharu dǝ vǝgha Kǝristi am ǝmtsamǝtsan kǝ adzahadzaha Muusa, dlaɓa am dǝga uudi tlǝrǝn ndakwana, am dǝga daddakwa ciyavant ma gǝtlaha. Kwakyarvad kwaha, kiyam ɓagaɓag kǝ dǝgiti maraw kǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Ma sarta kwa ndza kiyam ndzǝga tǝdvad uudǝra, ndza shahkiyamshahǝg nǝ adzahadzah kǝ kǝmma dǝgit ghwaɗa. Kwan kǝ kǝmma dǝgitaha, kaa ɓa tlǝr ma vǝghamiyama, dlaɓa baɗǝm tlǝrahi ghwaɗ ɓagiyam nǝ miyam ɓagiyamar ba tlǝr maraw kǝ ǝmtsǝga. ");
INSERT INTO glwl_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Amma ndakwan ngǝdlǝyamangǝdlǝg sagal ma kwarǝga adzahadzaha Muusa, aɗaba ǝmtsiyamaǝmtsǝg ma adzahadzaha Muus kwa nguɗakiyamanguɗǝga. Mbakyarvad kwaha, kiyam ɓagar kwatnahǝr kǝ Daadamazhigǝl ma daala ndzǝgan ma shiɗǝkwana. Ənghura kwatǝnahǝrǝn ndza kiyam ɓagar nǝ miyam kǝ adzahadzaha Muusa, dalla. ");
INSERT INTO glwl_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Au kaci wa kiyam da tag nǝ miyami? Haip nǝ adzahadzaha Muusa? Ba pakat maaya, maa sǝrana bi kǝ haip akwama maay tǝdvad adzahadzaha Muus biya. Akwa maa tagada bi nǝ adzahadzah taakiya, “Kǝmbi kǝ dǝgit biya,” mana ndza sǝrgabi kǝ dǝgit tagav dǝ kǝmma dǝgit biya. ");
INSERT INTO glwl_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Amma mbakyarvad adzahadzahna, kaa ba tlǝkǝntlǝg kǝ haip kǝ ɗuula shaha aanji hulfa kwar kǝ kǝmǝg ma vǝghara. Aɗaba ma maay tǝdvad adzahadzah biya, ndza ǝmtsaǝmtsa haipa. ");
INSERT INTO glwl_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Ma sarta kwa ndzan sǝrga bi nai kǝ adzahadzaha Muus biya, ndzan ba dǝ shifǝga, sǝranaaka ba nai kǝ adzahadzahna, kaa ba ciig kǝ haip dǝ shifǝga, kaa ba ǝmtsǝg kǝskaiya. ");
INSERT INTO glwl_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Nǝghanaakanǝghǝg dlaɓ taakiya, adzahadzahǝn kwa tlatlav da saa dǝ shifǝgna, iin wa sǝghwada ǝmtsǝga. ");
INSERT INTO glwl_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Tlakǝnatlǝg haip kǝ ɗuulaana, valakwadavalǝg tǝdvad adzahadzaha, dlaɓa tsakwiitsǝga. ");
INSERT INTO glwl_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Mbakyarvad kwaha, adzahadzah kataghǝraana, cacuwanacauwana, tsagaanana, cacuwanacacuwana, ba kalkala dlaɓa marawa. ");
INSERT INTO glwl_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Aitsaa, da tagav nii taaki tsagaanaan marawǝn wa sǝghwada ǝmtsǝgna? Maaya! Əndkwah biya! Tǝdvad tsagaanaan marawǝna, sǝghwadasǝg haip kǝ ǝmtsǝga. Mbakyarvad sǝrvan gyigyiya haipa, tǝdvad adzahadzah wa sal nǝ haip da tǝ ɓalaɓal baz kǝlaadǝraan ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Kiyam sǝrgasǝrǝg taakiya, tsagaana Muusa, dǝga shǝɗǝkwa, kaiya ǝn band ndzǝgana uuda dǝgshiga, ɛɛva kǝ haipa. ");
INSERT INTO glwl_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ən nǝghǝgaaka bi kǝ dǝgiti ǝn ɓag nai biya, aɗaba dǝgiti ǝn naag nai kǝ ɓagaana, iin bi wan ɓag nai biya. Ɗlaɓa dǝgiti ǝn naa bi nai kǝ ɓagaan biya, iin wan ɓag naiya. ");
INSERT INTO glwl_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Akwama dǝgiti ǝn ɓag naiya, iin bi wa naag ghǝrar kǝ ɓagaan biya, haiyananthaig taakiya maraw nǝ adzahadzaha. ");
INSERT INTO glwl_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Aɗaba kai dǝ ghǝrar bi wa ɓagaan biya, ba haipǝn ndzǝga ma kaiyǝn wa ɓagaana. ");
INSERT INTO glwl_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Ən sǝrgasǝrǝg taakiya, ma ndzǝgana uuda dǝgshigara, maay nǝ dǝgit maraw ndzǝga ma kai biya, aɗaba ǝn naagaan kǝ ɓa dǝgit marawa, bakǝvakwaha, ɗǝmghwavaaɗǝmga. ");
INSERT INTO glwl_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Ən maay ɓa dǝgiti maraw naag ghǝrar kǝ ɓagaan biya, ǝn ɓa ba tlǝra kǝladǝri naa bi ghǝrar kǝ ɓagaan biya. ");
INSERT INTO glwl_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Aiciya, akwaman ɓa ba dǝgiti naay ghǝrar kǝ ɓagaan biya, maradamarǝg taakiya kai bi wa ɓa kwan kǝ dǝgit biya, haipǝn ndzǝga ma kaiyǝn wa ɓagaana. ");
INSERT INTO glwl_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Kaa nǝghǝgaakanǝghǝg kǝskai taakiya, nalnǝg kǝ vǝgh kǝskaiya, akwaman naa ɓa dǝgit marawa, kaa nǝghǝgaakanǝghǝg kǝskaiya, mbats kǝlaadǝr ba ǝmtaɗ dǝ kaiya. ");
INSERT INTO glwl_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Aɗaba haiyananthaig dǝ adzahadzaha Daadamazhigǝl ma ǝrviɗmahuɗara, ");
INSERT INTO glwl_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Man zharǝg naiya, mǝng nǝ watlǝrn kǝ adzahadzah shah ma uuɓiyaha vǝghara kwa ɓa ghwav dǝ adzahadzahi kwa haighant ghǝrara, ngwuɗakwingwuɗeg wan kwakyarvad adzahadzah kwa ndzǝga ma uuɓiya vǝghara. ");
INSERT INTO glwl_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Kayin badzabadza nǝ ǝrviɗmahuɗna! War wa da katkwakatǝg sagal ma vǝghǝn dǝga ǝmtsǝg nii? ");
INSERT INTO glwl_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Gangal bark kǝ Daadamazhigǝl aɗaba katakutkatǝg tǝdvad Yesu Kǝristi Yaazhigǝlamiyama! mbakyarvad kwaha, ma ǝrviɗmahuɗar ǝn ɓagar ɛɛva kǝ adzhadzaha Daadamazhigǝl, ma ndzǝgana uuda dǝgshigara ǝn ɓagar ɛɛva kǝ adzahadzaha haipa. ");
INSERT INTO glwl_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Mbakyarvad kwaha, madlabi ghazǝg ndakwan tǝghǝr kǝ lii dǝga Kǝristi Yesu biya. ");
INSERT INTO glwl_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Aɗaba adzahadzaha Shǝɗkwa Daadamazhigǝl kwa vǝla shifǝga, iin wa ngǝdlakwi sagal ma adzahadzaha haip ard ǝmtsǝga tǝdvad Kǝristi Yesu. ");
INSERT INTO glwl_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Dǝgiti ɓagaa bi nǝ adzahadzaha Muus mbakyarvad hǝtsǝgalhǝtsǝga uuda dǝgshiga biya, iin wa ɓagaa Daadamazhigǝla. Ɓǝladiɓǝlǝg nǝ Daadamazhigǝl kǝ Zǝraan pall ba nǝ iin dǝ dzakǝva vǝghamiyam kwa dǝ haipa, kiyava nǝg kǝ dǝga kyulǝg mbakyarvad haipa. dlaɓa kalvǝda ndzǝɗa haip ma vǝgha. ");
INSERT INTO glwl_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ɓagaa mbakyarvad righant Daadamazhigǝl baɗǝm kǝ tlǝra jiijiir kwa taga nǝ adzahadzaha Muus taaki aa ɓagavɓag ma kǝmiyama, kǝmiyamǝn kiyam nzǝgan tǝdvad uuda dǝgshigǝr biya, kiyam ndzǝga tǝdvad Shǝɗkwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Lii ndzǝgan tǝdvad uuda dǝgshigǝra, ghǝraatǝr ba tǝ dǝgiti naag nǝ vǝgha, amma lii ndzǝgaan tǝdvad Shǝɗkwa Daadamazhigǝla ghǝraatǝr ba tǝ dǝgiti naag Shǝɗkwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Fa hǝnkal tǝ dǝgiti naag nǝ vǝgha saa dǝ ǝmtsǝga, dadda kwa fa hǝnkalaan tǝ dǝgiti naag nǝ Shǝɗkwa Daadamazhigǝla, saa dǝ shifǝga ard gabǝrra. ");
INSERT INTO glwl_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Ɓaɗǝm daddakwa fa hǝnkalaan tǝ tlǝra vǝgh ɓa tlǝghum dǝ Daadamazhigǝla, aɗaba fadǝmbi kǝ ghǝraan ma gata adzahadzaha Daadamazhigǝl biya, dlaɓa ɓagna biya. ");
INSERT INTO glwl_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Lii ndzǝgan tǝdvad tlǝra vǝgha, ar ɓagarabi kǝ dǝgit tǝ wayaan kǝ Daadamazhigǝl biya. ");
INSERT INTO glwl_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Aɗaba am maay ndzǝga tǝdvad uuda dǝgshig kwa tagkur nǝ iin taaki ɓagamɓag biya, bamma am ndzǝga tǝdvad dǝgiti tagkur Shǝɗkwa Daadamazhigǝla, akwama Shǝɗkwa Daadamazhigǝl wa ndzǝga ma ǝrviɗmahuɗaruwa. Baɗǝm daddakwa maay dǝ Shǝɗkwa Kǝristi biya, dǝga Kǝristi bi nǝ iin biya. ");
INSERT INTO glwl_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Akwama Kǝristi wa ndzǝgan ma kurama, aanji ba ǝmtsǝmtsan nǝ vǝgharu mbakyarvad haipa, Shǝɗkwa Daadamazhigǝl vǝlkurvǝlǝg kǝ shifǝg mbakyarvad dlǝghakuradlǝghǝg Daadamazhigǝl ma ndzǝgana lii kalkala. ");
INSERT INTO glwl_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Akwama Shǝɗkwa Daadamazhigǝl kwa ciighant Yesu ma gǝtlah wa ndzǝga ma ǝrviɗmahuɗaruwa, ba Daadamazhigǝlǝn ciighant Kǝristi ma gǝtlaha, iin wa da vǝla shifǝg kǝ vǝgharu kwa dǝga ǝmtsǝga tǝdvad Shǝɗkwaan kwa ndzǝgan ma kurama. ");
INSERT INTO glwl_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Mbakyarvad kwah zaraabaha, kiyam mǝng dǝ tlǝra, amma tǝdvad ndzǝgana uudǝr kwa naag nǝ vǝgh biya. ");
INSERT INTO glwl_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Aɗaba akwamam ɓa dǝgiti naag nǝ vǝgha, am da ǝmtsǝga. Akwama tsama tǝdvad ndzǝɗa Shǝɗkwa Daadamazhigǝl nǝ uuram kǝ haipa, am da tlǝkǝnatlǝg kǝ shifǝga. ");
INSERT INTO glwl_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Baɗǝm lii ndzǝga tǝdvad Shǝɗkwa Daadamazhigǝla, ar zarha Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Aɗaba Shǝɗkwa Daadamazhigǝlǝn vǝlakur nǝ uudǝna, dǝga ɛɛvǝr kwa da gwiya fǝkura nzǝgaan ma dladlawur biya. Maaya, Shǝɗkwǝn dǝga nǝg kǝ zarha Daadamazhigǝla, dlaɓa tǝdvad Shǝɗkwǝn wa kiyam ɗaag nǝ miyam kǝ Daadamazhigǝla, kiyam taakiya “Abba! Daada!” ");
INSERT INTO glwl_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Shǝɗkwa Daadamazhigǝl dǝ ghǝraan ard Shǝɗkwamiyam tagakiyamdatag taakiya kiyam zarha Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Niyamalnǝg tsaw kǝ zarhaana, niyamalnǝg kǝ yaa dadda gwiga, lii da gwiya barka Daadamazhigǝla dlaɓa tsaghwa gwig ǝmtaɗ dǝ Kǝristi. Akwama hǝɓǝyamuhǝɓǝg kǝ dlaɗ ǝmtaɗ dǝ Kǝristi, da fǝkiyamaarafǝg nǝ uud ǝmtaɗ dǝ iina. ");
INSERT INTO glwl_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Fandghǝrǝtfǝg taakiya, da gǝrvnabi nǝ dlaɗahi kiyam hǝɓǝg nǝ miyam ma kwan kǝ zaman biya, ard ndangǝri da markiyam nǝ uud tǝvuukwa. ");
INSERT INTO glwl_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Baɗǝm dǝgitahi vǝrɗyavan ar kǝmǝg ba vaivaiya, ar pakka nǝgha faciyin kwa da marǝg Daadamazhigǝl kǝ zarhaana. ");
INSERT INTO glwl_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Dǝgiti vǝrɗyavan hǝtsalarhǝtsǝg da tǝ dǝgiti naag Daadamazhigǝla, kwana kwakyarvad naaga dǝgitahi kwa vǝrɗyavan biya, aɗaba naha bandkwah Daadamazhigǝla. ɓagavaɓag nǝ wan dǝ fantaara, ");
INSERT INTO glwl_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","taakiya, dǝgiti vǝrɗyavan kataghǝraana, da ngǝdla sagal ma ɛɛvǝr kwa ǝrtsǝga, da tlǝkǝnatlǝg dlaɓ kǝ kwara ghǝra ndangǝra kwa da ɓagvǝtǝr kǝ zarha Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Kiyam sǝrgasǝrǝg taakiya, gwastaana, baɗǝm dǝgitahi vǝrɗyavana ar ngiig band uus ǝmhuɗ kwa kalkǝn kungula yigga. ");
INSERT INTO glwl_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Dǝgiti vǝrɗyavan kalti bi wa ngiig biya, baz kǝmiyama. Kǝmiyamǝn tlǝyamkǝna gyagyaan Shǝɗkwa Daadamazhigǝl ba zunngw ma dǝgitahi vǝlakiyam nǝ uuda, kiyam ngiig ma ǝrviɗya miyam, kiyam vaugaan ba vaivaiya, kiyava nǝkiyamdadal Daadamazhigǝl kǝ zarhaana, dlaɓa da varda kǝ vǝgha miyama. ");
INSERT INTO glwl_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Aɗaba katakiyamǝt tǝdvad fantaara nǝ uuda. Amma akwama nǝghǝyamanǝghǝg kǝ dǝgiti kiyam dǝ fantaar nǝ miyam tǝ vakaiya, tlal bi nǝ wan dǝ fantaar biya. Kwar kǝ uud wa dǝ fantaar tǝghǝr kǝ dǝgiti tlakǝnatlǝg nǝ iin ni? ");
INSERT INTO glwl_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Akwama kiyam dǝ fantaar tǝghǝr kǝ dǝgiti tlǝyamkǝna biya, kiyam vaugaan dǝ fa ǝrviɗmahuɗa. ");
INSERT INTO glwl_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Mǝlkiyamu bandkwah dlaɓ nǝ Shǝɗkwa Daadamazhigǝl tǝdvad hǝtsǝgalhǝtsǝga miyama. Kiyam sǝrga bi kǝ ɗuuli kiyam da dzug nǝ miyam kǝ zhigǝl biya, amma Shǝɗkwa Daadamzhigǝl bad ghǝraan wa ghala Daadamzhigǝl dlakulva miyam ǝmtaɗ dǝ ngiig kwa shǝvǝt bi ghai kǝ tagaan biya. ");
INSERT INTO glwl_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Daadamazhigǝli sǝrgasǝrǝg kǝ dǝgiti ma ǝrviɗmahuɗa uuda, sǝrgasǝrǝg kǝ dǝgiti tlatlǝg nǝ Shǝɗkwa Daadamzhigǝla, aɗaba Shǝɗkwa Daadamzhigǝl wa ghalǝg dlakulva uudaha Daadamazhigǝl tǝdvad naagana. ");
INSERT INTO glwl_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Kiyam sǝrgasǝrǝg taakiya baɗǝm ma dǝgitaha, ɓa ba tlǝra hɛrǝr Daadamazhigǝl kǝ lii waigaana, kwa ɗahatǝrǝt nǝ iin tǝdvad naagana. ");
INSERT INTO glwl_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Aɗaba lii kǝsatǝraaka Daadamazhigǝl ba wurwura, dlaɓa fatǝraafǝg kǝsa dzakǝva Zǝraana, mbakyarvad nal kǝ dǝga zunngw ma zaraabah ɗyaka. ");
INSERT INTO glwl_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Lii kǝsatǝraaka Daadamazhigǝla, iitǝr wa ɗahatǝrǝt nǝ iina. Lii ɗahatǝrǝt nǝ iina, iitǝr wa natǝrdal nǝ iin kwal haip tǝvuukwaana, lii natǝrdal nǝ iin kwal haip tǝvuukwaana, iitǝr dlaɓ wa fǝtǝraara nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Auci, wa kiyam da tag nǝ miyam tǝghǝr kwanahaan kǝ dǝgiti? Akwama ba ǝmtaɗ Daadamazhigǝl dǝ kǝmiyama, war wa tlǝgaltlǝg kǝ ɓa tlǝghum dǝ kǝmiyammi? ");
INSERT INTO glwl_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Piyakiyamdadda bi Daadamazhigǝl kǝ Zǝraan biya, vǝladavǝlǝg mbakyarvad kǝmiyam baɗǝmma. Daadamazhigǝlǝn vǝlakiyam Zǝraanǝna, mbats da vǝlkiyam bi kǝ dǝgitah baɗǝm biya? ");
INSERT INTO glwl_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","War wa da ɗiya ghunj tǝghǝr kǝ lii dzǝrghaaka Daadamazhigǝli? Ba Daaadamazhigǝl kata ghǝraan wa da nǝtǝrdalnǝg ba kalkal tǝvuukwaana. ");
INSERT INTO glwl_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","War wa tlǝgaltlǝg kǝ ghaza uudi? Maay wa tlaltlǝg biya. Kǝristi Yesu kwa ǝmtsaǝmtsǝga, bi kwa tagav taaki, daddakwa ciyavant ma gǝtlaha, iin wa cihurga tǝ dǝva kaffa Daadamazhigla, dlaɓa ghalla Daadamazhigǝl ma dlakulva miyama. ");
INSERT INTO glwl_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","War wa tagkwiyamatagw dǝ waiyava Kǝristi? Hǝɓa dlaɗ nii, dlaɗ nii, tlatlǝɓa pin nii, wai nii, talagǝr nii, fǝɗa duuni nii? Katsakar hii?. ");
INSERT INTO glwl_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Bandkwa vindavindan ma kakkaɗa Daadamazhigǝl taakiya, “Mbakyarvad kǝgh wa kǝm hǝɓǝg nǝmnd kǝ dlaɗa ǝmtsǝg ba kǝlaa hǝnga, nakǝmdaddanǝg nǝ uud band tuughwah kwa langav da vaka hǝrga. ");
INSERT INTO glwl_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Kwanahaan kǝ dǝgitahaan dzǝghaardzǝgǝn baɗǝmma, jiyamujig kǝ yaa dadda za fiira, tǝdvad dadda kwa waiya kǝmiyama. ");
INSERT INTO glwl_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Aɗaba fandǝghǝrǝtfǝg nai taakiya ma ǝmtsǝga, ma shifǝga, ma zarha ɓǝlga Daadamazhigǝla, ma shatanaha, ma hǝnkala ndakwana, ma kwa da tǝvuukwa, ma ndzǝɗah shahshaha, ");
INSERT INTO glwl_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ma tlaɗa, ma kyalangwa, aanji dǝgiti shah ma dǝgitahi vǝrɗyavan baɗǝmma, tlalar bi kǝ tagwa kǝmiyam dǝ waiyavǝn waikiyam Daadamazhigǝl tǝdvad Kǝristi Yesu Yaazhigǝla miyam biya. ");
INSERT INTO glwl_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ən taa ba jiir nai ma Kǝristi, fiid bi wan tag nai biya. Ma tǝ dzamaghǝrar ǝn sǝrgasǝrǝg ba pakkat tǝdvad tagaana Shǝɗkwa Daadamazhigǝl tǝghǝr kwannǝn taakiya ");
INSERT INTO glwl_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ǝn dǝ badzǝga ǝrviɗmahuɗ ba vaivaiya, dlaɓa mbakwambǝg ma ǝrviɗmahuɗara. ");
INSERT INTO glwl_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Ambana ma naa ba tlafatlafana, dlaɓa tagwkwi nǝ uud dǝ Kǝristi mbakyarvad zaraabahara, uudahar kwa jibara! ");
INSERT INTO glwl_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Kwanahaan kǝ uudah ar yaa Israila. Iitǝr wa natǝrdal Daadamazhigǝl kǝ zarhaana, martǝrdan dlaɓ kǝ ndangǝraana, taatǝg kǝ langyi dǝ iitǝra, vǝltǝr kǝ adzahadzaha Muusa, martǝrdan kǝ ɗuula ɓa kwatǝnahǝra jiijiira, vǝltǝr baz langyiyaha. ");
INSERT INTO glwl_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Hulfaatǝr saral bamma daadiija daadiij kwa sǝrǝvtǝrsǝrǝg ba vaivaiya. Kǝristi dlaɓ tǝdvad ndzǝgana uuda dǝgshiga, sal ma kuɗigaatǝr nǝ iina. Aa galavgalǝg Daadamazhigǝl kwa kwara dǝgitah baɗǝm tangw damma zǝrazǝra. Aandz bandkwaha. ");
INSERT INTO glwl_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Walaa hǝtsalhǝtsǝg bi nǝ ǝlbǝga Daadamazhigǝl kǝ righǝg biya. Aɗaba ɗǝm bi yaa Isra'il ar vizhvizha Isra'ilah biya. ");
INSERT INTO glwl_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Dlaɓa ɗǝm bi lii ma kuɗiga Ibrahim ar vizhvizha zarha Ibrahim biya. Dlakulvakwaha, am Daadamazhigǝl taa kǝ Ibrahima, “Da kǝdlav tǝdvad Ishaku hulfagha.” ");
INSERT INTO glwl_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Ɗǝm bi zarhi yaha nǝ Ibrahim wa zarha Daadamazhigǝl biya, bamma zarhi tlavkǝna tǝdvad righa langyiya Daadamazhigǝla, iitǝr wa ɗahvǝtǝr dǝ zarha jiijiira. ");
INSERT INTO glwl_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Aɗaba kwan nǝ dǝgiti taghar Daadamazhigǝl kǝ Ibrahim ma sarta kwa tǝghara nǝ iin kǝ lanngyi taaki, “Akwama da ɓagaaɓag sarta, da yigaan Saratu kǝ zǝr lakwti ǝn da gwiiya sagauwa.” ");
INSERT INTO glwl_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Maay ba wah ndakwani, dzǝgaadzǝg Rifkatu kǝ ghwalah dǝ daadamiyam Ishaku. ");
INSERT INTO glwl_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Lakwti yav zarhǝn buwna, taghartag Daadamazhigǝl kǝ Rifkatu taakiya, “Maalǝn da ɓagarnǝs kwatǝnah kǝ kudǝrǝna.” Tagavar kwakyarvad daddakwa da kǝsavǝna, da kǝsav tǝdvad naaga Daadamazhigǝla. Tǝdvad tlǝrahaan biya, tǝdvad ɗahǝga Daadamazhigǝla. Dzǝghaar lakwti ɓa dǝgiti marawa ard ghwaɗ kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Bandkwa vindavindan ma Kakkaɗa Daadamazhigǝl taakiya, “Waiyanantwaig kǝ Yakuba, ɗuwanantɗug kǝ Isuwa.” ");
INSERT INTO glwl_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Auci wa kiyam da tag nǝ miyami? Ɓagaa bi Daadamzhigǝl kǝ kalkal bi nii? Maaya! ǝndkwah biya! ");
INSERT INTO glwl_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Aɗaba taghartag Daadamazhigǝl kǝ Muus taakiya, “Daddakwan da margar da nai kǝ zhuwadaala, iin wan da zhugardaala naiya, daddakwan da margar da nai kǝ zanvaara, iin wan da zǝgarvaara naiya.” ");
INSERT INTO glwl_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Kwanǝnna, tsaghǝr tǝ naaga uud biya, bi dǝga ndzǝɗaan biya, amma aɗaba zhuwadaala Daadamazhigǝl kaltiya. ");
INSERT INTO glwl_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Am Kakkaɗa Daadamzhigǝl taa kǝ Firˈauna, “Nangkadalnǝg kǝ tlǝkǝs mbakyarvad ǝn marda kǝ ndzǝɗar tǝdvad kǝgha, dlaɓa tagvǝda ɗaagar ma duuni baɗǝmma.” ");
INSERT INTO glwl_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Tǝdvad kwah wa marǝg Daadamazhigǝl kǝ zhuwadaalaan kǝ daddakwa naag nǝ iin mararda kǝ zhuwadaalǝra, dlaɓa faraa kǝ dǝkdǝka ghǝr kǝ daddakwa naag nǝ iin faraa kǝ dǝkdǝka ghǝra. ");
INSERT INTO glwl_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Pallǝraru da taguwatag taakiya, “Akwama bandkwah tsa, aujilbǝg kaci kǝ Daadamazhigǝl gwaastaan zhara kǝmiyam dǝ haipi? War wa da lǝwalǝg kǝ haiya dǝgiti naag Daadamazhigǝli?” ");
INSERT INTO glwl_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Kǝgh uuda, agha war nǝnng agha da ɓala agajaw dǝ Daadamazhigǝli? Dǝgiti ndǝravana, tagardatag kǝ daddakwa ndǝrgandǝrǝg taakiya, “Agha ndǝrkwi kiyavau ǝndkwana?” ");
INSERT INTO glwl_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Abi dadda ndǝra shak ɓagaan nǝ iin kǝ tlǝr dǝ luu bandkwa naag nǝ iin kǝ ɓagaana. Ɓagaɓag nǝ iin kǝ tlǝr dǝ ɗakwarga luu palla ndǝra kǝ kwatlǝrǝn kǝ shak mbakyarvad tlǝr kwa ndannga, kyalmahaan dlaɓa mbakyarvad tlǝr kwa maay ndanng biya. ");
INSERT INTO glwl_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Bandkwah tlǝra Daadamazhigǝla. Nahanahǝg mardan kǝ badzǝga ǝrviɗmahuɗaana, dlaɓa mardan kǝ ndzǝɗaan ba tǝ ɓalaɓala. Faafǝg Daadamazhigǝl kǝ ǝrviɗmahuɗ ba vaivai ɓǝshtǝrɓǝshig kǝ lii maa dlayatǝr badzǝga ǝrviɗmahuɗaana, lii fatǝra Daadamzhigǝl kiyava ghyǝhga. ");
INSERT INTO glwl_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Bandkwah dlaɓ wa naha nǝ iin martǝrdan kǝ ɗyakǝra ndanngǝran kǝ lii maratǝrda nǝ iin kǝ zhuwadaala, kwa ɓadlatǝrna nǝ iin ba zunngw kiyava ndanngǝraana. ");
INSERT INTO glwl_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Baz kǝmiyama, kǝmiyamǝn ɗahakiyamǝt Daadamazhigǝlǝna, Yahudah kalti biya, baz lii ar Yahudah biya. ");
INSERT INTO glwl_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Bandkwa tagavda ma kakkaɗa Huzaaya taakiya, “Lii ar uudahar biya, ǝn da ɗahtǝrɗahǝg dǝ ‘Uudahara’. Ɗlaɓa lii ndza waiyantǝrǝt bi nai biya, ǝn da ɗahtǝrɗahǝg dǝ lii, ‘Ən waitǝr naiya.’ ” ");
INSERT INTO glwl_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Dlaɓa, ba kalkala vakavaki tagavtǝra taakiya, ‘Am uudahar bi na,’ da ɗahǝvtǝr vakwah taakiya, ‘Ar zarha Daadamazhigǝl dǝ Shifǝga.’ ” ");
INSERT INTO glwl_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Tuwatuug tlayanng Ishaya kwakyardvad Israˈila taakiya, “Aanji ar ba ɗyak nǝ uudaha Israˈila, ɗyakǝraatǝr band sǝghǝl ma zaagha, bakǝvakwaha tǝmgatǝr ba ǝnkykwah wa da katǝvtǝrkatǝga. ");
INSERT INTO glwl_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Aɗaba da tǝgaan Yaazhigǝl kǝ shariyan ma duuni baɗǝmma, ba kwal badza sarta.” ");
INSERT INTO glwl_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Bandkwa tagaa tlayanng Ishaya kǝ tlayanngǝraan ba wur taakiya, “Maa ndza maay kwakyarvad Yaazhigǝla yaa Tlaamazhigǝlah wa ɗuwakiyamnaa hulf biya, maa niyamalnǝg band Sodoma, maa nakiyamdalnǝg nǝ uud band Gomora.” ");
INSERT INTO glwl_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Au kaci wa kiyam da tag nǝ miyami? Lii ar Yahudah biya, kwa ghularva bi kǝ gata ndzǝgana kalkal tǝvuukwa Daadamazhigǝl biya, tlarkǝnatlǝga. Ndzǝgana kalkalǝn tlarkǝna nǝ iitǝrna, hulfa kwa tlǝvkǝna tǝdvad fadǝghǝra. ");
INSERT INTO glwl_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Amma Israˈilahi ghularvaghulǝg kǝ gata ɗuula ndzǝgan kalkal tǝvuukwa Daadamazhigǝl tǝdvad gata Adzahadzaha Muusa, tlarkǝna biya. ");
INSERT INTO glwl_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Aujilbǝg ǝndkwahi? Aɗaba gatar tǝ ɗuula fadǝghǝr biya, gatar tǝ ɗuula ɓa tlǝra. Kaa mbǝɗǝg kǝ iitǝr tǝ ɗuul da, “Akurǝn kwa fǝgaraa uud kǝ mbǝɗǝga.” ");
INSERT INTO glwl_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Bandkwa vindavindan ma Kakkaɗa Daadamazhigǝl taakiya, “Wan fǝgaan kǝ akur ma Sihiyona, akura tǝrɗa uud tǝ ɗuula, akura kwa fǝgaraa uudah kǝ mbǝɗǝga. Baɗǝm daddakwa fǝdghǝrǝtfǝg tǝ iina, da maay tsǝvar zhǝru biya.” ");
INSERT INTO glwl_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Zaraabahara, dǝgiti ma naag nǝ ǝrviɗmahuɗara, maa tlǝkǝnana yaa Israˈilah kǝ katǝga. Iin dzugwazhiglar vak Daadamazhigǝl mbakyarvad iitǝra. ");
INSERT INTO glwl_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Ən tagkurdatag taakiya ar nagaan kǝ ɓa kwatǝnahǝr kǝ Daadamazhigǝla, amma kwa nǝ iin kǝ dǝgit ar ɓag ba kwal sǝrgasǝrgatǝra. ");
INSERT INTO glwl_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Sǝrara bi tsaw kǝ jiira Daadamzhigǝl biya, dlaɓa ar ɓa kǝlaa ndzǝɗaatǝr kǝ gata ɗuulatǝri tlǝrn kiyava ndzǝga kalkal tǝvuukwa Daadamazhigǝla, mbakyarvad kwana, fardǝm bi kǝ ghǝraatǝr kǝ gata ndzǝgan kalakal tǝvuukwa Daadamazhigǝl biya. ");
INSERT INTO glwl_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kǝristi ghaala Adzahadzaha Muusa, aɗabad kwaha, baɗǝm daddakwa fadǝghǝrǝtfǝg tǝ iina, da tlaƙǝnatlǝg kǝ ndzǝgan kalkal tǝvuukwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Vindavindǝg Muus tǝghǝr kǝ ndzǝgan kalkal kwa tlǝvkǝna tǝdvad gata Adzahadzah taakiya, “Baɗǝm daddakwa gata ɗuula Adzahadzaha, da tlǝkǝnatlǝg kǝ shifǝg tǝdvad iina.” ");
INSERT INTO glwl_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Wai nǝ dǝgiti tagaa Kakkaɗa Daadamzhigǝl tǝghǝr kǝ ndzǝgan kalkal kwa tlǝvkǝna tǝdvad fadǝghǝra, “Tag bi ma ǝrviɗmahuɗagh, taaki, ‘War wa dǝgǝtdǝg damma ghǝrazhigǝli?’ ” Da sǝdi kǝ Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","“Nii agha tagan ha taaki, ‘War wa da daay damma fai vaka ndzǝgana lii ǝmtsaǝmtsani?’ ” Mbakyarvad ciyant kǝ Kǝristi ma gǝtlahi. ");
INSERT INTO glwl_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Dǝgiti tag Kakkaɗa Daadamazhigǝl iin taakiya, “Əlbǝga Daadamazhigǝl ba hǝrz dǝ kǝgha, bamma ghaiyagha, dlaɓa bamma ǝrviɗmahuɗagha.” Əlbǝgiin tǝghǝr kǝ ǝlbǝga fadǝghǝr kwa kǝm tag nǝmnd kǝ ǝlbǝg maraw tǝghǝra. ");
INSERT INTO glwl_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Akwama taghatag ba dǝ ghaiyagh taakiya Yesu Yaazhigǝl nǝ iina, dlaɓa fǝdǝghǝrǝtfǝg ma ǝrviɗmahuɗagh taakiya ciighantciig Daadamazhigǝl ma gǝtlahha, da katakkatǝg nǝ uuda. ");
INSERT INTO glwl_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Aɗaba fǝvdǝghǝrǝt ma ǝrviɗmahuɗ kǝ tlǝkǝna ndzǝgan kwal haip tǝvuukwa Daadamazhigǝla, dlaɓa tagav ba dǝ ghai pǝlaw agha tlǝkǝntlǝg kǝ Katǝga. ");
INSERT INTO glwl_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Bandkwa vindava ma Kakkaɗa Daadamazhigǝl taakiya, “Baɗem daddakwa fadǝghǝrǝtfǝg tǝ iina, da tsǝvara bi zhǝru biya.” ");
INSERT INTO glwl_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Aɗaba maay gǝrgǝr ma taataka Yahudaha ard lii ar Yahudah biya, ba Yaazhigǝlǝn pallna iin Yaazhigǝla aanji wara, iin dlaɓ wa vǝla bark ba ɗyak kǝ lii ɗaha ɗaagaan baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Bandkwa vindava ma Kakkaɗa Daadamzhigǝl taakiya, “Baɗǝm daddakwa ɗaha ɗaaga Yaazhigǝla, da tlǝkǝnatlǝg kǝ katǝga.” ");
INSERT INTO glwl_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Ar da ɗaag ndandar kaci kǝ daddakwa fardǝghǝrǝt bi tǝ iin biyi? Ar da fadǝghǝr ndandar kaci tǝ daddakwa taparna bi kǝ cinnga ǝlbǝg tǝghǝr kǝ iin biyi? Ar da cinnga ndandar dlaɓ akwama maay daddakwa da tagtǝr ǝlbǝg maraw biyi? ");
INSERT INTO glwl_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Ar da tag ndandar kaci lii taa ǝlbǝg maraw kǝ ǝlbǝg maraw akwama ɓǝlavtǝrǝt bi da tagaan biyi? Bandkwa vindava taakiya, “Dǝga jappǝr nǝ lii sarda ǝlbǝga Daddamazhigǝl marawa. ");
INSERT INTO glwl_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Ɗǝm bi nǝ Israˈilahi haiyaranthaig dǝ ǝlbǝg marawǝn biya. Bandkwa tagaa nǝ tlayang Ishaya taakiya, “Yaazhigǝla, war wa fadǝghǝrǝtfǝg tǝ ǝlbǝgǝn cinngha nǝ iin vakamnd nii? ");
INSERT INTO glwl_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Mbakyarvad kwaha, fadǝghǝr sagaw tǝdvad cinnga ǝlbǝg marawa, dlaɓa ǝlbǝg maraw sagaw tǝdvad cinnga ǝlbǝga Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Ən dǝ ndavǝg naiya, “Bak jiijiir tsa cinngara biya?” Cinngaracinnga. Aɗaba vindavavindǝg ma Kakkaɗa Daadamazhigǝl taakiya, “Cinngalcinng nǝ ghaiyatǝr aanji ta kwar ma duuni baɗǝmma, dlaɓa ǝlbǝgahaatǝr dal da tǝ ghaala duuniya.” ");
INSERT INTO glwl_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Ən gwiya ndavǝga. “Aitsa, nǝgharaaka bi nǝ yaa Israˈilah biya?.” Ngwatǝrangw Muus ba zunngw taakiya, am Daadamazhigǝla, “Ən da fǝkurafǝg kǝ shilga dlamaakǝlaaw kwar jibah biya, ǝn da fǝkurafǝg kǝ nguɗɗa ǝrviɗmahuɗ dǝ jibah kwar nǝghǝgaaka bi kǝ dǝgitah biya.” ");
INSERT INTO glwl_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Tǝhala kwaha, shughanashuug nǝ Ishaya kǝ gyi baz taakiya, am Daadamazhigǝla, “Lii gatarkwa biya, iitǝr wa tlarkwiitlǝga. Lii ndavarkwa biya, marandamarǝg kǝ ghǝrar vakatǝraa” ");
INSERT INTO glwl_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Gwiya tagaatag Daadamazhigǝl tǝghǝr kǝ yaa Israˈilah taakiya, “Ba kǝlaa hǝnga ba vǝlavǝlan nǝ dǝvvar tǝghǝr kǝ uudahi ar fǝgaara bi kǝ uudah biya, ard lii maay cinnga ǝlɓǝga uud biya.” ");
INSERT INTO glwl_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Mǝnng ndavǝgara, aici tsa, fiyatǝrdafigi kaci Daadamazhigǝl kǝ uudahaana? Maaya! Əndkwah biya! Ba kai dǝ ghǝrar ndakwani ǝn uuda yaa Israˈila, kwa sal ma hulfa Ibrahima, dlaɓa ma kuɗiga Benyamin. ");
INSERT INTO glwl_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Fiyatǝrda bi Daadamazhigǝl kǝ uudahaan kwa dzǝrghaaka nǝ iin bamma zunngwǝr biya. Am sǝrgasǝrǝg kǝ dǝgiti tagaa Kakkaɗa Daadamazhigǝl tǝghǝr kǝ Iliya, kwa lanngada tuugaan da vak Daadamazhigǝl tǝghǝr kǝ Israˈilah taakiya, ");
INSERT INTO glwl_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Yaazhigǝla, ciɓaraciɓǝg kǝ tlayanngahagha, dlaɓa dlagarnadlag kǝ alagahagha. Ba kai pall wa tǝmgatǝmga, ar gata ɗuula tsa kaiya.” ");
INSERT INTO glwl_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ngughara ndandar Daadamazhigǝl kǝ iini? Ngughara taakiya, “Fanafǝg kǝ uudah alfu uuɗif kǝ ghǝrar lii kǝlara bi kǝ ghunj kǝ ɓagarnǝs kwatǝnah kǝ ghǝl kwa ɗahav dǝ Baˈal biya.” ");
INSERT INTO glwl_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Bandkwah dlaɓ ma ndzǝgana haniina. Mǝnng kyalma uudaha Israˈila kwa dzǝrghaaka Daadamazhigǝl tǝdvad hɛrǝrraana. ");
INSERT INTO glwl_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Kwan kǝ dzǝrgǝna, dzǝrghaaka kwakyarvad hɛrrǝraan Daadamazhigǝla, kwakyarvad tlǝrahi ɓag nǝ uudah biya. Akwa maa maay ǝndkwah biya, ma nǝgal bi hɛrǝrǝn kǝ hɛrǝr biya. ");
INSERT INTO glwl_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Da ndandar ka ciya? Piletǝrvaapǝlig kǝ yaa Israˈila tlǝkǝna dǝgiti nahar nǝ iitǝra. Lii dzǝravaakan tlarkǝnatlǝga, tǝmga uudahatsa dǝkdǝk ghǝraatǝra. ");
INSERT INTO glwl_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Bandkwa vindavindan taakiya, “Vǝlatǝrvǝlǝg Daadamazhigǝl kǝ Shǝɗkwa nǝghǝgaaka biya, ar dǝ gyi ar nǝghǝga bi kǝ dǝgit biya, ar dǝ hyimiya ar cinnga bi kǝ dǝgit biya. Kwan kǝ dǝgita zaa ba vuuk ba gwaastaana.” ");
INSERT INTO glwl_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Tagaatag Dauda dlaɓ taakiya, “Aa nalnǝg hwaɗagatǝr kǝ dlǝgǝda ard patuma agya, kwa da sǝtǝrda tlatlǝɓa piina. Aa fǝtǝraafǝg kǝ mbǝɗǝg tǝ ɗuula, dlaɓa sǝtǝrda kǝ dlaɗa. ");
INSERT INTO glwl_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Aa nalnǝg gyiyahatǝr kǝzǝtkǝzǝt haik nǝghganǝghǝg kǝ iitǝra, dlaɓa agha dzalna kǝ kunngulahatǝr ba dǝmma.” ");
INSERT INTO glwl_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Gwaastaana ǝn dǝ ndavǝga. Tǝrɗara ba yaa Israˈila tǝ ɗuul tsa, gwiiyara bi ha kǝ ciiga? Maaya! Əndkwah biya! Mbakyarvad haipahatǝra tlarkǝntlǝg nǝ lii Yahudah bi kǝ katǝga, kiyava fǝtǝra shilǝg kǝ yaa Israˈila. ");
INSERT INTO glwl_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Akwama haipi ɓagara nǝ iitǝr wa sǝgharda bark kǝ duuniya, dlaɓa akwama hǝtsǝgalhǝtsǝgaatǝr wa satǝrdaa bark kǝ lii Yahudah biya, da tlǝkǝnatlǝg duuni kǝ bark ba vaivai ma sarta kwa gwiyarghǝragwig nǝ Yahudah ba ɗyak kǝ ɓa dǝgiti naag Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Ən tagkur kǝskuramǝn am Yahudahǝn biya. Aanji ba ǝn zǝrɓǝlga Yesu kǝ lii Yahudah biya, ǝn tsǝgaan kǝ kusǝgh dǝ tlǝrara. ");
INSERT INTO glwl_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Tǝdvad ɓa kwana, manaa naagaan taakiya ǝn fǝtǝra kǝ zaraabahar Israˈilah kǝ shilga, kiyava katvant kyalmatǝra. ");
INSERT INTO glwl_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Akwama kwa fiyatǝrda Daadamazhigǝlǝn wa sadaa ɗuula ɓadla ndzǝgan ma taataka Daadamazhigǝl ard duuniya, ma sartǝn da dlǝghvtǝr nǝ iitǝrna, abi da saa dǝ tlǝkǝna shifǝg nǝ wan kǝ lii ruwararug wan biya? ");
INSERT INTO glwl_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Akwama vǝlavarvǝlǝg hutsǝga burudiya zunngw kǝ Daadamazhigǝla, baɗǝm tǝmga burudiyin ndakwi ba cacuwanacacuwana. Akwama cacuwanacacuwana tlaliya uufa, baɗǝm dǝvahaan ba cacuwanacacuwana. ");
INSERT INTO glwl_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Akwama kalavdakǝlǝg kyalma dǝvvaha uufa zaituna hǝnnyaha, kǝlǝvdaa dǝvva uufa zaituna tǝghal matlǝvtǝrǝt ǝmtaɗ dǝ dǝga hǝnnyaha. Kuramǝn am Yahudahǝn biya, am band dǝvva uufa zaituna tǝghalǝn nǝ uurama, kuram wa matlakurǝt nǝ uud dǝ dǝga hǝnnyaha, kwa iitǝr Yahudaha, kwam tlamkǝna nǝ uuram kǝ jiɗǝg tǝdvad tlaliya uufa hǝnnyaha. ");
INSERT INTO glwl_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Mbakyarvad kwaha, tsam bi kǝ kusǝgha taakiya jamujig nǝ uuram kǝ kyalǝma dǝvvaha uufǝn kalavdanǝn biya. Akwama am tsa kusǝgha, am dzamnan taakiya uufǝn bi wa tsaghǝr tǝ kuram biya, bamma kuram wa tsaghǝr tǝ ndatsa uufiina. ");
INSERT INTO glwl_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Agha tagdatag taakiya, kalavǝda mbakyarvad ǝn tlǝkǝna kǝ ɗuul matlǝkut nǝ uud dǝ ndatsa uufiina.” ");
INSERT INTO glwl_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Ba kǝ jiijiira! Mbakyarvad maira fadǝghǝr wa kalavǝda nǝ iitǝr tǝ ndatsa uufiina, kǝgh dlaɓa tǝdvad fadǝghǝr wa tlǝghkǝna nǝnng kǝ ɗuula matlav dǝ ndatsa uufiina. Aɗabad kwaha tsǝbi kǝ kusǝgh biya, dlakulva kwaha, gǝdzǝga. ");
INSERT INTO glwl_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Zhuwatǝrdaala bi tsaw Daadamazhigǝl kǝ dǝvaha uufǝn kwa iitǝr dǝvaha ndatsa uufin biya, kǝgh ndakwani da zhukadaala biya. ");
INSERT INTO glwl_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Kiyam nǝghǝganǝghǝg kǝ kalaliya Daadamazhigǝl ard dlaɗaana. Maratǝrdamarǝg kǝ dlaɗa nǝghǝgaraa gyi kǝ lii mbǝɗara tǝ ɗuula, marakadamarǝg kǝ hɛrǝrran kǝskǝgha, akwama agha za vuuk dǝ ndzǝga ma hɛrǝrraana, dlaɓa akwama agha maay za vuuk ndǝkwah biya, kǝgh ndakwani da kǝlakkǝlǝg nǝ uud dagal tǝ ndatsa uufiina. ");
INSERT INTO glwl_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Akwama gwiyara bi zaa vuuk nǝ uudaha Israˈila dǝ ndzǝgana maira fadǝghǝr biya, da matlǝvtǝrmatlǝg ba tǝ ndatsa uufiina, aɗaba gwiya ɓagaɓag Daadamazhigǝl gwitǝrdaan da tǝ ndatsa uufiina. ");
INSERT INTO glwl_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Kuramǝn am Yahudahǝn biya, am band hulfa uufa zaitun kwa kǝlavdaa ma tǝghala, tǝhala kwa kǝlavǝda nǝ iina, matlǝvtǝrǝt dǝ uufa zaituna hǝnnyaha. Kwa ɓagava nǝ iin ǝndkwaha gatav bi kalkala matla dǝvva uuf tǝ uuf biya. Yaa Israˈila tsaw nǝ uufa zaituna hǝnnyaha, ba tsaftsaf vak Daadamazhigǝl gwiya fahǝt kǝ dǝvvaha uufǝn kwa kalavǝdan tǝ ndatsa uufatǝra. ");
INSERT INTO glwl_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Zaraabahara, ǝn naagaan am sǝra kǝ jiira dǝginǝn shiɓashiɓanǝnna, tǝɗam bi kǝ fǝɗyavǝgha taakiya am dǝ dabari biya. Aɗaba dǝkdǝka ghǝrǝn dzǝghaar ma kyalma yaa Israˈila, bamma da righǝtrighǝg ɗyakǝra lii ar Yahudahǝn bi vak Daadamazhiǝl lakwti da wurǝvtǝrwurǝg dǝkdǝka ghǝraatǝra. ");
INSERT INTO glwl_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Da katav ǝndkwah yaa Israˈila baɗǝmma. Bandkwa vindava taakiya, “Da sagal ma Sihiyon Dadda Katǝga. Da hǝvdan kǝlaadǝr sagal ma kuɗiga Yakuba. ");
INSERT INTO glwl_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Kwannǝn langiyar ǝmtaɗ dǝ iitǝra, ma sarta kwan da kǝstǝraara nai kǝ haipahaatǝra.” ");
INSERT INTO glwl_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Aɗaba larwalǝg Yahudah kǝ dlǝgha ǝlbǝg marawǝna, kaa ɓa tlǝghum kǝ iitǝr dǝ Daadamazhigǝla. Kwanǝnna dzǝghar kwakyarvad mǝlkuru kǝskuramǝn am Yahudahǝn biya. Tǝdvad kǝsgi kǝsatǝraaka nǝ iina, waitǝrwaig Daadamazhigǝl ma barka daadiija daadijahaatǝra. ");
INSERT INTO glwl_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Aɗaba gyanaha Daadamazhigǝl ard ɗahgaana, dǝgitahi da gwiig Daadamazhigǝl kǝ ghai tǝghǝr biya. ");
INSERT INTO glwl_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Kuramǝn am Yahudahǝn biya ndza famaara bi kǝ Daadamazhigǝl wur biya, zhuwakurdaalazhuug nǝ uud ndakwan kwakyarvad larǝwalǝg Yahuhah kǝ fǝgaara Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Bandkwah dlaɓ Yahudaha, naralnǝg kǝ lii maay fǝgaara kǝ Daadamazhigǝl biya. Kwanna mbakyarvad ar tlǝkǝna kǝ zhuwadaal tǝdvad zhuwadaala Daadmazhigǝl ɓagakura nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Aɗaba natǝrdalnǝg Daadamazhigǝl kǝ uudah baɗǝm damma ɛɛva maira fǝgaarafǝg biya. Ɓagaa kwakyarvad martǝrda kǝ zhuwadaal baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Bak kǝ jiijiira maay ghaala tlaɗɗa dabariya Daadamazhigǝl ard sǝrgasǝrgaan biya! Tlaɗɗǝra sǝrgasǝrgaan maay ghaalaan biya, shariyahi ɓag nǝ iin hǝgga bi shigaan biya, dǝgitahi ɓag nǝ iin juujig kǝ sǝrgasǝrga uuda! ");
INSERT INTO glwl_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","War wa tapǝghanatapǝg kǝ sǝrga dzamaghǝra Yaazhigǝli? War wa tapǝghanatapǝg kǝ nǝg kǝ tsaghwa sawariya nii? ");
INSERT INTO glwl_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","“War wa tapǝghana vǝlǝga dǝgit kǝ Daadamazhigǝl kwa da nǝg kǝ barari kǝ Daadamazhigǝl gwiyardani?” ");
INSERT INTO glwl_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Aɗaba iin wa vǝrɗya dǝgitah baɗǝmma, dlaɓa baɗǝm dǝgitah ɓagaa ba nǝ iin kiyavaana. Ndanngǝr kǝ Daadamazhigǝl ba tanngw damma zǝrazǝra! Andz bandkwaha. ");
INSERT INTO glwl_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Aɗabad kwaha, ǝn ghala kuram zaraabahara, mbakyarvad ɗyakǝra zhuwadaalǝraan kǝ Daadamazhigǝla, vǝlamavǝlǝg kǝ ghǝraru kǝ ɓaa kyulǝga kwa dǝ shiifǝga, dlaɓa cacuwanacacuwan kwa da caug Daadamazhigǝla. Kwan kalkala ɗuuli am da ɓagar nǝ uuram kǝ kwatǝnahǝr kǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Haiyamant bi kǝsuu hulfa ndzǝgana duuni kǝ hǝnkalaru biya, aa mbǝɗnambǝɗǝg Daadamazhigǝl kǝ hǝnkalaru kiyava gwiyav kǝ ndzǝganaruwa. Tǝdvad kwan wam da sǝrgaaka nǝ uuram kǝ dǝgiti naag Daadamazhigǝla, dǝgit marawa, dǝga dlǝghǝg vak Daadamazhigǝla, dlaɓa dǝgiti kalkala. ");
INSERT INTO glwl_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Tǝdvad hɛrǝrrǝn vǝlghwa Daadamazhigǝlǝna, ǝn ɓǝlgaraɓǝlǝg kǝ magi aanji kwar kǝ pallaru taakiya, aa faara bi nǝ uudan kǝ ghǝraan juu kǝ dǝgiti tlatlǝg nǝ iin biya. Dlakuvakwaha aa fafǝg nǝ uudan kǝ hǝnkal tǝ ɗuuli vazǝg nǝ iin kǝ ndzǝganaana, aa ndzanzdǝg ba tǝ kalkala fadǝghǝri kwa vǝlghar Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Kiyam dǝ uuɓiyah ba ɗyak tǝ vǝgh palla, dlaɓa baɗǝm nǝ uuɓiyahaana, ar ba dǝ tlǝrahaatǝr shahshaha. ");
INSERT INTO glwl_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Kǝmiyam ndakwi bandkwaha, kiyam ba ɗyakka, niyamalnǝg kǝ vǝgh pall ma Kǝristi, aanji kwar kǝ uɓi ba dǝ tlǝran bandkwa ɓag kyalma uɓiyah baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Kiyam mǝnng tsaw dǝ vǝlga dǝgitah shahshah kalkala kwa vǝlakiyam Daadamazhigǝl tǝdvad hɛrǝrrana, ɓagiyamɓag kǝ tlǝr dǝvakaiya. Akwama dǝga taa tlayanngǝr wa vǝlakak nǝ uuda, tag kǝ tlayanngǝragh kalkala fadǝghǝragha. ");
INSERT INTO glwl_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Akwama vǝlga ɓa kwatǝnaha, ɓag kǝ kwatǝnahǝra. Akwama dǝga tsaga dǝgita, tsaga. ");
INSERT INTO glwl_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Akwama dǝga fǝgaraa ndzǝɗ kǝ uuda, a farnaa kǝ ndzǝɗa. Akwama dǝga mǝlga, agha mǝlaruwa. Akwama dǝga kwarǝg nǝ iina, aa kwarǝg ba tǝ ɗuula jiira. Akwama dǝga ɓaa zhuwadaala, ɓag bad huɗ palla. ");
INSERT INTO glwl_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Aa nalnǝg waiyavaru ba kǝ dǝga jiijiira. Ɗuwamarsɗuug kǝ dǝga kǝlaadǝr baɗǝmma, hakyamvǝthakyig tǝ dǝga jiijiira. ");
INSERT INTO glwl_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Waiyamwaig kǝ uudah dǝ waiyava zaraabaha, famaarafǝg kǝ zǝraabaharu tǝghǝr kǝ ghǝraruwa. ");
INSERT INTO glwl_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Haiyamant bi kǝ ndzǝgana mandǝlghǝr biya, famfǝg kǝ ndzǝɗ ma ǝrviɗmahuɗaru am ɓagar kwatǝnahǝr kǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Dlaiyamdlaig ma ndzǝgana fantaararuwa, am fǝgaan kǝ ǝrviɗmahuɗ ma hǝɓa dlaɗa, ndzamandzǝg dǝ fadǝghǝr ma dzugwazhigǝlaruwa. ");
INSERT INTO glwl_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Tagwamtagw kǝ dǝgiti am dǝvakai nǝ uuram dǝ uudaha Daadamazhigǝl kwa gulagula ndzǝɗaatǝra, dlǝghamdlǝghǝg kǝ ghulabah ba dǝ dǝvvaa buwa. ");
INSERT INTO glwl_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Famtǝraafǝg kǝ bark kǝ lii vǝlkur dlaɗa. famtǝraafǝg kǝ barka, tlafamtǝr biya. ");
INSERT INTO glwl_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Dlaiyamdlaig dǝ lii dlaiga, dzugwamdzugw kǝ daddakwa tagvar dzugwagha. ");
INSERT INTO glwl_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Ndzamandzǝg ba lassan dǝ zaraabaha. Tǝɗam bi kǝ fǝɗyavǝgh biya, vaiyamvaig kǝ tsaghwah dǝ lii maay puutatǝr biya. Kǝsamant bi kǝ ghǝraru taaki jamujig kǝ kyalma uudah dǝ ɗyamɗyamǝr biya. ");
INSERT INTO glwl_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Pǝlam bi kǝ tlǝra kǝlaadǝr dǝ kǝlaadǝr biya. Famfǝg kǝ hyimi kǝ ɓa dǝgiti maraw aanji da nǝghǝga ba war da tagaan taakiya ba kalkala. ");
INSERT INTO glwl_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Ɓagamɓag kǝlaa ndzǝɗaruwa, akwama ma ɓagaɓag ndzamandzǝg ba lassan aanji dǝ wara. ");
INSERT INTO glwl_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Pǝlambi kǝ dǝgiti ɓagkur nǝ uud zaraabahar biya, ɗuwamarnaɗuug ba kǝ Daadamazhigǝla, iin wa da pǝlkurpǝlǝg dǝ badzǝga ǝrviɗmahuɗaana. Aɗaba vindavindan ma Kakkaɗa Daadamazhigǝl taakiya, “Tǝ kai pǝlgaana, ba kai wada pǝlǝgaan awaram Yaazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Gwiya tagaatag Kakkaɗa Daadamazhigǝl taakiya, “Akwama njikǝn wai kǝ tlǝghumagha, vǝlarvǝlǝg kǝ dǝg zǝga. Akwama njikǝn nǝ andǝla, agha garu kǝ yuwa hǝɓǝga. Tǝdvad kwan wa gha dzaagar nǝnng kǝ hyiiya kaar da tǝ ghǝraana.” ");
INSERT INTO glwl_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Ɓǝlamarna bi kǝlaadǝr zuu kǝ fiir tǝghǝr kǝskuram biya, dlakulvakwaha zamzǝg kǝ fiir tǝghǝr kǝ kǝlaadǝr tǝdvad ɓa tlǝri kalkala. ");
INSERT INTO glwl_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Barari aanji ma ba war faara kǝ tlǝvuukwaha gumnatiya, aɗaba maay watlǝrn kǝ ndzǝɗa kwarǝg biya bamma vak Daadamazhigǝla. Dlaɓa baɗǝm lii dǝ ndzǝɗa kwarǝgǝn kiyam dǝvakai nǝ miyamna, fatǝra ba Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Mbakyarvad kwaha, baɗǝm daddakwa lawalǝg kǝ fǝgaara kǝ tlǝvuukwaha gumnatiya, fǝghaara bi kǝ dǝgiti faa Daadamazhigǝl biya. Lii larwalǝg kǝ ɓa kwaha ar sǝgarda shari kǝ ghǝraatǝra. ");
INSERT INTO glwl_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Aɗaba dǝga gǝdzǝg bi nǝ tlǝvuukwaha gumnati kǝ uudahi ɓa dǝgiti kalkal biya, bamma uudahi ar ɓa dǝgitahi gwaɗa. Agha naagaan agha taguvan dǝ gǝdza uudi dǝ ndzǝɗa kwarǝga? Aiciya, ɓag kǝ dǝgiti kalkalaana, da galakgalǝg nǝ iina, ");
INSERT INTO glwl_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","aɗaba dadda ɓa tlǝra Daadamazhigǝl nǝ iin kwakyarvad tsǝka kǝ puutagha. Akwama agha dadda ɓa kǝlaadǝra, agha gǝdzǝgaana, mbakyarvad hǝkyig gyagyan bi nǝ dadda kwarǝg kǝ katsakar biya. Dadda ɓa tlǝra Daadamazhigǝl nǝ iina, dlaɓa tǝdvad iin wa da marǝg Daadamazhigǝl kǝ badzǝg ǝrviɗmahuɗa kiyava vǝlgar dlaɗ kǝ dadda kǝlaadǝra. ");
INSERT INTO glwl_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Mbakyarvad kwaha, barari kǝskuram fǝgaara kǝ tlǝvuukwaha gumnatiya. Kwakyarvad am ngǝdlarwa kǝ badzǝga ǝrviɗamahuɗ vakaatǝr kalti biya, amma kwakyarvad dzamaghǝraru aa ndzanzǝg ba kalkala. ");
INSERT INTO glwl_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Iin wa nǝ iin am ɗiig nǝ uuram kǝ hadamǝna, aɗaba tlǝvuukwaha gumnati ar ɓa tlǝra Daadamazhigǝl nǝ iitǝra, kwar kǝsa sartaatǝr baɗǝm kwakyarvad ɓa tlǝra kwarǝga. ");
INSERT INTO glwl_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Ɗiyamtǝraɗiig kǝ dǝgiti ar gatkur nǝ iitǝr tǝvakai baɗǝmma. Akwama hadama ghǝravaru war gatkur nǝ iitǝra, am ɗiitǝrana, akwama hadama kadlangaharuwa, am ɗiitǝrana. Gǝdzamgǝdzǝg kǝ daddakwa tlaltlǝg kǝ gǝdzava, dlaɓa am faaran kǝ daddakwa tlaltlǝg kǝ fǝgaarafǝga. ");
INSERT INTO glwl_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Hǝkyam bi aanji dlaiyawar biya, bamma dlaiya kwa nalnǝg kǝ barari kǝskuram kǝ ɓagaana, iin, nǝ dǝga waiyava zaraabaha, aɗaba daddakwa waiya zǝraabana righantrighǝg kǝ adzahadzaha Muusa. ");
INSERT INTO glwl_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","kwanahaan kǝ adzahadzaha, kwa taaki, “Ɓag bi kǝ gwaragwar biya, tsǝbi kǝ shifǝg biya, ɓag bi kǝ gǝl biya, kǝm bi kǝ dǝga uud biya,” ard kyalma adzahadzah baɗǝm kwa dǝvakai nǝ uuda, dzahavaadzahǝg baɗǝm tǝ adzahadzahǝn kwa taakiya, “Waig kǝ tlǝgharawakyaghagh band ghǝragha.” ");
INSERT INTO glwl_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Akwama agha waigaan kǝ tlǝgharawakyaghagha, agha tapna bi kǝ ɓagar dǝga kǝlaadǝr biya. Mbakyarvad kwaha, waiyava, iin nǝ righa adzahadzaha. ");
INSERT INTO glwl_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Ɓagamɓag kwana, aɗaba nǝghamaakanǝghǝg kǝ hulfa zamanǝn kwa kiyam mavakai nǝ miyamna. Ɓagaaɓag sarta kwam da ciig nǝ uuram ma haara, aɗaba ndakwan hǝrzǝthǝzǝg sarti da katǝkiyam nǝ uuda, tǝghǝr kǝ sarti fiyamdǝghǝrǝt nǝ miyam ba zunngwa. ");
INSERT INTO glwl_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Hǝrz nǝ kǝs kǝ wurǝga, dlaɓa dǝmdǝg cagaa. Mbakyarvad kwaha ɗuuyamarsɗuug kǝ tlǝra gurtla, kiyam tsǝguv kadlanga ghwaava miyam kwa dǝga paraka. ");
INSERT INTO glwl_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Ndzǝyamandzǝg ba maraw kalkal dǝ ndzǝgana paraka, ba kwal ɓa hwaɗaga za dǝgitaha, hǝɓa kya ɗyakɗyaka, ard gwaragwara, ard gata cinnga ǝmtakǝr kwa dǝga tsa zhǝruwa, ard uushava, dlaɓa ard shilga. ");
INSERT INTO glwl_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Dlakulvakwaha, kǝsamkǝsǝg kǝ ndzǝgana Yaazhigǝl Yesu Kǝristi, haiyamant bi dlaɓ kǝsu nǝ ndzǝgana uudǝr kǝ hǝnkalaru kwa da lankur dama kǝma dǝga kǝlaadǝr biya. ");
INSERT INTO glwl_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Dlǝghamdlǝghǝg kǝ daddakwa tǝhwal bi fadǝghǝraan biya, famaraa bi kǝ haip akwama shah dǝgiti naag nǝ iin dǝ dǝgaru biya, ");
INSERT INTO glwl_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Mǝnng nǝ wan kǝ uuda haigharanthaig fadǝghǝraan kǝ za aanji hulfa kwar kǝ dǝgiti naagant wayaana, mǝnng wan dlaɓ hǝtsahǝtsan fadǝghǝraana, za ba kadlanga guh kaltiya. ");
INSERT INTO glwl_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Daddakwa za dǝgitahi naagant waiyaan baɗǝmma, aa nen bi kǝ daddakwa maay za aanji hulfa kwar kǝ dǝgzǝgǝn biya. Dlaɓa daddakwa maay za aanji hulfa kwar kǝ dǝgzǝgǝn biya, aa tar bi kǝ shari kǝ daddakwa za aanji hulfa kwar kǝ dǝgzǝgǝn biya, aɗaba haiyatǝranthaig Daadamazhigǝl baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Agha war nǝnng agha da tǝgar shari kǝ kwatǝnaha uudani? Aanji ɓagaaɓag kwatǝnahǝn kǝ tlǝr marawa, aanji ɓagaa biya, ba dǝgan wah kǝ dadda hǝnyahǝna. Bak jiijiira da fǝvarnaafǝg ndzǝɗa, aɗaba Yaazhigǝl wa da mǝlgarumǝlǝg ghacan zuu kǝ fiira. ");
INSERT INTO glwl_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Mǝnng nǝ uudi fǝgaarafǝg kǝ faci pall tǝghǝr kǝ kyalma faciyaha, Vak kwana baɗǝm hǝngah ba kalkala. Ma ba wara aa ndzandzǝg ba tǝ dǝgiti aa nǝghǝgaaka nǝ iin ma ǝrviɗmahuɗaana. ");
INSERT INTO glwl_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Baɗǝm daddakwa fǝgaara faci palla, ɓag mbakyarvad faara kǝ Yaazhigǝla. Baɗǝm daddakwa za aanji hulfa kwar kǝ dǝgzǝga, zǝg mbakyarvad fǝvaara Yaazhigǝla, aɗaba tagartag nǝ iin kǝ uus kǝ Daadamazhigǝl kwakyarvad dǝgzǝgina. Baɗǝm daddakwa maay za kyalma dǝgzǝgah biya, iin ndakwani ɗuugant mbakyarvad fǝvaara Yaazhigǝla, aɗaba iin ndakwani tagar uus kǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Maay wa ndzǝga dǝ shifǝg kwakyarvad ghǝraan biya, dlaɓa maay wa ǝmtsǝg kwakyarvad mǝlgaru kǝ ghǝraan biya. ");
INSERT INTO glwl_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Akwama kiyam ndzǝgan dǝ shifǝga, kiyam ndzǝgan mbakyarvad Yaazhigǝla, dlaɓa akwama kiyam ǝmtsǝga, kiyam ǝmtsǝg mbakyarvad Yaazhigǝla. Aɗabad kwaha, aanji kiyam dǝ shifǝga bi kiyam ǝtsamtsana, kiyam ba dǝga Yaazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Aɗaba ǝmtsaaǝmtsǝg Kǝristi dlaɓa ciyitciig dǝ shifǝg mbakyarvad nal kǝ Yaazhigǝl kǝ lii ǝmtsamtsan ard lii dǝ shifǝga. ");
INSERT INTO glwl_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Kǝghǝm, aujilbǝg kǝskǝgh agha tǝgar shari kǝ zǝraabaghi? Dlaɓa aujilbǝg kǝskǝgh agha nena zǝraabaghi? Baɗǝmma miyama kiyam da ghacig tǝ vuukwa Daadamazhigǝl kwa iin wa da tǝkiyam shariya. ");
INSERT INTO glwl_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Aɗaba vindavindan ma Kakkaɗa Daadamazhigǝl taakiya, Am Yaazhigǝla, “Bak jiijiira, kai tsaw Yaazhigǝl dǝ shifǝga, ma kwar kǝ uuda bamma kǝlaakǝlǝg kǝ ghunj tǝvuukwara, ma kwar kǝ aryah da tagaan taaki ǝn Daadamazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Aiciya, ma kwar kǝ palla miyam da tagaan kǝ dǝgiti ɓagaa nǝ iin tǝvuukwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Mbakyarvad kwaha, tǝyamar bi kǝ shari kǝ zaraabah biya. Dlakulvakwaha, ma ba war aa fǝdǝm bi ma ǝrviɗmahuɗaan nal kǝ ɗuula mbǝɗa zǝraabaan damma haip biya. ");
INSERT INTO glwl_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Ən sǝrgasǝrǝg naiya, dlaɓa fandghǝrǝtfǝg ma Yaazhigǝl Yesu taakiya, maay dǝgzǝgi kwadlamb kataghǝraan biya. Akwama kǝsghantkǝsǝg nǝ uudan ma ghǝraan taakiya mǝnng dǝgzǝg kwadlamba, aiciya, kwah kǝ dǝgzǝg kwadlamb ba vakaana. ");
INSERT INTO glwl_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Akwama dǝgiti agha zǝg nǝnng wa da sǝgardaa dlaɗ kǝ zǝraabagha, ndzǝgana waiyav bi wagha ɓag nǝnng dǝ iin biya. Aa nal bi nǝ dǝgiti agha zǝg nǝnng kǝ ɗuula badza zǝraabagh kwa ǝmtsaa Kǝristi mbakyarvad iin biya. ");
INSERT INTO glwl_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Aɗabad kwaha, dǝgiti maraw vakagh aa nal bi kǝ dǝga kǝlaadǝr vak kyalmah biya. ");
INSERT INTO glwl_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Aɗaba tlǝskǝsǝra Daadamazhigǝl ǝlbǝg tǝghǝr kǝ zǝgaana ard hǝɓǝgaan biya, amma ǝlbǝg tǝghǝr kǝ jiira, gabǝrǝrra, ard dlaig ma Shǝɗkwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Baɗǝm daddakwa ɓagar kwatǝnah kǝ Kǝristi tǝdvad kwan kǝ ɗuula, iin wa cinng Daadamazhigǝl kǝ ǝmtakǝraana, dlaɓa da haiganthaig nǝ uudah kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Mbakyarvad kwaha, ɓagiyamɓag kǝlaa ndzǝɗa miyam kiyava ɓa dǝgiti kwa da saa dǝ gabǝrǝrra ard fǝgaraa ndzǝɗ kǝ zaraabaha. ");
INSERT INTO glwl_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Badzamda bi kǝ tlǝra Daadamazhigǝl mbakyarvad dǝgzǝg biya. Bak jiijiira aanji hulfa kwar kǝ dǝgzǝg ba cacuwa, dǝgiti ghwaɗa, iin za dǝgiti da fǝgaraa mbǝɗǝg kǝ uuda. ");
INSERT INTO glwl_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Ɓagaɓag kǝ maraw zǝbi kǝ tluw biya, bi hǝɓa yuwa inabi biya, bi ɓa aanji hulfa kwar kǝ dǝgiti da fǝgara mbǝɗǝg kǝ zǝraabagh biya. ");
INSERT INTO glwl_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Baɗǝm dǝgiti aa haigant ghǝragh tǝghǝr kǝ kwanahaana, aa ndzandzǝg bamma taatakagh dǝ Daadamazhigǝla. Dǝ bark nǝ uudi ghazǝghana bi kǝ ghǝraan tǝghǝr kǝ dǝgiti vazǝg nǝ iin ba kalkala vakaana. ");
INSERT INTO glwl_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Daddakwa ɓa ndawndaw tǝghǝr kǝ dǝgiti zǝg nǝ iina, sǝgarda shariya Daadamazhigǝl kǝ ghǝraan akwama zuuzǝga, kwakyarvad aa zǝg dǝ fadǝghǝr biya. Aɗaba baɗǝm dǝgiti sǝga tǝdvad fadǝghǝr biya, haip nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Kǝmiyamǝn kiyam dǝ ndzǝɗ ma fadǝghǝrna, ɓagaɓag kǝ marawǝr kiyam mǝltǝru kǝ lii tǝhwalar bi ma fadǝghǝr biya. Ɓagiyam bi kǝ dǝga naa ghǝr biya. ");
INSERT INTO glwl_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Aanji kwar ma kǝmiyam aa ɓag kǝ dǝgiti da fǝgaraa cinnga ǝmtakǝr kǝ zǝraabaan mbakyarvad mǝlaruwa, dlaɓa farna kǝ fadǝghǝraana. ");
INSERT INTO glwl_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Aɗaba aanji Kǝristi ndakwani ɓagaa bi kǝ dǝga naa ghǝr biya. Bandkwa vindava ma Kakkaɗa Daadamazhigǝl taakiya, “Ɗaavǝn ɗahakav kyalmahǝn sǝghaasǝg da tǝ kaiya.” ");
INSERT INTO glwl_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Aɗaba baɗǝm dǝgiti vindava wur ma Kakkaɗa Daadamazhigǝla, vindava kwakyarvad tsagkiyamu nǝ uud kǝ dǝgita, kiyava ndzǝgan kǝskǝmiyam dǝ fantaar tǝdvad ɓǝshgaan ard fa ndzǝɗ kwa tagakiyam Kakkaɗa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Ən ghala Daadamazhigǝl kwa vǝlgar ɓǝshigaan ard fǝgaraa ndzǝɗ kǝ uudaha, maa vǝlkur ǝrviɗmahuɗa ndzǝgan ba lassan aanji dǝ war bandkwa ɓaga Kǝristi Yesu. ");
INSERT INTO glwl_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Tǝdvad kwah wam da ndzǝgan nǝ uuram dǝ ghai palla, ard dzamaghǝr palla, am gala Daadamazhigǝla ard Daada Yaazhigǝlamiyam Yesu Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Dlǝghamdlǝghǝg kǝ zaraabah dǝ dǝvva bu bandkwa dlǝghakura Kǝristi ba dǝ dǝvva bu kiyava saa dǝ galǝg kǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Ən tagkurtag taakiya, kwa nal Kǝristi kǝ kwatǝnah kǝ Yahudahna, nal kwakyarvad marda kǝ jiira ǝlbǝga Daadamazhigǝla, dlaɓa fǝvdǝghǝrǝt tǝ langyi kwa tǝghara nǝ iin kǝ daadiija daadiijahaatǝra, ");
INSERT INTO glwl_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","aɗaba kiyava fǝgaarafǝg kǝ lii ar Yahudahǝn bi kǝ Daadamazhigǝl mbakyarvad zhuwadalǝraana. Bandkwa vindavindan taakiya, “Mbakyarvad kwana, Yaazhigǝla, ǝn da galakgalǝg ma lii ar Yahudah biya, ǝn da ɓǝlgaan kǝ ǝnngsa galla ɗaagagha.” ");
INSERT INTO glwl_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Gwiya tagaatag Kakkaɗa Daadamazhigǝl taakiya, “Kuramǝn Yahudahǝn biya, dlaiyamdlaig ǝmtaɗ dǝ uudaha Daadamazhigǝla,” ");
INSERT INTO glwl_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Gwiya tagavatag taakiya, “Galamgalǝg kǝ Yaazhigǝla, baɗǝmmaru Yahudahǝn biya, galamgalǝg kǝ iina, uudaha duuni baɗǝmma.” ");
INSERT INTO glwl_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Tagaatag nǝ Ishaya taakiya, “Mǝnng nǝ uud da sagal ma kuɗiga Yesse, da sagaw da kwara lii Yahudahǝn biya, ar da ndzǝga ba dǝ fantaar tǝ iin lii Yahudahǝn biya.” ");
INSERT INTO glwl_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Ən ghala Daadamazhigǝl kwa saa dǝ fantaar maa righǝkurǝt dǝ panahnahǝr ard gabǝr baɗǝmma, ma sarta kwam fadǝghǝr nǝ uuram tǝ iina, kiyava fǝkurnaa nǝ uud kǝ fantaar ba vaivai tǝdvad ndzǝɗa Shǝɗǝkwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Zaraabahara, ba kai dǝ ghǝrar haiyananthaig taakiya, kuram dǝ ghǝraru ndakwani am uudaha jiijiira, dlaɓa am sǝrgasǝrg kǝ dǝgit ba vaivaiya, tlamaltlǝg kǝ tsagaru dǝgit kǝ ghǝraruwa. ");
INSERT INTO glwl_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Bakǝvakwaha, ma vindǝgar sanalsǝg nai da tǝ ɓalaɓal ba vaivai ǝn taa ǝlbǝg tǝghǝr kǝ kyalma dǝgitah kiyava dzamkurnǝsdzamǝg kǝskai kǝ ǝlbǝgahaana. Ɓaganaɓag nai kwan tǝdvad hɛrǝrrǝn kwa vǝlghwa Daadamazhigǝla, ");
INSERT INTO glwl_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","kwa nakwadal kai kǝ ɓa tlǝra Kǝristi Yesu kǝ lii Yahudah biya. Ən ɓa tlǝra zhiilakǝsuuf tǝdvad taa ǝlbǝg marawa Daadamazhigǝl kǝ lii Yahudah biya, maraa vǝlda kǝ ghǝraatǝr kiyava dlǝghǝgaan kǝ Daadamazhigǝla, lii pǝshavtǝraaka tǝdvad Shǝɗkǝwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Mbakyarvad kwaha, ǝn tsǝgatsǝg kǝ kusǝgh tǝ Kǝristi Yesu tǝghǝr kǝ tlǝri ǝn ɓagar nai kǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Ən dzǝgwant bi nai kǝ taa ǝlbǝg tǝghǝr kǝ dǝgiti tlǝrǝn biya, bamma dǝgiti ɓagaa Kǝristi tǝdvad kaiya. Kwanǝn kǝ dǝgit iin ɗuuli savtǝrdaa lii Yahudah bi da fǝgaara kǝ Daadamazhigǝl tǝdvad ǝlbǝgara ard tlǝrara, ");
INSERT INTO glwl_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","tǝdvad ndzǝɗa dǝga sǝrgah ard tlǝraha dǝga jappǝra, baɗǝm ba tǝdvad ndzǝɗa Shǝɗǝkwa Daadamazhigǝl nǝ iina. Ciigǝt ma Wurshalima tsanarvaaratsǝg ba kyuɗ damma Ilirikum tagandatag kǝ ǝlbǝg marawa Kǝristi, ɓaganaɓag kǝ tlǝrahar baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Kǝlaa hǝnnga, ǝn naa ba taa ǝlbǝg maraw tǝghǝr kǝ Kǝristi nai baɗǝm vakavaki sǝrva bi Kǝristi biya, aɗaba aa da nal bi taakiya ǝn ndǝrǝg tǝ ndatsa uudan shah biya. ");
INSERT INTO glwl_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Dlakulva kwaha, bandkwa vindava taakiya, “Lii tapavna bi tagǝvtǝr nǝ ǝlbǝgaan biya, ar da nǝghǝganǝghǝga, lii taparna bi kǝ cinnga ǝlbǝg tǝghǝr kǝ iin biya, ar da nǝghǝgaakanǝghǝga.” ");
INSERT INTO glwl_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Tsakwava mbakyarvad kwan nǝ uud kǝ saha sagaw sa vakaruwa. ");
INSERT INTO glwl_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Ndakwan ciya madlabi tsaw vakavaki ǝn da ɓag nai kǝ tlǝr ma lardahaan biya. Ɗlaɓa viyamaviig ǝn kǝma dagaw da vakaru mbakyarvad ǝn nǝghǝkuraana, ");
INSERT INTO glwl_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ɓadlanvaɓadlǝg da nǝghǝkuraanǝghǝg ndakwana. Ma sarta kwan da dagal nai damma haaya Sifen, ǝn da kyǝha da tagkur uusa. Ma tǝ naagara, akwama cinnganucinng kǝ ǝmtakǝra ndzǝgan vakaru kǝ dǝga sart hǝɗikǝna, lakwti ǝn da zaa vuukw dagalar da vaakwah ǝmtaɗ dǝ mǝlgwadmǝlgaruwa. ");
INSERT INTO glwl_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Ndakwan ciya, ǝn dagat damma Wurshalima kiyava lannga dǝgiti dzahavant kǝ yaa dadda gatǝg vakwaha. ");
INSERT INTO glwl_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Yaa dadda gatǝg kwa ma Makiduniya ard lii ma Akaaya cinngarucinng kǝ ǝmtakǝra dzaha dǝgitah kiyava talagah lii gatǝg ma Wurshalima. ");
INSERT INTO glwl_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Cinngarucinng kǝ ǝmtakǝra dzaha kwanahaan kǝ dǝgitaha, aanji maa ba dlaiyatǝr mǝltǝrurumǝlga. Tlarkǝnatlǝg tsaw lii Yahudahǝn bi kǝ nuuba barka shǝɗǝkw vak Yahudaha, nalnǝg band gǝmaw dlaɓ kǝ iitǝr ar mǝltǝru kǝ Yahudah dǝ barka duuni kwa da tsǝg nǝ iitǝr kǝ puut dǝ vakaiya. ");
INSERT INTO glwl_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Akwama ghyǝnganaghyǝng ɓa kwan kǝ tlǝra, ǝn fǝdǝghǝrǝt dlaɓ taakiya, vǝlantǝrvǝlǝg kǝ dǝgitahaan dzahavant mbakyarvad iitǝra, kaa da viya ɗuula dagal kǝskai damma Sifen, dlaɓa ǝn da tagkur kǝ uus tǝ ghǝrdǝga dagala. ");
INSERT INTO glwl_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Ən sǝrgasǝrǝg taakiya akwaman da sagaw sa vakaruwa, ǝn da sagaw dǝ barka Kǝristi righarighana. ");
INSERT INTO glwl_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Zaraabaha, ǝn ghala kuram mbakyarvad Yaazhigǝlamiyam Yesu Kǝristi ard waiyavǝn kwa ɓag nǝ iin tǝdvad Shǝɗkwa Daadamazhigǝlna, ǝn ghala kurama, am mǝlwad dǝ dzǝgwazhigǝl ma ɓagakǝvar dǝ tlǝra. ");
INSERT INTO glwl_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Dzugwamdzugw kǝ zhigǝl maa tsuufǝkut vak Yahudah lii larwa kǝ dlǝgha ǝlbǝga miyama, dlaɓa maraa cawan lii gata Yaazhigǝl ma Wurshalim kǝ dǝgitahaan dzahavant vakara. ");
INSERT INTO glwl_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Akwama haighanthaig Daadamazhigǝla, ǝn dagaw da vakaru ba dǝ panaha ǝrviɗmahuɗa, ǝn ɗiida kǝ kuɗǝg ǝmtaɗ dǝ kurama. ");
INSERT INTO glwl_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Gabǝrra Daadamazhigǝla aa dzandzǝg tǝghǝr kǝskuram baɗǝmma. Aandz bandkwaha. ");
INSERT INTO glwl_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Ən markur dughwa baabamiyam Fibi, fandǝghǝrǝtfǝg taakiya dughwa jiijiira, dlaɓa ɓa kwatǝnahǝr ma cauc ma Kankiriya. ");
INSERT INTO glwl_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Dlǝghamdlǝghǝg kǝ dughwa baabamiyam ma ɗaaga Yaazhigǝl ba kalkal bandkwa dlǝghav yaa dadda gatǝga, vǝlamarvǝlǝg dlaɓ aanji hulfa kwar kǝ dǝgiti naag nǝ iin vakaruwa, aɗaba iin dǝ ghǝraan mǝlgharumǝlǝg kǝ uudah ba ɗyaka, baz kai dǝ ghǝrara. ");
INSERT INTO glwl_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Tagamtǝrtag kǝ uus kǝ Biriskila ard Akila, tsaghwaha tlǝrar ma Kǝristi Yesu. ");
INSERT INTO glwl_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Vǝlaruvǝlǝg kǝ ghǝraatǝr kǝ ǝmtsǝg mbakyarvad kaiya. Kai pall bi wa dlaig biya, baz cauca lii Yahudahǝn bi baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Tagamtǝrtag kǝ uus kǝ yaa dadda gatǝg kwa dzahav ma vǝgyaatǝra. Tagamartag kǝ uus kǝ Afanitus, tsaghwar ba vaivaiya, kwa nal kǝ dadda gata Kǝristi ba zunngw ma haaya Asiya baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Tagamartag kǝ uus kǝ Maryam kwa tlakǝntlǝg ɓa tlǝr ba vaivai mbakyarvad kurama. ");
INSERT INTO glwl_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Tagamtǝrtag kǝ uus kǝ Andaronikus ard Yuniya, zaraabahar Yahudah band kaiya, lii ɗiyavtǝrdǝm damma guda bǝrfing ǝmtaɗ dǝ kaiya. Sǝrvǝtǝrsǝrǝg nǝ iitǝr ba vaivai ma zarha ɓǝlga Yesu, dlaɓa dlǝghara nǝ iitǝr kǝ Kǝristi tǝghǝr kǝskaiya. ");
INSERT INTO glwl_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Tagamartag kǝ uus kǝ Amfiliyatus, tsaghwar ba vaivai ma Yaazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Tagamartag kǝ uus kǝ Urbanus tsaghwa tlǝra miyam ma Kǝristi, ard tsaghwar Sitakis. ");
INSERT INTO glwl_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Tagamartag kǝ uus kǝ Afalis kwa marada ghǝraan taakiya dadda gata Kǝristi nǝ iin ba vaivaiya. Tagamartag kǝ uus kǝ yahha Aristobulus. ");
INSERT INTO glwl_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Tagamartag kǝ uus kǝ Hirudiyan kwa iin ndakwani zhiil Yahuda. Tagamtǝrtag kǝ uus kǝ yaa dadda gata Yaazhigǝl ma vǝgya Narkisus. ");
INSERT INTO glwl_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Tagamtǝrtag kǝ uus kǝ Tirayifina ard Tirayifusa, kwan kǝ ǝnghwasah ar ɓagar tlǝr ba vaivai kǝ Yaazhigǝla. Tagamartag kǝ uus kǝ Farsis, kwanǝn kǝ uus uuda yaa uuda, tlakǝntlǝg ɓa tlǝr ba vaivai mbakyarvad Yaazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Tagamartag kǝ uus kǝ Rufus pall ma lii kǝsghaaka Yaazhigǝla. Am tagar dlaɓ kǝ uus kǝ babbaan kwa kǝsakut band zǝra huɗaana. ");
INSERT INTO glwl_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Tagamtǝrtag kǝ uus kǝ Asinkiritus, ard Filigona, ard Hermes, ard Faturobas, ard Harmas ard zaraabah baɗǝm kwa ǝmtaɗ dǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Tagamtǝrtag kǝ uus kǝ Filologus, ard Yuliya ard Niriyus ard dughwa babaana, ard Olimfas ard yaa dadda gatǝgi ǝmtaɗ dǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Tagamtǝrtag kǝ uus kǝ zaraabaharu dǝ burhwakǝva waiyava. Ar tagkur uus yaa dadda gata Kǝristi baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Ən ghala kuram zaraabahara, famfǝg kǝ hyimi dǝ lii saa dǝ tagwazha tagwazh ma taatakaruwa, ard lii tǝrɗa kuram tǝ ɗuula, ar ɓa tlǝghum dǝ dǝgiti tsagamu nǝ uurama. Dam bi da tǝvǝgh kǝ iitǝr biya. ");
INSERT INTO glwl_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Aɗaba hulfa kwan kǝ uudah ar ɓagar kǝ Kǝristi Yaazhigǝlamiyam bi nǝ iitǝr kǝ kwatǝnahǝr biya. Ar sǝra ba huɗaatǝra. Ar valla uudahi cinngtǝrcinnga tǝdvad mǝɗmǝɗa ghaiyahaatǝr ard fiidaha. Lii cinngtǝrcinngǝn ar dǝ ghǝrtla zarhǝra. ");
INSERT INTO glwl_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Aanji ba war cinnghacinng kǝ ɗuuli am fǝgaara nǝ uuram kǝ uuda, fǝghwaafǝg wan kǝ dlaig mbakyarvad kurama. Ən naagaan mamaa nal kǝ yaa dadda dabari tǝghǝr kǝ dǝgit marawa, dlaɓa am ndzan kwal haip tǝghǝr kǝ dǝgaha kǝlaadǝr baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Daadamazhigǝl kwa vǝla gabǝrǝr da hapǝgaan kǝ shatanaha, da vǝlkur dlaɓ kǝ ndzǝɗ tǝghǝr kǝ iina, ba kwal badza sarta. Hɛrǝrra Yaazhigǝlamiyam Yesu aa ndzandzǝg ǝmtaɗ dǝ kurama. ");
INSERT INTO glwl_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Tagkur uus Timoti, tsaghwa ɓa tlǝrara, bandkwah dlaɓ Lushiyus, ard Yason, ard Sosifata, kwa ghǝravaatǝr ndakwani ar Yahudaha. ");
INSERT INTO glwl_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Kai, Tartiyus, kwa vinda kwan kǝ wakita, ǝn tagkur uus ma ɗaaga Yaazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayus, kwa dlǝghakwi ma vǝgyaana, dlaɓa dlǝghǝgaan kǝ yaa dadda gatǝg baɗǝm ma vǝgyaana, iin ndakwani tagkur uusa. Erastus, kwa hǝkya kwaɓa kǝsa, ard zǝraabamiyam Kwartus ar tagkur uusa. ");
INSERT INTO glwl_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Aa ndzandzǝg hɛrǝrra Yaazhigǝl Kǝristi tǝghǝr kǝskuram baɗǝmma. Aandz bandkwaha. ");
INSERT INTO glwl_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Ndangǝr baɗǝm kǝ Daadamazhigǝl kwa fǝkurnaa ndzǝɗ ma fadǝghǝr tǝdvad ǝlbǝg marawǝn kwan tag nai kǝ ǝlbǝg tǝghǝr kǝ Yesu Kǝristi. Kwan kǝ ǝlbǝg marawa, dǝgiti ndza shiɓavnan sagalaan bamma dati. ");
INSERT INTO glwl_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Ndakwan savdasǝg da tǝ ɓalaɓal ma vindǝga tlayanngaha, tǝdvad ǝlbǝgi vǝlada Daadamazhigǝl ǝmkyaɗaka, dlaɓa maravtǝrdamarǝg kǝ jibah baɗǝmma, mbakyarvad ar fǝdǝghǝrǝt tǝ iina, dlaɓa ar faaraana. ");
INSERT INTO glwl_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Ndanngǝr kǝ Daadamazhigǝla, kwa pall ba nǝ iin dadda dabariya, tǝdvad Yesu Kǝristi tanngw damma zǝrazǝra! Aandz bandkwaha.");
INSERT INTO glwl_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Bulus kwa ɗahavant kiyava nǝg kǝ zǝr ɓǝlga Yesu Kǝristi dǝ naaga Daadamazhigǝl, ard zǝraabamiyam Sastanis. ");
INSERT INTO glwl_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Da vak cauc ma Korinti, lii pǝshavǝtǝran kǝ gata Kǝristi Yesu, dlaɓa ɗahavǝtǝrǝt kiyava nǝg uudahaan cacuwanacacuwana, ǝmtaɗ dǝ lii dzugwazhigǝl baɗǝm aanji takwar ma ɗaaga Yesu Kǝristi Yaazhigǝlamiyama, Yaazhigǝlaatǝra ard dǝgamiyam baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Hɛrǝrra ard gabǝr vak Daadamazhigǝl Daadamiyam ard Yaazhigǝl Yesu Kǝristi da vakaruwa. ");
INSERT INTO glwl_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Ən tagar uus kǝ Daadamazhigǝl ba kǝlaa hǝnng kwakyarvad kurama, aɗaba hɛrǝrrǝn vǝlakur nǝ iin tǝdvad Kǝristi Yesu. ");
INSERT INTO glwl_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Aɗaba aanji takwar kǝ ghyaba vǝlakurvǝlǝg nǝ uud kǝ hyahǝr ma iina, tǝdvad taa ghaiya ard sǝrgasǝrgǝr baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Bandkwa favǝdǝghǝrǝt shidamnd tǝghǝr kǝ Kǝristi ma taatakaruwa. ");
INSERT INTO glwl_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Mbakyarvad kwaha, hǝtsakurvaa bi tlǝkǝna aanji hulfa kwar kǝ gyaan kwa tlǝvǝkǝna tǝdvad Shǝɗkwa, ma sartǝn am fa gyi nǝ uuram am paka saaya Yaazhigǝlamiyam Yesu Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Da fǝkurnaafǝg Yaazhigǝlamiyam kǝ ndzǝɗ ba tanngw da tǝ ghaalaana, aɗaba am da nal kǝ lii maay dǝ haip ma sartǝn da saay Yaazhigǝlamiyam Yesu Kǝristi biya. ");
INSERT INTO glwl_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Daadamazhigǝl dadda righa langyi nǝ iina, Iin wa ɗahakurǝt kiyava ndzǝgana hwǝɗɗir ǝmtaɗ dǝ Zǝraan Yesu Kǝristi Yaazhigǝlamiyama. ");
INSERT INTO glwl_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Ən ghala kurama, zaraabahara, mbakyarvad ɗaaga Yaazhigǝl Yesu Kǝristi, taakiya, aa ndzandzǝg ghaiyaru ba vak palla, aandz maay tagwazhatagwazh ma taatakaru biya, bamma am dzant kǝ ghǝraru vak palla, ndzamandzǝg ba tǝ dǝgit palla, dzamaghǝraru ndakwani aandz ba vak palla. ");
INSERT INTO glwl_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Zaraabahara, tagarwatag lii ma hǝnnyaha Kuluwi taakiya, mǝnng mbaɗa ghai ma taatakaruwa. ");
INSERT INTO glwl_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Dǝgiti ǝn tlatlǝg naiya, iin taakiya, ma kwararuwa taa dǝgaan shaha, kwan taakiya, “Ən dǝga Bulus naiya,” kwan taakiya, “Ən dǝga Afulus naiya,” kwan taakiya “Ən dǝga Kefasa,” kwan dlaɓ taakiya, “Ən dǝga Kǝristi naiya.” ");
INSERT INTO glwl_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Mbats tagwavǝmtagw Kǝristi shahshaha? Əmtsaaǝmtsǝg Bulus tǝ tlaɓa hǝrtǝg kwakyarvad kurama? Nii ɓagakura dǝ ɗaaga Bulus ha nǝ uud kǝ tsuufǝgi? ");
INSERT INTO glwl_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Ən tagar uus kǝ Daadamazhigǝl ɓaganara bi aanji war ma kuram kǝ tsuufǝg biya, ba Kirisbus ard Gayusa. ");
INSERT INTO glwl_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Mbakyarvad kwaha, maay wa tagdatag taakiya ɓagakura dǝ ɗaagar nǝ uud kǝ tsuufǝg biya. ");
INSERT INTO glwl_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Dzamannadzamǝg dlaɓa, ɓagantǝraɓag kǝ tsuufǝg kǝ yaha Istafanusa, ma juujig ba kǝ yaha Istafanusa maay nǝ uudahi tlǝrǝn ɓagantǝra nai biya. ");
INSERT INTO glwl_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Ɓǝlakut bi Yesu mbakyarvad tsuufǝg biya, ɓǝlakut mbakyarvad taa ǝlbǝg marawa, ba kwal ɓa tlǝr dǝ dabariya ard mǝɗmǝɗa ghaiya. Aɗaba aa da hǝtsal bi nǝghǝga ndzǝɗa ǝmtsǝga Yesu tǝ tlaɓa hǝrtǝg biya. ");
INSERT INTO glwl_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Əlbǝga tlaɓa hǝrtǝga, ǝlbǝga dlagǝr nǝ iin vak lii gata ɗuula ruuga, amma vaka miyamǝn katakiyamǝtkatǝg nǝ uudna, ǝlbǝga tlaɓa hǝrtǝg ndzǝɗa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Aɗaba vindavavindǝg ma Kakkaɗa Daadamazhigǝl taakiya, “Ən da badzǝgaan kǝ dabariya lii dǝ dabariya. Ən da nǝdal kǝ ɗyamɗyama lii ɗyamɗyam kǝ dlagǝra” ");
INSERT INTO glwl_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Aitsaa, ar mǝr yaa dadda dabariyi? Ar mǝr lii tsaga adzahadzaha Muusi? Ar mǝr lii taakiya ar sǝrgasǝrǝg kǝ dǝgitah baɗǝmmi? Mbats marada bi Daadamazhigǝl taakiya, dabariya lii dǝ dabariya kwan kǝ duuni ba dlagǝr nǝ iin biya? ");
INSERT INTO glwl_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Aɗaba tǝdvad dabariya Daadamazhigǝla, uudaha duuni ar sǝrga bi kǝ Daadamazhigǝl tǝdvad dabariyatǝr biya. Cinngucinng Daadamazhigǝl kǝ ǝmtakǝr tǝdvad dlagǝra ǝlbǝg maraw tagavdan kiyava kata lii fardǝghǝrǝtfǝga. ");
INSERT INTO glwl_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Yahudah ar naa maa marvǝtǝrda dǝga sǝrga, Helenaha dlaɓa ar gata dǝga dabariya. ");
INSERT INTO glwl_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Amma kǝmnd kǝm taa ǝlbǝg marawa Kǝristi kwa ǝmtsaa tǝ tlaɓa hǝrtǝga, kwa nal kǝ ɗuula mbǝɗǝg kǝ Yahudaha, dlaɓa dǝga dlagǝr vak lii ar Yahudah biya. ");
INSERT INTO glwl_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Kiyava lii ɗahatǝrǝt Daadamazhigǝla, Yahudaha ard lii Yahudah biya, Kǝristi ndzǝɗa Daadamazhigǝl ard dabariya Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Aɗaba dlagǝra Daadamazhigǝl juujig dǝ ɗyamɗyam kǝ dabariya uuda dǝgshiga, dlaɓa hǝtsǝgalhǝtsǝga Daadamazhigǝl juujig dǝ ndzǝɗ kǝ ndzǝɗa uuda. ");
INSERT INTO glwl_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Zaraabaha, dzamamnadzamǝg kǝ ndzǝganaru ma sartǝn ɗahakurt Daadamazhigǝla, ndza ba hǝɗikǝn ma kuram wa dǝ dabari ma zharǝg nǝ uudaha, ndza ba hǝɗikǝn lii dzǝgadzǝga nǝ ahyapaatǝr ma kurama, dlaɓa ndza ba hǝɗikǝn lii zarha uud maamaala. ");
INSERT INTO glwl_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Amma kǝsǝghaakakǝsǝg Daadamazhigǝl kǝ dǝgitahi dlagǝr vak duuniya, kiyava tsǝtǝr zhǝru kǝ lii dǝ dabariya, kǝsǝghaakakǝsǝg Daadamazhigǝl kǝ dǝgitahi maay dǝ ndzǝɗ ma duuniya, kiyava tsǝtǝr zhǝru kǝ lii dǝ ndzǝɗ ma duuniya. ");
INSERT INTO glwl_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Kǝsghantkǝsǝg Daadamazhigǝl kǝ dǝgitahi maay dǝ zhǝru ma duuni biya, ard dǝ dǝgitahi nenenanena, ard dǝgitahi maay paiɗaan biya. Kǝsǝghaaka mbakyarvad kǝlda Daadamazhigǝl kǝ dzaara dǝgitahaan kwa zharǝg duuni bandgi mǝnng tlǝrana. ");
INSERT INTO glwl_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Bagaaɓag Daadamazhigǝl kwanahaan baɗǝm haik kǝ tsa kusǝgh kǝ uuda dǝgshig tǝvuukwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Daadamazhigǝl wa faafǝg kwa namal nǝ uuram kǝ dǝga Kǝristi Yesu, Daadamazhigǝl dlaɓ wa haighanthaig kǝ Kǝristi nal kǝ dabariyamiyama. Tlǝyamkǝna tǝdvad iin nǝmiyam kǝ ndzǝgana kalkal tǝvuukwa Daadamazhigǝl kǝ pǝshiga ard varga. ");
INSERT INTO glwl_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Mbakyarvad kwaha, band kwa vindavidan ma Kakaɗa Daadamazhigǝl taakiya, “Baɗǝm dadda tsa kusǝgha aa tsǝg tǝ Yaazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Zaraabaha, sarta kwa sanǝv nai da tagkur dǝgit shiɓashiɓan kwa taghwa Daadamazhigǝla, tagankur bi nai kǝ ǝlbǝgǝn tǝdvad mǝɗmǝɗa ghai biya, bi markur dabari biya. ");
INSERT INTO glwl_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Aɗaba ma sartǝn ndzana nai ǝmtaɗ dǝ kuramna, nguɗanantnguɗǝg ma ǝrviɗmahuɗar taakiya, ǝn vinaviig kǝ dǝgitah baɗǝmma maay ba Yesu Kǝristi ard dǝ ǝmtsǝgaan tǝ tlaɓa hǝrtǝg biya. ");
INSERT INTO glwl_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Sagawar ba zunngw da vakaru ndzan maay dzangdzang biya, tǝg nǝ vǝghar mbakyavad dladlawa. ");
INSERT INTO glwl_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Əlbǝgara ard ǝlbǝg maraw dǝga dabariya ard dǝga patta kuram biya, bamma tǝdvad mara ndzǝɗa Shiɗkwa Daadamazhigǝla, ");
INSERT INTO glwl_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Aɗaba haik tsaghǝr fadǝghǝraru tǝ dabariya uudaha, bamma tǝ ndzǝɗa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Bakǝvakwaha kǝm taa ǝlbǝga dabari kǝ lii ghubararaghubarǝg ma fadghǝraatǝra, amma dabariya hulfa kwan kǝ zaman biya, bi dǝga hulfa lii kwara kwan kǝ zaman kwa da dagal zamana kwargatǝr biya. ");
INSERT INTO glwl_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Kǝm taa ǝlbǝga dabariya Daadamazhigǝl shǝɓashǝɓana, dabari kwa ndza shǝɓashǝɓan ba wura, iin dabariya Daadamazhigǝl kwa kurghǝna nǝ iin ba wura kiyava ndangǝramiyama lakwti kǝ fazha duniya . ");
INSERT INTO glwl_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Ma lii kwara zaman ndakwana maay wa nǝghǝghaakanǝghǝg kǝ dabariyan biya, akwama nǝgharaaka nǝ iitǝra, maa hǝrtarǝt bi kǝ Yaazhigǝl ndanng biya. ");
INSERT INTO glwl_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Band kwa vindavindan taakiya, “Baɗǝm dǝgiti kuratǝrna Daadamazhigǝl kǝ lii waigaana, maay wa nǝghanǝghǝg biya, maay daadakwa tapghanitapǝg kǝ cinnghacinng biya, dlaɓa maay daadakwa tapghanitapǝg kǝ dzamaghǝr tǝghǝr biya.” ");
INSERT INTO glwl_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Marakiyamndamarǝg Daadamazhigǝl kǝ kwanahaan kǝ dǝgitah tǝdvad Shǝɗkwa, aɗaba shǝɗkw wa ha shiga dǝgitah baɗǝmma, baz dǝgaha Daadamazhigǝl kwa ɗǝmɗǝm kǝ nǝghǝgaakanǝghǝga. ");
INSERT INTO glwl_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","War wa sǝrgasǝrg kǝ dǝgiti ma ǝrvidmahuɗa uudan ma maay ba shiɗkwan kǝ uuda nǝ iin biyi? Bandkwah dlaɓa, maay wa nǝghǝgaakanǝghǝg kǝ dzamaghǝra Daadamazhigǝl biya, bamma Shǝɗkwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Shǝɗkwa duuni bi wa dlǝghamndanǝmnd biya, Shǝɗkwa Daadamazhigǝl wa dlǝghamnda nǝmnda, kiyava nǝghǝgaakanǝghǝg kǝskǝmnd kǝ dǝgitahi vǝlakǝmnd Daadamazhigǝla ba pasakka. ");
INSERT INTO glwl_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Kǝm tagkur kwanaahaan kǝ dǝgitaha, dǝ ǝlbǝgahi tsagav dǝ dabariya uud biya, bamma kǝm tsag dǝ dǝga Shǝdkwa, tǝdvad martǝr jiira dǝgaha Shǝdkw kǝ lii dǝ Shǝdkwa. ");
INSERT INTO glwl_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Daddakwa Shiɗǝkwa Daadamazhigǝl bi wa ɓa tlǝr dǝvakai biya, maay dlǝgha dǝgaha Shiɗǝkwa Daadamazhigǝl biya, aɗaba dlagǝr wahiin vakaana. Dlaɓa da nǝghǝgaaka biya, aɗaba nǝghǝvaakanǝghǝg tǝdvad Shiɗǝkwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Daddakwa ɓa tlǝr Shiɗǝkwa Daadamazhigǝl dǝvakaiya, tǝgatǝg kǝ shari tǝghǝr kǝ dǝgitah baɗǝmma, daddakwa maay dǝ Shiɗǝkw biya, tǝga bi kǝ shari tǝghǝr kǝ daddakwa dǝ Shiɗǝkw biya. ");
INSERT INTO glwl_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","“War wa sǝrgasǝrǝg kǝ dzamaghǝra Yaazhigǝl dlaɓa da kwararnǝsi?” Amma kǝmiyam kiyam dǝ dzamaghǝra Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Zaraabaha, ǝn tagkurda bi nai kǝ ǝlbǝg ndǝ lii ndzǝga tǝdvad Shiɗǝkwa Daadamazhigǝl biya, bamma ǝn tagkur band uudaha duuniya, vuunjah ma gata Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Gǝlankurǝtgǝlǝg nai dǝ ghwaya watla, dǝ kaf dǝkdǝk biya, aɗaba tlamal bi kǝ za kaf dǝkdǝk biya, bakǝvakwah tlamal biya. ");
INSERT INTO glwl_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Aɗaba gwastaan am ba ndzǝgaan ɓa dǝgiti naag nǝ vǝghǝgha, akwama am ba ndzǝgaan shilgakǝva, am ɓa uushav dǝ zaraabaharuwa, am ba ndzǝgaan ɓa tlǝra vǝghǝgha, aɗaba am ɓa tlǝrahi naag nǝ vǝghǝgha. ");
INSERT INTO glwl_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Mbakyarvad kwaha, akwama tagaatag nǝ uudan taaki, “Ən dǝga Bulus naiya,” kwatlǝrn ɗlaɓ taaki, “Ən dǝga Afullusa,” mbats tlǝra vǝghǝgh bi wam marǝg nǝ uuram biya? ");
INSERT INTO glwl_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","War nǝ Afullusi? War Bulusi? Ar ba kwatǝnah kaltiya, kwa famdǝghǝrǝt nǝ uuram tǝdvad iitǝra, ma kwaraatǝr ba dǝ hulfa tlǝri vǝlghar Yaazhigǝl biya? ");
INSERT INTO glwl_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Kai wa riyanariiga, Afullus wa peɗghar yuwa, Daadamazhigǝl wa fǝgaarafǝg kǝ ghubarǝg kǝ dǝgiti riyavana. ");
INSERT INTO glwl_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Mbakyarvad kwaha, daddakwa riyariiga, ard daddakwa peɗghar yuwa maay dǝgiti tuuk vakai nǝ iitǝr biya, bamma Daadamazhigǝl pall kwa fǝghara ghubarǝg kǝ dǝgitahi riyavariiga. ");
INSERT INTO glwl_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Dadda riiga, ard daddakwa peɗghar yu ba tlǝraatǝr palla, aɗaba aanji kwaraatǝr da tlǝkǝnatlǝg kǝ dǝgshigaan kalkala tlǝraana. ");
INSERT INTO glwl_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Aɗaba kǝmiyama, kiyam tsaghwa ɓa tlǝra Daadamazhigǝla, kuram nǝ guha Daadamazhigǝla, dlaɓa am ndǝrǝga Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Tǝdvad herǝrra Daadamazhigǝl kwa vǝlghwa nǝ iina, fanafǝg nai kǝ ndatsa ndǝrǝg band daddakwa ɗyaagh kǝ ndǝrǝga, kwatlǝrn dlaɓ ndǝrǝg tǝghǝraana. Barari kǝ dadda ndǝrǝg fa hyimi tǝ hulfa ndǝrǝgi kwa da fǝgaraa nǝ iin tǝghǝra. ");
INSERT INTO glwl_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Aɗaba maay daddakwa da fa kwatlrǝn kǝ ndats shah dǝ kwa fǝvanǝn biya, kwa iin Yesu Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Akwama fǝgharaafǝg nǝ uudan kǝ ndǝrǝg da tǝghǝr kǝ ndatsǝn favarzha dǝ adawanǝnna, aanji dǝ agwalela, bi dǝ akurahi kwa ndannga, bi dǝ dakara, bi dǝ kazhakwa, aanji dǝ ghuuva, ");
INSERT INTO glwl_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","da nǝghǝvanǝghǝg tlǝra aanji kwar kǝ dadda ndǝrǝga, da marazha sagal daghuvali da gwiya saay Kǝristi, aɗaba da tapav dǝ kaar aanji tlǝra wara, dlaɓa da tapav dǝ kaar nǝ dzǝgana tlǝra uudana. ");
INSERT INTO glwl_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Akwama zǝt bi kaar kǝ ndǝrgǝn favaraa da tǝghǝr kǝ ndatsǝn biya, daddakwa ɓagaa kwan kǝ ndǝrǝg da tlǝkǝnatlǝg kǝ dǝgshigaana. ");
INSERT INTO glwl_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Akwama zǝtzǝg kaaraa, ɓagaaɓag kǝ asar dadda ndǝrǝgna, aanji ba da tlǝkǝnatlǝg nǝ iin katǝga, da band daddakwa ngǝdlǝga sagal ma taataka kaara. ");
INSERT INTO glwl_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Mbats am sǝrga bi taaki am vǝgya Daadamazhigǝl nǝ uuram biya, dlaɓa Shiɗǝkwa Daadamazhigǝl wa ndzǝga ma kuram biya? ");
INSERT INTO glwl_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Baɗǝm daddakwa badzadabadzǝg kǝ vǝgya Daadamazhigǝla, da badzǝgaan dlaɓ Daadamazhigǝl kǝ iin aɗaba vǝgya Daadamazhigǝl cacuwanacacuwan nǝ iina, aɗaɓa kuram dǝ ghǝraru ndakwani am vǝgya Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Aa valda bi nǝ uudan kǝ ghǝraan biya, akwama tlatlǝgaan nǝ uudan ma ghǝraan taakiya, dadda dabari nǝ iin tǝdvad kwa kǝsghant duuni kǝ dabariya, aa nǝdalnǝg kǝ ghǝraan band dlaga mbakyarvad nal kǝ dadda dabariya. ");
INSERT INTO glwl_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Aɗaba dabariya kwan kǝ duuni dlagǝr vak Daadamazhigǝla, mbakyarvad vindavindan taakiya, “Vaigaan kǝ lii dǝ dabariya ma ɗyamɗyamatǝra.” ");
INSERT INTO glwl_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Vindavindan dlaɓ ma Kakkaɗa Daadamazhigǝl taakiya, “Sǝrgasǝrǝg Yaazhigǝl taaki dzamaghǝra lii dǝ dabariya maay tlǝraan biya.” ");
INSERT INTO glwl_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Mbakyarvad kwaha, aa tsǝbi nǝ uudan kǝ kusǝgh dǝ lii kwara uud biya, aɗaba baɗǝm dǝgitah ba dǝgaruwa, ");
INSERT INTO glwl_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","aanji Bulusa, bi Afullusa, bi Kǝfasa, bi duuniya, bi shifǝga, bi ǝmtsǝga, aanji dǝgitahi ndakwana, aanji kwa da tǝvuukwa, baɗǝm ba dǝgaruwa. ");
INSERT INTO glwl_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Aɗaba am dǝga Kǝristi nǝ uurama, Kǝristi dlaɓa dǝga Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Kǝsamkǝmdǝtkǝsǝg kǝm kwatǝnaha Kǝristi nǝmnda, lii vǝlatǝr Daadamazhigǝl kǝ langiya sǝrga jiiraan shiɓashiɓana. ");
INSERT INTO glwl_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Aɗabad kwaha, baraari kǝ lii hǝkya langyi ar marda kǝ jiir ma ndzǝgana tlǝri vǝlavǝtǝrvǝlga. ");
INSERT INTO glwl_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Maay lambar aanji ba hǝɗikǝn akwama kuram wa tǝgwa shari biya, bii tǝdvad shariya duuniya, ba pakkata, aanji ba kai ǝn maay ta shari kǝ ghǝrar biya. ");
INSERT INTO glwl_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Tsǝgwatsǝg ghǝrar taaki maay dǝgit ghwaɗ ɓagana nai biya, bakǝvakwah nakwadal bi wan taaki ǝn haamak biya, Yaazhigǝl wa da tǝgwa shariya. ");
INSERT INTO glwl_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Mbakyarvad kwaha, ghudamar bi kǝ shari kǝ uud ma ɓaga bi sart biya, pakamantpag bamma sǝghawiisǝg Yaazhigǝla. Iin wa da marda dǝgitahi shiɓashiɓan ma gurtla, da tagdan dlaɓ kǝ dǝgiti tlatlǝg nǝ ǝrviɗmahuɗa uudaha, ma kwah kǝ sart wa da dlǝghǝg aanji ba war kǝ galǝg vak Daadamazhigǝl kalkala dǝgiti ɓagaa nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Aici zaraabahara, tǝdvad kwanahaan kǝ ǝlbǝga, nantǝrdalnǝg nai kǝ garav kǝ ghǝrar ard Afullus mbakyarvad kurama, kiyava tsagaan kǝskuram tǝghǝr kǝ ǝlbǝgǝn kwa taakiya, “Dzǝvamara bi kǝ dǝgiti vindavan biya,” haik tǝɗa fǝɗyavǝgh kǝ pallaru taakiya, daddakwa tsaghwadtsag juujig kǝ daddakwa tsagharu kǝ dadda kwaha. ");
INSERT INTO glwl_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Tagakak war taakiya jǝghuujig kǝ kyalmi? Au wa agha dǝvakai nǝnng kwa vǝlakak Daadamazhigǝl biyi? Akwama bandkwah ci tsaa, aujilbǝg agha naa ghǝr bandgi vǝlakak gyagyan bi nǝ uud biyi? ");
INSERT INTO glwl_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Tlamkǝnatlǝg kǝ dǝgiti am naag nǝ uuram baɗǝmma! Namalnǝg kǝ yaa dadda hyahaa! Namalnǝg band tlǝksah ba kwal kǝmnda! Maa tǝ naagar maa famarzhafǝg kǝ kwarǝga, kiyava kwarǝg kǝskǝmiyam ǝmtaɗ dǝ kurama! ");
INSERT INTO glwl_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Aɗaba man tlǝg naiya, maradamarǝg Daadamazhigǝl ba tǝ ɓalaɓal taakiya kǝmnd zarhaɓǝlga Yesu nǝ dǝga hall ma lii daasa, band lii ghudavtǝrda shariya ǝmtsǝga, aɗaba namdalnǝg nǝmnd kǝ akwatram kwa da fǝg duuniya, zarhaɓǝlga, ard uudah kǝ gyi tǝ vakai baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Namndalnǝg kǝ dlag mbakyarvad Kǝristi, amma am dǝ dabari nǝ uuram ma Kǝristi! Kǝm maay nǝmnd dǝ ndzǝɗ biya, am dǝ ndzǝɗ nǝ uurama! Fa zhǝru nǝ uud tǝ kurama, amma vǝlkǝmnd dlaɗ nǝ uud kǝskǝmnda! ");
INSERT INTO glwl_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Bakǝvakwan ndakwani njakǝmndjiig waiya ard andǝla, kǝm faha ba akacakaca, kalkǝmndkalǝg nǝ uuda, dlaɓa kǝm maay dǝ hǝnnyah biya. ");
INSERT INTO glwl_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Kǝm ɓa tlǝr dǝ dǝvvahamnd ba vaivaiya, akwama ɗahakǝmvaɗahǝg nǝ uuda, kǝm fǝtǝra kǝ bark dlakulvaana, akwama vǝlakǝmndvǝlǝg nǝ uud kǝ dlaɗa, kǝm ɓǝshigaana. ");
INSERT INTO glwl_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Akwama tagaratag nǝ uudah kǝ ǝlbǝg ghwaɗ tǝ kǝmnda, kǝm ngutǝra ba dǝ ǝmtakǝra. Namndalnǝg kǝ agaagava duuni tanngw sama sartǝna. ");
INSERT INTO glwl_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Vindankura mbakyarvad ǝn fǝkurdǝm damma zhǝru bi nai biya, vindankura mbakyarvad ǝn ɓǝlkura kǝ maggi aɗaba am zarhar kwan waitǝr naiya. ");
INSERT INTO glwl_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Aanji am ba dǝ lii tsaga dǝgit ma Kǝristi kwa kǝdlǝvtǝrna biya, am maay dǝ daadah ɗyak biya. Ba jiijiir nanalnǝg nai kǝ daad kǝskuram ma Kǝristi Yesu tǝdvad langkur ǝlbǝg marawa. ");
INSERT INTO glwl_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Mbakyarvad kwaha, ǝn ghala kuram tsagamtsag kǝ ndzǝganara. ");
INSERT INTO glwl_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Aɗabad kwah ɓǝlanantɓǝlǝg kǝ Timuti zǝrar kwan waig nai da vakaruwa, uuda jiijiir ma Yaazhigǝla, da dzamkurnǝsdzamǝg kǝ ɗuula ndzǝganar ma Kǝristi Yesu, kwa ba kalkal dǝ dǝgiti ǝn tsag nai aanji takwara, dlaɓa aanji ma kwar kǝ cauca. ");
INSERT INTO glwl_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Kǝsarantkǝsǝg kyalmaru bandgi ǝn da maay dagal da vakaru biya, baz tǝɗa fǝɗyavǝgh kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Akwama haighanthaig Yaazhigǝl ǝn da zǝlma bi kǝ sagaw da vakaru biya, ǝn da sǝran kǝ hulfa ndzǝɗi dǝ vakai lii tǝɗa fǝɗyaveghna, kwakyarvad ǝlbǝgahaatǝr biya. ");
INSERT INTO glwl_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Aɗaba tlǝkǝsǝra Daadamazhigǝl tǝdvad ghai biya, bamma tǝdvad ndzǝɗa. ");
INSERT INTO glwl_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Aitsa, au wa maa kǝsǝgaaka nǝ uurami? Ən sagaw sa vakaru dǝ kiiɓa ndaiga, nii ǝn markurda kǝ waiyav ma kalaliyǝr hi? ");
INSERT INTO glwl_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Cinnganacning taakiya mǝnng lii ɓa gwaragwar ma kurama, hulfa kwa maay ɓagav aanji ma lii sǝrga bi kǝ Daadamazhigǝl biya, mǝnng daddakwa nadal uusa daddaan band uusaana. ");
INSERT INTO glwl_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Baz tǝɗa fǝɗyavǝgh kǝskurama! Mbats, kalkalan bi kǝskuram am ma danngwurahuɗa, am lagwdan kǝ daddakwa ɓa kwahiin sagal ma kuram biya? ");
INSERT INTO glwl_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Aanji ba ǝn maay ǝmtaɗ dǝ kuram ma ndzǝgana vǝgh biya, ǝn ba ǝmtaɗ dǝ kuram ma Shiɗǝkwa Daadamazhigǝla. Ghudanardaghudǝg nai kǝ shari kǝ dadda ɓa kwan kǝ dǝgit ma ɗaaga Kǝristi Yesu aanji ba ǝn maay ǝmtaɗ dǝ kuram biya. ");
INSERT INTO glwl_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Ma sarta kwa dzahamvǝtdzahǝga, ǝn ba ǝmtaɗ dǝ kuram ma Shiɗǝkwa, dlaɓa ndzǝɗa Yaazhigǝlamiyam Yesu bamma taatakaruwa, ");
INSERT INTO glwl_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","vǝlamarvǝlǝg kǝ Shatanah uudanǝnna, kiyava badzǝgaan kǝ shatanah kǝ vǝghaana, da katav shifǝgaan davala faciya Yaazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Tǝɗa fǝɗyavǝghǝn am ɓag nǝ uuramǝn maraw biya, mbats am sǝrga bi taakiya, zǝr yist ba kǝshat wa fǝgaraa kuburǝg kǝ burudi baɗǝm biya? ");
INSERT INTO glwl_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Tagwamvatagw dǝ ǝnghura yista aa haipa kiyava nǝg kǝskuram kǝ daala burudi kwal yista, ba pakatta am bandkwah nǝ uurama. Aɗaba ɓagavaɓag kyulǝga Zǝr Mbakǝlakamiyam kiyava hwaɗaga haarakǝsa Dzava Hǝnyaha, iin nǝ Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Mbakyarvad kwaha, ɓagiyam bi kǝ hwaɗaga haara kǝsamiyam dǝ bruudi kwa dǝ ǝnghura yist ma vakai biya, kwa dǝga hǝkya uuda ma ǝrviɗya ard dǝga kǝlaadǝr biya, ɓagiyamɓag dǝ bruudi kwal yist kwa iin haiganthaiga ard jiira. ");
INSERT INTO glwl_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Vindankuravinndǝg ma wakitar taaki camaramkǝv bi dǝ lii ɓa gwaragwar biya. ");
INSERT INTO glwl_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Ən taa kǝ hulfa uudaha duuniyǝn gwaiyalargwaigǝn biya, bi lii dlǝrmǝga, bi lii ɓa gǝlla, bi lii ɓagarnǝs kwatǝnahǝr kǝ ghǝla biya. Akwama bandkwah am ndzǝga bi ma duuni biya. ");
INSERT INTO glwl_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Ən vindkurvinndǝg taakiya camaramkǝv bi annji dǝ kwar kǝ zǝraab dadda gatǝg akwama ɓa gwaragwar nǝ iin biya, aanji dadda dlǝrmǝga, bi dadda ɓagar kwatǝnahǝr ghǝlla, bi daddakwa ɗaava uuda, bi dadda hǝɓa kya ɗyakɗyaka, bi dadda ɓa gǝlla, zambi kǝ dǝgzǝg dǝ hulfa kwan kǝ uudah biya. ");
INSERT INTO glwl_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Au lambar dǝ tǝtǝr shari kǝ lii maay ma cauc biyi? Abi am da tǝtǝr ba kǝ lii ma cauc nǝ uuram kǝ shari? ");
INSERT INTO glwl_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Daadamazhigǝl wa tǝtǝr shari kǝ lii dǝga miyam biya. Lagwamdalagw kǝ yaa dadda kǝlaadǝr ma kurama. ");
INSERT INTO glwl_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Akwama mǝnng dǝgiti dǝm ma taatakagh dǝ zǝraabagha, agha maay ɗiya ghunjaan vak lii maay gǝdza Daadamamazhigǝl kiyava ta shari biya, dlakulvakwaha, agha ɗiig bi kǝ ghunjaan vak yaa dadda gatǝg biya? ");
INSERT INTO glwl_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Mbats, am sǝrga bi taakiya yaa dadda gatǝg wa da tǝtǝr shari kǝ duuni biya? Akwama ba kuram wa da tǝtǝr shari kǝ duuni tsaw tsaa, mbats tlamal bi nǝ uuram kǝ ta shari tǝghǝr kǝ dǝgitahaan hǝɗiikǝnǝn biya? ");
INSERT INTO glwl_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Am sǝrga bi taakiya kǝmiyam wa da tǝtǝr shari kǝ zarhaɓǝlga Daadamazhigǝl biya? Kyakaɗava dǝgitahi ma kwan kǝ duuniyi kaciya? ");
INSERT INTO glwl_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Akwama dzǝghaardzǝg nǝ hulfa kwanahaan kǝ dǝgit ma taatakaruwa, aujilbǝg am langtǝr da vak lii haiyatǝrǝt bi cauc kiyava tǝtǝr shariyi? ");
INSERT INTO glwl_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Taganda mbakyarvad ǝn tsǝkura kǝ zhǝru nai kwan kǝ ǝlbǝga, aitsa, maay aanji pall ma kuram wa dǝ dabari kwa tǝgatǝg kǝ shari ma taataka zaraabah biya? ");
INSERT INTO glwl_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Ɗlakulvakwaha, zǝraab ɗiya ghunja zǝraabaan ma guda ta shariya, baz tǝvuukwa lii maay gatǝg biya! ");
INSERT INTO glwl_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Ɗiya ghunja zaraabaharuwǝn am ɓag nǝ uuramna, maradamarǝg taakiya hǝtsǝgalhǝtsǝg wahiin vakaruwa, abi ngulǝm ɓagkura nǝ uud kǝ dǝgit ghwaɗ? Ɗlaɓa ngulǝm zǝkuru nǝ uud? ");
INSERT INTO glwl_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Dlakulvakwaha, ba kuram dǝ ghǝraru am ɓagtǝr dǝgit ghwaɗ kǝ zaraabaharuwa, dlaɓa am za zaraabaharuwa! ");
INSERT INTO glwl_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Mbats, am sǝrga bi taakiya lii ɓa dǝgiti ghwaɗ ar da dǝgaa bi damma tlǝkǝsǝra Daadamazhigǝl biya? Aa valkurda bi nǝ uud biya, aɗaba maay lii shalavashalava, kwatǝnahǝr kǝ ghǝlaha, lii ɓa gwaragwara, aanji ghwalvahi hǝnna dǝ vǝgaatǝr ghwalvaha, ");
INSERT INTO glwl_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","Bi gǝllaha, bi lii dlǝrmǝga, bi lii hǝɓa kya ɗyakɗyaka, bi lii ghudazha uuda, bi lii pǝrɗa dǝga uuda, maay aanji pallatǝr wa da dǝgaadǝg damma tlǝkǝsǝra Daadamazhigǝla biya. ");
INSERT INTO glwl_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Ndza bandkwan kyalmaru wura, barakurabarǝg nǝ uuda, pǝshakurapǝshig nǝ uuda, dlaɓa nakurdalnǝg nǝ uud ba kalkal tǝvuukwa Daadamazhigǝl ma ɗaaga Yaazhigǝl Yesu Kǝristi, ard Shiɗǝkwa Daadamazhigǝlamiyama. ");
INSERT INTO glwl_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","“Haighwanthaig nǝ uud kǝ ɓa dǝgitah baɗǝmma,” amma ɗǝm bi dǝgitahi mǝlgaru kǝ uud biya, “Haighwanthaig nǝ uud kǝ ɓa dǝgitah baɗǝmma,” ǝn nǝgal bi kǝ ɛɛvya aanji kwar kǝ dǝgit biya. ");
INSERT INTO glwl_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","“Ɓagava mbakyarvad huɗ nǝ dǝgzǝga, huɗ dlaɓa mbakyarvad dǝgzǝga,” Daadamazhigǝl wa da ghyihtǝrghyihga ba bǝrkuɗa. Ɓagava mbakyarvad shalavshalav bi nǝ vǝghǝ biya, bamma mbakyarvad Yaazhigǝla, Yaazhigǝl dlaɓa mbakyarvad vǝgha. ");
INSERT INTO glwl_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Cighantciig Daadamazhigǝl kǝ Yaazhigǝl dǝ shiifǝga, da cikiyam bandkwah dlaɓ kǝskǝmiyam tǝdvad ndzǝɗaana. ");
INSERT INTO glwl_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Mbats, am sǝrga bi taakiya vǝgharu uuɓiya Kǝristi biya? Ən kǝsgant bi kǝ uuɓiya Kǝristi ǝn matlant dǝ uɓiya tand biya. Ən haigant biya! ");
INSERT INTO glwl_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Am sǝrga bi taakiya baɗǝm daddakwa matlǝgant vǝghaan dǝ tand naralnǝg kǝ vǝgh pall biya? Aɗaba vindavavindǝg ma Kakkaɗa Daadamazhigǝl taakiya, “Ba bǝrkuɗaatǝr naralnǝg kǝ vǝgh palla.” ");
INSERT INTO glwl_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Baɗǝm daddakwa matlǝgant ghǝraan dǝ Yaazhigǝl naralnǝg kǝ dǝgit pall dǝ iin ma Shiɗǝkwa. ");
INSERT INTO glwl_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Kuvamkuvǝg kǝ shalavashalava! Baɗǝm haipi ɓag nǝ uud tlǝkǝna bi kǝ vǝghaan biya, amma dadda gwaragwar ɓagar haip kǝ ghǝvaana. ");
INSERT INTO glwl_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Sǝramasǝrǝg taakiya vǝgharu Vǝgya Shiɗǝkwa Daadamazhigǝl kwa ndzǝga ma kurama, dlaɓa iin wa dlǝghama nǝ uuram vak Daadamazhigǝla. Kuram bi wa kwara ghǝraru biya, ");
INSERT INTO glwl_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","sǝgwakura dǝ sǝgw nǝ uuda. Mbakyarvad kwah famaarafǝg kǝ Daadamazhigǝl dǝ vǝgharuwa. ");
INSERT INTO glwl_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Ndakwana, tǝghǝr kǝ dǝgiti vindama nǝ uuramna, ɓagaɓag kǝ marawur aa camarakǝvbi nǝ uud dǝ uus biya. ");
INSERT INTO glwl_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Dzaagardzag tsaw shalavashalav ma kurama, aanji kwar kǝ ghwalv aa camarakǝv dǝ uusaana, bandkwah dlaɓ nǝ uus aa camarakǝv dǝ zhiilaana ");
INSERT INTO glwl_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Aa vǝlarvǝlǝg zhiil kǝ vǝghaan kǝ uusaana, bandkwah dlaɓ nǝ uus aa vǝlarvǝlǝg kǝ vǝghaan kǝ zhiilaana. ");
INSERT INTO glwl_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Aɗaba maay nǝ uus dǝ ndzǝɗ tǝghǝr kǝ vǝghaan biya, bamma zhiilaan wa dǝ ndzǝɗ tǝghǝra, bandkwah dlaɓ zhiil maay dǝ ndzǝɗ tǝghǝr kǝ vǝghaan biya, bamma uusan wa dǝ ndzǝɗ tǝghǝra. ");
INSERT INTO glwl_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Aa piyarda bi pallaru kǝ uud pall biya, bamma am haigant nǝ uuram kǝ gaha hǝnngah kiyava fa ndzǝɗ kǝskuram ma dzǝgwazhigǝla. Tǝhala kwah am gwiya matlǝvǝta, aɗaba valkurdavalǝg Shatanah akwamam kwarǝgant bi kǝ ghǝraru biya. ");
INSERT INTO glwl_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Sawari wan vǝlkur naiya, barari biya. ");
INSERT INTO glwl_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Akwa maa baɗǝm nǝ uud band kaiya, bakǝvakwah annji war ba dǝ vǝlgi vǝlgha Daadamazhigǝla, pall dǝ hulfa kwana, kwatlǝrǝn dlaɓ dǝ hulfa kwaha. ");
INSERT INTO glwl_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Tǝghǝr kǝ lii gara bi kǝ uusa ard wagyigah biya, ɓagaɓag kǝ marawur maraa ndzan band kai ba kwal uusa bi kwal zhiila. ");
INSERT INTO glwl_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Akwama ar kwarǝgant bi kǝ ghǝraatǝr biya, aa kǝsarkǝsǝg kǝ uusa bi kǝsa zhiila, ɓagaɓag kǝ marawur ga kǝ uusa bi ga kǝ zhiil tǝghǝr kwa da mbǝtǝr kǝma camarakǝva. ");
INSERT INTO glwl_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Ən tagtǝr kǝ lii kǝsarukǝsǝg kǝ uusa ard lii kǝsarukǝsǝg kǝ zhiila, kai bi wa tagaan biya, Yaazhigǝl wa tagaatag taakiya, aa tagwazh bi nǝ uus dǝ zhiilaan biya. ");
INSERT INTO glwl_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Akwama tagwazhatagw nǝ uus dǝ zhiilaana, aa gwiya kǝs bi kǝ zhiil biya, aa ɓadlarnaɓadlǝg kǝ ndzǝganatǝr dǝ zhiilaana, dlaɓa aa lagw bi zhiil kǝ uusaan biya. ");
INSERT INTO glwl_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Tǝghǝr kǝ kyalǝm uudah dlaɓa, kai wa tagaana, Yaazhigǝl biya, akwama mǝnng zǝraab kwa dǝ uusi kwa dadda gatǝg biya, haighanthaig ndzan ǝmtaɗ dǝ iina, aa lagw biya. ");
INSERT INTO glwl_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Akwama mǝnng dlaɓ nǝ uusi dǝ zhiil kwa dadda gatǝg biya, dlaɓa haighanthaig ndzan ǝmtaɗ dǝ iina, aa tagwazh bi dǝ vakai biya. ");
INSERT INTO glwl_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Aɗaba zhiili dadda gatǝg biya, pǝshapǝshan tǝdvad uusaani dadda gatǝga, bandkwah dlaɓ nǝ uusi dadda gatǝg biya, pǝshapǝshan tǝdvad zhiilaan dadda gatǝga, akwama maay ǝndkwah biya, zarharuwa ar da maay dǝ cacu biya, amma ndakwana ar dǝ cacuwa. ");
INSERT INTO glwl_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Akwama naa tagwazh nǝ zhiil bi uus kwa maay gatǝg dǝ daddakwa gatǝgǝna, aa tagwarvatagwa, akwama dzǝghaardzǝg ǝndkwana, zǝra baaba bi dughwa baab kwa dadda gatǝga, ar madlabi ma izhangyil kǝ kwarǝga kǝsa uusa bi kǝsa zhiil ndakwan biya, aɗaba ɗahakiyamǝt kwakyarvad ndzǝgana gabǝr Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Kǝgh uusa, agha sǝrgasǝrg mbatak kǝgh wagha da kata zhiilaagha? Kǝgh zhiila, agha sǝrgasǝrg mbatak kǝgh wagha da kata uusaagha? ");
INSERT INTO glwl_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Aanji ma kwar kǝ ndzǝgana, ma ba war aa ɓag kǝ ndzǝgan hulfa kwa kurgharna Yaazhigǝla, dlaɓa kwa ɗahghant Daadamazhigǝla. Iin nǝ adzahadzahi vǝlantǝr nai kǝ caucah baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Baɗǝm daddakwa ɗahghant Daadamazhigǝla, kwa ndza dǝ aguvaca, aa gwiya nalbi band daddakwa ɓagavara bi nǝ aguvac biya. Daddakwa ɗahghant Daadamazhigǝl dlaɓa, kwa ndza ɓagavara bi nǝ aguvac biya, aa tagbi taakiya bamma ɓagavaraɓag nǝ aguvac biya, ");
INSERT INTO glwl_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Mǝnnga, maay nǝ aguvac biya, maay dǝgiti tuuk vakai nǝ iin biya, amma tsuufa adzahadzaha Daadamazhigǝl iin wa marawa. ");
INSERT INTO glwl_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Ma ba wara aa ndzandzǝg band ndzǝgani ndza wur ma sarta kwa ɗahghant Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Akwama ndza agha ɛɛvya nǝnng ma sarta kwa ɗahakǝt nǝ uuda, aa njak biya. Akwama ba agha tlǝkǝnatlǝg kǝ kwara ghǝragha, ba agha ɓagaana. ");
INSERT INTO glwl_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Daddakwa ndza ɛɛvy ma sarta kwa ɗahavant damma fadǝghǝr ma Kǝristi, tlakǝnatlǝg kǝ kwara ghǝr ma Kǝristi. Bandkwah dlaɓ daddakwa ndza dǝ kwarǝga ghǝr sarta kwa ɗahavant nǝ iina, nalnǝg kǝ ɛɛvya Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Sugwakura dǝ gan nǝ uuda, aɗabad kwah namal bi kǝ ɛɛvyaha uudah biya. ");
INSERT INTO glwl_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Aici zaraabaha, aanji hulfa kwar kǝ ndzǝgan wa ndza ndzǝga nǝ uudan ma sarta kwa ɗahavant nǝ iina, aa ndzandzǝg bandkwah ǝmtaɗ dǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Tǝghǝr kǝ dǝg hǝri taparna bi kǝsa zhiil biya, tagghwa bi Yaazhigǝl kǝ ǝlbǝg tǝghǝr kǝ iitǝr biya, ǝn taa dǝgiti ma ǝrviɗyar nai taakiya, kai wa haiyakut nǝ uud tǝdvad zhǝwadaala Yaazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Mbakyarvad dlaɗi mavakai nǝ uud ndkwanǝnna, man tlǝg nai ɓagaɓag kǝ maraw kǝ uud ndzan band ndzǝganaana. ");
INSERT INTO glwl_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Akwama gǝghagǝg kǝ uusa, lagwbi dagal biya, akwama gǝgha biya, gǝ biya. ");
INSERT INTO glwl_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Akwama gǝghagǝg kǝ uusa, ɓaggha bi kǝ haip biya, akwama gaagǝg dlaɓ nǝ dughw kǝ zhiila, ɓagaa bi kǝ haip biya. Aɗaba baɗǝm lii garagǝg kǝ uusa ard lii garagǝg kǝ zhiila, ar da hǝɓǝgaan kǝ dlaɗ ma ndzǝganaatǝra, ǝn naagaan ǝn ngǝdlkura tuuk hulfa kwannǝn kǝ dlaɗa. ");
INSERT INTO glwl_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Dǝgiti ǝn tlǝg nai zaraabaha, aɗaba hǝrǝz sart kǝ ghyinnga. Ciigǝt ndakwana, lii garagǝg kǝ uusa bi garagǝg kǝ zhiila, aa nardalnǝg kǝ ghǝraatǝr bandgi lii garabi kǝ uusa bi garagǝg kǝ zhill biya, ");
INSERT INTO glwl_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","lii ma dannwura huɗ aa naralnǝg band lii ar maay ma dannwura huɗ biya, lii dlaig aa naralnǝg band lii ar maay dlaig biya, lii sǝgwa dǝgit aa tlatlar bi taakiya mǝnng dǝgaatǝr fǝgan biya, ");
INSERT INTO glwl_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","lii ɓa tlǝr dǝ kadlanga duuniya, aa tsar bi kǝ ghǝr tǝvakai biya, aɗaba da ghying ndzǝgana duunina. ");
INSERT INTO glwl_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Mana naag nai mamma ngǝdlan sagal ma dzama dǝgitaha. Daddakwa gaa bi kǝ uus biya, dzama ba ǝlbǝga Yaazhigǝl ba vaivaiya, kwa da cingucing Yaazhigǝl kǝ ǝmtakǝraana. ");
INSERT INTO glwl_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Aɗaba daddakwa gaagǝg kǝ uusa dzamgaan kǝ dǝgaha duuniya, kwa da fǝgaraa uusaan kǝ cinga ǝmtakǝra. ");
INSERT INTO glwl_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Tagwazhatagw ghǝraan hutsǝg buwa, Uusi kwa gaa bi kǝ zhiil biya, ma dughwa nǝ iina, dzama ba ǝlbǝga Yaazhǝgǝla ba vaivaiya kwa da nǝgalnǝg nǝ iin kǝ cacuwa tǝdvad vǝgha ard gatǝga. Uusi kwa dǝ zhiila dzama dǝgaha duuniya, kwa da fǝgaraa zhiilaan kǝ cinnga ǝmtakǝra. ");
INSERT INTO glwl_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Naa tagkur kwana mbakyavad da mǝlkurumǝlǝga, kwakyarvad ǝn gǝkurgyan biya, aɗaba maa nal nǝ ndzǝganaru kǝ marawa, kiyava ɓagarnǝs kwatnahǝr kǝskuram kǝ Yaazhigǝl ba kwal tagwzha kǝ ghǝraru biya. ");
INSERT INTO glwl_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Akwama taatǝg nǝ uudan kǝ langyi dǝ dughwi da gǝgǝg nǝ iina, dlaɓa ma tlatlǝg nǝ iina faha dǝvvadǝvva, tǝhala kwah kǝmgaan ba vaivaiya, ba gǝgaan kǝ iina. Akwama bandkwaha, haip biya. ");
INSERT INTO glwl_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Akwama ghacaghacig nǝ uudan ba tǝ dǝgiti aa nguɗgant nǝ iin ma ǝrviɗmahuɗana taakiya, barari bi kǝ iin kǝ gǝgaan biya, dlaɓa tsufǝgantsufǝg kǝ ghǝraana, tǝhala kwah fadǝmfǝg ma ǝrviɗmahɗan taakiya da maay gǝgaan biya, kwan ndakwi ba kalkala. ");
INSERT INTO glwl_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Mbakyarvad kwah daddakwa gaagǝg kǝ dughwi kwa taa nǝ iin kǝ langyi dǝ iina, ba kalkala. Daddakwa gaa bi kǝ dughwin biya, ngulǝm ba nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Aa tagwza bi nǝ uus dǝ zhiilaan ma ba dǝ shiifǝg biya, akwama ǝmtsaaǝmtsǝga nǝ zhiilaana, gǝgaan kǝ zhiili naagant ghǝrana, aa gaagǝg kǝ dadda gata Yaazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Akwama tǝ naagara, ma da cinngan kǝ ǝmtakǝr ma ndzaandzǝg band ndzǝganana. Aɗaba man zharǝg naiya ǝn dǝ Shǝɗkwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Ai ciya, tǝghǝr kǝ dǝgzǝg kwa kyulvar kǝ ghǝlla, kiyam sǝrgasǝrg baɗǝmma miyam kǝyam dǝ sǝrgasǝrgǝra, sǝrgasǝrgǝr dlaɓ saa dǝ naa ghǝra, wayakǝvǝra fǝgara ndzǝɗa. ");
INSERT INTO glwl_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Baɗǝm daddakwa tlatla taakiya sǝrgasǝrg kǝ dǝgita, gwaastaan sǝrgai kǝ dǝgiti ɓagaɓag kǝ marau sǝran biya. ");
INSERT INTO glwl_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Baɗǝm daddakwa waigaan kǝ Daadamazhigǝla, sǝrgasǝrǝg Daadamazhigǝl kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Ai ciya, tǝghǝr kǝ zaa dǝgzǝgi kyulvar kǝ ghǝllaha, kiyam sǝrgasǝrǝg taakiya, ma duuni baɗǝmma, maay dǝgiti tuu kǝ vakai ghǝll biya, kiyam sǝrgasǝrǝg dlaɓ taakiya Daddamazhigǝl ba palla, maay watlǝrn biya. ");
INSERT INTO glwl_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Aanji maa mǝng lii ɗahvǝtǝr dǝ “daadamazhigǝlaha” ma ghǝrazhigǝla bi ma duuniya, ba pakkata mǝng daadamazhigǝlah ard yaazhigǝlah ba ɗyakka. ");
INSERT INTO glwl_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","Bakǝvakwaha, ba pall Daadamazhigǝl vakamnda, Daadamazhigǝl Daada kwa baɗǝm dǝgitah dzǝghaar ba vakaana, Kwa kiyam ndzǝgan nǝ miyam kwakyarvad iina, Yaazhigǝl ba palla, iin Yesu Kǝristi, kwa dzǝghaar tǝdvad iin nǝ dǝgitah baɗǝmma, dlaɓa kiyam ndzǝgan tǝdvad iina. ");
INSERT INTO glwl_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Ɗǝm bi lii sǝrgasǝrg kwannǝn biya, aɗaba gwastaan badlaɓ kyalmah kwa narǝtnǝg kǝ ɓagarnǝs kwatǝnahǝr kǝ ghǝllaha akwama ma zaruzǝg kǝ kafa kyulǝga ar tlatla taakiya a ɓagvara ba kǝ ghǝlla. Aɗaba tǝhwalar bi ndan biya, ma tlatlǝg nǝ iitǝra ɓagaraɓag kǝ kwadlambǝr tǝdvad zaa kaffa ghǝll na. ");
INSERT INTO glwl_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Sǝkiyamnda bi kaf hǝrz da tǝvǝgh kǝ Daadamazhǝgǝl biya, aanji ziyamu biya, gulkiyama biya, aanji kiyam zuu fǝkiyamaraa biya. ");
INSERT INTO glwl_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Famfǝg kǝ hǝnkal aa nal bi kwara ghǝraru kǝ ɗuula ɓa haip kǝ lii hǝtsahǝtsan ndzǝɗaatǝr ma fadǝghǝr biya. ");
INSERT INTO glwl_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Aɗaba akwama nǝghǝghakaknǝghǝg kyalma uudah kǝskǝghǝn agha sǝrgasǝrǝg kǝ dǝgitǝn agha zaa kaf ma guda ghǝlla, da maay fǝtrafǝg kǝ zaa kafa ghǝll aɗaba hǝtsahǝtsan fadǝghǝraatǝr biya? ");
INSERT INTO glwl_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Tǝdvad kwaha, sǝrgasǝrgǝraghna da nǝg kǝ ɗuula mbǝɗǝg kǝ zǝraabaghǝn tǝhwal bi kwa ǝmtsaa Kǝristi mbakyarvad iina. ");
INSERT INTO glwl_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Tǝdvad ɓagar haip kǝ zaraabaharu wam ɓagar nǝ uuram haip kǝ Kǝristi, am fǝtǝra dzamagher mbakyarvad ar sǝrgabi ke dǝgiti marawa ar digiti ghwaɗ biya. ");
INSERT INTO glwl_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Mbakyarvad kwaha, akwama dǝgiti ǝn zǝg nai wa da fǝgara zǝraabar kǝ mbǝɗǝg tǝ ɗuula, ǝn ɗugaan kǝ zaa tlu haik kǝ mbǝɗǝg kǝ zǝraabar tǝ ɗuula. ");
INSERT INTO glwl_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Ən maay naiy dǝ kwara ghǝr biya? Ən zǝr ɓǝlǝga Yesu bi nai biya? Nǝghǝghana bi kǝ Yesu Yaazhigǝlamiyam biya? Abi am dlakulva tlǝri ɓagan nai ma Yaazhigǝl nǝ uuram? ");
INSERT INTO glwl_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Akwama ǝn zǝrɓǝlǝga Yesu bi nai vak uudah biya, ǝn zǝrɓǝlǝgaan nai vakaruwa, aɗaba kuram nǝ dǝga sǝrga shidar taakiya ǝn zǝrɓǝlǝga Yaazhigǝl naiya. ");
INSERT INTO glwl_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Ən ngǝdlǝg dǝ kwan nai kǝ ghǝrar vak lii naa ha shigara. ");
INSERT INTO glwl_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Mbats kalkalaan bi vǝlkǝmnd nǝ uud kǝ dǝg zǝga ard yuwa hǝɓǝg biya? ");
INSERT INTO glwl_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Kǝm maay dǝ ndzǝɗa gwayav dǝ ǝnghwasahamnd lii gatǝg band kwa ɓag kyalǝma zarha ɓǝlgah, ard zaraabaha Yaazhigǝla, ard kefas biya? ");
INSERT INTO glwl_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Nii ba kaiya ard Barnabas ha wa nalnǝg kǝ barari kǝskǝmnd kǝ ɓa tlǝr gǝlla ghǝramndi? ");
INSERT INTO glwl_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","War wa ɓatlǝra tlauja tǝhalakwaha kaa gǝlla ghǝraani? War wa uusa ghuha inabi, kwal hǝɓguu bi kǝ yuwan biyi? War wa piiya alman, da pilgarvaa hǝɓa watli? ");
INSERT INTO glwl_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Ən tag kwakyarvad dǝgiti naag nǝ uudaha? Tagada bi nǝ adzahadzaha muus ba kalkal band kwahiin biya? ");
INSERT INTO glwl_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Aɗaba vinɗaviindan ma adzahadzaha Muus taakiya, “Far bi kǝ jam ma ghai kǝ kawa uusǝg ma sarta bǝga hǝi biya,” Ba kawah kalti wa fǝg Daadamazhigǝl kǝ hyǝmi tǝ iitǝra? ");
INSERT INTO glwl_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Ba pakata tag tǝghǝr kǝskǝmiyam nǝ iin kwan kǝ ǝlbǝga, nii ǝnd kwah bi hii? Ba kǝ jiijiira, vindava mbakyarvad kǝmyama. Aɗaba kalkalaan kǝ dadda uusǝga ard dadda bǝga hiya dǝ fantaara tlǝkǝna nuubaan ma kadlannga guha. ");
INSERT INTO glwl_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Akwama riyamndariig kǝ ǝlbǝga Daadamazhigǝl ma ǝrviɗmahuɗaruwa, dǝgit ɗyaki kaci akwama vǝlamkǝmndvǝlǝg kǝ dǝga duuniyaruwa? ");
INSERT INTO glwl_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Akwamam mǝltǝrumǝlǝg kǝ kyalma uudah dǝ dǝgitaha, mbats am vǝkǝmnd juujig kwah biya? Bakǝvakwaha, ɓagamnda bi kǝ tlǝr dǝ kwahiin kǝ ndzǝɗ biya, famdafǝg kǝ huɗ aanji dǝ kwar kǝ dǝgita haik kǝ tsǝgarǝv ɓa tlǝra taa ǝlbǝg marawa Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Mbats, am sǝrgai taakiya lii ɓa tlǝr ma Vǝgya Daadamazhigǝl ar tlǝkǝna vakwahiin kǝ ɗǝgzǝgaatǝr biya? Lii ɓa tlǝr tǝ alaga, ar tlǝkǝna ba ma dǝgitahi vǝlǝvda kǝ kyuulǝg nǝ iitǝr kǝ nuubaatǝr biya? ");
INSERT INTO glwl_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Bandkwah dlaɓa, tagadatag nǝ adzahadzaha Yaazhigǝl taakiya lii taa ǝlbǝg marawa, ar da tlǝkǝna ba vakwahiin kǝ dǝga tsa puutaatǝra ");
INSERT INTO glwl_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Ɓagana bi nai kǝ tlǝr aanji ba hǝɗikǝn dǝ kwanahaan kǝ ndzǝɗ biya, dlaɓa ǝn vindǝg mbakyarvad maa ɓagwi nǝ uud ǝndkwah biya, abi ngulǝm ǝn ǝmtsan tǝghǝr kwa da tsǝkwava nǝ uud kǝ tǝɗa fǝɗyavǝgha dǝ kwanǝnna. ");
INSERT INTO glwl_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Aanji ban ɓa tlǝra taa ǝlbǝg marawa, nal bi kǝskai kǝ dǝga tǝɗa fǝɗyavǝgh biya, aɗaba barari kǝskai ɓa tlǝra. Dǝga zhuwadaal kǝskai akwama ǝn maay ɓa tlǝra taa ǝlbǝg marawǝn biya. ");
INSERT INTO glwl_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Akwamana ɓag kwakyarvad naaga ghǝrar naiya, bama maa vǝlghwavǝlǝg nǝ uud kǝ dǝgshigara, aɗaba ǝn ɓag kwakyarvad naa ghǝr biya, ǝn ɓaa tlǝra langyi kwa vǝlghwa Yaazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Au kaci dǝgshigarii? Dǝgshigar iin taa ǝlbǝg marawa, ǝn tagaan ba gyagyaana. Ən maay ɓa tlǝr dǝ ndzǝɗǝn tlankǝna nai ma tlǝra taa ǝlbǝg marawǝn biya. ");
INSERT INTO glwl_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Aanji ban ɛɛva uud bi nai biya, nandalnǝg kǝ ghǝrar kǝ ɛɛva uuda, aɗaba ǝn sǝtǝrda kǝ uudah ba ɗyakka. ");
INSERT INTO glwl_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Vak Yahudaha, ǝn nǝdal kǝ ghǝrar band Yahudah kwakyarvad ǝn sǝtǝrdaa kǝ Yahudaha. Kiyava lii mizhangyil kǝ adzahadzaha Muusa, ǝn nǝdal kǝ ghǝrar band daddakwa mizhangyil kǝ adzahadzaha, aanji ba adzahadzah bi wa kwara kai biya, mbakyarvad ǝn sǝtǝrdaa kǝ lii ma kwarǝga adzahadzaha. ");
INSERT INTO glwl_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Kiyava lii maay mizhangyil kǝ adzahadzaha Muus biya, ǝn nal band daddakwa maay ma kwarǝga adzahadzaha Muus biya, nǝgal bi taakiya maay nǝ adzahadzaha Daadamazhigǝl ɓa tlǝr tǝghǝr kǝskai biya, ǝndkwah biya, ǝn mizhangyil kǝ adzahadzaha Kǝristiya, kwakyarvad ǝn sǝtǝrdaa kǝ lii ar maay mizhangyil kǝ adzahadzaha Muus biya. ");
INSERT INTO glwl_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Lii tǝhwalar bi ma fadghǝraatǝr biya, ǝn nǝdal kǝ ghǝrar band lii tǝhwalar bi ma fadghǝraatǝr kiyava ǝn sǝtǝrdaan. Nanalnǝg aanji hulfa kwar kǝ dǝgit vak aanji hulfa kwar kǝ uudaha aɗaba ma ɓaga ba ndandara ǝn katǝrǝt kǝ kyalmaha. ");
INSERT INTO glwl_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Ən ɓa kwanahaan baɗǝm mbakyarvad ǝlbǝg marawa, kiyava tlǝkǝnatlǝg kǝskai kǝ dǝgshigar ma barkaana. ");
INSERT INTO glwl_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Mbats am sǝrga biya, vaka ɓa agwaraagwara ǝmndǝrga, baɗǝm lii ǝmndǝrga ar ɓa kǝlla ndzǝɗaatǝra ar jaara kǝ zaraabahaatǝr dǝ ǝmndǝrga, ba pal ma iitǝr wada tlǝkǝna dǝgshiga fiir biya? Aiciya, ǝmndǝramdǝrǝg tǝ ɗuuli am da tlǝkǝna nǝ uuram kǝ dǝgshiga. ");
INSERT INTO glwl_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Baɗǝm lii ɓa agwagraagwaraa ɓa dǝra ar salgaan kǝ ghǝraatǝr ba walaklak kwakyarvad ar tlǝkǝna kǝ dǝgshigaatǝr kwa zǝlma biya, amma kǝmnd dǝgshigamnda da maay badzǝg ba dǝm biya. ");
INSERT INTO glwl_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Mbakyarvad kwaha ɓalla ǝmndǝrgara da nǝgalbi gyan biya, tsa dǝmbara ǝn tsǝg ma fǝdbiya. ");
INSERT INTO glwl_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","Aɗaba ǝn ndaigaan kǝ vǝghara, nandalnǝg kǝ ɛɛvara, mbakyarvad aa nal bi dlaɓ tǝhala taa ǝlbǝg maraw kǝskai kǝ kyalmaha, kai kata ghǝrarra ǝn da ghudal ma tlǝkǝna dǝgshiga za fiira. ");
INSERT INTO glwl_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Aiciya, ǝn naagan am sǝran zaraabah taakiya, daadijahamiyam baɗǝm daral mizhangyil kǝ akumba tǝ ɗuula dagalla, baɗǝmmatǝra daral bama taataka yuwa haiya. ");
INSERT INTO glwl_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Ɓagavtǝra bama akumba ard yuwa haiy tsuufǝg kǝ iitǝr baɗǝm kǝ gata adzahadzaha musa. ");
INSERT INTO glwl_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Baɗǝmmatǝra zaruuzǝg kǝ dǝgzǝgi sahi ma ghǝrazhigǝla, ");
INSERT INTO glwl_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","baɗǝmmaatǝra hǝɓaruuhǝɓǝg kǝ yu kwa vǝlatǝr Daadamazhigǝl aɗaba hǝɓaruu yu ma akura kwa maratǝrda Daadamazhigǝla, kwa da dagal ǝmtaɗ dǝ iitǝra, Kwahiin kǝ akura iin Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Bakǝvakwaha cinngu bi Daadamazhigǝl kǝ ǝmtakǝr dǝ kyalmaatǝr biya, ruwararuug ma tǝghala. ");
INSERT INTO glwl_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Nalnǝg wan kǝ dǝga garav kǝskimyam ndakwana haik kǝ kǝma dǝgaha kǝlaadǝr bandkwa ɓag nǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Namal bi kǝ lii ɓargarnǝs kwatǝnahǝr kǝ ghǝllah band kwa naral kyalmah biya. Aɗaba vindavinda ma kakkaɗa Daadamazhigǝl taakiya, “cahwararacahwarǝg nǝ uudaha ar zǝgaana ar hǝɓgaana, baz shakalga ard ɓa gwaragwara.” ");
INSERT INTO glwl_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Ɓagiyam bi kǝ gwaragwar bandkwa ɓag kyalmah biya, aɗaba ǝmtsaharaǝmtsahǝg nǝ uudah alfu kulbu tar uufaɗa ba daaval palla. ");
INSERT INTO glwl_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Fǝshiyam bi kǝ Yaazhigǝl bandkwa ɓagar kyalmah biya, ghwahatǝraghwahǝg ghavalaha ruwararuuga. ");
INSERT INTO glwl_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Zaviyam bi kǝ ghai bandkwa ɓag kyalmah biya, aɗaba ciɓatǝraciɓǝg nǝ zarha ɓǝlga Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Kwanahaan kǝ dǝgitah dzǝghaar dǝ iitǝrǝn ba garava, vindavavindǝg wan mbakyarvad ɓǝlkiyama nǝ uud kǝ magiya, kǝmiyamǝn tlakiyama nǝ ghyǝnga zamanna. ");
INSERT INTO glwl_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Mbakyarvad kwaha, akwama agha tlatla taaikya ghacighaghacig ba danngala, aiciya, fafǝg kǝ hǝnkala mbǝɗa biya. ");
INSERT INTO glwl_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Maay fǝshǝgi tlakuratlǝg kwa tapǝghana bi kǝ dzǝgaardzǝg dǝ uudah biya. Aɗaba Daadamazhigǝla uuda jiirjiir nǝ iina da ɗukurǝs bi am dǝm damma fǝshig kwa juujig kǝ ndzǝɗaru biya, akwama damǝmdǝg fǝshiga, da wurkurantwurg kǝ ɗuula ngǝdlǝg kwam da dzugwantdzug nǝ uurama. ");
INSERT INTO glwl_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Mbakyarvad kwaha, kuramǝn ǝn waikur naiyna, kuvamkuvǝg kǝ ɓagar kwatǝnahǝr kǝ ghǝllaha. ");
INSERT INTO glwl_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Ən tagkur kǝskuramǝm am ɗainaɗaig kǝ ghǝr na, dzamamdzamǝg kǝ ghǝr ghǝravaru tǝghǝr kǝ dǝgiti ǝn tagkur naiya. ");
INSERT INTO glwl_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Kuuwǝn dǝga barka nǝ iin kwa kiyam taa uus dǝvakiya, mbats iin bi wa fǝkiyama ndzǝga pal ma avǝza Kǝristi biya? Bruudyin kiyam ghwadǝg nǝ miyamǝna, iin bi wa fǝkiyama ndzǝga pal ma vǝgha Kǝristi biya? ");
INSERT INTO glwl_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Ba pall tsaw bruudina, mbats kǝmiyamǝn kiyam ɗyakna ba vǝgh palla, aɗaba baɗǝmma miyama ba bruudi pall wa kiyam zǝg nǝ miyama. ");
INSERT INTO glwl_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Zharamzharg kǝ uudaha israila. Mbats lii zaa dǝga kyuulǝga, ar ba dǝgit pal bi nǝ iitǝr ma zaa dǝga kyuulǝg kwa vǝlǝva kǝ Daadamazhigǝl tǝ alaga kyuulǝg biya? ");
INSERT INTO glwl_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Awan tlatlǝg nai vakwani? Dǝgiti aa hǝrvaru kǝ ghǝli ci nǝ dǝgita? Nii ghǝlini ka ci nǝ dǝgiti? ");
INSERT INTO glwl_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Əndkwah biya, ǝn tlatla taakiya, dǝga kyuulǝgi kwa vǝlǝgar lii ɓagar kwatǝnah kǝ ghǝlla, ar vǝlgar kǝ shatanaha, kǝ Daadamazhigǝl biya. Ən naiy am nal band shatanah biya. ");
INSERT INTO glwl_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Ɓaga bi taakiya am hǝɓu ma kuwa Yaazhigǝla, dlaɓa am hǝɓu ma dǝga shatanah biya. Ɓaga bi taakiya am zuu kǝ dǝga Yaazhigǝla, dlaɓa am zuu kǝ dǝga shatanah biya. ");
INSERT INTO glwl_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Kiyam pǝcca ghaiya Yaazhigǝl kiyava ɓa shilǝg nii? Jiyamujig kǝ iin dǝ ndzǝɗ hi? ");
INSERT INTO glwl_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","“Haiyakiyamanthaig nǝ uud kǝ dǝgitah baɗǝmma” Ɗǝm bi dǝgitah mǝng tlǝran biya, “Baɗǝm dǝgitah haiyakimathaig nǝ uuda,” Ɗǝm bi dǝgitahi da fǝgara ndzǝɗ ma fadǝghǝr kǝ uud biya. ");
INSERT INTO glwl_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Ɓagar bi kǝ dǝgit maraw ghǝragh kalti biya, ɓagarɓag baz zǝraabagha. ");
INSERT INTO glwl_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Zamzǝg kǝ hulfa dǝgiti valav vaka valla tlu baɗǝmma, ba kwal ndavǝgaan kǝskurama, haik dzamgaan kǝskuram ma ǝrviɗmahuɗaru kǝ vakavaki aa sǝgal dǝ tluwiina. ");
INSERT INTO glwl_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Aɗaba tagatag nǝ ǝlbǝga Daadamazhigǝla taakiya, “Duuniya ard dǝgiti ma vakaita baɗǝmma dǝga Daadamazhigǝla,” ");
INSERT INTO glwl_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Akwama ɗahakurǝtɗahǝg daddakwa maay gatǝg da za kaffa, ma haiyamanthaig kǝ dagauwa, zamzǝg baɗǝm kǝ hulfa dǝgitahi aa vǝlkur nǝ iina, ba kwal ndavǝga, haik dzamgaan kǝskuram ma ǝrviɗmahuɗaru kǝ vakavaki aa sǝgal dǝ dǝgzǝgiina. ");
INSERT INTO glwl_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Akwama tagakuuratag nǝ uud taakiya, “Aa hǝrvara kǝ ghǝll wanǝnna,” zambiya, mbakyarvad dadda kwa tagkurataga, dlaɓa hǝna nǝ ǝrviɗmahuɗaruwa. ");
INSERT INTO glwl_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Ən tlatla dǝgiti da dzamǝg nǝ uuda nǝ iin ma ǝrviɗmahuɗaana, dǝgaru biya. Tagdatag pallaru taakiya “Aujilbǝg kǝ dzamaghǝra uudan da tsǝkwava kǝ kwara ghǝrari? ");
INSERT INTO glwl_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Akwama taganaratag kǝ uus kǝ Daadamazhigǝla lakwti ǝn da zaa dǝgzǝga, aujibǝg da ghudgus ǝlbǝg nǝ uud tǝghǝr kǝ dǝgiti naa zǝg naiy tambar taganaratag kǝ uus kǝ Daadamazhǝgǝli?” ");
INSERT INTO glwl_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Aiciya, baɗǝm dǝgiti am ɓag nǝ uurama, aanji am zǝg dǝ zǝga, bi am hǝɓǝg dǝ hǝɓǝga, ɓagamɓag mbakyarvad ndanngǝra Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Namal bi kǝ ɗuula ɓa haip kǝ yahudah biya, aanji ma lii ar yahudah biya, bii lii gata Daadamazhigǝl biya. ");
INSERT INTO glwl_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Ɓagamɓag band kwa ǝn ɓag naiya. Ən ɓa kǝla ndzǝɗar maa cinngu aanji ba war kǝ ǝmtakǝra dǝgitahi ǝn ɓag nai baɗǝmma, kwakyarvad ghǝrar pal wan ɓag nai biya, ǝn ɓag kwakyarvad mǝlgaru kǝ uudah ba ɗyakka, aɗaba ar tlǝkǝna kǝ katǝga. ");
INSERT INTO glwl_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Gatamgatǝg kǝ garavara, bandkwan gatǝg nai kǝ garava Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Ən galkurgalǝg aɗaba am dzamkwadzamǝg aanji ma kwar kǝ dǝgita, dlaɓa hakyamvǝthakyǝg tǝ dǝga daadij bandkwa tsagankuru naiya. ");
INSERT INTO glwl_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Aɗaba ǝn nagaan am nǝghaaka taakiya, Kǝristi maal tǝghǝr kǝ aanji kwar kǝ uuda, Zhiil dlaɓa maal tǝghǝr kǝ uusaana, Daadamazhigǝl dlaɓa maal tǝghǝr Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Baɗǝm ghwalvi dzǝgwazhigǝl bi taa tlayanngǝr kutakuta sǝɗav ma ghǝra nenghǝninenig kǝ daddakwa maal tǝghǝr kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Baɗǝm nǝ uusi dzǝgwazhigǝla bi taa tlayanngǝr kwal kutǝgǝr sǝɗav ma ghǝra, nenghǝninenig kǝ zhiilaana, ba kalkal bandgi aa uusǝda ghǝra. ");
INSERT INTO glwl_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Akwama lawalǝg nǝ uus kuta sǝɗav ma ghǝra, ba uusǝda kǝ ghǝraana, amma dǝga zhǝru tsaw nǝ uusa ghǝr kǝ dǝg hǝra, aa kutǝrkutǝg kǝ sǝɗav ma ghǝra. ");
INSERT INTO glwl_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Kalkal bi kǝ ghwalǝv kuta sǝɗav ma ghǝr biya, aɗaba mara dzakǝva Daadamazhigǝla ard ndanngǝraana, amma uusa mara ndanngǝra zhiilaana. ");
INSERT INTO glwl_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Aɗaba sal ma vǝgh kǝ uus bi ghwalǝv biya, uus wa sǝghal ma vǝgha ghwalǝva. ");
INSERT INTO glwl_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Vǝrɗyava kwakyarvad uus bi ghwalǝv biya, bamma uus wa vǝrɗyava kwakyarvad ghwalǝva. ");
INSERT INTO glwl_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Mbakyarvad kwaha barari kǝ uus kutǝr kǝ sǝɗav ma ghǝra, nal kǝ dǝga sǝrǝg taakiya dǝ ndzǝɗ zǝrɓǝlga. ");
INSERT INTO glwl_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Bakǝvakwaha, tagwa bi nǝ uus dǝ ghwalǝv ma Kǝristi biya, ghwalǝv dlaɓa tagwa bi dǝ uus ma Kǝristi biya. ");
INSERT INTO glwl_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Bandkwa sǝghal nǝ uus ma vǝgha ghwalǝva, uus dlaɓ wa yaa ghwalǝva, aɗaba baɗǝm dǝgit ɓagaa ba Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Vazamvazǝg ba nǝ uuram dǝ ghǝraruwa, kalkalaan kǝ uus dzǝgwazhigǝl kǝ Daadamazhigǝl kwal kutǝgǝr sǝɗav ma ghǝra? ");
INSERT INTO glwl_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Abi aanji ba ndzǝgana duuni tsagakurutsag taakiya akwama ɗuugharsɗuug ghwalǝv kǝ guj ma ghǝraan kwal usǝga, dǝga zhǝruw kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Amma uusi tlaɗ nǝ guja ma ghǝraana, dǝga ndanngǝr vakaana, aɗaba ɓagavara mbakyarvad hǝɗɗa ghǝraan nǝ guja. ");
INSERT INTO glwl_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Akwama mǝnng daddakwa naa ɓaa ngǝji tǝghǝr kwannǝna, kǝm sǝrga bi nǝmnd kwatlǝrn kǝ dǝga daadij biya, bandkwah dlaɓ kyalma zaraabah lii gatǝga. ");
INSERT INTO glwl_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Tǝghǝr kǝ ǝlbǝgǝn tagankur nai na, dlǝbankurǝt biya aɗaba dzahavaruna dǝga jiijiir biya. ");
INSERT INTO glwl_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Cinngancinng taakiya akwama dzahamvǝtdzahǝga, hulfa dzahava yaa dadda gatǝga, mǝnng tagwazhatagwazh ma taatakaruwa, dlaɓa fanarzhafǝg kǝ haiganthaig dǝ ǝlbǝgiina. ");
INSERT INTO glwl_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Barari tlǝvkǝnatlǝg tagwazhatagwazh ma taatakaruwa, aɗaba nǝghǝvaaka nǝ uudaha jiijiir ma taatakaruwa. ");
INSERT INTO glwl_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Mbats ma dzahamvǝtdzahǝga, am dzahav kwakyarvad za jibiya Yaazhigǝl biya. ");
INSERT INTO glwl_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","Aɗaba vaka za dǝgzǝga, aanji wara ghǝraan ba tǝ dǝgiti zǝg nǝ iina, da ɗuuvars watlǝrn dǝ waiya, kwatlǝrn dlaɓa da hǝɓu da tsa band kya. ");
INSERT INTO glwl_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","Am maay dǝ hǝnnyahah kwam da zǝg nǝ uuram ard hǝɓgaan ma vakai biya? Nii am nenna dlamakǝlaw lii gata Daadamazhigǝl tǝdvad vǝltǝr dlaɗ kǝ lii maay ba ndaw vakatǝr hi? Auci wan da tagkur naiyi, ǝn da dlǝba kuuram mbakyarvad kwana? Ən maay dlǝbkurdlǝbǝg biya. ");
INSERT INTO glwl_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Dǝginǝn vǝlankur nai na, dlǝghana vak Yaazhigǝla, taakiya, Yaazhigǝl Yesu, ma huɗavǝɗǝn vǝlavǝt nǝ iin na, kǝssant kǝ bruudiya, ");
INSERT INTO glwl_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","tǝhala tagar uus kǝ Daadamazhigǝla, ghwadǝna kǝ iina, aiyama, “Kwana iin nǝ vǝghara, kwa vǝlavǝda mbakyarvad kuurama. Ndzaa ba ɓagamɓag bandkwana kiyava dzamkwadzamǝg kǝskuurama.” ");
INSERT INTO glwl_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Bandkwah dlaɓ tǝhala za jibiya, kǝssant kǝ iin kǝ zǝr kuuwa amaa,“ Kwan kǝ zǝr kuwa iin daala langiya avzara, ɓagamɓag bandkwana ba tuuk sarti am hǝɓǝg nǝ uurama, kiyava dzamkwadzamǝg kǝskuurama.” ");
INSERT INTO glwl_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Ba tuuk sarti am zǝg nǝ uuram kǝ bruudiya, dlaɓa am hǝɓǝgaan ma zǝr ku na, am kuta ǝmtsǝga Yaazhigǝl, tangw damma sarti da saay nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Mbakyarvad kwaha baɗǝm daddakwa zǝguu bruudina, bi hǝɓǝgu ma zǝr kuwa Yaazhigǝl tǝ ɗul kalkal biya, ɓagharaɓag kǝ haip kǝ vǝgha Kǝristi ard avǝzaana, ");
INSERT INTO glwl_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Ma ba wara aa vazǝnavazǝg kǝ ndzǝganaana, lakwti zǝgaan kǝ bruudiya ard hǝɓǝgaan ma zǝr ku na. ");
INSERT INTO glwl_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Baɗǝm daddakwa zǝguu bruudiya, bi hǝɓǝgu ma zǝr ku kwal fǝgaarafǝg kǝ vǝgha Yaazhigǝla, sǝghardaasǝg kǝ shari kǝ ghǝraan tǝdvad zǝgaana ard hǝɓǝgaana. ");
INSERT INTO glwl_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Iin wa nǝ iin ba ɗyak lii ar maay dǝ ndzǝɗa ard lii lapi bi ma kuurama, kyalmah ndakwani ǝmtsaharaǝmtsahǝga. ");
INSERT INTO glwl_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Akwama ma gatiyamarzhagatǝg kǝ ndzǝganamiyam ba zunngwa, da maay nǝ uud tǝkiyam shari biya. ");
INSERT INTO glwl_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Akwama Yaazhigǝl wa tǝkiyam shariya, ndaig wa ɓagkiyam nǝ iin haik ghazǝkiyamghazǝg kǝ uud ǝmtaɗ dǝ uudaha duuniya. ");
INSERT INTO glwl_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Mbakyarvad kwah zaraabahara, akwama dzahamvǝtdzahǝg da za dǝgzǝga, am pakant kǝ zaraabaharuwa. ");
INSERT INTO glwl_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Akwama mǝnng daddakwa njǝkǝn wai ma kuurama, aa zuuzǝg kǝ dǝgzǝg hǝnnyaha, aa da sǝkurda bi dzahavaruwǝn kǝ dlaɗ biya. Tǝghǝr kǝ kyalma dǝgitah dlaɓa, akwamada sanaasǝga ǝn da tagkurtaga. ");
INSERT INTO glwl_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Ndakwan ciya, zaraabahaara, tǝghǝr kǝ vǝlga Shǝɗkwa Daadamazhigǝla, ǝn nai am ndzan kwal sǝrgasǝrg biya. ");
INSERT INTO glwl_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Ndzam sǝrgasǝrǝg taakiya ma sarta kwa ndzam tǝ kǝrdi nǝ uurama, valakurda dǝ valǝg nǝ uuda, ndzam ɓagar kwatǝnahǝr kǝ ghǝllah kwar maay dǝ shifǝg biya. ");
INSERT INTO glwl_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Aɗabad kwaha ǝn naagaan am nǝghaakan taakiya, maay daddakwa ɓa tlǝr Shǝɗkwa Daadamazhigǝl dǝ iin da taakiya, “Tlafatlafan nǝ Yesu biya!” Dlaɓa maay wa tagdatag taakiya, “Yesu Yaazhigǝl biya,” bamma daddakwa Shǝɗkwa Daadamazhigǝl wa ɓa tlǝr dǝ iina. ");
INSERT INTO glwl_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Mǝnng vǝlgah shahshaha, ba Shǝɗkwa Daadamazhigǝl pall wa vǝlgaan baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Mǝnng ɗuula ɓa tlǝr shahshaha, ba Yaazhigǝl pall wa ɓagvara. ");
INSERT INTO glwl_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Mǝnng tlǝrah shahshaha, amma ba Daadamazhigǝl pall wa vǝlgar ndzǝɗa ɓagaan kǝ uudah baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Nǝghǝvaakanǝghǝg ndzǝgana Shǝɗkwa Daadamazhigǝl ma aanji kwar kǝ uud tǝdvad tlǝrahi ar ɓag nǝ iitǝr kiyava mǝltru kǝ uudah baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Mǝnng wana vǝlavar dǝga tsaga dabariya tǝdvad Shǝɗkwa Daadamazhigǝla, kwaktlǝrn dlaɓa vǝlavar dǝga tsaga ard sǝrgasǝrgǝr tǝdvad kwannǝn kǝ Shǝɗkwa. ");
INSERT INTO glwl_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","Kwatlǝrn dlaɓa vǝlavar dǝga fadǝghǝr tǝdvad kwan nǝ iin kǝ Shǝɗǝkwa, kwatlǝrna vǝlavar dǝga mbaha uudah tǝdvad shǝɗǝkw na, ");
INSERT INTO glwl_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","Kwatlǝrna dlaɓa vǝlavar ɓa tlǝraha dǝga jappǝrra, kwanaa dǝga tlayanngǝra, kwatlǝrna dlaɓa tagwarzhatagw kǝ ndzǝgana shǝɗǝkwaha, kwatlǝrna dǝga sǝrga taa ghai shahshaha, kwatlǝrn dlaɓa dǝga gwiya ghaiyah shahshaha. ");
INSERT INTO glwl_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Baɗǝm wanahaan ba Shǝɗǝkw pall wa ɓagaana, dlaɓa ba iin wa tagwartagw kǝ uud dǝ naaga ghǝraana. ");
INSERT INTO glwl_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Bandkwa ba pall nǝ vǝgha, dlaɓa uuɓiyah tǝvakai ba ɗyaka, aanji ba mǝnng nǝ uuɓiyah ba ɗyaka, ar ba vǝgh palla. Bandkwah ci kǝ Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Aɗaba ɓagakiyamaɓag nǝ uud kǝ tsuufǝg baɗǝmmamiyam tǝdvad Shǝɗǝkw pall damma vǝgh palla, aanji Yahuudaha aanji lii Yahuudah biya, ma ɛɛva nǝ iina bi dadda kwara ghǝraana, baɗǝmmamiyama vǝlakiyamvǝlǝg nǝ uud kǝ Shǝɗǝkwiin kiyava hǝɓǝga. ");
INSERT INTO glwl_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Vǝgh uuɓii pall bi nǝ iin biya, uuɓiyah ba ɗyak tǝ vakaiya, ");
INSERT INTO glwl_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Akwama tagadatag shig taaki, “ Ən dǝv bi nai biya, mbakyarvad kwaha ǝn, uuɓiya vǝgh bi nai biya,” Atar ba tagda kwana tsǝgarva bi kǝ nǝg kǝ uuɓiya vǝgh biya. ");
INSERT INTO glwl_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","Bandkwah dlaɓ hyǝmi akwama tagadatag taakiya,“Ən gyi bi nai biya, kwakyarvad kwaha ǝn uuɓiya vǝgh bi nai biya,” Atar ba tagǝda ǝndkwaha tsǝgarva bi kǝ nǝg uuɓiya vǝgh biya. ");
INSERT INTO glwl_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Akwa maa baɗǝm nǝ vǝgh maa ba gyiya, maa da cinngav dǝ au nǝ ǝlbǝgi? Akwa maa baɗǝm nǝ vǝgh maa ba hyǝmiya, maa da shiyav dau nǝ dǝgiti? ");
INSERT INTO glwl_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Amma ɓadlǝghanaɓadlǝg Daadamazhigǝl aanji kwar kǝ uuɓiya vǝgh bandkwa kǝsghaaka nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Akwa maa baɗǝm nǝ vǝgh ba uuɓi palla, maa mǝr tǝmga vǝghi? ");
INSERT INTO glwl_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Iin wan kwana mǝnng nǝ uuɓiyah ba ɗyaka, amma vǝgh ba palla. ");
INSERT INTO glwl_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Tagarda bi gyi kǝ dǝv taakiya,“Maay lambar dǝ kǝgh biya,”Aanji ghǝr tagardai kǝ shigah taakiya,“Maay lambar dǝ kuuram biya.” ");
INSERT INTO glwl_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Əndkwah biya, uuɓiyahi vazav bandgi ar maay dǝ puutaatǝr biya, iitǝr wa mǝnng tlǝraatǝra. ");
INSERT INTO glwl_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","Uuɓiya vǝghahi kiyam vazǝg nǝ miyam bandgi dǝti ndanngǝr da tǝ kyalmǝn biya, iitǝr wa kiyam fǝtǝraara nǝ miyama. Mbakyarvad kwaha uuɓiya vǝghahamiyami ghwaɗ kǝ vazǝg fǝvarnaafǝg marawuraana. ");
INSERT INTO glwl_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","Uuɓiyaha vǝghahamiyamǝn maaraw kǝ Vazǝg naa bamma ɓagavtǝra dǝgit biya, maltlǝghantmatlǝg Daadamazhigǝl kǝ vǝgh vak palla, nǝdal kǝ uuɓiyahi nenenennen kǝ ndanngǝra ");
INSERT INTO glwl_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","Aɗaba aa dzaar bi tagwazhatagwazh tǝ vǝgh biya, bamma uuɓiyah wa fa hyǝmi ma taatakatǝra. ");
INSERT INTO glwl_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","Mbakyarvad kwaha akwama tlakǝnatlǝg nǝ uuɓii pal kǝ dlaɗa, baɗǝmmatǝra ar ma dlaɗa, akwama dlǝbavantdlǝɓǝg nǝ uuɓii palla, baɗǝmmatǝra ar ba hwaɗag ǝmtaɗa. ");
INSERT INTO glwl_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Baɗǝmmaruwa am vǝgha Kǝristi, ma kwararuwa am uuɓiyana. ");
INSERT INTO glwl_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","Ma yaa dadda gatǝga, faafǝg Daadamazhigǝl kǝ zarhaɓǝlga Yesu kǝ dǝga zunngwa, dǝga buwa tlayanngaha, dǝga hǝkǝrɗa lii tsaga dǝgita, lii ɓa dǝgaha jappǝra, lii vǝlavtǝr vǝlga mbahuudaha, ard lii mǝlgaru kǝ uudaha, ard lii fa hyǝmi tǝ tlǝra yaa dadda gatǝga, ard lii sǝrga taa ghai shahshaha. ");
INSERT INTO glwl_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Baɗǝm ar ba zarhaɓǝlga Yesu ni? Baɗǝm ar ba tlayangah ni? Baɗǝm ar ba lii tsaga dǝgit ni? Nii baɗǝm ar ba lii ɓa dǝgaha jappǝr hi? ");
INSERT INTO glwl_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","Baɗǝm ar ba dǝ vǝlga mbaha uudah ni? Baɗǝm ar ba sǝrgasǝrg kǝ taa ghaiyah shahshah ni? Nii baɗǝmmatǝr ha sǝrgasǝrg kǝ gwiya ghaiyah hi? ");
INSERT INTO glwl_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","Kǝmamkǝmǝg kǝ vǝlgahi kwa ndannga, ǝn da markurmarg kǝ ɗuuli kwa juujig baɗǝm dǝ marawa. ");
INSERT INTO glwl_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Aanji ma naa ba sǝrgasǝrg kǝ taa ghaiya uudah shahshah ard dǝga zǝrɓǝlgaha Daadamazhigǝla, akwama ǝn maay dǝ waiyakǝv biya, nanalnǝg band talenaleng kwa tlaav ba gyaagyaana, bi ganng kwa tlaav ba ɗyakɗyaka, ");
INSERT INTO glwl_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","Aanji ma naa ba sǝrgasǝrg kǝ taa tlayanngǝra, ǝn nǝghǝgaakanǝghǝg kǝ dǝgitah shiɓashiɓan baɗǝmma, dlaɓa ǝn dǝ sǝrgasǝrgǝr baɗǝmma, aanji ma naa ba dǝ fadǝghǝr ba vaivaiya, kwa da gantgǝg kǝ aghwa, akwama ǝn maay dǝ waiyakǝvǝr biya, maay dǝgiti ǝn tuuk vakai nai biya. ");
INSERT INTO glwl_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Aanji ǝn vǝldan kǝ dǝgitahi ǝn dǝ vakai nai baɗǝmma, ǝn vǝldan dlaɓ kǝ vǝghara hǝvara kaara, akwama ba ǝn maay dǝ waiyakǝv biya, maay paiɗaan vakar biya. ");
INSERT INTO glwl_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Waiyava dǝ fa ǝrviɗa ard kanaadiya, waiyava maay shilg biya, maay tsa kusǝgh biya, dlaɓa maay naa ghǝr biya, ");
INSERT INTO glwl_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","maay waiyav dǝ naa ghǝr biya, maay fa dagar ma uudah biya, maay badza ǝrviɗmahuɗ biya, maay dlaɓ hǝkya dǝgit ghwaɗ ɓagavaran biya. ");
INSERT INTO glwl_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","Maay waiyav cinnga ǝmtakǝra kǝlaadǝr biya, amma cinngaan kǝ ǝmtakǝra jiira, ");
INSERT INTO glwl_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","Fǝgaan waiyav kǝ ǝrviɗ aanji ma kwar kǝ ndzǝgana, ard fadǝghǝr aanji ma kwar kǝ ndzǝgana, ard fantaar aanji ma kwar kǝ ndzǝgana, ard ɓǝshgaana aanji ma kwar kǝ ndzǝgana. ");
INSERT INTO glwl_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Maay ghyǝnng waiyav ba dǝm biya, taa tlayanngǝra da ghaciga, ghayah shasha dlaɓa da zǝgga, sǝrgasǝrgǝr da ghyǝnnga. ");
INSERT INTO glwl_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","Bak jiijiira, sǝrgasǝrgǝramiyama ard taa tlayanngǝramiyama righghǝt biya. ");
INSERT INTO glwl_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","Akwama da sǝghawisǝg daddakwa righarighana, kaa da nig kǝ daddakwa righa biyǝn tǝhala kwaha. ");
INSERT INTO glwl_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Ma sarta zarhǝrara, ndzan taa ghai band zarha, ndzan dzamaghǝr band zarha, ndzan vǝla farwut band zarha. Ghubara ba naiya ǝn ɗuwars kǝ hǝnkala zarhǝra. ");
INSERT INTO glwl_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Aɗaba ndakwana kiyam nǝghǝganǝghǝg wuzǝhwuzǝh kǝ dzakǝva ma akwatǝrama, daghuvalaana kiyam da nǝghǝkǝv ba ma gyi ma gyi, aɗaba ndakwana sǝrgasǝrgǝrara righǝt biya, daghuvalaana sǝrgasǝrgǝrara da righǝg ba ɗyakɗyak band kwa fakwi Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","Ndakwan ciya, dǝgitahaan hǝkǝrɗǝn ndzarandzǝga, fadǝghǝra, fantaara, ard waiyava, amma kwa dadal ma iitǝr baɗǝmma, iin waiyava. ");
INSERT INTO glwl_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Ghulamvaghulǝg kǝ gata waiyava, kǝmamkǝmǝg dlaɓ kǝ vǝlga sǝrgasǝrǝg vak Shǝɗkwa Daadamazhigǝla, ndǝ dǝga taa tlayanngǝra. ");
INSERT INTO glwl_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Aɗaba daddakwa taa ghai kwa sǝrva bi tag dǝ uudah biya, tag dǝ Daadamazhigǝla, aɗaba maay wa nǝghǝgaakanǝghǝg kǝ dǝgitahi tag nǝ iin biya, mbakyarvad taa dǝgitahi shiɓashiɓan tǝdvad ndzǝɗa Shǝɗkwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Aɗaba daddakwa taa tlayanngǝra, tagtǝr mbakyarvad fǝtǝrna ndzǝɗ kǝ uudaha, mǝltǝruwa, dlaɓa tagtǝra kǝ dzǝgwagha. ");
INSERT INTO glwl_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Daddakwa taa ghai kwa sǝrva bi mǝlgaru ba kǝ ghǝraana, aɗaba daddakwa taa tlayanngǝra mǝltǝru kǝ yaa dadda gatǝga. ");
INSERT INTO glwl_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","Ən naagaan baɗǝmmaru mamma taa ghai kwa sǝrva biya, amma ma tǝ naagar mamma taa tlayanngǝra. Daddakwa taa tlayanngǝr juujig kǝ daddakwa taa ghai kwa sǝrva biya, bamma mǝng daddakwa sǝrgasǝrǝg kǝ gwiya ghaiyin kiyava mǝlgaru kǝ yaa dadda gatǝga. ");
INSERT INTO glwl_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","Aici zaraabahara, akwama sanǝvsǝg sa vakaru ǝn tagkur kǝ ǝlbǝg dǝ ghai kwa sǝrva biya, auci paiɗaan vakaru, bamma ǝn sǝgǝv dǝ ǝlbǝgaha, bi sǝrǝgasǝrǝgǝra, bi taa tlayanngǝra, bi tsaga ǝlbǝga Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","Bandkwah dlaɓ dǝgitahi maay dǝ shifǝg biya, band faakila ard kakkangya. Akwama cinngal bi tlaavatǝr ɗyakɗyak biya, da sǝrga ndandar nǝ uudan kǝ dǝgiti tsava ard dǝgiti fǝrtavi? ");
INSERT INTO glwl_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","Akwama fǝrtavant bi dǝraw kalkala kwa nǝghǝvaakanǝghǝg biya, war wa da ɓadlava da ghwaavi? ");
INSERT INTO glwl_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","Bandkwah dlaɓ vakaruwa, akwama tagamatag kǝ ǝlbǝg dǝ ghai kwa sǝrva biya, da sǝrvaaka ndar nǝ dǝgiti am tag nǝ uurami? Tagamatag kǝ ǝlbǝg ba gyagyaana. ");
INSERT INTO glwl_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Mǝnng ghaiyah shahshah ma duuniya, ma kwaraatǝra ba tuuk kǝ ǝlbǝga. ");
INSERT INTO glwl_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","Akwama ǝn cinnga bi kǝ ghaiyin biya, nanalnǝg kǝ ghulab kǝ daddakwa ta ǝlbǝgiina, ghǝravaan ndakwi nalnǝg kǝ ghulab vakara. ");
INSERT INTO glwl_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","Bandkwah dlaɓ vakaruwa, akwamam kǝmma tlǝkǝna vǝlǝg shahshah dǝga Shǝɗkwa, ghulamvaghulǝg ɓagamɓag kǝlaa ndzǝɗaru am ɓagaan kǝ tlǝr dǝ vǝlǝgahaan kwa da fǝtǝrna ndzǝɗ kǝ yaa dadda gatǝga. ");
INSERT INTO glwl_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","Mbakyarvad kwaha, baɗǝm daddakwa taa ǝlbǝg dǝ kwatlǝr kǝ ghaiya, aa dzugw kǝ zhigǝl vǝlvar sǝrgasǝrga gwiiya ghaiyiina. ");
INSERT INTO glwl_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","Akwama dzǝgwanadzugw kǝ zhigǝl dǝ ghai kwa sǝrva biya, Shǝɗkwar wa dzǝgwazhigǝla, ǝn nǝghǝgaaka bi kǝ dǝgiti ǝn tag nai biya. ");
INSERT INTO glwl_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","Auci, wan da ɓag naiyi? Ən dzǝgwaan kǝ zhigǝl dǝ Shǝɗkwara, ǝn dzǝgwaan dlaɓ kǝ zhigǝl ma ǝrviɗyara. Ən ɓǝlgaan dlaɓ kǝ ǝnngs ma Shǝɗkwara, dlaɓa ǝn ɓǝlgaan dlaɓ kǝ ǝnngs ma ǝrviɗyara. ");
INSERT INTO glwl_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","Akwama maay ǝndkwah biya, akwama taghartag kǝ uus kǝ Daadamazhigǝl ma Shǝɗkw kaltiya, da tag ndandar ci daddakwa cinnga bi kǝ ghaiyǝn agha tag nǝnng taaki, “Amin” tǝghǝr kǝ taa uus kwa agha tag nǝnng, akwama sǝrga bi kǝ dǝgiti agha tag nǝnng biyi? ");
INSERT INTO glwl_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","Aanji ba tagharatag kǝ uus kǝ Daadamazhigǝl ba vaivaiya, mǝlgharu bi kǝ uudanin biya. ");
INSERT INTO glwl_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","Ən tagar uus kǝ Daadamazhigǝl ǝn tagatag kǝ ǝlbǝg dǝ ghai kwa sǝrva bi tǝghǝr kǝskuram baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","Bakǝvakwah ma dzahava yaa dadda gatǝga, manaa naag nai manaa tagda kǝ ǝlbǝg ba dlǝɓ kiyava nǝghǝgaakanǝghǝg kǝ iitǝra, dlaɓa ǝn tsagtǝru kǝ kyalmaha, tǝghǝr kǝ tagda ǝlbǝgah alfu kǝlaaw dǝ ghai kwa sǝrva biya. ");
INSERT INTO glwl_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Zaraabahara, dzamam bi kǝ ghǝr ndǝ zarh biya, namalnǝg band vunjah tǝdvad ɓa kǝlaadǝra, dzamamdzamǝg kǝ ghǝr band uudah maamala. ");
INSERT INTO glwl_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","Vindavindan ma Kakkaɗa Daadamazhigǝl taakiya, “Ən da tagaan kǝ ǝlbǝg dǝ uudahah tǝdvad uudahi taa ghai dǝ ghaiyi kwa sǝrva biya, ard tǝvad ghulaba ghaiya, bakǝvakwaha ar da cinngwana biya, am Yaazhigǝla.” ");
INSERT INTO glwl_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","Taa ghai dǝ ghaiyi kwa sǝrva bi dǝga sǝrǝg kǝ lii ar maay gatǝg biya, dǝga sǝrǝg bi yaa kǝ dadda gatǝg biya. Taa tlayanngǝr dǝga lii fadǝghǝra, mbakyarvad lii maay dǝ fadǝghǝr biya. ");
INSERT INTO glwl_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","Mbakyarvad kwaha, akwama dzaharvǝtdzahǝg yaa dadda gatǝg baɗǝmma, ma kwaratǝr taa ǝlbǝg dǝ ghai kwa sǝrva biya, kaa sagaw kǝ uudahi kwar sǝrga bi kǝ dǝgiti ar tag nǝ iitǝr biya, bi dǝgǝm lii maay gatǝg damma iitǝr biya, mbats, ar maay tagaan taaki namalnǝg kǝ valagah biya? ");
INSERT INTO glwl_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","Akwama taaki baɗǝmmaru am taa tlayanngǝra, ma tlakuraatlǝg daddakwa maay gatǝg ard kwa sǝrga bi kǝ dǝgiti tagavǝn biya, kaa tapnatapǝg nǝ ǝlbǝgahaan kǝ ǝrviɗmahuɗana, kaa pǝlla ghǝr kǝ iina. ");
INSERT INTO glwl_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","Da marazha sagal nǝ dǝgiti ma ǝrviɗmahuɗaana, tǝdvad kwaha da mbǝɗa damma haay ɓagarnǝs kwatǝnahǝr kǝ Daadamazhigǝla, kaa taakiya, “Bak jiijiira mǝng nǝ Daadamazhigǝl ma kuurama.” ");
INSERT INTO glwl_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","Wan dǝgiti ǝn tlatlǝg nai zaraabaha, akwama dzahamvǝtdzahǝg kǝ ɓa kwatǝnahǝra, kwana ɓǝla ǝnngsa gala Daadamazhigǝla, kwana tsaga dǝgita, kwana taa dǝgitaha, kwana taa ǝlbǝg dǝ ghai kwa sǝrva biya, kwana gwiya ghaiya. Bagamɓag kwanahaan baɗǝm mbakyarvad fǝtǝra kǝ ndzǝɗ kǝ yaa dadda gatǝga. ");
INSERT INTO glwl_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Akwama mǝnng lii da taa ǝlbǝg dǝ ghai kwa sǝrva biya, aa juubi kǝ uud buwa bi hǝkǝrɗ biya, aa tagartag ba dǝ aa pallapalla, kwatlǝrn dlaɓa gwiya dǝgiti tagava. ");
INSERT INTO glwl_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Akwama maay daddakwa sǝrgasǝrǝg kǝ gwigan biya, aa ndzarandzǝg ba ɗǝw ma dzahava yaa dadda gatǝga. Aa tagara ba kǝ ghǝraan kǝ ǝlbǝg ard Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","Lii taa tlayanngǝra, aa tagartag ba nǝ uud bu bi hǝkǝrɗ kǝ ǝlbǝga. Kyalmaha aa tsǝgwartsǝgw kǝ hyimi tǝ dǝgiti tagava. ");
INSERT INTO glwl_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","Akwama taghartag Daadmazhigǝl kǝ ǝlbǝg kǝ uudani cihurga vakwahiina, ba ghacan daddakwa fǝgarzha kǝ taa ghaina. ");
INSERT INTO glwl_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","Baɗǝmmaru am tagatag kǝ tlayanngǝr ba dǝ aa pallapalla, kiyava tsagaan kǝ uudaha, dlaɓa ar fǝtǝra kǝ ndzǝɗa. ");
INSERT INTO glwl_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Sǝramasǝrǝg taakiya, lii taa tlayanngǝr ar sǝrgasǝrǝg kǝ dagal dǝ shiɗkwatǝra. ");
INSERT INTO glwl_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","Aɗaba Daadamazhigǝla miyam Daadamazhigǝli kǝɗǝg ghǝraan biya, Daadamazhigǝla gabǝrra. Bandkwah ma dzahava yaa dadda gatǝg baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","Aa ndzarandzǝg nǝ ǝnghwasah ba ɗǝw ma dzahava yaa dadda gatǝga, aɗaba ɓǝlavtǝrna bi taa ghai biya, aa gatargatǝg kǝ dǝgiti taga nǝ adzahadzaha Muusa. ");
INSERT INTO glwl_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","Akwama mǝnng dǝgiti ar naa sǝrga nǝ iitǝra, aa ndavarndavǝg vak zaalahaatǝr hǝnnyaha. Aɗaba dǝga zhǝru kǝ ǝnghwasah taa ghai ma yaa dadda gatǝga. ");
INSERT INTO glwl_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","Fǝgharzha ba tǝ kuram nǝ ǝlbǝga Daadamazhigǝla? Nii ba kuram ha wa dal nǝ ǝlbǝgiin da vakaruwi? ");
INSERT INTO glwl_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","Akwama mǝnng nǝ daddakwa tlatla taaki tlayanng nǝ iina, bi dǝ vǝlga shǝɗkwa, aa nǝghaakanǝghǝg taakiya, dǝgitahaan ǝn vindkur nai na adzahadzaha Yaazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","Akwama lawalǝg nǝ uudan kǝ fa hyimi tǝ kwanna, ghǝravan ndakwani aa fav bi hyimi tǝ vakai biya. ");
INSERT INTO glwl_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","Mbakyarvad kwah zaraabahara, nahamnahǝg kǝ taa tlayanngǝra, tsamarǝv bi dlaɓ kǝ uud kǝ taa ghai dǝ ghai kwa sǝrva biya. ");
INSERT INTO glwl_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","Aanji kwar kǝ dǝgit aa ɓagavɓag ba tǝ ɗuulan ba kalkala. ");
INSERT INTO glwl_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","Ndakwan ci zaraabahara, ǝn naagaan ǝn dzamkurnǝs kǝ ǝlbǝg marawǝn kwa tagankur naiyina, kwa dlǝghama nǝ uuramna, dlaɓa kwa famdǝghǝrǝt nǝ uuram tǝ vakaiya. ");
INSERT INTO glwl_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","Tlamkǝna tǝdvad ǝlbǝg marawǝn nǝ uuram kǝ katǝga, ma ba hǝkyamnahǝkyǝg kǝ ǝlbǝgǝn tagankur naiyin ba marawa. Akwama ma maay ndǝkwah biya, fadghǝraruwa ba gyaagyaana. ");
INSERT INTO glwl_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","Dǝgiti dlǝghana naiya, iin wa vǝlankur naiya, kwa maraw ba vaivaiya, iin taakiya, ǝmtsaǝmtsǝg Kǝristi mbakyarvad haipahaamiyama, band kwa vindavindan ma Kakkaɗa Daadamazhigǝla, ");
INSERT INTO glwl_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","taakiya hǝɗavǝnahǝɗǝga, dlaɓa ciyavantcig tǝ hǝnnga hǝkǝrɗa, bandkwa vindavindan ma Kakkaɗa Daadamazhigǝla, ");
INSERT INTO glwl_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","tsugwatsugw vak Kefasa, ard kǝlaawa tar buwǝna. ");
INSERT INTO glwl_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","Tǝhalakwah kaa ba tsugwatsugw kǝ iin vak kǝ uudah dǝrmǝk dlǝɓ dǝ ghǝr ba daval palla, kyalmahaatǝr ar ba dlaɓ ba dǝ shifǝga, kyalmah dlaɓ ǝmtsaharaǝmtsahǝga. ");
INSERT INTO glwl_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","Kaa tsugwatsugw vak Yakuba, ard zarhaɓǝlga Yesu baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","Tǝhala kwanahaan baɗǝmma, kaa ba tsugwatsugw kǝ iin vakara, aanji ba ǝn zǝra ghǝrdlǝga. ");
INSERT INTO glwl_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","Aɗaba kai wa hǝɗikǝn ma zarhaɓǝlga Yesu, maa dlaikwa bi ɗaa kai kǝ uud dǝ zǝrɓǝlga Yesu biya, aɗaba kai wa vǝlantǝr dlaɗ kǝ yaa dadda gata Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","Amma mbakyarvad hɛrǝrra Daadamazhigǝl wa nanal nai ǝndkwana, dlaɓa hɛrǝrrǝn ɓagghwi nǝ iin na gyagyaan biya, aɗaba januujig aanji kwar kǝ zǝrɓǝlgaha Yesu dǝ tlǝrra, bakǝvakwah kai bi wa ɓaganɓag biya, herǝrra Daadamazhǝgǝl kwa ǝmtaɗ dǝ kaiya. ");
INSERT INTO glwl_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","Aiciya, bi kaiya, bi iitǝra, baɗǝmmamnd kǝm taa ba ǝlbǝg marawa, kwan kǝ ǝlbǝg wa famghǝrǝt nǝ uuram tǝ vakaiya. ");
INSERT INTO glwl_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","Akwama ba tagav taaki ciyiitciig Kǝristi ma gǝtlaha, aujilbǝg ka cii kǝ kyalmaru ar taakiya maay ciig ma gǝtlah biyi? ");
INSERT INTO glwl_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","Akwama ba maay ciig ma gǝtlah biya, mbats ciyiit bi Kǝristi ma gǝtlah biya. ");
INSERT INTO glwl_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","Akwama ba ciyiit bi Kǝristi ma gǝtlah biya, mbats taa ǝlbǝg marawamnda ba gyagyaana, fadghǝraru dlaɓa nalnǝg ba gyagyaana. ");
INSERT INTO glwl_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","Nalnǝg taaki, tagamndatag kǝ fiid tǝghǝr kǝ Daadamazhigǝla, aɗaba tagamndatag kǝ ǝlbǝg tǝghǝr kǝ Daadamazhigǝl taakiya cighantciig kǝ Kǝristi, akwama ba cighant biya, bak jiijiir maay ciig ma gǝtlah biya. ");
INSERT INTO glwl_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","Akwama maay ciig ma gǝtlah biya, mbats Kǝristi ndakwani ciyavant bi ma gǝtlah biya. ");
INSERT INTO glwl_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","Akwama ba ciyavant bi Kǝristi biya, mbats fadǝghǝraru ba gyaagyaana, bakǝvakwan am ba ndzǝgaan ba ma haipaharuwa. ");
INSERT INTO glwl_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","Mbats lii ǝmtsahara ma Kǝristi zaharazahǝga. ");
INSERT INTO glwl_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","Akwama fantaara miyam ma Kǝristi ba kwakyarvad ndzǝgan kaltiya, mbats jiyamujig aanji ba war kǝ dǝga zhuwadaala. ");
INSERT INTO glwl_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","Bak jiijiira, ciyavantcig Kǝristi ma gǝtlaha. Iin nǝ dǝga zunngw kǝ ciig ma gǝtlaha. Ba pakkat maradamarǝg wan taakiya lii ǝmtsaharaǝmtsahǝg ar da ciiga. ");
INSERT INTO glwl_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Sǝghǝv tǝdvad uud tsaw nǝ ǝmtsǝga, bandkwah dlaɓ ciig ma gǝtlah sǝghǝv tǝdvad uuda. ");
INSERT INTO glwl_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","Bandkwa ǝmtsǝg nǝ uud baɗǝm mbakyarvad Adamu, da ciiyav dlaɓ nǝ uud baɗǝm mbakyarvad Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","Ma ba war da ciiyav ba kǝ aɗab kǝ aɗaba, Kǝristi dǝga zuungwa, tǝhalakwaha da ciiyav nǝ uudahaan dǝ shifǝg daghuvali da saay nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","Kaa da sagaw kǝ halavuwa, da tsǝtǝrdatsǝg nǝ Kǝristi kǝ lii kwarǝga, ard kwarǝga, ard ndzǝɗ baɗǝmma, tǝhalakwaha da gwiyarda kǝ tlǝksǝraan baɗǝm kǝ Daadamazhigǝl Daada. ");
INSERT INTO glwl_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","Aɗaba barari kǝ Kǝristi da ɓagaan kǝ kwarǝga, bamma fatǝrɗǝmfǝg kǝ tlǝghumahaan baɗǝm da ma izhangyil kǝ shigahaana. ");
INSERT INTO glwl_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","Tlǝghumi kwa da ghyǝhav tǝhala, iin nǝ ǝmtsǝga. ");
INSERT INTO glwl_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","Aɗaba tagaatag nǝ ǝlbǝga Daadamazhigǝl taaki, “Fadǝmfǝg Daadamazhigǝl kǝ dǝgitah baɗǝm ma izhagyil kǝ kwarǝgaana.” Kwa taga nǝ iin taaki, “Baɗǝm dǝgitah” fadǝmfǝg ma izhangyil kǝ kwarǝgaana, kwan ba tǝ ɓalaɓal taakiya, maay Daadamazhigǝl kata ghǝraan mavakai biya. Daadamazhigǝl wa fadǝm dǝgitah baɗǝm ma izhangyil kǝ Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","Akwama da fadǝmfǝg Daadamazhigǝl kǝ dǝgitah baɗǝm da ma izhagyǝl kwarǝga Kǝristi, tǝhalakwah da ndzan zǝrin damma izhangyil kǝ Daadamazhigǝl kwa fadǝm dǝgitah baɗǝm da ma izhagyil kǝ iina, aɗaba Daadamazhigǝl dǝgit baɗǝm baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","Akwama maay ǝndkwah biya, au wa da ɓag nǝ uudahaana, kwa ɓagavtǝra tsufǝg ma gufka lii ruwararugi? Akwama ba maay ciig ma gǝtlah biya, aujilbǝg ka cii ɓagavtǝra tsufǝg kǝ uudah ma gufka lii ruwararugi? ");
INSERT INTO glwl_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","Aujilbǝg ci kǝskǝmiyam vǝla shifǝgamiyam ba kǝlaa hǝnngi? ");
INSERT INTO glwl_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","Ən nǝghǝganǝghǝg kǝ ǝmtsǝg ba kǝlaa hǝnng zaraabahara, bak jiijiira ǝn tsa ghǝr tǝ kuram ma Kǝrsti Yesu Yaazhigǝlamiyama. ");
INSERT INTO glwl_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","Akawama ɓagamndkǝvaɓag dǝ dǝgtǝghalah ma Afisa, ma tǝ tlatlǝga uuda, au ci paiɗaan vakari? Akwama ba da maay nǝ uud ciig ma gǝtlah biya. “Ba kiyam zǝgaan kiyam hǝɓǝgaana, kiyam da ǝmtsǝg tsaw dlakadur biya?” ");
INSERT INTO glwl_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","Aa valkurda bi nǝ uud biya, “Aɗaba ndzǝgan dǝ kǝlaadah badzǝgaan kǝ hǝnkala jiijiira.” ");
INSERT INTO glwl_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","Asamasaas da tǝ ɗuula dzamaghǝr kalkala, am ɗuuwars kǝ ɓa haipa. Aɗaba kyalmaharu ar sǝrga bi kǝ Daadamazhigǝl biya. Ən tag kwakyarvad ǝn tsǝkura kǝ zhǝruwa. ");
INSERT INTO glwl_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","Ar da ndavǝgan kyalmah taakiya, “Da ciig ndar lii ǝmtsaharamǝmtsahǝgi? Ar da sagal dǝ hulfa kwar kǝ vǝghi?” ");
INSERT INTO glwl_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","Kǝgh dlagǝna! dǝgiti aghaa riiga nǝnng da maay sagal biya bamma ǝmtsaǝmtsǝga. ");
INSERT INTO glwl_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","Dǝgiti agha riiga nǝnnga, gyigyiya iin bi wa da sagal biya, ba hulf kaltiya, bi hulfa hiiya, bi hulfa dǝgiti tlǝrn shaha. ");
INSERT INTO glwl_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","Ba Daadamazhigǝl wa vǝlga vǝgh kǝ hulfiin band kwa naag nǝ iina, ma kwar kǝ hulfa dǝgit ba dǝ vǝghaana. ");
INSERT INTO glwl_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","Ɗǝm bi tlu ar dǝgit pall biya. Uudah ard hulfa dǝgaatǝra, almanaha ard hulfa dǝgaatǝra, ɗiikaha ard hulfa dǝgaatǝra. Kilfah dlaɓa ard hulfa dǝgaatǝra. ");
INSERT INTO glwl_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","Mǝnng hulfa vǝrɗiga ghǝrazhigǝla, mǝnng dlaɓ hulfa dǝga kwa ma haaya. Ndanngǝra dǝga ghǝrazhigǝl shaha, ndanngǝra hulfa dǝga haay dlaɓa shaha. ");
INSERT INTO glwl_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","Ndanngǝra faciya shaha, dǝga kyila shaha, dǝga kwadladlah dlaɓa shaha, mǝnng dlaɓ kwatlǝrǝn kǝ kwadladl shah dǝ kwatlǝrǝn kǝ kwadladl vaka ndanngǝra. ");
INSERT INTO glwl_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","Bandkwah dlaɓ tǝghǝr kǝ ciig ma gǝtlaha, dǝgiti aa riiva dǝ riiga da ǝrtsǝga, dǝgiti aa ciivantciig dlaɓ da maay ǝrtsǝg biya. ");
INSERT INTO glwl_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","Riivariig nǝ iin ma neniga, ciiyavantciig dlaɓ ma ndanngǝra. Riivariig ma maira ndzǝɗa, ciivantciig dlaɓ ma ndzǝɗa. ");
INSERT INTO glwl_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","Riivariig dǝ ndzǝgana vǝgha uudǝra, ciiyavantciig dlaɓ dǝ ndzǝgana vǝgha shiɗkwa. Mǝnng tsaw nǝ vǝgha uudǝra, ba jiijiira mǝnng nǝ vǝgha shiɗkwa. ");
INSERT INTO glwl_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","Vindavindan bandkwah taakiya, “Adamu nǝ uuda zunngwa, nalnǝg kǝ uud dǝ shifǝga.” Adamu dǝga hal iin shǝɗkw kwa vǝlla shifǝga. ");
INSERT INTO glwl_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","Dǝga shiɗkw bi nǝ dǝga zunngw biya, dǝga tluwa ard avǝz lakwti kǝ dǝga shiɗkwa. ");
INSERT INTO glwl_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","Uuda zunngw ndǝrava dǝ haaya, sal ma haaya. Dǝga bu sahi ma ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","Bandkwa dǝga haay nǝ uuda, ar bandkwah dlaɓ lii ndǝrava dǝ haaya. Lii ar dǝga ghǝrazhigǝla, ar band daddakwa sahii ma ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","Bandkwa kiyam dǝ dzakǝva daddakwa ndǝrava dǝ haay nǝ miyama, kiyam da nǝg dlaɓ kǝ dzakǝva daddakwa sahii ma ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","Dǝgiti ǝn tagkur nai zaraabahara, tluwa ard avǝz gwigu bi kǝ tlǝkǝsǝra ghǝrazhigǝl biya, bandkwah dlaɓ daddakwa da ǝrtsǝg da maay gwiya daddakwa maay ǝrtsǝgǝn biya. ");
INSERT INTO glwl_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","Cinngamcinga, ǝn tagkurtag kǝ dǝgiti shiɓashiɓana! Kiyam da maay ǝmtsǝg ɗǝm biya, amma da mbǝɗav nǝ ndzǝgana miyam baɗǝmma, ");
INSERT INTO glwl_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","Ba daval palla, band kǝbǝciga gyiya, aɗaba da fǝrtav dǝrawa, dlaɓa da ciyav lii ǝmtsaharaǝmtsahǝg dǝ vǝgh hulfa kwa da maay ǝrtsǝg biya, da mbǝɗav nǝ ndzǝgana miyama. ");
INSERT INTO glwl_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Aɗaba barari nǝ vǝghǝn kwa ǝrtsǝgǝna da mbǝɗav nal kwa maay ǝrtsǝg biya, vǝghǝghi kwa da ǝmtsǝga da mbǝɗav nal kwa maay ǝmtsǝg biya. ");
INSERT INTO glwl_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","Tǝhalakwa ma mbǝɗavnambǝɗǝg nǝ vǝghǝn kwa ǝrtsǝgǝn nal kwa maay ǝrtsǝgǝn biya, dlaɓa vǝghǝn kwa dǝga ǝmtsǝgǝn nal kwa maay ǝmtsǝgǝn biya, da righǝg ma sarta kwah nǝ ǝlbǝgǝn vindava ma Kakkaɗa Daadamazhigǝl taakiya, “Ghyihavǝnaghyihǝg nǝ ǝmtsǝga, zavuuzǝg fiir tǝghǝra. ");
INSERT INTO glwl_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","Kǝgh ǝmtsǝga, mǝr za fiiraghi? Kǝgh ǝmtsǝga mǝr nǝ guraghi?” ");
INSERT INTO glwl_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","Gura ǝmtsǝga iin haipa, ndzǝɗa haip iin nǝ adzahadzaha. ");
INSERT INTO glwl_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","Tagiyamartag kǝ uus kǝ Daadamazhigǝl kwa vǝlkiyam fiir tǝdvad Yaazhigǝl Yesu Kǝristi! ");
INSERT INTO glwl_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","Mbakyarvad kwah zaraabahara, ghacamaghacig ba dangala, ba kǝlaa hǝng am ɓagar tlǝr kǝ Kǝristi, aɗaba am sǝran taakiya dlaɗǝn am hǝɓǝg nǝ uuram mbakyarvad Yaazhǝgǝlǝn gyagyaan biya. ");
INSERT INTO glwl_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","Tǝghǝr kǝ ǝlɓǝga mǝltǝru kǝ yaa dadda gatǝga, ɓagamɓag bandkwa taganter nai kǝ yaa dadda gatǝgi ma Galatiya taaki aa ɓagarɓaga. ");
INSERT INTO glwl_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","Aanji kwar kǝ laada, famfǝg kǝ kwaɓ kalkala dǝgiti tlǝkǝna dǝvaan kǝ uudana, pakam bi kǝ sagawar lakwti am dzaha dǝgiti da mǝlvaru kǝ uud biya. ");
INSERT INTO glwl_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","Akwama da tsugwanatsugwa, ǝn da ɓǝltǝrǝt kǝ lii haiyamanthaig nǝ uuram dǝ iitǝra, ǝmtaɗ dǝ wakita mara ghǝra, ar dǝda kǝ dǝgiti dzahamant nǝ uurama. ");
INSERT INTO glwl_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","Akwama dlaikwadlaig kǝskai kǝ dagal ndakwani, bar da pughwkwazhana. ");
INSERT INTO glwl_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","Akwama gwaiyanvagwaig ma Makidoniya, ǝn da dagaw da nǝghǝkuraanǝghǝga, aɗaba ǝn da ghuda dagal dǝ Makidoniya. ");
INSERT INTO glwl_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","Mbatak ǝn da zǝlmazǝlǝmǝg vakaruwa, bi ǝn da zu kǝ viyaks vakaruwa, aɗaba am da mǝlwad ba kǝlaa vakavaki ǝn da dagal naiya. ");
INSERT INTO glwl_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","Naagar bi ǝn ghaca dzuɓ vakaru biya, akwama haighanthaig Yaazhigǝl manaa naagaan manaa zǝlma vakaru ba ngaa . ");
INSERT INTO glwl_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","Ən da ghacig ma Afisa ǝn da pakant kǝ sarta Fentikus. ");
INSERT INTO glwl_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","Aɗaba wurghwantwurg nǝ uud kǝ ɗuul ba bannganng kiyava ɓa tlǝr marawa, aanji ba mǝnng tlǝghumah ba ɗyaka. ");
INSERT INTO glwl_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","Akwama sǝghǝvsǝg Timuti, aa ɓalaɓalǝg ghǝraan vakaruwa, aɗaba iin ndakwi ɓa tlǝra Yaazhigǝl band kwan ɓag naiya. ");
INSERT INTO glwl_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","Mbakyarvad kwaha, aanji war aa nen biya, mǝlamarumǝlǝg dǝ dǝgit akwama da ciyitciig kǝ saasa vakara, aɗaba gukya saasaan ǝmtaɗ dǝ yaa dadda gatǝga. ");
INSERT INTO glwl_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","Əlbǝga zǝraabamiyam Afullusa, ghalanghalǝg ma dǝv da vakaru ǝmtaɗ dǝ kyalma zaraabaha, haighant bi ghǝraan kǝ dagaw ndakwan biya, da dagaw ma da shavǝtshǝga. ");
INSERT INTO glwl_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","Ɓadlamvaɓadlǝg ba marawa, am ghacan tǝ fadǝghǝraru ba vaivaiya, am ɓǝlgaan kǝ magiya am fǝgaan kǝ ndzǝɗa. ");
INSERT INTO glwl_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","Baɗǝm dǝgiti am ɓag nǝ uurama, ɓagamɓag ba dǝ waiyava. ");
INSERT INTO glwl_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","Zaraabahara, am sǝrǝgasǝrǝg taaki Istafanus ard yahaan wa fararzha pǝlaghǝr ba zunngw ma haaya Akaya, vǝlardavǝlǝg kǝ ghǝraatǝr kiyava ɓagtǝr tlǝr kǝ yaa dadda gatǝga. ");
INSERT INTO glwl_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","Ən ghalakuram famtǝraarafǝg kǝ hulfa kwanahaan kǝ uudaha, baz tsaghwaha tlǝra miyama ard dlaɗa miyama. ");
INSERT INTO glwl_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","Cinnganucinng kǝmtakera dǝ sagawa Istafanusa, ard Fartunatus, ard Akaikus, bandgi kuram wa sǝgal sa vakara. ");
INSERT INTO glwl_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","Aɗaba ɓagarwiɓag kǝ dǝgit naag waiyar baz dǝgaruwa. Hulfa kwan kǝ uudah ɓagaɓag kǝ maraw fǝvtǝraarana. ");
INSERT INTO glwl_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","Ar tagkur uus yaa dadda gatǝg kwa ma haaya Asiya. Akila ard Biriskila, ǝmtaɗ dǝ yaa dadda gatǝg kwa dzahav ma vǝgyaatǝra, ar tagkur uus ba vaivai ma ɗaaga Yaazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","Baɗǝm zaraabaha ar tagkur uusa. Tagamtag kǝ uus dǝ bǝrhuga waiyava. ");
INSERT INTO glwl_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","Ba kai Bulus dǝ ghǝrar wa vinda kwan kǝ taa uusa. ");
INSERT INTO glwl_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","Baɗǝm daddakwa maay waiya Yaazhigǝl bi tlafatlafana. Asega, Yaazhigǝla! ");
INSERT INTO glwl_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","Herǝrra Yaazhigǝl Yesu aa ndzandzǝg ǝmtaɗ dǝ kurama. ");
INSERT INTO glwl_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","Waiyavar aa ndzandzǝg ǝmtaɗ dǝ kuram ma Kǝristi Yesu. Amin.");
INSERT INTO glwl_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","Bulus kwa nal kǝ zǝrɓǝlga Kǝristi Yesu dǝ naaga Daadamazhigǝla, ard zǝraabamiyam Timoti, da vak yaa dadda gata Daadmazhigǝl ma Korinti, ǝmtaɗ dǝ uudaha Daadamazhigǝl cacuwanacacuwan baɗǝm ma larda Akaaya. ");
INSERT INTO glwl_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","Herǝrra ard gabǝr vak Daadamazhigǝl Daadamiyam ard Yaazhigǝl Yesu Kǝristi aa ndzarandzǝg ǝmtaɗ dǝ kurama. ");
INSERT INTO glwl_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","Galiyamgalǝg kǝ Daadamazhigǝl Daadamiyama, kwa iin Daada Yaazhigǝl Yesu Kǝristi, Daada kwa dadda zhǝwadaal ba ɗyakɗyaka, Daadamazhigǝl kwa tagkiyam aanji hulfa kwar kǝ dzǝgwagha! ");
INSERT INTO glwl_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","Kǝhyikiyamkǝhyig Daadamazhigǝl kǝ ǝrviɗy ma dlaɗa miyam baɗǝmma, kiyava Kǝhyitǝrkǝhyig kǝskǝmiyam kǝ ǝrviɗy kǝ kyalmah ma dlaɗi ar hǝɓǝg nǝ iitǝra, dǝ kwanǝn kǝ Kǝhya ǝrviɗǝn tlǝyamkǝna nǝ miyam vak Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","Bandkwa kiyam hǝɓǝg nǝ miyam kǝ dlaɗa, hǝɓu bandkwah Kǝristi dǝ ghǝraan kǝ dlaɗa, kiyam da tlǝkǝna tǝdvad Kǝristi kǝ ɗyakǝra kǝhyiga Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","Aanji kiyam hǝɓa dlaɗa, kiyam hǝɓǝg mbakyarvad nal kǝ dǝga kǝhyig ǝrviɗy kǝskuram dlaɓa da fǝkurna kǝ ndzǝɗ ma gata Daadamazhigǝla. Akwama kǝhikiyam ǝrviɗy nǝ uuda, kuram ndakwani tlamkǝnatlǝg kǝ kǝhyiga ǝrviɗy kwam da tlǝkǝna nǝ uuram kǝ ndzǝɗa fa ǝrviɗmahuɗ tǝghǝr kǝ dlaɗ kwa hǝɓǝg ghǝravamnda. ");
INSERT INTO glwl_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","Kǝm maay ɓa ndaundau dǝ kuram aanji ba hǝɗiikǝn biya, aɗaba kǝm sǝrgasǝrǝg taakiya am hǝɓa dlaɗ band kwa kǝm hǝɓǝg nǝmnda, kuram ndakwani am da tlǝkǝnatlǝg kǝ hulfa kǝhya ǝrviɗy kwa ɓagkǝmnd nǝ uuda. ");
INSERT INTO glwl_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","Zaraabahara, kǝm naay taaki am dzan kwal sǝrgasǝrǝgǝr tǝghǝr kǝ hulfa dlaɗǝn hǝɓamndu nǝmnd ma haaya Asiyǝn biya, kwan kǝ dlaɗ ndza juujig kǝ kusǝghamnda, tagamnd bi taakiya kǝmnda ɓagaan kǝ shifǝg biya. ");
INSERT INTO glwl_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","Baz tlatlǝgaan kǝskǝmnd taaki bandgi shariya ǝmtsǝg wa ghudakǝmnda nǝ uuda. Dzǝghaardzǝg wan haik fadǝghǝr kǝskǝmnd tǝ ɓagnaɓagamnda, bamma kiyam fadǝghǝr tǝ Daadamazhigǝla, kwa ciya lii ǝmtsaharaǝmtsahǝga. ");
INSERT INTO glwl_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","Sakǝmndasǝg Daadamazhigǝl sagal ma ǝmtsǝga dlaɗna, famdǝghǝrǝtfǝg taakiya da katkǝmndkatǝga. Kiyam tsaghǝr ba tǝ iin kiyava da gwiya katkiyamkatǝga. ");
INSERT INTO glwl_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","Mǝlamkǝmndumǝlǝg dǝ dzǝgwazhigǝla. Tǝdvad kwah wa da tagar nǝ uudah ba ɗyak kǝ uus kǝ Daadamazhigǝl mbakyarvad kǝmnda, mbakyarvad ɗyakǝra barki kǝmnda tlǝkǝna nǝmnd tǝdvad dzǝgwazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","Kwan wa kǝm tsǝg nǝmnd kǝ kusǝgh tǝvakaiya, ǝn tagdatag kwan ba dǝ ǝrviɗmahuɗ pall taakiya ba jiira. Ma dǝgitahi ɓagamnd nǝmnd ma duuniyǝn baɗǝmma, ɓagamnd ba dǝ jiir ard ǝrviɗmahuɗ pall vak Daadamazhigǝla. Kwana ba jiijiir ma dǝgitahaan ɓagamnda nǝmnd ǝmtaɗ dǝ kurama, ɓagamndaɓag kwan tǝdvad hɛrǝra Daadamazhigǝl tǝdvad dabariya duuni biya. ");
INSERT INTO glwl_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","Kǝm vindkur dǝgiti am da karantǝga karantǝg dlaɓa am nǝghaakana, Bakǝvakwah aanji ba nǝghamaakanǝghǝg hǝɗiikǝn ndakwana, mantlǝg naiya am da nǝghǝgaakanǝghǝg kǝ dǝgitah baɗǝmma, ");
INSERT INTO glwl_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","Aɗaba sartǝn da saay Yaazhǝgǝlamiiyam Yesu, am da tsa kusǝgh dǝ kǝmnda, bandkwa kǝmnda tsa kusǝgh nǝmnd dǝ kuurama. ");
INSERT INTO glwl_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","Mbakyarvad haiyananthaig nai kwana, iin wa nahan nai kǝ sagau da vakaru ba zǝnngwa, aɗaba am tlǝkǝna kǝ bark shig buwa. ");
INSERT INTO glwl_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","Ɓadlanvaɓadlǝg kǝ da vakaruwa, akwaman da dagal dama Makidoniya, ǝn da ghaca dlaɓ vakaruwa akwaman da gwiya saasa, aɗaba ǝn tlaraan kǝ dǝgiti am da mǝlgwad nǝ uuram kiyava langaan kǝskai dama Yahudiya. ");
INSERT INTO glwl_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","Mam tlatlǝg nǝ uuram tsa naa ɓadlǝva ba kwal sǝrgasǝrgar ha kǝskurama? Nii mam tlatlǝg nǝ uuram naa ɓadlǝva dǝ ndzǝgana hǝnkala uuda dǝgshiga, kiyava tagaan kǝskai taaki, “Aana” ǝn gwiiya tagaan dlaɓ taaki “Maaya”? ");
INSERT INTO glwl_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","Bandkwa jiir nǝ ǝlbǝga Daadamazhigǝla, bandkwah dlaɓ nǝ ǝlbǝgǝn kwa tagamdkur nǝmndǝn dǝga taaki “Aana” ard “Maay” biya. ");
INSERT INTO glwl_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","Yesu Kǝristi, Zǝra Daadamazhigǝla, kwa tagarkur nǝ Silas, Timoti ard kai kǝ ǝlbǝg tǝghǝra, ndza maay “Aana” bi “Maay biya” Ma Kǝristi ba kǝlaa hǝnng ba “Aana.” ");
INSERT INTO glwl_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","Aanji ndar ɗyakǝra langyiyah taa Daadamazhigǝla, ar ba “Aaana” Ma Kǝristi. Kiyam tag tǝdvad iin nǝ miyam taaki “Aandz bandkwaha” kiyava ndanngǝra Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","Ba Daadamazhigǝl wa fǝkiyama ghaciga ba dangal ma Kǝristi, baz kǝmnda baz kuurama, ba iin dlaɓ wa kǝsakiyamaakakǝsǝga. ");
INSERT INTO glwl_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","Fǝtfǝg kǝ dǝga sǝrgaan tǝ kǝmiyama, dlaɓa fadǝmfǝg kǝ Shiɗǝkwaan ma ǝrviɗyamiyam mbakyarvad markiyamdada kǝ dǝgiti da ɓag nǝ iin tǝvuukwa. ");
INSERT INTO glwl_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","Ba Daadamazhigǝl shiidara, sǝrǝgasǝrǝg kǝ ǝrviɗyara, kwa gwiya danal bi nai damma Korinti biya, mbakyarvad aa gwiya fankura bi kǝ dlaɗ biya. ");
INSERT INTO glwl_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","Kwakyarvad kǝm naa markura ndzǝɗ tǝghǝr kǝ fadǝghǝraru biya, maaya, kiyam ɓa ba tlǝr ǝmtaɗa, kiyava dlaig kǝskuurama, mbakyarvad am ghacan ba dangal ma fadǝghǝraruwa. ");
INSERT INTO glwl_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","Mbakyarvad kwaha, nguɗanantǝnguɗǝg ma ǝviɗyar taaki ǝn madlabi da vakaru haik badzǝdkurda ǝrviɗy biya. ");
INSERT INTO glwl_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","Aitsa, akwama fankuraafǝg kǝ badza ǝrviɗa, war wada fǝgwa cinnga ǝmtakǝr kǝskai, abi ba daddakwa naa fǝgaraa nai kǝ badza ǝrviɗni? ");
INSERT INTO glwl_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","Iin wa viindankura nai kwah kǝ wakiita, aɗaba nahan bi kǝ da vakaru ǝn da tlǝkǝna kǝ badzǝga ǝrviɗ vak uudahi kwa maa dlaiyatǝr fǝgwa hwaɗagaa, Aɗaba fandǝghǝrǝtfǝg nai taakiya, akwama ǝn da hwaɗaga, baɗǝmmaru ndakwani am da hwaɗaga. ");
INSERT INTO glwl_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","Viindankura mbakyarvad ǝn ma dlaɗa ard badzǝga ǝrviɗmahuɗ ba ɗyakɗyaka, baz kǝla yuwa tuug kǝskai ba vaivaiya, kwakyarvad ǝn fǝkura kǝ badzǝga ǝrviɗmahuɗ biya, aɗaba am sǝran taaki ǝn waikurwaig ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","Akwama badzǝghardabadzǝg nǝ uudan kǝ ǝrviɗ kǝ uudana, aa ɓagwi kǝskai biya, aa ɓagkura kǝskuram baɗǝmma. Ən tag kwakyarvad taakiya ǝn mbǝkurǝs biya. ");
INSERT INTO glwl_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","Ndaigǝn hǝɓu nǝ iin vak ghamaga uudahna, ghyinngaghyinng bandkwaha. ");
INSERT INTO glwl_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","Ndakwan ciya, ɓǝshamarnaaɓǝshiga, am kǝhyarna kǝ ǝrviɗa, haik ɗuugarsɗuug kǝskuram ma badzǝga ǝrviɗ kwa da jiguujig kǝ ndzǝɗaana. ");
INSERT INTO glwl_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","Mbakyarvad kwaha ǝn ghala kuurama, am marardan taakiya am waigaan ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","Na viindkura kwan kǝ wakita mbakyarvad ǝn fǝsha kuurama, aɗaba ǝn sǝran mbatak am da gatǝgaan kǝ ǝlbǝgi tagankur ba kǝlaa hǝnnga. ");
INSERT INTO glwl_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","Baɗǝm daddakwama ɓǝshgarna nǝ uurama, ba kai ndakwani ɓǝshanarnaaɓǝshǝga. Dǝgiti naa ɓǝshna naiya, akwama ba mǝnng dǝgiti ǝnda ɓǝshgarna naiya, ɓǝshǝnnaɓǝshǝg mbakyarvad kuurama, ma barka Kǝristi, ");
INSERT INTO glwl_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","Haik tlǝkǝnatlǝg shatanah kǝ ɗuula valla kǝmiyama, mbakyarvad kiyam sǝrgasǝrg kǝ dǝga kǝlaadǝrahaan ba tǝ ɓalaɓala. ");
INSERT INTO glwl_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","Danal ba nai damma toruwasa da taa ǝlbǝg maraw tǝghǝr kǝ Kǝristi, wurghwantwurǝg dlaɓ Yaazhigǝl kǝ ɗuula ɓa tlǝr vaakwana, ");
INSERT INTO glwl_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","bakǝvakwaha ɓalla bi ghǝrar biya, aɗaba nǝghǝghana bi kǝ zǝraabar Titus vaakwan biya. Tǝhala kwaha kaa ɗuutǝrǝsɗuug kǝskai kǝ uudaha, kaa dagal kǝskai damma Makidoniya. ");
INSERT INTO glwl_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","Aa tagvartag nǝ uus kǝ Daadamazhigǝla, iin wa ba kǝlaa hǝnng vǝlkiyam zaa fiir tǝdvad Kǝristi. Ɓa tlǝr dǝ kǝmiyam kiyava langa ǝlbǝg marawa Kǝristi Aanji takwar band tǝrshan bǝtbǝta kwa pǝshvapǝshǝga. ");
INSERT INTO glwl_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","Aɗaba kiyam band tǝrshǝn bǝtbǝt nǝ miyam kwa vǝlgar nǝ Kǝristi kǝ Daadamazhigǝla, kwa kwazaakwazǝg dama lii katavtǝrǝtkatǝga ard lii tǝ ɗuula ǝmtsǝga. ");
INSERT INTO glwl_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","Kiyava lii tǝ ɗuula ǝmtsǝga, bǝtbǝtna vaka ǝmtsǝga, kwa saa dǝ ǝmtsǝga, kiyava lii tlarkǝnatlǝg kǝ katǝga, bǝtbǝtna iin shifǝga kwa saa dǝ shifǝga. Maay daddakwa dzǝgwantdzugw kǝ ɓa kwan kǝ tlǝr biya. ");
INSERT INTO glwl_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","Aɗaba kǝmnd kǝm band kyalma uudah biya, kwar taa ǝlbǝg marawa Daadamazhigǝl kiyava tlǝkǝna ribaatǝra. Aɗaba aa ɓǝlkǝmdǝt nǝ Daadamazhigǝl kǝskǝmnda, kǝm taa ba jiijiir tǝvuukwana, kwakyarvad kǝm lii ɓa tlǝra Kǝrsiti. ");
INSERT INTO glwl_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","Aitsa, kǝmnda fǝgarzha gwiya dlǝba ghǝramnd ha nǝmnda? Nii kǝm gata wakita shid da vakaruw ha, aanji ma vakaruwa, band kwa ɓag nǝ kyalmah hi? ");
INSERT INTO glwl_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","Abi ba kuuram dǝ ghǝraru nǝ wakiti kwa kǝm dǝvakai nǝmnda, kwa viindava ma ǝrviɗmahuɗamǝnda aɗaba nǝghan aanji ba wara dlaɓa karantana. ");
INSERT INTO glwl_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","Maramdamarg nǝ uuram taaki am wakita Kǝristi nǝ uurama, kwa iin dǝgshiga tlǝramnda. Kwan kǝ wakita viindava dǝ dǝga viindǝg biya, viindava dǝ shǝɗkw cacuwanacacuwana dǝga Daadamazhigǝl kwa dǝ shifǝga. Viindava tǝ fafakǝlema akur biya, viindava ma ǝrviɗmahuɗ uudaha. ");
INSERT INTO glwl_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","Kǝm taa kwana mbakyarvad kǝm dǝ jiir tǝvuukwa Daadamazhigǝl tǝdvad Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","Maay nǝ dǝgiti kwa kǝm da mardamarg taakiya ɓagamnd dǝ sǝrgasǝrgamnd kǝ tlǝriin biya, Sǝrgasǝrgamǝda saal vak Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","Iin wa namndal nǝmnd kǝ lii ɓa tlǝra daala langiya kwa vindava tǝdvad adzahadzah biya, vindava tǝdvad shǝɗǝkwa. Adzahadzahǝn kwa vindavana iin wa saa dǝ ǝmtsǝga, shǝɗǝkwa cacuwana iin wa vǝla shifǝga. ");
INSERT INTO glwl_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","Viindavaviindǝg nǝ adzahadzaha Muus tǝ fafakǝlema akura, dlaɓa ndanngǝra Daadamazhigǝla mararmarg ma sarta kwa vǝlavda nǝ iina. Aanji ba dǝgitǝn ndza mbiig tǝ huɗvǝga Muus da zǝlma biya, kaaa mbiig ba caacan huɗvǝgaan ba vaivaiya pǝletǝrvapilǝg kǝ zarha Israˈilah kǝ vazgaana. Akwama adzahadzahi kwa saa dǝ ǝmtsǝga sǝghǝvsǝg dǝ ndanngǝr ǝndkwana, ");
INSERT INTO glwl_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","Aitsa, da ɓaga ndar kaci ɗyakǝra ndanngǝra kwa dǝga ɓaa tlǝra shǝɗkwa cacuwanacacuwan kǝ ndzǝgani? ");
INSERT INTO glwl_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","Akwama ɓa dǝgiti saa dǝ ǝmtsǝga tlakǝnatlǝg kǝ ndanngǝra, ba jiijiira dǝgiti saa dǝ tlǝkǝkǝna jiira Daadamazhigǝla juujig kǝ iin ba ɗyakɗyaka. ");
INSERT INTO glwl_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","Ba jiijiira, ndanngǝra ǝmghura langiya madla bi dǝ ndanngǝr ndakwan biya, akwama gǝravǝnagǝrǝg dǝ ndanngǝra daala langiya. ");
INSERT INTO glwl_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","Akwama dǝgiti da ghyǝnng nǝ zamanana sǝghǝvsǝg dǝ ndanghǝra, da nǝg ndandar ka cii nǝ dǝgiti kwa da ndzǝg ba tangw dama zǝrazǝri! ");
INSERT INTO glwl_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","Mbakyarvad kiiyam mǝng dǝ hulfa kwan kǝ fantaara, iin wa kiyam mǝng dǝ ndzǝd ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","Kiiyam maay nǝ miiyam band Muus biya, kwa hǝɗgharduu huɗvǝgaan dǝ sǝɗav biya, haik nǝghǝganǝghǝg nǝ uudaha Israilaha kǝ ghyǝnnga ndanngǝr kwa da dagal zamanana. ");
INSERT INTO glwl_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","Aɗaba ghǝraatǝra ba dǝkdǝka, tangw dat hiinanna, mǝnng dǝgiti tsǝtǝrva nǝghǝga jiira akwamar karanta umghura langiya. Tǝhavdabi nǝ sǝɗavǝn ba kǝvakwan biya, aɗaba tǝhǝvdabiya, bamma tǝdvad Tlǝkatǝg kalti lakwti tǝhǝvdatǝhǝga. ");
INSERT INTO glwl_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","Tangw dat hiinanna, akwamaar karanta kakaɗa muusa, kaa hǝɗtǝrduhǝɗǝg nǝ sǝɗavǝn kǝ ǝrvǝdmahuɗaatǝra. ");
INSERT INTO glwl_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","Tǝhvǝdatǝhǝga nǝ sǝɗaviina akwama gwiiyagwiig nǝ uudan da vak Tlǝkatǝga. ");
INSERT INTO glwl_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","Aiciya, Yaazhigǝla iin shǝɗkwa cacuwanacacuwanna. Vakavaki dǝ shǝɗkwa Yaazhigǝla mǝnng kwaraghǝr vakwahiina. ");
INSERT INTO glwl_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","Kǝmiyamǝn hǝɗavarduu bi huɗvǝgamiiyamǝn biya, kiyam mara paraka ndanngǝra Yaazhigǝl band akwatǝrama, dlaɓa gwikiyamantgwiig nǝ uud kiyam nal band Yaazhigǝla. Kwan kǝ gwiya vǝghǝn ɓagakiyama nǝ uudǝna fǝgaraa bad fǝga ma ndanngǝra kwa sal vak Yaazhigǝla, kwa iin shǝɗkw cacuwanacacuwana. ");
INSERT INTO glwl_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","Mbakyarvad kwaha, kiyam mǝnng tsau dǝ kwan kǝ tlǝra kwakyarvad zhǝwadaala Daadamazhigǝla, aa ngadlavbi nǝ ǝrviɗmahuɗamiyam biya. ");
INSERT INTO glwl_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","Maay lambamnd dǝ shǝɓa hulfa dǝga muuniya kwa saa dǝ dǝga tsa zhǝru biya. Maay lambamnd dǝ vala uuda ma taa fiid dǝ ǝlbǝga Daadamazhigǝl biya. Kǝm taa ba jiir nǝmnda bat ɓalaɓala. Da ɓag ǝndkwah nǝ uudah kǝ shiida jiijir kwa ɓagamnda nǝmnd tǝ vuuka Daadamazhigǝl ma ǝrviɗmauɗaana. ");
INSERT INTO glwl_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","Akwama ǝlbǝg marawǝn kwa kǝm tag nǝmnd kǝ ǝlbǝg tǝghǝrǝn shǝɓashǝɓanna, shǝɓashǝɓan bak lii tǝ duula ǝmtsǝga. ");
INSERT INTO glwl_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","Ar lii maay dǝ fadǝghǝr nǝ iitǝr biya, aɗaba shatanaha duniya gulfatǝrǝtgulfǝg kǝ ǝrviɗmahuɗaatǝra. Tsatǝrvatsǝg kǝ nǝghǝga paraka kwa ba caacan tǝghǝr kǝ iitǝra, parakǝn kwa sǝghal ma ǝlbǝg marawa aa ndanngǝra Kǝristi, kwa iin garava Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","Mbakyarvad kǝm taa ǝlbǝg marawa ghǝramnd biya, bamma dǝga Yesu Kǝristi, taakiya iin Yaazhigǝla, kǝm band kwatǝnaharu nǝmnd mbakyarvad Yesu. ");
INSERT INTO glwl_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","Daadamazhǝgǝlǝn kwa tagaa taaki, “Aa ndzadzǝg nǝ parak ba parakrak ma gurtla,” iin wa fafǝg kǝ parakan kwa ba parakrak ma ǝrvǝdmahuɗamiiyamma, kiyava ba parakrak kǝ uudaha mara sǝran kǝ ndanghǝra Daadamazhigǝl tǝvuukwa Tlǝkatǝga. ");
INSERT INTO glwl_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","Bakǝvakwaha, kǝmiyamǝn kiyam dǝ kwan kǝ hyahǝra ma gatǝga, kiyam band dǝfuwa luuwa. Niyamalmǝg band ǝndkwaha, aɗaba marvǝdan taakiya ndzǝɗi kwa juujig baɗǝmma sal vak Daadamazhigǝla, sal vakamnd biya. ");
INSERT INTO glwl_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","Vǝlkǝmnd vǝlǝg nǝ uud kǝ dlaɗ nǝ uud aanji ta kwar kǝ ɗuula, bakǝvakwaha fakǝmnda bi nǝ uud kǝ kuɗǝg dǝ tlǝriin biya. Davalitlǝrna kǝm ɓagan kǝ ndaundauwa, aɗaba gǝndzamdǝt biya. ");
INSERT INTO glwl_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","Vǝlkǝmnd vǝlǝg nǝ uud kǝ mbahǝlla, bakǝvakwaha duuwa kǝmndarsbi nǝ Daadamazhigǝl biya. Daghuvaliitlǝr dlaɓa tsǝkǝmǝndtsǝg nǝ uud dǝ zaada, bakǝvakaha ciiɓakǝmndabi nǝ uudya. ");
INSERT INTO glwl_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","Ba kǝlahǝnga kǝm ba tǝ duula ǝmtsǝga band kwa ɓagavara kǝ Yesu, mbakyarvad marvǝdan nǝ ndzǝgana Yesu tǝ vǝgha miiyam kwa dǝga ǝmtsǝga. ");
INSERT INTO glwl_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","Ma ba kiiyam ndzǝga bad shifǝg ma duniya, kiiyam ba tǝ duula ǝmtsǝg mbakyarvad Yesu, aɗaba nǝghǝvan nǝ ndzǝgana Yesu tǝ vǝghamiiyam kwa dǝga ǝmtsǝga. ");
INSERT INTO glwl_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","Iin wa ba kǝlahǝnga kǝm ba tǝ duula ǝmtsǝga, mbakyarvad am tlǝkǝna nǝ uuram kǝ shifǝga. ");
INSERT INTO glwl_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","Viindaviindan ma kakaɗa Daadamazhigǝl taakiya, “Fandǝghǝrǝtfǝga, mbakyarvad kwaha taganataga.” Aanji ba kiiyam dǝ fadghǝr hulfa dǝgit palla, ba kǝmnd ndakwani famdǝghǝrtfǝga, kǝm tag mbakyarvad kwan nǝmnd kǝ ghaiya. ");
INSERT INTO glwl_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","Kǝm sǝrgasǝrg taakiya Daadamazhigǝl kwa ciighant Yaazhigǝl Yesu ma gǝtlaha, da ciikiyamciig ǝmtaɗ dǝ Yesu, da sǝkiiyamnda da tǝvuukwana baz kǝ uurama. ");
INSERT INTO glwl_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","Baɗǝm wana mbakyarvad da mǝlkuru kǝskuurama, aɗaba herrǝra Daadamazhigǝla da fǝgarabadfǝg da tǝghǝr kǝ uudaha ba ɗyakka, da nǝg kǝ dǝgshiga gwiya fǝgara taa uus kǝ uudah kǝ Daadamazhigǝla, kiyava vǝlva ndanngǝra. ");
INSERT INTO glwl_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","Mbakyarvad kwaha gǝdzamdǝt biya, aanji ba vǝghamnda dǝga uuda duniya da badzǝga, bakǝvakwaha kǝm nǝg bak daal ma gatǝg ba kǝlahǝnga. ");
INSERT INTO glwl_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","Aɗaba kwan kǝ zǝr dlaɗǝn kǝm hǝɓǝg nǝmnda da zǝlmabiya, kǝm da tlǝkǝnatlǝg kǝ ndanngǝr ba ɗyakka, kwa juujig kǝ taga, da ndzǝg ba tangw damma zǝrazǝra. ");
INSERT INTO glwl_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","Kwakyarvad dǝgitahi zharǝg nǝ gyiya wa kǝm fǝg nǝmnd kǝ taaɗ tǝ vakai biya, bamma dǝgitahi kwa nǝghvabiya. Aɗaba dǝgitahi kwa nǝghǝvanǝghǝga da zǝlmabi nǝ zamanan kǝ dagal biya, dǝgitahi kwa nǝghǝvabiya dǝga tangw damma zǝrazǝra. ");
INSERT INTO glwl_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","Sǝryamasǝrg taakiya akwama dlagavnadlag tsakwamǝn kwa kiyam ndzǝga nǝ miyam ma vakaina, kwa iin vǝghǝghamiyama dǝga kwan kǝ duuniya, ɓagakiymaɓag Daadamazhigǝl bad ghǝraan kǝ hǝnnyah ma ghǝrazhigǝla. Kwan kǝ hǝnnyaha ndǝra nǝ uud biya, da ndzǝg nǝ iin ba tangw damma zǝrazǝra. ");
INSERT INTO glwl_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","Ndakwana, kiiyam fǝgaan kǝ ǝrvǝdmahuɗa, kiiyam hwaɗag ba vaivaiya kiiyam da tlǝkǝna kǝ sǝɗav da tǝ vǝgha ma ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","Akwama da vǝlyakiiyam vǝlǝg nǝ uud kǝ sǝɗava, da tlǝkiiyamabi nǝ uud dǝ suuh biya. ");
INSERT INTO glwl_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","Ma sarta kwa kiiyam ndzǝgan nǝ miiyam dǝ vǝgha kwan kǝ duniya, kiiyam ngiiga mbakyarvad dlaɗa kwa kiiyam huɓǝg nǝ miiyama. Kwakyarvad kiiyam na tagguva dǝ vǝgha kwan kǝ duni biya, ma naaga miiyama ma kiiyama tlǝkǝna kǝ sǝɗav kwa dǝga ghǝrazhigǝla, aɗaba dǝgit dǝ shifǝga tangw dama zǝrzzǝrra gwiighantgwiig kǝ dǝga ǝmtsǝga baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","Ba Daadamazhigǝl dǝ ghǝraan wa ɓadlǝghani kwan kǝ gwiiya vǝgha, vǝlakiiyamvǝlǝg dlaɓ kǝ shǝdkwan kiyava markiiyamndan kǝ dǝgiti da ɓagkiiyam nǝ iin tǝvuukwa. ");
INSERT INTO glwl_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","Mbakyarvad kwaha iin wa bakǝlahǝng kiiyam tsa ǝrvǝdmahuɗa miiyama, kiiyam sǝrgasǝrg dlaɓ taakiya akwama ba kiiyam dǝ vǝgha kwan kǝ duniya, kiiyam ba bǝkyǝ dǝ hǝnyaha miiyam kwa ǝmtaɗ dǝ Yaazhǝgǝla. ");
INSERT INTO glwl_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","Aɗaba kiiyam ndzǝgan ma fadghǝra, dǝga nǝgha gyi biya. ");
INSERT INTO glwl_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","Bak jiijira ghacamnda ghacig tsau ba tankara, maa tǝ naagamnda makǝma tagguva dǝ kwan kǝ vǝgha, kǝm ndzan ǝmtaɗ dǝ Yaazhǝgǝl ma ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","Mbakyarvad kwaha, aanji kǝm ma kwan kǝ duniya aanji kǝm maghǝrazhǝgǝla ma tǝ naagamnd ma ciingu kǝ ǝmtakǝramnda. ");
INSERT INTO glwl_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","Aɗaba barari kǝskǝmiyam kiyam ghachan tǝvuukwa Kǝristi baɗǝmma, kiyava tǝkiyama kǝ shariya. Ma bawara da cawa dǝgshiga tlǝraani ɓagaa nǝ iin dǝ vǝgha kwan kǝ duniya, aanji marawa aanji marau biya. ");
INSERT INTO glwl_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","Kiiyam sǝrgasǝrg tsau kǝ dǝgiti tagav dǝ gǝdza Daadamazhigǝla, iin wa kǝm ɓa kǝlaa ndzǝɗamnda ma kǝma sǝdaa kǝ kyalmaha. Sǝrgasǝrǝg Daadamazhigǝl kǝ ndzǝgana miiyan baɗǝmma, mandlǝg naiya am sǝrgasǝrǝg kǝ kwan ma ǝrviɗmahuɗaruwa. ");
INSERT INTO glwl_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","Kwakyarvad kǝm dlǝba ghǝramnd tǝvuukwaru biya, kǝm ɓa kǝla ndzǝɗamnda kǝm tagkur kǝ ɗuuli am da cinngu nǝ uuram kǝ ǝmtakǝramnd ba vaivaiya, kiyava ngutǝrangug kǝskuuram kǝ lii naa ghǝraatǝr mbakyravad ar uudah ɗyakɗyaka, dlakulva hǝnkalaatǝra. ");
INSERT INTO glwl_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","Kǝm valaagah nǝmnd bandkwa tag kyalmaha? Aanji kǝm ba valaaga, kǝm valaag mbakyarvad ndanngǝra Daadamazhigǝla. Akwama kǝm valaag bi nǝmnd biya, ba kwa vakaru ci waha. ");
INSERT INTO glwl_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","Baɗǝm dǝgiti ɓagamnda nǝmnda, ɓagamnd kiyava tlǝkǝna dǝgshig kǝ ghǝramnd biya, ɓagamnd mbakyarvad waiyakǝva Kǝristi kwa ɓa tlǝr dǝ kǝmnda. Fǝyamdǝghǝrǝtfǝg tsau taakiya ǝmtsaǝmtsǝg Kǝristi mbakyarvad uudah baɗǝmma, mbakyarvad kwaha baɗǝm ǝmtsaharaǝmtsahǝg ǝmtaɗ dǝ iina. ");
INSERT INTO glwl_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","Əmtsaǝmtsǝg nǝ iin mbakyarvad uudah baɗǝmma, aɗaba haik ɓa dǝgiti naag ghǝraatǝr kǝ lii dǝ shifǝga, bamma ar ɓa ndzǝgan mbakyarvad daddakwa ǝmtsa kwakyarvad iitǝra, ciyavantciig dlaɓ mbakyarvad iitǝra. ");
INSERT INTO glwl_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","Mbakyarvad kwaha kǝm madla bi zhara ndzǝgana uud dǝ hǝnkala duni biya, aanji ba tapamndǝnatapǝg kǝ dzamaghǝr tǝghǝr kǝ ndzǝgana Kǝrsiti band ndzǝgana uudǝra, ndakwana kǝm madla bi ndzamgan ǝndkwah biya. ");
INSERT INTO glwl_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","Mbakyarvad kwaha akwama nzdǝgan ma Kǝristi nǝ uudana, nalnǝg kǝ daala vǝrɗǝga, baɗǝm nǝ ǝnghura dǝgitaha dal zamanana, aanji ba auwa, nalnǝg kǝ daala. ");
INSERT INTO glwl_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","Baɗǝm wana ba vak Daadamazhigǝla, kwa ɓadlǝghana ndzǝgana taataka miyam ǝmtaɗ dǝ iin tǝdvad Kǝristi, vǝlakǝmǝndvǝlǝg dlaɓ kǝ tlǝra ɓadla ndzǝgana taataka uudah dǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","Əlbǝgamnda iin taakiya ɓadlǝghanaɓadlǝg Daadamazhigǝl kǝ ndzǝgana taataka uuda dǝgshiga ard iin tǝdvad Kǝristi, maay dlaɓ kǝdla haipahaatǝr tǝghǝr kǝ iitǝr biya. Vǝlakǝmndvǝlǝg Daadamazhigǝl kǝ dǝgshiga ɓa tlǝra ɓadla ndzǝgana uudaha ard iina. ");
INSERT INTO glwl_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","Mbakyarvad kwaha kǝm dlakulva gyiya Kǝristi nǝmnda, bangki ba Daadamazhigǝl dǝ ghǝraan wa taaghai tǝdvad kǝmnda. Ma ɗaaga Kǝristi, kǝm ghala kuurama ɓadlamvaɓadlǝg dǝ Daadamazhigǝla am nal kǝ tsaghwahaana, lii ɓa tlǝghum dǝ iin biya. ");
INSERT INTO glwl_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","Tapghana bi Kǝristi kǝ ɓa haip biya, mbakyarvad kǝmiyama nadalnǝg Daadamazhigǝl kǝ Kǝristi band dadda haipa. Tǝdvad kwan kǝ ɗuul, wa kiyam da tlǝkǝna kǝ jiira ma ɗaaga Kǝristi vak Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","Ma huɗa tlǝri ɓagamnd nǝmnd ǝmtaɗ dǝ Daadamazhigǝla, kǝm ghala kuuramǝn tlamkǝnatlǝg kǝ herǝrra Daadamazhigǝlna, ɗuuwamars bi nal ba gyagyaan biya. ");
INSERT INTO glwl_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","Cinngamcinng kǝ dǝgiti aa taag Daadamazhigǝla, amaa, “Sǝghǝv ba sarta kwa ɓagankur nai kǝ herǝrra, cinngankuranacinnga. Sǝghǝv ba sarta katǝga, mǝlankurumǝlǝga.” Cinngamcinnga! kwan sarta kwam da caaug nǝ uuram kǝ herǝrra Daadamazhigǝla, hiinan faciya katǝga! ");
INSERT INTO glwl_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","Niyamal bi kǝ ɗuula mbǝɗǝg aanji kǝ war biya, aɗaba haik tlǝkǝna ɗuula ghudǝkiyamǝs ǝlbǝg tǝghǝr kǝ tlramiyama. ");
INSERT INTO glwl_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","Dlakulvakwaha, baɗǝm nǝ dǝgiti kiiym ɓag nǝ miiyama, ɓagyamɓaga mbakyarvad kiiyam mardan takiya kiiym lii ɓa tlǝra Daadamazhigǝla. Kiiyam ɓagan dǝ fa ǝrvǝdmahuɗa, ard huɓa dlaɗa, mbahǝlla, ard dlaɗa ndzǝgana. ");
INSERT INTO glwl_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","Kalakǝmndakakalǝg nǝ uuda, ar ɓǝlkǝmdǝm dama guda bǝrfina, dlaɓa ar fakǝmdǝt nǝ uud kǝ vavǝrra ma sarta ciiga hǝnkala, ɓagamndaɓag kǝ tlǝr kwa juujig kǝ ndzǝɗamnda, hǝnamndu bi kǝ haar biya dlaɓa famndu bi kǝ kaff biya. ");
INSERT INTO glwl_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","Tǝdvad hǝnkalamnd kwa cacuwana, ard sǝrgasǝrgamnda, ard fa ǝrviɗmahuɗamnda ard taa jiira, maramndamarǝg taakiya kǝm lii ɓa tlǝra Daadamazhigǝl tǝdvad shǝɗkw cacuwanacacuwana, ard waiyakǝvamnda ba jiijiira, ");
INSERT INTO glwl_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","Ard ǝlbǝgamnda kwa ba jiijiira, ard ndzǝɗa Daadamazhigǝla. Kǝm mǝng dǝ jiira kwa iin wa band dǝgdǝva kwa kiiyam hǝkyǝg nǝ miiyam ma dǝva kaffa ard dǝva ghyǝɓa. ");
INSERT INTO glwl_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","Fakǝmndaarafǝg nǝ uuda, dlaɓa vǝlakǝmndvǝlǝg nǝ uud kǝ dlaɗa, dlǝbakǝmdǝtdlǝbǝg nǝ uuda, dlaɓa bazdakǝmndabadzǝg nǝ uud kǝ ɗaaga. Nakǝmdadalnǝg nǝ uud kǝ lii taa fiida, bakǝvakwaha kǝm taa ba jiir nǝmnda. ");
INSERT INTO glwl_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","Mandki sǝrkǝmnd bi nǝ uud biya, tambar sǝrkǝmndsǝrǝg nǝ uuda ba vaivaiya, Mandki kǝm ba tǝ duula ǝmtsǝga, iin wan kwana kǝm bad shifǝga. Ar vǝlkǝmnd dlaɗa, bakǝvakwaha ciiɓakǝmndabi nǝ uudi, ");
INSERT INTO glwl_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","Ma huɗa dlaɗǝn vǝlakǝmnd nǝ uudna, fakǝmnda ba hwaɗaaga. Aanji ba kǝm maay dǝ dǝgit biya, bakǝvakwaha tlakǝnatlǝg nǝ uudah badyǝk kǝ hyahǝr tǝdvad kǝmnda. Mandki kǝm maay aanji ndau biya, mbats baɗǝm nǝ dǝgita ba dǝgamnda. ");
INSERT INTO glwl_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","Kuuram uudaha Korintiyaha, shǝbamndkurvabi aanji ndauw biya, dlaɓa maramndadamarǝg nǝmnd taakiya kǝm waikurwaiga ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","Au kǝmnd wa duuwamndkurars duuga, abi kuuram wa haiyamantbi dǝ kǝmnd ma ǝrvǝdmahuɗaru biya. ");
INSERT INTO glwl_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","Ən taagkur kwan naiya band kwa taagtǝr nǝ Daad kǝ ǝlbǝg kǝ zarhaana, kuuram ndakwani am markǝmndadan kǝ waiyakǝvaruwa. ");
INSERT INTO glwl_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","Haɗambi kǝ ghǝr dǝ uudahi kwar maay gata Yaazhigǝl biya. Əndzǝgandzǝg nǝ uuda jiirjiir ba lapi dǝ dadda ɓa kǝlaadǝra? Nii auwa dzǝtǝrǝm paraka ard gurtli? ");
INSERT INTO glwl_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","Tsaghwa shatanah nǝ Kǝristiya? Nii auwa dzǝtǝrǝm lii gata Yesu ard lii maay gata Yesu biyi? ");
INSERT INTO glwl_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","Auwa dzǝtǝrǝm vǝgya Daadamazhigǝla ard hǝnnyaha ɓa ghǝlli? Kǝm vǝgya Daadamazhigǝl nǝmd kwa dǝ shifǝga. Band kwa tagaa Daadamazhigǝl taaki, “Ən da ndzǝgan ǝmtaɗ dǝ iitǝra, ǝn gwaiva ma iitǝra. Ən nal dlaɓa kǝ Daadamazhigǝlatǝrra, ar nal dlaɓ nǝ iitǝr kǝ uudahara. ");
INSERT INTO glwl_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","Mbakyarvad kwaha asamasagal ma lii ar maay gata Yesu biya, wahamzhawahǝg kǝ ghǝraru dǝ iitǝra, am nǝ Yaazhǝgǝla. Haɗambi kǝ ghǝraru dǝgiti kwa maay cacuwana cacuwan biya, ǝn da haikurǝt tǝdvad kwan naiya am nǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","Ən da nǝg kǝ Daadaruwa, kuuram dlaɓ am nal kǝ zarhahar ghwalvaha ard ǝnghwasaha. Am nǝ Yaazhǝgǝl kwad ndzǝɗ baɗǝmma.” ");
INSERT INTO glwl_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","Takiyamatǝg tsaw nǝ uud kǝ langyiya dǝgitahaan baɗǝm zaraabahara, mbakyarvad kwah aandz ba cuwaɗaɗ vǝghamiyam ard ǝrviɗamiyam haik ɓa haip kǝskǝmiyama. Kiyam nal dlaɓ ba cacuwanacacuwana ma gǝdza Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","Haiyamanthaig dǝ kǝmnd ma ǝrviɗaruwa. Ɓagamndarabi kǝ haip aanji kǝ war biya, badzamdardabi dlaɓ kǝ ǝrvidmahuɗ aanji kǝ war biya, dlaɓa zamndubi aanji dǝga war biya. ");
INSERT INTO glwl_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","Naa fǝkura haip nai kwakyarvad na tagda kwah biya, bandkwa tagankurda nai taakiya, ma tǝ ǝmtsǝga bi shiifǝg kiyam ǝmtaɗ dǝ kurama. ");
INSERT INTO glwl_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","Haiyankurǝthaig ba vaivaiy dǝ kurama, ǝn tsǝgaan kǝ kusǝgh dlaɓ dǝ kuurama. Ərviɗar ba panahnah ba vaivaiya. Aanji ba kǝm hǝɓa dlaɗa, ǝrviɗar ba parakka. ");
INSERT INTO glwl_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","Aanji ba sarti damdaghan nǝmnd damma haaya Makidoniya, diiyamndubi kǝ kuɗǝgg biya. Aanji kǝm takwara ba dlaɗa, tǝ ɓalaɓala ndakwani pǝkya ghaiyamnd nǝ uuda, ma huɗa kǝssa gǝgzǝtgǝdzǝg nǝ ǝrvǝdmahuɗamnda. ");
INSERT INTO glwl_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","Daadamazhǝgǝli kwa fǝgara ndzǝɗ kǝ daddakwa gǝdzǝga, fakǝmndafǝg kǝ nzdǝɗ dǝ sagauwa Titusa. ");
INSERT INTO glwl_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","Kwakyarvad sagauwa Titus kalti bi wa fakǝmnda hwaɗag biya, ǝlbǝgahi tagakǝmnd nǝ iin kǝ duula kwa famarna nǝ uuram kǝ ndzǝɗa. Tagakǝmndtag dlaɓ kǝ ɗuuli am na nǝghǝkwa nǝ uurama ba vaivaiya, ard ɗuuli badzamdadda nǝ uuram tǝghǝr kǝ dǝgiti dzǝghardzǝga, ard kwa ɓagam nǝ uuram kǝ kǝla ndzǝɗaru kǝ tlahǝgus ǝlga. Kwan wa fǝghwa kǝ cinnga ǝmtakǝr ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","Aanji ba badzakurdabadzǝg nǝ wakiitar kǝ ǝrvǝdmahuɗa, njikwa biya. Ndza badzanda badzǝg kǝ ǝrvǝdmahuɗa ma sartakwa ndza wura aɗaba sǝranasǝrǝg taaki ndza tapghant tapǝg nǝ wakiitar kǝ ǝrvǝdmahuɗaruwa, aanji ba dǝga sart ǝnkyǝkwaha. ");
INSERT INTO glwl_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","Ndakwana ǝn hwaɗaaga, aanji ba cǝnnganubi kǝmtakǝra kwa badzankurdanai kǝ ǝrvǝdmahuɗ biya, aɗaba badzǝga ǝrvǝdmahuɗaru wa fakura pǝlla ghǝra am ɓadlǝna kǝ hǝnkalaruwa. Badzǝga ǝrvǝdmahuɗaruwa hulfa kwa naag nǝ Daadamazhigǝla, mbakyarvad kwaha ɓagamndkurabi kǝ haip tǝghǝr kǝ dǝgiti ɓagamndkura nǝmnd biya. ");
INSERT INTO glwl_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","Aɗaba badzǝga ǝrvidmahuɗi kwa hulfa dǝga Daadamazhigǝla wa fǝgaraa pǝlaghǝr kǝ uuda, gwiiyan davak Daadamazhigǝla, da tlǝkǝna ǝndkwah kǝ katǝga. Dlaɓa maay taaki “ma sǝranasǝrg” mavakai biya. Aɗaba badzǝga ǝrvidmahuɗi sǝgarda nǝ uudan kǝ ghǝraana, saa dǝ ǝmtsǝga. ");
INSERT INTO glwl_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","Zharamzharǝg kǝ dǝgiti aa sǝkurda nǝ badzǝga ǝrvǝdmahuɗ hulfa kwa naag Daadamazhigǝl dama kuurama. Fakuraafǝg kǝ panahnaha ɓagana, ard mara taaki ɓagama bi kǝ dǝgit kalkal biya. Fakuurafǝg kǝ nguɗa ǝrvǝdmahuɗa, dlaɓa gǝdzamǝtgǝdzǝga. Fakurafǝg kǝ ɓa fantara, dlaɓa ɓagamaɓag kǝ tlǝra. Fakurafǝg am ɓadlǝvan da caauwa kiiɓa ndaiga kwa kalkalana. Əlbǝg tǝghǝr kǝ kwan kǝ dǝgita, bak jiijiira aanji tǝ kwar kǝ duula maramdamarg nǝ uuram taakiya am maay dǝ haip biya. ");
INSERT INTO glwl_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","Ma sarta kwa viindananai kǝ kwah kǝ wakita, ndza maay lambar dǝ uudi kwa ɓaga haip biya, aanji ma daddakwa ɓagǝvara nǝ haipa. Dlakulvan wana viindkuranai kiyava markurdan ba da palla pal taaakiya sǝrgasǝrg nǝ Daadamazhigǝl haiyamanthaig dǝ kǝmnda ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","Kwakyarvad kwan wa tlamkǝna nǝmnd kǝ ndzǝɗ ma ǝrvidmahuɗamnda. Maay ba nǝ tlǝkǝna ndzǝɗ ma ǝrvidmahuɗamnd biya, bakǝvakwaha kǝm fǝgara ba hwaɗag ba vaivaiya aɗaba hulfa hwaɗagǝn mavakai nǝ Titus na, mbakyarvad baɗǝmmaruwa mǝlamarumǝlǝg dǝ tlǝkǝna ndzǝɗ ma ǝlbǝgaha. ");
INSERT INTO glwl_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","Aanji ba taganartag nai taakiya ǝn tsa kushǝg dǝ kuurama, da nǝmbi damma zhǝru biya. Band kwa tagamndkurnǝmnd kǝ dǝgitah baɗǝm bak jiijiira, bandkwah dlaɓ tsa kushǝghamnd dǝ kuurama nalnǝg bak jiirjiir tǝvuukwa Titusa. ");
INSERT INTO glwl_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","Waiyakǝvǝn kwa ɓagkur nǝ Titus na, fǝgara bad fǝg ba vaivaiya akwama dzamghanadzamǝg kwa famaara nǝ uuram nǝ uuram baɗǝmma, ard hulf hǝnkali maramarda nǝ uuram ma sarta kwa caawama nǝ uurama. ");
INSERT INTO glwl_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","Ən hwaɗag ndakwana mbakyarvad haiyananthaig dǝ kuurama bak jiijiira. ");
INSERT INTO glwl_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","Ndakwan ci Zaraabaharra, kǝm naagan am sǝran kǝ dǝgiti ɓagaa nǝ herǝrra Daadamazhigǝl ma dlamakǝlaaw lii gatǝga kwar ma Makidoniya. ");
INSERT INTO glwl_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","Aɗaba huɓaruuhuɓǝg kǝ dlaɗ ba vaivai mbakyarvad dlaɗǝn darǝm nǝ iitǝr da mavakaina, bakǝvakwaha dyǝkǝra hwaɗaagatǝra fatǝrafǝg kǝ ɓa tlǝra herǝrra kǝ mǝltǝru kǝ kyalmaha, aanji ar bamma talagǝraatǝra. ");
INSERT INTO glwl_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","Fandǝghǝrtfǝg nai taakiya araa vǝlda ba kalkala ndzǝɗaatǝra juujig kwa nahava. Vǝlardavǝlǝg bad haiga ghǝratǝra, favtǝra dǝ ndzǝɗ biya. ");
INSERT INTO glwl_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","Ghalarkǝmnd ghalǝga ma kǝma vǝltǝr kǝ duula ɓa tlǝra mǝltǝru kǝ uudaha, aɗaba iitǝr ndakwani mara dǝm damma lii mǝltǝru kǝ lii gatǝga kwar ghyǝba Yahuda. ");
INSERT INTO glwl_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","Vǝlardavǝlǝg juujig ba kǝ dǝgiti tlatlamnd nǝmnda. Aɗaba vǝlardavǝlǝg kǝ ghǝratǝr ba ma zungwǝr kǝ Yaazhǝgǝla, ar vǝldan dlaɓ kǝ ghǝraatǝr kǝskǝmnda, band kwa naag nǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","Nǝghamnda ba nǝmnd ǝndkwaha, kaa ghala Titus kǝskǝmnd ma zaavuuk dǝ tlǝra dzaha dǝgitahi ndzahavanta, aɗaba iin wa fǝghazhafǝga. ");
INSERT INTO glwl_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","Aanji bamma kwar kǝ dǝgita, ba kuuram wa tǝvuukwa, aanji tǝ fadǝghǝr ma Kǝrsitiya, aanji ba tǝ taa ǝlbǝga, ma sǝrga dǝga jiijiira, ma tǝ naa ɓa tlǝra, ard waiyakǝvǝri am ɓagkǝmnd nǝ uurama. Mbakyarvad kwaha zamzǝg kǝ vuuk dǝ ɓa tlra vǝlǝg naaga ghǝra. ");
INSERT INTO glwl_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","Na fǝkuraa barari bi nai biya, ǝn markur ɗuuli ɓagar kyalmah kǝ tlǝra mǝlagaru kǝ uudaha. Kwan wa da marda waiyakǝvi am dǝ vakai nǝ uurama. ");
INSERT INTO glwl_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","Aɗaba am sǝrgasǝrǝg kǝ herǝrra Yaazhǝgǝl Yesu Tlǝkatǝga. Aanji ba dadda hyahǝr nǝ iina, bakǝvakwaha nadalnǝg kǝ ghǝraan kǝ talaga mbakyarvad kǝ uurama, aɗaba tǝdvad talagǝrana, am da tlǝkǝnatlǝg nǝ uuram kǝ dǝgit baɗǝm tǝvuukwa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","Sawariyi ǝn vǝlkurnaiya, ǝn taaakiya, ɓagaɓag kǝ maraw am ghyǝnngna kǝ dǝgiti famarzha nǝ uuram ma viigǝn kwa daal na, kwakyarvad vǝlamndavǝlǝg kalti biya, ǝndkwah biya, aɗaba am naagan kǝ ɓagana. ");
INSERT INTO glwl_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","Ghyǝnngamna ghyǝnng ci kǝ tlǝrǝn famarzha nǝ uuram bad ǝrvǝdmahuɗ pallna, ɓagamɓag ba kǝla ndzǝɗaaruwa. ");
INSERT INTO glwl_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","Akwamam dǝ ǝrvǝdmahuɗa vǝlgaana, da ciingan nǝ Daadamazhigǝl kǝmtakǝra valgaanaruwa, akwama vǝlamndavǝlǝg kalkala ndzǝɗaaruwa. Naa bi nǝ Daadamazhigǝl kǝ ɓa dǝgiti kwa dǝtbi nǝ ndzǝɗaaru dat vakaiy biya. ");
INSERT INTO glwl_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","Kwakyarvad ǝn vǝltǝr kǝ dǝgit tsaftsaf kǝ kyalmaha, tǝhalakwaha ǝn fǝkura kǝ dǝgit dǝmdǝm biya. ");
INSERT INTO glwl_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","Kwakyarvad taguvnan nǝ tlǝriin ba kalkal band kwa nahava, mǝlamtǝrumǝlǝg ba ndkwana aɗaba am dǝ duula mǝltǝrumǝlǝga. Kuuram dlaɓa ar da mǝlkurumǝlǝg ma sarta kwa da maay nǝ dǝgit vakaru biya, iitǝr dlaɓa ar da mǝlkuru, sarti ma da mǝng nǝ dǝgit vakatǝra. Tǝdvad kwah wa da ba kalkal nǝ ndzǝgana. ");
INSERT INTO glwl_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","Bandkwa viindaviindan ma kakaɗa Daadamazhigǝl taaki, “Daadakwa dzagant ba dyǝka, da jǝguubi kǝ ndzǝɗa biya, Daadakwa dzagant ba ǝnkyǝkwaha, hǝtsal bi kǝ iin biya.” ");
INSERT INTO glwl_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","Kǝm tagar uus kǝ Daadamazhigǝl kwa fǝghara kǝ Titus kǝ ɓa tlǝra mǝlgaru kǝ uudah, bandkwa naag naiya. ");
INSERT INTO glwl_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","Kwakyarvad ghalgamnd bi wa fǝghara kǝ dagau da vakaru biya, aɗaba naha ba wur nǝ iin kǝ da vakaruwa. ");
INSERT INTO glwl_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","Wa ɓǝlamndantɓǝlǝg baz zǝraabamiiyam ǝmtaɗ dǝ iina, kwa daal nǝ daagan vaka taa ǝlbǝg maraw kǝ dlamakǝlaaa lii gatǝg baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","Maay waha ndakwani, kǝsghakakǝsǝg nǝ dlamakǝlaaa lii gata kǝ iina ma dahadagal ǝmtaɗ dǝ kǝmnda da vaka ɓatlǝra herǝrra kwa kǝm ɓag nǝmnd mbakyarvad galla Yaazhǝgǝla, dlaɓa kiyava mardamarǝg taakiya kǝm mǝng dǝ ǝrvǝdmahuɗa mǝltǝru kǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","Kǝm gǝdza dǝgiti da tagav tǝ kǝmnd tǝghǝr kǝ ɗuuli kǝmnda tagw nǝmnd dǝ dǝgitahi dzahavant dǝ haiga ghǝra. ");
INSERT INTO glwl_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","Naagamnda kǝm ɓaga kǝ dǝgit marawa, kwakyarvad tǝvuukwa Yaazhǝgǝl pall biya, baz tǝvuukwa uudaha. ");
INSERT INTO glwl_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","Ɓǝlamndantɓǝlǝg kǝ zǝraabamiyam ǝmtaɗ dǝ iitǝra, kwa shǝg ba dyǝk kǝm ba fishǝgaana dlaɓa famndǝghǝrtfǝg dǝ iin tǝghǝr kǝ dǝgitah shahshaha. Ndawana gwiiya fǝgharaafǝg kǝ mǝlkurumǝlǝg mbakyarvad haiyakurǝrhaig dǝ kuurama. ");
INSERT INTO glwl_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","Dzamamnadzamǝg taakiya Titusa tsaghwa ɓa tlǝrarra, baz iina baz kaiya kǝm ɓa tlǝr mbakyarvad kuurama. Kyalma zaraabahamiyami kwar ǝmtaɗ dǝ iina, ɓǝlatǝrǝt dlamakǝlaw lii gata Yesu, tlǝraatǝra fǝgara ba gala Kǝristi. ");
INSERT INTO glwl_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","Maramtǝrdamarǝg kǝ uudah kǝ hulfa waiyakǝvǝn ɓagamtǝra nǝ uuramana. Ar da cinngacinng dlamakǝlaaw lii gata Yesu kwa ɓǝlatǝrǝrɓǝlǝg kǝ dǝgiti ɓagamtǝra nǝ uurama, kwan wa da martǝrdamarǝg taakiya tsa kusǝghamnd dǝ kuurama mbats bak jiijiira. ");
INSERT INTO glwl_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","Maay tlǝra viindkur wakit kǝskai tǝghǝr kǝ mǝltǝru kǝ yaa dadda gatǝg biya. ");
INSERT INTO glwl_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","Aɗaba ǝn sǝrgasǝrǝg nai am naagan kǝ mǝlgaru kǝ uuda, baz tsa kushǝgh kǝskai vak kǝ uudaha makidoniya tǝghǝr kwana. Ən tagtǝrtag taakiya kǝ uuram uudaha Akaaya ɓadlǝvaɓadlǝg bamma viigǝn kwa dalna. Hulfa fa ndzǝɗǝn maramnda nǝ uurama iin wa fatǝrafǝg kǝ ghǝravatlǝr kǝ fa ndzǝɗa. ");
INSERT INTO glwl_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","Ndakwan ciya, wan ɓǝlgan kǝ uudahaan zaraabaharra, aɗaba haik kǝ nǝg nǝ tsa kushǝghamǝnd dǝ kuuram kǝ dǝga bandza. Ən naagan an ndzan ba ɓadlaɓadlana, band kwa tagankur nai wurra taaki am ndzana. ");
INSERT INTO glwl_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","Mbakyarvad kwaha akwama da sarǝvsǝg ǝmtaɗ dǝ kyalma lii gatǝga kwar ma Makidoniya, ǝn naay ar tlǝkuuran ba kwal dzahgant dǝgit biya. Akwama dzǝghardzǝg ǝndkwana, ǝm da ciinga zhǝruwa mbakyarvad dyakǝra tsa kushǝghǝn ǝn tsǝg nai dǝ kuurama, ba kai pal bi wam da tsǝgwi nǝ uuram kǝ zhǝru biya, baz kǝ uurama. ");
INSERT INTO glwl_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","Mbakyarvad kwaha, maa ɓagaɓag kǝ maraw ǝn ghalu kǝ Zaraabahǝn mara sǝv saa vakaru lakwti ǝn da dagau naiya, mbakyarvad mara dzahant kǝ dǝgitahaan tama nǝ uuram kǝ langyi vǝlgaana, aɗaba ma tlǝvaran dzahadzahana. Kwan wa da mardamarǝg taakiya vǝlamnda bad naaga ghǝraruwa, faakuura dǝ ndzǝɗ nǝ uud biya. ");
INSERT INTO glwl_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","Dzamam-nadzamǝga, daddakwa riiga hulf ǝnkyǝkwaha, da tlǝkǝna ba ǝnkykwah kǝ dǝgita ma guuha, kiyava daddakwa riiga hulf ba dyǝkka, da tlǝkǝnatlǝg kǝ dǝgit ma guuh ba ɗyakka. ");
INSERT INTO glwl_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","Ma bawara aa vǝldavǝlǝg band kwa haigant nǝ iina, dǝ badzǝga ǝrvidmahuɗ biya dǝ barari biya, aɗaba naa daddakwa vǝlda bad huɗ pal Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","Da vǝlkurvǝlǝg nǝ Daadamazhigǝl kǝ bark ba kwa juujig kǝ dǝgiti am naag nǝ uurama, aɗaba aanji ba hǝra am tlǝkǝna kǝ dǝgiti am naag nǝ uuram baɗǝmma, baz kwa juujig kwaha, kiyava ɓa dǝga herǝrr kǝskuurama. ");
INSERT INTO glwl_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","Bandkwa viindaviindan ma kakkaɗa Daadamazhigǝl taakiya, “Vǝltǝrvǝlǝg kǝ dǝgit kǝ talagaha. Jiijiira aandz ba tangw damma Zǝrazǝra.” ");
INSERT INTO glwl_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","Ba Daadamazhigǝl wa vǝlga hulfa riig kǝ dadda riiga, vǝlar dlab kǝ dǝg zǝgga. Mbakyarvad kwaha da vǝlkurvǝlǝg nǝ Daadamazhigǝl kǝ hulfa riiga, iin dlaɓ wa da fǝgara hulf kǝ ghubarga. Tǝdvad kwah wa da fǝgara nǝ iin kǝ bark tǝghǝr kǝ dǝgiti amaa vǝlda nǝ uurama dǝ haiga ghǝra kiyav ɓa dǝga herǝrra. ");
INSERT INTO glwl_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","Aanji ba hǝrra da fǝkurafǝg kǝ bark ma dǝgiti am da ɓag nǝ uuram kiyava vǝlgan kǝskurama dǝ haiga ghǝra ba kǝlahǝnga. Ar da tagar ǝndkwah nǝ uudah ba dyǝk kǝ uus kǝ Daadamazhigǝl mbakyarvad gyagyaan kwam da vǝltǝr nǝ uuram tǝdvad kǝmnda. ");
INSERT INTO glwl_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","Aɗaba tlǝra herǝrrǝn am ɓag nǝ uuram kiyava pǝlla puuta yaa dadda gatǝg kalti biya, gwiiya ba fǝgaraa tagar uus badyak dyak kǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","Mbakyarvad tlǝrahi kwam ɓag nǝ uurama, ar da galgaan nǝ uudah ba ɗyaka kǝ Daadamazhigǝl mbakyarvad fǝgaarafǝgaruwa kwa gwiya tǝhala kwa cawama nǝ uuram kǝ ǝlbǝg marawa Kǝristi, dlaɓa mbakyarvad kwa mǝlamtǝru nǝ uuram kǝ iitǝra ard kyalma uudaha baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","Ar da dzǝkurdzǝg nǝ iitǝr kǝ zhigǝla, dlaɓa ar da dzamkurdzamǝg ma ǝrviɗmahuɗaatǝr mbakyarvad herǝr kwa juujig kǝ taga kwa ɓagakura nǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","Tagiiyamartag kǝ uus kǝ Daadamazhigǝl mbakyarvad gyagyanǝn vǝla kiiyam nǝ iin, gyagyan kwa juujig kǝ taga. ");
INSERT INTO glwl_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","Ba kai Bulus dǝ ghǝrara, ǝn ghala kurama, kwa ɗaakwa nǝ uud, “Daddakwa dǝ hǝnkala” akwaman ǝmtaɗ dǝ kuurama, akwama ǝn maay ǝmtaɗ dǝ kuuram biya “Ən daddakwa mbǝgar kǝ uuda” ma barka kalaliya ard hǝnkala Kǝristi, ");
INSERT INTO glwl_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","Ən ghalakuurama, famwabi ǝn mbukurǝs akwama da danǝvdǝg da vakaru biya, aɗaba ǝn sǝrgasǝrǝg ǝn da mbǝtǝrasmbǝg kǝ lii taaki dǝgiti kǝm ɓag nǝmnda, ba dǝga duniya. ");
INSERT INTO glwl_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","Aanji ba kǝm ɓa ndzǝgan ma duniya, ghwavi kǝm ɓag nǝmnda dǝga duni biya. ");
INSERT INTO glwl_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","Aɗaba kadlanga ghwavamnda dǝga duniya biya, dǝga ndzǝɗa Daadamazhigǝla. Kǝm dlag tǝdvad iitǝr nǝmnd kǝ vakavakahi dǝ ndzǝɗa kwa ndzamǝg nǝ tlǝghumaha kǝ dǝga fiidfiida. ");
INSERT INTO glwl_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","Kǝm zaafir tǝghǝr kǝ lii ɓala gajauwa, kǝm dlagan aanji kwar kǝ dǝgiti da tsǝgarva sǝrga Daadamazhigǝla, kǝm gwiidan dlaɓ aanji hulfa kwar kǝ dzamaghǝr da tǝ ɓa kwatǝnahǝra ard fǝgara kǝ Tlǝkatǝga. ");
INSERT INTO glwl_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","Ɓadlamvaɓadlǝg nǝmnd kǝm vǝla kǝ kiiɓa ndaig kǝ daddakwa lawalǝg kǝ fǝgaara kǝ Tlǝkatǝga, akwama ba am fǝgarafǝga. ");
INSERT INTO glwl_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","Zharamzharǝg kǝ dǝgit bat ɓalaɓala! akwama tagaatag nǝ uudan taaki dǝga tlǝkatǝg nǝ iina, aa gwiiya dzamǝg nǝ uudanǝn kǝ ghǝra, da nǝghǝgakanǝghǝg nǝ iin taakiya ba kǝmnd ndakwani kǝm dǝga tlǝkatǝga. ");
INSERT INTO glwl_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","Aanji ba mana tsa kushǝgh dǝ ndzǝɗǝn kwa vǝlakǝmnd nǝ Yaazhǝgǝl kiyava fǝkura ndzǝɗa, kwakyarvad gulkura nǝ uud biya, ǝn da dǝgǝmbi dama zhǝru mbakyarvad tlǝrar biya. ");
INSERT INTO glwl_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","Tlatlambi taaki ǝn na vǝlkur tlatlau nai ma wakiitahar biya. ");
INSERT INTO glwl_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","Aɗaba tagav taakiya, “Wakiitaha Bulusa ba dladlaɗana ard ndzǝɗa, akwama ba iin dǝ ghǝran wa vakamiiyama, maay nǝ iin taaghai dǝ ndzǝɗ biya, dlaɓa ǝlbǝgahaana tlalbi kǝ dǝgiti biya.” ");
INSERT INTO glwl_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","Barari hulfa kwan kǝ uudaha ar sǝran taakiya maay nǝ gǝrgǝr ma taataka dǝgiti viindamnda nǝmnd ma wakiitamnda akwama kǝm maay vakwani, ar dǝ dǝgiti kǝm da ɓag nǝmnd akwama kǝm ǝmtaɗ dǝ kuurama. ");
INSERT INTO glwl_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","Kǝm war nǝmndi! tlamdalbi nǝmnd kǝ gǝra ghǝramnd dǝ uudahi kwa ma zharg nǝ iitǝra jarujig aanji ma bawara. Kwan kǝ uudaha ar kura ghǝraatǝr dǝ zaraabahatǝra, ar na sǝraakan kǝ gǝrgǝr mataatakatǝra, ar dlagah nǝ ittǝra! ");
INSERT INTO glwl_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","Kǝm maay tsa kushǝgh kwa juujig kǝ ndzǝɗ biya, bamma kǝm ghachan bat ghala dǝgiti aa ghutǝkǝmnda nǝ Daadamazhigǝla, kwa ndzakiiyamǝt baz kuurama. ");
INSERT INTO glwl_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","Abi baz kuuram ndakwani am ba ma ghaali kwa ghudgwi nǝ Daadamazhigǝla, mbakyarvad kwaha dzǝvanai kǝ ghala guh kwakyarvad na dǝgal da vakaru da taa ǝlbǝg marawa Tlǝkatǝg biya. ");
INSERT INTO glwl_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","Tsa kushǝghamnda juubi kwa nahav biya, tapghantbi dlaɓ kǝ tlǝra kyalmah biya. Aɗaba kǝm dǝ fantar taakiya fadghǝraruwa da fǝgara bad fǝga, tǝdvad kwah nǝ vaka ɓa tlǝramnd ma kǝ uurama fǝgara bad fǝg ba vaivaiya, ");
INSERT INTO glwl_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","Kǝm da taagan kǝ ǝlbǝg maraw ma kwatlǝrn kǝ kǝsah kwa tǝvuukwaruwa, ba kwal gata daag vaka ɓa tlǝri ɓaga nǝ uudan tǝ vakavaki favan nǝ iin biya. ");
INSERT INTO glwl_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","Bandkwa viindaviindan ma kakaɗa Daadamazhigǝl taakiya, “Baɗǝm nǝ daddakwa tsa kushǝgha, aa tsatsǝg kǝ kushǝgh dǝ Yaazhǝgǝla.” ");
INSERT INTO glwl_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","Daddakwa dlǝba ghǝran bi wa haivanthaig dǝ iin biya, bamma daddakwa dlǝbgant nǝ Yaazhǝgǝla. ");
INSERT INTO glwl_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","Am da fa ba ǝrviɗmahuɗ dǝ kaiya, aanji ba mǝnng zǝr dlagǝr vakara. Famafǝg kǝ ǝrviɗmahuɗ dǝ kaiya! ");
INSERT INTO glwl_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","Ən sǝlga mbakyarvad kuurama, dǝ hulfa sǝlga waiyakǝva kwa ɓag nǝ Daadamzhǝgǝl tǝghǝr kǝskuurama. Am band ghuul cacuwanacacuwan kwa tavara langyi kǝsgan kǝ zhiila ba pal ba nǝ iina, iin Tlǝkatǝga. ");
INSERT INTO glwl_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","Ən gǝdzǝg naiya aa nal bi band kwa dzǝghaar dǝ Hauwa, da dzaar dǝ kuuram biya. Valadavalǝg ghavala bad ɗyamɗyamǝraana ɓagaaɓag kǝ haipa. Am band kwah nǝ uurama, nǝgalnǝg dzamaghǝraru kǝ dǝga jiirǝr biya, tǝdvad kwaha, am vǝlda bi kǝ ghǝraru bak jiijiir kǝ Kǝristi biya. ");
INSERT INTO glwl_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","Aɗaba am haigant ba wats dǝ lii sǝgǝv da vakaruwa. Haiyamanthaig dǝ ǝlbǝgahi ar tagkur nǝ iitǝr tǝghǝr kǝ Yesu, aanji ba shah dǝ kwa tsagamndkuuru nǝmnda kǝ ǝlbǝg marawana. Haiyamanthaig dlaɓ dǝ hulfa shǝdkwi tagarkur nǝ iitǝra, bakǝvakwaha kwan kǝ shǝdkwa shiɗkwa cacuwanacacuwan bi wa caawama nǝ uur biya. Haiyamanthaig dlaɓ dǝ hulfa ǝlbǝg marawatǝra, aanji ba shah dǝ kwa caawama nǝ uuram vakamnda. ");
INSERT INTO glwl_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","Manzharg naiya jarkwarabi nǝ lii am tagtǝr nǝ uuram taaki “Ar dlakulva gyiyaha Yesu” dǝ dǝgit biya. ");
INSERT INTO glwl_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","Aanji ba tsaghwad bi nǝ uud kǝ taaghai biya, bakǝvakwah ǝn sǝrgasǝrǝg kǝ dǝgita. Maramndkurdamarg nǝmd kwan aanji tǝ kwar kǝ ɗuula. ");
INSERT INTO glwl_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","Tagankuratag nai kǝ ǝlbǝg marawa Daadamazhigǝl ba gyagyana. Nannennanenig nai kǝ ghǝrara, kiyava fǝkuraaran nǝ uuda. Baganaɓag kǝ haip ciya? ");
INSERT INTO glwl_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","Nalnǝg mandki na pǝrɗigu kwaɓ vak kyalma dlamakǝlaaa lii gatǝga kwakyarvad ǝn ɓakura kǝ tlǝra. ");
INSERT INTO glwl_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","Ma sartǝn ndzan ba ǝmtaɗ dǝ kuurama, nahanahǝg nai kǝ kwaɓa, bakǝvakwaha ndavankur biya, aɗaba sarwadǝvsǝg zaraabahamiyam kwa sarǝv ma Makidunkiya kǝ dǝgiti ǝn naag nai baɗǝmma. Fankuraabi nai ma sartakwahiin biya, dlaɓa ǝn da zaa ba vuukw bandkwana. ");
INSERT INTO glwl_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","Kwakarvad jiira Tlǝkatǝga kwa ma kaiya, maay wa tsǝkwavatsǝg baɗǝm ma haaya Akaaya kǝ taaki ɗuuwarɗug kǝ tsa kushǝgh biya. ");
INSERT INTO glwl_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","Aujilbǝg kǝskai ǝn taa kwani? Mbakyarvad ǝn maay waiya kurami ciya? Sǝrgasǝrg nǝ Daadamazhigǝl taaaki ǝn waikurwaiga. ");
INSERT INTO glwl_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","Ən zaa ba vuuk nai dǝ ɗuuwa kwaɓi kwam da mǝlgwad nǝ uurama, mbakyarvad ǝn tsǝtǝrva kǝ “Dlakulvaha gyiyi Yesu kwa dyǝkdyǝkǝn” kǝ ɗuula tsa kushǝgh taakiya, ar ɓa tlǝr ba kalkal dǝ kǝmnda. ");
INSERT INTO glwl_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","Hulfa kwan kǝ uudaha ar dlakulva gyiya Yesu aa jiirjiir biya, lii ɓa tlǝra fiida. Ar na ghǝraatǝr band dlakulva gyiya Tlǝkatǝga. ");
INSERT INTO glwl_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","Dǝga jappǝr biya, aɗaba shatanah dǝ ghǝraan ndakwani naa ghǝraan band zǝrɓǝlǝg paraka. ");
INSERT INTO glwl_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","Mbakyarvad kwaha, dǝga jappǝr bi akwama nardalnǝg lii ɓagar tlǝr kǝ Shatanah kǝ ghǝraatǝr band lii ɓa tlǝra jiijiira. Tǝhala ghyǝnnga duniya ar da cauwa dǝgshǝgaatǝr ba kalkal dǝ tlǝraatǝra. ");
INSERT INTO glwl_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","Ən gwiiya ba tagan naiya, aa tlatl bi nǝ uudan taakiya ǝn dlag biya. Akwmam tlatlǝgan band kwaha, aciya, haiyamanthaig dǝ kai band dadda dlaga, aɗaba kai ndakwani ǝn tlǝkǝna kǝda tsa kusǝgha. ");
INSERT INTO glwl_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","Hulfa tsakushǝghǝn ǝn tsǝg naiyna, kwakyarvad tagaa nǝ Yaazhigǝl ǝndkwah biya. Aˈa, ma kwanǝn kǝ ǝlbǝga ǝn tsakushǝgh band dlaaga. ");
INSERT INTO glwl_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","Aɗaba mǝng nǝ lii tsakushǝgh band kwa ɓag nǝ uudaha duniya, ba kai ndakwani ǝn ɓagan band kwaha. ");
INSERT INTO glwl_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","Am ba dyǝmdyǝm nǝ uuram ba vaivaiya, baz hwaɗag kǝskuurama am ɓǝsha dǝgiti ɓagkur nǝ dlaagaha! ");
INSERT INTO glwl_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","Aɗaba ma fakuraafǝg nǝ uud kǝ ɓa kwatǝnahǝra, am ba ɓǝshǝgana, aanji pǝrkurva dǝga ruuwa, ma markura ndzǝɗa, ma ɓalkura mahǝpǝngw ma hudvǝga. ");
INSERT INTO glwl_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","Ən cinnga zhǝruw nai kǝ taaki mbakyarvad maira ndzǝɗamnd wa ɓagamnda bi kǝ kwanahaan kǝ dǝgitah biya! Akwama mǝng nǝ daddakwa fa ndzǝɗa tsa kushǝgh dǝ dǝgiti tlǝrna, ba kai ndakwana ǝn fǝgaan kǝ ndzǝɗ bandkwaha. Ən tag band dlag naiy kǝ ghaiya vakwana! ");
INSERT INTO glwl_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","Akwamaa Ibraniyah nǝ iitǝra, kai ndakwani bandkwaha. Akwamar kuɗiga Ibrahim nǝ iitǝra, ba kai ndakwani bandkwaha. Akwamar Isra ilah nǝ iitǝra, ba kai ndakwani bandkwaha. ");
INSERT INTO glwl_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","Akwama ar lii ɓa tlǝra Kǝristi nǝ iitǝra, jantǝrarajig naiya! ǝn taa ghaiya bandgi nanalnǝg kǝ valaaga! abi jantǝrarajig naiy dǝ tlǝr ba vaivaiya, danaghadǝg damma guda bǝrfinnga, hǝɓanuhǝɓǝg kǝ tsǝgga ba ɗyaɗyaka, shǝg ba ɗyak kǝskai kǝ ngǝdlǝg tǝ ɗuula ǝmtsǝga. ");
INSERT INTO glwl_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","Shǝg dlǝɓa kǝ Yahudah kalkwakalǝg dǝ kiiɓ kulhǝkǝrd taar vaslambada. ");
INSERT INTO glwl_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","Shǝg hǝkǝrd kalkwakalǝg nǝ Rumaha dǝ kiiɓa. Tapavnatapǝg dlaɓ ɗawalkwaɗawalǝg nǝ uud da akura shǝg palla. Shǝg hǝkǝrd kǝ pǝrayuwa caaɓǝg ǝn bama vakaiya. Tapannatapǝg dlaɓ kǝ hǝnnga baz vanng bama dǝlva, lakwti sǝkwadasǝg nǝ uuda. ");
INSERT INTO glwl_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","Ma dahadagali ɓagan naiya fǝrtanafǝrtǝg kǝmtsǝg ma zaagha, dlaɓa fǝrtanatǝrtǝg kǝmtsǝg ma dǝva gwarɗaaha. Fǝrtanafǝrtǝg kǝmtsǝg ma dǝva zaraabahar Yahudaha, dlaɓa fǝrtanafǝrtǝg ma dǝva lii kwar yahudah biya. Fǝrtanafǝrtǝg kǝmtsǝg ma kǝssah dyǝka, fǝrtanafǝrtǝg kǝmtsǝg ma tǝghala, fǝrtanafǝrtǝg kǝmtsǝg ma dǝlva, fǝrtanafǝrtǝg dlaɓ kǝmtsǝg ma dǝva zaraabah fiidfiida. ");
INSERT INTO glwl_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","Ɓaganaɓag kǝ tlǝra, tlakwatlǝg dlaɗa, hǝnnanubi kǝ haar maraw biya, ɓǝshanuɓǝshǝg kǝ waiya ard andǝla. Shǝg ba dyǝkka ǝn tlǝkǝnabi kǝ kaff biya, tlakwatlǝg nǝ akwǝhya, pǝlghwavapǝlǝg nǝ sǝdav ǝn da fǝg nai biya. ");
INSERT INTO glwl_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","Maay ba nǝ kyalma dǝgitahi shah biya, ba kǝlahǝnnga ǝn kǝsa dlaɗa faahyǝmi tǝ yaa dadda gatǝg baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","Akwama mǝng nǝ daddakwa hǝtsalhǝtsǝga, mandki kai wa hǝtsǝgalhǝtsǝga, akwama mǝng nǝ daddakwa dǝgǝm damma haipa, fǝgwafǝg kǝ badza ǝrvǝdmahuɗ ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","Akwama nalnǝg ba jiirjir kǝskai tsakushǝgha, ǝn tsakushǝgh dǝ dǝgitahi kwa mara hǝtsǝgalhǝtsǝgara. ");
INSERT INTO glwl_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","Sǝrgasǝrǝg nǝ Daadamazhigǝl taaki fiidbi wan tag naiya, kwa iin Daadamazhigǝla, dlaɓa Daada Yaazhǝgǝl Yesu Tlǝkatǝga. Aa ndzandzǝg bark tǝghǝr kǝ iina ba tangw damma zǝrazǝra! ");
INSERT INTO glwl_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","Ma sarta kwa ndzan ma Dimashku naiya, faafǝg nǝ gwammna kwa miizhangil kǝ tlǝkǝsa Aretas kǝ uuda tuuk kǝ ghaiya guda kǝs dyǝkka Dimashku kiyava viiya kaiya. ");
INSERT INTO glwl_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","Sarkwada nǝ tsaghwahar ma alghwa tǝ ghǝra dǝlga kǝssiina, ngǝdlanarva ǝndkwaha. ");
INSERT INTO glwl_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","Aanji ba da maay tlǝraan biya, barari kǝskai tsa kusǝgha. Bandkwannǝn, ǝn zaavuuk dǝ taa ǝlbǝgah tǝghǝr kǝ dǝgitahi marghwada Yaazhigǝl Yesu Kǝristi ma sǝnnga ard ba ghwɛm dǝ gyiya. ");
INSERT INTO glwl_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","Ən sǝrgasǝrg kǝ uuda nǝ iina kwa vigaan kǝlaawa tar uufaɗ hinanna, kǝsavantkǝsǝg dagat damma ghǝrazhigǝla dǝga hǝkǝrɗa tǝdvad ndzǝɗa Kǝristi, mbatak ma ndzǝgana vǝgha, mbatak ma ndzǝgana vǝgh biya, ǝn sǝrga biya, sǝrga ba Daadamazhigǝl palla. ");
INSERT INTO glwl_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","Ən ba sǝrgasǝrǝg dlaɓ kǝ uuda nǝ iina, kwa kǝsavantkǝsǝg dagat damma ghǝrazhigǝla dǝga hǝkǝrɗna, mbatak ba maa ndzǝgana vǝgh nǝ iina, mbatak ma ndzǝgana vǝgh biya, ǝn sǝrga biya, sǝrga ba nǝ Daadamazhigǝl palla. ");
INSERT INTO glwl_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","Cinnghacinng kǝ kyalma dǝgitahi vakwah kwa da tagǝvda biya, hulfa kwa tagda bi nǝ uuda dǝgshig kǝ ǝlbǝg tǝghǝr biya. ");
INSERT INTO glwl_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","Ən tsǝgaan nai kǝ kushǝgh dǝ uudana, ǝn tsǝga bi kǝ kusǝgh dǝ ghǝrar biya, bamma tǝghǝr kǝ dǝgitahi kwa mara hǝtsǝgalhǝtsǝgara. ");
INSERT INTO glwl_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","Akwaman naagaan kǝ tsakusǝgha, ǝn nǝgal bi kǝ dlagi, aɗaba ǝn da taa ba jiira. Ən maay da tsa kusǝgh biya, mbakyarvad aa dzam bi nǝ uudan bandgi ǝn shah dǝ kwa sǝrkwa nǝ iin biya, ard kwa cinngha nǝ iin vakara. ");
INSERT INTO glwl_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","Aɗaba haik tsa kusǝgh kǝskai dǝ kwanahaan dǝ sǝnnga kwa juujig kǝ dǝga jappǝra, ngal ba ɓǝlgusɓǝlǝg nǝ uud kǝ kuzza kwa nal kǝ tak ma vǝghara. Nalnǝg wan kǝ zǝrɓǝlga shatanah kiyava vǝlgwa dlaɗ tsǝkwavan dlaɓ kǝ tǝɗa fǝɗyavǝgha. ");
INSERT INTO glwl_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","Shǝg hǝkǝrd kǝskai ǝn ba ghaala Yaazhigǝl mana tagwzha dǝ kwan kǝ dǝgita, ");
INSERT INTO glwl_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","Aiyama kǝskaiya, “Tlakaaratlǝg herǝrra, aɗaba tǝdvad hǝtsǝgalhǝtsǝgah wa da nǝghǝvaanǝghǝg ndzǝɗara.” Mbakyarvad kwaha ǝn da fǝgara bad hwaɗag nai kǝ tsa kushǝgha hǝtsǝgalhǝtsǝgar kiyava ndzǝg nǝ ndzǝɗa Kǝristi ǝmtaɗ dǝ kaiya. ");
INSERT INTO glwl_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","Mbakyarvad kwaha nǝghǝghanaakanǝghǝg dǝ hǝtsǝgalhǝtsǝgara, ard zaa hǝtǝr ma vǝga kwa ɓaghwi nǝ uuda, ard huɓa dlaɗa, ard mbahǝlla, ard dǝgitahi dzaaghardzag mbakyarvad Kǝristi. Aɗaba akwma hǝtsanalhǝtsǝga, ǝn da tlǝkǝna ma sartakwah nai kǝ ndzǝɗa. ");
INSERT INTO glwl_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","Ɓaganaɓag kǝ dlagǝra, famwaba nǝ uurama. Ma kuuram wa kalkalaan kǝ dlǝba kaiya. Aanji ba tlanal ndau biya, nal bi taaki “mallaha dlakulva gyiya Yesu ruwa” jarkwaraa biya. ");
INSERT INTO glwl_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","Ɓagaɓag Daadamazhigǝl kǝ dǝga sǝrga ard tlǝraha jappǝr tǝdvad kai makuurama, kwa ɓagana nai kǝ tlǝrar dǝ fa ǝrvidmahuɗa. Kwanahaan kǝ dǝgaha jappǝra maradamarǝg taakiya ǝn dlakulva gyiya Yesu ba jiijira. ");
INSERT INTO glwl_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","Ta kwar kǝ ɗuul wa maranda nai taakiya namal bi kalkal dǝ kyalma dlamakǝlaaw lii gatǝg biyi? Nii mbakyarvad tsankurvatsǝg kǝ mǝlgwad dǝ kwaɓ hi? Ɓǝshamwanaɓǝshǝg ci kwan kǝ haipa! ");
INSERT INTO glwl_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","Ɓadlamvaɓadlǝg kǝ dǝga hǝkǝrd da nǝghakuuram ndakwana. Ən fǝkuraabi kǝ ɓa dǝgit biya, aɗaba kuuram wan naag naiya, kwaɓaruu biya. Aɗaba kalkalna bi kǝ zarh kǝ dlaɗa ɓa dǝgit kǝ Daddaahaatǝra ard Babbahatǝr biya, bamma Daddaatǝra ard Babbaatǝr wa kǝsa dlaɗa zarhahaatǝra. ");
INSERT INTO glwl_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","Ən cinnga ǝmtakǝr akwama tsanatsǝg kǝ dǝgit vakar baɗǝmma, baz ghǝrarra kwakyarvad ǝn mǝlkuruwa. Akwamma ǝn zaa ba vuukw dǝ waiya kǝ uurama, mbats am da gulgan kǝ waiyakǝvaru mbakyarvad kaiya? ");
INSERT INTO glwl_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","Am da haiganthaig dǝ kai taakiya nanaibi naiy kǝ dǝgit kǝskuuram biya. Aɗaba mǝng wa da tagan taaki na markura dyǝmdyǝmǝra, na patkuru bad fiida. ");
INSERT INTO glwl_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","Zankuruzǝg nai tǝdvad kwatlǝr kǝ uud ma lii ɓǝlantǝr nai da vaakaruwa? ");
INSERT INTO glwl_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","Ghalanghalǝg kǝ Titus maa da vakaruwa, ɓǝlanantɓǝlǝg kǝ zǝraab kwa dadda gatǝg ǝmtaɗ dǝ iina. Am tagaan taakiya zakuruzǝg Titusa? Mbats kaiya ard iina ba dǝgit pall nǝmnd biya? Dlaɓa kǝm taa ba ɗuul pal biya? ");
INSERT INTO glwl_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","Mbats tlatlam ba wur nǝ uuranm taakiya kǝm ɓa kǝla ndzǝɗamnd kǝ ngǝdla ghǝramnd vakaruwa. Ba Daadamazhigǝl nǝ shiidamnda, kǝm taa ba jiijir ma Kǝristi. Aanji kǝm ɓa bau nǝmnda, kuuramǝn ǝn waikur naiya, ɓagamnd kwakyarvad am tlǝkǝna kǝ ndzǝɗa. ");
INSERT INTO glwl_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","Ən gǝdzǝga, mbatak sarti ǝn da sagau naiya, ǝn tlǝkuuran band kwan naag nai biya, dlaɓa am tlǝkwa nǝ uuram band kwam naag nǝ uuram biya. Ən gǝdza aa tlanarai kǝ ushava, ard sǝlga, ghwaɗa hǝnkala, ard naa ghǝra ard badza ɗaaga, ard amaaha, ard dǝkdǝka ghǝra, ard ciya hǝnkala. ");
INSERT INTO glwl_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","Ən gǝdza taakiya akwama da gwiiyanagwiig da vakaruwa, da fǝgwaafǝg Daadamazhigǝlar kǝ cinnga zhǝruw tǝ vuukwaruwa. Ən gǝdza haik badza ǝrviɗmahuɗ kǝskai mbakyarvad uudah ba ɗyakka kwa ndzar ɓa ba haip wura, lii pǝlara bi kǝ ghǝr vaka ɓa gwaragwar biya, ard ɓa fǝdǝra ard gata ɗuula cinnga ǝmtakǝr dǝga tsa zhǝruwa. ");
INSERT INTO glwl_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","Dǝga hǝkǝrd nǝ wan kǝskai ǝn ba sagau da nǝghkuranǝghǝga. “Ba jiijira da sǝrvaka tǝ shidah buwa ma hǝkǝrd nǝ jiira ǝlbǝga” band kwa viindava ma kakaɗa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","Dagawar da vakaru kǝ dǝga buwa, ɓǝlanaɓǝlǝg kǝ magiya kǝ lii ɓagara haipa ard kyalma uudah baɗǝmma mara duuwars kǝ ɓa haipa. Aanji ban maay ǝmtaɗ dǝ kuuram biya, ǝn gwiiya gwaigarsgwaig kǝ hulfa kiiɓa ndaigǝn tagankur nai na, aɗaba akwama gwiiyanagwiig da vakaruwa maay nǝ daddakwa da ngǝdlǝgarwangǝdlǝg kǝ kiiɓa ndaig biya. ");
INSERT INTO glwl_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","Akwama ba am na sǝran kǝ jiira taakiya taaghai nǝ Tlǝkatǝg tǝdvad kaiya, wayam ci nǝ jiirana, hǝtsalbi nǝ tlǝkatǝg ma kuuram biya, dlakulvakwaha mara ndzǝɗan ma kuurama. ");
INSERT INTO glwl_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","Aanji ba hǝrtavǝthǝrtǝg nǝ Yesu tǝdvad mara ndzǝɗa, bakǝvakwaha dǝ shifǝg nǝ iin tǝdvad ndzǝɗa Daadamazhigǝla. Aanji ba kiyam maira ndzǝɗ nǝ miiyam ma Yesu, bakǝvakwaha kiyam dǝ shifǝg ma Yesu tǝdvad ndzǝɗa Daadamazhigǝla mbakyarvad tlǝrǝn ɓagamnd nǝmnd ma kuurama. ");
INSERT INTO glwl_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","Sǝramakasǝrǝg ndan kǝ ghǝraruwa mbakyarvad am sǝrakan taakiya am gatǝgaan kǝ Yesu bak jiijiira. Sǝramakasǝrǝg kǝ ndzǝgana ruuwa. Mbats am sǝrgai taakiya Tlǝkatǝg ba ma kuuram biya? Akwama am sǝrgabiya, nalnǝg mbǝɗamambǝdǝg tǝ duula fǝshiga. ");
INSERT INTO glwl_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","Mantlǝg naiya am da sǝrgaakasǝrǝg taakiya hǝtsamndalbi nǝmnd biya. ");
INSERT INTO glwl_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","Kǝm dzǝgwazhǝgǝl kǝ Daadamazhigǝl taakiya ɓagam bi kǝ dǝgiti kwa kalkal biya. Kwayarvad kǝm ɓa dabariya nǝdal ghǝramnd mandki kǝmnd wa zamndu fiir biya, mbakyarvad am ɓagan nǝ uuram kǝ dǝgiti kalkala, aanji ar ba da tlatlǝgan nǝ uudah taaki mandki hǝtsamdalhǝtsǝga. ");
INSERT INTO glwl_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","Aɗaba kǝm naiy kǝ dǝgiti maay nǝ jiir mavakai biya, kǝm naa ba dǝga jiira. ");
INSERT INTO glwl_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","Kǝm hwaɗag nǝmnda akwama hǝtsamndalhǝtsǝga, aɗaba am tlǝkǝna nǝ uuram kǝ ndzǝɗa. Ɗlaɓa kǝm dzǝgwazhǝgǝl am nal ba kǝ uudah jiirjiira. ");
INSERT INTO glwl_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","Iin wa viindankura nai kǝ kwana aanji ban maay ǝmtaɗ dǝ kǝ uuram biya, aɗaba akwama sanǝvsǝga, aa da nal bi kǝ barari kǝskai ǝn da vǝlkur kǝ dlaɗ dǝ mara ndzǝɗǝn kwa vǝlghwa nǝ Yaazhǝgǝla, ndzǝɗa fǝgaraadǝfǝga, dǝga badzǝg dǝ badzǝg biya. ");
INSERT INTO glwl_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","Dǝga mbasuumbas ci zaraabahara, da ba daghuvalitlǝrn. Ɓagamɓag kǝla ndzǝɗaru am nal kǝ uudah jiijiira, cinngamcinng kǝ ghalgara, haiyamanthaig dǝ zaraabaharuwa am ndzan ba lapiya. Tǝdvad kwah wa da ndzǝg Daadamazhigǝl kwa waiya uuda ard gabǝrra ǝmtaɗ dǝ kuurama. ");
INSERT INTO glwl_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","Tagamartag kǝ uus kǝ zaraabaharuwa dǝ taa uus bǝrhuga kwa caccuwanacaccuwana. ");
INSERT INTO glwl_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","Ar tagkur uus nǝ yaa dadda gatǝg baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","Aa ndzandzǝg nǝ herǝrra Yaazhǝgǝlamiiyam Yesu Tlǝkatǝga, ard waiyakǝva Daadamazhigǝla, ard ndzǝgan shǝdkwa caccuwanacaccuwana ǝmtaɗ dǝ kuuram baɗǝmma. Amin.");
INSERT INTO glwl_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","Bulus zǝrɓǝlǝg Yesu. Ɗahakwant nǝ uudah ma sǝv vak kǝ uud biya. Ɗahakwant nǝ Yesu Kristi ard Daadamazhigǝl Daada kwa ciighant Yesu ma gǝtlaha. ");
INSERT INTO glwl_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","Baɗǝm nǝ zaraabah kwar ǝmtaɗ dǝ kai vakwana, ghǝravatǝr ndakwani ar taa uus kǝ dlamakǝlaaa lii gatǝg baɗǝm kwar ma Galatiya. ");
INSERT INTO glwl_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","Aa dzadzǝg nǝ herǝrra ard gabǝra Daadamazhigǝl Daadamiyama ard Yaazhigǝl Yesu Kristi da tǝghǝr kǝskuurama. ");
INSERT INTO glwl_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","Vǝladavǝlǝg nǝ Yesu Kristi kǝ shifǝgan mbakyarvad haipahamiyma, kiyava katkiyamkatǝg makwan kǝ zamana kǝladǝra. Kwana kwakyarvad naaga Daadamazhigǝl Daadamiyama. ");
INSERT INTO glwl_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","Ndanghǝr kǝ Daadamazhigǝl ba tangw damma zǝrazǝra. Amin. ");
INSERT INTO glwl_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","Vǝlghwavǝlǝg nǝ dǝgiti am ɓag nǝ uuram kǝ dǝga jappǝr ba vaivaiya. Bamma sart hǝɗiikǝn am naa ɗuwa daddakwa ɗahakurǝt tǝdvad herǝrra Kristi, am gwiya damma kwatlǝrn kǝ daala ǝlbǝg shah dǝ ǝlbǝg maraw kwa samndkurdǝv nǝmnda. ");
INSERT INTO glwl_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","Maay nǝ watlǝrn kǝ ǝlbǝg maraw shah biya. Aɗaba mǝng kyalma uudaha ar na ciikurant hǝnkalaruwa, dlaɓa ar ɓa dabariya gwiya jiira ǝlbǝg marawa Kristi. ");
INSERT INTO glwl_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","Ən tagkurtag ciya, akwama sakurdǝvsǝg nǝ uudan kǝ ǝlbǝg shah dǝ ǝlbǝg maraw kwa samndkurdǝv nǝmnda, aanji zǝrbǝlǝg sii ma ghǝrazhigǝla, aanji ma kǝmnda, tlafatlafan vak Daadamazhigǝla! ");
INSERT INTO glwl_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","Bandkwa tagamndkur nǝmnd ba wurwura, ǝn gwiya tagkurtag bakǝvakwana taakiya, baɗǝm nǝ daddakwa tagkura ǝlbǝg maraw shah dǝ ǝlbǝg maraw kwa cawama nǝ uuram vakamnda, tlafatlafana! ");
INSERT INTO glwl_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","Magha tag nǝng ǝn ɓa dabariya fǝtǝra uudah mara haiyant dǝ kaiya? Əndkwah biya. Dǝgiti ǝn naag naiya, aa haiyanthaig nǝ Daadamazhigǝl dǝ dǝgiti ǝn ɓag naiya. Mam tlǝg nǝ uuram ǝn ɓa dabariya ɓa dǝgiti naag nǝ uudah naiya? Əndkwah biya. Akwama manaa ɓa dǝgiti naag nǝ uudah naiya, ma nanal bi kǝ kwatǝnah Kristi biya. ");
INSERT INTO glwl_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","Ən naagan am sǝran zaraabahar taakiya, ǝlbǝg marawǝn ǝn tag nai kǝ ǝlbǝg tǝghǝrna, sal vak uud nǝ iin biya. ");
INSERT INTO glwl_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","Caawana vak uud bi naiy biya. Dlaɓa maay wa tsaghwad tsag biya. Caawana vak Yesu Kristi tǝdvad mara ghǝran vakara. ");
INSERT INTO glwl_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","Cinngamacinng kǝ hulfa ndzǝgani ɓagan nai wur ma gatǝga Yahudaha, ard ɗuuli vǝlantǝr nai kǝ dlad kǝ dlamakǝlaaa lii gata Daadamazhigǝl ba vaivaiya, ɓaganaɓag kǝ kǝla ndzǝɗar mana ghǝhnan na. ");
INSERT INTO glwl_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","Am sǝrgasǝrǝg dlaɓ taakiya januujǝg kǝ kyalǝm uudah ma gatǝga Yahudah kwa ghubaramnd nǝmnd ǝmtaɗ dǝ iitǝra. Jantǝruujǝg dǝ naa dǝga daadijahamnd ba vaivaiya. ");
INSERT INTO glwl_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","Daadamazhigǝl kwa fakwi mahuɗa baabara, kǝsakutkǝsǝga dlaɓa ɗahakutɗahǝg tǝdvad herǝrraana, cinngucinng kǝ ǝmtakǝrarra ");
INSERT INTO glwl_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","Marghwadamarǝg kǝ Zǝran Yesu, kiyava taa ǝlbǝg maraw kǝ lii ar Yahudah biya. Ɓagaa ba nǝ iin ǝndkwana gatan bi kǝ sawari vak kǝ uud biya, ");
INSERT INTO glwl_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","danal bi dlaɓ damma wurshalim da vak lii jarkwarajǝg kǝ nǝg kǝ zǝrɓǝlǝgah biya. Dǝgiti ɓagan naiya, batwatswatsǝra ka dagal kǝskai damma haaya Arabiya, tǝhalakwaha ka gwiya saas kǝskai damma Dimasku. ");
INSERT INTO glwl_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","Danal tǝhala viig hǝkǝrǝɗ damma wurshalima da nǝgha Kefas kwa ɗahav dǝ Siman Bitrusa. Ən ɓaga kǝ hǝngah kǝlawa tar dlǝɓ ǝmtaɗ dǝ iina. ");
INSERT INTO glwl_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","Nǝghana bi nai aanji ba pall ma zǝrɓǝlǝgah biya, ba Yakub zǝra babba Yaazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","Dǝgiti ǝn viindkurnai na bak jiijiira tǝ vuukwa Daadamazhigǝla, fiid bi wan tagkur nai biya. ");
INSERT INTO glwl_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","Tǝhalakwaha, kaa dagal kǝskai damma haaya Suriya ard Kilikiya. ");
INSERT INTO glwl_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","Ma sarta kwahiina, dlamakǝlaaa lii gata Kristi kwar ma Yahudiya, sǝrarkwaka biya. ");
INSERT INTO glwl_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","Cinngara bad cinng taakiya, “Daddakwa ndza vǝlakiyam dlaɗ ba wurwur na, ǝn wan ndakwan taa ǝlɓǝga fadghǝrǝn kwa ndza badza da nǝ iin wur na!” ");
INSERT INTO glwl_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","Kaa gala Daadamazhigǝl kǝ iitǝr mbakyarvad dǝgiti ɓaga nǝ iin tǝdvad kaiya. ");
INSERT INTO glwl_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","Tǝhala viig kǝlawa tar uufaɗa kaa gwiya dagal kǝskai damma wurshalima. Ma sarta kwahiina, danal ǝmtaɗ dǝ Barnabasa ard Titusa. ");
INSERT INTO glwl_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","Marghwada ma sǝng nǝ Daadamazhigǝl taakiya dǝgama. Danal ba nai da vaakwahiina, kaa fǝgaafǝg kǝskai kǝ dzaghǝr dǝ kyalǝma maalaha dlamakǝlaaa lii gatǝga, kaa tagtǝrtag kǝskai kǝ ɗuuli ǝn tagtǝr nai kǝ ǝlbǝg marawa kǝ uudahi kwar Yahudah biya. Ba iitǝr pall wa tagantǝr nai kǝ ǝlǝbǝga, aɗaba aa nal bi nǝ fa ndzǝɗar ma tlǝr kǝ gyaagyan biya. ");
INSERT INTO glwl_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","Titus tsahgwa dagalara, wa ba zhiila Hellas nǝ iina, maay wa fǝghara barari kǝ ɓagara aguvac biya. ");
INSERT INTO glwl_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","Əlǝbǝga kwa ciyǝt tǝghǝr kǝ ɓa aguvaca, ciyǝr mbakyarvad zaraabaha fiidfiida kwa saraghan siɓasiɓana, saraghan kwakyarvad ar badzǝdan kǝ kwara ghǝrǝn kwa kiyam dǝ vakai nǝ miyam tǝdvad Kristi Yesu. Ar naa nǝkiyamdadal kǝ ɛvaha. ");
INSERT INTO glwl_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","Kǝm haitǝrant bi aanji ba hǝɗiikǝn biya, kǝm na tsufant kǝ jiira ǝlbǝg maraw kiyavaruwa. ");
INSERT INTO glwl_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","Uudahan kwa tagav taaiya ar mamaalahna, fararaa bi nǝ iitǝr aanji ndau tǝghǝr kǝ dǝgiti kwan tsag nai biya, man zharǝg naiya aanji ar hulfa kwar kǝ uudah nǝ iitǝra ba dǝgit pall vakara, aɗaba maay nǝ Daadamazhigǝl fa dagar ma uudah biya. ");
INSERT INTO glwl_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","Dlakulvakwaha, nǝgharanǝghǝg kǝ ɗuuli fǝghwaɗǝm nǝ Dadamazhigǝl kǝ tlǝra taa ǝlbǝg maraw kǝ lii ɓagavtǝra bi na aguvac biya, bandkwa favɗǝm ma dǝv kǝ Bitrus nǝ taa ǝlbǝg maraw kǝ Yahudah kwa ɓagavtǝraɓag nǝ aguvaca. ");
INSERT INTO glwl_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","Ba Daadamazhigǝl kwa ɓagaa tlǝr ma ǝrviɗmahuɗa Bitrus kiyava nǝg kǝ zǝrɓǝlǝga Yesu da vak Yahudaha, ba iin dlaɓ wa ɓagaa tlǝr ma ǝrviɗmahuɗar kiyava nǝg kǝskai kǝ zǝrɓǝlǝg Yesu da vak lii ar Yahudah biya ");
INSERT INTO glwl_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","Marghwada ba nǝ Daadamazhigǝl kǝ herǝraana, az Yakuba, Bitrusa, ard Yuhwana, lii favtǝra nǝ ɓa tlǝra maalǝr tǝghǝr kǝ dlamakǝlaaa lii gatǝga, kaa caukǝmndacaug kǝ iitǝr baz kaiya baz Barnaba bad ǝrviɗmahud palla. Haiyamndanthaig dǝ ghǝramnd taakiya kǝm dagal da vak lii ar Yahudah biya, iitǝr dlaɓa ar da vak Yahudaha. ");
INSERT INTO glwl_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","Ar dzamkǝmdant taakiya aa viya bi mǝlgaru kǝ talagah biya, aɗaba kaiya ba dǝgiti ndzan kǝmǝg nai ba wurwur wana. ");
INSERT INTO glwl_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","Ma sarta kwa sahi nǝ Bitrus damma Antakiya, kaa tagartag kǝskai kǝ ǝlbǝg bamma gyi ma gyiya kwakyarvad haipan bat ɓalaɓala. ");
INSERT INTO glwl_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","Ma zǝngwǝra, ndza zǝgan kǝ kaf ǝmtaɗ dǝ yaa dadda gatǝga kwar Yahudah biya. Tǝhalakwa ɓǝlatǝrǝt ba nǝ Yakub kǝ kyalǝmah damma Antakiya, kaa hǝzhahǝg kǝ Bitrus daghuvana. Ɓagaɓag nǝ iin kwana mbakyarvad gǝdza lii na ɓagǝvtǝra nǝ aguvac kǝ lii ar Yahudahǝn biya. ");
INSERT INTO glwl_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","Ɓagara bandkwah dlaɓ nǝ kyalǝma lii gata Yesu ma Yahudah kǝ muuniya band Bitrusa, viyardǝmvig baz ghǝra Barnaba damma muuniyǝra. ");
INSERT INTO glwl_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","Nǝghanaka ba nai ar maay ɓa dǝgatǝr tǝ ɗuula jiira ǝlbǝg maraw biya, aiyamai kǝ Bitrus tǝvuukwa uudah baɗǝma, “Kǝgha agha zhila Yahudaha, agha ɓa ndzǝgan bandkwa ɓag nǝ lii ar Yahudah biya, maay ǝndkwa ɓa nǝ yaa Yahudahi. Aujilbǝg agha fǝtǝra barari kǝ lii ar Yahudah bi kǝ gata dǝ Daadiija Yahudahi?” ");
INSERT INTO glwl_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","Bak jiijiira kiyam Yahudah nǝ miyam tǝdvad yiiga, kiyam lii ar Yahudah biya ma yaa dadda haipah biya, ");
INSERT INTO glwl_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","kiyam sǝrgasǝrǝg taakiya tlǝkǝna bi nǝ uud kǝ ndzǝgan kwal haip tǝvuukwa Daadamazhigǝl tǝdvad gata tsaga adzahadzaha Muus biya, bamma fǝdghǝrǝtfǝg nǝ uudan tǝ Yesu Kristiya. Mbakyarvad kwaha famdǝghǝrǝtfǝg ghǝravamnd tǝ Kristi Yesu. Ɓagamndaɓag kwana kwakyarvad kǝm tlǝkǝna kǝ ndzǝgan kwal haip tǝ vuukwa Daadamazhigǝl tǝdvad fadǝghǝr tǝ Kristiya tǝdvad tlǝraha tsaga adzahadzah Muus biya. Aɗaba maay wa tlǝkǝna ndzǝgana kwal haip tǝ vuukwa Daadamazhigǝ tǝdvad tsaga adzahadzaha Muus biya. ");
INSERT INTO glwl_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","Akwama nalnǝg taakiya kiyam na tlǝkǝna kǝ ndzǝgana kwal haip tǝvuukwa Daadamazhigǝl tǝdvad fadǝghǝr tǝ Kristiya, kaa tlǝkiyamatlǝg nǝ uud kǝ ghǝravamiyama dǝ haipa, aitsa, maradamarǝg wan taakiya tlǝra Kristi haighanthaig dǝ haipa? Əndkwah biya! ");
INSERT INTO glwl_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","Akwama gwiya ndǝranantndǝrǝg kǝ dǝgiti dlagana nai wura nanalnǝg kǝ dadda kǝla adzahadzaha. ");
INSERT INTO glwl_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","Tǝdvad tsaga adzahadzaha Muusa ǝmtsanaǝmtsǝg kwakyaevad adzahadzaha, kiyava ndzǝgan kǝkai kǝ Daadamazhigǝja. ");
INSERT INTO glwl_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","Hǝrtakuthǝrtǝg nǝ uud ǝmtaɗ dǝ Kristiya. Ndakwana kai bi wa ndzǝgan dǝ ghǝrar biya, Kristi wa ɓa ndzǝgan ma kaiya. Kwan kǝ ndzǝganǝn ɓa naiyna, ndzǝgan tǝdvad fadǝghǝr tǝ Zǝra Daadamazhigǝla, kwa waiyakutwaiga vǝladavǝlǝg kǝ shifǝgan mbakyarvad kaiya. ");
INSERT INTO glwl_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","Ən vinabi kǝ herǝrra Daadamazhigǝl biya. Akwama tlǝkǝnatlǝg nǝ uud kǝ ndzǝgana kwal haip tǝvuukwa Daadamazhigǝl tǝdvad gata nadzahadzaha Muusa, maradamarǝg wan taakiya ǝmtsǝga Kristiya mbats nalnǝg bak gyagyaana. ");
INSERT INTO glwl_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","Kuram Galantiyaha, am dlagaha? Aa da nau kǝ hǝnkalaruwi? Tangankur bat ɓalaɓal naiy kǝ ǝlbǝg tǝghǝr kǝ Yesu Kǝristi kwa ǝmtsaa tǝ tlaɓa hǝrtǝga. ");
INSERT INTO glwl_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","Ən naa ndavkuru ndavǝg palla. Cauwama mbakyarvad am gataa adzahadzaha Muus nǝ uuram kǝ Shiɗkwa Daadamazhigǝl nii, cauwama mbakyarvad famdghǝrǝtfǝg tǝ ǝlbǝgi cinngama nǝ uuram hi? ");
INSERT INTO glwl_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","Hulfa kwar kǝ dlagǝr wam dǝ vakai nǝ uuramni? Famarzha dǝ Shiɗkwa Daadamazhigǝla, iin wan kwan ndakwana am naa ghyǝng dǝ dǝgiti naag nǝ ghǝraru kǝ ɓagaana! ");
INSERT INTO glwl_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","Mbats dlaɗahan huɓamuu nǝ uuram shahshahǝn nalnǝg ba gyagyaana? ");
INSERT INTO glwl_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","Ən gwiiya ndavkurundavǝga, mam tlatlǝg nǝ uuram vǝlakurvǝlǝg nǝ Daadamazhigǝl kǝ Shiɗkwan ma kuuram kiyava ɓa dǝgaha jappǝr kwakyarvad am gata tlǝri tsag na adzahadzaha Muus nii, mbakyarvad cinngamacinng kǝ ǝlbǝg Kǝristi am fǝdghǝrǝt tǝ iin hii? ");
INSERT INTO glwl_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","Bandkwah nǝ Ibrahim “fǝdghǝrǝtfǝg tǝ Daadamazhigǝla, kǝdlǝgharnakǝdlǝg nǝ Daadamazhigǝl kǝ iin kǝ kwan uuda jiirjiira.” ");
INSERT INTO glwl_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","Nǝghamakanǝghǝg kwan, taakiya, lii dǝ fadghǝra iitǝr nǝ zarha Ibrahima. ");
INSERT INTO glwl_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","Vinndavinndan ma kakaɗa Daadamazhigǝl ba wur taakiya, lii ar Yahudah biya ar datlǝkǝnatlǝg kǝ nǝg kǝ uudah jiirjiir tǝ vuukwa Daadamazhigǝl tǝdvad fadghǝra. Aɗaba tagavar ba wur nǝ ǝlbǝg maraw kǝ Ibrahim taakiya, “Ar da tlǝkǝna tǝdvad kǝgh nǝ lii ar Yahudah bi kǝ barka.” ");
INSERT INTO glwl_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","Mbakyarvad kwaha, lii dǝ fadghǝra da vǝlvǝtǝrvǝlǝg nǝ bark ǝmtaɗ dǝ Ibrahim dadda fadghǝra. ");
INSERT INTO glwl_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","Aɗaba baɗǝm nǝ lii tlatla taaki da cautǝrcaug nǝ Daadamazhigǝl kwakyarvad ar gata adzahadzaha Muusa. Ar tlafatlatana. Aɗaba vinndavinndan ma kakaɗa Daadamazhigǝl taakiya, “Baɗǝm daddakwa ɓagaa bi kǝ dǝgitahi vinndavinndan ma kakaɗa adzahadzaha Muus biya, tlafatlafan nǝ iina.” ");
INSERT INTO glwl_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","Salsǝg ba dat ɓalaɓal, taakiya, maay wa nǝgalnǝg kǝ uuda jiijiir tǝ vuukwa Daadamazhigǝl tǝdvad gata tsaga adzahadzaha Muus biya, aɗaba vinndavinndan taakiya, “Uuda jiirjiira, da tlǝkǝnatlǝg kǝ shifǝg tǝdvad fadghǝra.” ");
INSERT INTO glwl_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","Adzahadzaha Muusa shah nǝ iin dǝ fadghǝra, bandkwa vinndavinndan taakiya, “Daddakwa ɓagaɓag baɗǝm kǝ dǝgitahi tagava ma adzahadzaha Muusa, da tlǝkǝnatlǝg kǝ shifǝg tǝdvad iina.” ");
INSERT INTO glwl_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","Ngǝdlakiyamangǝdlǝg nǝ Kǝristi sagal ma tlafǝga adzahadzaha Muusa, navdalnǝg tsau kǝ dǝga tlafǝg kǝskǝmyama. Aɗaba vinndavinndan ma kakaɗ taakiya, “Baɗǝm nǝ daddakwa hǝrtǝvǝt tǝ gugyǝmba dakara, tlafatlafan nǝ iina.” ");
INSERT INTO glwl_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","Varakiyamndavarǝg nǝ Kǝristi mbakyarvad barkǝn vǝlavar kǝ Ibrahim, iin wa tlakǝna kǝ lii ar Yahudahǝn bi tǝdvad Kǝristi Yesu. Bandkwah ghǝrava miyama, kiyam da tlǝkǝna tǝdvad fadghǝr kǝ Shiɗkwa Daadamazhigǝl kwa takiyama nǝ iin kǝ langyiyaana. ");
INSERT INTO glwl_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","Zaraabaha ard ǝnghwasaha, ǝn vǝlkurvǝlǝg kǝ garava dǝgiti namǝtnǝg nǝ uuram kǝ ɓagaana. Akwama nguɗarantnguɗǝg nǝ uudah bu kǝ langyiya dlaɓa ar fǝdǝm kǝ dǝva kiyava fǝdghǝrǝtfǝg tǝ vakaiya, maay nǝ daddakwa masdamasǝg biya dlaɓa maay daddakwa fǝgarnafǝg kǝ dǝgit tǝghǝr biya. ");
INSERT INTO glwl_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","Tǝgharatǝg nǝ Daadamazhigǝl kǝ langyi kǝ Ibrahim ard hulfaana. Vinndabi taakiya, “dǝ hulfah biya” kwa maradamarǝg mandki ar ba dyak biya, ǝndkwah biya, “hulfagha” am nǝ uud taa kǝ iina, ba uud palla, kwa iin nǝ Kǝristiya. ");
INSERT INTO glwl_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","Dǝgiti ǝn tlatlǝg naiya iin wana, tǝgharatǝg nǝ Daadamazhigǝl kǝ langyi kǝ Ibrahim dlaɓa maradamarǝga. Adzahadzaha Muus savda tǝhala viig dǝrmǝk uufaɗ dǝ kulhǝkǝrɗa, nǝdalbi kǝ langyi kwa taa nǝ Daadamazhigǝl ba wur kǝ maay nǝ tlǝran biya. ");
INSERT INTO glwl_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","Akwama tlǝkǝna tǝdvad gata adzahadzaha Muus nǝ uud kǝ gwiiga barka vak Daadamazhigǝla, mbats ma tlǝvkǝna bi tǝdvad langyi biya. Aɗaba tlakǝna tǝdvad langyi nǝ Ibrahim kǝ bark vak Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","Akwama bandkwah ci tsaa, savdagha kwakyarva dau nǝ adzahadzaha Muusi? Favarna kiyava ɓa tlǝr kǝ uud dǝ adzahadzaha Muus tangw damma sarta kwa da sii nǝ hulfa Ibrahim kwa tavara nǝ langyi mbakyarvad iina. Vǝlavda tǝdvad Zǝrɓǝlgah nǝ adzahadzaha Muus kiyava daddakwa ghaciga mataataka Daadamazhigǝla ard uuda. ");
INSERT INTO glwl_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","Maay nǝ tlǝra ghacig mataataka akwama ba uud pal biya, aɗaba Daadamazhigǝl ba palla. ");
INSERT INTO glwl_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","Mbats Adzahadzaha Muus ɓa tlǝghum dǝ langyiya Dadamazhigǝli ciya? Maay ǝndkwah biya! Akwama mǝng nǝ kwatlǝrn kǝ Adzahadzah kwa da vǝlkiyam daala shifǝga, ma tlǝvkǝnatlǝg nǝ jiira Daadamazhigǝl tǝdvad gata Adzahadzaha Muusa. ");
INSERT INTO glwl_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","Aɗaba vinndavinndan ma kakaɗa Daadamazhigǝl taakiya, baɗǝm nǝ duniya mazhangyil kǝ kwarga haipa. Kwakyarva cauyamacaug kǝ langyiya Dadamazhigǝl tǝdvad fadghǝr tǝ Yesu Kǝristi, da vǝlǝvtǝrvǝlǝg kǝ lii fardǝghǝrǝtfǝga. ");
INSERT INTO glwl_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","Lakwti sagau nǝ fadghǝra, ndza kiyam ngangan band ɛɛv mazhagil kǝ kwarǝg adzahadzaha, da ɓaga ba sarta marazha fadghǝra. ");
INSERT INTO glwl_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","Mbats ndza adzahadzaha Muus wa ndza markiyam ɗuula, da sahi ba nǝ Kǝristi wa tlǝyamkǝna nǝ miyam kǝ ndzǝga kwal haip tǝvuukwa Daadamazhigǝl tǝdvad fadghǝra. ");
INSERT INTO glwl_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","Sǝv ba nǝ fadghǝr ndakwana, kiyam madlabi mizhadǝva adzahadzaha Muus biya. ");
INSERT INTO glwl_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","Aɗaba baɗǝmaru am zarha Daadamazhigǝl tǝdvad fadghǝr ma Kǝristi Yesu. ");
INSERT INTO glwl_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","Ɓagakuraɓag nǝ uud kǝ tsuufǝg baɗǝmaru ma Kǝristi, dlaɓa fǝkurǝm nǝ uud kǝ sǝɗava Kǝristi ");
INSERT INTO glwl_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","Mbakyarvad kwaha, madlabi taakiya Yahud waha Kǝrdi wah biya, ma zǝra hǝnyaha ma ɛɛv biya, ma uus waha ma ghwalǝv biya, badǝm am ba dǝgit pall ma Kǝristiya. ");
INSERT INTO glwl_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","Akwama am dǝga Kǝristi nǝ uurama, namalnǝg kǝ kuɗǝga Ibrahima, lii da caawa dǝga gwiiga tǝdvad langyiya. ");
INSERT INTO glwl_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","Ma sarta kwa ba zarh nǝ dadda gwiiga, ba kalkal nǝ iin da ɛva, aanzdu ba dǝgan nǝ dǝgit hǝnyah baɗǝma. ");
INSERT INTO glwl_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","Dadda gwiigǝn ba miizhadǝva lii hǝkyǝgana tangw damma sarti fa nǝ daddaana. ");
INSERT INTO glwl_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","Bandkwah nǝ miyama lakwti sagau nǝ ɗuula Kristiya. Ndza kiyam band ɛvah vak ndzǝɗa tlǝksǝra duniya. ");
INSERT INTO glwl_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","Ɓagaa ba nǝ righǝga sarta kwa fa nǝ Daadamazhigǝla, kaa ɓǝldiɓǝlǝg nǝ Daadamazhigǝl kǝ Zǝraana, sahi tǝdvad uusa. Favɗǝm mazhagyil kǝ adzahadzaha Muus bamma sarta yiigaana, ");
INSERT INTO glwl_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","mbakyarvad vartǝrdan kǝ lii miizhagyil kǝ adzahadzaha Muusa, natǝrdalnǝg kǝ zarha Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","Aɗaba am zarhaana, ɓǝladiɓǝlǝg nǝ Daadamazhigǝl kǝ shǝdkwa zǝran damma ǝrviɗmahuɗaruwa, Daadamazhigǝl taakiya, “Abba! Daada!” ");
INSERT INTO glwl_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","Agha madla bi nǝng ɛv biya, agha zǝra Daadamazhigǝla. Nǝghalnǝg tsau kǝ zǝra, nakadalnǝg nǝ Daadamazhigǝl kǝ dadda gwiiga. ");
INSERT INTO glwl_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","Ndzam sǝrgai kǝ Daadamazhigǝl wurwur biya, ndzam ɓagar kwatǝnahǝr kǝ ghǝllaha kwa ɓagaa nǝ uuda. ");
INSERT INTO glwl_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","Aɗaba ndakwana am sǝrgasǝrǝg kǝ Daadamazhigǝla, dlaɓa sǝrkwursǝrǝg nǝ Daadamazhigǝla, am gwiya da mǝr dlaɓ miizhagyil kǝ kwarǝg ndzǝɗa duni kwa maay nǝ tlǝran biyi? Aujilɓǝg dlaɓ am gwiya na nǝg kǝ ɛvaha tǝri? ");
INSERT INTO glwl_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","Am vǝldavǝlǝg kǝ ghǝraru kǝ tsuufa kyalma hǝngaha ard kyilaha, ard sartaha, ard viigaha. ");
INSERT INTO glwl_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","Ən gǝdzǝkurgǝdzǝga, aɗaba mandki baɗǝm nǝ dlaɗi ǝn huɓǝg nai tǝghǝr kǝskuuramna nalnaǝg ba gyaagyaana! ");
INSERT INTO glwl_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","Ən ghalakuuram zaraabahara, namalnǝg band kaiya. Aɗaba kai ndakwani mana nal band kuurama. Ɓagamwi bi nǝ uuram kǝ haip biya. ");
INSERT INTO glwl_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","Am sǝrgasǝrǝg taakiya yang biyin ɓagana naina, iin wa wurghwant ɗuua lankur ǝlbǝg maraw ba zunngwa. ");
INSERT INTO glwl_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","Aanji ba sakurdaasǝg kǝ damuuw nǝ yangbiyin ɓaga na naina, bakǝvakwaha nenǝmkwi biya dlaɓa lamwabi kǝ fa hyǝmi tǝ kai biya. Caawamkwicaug band zǝrɓǝlgah ma ghǝrazhigǝla, band kwa caawama nǝ uuram kǝ Kristi Yesu dǝ ghǝraana. ");
INSERT INTO glwl_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","Ndzam dlaiga ba vaivaiy ma sartiina! Ən hwaɗag nai ndkwana mbakyarvad cinngamwanacinga? Ən sǝrgasǝrǝg nai ma sartakwahiina aanji ba zǝra gyiyaharu ndkwani ma taɗamdataɗǝg am vǝlwana! ");
INSERT INTO glwl_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","Mbats nanalnǝg nai kǝ tlǝghumaru ndakwan kwakyarvad tagankurtag kǝ jiira? ");
INSERT INTO glwl_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","Kwanahan kǝ uudaha ar kǝma ndzǝgan dǝ kuurama, dǝgiti ar tlatlǝg nǝ iitǝra ba ghawɗa. Ar naa tagkwiyamtagwa ǝmtaɗa, mbakyarvad ar viyǝt kǝ hǝnkalaru baɓǝm da vakatǝra. ");
INSERT INTO glwl_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","Maraw nǝ kǝma hulfa ndzǝgan ǝndkwana. Aa ɓagarɓag ba kǝlahǝng bandkwana, ba mar nǝgha kai vakaru nǝ iitǝr biya. ");
INSERT INTO glwl_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","Kuuram zaraabahara, nalnǝg kǝ dǝga bu wan kǝskai ǝn cinnga dlaɗa yiig kǝ urama. Dlaɓa ǝn za ba vuuk dǝ kwanǝn kǝ dlaɗa bamma ndzandzǝg nǝ hǝnkala Kristi ma ǝrviɗmahuɗaruwa. ");
INSERT INTO glwl_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","Akwamana ba ǝmtaɗ dǝ kuurama ndakwana, mana mbǝɗanǝn kǝ kunghyara. Aɗaba ǝn dzama ghǝr ba vaivai mbakyarvad kuurama. ");
INSERT INTO glwl_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","Tagamwataga, kuuramǝn am gata ba adzahadzaha Muusa, nǝghamakanǝghǝg dǝ dǝgiti tsag na adzahadzaha? ");
INSERT INTO glwl_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","Aɗaba vinndavinndan taakiya Ibrahim ndza dǝ zarh buwa ghwalvaha, palla yava tǝdvad uusa kwa ɛva, pall dlaɓa tǝdvad uusa kwa kwara ghǝraana. ");
INSERT INTO glwl_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","Zǝran kwa yava dǝ uusa ɛva, tlakǝna band kwa tlǝfkǝna nǝ zarha. Kiyava zǝran kwa yava dǝ uusa kwa kwara ghǝraana yava tǝdvad langyi kwa tǝghara nǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","Kwan kǝ garava ǝmghwasahaana, iin nǝ langyi buwa. Hagar iin wa yaa ɛva. ");
INSERT INTO glwl_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","Hagar wa nalnǝg kǝ garava Aghwa Sinai kwa ma haaya Arabiya. Iin nǝ garava kǝsa Wurshalima ndakwana, aɗaba iina ard zarhaana ar ba ɛvah baɗǝma. ");
INSERT INTO glwl_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","Aɗaba Wurshalima kwa ma ghǝazhigǝla dǝ kwara ghǝra, dlaɓa iin baabamiyama. ");
INSERT INTO glwl_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","Vinndavidan taakiya, “Ɓag kǝ hwaɗaga kǝgh uusa kwa yigha bi kǝ zǝr biya, Agha tlǝhga hwaɗaga mbakyarvad tapghanabi kǝ dlada yaa zǝr biya, aɗaba zarha uusa kwa ɗuughars nǝ zhiilana ɓagaraɓag ba dyeka. Jaruujig kǝ zarha uusii dǝ zhiilaana.” ");
INSERT INTO glwl_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","Aiciya, zaraabahara, niyamalnǝg ghǝravamiyam kǝ zarha Daadamazhigǝl tǝdvad langyiya band Ishaku. ");
INSERT INTO glwl_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","Ma sartakwahiina zǝrǝn yava band kwa yahav nǝ zarha vǝlgharvǝlǝg kǝ dlaɗ kǝ zǝrǝn kwa yava tǝdvad ndzǝɗa Shiɗkwa Daadamazhigǝla. Bandkwah dlaɓ tangw dat hiinana. ");
INSERT INTO glwl_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","Vinnɗavinnɗan ma kakkaɗa Daadamazhigǝl taakiya, “Lagwdalagw kǝ uusǝn ɛvana ard zǝraana, aɗaba zǝrǝn yava dǝ ɛvana da maay tagwa dǝga gwiig ǝmtaɗ dǝ zǝra uusǝn kwa kwara ghǝrǝn biya.” ");
INSERT INTO glwl_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","Mbakyarvad kwaha zaraabahara, kiyam zarha uusiin kwa ɛva biya, kiyam zarha uusǝn kwa dǝ kwarǝga ghǝra. ");
INSERT INTO glwl_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","Kwakyarvad ndzǝgana kwara ghǝra iin wa ngǝdlakiyam nǝ Kristi. Mbakyarvad kwaha ghacamaghacǝg bad ndzǝɗa, gwiya vǝlambi dlaɓ kǝ ghǝraru da mazhagyil kǝ zuukiya ɛva biya. ");
INSERT INTO glwl_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","Aiciya, cinngamcinnga, kai Bulus wa tagkur kwana, akwama haiyamanthaig ɓagkuraa nǝ uud kǝ aguvaca, mbats maay nǝ tlǝra Kristi vakaru biya. ");
INSERT INTO glwl_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","Ən gwiya ba tagkurtag taakiya, baɗǝm daddakwa haiganthaig gata adzahadzaha ɓa aguvaca, nalnǝg barari gatǝgaan kǝ adzahadzaha muus baɗǝma. ");
INSERT INTO glwl_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","Kuuramǝn am ɓa kǝlandzǝɗaru kǝ tlǝkǝna nǝg kwal haip tǝvuukwa Daadamazhigǝl tǝdvad gata adzahadzaha Muusa, samdalsǝg kǝ ghǝraru ma gata Kistiya. Tǝrɗamatǝrɗǝg tǝ herǝra Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","Aɗaba tǝdvad Shiɗkwa Daadamazhigǝla ard fadghǝra, nǝ wa kiyam pakkǝg nǝ miyam dǝ fantaar kǝ tlǝkǝna jiijjira. ");
INSERT INTO glwl_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","Aɗaba ma kiiyam dǝ Kristi Yesu nǝ miiyama, aanji ɓagakaɓag nǝ uud kǝ aguvaca, aanji ɓagakaabi nǝ uud biya, maay tlǝran vakamnd biya. Dǝgiti maraw vakamnda, iinfadghǝra kwa mara ghǝran tǝdvad waiyakǝvǝra. ");
INSERT INTO glwl_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","Ba zunngw am za vuuk ba vaivaiya. War wa tsakurva kǝ gata dǝga jiijiii? ");
INSERT INTO glwl_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","Hulfa kwan kǝ valla uuda sahi vak Daadamazhigǝl kwa ɗahakurǝtɗahǝg biya. ");
INSERT INTO glwl_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","Bandkwa tagavdan taakiya, “Zǝr yisti ba hǝɗiikǝn wa fǝgara ciig kǝ bǝruudiya.” ");
INSERT INTO glwl_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","Mbakyarvad hweɗa miyam ma Kristiya, fandghǝrfǝg naiy taakiya am maay gata kwatlǝrn kǝ ǝlbǝg shah dǝ dǝgar biya. Daddakwa na ciya hǝnkalaruwa da vǝlvarvǝlǝg nǝ dlaɗa, aanji ba war nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","Zaraabahara, akwama gwastaan ǝn taa ba ǝlbǝg marawa tǝghǝr kǝ ɓa aguvac naiya, aujilɓǝg kaci kǝ uudaha gwastaan ar vǝlgwa ba dlaɗi? Akwama bandkwaha, ǝlɓǝgar tǝghǝr kǝ ǝmtsǝga Kristi tǝ tlaɓa hǝrtǝga nalbi kǝ dǝga mɓǝɗa uud tǝ ɗuul biya! ");
INSERT INTO glwl_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","Lii ar ciya hǝnkalaruna, ngulǝm mara datlant kǝ ghǝratǝra! ");
INSERT INTO glwl_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","Zaraabaha, ɗahakurantɗahǝg nǝ uud kiyava kwaraghǝra. Famfǝg kǝ kyǝmiya analbi nǝ kwaraghǝraru kǝ dǝga ɓa dǝgiti naag nǝ vǝgh biya. Dlakulvakwaha ɓagamɓag kǝ tlǝr dǝ kwaraghǝraru am waigan kǝ zaraabaharuwa. ");
INSERT INTO glwl_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","Aɗaba baɗǝm tsagaana adzahadzaha Muusa ghaca bad dǝgit palla kwa taakiya, “Waiga kǝ zǝraabagha band ghǝragha.” ");
INSERT INTO glwl_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","Akwama am zavǝghad zaraabaharuwa dlaɓa am hadzakava, famfǝg kǝ hǝnkala, badzamdabi kǝ ghǝraru biya. ");
INSERT INTO glwl_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","Naagara, ɓagamɓag kǝ ndzǝgani naag nǝ Shiɗkwa Daadamazhigǝla. Akwama ɓagamaɓag ǝndkwana, am maay gata ndzǝgana vǝgh biya. ");
INSERT INTO glwl_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","Aɗaba ndzǝna vǝgha haigant bi dǝ Shiɗkwa Daadamazhigǝl biya, shiɗkwa Daadamazhigǝl dlaɓa haigant bi dǝ ndzǝgana vǝgha biya. Kwanaham kǝ hǝnkal buwaǝna ar ɓa tlǝghum dǝ ghǝrahatǝra. Iin wam ɓagǝnabi nǝ uuram kǝ dǝgiti am naag nǝ uuram kǝ ɓagan biya. ");
INSERT INTO glwl_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","Akwama Shiɗkwa Daadamazhigǝl wa ɓa tlǝr dǝ kǝ uurama, am mazhagil kǝ tsaga adzahadzaha Muus biya. ");
INSERT INTO glwl_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","Tlǝrahi kwa ɓag nǝ ndzǝgana vǝgha maradamarǝg ba tǝ ɓalaɓala. Iitǝr nǝ ɓa kuuya, ɓa gwaragwara, ard gata cinnga ǝmtakǝra kwa dǝga tsa zhiruwa, ");
INSERT INTO glwl_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","ard ɓa kwatǝnahǝr kǝ ghǝlla, ard uukya, ard naabi kǝ zǝraaba, uushava, sǝlga kǝ zǝraaba, nguɗa ǝrviɗmahuɗa, naa ghǝra, ard tlakwatsiga, ");
INSERT INTO glwl_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","ard sǝlga ard tsǝg nǝ kya, ard hulfa tǝr baɗǝma. Ən ɓǝlkur kǝ kiiɓa ndaiga, band kwa tangankur nai ba wurwur taakiya lii ɓa hulfa kwanahan kǝ dǝgita ar da tlǝkǝnabi kǝ dǝga gwiig ma tlǝksǝra Daadamazhigǝl biya. ");
INSERT INTO glwl_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","Dǝgiti vǝlǝg nǝ Shiɗkwa Daadamazhigǝla iin nǝ waiyakǝva, ard panahnaha ǝrviɗmahuɗa, ard gabǝrǝra, ard fa ǝrviɗmahuɗa, ard jiira, ");
INSERT INTO glwl_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","ard kalaliya ard agha ɗuuwant kǝ dǝgiti naag nǝ vǝgha. Lii ɓa hulfa kwan kǝ dǝgitaha da maay tǝvtǝr nǝ shari biya. ");
INSERT INTO glwl_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","Baɗǝm nǝ lii dǝga Kristi Yesu hǝrtarǝthǝrtǝg kǝ tlǝra vǝgha ard dǝgitah shahshah kwa naag nǝ vǝgha. ");
INSERT INTO glwl_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","Vǝlakiyamvǝlg tsau ba nǝ Shiɗkwa Daadamazhigǝl kǝ shifǝga, aa ɓa nǝ Shiɗkwa kǝ tlǝr dǝ kǝmyam ma ndzǝgana miyam baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","Niyamalbi kǝ lii dǝ dǝkdǝka ghǝr biya, bi lii ciya hǝnkala zaraabah biya, bi lii naabi kǝ zaraabah biya. ");
INSERT INTO glwl_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","Zaraabahara, akwama nǝghamanǝghǝg kǝ uuda ma haipa, kuuramǝn am ndzǝga ma Shiɗkwa Daadamazhigǝlna, am gwidan kǝ uuda nǝ iin dat ɗuula. Famfǝg kǝ hǝnkala, anabi dlaɓ dlakulva saa dǝ zarab dat ɗuula agha dǝm damma fishǝg biya. ");
INSERT INTO glwl_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","Mǝlamarumǝlǝg kǝ zaraabaharu tǝdvad kǝsa dlaɗa kyalmaha. Am da righǝg ǝndkwan kǝ adzahadzaha Kristi. ");
INSERT INTO glwl_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","Akwama tlatlǝgan nǝ uudan taakiya mǝng nǝ dǝgit tuuk vakai nǝ iina, mbats maay nǝ dǝgiti tuuk vakai nǝ iin biya, valaba ghǝraana. ");
INSERT INTO glwl_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","Aa zharnazharǝg nǝ uudan kǝ tlǝrani ɓag nǝ iin ndana. Akwama ba marawa, lakwti da tiɗa fiɗavǝgh dǝ dǝgiti ɓagaa nǝ iin dǝ ghǝrana, bamma gǝra ghǝran dǝ uudi tlǝrn biya. ");
INSERT INTO glwl_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","Aɗaba ɓagaɓag kǝ maraw aanji bawara akǝsǝg kǝ kadlanga ghǝraana. ");
INSERT INTO glwl_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","Baɗǝm nǝ daddakwa tsagǝvaru nǝ ǝlbǝga Kristiya aa tagwnatagw kǝ dǝgaha harǝr baɗǝm dǝ daddakwa tsagarutsaga. ");
INSERT INTO glwl_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","Valamndabi kǝ ghǝraru biya, ɓagabi marvara nǝ ɗyǝmɗyǝmǝr kǝ Daadamazhigǝl biya. Badǝm nǝ dǝgiti aa riiga nǝ uuda, iin wa da ghudǝg nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","Aɗaba ma riyarig nǝ uudan dǝ naaga ǝrviɗmahuɗaana, da ghuɗǝgan kǝ ǝmtsǝga. Akwama aa riiga dǝ naaga shiɗkwa Daadamazhigǝla, da ghuɗǝgan kǝ shifǝga tangwa damma zǝrazǝra. ");
INSERT INTO glwl_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","Mbakyarvad kwaha kuɗǝyamalbi dǝ ɓa dǝgit maraw biya. Aɗaba akwama kuɗǝyamalbi, kǝ ɓagan biya, da sagau nǝ sarta kwa kiyam da ghuɗǝg nǝ miyam kwa dǝ barka. ");
INSERT INTO glwl_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","Mbakyarvad kwaha, ba kǝla sarti kiyam tlǝkǝna nǝ miyam kǝ ɗuula ɓagaana, mǝlamarumǝlǝg kǝ uudah baɗǝma, kyambar zaraabahamiyami kwama Krǝstiya. ");
INSERT INTO glwl_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","Zharamzharǝg kǝ hulfa vinɗǝgahan dyakdyakǝn vindankura nai dǝ dǝvara. ");
INSERT INTO glwl_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","Aiciya uudahanǝn ar na ba ma cingaba dǝgatǝr nǝ uudna, iitǝr wana fǝkura barari ɓakura nu uud kǝ aguvaca. Ar ɓakur kwana aɗaba ar gǝdza dlaɗǝn ar da huɓǝg nǝ iitǝr mbakyarvad hǝrtǝga Kǝristiya. ");
INSERT INTO glwl_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","Aanji ba lii ɓagavtǝraɓag nǝ aguvac ndakwani ar maay tsuufa adzahadzaha Muus biya. Ar naa ba ma ɓakura nǝ uud kǝ aguvaca kiyava taakiya iitǝr wa fakura ɓakura nǝ uud kǝ aguvaca. ");
INSERT INTO glwl_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","Kiyava kaiya ǝn maay tǝɗa fǝɗavǝgh biya, bamma tǝghǝr kǝ hǝrtǝga Yaazhigǝl Yesu Kǝristiya, Aɗaba tǝdvad ǝmtsǝgan tǝ tlaɓa hǝrtǝga nǝ wa ɗuuwanars nai kǝ ndzǝgana duniya, dlaɓa ǝmtsanaǝtsǝg kwakyarvad dǝga duniya. ");
INSERT INTO glwl_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","Ɓagaɓagan nǝ aguvaca ɓagabi na aguvac biya maay nǝ dǝgiti tuuk vakai nǝ iini, dǝgit marawa kǝ uuda, aa nalnǝg kǝ daala vǝrɗǝgga. ");
INSERT INTO glwl_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","Gagǝra ard zhuwaɗaala aa dzadzǝg tǝghǝr kǝ lii gata kwan kǝ ɗuul baɗǝmma, kwa yaa izraila ba jiijiira. ");
INSERT INTO glwl_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","Cigǝt ndakwana da tǝvuuk zaraabahara, aa gwiyabi nǝ uudan kǝ gagyakai dǝ dǝgiti tlǝr biya, aɗaba vavǝrahan tǝ vǝgharna maradamarǝg taakiya ǝn ɛva Yesu naiya. ");
INSERT INTO glwl_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","Aa ndzandzǝg nǝ harǝrra Yaazhigǝl Yesu Kǝristi ǝmtaɗ dǝ Shiɗkwaru zaraabahara. Amin.");
INSERT INTO glwl_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","Wakita Bulus, kwa nal kǝ zǝr ɓǝlga kǝristi Yesu tǝɗvad naaga Daadamazhigǝl, ǝmtaɗ dǝ Timuti, zǝraabamiyama, ");
INSERT INTO glwl_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","Da vak lii gata Daadamazhigǝl kwar ndzǝga ma Kolosiya. Aa ndzandzǝg nǝ Herǝra ard gabǝrǝr Daadamazhigǝl Daadamiyam tǝghǝr kǝskurama. ");
INSERT INTO glwl_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","Ba kǝlahǝnga, kǝm tagar uus kǝ Daadamazhigǝla, Daad Yaazhigǝlamiyam Yesu Kǝristiya, ma sartǝn kǝm dzug nǝmnd kǝ zhigǝl kwakyarvad kuurama ");
INSERT INTO glwl_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","Aɗaba cinngamndacinng kǝ fadghǝraru tǝ Kǝristi Yesu, ard waiyakǝvi am martǝr nǝ uuram kǝ lii gata Daadamazhigǝl baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","Kwam ɓagtǝr nǝ uuram ǝndkwaha, aɗaba am dǝ fantaar tǝghǝr kǝ dǝgitahi marau kwa fakura nǝ uud ma ghǝrazhigǝla. Kwan nǝ ǝlbǝga jiijiiri cinngama nǝ uuram ba zunngw ma ǝlbǝg marawa. ");
INSERT INTO glwl_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","Əlbǝg marawǝn sa dǝ barka, dlaɓa cinngalciing ma duni baɗǝmma, bandkwa ɓagaa nǝ iin makuuram bamma sarta kwa famarzha cinnga ǝlbǝg tǝghǝr herǝra Daadamazhigǝla, ard ɗuuli nǝghamaaka nǝ uurama. ");
INSERT INTO glwl_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","Fǝgharzha nǝ Abafaras tsaghwa tlǝramnda kwa kǝm waig nǝmnd kǝ lankur ǝlbǝga hǝrǝrra Daadamazhigǝla. Uuda jiijiir nǝ iin ma ɓa tlǝra Kǝristiya, dlaɓa iin wa ɓa tlǝr vakaru dlakulvamnda. ");
INSERT INTO glwl_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","Iin dlaɓ wa tagkǝmnd ǝlbǝg tǝghǝr kǝ waiyakǝvi am ɓag nǝ uuram ma Shiɗkwa. ");
INSERT INTO glwl_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","Cinngamnda ba nǝmnd kǝ ǝlbǝgna, ghacamnda bi kǝ dzǝgwazhigǝl mbakyarvad kǝ uuram biya, kǝm ba ghala Daadamazhigǝl ma righkurǝt dǝ sǝrgasǝrg ma dabariya ard nǝghgakanǝghǝga. ");
INSERT INTO glwl_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","Tǝdvad kwah wam da ɓag nǝ uuram kǝ ndzǝgan maraw tǝvuukwa Yaazhigǝla, am hǝnarna kǝ ǝrviɗmahuɗa, am ɓagan kǝ ndzǝgan maraw aanji ma hulfa kwar kǝ tlǝra, dlaɓa am gwiya fǝgara bad fǝg ma sǝrga Daadamazhigǝla ");
INSERT INTO glwl_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","Aa fǝkuraafǝg nǝ Daadamazhigǝl kǝ ndzǝɗ dǝ ndzǝɗan baɗǝmma, kiyava ɓishgan kǝskuuram aanji bau wa dzǝgardzǝga, am fǝgan kǝ ǝrviɗmahuɗ dǝ dlaiga. ");
INSERT INTO glwl_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","Am tagar uus kǝ Daad ba kǝla hǝnga, aɗaba iin wa fakiyama tlǝkǝna dǝgshiga gwiigǝn kwa faa nǝ iin kiyava uudahan kwar ma tlǝksǝra paraka. ");
INSERT INTO glwl_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","Aɗaba iin wa ngǝdlakiyama sagal ma tlǝksǝra gurtla, sǝkiyamdaan damma tlǝksǝra Zǝraan kwa waig nǝ iina. ");
INSERT INTO glwl_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","Kwa varakiyamnda tǝdvad iin nǝ uuda, kwa iin nǝ ɓisha haipaha miyama. ");
INSERT INTO glwl_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","Kǝristi nǝ dzakǝva Daadamazhigǝl kwa nǝghva biya, iin Zǝra zǝnngw tǝvuukwa dǝgitahi vǝrɗyava baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","Aɗaba ɓagava tǝdvad iin nǝ dǝgitah baɗǝmma, dǝgitahi ma ghǝrazhigǝla ard ma duuniya, ard dǝgitahi nǝghvanǝghǝga ard dǝgitahi kwa nǝghva biya, aanji avda kwarga, aaji kwarga, aanji lii ndzǝɗa. Baɗǝm nǝ dǝgitahi vǝɗyavana, vǝrɗyavtǝra tǝdvad iina, dlaba mbakyarvad iina. ");
INSERT INTO glwl_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","Kǝristi wa tǝvuukwa dǝgitah baɗǝmma, dlaɓa baɗǝm nǝ dǝgitahi vǝrɗyavana matlavant tǝdvad iina. ");
INSERT INTO glwl_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","Iin nǝ ghǝr tǝ vǝgha, kwa iin dlamakǝlawa lii gatǝga. Iin nǝ dǝga zǝnngwa, iin dlaɓ nǝ dǝga zǝnngw ma lii ciig ma gǝtlaha, dlaɓa aanji ma kwar kǝ dǝgita nalnǝg nǝ iin kǝ dǝga zǝnngwa. ");
INSERT INTO glwl_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","Aɗaba cinngucinng nǝ Daadamazhigǝl kǝmtakǝra righǝga dǝgitah baɗǝm ma iina, ");
INSERT INTO glwl_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","tǝdvad Kǝristi dlaɓ wa nadal nǝ iin kǝ dǝgitahi vǝrɗya nǝ iin baɗǝm da vakaana. Aanji dǝgitahi ma duuniya ma dǝgitahi ma ghǝrazhigǝla, sadaasǝg kǝ gabar saa mataataka kwanahaan baɗǝm tǝdvad ɗiida avzaan tǝ tlaɓa hǝrtǝga ");
INSERT INTO glwl_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","Ndzam ba bǝkya dǝ Daadamazhigǝl wurwura, ndzam ɓa tlǝghum dǝ iin ma ǝrvǝɗmahuɗaru am ɓa dǝgitah ghwaɗghwaɗa. ");
INSERT INTO glwl_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","Aɗaɓa ndakwana, faafǝg nǝ Daadamazhigǝl kǝ gabǝr mataatakaru dǝ iin ma avza Kǝristi kwa dǝga tluwa ard avza tǝdvad ǝmtsǝgaana. Nakurdalnǝg nǝ Kǝristi ndakwan ba cuwaɗaɗ lii maay dǝ haip tǝvuukwa Daadamazhigǝl biya, ");
INSERT INTO glwl_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","Akwama am zaa ba vuuk dǝ fadghǝraruwa, am ghaca ba tǝ vakaiya, ɗuuwamar bi kǝ fantara kwam dǝvakai nǝ uuram kwa cinngam ma ǝlbǝg marawǝn biya. Kwan kǝ ǝlbǝga maraw kwa tagavtǝr aanji kwar kǝ dǝgitahi vǝrɗyava ma miizhangǝl kǝ ghǝrazhigǝla, kai Bulus wa nanal kǝ dadda ɓa tlǝra. ");
INSERT INTO glwl_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","Ən dlaig nai ndakwan mbakyarvad dlaɗǝn ǝn huɓǝg nai kwakyarvad kuramna, aɗaba ǝn da righgant tǝdvad dlaɗǝn kǝ dǝgiti tǝmaa kǝ dlaɗa Kǝristi huɓuu nǝ iin kwakyarvad vǝghaana, kwa iin nǝ dlamakǝlawa lii gatǝgaana. ");
INSERT INTO glwl_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","Nanalnǝg kǝ dadda taa ǝlbǝg marawa tǝdvad hǝkya langyiya kwa vǝlghwa nǝ Daadamazhigǝl mbakyarvad kǝ uurama, kiyava tagkur ǝlbǝg Gaadamazhigǝl ba marawa. ");
INSERT INTO glwl_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","Kwan kǝ ǝlbǝgǝn ǝn tagkur naiy na, dǝgit shiɓashiɓan ba sagalan ma zǝrazǝra, aɗaba ndakwana maravtǝrdamarǝg kǝ yaa dadda gata yaazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","Naaga Daadamazhigǝl mara sǝran nǝ uudahan kǝ dyaka hyahǝrǝn ma dǝgan shiɓashiɓan kwa ndanga, kwa fa nǝ iin kiyava lii ar Yahudahǝn biya, dǝgitǝn shiɓashiɓanna, iin Kǝristi kwa dǝ shifǝg ma kǝ uurama, am dǝ fantar ndzǝga ǝmtaɗ dǝ iin ma ndangǝraana. ");
INSERT INTO glwl_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","Iin wa kǝm tagar nǝmnd aanji war kǝ dǝgit tǝghǝr kǝ Yesu Kǝristiya, kǝm tǝdkur hyǝmya dlaɓa kǝm tsakur kǝ dǝgitah badǝm dǝ dabariya kiyava nal aanji ba war kǝ dadda gata Kǝristiya. ");
INSERT INTO glwl_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","Mbakyarvad kwah wan ghulvanai kǝ ɓa tlǝr bad halavuwa ndzǝɗar kwa vǝlghwa nǝ Kǝrisri ma kaiya. ");
INSERT INTO glwl_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","Ən naagan am sǝran kǝ hulfa dlaɗan ǝn hǝɓǝg nai kwakyarvad kǝ uurama ard uudahi ar ma lawudikiya, ard uudah baɗǝm kwa taparnabi kǝ nǝghkwanǝghǝg biya. ");
INSERT INTO glwl_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","Maa tǝ naagara maraa ndzan ma waiyakǝva, dlaɓa ar tlǝkǝna kǝ ndzǝɗ ma ǝrviɗmahuɗaatǝra, kiyava tlǝkǝnatlǝg kǝ iitǝr kǝ sǝrgasǝrǝg ba maraw, ar sǝran kǝ dǝga Daadamazhigǝl shiɓashiɓana, kwa iin Kǝristi bad ghǝraana. ");
INSERT INTO glwl_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","Shiɓavna ma iin nǝ ndangǝra dabariya ard sǝrgasǝrgǝr baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","Ən tagkur kwa nai haik valkurdavalǝg nǝ uudanna dǝ ǝlbǝga, ɓala gajawa. ");
INSERT INTO glwl_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","Aanji ban maay ǝmtaɗ dǝ kuuram ma ndzǝgana vǝgh biya, aɗaba ma shiɗkwa ǝn ba ǝmtaɗ dǝ kuurama. Ən dlaig nai ba vaivai mbakyarvad ndzǝga ba kalkala, dlaɓa am dǝ fadghǝr ma Kǝristiya. ");
INSERT INTO glwl_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","Haiyamanthaig tsau taakiya Yesu Kǝristi nǝ Yaazhigǝlaruwa, zamzǝg kǝ vuuk dǝ gatǝgaana. ");
INSERT INTO glwl_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","Am ndzan ba maraw ma iina, am faraa kǝ ndzǝɗ kǝ ghǝraruwa, dlaɓa am ghacan ma fadghǝraru bandkwa tsagamndkuru nǝmnda, am tagar uus kǝ Daadamazhigǝl ba kǝlahǝnga. ");
INSERT INTO glwl_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","Famfǝg kǝ hyǝmiya, aa viiyǝt bi nǝ uudan kǝ ghǝraru tǝdvad ɗyamɗyama duuni kwa dǝga valuud biya, kwa tag nǝ dǝga daadija uudah tǝdvad ndzǝɗa shiɗkwa duuniya, kwa dǝga Kǝrist biya. ");
INSERT INTO glwl_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","Aɗaba righant ma Kǝristi nǝ Daadamazhigǝl kǝ dǝgahan baɗǝm ma vǝghaana. ");
INSERT INTO glwl_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","Bandkwah dlaɓ nǝ uurama, am righarighan ma Kǝristiya, kwa iin maal tǝghǝr ndzǝɗa ard kwarga ");
INSERT INTO glwl_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","Ɓagakura ma iin dlaɓ nǝ uud kǝ aguvaca, hulfa aguvacǝn ɓag nǝ uud dǝ dǝv biya. Sakurdasǝg nǝ uud sagal ma haipaharu kwa naag nǝ vǝgh baɗǝmm, ma sarta kwa ɓagakura nǝ Kǝristi kǝ aguvaca. ");
INSERT INTO glwl_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","Aɗaba hǝɗakurahǝɗǝg nǝ uud ǝmtaɗ dǝ Kǝristi ma sarta kwa ɓagakura nǝ uud kǝ tsuufǝga. Ciyakurǝtciig dlaɓ nǝ uud ǝmtaɗ dǝ Kǝristi ma tsuufǝg tǝdvad fadghǝraru ma ndzǝɗa Daadamazhigǝla, kwa ciighant nǝ iin ma gǝtlaha. ");
INSERT INTO glwl_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","Ndzam ǝmtsamǝmtsan wur mbakyarvad haipaharuwa ard maara ɓa aguvaca kwa dǝga ɗuwa hǝnkali naag nǝ vǝgha, ciyakurǝtciig nǝ Daadamazhigǝl dǝ shifǝg ǝmtaɗ dǝ Kǝristiya, ɓishakiyamnaɓishǝg kǝ haipahamiyam baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","Ghudadaghuɗǝg kǝ shariya kwa nguɗa kiyama nǝ adzahadzahǝna, kǝsakiyamara kǝsǝga nǝ Daadamazhigǝla, tsahǝttsahǝg kǝ kus tǝ tlaɓa hǝrtǝga Kǝristiya. ");
INSERT INTO glwl_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","Kǝsatǝrvakǝsǝg kadlanga ghwava lii kwarǝga ard ndzǝɗaatǝra, tsatǝratsǝg kǝ zhirwa bat ɓalaɓala tǝdvad zaa fiir tt iitǝr tǝ tlaɓa hǝrtǝga. ");
INSERT INTO glwl_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","Mbakyarvad kwaha, aa fǝkuraabi nǝ uud kǝ haipa tǝghǝr kǝ dǝgiti am zǝg nǝ uurama, bi tǝghǝr kǝ dǝgiti am huɓǝg nǝ uurama, bi am maay tsuufa hwaɗaga haarakǝsa, bi Hwaɗaga Daala Kyila, bi ngiiya faciya sǝvd biya. ");
INSERT INTO glwl_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","Kwanahaan kǝ dǝgitaha band shiɗkwa dǝgiti da sagauwa, Kǝristi nǝ gyigyiya dǝginiina. ");
INSERT INTO glwl_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","Mbakyarvad kwaha, haiyamant bi aanji ba war kǝ dadda naa ghǝr nenna kǝ uuram taakiya, tlaltlǝg nǝ iin kǝ ghwalvǝra ɓagan kǝ sǝnga. Hulfa kwan kǝ uuda naa ghǝran ba ghyaana, baz taaki ɓagar kwatǝnah kǝ zǝrha ɓǝlga Daadamazhigǝla, mbats ndakwani vala ba ghǝraana, ǝrviɗmahuɗana dǝga hǝnkala uuda digshiga. ");
INSERT INTO glwl_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","Hulfa kwan kǝ uuda, ǝmtsavǝt bi tǝ Kǝristi kwa iin nǝ ghǝr tǝ vǝgh biya. Aɗaba iin wa hǝkya vǝgh baɗǝma kwa matlamatlan dǝ pǝrɗaha, ghubarǝg dlab bandkwa faa nǝ Daadamazhigǝla kiyava ghubarǝga. ");
INSERT INTO glwl_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","Əmtsamaǝmtsǝg tsau ǝmtaɗ dǝ Kǝristiya, dlaɓa sakurdasǝg sagal mazhagyil kǝ ndzǝɗa kwan kǝ duuniya. Aujilbǝg am ɓa ndzǝgan band lii gwastan ar ba dǝga duuniyi? Aujilbǝg am haiganthaig dǝ adzahadzah kwa tsag nǝ uud duuni, ");
INSERT INTO glwl_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","adzahadzah kwa taakiya, “Ɓag bi kǝ tlǝr dǝ kwan biya, tap biya, vii biya”? ");
INSERT INTO glwl_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","Hulfa kwan kǝ adzahadzaha tag tǝghǝr kǝ dǝgitahi da zǝlma biya, aɗaba adzahadzahiina kwa tsag nǝ uudaha. ");
INSERT INTO glwl_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","Hulfa kwan kǝ adzahadzaha mǝng nǝ ndzǝgana dabariya vaka faa ndzǝɗ ma gatǝga kwa naag nǝ uudaha, ar tsǝgarva ghǝratǝr kǝ cinnga ǝmtakǝr mbakyarvad gata digshiga, ar vǝlga dlaɗ kǝ ghǝratǝra. Bak jiirjiira, hulfa kwan kǝ adzahadzaha maay dǝ ndzǝɗ vaka tsǝgarva dǝgiti naag nǝ vǝgh biya. ");
INSERT INTO glwl_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","Ciyakurǝtciig tsau nǝ Daadamazhigǝl dǝ shiifǝg ǝmtaɗ dǝ Kǝrisiya, gatamgatǝg kǝ dǝgitahi kwa maghǝrzhigǝla, vakavaki dǝ Kǝristiya, kwa cihurgan tǝ dǝva kafa Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","Dzamamdzamǝg ba kǝ dǝgitahi kwa ma ghǝrazhigǝla, ndavambi kǝ dǝgitahi kwa ma duuni biya. ");
INSERT INTO glwl_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","Aɗaba ǝmtsamaǝmtsǝga, shiɓashiɓan nǝ shifǝgaru ǝmtaɗ dǝ Kǝristi ma Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","Ma sartǝn da marazh nǝ kǝristi kwa iin nǝ shifǝgaruwa, ghǝravaru ndakwani am da marazh ǝmtaɗ dǝ iin ma ndangǝraana. ");
INSERT INTO glwl_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","Mbakyarvad kwanha, ɗuwamarsɗuug kǝma dǝga duuni ma ǝrviɗmahuɗaruwa, kwa iin tlǝra gwardzǝrra, ard gwaragwara, ard ɓa kǝladǝra, ard shiɓǝlga, kwa iin ndakwani ba ɓagar kwatǝnah kǝ ghǝlaha. ");
INSERT INTO glwl_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","Mbakyarvad kwan kǝ haipah wa badzǝg nǝ Daadamazhigǝl kǝ ǝrviɗmahuɗ dǝ lii ɓa kwana. ");
INSERT INTO glwl_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","Ndzam za vuuk dǝ kwanahan kǝ hǝnkal nǝ uuram wura, ndza nalnǝg kǝ vǝgh kǝskurama. ");
INSERT INTO glwl_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","Aɗaba ndakwana, barari kǝskuram am ɗuwar kǝ hulfa kwanahan baɗǝmma. Ɗuwamarɗug kǝ nguɗa ǝrviɗmahuɗa, ciiya jaaga, ard naa bi kǝ uuda, ard baɗza ɗaaga, ard ǝlbǝg ghwaɗ kwa sagal ma ghaayaruwa. ");
INSERT INTO glwl_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","Tagam bi kǝ fiid ma taatakaru biya, ɗuwamarɗug tsau kǝ hǝnkalaruwi kwa ndza wura ard tlǝrahaana, ");
INSERT INTO glwl_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","baz kǝsa daala hǝnkal kǝakurama, kwa navdal kǝ daal tǝdvad sǝrgasǝrg ma dzakǝva daddakwa vǝrɗyavǝrɗyǝga. ");
INSERT INTO glwl_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","Tlǝmkǝnatlǝg tsau kǝ daala hǝnkala, madla bi nǝ ndzǝgan gǝrgǝr ma taatakaru biya, aanji Yahudaha ma lii ar Yahudah biya, ard daddakwa ɓagaɓag ka aguvaca ard daddakwa ɓagabi ka aguvac biya, ard dadda tǝmaruwa, ard zǝrndzǝga, ard ɛrva, ard daddakwa kwara ghǝra, baɗǝm ba dǝgit palla, aɗaba Kǝristi nǝ dǝgit baɗǝmma, iin dlab wa ma kǝmyam baɗǝmma. ");
INSERT INTO glwl_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","Kǝsakurakakǝsǝg nǝ Daadamazhigǝl kiyava nǝg kǝ uudahana lii cacuwanan kwa waitǝr nǝ iin ba vaivaiya. Mbakyarvad kwaha, am zhutǝrɗaala kǝ zarabaharuwa, am ɓagtǝr herǝrra, am nal kǝ kalaliyah ard ɓa dǝga jiira ard ɓishgaana, ");
INSERT INTO glwl_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","am fagan kǝ ǝrviɗmahuɗ dǝ zaraabaharuwa. Akwama ɓagaɓag nǝ uud pal ma kuuram kǝ haipa, am ɓisharnana bandkwa ɓishkurna nǝ Yaazhigǝl kǝ haipaharuwa, ɓishamarnaɓishǝg dlab nǝ uuram kǝ pallaruwa. ");
INSERT INTO glwl_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","Tǝghǝr kwanahaan baɗǝmma, ɓagamɓag kǝ waiyakǝva, aɗaba waiyakǝv wa matlǝgant kwanahan baɗǝm tǝ dǝgit palla. ");
INSERT INTO glwl_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","Aa ɓag nǝ gabǝra Kǝristi kǝ kwarǝg ma ǝrviɗmahuɗaruwa, aɗaba mbakyarvad gabǝrǝn wa ɗahakurǝr nǝ uud kǝ ndzǝga kǝ vǝgh palla, dlaɓa am nal kǝ lii tagar uus kǝ Daadamzhigǝla. ");
INSERT INTO glwl_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","Aa ndzandzǝg nǝ ǝlbǝga Kǝristi ma ǝrviɗmahuɗaru ba dyakdyaka, am tsagtǝrtsag kǝ zarabaharuwa, am ɓǝlgan kǝ magi dǝ dabari baɗǝmma, am ɓǝlgan kǝ ǝngsa zabura ard dǝ dǝga galla Daadamazhigǝla, am ɓǝlgan kǝ ǝngsa kwa tagkur nǝ Shiɗkwa, am ɓǝlgan da taa uus ma ǝrviɗmahuɗaruwa. ");
INSERT INTO glwl_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","Aanji ba kwar kǝ dǝgiti am ɓag nǝ uurama, ma taa ǝlbǝga ma tlǝra, ɓagamɓag ma ɗaaga Yaazhigǝl Yesu, am tagar uus kǝ Daadamazhigǝl Daada tǝdvad iina. ");
INSERT INTO glwl_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","Kuuram ǝngwasaha, ɓagamɓag kǝ ndzǝgan dǝ zhiilaharu band kwa kalkalan dǝ lii gata Yaazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","Kuuram ghulvaha, waiyamtǝrwaig kǝ ǝngwasaharuwa, maramtǝrbi kǝ hǝnkal ghwaɗ biya. ");
INSERT INTO glwl_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","Kuuram zarha, famarafǝg kǝ daadaharuwa ard baabaharu aanji ma kwar kǝ dǝgita, aɗaba kwan wa naag nǝ Yaazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","Kuuram daadaha, vǝlamtǝrbi kǝ dlaɗ kǝ zǝrharu biya, haik kǝ gǝdzǝg kǝ iitǝra. ");
INSERT INTO glwl_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","Kuuram ɛɛvaha, famtǝraraafǝg kǝ dadda hǝnyaharu maa duuni aanji bamma auwa. Ɓagambi kǝ dǝga nǝgha gyi band kwa ɓag lii gata ɗaag vak kǝ uudah biya, dlakulva kwaha, ɓagamɓa kǝ tlǝr bad ǝrviɗmahuɗ palla, am gǝdzǝgan kǝ Yaazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","Baɗǝm nǝ dǝgiti am ɓag nǝ uurama, ɓagamɓag bad ǝrviɗmahuɗaru baɗǝmma, mandki am ɓagar kǝ Yaazhigǝla, am ɓagar kǝ uud biya, ");
INSERT INTO glwl_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","am sǝrgasǝrg tsau taakiya da vǝlkurvǝlǝg nǝ Yaazhigǝl kǝ dǝga gwiig kwa iin nǝ dǝgshigaruwa. Aɗaba am ɓagar kǝ Yaazhigǝl Kǝristi nǝ uuram kǝ kwatǝnahǝra! ");
INSERT INTO glwl_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","Daddakwa ɓa tlǝra kǝladǝra, da tlǝkǝnatlǝg kǝ dǝgshiga kǝladǝrana, aɗaba maay nǝ Daadamazhigǝl fa dagar ma uud biya. ");
INSERT INTO glwl_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","Kuuram dadda hǝnyahaha, hǝkyamnahǝkyǝg kǝ ɛɛvaharu bak jiijiira am gǝdzǝgan kǝ Yaazhigǝla, aɗaba am sǝrgasǝrǝg ghǝravaru taakiya am dǝ Yaazhigǝl nǝ ghǝravaru ma ghǝrazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","Ghulamvaghulǝg kǝ dzǝgwazhigǝla, am uufǝgaana am tagar uusa kǝ Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","Am dzǝgwan kǝ zhigǝl ɗlab kǝskǝmnda, kwa da wurkǝmndant nǝ Daadamazhigǝl kǝ ɗuul kiyava taa ǝlbǝgaana, kǝm tagtǝr kǝ uudah kǝ ǝlbǝga Kǝristi shiɓashiɓana. Mbakyarvad dǝgitin shiɓashiɓanǝn wa ɓǝlakwaɗǝm nǝ uud ma guda bǝrfǝga. ");
INSERT INTO glwl_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","Dzǝgwamwadzǝgw kǝ zhigǝla kiyava taa ǝlbǝgǝn shiɓashiɓanǝn ba marawa, kwa kalkalana kǝskai tagana. ");
INSERT INTO glwl_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","Dzamadzǝg dǝ dabari ma lii ar maay gata Yesu biya, am ɓa tlǝra aanji dǝ kwar kǝ sartaruwa. ");
INSERT INTO glwl_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","Aanji ba hǝra, tagamtag ba kǝ ǝlbǝga herǝrra dlaɓa kwa ǝmtak kǝ cinnga, kiyava sǝrgasǝrǝg kǝskuuram kǝ ɗuuli am da ngutǝr nǝ uuram aanji ba wara. ");
INSERT INTO glwl_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","Da takurtag nǝ Tikikus kǝ dǝgit tǝghǝr kǝskai baɗǝmma. Zǝraabamiyam nǝ iin kwa kiyam waig nǝ miyam ba vaivaiya, dlaɓa uuda jiijiir nǝ iin ma ɓa tlǝra Yaazhigǝl ǝmtaɗ dǝ kǝmyamma. ");
INSERT INTO glwl_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","Ɓǝlanantɓǝlǝg da vakaruwa aɗaba am sǝran kǝ ndzǝgana lapiyamnda, dlaɓa fǝkurna kǝ ndzǝɗa. ");
INSERT INTO glwl_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","Dagal ǝmtaɗ dǝ Onisimusa, zǝrabamiyam uuda jiijiir kwa kiyam waig nǝ miyama, kwa ghǝravan ndakwi ba uuda kǝsaruwa. Ar da tagkurtag nǝ iitǝr kǝ dǝgitah baɗǝm kwa dzagardzaag dǝ kǝmnd vakwanna. ");
INSERT INTO glwl_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","Aristarkus kwa ma guda bǝrfǝg ǝmtaɗ dǝ kai vakwana, tagkur uusa, band kwah dlaɓ nǝ Markus kwa daadijatǝr pal dǝ Barnabasa. Iin wa tagankur naiy kǝ ǝlbǝg tǝghǝr kǝ iin taakiya, akwama sǝvsǝg sa vakaruwa, cawamacaug bad dǝva buwa. ");
INSERT INTO glwl_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","Yesu kwa ɗahav dǝ Yustus, ghǝravan ndakwi tagkur uusa. Ba uudahan hǝkǝrɗǝn kalti ma yaa Yahudah kwa ɓa tlǝra tlǝksǝra Daadamazhigǝl ǝmtaɗ dǝ kaiya, nararnǝg kǝ dǝga taa ndzǝgwagh vakara. ");
INSERT INTO glwl_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","Abafaras kwa pal ghǝravan ma kuurama, iin ndakwani ba kwatǝnaha Yesu Kǝristiya, tagkur uusa. Ba kǝlahǝng ba dzǝgwazhigǝl ghala Daadamazhigǝl kwakyarvad am ghacan bad ndzǝɗa, am ndzan ba righarighana, am fǝdghǝrǝt taakiya am lii gata Daadamazhigǝla. ");
INSERT INTO glwl_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","Nanalnǝg nai kǝ shiɗ kǝ Abafaras tǝghǝr kǝ tlǝri kwa ghulava nǝ iin kwakyarvad mǝlkuru kǝskurama, ard uudaha Lawudikiya ard uudaha Hirafolis. ");
INSERT INTO glwl_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","Luka, doctar kwa kiyam waig nǝ miyama, ard Demas, ar tagkur uusa. ");
INSERT INTO glwl_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","Tagamtǝrtag kǝ uus kǝ zaraabahamiyam baɗǝm kwar ma Lawudikiya, ard Nimfa ǝmtaɗ dǝ dlamakǝlawa lii gata Yesu kwar dzahav ma vǝgyaana. ");
INSERT INTO glwl_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","Akwama ghyǝnngava ghyǝnng karanta wakitǝn tǝvakwaruwa, am vǝltǝr kǝ dlamakǝlawa lii gata Yesu kwar ma Lawudikiya, kiyava karantǝgan ghǝravatǝra. Am karantan ghǝravaru kǝ wakitǝn kwar da vǝlkur nǝ uudah Lawudikiya. ");
INSERT INTO glwl_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","Am tagar kǝ Arkibus aa fafǝg kǝ hǝnkal ghyǝnngna kǝ tlǝrǝn vǝlghar nǝ Yaazhigǝlna. ");
INSERT INTO glwl_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","Ba kai Bulus dǝ ghǝrar wa vǝndkur kwan kǝ taa uusa. Viyamnabi taakiya ǝn nguɗanguɗan biya. Aa ndzandzǝg nǝ Herǝra Daadamazhigǝl ǝmtaɗ dǝ kuurama. Amin.");
ALTER TABLE glwl_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
