﻿USE sofia;
DROP TABLE IF EXISTS sofia.glk_vpl;
CREATE TABLE glk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES glk_vpl WRITE;
INSERT INTO glk_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","از اوّل کلمه بو و کلمه خدا اَمره بو و کلمه، خدا بو. ");
INSERT INTO glk_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","اون از اوّل خدا اَمره بو. ");
INSERT INTO glk_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","همه چی توسطه اون به وجود بَمو، و از هر اونچی کی به وجود بَمو، هیچ چی بدونه اون به وجود نَمو. ");
INSERT INTO glk_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","در اون حیات بو و او حیات، نوره آدمیأن بو. ");
INSERT INTO glk_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","اَ نور در تاریکی تأبه و تاریکی نتأنه اونه از بین ببره. ");
INSERT INTO glk_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","مردی بَمو کی خدا اونه اوسه کوده بو. اونه نام یحیی بو. ");
INSERT INTO glk_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","اون شهادت دَئنه‌ره بَمو بو، شهادته بر او نور، تا همه توسطه اون ایمأن بأورید. ");
INSERT INTO glk_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","یحیی خودش او نور نوبو، بلکی بَمو بو تا بر او نور شهادت بده. ");
INSERT INTO glk_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","اون نوره حقیقی کی هر آدمی‌یه منوّره کونه، حقیقتاً به جهان اَمون دوبو. ");
INSERT INTO glk_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","اون دنیا میأن ایسه بو و دنیا به واسطه‌یه اون به وجود بَمو، امّا دنیا اونه نشنأخته. ");
INSERT INTO glk_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","به خو مِلکِ سر بَمو، ولی اونه قوم، اونه قبول نوکودیدی. ");
INSERT INTO glk_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","امّا به تمامه کسأنی کی اونه قبول بوکودیدی، اَ حقَ فده کی خدا زأکأن بیبید، یعنی هر کسی کی به اونه نام ایمأن بأوره. ");
INSERT INTO glk_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","نه کسأنی کی از انسان به دنیا بَموییدی و نه از نفسه خوأهشیدی و نه از ایتأ مردِ خوأسته به دنیا بَموییدی، بلکی تولدی از خدایه. ");
INSERT INTO glk_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","و کلمه، انسانه خاکی بوبوسته و اَمی میأن ساکن بوبوسته و اَمأن اونه جلاله بیده‌ییم، جلالی کی شایسته‌یه او یگانه پسری ایسه کی از طرفه پئر بَمو، پُر از فیض و راستی. ");
INSERT INTO glk_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","یحیی بر اون شهادت دَیی و با صدایه بلند گفتی کی: «اَن او کسی ایسه کی درباره‌یه اون بوگفتم: ‹اون کی بعد از من اَیه بر من برتری پیدا بوکوده، چونکی قبل از من وجود دأشتی›.» ");
INSERT INTO glk_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","از اونه پُری اَمأن همه بهره‌مند بوبوستیم، فیض، فیضه سر. ");
INSERT INTO glk_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","چونکی شریعت توسطه موسی بَمو، امّا فیض و راستی به واسطه‌یه عیسی مسیح بَمو. ");
INSERT INTO glk_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","هیچکی هرگز خدایه نیده. امّا او یگانه، کی پئره ورجه ایسه و در خودشه ذاتم خدایه، اون، اونه بشنأسأنه. ");
INSERT INTO glk_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","اَنه یحیی شهادت او وختی کی یهودیأن، کاهنأن و لاویأنه از اورشلیم اونه پهلو اوسه کودیدی تا از اون وَورسید کی: «تو کی ایسی؟» ");
INSERT INTO glk_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","یحیی اعتراف بوکوده، انکار نوکوده، بلکی اصرار دأشتی کی: «من مسیح نی‌یم.» ");
INSERT INTO glk_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","وَورسه‌ییدی: «پس چی؟ تو الیاسی؟» جواب بده: «نی‌یم.» وَورسه‌ییدی: «تو او پیامبری؟» جواب بده: «نه!» ");
INSERT INTO glk_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","او وخت اونه بوگفتیدی: «پس کی ایسی؟ بوگو چی جوابی او کسأنی‌ره کی اَمَره اوسه کودیدی، ببریم؟ درباره‌یه خودت چی گی؟» ");
INSERT INTO glk_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","یحیی طبقِ اونچی کی اِشَعْیایه نبی بیان بوکوده بو، بوگفته «من او صدایه نداکوننده در بیابانم کی گه: ‹خداونده رایه همواره کونید!›» ");
INSERT INTO glk_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","تعدادی از اوشأنی کی روانه بوسته بید و از فَریسیأن بید، ");
INSERT INTO glk_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","اونه وَورسه‌ییدی: «اگر تو نه مسیحی، نه الیاسی و نه او پیامبر، پس چره تعمید دیهی؟» ");
INSERT INTO glk_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","یحیی در جواب بوگفته: «من آبه اَمره تعمید دهم، امّا شیمی میأن کسی ایسه کی شومأن اونه نشنأسیدی. ");
INSERT INTO glk_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","اونی کی بعد از من اَیه، من لایقه وأکودن اونه کفشه بندم نی‌یم.» ");
INSERT INTO glk_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","اَشأن همه در بیت‌عَنْیا واقع در او طرفه اُردنِ رودخانه رخ بده، جایی کی یحیی تعمید دَیی. ");
INSERT INTO glk_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","فردایه او روز، یحیی چون عیسایه بیده کی اونه طرف اَمون دره، بوگفته: «اَنه برّه‌یه خدا کی گناهه از دنیا اوسَنه! ");
INSERT INTO glk_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","اَن، اونی ایسه کی من درباره‌یه اون بوگفتم؛ ‹بعد از من مردی اَیه کی بر من برتری دأشتی، چونکی قبل از من وجود دأشتی.› ");
INSERT INTO glk_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","من خودمم اونه نشنأختیم، امّا هَنه وستی بَموم کی آبه اَمره تعمید بدَم تا اون، اسرائیله‌ره ظاهره به.» ");
INSERT INTO glk_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","پس یحیی شهادت بده و بوگفته: «روحه بیدم کی کبوتره مأنستن از آسمان فرود بَمو و بر اون قرار بیگیفته. ");
INSERT INTO glk_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","من خودمم اونه نشنأختیم، امّا اونی کی مره اوسه کوده تا آبه اَمره تعمید بدَم، مره بوگفته کی: ‹هر وخت بیده‌یی کی روح بر کسی فرود بَمو و بر اون قرار بیگیفته، بدأن اون، اونی ایسه کی روح‌القدسه اَمره تعمید دهه.› ");
INSERT INTO glk_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","و من بیدم و شهادت دهم کی اَن خدا پسره!» ");
INSERT INTO glk_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","فردایه او روز، ایبارِ دیگر یحیی خو دوتأ شاگردأنه اَمره ایسه بو. ");
INSERT INTO glk_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","اون عیسایه کی راه شوئون دوبو، نیگاه بوکوده و بوگفته: «اَنه، خدا برّه!» ");
INSERT INTO glk_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","وختی اونه دوتأ شاگرد، اَنه حرفه بیشنَوستیدی، از عیسی دونبالسر راه دکفتیدی. ");
INSERT INTO glk_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","عیسی خو رویه وأگردأنه و بیده کی از اونه دونبالسر اَمون دریدی. اوشأنه بوگفته: «چی خوأییدی؟» بوگفتیدی: «ای اوستاد، تی خانه کویه ایسه؟» ");
INSERT INTO glk_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","جواب بده: «بأیید و بیدینید!» پس بوشوییدی و بیده‌ییدی کی کویه خانه دأره و او روز اونه اَمره سر بوکودید. او لحظه ساعته چهاره بعد از ظهر بو. ");
INSERT INTO glk_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ایتأ از او دو نفر کی یحیی حرفأنه بیشنَوسته بو و عیسی دونبالسر بوشو، آندریاس، شَمعونِ پِطرُسِ برأر بو. ");
INSERT INTO glk_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","اون اوّل خو برأر شَمعونَ پیدا بوکوده و اونه بوگفته: «اَمأن مسیحه (کی اونه معنی ‹مسح بوبوسته‌یه›) پیدا بوکودیم.» ");
INSERT INTO glk_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","و اونه عیسی ورجه ببرده. عیسی اونه نیگاه بوکوده و بوگفته: «تو شَمعونِ پِطرُس، یوحنا پسری. امّا ‹کیفا› دوخوأده بی» (کی اونه معنی صخره‌یه). ");
INSERT INTO glk_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","روزِ بعد عیسی خوأستی کی به ولایته جلیل بشه. فیلیپُسه پیدا بوکوده و اونه بوگفته: «می دونبال بیأ!» ");
INSERT INTO glk_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","فیلیپُس اهله بیت‌صِیْدا بو، آندریاس و پِطرُسِ همشهری. ");
INSERT INTO glk_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","اون نَتَنائیلَ پیدا بوکوده و بوگفته: «اون کسی کی موسی در تورات درباره‌یه اون بوگفته و پیامبرأنم بینیویشتیدی، پیدا بوکودیم! اون عیسی، یوسفه پسر از شهر ناصره‌یه!» ");
INSERT INTO glk_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","نَتَنائیل اونه بوگفته: «مگر به، کی از ناصره چیزه خوبی بیرون بأیه؟» فیلیپُس جواب بده: «بیأ و بیدین.» ");
INSERT INTO glk_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","وختی عیسی بیده کی نَتَنائیل اونه طرف اَمون دره، درباره‌یه اون بوگفته: «حقیقتاً کی اَنه او مردِ اسرائیلی کی در اون هیچ مکر و حیله‌یی پیدا نیبه!» ");
INSERT INTO glk_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","نَتَنائیل اونه بوگفته: «مره از کویه شنأسی؟» عیسی جواب بده: «قبل از اونکی فیلیپُس تره دوخوأنه، وختی کی درخته انجیره زیر ایسه بی، تره بیدم.» ");
INSERT INTO glk_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","نَتَنائیل جواب بده: «اوستاد تو خدا پسری! تو اسرائیله پادشاهی!» ");
INSERT INTO glk_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","عیسی در جواب بوگفته: «آیا بخاطره اَنکی بوگفتم تره درخته انجیره زیر بیدم، ایمأن بأوردی؟ از اَن به بعد چیزأنه بزرگتری دینی.» ");
INSERT INTO glk_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","بعداً بوگفته: «آمین، آمین شمره گم کی آسمان بازه به و خدا فرشته‌یأنه در حالی کی بر انسانه پسر بیزیر اَییدی و به آسمان شیدی، دینیدی.» ");
INSERT INTO glk_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","سوّمین روز قانایه جلیلِ میأن عروسی بو و عیسی مارم اویه ایسه بو. ");
INSERT INTO glk_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","عیسی و اونه شاگردأنم به عروسی دعوت بوبوسته بید. ");
INSERT INTO glk_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","وختی کی شراب تمامه بوسته، عیسی مار، عیسایه بوگفته: «اَشأن دِ شراب نأریدی.» ");
INSERT INTO glk_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","عیسی اونه بوگفته: «بانو، مره چی به اَ کارأن؟ می وخت هنوز فَنرسه.» ");
INSERT INTO glk_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","اونه مار پیشخدمتأنه بوگفته: «هر چی شمره گه، بوکونید.» ");
INSERT INTO glk_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","اویه شیش‌تأ خمره‌یه سنگی نَهه بو کی برای رسمه تطهیره یهودیأن به کار اَمویی و هر کدام ظرفیته دو یا سه‌تأ پیمانه‌یه دأشتی. ");
INSERT INTO glk_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","عیسی خدمتکارأنه بوگفته: «اَ خمره‌یأنه از آب پُره کونید.» پس اوشأنه لبالب پُره کودیدی. ");
INSERT INTO glk_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","بعداً اوشأنه بوگفته: «الأن ایپچه از اون اوسَنید و صاحبه مجلسه‌ره ببرید.» اوشأنم هوطو بوکودیدی. ");
INSERT INTO glk_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","صاحبه مجلس نأنستی کی اونه از کویه بأوردیدی، ولی خدمتکارأنی کی اونه اوسَده بید، دأنستیدی. اون وخت آبی کی شراب بوبوسته بو بیچیشته، داماده دوخوأده ");
INSERT INTO glk_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","و اونه بوگفته: «همه اوّل شرابه نابه اَوریدی و پذیرایی کونیدی و وختی مهمانأن مسته بیدی، بعداً شرابه ارزانتره اَوریدی؛ امّا تو شرابه نابه تا اَ لحظه بدأشتی!» ");
INSERT INTO glk_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","اَطویی عیسی خو اوّلین معجزه‌یه قانایه جلیلِ میأن انجام بده و خو جلاله نیشأن بده و اونه شاگردأن به اون ایمأن بأوردیدی. ");
INSERT INTO glk_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","بعد از اون، خو مار و خو برأرأن و شاگردأنه اَمره به کَفَرناحوم بوشو و چند روزی‌یه در اویه بِیسه‌ییدی. ");
INSERT INTO glk_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","چونکی یهودیأنه عیده پِسَخ نزدیک بو، عیسی به اورشلیم بوشو. ");
INSERT INTO glk_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","معبده صحنِ میأنی بیده کی تعدادی به فروختنه گاو و گوسفند و کبوتر مشغولیدی و صرافأنم به کاسبی نیشته بید. ");
INSERT INTO glk_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","پس، از طناب شلاق چأکوده اوشأنه با همه‌یه گاوأن و گوسفندأن از معبد بیرونه کوده و صرافأنه سکه‌یأنه، زمینه رو فوکوده و اوشأنه میزأنه وأگردأنه ");
INSERT INTO glk_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","و کبوتر فروشأنه بوگفته: «اَشأنه از اَیه بیرون ببرید و می پئره خانه‌یه به محلِ کاسبی تبدیل نوکونید!» ");
INSERT INTO glk_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","اون وخت اونه شاگردأن به یاد بأوردیدی کی بینیویشته بوبوسته بو: «غیرتی کی تی خانه وستی دأرم، مره سوزنه.» ");
INSERT INTO glk_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","پس یهودیأن بخاطره اَ کارأن اونه بوگفتیدی: «چی معجزه‌یی اَمَره نیشأن دیهی کی بدأنیم تو اجازه‌یه اَ کارأنه دأری؟» ");
INSERT INTO glk_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","عیسی در جوابه اوشأن بوگفته: «شومأن اَ معبده خرابه کونید من سه روزِ اونه دوباره چأکونم.» ");
INSERT INTO glk_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","یهودیأن اونه بوگفتیدی: «اَ معبده ساختن چهل و شیش سال طول بکشه، و الأن تو خوأیی سه روزِ اونه چأکونی؟» ");
INSERT INTO glk_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ولی معبدی کی عیسی از اون حرف زه‌یی، خودشه بدن بو. ");
INSERT INTO glk_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","پس وختی کی از مُرده‌یأن ویریشته، اونه شاگردأن اَ گفته‌یه به یاد بأوردیدی و به کیتابه مقدّس و اونه حرفأن ایمأن بأوردیدی. ");
INSERT INTO glk_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","وختی کی عیسی عیده پِسَخِ‌ره اورشلیمه میأن ایسه بو، خیلی‌یأن بخاطره معجزاتی کی انجام بده بو، به اونه نام ایمأن بأوردیدی. ");
INSERT INTO glk_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","امّا عیسی به اوشأنه ایمأن اعتماد نأشتی، چونکی همه‌یه شنأختی ");
INSERT INTO glk_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","و لازم نوبو کسی درباره‌یه انسان چیزی اونه بگه، چونکی خودش دأنستی کی انسانه دورونی چی نَهه! ");
INSERT INTO glk_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","مردی بو از فرقه‌یه فَریسی، نیقودیموس نام، از حاکمأنه یهود. ");
INSERT INTO glk_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","اون ایتأ شب عیسی ورجه بَمو و اونه بوگفته: «اوستاد! دأنیمی کی تو معلمی ایسی کی از خدا طرف بَمویی، چونکی هیچکی نتأنه معجزاتی‌یه کی تو انجام دیهی، انجام بده، بجز اونکی خدا اونه اَمره ببه.» ");
INSERT INTO glk_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","عیسی در جواب بوگفته: «آمین، آمین، تره گم تا کسی از نو به دنیا نأیه، نتأنه خدا پادشاهی‌یه بیدینه.» ");
INSERT INTO glk_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","نیقودیموس اونه بوگفته: «کسی کی پیره، چوطو تأنه دوباره به دنیا بأیه؟ آیا تأنه به خو ماره شکم وأگرده و دوباره به دنیا بأیه؟» ");
INSERT INTO glk_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","عیسی جواب بده: «آمین، آمین تره گم تا کسی از آب و روح به دنیا نأیه، نتأنه وارده خدا پادشاهی ببه. ");
INSERT INTO glk_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","اونچی کی از انسان به دنیا بأیه، جسمأنی‌یه و اونچی کی از روح به دنیا بأیه، روحانی‌یه. ");
INSERT INTO glk_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","تعجب نوکون کی بوگفتم بأید از نو به دنیا بأیید! ");
INSERT INTO glk_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","باد هر جایی کی بخوأیه، حرکت کونه و اونه صدایه ایشنَوی، امّا نأنی کی از کویه اَیه و به کویه شه. هوطویه هر کسی کی از روح به دنیا بأیه.» ");
INSERT INTO glk_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","نیقودیموس از اون وَورسه: «اَ چیز چوطو ممکنه؟» ");
INSERT INTO glk_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","عیسی جواب بده: «تو اسرائیله معلمی و اَ چیزأنه متوجه نیبی؟ ");
INSERT INTO glk_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","آمین، آمین، تره گم اَمأن از اونچی کی دأنیم، حرف زنیم و اونچی کی بیده‌ییم، شهادت دیهیم، امّا شومأن اَمی شهادته قبول نوکونیدی. ");
INSERT INTO glk_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","وختی شیمی اَمره درباره‌یه اموره زمینی حرف بزم، باور نوکودیدی، چوطو باور کونیدی اگر شیمی اَمره از اموره آسمانی بگم؟ ");
INSERT INTO glk_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","هیچکس به آسمان بوجور نوشو، مگر اونی کی از آسمان بیزیر بَمو، یعنی انسانه پسر. ");
INSERT INTO glk_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","هوطویی کی موسی بیابانه میأن ماره مجسمه‌یه بلنده کوده تا مردم بیدینید و از مرگ نجات پیدا بوکونید، هوطویی هم انسانه پسر بأید بلنده کوده ببه تا مردم بیدینید و نجات پیدا بوکونید. ");
INSERT INTO glk_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","تا هر کسی کی به اون ایمأن بأوره، زندگی‌یه اَبدی بدأره. ");
INSERT INTO glk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","«چونکی خدا دنیایه اونقدر محبت بوکوده کی خو یگانه پسره فده، تا هرکی به اون ایمأن بأوره هلاکه نبه، بلکی زندگی‌یه اَبدی بدأره. ");
INSERT INTO glk_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","چونکی خدا خو پسره اوسه نوکوده تا مردمه دنیایه محکوم بوکونه، بلکی اوسه کوده تا توسطه اون نجات پیدا بوکونید. ");
INSERT INTO glk_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","«هرکی به اون ایمأن دأره، محکوم نیبه، امّا هرکی به اون ایمأن نأره، از هَه الأنم محکوم بوبوسته، چونکی به خدا یگانه پسره نام ایمأن نأورده. ");
INSERT INTO glk_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","و محکومیت در اَنه کی نور به جهان بَمو، امّا مردم تاریکی‌یه بیشتر از نور دوست دأشتیدی، چونکی اَشأنه کارأن بد ایسه. ");
INSERT INTO glk_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","چونکی هر کسی بدی کونه، از نور نفرت دأره و نوره طرف نأیه، مبادا اونه کارأن آشکاره به و رسوا ببه. ");
INSERT INTO glk_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","امّا اونی کی در راستی زندگی کونه، نوره طرف اَیه تا آشکاره به، کی خو کارأنه به یاری‌یه خدا انجام بده.» ");
INSERT INTO glk_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","بعد از اون، عیسی خو شاگردأنه اَمره به دهاته اطرافه یهودیه بوشو، اون چند روزی اویه بِیسه و مردمه تعمید بده. ");
INSERT INTO glk_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","یحیایم عِیْنونِ میأن، نزدیکه سالیم، تعمید دَیی، چونکی در اویه آب زیاد بو و مردم اَموییدی و تعمید گیفتیدی. ");
INSERT INTO glk_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","اون وختی بو کی یحیی هنوز به زندان دنکفته بو. ");
INSERT INTO glk_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ایدفعه بین یحیی شاگردأن و ایتأ یهودی، رسمه تطهیره وستی بحثی به وجود بَمو. ");
INSERT INTO glk_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","پس یحیی ورجه بَموییدی و اونه بوگفتیدی: «اوستاد، اونی کی تی اَمره او طرفه رودِ اُردن ایسه بو و تو درباره‌یه اون شهادت دَیی، الأن خودش تعمید دهه و همه اونه ورجه شیدی.» ");
INSERT INTO glk_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","یحیی در جواب بوگفته: «هیچکی نتأنه چیزی به دست بأوره مگر اونکی از آسمان به اون عطا ببه. ");
INSERT INTO glk_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","شومأن خودتأن شاهدید کی من بوگفتم کی من مسیح نی‌یم، بلکی پیشاپیشه اون روانه بوبوستم. ");
INSERT INTO glk_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","عروس داماده‌شینه، امّا داماده رفق کی کنار ایسَه به اون گوش کونه، و از ایشنَوستنه داماده صدا، شادی‌یه زیادی کونه. می شادی‌یم اَطویی تکمیله بوسته. ");
INSERT INTO glk_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","اون بأید جلال پیدا بوکونه و من بأید کوچیکه بم. ");
INSERT INTO glk_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«اون کی از آسمان اَیه، از همه بالاتره، امّا اونی کی از زمین ایسه، زمینی‌یه و از چیزأنه زمینی حرف زنه. اونی کی از آسمان اَیه، از همه بالاتره. ");
INSERT INTO glk_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","اون از اونچی کی بیده و بیشنَوسته شهادت دهه، امّا هیچکی اونه شهادته قبول نوکونه. ");
INSERT INTO glk_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","کسی کی اونه شهادته قبول بوکونه، بر راستی‌یه خدا مُهرِ تأیید بزه. ");
INSERT INTO glk_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","چون اونی‌یه کی خدا اوسه کوده، خدا کلامه بیان کونه، چون خدا خو روحه به یک میزان عطا نوکونه. ");
INSERT INTO glk_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","پئر پسره محبت کونه و همه چیزه به اون بیسپرده. ");
INSERT INTO glk_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","اونی کی به پسر ایمأن دأره زندگی‌یه اَبدی دأره، امّا اونی کی از پسر اطاعت نوکونه، زندگی‌یه اَبدی‌یه نیدینه، بلکی زیرِ غضبه خدا مأنه.» ");
INSERT INTO glk_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","وختی عیسی بفهمسته کی فَریسیأن بیشنَوستیدی کی اون بیشتر از یحیی شاگردأن بساخته و اوشأنه تعمید دهه، ");
INSERT INTO glk_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","گر چی عیسی شاگردأن تعمید دَییدی، نه خودش، ");
INSERT INTO glk_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","یهودیه‌یه ترکه کوده و ایبارِ دیگر به طرفه جلیل بوشو. ");
INSERT INTO glk_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","و بأیستی از سامره ردّه بوسته بی. ");
INSERT INTO glk_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","پس به ایتأ شهر از سامره کی اونه نام سوخار بو، فَرسه؛ نزدیکه او تیکه زمینی کی یعقوب خو پسر یوسفه فده بو. ");
INSERT INTO glk_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","یعقوبه چاه اویه نَهه بو و عیسی کی از سفر خسته بوسته بو، چایه کنار بینیشته. حدوداً ساعت دوازده ظهر بو. ");
INSERT INTO glk_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","در اَ وخت زنی از مردمأنه سامره آب فکشنه وستی بَمو. عیسی اونه بوگفته: «ایپچه آب مره فدن.» ");
INSERT INTO glk_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","او وخت اونه شاگردأن بوشو بید شهر، غذا تهیه بوکونید. ");
INSERT INTO glk_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","زن اونه بوگفته: «چوطو تو کی یهودی ایسی، از من کی ایتأ زنه سامری‌یم، آب خوأیی؟» چونکی یهودیأن سامریأنه اَمره هیچ معاشرتی نأشتیدی. ");
INSERT INTO glk_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","عیسی در جواب بوگفته: «اگر بخششه خدایه بدأنستی بی و دأنستی کی چه کسی از تو آب خوأیه، تو خودت از اون خوأستی تره آبه روانی کی حیات بخشه، عطا بوکونه.» ");
INSERT INTO glk_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","زن اونه بوگفته: «ای سرور، سطل نأری و چایم خیلی گوده، پس آبه روانَ از کویه اَوری؟ ");
INSERT INTO glk_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","آیا تو از اَمی پئر یعقوبم پیله‌تری کی اَ چایه اَمَره فده و خودش و اونه پسرأن و اونه گاو و گوسفندأن از او چاه آب خوردیدی؟» ");
INSERT INTO glk_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","عیسی بوگفته: «هر کسی از اَ آب بوخوره، بازم تشنه به. ");
INSERT INTO glk_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","امّا هر کی از او آبی کی من اونه فدم بوخوره، هرگز تشنه نیبه. چونکی آبی کی من اونه فدم، در اون چشمه‌یه آبی به، کی تا زندگی‌یه اَبدی جوشأنه!» ");
INSERT INTO glk_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","زن بوگفته: «ای سرور، از اَ آب مره فدن تا دِ تشنه نبم و آب فکشنه‌ره اَیه نأیم.» ");
INSERT INTO glk_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","عیسی بوگفته: «بوشو تی مردَ دوخوأن و وأگرد.» ");
INSERT INTO glk_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","زن جواب بده: «مرد نأرم.» عیسی بوگفته: «راست گی کی مرد نأری. ");
INSERT INTO glk_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","چونکی پنج‌تأ مرد دأشتی و اونم کی الأن دأری تی مرد نی‌یه. اونچی کی بوگفتی درسته!» ");
INSERT INTO glk_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","زن بوگفته: «ای سرور، دینم کی تو ایتأ نبی ایسی! ");
INSERT INTO glk_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","اَمی پئرأن اَ کوه رو عبادت کودیدی، امّا شومأن یهودیأن، گیدی جایی کی بأید در اویه عبادت بوکونید، اورشلیمه.» ");
INSERT INTO glk_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","عیسی بوگفته: «ای زن، باور بوکون زمانی فَرسه کی پئره نه اَ کوه رو عبادت کونیدی، نه اورشلیمه میأن. ");
INSERT INTO glk_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","شومأن اونچی‌یه کی نشنأسیدی عبادت کونیدی، امّا اَمأن اونچی‌یه کی شنأسیم عبادت کونیم، چونکی نجات به وسیله‌یه قومه یهود فراهم به. ");
INSERT INTO glk_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","امّا زمانی اَیه و الأنم او زمان فَرسه کی عبادت‌کوننده‌یأنه حقیقی، پئره در روح و راستی عبادت کونیدی، چونکی پئر به دونباله اَجور عبادت‌کوننده‌یأن ایسه. ");
INSERT INTO glk_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","خدا روحه و اونه عبادت‌کوننده‌یأن بأید اونه در روح و راستی عبادت بوکونید.» ");
INSERT INTO glk_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","زن بوگفته: «دأنم کی مسیح (یعنی ‹مسح بوبوسته›) اَیه. وختی اون بأیه، همه چیزه اَمَره خبر دهه.» ");
INSERT INTO glk_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","عیسی اونه بوگفته: «من کی تی اَمره حرف زِئن درم، هونم.» ");
INSERT INTO glk_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","او لحظه عیسی شاگردأن از راه فَرسه‌ییدی و از اَنکی اون ایتأ زنه اَمره حرف زِئن دوبو، تعجب بوکودیدی. امّا هیچکی وَنَورسه کی: «چی خوأیی؟» یا «چره او زنه اَمره حرف زنی؟» ");
INSERT INTO glk_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","اون وخت زن خو کوزه‌یه جا بنَه و به شهر بوشو و مردمه بوگفته: ");
INSERT INTO glk_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«بأیید مردی‌یه بیدینید کی هر چی کی تا الأن بوکوده بوم، مره بوگفته. آیا امکان نأره کی اون مسیح ببه؟» ");
INSERT INTO glk_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","پس اوشأن از شهر بیرون بَموییدی و عیسی ورجه بوشوییدی. ");
INSERT INTO glk_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","اَ میأن، شاگردأن از اون خوأهش بوکودیدی و بوگفتیدی: «اوستاد چیزی بوخور!» ");
INSERT INTO glk_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","امّا عیسی اوشأنه بوگفته: «من خوراکی، خوردنه‌ره دأرم کی شومأن از اون چیزی نأنیدی.» ");
INSERT INTO glk_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","شاگردأن همدیگره بوگفتیدی: «مگر کسی اونه‌ره خوراکی بأورده؟» ");
INSERT INTO glk_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","عیسی اوشأنه بوگفته: «می خوراک اَنه کی اراده‌یه او کسی‌یه کی مره اوسه کوده بجا بأورم و اونه کاره به کمال برسأنم. ");
INSERT INTO glk_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","آیا اَ حرفه نیشنَوستیدی کی: ‹چهار ماه بیشتر به وخته درو نمأنسته›؟ امّا من شمره گم، شیمی چشمأنه وأکونید و بیدینید کی الأن مزرعه‌یأن آماده‌یه درویه. ");
INSERT INTO glk_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","الأن دروگر خو مزده فیگیره و حاصلی برای زندگی‌یه اَبدی به دست اَوره، تا اونی کی بکاشته و اونی کی درو بوکوده، با هم شاد بیبید. ");
INSERT INTO glk_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","در اَیه اَ گفته درسته کی: ‹اینفر کأره، و اینفر دیگر درو کونه›. ");
INSERT INTO glk_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","من شمره اوسه کودم تا محصولی‌یه درو بوکونید کی شیمی دسترنج نی‌یه. دیگرأن سخت کار بوکودیدی و شومأن اوشأنه دسترنجه بردأشت کونیدی.» ");
INSERT INTO glk_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","پس به دونباله شهادته او زنی کی بوگفته بو: «هرچی کی تا الأن بوکوده بوم، مره بوگفته،» خیلی از سامریأنه ساکنه او شهر به عیسی ایمأن بأوردیدی. ");
INSERT INTO glk_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","وختی کی او سامریأن عیسی ورجه بَموییدی، از عیسی بخوأستیدی کی اوشأنه ورجه بِیسه. پس دو روز اویه بِیسه. ");
INSERT INTO glk_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","و خیلی‌یأنم بخاطره ایشنَوستنه اونه حرفأن ایمأن بأوردیدی. ");
INSERT INTO glk_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","اوشأن او زنه بوگفتیدی: «تنها دِ بخاطره تی حرفأن ایمأن نأوریم، چونکی اَمأن خودمأن اونه حرفأنه بیشنَوستیم و دأنیم کی حقیقتاً اَ مرد نجات‌دهنده‌یه دنیایه.» ");
INSERT INTO glk_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","بعد از دو روز، عیسی از اویه به جلیل بوشو. ");
INSERT INTO glk_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(قبلاً خودش بوگفته بو کی: «نبی در خودشه محل احترام نأره.») ");
INSERT INTO glk_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","وختی به جلیل فَرسه، جلیلیأن اونه به گرمی قبول بوکودیدی، چونکی اوشأن بخاطره عید به اورشلیم بوشو بید و اونچی‌یه کی عیسی اویه انجام بده بو، بیده بید. ");
INSERT INTO glk_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","بعد از اون، عیسی دوباره به قانایه جلیل بوشو، اویه کی آبه تبدیل به شراب بوکوده بو. در اویه ایتأ از افسرأن ایسه بو کی پسری مریض کَفَرناحومِ میأن دأشتی. ");
INSERT INTO glk_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","وختی بیشنَوسته کی عیسی از یهودیه به جلیل بَمو، به اونه دِئن بوشو و منّت بوکوده کی بأیه اونه پسره کی در حال مرگ بو، شفا بده. ");
INSERT INTO glk_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","عیسی اونه بوگفته: «تا معجزات و چیزأنه عجیب نیدینید، ایمأن نأوریدی!» ");
INSERT INTO glk_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","او مرد بوگفته: «ای سرور قبل از اونکی می زأی بیمیره، بیأ.» ");
INSERT INTO glk_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","عیسی اونه بوگفته: «بوشو، تی پسر زنده مأنه.» او مرد عیسی کلامه قبول بوکوده و به راه دکفته. ");
INSERT INTO glk_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","هنوز راه میأن ایسه بو کی اونه خدمتکارأن بَموییدی و بوگفتیدی: «تی پسر زنده و سالمه.» ");
INSERT INTO glk_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","از اوشأن وَورسه: «چی ساعتی اون شفا پیدا بوکوده؟» بوگفتیدی: «دیروز ساعت یکِ بعد از ظهر تب، اونه وله کوده.» ");
INSERT INTO glk_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","او وخت پئر بفهمسته کی اَن هو ساعتی بو کی عیسی اونه بوگفته بو: «تی پسر زنده مأنه.» پس خودش و اونه تمامه خانواده ایمأن بأوردیدی. ");
INSERT INTO glk_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","اَن دوّمین معجزه‌یی بو کی عیسی وختی کی از یهودیه به جلیل بَمو بو، انجام بده. ");
INSERT INTO glk_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","بعد از مدتی عیسی بخاطره ایتأ از یهودیأنه عید به اورشلیم بوشو. ");
INSERT INTO glk_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","اورشلیمه میأن، «دروازه‌یه گوسفنده» کنار حوضی نَهه کی به زبانه عبرانیأن «بیت‌حِسْدا» گیدی و پنج‌تأ اِیوانه سربسته دأره. ");
INSERT INTO glk_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","در اویه خیلی از علیلأن، مثله کورأن، شلأن و افلیجأن خوفتیدی، و منتظره حرکت آب بیدی. ");
INSERT INTO glk_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","چونکی هرچند وخت ایبار ایتأ فرشته‌یه خداوند اَمویی کی آبه حوضه به حرکت بأوره. اوّلین نفری کی بعد از به حرکت اَمونه آب وارده اون بوستی، از هر مرضی کی دأشتی، شفا پیدا کودی. ");
INSERT INTO glk_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","اَ میأنی مردی ایسه بو کی سی و هشت سال زمینگیر بو. ");
INSERT INTO glk_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","وختی عیسی بیده اون اویه خوفته، بفهمسته کی خیلی وخته به اَ حال دوچاره. از اون وَورسه: «آیا خوأیی کی تی سلامتی‌یه به دست بأوری؟» ");
INSERT INTO glk_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","مردِ علیل بوگفته: «ای سرور، کسی‌یه نأرم کی وختی آب به حرکت اَیه، مره حوضه میأن تَوَدَه. تا اَیم خودمه به اویه فَرسأنم، کسه دیگری پیشتر از من آبه میأن دکفه.» ");
INSERT INTO glk_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","عیسی اونه بوگفته: «ویریز، تی جایه جمعَ کون و راه بوشو.» ");
INSERT INTO glk_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","او مرد در هو لحظه خو سلامتی‌یه به دست بأورده و خو جایه جمعَ کوده و شروع بوکوده به راه شوئون. او روز، شَبّات بو. ");
INSERT INTO glk_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","پس حاکمأنه یهود او مردی‌یه کی شفا پیدا بوکوده بو، بوگفتیدی: «امروز روزِ شَبّاته و تو اجازه نأری کی تی جایه جمعَ کونی!» ");
INSERT INTO glk_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","اون جواب بده: «اونی کی مره شفا بده مره بوگفته، ‹تی جایه جمعَ کون و راه بوشو.›» ");
INSERT INTO glk_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","از اون وَورسه‌ییدی: «اونی کی تره بوگفته تی جایه جمعَ کون و راه بوشو، کی بو؟» ");
INSERT INTO glk_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","امّا او مردی کی شفا پیدا بوکوده بو، نأنستی کی اون کی ایسه. چونکی عیسی جمعیته میأن ناپدیده بوسته بو. ");
INSERT INTO glk_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","مدتی بعد، عیسی او مردَ معبده میأن پیدا بوکوده و اونه بوگفته: «الأن کی تی سلامتی‌یه پیدا بوکودی، دِ گناه نوکون تا از اونی کی بی بدتره نیبی.» ");
INSERT INTO glk_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","او مرد بوشو و یهودیأنه بوگفته: «اونی کی مره شفا بده، عیسایه!» ");
INSERT INTO glk_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","به اَ دلیل بو کی حاکمأنه یهود عیسایه آزار دَییدی، چونکی در روزِ شَبّات دست به اَجور کارأن زه‌یی. ");
INSERT INTO glk_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","عیسی جواب بده: «می پئر هنوز کار کونه، منم کار کونم.» ");
INSERT INTO glk_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","به اَ خاطر یهودیأن بیشتر از قبل خوأستیدی کی اونه بوکوشید، چونکی نه تنها روزِ شَبّاته ایشکنه‌یی، بلکی خدایه خو پئر دوخوأدی و خودشه خدا اَمره برابر دأنستی. ");
INSERT INTO glk_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","عیسی جواب بده: «آمین، آمین، شمره گم کی پسر از خودش هیچ کاری نتأنه انجام بده مگر او کارأیی کی پئر انجام دهه، پسر بیدینه. چونکی هرچی کی پئر کونه، پسرم کونه. ");
INSERT INTO glk_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","پئر پسره دوست دأره و هر کاری کی کونه، اونه نیشأن دهه و کارأیی از اَن بزرگترم در آینده نیشأن دهه تا شومأن از تعجب مات بمأنید. ");
INSERT INTO glk_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","هوطو کی پئر مُرده‌یأنه ویریزأنه و اوشأنه زندَه کونه، پسر هم هر کسی‌یه کی بخوأیه، زندَه کونه. ");
INSERT INTO glk_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","پئر کسی‌یه داوری نوکونه، بلکی تمامه کاره داوری‌یه به پسر بیسپرده. ");
INSERT INTO glk_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","تا همه پسره احترام بوکونید، هوطو کی پئره احترام نهیدی. کسی کی پسره احترام نوکونه، به پئری کی اونه اوسه کوده، احترام ننَه. ");
INSERT INTO glk_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","آمین، آمین، شمره گم هر کی می کلامه گوش بده و به کسی کی مره اوسه کوده ایمأن بأوره، زندگی‌یه اَبدی دأره و محکومه نیبه، بلکی از مرگ به زندگی‌یه اَبدی انتقال پیدا کونه. ");
INSERT INTO glk_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","آمین، آمین، شمره گم، زمانی فَرسه، بلکی الأنه کی مُرده‌یأن، خدا پسره صدایه ایشنَویدی و هر کی گوش بده، زندَه به. ");
INSERT INTO glk_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","چونکی هوطو کی پئر در خودش حیات دأره، خو پسرم عطا بوکوده کی در خودش حیات بدأره. ");
INSERT INTO glk_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","و اونه اَ قدرته ببخشه کی داوری بوکونه، چونکی انسانه پسره. ");
INSERT INTO glk_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","از اَ حرفأن تعجب نوکونید، چونکی زمانی فَرسه کی همه‌یه اوشأنی کی در قبریدی، اونه صدایه ایشنَویدی و بیرون اَییدی. ");
INSERT INTO glk_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","اوشأنی کی خوبی بوکوده بید، برای قیامتی کی خو دونبال زندگی اَبدی‌یه دأره. اوشأنی کی بدی بوکوده بید، برای قیامتی کی خو دونبال مکافاتَه دأره. ");
INSERT INTO glk_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","من از خودم هیچ کاری نتأنم بوکونم، بلکی از اونچی کی ایشنَوم، داوری کونم و می داوری‌یم عادلأنه‌یه، چونکی به دونبال انجامه می خوأسته‌یأن نی‌یم، بلکی خوأیم خوأسته‌یه اونی‌یه کی مره اوسه کوده انجام بدَم. ");
INSERT INTO glk_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«اگر خودم مره شهادت بدَم، می شهادت اعتبار نأره. ");
INSERT INTO glk_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","امّا کسی دیگری ایسه کی مره شهادت دهه و دأنم کی اونه شهادت در مورده من معتبره. ");
INSERT INTO glk_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","البته شومأن کسأنی‌یه یحیی ورجه اوسه کودیدی و اون بر حقیقت شهادت بده. ");
INSERT INTO glk_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","نه بخاطره اَنکی من انسانه شهادته قبول بوکونم، بلکی اَ حرفأنه زنم تا نجات پیدا بوکونید. ");
INSERT INTO glk_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","یحیی چراغی بو روشن و نورانی و شومأن خوأستیدی کی زمانی اونه نوره میأن خوش بیبید. ");
INSERT INTO glk_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","امّا من شهادتی محکمتر از یحیی شهادت دأرم، چونکی پئر کارأنی مره بیسپرده تا به کمال برسأنم، یعنی اَ کارأنی کی کونم، مره شهادت دهه کی مره پئر اوسه کوده. ");
INSERT INTO glk_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","هو پئری کی مره اوسه کوده، خودش مره شهادت دهه. شومأن هرگز اونه صدایه نیشنَوستیدی و اونه رویه نیده‌ییدی. ");
INSERT INTO glk_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","اونه کلامه شیمی دیله میأن نأریدی. چونکی به اونی کی اونه اوسه کوده ایمأن نأریدی. ");
INSERT INTO glk_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","هَه کیتابه مقدّسه به دقّت خوأنیدی، چونکی فکر کونیدی توسطه اون زندگی‌یه اَبدی دأریدی، در حالی کی هَه کیتابأنه کی مره شهادت دهه. ");
INSERT INTO glk_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","امّا نخوأییدی می ورجه بأیید تا زندگی‌یه اَبدی پیدا بوکونید. ");
INSERT INTO glk_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«جلاله از آدمیأن قبول نوکونم. ");
INSERT INTO glk_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","امّا شمره شنأسم کی خدا محبته شیمی دیله دورون نأریدی. ");
INSERT INTO glk_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","من به نامِ می پئر بَموم، امّا شومأن مره قبول نوکونیدی. امّا اگر کسی دیگری به نامِ خودش بأیه، شومأن اونه قبول کونیدی. ");
INSERT INTO glk_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","چوطو تأنیدی ایمأن بأورید، در حالی کی همدیگره جلال دیهیدی. امّا به دونباله جلالی کی از خدایه یکتا ایسه، نی‌ییدی؟ ");
INSERT INTO glk_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","فکر نوکونید اون منم کی پئره ورجه شمره متهم کونم. شیمی متهم‌کوننده موسایه، هونی کی شومأن به اون امید دَوَستیدی. ");
INSERT INTO glk_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","اگر موسایه قبول دأشتیدی، مرم قبول کودیدی، چونکی اون درباره‌یه من بینیویشته بو. ");
INSERT INTO glk_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","امّا اگر اونه نیویشته‌یأنه باور نأریدی، چوطو می حرفأنه قبول کونیدی؟» ");
INSERT INTO glk_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","مدتی بعد، عیسی به او طرفه دریاچه جلیل کی هو دریاچه تیبِریه بو، بوشو. ");
INSERT INTO glk_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","گرویه زیادی اونه دونبالسر بوشوییدی چونکی معجزاتی کی با شفایه مریضأن انجام بده بو، بیده بید. ");
INSERT INTO glk_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","پس عیسی تپه جور بوشو و خو شاگردأنه اَمره اویه بینیشته. ");
INSERT INTO glk_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(یهودیأنه عیده پِسَخ نزدیک بو.) ");
INSERT INTO glk_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","وختی عیسی نیگاه بوکوده، بیده کی گرویه زیادی اونه طرف اَمون دریدی، فیلیپُسه بوگفته: «از کویه نان بیهینیم تا اَشأن بوخورید؟» ");
INSERT INTO glk_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","عیسی اَ حرفه بوگفته چون خوأستی اونه امتحان بوکونه و خودش بهتر دأنستی کی چی بوکونه. ");
INSERT INTO glk_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","فیلیپُس جواب بده: «دیویست دینار نانم اوشأنه سئره نوکونه، حتی اگر هر کدامه اوشأن ایپچه نان بوخورید.» (دیویست دینار، او موقع حدوده هشت ماهه کارگره مزد بو.) ");
INSERT INTO glk_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ایتأ دیگر از شاگردأن به نامِ آندریاس کی شَمعونِ پِطرُسِ برأر بو، بوگفته: ");
INSERT INTO glk_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«ایتأ پسر بچه ایسَه کی پنج‌تأ نانه جو و دوتأ ماهی دأره، امّا اَن، چوطو اَ گرویه سئره کونه؟» ");
INSERT INTO glk_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","عیسی بوگفته: «مردمه بینیشأنید.» اویه سبزه‌زار زیاد بو. او جمعیت میأن پنج هزار نفر فقط مرد بید. ");
INSERT INTO glk_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","اون وخت عیسی نانه فیگیفته و شکرگزاری بوکوده و اونه شاگردأن، بین اوشأنی کی نیشته بید، تقسیم بوکودیدی، و ماهی‌یأنه اَمره‌یم هو کاره بوکوده، به اندازه‌یی کی خوأستیدی اوشأنه فده. ");
INSERT INTO glk_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","وختی سئره بوستیدی، خو شاگردأنه بوگفته: «هر چی زیاد بَمو خورده‌نانأنه جمعَ کونید تا چیزی از بین نشه.» ");
INSERT INTO glk_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","پس اوشأنه جمعَ کودیدی و از باقی‌مانده‌یه او پنج‌تأ نانه جو کی جماعت بوخورده بید، دوازده‌تأ زنبیل پُره بوسته! ");
INSERT INTO glk_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","مردم با دِئنه اَ معجزه کی از عیسی ظاهره بوسته، بوگفتیدی: «راستی، راستی کی اون هو پیامبری ایسه کی بأیستی به جهان بَمو بی.» ");
INSERT INTO glk_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","عیسی وختی بفهمسته کی اوشأن تصمیم دأریدی اونه به زور پادشاه بوکونید، او جایه ترکه کوده و تنهایی به کوه بوشو. ");
INSERT INTO glk_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","غروب دم، اونه شاگردأن به سمته دریاچه بیزیر بَموییدی. ");
INSERT INTO glk_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","هوا تاریک بو و عیسی هنوز اوشأنه اَمره نِیسه بو، اوشأن سوارِ قایق بوبوستیدی و به او طرفه دریاچه، به طرفه کَفَرناحوم بوشوییدی. ");
INSERT INTO glk_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","امّا در اَ موقع، دریاچه بخاطره وزشه باده سختی کی اَمویی به تلاطم دکفته. ");
INSERT INTO glk_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","وختی به اندازه پنج یا شیش کیلومتر پارو بزه بید، عیسایه بیده‌ییدی کی آبه رو راه شوئون دره و قایقه نزدیکه بوستن دره. پس هراسأنه بوستیدی. ");
INSERT INTO glk_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","امّا عیسی اوشأنه بوگفته: «منم، نترسید!» ");
INSERT INTO glk_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","اون وخت خوأستیدی اونه سوارِ قایق بوکونید، کی قایق هو لحظه به مقصد فَرسه. ");
INSERT INTO glk_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","روزِ بعد، جماعتی کی او طرفه دریاچه ایسه بید، بفهمستیدی کی بجز ایتأ قایق، قایقه دیگری اویه ننَه بو و دأنستیدی کی عیسی خو شاگردأنه اَمره اونه سوارَ نوبوسته بو، بلکی شاگردأن تنهایی بوشو بید. ");
INSERT INTO glk_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","اون وخت قایقأنه دیگری از تیبِریه بَموییدی و نزدیکه جایی فَرسه‌ییدی کی اوشأن بعد از شکرگزاریه عیسی، نان بوخورده بید. ");
INSERT INTO glk_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","وختی مردم بفهمستیدی کی نه عیسی اویه ایسه و نه اونه شاگردأن، او قایقأنه سوارَ بوستیدی و به دونباله عیسی به کَفَرناحوم بوشوییدی. ");
INSERT INTO glk_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","وختی اونه او طرفه دریاچه پیدا بوکودید، اونه وَورسه‌ییدی: «ای اوستاد، کِـی اَیه بَمویی؟» ");
INSERT INTO glk_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","عیسی جواب بده: «آمین، آمین، شمره گم، می دونبال گردیدی نه به دلیله معجزاتی کی بیده‌ییدی، بلکی بخاطره او نانی کی بوخوردیدی و سئره بوستیدی. ");
INSERT INTO glk_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","کار بوکونید امّا نه خوراکه فانی‌ره، برای خوراکی کی تا زندگی‌یه اَبدی باقی‌یه، خوراکی کی انسانه پسر شمره فده. چونکی بر پسره کی خدایه پئر، مُهرِ تأیید بزه.» ");
INSERT INTO glk_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","اون وخت از اون وَورسه‌ییدی: «چی بوکونیم تا کارأیی کی خدا خوأیه انجام بدیم؟» ");
INSERT INTO glk_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","عیسی در جواب بوگفته: «کاری کی خدا خوأسته‌یه اَنه کی به او کسی کی اون اوسه کوده ایمأن بأورید.» ");
INSERT INTO glk_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","بوگفتیدی: «چی معجزه‌یی اَمَره نیشأن دیهی تا با اونه دِئن، تره ایمأن بأوریم؟ چی کونی؟ ");
INSERT INTO glk_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","اَمی پئرأن بیابانه میأنی مَنّایه کی خوراکه آسمانی بو، بوخوردیدی هوطو کی بینیویشته نَهه: ‹اون از آسمان اوشأنه نان فده تا بوخورید.›» ");
INSERT INTO glk_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","عیسی جواب بده: «آمین، آمین، شمره گم، موسی نبو کی از آسمان او نانه شمره فده، بلکی می پئر بو کی نانه حقیقی‌یه از آسمان شمره فده. ");
INSERT INTO glk_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","چونکی خدا نان، کسی‌یه کی از آسمان نازله به و به دنیا حیات بخشه.» ");
INSERT INTO glk_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","پس بوگفتیدی: «اَ نانه برای همیشه اَمَره فدن.» ");
INSERT INTO glk_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","عیسی اوشأنه بوگفته: «من نانه حیات ایسم، هر کی می ورجه بأیه، هرگز گرسنه نیبه و هر کی مره ایمأن بأوره، هرگز تشنه نیبه. ");
INSERT INTO glk_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ولی هوطو کی شمره بوگفتم، هرچند کی مره بیده‌ییدی، امّا ایمأن نأوریدی. ");
INSERT INTO glk_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","هر کسی کی پئر، مره ببخشه، می ورجه اَیه و هر کی می ورجه بأیه، هیچ وخت اونه از خودم دوره نوکونم. ");
INSERT INTO glk_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","چونکی از آسمان بیزیر نَموم کی می خوأسته‌یه عمل بوکونم، بلکی بَموم تا خوأسته‌یه کسی‌یه کی مره اوسه کوده انجام بدَم. ");
INSERT INTO glk_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","و خوأسته‌یه کسی کی مره اوسه کوده اَنه کی کسأنی‌یه کی اون مره ببخشه، هیچ‌کدامه از دست ندم، بلکی اوشأنه در روزِ آخر ویریزأنم. ");
INSERT INTO glk_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","و می پئره خوأسته اَنه کی هر کسی کی پسره بیدینه به اون ایمأن بأوره، از زندگی‌یه اَبدی برخوردأره به، و من اونه در روزِ آخر ویریزأنم.» ");
INSERT INTO glk_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","اون وخت یهودیأن درباره‌یه اون شروع به همهمه بوکودیدی، چونکی بوگفته بو: «من او نان ایسم کی، از آسمان نازله بوسته.» ");
INSERT INTO glk_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","اوشأن گفتیدی: «مگر اَ مرد، عیسی، یوسفه پسر نی‌یه کی اونه پئر و ماره اَمأن شنأسیم؟ پس چوطو گه کی ‹از آسمان نازله بوستم›؟» ");
INSERT INTO glk_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","عیسی در جواب بوگفته: «همدیگره اَمره همهمه نوکونید! ");
INSERT INTO glk_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","هیچکس نتأنه می ورجه بأیه مگر، پئری کی مره اوسه کوده اونه جذب بوکونه. من اونه در روزِ آخر ویریزأنم. ");
INSERT INTO glk_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","در کیتابه انبیا بَمو کی: ‹همه از خدا تعلیم گیریدی.› پس هر کی از خدا بیشنَوه و از اون تعلیم بیگیره، می ورجه اَیه. ");
INSERT INTO glk_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","هیچ کس پئره نیده، مگر اون کسی کی از طرفه خدا بَمو؛ اون، پئره بیده. ");
INSERT INTO glk_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","آمین، آمین، شمره گم، هر کی ایمأن بأوره، از زندگی‌یه اَبدی برخوردأره. ");
INSERT INTO glk_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","من نانه زندگی ایسم. ");
INSERT INTO glk_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","شیمی پئرأن بیابانه میأن مَنّایه بوخوردیدی، ولی به هر حال بمَردیدی. ");
INSERT INTO glk_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","امّا نانی کی از آسمان نازله به، هر کی از اون بوخوره، نیمیره. ");
INSERT INTO glk_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","اون نانه زنده من ایسم کی از آسمان نازله بوسته. هر کی اَ نانه بوخوره، تا اَبد زنده مأنه. نانی کی من برای حیاته دنیا بخشم، می بدنه.» ");
INSERT INTO glk_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","پس بحثه تندی حاکمأنه یهوده میأن به وجود بَمو کی: «اَ مرد چوطو تأنه خو بدنه اَمَره فده تا بوخوریم؟» ");
INSERT INTO glk_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","عیسی اوشأنه بوگفته: «آمین، آمین، شمره گم کی تا انسانه پسره بدنه نوخورید و اونه خونه ننوشید، در خودتأن زندگی اَبدی نأریدی. ");
INSERT INTO glk_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","هر کی می بدنه بوخوره و می خونه بنوشه، زندگی‌یه اَبدی دأره و من در روزِ آخر اونه ویریزأنم. ");
INSERT INTO glk_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","چونکی می بدن خوراکه حقیقی و می خون نوشیدنی‌یه حقیقی‌یه. ");
INSERT INTO glk_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","کسی کی می بدنه خوره و می خونه نوشه در من ساکنه به و منم در اون ساکنه بم. ");
INSERT INTO glk_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","هوطو کی پئره زنده مره اوسه کوده منم به می پئر زنده‌یم، اونی کی مره خوره، توسطه من زنده مأنه. ");
INSERT INTO glk_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","اَن، نانی‌یه کی از آسمان نازله بوسته، نه مثله اونچی کی شیمی پئرأن بوخوردیدی و به هر حال بمَردیدی؛ بلکی هر کی از اَ نان بوخوره، تا اَبد زنده مأنه.» ");
INSERT INTO glk_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","عیسی اَ حرفأنه زمانی بوگفته کی کَفَرناحومه کنیسه میأن تعلیم دَیی. ");
INSERT INTO glk_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","خیلی از اونه شاگردأن با ایشنَوستنه اَ حرفأن بوگفتیدی: «اَ تعلیم خیلی سخته، کی تأنه اونه قبول بوکونه؟» ");
INSERT INTO glk_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","عیسی دأنستی کی اونه شاگردأن درباره‌یه اونه حرفأن همهمه کودن دریدی. اوشأنه بوگفته: «آیا اَن باعثه شیمی انحراف به؟ ");
INSERT INTO glk_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","پس اگر انسانه پسره بیدینید کی به خو جایه اوّل صعود بوکونه، چی کونیدی؟ ");
INSERT INTO glk_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","روحه کی زندَه کونه، جسم فایده‌یی نأره. حرفأنی کی من شمره بوگفتم، روح و زندگی‌یه. ");
INSERT INTO glk_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","امّا بعضی از شومأن ایسه‌ییدی کی ایمأن نأوریدی.» عیسی از اوّل دأنستی کی چی کسأنی ایمأن نأوریدی و کی‌یه کی اونه به دشمن تسلیم کونه. ");
INSERT INTO glk_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","بعد از اون، بوگفته: «هَنه وستی شمره بوگفتم کی هیچکس نتأنه می ورجه بأیه، مگر اَنکی از پئره طرف به اون عطا بوبوسته بی.» ");
INSERT INTO glk_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","در اَ زمان خیلی از اونه شاگردأن وأگردستیدی و دِ اونه همرأهی نوکودیدی. ");
INSERT INTO glk_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","پس عیسی او دوازده شاگرده کی قبلاً انتخاب بوکوده بو بوگفته: «آیا شومأنم خوأییدی بیشید؟» ");
INSERT INTO glk_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","شَمعونِ پِطرُس جواب بده: «ای سرور، کی ورجه بیشیم؟ کلماته زندگی‌یه اَبدی تی ورجه نَهه. ");
INSERT INTO glk_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","و اَمأن ایمأن بأوردیم و دأنیم کی تویی او قدّوس از پیشه خدا.» ");
INSERT INTO glk_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","عیسی اوشأنه جواب بده: «مگر شومأن دوازده نفره من انتخاب نوکودم؟ با اَ حال ایتأ از شومأن از ابلیسه.» ");
INSERT INTO glk_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","اون به یهودا، شَمعونِ اِسْخَریوطی پسر، اشاره کودی، چونکی ایتأ از او دوازده نفر بو کی بعد از مدتی عیسایه به دشمن تسلیم کودی. ");
INSERT INTO glk_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","از اون به بعد عیسی جلیلِ میأن گردستی، نخوأستی یهودیه میأن بِیسه، چونکی حاکمأنه یهود خوأستیدی اونه بوکوشید. ");
INSERT INTO glk_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","وختی عیده خیمه‌یأن کی ایتأ از یهودیأنه عید بو، نزدیکه بوسته، ");
INSERT INTO glk_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","عیسی برأرأن اونه بوگفتیدی: «اَیه ترکه کون و به یهودیه بوشو، تا تی هوادارأن کارأیی کی کونی، بیدینید. ");
INSERT INTO glk_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","چونکی هر کی خوأیه شنأخته ببه، خلوتی کار نوکونه. تو کی اَ کارأنه کونی، دنیایه نیشأن بدَن.» ");
INSERT INTO glk_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","چونکی حتی اونه برأرأنم اونه ایمأن نأورده بید. ");
INSERT INTO glk_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","پس عیسی اوشأنه بوگفته: «می وخت هنوز فَنرسه، امّا شیمی‌ره هر وختی مناسبه. ");
INSERT INTO glk_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","دنیا نتأنه از شومأن متنفر ببه، امّا از من نفرت دأره، چونکی من شهادت دهم کی اونه کارأن، بده. ");
INSERT INTO glk_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","شومأن خودتأن به عید بیشید. من الأن نأیم، چونکی می وخت هنوز فَنرسه.» ");
INSERT INTO glk_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","اَنه بوگفته و جلیلِ میأن بِیسه. ");
INSERT INTO glk_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","امّا بعد از اونکی اونه برأرأن به عید بوشوییدی، خودشم بوشو، امّا نه آشکارا بلکی خلوتی. ");
INSERT INTO glk_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","پس حاکمأنه یهود، عیده موقع اونه دونبال بیدی و وَورسه‌ییدی: «او مرد کویه ایسه؟» ");
INSERT INTO glk_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","درباره‌یه اون مردمه میأن همهمه زیاد بو. تعدادی گفتیدی: «مردِ خوبی ایسه» و تعداده دیگرم گفتیدی: «نه، بلکی مردمه گمراهه کونه.» ");
INSERT INTO glk_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","چون از حاکمأنه یهود ترس دأشتیدی، هیچکس درباره‌یه اون آشکارا حرف نزه‌یی. ");
INSERT INTO glk_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","چون نیمی از عید بوگذشته بو، عیسی به صحنِ معبد بَمو و شروع به تعلیم بوکوده. ");
INSERT INTO glk_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","یهودیأن تعجب بوکودیدی و وَورسه‌ییدی: «اَ مرد کی درسه الهی نخوأنده، چوطو تأنه اَنقدر معلومات بدأره؟» ");
INSERT INTO glk_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","عیسی در اوشأنه جواب بوگفته: «می تعالیم از من نی‌یه، بلکی از کسی ایسه کی مره اوسه کوده. ");
INSERT INTO glk_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","اگر کسی براستی بخوأیه کی اونه اراده‌یه انجام بده، فهمه کی اَ تعالیم از خدایه، یا اَن کی من از خودم گم. ");
INSERT INTO glk_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","اونی کی از خودش گه، به دونبال اَنه کی خودشه جلال بده، امّا اونی کی خوأیه کسی‌یه کی اونه اوسه کوده جلال بده، راستگه و در اون هیچ ناراستی‌یی ننَه. ");
INSERT INTO glk_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","آیا موسی شریعته شمره فنده؟ امّا هیچ‌کدام از شومأن به اون عمل نوکونیدی. پس چره خوأییدی مره بوکوشید؟» ");
INSERT INTO glk_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","مردم جواب بدَییدی: «تره دیوبزه، کی‌یه کی تی کوشتنه دونبال ببه؟» ");
INSERT INTO glk_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","عیسی در جوابه اوشأن بوگفته: «من ایتأ معجزه بوکودم و شومأن همه‌تأ از اون ماته بوستیدی. ");
INSERT INTO glk_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","موسی حکمه ختنه‌یه شمره فده - البته اَن نه از طرفه موسی بو، بلکی از طرفه پئرأنه قوم بو - و طبقِ اَ حکم، شومأن شیمی پسرأنه در روزِ شَبّات ختنه کونیدی. ");
INSERT INTO glk_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","پس اگر انسان در روزِ شَبّات ختنه به تا موسی شریعت نشکفه، چره عصبانی بیدی از اَنکی تمامه بدنه انسانی‌یه در روزِ شَبّات سلامتی ببخشم؟ ");
INSERT INTO glk_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","سرسری داوری نوکونید، بلکی به حق داوری بوکونید.» ");
INSERT INTO glk_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","پس بعضی از اهالی‌یه اورشلیم بوگفتیدی: «آیا اَن هونی نی‌یه کی قصد دأریدی اونه بوکوشید؟ ");
INSERT INTO glk_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","بیدینید چوطو آشکارا حرف زنه و اونه هیچی نیگیدی! آیا امکان دأره کی حاکمأنه قوم اَ حقیقته بفهمستیدی کی اون هو مسیحه؟ ");
INSERT INTO glk_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","اَمأن دأنیم کی اَ مرد از کویه بَمو، وختی کی مسیح ظهور بوکونه، کسی نأنه کی از کویه اَیه.» ");
INSERT INTO glk_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","اون وخت عیسی موقعه تعلیم معبده میأنی، با صدایه بلند بوگفته: «مره شنأسیدی و دأنیدی کی کویه‌شینم، امّا من از طرفه خودم نَموم؛ اونی کی مره اوسه کوده، حقِ و شومأن اونه نشنأسیدی. ");
INSERT INTO glk_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","امّا من اونه شنأسم، چونکی من از اونم و اون مره اوسه کوده.» ");
INSERT INTO glk_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","پس خوأستیدی کی اونه گرفتاره کونید، امّا هیچکی اونه دست درازه نوکوده، چونکی اونه وخت فَنرسه بو. ");
INSERT INTO glk_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","به هر حال خیلی از مردم اونه ایمأن بأوردیدی. اوشأن گفتیدی کی: «آیا وختی مسیح بأیه، از اَ مرد بیشتر معجزه کونه؟» ");
INSERT INTO glk_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","امّا فَریسیأنه گوش فَرسه کی مردم درباره‌یه عیسی اَجور همهمه کونیدی. پس سرأنه کاهنأن و فَریسیأن، قراولأنه معبده اوسه کودیدی تا اونه گرفتاره کونید. ");
INSERT INTO glk_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","اون وخت عیسی بوگفته: «زمانه کمی شیمی اَمره ایسَم، از اَن به بعد او کسی ورجه شم کی مره اوسه کوده. ");
INSERT INTO glk_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","می دونبال گردیدی، امّا پیدا نوکونیدی، و جایی کی من شم، شومأن نتأنیدی بأیید.» ");
INSERT INTO glk_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","پس یهودیأن همدیگره گفتیدی کی: «اَ مرد کویه شه کی اَمأن نتأنیم اونه پیدا بوکونیم؟ نوکونه خوأیه بشه یهودیأنی ورجه کی بین یونانیأن پراکنده‌ییدی و یونانیأنه تعلیم بده. ");
INSERT INTO glk_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","اونه منظور چی بو کی بوگفته ‹می دونبال گردیدی، امّا نتأنیدی پیدا بوکونید و جایی کی من ایسم، شومأن نتأنیدی بأیید؟›» ");
INSERT INTO glk_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","روزِ آخر کی روزِ بزرگه عید بو، عیسی بِیسه و با صدایه بلند بوگفته: «هر کی تشنه‌یه، می ورجه بأیه و آب بوخوره. ");
INSERT INTO glk_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","هر کی به من ایمأن بأوره، هوطو کی کیتابه مقدّس گه، از اونه وجود چشمه‌یأنه آبه زنده جاری به.» ");
INSERT INTO glk_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","اَ حرفه درباره‌یه روح بوگفته کی کسأنی کی به اون ایمأن بأورید، او روحه پیدا کونیدی. چونکی روح هنوز عطا نوبوسته بو، و عیسی هنوز جلال پیدا نوکوده بو. ");
INSERT INTO glk_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","بعضی از مردم با ایشنَوستنه اَ حرفأن گفتیدی کی: «راستی، راستی کی اَ مرد هو پیامبره موعوده.» ");
INSERT INTO glk_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","دیگرأن گفتیدی کی: «اون مسیحه!» امّا گروهی دیگر وَورسه‌ییدی: «مگر مسیح از جلیل ظهور کونه؟ ");
INSERT INTO glk_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","مگر کیتابه مقدّس نوگفته کی مسیح از نسله داووده و از بیت‌لِحِم، دِهی کی داوود در اون زندگی کودی، ظهور کونه؟» ");
INSERT INTO glk_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","پس بخاطره عیسی مردمه میأنی اختلاف دکفته. ");
INSERT INTO glk_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","تعدادی خوأستیدی کی اونه گرفتاره کونید، امّا هیچکی اونه دست درازه نوکوده. ");
INSERT INTO glk_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","پس قراولأنه معبد وأگردستیدی سرأنه کاهنأن و فَریسیأنه ورجه. فَریسیأن و سرأنه کاهنأن از اوشأن وَورسه‌ییدی: «چره اونه نأوردیدی؟» ");
INSERT INTO glk_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","قراولأن جواب بدَییدی: «تا الأن مثله اَ مرد کسی حرف نزه.» ");
INSERT INTO glk_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","پس فَریسیأن بوگفتیدی: «مگر شومأنم فریب بوخوردیدی؟ ");
INSERT INTO glk_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","آیا از حاکمأن یا فَریسیأن کسی ایسه کی اونه ایمأن بأورده بی؟ ");
INSERT INTO glk_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","البته کی نه! امّا اَ مردمه نادان کی از شریعت چیزی نأنیدی، ملعونیدی.» ");
INSERT INTO glk_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","نیقودیموس کی پیشتر عیسی ورجه بوشو بو و ایتأ از فَریسیأن بو، بوگفته: ");
INSERT INTO glk_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«آیا اَمی شریعت کسی‌یه محکوم کونه، بدونه اَنکی اوّل اونه حرفه بیشنَوه و بدأنه کی چی بوکوده؟» ");
INSERT INTO glk_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","در جواب بوگفتیدی: «مگر تونم جلیلی‌یی؟ تحقیق بوکون و بیدین کی هیچ پیامبری از جلیل وینیریزه!» ");
INSERT INTO glk_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","بعد از اون، هر کی خودشه خانه بوشو. ");
INSERT INTO glk_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","امّا عیسی بوشو به کوهه زیتون. ");
INSERT INTO glk_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","وخته سحر عیسی بازم به صحنِ معبد بَمو. در اویه مردم همه اونه دور جمعَ بوستیدی عیسی بینیشته و اوشأنه تعلیم بده. ");
INSERT INTO glk_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","در اَ وخت علمایه دین و فَریسیأن، زنی‌یه کی در حینه زنا بیگیفته بید، بأوردیدی و اونه مردمه میأن بدأشتیدی. ");
INSERT INTO glk_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","عیسایه بوگفتیدی: «اوستاد، اَ زنه در حینه زنا بیگیفتیدی. ");
INSERT INTO glk_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","موسی در شریعت، اَمَره حکم بوکوده کی اَجور زنأکأن سنگسار بیبید. امّا تو چی گی؟» ");
INSERT INTO glk_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","اَنه بوگفتیدی تا اونه امتحان بوکونید تا ایتأ بهانه‌یی بدأرید و اونه محکوم بوکونید. امّا عیسی خو سره بیزیر تَوَدَه و خو انگوشته اَمره زمینه رو نیویشتی. ");
INSERT INTO glk_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","امّا چونکی اوشأن بازم از اون سؤال کودیدی، عیسی خو سره بلنده کوده و اوشأنه بوگفته: «از شیمی میأنی هر کسی کی گناهی نأره، اوّلین سنگه اونه بزنه.» ");
INSERT INTO glk_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","بازم خو سره بیزیر تَوَدَه و زمینه رو نیویشتی. ");
INSERT INTO glk_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","با ایشنَوستن اَ حرف اوشأن، ایتأ ایتأ از بزرگترأن شروع بوکودیدی و از اویه بوشوییدی و عیسی اویه او زنه اَمره تنها بِیسه. ");
INSERT INTO glk_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","اون وخت عیسی خو سره بلنده کوده و اونه بوگفته: «ای زن، اوشأن کویه ایسه‌ییدی؟ هیچکس تره محکوم نوکوده؟» ");
INSERT INTO glk_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","جواب بده: «هیچکس، ای سرور.» عیسی اونه بوگفته: «منم تره محکوم نوکونم. بوشو، و دِ گناه نوکون.» ");
INSERT INTO glk_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","پس عیسی ایبارِ دیگر مردمه اَمره حرف بزه و بفرمأسته: «من نوره دنیا ایسم، هر کی از من پیروی بوکونه، هرگز در تاریکی راه نیشه، بلکی از نوره زندگی برخوردأره به.» ");
INSERT INTO glk_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","پس فَریسیأن اونه بوگفتیدی: «تو خودت، خودته‌ره شهادت دیهی، پس تی شهادت معتبر نی‌یه.» ");
INSERT INTO glk_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","عیسی در جوابه اوشأن بوگفته: «هرچند کی من خودم، خودمه‌ره شهادت دهم، ولی می شهادت معتبره، چونکی دأنم از کویه بَموم و به کویه شم، امّا شومأن نأنیدی کی من از کویه بَموم و به کویه شم. ");
INSERT INTO glk_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","شومأن فکره انسانی اَمره داوری کونیدی، امّا من کسی‌ره داوری نوکونم. ");
INSERT INTO glk_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ولی اگر داوری‌یم بوکونم، می داوری درسته، چونکی تنها نی‌یم، بلکی پئری کی مره اوسه کوده، می اَمره‌یه. ");
INSERT INTO glk_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","شیمی شریعته دورون بینیویشته بو کی شهادته دوتأ شاهد معتبره. ");
INSERT INTO glk_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","من خودم مره شهادت دهم و می پئرم کی مره اوسه کوده، مره شهادت دهه.» ");
INSERT INTO glk_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","اون وخت از عیسی وَورسه‌ییدی: «تی پئر کویه ایسه؟» عیسی جواب بده: «نه مره شنأسیدی نه می پئره. اگر مره شنأختیدی می پئرم شنأختیدی.» ");
INSERT INTO glk_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","عیسی اَ حرفأنه زمانی کی در بیت‌الماله معبد تعلیم دَیی، بیان بوکوده، امّا هیچکس اونه دستگیر نوکوده چونکی اونه وخت هنوز فَنرسه بو. ");
INSERT INTO glk_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","عیسی ایدفعه دیگر اوشأنه بوگفته: «من شم و شومأن می دونبال گردیدی و شیمی گناهأنه میأن میریدی. او جایی کی من شم، شومأن نتأنید بأیید.» ");
INSERT INTO glk_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","پس یهودیأن بوگفتیدی: «آیا تصمیم دأره کی خوره بوکوشه کی اَطو گه: ‹او جایی کی من شم، شومأن نتأنید بأیید›؟» ");
INSERT INTO glk_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","عیسی اَشأنه بوگفته: «شومأن از بیزیریدی و من از بوجور. شومأن از اَ دنیایید ولی من از اَ دنیا نی‌یم. ");
INSERT INTO glk_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","شمره بوگفتم کی شیمی گناهأنه میأن میریدی. چون اگر ایمأن نأورید کی من ایسم کی ایسم، در شیمی گناهأن میریدی.» ");
INSERT INTO glk_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","از اون وَورسه‌ییدی: «تو کی ایسی؟» عیسی جواب بده: «هونی کی از اوّل شمره بوگفتم. ");
INSERT INTO glk_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","خیلی چیزأن درباره‌یه شومأن دأرم کی شمره بگم و شمره محکومه کونم، امّا اونی کی مره اوسه کوده، حقِ و من اونچی‌یه کی از اون بیشنَوستم، به دنیا بازم گم.» ");
INSERT INTO glk_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","اوشأن نفهمستیدی کی از پئر اوشأنه‌ره گفتن دره. ");
INSERT INTO glk_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","پس عیسی اوشأنه بوگفته: «اون وختی کی انسانه پسره بلنده کودیدی، فهمیدی کی من ایسم و از خودم کاری نوکونم، بلکی فقط اونچی‌یه گم کی می پئر مره یاد بدَه. ");
INSERT INTO glk_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","اون کی مره اوسه کوده، می اَمره‌یه. اون مره تنها ننَه، چونکی من همیشه اون چیزی‌یه کی اونه خوشحاله کونه، انجام دهم.» ");
INSERT INTO glk_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","اَ حرفأنه اَمره خیلی‌یأن اونه ایمأن بأوردیدی. ");
INSERT INTO glk_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","پس عیسی به یهودیأنی کی اونه ایمأن بأورده بید، بوگفته: «اگر می کلامه میأن بِیسید، حقیقتاً می شاگرد بیدی. ");
INSERT INTO glk_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","و حقیقته شنأسیدی و حقیقت شمره آزاده کونه.» ");
INSERT INTO glk_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","اونه جواب بدَییدی: «اَمأن ابراهیمه زأکأنیم و هیچ وخت غلامه کسی نوبوستیم. پس چوطویی گی، کی آزاده بیمی؟» ");
INSERT INTO glk_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","عیسی جواب بده: «آمین، آمین، شمره گم، هر کسی کی گناه کونه، غلامه گناهه! ");
INSERT INTO glk_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","غلام هیچ وخت اهله خانه میأن جایه همیشگی نأره، امّا پسره همیشه جا نَهه. ");
INSERT INTO glk_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","پس اگر پسر شمره آزاده کونه، حقیقتاً آزاده بیدی! ");
INSERT INTO glk_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","«دأنم کی ابراهیمه زأکأنیدی. امّا به دونباله اَنیدی کی مره بوکوشید، چونکی می کلام شیمی میأنی جایی نأره. ");
INSERT INTO glk_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","من از اونچی کی می پئره ورجه بیدم، حرف زنم و شومأنم اونچی‌یه کی از شیمی پئر بیشنَوستیدی، انجام دیهیدی.» ");
INSERT INTO glk_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","بوگفتیدی: «اَمی پئر، ابراهیمه.» عیسی بوگفته: «اگر ابراهیمه زأکأن بید، ابراهیمه مأنستن رفتار کودیدی. ");
INSERT INTO glk_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","امّا به دونباله اَنید کی مره بوکوشید و من اونی ایسم کی حقیقتی‌یه کی از خدا بیشنَوستم، شمره باز بوگفتم! ابراهیم اَطو رفتار نوکوده. ");
INSERT INTO glk_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ولی شومأن شیمی پئره کارأنه انجام دیهیدی.» بوگفتیدی: «اَمأن حرامزاده نی‌ییم! ایتأ پئر دأریم کی هو خدایه.» ");
INSERT INTO glk_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","عیسی اَشأنه بوگفته: «اگر خدا شیمی پئر بو، مره دوست دأشتیدی، چونکی من از طرفه خدا بَموم و الأن اَیه ایسم. من از طرفه خودم نَموم، بلکی اون مره اوسه کوده. ");
INSERT INTO glk_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","بخاطره چی می حرفأنه نفهمیدی؟ بخاطره اَنکی نتأنیدی می کلامه قبول بوکونید. ");
INSERT INTO glk_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","شومأن از شیمی پئر شیطانیدی و به دونباله انجامه اونه خوأسته‌یأنیدی. اون از اوّل قاتل بو و حقیقته اَمره نسبتی نأشتی، چونکی هیچ حقیقتی در اون ننَه. هر وخت دروغ گه، از ذاته خودش گه. چونکی دروغگویه و دروغگویأنه پئره. ");
INSERT INTO glk_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","امّا از اویه کی من حقیقته شمره گم، می حرفأنه باور نوکونیدی. ");
INSERT INTO glk_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","کی شیمی میأن تأنه مره به گناه محکوم بوکونه؟ پس اگر حقیقته شمره گم، چره می حرفأنه باور نوکونیدی؟ ");
INSERT INTO glk_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","کسی کی از خدایه، خدا کلامه قبول کونه، امّا شومأن کی قبول نوکونیدی، بخاطره اَنه کی از خدا نی‌ییدی.» ");
INSERT INTO glk_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","یهودیأن در جوابه اون بوگفتیدی: «آیا اَمأن درست نوگفتیم کی تو سامری‌یه بیگانه و دیوبزه‌یی؟» ");
INSERT INTO glk_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","عیسی جواب بده: «من دیوبزه نی‌یم، بلکی می پئره احترامه دأرم. امّا شومأن مره بی‌احترامی کونیدی. ");
INSERT INTO glk_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","من به دونباله می جلال نی‌یم. ولی کسی ایسه کی به دونباله جلال دَئنه منه و داوری‌یم با اونه. ");
INSERT INTO glk_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","آمین، آمین، شمره گم، اگر کسی می کلامه بدأره، مرگه تا اَبد نیدینه!» ");
INSERT INTO glk_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","یهودیأن اونه بوگفتیدی: «الأن دِ یقین پیدا بوکودیم کی تو دیوبزه‌یی! ابراهیم و پیامبرأن بمَردید، الأن تو گی کی: ‹اگر کسی می کلامه بدأره، هرگز نیمیره!› ");
INSERT INTO glk_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","آیا تو از اَمی پئر ابراهیمم بزرگتری؟ اون بمَرده، پیامبرأنم بمَردیدی، خودته کی دأنی؟» ");
INSERT INTO glk_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","عیسی بوگفته: «اگر من خودمه جلال بدَم، می جلال ارزش نأره. اونی کی مره جلال دهه، می پئره، هونی کی شومأن گیدی اَمی خدایه. ");
INSERT INTO glk_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","هرچند کی شومأن اونه نشنأسیدی، امّا من اونه شنأسم. اگر بگم کی اونه نشنأسم، شیمی مأنستن دروغگو بم. امّا من اونه شنأسم و اونه کلامه دأشتن درم. ");
INSERT INTO glk_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","شیمی پئر، ابراهیم، شادی کودی تا می روزَ بیدینه. و او روزَ بیده و شاده بوسته.» ");
INSERT INTO glk_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","یهودیأن اونه بوگفتیدی: «هنوز پنجاه سالم نأری، ابراهیمه بیده‌یی؟» ");
INSERT INTO glk_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","عیسی اوشأنه بوگفته: «آمین، آمین، شمره گم، قبل از اونکی ابراهیم ببه، من ایسم!» ");
INSERT INTO glk_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","پس سنگه اوسَدیدی تا اونه سنگساره کونید. امّا عیسی خوره قأیمه کوده و از صحنِ معبد بیرون بوشو. ");
INSERT INTO glk_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","عیسی شوئون دوبو کی ایتأ کوره مادرزاده بیده. ");
INSERT INTO glk_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","اونه شاگردأن از اون وَورسه‌ییدی: «اوستاد، گناهه کی بوکوده، کی اَ مرد کور به دنیا بَمو؟ از خودشه یا از اونه پئر و مار؟» ");
INSERT INTO glk_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","عیسی جواب بده: «نه از خودشه و نه از اونه پئر و مار، بلکی اَطو بوبوسته تا اَنکی قدرته خدا در اون آشکاره به. ");
INSERT INTO glk_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","تا روزِ، بأیستی اونی‌یه کی مره اوسه کوده اونه کارأنه انجام بدیم. شب نزدیکه بوستن دره کی در اون کسی نتأنه کاری بوکونه. ");
INSERT INTO glk_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","تا زمانی کی دنیا میأن ایسم، نوره دنیا ایسَم.» ");
INSERT INTO glk_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","اَنه بوگفته خو آبه دهأنَ زمینه رو تَوَدَه، و گیل چأکوده، و اونه او مردِ چشمأنه رو بمألسته. ");
INSERT INTO glk_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","و اونه بوگفته: «بوشو در حوضه سْیلوحا (کی به زبانه عبری ‹فرستاده› معنی دهه) تی چشمأنه بوشور.» پس بوشو و بوشوسته و از اویه با چشمأنه باز وأگردسته. ");
INSERT INTO glk_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","همسأیأن و کسأنی کی قبلاً اونه در حاله گدایی بیده بید، از همدیگر وَورسه‌ییدی: «مگر اَن، اونی نی‌یه کی نیشتی و گدایی کودی؟» ");
INSERT INTO glk_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","بعضی گفتیدی: «هونه.» دیگرأن گفتیدی: «شبیه اونه.» امّا اون خودش اصرار بوکوده و بوگفته: «من هونم.» ");
INSERT INTO glk_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","پس از اون وَورسه‌ییدی: «چوطو تی چشمأن بازه بوسته؟» ");
INSERT INTO glk_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","جواب بده: «مردی عیسی نام، گیل چأکوده و می چشمأنه رو بمألسته و بوگفته ‹بوشو به حوضه سْیلوحا و تی چشمأنه بوشور.› پس بوشوم و بوشوستم و می چشمأن بازه بوسته.» ");
INSERT INTO glk_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","از اون وَورسه‌ییدی: «اون کویه ایسه؟» جواب بده: «نأنم.» ");
INSERT INTO glk_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","پس او مردی‌یه کی قبلاً کور بو، فَریسیأنه ورجه بأوردیدی. ");
INSERT INTO glk_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","او روز کی عیسی گیل چأکوده بو و اونه چشمأنه وأکوده، روزِ شَبّات بو. ");
INSERT INTO glk_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","اون وخت فَریسیأنم اونه پرس و جو بوکودیدی کی چوطو تی چشمأن بازه بوسته. جواب بده: «می چشمأنه گیل بمألسته و من بوشوستم، الأن می چشمأن تأنه بیدینه.» ");
INSERT INTO glk_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","پس بعضی از فَریسیأن بوگفتیدی کی: «او مرد از خدا نی‌یه. چونکی احترامه روزِ شَبّات ندأشته.» امّا دیگرأن بوگفتیدی: «چوطو شخصی کی گناهکاره، تأنه اَجور معجزات بوکونه؟» و اوشأنه میأن اختلاف دکفته. ");
INSERT INTO glk_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","پس ایدفعه دیگر از اون وَورسه‌ییدی: «تو خودت درباره‌یه اون چی گی؟ چونکی تی چشمأنه، اون بازه کوده.» جواب بده: «اون نبی‌یه.» ");
INSERT INTO glk_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","امّا حاکمأنه یهود هنوز باور نأشتیدی کی اون کور بو و اونه چشمأن بازه بوسته، تا اَنکی اونه پئر و ماره دوخوأدیدی. ");
INSERT INTO glk_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","و از اوشأن وَورسه‌ییدی: «آیا اَن شیمی پسره، هونی کی گیدی کور به دنیا بَمو؟ پس چوطو الأن تأنه بیدینه؟» ");
INSERT INTO glk_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","جواب بدَییدی: «دأنیم کی اَمی پسره و دأنیم کی کور به دنیا بَمو. ");
INSERT INTO glk_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","امّا از اَنکی چوطو اَنه چشمأن بازه بوسته و یا کی اونه چشمأنه وأکوده، اَمأن نأنیم. از خودش وَورسید. اون خودش بالغه و خودش درباره‌یه خودش تأنه گب بزنه.» ");
INSERT INTO glk_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","اَشأن بخاطره اَن اَطو گفتیدی، چونکی از حاکمأنه یهود ترسه‌ییدی. چونکی حاکمأنه یهود همدست بوبوسته بید هر کسی کی اعتراف بوکونه عیسی هو مسیحه، اونه از کنیسه بیرونه کونید. ");
INSERT INTO glk_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","بخاطره اَن بو کی اونه پئر و مار بوگفتیدی، «خودش بالغه و از خودش وَورسید.» ");
INSERT INTO glk_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","پس ایبارِ دیگر او مردی کی قبلاً کور بو، دوخوأدیدی و اونه بوگفتیدی: «در حضوره خدا بوگو کی حقیقته گی. اَمأن دأنیم کی اون مردی گناهکاره!» ");
INSERT INTO glk_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","جواب بده: «اون گناهکار ایسه یا نی‌یه نأنم. ایچی‌یه دأنم کی کور بوم ولی الأن دینم!» ");
INSERT INTO glk_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","وَورسه‌ییدی: «تی اَمره چی بوکوده؟ چوطو تی چشمأنه بازه کوده؟» ");
INSERT INTO glk_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","جواب بده: «من کی شمره بوگفتم، ولی شومأن گوش ندَییدی، چره خوأییدی دوباره بیشنَوید؟ مگر شومأنم خوأییدی اونه شاگرد بیبید؟» ");
INSERT INTO glk_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","اوشأن اونه فحش بدَییدی و بوگفتیدی: «تو خودت اونه شاگردی! اَمأن موسی شاگردیم! ");
INSERT INTO glk_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","اَمأن دأنیم کی خدا موسی اَمره حرف بزه. امّا نأنیم اَ شخص کویه‌شینه.» ");
INSERT INTO glk_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","او مرد در جوابه اوشأن بوگفته: «جایه تعجبه در حالی کی می چشمأنه بازه کوده، نأنیدی از کویه بَمو! ");
INSERT INTO glk_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ولی اَمأن دأنیم کی خدا گناهکارأنه دعایه نیشنَوه، امّا اگر کسی خداترس ببه و اونه خوأسته‌یه انجام بده، خدا اونه دعایه ایشنَوه. ");
INSERT INTO glk_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","از بنیاده عالم تا الأن کسی نیشنَوسته اینفر کوره مادرزاده چشمأنه بازه کوده بی. ");
INSERT INTO glk_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","اگر اَ مرد از طرفه خدا نوبو، از اون کاری برنَمویی.» ");
INSERT INTO glk_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","اَشأن در جوابه اون بوگفتیدی: «تو سر تا پا در گناه به دنیا بَمویی! الأن اَمَره درس دَئن دری؟» پس اونه بیرونه کودیدی. ");
INSERT INTO glk_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","وختی عیسی بیشنَوسته کی او مردَ بیرونه کودیدی، اونه پیدا بوکوده و از اون وَورسه: «آیا به انسانه پسر ایمأن دأری؟» ");
INSERT INTO glk_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","جواب بده: «ای سرور، بوگو کی ایسه تا اونه ایمأن بأورم.» ");
INSERT INTO glk_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","عیسی اونه بوگفته: «تو اونه بیده‌یی! اون هونی ایسه کی الأن تی اَمره حرف زِئن دره.» ");
INSERT INTO glk_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","بوگفته: «ای سرور، ایمأن دأرم!» و عیسی جلو زانو بزه. ");
INSERT INTO glk_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","عیسی بوگفته: «من داوری‌ره به اَ دنیا بَموم تا کورأن بینا، و بینایأن کوره بید.» ");
INSERT INTO glk_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","بعضی از فَریسیأن کی اونه اَمره بید وختی اَنه بیشنَوستیدی، وَورسه‌ییدی: «آیا اَمأنم کوریم؟» ");
INSERT INTO glk_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","عیسی اوشأنه بوگفته: «اگر کور بید، گناهی نأشتیدی. ولی الأن کی ادعا کونیدی دینیدی، گناهکار باقی مأنیدی. ");
INSERT INTO glk_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","«آمین، آمین، شمره گم، کسی کی از در، وارده طویله‌یه گوسفندأن نبه، بلکی از رایه دیگر وارد ببه، دوزد و راهزنه. ");
INSERT INTO glk_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","امّا اونی کی از در وارده به، چوپانه گوسفندأنه. ");
INSERT INTO glk_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","دربان، درَ اونه‌ره بازه کونه و گوسفندأن اونه آوازه ایشنَویدی. اون خو گوسفندأنه به نام دوخوأنه و اوشأنه بیرون بره. ");
INSERT INTO glk_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","وختی تمامه خو گوسفندأنه بیرون بره، جلوتر از اوشأن قدم اوسَنه و گوسفندأن اونه دونبالسر شیدی، چونکی اونه صدایه شنأسیدی. ");
INSERT INTO glk_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","امّا هرگز بیگانه دونبالسر نیشیدی، بلکی از اون فرار کونیدی، چونکی اونه صدایه نشنأسیدی.» ");
INSERT INTO glk_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","عیسی اَ مَثَله اوشأنه‌ره بوگفته، امّا نفهمستیدی کی اوشأنه چی گفتن دره. ");
INSERT INTO glk_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","پس ایدفعه دیگر اوشأنه بوگفته: «آمین، آمین، شمره گم، من گوسفندأنه‌ره ‹در› ایسم! ");
INSERT INTO glk_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","اوشأنی کی از من پیشتر بَموییدی همگی دوزد و راهزنید، امّا گوسفندأن اوشأنه حرفه گوش نوکودیدی. ");
INSERT INTO glk_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","من ‹در› ایسم! هر کی از می راه وارد ببه، نجات پیدا کونه و آزادأنه بودورون اَیه و بیرون شه و چراگاه پیدا کونه. ");
INSERT INTO glk_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","دوزد نأیه، مگر اَنکی دوزدی بوکونه و بوکوشه و نابود بوکونه. من بَموم تا اَشأن زندگی‌یه اَبدی پیدا بوکونید و از او زندگی‌یه اَبدی به فراوانی بهره ببرید! ");
INSERT INTO glk_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«چوپانه خوب من ایسم! چوپانه خوب خو جانه گوسفندأنه‌ره نِهه. ");
INSERT INTO glk_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","کارگر چوپانه مأنستن نی‌یه و گوسفندأن اونه‌شین نی‌ییدی. هر وخت بیدینه گرگ اَمون دره، گوسفندأنه وله کونه و فرار کونه و گرگ گوسفندأنه حمله کونه و اوشأنه پراکنده کونه. ");
INSERT INTO glk_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","کارگر فرار کونه، چره کی کارگره و به فکر گوسفندأن نی‌یه. ");
INSERT INTO glk_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","چوپانه خوب من ایسم! من می گوسفندأنه شنأسم و می گوسفندأن مره شنأسیدی. ");
INSERT INTO glk_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","هوطو کی پئر مره شنأسه، منم پئره شنأسم. من می جانه گوسفندأنه‌ره نَهم. ");
INSERT INTO glk_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","گوسفندأنه دیگری‌یم دأرم کی از اَ طویله نی‌ییدی. اوشأنه بأید بأورم و اوشأن می صدایه گوش کونیدی. اون وخت ایتأ گله بیدی با ایتأ چوپان. ");
INSERT INTO glk_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","پئر، هَنه وستی مره دوست دأره کی من می جانه نَهم تا اونه پس فیگیرم. ");
INSERT INTO glk_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","هیچکس اونه از من فینگیره، بلکی من به میلِ خودم اونه فدم. اختیارشه دأرم کی فدم و اختیارشه دأرم کی اونه پس فیگیرم. اَ حکمه از می پئره فیگیفتم.» ");
INSERT INTO glk_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","به دلیله اَ حرفأن ایدفعه دیگر یهودیأنه میأن اختلاف دکفته. ");
INSERT INTO glk_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","خیلی‌یأن از اوشأن بوگفتیدی: «اون دیوبزه و دیوأنه‌یه. چره اونه حرفأنه گوش کونیدی؟» ");
INSERT INTO glk_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","امّا دیگرأن بوگفتیدی: «اَشأن ایتأ دیوبزه حرفأن نی‌یه. آیا دیو تأنه کورأنه چشمأنه بازه کونه؟» ");
INSERT INTO glk_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","زمان برگزاری عیده وقف اورشلیمه میأن فَرسه بو. زمستان بو ");
INSERT INTO glk_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","و عیسی معبده میأن، اِیوانه سلیمانه میأن راه شویی. ");
INSERT INTO glk_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","یهودیأن اونه دور جمعَ بوستیدی و بوگفتیدی: «تا کی خوأیی اَمَره شکّه میأن بدأری؟ اگر مسیح ایسی، اَمَره آشکارا بوگو.» ");
INSERT INTO glk_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","عیسی جواب بده: «شمره بوگفتم، امّا باور نوکونیدی. کارأیی کی من به نامِ می پئر کونم، مره شهادت دیهیدی. ");
INSERT INTO glk_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","امّا شومأن ایمأن نأوریدی، چونکی از می گوسفندأن نی‌ییدی. ");
INSERT INTO glk_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","می گوسفندأن، می صدایه گوش کونیدی. من اوشأنه شنأسم و اوشأن می دونبال اَییدی. ");
INSERT INTO glk_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","من اوشأنه زندگی‌یه اَبدی بخشم و یقیناً هرگز هلاکه نیبیدی و کسی اوشأنه از می دست نتأنه بدوزده. ");
INSERT INTO glk_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","می پئر کی اوشأنه مره ببخشه، از همه پیله‌تره و هیچکس نتأنه اوشأنه از می پئره دست بدوزأنه. ");
INSERT INTO glk_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","من و پئر ایتأییم.» ");
INSERT INTO glk_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","اون وخت ایدفعه دیگر یهودیأن سنگ اوسَدیدی تا اونه سنگساره کونید. ");
INSERT INTO glk_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","عیسی اوشأنه بوگفته: «کارأیه خوبه زیادی از می پئر شمره نیشأن بدَم، بخاطره کویتأ خوأییدی مره سنگساره کونید؟» ");
INSERT INTO glk_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","جواب بدَییدی: «بخاطره کاره خوب نی‌یه کی تره سنگسار کونیم، بلکی بخاطره اَنکی کفر گی. چونکی انسانی و خودته خدا خوأنی!» ");
INSERT INTO glk_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","عیسی اوشأنه بوگفته: «مگر در شیمی تورات نَمو کی خدا بوگفته، شومأن خدایأنید؟ ");
INSERT INTO glk_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","هیچ قسمتی از کیتابه مقدّس از اعتبار ساقطه نیبه. اگر اوشأنی کی کلامه خدا اوشأنه فَرسه، خدایأن خوأنده بیبید، ");
INSERT INTO glk_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","چوطو تأنیدی کسی‌یه کی پئر اونه وقف بوکوده و به دنیا اوسه کوده، بیگید کی: ‹کفر گه،› تنها به اَ خاطر کی بوگفتم خدا پسرم؟ ");
INSERT INTO glk_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","اگر می پئره کارأنه بجا نأورم، می کلامه باور نوکونید. ");
INSERT INTO glk_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","امّا اگر بجا اَورم، حتی اگر می کلامه باور نأریدی، دسته کم به اونه کارأن ایمأن بأورید تا بدأنید و باور بدأرید کی پئر در منه و من در پئر.» ");
INSERT INTO glk_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","اون وخت ایدفعه دیگر خوأستیدی کی اونه گرفتاره کونید، ولی از اوشأنه دست در بوشو. ");
INSERT INTO glk_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","بعد از اون، عیسی به او طرفه رودِ اُردن، اویه کی یحیی قبلاً تعمید دَیی، بوشو و اویه بِیسه. ");
INSERT INTO glk_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","خیلی‌یأن عیسی ورجه بَموییدی. اوشأن گفتیدی: «هرچند کی یحیی هیچ معجزه‌یی نوکوده، ولی هر اونچی کی درباره‌یه اَ شخص بوگفته، حقیقت دأشتی.» ");
INSERT INTO glk_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","پس خیلی‌یأن اویه به عیسی ایمأن بأوردیدی. ");
INSERT INTO glk_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","مردی ایلعازَر نام مریض بو. اون از مردمأنه بیت‌عَنْیا بو، دِهی کی مریم و اونه خواخور مارتا اویه‌شین بید. ");
INSERT INTO glk_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","مریم او زنی بو کی عیسی پایأنه معطر بوکوده و خو گیسه اَمره اونه خوشکه کوده. اونه برأر ایلعازَر مریضه بوسته بو. ");
INSERT INTO glk_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","پس ایلعازَرِ خواخورأن، عیسی‌ره پیغام بدَییدی و بوگفتیدی: «ای سرور، تی دوستِ عزیز مریضه.» ");
INSERT INTO glk_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","عیسی وختی اَ خبره بیشنَوسته بوگفته: «اَ مریضی مرگه اَمره به آخر نرسه، بلکی خدا جلاله وستی‌یه، تا خدا پسر، توسطه اونه مریضی جلال پیدا بوکونه.» ");
INSERT INTO glk_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","عیسی مارتا و اونه خواخور و ایلعازَرَ دوست دأشتی. ");
INSERT INTO glk_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","پس وختی بیشنَوسته کی ایلعازَر مریضه، دو روز دیگرم در جایی کی ایسه بو، بِیسه. ");
INSERT INTO glk_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","بعد از اون، خو شاگردأنه بوگفته: «بأیید بازم به یهودیه بیشیم.» ");
INSERT INTO glk_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","اونه شاگردأن بوگفتیدی: «اوستاد، چند روزِ پیش بو کی یهودیأن خوأستیدی تره سنگساره کونید، تو بازم خوأیی اویه بیشی؟» ");
INSERT INTO glk_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","عیسی جواب بده: «مگر هر روز دوازده ساعت نی‌یه؟ اونی کی در روز راه شه لغزش نوخوره، چونکی نوره اَ دنیایه دینه. ");
INSERT INTO glk_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","امّا اونی کی در شب راه شه لغزش خوره، چونکی نوری نأره.» ");
INSERT INTO glk_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","بعد از اَ حرفأن، اوشأنه بوگفته: «اَمی رفق ایلعازَر خوفته، امّا شوئون درم تا اونه بیداره کونم.» ");
INSERT INTO glk_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","پس شاگردأن اونه بوگفتیدی: «ای سرور، اگر خوفته، خوره خوره خوب به.» ");
INSERT INTO glk_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","امّا عیسی از اونه مرگ حرف زه‌یی، در حالی کی اونه شاگردأن فکر کودیدی کی گه اون خوفته. ");
INSERT INTO glk_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","اون وخت عیسی آشکارا اوشأنه بوگفته: «ایلعازَر بمَرده. ");
INSERT INTO glk_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","شیمی وستی خوشحالم کی اویه نِیسه بوم، تا ایمأن بأورید. امّا الأن اونه ورجه بیشیم.» ");
INSERT INTO glk_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","پس توما کی به دوقولو معروف بو، شاگردأنه بوگفته: «بأیید اَمأنم بیشیم و اونه اَمره بیمیریم.» ");
INSERT INTO glk_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","وختی عیسی اویه فَرسه، بفهمسته کی چهار روزِ ایلعازَرَ قبره میأن بنَه‌ییدی. ");
INSERT INTO glk_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","بیت‌عَنْیا حدوداً سه کیلومتر اورشلیمه اَمره فاصله دأشتی. ");
INSERT INTO glk_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","یهودیأنه زیادی مریم و مارتا ورجه بَمو بید تا اوشأنه بخاطره مرگه ایلعازَر تسلی بدید. ");
INSERT INTO glk_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","پس وختی مارتا بیشنَوسته کی عیسی اویه اَمون دره، اونه استقبال بوشو. امّا مریم خانه میأن بِیسه. ");
INSERT INTO glk_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","مارتا عیسایه بوگفته: «ای سرور، اگر اَیه بِیسه بی، می برأر نَمردی. ");
INSERT INTO glk_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","امّا دأنم کی الأن اگر هر چی از خدا بخوأیی، تره فده.» ");
INSERT INTO glk_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","عیسی اونه بوگفته: «تی برأر زندَه به.» ");
INSERT INTO glk_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","مارتا اونه بوگفته: «دأنم کی در روزِ قیامت زندَه به.» ");
INSERT INTO glk_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","عیسی بوگفته: «قیامت و حیات من ایسم. اونی کی مره ایمأن بأوره، حتی اگر بیمیره بازم زندَه به. ");
INSERT INTO glk_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","و هر کی زنده‌یه و مره ایمأن دأره، یقیناً تا اَبد نیمیره. آیا اَنه باور کونی؟» ");
INSERT INTO glk_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","مارتا بوگفته: «بله، ای سرور، من ایمأن دأرم کی تو ایسی مسیح، خدا پسر، اونی کی بأید به جهان بَمو بی.» ");
INSERT INTO glk_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","اَنه بوگفته و بوشو خو خواخور مریمه دوخوأده و خلوتی اونه بوگفته: «اوستاد اَیه ایسه و تره دوخوأنه.» ");
INSERT INTO glk_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","مریم وختی اَنه بیشنَوسته، بدونه معطلی ویریشته و اونه ورجه بوشو. ");
INSERT INTO glk_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","عیسی هنوز وارده دهکده نوبوسته بو، بلکی جایی ایسه بو کی مارتا اونه ملاقات بوکوده بو. ");
INSERT INTO glk_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","یهودیأنی کی مریمه اَمره خانه میأن ایسه بید و اونه تسلی دَییدی، وختی بیده‌ییدی کی مریم عجله اَمره ویریشته و بیرون بوشو، اونه دونبالسر بوشوییدی، فکر کودیدی کی قبره سر شوئون دره تا اویه گریه و زاری بوکونه. ");
INSERT INTO glk_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","وختی مریم اویه فَرسه کی عیسی ایسه بو، اونه بیده و اونه پا زیر بکفته و بوگفته: «ای سرور، اگر اَیه بِیسه بی، می برأر نَمردی!» ");
INSERT INTO glk_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","وختی عیسی، گریه و زاریه مریم و یهودیأنی کی اونه اَمره همرأه بید، بیده، اونه روح آشفته و سخت منقلبه بوسته. ");
INSERT INTO glk_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","وَورسه: «اونه کویه بنَه‌ییدی؟» بوگفتید: «ای سرور، بیأ و بیدین.» ");
INSERT INTO glk_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","عیسی گریه بوکوده. ");
INSERT INTO glk_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","پس یهودیأن بوگفتیدی: «بیدینید چقدر اونه دوست دأشتی.» ");
INSERT INTO glk_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","امّا بعضی‌یأن بوگفتیدی: «آیا کسی کی او مردِ کوره چشمأنه بینا بوکوده، نتأنستی ایلعازَرَ مرگه جلویه بیگیره؟» ");
INSERT INTO glk_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","بعد از اون، عیسی، در حالی کی باز آشفته بو، قبره سر بَمو. قبر، غاری بو کی اونه دهأنه رو سنگی بنَه بید. ");
INSERT INTO glk_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","بفرمأسته: «سنگه اوسَنید.» مارتا میّتِ خواخور بوگفته: «ای سرور، الأن دِ بویه بد دهه، چونکی چهار روز بوگذشته.» ");
INSERT INTO glk_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","عیسی اونه بوگفته: «مگر تره نوگفتم کی اگر ایمأن بأوری، خدا جلاله دینی؟» ");
INSERT INTO glk_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","پس سنگه اوسَدیدی. اون وخت عیسی آسمانه نیگاه بوکوده و بوگفته: «پئر تره شکر کونم کی مره بیشنَوستی. ");
INSERT INTO glk_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","من دأنستیم کی همیشه مره ایشنَوی. امّا اَنه کسأنی وستی بوگفتم کی در اَیه ایسه‌ییدی، تا ایمأن بأورید کی تو مره اوسه کودی.» ");
INSERT INTO glk_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","اَنه بوگفته و بعد از اَن، صدایه بلنده اَمره دوخوأده: «ایلعازَر، بیرون بیأ!» ");
INSERT INTO glk_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","پس او میّت کی اونه دست و پایه کفنه اَمره دَوَسته بید و اونه صورته ایتأ دستماله اَمره بپوشأنه بید، بیرون بَمو. عیسی اوشأنه بوگفته: «اونه بازه کونید و وئلید بشه.» ");
INSERT INTO glk_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","پس خیلی از یهودیأنی کی به دِئنه مریم بَمو بید و عیسی کاره بیده بید، اونه ایمأن بأوردیدی. ");
INSERT INTO glk_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","امّا بعضی‌یأن بوشوییدی فَریسیأنه ورجه و اوشأنه از اونچی کی عیسی بوکوده بو، خبر بدَییدی. ");
INSERT INTO glk_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","پس سرأنه کاهنأن و فَریسیأن بینیشتیدی و مشورت بوکودیدی. بوگفتیدی: «چی بوکونیم؟ اَ مرد معجزاته زیادی ظاهره کونه. ");
INSERT INTO glk_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","اگر وئلیم اون، هوطو پیش بشه، همه به اون ایمأن اَوریدی و رومیأن اَییدی و اَ مکانه و اَ قومه از اَمی دست بیرون اَوریدی.» ");
INSERT INTO glk_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","امّا ایتأ از اوشأن کی اونه نام قیافا و در او سال کاهنِ اعظم بو، دیگرأنه بوگفته: «شومأن هیچی نأنیدی. ");
INSERT INTO glk_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","فکر نوکونید صلاح اَنه کی اینفر قومه وستی بیمیره، تا اَنکی تمامه مردم نابوده بید.» ");
INSERT INTO glk_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","امّا اَ حرف از خودش نوبو، بلکی چون در او سال اون کاهنِ اعظم بو اَطو نبوّت بوکوده کی عیسی قومه وستی میره، ");
INSERT INTO glk_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","نه تنها قومه وستی، بلکی برای جمعَ کودن و ایتأ بوستنه خدا زأکأن کی پراکنده‌ییدی. ");
INSERT INTO glk_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","بعد از او روز، اونه قتله توطئه‌یه دیچه‌ییدی. ");
INSERT INTO glk_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","از اون به بعد، عیسی آشکارا دِ یهودیأنه میأن رفت و آمد نوکودی، بلکی به شهری کی اونه نام اِفْرایم بو در ناحیه‌یی نزدیکه بیابان بوشو و خو شاگردأنه اَمره اویه بِیسه. ");
INSERT INTO glk_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","وختی یهودیأنه عیده پِسَخ نزدیکه بوسته، عده زیادی از جاهایه مختلف به اورشلیم بوشوییدی تا رسمه تطهیر کودنه قبل از پِسَخَ بجا بأورید. ");
INSERT INTO glk_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","اوشأن به دونبال عیسی بید، وختی معبده صحنِ میأن ایسه بید، همدیگره گفتیدی: «چی فکر کونیدی؟ آیا اصلاً عیده‌ره نأیه؟» ");
INSERT INTO glk_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","امّا سرأنه کاهنأن و فَریسیأن دستور بده بید کی هر وخت کسی بدأنه عیسی کویه ایسه، خبر بده تا اونه دستگیر بوکونید. ");
INSERT INTO glk_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","شیش روز قبل از عیده پِسَخ، عیسی به بیت‌عَنْیا، جایی کی ایلعازَر زندگی کودی، بَمو؛ هونی کی عیسی اونه از مُرده‌یأنه میأن زندَه کوده بو. ");
INSERT INTO glk_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","در اویه به افتخاره عیسی شام بدَییدی. مارتا پذیرایی کودی و ایلعازَر از جمله کسأنی بو کی اونه اَمره سفره سر نیشته بو. ");
INSERT INTO glk_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","اون وخت، مریم عطره گران قیمتی‌یه کی از سنبله خالص و حدوداً نیم لیتر بو، بیگیفته و عیسی پایأنه معطره کوده و خو گیسأنه اَمره اونه پایه خوشکه کوده، تا جایی کی خانه پُر از عطر بوبوسته بو. ");
INSERT INTO glk_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","امّا یهودایه اِسْخَریوطی، ایتأ از عیسی شاگردأن کی بعداً اونه به دشمن تسلیمه کوده، بوگفته: ");
INSERT INTO glk_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«چره اَ عطره سیصد دینار نوفروختیدی تا اونه پوله فقیرأنه فدید؟» ");
INSERT INTO glk_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","اون اَنه، فقیرأنه وستی نوگفتی، بلکی به اَ خاطر گفتی کی خودش دوزد بو. اون مسئوله دخل و خرج بو، و از پولی کی اونه ورجه بنَه بید، دوزدی کودی. ");
INSERT INTO glk_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","پس عیسی بوگفته: «اونه به حاله خودش بنید، چونکی اَ عطره می روزِ دفن کودنه‌ره بدأشته بو. ");
INSERT INTO glk_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","فقیرأنه همیشه شیمی اَمره دأریدی، امّا مره همیشه نأریدی.» ");
INSERT INTO glk_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","عده زیادی از یهودیأن چون بیشنَوستیدی عیسی اویه ایسه، بَموییدی تا نه فقط عیسایه بلکی ایلعازَرم کی زندَه بوکوده بو، بیدینید. ");
INSERT INTO glk_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","پس سرأنه کاهنأن تصمیم بیگیفتیدی تا ایلعازَرم بوکوشید، ");
INSERT INTO glk_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","چونکی باعث بوبوسته بو کی خیلی از یهودیأن از اوشأن دوره بید و به عیسی ایمأن بأورید. ");
INSERT INTO glk_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","صبحه دم جمعیته زیادی کی عیده‌ره بَمو بید، وختی بیشنَوستیدی عیسی به اورشلیم اَمون دره، ");
INSERT INTO glk_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","نخله درخته شاخه‌یأنه به دست بیگیفتیدی و اونه پیشواز بوشوییدی. اوشأن فریادزنأن گفتیدی: «هوشیعانا! مبارکه، اونی کی به نامِ خداوند اَیه! مبارکه، اسرائیله پادشاه!» ");
INSERT INTO glk_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","اون وخت عیسی کرّه الاغی‌یه پیدا بوکوده و اونه سوارَ بوسته؛ هوطو کی بینیویشته بوبوسته بو: ");
INSERT INTO glk_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«نَواترسن! ای صهیونِ دختر، بیدین، تی پادشاه کرّه الاغه سر سواره اَمون دره!» ");
INSERT INTO glk_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","اونه شاگردأن اوّل اَ چیزأنه نفهمستیدی، امّا وختی عیسی جلال پیدا بوکوده، به یاد بأوردیدی کی اَ چیزأن همه درباره‌یه اون بینیویشته بوبوسته بو، هوطویی کی مردم اونه اَمره بوکوده بید. ");
INSERT INTO glk_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","وختی عیسی ایلعازَرَ دوخوأده و زندَه کوده و از قبر بیرون بأورده، جماعته زیادی اویه ایسه بید. اوشأن او چیزی کی بیده بید شهادت دَییدی. ");
INSERT INTO glk_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","خیلی از مردم به هَه دلیل اونه پیشواز بوشوییدی، چونکی بیشنَوسته بید، چه معجزه‌یی از اون ظاهره بوسته بو. ");
INSERT INTO glk_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","پس فَریسیأن همدیگره بوگفتیدی: «بیدینید کی شومأن راه به جایی نبریدی. نیگاه بوکونید تمامه دنیا اونه دونبال بوشوییدی!» ");
INSERT INTO glk_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","از کسأنی کی عبادته‌ره، به عید بَمو بید، تعدادی یونانی بید. ");
INSERT INTO glk_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","اوشأن فیلیپُسه ورجه بَموییدی کی اهله بیت‌صِیْدایه جلیل بو. اونه بوگفتیدی: «ای سرور، خوأییم عیسایه بیدینیم.» ");
INSERT INTO glk_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","فیلیپُس بَمو و آندریاسَ بوگفته و اوشأن هر دوتأ بوشوییدی عیسایه بوگفتیدی. ");
INSERT INTO glk_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","عیسی اوشأنه بوگفته: «وخته جلال پیدا کودنه انسانه پسر فَرسه. ");
INSERT INTO glk_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","آمین، آمین، شمره گم، اگر دانه گندم خاکه میأن نکفه و نیمیره، تنها مأنه، امّا اگر بیمیره، بارِ زیاد اَوره. ");
INSERT INTO glk_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","کسی کی خو جانه دوست بدأره، اونه از دست دهه، امّا کسی کی در اَ دنیا از خودشه جان نفرت بدأره، اونه تا زندگی‌یه اَبدی حفظ کونه. ");
INSERT INTO glk_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","اونی کی بخوأیه مره خدمت بوکونه، بأیستی از من پیروی بوکونه، و جایی کی من ایسم، می خادمم اویه ایسه. کسی کی مره خدمت بوکونه، می پئر هم اونه سربلنده کونه. ");
INSERT INTO glk_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«الأن می جان در اضطرابه، چی بگم؟ آیا بگم، ‹پئر! مره از اَ ساعت آزاده کون›؟ امّا به هَه دلیل من به اَ وخت فَرسم. ");
INSERT INTO glk_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","پئر تی نامِ جلال بدَن!» اون وخت ندایی از آسمان فَرسه کی: «جلال بدَم و بازم دهم!» ");
INSERT INTO glk_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","پس مردمی کی اویه ایسه بید، اَنه بیشنَوستیدی و بوگفتیدی: «رعد بو!» دیگرأن بوگفتیدی: «ایتأ فرشته اونه اَمره حرف بزه.» ");
INSERT INTO glk_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","عیسی بوگفته: «اَ ندا شیمی وستی بو، نه می وستی. ");
INSERT INTO glk_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","الأن زمانه داوری‌یه اَ دنیایه؛ الأن رئیسه اَ دنیا بیرون تَوَدَه به. ");
INSERT INTO glk_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","و من، وختی کی از زمین بلنده بم همه‌یه به طرفه خودم اَورم.» ");
INSERT INTO glk_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","اون اَ حرفأنه اَمره، اشاره به مرگی بوکوده کی اونه انتظاره دأشتی. ");
INSERT INTO glk_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","مردم بوگفتیدی: «طبقِ اونچی کی از تورات بیشنَوستیم، مسیح تا اَبد باقی مأنه، پس چوطویه کی گه انسانه پسر بأید بلنده به؟ اَ انسانه پسر کی‌یه؟» ");
INSERT INTO glk_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","عیسی اَشأنه بوگفته: «تا مدته کمی نور شیمی اَمره ایسه! پس تا مدتی کی هنوز نوره دأریدی، راه بیشید، مبادا کی تاریکی شمره بیگیره. اونی کی تاریکی میأن راه شه، نأنه کویه شوئون دره! ");
INSERT INTO glk_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","تا زمانی کی نوره دأریدی، به نور ایمأن بأورید، تا نوره زأکأن بیبید.» وختی اَ حرفأنه بزه، از اویه بوشو و خودشه از اوشأن پنهانه کوده. ");
INSERT INTO glk_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","با اونکی عیسی معجزاته زیادی اوشأنه چشمأنه جلو انجام بده بو، به اون ایمأن نأوردیدی. ");
INSERT INTO glk_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","هَنه وستی اِشَعْیایه نبی پیشگویی، ثابته به کی بوگفته بو: «کی‌یه، ای خداوند کی اَمی پیغامه باور بوکونه، و کی‌یه کی قدرته خداوند اونه‌ره آشکاره بوسته؟» ");
INSERT INTO glk_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","هوطو کی اِشَعْیایه نبی خودش در جایه دیگر بوگفته، اوشأن نتأنستیدی ایمأن بأورید چونکی: ");
INSERT INTO glk_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«اون، اوشأنه چشمأنه کور، و اوشأنه دیلأنه سخته کوده، تا خوشأنه چشمأنه اَمره نیدینید، و خوشأنه دیلأنه اَمره نفهمید، و وأنَگردید تا اوشأنه شفا بدَم.» ");
INSERT INTO glk_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","اِشَعْیا به اَ خاطر اَنه بوگفته چونکی اونه جلاله بیده و درباره‌یه اون حرف بزه. ");
INSERT INTO glk_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","با اَنکی حتی خیلی از حاکمأنه قوم عیسایه ایمأن بأوردیدی، امّا از ترسه فَریسیأن، خوشأنه ایمأنه اقرار نوکودید، نوکونه کی اوشأنه از کنیسه بیرونه کونید. ");
INSERT INTO glk_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","چونکی تعریفه مردمه بیشتر از تعریفه خدا دوست دأشتیدی. ");
INSERT INTO glk_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","اون وخت عیسی با صدایه بلند بوگفته: «هر کی به من ایمأن بأوره، نه به من بلکی به او کسی کی مره اوسه کوده ایمأن بأورده. ");
INSERT INTO glk_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","هر کی مره دینه، اونی‌یه دینه کی مره اوسه کوده. ");
INSERT INTO glk_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","من ایتأ نوره مأنستن به جهان بَموم تا هر کی به من ایمأن بأوره، تاریکی میأن نِیسه. ");
INSERT INTO glk_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","اگر کسی می حرفأنه بیشنَوه ولی از اون اطاعت نوکونه، من اونه داوری نوکونم، چونکی نَموم تا مردمه دنیایه داوری بوکونم، بلکی بَموم تا اوشأنه نجات ببخشم. ");
INSERT INTO glk_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","کسی کی مره ردّه کونه و می حرفأنه قبول نوکونه، ایتأ داوره دیگر ایسه؛ هو حرفأنی‌یه کی بوگفتم، در روزِ آخر اونه محکومه کونه. ");
INSERT INTO glk_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","چونکی من از طرفه خودم حرف نزنم، بلکی پئری کی مره اوسه کوده، مره دستور بده کی چی بگم و از چی حرف بزنم. ");
INSERT INTO glk_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","و من دأنم کی اونه دستور زندگی‌یه اَبدی‌یه. پس اونچی‌یه کی من گم هو چیزی ایسه کی پئر بوگفته کی من بگم.» ");
INSERT INTO glk_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ایروز قبل از عیده پِسَخ، عیسی دأنستی اونه وأگردستنه موقع از اَ دنیا به پئره ورجه فَرسه، خو کسأنه کی اَ دنیا میأن دوست دأشتی، تا حده کمال محبت بوکوده. ");
INSERT INTO glk_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","وخته شام بو، ابلیس قبلاً یهودایه اِسْخَریوطی، شَمعونِ پسره دیله میأن بنَه بو کی عیسایه تسلیمه دشمن بوکونه. ");
INSERT INTO glk_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","عیسی کی دأنستی پئر همه چیزه اونه دست بیسپرده و از اونه ورجه بَمو، و اونه ورجه شوئون دره، ");
INSERT INTO glk_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","از شامِ سر ویریشته و خو ردایه از تن بیرون بأورده و ایتأ حوله اوسَده و به خو کمر دَوَسته. ");
INSERT INTO glk_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","بعد ایتأ لگنه میأن آب دوکوده و شروع بوکوده خو شاگردأنه پایه شوستن و اوشأنه پایه او حوله اَمره کی خو کمره دور، دَوَسته بو خوشکه کوده. ");
INSERT INTO glk_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","وختی به شَمعونِ پِطرُس فَرسه، اون عیسایه بوگفته: «ای سرور، تو خوأیی می پایه بوشوری؟» ");
INSERT INTO glk_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","عیسی جواب بده: «الأن از درکِ اونچی کی کودن درم، ناتوانی، امّا بعداً فهمی.» ");
INSERT INTO glk_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","پِطرُس اونه بوگفته: «هرگز! تو هرگز می پایأنه نوشوری!» عیسی جواب بده: «تا تره نوشورم، از من سهمی نَبری.» ");
INSERT INTO glk_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","پس شَمعونِ پِطرُس بوگفته: «ای سرور، نه فقط می پایأنه، بلکی می دستأن و می سره هم بوشور!» ");
INSERT INTO glk_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","عیسی جواب بده: «اونی کی حمام بوکوده، سر تا پا تمیزه، دِ شوستن احتیاج نأره، بجز اونه پایأن. بله، شومأن پاکیدی، امّا نه همه.» ");
INSERT INTO glk_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","چونکی دأنستی چه کسی اونه تسلیمه دشمن کونه و بخاطره اَن بوگفته: «شومأن همه پاک نی‌ییدی.» ");
INSERT INTO glk_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","بعد از اَنکی عیسی اوشأنه پایأنه بوشوسته، خو ردایه دوکوده و بازم شامِ سفره سر بینیشته. اون وخت از اوشأن وَورسه: «آیا بفهمستیدی کی شمره چه کاری انجام بدَم؟ ");
INSERT INTO glk_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","شومأن مره اوستاد و سرور دوخوأنیدی، و درستم گیدی، چونکی هَطو ایسم. ");
INSERT INTO glk_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","پس اگر من کی شیمی اوستاد و سرورم، شیمی پایأنه بوشوستم، شومأن هم بأید همدیگره پایأنه بوشورید. ");
INSERT INTO glk_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","من اَ کاره اَمره شمره سرمشق بنَم تا شومأنم هَطو رفتار بوکونید کی من شیمی اَمره بوکودم. ");
INSERT INTO glk_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","آمین، آمین، شمره گم، نه غلام از خو ارباب بزرگتره، نه فرستاده، از خودشه فرستنده! ");
INSERT INTO glk_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","الأن اَشأنه دأنیدی، خوش بحاله شومأن کی اگر اَشأنه انجام بدید. ");
INSERT INTO glk_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«اونچی کی گفتن درم درباره‌یه همه‌یه شومأن نی‌یه. من اوشأنی کی انتخاب بوکودم، شنأسم. امّا اَ گفته‌یه کیتابه مقدّس بأید ثابت ببه کی: ‹می همسفره می اَمره به دشمنی ویریزه.› ");
INSERT INTO glk_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","پس الأن قبل از اَنکی اتفاق دکفه، شمره گم تا زمانی کی اتفاق دکفه، ایمأن بأورید کی من ایسم. ");
INSERT INTO glk_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","آمین، آمین، شمره گم، هر کی، کسی‌یه کی من اوسه کونم قبول بوکونه، مره قبول بوکوده، و هر کی مره قبول بوکونه، اونه کی مره اوسه کوده، قبول بوکوده.» ");
INSERT INTO glk_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","عیسی بعد از اَنکی اَنه بوگفته، در روح منقلبه بوسته و آشکارا بوگفته: «آمین، آمین، شمره گم، ایتأ از شومأن مره به دشمن تسلیم کونه.» ");
INSERT INTO glk_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","شاگردأن همدیگره نیگاه بوکودیدی و در تعجب بید کی اَ حرفأنه درباره‌یه کی گفتن دره. ");
INSERT INTO glk_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ایتأ از شاگردأن کی عیسی اونه دوست دأشتی، اونه سینه ورجه تکیه بده بو. ");
INSERT INTO glk_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","شَمعونِ پِطرُس اشاره اَمره از اون بخوأسته تا از عیسی وَورسه اونه منظور کی‌یه. ");
INSERT INTO glk_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","پس اون کمی عقب بوشو و به عیسی سینه تکیه بده و بوگفته: «ای سرور، اون کی‌یه؟» ");
INSERT INTO glk_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","عیسی جواب بده: «اونی‌یه کی اَ لقمه نانه بعد از اَنکی کاسه میأن زنم و اونه فدم.» و اون وخت، لقمه‌یه کاسه میأن بزه و اونه به یهودا، شَمعونِ اِسْخَریوطی پسر فده. ");
INSERT INTO glk_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","یهودا وختی لقمه‌یه فیگیفته، او لحظه شیطان وارده اون بوبوسته. اون وخت عیسی اونه بوگفته: «اونچی کی خوأیی انجام بدی، زودتر انجام بدَن.» ");
INSERT INTO glk_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","امّا هیچکس از کسأنی کی سفره سر نیشته بید، عیسی منظوره نفهمستیدی. ");
INSERT INTO glk_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","بعضی‌یأن فکر کودیدی چونکی یهودا مسئوله دخل و خرجه، عیسی اونه گه کی اونچی کی عیده‌ره لازمه بیهینه، یا اَنکی فقیرأنه چیزی فده. ");
INSERT INTO glk_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","بعد از فیگیفتنه لقمه، یهودا بدونه معطلی بیرون بوشو و شب بو. ");
INSERT INTO glk_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","بعد از اَنکی یهودا بیرون بوشو، عیسی بوگفته: «الأن انسانه پسر جلال پیدا بوکوده، و خدا هم در اون جلال پیدا بوکوده. ");
INSERT INTO glk_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","اگر خدا در اون جلال پیدا کوده، پس خدایم اونه در خودش جلال دهه و اونه بدونه معطلی جلال دهه. ");
INSERT INTO glk_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","عزیزأن، مدته کمی شیمی اَمره ایسم. می دونبال گردیدی، هوطو کی یهودیأنه بوگفتم، الأنم شمره گم کی او جایی کی من شوئون درم، شومأن نتأنیدی بأیید. ");
INSERT INTO glk_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","شمره ایتأ حکمه جدید فدم، و اون اَنه کی همدیگره دوست بدأرید؛ هوطویی کی من شمره دوست دأشتیم، شومأنم بأید همدیگره دوست بدأرید. ");
INSERT INTO glk_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","از هَه محبتی کی شومأن همدیگره کونیدی، همه فهمیدی کی شومأن می شاگردیدی.» ");
INSERT INTO glk_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","شَمعونِ پِطرُس بوگفته: «ای سرور، کویه شوئون دری؟» عیسی جواب بده: «تو الأن جایی کی من شوئون درم نتأنی می دونبال بأیی، امّا بعداً می دونبال اَیی.» ");
INSERT INTO glk_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","پِطرُس بوگفته: «ای سرور، چره الأن نتأنم تی دونبال بأیم؟ من می جانه تی رایه وستی نَهم.» ");
INSERT INTO glk_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","عیسی بوگفته: «آیا در رایه من تی جانه نهی؟ آمین، آمین، تره گم، قبل از اَنکی خروس بخوأنه، تو مره سه بار انکار کونی.» ");
INSERT INTO glk_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","«شیمی دیل نیگران نبه! به خدا ایمأن بدأرید، به منم ایمأن بدأرید. ");
INSERT INTO glk_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","می پئره خانه میأن منزل زیاده، وگر نه شمره گفتیم. شوئون درم تا جایی شمره حاضره کونم. ");
INSERT INTO glk_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","اون وخت کی بوشوم و جایی شمره حاضره کودم، بعداً اَیم و شمره می ورجه برم، تا جایی کی من ایسم شومأنم بِیسید. ");
INSERT INTO glk_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","جایی کی من شوئون درم، او رایه دأنیدی.» ");
INSERT INTO glk_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","توما اونه بوگفته: «اَمأن حتی نأنیمی کویه شوئون دری، پس چوطو تأنیم رایه بدأنیم؟» ");
INSERT INTO glk_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","عیسی اونه بوگفته: «راه و راستی و حیات من ایسم، هیچکس می پئره ورجه نأیه مگر به واسطه‌یه من. ");
INSERT INTO glk_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","اگر مره شنأختیدی، می پئرم شنأختیدی. امّا بعد از اَن، اونه شنأسیدی و اونه بیده‌ییدی.» ");
INSERT INTO glk_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","فیلیپُس اونه بوگفته: «ای سرور، پئره اَمَره نیشأن بدَن، هَن اَمَره کافی‌یه.» ");
INSERT INTO glk_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","عیسی اونه بوگفته: «فیلیپُس، خیلی وخته کی شیمی اَمره ایسم، هنوز مره نشنأختی؟ کسی کی مره بیده، پئره بیده. پس چوطو ایسه کی گی ‹پئره اَمَره نیشأن بدَن›؟ ");
INSERT INTO glk_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","آیا باور نأری کی من در پئرم و پئرم در من؟ حرفأنی کی من شمره گم از خودم نی‌یه، بلکی از پئری‌یه کی در من ساکنه، اونه کی خو کارأنه به انجام رسأنه. ");
INSERT INTO glk_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","اَ حرفه کی من گم باور بوکونید کی من در پئرم و پئرم در من؛ وگر نه اونه کارأنه وستی باور بوکونید کی من در پئرم و پئرم در من. ");
INSERT INTO glk_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","«آمین، آمین، شمره گم، اونی کی به من ایمأن بدأره، اونم کارأنی کی من کونم انجام دهه، و حتی کارأنه بزرگتر از اونم انجام دهه، چونکی من پئره ورجه شوئون درم. ");
INSERT INTO glk_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","و به نامِ من هر چیزی کی بخوأیید، من اونه انجام دهم، تا پئر در پسر جلال پیدا بوکونه. ");
INSERT INTO glk_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","اگر چیزی به نامِ من بخوأیید من اونه انجام دهم. ");
INSERT INTO glk_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«اگر مره دوست بدأرید، می احکامه دأریدی. ");
INSERT INTO glk_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","و من از پئر خوأیم و اون، پشتیبانه دیگری شمره فده کی همیشه شیمی اَمره بِیسه، ");
INSERT INTO glk_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","یعنی روحه راستی کی دنیا نتأنه اونه قبول بوکونه، چونکی نه اونه دینه و نه اونه شنأسه، امّا شومأن اونه شنأسیدی، چره کی شیمی ورجه ساکنه به و در آینده شیمی میأن ایسه. ");
INSERT INTO glk_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«شمره بی‌کس نَنم، شیمی ورجه اَیم. ");
INSERT INTO glk_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","بعد از مدتی دنیا مره نیدینه، امّا شومأن مره دینیدی. چونکی من زنده‌یم، شومأنم زندگی کونیدی. ");
INSERT INTO glk_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","در او روز فهمیدی کی من در پئر ایسم و شومأن در من و منم در شومأن. ");
INSERT INTO glk_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","اونی کی می احکامه بدأره و از اوشأن پیروی بوکونه، اون مره دوست دأره؛ و اونی کی مره دوست دأره، می پئرم اونه دوست دأره و منم اونه دوست دأرم و خودمه اونه‌ره آشکاره کونم.» ");
INSERT INTO glk_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","یهودا (نه اون یهودایه اِسْخَریوطی) از اون وَورسه: «ای سرور، چوطویه کی خوأیی خودته اَمَره آشکاره کونی، امّا نه اَ دنیاره؟» ");
INSERT INTO glk_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","عیسی جواب بده: «اگر کسی مره دوست بدأره، می کلامه دأره، و می پئرم اونه دوست دأره و اَمأن اونه ورجه اَییم و اونه اَمره زندگی کونیم. ");
INSERT INTO glk_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","اونی کی مره دوست نأره، می کلامم اطاعت نوکونه، و اَ کلامه کی ایشنَویدی از من نی‌یه، بلکی از پئری‌یه کی مره اوسه کوده. ");
INSERT INTO glk_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«اَ چیزأنه تا الأن کی شیمی اَمره ایسم، شمره بوگفتم. ");
INSERT INTO glk_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","امّا او پشتیبان، یعنی روح‌القدس، کی پئر اونه به نامِ من اوسه کونه، اون همه چیزه شمره یاد دهه و هر اونچی کی من شمره بوگفتم، شمره به یاد اَوره. ");
INSERT INTO glk_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","شمره آرامش بجا نَهم، می آرامشه شمره فدم. اونچی کی من شمره فدم اونی نی‌یه کی دنیا شمره فده. شیمی دیل نیگران و هراسان نبه. ");
INSERT INTO glk_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","بیشنَوستیدی کی شمره بوگفتم ‹من شوئون درم. امّا بازم شیمی ورجه اَیم.› اگر مره دوست بدأشته بید، خوشحاله بوستیدی کی می پئره ورجه شوئون درم، چونکی پئر از من بزرگتره. ");
INSERT INTO glk_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","الأن اَنه قبل از اَنکی چیزی پیش بأیه شمره بوگفتم، تا وختی کی اتفاق دکفه، ایمأن بأورید. ");
INSERT INTO glk_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","وخته زیادی نمأنسته کی شیمی اَمره حرف بزنم، چونکی رئیسه اَ دنیا اَمون دره، اون هیچ قدرتی بر من نأره. ");
INSERT INTO glk_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","امّا من کاری‌یه کونم کی پئر مره دستور بده، تا دنیا بدأنه کی پئره دوست دأرم. ویریزید، بیشیم. ");
INSERT INTO glk_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«انگور درخته حقیقی من ایسم و می پئر باغبأنه. ");
INSERT INTO glk_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","هر شاخه‌یی کی از منه و میوه نأوره، می پئر اونه وَوینه، و هر شاخه‌یی کی میوه اَوره، اونه هَرَس کونه، تا زیادتر میوه بأوره. ");
INSERT INTO glk_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","شومأن الأن بخاطره کلامی کی شمره بوگفتم، پاکیدی. ");
INSERT INTO glk_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","در من بمأنید، و منم در شومأن مأنم. چونکی شاخه نتأنه از خودش میوه بأوره مگر اینکه در درخت بمأنه، شومأنم نتأنید میوه بأورید اگر در من نمأنید. ");
INSERT INTO glk_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«من درخته انگور ایسم و شومأن اونه شاخه‌یأنیدی. کسی کی در من بمأنه و منم در اون، میوه‌یه زیادی اَوره. چونکی بدونه من هیچی نتأنیدی بوکونید. ");
INSERT INTO glk_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","اگر کسی در من نمأنه، مثله شاخه‌یی ایسه کی اونه دور تَوَدیدی و خوشکه به. خوشکه بوسته شاخه‌یأنه جمعَ کونیدی و آتشه میأن تَوَدیدی و سوزانیدی. ");
INSERT INTO glk_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","اگر در من بمأنید و می کلام در شومأن بمأنه، هر چیزی کی بخوأیید و درخوأست بوکونید براَورده به. ");
INSERT INTO glk_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","می پئره جلال در اَنه کی شومأن میوه‌یه زیادی بأورید و اَطویی می شاگرد بیدی. ");
INSERT INTO glk_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","«هوطو کی می پئر مره دوست دأشتی، منم شمره دوست دأشتیم. در می محبت بمأنید. ");
INSERT INTO glk_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","اگر می احکامه بدأرید، در می محبت مأنیدی، هَطو کی من می پئره احکامه بدأشتم و در اونه محبت مأنم. ");
INSERT INTO glk_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","اَ حرفأنه شمره بوگفتم تا می شادی در شومأن بأیه و شیمی شادی کامل ببه. ");
INSERT INTO glk_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","«می حکم اَنه کی همدیگره محبت بوکونید، هوطو کی من شمره محبت بوکودم. ");
INSERT INTO glk_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","بیشتر از اَن محبتی وجود نأره کی کسی خو جانه فدایه خو دوستأن بوکونه. ");
INSERT INTO glk_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","می دوستأن شومأنیدی، اگر اونچی کی شمره حکم بوکودم انجام بدید! ");
INSERT INTO glk_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","دِ شمره غلام دونوخوأنم، چونکی غلام از خو اربابه کارأن خبر نأره، بلکی شمره می دوست دأنم، چونکی هر چی کی از می پئر بیشنَوستم، شمره از اون باخبر بوکودم. ");
INSERT INTO glk_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","شومأن نیبید کی مره انتخاب بوکودیدی، بلکی من شمره انتخاب بوکودم و قرار بنَم کی بیشید و میوه بأورید و شیمی میوه بمأنه، تا هر چی از می پئر به نامِ من بخوأیید، شمره فده. ");
INSERT INTO glk_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","می حکم به شومأن اَنه کی همدیگره محبت بوکونید! ");
INSERT INTO glk_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«اگر دنیا از شومأن نفرت بدأره، به یاد بأورید کی قبل از شومأن، از من نفرت دأشتی. ");
INSERT INTO glk_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","اگر متعلق به دنیا بید، دنیا شمره مثله خو کسأن دوست دأشتی. امّا به دنیا تعلّق نأریدی، من شمره از دنیا انتخاب بوکودم، بخاطره اَنه کی دنیا از شومأن نفرت دأره. ");
INSERT INTO glk_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","کلامی‌یه کی شمره بوگفتم به یاد بأورید: ‹غلام از خو ارباب بزرگتر نی‌یه.› اگر مره آزار بدَییدی، شیمی اَمره‌یم هَطو کونیدی و اگر می کلامه بدأشتیدی، شیمی کلامه هم دأریدی. ");
INSERT INTO glk_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","امّا همه‌یه اَ کارأنه می نامِ وستی شیمی اَمره کونیدی چونکی اونی کی مره اوسه کوده اونه نشنأسیدی. ");
INSERT INTO glk_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","اگر نَمو بیم و اَشأنه اَ حرفأن نزه بیم، گناهی نأشتیدی، امّا الأن هیچ بهانه‌یی برای خوشأنه گناهأن نأریدی. ");
INSERT INTO glk_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","کسی کی از من نفرت بدأره، از می پئرم نفرت دأره. ");
INSERT INTO glk_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","اگر اوشأنه‌ره کاری نوکوده بیم کی بجز من کسی نوکوده، گناهی نأشتیدی، امّا الأن با اَنکی او کارأنه بیده‌ییدی، هم از من، هم از می پئر نفرت دأریدی. ");
INSERT INTO glk_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","اَطویی‌یه کی، کلامی کی در خوشأنه تورات بَمو، ثابت ببه کی: ‹از من بی‌دلیل نفرت دأریدی.› ");
INSERT INTO glk_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«امّا چون او پشتیبان کی از طرفه پئر روانه به، بأیه، یعنی روحه راستی کی از پئره ورجه اَیه، اون خودش می وستی شهادت دهه. ");
INSERT INTO glk_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","و شومأنم بأید شهادت بدید چونکی از اوّل می اَمره بید. ");
INSERT INTO glk_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«اَ چیزأنه شمره بوگفتم تا از راه بدره نیبید! ");
INSERT INTO glk_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","شمره از کنیسه‌یأن بیرونه کونیدی. حتی زمانی فَرسه کی هر کی شمره بوکوشه، فکر کونه کی خدایه خدمت بوکوده. ");
INSERT INTO glk_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","اَ کارأنه کونیدی، چونکی نه پئره شنأسیدی نه مره! ");
INSERT INTO glk_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","اَ حرفأنه شمره بوگفتم تا وخته اونه انجام فَرسه، به یاد بأورید کی شمره آگاه بوکوده بوم. اوشأنه از اوّل شمره نوگفتم، چونکی خودم شیمی اَمره بوم. ");
INSERT INTO glk_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«الأن کسی کی مره اوسه کوده اونه ورجه شوئون درم و هیچ‌کدام ونَورسیدی ‹کویه شوئون دری؟› ");
INSERT INTO glk_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","امّا می حرفأنه وستی شیمی دیل پُر از غم بوبوسته. ");
INSERT INTO glk_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","با اَ حال من شمره حقیقته گم کی می شوئون به نفعِ شومأنه، چونکی اگر نشم، او پشتیبان شیمی ورجه نأیه، امّا اگر بشم، اونه شیمی ورجه اوسه کونم. ");
INSERT INTO glk_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","و وختی اَیه، جهانه از اونه گناه، و از عدالته خداوند، و از روزِ داوری آگاه کونه. ");
INSERT INTO glk_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","گناهه جهان، بی‌ایمانی به منه. ");
INSERT INTO glk_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","عدالت فراهمه، چونکی من پئره ورجه شوئون درم و دِ مره نیدینیدی. ");
INSERT INTO glk_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","داوری اَیه چونکی رئیسه اَ جهان داوری بوبوسته. ");
INSERT INTO glk_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«خیلی چیزأنه دیگر دأرم کی شمره بگم، امّا الأن طاقتِ اونه ایشنَوستنه نأریدی. ");
INSERT INTO glk_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","امّا وختی روحه راستی بأیه، شمره به طرفه حقیقت هدایت کونه. چونکی اون از طرفه خودش حرفی نزنه، بلکی اونچی‌یه کی ایشنَوه، گه، و اونچی‌یه کی پیش اَیه، شمره خبر دهه. ");
INSERT INTO glk_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","اون مره جلال دهه، چونکی اونچی‌یه کی از من فیگیره، شمره خبر دهه. ");
INSERT INTO glk_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","هر چیزی کی پئره‌شینه، می‌شینم ایسه. هَنه وستی بوگفتم کی اونچی‌یه کی از من فیگیره، شمره خبر دهه. ");
INSERT INTO glk_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«پس از مدته کمی، دِ مره نیدینیدی، بعد از مدته کمه دیگری بازم مره دینیدی.» ");
INSERT INTO glk_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","اون وخت بعضی از اونه شاگردأن همدیگره بوگفتیدی: «اونه منظور از اَ حرفأن چی‌یه کی: ‹پس از مدته کمی، دِ مره نیدینیدی و پس از مدته کمه دیگری بازم مره دینیدی›؟ یا اَنکی گه ‹چونکی پئره ورجه شوئون درم›؟» ");
INSERT INTO glk_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","پس همدیگره گفتیدی: «اَ ‹مدته کمی› کی گه، چی‌یه؟ اونه منظوره نفهمیم؟» ");
INSERT INTO glk_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","امّا عیسی قبلاً دأنستی کی خوأییدی از اون سؤال بوکونید؛ پس اوشأنه بوگفته: «آیا اَنه وستی همدیگره اَمره بحث کونیدی کی بوگفتم ‹پس از مدته کمی، دِ مره نیدینیدی، و پس از مدته کمه دیگری بازم مره دینیدی؟› ");
INSERT INTO glk_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","آمین، آمین، شمره گم، شومأن گریه و زاری کونیدی امّا دنیا خوشحاله به. شومأن غمگینه بیدی، امّا شیمی غم به شادی تبدیله به. ");
INSERT INTO glk_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","زن تا وخته زأیمأن درد کشه، چونکی اونه وخت فَرسه. امّا وختی کی اونه زأی به دنیا بَمو، دِ خو درده به یاد نأوره، چونکی خوشحاله از اَنکی انسانی به دنیا بَمو. ");
INSERT INTO glk_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","هَطو کی شومأنم الأن غمگینیدی، امّا بازم شمره دینم کی شیمی دیل شاده به و هیچکس او شادی‌یه از شومأن فینگیره. ");
INSERT INTO glk_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","او روز دِ چیزی از من نخوأییدی. آمین، آمین، شمره گم، هر چی از پئر به نامِ من بخوأیید، اونه شمره فده. ");
INSERT INTO glk_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","تا الأن به نامِ من چیزی نخوأستیدی. بخوأیید تا پیدا بوکونید و شیمی شادی کامله به. ");
INSERT INTO glk_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«اَ چیزأنه مَثَله اَمره شمره بوگفتم، امّا زمانی فَرسه کی، دِ شیمی اَمره اَجور حرف نزنم، بلکی آشکارا در مورده پئر شمره گم. ");
INSERT INTO glk_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","او روز به نامِ من تقاضا کونیدی و شمره نگم کی من از طرفه شومأن از پئر تقاضا کونم. ");
INSERT INTO glk_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","چره کی پئر خودش شمره دوست دأره، چونکی شومأن مره دوست دأشتیدی و ایمأن بأوردیدی کی از خدا ورجه بَموم. ");
INSERT INTO glk_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","من از پئره ورجه بَموم و به اَ دنیا وارده بوستم، و الأن اَ دنیایه ترکه کونم و پئره ورجه شم.» ");
INSERT INTO glk_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","اون وخت اونه شاگردأن بوگفتیدی: «الأن آشکارا حرف زنی، نه مَثَله اَمره. ");
INSERT INTO glk_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","الأن دِ دأنیم کی از همه چیز آگاهی و حتی احتیاج نأری کسی خو سؤاله تی اَمره در میأن بنَه. هَنه وستی ایمأن دأریم کی از خدا ورجه بَمویی.» ");
INSERT INTO glk_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","عیسی اوشأنه بوگفته: «آیا الأن واقعاً ایمأن دأریدی؟ ");
INSERT INTO glk_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ولی زمانی فَرسه کی، و حقیقتاً الأن فَرسه کی پخشه بیدی و هر کی خو خانه و زندگی سر شه و مره تنها نَهه. ولی من تنها نی‌یم، چونکی پئر می اَمره‌یه. ");
INSERT INTO glk_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","اَ چیزأنه شمره بوگفتم تا در من آرامش بدأرید، دنیا میأن شومأن به زحمت دکفیدی؛ ولی شیمی دیل قوی ببه، چونکی من بر دنیا غلبه بوکودم.» ");
INSERT INTO glk_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","بعد از اَ حرفأن عیسی آسمانه نیگاه بوکوده و بوگفته: «پئر! وختش فَرسه. تی پسره جلال بدَن تا تی پسرم تره جلال بده. ");
INSERT INTO glk_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","چونکی تو اونه قدرت فدَیی بر تمامی‌یه بشر تا همه‌یه کسأنی‌یه کی تو به اون عطا بوکودی، زندگی‌یه اَبدی ببخشه. ");
INSERT INTO glk_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","و اَنه زندگی‌یه اَبدی، کی تره، تنها خدایه حقیقی و عیسی مسیحه کی اوسه کودی، بشنأسید. ");
INSERT INTO glk_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","من او کاری‌یه کی مره بیسپرده بی، به کمال فَرسأنم، و اَجور تره زمینه رو جلال بدَم. ");
INSERT INTO glk_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","پس الأن ای پئر، تونم مره در حضور خودت جلال بدَن، همان جلالی کی قبل از دنیا، تی ورجه دأشتیم. ");
INSERT INTO glk_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«من تی نامِ به اوشأنی کی از دنیا مره ببخشه‌یی، آشکاره کودم. تی‌شین بید و تو اوشأنه مره ببخشه‌یی و تی کلامه بدأشتیدی. ");
INSERT INTO glk_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","الأن بفهمستیدی کی هر چی کی مره ببخشه‌یی حقیقتاً از طرفه تویه. ");
INSERT INTO glk_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","چونکی او کلامی‌یه کی مره بیسپردی، اوشأنه بیسپردم و اوشأن اونه قبول بوکودیدی و یقین بدأنستیدی کی از طرفه تو بَمو و ایمأن بأوردیدی کی تو مره اوسه کودی. ");
INSERT INTO glk_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","می درخوأست اوشأنه وستی‌یه؛ من نه دنیا وستی، بلکی اوشأنی وستی تقاضا کونم کی تو مره ببخشه‌یی. چونکی تی‌شینیدی. ");
INSERT INTO glk_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","هر اونچی کی به من تعلّق دأره، تی‌شینه و هر اونچی کی به تو تعلّق دأره، می‌شینه و در اوشأن جلال پیدا بوکودم. ");
INSERT INTO glk_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","بیشتر از اَن، دنیا میأن نِیسم، امّا اوشأن هنوز در دنیا ایسیدی. من تی ورجه اَیم. ای پئره قدّوس، تی نامِ مره ببخشه‌یی، اوشأنه به قدرته تی نام حفظ بوکون، تا ایتأ بیبید، هَطو کی اَمأن ایسیم. ");
INSERT INTO glk_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","من اوشأنه تا زمانی کی می اَمره ایسه بید، حفظ بوکودم، و از اوشأن به قدرته تی نام کی مره ببخشه‌یی، محافظت بوکودم. هیچ‌کدام از اوشأن هلاکه نوبوستیدی، جز اونی کی بأید به هلاکت برسه، تا پیشگویی‌یه کیتابه مقدّس ثابت ببه. ");
INSERT INTO glk_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","امّا الأن تی ورجه اَیم و اَ حرفأنه زمانی گم کی دنیا میأن ایسم تا می شادی‌یه خوشأنه میأن به کمال برسأنید. ");
INSERT INTO glk_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","من تی کلامه اوشأنه فدم، امّا دنیا از اوشأن نفرت دأشتی، چونکی متعلق به دنیا نی‌ییدی. هَطو کی من تعلّق نأرم. ");
INSERT INTO glk_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","می درخوأست اَن نی‌یه کی اوشأنه از اَ دنیا ببری، بلکی خوأیم از شَرور محافظت بوکونی. ");
INSERT INTO glk_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","اوشأن به اَ دنیا تعلّق نأریدی هَطو کی من تعلّق نأرم. ");
INSERT INTO glk_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","اوشأنه به وسیله‌یه تی حقیقت تقدیس بوکون؛ تی کلام، حقیقته! ");
INSERT INTO glk_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","هَطو کی تو مره به اَ دنیا اوسه کودی، منم اوشأنه اَ دنیا میأن اوسه کودم. ");
INSERT INTO glk_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","من خودمه اوشأنه وستی تقدیس کونم، تا اوشأنم حقیقته اَمره تقدیس بیبید. ");
INSERT INTO glk_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«می درخوأست فقط اوشأنه‌ره نی‌یه، بلکی برای کسأنی‌یه کی توسطه اوشأنه پیغام به من ایمأن اَوریدی. ");
INSERT INTO glk_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","تا همه ایتأ بیبید، هَطو کی تو ای پئر در منی و من در تو، طوری بوکون کی اوشأنم در اَمأن بیبید، تا دنیا ایمأن بأوره کی تو مره اوسه کودی. ");
INSERT INTO glk_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","و من جلالی‌یه کی مره ببخشه‌یی، اوشأنه ببخشم، تا ایتأ بیبید، هَطویی کی اَمأن ایتأییم. ");
INSERT INTO glk_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","من در اوشأن و تو در من، طوری بوکون کی اوشأنم کاملاً ایتأ بیبید، تا دنیا بدأنه کی تو مره اوسه کودی و اوشأنه هوطویی دوست دأشتی کی مره دوست دأشتی. ");
INSERT INTO glk_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ای پئر خوأیم اوشأنی کی مره ببخشه‌یی، می اَمره بیبید، هو جایی کی من ایسم، تا می جلاله بیدینید، جلالی کی تو مره ببخشه‌یی؛ چون قبل از اَنکی دنیا به وجود بأیه، مره دوست دأشتی. ");
INSERT INTO glk_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","«ای پئره عادل، دنیا تره نشنأسه، امّا من تره شنأسم، و اوشأن دأنیدی کی تو مره اوسه کودی. ");
INSERT INTO glk_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","من تی نامِ به اوشأن بشنأسأنم و بازم شنأسأنم، تا او محبتی کی تو مره دأشتی، در اوشأنم بمأنه و منم در اوشأن بمأنم.» ");
INSERT INTO glk_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","عیسی پس از گفتنه اَ حرفأن خو شاگردأنه اَمره به او طرفه دره‌یه قِدْرون بوشو. در اویه باغی نَهه بو و عیسی خو شاگردأنه اَمره اویه بوشو. ");
INSERT INTO glk_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","امّا یهودا، اونه تسلیم‌کوننده، او محله شنأختی، چونکی عیسی و اونه شاگردأن همیشه در او محل جمعَ بوستیدی. ");
INSERT INTO glk_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","پس یهودا گروهی از سربازأن و مأمورأنه سرأنه کاهنأن و فَریسیأنه اوسَده و به اویه بَمو، اوشأن چراغ و مشعل و اسلحه اَمره اویه فَرسه‌ییدی. ");
INSERT INTO glk_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","عیسی با اونکی دأنستی چی رخ دهه، جلو بوشو و اوشأنه بوگفته: «کی دونبال گردیدی؟» ");
INSERT INTO glk_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","جواب بدَییدی: «عیسایه ناصری دونبال.» بوگفته: «منم!» یهودایه خائنم اوشأنه اَمره بو. ");
INSERT INTO glk_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","وختی عیسی بوگفته، «منم» اوشأن عقب عقب بوشوییدی و زمینه رو بکفتیدی. ");
INSERT INTO glk_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","عیسی ایبارِ دیگرم از اوشأن وَورسه: «کی دونبال گردیدی؟» بوگفتیدی: «عیسایه ناصری دونبال.» ");
INSERT INTO glk_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","جواب بده: «شمره بوگفتم کی من خودمم. پس اگر مره خوأییدی، وئلید اَشأن بیشید.» ");
INSERT INTO glk_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","اَنه بوگفته تا اونچی کی قبلاً بوگفته بو، ثابت ببه کی: «هیچ‌کدام از اوشأنی کی مره ببخشه‌یی، از دست ندم.» ");
INSERT INTO glk_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","اون وخت شَمعونِ پِطرُس شمشیری‌یه کی دأشتی، بیرون بأورده و ضربه‌یی به خادمه کاهنِ اعظم بزه و اونه گوشِ راسته وَوِه. اونه خادمه نام مالخوس بو. ");
INSERT INTO glk_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","عیسی پِطرُسَ بوگفته: «تی شمشیره غلاف بوکون. آیا نبأید او جامِ کی پئر مره فده، بنوشم؟» ");
INSERT INTO glk_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","اون وخت سربازأن، خوشأنه فرمانده و مأمورأنه یهودی اَمره، عیسایه دستگیر بوکودیدی و اونه دستأنه دَوَستیدی. ");
INSERT INTO glk_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","اوّل اونه حَنّا ورجه ببردید. حَنّا، قیافا زن پئر بو و او زمان کاهنِ اعظم بو. ");
INSERT INTO glk_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","قیافا اونی بو کی یهودیأنه توصیه کودی کی بهتره اینفر بخاطره قوم بیمیره. ");
INSERT INTO glk_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","شَمعونِ پِطرُس و ایتأ شاگرده دیگر عیسی دونبالسر بوشوییدی. او شاگرد از آشنایأنه کاهنِ اعظم بو. پس عیسی اَمره وارده حیاطه خانه‌یه کاهنِ اعظم بوبوسته. ");
INSERT INTO glk_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","امّا پِطرُس درِ پشت بِیسه. او شاگردی کی از آشنایأنه کاهنِ اعظم بو، بیرون بوشو و کنیزه اَمره کی دربان بو، حرف بزه و پِطرُسَ به خانه دورون ببرده. ");
INSERT INTO glk_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","اون وخت او کنیز پِطرُسَ بوگفته: «مگر تو از شاگردأنه او مرد نی‌یی؟» پِطرُس جواب بده: «نی‌یم.» ");
INSERT INTO glk_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","هوا سرد بو. خادمأن و مأمورأن زغاله اَمره آتشی چأکوده بید و اونه دور جمعَ بوسته بید و خوشأنه گرمه کودیدی. پِطرُسم اوشأنه اَمره ایسه بو و خودشه گرمه کودی. ");
INSERT INTO glk_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","پس کاهنِ اعظم از عیسی درباره‌یه اونه شاگردأن و اونه تعالیم وَورسه. ");
INSERT INTO glk_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","عیسی جواب بده: «من به دنیا آشکارا حرف بزم و همیشه کنیسه و معبده میأن کی یهودیأن اویه جمعَ بیدی، تعلیم بدَم و چیزی‌یه مخفیأنه نوگفتم. ");
INSERT INTO glk_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","چره از من وَورسی؟ از اوشأنی وَورس کی می حرفأنه بیشنَوستیدی؛ اوشأن بهتر دأنیدی کی من اوشأنه چی بوگفتم.» ");
INSERT INTO glk_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","وختی اَنه بوگفته، ایتأ از قراولأن کی اویه ایسه بو، ایتأ سیلی اونه صورته بزه و بوگفته: «اَطو کاهنِ اعظمِ جواب دیهی؟» ");
INSERT INTO glk_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","عیسی جواب بده: «اگر خطا بوگفتم، بر می خطا شهادت بدَن، امّا اگر راست بوگفتم، چره مره زنی؟» ");
INSERT INTO glk_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","اون وخت حَنّا اونه با دسته دَوَسته اوسه کوده قیافا کاهنِ اعظمِ ورجه. ");
INSERT INTO glk_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","موقعی کی شَمعونِ پِطرُس ایسه بو و خودشه گرمه کودن دوبو، بعضی‌یأن اونه بوگفتیدی: «مگر تو از اونه شاگردأن نی‌یی؟» اون انکار بوکوده و بوگفته: «نه! نی‌یم.» ");
INSERT INTO glk_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ایتأ از خادمأنه کاهنِ اعظم اویه ایسه بو. اون از بستگأنه کسی بو کی پِطرُس اونه گوشِ وَوِه بو، بوگفته: «مگر من خودم تره اونه اَمره او باغه میأن نیدم؟» ");
INSERT INTO glk_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","پِطرُس بازم انکار بوکوده. هو لحظه ایتأ خروس بخوأنده. ");
INSERT INTO glk_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","یهودیأن عیسایه از قیافا ورجه به کاخِ فرمانداره رومی ببردیدی. وخته سحر بو. اوشأن خودشأن وارده کاخ نوبوستیدی تا نجسته نیبید و بتأنید پِسَخَ بوخورید. ");
INSERT INTO glk_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","پس پیلاتُس اوشأنه ورجه بَمو و وَورسه: «اَ مردَ به چی جُرمی متهم کونیدی؟» ");
INSERT INTO glk_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","جواب بدَییدی و بوگفتیدی: «اگر جُرمی نأشتی، اونه به تو تسلیمه نوکودیم.» ");
INSERT INTO glk_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","پیلاتُس اوشأنه بوگفته: «شومأن خودتأن اونه ببرید و طبقِ شیمی شریعت اونه محاکمه بوکونید.» یهودیأن بوگفتیدی: «اَمأن اجازه نأریم کسی‌یه اعدام بوکونیم.» ");
INSERT INTO glk_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","به اَ طریق عیسی حرفأن در مورده اَنکی چی جور مرگی در انتظاره اونه، ثابته به. ");
INSERT INTO glk_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","پس پیلاتُس به کاخ وأگردسته و عیسایه دوخوأده و اونه بوگفته: «آیا تو پادشایه یهودی؟» ");
INSERT INTO glk_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","عیسی جواب بده: «آیا اَنه تو خودت گی، یا دیگرأن درباره‌یه من تره بوگفتیدی؟» ");
INSERT INTO glk_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","پیلاتُس جواب بده: «مگر من یهودی‌یم؟ تی قوم و سرأنه کاهنأن تره به من تسلیم بوکودیدی. مگر چی بوکودی؟» ");
INSERT INTO glk_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","عیسی جواب بده: «می پادشاهی از اَ دنیا نی‌یه. اگر می پادشاهی از اَ دنیا بو، می خادمأن جنگستیدی تا من به دسته یهودیأن دستگیره نبم. امّا می پادشاهی از اَ دنیا نی‌یه.» ");
INSERT INTO glk_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","پیلاتُس اونه بوگفته: «پس تو پادشاهی؟» عیسی جواب بده: «تو خودت گی کی من پادشاهم. من هَنه وستی به دنیا بَموم تا حقیقته شهادت بدَم. پس هر کسی کی به حقیقت تعلّق دأره، می صدایه گوش کونه.» ");
INSERT INTO glk_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","پیلاتُس بوگفته: «حقیقت چیسه؟» وختی پیلاتُس اَنه بوگفته، بازم بوشو بیرون یهودیأنه ورجه و اوشأنه بوگفته: «من هیچ دلیلی اونه محکوم کودنه‌ره نیدینم. ");
INSERT INTO glk_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","امّا شومأن ایتأ رسم دأریدی کی در روزِ پِسَخ ایتأ زندانی‌یه شمره آزاده کونم. آیا خوأییدی کی پادشاه یهوده آزاده کونم؟» ");
INSERT INTO glk_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","اوشأن در جواب، داد بزه‌ییدی: «اونه نه! بلکی بارْاَبّایه آزاده کون!» (بارْاَبّا راهزن بو.) ");
INSERT INTO glk_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","اون وخت پیلاتُس دستور بده عیسایه شلاق بزنید. ");
INSERT INTO glk_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","و سربازأن، تاجی از خار ببافتیدی و اونه سر بنَه‌ییدی و لیباسی ارغوانی رنگ اونه دوکودیدی. ");
INSERT INTO glk_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","و اونه ورجه اَموییدی و گفتیدی: «سلام بر تو، ای پادشایه یهود.» و اونه سیلی زه‌ییدی. ");
INSERT INTO glk_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","بعد از اون، پیلاتُس ایبارِ دیگر بیرون بَمو و یهودیأنه بوگفته: «من اونه شیمی ورجه بیرون اَورم تا بدأنید کی هیچ دلیلی اونه محکوم کودنه‌ره پیدا نوکودم.» ");
INSERT INTO glk_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","پس عیسی، تاجه خار و لیباسه ارغوانی اَمره، بیرون بَمو. پیلاتُس اوشأنه بوگفته: «اَنه، او شخص!» ");
INSERT INTO glk_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","وختی سرأنه کاهنأن و قراولأنه معبد اونه بیده‌ییدی فریاد بزه‌ییدی و بوگفتیدی: «مصلوبه کون! مصلوبه کون!» پیلاتُس اوشأنه بوگفته: «شومأن خودتأن اونه ببرید و مصلوبه کونید، چون من هیچ دلیلی اونه محکوم کودنه‌ره پیدا نوکودم.» ");
INSERT INTO glk_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","یهودیأن در جوابه اون بوگفتیدی: «اَمأن شریعتی دأریم کی طبقِ اون، اَ شخص بأید بیمیره، چونکی ادعا کونه خدا پسره!» ");
INSERT INTO glk_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","وختی پیلاتُس اَنه بیشنَوسته، بیشتر بترسه. ");
INSERT INTO glk_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","بازم به کاخ وأگردسته و از عیسی وَورسه: «تو از کویه بَمویی؟» امّا عیسی اونه جوابی نده. ");
INSERT INTO glk_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","پس پیلاتُس اونه بوگفته: «مره هیچی نیگی؟ آیا نأنی کی قدرت دأرم تره آزاده کونم و قدرت دأرم کی تره مصلوبه کونم؟» ");
INSERT INTO glk_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","عیسی بوگفته: «هیچ قدرتی بر من نأشتی، مگر اینکه از بوجور، فیگیفته بی ولی گناهه اونی کی مره به تو تسلیم بوکوده از تو بیشتره.» ");
INSERT INTO glk_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","بعد از اون، پیلاتُس سعی بوکوده کی اونه آزاده کونه، امّا یهودیأن فریاد زه‌ییدی و گفتیدی: «اگر اَ مردَ آزاده کونی، قیصرِ دوست نی‌یی! هر کی ادعایه پادشاهی کونه، به ضده قیصر حرف زنه.» ");
INSERT INTO glk_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","وختی پیلاتُس اَ حرفأنه بیشنَوسته، عیسایه بیرون بأورده و خودش بر مسنده داوری بینیشته، در محلی کی به «سنگه فرش» معروف بو و به زبانه عبرانیأن «جَبّاتا» گفتیدی. ");
INSERT INTO glk_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","او روز، روزِ «تهیه» عیده پِسَخ بو و ظهر نزدیک بو. پیلاتُس یهودیأنه بوگفته: «اَنه شیمی پادشاه!» ");
INSERT INTO glk_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","اوشأن فریاد بزه‌ییدی: «اونه از میأن اوسَن! اونه از میأن اوسَن. اونه مصلوبه کون!» پیلاتُس بوگفته: «آیا شیمی پادشایه مصلوبه کونم؟» سرأنه کاهنأن جواب بدَییدی: «اَمأن پادشاهی جز قیصر نأریم.» ");
INSERT INTO glk_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","سر آخر پیلاتُس عیسایه به اوشأن بیسپرده تا اونه مصلوبه کونید. اون وخت عیسایه بیگیفتیدی و ببردیدی. ");
INSERT INTO glk_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","عیسی صلیب به دوش بیرون بوشو، به سمته محلی به نامِ جمجمه کی به زبانه عبرانیأن جُلجُتا خوأنده به. ");
INSERT INTO glk_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","اویه اونه به صلیب بکشه‌ییدی. اونه اَمره دو نفر دیگرم، اونه دو طرف مصلوبه کودیدی و عیسی اوشأنه میأن قرار دأشتی. ");
INSERT INTO glk_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","به دستوره پیلاتُس ایتأ نیویشته اونه صلیبه جور نصب بوکودیدی، کی اونه رو بینیویشته بوبوسته بو: «عیسایه ناصری، پادشایه یهود.» ");
INSERT INTO glk_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","خیلی از یهودیأن او نیویشته‌یه بخوأندیدی، چون جایی کی عیسایه به صلیب بکشه‌ییدی، نزدیک به شهر بو و او نیویشته به زبانه عبرانیأن و لاتینی و یونانی بو. ");
INSERT INTO glk_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","پس سرأنه کاهنأنه یهود پیلاتُسَ بوگفتیدی: «نینیویس، ‹پادشاه یهود›، بلکی بینیویس اَ مرد بوگفته کی من پادشاه یهودم.» ");
INSERT INTO glk_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","پیلاتُس جواب بده: «اونچی بینیویشتم، بینیویشتم.» ");
INSERT INTO glk_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","وختی سربازأن عیسایه به صلیب بکشه‌ییدی، اونه لیباسأنه اوسَدیدی و به چهارتأ قسمت تقسیم بوکودیدی. هر کدام ایتأ تیکه اوسَدیدی. اونه لیباسه زیرَ هم فیگیفتید. امّا او لیباس درز نأشتی، بلکی یکسره از بوجور به بیزیر ببافته بوبوسته بو. ");
INSERT INTO glk_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","پس همدیگره بوگفتیدی: «اَنه تیکه تیکه نوکونیم، بلکی قرعه تَوَدیم و بیدینیم کی‌شین به.» اَطویی پیشگویی‌یه کیتابه مقدّس ثابته به کی: «می لیباسأنه خوشأنه میأن تقسیم کونیدی و می لیباسأنه‌ره قرعه تَوَدیدی.» پس سربازأن هوطو بوکودیدی. ");
INSERT INTO glk_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","عیسی صلیبه نزدیکی اونه مار و اونه خألأ و مریم کْلوپاسِ زن و مریمِ مَجْدَلیّه ایسه بید. ");
INSERT INTO glk_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","وختی عیسی خو مار و او شاگردی‌یه کی دوست دأشتی و اونه کنار ایسه بو، بیده، خو ماره بوگفته: «بانو، اَنه، تی پسر!» ");
INSERT INTO glk_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","بعد از اَن او شاگرده بوگفته: «اَنه، تی مار!» از او ساعت، او شاگرد، عیسی ماره خودشه خانه ببرده. ");
INSERT INTO glk_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","اون وخت عیسی دأنستی کی همه چیز به انجام برسه؛ بوگفته: «تشنه‌یم!» به اَ خاطر بوگفته تا پیشگویی‌یه کیتابه مقدّس ثابت ببه. ");
INSERT INTO glk_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","در اویه ظرفی نَهه بو پُر از شرابه ترشیده. پس اسفنجی‌یه به او شراب بزه‌ییدی و بنَه‌ییدی ایتأ شاخه سر و اونه دهأنِ ورجه ببردیدی. ");
INSERT INTO glk_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","وختی عیسی شرابه بیچیشته، بوگفته: «به انجام برسه.» بعد از اون، خو سره خمه کوده و خو روحه تسلیم بوکوده. ");
INSERT INTO glk_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","او روز، روزِ «تهیه» بو، و روزِ بعد، شَبّاتِ بزرگ. از اویه کی حاکمأنه یهود نخوأستیدی کی جسدأن، تا روزِ بعد صلیبه رو بمأنه، از پیلاتُس بخوأستیدی کی او سه نفره ساقِ پایه بشکنید و اوشأنه جسدأنه از صلیب بیزیر بأورید. ");
INSERT INTO glk_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","پس سربازأن بَموییدی و اوّلین نفره ساقِ پا و اویتأ ساقِ پایه کی عیسی اَمره به صلیب بکشه بید، بشکنه‌ییدی. ");
INSERT INTO glk_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","امّا وختی به عیسی فَرسه‌ییدی، بیده‌ییدی کی بمَرده، اونه ساقأنه نشکنه‌ییدی. ");
INSERT INTO glk_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","امّا ایتأ از سربازأن نیزه‌یه اونه پهلویه بزه و هو لحظه از اونه بدن خون و آب جاری بوبوسته. ");
INSERT INTO glk_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","اونی کی اَنه بیده شهادت دهه، تا شومأنم ایمأن بأورید. اونه شهادت راسته و اون دأنه کی حقیقته گفتن دره. ");
INSERT INTO glk_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","اَشأن رخ بده تا پیشگویی‌یه کیتابه مقدّس ثابت ببه کی: «هیچ‌کدام از اونه استخوأنأن نشکفه.» ");
INSERT INTO glk_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","و قسمتی دیگرم از کیتابه مقدّس کی گه: «اونی‌یه کی به اون نیزه بزه‌ییدی، تماشا کونیدی.» ");
INSERT INTO glk_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","اون وخت یوسف، اهله رامه، از پیلاتُس اجازه بخوأسته کی عیسی جسده فیگیره. یوسف از پیروأن عیسی بو، امّا مخفیأنه. چونکی از حاکمأنه یهود ترسه‌یی. پیلاتُس اونه اجازه بده. پس بَمو و عیسی جسده فیگیفته. ");
INSERT INTO glk_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","نیقودیموسم کی قبلاً شبأنه عیسی ورجه بوشو بو، بَمو و خو اَمره عطری از مُر و عود کی حدوده سی و پنج کیلو بو، بأورده. ");
INSERT INTO glk_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","پس اوشأن عیسی جسده فیگیفتیدی و اونه به رسمه دفنه یهودیأن عطریاته اَمره کفنه میأن بپیچَنیدی. ");
INSERT INTO glk_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","نزدیکه او جایی کی عیسی مصلوبه بوسته، باغی بو کی او باغه میأن مقبره‌یی تازه وجود دأشتی کی هنوز مُرده‌یی در اون ننَه بید. ");
INSERT INTO glk_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","پس چونکی روزِ «تهیه» یهودیأن بو و او مقبره‌یم نزدیک بو، عیسی جسده در اویه بنَه‌ییدی. ");
INSERT INTO glk_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","در اوّلین روزِ هفته، وخته سحر، زمانی کی هوا هنوز تاریک بو، مریم مَجْدَلیّه مقبره ورجه بوشو و بیده کی اونه سنگ اوسَده بوبوسته. ");
INSERT INTO glk_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","پس بدو بدو بوشو شَمعونِ پِطرُسِ ورجه و او شاگرده دیگری کی عیسی، اونه دوست دأشتی. مریم اوشأنه بوگفته: «اَمی سروره از قبر ببردیدی و نأنیم کویه بنَه‌ییدی.» ");
INSERT INTO glk_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","پس پِطرُس اویتأ شاگرده اَمره بیرون بَمو و بوشوییدی به سمته مقبره. ");
INSERT INTO glk_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","هر دوتأ دووَستیدی، امّا اویتأ شاگرد تندتر بوشو، از پِطرُس پیش دکفته و اوّل اون به مقبره فَرسه. ");
INSERT INTO glk_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","پس خمه بوسته و بیده کی پارچه‌یه کفن اویه نَهه. امّا مقبره دورون نوشو. ");
INSERT INTO glk_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","پس شَمعونِ پِطرُسم، اونه دونبالسر بَمو و مقبره دورون بوشو و بیده کی پارچه کفنی اویه نَهه، ");
INSERT INTO glk_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","امّا او دستمالی کی عیسی سر دَوَسته بید، پارچه‌یه کفنی کنار ننَه بو، بلکی جدا و تا بوبوسته جایی دیگر نَهه بو. ");
INSERT INTO glk_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","پس او شاگرده دیگرم کی اوّل به مقبره فَرسه بو، بوشو بودورون، بیده و ایمأن بأورده. ");
INSERT INTO glk_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","چونکی هنوز کیتابه مقدّسه درک نوکوده بید کی اون بأید از مُرده‌یأنه میأن ویریزه. ");
INSERT INTO glk_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","اون وخت او دوتأ شاگرد خوشأنه خانه وأگردستیدی. ");
INSERT INTO glk_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ولی مریم بیرونه مقبره ایسه بو و گریه کودی. اون گریه اَمره خمه بوسته تا مقبره دورونه نیگاه بوکونه. ");
INSERT INTO glk_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","نیگاه بوکوده و دوتأ فرشته‌یه بیده کی لیباسه سفید، دوکوده بید، او جایی کی عیسی جسده بنَه بید، ایتأ سره ورجه و اویتأ پا ورجه نیشته بید. ");
INSERT INTO glk_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","اوشأن اونه بوگفتیدی: «ای زن، چره گریه کونی؟» جواب بده: «می سروره ببردیدی و نأنم کویه بنَه‌ییدی.» ");
INSERT INTO glk_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","وختی اَنه بوگفته وأگردسته و عیسایه اویه سرپا بیده، ولی نشنأخته. ");
INSERT INTO glk_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","عیسی اونه بوگفته: «ای زن، چره گریه کونی؟ کی دونبال گردی؟» مریم به خیال اَنکی باغبأنه، بوگفته: «ای سرور، اگر تو اونه اوسَدی مره بوگو کویه بنَه‌یی تا بشم و اونه اوسَنم.» ");
INSERT INTO glk_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","عیسی دوخوأده: «مریم!» مریم خو رویه اونه طرف وأگردأنه و به زبانه عبرانیأن بوگفته: «رَبّونی!» (یعنی اوستاد). ");
INSERT INTO glk_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","عیسی اونه بوگفته: «مره وله کون، چونکی هنوز می پئره ورجه بوجور نوشوم. بلکی می برأرأنه ورجه بوشو و اوشأنه بوگو، می پئر و شیمی پئره ورجه و می خدا و شیمی خدا ورجه بوجور شوئون درم.» ");
INSERT INTO glk_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","مریم مَجْدَلیّه بوشو و شاگردأنه خبر بده کی: «خداونده بیدم!» و اونچی کی بوگفته بو، اوشأنه بوگفته. ");
INSERT INTO glk_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","هو روز غروب کی یکشمبه بو، وختی کی شاگردأن جمعَ بوسته بید و درأن از ترسه حاکمأنه یهود قفل بو، عیسی بَمو و اوشأنه میأن بِیسه و بوگفته: «سلام بر شومأن!» ");
INSERT INTO glk_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","وختی اَنه بوگفته، خو دستأنه و خو پهلویه اوشأنه نیشأن بده. شاگردأن با خداونده دِئن شاده بوستیدی. ");
INSERT INTO glk_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","عیسی بازم اوشأنه بوگفته: «سلام بر شومأن! هوطو کی پئر مره اوسه کوده، منم شمره اوسه کونم.» ");
INSERT INTO glk_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","وختی اَ حرفه بوگفته، شاگردأنه رو فوت بوکوده و بفرمأسته: «روح‌القدسه فیگیرید. ");
INSERT INTO glk_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","اگر کسی گناهأنه ببخشید، اونه‌ره بخشیده به، و اگر کسی گناهأنه نبخشید اونه‌ره، بخشیده نیبه.» ");
INSERT INTO glk_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","وختی کی عیسی بَمو، توما، ایتأ از اون دوازده نفر کی دوقولویم اونه دوخوأدیدی، اوشأنه اَمره نوبو. ");
INSERT INTO glk_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","پس شاگردأنه دیگر اونه بوگفتیدی: «خداونده بیده‌ییم!» امّا اون اوشأنه بوگفته: «تا خودم جایه میخه اونه دستأنه میأن نیدینم و می انگوشته اونه جایه میخ نَنم و می دسته اونه پهلو سوراخه میأن نَنم، ایمأن نأورم.» ");
INSERT INTO glk_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","بعد از یک هفته، عیسی شاگردأن، بازم خانه میأن ایسه بید و تومایم اوشأنه اَمره بو. در حالی کی درأن قفل بید عیسی بَمو و اوشأنه میأن بِیسه و بوگفته: «سلام بر شومأن!» ");
INSERT INTO glk_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","اون وخت تومایه بوگفته: «تی انگوشته اَیه بنَه و می دستأنه بیدین. تی دسته جلو بأور و می پهلو سوراخه میأن بنَه. بی‌ایمأن نوبو، بلکی ایمأن بدأر.» ");
INSERT INTO glk_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","توما اونه بوگفته: «می خداوند! می خدا!» ");
INSERT INTO glk_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","عیسی بوگفته: «آیا چونکی مره بیده‌یی، ایمأن بأوردی؟ خوش بحال اوشأنی کی نیده‌ییدی، ایمأن بأوردیدی.» ");
INSERT INTO glk_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","عیسی معجزاته زیاده دیگری در حضور خو شاگردأن انجام بده کی اَ کیتابه میأن بینیویشته نوبوسته. ");
INSERT INTO glk_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ولی اَنقدر بینیویشته بوبوسته تا ایمأن بأورید کی عیسی هو مسیح، و خدا پسره، و به توسطه اَ ایمأن صاحبه زندگی‌یه اَبدی بیبید. ");
INSERT INTO glk_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","بعد از اَ اتفاقأن، عیسی بارِ دیگر خودشه در کنار دریاچه تیبِریه، به خو شاگردأن آشکاره کوده. اون اَطو ظاهره بوسته: ");
INSERT INTO glk_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ایتأ روز، شَمعونِ پِطرُس، تومایه معروف به دوقولو، نَتَنائیل از مردمأنه قانایه جلیل، زِبِدی پسرأن، و دوتأ از شاگردأنه دیگرم با هم بید. ");
INSERT INTO glk_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","شَمعونِ پِطرُس اوشأنه بوگفته: «من شوئون درم ماهی صید بوکونم.» اوشأن بوگفتیدی: «اَمأنم تی اَمره اَییم.» پس بیرون بوشوییدی و قایقه سوارَ بوستیدی. امّا او شب هر چقدر تور تَوَدیدی، چیزی صید نوکودیدی. ");
INSERT INTO glk_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","وخته سحر، عیسی ساحله کنار بِیسه، امّا شاگردأن نفهمستیدی کی عیسایه. ");
INSERT INTO glk_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","اون اوشأنه بوگفته: «ای زأکأن، چیزی خوردنه‌ره نأریدی؟» جواب بدَییدی: «نه!» ");
INSERT INTO glk_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","بوگفته: «توره به طرفه راسته قایق تَوَدید، تأنیدی بیگیرید.» اوشأن اَ کاره بوکودیدی و از زیادی ماهی نتأنستیدی توره قایقه دورون فکشید. ");
INSERT INTO glk_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","شاگردی کی عیسی اونه دوست دأشتی، پِطرُسَ بوگفته: «اون خداونده!» وختی شَمعونِ پِطرُس بیشنَوسته اون خداونده، خو لیباسه خو دور دَوَسته - چونکی اونه از خو تن بیرون بأورده بو و خودشه دریا میأن تَوَدَه. ");
INSERT INTO glk_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","امّا شاگردأنه دیگر قایقه اَمره بَموییدی، در حالی کی تور پُر از ماهی‌یه، خوشأنه اَمره فکشن دیبید. چونکی اوشأنه فاصله ساحله اَمره حدوده صد متر بو. ");
INSERT INTO glk_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","وختی به ساحل فَرسه‌ییدی، آتشی‌یه بیده‌ییدی کی زغاله اَمره چأکوده بوسته بو و ماهی‌یم اونه رو و نانم اویه نَهه بو. ");
INSERT INTO glk_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","عیسی اَشأنه بوگفته: «از او ماهی‌یأنی کی الأن بیگیفتیدی، بأورید.» ");
INSERT INTO glk_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","شَمعونِ پِطرُس وارده قایق بوبوسته و توره به طرفه ساحل فکشه. تور پُر از پیله ماهی بو، به تعداده صد و پنجاه و سه‌تأ ماهی. با اَنکی تعداده ماهی بیش از حد بو، تور پاره نوبوسته. ");
INSERT INTO glk_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","عیسی اَشأنه بوگفته: «بأیید ناشتأیی بوخورید.» هیچ‌کدام از شاگردأن جرأت نوکودیدی از اون وَورسید «تو کی ایسی؟» چونکی دأنستیدی کی اون خداونده. ");
INSERT INTO glk_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","عیسی جلو بَمو و نانه اوسَده و اوشأنه فده و ماهی‌یم هَطو. ");
INSERT INTO glk_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","اَن سوّمین بار بو کی عیسی بعد از ویریشتن از مُرده‌یأنه میأن، به خو شاگردأن ظاهره بوسته. ");
INSERT INTO glk_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","بعد از ناشتأیی، عیسی از شَمعونِ پِطرُس وَورسه: «ای شَمعون، یوحنا پسر، آیا مره بیشتر از اَشأن دوست دأری؟» اون جواب بده: «بله ای خداوند! تو دأنی کی تره دوست دأرم!» عیسی اونه بوگفته: «از می گوسفندأن مراقبت بوکون.» ");
INSERT INTO glk_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","دوّمین بار عیسی از اون وَورسه: «ای شَمعون، یوحنا پسر، آیا مره دوست دأری؟» اون جواب بده: «بله ای خداوند! دأنی کی تره دوست دأرم!» عیسی بوگفته: «از می گوسفندأن مراقبت بوکون.» ");
INSERT INTO glk_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","سوّمین بار اونه بوگفته: «ای شَمعون، یوحنا پسر، آیا مره دوست دأری؟» پِطرُس از اَنکی عیسی سه بار از اون وَورسه کی «آیا مره دوست دأری؟» ناراحته بوسته و جواب بده: «ای خداوند! تو از همه چیز باخبری. تو دأنی کی تره دوست دأرم.» عیسی بوگفته: «از می گوسفندأن مراقبت بوکون. ");
INSERT INTO glk_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","آمین، آمین، تره گم، زمانی کی جوانتر بی، تی کمره دَوَستی و هر جا کی خوأستی شویی؛ امّا وختی کی پیره بی، تی دستأنه درازه کونی و کسی دیگر تی کمره دَوَده و به جایی کی نخوأیی بیشی، تره بره.» ");
INSERT INTO glk_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","عیسی اَ حرفأنه اَمره اشاره به چوطو مَردنه پِطرُس کودی کی اونه اَمره خدایه جلال دهه. بعد از اون، عیسی اونه بوگفته: «می دونبالسر بیأ!» ");
INSERT INTO glk_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","اون وخت پِطرُس وأگردسته و بیده کی او شاگردی کی عیسی اونه دوست دأشتی، اونه دونبالسر اَمون دره. اون هونی بو کی شامِ موقع عیسی سینه سر تکیه بده بو و وَورسه بو کی: «سرورم، کی‌یه کی تره تسلیم کونه؟» ");
INSERT INTO glk_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","وختی پِطرُس اونه بیده، از عیسی وَورسه: «پس اون چی به؟» ");
INSERT INTO glk_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","عیسی اونه بوگفته: «اگر بخوأیم اون تا می وأگردستن، زنده بمأنه، به تو چی؟ تو می دونبال بیأ!» ");
INSERT INTO glk_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","پس اَ فکر، برأرأنه میأن شایع بوبوسته کی او شاگرد نیمیره، در حالی کی عیسی پِطرُسَ نوگفته کی اون نیمیره، بلکی بوگفته: «اگر بخوأیم اون تا می وأگردستن، زنده بمأنه، به تو چی؟» ");
INSERT INTO glk_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","هو شاگرده کی بر اَ چیزأن شهادت دهه، و اَشأنه بینیویشته و اَمأن دأنیم کی اونه شهادت راسته. ");
INSERT INTO glk_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","عیسی کارأیه زیاد دیگری‌یم بوکوده، کی اگر دانه دانه بینیویشته بوبوسته بید، گومان نوکونم حتی تمام دنیایم گنجایشه اونه نیویشته‌یأنه بدأشته بی. ");
ALTER TABLE glk_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
