﻿USE sofia;
DROP TABLE IF EXISTS sofia.ghs_vpl;
CREATE TABLE ghs_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ghs_vpl WRITE;
INSERT INTO ghs_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Dzoobe Qesamane Name: Dzesu Kiristui Abarahamu ma Tabitiho sooro ma sainata biranatetaho ttari erani. ");
INSERT INTO ghs_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Oi Abarahamui Isakaho mai ma Isakaho khatai Dzakopo. Qate Dzakopoho khametoi apene bahe Dzuta ma nomamane noho (nokoi tupu 12 naateta). ");
INSERT INTO ghs_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ma Dzutai Ttamarake naatemi nopoho khameto biranateta oi Pare ma Dzara. Qate Pareho khata noi Esiromu ma Esiromuho khataio Aramu. ");
INSERT INTO ghs_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ma Aramuho khatai Aminatabi ma noho khataio Nasoni. ");
INSERT INTO ghs_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Qate Nasoniho khata Saromo ma noi Rakhabike naatemi nopoho khata Boasi biranateta. Qate Boasi noi Ruttike naatemi Obetti biranateta. Biranateqi noi ata naatemi Dzese biranateta. ");
INSERT INTO ghs_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Biranatemi nomaeho khata Tabiti biranateqi Dzuta abiho qiba naateta. Oonita Tabiti noi Uriaho ata tarumi aimata dzapa noho Battaseba ma nopoho khata Soromo noi biranateta. ");
INSERT INTO ghs_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Qate Soromoho khata Rehoboamu ma Rehoboamuho khata Abidza ma noho khata Asa biranateta. ");
INSERT INTO ghs_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Qate Asaio ata maatemi Dzehosapati biranateta ma Dzehosapatiho khata Dzoramu biranatemi noho khata Adzaria. ");
INSERT INTO ghs_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Qate Adzariaho khata Dzottamu ma Dzottamuho khata Ahadzi ma noho khata Hedzekia. ");
INSERT INTO ghs_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Oonita Hedzekiaho khata Manase biranatemi noho Khata too abi Amosi oni qate noho khatai Dzosia. ");
INSERT INTO ghs_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ma Dzosiaho khameto Dzekhonia ma nomamane biranateta oi Isirae abiho tupu Dzuta nokoi oho bodzata Babironia habaho sutasuta abi naate tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Oke eetemi Dzekhoniaho khata Sarattie oqata biranateta qate Sarattieho khata Dzarubabei biranateta noio abi qiba teei oni. ");
INSERT INTO ghs_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Qate khata noho Abiuta biranateta ma Abiutaho khata Eriakimu biranateta ma noho ttidzata Adzaro biranateta. ");
INSERT INTO ghs_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Qate Adzaroho khata Sattoko biranatemi nomaeho khata Akhimi biranatemi noho ttidzata Eriutti biranateta. ");
INSERT INTO ghs_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Qate Eriuttiho khata Ereadza oni qate noho khata Mattani ma Mattaniho khata Dzakopo Dzosepeho mai. ");
INSERT INTO ghs_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Oi Dzosepe ape bahe Marake naateta. Oonita Mariaho ttidzata Dzesu, noho totaqike paha Kiristuiqi hiirorai noi biranateta. ");
INSERT INTO ghs_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Oonita mooro, Abarahamuho soro ma saina biranate peitemi Tabitiho bodza naatemi oho soro ma saina 14 naateta. Qate Tabitiho neta biidza ma suuna biranate peitemi oi Babironiaho sutasuta bodza naateta oho soro ma saina paha 14 naateta. Ma ooqata biidza ma suuna ipibire biranatemi Kiristu biranateta oho soro ma saina oho qesa 14 naateta. ");
INSERT INTO ghs_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Oonita Dzesu Kiristui ikanomake eete biranateta oho isere erani. Oi pai nohoho dzapa Maria, noi Dzosepeho ata pobi oomi Qaheuba Sumasai noke dzasusu eetemi noi qura eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Qura eetemi apu pobi noho Dzosepei oke moomi nota bame eeteta. Oonihe noi hasu ma keba abi oonita noi te noho qomaqoma hibaranihe seiqake oho gee teeke saridze Mariake qaatareiqi qupadzomata. ");
INSERT INTO ghs_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Oke qupadzohiqi, idze! noi nese qooroqi moomi Ohonga Sooparaho angero noho torota biranateqi hiireta, Tabitiho eema ma khata Dzosepe, nii nookare. Maria ata pobi niimeke aimareiqi eto atti eetaino. Oi noke dzasusu eeteta oi abi bahe Qaheuba Sumasa. ");
INSERT INTO ghs_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Oonita noi khata dzoomamake abi minaraho kahosa qagaumaquho baura qidza oi khataho irata peitakoi oho qubake nii noho dzapake Dzesuiqi hiibaridzoni — oho khoobai hee, Ohonga ingona mai ooniqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Oonita tete oonomata biranatetaho khooba erani. Ohonga Sooparai too abiho qetaqetata hee, Nookao, qeseba atapa teei qura eeteqi khata dzoomani noho dzapake hee, Emanuere hiibakoi. Oonihe dzapa oho khoobai hee, Ohongai abi napama oorai ooiqi hiiroraita oho qetaqetai ooqata meenoma naateta. ");
INSERT INTO ghs_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Oonita Dzosepe nese parara eeteqi te bai hiibaranihe Soopara hiiretaho isakita ata pobi nomeke aimata. ");
INSERT INTO ghs_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Aimaqi te noke dzaga kotoro meeraranihe kebanoke Maria khata oke dzoomami Dzosepe noho dzapake Dzesuiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Oonita Herotei ttokaho soopara qaata bodzata Dzesu khata biranateta. Oi Maria ma Dzosepe Garirea haba qaateqi Dzutea habata tuumaqi nagapa khooba Betterehemuta oomi Dzesu Khatai biranateta. Biranatemi idze, ete peitoraiho haba neta kaaba ma basara abi nokanokanoma qesai nagapa nokome qaateqi nagapa qiba Dzerusaremuta baaqi erake hiireta, ");
INSERT INTO ghs_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Maga, nana moomi Dzuta abiho totaqita taama teei paana naate hee, Dzuta abiho abi qiba minanipamu biranate ooraiqi hiirorai. Oonita nanai noho torota pomai kootoroqa hasama gegema hiibareiqi baabe. Noio kaqa? ");
INSERT INTO ghs_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Oke noko hiiremi Herotema Dzerusaremu abi mimi gama nookaqi roqobeteta. ");
INSERT INTO ghs_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Oho quba Herotei Dzuta abiho dzube abi ma qetaqeta abi mimike ao ttuttuiteqi nokoke qasa hiireta, Nikeho sinabidzai hee, Kiristui biranatakoiqi hiireta oi ikata oorai? ");
INSERT INTO ghs_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Hiimi nokoi hee, Noi Dzutea habaho nagapa Betterehemuta biranatakoiqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Oi teeho quba bahe Ohongaho too abi Mika noi geeta qeeteta oi hee, Qate Dzutea habaho nagapa Betterehemu niiho neta abi teei biranateqa Isirae Abi tupu nahoke soopara eetorakoita Dzuta abi mimiho neseta nagapa Betterehemu niiho dzapa pobi peitakoiqi hiirorai oiqi nokoi Heroteke pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hiiremi Herotei kaaba ma basara abike qaheburoqi korabete qasa hiireta, Maqa taama nohoi bodza apenipamuta biranatemi nike moota? Hiimi nokoi oho bodza paanaiteta. ");
INSERT INTO ghs_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Paanaitemi Herotei nokoke Betterehemuta dzoobireqi hiireta, Oionita nike ota tuumaqa khata oho qirike eetare. Qiri eete saridze khooba nohoke gama moo nooka soubireqa baa noho isereke naho torota mootomake ana paha namae tuuma noho torota pomai kootobare. ");
INSERT INTO ghs_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Hiiremi nokoi abi qiba oho noo nookaqi tuumata. Tuusuhimi taama nokoi bosata ete peitoraiho habata moota oi paha nokoho quba paana naateqi khata oota tekake paanaite mumure naate qoorota. ");
INSERT INTO ghs_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Oonita noko paha taama oke mooqi qaki ma naki minake eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nokoi naga ota peiteqi moomi khata noi pai nome Mariama oomi nokoi pomai kotoroqi noho hasa hiireta. Hiireqi nokoi quba bagenoma ttuma minanomake asi nokometa sisibeteqi noke dzou eeteta oi goori ma ura moromoronoma oke parakiseni hiirorai ma paha maraseni bagenoma dzapa noho miro oke gama noke moiteta. ");
INSERT INTO ghs_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Oonihe Ohongai bakuta nokoke Heroteho qaga hiiremi nokoi te Heroteho torota isere mootareiqi tuumaranihe tete mainata tuumaqi nagapa nokometa biranateta. ");
INSERT INTO ghs_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Oke eetemi Ohongaho angeroi bakuta Dzosepeho torota biranateqi hiireta, Herotei Khata oke teetareiqi qiri eetakoita nii Khatake paima gama aima atti tuuma Aigitta habata oorare. Ota ooma ana hiiremake nike paha burisi eetare. ");
INSERT INTO ghs_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Oiqi hiiremi Dzosepe noi ao qupibake qoridzeqi paima khata aimaqi atti tuuma qaaramuti Aigitta habata biranate ota oota. ");
INSERT INTO ghs_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","19","Oonita Herotei moomi kaaba ma basaraho abi mimi nokoi noke ikobeteqi Betterehemuta burisi eete noho torota oho isere mootaama naatemi noho dzauba peiteta. Peitemi noi qupa nometa hee, Eto abi khata oi bitotoqa naho teka karabetaino hiireqi kaaba ma basara abiho torota taama oi bosata biranatetaho bodza qupadzomaqi noi qaa abike Betterehemuho haba totaqita dzoobiremi nokoi khameto tii uani ma tii tuho isaki oho robena oota nokoke gama teetemi baateta. Oi teeho bahe quba oi biranatarotaho qamodzamodzai too abi Dzeremiaho qetaqetata biranateqi eraiqi hiireta, Isiraeho neemi pai Rakhere noi nese tuuta eemane khameto nomeho quba tti ma ttaka minake hiiremi oho totoho samane biranatemi noke ttapuitaquho isakiama naatokoi oi nokoi ao bamu naateta. Oiqi hiireta oi ooqata meenoma naateta. Oke eetemi Herote noomae heme minake saridzeqi baateta. ");
INSERT INTO ghs_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","21","Herotei baatemi Ohonga Sooparaho angeroi Aigitta habata biranateqi bakuta Dzosepe pobi hiireta, Nookare. Herote ma qesai khata oke teetareiqi qaa samaneke eete qaabi nokomae ao baatetanita poiqa nii qoridzeqa paima khata oke dzeima paha Isirae habata tuumare. Oiqi hiiremi Dzosepe qoridzeqi pai ma khata oke aimaqi Isirae habata tuumata. Oonihe nokoi Aigitta habata tta eetetaho khooba erani. Ohongaho too abi Hoseaho qetaqetai hee, Khata name, ana niike Aigitta habata dzeimami baataiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Qate Dzosepe pai ma khata teteta dzeima baahuqi nookami Heroteho khata Arekherau noi mai nomeho poro qereta peite oomi Dzosepe oho attike eeteta. Atti eeteqi bakuta tete saridzeqi noi Dzuta haba riiteqi qee Garirea habata biranateta. ");
INSERT INTO ghs_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Oonita noi nagapa Nadzarette ota qopa koobireta. Oonihe oi paha khoobanoma. Oi bosata Dzeseai hee, Noi Nadzaretteho isaki oi Tabitiho mai Dzese, noho biidza ma suuna oonita khata noke hee, Nadzaretteho nenaniqi hiibakoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Oionita kebanoqake Dzohane sobasobanai Dzutea haba habanata biranateqi sinabidza hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Hee, Ohongaho pobi ao biranasubita nike qupa burisi eetare. ");
INSERT INTO ghs_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Oiqi hiireta oi teeho bahe too abi Dzesea hiiretaho isaki keke. Noi hiireta, Haba habanata totoho teei sokateqi hee, Ohonga Soopara baaoraita noho quba roibeteqa tete nikeme pobitare. Oiqi hiiretai Dzohanehota meenoma naateta. ");
INSERT INTO ghs_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Qate Dzohaneho isaki eranoma: Kamere suuho sasake ootomi noi dzaaroqi oke hoo sasa siihuma qahitoto suuto qaata. Ma guuru ma here obake noi muunaqi patta qesaho hutingi naate qaata. ");
INSERT INTO ghs_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","6","Oonita Dzohanei sinabidza hiiremi abi Dzotani oba totaqi ma totaqina qaata ma Dzerusaremu abi ma Dzutea haba minarahota abi samanei noho torota ttutturateta. tutturateqi kahosa nokome hiire paanaitemi noi nokoke Dzotani obama sooro qaata. ");
INSERT INTO ghs_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Qate Pariseo ma Satukeo nokohota qesai baaqi quba oke mooqota. Mooqomi Dzohanei nokoke qeraqera eeteqi hiireta, Ohongai kahosa abiho ipi ma ari moitakoimi qesai oho attike eeteqi kahosaho dzamudzamu saridzorai. Qate dzohomaho khameto nikei ikabetaqu? ");
INSERT INTO ghs_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","9","Eto nike sama gimutta eeteqi hee, Baamu, nanai Abarahamuho biidza ma suunanita isanatoraiqa hiibaino. Dzare nohoke hee biidza qubake Ohonga oma erana oorai nokoke eehahaitemi isaki hee baabakoihe bamu. Nike mekeqoma qupa burisi eetemi oho mee paana naatemake ooqata isanatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Oi erake eete oorai. Boseke ao ee khoobata upubiremi mee qidzanomake ingonaitakoihe ttike ma pareke dzootomi eepaho pobi naatakoita nookare. ");
INSERT INTO ghs_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Qate qesa ma nikei qupa burisi eetemi anai nikeke obaqama soororai. Oonihe abi mina teei naho tumena baaorai isaki nohoi nahoke riitanipamuke eetemi anai oko sasa nohoke suutare beubeu eetorai. Noi isaki apema nikeke soobaqu bahe Qaheuba Sumasama soobakoi, eepama soobakoi. ");
INSERT INTO ghs_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Noi gottara meeke asinaiteqa quhisake sarautoqa eepa tatangata biidzareiqi oho baqebaqema baaorai. Oiqi Dzohane hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Oke Dzohane hiire qaami Dzesui qeemaqi Dzohaneho botota sobasoba oke saridzareiqi Dzotani obata biranateta. ");
INSERT INTO ghs_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Biranatemi noi oho bai hiireqi hee, Baamu, nii isaki niimema anake soobareni qate ikabeteqi nii naho botota oba sobasoba saridzaqu? ");
INSERT INTO ghs_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Hiiremi Dzesui noke pobi hiireta, Oi meenihe isaki qidza nime eetorai oke ana qaupuitareiqi baahubita noo oke qaato. Hiiremi noi nipanateqi noke obama soorota. ");
INSERT INTO ghs_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sooromi Dzesui igasata peqihimi Dzohane moomi qusu papatemi qusubibi quratoraiho isakita Qaheuba Sumasai Dzesuho irita gaibaqi mai eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mai eesuhimi qusu neta totoho teei biranateqi hiireta, Eraio qeseba khata nahonita ana noho nookami bagenomanipamu ooniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","2","Oke eetemi Sumasai Dzesuke qooro teetemi noi haba habanata Iibadzaho toronake saridzareiqi tuumata. Noi qupi 40-ho isakiqata hutingi naate qaami noho ttidza saa eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ttidza saa eetemi ikoikoho maikhata baaqi noke pobi hiireta, Oo nii Ohongaho khatani kaqa nii hiiremi oma khameto erana oorai nokoi hiiburoqa dzobadzoba naatemi khooba paana naatare. ");
INSERT INTO ghs_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Hiiremi noi kaitomaqi hee, Baamu, noo erake qeetemi oorai, Abi eto ttokaho pattaqake muunainohe Ohongaho toota quratorai noo oke gama muuna qaarareiqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Hiiremi iibadzai noke dzeimaqi Qaheuba nagapaho biiri oho ttittirata mootoqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Hee Ohongaho noota noorake qeetemi oorai, Omai khata niiho oko qettaitaino hiireqi Ohonga mai angero nomeke pobi hiiremi nokoi niike basidzomakoiqi hiiroraita nii meenipamu Ohongaho khata ooraiqako kautu eetemi oho mee paana naatare. ");
INSERT INTO ghs_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Hiiremi Dzesui hee, Oonihe qetaqeta paha teei erake hiiremi oorai, Nii etoqa Ohonga Soopara niimeke torona minake eetaino. ");
INSERT INTO ghs_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ooqi hiiremi Iibadzai paha poma maina teeke qupadzomaqi noke dzeima tora kaka minata peiteqi ttoka ma haba samane qidza dzapa pobinoma oke gama Dzesuke banaiteta. ");
INSERT INTO ghs_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Banaiteqi noke pobi hiireta, Quba oke ana gama nii moite soubidzakoi oonihe bosata nii naho torota pomai kotoro hasa hiiremake moitakoi. ");
INSERT INTO ghs_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Oke hiiremi Dzesu hee, Ae Saata nii papatare! Qaheuba qetaqetai eraiqi hiirorai, Ohonga Soopara niimeho torota pomai kotoroqa noqaho kokora eetorare. ");
INSERT INTO ghs_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Noi totoho oonomata hiiremi oionita Iibadzai noke papateta. Papatemi Ohongaho angeroi qeemaqi Dzesuke kokora qidzake eetota. ");
INSERT INTO ghs_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Qateqa Herotei Dzohaneke sutasutata moototaho pobike Dzesu nookaqi noi burisi eete Garirea habata tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Oonihe noi nagapa khooba Nadzarette qaateqi ato Dzeeburo ma Napattariho totaqi oba ttu robena oorai nagapa Kapanao ota biranateqi oota. ");
INSERT INTO ghs_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Oke eetemi too abi Dzesea noo teeke agobake hiire qeeteta oi meenoma naateta. ");
INSERT INTO ghs_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Qetaqeta oi hee, O Dzeeburo ma Napattari Dzotani obaho robe oi oba ttuho samaqata oorai abi samane nike Garirea habaho nenanita nookare. ");
INSERT INTO ghs_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nike baataho tupidzaho kha qupita habese baa qaariti poiqake moorare. Dzadza minanipamu teei nikeho bisata biranate nikeke baibuzakoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Oonita Dzesui ota sohoroqi sinabidza hiireqi eraiqi hiireta, Ohonga qusunai pobi nomeke gama mai eetare eesubita nike ao qupa burisi eetare. Oiqi hiire qeemata. ");
INSERT INTO ghs_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Bodza teeta Dzesui Garirea oba ttuta sosomaqi abi eserike moota. Nane noi Siimo, noke Dzesu ipita Peetoroiqi hiireta, qate noma nohoio Attereo. Nopoi khaa apiapi ooqi dzupu nokomeke abata biirota. ");
INSERT INTO ghs_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Biiromi Dzesu nopoke pobi hiireta, Nipe baa anama tuumami ana nipeke banaitemi khaa bahe abi apiapi naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Hiiremi ao nopoi dzupu nopomeke qaateqi noma tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Oonita nokoi qeehiqi paha abi eserike moomi nopoi oho qesa kha apiapi ooqi sisimata dzupu nopomeke usari eetota. Naneho dzapa Dzakoponi qate nomaio Dzohane, nopoi mai nopome Dzebetteoma noko baura oke eetomi Dzesui nopoho kira hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kira hiiremi iiha ma dzoobidzaamake nopoi mai ma sisima ma quba oke gama pekha eete Dzesuma nokoi tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tuumaqi Dzesui Garirea habaho nagapa samaneke ogama tuumaqi sinabidza guhu nokohota peite Ohongaho pobi ma baura qidza oke abi banaiteqi heme ma porobanomake gama qidzaite soubireta. ");
INSERT INTO ghs_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Oke eetemi Siria habana oota nokoi oho pobi nookaqi heme ma bame, khettedza maina paina, ruume ma potutu, gisi ma songenanoma, sarosaronoma ma kara, nokoke gama ttuttuiteqi noho torota dzeima baami noi noko qidzaite soubireta. ");
INSERT INTO ghs_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Oonita noi baura samane oke eete tuumami Garirea abi keke bahe nagapa qiba tteni oho nena ma Dzotani oba totaqi nena ma Dzerusaremu ma Dzutea haba nena abi quba mina noke iihata. ");
INSERT INTO ghs_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Oonita Dzesui moomi abi huba haba biiremi noi tora peiteqi habeseta. Habese ooqi abi qesai noho tumakhameto naatareiqi noi nokoho kira hiiremi nokoi noho torota ttutturateta. ");
INSERT INTO ghs_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ttutturatemi noi nokoke bapotopotareiqi too saqorota. ");
INSERT INTO ghs_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Dzesui hee, abi qupa gaibanomai ao qusuho pobi mai eetaridzonita oi nokoho paramu oni. ");
INSERT INTO ghs_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Qate ipita qaki ma nakinoma naatakoiqi qesai ttottokaho sururu potti biidzaama nokoho isaki bagenoma. ");
INSERT INTO ghs_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ma qesai sama pati nokomeke qohataama naatorai nokoke qepe ma haba gama moite soubidzakoita nokoio bagenoma. ");
INSERT INTO ghs_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Oi apenei minaraho qupaqupake eeteqi nokoho isaki iso keke biranatare hiireqi dzaodzaoma baura eetorai nokomaeho isaki oho qesa isanatakoita oi bagenoma. ");
INSERT INTO ghs_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Qate baruna heenanomaho isaki oi paha qidza, nokoi oho qesa baruna heenata quba saridzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Qate qupa ikoikoamai Ohongake saridze qidzanatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ma hasuho maimane nokoho dzapake hee, Ohongaho qesamaneniqi hiibakoi oi dzapanomani. ");
INSERT INTO ghs_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Qate abi tete qidza rike ma pobita tuumami qesai nokoke bisi naate sesero eetemi nokoi qusuho pobi mai eetakoita oi paha bagenoma. ");
INSERT INTO ghs_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Qateqa nike naho quba baura qidza eetemi qesai nike qanga hiireqi qomadzubobireqa sesero samane eetemi isaki nikehoi qidzanatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Oi teeho quba bahe nikeho ipi ma ari qusuta biranataqu oi meupu minanipamu. Oi qesai too abi ma karake teete qaami nokoho ipi ma ari mina, nikeho isaki oonomanita oho qaki ma naki minanipamuke eetare. ");
INSERT INTO ghs_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Maqoe, nike ttokata baura qidza eetemi oi tomuho meke oho isaki naatakoi. Oonihe tomuho meke bamu naatemi quba apema paha mekeitemi isanataqu? Oi bamuhe oke sasata biiremi abi oke qooro teetakoita eto nikeho meke oho isaki naataino. ");
INSERT INTO ghs_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Paha nike ttokata ooraiqi dzadzaho isakita abike baiburorai. Oonita meusu nagapa dzadza samanenomai tora kaka paata oomi oke dzukubaquho isaki ooraamanita oho tete qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ma paha abi teei dzongi qeereqa oke bamu qapuma saabaquhe qohareta mootomi oi naga oona oorai nokoke gama baibudzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tete oke qupadzomaqi dzadza nikemeke eto abike qaanatainohe baura qidza samane nokoho quba eetemi nokoi mooqa Ohonga mai nikeho qusuna oorai noho hasama gegema hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","19","Nookare. Hu noo ma too abi ttarita noo hiire baa qaabi oke ana teqaha siginaitare baaoraidzara. Oonita eto oke qupadzomaino. Oi abi teei oho poma teeke ai siginaiteqa abike hee, Eto noo oke qusubaitainoiqi hiibaquko qusuta dzapa noho (Saatahoi) taatakoi. Qate teei poma oke gama iso keke qusubaiteqa abike oho suhe gama banaite soubidzaqu dzapa nohoke qusuta qusubaitemi minanipamu naatakoi. Abi oi ape bahe ana eka namema oke gama teenaite suutomake isaki nikehoi eehaha naatakoi. Korabete nooho qetaqetata gigini mae gohata noo teeqai baamu bamu naataquhe oke ana gama eka namema sipitotomi nikeke ingonaitaquho isaki biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Oi Pariseo ma qetaqeta abi isaki eetorai oi isanataamanita nike naho rike ma pobi saridzoraiho isaki oi isaki nokohoke riitorai. Riitaama naatapuko nike bamu qusuho pobita dzuubarori, baamunipamu, oke ana bamu nike dzaheitaqu. ");
INSERT INTO ghs_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","22","Oi erake eete oorai. Agobake nikeho uimane neimane totoho erake hiire qaata. Nii eto abike teete baataino. Teete baataquko nii maripa abiho pobi naatakoi, Ooiqi hiire qaatahe anaho tetei hee, Teei nomani mae nane nomeho ibo eetaquko noio ao maripa abiho pobi naatakoi. Qate teei qesa nomeke hee, Abi quseriponiqi hiibaquko oi maripa maimane nokoho pobi naataridzoni. Ma teei temu nomeho nookami susu ma sasaho isaki naataquko eepa gabi oi ao noke dzoobaridzoni. ");
INSERT INTO ghs_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Oho qubake nii Ohongaho quba kiridza teeke aima baahuma niiho qupai niike iga hiireqi hee, Maqa, teei niiho kahosa eete ooraiqa hiibaquko kiridza oke sigita mootoqa bosata tuuma temu niimema noo oke pobite isanatemake oionita nii burisi eete baa kiridza niimeke Ohongake moitemi isanatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Qate teei niiho oma kahosa eete ooraquko nii hairiamake noke ttapuite hasu hiibare. Oke eetaama naatemi eto noi niike qohareta mootomi maripa abi niike qomaqoma hiire pirittaniho botota mootomi nii sutasutata biranataino. ");
INSERT INTO ghs_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ota nii bamu gisake saqosaqo naataquhe ota qaaqa oho ttuma gama biire soubireqanoke bodza apeta biranataqu? ");
INSERT INTO ghs_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Qateqa agobake uimane neimanei hee, Nii eto apuata eetaino. ");
INSERT INTO ghs_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Oiqi hiire qaatahe anaho tetei eraiqi nike pobi hiire. Teei qupa nometa atapa teeho dza ma rumuba eetaquko ooqata ao pasenaho isaki naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","30","Oonita nookare. Nii dza ma rumuba niimema gama tuumaqa eepaho kabira naataquko bamu isanataqu. Oonita quba apei niiho angi naatorai, oi neseni mae botoni mae naane ma naane, oke nii ao kuibireqa oho dzore naate qaraqaraho pobita qeemaquko oio isanatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Dzesui hee, Qate agobake Mose ma karaho totoho teei eraiqi hiiremi nooka qaata, teei ata nomeke qaatareiqa noho quba gee tatanga saridzeqake moitemi noi tuumakoi. ");
INSERT INTO ghs_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Oiqi hiire qaatahe teeho atai abi mainama qesa guume eetaamake oomi apui ata usaqe teeke aimareiqa sepeke ata bosabosake gaubireqi gee oke saridzaquko oke eesuqa ata oke pasenaho teteta dzoobidzakoi, oi teeho bahe ata qaateta atapa oke abi siginai nookami pasenaho pobi oonita qidzoke pasenaamake noke aimaqu. ");
INSERT INTO ghs_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Dzesui hee, Qateqa agobake abi mimike hee, Nii noo niimeke abi teeho quba tatangaitareiqi hee, Ohongaho pengata hiibiqi hiibaquko noo oke nike eto saparaitaino. Oi nike Ohongaho dzapata hiiremi tatanga naate qaarakoita eto oke paha geemaino. ");
INSERT INTO ghs_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Oiqi hiire qaatahe nii noo niimeke tee ma teeta mooto tatangaitaqu oi gama oberani. Erake eete oorai. Poro qere qusuna oorai oi Ohongahonita oho qaga oorai. ");
INSERT INTO ghs_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Qate ttokata mooto hiibaqu oi paha qaganoma oi teeho bahe ttokaio paha Ohongaho qobaqobani. ");
INSERT INTO ghs_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Dzerusaremui oho qesa abi qiba qusunaho meusu nagapanita oho qaga oorai. Oi paha nii qiba niimeta mootoqi hiibaquko oi paha bamu isanataqu oi nii Ohonga apei hiiremi qiba gee gabara biranataqu mae bamu? ");
INSERT INTO ghs_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nookao. Nii noo teeke mee hiibareiqa oke hee, Oore ooqake keke hiireqa eto paha tee ma teeta mootoqi ipibidzaino. Qate nii noo teeke bai hiibareiqa oke hee, Baamu ooqake hiibareni qate oke quba tee ma teeta ipibire mootomi obera naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","39","Dzesui hee, Agobake hu noota erake hiire qaata, Teei temuho neseni mae tooke bikoumaquko noomaeho neseni mae tooke oho isakita bikoumaridzoniqi hiire qaata. Oonihe anai nike noorake hiiremi nookare. Teei nike sesero eetemi eto too pasereke qupadzomaino. Oi teei niike ngibasa totaqita teetaquko eto oke nookami qanganatainohe totaqi temuke noke bobotare oi teteni. ");
INSERT INTO ghs_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Qate teei niike qohareta mootare hiireqi oho habarake sasa qidza niihoho quba hiiremi eto oho baike hiibainohe paha ttoba ma sasa niime teeke oho tongo neta noke moitare. ");
INSERT INTO ghs_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Qate kiapeni mae soopara apei hee, Nii quruma nahoke aima isakiqata tuuma ota mootareiqi hiiremi eto bai hiibainohe noi hiibaquho isaki keke bahe oke kharaite qee neta mootaqu oio tete qidzani. Qate teei niiho torota quba teeke aimareiqi hiibaquko eto qaanatainohe moitare. ");
INSERT INTO ghs_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ma teei hee, Maqoe nii isaki niimeke poiqa ana moitemi iihaike ana oke burisi eetakoiqa hiibaquko eto oho basesa eetaino. ");
INSERT INTO ghs_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Hiireqi Dzesui hee, Oioni qate nike nookami agobake hee, Dzaira niimeho kokora eetareni qate iboke bisi naatareiqi hiire baaorai. ");
INSERT INTO ghs_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Oonihe ibo abi nikeke bisi naate sesero eetemi nokoho quba pupu hiireqake nokoke kokora qidza eetare tete oke ana nikeho quba paanaisubi. ");
INSERT INTO ghs_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tete oke nike qusubaiteqa qusu mai nikemeho khameto meenipamu naatakoi. Oi teeho bahe Ohonga noomae hiiremi quuni mae ete dzadzai abi qidza ma qanga iso keke hoobirorai. ");
INSERT INTO ghs_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pisinisi abi ma kara nokoi qesamane nokomeqake hoobiroraiho pomake nike qusubaitaquko oi quba sepeho isaki naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ma raaba abi nokoi gemu teena nokomeke mooqi Dzoobe hiiroraihe qesake moo nipanatorai. Oonita nike poma oonomaqake qusubaitemi apei nikeho hasa hiibaqu, baamu. ");
INSERT INTO ghs_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nookao Ohonga mai nikehoi qidza qoredzaamanita nikemae oho isaki naatare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Dzesui ipibireqi hee, Maqa nike kokora baura qidza eetareiqa oke eto abiho nese ma penga quba eetainohe Ohonga mohimohi maikhataho quba eetemi noi oho ipi ma ari moitakoi. Qate eto abiho penga quba eetemi sapara naataino. ");
INSERT INTO ghs_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Oi ikoiko abi qesai dzapa pobinoma naatare hiireqi guhu ma otoba patita sama kano noo hiirorai. Nokoi eetoraiho puturu ma tauba bamu, oke ana ao nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Oonita nike abiho tteki eetareiqa oke seike eetare. Eetomi eto garenai oho nooke nookaino. ");
INSERT INTO ghs_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Seike eetemi Ohonga mohimohi maikhata noomae oho ipi ma ari moitakoi. ");
INSERT INTO ghs_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Hiireqi Dzesui hee, Ma pupuho tete paha oke eete oorai. Oi ikoiko abi qesai abiho nese ma penga quba eeteqi sinabidza guhuni mae sobadzani mae ika ma ikata sama kano eete qooroqi pupu samaneke hiiroraihe oho puturu ma tauba baamuta eto nike poma oke gesina naataino. ");
INSERT INTO ghs_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nooka. Nii pupu hiibareiqa suruho niimeta peite tete siireqa seike Ohonga maiho torota pupu hiibare. Hiiremi mai dzukudzukuta mooqi noo oho mee saridze bamu qaanataqu. ");
INSERT INTO ghs_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","8","Oonihe raaba abi hee, Totoho samaneta pupubetemi meenoma naatakoiqi hiiroraihe, oi khurotou peutounomaho isaki naatoraita nike oho tomidza naataino. Totoho oi oberanita nike pupu meeqake hiibare. Oi nike quba teeho dzore naate pupu hiibamake Ohongai qupadzomoraita nike pupu hiima ao moitakoi. ");
INSERT INTO ghs_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Oho qubake nike totoho eranomata pupu hiibare: ");
INSERT INTO ghs_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Qusu Mai naname, Niiho dzapa qaheubata oorare, Niiho pobi biranatare, Niiho qusubaita qusuta ooraiho isaki ttokata biranatare. ");
INSERT INTO ghs_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nii nanaho patta saninoke moitorare, ma nanaho kahosa qaatare. ");
INSERT INTO ghs_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nanai oho qesa kahosa abi nanamehoke qaatorai. ");
INSERT INTO ghs_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma toronata nanake mootaino, oonihe qangata nanake qagamare. (Beedzae ma tatanga ma pobi oi gama niihoi kekenita agoba qaaraqara qaarakoi. Oore.) ");
INSERT INTO ghs_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Oi erake eete oorai, Abi nikeke kahosa eetemi gaubidzaquko qusu Mai nikehoi oho qesa kahosa nikehoke gaubidzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Oonihe nike kahosa qesahoke gaubidzaama naataquko qusu Mai nikehoi oho qesa bamu kahosa nikehoke gaubidzaqu. ");
INSERT INTO ghs_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","18","Dzesui hee, Qate nike Ohongaho pengata patta ma quba qesaho hutingi naatareiqa nese ma penga nikeme akobeteqa poro bibake pengata suraitemi abi mooqi bamu hutingi nikehoke qupadzomaquhe, Ohonga noomae dzukudzukuta moorakoi. Mooqa oho ipi ma ari nike moitemi ota paana naatakoi. Oi teeho quba bahe ikoiko abi qesai te Ohongake qupadzomaqi eetoraidzaranihe abiho penga qubake hutingiho birabira naateqi kuu ma pebama tuumorai. Oonihe nokoho ipi ma ari ooqai oonita nike eto nokoke kimatetaino. ");
INSERT INTO ghs_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Dzesui hee, Ttokata abi qesai ttuma ma quruma hohoitemi arinatorai, ttidza sakaborai, guume abi qeemaqi karabetorai. Oke eetemi oho mee kaqa? Oonita nike eto oonomaho kabira naataino. ");
INSERT INTO ghs_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Qate nikei sinabidzaho totaqike qupadzomaqi qusuho quruma oonomake ttuttuitemi ikanomake eete ttidza sakabaqu, mae arinataqu, mae guume abi karabetaqu? ");
INSERT INTO ghs_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Baamuta erake qupadzomare. Qupa niihoi ikata oorai, oio niiho ttuma ma qurumaho isaki oni. ");
INSERT INTO ghs_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Hiireqi Dzesu oke hee, Tete erake eete oorai. Nese ikata tuumorai oi qupaho khooba paanaitorai. Oonita nese niihoi abiho bameko mooraquko nii ao baruna heena naatemi niiho oora ma qaarai dzadza keke naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Qate nii qoredza nese sigire eetaquko oora ma qaara niihoi qupi soobakoi. Oonita niiho dzadza ma adzahaha ooraroriho habarake qupi sooromi niihota bamenomanipamu naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Oohoke Dzesui hee, Oonita abi teei maimane eseriho baura eetoraquho tete bamu. Temuho dzake eete kokora eetakoini qate temuho ngiingi eetakoi. Oonita nike Ohongaho qaru ma ttumaho qaru esese eetaquho tete baamu, oke eto ruume naataino. ");
INSERT INTO ghs_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Tete oke eete ooraita ana eraiqi nike pobi hiire. Oba ma patta apeke muunaqu ma ttoba ma sasa apeke eetaqu nike ooqaho iiha ma dzoobidzake eetemi oora ma qaara nikehoi oho quba qidzanataqu mae? ");
INSERT INTO ghs_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Moorare, nee qusuna areumorai nokoi dzoo eetaama, iisu mootaama oi Ohonga noomae nokoho qupaqupa eeteqi patta moitorai. Oonita noi quba sepe nokoho quba eesuhiqa nikeke ruume naataqu mae? ");
INSERT INTO ghs_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Oi baamunipamu. Nikehota teei isanate Ohongaho habara naate isaki nomeke minaitaqu mae? ");
INSERT INTO ghs_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Oho tete ooraamanita naane quba qepe ma haba nikemeho iiha ma dzoobidza samane samaneke eetaqu? Nike moorare. Sihidza bagenoma soobadzana oorai nokoi dzoo ma patta eetaama, asi ma haba ootaamanihe ao bitoto bagenoma naatorai tete nokohoke qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Oonita Soromoho qaru abi samanenipamui noho kokora eeteqi noke ttoba ma sasa nee ma baunoma eete qaatahe, noi te sihidza hiibi oho isakita neema baunoma naate qaarara, baamu. ");
INSERT INTO ghs_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mooro, poiqa sihidza nokoi bageke eete soobadzata biranatoraihe nokoi quba sepe ooqi ihaike ao eepaho pobi naatakoi. Oonita bodza hoteqake Ohongai sihidzaho quba tete bagenoma biraitoraihe noi ai tataumaho tupu nikeho quba isaki saridzoraqu oi hoteqa bahe kharanipamu! Mae ai tatauma nikehoi bamu naatemi ana sepeke noo hiirorai? ");
INSERT INTO ghs_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Oho qubake eto eranomaho totohota hiibaino, Oba ma patta apeke muunaqu, ma ttoba ma sasa apeke eetaqu oiqi hiibaino. ");
INSERT INTO ghs_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Raaba abi nokoio totoho oonomata hiiroraini qate Ohonga mai qusuna noi teqaha nike ruume naatoraidzara. Quba oke noi nikeho quba gama saridzemi isanatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Oonita nike Ohongaho neta oora ma qaara rike ma pobi saridzareiqi beedzae eete qaama noomae oho totaqike nikeho quba saridzorakoi. ");
INSERT INTO ghs_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Oho quba baura poiqa niiho botona oorai oi niiho quba isanatoraita eto iihaiho iiha ma dzoobidzake oho tongo neta mootaino. Iihaiho quba samane oio iihaiho kekenita eto poiqa oho qupa muunaino. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Dzesui hiireqi hee, Nikei qesaho honga ma kahosa eetaama naatemi nokoi oho qesa bamu nikeho qomaqoma hiibaqu. ");
INSERT INTO ghs_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Oi nike tete apeta abiho isaki hiibaqu hiiremi oho isakita oho qesa nikemaeho irita biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Oho qubake niimaeho kahosai ee bittaku minaho isaki nese niihoke sirihami nii ikabeteqi kahosa gattiqa miriququho isaki teemu niimeho neseta mooqa pobitaqu? ");
INSERT INTO ghs_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Bittaku oi niiho nese sirihami nii bamu isanate temu niimeke hee, Nii qaatemi ana miriququ niiho nesena ooraike dzamutakoiqi hiiremi isanataqu. ");
INSERT INTO ghs_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ikoiko abi nii! Bosata nii kahosa nime, bittakuho isaki, oke ai siginaitemi nese niihoi qidzanatemake nii teemu niimeho kahosa gattiqa, miriququ nesena taatoraiho isakike bageke eete mooqa dzamutomi bamu obera naataqu. ");
INSERT INTO ghs_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Qateqa qaheuba noo mutusa qidza teei niiho qupata peitaquko oke eto ao paa qereqereho isakita oke pureke paanaitaino. Oi qesai hoo ma haaho isakita noo qidza oke aima bikhi bakha eeteqa burisi eete niike gaamami bamenoma naatakoita qupadzomare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Dzesui hee, nike tete qidzaho dzake eetorai mae? Oonita qasake hiiremi moitakoi. Qirike eete saridzakoi. Ma tuputupu teetemi tete geemakoi. ");
INSERT INTO ghs_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Oi abi qasa hiibaamake bamu saridzaqu, qiri eetaamake qidzoke saridzaqu ma tuputupu teetaama naatemi apei tete geemaqu? ");
INSERT INTO ghs_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Maimane nikehota teeho khatai qeemaqa maike hee, Maqa dzobadzoba teeke ana moito. Oiqi hiiremi mai ikobeteqi oma sepe teeke noke moitaqu, tete oke eete ooraidzara. ");
INSERT INTO ghs_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma noi khaa quba hiiremi nike dzotata qaanomake moitaqu oi paha bamu. ");
INSERT INTO ghs_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Oi abi nike te sepeke tete oonoma aimaama. Nike khameto nikeme quba qidza keke moitorainita nike qaheuba Mai qusuna oorai noke quba qidzaho qasake hiiremi noi bamu qaanataquhe moitakoi. ");
INSERT INTO ghs_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Oionita nookare, hu noo hiirorai ma too abi hiirorai oho noo qiba erake eete oorai. Nike dza eetemi abi nikeke ikanomake eetaqu oho isakita nikei isanate abiho kokora eetemi Ohonga ma minarahota dzapanoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Dzesui hee, Nookare. Rubenga saridzaquho tete mina samane ooraiho qubake abi paha samane ota oho kabira naatorai. Qate qidzanataquho tetei reresepe bahe takuranita abi teena teenai oke saridze qidzanatoraiho qubake nikemae beedzae eete ota dzuubare. ");
INSERT INTO ghs_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Dzesui paha hee, Qateqa too abi obera qesai hoo keba ma dzapaho isakita nikeho bisata seiqake qeemakoihe meeke nokoi haa teeko qaanamanita nokoho bakena geemorare. ");
INSERT INTO ghs_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Oi nike mee nokohoke moo pobiteqa khooba ao qupadzomaridzoni. Oi teeho bahe tooneneta bamu qasipu saridze muunaqu, ma bamu sikakata togora mee saridze muunaqu. ");
INSERT INTO ghs_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ee ma eka mee qidzanomata rumuto muunakoini qate ee ma eka mee togonomata bamu rumuto muuna qidzanataqu. ");
INSERT INTO ghs_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ma nokoi qesaho habara naate mee goomaquho tete bamu. ");
INSERT INTO ghs_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Oi pare ma mee qanganomake bamu ingonaitaquhe ao geemami eepaho pobi naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Qahura oke qupadzomaqi too abi oberaho khooba mooqa ao nokoke kuibidzare. ");
INSERT INTO ghs_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Oi qesai too kakama naho dzapake hiireqi hee, O Ohonga Soopara oiqi hiiroraihe nokoi Ohonga qusunaho pobita dzuubaquho tete bamu. Qate qusu Maiho dzake qusubaitorai nokoqai dzuubakoi. ");
INSERT INTO ghs_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nooka. Ipita qesa samanei naho torota biranateqa hee, O Ohonga Soopara naname, nanai dzapa niihoho quba eeteqi sinabidza hiire qaata, songena iiha qaata ma dzapa niihota obaoba bagenoma samaneke eete qaata oke nii ruume naate mae? ");
INSERT INTO ghs_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Oke hiiremi anai erake noko pobi hiibakoi. Ae, ana nike ruume. Nike koiri kairinomanita papatare. Oiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Oiqi hiireqi Dzesui hee, Ana hiirorai noo oke apene nooka qusubaitaqu nokoke ana isaki apeta mootomi isanataqu bahe gesina abi teei naga nomeke poubosa tatangata goototaho isaki. ");
INSERT INTO ghs_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Oi uta tooromi quu mina taatemi oba soorotanihe naga oi te oho quba peperatara te uubara. Nokanoka abi nokoi oho isaki. ");
INSERT INTO ghs_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Qate naho noo tomama nookaqi qusubaitaama naatorai nokoi eraho isaki. Abi quseripoi naga nomeke igasa pepeta gootomi uta tooromi quu mina taatemi oba soorota. ");
INSERT INTO ghs_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sooromi naga oi ao peperate uuba ngausa naateta. Nokoio oho isaki oonita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Dzesui noo bamenoma samaneke hiire qaami abi tupu nookami too baunoma naatemi nokoi roqobeta minake eeteta. Nokoi hee, Idze sinasina eranomake qetaqeta abi ma kara ruumeniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Oionita Dzesui sinasina noo hiire bamuiteqi tora neta quratemi abi tupu mina oi gama noke iihaqi baata. ");
INSERT INTO ghs_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Qate abi pottomunoma teei baaqi noho dzagata pomai kotoroqi hiireta, Soopara name, Niiho beedzae ooraita niiho dza hiiremi nii isanate anake qidzaitaqu mae? ");
INSERT INTO ghs_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Hiiremi Dzesui boto dzoobire noke hesateqi hiireta, Isanate naho dza oke eete ooraita nii qidzanatare. Hiimi pottomu nohoi ao hairiamake agimata. ");
INSERT INTO ghs_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Agimami Dzesu noke pobi hiireta, Eto sepeke abi pobi hiibainohe nii tuuma sama niimeke dzube abi banaitemi noi mee hiiremake Moseho noota hiiremi ooraiho isakita nii oho kiridza qeeremi abi minarai mumure oke moo qupadzomakoi. ");
INSERT INTO ghs_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Hiireqi Dzesui Nagapa Kapanaota peihimi Romaho Qaa pobipobi noho torota biranateqi qasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Hee, Soopara name khata nahoi nagata pone ma qeqesa naate heme minake eete oorai. ");
INSERT INTO ghs_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Hiiremi Dzesu hee, Isanate ana qeemaqi noke qidzaitakoi. ");
INSERT INTO ghs_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Oke hiiremi Qaa pobipobi noo ipi eranomake hiireta, Soopara name nookare, nii qaheuba abi minanita nii naho nagata peita qubake ana midza eete, oonihe ana tete erake qupadzome. Ana naamae qaa pobipobi oonita anai abi teeho quba hiibaquni mae teeke qaru dzoobidzaquni mae kokora abi nameke baura teeke moitaqu oke hiiremi nokoi bamu hairi eetaquhe ao eetakoi. Oonihe anai abi gattiqanihe nii minaho qubake tete oonoma paha niihota meupui oorai. Oonita nii noo teeqake erata hiiremi kharata naho khatai ao qidzanatakoi oke ana qupadzome. ");
INSERT INTO ghs_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Hiiremi Dzesu nooka sahateteqi burisi eete abi tupu nomeke pobi hiireta, Maqoe, ai tatauma abiraho torota minai oorai oho isakike ana Isirae abi nikeho bisata mooraamanipamu. ");
INSERT INTO ghs_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","12","Oonita nookare, Abarahamu ma Isaka ma Dzakopo ma karai qusu pobi mai eetakoi. Qate qesa ma nike nokoma gama ttaike mai eetororihe nooka hiisi eetaama naatemi nikeke hotou biidzakoi. Oke eetemi abi eranomaho qesa samanei ttoka tume ma dzagata baaqi ota dzuubaqi ttaike qusu pobi mai eetemi nike sasata ooma kha qupi nike sengibetemi nike too gaama kharikhariri hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Hiireqi Dzesu paha burisi eete qaa pobipobike hee, Nii ai tataumoraita nii hiireho isakita khatai ao qidzanate. Oionita niimae tuumare. Hiiremi tuumaqi moomi bodza ooqata khata ao qidzanate oota. ");
INSERT INTO ghs_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Oonita Dzesui Peetoroho hagata peiteta. Peite moohimi Peetoroho motami heme eetemi humamutu suqobiremi meeqota. ");
INSERT INTO ghs_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Oho qubake Dzesu qeemaqi noho boto hesatemi humamutui ao gaemami qidzanateta. Qidzanateqi noi qori nokoke kokora bagenoma eetota. ");
INSERT INTO ghs_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Qate surenake abi qesai songenanoma samaneke dzeima naga pati nohota mootomi Dzesui songena iihaqi hemenomake gama qidzaiteta. ");
INSERT INTO ghs_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Oi isaki ape bahe too abi Dzeseai baura nohoke agobake hee, Noi abi napaho heme ma bameke aimami bamu naatokoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Qate Dzesui moomi abi quba minai noke qahiqahi eetemi noi sisima abi Peetoro ma kara nokoke hee, Napai oba ttu totaqita qeemare. ");
INSERT INTO ghs_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hiiremi Hu nooho soopara teei baaqi eraiqi hiireta, Banaita name, Ana niike gainene eete nakamae tee ma teeta tuumareiqa tuumakoi. ");
INSERT INTO ghs_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Hiiremi Dzesui hee, Kabira ttokanai gama khakhanoma ma nee nokoi oho qesa ttaqanoma keke. Qate Abiho Isaki anai qepe ma qiba pouu baamuta nii ikaqi hiire? Oiqi hiiremi nipanateta. ");
INSERT INTO ghs_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nipanatemi tumakhameto noho teei Dzesuke hee. Soopara name, anai niima tuumare qupadzomoraihe, naho mai baasuhima ana noke qurabireqake niike iihakoi. ");
INSERT INTO ghs_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Hiiremi noi hee, Abi keba nokoio keba nokomeke qurabidzareni qate nii ao anama ttaike baurata tuumare. ");
INSERT INTO ghs_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Hiireqi Dzesui sisimata peitemi tumakhameto nokoi noke iiha peite noko totaqita qeemota. ");
INSERT INTO ghs_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Qeehiqi noi meeqota. Meeqomi idze, uta minai tooromi pouma horesa kotoroqi sisima nakuta qeemata. Nakuta qeemami attinoma naatemi nokoi Dzesu tukutoqi hee, Soopara, napa dzaetare boobita, hoobidzare! ");
INSERT INTO ghs_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Hiiremi noi hee, Nikeho ai tatauma bamu naatemi nike atti ququimaqi oke hiire mae? Hiireqi noi qori utake qamuni hiiremi obai ao kebarateta. ");
INSERT INTO ghs_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kebaratemi abi nokoi roqobeteqi hiireta, Iaqa, Abirai ikanomani? Noi uta qamuni hiiremi ao obai kebarate. ");
INSERT INTO ghs_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Oke hiire tuumaqi Gattere habata unateta. ");
INSERT INTO ghs_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Gattere habata unatemi abi songenanoma eseri Dzesuho torota biranateta. Oonihe abi samanei nopoho attike eeteqi haba oke girodzomaqi mainata tuuma qaata. ");
INSERT INTO ghs_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Abi nopoi Dzesuke mooqi hee, Oo, nii Ohongaho Khata. Oonihe bodza hiiremi ooraike nii naane quba riiteqi ao songena nanake sesero eetare baabe? ");
INSERT INTO ghs_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","31","Hiireqi nopoi moohimi hoo kitu minai sererahuke peku muusoqi oota. Oomi nopoi hee, Nii nanake hotou biidzareiqa isanate nanake dzoobiremi hoo kitu oho nakuta dzuubare. ");
INSERT INTO ghs_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Hiiremi Dzesui hee, Isanate ota dzuubare. Hiiremi songena nokoi nopoho neta tta eete hoo ota dzuubata. Dzuubami hoo kitu oi hairiamake torouma hapa rometa qurateqi obata dzaga susuma baateta. ");
INSERT INTO ghs_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","34","Oke eetemi hoo kitu oho soopara nokoi abi songenanoma eseri nopoho isere gama nagapa abi pobi hiireta. Hiiremi nokoi Dzesu moorare baata. Baaqi noke mooqi hee, Nii isanate nanake papatareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Hiiremi Dzesui burisi eete tumakhameto nomema sisimata peite obatu totaqita unateqi nagapa nome kapanaota biranateta. ");
INSERT INTO ghs_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Biranatemi qesai abi sarosaronoma teeke dzarimama aima Dzesuho torota baata. Baami Dzesui moohimi ai tatauma nokoho torota oomi noi sarosaronomake hee, Maqa, poike kahosa niihoke dzamutenita nii qupa qidzanatare. ");
INSERT INTO ghs_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Hiiremi qetaqeta abi oona oota nokoi barubaru hiireqi hee, Abirai ikaqi noo qaganoma oke hiire. ");
INSERT INTO ghs_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Hiiremi Dzesui ao iiha ma dzoobidza nokohoke qupadzomaqi hiireta, Maqoe, nike nookami ana noo bamenoma ma attinoma hiire mae? ");
INSERT INTO ghs_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Anai hee, Kahosa niihoke poiqa ana dzamute, oiqi hiiremi niketa bamenoma naate kaqa. Qate anai oho heeta noke paha hee, Nii qoriqa qooro tuumareiqa hiibaquko nikehota noo oi paha bamenoma attinoma naataquni mae? ");
INSERT INTO ghs_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nookao, Anaio Abiho Isaki oonita ttokata anai abiho kahosa dzamutaquho beedzae oorai oke nike moo nooka qupadzoma qubake poiqa anai meenipamu oke hiibakoi. Hiireqi noi abi sarosaronoma oke hee, Nii ao qori qepe niime qoomaqa nagapa tuumare. ");
INSERT INTO ghs_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hiiremi noi ao qoridzeqi qepe aimaqi nagapa tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tuumami abi tupu oona oota nokoi atti eeteqi Ohonga hasa hiireqi hee, Ohonga dzoobe, nii beedzae oonomake abiho neeta mootomi ooraiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Qate bodza teeta dzesui otoba patita ogamaqi moomi ttagetti qohareta abi teei habese baura eetota. Dzapa noho Matteo. Dzesui noho quba hiireqi hii, Nii ana iihare. Hiiremi noi ao adzahaha naate qori noke iiha tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Oonita ttageti apiapi ma kara oora ma qaara oberanoma nokoi pobi nookaqi abi ooho nagata ao peiteqi tumakhameto nohoma gama qidzanate patta muunata. ");
INSERT INTO ghs_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Muunami Pariseo qesai oke mooqi tumakhameto nohoke qasa hiireta, Banaita nikehoi ikaiqi hiireqi poma napame riiteqi abi qanga ttagetti apiapi ma kara nokoma ttaike patta muuhibi? ");
INSERT INTO ghs_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Hiiremi Dzesui oho totoho nookaqi noko pobi hiireta, Ttotai sama rikerikenoma bahe khettedzanomaho baurake eetoraiho teteke qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Oi Ohongaho qetaqeta teei erake hiiremi oorai, Abi samaqama anake tuuhorarai nokoho goottaeke ana eetoraihe meeke dzasaho teteke qaupuitaqu oho dza minake ana eetorai. Qetaqeta oho pomake nike gesina naataamake oorai kaqa. Oonita nookare, abi qesa ma nikei sama nikemehoke nookami rike ma pobinomanita anai te rikeho quba baura eetoraidzaranihe kahosa ma pasenanomake qidzaitorai. Ooiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Qate ipita Dzohane sobasobaho tumakhametoi Dzesuho torota baaqi qasa hiireta, Pariseo ma nanai gama hutingi bodzaqata hutingi naatorai oonihe ikanomake eeteqi tumakhameto niihoi tete oke qusubaitaama? ");
INSERT INTO ghs_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Hiiremi Dzesui hee, Tete erake qupadzomare. Abi teei ata naatare boohimi noho qesamanei hee, Ipita noi napake qaate mainata tuumakoiqi hiireqi ao noke aipo biidzareiqi noma nokoi bosata qaki ma nakiho isakita ooraridzoho tete qupadzomare. Oi ipita ana bamu naatemi tumakhameto nokoi meeke bodza ooqata hutingi naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Oke hiireqi noi paha abiho poma agoba ma tete usaqe nomeho qahura erake hiireta, Ttoba qosana agobai pui eetemi bamu ttoba koko usaqe puita suutomi isanataqu, oi usaqei tatanganita oi agobake suqobiremi pui minanatemi rasakinoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Oi paha abi bai oba usaqeke ingonaitorare hiireqi bamu oke nuupu agobata uqumami isanataqu. Ota uqumaquko nuupu okasabaqi bai obama gama susupu bamu naatakoita nokoi bai oba usaqe oke nuupu paha usaqeta uqumami oi gama bageke eete oorakoi. Oke hiireqi Dzesui tete agoba ma tete usaqeho qahurake hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Oke hiiremi guhu soopara teei Dzesuho torota pomai kotoroqi noorake hiireta, Maqoe, khatata nahoi poiqanipamuke baate. Oonihe ana qupadzomami nii baaqa boto niime noho irita mootomi eehaha naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Hiiremi Dzesui tumakhameto nomema gama qoridzeqi guhu soopara oke gainene eete tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Tuusuhimi atapa hemenoma teei noke iihata. Atapa oho khettedzai teeho bahe tii ttuerebeho isakita noho dzuui ipi uhubaamake qaata. Noi qupa nometa hee, Iidzo anai noho ttoba ma sasake seiqake hesateqake qidzanatakoi. Oiqi hiireqi noi qeemaqi sasa patisigi nohoke hesateta. ");
INSERT INTO ghs_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Hesatemi Dzesui burisi eeteqi noke mooqi hiireta, Khatata name, nii ai tataumami niiho sama qidzanasubi. Hiiremi bodza ooqata keke noho dzuu ipi uhubami noi qidzanate tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Oonita Dzesui guhu soopara oho nagata biranate moo nookami abi ao ttutturate rore ma sasa hiirota oi qesai tooma hiirotani qate qesai mangima hiirota. ");
INSERT INTO ghs_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Hiiromi Dzesui nokoke iihaqi hiireta, Khatata oi baatanipamuke eete ooraidzaranihe meeraho isakita ooraita nike papatare. Hiiremi nokoi sosoridzo hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Oonihe abi hoho oi paata biranatemi noi suruho ota dzuubaqi khatatake botota aima qoridzemi eehaha naateta. ");
INSERT INTO ghs_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Eehaha naatemi oho isere ao tuumaqi haba oke igabireta. ");
INSERT INTO ghs_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Qate Dzesui teteta sosomami abi nese khabanoma eseri noke iihaqi hiireta, Tabitiho eema ma khata, nii isanate nakaho dzasa eeteqi nesenomaitaqu mae? ");
INSERT INTO ghs_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Oke hiire tuumami noi naga teeta peitemi nopo iihaqi noho dzagata biranatemi Dzesui hee, Nipe qupadzomami oho beedzae naho torota oorai mae? Hiiremi nopoi hee, Soopara nakame, oore oi oorai. ");
INSERT INTO ghs_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hiiremi noi nese nopohoke hesateqi hiireta, Oionita nipe ai tatauma ooraiho isakita nesenoma naatare. Hiiremi nopoho nese paa eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Paa eetemi Dzesui nopoke hee, Oonihe eto sepeke abi pobi hiibaino. ");
INSERT INTO ghs_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Oiqi hiiretahe nopoi oke qahitota quba bitta eeteqi isere hiiremi oho pobi haba oke igabireta. ");
INSERT INTO ghs_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Oonihe nopoi paata tuusuhimi qesai abi potutu songenanoma teeke Dzesuho torota dzeimami baata. ");
INSERT INTO ghs_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Baami Dzesui songena oke iihami abi potutu noi ao noo ma toonoma naatemi abi qesa oona oota nokoi hasa hiireqi hee, Quba agiagi eranomai te Isirae abi napaho bisata biranate qaarara bamu. ");
INSERT INTO ghs_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Oonihe Pariseo basesa eeteqi hiireta, Ae, Iibadzanipaho dzapata hiireqi noi songenake iihorai. Obera noo oke noko hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Qate Dzesui haba ogamaqi nagapa mina ma gattiqa ota tuumaqi nokoho guhuta peiteqi qusuho sinabidza hiireqi heme ma bamenoma nokoke gama qidzaite soubireta. ");
INSERT INTO ghs_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ma Dzesui abi moomi sipisipi sooparaama sepesapeke tuumoraiho isaki naatemi noi nokoho quba baruna heme eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Noi tumakhameto nomeke hee, Dzooho mee gairai ooraihe oke rumutaquho abi samane bamu. ");
INSERT INTO ghs_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Oho qubake nike hoobire dzooho Mai noho torota pupu hiiremi noi baura abi samaneke dzoo nometa dzoobiremi tuumare. ");
INSERT INTO ghs_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Oiqi hiireqi Dzesui tumakhameto ttuerebe nomeho kira hiiremi baami noi nokoke beedzaenomaiteta. Beedzaenomaitemi nokoi songenake iihaqu ma khettedza maina paina qidzaitaqu oho isakinoma naateta. ");
INSERT INTO ghs_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Qate tumakhameto nokoi ipita qaru abi naatorota dzapa nokohoi erani: Bosabosa oi Siimo noke Dzesu paha dzapa usaqe Peetoro oke moiteta. Ma Attereo noma noho, ma Dzebetteoho khameto Dzakopo ma noma noho Dzohane. ");
INSERT INTO ghs_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Qate paha Piripo ma Battoromeo ma Ttoma ma Matteo ttagetti apiapi ma Arepeoho khata Dzakopo ma paha Ttateo. ");
INSERT INTO ghs_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Qate paha Siimo kana haba nena ma Dzuta Khariotta nena — noi ipita Dzesuke geema mootota — abi oioni. ");
INSERT INTO ghs_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Abi tuerebe oke Dzesu sinasina hiireqi dzoobireta. Noi hee, Nike haba qesaqesa abi nokoho torota tuumare. Oonihe eto poiqa Samaria abiho haba totaqita tuumaino. ");
INSERT INTO ghs_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Oi nike bosata Isirae abi sipisipi rasaki naate ooraiho isakita nokoho torota baura eetare. ");
INSERT INTO ghs_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Oonita nike tuumaqa sinabidza hiireqi eraiqi hiibare, Ohonga qusunaho pobi oi poiqa nikeho irita qeeme. ");
INSERT INTO ghs_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Oiqi hiireqa hemenomake qidzaitare, abi baatemi nike eehahaitare, pottomunomake qidzaitare, songenanomake hobireqi songenake hotou biidzare. Oke gama eeteqi eto oho ttuma quba hiibaino oi nike ttumaamake oho isaki saridzeta. ");
INSERT INTO ghs_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Qate eto oma teeke asita bautotaino, oi goorini mae siriba mae kopani mae quba ape oi gama baamu. ");
INSERT INTO ghs_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ma paha eto tete asike aimaino, ttoba ma sasa paramu aimaino, oko sasa aimaino ma pahu sumu teeke aimaino. Oi teeho bahe nokoi nikeke kokora eetaridzoni, oi baura oho pobi oni. ");
INSERT INTO ghs_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Qate nike nagapa teeta peitareiqa bosata abi qasa hiireqa hee, Nagapa eraho nakuta apei qidza kokoranoma? Oke hiiremi abiho dzapa paana naatemi nike ota peiteqa eto paha naga qesaqesata somobasomoho isakita tuumainohe ooqata keke meerake eeteqa nagapa oho baura eete soubireqake paha nagapa mainata tuumare. ");
INSERT INTO ghs_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Oonihe nike naga teeta peitare boohiqa nokoke Dzoobe hiibare. ");
INSERT INTO ghs_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Dzoobe hiiremi nokoi kaitomaqi Dzoobe hiibaquko nike nokoma hasu ma kebata oorakoi. Oonihe nokoi kaitomaama naatemi nike paha mainata tuumaqa hasu ma kebata nokoho neta peitakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Qate nagapa teeho abi gama basesa eeteqa noo nikeho nookaama naatemi nike nagapa oke qaatare. Qaasuhiqa hau nikeho okota ooraqu oke omata dzamutomi oi nokoho khooba paanaitakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nookao, Sotomu ma Gomoraho abike maripa eetaqu bodzata nokoi quba bamenoma saridzakoihe nokoho bame minabari. Oonihe nagapa teei nikeke bai hiiremi nokoke maripa bodzata quba bamenomanipamuke moitakoi oke ana bamu nike ikobetaqu. ");
INSERT INTO ghs_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Oi Dzesui hee, Ana nike dzoobiremi nike abi koiri kairinomaho bisata ooraqu oi sipisipike haa teekoho bisata dzoobidzaquho isaki naatakoi. Oho qubake nike nokoma ooraquta dzosi nokanokanomaho isakita dzeubaqa qusubibi hasunomaho isakita oora ma qaara eetare. ");
INSERT INTO ghs_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ma eto abi nookami ao hairiamake dzairanipamuho isaki naataino. Oi nokoi sinabidza guhuta nikeke gabeho biidzakoi ma nikeho isereke sinasina abi mimiho torota mootakoi oke eetemi nike ttoka soopara ma abi qiba ma kara nokoho bisata biranatemi nike naho noo nokoho tomata hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Hiiremi oi ttoka ma haba samaneho noo naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Oonihe nokoi nikeke qoharenaitemi eto nokoho noo ipi hiibaquho iiha ma dzoobidza eetaino. Oi Ohonga Mai nikehoho Sumasai bodza ooqata noo nike banaitemi noo ooqake hiiremi meenoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Oi erake eete oorai. Noma ma nanei qesa ibo eete qoharenaitokoi. Mai ma khata qesa bisi naate isere bamenoma mootakoi, ma khametoi mai ma pai basesa eete teetakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Oi nike naho quba baura eetemi abi samanenipamui nikeke ibo eetakoi. Oonihe nike baura eete soubidzare hiireqi battigara naatoraqutoke qidzanatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Oonita nagapa teeta nokoi nike ibo eetemake paha nagapa mainata tuuma ota soomare. Oonomake eete tuuma nagapa qesaqesa soubidzaamake ao Abiho Isaki anai ota nike saridzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Anai minaraho maikhata, banaita nikehonihe abi anake hee, Nii Iibadzaho isaki ooniqi hiiroraita nokoi bamu tumakhameto nikeke ingonaitaqu. Oi bauraho mai heme saridzemi kokora abi nohoi bamu heme oke riitaqu tete oke gama qupadzoma soubidzare. Anai nikeho mai ma banaitanita nokoi anake sesero eetaridzoho isakita nokoi tumakhameto ma kokora abi nikeke sesero eetakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Hiireqi Dzesui hee, Nokoi nike sesero eetakoihe eto atti eetaino. Nokoi dzukudzukuta eetaqu oke Ohongai gama paanaitakoi. Oi quba dzahedzahenomai gama susupu paana naate soubidzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Oi anai seike nikeho tomata hiibaqu oke nike otoba patita paanaitare. ");
INSERT INTO ghs_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Oke eetemi koiri kairinoma qesai sama nikehoke teetemi baatakoihe noko gisi nikehoke sesero eetaquho tete bamu oonita eto abi oonomaho attike eetaino. Ohonga teenai sama ma gisi ma gama eepata rubengaitaquho isaki oonita noqake ququimare. ");
INSERT INTO ghs_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Oonihe tete erake qupadzomare. Abi qesai bararima nee aimaqa nokoke makettita oho ttuma qattiqa aimorai. ");
INSERT INTO ghs_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Oi quba sepenihe Ohongaho nese oke riitaama. Oonita noi nike gama moo soubireqi qiba geeni mae quba ape nikeho torona oorai oke noi gama qupadzoma aima soubirorai. ");
INSERT INTO ghs_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nee gamisi oke noi nome moo qupadzomoraihe meenipamuke noi nikehoke nookami tobe sumanomanita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Hiireqi Dzesui hee, Oho qubake teei naho isere bageke eete abiho torota mootomi anai moorakoi ma isere qidza nohoke qusu Mai nameho pengata hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Qate teei abiho penga qubake naho bai hiibaquko qusu mai nameho pengata anai paha noho bai hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Dzesui hee, Nookare, ttokata hasu biranatorareiqi anai te baabaranita eto oke qupadzomaino. Anai biranatemi oho quba uuba ma sakaba samane biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Oi ana baami sinabidza oho ipike mai teei khatata nomeke ibo eetakoi, motami noi anapidza ibo eetakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Oke eetemi quni ma mani tee ma teeho bisata ibo ma kote samanei biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Oonihe teei qupa nometa hee, mai ma pai namehota atimaqu mae Kiristuho dzapata atimaqu oiqi hiireqi qupa eserima ooraqu ana bamu noho nookami isanataqu. ");
INSERT INTO ghs_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Oi teei anake iihareqi sama nomeke oho bagara biidzaama naatemi nohoke ana nookami qaganatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Oi teei qaraqara nomeke qaanateqa ao oho dzore naatakoi qate teei naho quba eeteqi qaraqara nomeke qaanataama naateqa qaraqara gama mai eetakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Dzesu ipibireqi hee, Oonita nike sinabidza hiiremi abi nikeho nookami meenoma naasuhiqa nahoke nookami meenoma naatakoi ma mai nahoke nookami paha meenoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Oonita naho too abi teei biranatemi teei noho nookami meenoma naatemi noke aima kokora eetaquko noi oho isakita ipi ma ari saridzakoi. Ma naho neta abi rike ma pobi teei biranatemi teei nohoke nookami meenoma naatemi noho kokora eetaquko noi paha oho isakita kiridza saridzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Qate anake nooka hiisi eetoraiho tuputa abi teei biranatemi teei noke moomi naho tumakhata naatemi oho quba noi noke kokora gattiqa eete oba kebani mae quba apeke noke moitaqu moitemi quba gattiqa oi paha ipi ma arinoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Noo ma sinasina samane oke Dzesui hiire soubireqi oke gama tumakhameto ttuerebe nomeho qereta gosorota. Gosoroqi noi nagapa oke qaate nagapa qesa samaneta noo ma sinabidza nomeke hiire paanaitareiqi tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Tuumaqi baura bamenoma samaneke eetotaho pobike Dzohane sobasobai nookatahe qupa muunaqi noi tumakhameto nomeke Dzesuho torota dzoobireqi qasa hiireta, Mesia baabakoiqi qetaqetai hiiremi nana noho beebe eetorai oi nii oioni mae maina teei paha baabaqu? ");
INSERT INTO ghs_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Oke hiiremi Dzesu nookaqi eraiqi hiireta. Ibaukhabaunomai nese uhuborai, qosu ma ponei tuuma ma baabanoma naatorai, pottomunomaho sama paisasa hiiburorai, toma susui toma uhuborai, abi baatemi eehahaitorai oke eeteqi abi habana nokoho quba sinabidza hiiremi qidzanatorai. Noo ma baura samane oke nike era moo nookorai oho isereke nike tuuma Dzohane sobasobai sutasutata oorai noho torota mooto soubidzare. ");
INSERT INTO ghs_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Qate sinasina erake paha noke pobi hiibare, Nii nahoke nookami niihota isanataquko nii oho agoago saridzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","9","Oiqi hiiremi Dzohane sobasobaho tumakhametoi tuumami Dzesui Dzohaneho hasa hiireqi nohoke abi samane noho torona oota nokoke pobi hiireta. Nike haba habanata Dzohaneke moora quba tuumata. Tuumaqi abi qiba, sasa nee ma baunoma meusa nagapaho poro qereta ooraiho isakike moorare tuumatani mai? Eo, nike qupadzomami uta tooro eebeke poupa taatoraiho isakinita quseripo oke moorakoiqi hiiretani mae? Eo too abi teeke moorakoiqi tuumatani mae? Nookao. Noio too abi oonihe paha too abiho isakike suqobirorai. ");
INSERT INTO ghs_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Dzohanehoke Ohongaho noota erake qeetemi oorai, Nookare, Qaru khata nameke anai Kiristu niiho bosata dzoobiremi tuumaqi tete niihoke ao roibetakoiqi hiiretanita abi oi ooni. ");
INSERT INTO ghs_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Oonita ana hiiremi nookare. Paimanei abike dzoomoraihota abi teei Dzohaneke riitaquho isaki ooraamanihe quba oi ttoka samaho dzapa pobi oho beekho kekeni. Oonihe Ohongaho pobi naatoraihota abi mina ma adza nokoi gama ttokaho dzapa pobi oonomake suqobirorai. ");
INSERT INTO ghs_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Qate Dzohane sobasobai baura nomeke sohoromi abi samanenipamu qaupa sasa gaamaqi beedzae eete Ohongaho pobita qeematai qeemorai. ");
INSERT INTO ghs_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Oi teeho bahe Mose ma too abi samanei sauqata sohoroqi hee, Quba oi biranatakoiqi hiire baa qaatani qate Dzohane nokoho musaqiqanita abi noko poiqa musaqiqaho noo nookami Soopara mee naho bodza naasuhimi nokoho qupa tukuborai. ");
INSERT INTO ghs_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Oi abi qesai hee, Eriai baataamake qusuta peitetai paha burisi eete baabakoiqi hiire qaata. Oonihe nike naho noo erake nookami meenoma naataquko erake qupadzomare. Dzohane noio Eriaho isakinipamu. ");
INSERT INTO ghs_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Oonita tomanomai nookare. Oke hiireqi Dzesui paha abi basesanomake eraiqi hiireta, Abi naga nikei quba apeho isaki? ");
INSERT INTO ghs_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Khameto sobadzata habese inga naatoraiho tete qupadzomare. Oi hoho teei hoho teemuke hee, Ae nanai ao kito biireqi mangi huitemi nike teqaha kaitomaqi naa hiibara. Qate nanai tti ma ttaka hiiremi nike ikaqi oho surupo eetaama naatorai? Oiqi khametoi hiiroraihe nokohota basesa biranatoraiho isakita abi basesanoma nikei Dzohaneho noo qusubaitaama naateta ma paha naho noo oho qesa arabirorai. ");
INSERT INTO ghs_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Oi Dzohane sobasobai oba ma patta kebakebaho hutingima baami nike noke hee, Songenanomaniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Qate Abiho Isaki anai baaqi patta ma oba qidzaho bai hiibaama naatemi nikei anahoke hee, Iidzii, bai oba hoobaqi dzoobaqi muunaqi paha pattake saqubema muunorai abi oni. Noi paha ttagetti apiapi pasenanoma nokoma qesa dzaira eetorainomani. Oiqi nike hiiroraihe nookare. Tete oi qidzani mae qanga ipita khooba paana naatakoi oiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Qate nagapa qesata Dzesui obaoba bamenoma samane eete tuumami nokoi basesa eete qupa burisi eetaama naateta. Oho qubake noi nokoke himotoqi noo minake hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Noi hee, nagapa Khoradzi ma Bettesaitta quba attinoma nipeho irita biranatakoi. Oi anai obaoba samane nikeho bisata eetemi Ohongaho mumure naatemi nike basesa eetoraihe oho isakita mumure nagapa ttiro ma Sittoho bisata biranatapuko nokoi bamu rubenga saridzarotahe ao tti ma ttaka hiireqi hau suranatemi ingonaitarota. ");
INSERT INTO ghs_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Oi nokoho bame minaminai oorakoihe maripa bodzata nikeho bame oi paha nokohoke suqobidzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Qate nagapa name Kapanao niiho dzapake ao qusubaitemi qusuho pobi naatarorihe baamunipamu. Dzapa nikehoi taate qoo iibadza nagata quratakoi. Oi teeho bahe anai baura qidza samane nikeho bisata eetemi Ohongaho mumure naate baorai. Oonihe oho isakita Sottomuho otoba patita paanaitapuko nokoi agobake qupa burisi eetemi nagapa oi poiqa oorarori. ");
INSERT INTO ghs_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Oho qubake nokoho bame oorai oorakoihe maripa bodzata nikeho bame oi nokohoke suqobidzakoi. Ooiqi Dzesu noko pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Oonita Dzesui Ohonga pupu hiireqi eraiqi hiireta. O mai name, nii qusu ma ttokaho maikhatanita nii noo bamenoma dzukudzukuna oorai oke te ttoka abi nokanoka ma gesinanomaho qupata paanaitoraidzaranihe abi qupa gaibanoma naho dzapana oorai nokoho qupata paanaitorai. ");
INSERT INTO ghs_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oho qubake ana niike dzoobe minake hiire. Oi nii tete oke saridzemi nese niihota bagenomanipamu naatorai. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Qate noi burisi eete tumakhameto nomeke pobi hiireta, Ohongaho khata anake gesina oi ape bahe mai teena ma Ohonga maike apei gesina bahe khata teena noho. Anaio noke gesinanipamu ma paha noi qesa ma nikeho dzapa hiiremi anai noho tete nikeke banaitemi nike oho qesa noke gesina naatorakoi. Oho qubake mai ao baura nomeke naho botota mootomi ana nikeho quba paanaitorai. ");
INSERT INTO ghs_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Oonita nike naane quba heme ma bame samane nikeme sepeke qere biire qaaraqu. Nike naho torota baaqa oke qerepasa eetemi ana isanate nikeke qidzaitakoi. ");
INSERT INTO ghs_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nookare, anai keba ma dzapaho maikhatanita nike naho neta qidzanatemake ana nike tete maina banaiteqa tetena nameke nikeho qereta goosoromi baura oi nikeho moirata bamu perebaqu. ");
INSERT INTO ghs_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Oi teeho quba bahe bame anai nike moitaqu oi isakiqata oorai ma naho tetena oio paha kebakebani. Oiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Dzuma teeta Dzesui haba ogamaqi uitti dzoota tuusuhimi tumakhameto nokoho ttidza saa eetemi nokoi quhisa qesa rumutoqi botoma kurutete muunota. Muunomi Pariseoi mooqi Dzesu qasa hiireta, ");
INSERT INTO ghs_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Maqoe, dzumata baura oonomake eetaquho qagai ooraita tumakhameto niihoi ikaqi oke eetorai? ");
INSERT INTO ghs_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Hiiremi noi noko pobi hiireta, Qate Tabiti qesamane nomema nokoho ttidza saa eetemi noi eeteta gotta ma pai oke nike isaitemi oorai mae bamu? ");
INSERT INTO ghs_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Oi noi Ohongaho parai nagata peiteqi dzobadzoba Ohongaho dzagata mooto qaata oke aimaqi muunata ma qesamane nomeke moitemi muunata. Oonihe oke muunaquho qagai qaatahe dzube abi keke muuna qaata. ");
INSERT INTO ghs_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mae nike oho ruume? Oi paha Dzumata baura samaneke eetaquho qagai ooraike dzube abi Ohongaho biirina oorai nokoho baura urai ooraita ikanomake eeteqi oho qagake qusubaiteqi oke qaataqu. Baamu, qaga oke riiteqi beedzae eete qeemami oi teqaha kahosananoma naatoraidzarani. ");
INSERT INTO ghs_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","8","Qate nookare. Anai Abiho Isaki ooqi naamae dzuma ape ma apeho Sooparanipamu. Oonita biirina qaga oorai oi poma teei oke eete ooraihe napa erana hiirorai oi quba meenipamu, oi qaga oonomake suqobireqi ai siginaitorai. Oi teeho bahe qetaqeta teei hee. Qoberobaho poma qesaqesa hiiroraiho goottaeke ana eetorai oonihe baruna heenaho tete oho dza minake eetorai. Qetaqeta oke nike naane quba mai eetaama naatorai. ");
INSERT INTO ghs_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Oke hiireqi Dzesui dzoo oke qaateqi sinabidza guhu nokohota peiteta. ");
INSERT INTO ghs_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Peitemi abi boto atimanoma teei ota oomi Pariseo ma karai Dzesuho angi naatareiqi qasa hiireta. Dzumata abike qidzaitaqu oi qaganomani mae bamu? ");
INSERT INTO ghs_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Hiiremi Dzesui noko pobi hiireta, Nikeho hoo teei dzuma bodzata koseta taatemi minara ma nikei noke aima ingonaitaridzoni, mae nikehota teei oonomaho isaki baamu? ");
INSERT INTO ghs_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Oonita moorare, hoo quba sepe oomi noho quba dzumata kokora eeteqa abinipamuke oho kokorake qaanataqu oi oberani. ");
INSERT INTO ghs_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Hiireqi noi abi boto atimanoma oke hee, Boto niimeke tataitare. Hiiremi noi noo oke qusubaitemi boto hohoi ao pobirate temuho isaki naateta. ");
INSERT INTO ghs_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Oke eetemi Pariseo paata biranateqi Dzesuke ikanomake eete ngausa eetaqu oho gunu ma naru hiiretahe noi ao qupadzomata. ");
INSERT INTO ghs_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Oonita Dzesui ao khooba qupadzomaqi nagapa oke qaate tuumami abi hemenoma samane noke iihami noi nokoke gama qidzaite soubireta. ");
INSERT INTO ghs_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Oonihe noi nokoke qogo noo hiireta, Nike eto baura oke sepeke abiho pengata paanaitaino. ");
INSERT INTO ghs_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Oonita Dzesui seike baura qidza oonomake eetetaho khooba erani. ");
INSERT INTO ghs_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Too abi Dzeseai Ohongahoke eraiqi hiire qeeteta. Moorare. Anai qeseba khata qidza bagenoma name quba asateqi qaheuba Sumasa nameke noho irinaitemi noi abi samaneke pobitareiqi biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Oonihe noi otoba patita sama kano hiibaqui baamu, ma noho niiqi ma noosa baamu. ");
INSERT INTO ghs_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","(Ma abi bame eetoraiho qahura erake qupadzomare) Noi bamu subidza makanomake geqobidzaqu qate eepa mukena hiibare boohimi bamu sepeke hiitaquhe oke gama eehahaite pobitakoi. ");
INSERT INTO ghs_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Oke eetoraqutoke suqobidza maikhata naatemi nagapa samaneho abi nokoi noho qupa toobake eetakoi. Oiqi Dzesea qeetemi Dzesuhota meenoma naateta. ");
INSERT INTO ghs_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Qate noko paha abi nese khabanoma ruume ma potutu songenanoma teeke Dzesuho torota mootomi noi noke qidzaitemi noonoma naateta ma nesenoma naateta. ");
INSERT INTO ghs_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Oke eetemi abi samanei mooqi roqobeteta. Nokoi hee, Tabitiho eema ma khatai oonomaho isakita biranatakoiqi hiireta abirai oioni kaqaniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Hiiremi Pariseo nookaqi bai hiireta, Baamu abirai songena iihoraiho khooba ape bahe noi Iibadzaho dzapata oke eetorai. ");
INSERT INTO ghs_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Oke hiiremi Dzesui iiha ma dzoobidza obera nokohoke qupadzomaqi noko pobi hiireta, Abi naga teei qesa hu ma koridza biidzaquko bamu bodza minake qaaraqu. Oho qesa nagapa mina teeta abi qesa ibo eetaquko bamu agoba qaaraquhe ao taatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Oonita Saatai sama nomeke hotou biidzaquko pobi nohoi ikanomake eete qaaraqu? Baamu, noi tete oonomake aimaama. ");
INSERT INTO ghs_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nikemaeho qesamanei dzapa apeta songena iihorai? Bamu, nokoi songenake Iibadzaho dzapata iihaquho tete bamuta nokoi nikeho noo nookaqa nikeke qoma dzubobidzakoi. Oonita nike oberama anake hee, Iibadzaho dzapata songenake iihoraiqi hiire. ");
INSERT INTO ghs_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Oonita anai Ohongaho sumasama songenake iihami tuumoraiho qubake nike ikaqi qupadzomaqu bahe Ohongaho pobi ao nikeho torota biranate ooraike nike qupadzomaridzoni. ");
INSERT INTO ghs_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ma qahura erake qupadzomare. Abi bise baisenomaho nagata sepeke peite qubadzage noho botona ooraike sepeke aimaquho tete baamuta bosata abi qanga oke suutoqanoke isanate noho nagana oorai oke gama saqoroqi aima tuumaridzoho isakita anai aoke Saatake suqobire ooraike qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nookao, anake hoobire qesake ingonaitaqu abi noio dzaira nahoni. Qate ana baura eetoraike teei bai hiire rasaki eetaquko noi naho ibonipamu. ");
INSERT INTO ghs_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Oonita qesai baru ma noo qanga maina paina hiirorai kahosa oonomake dzamutaquho tete oorai. Qate Ohongaho Sumasai baura eranomake eetemi oke qanga hiibaqu kahosa oke akobetaquho tete te ooraidzara. Poiqa bamu, ipita oho qesa baamu dzanadzana! ");
INSERT INTO ghs_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Oi qesai Abiho Isaki anaqake qanga hiiremi anai nokoho kahosa oke gaubidzaquho tete ooraihe teei Sumasa ma noho baura eranomake qanga hiiremi kahosa oi agoba qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Hiireqi Dzesui hee, Nookare, ee teeho meeke mooqa hee, Ee qidzaniqi hiibakoi eo hee, Ee qanganiqi hiibakoi oonita etoqa oke rasakiiteqi ee qidzata mee qangake goosobaino. Oho qesa eto ee qangata mee qidzake sepeke goosobaino. ");
INSERT INTO ghs_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Oonihe ana moomi abi naga nikei dzohomaho khameto oonita ikanomake eeteqi nike noo qidzake hiibaqu? Baamu, iiha ma dzoobidzata hee ma heeta oorai ooqai toota biranatorai. ");
INSERT INTO ghs_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Abi qidzai qupaho iisuta noo qidza saridzeqi abi moitoraini qate abi qangai qupaho iisu nometa saridze abi moitorai oi paha qangani. ");
INSERT INTO ghs_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Oho qubake abi noo qidzake hiibaquni mae noo sepesapeke hiibaqu oho isereke abi oi ipita Ohongake pobi hiiremi maripa eetakoita noi bamu noo teeqake riitaqu. ");
INSERT INTO ghs_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Oonita totoho apeta nii hiibaquke qupadzomare. Noo qidzake hiiremi oi niike qidzaitakoini qate noo qangake hiiremi oi niike qangaqitakoi. ");
INSERT INTO ghs_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Oiqi hiiremi Pariseo ma Qetaqeta abi qesai baaqi hee, Nana dza eetemi nii nanake baura teeke banaitemi nanata Ohongaho mumure naatare. ");
INSERT INTO ghs_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Hiiremi Dzesui hee, Iidzo, abi naga qanga pasenanoma nike Ohongaho mumure teeho quba qasa hiirehe, Dzonaho bodzata mumure biranateta ooqai keke biranatemi nike moorakoi. ");
INSERT INTO ghs_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Oi Dzonai qupi tapariho isakita pakeba minaho qausuta ooqi ipita eehahake biranatetaho isakita Abiho Isaki anai qupi taparike nesetuta ooqa paha eehahake biranatemi oi Ohongaho mumure naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Oonita qupadzomare. Dzonai eehaha naate meusu nagapa Ninibe nokoho qogo noo hiiremi nokoi qupa burisi eete qidzanateta. Oho qubake maripa bodzata Ninibe abi qoridzeqa nikeke hee, Nanai too abi Dzonaho noo nookaqi qusubaitetahe nikeho torota too abi keke bahe Abiho Isakinipamui biiranate qogo noo hiiremi nookaama naatoraiho qubake nikei abi naga qanganipamu. Oiqi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Qate paha atapa qiba teei agobanipamuke haba pobi neta baaqi Isiraeho abi qiba Soromo nokanoka mina nohoke nooka pobita quba noho torota peiteta. Peiteqi nokanokanoma naateta. Oonihe anai Soromoho isaki gattiqa bahe Abiho Isaki anai Sooparanipamu oonita abi naga quseripo nike naho torota baaqi te naho noo qusubaitoraidzara oonita atapa mina noi maripa bodzata nikeho iiga minanipamuke hiibakoi! ");
INSERT INTO ghs_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Oiqi hiireqi Dzesui hee, Qate qahura erake nookare. Songena teei abi teeke qaasuhiqa qongara naga hau ma obanomata meupu saridzareiqi tuumata. Tuumaqi saridzaama naate burisi eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Burisi eeteqi hee, Anai naga tta eeteta ota paha dzuubakoi hiire qeemaqi moohimi meeke sarautomi oota. Qate quba teei noho habara oorananihe teka habanai oota. ");
INSERT INTO ghs_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Habanai oomi noi iiha ma dzoobidzake eete qesamane nome songena sebeni ngiinginomanipamu nokoke dzeima nokoi ttaike ota dzuubami abi oi nokoho pattanipamu naateta. Oi bosata noi isakiqata qangama ootahe songena tuumami noi oho habarake baura qidza mai eetaama naatemi eranoma naatemi suhe nohoio attinomanipamu naateta. Oonita abi naga nikeio oho isaki. ");
INSERT INTO ghs_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Dzesui noo oke abi tupu pobi hiire qaasuhimi oionita pai gotta nohoi nomamane dzabamane nohoma noko naga patita qooroqi hee, Nanai noo teeke noke pobi hiibareiqi baabe. ");
INSERT INTO ghs_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","(Hiiremi teei Dzesuho torota qeemaqi hee, Maqoe pai gotta niihoi nomamane dzabamane niihoma gama paata qooroqi niima qesa noo hiibare baabe.) ");
INSERT INTO ghs_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Oiqi hiiremi noi totoho eranomata ipi hiireta. Pai gotta nahoi ape oni? Ma nomamane dzabamane nahoi apene oni? ");
INSERT INTO ghs_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","50","Hiireqi noi tumakhameto nomeke boto koko eeteqi hiireta, Nookare. Apene qusu mai nahoho dzake qusubaitorai nokoi pai gotta ma nomamane dzabamane nahoho isaki. Oonita tumakhameto name, nikeio quni ma mani nahoni. ");
INSERT INTO ghs_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Hiireqi Dzesui nagata tta eeteqi oba ttu oho patisigita teemaqi habeseta. Habehimi ao abi samanenipamu noho torota ttutturateta. ");
INSERT INTO ghs_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ttutturatemi teka pui siiremi noi nokoke sinabidza hiibareiqi sisimata peitemi nokoi igasata habese nookata. ");
INSERT INTO ghs_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nookomi noi qahura noota nokoke sinasina samane ke hiireta. Noi hee, Dzooho mai teei gottara bababa eetare sobadzata tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Oonita noi uitti gottara bababa eesumi qesai tete patisigita taatetahe nee ao baaqi oke gama nukurota. ");
INSERT INTO ghs_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Qate gottara qesai oma quhiquhirata taateqi ao suuna eeteta. Oonihe orotu noho ohoumata. ");
INSERT INTO ghs_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ohoumami ete huubiremi ao bubuso naateta. ");
INSERT INTO ghs_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Qate gottara qesai baa bisata taateqi paha suuna eeteta. Oonihe baa ma ngaa oi peiteqi oke pupubiremi poqe eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","9","Qate gottara paha qesai ttoka qidza bibinomata taateqi suuna eete peiteqi mee goomata. Qesai teutiho isaki qesai sikistiho isaki qate qesai paha gaira naateta oi hattattiho isaki oni. Oonita tomanomai nookare! ");
INSERT INTO ghs_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Dzesui oke garuba pobi hiiremi bamu naatemi tumakhameto nohoi baaqi noke qasa hiireta, Nii khooba apeho qubake nokoke qahura noota sinabidza hiirorai? ");
INSERT INTO ghs_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","12","Hiiremi noi hee, Oi erake eete oorai. Anai ango nikeho torota baura eete qaimi Sumasa nike uumami isakiqata tete oho mee saridzorai. Oonita nikeke ipibire sinabidza paata hiiremi nikehota meupunoma naatakoi. Oonihe abi tupu toma agiagike paata sinabidza hiiremi arabidzakoita bosata nokoke qahura noota dzeimami aimareiqa aimakoi gaubidzareiqa gaubidzakoi. Apiapike moitakoihe qesai noo arabidzaqu nokoke quba oke bamu sepeke moitemi puita tuumaqu. ");
INSERT INTO ghs_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Oonita hiibi anai nokoke qahura noota sinabidza hiiremi arabidza abi nokoi nesema moramorake moorakoihe baamu moo pobitaqu, ma tomama nookake eetakoihe bamu nooka qupadzomaqu. ");
INSERT INTO ghs_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Oi too abi Dzeseaho qetaqeta teei hee, Abi nagarai hee, Eto Ohonga nanake ingonaitaino hiireqi eto nanai nese nanamema moo pobiteqi tomama nooka qupadzomaqi qupa uhuba pobiratemi napai qupa burisi eetaino. Oke hiiremi nese nokohoi sidzobetemi toma susudzatorai ma qupa nokohoi asuasu naatorai oiqi Dzesea hiiremi nokohota meenoma naatorai. ");
INSERT INTO ghs_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","Oonihe nike poike moo nookoraike too abi ma abi dzapa pobinoma agobake moo nookareiqi dza minake eete qaatahe baamu. Te moorara, te nookara. Nikeho nese moo pobitorai ma toma nikehoi nooka qupadzomoraiho isakita nike nokoho habara naateqi agoago saridzoraita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Hiireqi Dzesui hee, Oonita dzooho maiho qahura khooba nohoi eraqanita nookare. ");
INSERT INTO ghs_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Goottara qesai tete patisigita taateta oi abi qesai qusuho sinabidza nookami ingaqonoma naatemi Iibadzai baaqi nokoho qupata menoma naatarotake noi ao karabetemi sapara naatoraiho qahurani. ");
INSERT INTO ghs_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Qate gottara qesai oma quhiquhirata taateqi suuna eetetahe ao bubuso naateta oi abi qusuho sinabidza nookami oi nokoho qupata meenoma naasuhimi oho kaipo ma qangareba, uuba ma sakaba biranatemi nokoi ao peperate bamu naatoraiho qahurani. ");
INSERT INTO ghs_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Qate goottara qesai baa bisata taateta oi abi qesai sinabidza nookaqi qusubaitare boohimi ttokaho iiha ma dzoobidza ma ttuma ma qurumaho ikoiko oi gama abi nokoho angi naatemi oho kabira naate bamu naatoraiho qahurani. ");
INSERT INTO ghs_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Qate goottara ttoka qidza bibinomata taateta oi Ohongai ao abi qesaho qupa roibetemi ooraita nokoi nooka qupadzomaqi noo qusubaitemi meenoma naatorai. Qesaho isaki gattiqa — 30 oni — qate qesahoi minamina — 60 oni — qate qesahoio gairanoma — 100 oni — oio oho qahurani. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ipita Dzesu qahura teeke paha nokoho quba hiireta. Noi hee, Ohongaho pobi nebe teeta erake eete oorai. Abi teei dzoo nometa tuumaqi goottara qidza ota dzaaro dzaaroke tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tuuma soubireqi surenake burisi eete nagata peite qesama gama meeta. Meeqomi abi qesai noke ibo eeteqi seike dzoota qeemaqi uitti gottara qidza dzaaro dzaaroke tuumatahn takura samaneta baapi goottarake dzaaroqi papateta. ");
INSERT INTO ghs_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Qate quba oi gama suuna eete peite heubare boohimi dzoo oho baura abi quhisa sama maina paina oke moo sahateteta. ");
INSERT INTO ghs_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Sahatete dzoo maikhataho torota biranateqi hiireta, Mai naname, nana moomi nii uitti goottara qidza keke nana moitemi dzaarota. Qate ikanomake eete baapi oho bisata peite heuborai? ");
INSERT INTO ghs_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Hiiremi noi nokoke pobi hiireta. Eehe erai ibo abi teeho baurani. Hiiremi baura abi noke hee, Oonita nii dza eetemi nanai isanate tuuma baapi oke uumaqu mae? ");
INSERT INTO ghs_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Hiiremi eraiqi hiireta. Baamu, oke uuhiqa eto uittima gama uumaino. ");
INSERT INTO ghs_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Oho qubake beebe eetemi oi gama mee gooma baa naatemake oionita anai rumutaquho abike pobi hiireqa hee, Nike bosata baapike khoobata korabete geema sipitoto eepata biidzare. Oke eeteqa uitti qidza oke gama dzurutoqa naho iisunaitare. Oiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Hiireqi Dzesui qahura noo teeke paha abi samaneho quba hiireta, Noi hee, Ohongaho pobi erake eete minanatorai, Abi teei dzoo nometa tuumaqi moepa goottara teeke dzaarota. ");
INSERT INTO ghs_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Qate moepa goottara oi mina baamu, oi dzooho quba gattiqanipamu. Oonihe oke dzaaromi ao peite mina naate eeho tomidza naatemi nee qesai baaqi ota sumudzataquho isaki naatorai. ");
INSERT INTO ghs_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Oiqi hiireqi noi qahura noo oke paha iisita mootoqi hiireta. Noi hee, Atapa teei iisi isaki teeke qausoma teenaite saretemi oi qauso igabire qura huite minanatorai. Ohongaho pobi paha oke eete abike igabirorai. Oiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Oonita Dzesui abi minaraho pengata sinabidza hiireqi qahura noota keke nokoke tete banaite qaata ma oho amake te nokoke noo tee ma teeke banaite qaarara. ");
INSERT INTO ghs_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Oi teeho quba bahe Ohongaho too abi agobake Samu teeta qeeteqi hee, Anai too saqoroqake noo agiagi agoba khoobanipamuta sengibetemi qaata oke qahura noota paanaitemi oho isakita nookakoiqi hiiretanita oke eete biranateta. ");
INSERT INTO ghs_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Qahura qesa oke hiire soubireqi Dzesui garuba oke dzoobiremi nagapa nokometa tuumata. Tuumami tumakhameto nokoi noho torota baaqi qasa hiireta, dzoota baapi peiteta qahura oho meeke nii nana pobi hiibo. ");
INSERT INTO ghs_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Hiiremi noi eraiqi hiireta. Teei goottara dzaarorai oi ape bahe Abiho Isaki Ana. ");
INSERT INTO ghs_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Qate dzoo oi abi ttoka ma haba minarata oorai. Qate goottara qidza oi abi qesa Ohongaho pobi naatorai oioni. Oonihe baapi oi ibo teei ikoiko abi qesa dzoobirorai noko oioni. ");
INSERT INTO ghs_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Qate ibo abi oi Iibadzani. Rumutaqu baura oi batabidza ipina biranataquho qahurani. Ma mee rumutorai abi nokoi angero oni. ");
INSERT INTO ghs_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ma baapike ubaqoto qeebaqu oho isakita abi meeamaho irata biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","Oi oho bodza biranahimake Abiho Isaki anai angero nameke dzoobiremi nokoi abi kahosanoma koiri kairinomake gama oho neta dzurutoqi eepaho isakita biiremi nokoi ota too dzootoqi tti ma areare hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Oonihe bodza ota abi rike ma pobi nokoi mai nokomeho pobita ooqa ete dzadzaho isakita baiburorakoi. Oonita tomanomai nookare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Qate bodza teeta Dzesui eraiqi hiireta, Nebe teeta Ohongaho pobi paha erake eete oorai. Oma mina hihihinoma tobe sumanoma oke ttoka nakuta qurabire oomi abi teei baaqi saridze qakiqaki naateta. Oonihe Noi teqaha oke paanaitaranihe tuumaqi quba tongo nomeke gama ttuma quba mootota. Mootomi oho isaki biranatemi ttuma oke noi ttoka oho quba mootoqi oma mina oke ttokama gama mai eeteta. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ma Dzesui noo ipibireqi hee, Ohongaho pobi naataquho qahura erake hiire. Besaho kabira nakuta isaki khabanoma ttumanoma biranatorai dzapa noho peari oi suusa pai gotta. Oonita abi teei ttumaho sobadza samaneta asate tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tuumaqi noi oho isaki mina tobe sumanoma teeke saridze roqobeteta. Roqobeteqi noho torona oho gamitti oota oke noi gama ttuma quba mootomi biranatemi noi ttuma oke aimaqi suusa pai oho quba biire soubireqi mai eeteta. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Bodza teeta Dzesui qahura noo hiireqi hee, Ohonga qusunaho pobi paha nebe teeta erake eete oorai. Khaa apiapi nokoi dzupu nokomeke obata mootomi khaa dzapa samane ota agomata. ");
INSERT INTO ghs_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Agomaqi hee baami nokoi dzupuke dzeima igasata perebireta. Perebireqi nokoi habeseqi khaa qidzake asateqi ttubata moototahe togoke ai biireta. ");
INSERT INTO ghs_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Oi ipi bodzata Ohongaho angeroi tuumaqi abi qidzake asateqa qangake eepaho isakita biiremi nokoi ota too dzootoqi tti ma areare hiibakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Oke hiireqi Dzesui tumakhameto nomeke qasa hiireta. Qahura noo oho khoobake nike gama qupadzomorai mae? Hiiremi nokoi hee, Oore. ");
INSERT INTO ghs_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Oke hiiremi Dzesui hee, Oionita qesa ma nikei hu nooho qetaqetama gesinanoma naate baa qaabiqi qusuho sinabidza mai eeteqi nikei eraho tomidza naatorai. Oi naga minaho maikhata iisu nometa quba agoba ma paha quba agiagi saridze gaaga eetemi mekenoma naatorai nikei oho isaki naatorai dzoobe. ");
INSERT INTO ghs_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Oonita Dzesui qahura noo samanake paanaite soubireqi ooqata koridza biireta. ");
INSERT INTO ghs_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Qate noi tuumaqi haba nometa sinabidza guhu nokohota peiteqi mekeqoma sinabidza hiireta. Hiiremi nokoi sahateteqi hee, Abirai napaho nenanita nokanoka ma obaoba samaneke dzoomorai oho beedzaeke noi ikata aimorai? ");
INSERT INTO ghs_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mai nohoi kamuta Dzosepeniqi hiirorai ma pai gotta nohoi Maria. ");
INSERT INTO ghs_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nomamane nohoho dzapa paha Dzakopo ma Dzosepe ma Siimo ma Dzuta. Qate dzabamane nohoi gama napaho bisata oorai. Oonita noi ikaqi baura erake mainata saridzeqi napaho bisata mootorai? ");
INSERT INTO ghs_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","58","Oi nokohota qanganatemi nokoi oho totohota hiireta. Oonihe Dzesui nokoke eraiqi hiireta, Too abiho dzapake haba qesaho abi qusubaitorai. Oonihe noko ma nanamaeho nagapa khoobata abi nanaho dzapake ngiingi ma baabake eetorai. Oke Dzesu hiiremi nokoi nooka hiisi eetaama naatemi noi nokoho bisata baura samaneke eetarotahe ooqata tete bamu naateta. ");
INSERT INTO ghs_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Bodza ooqata abi mina Herotei Dzesuho isereke abiho toota nookata. ");
INSERT INTO ghs_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nookaqi noi hee, Ae! Dzohane sobasobaho qibake ana geemami baateta. Oonihe noi paha eehaha naateqi oho beedzaeta obaoba ma baura bamenoma samane erake eetorai mae? ");
INSERT INTO ghs_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Oi Herotei oonomaho totohota hiiretaho khooba erani. Bosata Herotei Piripo noma nomeho ata Herottia karabeteta. ");
INSERT INTO ghs_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Karabetemi Dzohanei Heroteke hee, Nii atapa oke naate oorai tete oi qaganomaniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hiiremi Herote ao noke teetarotahe abi samanei nookami Dzohane noi too abi qaheubanaho isaki naatemi Herote nokoho attike eeteqi te noke teetaranihe sutasuta nagata biireta. ");
INSERT INTO ghs_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ota biire oomi Heroteho pai noke dzomataho bodza naatemi abi dzapa pobinoma samanei noho nagata peite iinga eetota. Iinga eetoqi Herottiaho khatata noi nokoho bisata naa teetemi Herote oho dza minake eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Eeteqi noi atapa khata oke naru hiireqi hee, Nii quba tee ma teeho dzake eete hiiremi ao moitakoi. ");
INSERT INTO ghs_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Oke Herote hiiremi khatatai pai gottaho torota oho qasake hiireta. Hiiremi pai hee, Maa, nii isanate Heroteke hee, Nii Dzohane sobasobaho paruke geemaqa qiba sabidzata mooto aima baa erata paanaitareiqi hiibare ooqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hiiremi khatatai teena oho qasa hiireta. Hiiremi Heroteta bame eeteta oonihe noi aoke abi mimiho pengata naru oonomake hiiretaho qubake noi qusubaiteta. ");
INSERT INTO ghs_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Noi hiiremi qaa abi teei sutasuta nagata Dzohaneho paru geemata. ");
INSERT INTO ghs_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Qiba nohoke sabidzata mootoqi khatata oke moitemi noi aima baa paike moiteta. Oke eetemi Dzohaneho tumakhametoi keba nohoke aimaqi qurabireta. ");
INSERT INTO ghs_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Qurabiireqi nokoi qeema oho isereke Dzesu pobi hiireta. Khooba ooqaho qubake Herotei ipita qupa muunaqi hee, Dzohanei eehaha naate mae? Oke Herotei hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Qate Dzesui isere bamenoma oke nookaqi nagapa nomeke qaateqi sisimata peite qee totoqita biranate haba habanata tuumaqi noqeke oota. Oonihe nagapa abi samanei noho pobi nookaqi soosomaqi noho torota tuumota. ");
INSERT INTO ghs_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tuumomi noi qeemaqi moomi abi samane naatemi noi nokoho quba dzasa eeteqi heme ma bame nokohoke gama qidzaiteta. ");
INSERT INTO ghs_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Qate ete aparana naahimi tumakhameto nokoi baaqi noke qupanomaiteta, Maqoe, erai haba habananita bodza riitemi nii abi tupu oke dzoobiremi nagapa ma dzoo naga qesaqesata tuumaqa patta ttuma eetare. ");
INSERT INTO ghs_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Hiiremi Dzesui hee, Naane quba nokoke kharata dzoobidzaqu? ");
INSERT INTO ghs_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nikemae noko patta moitemi muunare. Hiiremi nokoi hee, Oonihe nanata patta baamuhe dzobadzoba boto teena ma sekana ngoru eseribanita ikabetaqu? ");
INSERT INTO ghs_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Hiiremi noi hee, Seke aima baabare. ");
INSERT INTO ghs_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Hiiremi aima baahumi noi hee, Abi tupu oke siiruta habesareiqi hiibare. Hiiremi qusubaitemi noi dzobadzoba boto teena ma sekana ngoru eseri oke aimaqi nese qusuke mooqi agoago eeteta. Eeteqi noi dzobadzoba ma sekana oke qooto teeteqi tumakhameto moitemi nokoi abi tupu moitemi muunata. ");
INSERT INTO ghs_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","21","Muuna isanatemi tumakhametoi qettaqettake ttuttuitemi oi paha asi tuerebe, dzare nokomaeho isaki naateta. Qate abi ungapaho dzare oi paipu ttauseni naatetani qate paimane ma khametoho dzareke te aimara. ");
INSERT INTO ghs_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Oionita Dzesui tumakhameto pobi hiireqi hee, Nike ao bosa sisimata peiteqa oba ttu totaqita qeehima anai ooqa abi tupurake dzoobidzare. ");
INSERT INTO ghs_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Hiiremi tumakhameto tuumami noi abi tupu dzoobiremi nagapa nokometa tuumami noi noqeke torata peite pupu hiirota. ");
INSERT INTO ghs_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Qate tumakhameto nokoi unatare boohimi uta mina dzaga neta tooromi oba pouma minake eetemi nokoi kaiponoma naateta. ");
INSERT INTO ghs_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kaipo mina eete qaami iihaiho takura naatemi Dzesui oba heeta qooro qooroma baaota. ");
INSERT INTO ghs_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Baaomi tumakhameto oke moomi gisi ma songenaho isaki naatemi nokoi atti eete areare hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Areare hiiremi Dzesui too dzoobireqi hee, Eo, eto atti eetaino. Oi ananita qupa qidzanatoo. ");
INSERT INTO ghs_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Oke hiiremi Peetoroho qupa tukubami noi hee, O Soopara name, oi nii ooni kaqa. Oho quba nii hiiremi anai obata qooro niiho torota qeemare. ");
INSERT INTO ghs_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Hiiremi noi hee, Ana oionita baabare. Hiiremi Peetoroi sisimata qura obata qooro Dzesuho torota qeemota. ");
INSERT INTO ghs_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Oonihe qeemoqi moomi utai oba huitemi pouma peitemi noi atti eesuqi ao suuta tuumare eeteta. Eeteqi noi areare hiireqi hee, Soopara, nii anake hoobidzare! ");
INSERT INTO ghs_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hiiremi Dzesui ao noke botota aimaqi pobi hiireta, Nii ikake eetemi niiho ai tatauma saparapara naate? ");
INSERT INTO ghs_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hiireqi nopoi sisimata peitemi utai ao bamu naateta. ");
INSERT INTO ghs_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Utai bamu naatemi sisimana oota nokoi gama noho hasa hiireqi hee, Meenipamu nii Ohongaho khatani. ");
INSERT INTO ghs_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Oiqi hiireqi Dzesu ma nokoi qeemaqi Genesarette haba teeta qurateta. ");
INSERT INTO ghs_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","36","Quratemi haba oho abi gama Dzesuke moo qupadzomami noho pobi ao haba oke igabireta. Haba igabiremi nokoi heme ma bame nokomeke dzeimaqi noho torota biranateqi hee, Maqa nanai khettedzanomanita nii eto nanake botoma hesataino. Oonihe nanai nii ttoba patisigiqake hesatare. Oke hiiremi nohota isanatemi hesateta nokoi gama iso keke qidzanateta. ");
INSERT INTO ghs_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Qateqa Pariseo ma qeteqeta abi nokoi Dzerusaremuta baaqi Dzesu qasa hiireta, ");
INSERT INTO ghs_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Niiho khameto naane quba uimane neimaneho poma teeke riiteqi boto nokomeke akobetaamake patta muunorai? ");
INSERT INTO ghs_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Hiiremi noi nokoke hee, Qate nike naane quba Ohongaho too qurake ai siginaiteqi uimane neimaneho noo ma poma qesaqesake qusubaitorai? ");
INSERT INTO ghs_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nookare! Ohongai hee, Mai pa pai niimeke qusubaiteqi kokora eetorareiqi hiireta. Hiireqi oho tete qaupuiteqi paha hee, Khata teei mai oonimae paike baru hiibaquko noke teetemi baatemi quba tongo nohoi mai ma paiho naatakoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Oonihe abi khata quruma minanoma teei maini mae pai nomeke baru hiiremi nike naane quba pati nikemeke qoohateqi khata oke sinasina hiireqi hee, Nii baataamake ooraquta ao hairiamake quba tongo niimeke qaheuba biiriho quba qoonotoqa mai ma paike hee, Quba tongo nahoi bamu nikeho naataquhe ao biiriho pobi naateiqi hiibare. ");
INSERT INTO ghs_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Oke khata pobi hiireqi nike Ohongaho noo riiteqi poma nikemeta naane quba ipibirorai? ");
INSERT INTO ghs_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Oonita nike ikoiko abinipamu. Too abi Dzeseai nikehoke qupadzomaqi eraiqi hiireta, ");
INSERT INTO ghs_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Abi nagarai oosasama naho hasake hiiroraihe qupa nakohoi qekakake ooroi. ");
INSERT INTO ghs_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Oonita noo nahoho habarake nokoi noo nokomeke upubiremi sinabidza nokohoi quba sepe naatorai. Oiqi Dzesea hiiretata qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Hiireqi Dzesui Pariseo ma qetaqeta abi keke bahe abi samane oona oota nokoke gama ttuttuiteqi eraiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Boto akobetaamake patta muunaqu oio ttokaho qubani. Oi qausuta qurateqi abike hoobireqi paha ttidzama biranatorai. Oonihe abike meeke sesero mina eetorai oi quba ape bahe noo qanga toota biranatorai oi oni! Oke korabete nooka qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Oke hiiremi qesai baaqi Dzesuke hee, Maqoe nii totoho oonomata hiiremi Pariseohota qanganate oonita nookare. ");
INSERT INTO ghs_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Hiiremi noi nokoke hee, Erake eete oorai. Biidza ma suuna Ohongai dzaaromi peitorai oi oorakoihe noi dzaabaama oke gama uumakoi. ");
INSERT INTO ghs_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Oonita abi nese qupi noi paha nese qupike dzeeima tuumaqi esese koseta taatakoi. Pariseo ma kara nokoio nese qupi keke ooqi abike dzeimoraita etoqa nokoho qupake muunaino. ");
INSERT INTO ghs_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Oiqi hiiremi Peetoroi noke pobi hiireta, Qahura noo bosana hiirori oho khoobake nana pobi hiibare. ");
INSERT INTO ghs_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Hiiremi Dzesui hee, Iaqa, nike oho qesa ruume abi kekeni mae? ");
INSERT INTO ghs_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nookare. Pattai qausuta qurateqi ttidzama biranatorai oho qanga bamu. ");
INSERT INTO ghs_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Qate iiha ma dzoobidza qangai qupata peite toota biranatorai oio qesake sesero eetorai paha abi noomaeke sesero eetorai. ");
INSERT INTO ghs_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Quba qanga apehoke hiidzaranihe, iiha ma dzoobidza nginginoma, pasena maina paina, guume ma meera, teeta ma ttanga, too pokhi ma rasaki noo. Quba oonomai qupata peite toota biranatorai oio qaganomani. ");
INSERT INTO ghs_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Qate uimane neimaneho sinabidza poma teeke riite boto akobetaamake patta muunaqu oi baamu oho qubake abike dzakidzaki eetaqu. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Oonita Dzesui haba oke qaateqi Ttiro ma Sittona habata biranateta. ");
INSERT INTO ghs_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Biranatemi Kaana haba oho nena atapa teei noho torota baaqi poro kira hiireta, Soopara name nii Tabitiho eema ma khata. Oonita songena qaanoma teei khatata nahoke sesero minake eetemi nii naho quba dzasa eetare. ");
INSERT INTO ghs_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Hiiromi noi kaitomaama naatemi tumakhameto nohoi baaqi Dzesuke pobi hiireta, Atapa oi napake ipitotoqi tti ma poro hiiremi nii isanate noke qamuni hiibaqu mae? ");
INSERT INTO ghs_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Hiiremi noi hee, Oo, anai abi qesaho qubake te erata baabaranihe Isirae abi sipisipi rasakinomaho qesa naatorai nokoqaho quba era baaba. ");
INSERT INTO ghs_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Oiqi hiiremi atapai qeemaqi noho torota pomai kotoroqi hiireta, Soopara niimae anake hoobidzo. ");
INSERT INTO ghs_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Hiiremi Dzesui noke toronaiteqi eraiqi hiireta. Khametoho pattake karabeteqi haaho quba biidzaqu oho tete bamu. ");
INSERT INTO ghs_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Hiiremi noi hee, Soopara name nii noo meeke hiire. Oonihe haai maimane nokomeho qohare pesuta oomi patta huhu pereborai oke haai isanate muunorai oni. ");
INSERT INTO ghs_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Hiiremi Dzesui noke hee, O atapa, niiho ai tatauma oi bagenomanita nii dza eetorai oio meenoma naatare. Oiqi hiiremi bodza ooqata keke khatata nohoi qidzanateta. ");
INSERT INTO ghs_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Dzesu haba oke qaateqi kebanoke Garirea obaho patisigita biranateta. Biranateqi oke paha qaate torata peite ota habeseta. ");
INSERT INTO ghs_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Torata habese oomi heme ma bame, qosu ma pone, ruume ma potutu, abi samane oonomai baaqi oko toro nohota taatemi noi noko gama qidzaiteta. ");
INSERT INTO ghs_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Oke eetemi abi tupu oona oota nokoi moohimi ruume ma potutu noonoma naateta, qosu ma ponei pobirate bageke eete qooro tuumata ma ibau khabaui nesenoma naatemi nokoi Isirae abiho Ohonga dzapa qusubaite hasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Qidzaita baura oke Dzesu eete qaaqi qaaqi tumakhameto nomeho kira hiireqi hiireta, Abi samane erai ao qupi tapariho nakuta pattaamake naho torota noo nookoraimi ana nokoke dzoobiremi tuumakoi. Oonihe nokoi eto teteta qereqare eetainoho qubake anai nokoho dzasake eetorai. ");
INSERT INTO ghs_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Hiiremi tumakhameto nohoi hee, Oonihe napai haba habana erata ooraiqi ikata garuba minaraho quba patta saridzaqu? ");
INSERT INTO ghs_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Hiiremi Dzesui noko qasa hiireta, Dzobadzoba nikeho ikabete oorai? Hiiremi nokoi hee, Dzobadzoba sebeni ma sekana ngoru paha teenani mae eseri kaqani. ");
INSERT INTO ghs_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Hiiremi noi hee, Abi tupu oi gama ttokata habesareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Hiiremi nokoi gama habese oomi noi dzobadzoba sebeni oke sekanama gama aimaqi agoago eeteta. Agoago eeteqi oke qooto teeteqi tumakhameto moitemi nokoi garuba moitemi muunata. ");
INSERT INTO ghs_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Oonita nokoi muuna isanatemi oho huhu ma saaruke paramu quba ttuttuitemi asi sebeni hee eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Qate abi ungapa ota patta muunata oho dzare po ttauseni qate paimane ma khametoho dzareke te isaitara. ");
INSERT INTO ghs_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Oke eetemi Dzesui abi tupu oke dzoobire tuumami noi tumakhametoma gama sisimata peiteqi nagapa Magattani ttoka kokota unateta. ");
INSERT INTO ghs_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Oonita Pariseo ma Satukeo nokoi obaoba teeke moora quba dza eeteta. Oonita nokoi Dzesuke toronaitareiqi noho torota qusuho mumure teeho quba qasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Oonihe noi nokoho noo sigire teeteqi eraiqi hiireta, (Nookao, sure mootomi motaiqabetemi nike mooqi hee, O iihai qidza mootakoiqi hiiremi meenoma naatorai. ");
INSERT INTO ghs_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Qate saunabake haba sautomi nike hee, Poike quu taatakoiqi hiiremi oi paha meenoma naatorai. Oonita qupadzomare, nike qusuke mooqi mumure oonomake isaitoraihe Ohongai bodza mootomi ooraiho qamodzamodzake nike ikanomake eete mooqi teqaha nookami noho mumure naatoraidzara?) ");
INSERT INTO ghs_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Oonita abi naga kheukhauma basesanoma nikei naane quba paha mumure teeho quba qasa hiibaqu? Dzonaho neta mumure biranateta teena oi nikeho qogo naate qaarakoi. Oke hiireqi noi nokoke qaate mainata tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","6","Dzesui tumakhametoma noko sisimata peite oba ttu totaqita qeemata. Qeemaqi Dzesui nokoke pobi hiireta, Pariseo ma Satukeoho patta qanganita oke potti biire qaarare. ");
INSERT INTO ghs_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Hiiremi nokoi sisimaho heeba aimare ruume naate ooqi erake qupadzomata, Oo, Dzesu pattaho noo hiirenita napa heeba aimaama naate sepeke baabe oho iigake hiibi kaqani. ");
INSERT INTO ghs_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Oke qupadzohimi Dzesui gesina naateqi hee, Oe! Nike heeba aimaama naate oho qupake muunaqi noo hiirorai mae? ");
INSERT INTO ghs_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ai tatauma nikehoio kaqani? Bosata abi tupu minanipamu paipu ttausenike dzobadzoba paipuma patta moitemi qidzanatemi nike oho huhu ma saaru asinaitemi samane naateta oke nike ao ruume naatorai mae? ");
INSERT INTO ghs_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Oho qesa dzobadzoba sebenima garuba teeke paha heeba moitemi asi qesa paha paramu naatetaho khooba ao nikeho qupata bamu naate mae? ");
INSERT INTO ghs_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Oonihe anai teqaha patta ma heebaho noo poiqanipamuke hiidzaranihe Pariseo ma Satukeoi tete ikoikonomata abike dzeimoraiho qahura nooke hiibi. ");
INSERT INTO ghs_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Hiiremi nokoho qupa pobiratemi nokoi hee, Oo meeke noi te pattanipaho nooke hiibaranihe Pariseo ma Satukeo oberama sinasina hiiroraiho qahurake pattahota mootoqi hiire, ooiqi noko hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Oonita Dzesui Kiape Piripiho haba pobi neta tuumaqi qaa nagapa Kaisarea oho totaqita biranateta. Biranateqi noi tumakhameto nomeke qasa hiireta, Abiho Isaki anake abi qesai apeniqi hiirorai? ");
INSERT INTO ghs_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Hiiremi nokoi hee, Qesai niike hee, Eria, qesai hee, Dzeremia, qesai hee Too abi tee, qesai paha hee Dzohane sobasoba ooniqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Hiiremi noi noko dzaga bobotoqi hiireta, Qate nikemae anake ikaiqi hiirorai? ");
INSERT INTO ghs_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Hiiremi Siimo Peetoroi eraiqi hiireta, Nii ape bahe Kiristu Ohonga qaraqaranomaho khatanipamu oni. ");
INSERT INTO ghs_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Hiiremi Dzesui noke pobi hiireta, Oore Dzonaho khata Siimo. Oonihe nii teqaha ttokaho sama, mae dzuu koko niimeta oho gesinake saridzaranihe qusu mai nahoi oho khooba niiho quba paanaitemi nii hiire. ");
INSERT INTO ghs_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Oho qubake ana niiho dzapa bamu Siimo hiibaquhe omata mootoqi Peetoroke hiibakoi (oio birikiho isaki). Ma oi teeho quba bamuhe nii qesaho pui naate oonoma hiiremi anai niike hee omaniqi hiire. Hiireqi oma oonomama ana oko ma boto tupu nameke qesa hee ma heeta gootomi oi biiriho isaki naatakoi. Oonita nike oho qaa qogoimaqa Iibadzaho nagapa gama suqobidzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Oonita Peetoro, nii nokoho pui naatemi anai qusuho tete oho kaame niike moitemi nike ttokata saqobaqu oke qusuta qaupuitakoi ma ttokata qahitotaqu oke paha qusuta qaupuitakoi. ");
INSERT INTO ghs_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Oke hiireqi Dzesui tumakhameto nomeke hee, Meeke Kiristui baabakoi ma baatakoiqi hiire baaorai anai oionihe nike eto sepeke abike oho pobi hiibaino. ");
INSERT INTO ghs_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Dzesu Kiristuho khoobai ota paana naatemi noi bodza ooqata sohoroqi eraiqi hiireta, Meenipamu anai Dzerusaremuta tuumamake hu nooho abi mimi ma dzube abi mimi ma qetaqeta abi nokoi anake sesero minake eeteqa teetemi baatakoi. Oonihe baatemi qupi tapari naatemi qoridzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Oke hiiremi Peetoroi noke qaheburoqi qamuni hiireta, Soopara name, nii hiire oi eto biranataino. ");
INSERT INTO ghs_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Oho tete bamu. Hiiremi Dzesui Peetoroke dzaga bobotoqi pobi hiireta, Nii Saataho isakita te Ohongaho teteke qupadzohidzaranihe abihoke qupadzomaqi hiiremi anata qanganate oonita nii papatare. ");
INSERT INTO ghs_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Hiireqi Dzesui burisi eete tumakhameto nomeke gama pobi hiireta, Teei anake iihareiqa sama nome qasumaqi maranga biire anake iiha qaarare. ");
INSERT INTO ghs_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Oi erake eete oorai. Teei sama nomeke qaanatemi noho isaki oi bamu naatakoi, qate teei naho quba eeteqi sama nomeke qaanataama naataqu noi baamu bamu naataqu. ");
INSERT INTO ghs_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Oonita teei ttoka ma haba minarake mai eetare hiireqi oho beedza eetemi oora ma qaara nohoi taatemi apei noke hoobidzaqu? Ma paha qaraqara nohoi bamu naatemi ttuma apema oke paha mai eetaqu? Baamunipamu oonita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Abiho Isaki anai Mai nameho dzapa pobita biranate angero nohoma gama baabakoi. Baaqanoke abi gama ika ma ikake eetorai oho ipi ma habara moitakoi. ");
INSERT INTO ghs_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nookare, nike erana qooro oorai nikehota qesai baataamake ooqi Abiho Isaki anai dzapa pobi nameta baahumi ao nike moorakoi. ");
INSERT INTO ghs_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Oi Dzesui dzapa pobi nomehoke hiire qaasuhimi qupi sikisi naatemi noi ao Peetoro ma Dzakopo ma Dzohane noma noho, nokoke dzeimaqi seike tora kakata peiteta. ");
INSERT INTO ghs_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Peiteqi noi nokoho neseta hiiburomi nese ma penga nohoi ete dzadzaho isaki naateta. Ma ttoba ma sasa nohoi oho qesa dzadza khabanoma kisakisama uhubota. Oke eetemi Mose ma Eriaho birabira noho torota biranate Dzesuma nokoi qesa noo hiirota. ");
INSERT INTO ghs_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","4","Noo hiiromi Peetoroi moomi noho qupa tukubami noo apeke hiibarota hiireqi noi Dzesuke hee, Soopara name, erata ooraqu oio bagenomanita nii hiiremi ana isanate baruba taparike biidzaqu mae? Oi teei nihoni teei Mosehoni qate temu Eriaho. ");
INSERT INTO ghs_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Noo oke noi hiimi dzorobi dzadzanomai baaqi nokoke sengibetemi dzorobi neta totoho teei biranateqi eraiqi hiireta. Eraio qeseba khata nahonita ana noho nookami dzapanomani. Oho qubake nike korabete noho noo nookare. ");
INSERT INTO ghs_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Oiqi hiiremi nokoi ttokata gaipori kotoroqi atti minake eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Oke eetemi Dzesui baaqi nokoke hesate hiireta, Eto atti eetaino, ao qoridzare. ");
INSERT INTO ghs_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hiiremi nokoi nese qusubaiteqi moohimi Dzesu noqeke oota. ");
INSERT INTO ghs_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Qate nokoi gama torata qurahiqi Dzesui nokoke hee, Sehequ qoe! nike nese qooroqi moori oke etoqa abi pobi hiibainohe Abiho Isaki anai baateqa paha eehaha naatemake isanate abi pobi hiibare. ");
INSERT INTO ghs_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Hiiremi tumakhameto tapari noko qasa hiireta, Oonita naane qubake qetaqeta abi nokoi hee, Eriai bosata baaqanoke quba samaneke ttarita mootomake eranomai meenoma naatakoiqi hiireta? ");
INSERT INTO ghs_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Hiiremi noi nokoke hee, Eriai bosa baaqa quba samaneke ttarita mootakoiqi hiirorai oi noo obera baamu. ");
INSERT INTO ghs_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Oonihe naho noorake nookare. Eriaho isaki aoqake baatahe abi samane te noke moo qupadzomara. Baamu, nokoho qupata ibo biranatemi nokoi noke sutasuta ma baata quba mootota. Oonihe nokoi noke eeteta teena oke noko paha Abiho Isaki anake eetemi nokoho botota heme samaneke saridzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Oke Dzesu hiiremi nokoho qupa pobiratemi nokoi hee, Oo Eriahoke noi Dzohane sobasobahota mootoqi hiibi oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Oonita eserisa eseri nokoi qurateqi abi tupu mina saridzemi nokohota abi teei baaqi Dzesuho torota pomai kotorota. ");
INSERT INTO ghs_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Noi hee, Soopara name, naho khatai khettedza naate baate biraboraita nii isanate dzasa eete ana hoobidzaqu mae? Oi khatai saninoke obani mae eepani mai tee ma teeta taatorai. ");
INSERT INTO ghs_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Oke eete qaimi anai noke dzeima baa tumakhameto qesa niihoho dzagata mootomi nokoi noke qidzaita quba bitta eetorai. ");
INSERT INTO ghs_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Oke hiiremi Dzesui misi teeteqi tumakhameto qesa nomeke pobi hiireta, Abi naga obera nikeke anai totohu ma qaqu eetoraiqi bodza ikabete nikeho bisata qaamake nikeho ai tatauma isanataqu? ");
INSERT INTO ghs_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Oke hiireqi noi burisi eete khata oho quba hiireqi hee, Noke dzeima baabare. Hiimi noke dzeima baami songena khataho irina oota noke Dzesu qamuni hiiremi noi noke qaatemi abi khatai bodza ooqata keke qidzanateta. ");
INSERT INTO ghs_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Qidzanatemi Dzesu tumakhameto qesa hiimotota nokoi midzaqo samaqo eete seike Dzesuho torota baaqi qasa hiireta, Khooba apeho qubake nanai songena oke hotou biidzare bittake eete? ");
INSERT INTO ghs_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Hiiremi noi nokoke hee, Oi teeho quba bahe ai tatauma nikehoi isanataama naatemi bittake eete. Oonita tete erake qupadzomare. Ai tatauma mee nikeho torota ooraqu oi paha mina bahe gattiqa, pobidzo gottara teenaqaho isaki ooraquko nike baamu bitta eetaquhe tora oke hee, Papatare ooiqi hiiremi ao papatakoi. Oonomake ete nike baamu quba tee ma teeho bittake eetaqu. ");
INSERT INTO ghs_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Qate nokoi gama Garirea haba ogama tuusuqi Dzesui tumakhameto pobi hiireta, Nokoi Abiho Isaki anake raaba abiho botota mootakoi. ");
INSERT INTO ghs_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Mootomi nokoi anake teetemi baatakoi. Oonihe qupi tapari naatemi qoridzakoi. Noo oke noi hiiremi qupa nokohoi togo minake eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Qate nokoi nagapa Kapanaota biranahimi biiriho ttagetti apiapi teei Peetoroke qaanateqi hee, Qate banaita nikehoi ttagetti oke biidzaama naatorai kaqani. ");
INSERT INTO ghs_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Hiiremi noi hee, Eehe biirorai. Hiireqi noi Dzesu iihata. Oonihe Dzesui ao naga teeta peite oomi noi oho qesa peitemi Dzesui noho ttidza kootorota. Hee, Nii tete apeke qupadzomaqi ttagetti apiapi pobi hiire? Roma mapoho gamani nokoi ttagetti quba hiireqi nagapa nokomeho abike hee, Biidzareiqi hiirorai, mae eo sigina ma garena nokoi bidzareiqi hiirorai? ");
INSERT INTO ghs_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Hiimi noi hee, Sigina ma garena oke meeke hiire. Hiimi Dzesui hee, Oonita Biiriho ttagetti oke nagapa napameho abi ma khata napai naane quba oke biidzaqu? ");
INSERT INTO ghs_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Oonihe eto nokoi oho nookami qanganatainota nii isanate oba ttuta qeemaqa kiito biiremi sekana bosa oona biranataqu oi too kakaratemi ttuma teei ota ooraqu oke nii aima nii ma nakame quba ttagetti biiremi noo oi bamu naatare. ");
INSERT INTO ghs_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Bodza teeta tumakhametoi Dzesuho torota biranate qasa hiireta, Ohonga qusunaho pobita dzuuborai apei ota abi mina naataqu? ");
INSERT INTO ghs_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Hiiremi noi khata gattiqa teeho quba hiireqi noke bisa nokohota upubireta. ");
INSERT INTO ghs_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Noi hee, Nike khameto qupa gaibanamaho teteke qupadzomaqi Qusu Maiho pobita dzuubakoini qate sama qusubaho tete ota ooraama. ");
INSERT INTO ghs_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Teei khata qupa gaibanoma eranomaho qesa naate Ohongaho pobita dzuubaqu dzapa pobi nohoi ooqata biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ma paha teei naho quba eeteqi khata eranomaho qesake aima kokora eetaqu oke eesuhiqa anake kokora eetakoi. ");
INSERT INTO ghs_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Qate teei khata eranomaho qesa anata atimorai noke sesero eetaquko quba bamenoma naatakoi. Noi quba oke eetare boohimi oma mina teeke paru nohota suutoqa noke besata biidzapuko gattiqa isanatarota. ");
INSERT INTO ghs_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Oonita ttokata sesero baura qesa biranatetai biranatorakoi oonihe apenei sesero baura oonoma eetorai nokoho irita peitaqu oio attinomanipamu. ");
INSERT INTO ghs_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Oiqi hiireqi dzesu noo oke qahurata mootoqi eraiqi hiireta. Okoni mae boto niihoi niike qangata dzeimare hiiremi oke geema biireqa qaraqarata qeemaqu tete oi paha gattiqa isanatakoi. Oonihe oi niike qangata dzeima qusubaitemi angeroi niike oko ma boto ma gama eepata biidzaqu oi attinomani! ");
INSERT INTO ghs_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Hiireqi noi qahura oke ipibireqi hee, Nese niihoi niike qangata dzeimare boohima nii oho quba nese oke kotoro sakabami nii qaraqarata dzuubaqu oho qanga baamu. Qate nese oi niike qangata dzeima qusubaitemi noko niike nesema gama eepata biiremi oi bamenomanipamu naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Oho quba abi ma khata qupa gaibanoma eranomaho qesake abi eto nookami quba sepe naatemi dzakidzaki eetainonipamu. Oi nokoho isere abi nokoi qupi ma sau samaneke Ohonga qusu Mai nahoke penga bobotoraita qupadzomare, oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Dzesui hee, Ana oho gootta ma pai teeke hiiremi nike nookami ikanoma naataqu? Abi teeho hoo sipisipi uani hattatti ooqake ohota teei ruume naate qaheubaqu oke eetemi oho mai noi sipisipi qesa minarake qeba neta qaasuhiqa ao hairiamake tuuma temuho qiri eetakoi. ");
INSERT INTO ghs_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Qiri eete saridzeqanoke noi qesa 99 nokoho quba bahe teena ooqaho qubake ttidza qidzaqidza eetakoi. ");
INSERT INTO ghs_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Oho qesa Ohonga Mai nikehoi dza eetemi eto nikehota teenaqai bamu naataino oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Hiireqi Dzesui hee, Qateqa niiho qesa teei kahosa saridzaquko nii ao tuuma noma nipeqeke qesa noo hiireqa nii noke qupanomaitare. Qupanomaitemi noi oke qusubaite pobitaquko, dzoobe nipe qesa dzaira eete oorakoi. ");
INSERT INTO ghs_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Qate noi noo nookaama naatemi nii paha abi teenani mae eseriqake pobi hiiremi nopo niike gainene eete tuuma paha noke qupanomaitemi noi noo apeke hiibaqu oke gaigai nookaqi isere mootomi bai hiibaquho isakiama naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Oonihe abi oi paha tatanga naate nopoho baike hiibaquko nii tuumaqa oko ma boto tupu pobi hiiremi nokoi oho baura eetemi paha nookaama naatemi nii nohoke hee, Raaba abi pasenanomaho isaki ooniqi hiibaridzoni. ");
INSERT INTO ghs_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Oi bosata ana Peetoroke pobi hiireta teena oke ana nike minarake pobi hiire. Nike ttokata abiho torota baura eetemi basesanomake kaame teetemi sutasutaho pobi naatemi Ohongai qaupuitakoi. Qate adzahaha naatemi kaame hiumami oho saqosaqo naataqu oke Ohongai paha qaupuitakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Qate Dzesui hee, Nikehota eserini mae tapari Ohongaho pengata qupa teenaite quba teeho quba pupu hiiremi qusu Mai nahoi moitakoi oke ana meeke nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Oi teeho quba bahe nikehota eserini mae tapari naho quba eeteqi ttutturatemi ana naamae nikeho bisata ooqi qaupuitakoi oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Oke hiiremi Peetoroi baaqi Dzesuho torota qasa hiireta, Soopara name, abiho kahosake dzamutareiqa dzamutakoi oke nii ao hiirorihe noi kahosa eetemi dzamutomi paha ipibiremi dzamuto tuumomi sebeni naatemi paha oonomake dzamutoraquni mae? ");
INSERT INTO ghs_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Hiiremi Dzesui hee, Qupi sebeni ooqake keke ana bamu qaupuitaquhe abi oho kahosake dzamutoraqu bamu oho ipi uhubaqu. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Dzesui ipibireqi eraiqi hiireta, Oi Ohongaho pobi nebe teeta erake eete oorai. Abi qiba teei kokora abi qesa nomeke ttuttuite isaki nokohoke pobitareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hiiremi bosata abi omaho kahosa minanoma teei noho torota biranateta. Oma kahosa nohoi bamenoma huba haba biireta (K10,000,000.00). ");
INSERT INTO ghs_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Oonihe noi kahosa oke teetaquho isakiama naatemi abi qibai hee, Oionita abi oke ata ma khameto ma qepe ma haba noho torona oorai oke gama teenaiteqi ttuma quba mootomi biranatemi oi oma kahosa oho habara naatare. ");
INSERT INTO ghs_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Oke hiiremi abi oi noho torota pomai kotoroqi tti ma sori hiireqi hiireta, O Mai name, nii qaatemi kahosa oke ana gama teetemi bamu naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Hiiremi Mai nohoho baruna heme eetemi noi kokora abi saqoroqi oma kahosa nohoke gama gaubireta. ");
INSERT INTO ghs_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Oonihe gaubiremi kokora abi oi paata biranate kokora abi temu nomeke saridzeta. Saridzeqi noi noke paruta aima pobi hiireta, Ae, oma kahosa nahoho isaki teei niiho torota oorai (K100.00). Oonita oke nii hairiamake oma oke ana moite soubidzare. ");
INSERT INTO ghs_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Hiiremi noi tti ma sori hiireqi hee, Maqoe nii dzauba niime qaasuhimake oma kahosa oke ana gama biire soubidzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Oiqi hiiretahe, temu noi beedzae eete temu nomeke sutasutata mootoqi hee, Ttuma oke nii bosata ana moite soubiremake ana niike saqoromi biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Oonihe qesamane nopohoi oke moohimi nokohota qanganatemi nokoi qeemaqi mai nokomeke oho noo ma pobi gama hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Hiiremi mai noi kokora abi bosabosa noho dzauba eeteqi noho quba hiiremi baami pobi hiireta, Nii kokora abi qanganipa! Nii naho torota tti ma sori hiiremi ana oma kahosa minanipamu niihoke dzamutomi baamu naate. ");
INSERT INTO ghs_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Oonita ana niike ingonaitemi nii oho qesa temu nimeke ingonaitororihe naane quba oke eetaama naate? ");
INSERT INTO ghs_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Oke mai hiiremi nooama naatemi dzauba nohoi peitemi noi sutasuta maimaneho quba hiireqi pobi hiireta, Nike abirake aima heme moite qaamake noi naho ttumaho kahosa (K10,000,000.00) gama teete soubidzare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Gotta ma pai oke Dzesu nokoke pobi hiireqi eraiqi hiireta, Ohongai nikeho kahosa dzamutomi nike oho qesa qesamane nikemeho kahosa quba adzahaha naate gaubidzaama naatemi Qusu Mai nahoi oho isakita nikeke heme moitorakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Oonita Dzesui noo samane oke hiire soubireqi Garerea habake qaateqi Dzotani oba totaqita qeemaqi oba iiha atomaqi Dzutea habaho koridzata biranateta. ");
INSERT INTO ghs_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Oonihe abi samane noke iihami noi heme ma poroba nokohoke gama moo qidzaiteta. ");
INSERT INTO ghs_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Qate Pariseo qesai Dzesuke toronaita quba baaqi qasa hiireta, Abi teei quba naane ma naane quba ata nomeke qaatemi isanataqu mae? ");
INSERT INTO ghs_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Hiiremi noi ipi hiireta, Khoobanipamuta Ohongai nopoke apu ma ata korabeteta oho geeke nike isaitorai mae bamu? ");
INSERT INTO ghs_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Hiireqi noi hee, Oho qubake abi teei ata naatareiqa mai ma pai nomeka qaate ata nomeho torota atima nopo esese sama teena naate qararidzoni. ");
INSERT INTO ghs_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Oho qubake nopoi te maina paina oonidzaranihe Ohongai nopoke teenaitemi sama tetenibai kekenita abi paha ipi oke uhutomi obera naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Hiiremi nokoi hee, Oke nii hiirehe, abi ata nomeke qaatare hiiremi Mosei naane qubake ata qaataquho geebake moiteta? ");
INSERT INTO ghs_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Hiiremi Dzesui hee, Oi teeho quba bahe qiba tatanga nikehoho qubake noi qaatemi atake qaataquho pui teei biranateta oonihe khoobanipamuta tete oke eete qaarara. ");
INSERT INTO ghs_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Oonihe abi teei ata usaqe teeke aimare hiireqi ata bosabosake qaataqu oi pasenata tuumakoi. Qate ata bosabosai bosata pasenake saridzemi noke qaataqu oi paha tete maina. ");
INSERT INTO ghs_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Oke hiiremi tumakhametoi roqobeteqi noke hee, Abi somoroi ata naatemi oi noomaeho angi naatemi kaiponoma naatakoita noi ata naataamake soromoke qaaraquko isanataqu kaqani. ");
INSERT INTO ghs_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Hiiremi Dzesui hee, Nike hiire tete oi abi minaraho quba bamu isanataquhe abi teenani mae eseri nokoi somoroke ooraquko isanatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Oi erahoke ana hiire. Qesake puniamake dzoomami oorai ma qesake abi puni teetemi oho isakita oorai ma qesa teenani mae eseri Ohongaho baura tatanga qere biirorare hiireqi paimaneho hutingi naatorai oonihe abi oonomai samane baamuhe teena mae eseri oho isaki naatorai ooqai onita eto oke nookami samaneho naataino. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Qate abi ma paimane qesai khameto nokomeke aima baaqi Dzesui boto nomeke nokoho irita mooto agoago eetareiqi hiiretahe tumakhameto bai hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Oonihe Dzesui tumakhametoke hee, Ohonga qusunaho pobita dzuuborai oi khameto oonomaho isaki kekenita eto qamuni hiibainohe nokoke dzeimami naho torota baabare. ");
INSERT INTO ghs_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Oke hiireqi noi boto nokoho irita upubire agoago eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Qate abi ttumanoma teei Dzesuho torota baaqi noke qasa hiireta, Banaita name, baura qidza apeke ana eeteqake oho quba qaraqara tatanga saridzaqu? ");
INSERT INTO ghs_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Hiiremi Dzesui hee, Naane qubake nii anake hee baura qidza apeke eetareiqi hiibi? Qidza keke eetorare hiiremi oorai. Hiireqi noi noke toronaiteqi hee, Qate nii qaraqara saridzareiqa hu noo qusubaitaridzo. ");
INSERT INTO ghs_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Hiiremi noi hee, Hu noo apeke nii hiibi? Hiiremi Dzesui hee, Huu noo apeke bahe, Nii eto teete baataino, Nii eto apuata eetaino, Nii eto guume eetaino, ");
INSERT INTO ghs_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nii eto tooi pokhi eetaino, Nii mai pa pai niimeho dzapa qusubaitare, Ma nii sama niimeke kokora eetoraiho isakita qesa nimeke kokora eetorare oke keke qusubaite peitareiqi hiibi. ");
INSERT INTO ghs_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hiiremi abi eehaha noi Dzesu pobi hiireta, Hu noo oke ana gama qusubaite baaoraihe, poma apeke ana riiteqi qaraqara saridzaamani? ");
INSERT INTO ghs_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Oke hiiremi Dzesui hee, Oore, quba tongo niimeke gama ttuttuiteqa oho ttuma quba hiiremi biranatemi ttuma oke nii gama abi habanake moite soubiremi qusuho iisuta niiho isaki peitakoi poma oonomake nii gesina naataamake ooraita oke eete baa anake iihorare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Oonihe abi eehaha quba tongo nohoi minanipamu oomi noo oi noke suqobiremi noi paha papateta. ");
INSERT INTO ghs_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Papatemi Dzesui tumakhametoke pobi hiireta, Oonita moorare, qidzoke abi ttuma ma quruma minanomai Ohonga qusunaho pobita dzuubaqu. ");
INSERT INTO ghs_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Oke ana noo totoho eranomata hiiremi nookare. Hoo kamere noi minanita ikanomake eeteqi noi baako puita dzuuba biranataqu oho tete oorai mae baamuhe qidzoke ttuma minanomai Ohongaho pobita dzuubaqu. ");
INSERT INTO ghs_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Oke hiiremi tumakhameto nookaqi roqobeta minake eete eraiqi hiireta, Qate abi ttumanomai dzuubaquho tete bamu naatemi abi habana minarama nanai ikabeteqi qidzanataqu? ");
INSERT INTO ghs_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Hiiremi Dzesui nokoke asabireqi erake hiireta, Abihota oho tete bamunipamu, qate Ohongai bamu quba tee ma teeho bittake eetaqu. ");
INSERT INTO ghs_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Hiiremi Peetoroi noke pobi hiireta, Nookare, qesa ma nanai niike iihareiqi quba samane nanameke ao tume biiremi bamu naatetanita nanai ikabetaqu? ");
INSERT INTO ghs_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","29","Hiiremi Dzesui noko pobi hiireta, Oho noo ipike ana meenipamuke pobi hiiremi nookare. Apenei mai ma pai, nomamane nanemane, sasemane dzabamane, ata ma khameto, ttoka ma quba bosa nokomeke qaate ana iihorai nookao, nike oke eesuqi oho habarake qaraqara ma quba samane heuheunomake saridze qaarakoi. Oonita Abiho Isaki anai poro qere dzapa pobinoma nameta peitaquho bodzata nikemae oho qesa poro qere tuerebe nikemeta peite hoobire Isirae Abiho tupu tuerebe ma kara nokoke batabidzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Oonihe bosa qobaqoba oberai ipina naatakoini qate ipina qidza qesai bosa qobaqoba naatakoita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Hiireqi Dzesui hee, Oi nebe teeta Ohongaho pobike qahura eranomata ana hiiremi nookare. Ttoka ma haba teeho mai teei saunabake biranate baura abi quba hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hiiremi qesai kaitomaqi hee, Isanate nanai uani kinaho isaki quba ete bodza erata baura niiho eetakoi. Hiiremi noi nokoke dzoo nometa dzoobiremi baura eetota. ");
INSERT INTO ghs_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Qate baura abi isanataama naatemi noi paha naini Kirokota biiranate moohimi qesai sepeke otoba patita qoorota. ");
INSERT INTO ghs_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Qooro oomi noi nokoke hee, Maqa nike oho qesa dzoota tuumaqa baura eetemi surenake ana oho isaki moitakoi. Hiiremi noko tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Qate ete bisata paha abi mooqi teena oke noko pobi hiireta ma oho qesa tiri kirokota abi dzoobiremi noko gama dzoota baura quba tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Oonihe paha ete aparana naahimi mai paha biranate moohimi abi paha qesai sepeke qooro oota. Oomi noi nokoke hee, Nike ikaqi sepeke oorai? ");
INSERT INTO ghs_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Hiiremi nokoi hee, Eo apeno baurake eetaqu, oho beebeke nana eetorai. Hiiremi noi hee, Oionita nike oho qesa dzoo nahota tuumaqa baura eetare oiqi hiiremi tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Qateqa qupi sooromi baura abi gama baami dzooho mai noi baura oho sooparake hee, Pobi hiiremi baura abi ttarita qooromake ana oho ttuma mootakoi. Oonihe ipina qeemaqi baura eetorai nokoke ao bosa moitare. ");
INSERT INTO ghs_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Hiiremi oionita ipina baurata qeemata nokoi bosata qooromi nokoke uani kina moiteta. ");
INSERT INTO ghs_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Qate ipina baurata qeematai gama nokome saridze soubiremi saunabanipamuke qeemata nokoi erake qupadzomata, Oo ipina baurata qeemorike noi uani kina moitenita bosana qeemori nanaho isakike ai peitaqu kaqani. Oonihe bamu, nokoke oho qesa uani kina uani kina keke moite soubireta. ");
INSERT INTO ghs_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Oke eetemi noko maiho nookami qanganatemi eraiqi hiireta, Qesa ma nanai saunabake sohoro baura eetemi ete nana moomi kaipoma baura eete. Qate qesai surenaqake baahumi nii nokoke uani kina moihibiqi nanake kina teena oke keke qonote. ");
INSERT INTO ghs_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hiiremi dzooho mai nokoho teeke hee, Dzaira name, Nii ete eraho nakuta baura eeteqa oho quba kina teeke saridzakoiqi ana hiiremi oke niiho tooi saunabake qaupuite oonita anai te niike sesero eetara. ");
INSERT INTO ghs_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Oonihe ana baruna heenata abi ipinake oho qesa uani kina moitemi oi te niiho noonidzara oi namaehoni. Mae nii noke bisi naateqi hee, Eto noke moitainoiqi hiidzo? ");
INSERT INTO ghs_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Mai hiireta oke Dzesu hiiretanita noi tumakhametoke hee, Qahura oi teeho bahe Ohongaho pobi oho poma teeta oke eete oorai, bosabosa qesai ipina naatakoi ma ipina qesai bosa qoobakoi. ");
INSERT INTO ghs_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","18","Qateqa Dzesui Dzerusaremuta tuumare boohiqi tumakhameto ttuerebe nomeke qaheburoqi pobi hiireta, Nookare, napai Dzerusaremuta tuusubihe Abiho Isaki anake teei geema mootomi anai qetaqeta abi ma Dzube abi mimiho botota taatemi nokoi anake baataho pobiniqi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Oke hiireqa nokoi anake raaba abiho botota mootomi nokoi anake ekepusa eetakoi, gou biidzakoi ma hapahapanaitakoi. Oonihe qupi tapari naatemi anai paha eehaha naate qoridzakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Oonita nokoi gama teteta tuusuhiqi Dzebeteoho khameto Dzakopo ma dzohane, pai nopohoi nopoma gama seike baaqi Dzesuho torota gaipori kotoroqi qasa noo teeke hiibare qupadzomata. ");
INSERT INTO ghs_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Oke eetemi Dzesui hee, Quba apeho dzake eete? Hiiremi noi hee, Ana dza eetemi nii poro qere niimeta peitaqu bodza ota khameto nahoi niiho samaqata oorare, teei mage robenani teei pobi niihota oorare. ");
INSERT INTO ghs_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Hiiremi Dzesui hiireta, Ae ruume mutu nike, naane qasake nike hiire? Quba attinoma anake ttidza kebata aimami nipe paha oho quba isanataqu mae? Hiiremi nopoi hee, Oore nakai isanatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Hiiremi noi nopoke hee, Sehequ qoe! Anake ttidza kebata aimaqu oke nipe gattiqa isanataqu kaqa oonihe Ohonga Mai nahoi teka totaqi ma totaqike abi qesaho quba roibetemi oorai oke naamae oho dzapa hiibaquho tete bamu. ");
INSERT INTO ghs_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Oiqi hiiremi tumakhameto qesai nookaqi Dzakopo ma Dzohane nopoho nookami qanganateta. ");
INSERT INTO ghs_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Oonihe Dzesui nokoke gama ttuttuiteqi eraiqi hiireta, Ttokaho abi mimi bise baisanoma nokoi raaba abi ma kara nokoke soopara eeteqi eema dzeimorai oi poma nokome. ");
INSERT INTO ghs_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Oonihe nikehota tete mainake hiiremi oorai. Oi teei abi mina naatare hiibaqu noi isanate qesaho kokora abi naatare. ");
INSERT INTO ghs_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Oi bosaqobaqoba naataquho tete ikanoma bahe qesaho qaruqaruke eetorare. ");
INSERT INTO ghs_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nookare. Anaio Abiho Isaki oonihe abi qesai anaho kokora eetorareiqi ana te baabara. Baamu, anai abi samaneke kokora eetoraqutoke qaraqara nameke mootoqa abi ingonaitareiqi baaorai. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Oonita nokoi Dzerikho qaateqi Dzerusaremuta peqihimi abi quba mina noke iihata. ");
INSERT INTO ghs_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Iiha tuumami abi eseri ibau khabaunomai Dzesu ma nokoi qeemotaho husu nookaqi too dzoobireqi hiireta, O Sooparara nakame, nii Tabitiho sooro ma sainanita nakaho dzasa eetare. ");
INSERT INTO ghs_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Hiiremi abi tupu mina noko nookaqi qamuni hiireta. Qamuni hiiremi eehe, nopoi beedzae eeteqi sokateqi hiireta, O Tabitiho sooro ma saina, Soopara nakame, meenipake nakaho quba dzaasa eetare. ");
INSERT INTO ghs_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Hiiromi Dzesu roroko biireqi nopoho kira hiireqi hee, Nipe dza eetemi ana quba apeke eetaqu? ");
INSERT INTO ghs_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Hiiremi nopoi hee, Nakai dza eetemi nii nakake nesenomaitare. ");
INSERT INTO ghs_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Oke hiiremi Dzesuho baruna heme eetemi noi boto dzoobire nese nopohoke hesahimi ao paa eeteta. Oke eetemi nopoi noke iihata. ");
INSERT INTO ghs_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Qate Dzesu ma nokoi gama Dzerusaremu dzamoiteqi nagapa gattiqa Bettepage Oriba torana oorai ota biranateta. ");
INSERT INTO ghs_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Biranateqi Dzesui tumakhameto eserike qaru dzoobireta. Noi hee, Nipe tupidza oke riite nagapa gattiqa qee neta oorai ota biranate peqihiqa toogi pai khatanoma suutomi ooraike ota moorakoi. Mooqa nopoke saqoroqake dzeima baabare. ");
INSERT INTO ghs_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Qate teei nipeke hee, Naaneke eetoraiqa hiibaquko nipe noke hee, Oi teeho quba bahe Soopara napahoi oho quba hiire, ooiqi hiiremi bamu bai hiibaquhe nohota bagenoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Oonihe Dzesui oonomake eete hiireta oi teeho quba bahe too abi oho hoore noo hiireqi totoho erake qeeteta. ");
INSERT INTO ghs_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Hee, Toogi pai khatanoma oho heeta abi qiba napahoi keba ma dzapata qeemaqi pobi nomeke mai eetakoi oke Dzerusaremuho mutuma khatake pobi hiiremi nookare. ");
INSERT INTO ghs_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","7","Oiqi qeete oomi tumakhameto eseri nopoi Dzesui hiiretake qusubaiteqi toogi khatanoma dzeima baaqi nokoi sasa nokomeke nopoho irita mootomi Dzesui ota habese nagapata peitemi hoore noo oi meenoma naateta. ");
INSERT INTO ghs_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Qate abi tupu mina nokohota qesai sasa heena nokomeke kuibireqi oke teteta qepe tiiteta ma qesai ee ma eka hehenake geemaqi teteke nee ma bau eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Eetemi noi ota tuumami qesai bosata naa teeteqi noke dzeimami qesai ipi totota. Oonihe nokoi gama garuruiqi, Ohonga dzoobe mina, Tabitiho sooro ma sainai Ohongaho dzaapa oonita noi ao baabe, Buububuu! ");
INSERT INTO ghs_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Oke hiire hiireke tuumaqi Dzerusaremuta peitemi nagapa qiba oho nenai gama roqobeteqi hee, Abi apei era baahubi? ");
INSERT INTO ghs_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Hiiremi abi tupu oi gama kaitomaqi hee, Erai ape bahe Garirea habaho nagapa Nadzarette oho too abi Dzesu oniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Qate Dzesui nagapaho otoba patita biranateqi Ohongaho biirita peiteqi moomi abi oona biiriho kau ma meeme ma nee ma kiridza qesaho baurake mekeqoma eetomi oi pisinisiho tomidza naatemi nohota qanganatemi noi ttumaho qohare oke perebireqi nokoke gama hotou biireta. ");
INSERT INTO ghs_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Noi nokoke hee, Biiri naho oi pupu ma hasa hiibaquho naga ooniqi hiire qeetemi ooraihe nike ikaqi oke ttuma ma kapaho sobadza ttibetorai? Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Qate ibau khabau ma qosu ma pone qesai biirita ooqi Dzesuho torota biranatemi noi nokoke qidzaiteta. ");
INSERT INTO ghs_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Qidzaitemi Dzube abi ma Qetaqeta abi mimi nokoi baura bamenoma oke moota. Ma noko nookami mutu ma khata ma gama biirita ooqi Dzesuho hasa hiireqi hee, Tabitiho sooro ma saina Buububuu! Oiqi hiiremi abi mimi nokoi nookami qanganateta. ");
INSERT INTO ghs_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Qanganatemi nokoi miisi teeteqi Dzesuke hee, Ae nokoi hiiroraike nii nooke mae? Hiiremi noi hee, Oore nookorai. Oonihe qetaqeta teei hee, Khameto koidza ma amenana oorai nokoho too oi Ohongaho dzapake qiraitaquho pobi qetaqeta oke eete ooraike nike ruume naateqi erake hiire mae? ");
INSERT INTO ghs_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hiiremi noko nipanatemi noi nokoke gama gaubireqi nagapa qiba qaate Bettania nagapata peiteqi ota mee qidzanateta. ");
INSERT INTO ghs_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Oonihe iihai mootomi Dzesui qori paha Dzerusaremu ota tuusuhimi noho ttidza saa eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Saa eetemi noi moomi ee dzuna teei oomi noi mee teeke saridzareiqi qeematahe mee bamu, geei keke oota. Oomi nohota isanataama naatemi noi ee dzuna oke baru hiireqi hee, Oionita nii mee qaanatemi abi teei bamu paha niihota mee teeke rumutaqu. Oiqi hiiremi ee dzuna oi ao gee baro eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Eetemi tumakhameto mooqi hee, Ae, ikanomake eeteqi ao baro eete? ");
INSERT INTO ghs_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Hiiremi Dzesui hee, Oio ai tataumaho quba samane, oonita ee dzunai baro eete oi oho qetta ma koko. Oonihe nikemae oho qesa qupa hou peu eetaamake tora mina teeke hee, Nii besa bisata taate bamu naatareiqi hiiremi bamu sapara naataquhe meenoma naatakoita nike oonoma eetaridzoni oke ana bamu nike ikobetaqu. ");
INSERT INTO ghs_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Oonita nike quba teeho quba qasa hiibareiqa oi meenoma naatakoiqi qupadzomaqi qasa hiiremi Ohonga moitakoi. ");
INSERT INTO ghs_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Oonita banaitake eete tuusuhiqi Dzesui biirita peitemi dzube abi ma abi mimi nokoi noke dzaga bobotoqi qasa hiireta, Apei hiiremi nii sinasina hiire tuumorai ma beedzae apema nii obaoba samaneke eetorai? ");
INSERT INTO ghs_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Hiiremi Dzesui kaitomaqi eraiqi hiireta, Oore, ana hiibaridzonihe ana bosa nikeke qasa eetemi oho ipi hiiremake ana hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Hiireqi noi nokoke hee, Dzohane noi sobasoba baura eete qaata oke nike nookami Ohongaho nenani mae abiho nena? Hiiremi nokomae hee, Ae, napai Dzesuke hee, Oi qusuho nenaniqi hiibaquko noi burisi eeteqi hee, Oonita nike naane quba oho basesa eetetaiqa hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Qate napai noke hee, Baamu oi ttokaho nenaniqi hiibaquko abi erana nookorai nokohota qanganipamu naatakoi oi nokoi Dzohanehoke nookami too abinipamu naate qaata. ");
INSERT INTO ghs_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Oke hiireqi nokoi abi tupu oho attike eeteqi Dzesuke pobi hiireta, Maa, Dzohanehoke nana ruumeni. Hiiremi Dzesui hee, Oo, nike oho ipi hiibaama naatemi ana eetoraike paha bamu nike oho khooba pobi hiibaqu. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Hiireqi Dzesui abi naga oke qoqopa eeteqi eraiqi hiireta, Qate nike noorake nookami ikanoma naataqu? Abi teeho khameto eseri oota. Oomi noi bosabosaho torota noo hiireqi hee, Khata name nii poike tuuma dzoota baura eetare. ");
INSERT INTO ghs_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Hiiremi noi hee, Oore mai name, ana tuumakoiqi hiiretahe noi te tuumara. ");
INSERT INTO ghs_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Qate Mai noi paha khata sabike noo teena oke pobi hiireta. Hiiremi noi bai hiiretahe, ipita noho qupa burisi eetemi noi tuumaqi baura eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Oonita nike nookami nopohota apei meeke maiho noo qusubaiteta? Hiimi nokoi hee, Khata sabi noi qusubaiteta. Hiiremi oi nokomaeho khooba paanaitemi Dzesui noko pobi hiireta, Nookao gairuru ma pasenanoma qesai qupa burisi eete Ohongaho pobita dzuubakoihe qate nikei? ");
INSERT INTO ghs_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Oi teeho bahe Dzohane tete qidzake biraitareiqi baata. Baami gairuru ma pasenanoma nokoi noho noo nookaqi qusubaiteta, qate nikei oke heeqata moo nookaqi te qupa burisi eetaranita oho qubake hiire. ");
INSERT INTO ghs_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Hiireqi Dzesui Abi mimi ma qetaqeta abike hee, Ana qahura noo teeke paha hiiremi nookare. Ttoka teeho mai noi bai meeho dzoo eeteta. Eka oke dzaaroqi oke rome biireta. Ma penono gootoqi noi paha bai mee imitaquho isaki korabeteta. Oke eete soubireqi dzoo oke noi abi qesaho botota mootoqi tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Qate bai mee goomaquho bodzata noi qaru khameto qesa nomeke dzoobireqi hee, Tuuma bai mee goomoraihota bai oba naho pobi naataridzo oke aima baabare. ");
INSERT INTO ghs_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Oiqi hiiremi nokoi ota biranatetanihe baura abi nokoi qaru khameto oke aimaqi teeke buribaroke teeteta, teeke omama urupusake eetetani teeke teetemi baateta. ");
INSERT INTO ghs_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Oke eetemi mai pobi nookata oonihe noi paha qaru abi qesa dzoobiremi teena oke eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Qate ipita noi qupa nometa hee, Qidzoke noko khatanipamu nahoho bai hiibaqu. Hiireqi noi noke dzoobiremi tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Oonihe baura abi dzoona oota nokoi khatake mooqi qesa dzahe noo hiireta. Ae, khata erai ipita dzoorake mai eetaridzo. Oonita napai ao noke teete kebaiteqa oke napame quba mai eetare. ");
INSERT INTO ghs_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Hiireqi nokoi khatake karabeteqi teetemi baatemi sasata biireta. ");
INSERT INTO ghs_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","41","Oke hiireqi Dzesu abi mimike hee, Qate nike qupadzomami noho Mai oho pobi nookaqi ikake eetaqu? Hiiremi Dzube abi ma kara nokoi hee, Mai nohoi isanate baaqa abi qanga oke ngausa eeteqa dzoo oke abi qidzaho botota mootomi nokoi oho mee saninoke noke moitorakoi. ");
INSERT INTO ghs_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Oiqi hiiremi Dzesui hee, Oore. Oonihe abinaga nikei sinabidza qetaqeta erake isaite khooba qupadzomorai mae? Oi hee, Naga gosogoso abi nokoi naga gootoqi oma khara teeke bai hiiretahe ikanomake eetemi oma oi ao naga oho ttittira naate oorai? Oi teeho quba bahe Ohonga Sooparaho bauranita napa moohimi bagenomani! ");
INSERT INTO ghs_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Oiqi qeetemi ooraihe oi nikeho khooba paanaitemi Ohongaho pobi oke nikeho botota karabeteqa raaba abiho botota mootomi nokoi oho mee bageke eete soopara eetakoi. ");
INSERT INTO ghs_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(Qate oma ttittira hiibi teei ota haratetaquko rubenga naatakoi qate oi paha abi teeho irita taataquko noke rubengaitakoi.) ");
INSERT INTO ghs_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Hiiremi dzube abi mimi ma Pariseo nokoi qahura noo oke nookami nokoho naateta. ");
INSERT INTO ghs_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Naatemi nokoi ao Dzesuke paruta aimarotahe abi tupu oona oota nokoi nookami Dzesui Ohongaho too abiho isaki naatemi Pariseoma karai nokoho atti eeteqi noke gaubireta. ");
INSERT INTO ghs_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Oke eetemi Dzesui Pariseo ma abi mimi nokoke paha qahura noota bapotopotota. ");
INSERT INTO ghs_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Noi hee, Nebe teeta Ohongaho pobi erake eete oorai. Abi qiba teeho khatai ata naatare boohimi mai oho hoo ma patta roibeteta. ");
INSERT INTO ghs_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Roibeteqi noi qaru abi nomeke dzoobireqi hee, Qesaho dzapa agobake hiiremi oorai tuuma nokoho kira hiiremi ao baaqa ttaike muunare. Hiiremi tuumatahe nokoi goottae eete bai hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Bai hiiremi abi qiba noi qaru abi qesa paha dzoobireta. Noi hee, Tuuma nokoke pobi hiireqa hee, Maqoe, mai noi aoke hoo dzubete pattama khauto uraitemi ooraita baaqa ttaike muunare. ");
INSERT INTO ghs_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","6","Oiqi hiiremi nokoi tuumaqi isere qidza oke moototahe nokoi paha bai hiireta. Teei dzoo tuumata, teei pisinisi nometa tuumata oke eete bamu naateta. Qate qesai qaru abi bisi naateqi nokoke qanga hiireqi teetemi baateta. ");
INSERT INTO ghs_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Oke eetemi abi qiba noi nokoho dzaubake eeteqi ipita qaa qogoima tuumaqi nagapa oke abima gama rubengaite qeeremi ngaura naateta. ");
INSERT INTO ghs_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Qate bodza ooqata noi qaru abi nomeke hee, Maa, bosata dzapa hiireta nokoho dzapa ao bamu naate. ");
INSERT INTO ghs_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Oonita nike tete kosoramu ma apota tuumaqa apene ota oorai nokoke dzeima baa ttaike patta muunare. ");
INSERT INTO ghs_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Oke hiiremi nokoi tuumaqi abi ape ma apeke saridzeta abi qidza ma qanga nokoke dzeimami noko gama dzaira nagata ttutturate pui siire oota. ");
INSERT INTO ghs_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Qate abi qiba noi nakuta qeemaqi abi habese oota nokoma qesa dzaira eetetahe noi moohimi teei ttoba ma sasa oridza eetaamake ooqi sepeke dzuubata. ");
INSERT INTO ghs_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Oonita abi qiba noi noke hee, Dzaira, nii ikanomake eeteqi oridza eetaamake sepeke era baabe? Hiiremi no too saa eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Too saa eetemi abi qibai kokora abi nomeke hee, Abi erake oko ma boto suutoqa sasata biidzare. Oonita noi khaa qupita ooqa too dzosodzoso eete qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Oi teeho quba bahe abi samaneho kirake hiiroraihe te samanei mekeqoma sinabidzata qeemoraidzara. Qesai meeni, qesai too kakaho isankini, qate qesai baamunipamu. ");
INSERT INTO ghs_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Qahura oke Dzesu hiiremi Pariseo nookami nokomaeho isaki naatemi nokoi dzauba eete papeteta. Papeteqi ikanomake eeteqi noke ikobetemi noi noo oberama hiireqa angi nokohota dzuubaqu oho nooke noko suuto saqorota. ");
INSERT INTO ghs_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Oonita nokoi tumakhameto nokomeke Heroteho qesamane ma nokoke dzoobiremi nokoi Dzesuke qoqopa eetare hiireta, Banaita naname, Nii abi tete banaiteqi te abiho nese ma penga quba eete sinasina hiiroraidzaranihe meenipamuke Ohongaho tete biraitorai. ");
INSERT INTO ghs_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Oonita nii nanake noorake pobi hiibare. Nii qupadzomami abi napai Kaisaho quba ttagetti biidzaqu tete oi isanatorai mae? ");
INSERT INTO ghs_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","19","Oke hiiretahe Dzesui ikoiko nokohoke mooqi hiireta, Obera abi, nikei naane quba anake toronaisubi? Nike ttagetti oma teeke anake banaitare. Hiiremi nokoi oma sarara teeke noke moiteta. ");
INSERT INTO ghs_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Moitemi noi hee, Nike moohimi apeho gisigisi ma qetaqeta oho samata geeba mootomi oorai? ");
INSERT INTO ghs_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Hiiremi nokoi hee, oio Kaisahoni. Oke hiiremi Dzesui hee, Oonita nike ao oho ipi hiiremi ooraita napai isanate Kaisaho quba samaneke noke moihiqa Ohongahoke noomaeke moitareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hiiremi nokoi roqobeteqi papateta. ");
INSERT INTO ghs_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","24","Qate Sutukeo, abi naga nokoi erake hiire qaata, Abi teei baateqa bamu paha qoridzaqu, ooiqi hiire qaata, Oonita nokoi Dzesuho torota baaqi noke qoqopa eeteqi noorake hiireta, Banaita, Moseio hee, Abi nanei biidza ma suuna saridzaamake baataquko noma nohoi ttarumi nohoke naate noho quba biidza saridzaridzoniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Oonihe nii moorare, nomamane nanemane sebeni oota. Nane gottai ata naateqi khata saridzaamake baateta. Baatemi noho samai ttarumi nohoke naatetahe noomae oho qesa khata saridzaamake baateta. ");
INSERT INTO ghs_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","27","Oho quba nomamane qesa oke keke eete tuumami noma sabi oho qesa biidza saridzaamake baateta. ");
INSERT INTO ghs_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Oho quba nii nookami qoridzaqu bodzata sebeni nokohota apei atapa oho apui ooraqu? ");
INSERT INTO ghs_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Oke hiiremi Dzesui noko pobi hiireta, Iaqa, nike Ohongaho qetaqeta ma tete ruume naateqi ota oberama hiirorai. ");
INSERT INTO ghs_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Oi teeho bahe abi taateqa qoridzaqu nokoi Ohongaho angeroqaho isaki oonita bamu apu ma ataho teteta qeemaqu. ");
INSERT INTO ghs_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nookare. Ohongai abi qoridzaquho noo teeke hiiremi nike isaiteqi khooba qupadzomorai mae bamu? ");
INSERT INTO ghs_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ohongai hee, Anaio Abarahamu ma Isaka ma Dzakopo nokoho Ohongani qate nokoi naho oko ma boto ooniqi hiireta oonita nike moorare, noi te abi goono naatetaho Ohonga oonidzara, oi nokoi eehahake oorai. ");
INSERT INTO ghs_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Dzesu oke hiiremi oi Satukeoho noo suqobiremi abi tupu oona oota nokoi noho noo quba roqobeteta. ");
INSERT INTO ghs_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Qate Dzesui Satukeoho noo ipi bagenomake hiireqi nokoke suqobiretaho pobike Pariseoi nookaqi noko noho torota ttutturateta. ");
INSERT INTO ghs_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ttutturateqi hu nooho mai teei noke toronaiteqi qasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Banaita name, hu noo minarata ikai qesake riite oorai? ");
INSERT INTO ghs_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Hiiremi Dzesui hee, Nii qupa ma dzaodzao ma iiha ma dzoobidza niimema gama teenaiteqi Ohonga Soopara niimeho dzake eetorare. ");
INSERT INTO ghs_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hu noo oio minaraho qiba oni. ");
INSERT INTO ghs_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Oonihe oho temui erake eete hiirorai. Nii sama niimeho dzasa eetoraiho isakita samaqana niimeho quba dzasa eetorare. ");
INSERT INTO ghs_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Noi hee, noo eseri oio hu nooni mae too abiho qetaqetani mae noo ape ma ape oho qiba ma suba tatanga kekeni. Oiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Oonita Pariseoi gama ota ttutturate oomi Dzesui nokoke qasa hiireta, Kiristui baabakoiqi hiire baaorai noi apeho ttarita baabaqu? ");
INSERT INTO ghs_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Hiiremi nokoi hee, Apeho bahe Tabitiho ttari oni. ");
INSERT INTO ghs_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Hiiremi noi hee, Oke nike hiirehe, noi Tabitiho sooro ma saina oomi ikanomake eeteqi Tabiti noke hee, Soopara namaehoniqi hiireta? ");
INSERT INTO ghs_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Oi teeho bahe Ttabitti hee, Ohonga mai noi Soopara nahoke hee, Nii poro qere nahoho samaqata beebe eete oomake niike ibo eetorai abi oke ana gama ai mootomi nokoi niiho oko sengi naate qaarakoiqi hiire qeetemi oorai. ");
INSERT INTO ghs_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Oonita nike nookami Tabiti Kiristuke hee, Soopara nahoniqi hiireqi ikanomake eeteqi paha noke hee, Sooro ma saina nahoniqi hiibaqu? ");
INSERT INTO ghs_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Oke hiiremi nokoi oho noo ipike ikanoma hiiremi isanatarota, baamu. Oonita nokoi ota koridza biireqi teqaha ipita paha qasa noo teeke noke eetara, baamunipamu. ");
INSERT INTO ghs_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Oonita Dzesui tumakhameto nomeke abi tupuma gama pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Hee, Mosei agobake abi batabire qaataho tekake Pariseo nokoi nokome quba mai eete oorai. ");
INSERT INTO ghs_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Oonita nokoi tooma nike pobi hiirorai oke nike qusubaitaridzoni kaqa. Oonihe noo noko hiirorai oke nokomae qusubaitaamanita nokoi eetoraiho teteke nike eto suimaino. ");
INSERT INTO ghs_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Oi nokoi bame samaneke abiho qereta gosororaihe nokoi bamu abiho bameke teeqake hoobire aimaqu. ");
INSERT INTO ghs_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Oi nokoi baura eetorai oke nokoi abiho nese ma penga quba eetorai. Baura ape bahe, bauraho mumure nokomeho ttokottoko hiire minaiteqi ttoba ma sasa kharake kharerepo qoomorai. ");
INSERT INTO ghs_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Paha nokoi Guhuta peitaquni mae hoo ma patta oho tuputa nokoi qupi samaneke qeemaqa teka bosabosata habesorai. ");
INSERT INTO ghs_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ma nokoi sobadzata tuumami abi qesa nokoke dzapa pobinomaitare hiireqi hee, O dzoobe banaita mimi nanameiqi hiiroraiho dzaodzaoke noko eetorai. ");
INSERT INTO ghs_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Qate nookare, nikei gama noma ma naneho isaki oonita etoqa abi qesai nikeho dzapake qaupuiteqi hee, Banaita mimi nanameiqi hiibaino. Oi Nikeho banaita mina teenai keke oorai oonita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma nikeho mai qusuna teenai ooraiho qubake etoqa abi ttokana ooraike sepeke hee, Maimane nameiqi hiibaino. ");
INSERT INTO ghs_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Oho qesa bosa qobaqoba nikehoi samane bamu. Ana Kiristu teenai nikeho bosa qobaqobanita etoqa abi sepeke hee, Bosaqobaqobaniqi hiibaino. ");
INSERT INTO ghs_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ma paha nikeho teei abi mina naatare hiibaquko noi minaraho kokora eetorare. ");
INSERT INTO ghs_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Oi teei sama nomeke ai peitaqu noke qogobidzakoihe teei sama nomeke ai qurataqu noke ai peitakoi. Noo oke nookare. ");
INSERT INTO ghs_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Oke hiireqi Dzesui burisi eete Pariseo ma qetaqeta abi pobi hiireta, Quba bamenoma nikeho irita peitakoi. Oi teeho quba bahe nike abi ikobeteqi qusuho teteke siirorai. Oi nikemae ota dzuuba quba gottae eetoraihe abi qesai ota dzuubare hiiremi qaanatorai. ");
INSERT INTO ghs_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Idze! Pariseo ma qetaqeta abi nikei Iibadzaho khameto ma ikoikoho maikhametonipamu. Oi nike raaba abihota teeke mai eete Isirae abiho tumakhata naata qubake oho baura minaqipake eetorai. Oonihe noi Isiraeho ttarita qeemami nike noke hobidzaama naatemi noi bitta minake eetemi nike noke Iibadza nagapaho pobi hiiremi suhe nohoio qanganipamu naate oora ma qaara bosana qangama qaatake riitanipamuke eetorai. ");
INSERT INTO ghs_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Iaqa! Nike ibau khabaunomanita ikanomake eeteqi nikei nese qupi nokoke dzeimaqu? Oi nike naru noo nikemeke tatangaitareiqi qaheuba biiriho ttumaho dzapake hiireqi hee, Oio noo mee ma naho naru oi oho qesa mee ooniqi hiirorai. Qate nike abi ikobeteqi biiriqaho dzapa keke hiireqi abi oke oosasama mee hiirorai, oonihe qupata oke nike hee, Baamu, oho mee bamuta ana naru hiire oi qidzoke anake too pasere eetaquiqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Obera abi nike. Nookao, ttuma oi teqaha biirike dzapa pobinomaitoraidzaranihe biiri oio ttuma nomeke dzapa pobinomaitorai. ");
INSERT INTO ghs_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nike oho qesa haqaho kiridza oho dzapa hiireqi naru noo nikemeke ota tatangaitorai. Oonihe nike abi ikobeteqi haqa ooqaho dzapa keke hiireqi naru tatangaitarorike qupa nikemeta saparaitorai. ");
INSERT INTO ghs_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Obera abi nike! Ohongaho haqaio oho kiridza mee hiiroraini qate kiridza oi teqaha haqake mee hiiroraidzara. ");
INSERT INTO ghs_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Oi teei naru noo nomeke tatangaitareiqi haqaho dzapa ota hiibaquko oke hiiqi noo oke haqa ma kiridza ma gama susupu mee hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma teei naru noo nomeke tatangaitareiqi biiriho dzapake hiibaquko oke noi hiiqi biiri keke bahe Ohongai biiriho nakuta oorai noho dzapama gama hiibakoi. Oi biiri ma Ohonga nopoi eseima naruke mee hiiremi naru oke abi gaubidzaquko noke bamu kanabetaqu. ");
INSERT INTO ghs_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Oho qesa teei Qusuho dzapake naruta moosohiqi noi Ohongaho dzapake ota paha mootakoi oi teeho quba bahe oio Ohongaho qopanita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Oonita Pariseo ma qetaqeta abi nikei pattaho qetta ma koko dzapa samaneke totaqi nikeme quba mootoqi totaqike Ohongaho quba mootorai tete oio qidza. Oke nike eetoraridzonihe ai tatauma ma baruna heena ma Ohongaho noo qesaqesake nike naane quba ruume naateqi ota oberanipamu naatorai? Oho ipike nike quba bamenoma saridzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nike baura hiike suranatoraiho abi naga. Nike pui gattiqa riitareiqi kose hee eseqotoraiho isaki. ");
INSERT INTO ghs_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Pariseo ma qetaqeta abi nookare. Nikehota baura teeho nakuta guume ma rasaki tee ma teei oomi nike ikaqi sasaqake sooroqi hee, Qidzaniqi hiirorai. Oke eetoraiho ipike quba attinoma nikeho irita peitakoi. ");
INSERT INTO ghs_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Oonihe nike bauraho ttuba ma qapu oho nakuke akobeteqa sasa oho qesa dzamutomi oi gama sasari bagenoma naataridzonita nese taate moorare. ");
INSERT INTO ghs_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","O Pariseo ma qetaqeta abi. Nikei abi ikobeta minake eetorai. Abi qesai nikeho sasake moohimi sasari khabanomani qate qupa nakuta dzoodzo pikobetorai. ");
INSERT INTO ghs_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Abiho nesei moomi nikei rike ma pobiho isaki oonihe nakuta nikeho rasaki ma ikoiko quba minai ooraita oho ipi ma arike nike saridzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","Dzesui hee, Agobake nikeho uimane neimanei too abi qesake teetemi baate qaata. Oonita nikeho uimane eete qaata oke nike eehahaiteqi hee, Dzaasa, nanai oho bodzata oorapuko nokoke bamu teetarotaiqi hiireqi beubeuma ttaike too abi nokoho qura tupuke nee ma bau eete oho mumure samaneke mootorai. ");
INSERT INTO ghs_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","32","Oke eesuqi nike khooba nikemeke gimutta eeteqi uimane neimanei too abi teete qaataho ttaiqa naate baura oke hee biiremi ipi ma ari oohoho qettai paha nikeho irita taatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nike dzobara ma pusamaho isaki oonita qidzoke eepa tatanga oke potti biidzaqu. Oho qubake nookare. Nike Kaini ma karaho qesamane naateqi Abereke teeteqi qesake teete baaqi musaqike nike naho abi qidza Barakhioho khata Dzakharia noke biiri ma haqaho tukurata teetemi baateta. Oonoma keke eete qaimi noko minaraho dzuui nikeke qomaqoma hiiremi nike oho ipi ma ari saridzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","35","Oi keke bahe ipita nokanoka abi ma sinabidza abi ma too abi ma kara nokoi naho qaru eeteqi nikeho torota biranate naho isere qidza mootomi nike bamu nokoke kanabetaqu baamu. Nike noko ibo eeteqi gabeho biireqa hapahapanaitakoi teetemi baatakoi oke keke eeteqi nagapa samaneta nokoke iihaqi sesero eetorakoi. ");
INSERT INTO ghs_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Quba oi bama abinaga nikeho irita peitakoi oohoke anai bamu nike ikobetaqu. ");
INSERT INTO ghs_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Dzesui tti hiireqi hee, O Dzerusaremu, Dzerusaremu abi, anai too abi samaneke nikeho quba dzoobiremi baaoraihe nike naane quba nokoke teetemi baatorai? Nee pai noi khametoke hira nomeho pesuta ttuttuitoraiho isakita anai nikeho herohero naatarorihe nike oho goottae keke. ");
INSERT INTO ghs_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Dzasa mina, ipita nikeho nagapa togora ma taruku qoridzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Bodza minake nike bamu anake mooraquhe, heme ma bame samaneke saridze qaaraqutoke kebanoke nike moohimi ana biranatakoi. Biranatemi anake nike oho bodzata hee, O dzoobe Ohongaho dzaapa, nii baabe. Dzoobe mina! Oiqi nike hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Oiqi hiireqi Dzesui qaheuba biiri oke qaasuhimi tumakhameto qesai noho torota biranateqi hee, Maqoe, Biiri eraio tatanga qidza bagenomanipamu. ");
INSERT INTO ghs_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Hiiremi noi noko pobi hiireta, Nookao, quba oke nike gama mooraihe, dzasa mina. Oma suu ma hee gooto peitemi oorai oonihe oke gama susupu rubengaitemi huhu ma saaru naatakoi noo oke ana bamu nike dzaheitaqu. ");
INSERT INTO ghs_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Oke hiire Dzesui hapata peiteqi Oriba kakata habeseta. Habese oomi tumakhameto nokoqeke baaqi noke qasa hiireta, Quba biranatakoiqi nii hiire oi bodza apeta biranataqu? Ma nii biranatare boohima mumure apeke abi nanai moohiqa hee, Oo bodza ao bamu naatemi Kiristui baabeiqa hiibaqu? ");
INSERT INTO ghs_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Hiiremi Dzesu noko pobi hiireta, Abi teei eto nike ikobetaino. ");
INSERT INTO ghs_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Oi qesa samanei baaqi abi ikobeteqi hee, Anai Kiristu ooniqi hiibakoi. Hiiremi qesai nookami meeho isaki naatakoihe baamu. ");
INSERT INTO ghs_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Qate qaa samanei biranatakoi ma nike oho pobi ma pati qauna nookorakoihe oi te bodza bamu naataquho qamodzamodza oonidzara oonita eto oho qupake muunaino. ");
INSERT INTO ghs_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Oi quba oonoma samanei biranataridzoni. Haba ma Nagapa teei qaa qogoimami nagapa teei paha nokoma qesa kurebetakoi oi samane naatakoi. Tee ma teeta ttoka ma haba rubabetakoi ma seebe mina samanei biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Oonihe oi suhe bahe quba bamenoma biranataridzoho sohosoho oni. ");
INSERT INTO ghs_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Bodza ota nike dzapa nahoho quba eetemi nagapa abi maina paina samanei nike ibo eetakoi, sesero eetakoi, teetakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Eetemi Bodza ota abi samanei qesamane nokomeke biisi naate qesa geema mootakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bodza ota too abi oberaobera qesai biranateqi abi samaneke ikobetemi oho kabira naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ma oho bodzata abi qesai dzasaho tete qaateqa koiri ma pasenaho sogo naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Qate qesai paha baatigara naate qaamake qidzaitakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Oi naho isere qidza oke ttoka ma haba minaraho abi noo maina painanoma nokoho quba hiire hiireke tuuma qaamake suheqata Ohongaho bodza biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Qate too abi Tanie hiiretaho isakita nike moohimi raaba abi nokoi quba ngiinginoma oke biiriho bisa qaputa upubiremake oi bodza attinoma naatakoi. Oonita oho nooke nike korabete isaiteqa qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Oi bodza ota qesa ma nike Dzutea habana ooraqu nikei ao tora ma hapata sakaba tuumare. ");
INSERT INTO ghs_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Oi teei naga totaqita oomi quba oi biranasuhima noi eto quba nome teeke aimareiqi naga totaqita qeemainohe ao atti tuumare. ");
INSERT INTO ghs_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Qate teei dzoo ma baura eesuhima biranatemi eto noi qepe ma haba nome teeke aimareiqi nagata tuumaino. ");
INSERT INTO ghs_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ao atti tuumare. Qate paimane quranoma ma khameto amenata ooraqu dzasa, bame nokoke suqobidzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Oonihe eto quba oi quu ma utaho bodzata biranatainoiqi pupu hiibare. Ma eto dzumata biranatainoiqi pupu hiibare. ");
INSERT INTO ghs_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Oi teeho quba bahe quba bamenoma qesaqesa biranate baaoraihe erana hiibi isaki oi bame qesa gama susupu riiteqi suqobidzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Oonihe Ohongai abi tupu nomeke qupadzomaqi bodza oke hoteitakoi. Hoteitaama naataquko abi gama susupu dzaete goono naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Oonita bodza ota teei hee, Kiristu oio era, eo noio qeemo oke hiiremi eto nookaino. ");
INSERT INTO ghs_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Oi eraho qubake oho qogo noo minake hiire. Too abi oberaobera qesai biranatakoi ma qesai oberama hee, Anaio Kiristuiqi hiireqi obaoba ma kinisa bamenomama abi minarake iso keke sengibetareiqi ikobetemi abi samanei oho angita dzuubakoi. Oonihe Ohonga abi dzapami oorai nokoqai baamu oho kabira naataqu. ");
INSERT INTO ghs_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Noo oke ana ao nike pobi hiirenita nookaqi ao battigara naatare. ");
INSERT INTO ghs_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Oho qubake abi teei nikeke hee, Moo Kiristui haba habana qerata ooraiqa hiibaquko eto oke qaupuiteqi ota tuumaino. Eo hee. Kiristui suruho dzukudzukuta ooraiqa hiibaquko eto oho noo nookaino. ");
INSERT INTO ghs_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Oi teeho quba bahe baibai aimami haba totaqi ma totaqi gama dzadza eetoraiho qesa Abiho Isaki anai paata biranate oorakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Oi kheekhe ma qaromi kabira kebake kharata moo qupadzomoraiho isakita anaio gutu boto kharanita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Hiireqi Dzesui hee, Qate heme ma bame oho bodza biranahima ete qupi soobakoi. dzasidzaho dzadza sirihakoi, tama ma pomatti uuba taatakoi, qusuho isaki gama rubabetakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Oke eetemi Abiho Isaki anaho mumure qusuta biranatakoi. Oi anai qusuho perettabita beedzae minama biranatemi ttoka ma habaho quni ma mani gama moohiqa tti ma areare hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Oke eetemi anai angero nameke dzoobiremi suu minake huiteqi dzapa naho aimoraqu nokoke haba ika ma ikata oorai oke gama aima ttuttuite soubidzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Hiireqi Dzesui hee, Ee dzunaho qahurake nookare. Oi taa teesuhimi nike mooqi hee, Oho mee biranatare boobiqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Oho qesa ana hiireho qaamodzamodza biranahima nike erake qupadzomare, Oo Kiristuho bodza ao paana naasubiqi hiibaridzoni. ");
INSERT INTO ghs_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Qate abinagarai bamu naataamake noo oi ao gama meenoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nookare, qusu ma ttoka bamu naataridzonihe naho noo oi agoba qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Dzesui hee, Qate ana hiire oho bodzanipamu oke abi ma angeroi gama ruume. Mai naho noqe gesina. ");
INSERT INTO ghs_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nookare. Abiho Isaki anai baabaqu oi Noai qaataho bodzata quba sahasahama biranatetaho qesa naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Oi erake eete oorai. Oba oi soobaamake oomi abi nokoi apu ma ata, qaki ma naki, meera ma dzeuba eete qaami qaami Noai sisimata peiteta oio koridza naateta. ");
INSERT INTO ghs_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Oonita oba soobarotaho ruumeke noko eetomi oi baaqi nokoke gama nukurotanita oho qesa Abiho Isaki anaho bodzata oke eete oorakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Oi abi eseri dzoota baura eesuhimi temuke aimakoi temuke gaubidzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Oho qesa paimane eseri patta khautomi teeke aimakoi teeke gaubidzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Oi anai Sooparanita ana baabaqu bodzanipamuke nike ruume, oho qubake bakena geema qaarare. ");
INSERT INTO ghs_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tete erake qupadzomare. Guume abi teei nagake geemarotaho bodzake nagaho mai qupadzomapuko noi noke nagake qaa aimarota. ");
INSERT INTO ghs_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Oho qubake nike naho beebe eete qaamake Abiho Isaki anai baabakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Oiqi hiireqi Dzesui paha hee, Oonita naga teeho mai noi tuhotuho abi apeke naga soopara upubidzaqu bahe teei nokanokata patta ma quba qesa oho bodzaqata urai eete mooto qaaraqu, abi oonomake upubidzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Oi noi oonomake eete qaamake mai nohoi baaqa moomi noho isaki isanatakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Isanatemi mai noi kokora abi oke quba tongo nomeho soopara mootakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","50","Qate tuhotuho abi noi naga soopara baura eesuqa oberama qupa nometa hee, Mmhm, Mai nahoi qoqotoke baaoraiqi hiireqa saqubema maiho patta ma oba samaneke muuhiqa kokora abi qesa nohoke buribaroke teetaquko oionita noi maiho bodza ruume naasuhimi ao baabakoi. ");
INSERT INTO ghs_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Baaqake kokora abi obera noke rubengaite ikoiko ma obera abiho tupu ngiinginomata biiremi nokomae ota tti ma ttaka hiire too dzootorakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Hiireqi Dzesui hee, Bodza ota qusuho pobi isaki apeta ooraqu bahe oke boseba paimane tteni nokohota mootoqi hiire. Oi teeho bahe nokoi atapa apu pobinoma noke tuuhoroqi atapa oho apu pobihibahiba quba beebe eetota. ");
INSERT INTO ghs_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Eetoqi paimane boto totaqi nokoi nokanokanomanita dzongi ma obaho isakima gama oota. Oonihe boto totaqi nokoi quseripoho isakita dzongike aimatahe te oho oba paramu aimara. ");
INSERT INTO ghs_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Qate apu pobihibahiba noi roroko biire oomi saubapo dzeubami paimaneho nese sidzobetemi meeta. ");
INSERT INTO ghs_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Meeqomi totoho teei biranateqi hee, Nooka, ata pobihibahiba baabeta nike gama tuuma noke saridzare. ");
INSERT INTO ghs_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Hiiremi nokoi nese parara eete qori dzongi nokomeke qeereta. ");
INSERT INTO ghs_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Oonita paimane quseripo obaamake ooqi nokoi qesake pobi hiireta, Idze, nanaho dzongi oba ao bamu naateta nike isakiqata teeke nana moitare. ");
INSERT INTO ghs_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Hiiremi gesina paimane nokoi bai hiireta, Eehe, eto nanaho oba oho qesa bamu naataino oonita nike quruma nagata tuumaqa ota nikeme quba giimare. ");
INSERT INTO ghs_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Hiiremi giimare tuusuhimi ata pobihibahiba noi ao baaqi qesa roibeteqi beebe eetota nokoma gama nagata peite tete siireqi nakuta oho qaki ma naki naateta. ");
INSERT INTO ghs_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Oonita tete siire oomi paimane qesai baaqi too dzoobireqi hiireta, Mai naname, Mai qoe! Nanaho quba tete geemoo! ");
INSERT INTO ghs_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Hiiremi noi hee, Ae, nikeke ana ruumenipamu oonita tuumare. ");
INSERT INTO ghs_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Oiqi hiiretanita tete oke nike qupadzomare. Oi bodza nahoke nike ruumenita oho bakena geema qaarare. ");
INSERT INTO ghs_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Oiqi hiireqi Dzesui nokoke paha hee, Oi paha erake eete oorai. Abi teei kharata tuumare hiireqi kokora abi nomeke gama ttuttuiteqi quba tongo nomeke nokoho botota mootota. ");
INSERT INTO ghs_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Oi nokoi oho isakima pisinisi eetemi meupu biranatareiqi noi baura nokohoho isakike qupadzomaqi kokora abi bosabosake 50 kina moiteta. Ma teeke 20 kina moiteqi noi paha teeke 10 kina moiteta. Moiteqi naga oke qaate tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tuusuhimi bosabosa noi 50 kina nomeke aimaqi ooma pisinisi eetemi oi minanate 100 kina naateta. ");
INSERT INTO ghs_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Oho qesa samaqana nohoi 20 kina nomeke aimaqi ooma baura eetemi oi 50 kina naateta. ");
INSERT INTO ghs_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Qate abi temu noi bisi naate siriba 10 kina mai noke moitemi oota oke sengibeteqi qurabireta. ");
INSERT INTO ghs_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Oke eete qaami kokora abiho mai nokoho isakike pobitareiqi baata. ");
INSERT INTO ghs_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Baami kokora abi bosabosa noi maike dzaga bobotoqi hee, Nii ana 50 kina moitemi ana ooma baura eetemi oi 100 kina naate ooraita mooro. ");
INSERT INTO ghs_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Hiiremi Mai noke hee, Dzoobe kokora abi qidza name. Ana niike isakiqata moitemi nii ooma baura iso keke eete ooraita nii meupu namaehota qeehiqa quba tongo nahoke soopara eetorakoi oke ana nii pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Hiiremi noho samaqana baaqi hiireta, Dzoobe mai, nii anake 20 kina moiteta ooma ana baura eetemi 40 kina biranate nii mooro. ");
INSERT INTO ghs_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Hiiremi mai noke noo teena oke hiireqi hee, Dzoobe kokora abi qidza name, ana niike isakiqata moitemi nii ooma baura iso keke eete ooraita nii meupu namaehota qeehiqa quba tongo nahoke soopara eetorakoi oke ana nii pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Oke hiiremi abi temu 10 kina moiteta noi baaqi hiireta, Mai name, ana nookami nii abi qoredzanomanita nii dzoo ma baura qesa eetaamake oho mee ao dzurutoqi saqubema muunorai. ");
INSERT INTO ghs_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Oonita nii tuusumi ana niiho attike eeteqi nii ana moiteta oke sengibeteqi ttokata qurabireta. Oke ana aima baa moote oonita mooro. ");
INSERT INTO ghs_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Hiiremi mai noke pobi hiireta, Nii kokora abi qanga, seeno ma gau oni. Nii anahoke hee, Abi qoredzanomanita dzoo ma baura qesa eetaamake oho mee ao dzurutoqi saqubema muunoraiqi hiire. ");
INSERT INTO ghs_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Oonita nii hairiamake oma oke ttumaho maimane nokoho botota mootomi nokoi ooma baura eetemi oho patisigi ao minanatarorihe, baamu dzanadzana. ");
INSERT INTO ghs_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Oke hiireqi noi abi qesa pobi hiireta. Ana 10 kina abirake moiteta oke abi temu 100 kina saridze oorai noke moitemi aimare. ");
INSERT INTO ghs_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Oi teei meeupu saridzorai noke ipibire moitemi asuasu naatakoi. Qate teeho isaki gattiqa oomi noi nookami ngiinginoma naatemi quba oke paha noho botota karabetakoi. ");
INSERT INTO ghs_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma nike kokora abi seeno ma gau oke aima hotou biiremi noi khaa qupita too dzootoqi tti ma areare hiibakoi. Oiqi mai hiiretake Dzesu noko pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Dzesui nokoke hee, Oho qubake nookare. Abiho Isaki anai dzapa pobi nameke mai eeteqa qaheuba angeroma gama baaqa poro qere dzadzanoma nameta peitakoi. ");
INSERT INTO ghs_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Peitemi angero nokoi abi tupu maina paina samane ttokana oorai nokoke gama naho dzagata ttuttuitemi hoo sooparai kabira qidza ma qangake batabiroraiho isakita anai nokoke gama batabidzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","34","Batibireqi sipisipi qidzake boto pobi nameta moosohiqa meme basesanomake boto mageta mootakoi. Oi anai abi qiba ooqi abi tupu boto pobi nahota ooraqu nokoke erake pobi hiibakoi, Dzoobe, Ohongai nikeke agoago eetemi ooraita nikeho qubake qaheuba teka agobanipake roibete baaorai pobi oke nike baa mai eete soubidzare. ");
INSERT INTO ghs_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Oi anai dzore ma aabeho isakita oomi nike anake kokora eeteta ma anai oba ma pattaho quba kaipo eetemi nike anake isakinomaiteta. ");
INSERT INTO ghs_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ma anai ttoba ma bareamake oomi nike anake ttoba ma barenomaiteta, ma ana batabata eete oomi nike baaqi naho tteki aimata, ma anai sutasutata oomi nike baaqi anake dzaira eete ttapuiteta. ");
INSERT INTO ghs_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Oke ana hiiremake abi rike ma pobi nokoi kaitomaqi ana pobi hiibakoi, Soopara naname, bodza apeta nana niike moohimi nii patta ma oba quba kaipo eetemi nana niike moiteta? ");
INSERT INTO ghs_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ma bodza apeta nana niike moohimi nii dzore ma aabeho isakita ooqi ttoba ma bareama naatemi nanai niike oho isakinomaiteta? ");
INSERT INTO ghs_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Oho qesa nii bodza apeta batabata eeteta mae sutasutata oomi nanai niike ttapuitareiqi ota qeemata? ");
INSERT INTO ghs_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Oke hiiremake abi qiba anai nike totoho eranomake eete hiibakoi. Meenipamu nike oko ma boto tupu nahota minani mae adzanike oke eeteta oi anake eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Oke ana nokoke pobi hiireqake besesanoma boto magena ooraqu nokoke erake pobi hiibakoi, Nookao eepa tatanga teeke Iibadza ma noho qaru khameto nokoho quba qeeremi qaitorai ota abi ngiinginoma nike tuumare. ");
INSERT INTO ghs_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Oi anai oba ma patta quba kaipo eetemi nike qaanateta. ");
INSERT INTO ghs_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma anai dzore ma aabeho isakita ooqi ttoba ma bareama naatemi nike moomi sutasutata ooqi hemenoma naateta oonihe nike te anaho torota qeemaqi kokora eete ttapuitara, baamu. ");
INSERT INTO ghs_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Oke ana noko pobi hiiremake nokoi kaitomaqi eraiqi hiibakoi, Eehe Soopara naname, bodza apeta nana niike moohimi nii oba ma patta quba kaipo eeteqi dzore ma aabeho isakita ooqi ttoba ma bareama naate hemema ooqi sutasutata oomi nanai niiho kokora eetaama naatemi nii hiire. ");
INSERT INTO ghs_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Hiiremi ana erake noko pobi hiibakoi, Anaho oko ma boto tupuhota minani mae adzanike nike kokora oonomake qaanateta oho qubake nike anake oke qaanateta. Oiqi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Oonita nokoi heme tatangaho pobi naasuhimi abi rike ma pobi nokoi qaraqara tatanga mai eetakoi. ");
INSERT INTO ghs_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Oke eete noo samane nomeke abi oke pobi hiire soubireqi Dzesui tumakhameto nome pobi hiireta. Nookao, paha qupi eseri naatemi Ingona Dzuma biranatemi oionita teei ao anake geema mootomi abi anake hapahapanaitakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Qate bodza ota dzube abi ma Dzuta abi mimi nokoi Kaipa dzube abi minaho otoba patita ttutturateta. ");
INSERT INTO ghs_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ttutturateqi ikanomake eete Dzesuho hibahibata noke anginaiteqi teetemi baataqu oho noo suuto saqorota. ");
INSERT INTO ghs_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Oonihe qaheuba dzumata abi tupu minai eto oho nookami qanganatainoho attike noko eeteqi hee, Dzumata bahe ipita oke eetakoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Qate Dzesui Bettania nagapata peiteqi Siimo, oi bosata pottomunomai qaataraho nagata habese oota. ");
INSERT INTO ghs_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Oomi atapa teei arabasta omaho mangi teeke aimaqi Dzesuho qibata geesubireta. Oonihe oho nakuta oota oi bibi bagenoma ttuma minanoma. ");
INSERT INTO ghs_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Oke eetemi tumakhameto mooqi miisi teeteqi eraiqi hiireta, Ae, oba ttuma minanoma oke naane quba sepeke perebidzaqu? ");
INSERT INTO ghs_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Oho ttuma quba hiibapuko oma mina biranatemi oke abi habanake moitemi isanatarori. ");
INSERT INTO ghs_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Oonihe nokoi hiiretake Dzesui gesina naateqi noko pobi hiireta, Atapa oi quba bagenomanipamuke naho quba eetemi ooraita eto noho nooke hiibaino. ");
INSERT INTO ghs_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nookare, nike abi habanake quba moitareiqa isanate moitorakoi. ");
INSERT INTO ghs_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Qate anai erata bamu agobake ooraqu. Oonita atapa erai eete oi anai baatemi naho dzapa minanipamu naataridzoho hoore ma araqike noi ao eete. ");
INSERT INTO ghs_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Oonita ttoka ma haba minarata nike sinabidza hiire tuumaqu atapa noi ao hoore ma araqi erake eete oho pobike nokoi gama nooka soubidzaridzoni. ");
INSERT INTO ghs_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Totoho oonomata Dzesu hiiremi tumakhameto noho tee, dzapa noho Dzuta noi Khariottaho nena, noi noo oho quba bisi naate dzube abi mimi nokoho torota tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Noi hee, Anai Dzesuke nikeho botota mootaquko nike anake ttuma apeke moitaqu? Hiiremi nokoi oma siriba isaitemi tteutti naatemi nota isanateta. ");
INSERT INTO ghs_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nota isanatemi Dzutai ao Dzesuke ikanomake eeteqi noke dzube abiho botota mootaqu oho tete qirike eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Qate Ingona Dzuma minai soohorotaho dzapa Dzobadzoba Ngorungoru oi biranatemi tumakhametoi Dzesuho torota qasa hiireta, Nii dza eetemi nanai ikata tuumaqa Ingona Dzuumaraho quba roibeteqi napa habese oho patta muunaqu? ");
INSERT INTO ghs_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","19","Hiiremi noi hee, Nipe meusu nagapa ota tuumaqi abi teei ota oorai noke pobi hiibare, Banaita napahoi hee, Naho bodza ao dzamoqa naatenita ana isanate niiho nagata peiteqa tumakhameto namema dzuma erake eetakoiqi hiibare. ");
INSERT INTO ghs_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Dzesui noo oke nopo moitemi oho isakita nopo tuumaqi dzuma oho roiroi eeteta. Oonita ete biiremi Dzesui baaqi tuerebe nomema habese oho dzuma eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","22","Oonita nokoi ttaike patta muuhiqi Dzesui nokoke hee, Sehequ qoe, nikehota teei anake geema mootare boobi oke ana bamu nike ikotetaqu. Hiiremi bame mina noko suqobiremi nokoi gama qasake eeteqi hee, Soopara naname, oi anani mae ape oni? ");
INSERT INTO ghs_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","24","Hiiremi noi hee, Nookao, Abiho Isaki anake teetemi baatakoiqi qetaqeta hiiremi oorai. Oonihe abi ana geema mootaqu noke pai dzoomaama naatapuko isanatarota. Oonita abi oi ape bahe poiqanipamu naho ttubata patta teeke giihibi teena. ");
INSERT INTO ghs_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Hiiremi gemagema abi Dzuta noi hee, Anake nii hiibi mae? Hiimi noi hee, Oore, nii oni. ");
INSERT INTO ghs_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Qate noko patta oke muuna qaasuhiqi Dzesui dzobadzoba usaqe teeke aimaqi agoago eeteqi oke qootoqi tumakhameto moiteqi hiireta, Erai mee nahoho isaki oonita aima muunare. ");
INSERT INTO ghs_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Hiireqi noi paha bai obaho khooru aimaqi agoago eeteqi hiireta, Dzuu nameke minaraho kahosa teeteqi poro tongo erake saqore oonita aima muunare. ");
INSERT INTO ghs_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Oi teeho bahe ana bamu paha eka mee eraho oba muunaquhe Ohonga mai nahoho pobi biranatemake oke ao dzamonoke ana usaqeke muunakoi oke ana meeke nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Oke hiireqi nokoi hasa naa teeke hiire qaasuqi biranate Oriba torata peiteta. ");
INSERT INTO ghs_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","32","Hapa peiteqi Dzesui noko pobi hiireta, Qetaqeta teei Ohonga maihoke hiireqi hee, Anai sipisipi sooparake teetemi kitui sakabakoiqi hiireta. Oho qubake qupi qesaho nakuta qesa ma nikei anake gaubidzakoi. Oonihe ana baate qoridzeqake nikeho bosa qooro Garirea habaho isakita nikeke dzeimorakoi. ");
INSERT INTO ghs_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Hiiremi Peetoroi hiireta, Eehe, qesai niike gaubidzaqu kaqanihe anai bamu. ");
INSERT INTO ghs_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Hiiremi Dzesui hee, Ae, nee ungapa qupi taparike noo hiibaamake nii ao qupi eserike naho bai hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Hiiremi Peetoroi tatanga naateqi hee, Baamu, ana niima nakamae ttaike baatareiqa baatakoi. Hiiremi qesamane nokoi teena oke paha hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","37","Hiire peiteqi nokoi Gesemane dzoota biranateta. Biranateqi Dzesui tumakhameto pobi hiireta, Nike erata habesemake anai isakiqata qeehiqake pupu hiibakoi. Oke hiireqi noi Peetoro ma Dzebetteoho khameto Dzakopo ma Dzohane nokoke dzeima qeehimi qupa bame nohoi peiteqi noke suqobireta. ");
INSERT INTO ghs_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Noi nokoke hee, Qupa bame anake suqobiremi baataquho isaki naateta nike era dzamoqata ooqi anake hoobire baura eetare. ");
INSERT INTO ghs_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Hiiremi qupa bame nohoi noke suqobiremi noi kebanoke qeehiqi ttokata uhesaroqi pupu hiireta, O Mai name, naho dza oi hee, Nii qaatemi ana isaki erake potti bidzareiqi hiibarorihe bamu, nii aoke tete hiiremi oorai. ");
INSERT INTO ghs_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Oke hiireqi qori tumakhameto tapari nokoho torota biranate moohimi nokoho nese sidzobetemi meeta. Meehimi noi Peetoroke tukutoqi hiireta, Nike bodza hoteqata ana hobire baura eetareiqi hiirehe, ikanomani? ");
INSERT INTO ghs_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Oi nikeho dza oi ooraihe sama peperatemi moori. Oonihe eto toronaho kabira naataino hiireqi nike roqoroqo ma sahasahama oorare. ");
INSERT INTO ghs_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Oke hiireqi noi paha tuuma pupu hiireqi hiireta, O Mai name, niiho dza hiiremi isaki erake ana potti biidzaquho tete bamu naatemi anai isanate sama name bagara biidzakoi. ");
INSERT INTO ghs_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Hiireqi noi burisi eete baaqi paha moomi noko nese hiitemi meeqota. ");
INSERT INTO ghs_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Meeqomi noi paha qeemaqi hiireta teena oke paha hiiremi tapari naateta. ");
INSERT INTO ghs_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Oke eete ooqi burisi eete tumakhametoho torota biranate noko pobi hiireta, Nike meerareiqa meerakoihe, Abiho Isaki anaho bodza ao eetemi teei anake geemaqi raaba abiho botota moosobi, ");
INSERT INTO ghs_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","oonita nike qori napa nokoke saridzare. Oio gemagema abi era baahubi nike mooro. ");
INSERT INTO ghs_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Oke hiimi idze, Dzuta nokomaeho tee noi tupu qaanoma oho bosa qooroqi nokoke dzeima baata. Oi Dzuta abiho dzube abi ma abi mimi hiiremi abi qesake ttuttuiteqi qaa dzube ma puraba moitemi nokoi koiri kairiho isakita qeemata. ");
INSERT INTO ghs_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Qate Dzutai abi hoho oke ao suu ma pai mootoqi hiiremi oota. Noi hee, Anai abi kanabetaqu oionita nike noke ango aimareiqi hiiremi oota. ");
INSERT INTO ghs_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Oonita noi Dzesuho dzagata qeemaqi hee, Dzoobe banaita. ");
INSERT INTO ghs_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Oiqi hiireqi noi noke kanabeta. Kanabohimi Dzesu noke hee, Dzaira, ao baura niimeke eetemi bamu naatare. Hiiremi qaa abi ma kara nokoi hairiamake qeemaqi boto dzoobireqi Dzesuke aimata. ");
INSERT INTO ghs_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aihimi Dzesuho tumakhata Peetoroi qaa dzube nomeke quhisata dzeimaqi dzube abi minaho kokora abi toma nohoke dzooto qagamaumata. ");
INSERT INTO ghs_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Qagaumami Dzesui noke hee, Ae, teei qaaho koo ma tanga hesateqake noomae oho kabira naate baatakoita dzube oke paha quhisanaitare. ");
INSERT INTO ghs_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Oi ana Mai nameke qasa hiiremi noi ao hairiamake angero qaa tupu tuerebe ttausen dzoobidzaquho isaki ooraike nii ruumeni kaqa. ");
INSERT INTO ghs_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Qetaqetai ango naho noo hiiremi anai nokoho botota qeemenita oke saparaitaquko ikabetaqu? ");
INSERT INTO ghs_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hiireqi Dzesui burisi eete qaa abi tupu oke hee, Maa, ana guume ma rasaki abi oho qubake nike qaa dzube ma puraba khakhaumaqi anake aimareiqi baahuidzo? Nookao, qupi ma sau samaneke anai Ohongaho biirita abi bapotopoto qaabihe anake nike naane quba ota aimaama naateqi eranomake eete baabe? ");
INSERT INTO ghs_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Oonihe qaheuba too abiho qetaqetai noorake hiiremi ooraiho quba isanatakoi. Oke hiiremi tumakhameto nokoi qupa bitotoqi sakabata. ");
INSERT INTO ghs_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Oonita Dzesuke nokoi suuto noke ekata dzeimaqi dzube abi mina Kaipaho nagata tuumata. Oi Dzuta abi mimi ma qetaqeta abi nokoi ao ota ttutturate oota. ");
INSERT INTO ghs_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","59","Qate Peetoroi Dzesuke ipitotoqi sererahuke dzube abi minaho qahota biranateqi qupa nometa hee, Dzesuke ikake eetequiqi hiireqi kokora abi nohoma nokoi oota. Qate dzube abi mimi ma sinasina tupu mina nokoi gama qiba teenaiteqi Dzesuke teetareiqi qomaqoma apeta hiiremi meenoma naatorota oho obera noo hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Oonihe abi qesai noo oke tuputa paanaitarota nokoi quseriponita batibidza abi bamu nokoho noo nookarota. ");
INSERT INTO ghs_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Oonihe ipita abi eseri nopoke toronaitemi nopoi hiireta, Oo abirai hee, Ohongaho biirike anai ngausa eeteqake qupi tapariho nakuta oke paha gooto soubidzakoiqi hiiremi nakai nookata. ");
INSERT INTO ghs_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nopoi oke hiiremi dzube abi mina noi qoridzeqi Dzesuke qasa hiireta, Nopoi niiho qanga hiiremi nii bamu oho ipike hiibaqu? ");
INSERT INTO ghs_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Hiiremi Dzesui nipanateta, Nipanatemi dzube abi mina noi tatanga naateqi hee, Ohonga qaraqaranomaho pengata ana niike qasa hiire, Nii Ohongaho khata Kiristu ooni mae? ");
INSERT INTO ghs_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Hiiremi Dzesu noke hee, Oke nii meeke hiire. Oonita Abiho Isaki anai ipita poro qere nameta peiteqa qusuho perettabita baahuma nike moorakoi. Oke ana meeke nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Hiiremi dzube abi mina noi noho noo nookami qaganomaho isaki naatemi noi sasa nomeke aima qohateta. Noi hee, Abirai noo qaganoma oke hiiremi napa gama nooketa naane quba paha isere abi teeho qirike eetaqu? ");
INSERT INTO ghs_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Oonita nike nookami ikanoma? Hiiremi nokoi hee, Baamu, noio baataho pobi oni. ");
INSERT INTO ghs_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hiireqi nokoi noke sesero minake eeteqi teeteta, noho irita ekepusa eeteta ma boto nokome sepeiteqi noke buribaroke teeteta. ");
INSERT INTO ghs_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nokoi hee, Oo nii Kiristu ooni kaqa. Oho qubake nanahota apei niike teete oke nii too abiho isakita hiibare. ");
INSERT INTO ghs_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","70","Dzesuke nokoi oonomake teetemi Peetoroi paata kautu eetemi dzube abiho kokora atapa teei baaqi noke pobi hiireta, Nii Dzesu Garireaho nenama nipe oori. Hiiremi noi bai hiireta, Nii hiibike anai khoukhau oni. ");
INSERT INTO ghs_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Hiireqi noi naga pata oke papahimi ota paha teei hee, Oe, Abirai Dzesu Nadzaretteho nenama nopoi oomi ana moori. ");
INSERT INTO ghs_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Hiiremi noi noo nomeke tatangaitareiqi Ohongaho dzapata hiireqi hee, Baamu abi oke ana ruumeni. ");
INSERT INTO ghs_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Oke hiiretahe gattiqa ipita qesa dzamonoke oota nokoi Peetoroho torota qeemaqi hiireta. Maqoe, niiho totoho oi Garirea habahonita oi ao khooba niihoke paanaite. ");
INSERT INTO ghs_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hiiremi noho humamutu peitemi noi hu ma hapa dzongobeteqi baru noo hiireta, Baamunipamu, abi oke ana teqaha gesina naatoraidzarani. Oiqi hiimi oionita nee ungapa noo hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Noo hiireta oi Dzesu bosata hee, Nee ungapa noo hiiremi eseri naataamake oomi nii ao naho bai hiiremi tapari naatakoi oiqi hiiretake Peetoroi qupadzomaqi sigita tuusuhiqi tti minake hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Oonita iihai kharata dzube abi mimi ma Dzuta abi mimi qesa nokoi qupa teenaiteqi Dzesuke baataho pobiniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Oonita noke ekama suutoqi nokoi noke dzeima Pirato Romaho kiape minaho nagapata tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Qate quba oke Dzutai gama moohimi noomaeho qupa khatai noke teetemi siriba tteutti noi bosata dzube abi ma abi mimiho botota aimata oke noi hairiamake burisi eeteqi hiireta, ");
INSERT INTO ghs_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Maqoe, abi qidza rike ma pobi noke ana oberama geema mootomi eto noho dzuu naho irita taatainoho qubake ana oma erake burisi eete. ");
INSERT INTO ghs_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hiiremi nokoi hee, Eehe, oi niiho qubani. Hiiremi noi oma oke nokoho patita biireqi biirike papate tuumaqi mogetomata. ");
INSERT INTO ghs_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Qate dzube abi mimi nokoi oma oke mooqi hee oi baataho ttumanita oke bamu sepeke paha maubata biidzaqu. ");
INSERT INTO ghs_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","8","Hiireqi nokoi oho tete saridzeqi ooma ttoka tteke mai eetemi oio dzore ma aabeho qura tupu naateta. Oke paha qapu tesutesuho ttokaniqi hiire qaatanihe paha oke hee, Kasu, dzuuho sobadzaniqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Oi too abi Dzeremia noi Ohongaho noo qeeteqi eraiqi hiireta, Isirae abi teeho ttuma siriba tteutti oke noko aimaqi ooma ttoka teeke mai eeteta. Oi Ohonga Sooparai hiiremi nokoi qapu tesutesuho ttoka mai eetetaiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Qate Dzesuke nokoi ttoka soopara Piratoho dzagata mootomi noi noke toronaiteta. Noi hee, Nii Dzuta abiho abi qibani mae? ");
INSERT INTO ghs_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Hiimi Dzesui hee, Nii meeke hiire. Hiiremi dzube abi ma Dzutaho abi mimi nokoi noke qoma dzubobiromi noi te oho noo ipi hiibara. ");
INSERT INTO ghs_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Oho qubake Piratoi Dzesu pobi hiireta, Nokoi niike qomoqoma hiiremi nii nookorai mae? ");
INSERT INTO ghs_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Hiiremi Dzesu nipanatemi Pirato pairuru eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Qate Romaho sutasuta nagata Dzuta abi qesaqesai qaatanihe Ingona dzuma minata Romaho ttoka sooparai sutasuta nokohota teeke saqoro qaata. ");
INSERT INTO ghs_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Oi Dzuta abi nokoi teeho dzapa hiiremi noke saqoro qaata. Oonita oho bodzata abi baisanoma teei sutasuta nagata oota, dzapa noho Baraba. ");
INSERT INTO ghs_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Qate Dzuta abi mimi ma karai Piratoho dzagata ttutturate oomi noi nokoke qasa hiireta, Oonita nike dza eetemi anai Barabake saqobaquni mae eo Dzesu apeke Kiristu hiirorai noke saqobaqu? ");
INSERT INTO ghs_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","19","Oonihe Piratoi oho totohota hiireta oi teeho bahe Piratoho ata noi noho samaqata habeseqi noo teeke Pirato moiteqi hee, Nooka, ana qupibake abiraho baku geemaqi moomi noi abi rike ma pobi oonita baku oi ana suqobiremi anai qogo noo niike pobi hiire. Eto nii noke qangaqitaino. Hiiremi Piratoi nookaqi abi tupu ttirenoma nokoke kebaitareiqi Barabaho noo bisata mootota, khooba oioni. ");
INSERT INTO ghs_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Oonihe dzube abi mimi abike kosibeteqi hee, Barabake noi saqobareiqi noke pobi hiibare. Ma noke hee, Dzesuke teetareiqi hiibare. ");
INSERT INTO ghs_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Hiiremi ttoka sooparai hee, Nike dza eetemi ana nopohota apeke saqobaqu? Hiimi nokoi hee, Barabake saqobare. ");
INSERT INTO ghs_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Hiiremi Piratoi hee, Oonihe anai Dzesu Kiristu hiirorai noke ana ikake eetaqu? Hiiremi noko garuruiqi hee, Noke hapahapanaitare. ");
INSERT INTO ghs_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Hiiremi noi hee, Qate baura qanga apeke noi eetemi nike oke hiire? ");
INSERT INTO ghs_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hiiremi nokoi sokateqi hee, Ae, noke hapahapanaitare! Oke noko dzaubama hiiremi Pirato moomi noko noho noo nookaama naatemi eto rasaki mina biranatainoiqi noi hee, Abirake moomi kahosaamanita nike noke quba eesubi oho kahosa eto naho irita peitainoiqi hiireqi noi obata boto nomeke akobetemi oho mumure naateta. ");
INSERT INTO ghs_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Oke eetemi abi tupu nokoi gama hee, Isanate oho kahosa nanaho irita peitare, ma biidza ma suuna nanahota peitare. ");
INSERT INTO ghs_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hiiremi Piratoi nokoho totoho qusubaiteqi Barabake saqorota. Qate noi hiiremi qaa abi nokoi Dzesuke buri ma baroke gabeho biiremi Piratoi moomi isanatemi noi hiiremi qaa abi nokoi Dzesuke hapahapanaitareiqi mai eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mai eeteqi nokoi Dzesuke qaa nagata mootoqi nokoi gama noke rome biireta. ");
INSERT INTO ghs_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nokoi sasa nohoke kuimaqi noke abi qibaho qepuqepu hiireqi qaa abiho sasa topa noke dzaarota. ");
INSERT INTO ghs_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Dzaaroqi nokoi guupa ponedza korabeteqi qiba nohota dzamotoqi saaro teeke noho botota mootoqi noho dzagata pomai kootoroqi hiireta, Oo, nii Dzuta abiho abi qibanita dzoobe dzoobe! ");
INSERT INTO ghs_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Hiireqi nokoi noho irita ekepusa eeteqi saaro aimaqi ooma noke qibata teeteta. ");
INSERT INTO ghs_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Oonita nokoi qepuqepu oke eete soubireqi sasa dzuunoma oke kuimaqi sasa nohoke noke dzaaroqi noke hapahapanaita qubake teteta dzeima tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","33","Qate Dzesui hapahapa oke qere biidzare biita eetemi qaa abi nokoi Kureneo abi teeke pobi hiiremi noi hapahapa nohoke aimata, dzapa noho Siimo. Oke eete qaaramuti nokoi ttoka teeta biranateta oke hee, Gorigotta hiirorai oke paha hee qiba gottaniqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Oonita nokoi Dzesuke oba too bairanoma teeke moitemi etteimatanihe oho bai hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Oonita noko ota noke hapahapanaiteqi ttoba ma sasa nohoho quba baabe biireta. ");
INSERT INTO ghs_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nokoi oke eete soubireqi noke bakena geemata. ");
INSERT INTO ghs_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Qate nokoi ee sabinata qetaqeta teeke qeeteqi qiba suhe nohota oke suutota. Noo oi hee, ERAIO DZESU DZUTA ABIHO ABI QIBA OONIqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Qate nokoi guume abi eserike oho qesa hapahapanaiteqi temuke pobi nohota upubiretani temuke mage neta upubireta. ");
INSERT INTO ghs_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Oke eetemi abi tete kosoramu oona girodzomata nokoi qiba nokomeke baqebeteqi Dzesuke qanga hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Nokoi hee, Iidzo, nii biirike rubengaiteqi qupi tapariho nakuta paha gootakoiqi hiirorai. Qate nii Ohongaho khata ooraiqako sama niime ingonaite isanate hapahapata quratareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Oonita Dzuta abi mimi nokoi dzube abi mimima gama noke qepuqepu hiireqi eraiqi hiireta, ");
INSERT INTO ghs_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Seke moo, qesake noi hoobire baaoraihe qidzoke sama nomeke hoobidzaqu. Qate noi Isirae abiho qiba ooraiqako noi isanate quratemake napa noke qaupuitaridzoni. ");
INSERT INTO ghs_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Oi noi sama nomeke hee, Anai Ohongaho khataniqi hiiretanita noi Ohongake ai tataumami Ohongai noho dzasa eete ingonaitaquni mae? ");
INSERT INTO ghs_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Oiqi hiireta ma paha guume abi noho samaqata hapahapanaiteta nopoi paha oho qesa noke bisebise hiirota. ");
INSERT INTO ghs_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Qate ete bisa ma ttiri kiroko surena oho takurata haba oi gama qupi soorota. ");
INSERT INTO ghs_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Oonihe ttiri kirokota Dzesui totoho minama sokateqi hiireta, Ohonga name, Ohonga name, naane qubake nii anake gaubire oiqi hiireta. Oonihe Heboro noota oho totohoi Eri Eri rema sabakhattani oni. ");
INSERT INTO ghs_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Oke hiiremi qesa dzamonoke qooro oota nokoi oberama nookaqi hee, Noi too abi Eriaho quba hiire ooiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Oho qubake teei ao hairiamake torouma tuumaqi besa bidzaga teeke oba too bairanomata suqobire saaro soramu biiremi noi muunareiqi dzoobire peiteta. ");
INSERT INTO ghs_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Oonihe qesai hee, Oke qaate hapa moohima Eria baabaquni mae baamu. ");
INSERT INTO ghs_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Oonita Dzesui paha sokata minake eeteqi suma khapere eetemi gisi tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Gisi tuumami qaheuba biiriho nakuta ttoba hahari asuasu oi pei neta sohoroqi pisisi eetemi poro ttangaho suruho paana naateta. Paana naatemi ttoka rubabeta minake eetemi oma qesai huhunateta. ");
INSERT INTO ghs_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ma qura tuputa kose qesai takobami qesa baate oota nokoi eehaha naate qoridzeqi biranateta. ");
INSERT INTO ghs_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nokoi meusa nagapa Dzerusaremuta peitemi abi samane nokoke moo gesina naateta. ");
INSERT INTO ghs_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Oonita qaaho pobipobi noi qesamane nomema ota bakena geema oota nokoi tuumu ma quba samane oke mooqi atti minanipamuke eeteqi noi eraiqi hiireta, Meenipamu Dzesuio Ohongaho khataniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Qate Garirea habaho paimane qesai Dzesuke kokora eetareiqi noke iihaqi Dzerusaremuta baata nokoi sererahuke qooroqi mooqota. ");
INSERT INTO ghs_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nokohota Maria Magattaraho nenai oota ma Maria Dzesu ma Dzakopo ma Dzosepe nokoho pai oota ma Dzebetteoho khameto Dzakopo ma Dzohane nopoho pai oho qesa nokoma gama oota. ");
INSERT INTO ghs_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Oonita sure mootomi Dzosepe Arimatteo nagapa nena noi abi dzapa pobinomanihe qupa nometa noi paha Dzesuho tumakhata. ");
INSERT INTO ghs_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Oonita noi baaqi Piratoho torota Dzesuho keba quba qasa hiireta. Hiiremi noi nookami isanatemi noi hapahapata qeemata. ");
INSERT INTO ghs_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Qeemaqi Dzosepe noi ttoba khabanoma sasari aimaqi ooma keba nohoke sengibete qegorota. ");
INSERT INTO ghs_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Sengibeteqi oke aimaqi oma naga nome quba kaibetemi ootaho nakuta mootoqi oma sarara hohonga oke burisi eeteqi tete siireqi papateta. ");
INSERT INTO ghs_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Papahimi Maria Magattaraho nena ma Maria temu nopoi tupidza totaqita oma naga oke mooqota. ");
INSERT INTO ghs_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Qate dzuma bosabosa oi bamu naatemi iihai mootomi Pariseo ma dzube abi mimi nokoi Piratoho torota ttutturateqi Hiireta, ");
INSERT INTO ghs_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Soopara naname, abi ikoikonoma Dzesu noi baataamake ooqi hee, Ana baatemake qupi tapari naatemi ana qoridzakoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Oonita nii hiiremi qaa abi nokoi tuuma oma naga oke simeri bittiteqa bakena geema qaama qupi tapari naatemake isanatakoi. Oi eto tumakhameto nokoi seike baaqi keba oke aimaqi abike ikobeteqi hee, Dzesui baata neta qoridze ooraiqa hiiremi ikoiko ma obera noo nohoi eto minanipamu naataino. ");
INSERT INTO ghs_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Oke hiiremi Piratoi hee, Isanate, qaa abi nokoi nikeho botota ooraita nike hiire teena oke eetare. ");
INSERT INTO ghs_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Hiiremi nokoi tuumaqi simerima tete oke siireqi qaa abi mootomi bakena geema oota. ");
INSERT INTO ghs_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Qate Ingona dzuma mina oi gama baamu naatemi oho iihai mootomi Maria Magattaraho nena ma Maria temu nopoi oma naga oke moorare baata. ");
INSERT INTO ghs_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Baahumi ttoka paha rubabeta minake eetemi qusu neta Ohonga Sooparaho angero teei qurateqi teteta biranate oma sarara oke ai burisi eetemi papatemi angero noi ota habeseta. ");
INSERT INTO ghs_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Qate birabira nohoio baibai aimoraiho isakita oomi sasa nohoi khaba khabarinipamu ooni. ");
INSERT INTO ghs_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Qate qaa abi oona bakena geema oota atti nokoke suqobiremi nokoi baataho isaki naateta. ");
INSERT INTO ghs_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Qate angero noi paimane nopoke pobi hiireta, Eto atti eetaino. Nokoi Dzesuke hapahapahaitemi nipe keba nohoho qirike eetoraihe noi teqaha erata ooraidzara. ");
INSERT INTO ghs_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Noi aoke qoridze eehaha naate ooraita baaqa noi meeqoriho tekake mooro. Oi baamu. ");
INSERT INTO ghs_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Oonita nipe ao hairiamake qeemaqa tumakhameto nohoke pobi hiireqa hee, Dzesui aoke baata neta qoridzeqi eehahake oorai. Noi bosata hee, Ana nikeho bosa qooroqi Garirea habaho isakita nike dzeima qaarakoiqi hiiretake qupadzomaqi tuumaqa noke ota moorare. Oi ana ao noo oke nipe pobi hiire oonita tuumare. ");
INSERT INTO ghs_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hiiremi nopoho qupa tukubami nopo atti uboubo eeteqi hairiamake torouma tuumaqi tumakhameto nohoke oho pobi hiibare qupadzomata. ");
INSERT INTO ghs_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Oonihe Dzesui nopoho bisata biranateqi dzoobe hiireta. Hiiremi nopoi pomai kotoroqi oko nohoke gimutta eeteqi noho hasama gegema hiireta. ");
INSERT INTO ghs_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Oke eetemi Dzesui nopoke pobi hiireta, Eto atti eetainohe tuuma qesamane nahoke pobi hiireqa hee, Nike Garirea habata naamaeke moorareiqi hiibare. Oke hiiremi nopo tuumata. ");
INSERT INTO ghs_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tuumami qaa abi ota bakena geemota nokohota qesai ao Dzerusaremuta tuumaqi dzube abi mimiho torota oho isere gama pobi hiire soubireta. ");
INSERT INTO ghs_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Oho qubake nokoi sinasina tupuho abi mimima gama ttutturateqi nokoho quba ttuma ttuttuiteta. Ttuttuiteqi oke qaa abike moiteqi eraiqi hiireta, Nike abi pobi hiireqa hee, Nanai bakena geema oorihe nanaho nese sidzobetemi tumakhameto nokoi seike saubepota baa keba nohoke guume eete aima tuumeiqa hiibare. ");
INSERT INTO ghs_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Qate ttoka soopara Pirato oho pobi nookaquko nanai noke kebaitakoita nike eto noho attike eetaino. ");
INSERT INTO ghs_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Oke hiiremi qaa abi nokoho sinasina nookaqi ttuma oke aimaqi nokoho noo qusubaiteqi abike ikobeteta. Ikobetemi Dzuta abi minarai nookami tumakhameto nokoi nokoke ikobetetaho isaki naateta. ");
INSERT INTO ghs_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Qate tumakhameto erebeni nokoi Garirea habata tuumaqi tora Dzesui hiiretata biranateta. ");
INSERT INTO ghs_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Biranateqi nokoi noke mooqi noho hasama gegema hiiretahe qesai qupa hou peu eeteta. ");
INSERT INTO ghs_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Oonita qesai hou peu eetemi Dzesui baaqi nokoke eepa moiteqi hiireta, Ohongai anake qusu ma ttoka minaraho Soopara upubiremi ana noorake nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nike tuumaqa abi noo samane nokoke bapotopotoqi nokoke Mai ma Khata ma Qaheuba Sumasaho dzapata asinaiteqa soobare. ");
INSERT INTO ghs_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Noo samane ana nike banaite qaabi oke noko gama banaitemi qusubaite soubidzare. Oonihe nikeqe bahe ana nikema napai qesa gainene eete baura eetoraqu oke nike moorakoi. Eete qaamake bodzai baamu naatakoi. Oiqi Dzesu hiireta. Anaio Rebi Matteo ");
INSERT INTO ghs_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Dzoobe Dzairamane: Dzesu Kiristuho sinabidza khooba erani. ");
INSERT INTO ghs_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Dzesea ma too abiho neta qeeteta sinabidza oi hee, Nookare. Anai qaru abi nameke khata niiho bosata dzoobiremi tuumaqi noi niiho tete roibetakoi. ");
INSERT INTO ghs_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Noho noo totoho haba habanata sokate hiireqi hee, Sooparaho tete minake roibeteqi oko tete nohoke pobitareiqi hiibakoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Oiqi qeetetaho mee era, oi Dzohane sobasoba maikhata noi haba habanata biranate sinabidza hiireqi hee, Abi qupa burisi eete sobasoba oba saridzemi Ohonga nokoho kahosa dzamutareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Hiiremi, Dzutea haba nena ma Dzerusaremu abi nokoi gama susupu noho toro Dzotani obata biranateqi kahosa nokomeke hiire paanaitemi noi nokoke obama soorota. ");
INSERT INTO ghs_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Qate, Dzohanei ttoba kamere siihu suuto qaaqi guru ma here oba muuna qaata. ");
INSERT INTO ghs_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma noi Dzesuho qaamodzamodza hiireta, Teei naho ipina baaqorai noho isaki nahoke suqobiroraita ana subate oko sasa nohoho ekake saqobaquho isaki baamu. ");
INSERT INTO ghs_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Anai nike obama sooromi ooraihe, noi nikeke Qaheuba Sumasama soobakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Oho bodzata Dzesui Garirea habaho nagapa Nadzarette oke qaateqi Dzotani obata baami Dzohane noko obama soorota. ");
INSERT INTO ghs_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sooroqi noi oba neta peite moohimi qusu papahimi Sumasai qusubibiho qesa qurate Dzesuho irita biranateta. ");
INSERT INTO ghs_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Biranatemi qusu neta totoho teei hee, Qeseba khata name, anai niiho nookami bagenomani. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","13","Hiiremi Sumasai Dzesuke qooro teetemi noi haba habanata tuumaqi haba ota kabira idzahubama oomi Saatai noke qupi 40 oho isakita toronaite ootanihe angeroi noho kokora eetomi noi te peperatara. ");
INSERT INTO ghs_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Qateqa, Herotei Dzohaneke sutasutata mootomi Dzesui Garirea habata biranateqi Ohongaho sinabidza hiireqi hee, ");
INSERT INTO ghs_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Bodza ao bamu naatemi Ohongai pobi nomeke mai eesubi. Oonita nike qupa burisi eeteqi sinabidza nooka hiisi eetare. Dzesu oke hiire hiireke tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ma Dzesui Garirea oba ttuuke girodzomaqi moomi khaa apiapi Siimo ma noma noho Atereo nopoi obata dzupuke mootota. ");
INSERT INTO ghs_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Mootomi Dzesu nopo pobi hiireta, Anai nipeke banaitemi nipe abi apiapi naatakoi, oonita baa ana iihare. ");
INSERT INTO ghs_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hiimi nopo ao dzupuke qaateqi noke iihata. ");
INSERT INTO ghs_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iihami Dzesui qeemaqi moomi Dzakopo, oi Dzebeteoho khata ma Dzohane noma noho, nopoi sisimata dzupu uusari eetota. ");
INSERT INTO ghs_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Eetomi noi nopoho kira hiireta. Oonita Dzebeteo mai nopohoi kokora abima sisimita oomi nopoi nokoke qaateqi Dzesuke iihata. ");
INSERT INTO ghs_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Oonita tumakhameto agiagi nokoi Dzesuma noko Kapanao nagapata biranateta. Biranatemi dzuma naatemi, noi guhu dzuubaqi abi banaitemi nokoi noho noo qubake hasaqu eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Oi noi teqaha qetaqeta abiho isaki gattiqata hiibaranihe, maikhatai toobauma hiiroraiho isakita noi nokoke banaiteta. ");
INSERT INTO ghs_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Qate guhu nokohota abi songenanoma teei ooqi, areare hiireqi hiireta, ");
INSERT INTO ghs_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Idze Dzesu Nadzaretteho nena, nii Ohongaho Qaheubananike ana gesinanita nii nanake ikabetaqu? Songena nanake nii ngausa eetare baaorai mae? ");
INSERT INTO ghs_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Hiiremi Dzesui noke qamuni hiireqi hiireta, Nii too pati suutoqa abi oke qaate papatare. ");
INSERT INTO ghs_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Hiiremi, songenai abi oke aima pirupara eete sokata minake eeteqi noke qaate tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tuumami abi guhuna oota nokoi gama roqobeteta. Nokoi qiri eeteqi, qesa qasa hiireta, Idze, oho tete ikanoma? Dzesui maikhataho isakita hiiremi songena ao noho noo qusubaitorai. Oi tete qidzanipamu! ");
INSERT INTO ghs_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","O hiiremi, ango hairiamake dzapa pobi nohoi Garirea haba gegebete soubireta. ");
INSERT INTO ghs_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Qate Dzesui guhuta biranateqi, noi Dzakopo ma Dzohanema noko Siimo ma Atereoho nagata peiteta. ");
INSERT INTO ghs_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Oonihe Siimoho motami humamutu minake eete meeqomi nokoi oho pobi hairiamake Dzesu pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Hiiremi, noi qeemaqi noke botota aima tukuma qoridzemi, humamutu noke qaateta. Qaatemi motami noi nokoho kokora eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Qate ete biiremi sure moosohimi, qesai abi heme ma songenanoma samane noho torota dzeima baata. ");
INSERT INTO ghs_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Baami nagapa mina oho abi gama susupu naga patita ttutturateta. ");
INSERT INTO ghs_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ttutturatemi Dzesui khetedza maina painanoma qidzaiteqi, songena samaneke iihata. Oonihe, songenai noke gesina naatemi noi nokoke qamuni hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","36","Qupibake Dzesu qoridzeqi iihai kharata qeba neta tuumaqi ota pupu hiiremi Siimo ma qesamane noho nokoi noho qiri minake eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Oonita saridzeqi nokoi noke pobi hiireta, Abi samane niiho qirike eetorai. ");
INSERT INTO ghs_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Hiiremi noi hee, Oonihe, nagapa qesa dzamoqana oorai, napa ota tuumaqa ana paha nokoho toro sinabidza hiibakoi. Ooqaho qubake ana biranate oorai, oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Oonita noi Garirea haba ogama soubireqi guhu samane nokohota sinabidza hiireqi songena iiha qaata. ");
INSERT INTO ghs_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Qateqa, abi pottomunoma teei Dzesuho torota biranate pomai kotoroqi dzauri hiireta, Nii anake qidzaitaquho isaki ooraihe, oke niiho dza hiibaqu mae bamu? ");
INSERT INTO ghs_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Hiiremi noi dzaubarike misi teeteqi boto nomeke dzoobire noke hesate hiireta, Ana isanate dza eete, oonita qidzanatare. ");
INSERT INTO ghs_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Hiimi pottomu ao noke qaatemi qidzanateta. ");
INSERT INTO ghs_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","45","Qate Dzesu abi oke dzoobireqi qogo minake hiireta, Nookare, erahoke nii eto abi pobi hiibainonipamu. Oonihe, nii tuuma sama niimeke dzube abi bainaiteqi sama niihoi qidzanate oho kiridza eetare. Oke Mose hiiretanita nii oke eetemake ota khooba paana naatakoi. Oiqi hiireta, oonihe abi oi biranateqi baruna hosohosoma oho noo hiire paanaite soubiremi Dzesui oho quba nagapa mina teeho otoba patita peitare bitta eeteqi qeba neta oota. Oomi abi samane haba totaqi ma totaqina nokoi noho torota biranateta. ");
INSERT INTO ghs_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ipita Dzesui burisi eeteqi Kapanao nagapata biranate naga peite oomi abi oho pobi hiiremi nookata. ");
INSERT INTO ghs_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nookaqi abi samane ttutturate pui siiremi naga patita teka bamu naatemi noi oho isakita nokoke sinabidza hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ma abi eserisa eseri abi sarosaronoma teeke kahoba eete Dzesuho toro biranateta. ");
INSERT INTO ghs_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Oonihe abi tupu minai oomi noko noho dzagata biranatare hou eeteqi, Dzesu oota neta noko naga sigumaqi abi sarosaronoma paraiho heeta meeqoota oke noko aima qurateta. ");
INSERT INTO ghs_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Oonita Dzesui ai tataumaho bedzabedza nokohoke moo qupadzomaqi abi sarosaronomake pobi hiireta, Khata name, ana kahosa niihoke dzamute. ");
INSERT INTO ghs_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Hiiremi qeteqeta abi qesai ota habeseqi qupa nokometa eraiqi qupadzomata, ");
INSERT INTO ghs_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Naane quba noi oonomake hiire? Noo oi qaganomanipamu. Apeho torota kahosa dzaamutaquho isaki oorai? Baamuhe, Ohonga teena. ");
INSERT INTO ghs_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Hiiremi nokoi oonomake qupadzomatake Dzesu ao qupa nometa gesina naate nokoke pobi hiireta, Naane quba nike qupa nikemeta quba oonomake qupadzohibi? ");
INSERT INTO ghs_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Abi sarosaronomake noo apeke pobi hiiremi adzahaha naataqu? Anai hee, Kahosa niihoke dzamuteiqa hiibaqu oni mae hee, Parai niimeke aimaqa qoro tuumareiqa hiibaqu? ");
INSERT INTO ghs_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Oonita anai Abiho Isaki ooqi ttokata kahosake dzaamutaquho isaki ooraike nike gesina naata qubake ana abi sarosaronomake pobi hiireqa hee, ");
INSERT INTO ghs_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Qoridze parai niimeke aimaqa naga niimeta tuumare, oke ana niike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hiimi noi qoridzeqi hairiamake qepe asuasu nomeke qere biire nokoho pengata qeemaqi paata biranateta. Biranatemi nokoi gamaqa pairuru eeteqi Ohongaho hasa hiireqi hee, Ae! Quba oonomake napai teqaha moo qaararani, oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Dzesu paha oba ttuuho pati sigita biranatemi abi tupu noho toro biranatemi noi noko ota banaiteta. ");
INSERT INTO ghs_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ipita noi sosomaqi moomi Rebi, Arapeoho khata noi ttagetti nagata habese baura eetomi noi noke pobi hiireta, Nii ana iihare. Hiiremi noi qoridze quba oke pekha eete noke iihata. ");
INSERT INTO ghs_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ma bodza teeta Dzesui naga nometa patta muunomi ttagetti apiapi ma kahosa abi ma tumakhameto noho noko gama noho toro habese oota, oi abi maina paina noke iiha qaata. ");
INSERT INTO ghs_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Qate Pariseoho qetaqeta abi nokoi moohimi, noi ttagetti apiapi abi ma kahosa abima patta muunoomi nokoi tumakhameto nohoke qasa hiireta, Noi naane quba ttagetti apiapi ma kahosa abima muunorai? ");
INSERT INTO ghs_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Hiiremi Dzesu oke nookaqi noko pobi hiireta, Sama rikenoma nokoi ttottaho quba hiibaamanihe, khettedzanomai hiirorai. Oho qesa anai teqaha abi pobiho quba baabaranihe, kahosa abiho quba baaqorai. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Qate Dzohaneho tumakhameto ma Pariseoho nokoi hutingi naatomi abi qesai baaqi Dzesu qasa hiireta, Dzohaneho tumakhameto ma Pariseoho tumakhameto nokoi gama hutingi naatemi niihoi ikake eeteqi hutingi naataamani? ");
INSERT INTO ghs_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Hiiremi, Dzesui noko qahura noota pobi hiireta, Teei ata naasuhimi noho qesamane noho torota ooqa ikanomake eeteqi nokoi hutingi naataqu? Bamu! Ata naataqu abi noi nokoho toro oomi qidzoke noko hutingi naataqu. ");
INSERT INTO ghs_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Anai ata naataqu abiho qesa oonita ipita anai nokoho neta bamu naatemake nokoi isanate hutingi naatakoi. Baata nomehoke hiireqi oke Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Dzesui noo nomehoke hiireqi erake hiireta, Teei ttoba koko usaqeke ttoba qosanata mooto hiibotaamani. Oke no eetaquko, ttoba kokoi qosanake dzeimami uhubami, pui minanatakoi. ");
INSERT INTO ghs_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Paha teei bai oba usaqeke nuupu agobata uqumaamani. Oke noi eetaquko, bai oba oi nuupuke qausu qohateqa bai oba ma nuupu esese qanganatakoi. Bai oba usaqe (oi sinabidza) oi nuupu usaqe (oi qupa usaqe) oho quba isanatakoi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Qate Dzutaho dzuma teeta Dzesu sepora dzoo bisata tuusumi tumakhameto nohoi oho mee rumutota. ");
INSERT INTO ghs_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Rumuhimi Pariseo nokoi Dzesuke pobi hiireta, Nii moo, dzuma bodzata quba qaganoma oke noko naane quba eetorai? ");
INSERT INTO ghs_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Hiimi noi noko pobi hiireta, Ae! Tabiti qesamane nomema oomi patta bamu naatemi nokoho ttidza saa eetemi noko eetetaho noo nike isaitaamani kaqa. ");
INSERT INTO ghs_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Oi Abiatta dzube abi mina qaata bodzata Tabitiho ttidza uhubami noi Ohongaho nagata peiteqi moomi dzobadzoba Ohongaho dzagana mooto qaata oke dzube abi keke muuna qaata oi oota. Oonihe oke Tatibi noomae aima qesamane nome moiteqi noko gama muunami te kahosa naatara. ");
INSERT INTO ghs_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Hiireqi Dzesui noko pobi hiireta, Ohongai te abike dzumaho quba mootaranihe dzumai abike kokora eetareiqi noi dzuma mootota. ");
INSERT INTO ghs_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Oonita nike moomi Abiho Isaki anai paha dzumaho Sooparanita tumakhameto eesubi oke eto bai hiibaino. ");
INSERT INTO ghs_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Dzesu paha guhu dzuubami abi boto atimanoma teei ota oomi qesai ");
INSERT INTO ghs_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Dzesuke qomaqoma hiiba quba nese dzoobireqi hee, Dzesui noke dzumata korabetaqu, mae bamu? Ooiqi hiire mooqota. ");
INSERT INTO ghs_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mooqomi noi abi boto atimanomake pobi hiireta, Nii bisa qaputa qoobare. ");
INSERT INTO ghs_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Hiireqi noi abi sigina qasa hiireta, Dzumata baura apeke eetaquho qaga oorai? Oi quba qidzake eetaqu, oni mae quba qangake eetaqu? Eo, abiho qaraqarake ingonaitaqu, oni mae abike teete baataqu? Hiiremi nokoi nipanateta. ");
INSERT INTO ghs_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nipanatemi Dzesui dzauba irita nesema asabiremi qupa tatanga nokohoho quba ttidza noho qanganatemi noi abi noke pobi hiireta, Boto niimeke tataitare. Hiiremi noi oke tataitemi boto nohoi ao pobirateta. ");
INSERT INTO ghs_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pobiratemi Pariseo nokoi biranate tuumaqi Heroteho nenama teena naate nokoi ikanomake eeteqi Dzesuke ngausa eetaqu oho gunu ma naru hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Qate Dzesui tumakhameto nomema isakiqata qaheubata, paha ipita oba ttuuqata biranateta. Biranatemi Garirea nena ma Dzutea ma Dzerusaremu nena, ");
INSERT INTO ghs_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ma Itumea ma Dzotani oba qee nena ma Tiro ma Sitona nena, nokoi quba samane noi eete qaataho pobi nookaqi gairanipamu noho torota biranateta. ");
INSERT INTO ghs_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Oonita abi samaneke noi qidzaitemi hemenoma samane noke hesatare beedzae eeteta. Eetemi abi tupu minanipamu oomi noko eto noke qiruqiru bidzainoho quba Dzesui tumakhameto nomeke hee, Sisima teeke roibetareiqi pobi hiiremi noko qusubaitemi noi ota peiteta. ");
INSERT INTO ghs_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Qate songenanoma noko Dzesuke moohiqi dzaga nohota gaipori kotoro areare hiireqi hiireta, Idze! Nii Ohongaho Khatani. ");
INSERT INTO ghs_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Hiiremi noko eto abike noho pobi hiibainoho qogo noo minake noi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ipita Dzesue torata peite noomae gesaho dzake eete nokoho kira hiiremi biranateta. ");
INSERT INTO ghs_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","16","Biranatemi noi abi 12 uhutota. Oi nokoi noho torota qaamake noi noko dzoobiremi sinabidza hiireqa songena iiharota, oho quba noi nokoke uhutota. Qate noi Siimoho dzapake Peetoro (oi Biriki) oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ma Dzebeteoho khameto Dzakopo ma noma Dzohane nopoho dzapake noi Boanege (Paraho isaki) ooniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Attereo ma Piripi ma Battoromeo ma Matteo ma Ttoma ma Dzakopo Arapeoho khata, ma Ttatteo, ma Siimo ");
INSERT INTO ghs_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","21","Kana habaho nena, ma Dzuta Khariotta nena (ikai ipita Dzesuke geema mootota). Nokoke Dzesu uhutota. Qate Dzesu naga teeta peitemi abi tupu paha ttutturatemi nokoi oho quba patta muunare bitta eetemi qesamane nohoi oho pobi nookaqi noke qaanatare qeemaqi hiireta, Noi ao ababarake naate oorai. ");
INSERT INTO ghs_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Hiiremi qeteqeta abi qesai Dzerusaremu neta qurateqi oberama hiireqi hee, Songenaho qibai noho irita ooraimi noi oho beedzaeta songena samaneke iihorai. ");
INSERT INTO ghs_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hiiremi Dzesui nokoho quba hiireqi qahura noota nokoke qasa hiireta, Ikanomake eeteqi Saatai Saatake iihaqu? Baamu. ");
INSERT INTO ghs_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nookare, Haba teeho abi tupu nokoi qesa hu ma koridza biidzaquko, bamu naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma quni ma mani tee nokoi qesa koridza biidzaquko, oi paha bamu naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Oho qesa Saatai sama nomeho ibo eete beedzae nomeke geemapuko noi bamu oorairorihe, ao bamu naatarota. ");
INSERT INTO ghs_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Oonihe, Dzesui Saataho beedzae ao suqobireta oho quba noi hee, Teei bamu sepeke abi qaanomaho nagata peiteqi quruma nohoke saqobaquhe bosata noke suutoqake isanate pobi nohoke saqoromi eehaha naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Oonita ana bamu nike ikobetaqu. Abi kahosa maina paina saridzaqu ma noo qanga qesaqesa hiibaqu oke gama dzamutaquho isaki oorai. ");
INSERT INTO ghs_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Oonihe, teei oonomake Qaheuba Sumasaho baura qanga hiibaqu oke Ohongai bamu dzamutaquhe kahosa oi noho torota qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Hiireta oi teeho quba bahe, qesai oberama hee, Songena teei Dzesuho irita ooraiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Qateqa, Dzesuho pai gotta ma nomamane noho nokoi baaqi paata qooro too dzoobireqi noho kira hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Hiiremi, abi samane habese noke rome biire ooqi hiireta, Pai gootta ma nomamane dzabamane niihoi paata qooroqi niiho haba mooqorai. ");
INSERT INTO ghs_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Hiiremi noi hiireta, Naho pai ma nomamanei apeneni? ");
INSERT INTO ghs_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","35","Hiireqi noke rome biirota nokoke noi moo qeraqera eete hiireta, Ohongaho dzake apei qusubaitorai noio naho noma ma dzaba ma pai, oonita nikemae naho pai ma nomamane dzabamaneho isaki. ");
INSERT INTO ghs_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Dzesui paha oba ttuuho samaqata bosaho eete abi banaitemi noko samanenipamu noke sengibetetaho quba noi sisimata peiteqi oho nakuta habese oba heeta oota. Oomi abi quba mina nokoi gama igasata habeseqi oba pouqata soubireta. ");
INSERT INTO ghs_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Qate noi qahura noota noo samaneke nokoke pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Hiireqi noi hee, Nookare, Bababa eetaqu abi teei bababa eetare biranateta. ");
INSERT INTO ghs_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Biranate bababa eesuhimi goottara qesai tete sigiqata taatemi nee biranate oke muuna bamuiteta. ");
INSERT INTO ghs_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma qesai oma quhirata taasuqi suuna eetetahe, ttoka obera oomi ete peite moomi, ");
INSERT INTO ghs_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","bubuso naatemi noho orotu bamu naatemi ngorubateta. ");
INSERT INTO ghs_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ma gottara qesai baa bisata taatemi baa pei kharanate pesunaitemi goomaama naateta. ");
INSERT INTO ghs_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Qate gottara qesai ttoka bibinomata taate suna eeteqi qesai 30, qesai 60, qesai 100 oho isakita gairai goomata. ");
INSERT INTO ghs_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Hiireqi noi hee, Tomanomai nookare ooiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Noko noke qaasumi noi qesa Tuerebema noko ooqi nokoi noke qahura oho qasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Hiiremi noi noko pobi hiireta, Ohongaho pobi oho noo rurunake nikeho quba paanaitaridzoni. Oonihe sasana oorai nokoho quba oke gama qahura noota keke hiiremi oorai. ");
INSERT INTO ghs_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Oi qetaqetai hee, Kahosa nokohoke Ohonga dzamutainoho quba nokoi qupa burisi eetaama naateqi nesema mooqi moo pobitaama, ma tomama nookaqi nooka pobitaamani. Oiqi qeetemi ooraiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Noi hee, Qahura noo erake nike ruume naate mae? Oonita niike ikanomake eeteqi qahura noo qesaqesa qupadzomaqu? ");
INSERT INTO ghs_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bababa eetaqu abi noi sinabidza nooke bababa eetorai. ");
INSERT INTO ghs_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Noo oke tete sigiqata bababa eesumi, qesai ota ooqi nookahimi Saatai hairiamake baaqi noo nokoho torota bababa eetoraike karabetorai. ");
INSERT INTO ghs_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Oho qesa oma quhirata bababa eesumi nokoi noo oke nookaqi ttidza qidza eeteqi aimorai. ");
INSERT INTO ghs_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Oonihe, nokoho nakuta orotu ooraama naatemi nokoi bodza hoteqata oomi sinabidza nooho quba kaiponi mae uuba ma sakaba biranatemi nokoi ao taatorai. ");
INSERT INTO ghs_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma qesa baa bisata bababa eesumi nokoi noo oke nookorai. ");
INSERT INTO ghs_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Oonihe, ttokaho iiha ma dzoobidza, ma qurumaho ikoiko ma quba qesaho qeraqera oi gama ota peiteqi sinabidza nooke pesunaitemi noo oi meeama naatorai. ");
INSERT INTO ghs_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Qate qesa ttoka bibinomata bababa eetemi, noko noo oke qupata mootomi qesa 30 qesa 60, qesa paha 100 oho isakita mee goomorai. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ma noi noko pobi hiireta, Abi dzongi aima baa oke bamu qapuma uhesabaqu, mae meramera pesuta mootaqu, baamu. ");
INSERT INTO ghs_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","23","Noi isanate oke qohare heeta mootakoi. Oonita quba dzukuna oi gama paana naataquho isaki, ma quba dzahedzahena oi gama paana naataquho isaki oni. Tomanomai nookare! ");
INSERT INTO ghs_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","Hiireqi noi eraiqi hiireta, Quba nike nookaqu oke korabete nookare, Oi nike nooka beedzae eetoraiho isakita mee saridzakoi. Sarihimake nikeke paha moitakoi oi teeho torota isaki baura eesuma Ohongai paha qesa noke moitakoi. Qate teeho neta oho isaki bamu naatemi oke paha noho neta karabetakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Hiireqi noi paha erake hiireta, Nebe teeta Ohongaho pobi erake eete oorai. Abi teei goottara qesa ttokata bababa eeteqa qupibake meeqa etebake qoridzakoi. ");
INSERT INTO ghs_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Oonihe, gottara suuna eete bitotorai oho teteke noi ruumeni. ");
INSERT INTO ghs_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Oi ttoka nomae beedzae moitemi mee eetorai. Bosata suuna biranatemi quhisa ota takobami oho nakuta mee goomorai. ");
INSERT INTO ghs_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Qate, mee ba naatemake rumutaquho bodzata abi oi oho dzube mootakoi. ");
INSERT INTO ghs_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Dzesui hiireta, Ohongaho pobi oke napai quba apeho tomidzata mootaqu? Mae qahura noo apeta hiiremi isanataqu? ");
INSERT INTO ghs_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Oi pobidzo benarai benara minaraho neta gattingaqanita abi oke ttokata aubotaquho isaki. ");
INSERT INTO ghs_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Aubotomi oi peiteqi kuna minarake riiteqi goha dzoobiremi mina naatemi nee ota sumudzatorai. Oho isakita sinabidza gattiqai minanate abi kokora eetakoi. ");
INSERT INTO ghs_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Oonita nokanoka nokohoho isakita noi sinabidzake qahura noo samaneta mootoqi abi minarake pobi hiire qaaqi teqaha qahura nooamake noko pobi hiire qaarara. ");
INSERT INTO ghs_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Oonihe, noi qaheubaqata tumakhameto nomeke oho khooba gama hiire paanaite qaata. ");
INSERT INTO ghs_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Qate oho surenake noi noko pobi hiireta, Napamae oba ttuuho totaqita qeemare. ");
INSERT INTO ghs_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hiireqi noko abi tupu oke aipo biire noi ao sisima nakuta oomi noko paha ota peite noma noko tuusumi sisima qesai paha nokoma gama tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tuusuhimi bapamu mina teei tooromi pouma sisima nakuta quura hee eetare eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Qate noi sisima ipita bosaqure heeta meeqomi nokoi noke tukutoqi pobi hiireta, Banaita, napai dzaetare boohibita nii bamu oho atti eetaqu? ");
INSERT INTO ghs_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hiiremi noi tukubaqi uta qamuni hiireqi oba ttuu pobi hiireta, Nipanate, kebaratare. Hiiremi uta bamu naasumi oba kebaratanipamuke eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Eetemi noi erake noko pobi hiireta, Nike naane quba atti eete? ");
INSERT INTO ghs_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nike ai tatauma saridzaamake oorai mae? Hiiremi nokoho sama suu qooromi noko qesa pobi hiireta, Abirai apeni uta ma oba ttuui oonomake eete noho noo qusubaite? Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Oke hiireqi nokoi oba ttuu totaqita qeemaqi Geraseno habata biranateta. ");
INSERT INTO ghs_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Biranatemi noi sisimata tta eesumi abi songenanoma teei nesetu neta biranateqi noke saridzeta. ");
INSERT INTO ghs_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Oi noi oma nagata qopa koobire qaami abi noke ngibirama suutare bitta minake eete qaata. ");
INSERT INTO ghs_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Oi abi noke bodza ginaqake eka ma ngibirama suutomi noi ngibirake basesa eete ngausa eeteqi eka uhuto qaami abi noke suqobidzaquho isakiama naate qaata. ");
INSERT INTO ghs_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sau samane, qupiba ma etebake noi oma naga ma qeba neta areare hiireqi sama nomeke omama sesero eete qaata. ");
INSERT INTO ghs_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Obete noi Dzesu sererahuke moo torouma baaqi noho dzagata gaipori kotoro sokata minake eete hiireta, ");
INSERT INTO ghs_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","O Dzesu Ohonga qusunanipamuho Khata, nii anake ikabetaqu? Hiiremi Dzesui ao noke hee, Songena, nii noke qaatareiqi hiiremi oho quba noi hiireta, Ana Ohongaho neseta hiibita nii eto anake sesero eetaino. ");
INSERT INTO ghs_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Oonita Dzesu noke qasa hiireta, Dzapa niiho apeni? Hiiremi noi hee, Naho dzapa Huba, oi nanai samaneniqi hiireta, ");
INSERT INTO ghs_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma eto Dzesui nokoke haba kharata dzoobidzaino hiireqi abi oi Dzesuke dzauri minake hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Qateqa, hoo kitu minai qeba neta peku eetomi, noko noke dzauri hiireqi hee, ");
INSERT INTO ghs_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nii nanake hooho neta dzoobiremi nana ota dzuubare. ");
INSERT INTO ghs_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Hiiremi Dzesui qaasumi songenai abi oke qaateqi noko hoota dzuubata. Qate hoo kitu oho dzare 2,000 ootani kaqa. Oomi hoo nokoi hapa rometa sakaba qurate oba ttuuta dzaga susuma baateta. ");
INSERT INTO ghs_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Baatemi hoo soopara sakaba tuumaqi nokoi nagapa ma qeba neta oho pobi hiire paanaitemi qesai quba ota biranatetake moorare baata. ");
INSERT INTO ghs_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Baaqi noko Dzesuho torota biranate moohimi abi songena hubanoma qaata noi ao ttoba dzapire qupa qidzanoma ota habese oomi noko atti eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Eetemi qesa bosata moohita nokoi qesake Dzesui songenanomake eetetaho pobi hiireqi, paha hooho irita quba biranatetaho pobi hiiremi nookata. ");
INSERT INTO ghs_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nookaqi noko Dzesuke hee, Nii nanaho haba qaatareiqi hiireqi noke dzauri minake hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Dzauri hiiromi Dzesui paha sisimata peitake boohimi abi songenanoma qaatati qidzanateta noi noke gainene eetare hiireqi noke pupu hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Hiiremi noi basesa eete eraiqi hiireta, Baamu. Nii nagapa tuumaqa Ohonga Soopara niiho quba dzasa eeteqi niike qidzaite oho pobike nii qesamane niimeke hiire paanaitare. ");
INSERT INTO ghs_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Hiiremi, abi oi burisi eete nagapa 10 oho qibata tuumaqi Dzesu noho quba eetetaho pobike hiire paanaitemi noko gama nooka sahateteta. ");
INSERT INTO ghs_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Obete Dzesui paha sisimata peite oba totaqita qeemaqi igasata oomi abi quba mina noho torota ttutturateta. ");
INSERT INTO ghs_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ttutturatemi guhuho bosa qobaqoba tee, dzapa noho Dzairo, noi baaqi Dzesuke moo oko toro nohota gaipori kotoro tti ma dzauri hiireqi hiireta, ");
INSERT INTO ghs_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Khatata nahoi batabata minake eetemi nii isanate baaqa boto niimeke noho irita mootomi noi qidzanate eehaha naatare. ");
INSERT INTO ghs_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hiiremi noi noma nopo tuusumi abi tupu minanipamu oi noke qahiqahi eete tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","26","Tuumami atapa teei ota oota. Noi tii 12 oho isakita dzuu topoto qaaqi ttotta abi samaneho neta ttuma nomeke biire bamuitemi nokoi noho irita baura eete bitta minake eete qaami noi te qidzanataranihe dzore birama qaata. ");
INSERT INTO ghs_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Noi Dzesuho pobi nookaqi hee, Ana ttoba nohoqake ngingitti eetaquko qidzanatakoiqa hiireqi noi abi tupuho bisata qeemaqi Dzesuho tumeta biranate ttoba nohoke hesateta. ");
INSERT INTO ghs_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hesatemi ao dzuu ipi uhubami heme bamu naatemi sama noho asuratemi noi ao qupadzomata. ");
INSERT INTO ghs_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Obetemi, Dzesuho beedzae teeho irita baura eesutake noi qupadzomaqi abi tupu bisata burisi eeteqi hiireta. Apei naho ttoba hesate? Hiiremi, tumakhameto nohoi hiireta, ");
INSERT INTO ghs_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Abi samane niike qahiqahi eetemi nii moorita ikanoma eeteqi nii hee, Ape anake hesateiqi hiire? ");
INSERT INTO ghs_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Hiiremi apei noke hesatetaho quba noi asabireqi qiri eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Eesuhimi noomaeho irita biranatetake atapa oi ao qupadzomaqi attiubouboma tititi eeteqi, oko toro nohota gaipori kotoro oho mee gama noke hiire paanaiteta. ");
INSERT INTO ghs_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Paanaitemi Dzesu noke pobi hiireta, Atapa, nii ai tataumami niiho sama qidzanate. Oonita heme oi aoke niike gaubiremi nii keba ma dzapata tuumare. Ooiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Dzesu oke hiimi guhuho bosaqobaqobaho abi qesai baaqi hee, Ma, niiho khatata ao baate. Oonita eto banaita sepeke sesero eetaino. ");
INSERT INTO ghs_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Hiimi Dzesu totaqike nookaqi guhuho bosaqobaqoba pobi hiireta, Eto roqobetainohe, nooka hiisi eetare. ");
INSERT INTO ghs_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Hiireqi noi qesa qaanatemi, Peetoro ma Dzakopo ma Dzohane, dzakopoho noma nokoqeke noke gainene eeteqi tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tuumaqi, nokoi guhuho bosaqobaqobaho nagata biranateqi Dzesu husu ma noo aga nookami qesai tti ma ttaka minake hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Hiiremi noi dzuubaqi erake hiireta, Nike naane quba tti ma husu eranoma hiirorai? Oi khatata gattiqai baataamanihe, meerake eetorai. ");
INSERT INTO ghs_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Hiiremi nokoi noke sosoridzo hiireta. Hiiremi noi noko iihami sasata biranatemi noi khatataho mai ma paike dzeimaqi noma oota nokoi gama khatata meeqoota tuputa biranateta. ");
INSERT INTO ghs_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ma khatataho boto aimaqi noi noke hee, Khatata, ana nii pobi hiiremi nii qoridzareiqi hiireta (totoho nometa oke hee, Taritta koumiqi hiireta) ");
INSERT INTO ghs_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Hiiremi khatata noomai qoridze ao ogama tuumami Dzesu nokoke hee, Nike khatata oke patta moitareiqi hiireta. Oonita noko sahasaha minake eetemi Dzesu nokoke qamuni tatanga hiireqi hee, Eto abi minara oho pobi hiiremi nookainoiqi hiireta. Qate khatataho tii bodza sikisi oota. ");
INSERT INTO ghs_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Dzesu haba oke qaatemi noho tumakhameto ipi suutomi noi nagapa khooba nometa biranateta. ");
INSERT INTO ghs_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Qate dzuma biranatemi, noi bosaho eete guhuta abi banaitemi abi samane noho noo nooka hasaqu eeteqi hiireta, Abirai baura samane bamenomanipamuke eetorai. Oonihe noi naga baura abi, Mariaho khata. Noi Dzakopo ma Dzose ma Dzuta ma Siimo nokoho nane oni. Paha dzabamane nohoi napama gama ooraita ika neta noi qubarake aimorai? Ma apei noke bapotopotomi oorai. Oke hiireqi noko noho nookami qanganateta. ");
INSERT INTO ghs_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Qanganatemi Dzesui noko pobi hiireta. Too abi teeho dzapake abi isanate qusubaitoraihe, noi nagapa khooba nometa tuumaquni mae, qesamane nomeho toro biranataquni mae, oko ma boto nomeho toro biranataqu, biranatemi nokoi noho dzapa qusubaitaama. ");
INSERT INTO ghs_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Dzesui oke hiireqi nokoho neta obaoba samane eetare isanataama naateta. Oi minaraho ai tatauma bamu naatemi nota bame eeteta. Oonihe abi eseri tapari heme eetemi noi boto nome nokoho irita mootomi qidzanateta. ");
INSERT INTO ghs_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Qate Dzesu ngeromagi nagapa samaneta abi banaite qaaqi tumakhameto Tuerebe nomeho kira hiireqi noko eseri eserike baura quba dzoobidzare hiireqi songena suqobidzaquho beedzae nokoke moiteta. ");
INSERT INTO ghs_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Moiteqi noi hee, Nike teteho isakita eto quba teeke aimaino, oma baubotaino, oonihe patta ma asike qaateqa sumu keke aimare. ");
INSERT INTO ghs_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Noi hee, Nike isanate oko sasa dzaabakoihe, eto sasa eserike aimainoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Noi hee, Nike nagapa teeta biranate naga teenaqata sumudzate baura eete ooqa nagapa mainata tuumare. ");
INSERT INTO ghs_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Qate nagapa teei nike dzeimaama naate nikeho noo nookaama naataquko nagapa oke qaasuhiqa pomu nikeho okota ooraqu oke tupu teete nokoho khooba paanaitare. ");
INSERT INTO ghs_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Hiiremi tumakhameto noko biranate abi qupa burisi eetaridzoho nooke hiire tuumaqi, ");
INSERT INTO ghs_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","songena samaneke iihaqi abi khetedzanomake bibima suraitemi qidzanateta. ");
INSERT INTO ghs_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Qate Dzesuho dzapa pobi haba gegebetemi abi erake hiireta, Idze, Dzohane sobasoba maikhatake Herote teetemi noi ao baata neta qoridzeqi oho beedzaeta baura bamenoma samane eetorai. ");
INSERT INTO ghs_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","16","Hiiremi Herotei oho pobi nookata. Oonihe, qesai hee, Oi Erianiqi hiiremi qesai paha hee, Noi too abi agobahota teeho qesaniqi hiireta. Qate Herote nooka sahatete erake hiireta, Anai Dzohaneho paru geemami baatetahe, noi ao qoridze oorai mae? ");
INSERT INTO ghs_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Hiireta oi teeho bahe bosata Herotei Piripi, noma nomeho ata Herotia naateta. Naatemi oho quba Dzohane noke pobi hiireta, Noma nimeho ata aimaqu oi quba qaganomani. ");
INSERT INTO ghs_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Hiiremi Herotei noo dzoobiremi Dzohaneke aimaqi sutasuta nagata mootota. Ma Herotia noi Dzohaneho oso ma dzauba minake eete noke teete baatarotahe, Herotei hee, Dzohane abi qidza qaheubananiqi hiireqi atti eete noke herohero eetemi Herotia Dzohaneke teetare bitta eete qaata. Oonihe Herote noi ttidza qidza eeteqi Dzohaneho noo nooka qaatahe, noho qupata ingaqonoma naateta. ");
INSERT INTO ghs_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Qate ipita Herotia Dzohaneke teetarotaho isaki biranateta. Oi Heroteke pai dzoomata oho dzuma biranatemi Herotei oho muuna ma aima eetare hiireqi bosa qobaqoba nomeho quba hiireqi qaaho pobipobi abi ma Garireaho abi dzapa pobinoma nokoke gama dzeimami baata. ");
INSERT INTO ghs_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Baami, Herotiaho khatatai ota dzuubaqi qaki ma qasanidza eetemi qesai Herotema nokoi hoo ma patta muunata nokoi gama moo rumubata. Rumubaqi abi qibai Herotiaho khatata pobi hiireta, Quba minarahota nii teeho dzake eete hiiremake ana nii moitakoi. ");
INSERT INTO ghs_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Hiireqi naru oke noi hiire tatangaiteqi hiireta, Pobi minara naho ooraike nii moo quba apeho dzake eete hiiremake oke ana ao nii moitakoi. ");
INSERT INTO ghs_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Hiiremi Khatatai paata biranate pai nomeke qasa hiireta, Quba apeho qubake ana hiibaqu? Hiimi, noi hee, Dzohane sobasoba maikhata, qiba nohoho quba nii hiibare. Hiiremi, khatata ango hairiamake abi qibaho torota biranate hiireta, ");
INSERT INTO ghs_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ana dza eetemi nii poiqanipamuke Dzohane sobasoba maikhataho paru geema qiba nohoke sabidza heeta mooto ana moitare. ");
INSERT INTO ghs_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Hiiremi, abi qibai dzasa minanipamuke eeteta. Oonihe naru tatanga noi ao hiireta, paha qesai noma patta muunotaho penga qubake noi te khatataho baike hiibara. ");
INSERT INTO ghs_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Oonita noi qaa tupuho dzudzu teeke dzoobireqi hee, Nii qiba gootta nohoke aima baabareiqi hiiremi tuumata. Tuumaqi, noi sutasuta nagata biranate paru nohoke geemaqi qibake sabidzata mooto aima baa khatata moitemi noi oke pai nome moiteta. ");
INSERT INTO ghs_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Qate Dzohaneho tumakhametoi oho pobi nookaqi noko tuumaqi keba nohoke aima oma nagata mootota. Oho qubake Dzesui baura bamenoma eetemi Herote pobi nookaqi qupa muunaqi hee, Dzohane qoridzeqi baura oke eetorai mae, oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Qate Dzesuho qaru abi nokoi noho toro ttutturate nokomae eeteta ma banaiteta oho pobi gama noke hiire paanaiteta. ");
INSERT INTO ghs_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Oonita abi samane tuuma ma baabe eetomi qidzoke noko patta muunarota. Eetemi, noi noko pobi hiireta, Nike ma napamae keke qaheubaqata tuumaqa gattiqa sama qidzanatare. ");
INSERT INTO ghs_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Oonita nokoi sisimata peite nokoqeke qaheubata tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tuusumi abi samane nokoke moo qupadzomaqi nagapa samaneho neta baa sosomaqi nokoke riite teka ota bosa biranateta. ");
INSERT INTO ghs_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Biranatemi Dzesu unate abi tupu mina oke moomi noko sipisipi sooparaamaho isaki naatemi noi nokoho quba dzasa eete noo samane nokoke banaiteta. ");
INSERT INTO ghs_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Banaitomi bodza riitemi tumakhameto nohoi baaqi noke pobi hiireta, Haba erai qanga. Oonita bodza riitemi isanate nii noko dzoobiremi nokoi dzoo ma nagapa qesa dzamonoke oorai ota tuumaqa nokome quba patta ttuma eete muunaqu mae? ");
INSERT INTO ghs_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Hiiremi noi nokoke pobi hiireta, Nikemae noko patta moitare. Hiimi nokoi hee, Nanai isanate tuumaqa sengi eserisa eseriho isakita ttuma eete dzobadzoba aimaqa noko moitemi muunaqu mae? ");
INSERT INTO ghs_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Hiiremi noi hiireta, Dzobadzoba nikeho toro ikabete oorai? Seke moorare. Hiiremi nokoi moo isaiteqi noke pobi hiireta, Eo, boto teena. Qate khaa paha eseriba ooqai oni. ");
INSERT INTO ghs_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Hiiremi, noi nokoke hee, Abi noko tupu maina painake ttokata habesareiqi hiiremi qesa 100, qesa 50, oi oho isakita noko ttarita habeseta. ");
INSERT INTO ghs_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Habese oomi, noi dzobadzoba boto teena ma khaa eseri oke aimaqi qusuke moo agoago hiireqi dzobadzobake qootoqi dzoo mutu mootomi tumakhameto nohoi oke pattabete abi moiteta. Moitemi noi paha khaa eseri oke nokoho quba gama pattabeteta. ");
INSERT INTO ghs_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Oonita noko gama patta muunaqi qura eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","44","Ma noko patta saru ttuttuitemi asi 12 hee baata ma khaa qetta qesa oota. Qate dzobadzobake muunata abi ungapa oho dzare 5,000 naateta. ");
INSERT INTO ghs_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Oke eete soubire Dzesu tumakhameto nomeke dzoobiremi sisimata peiteqi oba totaqi Besaita nagapa toroqata qeehimi noi abi tupu aipo biireta. ");
INSERT INTO ghs_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Aipo biire qaasuqi noi torata peite pupu hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","48","Qate qupi sooromi sisima oi oba ttuu dzounipamuta oomi Dzesu noqeke osobita ooqi moomi utai tumakhametoho robeta tooro baami noko kaipo minake eete dzaomata. Obetemi, Dzesui qupibake dzuridzarita qeemaqi nokoho torota oba heeta qooro tuumaqi noko riitare eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Eesuhimi noko moomi noi oba heeta qoro tuusumi noko atti eeteta. Noko hee, Gisi ooniqi hiireqi areare hiireta. Hiiremi noi noko pobi hiireta, Eo, eto atti eetaino. Ana oionita nikeho qupa kebaratare. ");
INSERT INTO ghs_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Oi Dzesu beedzaeho maikhatai dzobadzoba oke haba habanata biraitetaho khoobake nokoi ikaqi ruume naateta? ");
INSERT INTO ghs_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Oonita qupa nokohoi uhubaamake oomi noi uta qamuni hiiremi utai ao bamu naatemi noi nokoho toro qeemami sisimata peitemi noko atti sama eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Oonita nokoi oba dzongobeteqi Genesare igasata unate too pouta angina teeteta. ");
INSERT INTO ghs_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","55","Oonita noko sisima qaasuhimi oho abi Dzesuke moo gesina naateqi ao hairiamake haba totaqi oke gama dzongobeteqi Dzesui ika neta ootake qupadzomaqi nokoi khetedzanoma kahoba eete noho toro baa qaata. ");
INSERT INTO ghs_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Oi noi nagapa gattiqani mae, nagapa minani mae dzoo nagata tuumarota, oho sobadzata nokoi khetedzanoma mootomi nokomae ttoba patisigiqa nohoke hesate qidzanatareiqi noke dzauri hiireta. Ma abi noke hesateta nokoi gama susupu qidzanateta. ");
INSERT INTO ghs_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","3","Qate Pariseo ma Dzuta abi gama susupu uimane nokomeho pomata boto akobetaamake patta muuna qaarara, oonita Pariseo ma qetaqeta abi qesai Dzerusaremu neta baaqi Dzesuho toro ttutturateqi moomi tumakhameto nohota qesai qaga oke riiteqi boto akobetaamake patta muunota. ");
INSERT INTO ghs_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","(Ma Dzuta abi noko ttuma eetoraiho sobadza neta baaqi oba taataamake patta muuna qaarara. Oonihe, poma agoba samaneke noko qusubaiteqi khoru ma ttoka qapu ma kapa qapu ma meramera teka akobetaqu, quba oonomake noko eesuqi ohonga tiibete qaata.) ");
INSERT INTO ghs_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Oonita, Pariseo ma qetaqeta abi nokoi Dzesuke qasa hiireta, Ikanomake eeteqi tumakhameto niihoi uimaneho poma qusubaitaama naate boto akobetaamake paatta nokome muunorai? ");
INSERT INTO ghs_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Hiiremi Dzesui noko pobi hiireta, Meenipamuke Dzeseai ikoiko abi nikeke qupadzomaqi ao hee, Abi nagarai too kaka nokomema naho dzapake qusubaitoraihe, qupa nokoi sererahuke oorai. Nokoi ttaroke naho hasama gegema hiireqi abiho sinasinake hee Ohongaho sinabidza ooniqi hiireqi oke abi banaitorai. Oiqi Dzesea hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Dzesui hee, Oi teeho quba bahe Ohongaho too qurake nike basesa eeteqi uimaneho pomata tatanga naatorai. ");
INSERT INTO ghs_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Hiireqi Dzesu paha noorake hiireta, Uimane nikemeho pomake nike tatangaitareiqi meenipamuke Ohongaho too qura siginaitorai! ");
INSERT INTO ghs_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosei Hee, Mai ma pai niimeke kokora eete qusubaitorareiqi hiireta. Ma noi paha hee, Teei maini mae pai nomeke qanganiqi hiibaquko noi baataridzoniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Qate oho habarake nike hee, Abi oonoma teei maini mae pai nomeke hee, Ana baasumake nii naho quba qesaqesa aimororihe, ");
INSERT INTO ghs_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","oi ao qaheuba qonoqono (nokoho totohoio koroba) naate oorai ooniqi hiirorai. Oke noi oberama hiiremi nike noke hoobiremi noi ota mai ma pai nomeho kokora eetaama naatorai. ");
INSERT INTO ghs_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Idze, nike oke eeteqi uimane nikemeho pomata ipibireqi Ohongaho too qurake teetorai. Ma quba oonoma samaneke nike oberama eetorai. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Dzesui paha abi samaneke ttuttuiteqi noko pobi hiireta, Nike gama susupu naho noo nookaqi erake qupadzomare, ");
INSERT INTO ghs_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Quba abi teei muunami ttidzata qurataqu oi bamu abi oke kahosanomaitaqu. Oonihe quba abiho nakuta peiteqa biranataqu oio abi oke kahosanomaitakoi. ");
INSERT INTO ghs_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Tomanomai nookare.) ");
INSERT INTO ghs_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Hiireqi Dzesui abi tupu oke qaate naga nometa peitemi tumakhameto nohoi qahura oho quba noke qasa hiiremi noi noko pobi hiireta, ");
INSERT INTO ghs_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Qesaho qupai asuasu ooraimi nikehoi paha oke eete oorai mae? Nookare. Quba abi muunami qurataqu oi qidzoke abi kahosanomaitaqu. ");
INSERT INTO ghs_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Baamu, oi teqaha qupa nohota quratoraidzaranihe, qausuta qurate ttidzama biranatorai. Mae nike oho tete moo pobitaama? Noi o hiiretaho quba moomi pattai gama susupu qidza kekeni. ");
INSERT INTO ghs_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Noi erake hiireta, Quba qanga tee ma tee abiho qupata peite biranataqu oi abike kahosanomaitorai. ");
INSERT INTO ghs_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Oho tete erake eete oorai, Iiha ma dzobidza qanga oi nakuta ooqi abiho qupa neta biranatorai oi samaho guume ma meera maina paina, ma teeta ma tanga, ma apuata, ma qupabage, ma koiri kairi, ");
INSERT INTO ghs_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ma ikoiko ma ritarita, ma peetta ma qeraqera, ma ibo ma koke, ma sama qusuba ma rasaki, ");
INSERT INTO ghs_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","quba qanga erai gamaqa naku neta peiteqi abike kahosanomaitorai. Oiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Oke hiireqi Dzesui qoridze tuumaqi Tiro ma Sitona habata biranateqi naga teeta peiteta. Peiteqi noi hee, Abi eto naho pobike nookainoiqi hiiretahe, noi dzukubare hou eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Oi atapa teeho khatatai songenanoma oomi atapa oi Dzesuho pobi nooka baaqi, oko toro nohota gaipori kotorota. ");
INSERT INTO ghs_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Oonihe atapa noi Dzutaho bahe Siroponikisa haba nenai qaata. Oonita atapa noi dzauri hiireqi hee, Songena teei khatata nahoho irita ooraimi oke nii iihaqu mae? ");
INSERT INTO ghs_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Hiiremi Dzesui atapa oke qahura noota toronaiteqi hiireta, Khametoi bosa patta muuna isanataridzonita dzobadzoba oke khametoho neta karabete haa quba biidzaqu oi bamu isanataqu. ");
INSERT INTO ghs_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Hiimi noi haaho noo oke sama nometa mootoqi hiireta, Mai name, oi meenihe, khametoho patta huhu qohare pesuta taatemi haai muunorai oni. ");
INSERT INTO ghs_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Hiiremi, Dzesu noke pobi hiireta, Nii oonoma hiiremi isanate oonita niimae tuumaqa moorare. Songena ao niiho khatata qaatemi oorai. ");
INSERT INTO ghs_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hiiremi atapa oi nagapa tuumaqi moomi songena ao bamu naatemi khatata meramera tekata bage eete meeqota. ");
INSERT INTO ghs_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Oonita Dzesu burisi eeteqi Tiro habake qaateqi, Sitona nagapa riiteqi nagapa 10 oho bisata tuumaqi Garirea oba ttuuta biranateta. ");
INSERT INTO ghs_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Obetemi, nokoi abi toma susu ma too atimanoma teeke noho toro dzeima baaqi, Dzesu boto nomeke abi oho irita mootareiqi noke dzauri hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Hiiremi Dzesu abi tupu minaho neta noke qaheburoqi boto khameto nomeke abiho toma nakuta upubire ogidzoba eeteqi eteete nohoke hesateta. ");
INSERT INTO ghs_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Hesateqi, noi qusuke moohiqi heemaho hiireqi noke hee, Uhubare oiqi hiireta. (Oonihe nokoho totohoi Epatta.) ");
INSERT INTO ghs_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hiiremi toma noho uhubami eteetenohoi saqobami, noi ao noo rikeke hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Hiiremi Dzesui nokoke hee, Eto abi qesa oho pobi hiibainoiqi hiireta. Oonihe abi oi qamuni oke riiteqi oho noo abi hiire paanaite soubiremi, ");
INSERT INTO ghs_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","nokoi hasaqu minanipamuke eeteqi erake hiireta, Abi toma susuke noi tomanomaiteqi, too atimanomake noonomaitorai. Idze, noi quba samane bagenomanipamuke eetorai. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Oho sauta abi tupu minanipamu paha ttutturatemi, nokoho patta bamu naatemi Dzesui tumakhameto nomeho kira hiireqi pobi hiireta, ");
INSERT INTO ghs_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Abi tupui naho toro ao qupi tapariho isakita ooraimi nokoho patta bamu naatemi, anai nokoho quba dzasa minake eete. ");
INSERT INTO ghs_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Oi qesai kharata baaqorai. Oonita anai nokoke nagapata dzoobiremi, nokoho ttidza saa eetemi noko eto teteta qereqare eetaino. ");
INSERT INTO ghs_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Hiiremi, tumakhameto nohoi hiireta, Ikanomake haba qanga erata heeba saridze nokoke moitemi muuna isanataqu? ");
INSERT INTO ghs_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Hiimi noi hee, Dzobadzoba nikeho toro ikabete oorai? Hiiremi noko hee, 7 ooraiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Oonita Dzesui hiiremi abi tupui ttokata habesemi noi dzobadzoba 7 oke aimaqi agoago eete qootoqi dzoo mutu mootomi tumakhameto nohoi oke abiho dzagata mootota. ");
INSERT INTO ghs_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Paha khaa oberaqa teei nokoho toro oomi Dzesu oho irita agoago eeteqi, hiiremi tumakhameto nohoi paha oke nokoho dzagata mootota. ");
INSERT INTO ghs_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mootomi, noko patta muunaqi qura eeteta. Oonihe, pattaho saruke noko aimami asi pai 7 hee baata. ");
INSERT INTO ghs_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Obete, abi ootaho dzare oi 4,000 ooni kaqa. Oonita noi nokoke dzoobiremi tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tuumami noi tumakhameto nomema sisimata peiteqi Tamanutta habata biranateta. ");
INSERT INTO ghs_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Qate Pariseo nokoi Dzesuho torota baaqi sohoro noo mina hiireta. Hiireqi noko noke toronaiteqi hee, Nii nanaho quba qusuho obaoba teeke eetareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Hiiremi, noi qupa nometa misi teeteqi erake hiireta, Naane quba abi nagarai obaoba teeho quba hiirorai? ");
INSERT INTO ghs_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Obaoba oonoma oke bamu abi naga nikeho quba eetaqu. Oke ana bamu nike ikobetaqu. Hiireqi noi nokoke qaateqi, paha sisimata peite totaqi temuta qeemata. ");
INSERT INTO ghs_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","16","Oonita Dzesui Pariseo ma Heroteho tete qanga oke qahura noota hiireqi hiireta, Pariseo ma Heroteho pattai togonoma oonita nike oho bakena geema qaarare. Hiiremi tumakhametoi patta aimare ruume naatemi dzobadzoba teenai keke sisima nakuta oomi noko qesai hee, Dzobadzoba bamu naatemi noi oho quba noo hiire kaqa. ");
INSERT INTO ghs_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Hiiremi, Dzesu qupadzomaqi noko pobi hiireta, Quba apeho qubake nike dzobadzoba bamu naateho nooqake hiirorai? Nike moo pobitaama naate ruumenipamu naatorai mae? Eo, nikeho qupa tatanga naatorai Mae? ");
INSERT INTO ghs_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Idze, nike nesenomanihe, moo pobitaamani. Nike tomanomanihe, nooka pobitaamani mae nikeho qupai uko ma ttauko eete? noo ");
INSERT INTO ghs_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nookare, Anai abi 5,000 oho quba dzobadzoba boto teenake qootomi, nike oho saru aimami asi ikabete hee baata? Hiiremi, noko hee, 12 oni. ");
INSERT INTO ghs_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Hiimi noi hiireta. Qate anai abi 4,000 oho quba dzobadzoba 7 oke qootomi, nike oho saru aimami asi pai ikabete hee baata? Nokoi hee, 7 oni. ");
INSERT INTO ghs_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Hiiremi noi noko qasa hiireta, Oonita nike naho khooba qupadzomorai mae baamu? Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Qate nokoi Besaita nagapata biranatemi qesai abi nese khabanoma teeke Dzesuho toro dzeima baaqi, Dzesu noke hesatareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Hiiremi Dzesui abi nese khabanoma basidzomaqi nopo nagapa tumeta biranateta. Biranateqi Dzesui nese nohota ogidzoba eete boto nome abiho irita mootoqi noke qasa hiireta, Nii quba moori mae? ");
INSERT INTO ghs_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hiimi noi nese parara eeteqi hiireta, Abike ana moohimi ee qooro ooraiho qesa nokoi qooro tuuma ma baabake eesubi. ");
INSERT INTO ghs_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Hiiremi noi paha boto nome abiho neseta mootomi, noi bageke eete moomi pobirateta. Paha quba samane kharaqana oke no gama bageke eete mooqota. ");
INSERT INTO ghs_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Obetemi Dzesui noke nagapata dzoobireqi hiireta, Eto sepeke nagapata abi oho pobi hiibaino. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Dzesui tumakhameto nomema nokoi Piripi Kaesareaho nagapa gamittita biranateta. Oonihe, noi teteta tumakhameto nomeke qasa hiireta, Abi nokoi anake apeniqi hiirorai? ");
INSERT INTO ghs_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Hiiremi noko hiireta, Dzohane sobasoba maikhata oioniqi hiiremi qesai hee, Eria ooniqi hiiremi, paha qesai hee, Too abihota teei ooniqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Hiiremi, noi noko qasa hiireta, Qateqa, nikemae anake apeniqi hiirorai? Hiiremi Peetoro noke eraiqi hiireta, Nii Kiristunipamu oni. ");
INSERT INTO ghs_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Hiiremi noi nokoke hee, Eto oho pobi abike pobi hiibainoiqi hiireqi qamuni tatangake hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Qate Dzesu sohoroqi tumakhameto nome banaiteqi hiireta, Anai Abiho Isaki oonihe, ana abi mimi ma dzube abi bosabosa ma qetaqeta abi nokoho botota heme samaneke saridzemi noko basesa eeteqi ana teetemi baatakoi. Oonihe qupi tapari naatemake ana qoridzakoi. ");
INSERT INTO ghs_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Noi o hiireqi, paanaite hiireta. Hiiremi Peetoroi noke qaheburoqi qamuni hiibare boohimi, ");
INSERT INTO ghs_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Dzesu burisi eete tumakhameto nome nesema moo Peetoroke pobiteqi hiireta, Saata, nii papatare! Peetoro, nii ikaqi Ohongaho tete ruumenihe abihoke qupadzomorai? ");
INSERT INTO ghs_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Hiireqi noi abi tupu ma tumakhameto nomema nokoke ttuttuiteqi hiireta, Teei naho ipi suutare dza eetaqu no isanate sama nome bai hiire maranga biireqa anake iiha qaarare. ");
INSERT INTO ghs_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Oi teei qaraqara nomeke qaanataquko noi quba seepe naatakoi. Qate teei qaraqara nomeke naho quba ma sinabidzaho quba qaanataama naate abike moitaquko qaraqara nohoi meeke qidzanatakoi. ");
INSERT INTO ghs_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","38","Oi abi teei ttoka ma haba gama susupu mai eete soubiremi qaraqara nohoi dzaetaqu oi ikanomake eeteqi noke hoobidzaqu? Oi dzaetemi, noi quba apeke moitemi, qaraqara nohoi paha qidzanataqu? Baamu. Nookare. Abi naga meeama ma pasenanoma eraho neta teei naho midza ma qesamane nahoho midzake eetaquko, ana Abiho Isaki ooqi ipita Mai nameho dzadzama baaqi qaheuba angeroma gama baaqake namae abi oho midza eetakoita qupadzomare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Noi hiireqi hee, Abi erata habese ooraiho neta qesai baataamake oomi Ohongaho pobi beedzae minama biranahimake noko ao moorakoi. Oke ana meeke nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Hiiremi qupi 6 naatemi, Dzesui Peetoro ma Dzakopo ma Dzohane nokoke dzeima noko gama tora teeta peiteta. ");
INSERT INTO ghs_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ota nokoqeke ooqi, Dzesui nokoho pengata ogasumami ttoba ma sasa nohoi khabakhabari hihidzanoma naateta oi ttokata abi teei ttoba teeke oho isakita khabanomaitare bitta eetorai oni. ");
INSERT INTO ghs_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Oke eetemi noko moohimi Eria ma Mose nopo nokoho pengata birabira naateqi Dzesuma qesa noo hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Oonita noko ququimaqi noo apeke hiibarota? Oho quba Peetoroi Dzesuke hee, Mai name, napa erata ooraqu oi bagenoma. Oonita nii dza eete hiiremake, nanai baruba tapirike biidzare, teei niihoni, teei Mosehoni, teei Eriaho. ");
INSERT INTO ghs_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hiiremi dzorobi teei nokoke sengibetemi, noo totoho teei dzorobi neta biranateqi erake hiireta, Eraio qeseba khata nahonita noo nohoke nike nookorare. ");
INSERT INTO ghs_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hiimi tumakhameto nokoi nese dzoobire moomi, abi nopoi bamu naatemi Dzesu keke nokoma oota. ");
INSERT INTO ghs_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Qate Dzesu ma Peetoro ma Dzohane ma Dzakopo nokoi tora neta qurahiqi Dzesui noko qamuni hiireqi hiireta, Nike birabira erake moorihe, Abiho Isaki anai baate qoridzaamake ooraquta etoqa eraho pobi abike pobi hiibaino. ");
INSERT INTO ghs_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Hiiremi noko noo oke qahitoto qaata. Oonihe abi baata neta qoridzaquho khoobake noko qiri eeteqi, nokomae qesa qasa hiireqi bitta eeteqi Dzesuke qasa hiireta, ");
INSERT INTO ghs_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Qetaqeta abi nokoi naane quba hee, Eriai bosata baamake sama tukutuku biranatakoiqi hiiremi nana nookorai? ");
INSERT INTO ghs_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Hiiremi Dzesu erake hiireta, Eria nome bosata baaqi quba samane ttarita mootaridzonihe, aoke Eriaho qesai baami, abiho dza hiiretaho isakita nokoi noke paru geemata. Oi Dzohanehoke agobake sinabidzata qeeteta, oke anai bamu nike ikobetaqu. Oonihe Abiho Isaki anai heme minake saridzaridzoni. Saridzemi nokoi anake puutta hiibaqu oho qetaqeta paha ikanoma hiiremi oorai oke nike qupadzomorai mae? Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Oke Dzesu hiireqi nokoi tumakhameto qesaho toro biranateta. Biranate moomi abi tupu minai nokoke rome biireqi qetaqeta abima noko noo mina hiirota. ");
INSERT INTO ghs_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hiiromi abi tupu oi Dzesuke moo roqobete noho torota hairiamake baaqi noho qaki eetemi noi noko qasa hiireta, ");
INSERT INTO ghs_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nike quba apeho quba noo minake hiirorai? ");
INSERT INTO ghs_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","Hiiremi abi tuputa teei erake hiireta, Banaita name, songena teei khata nahoho irita ooraimi noi potutu naate oorai. Oi songena noke aima biiremi noi too dzootorai, ma noho too horesa pereborai, ma gotta nohoi tataumorai. Oho qubake ana noke niiho toro dzeima baabe. Oonihe, anai tumakhameto niihoke hee, Songena oke iihareiqi hiiremi noko hou eete. ");
INSERT INTO ghs_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Hiiremi, Dzesui tumakhameto pobi hiireta, Idze, abi naga nike ikanomake ai tataumaamani! Anai pookeba samakeba naate nikeho torota baura eete baa qaimi, bodza apeta nike nooka hiisi eetaqu? Seke khata oke dzeima baabare. ");
INSERT INTO ghs_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hiiremi nokoi khata oke dzeima baami songena Dzesuke moo gesina naateqi hairiamake khata oke aima pirupara eetemi noi ttokata taate buribaro eetemi too horesa nohoi biranateta. ");
INSERT INTO ghs_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Biranatemi Dzesui khata oho maike qasa hiireta, Quba oi bodza apeta sohorota? ");
INSERT INTO ghs_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mai hee, Noi khata bittina oomi, songena oi sohoroqi noke teetareiqi hiiremi, khata bodza ginaqake obata dzaga susumaqu, mae eepata dzuubaqu oho beedzae eetorai. Oonita oho isaki niiho toro ooraimake nii nakaho quba dzasa eeteqi hoobidzare. ");
INSERT INTO ghs_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Hiiremi Dzesu noke pobi hiireta, Nii hee, Oho isaki ooraimakeiqi hiire. Idze. Teei nooka hiisi eetemi quba samane minarake eetaquho isaki noho toro oorai? ");
INSERT INTO ghs_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Hiimi abi khata oho mai hee, Anai nooka hiisi eetoraihe, ikake eeteqi paha houpeu eetorai? Nii anake hoobidzare. ");
INSERT INTO ghs_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Hiiremi Dzesui moomi abi tupu oi ango minanatemi noi songena oke qamuni hiireqi hiireta, Nii abi khata oke naane quba toma susu ma potutunomaitorai? Oonita, nii noke qaate tuumaqa etoqa paha noho irita biranataino. ");
INSERT INTO ghs_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Hiiremi, songena areare hiireqi abi khata aima pirupara eete noke qaate tuumata. Tuusumi abi khata oi baataquho tomidza naatemi, abi samane hee, Noi baateniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Oonihe, Dzesui noke botota karabete ai qusubaitemi noi nomae qooro isanateta. ");
INSERT INTO ghs_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Qate Dzesui naga teeta peitemi tumakhameto nohoi noke qasa hiireta, Naane quba nanai songena oke iihare bitta eete? ");
INSERT INTO ghs_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Hiiremi noi hee, Songena oonomake iihaqu oke abi bamu sepeke eetaquhe, pupu hiireqake iihami tuumakoi. ");
INSERT INTO ghs_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ipita noko gama tuumaqi, Dzesui hee, Anai songenake iihe eto abi oho nooke nookainoiqi hiireta. Hiireqi noko Garirea habake dzongobeteta. Dzongobeteqi noi tumakhameto nomeke bainaite pobi hiireta, ");
INSERT INTO ghs_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Teei Abiho Isaki anake geema mootomake noko ana teete baatakoi. Baatemi qupi tapari naatemake ana paha eehaha naate qoridzakoi. ");
INSERT INTO ghs_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Hiiremi, Dzesuho tumakhametoho qupa uhubaama naatemi nokoi noo oho khooba quba noke qasa hiibarotahe atti eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Obetemi noi nokoma gama Kapanao nagapata biranateqi ipita naga nakuta ooqi noi noko qasa hiireta, Noo apeke nike teteta qesa pobipobi hiirori? ");
INSERT INTO ghs_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Hiiremi noko nipanateta, oi noko teteta baahuqi apei nokohota abi mina naatarota oho nooke hiirota. ");
INSERT INTO ghs_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Oho qubake Dzesui habeseqi tumakhameto Tuerebe nokoke ttuttuiteqi pobi hiireta, Teei bosa qobaqoba naatare hiireqa noomae qupa gaibata ipina naate abi samaneho kokora eetorare. ");
INSERT INTO ghs_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hiireqi noi khata gattiqa teeke nokoho bisata mootoqi noke amaki eeteqi noko pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Hee, Teei naho quba eeteqi khata oonoma teeke aima kokora eetaqu noi oke eeteqi anake oke eetakoi. Ma apei anake kokora eetaqu noi oke eeteqi Mai anake dzoobiremi baata paha noke eetakoi. ");
INSERT INTO ghs_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Hiiremi tumakhata Dzohanei Dzesuke hee, Banaita name, teei dzapa niihoho beedzaeta songenake iihami nana moori. Qate noi napaho nena ooraamanita nanai noke qamuni hiire. ");
INSERT INTO ghs_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Hiiremi Dzesu erake hiireta, Teei dzapa nahoho beedzaeta baura qidza bamenoma teeke eeteqi bamu gisake anake qanganiqi hiibaqu. ");
INSERT INTO ghs_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Oonita etoqa noke qamuni hiibaino. Oi teei napaho ibo eetaama naataqu noi napaho nena keke. ");
INSERT INTO ghs_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ma teei hee, Nike Kiristuho tumakhametoniqi qupadzomaqi khoruta oba giima nikeke moitaqu noi bamu ipi ma ari oho dzore naataqu. Oke ana meeke nike pobi hiire. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Hiireqi Dzesui hee, Abi teei qesaho angi naatemi khameto gamitti erana nooka hiisi eetoraihota teei taataqu, angi abi oke bosata oma bamenoma paruta suutoqa oba ttuuta ai biidzapuko isanatarota. ");
INSERT INTO ghs_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Oiqi hiireqi noi oke qahura noota hee, Boto temu niihoi niike qangata dzeimake boohimi nii eto taatainoho isakita oke geema qaateqi boto temuma qaraqarata dzuubaqu oi isanatakoi. Oonihe, dzeimami nii taateqake boto eseima eepa tatangata dzuubaqu oi baamu isanataqu. ");
INSERT INTO ghs_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Eepa oi bamu hiibaquhe, ota dzoodzoi oho keba muuna qaarakoi.) ");
INSERT INTO ghs_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Oho qesa oko niiho teei niike qangata dzeimake boohimi nii eto taatainoho isakita oke geema pone naateqa qaraqarata dzuubaqu oi isanatakoi. Oonihe, dzeimami nii taateqake oko eseima eepa tatangata dzuubaqu oi baamu isanataqu. ");
INSERT INTO ghs_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Eepa oi baamu hiibaquhe, ota dzoodzoi oho kebake muuna qaarakoi.) ");
INSERT INTO ghs_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Oho qesa nese temu niihoi niike qangata dzeimake boohimi nii eto taatainoho isakita oke bikoumaqi nese temuma Ohongaho pobita dzuubaqu oi isanatakoi. Oonihe, dzeimami nii taatemake nokoi niike nese eseima gama eepa tatangata ai biidzaqu oi bamu isanataqu. ");
INSERT INTO ghs_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Qate eepa oi bamu hiibaquhe, ota dzoodzoi oho kebake muuna qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Qate Ohongai abi samaneke kaipoho eepata mootomi tomuho qesa oho meke biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Oonita tomu oi qidza. Oonihe, oho meke bamu naatemake oke nii quba apeke eetemi oho meke paha biranataqu? Baamu. Oho quba oora ma qaara nikehoho meke biranate qaamake nike keba ma dzapata qaarare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","2","Oonita Dzesui haba oke qaateqi oba Dzotani ma Dzutea habata biranatemi abi samane noho toro ttutturatemi noi saninoke banaite qaataho isakita paha nokoke tete banaiteta. Banaitemi Pariseo nokoi baaqi noke toronaiteqi hee, Abi teei ata nomeke saqobaqu oi qaganomani, mae baamu? ");
INSERT INTO ghs_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Hiiremi noi erake hiireta, Oohoke Mosei nike ikanomake pobi hiireta? ");
INSERT INTO ghs_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Hiiremi nokoi hee, Abi teei ata nomeke saqobareiqi hiiremi oho pepa qeete tatangaitemi Mosei teqaha oho baike hiibara. ");
INSERT INTO ghs_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Hiiremi Dzesui erake hiireta, Mosei qupa tatanga nikehoke qupadzomaqi tete oke paanaiteta. ");
INSERT INTO ghs_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Oonihe, khoobanipamuta Ohonga quba minara mootoqi abi ma ata nopoqake qesaho quba korabetetanita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Oho qubake abi teei mai ma pai nomeke qaateqi ata nomeho toro atimaqi nopo esese sama teena naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Oi nopoi maina ma paina oonidzara, nopoi sama teenani. ");
INSERT INTO ghs_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Oonita nopoke Ohonga nomae hongasiremi etoqa abi baura oke uhutaino. Oiqi qetaqeta agoba hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Hiiremi ipita tumakhameto nohoi naga nakuta qeemaqi noke qasa hiiremi noi noko pobi hiireta, ");
INSERT INTO ghs_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Teei ata nomeke qaateqi maina teeke aimami guume naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma atapa teei apu nomeke qaateqa maina teeke aimami guume naatakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Obetemi qesai khameto nokome aima baaqi Dzesu nokoke hesate agoago eetareiqi hiiremi, tumakhameto nohoi nokoke niiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Hiiremi Dzesu mooqi dzaubadzauba eeteqi erake hiireta, Khameto gamitti isanate naho toro baabare. Oho teteta nokoi Ohongaho pobi naatorai oonita etoqa nokoke tete siibaino. ");
INSERT INTO ghs_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Khameto gamitti baaqi Ohongaho pobi naatoraiho isakita abi teei baabaama naataquko noi bamu Ohongaho pobita dzuubaqu, oke ana bamu nike ikobetaqu. ");
INSERT INTO ghs_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Oke hiireqi noi khameto amaki eeteqi boto nome nokoho irita mooto noko agoago eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ipita Dzesui biranate teteta tuusumi teei torouma baaqi noho toro pomai kotoro noke hee, Banaita qidza name, quba apeke ana eeteqake oho quba qaraqara tatanga saridzaqu? ");
INSERT INTO ghs_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Hiiremi, Dzesu hiireta, Ohonga teenai qidzanita oho quba nii anake hee, Qidzaniqi hiire mae? ");
INSERT INTO ghs_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Qate hu nooi hee, Nii eto teete baataino. Nii eto apuata eetaino. Nii eto quume eetaino. Nii eto tooi pokhi eetaino. Nii eto qesaho pobi qaanataino. Nii mai ma pai niimeke qusubaitare. Oiqi hiiremi nii qupadzomorai Mae? ");
INSERT INTO ghs_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hiiremi noi Dzesu pobi hiireta, Banaita name, noo samane oke ana dzobadzoba nameho neta qusubaite baaorai. ");
INSERT INTO ghs_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Hiiremi Dzesu noke iiha taate moo inobeteqi pobi hiireta, Oonihe, quba teeke nii eetaamake oorai. Oonita nii tuumaqa quba samane niiho torona oorai oho ttuma saridzeqi oke abi habanake moite soubiremake ttuma qusunai niiho torota biranatokoita nii oke eeteqake baa anake iiha qaarare. ");
INSERT INTO ghs_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Hiiremi quba tongo nohoi hii khara oomi abi oi nese ma penga ruruhoromi nota bame eetemi noi Dzesuke qaate papateta. ");
INSERT INTO ghs_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Papatemi Dzesu tumakhameto nomeke mooqi erake hiireta, Qidzoke abi oma minanomai Ohongaho pobita dzuubaqu. ");
INSERT INTO ghs_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Oke hiiremi tumakhameto nohoi roqobetemi Dzesu paha hee, Khameto name, Ohongaho pobita dzuubaqu oi quba bamenoma. ");
INSERT INTO ghs_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamere hoo teei baakoho puita dzuuba biranataqu oi baura bamenomanihe, abi quruma minanomai Ohongaho pobita dzuubaqu oio baura bamenomanipamu oni. ");
INSERT INTO ghs_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","27","Hiiremi nokoi hasaqu minake eete qesa pobipobi hiireta, Idze, apei tete saridzemi Ohonga noke ingonaitaqu? Hiiremi Dzesu nokoke iiha taate moo pobi hiireta, Abi oho beedzaeamanihe, Ohongai oho beedzae oorai. Oi baura minaraho beedzae noho torota oorai. ");
INSERT INTO ghs_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hiiremi Peetoro iiha ma dzoobidza eeteqi Dzesu pobi hiireta, Nii moo. Nanai quba samane qaateqi niike iiha baaqorai. ");
INSERT INTO ghs_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Hiiremi Dzesu erake hiireta, Teei naho quba ma sinabidzaho quba, quba samane nomeke qaataqu oi nagani mae, nomamane namemaneni mae, sasemane dzabamaneni mae, maini mae, atani mae, khametoni mae, dzoo qesa oke qaatequ noi gairaho isakita quba saridzakoi. Oi naga qesa ma, nomamane nanemane ma, sasemane dzabamane ma, paimane gottagotta ma, khameto ma dzoo qesa, quba oonomake noi poiqa bodzarata kaipoma saridzeqi ipi bodzata paha qaraqara tatanga saridzakoi. Meeke oke ana nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Oonihe, qesa bosa qoororai nokoi ipina naatakoi, ma qesa ipina oorai nokoi bosa qoobakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Obete nokoi Dzerusaremuho teteta tuumoqi Dzesu nokoho bosa qooro tuumomi, noko ipitotoqi noho noo quba qupa ororo eetemi ipinai attoibobo eeteta. Eetemi noi Tuerebe nokoke qaheburoqi, ipita quba bamenoma noho torota biranatarotaho noo nokoke pobi hiireta. Hee, Nike nookare. ");
INSERT INTO ghs_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","34","Napai Dzerusaremuta peqibihe, teei dzube abi ma qetaqeta abiho bosa qobaqoba nokoho quba Abiho Isaki anake geema mootoma, nokoi ana baataquho isakiniqi hiireqa raaba abiho torota mootakoi. Mootoqi noko anake boto neinei eete ekepusa eeteqa buri ma baroke teetemi baatakoi. Oonihe qupi tapari naatemi ana qoridzakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Qate Dzebeteoho khameto Dzakopo ma Dzohane nopoi Dzesuho torota baaqi erake hiireta, Banaita nakame, nakai niiho toro qasa hiibaqu oke nii nakaho quba eetareiqi naka dza eete. ");
INSERT INTO ghs_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Hiiremi noi nopoke qasa hiireta, Anai nipe naaneke eetareiqi nipe dza eete? ");
INSERT INTO ghs_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Hiiremi nopo hee, Dzapa pobi niihoho bodzata nakai ooqa teei boto pobi niihota habesemi, temu boto mage niihota habese qaaraqu oho naruke nii hiibare. ");
INSERT INTO ghs_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Hiimi Dzesui hee, Nipe qasa hiibi oke nipe ruume. Anai bameho khoruta muunaqu oke nipe paha isanate muunaqu? Oni mae quba bamenoma naho irita soobaqu oi paha nipeho irita sooromi isanataqu mae? ");
INSERT INTO ghs_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Hiiremi nopo ipi hiireta, Oi paha nakaho isaki oni. Hiimi Dzesu hee, Khoruta ana quba bamenoma muunaqu oke nipe paha muunakoi, ma naho irita dzuui soobaqu oi paha nipeho irita soobakoi. ");
INSERT INTO ghs_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Oonihe, boto pobi nahota habesaqu, mae boto mage nahota habesaquho naru nipeke pobi hiibaqu oho isaki naho toro ooraidzara. Teka oke qesaho quba roibetemi nokomae ota habesakoi. ");
INSERT INTO ghs_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hiiremi tumakhameto 10 nokoi nooraho pobi nookaqi Dzakopo ma Dzohaneho dzauba eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Eetemi Dzesu nokoho kira hiireqi erake hiireta, Raaba abiho pobipobi abi nokoi isanate abiho irita bedzabedzake eetorai, ma nokoho abi mimi nokoke soopara eetorai. ");
INSERT INTO ghs_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Oonihe, nikeqaho bisata quba oonomai eto biranataino. Oi nikeho torota apei abi mina naatare hiibaqu nomae nikeho kokora eetorare. ");
INSERT INTO ghs_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma apei nikehota bosa qobaqoba naatare hiibaqu noomae nike minaraho tteeki aimorare. ");
INSERT INTO ghs_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Oho qesa ana te hee, Abi samanei Abiho Isaki anaqaho kokora eetareiqi hiire baabara, bamu. Anai abiho kokora eeteqi qaraqara nameke mootoqa abi samaneke qangaho ekata saqobareiqi baaoraita qupadzomare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","47","Oke hiiroramuti noko gama Dzeriko nagapata biranateta. Biranateqi noi tumakhameto ma abi tupu minama noko gama nagapa oke qaasuhimi Barattimeo noi tete sigiqata habese oota. Abi oi Timaho khata oonihe noho nese khaba eete oomi noi tomama pobi nookami Dzesu Nadzaretteho nenai ota tuusuta. Oonita noi pobi nookaqi sokate hiireta, Dzesu, Tabitiho eema ma khata, nii naho quba dzasa eetare. ");
INSERT INTO ghs_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Oke hiiromi, abi samane noke qamuni hiireqi hiireta, Noo ango qaatare. Hiiremi noi beedzae eete dzaubama hiireta, Oe, Tabitiho eema ma khata, nii naho quba dzasa eetare! ");
INSERT INTO ghs_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Hiimi, Dzesui roroko biireqi nokoke pobi hiireta, Abi oho kira hiiremi baabare. Hiiremi nokoi abi nese khabanomaho kira hiireqi hee, Dzesui ao niiho quba hiire oonita nii qupa too teeteqi qoridzare. ");
INSERT INTO ghs_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Hiiremi noi sasa nomeke ai siginaite tukubaqi Dzesuho toro biranateta. ");
INSERT INTO ghs_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Biranatemi Dzesu noke hee, Quba apeke ana niike eetareiqi nii dza eete? Hiiremi abi nese khabanomai hee, Mai name, ana paha nesenoma naatare dza eete. ");
INSERT INTO ghs_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Hiiremi Dzesu noke pobi hiireta, Nii ai tataumoraita niiho nese ao qidzanatare. Hiimi abi oi paha nesenoma naate qeemaqi teteta Dzesuke ipitotota. ");
INSERT INTO ghs_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Nagapa Bettepage ma Bettania nopo Oriba torata oomi Dzesu tumakhameto nomema nokoi gama oho robeta biranateta. Biranatemi Dzerusaremu sererahuke oomi Dzesui tumakhameto nomehota eserike dzoobireqi erake hiireta, Nagapa gattiqa totaqi temuta oorai nipe ota dzuubahiqa toogi khata tee abi peitaama oke nipe ota mooqa saqoroqake dzeima baabare. ");
INSERT INTO ghs_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Qate, abi teei ota hee, Nipe naane quba oke eetoraiqi qasa hiibaquko erake hiibare, Eo, Soopara napahoi toogi khata oho quba hiireqi ipita paha hairiamake noke dzoobiremi erata baabakoiqi hiibare. ");
INSERT INTO ghs_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","6","Oke Dzesu hiiremi nopo tuumaqi kosoramuta biranateqi moomi toogi khatake naga teeho patita suutomi oota. Oomi nopoi saqorota. Saqohimi abi qesai ota qooro ooqi qasa hiireta, Ae, nipe ikaqi hiireqi toogi khata oke saqohibi? Hiiremi, Dzesu bosata hiiretake nopoi noko pobi hiiremi, noko qaateta. ");
INSERT INTO ghs_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Qaatemi nopo toogi khata oke Dzesuho toro dzeima baami abi nokoi sasa nokome toogi khataho irita saama eetemi Dzesu oho heta habese tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tuusumi, abi samane noho qaki eeteqi sasa nokome teteta rerengi eetemi qesai paha qeba neta ee henenake geemaqi teteta mootomi ota tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Qate, bosana tuumata ma ipina baaqota noko gama garuruiqi hiireta, Soopara napemeho dzaapa, dzoobe dzoobe! Nii baabe! Nii agoagonomani. ");
INSERT INTO ghs_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tabiti uumi napameho dzapa pobi oi biranatorai. Oi hasanomanipamu! Ohonga dzoobe! ");
INSERT INTO ghs_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Oke hiiromi Dzesu Dzerusaremuta biranate Ohongaho biirita dzuubata. Dzuubaqi noi emoemoma tuumomi sure mootomi noi biranate Tuerebema noko gama Bettania nagapa gattiqata tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Iihai mootomi nokoi Bettania nagapa qaatemi Dzesuho ttidza saa eetemi, ");
INSERT INTO ghs_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","noi haba kharata ee dzunaho geeke mooqi ota tuumaqi mee nohoho qiri eeteta. Oonihe oi dzuna mee goomoraiho bodza ooraama naatemi noi gee keke moota. ");
INSERT INTO ghs_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Oho qubake noi ee oke hee, Abi bamu paha niiho neta mee saridze muunaqu. Baamunipamu! Hiiremi tumakhameto oho noo nookaqi roqobeteta. ");
INSERT INTO ghs_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Obetemi noko Dzerusaremuta biranateqi Dzesui Ohongaho biirita dzuubata. Dzuubaqi moomi abi qesa ttuma biirota ma qesa ttuma aimota. Oho qubake noi noko hotou biireqi abi oma burisi eetoraiho qohare aima perebireqi abi qusubibiho ttuma aimotaho qohare oke paha ai perebireta. ");
INSERT INTO ghs_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma qesai ttuba ma quba samane nokomema sepeke biirita dzuuba biranatomi noi oho tete siireta. ");
INSERT INTO ghs_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Obeteqi Dzesui nokoke banaiteqi erake hiireta, Sinabidza noota hee, Naga nahoke abi tupu samaneho pupu hibahiba naganiqi hiibaridzoni. Oiqi qeetetanita nike naane quba eranomake eetemi guume qopaho tomidza naatorai? ");
INSERT INTO ghs_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hiiremi oho nooke dzube abi mimi ma qetaqeta abi nookaqi Dzesuke teetare hiireqi tete qirike eeteta. Oonihe, abi samane noho noo nokaqi ota qeemami abi mimi nokoho quba ququimata. ");
INSERT INTO ghs_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Qate sure mootomi Dzesu tumakhameto nomema nagapa oke qaate biranateta. ");
INSERT INTO ghs_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Iihai mootomi nokoi paha burisi eete teteta tuusuqi moomi ee dzuna oi orotu ma gama baro eete oomi Peetoro oke qupadzomaqi Dzesu pobi hiireta, ");
INSERT INTO ghs_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Mai name, nii moorare. Ee dzuna nii baru hiireta oi ao baro eete oorai. ");
INSERT INTO ghs_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Hiiremi Dzesu noko gama pobi hiireta, Oionita Ohonga ai tatauma qaarare. ");
INSERT INTO ghs_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Oi teei tora teeke hee, Nii oba ttuuta qeemaqa bamu naatare oke hiireqa noo oho mee biranataridzoho qupa houpeu eetaama naate hiisi keke eetaquko, oho isakita noho quba biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Oke ana meeke nike pobi hiire. Oho quba ana paha eraiqi hiire. Quba qesaqesaho quba nike Ohonga pupu hiireqa oke nike ao saridzakoiqi qupadzomaqi saridzakoi. ");
INSERT INTO ghs_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Oonihe nike pupu hiibare boohimi abi teeho kahosa niiho qupata oomi oke nii teesumi, qusu Mai nikehoi oho qesa kahosa nikehoke teetemi bamu naatakoi. ");
INSERT INTO ghs_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Qate nike qesaho kahosa qaataama naatemi Ohongai oho qesa bamu nikehoke qaataqu.) Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","28","Hiireqi nokoi paha Dzerusaremuta baaqi Dzesu biirita dzuubaqi tuuma ma baabake eesumi dzube abi bosabosa ma qetaqeta abi ma abi mimi nokoi gama noho toro biranate noke qasa hiireta, Naane beedzaema quba samane erake nii eetorai, ma apei hiiremi nii tete erake aimorai? ");
INSERT INTO ghs_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Hiiremi Dzesu nokoke hee, Ana paha nike qasa noo teeke hiiremi oho ipike nike ana pobi hiiremake beedzae apeta ana quba samane eetoraiho khoobake ana nike pobi hiire paanaitakoi. ");
INSERT INTO ghs_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Oonita Dzohane abi obama sooro qaata, baura oi Ohongahoni, mae abihoni? Nike naho noo ipi hiibare. ");
INSERT INTO ghs_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Hiiremi nokomae qesa pobipobi hiireta, Napai hee, Oi Ohongaho bauraniqi hiibaquko, noi oke hee, Oonita nike naane quba Dzohaneho noo nookaama naate qaataiqa hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Qate, napai hee, Oi abiho bauraniqi hiibaqu, sss! Oiqi hiireta oi teeho quba bahe abi minarai hee, Dzohanei Ohongaho too abi ooniqi qupadzomami nokoi abi tupuho attike eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Oho qubake nokoi Dzesuho noo ipi hiireqi hee, Nanai khoukhau oni. Hiiremi Dzesu noko pobi hiireta, Oho qesa beedzae apehota ana baura samane erake eetoraiho khoobake ana bamu nike pobi hiire paanaitaqu. Baamu. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Dzesu ipibireqi qahura noota Dzutaho abi mimi pobi hiireta. Hee, Abi teei bai meeho dzoo teeke dzaaro rome biireqi bai mee imitaquho kose qoomaqi, penono teeke suutoqi dzoo oke gama abi qesaho botota mootoqi hee, Oke soopara eetareiqi hiireqi haba kharata tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tuuma qaaramuti oho bodzata maikhatai kokora abi teeke dzoobireqi hee, Nii tuuma dzoo oho sooparaho torota mee batabireqi totaqi nahoke aima baabareiqi hiiremi tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tuumami nokoi kokora abi oke buribaroke teeteqi dzoobiremi habanake baata. ");
INSERT INTO ghs_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Baami maikhata kokora abi paha teeke dzoobiremi tuumami, nokoi qiba nohoke urupusa eeteqi noke midzata mootata. ");
INSERT INTO ghs_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Obetemi maikhata paha teeke dzoobiremi nokoi noke teetemi baateta. Baatemi maikhata paha qesa samaneke dzoobire tuumami, nokoi qesake buribaroke teeteqi qesake teete baateta. ");
INSERT INTO ghs_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Baatemi maikhataho qeseba khata teenai keke noho dzagana oomi mai noke nokoho toro musaqi dzoobireqi hee, Khata nahoho tooke noko isanate qusubaitakoiqi hiiremi tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Oonihe, dzoo oho soopara nokoi khatake mooqi qesa pobipobi hiireqi hee, Abirai dzoo erake mai eetakoi. Oonita napa noke teete baatemake oho maikhameto naatareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hiireqi noko khatake karabete teete baatemi, keba nohoke dzoo sasata biireta. ");
INSERT INTO ghs_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Biiremi, dzoo oho maikhatai oho ipike quba apeke eetaqu? Noi isanate baaqi dzoo sooparake gama teeteqi dzoo oke paha abi qesaho botota mootaridzoni. ");
INSERT INTO ghs_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Hiireqi abi mimi oke dzesui hee, Paha noorake sinabidza noota qeetetake nike isaitaamani mae? Oi hee, Gosogoso abi oma naga gootoqi, oma teeke oberaniqi hiiremi, ikanomake eete oma oi ao naga oho ttittira naate oorai? ");
INSERT INTO ghs_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Oke napaho nese moomi Ohonga Sooparaho bauranita oho hasa hiire. Oiqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Oonita Dzesu qahura noo oke hiiremi abi mimi moomi nokoho khooba paana naatemi noko noke karabetareiqi hiiretanihe, noko abi tupu oho attike eete noke qaate papateta. ");
INSERT INTO ghs_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Dzesuke papateqi abi mimi nokoi Pariseo ma Heroteho abi qesa hee, Nike Dzesuho hibahibata noke angina teetareiqi hiiremi tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tuumaqi nokoi noho toro biranate erake hiireta, Banaita naname, nana moomi nii meenipamu oni. Ma nii te abiho penga quba eetoraidzaranihe, meenipamuke nii Ohongaho tete abike banaitorai oke nana gesina. Qate, ttagetti oke nana Kaisa abi mina moitemi isanataqu, mae baamu? Oho omake nana isanate biidzaqu, mae baamu? ");
INSERT INTO ghs_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Hiiremi, Dzesu ikoiko nokohoke qupadzomaqi noko pobi hiireta, Nike naane quba anake toronaisubi? Seke oma teeke aima baa ana moitemake ana moorare. ");
INSERT INTO ghs_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Hiiremi oke noko aima baami noi aimaqi hee, Apeho gisigisi ma qetaqeta erani? Hiimi nokoi hee, Kaisa, abi minahoni. ");
INSERT INTO ghs_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Hiimi Dzesu nokoke hee, Oonita Kaisahoke noke moitarenihe, Ohongahoke noomaeke moitare. Hiiremi nokoi nookaqi sahasaha minake eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Obetemi Satukeo nokoi hee, Baatetai bamu paha eehaha naataquiqi hiire qaata. Oonihe, nokoi noho toro baaqi qasa hiireta, ");
INSERT INTO ghs_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Banaita naname, Mosei napaho quba qeeteqi hee, Abi teeho nanei khametoamake baate ata qaatemi noma nohoi ata nohoke aimaqi naneho dzapake gisi qusubaitaridzoniqi qeeteta. ");
INSERT INTO ghs_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oonihe, nomamane nanemane sebeni oi qaata. Nane gotta atapa teeke naate khametoamake baatemi, ");
INSERT INTO ghs_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","noho samaqanai paha atapa oke naateqi oho qesa khametoamake baatemi, samaqana nohoi oho qesa eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ma sebeni nokoi gama oho qesa eeteqi khametoamake baatemi atapa oi paha musaqi baateta. ");
INSERT INTO ghs_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Qate atapa noi sebeni nokoke naateta. Oonita tukutuku bodzata noi nokohota paha apeke naataqu? ");
INSERT INTO ghs_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Hiiremi Dzesu hiireta, Sinabidzaho qetaqeta ma Ohongaho beedzae oke nike gama ruume naateqi oho quba obera naate oorai mae? ");
INSERT INTO ghs_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nookare. Abi ma paimane baata neta qoridzaqake bamu qesa naataquhe, qusuho angero ooraiho qesa noko oorakoi. ");
INSERT INTO ghs_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Obete nike Moseho sinabidzata gee takomami noi ee hohoho teteta abi batabatai qoridzaquhoke hiiremi nike noo oke isaitaamake oorai mae? Oi Ohongai Moseke hee, Abarahamu ma Isaka ma Dzakopo noko anake hee, Ohonga nanameiqi hiiroraiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Oke hiiremi napa moomi Ohongai teqaha abi batabatanipamuho Ohonganidzara. Baamu. Noi abi eehahaho Ohonganita noo oke nike oberama nookaama naate tukutuku bai hiirorai. ");
INSERT INTO ghs_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Hiiremi noko qesa noo hiimi qetaqeta abihota teei baa nookaqi hee, Dzesu nokoho noo ipi bagenomanipamuke hiireniqi qupadzomata. Qupadzomaqi noi Dzesu qasa hiireta, Hu noo apei hu noo qesaho qibani? ");
INSERT INTO ghs_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Hiiremi Dzesu hiireta, Noo qibai hee, Isirae abi nike nookare, ");
INSERT INTO ghs_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ohonga noi noqeke napaho Sooparanita nii Ohonga Soopara niimeho dzake eeteqi, qupa ma gisi niime ma qiba ma beedzae niimema gama noho dzake eetorare. ");
INSERT INTO ghs_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Oiqi hiiremi noo oho samaqanai hee, Nii sama niimeho quba dzasa eetoraiho isakita samaqana niimeho dzasa eetorareiqi hiiroraita hu noo qesai bamu nopoke riitaqu. ");
INSERT INTO ghs_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Hiiremi, qetaqeta abi oi Dzesuke hee, Banaita name, oi noo bagenoma, Ohongai teenanipamu. Noho temu te ooraidzaranita noo meeke nii hiire. ");
INSERT INTO ghs_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Qate, qupa ma ttittira niime ma beedzae niimema gama Ohongaho dzake eetaqu oi bagenoma. Ma nii sama niimeho dzasa eetoraiho isakita samaqana niimeho dzasa eetoraqu oi paha bagenomanipamu. Qate Ohongake qeere gabi eetaquho kiridza ma qonoqono moitaqu oi bagenomanihe, baura oi hu noo eseri eraho isaki baamu. ");
INSERT INTO ghs_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Hiiremi Dzesu moomi noi nokanokata noo oke hiiremi noi paha abi oke hee, Maa, nii Ohongaho pobi naatake boobiqi oorai oiqi hiireta. Hiiremi abi nokoi Dzesu paha qasa noo apeke hiibarota? Bamu oonita noko qaateta. ");
INSERT INTO ghs_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Qate Dzesu paha biirita dzuubaqi abike toronaiteqi eraiqi hiireta, Ikanomake eeteqi qetaqeta abi nokoi hee, Kiristui Tabitiho eema ma khataniqi hiirorai? ");
INSERT INTO ghs_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Oi Tabiti nomae Qaheuba Sumasake qusubaiteqi hee, Ohonga Soopara noi Soopara nahoke hee, Nii boto pobi nahota habese qaamake, ibo samane niihoke ana oko pesu niihota mooto soubidzakoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tabiti oke qeeteqi noomae Kiristuke Sooparaniqi hiireta. Oonita Kiristui Tabitiho sooro ma saina oomi oho tete ikanoma? Oiqi Dzesu hiireta. Dzesu noo hiire qaami abi tupu oi ttidza qidzaqi dza eete noho noo nooka qaata. ");
INSERT INTO ghs_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ma hibahiba nometa noi noorake hiireta, Nike qetaqeta abiho tete potti biire qaarare. Oi nokoi quba eranomaho dzake eetorai. Nokoi sasa khara kharerepo qoomaqi tuumaqu, mae abi samane ttuma eetoraiho soobadzata nokoke dzoobe hiiremi nookaqu, ");
INSERT INTO ghs_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","mae noko sinabidza guhuta habehabe bosabosata habesaqu, mae hoo ma patta tuputa noko teka qidzake aimaqu, ");
INSERT INTO ghs_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","mae noko ttarumiho kapurake aima muuna bamuitaqu, quba samane oonomaho dza quba minake noko eetorai. Oonihe noko sama nokome gimutta eeteqi pupu kharakhara sepeke hiirorai. Oho ipike noko quba bamenomanipamuke saridzakoi. Oiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Dzesui bodza teeta moomi qesai Ohongake ttuma moite qaataho mauba totaqita habesemi abi samane oho takurata biiromi noi moomi abi ttuma minanoma samanei oma mina oho takurata biirota. ");
INSERT INTO ghs_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Oonihe, ttarumi pai habana teei baaqi oma dzuunoma ttimuna eserike ota biiremi toea teenaho isaki naateta. ");
INSERT INTO ghs_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Oonita Dzesu tumakhameto nomeho quba hiireqi noko pobi hiireta, Ttarumi habana erai quba takurata biire oi abi samane oho takurata biiroraiho isaki gama riite. ");
INSERT INTO ghs_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Oke ana meeke nike pobi hiire. Oi noko gamaqa meupu nokomeho neta aima ota biiroraihe, atapa erai seebe nomeho neta quba gamitti noho torona oori oke gamaqa takurata biire bamuite. Oiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Oonita Dzesui Ohongaho biiri qaasuhimi tumakhameto nohota teei noke hee, Banaita name, oma qidzama noko biiri mina erake gootomi ooraike nii moorare. Uububuu! ");
INSERT INTO ghs_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Hiiremi Dzesui erake hiireta, Naga mimi nii moo hasa hiire Mae? Nookao, naga oke gootoqi oma qesa hee ma heeta mooto soubireta oke abi qesa paha aima biire bamuitemake naga oi ngaura naatakoi, oke hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Qate Dzesu ipita Oriba torata habese biiri dzaga bobotomi Peetoro ma Dzakopo ma Dzohane ma Attereo nokoi seiqake noke oho noo quba qasa hiireta, ");
INSERT INTO ghs_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Quba samane oi bodza apeta biranataqu? Ma oi biranate soubidzaquho qamodzamodza ikanoma biranataqu? ");
INSERT INTO ghs_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Hiiremi Dzesu oke rerengi eeteqi hiireta, Teei eto nikeke ikobetainoho quba bakena geema qaarare. ");
INSERT INTO ghs_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Oi abi samanei dzapa nahota baaqi hee, Anai Kiristu oniqi hiireqa abi samaneke ikobetakoi. ");
INSERT INTO ghs_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Qate qaa biranataquho noo ma qaaho qamodzamodza oho noo samaneke nike nookami oi gama biranatakoi. Oonihe, oho ipi uhubaamake qaama nike etoqa oho attike eetaino. ");
INSERT INTO ghs_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Oi abi tupu maina paina ma haba ma nagapa maina paina oho abi qesa koo ma taanga eetorakoi. Ma haba qesa ota tumu samane biranate qaarakoi. Paha seebe minai biranatakoi. Oonihe, quba oi gama heme ma bameho sohosoho kekenita minanatakoi. ");
INSERT INTO ghs_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Hiireqi Dzesui hee, Nike korabete qupadzoma qaarare. Nokoi nike batabidzareiqi noo ma qaata mootakoi, ma sinabidza guhuta nokoi nike buribaroke teetakoi. Ma nokoi nikeke ttoka ma habaho soopara ma abi qiba samaneho pengata mootomi nike ota naho khooba hiire paanaitakoi. ");
INSERT INTO ghs_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Oonihe, nagapa samaneho abiho torota sinabidza erake hiibaridzoni, qaataquho tete baamu. ");
INSERT INTO ghs_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ma noko nikeke toronaite batabidzareiqi mootoma, nike etoqa bosata hee, Napai ikaqi hiibaquiqi hiibaino. Oi nikeqeke bamu hiibaquhe, Qaheuba Sumasai hiibakoi. Oonita Qaheuba Sumasai bodza ooqata nike pobi hiibaqu noo teena oke nike nokoke pobi hiibare. ");
INSERT INTO ghs_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Oi nane teei noma nomeke baataquho quba mootakoi. Ma mai teei khata nomeke oho isakita mootakoi. Ma khameto oho qesa maimane paimane nokomeho ibo eeteqi nokoke teete baataquho isakita mootakoi. ");
INSERT INTO ghs_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Oi nike naho dzairamane oomi abi samane nikeke ibo eetakoi. Obete ape ma apei peperataamake qaaraqu nokoke Ohonga ingonaitakoi. Oiqi Dzesui hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Hiireqi Dzesui hee, Qate, isaita abi, nike qupadzomare, quba peranomake biirita upubiremake rubenga biranatemi nike mooraqu, oho bodzata apenei Dzutea habata ooraqu nokomae ao sakabaqi torata tuumare. ");
INSERT INTO ghs_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nookare. Teei naga totaqita ooqa eto totaqi temuta qeemaqa quba qesa aimainohe, ao sakaba tuumare. ");
INSERT INTO ghs_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mae teei dzoota ooqa eto paha burisi eete nagata peite ttoba ma sasa nomeke aimainohe, ao sakabare! ");
INSERT INTO ghs_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ma bodza ota khameto qurana ma amenana ooraiho paimane, nokohota bame minanipamu biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Oonihe, quba oi tamaho bodzata biranatainoho quba pupu hiibare. ");
INSERT INTO ghs_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Oi Ohongai khoobanipamuta quba korabetemi uuba ma sakaba sohoroqi biranate baaqoraihe, ipita quba bamenomanipamu biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ma Ohonga Soopara bodza oke hoteitaama naatapuko abi ma quba samane oi baamunipamu naatarori. Obete Ohongai qesa dzapaqi uhutota noi nokoho quba dzasa eeteqa bodza oke hoteitakoi. ");
INSERT INTO ghs_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Oonihe, bodza ota teei hee, Moorare, Kiristui erata ooraiqi hiibaqu, mae hee, Moorare, Kiristui ota ooraiqi hiibaqu, hiiremi nike etoqa oho noo nookaino! ");
INSERT INTO ghs_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","23","Kiristu oberaobera ma too abi oberaobera samanei biranateqa Ohonga abi qesa uhutotake nokoi mainata dzeimare hiireqi mumure ma obaoba obera samaneke mootakoi. Aoke ana nike quba samane eraho pobike hiiremi oorai oonita nike ao bakena geema qaarare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Hiireqi Dzesui hee, Obete uuba ma sakaba oho totaqita qusuho ete qupi sooromake dzasidza baibudzaama naatemi, ");
INSERT INTO ghs_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","taama qusuta uuba perebami qusuho beedzae ma tatanga gama rubabetakoi. ");
INSERT INTO ghs_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Rubabetemi anai Abiho Isaki ooqi bodza ota peretabita beedzae ma koina minama biranahimi noko moorakoi. ");
INSERT INTO ghs_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ana biranateqa angero nameke dzoobiremi tuumaqa abi dzapa hiiretake nokoi totaqi ma totaqi, qusu ma habaho moira neta ttuttuitakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Hiireqi Dzesui hee, Qate ee dzuhano qahurake nike nooka qupadzomare. Sama nohoi kebakeba naateqi sumana usaqe teetemi nike hee, Tii bodza dzomonoke ooraiqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Oho qesa quba samane ana hiire oi biranahima nike mooqake hee, Oi dzamoqa naasubiqi ao naga pouqata ooraiqi hiibare. ");
INSERT INTO ghs_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Dzuta abi nagarai bamu naataamake ooraquta quba oi gama biranatakoi, oke ana meeke nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Qusu ma ttoka oi meeke uubakoi oonihe naho noo oi bamu uubaqu. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Hiireqi Dzesui hee, Qate, bodza ma sau oohoke abi oni mae qusuho angeroni mae Khata ana, napai gama ruumenihe Mai teenai oho gesina. ");
INSERT INTO ghs_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Oonita biranataqu bodza nike ruume naateqi roqoroqo ma sahasahama qaarare. ");
INSERT INTO ghs_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Oho tete erake eete oorai. Naga teeho maikhatai naga nome qaasuqa kokora abi qesa nomeke baura pattabete moiteqi naga sooparake hee, Nii bakena geema qaarareiqi hiireqi haba kharata tuumami, ");
INSERT INTO ghs_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","nike qupadzomami nagaho maikhata paha burisi eete baabaqu, oi surenani, mae saubaponi, mae iihai dzuridzarini, mae saunabake baabaqu? Oho bodzake nike ruumenita bakena geemorare. ");
INSERT INTO ghs_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Oi nike eto meeqomi noi bukhittidzake baaqa nike oonomake moorainoho quba bakena geema qaarare. ");
INSERT INTO ghs_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Qateqa anai nike pobi hiibi noo teena oke ana minarake pobi hiire oonita nookao, nike gama iso keke bakena geema qaarare, oke Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Obete Ingona dzuma, ma abi bookha ngoru muunaridzoho dzuma, oi qupi eseriho nakuta biranataamake oomi dzube abi mimi ma qetaqeta abi nokoi Dzesuke teete kebaitare hiireqi oho gunu ma naru hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Oonihe, nokoi hee, Abi samane qaa qupadzomainoho quba napai eto noke dzumata teetainoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Obete Bettania nagapata ooqi Dzesui Siimo abi pottomunoma noho nagata peite patta muunota. Qate atapa teeho arabasta omaho mangi teei oota, oho oba mee ura moromoronoma oomi oho ttuma mina. Oonita mangi oke atapa oi aima baaqi huhuite oba oke Dzesuho qibata gesubireta. ");
INSERT INTO ghs_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Gesubiremi Dzuta ma karai dzaubadzauba irita gunugunu hiireqi hiireta, Naane quba oba uranoma erake sepeke perebiremi bamu naate? ");
INSERT INTO ghs_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Teei oba oho ttuma quba hiiremi biranatapuko ao kina 60 naatemi oke abi habanake moitemi isanatarori. ");
INSERT INTO ghs_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Hiireqi nokoi atapa oke hiimota minake eeteta. Hiimotomi Dzesu hiireta, nike qaata! Naane quba atapa oke dzakidzaki eetaqu? Noi naho irita obaoba bagenoma teeke eetemi oorai. ");
INSERT INTO ghs_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Abi habana nokoi sau samane nikeho torota ooraimi, bodza nikemae qupadzomaquta nike nokoke hoobidzareiqa hoobidzakoi. Oonihe, anai bamu nikeho toro bodza mina qaaraqu. ");
INSERT INTO ghs_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Qate atapa eraho torota ooriho isakita noi quba bagenoma anake eetemi oorai. Anake abi qurabiremi ana qoridzaqu oohoke noi qupadzomaqi naho samata oba erake suraite. ");
INSERT INTO ghs_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Oonita ttoka ma haba ika ma ikata qesa ma nike sinabidza hiibaqu ota paha atapai erake eete oho pobike nike hiiremi nookakoi. Oke ana meeke nike pobi hiire. Oiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Dzesui oma oho qamuni hiiremi, tuerebehota tee Dzuta Khariottaho nena, noi dzauba eete Dzesuke geema mootareiqi dzube abi mimiho toro tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tuumami noko noho noo nookaqi qaki eeteqi Dzuta oho ttuma moitakoiqi hiireta. Hiiremi Dzutai Dzesuke geema mootarota oho pui qiri eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Qate bookha muunaridzoho dzuma naatemi oho qupi bosabosata nokoi ingonaho kiridza dzubetomi tumakhameto nohoi Dzesuke qasa hiireta, Nii dza eete hiiremake nanai ikata tuumaqa ingonaho qonoqono oke urai eetemi nii ma napai muunaqu? ");
INSERT INTO ghs_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","14","Hiiremi, noi tumakhameto eseri nomeke dzoobireqi hee, Nagapa qiba ota nipe peitemi abi oba mangi mina aimanoma noi nipeke saaridzeqake nipe noma gama tuumare. Obete noi dzuubaqu ota nipe naga oho maikhatake hee, Banaita napahoi hee, Ingonaho qonoqono oke ana tumakhameto namema gama muunaridzonita oho aabe suruhoi kaqaniqi hiibare. ");
INSERT INTO ghs_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Hiiremake suruho heena mina noko ttarita mootomi oorai suruho oke noi nipe banaitemi nipe ota napame quba roibetare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Hiiremi tumakhameto nopo tuumaqi nagapa qibata peiteqi Dzesu nopo pobi hiiretaho isakita saridzeqi ota ingonaho kiridza roibeteta. ");
INSERT INTO ghs_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Qate ete biiremi Dzesui Tuerebema noko ota ttutturateqi, ");
INSERT INTO ghs_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","kiridza oho patta muunoqi noi erake hiireta, Nikehota teei anama nakai ttaike patta muuhibi noi ao anake geema mootakoi oke ana bamu nike ikobetaqu. ");
INSERT INTO ghs_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Hiiremi nokoho ttidza qanganatemi teena teena nokoi noke hee, Oi ana oni mae ape? Oiqi hiimi teei hee, Ana oni maeiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Hiiromi noi nokoke hee, Tuerebe nikehota teei anama naka ttuba teenaqata poinqanipamu patta giima muuhibi abi oioni! ");
INSERT INTO ghs_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nookare, Abiho Isaki quba qeetemi ooraiho isakita ana baatakoihe, apei anake geema mootaqu, Idze, noho torota quba bamenomanipamu biranatakoi! Pai noke dzoomaama naatapuko noho quba isanatarota. Oke hiireqi noi Dzutaho khooba paanaiteta. ");
INSERT INTO ghs_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hiireqi nokoi patta muunoqi Dzesui dzobadzoba teeke aimaqi agoago eete oke qooto nokoke moiteqi hiireta, Erai mee nohoho isaki oonita aima muunare. ");
INSERT INTO ghs_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Hiireqi noi khoru oke aimaqi Ohonga dzoobe hiireqi noko moitemi noko gamaqa ota muunata. ");
INSERT INTO ghs_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Muuhimi noi noko eraiqi hiireta, Dzuu nameke minaraho quba poro tongo era saqore. ");
INSERT INTO ghs_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Qate ana bamu paha eka mee eraho oba muunaquhe, Ohongaho pobi biranatemake oke ana usaqeke muunakoi oke ana meeke nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hiire qaateqi, noko hasa naa teeke hiire biranateqi Oriba torata tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tuumaqi Dzesu nokoke pobi hiireta, Sinabidzata qeeteta oi hee, Ohongai sooparake teetemi sipisipi sakabakoiqi hiiremi ooraiho isakita nike gama sakabakoi. ");
INSERT INTO ghs_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Oonihe, anai baata neta qoridzeqake paha nikeho bosa qooroqi Garirea habaho isakita tuumakoi. ");
INSERT INTO ghs_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Hiiremi Peetoro noke pobi hiireta, Nokoi gamaqa niiho nookami qanganataqu kaqa. Qate naamae bamu niiho nookami qanganataqu. ");
INSERT INTO ghs_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Hiimi Dzesu noke pobi hiireta, Idze! Poiqa nee ungapa qupi eserike noo hiibaamake ao qupi taparike nii anake raraku biidzaama naatakoi. Oke ana bamu nii ikobetaqu. ");
INSERT INTO ghs_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Hiimi Peetoroi bedzabedza eete erake hiireta, Eehe, anai niima naka esese baataqu kaqa. Oonihe ana bamu niike raraku biidzaama naataqu. Hiiremi noo teena oke tumakhameto gama pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ttoka teeho dzapa Gesemane ota Dzesui biranateqi tumakhameto nomeke pobi hiireta, Anai pupu hiibakoita nike erata habese oorare. ");
INSERT INTO ghs_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Oke hiireqi noi Peetoro ma Dzakopo ma Dzohane nokoke dzeima qeemaqi attiuboubo minake eete ququimata. ");
INSERT INTO ghs_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ququimaqi noi hee, Qupa nahoi bame minake eeteqi ana suqobire. Oonita nike erata roqoroqo ma sahasahama oorare. ");
INSERT INTO ghs_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Oke hiireqi noi gattiqa qeemaqi ttokata uhesaroqi tete apeta oho bame potti biidzaqu oho qiri eete pupu hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Hiireqi noi totoho nometa hee, Aba, oi Mai name, quba minaraho beedzae niiho toro ooraita bameho khoru erake nii naho neta aimare. Oonihe naho qupa hiibarori oi bamuhe, niihoi hiiremi ooraiho isakita biranatare. ");
INSERT INTO ghs_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hiireqi noi qori baa moomi nokoi meeqoomi noi Peetoro pobi hiireta, Siimo nii meebo? Bodza hoteqake nii eehahaqake oorare bitta eete mae? Nikeho dzo ooraihe, ");
INSERT INTO ghs_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","meera nikeho samake teetemi nike toronaho kabira naatainoho quba ao bakena geemaqa pupu hiirorare. ");
INSERT INTO ghs_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Hiireqi Dzesu paha qeema pupu hiireqi teena oke hiiroramuti burisi eete baa moomi noko paha meeqoota, ");
INSERT INTO ghs_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","oi nese nokohoi sidzobetemi noko noo apeke noke pobi hiibarota? ");
INSERT INTO ghs_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Obetemi noi tuumaqi, paha baaqi nokoke pobi hiireta, Nike uraira meeqi qidzanatoraidzo? Oionita bodza ao bamu naate. ");
INSERT INTO ghs_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nookao, Abiho Isaki anake ao kahos abiho botota moosobita qoridze napa tuumare. Mooro! Abi anake geema moosobi noi ao erata baabe. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Qate tuerebehota tee, Dzuta, noi dzube abi bosabosa ma qetaqeta abi ma abi mimi nokoho neta abi hoho teeke saridzemi nokoi taanga ma qaa dzubeke aimaqi Dzutama gama baata. ");
INSERT INTO ghs_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Obete Dzuta gemagema abi noi ago bosata abi hoho oke suu ma pai mootoqi hiireta, Anai abi kanabetaqu oioni. Noke nike karabeteqa bage eete noke aima tuumare. ");
INSERT INTO ghs_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Oke bosata hiiretanita Dzutai baaqi Dzesuke dzaga boboto kanabeteqi eraiqi hiireta, Mai name, dzoobe. ");
INSERT INTO ghs_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","47","Hiiremi nokoi Dzesuke karabetemi, tumakhameto qesa sigiqata qoorota nokohota teei qaa dzube nomeke dzeimaqi dzube abi minaho kokora abi teeke teeteqi toma gee nohoke dzooto qagaumata. ");
INSERT INTO ghs_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Qagaumami Dzesu abi hoho oke pobi hiireta, Guume abi teeke karabetaquho isakita nike qaa dzube ma taangama anake karabetare baaqorai mae? Nookare. ");
INSERT INTO ghs_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Saninoke anai biirita nike banaite qaimi nike teqaha anake karebete qaarara. Oonihe, sinabidza noota qeetemi ooraiho isakita quba eranomai biranataridzonita isanate. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","52","Dzesui oke hiiremi, tumakhameto nohoi gamaqa Dzesuke qaate sakaba tuumami ana Marekoi khata tuipanoma ooqi Dzesuke iihami abi hohoi ao anake karabetareiqi tuipa nahoke uumami ana habanake atti tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Qate abi hoho oi Dzesuke dzeima dzube abi minaho torota biranatemi dzube abi bosabosa ma abi mimi ma qetaqeta abi nokoi gamaqa noho quba ota ttutturateta. ");
INSERT INTO ghs_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Obetemi Peetoroi Dzesu ipitotoqi dzube abi minaho repa nakuta qeemaqi sogimoho torota eepa agima oota. ");
INSERT INTO ghs_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Qate dzube abi bosabosa ma batabidza abi mimi nokoi gama Dzesuke teetare hiireqi noho mee ma obera hiire qaaqi teqaha oho mee saridzara. ");
INSERT INTO ghs_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Oi abi samanei noke qomaqoma hiireta, oohihe nokoho noo totohoi teqaha teenata tuumara. ");
INSERT INTO ghs_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Qesai qooroqi noo oberake hiireqi hiireta, Abi oi hee, ");
INSERT INTO ghs_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ohongaho biiri erake abi botoma gootoota oke ana namae ngausa eeteqake qupi tapariho nakuta paha biiri temu gootakoi oonihe bamu abi gootoraiho isaki naataquiqi hiiremi nana nookata. ");
INSERT INTO ghs_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Oke hiireta oonihe nokoho noo totoho teqaha teenata tuumara, baamu. ");
INSERT INTO ghs_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Oonita dzube abi mina noi bisa qaputa qooroqi Dzesuke qasa hiireta, Nokoi niiho qomaqoma ikanomake hiirorai? Nii bamu oho noo ipi hiibaqu mae? ");
INSERT INTO ghs_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Hiiremi Dzesu nipanate noo ipi hiibaama naatemi dzube abi minai beedzae eete paha noke qasa hiireta, Nii Kiristu, Ohonga agoagonomaho khatani, mae bamu? ");
INSERT INTO ghs_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Hiiremi Dzesui hee, Oore, anai oni. Ma anai Abiho Isaki ooqi Ohonga beedzaenomaho samaqata qooro qaaqake qusuho peretabita baahumi nike moorakoi. ");
INSERT INTO ghs_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Hiiremi dzube abi minai sasa nomeke qohate hiireta, Oionita naane quba qesai paha noho qomaqoma ipibire hiibaqu? ");
INSERT INTO ghs_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Oi noi ao nomae oberama hee, Anai Ohongama sama teena oniqi hiiremi napa gama nooke. Oonita nike noke ikanomaniqi hiibaqu? Hiiremi nokoi gama qarutoqi hee, Noi baataquho pobi ooniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hiireqi, qesai noho irita ekepusa eeteqi nese ma penga nohoke sengibete noke buribaroke teeteqi hiireta, Apei niike teete? Hiiba! Hiiremi sogimo nokoi noke dzeima tuusuqi boto sepeiteqi noke teeteta. ");
INSERT INTO ghs_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Qate Peetoroi qoo repa nakuta eepa agihimi dzube abi minaho kokora paimanehota teei baaqi, ");
INSERT INTO ghs_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Peetoroke moo qeraqera eete hiireta, Nii paha Dzesu Nadzaretteho nenama nipe oori. ");
INSERT INTO ghs_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Hiimi noi bai hiireta, Nii hiireke ana ruume. Anai oho khoukhau oni. Hiireqi noi repa oke qaateqi tta eete paata tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tuumami nee noo hiireta. Obete kokora atapa noi paha Peetoroke moohiqi abi ota qoorota nokoke hee, Meeke abirai nokoho nenani. ");
INSERT INTO ghs_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Hiimi Peetoroi paha bai hiireta. Oonihe gattiqi ipita abi oona qooro oota nokoi paha Peetoroke pobi hiireta, Meenipamu nii Garirea habaho nenanita nii nokoho nenani. ");
INSERT INTO ghs_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Hiiremi Peetoro tatanga naateqi erake hiireta, Abiqahe, nike hiiroraike ana ruumenipamu. Oke ana Ohongaho pengata hiibita qaata. ");
INSERT INTO ghs_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hiimi, nee ungapa noo hiiremi qupi eseri naatemi Peetoro erake qupadzomata, Idze, Dzesu anake hee, Nee ungapa qupi eserike noo hiibaamake nii ao qupi taparike anake raraku biidzaama naatakoiqi hiire. Oke qupadzomaqi Peetoro ao tti ma ttiroba minake eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Iihai mootomi dzube abi bosabosa ma abi mimi ma ta mootota. ");
INSERT INTO ghs_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mootomi Piratoi noke qasa hiireta, Nii Dzuta abiho abi qibani, mae bamu? Hiiremi noi hee, Nii hiire, oioni! ");
INSERT INTO ghs_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Hiiremi dzube abi bosabosa nokoi quba samaneho quba Dzesu qoma dzubobirota. ");
INSERT INTO ghs_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Qoma dzubobiromi Pirata paha noke qasa hiireta, Nii moomi quba samaneho quba nokoi niike qomaqoma hiiremi nii bamu oho noo ipi hiibaqu? ");
INSERT INTO ghs_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Hiiremi Dzesui nipanatemi Piratoi qupa ororo eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Obete Ingona dzuma mina oho bodzata abi samane baaqi Piratoi sutasuta abi saqobareiqi hiiremi noi saninoke teeke saqoro qaata. ");
INSERT INTO ghs_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Qate hu ma koridza biranatemi taanga abi qesai abike teete kebaiteta nokoke sutasuta nagata mooto oomi abi tee, dzapa noho Baraba, noi nokoma gama oota. ");
INSERT INTO ghs_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Oomi abi tupui Piratoho toro peiteqi hee, Nii sutasuta abi saqororaiho isakita paha eetaqu maeiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Qate dzube abi bosabosa nokoi Dzesuke bisi naateqi geema mootomi oke Pirato moo qupadzomaqi noorake hiireta, Nike dza eetemi ana isanate Dzuta abi nikeho abi qibarake nikeho quba saqobaqu mae? ");
INSERT INTO ghs_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Hiiremi dzube abi bosabosai abi tupu oke kosikosi eetemi nokoi hee, Pirato nii Dzesuke saqobainohe noho habara Barabake nanaho quba saqobareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Hiiremi Pirato paha nokoke pobi hiireta, Nike abirake Dzuta abiho abi qibaniqi hiirorai noke anai quba apeke eetemi nikehota isanataqu? ");
INSERT INTO ghs_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Hiiremi nokoi qarutoqi hiireta, Noke hapahapanaitare. ");
INSERT INTO ghs_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Hiiremi Pirato nokoke qasa hiireta, Naane quba? Baura qanga apeke noi eetemi nike oke hiire? Hiiremi abi tupu dzaubama qarutoqi paha hiireta, Noke meenipamuke hapahapanaitare! ");
INSERT INTO ghs_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Hiiremi Pirato abi tupu oke hasu hiibareiqi Barabake nokoho quba saqorota. Oonihe noi hiiremi qaa abi Dzesuke gabeho biiroramuti qaatemi Pirato hee, Noke isanate hapahapanaitareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ma qaa abi nokoi Dzesuke aima tuumaqi qaa guhu Paraetoriota biranateqi qaa abi minaraho kira hiiremi ttutturateta. ");
INSERT INTO ghs_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ttutturateqi, noko qepuqeputa sasa hihihinoma aima noke dzaaroqi guupake papara suutoqi oke qiba nohota dzaamotota. ");
INSERT INTO ghs_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dzaamotoqi noko ttaroke Dzesuho qaki eete hiire ta, Dzoobe dzoobe, nii Dzuta abiho abi qibani! ");
INSERT INTO ghs_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Hiireqi nokoi qiba nohoke saaro sumuma teeteqi noho irita ekepusa eete noho toro pomai kotoro gaipori kootorota. ");
INSERT INTO ghs_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Oonita noko oonomake noke sosoridzo hiiroramuti qaateqi sasa hihihinoma oke kuimaqi ttoba ma sasa nohoke eeteqi, Dzesu hapahapanaitare hiireqi noke dzeima sasata biranateta. ");
INSERT INTO ghs_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Noko biranate tuumatahe Dzesui hapahapa bittake eetemi Arekhatarou ma Roupouho mai Siimo noi nagapa Kureneoho nena noi teteta tuusumi nokoi abi oke qaanate hiiremi noi Dzesuho hapahapa aima tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ma noko Dzesuke dzeima Gorigotta teka (oi qiba gotta teka) ota noko biranateta. ");
INSERT INTO ghs_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Biranateqi noko bai obake too bairaho isakima sareteqi oke noke moitetahe noi te muunara. ");
INSERT INTO ghs_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Oonita nokoi Dzesu ota hapahapanaiteta. Qate qaa abi nokoi Dzesuho ttoba ma barehota quba apeke nokome quba aimarota? Oke hiireqi noko baabe biireqi oke gama pattabeteta. Obete noko noke hapahapanaiteta oho bodzai naini kiroko. ");
INSERT INTO ghs_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ma noko qomaqoma nohoke ee sabinata qeeteta oi hee, DZUTAHO ABI QIBA ERANI. ");
INSERT INTO ghs_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nokoi guume abi eserike Dzesuma gama hapahapanaitemi teei Dzesuho pobita ootani temui mage nohota oota. ");
INSERT INTO ghs_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Oi teeho bahe sinabidza agobanipamuta Dzeseai qeeteta oi hee, Noko noke ritarita abima ooraquho isakita moototaiqi qeetemi oi ooqata meenoma naateta.) ");
INSERT INTO ghs_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Qate abi tuuma ma baaba eesuqi noko Dzesuke too neinei eete qiba baqebeteqi hiireta, Anh! Nii biiri ngausa eeteqi qupi tapariho nakuta oke paha gootaqu mae? ");
INSERT INTO ghs_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Oonita nii isanate sama niimeke ingonaiteqa ao hapahapata gaibare. ");
INSERT INTO ghs_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Hiiremi oho qesa dzube abi bosabosa ma qetaqeta abima nokoi qesa noo hiireqi noho qepuqepu eete hiireta, Hee, Abi qesake noi ingonaite baaqoraihe, sama nomeke ingonaitare oke noi ikanoma hou eete? ");
INSERT INTO ghs_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Idze, noi Kiristu, Isirae abiho abi qiba ooniqi hiiroraita nomae poiqake hapahapata quratemake napai oke moo hiisi eetare. Hiiremi abi noma hapahapanaiteta nopoi oho qesa noke too neinei eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Eetemi ete bisata ttoka ma haba sautoqi, qupi mina sooromi tiri kirokota uhubata. ");
INSERT INTO ghs_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Bodza ota Dzesui dzaubama sokateqi hee, Eroi Eroi rama sabattani oiqi totoho nometa hiiremi oho khooba erani. Ohonga, Ohonga name, nii ikanomake eeteqi anake gaubire ooiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hiiremi qesai ota qooro nookaqi hiireta. Nooka. Noi Eriaho kira hiire. ");
INSERT INTO ghs_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Hiimi teei hee, Papata! Napai moomi Eria baaqi noke aima qurataqu mae bamu? Oiqi hiireqi noi hairiama besa bidzaga teeke aima oba too bairanomata suqobire saarota soramu biireqi oho obake Dzesu moiteta. ");
INSERT INTO ghs_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Oonihe, Dzesu sokata minake eete baateta. ");
INSERT INTO ghs_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Baatemi biiriho ttoba hahari bisa qapuna qaata oi pei neta qohaba papatemi abi nakuke moota. ");
INSERT INTO ghs_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Paha qaa pobipobi abi noi qooro ooqi Dzesuke dzaga boboto quba samane mooqomi noi oonomake baatemi noi hee, Meeke abirai Ohongaho khata ooniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Paha paimane qesai sererahuke qooroqi quba oke gama mooqota. Oi Maria nagapa Magataraho nena ma, Dzakopo gattiqa ma Dzosepeho pai Maria ma Sarome ikaqi Garirea habata Dzesuke iiha qaaqi kokora nohoke eete qaata ma paimane samane ikanei Dzesuma Dzerusaremuta baata paimane nokoi oke gama mooqota. ");
INSERT INTO ghs_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Obetemi sure mootomi iihai dzumaho roiroi bodza oomi, ");
INSERT INTO ghs_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Dzosepe nagapa Arimatteaho nena (noi paha sinasina maimaneho nena ooqi Ohongaho pobi biranatarotaho beebe eete qaata) abi oi baaqi qupa too teeteqi Piratoho toro biranate Dzesuho keba quba qasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Hiiremi Dzesu ango hairiamake baatetaho pobi nookaqi Pirato sahatete qaa pobipobi abiho kira hiireqi hee, ");
INSERT INTO ghs_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Dzesu ango baate maeiqi hiiremi, oho pobike qaa pobipobi abi noke pobi hiiremi Piratoi hee, Keba nohoke Dzosepe moitareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Hiiremi Dzosepe ttoba qidza khabanoma oho ttuma eete oke aimaqi Dzesuho keba hapahapata ai qurateta. Ai qurateqi noi oke ttobama qegoroqi oma ma tapata keba naga usaqeke kaibetetaho nakuta keba nohoke mooto oma sarara teeke ai burisi eete keba naga pati pui siireta. ");
INSERT INTO ghs_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Qate nokoi Dzesuho keba mootota tekake Maria Magataraho nena ma Maria Dzoseho pai nopoi moota. ");
INSERT INTO ghs_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Qate dzuma mina oi bamu naatemi, Maria Magatara nena ma Maria Dzakopoho pai ma Sarome nokoi Dzesuho keba bibi suraitare hiireqi bibi ura moromoronoma teeho ttuma eete aimaqi, ");
INSERT INTO ghs_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","baura bodzaho samasamata nokoi saunabanipamuta tuumata. ");
INSERT INTO ghs_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tuumami ete gagabero kukubiremi nokoi keba nagata biranatake boohiqi qesa pobipobi hiireqi hee, Apei napaho quba keba naga patiho oma oke burisi eetemi papataqu? ");
INSERT INTO ghs_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Hiiqi noko moomi oma minanipamu oke apei ao burisi eetemi papate ooto? ");
INSERT INTO ghs_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Oonihe nokoi keba naga ota dzuubaqi moomi abi khata sasa khabanoma dzaabanoma noi teka pobiqata habese oomi nokoi roqobeta minanipamuke eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Eetemi noi noko pobi hiireta, Etoqa roqobetaino. Oi Dzesu Nadzaretteho nenake noko hapahapanaitemi nike keba nohoho qirike eesubi, meeke? Oonihe noi meeqoriho tekake nike moohimi no teqaha erata ooraidzara. Noi aoke qoridze papate. ");
INSERT INTO ghs_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Oonita nike tuumaqi eraho pobike Peetoro ma tumakhameto qesa Dzesuhoke pobi hiireqi hee, Dzesui ango nikeho bosa qooroqi Garirea habata tuusubiqi hiibare. Oonita Dzesui bosata nike pobi hiiretaho isakita nike ota noke meeke moorakoi. ");
INSERT INTO ghs_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Hiiremi paimane sahateta minanipamuke eeteqi keba nagake qaateqi atti tuumami attiuboubo nokoke suqobiremi noko teqaha noo oke abike pobi hiibara, baamu. ");
INSERT INTO ghs_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Dzuma oi bamu naatemi oho iihai saunabanipamuta Dzesui baata neta qoridzeqi Maria Magattara nenaho torota bosa biranateta. (Oi bosata noho irita songena sebeni oomi Dzesui nokoke iihata, atapa oioni.) ");
INSERT INTO ghs_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Qate qesai qupi samane Dzesuho torona qaata nokoi tti ma ttaka eetomi, Maria noi tuumaqi oho pobi nokoke pobi hiireqi hee, Dzesui ao eehaha naate ooraimi anai noke moori, ooiqi hiiremi noko oho pobi tomama nookatahe hou eeteta. ");
INSERT INTO ghs_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ipita nokohota eseri nopoi qeba neta qooro tuusumi Dzesui mainaho birabirata nopoho toro biranatemi moota. ");
INSERT INTO ghs_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Moohimi noi nopoke qaatemi nopoi burisi eete tuumaqi oho pobike noko gama pobi hiiretanihe, noke paha nopoho noo nookaama naateta. ");
INSERT INTO ghs_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Qate Dzesui qoridzemi abi ma paimane noke mooqi tumakhameto qesake pobi hiiremi noko noo nookaama naate ooqi bodza teeta tumakhameto 11 nokoi patta muunomi Dzesui nokoho toro biranateta. Biranateqi noi kheukhau ma qupa tatanga nokohoho quba nokoke tete hiimotota. ");
INSERT INTO ghs_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Qate baurahoke noi noko pobi hiireta, Nike ttoka ma haba samaneho abi nokoho torota tuumaqa Ohongaho boto biidza minara nokoke sinabidza erake pobi hiire sobasoba saridzaqu nokoke Ohongai ingonaitakoi. ");
INSERT INTO ghs_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Qate apenei nooka hisi eetaama naataqu nokoke Ohongai hee, Baate bamu naataquho pobiniqi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Obete qesai nooka hiisi eetemake Ohongai baura nokohoke mumure erama mee hiibakoi: Oi noko songenake iihakoi, ma noo agiagita hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Qate nokoi dzootatake aimaqu, mae quba baatanomake muunaqu oi baamu nokoke sesero eetaqu. Oonihe nokoi boto nokome khetedzanomaho irita mootomi qidzanatakoi. Oiqi Dzesui hiireta. ");
INSERT INTO ghs_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Hiire qaateqi Dzesu Sooparai qusuta peite Ohongaho sama pobiqata qoorota. ");
INSERT INTO ghs_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Qooro oomi qesa ma nokoi biranateqi haba samaneta tuumaqi ota abi sinabidza oke hiire paanaite qaata. Oonihe tuumaqi noko baura eetemi Soopara noi oho mumurema baura nokohoke mee hiire qaata. (Qate paimane nokoi tuumaqi Peetoro ma qesamane noho nokoho toro isere mootoqi nokomae noo nookata oke nokoi hiire paanaite soubireta. Ipita Dzesu nomae abike ingonaitaquho noo ma qaraqara tatangaho noo oke tumakhameto nomeho botota mootomi nokoi abi totaqi ma totaqi gama pobi hiire soubireta.) ");
INSERT INTO ghs_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O dzoobe Tteopiro: Abi qesai ao samane naateqi eeho aimaqi Dzesuho noo samane biranate soubireta oho isereke nokoi qeetemi oorai. ");
INSERT INTO ghs_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Oi noo biranatota ooqata apenei nese nokomema Dzesuma gama moo qaata nokoi oho isere mootomi qeetorai. ");
INSERT INTO ghs_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ana poma oke nookami bagenoma naatemi paha naamae noo oho khooba korabete nookaqi ttarita qeeteqi abi mina niiho quba oho isere qeetorai. ");
INSERT INTO ghs_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kiristuho pobi oke nii ao tomama nookoraihe ana gee erake dzoobiremake nii oke toronaiteqi moohimi niiho qupata meenoma naataridzoni. ");
INSERT INTO ghs_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Oionita Herotei Dzutea habaho qiba naate qaataho bodzata dzube abi tee, dzapa noho Dzakharia, noi Abiaho gemu oho nenani. Ata nohoi oho qesa Aaro, dzube abiho nenanita dzapa noho Erisabe. ");
INSERT INTO ghs_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nopoi Ohongaho pengata rike ma pobiho isakita Sooparaho hu nooho gigi ma goha samaneke qusubaite qaami nopoke iiga hiibaquho tete oorara. ");
INSERT INTO ghs_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Oonihe Erisabe qumai qaami khameto nopohoi biranataamake qaami nopo tasu naateta. ");
INSERT INTO ghs_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Qate dzube abiho ttarike qusubaite qaami Dzakharia noomae qaheuba biirita peite dzube abiho isakita Ohongaho pengata baura oke eetarotaho bodza naateta. ");
INSERT INTO ghs_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Oi Sooparaho biirita isaki ura moromoronomake qeebaquho bodza oio dzube abiho pomata quba ttarinoma kekeni. ");
INSERT INTO ghs_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","11","Oonita Dzakharia oho bodzata biirita dzuubaqi isaki ura moromoronomake qeeremi abi samanei sasata qooro pupu hiiromi Sooparaho angero teei isaki ura moromoronomaho qohare oho pobi neta biranate qoorota. ");
INSERT INTO ghs_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Noke Dzakharia moo roqobeteqi oho atti minake eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Oonihe angeroi noke erake pobi hiireta, Bamu, eto atti eetaino. Dzakharia, nii pupu hiire qaabi oho nooke Ohongai nookami ooraita ata niiho Erisabe noi niiho khata teeke dzoomakoi. Dzoomamake nii noho dzapake Dzohane hiibare. ");
INSERT INTO ghs_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Oke eetemi niiho qupa qidzanatemi nii oho qaki naatemi abi paha samane nookami khataho isaki bagenoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Oi teeho quba bahe Sooparaho neseta khata oi abi mina naatakoi. Oi paiho asi neta Qaheuba Sumasai noke raraku biire qaarakoita noi eetoqa bai oba ma oba tatangake hesataino. ");
INSERT INTO ghs_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Noi Isirae abi samaneke burisi eetemi nokoi Ohonga nokometa atimakoi. ");
INSERT INTO ghs_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Eria sumasaho beedzaeta baura eete qaataho isakita Dzohanei biranateqi Soopara napahoi nome quba abi tupu teeke mai eetaridzoho naru agoba hiireta oke Dzohanei roibetareiqi qeemakoi. Qeemaqa hiiremi oionita abi mina ma adza nokoi gama basesa nokome qaasuhiqa rike ma pobiho nokanoka saridze qesa hongasidzakoi. ");
INSERT INTO ghs_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Oke angeroi hiiremi Dzakharia angero oke hee, Maqa, ata ma naka ao tasu naate ooraita nii hiibi noo oi meeni mae? Oke ana ikanomake eete qupadzomaqu? ");
INSERT INTO ghs_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Hiiremi angero noi hee, Anai ape bahe Gabiriai Ohongaho pengata qoororai. Oionita noi hiiremi anai baaqi oho noo ao nii pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Oonihe nii naho noo nookaama naateho qubake nii ao potutu naate qaamake khata dzoomaquho noo erana hiire oi meenoma naatemake nii paha noonoma naatakoi. Oiqi hiireqi qaateta. ");
INSERT INTO ghs_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Oonita abi biiriho sasana oota nokoi Dzakhariaho beebe eetomi bodza kharanatemi noko hou eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Eetemi noi biranateqi nokoke agoago hiibarotanihe bitta eeteqi botoma qaseqase eetemi nokoi hee, Oo Noi biirita bakuho isakike moori ooniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Oonita Dzakharia noi tuhotuho baura nome kebanoke eete soubireqi burisi eete Nagapa tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Qateqa bodza ota Erisabe noi apu naate qura eeteqi dzasidza paipu oho isakita sama nome dzukuro qaaqi eraiqi hiirota. ");
INSERT INTO ghs_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Idze, abi nokoi quma nahoho ngiingi ma baaba eete qaabi oke Sooparai ai siginaiteqi quba bagenoma erake naho quba paanaisubi. ");
INSERT INTO ghs_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Qate dzasidza sikisi naatemi Ohongai Angero Gabiria dzoobiremi noi Garirea habaho nagapa Nadzerette ota biranateta. ");
INSERT INTO ghs_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Oi ota atapa somoro usaqe, dzapa noho Maria noi Dzosepeho ata pobi oota. Qate Dzosepe noi Tabitiho gemu oho abi. Oonita Gabiria noi atapa oho toro biranateta. ");
INSERT INTO ghs_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Biranateqi noi hee, Dzoobe mina, qeseba atapa, Sooparai ao niima nipemae oorai. ");
INSERT INTO ghs_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Oiqi hiiremi nookaqi roqobeteta. Noi hee, Noo eranomake hiire oho tete ikanoma? ");
INSERT INTO ghs_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Hiiremi angeroi noke hee, Maria, Ohongai niiho nookami bagenomanita nii etoqa attike eetaino, bamu. ");
INSERT INTO ghs_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Oonita nookao, nii qura eete khata dzoomakoi oonihe noho dzapake Dzesu, oi Ingona Mai, oke hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Noho dzapai peitanipamuke eetemi nokoi noke hee, Ohonga qusunanipamuho khataniqi hiibakoi. Oi Ohonga Sooparai hiiremi noi Tabiti uumi nomeho poro qereta qoobakoi. ");
INSERT INTO ghs_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ota qooroqa noi Dzakopoho eemane khametoke soopara eetorakoi, oonihe poro qere nohoho isaki agoba qaaqa baamu bamu naataqu. ");
INSERT INTO ghs_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Hiiremi Mariai angero erake pobi hiireta, Anai apu naataamake ooraita tete ikanomake eete biranataqu? ");
INSERT INTO ghs_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Hiiremi oho ipike angeroi hee, Ohonganipamuho beedzae oi Qaheuba Sumasa nohoi niiho irita qeemaqa niita takitotakoi. Oonita khata nii dzoomaqu noke hee, Qaheubana, Ohongaho Khatanipamu ooniqi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Noo oi keke bahe, Erisabe pai totaqi niihoi tasu naate oorai oonita abi noke qumaiqi hiiroraihe noi ao dzasidza sikisiho isakita qura eete oorai. ");
INSERT INTO ghs_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Oi Ohongai noo tee ma teeke hiireqa bamu bitta eetaqu. ");
INSERT INTO ghs_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Oke hiiremi Maria erake hiireta, Oionita nii hiiremi ooraiho isaki biranatare. Oi ana aoke Soopara nameho tuhotuho atapa naate oorai. Hiimi angero papateta. ");
INSERT INTO ghs_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Oonita bodza eetemi Maria qoridze ao hairiamake Dzuteaho tora ma habata tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tuumaqi noi Dzakhariaho nagata peiteqi Erisabe saridze dzoobe hiire kanabeteta. ");
INSERT INTO ghs_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Kanabohimi Erisabei Mariaho noo totoho nookahimi Dzohanei khata asita dzooto kotoromi Qaheuba Sumasai Erisabe adzahahaitemi Erisabei sokateqi hee, Dzoobe mina! Paimane minarahota nii bagenomani, oho qesa khata niiho asina oorai noio dzapanomani! ");
INSERT INTO ghs_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Oonita Soopara qidza nameho pai gotta niike ana moohimi ikanomake eete nii naho torota baabe? ");
INSERT INTO ghs_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nii nookao, nii ana dzoobe hiiremi naho tomata taasuhimi khata naho asita oorai noi ao dzooto kotoroqi qakiqaki eete. ");
INSERT INTO ghs_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Oonita Sooparaho nooi niiho torota biranateta noo oi meenoma naatakoita nii nookaqi ao hiisi eetetaho qubake nii agoagonomani. ");
INSERT INTO ghs_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Oiqi hiiremi Mariai eraiqi hiireta, Uububuu! Naho qupa khatai Sooparaho hasa hiire. ");
INSERT INTO ghs_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ohonga ingona mai name, naho gisi niiho nookami subesubenomani. ");
INSERT INTO ghs_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Oi teeho bahe tuhotuho atapa niiho anai qonotai ootanihe nii naho qupadzomami poiqa abi minarai naho pobi erake nookaqi anake agoagonomaniqi hiirorakoi. ");
INSERT INTO ghs_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Oi abi moohimi Beedzaeho Maikhatai quba bagenoma naho quba eetemi ooraita dzapa niihoi qaheubana bagenomani! ");
INSERT INTO ghs_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Apene ma apenei niike ququimorai abi oohomaho dzasake nii eetorakoi. ");
INSERT INTO ghs_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Qate boto tatanga niihoi ao abi sama qusubanomaho qupake rasikiitorakoi. ");
INSERT INTO ghs_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Abi bise ma baisenomake nii poro qereta hotou biireqi qupa gaibanomake oho tekata mootorainomani. ");
INSERT INTO ghs_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Meupunomake nii seebeta dzoobireqi abi habanaho iisuta quba qidza mooto peitorai. ");
INSERT INTO ghs_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Nii Abarahamu ma nanaho uimane neimane ma eemane khameto nokoho ma nanake naru hiiretaho isakita Isirae abi niiho qaru eetorai, nokoma nanaho dzasa minake nii eeteqi hoobirorai. ");
INSERT INTO ghs_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Oonita dzasidza tapariho isakita Mariai Erisabema nopomae naga teenata oota. Qate Erisabeho dzasidza ao naini naatemi oionita Maria burisi eete nagapa nome tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Oi teeho bahe Erisabei khata dzoomarotaho bodza naatemi noi bosa khata dzoomami tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Oonita Erisabe ma Dzakhariaho dzuu koko ma qesamane nokohoi khata biranatetaho pobi nookaqi ao ttutturateqi Erisabeke hoobire Sooparaho dzapa qiraiteqi hee, Dzoobe! Eranomaho isakita Sooparaho qupa kokora biranatemi mooraiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Qate qupi qeth naatemi noko khatake sama koko geebanomaitare baata. Baaqi maiho dzapa qusubaitare hiireqi khatake Dzakharia hiibare eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Oonihe pai bai hiireqi hee, Baamu, noke Dzohane hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Hiiremi nokoi paike hee, Qate niimaeho quni ma manita dzaapa oonomai ooraidzaranita ikanoma? ");
INSERT INTO ghs_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Oiqi hiireqi mai dzapa apeke mootareiqi noke toone eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Toone eetemi mai gee quba hiireqi ota qeeteta. Hee, dzapa nohoio Dzohane. Oke qeetemi noko gama roqobeteta. ");
INSERT INTO ghs_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Roqobetemi Dzakhariaho too saqobami eteete ao adzahaha naatemi noi Ohongaho hasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Hiiremi Dzutea habaho tora totaqi ma totaqita abi nokoke rome biire qaata qeena ma baana nokoi oho noo ma pobi gama hiire nooka pobitemi atti nokoke suqobireta. ");
INSERT INTO ghs_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Oi apene oho noo nookata nokoi atti ququimaqi hee, Khata erai ikanoma naataqu? Hiireta oi teeho bahe Sooparaho beedzae ao noho irita dzuubata. ");
INSERT INTO ghs_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Qate Qaheuba Sumasai Dzohaneho mai Dzakharia noke raraku biiremi noi too abiho isakita hiireqi hee, ");
INSERT INTO ghs_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Isirae abiho Ohonga Sooparai noko ma napaho bameke qupadzomaqi napake iboho botota hiumake boobita napa noho hasa hiibare. ");
INSERT INTO ghs_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Noi kokora abi nome Tabitiho gemuho neta ingona abi teeke saridze noke napaho quba beedzae moitemi oorai. ");
INSERT INTO ghs_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Agobanipamuke Ohongai qaheuba too abi nomeho teteta naru oke hiire baaorai. ");
INSERT INTO ghs_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Oonita apene napaho ibo naate napake sesero eetorai nokoho botota noi napake ingonaitakoi. ");
INSERT INTO ghs_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Oi noi uimane napaho ma nanake qaheuba noota qesa hongasiretake noi qupadzomaqi oho baruna heena naatorai. ");
INSERT INTO ghs_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Noi Abarahamu eebobo napahoho quba noo tatangama naru hiireta oho meeke noi poiqa napa moitake boobi. ");
INSERT INTO ghs_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Noi napake ibo napahoho ekata saqohibi. Oho qubake napa rike ma pobiho isakita qupi ma sau samaneke attiamake Ohongaho qaru eete qaarare. ");
INSERT INTO ghs_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Qate khata niike oho qesa Ohonga qusunaho too abi ooniqi hiibakoi. Oi nii Sooparaho bosa qooroqi tete nohoke biraitakoi. ");
INSERT INTO ghs_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nii abike bapotopotomi nokoi kahosaho dzamudzamu saridzeqa ingona maiho gesina naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Oonita Ohongai baruna heena naatemi napai noho ete agimare eete. Oi qesama napai khaa qupita habeseqi baataho utamoemoeta qaimi dzadza nohoi ao biranate hiiremi napai keba ma dzapaho tete nohota qeehibi dzoobe! Oiqi Dzakharia hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Oonita khata Dzohane noi bitoto qaami Sumasai noke beedzaenomaitemi noi kebanoke Isirae abiho bisata baura nome qere biidzakoiqi haba habanata hutingima qaata. ");
INSERT INTO ghs_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Bodza oho neta Romaho Kaisa, dzapa noho Augusto, noi haba ma nagapa samanenipamuta noo dzoobireqi hee, Abi mina ma gattiqa oi iso keke dzapa nome ma nomeke ttarita qeetemi oorareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","3","Oonihe tete agiagi oi Kirinio noi Siria habaho kiape qaataho bodzata baura oi biranateta. Biranatemi abi mutu ma khata ma gama dzapa nokome ttarita qeetareiqi nagapa khooba nokometa tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Oonita Dzosepeho ata dzomadzoma naasumi noi noke dzeimaqi nopoi Garirea habaho nagapa Nadzarette qaate atomaqi Dzutea habaho nagapa Betterehemu ota biranateqi dzapa nopome qeeteta. ");
INSERT INTO ghs_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Oonihe nopoi ota ooqi khata qase dzoomata. Qase dzoomami aabe naga pui siire oomi nopoi hoo nagata qeemaqi pai ota eka bosa khata nome dzoomaqi ttobama qeegoroqi ota mootota. ");
INSERT INTO ghs_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Qate haba oho totaqita hoo sipisipiho soopara qesa qaata nokoi qupibake sipisipi tupu nokomeho bakena geemaqi oota. ");
INSERT INTO ghs_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Oomi Sooparaho angeroi nokoho torota biranatemi Sooparaho koina nokoke gama rome biireta. Rome biiremi nokoi atti minanipamuke eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Eetemi angeroi noko pobi hiireta, Bamu, abi minaraho qubake ana noo qidza qakinomake nike pobi hiibare eetenita atti eetainohe toma tiite nookare. ");
INSERT INTO ghs_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Oi Tabitiho nagapa khooba erata nikeho quba ingonaho isaki teeke poiqa dzoomami oorai, dzapa nohoio Kiristu Sooparani. ");
INSERT INTO ghs_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Oonita nike qeehiqa hoo nagata moomi khata bittina teeke ttobama qegoro ota mootomi oorai oke nike mooqa oho mee qupadzomakoi. ");
INSERT INTO ghs_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Oke hiihimi idze, qusuho qaa tupu minai angero oho totaqita paana naateqi garuruiqi hiireta, ");
INSERT INTO ghs_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Abi qesai ttokata Ohongaho qupa tooba eetorai nokoho qubake noi baruna heenata oke mee hiibi oonita dzapa pobi nohoke nike qaupuitare. ");
INSERT INTO ghs_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Oiqi hiireqi angeroi qusuta dzaetemi hoo soopara nokoi qesa pobi hiireqi hee, Oionita Soopara napahoi napake quba biranate ooraiho pobi hiire oonita oke napamae moora quba ao qori Betterehemuta tuumare. ");
INSERT INTO ghs_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Hiireqi nokoi hairiamake qeemaqi Maria ma Dzosepe saridzeqi moohimi khata meenipamu hoo naga ota meeqota. ");
INSERT INTO ghs_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Oke mooqi khataho noo bosata nokoho torona biranateta oke noko ota paanaiteta. ");
INSERT INTO ghs_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Paanaitemi khataho noo hoo sooparaho toota qurateta oke abi qesa nookaqi roqobeteta. ");
INSERT INTO ghs_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Qate Maria noo ma quba ota biranateta oke qupadzomaqi iiha ma dzobidza nometa tani totota. ");
INSERT INTO ghs_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Oonita hoo sooparai burisi eeteqi noo nokoho torona biranatemi moo nookata oho quba nokoi Ohongaho hasama gegema hiire tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Qate qupi qeth naatemi bodza biranahimi Dzosepe ma kara nokoi khata oke sama koko gebanomaiteqi dzapa nohoke Dzesu hiireta, oi Maria khataho qura eetaamake oomi angeroi Dzesuho dzapa hiiretaho isaki oioni. ");
INSERT INTO ghs_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ma Moseho noota paimane khata dzoomaqi qupi pootiho isakita atahe nagata ooraridzoho teteke mai ma pai qusubaitemi oho bodza bamu naatemi nopoi khata aimaqi noke Ohonga moitareiqi Dzerusaremuta tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Oi teeho bamuhe Sooparaho hu noota noorake qeetemi qaata, Eka bosa khatai biranahima noke Sooparaho quba qaheubudzare oke qeetemi oota. ");
INSERT INTO ghs_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ma paha hu noo ota oi hee, Qusubibi eseri mae buqo eseri Ohonga moitare oiqi hiiretanita nopo qusubaiteqi biiri ota peiteta. ");
INSERT INTO ghs_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Peitemi Dzerusaremuta abi rike ma pobi teei oota, dzapa noho Simeo. Qaheuba Sumasai noho qupata baura eetemi noi Isirae abi samane qidzanataridzoho beebe eete qaata. ");
INSERT INTO ghs_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Oi noi baataamake ooqa Ohonga Sooparaho Kiristuke bosa moorakoiqi Qaheuba Sumasa ao noke qupanomaitemi oota. ");
INSERT INTO ghs_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Oonita mai ma pai biirita peihimi Sumasai Simeoke dzeimami biirita oho qesa peiteta. Oi mai ma pai khata nopomeke hu noo hiire qaataho isakinomaitareiqi qeemata. ");
INSERT INTO ghs_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Qeemami Simeo khatake amaki eeteqi Ohongaho hasa hiireqi eraiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","O dzoobe, Maikhata name. Niiho noo agobanita naho qupa ao qidzanatemi poiqa nii isanate kokora abi niime anake saqoromi hasu ma kebata baatare. ");
INSERT INTO ghs_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Oi teeho quba bahe nese namema ana ao ingonaho isaki niihoke moori. ");
INSERT INTO ghs_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","32","Isaki oke nii abi minaraho pengata paanaisubi. Noi Isirae abiho dzapa pobi mina naateqa paha raaba abi gama baibudzaquho dzadza naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Oonita noi khataho noo hiiremi mai ma pai gotta nohoi hasaqu eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Hasaqu eetemi Simeoi noko gama agoago eeteqi khataho pai Maria pobi hiireta, Nii Nookare. Khata erai khepidzeho isaki naatemi oi paha niiho qupa kotoroqi suqobidzakoi. Oi abiho qupana oorai oi noho neta paana naatemi Isirae abi qesai noke peemaiteqi rubenga saridzakoinihe qesai nota atimaqi qidzanatakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Hiimi paha atapa tasu teei ota oota, dzapa noho Aana. Noi Ohongaho too atapa, mai nohoho dzapai Panua qate gemu nohoio Asere. ");
INSERT INTO ghs_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Atapa oi somoro nometa tii sebeniho isakita apu naate qaami baatemi noi ttarumi qaami tii noho qetti po biranateta. ");
INSERT INTO ghs_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Oonita noi Ohongaho biirita eteba ma qupibake hutingima Soopara tuuhoroqi pupu baura eete qaaqi teqaha ota tta eetara, bamu! Oonita bodza ooqata keke noi Dzesu khataho neta qeemaqi ao Ohonga dzoobe hiireqi qesai Dzerusaremuta ingonaho isaki saridzareiqi beebe eetota noi nokoke khata oho noo ma pobi hiire hiireke qeemata. ");
INSERT INTO ghs_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Qate mai ma pai nopoi Sooparaho hu nooke qusubaiteqi khataho kiridza qeere soubireta. Soubireqi nokoi gama burisi eete nagapa tuumaqi Garireaho nagapa Nadzarette ota biranateta. ");
INSERT INTO ghs_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Qate Dzesu khata bitoto kotanga naate nokanokaho pobi naatemi Ohongaho baruna heena noho irita qaata. ");
INSERT INTO ghs_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ma mai ma pai nohoi ingona dzuma mina samaneke Dzerusaremuta tuuma qaata. ");
INSERT INTO ghs_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Qate khataho tii tuerebe naatemi nokoi dzuma mina oke qusubaiteqi noke dzeima atomaqi Dzerusaremuta peiteta. ");
INSERT INTO ghs_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Oonita nopoi ota khatake dzuma mina oke gama banaitomi qupi sebeni naatemi dzuma oi bamu naatemi nopoi burisi eete nagapa tuusuta. Oonihe Dzesu khatai Dzerusaremuke qaatama naatemi mai ma pai ikanomake eete oho ruume naate tuusuta? ");
INSERT INTO ghs_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Oi nopoi hee, Khatai qesama dzaira napamema baaoraiqi hiiremi sure mootomi nopoi qesamanehota qiri mina eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Qiri eete saridzaama naateqi burisi eete qiri eete tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tuumaqi qupi tapariho nakuta qiri quba minake eetomi khatai qaheuba biirita ooqi banaita mimiho tuputa habese ooqi qasa noo samaneke hiire nookahimi nopoi saridzeta. ");
INSERT INTO ghs_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Oonihe qesa samane khataho noo nookata nokoi moohimi noi nokanoka maikhataho isakita nokoho noo ipi hiire suqobireta. ");
INSERT INTO ghs_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Oke mai ma pai moo roqobeteqi pai gotta noke pobi hiireta. Khata name, nii ikaqi hiireqi nakake sesero eetemi mai niihoma nakai qupa qanga eeteqi niiho qiri quba mina eetoraimi nii era oorai. ");
INSERT INTO ghs_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Hiiremi noi nopoke hee, Naane quba nipe naho qiri eete. Mai nameho qubatu dzooke ana mai eetaridzoke nipe ruumeni mae? ");
INSERT INTO ghs_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Hiiremi khataho nooke nopoi nooka hou eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Oonihe noi nopoho noo qusubaiteqi nopoma tuumaqi nagapa Nadzarette biranateta. Qate pai gotta nohoi noo ma quba oke gama ttarima qupata mootota. ");
INSERT INTO ghs_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Qate Dzesui bitotomi nokanoka nohoi minanatemi Ohonga keke bahe abima gama noho nookami bagenoma naateta. ");
INSERT INTO ghs_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Qate Ohongaho nooi Dzohanehota biranateta oi bodza ape bahe Kaisa Tiberio noi ao tii 15 oho isakita Roma abiho abi qiba naate oomi Pottio Piratoi Dzuta abiho Kiape oota, ma Herotei Garireaho Sooparai oota, ma noma noho Piripoi nagapa Itturea ma Ttakhonitoho Sooparai oota, Risanioi paha nagapa Abireneho sooparai qaata. ");
INSERT INTO ghs_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Oi paha Anasi ma Kaipa nopoi dzube abi mimi qaata bodza ota Ohongaho nooi haba habanata Dzakhariaho khata Dzohane sobasobahota biranateta. ");
INSERT INTO ghs_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Biranatemi oionita noi ao Dzotani obaho neta qeemata. Oi abi qupa burisi eeteqi kahosa dzamudzamu saridzarotaho sinabidzake noi ota hiiremi nokoi qusubaitemi noi samaneke obama soorota. ");
INSERT INTO ghs_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Oi teeho isaki bamuhe too abi Dzeseai noorake qeeteta, Noo totoho teei haba habanata baaqi qahurata hee, Sooparaho tete ao roibeteqi kosoramu nohoke gama paanaitare. ");
INSERT INTO ghs_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tubosa poubosa oke gama gimutta eete idzoidzo naatemi ngerongaroke pobiteqa oma huhuitemi saru naatare. ");
INSERT INTO ghs_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Oke eete abi minarai Ohonga ingonaitaquho isaki moorakoi. Oiqi Dzeseai qeetemi Dzohanehota meenoma naateta. ");
INSERT INTO ghs_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Oonita abi quba mina Dzohaneho torota sabasoba saridza quba ttutturatemi noi abi basesanoma qesake hee, Apei Dzohomaho ttari nena nikeke pobi hiiremi nike Ohongaho purabake arabidzareiqi baoraidzo? ");
INSERT INTO ghs_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Oho quba nike etoqa hee, Bamu, nanaho mai Abarahamu oqai ooniqi hiibaino oi Ohongai oma eranomahota nome quba khametoke eehahaitaquho isaki ooraita nike ao qupa burisi eeteqi oho mee paanaitare. ");
INSERT INTO ghs_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nookao, aoke bose ee herake tupu teeteqi ee pareke dzootoqa eepata biidzake boobita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Oke hiiremi abi nokoi noke hee, Oonita nanai ikanomake eetaqu? ");
INSERT INTO ghs_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Hiiremi noi erake hiireta, Sasa eserinoma nikei isanate oho dzore ooraike teeke moitare ma patta iisunoma nikei paha quba oho dzore nokoke isakinomaitare. ");
INSERT INTO ghs_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Noo oonomake hiiremi ttagetti apiapi nokoi oho qesa sobasoba saridzareiqi noke qasa hiireta, Banaita, qate nanai? ");
INSERT INTO ghs_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Hiiremi noi hee, Oonita ttagettiho dzare hiiremi ooraike eto nikeme quba minaitaino. ");
INSERT INTO ghs_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Oke hiiremi qaa abi paha qasa hiireta Qate nanai? Hiimi hee, Oore, ttuma nikemeke nookami isanataridzoni. Etoqa abike qorobire nokohoke giimaqi nikemeke hee biidzaino. ");
INSERT INTO ghs_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Oonita Dzohane noi noo oonoma samaneke hiiremi abi noho nookami attinoma naatemi noko iiha dzoobireqi hee, Abirai Kiristu baabaridzoho mee oni mae? ");
INSERT INTO ghs_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hiiremi Dzohane noko pobi hiireta, Eehe, obama keke ana abike soororai. Qate naho ipita teei baahubi dzapa pobi nohoi nahoke riitanipamuke eete oorai oi oko sasa nohoho eka suutaqu anai oho quba isanataamanita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Abi oio quba apema nike soobaqu bahe eepama, Qaheuba Sumasama soobakoi. Oonihe noi sarautanomanita biranateqi noi gottara meeke isunomaiteqi sasake sarauto eepa tatangata biidzakoi. ");
INSERT INTO ghs_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Oke hiireqi Dzohanei abike sinasina hiireqi qogo ma saga samaneke hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ma paha Herote noi noma nome Piripoho ata Herotia noke karabete oomi Dzohane noi Heroteho poma qanga qesa oke teenaiteqi oho niiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Oke hiimi Herotei nookaqi noke sutasuta nagata mootota. ");
INSERT INTO ghs_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Oonihe Herotei Dzohaneke suutaamake oomi abi quba mina nokoi Dzohaneho torota sobasoba saridzareiqi ttutturatemi Dzesu paha noomae baaqi noho torota sobasoba oke saridzeta. ");
INSERT INTO ghs_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Saridze pupu hiimi qusu papatemi qusubibi quratoraiho qesake eete Qaheuba Sumasai baaqi Dzesuho irita dzuubata. Dzuubami qusuta totoho teei biranateqi hee, O qesebe khata name, ana niiho nookami bagenomani. Oiqi hiiremi nookata. ");
INSERT INTO ghs_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Qate Dzesuho tii bodza oi teutiho isaki naatemi quba oi biranateta. Oi noke abi qupa nokomeho isakita hee, Noi Eriho eema, Dzosepeho khataniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Qate Eriho mai ape bahe Mattatti, qate noho mai Rebi oonini, noho mai Merikhi ooni, qate noho mai Dzanai ma noho mai paha dzapa Dzosepe. ");
INSERT INTO ghs_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Qate noho mai Mattattia ooni, mai nohoi Amosi, ma noho mai Nahumu, qate noho mai Hesiri, ma noho mai Nagai. ");
INSERT INTO ghs_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Qate noho mai Maata, ma noho mai Mattattia, ma mai nohoi Semei, ma noho maio Dzosekhe, ma mai nohoi Dzota. ");
INSERT INTO ghs_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Qate Dzotaho mai Dzoana, noho mai Resa, qate mai nohoi Dzorobabe, qate mai nohoio Sarattie ooni, qate mai noho Neri. ");
INSERT INTO ghs_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Oni Neriho mai Merikhi, qate mai nohoio Atti, ma mai nohoio Kosamu, qate noho maio Erematamu, ma mai noho Ere. ");
INSERT INTO ghs_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Qate Ereho mai dzapa noho paha Dzosuba ma noho mai Eriese, ma mai nohoi Dzorimu, qate mai nohoio Mattatta, noio Rebiho khata. ");
INSERT INTO ghs_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Qate Rebiho mai Simeo, qate mai nohoio Dzuta, ma noho mai Dzosepe, ma mai nohoio Dzonamu, qate noi Eriakimuho khata. ");
INSERT INTO ghs_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Qate Eriakimuho mai noi Merea, qate noho maio Mena, ma mai nohoi Mattatta, mai nohoi Nattamu, ma mai nohoio Tabiti. ");
INSERT INTO ghs_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Qate Tabitiho mai Dzese, qate noho maio Dzobette, ma mai noho Boasi, qate Boasiho mai Sara ma noho mai Naasoni. ");
INSERT INTO ghs_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Qate noi Aminataho khatani, qate Atami noho mai, ma mai nohoio Arani, qateqa noho mai Heseromu, ma mai nohoi Pare. ");
INSERT INTO ghs_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Pareho maio Dzuta. Qate Dzutaho maio Dzakopo, ma noho mai Isaka, noi Abarahamuho khata. Ma Tterai noho mai ooni, qate mai nohoio Nakho. ");
INSERT INTO ghs_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Qate noho mai Serugu, ma mai nohoio Regu ma noho mai paha Perege qate noho mai Ebe ma mai noho Sera. ");
INSERT INTO ghs_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Qate Seraho mai Kaana, ma noho mai paha Arapakhata, ma mai nohoi Semu, qate noho mai Noa, qate Noaho mai Ramekha. ");
INSERT INTO ghs_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ma mai nohoi Mettusere, qate noho mai Enokha, noio Dzarettiho khata, qate mai nohoi Maharere, ma mai nohoio Kaana. ");
INSERT INTO ghs_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Qate Kaanaho mai Enosi, ma noho mai Seetti, mai nohoio Aatamu. Qate Aatamui apeho nena bahe Ohongahoni. ");
INSERT INTO ghs_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Oonita Dzesui Dzohaneke Dzotani obata qaatemi Ohongaho Sumasai noke qooro teetemi Dzesui haba habanata biranatemi iibadzai qupi pootiho isakita noke toronaite qaami noi teqaha patta oho bodzata muunara. Oonihe oho bodza bamu naatemi noho ttidza horesa eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Horesa eetemi Iibadzai noke hee, Nii Ohongaho khatai ooraiqako oionita oma erake teeke pobi hiiremi dzobadzoba naatare. ");
INSERT INTO ghs_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Hiiremi Dzesui erake hiireta, Oonihe qetaqeta teei hee, Abi patta keke muunaquko oi bamu noho quba isanataqu oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Oke hiiremi Iibadzai noke tora khara teeta dzeima peiteqi haba samane oota oke hairiamake noke banaiteta. ");
INSERT INTO ghs_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Banaisuhiqi Iibadzai eraiqi hiireta. Oho pobike gama naho botonaitemi ooraihe apeke moitaqu oke naamae. ");
INSERT INTO ghs_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Oonita nii naho torota hasama gegema hiiremi oke ana ao niiho pobi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Oke hiiremi Dzesu noke erake pobi hiireta, Qate qetaqeta paha teei hee, Ohonga Soopara niimeho hasama gegema hiireqa noqaho qaruke eetorareiqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Hiiremi noi paha Dzesuke dzeima Dzerusaremuta peiteqi pei Qaheuba Biiriho ttittirata mootoqi hee, Paha noorake qeetemi ooraita nookare. Hee, Ohongai angero nome pobi hiiremi eto niiho oko oma peemaitainoho qubake noko niike ingonaiteqi kharikhari eete qurataridzoni. Oke qeetemi ooraita nii qupadzomaqi ao tukuba qurateqi moorare. ");
INSERT INTO ghs_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Oonihe Dzesui noho noo ipi erake hiireta, Qate paha noorake hiiremi oorai, Nii etoqa Ohonga Soopara niimeke toronaitaino. ");
INSERT INTO ghs_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Oiqi hiiremi torona gama bamu naatemi Iibadzai isakiqata noke papateta. ");
INSERT INTO ghs_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Oionita Dzesui burisi eete Sumasaho beedzaeta Garirea habata biranateta. Biranatemi abi oho totaqina qaata nokoi noho pobi nooka soubireta. ");
INSERT INTO ghs_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Qate noi guhu qesaqesa nokohota dzuubaqi nokoke tete banaite qaami noko gama susupu oho hasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Oonita noi nagapa khooba nome Nadzarette ota peiteqi dzumata poma nometa sinabidza isaitareiqi qoorota. ");
INSERT INTO ghs_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Qooromi noko noke too abi Dzeseaho gee noke moitemi noi takomaqi qetaqetaho tete erake saridzeta. ");
INSERT INTO ghs_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Hee, Sooparaho Sumasai naho irita oorai oi teeho bahe noi anake ao poro qerenomaiteqi hiiremi ana abi habanake isere qidza hiiremi meupu saridzakoi, sutasuta abike saqobakoi, nese khabanomake nesenomaitakoi, qorobiremi ooraike ana qusubaitakoi. Oke eeteqi ana Soopara napameho baruna heenaho bodza paanaitakoi. ");
INSERT INTO ghs_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ooqaho isakita Dzesui isaite qaasuhiqi gee saaroqi oke oho soopara moiteqi habeseta. ");
INSERT INTO ghs_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Habesemi abi guhu oona oota nokoi gama roqobete noke rittabetota. ");
INSERT INTO ghs_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Rittabetemi noi sohoroqi noko pobi hiireta, Sinabidza erana isaitemi toma nikehota taate oi poiqanipamu meenoma naasubi. ");
INSERT INTO ghs_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Hiiremi noo bagenoma noho toota qurateta oke noko gama nookatahe iiha dzoobireqi hee, Noi Dzosepeho khatanita noi ikanomake eete oke hiire? ");
INSERT INTO ghs_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Hiiremi noi nokoho ipi erake hiireta, Meenipamuke nike anake pobi hiireqa hee, Nana nookami nii Kapanao nagapata baura bamenoma eeteta oho qesa nagapa khooba niime erata nanaho quba eetare. Oiqi nike hiibakoihe ipita nike anake bisi naate totoho eranomata ana pobi hiibakoi, Ttotta nii isanate sama niime qidzaitare oiqi nike hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Hiireqi noi hee, oi teeho quba bahe too abiho nooke haba mainaho abi isanate nookakoihe too abi teei nagapa khooba nometa hiiremi oho abi bamu qaupuitaqu oke ana bamu nike ikobetaqu. ");
INSERT INTO ghs_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Noo meenipamu erake ana nike pobi hiire nookare. Eriaho bodza agobata tii tapari ma teeho totaqita quui taataama naatemi ttoka minata seebe ttidza makanomai qaami Eriaho patta bamu naatemi ttarumi paimane samanei Isirae habata ooqi noke tuuhobarotahe Ohongai noho pati qohatareiqi ttarumi nokeho teeta dzoobiremi qidzanatetani mae? ");
INSERT INTO ghs_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Oi bamu, noi Isiraeho ttarumi paimane nikehoke potti biireqi Eriake raaba abiho ttarumi pai qee Sittona habaho nagapa Sareta ota dzoobiremi tuumaqi qidzanateta. ");
INSERT INTO ghs_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma paha too abi Eriaho bodza agobata Isiraeho abi pottomunoma samanei qaatanihe nokohota Ohongai teqaha teeke qidzaitaranihe raaba abi Naema Siria habaho abi mina noqake qidzaiteta, oonita nike khooba oke qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Oke Dzesu hiiremi sinabidzaho guhuna oota nokoi nookami nokoho humamutu biranateta. ");
INSERT INTO ghs_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Biranatemi nokoi ao qori noke nagapata hotou biireqi dzeima nagapa qeba nenaho tora ma tapata noke teetareiqi dzoobidzarota. ");
INSERT INTO ghs_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Oonihe ikanomake eeteqi noi nokoho bisata dzaake tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Oonita noi qurateqi Garirea ttuho nagapa Kapanaota biranate dzuma qesaqesaho isakita abi nokoke banaitota. ");
INSERT INTO ghs_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Oonihe noho beedzae mainanita noi nokoke noo banaitemi abi roqobeta minake eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Qate sinabidza guhu nokohota abi songena ngiinginoma teei oota noi sokateqi eraiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ae! Dzesu Nadzaretteho nena, nii baami songena nanai ikabetaqu? Nii Ohongaho qaheubananike ana gesinanita nii ao nanake ngausa eetare baabe mae? ");
INSERT INTO ghs_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Hiiremi Dzesui noke qamuni hiireqi hee, Too niime pati suutoqa abi oho neta tta eetare. Hiiremi songena noi abi oke minaraho bisata ai biiretahe noke sesero eetaamake ao biiranate tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tuumami noko gama hasaqu eeteqi qesa pobipobi hiireta, Abirai maikhataho isakita hiiremi songenai ao hairiamake biranate tuume! ");
INSERT INTO ghs_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Oio ikanoma? Noo oke hiiremi oho pobi ao haba oke igabireta. ");
INSERT INTO ghs_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Qate Dzesui baura oke eeteqi qoridze sinabidza guhu oke qaateqi Siimo Peetoroho nagata peiteta. Qate Siimoho motami humamutu minake eete oomi nokoi oke Dzesu pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pobi hiiremi noi noho irita baura eete humamutu oke qamuni hiiremi oi ao bamu naateta. Bamu naatemi noi hairiamake qoridzeqi nokoke kokora eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Oonihe ete biidzaamake heme ma bamenoma samanenipamuke abi noho torota dzeima baami noi boto nome nokoho irita mootoqi qidzaiteta. ");
INSERT INTO ghs_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Qidzaitemi songena samane areare hiireqi hee, Ae, nii Ohongaho Khataniqi hiireta. Hiiremi noi moomi noko ao hee, Kiristu oi ooniqi hiiremi noi nokoho noo tete siireqi qamuni hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Qate iihai mootomi Dzesui nagapa oke qaateqi haba habana teeta tuumata. Tuumami abi samane noho qiri eete saridzeqi hee, Eto nanake qaate tuumaino oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Hiiremi noi hee, Oonihe anai nagapa qesa samaneta Ohongaho noo ma pobi hiire soubidzareiqi noi anake dzoobiremi baatanita qaataquho tete bamu. ");
INSERT INTO ghs_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Oke hiireqi noi tuumaqi Dzutea habaho sinabidza guhu samaneta dzuubaqi ota sinabidza hiire qaata. ");
INSERT INTO ghs_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Qate qupi teeta Dzesui Genesarette oba ttuho patisigita qooro sinabidza hiimi abi nooka quba beedzae eete noke qahiqahi eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Qahiqahi eetemi noi moomi sisima eseri oba samaqata suutomi oota. Oonihe oho khaa apiapi mainata tuumaqi dzupu nokome akobohimi sisimai habanake oota. ");
INSERT INTO ghs_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Qate Siimoi sisima teeho maikhata oomi Dzesui ota peiteqi Peetoroi oke gattiqa dzoobire qeemareiqi hiireta. Hiiremi qusubaitemi noi sisimata habese abike sererahuke sinabidza banaiteta. ");
INSERT INTO ghs_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Banaite qaaramuti qaateqi noi Siimoke hee, Sisima oke dzoobire qausuta biranate khaa quba dzupu mootare. ");
INSERT INTO ghs_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Hiiremi Siimoi hiireta, Bosa qobaqoba name, nanai qupi saubapota dzupu mooto qaimi teqahama naate. Oonihe niiho too quba ana paha isanate dzupu mootakoi. ");
INSERT INTO ghs_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Oke hiire moosohimi khaa samanenipamui agomaqi dzupuke uhutare eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Eetemi noko hairiamake qesamane nokome sisima temuna oota nokoke boto sabiri eetemi baaqi hoobire khaa aima sisimanaitemi idze! Sisima suqobidzare eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Eetemi Siimo Peetoro mooqi Dzesuho khooba qupadzomaqi oko toro nohota taateqi noke pobi hiireta, Maqa anai abi qanganita nii anake qaate papatare. ");
INSERT INTO ghs_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Oiqi hiireta oi teeho quba bahe khaa quba mina aimaqi nokoi gama pairuru eeteqi noi oke hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Oi Siimo keke bahe Dzebeteoho khameto Dzakopo ma Dzohane nopoi noma gama bauraho ttaiqanita Dzesui Siimo ma nokoke hee, Nike poike sohoroqi abi eehahaho apiapi naatorakoita eto atti eetaino oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Oonita nokoi sisima oke pobiteqi unaunata biranateqi baura oke gama pekha eeteqi Dzesuke iihata. ");
INSERT INTO ghs_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Qate Dzesui nagapa teeta oomi abi pottomunoma teei noke mooqi gaipori kotoroqi dzauri hiireta, Soopara name, nii oho dza eete isanate anake qidzaitakoi. ");
INSERT INTO ghs_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Hiiremi noi boto dzoobire hesateqi noke pobi hiireta, Oore ana oho dza eete oonita ao qidzanatare. ");
INSERT INTO ghs_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Oke hiimi pottomu oi ao agimata. Agimami Dzesui hee, Eto abi teeqake oho pobi hiibainohe Mosei hu noota hiiretaho isakita nii tuuma sama niihoi qidzanate oho kiridzake nii biirita qeeremi ota khooba paana naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Hiiremi noi tuumatanihe baura oho pobi oi ao haba gegebetemi abi quba mina Dzesuho noo nooka quba ma sama qidzanata quba noho torota ttutturateta. ");
INSERT INTO ghs_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ttutturatemi oi noke suqobiremi noi seike haba habanata pupu hiibare tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Qate bodza teeta Pariseo ma hu nooho maimane nokoi baaqi tuputa habese oomi Garirea habaho nagapa abi samane totaqi ma totaqita baami oho qesa Dzutea haba ma Dzerusaremu abi nokoi gama Dzesuho torota ttutturatemi noi nokoke tete banaitota. ");
INSERT INTO ghs_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Qate noho torota abike qidzaitaquho isaki meenipamu oota. Oke hiireqi qesai abi sarosaronoma teeke dzarima aima baaqi noke dzesuho dzagata mootareiqi qeemata. ");
INSERT INTO ghs_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Oonihe abi pui siire oomi bitta eeteqi noko naga heeho biriki gee takomaqi abi oke dzarimama gama dzoobire qurateqi Dzesuho dzagata mootota. ");
INSERT INTO ghs_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mootomi Dzesu moomi abi nokoho ai tatauma oonomai oomi noi hiireta, Abiqa, kahosa niihoke ana ao dzamute. ");
INSERT INTO ghs_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Oke hiiremi Pariseo ma qetaqeta abi nokoi qesa gunugunu hiireqi hee, Ohonga teenai abiho kahosa dzamutaquho isaki oorai. Oonihe noo qaganoma erake hiire oi abi apeni? ");
INSERT INTO ghs_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ooiqi hiimi Dzesu moohimi abi gunugunu hiiremi noi noko pobi hiireta, Nike naane quba iiha ma dzoobidza oonomake eetorai? ");
INSERT INTO ghs_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Anai abi erake hee, Niiho kahosa ao dzamute oiqi hiiremi nikehota bamenoma naate mae? Oonita anai hee, Abi nii qoridzeqa qooro tuumare oke hiiremi nikehota oho qesa bamenoma naataqu kaqa? ");
INSERT INTO ghs_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Oonihe Abiho Isaki anai maikhata ooraiqi ttokata kahosa dzamutaquho tete ooraike nikemae qupadzoma qubake ana poiqa nikeho pengata abi sarosaronoma noo oke hiibakoi. Hiireqi noi abi oke hee, Nii ao qoridze dzarima niimeke aima nagapa tuumare. ");
INSERT INTO ghs_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Oke hiimi noi hairiamake nokoho neseta qoridzeqi dzarima nome meeqota oke aima Ohongaho hasa hiireqi nagapa tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tuumami noko hasaqu eetemi atti noko suqobiremi Ohongaho subesube hiireta. Nokoi hee, Idze, poike quba nese agiagike moori! Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Qateqa ipita Dzesui teeta tuumaqi moomi ttagetti apiapi tee, dzapa noho Rebi (Matteo) noi oho qohareta habese oomi noi noke hee, Baa anake iihare. ");
INSERT INTO ghs_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Oke hiiremi noi qoridze baura oke ao gaubireqi noke iihata. ");
INSERT INTO ghs_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Iihaqi noi bodza mootoqi naga nometa Dzesuho quba patta ma kabira minanipamuke mootoqi ttagetti apiapi qesa ma abi maina paina nokoi Rebima gama ota habese muunota. ");
INSERT INTO ghs_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Muunomi Pariseo ma qetaqeta abi qesai Dzesuho tumakhameto nookami qanganatemi hee, Nike ikaqi hiireqi ttagetti apiapi ma kahosa oonomaho abima gama oba ma patta muuhibi? ");
INSERT INTO ghs_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Hiiremi Dzesui nokoho noo ipi hiireta, Ttottaho quba hiirorai oi sama rikerikenoma bahe khettedzanomai hiirorai. ");
INSERT INTO ghs_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Oonita anai abi rike ma pobike bahe kahosanomake qupa burisi eetare hiire baaqorai. ");
INSERT INTO ghs_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Hiiremi nokoi noke hee, Dzohane sobasobaho mai noi hiiremi noho tumakhametoi bodza samaneke hutingi naate pupu baura eetorai ma teena oke paha Pariseo ma nanaho tumakhameto eetorai. ");
INSERT INTO ghs_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Qate tumakhameto niihoi tete oke ruume naateqi oba ma pattaho qausunomani. Hiiremi Dzesui nokoke pobi hiireta, Nookao, Abi teei ata teeke naasuhimi abi oho qesamane nokoi qidzoke hutingi naataqu. ");
INSERT INTO ghs_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Qate meenipamuke ipita apu oke nokoho bisata karabetemake bodza ota nokoi hutingiho tete gesina naatakoi. Oiqi hiireqi noi ipita baatarotaho qahurake hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ma noi tete agoba ma usaqeho qahura noo teeke nokoho quba hiireta. Hee, Abi teei sasa nome usari eeteqa bamu ttoba koko usaqe teeke aima sasa qosana nometa hiboto isanataqu. Oke eetaquko usaqe oi agobahoma qesa dzaira eetaama naatemi oho pui paha mina naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Oho qesa abi teei bai oba usaqe korabeteqa bamu oke nuupu agobata uqumami isanataqu. Ota uqumaquko bai oba oi qausu qohaba perebaqi nuupuma gama bamu naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","39","Oi abi teei bai oba agobaho isakike gesina naate baaorai noi qidzoke hairiamake tete usaqe oke muuna dza eetaqu, oi teeho bahe noi hee, Agobaio naho quba isanatoraiqa hiibakoi. Oonihe bai oba usaqe ana hiire oke paha nuupu usaqeta uqumaquho teteke qupadzomare. Oi nikeho poma agoba ma naho tete usaqeho qahuranita oho tete biranatemake abima gama qidzanatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Dzuma teeta Dzesuma nokoi uiti dzoo bisata tuusuhiqi tumakhameto nokoi mee qesa oke rumuto botoma kurutete muunota. ");
INSERT INTO ghs_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Muunomi Pariseo qesai oke moohimi nokohota qanganatemi nokoi hee, Baura oonomake dzumata eetaqui qaganomanita oke naane quba eete? ");
INSERT INTO ghs_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Hiiremi Dzesui noko pobi hiireta, Eehe, Tabiti qesamane nomema nokoho ttidza saa eetemi noi eetetake nike te isaite qupadzomoraidzarani kaqa. ");
INSERT INTO ghs_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Oi noi Ohongaho parai nagata peiteqi dzobadzoba Ohongaho dzagata mooto qaata oke abike qaga hiire qaami dzube abi keke oke muuna qaatanihe Tabiti patta qaganoma oke aima muunaqi paha qesamane nome moitemi muunata. ");
INSERT INTO ghs_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Hiireqi Dzesu nokoke hee, Oonita ana naamae Abiho Isaki ooraiqi oho qesa dzumaho maikhatanita noo oke qaato. ");
INSERT INTO ghs_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Qate paha dzuma teeta Dzesui sinabidza guhuta peiteqi sohoroqi abi banaiteta. Banaitemi abi boto atimanoma teei ota oota. ");
INSERT INTO ghs_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Oomi Pariseo ma qetaqeta abi nokoi hee, Dzesui abi oke dzumarata qidzaitaquko noke noota mootakoiqi hiireqi noke nese taate mooqota. ");
INSERT INTO ghs_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Oonihe nokoho iiha ma dzoobizake noi ao qupadzomaqi abi boto atimanomake hee, Nii qoridze bisa qaputa qoobare. ");
INSERT INTO ghs_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Oke hiimi noi qoro qoorota. Qooromi Dzesui nokoke hee, Maqa, ana nikeke qasa noorake hiiremi nookare. Dzumata baura qidzake eeteqi abi qidzaitaquho isaki oorai, eo quba qangake eete abike teetaqu? ");
INSERT INTO ghs_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Oke hiireqi nokoke asabiremi nokoi nooama naatemi noi abi oke hee, Boto niime tataitare. Oke hiimi qusubaitemi botoi pobirateta. ");
INSERT INTO ghs_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pobiratemi nokoho dzauba peitemi noko qesa pobipobi hiireqi hee, Dzesuke ikanomake eetaqu oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Bodza oho neta Dzesui torota peitemi qupi sooromi noi Ohongaho torota pupu hiire qaami iihai mootota. ");
INSERT INTO ghs_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Iihai mootomi noi tumakhametoho kira hiireqi nokohota tuerebeke asateqi ipita nokoke paha Qaru Abi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Dzapa nokohoi Siimo, apeke noi paha Peetoro hiireta, ma noma noho Attereo, ma Dzakopo, ma Dzohane, ma Piripo, ");
INSERT INTO ghs_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ma Battoromeo, ma Matteo, ma Ttoma, ma Arapeoho khata Dzakopo, ma Romake qirutomaquho dzaodzaonoma, dzapa noho paha Siimo, ma Dzakopoho khata Dzuta, ");
INSERT INTO ghs_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ma Dzuta Khariotta nena apei Dzesuke geema mootota, nokoqaho dzapake Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Hiire qaateqi Dzesui hapata gaibaqi katata roroko biiremi tumakhameto qesa, ma paha Dzerusaremu abi ma Dzutea abi ma besa neta Tiro ma Sitona nagapa abi, kitu minai baata. ");
INSERT INTO ghs_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nokoi noho noo nooka quba baata ma qesai sama rikerike noho torota saridza quba baata. Baami noi nokoho quba baura eeteta paha songenanomake qidzaiteta. ");
INSERT INTO ghs_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Oi abi qidzaitaquho beedzae noho torota ttuunomai oomi abi samanenipamui noke qegoroqi hesatare bedzabedza eetemi noi nokoke gama qidzaiteta. ");
INSERT INTO ghs_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Obeteqi noi tumakhameto nome nese taate pobi hiireta, Abi quba qesaho dzore, niikeho isaki bagenoma oi teeho bahe nikemae Ohonqaho pobi mai eetakoi. ");
INSERT INTO ghs_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Qesa ma nikei poiqa ttidza saa eetorai nike iisunoma naatakoita eto tti ma sori hiibaino. Qesa ma nikei poiqa tti ma ttakake hiiroraihe ipita nike too inatakoita nike ao qupa too teetare. ");
INSERT INTO ghs_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Qate qesa ma nikei Abiho Isaki anaho dzapata atimami abi qesai nikeho ibo eete dzapa nikeho qanga hiireqa qore hiire iihami tuumakoi oonihe nikeho isaki bagenoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Oke erake qupadzomare, too abike uimane neimanei oonoma eete qaataho qesa nikeke eetakoihe oho quba ipi ma ari nikeme minanipamuke qusuta saridzakoita heme oonomai biranahimake ao qaki ma naki eetare. ");
INSERT INTO ghs_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Oonihe meupu minanoma nikei ipi ma habara nikeme ao saridze qaate. Oonita iisu minanoma nikeho isaki bamu naatemi idze, nikeho ttidza uhubakoi. ");
INSERT INTO ghs_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Qesa ma nikei poike qaki ma nakita ooraihe, dzasa! Nike ipita tti ma ttaka minanipamu hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Qate qesa ma nikeho dzapake abi samane nookami bagenoma naatoraihe idzi! oi quba attinomanipamu; uimane neimane oho qesa agobake too abi oberaho dzapa nookami bagenoma naate qaatahe, qanganipamu! ");
INSERT INTO ghs_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Qate ana noorake hiiremi nookare! Ibo nikemeho quba dzasa eetare. Nikeke bisi naatorai nokoke kokora eetare. ");
INSERT INTO ghs_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","29","Ma abi nike baru hiirorai nokoke noo qidza hiibare. Noko nike qomoqoma hiiremi nokoho quba pupu hiibare. Teei nike ngibasa temuta teetemi temuke paha bobotare. Ma teei niiho sasa karabetaquko oionita eetoqa noke ttoba qaanataino. ");
INSERT INTO ghs_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nikeho torota quba teeho qasa hiiremi moitare. Moiteqa eto oho ipi quba hiibaino. ");
INSERT INTO ghs_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nike dza eetemi abi nokoi nikeke ikanoma eetaqu oho isakita nike paha nokoke eetare. ");
INSERT INTO ghs_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Qate qesai nikeho kokora eetemi nike oho ipike nokoqaho kokora eetaquko oho mee kaqani? Bamu, oi ttoka abiho kokora isaki keneni. ");
INSERT INTO ghs_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Oi erake eete oorai. Teei niike kokora eetemi oho habarake nii noke keke kokora eetaquko Ohongai oho quba niike dzoobe hiibaqu mae? Bamu, oi raaba abiho teteni. ");
INSERT INTO ghs_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma abi teei niike quba moitemi niiho tinau noho torota ooraimi nii abi ooqake keke quba moitemi noho tinau niiho torota ooraquko abi sinabidzaho sasana oorai noi oke moohimi oi ikanomake eete noho dzebidzebi naataqu. Bamu oi pisinisi abi nokomae keke qesa hoobiroraiho teteni. ");
INSERT INTO ghs_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Oho quba nike ibo nikemeho quba dzasa eete kokora eetemi nikeho torota quba teeke tinauta aimare hiiremi eto oho iiha ma dzoobidza eetainohe oho tinau aimare. Oke eetemi Ohongai oho ipi ma habara minamina nikehoke hiibakoi. Oi teeho bahe dzoobe hiibaamaho abi ma abi basesanoma nokoho quba Ohongai ohonga naatoraita nike oho tete suimami nikeke Ohongaho khametonipamu ooniqi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ohongai gimuba hemenomanita nike oho qesa gimuba hemenoma naatare. ");
INSERT INTO ghs_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Dzesui hee, Nikei abike qomaqoma hiibaama naatemi bamu nikeho qomaqoma hiibaqu. Nikei qore ma geema hiibaama naatemi bamu nikeho qoro ma geema hiibaquhe nike abiho kahosa qaatemi oho qesa nikehoke qaatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nike baruna heenata moitemi oho ipike nikeke hee ma heeta isakiamake moitemi una biidzakoi. Oi teeho bahe qupa niimeho isakita moitemi oho isakita paha niike moitakoi. ");
INSERT INTO ghs_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Oke hiireqi Dzesu paha qahurata nokoke noorake pobi hiireta, Nese khabanomai nese qupike teteta dzeimami ikanoma naataqu bahe nopo esese koseta taatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Hiireqi Dzesui paha hee, Banaita teei tumakhata nome tete banaitemi noi ao mai nome qorobidzaquho tete ooraamanihe tumakhameto kebanoqake baura oke mai eete soubireqake maiho isakita peitaqu kaqani. ");
INSERT INTO ghs_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Hiireqi noi qahurata hee, Niiho neseta pasenaho bittaku teei ooraimi ikanomake eete nii oho ruume naate temu nimeho neseta miriququ mooqa aimaqu? ");
INSERT INTO ghs_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Bittaku oi niiho neseta ooraimi nii oho ruumeke hee, Dzaira name nii qaatemi ana kahosaho miriququ niiho nesena ooraike aimare, oke hiiremi isanataqu mae? Oonita quseripo niimeke qaasuhiqake bosata pasenaho bittaku niimaeho neseta oorai oke hiumake eeteqa moo isanatemi miriququ temu niimeho nesena ooraike nii aimami bamu ooqata obera naataqu. Qahura oke qupadzomare! ");
INSERT INTO ghs_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Hiireqi Dzesui paha hee, Ee qidzai te mee qanga goomoraidzara oho qesa ee qangai teqaha mee qidzake goomoraidzara. ");
INSERT INTO ghs_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Oi abi teei ee mee teeke moo qupadzomaqi ee oho dzapa hiibakoi. Tukunita bamu kharuba aimaqu ma ttidzadzata oottoke saridzaama oke qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ma abi teeho qupana oorai oi ao too nohota biranatakoi. Oi abi qangaho qupata noo hee eete oorai oi ao noho toota biranatakoi oho qesa abi qidzaho qupa iisuta meupu qidzai oorai oi paha too nohota paana naatakoi oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Dzesui paha erake hiireta, Nike isanate anake hee, Ohonga Sooparaniqi hiiroraihe naamae hiirorai noo oke nike naane quba qusubaitaama naatorai? ");
INSERT INTO ghs_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nookare, teei naho torota baa noo nookaqi qusubaitorai noi quba apeho isaki oke ana poike nike banaitakoi. ");
INSERT INTO ghs_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Oi teei naga gootare hiireqi ttoka toqomaqi manoqo suunipamuta khoobake paanaite ota sohoro simetti bittite oma mooto peite soubiremi tatanga naateta abi oi oho isaki ooni. Oi quu taatemi oba sooroqi naga tatanga oke bitta minake eeteta oi teeho bahe naga bageke eete goototaho isaki. ");
INSERT INTO ghs_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Qate teei naho noo tomama nooka arabirorai noi abi sepeke naga ttoka heeqata gootomi oba sooro naga teetemi bamu naatetaho isaki. Oonihe abi oho rubenga minanipamu, oke qupadzomare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Oonita Dzesui noo samane oke gama hiiremi abiho tomata taatemi noi qurateqi nagapa Kapanaota tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Qate nagapa ota Romaho Qaa pobipobi teei oomi noho kokora abi bagenoma teei batabata mina eete oota. ");
INSERT INTO ghs_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Oomi noi Dzesuho beedzae pobi nookaqi qeemaqi Dzuta abi mimi qesa nokoho torota biranate Dzesuho quba qasa hiireta, Hee, Noi isanate hiiremi naho kokora abi qidzanataquni mae? Tuuma noke qasa hiibare. ");
INSERT INTO ghs_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Hiiremi tuumaqi nokoi Dzesuho torota hee, Maqa, Abi dzapa pobinomanita isanate baura oke noho quba eetaquni mae? ");
INSERT INTO ghs_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Oi noi Isirae abi napaho dza minake eeteqi aoke napaho sinabidza guhu teeke gootomi oorai. ");
INSERT INTO ghs_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hiiremi Dzesui nookaqi nokoma tuumata. Tuusuhimi naga oi sererahuke oomi Qaa abi noi dzairamane dzoobireqi hee, Soopara name anai abi qanganita nii anaho nagata peitaquho isaki bamu, eto sama niime sesero eete baabaino. ");
INSERT INTO ghs_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Oi ana naamae niiho torota qeemaquho midza eete. Oonihe ana sogimo name teeke hee, Tuumareiqi hiiremi tuumakoi. Ma paha teeke hee, Baabareiqi hiiremi noi baabakoi. Ma anai kokora abi nameke hee, Erake eetare. Oke hiima ao eetakoi oonita oonoma noo hiibaquho geebai paha niiho torota ooraike ana qupadzomami nii kharata oho nooqake hiiremi naho kokora abi ao qidzanatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Oke hiiremi Dzesu nookaqi abi samane noma nokomae tuumota nokoho tomata noi Qaa abi oho hasahasa hiireta, Idze, ai tatauma nohoi mina. Oonomaho isakike anai te Isirae abi napameho bisata saridzara oke ana bamu nike ikobetaqu. ");
INSERT INTO ghs_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Hiireqi Dzesui kokora abi qidzanatarotaho noo hiiremi Qaa abiho qaru khameto nokoi burisi eete nagata biranate moomi Qaaho kokora abi noi ao qidzanate oota. ");
INSERT INTO ghs_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Qate iihai mootomi Dzesui nagapa Naini ota tuusumi abi kitu mina nokoi noho tumakhametoke gainene eete gama tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Oonita noi nagapa oke dzamoqaite moohimi ttarumi paiho khata teena baate oomi noho kebake ai tuumaqi nagapa abi samanema nokoi tti ma ttaka hiireqi tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tuumami Dzesu Sooparai ttarumi paike mooqi dzasa eeteqi hee, Bamu, eto tti hiibaino. ");
INSERT INTO ghs_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Oke hiiqi noi qeemaqi parangi oke hesatemi abi aimota nokoi roroko biiremi noi erake hiireta, Abi khata, niike ana hee, Qoridzare. ");
INSERT INTO ghs_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Hiiremi baatetai qoro habese noonoma naasuhimi Dzesui noke paima oorareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Hiiremi nokoi gama atti minake eeteqi Ohongaho hasa hiireqi hee, O Ohonga, nii abi nanaho toro ogama baaqi nanaho bisata too abi mina teeke upubiremi oorai, dzoobe! ");
INSERT INTO ghs_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hiiremi oho noo ma pobi oi tuumaqi ao haba oho totaqi ma Dzutea haba qesa gama gegebeteta. ");
INSERT INTO ghs_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Oke eetemi Dzohane sobasobaho tumakhametoi Dzesu eetotaho isere gama maiho torota mooto soubireta. Oonita Dzohanei nookaqi tumakhameto nomehota eserike uhutota. ");
INSERT INTO ghs_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Uhutoqi nopoke hee, Abi oke qasa noorake hiibare, Kiristui baabakoiqi hiireta oi nii oonimae bamu? Nanai paha teeho quba beebe eetaqu mae? Oiqi hiireqi nopoke dzoobireta. ");
INSERT INTO ghs_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Dzoobiremi Dzesuho torota biranate hee, Dzohane sobasoba noi nakake dzoobireqi hee, Nipe tuumaqa Dzesuke qasa noorake hiibare, Kiristui baabaridzo oi niini mae nanai paha teeho beebe eetoraidzo, oiqi hiiremi nakai baabe. ");
INSERT INTO ghs_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Oiqi hiiremi Dzesui baura nome ipibireqi khettedza ma hemenoma samaneke qidzaiteqi songenai abiho irina oota samaneke iihami biranate tuumami noi nese qupi qesa samanake nesenomaiteta. ");
INSERT INTO ghs_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Oonita baura oke eesuqi Dzesui Dzohaneho tumakhameto nopoke pobi hiireta, Nike moomi abi nese qupi nesenoma naatorai, ponei pobiratorai, pottomunomai saarari naatorai, toma susui toma uhuborai, baatetai eehaha naatorai ma abi qubaho dzore nokoi sinabidza nookami bagenoma naatorai oonita qubarake nipe moo nooka soubire oho isereke korabete Dzohaneho torota mooto soubidzare. ");
INSERT INTO ghs_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Noke pobi hiireqa hee, Dzesui hee, Naho nookami qanga naataama abi oonomaho isaki bagenomanita nii sutasutata ooraihe qupadzomare. Oiqi hiireqi nopoke dzoobireta. ");
INSERT INTO ghs_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Dzoobiremi Dzohaneho qaru khametoi tuumami Dzesui sohoroqi Dzohane sobasobaho nooke abi tupu ona oota nokoke qasa hiireta, Dzohane noi haba habanata oomi nike noi abi ikanomaniqi hiireqi ota qeemata? Hee, Uta tooro eebeke buribaro eetoraiho isakiniqi hiiretani mae? ");
INSERT INTO ghs_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Eo hee, abi sasa nee ma baunomaniqi hiire qeemata. Oi bamu, abi sasa nee ma baunoma sasa khepo khaponoma oke nii isanate meusu nagapa qibaqata mooraridzonihe noi oonoma bamu. ");
INSERT INTO ghs_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mae nike hee, Too abi oonita moorakoiqi hiireta? Iidzo noi too abi bagenoma oonihe paha too abiho isaki riitorai. ");
INSERT INTO ghs_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Abi oi ape bahe nohoke Ohongai erake qeetemi oorai, Nookare, qaru khata nameke anai Kiristu niiho bosata dzoobiremi tuumaqi tete niihoke ao roibetakoi. Ooqi hiiretanita Dzohane noi abi oioni. ");
INSERT INTO ghs_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Oonita paimanei abike dzoomoraihota teei Dzohaneke riitaquho isaki ooraama. Oonihe noo oi ttoka samaho dzapa pobi kekenita Ohongaho pobi naatoraihota minama gattiqai gama oonomaho dzapa pobike suqobirorai. ");
INSERT INTO ghs_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Oke hiiremi abi samane oona oota nokoi ttagetti apiapima gama Ohongahoke nookami bagenoma naateta oi teeho quba bahe nokoi bosata Dzohaneho neta sobasoba saridzeta. ");
INSERT INTO ghs_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Oonihe Pariseo ma hu nooho maimane nokoi Ohongaho pengata sama nokome sesero eeteqi Dzohaneho sobasoba bai hiire qaata. ");
INSERT INTO ghs_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Oonita Dzesui Pariseoma nokoke qupadzomaqi eraiqi hiireta, Abi naga nike quba apeho isakita mooto hiiremi isanataqu, ma nikei quba apeho qesani? ");
INSERT INTO ghs_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Khameto sobadzata habese iinga naateqi hoho teei hoho temuke hee, Ae, nanai ao inabi teetemi nike naane quba naa teetara, qate nanai tti ma ttaka hiiremi nike ikaqi hiireqi oho surupo eetaama naateiqi hiirorai. Oonita Pariseo ma hu nooho maimane nikei oho isakita basesa eete Ohongaho kira temu ma temu kaitomaama. ");
INSERT INTO ghs_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Oi Dzohane sobasobana noi bai oba ma dzobadzobaho hutingima baaqi baura eetemi nike noke hee songenanomaniqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Qate Abiho Isaki anai oho hutingiamake baaqi baura eetemi nike anake hee, Oo abi qausunoma, bai obaho muhimuhi noi ttagetti apiapi ma kahosa abiho dzairaniqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nookao, nokanokaho teteke apene qusubaitemi meenoma naatorai nokoio teteoho subesube hiibaridzonihe nikemae tete temuho baike hiirorai oho qesa temuke bai hiirorai, oi attinomani! ");
INSERT INTO ghs_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Oke hiiremi Pariseohota teei Dzesu noma nopomae patta muunareiqi hiiremi Dzesui noho nagata peite uhesaroqi qidzanatota. ");
INSERT INTO ghs_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Qidzanatomi idze, nagapa oho atapa kahosanoma teei nookami noi Pariseo oho nagata qidzanatomi noi omaho mangi ura moromoronoma teeke aima naga ota peiteta. ");
INSERT INTO ghs_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Peiteqi noi Dzesuho oko torota qooro surupo minake eetemi surupo oi taate oko nohoke akobohimi noi habese qiba gee nomema oko nohoke dzamutota. Dzamutoqi oko nohoke kanabohiqi bibi ura moromoronoma nome aimaqi ooma oko nohoke suraiteta. ");
INSERT INTO ghs_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Suraitemi Pariseo noi mooqi qupa nometa hee Ae, atapa pasenanomanita abirai too abi oorapuko atapa noke hesatoraike noi ao qupadzomaqi bai hiibarori. ");
INSERT INTO ghs_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Oke qupata hiimi Dzesu noke pobi hiireta, Siimo, oi Siimo maina, nakaho noo oorai ooiqi hiireta. Hiiremi noi hee, Banaita name, isanate hiibo. ");
INSERT INTO ghs_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hiiremi Dzesui hee, Qateqa abi eseri nopoi tinau abi teeho torota qaata, Temuho tinau oi siriba paipu hattatti, qate temuhoi pipiti. ");
INSERT INTO ghs_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Oonihe nopoi tinau nopome teetare bittake eete qaami oho maikhata oke mooqi kahosa nopohoke sepeke qagaumata. Qagaumami nii qupadzomami abi nopohota apei maikhata oho dza minake eetaqu? ");
INSERT INTO ghs_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Hiiremi Siimoi oho ipike hee, Siribaho kahosa paipi hattatti naateta abi oioni kaqa. Hiiremi Dzesui hiireta, Oke meeke nii hiire. ");
INSERT INTO ghs_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Oke hiireqi Dzesui atapa oke nese taate Siimoke pobi hiireta, Ataparake nii moo. Anai naga niihota peitemi naane quba nii anaho oko akobetareiqi oba ana moitaama naate. Oonihe atapa erai surupoma oko nahoke akobeteqi qiba gee nomema dzamute. ");
INSERT INTO ghs_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Hiibi ana niiho nagata peitemi nii anake kanabetaama naate, qate atapa oi ao naho oko kanabeteqi qaataama. ");
INSERT INTO ghs_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Oho qesa nii bibi qidzama naho qibake suraitarorihe bamuta ataparai niiho habara naate oko nahoqake oho bibi qidzama suraite. ");
INSERT INTO ghs_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Oonita ana hiiremi korabete nookare. Noho pasena samane qaariti bamu naatemi noi naho dzaodzao minake eete qaarakoi. Qate nii oni mae apei kahosa nome moohimi gattiqa naatemi noi anake ruume naataqu abi oonomai qidzoke naho dzaodzao minake eetaqu oke niimae qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Hiireqi noi atapa oke hee, oionita ana niiho kahosa ao dzamute. ");
INSERT INTO ghs_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Oke hiiremi qesa noma uhesaro qidzanatota nokoi qesa pobipobi hiireqi hee, Abirai ape noi paha abiho kahosake dzamutaqu? ");
INSERT INTO ghs_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Hiiremi Dzesui atapa oke erake pobi hiireta, Ai tatauma niihoi isanatemi nii qidzanate oonita hasu ma kebata tuumare oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Qate kebanoke Dzesui tumakhameto tuerebe nomema noko nagapa minama gattiqata ogamaqi Ohongaho sinabidza nokoke pobi hiire tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Tuumami paimane qesai noke gainene eete qubatu nokometa quba saridzeqi noke kokora eete tuumata. Oi Dzesui nokohota songena hotou bireta oi paha Maria Magattaraho nena, noho neta Dzesui songena sebenike hotou biireta, ma paha Heroteho tuhotuho abi Khoudza noho ata Dzoana ooni, qate Susana ma paha paimane qesa samane nokoi tuhotuho baura qidza samaneke nokoho quba eete qaata. ");
INSERT INTO ghs_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bodza ota nagapa maina painaho abi quba mina noho torota biranatemi noi qahura teeke noko pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Bababa abi teei gottara nome bababa eetare tuumata. Tuumami qesai teteta taatemi abi qooromi nee qusunai baaqi muunata. ");
INSERT INTO ghs_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Qate gottara qesai oma heeta taatemi suna peitemi bibi bamu naatemi ohoumata. ");
INSERT INTO ghs_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","8","Qate qesai baa bisata taatemi baai peite suqobireta. Oonihe gottara qesai ttoka bibinomata taate suuna peite mee goomami goottara teenai ao hattattiho isaki naate gaira naateta. Hiireqi noi hee, Tomanomai nookare. ");
INSERT INTO ghs_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Oke hiiremi Dzesuho tuumakhametoi noho torota qahura oho qasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Hiiremi Dzesui hee, oi erake eete oorai. Abi minarake qahura noota hiiremi nokoi tomama nookami pobirataama naatemi nesema moohimi rikeqomaama naatemi hasaqu eetakoi. Qate oho khoobake ao nikemae saridzaridzoni. ");
INSERT INTO ghs_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Qahura oho khoobai erani. Gottara hiire, oio Ohongaho noo. ");
INSERT INTO ghs_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Oonita qesai teteta taate suuna peitorai oi abi qesai sinabidza nookaqi ao hiisi eete qidzanataridzonihe Iibadzai baaqi oke abiho qupata karabebetoraiho isaki. ");
INSERT INTO ghs_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Qate gottara qesai oma heeta taate suuna peite ohoumorai oi abi qesai sinabidza ttidza qidzaqidzama nookoraihe oho husi ma pai dzoobidzaama naate qaami kaipo ma qangahasi biranatemi ao taatoraiho isaki. ");
INSERT INTO ghs_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Qate gottara qesai baa bisata taate suuna peitemi baai suqobirorai oi abi qesai noo oke nookoraihe ttokaho iinga ma siidza ma iiha ma dzoobidza samane biranateqi sinabidza nokohoke pupubiremi meeama natoraiho isaki. ");
INSERT INTO ghs_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Qate gottara paha qesai ttoka bibinomata taate suuna peite gaira naatorai oi paha abi qesaho qupa adzahaha naatemi korabete nooka hiisinipamuke eete batigara naatorai ma bauraho mee samane goomoraiho isaki ooni. ");
INSERT INTO ghs_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Oonita qahura oi quba ape bahe abi teei dzongi qeereqi qohareta mootomi dzadzai minarake baibudzaquho isaki. Qate abi dzongi oke qohare pesuta mootomi dzadza biranataama naatemi bamu isanataqu. ");
INSERT INTO ghs_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Oi quba dzukudzukuna ma dzahedzahena oi gama iso keke paananipamu naate soubidzaridzoni. ");
INSERT INTO ghs_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Oonita teeho dzadza oho isaki ooraimake noke paha ipibire moitakoi. Qate teeho isaki bamu naatemi noho torona oorarori oke paha noho neta karabetaridzonita nike noo nookami eto arabidzaino. ");
INSERT INTO ghs_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Qateqa pai gotta ma nomamane dzabamane nohoi Dzesuke moorare baami abi pui siire oomi noko bitta eete sasata oota. ");
INSERT INTO ghs_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Oomi teei noke oho pobi hiireqi hee, Maqa, Pai gotta ma nomamane dzabamane niihoi sasata ooraiqi niiho quba hiire. ");
INSERT INTO ghs_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Hiiremi noi noko erake pobi hiireta, Naho pai ma nomamane dzabamane nahoi apene bahe Ohongaho noo nookaqi qusubaitorai nike oioni. ");
INSERT INTO ghs_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Bodza teeta Dzesui sisimata peiteqi tumakhameto nomeke hee, Napamae oba ttu biireqa totaqi qee neta biranatare. Hiiremi nokoi parai qusubaite qeemota. ");
INSERT INTO ghs_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Qeehimi Dzesuho nese sidzobetemi meeqota. Meeqomi bapamuho isaki teei tora neta tooromi obaho pouma noko suqobidzare eetemi attinoma naateta. ");
INSERT INTO ghs_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Attinoma naatemi tumakhametoi noho toro baa tukutoqi hiireta, Mai! Mai naname, napai dzaetake boobi. Oke hiimi noi qoridzeqi obaho pouma ma bapamu gama qamuni hiiremi ao kebarate bamu naateta. ");
INSERT INTO ghs_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Oke eetemi noi noko qasa hiireta, Teeqa, nikeho ai tatauma kaqani? Hiiremi nokoho sama suu qooromi hasaqu eeteqi noko qesa pobipobi hiireta, Ae, abirai sama ikanoma ooraimi oba ma utai gama noho noo qusubaitorai? Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Oonita nokoi qeehiqi Geraseno haba totaqita unateta. ");
INSERT INTO ghs_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Unateqi Dzesui ttokata peqihimi abi songena samanenoma teei noke saridzeta. Oonihe abi oi agoke naga qaateqi ttoba ma bareamake tuumaqi nesetu ma oma nagata qaata. ");
INSERT INTO ghs_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Noi Dzesuke mooqi idze ma mare hiire noho dzagata taate sokateqi hiireta, Oo Dzesu Ohonganipamuho khata nii anake ikabetaqu? Eto nanake sesero eetainoiqi niike dzauri hiire. ");
INSERT INTO ghs_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","30","Oiqi hiireta oi songenai qupi samaneke abi oho irita baami qesai noke eka ma ngibira tatangama suutoqi noke bakena geema oomi noi sutasuta oke gama uhutomi songenai noke dzeimaqi haba habanata tuuma qaata. Oonita Dzesui noke qasa hiireta, Dzapa niihoi ikanomani? Oke hiiremi songena samanei noho irita oomi noi hee, Anaho dzapaio Hubani. ");
INSERT INTO ghs_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Oke hiiremi Dzesui songena abi oke qaatareiqi hiireta. Hiiremi songenai hee, Eto nanake dzoobiremi paha iibadza nagata tuumainoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Qate hoo kitu teei qeba neta peeku muusa oomi nokoi hee, Qate nii hiiremi nana isanate hoo oho irita dzuubare. Hiiremi te bai hiibara. ");
INSERT INTO ghs_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Oonita songenai abi oke qaateqi hooho irita dzuubata. Dzuubami hooi hapa rometa sakaba qurate obata dzaga susumaqi baateta. ");
INSERT INTO ghs_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Qate hoo soopara nokoi quba oke mooqi sakaba tuumaqi oho isereke hoo poka naga ma nagapa abi gama pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pobi hiiremi nokoi quba oke moorare baaqi Dzesuho torota biranate moohimi abi songenanomai qaatati qidzanateta noi ao qupa pobirate ooqi ttoba ma sasa dzaabanomai oota. Noi Dzesuho oko torota habese noho noo nookaqi oomi nokoi atti minake eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Eetemi bosata Dzesui ikanomake eete songenanomake qidzaiteta oke apene moota nokoi oho isere gama ota isaiteta. ");
INSERT INTO ghs_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Isaitemi Geraseno haba oho abi totaqi ma totaqi nokoi gama atti uboubo eeteqi qupa muunaqi Dzesu nokoke papatareiqi hiireta. Hiiremi noi paha sisimata peiteqi burisi eete tuumarota. ");
INSERT INTO ghs_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Oonihe abi bosata songenanomai qaata noi Dzesuho gainene tuumare hiiremi bai hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Hee, Nii burisi eete nagapa tuusuhiqa Ohonga niike qidzaite oho isereke gama noko moite soubidzare. Hiiremi noi tuumaqi nagapa abike gama susupu pobi hiireqi hee, Eranomake Dzesui anake eetemi ooraiqi hiire hiireke tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Qate Dzesui burisi eete tuumaqi nagapata biranahimi abi tupu minai noho beebe eeteqi noho dzoobe ma kanakana hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Hiireqi Sinabidza guhu soopara, dzapa noho Dzairo, noi baa Dzesuho torota subateqi hee, Ana dza eetemi nii naho nagata baabare. ");
INSERT INTO ghs_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Oi teeho bahe khatata teena naho, noho tii 12, noi batabata minake eete oorai. Oke hiiremi Dzesui ota tuusuhimi abi samanenipamu noke qahiqahi eete tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tuumami atapa dzuu topoto qaata noi tii bodza tuerebe oho isakita ipi uhubaama qaami ttottai noke qidzaitaquho isaki bitta eete qaata. ");
INSERT INTO ghs_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Oonihe atapa oi qeemaqi Dzesuho sasake ngingitti eesuhimi idze ao dzuu ipi uhubata! ");
INSERT INTO ghs_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Uhubami Dzesui hee, apei anake hesate? Hiiremi nokoi gama bai hiiremi Peetoroi hiireta, Mai name, abi minai niike rome biire qahiqahi eetoraita qupadzomo. ");
INSERT INTO ghs_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Hiiremi Dzesui hee, Anahota qidzaitaquho beedzae teei teehota qeeme oonita apei ana hesate? ");
INSERT INTO ghs_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Oke hiiremi atapa oi moohimi sama nome dzukubaquho isakiama naatemi noi tititi eete baaqi noho torota subateqi minaraho pengata isere nomeke mootoqi hee, Aoke nookami ana qidzanate. ");
INSERT INTO ghs_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Oke hiiremi Dzesu noke pobi hiireta, Khatata name ai tatauma niihoi isanatemi nii qidzanate oonita keba ma dzapata tuumare. ");
INSERT INTO ghs_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Noo oke Dzesu hiiremi Guhu sooparaho nagata teei baaqi soopara oke pobi hiireta, Maqa, niiho khatata ao baate bamu naate oonita etoqa banaita sesero eetaino. ");
INSERT INTO ghs_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Oonihe Dzesui oho pobi nookaqi guhu sooparake hee, Bamu, nii ai tatamaqi eto iiha ma dzoobidzake eetaino. Khatata niihoi qidzanatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","52","Oke hiireqi noi naga ota peite moomi nokoi tti ma ttaka hiiremi noi hiireta, Khatatai baataamanihe meeraho isakita ooraita eto tti ma ttaka hiibaino. ");
INSERT INTO ghs_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Oke hiiremi qesai moomi ao baatanipamuke eete oomi nokoi Dzesuke too khepidze eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Oonita Dzesui abi minarake hotou biireqi Peetoro ma Dzohane ma Dzakopo ma mai ma pai qaanateqi khatata oke botota aimaqi noho kira hiireta, Khatata nii qoridzare! ");
INSERT INTO ghs_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Hiiremi hekhettidza hiireqi noi ao hairiamake qoridzeta. Qorihimi Dzesui noke patta moitareiqi hiireta. Hiiremi mai ma pai roqobeta minake eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Oonihe nokoi eto abike oho pobi hiibainoho qamunike Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Qate bodza ota Dzesui tumakhameto tuerebe nomeke ttuttuiteqi abi songenanoma ma heme ma bamenomake qidzaitaquho beedzae nokoke moiteta. ");
INSERT INTO ghs_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Moiteqi nokoi qusuho noo ma pobi hiireqa abi qidzaitareiqi nokoke dzoobireta. ");
INSERT INTO ghs_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Dzoobireqi noi hee, Nike etoqa teteho quba samane khakhaumaino, oi sumuni, mae asini, mae heebani, mae ttumani, mae ttoba ma sasaho paramu, oke eto aimaino. ");
INSERT INTO ghs_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Qate nagapa teeta biranateqa eto somobasomo eetainohe naga teenaqata ooma, baura bamu naatemi paha nagapa teeta tuumare. ");
INSERT INTO ghs_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","6","Qate nagapa teei nike kokora eetaama naatemi nagapa oke qaasuhiqa khooba nokohoke paanaitareiqi oma aima oko nikeme dzamutoqa tuumare. Oke hiiremi nokoi nagapa samaneta tuumaqi ota qusuho isere qidza mootoqi hemenomake qidzaiteta. ");
INSERT INTO ghs_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Qate ttoka ma haba oho soopara Herote noi noo ma baura samane oho pobi nookaqi hou peu eeteta. Oi teeho quba bahe noi Dzohaneho paru geematanita abi qesai hee, Dzohanei paha qoridzeqi baura nome ipibiroraiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Qate qesai hee, Eria oioniqi hiiremi qesai paha hee, Too abi agoba teei baata neta qoridzeqi eetoraiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Oke hiire qaami Herotei erake hiireta, Dzohaneke ana ao paru geematanihe abiraho pobike abi ikanoma hiiremi ana oho totohota nookorai? Oke hiireqi noi Dzesuke moora quba dza minake eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Qate tumakhameto nokoi baura nokome soubireqi burisi eete isere nokomeke Dzesu pobi hiireta. Pobi hiire soubiremi noi nokoke dzeima seike tuumaqi nagapa Bettesaitta ota tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Oonihe abi tupu oi ao qupadzomaqi noke iihami noi nokoke moo dzoobe hiireta. Hiireqi noi Ohongaho noo ma baura noko pobi hiireta, qate hemenoma hiiremi noi nokoke qidzaiteta. ");
INSERT INTO ghs_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Qate ete aparana naatemi Dzesuho tumakhametoi noho torota biranate pobi hiireta, Napai haba habanata ooraita nii abi tupu erake dzoobiremi nokoi nagapa qesa ma abiho dzoo naga totaqi ma totaqina oorai ota tuumaqi heeba saridzeqa meerareiqi hiibare. ");
INSERT INTO ghs_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Hiiremi noi hee, Eo, nikemae nokoke heeba moitaqu? Hiiremi nokoi hee, Oonihe nanaho torota oorai oi dzobadzoba paipu ma khaa ngoru eseriba oqaionita nanai isanate tuumaqi abi tupu mina eraho quba ttuma eete patta saridzaquni mae? ");
INSERT INTO ghs_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Oonihe abi quba mina, oi paipu ttauseni. Oke hiiremi noi tumakhameto pobi hiireta, Nike hiiremi abi dzare piipiti oho isakita hohoma habese tuumare. ");
INSERT INTO ghs_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Oke hiiremi noko abi pobi hiiremi gama oke eete habese soubireta. ");
INSERT INTO ghs_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Obetemi noi dzobadzoba paipu ma sekana ngoru eseri oke aima qusu moohiqi agoago eete qootoqi tumakhameto moitemi ttihu biireta. ");
INSERT INTO ghs_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ttihu biiremi abi gama muuna isanatemi qetta ma saru aimami kamo tuerebeho isaki hee baata. ");
INSERT INTO ghs_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Qate bodza teeta Dzesui tumakhametoma noko qaheubata pupu hiire ooqi noi noko qasa hiireta, Abi tupu nokoi anai ape ooniqi hiirorai? ");
INSERT INTO ghs_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Hiiremi hiireta, Oo qesai hee, Dzohane sobasobaniqi hiiroraini, qesai hee, Eria ooniqi hiiroraini, paha qesai hee, Too abi agobaho teei qoridze baura eetorai ooiqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Hiiremi noi nokoke toronaiteqi hee, Oore, oonihe nikemae anake ikaqi hiiroraiqi hiireta. Hiimi Peetoro erake hiireta, Bamu, nii Ohongaho Abi Mina Kiristu. ");
INSERT INTO ghs_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Hiiremi nokoi eto abike oho pobi hiibainoho quba noi qamuni hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Dzesui Peetoro ma nokoke hee, Anaio Abiho Isaki oke nii ao hiirenihe Dzuta abi soopara ma dzube abi mimi ma qetaqeta abi nokoi ana sesero minake eete bai hiireqa teetemi baatakoi. Oonihe qupi tapari naatemi ana ao qoridzakoita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Oonita noi noko paha noorake pobi hiireta, Anake iihaquho dza oi teeho torota ooraquko noi isanate sama nome maranga biireqa hapahapaho pobi hiireqi anake iihare. ");
INSERT INTO ghs_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Oi teei sama nomeho oorama qaara qaanateqi qaraqaraho dzore naatakoi, qate teei naho quba oorama qaara nome qaanataama naateqi qaraqara saridzakoi. ");
INSERT INTO ghs_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Oi erake eete oorai. Teei ttuma baura eete qaaqa ttokama haba gama mai eete soubiremi oi isanate burisi eete abi oke ingonaitaqu? ");
INSERT INTO ghs_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Eo oi heme nohoke adzahahaitaqu? Oi bamu, oonita teei Abiho Isaki anaho midzani mae noo nahoho midzake eete ooraquko ipita anai Mai ma qaheuba angeroma gama naamaeho dzapa pobita biranataquta anai oho qesa abi oonomake midzata mootakoi. ");
INSERT INTO ghs_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Oonihe meeke ana hiire, Ohongaho dzapa pobi biranahimi abi napaho bisata qooro ooraihota qesai baataamake ao nese nokomema moorake boobi. ");
INSERT INTO ghs_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Oke hiire qaatemi qupi qeth naatemi Dzesui Peetoro ma Dzohane ma Dzakopo nokoke dzeima tora kakata pupu hiibareiqi peiteta. ");
INSERT INTO ghs_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Peiteqi noi sohoro pupu hiimi nese ma penga noho ma sasa nohoi gama khabanoma hihihinoma naateta. ");
INSERT INTO ghs_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Naatemi idze, abi eseri oi Mose ma Eria nopoi oho qesa dzadza ma koinama biranateqi noma nokoi qesa noo hiireqi Dzesui Dzerusaremuta dzamonoke baura soubidzarotaho noo hiirota. ");
INSERT INTO ghs_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Oonihe Peetoro ma kara nokoho nese sidzobetemi meeta. Meeqoqi paha nese parara eeteqi abi eseri Dzesuma qooro oota nokoho dzadza ma koina gama moo roqobeteta. ");
INSERT INTO ghs_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Oonita Mose ma Eriai Dzesu qaatare boohimi Peetoroi dzaga hosohoso quba hiireta, ");
INSERT INTO ghs_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mai name, napa erata oorai oi dzapanomanita nanai isanate parai naga tapari qusubaitare, teei niihoni teei Mosehoni teei Eriaho. ");
INSERT INTO ghs_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Oonihe noo oke hiihimi dzorobi teei baaqi nokoke sengibetemi noko atti ququimata. ");
INSERT INTO ghs_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ququimami dzorobiho neta totoho teei biranateqi hiireta, Eraio khata tobe sumanoma namaehonita noo nohoke korabete nookorare. ");
INSERT INTO ghs_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Qate noo totohoi bamu naatemi noko moohimi Dzesui noqeke oota. Oonita tumakhameto tapari nokoi teqaha oho isereke abi pobi hiire qaararanihe Dzesu qusuta peiteta ooqata hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Qate iihai mootomi nokoi tora neta gaibami abi samane noke saridzeta. ");
INSERT INTO ghs_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Saridzeqi nokohota teei too dzoobireqi hiireta, Oe, Banaita name, khata erake moorare. ");
INSERT INTO ghs_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Noi naho buqo mutu teena. Oonihe songena teei noke aimami ao areare hiiremi ttidzagori amagorike eetemi too qarosa perebami aima kurukaru teeteqi te hairiamake qaatoraidzara. ");
INSERT INTO ghs_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","41","Obetemi anai baa tumakhameto niihoho torota dzauri hiiremi noko songena oke hotou biidzare bitta eete qaatemi oorai. Oke hiiremi Dzesui tumakhameto qesa eraiqi hiireta, Idze, abinaga houpeu ma gau, sau samaneke anai nikeke amaki eete baa qaimi, bodza apeta nikemae qooro tuumaqu? Seke khata oke erata aima baabare. ");
INSERT INTO ghs_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Oonihe nokoi noke aima baahumi songena paha khatake aimaqi baqebaqe eeteta. Eetemi Dzesui songena ngiinginoma oke qamuni hiireqi khatake qidzaiteqi maiho dzagata mootota. ");
INSERT INTO ghs_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mootomi abi minarai nookami Ohongaho dzapai poro kiranoma naateta. Oonihe nokoi quba oonomaho hasahasa hiimi Dzesui tumakhameto nome erake pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Noorake korabete nooka qupadzomare. Anaio Abiho Isaki oonihe anake ao geemaqa abiho botota mootareiqi hiiremi oorai. ");
INSERT INTO ghs_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ooiqi hiiretanihe nokoi tomama nookaqi teqaha oho mee saridzara ma noko noke oho qasa hiibare bitta eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Qate noko ruume nokometa qesa pobipobi hiireqi hee, napahota apenei Dzesuma gama abi mimi naataqu? ");
INSERT INTO ghs_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Oonihe Dzesui ao qupa nokohoho noo gesina naateqi khata gattiqa teeke aimaqi noke nokoho bisata mootomi qoorota. ");
INSERT INTO ghs_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Qooromi noi noko pobi hiireta, Nike naho dzapa qusubaitare hiirorai mae? Oonita teei naho quba eeteqi khata eranomake aima kokora eetoraquko oi anaho dzapa qusubaitaquho isaki naatakoi. Oi naho dzapa qusubaiteqa mai ana dzoobireta dzapa nohoke qusubaitakoi. Oonita qupadzomare, abi kokoranoma, sama gaibanoma noio abi minani. ");
INSERT INTO ghs_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Hiiremi tumakhametohota Dzohanei oho ipike hee, Mai naname, Oore, oonihe nanai moohimi abi teei niiho dzapa quba eeteqi songena abiho irita oota oke iihami nana abi oke qamuni hiireta oi teeho bahe noi teqaha napaho ttarita oorara. ");
INSERT INTO ghs_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Hiiremi Dzesui noke hee, Bamu. Teei nike ibo eetaama naateqi baura qidzake eetorai oi abi ikanoma bahe dzairanita eto abi oonomake qamuni hiibaino. ");
INSERT INTO ghs_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Qate Dzesui dzamonoqake qusuta peitarotaho bodza naatemi noi Dzerusaremuta tuumareiqi sama nome qaasumata. ");
INSERT INTO ghs_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Oke qupadzomaqi noi bosa qaru dzoobireqi hee, Tuumaqa Samaria habaho nagapa teeta naho quba roibetare hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Hiiremi nokoi tuumaqi roibetarotahe haba oho abi nookami Dzesui paha Dzerusaremuta tuumarotaho isaki naatemi nokoi biisi naate noke naga qaanateta. ");
INSERT INTO ghs_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Qaanatemi Dzakopo ma Dzohane nookami nopohota qanganatemi hiireta, Soopara nakame, nii dza eetemi nakai hiiremi eepa teei qusuta taateqa nokoke dzakasire bamuitaqu mae? ");
INSERT INTO ghs_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Hiiremi noi nopoke noosa hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Oonihe noko nagapa oke qaateqi temuta tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Qate nokoi teeta tuumami abi teei baaqi noke hee, Nii tuumoraita ana niima nakai tuumakoi. ");
INSERT INTO ghs_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Hiiremi Dzesui noke pobi hiireta, Eehe, neei ttaqanomani, haa teekoi oho qesa suturunomani. Qate anai Abiho Isaki oonihe ikata qepe ma haba saridzoraqu oi baamu, oonita qupadzomare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Qate abi mainake noi hee, Nii anake iihorareiqi hiireta. Hiiremi noi hee, Oore, oonihe nii qaatemi bosata naho mai baatemi ana qurabireqanoke niike iihakoi. ");
INSERT INTO ghs_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Hiiremi Dzesu eraiqi hiireta, Nookare, Keba nokoio keba nokomeke qurabidzaquho isaki ooraini qate nii, nii isanate tuumaqa aoqake Ohongaho noo ma pobi paanaitare oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Qate teei paha noke hee, Soopara name, anai isanate niike iihorakoi oonihe nii qaatemi ana bosata tuuma qesamane name aipo biireqanoke iihakoi. ");
INSERT INTO ghs_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Hiiremi Dzesui qahurata hiireta, Abi teei bose aubotare boohiqa mainake mooraqu noi bamu Ohongaho pobi quba isanataqu, bamu! ");
INSERT INTO ghs_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","2","Qateqa, noo oi gama bamu naatemi Dzesu Sooparai qaru khameto qesaho quba paha hiireta, Noi hee, Mee gooma oorai oi meupu, oonihe baura abi oberaqanita nike rumutaquho maike dzauri hiiremi noi ao baura abike dzoota dzoobidzare. Oiqi hiireqi noi 70 oke uhutoqi noi guhu ma agapa qesa samaneta tuumarotaho isakita nokoke eseri eserike ao bosa dzoobireta. ");
INSERT INTO ghs_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Dzoobireqi noi hee, Oionita nike tuumare, oonihe sipisipi khametoke haa teekoho bisata dzoobiremi attinoma naatoraiho isakita ana nike dzoobihibi. ");
INSERT INTO ghs_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Oi nike eto asi aimaino, ttuma sengi aimaino, oke sasa aimaino. Qate nike teteta tusuhiqi abi saridzeqa eto nokoma qesa noo ma too minake eetaino. ");
INSERT INTO ghs_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","6","Ma nike naga teeta peitareiqa hee, Ohonga dzoobe! Oke hiiremi ai tataumanomai ota oomake oi bamu sapara naataqu. Qate oho abi ooraama naatemi nike mainata tuumami noo oi paha temuta meenoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Qate baura abi ipi ma ari nome ma nomeke saridzaridzonita nike teeta peiteqa nokoma keke muuna ma aima eete ooqa baura soubireqake nagapa mainata tuumare. Oke eetemi bamu somobasomoho isaki naataqu. ");
INSERT INTO ghs_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Oi nike nagapa ape ma apeta peitaqu oho abi nikeke kokora eeteqi patta ikanoma nikeho dzagata mootaqu oke nike isanate aima muunare. ");
INSERT INTO ghs_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nagapa oho hemenomake qidzaiteqi nokoke hee, Oionita nike ao Ohongaho pobi naasubi. ");
INSERT INTO ghs_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Qate nike nagapa teeta peitemi noko nikeho bai hiiremi nike otoba pati nokohota biranate eraqake hiibare, ");
INSERT INTO ghs_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Nookao, ao nike Ohongaho pobi naatarorihe bai hiiremi oko hau nakameke oma erata dzamutomi oi nikeho khooba paanaitakoi oiqi hiibare. ");
INSERT INTO ghs_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Oi Sotomu nagapa abi nokoi quba bamenoma saridzorakoihe idze, nagapa teeho abi nikeke bai hiibaqu nokoio bame minanipamu saridzorakoi. Ooiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Oohoke Dzesui hee, Idze khoradzi nagapa, ma idze Bettesaita! Obaoba bamenoma nikeho bisata eeteta oho isakita Ttiro ma Sitto nagapa besa pakina oorai nokoho bisata oho isakike paanaitapuko nokoi agobaqake some ma ttarumiho isakita qupa burisi eetarota. ");
INSERT INTO ghs_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Oonita nokoho bame urai ooraiho Khoradzi ma Bettesaitake maripa eetaquho bodzata nikeho bame oi nokohoke suqobidzakoi. ");
INSERT INTO ghs_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Qate Kapanao. nikeho dzapake aima qusubaitaquni mae? Oi bamu. Dzapa nikehoi taatemi nike iibadza nagapata tuumakoi. ");
INSERT INTO ghs_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Oiqi hiireqi noi burisi eete qaru khameto nomeke hee, Apenei nikeho noo nookaqui paha nahoke nookakoi. Qate nikeho noo bai hiibaqu nokoi paha naho bai hiibakoi. oho qesa mai ana dzoobireta noho bai hiibakoita qupadzomaqi tuumare, oiqi hiiremi tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tuumaqi baura eete qaarumuti qaateqi qaru khameto nokoi sama geqogeqoma burisi eete baa Dzesuho torota isere hiireqi erake hiireta, Oo Soopara naname, nana niiho dzapata hiiremi meenipamu songenai nanaho noo qusubaite abi qaatorai. ");
INSERT INTO ghs_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Oonihe nokoi oonomaho totohota hiiremi Dzesui erake hiireta, Ae, moo nookami Saataho isaki baibaiho tomidzata ao qusuta taateo? Nookare. ");
INSERT INTO ghs_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Meeke ana beedzae nike moitemi nike dzotata ma besabesaho isaki qorobidzakoi ma nike iboho beedzaeke suqobiremi quba oonomai bamu nike sesero eetaqu. ");
INSERT INTO ghs_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Oonihe, songenai nikeho noo qusubaitoraiqaho quba eto qaki eetainohe dzapa nikehoi qusuho ttarita baranate oorai oho quba isanate dzoobe hiibare, oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Bodza ooqata keke Qaheuba Sumasai Dzesuke uumami noi Ohonga hasa hiireqi hiireta, O mai name, qusu ma ttokaho maikhata, nii ttokaho nokanoka ma gesinanomaho neseke sirihami nokoi baura erake mooraamanihe oke nii sama gaibanomake banaitoraiho qubake ana niiho hasama gegema hiire. Oore, mai name, nii nookami tete bagenomanita oho isakita nii eetorai, buububu! ");
INSERT INTO ghs_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Oke hiireqi Dzesui noko erake pobi hiireta, Baura minarake mai nahoi boto nahota mootomi oorai. Oonita khataho khoobanipamu oke mai keke gesinani, qate maiho khooba oke ape bahe khata anaio gesina ma paha anai apeneke banaitare hiibaqu nike ma nokoi paha baura oho gesina aimakoi. ");
INSERT INTO ghs_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Hiireqi noi tumakhameto nomenipamuke asabireqi seike erake hiireta, Maa, quba nike moorai oi teeho bahe Ohongai nikeho nese uhutomi moorai. ");
INSERT INTO ghs_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nookare. Nike moorai quba oke too abi ma uimane neimaneho abi qiba samane nokoi moora quba dza minake eete qaatahe te moorara, ma nike nookorai noo oke nookare dza eete qaatanihe te nookara. Oiqi hiiremi nookata. ");
INSERT INTO ghs_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Bodza teeta hu nooho mai teei Dzesuke toronaitareiqi qoridze qasa hiireta, Banaita name, anai ikake eeteqa qaraqara saridzaqu? ");
INSERT INTO ghs_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Hiiremi Dzesu noke hee, Qate nii hu nooho qetaqeta isaitemi ikaiqi hiirorai? ");
INSERT INTO ghs_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Hiiremi noi hiireta, Hu nooi hee, Nii qupa ma sama, dza ma dzasa oke beedzae niimema gama susupu Ohonga Soopara niimeho torota mootorare. Oke hiireqi paha hee, Nii sama niimeho quba dzasa eetoraiho isakita temu niimeho quba dzasa eetorare oiqi hu noo hiirorai. ");
INSERT INTO ghs_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Hiiremi Dzesui hee, Oke nii meeke hiirenita oke kaipoma qusubaite qaaqa qaararidzo. ");
INSERT INTO ghs_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Qate abi oi sama nome gimutta eetareiqi Dzesuke qasa hiireta, Oonihe naho temu hiibi oi ape oni? ");
INSERT INTO ghs_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Hiiremi Dzesu hiireta, Oo dzoobe. Dzuta abi teei Dzerusaremu qaateqi Dzerikhota tuumare tapata qurahita. Qurahimi guume abi qesai noke saridze buribaroke teeteqi ttoba ma haba nohoke karabete noke qaate tuumami noi baataquho isakita oota. ");
INSERT INTO ghs_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Oho isakita oomi dzube abi teei paha ota qurateqi moota. Mooqi te hoobidzaranihe potti biireqi tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ma Reebiho gemuhota teei ota baaqi noke moo oho qesa potti biireqi tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Qate ibo haba Samariaho abi teei haba kharata aabe tuumoqi ota biranate abi qettanoma moo dzasa mina eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Noi ao qurate bai obama maka nohoke akobete bibi suraiteqi suutota. Suutoqi noke ttoogi nomeho heeta mootoqi dzeima aabe nagata biranate noke tuuhorota. ");
INSERT INTO ghs_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tuuhoro qaami iihai mootomi oma eserike aabe nagaho mai moiteqi hiireta, Isanate nii abi oke tuuhoro qaaqa moomi ttuma isanataama naatemi anai burisi eete baaqanoke oho koko nii moitakoi oiqi hiire tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Hiireqi Dzesu hu nooho mai oke hee, Qate nii nookami abi taparihota apei abi makanomake dzaira eeteta? ");
INSERT INTO ghs_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Hiiremi noi erake hiireta. Abi dzasa eeteta oioni. Hiiremi Dzesu hee, Qateqa niimae tuumaqa oonomake eetorare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Qate nokoi teteta tuumaqi nagapa teeta biranatemi ota atapa tee, dzapa noho Matta, noi Dzesu ma karake kokora eetareimi noho nagata peiteta. ");
INSERT INTO ghs_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Qate Mattaho dzaba, dzapa noho Maria, noi baaqi Dzesu oko toro nohota habese noo qidza nohoke korabete nookota. ");
INSERT INTO ghs_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nookomi Mattai kokora baura noqeke eete oomi nohota kaiponoma naatemi noi baaqi hiireta, Soopara name, dzaba nahoi ana hoobidzaama naatemi ana naqeke kokora samane eetemi niihota isanatorai Mae? ");
INSERT INTO ghs_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Hiiremi Sooparai noke hee, Matta! Matta, nii bukhi ttidzake eeteqi baura samaneke qupadzomorai, oho qanga bamuhe teena erake qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Maria noi paha poma qidza meenoma teeke saridze oorai oke bamu nohota karabetemi isanataqu. Ooiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Qeteqa bodza teeta Dzesui qeba neta pupu hiirota. Hiire qaasuhimi tumakhameto teei noorake noke pobi hiireta, Dzohane sobasoba noi tumakhameto nomeke pupuho tete banaiteta oonita nanai dza eetemi nii oho isakita nana banaitare. ");
INSERT INTO ghs_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Hiiremi noi hee, Dzoobe, nike pupu hiibareiqi eranomaho totohota hiibare, Mai naname, dzapa niihoi subesubenomanita rike ma pobi niihoi nanaho irita biranatare. ");
INSERT INTO ghs_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","4","Qate patta nanahoke saninoke moitare. Ma nanai kahosa abi nanamehoke qaatoraita nii paha kahosa nanahoke qaatare. Oonihe eto nii nanake qaatemi toronaho kabira naataino. ");
INSERT INTO ghs_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","7","Oiqi hiireqi Dzesu noko pobi hiireta, Nikeho dzaira teei qupi qausuta baa naga pouta qooroqa hee, Dzaira name, naho qesa teei haba kharata baaqoriti naho nagata peitemi ana patta apeke noho dzagata mootaqu? Oho quba anai niiho torota dzobadzoba tapariqaho quba qasa hiire. Oke eete pupu hiiremi nikehota apei totoho eraiqi hiibaqu, Eehe, tete siire ooraimi khameto ma nanai gama meeoraita qidzoke qoridze oke nii moitaqu? ");
INSERT INTO ghs_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ana qupadzomami oho totohota bamu hiire isanataquhe nii aoke qoridzeqa dzare noi hiibaquho isakita noke moitakoi. Oi dzaira quba bamuhe noi pouqata qooro tototo hiiremi ooho qubake moitakoi. ");
INSERT INTO ghs_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Oonita ana bamu nike ikobetaqu. Pupu hiire qaamake moitakoi, qiri eete qaaqake saridzakoi ma tuputupu teete qaamake tete geemakoi. ");
INSERT INTO ghs_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Oi apeneke isaki moitorai bahe, pupu hiiroraike moitorai. Ma apenei saridzorai bahe qiri eetorai nokoi saridzorai. Ma apeneho quba tete geemorai bahe tuputupu teetorai nokoho quba geemorai oioni. ");
INSERT INTO ghs_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Qate nikehota khata teeke mai nomeho torota sekanaho quba hiiremi mai isanate dzotata qaanoma noke moitaqu? ");
INSERT INTO ghs_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Eo khatai nee mutuho quba hiiremi besabesa moitaqu? Oi bamu. ");
INSERT INTO ghs_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nike obera abiho isaki oonihe paha khameto nikeme quba qidza moitare gesinanita nike Qusu Mai nikemeho torota Qaheuba Sumasaho quba pupu hiire qaama bamu qaanataquhe moitakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Qate songena teei abi teeho irita oomi noi potutu naate oomi Dzesui songena iihami tuumami abi oi paha noonoma naateta. Noonoma naatemi abi samane oho hasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","16","Oonihe qesai Dzesuke toronaiteqi qusuho mumure teeho quba hiireta. Qate paha qesai noke ekepusa eeteqi hee, Iidzo, noi songenaho abi qiba Beedzeburo (oi qongara pai ma Iibadza) dzapa nohota hiiremi songena atti tuumoraiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nokoi totoho oonomata hiiremi Dzesu ao obera nokohoke gesina naateqi noko pobi hiireta, Abi naga teei qesa hu ma koridza biidzaquko bamu qaaraqu oho qesa nagapa mina teeta abi nokoi qesa ibo eetaquko bamu agoba qaaraquhe ao rubenga naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Oho quba paha Iibadzai sama nomeho goottaeke eetaquko ikanomake eete noho nagapai isanate ooraqu? Oi nike anahoke hee, Noi Beedzeburoho dzapata songenake iihoraiqi hiiremi ana nookorai. ");
INSERT INTO ghs_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Oonihe anai Beedzeburoho dzapata songena hotou biiroraimake apeho dzapata nikemaeho qaru khametoi songenake iihorai? Oho quba nokomae nikeke qanga hiibaridzoni. ");
INSERT INTO ghs_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Oonita anai Ohongaho beedzaema songenake hotou biiremi erake qupadzomare. Oo, meenipamuke Ohongaho beedzae napaho irita qeehibiqi hiibare. ");
INSERT INTO ghs_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Qahura erake qupadzomare, Gume abi bise baisenomaho dzudzu ma sogimoi koo ma tangama ooraquko abi qanga noi attiamake naga tatangaho nakuta oorakoi ma qubadzage noi karabeteqi mai eete oorai oi qidzoke saqosaqonoma naataqu. ");
INSERT INTO ghs_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Oonihe abi mina beedzae minanoma teei baabaquko noi isanate gume abi oke suqobireqi koo ma taanga ma tepure nohoke gama geemaqi quba qidza nohoke ingonaiteqa saqoromi oi gama qidzanate teka nome ma nometa tuumakoi. Oiqi hiireqi Dzesui ingona baura nomehoke hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Noi nokoke hee, Nikehota teei anama ttaiqa baura eetaama naasuhiqa anake ibo eetakoi oi noi anama mee dzurutaama naasuqa dzakidzaki baura eetakoi oonita dzakidzaki oke qaatare. ");
INSERT INTO ghs_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Oonihe ana qogo noo paha teeke hiire nookare. Songena teei abiho irina oori oke hotou biiremi ikata qidza naataqu hiireqi songena oi tora ma ngaata tuumaqi bitta eete qaaramuti burisi eete paha abiho qupa puita biranatareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Hiireqi baa moohimi abiho qupa akobetemi ootahe Ikanomake eete habanake oota? ");
INSERT INTO ghs_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Habanake oomi noi miisi teeteqi songena paha qesa ngiigninomanipamu nokoke ttuttuiteqi nokomae gama ota dzuubata. Oonita abi oi bosata qangama ootati qidzanatetanihe qupa ma oora ma qaara nohoi sepeke oomi ipita nohota paha tete bamenoma attinomanipamu biranatetanita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Qate Dzesui noo oonoma hiiromi garuba oho bisata atapa teei too dzoobireqi hiireta, Paiho khata asita nii baranateta ma amena nohota nii bitotota atapa oio dzapanomani. ");
INSERT INTO ghs_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Hiiremi Dzesui hee, Oi meenihe, apenei Ohongaho noo nookaqi qusubaitorai tupu oio meeke dzapanomani ooiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Oonita abi quba minai eema ma totoqu eete Dzesuke sengibetemi noi noko pobi hiireta, Abi naga obera nike naane obaobaho qirike eetorai. Oonita nike obaoba apeke saridzaqu bahe Dzonai torona saridzetaqaho isaki saridzakoi. ");
INSERT INTO ghs_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Oi Dzonai Ninibe nagapa abiho torota biranateqi qogo noo hiireqi noomae Ohongaho mumure naateta oho qesa Abiho Isaki anai abi naga nikeho mumure naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nookare, agobake atapa mina teei haba kharanipamu, oi ttoka pobi nenata baaqi abi qiba Soromoho noo nookami nokanokanoma naateta. Oonihe anai Soromoho isaki riiteqi nikeho quba noo bagenomanipamu hiiremi nike nookaama naatemi oho quba ipi bodzata atapa mina oi ttota nikehoho bisata biranateqa nikeho qomaqoma minanipamu hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Oho qesa nagapa meusu Ninibe oho abi Dzonaho qogo noo nookaqi te basesa eetaranihe qupa burisi eeteta. Oonita Dzonaho isaki keke bahe anaio nikeho quba noo hiiremi nookaama naatemi oho quba ipi bodzata Ninibe abi nokoi noo qohare nikehota isere mootoqi nikeke iiga minanipamu hiibakoi. Oonita nookare. ");
INSERT INTO ghs_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Dzesui hee, Abi dzongike qeereqi teqaha qapuma saaroraidzara ma te qohare pesuta mootoraidzaranihe oke qohare heeta mootomi abi minarai isanate mooraridzoho isaki naatorai. ");
INSERT INTO ghs_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Oonita nese niihoi ikata taatorai oi dzongiho qesa naate oora ma qaara niihoke dzeimorai. Oi nese niihoi kokora baura qidzake asatoraquko niiho oora ma qaara gama dzaodzaonoma naatakoi. Oonihe niiho nese oi qoredzaho pobi naataquko oora ma qaara niihoi qupisoobakoi. ");
INSERT INTO ghs_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Oonita eto niiho oora ma qaara qupi soobainoho quba nese niimeke bakena geema qaarare. ");
INSERT INTO ghs_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Oi oora ma qaara gama dzadzanomai keke ooraquko nikehota tete bagenoma naate qaarakoi. Oi baruna heenai koina minanomaho isakita tete baibudzakoi. ");
INSERT INTO ghs_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Oonita Dzesui noo oonoma hiiromi Pariseo teei baaqi Dzesui noma nopo ttaike noho nagata patta muunareiqi hiireta. Hiiremi Dzesui ao peiteqi pattaho qohareta habeseta. ");
INSERT INTO ghs_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Qate Pariseo moohimi noi boto akobetaamake ao patta muunare eetemi noi oho iiha ma dzoobidza eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Eetemi Dzesu Sooparai noke pobi hiireta, Maqa Pariseo ma nikei ttuba ma qapuho sasaqake akobetorai qate nakuta guume ma rasaki samanei hee baaqorai. ");
INSERT INTO ghs_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ohongai sasake korabetetai nakuma gama korabetetanita abi naga nike ikaqi hiireqi ota obera naatorai? ");
INSERT INTO ghs_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nakui saasari ooraquko nike qoredza bahe baruna heenaho teteke gesina naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Oi Pariseo nike meeke ttumani mae pattani mae quba naane ma naaneke saridzorai oohota saninoqake oho kokoqake aima Ohongaho tteki quba mootorai. Oho qanga bamu, oke eetaridzonihe nike oonomake eeteqi dzasa tetenipamuke ruume naateqi sasaqake sooroqi oberama abike qahitotorai. Oke eetoraiho qubake nike quba bamenoma saridzakoi! ");
INSERT INTO ghs_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Oi Pariseo, nike sobadzata tuumami abi nikeho dzapa hiire qusubaitemi nike totoho oonoma nooka quba dza eetorai ma nike sinabidza guhuta peiteqa oho habehabe qidza bosabosa ota habesa quba dza minake eetorai Idze, nike oho ipike quba bamenoma saridzakoi! ");
INSERT INTO ghs_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Pariseo nike Qetaqeta abima gama ikoikonomani. Nikeho naku oi quba apeho isaki? Abi teei ruume naate sepeke qura tuuho kebake qooro qahitotorai nike oho isaki oonita oi quba bamenomanipamu! ");
INSERT INTO ghs_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Oke Dzesu hiiremi hu nooho maimane teei hee, Banaita naname, nii noo oke hiireqi paha nanake kootore. ");
INSERT INTO ghs_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Hiiremi noi hee, Oionita nike paha oho mokosu koko moohiqake eete qeemorare. Oi teeho bahe nike sepeke abiho irita bame samane mooto peitemi areare hiiremi nike teqaha oke boto nikemema hesate adzahahaitoraidzara. Bamu. ");
INSERT INTO ghs_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Uimane neimane nikehoi too abike teete baaoraimi nikemae baura oho koko ipibireqi oho mumure biirorai. ");
INSERT INTO ghs_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Oi uimane neimane nikehoi too abike teete qaata oke nike qaupuiteqi eranomake eete abike sesero eeteqi isere nikeme ao ota mootorai. ");
INSERT INTO ghs_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Oi Ohongaho noo nokanokanoma teei eraiqi hiireta, Anai abi naga nokoho torota too abi ma qaru abi samaneke dzoobiremi tuumami nokoke sesero eete teetemi baatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Teetemi baate qaamake ttokaho husi ma pai moototaho bodza neta nokoho dzuu oke taanga abi oho qereta gama suraitemi bamenoma naatakoi! ");
INSERT INTO ghs_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Apeneho dzuuhoke qeeteta bahe bosata Abereho dzuu ma tuuma qaaramuti Dzakharia noke haqa ma Biiriho takurata teeteta abi oonomaho dzuu samane oonita nokoho dzuu gama abi naga nikeho irita peitakoi. ");
INSERT INTO ghs_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Oonita hu nooho maimane ikaqi nikemae nokanokaho tete ota dzuubaama naateqi qesai ota dzuubare hiiroraike nike naane quba tete siireqi teteho gehigehi dzukurorai? Idze nikeho bame minanipamu biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Noo oke Dzesu hiiremi Pariseo ma Qetaqeta abi nokoi noke anginaitareiqi qasa noo bamenoma samane noho torota mootota. ");
INSERT INTO ghs_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Oi nokoi hee, Noi noo teeke oberama hiimake oionita noke aima qomaqoma hiibakoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Oonita quba oonomai biranatemi abi huba haba biireqi qesa qahiqahi eetemi Dzesui burisi eete tumakhameto nomeke bosa pobi hiireta, Maqa, Pariseoho ikoiko oi maa uubaqi qesa dzoobaquho isaki oonita eto oho patta naataino. ");
INSERT INTO ghs_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nokao, quba dzukuma ma dzahedzahena oi gama paana naate soubidzakoi. ");
INSERT INTO ghs_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Oonita qupita noo teeqake hiiremi oi aoke ete dzadzata abi samaneho tomata dzuubakoi. Dzahe noo teeke hiiremi eehe, ao abi minaraho noo naatakoi oke qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Dzesui hee, Dzairamane name, qesai nikeke teetemi baatakoiqi hiiremi etoqa oho attike eetaino. Oi nokoi nike teetemi baatemi oho heeta nokoi paha quba apeke eetaqu, oi bamu. ");
INSERT INTO ghs_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Qate teeqaho attike eetaridzoni. Apeho atti bahe nike baatemi iibadza nagata dzoobidzaqu ma oho neta nikeke ingonaitaqu oho beedzae oi Ohongaho torota ooraita meeke noqaho qubake ququimare oke ana nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Oonihe qupadzomare, Nee kipadza boto teena oke abi qesai tu Toeama ttuma eetoraihe, Ohongai teqaha noko teeke ruume naasuidzarani, bamu. ");
INSERT INTO ghs_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Oonita nokoho ttuma gattiqanihe Ohongaho pengata nikemaeho ttuma minanipamu. Qiba gee nikehoho dzare oke noi gama aimaqi aimaqi nikeho pati qohatakoita noho torota inobetare. ");
INSERT INTO ghs_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Oi keke bahe apenei anake raraku biireqi abihota paanaitorai nokoke Abiho Isaki anai isanate Ohongaho angero nokoho pengata raraku biidzakoi. ");
INSERT INTO ghs_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Qate teei anake bai hiiremi noke anai paha angeroho pengata bai hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Qate qesai Abiho Isaki anake ruume naateqi obera hiibaqu kahosa nokohoke dzaamutaquho tete nome gattiqa ooraihe, apenei Qaheuba Sumasaho isaki moo pobiteqa qanganiqi hiibaqu nokoho kahosake dzaamutaquho tete ooraidzara bamu. ");
INSERT INTO ghs_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Oonita, tumakhameto name, ibo abi oonomai nike qomaqoma hiibareiqi sinabidza guhuta dzeimaqu mae ttoka sooparaho neseta dzeimaqu mae bise ma baise ape ma apeho pengata dzeimaqu bodza ota etoqa nike iiha ma dzoobidza eeteqa hee, Ikaqi hiibaqu mae noo ipi ikanoma hiibaqu ooiqi hiibaino. ");
INSERT INTO ghs_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Oi bodza ooqata keke Qaheuba Sumasa noomae oho noo nike banaitemi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Dzesui oke eete noo hiiromi abi tupuhota teei hee, Banaita name, nii isanate nane gotta nahoke pobi hiiremi quba tongo nanai aimaridzo oke noi eto nome quba qahitotainohe ao batabidzare. ");
INSERT INTO ghs_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Hiiremi Dzesui kaitomaqi hee, Oonita apei hiiremi anai quba samane nikehoho batabidza abi naataqu. ");
INSERT INTO ghs_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nookao, abi teeho quba samane huba haba biiremi oho quba noho oora ma qaarai qidzanataqu mae? Oi Bamuta nike eto peetta ma qeraqeraho angita dzuubainohe atti ququimare. ");
INSERT INTO ghs_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Hiireqi Dzesui noo oke gotta ma paita mootoqi erake hiireta. Abi quba tongo minanoma teeho dzoota mee gairai biranateta. ");
INSERT INTO ghs_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Gairai biranaatemi oho mai qupa nometa hiireta, Ae anai mee minanipamu oke ikata paramu mootoraqu? Bamuta erake eetakoi. ");
INSERT INTO ghs_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Anai isanate goottara oho paramu naga gamitti nameke eseqotoqa paha mimiqapa gooto mee ma gottara samane name oho nakuta mootomi bageke eete qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Oke eeteqanoke naamaeke pobi hiireqi hee, Qupa khata name dzoobe! Poiqa moomi nakaho paramu tii samaneho isaki mootomi ooraita qidzanatorare hiireqi nakamae patta ma oba saqubema muunaqa qakima naki eetorare. ");
INSERT INTO ghs_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Oke hiibakoiqi abi oi hiiretahe, bodza ooqata Ohongai erake hiireta, Potutu nii! Qupi eraho nakuta nii baatake boobi. Oonita quba tongo minanipamu niihoke apei mai eetaqu? Oiqi Ohongai hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Oho quba nookare, abi oonoma qoredza eeteqi Ohongaho pengata quba samane nomeqaho quba qaanataqu noi oho ipike quba bamenoma saridzakoita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Oke hiireqi Dzesu burisi eete tumakhameto nome pobi hiireta, Nike noorake nooketa ttokata qaaraquho quba eto pattaho iiha dzoobidzaino ma sama nikehoi ttoba ma sasa apeke dzaabaqu eto oho qupake muunaino. ");
INSERT INTO ghs_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Oi sama nikehoi meeni qate ttoba ma bareio sasa, Pattai dzaetakoini qate qaraqaraio oorakoi. ");
INSERT INTO ghs_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Oi nike neeke moorare. Nokoi dzoo eetaama, iisu ma paramu teeke mootaama oonihe Ohonga noomae noko sogo moitorai. Oonihe Ohongai moomi nee oi quba gattiqa ma sepeni qate noi abi nikeke moomi noho baruna heme biranataridzonita noi abi nikeho pati qohatemi isanatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Erake eete oorai, Abi teei sama nomeho baku geemami oho quba noho oora ma qaara minanataqu mae? ");
INSERT INTO ghs_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tete oonoma ooraamanita khooba apeho qubake nike oho qaseqase samaneke qaupuitaqu? ");
INSERT INTO ghs_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ma sihidzaho tete paha moorare. Noko angi angitaama, asi ootaamanihe noko haba biirorai ma nee ma bau nokohoi gattiqa bamu. Soromoho nee ma bau oi minanipamu ootahe sihidzahoi nohoke riitoraita oho khooba qupadzomami oi sihidzaho pobi keke bahe paha nikeho. ");
INSERT INTO ghs_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Oonita nookare, baa ma bittina sobadzana biranatorai oke Ohongai ttoba ma sasanomaitoraihe oho ttuma mina bamu, ao ihaike qeeremi bamu naatakoi. Oonihe Ohongai nike moomi tobe sumanomanita qaarakoi. Oonita nike ai tataumaqi ikaqi hiireqa hee, Ohongai qidzoke napake ttoba ma barenomaitaquiqi hiibaqu? ");
INSERT INTO ghs_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Oho quba etoqa hee, Napai patta ma oba apeke muunaqu oiqi hiireqi oonomaho qupa ororo eetaino. ");
INSERT INTO ghs_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Abi Ttokaho nena nokoho poma oke eete ooraihe qeepe ma haba nikehoi dzaetorai mae? Oke Ohonga mai ao sauqata tete qupadzomorai. ");
INSERT INTO ghs_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Oonita quba apeho baurake nike eetoraqu bahe Ohongaho baura ooqake eete qaama Ohongai quba qesa samane nikehoke haba habara mooto tuumami isanatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Abi hohoqa name, nike nookare, Ohongai pobi nome nikeke qaanataqu bahe oke gama nike moite soubidzaquho dzake noi eetorai. ");
INSERT INTO ghs_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Oi qusuho iisuta gume abi peitaamani, oho ttuma nahusa eetaamanita nike qusuho ttuma oho sengi qidza tatanga nikeme quba saridzeqa oonomaho ttuma mai eetare. Oi ttokaho quba qesa nikeho torona naatoraita nike oho ttuma quba hiiremi biranatemake oke nike gama abi habanake moitemi nikehota qusuho ttumai meupu naate qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Oi abiho qupa ika neta oorai oio noho ttumaho isaki oonita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Oonita mai teei ata naateqi ao burisi eete nagapa baahumi abi noho beebe eesuqi ttoba dzapire dzongi qeere noho quba ao tete geemami hairiamake dzuubaquho pomake qupadzomaqi tete oke nikemae roibetare. ");
INSERT INTO ghs_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Oi oho mai baaqi moomi baura abi ao noho quba roibete ooma mai noi nokoma dzuubaqa nokoke kokora eeteqa hiiremi noko patta muunaqa qidzanatakoi oke ana meeke nike pobi hiire. Oonita baura abi oonomaho isaki bagenomani. ");
INSERT INTO ghs_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Oi mai noi saubapota baabaquni mae dzuridzarita baabaquni mae bodza apeta baabaqu? Baaqa moohimi baura abi nike roibete beebe ooma nikeho isaki bagenomanipamu oorakoi. ");
INSERT INTO ghs_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Oonihe paha erake qupadzomare. Gume abi teei naga teeke geemareiqa bodza ma teteke noi te paanaitemi nagaho soopara nookoraidzara. Nookaquko noi qesama nokoi ao noho beebe eeteqi noke naga qaanatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Qate Abiho Isaki anai gume abi bamuhe anai baabaquho bodzake nike ruume naatoraita roqoroqo ma sahasahama oorare. ");
INSERT INTO ghs_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Oke hiiremi Peetoroi hee, Qahura noorake nii abi minaraho quba hiireni mae nanaqaho qubake hiire. ");
INSERT INTO ghs_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Hiiremi Sooparai hee, Oonita apeho nokanoka isanatemi noi tuhotuho abi qesake soopara eete qaami patta ma quba samane oi bodza nome ma nometa iso keke biranatoraqu oho tete qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Naga soopara oonomai baura idzoidzoke eete ooma mai baaqa mooraqu abi ooho isaki bagenoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Oi mai oke mooqi ao noke quba tongo nomeho sooparake upubidzakoi oke ana meeke nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","Oonihe naga sooparai qupa nometa hee, Mmhm, Mai qoqotoke baaoraiqi hiireqa ao oba ma patta saqubema muunami qiba noho ruume naatemi noi kokora abi ma paimaneke buribaroke teete ooma mai nohoi bodza oonomata seike baaqi oke mooqa abi oke naga sooparaho isaki qaanate noke abi sepe naatareiqi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Oi keke bahe maiho dza hiireta oke abi noi teqaha ruume naataranihe sepeke noho noo ai siginaitetaho qubake noke paha bitte batte biidzakoi. ");
INSERT INTO ghs_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Abi teei ruume quba oberama eetemi noke isakiqata teete pobitakoi, qate teeho gesina mina oomi noke soopara baura samaneke moitemi noi oho isakita ttuma mina aimakoi, mae noi baura sesero eetaquko noi oho ipike quba bamenomanipamu saridzakoi. Oi teeho bahe noho isaki mina kekeni. ");
INSERT INTO ghs_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nookare, Anai eepa bamenoma teeke qeeba quba baatanita naho qupai hee, Eto bodza sepeke kharanataino. ");
INSERT INTO ghs_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Oi sobasoba bamenoma teei naho irita biranataridzoho qubake ao naho ttidza qosu sahauborai. ");
INSERT INTO ghs_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mae nike qupadzomami anai ttokata gaibami oho quba hasu biranataqu? Oi bamu. Hasu bahe hu ma koridza samane biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Oi naga teeta eseri nooka hiisi eetemi tapari basesa eetakoi. Mae tapari nooka hiisi eetemi eseri bamu. ");
INSERT INTO ghs_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Oke eete oorakoi. Mai ma khatai naho nookami teei ai tataumakoini qate teemui bamu. Oho qesa pai ma khatata nopoho qupa maina paina naatakoi. Motami ma anapidza oho qesa ota batabidzakoi oi oonomaho isaki naatakoi Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Dzesui abi tupu oke dzaga bobotoqi hiireta, Ma nike apata moohimi perettabi peitemi nike hee, Oo quu taatake boobiqi hiirorai. Hiiremi bamu haba naataqu. ");
INSERT INTO ghs_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma paha nike hee, Utai dzaga neta toororaita haba ngorubatakoiqa hiirorai. ");
INSERT INTO ghs_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hiiremi sapara naataama. Oi quba oonoma ttoka ma habata biranatemi oke nike ao sauqata moo qupadzomorai. Oonihe ana nike quba biranataridzoho qamodzamodza hiiremi nike ikoiko apeho quba khooba ruume naatorai? ");
INSERT INTO ghs_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Nikemae ao khooba mooqa hee, Meenipamu ooniqi hiibarorihe bamu. ");
INSERT INTO ghs_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Dzesui hee, Oi paha teei niiho kahosa eete ooqi niike aima ttoka sooparaho torota tuusuhimi nii qupa niimeta hee, Idze! Eto ttoka sooparai naho nookami qanga naatemi anake sutasutaho pobi hiiremi pirittani anake aimaino hiireqi nii ao teteta temuke kebaitareiqi oho baura minake eetororai. Oonita paha Ohongaho neta oonoma eetaridzoni. ");
INSERT INTO ghs_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Oi kahosa niihoi bamenomanipamu oomi noi niike sutasuta tatangata mootomi nii qidzoke ota biranataqu, bamuta ao qupadzomare. Oke hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","3","Oho bodzata Dzesu pobi nookami Garirea abi qesai Dzerusaremuho biirita kiridza qeereqi kabira dzuubetomi Pirato hiiremi qaa abi nokoi abi oke kabirama gama dzubeteta. Noo oke Dzesu nookaqi abi tupu pobi hiireta, Quba bamenoma oi Garirea abi nokoho irina taateta oho qubake nike hee, Idze, noko poi abi kahosa minanomanita ipi oonoma saridzeiqi hiire mae? Oi bamu. Nikemae qupa burisi eetaama naataquko oho qesa gama baate bamu naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Qate Siroamu oma penonoi abinike khooba apeho quba abi 18 nokoho irita taatemi baateta oho quba nike nookami abi nokoho kahosai minanipamu ooqi Dzerusaremu abi ma nikehoke riitorai mae? ");
INSERT INTO ghs_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Oi bamu, nike Ohongaho neta qupa burisi eetaama naataquko oho qesa dzaetakoi, oiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Oho quba Dzesui oke gotta ma paita mootoqi erake hiireta, Abi teei ee muri dzoo nometa dzaarota. Dzaaroqi qupi samaneke baaqi mee nohoho qiri eetemi bamu naate qaata. ");
INSERT INTO ghs_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Qaami noi dzoo sooparake pobi hiireta, Maa, ao tii tapariho isaki anai ee muri eraho mee qiri eete baaorai. Oonihe bamu naate qaimi naane quba ee oi sepeke ttoka mina karabetaqu? Baamu, oonita oke ao geemaridzoni. ");
INSERT INTO ghs_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Hiiremi dzoo sooparai hee, Mai name, nii qaatemi ana isanate paha tii teenaqaho nakuta noho khooba ttoka sakate bibi moitaqu mae? ");
INSERT INTO ghs_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Bibi moite qaama bodza bamu naatemi mee goomaama naataquko oke isanate geema biidzakoi. Qupa napahoho qahura oke hiireqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Dzuma teeta Dzesui Sinabidza guhuta peite abi banaiteqi moomi atapa hemenoma teei oota. ");
INSERT INTO ghs_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","12","Heme nohoi tii bodza 18 naatemi atapa oi ao hohoqa naate oota. Oonita Dzesui noke pobi hiireta, Atapa, heme niihoi ao bamu naatare. ");
INSERT INTO ghs_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Oke hiireqi boto nome noho irita mootomi sama ao pobiratemi noi Ohongaho hasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Oonihe dzumata baura oonomai biranatemi guhu sooparahota obera naatemi noi abi tupu pobi hiireta. Baura bisa napahota oorai oi qupi qesaqesa oonita nike bodza ooqaho nakuta hemenomaho baura eetaqu oi teteni. ");
INSERT INTO ghs_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Hiiremi Dzesu Sooparai oho ipike hee, Ae ikoiko abi nike, dzumata nike burimakau ma ttogi nikeme eka saqoroqi noko oba muunareiqi ota dzeima tuumaamani kaqa! ");
INSERT INTO ghs_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Qate ataparai kabira bahe Abarahamuho dzuu kokonipamu, oonihe Saatai ao tii bodza 18 oho isakita noke suuto qaimi dzumata noho eka saqoromi nikehota obera naate kaqani! ");
INSERT INTO ghs_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Dzesui noo totoho oonomata hiireqi oona bai hiiretaho nenake gama midzahutaiteta. Qate Dzesui baura qidza samane eetotaho qubake garubai gama boto teeteta. ");
INSERT INTO ghs_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","Oonita Dzesui erake hiireta, Ohongaho pobi oi quba apeho isaki ma oke quba apeta mootomi isanataqu? Oi moepaho gottarai quba gattingaqanihe abi teei oke aimaqi dzoo nometa dzaaromi peite eeho qesa naatemi nee gohabaqi ota taate sumudzataquho isaki naatorai. ");
INSERT INTO ghs_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Oke hiireqi paha teena oke Dzesui hee, Ohongaho pobi oke qahura apeta hiiremi pobirataqu? ");
INSERT INTO ghs_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Oi iisiho qesa. Oke atapa teei aima qausoma sarete teenaite mootomi qausoi gama oho quba qura huitakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Oonita Dzesui haba ogamaqi nagapa samaneta peite ota sinabidza hiire hiireke tuuma qaaramuti Dzerusaremu ota biranateta. ");
INSERT INTO ghs_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Oonihe Dzerusaremuta biranataamake oomi teei noho torota qasa noo hiireta, Soopara name, abi samanei sinabidzata sumudzate qidzanataqu, eo oberaqai ota qidzanataqu? ");
INSERT INTO ghs_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Hiiremi noi abi noko pobi hiireta, Bamu, abi samane tete pou takurata dzuuba quba bitta eetakoi oke ana bamu nike ikobetequ. Oho qubake nike hairi eetainohe ao ota dzuubareiqi beedzae eetare. ");
INSERT INTO ghs_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Oi erake eete oorai. Naga oho mai qeemaqi tete siiremake qesa nikei pouta baa tuputupu teete too dzoobireqa hee, Ae, Soopara naname, tete geemo. Hiiremi anai erake hiibakoi, Eehe, nike ika nena oke ana ruumeni. ");
INSERT INTO ghs_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hiiremi nikei eraiqi hiibakoi, Maqoe, nii nanaho otoba patita sinabidza hiiremi nookata ma paha nanai niima napai qesa dzaira eete ttaike patta muunata oke nii qupadzome? ");
INSERT INTO ghs_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hiiremi anai totoho erake eete hiibakoi, Anai abi naga kahosanoma nikeke ruume oonita ao papatare. ");
INSERT INTO ghs_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Oonomake hiiremi nike moomi Abarahamu ma Isaka ma Dzakopo ma too abi ma kara nokoi gama Ohongaho pobita dzuubahima nikemaeke qirutomami sasata ooqa eema ma totoqu eesuqa sama nikeme iiga minanipamuke hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Oi ttoka ma haba samaneho abi ota dzuubakoihe nike bamu. ");
INSERT INTO ghs_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Oonihe abi qesa poiqa dzapa pobinomai ipita pobiama naatakoi ma poiqa qesa dzapa pobiama nokoi ipita oho pobinoma naatakoita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Noo oonomake Dzesui hiimi Pariseo qesai noke atti hubaiteqi hiireta, Maqa, Herote ao nii teetare hiirenita nii haba erake qaate mainata tuumare. ");
INSERT INTO ghs_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Hiiremi noi burisi eete noko pobi hiireta, Oo, nike tuuma haa teeko oke eraiqi pobi hiibare, Nookare, anai songena iihaqu ma abi qidzaitaqu oke poiqa ma iihaike eetoraqutoke iihai temuta teteta tuumakoi. ");
INSERT INTO ghs_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Oi meenipamu poiqi ma iihai ma iihai temuta tuumaqa Dzerusaremuta biranataridzo oi teeho bahe too abi baataquho qopaio Dzerusaremu. ");
INSERT INTO ghs_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Hiireqi noi hee, O Dzerusaremu, Dzerusaremu abi nike nookare. Khokhora paimanei khameto nokomeke ttuttuite hira pesuta mootoraiho isakita ana nike qidzaita quba hiire baoraihe nike oho goottae eete qaru abi nahoke omama teetorai, too abike gama teetemi bamu naatorai. ");
INSERT INTO ghs_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Oonita nike anake teeteqa bamu paha naho mee mooraquhe abi naga nike qopa nikemema gama ngausaho pobi naate qaaqa qaaqa kebanoke hee, Ohongaho Dzaapa baabe, Dzoobe, dzoobe, totoho oonomata hiireqanoke nike bodza ooqata naho mee moorakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","3","Dzuma bodza teeta Pariseoho bosaqobaqoba teei Dzesu noma nopomae ttaike patta muunareiqi noke dzeima nagata peiteta. Peitemi abi oko ma boto tabaranoma teei noho dzagata oomi moota. Oonihe Pariseo nokoi Dzesuke rittabetota. Rittabete oomi Dzesui hu nooho maimane ma Pariseoke asabireqi qasa hiireta, Nike hu noota moohimi abike dzumata qidzaitaquho tete oorai mae bamu? ");
INSERT INTO ghs_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Hiiremi noko too saa eete oomi Dzesu abi oke qidzaite dzoobiremi tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tuumami Dzesui ipibireqi noko qasa hiireta. Maqa, nikehota khatani mae hooni mae haa teei koseta taatemi dzuma qubake nike te hairiamake noke dzeimoraidzarani mae? ");
INSERT INTO ghs_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Hiiremi nokoi noo ipi apeke hiibarota, bamu. ");
INSERT INTO ghs_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Obetemi Dzesu moomi aabe oona oota nokoi ao hairiamake teka qidzake mai eete habeseta. Oho qubake noi nokoho nooke erake hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Hee, Qate teei ataho kiridza ma qonoqono biraiteqi nikeke ota dzeimami nike etoqa ao hairiamake abi mimiho teka mai eetaino. ");
INSERT INTO ghs_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Oi erake eete oorai. Nike teka oke mai eetemi eto naga oho mai baaqi niike pobi hiireqa hee, Maqe, teka nii aima oorai oke abi dzapa pobinoma erake moitareiqa hiiremi nii midzata qeemaqi kharata habesaino. ");
INSERT INTO ghs_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Oho qubake nii noho nagata peiteqa bosa bahe ipiqata habehima mai baaqi hee, Dzaira name, nii isanate dzamonoqake habesare hiiremake isanate nii ota habesemi oona habese ooraqu oi nokohota nee ma baunoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Oi teei sama nome qusubaitemi noke ai quratakoini qate teei sama nome ai quratemi noke qusubaitakoita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Oke hiireqi abi teei Dzesuke naga nometa dzeimata noke Dzesui hee, Tete erake qupadzomare. Nii hoo ma patta teeke abiho quba eetare hiireqi etoqa quruma minanoma, qesa ma dzaira niimeke ota dzeimami noko ipi ma habarake hoo ma patta niiho quba biraitaino. ");
INSERT INTO ghs_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Oonita nii hoo ma patta teeke eetare hiireqi nese qupi ma abi habana ma qosu ma pone ma abi oonomake ota dzeimami muunare. ");
INSERT INTO ghs_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Oi nokoi quba apema niiho kiridza ma qonoqono eetaqu? Baamuta oho ipi ma arike nii abi pobiho tukutuku bodzata saridzakoi. Oonita oonomake eetemi niike agoagonomaniqi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Oke hiire qaatemi oona patta muunota nokohota teei hee, Ape ma apei Ohongaho pobita dzuubaqa ota patta muunaqu nokoio agoagonomani. ");
INSERT INTO ghs_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Hiiremi Dzesui gotta ma pai teeke hiireta, Abi mina teei hoo ma patta mootareiqi bosata abi oona baabarota nokoho dzapa hiireqi pobi dzoobibiremi tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Qate pattake roibete oomi noi qaru khata nome dzoobireqi hee, Patta abanire oonita ao baabare. ");
INSERT INTO ghs_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Oiqi hiiremi tuumami nokoi gama totoho teenata hee, Nii qaatemi nanai bamu qeemaquiqi hiireta. Oi bosabosai hee, Anai dzoo teeke ttuma eete ooraita oke tuuma moorakoi, qaataquho isaki bamu. ");
INSERT INTO ghs_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Qate teei hee, Maa, anai burimakau eseri eserike quba dzeimoraiho dzare 5 oho ttuma eete oorai. Anai nokoho beedzae isaki toronaitaridzonita nii qaatemi ana ota tuumare. ");
INSERT INTO ghs_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Qate temui hee ana ata naate ooraita qeemaquho isakiama naate. ");
INSERT INTO ghs_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Oonoma keke hiiremi qaru khatai burisi eete oho isere gama mai nomeho torota mootota. ");
INSERT INTO ghs_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mootomi abi minahota qanga naatemi noi qaru khata nome pobi hiireta, Hairiamake tuumaqa nagapa sigi ma sasana, tume ma dzagana oorai ota abi habana, nese qupi, pone ma qosu, abi oonoma keke dzeima baabare. Oke hiimi qaru khata qusubaiteqi tuumatati baaqi hee, Oke ao eetenihe naga pui siibaamake oorai. ");
INSERT INTO ghs_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Hiiremi mai hee, Oonita nii tete ma sobadza ma apota tuumaqa tototo hiiremi abi baa naho naga pui siibare. ");
INSERT INTO ghs_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Oonihe qesaho dzapa bosata hiireta nokohota teeqai bamu ttaike oho patta muunaqu, oke ana bamu dzaheitaqu ooiqi mai hiireta. Qogo noo oke Dzesu noko pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Qate abi paha samanenipamu ttutturatemi Dzesui noko dzaga bobotoqi pobi hiireta, ");
INSERT INTO ghs_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Teei anake iihare hiireqa mai ma pai, noma ma nane, sase ma dzaba, ata ma khameto, qesamane oonomata atimami bamu isanataqu, bamu. ");
INSERT INTO ghs_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Oi teei naho tumakhata naatare hiireqi sama nome marangaho pobi hiire qeemami isanatakoihe, tete teei paha ooraidzara. ");
INSERT INTO ghs_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Oke hiireqi Dzesui oho totaqi paha nagata mootoqi hee, Oi nikehota teei baura naga teeke gootare hiireqi bosata habese ttuma nome isaite moomi isanatemi gootakoi. ");
INSERT INTO ghs_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Oi noi etoqa sohoroqa husi ma pai mootoqa naga gotta ipibidzare bitta eeteqi qaatemi abi baaqa hee, Idzii, abirai naga nome sohoroqi gootoriti qaate ooiqi sosoridzo hiibainoho qubake noho ttuma isanataama naatemi noi ikaqi hiireqi sepeke sohobaqu? Oonita maranga hiibi oke abi qupadzomaqi oho tete mai eetare. ");
INSERT INTO ghs_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Hiireqi Dzesui oke paha qaaho maimanehoto mootoqi hiireta, Ma paha Abi qiba teei qaa qogoimaqi baahumi abi qiba temui noma noko qaa eetare hiireqi bosata iiha dzoobireqa hee, Iaqa, noho abi tupu oi tubenti ttauseni qaate nahoi teni ttauseni keke oonita anai noke isanataqu mae bamu? ");
INSERT INTO ghs_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Oke hiiremi noho qupai hee, Isanatakoiqa hiibaquko noi kurebetare qeemakoi. Qate noho qupai hee, Qidzoke isanataquiqi hiibaquko noi ao bosata hasuho maimane dzoobiremi noko kiridza apeke abi qiba temuke moitemi noho qupai kebarataqu oonita eto pureke marangake mai eetainohe bageke eete qupadzohiqa mai eetare. ");
INSERT INTO ghs_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Oonita nikehota apei naho tumakhatanipamu naataqu noi ttokaho tete samane oho dzore keke naateqa anake iiha qaarare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Oke Dzesui paha tomuta mootoqi hiireta. Marangaho tete oi qidza tomuho qesa. Oonihe tomuho meke bamu naatemi oke ikake eetemi noho qaa ma meke paha biranataqu? ");
INSERT INTO ghs_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Oi bamunipamu. Tomuho qaai bamu naatemi susu ma sasa naatemi oke ikake eetaqu? Ooma ttokake bibi moitaquni mae quba naane ma naane eetaqu? Oho tete bamu naatemi koseta biidzakoita nike marangata eto peperataino. Tomanomai nookare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Oonita ttagetti apiapi kahosanoma ma kara nokoi Dzesuho noo nookareiqi baata. ");
INSERT INTO ghs_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Baami Pariseo ma qeteqeta abi oho niqi hiireqi erake hiireta, Ae! Abirai ikake eete kahosa abi dzeimaqi nokoma ttaike patta muunorai? ");
INSERT INTO ghs_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Oke hiiremi Dzesui oho quba qahura erake hiireta, ");
INSERT INTO ghs_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Nikehota abi teeho sipisipi 100 ooraimi nookami oho dzareta teei dzaetemi noi isanate 99 nokoke hoo poka rometa qaateqa tuuma temuho qirike eete saridzakoi. ");
INSERT INTO ghs_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Noi qiri minake eete saridzeqa qere kharupe biire qaki naate burisi eete baabakoi. ");
INSERT INTO ghs_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Baa nagapata biranate qesa ma dzaira nome ttutuiteqa nokoke pobi hiibakoi. Maqa, naho sipisipi erai dzaetemi anai qiri minake eetoriti ao saridze oonita napai oho qaki naatare. Oke eete hiibaridzoni. ");
INSERT INTO ghs_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Qate Ohongaho tuputa abi 99 rike ma pobi oomi teei kahosaho neta ooqa qupa burisi eetemake oho qesa qusuho angeroi ikake eetaqu? Oi nokoi 99 nokohoke nookami isanatoraini qate teena ooqaho quba qaki ma naki minanipamu naatakoita nike naane quba naho nookami qanganataqu? ");
INSERT INTO ghs_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Dzesui hee, Paha oke atapa moninomata hiire. Noho ttuma sarara tenihota teei bamu naatemi noi ikake eetaqu bahe ao hairiamake dzongi qeereqa qiri minake eete naga sarautoqa saridzakoi. ");
INSERT INTO ghs_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Saridzeqonoke qesama dzaira nome gama ttutuite noko pobi hiibakoi, Maqa ttuma sarara naho teei bamu naatori oke ana qiri minake eete poiqanipamu saridze. Oonita napai gama oho qaki naatareiqi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Oonita oho qesa kahosa abi teei Ohongaho neta qupa burisi eetemi angero ma kara nokohota oho qaki minanipamu ooraridzoni oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ma Dzesu paha hee, Abi teeho khameto eseri oota. ");
INSERT INTO ghs_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ooqi khata sabi noi mai nome pobi hiireta, Poro tongo nane ma nakaho naataridzo oke nii ao batabiremi naka mai eetare. Hiiremi mai noi qubadzage dzapa samane batibireqi nopo moite soubireta. ");
INSERT INTO ghs_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Oonita qupi samane naataamake khata sabi ao quba samane nome ttuttuiteqi haba kharata tuumata. Tuumaqi haba ota noi munasa munasaho isakita oota. ");
INSERT INTO ghs_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Noi quba nomeke piripirima eete bamuiteta. Qate haba ota seebe mina biranatemi abi khata noho ttidza horesa eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Horesa eetemi noi abi hoo kitunoma teeho torota qasa hiiremi noi noke hoo kokora eetareiqi dzoobireta. ");
INSERT INTO ghs_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Dzoobiremi tuumaqi huhu ma sasa noko hoo moiteta oohota noi teeke nome quba muunare hiiremi oho soopara nokoi qaanateta. ");
INSERT INTO ghs_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Qaanatemi noho ttidza qosu sahaubami noi hee, Iidzi. Mai nahoho kokora abi samane nokoho patta meupui ooraimi ana ikaqi hiireqi erata seebe meeorai? ");
INSERT INTO ghs_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ana isanate qoridzeqa tuuma mai nameho torota biranate noke eraiqi hiibakoi, Mai name, anai Ohonga ma nipeho pengata kahosa bamenoma teeke eete oorai. ");
INSERT INTO ghs_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Oho quba anake khataniqi hiibaquho isakiama naate ooraihe nii nookami ana isanate niiho kokora eeteqa qeepe ma haba gattiqa saridzaqu mae? Oke hiibakoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Hiireqi noi qoridze tuuma qaarumuti mai nomeho dzagata biranateta. Oonihe noi sererahuke baaqomi mai ao noke moohimi baruna nohoi heme eetemi noi torouma tuumaqi khatake dzoge biire aimaqi kanabeta minake eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Eetemi khatai hee, O mai name, anai Ohonga ma nipeho pengata kahosa bamenoma eete ooraiho qubake bamu anake khataniqi hiiremi isanataqu. ");
INSERT INTO ghs_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Oke hiiretahe, mai burisi eete kokora abi pobi hiireta, Nii hairiamake tuuma ttoba ma sasa qidza bagenoma aima baa khata sabike dzapireqa oke sasa dzaaroqa boto nohota ringi dzoobireqa noke khataho isakinomaitare. ");
INSERT INTO ghs_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ma burimakau khata sapurunoma oke aima dzubeteqa hoo ma patta eetemi qaki ma naki napahota biranatare. ");
INSERT INTO ghs_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Oi teeho quba bahe khata sabi nahoi bamu naateqi baataho isakita qaariti poike paha eehaha naasubi. Oiqi hiiremi nokohota qaki ma nakinoma naateta ooqi Dzesui hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Oonihe Pariseo basesa eetotaho qubake Dzesui ipibireqi hee, Oonihe eka bosa khatai dzoota baura eetomi khata sabi baata. Oho qubake nanei nagapa dzamoiteqi nookami gitta ma kuiho husu biranateta. ");
INSERT INTO ghs_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Oho husu biranatemi noi kokora abi teeke oho khooba qasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hiiremi noi hee, Maa, noma gotta niihoi baami mai nipehoi noke moohimi baataamanihe eehahake oorai. Oonita mai hiiremi hoo khata sapurunoma oke dzuubetemi noho quba qaki ma naki era biranatorai. ");
INSERT INTO ghs_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Oonihe nane noo oke nookami ttidza noho qanga naatemi noi nagata peitaama naatemi mai noke ttapuitareiqi baata. ");
INSERT INTO ghs_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Oonihe nane maike hee, Nii nookare. Tii samanenipamuke ana niiho baura eete baaorai. Oonita ana niiho noo tee ma teeke basesa eetaamanihe nii meme khata gattingaqa teeke ana moitemi dzairamane namema nanai oho qaki ma naki naatarota oke ana te mooraidzarani. ");
INSERT INTO ghs_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Qate khata sabi niihoi quruma ma quba nii noke moiteta oke noi gama paimaneho neta piripirike eete bamuiteta. Bamuite qaariti baahumi nii ikake eeteqi noho quba hoo sapurunoma oke dzubetemi eranomai biranate? ");
INSERT INTO ghs_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Hiiremi mai hee, Khata qidza name, niima nakamae qupi ma sau samaneke ttaike qaabi, naho quba samane oi niihoi keke. ");
INSERT INTO ghs_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Oonita qupadzomare, noma gotta niihoi baataho neta eehaha naate baabe. Taata naatetake naka paha saridze ooraita poiqa oho qaki ma naki bodzai napamaeho irita oorai. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Bodza teeta Dzesui tumakhameto nome gotta ma pai erake hiireta. Abi quruma minanoma teeho quruma sooparai oberama eetemi abi qesai mai nohoho torota isere hiireqi hee, Niiho quruma ma quba rasakiitoraiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hiiremi Mai noi abi oho kira hiiremi baami hee, Abi niiho isere ikanoma hiiremi ana nookorai? Oonita nii quruma soopara eete qaabi oi poike bamu naate. Oho quba isere niime ttari eete aima baa ana moitare. ");
INSERT INTO ghs_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Oke hiiremi noi qupa muunaqi hee, Ae, mai ao naho baura qaanatemi anai baura apeke eetaqu? Ttoka baurake ana bitta eetakoi qate pupu ma nenesake hiiroraquho midzake ana eetorai. ");
INSERT INTO ghs_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Oi oonita anai abi qesaho nagata peitemi nokoi naho kokora eetorareimi ana erake eetakoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Hiireqi apeneho oma kahosa maiho torona oota quruma soopara noi ao nokoho kira hiiremi baata. Baami bosobosake noi hee, Maqa, niiho kahosa ikabete maiho torota oorai? ");
INSERT INTO ghs_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Hiimi noi hee, Oriba bibi ttaramu mimi 20 oqaho isaki oorai. Hiiremi noi hee, Oionihe nii hairiamake qohareta habese gee niimeta dzare oke rasakiiteqa oho habarake ttaramu tteni oke hiire qeetare. Hiiremi qeeteta. ");
INSERT INTO ghs_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Qeetemi abi oho samanake quruma soopara noi hee, Qate niiho kahosa? Hiimi noi hee, Oo, naho kahosaio uitti basiketti uani ttauseni ooniqi hiireta. Hiimi noi hee, Nii paha hairiamake oke rasakiiteqa oho habarake dzare qeth hattatti (800) hiire qeetare. Hiiremi noi qeeteta. ");
INSERT INTO ghs_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Qeetemi quruma sooparai isere oke gama maiho torota mootomi mai noi noho oberake moo hasa hiireta. Oi teeho bahe pisinisi abi qesaho qibaio bitta ma kakanomani. Nokoho isaki oonomai abi Ohonga ai tataumorai bitta ma kaka nokohoho isakike riitorai. ");
INSERT INTO ghs_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Hiireqi Dzesui tumakhameto nomeke hee, Oonita nike dza eetemi anai nikeke hee, Isanate pisinisiho obera oonomake nike qaupuitemi qangahasi teei biranatemi ttoka abi nokoi nike naga nokometa dzeima kokora eetorareiqa hiiremi isanataqu mae? ");
INSERT INTO ghs_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Oi bamu, oonihe baura gattiqa teeke abiho botota mootomi bageke eete kokora eetaquko abi oonomai paha baura minata isanatakoi. Qate abi teeho botota baura gattiqa teeke mootomi ota taataquko noi oho qesa baura minata taataridzoni. ");
INSERT INTO ghs_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Oonita nike ttokaho pisinisi ma apota ao taate ooraquko apei adzahaha naate qusuho quba samaneke nikeho botota mootaqu? Oi bamu. ");
INSERT INTO ghs_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Oho qesa nii abi mainaho quruma bageke eete soopara eetaama naataquko qidzoke nii isaki niimaehoke saridzaqu. ");
INSERT INTO ghs_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Oi erake eete oorai. Kokora abi teei maimane eseriho too qusubaitaqu oho isaki ooraama. Noi teenaqaho dzake eete noho too qusubaitakoi, qate teemuho goottaeke eete bamu noho too qusubaitaqu. Oonita nike apeho kirake qusubaitaqu, Ohongahoni mae moniho? Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Hiiremi Pariseo ma karaho quruma khooba paana naatemi nokoi noho ngiingi ma baaba eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Eetemi Dzesui noko pobi hiireta, Nike abiho neta sama qusuba baura eeteqi isaki nikeme nookami bagenomanihe, Ohongai nikeho qupa moo soubireqi nookami oi quba peranomani. ");
INSERT INTO ghs_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Nooka! Hu noo ma too abi nokoi Dzohane sobasoba maikhata ma gama qamodzamodza hiire qaimi poiqa anai sinabidza mee hiire nookami abi minanipamu qeemaqi pui siirorai. ");
INSERT INTO ghs_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Oonihe nike oho quba nookami hu nooi bamu too pasere eete nikeke gaamaqu? Idze! Ttoka ma haba bamu naatakoihe hu nooho bagohota teeqai baamu bamu naataqu. ");
INSERT INTO ghs_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Dzesui hee, oonita teei ata usaqe naatareiqa bosabosake ai siginaitaqu noi pasenaho tete geemakoi. Oi abi noi oke eesuhimi ata bosabosake qesai nookami pasenaho pobi naatemi abi qidza apei noke naataqu? ");
INSERT INTO ghs_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Dzesu paha erake hiireta, Abi ttuma minanoma teei qupi ma sau samaneke ttoba ma sasa qidza dzaaroqi qaki ma nakiho isakita qaata. ");
INSERT INTO ghs_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Qaami bodza teeta qesai abi habana makanoma teeke noho pouqata nenesa hiibare aima baa mootota, dzapa noho Dzasaro. ");
INSERT INTO ghs_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Noi teeho quba hiibarainihe huhu ma saaru qoharena taatota ooqake muunare hiiretanihe bamu. Haai baaqi ao noke riiteta ma maka samane nohoke bisiteqi eeteimata. ");
INSERT INTO ghs_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Oke noi bitta eete qaaramuti baatemi angeroi noke dzeima Abarahamu ma karaho nagapa qidzata mootota. Obetemi ipita abi ttumanomai paha baatemi qurabireta. ");
INSERT INTO ghs_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Qurabiremi noi iibadza nagata ooqi nese dzoobire moohimi Dzasaroi sererahuke Abarahamuho nagapa qidzata oota. ");
INSERT INTO ghs_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Oomi noi kira hiireqi hiireta, Abarahamu eebobo name, eepa gabi erai ao anake dzooromi nii isanate naho dzasa eeteqa Dzasaroke dzoobiremi noi boto khata nome obata upubireqa baa oke naho eteeteta suraitemi kebaratare! ");
INSERT INTO ghs_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Hiiremi Abarahamui bai hiireta, Eema khata name nookare. Dzasaroi oora ma qaara nometa qangahasi minata qaatati poike qidza ma riketa oorai. Qate nii aari ma moosuta qaariti poike heme niimeta ooraita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Oi keke bahe nii ma nanaho bisata tupidza minai ooraimi nipe qesaho torota qeemaquho tete ooraidzara. ");
INSERT INTO ghs_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Hiimi noi hee, Eebobo name, oke nii ao hiirenita oho habarake nii isanate noo teeke mai nahoho nagata dzoobidzaqu mae? ");
INSERT INTO ghs_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Oi teeho bahe naho qesamane boto teena ota ooraimi nii qaru dzoobiremi nokoi eraqata eto baabainoho qamuni hiibare. ");
INSERT INTO ghs_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Hiiremi Abarahamu erake hiireta, Eehe, Mose ma too abi minaraho isere nokoho torota ooraita nokoi nookareiqa nokoho nooke nookare. ");
INSERT INTO ghs_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Hiiremi noi hee, Abarahamu, eebobo name oi bamu. Teei baata neta qoridzeqa nokoho torota biranatemi nokoi noho noo qusubaiteqa ao qupa burisi eetakoi. ");
INSERT INTO ghs_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Oke hiiremi Abarahamui hee, Nokoi Mose ma too abi minaraho noo nookaama naatoraita abi teei baata neta qoridzemi noko oho qesa noho noo arabidzakoi. Oiqi hiiretake Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Dzesui Tumakhameto nome erake pobi hiireta, Angi ma kakati samane oorai oorakoi, tete oke eete oorai. Oonihe apei angi oonoma mootorai noho irita quba bamenomanipamu taatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Noi kopuna erana qesake sesero eetaamake ootata abi noke bosata bikomu teeke paruta suutoqi besata biiremi bamu naatapuko oi noho quba paha gattiqa isanatarota. ");
INSERT INTO ghs_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Oho qubake sama nikehoi sesero baura oonomaho hutingi naatorare. Qate niiho qesa teei niike sesero eetaquko noke qamuni hiibare. Hiiremi qupa burisi eetaquko kahosa oke nii qaatare. ");
INSERT INTO ghs_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Oi qupi teena bahe qupi samaneke niike sesero eetemi qupanomaitemi qupa burisi eetemi kahosa nohoke eetoqa qaanatainohe gaubidza keke eetorare. Oiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Qate tumakhametoi qaru abi naatareiqi noho torota baaqi hiireta, Soopara naname, nii hiiremi nanaho ai tatauma ao gaira naatare. ");
INSERT INTO ghs_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Oke hiiremi Dzesui hee, Abiqahe, nike minanataquhoke hiireni. Oonihe nikeho ai tatauma oi moepa benara gamisimisi teeho isaki meenipamuke ooraquko nike ee tatanga oke hee, Tukubake eeteqa besata taatare. Oke hiimake nome ango meenoma naataridzoni. ");
INSERT INTO ghs_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Dzesui hee, Oonita tete erake qupadzomare. Abi teeho kokora abi dzoo eetaquni mae hoo soopara eetaqu oke eete ooma sure mootomi noi baura oke qaate nagapa baahuma noke mai bamu hee, Oo nii habese qidzanate dzapa pobinoma naatareiqa hiibaqu. ");
INSERT INTO ghs_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bamu, noi erake kokora abike pobi hiibakoi, Aoke nii patta khautoqa qohareta mootoqa anake tuuhoro ooma anai patta ma oba oke muuna isanatemake niimae ipita muunakoi. ");
INSERT INTO ghs_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Oke hiireqi noi bamu kokora abi nomeho hasake hiibaqu. Oi teeho bahe kokora abi noi noo qusuba baura keke eetorai. Oke nike moomi poma oke eete oorai. ");
INSERT INTO ghs_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Oho qesa nikei naho noo gama qusubaite soubireqa bamu oho quba dzapa pobinoma naataqu. Oke soubireqa erake nike hiibaridzoni. Kokora abi nanai niiho noo qusubaitenihe oberama eete. Oke hiireqa bamu maikhataho totohota hiibaqu. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Qate Dzesui tumakhametoma noko Dzerusaremuho teteta tuumoqi Garirea ma Samaria habaho tukurata tuumota. ");
INSERT INTO ghs_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tuumoqi noko nagapa gattiqa teeta biranahimi abi pottomunoma tteni nokoi sererahuke qoorota. ");
INSERT INTO ghs_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Qooro ooqi too dzoobireqi hiireta, Dzesu abi mina naname, nii nanaho quba dzasa eetare. ");
INSERT INTO ghs_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Hiiremi Dzesu nese dzoobire mooqi nokoke hee, Oionita nike ao tuumaqa sama nikeme dzube abi banaitemi ikaqi hiibaqu? Hiiremi noko tuumata. Tuumaqi moohimi sasa nokohoi sasari naateta. ");
INSERT INTO ghs_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sasari naasuhimi teei mooqi ao burisi eete hasama gegema hiireqi hee, Ohonga Dzoobe mina. ");
INSERT INTO ghs_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hiireqi noi Dzesuho oko torota taateqi noho subesube hiireta. Oonihe noi Dzuta abi bahe Samaria abi oni. ");
INSERT INTO ghs_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Oho quba Dzesu eraiqi hiireta, Nike tteniho isaki ooqi gama qidzanate. Oonita Samaria abi nii teenai era baabeni, qate Dzuta abi naini nokoi kaqani? ");
INSERT INTO ghs_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nokoi oho ruume bamuhe te burisi eete baa Ohongaho hasa hiidzara! Iidze, haba mainaho abi teena nii oo eete. ");
INSERT INTO ghs_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Oke hiireqi noi abi oke hee, Oioni. Nii ai tataumami niiho sama qidzanate oonita keba ma dzapata qoridze tuumare. Oke hiiremi tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Qupi teeta Pariseo nokoi tototo hiireqi Dzesu qasa hiireta, Bodza apeta Ohongaho pobi meenipamuke biranataqu? Hiiremi noi hee, Mmhm, Ohongaho pobi oke nesema mooraquho isaki bamu. ");
INSERT INTO ghs_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Oi qesai hee, Oi erani, eo oioniqi hiibakoihe bamu. Ohongaho pobi oio ao nikeho bisata ooraita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Hiireqi noi ipita paha tumakhameto nome oho totaqi pobi hiireta. Ipita Abiho Isaki anake nesema mooraquho tete bamu naatemi nike anake paha qupi teeke mooraquho dza minanipamuke eetakoihe bamu. ");
INSERT INTO ghs_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bodza ota abi qesai nike ikobeteqi hee, Noio erani, eo noi ota ooraiqa hiiremi eto oho totoho qusubaiteqi tee ma teeta sepeke tuumaino. ");
INSERT INTO ghs_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Oi bodza ota anaho tete erake eete oorakoi. Baibai ma noo dzobidzobi oke abi teena bahe samane haba totaqi ma totaqita moo nookaridzoni. ");
INSERT INTO ghs_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Oonihe bosata ana heme samane saridzemi abi naga khepidzenomai nahoke nookami meeamaho isaki naatemake kebanoke tete ipina hiibi oi biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Bodza ota tete ape bahe Noai agobake qaataho tomidzata naho tete dzukudzukuta ooqa biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Oi abinaga nokoi sepesapeke patta ma oba muuna qesa naate qaaqi Noai hiire qaatake noko nookaama naate qaami noi suheqata sisimata peitemi obai sooroqi abike nukuromi minarai baatetaho teteke qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","29","Oho qesa Rotti qaataho isakita biranatakoi. Agobake abi Sotomuna qaata nokoi oba ma patta muuna qaaqi dzoo eete qaata, naga gooto qaata. Qate Rottike angeroi dzoobiremi Sotomu qaate papateta bodzaqata oma eepanomai qusuta perebaqi nagapa oho abi gama pupubiremi baatetaho teteke qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Oi Abiho Isaki Anai ipita oho qesa dzukudzukuta baura eete qaamake naho khooba paana naatakoi oke qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Bodza ooqata tete erake eete oorakoi. Teei sama qidzanatareiqi naga totaqita peitemi ao uuba ma sakaba biiranatakoi. Biranahimi noi etoqa quba qesa nome khakhaumareiqi naga totaqita qeemainohe ao atti ttumare. Oho qesa teei dzoo eetomi quba oi biranahimi eto noi quba samane nomeho iiha dzoobidzainohe ao atti tuumare. ");
INSERT INTO ghs_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Rottiho atai hairi eete baatetake qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Oi teei qaraqaraho isaki nome ingonaitareiqa noi ango bamu naatakoi. Qate teei qaraqaraho isaki pekha eeteqa noomae qidzanatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","35","Oi abi eseri dzoo ma baura eetoma teeke ao hira moitemi tuumakoihe teemu sapo teeteqa baatakoi. Qate eseri katata meeqoma teeke tukutomi ao tukumakoihe teemuho nese sidzobetemi ao baataho pobi naatakoi. Tete oonomai biranatakoi oke ana bamu niikeke dzaheitaqu. ");
INSERT INTO ghs_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(Oi bamu) ");
INSERT INTO ghs_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Hiiremi tumakhametoi hee, Soopara naname, Ikata qesa tuumakoiqi nii hiire? Hiiremi Dzesui hee, Oho teka ooraihe, erake qupadzomare, kheekhei poupanoma bahe kebaqake muunoraita eto nikemae oho patta naataino oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Oonita abi eto peperatainohe qupi ma sau samaneke pupu baura eetoraridzohoke qupadzomaqi Dzesui qahura noo erake hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Noi hee, Rooho maripa mai teei nagapa teeta baura nome eeteqi noi te abike ququima qaarara oho qesa Ohongake ququima qaarara. ");
INSERT INTO ghs_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Qate nagapa oho nena tarumi pai noho qohareta peiteqi hiireta, ");
INSERT INTO ghs_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Abi teei naho ibo eetemi nii anake hoobidzare. Oke keke hiire qaami bodza kharanatemi tototo hiiremi noi qupa nometa eraiqi hiireta, Idze, anai Ohonga ma abi iso keke basesa eetorainoma. ");
INSERT INTO ghs_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Oonihe tarumi erai tototo samaneke hiiroraimi anata sesero ma dzakidzakiho isaki naataino hiireqi ana isanate noke hoobireqa noho bame qogoimakoi. ");
INSERT INTO ghs_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Oke hiireqi Dzesu Sooparai hee, Moorare, maripa abi qanga basesanomai hiire oke nike etoqa nookaama naataino. ");
INSERT INTO ghs_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Oi Ohongai oho basesa bamuhe nike qupadzomami abi noho ttarina biranate oorai nokoi ai tataumaqi qupiba ma etebake noho torota dzauri hiire qaama noi bamu isanate nokoho bame qogoimaqu? ");
INSERT INTO ghs_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Bamu, noi ao hairiamake nokoho baura eetakoi. Oonihe teena eraqaho qupake ana muune. Abiho Isaki anai ttokata biranataqu bodzata abiho ai tataumai isanataquni mae bamu? Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Qate abi qesai qesaho ngiingi ma baaba eeteqi sama nokomeho nookami rike ma pobiho isaki naatemi isanateta. Oho quba Dzesui gotta ma pai erake hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Abi eseri nopoi pupu hiibareiqi Ohongaho biirita peiteta. Temui Pariseo oni qate temui ttagetti apiapi. ");
INSERT INTO ghs_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Oonita Pariseo noi pobinoke qooro qusuke mooqi sama qusubaiteqi eraho totohota hiireta, O Ohonga, abi qesai qosunoma, koiri kairinoma, sama sesenoma, ttagetti apiapi erana ooraiqaho isaki kekeni. ");
INSERT INTO ghs_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Qate anai dzuma teenaho nakuta qupi eserike hutingi naatorai ma anai quba naane ma naaneke saridzorai ohota qetta samaneke niiho quba qaheburorai oonita anaio qesaho isaki oonidzara, dzoobe. ");
INSERT INTO ghs_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Oonomake hiiretahe ttagetti apiapi noi sigiqata ooqi subateqi boto sama teeteqi eraiqa hiireta. O Ohonga nii abi qanga anaho quba dzasa eetare. ");
INSERT INTO ghs_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Totoho oonomata hiiremi Ohongai noke rike ma pobiho ttarita ipibiretahe temu bamu, oke ana bamu nike ikobetaqu. Oi teei sama nome qusubaitemi Ohongai noke ai quratakoi qate apei sama nome ai qurataqu noke ai qusubaitakoi oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Qate abi ma paimane qesai khameto bittinake Dzesu hesate agoago eeta qubake nokoke aima baata. Baahumi tumakhametoi qamuni hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Hiiremi Dzesui nookaqi hiireta, Oe, Khametoi Ohongaho dzubinanipamu oonita nike etoqa nokoke tete siibainohe dzeima baabare. ");
INSERT INTO ghs_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Oi khameto gamitti Ohongaho dzaodzao eetoraiho isakita abi eetaama naataquko bamu noho pobita dzuubaqu, bamu! Oke ana bamu nikeke dzaheitaqu. ");
INSERT INTO ghs_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Oke hiiremi abi soopara teei baaqi noke qasa eeteta. Banaita qidza name, baura qidza apeke ana eeteqanoke oho quba qaraqara tatanga saridzaqu? ");
INSERT INTO ghs_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Hiiremi Dzesui noke toronaiteqi hee, Ohonga teenai qidza oke nii qupadzomaqi anake hee, Qidzaniqi hiireo? ");
INSERT INTO ghs_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Oonita hu nooi hee, Nii eto apuata eetaino, nii eto teete baataino, nii eto guume maina paina eetaino, nii eto tooi pokhi eetaino, Nii mai ma pai niime qusubaitare oiqi hiiremi oke nii gama qupadzomorai mae? ");
INSERT INTO ghs_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Hiiremi noi hee, Oo, dzobadzoba nameta noo oke ana gama qusubaite baaorai. ");
INSERT INTO ghs_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Totoho oonomata hiiremi Dzesui noke hee, Oonihe poma teeke nii gesina naataamanita anake iihorareiqa isanate nii tuuma quba bosa niime gama oho ttuma quba hiiremi biranatemi ttuma oke gama abi habanaho quba batabiremi bamu naatare. Bamu naatemi niimae anake iihami quruma qusuna teei niiho quba iisuta peitakoi oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Oonihe abi soopara noho quba bosai samanenipamu oomi nota bamenoma naatemi noho penga ruruhorota. ");
INSERT INTO ghs_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Oke Dzesu mooqi erake hiireta, Abi quruma minanomai qidzoke Ohongaho pobita dzuubaqu, ");
INSERT INTO ghs_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Oi kamere teei baako puita dzuubaqu oi quba adzahaha bamuhe, abi quruma minanomai Ohongaho pobita dzuubaqu oio quba bamenomanipamu. ");
INSERT INTO ghs_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Oke hiiremi qesai nookaqi eraiqi hiireta, Idze, oonita qidzoke abi teei Ohongaho neta qidzanataqu. ");
INSERT INTO ghs_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Oke hiiremi Dzesui hee, Abiho neta quba qesa eetaquho tete ooraama oonihe Ohongaho neta eetaqu oke bamu tee ma teeho bitta eetaqu. ");
INSERT INTO ghs_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Hiiremi Peetoro noi hee, Nookare, nanamae aoqake quba samane naname pekha eete niiqake iihorai. ");
INSERT INTO ghs_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Oke hiiremi Dzesui hee, Dzoobe, nike naga nikeme qaateqi ata ma khameto mai ma pai, nomamane nanemane qesamane nikeme gama qaate Ohongaho pobi iihorai. ");
INSERT INTO ghs_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Oonita ape ma apei oonomake eetaqu nikei oorama qaara nikemeta oho ipi ma ari samaneke saridza qaaqa oho tongo neta qaraqara tatanga saridzakoi oke ana meeke nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Oke hiiroramuti Dzesu tumakhameto tuerebe nomeke pobi hiireta, Qateqa, napa poiqa tuumaqa Dzerusaremuta biranatemi too abi samanei Abiho Isaki anaho qamodzamodza qeete qaabi oi ota gama meenoma naatare. ");
INSERT INTO ghs_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Oi Dzuta abi nokoi anake raaba abiho botota mootomi noko anake too neinei ma boto koko eeteqa ekepusa eetakoi. ");
INSERT INTO ghs_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Oke eeteqanoke paha anake bitebate biireqa hapahapanaitemi baatakoi. Oonihe ete taparike paha qoridzakoi. ");
INSERT INTO ghs_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Oiqi hiiretanihe nokoi nookami noo qahurani mai dzukudzukunaho tomidza naatemi nokoho qupa te uhubara. ");
INSERT INTO ghs_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Oonita nokoi teteta tuuma qaaramuti Dzeriko nagapake dzamoitemi abi tee nese khabanomai tete sigiqata habese nenesa hiirota. ");
INSERT INTO ghs_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Hiiroqi nookami abi tupu baa tuumami husu nookaqi oho khooba quba qasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Hiiremi qesai hee, Dzesu Nadzaretteho nenaio baa tuusubiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hiiremi noi sokateqi hiireta, Dzesu Tabitiho eema ma khata qoe! Nii naho quba dzasa eetare. ");
INSERT INTO ghs_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Oke hiiremi tumakhameto qesai bosa qooro tuumata nokoi noke qamuni hiiremi eehe, noi beedzae eeteqi sokateta. Hee, Tabitiho eema ma khata, nii naho dzasa eetare. ");
INSERT INTO ghs_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Oke hiiromi Dzesu roroko biireqi hee, Noke dzeima baabareiqi hiireta. Oonita noko dzeima baami Dzesui noke qasa hiireta, ");
INSERT INTO ghs_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Nii dza eetemi ana ikake eetaqu? Hiiremi noi hee, Soopara name, ana nesenoma naatare dza eete. ");
INSERT INTO ghs_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Hiiremi Dzesu noke hee, Dzoobe nii oho ai tataumanomanita qidzanateqa ao haba moorare. ");
INSERT INTO ghs_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Oke hiimi ao haba moo isanateta. Oonita noi Ohongaho hasa ma gegema hiireqi qori Dzesuke iihami abi minarai oho qesa Ohonga dzoobe hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Obete Dzesui Dzeriko nagapata biranate tuusuta. ");
INSERT INTO ghs_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tuusuhimi ttagetti apiapiho mai teei ota oota, dzapa noho Dzakheo, abi ttuma minanoma. ");
INSERT INTO ghs_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Noi Dzesu moorare hiiretanihe noho sama hoteqa oomi noi abi tupu oke bittake eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Oho qubake Dzesui tete apeta tuumotake noi qupadzomaqi girodzoma toroumaqi ao ee peiteta. ");
INSERT INTO ghs_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Peitemi Dzesui ota biranate nese qusubaite mooqi noke pobi hiireta, Dzakheo maqa! Anai poiqa niiho nagata peitare hiiremi ooraita ao quratare. ");
INSERT INTO ghs_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Oke hiimi noho qupa tukubami noi qaki quba buu ma dzake qurate noke naga nometa dzeima peiteta. ");
INSERT INTO ghs_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Oonihe abi samane moohimi Dzesui abi qanga oonomaho nagata peitemi noko oho barubaru hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Oonihe dzakheoi Dzesuke ao dzaga bobotoqi tete nome pobitareiqi hiireta, O Soopara name nookare. Poiqake ana ttuma ma quruma name bisata geemaqa totaqike abi habanake moitake boobi. Ma paha abi tee ma teeke ana ttuma oberama aimami ooraiqake oho ipike ana burisi eetakoi. Oonihe oho isakike keke bahe oho dzareke ana eserima ipibiremi oi noho naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Oke hiiremi Dzesui hee, O dzoobe, ana poiqa niiho nagata peiteqi moohimi nii Abarahamu ma karaho isakita ai tataumaqi ao ingonaho ttarita qeeme. ");
INSERT INTO ghs_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Oonita qesai barubaru hiireta Dzesui nokoke hee, Nike nookare, Abiho Isaki Anai teeho quba baabaranihe abi eranomaho qesa rasaki naateta nokoho qiri eete ingonaitareiqi baata. ");
INSERT INTO ghs_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Dzesui noo oonomake hiiremi abi oona oota nokoi gama nookaqi qupadzomata. Qate Dzesui abi minama noko tuumoqi Dzerusaremu dzamoiteqi abi qesa erake qupadzomata. Oo, Ohongaho pobi ao ota paana naatake boobiqi hiireqi qeemota. ");
INSERT INTO ghs_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Oho qubake Dzesui gotta ma pai erake hiireta, Abi mina dzapa pobinoma tee noi abi ma ttoka nome gama mai eetaridzoho geeba saridza qubake haba khara gamaniho nagapa qibata tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Oonihe bosata noi kokora abi tteni nome ttuttuiteqi noko gama iso keke ttubenti kinake moite soubireqi hiireta, Anai tuusuhima nike gee ooma pisinisi ape ma apeke eetomake oho ttuma mina naataqu oke eetemi ana baabakoi. ");
INSERT INTO ghs_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Oiqi hiire tuumata oonihe kokora abi bahe abi qesa noho pesuna qaata nokoi noho goottaeke eeteqi qesa noo hiireta, Mmhm, noi bamu isanate napaho qiba naataqu. Oonita nokoi oho totohota isere qeeteqi gamaniho nagapata dzoobireta. ");
INSERT INTO ghs_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Oonihe abi oi ao hairiamake abi ma ttoka oho geeba saridzeqi burisi eete nagapata baata. Baaqi bosata kokora abi qesa ttuma moiteta nokoho kira hiireqi hiireta, Oonita pisinisi ikanomake nike eetemi ttuma minanate? ");
INSERT INTO ghs_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Hiiremi kokora abi bosabosai baaqi hee, Soopara name, ttubentti kina nii ana moiteta oi ao tu hattatti kina (K200.00) natte oorai. ");
INSERT INTO ghs_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Hiiremi noi hee, Dzoobe nii quba gattiqa ooma baura bageke eetemi oorai oho qubake ana hiiremi nii nagapa tteni oho soopara oorakoi. ");
INSERT INTO ghs_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Hiiremi paha teei baaqi hee, O soopara ttubenti kina nii ana moiteta oi aoke uani hattatti kina (K100.00) naate oorai. ");
INSERT INTO ghs_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Hiiremi noi abi oke hee, Dzoobe, paha oho quba ana hiiremi nii nagapa boto teenaho soopara oorakoi. ");
INSERT INTO ghs_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Hiiremi abi paha teei baaqi hee, Soopara, ttubentti kina nii ana moiteta oke ana ttoba kisinama qoomata oi urai ooraita moora. ");
INSERT INTO ghs_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Oi nii quba teeho dzoo eetaamake ao oho mee dzurutare hiirorai ma nii quba teeho baura eetaamake oho tuuma ao aimorai tete oonomake nii eetemi ana atti eete qaatemi oorai. ");
INSERT INTO ghs_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Hiiremi Soopara noi noke hee, Oo, ana abi soropurunomani baura eetaamake oho ttuma aimorai ma quba teeho dzoo eetaamake oho mee rumutorai oke nii nookami oke eete ooraita nii ttuma oke aima omaho maimane nokoho qohareta mootomi ota bageke eete oorarori ma paha oho patisigi minanatarorihe baamunipamu! ");
INSERT INTO ghs_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Oonita kokora abi qanga, niimaeho tooi ao niiho isere hiiremi anai bamu niike kanabetaqu. ");
INSERT INTO ghs_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Oke hiireqi noi burisi eete qesa oona qoorota nokoke hee, Nike abiraho ttubentti kina oke noho botota aima oke abi tu hattatti kina saridze oorai noke moitare. ");
INSERT INTO ghs_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Oi teeho quba bamuhe abi eekara adzahahanomaho botota quba ipibidzakoi. ");
INSERT INTO ghs_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Qate abi gauho botona gettara gattiqa oorarori oke gama karabetakoi oke ana bamu nike dzaheitaqu. ");
INSERT INTO ghs_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Qate abi qesai naho ibo eeteqi hee, Abirai bamu nanaho qiba naataquiqi hiirorai nokoke nike aima baa naho pengata sobana sooromi bamu naatare. ");
INSERT INTO ghs_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Oke hiire qaateqi Dzesui Dzerusaremu dzamoihiqi teteta peiteta. ");
INSERT INTO ghs_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Oonita noi Bettepage ma Bettania nagapa robeta biranahiqi tora Oriba hakha eeteqi tumakhameto eserike dzoobireqi eraiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Hee, Nagapa gattiqa tupidza totaqina oorai ota nipe dzuuba moohimi toogi khata agiagi ota suuto oorai noke saqoroqa dzeima baabare. ");
INSERT INTO ghs_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Qate teei nipeke hee, Nipe naane quba oke saqohibi ooiqi hiima hee, Oo, Soopara napahoi oho quba hiire. Ooqake nipe hiibare. ");
INSERT INTO ghs_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Oke hiiremi nopo tuumaqi moohimi Dzesu nopo pobi hiiretaqaho isaki biranateta. ");
INSERT INTO ghs_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Toogi khata oke nopoi saqohimi oho maimane mooqi hiireta, Maaqa naane quba toogi khata oke saqobi? ");
INSERT INTO ghs_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Hiiremi nopo hee, Teeho quba bahe Soopara napahoi oho quba hiire. ");
INSERT INTO ghs_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Oke hiiremi qaatemi nopoi oke dzeima dzesuho torota biranateqi nokomae gama ttoba ma sasa qesa nokome toogike sama eeteqi Dzesuke noho heeta mootota. ");
INSERT INTO ghs_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mootoqi noko gama qeemaqi qesai paha dzapa nohoke qusubaiteqi ttoba ma sasa nokome kuimaqi teteta tiitemi oho heeta qooro tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tuuma qaaramuti Oriba hapa gaibahimi tumakhameto noko abi samanema nokoi garuruiqi Ohongaho obaoba ma baura samane nokoi moo qaataho qubake noho hasa minanipamuke hiire qurateta. ");
INSERT INTO ghs_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nokoi hee, Dzoobe, Dzoobe! Ohongaho dzaapai ao abi qiba napaho naatareiqi baabe. Oho quba napai dzapa pobi nohoke ai peitanipamuke eetemi qusuho hasu ma keba igabidzare. ");
INSERT INTO ghs_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Oke hiiromi Pariseo qesai garuba oho nakuta ooqi Dzesu pobi hiireta, Banaita, nokoi totoho oonomata hiiremi nii noko qamuni hiibare. ");
INSERT INTO ghs_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Hiiremi noi nokoke hee, Bamu, nokoi nipanatemi oma ma tapai gama areare hiibaridzoni. ");
INSERT INTO ghs_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Oke hiire Dzerusaremuta peqihiqi Dzesui nagapa oho abi quba tti ma surupo eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Noi hee, Hasu nikemeho pobike nike saridzarorihe bamu, hasu oho teteke nike ruume naateqi qahitotorai. ");
INSERT INTO ghs_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Oho qubake bodza teeta (Roma) abi ibo nikehoi qaa qogoimaqi nagapa nikehoke rome biireqa totaqi ma totaqi gama hottoutoqa ngausa eetakoi. ");
INSERT INTO ghs_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Oke eeteqa khameto nikehoma nikeke gama rubengaiteqa omama naga tatanga samane gootomi oorai oma oke gama kotoro qagaumaqake sepesapeitakoi. Oi teeho quba bahe Ohongai poiqa ogama baahumi oke nike ruume naate basesa eetorai. ");
INSERT INTO ghs_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Oke hiireqi noi Ohongaho biirita peitemi pisinisi abi ota dzaodzaoma ttuma ma kapa eetomi noi mooqi hiireta, Totoho erake qeetemi oorai, Anaho nagaio pupu bauraho quba ooraiqi hiirorai. Oonihe nike ikake eeteqi oke maketti sobadzaho isakita mootorai? Oke hiireqi noi nokoke gama hotou biireta. ");
INSERT INTO ghs_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Obeteqi noi bodza samaneke biiri oho nakuta abi tete banaite qaami dzube abi mimi ma qetaqeta abi nokoi nagapa abi mimi qesama gama Dzesuke ngausa eetaquho tete qiri eetota. ");
INSERT INTO ghs_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Oonihe abi samanenipamu noho noo toma tiite nookataho isakita noko noke bitta eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Oonita Dzesui qupi ma sau samaneke biirita abi sinabidza hiire qaami bodza teeta Dzube abi mimi ma qetaqeta abi ma bosa qobaqoba qesai baata. ");
INSERT INTO ghs_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Baaqi noke qasa hiireta, Apei hiiremi nii eranomake eetorai? Niiho geeba ikanoma oomi nii oo hiirorai? ");
INSERT INTO ghs_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Hiiremi noi hee, Oore, oonihe ana paha bosata nikeho quba qasa teeke hiiremi oho ipi hiiremake hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Oi Dzohane sobasobai baura eete qaata oke nike moomi abiho nenani mae Ohongahoni? ");
INSERT INTO ghs_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Hiiremi nokoi qupa nokometa hee, Idze, napai Dzohanehoke hee Ohongahoniqi hiibaquko noi ao napake hee, Oonita nike naane quba noho nooka qusubaitaama naatetaiqa hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Oonihe napai hee, Dzohaneho baura oi abiho nenaniqi hiibaquko abi erana noo nookorai nokoi Dzohanehoke nookami too abinipamu naatemi noko napaho dzauba eeteqa omama teetaridzoni. ");
INSERT INTO ghs_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Oke hiireqi nokoi Dzesu pobi hiireta, Dzohanehoke nanai hou eete. ");
INSERT INTO ghs_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Hiiremi Dzesui hee, Oionita apei hiiremi ana eranoma eetorai oke ana oho qesa bamu nike pobi hiibaqu. ");
INSERT INTO ghs_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Oke hiireqi Dzesui nokoho qahurake abiho quba hiireqi erake hiireta, Abi mina teei dzoo teeke dzaaroqi oke geeba biireqi ttuma quba abi qesaho botota mootoqi haba kharata tuumaqi oota. ");
INSERT INTO ghs_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ota oomi mee rumutaquho bodza dzamonatemi noi kokora abi nome abi nokoho torota dzoo oho mee qesa aima quba dzoobireta. Oonihe nokoi kokora abi nohoke buribaroke teeteqi habanake dzoobireta. ");
INSERT INTO ghs_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Oho quba maikhatai oho habara abi teeke paha dzoobiremi nokoi noke oho qesa noo qanga hiireqi buribaroke teeteqi habanake dzoobireta. ");
INSERT INTO ghs_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Oho quba paha teeke dzoobiremi noko noke kittikotti eeteqi hotou biireta. ");
INSERT INTO ghs_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Oho qubake dzoo oho maikhatai hee, Idze anai ikate eetaqu? Anai qeseba khata teena nameke dzoobiremi nokoi qusubaitaqu kaqani. ");
INSERT INTO ghs_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Oke hiireqi noke dzoobiretanihe, abi nokoi khatake mooqi qesa gunu ma naru hiireqi eraiqi hiireta, Maqa, maikhataho biidza teena oionita napa noke teeteqa quba tongo nohoke karabete mai eetare. ");
INSERT INTO ghs_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Oke hiireqi khatake teeteqi kebake dzoota hotou biireta. Oiqi hiireqi Dzesu abi tupu oke hee, Nokoi khata oonomake eetemi ooraiho qubake nike qupadzomami dzooho maikhata noi ikake eetaqu? ");
INSERT INTO ghs_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Noi isanate baaqa abi naga oke ngausa eeteqa dzoo nome paha (raaba) abi qesaho botota mootakoi. Oke Dzesu hiiremi Dzuta abiho khooba ota paana naatemi nokoi qarutoqi hee, Oi baamunipamu ooniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Hiiremi noi nokoke asabireqi eraiqi hiireta, Nike oho bai hiibihe khooba apeqaho qubake qetaqeta erai biranate? Oi hee, Naga gosogoso abi nokoi baura eesuhiqi oma teeke ngiingi eetemi ikanomake eete oma oi aoqake naga oho ttittira naate oorai? ");
INSERT INTO ghs_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Oho quba oma ngiingi eetetahota apei taataqu noi rubenga saridzakoi ma oma oi apeho irita taataqu taateqa noke huhuitemi ngausa naatakoi ooiqi hiiremi ooraita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Hiiremi nokoi nookami qahura oi nokoho khooba paanaitemi bodza ooqata keke qetaqeta abi ma dzube abi mimi nokoi ao Dzesuke karabetarotahe abi qesa samane oona noo nookota nokoho attike eeteqi qaateta. ");
INSERT INTO ghs_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Oonita bosa qobaqoba nokoi tete qiri eeteqi Dzesuke ikanomake eeteqi nooma qoqopa eetemi angita qooromi karabeteqa haba oho kiapeho torota mootarota oho qubake nokoi sama gebageba abi ikoikonoma qesake saridzeqi Dzesuho torota dzoobiremi tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tuumaqi nokoi Dzesuho torota noo erake hiireta, Banaita naname, nanai moomi nii abi teena teeho penga qubake te eetoraidzaranihe, noo mee, tete rike ma pobi Ohongai hiiremi ooraiqaho isakita abike bapotopotorai. ");
INSERT INTO ghs_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Oho quba nii qupadzomami Dzuta abi napai. Kaisaho torota ttagetti biiremi hu noota isanatorai, mae bamu? ");
INSERT INTO ghs_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Oke hiiremi Dzesui ao nokoho ikoiko qupadzomaqi noko pobi hiireta, Seke oma teeke ana banaitare. ");
INSERT INTO ghs_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Hiiremi oma sarara teeke noke moitemi hee, Apeho gisigisi ma qetaqeta oho samata biranatemi nike moorai. ");
INSERT INTO ghs_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Hiimi nokoi hee, Oio Kaisahoni. Hiimi noi hee, Kaisahonita quba samane nohoke noke moitarenihe, Ohongaho quba samane oke paha noomaeke moitare. ");
INSERT INTO ghs_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hiiremi nokomaeho qoqopa nooi abiho pengata saqobami nokoi roqobeta minake eeteqi nipanateta. ");
INSERT INTO ghs_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Qate Satukeo abi qesai hee, Abiho tukutuku ooraamaniqi hiireqi baaqi Dzesuke toronaitareiqi qasa eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Hee, Banaita naname, Mosei nanaho quba erake eete qeeteta. Abi atanomai khata dzoomaamake baatemi noma nohoi gisi nohoke qusubaiteqi atapa oke naateqa biidza noho quba saridzareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Qate noorake qupadzomare. Nomamane nanemane sebeni qaata. Qaaqi nane gottai ata naateqi khata dzoomaamake baateta. ");
INSERT INTO ghs_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Baatemi noho saamai ata oke naateqi oho qesa biidza saridzaamake baateta. ");
INSERT INTO ghs_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Oho qesa noho saama eetemi nomamane qesai gama noke naate biidza saridzaamake baate bamu naateta. ");
INSERT INTO ghs_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","33","Oho qesa atapai musaqi baateta. Oonihe noi abi sebeni oke naate soubiretaho qubake abi baata neta qoridzaqu bodzata noi nokohota apeho pobi ooraqu? ");
INSERT INTO ghs_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Hiiremi Dzesu noko erake pobi hiireta, Nookare. Abi eehahai paimaneke naatemi paimane oho qesa abike naatorai ao ttokata oke eete oorai. ");
INSERT INTO ghs_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Oonihe abi ma paimane baatorai minarahota apeneho dzapai qusu habata biiranataqu nokoi tukutuku bodzata eehaha naatakoihe bamu qesa naataqu. ");
INSERT INTO ghs_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tukutukuho ttarita qoobaqu nokoi Ohongaho birabira naateqi angeroho isakita nokoi bamu qesa naataqu tete oke qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Oonihe nike hee, Qidzoke abi baateqa paha eehaha naataquiqi hiiroraiho khoobake ana noo erake hiire, Mosei agobake eehohota qooroqi uimane neimane ago baate bamu naate oota nokoke noi te hou eetaranihe eraiqi hiireta, O soopara nii Abarahamu ma Isaka mi Dzakopo ma nanaho Ohonga teena oioniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Oho qubake moomi Ohongai te dzaetaetaho pobi oonidzaranihe qaraqaranomaho pobi kekeni. Noi abi minarake qaraqaraho asinaitemi oorai. ");
INSERT INTO ghs_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Totoho oonomata Dzesui hiiremi qetaqeta abi qesai noke hee, Banaita, oke nii meenipamuke hiire. ");
INSERT INTO ghs_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Hiiremi oho quba abi paha teei noke noota toronaitaquho isakiama naate qaateta. ");
INSERT INTO ghs_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nokoi torona oke qaatemi Dzesui nokoqake toronaiteqi hiireta, Abi qesai ikanomake eeteqi hee, Kiristui Tabitiho eema ma khataniqi hiirorai? ");
INSERT INTO ghs_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Oi Samuho geeta Tabiti noomae noo qeeteqi Ohonga mai ma Kiristuhoke hiireqi eraiqi hiireta, Sooparanipamu Nii Soopara nahoke hee, Anai ibo niihoke suqobireqi niiho pesunaitakoi. Oonita nii oho beebe eeteqi poro qere nahoho samaqata qoobakoi. ");
INSERT INTO ghs_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ooiqi hiireqi nopoho dzapake Soopara keke hiiremi ikanomake eeteqi qesai Kiristuke hee, Noi Tabitiho eema ma khataniqi hiibaqu oho tete oorai kaqanihe oi ikanoma? ");
INSERT INTO ghs_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Oke hiiremi qetaqeta abima kara noo oho bittake eetemi garuba oho bisata Dzesui Dzauba barike tumakhameto nome pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Hee, Qetaqeta abi nokoi quba qesaho dzaodzao minake eetorai. Nokoi sasa khara kharerepo qoomaqi tuuma ma baaba eetorai, ma ttumaho sobadzata abi nokoho dzapa qusubaitemi nokorai ma sinabidza guhuta teka bosata habesorai ma hoo ma pattaho qohare bosata habesorai oonomaho dzaodzao minanipamuke noko eetorai. ");
INSERT INTO ghs_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Oonihe tarumi nokoi nokoho torota sinasina aima quba biranatemi qetaqeta abi nokoi nokoho quba pupu hiireqi sepeke pupu kharaiteqi oho isakita tarumiho kapurake muunami bamu naatorai. Nokoi abi sepe bamuta oho ipike noko quba bamenomanipamu saridzakoi. Oho qubake nike qetaqeta abiho teteke potti biire qaarare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Oonita bodza teeta Dzesui nese dzoobireqi moomi abi ttuma minanomai oma nokome qonotoqi maubaho takurata biirota. ");
INSERT INTO ghs_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Biiromi moohimi tarumi pai habana teei ota qooroqi ttimuna eserike takurata mootota. ");
INSERT INTO ghs_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Mootomi Dzesui hee, meenipamuke atapa habanarai takurata biire oi qesaho qonoqono gama suqobire. ");
INSERT INTO ghs_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Oi teeho bahe qesai meupu nokometa isakiqata giimaqi qonotoraihe ataparaho paramu ao bamu naatemi qetta musaqi oke poiqa biire bamuite. Oke Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Qate biiri oke oma qidza dzapanoma nee ma baunomama gootota oke tumakhameto qesai moo hasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Hiiremi Dzesui hee, Maqa oma hee ma heeta gooto baa qaimi nike moori oke gama kootoromi takoba soubidzaqu bodza ao hiiremi oorai. ");
INSERT INTO ghs_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Hiiremi nokoi noke oho qasa hiireta, Banaita naname, Nii hiireho mee bodza apeta biranataqu ma oho qaamodzamodza ikanoma biranataqu? ");
INSERT INTO ghs_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Hiiremi noi hee, Meenipamuke qesama nikei ooqata oberama qupadzomorai oonita korabete nookare. Qesai naho dzapata baaqa hee, Oho bodza poiqanita anaio era baabe. Oke hiiremi nike eto nokoke qaupuiteqa iihaino. ");
INSERT INTO ghs_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Oho qesa nike noomaki uuba ma sakaba, qaa ma quba attinoma dzapa samane biranatemi etoqa oho quba ququimaino. Quba oonomai biranate qaamake kebanoke bodza oke suhe hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Hiireqi noi hee, Haba maina paina qesa qaa qogoimakoi, qesa teeta ma taanga mina biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tuumu mina rubabetakoi, khettedza ma heme maina paina biranatakoi, seebe mina biranatakoi ma qusuta quba attinoma biranate mumure oho isaki naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Oonihe oi biranataamake bosata nike naho quba baura eetoma abi qesai nike karabete bame moiteqi sinabidza guhu qesa ma sutasuta naga qesata qeema qohareta mootakoi, paha kiape ma abi qiba qesaho torota mootakoi. ");
INSERT INTO ghs_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mootakoihe ota nike naho isere qidza hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Oho quba eto nike sauqata hee, ikanomake eete quba oonomake arabidzaquiqi hiibaino. ");
INSERT INTO ghs_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Oi bodza ooqata keke ana naamae nike noo ipi moitemi nikeho too saqobami oho nokanokai nokoke Suqobiremi noko too saa eetakoi. ");
INSERT INTO ghs_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Oonihe paha mai ma pai, noma ma nane, qesamane nikehoi nikeho isere qanga hiiremi qesa ma nikei oho quba baatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Oi naho dzapai nikeho irita oorakoi oho quba qesa samanei nike ibo eetakoi. ");
INSERT INTO ghs_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Oonihe Ohongaho pengata nike susupuke oorakoi. ");
INSERT INTO ghs_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Oi nike oho battigara naate qaaqa qupa khata nikeme ingonaitakoi. ");
INSERT INTO ghs_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Dzesui hee, nike qaamodzamodzahoke hiire, oi raaba abike nike moomi bodza apeta nokoi qaa qogoimaqa Dzerusaremuke rome biidzaqu oio ngausa nohoho utani. ");
INSERT INTO ghs_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Oke moohiqa qesa ma nike Dzutea habana ooraqu nikemae ao sakaba tora ma tapata tuumare. Qate qesai totaqita ooraqu nikei roroko biidzainohe ao tta eete tuumare. Qate qeba nena oorai nokoi etoqa bosata nagapa ota peiteqa quba saridzareiqi hiibainohe tuuma keke eetare. ");
INSERT INTO ghs_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Oi teeho quba bahe basesa nokohoho too pasere bodza oio. Ooniqi hiire qeetemi oorai. ");
INSERT INTO ghs_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Paimane qurana ma amenana ooraqu nokoho heme minanipamu ota biranataridzo oi nagapa oho abi ipima ari oke saridzaquho bodza. ");
INSERT INTO ghs_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bodza ota abi qesake dzubetemi bamu naatakoi qesake suutoqa haba maina painata mootakoi. Oke eeteqi Dzerusaremuke qorobire qaamake raaba abi oho qaai bamu naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Dzesui hee, Bodza ota ete ma dzasidza ma ttoka ma pomatti samane oho neta mumure qesa biranatakoi, ma besaho pouma husu minanipamu hiiremi abi suusupu oho qupa muunakoi. ");
INSERT INTO ghs_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Qusuho bise ma baise rubaruba eetakoi. Eetemi quba bamenoma abiho irina biranataquho atti minanipamuke eeteqi qesai oho qupa ororo eete baatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Oonihe bodza oi biranatemi Abiho Isaki anai biranatemi naho beedzae ma dzapa pobi paananipamu naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Oonita quba oonomaho qaamodzamodza oke nike mooqa hee, Nanai qidzanataquho bodza ao dzamonateiqi qupadzomaqi qoridzeqa Ohonga dzoobe hiibare. ");
INSERT INTO ghs_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Oke hiireqi Dzesui qahura teeke hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nike pogari ma ee qesa moohimi bittina soobaqu bodzata nike hee, Oo, ao mee eetakoiqi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Oho qesa ana hiirori qamodzamodza oonomake nike moohiqa hee, Oo Ohongaho pobi ao biranatare eeteiqa hiibare. ");
INSERT INTO ghs_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Oi abi nagarai baate bamu naataamake qubarai gama meenoma naate soubidzakoi. Nookare. ");
INSERT INTO ghs_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Qusu ma ttokai uubakoihe naho noo oi bamu sapara naataqu. ");
INSERT INTO ghs_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Oke hiireqi noi paha hee, Nike hutingi naate oora ma qaara nikemeke iinga ma siidza ma oba tatanga ma quba samanema eto rasakiitaino. Oi nike oonoma eetemi bodza oi seike biranate abi samane ttokana ooraiho irita taataquho isakita nikeho irita eto taataino. ");
INSERT INTO ghs_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Oonita quba oonoma samane biranatare boohimi nike etoqi oho kabira naatainohe, Abiho Isaki anaho pengata qooromi isanatare hiireqi roqoroqo ma sahasahama pupu hiire qaarare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Oi etebake Dzesui oonomake eete biiriho neta qupi samaneke sinabidza hiire qaatahe, qupibake noi tuumaqi Oriba torata mee qaata. ");
INSERT INTO ghs_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ma iihai mootomi noi paha baaqi biirita peitemi abi samane noho torota ttutturate noho noo nooka qaata. ");
INSERT INTO ghs_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ingonaho dzuma mina, bodza oonomata Dzuta abi te dzobadzoba qura huitanoma muunoraidzara. ");
INSERT INTO ghs_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Oonita Ingonaho dzuma oke bohimi dzube abi ma qetaqeta abi nokoi Dzesuho gunu ma naru hiireqi abi tupuho attike eeteqi tete qiri eete saridzaama naateta. ");
INSERT INTO ghs_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Oonihe bodza ooqata Saatai tuerebehota teeke qaatutu biireta, dzapa noho Dzuta Khariottaho nena. ");
INSERT INTO ghs_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Oho qubake noi Dzesuke geema mootareiqi dzube abi mimi ma pirittani mimiho torota biranate nokoma noo hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nokoi noho noo nookami nokoho qupa tukubami nokoi noke oho ttuma moitareiqi naru hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Oho quba Dzutai noo oke tatangaiteqi garubaho amata Dzesuke ikanoma eete geema mootarota tete qiri eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Oonita ingona dzumata nokoi sipisipi khata dzuubete roibetarota bodza naateta. ");
INSERT INTO ghs_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Naatemi Dzesui Peetoro ma Dzohane dzoobireqi hee, Nipe tuumaqa ingonaho patta roibeteqa napa ttaike dzuma oke eetare. ");
INSERT INTO ghs_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Hiiremi nopoi hee, Oke ika neta roibetaquiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Hiiremi noi hee, Nookare, nipe nagapa qiba pou minata dzubapihiqa abi oba mangi aimanoma teeke ota saridzakoi. Oonita noi naga apeta peitaqu oke mooqa paha nipemae peitare. ");
INSERT INTO ghs_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Peiteqa naga oho mai khata pobi hiireqa hee, Banaita napahoi hee, Ana tumakhameto namema ingona dzumaho pattake suruho apeta muunaquiqi hiire ooqake hiibare. ");
INSERT INTO ghs_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hiiremi abi oi nike suruho heena mina roibetemi ooraike nipe banaitemi ota dzumaho roiroi eetare. ");
INSERT INTO ghs_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hiiremi nopo tuumaqi moomi Dzesu hiiretaho isakiqake saridzeqi ota urai eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Urai eetomi Dzesu baaqi tumakhametoma nokomae ooqata tirere eete qidzanateta. ");
INSERT INTO ghs_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Qidzanatoqi noi noko pobi hiireta, Anai bame mina saridzare boobihe, oke saridzaamake bosata nikema ttaike dzumaho patta muuna quba dza minanipamuke eetoraita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Eraio tete usaqeho qaamodzamodza musaqi oonita erake anama napa gama muuhiqa bamu paha qaamodzamodza qupadzomaquhe Ohongaho pobi ao mee naatake boohibiqi qupadzomakoi. ");
INSERT INTO ghs_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Oke hiireqi noi khooru oke aimaqi agoago hiire qaateqi noko pobi hiireta, Erake aima nikeme quba pattabetare. ");
INSERT INTO ghs_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ana hiibi, Ohongaho pobi aoke napaho irita qeehibita eka mee eraho oba ana bamu paha qaamodzamodzaho isakita muunaquhe erai oho musaqi oni. ");
INSERT INTO ghs_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","20","Qate patta bosabosa oke noko qaateqi Dzesu dzobadzoba usaqe teeke aima agoago hiireqi qootoqi noko moiteqi hiireta, Eraio mee nahoho isaki poiqa nikeho quba moote oonita nike nahoke qupadzomaqi mumure oke ipibirorare. Hiireqi noi paha khooru aimaqi hee, poro tongo usaqe nikeho quba saqobare eete dzuu oho isaki erani. ");
INSERT INTO ghs_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Oonihe Iidze, nikehota teei naho qohareta ttaike boto dzoobire patta muunorai noi anake geema moosobi. ");
INSERT INTO ghs_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Abiho Isaki anai name isanate heme moorakoi oke geeta qeetemi tatanga naate ooraihe, abi apeho boto qubake ana ota biranataqu nohota bamenoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Hiiremi tumakhameto nokoi noo oho quba qiri eeteqi hee, Napahota apei oonoma eetake boobi? ");
INSERT INTO ghs_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Oonihe noko noo oke qaateqi nokomaehota apei abi mina naatarota oho noo baurake eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Eetemi Dzesui noko pobi hiireta, Ttokata abi qibai meenipamuke abi sooparaho dzapa pobita soropurunoma naatemi nokoho pesuna oorai oke ikaqi hiibaqu, bamu. ");
INSERT INTO ghs_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Oonihe nikehota oho tete ooraidzara. Teei mina naatareiqa qupa gaibanomata oorare, ma apei soopara naatareiqa isanate qesaho tuhotuho naatorare. ");
INSERT INTO ghs_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Oi nike ttokaho pomake moohimi abi minai te qesake tuhororaidzaranihe noomae qidzanasuhimi qesai noho kokora eetorai. Oonihe nike naho teteke moohimi anai tuhotuhoho isakita oorai. ");
INSERT INTO ghs_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Oke hiire qaateqi Dzesu nokoke ttapuitareiqi hee, kaipo ma qangareba samane napake suqobire baaoraihe nike ana qaataama ma peperataamani. ");
INSERT INTO ghs_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Oho qubake Ohonga mai anaho quba poro tongoho pobi teeke hiiremi oorai. Oho isakita ana paha naamae ao nikeho baura kamo biiremi nike naho qohareta oba ma patta ttaike muuna qaaqa poro qere nahota hoobire Isirae abi tupu samaneke batabire qaarakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Hiireqi noi Peetoroke dzaga bobotoqi ttokaho dzapa nohota hiireqi hee, O Siimo, Saatai ao nii benateqi eringa mutuho isakita niike kurutete huitemi nii nookorai mae? ");
INSERT INTO ghs_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Oonihe eto niiho ai tatauma goono naatainoiqi anai niike puputa too teetorai. Oonita nii dzogetoma qori paha pobirateqanoke oho qesa qesamane niimeke too teetorare. ");
INSERT INTO ghs_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Hiiremi noi roqobeteqi hee, Soopara name nookare. Anai niima nakamae sutasutata tuumaquni mae baataquni mae ikanomake eetaqu, teena oke naho qupa hiirorai. ");
INSERT INTO ghs_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Hiiremi Dzesu misi teteqi hee, O Peetoro, qupi sooreta nee ungapa noo hiibaamake nii anake hee, Noke ana ruumeniqi hiire hiireke tuumami ao tapari naatakoi. Oke ana bamu nii ikotetaqu. ");
INSERT INTO ghs_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Dzesu noko pobi hiireta, Tumakhameto, ana nike qaru dzoobireqi asi ma ttuma sengi ma oho sasa quba oonomaho amake dzoobiremi nikeho quba teeqai isanataama naateta mae? Hiiremi nokoi hee, Bamu oi gama isanateta. ");
INSERT INTO ghs_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Hiiremi noi hee, Qate poiqa ana nike paha tete erake pobi hiire, Teeho asi ma ttuma sengi ooraimake aimare. Ma teeho qaa dzube ooraama naatemi noi isanate ttoba teeke ttuma quba mootomi biranatemi oke qaa dzube quba mootoqa aimare. ");
INSERT INTO ghs_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ma oi teeho quba bahe qetaqeta teei nahoke hiireqi hee, Abi nookami noi koiri kairiho nenaniqi hiireta qetaqeta oi eto sapara naatainohe meeho tomidzabari naatare. ");
INSERT INTO ghs_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Oke hiiremi nokoi hee, Soopara naname, napahota qaa dzube eseri oi oorai. Hiimi hee, Ao isanatorai. ");
INSERT INTO ghs_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Hiireqi noko gama ota tta eeteqi Dzesui poma nomeke iihaqi tora Oribata tuumami tumakhameto noke iihata. ");
INSERT INTO ghs_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Oonita nokome mee qaata tekata biranateqi noi noko pobi hiireta, Nike angita dzuubainoho quba pupu hiiroqa oorare. ");
INSERT INTO ghs_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Oke hiireqi Dzesui gattiqa qaheubaqi pomai kotoroqi nomae pupu hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Hee, O mai name, Ima ma bago ana qurataqu oke nii aima sigita biidzareiqa ana ao oho totohota hiibarorihe bamu, nii hiiroraiho isaki keke biranatare. ");
INSERT INTO ghs_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hiiremi qusuho angero teei baaqi noke tatanga moiteta. ");
INSERT INTO ghs_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Oonita qupa bame minanipamu noke suqobiremi noi ipibire pupu hiiromi bere nohoi dzuuho isaki noho irita sooroqi kohukohuma ttokata taateta. ");
INSERT INTO ghs_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Taatemi noi pupu hiire ootati qori tumakhametoho neta biranate moomi nokoho qupa bame minanipamui ao noko suqobiremi meeta. ");
INSERT INTO ghs_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Meehimi noi noko tukutoqi hiireta, Maqoe, naane meera baurake eetorai? Nike eto quba teeho kabira naataino hiireqi pupu hiirorare. ");
INSERT INTO ghs_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Oke Dzesui hiihiimi idze, aoke abi hohoi baahuqi nokoho teei baaqi Dzesu kanabohiqi toone eeteta. Oonihe abi oi ape bahe tumakhata tee, oi Dzuta Khariottaho nena ooni. ");
INSERT INTO ghs_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Oke eetemi Dzesui noke hee, Dzuta meeke nii Abiho Isaki anake kanabohiqi geema moote mae? ");
INSERT INTO ghs_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hiiremi qaa biranatarota oke tumakhameto qesai mooqi hiireta, Soopara nanai qaa dzubenomanita nanai eetaqu mae? ");
INSERT INTO ghs_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Oonihe noi noo ipi hiibaamake tee, oi Peetoro, noi aoke dzube abi minaho kokora abike toma pobi nena oke dzooto qagaumata. ");
INSERT INTO ghs_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Oho qubake Dzesui qaa abi hee, Nike qaatemi ana bosa erake eetare. Oke hiireqi kokora abiho toma hesatemi agimata. ");
INSERT INTO ghs_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Agimami dzube abi mimi ma Dzuta abiho bosa qobaqoba ma Pirittani qesa nokoi Dzesuho dzagata baaqi sudzabeteta. Sudzabetemi noi noko qasa hiireta, Anai koiri kairiho isaki apeho qubake nike koo ma taangama anake karabetare baabe. ");
INSERT INTO ghs_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Anai qupi samaneke nikema biirita baura eete baaoraimi nike teqaha ota anake hesatara. Oonihe poiqai qupiho bodza ma pobi oonita nike eetareiqa eetakoi. ");
INSERT INTO ghs_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Oke hiiremi noko Dzesuke aimaqi dzeima zube abiho nagata tuumami Peetoroi ipitoto baata. ");
INSERT INTO ghs_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Oonita noko dzube abi minaho naga patita biranate dzapa eeteqi eepa qeere oohoro agimota. Agimami Peetoroi baaqi oho qesa nokoma oohorota. ");
INSERT INTO ghs_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Oonihe noi eepa dzadzaho neta oohoro oomi kokora atapa teei noke nese taate mooqi hee, Maa, abirai suma nopome qaabi. ");
INSERT INTO ghs_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Hiiremi noi atapa oho noo bai hiireta, Baamu noke ana ruume. ");
INSERT INTO ghs_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hiiremi gattiqa ipita abi teei paha noke mooqi hee, Maqoe, nii nokohota tee oni. Hiiremi Peetoroi hee, Abiqa anai bamu. ");
INSERT INTO ghs_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Oke hiiremi paha hauba teei bamu naatemi abi paha teei qahiqahike hiireta, Moomi abirai Garireaho abi oonita meenipamu noi Dzesuma karaho nenani. ");
INSERT INTO ghs_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Hiiremi Peetoroi abi oke hee, Nii hiire oke ana hou. Totoho oke hiihiimi khokhora mai ao noo hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hiiremi Dzesu burusi eete Peetoroke nesema asabiremi noi qupadzomata. Noi hee, Idze, Sooparai anake hee, Nee noo hiibaamake nii anaho bai hiire hiireke tuumami tapari naatakoiqi hiirori oi ao mee naate. ");
INSERT INTO ghs_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Oke hiireqi noi tta eetemi noho baruna masubatemi tti minake hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Qate pirittani ma karai quseripo naateqi Dzesuho nese sengibeteqi qoma dzubobireqi teeteta. ");
INSERT INTO ghs_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","65","Teeteqi hee, Oo nii too abi oonita apei nii teete noho dzapa hiibare. Hiireqi noo bamenoma samanema noke midzahubaiteta. ");
INSERT INTO ghs_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Qate iihai mootomi dzube abi ma qeteqeta abi mimiho sinasina tupui qopa nokometa ttutturate hiiremi Dzesuke ota dzeima baata. ");
INSERT INTO ghs_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Baami noko noke hee, Nii Kiristu oni mae bamu, oke nana pobi hiibare. ");
INSERT INTO ghs_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Hiiremi Dzesui hee, Ana hiiremi qidzoke nookaqu. Ma ana paha noo nameke hiiremi qidzoke nikehota meenoma naataqu. ");
INSERT INTO ghs_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Oonihe poo teena erake ana hiire. Ao bodza dzamonatemi nikei Abiho Isaki anake moomi Ohongaho poro qereta peiteqa pobi robe nohota qooro oorakoi. ");
INSERT INTO ghs_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hiiremi nokoi hee, Oke hiireqi nii hee, Anaio Ohongaho khatanipamu ooniqi hiire mae? Hiiremi noi hee, Ana oioni oke nikemae ao hiire. ");
INSERT INTO ghs_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Hiiremi nokoi hee, Iaqa! Nomaeho tooi hiiremi napa nooketa naane quba paha isere tee ma tee nohoho quba roroko biidzaqu? Baamu oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Oho quba abi tupu oi gama susupu qoridzeqi Dzesuke dzeimaqi kiape Piratoho torota tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ota biranateqi nokoi noho pengata Dzesuke qoma dzubobireqi eraiqi hiireta, Noi sama nome qusubaiteqi hee, Anai Kiristu, abi qiba ooniqi hiireqi Kaisaho ttagetti quba qamuni hiireqi abi naga nanaho qupa rasakiitorai. ");
INSERT INTO ghs_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Hiiremi Piratoi Dzesu qasa hiireta, maqa, nii Dzutaho abi qibani mae? Hiiremi noi hee, Nii hiire oi mee. ");
INSERT INTO ghs_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Hiiremi Piratoi dzube abi mimi ma abi tupu oona ttutturateta nokoke pobi hiireta, Kahosa nohoke saridzaamanita bamu. ");
INSERT INTO ghs_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Hiiremi nokoi tototo hiireta, Maa, abirai Garirea habata sohoroqi qeema Dzutea haba napahota baaqi mina ma adza gama nokoho qupake rasakiitorai. ");
INSERT INTO ghs_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Hiiremi noi hee, Oonita noi Garireaho nenani mae? Hiiremi meenoma naatemi noi Heroteho pobi naateta. ");
INSERT INTO ghs_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Qate Herote paha bodza ooqata Dzerusaremuta oomi Piratoi hiiremi noko Dzesuke noho torota dzeima tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Qate Herotei Dzesu moomi noho qupa qidzaqidza biranateta. Oi noi aoqake noho pobi nookaqi noho torota obaoba teeke moora quba dza minake eete qaata. ");
INSERT INTO ghs_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Oonita noi Dzesuho torota qasa noo samaneke hiiretahe, noi teqaha oho ipi hiibara. ");
INSERT INTO ghs_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Noi nipanatemi dzube abi ma qetaqeta abi mimi nokoi noo hee ma heeta hiireqi noke qoma dzubobirota. ");
INSERT INTO ghs_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Oonita Herotei ao noho ngiingi ma baaba eeteqi qaa abi nomema nokoi sohoroqi noho qepuqepu hiireqi abi qibaho sasa qidzaho qaseqaseke aima noke dzaaroqi dzoobiremi paha noke Piratoho torota dzeima tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Oonita Herotei oonomake eete Dzesuke Piratoho torota paha burisi eetetaho qubake abi mimi nopomae ibo nopome qaateqi qesa dzaira eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Qate Piratoi paha Dzesu mooqi dzube abi mimi ma abiho bosa qobaqoba nokoke gama ttutuiteta. ");
INSERT INTO ghs_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ttuttuiiteqi noko pobi hiireta, Nike abirake naho torota dzeima baaqi hee, Noi abi minaraho qupa rasakiitoraiqi hiiremi anai noke toronaite moomi qomaqoma nikehoi meeama naate. ");
INSERT INTO ghs_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Oho qesa Herotei noho obera saridzaama naateqi noke burisi eetemi noi paha khooba apeho quba napaho bisata oorai? Noi kahosa bamenoma eete ooraimake oho quba baatakoihe bamu. ");
INSERT INTO ghs_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Oho quba ana hiiremi noke gabeho biireqake saqobakoi. ");
INSERT INTO ghs_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Hiireta oi teeho quba bahe Ingona Dzumata sutasutana oorai abihota Romaho Kiapei teeke sani saqoro qaata oke qupadzomaqi hiireta. Hiiremi abi tupu nokoi gama qarutoqi hiireta, Oi bamu! Barabake saqobareni qate abirake teetare! ");
INSERT INTO ghs_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nokoi Barabaho dzapa hiireta oi noi Dzerusaremuta Roma abiho qaa tuputa qesake teetemi Kiapei noke oho quba sutasutata mootomi oota. ");
INSERT INTO ghs_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nokoi oonomake hiiretahe Piratoi Dzesuke saqobare hiireqi paha nokoke korabete qasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Hiiremi garuruiqi hee, Bamu! Abirake ao hapahapanaitare. ");
INSERT INTO ghs_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Hiiremi noi nokoke kebaitareiqi paha hiireta, Nookare noi kahosa bamenoma teeke eete ooraimake teetakoi oonihe noi kahosa apeke eete oorai? Baamuta anai noke gabeho biiroraqutoke saqobakoi. ");
INSERT INTO ghs_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Hiiremi abi tupu minanipamuho qubake nokoi dzaubama qarutoqi noho noo suqobireta. ");
INSERT INTO ghs_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Suqobiremi Piratoi nokoke bittake eete peperateqi nokoho noo qusubaiteta. ");
INSERT INTO ghs_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Oi nokoi hu ma koridza, teeta ma taangaho abi sutasutata oota Barabake saqobareiqi hiire Dzesuke hapahapanaitare hiiretaho isakita Piratoi temuke saaqoroqi Dzesuke nokoho dza quba mootota. ");
INSERT INTO ghs_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Oonita Piratoi nokoho dzake qusubaitemi Pirittani ma karai Dzesuke aimaqi tuumata. Tuumaqi hapahapa teeke mai eeteqi Dzesuke moiteta. Oonihe noi bittake eetemi Kureneo nagapa nena, dzapa noho Siimo, noi haba kharata baahumi nokoi noke hee hapahapa oke nii aimareiqi tototo hiiremi Dzesu bosa qooro tuumami noi oke qere biire ipita iihata. ");
INSERT INTO ghs_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ma paha paimane tupu teei noke iihaqi noho quba tti ma ttaka eetota. ");
INSERT INTO ghs_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","31","Eetomi Dzesu burisi eete qahura noota nokoke hee, Poiqa nike moohimi ee gattiqa dzusanoma teena eranomake dzarate, oonihe ipita nikeho bisata abaqasa ngoruta eepa qaitema noho gaabi gattiqa apei nikeho torota biranataqu? Quba bamenomanipamu Dzerusaremu nikeho irita biranatemi nike areare hiireqa hee, Napai qumai oorapu ma khameto amenana oorai nokoi biranataama naatapuko oi gattiqa isanatarori. Nike bodza ota tora ma tapake hee, Nike nanake pupubire ngaumareiqa hiibakoi. Oonita Dzerusaremuho paimane, nike eto naho quba tti hiibainohe nikeme quba ma khameto nikemeho quba tti minake hiibare. Ooiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Qate noko sutasuta abi koiri kairinoma eseri nopoke Dzesuma gama hapahapanaitareiqi dzeima tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Oonita noko qeba neta qeemaqi, poubosa teeho dzapa Qiba gotta, ota peiteqi Dzesuke ota koiri kairinoma eserima nokoke gama hapahapanaiteta. Temu mage neta ootani temu pobita oota. ");
INSERT INTO ghs_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Oke eesuhimi Dzesui pupu hiireta, Mai name, nokoi ruumeke naateqi eetoraita kahosa nokohoke qaatare. Oke hiireta. Qate qaa abi nokoi noho ttoba ma sasa mai eetare hiireqi baabe biireta. ");
INSERT INTO ghs_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Oonihe abi qesaqesai baura oke gama mooqi Dzuta abiho bosa qoboqobama gama qepuqepu hiireqi hiireta, Qesake noi qidzaite baaoraita Ohongai noke asatemi noi Kiristu ooraiqako sama nome hoobidzare. ");
INSERT INTO ghs_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Hiiremi qaa abi oba too bairanoma teeke noho quba mootoqi noho kasai hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Hee, nii Dzutaho abi qiba ooni mae? Oho quba isanate sama niime ingonaitare. ");
INSERT INTO ghs_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Qate qetaqeta paha teeke noho qiba suheta suutota oi hee, ERAIO DZUTAHO ABI QIBANI oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Qate abi koiri kairinomahota teei noke hee, Idze, nii Kiristu ooni kaqa oho quba sama nime ingonaisuqa nakake oho qesa ingonaitare. ");
INSERT INTO ghs_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Hiiremi temui noke qamuni hiireta, Ae, nii baatake boobiqi bamu Ohongaho attike eetaqu? Abirai nakama gama heme eraho ttaiqani. ");
INSERT INTO ghs_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nakamae pasena eetetaho ipi nakaho irita taate oonihe abirai kahosaamani. ");
INSERT INTO ghs_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Hiireqi noi Dzesuke hee, Maqa nii pobi niimeta peiteqanoke nahoke qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Hiiremi Dzesu noke hee, Oore niima nakamae poiqa Ohongaho dzoo qidzata qeemare boobi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Qate oi tuerebe koroko naatemi haba gama qupi sooroqi tuuma ttiri kirokota dzadza eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Oi eteke dzasidzai sirihami biiriho ttoba hahari asuasu oi bisata piisisi eetemi idze, poro ttangaho suruhoi paana naateta! ");
INSERT INTO ghs_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Eetemi Dzesui sokata minake eeteqi hiireta, Mai name, gisi nameke niiho botota ao moote. Oke hiiremi noho sumasa biranatemi baateta. ");
INSERT INTO ghs_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Quba oke qaa sooparai gama moo soubireqi Ohongaho dzapa qusubaiteqi hiireta, Meenipamu abiraio saasari qidzaniqi hiireta, ");
INSERT INTO ghs_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Oi keke bahe, abi qesa samane ota ttutturate quba attinoma oke gama mooqi pairuru eete sama nokome iga hiire tuumata. ");
INSERT INTO ghs_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Qate paimane ma qesamane Garirea habana Dzesu gainene eete baata nokoi dzasa eete sererahuke qooro oke gama mooqota. ");
INSERT INTO ghs_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Oonita Dzesu baatemi Dzuta abiho sinasina tupu minarahota tee noi abi rike ma pobi, dzapa noho Dzosepe, noi baata. ");
INSERT INTO ghs_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Oonihe saunabake sinasina tupui Dzesuho obera hiiretake noi te qaupuitara. Bamu. Noi Dzuta abiho nagapa Arimatteaho nena ooqi Ohongaho pobi biranatarotaho beebe oota. ");
INSERT INTO ghs_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Abi oi Piratoho torota baaqi Dzesuho kebake aimareiqi hiiremi nota isanateta. ");
INSERT INTO ghs_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Oho quba qeemaqi kebake ai qurate ttoba khabanomama saama eete qegorota. Qegoroqi nomaeho oma naga kaibeteta oi agiagike oomi keba oke oho nakuta mootota. ");
INSERT INTO ghs_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Oi ete biiremi aoke dzuma mina oho boodza mee naatarotaho qubake nokoi ao hairiamake oho roiroi eetota. ");
INSERT INTO ghs_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Oonita Dzesuho gainene paimane qesaqesa Garireana baata nokoi qeemaqi moohimi noho kebake oonomake aima nakuta mootota. ");
INSERT INTO ghs_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Oke mooqi nokomae burisi eete oho bibi ma quba uranoma qesaqesa oke roibetare hiire nagapata peiteta. Oonihe peitemi ete bidzabidzata dzuma tatanga ao sohohimi nokoi oke qusubaiteqi bodza oho nakuta te baura oke hesatara. ");
INSERT INTO ghs_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Oonihe dzuma mina oi gama bamu naatemi iihai dzuridzarita paimane nokoi ura moromoroho isaki oke aima baata. ");
INSERT INTO ghs_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Baaqi moohimi oma sarara asuasu naga kura biirota oke apei ao aima burisi eetemi papate oota? ");
INSERT INTO ghs_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Papate oomi noko nakuta qeemaqi moohimi Dzesu Sooparaho kebai te ota oorara. ");
INSERT INTO ghs_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Oonita qupa nokohoi uhubaama naatemi idze, abi eseri sasa khabanoma hihihinomai sigita qoorota. ");
INSERT INTO ghs_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Qooro oomi paimanei ququimaqi pomai kotoromi nopoi hee, Ikaqi hiireqi nesetuta eehahaho qirike eesubi? Noi teqaha erata ooraidzara. ");
INSERT INTO ghs_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Noke Ohonga ao tukutomi biranate tuume. Oho nooke noi Garirea habata nike pobi hiiremi nookatanita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Noi totoho erake eete hiireta, Abiho Isaki anake abi kahosanomaho botota mootomake anake hapahapanaitakoi. Oonita qupi tapari naatemi ana paha qoridzakoi ooiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Oonita abi nopoi oke hiiremi totoho oke paimane ango qupadzomata. ");
INSERT INTO ghs_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Oke qupadzomaqi noko burisi eete nesetu oke papate tuumaqi tumakhameto erebeni ma kara nokoho torota oho pobi hiire paanaiteta. ");
INSERT INTO ghs_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Oonihe baaqi qaru abi erebeni oke pobi hiireta, paimane oho dzapaio Maria Magattaraho nena ma Dzoana ma Maria Dzakopoho pai ma paimane qesa paha. ");
INSERT INTO ghs_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Noko oho pobi hiire rerengi eetemi qaru abi nokoi nookami noo gattagattaho isaki naateta oho qubake nokoho qupa te rikeqomara. ");
INSERT INTO ghs_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","(Oi bamu) ");
INSERT INTO ghs_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Qate bodza ooqata tumakhameto nokohota eseri nagapa Emausi ota tuumareiqi teteta tuumota. Oonihe oi haba khara bahe tu haubaho isaki. ");
INSERT INTO ghs_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Oonita nopoi tuumoqi quba bamenoma dzumata biranateta oho noo ma pobike hiirota. ");
INSERT INTO ghs_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Hiiromi Dzesu nomae qeemaqi nopoma noko teena naate tuumota. ");
INSERT INTO ghs_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Oonihe nopoho nese ikanomake eete qupi sooromi moo pobitaama naateta? ");
INSERT INTO ghs_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Oho quba Dzesui nopoke hee, nipe soosomaqi noo bamenoma apeke qesa pobipobi hiirorai? Hiiremi bame nopoke bahebiremi burisi eete noke qeraqera eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Eeteqi tee, dzapa noho Keropa, (Arapeo) noi Dzesuke hee, Maa nii haba mainaho abi oho quba Dzerusaremuna quba bamenoma biranate oho pobi nii nookaamani mae? ");
INSERT INTO ghs_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Hiiremi noi hee, Noo ape ooni? Hiimi nopoi hee, Qateqa, abi tee dzapa noho Dzesu, Nadzaretteho nena, noi too abiho isakita Ohongaho penga ma abi minaraho neseta baura qidza bamenoma samaneke eete qaata. ");
INSERT INTO ghs_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Oonihe dzube abi mimi ma Dzuta abiho bosaqobaqoba nokoi noke karabeteqi raaba abiho sooparaho toro mootomi noke baataho pobi hiireqi noke hapahapanomaiteta. ");
INSERT INTO ghs_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Oonihe nanai hee, Noi Dzuta abi naanake raaba abiho botota ingonaitareiqi hiire ootahe noi baatemi ao qupi tapari naate oorai (oi baata tatanga). ");
INSERT INTO ghs_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Qate paimane nanahota qesai nanake sahasaha moiteqi hee, Nanai saunaba dzuridzarita qori noho nesetuta tuume. ");
INSERT INTO ghs_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Tuumaqi ota biranate keba nohoke saridzaama naatehe angeroho birabirake moohimi angeroi nanake hee, Noi eehaha naate ooraiqi hiireta. Oonita paimane nokoi hairiamake nana pobi hiiremi nooke. ");
INSERT INTO ghs_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nookaqi qesama nanai ao nesetuta qeemaqi paimane hiiroriho isakike moohimi noho keba ota oorara. ");
INSERT INTO ghs_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","27","Oke nopo hiimi Dzesui Moseho noo ma too abiho noo ika ma ikata noomaeke hesatota oke tumakhameto nopoho quba gama rerengi eete paanaite soubireta. Noi hee, Obera abi nike! Khooba apeho qubake too abi nokoi oho noo samaneke hiire qeetemi nikeho qupa asuasu naatemi nookaama naatorai? Kiristui isanate bosata heme mina saridzeqake dzapa pobi nometa peitaridzoni. Oke too abi noko hiireqi qeeteta. ");
INSERT INTO ghs_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Oke hiire qaramuti nokoi nagapa Emausiho kosoramuta biranateta. Biranate Dzesui paha nagapa mainata tuumaquho tomidza naatemi nopoi qaanateta. ");
INSERT INTO ghs_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Hee, Maqa, ao sure moote oonita nii isanate nakaho nagata peitare, oke hiireqi tototo hiireta. Hiiremi noi nopoma gama peiteta. ");
INSERT INTO ghs_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Peiteqi noko tirere eete qidzanatemi heeba nokoho dzagata mootomi Dzesui dzobadzoba oke aima agoago eete eseqotoqi nopoke moiteta. ");
INSERT INTO ghs_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Moitapihimi nopoi noho boto (mamaka) moo roqobeteqi noke gesina naateta. Oonihe gesina naasumi noi aoke nopoho neseta dzaeteta. ");
INSERT INTO ghs_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Oonita noi dzaetemi nopoi qesa qeraqera eete hiireta, Idze, teteta noi nakake bapotopotoqi sinabidza oke rerengi eesuhimi nakaho qupata ao dzadzadza eete! ");
INSERT INTO ghs_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Oho subesube hiireqi nopoi ao qoro burisi eete Dzerusaremuta tuumaqi qupibake qesamane rebeni ma kara nokoke ttuttuiteqi Keropai isere hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Hee, Meenipamuke Soopara napahoi qoridze eehahake oorai. Noi Siimo Peetoroma nakaho toro biranatemi etebake moori! ");
INSERT INTO ghs_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Hiireqi Dzesui ikanomake eete dzobadzobake eseqotapihimi nopoi qupadzomata oho pomake gama noko pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Oonihe nopoi oho pobi hiimi Dzesu noomae nokoho bisata qooroqi dzoobe hiireta. ");
INSERT INTO ghs_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Hiirmi noko noke mooqi qesai hee, Gisi ooniqi hiireqi atti sakabare eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Eetemi noi noko pobi hiireta, Nike naane quba ququimaqi iiha ma dzoobidza samaneke eete? ");
INSERT INTO ghs_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Gisiho gotta ma hidzoba ooraamanihe nike anaho oko ma boto hesateqa moomi anaio mee ma gama iso keke oorai. ");
INSERT INTO ghs_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","(Oi bamu) ");
INSERT INTO ghs_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Oke hiiremi totaqita nokoho ttidza qidzanatetahe paha totaqita atti sama eetota. Oonita noi nokoke hee, Nikehota heeba teei oorai mae? ");
INSERT INTO ghs_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Hiiremi nokoi sekana ngoru qetta teeke no moiteta. ");
INSERT INTO ghs_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Moitemi noi aimaqi nokoho pengata muunata. ");
INSERT INTO ghs_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Muuna qaasuqi noi hiireta, Dzairamane, Moseho noo ma Tabitiho Samu oi too abiho noo ma gama teena naate naho bauraho qamodzamodza hiiremi qeete qaata. Noo oke ana nikema napamae qaata bodzata hiireqi hee, Noo oi gama naho neta meenoma naataridzoniqi hiire qaata. ");
INSERT INTO ghs_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Hiireqi nokoke pobitemi nokoho qupa uhubami qetaqeta oonomaho khooba oke nokoi gattiqa qupadzomata. ");
INSERT INTO ghs_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Oho qubake noi ipibireqi noko bapotopotoqi hiireta, Anaio Kiristunipamu oonita ana bosata heme ma bame samane saridze baateta. Baateqi anai ao qupi taparike baata neta ooriti qoridze oorai oho tete paha teei te ooraidzara. ");
INSERT INTO ghs_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Oonihe poike naho dzapa pobi biranatemi nike Dzerusaremuta sohoroqa naho dzapa quba eeteqi abi tupu ma noo maina painata sinabidza hiire tuumami abi qupa burisi eetemi kahosake akobetakoi. Oke keke eete tuuma qaamake haba gegebetakoi. ");
INSERT INTO ghs_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Qate apenei oho baura qere biidzaqu bahe nike oioni. ");
INSERT INTO ghs_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Oonihe nike beedzae apema baura eetaqu bahe Mai nahoi Sumasa dzoobiremi baaqa nike beedzaenomaitaquho naru hiiremi oorai. Oho qubake nike nagapa qiba erata oho beebe eetoma meenoma naatare. ");
INSERT INTO ghs_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Oke hiire qaasuqi Dzesui noko dzeimaqi tupidza qeeho nagapa Bettania ota biranate boto nome dzoobireqi nokoke agoago eeteta. ");
INSERT INTO ghs_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Eeteqi noi nokoho neseta peite dzaeteta. ");
INSERT INTO ghs_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Dzaetemi nokoi qupa qidzaqidza minanipamuke eete burisi eete Dzerusaremuta biranateta. ");
INSERT INTO ghs_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Biranate nokoi qupi samaneke Ohongaho biirita ooqi noho hasama gegema hiirota. (Poiqa nike Aposoro Qaru Abita takomaqa isere ipibire isaitare.) Dzoobe Mina! Ttotta Ruka ");
INSERT INTO ghs_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Dzoobe Dzairamane: Khoobanipamuta too noo teei qaata noio Ohongake tuuhoro qaata. ");
INSERT INTO ghs_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","3","Ma too noo oi Ohongaho isakinipamu ooqi noi khoobanipamuta Ohongama nopo qesa dzaga boboto qaata. Noomae hiiremi quba minarai biranateta. Oonihe biranatetaho neta quba teei teqaha noomae biranatara, baamu, ");
INSERT INTO ghs_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","5","Noio qaraqaraho khooba oonita qaraqara oi abi minarake baiburoqi qupi ma khoukhau ma basesa nokohoke suqobire baaorai. ");
INSERT INTO ghs_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Qate abi tee, dzapa noho Dzohane, noke Ohonga dzoobiremi noi dzadza oho isere abiho toro mootomi noko Ohongake nooka hisi eetarota. ");
INSERT INTO ghs_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Oi Dzohane te oho dzadza ooraranihe noi dzadza maikhataho isere mootareiqi baata. ");
INSERT INTO ghs_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Oonita dzadzaho maikhata noomae ttokata biranateqi abi gama susupu baiburorai. ");
INSERT INTO ghs_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Noi hiiremi ttoka ma quba minarai biranatemi noi oho bisata oota oonihe ttokaho abi ikake eeteqi te noke gesina naatara? ");
INSERT INTO ghs_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Noi qubatu nomeho bisata biranatemi qesamane nohoi noke raraku biidzaama naatetahe, basesa eeteta. ");
INSERT INTO ghs_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Oonihe oberaqai noke raraku biireqi noho dzapata atimami noi nokoke beedzaenomaitemi Ohongaho khameto naatorai. ");
INSERT INTO ghs_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Noko te abiho ttarita biranatara, te abiho dza quba biranataranihe Ohongai dza nometa nokoke dzoomami oorai. ");
INSERT INTO ghs_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Oonita Ohongaho too noo oi abiho sama aimaqi napaho bisata habese qaami napai dzapa pobi nohoke moomi noi baruna heena ma noi meenomanipamu. Oonihe mai noi khata teena nomeho dzapa pobi minaitoraiho isakita noi qaata. ");
INSERT INTO ghs_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nohoke Dzohane sobasobai hiireqi hiireta, Anai bosata hee, Teei naho tumena baaqorai noi naho bosa qobaqobani. Oi ana biranataamake qaami noi agoba baa qaabi. Oonita abi oioniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Oonita abi oonomaho iisuta napai gama ari ma mosu saridzorai. ");
INSERT INTO ghs_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Oi hu nooi Moseho neta biranateta oonihe, baruna heena ma quba mee oio Dzesu Kiristuho nena biranatorai. ");
INSERT INTO ghs_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Oi abi Ohongaho mee mooraamanipamu oonihe Ohonga khata teena Maiho dzagaqata agoba oorai noi noomae Ohongaho khooba paanaitetai paanaitorai. ");
INSERT INTO ghs_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Qate Dzerusaremuta Dzuta abi mimi nokoi dzube abi ma Rebi abi qesa dzoobiremi noko Dzohane sobasobaho toro biranate toronaiteqi hiireta, Nii ape oni? Hiiremi noi isere mootoqi te dzaheitaranihe paanaiteqi hiireta, Anai te Kiristu Ohongaho Soopara abi oonidzara. ");
INSERT INTO ghs_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Oiqi hiiremi noko hee, Oonita nii Eria ooni mae ape? Hiiremi noi hee, Eo bamu. ");
INSERT INTO ghs_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Hiiremi noko hee, Too abi baabakoiqi Mosei hiireta oi nii oni? ");
INSERT INTO ghs_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Hiiremi noi paha bai hiireta. Bai hiiremi noko noke hee, Qesai nanake dzoobiremi baaqi oorai noo apeke nana noko paha pobi hiibaqu? ");
INSERT INTO ghs_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","24","Oho quba nana niike hee, Nii ape oniqi hiire, Nii sama niimeho ikaqi hiireo? Hiiremi noi erake hiireta, Totoho teei haba habanata sokateqi hee, Ohongai baahubita tete nikeme pobitareiqi Dzesea hiiretanita anai oho isaki oni. ");
INSERT INTO ghs_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Hiiremi noko Pariseoho nena ooqi tototo hiireqi hee, Nii Kiristu oonidzarani Dzesea oonidzarani. Too abi oonidzaranita nane quba nii abi obama soororai? ");
INSERT INTO ghs_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","28","Oiqi hiireta oi teeho bahe, Dzohanei Dzotani oba qee ne Bettania nagapata abi obama sooromi ota oho noo biranateta. Hiiremi Dzohane nokoke hee, Oore anai abi obama soororaihe, nikeho bisata teei oorai noho khoobake nike ruumeni. Noi naho tumena baaqorami noho isaki nahoke suqobirorai. Anai abi oho oko sasa eka saqoba quba isanataama. ");
INSERT INTO ghs_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Qate iihai mootomi Dzohane moomi Dzesui noho toro baahumi noi qesamane nomeke hee, moorare. Ohongaho kiridza qeeremi ttoka abiho kahosa aima baamuitaquho Hoo Dzooba erani. ");
INSERT INTO ghs_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Abi erahoke anai hee, Naho tumena abi teei baaqorai noi naho bosa qobaqobaniqi hiireta oi ana biranataamake qaami noi agobake baa qaabi. ");
INSERT INTO ghs_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ma ana te noke oho isakita gesina naate qaarara oonihe noke Isirae abiho quba paanaitareiqi ana abi obaqama soororai. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Qate Dzohane noi paha isere mootoqi hiireta, Ana moomi Sumasai qusubibiho isaki qusu neta qurateqi noho irita dzuubata. ");
INSERT INTO ghs_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Meeke ana te bosata noke oho isakita gesina naate qaararanihe, anai abi obama soobareiqi Ohongai ana dzoobiremi baata, teena noi paha anake hee, Nii moomi Sumasai qurateqa teeho irita biranate qaaraqu noio abike Qaheuba Sumasama soobakoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Oonita noi Ohongaho khata oke ana nese namema moo pobiteqi oho isere moote. Oiqi Dzohane hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Qate iihai mootomi Dzohane sobasoba noi tumakhameto eseri nomema oomi Dzesui girodzohimi noi hee, ");
INSERT INTO ghs_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ohongai napaho Hoo Dzooba roibetoraita noke mooro! ");
INSERT INTO ghs_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Hiiremi noho tumakhameto eseri oke nookaqi ao Dzesuke iihata. ");
INSERT INTO ghs_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iihami Dzesu burisi eete nopo mooqi hiireta, Nipe naane qiri? Hiiremi nopo hee, Banaita, (oonihe nokoho totohoi Rabi) nii ika neta meeqorai? Hiiremi no hee, Baaqu moorare. ");
INSERT INTO ghs_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Oonita oi tteni kiroko naatemi nopo tuumaqi noho teka mooqi noma nokoi gamaqa oota. ");
INSERT INTO ghs_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Oi ao nopoi Dzohaneho noo nookaqi Dzesuke iihata. Oonita nopohota tee, dzapa noho Attereo, Siimo Peetoroho noma, ");
INSERT INTO ghs_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","noi ao tuumaqi Siimo nane gotta nomeke saridzeqi hee, Nookare. Nanai aoke Kiristu (oonihe Heboro totohoio Mesia) noke saridzemi oorai. ");
INSERT INTO ghs_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Hiireqi noi noke dzeima Dzesuho toro biranateta. Biranatemi Dzesu noke mooqi hiireta, Nii Siimo, Dzohane temuho khata. Oonihe dzapa niihoke Peetoro ooniqi hiibakoi (nokoho totohoi Kepa oi Podza). ");
INSERT INTO ghs_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Iihai mootomi Dzesui Garirea habata tuumare hiireqi Piripi saridzeqi hee, Nii ana iiha qaarare oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","45","Qate Piripi noi Attereo ma Peetoro ma nokoi gama Besaita nagapaho nena ooqi noi tuumaqi Nattanae saridze noke hee, Maaqa, Mose ma too abi qesai teeho noo qeeteta abi oke nanai saridzemi oorai. Noi Nadzarette nagapa nena Dzosepeho khata Dzesu oni. ");
INSERT INTO ghs_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Hiiremi Nattanae misi teteqi hee, Quba qidza apei Nadzarette nagapata biranataqu? Hiiremi Piripi hee, Seke baa mooro. ");
INSERT INTO ghs_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Hiireqi nopo baahumi Dzesu Nattanae mooqi nohoke hee, Moorare. ");
INSERT INTO ghs_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Isirae abi dzadzanoma, noonoma erani. Hiiremi Nattanae roqobeteqi hee, Ika neta nii anake gesina naateqi oke hiire? Hiiremi Dzesu noke hee, Eo, Piripi niiho kira hiibaamake oomi ana ao moohimi nii ee dzunaho pesuta oori. ");
INSERT INTO ghs_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Hiiremi Nattanae hiireta, Banaita name, nii Ohongaho khata Isiraeho abi qibanipamu. ");
INSERT INTO ghs_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Hiiremi Dzesu hiireta, Anai hee, Nii ee dzunaho pesuta ooriqi hiiremi ooqaho quba nii nooka hisi eete mae? ");
INSERT INTO ghs_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nookao, Abiho Isaki anai quba teema teeke qupadzohima qusu papatemi oho qaru samanei naho irita biranatemi nike moorakoi. ");
INSERT INTO ghs_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Qate iihai temu naatemi Garirea habaho nagapa Kanata abi ma atapa qesa naatemi Dzesuho pai gotta ota oota. Oonita nokoi Dzesu, tumakhameto nohoma gama ota dzeimami biranateta. ");
INSERT INTO ghs_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Oonita noko patta ma oba muuhimi idze nokoho bai oba ao bamu naateta. Bamu naatemi Dzesuho pai noke hee, Bai oba nokohoi ao bamu naate. ");
INSERT INTO ghs_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Hiiremi Dzesu noke hee, Pai name, naho baura bodza biranataamake nii ikaqi hiireqi anake oho sese hiire? ");
INSERT INTO ghs_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Hiiremi pai nohoi burisi eete kokora abi nokoke hee, Khata hiibaqu oke qusubaitare oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","7","Qate Dzuta abi sapunge moitorai teteho quba omaho mangi taramuho isaki sikisi ota oomi Dzesu kokora abike hee, Oba keba giimaqa ota uquma hee baabare. Oiqi hiiremi noko uqumami mangi ao hee baami noi hee, ");
INSERT INTO ghs_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Poiqa giima ttihu barabara abi moitare. Hiiremi noko moiteta. ");
INSERT INTO ghs_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Oonihe obai ao baiho isaki naate oomi ttihu abi oke eeteimaqi te oho khooba qupadzomara, oonihe kokora abi giimata nokoi Dzesuho khooba ooqata qupadzomata. ");
INSERT INTO ghs_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Oonita ttihu abi noi ata naateta abiho kira hiireqi hiireta, Abi minarai bai oba mekenoma oke bosata abi moitemi muuna qura eetemi mekeamake ipita moitorai. Oonihe nii ikanomake eete mekenomanipamu erake qaanatoriti ipiqata moite? Ooiqi hiiremi roqobeteta. ");
INSERT INTO ghs_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Oonomake eeteqi Dzesui Garirea habaho Kana nagapata sohoro obaoba eeteqi dzapa pobi nome paanaitemi tumakhameto nokoi noho torota atimata. ");
INSERT INTO ghs_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ipita Dzesui tumakhameto ma pai gotta ma nomamane nomema gama qurate Kapanao nagapata biranateqi bodza qesake (baura quba) oota. ");
INSERT INTO ghs_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Oonita Isirae abi ingonaitetaho dzuma dzamo naatemi Dzesui Dzerusaremuta peiteta. ");
INSERT INTO ghs_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Peiteqi noi moomi Ohongaho biirita pisinisi abi nokoi kiridza qeebaquho burimakau ma sipisipi ma qusubibi oke ttuma quba mootomi oota. Qate omaho maikhametoi haba maina painaho abiho ttuma habara mooto qaata nokoi qohare nokometa habese oota. ");
INSERT INTO ghs_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Oonita Dzesui ngibirama gabeho teeke tiibeteqi nokoke sipisipi ma barimakau ma gama susupu hotou biireqi oma maikhametoho qohare burisi eete oma nokohoke perebireta. ");
INSERT INTO ghs_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Oonihe qesai qusubibi ttuma quba mootota nokoke noi hee, Etoqa Mai nahoho nagake quruma naga tiibetaino. Oonita qubarake aima tuumare. ");
INSERT INTO ghs_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","18","Oiqi hiireta oi teeho bahe sinabidzata hee, O Ohonga, naga niihoho dzaodzaoi anake qeeremi qaite. Oke qeete oomi tumakhameto noho nokoi aoke Dzesuho khooba ota moo qupadzomata. Qate Dzesui pisinisi abi noko hotou biiremi Dzuta abi nokoi burisi eete noke qasa hiireta. Quba apeke nii nana banaitemi nana moo niiho baura erake mee hiibaqu? ");
INSERT INTO ghs_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Hiiremi Dzesu sama nomeke qupadzomaqi hee, Nike guhurake ngausa eetemake qupi tapariho nakuta oke ana paha ai qusubaitakoi. ");
INSERT INTO ghs_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Hiiremi Dzuta abi hee, Idze tii bodza 46 oho nakuta guhurake gooto baa qaimi nii qupi tapariho nakuta oke qusubaitaqu mae? ");
INSERT INTO ghs_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Oonihe noi sama nomeho qahura hiireqi oke guhuta mooto hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Oonita Dzesu ipita baata neta qoridze oomi noi bosata oho noo hiireta ma oho qetaqeta biranateta oke tumakhameto nokoi gama qupadzomami pobirateta. ");
INSERT INTO ghs_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Qate Ingonaiteta dzuma bodzata Dzesu Dzerusaremuta ooqi obaoba eetomi abi samane oke moo qupadzomaqi noho dzapata atimata. ");
INSERT INTO ghs_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Oonihe noi minaraho khooba qupadzomaqi te nokoma ipibidzara. ");
INSERT INTO ghs_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Oi abiho ikoiko ooraike noi gesinanipamu naate ooqi naane quba oho subesube totohoke nookarota? Baamu. ");
INSERT INTO ghs_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Qate Pariseohota tee, dzapa noho Nikotemo, noi sinasina tupu nokoho nena. ");
INSERT INTO ghs_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Oonita qupibake noi Dzesuho toro peite erake hiireta, Banaita name, nana qupadzomami Ohongai hiiremi nii nanake banaitare baata. Oi teeho bahe nii Ohongama ipibidzaama naatapuko nii obaoba eetoraiho isakita qidzoke eetarori. ");
INSERT INTO ghs_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Hiiremi Dzesui hee, Nookare, Khata usaqe biranataqu oqai keke abi teei Ohongaho pobi gesina naatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Oke ana baamu nii ikobetaqu. Hiiremi Nikotemo hee, Ikanomake eete abi agobai khata usaqeho isaki naataqu. Noi isanaate pai nomeho asita dzuubaqa paha biranataqu mae? ");
INSERT INTO ghs_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","Hiiremi Dzesu hee, Eehe, samaho neta biranatorai oio samaqaho pobi. Qate Sumasaho neta biranatorai oi Sumasaho pobi. Oonita akoakoma Sumasaho asita biranataqu oqai keke abi teei Ohongaho pobita dzuubakoi. Oke ana meeke hiire. ");
INSERT INTO ghs_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Anai hee, Nike dzomadzoma usaqeta biranatareiqi hiiremi eto roqobetaino. ");
INSERT INTO ghs_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Oi uta noomae toororai teteke qupadzomare. Nii oho husuqake nookoraihe ika neta baaorai ma tuumorai oke ruume. Oonita abi Sumasaho asita biranatorai nokoho naku dzebidzebi oke nii oho qesa ruumeni. ");
INSERT INTO ghs_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Hiiremi Nikotemoi hee, Oho tete ikanoma ooraimi nii oke hiire? ");
INSERT INTO ghs_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Hiiremi Dzesui hiireta, Idze, nii Isirae abiho banaita minanihe oho teteke ruume? Nookare. ");
INSERT INTO ghs_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Naka nesema mooraiho gesinata nakai hiirorai oi Ohongama nakai gesina naate oho isere mootorai. Oonihe ikanomake eete nike oho noo nookaama naatorai? ");
INSERT INTO ghs_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Oonita anai ttokahoke nike pobi hiiremi nookaama naataquko ikanomake eete ana nike qusuhoke pobi hiiremi nooka hiisi eetaqu? ");
INSERT INTO ghs_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ma paha apei qusuta peiteqa oho gesina naataqu bahe, abiho Isaki anai qusuho neta quratetai teena. ");
INSERT INTO ghs_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Mosei haba habanata dzoo gisigisi eehota goosoromi abi qidzanateta, oonita nokoi Abiho Isaki anake oho qesa goosoromake apenei anake nooka hisi eetaqu nokoi qaraqara tatanga saridzakoi. ");
INSERT INTO ghs_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Oi Ohongai ttoka abiho quba dzasa minanipamu eete khata teena nome ai mootomi apene noke nooka hisi eetaqui bamu dzaetaquhe, qaraqara tatanga saridzakoi. ");
INSERT INTO ghs_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Oi Ohongai khata nome dzoobiremi ttoka abike qomaqoma hiibare quratarani. Bamu. Ttoka abike qidzaita qubake anai baaqorai. ");
INSERT INTO ghs_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Oho quba teei ana nooka hisi eetemi bamu noke qomaqoma hiibaqu. Oonihe nooka hisi eetaama naatorai nokoke ao qomaqoma hiibaridzoni. Oi teeho bahe, nokoi basesa eete Ohongaho khata teenaqaho dzapata atimaama naatorai. ");
INSERT INTO ghs_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Oho kahosai erani. Dzadzai ao ttoka abi baiburoraihe, abiho khooba qanganita noko ikaqi hiireqi dzadza oho goottae eete qupiho dzake eetorai? ");
INSERT INTO ghs_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Oi qesai baura peranoma eeteqi eto oho khooba paana naatainoiqi hiireqi noko dzadzata qeemaama naate oke ibo eetorai. ");
INSERT INTO ghs_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Qate qesai meenomanita nokoi OKongaho beedzaeta baura qidza eete oke paanaitare hiireqi dzadzata qeemorai. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ipita Dzesui tumakhameto dzeimaqi Dzutea habaho qeba neta tuumaqi nokoma gama oora ma qaara eeteqi nokoi abike obama soorota. ");
INSERT INTO ghs_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Qate Dzohane sobasobaho maike Herote sutasutata mootaamake oota. Oonita Sarimu habaho nagapa gattiqa Aino oho samata obai isanatemi abi ota biranatemi Dzohane nokoke obama sooro qaata. ");
INSERT INTO ghs_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Oho quba Dzuta abi qesai ota baaqi Dzohaneho tumakhametoma qesa kurebeteqi akoako oho noo hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Hiireqi noko Dzohaneho toro baaqi oho qasa hiireta, Mai naname, Nii abi teema nipe Dzotani oba qee neta ooqi nii noho isere qidza mootota. Oonihe moorare. Poiqa abi quba mina noho toro biranatemi noi ikanoma eete nii eetoraiho isakita noko obama soorarai? ");
INSERT INTO ghs_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Hiiremi Dzohane hee, Teei sepeke baura eetaquho isaki baamuta, Ohonga hiiroraiho isakita eetorai. Oi ana bosata hiireqi hee, ");
INSERT INTO ghs_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ana naamae Kiristu oonidzara. Oonihe, Ohonga ana dzoobiremi anai Kiristuho roiroi bosa baorai. Oiqi hiiremi nike naho noo nookatanita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Oi erake eete oorai. Ata pobi oi teeho pobi bahe apu noomaeho pobi keke. Oonita teei ata pobi oke dzeima apuho botota mootoqa bamu apuke ttire eetaquhe, noho noo totoho nookaqi qaki eetakoi. ");
INSERT INTO ghs_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Oonita anai oho isakita nikeke Dzesuho botota mootoqi qaki minake eete. Kiristuho dzapai peitakoini, nahoi quratakoi. ");
INSERT INTO ghs_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Noi pei neta baaorai noio minaraho qibanihe, ttokaho nena ana ttokaho isaki ooqi hiirorai. Qate qusuho nena noi minara ma napaho qibanita noi moo nooka qaataho isereke no mootorai. ");
INSERT INTO ghs_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Oonita isere oke abi naane quba nookaama naataqu? ");
INSERT INTO ghs_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","Oi Ohonga noke dzoobiremi noi Ohongaqaho noo hiiroraita teei noho isere nooka qusubaiteqa Ohongake meenomaho isakita qaupuitakoi. ");
INSERT INTO ghs_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Oonihe Onongai khata nomeho dza minake eeteqi quba minara noho botota mootoqi Sumasake moitemi meupunoma naatorai. ");
INSERT INTO ghs_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Oonita teei Ohongaho Khata nooka hisi eeteqi ao qaraqara tatanga mai eesubi. Qate teei Khata nooka hisi eetaama naataquko noi bamu qaraqara oke mooraquhe, Ohongaho taanga noho irita oorakoi. ");
INSERT INTO ghs_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Dzesui tumakhameto samanenipamuke obama soorota. Oi Dzesui te noomae abi obama soobaranihe, tumakhameto nohoi oke eeteta. Oonita nokoho dzare Dzohanehoke riitemi oho isere Pariseoho toro hiiremi Dzesu oho qesa pobi nookata. Pobi nookaqi Dzutea haba oke qaateqi paha Garirea habata tuumata. ");
INSERT INTO ghs_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Oonihe noi tuumaqi Samaria habata bosa biranate, oho nagapa Sikhata biranateta. ");
INSERT INTO ghs_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Qate qgobanipamuke Dzakopoi khata nome Dzosepeke ttoka moiteta oho robeta oota. ");
INSERT INTO ghs_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ma paha Dzakopoho oba kose mina ota oota. Oomi Dzesui haba kharata baaoqi ete bisata qidzanatare hiireqi oba kose oho samata habeseta. ");
INSERT INTO ghs_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Qate noho tumakhameto nagapa Sikhata patta ttuma eetare tuusumi Samariaho atapa teei oba giimare baata. Baami Dzesu noke hee, Oba teeke ana moitemi muunareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Oonihe Dzuta abi ma Samaria abi te qesa dzaira eete qaarara. Oho quba Dzesu oke hiiremi atapa oi hee, Nii Dzuta habaho abi oonita ikanomake eete nii Samariaho atapa anake oba quba qasa hiire? ");
INSERT INTO ghs_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Oonihe Dzesu noke pobi hiireta, Nookare. Ohongai abike qonotoraike nii ruume. Ma ana nii oba quba qasa hiire naho khoobake nii ruume. Oke nii qupadzomapuko nii ao anake qasa hiiremi ana nii oba heuheunoma moitemi isanatarori. ");
INSERT INTO ghs_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Hiiremi noi hee, Mai name, kose oi khara ma niiho mangi bamu oonita nii ikanoma eete ana oba heuheunoma moitaqu? ");
INSERT INTO ghs_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nookare Dzakopo uumi nanaho noi noomae khata ma khameto, hoo ma haa nomema gama erata oba giima qaaqi oke nana moitemi oorai. Oonita niiho dzapa mina apei nohoke riitaqu? ");
INSERT INTO ghs_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Hiiremi Dzesui erake hiireta, Teei oba erake muunomi, ");
INSERT INTO ghs_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","15","isanataama naatemi paha muuna quba baatakoi. Qate oba anai abi moitemi muunaqa bamu paha oba quba baataqu, baamunipamu. Anai abi moitemi muunaqu oba oi noho nakuta heuheu eete ttuunoma naate agoba qaraqara qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Hiiremi atapai hee, Mai name, oba oke nii ana moitemake anai bamu paha oba quba baate erata giimoraqu. ");
INSERT INTO ghs_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Hiiremi Dzesu hee, Tuuma apu niime dzeima baabare. Hiiremi atapai hee, Anai apu bamu. ");
INSERT INTO ghs_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Hiiremi Dzesu hee, Oke nii meeke hee, Naho apu bamuiqi hiire. Oi nii ao apu boto teena oke nii naate gaubire qaariti poike paha teema nipe oorai noi niiho apu oonidzaranita oke nii meeke hiire. ");
INSERT INTO ghs_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Hiiremi noi hee, Mai name ana nookami nii too abiho isaki. ");
INSERT INTO ghs_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Oonihe Dzuta abima nikei hee, Dzerusaremuta naa ma pupu eetaridzoho qopaniqi hiiroraini nanaho uimane neimane Garidze tora qeerata naa ma pupu eete qaatake nana eetorai. ");
INSERT INTO ghs_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","22","Hiiremi Dzesu noke hee, Atapa nii naho noo nookare. Nike naa ma pupu eetoraike nike ruume. Qate ingonaho tete oi Dzuta abi nanaho neta biranatoraita nana naa ma pupu eetoraike nana gesina. Oonihe tora erani mae Dzerusaremuta abi Ohongaho toro naa ma pupu eetorai bodza oi ao bamu naatake boobi. ");
INSERT INTO ghs_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Oi Ohonga mai dza eetemi abi meenomai noho torota naa ma pupu eetaqu oke noko meenipamuke gutu boto Kharaho isakita naa ma pupu eetorakoi. Eetorakoi paha ao eetorai. ");
INSERT INTO ghs_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Oi Ohongai gutu boto kharanita abi noho torota naa ma pupu eetaqu oke noko meenipamuke gutu boto kharaho isakita noma qesa dzaira eetaridzoni. ");
INSERT INTO ghs_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Hiiremi atapa oi hee, Ana qupadzomami Mesia baabakoi. Oonihe noke paha Kiristu ooniqi hiirorai noi baaqake napake quba minara hiire pobitakoi. ");
INSERT INTO ghs_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Hiiremi Dzesu hee, Ana nii pobi hiibi anaio Kiristu oni. ");
INSERT INTO ghs_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Oke Dzesui hiihimi tumakhameto nohoi baaqi moomi noi atapama qesa noo hiiremi noko roqobeteta. Oonihe noko te atapake hee, Nii quba teeho quba hiireni mae? ");
INSERT INTO ghs_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ma noko oho qesa te Dzesuke hee, Nii ikanomake eete atapa erama qesa noo hiire oiqi hiibara. Qate atapa oi oba mangi nome qaate hairiamake nagapa tuumaqi oho abi pobi hiireqi hee, ");
INSERT INTO ghs_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Idze, anai oora ma qaara eete baa qaibi oke noi gama hiire paanaite soubire. Oonita nike baaqa moomi noi Kiristu ooni kaqa. ");
INSERT INTO ghs_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Hiireqi noko nagapa qaate noke moora quba tuumata. ");
INSERT INTO ghs_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tuumomi Dzesuho tumakhameto noke hee, Banaita, nii patta muunare. ");
INSERT INTO ghs_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Hiiremi noi hee, Naho torona patta oorai oke nike ruume. ");
INSERT INTO ghs_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Hiiremi noko qesa pobipobi hiireqi hee, Teei ao patta noke moiteni mae? ");
INSERT INTO ghs_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Hiiremi Dzesui hee, Eehe, naho patta oi teeho bahe Ononga ana dzoobiremi baaqi noho baura eete soubidzaqu oio naho pattani. ");
INSERT INTO ghs_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nookare. Nike hee, Oo dzasidza tapari naatemake uitti oi mee eetakoiqi hiirorai kaqa. Oonihe, nike nese dzoobireqa moomi aoke dzoo teei oi baa naatemi rumutaquho isaki naate. ");
INSERT INTO ghs_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","37","Oionita rumutaqu abi noi mee oke rumuto qaraqara tatangaho iisunaiteqa oho ipi ma ari saridzakoi oonihe noi bababa abima nopo esese ttaike oho ttidza qidzaqidza saridzakoi. Oke eetemi noo totoho erai meenoma naatakoi, oi hee, Teei dzabakoini teei rumutakoi. ");
INSERT INTO ghs_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Oi qesai oho dzoo ma baura eete qaimi ana nike dzoobiremi nike oho baura eetaamake qaariti poiqa nokohota ipibireqa rumutakoi ooiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Obetemi atapa oi Samaria nagapa abike hee, Ana oora ma qaara name eete qaabi oke abi oi ana pobi hiire soubire. Oiqi hiiremi nokohota qesai nookaqi hisi eeteta. ");
INSERT INTO ghs_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Oonita Samaria abi nokoi baaqi Dzesu nokoma oorareiqi hiiremi noi nokoma qupi eserike oota. ");
INSERT INTO ghs_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Oomi abi qesa samanei noomaeho toota nookaqi hisi eeteqi, atapa oke eraiqi hiireta, ");
INSERT INTO ghs_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Oo nii bosata hiiremi qesama nanai hou eetetanihe, poiqa nanai toma nanamema noho noo nookaqi hisi eete. Oi nana moomi abi erai ttoka abi napa minaraho ingona mai, oioniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Obetemi qupi eseri bamu naatemi Dzesu nagapa oke qaateqi Garireaho habata biranateta. Oonihe noi mooqi hee, ");
INSERT INTO ghs_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ohongaho too abi teei nagapa khooba nometa oomi nagapa abi teqaha noho dzapa qusubaitoraidzara, bamu. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Oonita Dzesu Garirea habata biranatemi nagapa abi noho hasahasa hiireta. Oi teeho quba bahe nokoi bosata Dzuma mina eetareiqi Dzerusaremuta peite moomi noi ota obaoba paanaitota. ");
INSERT INTO ghs_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Oonita noi bosata Garirea habaho nagapa Kana ota oba korabetemi baiho isaki naateta noi ota paha biranatemi gamaniho abi teei oota. Abi oi qaaho pobipobi. Qate noho khata heme aimaqi Kapanao nagapata ooqi baataquho isaki naateta. ");
INSERT INTO ghs_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Oho quba Dzesui Dzutea haba qaate Garirea habata biranatetaho pobike mai nookaqi noi Dzesuho torota biranateqi hee, Nii isanate naho khata qidzaitaqu mae? ");
INSERT INTO ghs_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Hiiremi Dzesu noke hee, Oo abi nike abaoba ma quba nese agiagi samane mooraama naataquko, nooka hisi eetaama naataqu kaqa? ");
INSERT INTO ghs_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Hiiremi qaa pobipobi noi hee, Eo soopara name, naho khata eto baatainoho quba ao baabare. ");
INSERT INTO ghs_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Hiiremi Dzesu noke pobi hiireta, Mai nii nookare. Khata niihoi ao eehaha naasubita nii tuumare. Noo oke Dzesu hiiremi noi nooka qupadzomaqi tuumata. ");
INSERT INTO ghs_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tuumomi kokora abi noho baaqi hee, Maa aoke niiho khata eehaha naasubi. ");
INSERT INTO ghs_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Hiiremi noi bodza apeta khata asuratetaho qasa hiiremi nokoi hee, Aruku uani kirokota kebarateta. ");
INSERT INTO ghs_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Hiiremi noi qupadzomami Dzesu noke hee, Khata niihoi eehaha naasubiqi hiireta bodza iso keke naateta. Oho qubake noi oko ma boto tupu nomema gama Dzesu nooka hisi eeteta. ");
INSERT INTO ghs_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Oonita Dzesui Dzutea haba qaate Garirea habata biranateqi obaoba oke eetemi oio oho isere eseri naateta. ");
INSERT INTO ghs_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ipita Dzesui dzuma nokoho teeke eetare hiireqi Dzerusaremuta peiteta. ");
INSERT INTO ghs_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Qate Dzerusaremu nagapaho tete kura teeho dzapa sipisipiho pou oni. Oho saamaqata oba ttuu Rumerume, oho dzapa Heboro noota hee Bedzattaniqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Ma oho naga mina ma seu noho boto teenai oomi abi porobanoma samanei ota meeqota, oi nese khabanoma ma pone ma qosu ma kara noko meeqoqi obai poupa eetaquho beebe eete qaata. ");
INSERT INTO ghs_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Qate nokohota tee, tii bodza nohoi 38, noi pone naate ota meeta. ");
INSERT INTO ghs_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Obetemi Dzesu abi oke moomi pone naate oomi Dzesui noke qasa niireta, Nii qidzanatare dza eete mae? ");
INSERT INTO ghs_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Hiiremi abi pone hee, Eo oba poupa eetemi apei baaqa ana aima oba ttuuta mootaqu? Baamuta ana naamae qeehimi aoke teei ana riite oba suqomami anai bitta eeteqi sepeke oorai. ");
INSERT INTO ghs_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Hiiremi Dzesu erake hiireta, Nii ao qori qepe niime aima tuumare. ");
INSERT INTO ghs_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hiiremi bodza ooqata keke abi oi qidzanate qepe nome aimaqi qeema biranateta. ");
INSERT INTO ghs_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Oonihe oi dzuma bodza oomi, Dzuta abi qesai abi qidzanatetake mooqi hee, Dzuma qaganomanita nii eto qepe niime aima tuumaino. ");
INSERT INTO ghs_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","13","Oiqi hiiremi noi hee, Oonihe poiqanipamuke abi teei anake qidzaite. Noi hiiremi, ana qepe name aima tuusubi. Hiiremi noko hee, Abi ikanoma niike hee, Qepe niime aima tuumareiqi hiire? Hiiremi abi qidzanateta noi noo ipi hiibare ruume naateta. Oi teeho quba bahe, oba ttuta abi samane pui siiremi Dzesu ao sama nome dzukuromi noi te moorara. ");
INSERT INTO ghs_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Oonihe gattiqa ipita Dzesui abi oke Ohongaho biirita saridzeqi noke pobi hiireta, Moorare, niiho sama qidzanate. Oonihe eto ipita paha quba bamenomanipamu niiho toro biranatainoho quba kahosa niime oke potti biire qaarare. ");
INSERT INTO ghs_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Hiiremi abi oi tuumaqi Dzuta abiho maimane oho pobi hiireqi hee, Abi anake qidzaite oi Dzesu ooniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Oho quba Dzuta abi nokoi hee, Oonihe Dzesui quba oonoma dzumata eetorai oke hiireqi nokoi noke qomaqoma hiirota. ");
INSERT INTO ghs_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Hiiromi Dzesu erake hiireta, Mai nahoi baura eete qaabiqi nakamae eetorai. ");
INSERT INTO ghs_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Hiiremi Dzuta abi nokoi hee Idzii, nii dzumake rasakiitorai, ma paha oho heeta nii Ohongama idzoidzoniqi hiireqi noke hee, Mai name ooniqi hiirorainoma. Oke hiireqi noko noho gunu dzoomata. ");
INSERT INTO ghs_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Oho quba Dzesu nokoke eraiqi hiireta, Anai khata. Oonita ana naamae qupadzomaqi baura eetaquho tete bamu. Oonihe anai mai name moomi eetorai tete oioni. Mai eetorai teena oke anai eetorai. ");
INSERT INTO ghs_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Oi Ohonga mai noi naho dza mina eeteqi quba minara noomae eetorai oke noi ana banaite qaabihe paha baura bamenomanipamu qesa ana banaitemi nike oho mee moo roqobetakoi. ");
INSERT INTO ghs_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Oonita mai abike baata neta tukuto khakhoro biirorai oho isakita khata naamae ape ma apeke qupadzomaqu nokoke tukutakoi. ");
INSERT INTO ghs_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Paha Mai noomae abi batabidzaama. Batabidza baura oke noi gama naho botota mootomi oorai. ");
INSERT INTO ghs_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Oke eetemi abi samane Ohonga maiho dzapa qusubaitorai oho qesa khata anaho dzapa qusubaitaridzo. Oonita teei Khataho dzapa qusubaitaama naataquko noi Mai ana dzoobire baata dzapa nohoke midzata mootakoi. ");
INSERT INTO ghs_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nookare. Teei naho noo nookaqi mai ana dzoobiretake hisi eetaquko noke qomaqoma hiibaquho tete bamu. Ana hiiremi noi ao baata neta qoridze qaraqarata biranate oorai ma qaraqara tatanga oke mai eete qaarakoi. Oke ana meeke nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Oi baataho nena nokoi Ohongaho khata anaho totoho nookaqu nookahiqa noko eehaha naatakoi. Oho bodza biranatakoi oonihe ao poike biranahibi. Oke ana meeke nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Oi Ohonga mai noi qaraqaraho khooba. Oonita noi hiiremi ooraiho isakita anai oho qesa qaraqaraho khoobani. ");
INSERT INTO ghs_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Anai Abiho Isaki oonita Mai noi beedzae naho torota mootomi anai abi batabidzakoi. ");
INSERT INTO ghs_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Oonihe ana noo erake hiiremi eto roqobetanino. Oho bodzata abi nesetuuna oorai, nokoi gamaqa susupu naho totoho nookakoi. ");
INSERT INTO ghs_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Nookami qusuba baura qidza eete qaata nokoke ana tukutomi noko biranate qaraqarata oorakoi. Qate quba qanga eete qaata nokoke ana tukutomi noko biranatemi oho ipike ana quba bamenoma noko moitakoi. ");
INSERT INTO ghs_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Qate ana eetorai oke ana naqeke eetaamanihe, ana Maiho toota nookoraiho isakita batabiremi oi meeta keke tuumorai. Oi teeho quba bahe anai dza nameke qusubaiteqi eetoraidzaranihe, Mai ana dzoobiretaho dza qusubaite eetorai. ");
INSERT INTO ghs_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ana sama nameho isere nikeho toro mootapuke isanataama naatarori. ");
INSERT INTO ghs_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Oonihe, maina teei naho isere qidza mootomi oorai. Oi ape bahe Dzohane sobasoba, ma ana qupadzomami noho isere oi mee. ");
INSERT INTO ghs_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","35","Oonita nike ao Dzohane sobasobaho torota noo dzoobire qasa hiiremi noi naho isere qidza mootomi meenoma naateta. Nookare. Dzohane noi dzongi qaite koina dzoobiroraiho qesa naatemi nike bodza ooqata noho koina quba qaki ma naki eeteta. Oonihe anai abi oonomaho isere quba beebe eetaamanihe, nikeke ingonaita qubake ana oho noo hiire. ");
INSERT INTO ghs_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Qate naho mai ana baura moitemi ana eete soubidzaqu baura oi noomae naho khooba paanaiteqi Mai ana dzoobiretake qaupuitanipamuke eeteqi Dzohaneho isere gama qaupuitorai paha suqobirorai. ");
INSERT INTO ghs_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Paha Ohonga Mai ana dzoobireta noomae naho isere mootomi ooraihe, nike noho noo totoho nookaama ma noho isaki mooraama. Bamu. ");
INSERT INTO ghs_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mai ana dzoobiremi ana baqorai. Oonihe noho nooi nikeho qupata bamu naatemi nike anake nooka hisi eetaama naatorai. ");
INSERT INTO ghs_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nike sinabidza geeta qaraqara tatanga saridza quba qirike eetoraihe nookare. Gee oi gama naho khooba paanaitorai. ");
INSERT INTO ghs_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Oonita ikanomake eete nike ota isaiteqi naho torota qaraqara oke saridza quba baabaama naatorai? ");
INSERT INTO ghs_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Abi naho dzapa qusubaita qubake ana te baqoraidzara, bamu. ");
INSERT INTO ghs_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","43","Oonihe anai Ohonga Maiho dzapata baami nike te anake dzaira eetoraidzara. Ota ana moomi nike Ohongaho dzake eetaama. ");
INSERT INTO ghs_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Qate maina teei dzapa nometa baabaquko nike noke ao dzaira eetakoi. Oi nike qesaho dzapa qusubaitoraini qate nike Ohonga qusubaitemi noi oho quba nikeho hasa hiibaqu oho goottaeke nike eetorai. Oonita nike ikanomake eete nooka tani naataqu? ");
INSERT INTO ghs_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Qate anai Ohongaho pengata nike qomaqoma hiibakoiqi eto hiibaino. Nike teeho Dzapata atimorai oi Mose. Oonihe noomae nike qomaqoma hiirorai abi oioni. ");
INSERT INTO ghs_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Noi naho noo sohoro qeetetanita nike noho qetaqeta qusubaitapuke ao anake nooka hisi eetarori. ");
INSERT INTO ghs_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Oonihe nike noho qetaqeta qusubaitaama naatoraita ikanomake eete nike naho nooke qusubaitaqu? Baamunipamu. ");
INSERT INTO ghs_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ipita Dzesu haba oke qaateqi Garirea oba ttuu qee neta tuumata. Oba ttuu oho dzapa paha Tiberia. ");
INSERT INTO ghs_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Qate abi quba mina bosata moomi noi porobanomake qidzaite qaami Ohongaho mumure naatemi noko noke ipitotoqi tuumata. ");
INSERT INTO ghs_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Tuusumi Dzuta abiho ingona dzuma naatemi Dzesui tumakhameto nomema noko torata peiteqi habese karasi eeteta. ");
INSERT INTO ghs_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","Oke eesuqi noi nese dzoobire moomi abi quba minai peqihimi noi nokoho quba eetarotake no ango qupadzomata. Oonihe noi Piripike toronaita quba qasa hiireta, Abi samane baabeta napa ikata patta ttuma eetemi muuna isanataqu? ");
INSERT INTO ghs_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Hiiremi Piripi hee, Eehe abi quba minanita napa ttuma tu hattatti kina (K200) oho isaki biiremi noko gama too kakaho isakita patta muunami bamu isanataqu. ");
INSERT INTO ghs_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Hiiremi Siimo Peetoroho noma Attereo, noi Dzesu pobi hiireta, ");
INSERT INTO ghs_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Abi khata napaho teei heeba aima baabe. Oi dzobadzoba boto teena ma sekana ngoru eseri. Oonihe oi abi tupu minaraho quba qidzoke isanataqu. ");
INSERT INTO ghs_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Hiiremi Dzesu hee, Nike abi pobi hiiremi habesare. Hiiremi garasi ota isanatemi abi ungapa ota habeseta oi 5,000 naateta kaqa. ");
INSERT INTO ghs_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Oonita Dzesui dzobadzoba oke aima Ohonga dzoobe hiireqi pattabetemi abi oona habeseta oi muunata. Ma teena oke noi sekana eetemi nokoho dza hiiretaho isakita biranateta. ");
INSERT INTO ghs_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Obetemi abi muuna isanatemi qetta ma saru oomi oi eto qanganatainoho quba Dzesu hiiremi, tumakhameto nohoi oke ttutuiteta. ");
INSERT INTO ghs_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ttuttuiteqi dzobadzoba qetta oke baubotomi kamo 12, nokomaeho isaki hee eeteta. ");
INSERT INTO ghs_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Oonita Dzesu oke eetemi abi moomi Ohongaho mumure naatemi noko erake hiireta, Meeke too abi mina ttokata biranatare hiireta oi era. ");
INSERT INTO ghs_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Hiiremi Dzesu moomi nokoi noke abi qiba nokome quba upubidzare boomimi noi noqeke torata herototota. ");
INSERT INTO ghs_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Obete sure mootomi tumakhameto nohoi qurate unaunata biranateqi sisima peite qee Kapanao nagapata tuumare hiiremi Dzesu nokoho toro biranataama naatemi qupi sooromi noko ao oba ttuu bisata tuumota. ");
INSERT INTO ghs_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","19","Oonihe uta mina tooromi oba horesa eetemi noko kiromita sebeniho isakita dzaomoqi moomi Dzesu obaho heeta qooro sisimaho toroqata biranatemi noko ququimata. ");
INSERT INTO ghs_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ququimami Dzesui hee, Eo anai oonita eto atti eetaino. ");
INSERT INTO ghs_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Hiiremi nokoi noke sisimata aimare hiiretahe, unauna noko qupadzomata oke noko ikanomake eete ao hairiamake ota biranateta? ");
INSERT INTO ghs_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Obetemi iihai mootomi abi tupu oi qirike eete oba ttuu totaqita qooroqi hee, Dzesui te arukuke torata qurate sisimata peitara. Ma sisima teenai keke ootahe, noho tumakhametoi noke qaate tuumata oonihe noi kaqani? ");
INSERT INTO ghs_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Oiqi hiiretanihe Tiberia nagapaho sisima qesai unateta. Oonihe Dzesui dzobadzobaho agoago eetemi abi muunata teka oi te kharata oorara. ");
INSERT INTO ghs_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Oonita abi tupu oi Dzesu ma tumakhameto nohoke mooraama naateqi nokoi goottae eeteqi sisima qesata peite Kapanao nagapata Dzesuho qiri eetareiqi tuumata. ");
INSERT INTO ghs_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tuumaqi noko oba ttuu totaqita biranate Dzesuke saridze qasa hiireta, Banaita bodza apeta nii baaqorai? ");
INSERT INTO ghs_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Hiiremi noi hee, Ana baura eetemi Ohongaho mumure naatemi nike oke moo te mumure oho quba naho qiri eetoraidzaranihe, dzobadzoba nike muuna qura eetetaho quba naho qirike eetorai. Oke ana bamu nike ikotetaqu. ");
INSERT INTO ghs_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","28","Oonihe etoqa dzaetaetaho patta quba beedzae eetaino. Nookare. Ohongai nikeho quba anake ponabetemi anai Abiho Isaki naate nike qaraqara tatanga moitemi oi nikeho patta naatemi nike ooqaho quba beedzae eete qaarare. Hiiremi nokoi hee, Ikanomake eeteqi nanai Ohongaho baura oho beedzae eetaqu? ");
INSERT INTO ghs_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Hiiremi Dzesi hee, Ohonga ana dzoobiremi baaqorai oonita nike anake nooka hisi eesuqa Ohongaho baura eetakoi. ");
INSERT INTO ghs_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Hiiremi nokoi hee, Oonihe, Moseho bodzata nanaho uimane haba habanata mana muuna qaata. Oonita Noi hiiremi qusu neta pattai quratemi abi muuna qaataiqi hiirorai. Oonihe, nii baura apeke eetemi nanai oke hee, Ohongaho mumure ooniqi hiireqa niike nooka hisi eetaqu? ");
INSERT INTO ghs_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Hiiremi Dzesu nokoke erake hiireta, Patta qusuta quratemi abi muunata oke Mose te nokoke moitaranihe, Mai nahoi qusu patta mee nike moite baaorai. ");
INSERT INTO ghs_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ohongai patta moitemi qusuta quratorai oi ttoka abi qaraqara moitoraiho isaki. ");
INSERT INTO ghs_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Hiiremi nokoi noke hee, O Soopara, patta oonomake nana moitemi muunorare. ");
INSERT INTO ghs_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Hiiremi Dzesu nokoke pobi hiireta, Ana naamae qaraqaraho patta. Oonita apei naho toro biranataqu noi bamu patta quba baataqu, ma apei anake ai tataumaqu noi bamu oba quba baataqu, bamu. ");
INSERT INTO ghs_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","37","Oonita ana hiire, teena oke paha hiire, Nike anake nesema mooraihe te ai tataumoraidzaranihe Ohonga naho botota mootomi oorai nokoio gama naho torota soomakoi. Ma naho toro soomareiqi baabaqu abi oonomake ana bamu qiritomaqu, bamu. ");
INSERT INTO ghs_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Anai te dza nameke qusubaita quba qurataranihe, mai anake dzoobireta noho dzake qusubaiteqi qurateta. ");
INSERT INTO ghs_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Oonita mai ana dzoobireqi abi qesa naho botota mootota noi dza eetemi ana nokoke gama tuuhoro qaaqa ipi bodzata iso keke nokoke tuukutakoi. ");
INSERT INTO ghs_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Oi Mai ana dzoobireta noi dza eetemi apenei anake mooqa nooka hisi eetaqu nokoi gama qaraqara tatanga saridzemi anai noko ipi bodzata tuukutakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Oonita Dzuta abi gunugunu hiireta oi teeho quba bahe noi bosata hee, Patta qusuna quratorai oi ananiqi hiiremi, noko erake hiireta, ");
INSERT INTO ghs_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Eehe, noi Dzosepeho khata. Mai ma pai nohoke napa gesinanihe, noi ikaqi hiireqi hee, Ana qusu neta quratoraiqi hiire? ");
INSERT INTO ghs_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Noko gunugunu hiiremi Dzesui noko pobi hiireta, Nikehota eto paha gunugunu biranataino. ");
INSERT INTO ghs_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nookare. Mai ana dzoobireta noi abi teeke qoqopa eetaama naatemi qidzoke abi oi naho toro soomami ana noke ipi bodzata tukutaqu. ");
INSERT INTO ghs_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Oi Too abi qeeteqi hee, Ohongai noko gama tete banaitakoiqi qeetetanita ape ma ape Ohongaho noo nookaqi noho toro tete gesina naatorai nokoio naho torota soomakoi. ");
INSERT INTO ghs_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Oonihe Ohongake nese taate iihorai oi abi qesa bahe, ana Ohongaho neta baaorai ma ana teenai noke nese taate iihorai. ");
INSERT INTO ghs_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Oonita teei ana nooka hisi eetorai noi qaraqara tatanga mai eetorai oke meeke ana nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Oi teeho bahe ana naamae qaraqara oho pattani. ");
INSERT INTO ghs_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nookare. Nikeho uimane haba habanata maana muunaqi baate bamu naateta. Oonihe ana naamae qaraqaraho patta. ");
INSERT INTO ghs_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Oi patta ape bahe ana qusuta quratemi abi teei anaho isakike muunaqa baataama naate qaaraqu patta oioni. ");
INSERT INTO ghs_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ana namae patta qaraqaranomai qusuta quratemi teei patta erake muunaquko noi agoba qaraqara qaarakoi. Oonihe patta ana ttoka abi moitemi qaraqara saridzaqu oi sama naamaehoni. ");
INSERT INTO ghs_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Qahura oke Dzesu hiiremi Dzuta abi nookami meeho isaki naatemi noko bababa bari naateqi hee, Abirai ikanomake eete sama nome napa moitemi muunaqu? ");
INSERT INTO ghs_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Oke hiiremi Dzesui nokoke ao kuibidzare hiireqi hee, Noo meenipamuke ana nike pobi hiire. Nikei Abiho Isaki anaho hidzoba ma dzuu muunaama naataquko qaraqara bamu nikeho torota biranataqu. ");
INSERT INTO ghs_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Qate apei naho hidzoba ma dzuu muunorai noi qaraqara tatanga mai eetorai. Ma abi oke ana ipi bodzata tukutakoi. ");
INSERT INTO ghs_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Oi hidzoba ma dzuu nahoi patta ma obaho qesa. ");
INSERT INTO ghs_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","57","Oonita teei naho torota isaki mee giimoraqu no ma nakamae qesa dzaga boboto qaaqa oora ma qaara qidza eetorakoi. Oi mai ana dzoobiremi ana noho torota qaraqara giimoraita teei naho mee naku nometa aimoraqu noi naho toro qaraqara giimorakoi. ");
INSERT INTO ghs_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Qate uimane haba habanata patta muuna qaaqi baateta oi mainanini, apei patta erake muuna agoba qaaraqu oi qahura maina. Oonita patta poiqa qusu neta quratorai oi ananita qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Noo oke Dzesui Kapanao nagapaho sinabidza guhuta abi banaite pobi hiiremi, tumakhameto qesa samane noho noo nookaqi hee, Idze. ");
INSERT INTO ghs_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Noo oi bamenomanipamu. Abi oke qidzoke nooka qusubaiteqi noho dzuu ma hidzoba muunaqu oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Oonihe Dzesuho tumakhameto oho qesa gunugunu oke hiiremi noi qupadzomaqi hiireta, Nike anake muunaquho noo oke nookami qanganate mae? ");
INSERT INTO ghs_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Oonita nookare Abiho Isaki anai burisi eete bosata qaataho robeta peqihimi nike moohimi nikehota isanataqu mae? ");
INSERT INTO ghs_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nookare. Hidzoba hiibi hiidzobanipamu oi bamu nike hoobidzaquhe, meeke Sumasai qaraqaranomaitorai, Oonita noo ana nike pobi hiirorai oio Sumasa ma qaraqaraho isaki. ");
INSERT INTO ghs_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","65","Oonihe nikehota qesai ai tataumaama naatoraiho qahurani. Oi Ohongai abi teeke qoqotomaama naataquko qidzoke noi naho toro soomaqu ooqaho qubake ana oonomake eete qahurake hiire. Oiqi hiireta. Oonita ape ma apei ai tataumaama naatarota ma apei noke geema mootarotake Dzesui khoobanipamuta ao qupadzoma ooqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Oke hiiroramuti qaatemi oho qubake tumakhameto qesa ma abi samane nokoi noke gaubire te noke paha gainene eete qaarara. ");
INSERT INTO ghs_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Oho quba Dzesui tumakhameto tuerebe nomenipamuke hee, Oonita nike oho qesa anake papatare hiirorai kaqa? ");
INSERT INTO ghs_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Hiiremi Siimo Peetoro noi hee, Soopara naname, nanai niike papate apeho torota soomaqu? Baamu. ");
INSERT INTO ghs_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nii teenai qaraqara tatanqaho pobi hibahiba. Oonita Nii Kiristu Ohongaho isaki qaheubana oke nana qupadzomaqi nooka tani naatorai. ");
INSERT INTO ghs_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Hiiremi Dzesu hee, Meeke ana tuerebe nikeke asatetanihe, nikehota teei Iibadzaho isaki oonita nookare. ");
INSERT INTO ghs_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Oiqi hiireta oi teeho bahe Siimo mainaho khata Dzuta Khariottaho nena noi tumakhameto tuerebama ooqi Dzesuke geema mootarotake Dzesui qupadzomaqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Oonita Dzutea abi nokoi Dzesuho gunu dzoomami noi Garirea habata tuume baabe eete qaaqi Dzutea haba potti biire qaata. ");
INSERT INTO ghs_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Qate haba habanaho Baruba ma Iisu Meupunomaho Dzuma mina dzamo naateta. ");
INSERT INTO ghs_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","4","Dzamoqa naatemi, Dzesuho nomamanei noho gedzoba hiireqi hee, Abi teei qasanidzata quba eetaqu oke dzukudzukuta eetaamanita isanate nii Dzutea habata tuumami baura samane nii eetorai oke tumakhameto niiho minarai gama moorare. Oke nii eetareiqa minaraho neseta eetare. ");
INSERT INTO ghs_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nokoi hiireta oi Dzesu noomaeho nomamanei te noke nooka hisi eetara. ");
INSERT INTO ghs_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Oke noko hiiremi Dzesu erake hiireta, Eehe, naho bodza biranatakoihe, poiqa ttoka abi ma nikeho bodza oni. ");
INSERT INTO ghs_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Oi noko te nike ibo eetoraidazanihe, anai nokoho khooba qanga paanaitemi nokoi anake ibo eetorai. ");
INSERT INTO ghs_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Oho quba nike ao dzuma quba peitare. Qate naho bodza biranaataamake ooraita ana bamu poiqa dzumata tuumaqu. ");
INSERT INTO ghs_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","10","Oke hiireqi noi te bodza ooqata Garirea haba qaatara, oonihe noho nomamane ao tuumami ipita noi paata bahe dzaheke tuumaqi Dzerusaremuta peiteta. ");
INSERT INTO ghs_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Dzuta abi samanei Dzerusaremuta dzuma eeteqi noho qirike eete hee, abi oi kaqaniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ma abi samane garubata noke noo maina painake hiireqi qesai hee, Noi abi qidzaniqi hiiretahe qesai hee, Eo noi abi ikobetake eetoraiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Oonihe nokoi gama Dzuta abi mimiho attike eete seiqake noho noo hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Qate dzumaho bisa qaputa Dzesui Ohongaho biirita peite abi banaiteta. ");
INSERT INTO ghs_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Banaitomi Dzuta abi hasa hiireqi hee, Abirai sukuru mina baamuhe, gesina nohoi minanipamu. ");
INSERT INTO ghs_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Hiiremi Dzesui hee, Oonihe naho hibahiba oi namaeho bahe, Mai ana dzoobireta oi noho. ");
INSERT INTO ghs_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Oonita ana nameke hiirorai eo Ohongahoke hiirorai oke teei Ohongaho dza eetare hiireqi qase dzoomaquko, ao naho khooba qupadzomakoi. ");
INSERT INTO ghs_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Oi teei sama qusuba baura eeteqi noo nomeke hiibakoihe, apei noke dzoobiretaho dzapa qusubaite hiibaqu noi obera bahe, meenipamu oni. ");
INSERT INTO ghs_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Nookare. Mosei nike hu noo moiteta. Oonita nike gama naane quba oke qububaitaama naate anake teetare hiirorai? ");
INSERT INTO ghs_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Hiiremi garubai hee, Apei niike teetare hiirorai? Nii ao gisike naateqi oke hiire. Hiiremi Dzesu hee, Nookare. ");
INSERT INTO ghs_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ana baura qidza teeke dzumata eetemi nikehota obera naatorai kaqa. Qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Sama koko geeba mootaqu oi Abarahamu ma karaho neenanihe Mosei oho pai tatanga mootomi nike dzumata oho geeba mootoqi khameto dzuubetorai. ");
INSERT INTO ghs_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Oonita nike Moseho hu noo oke riitaino hiireqi dzumata ungapa geeba mootomi ana oho qesa dzumata abi teeke sama noho qidzaitemi naane quba nikehota qanganatorai? ");
INSERT INTO ghs_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Oonita mee noho gama qupadzoma soubireqake hiibareni eto sasake soobaino. ");
INSERT INTO ghs_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","26","Hiiremi Dzerusaremuho abi qesai hee, Noke abi teetare hiirorai oi erani kaqa. Oonihe moorare. Noi paata noo hiiremi noko ikake eete noho noo ipi hiibaama naatorai. Pore napaho abi mimi moomi noi Soopara Kiristunipamu oni kaqa. ");
INSERT INTO ghs_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Oonihe Kiristu baabaqu, napai bamu noho nagapa khooba qupadzomaquhe, abiraho nagapa khoobake napa gesina. ");
INSERT INTO ghs_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Hiiremi Dzesu oho quba sokateqi biirita paanaite hiireta, Nike ana gesina ma naho khoobake gesinaniqi hiirorai. Iaqa, ana te naamae baabara. Mai ana dzoobireta noi meenipamu oonihe nike noke ruume. ");
INSERT INTO ghs_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Qate noi ana dzoobiremi ana noho neta baaqoraita anai naqeke noke gesina. ");
INSERT INTO ghs_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Noo oonomake noi hiiremi abi mimi nokoi noke karabetarotahe noho bodza biranatamake oomi abi te noke botoma hesatara. ");
INSERT INTO ghs_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Qate garubata qesa samane erake hiireta, Kiristunipamu baabaqu, baaqi noi obaoba samaneke eeteqi abirake beekho eetaquho tete bamu, oonita noio Kiristuni kaqa. Oiqi hiireqi nokoi nooka tani naateta. ");
INSERT INTO ghs_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Qate garubai Dzesuho noo oonoma hiiremi Pariseo nookaqi noko dzube abi mimima nokoi Dzesuke karabeta quba sogimo dzoobiremi noko noho toro biranateta. ");
INSERT INTO ghs_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Biranatemi Dzesui noo ipibireqi erake hiireta, Ana bodza hoteqa teeke nikeho bisata ooqa burisi eete mai ana dzoobireta noho toro tuumakoi. ");
INSERT INTO ghs_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tuumami nike ana iihare bitta eeteqi naho qirike eete bamu saridzaqu. ");
INSERT INTO ghs_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","36","Hiiremi Dzuta abi nokoi hee, Noi noo apeke hiireqi hee, Anai tuumaqu ota nike anake iihare bitta eete naho qiri eetareko hiibi? Abirai ikata tuumami napai noho qirike eetaqu? Mae noi Iisirae abi qesai raaba abi kharanaho bisata ooraiho neta tuumaqa Girisi abi ma kara tete banaitaqu? Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Qate dzumaho suheta qonoqono mina eeteta bodza ota Dzesu qooro sokateqi hiireta, Teei oba quba baateqi isanate no baa naho toro muunare. ");
INSERT INTO ghs_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Oonita apei ana oonomake eete ai tatamaqu qetaqeta hiiroraiho isakita naku nohota qaraqaraho oabio hee eete pereborakoi. ");
INSERT INTO ghs_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Hiireta oi Dzesui ipita paha qusu dzadzaho pobi naatemi Sumasai abi ai tataumoraike soobarotahoke noi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Hiiremi garubata qesai Dzesuho noo oke nookaqi hee, Maa too abi baabakoiqi hiireta oioni. ");
INSERT INTO ghs_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","42","Ma qesai hee, Abi oi Kiristunipamu ooniqi hiireta. Oonihe qesai erake hiireta, Eehe Tabitiho soro ma saina oi Tabitiho nagapa, Betterehemuta biranatakoi oke sinabidzata qeetemi ooraita ikanomake eete Kiristui Garirea habata baabaqu? ");
INSERT INTO ghs_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Hiiremi noho noo quba garubata hu ma koridza biranateta. ");
INSERT INTO ghs_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ma qesai noke karabetare hiiretahe, ikanomake eete abi noke hesataama naateta? ");
INSERT INTO ghs_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Oonita sogimo nokoi burisi eete Pariseo ma dzube abi mimiho torota biiranatemi noho qasa hiireta, Nike ikake eete noke aimaama naate? ");
INSERT INTO ghs_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Hiiremi nokoi hee, Abi qesai noo hiiroraihe, abi oio noo bamenomanipamuke hiirorai. ");
INSERT INTO ghs_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Hiiremi Pariseo nokoi hee, Idzo, noi paha nikeke ikobetorai. ");
INSERT INTO ghs_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","49","Meeke abi qesa rasakinoma nokoi hu noo ruume naate noho toro atimorai. Qate nike moomi bosa qobaqobani mae Pariseo nanahota teei noke nooka hisi eetorai mae? ");
INSERT INTO ghs_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Oonihe, nokomaeho tee Nikotemo noi bosata qupibake Dzesuho toro baata, noi qesamane nomeke hee, ");
INSERT INTO ghs_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Oonihe napa hu noo napame qusubaiteqi abi teeho baura ma noo ipi nookaamake ao hairiamake noke qanga hiibaamani. ");
INSERT INTO ghs_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Hiiremi nokoi hee, Oonita nii paha Garireaho nenai oke hiire kaqa. Nii sinabidza geeta qiri eete moorare. Too abi oi bamu Garirea habata biranataqu, baamu! ");
INSERT INTO ghs_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","(Oke hiireqi noko gama sakaba naga nome ma nometa tuumata.) ");
INSERT INTO ghs_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Qupi sooromi Dzesui qee Oriba torata peiteta. ");
INSERT INTO ghs_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Qate iihai mootomi noi burisi eete Ohongaho biirita peitemi abi samane noho torota baami noi habese noko tete baanaiteta. ");
INSERT INTO ghs_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","4","Banaihimi qetaqeta abi ma Pariseo nokoi atapa teeho pasena paanaite noke dzeima garubaho bisata mootoqi Dzesuke pobi hiireta, Banaita naname, atapa erai pasena eetemi nanai noho khooba saridze. ");
INSERT INTO ghs_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Obetemi Mosei hu noota qeeteqi napake hee, Pasena eranoma saridzorai nokoke omama teetareiqi hiireta. Qate nii oke ikaqi hiibaqu? ");
INSERT INTO ghs_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Oiqi hiireta oi teeho bahe, noko Dzesuho angi naate noke qomaqoma hiiba quba hiireta. Oonihe Dzesui kautu eete boto nomema ttokata qeeteta. ");
INSERT INTO ghs_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Qeetemi nokoi noke qasaqasa hiiromi noi qoridzeqi noko pobi hiireta, Oionita nikehota apei kahosaama, noi bosaho eete omama ataparake teetare. ");
INSERT INTO ghs_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","9","Oiqi hiireqi noi paha kautu eete ipibireqi ttokata qeetemi nokoi noo moo nookaqi subate abi mimi bosaho eete tta eesumi eehahai oho qesa sakabaqi bamu naateta. Bamu naatemi Dzesu moomi atapa bisata oota noi noqeke oota. ");
INSERT INTO ghs_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Oomi noi qoridze atapake qasa hiireta, Niho qomaqoma hiirori abi oio kaqa? ");
INSERT INTO ghs_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Hiiremi noi hee, Mai name, bamu. Hiiremi Dzesu hee, Oonita anai oho qesa bamu niiho qomaqoma hiibaqu, oonihe nii tuumaqa eto paha pasena teeke saridzaino ooiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Oke hiiremi bamu naatemi Dzesu noi paha garubake hee, Anai ttoka abiho dzadza. Oonita teei anake iihaqu noi bamu basa qooto tuumaquhe qaraqaraho dzadzata tuumakoi. ");
INSERT INTO ghs_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Hiiremi Pariseohota qesai hiireta, Eehe, sama niimeho nooke nii hiibi oonita noo oi obera. ");
INSERT INTO ghs_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Hiiremi Dzesu nokoke hee, Ana ikata baata ma ikata tuumaqu oke ana gesina. Oonita ana sama nameho noo hiibapuko oi bamu oho quba obera naatarori. Oonihe anai ika neta baata ma tuumaqu oke nike ruume. ");
INSERT INTO ghs_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nike noo sasake hiirorai. Qate anai te abiho khooba sepeke sigumoraidzara. ");
INSERT INTO ghs_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","17","Nookao, nikeho hu noota qeetemi oorai oi hee, Abi eseri nopoi isere teeke mootaquko oi meenoma naatakoi. Ooiqi hiirorai. Oonihe ana abiho khooba sigumaquko oi meenoma naatakoi oi Mai ana dzoobireta noma nakamae eseri ooraita noo oi meenoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Paha ana sama nameho isere mootapuko Mai ana dzoobireta noi naho isere qaupuitarori. ");
INSERT INTO ghs_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Hiiremi nokoi hee, Niiho mai noio kaqa? Hiiremi Dzesu hee, Mmhm, naho khooba ma mai nahoho khoobake nike ruume. Nike naho khooba qupadzomapuko, paha mai nahoho khooba qupadzomarori. ");
INSERT INTO ghs_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Noo oke Dzesui biirita hiireqi ttumaho suruhota hiireta. Oonihe noho bodza biranatamake oomi noko qidzoke noke karabetarota. ");
INSERT INTO ghs_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Oonita Dzesui paha nokoke hee, Ana tuusumake nike ota baabaquho isakiama naate naho qiri eete saridzaama naate kahosa nikemema gama baatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Hiiremi Dzuta abi nokoi qesa pobipobi hiireqi hee, Noi ikaqi hiireqi hee, Ana tuusumake nike ota baabaquho isakiama naatakoiqi hiire. Mae noi sama nome teetareke hiire? ");
INSERT INTO ghs_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Hiiremi noi hee, Nike kataho nenani anai pei nena. Oi anai ttokaho isaki bamuhe, nikemae oho isaki. ");
INSERT INTO ghs_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Oi nike anake hee, Qaraqaranomaniqi hiibaama naataquko nike kahosa nikemema gama baatakoi. Oke ana bamu nike ikobetaqu. Oqaho qubake ana bosata hee, Nike kahosa nikemema gama baatakoiqi hiire. ");
INSERT INTO ghs_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Hiiremi nokoi noke hee, Nii apei oni? Hiiremi Dzesui hee, Noo apeke ana hiiremi nike nookaqu? Baamu. ");
INSERT INTO ghs_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ana naamae nikeho noo samaneke hiireqa khooba nikehoke sigumaridzonihe, ana noo hiibi mai meenoma ana dzoobireta too nohota ana nookaqi noo ooqake anai ttoka abi nike pobi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Oonihe Dzesu oke hiiremi nokoi te hee, Noi Ohonga Maike hiire ooiqi te qupadzomara. ");
INSERT INTO ghs_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Oonita Dzesui erake hiireta, Ana naamae baura tee ma teeke eetoraidzaranihe, Mai ana bapotopotomi oho noo hiiroraike nike ipita qupadzomakoi. Oi nikei Abiho Isaki anake ai upubireqake naho khooba qaraqaranoma qupadzomakoi. ");
INSERT INTO ghs_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Qate Mai ana dzoobireqi teqaha ana qaataranihe, anake gainene eete nakamae oorai. Oonita ana noho dzake qusubaite eetorai oioni. ");
INSERT INTO ghs_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Noo samane oonomake Dzesui hiiremi Dzuta abi samane noho torota atimata. ");
INSERT INTO ghs_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Atimami Dzesu nokoqake pobi hiireta, Dzoobe, qate nike naho nooke nookoraquko naho khametonipamu naatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nike noo mee oke gesina naatemi noo oi nike saqoromi adzahaha naatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Hiiremi qesai basesa eeteqi hee, Nana Abarahamuho biidza ma suunai angiama naate baaqorai oonita nii ikaqi hiireqi hee, Noo oi nike saqoromi adzahaha naatakoiqi hiire? ");
INSERT INTO ghs_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Hiiremi Dzesu nokoke hee, Ape ma ape kahosa eetorai nikei kahosaho sutasuta oorai onita oke ana bamu nike ikobetaqu. ");
INSERT INTO ghs_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Oonihe tete erake eete oorai. Apei Maiho naga qidzata agoba qaaraqu? Oi sutasuta abi bahe, khataio ota agoba qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Oonita anai khata ooqi nike saqoromake nike adzahaha naate qaki naatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","38","Qate nikei Abarahamuho ttidzata quurateta oke ana gesina. Oonihe naho Mai baura eetemi naho nese mooqoraike ana hiire paanaitemi naho nooke nike naane quba arabireqi anake teetare hiirorai? Oi nike mai qanga nikemeho toota nookoraike nike eetorai. ");
INSERT INTO ghs_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Hiiremi nokoi hee, Nanaho mai ape bahe Abarahamu. Hiiremi Dzesui hee, Nike Abarahamuho biidza ma suunanipamu oorapuko noke suima oorarori. ");
INSERT INTO ghs_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Oonihe, anai noo mee Ohongaho toota nookaqi nike pobi hiiremi nike abi eranomake teetare hiirorai. ");
INSERT INTO ghs_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tete oonomake Abarahamu te aima qaarara. Oonita nike mai maina nikemeke suimaqi eetorai. ");
INSERT INTO ghs_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","43","Hiiremi nokoi hee, Nanai eehera khameto bamu. Nanaho mai Ohonga teena. Hiiremi Dzesu nokoke hee, Bamu. Ana te namae baabaranihe Ohonga ana dzoobiremi ana baaqorai, oi anai noho nena qaaqi baaqorai. Oonita Ohongai nikeho mai oorapuko nike naho dzake eetarori. Qate nikeho toma susudzatemi nike naho noo ma totoho nookaama naatorai. ");
INSERT INTO ghs_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Oi teeho quba bahe Saatai khoobanipamuta taanga abi naatemi nohota tete mee bamu naatemi noi quba meeho teteke qaateta. Oonita noi sama nomeke eeteqi obera noo hiirorai. Noi obera abi ooqi oho mai naatemi nike noho khameto naate Saata mai nikemeho dzake qusubaitorai. ");
INSERT INTO ghs_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Oho quba ana noo mee nike pobi hiiremi nike naho noo aimaama naatorai. ");
INSERT INTO ghs_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nookare, nikehota apei anake oberaniqi hiiremi isanataqu? Baamuta naane quba nike anake nooka hisi eetaama naatorai? ");
INSERT INTO ghs_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Oi nike Ohongaho khameto ooraama naate noo nookaama naatorai. Qate ape ma apei Ohongaho noo nookorai nokoio Ohongaho khameto. ");
INSERT INTO ghs_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Hiiremi Dzuta abi nokoi noorake noke pobi hiireta, Nana hee nii raaba abi songenanomaniqi hiiremi qidzoke nii oho bai hiibaqu. ");
INSERT INTO ghs_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Hiiremi Dzesu hee, Anai oonoma bahe Mai nameho dzapa qusubaitemi nike naho dzapa midzata mootorai. ");
INSERT INTO ghs_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Qate Teei quba minaraho pobipobi noi isanate naho dzapa qusubaitakoi. Oonihe anai te dzapa name qusubaitoraidzara. ");
INSERT INTO ghs_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nookare. Abi teei naho noo qusubaite qaaraquko bamu baataho kabira naataqu. Baamunipamu. Oke ana meeke nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Hiiremi Dzuta abi burisi eete noke hee, Nii oonoma hiiremi nana nookami nii songenaho isakinipamu. Abarahamu noi too abi ma noko gama baate bamu naateta. Oonita nii ikaqi hiireqi hee, Abi teei naho noo qusubaite qaaraquko baata bamu noke muunaquiqi hiire? ");
INSERT INTO ghs_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abarahamu ma too abi nokoi gama baatetanita nii nokoke beekho eete abi minanipamu ape oni? Nii sama niime moomi apei oni? ");
INSERT INTO ghs_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Hiiremi Dzesu hee, Eo, anai dzapa name qusubaitapuko naho dzapa quba sepe naatarori. Qate nike hee, Onongai nanaho mai ooniqi hiiroraihe, Ohonga nike hiirorai teena noi naho Mai ooqi naho dzapake qusubaitorai. Oonita nike noke ruume oonihe, meeke ana naamae noke gesina. ");
INSERT INTO ghs_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Anai hee, Noke ana ruumeniqi hiibapuko ana nikeho qesa obera abi naatorori. Oonihe anai noke gesina naateqi noho noo qusubaite soubirorai. ");
INSERT INTO ghs_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Qate Abarahamu eebobo nikeho noi naho bodza quba beebe eete qidzanate qaata. Oonihe noi anake mooqi qaki minanipamuke eeteta. ");
INSERT INTO ghs_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Hiiremi Dzuta abi nokoi noke hee, Iaqa, niiho tii 50 biranataamake aoke nii Abarahamuke moota mae? ");
INSERT INTO ghs_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Hiiremi Dzesu noko erake hiireta, Nookare. Abarahamu biranataamake oomi Anai Qaatai Qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Oke hiiremi nokohota bamenoma naatemi noke oma tukuma teetare eetetanihe, noi dzukuroqi biirita tta eeteta. ");
INSERT INTO ghs_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ipita Dzesu teeta tuusuqi moomi abi nese khabanoma teei oota. ");
INSERT INTO ghs_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Oi pai noke oonoma dzoomata. Qate Dzesuho tumakhametoi noke qasa eeteta, Banaita naname, abirai noomae kahosa saridzeta mae eo mai pa pai nohoi kahosa saridzeqi pai noke oonomake dzoomata? ");
INSERT INTO ghs_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Hiiremi Dzesui hee, Baamu. Mai ma pai baamu. Oho qesa noi te nomae kahosa eetemi biranatara. Oi Ohongai beedzae nome noho irita paanaitare hiiremi quba oi biranateta. (Khata, nookare.) ");
INSERT INTO ghs_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","5","Anai ttokata ooraquta ttoka abiho dzadza naatorai. Oonihe qupi sooromake abi qidzoke baura eetaqu. Oho quba ete dzadza ooraquta Ohonga ana dzoobiretaho baura oke napamae eetaridzoni. ");
INSERT INTO ghs_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","7","Oke hiireqi noi ttokata ogidzoba eete sare eeteqi oho akiakima abi nese khabanomaho nese suraiteqi noke pobi hiireta, Tuumaqa nese nime oba kose Siroamuta akobetare. Oiqi hiireta. Qate Siroamuho khooba oi hee, Dzoobireta. Oonita Dzesu noke ota dzoobiremi noi ota tuuma nese nome akobetemi uhubami baata. ");
INSERT INTO ghs_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Oonihe noi abi nese khabanomai qaata oke noho qesamane ma abi qesai gama gesina qaata. Oonita noi baami nokoi hee, Idze, abi habese nenesa eetorai abi oi erani mae apeni? ");
INSERT INTO ghs_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Hiiremi qesai hee, Oioni. Hiiremi paha qesai hee, Oi bamuhe noho tomidza tee ooniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Oonihe noomae hee, Eo anai oni. Hiiremi nokoi hee, Ikanomake eete niiho nese uhubami nii haba moori? Hiiremi abi oi hee, Abi tee, dzapa noho Dzesu, noi ttoka akiaki teeke korabeteqi naho neseta suraite hee, Nii tuumaqa oba kose Siroamuta nese niime akobetareiqi hiiremi ana tuume. ");
INSERT INTO ghs_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tuuma nese name akobetemi oi uhubami ana haba mooqi baabe. ");
INSERT INTO ghs_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Hiiremi noko noke hee, Abi oi kaqani. Hiimi noi hee, Ana ruume, ");
INSERT INTO ghs_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Oke hiiremi abi nese khaba eete qaatati qidzanateta noke noko dzeimaqi Pariseoho toro biranateta. ");
INSERT INTO ghs_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","(Oonihe Dzesui akiaki korabeteqi abiho nese pobiteta oke noi dzumata eeteta.) ");
INSERT INTO ghs_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Oonita Pariseo noko oho qesa abi ikanomake eete haba moota noke qasa hiiremi noi hee, Maa abi noi ttoka akiaki naho neseta suraitemi ana akobetemi nese naho uhubami moorai. ");
INSERT INTO ghs_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Hiiremi Pariseo qesai erake hiireta, Dzumake no riite baura eetemi nana nookami noi Ohongaho nenanidzara. Oiqi hiiremi qesai hee, Eehe, ikanomake eete abi kahosanomai baura eetemi Ohongaho mumure eranomaho qesa naataqu? Oke hiireqi nokohota hu ma koridza biranateta. ");
INSERT INTO ghs_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Biranatemi noko paha abi nese khabanomai qaatake hee, Dzesui niiho nese qidzaitemi nii noho noo ikanoma hiibaqu? Hiiremi noi hee, Ana moomi too abi oni. Ooiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Oonihe Dzuta abi noko hou peu eeteqi hee, Abirai nese khabanomai biranate qaimi noho nese pobitemi haba moori tete oi ooraama. Oke hiireqi noko mai ma pai nohoho quba hiiremi baata. ");
INSERT INTO ghs_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Baami nokoi nopoke hee, Erai khata nipehoni mae? Hiiremi nopoi hee, Oore. Hiimi nokoi hee, Qate noi nese khabanomai biranateta mae? Hiiremi hee Ooreiqi hiireta. Hiiremi noko hee, Oonihe noi ikanomake eete poiqa bageke eete mooqorai? ");
INSERT INTO ghs_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Hiiremi mai ma pai hee, Khata nakahoi nese khabanomai biranateta oke nake gesina. ");
INSERT INTO ghs_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Oonihe noi poiqa quba moori teteke naka ruume. Mae apei noho nese qidzaite oke paha ruume. Oonihe noi ao kotanga naate ooraita isanate noke qasa hiiremi noomae oho khooba paanaitare. ");
INSERT INTO ghs_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Oiqi hiireta oi teeho quba bahe, Dzuta abi mimi ago qiba teenaiteqi hee, Abi teei Dzesuho nookami Kiristu naataquko abi oke sinabidza guhuke qaanatareiqi hiiremi qaata. Oonita mai ma pai oho attike eete hee, ");
INSERT INTO ghs_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Noio kotanganita noke oho qasa hiibareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Hiiremi noko paha abi nese khabama qaata noho quba hiireqi erake hiireta, Nanai nookami Dzesui kahosanomanita eto noho hasa hiibainohe, Onongaqake hasa hiibare. ");
INSERT INTO ghs_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Hiiremi noi hee, Noi kahosanomani mae bamu oke ana ruumenihe, ana nese khabanomai naate qaarita poiqa isanate haba moorai teena oke ana gesina. ");
INSERT INTO ghs_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Hiiremi noko paha hee, Dzesui ikanomake eeteqi niiho nese pobitemi oorai? ");
INSERT INTO ghs_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Hiiremi noi hee, Idze, ana ao hiiremi nike nookaama naateqi nike naane quba noo teena oke nookareiqi hiidzo? Mae nike oho qesa Dzesuho tumakhameto naatare hiire oorai? ");
INSERT INTO ghs_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Hiiremi noko noke garugaru hiireqi hee, Nii noho khatani. ");
INSERT INTO ghs_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Qate nanaio Moseho tumakhameto. Oi Ohongai Mose pobi hiireta oke nana nookorai. Qate abiraho khoobake nana ruume. ");
INSERT INTO ghs_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Hiiremi abi oi nokoke hee, Iaqa, noi naho nese pobitemi ana mooraihe, ikanomake eete abi mimima nike noho khooba ruume? ");
INSERT INTO ghs_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Oi Ohongai abi kahosanomaho noo qusubaitaamanihe, teei Ohonga ai tataumami noi noho noo qusubaitorai oke napa gama gesinani. ");
INSERT INTO ghs_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Oi nese khabanoma teei biranatemi apei abi oonomake nese pobitaqu oho teteke napa nookaamake baa qaabi. ");
INSERT INTO ghs_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Oonita Dzesui Ohongaho neta baabaama naatapuko noi quba eranomake eetaquho isakiama naatarori. ");
INSERT INTO ghs_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Oke hiiremi noko hee, Nii kahosaho ttidzata biranateta oonita nii apei nanake bapotopotaqu? Oke hiireqi noko noke ao hotou biiremi Isirae ttokaho dzore naateta. ");
INSERT INTO ghs_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nokoi abi oke hotou biiremi Dzesu oke nookaqi noke saridze erake hiireta, Abiho Isaki noke nii qupadzomorai mae? ");
INSERT INTO ghs_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Hiiremi noi hee, Mai name, nii noke ana banaitemake ana isanate noke ai tataumakoi. ");
INSERT INTO ghs_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Hiiremi Dzesu noke hee, Apei nii noo pobi hiibike nii moobo? Anai erani. ");
INSERT INTO ghs_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Hiiremi noi Dzesuho toro pomai kotoroqi hee, Oo dzoobe, anai niike ai tataume. ");
INSERT INTO ghs_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Hiiremi Dzesui hee, Oore, Anai ttokata quratemi neseamai nesenoma naatoraini qate nesenomai neseama naatorai oke eete batabirorai. ");
INSERT INTO ghs_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Oke hiiremi Pariseoho qesai nookaqi noke hee, Iidzo, oonita qesa ma nanai neseamani kaqa. ");
INSERT INTO ghs_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Hiiremi Dzesu noko pobi hiireta, Nike neseamaho isaki oorapuko, kahosa nikehoi bamu naatarori. Qate nike hee, Nanai nesenomaniqi hiiremi kahosa nikehoi urai oorai oorakoi, oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Dzesui hiireqi erake hiireta, Nookare. Teei sipisipiho naga pouke potti biireqa mainata dzongobete peitaqu noi ape bahe guume abinipamu. Oke ana bamu nike ikobetaqu. ");
INSERT INTO ghs_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Qate teei pouqata dzuuborai noio sipisipiho Sooparani. ");
INSERT INTO ghs_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Oonita nokoho tuhotuhoi pouta ooqa sooparake tete geemami noi sipisipi nome dzapaqi dzeimami noko noho totoho nookaqi biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Biranate soubiremi noi nokoho bosa qooro tuumami nokoi noho totoho ago gesina naate noke iihorai. ");
INSERT INTO ghs_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Qate noko abi qesaho noo totoho ruume. Oho quba abi maina baami noko bamu noke iihaquhe sakaba tuumakoi. ");
INSERT INTO ghs_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Oonihe qahura noo oke Dzesu noko pobi hiiremi noko teqaha oho khooba qupadzomara. ");
INSERT INTO ghs_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Oho quba Dzesui noko noorake pobi hiireta, Nookao. Sipisipiho pou oi pou ape bahe ana, Oke ana meeke nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Qate abi anake riite baa qaari nokoi gama guume abi maina paina. Oonita sipisipi nikei nokoho noo totoho nookaamanihe nahoke nookorai. ");
INSERT INTO ghs_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Anai oho pou oonita teei anata dzuubaquko qidzanatakoi. Ma noi naho neta tuume baabe eeteqa patta saridzorakoi. ");
INSERT INTO ghs_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Qate guume abi noi teeho quba baaoraidzaranihe, guumeke qupadzomaqi sipisipike teeteqa dzuubeta quba baaorai. Oonita nookare! Nikei qaraqara meupunoma saridza qubake ana baaorai. ");
INSERT INTO ghs_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Oi nikeho soopara qidza anai nikeho habara naate baataridzo. Oonita hiibi, anaio nikeho soopara qidza. ");
INSERT INTO ghs_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Qate teei nikeho maikhata bamu oonihe noi ttuma saridzare hiireqi sipisipike oberama soopara eeteqa moomi haa teeko baahuma noi ao atti tuumakoi. Tuumami haa oi nikeke aima sepesapeitaridzoni. ");
INSERT INTO ghs_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Abi oonomai teqaha sipisipike qupadzomoraidzaranihe ttumaqake noi qupadzomorai. ");
INSERT INTO ghs_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Oonita anai oonoma bahe soopara qidza. Mai ana qupadzomorai ma anai noke qupadzomorai. Oho qesa anai sipisipi name nikeke qupadzomami nike naho qupa toobake eetaridzoni. Oho qubake anai nikeho habara eete baatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Oonihe naho sipisipi qesai ropuba erata ooraama. Oonita anai noko paha dzeimami noko naho noo nookaqi baaqake kitu teena ma soopara teenai keke oorakoi. ");
INSERT INTO ghs_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ana naamae qaraqara name moosohiqa paha aimokoiqi hiiremi oho quba Ohonga Mai naho dza minake eetorai. Oi teei qaraqara nahoke karabetaquho tete bamu, ana naamae mootakoi. ");
INSERT INTO ghs_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Naho Mai ao hiiremi anai qaraqara name mootaqu ma paha aimaqu oho beedzae naho toro oorai. ");
INSERT INTO ghs_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Oke Dzesu hiiremi Dzuta abi qesahota hu ma koridza biranatemi qesa samane noorake hiireta, ");
INSERT INTO ghs_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Noi songenaho isakita ababara naate hiiroraita nike naane quba noho noo nookorai? ");
INSERT INTO ghs_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Oke hiiremi qesai hee, Eo, songenai abi nese khabanomake qidzaitaamanita noi te songenanomaho isakita hiiroraidzara, baamu. Oke noko hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Qate tama bodzata Ohongaho biiri paha Dzerusaremuta agoago eete qaataho dzuma naatemi, ");
INSERT INTO ghs_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Dzesui biiri oke girodzomaqi Soromoho seuta biranateta. ");
INSERT INTO ghs_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Biranatemi Dzuta abi qesai noke rome biireqi hee, Nanai qisiqasi hiiroraita nii Kiristu oni mae bamu. Khooba niime paanaitemi nana nookare. ");
INSERT INTO ghs_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Hiiremi Dzesui hee, Ana bosata hiiremi nike nookaama naateta. Qate ana Mai nameho dzapata baura samane eetemi oi paha naho khooba paanaitorai. ");
INSERT INTO ghs_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Oonita nike nookaama naatorai oi teeho quba bahe nikei naho sipisipi baamu. ");
INSERT INTO ghs_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Naho sipisipike ana qupadzomorai. Oi anai noko gesinanita nokoi naho noo totoho nookaqi anake iihorai. ");
INSERT INTO ghs_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","29","Iihaqi nokoi bamu dzaetaqu, baamu. Anai nokoke qaraqara tatanga moitemi qaarakoi. Qate teei nokoke naho botota karabetaquho tete bamu. Oi naho mai nokoke naho botota mootomi oorai ma noho beedzae minarahoke riite oorami teei quba teeke noho botota karabetaquho isaki bamu. ");
INSERT INTO ghs_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Oonihe mai ma nakai sama teena. ");
INSERT INTO ghs_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Oke hiiremi oi nokohota bamenoma naatemi aoke nokoi oma aimaqi noke teetare boohimi, ");
INSERT INTO ghs_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Dzesu qasa hiireta, Mai nameho baura qidza samane ana nike banaitemi ooraihota baura apeho qubake nike anake omama teetare hiire? ");
INSERT INTO ghs_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Hiiremi Dzuta abi nokoi hee, Baura qidzaho quba nanai te niike teetare hiiroraidzaranihe, nii abi ooqi sama niimeke Ohonga kimatetemi qaganomanipamu naatemi nana hiire. ");
INSERT INTO ghs_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Hiiremi Dzesu noko erake pobi hiireta, Nikeho hu noota erake qeetemi oorai, Anai nikeke hee, Nikei ohonga-mane ooniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nookare. Ohongai oonomaho isakita sinabidza nomeho bosa qobaqoba nikeke hee, Nikei ohonga-mane ooiqi hiiremi ooraita sinabidza oke arabidzaquho tete bamu. ");
INSERT INTO ghs_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Oonita Ohonga anake agoago eete ttoka abihota dzoobiremi ana baaqi hee, Anai Ohongaho khataniqi hiiremi nike ikaqi hiire hee, Noo oi qaganomaniqi hiire? ");
INSERT INTO ghs_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Oi anai Ohongaho baura eetaama naataquko, eto anake nooka hisi eetaino. ");
INSERT INTO ghs_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Qate anai Ohongaho baura eetemi nike anake nooka hisi eetaridzonihe, anaqake hisi eetaama naataquko, baura ana eetorai oke moo qupadzomaqi hee, Oionita Ohongama nopoi qesa dzaga bobotoraiqa hiibare. ");
INSERT INTO ghs_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Hiiremi nokoi paha noke karabetare eetetanihe, noi nokoke potti biireqi tuumata. ");
INSERT INTO ghs_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tuumaqi oba Dzotani biireqi Dzohane sobasobai bosata abike obama sooro qaata ota biranateqi oota. ");
INSERT INTO ghs_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Oomi abi samane baaqi erake hiireta, Oo Dzohane sobasobai teqaha noomae baura qesaqesa eetemi Ohongaho mumure naatara. Oonihe Dzohanei abiraho noo samane bamenoma hiireta oio meeni. ");
INSERT INTO ghs_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Oiqi hiireqi abi samane ota Dzesuho torota atimata. ");
INSERT INTO ghs_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Qate abi teeho dzapa Dzasaro noi khetedza aimata. Noho nagapa Bettania. Qate noho sase Matta ma dzaba nohoio Maria. ");
INSERT INTO ghs_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Oonihe oi Maria teeho bahe, atapa oba ura moromoronoma aimaqi ooma Dzesuho oko suraiteqi qiba gee nomema noho oko dzamutota Oonita noho nane Dzasaro noi heme aimata. ");
INSERT INTO ghs_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Heme aimami sase ma dzaba nopoi Dzesuho quba noo dzoobireqi hee, Mai nakame, qeseba temu niihoi batabata eete ooraita nookare. ");
INSERT INTO ghs_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Oonita Dzesu oho noo nookaqi erake hiireta, Noi batabata eete ooraihe baatanipamu eetaquho isaki bamu. Oi Ohongaho dzapake hasa hiibaqu ma khata nohoho dzapake hasa hiibaquho isaki naate oorai. ");
INSERT INTO ghs_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Oiqi hiireta. Oonihe oho tete oi era. Dzesui Dzasaro ma Matta ma dzaba Maria ma nokoho dza mina eete qaata. ");
INSERT INTO ghs_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Oonita noi oho noo nookaqi naane quba ooqata keke qupi eserike oota? ");
INSERT INTO ghs_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Oonihe qupi eseri bamu naatemi noi tumakhameto nomeke hee, Napa isanate poiqa Dzutea habata paha tuumareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Hiiremi tumakhameto nokoi hee, Banaita naname bosata Dzutea abi nokoi niike omama teetare hiireta. Oho quba nii ikaqi hiireqi ota paha tuumareiqi hiire? ");
INSERT INTO ghs_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Oiqi hiiretanihe Dzesui teqaha oho ruumeke oorara. Oho qubake noi erake hiireta. Eehe, ete dzadza oi saunaba 6 kirokota sohoro qeemaqi surena 6 kirokota bamu naatorai. Oonita abi qupibake tuumaquko meeke noi angita dzuubakoi. Oonihe anai ete bisaho isakita tuusubita angi nike hiire ota ana bamu dzuubaqu. ");
INSERT INTO ghs_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Oiqi hiiretanihe noi temu nomehoke hee, Dzaira napaho Dzasaro noi meerake eete oorai. Oonita ana poiqa tuuma noke tukutakoi. ");
INSERT INTO ghs_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","Dzesu oke hiireqi Dzasaro ago baate ootaho qahurake noi hiireta. Hiiremi tumakhameto nokoi hee, Soopara naname noi meerake eete ooraiqako qidzanatakoi, dzoobe. Oiqi hiireqi nokoi qupa nokometa hee, Dzasaro mee qidzanatakoiqi Dzesu hiiroraiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Oho quba Dzesui paata hiireta. Baamu, Dzasaro ago baate. ");
INSERT INTO ghs_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Oonita anama napai ota oorapuko dzasai nikeke suqobidzarorihe napai kharata ooraimi noi baatemi ana nookami quba oi nikeho ai tatauma tukutakoi. ");
INSERT INTO ghs_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Oho totaqita bagemona naatakoita napa tuuma Dzasaroke saridzare. Hiiremi Ttoma iiha dzoobireqi qesamane nomeke hee, Oionita napa tuumaqa Dzasaroma gama baatare. (Oi Ttoma ape bahe noke abi hee, Noi eseima biranatetaiqi hiire qaata noio hiireta). ");
INSERT INTO ghs_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Oho quba Dzusu ma nokoi tuumoramuti nagapa gattiqa Bettania ota biranatare boohiqi nookami Dzasaroke ao qurabiremi qupi eserisa eseri naateta. ");
INSERT INTO ghs_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Qate Bettania nagapa ma Dzerusaremuho takura oi dzamoqa, hapu haubaho isaki. ");
INSERT INTO ghs_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Oonita Dzuta abi samane Dzerusaremuna qaata nokoi Bettania nagapata biranate Matta ma Mariama noko Dzasaroho utu oota. ");
INSERT INTO ghs_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Qate Dzesu biranatare eetemi Matta nookaqi noke saridzare tuumatahe, Maria nagata habeseqi te qoridzara. ");
INSERT INTO ghs_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Oonita Mattai Dzesuke tete kosoramuta saridzeqi hee, O Soopara name, nii erata baa oorapuko noma nahoi bamu baatarota. ");
INSERT INTO ghs_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Oonihe ana qupadzomami nii quba tee ma teeho quba Ohonga pupu hiiremi ango nii moitakoi. ");
INSERT INTO ghs_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Hiiremi Dzesu noke hee, Oore, noma niihoi qoridzakoi. ");
INSERT INTO ghs_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Hiiremi Mattai hee, Ipita tukutuku bodzata noi qoridzaqu oke ana gesina. ");
INSERT INTO ghs_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Hiimi Dzesu noke hee, Ana naamae tukutuku ma qaraqaraho khooba. Oho quba teei anake ai tataumaqu noi baatareiqa baatakoihe bamu qaraqaraho dzore naataqu. ");
INSERT INTO ghs_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Oi ape ma apei ooraiqi anake ai tataumorai nokoi bamu baataho pobi naataqu, baamunipamu. Oke nii qupadzome? ");
INSERT INTO ghs_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Hiiremi noi hee, Soopara name, oi mee. Kiristu Ohongaho Khatai ttokata baabakoiqi hiire qaabi ana moomi nii oioni! ");
INSERT INTO ghs_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Oke hiireqi Mattai tuumaqi seiqake dzabake pobi hiireqi hee, Banaita noi baaqi niiho quba hiire. ");
INSERT INTO ghs_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Hiiremi Maria ao qori Mattama nopoi Dzesuho toro qeemata, ");
INSERT INTO ghs_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","oi Dzesu te nagapanipamuta peitaranihe Matta noke bosata kosoramuta saridzeta ooqata oota. ");
INSERT INTO ghs_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Oonita Dzuta abi ma paimane gama nagata ooqi Maria ttapuitare eesuqi moomi noi hairiamake qoridze paata tuusumi nokoi hee, Oo noi qura tuputa tuumaqa tti hiibakoiqi hiireqi noke iihata. ");
INSERT INTO ghs_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Qate Maria tete kosoramuta Dzesuho toro biranate oke toro nohota subate tti hiireta, O Soopara, nii erata oorapuko nane gottai bamu baatarota. ");
INSERT INTO ghs_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Hiiremi Dzesui moomi Maria noi Dzuta abi samanema noko Dzasaroho tti ma ttaka hiiremi Dzesuho qupa qanganatemi noi hekhettidzaiqi hiireta, Noke nike ikata mootomi oorai? ");
INSERT INTO ghs_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Hiiremi nokoi hee, Oo Soopara nii baaqa tekake moorare. ");
INSERT INTO ghs_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Hiiremi noi ttiroba eeteta. ");
INSERT INTO ghs_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ttiroba eetemi Dzuta abi qesai hee, Dzasa. Noho qupai Dzasaroho quba gimubata heme eete. ");
INSERT INTO ghs_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Hiiremi qesai hee, Oonihe abi oi nese khabanoma qidzaitorainoma oonita noi hiibapuko Dzasaro baataama naatarota kaqa. ");
INSERT INTO ghs_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Hiiremi Dzesu paha hekhettidzaiqi qura tuputa biranate moomi oma naga oke oma sararama pui siiremi oota. ");
INSERT INTO ghs_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Oomi Dzesu hee, Omake ai papatare. Hiiremi abi baatetaho sase Mattai hee, Soopara, qupi eserisa eseri naatemi ao dzahosa eete. ");
INSERT INTO ghs_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Hiiremi Dzesu noke hee, Nii ai tataumaquko Ohongaho dzapa pobi moorakoi oke ana bosata nii pobi hiire mae bamu? ");
INSERT INTO ghs_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Hiiremi noko oma oke ai papatemi Dzesui qusuke mooqi hiireta, Mai name, ana pupu hiiremi nii nookorai, oho dzoobeke ana hiire. ");
INSERT INTO ghs_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ma nii qupi samane naho noo nookorai oke ana gesina. Oonihe nii ana dzoobiretake abi tupu mina qooro oorai nokoi poiqake moo nooka qupadzoma quba ana paata hiire. ");
INSERT INTO ghs_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Hiireqi noi dzaubama sokateqi hee, Dzasaro, Nii ao biranatare. ");
INSERT INTO ghs_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Hiiremi abi baateta noi ao biranateta. Oonihe noho oko ma boto ttobama qegoromi oota oho qesa too ma koko noho gama sengibete oomi Dzesui hiireta, Noke saqoromi noomae tuumare. ");
INSERT INTO ghs_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Hiiremi Dzuta abi Mariaho toro oota nokohota samanei Dzesuho baura mooqi noke ai tataumata. ");
INSERT INTO ghs_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Qate qesai noke papateqi Dzesu baura oke eeteho isere Pariseoho toro mootota. ");
INSERT INTO ghs_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mootomi Pariseo nokoi dzube abi mimima gama ttutturateqi hiireta. Abirai baura samane eetemi Ohongaho mumure naatoraita napa ikanomake eetaqu? ");
INSERT INTO ghs_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Napai noke qaanataama naatemi abi gama susupu noke nooka hisi eetemi Romaho gamamani baaqi biiri ma haba ma abi gama rubengaitakoi ooiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Oonihe Kaipa noi tii oho bodzata dzube abi minai qaatanita noi too abiho isakita noko pobi hiireta, Nike ruume baurake eetorai. ");
INSERT INTO ghs_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Abi minarai dzaetainoho quba abi teenaqai baatemi nike qupadzomami bamu isanataqu mae? ");
INSERT INTO ghs_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Qate noi te noomae qupadzomaqi hiibaranihe noi Ohongaho dzube abi mina oomi Sumasai noho irita baura eesumi noi too abiho isakita hee, Dzesui Dzuta abi minaraho habara naate baatakoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Oonihe oi Dzuta abi keke bahe Ohongaho khameto haba samaneta ooqi tupu teena naatarotaho quba hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Oke hiiremi nokoi ao Dzesuho suu ma pai mootomi qaata. ");
INSERT INTO ghs_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Oho qubake Dzesui Dzuta haba paata tuumarotaho isakiama naatemi Eparamu nagapa oi haba habanaho patisigita oomi noi ota tuumaqi tumakhameto nomema gama oota. ");
INSERT INTO ghs_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Qate Dzuta abiho Ingona dzuma dzamoihimi abi qeba nena nokoi kiridza qere qaataho tuputa qeemaqa kahosa nokome kuibidzare hiireqi Dzerusaremuta peiteta. ");
INSERT INTO ghs_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Peitemi Pariseo ma dzube abi mimi nokoi noo tatanga hiireqi hee, Dzesui ikata oorai oke abi teei gesina naataquko ango paanaitemi nana noke suutakoi ooiqi hiireta. Hiiremi abi samanei biirita qesa saridzeqi hee, Nike qupadzomami noo bamenoma oi ooraimi Dzesui dzumarata baabaqu mae bamu? Oke hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Oonihe Ingona dzumai qupi 6 naataamake oomi Dzesui aoke Bettania nagapata biranate Dzasaro (apeke bosata eehahaiteta) noho nagata peiteta. ");
INSERT INTO ghs_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Peitemi nokoi noke tuuhoro hoo ma patta mootota. Mootoqi Mattai khautomi Dzasaroi Dzesuma nokoi qidzanate patta muunata. ");
INSERT INTO ghs_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Muunomi Maria noi oba ura moromoronoma, mutusa qidza, ttuma minanipamu oke isaki teeke aima baaqi ooma Dzesuho oko suraiteqi qiba gee nomema oko nohoke dzamutota. ");
INSERT INTO ghs_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Oba oho ura oi naga masubate oota. Oonihe Dzesuho tumakhametohota tee, Dzuta Kariota nena ikai noke geema mootarota, noi niqi hiireqi hee, ");
INSERT INTO ghs_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Oba uranoma oho ttuma quba hiibapuko ao tu hattatti kina biranatarori. Oke eetemi abi habanai oho meke saridzarori. ");
INSERT INTO ghs_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Oiqi hiireta oi Dzutai te abi habana oho qupa muunaqi hiibaranihe, noi tumakhametoho oma sengi soopara eete qaaqi bodza qesata ota nome quba guume eete qaata oho qubake hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","8","Hiiremi Dzesui hee, Eo, eto Mariake noosa hiibaino. Oi abi habanai bodza samane nikeho toro oorami nokoke kokora eetareiqa eetorakoihe anai bamu bodza mina nikeho bisata ooraqu. Oonita abi naho keba qurabidzakoiqi hiireqi atapa erai ao anake kokora erake eete, oonita oke noho neta karabetemi bamu isanataqu. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Oonita Dzesui Dzasaroho nagata ootake Dzuta abi nookaqi abi samanenipamu nokoi Dzesu keke bahe Dzasaro apeke Dzesui eehahaiteta nopoke moorare baata. ");
INSERT INTO ghs_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Oonita dzube abi mimi paha Dzasaroke bisi naate noho suu ma pai mootota. ");
INSERT INTO ghs_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Oi teeho quba bahe Dzuta abi samane Dzasaroke moo qupadzomaqi Dzesuho toro atimata. ");
INSERT INTO ghs_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","Qate iihai mootomi abi samane dzuma eetare baaqi nookami Dzesui Dzerusaremuta peitarota. Oho quba nokoi ee hehenake aimaqi noke dzeima quba tuumaqi sokateqi hiireta, Dzoobe dzoobe, Ohonga Sooparaho dzaapai Isirae abiho qiba naatareiqi baabe. ");
INSERT INTO ghs_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Oke hiiretahe Dzesui ttogi khata teeke saridzeqi peite tuumata. ");
INSERT INTO ghs_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Oonihe noi teeho quba peitaranihe Sinabidzata qeetemi oorai oi hee, Dzerusaremu ma Dzioho paimane nike atti eetaino. Oi nikeho abi qibai hasu quba ttogi khata peite baaqoraiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Oonihe, noho tumakhameto te bodza ooqata khooba qupadzomara. Oonihe ipita Dzesui qoridze dzadzata peitemi nokoho qupa pobiratemi qetaqeta bosana hiireta ma abi noke oonoma eetetake noko gama qupadzoma soubireta. ");
INSERT INTO ghs_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Oonita Dzesui Dzasaro eehahaiteta bodzata abi oke mooqota nokoi oho isere qidza Dzerusaremuta mootomi, ");
INSERT INTO ghs_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","abi samane baura oho pobi nookaqi oho quba Dzesu moorare biranateta. ");
INSERT INTO ghs_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Oho quba Pariseo nokoi qesa pobipobi hiireqi hiireta. Moorare, Abi samane mutu ma khatai gama noke iihoraihe, napa bamu, oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Qate Giriki abi qesai dzumata sererahuke Ohonga pupu hiibare baata. ");
INSERT INTO ghs_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Baaqi nokoi Piripi, Garirea habaho nagapa Besaitaho nena, noho torota baaqi hee, Mai naname, Nanai Dzesu moorare hiireqi baabe. ");
INSERT INTO ghs_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Hiiremi Piripi qeemaqi Attereo pobi hiireqi nopo esese Giriki abiho noo Dzesuke pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Hiiremi Dzesu oho noo ipike hee, O dzoobe, oke eete Abiho Isaki anaho dzapa pobi haba biidzaridzoni. ");
INSERT INTO ghs_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Oonihe qahura erake qupadzomare. Seporaho gottarai ttokata taate ari naataama nataquko oi noqeke ooqa bamu haba biidzaqu oke ana bamu nike ikobetaqu. Oonihe ttokata taate ari naatemi sepora samane ao haba biidzakoi. ");
INSERT INTO ghs_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Oi teei qaraqara nome qaanataquko noi meupu oho dzore naatakoi. Qate teei ttokaho qaraqara nome qaanataama naataquko qaraqara meupunoma oi noho pobi naate qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Oonita teei anake tuuhobare hiibaquko noi naho tete oke iiha qaaqake, ana peitaquta tuhotuho nahoma nakamae oorakoi. Ma apei ana oonomake tuuhobaqu noho dzapake Ohonga mai qusubaitakoi. ");
INSERT INTO ghs_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Dzesui hee, Oonihe ana oho noo hiiremi naho beedzae saqobami ana noo apeke hiiremi isanataqu? Ana hee, Mai name, ana kaipota oorami nii ana ingonaitareiqi hiibaquni mae? Oi bamu. Ooqaho qubake ana era baaqori. ");
INSERT INTO ghs_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Hiireqi noi pupu hiireta, O mai, niimaeho dzapa pobi haba biidzare. Hiiremi qusuta totoho teei biranateqi hee, Ana hiiremi naho dzapai haba biire ooraihe minanatare boobi. ");
INSERT INTO ghs_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Oke hiiremi abi samane ota qooro ooqi totoho nookaqi qesai hee, Para hiire. Qate qesai hee, Eo angero teei noo hiire. ");
INSERT INTO ghs_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Hiiremi Dzesui erake hiireta, Noo totoho oi te naho toma quba baahuidzaranihe nikeke qupanomaita quba baahubi. ");
INSERT INTO ghs_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nookare, Ohongai poike ttokaho tete maripa eete oho baisa minanoma Iibadzake qirutomare boobi. ");
INSERT INTO ghs_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Oi ttoka abi nokoi noke qusubaiteqi anake hapahapata ai gosobakoi. Oonihe gosoromake anai abi minarake dzeimami abi samanenipamui naho toro pomai kotobakoi. ");
INSERT INTO ghs_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","O Hiireqi noi ikanomake eete baate dzapa pobinoma naatarotaho nooke hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Hiiremi abi tupu oi hee, Eehe, hu noota qeetemi oorai oi hee, Kiristui baaqanoke, agoba qaarakoiqi hiiremi nana nookorai. Oonita nii ikaqi hiireqi hee, Abiho Isaki anake hapahapata ai gosobakoiqi hiire? Abiho Isaki oi nii ooni mae apeni? ");
INSERT INTO ghs_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Hiiremi Dzesui noko pobi hiireta, Nookare. Dzadzai nikeke baiburorai oi bodza hoteqa. Qupi sooromake abi ao tete qiri eetakoi. Oho quba dzadza nikeke baiburoraiqata ao tete aimare. ");
INSERT INTO ghs_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ana noo hiiremi oi dzadzaho isaki naatemi nike ao qusubaiteqa anake ai tataumake eeteqa nike dzadzaho khameto naatakoi. Noo oke Dzesu paata hiire qaateqi tuumami abi samane nokoi noke te paha mooraama naateta. ");
INSERT INTO ghs_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Oonita dzesu baura samane abiho pengata eetemi Ohongaho mumure naate qaata oonihe ikanomake eete abi samane te noke ai tataumanipamuke eetara? ");
INSERT INTO ghs_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Oi teeho quba bahe Dzesea hiiretaho isaki naateta. Noi hee, O Soopara, beedzae niihoke abike gama paanaitemi oorai oi nanai oho isere gama mooto soubireta. Oonihe apenei oke nookaqi hisi eetorai? ");
INSERT INTO ghs_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Oiqi hiiretaho isakita noko hisi eetare hou eeteta. ");
INSERT INTO ghs_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Oi Dzesea paha hee, Noko eto nese nokomema moomi qupa nokohoi uhubami noko naho toro burisi eetemi ana Ohongai nokoke qidzaitainoiqi noko hiiremi anai oho quba nokoho nese kotoroqi qupa nokohoke pui siiremi oorai. ");
INSERT INTO ghs_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Oiqi hiireta oi Dzeseai Ohongaho dzapa pobi ma beedzae moomi suqobidzanoma naatemi oke eete paanaiteta. ");
INSERT INTO ghs_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Oonihe Dzuta abi mimi qesai qupata Dzesuke hisi eetetanihe, Pariseoi nokoke sinabidza guhu tete qaanatainoiqi hiireqi oke nokomae qahitoto qaata. ");
INSERT INTO ghs_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Oi nokoi teqaha Ohongaho dzapa pobi quba dzaodzao eetaranihe, abiho penga quba ququimata. ");
INSERT INTO ghs_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Oonita Dzesui sokateqi erake hiireta, Nookare. Teei naho dzapata atimaqu oi naho dzapa keke bahe Mai ana dzoobireta noho dzapata noi atimakoi. ");
INSERT INTO ghs_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ma teei anake moo qupadzomaqi mai ana dzoobiretake noi moo qupadzomakoi. ");
INSERT INTO ghs_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Oi anai ttoka abiho bisata dzadzaho isakita baiburorai. Oonita apema apei naho dzapata atimaqu, bamu qupita basa qooto tuumoraqu. ");
INSERT INTO ghs_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Oi anai te ttoka abike qahitota quba baabaranihe noko gama qidzaita quba baata. ");
INSERT INTO ghs_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Oho quba teei naho noo nookaqi qusubaitaama naataquko ana bamu naamae noke qomaqoma hiibaqu. Oi bamuhe, naho noo ago hiiremi oorai oi abi naho noo nookaqi anake basesa eetorai nokoke qomaqoma hiibakoi. Ana ago hiire qaate oorai noo oi ipi bodzata abi oke suutakoi. ");
INSERT INTO ghs_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","50","Oi erake eete oorai. Ana te naamae baaqi noo nameke hiibaranihe, Mai ana dzoobireta noi tete sakateqi hibahiba totoho ana moitorai, hibahiba nohota abi qaraqara tatanga saridzakoi. Oonita ana hiirorai noo oke ana noho toro nookaqi hiirorai. Oiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","3","Qate Siimo Khariottaho nenaho khata Dzuta, noho qupata Saatai ango suu ma pai mootomi noi Dzesu geema mootakoiqi hiire oota. Oonihe Dzesui bosata Maiho neta baata paha burisi eete noho torota peitarota oke mai gama noho botota mootomi oota. Oke Dzesu gama qupadzoma soubireta. Oonita noko gama Ingonaho dzuma eetare boohiqi Dzesui moomi noomae ttoka haba qaate maiho torota peitarotaho bodza ao dzamo naateta. Oonihe, Dzesui tumakhameto nome kokora eete qaata teena oke noi eete soubiremi bodza noho bamu naateta. ");
INSERT INTO ghs_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","5","Oonita surenake noko dzuma oho patta muunare boohitahe, bosata Dzesu qoridze sasa nome kuimaqi sama dzamudzamuke dzapireta. Dzapireqi noi khooruta oba uqumaqi bosaho eete tumakhametoho oko akobete sama dzamudzamu ooma oko nokohoke dzamutare hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Oke hiireqi Dzesu tuumaqi Siimo Peetoroho torota qeemata. Qeemami Peetoroi Dzesu pobi hiireta, Nii ikabeteqi naho oke akobetaqu? ");
INSERT INTO ghs_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Hiiremi Dzesu noke hee, Ana eesubi oke nii poiqa ruumenihe, ipita nii qupadzomakoi. ");
INSERT INTO ghs_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Hiiremi Peetoroi hee, Nii abi minanita bamu anaho oko akobetaqu, baamu. Hiiremi Dzesui hee, Nookao, oko niihoke ana akobetaama naataquko nii bamu anama naka ttaike ooraqu. ");
INSERT INTO ghs_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Hiiremi Peetoroi hee, Oionita oko keke bahe, boto ma qiba ma gama akobetare. ");
INSERT INTO ghs_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Hiimi Dzesui hee, Eo, teei oba taasumake noho sama ao saasari naatemi noke oko (oi oora ma qaaraho qahura) ooqake dzamutakoi. Nike ao saasari naate ooraihe, nikehota teei saasari naate ooraidzarani. ");
INSERT INTO ghs_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Oiqi hiireta oi teeho bahe, Dzutai noke geema mootorata oke noi qupadzomaqi hee, Nikehota teei saasari naate ooraidzaraniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Oonita poma nokomeke iihaqi Dzesui nokoke kokora eeteqi nokoho oko gama akobete soubireta. Oke eeteqi noi paha sasa nome dzaaroqi habese noko qasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ana eete oho khoobake nike qupadzome mae? Nike anake hee, Banaita ma Sooparaniqi hiirorai anai oho isakita nikeke kokora eetorai oonita oke nike meeke hiirorai. ");
INSERT INTO ghs_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Oonihe anai nikeho Soopara ma Banaita ooqi nikeho tteki aima qaabi oonihe poiqa nikemae ipibireqa qesaqesaho tteki aima qaarare. ");
INSERT INTO ghs_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Oi ana oora ma qaaraho akoako tete nike banaitemi oke nikemae ipibire eetorare. ");
INSERT INTO ghs_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tete erake eete oorai. Kokora abi noi Soopara nome beekho eetaquho tete bamu, eo qaru khata noi mai nome riitaquho tete bamu. ");
INSERT INTO ghs_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Noo oke nike nookehe, oke nike qusubaite qaamake nikeho isaki bagenoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ana nike gama asatetake ana gesina, oonita ana hiire noo oi ao nikeho naate. Oonihe nikehota teei oorai noho nooi bamenoma. Oi noo teeke sinabidzata qeeteta oi meenoma naatake boobi. Oi hee, Teei anama naka ttaike patta muunoraihe noi ana qorobidzare boobi. ");
INSERT INTO ghs_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Oiqi hiiremi ooraita oke ana nike qupanomaitemi oi meenoma naatemake nike anake qupadzomaqi hee, Meeke Dzesui Agoago khata ooniqi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","21","Oonita anai abi qaru dzoobiremi teei qaru abi oonomake kokora eetaqu oke eesuqi noi anake kokora eetakoi ma paha Mai ana dzoobiretake kokora eetakoi oi bagenomanihe, iidzi nikehota teei ana geehibi oio bamenoma. Oke ana bamu nike ikobetaqu. ");
INSERT INTO ghs_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Dzesui Dzutaho noo oke qahurata hiireqi noi hekhettidzaita. ");
INSERT INTO ghs_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Oho quba tumakhameto roqobeteqi qesa qeraqera eeteqi hee, Apehoke noi hiire? Qate Dzesui tumakahta Dzohane anaho dza mina eete qaata. ");
INSERT INTO ghs_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Oonita anai Dzesuho dzaganipamuta oomi Peetoroi anake toone eeteqi hee, Dzesuke qasa hiiremi noi abi oke paanaitareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Hiiremi anai Dzesuho dzagata tirere eete seike qasa hiireta, Soopara, abi nii geema mootaqu oi apeni? ");
INSERT INTO ghs_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Hiiremi Dzesui hee, Anai patta ponabete abi moitaqu abi oioni. Hiireqi noi patta oke suuta suqobire Siimo Khariotta nenaho khata Dzutake moitemi muunata. Muuhimi Saatai ao noho qupake mai eeteta. ");
INSERT INTO ghs_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mai eetemi Dzesui Dzutake hee, Niiho qupana oorai oke hiariamake eetare. ");
INSERT INTO ghs_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Oiqi hiiretahe seike hiiremi minara patta muunota nokoi te nooka pobitara. Qesai hee, ");
INSERT INTO ghs_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Noi oma sengi sooparanita Dzesui hiiremi noi quba teeke dzumaho quba ttuma eetareiqi hiire kaqa, Eo ttuma teeke abi habana moitareiqi hiire kaqa, Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Oonita Dzutai patta oke muunaqi tta eeteqi kha qupita tuumata. ");
INSERT INTO ghs_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Dzutai tuumami Dzesui hiireta, Oionita poiqa Abiho Isaki anaho dzapai minanatakoi. Minanasuhimi Ohongaho dzapa oho qesa minanatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ana hiiremi Ohongaho dzapa minanatemi oho qesa Ohongai hiiremi naho dzapa minanatakoi. Oonihe noi hiiremi ao hairiamake minanatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Khameto name dzasa. Anai ao nike qaasubi. Qaate tuumami nike naho qiri eetakoi. Oonihe ota naho toro baabaquho tete bamu naatakoi oke ana bosata Dzuta abi pobi hiireta teena oke paha nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Oonihe nikeqaho qubake ana pai erake moote. Anai nike dzaira eete qaabi oho isakita qesa nikeme dzaira eete qaarare. ");
INSERT INTO ghs_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Oi nikeme qesa dzaira eete qaama abi minarai oke mooqake hee, Dzesuho tumakhameto oioniqi hiibakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Hiiremi Siimo Peetoro noi Dzesuke hee, Oonihe nii ikata tuumakoiqi hiire? Hiiremi Dzesui baatahoke hiireqi hee, Nookare anai tuumami nii bamu poiqake oho tete iihaquhe ipita nii oho tete saridze ana iihaqa nakamae oho ttaiqa naatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Hiiremi Peetoroi hee, Mmhm, Ana niiho quba baatareiqa baatakoi oonita ana naane quba nii iihaama naataqu? ");
INSERT INTO ghs_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Hiiremi Dzesu noke hee Oo, nii naho quba baataqu mae? Nooka, nee ungapai noo hiibaamake nii anake gaubire raraku biidzaama naatakoi, oonihe ao tapari naatakoi. Oke ana bamu nii ikobetaqu. ");
INSERT INTO ghs_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Dzesui hee, Oonihe nike eto qupa muunaino. Nike Ohongake ai tataumaqi oho qesa anake ai tatauma qaarare. ");
INSERT INTO ghs_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Oi Mai nahoho nagapata suruho samane nikeho quba oorai. Ooraama naatapuko oke ana ao nike pobi hiibarori. Oonita ana tuumaqu oi teeho quba bahe ana nikeho quba isaki roibetare tuumakoi. ");
INSERT INTO ghs_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Teka ma isaki nikeho quba roibeteqanoke ana burisi eete baa nike dzeima anama napai gama teenata qopa koobire qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Oonita anai tuumaqu oho qopa ma teteke nike gesina naatorai. ");
INSERT INTO ghs_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Hiiremi Ttomai hee, Soopara naname, nii tuumaqu tekake nana nookaamanita ikabeteqi oho tete saridzaqu? ");
INSERT INTO ghs_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Hiiremi Dzesui noke pobi hiireta, Ana naamae minaraho mee ma tete ma qaraqara oonita teei anake potti biireqi bamu Maiho torota biranataqu, baamu. ");
INSERT INTO ghs_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Oi nike anake gesinanipamu naatapuko ao Mai nahoke gesinanipamu naatarori. Oonihe aoke nike noke mooqi isakiqata gesina. ");
INSERT INTO ghs_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Hiiremi Piripi hee, Soopara naname, Mai niime nanake banaitemake nanata isanatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Hiiremi Dzesui hee, Piripi ana nikeho toro agoba qaabi oonita nii ikanomake eete anake gesina naataama? Nookare. Teei anake moo pobiteqi mai nahoke moo pobitorai. Oonita nii ikanomake eeteqi hee, Mai niime nanake banaitareiqi hiire? ");
INSERT INTO ghs_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Mai ma nakamae qesa dzaga boboto baaqoraike nii qupadzome mae? Ana nike noo hiirorai oke ana te naamae hiiroraidzaranihe, Mai naho toro baura eetemi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mai ma nakamae qesa dzaga bobotorai oke nike qupadzomare. Eo oho ruumeke naate baura ana eetoraike nike qupadzomare. Meenipamuke ana nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nikei ana nooka hisi eeteqi baura ana eetoraike nike paha eetakoi. Oonihe ana Mai nameho torota peitakoi oho qubake ana eetoraiho isakita nike ipibireqa minanipamuke eetorakoi. ");
INSERT INTO ghs_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Oi nike naho dzapata atimaqi quba tee ma teeho quba hiiremi ana nike moitemi Ohonga mai noi khataho nookami nee ma baunoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Oonita nike naho dzapa quba eeteqi teeho quba hiiremi ana qusubaitakoi, oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Oonihe nike naho dzake eetaquko ana pai qesa mootomi oorai oke nike iso keke qusubaite soubidzakoi. ");
INSERT INTO ghs_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Oi teeho bahe anai Mai pupu hiiremi noi hobihobi teeke paha nikeho quba dzoobiremi noi nikeke beedzaenomaite tuuhoro agoba qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Dzapa nohoi Sumasa meenoma. Oonihe ttoka abi nokoi noke ruume, noke mooraamanita qidzoke noke gesina naataqu. Qate noi nikeho bisata ooqa nikeke tuuhoro qaama meeke nike noke gesina naatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Oi anai bamu nikeke toki ma hoeboho isakita qaataquhe ana oho isakita paha nikeho toro biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ttoka abi nokoi ana mooraama naatake boobihe nike anake Sumasaho isakita mooqorakoi. ");
INSERT INTO ghs_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Oi anai qaraqarata qaami nike oho qesa qaraqarata oorakoi. Oke eetemi anai maike dzaga bobotomi oho qesa nike ma napa qesa dzaga bobotoraqu oke nike ao ota qupadzomakoi. ");
INSERT INTO ghs_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Oonita apei naho dzaodzao eetoraqu ma naho noo qere biire qusubaitoraqu abi oioni. Noi oho pomata naho dza eetemi Mai nahoi abi oonomaho dza mina eetemi anai paha noho dzaodzao eeteqa isaki name noke banaitemi qupadzomakoi. ");
INSERT INTO ghs_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Hiimi Dzuta, oi Khariottaho nena bahe Dzuta temu, noi Dzesuke hee, Soopara, nii ikanomake eete sama niime nanake banaite qaaqa ttoka abi banaitaama naataqu? ");
INSERT INTO ghs_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Hiiremi Dzesu noke hee, Eo, teei naho dzaodzao eetaquko noi naho noo qusubaitemi naho mai noho dzake eeteqa noma nakamae abi oho toro biranate napai gama oora ma qaara eete qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Qate teei naho gottaeke eeteqi bamu naho noo qusubaitaqu. Oonihe ana noo hiiremi nike nookorai oi naho noo bahe Mai ana dzoobireta noho nooni. ");
INSERT INTO ghs_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Oi anai nikeho neta ooriti tuusubita anai aoke nike pobi hiire. ");
INSERT INTO ghs_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Qate Mai noi Qaheuba Sumasa dzoobiremi Hobihobi noi naho dzapata baaqake ana nike tete banaite qaibi oke noi nike qupanomaite qaaqa quba samane minara nike banaitakoi. ");
INSERT INTO ghs_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nookare. Anai hasuho mai oonita isaki nameke nikeho qupata dzeebiremi nike qangahasita poupaaama naatakoi, oke ttoka abi gesina naataquho isaki bamu. Oonita eto nike quba tee ma teeho qupa muunaino, teeho atti eetaino. ");
INSERT INTO ghs_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Anai ao nikeke hee, Ana tuumaqa paha burisi eete baabakoiqi hiire oi ana mai nameho toro biranatemi noho isaki oi gutu boto kharanita oi ttokaho isaki nahoke riite ooraimi nikeho beedzae ota minanatakoi. Oho qubake ana tuumareiqi hiire oho khoobake nike bageke eete qupadzoma soubidzaquko qaki naatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ana aoke nike oho pobi hiirenita oi mee naatemake nike qupadzomakoi. ");
INSERT INTO ghs_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Dzasa, ttoka abiho mai Iibadza noi baahutita napa noo erake kharaitaquho isaki bamu. Oi noi naho irita haa eetarorihe, baamu. ");
INSERT INTO ghs_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ttoka abi ma nike gama moomi anai Mai nameho dzaodzao eeteqi noi ana pobi hiiremi ooraiho baurake ana qusubaite soubidzaridzoni. Oionita napa qoridze tuumaqa oke soubidzare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Oonita nokoi dzoo ota tuusuqi Dzesui hee, Anai eka meenomaho khoobani qate naho Mai ekaho pobipobi. ");
INSERT INTO ghs_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Oonita oqina meeama qesai naho torota ooraquko Mai oke geema biidzakoi. Qateqa oqina qesai meenoma ooma oke noi pobite kokora eetemi noho mee qidza gaira naatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Oonita ana Maiho noo nike moitemi oi ao nikeho qupake pobitemi oorai oke qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Qate oqina teei eka khoobake qaataquko nomae mee goomaquho tete bamu. Nike oho qesa anake qaate mee eetaquho tete baamuta napa qesaho toro atima qaarare. ");
INSERT INTO ghs_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Oi anai eka khoobani qate nike oho iqina, Nike naho amake baura apeke eetemi meenoma naataqu? Baamuta napa qesaho toro atimami meenoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Oonita teei naho toro atimaama naatemi Mai noi pare oke kuibiremi sasata ngorubatemi nokoi quba oonomake ttuttuite eepata biiremi qaite bamu naatakoi, oke qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Oonihe nike naho toro atimami naho nooi nike uumami nike bauraho quba teeho dzake eete pupu hiiremi oi ao nikeho pobi naatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Oonita nike naho tumakhametonipamu naate mee samaneke goomami mai nahohota nee ma baunoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nookao. Naho mai anaho kokora eete baaoraiho isakita anai nike kokora eetoraita nike kokora baura oke ipibire eetorare. ");
INSERT INTO ghs_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nike naho noo qusubaitoraquko, ana nike kokoraho tete banaitorai oke ana bamu nikeke qaanataqu. Oi anai mai nameho noo qusubaiteqi kokora baura noi paanaitemi oorai ota ipibire qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Noo oke ana teeho quba nike pobi hiidzaranihe naho qupa qidzaqidza oorai oi paha nikeho naatemi nikeho qupa qidzanipamu naata qubake hiirorai. ");
INSERT INTO ghs_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Oonita anai nike kokora eete qaabi teteke nike ipibire qesaqesaho kokora eetorareiqi ana pai oke moote. ");
INSERT INTO ghs_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tete erake eete oorai. Abi teei dzairamane nomeho habara eete baataqu teei kokora baura oonomake riitaquho isaki bamu. Oonita anai pai mootomi oke nike qusubaitemi anai isanate nikeke hee, ");
INSERT INTO ghs_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Naho dzairamaneniqi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Oi tuhotuho abi teei mai nomeho qupa ruume. Qate anai bamu nikeke hee, Naho tuhotuhoniqi hiibaquhe noo samane ana maiho toota nokata oke gama ana nike pobi hiiremi nookoraita ana nikeke ringiringinaisubi. ");
INSERT INTO ghs_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Oi nike te anake asatarani. Anai nikeho dzohidzohi mai nikeke asate dzoobiremi nike bauraho mee samane goomami souba sakabaridzoni. Oke eetemi nike Maike quba tee ma teeho pupu hiiremi noi nahoke qupadzomaqi oke nike moitakoi. ");
INSERT INTO ghs_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Oho isakita nike qesaqesaho kokora eete qaarare. ");
INSERT INTO ghs_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Oonihe ttoka abi nokoi nikeho ibo eetemake nike hee, Oo noko bosata Dzesuho ibo eetetai eetoraiqa hiibare. ");
INSERT INTO ghs_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Oi nike ttokaho pobi oorapuko nokoi nikeho dzake eetarorihe, ana nike asatemi nike mainaho pobi naatemi oho quba ttoka abi nike ibo eetakoi. ");
INSERT INTO ghs_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Oonita ana bosata nike noo hiireqi hee, Tuhotuho abi nikei Soopara nikeme anake beekho eetaquho tete bamu. Ttoka abi nokoi naho ibo eetoraiqi nikeho ibo eetakoi. Oiqi hiiretanita qupadzomare. Nokoi naho noo nookaama naatetaho isakita nikeho noo nookaama naatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Oi mai ana dzoobiretake noko ruume naatemi nike tete bamenoma samane nokoho torota saridzakoi. ");
INSERT INTO ghs_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Anai baaqi nokoho torota noo hiibaama naatapuko nokoho kahosa oi bamu bamenoma naatarorihe poiqa noko quba apema kahosa bamenoma nokome sirihaqu? ");
INSERT INTO ghs_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Baamu, teei anake ibo eeteqi mai nahoke ibo eetorai. ");
INSERT INTO ghs_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Anai baura samane nokoho torota eete qaabi oke paha apei eetaquho isaki oorai? Baamu. Baura oke ana eetaama naatapuko nokoho kahosa bamenoma ooraama naatarorihe, noko ana keke bahe mai nahoke mooqi ibo eetorai. ");
INSERT INTO ghs_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Samu teeta erake qeetemi oorai, Khooba amata noko sepeke naho ibo eetorai. Oonita noo oi nokoho neta meenoma naatorai. ");
INSERT INTO ghs_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","27","Oonita nike ana ma napai khoobanipamuta baura eete baaqorai oonita nike naho khooba hiire paanaitare. Qate Hobihobi ana hiire noi Maiho nena oorai oonita ana noke nikeho quba dzoobiremi baaqake noi nike hoobire naho khooba hiire paanaitakoi. Noio Sumasa meenoma. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Dzesui hee, Ana noorake hiiremi eto nookami qanganataino. ");
INSERT INTO ghs_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Oi noko nikeke sinabidza guhuta hotou biidzakoi. Oi keke bahe, qesai Ohongake kokora eetareiqa nikeke teete baatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","4","Oi teeho quba bahe noko Mai ma nakake ruumeke naate eetakoi. Bosata ana nikema napamae oota oho quba ana te oho noo hiibaranihe noko oonoma eetaridzoho bodza biranatemi nike ao khooba qupadzoma quba anai poiqa nike pobi hiiremi nooke. ");
INSERT INTO ghs_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Dzesui hee, Qate Mai ana dzoobireta noho torota ana poiqa tuusuhimi nike anake hee, Nii ikata tuusubiqi hiibaquho isaki bamu. ");
INSERT INTO ghs_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Oonihe, ana noo oonoma hiiremi ikanomake eete dzasai nikeke suqobire? ");
INSERT INTO ghs_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Oonihe ana bamu nike ikobetaqu. Ana tuumaama nataquko Hobihobi Noi bamu baabaqu. Oonita ana tuumaqu oio tete qidza. Tuusuhiqa ana Hobihobi dzoobiremi nikeho toro baabakoi. ");
INSERT INTO ghs_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Noi baaqanoke ttoka abiho torota kahosaho noo ma pobipobiho noo ma maripaho noo oke noi gama tototo hiire paanaitakoi. ");
INSERT INTO ghs_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Oi basesanoma nokoi anake nooka hisi eetaama naatemi Hobihobi noi oho kahosa paanaitakoi. ");
INSERT INTO ghs_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Qate ana mai nameho torota tuumami nike ana mooraama naatemi pobipobi eetaquho teteke noi paanaitakoi. ");
INSERT INTO ghs_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Qate ttokaho Maike ao batabire oomi Hobihobi noi kahosa ipi saridzaquho teteke rerengi eetakoi. ");
INSERT INTO ghs_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Noo samaneke ana paha nike pobi hiibarorihe, dzaasa, nikeho toma susudzatemi nike nookaquho isakiama naate. ");
INSERT INTO ghs_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Oonihe Sumasa meenomai baaqake bamu noo nomeke hiibaquhe noi nookorai oke no hiibakoi. Noi nike dzeimami nike tete mee gama saridzakoi, ma ipita biranataqu oke noi paanaitemi qupadzomakoi. ");
INSERT INTO ghs_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Noi nahota giimaqi nikeho quba paanaitemi naho dzapa pobi biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Oi maiho botona oorai oi gama noho pobi oni. Oho quba anai hee, Hobihobi noi naho ttuta giimaqi nikeho quba paanaitakoiqi hiire. ");
INSERT INTO ghs_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Bodza hoteqake nike ana moohiqa mooraama naatakoi oonihe paha bodza hoteqake mooraama naasuhiqa paha hobihobiho teteta moorakoi. ");
INSERT INTO ghs_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Oke Dzesu hiiremi tumakhameto qesai qesa pobipobi hiireqi hiireta, Noi ikaiqi hiireqi hee, bodza hoteqa ke nike ana moohiqa mooraama naatakoi, ma bodza hoteqake mooraama naasuhiqa paha moorakoiqi hiirorai? ");
INSERT INTO ghs_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Noi paha hee, Ana Maiho torota tuusubi, oho quba oke hiireqi noi ikaqi hiire? Bodza hoteqa oi ikanomani. Noi hiiroraike napai ruumeni. ");
INSERT INTO ghs_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nokoi oke hiireqi Dzesuke oho qasa hiibare boohimi Dzesu ao qupadzomaqi noko pobi hiireta, Anai hee, Bodza hoteqake nike ana moohiqa mooraama naatakoi ma bodza hoteqake mooraama naasuhiqa paha moorakoiqi hiiremi nike tete qirike eete qesa qasa hiirorai mae? ");
INSERT INTO ghs_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nookare. Ttoka abi nokoi bisata qaki ma naki eetakoihe, nike oho tti ma ttaka hiibakoi. Oonihe aoke nikeho qupa bameke tiibetemi oi qidzaqidzaho isaki naatakoi. Oke meeke ana hiibi. ");
INSERT INTO ghs_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tete erake eete oorai. Atapa teei khata dzoomare heme moorai oi teeho quba bahe, oi oho bodzani. Qate noi heme mooqoraqutoke khata dzoomaqa moomi ungapanita noi heme oke ruume naate qaki naatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Oho qesa poiqa nikeho qupa heme eete ooraihe, anai ipita paha nike moohimake nikeho qupa qidzanipamuke naatakoi. Qate qupa qidzaqidza nikehoke apei karabetaqu? Oi baamu. ");
INSERT INTO ghs_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Oonita nike ruume noo poiqake hiirorihe ao paana naatakoi. Meeke anai hiibita nike naho quba eeteqa Maike quba teeho pupu hiiremi moitakoi. ");
INSERT INTO ghs_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Oi nike Ohonga pupu hiireqi naho dzapa quba hiibaamake qaarita poiqa nike naho quba eeteqi hiireqake saridzakoi. Saridzemi nikeho qupa qidzanipamu naatakoi, oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Dzesui hee, Nookare. Anai hoore noo samane erake hiire baaoraihe poiqa ana mee oho isakita hiireqa maihoke ana paanaite hiiremi nike nookorakoi. ");
INSERT INTO ghs_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Poiqa nikemae Ohonga pupu hiireqa naho dzapa quba hiiremi mee eetakoi. ");
INSERT INTO ghs_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Oi anai nikeho habara eete pupu hiiremi bamu ooqaho quba mee eetaquhe, anai Ohonga maiho nenanita oke nike qupadzomaqi naho dzake qusubaitemi oho quba mai noomae nikeho dzake eete moitakoi. ");
INSERT INTO ghs_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Oi ana maiho neta baaqi ttoka abiho bisata qaarita burisi eete maiho torota ruusuhimi nike naho quru khameto naatemi mai oke gama qaupuitakoi. ");
INSERT INTO ghs_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","30","Hiiremi tumakhameto nohoi hee, Oo dzoobe, nii hoore noota hiire qaarita poike paanaite hiiremi, nana qupadzomami nii quba minara gesina naatemi abi teei niike beekho eetaquho isaki ooraama. Oonita nii Ohongaho beedzaeta baaqoraimi nanai niiho neta soomoraqu oke nanai poiqa nookami pobirate. ");
INSERT INTO ghs_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Hiiremi Dzesui hee, Iidzo, nike nookami pobirate mae? ");
INSERT INTO ghs_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nookao, aoke nike anake qaate tee ma teeta sakaba tuumake boohimi ana naqeke oorake boobi, oonihe nike ikaqi oke hiire. ");
INSERT INTO ghs_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nookare, ana oho noo teeho quba hiibaranihe nike naho toro sooma quba hiiroraihe nike ttokaho torona mina saridzake boobi. Oonihe mai ma nakamae ooraita anai torona nikehoke ao qogoimakoita eto atti eetaino. Oiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Qate Dzesu pupu hiireqi nese qusuke mooqi hiireta, Mai name, bodza ao bamu naate oonita nii khata niimeho dzapa pobi paanaisuma anai oho qesa niiho dzapa pobi paanaitakoi. ");
INSERT INTO ghs_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nii hiiremi anai abi minara pobitaquho isaki naateqi abi nii ana moitemi ooraike ana qaraqara tatanga moitorai. ");
INSERT INTO ghs_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Oonihe abi nokoi Ohonga meenoma niiqake gesina naataqu ma nii Dzesu Kiristu anake dzoobire baatake noko gesina naataqu oio qaraqara tatangaho mee. ");
INSERT INTO ghs_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Oi nii anake baura moiteta oke ana eete soubireqi ttokata niiho dzapa pobi paanaitemi gesina naatorai. ");
INSERT INTO ghs_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Oonita agobanipamuke nii hiiremi anai ttoka ma haba biraiteqi oho dzapa pobinomai qaatanita nii hiiremi anai paha (ingona) biraiteqa oho pobinoma naatare. ");
INSERT INTO ghs_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Oi nii abi qesa naho botota mootomi anai dzapa pobi niihoke nokoho quba paanaite soubidzare. Nokoi niiho botota oomi nii noko naho botota mootomi noko niiho noo nooka qusubaitorakoi. ");
INSERT INTO ghs_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nii ana moitetaho isaki oi gama niiho nena baatake noko ao qupadzomorai. ");
INSERT INTO ghs_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Oi nii ana noo banaiteta teena oke ana nokoke moitemi aribidzaamanihe nii ana dzoobiremi ana dzubina niihoho nenake noko gama qupadzomorai. ");
INSERT INTO ghs_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","10","Oonita anai te ttoka abiho quba poiqa pupu hiibaamanihe, anai tumakhameto nokoho quba pupu hiire. Noko niiho pobi oomi nii nokoke naho botota mootomi anai nokoqaho quba pupu hiire. Oonihe naho pobi oi niihoni ma niiho pobi paha nahonita noko anahota dzapanoma naataridzoni. ");
INSERT INTO ghs_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Qate nokoi erata ooraimi anai nokoke ttokata qaateqi niiho torota qeehibi. Oonita Qaheuba Mai name, nii ana moitemi oorai abi oke nii dzapa pobi niimema sahotomi nakamae teenata ooraiho isakita nokoma napa gama teenata oorare. ");
INSERT INTO ghs_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Oi nokoma nanai qaaqi ana dzapa pobi niihoma nokoke sahoto qaari. Nii ana moiteta oke ana gama bakena geemami noko qidzake ooraihe meeke sinabidzai oho qamodzamodza hiiretaho isakita Dzuta Iibadzaho pobi noio bamu naate. ");
INSERT INTO ghs_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Oonita ana ttoka qaasuhiqi naho dzaodzao nokoke khakhoro biirorareiqi ana niiho noo nokoke moitemi nookorai. ");
INSERT INTO ghs_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Oonita anai ttokaho pobiama naatemi noko oho qesa oho pobiama naatemi ttoka abi nokoke ibo eetaridzoni. ");
INSERT INTO ghs_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Oonihe nii nokoke ttokata hiuma quba hiiroraidzaranihe, nokoi eto Saataho kabira naatainoho quba nii noko bakena geemareiqi ana hiire. ");
INSERT INTO ghs_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Oi anai ttokaho pobi bamu oho qesa noko oho pobi bamu. ");
INSERT INTO ghs_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Oonita niiho noo oi meenoma keke. Ooma nii isanate nokoke pona hiibare. ");
INSERT INTO ghs_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","19","Oi nii ana dzoobiremi ttokata baataho isakita anai nokoke dzoobiremi ttokata abiho bisata oorakoita oi ana nokoho quba paha sama name pona hiiremi nokohota pona oi meenomanipamu naatare. ");
INSERT INTO ghs_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Oonihe anai te nokoqaho quba keke pupu hiiroraidzaranihe, nokoi sinabidza oke ape ma apeho toro hiiremi nooka tani naataqu nokoho quba paha pupu hiirorai. ");
INSERT INTO ghs_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Obete Mai nii ma nakai qesa dzaga bobotoraiho isakita noko nakama gama qesa dzaga boboto oomake ttoka abi moohiqa nii ana dzoobiretake noko qupadzomakoi. ");
INSERT INTO ghs_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Qate dzapa pobi nii ana moitemi oorai ooma ana noko dzapiremi nakamae teenata ooraiho isakita nokomae teenata oorakoi. ");
INSERT INTO ghs_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Oonita nii ana dzaga bobotorai ana oho qesa noko dzaga bobotorai. Nii ana kokora eetoraike nii paha nokoke eetemi ttoka abi moo qupadzomaqa hee, Meenipamuke Ohongai khata nome dzoobiremi baaqi nokoho bisata ooraiqi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","O Mai name, qusu ma ttokaho husi ma pai biranataamake qaami nii naho dza minake eeteqi dzapa pobi anake moite baa qaabi. Oonihe tumakhameto nii naho botota mootomi oorai nokoi oho pobi mooqorare hiire ana dza eetemi noko anama napa ttaike oorare. ");
INSERT INTO ghs_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O pobipobiho mai ttoka abi niike ruumenihe ana teenai nii gesinanipamu. Oonihe anai niiho neta baami qesaho qupa aoke uhuborai. dzoobe. ");
INSERT INTO ghs_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Oi anai niiho dzapa ma pobi gama nokoho torota paanaitetai paanaitorakoi. Oke eete qaaqi anai nokoma ttaike oomake nii anake kokora eetorai oi paha nokoho oora ma qaarata baura eetorakoi. Pupu oke Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Oonihe Dzesui pupu oonomake hiireta oi noi tumakhameto nomema tuumaqi oba Ketoro biireqi Oriba ee meeho dzoo tuuta tuumaqi noi ota pupu oke hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Oonihe Dzesui qupi samane tuumakhameto nomema nokoi ota ttutturate qaata oke Dzuta gemagema abi qupadzomata. ");
INSERT INTO ghs_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Qupadzomami Pariseo ma dzube abi mimi nokoi hiiremi pirittani eepa ma dzongi ma koo ma tanganomai noke gainene eetemi Dzutai noko dzeima ota biranateta. ");
INSERT INTO ghs_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Biranatemi quba noomaeho irina biranatarota Dzesu aoke qupadzomaqi nokoho toro biranate qasa hiireta, Apeho qirike nike eete? ");
INSERT INTO ghs_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Oonihe Dzutai nokoho bisata qooro oomi nokoi hee, Dzesu nagapa Nadzaretteho nena noho qirike eete. ");
INSERT INTO ghs_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Hiiremi Dzesui hee, Anai erani. Hiiremi noko ubaqomaqi tumereke taateta. ");
INSERT INTO ghs_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Taatemi noi paha hee, Mae apeho qirike eete? Hiiremi nokoi hee, Eo, Dzesu, Nadzeretteho nena. ");
INSERT INTO ghs_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Hiiremi noi nokoke hee, Anai era, oke ana ao nike pobi hiire oonita nike anake saridze oorai. Oho quba naho samaqana oorai nokoke saqoromi tuumare. ");
INSERT INTO ghs_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Oke noi teeho quba hiibaranihe noi ao hee, Ohonga, nii ana moitemi ooraihota anai te teeke sepeke gaubidzaraniqi hiire qaasumi ao noo oho mee ota biranateta. ");
INSERT INTO ghs_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Oonihe Dzesui tumakhameto nome saqobareiqi hiiremi Peetoroi ao hairiamake qaa dzube dzeimaqi dzube abi minaho kokora abi noho toma dzooto qagaumata. Qate kokora abiho dzapaio Marokho. ");
INSERT INTO ghs_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Oonita Peetoro oke eetemi Dzesui noke hee, Maqa, Mai ana maranga biiremi oorai oke anai ikanomake eete oho isaki arabidzaqu? Baamu, oke ana isanate mai eetaridzonita nii dzube niimeke paha quhisanaitare. Oiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Oonita qaa pobipobi noi hiiremi qaa tupu ma Dzuta abi mimiho tuhotuho nokoi Dzesuke suutoqi dzeima tuumata. ");
INSERT INTO ghs_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Qate Kaipa noi tii oho nakuta dzube abi mina oomi noho aimi Anasi urai oomi noko Dzesu dzeimaqi bosa noho torota biranateta. ");
INSERT INTO ghs_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Oonihe oi Kaipa ape bahe bosata noi Dzuta abi mimike sanabidza hiireqi hee, Teei abi minaraho habara eete baataqui isanatakoiqi hiireta abi oioni. ");
INSERT INTO ghs_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Oonihe Siimo Peetoro noi tumakhata Dzohane anama nakai Dzesuke ipotota. Qate anai Dzube abi mina gesina naate qaatanita anai ao Dzesuma gama abi minaho naga repa nakuta qeemata. ");
INSERT INTO ghs_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Qate Peetoroi naga pouta qooro oomi (anai dzube abiho dzaira ooqi) burisi eete biranate repa pouho soopara atapa oke pobi hiiremi nohota isanatemi Peetoro ma nakai repa nakuta qeemata. ");
INSERT INTO ghs_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Qeehimi tuhotuho atapa noi Peetoro mooqi hee, Nii paha Dzesuho tumakhatani kaqa. ");
INSERT INTO ghs_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Hiiremi noi hee Eo, baamu. Qate abi oona oota noko dzapa eete eepa qeere agihimi Peetoro nokoho bisata biranate eepa agimata. ");
INSERT INTO ghs_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Obetemi dzube abi mina noi Dzesuke banaita baura nohoho qasa hiireqi paha tumakhameto nohoho qasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Hiiremi Dzesui oho ipike hee, Abi minarake ana noo paanaite banaitorai. Oi Dzuta abiho sinabidza guhuni mae biirini mae ika ma ikata ttutturatorai ota anai nokoke saridze banaitoraini qate ana te dzukudzukuta noo hiiroraidzara. ");
INSERT INTO ghs_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Oho qubake nii naane quba anake oho qasa hiibaqu? Naho noo nookorai oi abi samanenita nii isanate nokoke qasa hiibare. ");
INSERT INTO ghs_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Hiiremi abi ota qooro oota teei boto qooma hohoite Dzesuke teeteqi hee, Iidzo nii oonomake eete dzube abi minaho noo ipi hiidzo! ");
INSERT INTO ghs_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Hiiremi Dzesui noke hee, Oo ana oberama hiiremake oho baike hiibarenihe, ana hiire oi isanatemi nii naane quba anake teete? ");
INSERT INTO ghs_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hiiremi Anasi Dzesuke paha suutoqi dzube abi mina Kaipaho torota dzoobireta. ");
INSERT INTO ghs_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Qate Siimo Peetoro noi qooro eepa agima oomi qesai noke pobi hiireta, Maa, nii Dzesuho tumakhata ooni kaqa. Hiimi bai hiireta, Anai bamu. ");
INSERT INTO ghs_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Hiiremi dzube abiho kokora abi tee (noi Marokho apeho toma Peetoro dzooto qagaumata noho qesama koko) oonita abi oi hee, Meeke nii ee mee dzoo tuuta oomi anai moori. ");
INSERT INTO ghs_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Hiiremi Peetoro paha bai hiireta. Hiimi idze, Nee noo hiiremi qupadzomata. ");
INSERT INTO ghs_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Qate Dzesuke noko dzeima Kaipaho toro biranate paha kaipake qaate qaa guhu Paraitoriota biranatemi iihai mootota. Oonihe Dzuta abi nokoi Ingona Dzumaho kiridza muunare qupadzomaqi eto oho qaga riitaino hiireqi te Paraitorionipamuta dzuubarani. ");
INSERT INTO ghs_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Dzuubaama naatemi Piratoi biranate nokoke qasa hiireta, Oomaqoma apeho quba noke dzeima baabe? ");
INSERT INTO ghs_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Hiiremi nokoi hee, Eo abirai baura qanga eetaama naatapuko nanai ikaqi hiireqi noke dzeima niho torota baabarori? ");
INSERT INTO ghs_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Hiiremi Pirattoi hee, Isanate noke nike aima huu noo nikemeho isakita pobiitare. Hiiremi Dzuta abi nokoi hee, Eetakoihe, abike teetaquho qaga gamani nanaho torota mootomi oorai ");
INSERT INTO ghs_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Oiqi hiireta oi teeho quba bahe Dzesu bosata ikanomake eete baatarotaho noo hiiremi oho isaki naateta). ");
INSERT INTO ghs_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Oke noko hiiremi Piratoi burisi eete qaa guhu dzuubaqi Dzesuho quba hiireqi noke qasa hiireta, Maa, nii Dzuta abiho abi qibani mae bamu? ");
INSERT INTO ghs_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Hiiremi Dzesui hee, Abi naho khooba paanaitemi nii oho qasa hiire, mae eo niimae oho qasake hiire? ");
INSERT INTO ghs_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Hiiremi Piratoi hee, Anai Dzuta abi apei oho isakita hiibaqu? Oonihe nii ikanomake eetemi niimaeho noo oke nikeho dzube abi mimi ma abi qesa nokoi niike naho botota mootomi oorai? ");
INSERT INTO ghs_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Hiiremi Dzesui erake hiireta, Anai ttokaho abi qibanidzara. Anai ttokaho abi qiba oho isaki oorapuko, naho tuhotuho abi nokoi ao naho tepure naatemi anai bamu Dzuta abiho angita dzubarori. Qate naho pobio mainani. ");
INSERT INTO ghs_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Hiiremi Piratoi hee, Oonita nii abi qiba mainani kaqa. Hiiremi Dzesui erake hiireta. Nii anake hee, Abi qibaniqi hiire oi erake eete oorai. Anai quba meeho maikhata oke paanaitare baami ape ma ape abi meenomani nokoio naho noo qusubaitorai. ");
INSERT INTO ghs_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","40","Hiiremi Piratoi hee, Oonihe meeho tetei ikanomani? Oiqi hiireqi Piratoi biranate Dzuta abi pobi hiireta, Noho oberake ana qiri eete saridzama. Oonita Ingonaho dzumata gamani sutasuta abi teeke nikeho quba saqoro baaorai tete oke iihaqi nike isanate Dzuta abi nikemeho abi qibarake ingonaite saqobaqu mae? Hiiremi nokoi qarutoqi hee, Abi oke bahe Barabake saqobareiqi hiireta. Oonihe Barabai koiri kairiho maikhatanita noko naane quba noqake saqobareiqi hiireta? ");
INSERT INTO ghs_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","2","Oho quba Piratoi nakuta qeemaqi hiiremi qaa abi nokoi Dzesu aimaqi bitte biiroramuti qaateqi qepuqepu hiireqi gupake papara korabete noho qibata dzamotoqi sasa topa dzuunoma aima oke noke dzaarota. Dzaaroqi noko noho toro biranate hee, O dzoobe dzoobe. ");
INSERT INTO ghs_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Dzuta abiho abi qiba nii! Oiqi hiireqi noko boto sepeite noke teetota. Oke eetemi Piratoi paha biranate Dzuta abi pobi hiireta, Nookare. ");
INSERT INTO ghs_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ana abi oke toronaite noho obera saridzaama naateqi noke nikeho pengata moote. ");
INSERT INTO ghs_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Hiiremi Dzesui ttoba topa dzuunoma ma guupaho paparama gama biranatemi Piratoi nokoke hee, Dzasa. Abirake moorare. ");
INSERT INTO ghs_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Hiiremi dzube abi mimi ma nokoho qesamane qarutoqi hiireta, Baamu, hapahapanaitare! Noke hapahapanaitare! Hiimi Pirattoi hee, Anai noho kahosa ruume oonita nikemae noke aima hapahapanaitare. ");
INSERT INTO ghs_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Hiiremi Dzuta abi nokoi hee, Maa, abirai nanaho huke riiteqi sama nome Ohonga kimatetoraita noi oho quba baataridzoni. ");
INSERT INTO ghs_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Hiiremi Piratoi nookami Dzesui sama nomeke kimatetetaho qubake noi atti minake eeteta. ");
INSERT INTO ghs_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Noi Dzesuke dzeimaqi paha qaa guhu dzuubaqi noke qasa hiireta, Niiho khooba ikanoma? ");
INSERT INTO ghs_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Oiqi hiiretahe, Dzesui te oho noo ipi hiibara. Oho quba Pirato noke hee, Maa niike saqobaquni mae hapahapanaitaqu oho isaki naho toro ooraita nii bamu naho noo ipi hiibaqu? ");
INSERT INTO ghs_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Hiiremi Dzesui hee, Nookare. Ohonga qusunai oho isaki niike moitaama naatapuko oke nii anake eetaquho tete bamu naatarori. Oonita niiho kahosa ooraihe Dzuta abi anake niiho torota mootomi oorai nokoho kahosai niihoke riite oorai. ");
INSERT INTO ghs_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Hiimi Piratoi beedzae eete Dzesuke saqobarota qate Dzuta abi nokoi qarutoqi hee, Bamu, teei Kaisaho noo riiteqi sama nomeke noho habara mootare hiireqa oonoma eetakoita nii abi erake saqobaquko nii aoke Kaisaho ibo naatakoi. ");
INSERT INTO ghs_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Hiiremi Piratoi noo oke nookaqi Dzesu dzeima biranate gamaniho qohareta habeseta. Teka oho dzapa Simeri Qohare, qate Heburoho noota oke hee Gabattaniqi hiire qaata. ");
INSERT INTO ghs_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Obete Dzuta abiho Ingona dzumaho roiroi bodza oomi ete bisa naatemi Piratoi Dzuta abi oke pobi hiireta, Nike abi qiba nikeme Dzesuke moorare. ");
INSERT INTO ghs_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Hiiremi noko dzaubama qarutoqi hee, Eo, Noho dzapa ao bamu naatare. Noke hapahapanaitemi bamu naatare! Hiiremi Piratoi nokoke hee, Anai isanate nikeho abi qibake hapahapanaitaqu? Hiiremi dzube abi mimi hee, Bamu, nanaho abi qibaio Kaisa teena. ");
INSERT INTO ghs_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hiiremi Piratto nokoke kebaitare hiireqi nokoi Dzesu hapahapanaita quba noke abi naga nokoho botota mootota. Nokoi Dzesuke mai eete hapahapa moitemi noomae aima tuumata. ");
INSERT INTO ghs_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tuumaqi nokoi hapa peite Qiba Gottaho tongota biranateta. Oonihe Qiba Gootta oke Heboro noota hee Gorigottaniqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Teka ota nokoi Dzesuke abi qanga eserima hapahapanaiteta. Noi bisata oomi pobi nohota abi teei ootani teei mage robeta oota. ");
INSERT INTO ghs_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Qate Pirattoi hiiremi hapahapaho suheta qetaqeta erai peiteta, DZESU NADZARETTEHO NENARAI DZUTA ABIHO ABI QIBANI. ");
INSERT INTO ghs_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Qate nokoi Dzesu hapahapanaiteta tekai nagapa mina oho kosoramuta oomi noo qiba oke Heboro noo ma Romaho noo ma Girisiho noota gama qeete oomi Dzuta abi noo maina painanoma girodzomaqi noo oke isaitota. ");
INSERT INTO ghs_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","22","Oho quba dzube abi mimi bisi naate Pirattoke pobi hiireta, Oke eto qeeteqi hee, Dzuta abiho abi qibaiqi hiibainohe, erake qeetare, Abi noomae hee, Anai Dzuta abiho abi qibaniqi hiiroraiqi qeetare. Oke noko hiiremi Piratoi hee, Baamu! Ana qeete oke ango qeete qaate. ");
INSERT INTO ghs_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","24","Oonita qaa abi nokoi Dzesu hapahapanaite qaateqi ttoba ma sasa nohoke aima batabiremi qaa abi eserisa eseriho quba teena teenaho isaki naateta. Oonihe sasa khara kharerepo nohoke noko bosata koridzaamake ootota oonita qaa abi nokoi qesa pobipobi hiireta, Maa, eto uhutomi qanganatainohe napahota apei oke mai eetaqu oho qubake napa isanate baabe biidzare. Oiqi hiireta oi teeho quba bahe sinabidzata qetaqeta teei hee, Ttoba ma bare nahoke noko nokome quba pattabetetahe, sasa nahoho quba nokoi baabe biiretaiqi hiiremi qaa abi oke eetemi ooqata meenoma naateta. ");
INSERT INTO ghs_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","26","Qate Dzesu hapahapata oomi pai gotta nohoi oho khoobata qooro oomi paiho dzaba Keropaho ata ma Maria Magattaraho nena ma nokoi noma noko gama oota. Oho quba Dzesui pai mooqoqi paha Dzohane qeseba tuumakhata nome anake mooqi pai nomeke pobi hiireta Pai name, nii khata erake moomi niiho khata naatare. ");
INSERT INTO ghs_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Oiqi hiireqi khata anake noi hee, Nii atapa erake moomi noi niiho pai naatare. Oke hiiremi anai bodza ooqata noke qupadzomaqi ipita noke dzeimaqi naga nameta tuumaqi naka qesa kokora eete qaata. ");
INSERT INTO ghs_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","29","Oonita quba oi gama bamu naatemi Dzesu moomi sinabidzaho qetaqetai gama meenoma naate soubiremi noi erake hiireta. Naho baruna uhube. Oke noi hiiremi oba mangi toobairanoma heenomai ota oomi abi noko besa bidzaga teeke suqobireqi saarota soramu biire too nohota mootota. ");
INSERT INTO ghs_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mootomi noi oba too bairanoma oke muunaqi erake hiireta. Oioni, baura oi gama mee eetemi bamu naate. Oiqi hiiremi suma noho khapere eetemi gisi tuumata. ");
INSERT INTO ghs_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Qate iihai Ingona dzuma minaho roiroi bodza oomi eto abi kebanoke baatemi keba nokohoi dzuma oke sesero eetaino hiireqi Dzuta abi Piratoho torota biranateqi qasa hiiremi noi qaa abi dzoobiremi oko nokohoke geqobiremi hairiamake baatemi qurabidzare tuumata. ");
INSERT INTO ghs_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tuumaqi noko ota biranate abi eseri Dzesuma hapahapanaiteta nopoho oko bosa teete geqobireta. ");
INSERT INTO ghs_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Oonihe noko moomi Dzesui ao baate oomi noko te oko nohoke geqobidzara. ");
INSERT INTO ghs_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","36","Oonoma naateta oi teeho quba bahe sinabidzaho qeteqeta teei hee, Gootta nohoke bamu geqobidzaquiqi hiiremi ota meenoma naateta. Oke ana Dzohane namae mooqi isere mootomi nike nookami meenomanita niike nookare. Qate qaa abi teei kooma noho qebake kotoro pui eetemi Idze, ao oba ma dzuu esese biranateta. ");
INSERT INTO ghs_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Oi qetaqeta teei paha hee, Nokomae abi kootorota mookosu koko oke moohirareiqi hiirorai oioni. ");
INSERT INTO ghs_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","39","Obetemi Dzosepe Arimatteoho nena (noi bosata qupibake Dzesuho torota biranateta) noi Dzesuho tumakhata naatetanihe Dzuta abi mimiho attike eeteqi noi te nokoho pengata paaqata qaarara. Oonihe noi Piratoho torota baaqi Dzesuho keba quba qasa hiiremi Piratohota isanatemi no aima tuumata. Oonita Nikotemo oho qesa ganobine ma eebeke uranoma qesa, oho bame 30 kiro oho isakike gama aima baata. ");
INSERT INTO ghs_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Baaqi nokoi Dzuta abi keba nokome qurabire qaataho pomata ganobine ma eebeke uranoma ma ttoba qesa aimaqi ooma Dzesuho keba sengi eete qegorota. ");
INSERT INTO ghs_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Qate noko Dzesu hapahapanaitetaho neta dzoo teei oomi oho nakuta oma naga agiagi kaibetetai oota oi Dzosepe noomaehonita oho nakuta abiho keba mootaamake habanake qaata. ");
INSERT INTO ghs_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Oonita Dzuma mina ao biranatare boohimi oma naga dzamoqata oomi noko Dzesuho keba oho nakuta mootota. ");
INSERT INTO ghs_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Qate dzuma mina bamu naatemi Saate dzuridzarita Maria Magattara nenai qori qura tupu ota biranate moomi apei ao oma sarara oke burisi eetemi paatike oota? ");
INSERT INTO ghs_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Oho qubake noi burisi eete toroumaqi Siimo Peetoro ma Dzesuho qeseba tumakhata Dzohane anaho toro biranateqi naka pobi hiireta, Maaqa Soopara napahoke noko oma nagata hiumaqi ikata ai tuume oke paimane nanai ruume! ");
INSERT INTO ghs_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Hiiremi Peetoroi anama nakamae hairiamake qeemaqi oma nagata tuumare hiireqi, torouma tuumata. ");
INSERT INTO ghs_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tuusuhiqi anai Peetoroke riite bosa qura patita biranateta. ");
INSERT INTO ghs_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Biranateqi ana subate nese dzoobire moomi ttoba sengi keke ootahe anai te dzuubara. ");
INSERT INTO ghs_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Oonihe Siimo Peetoro ipita baaqi ao dzuubaqi saamaho ttoba sengi moo pobiteta. ");
INSERT INTO ghs_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ma qiba sengi nohoke te samaho ttobama teenaite mootomi ooraranihe, sigita qoomami oomi noi moota. ");
INSERT INTO ghs_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Oke noi moohimi ana atti quba qura patita ootahe anai naamae dzuubaqi moomi naho qupa pobirateta. ");
INSERT INTO ghs_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Oi bosata nanai Dzesu baate qoridzarotaho sinabidza qetaqetake te nooka pobite qaarara. ");
INSERT INTO ghs_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Qate nakamae oho mumure moohimi qupa pobiratemi nakai qaki minake eete burisi eete nagapa tuumata. ");
INSERT INTO ghs_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","Oonihe Maria noi qura patita biranate paata qooro tti hiireta. Tti hiireqi noi subate nese nakuta dzoobire moomi, Angero eseri ttoba khabanoma dzaabanomai Dzesuho keba meeqotaho tekata habeseqi temu qiba robeta oota, temu oko robeta oota. ");
INSERT INTO ghs_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ooqi nopoi hee, Atapa nii ikaqi tti hiire? Hiiremi noi hee, Soopara nahoke noko aimaqi ikata tuume oke ana ruumeni? ");
INSERT INTO ghs_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hiiremi Dzesu noho tumeta qooro oomi noi burisi eete noke mootahe, noho nese dzuubara. ");
INSERT INTO ghs_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Oonita Dzesu noke pobi hiireta, Apeho qirike eete tti hiire? Hiiremi noi qupa nometa hee Dzoo oho mai ooniqi hiireqi hiireta, Mai, nii noho keba aime mae? Aima ikata moote? Hiiremake ana ttuma aimakoi. ");
INSERT INTO ghs_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Hiiremi Dzesui noke hee, Maria! Oiqi hiiremi Maria pasere eete hee, Banaita name! (Qate Heboroho totohota oi hee Rabuni ooniqi hiireta.) ");
INSERT INTO ghs_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Hiiremi Dzesui hiireta Eehe, anai mai nameho torota peitaamake ooraita nii eto ana aima gimutta eetaino. Qate tuumaqa qesamane nahoke pobi hiireqa hee, Anai mai ma Ohonga nike ma napameho torota peqibiqi hiibare. ");
INSERT INTO ghs_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Oiqi hiiremi Maria Magattaraho nena noi ango tumakhametoho toro biranate pobi hiireta, Nookare, anai nese namema Soopara napame poiqanipamuke moori. Oiqi hiireqi noo Dzesu noke pobi hiireta oke noi paha noko gama pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Qate oho Saate surena qupi sooromi Tumakhameto nanai Dzuta abi mimiho atti eete tete siire tatanga naatemi Dzesui ikanomake eeteqi nanaho bisata qooroqi hiireta, Dzoobe ma kanakana! ");
INSERT INTO ghs_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Oiqi hiireqi noi nanake boto ma sama nomeho dzori banaitemi tumakhameto nanai Soopara naname moohimi nanaho baruna tukuba minanipamuke eeteta. ");
INSERT INTO ghs_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Eetemi Dzesui paha hee, Dzoobe, qupa nikehoi kebaratare. Oi Mai ana dzoobiretaho isakita ana naamae nikeke beedzaeta dzoobihimi nike poiqa qaru abi naate. ");
INSERT INTO ghs_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Hiireqi noi suuqa teeteqi hee, Naho Sumasai nikehota qeeme. ");
INSERT INTO ghs_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Oonita nikei oho baura eeteqa abiho kahosa dzamutomi bamu naatakoi, qate nike qaanate kahosa dzamutaama naataquko kahosa nokohoi qaarakoi ooiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Qate Ttoma, apeke abi hee Pai noke teema nopoke teenaite dzoomataiqi hiire qaata, noi tuerebehota tee. Oonihe, Dzesui oonomake eete qesa nanaho torota biranatemi Ttomai ikata oota? ");
INSERT INTO ghs_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Oho qubake tumakhameto qesai ipita noke hee, Maa nanai aoke Soopara napame moori. Hiiremi noi hee, Eehe, anai nese namema berumaho dzori oke noho botota mooqa, boto name noho qeba dzorita eepoqotoqake qupadzomakoihe bamu. ");
INSERT INTO ghs_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Oiqi hiiretanita qupi 8 naatemi tumakhameto nana Ttomama gama suruho minata ooqi tete siiremi tatanga naate oomi Dzesui paha baaqi nanaho bisata qooroqi hee, Dzoobe ma kanakana! ");
INSERT INTO ghs_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Oiqi hiireqi noi qeemaqi Ttoma pobi hiireta, Oionita boto niime boto nahota upubire berumaho dzori oke mooqi, boto niime qeba dzori nahota eepoqotoqake eto hou eetainohe qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Hiiremi Ttomai beubeu eete hee, Soopara ma Ohonga name, oi nii oni. ");
INSERT INTO ghs_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Hiiremi Dzesu noke pobi hiireta, Ttoma nii nookare. Abi mooraamake ao qupadzomorai nokoio rike ma pobi oni. Qate nii teeho quba qupadzohidzaranihe moorake eete qupadzome. Oke noi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Qate baura oonoma samaneke Dzesui tumakhameto nome nanaho pengata eetemi Ohongaho mumure naatetanihe qesaho isereke gee eranomata qeetaama naateta. ");
INSERT INTO ghs_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Oonihe noo eranomake ana qeetemi nike isaiteqi hisi eetaridzoni. Nike hee, Oo, Dzesui Kiristu, Ohongaho Khataniqi hiireqa dzapa nohoho quba qaraqaranoma naataridzoni. Oiqi Dzohane anai qeeteta qupadzomare. ");
INSERT INTO ghs_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ipita tumakhameto nohoi Tiberiaho oba ttuuta oomi Dzesui paha sama nome nokoke banaiteqi, erake eete banaiteta. ");
INSERT INTO ghs_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","3","Oi Siimo Peetoro ma Ttoma (oi teema nopoi biranatetahoni) ma Nattanae Garirea habaho nagapa Kanaho nena, ma Dzebete oho khameto naka, ma Dzesuho tumakhameto paha eseri nanai gama ota ooqi, Siimo Peetoro nanake hee, Anai paha Khaa apiapi naatare tuume. Hiiremi nanai hee, Oionita napa gama tuumare. Hiireqi nana biranate sisimata peite qupibake dzobi eete saridzaama naate qaami iihai mootota. ");
INSERT INTO ghs_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Iihai mootomi Dzesui baaqi igasata qoorotahe tumakhameto nanai te noke moo qupadzomara. ");
INSERT INTO ghs_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Oonita Dzesui noo dzoobireqi hee, Khameto name, kabira saridze mae? ");
INSERT INTO ghs_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Hiiremi nanai hee, Baamu. Hiiremi noi hee, Dzupu oke sisima pobi neta mootoqake saridzakoi. Hiiremi nanai ota mootota. Oonihe kabira samanenipamu agomami nanai oke dzeima quba bitta eeteta. ");
INSERT INTO ghs_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Oonita Dzesuho qeseba tumakhata anai Peetoro pobi hiireta, Maa, Soopara napaho oioni. Hiiremi Peetoroi Sooparaho dzapa nookami noho beedzae saqobami eto Dzesu noho habana mooraino hiireqi noi hairiamake sasa aima sama nome qegoroqi obata kautu eeteta. ");
INSERT INTO ghs_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Qate nanai iigasa sererahuke oomi mita 200 naatemi qesai botti gattiqata qurateqi tumakhameto nanai khaa ma dzupu qama dzeima igasa neta dzaoma baata. ");
INSERT INTO ghs_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Oonita baaqi nanai unate dzupuke igasata qaate peite moomi sekana eepata dzooro abaniremi dzobadzoba teei paha oota. ");
INSERT INTO ghs_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Oonita Dzesui nanake hee, Nikehota agome oho neta paha sekana qesa aima erama teenaitare. ");
INSERT INTO ghs_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Hiiremi Siimo Peetoro obata sura gimutta eetoqi ooqi dzupu oke noomae keke dzeima igasata peite moomi sekana mimi 153 oho nakuta ootahe dzupu te uhubara. ");
INSERT INTO ghs_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Obete Dzesui nanake hee, Nike baa patta muunare. Hiiremi tumakhameto nanai moomi Sooparanipamu oonihe, nanai beubeu eeteqi apei noke hee, Dzoobe Sooparaniqi hiibarota? Baamu. ");
INSERT INTO ghs_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Oonita Dzesui dzobadzoba ma sekana oke aima pattabete nana moiteta. ");
INSERT INTO ghs_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Oke eete Dzesui baata neta qoridzeqi sama nome nanake banaitemi bodza tapari naateta. ");
INSERT INTO ghs_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Oonita nanai saunaba patta oke muuna bamuitemi Dzesui Siimo Peetoroke ttokaho dzapata hee, Siimo Dzona, qupa niihoi khaa apiapiho pisinisita oorai, mae naho neta oorai? Hiiremi noi bere kotoroqi hee, Oo Soopara name, anai niiho dzake eetorai oke nii gesina. Hiiremi noi hee, Oonita nii sipisipi khameto nahoke sinabidzaho sogo moitorare. ");
INSERT INTO ghs_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Oke hiireqi Dzesui paha noke ttokaho dzapata hiireqi hee, Siimo Dzohane, Niiho qupa naho torota oorai, mae bamu? Hiimi noi Dzesuke hee, Oore Soopara, ana niiho dzake eetorai oke nii qesina. Hiiremi noi hee, Oonihe sipisipi gamitti nahoke nii isanate soopara eetoraridzoni. ");
INSERT INTO ghs_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Oke Dzesu hiireqi gattiqa ipita noi paha noo teena oke hiiremi tapari naateta. Hee, Siimo Dzohane, Meenipamuke nii naho dzake eetorai, eo bamu? Oonita noi totoho taparike hee Nii naho dzake eetorai mae bamuiqi hiiremi Peetorohota bame mina eetemi noi Dzesuke hee, Soopara name, nii quba minaraho gesina keke oonita naho qupa niiho torota oorai oke nii paha gesina. Hiiremi Dzesui noke hee, Oonihe nii qeseba sipisipi nahoke patta moitorare eto qaataino. ");
INSERT INTO ghs_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","19","Dzesui Peetoroke hee, Nookare! Nii eehaha niimeta siihu suutoqi niimae qupadzomaqi tee ma teeta tuuma qaari. Oonihe nii poiqa nasura naatemi maina teei (Sumasa) niike sasa dzaaroqa dzeima tee ma teeta tuuma qaaraqu — oi niiho dza bahe noho — oke ana bamu nii ikobetaqu. Oiqi hiireta oi paha Peetoroi ipita poma attinomata baatemi oho quba Ohongaho dzapa pobi haba gegebetarotaho isakita Dzesui oke hiireta. Noi hee, Oho quba nii anaqake iiha qaarare. ");
INSERT INTO ghs_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Hiiremi Peetoro nookatanihe noi burisi eete moomi apei qupi posaho bodzata Dzesuho dzagaqata tirere eeteqi hee Soopara, apei niike geema mootare boobiqi qasa hiireta, oi Dzohane ana. ");
INSERT INTO ghs_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Oonita Peetoroi anake mooqi Dzesu pobi hiireta, Soopara, qate Dzohanei ikanomake eetaqu? ");
INSERT INTO ghs_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Hiiremi Dzesui noke eraiqi hiireta, Ae Anai Dzohaneke hee, Ana dza eetemi nii naho beebe eete qaamake ana paha biranatakoiqi hiibaquni mae ikanomake ana hiibaqu oi niiho noo bamu. Niiho noo oke hee, Nii anaqake iiha qaarare. ");
INSERT INTO ghs_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Oiqi Dzesui hiiremi oho nooke sinabidzaho oko ma boto samane oberama nookaqi anahoke qesai hee, Tumakhata Dzohane noi bamu baataquiqi hiirorai. Oonihe Dzesui te anake hee Nii bamu baataquiqi hiibarani. Bamu. Noi Peetoroke hee Ana dza eetemi noi naho bebe eete qaamake ana paha biranatakoiqi hiibaquko oi bamu niiho noo naataquiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Oonita tumakhata quba oke gama moo soubireqi isere mootoqi qeetorai oi ape bahe ana. Ma isere nahoi meenihe oke napa gama gesina. ");
INSERT INTO ghs_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Qate Dzesui paha quba samane eete qaata oho isere gama iso keke qeete soubidzapuko ana qupadzomami qetaqeta gee samane ttokata oorai oi qidzoke oho quba isanatorori. Noo oioni Ana Dzohane ");
INSERT INTO ghs_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Tteopiro, abi mina name, Dzoobe: Ana bosata pepa niiho quba qeeteta oi Dzesui sohoroqi quba eete qaata ma banaite qaata oho isereke ana niiho quba qeeteta. ");
INSERT INTO ghs_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Qate noi qusuta peitare boohiqi noo tatanga nomeke Tumakhameto pobi hiireta ma Qaheuba Sumasa nokoho quba dzoobidzakoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Oonihe noi sama eehaha nome nokoke banaitomi qupadzomata. Qupadzomami noi Ohongaho pobi qesaqesa noko pobi hiire paanaite qaami bodza pooti naateta. ");
INSERT INTO ghs_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ma oho bodza teeta nokoi Dzesuke saridze oomi noi hiireta, Nike eto Dzerusaremu nagapake qaateqi tee ma teeta tuumainohe ota gama susupu ttutturate Maiho naru tatangaho bebe eesuma ana nike pobi hiireta oi meenoma naataridzoni. ");
INSERT INTO ghs_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Oi Dzohane noio obama abi sooro qaata oonihe bodza ao dzamoqa naasuhiimi ana naamae nikeke Sumasama soobakoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Oonihe bodza teeta nokoi totoho eranomata Dzesuke qasa hiireta, Soopara naname, nii Isirae abi nanaho bosa qobaqobai ao bodzaqarata ibo napame Romake suqobidzaqu mae? ");
INSERT INTO ghs_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Hiiremi noi erake hiireta, Nikei oho bodza ma sau qupadzomaquho isaki baamu oonihe oke Mai noqeke quba oonoma gesina naate oorai. ");
INSERT INTO ghs_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Oonihe hiibi, Qaheuba Sumasa nikehota gaibaqa nike beedzaenomaitemake oionita nike ao sohoroqa oko ma boto tupu naho Dzerusaremuta oorai ma Dzuttea habana oorai ma Samaria habana oorai ma haba samaneta oorai nokohota naho noo ma sinabidza mekeqoma hiire paanaitemi kata gamaqi habaho moirata soobeqomakoi. Oiqi Dzesu hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ma Dzesui quba oonomaho pobike Qaru Abi nokoke pobi hiireqi bodza ooqata keke nokoho nese ma pengata adzahaha naate, qusuta peitemi nokoi moohimi perettabi ao noke sengi eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ma nokoi nese dzoobireqi noi qusute bamu naatetaho tekake moohimi abi eseri sasa khabanomai nokoho bisata qoorota. ");
INSERT INTO ghs_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nopoi hee, O Garirea nena, nike abi naga ikanomai qusuke rittabetorai? Oi Dzesu nike qaate qusuta tuume oonihe tete teena ota paha burisi eetakoi. ");
INSERT INTO ghs_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Oiqi nopoi hiiremi Qaru Abi nokoi tora dzapa Oriba ota ooqi burisi eete Dzerusaremuta biranateta oi te kharata ooraranihe dzuma surenake qeemaquho isaki. ");
INSERT INTO ghs_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Oonita Dzerusaremuta biranateqi suruho nokome ota oora ma qaara eetota nokoi ota sohoroqi pupu hiirota. Qate abiho dzapa ttari oi Peetoro ma Dzohane ma Dzakopo ma Attereo ma Piripo ma Ttoma ma Battoromeo ma Matteo ma Dzakopo Aripeoho khata ma Siimo Romaho khepidzenoma ma Dzuta Dzakopoho khata. ");
INSERT INTO ghs_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ma paha Dzesuho pai ma nomamane noho ma paimane qesama noko gama qupa teenaite pupu baura eetota oke noko ota eete oota. ");
INSERT INTO ghs_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","17","Oomi bodza qesa naatemi Peetoro noi abi tupu, dzare nokoho 120, oho bisata qooroqi erake noko pobi hiireta. Dzairamane name, napaho ttarita teei Dzesuke geema mootoqi qaa tupu oke dzeimami nokoi Dzesuke aimata dzapa nohoio Dzuta. Oonihe baura nome oke eeteta oi teeho bahe Qaheuba Sumasa oke agobanipameke Tabitiho toonaitemi qeetetaho isaki oi ooqaho quba meenoma naateta. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Qate mooro. Dzuta noi pasena nomeho ttuma aima ooma ttoka teeke mai eeteqi ota suma kopidza eete taate qura qohabami ttidza nohoi biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Obetemi oho pobi Dzerusaremuta baami noko ona qaata nokoi nookaqi noo kokometa haba oke Akettamaniqi hiireta, oonihe haba oi Dzutaho kasu ooniqi hiirorai.) ");
INSERT INTO ghs_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Oonita Peetoro ipibireqi hee, Aoke Samuho pepata erake hiiremi oorai, Nagapa nohoi agiagi naatare abi teei eto oota ooraino. Ma oi paha teeta hee, Sinabidza baura nohoke isanate maina teei aimaridzoni. ");
INSERT INTO ghs_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Oke hiiremi ooraita Dzesuke Dzohanei obama soorotaho bodza ma Dzesui abiniqake napake qaate peiteta bodza oho nakuta apenei Dzesuma napamae ttaike oora ma qaara eete baa qaabi abi oonomahota teei paana naateqake abi oio napake hoobire Dzesu qoridzetaho mee hibahiba naatare. ");
INSERT INTO ghs_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Hiiremi nokoi abi eserike paanaiteta, oi Sabaho khata Dzosepe (oonihe dzapa temu nohoi Dzusto) qate temuho dzapai Mattiasi, nopo oioni. ");
INSERT INTO ghs_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ma nopoke paanaiteqi pupu hiireqi nokoi hiireta, ");
INSERT INTO ghs_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","O Soopara qupa mohimohi, nii isanate abi eseri nopoho neta teeke moomi isanatemi nii noke Dzutaho tekata mootomi qaru abiho baura erake Dzuta gaubiretake noi mai eetare. ");
INSERT INTO ghs_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ma oho baabeke noko biiremi oi Mattiasike paanaitemi noi qaru abiho ttarita ipibireta. ");
INSERT INTO ghs_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Qate Ingonaho dzuma ao kharata tuumami bodza pipiti naatemi patta ponabetaquho dzuma naate oomi Peetoro ma kara nokoi gama susupu ttutturateqi tupu teenata oota. ");
INSERT INTO ghs_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Oonita qusuta bapamuho qesa husu minanipamu teei biranateqi naga noko oota nokoke suqobireta. ");
INSERT INTO ghs_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Suqobiremi noko moohimi Ohongaho too dzadzai nokoho irita biranate qooro soubiremi, ");
INSERT INTO ghs_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Qaheuba Sumasai nokoke gama qooro teetemi nokoi ao nagapa noo maina painata sinabidza hiireta. Oonihe te sepeke hiibaranihe Sumasa nokoke banaitetaho isakita hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Oonihe Ohongaho dzaodzaonomaho Dzuta abi qesa Dzerusaremu nagapana qaata nokoi qeena ma baana oni. ");
INSERT INTO ghs_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Oonita bapamuho husu oi nokoho tomata dzuubami nokoi gama baa ttutturateqi abi samanei nookahimi Qaru Abi nokoi noo totoho maina paina nokohonipamuta hiirota oonita minarai hasaqu eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ma nokoi hasa hiireqi hiireta, Abinaga erai gama Garirea abi keke. ");
INSERT INTO ghs_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Oonita nokoi ikanomake eeteqi noo maina paina napahota hiiremi maikhametoi nookorai? ");
INSERT INTO ghs_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Napai Pattia ma Meette ma Eera, Mesopottamia ma Dzutea haba nena ma Asia gattiqa ma apoho abi ooni. ");
INSERT INTO ghs_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pirigia ma Papirai ma Agitta ma Ribia nena ma Kirene nena ma Romana baata abi oi Dzuta abinipamu ma paha nokoho nakuta dzuuboraiho abi. ");
INSERT INTO ghs_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Oi paha Kerette abi ma Arabia abi napama teena totoho maina paina napahota Ohongaho baura attinomake noko hiire paanaitorai oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Oho totoho maina painata Qaru Abi sinabidza hiiremi abi nokoi houpeu eeteqi qesa pobipobi hiireta, Eria naane obaoba? ");
INSERT INTO ghs_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Oonita qesai Qaru Abi nokoke sube ma pasena hiireta. Oi nokoi bai oba agiagike muunaqi ruume nooke hiiroraiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nokoi qepuqepu hiiremi Peetoro noi ttuerebe nokoho bisata qoridze dzaubarike hiireta, O Dzuttea abi ma Dzerusaremuta oorai abi, dzoobe. Nikei bage eete toma ttiteqa naho noo nookare. ");
INSERT INTO ghs_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Saunaba naini kiroko naataamake oorami nanake nike hee, Bai oba nike suqobirorai ooiqi hiire mae? Oi baamu. ");
INSERT INTO ghs_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Oonihe hore noo too abi Dzoerei hiireta oho meeke nike erake moori. ");
INSERT INTO ghs_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Oi Ohongai noho toota eraiqi hiireta, Anai kebanoke Sumasa name dzoobiremi haba samaneho abike igabire soubirema mutu ma khata nokoi too abiho isakita hiibakoi, ma abi tasu nokoi nese parara eeteqa baku meenomaho qesa mooqa tete qupadzomakoi. ");
INSERT INTO ghs_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Oonita ana kokora abi ma paimane nameho quba eeteqa Sumasa name dzoobiremi nokoi naho too naate hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Ma ana nokoke qusuta quba agiagi banaiteqa ttokata mumureho isaki dzoobiremi dzuu biranatemi eepa ma dzapunamu ma quba biranatakoi oi etei burisi eetemi qupi sooromi dzasidzai dzuu eetakoi. Oke eete soubiremi abi nokoi Soopara minake qaupuitaquho bodza ao biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Biranatemi oionita apenei Soopara oho dzapake qiraitaqu nokoke ana qidzaitakoi oiqi Dzoere hiiretanita oho mee era. ");
INSERT INTO ghs_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Hiireqi Peetoroi hee, Oionita Isirae abi, nike toma tiiteqa noo erake nookare. Dzesu Nadzarette nenake Ohongai husi ma painomaitemi noi bisa nikehota quba nese agiagi ma baura bamenoma samane eete qaami oi Ohongaho mumure naatemi nike te oho ruume naatoraidzara. ");
INSERT INTO ghs_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Qate nikei abi oonoma Dzesuke teetareiqi noke tuuma abiho botota mootomi hapahapanaitemi baateta. Oonihe oi teeho quba bahe Ohongai sauqata qupadzomaqi oho tete biraitemi nike qusubaiteta. ");
INSERT INTO ghs_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Oonita Ohongai noke paha qaraqaranomaiteqi baata ma hemeho neta saqorotaho isakita noi ao eehahaho pobi naateqi baatake suqobireta. ");
INSERT INTO ghs_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nookao, agobake Tabiti noi Dzesuho too naateqi eraiqi hiireta, Anai moomi Ohonga anake dzaga bobotorai oho isaki oni. Oi noi naho boto pobita ooraimi ana bamu quba teeho atti eetaqu. ");
INSERT INTO ghs_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Oho qubake ana ttidza qidza eetemi naho too hasahasa hiirorai. Oho qesa sama nahoi bage eete oorakoi. ");
INSERT INTO ghs_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Oi teeho bamuhe nii gisi nahoke sepeke gaubiremi rubenga naataquho tete bamu oi nii qeseba khata niime anake qaatemi ngausa naataqu oi teqaha ooraidzara. ");
INSERT INTO ghs_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Baamu, nii anake qaraqaraho tete banaitemi ota tuumakoi oi nii anake penganaite qaama qaama anai oho qaki naate qaarakoi oiqi Tabitti Dzesuhoke qeeteqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Oonita Peetoroi noo ipibireqi Dzuta abike hee, Qesa ma dzairamane name, uumi napaho Tabiti noi baatemi qurabireta oonita nohoke ana te hiiremi nike nookoraidzara baamu. Napa moomi noho nesetu napahota ooraita noi Dzesuhoke eeteqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Oi noi too abi qaaqi Ohonga naru noo tatanga noho irita mootota oi biidza ma suna nohota teei abi mina naatarotaho naru. Oonita Dzesuho naruke Tabiti qupadzomaqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Noi Kiristuho hore noo paanaiteqi hee, naho qeseba khatai bamu koseta qaami noho samai ota arinataqu oonihe, baata neta qoridzaqu oho noo hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Oonita Ohongai Dzesuke ao tukuto qoridzemi nana nese nanamema noke moota. ");
INSERT INTO ghs_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Qate noi qoridze peiqi Ohonga maiho boto pobi naate ooraiqi napake naru hiiretaho isakita Sumasa nanaho irita dzoobiremi soororai ma sobasoba ooqake nike poiqa moo nookorai. ");
INSERT INTO ghs_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Oi Tabiti teqaha noomae qusuta peitaranita oi te noho noonidzara. Oonihe Tabiti eraiqi hiireta, Ohonga mai noi Soopara mina nahoke hee, Nii naho boto pobi naateqa erata qoobare. ");
INSERT INTO ghs_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Qooro qaama ibo abi niihoke anai aimami noko oko toro niihota ttutturate qaarare oke Ohongai Dzesuke pobi hiiremi Tabiti qaupuiteqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Oonita Peetoroi noo ipibireqi hee, Isirae abi qeena ma baana ma nike gama korabete nookare. Nike Dzesu hapahapanaitemi baateta oonihe noke Ohongai tekata upubiremi noi Kiristu ma Soopara mina napahoke naate oorai. Oiqi Peetoro hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Noo oke Peetoroi hiiremi oi nokoho tomata dzubaqi qupa nokohoke kootoromi nokoi Peetoro ma qaru abi qesa minarake pobi hiireta, Dzairamane nana ikanomake eetaqu? ");
INSERT INTO ghs_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Hiiremi Peetoroi hee, Nike qupa burisi eete Dzesu Kiristuho dzapa mai eetare. Mai eeteqi sinabibidzaho sobasobata dzuubami kahosa nikeho dzamutomi Ohonga mai noi Qaheuba Sumasama nikeke dzou eete qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Oi nike keke bahe eemane khameto ma abi kharana oorai minarama nikeke Ohonga Soopara napahoi ao Qaheuba Sumasaho pobi hiiremi oorai. ");
INSERT INTO ghs_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ma Peetoroi noo oonomake hiiroqi ipibire noko pobi hiireta. Nike abi naga rasakinomake qaateqa baa aimare. ");
INSERT INTO ghs_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Oke hiire qaami apenei Peetoroho sinabidza nookami meenoma naateta (oio tiri ttauseni oni kaqa) nokoi sobasoba saridzeqi Qaru abi nokota ipibireta. ");
INSERT INTO ghs_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Oonihe nokoi gama ota teenaqata oomi, Qaru abi nokoke sinabidza pobi hiire banaitemi bage eete nokomae qaata. Ma teena naateqi dzobadzoba qooto muunaqi pupu baura eete qaata. ");
INSERT INTO ghs_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Oonita Qaru abi nokoi quba nese agiagi eetemi mumure naatemi nokoi moo nookami attinoma naateta. ");
INSERT INTO ghs_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Oonita nooka hiisi etaeta abi nokoi tupu teenata oomi quba nokohoi ttaiqa kekeni. ");
INSERT INTO ghs_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ma qesa nokoi quba tongo ma qubabosa nokome ttuma quba mootomi oma biranahimi qesamanei patta ma qubaho dzore qaata nokoho quba isakiqata batabire moite qaata. ");
INSERT INTO ghs_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Qate qupi samane noko Ohongaho biirita ttutturate qupa teena eete qaaqi, burisi eete naga nokometa patta qooto muuna qaaqi muuna ma aima qidza eete qaata. ");
INSERT INTO ghs_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Oi noko Ohongaho hasa hiire qaami abi paha qesai nokohoke nookami bagenoma naate qaata. Ma Ohongai abi sinabidzaho dza minake eete qaata nokoke aimaqi Qaru abiho tuputa ipibiremi qidzanate qaata. ");
INSERT INTO ghs_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","2","Qate ete aparana naahiimi pupu bodza naatemi Peetoro ma Dzohane nopoi Ohongaho Biirita peiteta. Oonihe abi pone (paiho amenata pone naate qaata) noke qesamane nohoi bodza samane aima tuuma Biiri pouta mootomi habese qaami nokoi sinabidza guhu ota tuuma ma baaba eesumi noi nokoke ttuma ma qurumaho pupu ma nenesa hiire qaata noio ota habese oota. ");
INSERT INTO ghs_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Oonita abi ponei moohimi Peetoro ma Dzohane Biiri nakuta dzuubake boohimi nopoke nenesa hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Hiiremi Peetoro noke moohimi Dzohane paha oke eeteta. Nopoi hee, Maa, nii nese taate nakake moorare. ");
INSERT INTO ghs_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Hiiremi noi hairiamake erake qupadzomata, nopoi quba teeke ana moitareke hiibi. ");
INSERT INTO ghs_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Hiimi Peetoroi hiireta, Maaqa, anai ttuma baamu, siriba baamu. Oonihe quba naho torona oorai oke ana isanate nii moitakoi. Oonita Dzesu Kiristu Nadzarette nenaho dzapata nii ao qoori tuumare. ");
INSERT INTO ghs_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Hiireqi noi noho boto pobita aima qusubaitemi oko ma sama nohoi tatanga naatemi noi tukuba qoorota. ");
INSERT INTO ghs_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ma noi nopoma gama sinabidza guhuta peiteqi nome tuuma ma baaba eesuhiqi Ohonga hasa ma gegema hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Oonita noi tuuma ma baaba eesuhiqi Ohongaho dzoobe hiiromi, abi ma paimane nokoi noke mooqi hee, ");
INSERT INTO ghs_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Biiri pou qidzata habese ttuma ma qurumaho nenesa hiire qaapu abi oioni. Oi quba nese agiagi oke mooqi noko hasahasa minanipamuke hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Obetemi abi oi Peetoro ma Dzohane nopohota soomata oi biiriho totaqi suba kharanoma oke hee Soromoho suruhoniqi hiire qaata ota nokoi oomi abi samanei nokoho toro torouma baaqi hasaqu eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Oke eetemi Peetoroi abi tupuke mooqi hiireta, Isirae abinaga, nike naane quba abiqake mooqi oho hasahasa minanipamuke hiiroraidzo? Nike qupadzomami Dzohane ma nakamaeho beedzae isanatorai mae sinabidza nakahoi bagenoma naatemi ooqaho qubake abirai tuuma ma baaba eetorai mae? Oi baamunipamu! ");
INSERT INTO ghs_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Uimane napaho Abarahamu ma Isaka ma Dzakopo nokoho Ohonga noi khata nome Dzesu Soopara noho beedzaeke abi eraho irita paanaite. Oonihe Dzesuke nikei ibo eeteqi raaba abi nokohota mootomi Piratoi noke ingonaitare hiiremi nike oho bai hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Dzesui qupa sasarinoma ma rikerikenomanihe nike teqaha noke ingonaitara. Baamu, nike Kiape Piratoke tototo hiireqi taanga abike ingonaitareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Qate nike Dzesuke baatata mootota oonihe noi qaraqaraho maikhatanita noke Ohonga baata neta eehahaitemi qoridzetake nana nese nanamema mooqorai. ");
INSERT INTO ghs_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Oonita abi erai Dzesuho dzapake nookaqi hiisi eeteqi dzapa nohota paha qidzanate. Oi abi nike moo nookahimi noomaeho ai tataumai isanatemi Dzesuho beedzae noho irita dzuubami noho sama pobirate. ");
INSERT INTO ghs_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Peetoroi hee, Qateqa, Qesamane obera name, Ana qupadzomami bosa qobaqoba nikeho ma nikei ruume nikemaeho isakita oke eetepu. ");
INSERT INTO ghs_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Oonihe Kiristui heme oonomake aimarotake Ohongai hiireqi oho nooke too abi nomeho toota hiire paanaitemi biranateta tete ooqake Ohonga biraitemi nike qusubaiteqi oonoma eetepu. ");
INSERT INTO ghs_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Oho quba nike qupa burisi eeteqa oora ma qaara qanqa nikeme tume biiremi honga ma kahosa nikehoke Ohongai dzamutakoi. Oke eeteqake Soopara mina napahoi nike khakhope biirorakoi. ");
INSERT INTO ghs_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Oonihe Khakhope biiroraquho khooba erani: Kiristuke Ohongai agobake uhutota. Oonihe too abi noho too naateqi hee, ");
INSERT INTO ghs_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kiristuke qusuta qaanatemi quba samaneke roibete isanatemake Dzesuke ana ttokata dzoobiremi paana naatakoiqi hiireta, khooba oioni. ");
INSERT INTO ghs_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Peetoroi hee, Ohongai Moseke qupanomaitemi noi abike hee, Ohongai anake upubiremi anai too abi nohonihe, naho temuke noi dzairamane nikeho neta teeke uhuto upubiremi nike noho too qusubaite soubidzare. ");
INSERT INTO ghs_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Oonihe teei noke qusubaitaama naataquko noke rubengaitemi abihota bamu naatakoi. ");
INSERT INTO ghs_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","26","Oiqi Mosei agobake hiireta oonihe Samue ma too abi samane nokoi noo teena oke hiire baaorai. Oi Ohongai naru oke Abarahamu ma ttari nohoke moiteqi eraqi hiireta, Niiho sooro ma sainata ttoka minaraho abi nokoi oho agoago saridzakoi. Oiqi hiiretanita nikei naru noo oho eemane khameto oomi Ohongai qaheuba qaru khata nome ai upubireqi noke bosata nikeho quba dzoobiremi noi nikeho qupa burisi eetemi sasari naataridzo — agoago oioni. Oho qubake nike koirikairi nikemeho isaki sigita biiremake noi nikeke agoago oke eetakoi, khooba oioni. Oiqi Peetoroi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Oke Peetoroi hiireqi Dzohane ma nopoi abi noo pobi hiiromi sinabidzaho soopara mimi ma Satukeo nokoi biiriho pirittaniho pobipobi abima noko nopoho torota biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Oi nopoi noo ma sinabidza oke abi tupuke pobi hiireqi Dzesu baata neta eehaha naate qoridzetaho noo oke hiimi abi mimi nokoi oke nookami qanganateta. ");
INSERT INTO ghs_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Qanganatemi nokoi nopoke aima suutotanihe ao sure mootomi nokoi iihaihoke qupadzomaqi nopoke sutasuta nagata mootota. ");
INSERT INTO ghs_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Oonihe biirita abi samane sinabidza noo nookaqi hiisi eeteta abi nokoho dzare paipu ttauseni naateta. ");
INSERT INTO ghs_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Obetemi iihai mootomi abi mimi ma hobihobi ma sinabidza soopara mina nokoi gama Dzerusaremuta ttutturateta. Oi Dzube abi mina Anasi ma Kaipa ma Dzohane (noi abi maina) ma Aresatte nokoi gama Dzube abi mimiho quni ma mani keke. Oonita noko hiiremi qaru abi eseri oke aima garuba nokoho bisata mootota. ");
INSERT INTO ghs_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mootoqi qasa hiireta, Apeho beedzae ma dzapata nipei obaoba oke eeteo? ");
INSERT INTO ghs_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Oke hiiremi Qaheuba Sumasai Peetoroke sahurunomaitemi noi erake hiireta, Abi mimi ma abiho bosa qobaqoba name nookare. ");
INSERT INTO ghs_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Nike nakeke hee, Apei nipeho husi ma pai naatemi nipei abi pone erake kokora eeteiqi hiire. ");
INSERT INTO ghs_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Oonita ana hiire paanaitemi Isirae abi ma nike gama susupu nookare. Dzesu Kiristu Nadzarette nagapa nenake nikei hapahapata teetemi baateta noke Ohongai baata neta tukuto eehahaitemi qori oorai noqaho beedzaeho qubake abi erai sama ma sasa qidza eeteqi oorai. ");
INSERT INTO ghs_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Oonita nike naga gosogoso abiho isaki ooqi Dzesu oma oonomaho bai hiireta oonihe noi ao naga oho ttittira naate oorai. ");
INSERT INTO ghs_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ma napa paha maina teeho dzapata qidzanataqu oho tete te ooraidzara, baamu. ");
INSERT INTO ghs_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Hiiremi nokoi Peetoro ma Dzohaneke moohimi nopoi abi sepe nokanoka guhu dzuubaamaho isaki oonihe nopoi too ananama noo hiiremi abi moo nookami nokoi bosata Dzesuma qaata oonita nokoi oho hasa hiireqi iiha ma dzoobidza eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Oonihe abi ponei qaata noi nopoma noko qooro oomi nokoi mooqi tee ma teeke hiiba quba bitta eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bitta eeteqi nokoi nokoke iihami tta eete naga patita oomi nokomae keke dzahe gunugunu hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Nokoi hee, Napa nopoke ikanomake eetaqu? Nopo ao quba eetemi oho pobi Dzerusaremuna oorai nokoi ago nookami Ohongaho mumure naate oorai. Oho qubake ikaqi oke gimutta eetaqu? ");
INSERT INTO ghs_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Oonine eto noo erai ango abiho otoba patita dzuubami nooka tani naatainoho quba napa nopoke qamuni hiireqa hee, Eetoqa Dzusuho dzapake ipita abike pobi hiibainoiqi hiibare. ");
INSERT INTO ghs_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Oiqi hiireta. Oonita nokoi Dzohane ma Peetoroho quba hiiremi baami nopoke dzoobidzareiqi noo tatanga hiireqi hiireta, Eetoqa Dzesuho dzapake abi pobi hiibainonipamu! ");
INSERT INTO ghs_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Oonihe Peetoro ma Dzohane erake noko pobi hiireta, Nikeho nooke qusubaiteqa Ohongaho nooke qaatareiqi nike hiibi mae? ");
INSERT INTO ghs_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Oonihe nanai quba moo qaabi ma nooka hiire qaabi oke qaataquho isaki baamunipamu. ");
INSERT INTO ghs_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Oke hiiremi Dzuta abi mimi nokoi ao nopoke eheitarota. Oonihe abi pone oho tii bodza 40 naatemi obaoba oke noho irita eetemi abihota bagenoma naateta. Oho qubake Dzuta abi mimi hee, Eto abi minarai oho nookami qanganatainoiqi hiiretanita nopoke tee ma teeke eetaquho tete bamu naatemi nokoi nopoke paha qaupasasa gaamaqi dzoobiremi tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Oonita nopoke saaqoromi nopoi qesamane nopomeho toro biranateqi abi mimi ma bosa qobaqoba nokoi noo ikanoma hiireta isere oke qesamane nopome gama pobi hiire soubireta. ");
INSERT INTO ghs_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Hiiremi nookaqi noko totoho nokome teenaite qusubaiteqi Ohongaho toro pupu hiireqi hiireta, O agoago khata teena. Nii qusu ma ttoka ma besa oke nii khooba nokohoma gama mooto soubireta. ");
INSERT INTO ghs_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Oke eetetai Qaheuba Sumasa dzoobiremi noi uumi nanaho Tabiti qaru khata niihoho too adzahahaitemi noi eraiqi hiireta, Abi soropurunoma nokoi naane quba dzauba eetorai? Ma abi nokoi naane quba noo sepesapeke qupadzomorai? ");
INSERT INTO ghs_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Oi ttokaho abi qiba nokoi ttarita qooromi bosa qobaqoba nokoi oho qesa ttutturateqi nokoma gama Ohonga ma Kiristu nopoho ibo eeteqi basesa eetorai. Oiqi Ttabitti hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Oonita meenipake nagapa eraho abi nokoi qaheuba khata Dzesu apeke Ohonga nii upubireta noke nokoi ibo eeteqi Herote ma Pottio Pirato nopoma raaba abi ma Isirae abi ma noko gamaqa noo teenaiteta. ");
INSERT INTO ghs_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Oonihe niimaeho boto ma too niihoi hiiretaho isakiqata noko eetorai. ");
INSERT INTO ghs_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Oonita Ohonga niimae moomi nokoi qaupasasa gaamami attinoma naatarorihe iboho isaki oke nii rasaki eeteqi qaru khameto niime beedzae moitemi nokoi too ananama niiho sinabidza hiire qaari oke paanaite qaarare. ");
INSERT INTO ghs_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Oke eesuhima niimae boto dzoobiremi abiho sama ma sasa qidzanatorare ma quba nese agiagi biranatemi mumure naatorare. Oonihe oi gama qaheuba khata niiho, Kiristuho dzapata biranate qaarare. ");
INSERT INTO ghs_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Oiqi hiire pupu hiimi naga nokoi oota oi ngungudza eesuhimi Qaheuba Sumasa nokoho qupake qanoqanonomaitemi sinabidza oke noko beedzaema hiire qaata. ");
INSERT INTO ghs_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Obetemi sinabidza qusubaitetaho tupu mokoi quba samane nokome gama mootoqi ttaike aima qaata ma ipibidza ma hongasidza mekeqoma eete qaata. Nokoi quba niiho naaho hiibaamake teenaite aima qaata. ");
INSERT INTO ghs_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ma Qaru abi nokoi Dzesu Kiristu baata neta qoridzetaho noo hiire qaami mee nokoi minanipamu naatemi abi minarai dzoobe ma kanakanaho isakinipamuta qaata. ");
INSERT INTO ghs_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ma bisa nokohota teei teqaha sepeke qaarara. Quba tongo ma qubabosa, guhu ma naga, dzoo ma hoo oi qaami oke noko oma quba hiiremi biranatemi oke ");
INSERT INTO ghs_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Qaru abi moitemi pattabete abi ooho dzoreke isakiqata moite qaata. ");
INSERT INTO ghs_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Qate abi teei qaata dzapa noho Dzosepe noke Qaru abi paha dzapa moiteta oi Banabe (dzapa nohoho khoobai ttapuita khata) noi Reebiho eema. Kusu Kipuro nena. ");
INSERT INTO ghs_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Noi oho qesa eeteqi quba tongo nome oho ttuma quba hiiremi biranatemi noi oke gama aima Qaru abiho dzagata mooto soubireta. ");
INSERT INTO ghs_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","Oonihe abi teeho dzapa Anania ma ata noho Sapira nopoi ttoka nopome tteke ttuma quba hiiremi biranatemi qesai oma gama Qaru abi moitetaho isaki bahe nopomae qesa naru hiireqi seike oma koko teeke nopome quba qaateqi koko temuke noi aima Qaru abiho dzagata mootoqi hee, oqaioniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Oke hiiremi Peetoroi hee, Anania nii naane qubake Saatai niiho qupa rasaki eetemi Qaheuba Sumasake ikobeteqi ttoka ma haba niimeho ttuma koko qahitotoraidzo? ");
INSERT INTO ghs_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ttoka ma haba niihoho koko teei oorareiqa oorakoi. Mae nipe oho ttuma quba hiiremi oma biranatemi ooma nipe quba tee ma teeke eetarorihe, naane qubake qupa niihoi niike ikobetemi nii oke eeteo? Nii abi nanake bahe Ohongake ikobetareiqi hee, Ttuma paha teei te ooraidzaraniqi hiire oi bamenoma! ");
INSERT INTO ghs_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hiiremi Anania noi noo oke nookahiqi taate baateta. Obetemi qesai moo nookata nokoi atti minanipamuke eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Qate abi khameto nokoi Ananiaho kebake aima tuuma ao qurabireta. ");
INSERT INTO ghs_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Obetemi bodza khara naataamake ata nohoi noka pobitaamake teka teena ota biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Biranatemi Peetoroi noke qasa hiireqi hee, Ttokaho ttuma oqaioni mae? Nii ana pobi hiibare, Hiiremi noi hee, Oore oqaioni. ");
INSERT INTO ghs_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Hiiremi Peetoro erake no pobi hiireta, Apu ma nipei naane qubake Ohongaho Sumasa ikobetareiqi erake eete? Oionita moorare, abi khameto apu niihoke ai tuuma qurabire nokoi burisi eete baahuqi naga pou samata qooro ooraita nokoi paha niiho kebake aima tuuma qurabidzakoi. Noi oke hiimi Sapirai ao oko toro nohota taate baateta. ");
INSERT INTO ghs_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Baatemi abi khameto nokoi keba nohoke aima tuuma apu noho qurabireta teka teena ota noke qurabireta. ");
INSERT INTO ghs_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Obetemi sobasoba tupu nokoi oho pobi nookaqi gama susupu atti ququimaqi qaata. ");
INSERT INTO ghs_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Oonita Qaru abi nokoi obaoba ma quba nese agiagi maina painake abiho pengata eetemi noko mooqi teena naate Ohongaho biiri totaqi, dzapa noho Soromoho suruho ota noko ttutturate qaata. ");
INSERT INTO ghs_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Oonihe abi sigina qesai nokoho ttaiqa naataranihe nokohoke nookami dzapa pobinoma naateta. ");
INSERT INTO ghs_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Qate abi paha qesa samane, oi abi ma paimane tupu minai nooka hiisi eeteqi Ohongata ipibireta. ");
INSERT INTO ghs_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Oke eetemi nokoi qesa ma dzaira nokoho apenei keba ma khetedza naate mee dzeuba qaata, ma pone ma qeqesa naate meramera tekata mee qaata, nokoke teteta mootomi Peetoroi baa riinimi noho sumusumui nokoke sirihahimi qidzanate qaata. ");
INSERT INTO ghs_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Oke eetemi Dzerusaremu nagapa totaqi ma totaqi abi tupu mina qaata, nokoi gama susupu khetedzanoma ma songena ngiinginoma oke aima biranatemi nokoi oho qesa gama qidzanate qaata. ");
INSERT INTO ghs_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Qateqa dzube abi mina ma Satukeoho nena nokoi ");
INSERT INTO ghs_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Qaru abiho baurake bisi naateqi Qaru abi mimike aimaqi sutasuta naga minata mootota. ");
INSERT INTO ghs_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Oonihe qupibake Sooparaho angero teei sutasuta naga mina oke kurauma noko dzeima qurateqi hiireta, ");
INSERT INTO ghs_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Nikei tuumaqa Ohongaho Biirita peiteqa teka nikemeta qooroqa qaraqara tatangaho kuku ma khooba abike pobi hiire qaarare. ");
INSERT INTO ghs_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Hiiremi nokoi tuumaqi Biirita dzuubaqi saunaba samaneke abi ma khata nokoke qusuho qaraqara oho pobi hiireta. Oonihe dzube abi mina ma qesa noho torona oota nokoi sinasina tupu ma Isiraeho Kanusoreho tupu mina oke gama ttuttuiteqi habeseta. Nokoi hee, Oonita noo dzoobiremi sutasuta nagata oorai qaru abi oke dzeima baabareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Oonihe pirittani nokoi qeemaqi sutasuta nagake moohimi nokoi bamu naateta. Bamu naatemi noko ao burisi eete oho isere hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Hee, Ae! sutasuta nagaho tete oi sibasibai oori, qate tete soopara abi paha pouta oori. Oonihe nanai tete geema pei moohimi teei te nakuta oorara, baamu! ");
INSERT INTO ghs_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Noo oke hiiremi Biiriho soopara ma dzube abi mimi nokoi nookaqi oho iiha ma dzoobidza eeteqi hee, Nokoi ikanomake eeteqi biranate? ");
INSERT INTO ghs_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Oke hiiremi teei baaqi hee, Maqa, nikei sutasutata mootota abi naga nokoi qaheuba biirita abi ma khata sinabidza pobi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Oke hiimi biiriho soopara ma pirittani nokoi tuumaqi moota, Ma nokoi qaru abike urupusa eete aimarotahe eto abi qesai nokomaeke omama teetainoiqi nokoke keba ma dzapata dzeima baata. ");
INSERT INTO ghs_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Oonita nokoi Qaru abi oke aima bisa nokometa mootomi dzube abi minai nokoke qasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Nanai nike Dzesuho dzapake hiire paanaitainoiqi hiiretake nike naane quba abi bapotopotomi dzapa oi Dzerusaremuta gegebetorai? ");
INSERT INTO ghs_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Hiiremi Peetoroi Qesamane nomeho puike naateqi noo ipi erake hiireta. Baamu, nanai abiho nooke qaateqi Ohongaho noo qusubaitorai. ");
INSERT INTO ghs_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nookao, nikei Dzesuke hapahapanaitemi baateta. Noke uimane napahoho Ohonga Mai tukutoqi qaraqara moiteta. ");
INSERT INTO ghs_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Oi Isirae abi ma napai qupa buirisi baura eeteqa kahosa napemeho dzamudzamu saridza qubake Ohongai noke ai qusubaitemi noi bosa qobaqoba ma ingona mai minanipamu napahoke naate oorai. ");
INSERT INTO ghs_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Oonita nanai nese nanamema quba oke gama mooqi hiirorai, oonihe nanaqeke keke bamuhe apenei Ohongake qusubaitorai nokoma nanake Ohongai Sumasa nome moitemi ooraita nanaio noho noo qaupuitorai. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Hiiremi noko noo oke nookami nokoho dzauba peitemi Qaru abi oke teetareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Oonihe Kaunsoriho tupu ota Sattukeo abi keke bahe paha Pariseoho abi teei oota, dzapa noho Gamarie, noi hu nooho sinasina abinipamu, noho dzapake abi qusubaite qaata oonita noi Qaru abi nokoke hee, Nikei paata qurateqa oorareqa teeke eetare. ");
INSERT INTO ghs_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Noi oke hiiremi Qaru abi nokoi paata quratemi abi oi qesamane nomeke erake pobi hiireta. Isiraeho maimane nookao. Abinaga erake quba teeke eetareiqa iiha dzoobireqake eetare. ");
INSERT INTO ghs_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Bosata abi teei qaata dzapa noho Teuta, noi hee, Anai abi ohonga, bosa qobaqoba nokohoniqi hiiremi abi 400 nohota ipibireta. Obetemi Roma abi noke teetemi oko ma boto noho sakabami oho noo bamu naateta. ");
INSERT INTO ghs_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Qate noho ipiqata Garirea habaho abi teei qaata, dzapa noho Dzuta (oi abi maina). Noi dzapa qetaqeta bodza napahota abi qesake ikobeteqi dzeima qaatahe noi oho qesa bamu naatemi noho oko ma boto gama sakabaqi baamu naateta. ");
INSERT INTO ghs_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Oonita quba oonoma biranate qaimi ana nike pobi hiire nookare. Nike abinaga erake qaatemi noko sepeke oorare. Nokoi noo ma baura mina erake eetorai oi noko qupa nokometa eetoraquko oi rasakinoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Oonihe Onongaho baurai ooraquko nike nokoke suqobidzaquho isakiama naatakoi ma Ohongaho baurai ooraquko nike Ohongake ibo eetakoita nookare, ooiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Oke hiiremi nokoi qaru abi nokoho quba hiiremi garubata peitemi gouma teeteqi erake hiireta. Nike Dzesuho dzapake abi pobi hiibainoiqi hiireqi dzoobireta. ");
INSERT INTO ghs_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Dzoobiremi nokoi Dzesuho dzapaho quba heme saridzetaho midza te eetaranihe ohongahonga naateta. ");
INSERT INTO ghs_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Oke eeteqi noko bodza ma sau samane Dzesuke Kiristu ooniqi hiireqi oho noo ma sinabidza Biirita hiire qaata. Oho qesa naga nokome ma nokometa nokoi hiire qaata. ");
INSERT INTO ghs_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Bodza ota sinabidzaho abi tupu gaira naatemi noko patta ttihu biire qaami Girikiho noonoma nokoi qesa Heboroho noota hiire qaata nokoke hee, Nikei naane quba nanaho ttarumike qaateqi ooraidzo? ");
INSERT INTO ghs_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Oke hiiremi Qaru abi mimi nokoi abi ttuttuiteqi hiireta, Nanamae Ohongaho baura qaateqa samaho ttihu biidzaqu oi baamu isanataqu. Oonita nikeho neta abi sebenike oho baura quba paanaitare. ");
INSERT INTO ghs_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Oonihe abi nokanoka, Sumasanoma oomake nike batabireqi napai nokoke oho baura moitemi eetorare. ");
INSERT INTO ghs_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Qate nanaio bodza nanameta pupu ma sinabidza baura oke eete qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Noo oke Qaru abi mimi hiiremi minarai nookami isanatemi nokoi abi erake paanaiteta: oi Setepano (abi nooka hiisi eetanoma, Qaheuba Sumasa noho qupata heuheu eete qaata) ma Piripo ma Porokoro ma Nikano ma Ttimo ma Pamena ma Nikora (noi Attiokhia nagapa nena raaba abi Dzuta abihota ipibireta). ");
INSERT INTO ghs_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nokoqake uhutoqi nokoke Qaru abiho dzagata mootomi noko qiba nokohota boto mootoqi agoago eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Obetemi Ohongaho sinabidza kata gaamami Dzerusaremuta abi tupu minanipamu naateta. Paha dzube abihota minanipamui sinabidza nooka tani naateta. ");
INSERT INTO ghs_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Qate Setepanoke abi nookami bagenoma beedzae minanoma noi abiho bisata quba nese agiagi eete qaami subesubeho isaki naate qaata. ");
INSERT INTO ghs_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Oonihe abi tupu nokanoka naga teeho nena naga oke hee Saqosaqo abiniqi hiire qaata, oho neta Kirena abi ma Aresatteria abi ma Kirikia abi ma Asia gattiqaho abi oi teena naateqi Setepano ma noko qesa kurebete qaata. ");
INSERT INTO ghs_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Oonihe noo oke noi Sumasama hiiremi nokanokanomanipamu naatemi nokoho noo asaqobami bitta eete qaateta. ");
INSERT INTO ghs_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Oonihe nokoi noho qore ma geema hiibareiqi abi qesa uhutomi nokoi hee, Abi oi Mose ma Ohongake dzakidzake eetoraiqi hiiremi nana nooke. ");
INSERT INTO ghs_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Oke hiireqi nokoi abi sepe ma Dzuta abi mimi ma qetaqeta abi qesake bitta ma kaka eetemi nokoi Setepanoho qaa mootoqi aima sinasina abi mimiho nagata tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Oonihe ao noo suutoqi qesamane moitemi aima oota noko oke hiiremi Setepanoho obera noo erake hiireta, Abi oi hapaho qaheuba biiri ma hu noo napahoke qangake keke hiiremi nanai nookorai. ");
INSERT INTO ghs_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Noi hee, Dzesu Nadzarette ho nenai nagapa erake ngausa eeteqa tete Mose napaho quba hiire paanaiteta oke rasaki eetakoi noo oonomake hiirorai. ");
INSERT INTO ghs_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Oonihe sinasina tuputa oota nokoi gama moohimi Setepanoi angero midza ma attiamaho isakita oota. ");
INSERT INTO ghs_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Oonita dzube abi mina noi erake hiireta, Oi noo mee ooni mae? ");
INSERT INTO ghs_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Hiiremi Setepano noi eraiqi hiireta, Maimane ma dzairamane name nike nookare. Napaho eebobo Abrahamu noi Harani nagapa Mesopotamia habata qaami Ohongaho totoho noho toro biranateqi hiireta, ");
INSERT INTO ghs_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Nii poike haba khooba ma nagapa qiba niime qaateqa haba anai niiho quba hiire oorai ota tuuma qaarare. ");
INSERT INTO ghs_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Hiiremi Abarahamu noi noo oke nookaqi Kharattea haba nome qaateqi Harani nagapata tuumami mai noho baatemi Ohongai haba nike ma napai maikhameto naate oorai erata dzeima baata. ");
INSERT INTO ghs_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Dzeima baaqi haba koko teeqake noi teqaha noke moitara, baamuhe Abarahamui biidzaamake ooqi ipita eemane khameto nomema gama mai eetarotaho naruqake Ohongai hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ohongai tete erake noke pobi hiireta. Biidza ma khata niiho nokoi haba kharata tuumaqa dzore ma aabeho isakita gaama haba oho maikhametoi nokoke sesero eete qaamake tii 400 naatakoi. ");
INSERT INTO ghs_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Oonihe tii 400 naatemake haba oho maikhameto apenei sutasuta baura moitoraqu nokoke ana ipi moitakoi oiqi Ohongai hiireta. Noi hee, Nokoke ipi moitemi biidza ma khata niihoi saqosaqo naateqake biranate haba erata baaqa anaho qaru eete qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Qate Ohongai sama geebaho noo Abarahamuke moitemi qusubaite qaata. Oonita Ohonga hiiretaho isakita khata noho biranate qupi 8 naatemi noke geebanomaiteta. Geebanomaitemi Isaka noi bitoto qaaqi ipita Dzakopoho mai naateta. Dzakopoi abi tuerebe nokoho mai oio Isirae abiho nase ooni. ");
INSERT INTO ghs_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Qate neimane napaho nokoi noma nokome Dzosepe biisi naateqi noke ttuma quba mootomi noi Aigitta habata tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Oonihe Onongai noke gainene eete qaata. Oonita noi qangahasita oomi Ohonga noke hoobiremi Aigittaho abi qiba Parao noi noke moomi noho qupa qidzanipamu naatemi noho dza eeteqi noke minaraho soopara upubiremi haba mina noho ma guhu ma nagapa noho oke noi gama soopara eete qaata. ");
INSERT INTO ghs_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Qate Aititta ma Kana habata seebe mina biranatemi neimane napaho seebe meeqi ttidza uhuba bosasuba qaata. ");
INSERT INTO ghs_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Qaaqi Dzakopo noi nookami Aigitta habata patta oorai hiiremi nookaqi khameto nome dzoobiremi ota tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Oonihe bodza temuta Dzosepe noomae nanemane nomeho khooba hiire paanaitemi ota Parao noi Dzosepe biranatetaho khooba gesina naateta. ");
INSERT INTO ghs_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Obetemi Dzosepe hiiremi mai noho Dzakopo noi quba samane nome gama susupu aimaqi nokoi abi ma paimane dzare 75 naateqi Aigitta habata tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Oonita Dzakopo noi Aigitta habata qaaqi baateta ma khameto noho oi neimane napaho nokoi oho qesa baate baamu naateta. ");
INSERT INTO ghs_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Baatemi noko keba nokohoke aima baaqi Abarahamu noi Sekhemu nagapa Hamoro ma quni ma manihota ttoka teke nesetu quba ttuma eeteta ota nokoi keba nokohoke mootota. ");
INSERT INTO ghs_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Obetemi Ohonga naru noo Abarahamu pobi hiireta oi kebanonipamuke tataumarota oonita nokoi Aigitta habata minanipamu huba biireta. ");
INSERT INTO ghs_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Oke eete qaami Aigitta abi qiba usaqe tee biranateta noi Dzosepeho isaki ababara naateta. ");
INSERT INTO ghs_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Noi neimane napahoke eenaiteqi sesero minake eete qaata. Eesuqi khameto bittina teete kebaite qaata. ");
INSERT INTO ghs_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Qate kebanoke Mose biranateta. Biranatemi Ohonga nookami noi khata bagenoma oonita pai noke dzasidza tapariho isakita maiho nagata amena moitemi qaata. ");
INSERT INTO ghs_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Qaami nokoi noke dzukuromi Paraoho khatatai saridzeqi aimami noi noho khata naateta. ");
INSERT INTO ghs_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Eetemi Aigittaho banaita mimi noke noo moite qaami nokanokaho gesina saridzeqi, Aigittaho noo ma baura oho abi mina naateta. ");
INSERT INTO ghs_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Oonihe Mosei qaami tii noho 40 naatemi dzairamane nome Isiraeho abi tupu nokoke moorare qupa nohota tukubami tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tuumoqi noi moohimi Aigitta abi teei Isiraeho teeke oberama eetomi noi qesa nomeke hoobidzareiqi Aigitta abi oke teetemi baateta. ");
INSERT INTO ghs_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Oi noi erake qupadzomata, Ohongai anake asatemi ana noho boto naate Isirae abike Paraoho botota karabetareimi Isirae abi nokoi khooba qupadzomaridzoni. Oke hiireqi noi Aigitta abi oke teeteta. ");
INSERT INTO ghs_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","27","Oonihe noho qesamane oke te qupadzomara. Oi iihai mootomi Mosei nokoho toro tuumomi Isirae abi eseri nokomae samai keke temu temuke botoma teetomi noi mooqi hee, Nipe sama teenanihe naane quba qesa teetorai? Hiiremi abi qaa sohorota noi hee, Nii nakaho kiapeni, mae apei niike nanaho soopara moote? ");
INSERT INTO ghs_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Oonita nii arukuke Aigitta abi teete baateta oho qesake nii anake teetareke hiireo? ");
INSERT INTO ghs_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Hiiremi oionita Mosei oho totoho nookami atti noke suqobiremi noi Mittia habata tuumaqi abi agiagiho bisata soomata. Oonihe noi ota ata naatemi khameto noho eseri biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Oonita noi ota qaami tii pooti naatemi noi tora Sinaiho khoobata tuumomi ee hoho teei qaitomi oho gabi nakuta Ohongaho angero teei ota biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Oonihe Mosei hee, Quba apei oke eetorai hiireta, bageke eete moorakoi hiireqi ota qeemomi Sooparaho totoho ota biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Oi hee, Anaio Abarahamu ma Isaka ma Dzakopoho eebobo ma uimane niihoho Ononga oonita nookare. Hiiremi Mosei noo oke nooka roqobeteqi subateta. ");
INSERT INTO ghs_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Subatemi Ohongai eraiqi hiireta, Nii ttoka qoore oi Qaheubananita oko sasa niime ao hiumare. ");
INSERT INTO ghs_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Oonita abi tupu nahoi Aigittata ooraiqi abiho botota heme saridzeqi tti ma ttaka eete baa qaimi ana poiqa oke suhe hiibaridzoni. Oho quba ana niike dzoobiremi Aigitta habata tuumami ana hiiremi nii abi tupu ota hiumakoi. ");
INSERT INTO ghs_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Oiqi Ohongai Moseke pobi hiiretake Setepanoi abi mimi qupanomaiteta. Noi hee, Oonita nike moomi qesai Mose dzaira eetaama naateqi hee, Apei niike kiape ma soopara nanaho uhutotaiqi hiireta. Oonihe Ohongai angero dzoobiremi noi eepa gabi nakuta biranateqi bosa qobaqoba ma ingona maiho baura oke Mose teena mai eetare pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Hiiremi noi tuumaqi obaoba samaneke Aigitta habata eetetati noko dzeima baaqi besa dzuunoma ma haba habanata obaoba samane eetemi mumure naate qaami tii paha pooti baamu naateta. ");
INSERT INTO ghs_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Oi Mosei keke Isirae abi eraiqi pobi hiireta, Ohonga noomae too abi teeke anaho tomidzake qesamane nikehoho bisata saridzakoi. ");
INSERT INTO ghs_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Oke hiireqi noi keke haba habanata neimane napahoho garubata qaaqi Sinai torata angeroho toota oora ma qaaraho sinasina bamenoma nookaqi oke noko pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","40","Hiiremi neimane napaho nokoi Moseho noo bai hiireqi ai siginaiteta. Oi nokoho qupai hee, Ao burisi eete Aigitta habata tuumareiqi hiiremi nokoi Aaro erake pobi hiireta, Maqa! Mose nanake Aigitta habata dzeima baata noi poi tuuma dzaeteta kaqa? Oonita nii gisigisi teeke korabetemi noi nanaho ohonga naate bosa qooromi nana burisi eete Aigitta habata tuumare. ");
INSERT INTO ghs_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Oke hiiremi Aaroi kau gisigisi teeke botoma korabeteqi nokomaeho boto kinisa oho hasahasa hiireqi oho kiridza qeereta. ");
INSERT INTO ghs_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Oke bohimi Ohongai noko qaatemi qupa nokohoi rasaki naatemi nokoi dzasidza ma pomatti (oi sinabidza oberaobera) ota qeemaqi soomata. Oho qubake Amosi too abi nokohota noo qeeteta oi erake hiire oorai, Isirae maikhameto nike tii pooti haba habanata qaaqi kabiraho kiridza mae kiridza qesa oke Ohonga anaho quba qeereta mae? ");
INSERT INTO ghs_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Eehe, nike Morokhaho paraike qusubaite qaaqi, paha Repani noho taama gisigisike khakhauma qaata. Quba oonomai Isirae ma nikeho ohongaho isaki naatemi noko pupu hiireqi korabete qaabi. Oho qubake anai hiiremake qaa abi nokoi nike suutoqa dzeima Baberonia nagapata tuumakoi oiqi hiiremi Amosi qeeteta. ");
INSERT INTO ghs_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Hiireqi Setepanoi Dzuta abi mimike hee, Oonita uimane napahoho sinabidza parai naga haba habanata qaata oho horeke Ohongai bosata Mose banaitemi oho isakita gootota. ");
INSERT INTO ghs_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Obetemi Uimane napaho sinabidza parai suba oke biire biire baa pei qaami, Mose bahe Dzosuba (Dzesuho qaamodzamodza) noi bosa qooromi erata raaba abiho bisata baaqi biranateta. Biranatemi Ohongai raaba abi iihami uimane napaho haba oke mai eeteqi sinabidza parai suba oke biire qaami Tabiti biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Biranatemi Ohonga nohoke nookami bagenoma naatemi oho quba noi Dzakopoho Ohonga (Ohonganipamu) noho biiri teeke gootareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Oonihe noomae bahe, khata noho Soromo (noi paha Dzesuho qaamodzamodza) noio Ohongaho biiri gootota. ");
INSERT INTO ghs_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Oonihe Ohongaio qusu ma quba minarahonita abi botoma gootorai naga ota noi ikanomake eete oora ma qaara eetaqu? Baamu. Oho qubake Dzesea too abiho toota noo erake hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Qusui naho ttube ma ttaraki qaate ttokai naho basanita naho naga ikanomake gootomake isanataqu? Ma teeka ikanomake korabetemi ana ota mee qidzanaataqu? Noo oke Soopara napahoi hiireqi hee, ");
INSERT INTO ghs_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Apeho boto bahe Naamaeho botoi quba erake korabete soubireta. Oiqi Ohongai hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Noo oke Setepanoi Dzuta abi mimike pobi hiireqi noi hee, Oonita qiba qanganoma nike! Qupa ma toma nikehoi uhubaamanipamu. Oonita neimane nikehoi eete qaata teteke nike iihaqi Qaheuba Sumasake basesa eetoraidzo? ");
INSERT INTO ghs_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Oonita too abi samane baa qaata nokohota teena teeke nikeho neimanei ingonaiteta, mae nokoke gama sesero eete qaata? Baamu, nokoke gama sesero eete qaata. Oi apenei pobipobi ma rikerikeho Maikhata biranatarotaho qaamodzamodzake hiireta nokoke nikeho neimane gama teetemi baateta. Qaaramuti Maikhata noomae biranatemi nike noke geema mootomi teeteta. Nikeio eeteta! Oke Setepanoi nokoke pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Setepanoi ipibireqi Dzuta abi mimike hiimotoqi hiireta, Oonita hu nooke angeroi tooma hiireta oke nike too kakama aimatahe qusubaitaamanipamu ooni! ");
INSERT INTO ghs_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Noo oke Setepanoi hiiremi nokoho ttidza qosu sahaubami dzauba minake eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Oonihe Setepano noke Qaheuba Sumasai ao raraku biiremi noi qusuta nese dzoobire Ohongaho dzapa pobi moohimi Abiho Isaki pobita qooroqi oota. ");
INSERT INTO ghs_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Oke mooqi noi hee, Idze! Qusu papatemi ana moohimi abiho isaki Dzesui Ohongaho boto pobita oorami ana moori. ");
INSERT INTO ghs_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Oke hiiremi noko qarutoqi noho noo rasaki eeteqi toma nokome isingi kotoro noke aima hotou hotou biireta. ");
INSERT INTO ghs_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nokoi tuuma nagapa tumeta noke omama teetare boohita. Oke boohiqi soopara nokoi sasa khara nokomeke kuimaqi abi eehaha tee, dzapa noho Sauro, noho dzagata tupu biireta. Tupu biireqi Setepanoke omama teeteta. ");
INSERT INTO ghs_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Oonihe nokoi Setepanoke omama teetomi noi pupu totoho eraiqi hiireta, O Soopara Dzesu, nii gisi nahoke aimare. ");
INSERT INTO ghs_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Oke hiireqi dzaubama sokateqi eraiqi hiireta. Soopara name, nii kahosa nokoho erake qaatare, oiqi hiireqi baateta. Baatemi Sauro (oi Pauro) noi nookami isanateta. ");
INSERT INTO ghs_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Nokoi Setepanoke omama teetemi baatemi sinabidza abi qesai noho keba qurabireqi tti ma ttaka noho eetota. Oonihe Sauro (oi Pauro) noi beedzae eeteqi sobasobaho abi ma paimane sesero minake eeteqi nagaho isakita peiteqi nokoke aima tuumami sutasutata qaata. Khooba oho qubake bodza ooqate sinabidzaho abi tupu Dzerusaremu nagapana qaata nokota uuba ma sakaba mina biranatemi nokoi sakabaqi Dzutea ma Saramia habata tuuma tee ma teeta soomaqi qaata. Oonihe Qaru abi mimi nokoqai keke Dzerusaremuta qaata. ");
INSERT INTO ghs_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Oonihe apenei qaaho atti ika ma ikata tuumata noko abike sinabidza pobi hiire tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Oonita Piripoi Samaria habaho nagapa qibata biranateqi Kiristuho noo ma sinabidza nokoho quba hiire paanaite qaata. ");
INSERT INTO ghs_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Oke eete qaaqi obaoba maina paina eetemi abi tupu minai gamaqa noho noo ma baura quba dzaodzao minanipamuke eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Oi noi abiho irita songena ngiinginoma samaneke iihami arearema biranate atti tuumata. Paha pone ma qosu samaneke qidzaiteta. ");
INSERT INTO ghs_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Eetemi nagapa oho abi qakiqaki minake eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Oonihe nagapa ota abi tee qaata dzapa noho Simona noi sama nome qusubaiteqi hee, Anai minaniqi hiireqi iima ttopo eetemi Samaria abi tupu minai nookami attinoma naate qaata. ");
INSERT INTO ghs_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Eetemi mina ma gattiqa nokoi nohoke nookami mina naatemi eraiqi hiire qaata. Abirai Ohongaho beedzae minanipamuniqi hiireqi hee, Beedzae teeho bahe oioniqi hiire qaata. ");
INSERT INTO ghs_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Eetemi noho iima ttopoi nokoke qupa rasakinomaitemi nokoi bodza kharake nota atima qaata. ");
INSERT INTO ghs_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Qaami Piripoi Ohongaho pobi ma Kiristuho isere qidza hiiremi abi ma paimane gama susupu nooka hiisi eeteqi sinabidzaho sobasoba saridze soubireta. ");
INSERT INTO ghs_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saridze soubiremi Simona oho qesa sinabidza nookaqi noomae sobasoba saridzeqi Piripoho dzagata qaata. Qaami Piripoi obaoba maina painake eetemi noi mooqi boto gaamaqi qaata. ");
INSERT INTO ghs_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Oionita Samariaho abi ma paimane sinabidza nooka hiisi eetemi oho pobi Dzerusaremuta baami Qaru abi nookaqi Peetoro ma Dzohane dzoobiremi ota tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tuuma biranateqi Samaria abi nokoi Sumasa saridzareiqi pupu hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Oi bosata noko sobasoba saridzetahe Qaheuba Sumasai noko raraku bidzaamake oota oi teeho bahe noko Dzesu Kiristuho dzapa nookaqi obaqaho sobasobake saridzeta. ");
INSERT INTO ghs_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Oonita Qaru abi nopoi boto nopome qiba nokohota mootoqi agoago eetemi Qaheuba Sumasake saridzeta. ");
INSERT INTO ghs_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Qate nopoi abi ma paimaneho qibata boto nopome mootomi Sumasa biranatemi Simonai mooqi baura oonoma saridzare hiireqi noi nopoke oho ttuma moitare hiireta, ");
INSERT INTO ghs_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Nipei beedzae oho qesa teeke ana moitemake, ana abi teeho qibata boto name mootomake noi Sumasanoma naatare. ");
INSERT INTO ghs_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Hiiremi Peetoro eraiqi hiireta. Maqa, nii Ohongaho kokorake ttuma eetareiqi hiibi mae? Idzii! Nii ao oma niimema rubenga naasuidzo. ");
INSERT INTO ghs_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nii Ohongake ikobetareiqi baura eraho ttaiqa naataquho tete baamunipamu! ");
INSERT INTO ghs_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Oho qubake nii rasaki niimeke qaatanipamuke eeteqa Ohongake pupu hiiremi noi qupa qanga niihoke qidzaitaqu mae? ");
INSERT INTO ghs_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Oi ana moohimi nii pasenaho dzoquta ooraimi oho togoi niike igabiremi oorai. ");
INSERT INTO ghs_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Oke hiiremi Simonai hee, Oonita nipemae naho quba Ohongaho toro pupu hiiremake ana ingonaitemi quba nipei hiibi oi eetoqa naho irita biranataino. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Qate Qaru abi nopoi isere nopome ma Ohongaho noo oke gama abi ma khata pobi hiire tatangaite soubireqi burisi eete Dzerusaremuta tuumata. Oonihe tuusuqi nopoi Samariaho nagapa gamitti samaneke Sinabidza pobi hiire hiireke tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Qate Sooparaho angero teei Piripoke eraiqi pobi hiireta, Nii qoridze pobi neta tuusuhiqa Dzerusaremu nagapa robena Gadza nagapana tete quratorai tete oi haba habana oonihe nii ota tuumare. ");
INSERT INTO ghs_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Hiiremi Piripoi noo oke qusubaiteqi tuumata. Qate Ettiopia habata atapa qiba teei qaata, dzapa noho Kattake, Noho kokora abi puniama nokanoka minanoma noi ttuma ma quruma mina nohoke soopara eete qaata. Oonihe noi Dzerusaremu nagapata Ohonga penga bobotare baa peiteta. ");
INSERT INTO ghs_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Peiteqi burisi eete karesita habeseqi nagapa nometa tuusuhiqi too abi Dzeseaho pepake isaitota. ");
INSERT INTO ghs_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Oke eesuhimi Sumasai Piripoke hee, Nii hairiamake tuuma karesi qeerake saridzare. ");
INSERT INTO ghs_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Hiiremi Piripo torouma qeema saridze nookami noi too abi Dzeseaho geeta isaitomi noi noke qasa hiireta. Nii noo isaitoraihe oho khooba qupadzomorai mae? ");
INSERT INTO ghs_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Hiiremi noi hee, Abi teei oho khooba ana pobi hiiremake ana nookareni baamu. Oonita noi Piripoke ota peitareiqi hiiremi pei noma habeseta. ");
INSERT INTO ghs_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Qate noo qetaqeta noi isaitota oi erani. Abi noke sipisipiho isakita aimami nooamake tuumorai, mae sipisipi khata teeke suu geemami nipanatoraiho qesake noi noo amake oota. ");
INSERT INTO ghs_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","34","Nokoi noke midzata mootomi noi oho quba noo ipi hiibaquho tete baamu naateta. Ma ttokata nokoi qaraqara nohoke geemataho qubake apei ororiba nohoke isaitaqu? Oho teteta isaiteqi abi mina noi Piripo qasa hiireqi hee, Too abi noi apehoke hiireta, sama nomeke hiiretani mae apeke hiireta? Oho khoobake nii hiire ana nookare. ");
INSERT INTO ghs_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Hiiremi Piripoi too abiho noota ipibireqi Dzesuho isere qidza no pobi hiiremi nookata. ");
INSERT INTO ghs_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Oke nopo hiire tuuma qaramuti obata biranateta. Biranateqi abi minai hiireta, Moora, oba ooraita ana sobasoba quba hiiremi nii isanate anake obama soobaqu mae? ");
INSERT INTO ghs_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Hiiremi Piripoi hee, Anai noo nii pobi hiibi oke nii qupa susupu niimema nooka hiisi eetaquko oke eetakoi. Hiiremi noi hee, Dzesu Kiristu Ohongaho khata oke ana qupa susupu namema ai tataume. ");
INSERT INTO ghs_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Oke hiireqi Piripo ma abi mina nopoi ota karesi qaateqi obata qurateqi Piripoi obama noke soorota. ");
INSERT INTO ghs_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Obeteqi nopoi oba neta baa peihiqi Ohongaho Sumasai ao Piripoke raraku biiremi abi mina noi noke mooraama naateta. ");
INSERT INTO ghs_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Oonihe meeke abi mina noi ttidza qidzama tete nometa tuumata. Qate Piripoi Adzota nagapata biranatemi moota. Oonita noi ota sohoroqi nagapa samaneke sinabidza pobi hiire tuuma qaaramuti Kaisarea nagapa biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Qate Sauro (oi Pauro) noi dzauba bisamu naateqi Dzesuho oko ma boto ibo eetemi noho qupata eepa qooridzemi noi dzube abi minaho torota tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Tuuma gunu ma naru hiiremi Ttamasiko nagapata dzuta abi qaata nokoho pepake dzube abi mina qeeteqi moitemi Sauro aima qee ota sinabidza nokanoka abi ma paimane saridze aima boto suuto Dzerusaremu nagapata aima baabareiqi tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Oonihe qesa ma nokoi tete bosaho eete tuuma Ttamasiko nagapa dzamoitemi qusuta eepa dzadza kisakisama uhubaqi qura noke rome biireta. ");
INSERT INTO ghs_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Eetemi noi ttokata taasuhimi ota totoho teei hee, Sauro, Sauro nii naane iboke eeteqi anake iihorai? ");
INSERT INTO ghs_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Hiiremi Sauroi qasa hiireta, Oonita Soopara name nii ape oni? Hiimi hee, Anai ape bahe Dzesu Kiristu nii ibo eetorai ooni. ");
INSERT INTO ghs_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Oonita nii qooridzeqa Ttamasiko nagapata tuumake teei niike ota saridzeqa sinasina hiiremi oke nii qusubaitare. ");
INSERT INTO ghs_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Noo oonoma hiiromi abi noma noko baaota nokoi noo totohoqake nookatani quba teeke te ota mooraranita noko noo apeke hiiremi isanatarota? Baamu. ");
INSERT INTO ghs_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Qate Sauro noi ttoka neta qoridzemi eehe, nese nohoi ao khaba eeteta. Khaba eetemi qesamane nohoi boto nohota kharikhari eete ai Ttamasiko nagapata tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tuumaqi noi ota biranate qupi taparike eetetahe nese noho teqaha uhubara, ma noi teqaha oba ma patta muunara. ");
INSERT INTO ghs_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Oonihe Ttamasikota Dzesuho qaru khata teei qaata dzapa noho Anania. Noke Ohongai tukutoqi hee, Anania! ");
INSERT INTO ghs_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","12","Oke hiiremi noi hee, Oe Ohonga anai erani. Hiiremi Ohongai ipibireqi hiireta, Maa, tete teeho dzapa pobipobi ota nii tuuma Dzutaho nagapa peiteqa abi tee, dzapa noho Sauro, noi Tarasu nagapa nena. Oonihe noi naho pupu hiiroraita qupa nohoi quba erake qupadzome: Abi teeho dzapa Anania noi naho toro baahuqa boto nome qiba nahota mootomi nese uhubareiqi hiirorai. Oonita nii tuuma noke saridze qidzaitare. ");
INSERT INTO ghs_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Sooparai noo oke hiiremi Ananiai eraiqi hiireta, Abi ohoke minanipamuke hiiremi ana nookorai, noi dzagana niihoke Dzerusaremu nagapata adzapeke sesero eetorai. ");
INSERT INTO ghs_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Obeteqi erata nanai niiho dzapa qiraitorai nanake suuto ai tuumare dzube abi minai noke pobi hiiremi oorai. ");
INSERT INTO ghs_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Hiiremi Ohongai hee, Abi oke naamae asatemi noi naho kamo naate dzapa pobi nahoke raaba abi qiba ma Isirae tupu nokohota aima tuuma qaarakoi. ");
INSERT INTO ghs_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Oi noi dzapa pobi nahoho quba iima ma bago samaneke saridze qaaraqu oke ana isanate noke banaitakoita nii tuuma noke qidzaitare. ");
INSERT INTO ghs_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Oke hiiremi Anania noi tuuma naga hiireta ota peiteqi Sauroho qibata boto mootoqi hiireta, Sauro, qeseba khata name. Dzesu Sooparai teteta niiho toro biranate noi ana dzoobiremi baabe. Oonita nese niiho uhubami Qaheuba Sumasai ao niike raraku biidzare. ");
INSERT INTO ghs_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Oke hiiremi noho neseta quba qoringi tomidza teei taatemi nese uhubami haba moota. Oonita noi qooridze hiiremi Ananiai noke obama soorota. ");
INSERT INTO ghs_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Obama sooromi oionita noi patta muunaqi tatanga aimata. ");
INSERT INTO ghs_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ma Sauro noi Ttamasikota Dzesuho oko ma boto ma nokoi isakiqata oota. Ooqi noi ao Dzuta abiho sinabidza guhuta peiteqi Dzesuho khooba hiire paanaiteqi eraiqi hiireta, Dzesu Kiristu noio Ohongaho khatanipamu ooni. ");
INSERT INTO ghs_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Oke hiiremi nokoi nookaqi houpeu eeteqi hiireta, Dzerusaremu nagapata dzapa oke abi qiraite qaami oho quba noi nokoke sesero minake eeteqi suuto baa qaarita erata oho qesa abi suutoqa dzeima dzube abi mimi nokoho botota mootare baata. Oonihe noi ikanomake eeteqi ao maina naate oorai, eo baamu? Atti quba hiireqi oke hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Oonihe Sauro noi bedzabedza eeteqi hiireta, Dzesu noi Kiristunipamu ooniqi hiireqi sinabidza noo suunipamuta hiire paanaitemi oi Dzuta abi hu noonoma nokoke suqobidzaquho isaki naateta. ");
INSERT INTO ghs_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Oho ipi ota dzuta abi nokoi Sauro teetare gunu dzoomata. ");
INSERT INTO ghs_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","25","Gunu dzoomatanihe noi ao pobi nookata. Oi nokoi repa patita sogimo qooro qaata, oonihe qesamane nohoi noke susu kamo minata sengibeteqi qupibake repa heeta dzoobiremi ttokata qurate biranate atti tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tuumaqi Sauroi Dzerusaremu nagapata biranateqi Dzesuho Qaru abi nokohota ipibidzare eeteta. Oonihe noi ao Dzesuho khata naateta oke nokoi nookami teqahama naatemi atti eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Oonihe Banabei noke dzaira eete Qaru abi nokoho toro dzeima tuumaqi Dzesui teteta Sauro saridzetaho noo ma pobi hiireta. Ma noi Ttamasikota Dzesuho tete hiire paanaiteta oho pobi ma biidza noo nokoke pobi hiireta, oke Banabei gama nokoho pengata hiire paanaiteta. ");
INSERT INTO ghs_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Hiiremi Sauro (Pauro) noi nokoma Dzerusaremuta qaaqi Dzesuho sinabidza attiamake abi pobi hiire qaata. ");
INSERT INTO ghs_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ma Dzuta abi qesa Girisi noota hiire qaata noi nokoma noo hiire nookaqi noo buribaro eeteta. Oonita obera abi noke teetare hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Hiiremi dzairamane noho nokoi nookaqi noke Kaisarea nagapata dzeima tuuma dzoobiremi tuuma qaaramuti Tarasu nagapa khooba nometa biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Qate sobasoba abi ma paimane Dzuta ma Garirea ma Samaria habana qaata nokohota hasu ma keba biranateta. Hasu ma kebata isakiqata qaaqi nokoi Ohongaho pengata subateqi qesa qahiqahi eete qaata. Oonihe Qaheuba Sumasai husi ma pai nokoho naatemi sinabidza haba gegebetemi tupu nokohoi mina naateta. ");
INSERT INTO ghs_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","33","Qate Peetoroi teteta tuuma qaaramuti Ohongaho oko ma boto Ritta nagapata qaata nokoho toro biranateta. Oonihe noi ota abi teke moota, dzapa noho Airea. Noi oko ma boto atimanoma naate tii eith-ho isakita meera keke eete qaata. ");
INSERT INTO ghs_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ma Peetoro noke pobi hiireta, Airea, Dzesu Kiristu niike qidzaihibita qori qepe niime qoomare. Hiiremi hairiamake qoridzeta. ");
INSERT INTO ghs_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Oke eetemi Ritta ma Saromi nagapanai oke mooqi qupa burisi eeteqi Ohongaho oko ma boto tupu naateta. ");
INSERT INTO ghs_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Qate paha Dzoopa nagapata atapa eehaha teei qaata dzapa noho Tabitta (Qate girisi noota oke hee Subaroho isaki ooniqi hiire qaata) noi abi samaneke kokora qidzanipamuke abiho tteki aima qaata. ");
INSERT INTO ghs_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Oonita Peetoro Dzoopata qaata bodzata Tabitta heme minake eeteqi baatare eeteta. Aoke baatemi qesai keba nohoke akobeteqi naga teeho nakuta ai pei mootota. ");
INSERT INTO ghs_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Oonihe Ritta nagapa oi Dzoopa nagapaho samaqata qaata. Oho qubake sobasoba abi tupu nokoi Peetoroho pobi nookaqi abi eserike dzoobiremi tuuma noke dzeima ao baabare hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Hiiremi Peetoroi nookaqi adzanoke noko tuumata. Tuuma biranate moomi kebai meeqota. Ota dzeima peiteta, peite moomi paimane ttarumi keke keba nakunaite tti ma ttaka eete Tabittai eehaha qaaqi nokoho quba sasa hiboto qaata oke peetoroke banaiteta. ");
INSERT INTO ghs_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Banaitemi Peetoroi noko tepatetemi biranahimi noi pomai kotoroqi pupu hiireta. Pupu hiire qaasuqi keba dzaga bobotoqi eraiqi hiireta, Tabitta nii qoridzare. Hiiremi noi nese parara eeteqi Peetoro mooqi qori habeseta. ");
INSERT INTO ghs_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Habesemi noho botota aimami qori qoorota. Qoohimi sobasoba abi ma ttarumi paimane nokoi peiteqi moomi Tabitta qaraqaranoma naatemi qupa qidzanipamu naateta. ");
INSERT INTO ghs_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Obetemi oho pobi Dzoopa nagapata gegebetemi tupu minanipamui noko Soopara nooka hiisi eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ma Peetoroi Dzoopata qaatahe abi teeho dzapa Simona sihu korakora abi noi noho nagata bodza samane noma nopo ttaike qaata. ");
INSERT INTO ghs_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Qate Kaisarea nagapata abi teei qaata, dzapa noho Konerio, noi raaba abi Itaria habaho qaa abi tupu nokoho soopara naate qaata. ");
INSERT INTO ghs_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Oonita noi oko ma boto nomema noko Ohonga qupadzoma qaata. Noi Dzuta abi samaneke kokora bageke eete qaata, paha Ohongaho toro saninoqake pupu hiire qaata. ");
INSERT INTO ghs_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Oonita Konerio noi oke eete qaami ete teeho surenake Ohongaho angero teei noho toro biranateqi noho kira hiireqi hiireta, Konerio. ");
INSERT INTO ghs_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Oonita kira oke hiiremi noi nese qooroqi moo sahateteqi hiireta, Soopara name, quba apeni? Hiiremi noi hiireta, Pupu ma kokora niihoho pobi Ohongaho tomata taatemi noi nookami bagenoma. ");
INSERT INTO ghs_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Oho qubake nii qaru dzoobiremi tuuma Dzoopa nagapata abi teeho dzapa Siimo, dzapa usaqe noho Peetoro noke dzeima baabare. ");
INSERT INTO ghs_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Noi Simona ma nopo oorai. Simona noi sihu korakora abi noma nopo oora ma qaara eetorai. Naga nohoi besa patisigiqata oorai. ");
INSERT INTO ghs_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","8","Oonita angero noo oke hiire tuusumi Konerio noi qaa abi Ohonga ai tataumanoma teeke uhutoqi kokora abi eseri noho baura eete qaata nopo oho qesa uhuto nokoke noo ma pobi hiire soubiremi Dzoopa nagapata tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Qate iihai mootomi abi noko tuumaqi teteta meeta. Meeqomi iihai mootomi tuusumi ete bisa naatemi noko nagapa dzamoitemi Peetoro naga suruho heena pupu hiibare peiteta. ");
INSERT INTO ghs_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Oonihe noi patta quba ttidza saa eetemi qesai noho quba patta khautomi noi bakuho isaki geemata. ");
INSERT INTO ghs_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Geema moohimi qusu papatemi boto qesai ttoba khabanoma nakunomaho isaki oke pobi ma mage, tume ma dzaga aimaqi oke dzoobiremi ttokata gaibata. ");
INSERT INTO ghs_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Oonihe oho nakuta kabira maina paina, dzotata ma siriquba ma qusuho nee maina paina ota oota. ");
INSERT INTO ghs_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Oomi totoho teei biranateqi hiireta, Peetoro, nii qori kabira oke teete dzuubete muunare. ");
INSERT INTO ghs_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Oonihe Peetoroi bai hiireta, Ohonga name, oio Baamu. Quba qataqatani mae quba sepesape oke ana muunaamanipamu. ");
INSERT INTO ghs_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","16","Oke hiiremi totoho oi paha hee, Ohongai ao sasari eetorai oke nii eto baaba eetaino oiqi hiiretanihe quba biranateta oi qupi tapari naatemi ao hairiamake dzeimami qusuta peiteta. ");
INSERT INTO ghs_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Oonita Peetoroi quba nese agiagi oke moo nookaqi qupa muunaqi hee, oi quba ikanomani? Oiqi hiireta. Hiimi Konerioi abi dzoobire baata nokoi nagapa biranateqi Simonaho naga qasa hiire tuuma qaaramuti naga pouta qoorota. ");
INSERT INTO ghs_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Qooroqi qasa hiireta, Siimo dzapa usaqe noho Peetoro noi naga erata meeqorai mae? ");
INSERT INTO ghs_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Oke hiimi Peetoroi quba nese agiagi mootaho quba iiha ma dzoobidza eesumi Sumasai noke pobi hiireta, Moorare, abi tapari naga erata biranate niiho qasa hiibi. ");
INSERT INTO ghs_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Oonita nii gaibaqa nokoma nike tuumare, oonihe nii eto oho qupa ororo eetaino. Oi anai noko gainene eetemi baabe. ");
INSERT INTO ghs_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Hiiremi Peetoro qurate noko pobi hiireta, Anaho qirike eetorai qate anai eranita naane quba baaorai? ");
INSERT INTO ghs_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Hiiremi abi nokoi hiireta, Qaa abi soopara nanaho Konerio noke Ohongai moomi qidza ma pobipobi, noke Dzuta abi nookami qidza naatorai. Oonihe qaheuba angero teei baaqi noke hee, Nii tuuma Peetoroho quba hiiremi baaqake noi too nomema noo hiibare. Oke hiiremi nanai baabe. ");
INSERT INTO ghs_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Hiiremi Peetoro nokoho quba qepe ma haba eetemi noko meeta. Qate iihai mootomi Peetoroi Dzoopa abi qesama noko gama Kaisarea abike gainene eete tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Tuumomi iihai mootomi Peetoro ma nokoi Kaisarea nagapata biranateta. Qate Konerio noi oko ma boto ma dzairamane nome gama ttuttuite beebe eetomi noko biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Biranateqi Peetoro nagata peitemi Konerioi noho dzagata pomai kotoro hasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Oonihe Peetoroi noke ai qusubaiteqi hiireta, Anai paha abi, niiho qesanita nii qoridzare. ");
INSERT INTO ghs_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Hiireqi nopo qesa noo ma too eeteqi nagata peitemi abi tupu minanipamui oomi moota. ");
INSERT INTO ghs_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Mooqi Peetoroi noko gama pobi hiireta, Nikei Dzuta abi nanaho khoobake nikemae gesinani. Nanai abi agiagi nikema ipibidza ma hongasidza eetaquho qagai oorai. Oonihe Ohongai oho kuku ma khooba anake banaitemi anai bamu isanate abi teeke paha hee ngiiginomaniqi hiibaqu, baamu. ");
INSERT INTO ghs_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Oonita nikei anaho quba hiiremi ana te qupa minake muunaranihe baaqi oho hasa hiibita naane qubake nike naho quba hiirorai? ");
INSERT INTO ghs_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","31","Oiqi hiiremi Konerio erake no pobi hiireta, Maqa, anai quba nese agiagi moo baa qaimi ete bodza eserisa eseri naate. Oho noo nii pobi hiire nii nookare. Ana naga nameta surenake pupu hiiromi abi tee, sasa noho khabanomanipamu noi naho toro biranateqi ana pobi hiireta, Konerio, Ohongai niiho pupu nookami niiho kokora oi qidzani. ");
INSERT INTO ghs_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Oho quba nii abi dzoobiremi Dzoopa nagapata tuuma Simona, dzapa temu noho Peetoro noke dzeimami niiho toro baabare. Abi noi Simona siihu korakoraho naga besa pouta oorai. ");
INSERT INTO ghs_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Oonita Peetoro erata baaqa noo qesa hiiremi nii nookakoi. Oke angeroi hiiremi anai abi dzoobiremi niiho quba qeemami nii baabe. Qate nii naho noo nookaqi baami anaho ttidza qidzanate. Ohongai noo nii pobi hiireta oke nii nana pobi hiiremi nana oke nookareiqi ttutturatorai. Oiqi Konerio hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Oke Konerio hiiremi Peetoroi hee, Meeke ana qupadzomami Ohongai abi napahoke te nookami teqaha teei teemuke riite ooraidzara. ");
INSERT INTO ghs_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Oonita abi noo ma sama maina paina nokoho neta qesai Ohongaho atti ququimaqi baura qidza eete qaaraquko nokohoke Ohonga nookami qidza naatakoi. ");
INSERT INTO ghs_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Qate Ohongai Isirae abi nanaho quba noo meenomake dzoobiremi saridzeta oho pobike nike nookorai. Noo oio Dzesu Kiristu noi abi minara napaho Soopara oioni, noke dzoobiremi noi hasu ma ponaho tete biraitemi oho isere qidza pobi hiire soubirorai. ");
INSERT INTO ghs_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Oonita noo Dzutea habata igabire oorai oi erani. Bosata, Dzohane noi sobasobaho baura eete qaata oho ipita Nadzarete nagapa nena Dzesu noi Garirea habata qori qooro tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","39","Qate Dzesu noke Ohongai Qaheuba Sumasama beedzaenomaitemi noi tuumaqi kokora baura qidza eetemi Iibadzai abi sesero eete qaata nokoke qidzaite qaata. Oi Ohongai noke gainene eetemi noi baura oke eete qaata. Eete qaami Dzutea haba ma Dzerusaremu nagapana hiireta ma eeteta oke qesa ma nanai gama moo nooka soubire oho mee hibahiba naate oorai. Oonihe abi nokoi Dzesuke hapahapata teetemi baateta. ");
INSERT INTO ghs_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Baatemi ete tapari naatemi Ohongai noke baata neta tukutota. Tukutoqi hiiremi noi qesahota biranatemi moo nookata. ");
INSERT INTO ghs_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Oonihe abi sepehota bahe, Ohongai qesa ma nanake asatemi oomi Dzesu baata neta qoridzemi nana nese nanameme noke mooqota ma noma nanai ttaike oba ma patta muunata oioni. ");
INSERT INTO ghs_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","43","Qate noi baata neta qoridze nanake noo tatanga moitemi nanai abi minarake noho pobi hiirorai. Kiristuho nooke Ohongaho too abi gama hiireqi agobake noho qaamodzamodza hiire qaata. Oonita Ohongai Dzesu Kiristuke upubiremi noi abi eehaha ma baateta gamaqa batabidzakoi. Oonihe poiqa apenei noho dzapa nookaqi hiisi eetaqu kahosa nokohoke Ohongai ao dzamutakoi. Noo oke nanai pobi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","46","Qate noo oke Peetoroi hiimi abi oona noo nookata nokoke Qaheuba Sumasai ao raraku biiremi nokoi nagapa noo maina painaho totohota Ohonga hasa hiirota. Hasa hiiromi Dzuta abi qesa sobasoba tupuna ooqi Peetoro gainene eete baata nokoi moohimi Ohongai oonomake raaba abike Sumasama irangi eetemi pairuru eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Hiiremi Peetoroi erake hiireta. Qateqa, nanahota Sumasa qurateta oho qesa abinaga erahota quratemi ikaqi nokoke sobasobaho oba qaanatemi isanataqu? Baamu. ");
INSERT INTO ghs_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Oiqi hiireqi noi noko qupanomaitemi nokoi abi nokoke Dzesuho dzapata ipibireqi obama soorota. Sooromi nokoi Peetoro qaanatemi ete bodza qesata nokoma qaata. ");
INSERT INTO ghs_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Oonihe Qaru abi qesa ma sinabidza abi Dzuta habana qaata nokoi raaba abi sinabidzake nookaqi Ohongama ipibiretaho pobi dzadzangike nookata. ");
INSERT INTO ghs_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Oonita Peetoro Dzerusaremuta peitemi sama geebanomaho dzaodzaonoma nokoi raaba abiho nookami hou peunoma naateta. ");
INSERT INTO ghs_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Nokoi Peetoroke hee, Nii naane quba raaba abiho botota patta aimaqi nokoma nike ttaike muuna ma aima eetemi nana nookorai. ");
INSERT INTO ghs_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","5","Hiiremi quba Kaisareata biranateta oke Peetoroi toqoma teeteqi noko pobi hiireta, Oore, Anai Dzoopa nagapata pupu hiire oomi Ohongai naho qupata erake paanaitemi ana moota. ");
INSERT INTO ghs_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ota ana nese qooroqi moomi qusuta boto qesai ttoba khabanomaho isaki oke mage ma pobi, tume ma dzagata aima ttokata quratomi oho nakuta quba sepesepe kabira oko ma botonoma ma oko ma botoama qesai qaanoma ma qusuho nee gotta oi paha oota. ");
INSERT INTO ghs_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ma noo totoho teei naho tomata dzubata oi hee, Peetoro nii moori oke teete khauto muunare. ");
INSERT INTO ghs_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Hiiremi ana hiireta, Eo, Ohonga name, quba muunaama, quba sepesape oonoma oke ana te muunoraidzarani. ");
INSERT INTO ghs_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Oke hiimi qusu neta noo totoho oi beedzae eeteqi hiireta, Ohongai quba hiire sasari eesubi oke nii etoqa ooho ngingi eetaino. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Quba biranateta oi qupi tapari naho dzagata biranatemi botoi oke paha dzeimami qusuta peiteta. ");
INSERT INTO ghs_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Oonita quba oi bamu naasuhimi aoke Kaisarea nagapa nena, abi tapari naho qaru qeemaqi nanai ootata biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Biranahimi anai nokoma tuumareiqi Sumasai hiireta. Oonihe noi hee, Eetoqa qupa bitobitoma tuumainoiqi hiireta. Oke hiiremi dzairamane napaho 6 noko anama baata nanai tuumaqi qaaho bosa qobaqobaho nagata peiteta. ");
INSERT INTO ghs_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Peitemi abi oi noo ma pobi nanake hiireta. Hee, Naho nagata angero teei baaqi ana pobi hiireta, Nii Dzopa nagapata qaru dzoobire tuumaqi Siimo Peetoro dzeima niiho toro baabare. ");
INSERT INTO ghs_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Noi baa noo hiiremake abi niiho nagana oorai ma nike gamaqa qidzanatakoi. ");
INSERT INTO ghs_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Oke qaa pobipoib noi hiiremi ana sinabidza noko pobi hiimi agoba napahota Sumasa qurateta oho qesa nokohota gaibata. ");
INSERT INTO ghs_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Eetemi ana Sooparaho noo erake qupadzomata: Dzohanei abi obama soorota oonihe nikeke Sumasama soobakoi. ");
INSERT INTO ghs_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Oke Dzesu Kiristui agobake hiiremi napa Soopara napame nooka hiisi eetemi Ohonga napake Sumasa moitetai teena oke raaba abiho quba irangi eetemi ana ikaqi Ohongake bai hiibarota? Baamu, ooiqi Peetoro hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Noi oho ipi hiiremi noko nooka nipanatemi qupa nokohoi kebaratemi nokoi gama Ohongaho hasahasa hiireqi hiireta, Oboboo, Ohongai raaba abi nokoho qupa ai burisi eetemi qaraqara mai eetareiqi hiibi. Dzoobe mina! Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Qate bosata Setepanoke teetemi uuba ma sakaba mina biranateta bodzata abi apenei Poenikia haba ma Kiporo sunga ma Attiokhia nagapata atti tuumata nokoi Dzuta abiqake sinabidza pobi hiire qaata. ");
INSERT INTO ghs_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Oonihe nokoho neta qesa Kipuro kusu ma Kirene haba nena nokoi Attiokhia nagapata tuumaqi Dzuta abiqake keke bahe paha Giriki abike Soopara Kiristuho sinabidza pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Obetemi Soopara noko beedzae moitemi oho isakita nokoi abi tupu minake pobi hiiremi qupa nokoho burisi eetemi noko Ohongaho pobi naateta. ");
INSERT INTO ghs_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ma oho pobi Dzerusaremuta baami Dzesuho oko ma boto tupu nookaqi Banabe dzoobiremi tuumaqi Attiokhia nagapata biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Biranateqi noi Ohongaho qupa kokora oke moomi noho qupa qidzanateta. Oonita noi nokoke qogo ma saga hiireqi hee, Nike qupa teenaiteqa Ohonga Sooparaho torota atimaqi battigara naate qaarareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Oi Banabei abi bagenoma oho quba nohota Qaheuba Sumasai heuheu eete qaami ai tatauma noho meupunoma naate qaata. Oho qubake nagapa oho abi adzapei adzahaha naateqi Ohongaho pobi naateta. ");
INSERT INTO ghs_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Oonihe Banabe noi Ttarasu nagapata tuumaqi Pauroho qiri eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Qiri eete saridzeqi noke dzeima Attiokhia nagapata nopo baata. Baaqi nopo abi samaneke sinabidza pobi hiire banaite qaami tii teena bamu naateta. Oonita Attiokhia nagapata Dzesuho oke ma botoi dzaodzaonoma naate qaami abi siginai sohoroqi nokoke Kiristuke suimorai abiniqi hiire qaata. ");
INSERT INTO ghs_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Qate bodza ota too abi Dzerusaremuho nenai Attiokhia nagapa tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ma nokohota tee, dzapa noho Agobo, noke Sumasai qupanomaitemi haba samaneta seebe mina biranatarota oho hore noo hiireta. (Oonihe seebe oi Karauttio Gaminiho abi mina noi qaata bodzata meenoma naateta.) ");
INSERT INTO ghs_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Oonita abi Attiokhiana qaata nokoi seebe biranatarotaho pobi nookaqi oma nokohoi ootaho isaki ttuttuiteqi Dzutea habata qesamane nokoho qaataho torota dzoobidzare hiire tatangaiteta. ");
INSERT INTO ghs_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Oma oke ttuttuiteqi Banabe ma Pauro moitemi aima tuuma Dzerusaremuho sinabidza abi mimi noke moitemi seebe oho paramu naateta. ");
INSERT INTO ghs_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Qate bodza oho robeta Kana habaho kiape mina abi qiba Herote, noi sobasoba abi qesa teete kootoroqi sutasuta nagata mooto qaata. ");
INSERT INTO ghs_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Noi hiiremi Dzohaneho nane Dzakopo noho paruke noko geemami baateta. ");
INSERT INTO ghs_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Oke eetemi Dzuta abi basesanoma nokoi oke moo hasa hiiremi Herote ohongahonga naate hiiremi oho qesa Peetoroke Ingona dzumaho bodza ooqata suutota. ");
INSERT INTO ghs_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Oi noi hee, Ingona dzuma baamu naatemi Dzuta abike banaiteqa teetare qupadzomaqi hiiremi sutasuta nagata mootomi qaa abi 16 nokoi soopara eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Oonihe oko my boto tupu nokoi Ohongaho toro pekhure teeteqi noho quba pupu hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Noko pupu hiiromi Herote noi hee, Iihai mootomi anai noke Dzuta abi banaitakoiqi hiireta. Oonihe qupi ota qaa abi eseri nopoi Peetoro ngibira eserima bisa nopometa suutomi noi meeta. Meeqomi qaa abi qesai tete sirasirata soopara qooro oota. ");
INSERT INTO ghs_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Oonihe naga suruho nakuta Ohongaho angero teei biranatemi naga gama saa eeteta. Eesumi angeroi Peetoroke qebata tuputupu teeteqi hiireta. Ae, nii hairiamake qoori. Oke hiiremi Peetoroho botona ngibira suuto oota oi saqobata. ");
INSERT INTO ghs_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ma angeroi hee, Oko sasa niime dzaabare. Hiiremi no dzaarota Dzaromi noi hee, Oionita sasa khara niime dzaaro baa anake iihare. ");
INSERT INTO ghs_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Hiiremi noi noho ipita biranateta. Oonihe angero noke quba pobi hiire banaiteta oke noi qupadzohimi bakuta mooraiho isaki naateta. ");
INSERT INTO ghs_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Obetemi nopoi teteta tuusuqi qaa abi qooro oota teeke riiteqi oho qesa paha teeke riite tete sirasira tatanga qainiho oke moomi noomae kuraubami nopoi biranateta. Biranate qaaramuti, teteta tuusuqi tete teeke riiteqi angero noke gaubire papateta. ");
INSERT INTO ghs_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Oonihe, Peetoroho qupa ota rikeqomami noi erake qupadzomata. Ohonga noi ao angero nome dzoobiremi Heroteho angi neta ma Dzuta abi nokoho dzauba neta ana saqohibi. ");
INSERT INTO ghs_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Noi oke qupadzoma rikeqomaqi tuuma Dzohane Marekoho pai, dzapa Maria, noho nagata biranateta. Oonihe abi adzapei ttutturateqi ota Peetoroho quba pupu hiirota. ");
INSERT INTO ghs_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Hiiromi Peetoro baaqi nagapa qaahota tuputupu teetemi kokora atapa tee dzapa noho Rootte noi hee, Apei pou tupu teete hiireqi qurateta. ");
INSERT INTO ghs_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Qurateqi noo totoho nookami Peetoroho. Oonihe te tete geemaranihe qaki eeteqi naga nakuta peiteqi hee, Peetoroi baaqi qoo paata qooro oorai. ");
INSERT INTO ghs_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Hiiremi nokoi noke hee, niiho qupa ruume naatemi nii hiire. Oonihe noi qiba baqebeteqi hiireta, Baamu! Peetoronipamui qooro oorai. Hiimi nokoi hee, Idze! Oi poi gisi noho ooniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Oonihe Peetoroi paha tonabetemi nokoi tete geemaqi Peetoro mooqi ubaqomata. ");
INSERT INTO ghs_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ubaqomami nokoi noo nipanatareiqi nokoke boto qamuni eeteqi Ohongai sutasuta naga neta noke saqoromi tta eete baata oho pobike noko hiire soubireta. Ma noi hee, Nike noo ma pobi erake Dzakopo ma dzairamane qesamaneke pobi hiibare. Noi oke noko pobi hiireqi nebe teeta qaheuba tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Oonita iihai mootomi qaa abi nokoi Peetoro qiri minake eeteqi ikanomake eete bamu naateta oke hiireqi ruume naateta. ");
INSERT INTO ghs_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Obetemi Herotei hee, Nike ao saridzeqake aimare. Hiiremi noko qiri eeteqi bittanipamu eetemi qaa abi sutasuta nagata Peetoro soopara eeteta nokoho khoobaho qirike eete saridzaama naate Herotei hee, nokoi ao baatareiqi hiireta. Hiireqi noi Dzutea haba qaateqi Kaisarea nagapata qura ota qaata. ");
INSERT INTO ghs_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Qate Herote noi bodza ota Ttiro ma Sittona nagapa nena nokoke ibo eeteta. Oi nokoi bosata Herotema muuna ma aima ttaiqake eete qaata oi ota ipi uhubata. Oonihe nagapa oho maikhametoi teena naate biranateqi Herotema paha qesa dzaira eetareiqi abi ohongaho abi mina tee dzapa noho Barasto noke noko hiire kebaitemi noi abi qiba Heroteke noo oke pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Oonihe Herotei oho noo ipi hiibarotaho bodza baami noi abi qibaho nee ma bau nome eeteqi poro qereta qooromi abi samane ttutturate oomi Herotei sama qaupu noo nomeke noko pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Hiiromi abi gama susupu noke qoqopa eeteqi qarutoqi hiireta, Ububuu noorai abiho baamuhe Ohongahoni. ");
INSERT INTO ghs_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Oke nokoi hiire qaami noi oke qamuni hiibaama naatemi Sooparaho angero teei ao noke heme mina moitemi dzoodzo minanipamui noho ttidza geemami baateta. ");
INSERT INTO ghs_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Qate Ohongaho noo oi haba gegebeteta. ");
INSERT INTO ghs_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Haba gegebetemi Banabe ma Pauro Dzerusaremuta baura eetare hiireta oke eete soubireqi burisi eete Attiokhia nagapata tuumare eesuqi Dzohane Mareko noke nopoi dzeima noko gama tuumaqi Attiokhia aimata. ");
INSERT INTO ghs_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Attiokhia nagapata sobasobaho tuputa too abi qesa ma paha banaita qesai qaata. Nokohota Banabe ma Simeo (dzapa totaqi noho Nigere) ma Rukio Kirene nena ma Manae, noi abi qiba Herote noho sinasina tupuho abi teei ooni, qate musaqi baataio Pauro. ");
INSERT INTO ghs_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Oonita qupi teeta nokoi pattaho hutingi naate naa ma pupu eetomi Sumasai paanaiteqi hiireta, Anai Banabe ma Sauro baura pobi hiiremi ooraita oho quba roibetare. ");
INSERT INTO ghs_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Hiiremi nokoi hutingi naate qaaqi boto nokome qiba nopohota mooto agoago eeteqi sinabidza baurata dzoobireta. ");
INSERT INTO ghs_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","Qate abi khata tee, oi Dzohane Mareko, noi mai Banabe ma Pauro nopoke baurata tuuhobare hiiremi nopohota isanatemi Qaheuba Sumasai nokoke dzeimami tuumaqi Serukia nagapata biranateta. Ota biraneteqi nokoi sisima aimaqi Kiporo kusuta tuumata. Tuumaqi kusu oho hagapa qiba Sarami ota biranateqi Dzuta abi nokoho sinabidza guhuta peiteqi nokoke Ohongaho noo hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","8","Ota noo hiire qaaramuti kusu oke dzongobete soubireqi nokoi Paapo nagapata biranateta. Biranate nokoi ota kiape teke saridzeta dzapa nohoi Seregio (dzapa temu noho paha Pauro). Oonita kiape Seregio noi abi nokanokanomai Ohongaho noo nookareiqi Banabe ma Pauroho qaru hiireta. Hiiremi nopoi baatahe ota moomi kiapeho sinasina abi teei oota. Noi Dzuta abi tee, dzapa noho Dzesukhata (ma dzapa temu noho Girisi noona hiirorai oi Erima. Oho khooba hee, Baabe ma Basarani). Noi too abi oberaoberanita baabe ma basara nometa qaata. Oonita Banabe ma Pauroi kiape Seregioho torota sinabidza hiibare boohimi Dzesukhatai kiapeke sinabidza oke qaanateqi Banabe ma Pauroke basesa eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Basesa eetemi Pauro (dzapa bosabosa noho Sauro) Sumasai qupa nohoke adzahahaitemi noi abi oke hee, Nii Dzesukhata bahe Iibadzakhata! Oi nii qidza ma pobipobiho ibo tatangani! Qupa niihota ikoiko ma baabe oberaoberaho nooi heenipamu eete ooraiho qubake Sooparaho tete rasiki eetorai oke qidzoke qaataqu. ");
INSERT INTO ghs_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Oho qubake Ohongaho beedzae khooba moorare. Nii ao ibau khabau eeteqa bodza qesata dzadzaho ruumeke qaarare. Oke Pauroi hiiremi ota nese noho qupi sooromi houpeu eeteqi basabasa eete abi boto nohota aimareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Oonita quba agiagi oonomai biranatemi kiape mooqi sinabidzahoke nookami attinoma nasuhiimi Ohongahota atimata. ");
INSERT INTO ghs_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nokoi Ohongata atimami Pauro ma Banabe ma Mareko nokoi Paapo nagapa oke qaateqi sisimata peite Papiria habata Peraga nagapata biranateta. Oonihe ota Dzohane Mareko noi ikanomake eete nokoke qaateqi burisi eete Dzerusaremuta tuumata? ");
INSERT INTO ghs_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Qate Pauro ma Banabe nopoi Peregia nagapa mina Attiokhia ota biranateqi Dzuta abiho sinabidza guhuta gama pei habeseta. ");
INSERT INTO ghs_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Habese oomi soopara nokoi hu noo ma too abi nokoho qetaqeta qesa oke gama isaite soubireqi eraiqi hiireta. Dzairamane, nike sinabidza teeke hiiroraiqake hiire nana nookare. ");
INSERT INTO ghs_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Oonita Pauroi qoridzeqi boto qusubaite botoma nokoke qamuni hiireqi hiireta, Isirae abi ma abi qesa nikema gama Ohongake ququimorai nike nookare. ");
INSERT INTO ghs_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Isirae abi napaho Ohongai uimane napahoke asatemi Agitta habata qaami Ohonga hiiremi nokoho dzare huba haba biireta. ");
INSERT INTO ghs_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Qate kebanoke noi beedzae ma tatanga nometa noko dzeimami baata. Baaqi haba habanata birante barubaru hiire qaami Ohongai pokeba sama kebata nokoke dzeima qaami tii 40 baamu naateta. ");
INSERT INTO ghs_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Paha ipita noi Kana habata abi tupu sebeni nokoke rubengaiteqi hiiremi neimane napahoi ttoka ma haba oke karabeteta. Oke eete ota qaami tii 450 baamu naateta. ");
INSERT INTO ghs_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ma oho tongo neta nokoi Kana habata qaami noi nokoho quba batabidza abi uhutomi nokoi abi minarake soopara eete qaami bodza ota too abi Samue biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Too abi Samuei biranate qaami noko abi qiba quba hiiremi Ohongai Bedzamiho eemane tupu nokoho neta Kiisiho khata Sauroke uhutomi noi tii 40-ho nakuta noko dzeima qaata. ");
INSERT INTO ghs_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Qaami Ohongai noke qasuhiqi Dzeseho khata Tabitike abi qiba nokoho upubireta. Oi teeho bahe Ohongai hee, Ana Dzeseho khateke saridzemi noio anaho too qusubaite soubidzakoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Qate Tabitiho ttarita Isirae abi napaho Ingona mai teei ao biranateqi Ohongaho naru noo agobake hiireta oke meenomaiteta oi ape bahe Dzesu ooni. ");
INSERT INTO ghs_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Oonihe Dzesui paana naataamake oomi abiho bisata Dzohane sobasoba baaqi Isirae abi qupa burisi eeta qubake nokoke obama soorota. ");
INSERT INTO ghs_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Oonihe Dzohane noi hee, Anai ape oniqi hiirorai. Oi nike anake hee, Kiristui baabaqu abi oioniqi hiiroraihe baamunipamu. Abi noi Noomae ipita baabakoi oonihe noi abi mina, anai oko sasa nohoke eka suuta quba bamu isanataqu oke Dzohane hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Oonita dzairamane name, nike Abarahamuho eemane khameto ma qesamane nikeho bisata Ohongaho ququimorai ana nike noo ma pobi hiiremi nookare. ");
INSERT INTO ghs_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ohongai napake ingonaitarota naru noo oke too abi napaho quba qeetemi dzuma samaneke isaitorai oke Dzerusaremu abi mina ma adzai nookorai oonihe nokoi Dzesuke teesuqi naru noo oke meenomaiteta oke noko teqaha qupadzomara. ");
INSERT INTO ghs_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nokoi Dzesuho kahosa qirinipamu eeteqi quba bamenoma saridzaama naatetahe sepeke Piratoho torota qiba qeereqi Dzesuke teete baateta. ");
INSERT INTO ghs_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Obete sinabidzata hiiretaho isakita nokoi eete soubireqi hapahapata hiumaqi nesetuho oma nagata mootota. ");
INSERT INTO ghs_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Oonihe Ohongai Dzesuke tukutomi qoridzeta. ");
INSERT INTO ghs_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Qoridzeqi noma Garirea haba nena Dzerusaremu nagapata gama peiteta noi nokoho torota ete bodza samaneta biranateta. Biranatemi moota abi nokoi pobi hibahiba noho naate oorai. ");
INSERT INTO ghs_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Oi Ohongai uimane napahoke naru hiiretaho mee oho isere qidzake nakai era hiibi oi Ohongai Dzesu tukutomi eemane khameto napahota meenoma naate oorai. ");
INSERT INTO ghs_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Oho quba nike ttidza qidzaqidza eetare. Oi Samu Hu tuta Ohonga abi qibai noo erake hiiremi qeeteta, Khata name poiqake ana niike (baata neta) dzoohibita nii naho poro qereta peiteqa ota qooro qaarare, oke qeetemi oorai. ");
INSERT INTO ghs_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Oi Ohongai Dzesu baata neta tukutomi ooraita noi bamu paha ipita baatata biranataqu. Oho quba Ohongai noke erake hiireta, Anai Tabitiho pobi hiireta oho mee qaheuba qaraqara tatanga oke ana ao Khata niike moite qaate. ");
INSERT INTO ghs_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Oiqi hiireta paha Samu teeta no erake qeetemi oorai, Qaheuba abi niihoi eto baate aritete gnausa natainoho isakita Ohonga nii qidzoke noke qaataqu. ");
INSERT INTO ghs_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Oke Tabitti qeetetahe oi te noomaeho noonidzara. Napa nookami Tabiti noi Ohonga baura hiireta oke abi nomeho torota eete soubireqi noomae baateta. Baatemi uimane neimane nokoho tuputa mootomi keba nohoi arinate ngausa naateta. ");
INSERT INTO ghs_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Oonihe Ohongai Dzesuke tukutomi abi oi teqaha arinate baamu naatara. ");
INSERT INTO ghs_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Quni ma mani name hiire nookare. Napaho kahosa dzumudzamuke abi oi ooqata saridzemi nikeho naatemi ana nikeke qupanomaisubi. ");
INSERT INTO ghs_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Moseho hu nooi nikeho kahosa biisi naatareiqi bitta eeteta. Oonihe Dzesuhota soomami nikeho kahosa qagaubakoi. ");
INSERT INTO ghs_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nookare, too abi nokoi basesaho nooke qeeteta oi hee, ");
INSERT INTO ghs_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Nike qaaraquta ana baura bamenoma teeke eetemi baura oho pobi hiiremi nikeho tomata taatemi qidzoke nike nookaqu. Oho quba puutta abike nike tomama nooka roqobetakoihe ao rubenga naatakoi. Oiqi qeeteta. Oonita noo oi eto nikeho naataino hiireqi naka qogo noo hiire. ");
INSERT INTO ghs_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Oke hiireqi Pauro ma Banabe nopoi sinabidza guhuta biranahiimi abi noko dzuma temuta paha noo teena oke hiibareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Oonita garuba nokohota Dzuta abi samane ma Dzuta abiho qahiqahi qesa (oi raaba abi) nokoi gama Pauro ma Banabeta atimami nopoi hee, Dzoobe, Ohongaho kokorata subate qaarareiqi qogo ma saga hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","45","Qateqa dzuma temu nokohoi dzamonahimi nagapa oho abi Onongaho noo nookare samanei biranateta. Biranahimi Dzuta abi qesa nokoi moo nookahimi qanga naatemi Pauroho noo baaba eeteqi noke ai qurateta. ");
INSERT INTO ghs_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Oke eetemi Pauro ma Banabe nopoi nokoke qanganipamuta moo hiireta, Dzuta abi nikeke Ohonga noo bosata hiibareiqi baaorai. Oonihe nikemae goottae eeteqi qaraqara tatangaho pobi naatare bai hiirenita nakai nikeke qaateqa raabe abi nokohota tuumakoi. ");
INSERT INTO ghs_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Oi teeho bahe Ohonga erake hiireta, Anai nii raaba abiho dzongi ma eepa moototata korakora nokoho naate tuuma qaaqa habaho moirata soubidzare oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Oke Pauro hiiremi raaba abi nokoi qupa qidzanateqi noko Ohongaho noo nookaquho hasa minake hiireta. Qaraqara tatangaho pobi naatarota nokoi gamaqa sinabidza nooka hiisi eeteta. Eetemi Ohongaho noo haba ota gegebeteta. ");
INSERT INTO ghs_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","50","Oonihe nagapa oho abi mimi ma paha paimane qesaqesa apene Dzuta abiho sinabidzata qahiqahi eeteta nokoke Dzuta abi kosikosi eete suu ma pai mootomi nagapa ma haba qaa aimaqi Pauro ma Banabe nopoke teete iihaqi haba ota hotou biireta. ");
INSERT INTO ghs_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Hotou biiremi nokoke qomaqoma hiireqi nopoi oko nopomeho kaususu tepateteqi Ikonio nagapata tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Tuusumi Qaheuba Sumasai nopota meupunoma naatemi qakiqaki eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Oonita Pauro ma Banabei Ikonio nagapata biranateqi oho qesa Dzuta abiho sinabidza guhuta dzuubaqi sinabidza hiiremi meenoma naateta. Obetemi Dzuta ma Girisi abi samanei Dzesuho oko ma boto tupu naateta. ");
INSERT INTO ghs_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Qate Dzuta abi qesaio sinabidza oho gottae eeteqi nagapa oho abi ttidza kootoromi Kiristuho abi nokoho dzauba eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Oonihe nopoi beedzae eete dzasidza ma bodza qesa nagapa ota qaaqi Ohongaho neta soomaqi attiamake sinabidza hiire qaata. Oke eesuhimi Ohongaio ingona noo nomeho khooba paanaiteqi nopoho husi ma pai naatemi obaoba bamenoma maina paina ota eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Eetemi nagapa oho abi batabireqi qesai Dzuta abihota soomata ma qesai qaru abi nopohota soomata. ");
INSERT INTO ghs_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Oho ipita raaba abi ma Dzuta abi qesai qaru abi nopoke omama teetare guunu dzoomata. ");
INSERT INTO ghs_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Guunu Dzoomami nopoi nookaqi atti Rikaonia habata tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Paha Ristera ma Dzerebe ma nagapa qesata nopoi tuumaqi ota sinabidza hiire qaata. ");
INSERT INTO ghs_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Qate Ristera nagapata abi teei qaata noi oko atimanoma paiho ttidza qausuta oonomake eete biranateqi tuuma ma baabaamake qaata. ");
INSERT INTO ghs_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pauro sinabidza hiiromi abi noi nookami Pauro moohimi abi oho ai tatauma isanatemi noi qidzanataquho isaki naateta. ");
INSERT INTO ghs_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Oho qubake Pauro dzaubama sokateqi hiireta, Nii oko niimema qori qoobare. Hiiremi abi oi tukuba qoridze qooro tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Qooro tuumami Pauroi quba eeteta oke abi tupu mina nokoi mooqi too ttutturateqi Rikaonia noo nokometa hiireta, Ohonga qesaqesai ao abi sama eeteqi abi napaho bisata biranatareqi oorai. ");
INSERT INTO ghs_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Hiireqi noko Banabeke hee, Dzeusi mai ooniqi hiireta. Qate Pauroi noo hibahibata adzahaha naatemi nokoi noke hee, Heremesiniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Oonita Dzeusiho kiridza abi hiiremi burimakau ma sihidzake khakhaumaqi nokoi nagapa oho kosoramuta Dzeusiho naga qaatata tuuma mootota. Ota nokoi Pauro ma Banabeho kiridza qeebare ttutturateta. ");
INSERT INTO ghs_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Oonihe Pauro ma Banabe nookaqi sama ma sasa nopome utotoqi ao hairiamake abiho bisata tuumaqi Girisi noota sokate hiireta, ");
INSERT INTO ghs_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Idze abinaga, naane qubake nike qubarake eetorai? Nakai napa gama abi sama teena, nikeho qesanihe noo qidzake aima baa hiirorai. Oi teeho bahe Ononga qaraqaranomai qusu ma ttoka ma besa ma quba minara mootota nohoke nookaqa baura meeama eranomake nike tume biireqa Ohongaho pobi naatareiqi naka baaorai. ");
INSERT INTO ghs_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Oi agoba baaorai raaba abi qesama nikei tete maina paina nikeme saridze qaata. ");
INSERT INTO ghs_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Oonihe Ohonga mee noi te nike ma nokoho seeno naatara, nike noho khooba gesina naatareiqi hiiremi quu ma ete iso keke biranatemi meupunoma naatemi ttidza qidzanate qaabi. ");
INSERT INTO ghs_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Qate qaru abi nopoi tototo hiire kebaite qaami qaami nokoi kiridza qebaqeba oke qaateta. ");
INSERT INTO ghs_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Oonihe Attiokia ma Ikonio nagapaho Dzuta abi nokoi biranateqi Pauro omama teetareiqi nokoke hoobire kosikosi eete teetemi baateta. Oonihe nokoi hee, Bamu eehaha naataquiqi hiireqi kebake nagapa tumeta dzeimaqi tapata biidzarota. ");
INSERT INTO ghs_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Oonihe tumakhametoi biranateqi Pauro nakunaite herohero eesuhimi noi paha eehaha naateqi nagapa peiteta. ");
INSERT INTO ghs_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Peitemi iihai mootomi Banabe ma nopoi Ristera nagapa qaateqi Terebe nagapata tuumata. Ma nopoi nagapa ota sinabidza baura eete qaami tumakhameto samanenipamu naatemi nopoi burisi eete Ristera ma Ikonio ma Attiokhiata paha biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Oi nopo nagapa samaneta biranateqi Dzesuho oko ma boto tupu nokoke ai tataumata hoobire noko Sooparama qaarareiqi hiire tatangaiteqi erake hiireta, Napa ima ma bagoho neta qaaqa Ohongaho pobita dzuubaridzoniqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Hiireqi nopo nagapaho isaki soopara nokoho upubireqi hutingi naate qaaqa pupu ma agoago eeteqi nooka hiisi etaeta nokohoho isakita Ohongama ipibidzare hiireqi nokoke qaateta. ");
INSERT INTO ghs_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Qaateqi Pauro ma Banabe nopoi Pisitia haba dzongobeteqi Papiria habata biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Oonita nopoi Perega nagapata sinabidza hiiroramuti Attaria nagapa qurateta. ");
INSERT INTO ghs_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Qurateqi nopo ota sisimata tuuma qaramuti paha Siria habaho Attiokhia nagapa ota biranateta. Oi sinabidza abi tupu nokoi Ohongaho kokora quba mootoqi baura nopo pobi hiiremi bosaho eeteta nopoi paha ota biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nopoi ota biranateqi oko ma boto tupu ttuttuiteqi hee, Ohongai nakaho husi ma pai naatemi raaba abihota baura eetemi nokoi sinabidzata dzuubata, dzoobe! Oke eete isere hiire soubireta. ");
INSERT INTO ghs_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ma nopoi bodza kharabariqa ota Dzesuho oko ma boto tupu nokoho bisata qaata. ");
INSERT INTO ghs_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pauro ma Banabei Attiokhiata qaami Dzutea habaho sobasobaho tuputa abi qesai Attiokhia nagapata tuumaqi sinabidza abi erake hiireta, Nike Moseho noo qusubaite sama nikeme geeba mootaama naataquko baamuqa Ohongaho pobi naataqu. ");
INSERT INTO ghs_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Oke hiiremi Pauro ma Banabei nokoma kurebeta minake eete qaaramuti erake hiire suutota. Pauro ma Banabe ma sobasoba abi oi Ttitto ma qesa nokoho neta noo oke Qaru abi mimi ma sinabidza bosa qobaqoba Dzerusaremu nagapana oorai nokoho toro aima tuumare. ");
INSERT INTO ghs_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Oiqi hiireqi tete nokohoke biiraite tuumaqi Poenikia ma Samariaho sinabidza oko ma boto samaneke eraiqi hiireta. Hee, Paha raaba abi samane sinabidza nookorai. Oho pobi hiiremi nookami nokota ttidza qidza minanipamu biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Qate nokoi Dzerusaremuta baaqi sinabidza abi mimi ma quru abi mimi ma noko garuba eeteqi Ohongai Pauro ma Banabe nopo hoobiremi sinabidza baura eetemi meenoma naateta oho noo ma pobike nokoke hiire paanaiteta. ");
INSERT INTO ghs_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Noo ma pobi oke hiiremi Pariseo qesa Kiristuho sinabidza ai tataumanoma nokoi eraiqi hiireta, Raaba abi nokoho torota sinabidza hiireqa nokoke sama koko geebanomaiteqa hiiremi noko Moseho hu noo qusubaite soubiremi isanatakoi oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Oho quba Qaru abi mimi ma sinabidzaho bosa qobaqoba noo oke nokoqeke hiire ttutturateqi noo hiire buribaro eeteqi Peetoroi qoridze erake hiireta, ");
INSERT INTO ghs_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Dzairamane name raaba abi noko bosata teeho toota sinabidza nookaridzoniqi hiireqi Ohongai napahota ape bahe anake asatemi oho too naatemi nokoi nooka tani naateta. ");
INSERT INTO ghs_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Obetemi Ohongai qupa mohimohi oonita Dzuta abi napake Qaheuba Sumasa moiteta oho qesa raaba abi qaupuiteqi moiteta. ");
INSERT INTO ghs_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Napai noke nooka hiisi eetemi qupa napahoi sasari naateta oho qesa nokoi nooka hiisi eetemi qupa sasari naatetaho isakita Ohongai te hiimotara. ");
INSERT INTO ghs_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Oi erake eete oorai. Hu noo ma apo oi Dzuta abiho uimane neimane ma napaho moirata gama pereborai. Oonita nike ikaqi hiireqi Ohongake toronaiteqi oke paha raaba abiho qereta goosobaqu? ");
INSERT INTO ghs_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Oe, oi baamu isanataqu. Napa erake nookorai: abi qidzanate pobirataqu oi Dzuta abi ma raaba abi gama susupu Soopara Dzesuho baruna heenata keke pobirate qidza naatorai. ");
INSERT INTO ghs_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Peetoroi noo oonomake hiiremi sinabidzaho abi mimi nokoi nipanate oomi Pauro ma Banabei raaba abiho bisata Ohongai kinisa nokoho botona mootota oho pobike noko korabete pobi hiiremi nooka pobiteta. ");
INSERT INTO ghs_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nopo hiire soubiremi Dzakopo oho ipi erake hiireta, Dzairamane, toma tiite nookare. ");
INSERT INTO ghs_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ohongai raaba abi nokohota abi aimami noho pobi naatare tete saridzeta. Oho noo ma pobike Siimo Peetoroi ao hiiremi napa nooke. ");
INSERT INTO ghs_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Obetemi noho nooi too abihoma iso keke naatorai. ");
INSERT INTO ghs_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Nokoi erake hiireqi qeeteta, Ohonga anai paha qurateqa Tabitiho naga arinateta oke paha usari eeteqi upubiremi bagenoma naatakoi. ");
INSERT INTO ghs_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Oonihe raaba abi qeba nena ma tume nena nokoi Ohongaho qiri eete saridzakoi oi raaba abi nokoi naho pobi naatemi naho dzapai nokoho irita biranatakoi. ");
INSERT INTO ghs_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ana nikeho Onongai noo oke hiire baa qaatai hiibi oi oni. ");
INSERT INTO ghs_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Dzakopoi hee, Oiqi Amosi ma Dzeremia ma Dzesea nokoi qeeteta, oonita Raaba abi ango Ohongahota qeemami eto napai nokoho irita hu nooho bameke mootaino, naho noo oi oni. ");
INSERT INTO ghs_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Oonihe, raaba abi ai tataumorai nokoi eto Ohongaho habara quba qesaqesa upubidzaino, mae apuata eetaino mae kabira dzaganoma muunaino eo keba ooraike muunaino oho isakita napa noo hiire geeta qeete tatangaiteqa pepa oke Pauro ma Banabeho botota mootare. ");
INSERT INTO ghs_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Oi teeho bahe Moseho noo agobake ehahaiteqi sohoroqi nagapaho isakita isaite baa qaabi ma bodza erata sinabidza nagaho isakita isaite nookorai. Oho qubake oi dzaetainoho isaki oioni. Oiqi Dzakopo hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Oke Dzakopoi hiiremi qaru abi ma bosa qobaqoba nokoi sobasoba tupu pobi hiiremi isanatemi abi eserike uhutota. Dzapa nopoho Dzuta, oi Sabaho khata, ma Siira nopo dzaira pepa oke aima tuumareiqi sinabidzaho bosa qobaqoba nopoke uhutoqi Pauro ma Banabe nokoke Attiokhia nagapata dzoobireta. ");
INSERT INTO ghs_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ma Nokoho quba pepa dzoobireta, Oi hee, Raaba abiho bisata Attiokhia nagapa ma Siria ma Kirikia ma haba qesata oorai qaru abi ma bosa qobaqoba nanai dzairamane naname nikeho qaki naateqi pepa erake nikeho quba dzoobire. ");
INSERT INTO ghs_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Oi nanai moo nookaama naasuhimi abi qesa nanaho neta qeemaqi qupa nikehoke rasakitemi nikehota kurekure biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Oho quba nana oke nooka ttutturateqi abi eserike dzoobiremi Pauro ma Banabe ma noko nikeho toro qeemorai. ");
INSERT INTO ghs_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Abi naga oi Soopara Dzesu Kiristuho dzapa quba sama nopome bagara biirorai. ");
INSERT INTO ghs_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Obete abi eseri uhutota Dzuta ma Siira nopoi qeemami noo oke nookare. ");
INSERT INTO ghs_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Oi Sumasa ma nanai qupa teenaiteqi eraqake keke hiire. ");
INSERT INTO ghs_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nike eto Ohongaho habara quba qesaqesa upubidzaino ma kabira dzuuma ooraike muunaino, ma dzaganomake muunaino, paha etoqa pasena eetaino. Nike nooraqake qusubaitemi bagenoma naatakoi. Dzoobe, aipo! ");
INSERT INTO ghs_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Noo oke qeeteqi nokoho botota mooto dzoobireqi aipo biiremi tuumata. Tuumaqi Attiokhia nagapata biranate oko ma boto tupu ttuttuite pepa moiteta. ");
INSERT INTO ghs_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Moitemi isaiteqi dzaira noo qeeteta oke mooqi oho ttidza qidzaqidza eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Oonita Dzuta ma Siira nopoi sinabidza abi oonita qesamane sinabidzaho noo samane pobi hiire tatangaiteqi too teeteta. ");
INSERT INTO ghs_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Qate nopoi nokoma oora ma qaara eetarotaho bodza baamu naasuhimi nokoi oho ttidza qidza eeteqi nopoke paha dzoobiremi Dzerusaremuho qesamane nopomeho toro tuumarota. ");
INSERT INTO ghs_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Oonihe Siirai nokoma oorareiqi hiiremi Dzutai keke tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Qate Pauro ma Banabe Attiokhia nagapata ooqi sinabidza abi qesama nokoi hobihobi eeteqi sinabidza hiireqi Ohongaho nooke bodza minaminaho isakita abi ma khata pobi hiire qaata. ");
INSERT INTO ghs_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ohongaho noo Attiokhia abike banaite qaaqi Pauroi Banabeke eraiqi hiireta, Baa naka burisi eete paha nagapa samanena raaba abi sinabidza pobi hiiremi nooka qaata oke tuuma karabidzare, nokoi ikanomake eetorai? ");
INSERT INTO ghs_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Oho qubake hiiremi Banabe noi paha Dzohane Marekoma nokoi gama tuumareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Oonihe Mareko noi bosata nopoma Papiria habata baura agiagita biranateqi nopoke qaateqi burisi eeteta oho qubake Pauro abi onomake qupadzomami teqaha nohota isanatara. ");
INSERT INTO ghs_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Oho qubake Pauro ma Banabe kure ma taara minake eeteqi batabireta. Batabireqi Banabe noi Dzohane Mareko dzeimaqi nopo sisima pei Kipuro sungata tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","41","Qate Pauroi hobihobi nome Siira aimami nopoke sobasoba tupu agoago eeteqi dzoobireqi hee, Ohongaho kokorata tuumareiqi aipo biiremi tuumata. Tuuma Siria ma Kirikia haba dzongobeteqi Dzesuho oko ma boto tupu qesaqesa saridze tatangaiteta. ");
INSERT INTO ghs_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pauro ma Siira nopoi tuuma qaaramuti Tterebe ma Ristera nagapata biranateta. Obetemi Ristera nagapa ota Dzesuho tumakhata teei qaata dzapa noho Timotteo noho pai Dzuta atapa ai tataumanoma, ma mai nohoi Giriki abi ooni. ");
INSERT INTO ghs_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Oonihe Ristera ma Ikonio nagapa nena sinabidza nokanoka nokoi Timotteo khooba qidza hiire paanaiteqi Pauro pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pobi hiiremi Pauro noma nokomae tuume baabe eetareiqi hiireta. Oonihe ttoka ota Dzuta abi qaata nokoi khatake hee, mai nohoi Giriki abi oniqi qupadzoma soubireta. Oonita oho noo kebaitareiqi Pauroi Timotteo aima sama geebanomaiteta. ");
INSERT INTO ghs_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Sama geebanomaiteqi noko tapari nagapa samaneta tuumaqi qaru abi ma bosa qobaqoba Dzerusaremu nagapata noo tatanga hiire pepata qeetetake nokoho quba rerengi eete soubireta. ");
INSERT INTO ghs_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Baura oke noko eete qaami Dzesuho oko ma boto tupu noko ai tataumaqi kata gaamata ma ete samane raaba abi nokoho torota biiresore eete qaaqi nokanoka abi tupui samane naateta. ");
INSERT INTO ghs_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Oonita Pauro ma Siira ma Timotteo nokoi Asia gattiagaho habata sinabidza hiibarotahe Qaheuba Sumasai oho bodzata qamuni hiiremi nokoi Perigia ma Garattia haba dzongobete tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Tuumaqi Misia haba kokota biranateqi totaqike paketomaqi Bittinia habata tuumare hiiremi Dzesuho Sumasai paha nokoho bai hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Oho quba nokoi Misia haba paketoma tuuma qaaramuti besa pakita Ttoroa nagapata biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ota biranateqi qupibake Pauro noi bakuta moohimi Maketonia abi teei noho toro biranate tti ma sori hiireqi erake hiireta. Nii Maketonia habata qeemaqi nanake hoobidzare. ");
INSERT INTO ghs_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Oonita Pauro noi quba oke bakuta mooqi eraiqi hiireta, Maketonia habata tuuma pobi qidza hiibareiqi Ohongai hiibi oi oni. Oke hiiremi Ruka anai nokoho gainene naatareiqi nokoma tuumare roibeteta (oi anai ttotta ooqi nokoke kokora eetarota). ");
INSERT INTO ghs_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Roibeteqi Pauro ma Siira ma Timotteo ma Ruka nanai gama sisimata peiteqi Ttoroa nagapa qaateqi tete paake tuuma qaaramuti Samottara kusuta biranateta. Iihai mootomi tuuma qaarumuti Neapori nagapata unateta. ");
INSERT INTO ghs_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ota sisimata tta eeteqi tuuma qaaramuti Maketonia habaho nagapa qiba Piripi ota biranateta. Oonihe Roma abi nokoio oho maikhametoi qaata. ");
INSERT INTO ghs_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nagapa ota bodza qesata nanai qaami dzuma dzamo naatemi nagapa kokota oba teei qaata ota erake hiireqi qurateta. Dzuta abi pupu hiirorai oho qopa oioni oba tee ooraita napa qura moorare. Oke hiireqi qurahimi paimane ttutturate oomi saridzeqi ota habeseqi sinabidza pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Hiiremi nokoho tuputa atapa teei Ohongake ququima qaata, dzapa noho Riitia, noi ttoba ma sasaho pai, Ttiattira nagapa nena. Oonita Sooparai hiiremi atapa oho qupa uhubami Pauroho noo toma qepe tiiteqi nookata. ");
INSERT INTO ghs_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nookaqi Riitia noomae oko ma boto nomema noko sinabidzaho sobasoba quba hiiremi soorota. Sooromi noi hee, Nike ana moomi Sooparaho pobi naahibiqako naho nagata peitemi ana nike kokora eetakoiqi hiiremi nana peiteta. ");
INSERT INTO ghs_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Qate bodza teeta pupuho sobadzata qurahiimi sutasuta atapa teei nanake saridzeta. Atapa noi songenanomai qaaqi khooba ma bangaro paana eete qaami maikhameto noho sinasina nohoho quba abiho torota ttuma aima qaata. ");
INSERT INTO ghs_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Noi Pauro ma nanake saridzeqi sokateqi hiireta, Abi nagarai Ohonga Minaho qaru eeteqi tete nohoke hiire paanaitorai. Oonihe noi onomake eete kira ma husu bodza samaneke hiirota. ");
INSERT INTO ghs_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Hiiromi Pauroi oho gottae eeteqi burisi eete songena erake pobi hiireta, Ana Dzesu Kiristuho quba eeteqi nii pobi hiirenita atapa oke nii ao qaate papatare. Oke hiiremi songenai ao biranate tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","20","Pauroi songenake iihami tuumami atapa khata oho maikhametoi moohimi ttumaho isaki nokoho oi ao bamu naatemi nokoi Pauro ma Siira aimaqi nagapa bisata kiapeho toro dzeima tuumaqi nopoho qomaqoma hiireqi eraiqi hiireta. Nopoi Dzuta abi nagapa nanahota baaqi qupa rasaki eetoraidzo. ");
INSERT INTO ghs_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Oke eesuqi poma agiagi samane Roma abi eetaamata eetoraidzo. ");
INSERT INTO ghs_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Oke hiiremi abi tupu minai qooro oota nokoi dzauba minake eeteqi nopoke tetatetake teesuhimi kiapei sasa nopohoke ao kuima teetare hiiremi gouma teeteta. ");
INSERT INTO ghs_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Gouma buribaroke teeteqi sutasuta nagata biireqi sooparai tete siiremi tatanga naatemi hee, Bageqake eete soopara eetareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Oonomake hiiremi sutasutaho sooparai naga naku bisa qaputa mootoqi oko nopohoke puuta tooma suutota. ");
INSERT INTO ghs_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Suutomi Pauro ma Siirai naa ma pupu hiiromi sutasuta abi qesai oke toma tiite nookota. ");
INSERT INTO ghs_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nookomi saubapo dzeubami Idze! tumu mina rubabetemi sutasuta nagaho hahari poupa eetemi tete sirasira hiuba soubireta ma abi gama puuta too hiuba soubiireta. ");
INSERT INTO ghs_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Eetemi sutasuta soopara noi meera neta nookaqi qoridze moomi tete sirasira paatinoke oomi noi hee, Idze! sutasuta abi nokoi ao atti tuumeiqi hiireqi qaa dzube quhisata dzeima sama nome ao kootobare eeteta, ");
INSERT INTO ghs_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Oke eetare eesumi Pauroi sookateqi hiireta, Eo, sama niime eto sesero eetaino, nanai gama susupu ooraidzo! ");
INSERT INTO ghs_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Hiiremi qaa sooparai dzongi quba hiimi oko ma boto nohoi moitemi bukhittidzake naga dzuubami suu gaa eetemi noi tititima qeemaqi Pauro ma Siira nopoho dzagata taateta. ");
INSERT INTO ghs_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Taatemi Pauro hiiremi noi qori naga neta nopoke dzeima biranate qasa hiireta, Abi ohonga name, ana dzaetare eeteqi kebai ooraita ikanomake eeteqi qidzanataqu? ");
INSERT INTO ghs_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Hiiremi nopoi erake hiireta, Nookao Soopara Dzesu Kiristuke ai tataumaqake qidzanatakoi. Oonihe nii quni ma mani niimema gama qidza naatakoi. ");
INSERT INTO ghs_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Oke hiireqi nopoi oko ma boto nohoma nokoke Dzesu Sooparaho noo hiire paanaiteta. ");
INSERT INTO ghs_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Hiire paanaitemi nookaqi noi ao nopoke dzeimaqi gou qetta nopohoke akotete suutota. Suutoqi hiiremi nopoi quni ma mani nohama nokoke sinabidzaho obama soorota. ");
INSERT INTO ghs_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Sooromi noomaeho nagata mootoqi hiiremi patta khauto urai eetemi muunata. Oonihe qaa abi oi quni ma mani nomema nokoi Ohongaho pobi naatetaho quba ttidza qidzaqidza minanipamuke eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Iihai mootomi kiape noko pirittani seike erake hiire dzoobireta, Abi eseri nopoke dzaheqake soqobare. ");
INSERT INTO ghs_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Oke hiiremi sutasuta sooparai nookaqi Pauro erake pobi hiireta, Ana nipe saqoromi tuumareiqi kiape noko noo dzoobiremi baabe, oho quba nipe biranate tuuma keba ma dzapata qaarare. ");
INSERT INTO ghs_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Hiiremi eehe, Pauroi bai hiireta. Hee, Baamu, nokoi Roma abi nakake noota mootaamake ao abiho soobadzata nakake gabeho biireqi sutasuta nagata biireta. Biireqi paha eranomake eete tteike naka dzoobidzaqu? Oi baamu! Nokomae baaqa paata naka dzeimami nana isanate tuumakoi. ");
INSERT INTO ghs_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pauro noo oke hiiremi pirittani nokoi burisi eete tuumaqi kiape pobi hiiremi nopoi Roma abiho isaki ootaho pobi oke nookaqi roqobeteta. ");
INSERT INTO ghs_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Roqobeteqi qupa muunaqi nopoho toro baaqi ttapuiteqi sutasuta naga neta dzeima baaqi hee, Nike isanate nagapa nanahoke qaate tuumaqu mae? Oke hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Hiiremi nopo sutasuta nagata biranateqi Riitia noho nagata tuumaqi Dzesuho okoma boto tupuke qogo ma saaga hiireqi tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Oonita Pauro ma Siira nopoi Apiporo ma Aporonia nagapa eseri oke riite Ttesaronika nagapata biranate oota. Oi Dzuta abi nokoho sinabidza naga teei ota oota. ");
INSERT INTO ghs_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Oonita Pauro nome eete qaata oke eeteqi dzuma taparike nokoma sinabidza naga nokohota dzuubaqi sinabidza hiire nookata. Hiireqi sinabidza ma noo qesaho khooba hiire paanaiteqi erake hiireta, ");
INSERT INTO ghs_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kiristui baateqa qoridzarotaho teteke noi saridzaama naatapuko bamu isanatarota. Oke sinabidzata hiiremi ooraita Dzesuho dzapa pobi ana nike pobi hiirorai noio Ohongaho abi mina Kiristunipamu oni. ");
INSERT INTO ghs_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Hiiremi qesa nokoi noo oke nooka hiisi eeteqi Pauro ma Siirahota soomata. Eetemi Giriki abi Ohongaho ququima qaatai oho qesa nokoho neta ipibireta, ma paimane mimi samanei paha biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Eetemi abi samanei sinabidza nookami Dzuta abi noko nookami nokota qanga naatemi nokoi abi ngiingi nganginoma ma basesanoma ttutuiteqi sokasoka hiireqi Dzasoho nagata Pauro ma Siira ootata ttutturateta. Ttutturateqi nopoke aimaqi abiho tuputa mootareiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Hiiretahe nopoho qiri eeteqi saridzaama naate nokoi Dzaso ma sinabidza nokanoka qesa aimaqi nagapa soopara nokoho toro dzeima tuumata. Oonihe erake hiireqi sokasoka hiire tuumata, Haba samaneta qupa rasaki eetorai abi oio nanaho toro biranate. ");
INSERT INTO ghs_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Oonihe Dzasoi nokoke kokora eetorai ma nokoi Roma abi qiba Kaisaho noo riiteqi abi ohonga agiagi tee, dzapa noho Dzesu, noho pobi hiiremi haba gegebete. ");
INSERT INTO ghs_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Noo oke hiireqi nagapa abi ma soopara bitta ma kaka eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Eetemi nagapa soopara hiiremi Dzaso ma qesamane noho nokoi sama nokomeho ttuma naru hiire mootomi nagapa sooparai nokoke saqoromi tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ma sinabidza nokanoka nokoi Pauro ma Siira qupibake dzoobiremi Berea nagapata tuumata. Ota biranateqi nopoi Dzuta abiho sinabidza guhuta peiteqi sinabidza hiirepu. ");
INSERT INTO ghs_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Obetemi Berea nagapa ota Dzuta abi nokoi keba ma dzapaho pobi qate Ttesaronika nagapa nena nokoi abi naga bise baisanoma. Berea abi nokoi sinabidza nooka quba dza minake eeteta. Eeteqi noo nopohoke hee, meeni mae oberaniqi hiireqi qupi samane kuku ma khooba qiri eeteqi suuta dzuubaqi sinabidzaho gee isaite nooka qaata. ");
INSERT INTO ghs_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Oke eeteqi nokohota samanei Dzesuho oko ma boto naateta ma paha nokohota Giriki abi ma paimane mimi qesa samanei nokota ipibireta. ");
INSERT INTO ghs_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Oonihe Pauroi Ohongaho noo Berea nagapata hiire paanaitemi oho pobi Ttesaronike nagapata tuumami oho quba Dzuta abi nookaqi Berea nagapata baaqi nagapa maikhametoke bitta ma kaka eetemi qupa mutu ma biribiri eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Oke eetemi Siira ma Timotteo nopoi Berea ota keke qaata. ");
INSERT INTO ghs_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Oonihe sinabidza nokanoka nokoi Pauro pobi hiiremi noi nagapa oke qaate tuuma qaramuti besata biranateta. Oonita abi noko Pauro dzeima tuuma Atteni nagapata mootomi noi erake pobi hiireta, Nike burisi eete hiiremake Siira ma Timotteo nopoi adzanoke erata baabare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Oke hiiremi Berea abi nokoi burisi eeteta. Ma Pauro noi Atteni nagapata Siira ma Timotteo nopoho beebe ooqi neemi gisigisi samanei ota oomi mooqi qupa nohota eepa gaiteta. ");
INSERT INTO ghs_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Qaitemi noi Dzuta abi nokoho sinabidza guhuta dzuubaqi Dzuta abi (nokomae ma Giriki abi qesai Dzuta abihota atima qaata) nokohota gama sisinabidzaho noo hiiremi nookata. Ma noi paha qupi samane otoba patita abi saridze sinabidza pobi hiire hiireke tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Qate nagapa ota abi nokanoka minanoma samanei qaata, dzapa ttari nokohoi Epikure abi (nokoi quba samane etteimorai) ma Sittoike abi (huttinginoma). Oho neta abi nokoi Pauro saridzeqi qesai hee, Ae, ttetterapo ooraqi ikaitorai! Hiiremi qesai Pauroho erake hiireta, Bamu, noi ohonga dzapa samanehota agiagi teehoke hiirorai kaqani. Oke hiireta oi teeho bahe Pauro noi Dzesuho pobi hiireta ma noi baata nena qoridzetaho noo hiiremi nokoi totoho oonomata hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Oke hiireqi tora kokota uta apiapi naga minanipamu teeho dzapa Areopago ota dzeima peiteqi noke hee, Isanate nii noo agiagi hiibi, naane qubake hiibi? ");
INSERT INTO ghs_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Noo oi toma agiagi nanahoni, oho khoobama hiire nookare. ");
INSERT INTO ghs_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Oiqi hiireta oi Atteni nagapaho abi dzore ma nagapa maikhata nokoi noo ma pobi agiagi hiire nookoraqu ooqaho dzaodzaoke eete qaata. ");
INSERT INTO ghs_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Oionita Pauro noi Areopago noo sobadzata tuuma qooroqi abi erake pobi hiireta, Dzoobe Atteni nagapaho abi mimi. Ana khooba nikeho erake moorai. Nike sinabidza ma ohonga maina paina samaneho pomata atimorai. ");
INSERT INTO ghs_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ana nagapa nikehota tuuma ma baaba eesuqi neemi gisigisi nikeho moo qaaramuti aratta teeta qetaqeta teeke ana isaitemi hee, Erai Ohonga agiagi teeho tekaniqi hiirorai. Oonita nike ohonga agiagike ao qupadzomaqi noho kokora sohororai Ohonga teena oke ana nikeho quba rerengi eetake boobita nookare. ");
INSERT INTO ghs_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ohonga noqeke ttoka mootoqi oho heeta quba samane mooto soubireta noi ape bahe qusu ma ttokaho maikhatanipamu. ");
INSERT INTO ghs_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Abi guhuke botoma gootorai ota noi oora ma qaara te eetoraidzara. Ma noi quba teeho qiri eetemi abi baura eetemi biranatoraiho tete baamu. Oi noi keke abi napa qaraqara ma hee ma hoonomake saridzeta paha quba minara saridzorai. ");
INSERT INTO ghs_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Noi abi biidza teenaqake saridzeqi noho neta abi tupu samane huba haba biireqi noko ma napai tuuma qaararotaho bodza ma hu ma koridza noi keke hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Noi hee, Abiho qupa khatai qiri qee ma baa peite qaama abi noomae Ohongake saridzaqu mae, oiqi hiireqi Ohongai oke eeteta. Oi noi kharaqata bahe bisa napahota abi napake gama isanate oorai. ");
INSERT INTO ghs_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Oi paha naa sutasuta abi nikehota teei hee, Napai noho qaraqaraho nakuta ooraiqi quba minara eetorai oi teeho quba bahe napai Ohongaho biidza ma suunaniqi hiiremi naa oi oke hiirorai. ");
INSERT INTO ghs_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Oonita napai meeke noho biidza ma suuna ooraiqako ikaqi hiireqi abi napai boto napamema gori ma siriba ma omama gisigisi nee ma baunoma ohongaho qaseqase korabetorai? Oi Ohongai oho isaki ooniqi eetoqa napai qupadzomaino. ");
INSERT INTO ghs_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Oi abi ruumema baa qaata oke Ohonga moo te oho kahosa hairiamake eete qaarara oonihe oho bodza ao bamu naate. Poiqa ttoka abi gama susupu qupa burisi eetareiqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Noi bodza ao hiireqi, ota haba samane abi napaho khooba paanaitakoi, ipi ma ariho isaki moitakoi. Ma abi teei baura oke eetareiqi Ohongai noke upubireta. Oonita ttoka abi gama susupu abi oke nooka hiisi eetareiqi Ohongai noke baata neta tukutomi oorai. ");
INSERT INTO ghs_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Qate Pauro noi Dzesu Kiristu ao baata neta qoridzetaho noo hiiremi qesai ao gattagatta hiireqi noke ngiingi ma baaba eeteta. Qate qesai tete siireqi hee, Oionita noo oke bodza teeta paha hiire nana nookaqu kaqani. ");
INSERT INTO ghs_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Oke hiiremi Pauroi noko qaate tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Oonihe abi qesai Paurohota atimaqi Dzesuho pobi naateta. Nokohota sinasina abi mina Areopagona qaata dzapa Tionision, ma atapa tee dzapa noho Dzamari ma paha abi qesai nooka hiisi eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Oonita Pauroi Atteni nagapa qaateqi Koritti nagapata tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ota Dzuta abi teeke saridzeta dzapa noho Akuira (noi Potu habata biranateta) ma ata noho Pirisira. Oi noma nopoi Itaria habata oomi abi qiba Kaisa Karauttio noi Dzuta abike Roma qaanateqi iihata. Iihami nopo nagapa oke qaateqi burisi eeteqi Koritti nagapata biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Biranatemi Pauroi nopoho toro noo hiibareiqi peiteta. Peite moohimi parai korakora noomae gesina naate qaata baura teena oke Akuira noi ooqata eetota. Oho quba noi nopoma noko qesa baura nokome ipibireta. ");
INSERT INTO ghs_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ma Pauro noi dzuma samaneta Dzuta abiho sinabidza guhuta peiteqi Dzuta abi ma Giriki abi nokoho quba sinabidza dzuubeteqi adzahahaiteta. ");
INSERT INTO ghs_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Qata Siira ma Timotteo nopo Makettonia habata baaqi moomi Pauroi sinabidza baura mekeqoma eeteqi Dzesu noi Kiristunipamu oho khooba Dzuta abike hiire rerengi eete soubireta. ");
INSERT INTO ghs_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Oonihe hiire soubiremi nokoi noo nohoke basesa eeteqi ngiingi robe eetemi noi sasa nome baabaaba eetemi miriququ perebami erake noko pobi hiireta. Nikei baatareiqa baatare, oonihe kahosa nikehoi bamu naho naataqu. Oionita ana Dzuta abi nike qaateqa raaba abi nokohota keke baura eetorakoi oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Qate abi teeho dzapa Titio Dzusto noi Giriki abi oonihe noi paha Dzuta abiho sinabidza qahiqahi ooni. Oonita Pauroi noho nagata peiteqi ota sinabidza hiire qaata. Oi naga nohoi Dzuta abiho guhu saamaqata oota. ");
INSERT INTO ghs_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Oonihe Dzuta abiho guhu soopara, dzapa noho Kirispo, quni ma mani nohoma nokoi sinabidza nookaqi Dzesuho oko ma boto naateta. Eetemi Koritti abi nokoho neta samaneqai sinabidza nookata, nooka hiisi eetemi sinabidza obama soorota. ");
INSERT INTO ghs_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ma qupi teeta Sooparai bakuta Pauroho torota biranate erake hiireta, Nii eto atti ququimaqa sinabidza qaatainohe, oke hiire qaarare. ");
INSERT INTO ghs_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Oi ana niike hohoba eesuhima abi noko bamu quba teeke niike eetaqu. Oi nagapa erata naho abi tupu quba minai oorai. ");
INSERT INTO ghs_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Oke hiiremi Pauro noi sohoro sama nomeho hutingike naate nagapa oho abike Ohongaho noo hiire banaite qaami tii bodza teena ma qetta naateta. ");
INSERT INTO ghs_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Oonihe Gario noi Giriki haba Akhaiaho totaqita kiape mina naate qaata bodzata Dzuta abi nokoi qesa hongasireqi Pauro ibo eete kiapeho toro aima tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Nokoi noho qomaqoma hiireqi hee, abi erai quba nanai hu noo qusubaite eetorai oke riiteqi hiiremi abi qesa Ohonga agiagi teeke ao qusubaitareiqi eetorai. ");
INSERT INTO ghs_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Hiiremi Pauroi noo totaqi hiibare eesumi Gario qamuni hiireqi Dzuta abi pobi hiireta, Abi erai roota kahosa bamenoma teeke saridzapuko oi ana isanate nikeho noo nookarori, oonihe baamu. ");
INSERT INTO ghs_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nikei noo sepeho quba ma noo khooba nikemeho quba ma sinabidza nikemeho quba noke geema mootorai oonita nikemae noo oke hiire tatangaitare oi naho baura baamu. ");
INSERT INTO ghs_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","17","Hiireqi noi nokoke iihami biranateta. Biranate midza nokome quba eeteqi abi nokoi Dzuta abiho sinabidza guhu soopara dzapa noho Sostene noke kiapeho pengata buribaroke teete iihami kiape moo nomena naateta. ");
INSERT INTO ghs_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Oionita Pauroi Koritti nagapata paha isakiqata qaaqi burisi eetareiqi nokanoka tupuma nokoi qesa aipo biireqi Pirisira ma Akuira noma nokoi sisima peiteqi Siria habata qesa gainene eete tuumata. Oonihe Sekherea nagapa gattiqaho unaunate biranate Pauroi sama nomeho hutingi naatota oke qaateqi some nome topotota (oi teeho bahe noi moomi Ohongai noke Koritti ota herohero eetarota oi ao meenoma naateta). ");
INSERT INTO ghs_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ma ooneta paha tuuma qaaramuti nokoi Epeso nagapata biranateqi Pauroi dzairamane eseri nomeke sisimata qaateta. Qaateqi Pauroi Dzuta abiho sinabidza guhuta peiteqi nokoma sinabidza qesa pobipobi hiire nookata. ");
INSERT INTO ghs_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Noi isanate nokoma qaarareiqi Dzuta abi noko qaanatare hiiremi bai hiireqi erake hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Anai tuumake boohibita, ipita Ohongai nookami ana nikeho toro burisi eetakoi. Oiqi hiire aipo biireqi sisima peite Epeso nagapa qaateqi tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Tuuma Kaisarea nagapata biranateqi ota sisimata tta eeteqi Kiristuho oko ma botoke dzoobe hiireta. Hiireqi burisi eete girodzomaqi Attiokhia nagapata biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Biranateqi Pauroi Attiokhia nagapata gattiqa ooreqa boohiqi sinabidza qaru dzongobeteqi nagapa qesake karabidzare tuumata. Oi Garattia ma Pirigia habata Dzesuho sinabidza quni ma manike noo hiire tatangaiteta. ");
INSERT INTO ghs_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Qateqa Epeso nagapata Dzuta abi teei baata dzapa noho Aporo, Aresattaria, Apirikaho nena. Noi nooho kotanganipamu oomi noi sinabidza hiire qaami oi kinisaho isaki naate qaata. ");
INSERT INTO ghs_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Oonihe Ohongaho sinabidza qesa noke banaitemi ooqake keke gesina naate qaata. Noi Dzohane sobasoba maikhata noho pobike nookata Dzesuho sinabidzake paha heeqata abi banaite qaata. ");
INSERT INTO ghs_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Oonihe noi oho koko nookaamake qaaqi oke qaate qaata. Abi oi Dzuta abiho guhuta peiteqi attiamake sinabidza hiireqi suu ma heeta hiirota. ");
INSERT INTO ghs_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Hiiromi Akuira ma Pirisira nopoi nookami koko isanataama naatemi noke dzaira eeteqi Sumasaho sinabidza kokoke noke banaitemi pobirateta. Pobiratemi noi ao Girisi habaho totaqi Akhaidzata tuumare hiiremi sinabidza nokanoka abi nokoi qesamaneho quba dzaira pepa qeeteqi moitemi aima tuumata. Oonita Aporo tuuma qaaramuti Koritti nagapa biranateqi abi Ohongaho baruna heenata sinabidza nooka hiisi eeteta nokoke hobidza minake eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Oi noi sinabidza pepa bosabosa oho neta giimaqi Dzesu noi Kiristunipamuniqi hiire oho khoobake abiho pengata hiire paanaitemi Dzuta abi oona qaata nokoi bai hiibaquho isakiama naateta. ");
INSERT INTO ghs_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Oonita Aporoi Koritti nagapata oomi Pauroi tora ma haba dzongobeteqi tuuma qaaramuti Epeso nagapata biranateqi sinabidza nokanoka abi saridzeta. Oonihe nokoho sinabidza teqahama naatemi noi qasa hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Nike sinabidza nookaqi Sumasaho pobi naate oorai mae baamu? Hiiremi noko hee, Baamu, Qaheuba Sumasa ooraiho pobike te nookoraidzara. Oke hiiremi Pauroi hee, Oonita nike apeho teteke qupadzomaqi sinabidzaho sobasoba aimata? Hiiremi nokoi hee, ");
INSERT INTO ghs_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Nanai Dzohane sobasobaho sinabidza qupadzomaqi sobasoba saridzeta. ");
INSERT INTO ghs_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Hiiremi Pauro erake noko pobi hiireta, Maqa, Dzohanei abi qupa burisi eetareiqi nokoke obama sooroqi hee, Teei anaho tumena baaorai noke nooka hiise eetareiqi hiireta, Oi ape bahe Kiristuhoke hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pauro oke hiiremi abi nokoi noo oke nookaqi Soopara Dzesuho dzapa qupadzomami obama soorota. ");
INSERT INTO ghs_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","7","Sooroqi Pauroi qiba nokohota boto nome mootomi Qaheuba Sumasai nokoke raraku biiremi oionita nokoi ao Ohongaho too naate noo maina painata sinabidza hiireta. Oonihe abi oke eeteta oho dzare oi tuerebe oni. ");
INSERT INTO ghs_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Eetemi Pauro noi Dzuta abiho sinabidza guhuta beubeuamake peiteqi dzasidza tapariho isakita noo hiireqi Ohongaho pobi ma tete hiire hunateqi oho khoobake rerengi eete hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Oonihe abi qesai basesa eete noo nookaama naateqi garubaho pengata Kiristuho tete qanga hiiremi Pauroi nokoke qaateqi sinabidzaho dza eeteta nokeke ttuttuiteqi ete samaneke abi teeho dzapa Ttirano noho sukuru nagata sinabidza banaite qaata. ");
INSERT INTO ghs_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Oke eete qaami abi Asia gattiqa habana qaata nokoi gama susupu Dzuta ma Giriki abi sinabidza nooka qaami tii eseri baamu naateta. ");
INSERT INTO ghs_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Obete Ohongai Pauroho husi ma pai naatemi noi obaoba nese agiagi eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Eetemi abi nokoi Pauroi bauraho ttoba ma dzamudzamu ttoba aima qaata oke aimaqi khettedzanoma nokoho toro aima tuumami hesateqi qidzanaate qaata ma songena nokoho irina qaatai atti tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Oonihe Dzuta abi qesa kaabanoma nokoi oota oi Dzube abi teeho dzapa Sikeba noho khameto sebeni nokoi oota. Nokoi bodza teeta girodzomaqi hee, Napai qaseqase eeteqa Soopara Dzesuho dzapa hiireqa songena abiho irina ooraike iihareiqi hiireta. Nokoi hee, Napai Songena erake pobi hiibare, Dzesuho dzapa pobi (Pauroi hiirorai) nii noho too quba paapatare. Oke hiireqi nokoi qeemata. ");
INSERT INTO ghs_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Qeemaqi nokoi noo oke abi songenanoma pobi hiimi songenai noko noo ipi erake hiireta, Ae, Dzesuke ana qupadzomorai ma Pauroke oho qesa ana qupadzomorai. ");
INSERT INTO ghs_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Qate nikei ika nena? Oke hiire abi songenanomai qaa eeteqi sasa qaite khametoke teete sigubireqi sasa nokoho qohata teetemi habanake dzuu suura naate nagata tta eete sakaba tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","18","Ma quba oho pobi Epeso nagapata baami Dzuta abi ma Giriki abi nookaqi atti minake eeteta. Eeteqi nooka hiisi eeteqi biranateqi baabe ma basara nokome quba eete qaata oke ngiingi ma baaba eeteqi oonoma gama gaubireta. ");
INSERT INTO ghs_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Qate abi adzapei baru ttari eete qaata nokoi pepa nokome khakhauma biranateqi otoba patiho eepata qeereta. Oonihe gee oho ttumake noko ttuttuitapuko siriba gettara 50 ttauseni naatarotahe noko ooma Ohongaho kiridza qeereta. ");
INSERT INTO ghs_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Oi abi nokoi oonomake eetemi Ohongaho noo pobi qoridzeqi souba sakabata. ");
INSERT INTO ghs_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Oonita Pauroi baura oke eete qaaramuti soubireqi hee, Ana Maketonia ma Akhaidza abike tuuma karibireqa Dzerusaremuta tuumaqa oho tongo neta oho qesa ana Roma moorakoi. ");
INSERT INTO ghs_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Oiqi hiiretanihe hobihobi nome eseri Timotteo ma Erasto nopo bosa dzoobiremi Maketonia habata qooro tuumami noomae qaata ota paha gattiqa oota. ");
INSERT INTO ghs_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ma oho bodzata Epeso nagapata sinabidzaho taara minai biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Oi siribaho nee ma bau korakora abi tee qaata dzapa noho Temettero abi oi Attemi neemi oberaho guhu gisigisi gamittimittike siribama korabetemi abi noko ttuma eetemi noma baura oonoma eete qaata nokoho toro oma minai biranate qaata. ");
INSERT INTO ghs_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Obetemi Temettero noi baura abi qesa nome ttuttuite erake hiireta, Dzairamane napaho baura oi oma napaho saridzorai oke nike gesinani. ");
INSERT INTO ghs_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Oonita abi teei baaorai, Pauro oioni, nike noho khooba gesina. Noi Epeso nagapa napaho Asia Gattiqa haba nena abi adzepeke qupa rasaki eeteqi hee, Abi botoma neemi gisigisi korabetorai oi quba meeama. ");
INSERT INTO ghs_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Noi hee, Pauroi oke hiiremi baura napahoho dzapa pobiama naataqu oi keke bahe, neemi napaho Attemi noho guhu barari biidzakoi, ma Attemi nomaeho dzapake Asia Gattiqaho haba ma haba qesaho abi gama susupu ququimorai oonita dzapa pobi nohoi isanate napahota baamu naataqu mae? ");
INSERT INTO ghs_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Temettero noo oke noko pobi hiiremi nookami qupa nokoho dzauba eetemi sookateqi erake hiireta, Epeso nagapa neemi Attemi noi minanipamu. ");
INSERT INTO ghs_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Hiire qarutomi nagapa abiho qupa tukutomi oko tumutumu biireqi biranate ttutturatoramuti sobadza nokometa tuumata. Obetemi Maketoniaho abi eseri Pauroke hoobire oota, dzapa nopoho Gaio ma Arittako, nopoke noko karabete aima tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Tuumami Pauroi nookaqi abi oho garubata tuumare hiiremi qesamane noko qaanateta. ");
INSERT INTO ghs_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Qate haba oho abi mimi qesa Pauroho dzairamane qaata nokoi paha garubata tuumaino hiireqi noo dzoobiremi Pauro noo nookata. ");
INSERT INTO ghs_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Obetemi garuba nokometa noo nganganoma hiimi qesa mina oota nokoi hee, ikanomake hiire eetoraiqi hiireqi hou eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Abi nokoi oke eete oomi Dzuta abi nokoi gesina abi nokome dzapa noho Aresatte noke abiho bisata mootomi qooroqomi nokoi noke qiruqiru biiremi noi noo hibahiba qohareta peiteqi noo geemare boto qamuni eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Obetemi abi nokoi noke mooqi hee, Dzuta abi ooniqi hiireqi too samanei ttutturateqi hee, Ohonga bahe Epeso nagapaho neemi Attemi noqaho dzapa pobi minanipamu oni. ");
INSERT INTO ghs_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Oonoma hiire qaaramuti Epeso nagapaho gamani qetaqeta abi noi nokoke hasu hiire kebaiteqi erake hiireta, Epeso nagapa eraho abi nookare. Napai Attemi mina napameho guhu soopara eetorai ma qusu neta gisigisi nohoi qaratemi napahota oho soopara eetorai. ");
INSERT INTO ghs_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Oonita haba minarata apei oke ruume naataqu? Oonomai baamuhe, qupa nikeho kebaratemi quba eto sepesapeke eetaino. ");
INSERT INTO ghs_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Abiho obera hiibaino. Nokoi neemi guhu napahota teqaha quba teeke aima dzukubara ma neemi Attemi Ttianake te ngiingi eetara. ");
INSERT INTO ghs_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Mae Temettero ma abi noho nokoi abi teehoke nookami qanga naatoraiqako noo ma kahosa hiibaqu bodza dzamonatemi Kiape oorai nokoho torota hiibare. ");
INSERT INTO ghs_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mae nikemaeho noo teei ooraiqako bosa qobaqobaho garubata aima tuumare. ");
INSERT INTO ghs_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Oonihe nikei poike ikoiko eesuhimi sepeke qaa biranatare eete oho noo qubake abi qiba napaho qaru hiiremi napa tuumaqi tee ma teeke hiimi nookami baamu isanataqu. ");
INSERT INTO ghs_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Qateqa qetaqeta abi oke hiiremi garuba nookaqi sakabata. ");
INSERT INTO ghs_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Noo ma nooaga oi baamu naasumi Pauroi sobasoba tupuho quba hiiremi baami qogo ma saga hiireqi Maketonia habata tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Haba oke dzongobete tuusuqi sobasoba tupu qaata nokoke qogo hiire tatangaiteqi tuuma qaaramuti Girisi habata biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ota dzasidza taparike qaaramuti besata qura sisima aima Siria habata tuumare hiiremi Dzuta abi ota qaa mootomi tete mainake aimare hiireqi Maketonia habata tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Tuumami abi naga erai noke iiha Asia Gattiqata tuumata, oi Berea napaga nena Sopate noi Pirihuho khata ma Ttesaronia nagapa nena Aristako ma Sekutto ma Gaio ma Timotteo ma Asia Gattiqa habaho nena Ttikhiku ma Ttoropimo. ");
INSERT INTO ghs_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Abi oio bosa qooroqi Ttoroa nagapata Pauro ma nanaho beebe oota. ");
INSERT INTO ghs_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Qate nanai ingona dzuma baamu naatemi Piripi nagapata sisima peiteqi ete paiputa tuuma qaaramuti Ttoroa nagapata noko saridzeta. Saridzeqi ete bodza sebenike qaata. ");
INSERT INTO ghs_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Obete Sateta nanai qupi posa muunareiqi ttutturateta. Oonihe Pauroi hee, Iihai mootomi tuumare hiiqi sinabidza hiire qaami saubapo dzeubata. ");
INSERT INTO ghs_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Dzeubami naga naku nanai oota ota dzongi samanei dzadza eetota. ");
INSERT INTO ghs_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Oonihe Pauro sinabidza hiiremi bodza khara naatemi abi khata tee dzapa noho Euttiko noi haba moramorata habeseqi mee ruume naateta. Oonihe suruho nokoi oota oi heenata oomi noi taate suruho eserike riite ttokata taate baateta. ");
INSERT INTO ghs_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Baatemi Pauro ao hairiamake qura khata dzogebiire aimaqi erake pobi hiireta. Eo baamu, eto tti ma ttaka hiibaino, noho baruna eehahake oorai. ");
INSERT INTO ghs_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Oke hiireqi naga nakuta peiteqi qupi posa moiteqi qaate patta muunata. Muunaqi nokoma sinabidzaho noo hiiromi iihai mootota. ");
INSERT INTO ghs_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Iihai mootomi abi nokoi khatake ttidza qidzaqidzake eete naga nohota dzeima tuumata. Qate Pauro ma nanai qaate tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pauro hiiremi qesa nanai sisimata peiteqi Aso nagapata tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Qate noomae torata tete biireqi Aso nagapata nanake saridzeqi sisimata peite hee biireqi nanai gama tuumata. Tuuma qaaramuti Mittirene nagapa biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Oneta tuuma qaaramuti iihai mootomi Kio sungata biranate riiteqi Samo kusuta biranateta. Ma ooneta tuuma qaaramuti Mirette nagapata biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Oi Pauro noi Sumasaho dzumata Dzerusaremu biranatakoiqi hiireqi Epeso abima bodza minake oorainoho quba Epeso nagapa riiteqi pobi neta sisimata tta eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pauroi sisimata tta eeteqi qaru dzoobiremi Epeso nagapata tuumaqi sinabidzaho bosaqobaqoba dzeima unaunata baata. ");
INSERT INTO ghs_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Baami Pauroi noko erake pobi hiireta, Dzoobe, ana khoobanipamuta Asia Gattiqa nikeho habata biranateqi ao nikeho toro baura name bosana eete qaata oke nike nooka baaqoraidzo. ");
INSERT INTO ghs_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Anake abi ngingi ma baaba eete qaami ana tti ma ttidza heme ipima Sooparaho qaru eete qaata. Oi Dzuta abi noko sesero ma dzakidzaki eesubomi ana teeta ma taanga ipima qaata. ");
INSERT INTO ghs_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ma ana te noo nikeke qoredza eete qaarara. Nike qidzanata quba sinabidza noo samaneke naga ma paata nike pobi hiire qaata. ");
INSERT INTO ghs_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ma Dzuta abi ma Giriki abi Ohonga dzaga bobotoqi Soopara napame Dzesu Kiristu nooka hiisi eetareiqi qupa nikeho tukuto qaata. ");
INSERT INTO ghs_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Obete poiqa Sumasa naho qupa qooro teetemi Dzerusaremu nagapa tuusubi. Tuusuhimi quba ikanomai naho toro biranataqu? Oke ana ruume. ");
INSERT INTO ghs_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Teena anai nagapa samaneta biranate qaimi Qaheuba Sumasai ana erake pobi hiirorai, sutasuta ma heme ma bame qee ota niiho beebe eetorai oiqi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Oonihe anai qaraqara nameho nookami ttuma minanoma naasuidzara, tete naho quba roibeteta oke iiha qaarareiqi hiirorai ma Ohongai hasu ma keba nohoho pobi qidza hiire gegebetareiqi Soopara Dzesui ana pobi hiireta, baura oke eete qaaqa soubidzareiqi qupa nahoi hiirorai. ");
INSERT INTO ghs_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Paha teeke hiire nookare, ana qusuho noo pobi qidza hiireqi nikeho bisata oora ma qaara eetemi nike ana mooraihe paha ipita nese ma penga naho baamu mooraqu. ");
INSERT INTO ghs_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ohongai sinabidzaho noo naho irita suutomi oorai oke ana nike pobi hiire soubireta, ");
INSERT INTO ghs_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","teeqake te qaatemi ooraidzara, baamu. Oho quba poike toma agiagita hiire nookare, teeho kahosa oorareiqa oorakoihe oi baamu naho naataqu. ");
INSERT INTO ghs_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Oonita nike sama nikeme soopara eeteqa sinabidza tupu nikeme isanate soopara eetorare. Qaheuba Sumasai nike nokoho bosa qobaqoba hiiretaho quba nike Sooparaho oko ma boto noomaeho dzuui soorota nokoke sinabidzaho sogo moite qaama keba ma dzapata qaarare. ");
INSERT INTO ghs_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Oonihe ana qupadzomami haa idzahuba qaanoma nokoho toro biranateqi sipisipi baamu ingonaitaqu. ");
INSERT INTO ghs_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Paha nikemaeho bisata abi biranate sinabidza ngiingirobe eete ai tatauma abi nokoho angi naatemi ota dzuubakoi. ");
INSERT INTO ghs_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Oho quba nikemae bakena geema qaarare. Oi tii tapari qupi samane tti ma dzasa ma qogo ma saga, noo hibahiba oke te qaatemi perebara nike ooho qupadzomaqi qaarare. ");
INSERT INTO ghs_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","(bisa 32 oi qoorata oorai) ");
INSERT INTO ghs_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Anai te ttuma ma quruma quba tti ma sori hiibara. ");
INSERT INTO ghs_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ana abi naga namema nana ttuma gattiqa saridzeta oke boto eseri namema saridzemi nanaho quba biranatetake nike nookorai. ");
INSERT INTO ghs_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ana koo ma taanga nikeho quba irangi eetemi ooma nike ao baura beedzaema eeteqi pepeqa ma roroqa nokoke hoobire qaarare. Oho teteta qooroqi ana oke nike banaitemi oorai. Oonita nike ota qooroqa Soopara Dzesui noo erake hiireta oke qupadzomare. Hee, Isaki teeke biraitemi ooraike nike aimaqu tete nome ooraihe, nikemae abiho ttiihu biidzaqu tete oio dzapa pobinomanipamu, oiqi hiireta. Qate ana nike Ohongaho botota mootomi baruna heena nohoi nike bakena geemami Beedzaeho Maikhatai nike isakinomaite qaarare. Qaama nike noho qaheuba abi tupuma ttaiqa naate ipi ma ari saridze isanatakoi. ");
INSERT INTO ghs_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Oonita Pauro noi noo oke hiire soubireqi pomai kotoroqi nokoma pupu hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Pupu hiiremi tti ngusuru ngasuruiqi dzoge biire aimaqi noke kanabeteta. ");
INSERT INTO ghs_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Oi noi noo samane hiireta oonihe noi hee, Nike baamu paha ana mooraqu ooqaho quba qupa nokohoi qanganipamu naatemi tti minake hiireta. Oionita noko Pauroke dzeimami sisimata peitemi nokoi aipo biireta. ");
INSERT INTO ghs_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Hiibi nanai Epesoho maimane gaubireqi pobinoke tuuma qaaramuti Koo sungata biranateta. Iihai mootomi Roti sungata dzuubaqi tuuma Pattara nagapata biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ota sisima teei Peonike habata tuumareiqi roibetomi saridzeqi ota peiteqi tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Tuuma qaaramuti Kiporo sunga moohimi mage neta oomi riiteta. Ma Siria haba neta tuuma qaaramuti Ttiro nagapata biranateta. Ota sisimai quruma perebireta. ");
INSERT INTO ghs_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Perebiromi nana Ttiro nagapata peiteqi sinabidza tuputa abi qesa saridzeqi nokoma qupi sebenike qaata. Qaami Sumasai bapotopotomi nokoi Pauro Dzerusaremu nagapata eto tuumainoho qubake qaanateta. ");
INSERT INTO ghs_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ota nana qaami tuumaqu bodza dzamonatemi abi ma paimane ma khata ma khameto nanai gama igasata pomai kotoroqi pupu hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Pupu hiireqi qesa aipo biireqi sisima peqimi noko nagapata burisi eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ma Ttiro nagapake qaate tuuma qaaramuti Ttoremae nagapata biranateqi sisimata tta eeteta. Qate nanai ota sinabidza tupu abi saridzeqi qupi teenake nokoma meeta. ");
INSERT INTO ghs_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Iihai mootomi tuuma qaaramuti Kaisarea nagapata biranate Piripo saridzeta. Piripo ape bahe bosata Dzerusaremuta ttiihu abi sebenike aimata noi nokohota teei oonita nanai noho nagata peiteta. ");
INSERT INTO ghs_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Qate noho atasare eserisa eseri somoroi qaata nokoi paha too abiho isaki naate qaata. ");
INSERT INTO ghs_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Obetemi nanai ota ipibire qaami Dzutea haba nena too abi teeho dzapa Agabo noi nanaho toro biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Biranateqi makuku Paurohoke aimaqi ooma oko ma boto nohoke suutoqi hiireta, Qaheuba Sumasa noi erake hiire, Makuku eraho maikhata noi Dzerusaremu nagapata tuuma biranatemi Dzuta abi noko eranomake eeteqi raaba abiho botota mootakoiqi hiire. ");
INSERT INTO ghs_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Noo oke Agabo hiiremi nanamae ma nagapa maikhameto ma gama Pauro Dzerusaremu nagapata tuumainoho bame eeteqi qaanateta. ");
INSERT INTO ghs_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Qaanatemi noi erake hiireta, Naane quba tti minake hiireqi qupa nahoke ai buribaro eetoraidzo? Ana Dzerusaremu nagapata sutasuta peitaqu oi keke bahe, Soopara Dzesuho quba eeteqi baatare roibetorai. ");
INSERT INTO ghs_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Hiiremi oho bai hiiremi tatanga naatemi noko ma nanai gama qaateqi hee. Isanate, Sooparaho noo meenoma naatare. ");
INSERT INTO ghs_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Baura bisa qesa baamu naatemi nanai roibeteqi Dzerusaremu nagapata tuumare eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Eetemi Kaisarea nagapa nena sinabidza tupu abi qesai nana dzeimaqi abi teeho dzapa Manaso, sinabidza abi agoba Kipiro sunga nena, noho hagata nana mootota. ");
INSERT INTO ghs_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Obete tuuma qaaramuti Dzerusaremu nagapata biranatemi ota sinabidza abi qesai nana dzaira eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Oonihe iihai mootomi Pauroi nanake dzeimaqi Dzakopoho torota peiteta. Nanai ota peiteqi oomi sinabidzaho bosa qobaqoba qesa biranate soubireta. ");
INSERT INTO ghs_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Biranatemi Pauroi boto nokoho aimaqi, Ohongai husi ma pai naatemi raaba abi nokoho toro sinabidza baura eetemi mee biranateta, oho noo ma pobi mekeqomake hiire soubireta. ");
INSERT INTO ghs_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Pauro isere mooto soubiremi nokoi gama Ohonga hasa hiireqi Pauro erake pobi hiireta, Dzaira naname, abi dzare ttauseni bahe oho samanenipamu ao nooka hiisi eetoraimi nii moorai. Oonihe abi qesa erata oorai nokoi paha hu nooho dzaodzaonoma. ");
INSERT INTO ghs_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Oonita sigita niiho noo teeke erake hiire baami nana nookorai. Hee, Dzuta abi raaba abiho bisata oorai nokoi Moseho noo qaatareiqi pobi hiirorai, hiiqi khametoho samata geeba mootainoiqi qamuni hiirorai, ma Dzuta abi oora ma qaara tete napame qaatareiqi qamuni hiirorai. ");
INSERT INTO ghs_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Nagapa eraho abi noko niiho totoho erake nookorai. Ma nii Dzerusaremu nagapata baabe oho pobi noko ao nooka soubidzakoita nookare. ");
INSERT INTO ghs_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Oho qubake nii quba apeke eetaqu oke nana hiiremi nii niimae oke eetare. Nanahota abi eserisa eseri oorai nokoi Ohongahota noo tatanga nokome mootomi ooraiho qubake ttarumi nokome topotaamake oorai. ");
INSERT INTO ghs_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Oonita nanai niike nokohota mootomi nii nokoho isakita quba eeteqa ttuma nokohoke biiremi ttarumi nokome topotare. Nii oke eetemi minarai niike eraiqi hiibakoi, Oo, noo nohoi baami nana nookata oi meeama, noi hu noo qusubaitoraiqa hiibaridzonita oke nii eetare. ");
INSERT INTO ghs_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Qate nanai raaba abi sobasobahoke hee, Ohonga oberaoberaho kiridza kabira dzuuma oorai, kabira dzaganoma oke qaasuhiqa dza ma rumubake biidzare hiire tatangaiteta, oke nii gesina. ");
INSERT INTO ghs_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Oke hiiremi Pauro noi abi eserisa eseri nokohota ipibiremi iihai mootomi sama sasa ma quba nokome roibete soubireqi Ohongaho biirita dzuubata. Dzuubaqi Pauroi bodza nokoho hutingi bamu naatarota ma oho kiridza qeebarota oho noo abike pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Oonita nokoi ttarumi nokome topotomi ete bodza sebeni oi baamu naatare boohimi Dzuta abi Asia Gattiqaho haba nena nokoi Pauroke biirita mooqi abi qesa oona oota nokoke gama kosibeteta. ");
INSERT INTO ghs_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Kosibete Pauro aimaqi suu ubaqotoqi hiireta. Ae, Isirae abi baa nana hoobidzare. Abirai haba samaneta tuumaqi Dzuta abi napa ibo eeteqi hu noo napaho ma biiri napaho baaba eeteqi biiri napahota Giriki abi dzeima baaqi qaheuba nagake kanesanomaitorai. ");
INSERT INTO ghs_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Oiqi hiireta oi teeho quba bahe bosata nokoi moomi Pauro noi Epeso nagapa nena Ttoropimo ma nopoi Dzerusaremu nagapata tuuma ma baaba eetota. Oho quba nokoi hee, Raaba abi oke qaheuba biirita dzeima peite ootaiqi qupadzomaqi oho areare hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Oonita Pauroke nokoi karabetemi nagapa abi gamaqa oko tumutumu biireqi gururuiqi ttutturateqi abi qesai Pauro biirita hotou biireqi ao hairiamake oho tete siireta. ");
INSERT INTO ghs_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Oonita abi noko Pauro aimaqi teete kebaitare eesumi oho pobi oi Roma qaa abi minaho tomata taatemi roqobeteqi erake hiireta, Dzerusaremu abi noko gama susupu qaa aimaqi eetorai. ");
INSERT INTO ghs_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Noo oke hiireqi hairiamake qaa abi mimi ma gamitti aimaqi gururuiqi tuumata. Oonita Dzuta abi nokoi Pauroke teesuhiqi moomi soopara minai qaa abima gama biranatemi noko qaateta. ");
INSERT INTO ghs_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Oonihe qaaho soopara minai biranateqi qaanahiqi ngibira eserima Pauro suutota. Suutoqi noi Pauroho dzapa qasa hiireta ma quba apeke eeteta oho qasa eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Eesumi abi noko sokasoka ma garugaru hiire rasaki eetemi te nooka pobitara. Oonita sooparai hiiremi qaa abi noko Pauro aima qaa naga nokometa tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Tuusuhiqi Pauroi irita peitare boohimi Dzuta abi noko noke qeegoromi qaa abi noke qusuta aimaqi peiteta. ");
INSERT INTO ghs_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Peitemi abi tupu minai iihaqi sokasoka hiire tuumaqi erake hiireta, Abi oi baamu naatare! Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Dzuta abi sokasoka hiimi Pauroi iri qusuta ooqi dzuubare boohiqi qaa sooparake Girisi noota qasa hiireta, Maqo ana isanate noo teeke nii pobi hiibaqu mae? Hiiremi sooparai hee, Ae, Nii Girisi noo nookorai mae? ");
INSERT INTO ghs_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Abiniqake Aigitta abi teei qaa eetare qaa abi po ttauseni aimaqi haba habanata tuumata nii abi oioni mae ape? ");
INSERT INTO ghs_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Qasa hiiremi Pauroi erake hiireta, Ana Dzuta abi, Kirisi habaho nagapa Ttaraso dzapa pobinoma, anaio oho nenani. Oonita nii nookami ana noo gattiqa abi pobi hiibare. ");
INSERT INTO ghs_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Hiiremi nookami Pauroi iri kokota qoroqi abi boto qamuni eetemi noo nipanatemi Dzuta abiho noota noo hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Heboro noota Pauroi hee, Dzairamane ma abi mimi name, ana khooba name hiire nookare. ");
INSERT INTO ghs_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pauro noi oke hiiqi Dzuta abiho noota noo hiiremi noko nookaqi poupaamake oota. ");
INSERT INTO ghs_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Oomi noi ipibire pobi hiireta, Ana Dzuta abi, Kirisi habata Ttaraso nagapata biranateta. Oonihe ana Dzerusaremu eraqata baa nokanoka nagata qaaqi bitotota. Bitotoqi banaita Gamarie noho dzagata qaami sinabidza banaitemi abi mimi napameho noo qusubaite kokora eete qaata. Paha poike nike Ohongaho dzaodzao eetoraidzo anai oho qesa Ohongaho eeteqi ima ma bago heeta qaaqi tatanga naateta. ");
INSERT INTO ghs_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Eeteqi sinabidza usaqe baamu naatareiqi ana ibo eeteqi abi oni mae paimane gama suutoqi sutasuta nagata mooto qaata. ");
INSERT INTO ghs_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Oi dzube abi mina ma sinasina abi mimima nokoi naho khooba gama gesina. Nokoi qesamane napaho Ttamasiko nagapata ooraidzo nokoho pepa qeeteqi ana moitemi erake hiireqi aima tuumata, Ana qeota abi ma paimane oonoma saridze suutoqa Dzerusaremu nagapata aima baamake ipi moitare. Oke Pauro hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Oonita Pauroi noo nome ipibireqi hee, Anai oke qupadzomaqi teteta tuumomi ete bisata Ttamasiko nagapa dzamoihimi qusu neta eepa dzadza minai biiqi baa anaho nese kootorota. ");
INSERT INTO ghs_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Kootoromi ana tookata taate ooqi totoho teeke erake nookata, Sauro, Sauro oe nii naane quba ana teete iihoraidzo? ");
INSERT INTO ghs_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Hiiremi anai hiireta, Soopara name nii ape oni? Hiiremi erake ana pobi hiireta, Dzesu Nadzarette nagapa nenake nii teete iihorai teena anaio. ");
INSERT INTO ghs_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Oiqi hiireta oonihe abi anama qaata nokoi eepa dzadza keke mootahe, noo anake pobi hiiretake te nookara. ");
INSERT INTO ghs_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Eetemi ana qasa hiireqi hiireta, Soopara name, ana quba apeke eetareke nii hiibi? Hiiremi Sooparai erake ana pobi hiireta, Nii qoridzeqa Ttamasiko nagapata tuumamake, quba nii eetoraidzoke ota nii pobi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Oiqi hiiretanita eepa dzadzai nese naho kootoromi qupi sooromi qesamane nahoi ana basidzomaqi Ttamasiko nagapata dzeima tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Nagapa ota abi teei qaata dzapa noho Anania. Noi hu nooho tete aimanoma, Dzuta abi nagapa ooqana qaata nokoi noho nookami qidzani. ");
INSERT INTO ghs_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Abi oi naho toro biranateqi erake hiireta, Dzaira name Sauro. Nii nese parara eetare. Hiimi anai nese parara eete haba moota. ");
INSERT INTO ghs_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Moomi noorake pobi hiireta, Uimane napaho, noko ma napaho Ohonga noi khooba nome paanaitareiqi hiiremi nii qidzaho maikhata moorare mooqi too nohota noo nookareiqi nii asateta. ");
INSERT INTO ghs_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Obetemi nii quba moo nooke oho pobike haba samaneta abi pobi hiire tuumare. ");
INSERT INTO ghs_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Sigita nii ikabete sepeke ooraqu? Nii qoridze Dzesuho dzapa qiraitemi niike sinabidza obama sooromi pasena niiho dzamutare. Oiqi Anania ana pobi hiireta oke Pauro hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Pauroi hee, Oke Anania ana pobi hiiremi qusubaiteta. Oonihe ana burisi eeteqi Dzerusaremu nagapata biranateqi Ohongaho biirita peiteqi pupu hiireqi neneho isakita Dzesu moota. ");
INSERT INTO ghs_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Moomi erake ana pobi hiireta, Nagapa eraho abi noko niiho toota noo naho nookaqa gottae eetakoi. Oho quba nii hairiamake Dzerusaremu qaateqa tuumare. ");
INSERT INTO ghs_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Hiiremi ana noo ipike hee, Soopara name ana abi niihoke sutasutata mootoqi sinabidza naga samaneta aima peiteqi gouma teete qaata. ");
INSERT INTO ghs_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Qesai hibahiba niiho Settepano teetare sasa nokome tupubiremi ana soopara eetemi teeteta oke ana nookami isanateta. Oi nagapa eraho abi gama nooka soubiroraita ana niiho pobi isanate hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Oke hiiremi Sooparai bai hiireta, Baamu. Ana haba kharata raaba abiho torota nii dzoobihibita ao tuumare. Oiqi Dzesu hiiremi ana nookata. ");
INSERT INTO ghs_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Oke Pauro hiimi eehe, Abi noko toma tiisuta nokoi noo musaqi nohoke nookami raaba abiho naatemi noko sokate qarutoqi hiireta, Ae! Pauro noi peranomanipamu oonita noho dzapa baamu naatare. ");
INSERT INTO ghs_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Oke hiire sookateqi sasa khara nokome kuimaqi pomu tupu teetemi peiteta. ");
INSERT INTO ghs_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Peitemi soopara minai hiiremi qaa abi nokoi Pauro naga nokometa aima peiteta. Obetemi abi noko naane quba sookateo oho khooba nookakoiqi qaa sooparai gouma teetare hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Oonihe nokoi gouma teetareiqi hoo sasa siihuma suutare boohimi Pauroi qaa sooparake erake hiireta, Nikei Roma abi anake sepeke sesero eete noo nahoke hiire pobitaamake gouma teetemi isanataqu mae? ");
INSERT INTO ghs_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Oke hiiremi noi soopara mina nomeho toro tuuma pobi hiireqi hiireta, Nii ikake eetareiqi hiibi. Abi oio Roma abinipamu oni. ");
INSERT INTO ghs_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Oke hiiremi soopara minai ao Pauroho toro tuumaqi qasa hiireta, Maa meenipamu nii Roma abi oni mae? Hiiremi Pauroi hee, Oi meenipamu. ");
INSERT INTO ghs_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Oke noi hiiremi qesai Pauroke buribaroke eete toronaitare boohita nokoi ao qaateta. ");
INSERT INTO ghs_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Qate Pauroi Roma abi ootaho pobike qaa soopara minai nookaqi sahateta. Oi teeho bahe Pauroke noi ao suutomi oota. ");
INSERT INTO ghs_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Oonita iihai mootomi qaa soopara minai Dzuta abi noko Pauroke naane quba nookami qanganateta oho khoobanipamu nooka quba dzube abi mimi ma sinasina tupu gama susupu hiiremi ttutturateta. Ttutturahimi Pauro dzeima qura nokoho torota mootota. ");
INSERT INTO ghs_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","2","Pauroi Dzuta abiho sinasina tupuke qeraqera eeteqi noorake hiireta, Qesamane name, ana hu nooho bai ma qamuni hiibaamake Ohongaho pengata qaatai qaabi. Oke hiiremi dzube abi mina Anania noi abi Pauroho dzagana qoroqota nokoke hee, Pauroke toota teetare. Hiiremi teeteta. ");
INSERT INTO ghs_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Teetemi Pauroi hee, Ttidza makanoma nii! Oi nii anake Ohongaho hu noota batabidzare hiireqi oho tekata habese ooraihe hu noo oke riiteqi ana oberama teetare hiire oonita Ohongai paha niike teetare boohibi. ");
INSERT INTO ghs_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Oke hiiremi abi qoroqota nokoi hee, Nii oonomake Ohongaho dzube abi minake pobi hiidzo? ");
INSERT INTO ghs_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Hiiremi Pauroi hee, Qesamane name, sinabidzata noo erake hiirorai. Nii eto abiho sooparake qanga hiibaino. Ana noo oke nookorai. Oonita abirai dzube abi mina oori oke ana nookaamake noo oke hiire. ");
INSERT INTO ghs_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pauroi oke hiireqi nese dzoobire moohimi tupuho abi qesai Satukeo ma qesai Pariseo oonita nokoi hu ma koridza biidzareiqi noi sokateqi hee, Abi qesamane name ana naamae Pariseo abi oho gottanipamu. Oonita baata neta qoridzaquho noo oorai oke qusubaitorai ooqaho quba nike anake noota mootoraidzo. ");
INSERT INTO ghs_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Pauroi oke hiiremi Pariseo ma Satukeo nokoi qesa kurebeteqi hu ma koridzanoma naateta. ");
INSERT INTO ghs_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Oi Satukeo abi nokoi baata neta qoridzaqu ma angero ma gutu boto khara quba oonomaho baike hiirorai qate Pariseo abi nokoi oho nookami meenomani. ");
INSERT INTO ghs_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Oho quba garuba nokometa qesa kurebeteta. Kurebete Pariseo abi nokoho tuputa sinabidzaho banaita qesai qoridzeqi tatangama erake hiireta, Nana abi eraho kahosa moomi baamu, angeroni mae gutu boto khara teei noke pobi hiiretaiqako ikabete sepeke bai hiibaqu? ");
INSERT INTO ghs_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Hiireqi baaba minake hiiremi qaa soopara minai hee, Tupu nokoi Pauroke ngausa eetainoiqi hiiremi qaa abi nokoi biranateqi Pauroke abi bisata dzeima naga nokometa tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Obetemi qupi ooqata Ohonga Sooparai Pauroho torota biranateqi qupanomaiteta. Nii Dzerusaremu nagapa erata anake paanaisubi oho qesa Roma nagapata anake paanaitakoita etoqa ququimaino oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Oonita iihai mootomi Dzuta abi qesa hongasireqi pattaho hutingi naate hee, Pauro teeteqanoke oba ma patta muunare hiireqi gunu dzoomata. Oonihe abi erake hiireta nokoho dzare poti riiteta. ");
INSERT INTO ghs_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Abi nokoio too abi mimi ma Dzuta abi mimi nokoho toro tuumaqi paanaiteqi erake hiireta, Nana patta hutingi minanipamuke eeteqi Pauro teeteqanoke ooqata quba muunare naru hiire. ");
INSERT INTO ghs_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Oho quba sinasina tupu ma nikei qaa soopara minaho toro noo dzoobireqa hee, Nii Pauro nanaho garubata dzoobire baami noo noho paha hiibare. Hiiremi noi noo nikeho nookaqi oke eetema nana ao Pauro teteta teetakoi. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Oonihe Pauroho mapui teetaquho noo nookata. Nookaqi qaaho nagata peiteqi nasami nome pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pobi hiiremi Pauroi qaa abiho kira hiireqi erake hiireta, Nii khata erake qaa soopara minaho toro dzeima tuumami noo teeke pobi hiibare. ");
INSERT INTO ghs_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Hiiremi qaa abi noi khatake soopara minaho torota dzeima tuumaqi noke pobi hiireta. Sutasuta abi Pauro noi naho kira hiireqi hee, Khata erake dzeima qaa sooparaho torota mootomi noo hiibare. Hiiremi khata erai noo nii pobi hiibare dzeima naka baabe. ");
INSERT INTO ghs_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Oke hiireqi pobi hiiremi soopara minai khata botota aimaqi sigiqata tuumaqi qasa hiireta, Noo apeke hiibaqu? ");
INSERT INTO ghs_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Hiiremi khatai hee, Dzuta abi noko niiho toro noo mootomi baabareiqi hiire nookao. Pauro garuba nokometa dzeima tuumaqi khooba nome paanaite soubidzareiqi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Pobi hiiremi noo nokoho eto nookaino. Abi nokoho dzare 40 riite oio Pauro teetare hiiroraidzo. Noko patta hutingi minanipamuke eete ooraiqi Pauro teeteqi sapunge muunare naru hiire roibeteqi niiho noo beebe oorai. ");
INSERT INTO ghs_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Khata noi noo oke hiiremi soopara minai hee, Nii noo hiire paanaisubi oke eto abi pobi hiibaino hiireqi dzoobireta. ");
INSERT INTO ghs_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Oonita qaa soopara minai qaa bosa qobaqoba eseri dzeima baaqi erake pobi hiireta. Nipe hiiremi qaa abi okoma tuumaqu oi 200, qate oosina tuumaqui 70, qate koo aimaqui 200 oi roibeteqa qupibaho 9 kiroko eesuhiima nike Kaisarea nagapa tatangata tuumare. ");
INSERT INTO ghs_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ma Pauro oosi teeke saama mootare. Eeteqi tteike soopara eeteqi kiape mina Perikhi noho toro aima tuumare. ");
INSERT INTO ghs_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Oke hiireqi kiapeho quba dzaira pepa teeke erake hiireqi qeeteta. ");
INSERT INTO ghs_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Hee, Dzoobe Pirikhi, kiape qidza name, anai niiho quba pepa era qeete. ");
INSERT INTO ghs_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Qaa abi noko abi teeke aima qeeme noko Dzuta abi teetare eeteta (dzapa noho Pauro). Anai nookami noi Roma abinipamu naatemi qaa abima nana tuumaqi nokoho botota hiumata. ");
INSERT INTO ghs_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Oonihe noke noota moototaho quba khooba nookareiqi bosa qobaqoba nokoho garubata aima tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Aima tuumami hu noo nokomeke qupadzomaqi qomaqoma hiiremi ana nookata. Quba eeteta oi te peiteqi teeta ma suutaho isaki naatara. ");
INSERT INTO ghs_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Qate abi qesai geema mootoqi Pauro teetare hiiremi nookaqi niiho toro dzoobiremi qeeme oio. Ma qomaqoma hiirorai abi oio noke oho qesa ana iihami niiho toro qeeme nokoi noo nohoke nii pobi hiibare. Anai Dzerusaremuho kiape, Kautio Risia. ");
INSERT INTO ghs_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Noo ooqake dzaira pepata qeetemi qaa nokoi soopara nokomeho too qusubaite pepa aimaqi qupibake dzeima tuuma qaaramuti Attipatti nagapata biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Biranatemi iihai mootomi okoma tuumataho qaa abi nokoi naga nokometa burisi eesumi oosinai keke Pauro dzeima tuuma qaaramuti Kaisarea nagapa biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Biranateqi Kiapeho dzaira pepa moiteqi Pauroke oho qesa noho botota mootota. ");
INSERT INTO ghs_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Mootomi kiape Perikhi dzaira pepa nome isaiteqi Pauroke haba khooba nohoho qasa hiiremi hiireta, Ana Kirikia haba nena. ");
INSERT INTO ghs_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Hiiremi kiapei hee, Noota nii mootorai abi naga oi baamake niiho noo hiibakoi. Oke hiireqi qaa abi pobi hiiremi Heroteho qaa guhuta mootoqi Soopara eetota. ");
INSERT INTO ghs_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ete bodza boto teena bamu naatemi dzube abi mina Anania noma abi mimi qesa, ma noo soopara teeho dzapa Tetturu, nokoi Kaisarea nagapata tuumaqi kiapeho torota Pauroho noo hiibare biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Oonita kiapei hiiremi Pauro qeemami Tetturui qomaqoma hiireqi kiape noorake pobi hiireta, Kiape qidza naname, nii isanate nana soopara eetemi keba ma hasuta oorai. Paha abi tupu era nanaho quba iiha ma dzoobidza eeteqi hoobirorai. ");
INSERT INTO ghs_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Hoobiremi nanaho nagapaho isaki quba samane isanate soubirorai. ");
INSERT INTO ghs_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","5","Oonita noo hiire kharanatainoho quba nii kebarateqi nookami noo hote teeke nii pobi hiibare. Abi eraho nookami qanga naatorai, noi iima barunoma Dzuta abi haba samane tuuma oorai nokoke kosibetorai. Qate paha sinabidza abi obera nokoke nanai hee, Nadzaretteho nenaniqi hiirorai noi nokohota bosa qobaqoba naate oorai ");
INSERT INTO ghs_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ma paha noi biiri nanaho makanomaitare eesuhimi aimata. ");
INSERT INTO ghs_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","8","Ma nanai noo nii pobi hiibi oke niimae qasaqasa hiireqi khooba isanate paanaitakoi. ");
INSERT INTO ghs_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Noo oke Tetturui hiiremi Dzuta abi noko noke hoobireqi noo noho qaupuiteta. ");
INSERT INTO ghs_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Oonita kiapei Pauro botoma qaseqase eetemi noorake hiireta, Nii haba erata tii samaneke kiape oorai oke ana qupadzomaqi noo name iiha ma dzoobidzaamake hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ana Dzerusaremu nagapata Ohonga penga bototareiqi qeema qaami ete ma qupi 12 keke naateta nii noo oho quba abi qasa hiiremi nii pobi hiibakoi. ");
INSERT INTO ghs_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Oi ana biirita mae sinabidza guhu qesata mae sinabidza nagapata abi ma nana sinabidzaho baabani mae abike kosikosi oke ana te eetemi noko moorara. ");
INSERT INTO ghs_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ma abi oi qomaqoma hiireqi noo hiirorai oho mee apeke nii banaitaqu? ");
INSERT INTO ghs_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Paha teeke hiire paanaitemi nookare. Tete meeho ngiingike nokoi eetorai ota ana qoororai oke noko hiirorai, oi meenipamu eetorai. Ma nokoho noo ma sinabidza aimaqi hu noo qibata sinabidza qeetemi oorai ma too abi hiire qeeteta oke ana nookami oi mee, uimane neimane napaho ma nokoho Ohonga noho qaruke eetorai. ");
INSERT INTO ghs_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Oonita qaaqi abi qidza ma qanga baata neta qoridzaquke mai eetakoi, oho quba abi era noko ma ana gama qupadzomorai. ");
INSERT INTO ghs_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Oke eete qaaqi Ohongaho pengata ma abiho pengata kahosaamake oora quba sama nameho bakena geema oorai. ");
INSERT INTO ghs_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Ma ana tii samaneke haba kharata qaaqi sinabidzaho ttuma samaneke ttuttuite qaatati Dzerusaremu nagapata qesamane nameho torota aima tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ma kiridza qeeba quba roibeteqi Biirita dzuuba oomi noko ota ana saridzeta. Sarihimi nanai te abiho tupu gairuru ma soropuruho tuputa oorara te husu ma noo agata oorara, baamu. ");
INSERT INTO ghs_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Oonihe Asia haba neta Dzuta abi qesai Biiri ota biranate naho qomaqoma hiireqi abi kosibeteta oonihe ikaqi hiireqi nokomae teqaha niiho toro biranate oke hiire paanaitoraidzara. ");
INSERT INTO ghs_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Mae ipita ana sinasina tupu nokohota qooroqomi naho kahosa teeke nookataiqako abi erana qoororai nokoi isanate nii pobi hiibare. ");
INSERT INTO ghs_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Oonihe anai noo teenaqake nokoho bisata hiiremi oke noko nookami nokohota isanataama naateta kaqa, oi ana paata erake pobi hiireta: Baata neta qoridzaqu oi oorai noo teena oke ana qusubaitorai qesai oke nookaqi anake noota mootomi nikeho pengata qoororai. Oke Pauro hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Hiiremi kiape Perikhi noi Pauroho noo oke hiire hiumaranihe oke mootota. Oi teeho bahe noi sinabidza usaqe Dzesuho pobi te nookaamake oorara. Oonihe noi gimuttake eete erake hiireta, Qaa soopara Risiai Dzerusaremu nagapa neta quratemake noo nokohoke hiumakoi. ");
INSERT INTO ghs_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Oke hiireqi noi qaa soopara erake pobi hiireta. Nike baaqi kokora eetare hiiremi eto bai hiibainoiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Oonita qupi qesa naatemi Perikhi noi Dzuta abiho neta ata noho Tturisira noma nopo ooqi Pauroho quba hiiremi dzeima peiteqi Pauroi Dzesu Kiristu nooka hiisi eetaridzoho khooba pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Oonihe hiiqi pobipobiho tete ma pasenaho hutingi naataquho tete ma ipi bodzaho ipi ma ari hiiremi Perikhi atti roqobeteqi Pauro erake pobi hiireta. Oo, kebanoke naamae bodza mootoqake paha niiho quba hiiremi ipibidzakoita tuumare. ");
INSERT INTO ghs_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Hiireta oi noi dza eetemi Pauroi noke ttuma moitakoiqi hiireqi bodza samane dzeimaqi noma nopo noo hiire qaatahe Pauro te noke ttuma moitara. ");
INSERT INTO ghs_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Oonihe tii eseri bamu naatemi kiape teeho dzapa Porokio Pesto noi Perikhiho habara naateta. Oonihe Perikhi noi Dzuta abi qupa qidzaqidza moitareiqi te Pauro sutasuta nagata saqobara. Bamu, qaateqi tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Qate ao ete tapiriho nakuta Pesto noi bukhi ttidzake soopara baura nome mai eeteqi Kaisarea nagapa qaate Dzerusaremu nagapata peiteta. ");
INSERT INTO ghs_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Peite biranatemi dzube abi mina ma Dzuta abi mimi nokoi noho toro bitanateqi Pauroho noo pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Hee, nii nanahoke nooka isanatemake hiire Pauro Dzerusaremuta biranatare pobi hiibare. Oiqi hiireta oi noko teteta qaa mooto Pauro teetare qupadzomaqi oke kiape pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Hiiremi Pestoi erake hiireta, Pauroi Kaisarea nagapata sutasutata oorakoi oonihe ana paha hairiaamake burisi eete ota quratakoi. ");
INSERT INTO ghs_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Oonita nike Pauroho kahosa noo hiibareiqa anama gama qurate hiibare. Hiiremi mee eetaqu mae baamu. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Oonita Pestoi qupi 8 oni mae 10 oke Dzerusaremu nagapata ooqi Kaisarea nagapata qurateta. Iihai mootomi noi noo qohareta peiteqi hiiremi Pauro aima peiteta. ");
INSERT INTO ghs_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Peitemi Dzerusaremu nagapa nena Dzuta abi noko rome biireqi bedzabedza eete Pauroke qomaqoma hiirota. ");
INSERT INTO ghs_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Oonihe qomaqomaho mee te biiranatara. Oi Pauroi noo nokohoke ai qurateqi erake hiireta. Maqa, Dzuta abi nikeho hu noo mae nikeho qaheuba Biiri mae Roma abi qiba oi te anake qomaqoma hiiremi isanatoraidzara. ");
INSERT INTO ghs_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Hiiremi Pestoi Dzuta abiho ttidza qidzaqidza quba Pauro qasa hiireta, Nii isanate Dzerusaremu nagapata tuumaqa ota noo niime hiire uhutaqu mae? ");
INSERT INTO ghs_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Hiiremi Pauroi hee, Baamu. Roma abi qibaho noo qohare oi eraqanita naho noo erata hiire uhutare. Nii niimae naho khooba gesina naatemi ana Dzuta abike quba qanga teeke eetara. ");
INSERT INTO ghs_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ana honga ma kahosa mina teeke eetapuko hiibarori. Teetare hiiremi ana sama name baamu qanatarori. Nokoi obera qubake qomaqoma naho hiiroraita apei nokoho ttidza qidzaqidza quba eete anake nokoho botota mootaqu, baamunipamu! Oonita anai Roma abiho pobita Roma abi qibake noo nameke hiibareiqi hiibi. ");
INSERT INTO ghs_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Oke Pauro hiiremi Pestoi qeraqera eeteqi sinasina abi nomema noko hiire qaasuqi Pauroke pobi hiireta, Abi qiba Kaisaho quba hiire oonita isanate nii abi qiba noho toro tuumare. Oiqi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Oonita ete bodza qesa baamu naasumi abi qiba gattiqa Agiripa ma Benike nopo ipai keke Kaisarea nagapata qurateqi Pestoma nokoi qesa dzaira eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Obete nopoi noma oora ma qaara eesumi Pestoi Pauroho noo ma pobike Agiripa eraiqi hiireta, Perikhi noi sutasuta abi teeke qaate tuumami oorai. Oonita ana Dzerusaremuta peiteta. ");
INSERT INTO ghs_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Peitemi dzube abi mimi ma bosa qobaqoba nokoi naho torota ttutturate anai abi oke teete baatareiqi ana pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","17","Oke hiiremi anai bai hiiremi Dzuta abi paha qesai anama nagapa erata baahumi iihai mootomi anai no ma noko gama dzeima noo qohareta tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Eetemi noko Pauroho pasena khooba teeke paanaitare hiimi ana moohimi oi mainata tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Oi noko sinabidza nokomeho quba kurebeteta. Ma abi baateta teeho dzapa Dzesu noho dzapake aima hiireta. Abi oohoke Pauroi eraiqi hiireta: Abi oi ao qori oorai. ");
INSERT INTO ghs_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Oke hiiremi ana noo oonomaho quba hou eeteqi hee, Pauro nii Dzerusaremu nagapata peitemi ana ota noo niihoke suhe hiumare, oke anai noke pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Hiiremi Pauroi Roma abi qibanipamu noo nome suhe hiumare hiireta. Hiiremi isanateta oonihe Pauro tuumaquho bodza naatemake ana hiiremi Roma abi qibaho toro tuumareiqi noke sutasuta nagata mootomi beebe oorai. ");
INSERT INTO ghs_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Oke Pestoi hiiremi Agiripai hiireta, Abi oi noo teeke hiire ana nookare dza eete. Hiiremi Pestoi hee, Isanate iihaike niimae noo nookare. ");
INSERT INTO ghs_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Oonita iihai mootomi Agiripa ma Benike nee ma bau nopomema garuba nagata peiteqi qaa soopara mimi ma nagapa oho abi gama dzeimaqi peiteta. Peite soubiremi Pestoi hiiremi noko Pauro ai peiteta. ");
INSERT INTO ghs_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Peitemi Pestoi noo erake hiireta, Dzoobe abi qiba Agiripa ma abi qesamane name ana noo hiire nike nookare. Abi erana qooro oorai noho qubake Dzuta abi adzapei Dzerusaremu nagapata sookate bedzabedza eete eraiqi hiireta, Noi baamu ooraqunipamu oni! ");
INSERT INTO ghs_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Oonomake hiiremi anai noho kahosa qiri eete qupadzomami noke teete baataquho isaki baamu. Oonihe noi Roma abiho qiba Kiasaho qubake hiiremi oho qubake anai noke noho torota dzoobire tuumakoi. ");
INSERT INTO ghs_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Oonihe ana noo mee qiri eete abi qibaho quba dzaira pepa qeetare hou peu eesubi. Eetemi oho qubake abi erake abi qiba Agiripa ma nikeho quba qaasuhimi nikei khooba noho saridzemake ana noo noho qeetemi tuumare. ");
INSERT INTO ghs_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Oi anai abi teeho noo ma kahosake qeetaamake sepeke dzoobire Roma nagapata tuumaquho teteke ana isanatamani. Oke Pestoi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Oke Pestoi hiiremi Agiripai Pauro pobi hiireta, Oionita niimae khooba niime hiire nana nookare. Hiiremi Pauroi boto nome dzoobireqi noo erake noko pobi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Hee, Ao Dzuta abiho nooi anake qomaqoma hiirorai oho totaqike poike abi qiba Agiripa niiho pengata hiibareiqi naho qupa qidzanate. ");
INSERT INTO ghs_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Oi teeho bahe ana nookami nii dzuta abi nanaho sinabidzaho kurekure ma quba eetoraiho khooba gesina. Oonita nii nookamake ana noo name hiibare. ");
INSERT INTO ghs_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","5","Ana bittina nameta Dzuta abi qesamane nameho bisata oora ma qaara eete bitotoqi Dzerusaremuta baa qaata oke noko gama gesina. Pariseo sinabidzaho nanemane gotta naate qaata nokoma nanai qaataho khoobake noko noo nooka qaaqi oke ao mee hiibarorihe baamu. ");
INSERT INTO ghs_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Anai sutasuta nagata oorai oi quba teeho quba bahe, Ohongai uimane napahoho naru hiireta. Ma sau samane Ohonga kiridza ma qonoqono qeere qaibi. ");
INSERT INTO ghs_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Oonita abi qiba name ana noo ooqaho ttidza dzebidzebi nokoi anake qomaqoma hiirorai. ");
INSERT INTO ghs_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Oi Ohongai abi baatetake tukutorai, oke nike naane qubake nookami quba eetaamaho isaki naatorai? ");
INSERT INTO ghs_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Oho qubake ana namaehoke hiire nike nookare. Anai Dzesu Nasarette nena noho dzapake ngausa eetare oho baurake name eete qaata. ");
INSERT INTO ghs_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Dzerusaremu nagapata ana oke eetota. Eetoqi dzube abi mimi nokoke qasa hiiremi gee tatanga ana moitemi ana sobasoba tupu adzepeke teete sutasuta naga samaneta mooto qaata. Paha abike gabehoma teete baatareiqi noko boto peitemi naho botoi oho qesa peite qaata. ");
INSERT INTO ghs_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Oi ana Dzuta abi nokoho sinabidza guhu samaneta peiteqi hee, Sobasoba tupu nike Dzesuho dzapa benatorai dzapa oke noko poiqa ngiingi ma peranomake hiibareiqi ana bedzabedza eete hiire qaata. Anai paha qaa battigarake naate nagapa kharanipamuta tuuma nokoke teete sigubire qaata. Oke Pauro hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Pauroi hee, Anai tete oonoma eete qaaramuti dzube abi mimiho toro peitemi nokoi pepa tatanga ana moiteqi hiiremi ana Ttamasiko nagapata tuumareiqi tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ana tuuma qaami ete bisana naatare eesuhimi qusu neta dzadza qurateqi ana ma abi anama tuumota nanake rome biireta. Oboboo! Abi qiba name, ete dzadza oi saparaparanoma, dzadza mootai minanipamu! ");
INSERT INTO ghs_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Obetemi nana ttokata taate oomi totoho teei Dzuta abiho noota hiireta, Sauro, Sauro qoe! Nii naane quba ana teete iihoraidzo? Nii qidzoke sama niimeke bagara biire qaaraqu. ");
INSERT INTO ghs_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Hiiremi anai hee, Ohonga name nii ape oni? Hiiremi noi hee, Nii Dzesuke teete iihorai anai ooni. ");
INSERT INTO ghs_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Oonihe nii nahoke moohibi ma paha ana ipita niike banaitoraqu oke nii qaupuiteqa naho qaru eete qaarareiqi ana isaki name niike banaihibi oonita nii ao qori qoobare. ");
INSERT INTO ghs_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","18","Oi ana niike dzoobiremi nii raaba abiho toro biranatemi nokoni mae Dzuta abi nokoi niiho qaa mootomake ana niike herohero eetakoi. Oke eete qaama raaba nokoho nese uhubami nokoi qupi nokome tume biireqa Saataho eka kuibire Ohongaho botona naate kahosaho dzamudzamu saridzakoi. Kahosaho dzamudzamuke saridzeqa qesai ao anake nooka tani eetorai nokoma gama qidzata qaarakoi. Totoho oiqi hiireta oke Pauroi hiireta. ");
INSERT INTO ghs_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Pauroi ipibireqi hee, Oonita abi qiba name Agiripa, ana qusu neta noo oke nooka qusubaiteta. ");
INSERT INTO ghs_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Oi bosata Ttamasiko nagapa abi ma Dzerusaremu nagapa nena abi ma paha Dzuta haba maikhameto nokoi keke bahe raaba abi gama qupa nokoho burisi eeteqi Ohongaho toro atimaqa noho botota oho mee qidza saridzare anai sinabidza pobi hiire baaorai. ");
INSERT INTO ghs_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ooqaho qubake Dzuta abi nokoi Biiri nokometa ana aimaqi teetare eeteta. ");
INSERT INTO ghs_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Eesumi Ohongai ana hohoba eete baaqoraimi ana sinabidza hiiretai hiirorai. Hiireqi abi mimi ma gamitti gama pobi hiirorai. Oi noo agiagi bahe, Mose ma too abi hore noo hiire noo qeeteta paasa oke hiirorai. ");
INSERT INTO ghs_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Oi teeho bahe Kiristu noi heme mooqa baatare hiireta. Paha, baateqa oho neta bosa qooro qoridzemake dzadzaho tete nohoi Dzuta abi ma raaba abi nokoho torota biranatareiqi nokoi hiireta, noo oke ana too teetorai. ");
INSERT INTO ghs_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pauro noi khooba nome hiire pobitapihimi Pestoi noo minake hiireqi hiireta, Ae, Pauro, niiho qupa rasaki naate. Pepa minake qeetemi oorai oke isaite qaabarobaro naatorai oio. ");
INSERT INTO ghs_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Hiiremi Pauroi hee, Abi qidza name Pesto, ana qupa rasaki noo bahe, noo mee, noo attinoma hiirorai. ");
INSERT INTO ghs_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Noo oho khoobake abi qiba Agiripai isanate nookorai, noho torota ana adzahaha naateqi hiirorai. Quba ana hiirorai oi dzukudzukuta te biranatara, oke ikanomake eete ruume naataqu? ");
INSERT INTO ghs_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Oke hiireqi Pauroi temuke dzaga bobotoqi hee, Abi qiba Agiripa, nii too abi nokoho noo nooka hiisi eetorai mae? Ana qupadzomami nii nooka qupadzomorai kaqani. ");
INSERT INTO ghs_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Hiiremi Agiripai Pauro qepuqepu hiireqi hee, Ae, nii bodza hoteqa teeke noo oonomake hiiremi ana ao Kiristuho abi naatake boobi mae? ");
INSERT INTO ghs_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Hiimi Pauroi hee, Bodza hoteqani mae khara, oonihe Ohongaho pengata ana dza eetemi nii keke bahe abi qesama nike poiqake noo erana nookaidzo, nikeke Ohongai hoobiremi anaho qesa naatareiqi hiibi. Oi sutasutahoke te hiibidzaranihe sinabidzahoke hiibi. ");
INSERT INTO ghs_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Oke hiiremi abi qiba Agiripa ma kiape Pesto ma Benike ma abi qesa noko qoridze ao biranateta. ");
INSERT INTO ghs_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Biranateqi qesa pobi pobi hiireqi erake hiireta, Mmhm, Pauro eetorai oi te teeta ma taangaho pobi oonidzara. ");
INSERT INTO ghs_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ma Agiripai Pesto erake pobi hiireta. Abi noi Roma abi qibanipamu Kaisaho torota noo nome hiibareiqi hiireta oke hiibaama naatapuko nii isanate noke saqoromi tuumarorihe baamu. ");
INSERT INTO ghs_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Oonita Itaria habata tuumaqu bodza dzamo naatemi kiape hiiremi Romaho qaa soopara tee, dzapa noho Dzurio, noi Augustuho qaa mimiho hohota tee onita noi Pauro ma sutasuta abi qesa aimaqi sisimata peiteta. ");
INSERT INTO ghs_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Sisima oi Attaramitte nagapa nena, oi Asia Gattiqaho nagapa unauna ttarita oota, ota tuumare hiiretaho isaki. Sisima ota peiteta, Maketonia abi teeho dzapa Aristako, Ttesaronike nagapa nena, noma gama tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","4","Oonita iihai mootomi sisimai Sitto nagapata unatemi Dzurioi Pauro dzaira eeteqi nookami nagapata peiteqi qesamane nome noo hiiremi teteho heeba ma apo moiteta. Qate sisimata paha peitemi utai tuumota neta baami nanai Kiporo sunga ma Asia habaho takurata tuumata. ");
INSERT INTO ghs_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Tuumaqi Kirikia ma Pamuria haba gir