﻿USE sofia;
DROP TABLE IF EXISTS sofia.ghn_vpl;
CREATE TABLE ghn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ghn_vpl WRITE;
INSERT INTO ghn_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ani za na kutina na tutina i Jisu Karisito aza na tutina i Devita aza na tutina i Ebarahami. ");
INSERT INTO ghn_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","I Ebarahami za vaporea i Aisake, ko i Aisake za vaporea i Jekopi, ko i Jekopi za vaporea i Jiuda beto ria na taina na tugana marene. ");
INSERT INTO ghn_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","I Jiuda za vaporedi ti Tama ari Parezi i Zara, i Parezi za vaporea i Gezironi, ko i Gezironi za vaporea i Rami. ");
INSERT INTO ghn_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","I Rami za vaporea i Aminadabi, i Aminadabi za vaporea i Nasoni, ko i Nasoni za vaporea i Salamoni. ");
INSERT INTO ghn_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","I Salamoni za vaporeni ti Regabi i Boazi, ko i Boazi za vaporeni ti Ruti i Obedi, ko i Obedi za vaporea i Jese, ");
INSERT INTO ghn_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ko i Jese za vaporea i Devita na bangara. Ko i Devita za vaporeni tana maqotana i Uria i Solomone. ");
INSERT INTO ghn_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","I Solomone za vaporea i Roboama, i Roboama za vaporea i Abija, ko i Abia za vaporea i Asa. ");
INSERT INTO ghn_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","I Asa za vaporea i Josapati, i Josapati za vaporea i Jorama, ko i Jorama za vaporea i Uzia. ");
INSERT INTO ghn_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","I Uzia za vaporea i Jotama, i Jotama za vaporea i Agazi, ko i Agazi za vaporea i Gezekae. ");
INSERT INTO ghn_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","I Gezekae za vaporea i Manase, i Manase za vaporea i Amoni, ko i Amoni za vaporea i Josia. ");
INSERT INTO ghn_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","I Josia za vaporea i Jekonia beto ria na taina marene, totonai qari taraputu lao pa Babiloni ria na tinoni Izireli. ");
INSERT INTO ghn_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pa liguna qari taraputu lao pa Babiloni ria na tinoni Izireli za i Jekonia za vaporea i Salatieli, ko i Salatieli za vaporea i Zorobabele. ");
INSERT INTO ghn_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","I Zorobabele za vaporea i Abiuda, i Abiuda za vaporea i Eliakimi, ko i Eliakimi za vaporea i Azoa. ");
INSERT INTO ghn_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","I Azoa za vaporea i Zadoki, i Zadoki za vaporea i Akimi, ko i Akimi za vaporea i Eliuda. ");
INSERT INTO ghn_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","I Eliuda za vaporea i Elieza, i Elieza za vaporea i Matani, ko i Matani za vaporea i Jekopi. ");
INSERT INTO ghn_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","I Jekopi za vaporea i Josepa na marenena i Mere, ko ti Mere za podo vei i Jisu aza za tagigala na Karisito. ");
INSERT INTO ghn_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ko na ngutidi ria doru podopodo zazae tinoni podalai ti Ebarahami ko za lame kamu ti Devita za ka manogamade podopodo, ria za podalai ti Devita ko za lame kamu totonai qari taraputu lao pa Babiloni ria na tinoni Izireli za ka manogamade podopodo, beto za koko totonai qari taraputu lao pa Babiloni ko za lame kamu tana Karisito za ka manogamade podopodo. ");
INSERT INTO ghn_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ego ari za vei za na vavakatona na podona i Jisu Karisito. I Mere, aza na tinana i Jisu, za perangaina tu za tavatiolata vakole vani i Josepa. Ba totonai qari oqoro makarai suvere varikamu ari kori, i Mere za tori vaporeni iapana tu na Ongu Tabuna. ");
INSERT INTO ghn_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","I Josepa na marenena ani za maka tinoni tuvizina aza. Ko zake nyorogua vavotuni vavakato varivakeana aza i Mere, ko za roquroqua ko bi koroto golomo paleni aza i Mere za gua. ");
INSERT INTO ghn_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ba totonai za korapa roverove vei zara i Josepa, za ani za votu tana pa putagita za maka mateana tana Bangara, ko ari za guni vei, <<Josepa, tuna i Devita! Muke matagutu tekua ao i Mere ko mi maqotamu, ura aza za pidoko pa iapana aza za na Ongu Tabuna tu za veini. ");
INSERT INTO ghn_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Pala mina vapodoa aza za maka koburu marene, ko muna vakukuni ao nizongona i Jisu aza, ura aza pala mina aloria pa dia sela ria na nana tinoni,>> za gua za na mateana. ");
INSERT INTO ghn_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ego doru zakazava ari za qari taroiti ko qari vagore votua za na paranga perangaina tu za pojai na Bangara tana tinoni korokorotai i Aisea, ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","<<Vainongoro! Maka reko koregana mina pore iapana ko mina vapodoa maka koburu marene, ko na izongona mari vakukuni i Imanuela,>> za gua. Na ginuana na paranga Imanuela za Na Tamaza za suvere tavitigita. ");
INSERT INTO ghn_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pa liguna na putagita za iqolo i Josepa ko za roitini aza vei za garununi na mateana tana Bangara ko za tekua aza i Mere ko na maqotana. ");
INSERT INTO ghn_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ko zake puta tavitia i Josepa i Mere tinganai za vapodoa tu aza na tuna marene. Ko za vakukuni i Jisu aza na izongona. ");
INSERT INTO ghn_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ego totonai za podo i Jisu pa Betilihema pa Jiudia, aza na totozo za bangara i Herodi, ari kaki tinoni gigigalai qari taloi koko vei pa kale zagere tapo ko qari bola pa Jerusalema, ");
INSERT INTO ghn_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ko qari nanaza, ari qari gua vei, <<Ae za na koburu za podo bangara tadiria na Jiu? Gami nanaza ura gami batia pa kale zagere tapo gami za na seru tana, ko gami kamu ko mami vatarazaea aza gami gua,>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ego totonai za nongoria i Herodi na bangara za na veveina aza, za takulanga aza beto ria dorudi pa Jerusalema. ");
INSERT INTO ghn_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ko za kuku varikamudi i Herodi ria na kuta iama beto ria na tinoni varivagigalai tadiria na tinoni, ko za nanazaria, <<Pae mina podo za na Karisito?>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nari za ari qari guni vei, <<Pa Betilihema pa Jiudia, ura ani za korotoni na tinoni korokorotai, ");
INSERT INTO ghn_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","<Ao Betilihema pa ia pa Jiudia. Ao nake goboromu tadiria na guguzu matamata pa Jiudia, ura tamu mina votu lame vei za maka matamata aza mina pauzuria ria na qua tinoni Izireli,> za gua,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nari za kuku kaledi i Herodi ria na tinoni gigigalai, ko za nyaqo votuni tadiria za na totozo za bola votu na seru. ");
INSERT INTO ghn_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Beto za garunu goredi pa Betilihema, ari za gudi vei, <<Mu gore nyaqo votu valeania gamu za na veveina na koburu. Ko aza tugu muna batia, za muna ule vaniziu, ko ara ba mana somana gore vatarazaea tugu vei,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pa liguna qari nongoria na bangara nari za qari taloi keni ria na tinoni gigigalai ari. Ko ani aza na seru, aza qari batini pa kale zagere tapo perangaina, za tokaria, ko tinganai za lao vanogoto pa narena totona ketakoi za kole na koburu. ");
INSERT INTO ghn_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ko totonai qari batia na seru za qari qera vitivitigi. ");
INSERT INTO ghn_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ko qari luge lao pa ruma nari za qari batia za na koburu beto i Mere na tinana. Ko qari gona nyumu sori tungutungu ko qari vatarazaea za na koburu, beto za qari raua ria na dia baeke varivana ko qari vani na qolo, na parakenisenisi beto na moa za na koburu. ");
INSERT INTO ghn_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Beto za votudi pana putagita za na ule vabalau ko marike mule zae ti Herodi za gua, ko qari tutia na goto zona tu ko qari mule kenidia pa dia guguzu ria na tinoni gigigalai. ");
INSERT INTO ghn_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ego pa liguna qari taloi kenidia ria na tinoni gigigalai ari, nari ani za votu ti Josepa pa putagita za na mateana tana Bangara, ko ari za guni vei, <<Mu turu, mu tokai za na koburu beto na tinana ko mu uku keni pa Ijipi, ko mu suvere ketakoi tinganai mana parangaigo mule ara. Ura i Herodi za mi nyaqoa za na koburu zana ko mi vaukea za gua,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nari za turu i Josepa, za tokai za na koburu beto na tinana na bongina tugu aza, ko za taloi keninana pa Ijipi. ");
INSERT INTO ghn_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ko za suvere ketakoi aza ko tinganai za uke tu i Herodi. Ko za gore votu za na paranga za pojai na Bangara tana tinoni korokorotai, ari za gua vei, <<Pa Ijipi qa kuku votuni ara za na tuqu marene,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ego totonai za gilagilai i Herodi za ria na tinoni gigigalai za qari vagonai gu aza, za za tagigiri vikevikereni. Ko za varigarunu ko mari vai vauke paledi ria doru koburu marene pa Betilihema beto pa guguguzu varilivutaina, ria koburu kori aorodi ko mi gore tadiria na melalu za gua. Na ngutina na aorodi ria na koburu za padani aza podalai tugu na totozo za nyaqo votuni aza tadiria na tinoni gigigalai. ");
INSERT INTO ghn_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ko za gore votu za na paranga za lame vei ti Jeremae na tinoni korokorotai, ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","<<Maka mamalaingi za tanongoro pa Rama, na lukana uui beto na kebokebo. I Resolo za lukanaria na tuna, ko za dainana tavamanoto ura qari manyao ria,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ego ko pa liguna za uke i Herodi, za ani na mateana tana Bangara za votu pa putagita ti Josepa pa Ijipi, ");
INSERT INTO ghn_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ari za gua vei, <<Mu turu, mu tokai za na koburu beto na tinana ko mu mule pa pezo pa Izireli, ura qari tori uke tu ria qari nyaqoa na toa tana koburu,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nari za turu i Josepa, za tokai za na koburu beto na tinana ko za mule pa pezo Izireli. ");
INSERT INTO ghn_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ba tonai za nongoroni i Josepa za i Akiliasi za sogai i Herodi na tamana ko za bangara pa Jiudia qari gua, za matagutu mule suvere ketakoi aza. Ko tonai za votu pa putagita za na ule vabalau nari za taloi keni vei pa pikata guguguzu pa Qalili tu. ");
INSERT INTO ghn_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ko za zae suvere pa guguzu na izongona pa Nazareti. Ko za gore votu za na paranga za gore vei tadiria na tinoni korokorotai, ari qari gua vei, <<Mina tagigala na tinoni Nazareti aza,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ego ko pana rane ria za votu lame i Jone Paputaiso, ko za podalai tarae pa qega pa Jiudia, ");
INSERT INTO ghn_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ari za gua vei, <<Mu gabala gamu! Ura mi toga za gua za na binangara pa noka,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","I Jone tugu ani za korotoni i Aisea na tinoni korokorotai, tonai ari za gua vei, <<Maka mamalaingi za velavela pa qega, ari za gua vei: <Vatanani na zona tana Bangara! Vaemeseria na zona mina reregeria aza,> za gua,>> za gua i Aisea. ");
INSERT INTO ghn_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ego ko i Jone na nana poko za na vurungudi gu na kameli, na nana doko za na kopo vulitini manugu mademade nenedi gu, beto na nana tekutekuna za na kupo beto na muji pirudi gu. ");
INSERT INTO ghn_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ko qari kamu tana ria pa Jerusalema, ria doru pa Jiudia beto ko ria doru pa varilivutaina pa pie Jodani. ");
INSERT INTO ghn_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ko qari ule votudi na dia sela beto i Jone za paputaisoria pa pie Jodani. ");
INSERT INTO ghn_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ba totonai za batiria i Jone za na motadi ria na Parese na Sadusisi za qari lame ko mi paputaisoria aza qari gua, nari ari za gudi vei aza ria, <<Boko tuni dole ikikeremiu! I zei za pojadigamu za pala muna boka ukuni gamu na vinakilasa za korapa jojoro lame? ");
INSERT INTO ghn_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mu roiti votudi ria na vua qari uleni na toa gabalana. ");
INSERT INTO ghn_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Keta mu rove sianani za na tamamami gami i Ebarahami keta mu gua. Ma pojadigamu gu ara za na Tamaza za boka gu pelukudi na tuna i Ebarahami ria na patu ari! ");
INSERT INTO ghn_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Na rio za tori tana kolenana tu pa bageredi na suvege. Ko doru suvege qarike vuani na vua leana za mari taduka vagore ko mari tagona lao pale pa iku. ");
INSERT INTO ghn_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ara za qa paputaisodigamu na kolo ko na vagilagilana na toa gabalana, ba aza tu za tuti ligu lameziu ara za poreveveina jolaniziu ara, ko ara ba nake padaqu mana pogozo vani na sadolo aza. Aza tu za mina paputaisodigamu na Ongu Tabuna beto na iku. ");
INSERT INTO ghn_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Na sevolo varivaripikatai za tori aruni tu pa limana ko mi pikata paledi za gua ria na kopo ikika pa ia iru varipikapikatadi ria na kiko, ko mi boko varikamudi pa ia vavakoleni kiko ria na kiko leadi beto mi vurungu paledi pa iku ilili ikerena ria na nyanyaodi na kiko za gua,>> za gua i Jone. ");
INSERT INTO ghn_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ego za kamu koko pa Qalili i Jisu ko za gore pa pie Jodani ko mi tapaputaiso ti Jone za gua. ");
INSERT INTO ghn_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ba i Jone za podeke vanogotia aza, ari za guni vei, <<Ara tu za na selaqu ko muna paputaisoziu ao, ba ae za vei za ao tu qu lame taqu?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ba za oe laoa i Jisu aza, <<Loia ko mi vei koviria, ura pa zona vei ani tana vagore votua gita za doru tuvizi,>> za gua aza. Nari za vazotoa i Jone aza. ");
INSERT INTO ghn_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ko aza tugu za tapaputaiso ko za iolo loia na pie i Jisu, za ani za tarevanga vani aza za na oka, ko za batia aza za na Ongonguna na Tamaza za tigoro gore lagere vei maka kuru ko za lagere togai aza. ");
INSERT INTO ghn_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Beto za maka mamalaingi za koko lagere vei pa noka, ari za gua vei, <<Ani za na tuqu qa roquroqua aral; aza qa qera vitivitigini ara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ego pa liguna aza za toka zaeni pa qega na Ongu Tabuna i Jisu ko mi toketokea na bangaradi na tomete za gua. ");
INSERT INTO ghn_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ko za tabutabu ganigani ka madengavuluputa ranena beto madengavuluputa bongina aza, ko za burana. ");
INSERT INTO ghn_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ko totonai za kamu za na bangara toketoke, ko ari za guni vei aza, <<Vei muna na Tuna na Tamaza ao, za mu parangaria na patu ari ko mari peluku bereti,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ba za oea i Jisu aza, ari za gua vei, <<Za paranga za na Kutikuti Tabuna, <Nake bereti gu makana za toani za na tinoni, goto doru paranga tu za parangadi na Tamaza!> za gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ego beto za toka laoni na bangaradi na tomete pa guguzu tabuna pa Jerusalema i Jisu, ko za vaturua pa are babanana na kakabarena na zelepade, beto ari za guni vei, ");
INSERT INTO ghn_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","<<Vei muna na Tuna na Tamaza ao, za mu soqolo gore! Ura ari za gua vei za na Kutikuti Tabuna, <Aza mina garununigo ria na nana mateana ao, ko mari kalonigo na limadi, ko na nenemu minake tupani pa patu,'> za gua,>> za gua na bangaradi na tomete. ");
INSERT INTO ghn_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nari za oea i Jisu za na bangaradi na tomete, ari za guni vei, <<Ari mutu za gua vei za na Kutikuti Tabuna, <Muke podekia na Bangara na mua Tamaza!> za gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nari za toka zaeni mule na bangaradi na tomete pa maka kubo ululuna i Jisu, ko za vabatini doru binangara pa kasia guguzu beto na dia neqi lavalavatadi. ");
INSERT INTO ghn_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Beto ari za guni vei i Jisu, <<Dorudi ari za ao mana vanigo, vei muna lotu gore ko muna vatarazaeziu ara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nari za oea i Jisu aza, <<Mu keni vazou, Setani! Ura ari tu za gua vei za na Kutikuti Tabuna, <Na Bangara na mua Tamaza gu mu vatarazaea, beto aza gu makana mu nabuluni!'> za gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nari za taloi keni za na bangaradi na tomete, ko ani ria na mateana qari kamu ko qari tokani i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ego totonai za nongoroni za i Jone za qari tori valugea tu pa ruma varipiu qari gua, nari za taloi keni veinana pa Qalili i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ko za iolo loia za pa Nazareti ko za gore suvere vei pa Kepaniami pa keketai ovuku pa Qalili, pa pikata ia pa Zabuloni beto pa Naputalai. ");
INSERT INTO ghn_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ko za gore votu za na paranga za pojai i Aisea na tinoni korokorotai, ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","<<Na pezo Zabuloni beto na pezo Naputalai, na zona vei pa ovuku, pa karovona pa pie Jodani, pa Qalili tadiria na tinoni karovodi. ");
INSERT INTO ghn_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ria na tinoni qari suvere pa rodomo qari batia maka kabere lavatana. Ria qari suveria na ia za angovia na ongongu uke za goreria na kabere,>> za gua i Aisea. ");
INSERT INTO ghn_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Podalai na totozo aza za podalai tarae i Jisu, ari za gua vei, <<Mu gabala gamu! Ura mi togagita gu za gua za na binangara pa noka!>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tonai za korapa popoananana pa ovuku Qalili i Jisu, nari za batiria ari kori tamatazi ari Saimone aza za tavaizongo i Pita beto i Aduru na taina. Qari korapa vaqaradia pa ovuku, ura na tinoni abu ari kori. ");
INSERT INTO ghn_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ko ari za gudi vei i Jisu ari kori, <<Mae, lame! Tutiziu, ko ma roitidigamu na tinoni abu tinoni,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Na totozo tugu aza qari loi paledi ketakoi ari kori za na dia vaqara, ko qari lao tutiadia i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ego ko za jola lao nari za batiria gu mule i Jisu ari kori goto tamatazi, ari Jekopi beto i Jone, kori tuna marene i Jebeti. Qari korapa tugu zae tavitia pa koaka za na tamadi i Jebeti, ko qari korapa oke tuvakaria na dia vaqara, nari za kukuria i Jisu ari kori tamatazi ria. ");
INSERT INTO ghn_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Na totozo tugu aza za qari loi paledi ari kori za na dia koaka beto na tamadi, ko qari lao tutiadia i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ego ko za lekoria i Jisu za doru ia pa Qalili, ko za kole varivagigalai pa dia ruma varivarikamudi, za taraeni na nongoro leana na binangara tana Tamaza beto za salana paledi aza ria doru mo beto na vagauru qari koleria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ko na nongorona i Jisu za lekoia na doru ia pa Siria. Ko qari toka kamudi tana ria doru za koleria na okokoto mo vagauru, ria qari gozororia na vitigi lavalavata, ria za lugeria na tomete ikikeredi, ria qari kirekirenge, beto ria za uke kale na kobukobu tinidi. Ko za salana betoria i Jisu ria doru. ");
INSERT INTO ghn_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ko qari tutia i Jisu za ria na minete lavata koko veidi pa Qalili, pa Manogaguguzu, pa Jerusalema, pa Jiudia, beto ria pa maka karovona Jodani. ");
INSERT INTO ghn_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Totonai za batiria i Jisu ria na minete tinoni, nari za keza zae pa kubokubona. Ko totonai za nyumu aza nari za qari lame varivarikamu tana ria na nana sepele. ");
INSERT INTO ghn_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nari za podalai vagigalairia aza ria, ari za gua vei: ");
INSERT INTO ghn_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","<<Qari tamana ria qari golaba pa ongongu, ura tadiria za na binangara pa noka. ");
INSERT INTO ghn_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Qari tamana ria qari takulanga, ura mari tavamanoto ria. ");
INSERT INTO ghn_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Qari tamana ria qarike tuara, ura ria mari teku izongia na kasia abana. ");
INSERT INTO ghn_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Qari tamana ria qari burana kidepeni na tuvizi, ura ria mari pote valeana. ");
INSERT INTO ghn_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Qari tamana ria qari variroqu varitokai, ura ria mari taiani na variroqu varitokai. ");
INSERT INTO ghn_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Qari tamana ria za lioso na bulodi, ura ria mari batia na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Qari tamana ria na tinoni varivabule, ura ria mari tapoja na tuna na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Qari tamana ria qari takomitini na tuvizi, ura tadiria za na binangara pa noka. ");
INSERT INTO ghn_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Gamu tamana za gamu tonai qari poja vikevikeregamu, qari komitigamu beto qari jutu sekeseke taridigamu doru maka ikerena pana laequ ara. ");
INSERT INTO ghn_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mu qera ko mu qera vitivitigi tu, ura na miu pinia pa noka za lavata jola. Ura ria na tinoni korokorotai pa moa ba qari komiti veidi tugu zara,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","<<Gamu za na solona na kasia abana. Ba totonai mina maragutu na lingilingina za na solo, nari za ae mule mina vei beto mina boka lingilingi solo ligu aza? Totonai za kepore veveina aza, goto na padana za mina tagona votu pale gu pa peguru, ko mari tete anyanyuni gu na tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Gamu za na kaberena na kasia guguzu. Na guguzu za nyumu pa batuna na kubo za zake boka pae. ");
INSERT INTO ghn_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kepore za maka tinoni za vatoaia na juke beto za vanyumu pale pa kauru kadikita. Goto za vaturua tu pa nyumunyumuna juke aza za na juke, ko za tolanga vadi ria doru pa leo ruma. ");
INSERT INTO ghn_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ko gamu ba mi tolanga valeana tu za na miu kabere ko ria na tinoni mari batiria na miu roiti leadi, ko mari vatarazaea za na Tamamiu pa noka,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","<<Keta mu roquroqua gamu za ara qa lame ko ma jegaria za na Vavanau ti Mosese babi na varivagigalai tadiria na tinoni korokorotai qa gua keta mu gua. Ara qake lame ko ma jegajegara goto ma vavaokoto tu qa gua. ");
INSERT INTO ghn_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ura ma pojadigamu zozoto ara za gamu: tinganai mina maragutu za na oka beto na pezo, za bi mija tu mina murimuri pa Vavanau za maka leta peki babi gaji peki, tinganai mari gore votu beto mae tu doru zakazava. ");
INSERT INTO ghn_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ko za vei za na tinoni za vakeporea maka ria na kobu garunu peki ari beto za vagigalaidi ria na goto tinoni ko mari veinidi tugu aza, za mina tapoja na tinoni kepore veveina pa binangara pa noka za na tinoni aza. Goto na tinoni za vataberia beto za varivagigalaidi, za mina tapoja na tinoni poreveveina pa binangara pa noka aza. ");
INSERT INTO ghn_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ma pojadigamu ara za gamu: vei na miu tuvizi minake pugele nyonyoa jolani na tuvizi tadiria qari varivagigalaini na Vavanau beto na Parese, nari za munake izongo boka lugea gamu za na binangara pa noka,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","<<Gamu tori nongoronimiu tugu gamu za aza ari za gua vei perangaina tadiria pa moa, <Munake varivai, beto ko aza za varivai za pala mina gozoria na varituti,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ba ara ma pojadigamu gamu: na tinoni za korakorani na taina za mina gozoria na varituti. Aza ari bi guni vei na taina, <Ao batu kovekove,> bi guni, za mina lao pa koti tadiria na tinoni Jiu. Aza ari bi gua vei, <Ao na duviduvili,> bi gua, za mina lao pa iku pa heli. ");
INSERT INTO ghn_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ko za vei za vei bu korapa varivanani pa ia vavavuina ao za na mua varivana nari za ketakoi tu za bu roquroqu kamua ao za maka sela qu roitini ao tana taimu, ");
INSERT INTO ghn_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nari za mu loi vakolea ketakoi pa moena na ia vavavuina za na mua varivana ko mu mule keni bulea mae za na taimu beto za mu lao varivanani za na mua varivana. ");
INSERT INTO ghn_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mu siqarai bulea na mua kana totonai gamu korapa lalaomiu pa zona, keta na mua kana mi valaogo tana tinoni varituti, ko na tinoni varituti mi valaogo tana na nabulu kopu, ko aza mi gona lugenigo pa ruma varipiu. ");
INSERT INTO ghn_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ma poja zozotonigo ara ao: pala munake izongo votu taloi ketakoi ao tinganai muna lipu vaokotia na poata betobetona,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","<<Gamu tori nongoronimiu tu gamu za aza ari za gua vei perangaina, <Munake barabarata,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ba ara ma pojadigamu gamu: na tinoni za dogodogoro nyoroguani gu za maka reko tiolata, za tori baratia tugu pa bulona aza. ");
INSERT INTO ghn_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ko vei na mata kale matuamu ao za bi valotugo, za mu ujolia ko mu gona paleni. Ura vei maka kobu tinimu ao za bi takobu pale za aza za leana jolani na tini dorumu ao bi tagona lao pa heli. ");
INSERT INTO ghn_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Beto vei na lima kale matuamu ao za bi valotugo ao, za mu kobua ko mu gona paleni. Ura vei maka kobu tinimu ao za bi takobu pale za aza za leana jolani na tini dorumu ao bi tagona lao pa heli,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","<<Ego ari za gua vei perangaina, <Aza za mi loi pale na maqotana za gua za mi vani na pepa variloi za na maqotana,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ba ara ma pojadigamu: na tinoni zake variputa taviti goboro na maqotana ba za loi pale goboro, za vabarabaratia za na reko ani beto na marene za nagoa na reko za taloi pale ani ba za barabarata tugu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","<<Gamu tori nongoronimiu mutugu gamu za aza ari za gua vei perangaina, <Munake tetea na mua maulu, goto muna vagore votua za aza qu maulu laoni tana Bangara,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ba ara ma pojadigamu: muke izongo maulu totonai mu roitini maka taringutinguti. Muke maulu lao pa noka, ura aza na nana nyumunyumuna bangara na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Muke maulu lao pa pezo, ura aza za na nana tetetena na nenena aza. Muke maulu lao pa Jerusalema, ura aza na guguzu tana Bangara lavata. ");
INSERT INTO ghn_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Beto muke maulu lao pa batumu, ura maka galu vurungumu gu ba quke boka vakekai babi vakudekudea. ");
INSERT INTO ghn_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Goto na miu paranga za mi E gu tonai mi E beto mi Dai gu tonai mi Dai. Goto vei kaki paranga mule muna jokadi, nari za ria na koko veidi gu tana kutana nikerena ria,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","<<Gamu tori nongoronimiu tugu gamu za aza ari za gua vei perangaina, <Aza za vapalekaia na matamu za mu vapalekaia na matana, beto aza za valovea na mua patu za mu valovea na nana patu,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ba ara ma pojadigamu: muke raja sogani ikerena za na ikerena. Goto bi poaria maka tinoni na papara kale matuamu, za mu balinga lao vani mule keta pa kale merimu ao. ");
INSERT INTO ghn_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Vei bi nyorogua toka lao rajanigo pa varituti za maka tinoni ko mi teku vakeninigo na mua soti bi gua, za mu vamalumu vani tugu vei na mua koti ao. ");
INSERT INTO ghn_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Vei maka tinoni bi jujukigo ko mu pogozo vani maka maelo bi gunigo, za mu tuti pogozo vani kori maelo tu ao. ");
INSERT INTO ghn_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Na tinoni za tepago za mu vani, beto na tinoni za nyorogua teku gu maqalai tamu bi gua za muke uku peleni tu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","<<Gamu tori nongoronimiu tu gamu za ari za gua vei perangaina: <Muna roquroqua na tavitimu, beto munake tavaragauni na mua kana,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ba ara ma pojadigamu gamu: mu roquroquria ria na miu kana beto mu varavara tokadi ria qari komitigamu, ");
INSERT INTO ghn_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ko mu tuna na Tamamiu pa noka za gamu ura aza na nana tapo za vaalangadi ria na tinoni ikeredi beto na tuvizidi beto na okoro za vagoredi ria tinoni na leadi beto ria na seladi. ");
INSERT INTO ghn_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ura vei ria gu qari roquroqugamu za muna roquroquria gamu, nari na pinia za muna tekua? Ria gu na tinoni tekuteku takisi ba qari bokadia roitini aza. ");
INSERT INTO ghn_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Beto vei muna gozoro qeraqeraniria ria na miu baere gu gamu, nari za gamu oqoro roitini maka za bi goto za gamu. Ria gu na tinoni rodomo ba qari bokadia roitini aza. ");
INSERT INTO ghn_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ko gamu za mi maladoruru na miu variroqu vei tugu na Tamamiu pa noka ba za maladoruru na nana variroqu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","<<Mu kopuni na miu roiti tuvizina ko muke roitini pa moedi ria na tinoni ko mu vadogorodi gu ria. Vei muna vei aza gamu, nari za mina kepore maka pinia muna tekua tana Tamamiu pa noka gamu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","<<Ego tonai muna roitini ao za maka variia tokani na tinoni varivasevina za muke kuvikuvilini pa moemu. Aza qari roroiti vei pa leo ruma varivarikamuna beto pa zona lavata ria na tinoni vavabatadi, ko mari vatarazaeria na tinoni qari gua. Ma poja zozotodigamu ara za gamu: ria za qari tori tekua tu na dia pinia. ");
INSERT INTO ghn_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Goto ao tonai mu roitini za maka variia tokani na tinoni varivasevina nari za muke vagilagilani na lima kale merimu za aza za roitini na lima kale matuamu, ");
INSERT INTO ghn_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ko na mua variia tokani na tinoni varivasevina za mi taroiti pa paena. Ko na Tamamu za batia aza qu roitini pa paena za mina vanigo na pinia,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","<<Ego tonai muna varavara za gamu, za muke vei ria na tinoni vavabatadi! Ura ria za qari nyonyorogua turu varavara pa leo ruma varivarikamuna beto pa varikae zona ko mari batiria na tinoni qari gua. Ma poja zozotodigamu ara za gamu: ria za qari tori tekua tu na dia pinia. ");
INSERT INTO ghn_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Goto ao tonai mu varavara, za mu luge lao pa mua lose, mu patea na mua akatamana beto mu varavara lao tana Tamamu za suvere pa paena. Ko na Tamamu aza za batia na roiti qu roitini pa paena za mina vanigo na pinia. ");
INSERT INTO ghn_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ko tonai mu varavara gamu za muke varisomanaidi kubo paranga qari vevei ria na tinoni rodomo, ura qari roquroqua ria za za zoku valeana na dia paranga ko pala mina nongororia na Tamaza qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Muke dogoro tutiria ria, ura na Tamamiu za totonai tu qu oqoro tepai za tori gilagilarianana tu aza ria gamu qasadi. ");
INSERT INTO ghn_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ko gamu za ari mu varavara vei: <Tamamami, ao pa noka, mi tapangaga na izongomu. ");
INSERT INTO ghn_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mu valamea na mua binangara. Mu vagore votua na mua nyorogua, aza za vevei pa noka za mu veini pa pezo. ");
INSERT INTO ghn_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mu vadigami na tekutekuna mami toani pa ngenari. ");
INSERT INTO ghn_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mu taleozodigami ria na mami sela, vevei gami gami taleozodi ria qari roiti lame sela tadigami. ");
INSERT INTO ghn_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Muke toka laodigami pa toketoke, goto mu vasaregami tana kutana nikerena,> mu gua. ");
INSERT INTO ghn_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ura vei muna taleozodi gamu ria na sela qari roiti lamedi ria na tinoni tadigamu, nari za na Tamamiu pa noka ba mina taleozodigamu tugu za gamu. ");
INSERT INTO ghn_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Goto vei munake taleozodi gamu ria na tinoni, nari za na Tamamiu ba minake taleozodigamu tugu na miu sela za gamu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","<<Ego tonai muna tabutabu ganigani za gamu, za muke vadogoro takulanga veidigamu ria na tinoni vavabatadi. Ria za qari vadogoro batikeria na izumatadi ko ria na tinoni mari batiria qari korapa tabutabu ganigani ria mari gudi qari gua. Ara ma poja zozotodigamu gamu: ria za qari tori tekua tu na dia pinia. ");
INSERT INTO ghn_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Goto ao za tonai qu tabutabu ganigani, za mu lumu valeania na batumu beto mu subi valeania na izumatamu. ");
INSERT INTO ghn_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ko ria na tinoni marike dogoro gilagilai za ao qu korapa tabutabu ganigani, goto na Tamamu gu pa paena za mi gilagilai. Ko na Tamamu aza za batiria na mua roiti qu roitidi pa paena za mina vanigo na pinia,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","<<Muke boko varikamumiu izizongo pa pezo ketakoi za boka gani piararia na tamo beto na obu, beto ketakoi qari boka pipiara luge ikoria ria na tinoni ikikodi. ");
INSERT INTO ghn_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Goto mu boko varivarikamumiu izizongo pa noka tu ketakoi qarike boka gani piararia na tamo beto na obu, beto ketakoi qarike boka pipiara luge ikoria ria na tinoni ikikodi. ");
INSERT INTO ghn_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ura ketakoi qari kole na mua izizongo za ketakoi tugu za kole za na bulomu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","<<Na jukena na tini za na mata. Ko vei mina leana za na matamu, nari za na tinimu doruna pala mina tolangani na kabere. ");
INSERT INTO ghn_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Goto vei mina ikere za na matamu, za na tinimu doruna pala mina rodomo. Ko vei na kabere za kole tamu za na rodomo gu, nari za pala mina rodomo kunikuni aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","<<Kepore za maka tinoni mina makarai nabuludi kori bangara. Maka za minake tavaraguani goto maka za mina roquroqua, babi maka pala mina valavatia goto maka za mina dogoro pale. Ko munake boka makarai nabuludi gamu za na Tamaza beto na izizongo. ");
INSERT INTO ghn_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ko za vei za ma pojadigamu: muke takulangani na miu toa, na za muna gania, na za muna bukua, babi na za muna pokoni na tinimiu. Na toa tu za poreveveina jolani na ganigani, beto na tini tu za poreveveina jolani na poko. ");
INSERT INTO ghn_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mu dogororia tu gamu ria na manugu pa vavagalo kota: ria za qarike umuma, qarike ababu, beto qarike aqaqono varikamu pa ruma, ba na Tamamiu pa noka za vatekutekuria gu ria. Ba gamu tu za gamu poreveveina joladi na manugu. ");
INSERT INTO ghn_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","I zei gamu za tonai za kole takulanga nari za tori boka vakakazia mae tu iapeki za na nana toa? Bi mija tugu! ");
INSERT INTO ghn_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ko ae za vei gamu takulangani tu gamu za na veveina na poko? Mu dogororia tu gamu ria na gavoro beto ae qari vei qari toa ko. Ria za qarike pavu talea na roiti beto qarike pitipitidia poko. ");
INSERT INTO ghn_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ba ma pojadigamu ara gamu: doru poko batabata leadi ti Solomone qarike kamua na batabata leana maka gavoro ani. ");
INSERT INTO ghn_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ko na gavoro gu za toa pa ngenari beto uka za ukenana ko za tagona lao pale pa iku vavavatununa ba na Tamaza za vapokopoko vabatabata leania tu. Ba gamu tu za gamu poreveveina joladi na gavoro. Za beko peki na miu rangerange! ");
INSERT INTO ghn_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ko muke takulangani za: <Na za tana gania?> babi <Na za tana bukua?> babi <Na za tana pokopokoni?> muke gua. ");
INSERT INTO ghn_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ura doru zakazava vevei ari za ria gu na tinoni rodomo qari kole nyaqo tokatokaria. Goto gamu za na Tamamiu pa noka za tori gilagilarianana tu za qari poreveveina muna toadi gamu za doru zakaza ari. ");
INSERT INTO ghn_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Goto mu nyaqo momoea za na binangara tana Tamaza beto na nana tuvizi, beto aza mina tamo vadigamu ria doru zakazava vevei ari. ");
INSERT INTO ghn_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ko muke takulangani za uka, ura uka za mina takulangani makana. Ria doru rane qari okoto pogozoria makadi za na dia tapata,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","<<Gamu muke pitua na goto tinoni, ko gamu ba muke tapitu makamiu. ");
INSERT INTO ghn_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ura aza tugu na zona gamu pituni na goto tinoni za aza tugu za na zona muna tapituni gamu. Beto aza tugu na pada gamu padadi ria na goto tinoni, za aza tugu za muna tapadani gamu. ");
INSERT INTO ghn_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ae za vei ko qu tapatiana dogoria tu ao za na opopu pa matana na taimu, ba na lomoto kobukobu pa matamu za quke pavu galani? ");
INSERT INTO ghn_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ae za vei ko ari tu qu guni vei ao za na taimu, <Mae ko ma kazi pale na opopu pa matamu,> qu gua? Ba dotu! Na lomoto kobukobu pa matamu! ");
INSERT INTO ghn_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ao na tinoni sekesekemu na vavabatamu ao! Momoe za mu kazi pale mae tu na lomoto kobukobu pa matamu, beto za pala muna batabata valeana ao ko muna boka kazi pale ao za na opopu pa matana na taimu. ");
INSERT INTO ghn_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Muke gona vadi na zakazava madidi ria na sie, ura pala mari gabala mule garatagamu gu. Beto ko muke gona vadi na miu patu poreveveidi ria na borogo, ura pala mari tete anyanyudi gu pa pezo,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","<<Gamu mu tepa ko mu tekua, mu nyaqo ko mu batia, mu kikia ko mi tarevanga vadigamu. ");
INSERT INTO ghn_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ura na tinoni za tepa za tekua, na tinoni za nyaqo za batia, beto na tinoni za kikia za tarevanga vani. ");
INSERT INTO ghn_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","I zei na tinoni gamu, za totonai za tepagana meme na tuna, nari na patu doa tu za vani? ");
INSERT INTO ghn_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ba bi tepagana igana aza, nari na dole tu za vani? ");
INSERT INTO ghn_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ko vei gamu na tinoni ikikeremiu gu ba gamu bokamiu iadi na zakazava leadi ria na tumiu, nari za na Tamamiu pa noka za za leana joladigamu ko aza mina iadi na zakazava leana joladi ria ria qari tepani aza! ");
INSERT INTO ghn_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ko doruna gamu nyoroguani ko mari roiti lameni tadigamu ria na tinoni, za ria tugu za mu roiti laodi tadiria na tinoni. Ura ani gu za na Vavanau ti Mosese beto na varivagigalai tadiria na tinoni korokorotai,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","<<Mu luge laoa na atakamana ngijupuna gamu, ura na atakamana lugelugena lao vei pa vinakilasa za za revata beto na zona laona za za kabekabere ko ria na zoku tinoni qari lugea. ");
INSERT INTO ghn_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Goto na atakamana lugelugena lao pa toa za ngijupu beto na zona laona za karajutu, ko ari ka vizaviza gu qari batia aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","<<Mu balaudi ria na tinoni korokorotai sekesekedi. Qari lame tadigamu pokopoko vei na sipi siranadi, ba na galegale vulupu pirudi ria. ");
INSERT INTO ghn_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pa vuadi pala muna dogoro gigaladi ria. Ae vei na tinoni qari lokete vungu qurepi pa gazoro livolivo eoro? Babi qari boka lokete vua piqi pa buruburu varivarioka? ");
INSERT INTO ghn_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Za varitoto vei aza za na suvege leana za vuadi na vua leadi, goto na suvege ikerena za vuadi na vua ikeredi. ");
INSERT INTO ghn_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Na suvege leana zake boka vuadi na vua ikeredi, beto na suvege ikerena ba zake boka vuadi na vua leadi. ");
INSERT INTO ghn_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na suvege zake vuani na vua leana za tario pale ko za tagona lao pale pa iku. ");
INSERT INTO ghn_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ko za vei za pa vuadi muna gigaladi ria,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","<<Nake ria doru qari kukukuniziu, <Bangara, Bangara,> za mari lugea na binangara pa noka, goto ria gu qari roitini na nyorogua tana Tamaqu pa noka. ");
INSERT INTO ghn_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tonai mina kamu za na rane varituti, za pala kubo tinoni za ari mariguniziu vei ara, <Bangara, Bangara, pa izongomu ao gami ulule votuni gami za na paranga, pa izongomu ao gami ijiju paledi na tomete ikikeredi, beto pa izongomu ao gami roitidi gami zoku roiti varivagabaradi!> mari gua. ");
INSERT INTO ghn_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ba ari pala mana ule votu veini vadi ara ria, <Qake izongo gilagilagamu ara za gamu. Mu taloi taqu za gamu na galegale tinoni ikikeremiu!> mana gudi,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","<<Ego ko aza za nongororia na qua paranga ari ko za tutiria, za vei na tinoni tavagigalana za vaturua na nana ruma pa kuta patu. ");
INSERT INTO ghn_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ko za gore za na qolapezo, za vae za na pie, beto za iru za na gava, ko za rajai za na ruma aza, ba zake boka tanobata za na ruma, ura za turu vamauru pa kuta patu aza. ");
INSERT INTO ghn_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Goto aza na tinoni za nongororia na qua paranga ari ba zake tutiria, za vei na tinoni duviduvilina za vaturua na nana ruma pa naganagazana. ");
INSERT INTO ghn_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ko za gore za na qolapezo, za vae za na pie, beto za iru za na gava, nari za tanobata za na ruma aza, ko za dugala tajegajegarani aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ego ko totonai za beto varivagigalaidi na paranga ari i Jisu, za qari gabara vitivitigini ria na minete tinoni za na varivagigalai tana, ");
INSERT INTO ghn_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ura aza za kole varivagigalai vei na tinoni za izongia na neqi beto zake vevei ria qari varivagigalaini na Vavanau. ");
INSERT INTO ghn_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ego totonai za taloi pa kubo ko za gore i Jisu, za ria na minete tinoni lavata za qari tutia aza. ");
INSERT INTO ghn_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ko ani za maka tinoni poqupoqu za lame nyumu sori tungutungu pa moena aza, ko ari za gua vei, <<Bangara, vei bu malumu ao, za muna boka valiosoziu gu ara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nari za kaqamani na limana ko za ulia i Jisu za na tinoni aza beto ari za guni vei, <<Qa malumu gu ara. Ko mu lioso tu ao!>> za guni. Na totozo tugu aza za tataloso valioso gu za na poqupoquna aza. ");
INSERT INTO ghn_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Beto ari za poja veini i Jisu aza, <<Kopuni ko munake vavakato vani maka tinoni, goto mu lao vatuvizi tana iama ko mi dogoro vilovilotigo beto za muna roitini ao za na mua vavavui vei za varigarununi i Mosese, ko ria doru mari gilagilai za ao qu tori lioso tu,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Totonai za luge lao pa Kepaniami i Jisu, za lame tana za maka tinoni matamata gogoto, ko za tepa tokatokani varitokai, ");
INSERT INTO ghn_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ari za gua vei, <<Bangara, na qua nabulu za korapa kole momonana pa ruma, za uke kale na tinina beto za kamua na vitigi lavata,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nari ari za guni vei i Jisu aza, <<Ara mana lao salania aza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ba za paranga za na tinoni matamata gogoto aza, ari za gua vei, <<Bangara, ara nake tinoni garoqu ko bu lame luge pa ruma taqu ara ao. Goto mu leve tarini gu na paranga, beto pala mina tasalananana gu za na qua nabulu. ");
INSERT INTO ghn_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ura ara ba maka tinoni qa kole kaurai tugu pa neqi tadiria na qua bangara beto ko koledia ria na tinoni varipera qari kole kaurai pa na neqi taqu. Ko tonai qa parangia ani, <Mu lao,> qaguni, nari za laonana tugu, beto qa parangia za nari, <Mu lame,> qaguni, nari za lamenana tugu. Ko na qua nabulu aza, <Roitini ani,> qa guni, za roitini gu,>> za guni i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Totonai za nongoria i Jisu nari za gabara vitivitigi, ko ari za gudi vei ria qari kole tututia aza, <<Ma poja zozotodigamu ara gamu: oqoro pore tana maka tinoni pa Izireli ba batini ara za na rangerange lavatana vei ani. ");
INSERT INTO ghn_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ko ma pojadigamu ara: pala kubo tinoni za mari lame vei keta pa zagere tapo beto pa suvu tapo, ko mari nyumu tavitiria pa vavolo pa binangara pa noka ari Ebarahami, i Aisake beto ko i Jekopi. ");
INSERT INTO ghn_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Goto ria na tuni binangara za mari tagona votu pale pa peguru rorodomona. Ketakoi mari lukana uui beto mari ngingizi tu na livodi,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Beto i Jisu za parangia na tinoni matamata gogoto ani, ari za guni vei, <<Mu kenimua. Aza vei qu vazozotoa ao za mi gore votu vanigo,>> za gua aza. Pa totozo tugu aza za tasalana za na nabulu tana tinoni matamata gogoto aza. ");
INSERT INTO ghn_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ego tonai za kamu pa ruma ti Pita i Jisu, za batia za na qoele roana i Pita za mangini na tinina ko za korapa kole momonana pa lovu. ");
INSERT INTO ghn_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ko za arua i Jisu za na limana, nari za taloi tana za na mo mangini ko za tatakole vatana vani na tekutekuna aza i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Totonai za gore na veluvelu nari za qari toka kamudi ti Jisu ria na mota tinoni za lugeria na tomete ikikeredi. Ko za iju paledi na nana paranga i Jisu ria na ongu ikikeredi, beto za salanaria ria qari mo. ");
INSERT INTO ghn_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ko za gore votu za na paranga za pojai i Aisea na tinoni korokorotai, ari za gua vei, <<Aza za teku paledi na nada mo beto za pogozo paledi nada vagauru,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ego ko tonai za batia i Jisu za na minete tinoni qari lame varilivutaini, za garunu ria na nana sepele ko mari toka lao pa maka kale karovona na ovuku Qalili za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Maka aza za varivagigalaini na Vavanau za lame ko ari za guni vei i Jisu, <<Tinoni varivagigalai, ara mana tutigo ao doru kota muna lao vei ao,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nari ari za guni vei i Jisu, <<Ria na pokese kolenana na dia baongo beto ria na manugu pa vavagalo kota kolenana na dia vorivori, goto na tuna na tinoni za kepore na nana ia mina vaminyeria na batuna,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Maka goto nana sepele ari za guni vei aza, <<Bangara, vamalumuziu ko ma mule lao golomia mae na tamaqu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nari ari za guni vei i Jisu aza, <<Tutiziu ara ao. Loiria ria na ukedi ko mari varigolomo makadi,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ego za zae pa maka koaka i Jisu beto ria na nana sepele, ko mari toka lao pa maka kale karovona na ovuku Qalili qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nari za raja vasiboro pa kolo za maka ranebongi, ko za vavapoara tarini na ololobagea za na koaka. Ba i Jisu za kole putagana tugu. ");
INSERT INTO ghn_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ko qari lao vaiqolia ria na nana sepele aza, ari qari guni vei, <<Bangara! mu alogita, Taqe dururu uke gu za gita!>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nari za oeria i Jisu ria, <<Ae za vei ko gamu matagutu tu za gamu? Za beko peki na miu rangerange!>> za gudi. Beto za tatakole aza ko za tokea za na gava beto na kolo, nari za bule elava za na kota. ");
INSERT INTO ghn_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nari za qari gabara beto ria doru, ko qari kole variparanga mule makadi, <<Koi, ae tu tinoni veveina ani? Ko na gava beto na ololobagea tu ba qari nongoria tu!>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ego totonai za paro pa maka kalena tata pa guguzu pa Qadara i Jisu, za qari koko lame vei pa bevi varivarigolomona ketakoi za kori tinoni za lugeria na tomete ikikeredi ko qari lame gozoria i Jisu. Qari aru tapata, ko kepore maka tinoni za nyorogua tokai za na zona za lao vei ketakoi. ");
INSERT INTO ghn_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tonai qari batia ari kori i Jisu za qari velavela votu, ari qari gua vei, <<Na za qu nyorogua roitini tadigami ao, na Tuna na Tamaza? Ae vei, qu lame ko mu pipiaragami gami totonai za oqoro kamua na mami totozo qu gua?>> qari gua ari kori. ");
INSERT INTO ghn_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ego nake zouna pa ia aza za maka godo borogo lavata qari korapa nyubenyubelegedi. ");
INSERT INTO ghn_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ko ria na ongongu ikikeredi qari tepa vitivitigia i Jisu, ari qari gua vei, <<Vei muna iju vakenigami, nari za mu garunu valaodigami gu pa godo borogo rari,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nari ari za gudi vei i Jisu, <<Mu lao tu!>> za gudi. Ko qari taloi keni tadi ari kori tinoni ari ria na tomete ikikeredi, ko qari lao luge tadiria na borogo. Ura ko qari sasuru turu taloi keni gu mule ria na borogo ari, ko qari tulai gore za na taba mamavarana, ko qari tuluzu gore pa leo kolo ko qari kuju uke beto pudaladia tu. ");
INSERT INTO ghn_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ego ko za vei aza nari za qari uku muledia pa guguzu ria na tinoni qari kopudi na borogo, ko qari vavakato beto vadi ria ria doru zakazava qari taroiti tadi ari kori za lugeria na tomete ikikeredi. ");
INSERT INTO ghn_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ko qari lao gozoria ria doru tinoni pa guguzu aza i Jisu. Tonai qari batia, nari za qari tepa vitivitigia aza ko mi loia na dia guguzu aza qari guni. ");
INSERT INTO ghn_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ego za surana pa koaka i Jisu ko za toka karovo lao pa nana guguzu zozoto. ");
INSERT INTO ghn_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ko qari pogozo kamuni pa nana kolekolena za maka tinoni za uke kale na tinina. Tonai za batia i Jisu za na rangerange tadiria, za ari za guni vei aza za na tinoni za uke kale na tinina, <<Tuqu, mu varene! Ria na mua sela za qari tori taleozo tu,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ego tonai za kaki ria qari varivagigalaini na Vavanau za qari kole variparanga golomo makadi, <<Na tinoni ani za vamoroania na Tamaza ani!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ba za tori gilagilainana tu i Jisu aza vei qari korapa roquroqua ria, ko ari za gudi vei, <<Ae za vei ko gamu roquroquria na zakazava ikikeredi veveidi zara pa bulomiu? ");
INSERT INTO ghn_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ae za munyala: na poja vei, <Qari taleozo ria na mua sela,> bi gua, babi na poja vei, <Mu tatakole ko mu rerege,> bi gua? ");
INSERT INTO ghn_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ba koviria ma vabatidigamu ara za na Tuna na Tinoni za kolenana nana neqi pa pezo ko mina taleozodi ria na sela,>> za gua aza. Beto ari za guni vei za na tinoni za uke kale na tinina, <<Mu turu! Mu pogozia na mua kolekolena ko mu kenimua pa mua ruma,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nari za soqolo turu gu za na tinoni ko za keninana pa nana ruma. ");
INSERT INTO ghn_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Totonai qari batia za vei zara ria na minete tinoni nari qari matagutu beto qari vatarazaea za na Tamaza, ura na Tamaza za vani na tinoni za na neqi vevei zara. ");
INSERT INTO ghn_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ego za taloi pa ia aza i Jisu ko za korapa lalaonana, za batia aza za maka tinoni tekuteku takisi, na izongona i Matiu, za korapa nyumunana pa nana ia roroitina aza. Ari za guni vei i Jisu aza, <<Mae tutiziu ara,>> za guni nari za turu i Matiu ko za tutianana i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ko tonai za korapa nyumu tekuteku pa ruma ti Matiu i Jisu beto ko ria na nana sepele, za na motadi ria na tinoni tekuteku takisi beto ria na tinoni seladi qari somana nyumu tekuteku tavitia i Jisu beto ria nana sepele. ");
INSERT INTO ghn_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ko qari batiria ria na Parese za qari vei aza, ko qari nanazaria ria na sepele ti Jisu, <<Ae za vei za tekuteku tavitiria tu ria na tinoni tekuteku takisi beto ria na tinoni seladi za na tinoni varivagigalai tadigamu?>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nari za nongoro vairia i Jisu, ko ari za gudi vei, <<Ria na tinoni toa valeadi za qarike nyaqoa za na tinoni varivarisalana, goto ria gu qari mo. ");
INSERT INTO ghn_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mu lao ko mu nyaqoa na ginuana za na paranga za pojai na Tamaza pa Kutikuti Tabuna, ari za gua vei, <Na variroqu varitokai za qa nyoroguani ara, nake vavavavuidi na manugu mademade nenedi!,> za gua. Ura qake lame ara ko ma kukuria na tinoni tuvizidi qa gua, goto ria tu na tinoni seladi,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ego qari lao ria na sepele ti Jone, ko qari nanazia i Jisu, ari qari guni vei, <<Ae za vei ko gami gu beto ko ria na Parese za gami tabutabu ganigani, goto ria na sepele tamu za qarike tabutabu ganigani tu?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nari za ari za gudi vei Jisu ria, <<Ae vei, pala mari kole takulanga pa vavolo varielava ria na tinoni tasorudi totonai za korapa nyumu tavitiria za na tinoni varielava? Dai! Ba za korapa lamelamenana za na rane totonai mina tateku varijo tadiria za na tinoni varielava ani, ko na totozo tu aza za mari suvere tabutabu ganigani ria. ");
INSERT INTO ghn_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kepore za maka tinoni mina tuvakani na poko koregana za na poko leluna. Vei mina vei nari za totonai mina vijongo za na poko koregana ani, nari za pala mina raqama valavatia za na poko leluna. ");
INSERT INTO ghn_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Beto kepore maka tinoni mina totoni na vaini koregana za na tototoni vaini leluna. Ura mina vei aza, nari za pala mina tapokata za na tototoni vaini leluna, ko mina tigitigi kijara keninana za na vaini. Goto na vaini koregana za mina tatoto lao tugu pa tototona koregana ko ari kori doru za mari takopu valeana beto,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Totonai za korapa paranga vei zara i Jisu, za kamu opo ovoro sori tungutungu pa moena aza za maka tiolata matamata tadiria na Jiu, ko ari za gua vei, <<Na tuqu maqota za koni uke gu, ba qa nyoroguanigo ko bu lame vaoponi na limamu ko bi toa mule qa gua,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nari za turu i Jisu beto ria na nana sepele ko qari tutia za na tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ego maka reko aza za varajani na mo malea ko za kole gu vakeni orungu ka manogori aoro za tuti pa liguna ko za ulia za na uquna na poko ti Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Za kole paraparanga golomo makana, <<Vei ba ulia gu nana poko, nari ba ba tasalanaqua gu ara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ko za balinga mule za gua i Jisu nari za batia za na reko, ko ari za guni vei, <<Mu varene, tuqu! Na mua rangerange za tori salanigo tu,>> za gua aza. Nari za na totozo tugu aza za tasalana gu za na reko aza. ");
INSERT INTO ghn_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ego totonai za lao kamu pa ruma tana tiolata matamata i Jisu, nari za batiria aza ria na tinoni qari lukana popoelai na romaroma beto qari lukana kebokebo, ");
INSERT INTO ghn_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","za ari za gudi vei, <<Mu taloi kenimiu gamu! Ura zake uke za na reko peki ani, goto za korapa gu putagana!>> za gua. Tonai za paranga vei aza nari za qari auni ria doru tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ko tonai qari votu beto pa peguru ria doru, za luge i Jisu ko za arua na limana na reko nari za tatakole za na reko. ");
INSERT INTO ghn_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ko na nongorona na roiti ani za tapiara lekoia doruna na kota aza. ");
INSERT INTO ghn_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ego totonai za taloi ketakoi i Jisu za kori tinoni nake batabatadi za qari tutia aza, ko qari velavela votu, ari qari gua vei, <<Tuna i Devita, mu roquroqu tokadigami,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tonai za luge pa ruma i Jisu nari za ari kori tinoni nake batabatadi ba qari lao tugu luge. Nari za nanazaria i Jisu, <<Ae vei, gamu vazozotoa tugu gamu kori za ara mana boka salanagamu gamu kori?>> za gudi. Nari za ari qari guni vei, <<E, Bangara!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nari za uliria i Jisu za na matadi beto ari za gua vei, <<Aza vei gamu vazozotoa gamu kori za mi gore votu vadigamu!>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nari za qari batabatadia tugu za na matadi ari kori. Beto za paranga vabalauria i Jisu ari kori, ari za gudi vei, <<Keta ule vadi ria na tinoni za na roiti ani,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ba qari taloi keni ari kori, ko qari vavavakatoni doru kota ketakoi za na veveina aza. ");
INSERT INTO ghn_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ego pa ligudi gu qari keni ari kori ari, za qari toka kamuni tana ria kaki tinoni za maka tinoni za lugea na tomete ikikerena ko za poka. ");
INSERT INTO ghn_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tonai za iju pale i Jisu za na tomete ikerena ani nari za podalai paranga gu za na tinoni aza. Ko qari gabara beto ria na minete tinoni, ko ari qari gua vei, <<Za oqoro pore tabata pa Izireli za na zakazava vevei ari,>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ba qari paranga ria na Parese, <<Na bangaradi gu ria na tomete ikikeredi za vani na neqi za boka iju paledi ria na tomete ikikeredi zana,>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ego za rerege betoria i Jisu ria na guguzu lavalavatadi na guguzu pekipekidi. Ko za varivagigalai aza pa ruma varivarikamuna, za taraeni aza za na nongoro leana na veveina na binangara tana Tamaza, beto za salanaria aza ria na tinoni qari vavarajadi na okokoto mo na vagauru. ");
INSERT INTO ghn_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Totonai za dogoro laoria aza ria na minete tinoni, za roquroqu vitivitigiria, ura qari vevei rerege beto qari nyunyala vei na sipi kepore na dia sepati. ");
INSERT INTO ghn_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nari ari za gudi vei ria na nana sepele, <<Qari matua nyanyalu ria na vuvua, ba ria na tinoni ababu za qari vizaviza gu. ");
INSERT INTO ghn_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ko mu varavara lao tana Bangaradi na umuma, ko mi garunuria na tinoni roiti ko mari ababu pa nana inuma,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ego za kuku varikamudi i Jisu ari ka manogori sepele ko za vadi na neqi ko mari ijiju paledi na tomete ikikeredi, mari salana paledi na okokoto mo beto doru vagauru za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ko ari ria na izongodi ari ka manogori tinoni tagarunudi: momoe, i Saimone (maka izongona i Pita) beto i Aduru (na taina i Pita), i Jekopi beto i Jone na taina (Ari kori tuna i Jebeti), ");
INSERT INTO ghn_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","i Pilipi, i Batolomiu, i Tomasi, i Matiu aza na tinoni tekuteku takisi, i Jekopi na tuna i Alepiasi, i Tadiasi, ");
INSERT INTO ghn_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","i Saimone aza perangaina za somanadi ria qari raja adu pale na qavuna pa Romu, beto i Jiudasi Isikarioti aza za gabala kanai i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ko ari ka manogori ari za vavanauria i Jisu beto za garunuria, ari za gudi vei, <<Munake lao tadiria na tinoni karovodi beto munake lugeria na guguguzu tadiria na tinoni Sameria. ");
INSERT INTO ghn_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Goto mu lao tadiria na tinoni Izireli ria qari vei na sipi mumadi. ");
INSERT INTO ghn_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mu lao ko mu tarae, ari mu gua vei, <Na binangara pa noka za mi togagita gu za gua,> mu gua. ");
INSERT INTO ghn_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mu salanaria ria qari mo, vatoa muleria ria qari uke, mu taloso valiosoria ria qari poqupoqu, beto mu iju paledi ria na tomete ikikeredi. Gamu ke vaia aza gamu tekua, ko muke vavaini aza gamu variiani. ");
INSERT INTO ghn_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Muke pogozo qolo, na siliva, babi kaki poata pa miu kurakurani poata. ");
INSERT INTO ghn_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Muke pogozia maka mane, muke pogozo vakori poko, muke pogozo sadolo babi na opata pa miu rerege. Na tinoni roiti za pada tugu ko mina taiani za nana tekutekuna. ");
INSERT INTO ghn_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Totonai muna kamua maka guguzu lavata babi na guguzu peki, za mu lugea na guguzu aza ko mu dogoro nyaqoa za maka tinoni mina qeradigamu ko mina vatogagamu. Muna suvere gu tana tinganai muna loia na ia aza za gamu. ");
INSERT INTO ghn_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tonai muna luge pa ruma za mu gozoro qeraqeradi ria na tinoni ketakoi. ");
INSERT INTO ghn_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Vei mari vakamu valeanagamu ria pa ruma aza, za mu tepai na Tamaza ko mi manadi. Goto vei marike tavaraguadigamu ria, za mu teku muleni na miu bule. ");
INSERT INTO ghn_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Vei kaki ruma babi na guguzu za barike nyorogua vakamugamu beto barike nyorogua nongorogamu, nari za mu turu iolo votu pa ia aza beto mu tavuzu paledi pa nenemiu za na kavuruni pezo pa guguzu aza. ");
INSERT INTO ghn_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ma poja zozotodigamu ara za gamu: mina jolani na varituti qari gozoria ria pa Sodomo beto pa Qomora za na varituti tana Tamaza mina gozoria na guguzu aza na rane varituti,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","<<Vainongoro! Qa garunu lao veidigamu na sipi tadiria na godo vulupu pirudi ara za gamu. Mu suvere vabalabalau vei ria na dole beto mu lioso pa miu uana vei na kuru. ");
INSERT INTO ghn_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mu suvere vabalabalaudi ria na tinoni. Ura pala mari aru tamanagamu, ko mari toka laodigamu pa varituti, beto mari majamajagamu pa dia ruma varivarikamuna. ");
INSERT INTO ghn_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pana laequ ara za pala mari toka ragata laodigamu pa moedi ria na qavuna beto na bangabangara, ko muna ule votuni na nongoro leana tadiria beto tadiria na tinoni karovodi. ");
INSERT INTO ghn_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Totonai mari toka laodigamu pa varituti, za munake takulangani gamu za na za muna poja toketokedigamu makamiu. Ura tonai mina kamua tu za na totozo paranga tadigamu za muna taiani gamu aza vei muna pojadi gamu. ");
INSERT INTO ghn_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ura nake gamu za muna kole paranga, goto na Ongonguna na Tamamiu tu za mina ule vadigamu aza muna pojai. ");
INSERT INTO ghn_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ria na tamatamatazi marene za pala mari varivalao pa uke, na tamadi mina veidi tugu na nana koburu, ria na koburu mari rajaria ria na tinadi na tamadi ko mari vaukeria. ");
INSERT INTO ghn_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Doru tinoni za pala marike tavaraguadigamu ura koko vei gamu tutiziu ara. Ba aza za vangaju kamua na betobetona za mina taalo. ");
INSERT INTO ghn_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tonai mari komiti vikevikeregamu ria na tinoni pa maka guguzu za mu uku laomiu pa maka goto guguzu. Ura ma poja zozotodigamu ara gamu: pala muna oqoro vaokoto betoria gamu ria na miu roiti pa doru guguzu pa Izireli, za mina mule lame gu za na Tuna na Tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Na sepele zake lavata jolani za na nana tinoni varivagigalai. Beto na pinauzu zake lavata jolani za na nana bangara. ");
INSERT INTO ghn_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Za pada gu za na sepele mina varitoto vei na nana tinoni varivagigalai, beto za pada gu za na pinauzu mina varitoto vei na nana bangara. Vei ara na miu tinoni matamata mari gigalaniziu i Beelizebulu, nari za gamu na qua tinoni za pala mina nongoro ikere jola mutu za na izongo mari kukudigamu!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","<<Ko muke matagutudi ria na tinoni ria. Ura doru zakaza paedi za pala mari tabata votu beto doru zakaza golomodi za mari tagilagila. ");
INSERT INTO ghn_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Aza qa ule vadigamu ara pa rorodomona za mu vavakatoni pa kabekaberena, beto aza gamu nongoria pa paena za mu velavelani pa are ruma. ");
INSERT INTO ghn_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Muke matagutudi ria qari boka vaukea na tini ba qarike boka vaukea na ongongu. Goto na Tamaza tu za mu matagutuni gamu. Aza za mina boka piaria na vaukeria na toa tini beto na ongongumiu ko mina boka valaogamu pa heli. ");
INSERT INTO ghn_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Maka pene peki gu na vaidi za kori kiri tu, ba zake pae tu pa roquroqu tana Tamaza za totonai za lotu pa pezo maka ari kori kiri ari. ");
INSERT INTO ghn_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ko gamu ba doru vurungumiu pa batumiu ba za tori nguti betoria tu na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ko muke matamatagutu. Gamu za gamu poreveveina joladi kubo ngavulu avara kiri,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","<<Aza za ule votuni pa moedi ria na tinoni za aza maka tinoni taqu mina gua, za ara ba mana ule votuni tugu aza pa moena na Tamaqu pa noka aza. ");
INSERT INTO ghn_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Goto na tinoni za kilu paleniziu ara pa moedi ria na tinoni, za ara mana kilu paleni tugu pa moena na Tamaqu pa noka aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","<<Keta mu roquroqua gamu za na bule za qa pogozo lameni ara pa pezo keta mu gua. Dai, nake bule za qa pogozo lameni ara, goto na benete varipikatai tu. ");
INSERT INTO ghn_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Qa lame ara ko ma varipikataidi ria na tuna marene beto na tamana, na tuna reko beto na tinana, beto na tamatamaivana beto na tamatamaroana qa gua. ");
INSERT INTO ghn_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ria na kana ikeredi jola tana tinoni za mina ari ka viza gu pa nana tatamana. ");
INSERT INTO ghn_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Aza za roquroquria na tamana babi na tinana jolani za roquroquziu ara za zake pada ko mina sepele taqu. Aza za roquroqua na tuna marene babi na tuna reko jolani za roquroquziu ara za zake pada ko mina sepele taqu. ");
INSERT INTO ghn_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Aza zake pogozia na nana korosi ko mina tutiziu ara, za nake padana tugu ko mina sepele taqu aza. ");
INSERT INTO ghn_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aza za kole gu tapatianani na nana toa tini, za mina saivia tugu aza za nana toa. Ba aza za gona pale nana toa pa laequ ara za mina izongia tugu za nana toa,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","<<Aza za vakamugamu gamu za vakamuziu tugu ara, aza za vakamuziu ara za vakamua tugu aza za garunuziu ara. ");
INSERT INTO ghn_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aza za vakamua na tinoni korokorotai ura na tinoni korokorotai aza, za aza mina somana tekua za na pinia tana tinoni korokorotai. Aza za vakamua na tinoni tuvizina ura na tinoni tuvizina aza, aza mina somana tekua za na pinia tana tinoni tuvizina. ");
INSERT INTO ghn_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aza mina vani maka kapa pie lomozo za maka aza nake poreveveina ari ura aza za na sepele taqu, nari za ara ma poja zozotodigamu gamu: aza mina tekua zozoto za na pinia,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Totonai za beto vavanauria ari ka manogori nana sepele i Jisu, nari za taloi ketakoi ko za keni varivagigalai beto za tarae pa guguguzu pa ia ketakoi. ");
INSERT INTO ghn_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ego za korapa suvere pa ruma varipiu i Jone Paputaiso za nongoroni aza ria na roiti za roitidi na Karisito, ko za garunu laodi aza tana ria kaki nana sepele, ");
INSERT INTO ghn_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ko ari qari guni vei, <<Ae vei, ao tugu za aza gami korapa adadonia gami na tinoni pala mina lame gamiguni? Ba ae vei, maka goto tu za mami adononi gami?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nari za oeria i Jisu ria, <<Mu mule lao ko mu ule vani i Jone ria vei gamu nongororia beto gamu batiria. ");
INSERT INTO ghn_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Na tinoni qarike batabata qari batabata, ria na qao qari rerege, ria za vairia na poqupoqu qari tataloso valioso, na tinoni qari kiqili qari nongonongoro, na tinoni ukedi qari toa mule, beto na nongoro leana tana Tamaza za tatarae tadiria na tinoni golabadi. ");
INSERT INTO ghn_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mari tamana ria qarike nongoro nyunyalaniziu ara!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ego ko pa ligudi qari taloi keni ria na sepele ti Jone ari, za pojai i Jisu tadiria na minete tinoni za na veveina i Jone, ari za gudi vei, <<Tonai gamu lao za gamu ti Jone pa qega, za na za za mu lao dogoria gamu gua? Maka tinoni za malei vei na equru buruburu za tajou vakanokanoko lao lameni na gava? ");
INSERT INTO ghn_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ba na za beka gamu nyorogua lao batia? Maka tinoni izizongo za pokopoko valeleana? Dai, na tinoni qari pokopoko valeana vei zara za pa ruma bangara tu qari suvesuvere! ");
INSERT INTO ghn_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ko na za zozoto za gamu nyorogua lao dogoria gamu? Maka tinoni korokorotai? E, ba ma pojadigamu ara: aza za poreveveina joladi ria na tinoni korokorotai. ");
INSERT INTO ghn_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ura i Jone gu za aza za pojai na veveina na Kutikuti Tabuna, ari za gua vei, <Vainongoro! Ara qa garunu momoe laoni za na qua tinoni pogozo nongoro, ko mina vatana momoea za na zona tamu,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ara ma poja zozotodigamu za gamu: za kepore maka tinoni podona za poreveveina jolani i Jone. Ba na tinoni za kepore veveina jola pa binangara pa noka za poreveveina jolani i Jone. ");
INSERT INTO ghn_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Za podalai totonai za kole tarae i Jone Paputaiso ko za kamu koviria za na binangara pa noka za qari rapatia ko ria na tinoni tuara ikeredi qari saputu ragata tekua. ");
INSERT INTO ghn_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ria doru tinoni korokorotai beto na Vavanau ti Mosese za qari ulule votuni tinganai qari lame kamua na totozo ti Jone. ");
INSERT INTO ghn_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Vei muna nyorogua vazozotoa za, i Jone gu ani za i Elaija, aza za korapa lamelamenana qari guni ria. ");
INSERT INTO ghn_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Na tinoni za pore na talingana za mi vainongoro valeana! ");
INSERT INTO ghn_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Na za mana vavavapadadi ara ria na zazae tinoni ari? Ria na tinoni koviria za qari vei gu ria na koburu qari nyumunyumudia pa ia makemaketina ko qari kole varivarikuku karovo, ari qari kuku vei, ");
INSERT INTO ghn_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","<Gami kerakera vadigamu na kera varielava, ba gamu gamuke peka tu! Gami kera romaroma gami, ba gamu gamuke lukana takulanga tu!> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Totonai za lame i Jone za boka madimadi ko zake tekuteku beto zake bukubuku vaini aza. Nari qari paranga ria na tinoni, <Za kolea na tomete ikikerena za na bangara zana!> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tonai za lame mule na Tuna na Tinoni ko za tekuteku beto za buku, nari za ari qari guni vei, <Dogoro! Za ngoja mota beto na tinoni bukubukuna, na baere tadiria na tinoni tekuteku takisi beto ria na tinoni seladi zana!> qari guni. Ba na tavagigala tana Tamaza za tabata votu pa vuana na toa tadiria na tinoni qari vazozotoa,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ego ko za podalai tokeria i Jisu ria na guguzu ketakoi za roitidi ria na kubo roiti varivagabaradi aza, ura qarike gabala loiria na dia sela. Ari za gudi vei, ");
INSERT INTO ghn_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","<<Mu takulangagemiu tu za gamu pa Korazini. Mu takulangagemiu tu gamu pa Betiseda! Vei bari taroiti tadiria na tinoni karovodi pa Turosi beto pa Sidoni ria na roiti varivagabaradi qari taroiti tadigamu koviria, za pa moa tu bari gabala loi paledi na dia sela ko bari bilubiludi na kau beto bari vazae poko tarikarikatadi ria! ");
INSERT INTO ghn_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ba ma poja valeanadigamu ara za gamu: na rane varituti za mina jolani na varituti mari gozoria ria pa Turosi beto pa Sidoni za na varituti tana Tamaza muna gozoria gamu. ");
INSERT INTO ghn_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Goto gamu pa Kepaniami! Ae vei gamu roquroqua gamu za pala muna taovulu zaemiu pa noka? Dai, pala muna tagona vagore gu pa ia suvesuverena tadiria na tinoni ukedi! Ura bari taroiti tadiria pa Sodomo ria na roiti varivagabaradi qari taroiti tadigamu koviria, za bi korapa turu jolanana kamua tu pa rane pa ngenari za na guguzu aza. ");
INSERT INTO ghn_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ma poja valeadigamu gu ara za gamu: na rane varituti za mina jolani na varituti mari gozoria ria pa Sodomo za na varituti tana Tamaza muna gozoria gamu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ego pa totozo aza za paranga vei ari i Jisu, <<Tamaqu, ao na Bangarana na oka beto na pezo. Qa paranga leana lao tamu ara, ura na zakazava ari za qu vapaeria ao tadi ria na tinoni gigigalaidi beto na bokabokadi beto qu vadogorodi ria qarike gigalai. ");
INSERT INTO ghn_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","E, Tamaqu, ura aza tugu za vei za na nyorogua tamu. ");
INSERT INTO ghn_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Na Tamaqu za tori ianiziu tu ara doru zakazava, ko kepore za maka tinoni bi gilagilai na Tuna goto na Tamana gu, beto kepore za maka tinoni bi gilagilai na Tamana goto na Tuna gu beto ria gu za mijataria na Tuna ko za vakabere vadi na veveina na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mae, lame taqu za gamu doru gamu pavu beto gamu pogozo mamata, ko ara ma vaminyeregamu. ");
INSERT INTO ghn_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mu paku pogozia na qua pajavala beto mu vainongoro lame taqu, ura ara za qake tuara beto qa vapekai pa bulo, ko mu teku vani na minyere na miu toa. ");
INSERT INTO ghn_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ura na pajavala taqu za munyala na paku pogozona, beto na pogozo taqu za kopele,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ego na totozo aza za rerege jola vei pa maka inuma vuiti na rane Minyere i Jisu. Ko ria na nana sepele za vairia na burana ko qari podalai ravuzu teku vuiti ko qari kole ngojagedi. ");
INSERT INTO ghn_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ko tonai qari batiria qari roiti vei, nari za ria na Parese ari qari guni vei i Jisu, <<Dogoro! Ria na sepele tamu za qari roitini za na roiti zake tavamalumu ko mina taroiti na rane Minyere!>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nari za oe laoria i Jisu ria, <<Ae vei gamu oqoro tiroamiu tu gamu aza na roiti za roitini i Devita beto ria na nana tinoni totonai qari burana ria? ");
INSERT INTO ghn_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Na vavakatona aza za lugea i Devita za na ruma tana Tamaza ko za gania za na bereti madina, aza zake vamalumia na Vavanau ko mina gania aza babi ria qari tutia goto ria gu na iama qari tavamalumuni. ");
INSERT INTO ghn_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Beto gamuke tiroamiu tu gamu pa Vavanau za ria na iama qari roitidi na dia roiti pa rane Minyere pa zelepade za qari majai tugu ria za na vavanauna na rane Minyere ba qarike tajutuni qari sela ria? ");
INSERT INTO ghn_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ba ma pojadigamu ara za gamu: maka za poreveveina jolani na zelepade za korapa pani. ");
INSERT INTO ghn_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ari za gua vei za na Kutikuti Tabuna, <Na variroqu varitokai za qa nyoroguani, nake vavavui,> za gua. Ko vei bu gilagila valeania miu gamu za na ginuana na paranga ani, za buke jutu goborodi na tinoni seladi gamu ria na tinoni qarike sela. ");
INSERT INTO ghn_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ura na Tuna na Tinoni za na bangarana na rane Minyere,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ego ko za taloi ketakoi i Jisu, za lao pa maka ruma varivarikamuna tadiria na Jiu, ");
INSERT INTO ghn_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ko ketakoi za korapa za maka tinoni za raiqo maka kale limana. Ko ria qari korapa nyaqo rokaga ko bari jutuni kaki sela i Jisu za ari qari guni vei aza, <<Ae vei, na tavamalumuna pa Vavanau za na salana tinoni na rane Minyere?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nari za oe laoria i Jisu ria, ari za gua vei <<I zei gamu za izongia maka sipi ko bi lotu loposo pa oqili na rane Minyere za na sipi aza, nari za minake bako votuni na rane tugu aza aza? Pala na rane tugu aza muna bako votuni gamu aza! ");
INSERT INTO ghn_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ba na tinoni tu za poreveveina jolani na sipi! Ko za vamalumia gu na Vavanau za na roitini na roiti leana na rane Minyere,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Beto nari za paranga laoa aza na tinoni za raiqo maka kale limana, <<Mu radonia na limamu,>> za guni. Ko za radonia aza za na limana nari za leana soga vei tugu maka kale limana. ");
INSERT INTO ghn_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nari za qari taloi keni ko qari varingodo roquroqu ria na Parese ko mari vaukea i Jisu qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Totonai za gilagilai i Jisu za na kukiti tadiria ani, za za taloi keninana ketakoi aza. Ko ria na minete tinoni lavata za qari tutia aza, ko za salana betoria i Jisu ria doru. ");
INSERT INTO ghn_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Beto za pojadi ria ko marike vavavakatoni tadiria na tinoni za na veveina aza za gua. ");
INSERT INTO ghn_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ko ani za na vagore votuna na paranga tana Bangara za pojai i Aisea, na tinoni korokorotai, ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","<<Ani za na qua nabulu qa mijatia. Aza qa roquroqua beto qa qerani ara. Mana vakoleni na Ongonguqu aza, ko ria na tinoni karovodi mina ule vadi ria na inaalo. ");
INSERT INTO ghn_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Minake varitoke babi kuku velavela aza, na mamalaingina minake tanongoro pa zona. ");
INSERT INTO ghn_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Minake pakata pale maka kae suvege maleina, beto minake piju vaukea maka juke nonona. Ko mina toa vei aza aza tinganai mari batia ria za na inaalo taqu. ");
INSERT INTO ghn_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ko tana mari vatogazia na dia totoravuzu za ria na tinoni karovodi,>> za gua za na Bangara. ");
INSERT INTO ghn_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ego pa liguna aza za qari toka kamuni mule ti Jisu ria za maka tinoni za lugea na tomete ikikerena ko zake vabatabatai beto za vapokai tugu vei. Ko za salania i Jisu aza ko za paranga beto za batabata soga. ");
INSERT INTO ghn_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ko qari gabara beto ria na mineminete tinoni, ko qari kole varivarinanaza, ari qari gua vei, <<Palu ani tugu beka za na Tuna i Devita?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ba ria na Parese za totonai qari nongoria nari za ari qari gua vei, <<I Beelizebulu aza na bangaradi gu na tomete ikikeredi za vani na neqi ani, ko za vei za boka ijiju votu paledi ria na tomete ikikeredi>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ba za tori gilagilainana tu i Jisu za na dia roquroqu za vei zara ko ari za gudi vei, <<Na binangara za tapikapikata ko qari kole varivaripera mule makadi, za pala minake turu vamauru za na binangara aza. Beto ko doru guguzu babi na tatamana qari varipikapikatai za marike boka turu vamauru. ");
INSERT INTO ghn_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ko vei maka pikatana ti Setani za bi rajai gu mule za maka nana pikatana gu mule makana, za tori tapikapikata tugu makana i Setani, ko minake boka turu vamauru za nana binangara aza. ");
INSERT INTO ghn_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ko vei pa neqi gu ti Beelizebulu ba boka iju paledi ria na tomete ikikeredi ara, nari za i zei ropi za vadi na neqi ria na miu sepele ko qari boka iju paledi ria na tomete ikikeredi? Ko zara za vei za na roiti qari roitini ria za uleni za gamu sela gu za gamu! ");
INSERT INTO ghn_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Dai, pa neqi tu tana Ongongu tana Tamaza qa boka iju pale tomete ikikeredi ara, ko na binangara tana Tamaza za tori togagamu tu gamu koviria. ");
INSERT INTO ghn_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ari mutu mu dogoro veini ko. Kepore za maka tinoni mina boka lugea za na leo ruma tana maka tinoni neqina ko mina teku paledi za doru nana zakazava za izongoria. Ba momoe za mina piu vakolea mae tu za na tinoni neqina ani, beto tu nari za mina boka luge laoa aza za na nana leo ruma, ko mina boka tavuzu betoria ria doru nana zakazava. ");
INSERT INTO ghn_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Aza zake somana vei taqu za za taleziu ara aza, beto aza zake varikamu tokaniziu ara za za varipipiarai aza. ");
INSERT INTO ghn_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ko za vei aza za ma poja veidigamu ari: doru sela beto na paranga ikeredi qari vaakeni na Tamaza ria na tinoni, za mari boka taleozoni gu. Ba na paranga ikeredi qari vaakeni na Ongonguna na Tamaza za marike taleozoni. ");
INSERT INTO ghn_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Aza za poja vikevikeria na Tuna na Tinoni, za mina boka taleozoni gu. Ba aza za poja vikevikeria na Ongu Tabuna za minake taleozoni pa toa koviria beto kamua na kamua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","<<Vei mina leana za na suvegena na suvege, za na vuana ba mari leadi tugu. Vei mina ikerena za na suvegena na suvege, za na vuana ba mari ikeredi tugu. Ura pa vuana gu muna gilagilani ae veveina za na suvege. ");
INSERT INTO ghn_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Boko tuni dole ikikeremiu! Ko na tinoni ikikeredi vei gamu za pala marike boka paranga votudi ria na zakazava leadi. Ura aza tugu za pugele ojojongo pa bulo za tapoja votu pa nguju. ");
INSERT INTO ghn_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Na tinoni leana za vavoturia ria na uana leadi qari pugele pa bulona, goto na tinoni ikikerena za vavoturia ria na uana ikikeredi qari pugele pa bulona. ");
INSERT INTO ghn_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ba ma poja valeanadigamu ara za gamu: na rane varituti za ria tinoni za mari okokoto vakaberia tana Tamaza za na ginuana qari pojaria ria doru paranga qari vokele gobororia. ");
INSERT INTO ghn_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ura doru mua paranga tugu qu pojaria ao za pala mari tuti mulenigo. Ko na mua paranga tugu mina uleni za vei muna talegazani za ba muna gozoria ao za na vinakilasa pa varituti tana Tamaza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pa liguna za vei zara, za qari lao nanazia ria kaki qari varivagigalaini na Vavanau beto ria na Parese i Jisu, <<Tinoni varivagigalai, gami nyorogua batia gami za maka roiti varivagabarana jola tana Tamaza bu roiti votuni ao,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nari za ari za gudi vei i Jisu ria, <<Na zazae tinoni ikikerena beto na vakevakeporea na Tamaza za korapa nyoroguani maka roiti varivagabarana jola! E, ba kepore za maka roiti varivagabarana muna tavadogoroni, goto aza tugu makana gu na roiti varivagabarana za taroiti ti Jona na tinoni korokorotai. ");
INSERT INTO ghn_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Maka moqaza podeke vei tugu za suvere kue rane beto kue bongi pa leo iapana na igana i Jona, za mina vei tugu za na Tuna na Tinoni. Mina kue ranena tugu beto kue bongina tugu pa bevi varivarigolomona aza, beto za mina toa mule. ");
INSERT INTO ghn_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na rane varituti za pala mari turu ko mari tutidigamu ria na tinoni pa Ninive za gamu na zazae tinoni koviria. Ura ria za qari gabala za totonai qari nongoria na taraena i Jona. Goto dogoro tu ko, za korapa gu pani koviria za maka aza za poreveveina jolani i Jona. ");
INSERT INTO ghn_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na rane varituti za pala mina turu na kalao pa Siba ko mina tutidigamu za gamu na zazae tinoni koviria. Ura na kakazana jola za nana rerege koko lame vei pa nana guguzu totonai za kamu nongoria za na varivagigalai bokabokana ti Solomone. Goto gamu za dogoro tu ko, za korapa gu pani koviria za maka aza za poreveveina jolani i Solomone,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","<<Totonai za taloi tana tinoni za maka tomete ikikerena, za keni lekoia aza za na ia kepore maka zavana ko za nyaqoa za ketakoi mi suvere minyere za gua. Ba zake batia aza za maka ia ketakoi bi boka suvere. ");
INSERT INTO ghn_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nari za paranga gu, <Ma mule vatuvizi gu pa qua ruma ketakoi qa suvere perangaina ara,> za gua. Ko za mule za gua nari za batia na kobakobana ko za tori tasaqu valioso na tavatana valeana tu za na ruma. ");
INSERT INTO ghn_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nari za mule keni aza ko za keni toka kamudi ari ka vitu tomete qari ikere jolani makana, ko qari kamu suveria za na ruma aza. Ko tonai za na toa tana tinoni aza za ikere jolani na totozo momoe. Mina vei putaputa tugu aza za na zazae tinoni ikikeredi koviria,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tonai za korapa paraparangaria i Jisu ria na tinoni, za kamu turu pa sebesebe ruma za na tinana beto ria na taina marene, ko mari parangia aza qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ko maka ria qari korapa varikamu ketakoi za paranga laoa aza, ari za gua vei <<Qokolo, na tinamu beto ko ria na taimu marene za qari korapa turu adonigo pa peguru. Qari nyorogua parangaigo qari gua,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ba za oe laoa i Jisu aza, <<I zei za na tinaqu beto ari zei za na taiqu marene?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Beto za uduku laoria ria nana sepele beto za paranga, <<Ari ria na tinaqu na taiqu marene! ");
INSERT INTO ghn_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ura aza na tinoni za roitini aza vei za nyoroguani na Tamaqu pa noka za aza tugu za na taiqu marene, na luluqu reko beto na tinaqu,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ego na rane tugu aza za taloi pa ruma aza i Jisu, ko za lao pa keketaina na ovuku ko za nyumu ketakoi. ");
INSERT INTO ghn_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Na minete tinoni lavata za qari varikamuni aza, ko za lao tu zae ko za nyumu pa maka koaka aza. Goto na puku minete tinoni za qari turu gu pa paroparona. ");
INSERT INTO ghn_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ko kubo zakazava za vagigalaidi aza pa vavakato vavapada. Ko za vavakato vei ari aza. <<Kolenana za maka tinoni umuma za keni iparadi na kiko pa nana inuma. ");
INSERT INTO ghn_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Totonai za kole iparadi aza ria na kiko, za kaki za qari lotu lao pa lodaka zona pa rereregena tana tinoni, ko qari tatava kamu na manugu ko qari tobiki gani betoria na gedi. ");
INSERT INTO ghn_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Goto kaki mule za qari lotu lao pa buturuna ketakoi zake kubo pezona. Ko qarike oriavo tugu pidokodia za na kiko ria, ura zake kubo na pezo. ");
INSERT INTO ghn_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ba tonai za zagere gu na tapo nari za alanga vamaleiria, ura za kepore na bageredi. ");
INSERT INTO ghn_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Goto kaki kiko mule za qari lotu lao pa gazoro varivarioka, ko za pilu vaukeria na gazoro varivarioka. ");
INSERT INTO ghn_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Goto kaki kiko za qari lotu lao pa pezo masuruna ko qari vua valeana. Ko kaki za qari vua gogoto, kaki za qari vua vonomongavulu, goto kaki za qari vua uengavulu. ");
INSERT INTO ghn_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aza za kolenana talingana za mi vainongoro valeana!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ego aza tugu za beto za qari rijo lao tata ko qari nanazia ria na nana sepele i Jisu, <<Ae za vei ko qu varoitiria tu na vavakato vavapada ao tonai qu parangaria ria na tinoni?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nari za oeria i Jisu ria, ari za gudi vei, <<Ura gamu gamu tori taiani tu za na gigalai golomona na binangara pa noka ko gamu gilagilaimiu, ba tadiria na tinoni za korapa pae. ");
INSERT INTO ghn_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aza na tinoni za tori porenana tu za mina taia mutugu ko mina pugele nyonyoa na nana. Aza na tinoni za keporenana za aza tugu iapeki za izongia ba mina tateku pale tugu. ");
INSERT INTO ghn_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Na ginuana qa varivagigalaidi na vavakato vavapada za ura qari dogodogoro tugu ria ba qarike batabata, qari vainongoro tugu ba qarike nongonongoro beto qarike vakaberiadia maka za. ");
INSERT INTO ghn_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ko za gore votu tugu tadiria za na korokorotai ti Aisea, aza ari za gua vei, <Muna nongoro ko muna nongoro za gamu, ba munake vakaberia. Muna dogoro ko muna dogoro za gamu, ba munake batia. ");
INSERT INTO ghn_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ura na bulodi na tinoni ari za dupa na talingadi za kiqili patu beto na matadi qarike batabata. Keta mari batabatani na matadi, mari nongonongoro na talingadi, beto mi tavagigala na bulodi ko mari gabala mule lame ko ara ma salanaria,> za gua na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ba gamu gamu tamana za gamu, ura gamu boka dogodogoro vatavagigala beto na nonongoro vakoititi. ");
INSERT INTO ghn_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ura ma poja zozotodigamu ara za gamu: na zoku ria na tinoni korokorotai beto ria na tinoni tuvizidi pa moa za qari nyoroguani ko bari batiria ba bari nongoria ria qe gua na zakazava gamu batiria beto gamu nongororia gamu ari, ba qarike boka,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","<<Ego mu vainongoroni za na ginuana na vavakato vavapadana na tinoni umuma. ");
INSERT INTO ghn_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Na tinoni za nongoria na nongorona na binangara tana Tamaza ba zake vakaberia za lame na kutana nikerena ko za teku pale za na nongoro za tavavuvuzu pa bulona. Na tinoni aza za vei na kiko za tavavuvuzu pa lodaka zona. ");
INSERT INTO ghn_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Goto na kiko za tavavuvuzu pa pezo buturuna, za vei tugu na tinoni tonai za nongoria na nongoro nari zake oriavo tugu teku qeraqerani. ");
INSERT INTO ghn_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ba zake bagere valeana pa nana toa makana ko zake kole zovai pa nana toa. Ko tonai za raja za na tapata beto qari komitia na tinoni pa ginuana vei za vazozotoa na nongoro aza, nari zake oriavo tugu lotunana. ");
INSERT INTO ghn_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Goto na kiko za tavavuvuzu pa gazoro varivarioka, za vei na tinoni za nongoria na nongoro ba na tapatiana qari kole pa toa beto na roqu totodi na izizongo pa pezo za pilua za na nongoro aza ko zake vua valeana. ");
INSERT INTO ghn_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Goto na kiko za tavavuvuzu pa pezo masuruna za vei na tinoni za nongoria na nongoro beto za vakaberia. Aza za vua valeana ko za vua gogoto, na vonomongavulu beto na uengavulu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ego za vavakatoni mule i Jisu tadiria za maka vavakato vavapada, ari za gudi vei, <<Na binangara pa noka za maka moqaza podeke vei tonai za keni vavuvuzia na kiko leana pa nana inuma za maka tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ba maka bongi totonai qari korapa puta beto ria doru tinoni za kamu za maka nana kana, ko za vavuvuzu vavarisomanai laodi na kiko ikikeredi za ketakoi za tori tavavuvuzu tu za na kiko leadi, beto ko za turu ko za keninana. ");
INSERT INTO ghn_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tonai qari pidoko za na umuma ko qari podalai vua, nari za qari tabata pikata ria na buruburu ikikeredi qari toa varisomanai. ");
INSERT INTO ghn_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nari qari lao tana tinoni porenana inuma ria na pinauzu, ko ari qari gua vei, <Bangara, beko na kiko leadi gu za qu vavuvuzuria ao pa mua inuma, uve? Ko pae na koko lame veidi ria na buruburu ikikeredi qari toa pa inuma?> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nari za oe lao aza, <Na kana za roiti vei ani,> za gua aza. Nari qari paranga ria na pinauzu, <Ko ae vei qu nyoroguadigami ko mami keni sobusobulu paledi ria na buruburu ikikeredi?> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ba za paranga za na tinoni porenana inuma, <Dai, ura vei muna sobulu paledi gamu koviria, za pala muna sobulu kale tavitidi kaki umuma leadi. ");
INSERT INTO ghn_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Goto loiria ko mari makarai toa varikamudia tinganai mina kamua na totozo ababu. Totonai tu mina kamua na totozo ababu, za pala mana garunuria ara ria na tinoni ababu, ko mari sobulu momoe paledi ria na buruburu ikikeredi, beto mari piu varivarikamudi ko mari vato paledi pa iku. Beto za mari tubo varikamudi ria na vua matua leadi ko mari vakoleria pa qua ruma vavakole ganiganina,> za gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Beto za vavakatoni mule i Jisu tadiria za maka vavakato vavapada, ari za gua vei, <<Na binangara pa noka za maka moqaza podeke vei maka kiko masitadi za tekua maka tinoni ko za vavuvuzia pa nana inuma. ");
INSERT INTO ghn_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Za peki joladi doru kiko aza, ba totonai za toa za lavata joladi doru umuma pa inuma. Ko za juki suvege lavata ketakoi aza, ko qari tatava kamu na manugu ko qari okoto roitidia vorivori na alale pa doru kaena,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Beto za vavakatoni mule i Jisu tadiria za maka vavakato vavapada, ari za gua vei, <<Na binangara pa noka za vei na vavakovuruni palava za tekua maka reko ko za qaliri varisomanaini pa kue bakete palava, ko za kovuru iolo beto tu za na palava doruna,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Za kole varivagigalai laonana gu pa vavakato vavapada i Jisu totonai za kole varivagigalai tadiria na minete tinoni. Ko kepore za maka nana vavakato lao tadiria bike vavapodeke pa vavakato vavapada. ");
INSERT INTO ghn_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Za roiti vei ari aza ko za vagore votua za aza vei za pojai na tinoni korokorotai, ari za gua vei, <<Mana paranga pa vavakato vavapada ara. Mana uledi ria na zakazava qari pae podalai tu na kasia guguzu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ego beto za taloi tadiria na minete tinoni i Jisu ko za luge pa leo ruma, nari za qari lao nanazia ria na nana sepele aza, ari qari guni vei, <<Mu ule vadigami na za ginuana za na vavakatona na buruburu ikikeredi pa inuma,>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nari za oe laoria i Jisu ria, ari za gua vei, <<Aza za vavuvuzia na kiko leana za na Tuna na Tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Na inuma za na kasia guguzu, ria na kiko leadi ria na tinoni pa binangara tana Tamaza, goto ria na buruburu ikikeredi za ria na tinoni tana kutana nikerena. ");
INSERT INTO ghn_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Na kana aza za umadi ria na buruburu ikikeredi za na bangaradi na tomete. Na totozo ababu za na vinabetona na totozo, goto ria na tinoni ababu ria na mateana. ");
INSERT INTO ghn_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Maka moqaza podeke vei qari tatubo varikamu ria na buruburu ikeredi ari ko qari tavato pale pa iku, za mina vei putaputa tugu aza za mina taroiti pa vinabetona na totozo. ");
INSERT INTO ghn_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Na Tuna na Tinoni mina garunuria ria na nana mateana ko mari mijata paledi pa nana binangara ria doru zakazava varivatatupe beto ria qari roiti vasela. ");
INSERT INTO ghn_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ko mari tagona valao pa leo iku memea ria ko ketakoi mari suvere lukana uui beto mina ngingizi tu na livodi. ");
INSERT INTO ghn_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Goto ria na tinoni tuvizidi za mari tolanga vei na kaberena na tapo pa binangara tana Tamadi. Aza za kolenana talingana za mi vainongoro valeana!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","<<Na binangara pa noka za vei maka izizongo poreveveina kole golomona pa maka kobu pezo. Totonai za batia maka tinoni za na izizongo ani nari za amu vakole golomo sogai, beto ko za taloi qeraqera ko za keni vavai betodi ria doru zakazava za izongoria ko za vai tekua na nana za na kobu pezo aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","<<Na binangara pa noka za vei mutugu maka tinoni za nyaqo ukukeria na patu leleadi na poreveveidi. ");
INSERT INTO ghn_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ko tonai za batia maka aza za batabata lea jola, nari za lao ko za vavai betodi ria doru nana zakazava ko za vaitekua na nana za na patu batabata lea jola ani,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","<<Na binangara pa noka za vei mutugu na vaqara za taipa lao pa kolo ko kubo okokoto iganadi za qari kura pa leona. ");
INSERT INTO ghn_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Totonai za pugelia na igana za na vaqara, za qari bako vaparoa pa parona ria na tinoni abu ko qari kole mijataria ria na igana. Ria na leadi za qari kuradi pa kurakurana, goto ria nake leadi za qari gona paledi. ");
INSERT INTO ghn_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ko pala zara tugu mina vei za pa vinabetona na totozo. Ria na mateana za mari votu lao ko mari mijata paledi ria na tinoni ikikeredi qari varisomanai tadiria na tinoni tuvizidi. ");
INSERT INTO ghn_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ko mari tagona valao pa leo iku memea ria ko ketakoi mari lukana uui beto mina ngingizi tu na livodi,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ego beto za nanazaria i Jisu ria na nana sepele, ari za gua vei, <<Ae vei, gamu gilagilaimiu tugu gamu ria na varivagigalai ari?>> za gua. Nari za, <<E,>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nari ari za gudi vei, <<Ego ko za vei za, ria doru tinoni varivagigalai pa Vavanau ti Mosese qari tavagigalaini na veveina na binangara pa noka za qari vei na tinoni za vavoturia pa nana lose kopukopuni zakazavana ria na varivagigalai koregadi beto na leludi,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ego ko pa liguna za beto varivagigalaidi i Jisu ria doru vavakato vavapada ari, za taloi pa ia aza aza, ");
INSERT INTO ghn_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ko za lao pa nana guguzu ketakoi za lavata zae ko za varivagigalai aza pa ruma varivarikamuna ketakoi. Ko qari gabara beto ria doru totonai qari nongoria na nana varivagigalai. Ko qari paranga ria, <<Pae za tekuni na bangara ani ria na gigigalai beto na roiti varivagabaradi veveidi zara? ");
INSERT INTO ghn_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Taqe gilagilainada gu gita za na tinoni ani! Na tuna gu na kamada ani! Na izongona na tinana i Mere gu ke! Ko ria na taina marene ari Jekopi i Josepa i Saimone beto i Jiudasi gu ke! ");
INSERT INTO ghn_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ko ria na luluna reko ba qari korapa gu suvere tavitigita ari! Ko na tinoni ani pae za butidi aza ria na varivagigalai beto na roiti veveidi zara?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ko qari kilu pale ria aza. Ba ari za gudi vei Jisu ria, <<Na tinoni korokorotai pa nana guguzu ketakoi za lavata zae gu beto pa nana tatamana gu za zake tatavaragua, goto pa goto guguzu tu za tatavaragua,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ko zake roitidi zoku roiti varivagabaradi pa ia aza i Jisu, ura koko vei ria na tinoni qarike vazozotoa aza. ");
INSERT INTO ghn_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pana totozo ria za nongoroni i Herodi, na bangara pa ia pa Qalili, za na vavakatona i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ko za pojadi ria na nana tiolata lavalavata, ari za gudi vei, <<I Jone Paputaiso zozoto gu ani!. Za toa mule pa uke! Ko za vei za izongia aza za na neqi ko za boka roitidi aza ria na roiti varivagabaradi,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ari za roquroqu vei aza ura perangaina tu za tori garunuria tu i Herodi ria nana tinoni ko qari piua i Jone Paputaiso ko qari valugea pa ruma varipiu. Za tapiu aza pa ginuguana gu i Herodiasi na maqotana i Pilipi na taina. ");
INSERT INTO ghn_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ura kaki totozo qari lao rari za vapoja zozotoni i Jone Paputaiso i Herodi, ari za guni vei, <<Zake tavamalumu pa Vavanau za qu vei ao qu elavia i Herodiasi, ura na maqotana tu na taimu aza,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ko pa ginuana aza za i Herodi za nyorogua vaukea i Jone, ba za matagutudi ria na tinoni Jiu ura ria na tinoni Jiu qari vazozotoa za maka tinoni korokorotai tugu i Jone qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ego ba totonai za kamu za na rane podo ti Herodi, za na tuna reko i Herodiasi za lao kole pekapeka pa moedi ria na tinoni qari tasoru valame pa varikamu. Ko za qera vitivitigini i Herodi za na pekapekana aza, ");
INSERT INTO ghn_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ko za ule votu tarini na maulu aza za doru zakazava mina tepai aza za mina vani gu za guni za na reko ani. ");
INSERT INTO ghn_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ko pa roquroqu tana tinana za lao ti Herodi za na reko ko za tepa vei ari, <<Mu petalani pa maka peleta ko mu vaniziu koviria tugu za na batuna i Jone Paputaiso,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Za takulanga vitivitigi i Herodi tonai za nongoria na tepa tana reko, ba za tori maulu vakole tu pa moedi ria na tinoni za soruria, ko za pojadi gu ria na nana tinoni ko mari vani gu aza vei za tepai na reko za gua. ");
INSERT INTO ghn_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ko za garunuria aza ria kaki nana tinoni varipera, ko qari lao kujukia pa ruma varipiu i Jone Paputaiso. ");
INSERT INTO ghn_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Beto za qari petalani pa maka peleta za na batuna ko qari pogozo kamu vani za na reko, beto za aza za lao vani za na tinana. ");
INSERT INTO ghn_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pa liguna aza za qari lao pogozia ria nana sepele za na kobukobu tinina i Jone, ko qari keni golomia. Beto za qari keni pojani i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ego totonai za nongoroni i Jisu za na veveina i Jone Paputaiso, za taloinana ketakoi pa maka koaka aza ko za keni vakaloinana pa maka ia kaloina. Ba tonai qari nongoro ria na minete tinoni za aza, za qari turu loidi ria na dia guguzu ko qari are tutia i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Totonai za tete paro i Jisu, za batia za na puku minete tinoni lavata, ko za roquroqu vitivitigiria aza ria ko za salanaria tugu aza ria qari mo. ");
INSERT INTO ghn_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Totonai za gore za na veluvelu za qari lao ria na nana sepele ko ari qari guni vei, <<Koi, na ia kaloina kepore tinonina za pani beto ko za tori papaka vitivitigi tu za na rane. Ae vei bu garunu vakeniria tu tinganai vei guguguzu ria na tinoni ari ko bari keni vaigedi ganigani makadi,>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nari ari za gudi vei i Jisu ria, <<Nake padadi mari keni ria ari, goto gamu makamiu za mu iadi kaki tekutekuna,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nari za qari paranga ria na nana sepele, <<Aza tugu ka lima batu bereti peki gu beto kori igana gu za ari,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","<<Ego mu pogozo lamedi pani,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Beto za pojadi aza ria doru na tinoni ko qari nyumu beto pa buruburu, beto za tekuria za ka lima bereti beto kori igana, ko za enga zae pa noka beto za paranga leanadi. Beto za kipakiparia za na bereti ko za vadi ria na nana sepele, ko ria na sepele qari iaria ria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ko qari tekuteku ko qari pote beto ria doru tinoni. Beto za qari tekuria ria na sepele za ka manogori topa ko qari vapugele nyonyoadi na kipakipa ganigani kole joladi. ");
INSERT INTO ghn_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Na ngutidi ria na marene qari tekuteku ari ka lima vuro, goto ria na reko beto ria na koburu za qarike tanguti. ");
INSERT INTO ghn_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ego pa liguna tugu aza, za pojadi i Jisu ria na nana sepele ko mari zae pa koaka ko mari karovo lao momoe pa maka kale karovona na ovuku, goto aza mi suvere ko mina garunu vamuleria mae na tinoni pa okotodia guguguzu za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pa liguna za vakeni betoria na tinoni, za zagere zae pa maka kubo makana aza ko za varavara. Ko totonai za gore na veluvelu, za kole tugu suverenana makana ketakoi aza. ");
INSERT INTO ghn_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ko tonai za tori zou lao tu pa korapa kolo za na koaka, ko za vaqevulu lao lameni na boguzu za na koaka, ura na gava turu koimoa za viva. ");
INSERT INTO ghn_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ego ko pa varikorapaina kue koloko volavolaza ko za lao kamu pa vonomo koloko volavolaza lea za rerege tuti lao pa vuliti kolo i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Totonai ria na sepele qari batia aza za korapa rerege lame pa vuliti kolo, za qari takulanga vitivitigi ria, <<Koi, maka tomete za lamegana ani!>> qari gua, ko qari velavela gagateana. ");
INSERT INTO ghn_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nari zake oriavo tugu parangaria i Jisu, ari za gua vei, <<Mu varene! Ara gu ani, muke matagutu!>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nari za paranga lao i Pita, ari za guni vei, <<Bangara, mina vei ao zozoto tugu zana, za mu kukuziu ko ma rerege lao tamu pa vuliti kolo,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","<<Leana, mu rerege lame gu,>> za gua i Jisu. Nari za taloi tugu pa koaka i Pita ko za podalai rerege lao ti Jisu pa vuliti kolo. ");
INSERT INTO ghn_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ba totonai za vagilagilai i Pita za na giburuna na gava nari za matagutu ko za podalai dururu, nari za uui, <<Bangara, mu aloziu!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Aza tugu za paranga vei zara i Pita nari za kaqama lao aru tamania i Jisu za na limana aza beto ari za guni vei, <<Za peki jola za na mua rangerange! Ae za vei ko qu orirabeke ao?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ko totonai qari zae beto pa koaka ari kori doru, za nogoto betonana za na gava. ");
INSERT INTO ghn_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ko ria na sepele pa koaka za qari vatarazaea i Jisu, ari qari gua vei, <<Zozoto jola za ao tugu za na Tuna na Tamaza,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ego qari karovia ria za na ovuku Qalili ko qari lao paro pa guguzu pa Qenesareti. ");
INSERT INTO ghn_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ko qari dogoro gigalia ria na tinoni pa ia aza i Jisu, ko qari vareregia pa varilivutaina na guguzu lavata aza za na nongorona aza, ko qari okoto toka kamudi ti Jisu ria doru tinoni qari mo. ");
INSERT INTO ghn_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ko qari tepa jujukia i Jisu ko mari boka ulia gu za na uquna nana poko qari gua. Ko ria doru tinoni momodi qari ulia na uqu poko tana, za qari tasalana beto tugu. ");
INSERT INTO ghn_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ego pa liguna aza za na koko veidi pa Jerusalema qari kamu ria kaki Parese beto ria qari varivagigalaini na Vavanau ko qari lao nanazia i Jisu, ari qari gua vei, ");
INSERT INTO ghn_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","<<Ae za vei za ria na sepele tamu za qari majai na uana tututi tadiria na nada tite? Ura qarike loqa lima momoe mae beto qari tekuteku,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nari za oeria i Jisu, ari za gudi vei, <<Goto gamu za ae za vei ko gamu majai za na garunu tana Tamaza ko gamu tutia gu gamu na miu uana tututi makamiu? ");
INSERT INTO ghn_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ura za paranga za na Tamaza, <Mu valavatia na tamamu beto na tinamu,> za gua, beto ko, <Aza za poja vikevikeria na tamana beto na tinana za mina tavauke,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ba gamu za gamu paranga tu za vei maka tinoni bi parangia na tinana babi na tamana, ari biguni, <Na zakazava ani za pada ba boka tokanigo ao, ba qa tori valao vani tu na Tamaza ara,> bi gua, ");
INSERT INTO ghn_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","nari za <Minake kilu valavatia aza za na tinana na tamana ba leana gu,> gamu gua za gamu. Ko pa zona vei ani za gamu vakeporea gamu za na paranga tana Tamaza, ko gamu tutia gu gamu na miu uana tututi makamiu. ");
INSERT INTO ghn_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Na tinoni jola vavabatamiu na sekesekemiu za gamu! Za zotonana gu za i Aisea tonai za ululeni na veveimiu gamu: ");
INSERT INTO ghn_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","<Ria na tinoni ari za qari valavataziu ara pa beruberu ngujudi gu, goto na bulodi za zou vitivitigi taqu. ");
INSERT INTO ghn_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Na goborona gu za na dia vinatarazaequ ara, qari varivagigalaidi na varivagigalaidi na vinaturu tadiria na tinoni gu,> za gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ego beto za kuku valameria i Jisu ria na minete tinoni, ko ari za gudi vei, <<Mu vainongoro ko mu vakoititia za aza vei mana pojai ara! ");
INSERT INTO ghn_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nake aza za teku ponyolia pa ngujuna na tinoni za vapajia za na nana toa, goto ria tu na zakazava qari votu lame vei pa ngujuna za qari vapajia aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Beto za qari lame ti Jisu ria na nana sepele ko ari qari guni vei, <<Qu gilagilaimua tugu beka ao za qarike qerani ria na Parese ria vei qu pojaria ao?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nari za oeria i Jisu, ari za gudi vei, <<Doru umuma zake umadi na Tamaqu pa noka za mari tasobulu gonagona pale beto. ");
INSERT INTO ghn_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ko muke pavu takulangadi ria. Ria na tinoni varitoka nake batabatadi ria. Ba vei na tinoni varitoka nake batabatana za mina titai za maka tinoni nake batabatana mutugu, za pala ari kori doru za mari makarai lotu beto pa maka oqili,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nari za oe lao i Pita, ari za guni vei, <<Mu vakabere valeania tadigami za na varivagigalai qu pojadi,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nari ari za gua vei i Jisu, <<Ko gamu ba gamu korapa tugu rururamiu za? ");
INSERT INTO ghn_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Gamuke vakoinonoa tu gamu za na zakazava za gania pa ngujuna na tinoni za gore gu kole pa borina na tinoni beto za votu keninana gu? ");
INSERT INTO ghn_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Goto ria tu qari votu vei pa nguju za na koko veidi pa bulo, ko ria tu za qari vapajia na toa tana tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ura na koko lame veidi pa bulo ria na roquroqu ikikeredi, na varivai, na barabarata, na toa lulasana, na ikiko, na jutu sekesekeria na goto tinoni, beto na poja vikevikereria na goto tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ari tu ria qari vapajia na toa tana tinoni. Goto nake loqa lima mae beto na tekuteku za zake vapajia na toa tana tinoni aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ego za iolo ketakoi i Jisu ko za taloi keninana pa pikata ia pa Turosi beto pa Sidoni. ");
INSERT INTO ghn_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ko za taloi lame za maka reko Kenani na suvesuverena pa guguzu aza, ko za kuku lukalukana lao ti Jisu, <<Kei, Bangara! Ao na Tuna i Devita! Mae ko mu roquroqu tokaniziu! Na tuqu reko za lugea na tomete ikikerena, ko za mo vitivitigi,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ba zake pavu vagalani i Jisu aza. Beto qari lame ria na sepele ko qari kole tepa tokatokai ari qari guni vei aza, <<Mu iju vamule kenia! Za korapa lukana tututigita gita zana!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nari ari za gua vei i Jisu, <<Ara za qa tagarunu ko mana lao tadiria na tinoni Izireli gu qari muma vei na sipi,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Totonai za rerege lao tu za na reko ani ko za lao nyumu sori tungutungu pa moena i Jisu ko ari za gua vei, <<Tokaniziu, Bangara!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nari za oe i Jisu, ari za guni vei, <<Nake leana za bi tateku za na ganigani tadiria na koburu ko bi tavalao vadi na sie tapauzudi pa ruma,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nari ari za gua vei za na reko ani, <<Zotomua tugu Bangara, ba ria na sie pauzudi ba qari kole gu adono ganigani vuvuzudi pa tevolo tadiria qari pauzuria,>> za gua za na reko. ");
INSERT INTO ghn_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nari za oe i Jisu, ari za guni vei, <<Koi tinaqu, na lavatana jola za na mua vazozoto! Mi taroiti vanigo tu ropi za aza vei qu nyoroguani ao,>> za gua. Ko na totozo tugu aza za za tasalana za na tuna reko aza. ");
INSERT INTO ghn_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ego za taloi ketakoi i Jisu ko za poana vei pa ovuku Qalili, beto za zagere zaea aza za maka kubo ko za nyumu ketakoi. ");
INSERT INTO ghn_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ego ko qari varikamu lame tana ria zoku pukupuku minete tinoni. Qari okoto toka lamedi tana ria qari qao, ria za uke kale kaki kobu tinidi, ria nake batabatadi, ria na poka beto kubo tinoni mo mule. Ko qari lao loiria pa kekerena i Jisu, ko za salana betoria i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ko qari gabara beto ria na tinoni tonai qari batia na poka za paranga, ria za uke kale na tinidi qari leana soga, na qao za rerege beto nake batabatadi ba qari batabata. Ko qari vatarazaea ria za na Tamaza tadiria na tinoni Izireli. ");
INSERT INTO ghn_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ego za kuku tekuria i Jisu ria na nana sepele ko ari za gudi vei, <<Qa roquroqu vitivitigiria ara ria na tinoni ari, ura tori kue ranedi tu za qari kole tututi taqu ko koviria za kepore maka zava mari tekua. Qake nyoguani ara za ba garunu vakeni buraburanaria, ura pala mari rake ko mari tabulobulo pa zona,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nari qari paranga ria na nana sepele, <<E, ba na minete tinoni lavata ani ko pae tana boka teku ganigani ko tana vatekuteku vapoteria za pa ia kaloina vei ari?>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","<<Ka viza bereti za gamu izongia?>> za gua i Jisu. <<Ka vitu gu, beto ko ka viza igana pekipekidi gu,>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nari za pojadi i Jisu ria na minete tinoni ko qari nyumu beto pa pezo. ");
INSERT INTO ghn_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Beto za tekuria aza za ka vitu bereti beto vei tugu na igana, ko za paranga leanadi, beto za kipakiparia, ko za vadi ria na sepele ko ria na sepele qari ia lao vadi na minete tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ko qari tekuteku beto ria doru tinoni, ko qari pote valeana beto. Beto za qari tekuria ria na sepele za ka vitu topa, ko qari vapugele nyonyoadi na ganigani kole joladi. ");
INSERT INTO ghn_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ko na ngutidi ria na tinoni qari tekuteku ari ka made vuro na marene, goto ria na reko beto ko ria na koburu za qarike tanguti. ");
INSERT INTO ghn_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ego ko pa liguna za garunu vamule keniria i Jisu ria na minete tinoni, nari za lao zae pa koaka aza, ko za toka lao vei tu pa guguzu Magadani. ");
INSERT INTO ghn_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ego qari lame dogoria i Jisu ria kaki Parese beto ko na Sadusisi ko mari vagonai aza qari gua, ko qari garunia aza ko mi roiti vavotu vadi maka roiti varivagabarana jola tana Tamaza, ko vei za mari vazozotoa na koko lamena tugu tana Tamaza aza qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ba za oeria i Jisu ria, ari za gudi vei, <<(Totonai za gore na veluvelu, za ari gamu gua vei za gamu, <Koi, pala mina bule za na kota, ura za maqarea na oka!> gamu gua. ");
INSERT INTO ghn_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Goto na volavolaza za ari gamu gua vei, <Koi, pala mina okoro za pa ngenari, ura za varodomo beto za dudurumana za na oka,> gamu gua. Gamu boka dogoro gilagilai gamu za ae mina vevei na vavagalo kota tonai gamu dogoria na oka, goto gamuke boka dogoro gilagilai gamu ria na vinagilagila pa totozo koviria.) ");
INSERT INTO ghn_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ao na zazae tinoni ikikeremu beto na vakevakeporea na Tamaza za gamu korapa nyoroguani maka roiti varivagabarana jola? E, ba kepore za maka roiti varivagabarana muna tavadogoroni, goto aza tugu na roiti varivagabarana muna tavadogoroni gamu za makana gu na roiti varivagabarana za taroiti ti Jona na tinoni korokorotai,>> za gudi. Beto za loiria ria ko za keninana. ");
INSERT INTO ghn_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Totonai qari toka karovo lao pa maka kale karovona na ovuku za qari roqu muma ria na sepele, ko qarike pogozo bereti besa. ");
INSERT INTO ghn_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nari ari za gudi vei i Jisu, <<Muna balauni na vavakovuruni palava tadiria na Parese beto na Sadusisi,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Totonai qari nongoria za gua vei zara aza, za qari kole variparanga mule makadi ria, ari qari gua vei, <<Taqeke pogozo bereti gita za korapa paranga vei zara,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ba za tori gilagilainana tu i Jisu aza na manugu qari kole pojai ria, ko ari za gudi vei, <<Ae za vei ko gamu korapa varivariparangani gamu za aza na veveina kepore gemiu bereti? Za peki jola na miu rangerange za gamu! ");
INSERT INTO ghn_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ae vei, gamu oqoro tugu vakoinonoa gamu? Gamuke roqu vakoititia tu gamu za totonai qa kipakiparia ka lima bereti ara, ko qa iadi ari ka lima vuro tinoni? Ka viza topa za gamu vapugeledi na ganigani kole joladi gamu totonai? ");
INSERT INTO ghn_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ko ae za vei za ka vitu bereti tonai qa iadi ari ka made vuro tinoni? Ka viza topa za gamu vapugeledi na ganigani kole joladi gamu totonai? ");
INSERT INTO ghn_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ae za vei ko gamuke boka vakoinonoa tu gamu za nake bereti za qa korapa guni ara? Mu kopu muledigamu pa vavakovuruni palava tadiria na Parese beto na Sadusisi,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tonai za qari gilagila kamua ria na sepele za nake veveina na vavakovuruni palava bereti za korapa vabalau muledi aza, goto na varivagigalai tu tadiria na Parese beto na Sadusisi za guni aza. ");
INSERT INTO ghn_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ego za taloi keni i Jisu ko za lao pa maka ia tata pa guguzu lavata pa Sizaria Pilipae. Ko ketakoi za nanazaria i Jisu ria na nana sepele, <<I zei qari guni ria na tinoni za na Tuna na Tinoni?>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nari ari qari gua vei ria na sepele, <<Kaki qari paranga i Jone Paputaiso qari gua, kaki i Elaija qari gua, kaki i Jeremae ba palu maka ria kaki goto tinoni korokorotai qari gua,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nari ari za gudi vei, <<Goto gamu za i zei gamuguniziu ara?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nari za oe i Saimone Pita, ari za gua vei, <<Ao za na Karisito, na Tuna na Tamaza toana,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nari za oea i Jisu, ari za guni vei, <<Na tamanamu ao Saimone na tuna i Jona! Na zozoto aza za nake ria na tinoni qari ule vanigo ao, goto za ianigo zozoto na Tamaqu tu ara pa noka. ");
INSERT INTO ghn_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma pojanigo ara ao: i Pita ao, na ginuana nizongomu za na Patu, ko pa patu kokovana tugu ani za mana vaturua ara za na qua ekelesia, ko na neqi tana uke minake boka vakilasia za na ekelesia. ");
INSERT INTO ghn_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mana vanigo ara ria na vidulu revangana na binangara pa noka, ko aza vei qu pukua ao pa pezo za mina tori tapuku tugu pa noka, beto ko aza vei qu ruvatia ao pa pezo za pa noka ba mina tori taruvata tugu,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Beto za naquria i Jisu ria na nana sepele ko marike vatavatarangeni za na veveina aza tugu za na Karisito za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ego ko podalai tugu pana totozo aza za podalai vavakato vakabere valeleanani i Jisu tadiria na nana sepele za na veveina nana vitigi. Ko ari za gudi vei, <<Pala mana gore pa Jerusalema ara, ko mana gozoria na vitigi tadiria na tiolata matamata, na kuta iama, ria qari varivagigalaini na Vavanau, beto ko mana tavauke. Ba pa vinaue rane mana turu mule pa uke,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nari za toka kaleni i Pita i Jisu ko za tokea, ari za guni vei, <<Zake vamalumia na Tamaza za vei aza, Bangara! Minake izongo taroiti tamu za vei zara!>> za gua i Pita. ");
INSERT INTO ghn_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nari za bata kekeria ko ari za guni vei i Pita, <<Rijo keni taqu, Setani! Ao za na kobukobu varivatatupe pa moequ ara, ura ria na roquroqu ari za nake lame veidi tana Tamaza, goto tana tinoni gu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Beto ari za gudi vei i Jisu ria na nana sepele, <<Na tinoni za nyorogua tutiziu ara, za mi roqu muma paleni makana, mi pogozia na nana korosi ko mi tutiziu ara. ");
INSERT INTO ghn_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ura aza za nyorogua kopu valeanani na nana toa makana za pala mina saivia tugu za nana toa. Goto aza za gona pale na nana toa pa ginuana za tutiziu ara za mina batia tugu na toa. ");
INSERT INTO ghn_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Na za mina vagavoria na tinoni vei bi gona pale na nana toa ko bi izongia za na kasia gugusu doruna? Bi julingai tu! Ko na za mina roitini aza ko mina boka teku sogai za na nana toa? Bi mija tu! ");
INSERT INTO ghn_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ura nake zovaina mina lame za na Tuna na Tinoni beto ria na nana mateana. Pala mina lame pa neqi tana Tamana ko mina okoto vadi na pinia padana na dia roiti ria doru tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ma poja zozotodigamu ara gamu: kaki gamu gamu korapa turu tavitiziu ara ari za mari oqoro uke, za mari batia za na lamena na Tuna na Tinoni mina lame vei na Bangara,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ego za jola gu ka vonomo rane, za tokai i Jisu i Pita beto ari Jekopi i Jone kori tamatazi, ko qari zagere zae pa maka kubo ululuna ko qari kole suvere makadi ketakoi. ");
INSERT INTO ghn_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ko tonai qari dogoro laoa i Jisu za dogoro goto za na tinina. Na izumatana za tolanga vei na tapo, goto na nana poko za keka valavalaka. ");
INSERT INTO ghn_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Beto ani! Qari bola votu kamuria ari Mosese i Elaija ko qari kole paraparangia i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nari za paranga i Pita, ari za guni vei i Jisu, <<Bangara, za vavagua jola za taqe suvere gita pani! Vei muna valeania ao, za ara ma roitini kue aqaqo; ko maka tamu, maka ti Mosese, beto maka ti Elaija,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ko za korapa tugu paraparanga vei zara i Pita, za lame maka lei keala ko za amu vapaeria ria doru. Beto qari nongoria za maka mamalaingi pa leona na lei ari za gua vei, <<Ani za na Tuqu qa roquroqua beto qa qera vitivitigini ara. Mu nongoria aza!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Totonai qari nongoria ari kue sepele za na mamalaingi nari za qari matagutu vitivitigi, ko qari gona nyumu pa pezo ko qari todongo. ");
INSERT INTO ghn_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nari za lao i Jisu ko za uliria ari kue, beto ari za gudi vei, <<Turu, muke matagutu!>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ko tonai mari enga qari gua za kepore mule za maka tinoni bari batia goto i Jisu gu makana. ");
INSERT INTO ghn_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tonai qari korapa mule gore na kokodi pa kubo, za naquria i Jisu ari kue, ari za gudi vei, <<Munake vavakatoni tana maka tinoni za na dogodogoro vei gamu batia gamu, koi vei tu mina tavaturu mule pa uke za na Tuna na Tinoni,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Qari nanazia ria na sepele i Jisu, ari qari gua vei, <<Ae za vei ko qari paranga ria qari varivagigalaini na Vavanau pala i Elaija tu za mina mule lame momoe mae tonai mina oqoro kamu na Mesaea?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nari za oeria i Jisu ria, ari za gua vei, <<E, i Elaija za mina lame momoe tugu ko mina vatana vatuvizi momoeria za doru zakazava. ");
INSERT INTO ghn_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ba ma pojadigamu gamu: za tori mule lame momoe tu i Elaija, ba qarike dogoro gilagilai ria na tinoni aza, ko qari ngangangulu veini aza qari nyorogua veini. Ko na Tuna na Tinoni ba pala mari ngangangulu veini mutugu ria na tinoni,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ego ko ketakoi za qari gilagila vakabere valeania ria na sepele za i Jone Paputaiso gu za guni aza. ");
INSERT INTO ghn_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ego totonai qari gabala mule kamu tadiria na minete tinoni ria, za lao gona nyumu sori tungutungu pa moena i Jisu za maka tinoni, ");
INSERT INTO ghn_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ko za paranga, <<Bangara, mu roquroqu tokani na tuqu marene! Za vavaini na mo kirenge ko za vavaaru vikereni ko kaki totozo za valotu laoa tugu pa iku beto pa kolo. ");
INSERT INTO ghn_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Qa tori toka laoni tugu tadiria na mua sepele ba qarike boka salania,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nari za oea i Jisu, ari za guni vei, <<Koi, gamu na zazae tinoni gamuke vazozoto beto gamuke gilagilai na tuvizi! Ae tu mina koi vei zovai vei za mana kole suvere tavitigamu na tapatianadigamu ara za gamu? Mu toka lameni taqu za na marene zana!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Beto za iju pale i Jisu za na tomete ikikerena za kole tana marene, ko za votu keni tana, ko za tasalana tugu na totozo aza aza. ");
INSERT INTO ghn_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Beto za tonai qari suvere makadi tu za qari lame ti Jisu ria na sepele ko qari nanaza, <<Ae za vei ko gamike boka iju votuni gami za na tomete zana?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nari ari za gudi vei i Jisu, <<Ura koko vei za peki jola na miu rangerange! Ura ma poja zozotodigamu ara gamu: vei bu izongia iapeki rangerange bi podeke pekina vei maka kiko masitadi, za vei bu paranga veini gu ari za na kubo ani, <Mu rijo lao pa nari!> bu gua, za pala mina lao tugu. Kepore za maka zava mina tapatagamu. ");
INSERT INTO ghn_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Na tomete ikikerena veveina zana, za zake tasalana goboro, goto pa varavara beto pa tabutabu tekuteku gu za pala mina boka taiju pale,)>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Totonai qari varikamu pa Qalili ria doru sepele, za ari za gudi vei i Jisu, <<Na Tuna na Tinoni za pala mina tavalao pa limadi ria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ko mina tavauke aza, ba pa vinaue rane za mina toa mule pa uke aza,>> za gudi. Ko qari mamata vitivitigi ria na sepele. ");
INSERT INTO ghn_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Totonai za kamu i Jisu beto ko ria na sepele pa Kepaniami, za qari lao ti Pita ria na tinoni tekuteku takisi ruma zelepade ko qari nanazia, <<Ae za vei za tabaria tugu na miu tinoni varivagigalai za na takisi ruma zelepade?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","<<E,>> za gua i Pita. Aza tugu za luge pa leo ruma i Pita za paranga i Jisu, <<Saimone, na za qu roquroqua ao? I zei za tabatabaria za na takisi tadiria na bangabangara pa kasia abana ani? Ria na tudi zozoto na bangara, ba ria tu na tinoni gotodi?>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nari ari za gua vei i Pita, <<Ria tu na tinoni gotodi,>> za guni. <<Koi, e, leana,>> za gua i Jisu. <<Ko na ginuana aza za ria na tudi zozoto na bangara ko marike tabaria za na takisi. ");
INSERT INTO ghn_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ba zake leana tana vatagigiria na tinoni, ko ao mu keni tu pa kolo ko mu ipani na tali. Muna kao vapodakia ao aza na igana muna vagani momoea ko tonai muna sangana vamangamangai, pala muna batia za maka poata siliva na padana na takisi ruma zelepade tadigita kori. Muna tekua, ko muna lao vadi na takisi tadigita kori,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ego pana totozo tugu aza za qari lao ria na sepele ti Jisu ko ari qari nanaza veini aza, <<I zei za na poreveveina jola pa binangara pa noka?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nari za kuku tekua i Jisu za maka koburu peki, ko za vaturua pa moedi ria, ");
INSERT INTO ghn_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","beto ari za gudi vei, <<Ma poja zozotodigamu ara za gamu: vei munake sogai gamu za na miu toa ko munake toa vei ria na koburu, za munake izongo lugea tugu gamu za na binangara pa noka. ");
INSERT INTO ghn_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Aza na tinoni gu za vapeki mule veini na koburu peki ani, za aza za poreveveina jola pa binangara pa noka. ");
INSERT INTO ghn_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aza za vatoga valeania pa izongoqu ara za maka koburu peki vevei ani za vakamuziu tugu ara,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","<<Ba na tinoni za vatatupea za maka ria na koburu vevei ani za vazozotoziu ara, za leana jola za bi pikoni patu doa lavata na ruana, beto bi keni valupi pale pa kolo lilisina aza. ");
INSERT INTO ghn_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mi takulangagana tu na kasia guguzu ura za kolea na zakazava varivatatupe! Marike koroto na lamedi ria na zakazava varivatatupe, ba mi takulangagana tu aza za valameria na zakazava varivatatupe. ");
INSERT INTO ghn_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ko vei maka kale limamu babi maka kale nenemu za bi vatatupenigo, za mu lomoto vaqopu pale ko mu gona pale! Ura leana jola za nake zavana za bu toa qopuqopumu gu ao beto bu luge pa toa jola. Aza bu vei za leana jolani bu tagona lao doruru kori limamu beto kori nenemu pa iku kole jolana. ");
INSERT INTO ghn_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Beto vei na matamu za bi vatatupenigo, za mu lobiti pale ko mu gona pale! Ura leana jola za bu matamata kale gu luge pa toa jola. Aza bu vei za leana jolani bu izongoria kori matamu beto bu tagona lao maladorurumu pa iku pa heli,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","<<Mu kopuni ko muke dogoro vakepore veveinaia za maka ria na koburu pekipekidi vevei ani. Ura ma pojadigamu: na dia mateana na suveredi doru totozo pa moena na Tamaqu pa noka za kopudi. ");
INSERT INTO ghn_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Ura na Tuna na Tinoni za lame ko mi aloa na tinoni mumana za gua.) ");
INSERT INTO ghn_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ae beka gamu roquroqu veini gamu za na tinoni za izongia maka gogoto nana sipi, ko vei maka ria nana sipi za bi muma? Pala mina loiria mae ari ka siangavulu sia ko mari kole ngojagedi buruburu pa kubo, goto aza mina keni ko mina nyaqoa za aza na sipi za muma. ");
INSERT INTO ghn_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ko tonai mina bati sogai za na nana sipi za muma za ma poja zozotodigamu ara gamu: na nana qerana na sipi za muma ani za jolani na nana qeradi ari ka siangavulu sia qarike muma. ");
INSERT INTO ghn_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ko maka moqaza podeke vei tugu aza za na Tamamiu pa noka zake nyoroguani aza za maka ria na koburu peki vei ari ko bi muma,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","<<Ego vei bi roitini maka sela tamu za na taimu, za mu lao ko pa varikorapaimiu gu gamu kori makamiu za mu udukia za na nana sela. Ko vei mina nongorigo, nari za qu alo muleni ao za na taimu. ");
INSERT INTO ghn_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Goto vei mina dainana nongorigo, nari za mu toka lao tavitidigo mule za maka babi kori tinoni, ko aza vei za pojai na Kutikuti Tabuna za pa moedi ari kori babi kue tinoni nongonongoro tu mari tavanyumu za doru paranga. ");
INSERT INTO ghn_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ba vei minake nongororia tugu ria qu tokaria, nari za mu ule vani na ekelesia totonai. Ko vei mina dainana tugu nongoria aza za na ekelesia, nari za totonai za mu dogoro veini gu maka tinoni rodomo beto maka tinoni tekuteku takisi aza. ");
INSERT INTO ghn_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ma poja zozotodigamu ara za gamu: aza gamu pukua gamu pa pezo za mina tori tapuku tugu pa noka, beto aza gamu ruvatia gamu pa pezo za pa noka ba mina tori taruvata tugu. ");
INSERT INTO ghn_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ma maka poja zozotodigamu mule ara gamu: vei ari kori tinoni pa pezo gamu za bari varivaegoni za maka zakazava ko bari varavarani, za pala mina roiti vadigamu gu na Tamaqu pa noka aza. ");
INSERT INTO ghn_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ura ketakoi mari suvere varikamu kori babi kue tinoni pa izongoqu ara, nari za ketakoi tugu qa somana suvere ara,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Beto za lao nanazia i Pita i Jisu, <<Bangara, ka viza totozo za maka turaqu mina kole gu roiti lameni na sela taqu beto ara mana kole gu taleozoni aza? Ka vitu totozo?>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nari ari za guni vei i Jisu aza, <<Dai, nake ka vitu totozo, goto ka vitungavuluvitu totozo vitu. ");
INSERT INTO ghn_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ura na binangara pa noka za ari tu za vei. Kolenana za maka bangara za nyorogua vatuviziria na lipulipu tadiria na nana tinoni roiti. ");
INSERT INTO ghn_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aza tugu za podalai dogororia aza ria na lipulipu nari za qari toka valugea gu ria za maka tinoni kolenana lipulipu, ko na zoku gogoto vuro poata nana lipulipu tana bangara aza. ");
INSERT INTO ghn_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ba na nabulu ani za zake ngaolo na nana poata ko zake boka lipu betoria ria na nana lipulipu. Ko ari za paranga veini na bangara aza, <Muna tavavai vei na pinauzu ao, na maqotamu, ria na tumu beto ko dorudi na mua zakazava qu izongoria, ko mina talipu za na mua lipulipu,> za gua za na bangara. ");
INSERT INTO ghn_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nari za gona nyumu sori tungutungu pa moena na bangara za na nabulu ani ko ari za tepa vei, <Koi, bangara muke veiniziu! Mu vaniziu na totozo beto pala mana lipu vaokoto betoria ria na qua lipulipu tamu,> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nari na bangara za roqua gu mule za na nabulu aza, ko za taleozoni gu za doruna nana lipulipu beto za vamalumu kenia. ");
INSERT INTO ghn_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ba beto totonai za taloi ko za votu keni za na nabulu ani, za lao gu gozoria za maka nabulu tavitina aza ka viza poata gu nana lipulipu tana. Za lao ragata tekua ko za rae orangia na ruana, beto ari za guni vei, <Siqarai lipuria na mua lipulipu taqu!> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nari za gona nyumu sori tungutungu mutugu za na nabulu tavitina ani beto za paranga, <Koi, muke veiniziu, mu vaniziu na totozo beto pala mana vanigo gu ria na qua lipulipu,> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ba za dainana za na nabulu ani goto za lao gona valuge pale pa ruma varipiu tinganai mina lipu betoria tu nana lipulipu za gua. ");
INSERT INTO ghn_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ego ko qari dogoro vaia ria kaki nabulu tavitina za aza za roiti vei aza nari za qari takulanga jola, ko qari lao ule vani na bangara aza vei za roitini na nabulu aza. ");
INSERT INTO ghn_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nari za kuku muleni na bangara za na nabulu aza, ko ari za guni vei, <Na nabulu ikeremu jola ao! Ara dorudi na mua lipulipu taqu za qa taleozodigu, ura ao qu tepa taqu. ");
INSERT INTO ghn_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ba ao ae za vei za quke roquroqu tokani za na nabulu tavitimu zana, vei qa roquroqu toka veinigo ara?> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ko za tagigiri vitivitigi za na bangara, ko za valao pale pa ruma varipiu za na nabulu aza, ko mi tavakilasa tinganai mina lipu betoria tu aza ria dorudi nana lipulipu za gua. ");
INSERT INTO ghn_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ko aza zara pala mina okoto veidigamu na Tamaqu ara pa noka za gamu doru vei munake okoto taleozo zozotodi pa bulomiu gamu ria na turamiu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ego totonai za beto varivagigalaidi i Jisu ria na zakazava ari, za taloi pa Qalili aza ko za zae pa ia pikata guguzu Jiudia pa maka karovona na pie Jodani. ");
INSERT INTO ghn_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ko na varikamu tinoni lavata za qari tutia aza, beto ketakoi tugu za salana betoria aza. ");
INSERT INTO ghn_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ego ria kaki Parese za qari lame tana ko qari nyorogua podekia aza. Ko qari gonani na nanaza ria aza, ari qari gua vei, <<Ae vei, na tavamalumuna pa Vavanau za mina boka loi pale maka tinoni za na maqotana pa ae ginugua vei gu za nyoroguani aza?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nari za oeria i Jisu, ari za gudi vei, <<Beko gamu tori tiroamiu tu ba gamu oqoro tu vakaberia gamu za na Kutikuti Tabuna? Ari za gua vei za na Kutikuti Tabuna, <Pa podapodalaina za tori vapodaka vamarenia beto varekoa tu na Tamaza za na tinoni,>' za gua. ");
INSERT INTO ghn_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Beto ari mutu za gua vei, <Ko pa ginuana aza za mina boka taloi tana tinana beto na tamana za na marene ko mina kole maka tana maqotana, ko mari maka gu ari kori,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ko marike pikataori ari kori, ba maka gu. Ko aza vei za tori varipuku taridi tu na Tamaza za kepore maka tinoni mi varivizudi,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nari qari nanaza soga ria na Parese, <<Ba ae za vei ko za varigarununi tu i Mosese za mina boka kutia na marene za maka pepa variloi, beto za mina iju vakeni pale za na maqotana?>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nari za oeria i Jisu ria, <<Na ginuana za vamalumudigamu i Mosese aza za ura koko vei za tapata na tavavanaumiu za gamu. Goto pa podalaina za zake vei zara za. ");
INSERT INTO ghn_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ko ara za ari ma poja veidigamu: bike varivariputa taviti goboro za na maqotana maka marene, ba bi lao na marene ko bi loi pale za na maqotana aza ko bi elava sogai mule maka goto reko, za loi pale tugu za na marene aza, za barabarata tugu na marena aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nari qari parangia ria na nana sepele, <<Vei mina aza za na ginuana vei na marene mina boka loia na maqotana, nari za leana jola za mike pavu varielava za na tinoni,>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nari za oeria i Jisu ria, <<Nake ria doru tinoni mari boka tekua za na varivagigalai ani, ba ria gu za tori vadi tu na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ura koledia za kubo okokoto ginugua vei beto qarike boka varielava ria na tinoni: kaki na podo veidi tu, kaki na tinoni gu qari moge vaegoro veini paledi, goto kaki qarike varielava ura qari nyorogua nabulu vani na binangara pa noka. Na tinoni mina boka tekua na vavanau ani za mi tekua tugu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ego ria kaki za qari toka laodi ti Jisu ria na koburu ko mi vaopodi na limana beto mi manadi aza qari gua, ba qari tokeria ria na sepele ria na tinoni qari varitoka lame. ");
INSERT INTO ghn_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ba ari za gua vei i Jisu, <<Mu vamalumuria ria na koburu ko mari lame taqu, muke suquturia. Ura tadiria tugu vevei ari za na binangara pa noka,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Beto za vaopodi na limana aza ria na koburu pekipekidi ko za manadi, beto za taloi keni. ");
INSERT INTO ghn_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ego kolenana za maka tinoni za kamu ti Jisu ko ari za gua vei, <<Tinoni varivagigalai, ae roiti leana za mana roitini ara beto mana tekua ara za na toa jola?>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nari za oea i Jisu, ari za gua vei, <<Ae za vei ko qu nanazani ao taqu za na veveina na leana? Maka gu makana za aza za leana. Vei muna nyorogua tekua na toa ao, za mu kopudi na garunu,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","<<Na garunu ae veveidi?>> za gua za na tinoni ani. Nari za paranga i Jisu, <<Na garunu za ari: munake varivuke, munake barabarata, munake ikiko, munake jutu sekeseke, ");
INSERT INTO ghn_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","mu valavataria na tinamu na tamamu, muna roquroqua na tavitimu maka moqaza podeke vei qu roquroqu mule veinigo makamu,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nari za paranga za na tinoni ani, <<Doru garunu ari za qa tori tuti betoria tu ara ria, goto na za mule za mana roitidi ara?>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nari ari za guni vei Jisu aza, <<Vei muna nyorogua nabu pa mua tuti ao, za mu lao ko mu vavaidi na mua zakazava qu izongoria, ko na poatadi mu vadi ria na tinoni varivasevidi. Beto za muna tekuria ao ria na izizongo pa noka, beto za mu lame tutiziu,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Totonai za nongoria na tinoni koregana ani za na paranga aza za takulanga ko za keninana, ura za zoku nana izizongo aza. ");
INSERT INTO ghn_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Beto ari za gudi vei i Jisu ria nana sepele, <<Ma poja zozotodigamu ara za gamu: za tapata vitivitigi tana tinoni izizongo za mina luge pa binangara pa noka aza. ");
INSERT INTO ghn_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ma maka poja valeadigamu mule ara za gamu: za tapata jola tana tinoni izizongo za mina luge pa binangara tana Tamaza aza, za tapata jolani na kameli bi sulingi lugea za na talupuru nila,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Totonai qari nongoria ria na sepele ani za qari gabara vitivitigi ko ari qari gua vei, <<Ko i zei gu za mina boka taalo za vei?>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nari za dogoro tariria i Jisu ria beto ari za gudi vei, <<Tana tinoni za tapata vitivitigi ani, goto tana Tamaza za doru zakazava qarike tapata,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nari za oe i Pita, ari za guni vei, <<Dogoro! Gami gami tori loi paledi tu ria doru zakazava ko gami tori tutigomami tu ao. Ko na za mami izongia gami?>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nari ari za gudi vei i Jisu ria, <<Ma poja zozotodigamu ara za gamu: totonai mina nyumu pa nana nyumunyumuna bangara za na Tuna na Tinoni pa totozo tana nana binangara, za muna somana nyumu pa manogori nyumunyumuna bangara za gamu ka manogori sepele, ko muna bangaradi ari ka manogori butubutu Izireli. ");
INSERT INTO ghn_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Beto ko ria doru qari loiria na dia ruma na taidi marene na luludi reko babi na tamadi na tinadi beto ria na tudi na pezo na vei pa dia tutiqu ara, za mina ia sogadi na Tamaza maka gogoto totozo mota joladi vei ria qari loiria ria beto mari teku izongia vei na toa jola. ");
INSERT INTO ghn_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ba ria zoku qari momoe za mari liguligu, beto ria zoku qari liguligu za mari momoe,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","<<Na binangara pa noka za maka moqaza podeke vei maka tinoni za taloi votu keni volavolaza lea ko za lao nyaqo tinoni ko mari roiti pa nana inuma qurepi za gua. ");
INSERT INTO ghn_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ego ko pa liguna aza beto ria na tinoni roiti qari makarai varivaegoni za aza mina tabaradi na padana maka poata siliva pa maka rane qari gua, nari za garunu vakeni roitiria pa nana inuma qurepi aza ria. ");
INSERT INTO ghn_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ego ko za votu keni soga mule pa ia makemaketina padapada sia koloko za gua aza, za batiria mule ria kaki tinoni qari korapa turu goborodia kepore maka zava bari roitini. ");
INSERT INTO ghn_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nari za pojadi mule ria, <Gamu ba mu lao tugu roiti pa inuma qurepi taqu. Pala mana tabaradigamu tugu aza mana dogoro vatuvizini ara,> za gudi vei aza ria. ");
INSERT INTO ghn_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ko qari taloi keni tugu roiti ria. Ego pa manogori koloko, beto pa kue koloko ba za roiti vei tugu, ko za tekuria tugu kaki tinoni ko za garunu vakeni roitiria. ");
INSERT INTO ghn_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Totonai za tori tata lima koloko tu za mule soga lao pa ia makemaketina aza, za batiria mule za kaki tinoni qari korapa turu goborodia. Nari za parangaria, <Na za gamu turuni pani na rane doruna kepore maka zava bu roitini gamu?> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nari za ari qari guni vei, <Ura kepore tinoni bi vadigami na roiti,> qari guni. <Ego, leana, gamu ba mu lao tugu roiti pa inuma qurepi taqu,> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ego totonai za gore na veluvelu, na tinoni kolenana inuma za pojani za na tinoni za matamatani na roiti, <Mu kuku varikamudi ria na tinoni roiti ko mu vadi na dia tabara. Mu podalai tadiria qari podalai liguligu tinganai muna kamuria ria qari podalai momoe,> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ego ko ria na tinoni qari podalai roiti lima koloko za vadi maka poata siliva pa maka tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ko totonai mari lao teku tabara qari gua ria qari roiti momoe, za qari kole roquroqu pala mami teku vakubo qari gua. Ba totonai qari okoto teku, za qari varitoto vei tugu ria qari podalai roiti liguligu ria. ");
INSERT INTO ghn_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ko tonai qari tekuria na poata za qari kole qumiqumini ria za na tinoni za varoitiria pa nana inuma. ");
INSERT INTO ghn_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Qari paranga ria, <Ria na tinoni qari podalai liguligu za maka aoa gu qari roiti, goto gami za gami pogozia na mamatana na rane beto qe varivasevi na mangini, ba ria ba qu varitoto veidigami tugu gami,> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nari za oea na tinoni kolenana inuma za maka ria, ari za guni vei, <Baere, qake nganganguligo ara ao. Beko taqe makarai varivaegoni tu gita kori za ao muna roiti na rane doruna beto ko ara mana tabaranigo maka poata siliva taqe gua tu. ");
INSERT INTO ghn_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mu pogozia gu na mua tabara ko mu mule kenimua gu. Aza na nyorogua taqu za aza vei qa vani na tinoni za roiti liguligu, vei tugu aza qa vanigo ao. ");
INSERT INTO ghn_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Quke gilagilai ao za na qua tuvizina makaqu ara ko mana varoiti veini aza qa nyorogua veini za na qua poata makaqu? Ba palu qu kono beka ao ura ara na tinoni leleaqu?> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ko zara za vei za ria qari liguligu za mari momoe, goto ria qari momoe za mari liguligu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tonai za korapa rerege zae pa Jerusalema i Jisu, za za teku kaledi ria na nana sepele ko za pojadi, ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","<<Mu vainongoro lame! Taqe korapa zae pa Jerusalema za gita, ko ketakoi za pala mina tavalao pa limadi ria na kuta iama beto ria qari varivagigalaini na Vavanau za na Tuna na Tinoni. Ko pala mari jutua ko mari vaukea ");
INSERT INTO ghn_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","beto za mari valaoa ria tadiria na tinoni karovodi ko mari vavaledeni, mari piqolia beto mari vaukea pa korosi aza. Ba pa vinaue rane za mina turu mule pa uke aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pa liguna aza za lao ti Jisu za na maqotana i Jebeti beto kori tuna marene, ko za todongo pa moena aza ko mi tepai maka za tana za gua. ");
INSERT INTO ghn_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nari za nanazia i Jisu za na reko aza, <<Na za qu nyoroguani ao?>> za guni. Nari za oe lao aza, <<Bangara, mu vakolea na taringutinguti ko ari kori tuqu marene ari mari nyumu tavitigo ao pa mua binangara, maka pa kale matuamu maka pa kale merimu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nari za oeria i Jisu ria, ari za gudi vei, <<Gamuke gilagilai gamu kori aza gamu korapa tepaia. Ae vei muna boka tugu gozoria gamu za na vitigi mana gozoria ara?>> za gua aza. Nari qari oe lao ari kori, <<E, mami boka gu,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nari za ari za gudi vei i Jisu ari kori, <<E, pala muna somana gozoria tugu gamu kori za na vitigi mana gozoria ara. Ba na neqi vei beto mina tamijata i zei pa kale matua i zei pa kale meri za nake taqu. Ria na ia veveidi ari za na Tamaqu tu za tori vatana vadi ria tu za tori mijataria tu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tonai qari nongoria ari ka manogaputa sepele za vei zara, za qari tagigiridi ari kori tamatazi. ");
INSERT INTO ghn_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nari za kuku varikamudi i Jisu ria doru sepele ko ari za gudi vei, <<Gamu gilagilaimiu gamu ria na bangara tadiria na tinoni karovodi za qari lalaeni za na toa tadiria na dia tinoni, beto ria na tinoni lavalavata qari vatadogoroni na dia neqi tadiria na dia tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ba tadigamu za minake vei zara. Aza za nyorogua tavalavata gamu, za mina nabuludigamu tu gamu doru. ");
INSERT INTO ghn_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Beto aza za nyorogua momoedigamu gamu za mina pinauzu tu tadigamu doru. ");
INSERT INTO ghn_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Maka moqaza podeke vei na Tuna na Tinoni za zake lame ko ria na tinoni mari vabangaria, goto za lame nabuluni na tinoni beto za vani na nana toa ko za pajuku aloria ria kubo tinoni,>> za gudi i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ego tonai za taloi pa Jeriko i Jisu beto ria nana sepele, nari za maka minete puku tinoni lavata za tutiria. ");
INSERT INTO ghn_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ego ko qari nongoroni ari kori tinoni nake batabatadi qari korapa nyumu pa zona za i Jisu za korapa rerege jola lame qari gua, za qari kuku votu, <<Mu roquroqu tokadigami ao na Tuna i Devita!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nari qari tokeria ria na minete tinoni ari kori ko mari nogoto qari gudi. Ba tonai za qari kuku vaiolo viviva tu, <<Mu tokadigami ao na Tuna i Devita!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nari za turu nogoto i Jisu ko za kukuria beto ari za gudi, <<Na za za gamu nyoroguani gamu kori ko ba roiti vadigamu ara?>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","<<Bangara, gami nyoroguanigo gami kori ko bu vabatabatagami!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nari za roquroqu vitivitigiria i Jisu ari kori ko za lao uliria na matadi, nari za qarike ruavo tugu na batabatadia ari kori ko qari tutiadia aza. ");
INSERT INTO ghn_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Totonai mari toga pa Jerusalema qari gua ko qari kamu pa Betipezi aza pa Kubo pa Olive i Jisu beto ko ria na nana sepele, za za garunu lao momoedi i Jisu ari kori nana sepele, ");
INSERT INTO ghn_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ari za gudi vei, <<Mu lao pa guguzu pa moemiu maka karovona lao nari. Ko aza tugu muna lao kamu za pala muna batia gamu kori za maka dongiki na tapiko vaturu kolena tavitia maka tuna. Mu ruvatia za na dongiki beto mu toka lamedi taqu. ");
INSERT INTO ghn_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Vei mari parangagamu kaki tinoni, za ari muna gua vei, <Na Bangara za nyoroguani,> munagu, za pala mari vamalumu vadigamu,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ko za taroiti vei ari ani ko za gore votu za na paranga tana Bangara za lame vei tana tinoni korokorotai, aza ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","<<Mu pojadi ria na guguzu tinoni pa Zaione, ari mugudi vei, <Dotu za korapa lamelamenana za na miu Bangara! Zake tuara beto ko za zae pa dongiki, za zae pa pokotona na tuni dongiki!> mugudi,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ko qari taloi lao ari kori sepele, ko qari roitini tugu aza vei za garunudi i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Qari toka kamuni ari kori za na dongiki beto ko na tuna, beto ko qari lovaza vaakedi ria pa pokotodi za na dia koti beto za zae i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ria na minete tinoni lavata qari lovazadi na dia koti za na zona, goto kaki qari kaele teku suvege ko qari lovaza vakoledi pa zona. ");
INSERT INTO ghn_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na puku minete tinoni za qari rerege pa moena beto pa liguna i Jisu beto qari kukuku, <<Aroia na Tuna i Devita! Za tamana aza za lame pa izongona na Bangara. Aroia pa nulu vavagalo,>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Totonai za luge lao pa Jerusalema i Jisu, za kirikanoko za na guguzu doruna, <<I zei za?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nari za qari oe lao ria na puku minete qari tutia aza, <<Aza na tinoni korokorotai ani, i Jisu pa guguzu Nazareti pa Qalili,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ego ko za luge lao pa kakabarena na zelepade i Jisu ko za adu votuvotudi ria doru qari korapa vavai beto qari vavaidi na zakazava pa kakaberena zelepade, beto za peluku vaopo paledi ria na tevolo tadiria na tinoni sogasoga poata karovodi beto ria na nyumunyumudi tadiria qari vavaidi na kuru vavavuidi. ");
INSERT INTO ghn_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Beto ari za gudi vei ria, <<Ari za gua vei za na Kutikuti Tabuna, <Na qua ruma za mina takukuni na ruma varavarana,> za gua, ba gamu za gamu roiti veini na bevi ovovona tadiria na tinoni raja ikikodi,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ego ko qari lao tana pa kakabarena na zelepade ria nake babatadi beto na qao, ko za salanaria aza. ");
INSERT INTO ghn_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ba ria na kuta iama beto ria qari varivagigalaini na Vavanau za qari tagigiri totonai qari batiria na roiti varivagabaradi za roitidi i Jisu beto ko qari nongoria na kukuku irirangadi na koburu pa kakabarena na zelepade ari qari gua vei, <<Aroia na Tuna i Devita!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ko ari qari guni vei i Jisu, <<Qu nongororiamua tu ao aza qari korapa pojai ria zara?>> qari guni. Nari, <<E, qa nongororiaqua. Gamu oqoro tu tiro vakaberia gamu za na Kutikuti Tabuna aza ari za gua vei? <Qu vatanai ao pa ngujudi ria na koburu beto na melalu za na vatarazae zozotona,> za gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ego tonai za taloi tadiria pa kakabarena na zelepade aza nari za lao pa Betani ko na bongina aza za puta ketakoi. ");
INSERT INTO ghn_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tonai za rerege mule soga lao pa Jerusalema na volavolaza leana i Jisu, nari za vaia na burana. ");
INSERT INTO ghn_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ko za batia za maka suvege piqi pa keketai zona, ko za lao kamua ba kepore maka vuana bi batia goto galegale equruna gu. Nari ari za guni vei za na suvege piqi, <<Na iamu za munake vua soga mule ao!>> za guni. Aza tugu za paranga vei zara aza, nari za zake oriavo tugu malei ukenana za na suvege aza. ");
INSERT INTO ghn_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tonai qari batia ria na sepele za vei zara za qari gabara vitivitigi, ko qari paranga ria, <<Ae za vei ko zake oriavo tugu malei ukenana za na suvege piqi zana?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nari za oeria i Jisu, ari za gudi vei, <<Ma poja zozotodigamu ara za gamu: vei muna vazozoto beto munake orirabeke pa miu rangerange za gamu, za pala muna bokai gu gamu aza vei qa roiti veini ara na suvege piqi ani. Ba nake makana gu ani, goto vei muna paranga laoa na kubo, <Mu iolo ao na kubo zana ko mu lao lotu pa ivere,> bu gua, za pala mina gore votu gu. ");
INSERT INTO ghn_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Beto vei muna vazozoto za gamu, za pala muna tekua gu gamu aza vei gamu tepai pa varavara,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ego za mule lao pa kakabarena na zelepade i Jisu ko za korapa varivagigalai, za qari kamu nananazia ria na kuta iama beto ria na tiolata matamata tadiria na tinoni aza, <<Na neqi za qu izongia ao? I zei za vanigo na neqi ko qu roitidi ao ria na zakazava ari?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nari za oeria i Jisu, ari za gudi vei, <<Ara ba ma nanazadigamu mae maka nanaza. Ko vei muna oe valeania gamu za pala mana ule vadigamu ara za ae neqi veveina qa izongia ko qa boka roitidi ara za na zakazava veveidi ari. ");
INSERT INTO ghn_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","I zei za vani na neqi i Jone beto za paputaiso tinoni? Na Tamaza ba na tinoni?>> za gua aza. Totonai qari nongoria za paranga vei zara aza, za qari kole varigua makadi, <<Na za tana gua za tana oe laoni? Ura vei tana paranga, <Na Tamaza za vani,> tana gua, za pala mina paranga aza, <Ba ae za vei ko gamuke vazozotoa tu gamu i Jone?> pala mina gudigita. ");
INSERT INTO ghn_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Goto vei tana paranga, <Na tinoni qari vani,> tana gua, za varivamatagutu mutu za na za mari gudigita ria na tinoni. Ura ria doru tinoni za qari tori vazozotoa tu i Jone za maka tinoni korokorotai,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ko qari oea gu i Jisu, ari qari guni vei, <<Dai, gamike gilagilai i zei za vani na neqi i Jone beto za paputaisoria na tinoni,>> qari gua ria. Nari za ari za gudi vei i Jisu, <<Ego, ko ara ba manake ule vadigamu tugu ropi za ae neqi veveina qa izongia beto qa roitidi na zakazava veveidi ari,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","<<Ego, ae gamu roqu veini gamu za na vavakato ani? Za kolenana za maka tinoni kori na tuna marene. Za lao momoe aza tana tuna moa, ko ari za garunu veini, <Tuqu, ao za pa ngenari za mu lao roiti pa inuma,> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","<Koi, ara daiqua,> za gua za na tuna moa, ba za zovai nari ari za soga roquroqu ko za keni tugu. ");
INSERT INTO ghn_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Beto za lao mutugu tana tuna pa ligu za na tamadi ko za garunu veini mutugu aza za poja veini na tuna moa, nari ari za oe veini, <E, leana, tamaqu,> za guni, beto za zake pavu keni roiti aza. ");
INSERT INTO ghn_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","I zei ari kori ari za roitini aza za nyoroguani na tamadi?>> za gua i Jisu. Nari za qari paranga ria, <<Aza pa moa,>> qari gua ria. Nari za paranga i Jisu, <<Ma poja zozotodigamu ara gamu: ria na tinoni ikikeredi vevei na tinoni tekuteku takisi beto na tugele za mari luge jola lao momoedigamu gamu pa binangara tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ura za tori kamu tu tadigamu doru i Jone ko za vadogorodigamu za na zona tuvizina ko muna tutia, ba gamuke vazozotoa tu gamu. Goto ria tu na tinoni tekuteku takisi beto na tugele za qari vazozoto. Ko gamu batiriamiu tugu gamu za na gabaladi ria na tinoni ari, ba gamu za gamuke soga podekia tugu na roqumiu ko bu vazozotoa i Jone,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","<<Ego, mu vainongoro lameni mule maka vavakato vavapada ani. Kolenana za maka tinoni za izongo pezo, ko za roitini na inuma qurepi, beto za bara varilivutaini. Za ruri valolua aza za maka patu ketakoi mina monyo vakoleni na vaini za gua. Beto za roitini maka ruma gelegelena. Ego beto za keni tu soru tinoni ko qari kamu roiti ko qari kopu vani za na inuma, beto za keni lekoleko pa guguzu zouna aza. ");
INSERT INTO ghn_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Totonai mi kamua za gua za na totozo lokelokete, za garunu laodi na tinoni kolenana inuma za kaki nana pinauzu, ko mari lao tadiria na tinoni roiti ko mari teku vani na iana pa nana vuvua pa nana inuma za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ba qari lao tu ria na tinoni roiti ko qari aru tamanaria ria na pinauzu, ko maka za qari majamajai, maka qari vai vaukea, goto maka mutu za qari buti tarini patu. ");
INSERT INTO ghn_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pa liguna aza za garunuria mutugu ria kaki nana pinauzu, ria za qari mota joladi ria za garunu momoeria. Ba qari roiti veidi mutugu ria za garunu laodi momoe. ");
INSERT INTO ghn_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pa liguligu betobeto za garunu laoni tadiria za na tuna zozoto. <Na tuqu ani ko pala mari pangagani ria,> za gua za na roverove tana. ");
INSERT INTO ghn_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ba totonai qari batia ria na tinoni roiti za na tuna, za qari kole variparanga, <Ani za na tuna mina teku vakarovoria na izizongo tana tamana! Mae, lame ko tavai vauke pale beto ta tekua nada za na izizongo tana!> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ko qari lao ko qari ragata tekua, beto qari gona votuni keta peguruna na inuma, ko qari vauke pale aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Beto za nanaza laoria i Jisu ria, <<Ego, vei totonai mina mule lame kamu za na tinoni kolenana inuma, za na za beka pala mina roitini tadiria na tinoni roiti ari?>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nari za qari oea ria aza, <<Pala mina vauke paledi gu aza ria na tinoni ikikeredi zara. Beto pala mina vakarovo lao vadi tu kaki goto tinoni za na nana inuma, ria na tinoni mari boka vani na iana totonai mari lokelokete,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nari za parangaria i Jisu ria, <<Gamu oqoro tu tiro vakaberiamiu gamu za na Kutikuti Tabuna aza ari za gua vei? <Na patu aza qari kilu pale ria na tinoni vavaturu ruma, za aza tugu za na kuta patu vizovizo. Na Bangara za roiti veini ani, ko za varivagabara jola pa nada dogodogoro!> za gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","<<Ko na binangara tana Tamaza za mina tateku varijo pale tadigamu, ko mina tavalao mule tadiria na tinoni karovodi mari boka roiti vavoturia na vua leadi. ");
INSERT INTO ghn_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(Aza na tinoni za lotu pa patu mina talomolomoto. Goto na tinoni za takoa na patu aza za mina avuru bilu,)>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Totonai qari nongoria ria na kuta iama beto na Parese za na vavakato vavapada ti Jisu, za qari gilagilai za aza za korapa gu pojai na veveidi ria qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ko qari kole podepodeke ko bari aru tamania qari gua, ba qari matagutudi na minete tinoni, ura ria doru tinoni za qari vazozotoa maka tinoni korokorotai i Jisu qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ego i Jisu za vavakato vadi mule kaki vavakato vavapada ria. Ari za gudi vei, ");
INSERT INTO ghn_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","<<Na binangara pa noka za vei ari. Kolenana za maka bangara za vatanani na vavolo varielava tana tuna marene. ");
INSERT INTO ghn_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Beto za garunu ria na nana nabulu ko mari lao kuku varikamudi ria na tinoni qari tasoru ko mari somanani na vavolo za gua, ba qari daidia kamu ria na tinoni tasorudi. ");
INSERT INTO ghn_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nari za maka garunuria mule ria kaki goto nana nabulu ko ari muna paranga veidi ria qari tasoru za gudi, <Vainongoro ko! Za tori naqiti beto tu za na vavolo taqu koviria, qari tori takubolo tu za na bulumakau lavalavatadi beto na tuni bulumakau nyobonyobokodi ko qari tori mogemoge vatana tu, beto doru maka za qari tori tavatana tu. Mae, lame somanani na tekuteku varielava, muna gudi,> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ba qarike pavu vagalani ria qari tasoru za na paranga ani. Rari vei qarike gudi tugu ria na nabulu goto qari kole gu tapatianani na dia roitina. Kaki qari kenidia tu pa dia inuma, kaki qari keni tu nyaqodia poata, ");
INSERT INTO ghn_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","goto ria kaki qari tasoru za qari lao tu ko qari aru tamanaria ria na nabulu tagarunudi ari ko qari komiti vikevikereria beto qari vaukeria. ");
INSERT INTO ghn_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nari za tagigiri vikevikeredi na bangara ria, ko za garunuria ria na nana tinoni varipera ko qari lao vai vauke betoria ria qari vaukeria na nana nabulu, beto qari vurungu paleni za na dia guguzu. ");
INSERT INTO ghn_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Beto za kukuria ria kaki nana nabulu mule ko ari za gudi vei, <Na qua vavolo varielava za tori tana tu, ba ria na tinoni qa soruria za nake garodi tugu ko mari lame. ");
INSERT INTO ghn_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ko mu lao pa zona lavalavata, ko mu soruria ria doru tinoni muna batiria pa zona, ko mari kamu somanani na vavolo,> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ko qari keni ria na nabulu ko qari kuku vakamu betoria ria na tinoni ria vei qari batiria, na tinoni leadi beto ria nake tinoni leadi. Ko qari pugelia ria na tinoni za na ruma ketakoi za taroiti na vavolo varielava. ");
INSERT INTO ghn_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ego ko tonai za luge lao za na bangara, ko mi dogororia ria na tinoni tasorudi za gua, nari za batia za maka tinoni zake vazaeria na poko varielava. ");
INSERT INTO ghn_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ko za nanazia na bangara aza, <Baere, ae za vei beto qu boka luge lame pani ao, ura ao za quke vazaeria na poko varielava?> za guni. Ba zake vagala za na tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nari za parangaria na bangara ria na nabulu, <Mu lao ko mu piuria na limana na nenena, ko mu gona votu lao pale pa peguru rorodomo kunikunina za na tinoni ani. Ketakoi mari lukana uui beto mina ngingizi tu na livodi ria na tinoni,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ura kubo ria qari tasoru, ba ari ka viza gu za qari tamijata,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ego qari varikamu ria na Parese ko qari varivavavakato ko mari vagonai pa kaki dia nanaza i Jisu qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Qari garunu laoni ria tana za kaki dia sepele beto ko kaki ria na tinoni qari somana jukai i Herodi. Ko ari qari guni vei, <<Tinoni varivagigalai, gami gilagilaimami gami za qu zotomua gu ao. Qu varivagigalaini ao pa zozoto za na zona tana Tamaza, beto ko zake vatakulanga podekigo ao za na za mari gua ria na tinoni, ura quke dogoro laoa ao za ae qari poreveveidi vei ria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ko mu pojadigami moko na mua roquroqu. Ae vei, na tavamalumuna tugu pana Vavanau za tana tabara laoni na nada takisi tana bangara i Siza, ba dai?>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ba za tori batia tu i Jisu za na dia roquroqu ikikerena qari vatanani ria. Ko ari za gudi vei ria, <<Na tinoni jola vavabatamiu na sekesekemiu za gamu! Ae za vei ko gamu korapa nyorogua podeke vagonaziu ara? ");
INSERT INTO ghn_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mu vabatiniziu moko za na poata siliva aza gamu tabarani takisi!>> za gudi. Ko tonai qari pogozo laoni tana za maka poata siliva, ");
INSERT INTO ghn_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nari za nanazaria, <<I zei na izumatana beto na izongona za kole pa poata siliva zana?>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nari za qari paranga ria, <<I bangara Siza,>> qari gua. Nari ari za gudi vei i Jisu ria, <<Ego mu valao vani i Siza za ria ti Siza, beto mu valao vani na Tamaza za ria tana Tamaza,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Totonai qari nongoria za na oe tana za qari gabara ria ko qari loi pale ko kenidia. ");
INSERT INTO ghn_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ego pana rane tugu aza za qari kamu ti Jisu ria na Sadusisi, ria qarike vazozotoa na veveina na tinoni mina boka turu mule pa uke, ko ari qari guni vei aza, ");
INSERT INTO ghn_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","<<Tinoni varivagigalai, na Vavanau ti Mosese za ari za gua vei, <Bi maka tiolata marene za bi kepore tuna beto ko bi uke, za pala na taina marene mina teku vakarovia za na naboko, ko ria na koburu mari vaporeria ari kori za mina tagigaladi na tuna tugu na marenena momoe za uke,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ego ko koledia za ari ka vitu tamatazi marene. Aza pa moa zozoto ria za varielava ko za oqoro pore na tuna beto za uke aza, ko za loia za na naboko ko za elavia mule na taina marene aza za tuti tana tugana moa. ");
INSERT INTO ghn_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ba aza na marene vinaori ani ba za vei tugu na tugana, za oqoro pore na tuna beto za uke. Na marene vinaue ba maka moqaza podeke tugu, ko qari beto pudala tugu ari ka vitu tamatazi. ");
INSERT INTO ghn_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Beto za liguligu tu beto za uke za na reko. ");
INSERT INTO ghn_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ego, ko na rane mari turu mule pa uke ria na tinoni, za i zei ari ka vitu tamatazi ari na maqotana za na reko aza? Ura ari ka vitu doru za qari elavia aza!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ba za oeria i Jisu ria, ari za gudi vei, <<Dai, gamu sela za gamu! Ura gamuke vakaberia gamu za na ginuadi na Kutikuti Tabuna babi na neqi tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ura tonai mari turu mule pa uke ria na tinoni, za pala mari suvere vei gu ria na mateana pa noka ria ko marike varielava. ");
INSERT INTO ghn_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Goto na veveina na turu mule pa uke za ae vei gamu oqoro tu tiro vakaberia za aza za pojadigamu na Tamaza? Ari za gua vei aza, ");
INSERT INTO ghn_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","<Ara za na Tamaza ti Ebarahami, na Tamaza ti Aisake, beto na Tamaza ti Jekopi,> za gua aza. Ko aza za nake Tamaza tadiria na tinoni ukedi, goto tadiria tu na tinoni toadi,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Totonai qari nongoria ria na minete tinoni za ani, za qari gabara betoni ria za nana varivagigalai. ");
INSERT INTO ghn_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ego totonai qari nongoria za vapapakaria i Jisu ria na Sadusisi, nari za qari varikamu ria na Parese. ");
INSERT INTO ghn_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ko maka ria na Parese aza za varivagigalaini na Vavanau za nyorogua vagonai i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ko za paranga, <<Tinoni varivagigalai, ave za na garunu poreveveina jola pa Vavanau?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nari za oea i Jisu, ari za guni vei, <<Mu roquroqua na Bangara na mua Tamaza pa doruna bulomu, pa doruna ongongumu, beto pa doruna na roqumu. ");
INSERT INTO ghn_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aza za na garunu za poreveveina jola beto za momoe. ");
INSERT INTO ghn_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na vinaori garunu ani gu: Mu roquroqua na tavitimu maka moqaza podeke vei qu roquroqu mule veinigo makamu. ");
INSERT INTO ghn_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tadi ari kori garunu ari qari titi za na doruna na Vavanau beto na varivagigalai tadiria na tinoni korokorotai,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ego tonai qari korapa tugu varikamu ketakoi ria na Parese, za nanazaria i Jisu ria, ");
INSERT INTO ghn_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","<<Na za gamu roquroquni gamu za na Karisito? Na tuti lamena ti zei aza?>> za gua. Nari qari oe lao ria, <<Na tutina i Devita,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nari za parangaria i Jisu ria, <<Ba ae za vei ko za pojani tu na Ongongu Tabuna i Devita ko za gigalani tu na Bangara i Devita aza? Ura i Devita za ari tu za paranga vei, ");
INSERT INTO ghn_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","<Ari za gua vei za na Bangara Tamaza tana qua Bangara na Karisito: Mu nyumu pa kale matuaqu, tingnai tu mana vakilasaria ria na mua kana,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ego, ko vei bi gigalani nana Bangara bi guni i Devita aza, za ae za vei beto mina na tuti lamena tu ti Devita za na Karisito?>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kepore maka ria bi boka oea i Jisu. Ko podalai pa rane aza za qarike tumanani nanaza sogai ria aza. ");
INSERT INTO ghn_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ego beto za paranga laoria i Jisu ria na minete tinoni beto ria na nana sepele, ari za gudi vei, ");
INSERT INTO ghn_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","<<Ria qari varivagigalaini na Vavanau beto ria na Parese za qari nyumua na nyumunyumuna ti Mosese. ");
INSERT INTO ghn_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ko muna kopuni beto mu tutia gu gamu aza vei qari varivagigalaini ria tadigamu, ba muke tutiria ria na roiti qari roroitidi ria. Ura ria za qarike tutiria ria na zakazava qari varivagigalaidi. ");
INSERT INTO ghn_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pana dia ruvata vokele paranga za qari vakedi na pogozo mamata ria na tinoni, ba maka karukarusudi gu bi uli pa pogozo mamata ko bi iapeki vakopele vadi na tinoni ba qarike nyorogua vei tugu. ");
INSERT INTO ghn_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Doru dia roiti za qari roitidi ria ko vei ko mari dogororia gu ria na tinoni qari gua. Qari vatogazaria pa readi beto pa limadi za na bokese za pugelia na paranga pa Kutikuti Tabuna, beto qari piti vakakazaria ria na uqudi na dia poko. ");
INSERT INTO ghn_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Qari nyonyorogua tavanyumu pa ia poreveveidi pa vavolo beto pa nyumunyumu poreveveidi pa leo ruma varivarikamuna. ");
INSERT INTO ghn_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Qari nyoroguani ko ria na tinoni mari gozoro qeraqeradi pa ia makemaketina beto mari gigaladi na <Rabi> mari gudi na tinoni qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ba gamu na qua tinoni za munake tagigala na <Rabi> ura na tamatazi gu za gamu, beto ko maka moqazana gu za na miu Tinoni varivagigalai. ");
INSERT INTO ghn_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Muke gigalani na <tamamiu> za maka tinoni pa pezo, ura maka moqazana gu za na Tamamiu, aza na suverena pa noka. ");
INSERT INTO ghn_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Muke gigalani na tinoni matamata za maka tinoni, ura na Karisito gu za na miu tinoni matamata. ");
INSERT INTO ghn_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Aza na tinoni za poreveveina jola gamu za mi nabuludigamu za gamu. ");
INSERT INTO ghn_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aza za valavata muleni makana za pala mina tavapeki, beto aza za vapeki muleni makana za pala mina tavalavata. ");
INSERT INTO ghn_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Mu takulangagemiu tugu za gamu gamu varivagigalaini na Vavanau beto na Parese! Na tinoni jola nyonyoravamiu! Ura gamu pate suqutia gamu pa moedi na tinoni za na atakamanana na binangara pa noka. Ko makamiu gamuke boka luge laoa tugu beto ko gamu suquturia tugu ria qari korapa podepodeke ko mari luge qegua. ");
INSERT INTO ghn_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Mu takulangagemiu tugu za gamu gamu varivagigalaini na Vavanau beto na Parese! Na tinoni jola nyonyoravamiu! Gamu iko toaria na ruma beto na zakazava tadiria na nabonaboko, beto gamu jola varavara vakakazamiu pa moedi na tinoni! Zara gamu vei ko mina lavata jola za na vinakilasa muna gozoria.) ");
INSERT INTO ghn_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mu takulangagemiu tugu za gamu gamu varivagigalaini na Vavanau beto na Parese! Na tinoni jola nyonyoravamiu! Gamu karovoria na kolo ka kolo beto gamu reregeria na ia ka ia, ko gamu vagabalia maka tinoni ko za tutia na Vavanau, beto totonai za gabala nari za ikere joladigamu mule gamu ko za padana na gana gu pa heli za na tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Mu takulangagemiu tugu za gamu na tinoni varitoka nake batabatamiu! Ura ari gamu vavanau vei za gamu, <Bi maulu galegale pa nizongona na zelepade madina za maka tinoni, za vei minake roiti votuni za nana maulu ba zake vei makia. Ba vei tu mina maulu lao aza pa qolo qari tavakole pa leo zelepade madina, nari za minake sogai goto mina roiti votuni tugu aza za na maulu za mauluni,> gamu gua za gamu. ");
INSERT INTO ghn_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Gamu duviduvili nake batabata za gamu! Ae ari kori za na poreveveina jola, na qolo ba na zelepade madina? Na zelepade madina gu za poreveveina, ura ketakoi gu qari boka tavamadi ria na qolo qari tavaroiti pa vatarazaena na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Beto za ari mule gamu vavanau vei, <Bi maulu pa izongona na idi vavavuina za maka tinoni, za vei minake roiti votuni nana maulu ba zake vei makia. Ba vei tu mina maulu lao aza pa varivana za ake pa idi vavavuina, nari za minake sogai goto mina roiti votuni tugu aza na maulu za mauluni aza,> gamu gua za gamu. ");
INSERT INTO ghn_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Za iapekigana tugu za nake batabata za vaigamu gamu! Aza tu na idi patu vavavuina za vamadia na varivana za za poreveveina jolani za na varivana za tavaake pa narena aza. ");
INSERT INTO ghn_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Za vei zara za, na tinoni za maulu lao pa ia vavavuina za maulu lao tugu za tadiria doru varivana qari tavakole pa narena. ");
INSERT INTO ghn_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Beto ko na tinoni za maulu lao pa zelepade madina za maulu tavitini tugu za na Tamaza za suvere pa leo zelepade madina. ");
INSERT INTO ghn_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Beto ko na tinoni za maulu zae pa noka, za maulu lao tugu za pa nyumunyumuna bangara, beto ko za maulu tavitini tugu za na Tamaza za nyumu pa nyumunyumuna aza. ");
INSERT INTO ghn_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Mu takulangagemiu tugu za gamu gamu varivagigalaini na Vavanau beto na Parese! Na tinoni jola nyonyoravamiu! Ura gamu valao vani na Tamaza za maka pa manoga pa miu umuma qari vavalingilingia na tekutekuna vevei na miniti, na dilli beto na kiumini. Ba gamu dogoro paledi gamu ria na uana poreveveidi pa Vavanau, na roiti vatuvizi lao tana na tinoni, na variroqu varitokai, beto na tuti valeania na Tamaza. Ari ria na uana za pada ko muna kopudi na roiti tutidi, beto ko vei tugu ria kaki tuti zara. ");
INSERT INTO ghn_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Na tinoni varitoka nake batabatamiu za gamu! Gamu podeke vitivitigi ko gamu teku pale za na lango peki za lao pa gemiu kapa pie bukuna, ba beto gamu ponyolo toaia za na kameli tu naregogoto! ");
INSERT INTO ghn_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Mu takulangagemiu tugu za gamu gamu varivagigalaini na Vavanau beto na Parese! Na tinoni jola nyonyoravamiu! Ura gamu valiosoria na pegurudi na miu kapa beto na peleita, goto pa leodi za pugeleria na zakazava ikikeredi gamu tekuria gamu pa miu zona ngangangulu beto na muino. ");
INSERT INTO ghn_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Na Parese nake batabatamu ao! Mu valioso momoea mae tu na leona na mua kapa, beto za pala mina lioso mutugu za na peguruna. ");
INSERT INTO ghn_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Mu takulangagemiu tugu za gamu gamu varivagigalaini na Vavanau beto na Parese! Na tinoni jola nyonyoravamiu! Gamu kale na bevi varivarigolomoni kobukobu tinoni ukedi, za tapedi vakeka ko za batabata lea na peguruna, ba pa leona za za pugelia na pudapuda beto na nyabo tomete. ");
INSERT INTO ghn_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ko zara gamu vei putaputa za gamu. Pa pegurumiu za gamu dogoro vei na tinoni tuvizimiu pa dogodogoro tana tinoni, goto pa bulomiu za pugelia na nyonyorava beto doru roiti ikikeredi. ");
INSERT INTO ghn_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Mu takulangagemiu tugu za gamu gamu varivagigalaini na Vavanau beto na Parese! Na tinoni jola nyonyoravamiu! Gamu roiti valeadi beto gamu vasari vabatabata learia tugu vei ria na poudi ria na tinoni korokorotai beto na merumerudi ria na tinoni tuvizidi pa moa. ");
INSERT INTO ghn_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Gamu paranga za gamu, <Vei babi korapa suveremami na totozo qari suvere ria na tamamami pa moa gami, za mamike somana vaukeria gami ria na tinoni korokorotai,> gamu gua. ");
INSERT INTO ghn_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ko zara za vei za gamu ule votuni gu pa miu uana za gamu za na tinoni veveimiu gu ria qari vaukeria na tinoni korokorotai pa moa! ");
INSERT INTO ghn_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ko mu laomiu gu ko mu roiti vaokotoni tu aza qari tori podalaini tu ria na tamamiu pa moa. ");
INSERT INTO ghn_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Boko dole! Boko tuni dole ikikeremiu! Ae vei, muna boka ukuni gamu za na vinakilasa pa heli? ");
INSERT INTO ghn_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ko za vei za mu vainongoro! Ara qa korapa garunu lamedi ara tadigamu ria na tinoni korokorotai, na tinoni gigigalai, beto ria na tinoni varivagigalai. Kaki ria za pala muna vaukeria tugu gamu, kaki mule za pala muna vaukeria pa korosi, beto kaki za pala muna majamajaria pa ruma varivarikamuna beto ko muna adu vatagatagararia pa guguguzu. ");
INSERT INTO ghn_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Gamu vaukeria ria na tinoni tuvizidi ko na tinajutu za muna gozoria gamu. Ko ria muna gozoroni tinajutu gamu za podalai ti Ebolo na tinoni tuvizina ko za lame kamu ti Zakarae na tuna marene i Barakia aza gamu vai vaukea gamu pa varikorapaina na zelepade madina beto na ia vavavuina. ");
INSERT INTO ghn_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ma poja zozotodigamu ara za gamu: na vinakilasa tadiria dodoru qari vai tinoni ari, za mari gozoria tugu ria na zazae tinoni koviria,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","<<Kei, Jerusalema, Jerusalema! Ao za qu vai vaukeria na tinoni korokorotai, beto ko qu buti taridi na patu ria na tinoni pogozo nongoro za garunu laodi na Tamaza tamu! Kubo totozo za qa nyorogua teku varikamudi ria na mua tinoni, ba veidigamu na kokorako za vaonguria na boko tuna pa kauru babanana ko ba kopudigamu qa gua, ba gamuke vamalumu podekeziu tugu! ");
INSERT INTO ghn_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Vainongoro! Na miu ruma za taloi pale, za kobakoba, beto mina ivulu gogoepe za na guguzu. ");
INSERT INTO ghn_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ura ma poja valeadigamu ara za gamu: podalai tugu koviria za munake bati liguziu ara za gamu, tinganai tu mina kamua za na totozo totonai pala ari muna paranga vei za gamu, <Na tamanana aza za lame pa izongona na Bangara,> muna gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ego tonai za taloi pa kakabarena na zelepade i Jisu, za qari lao tana ria na nana sepele, ko qari vadogoroni aza za na roitina na ruma zelepade doruna. ");
INSERT INTO ghn_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nari za parangaria i Jisu ria, <<Qari vagabaragamu gamu za ari? Ba ma poja zozotodigamu ara gamu: ria doru patu gamu batiria ari za marike kole varivaritopare lalaodia, ba pala mari taqovara beto,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ego totonai za korapa nyumunana pa batu kubo pa Olive i Jisu, za qari peki lao makadi tana ria na nana sepele, ko ari qari gua, <<Mu ule vadigami. Ae totozo mari podo ria doru zakazava qu gudi ao zara? Beto na za mina tabata vei na vinagilagilana na mua bola lame beto na vinabetona na totozo?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nari za oeria i Jisu ria, ari za gudi vei, <<Mu kopu valeana gu ko marike toka vapirugamu. ");
INSERT INTO ghn_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ura kubo ria na tinoni pala mari lame pa izongoqu ara, ko ari mari gua vei, <Ara za na Karisito!> mari gua, ko mari toka vapirudi ria na zoku tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pala muna nongorodi ria na varipera beto na vavakatodi na varipera, ba munake matagutu. Pala mari pidoko tugu za na zakazava zara, ba nake aza za na vinabetobetona. ");
INSERT INTO ghn_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Maka puku tinoni mina turu talea maka goto puku tinoni, beto maka binangara mina turu talea maka goto binangara. Beto na songe beto na nunu mari raja doru kota. ");
INSERT INTO ghn_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Doru zakazava ari za vei na podapodalaina na vitivitigi teku koburu. ");
INSERT INTO ghn_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Na totozo aza za pala muna taaru tamana za gamu ko mari toka laodigamu tadiria na tinoni ko muna tavakilasa beto mari vaukegamu. Pana ginuana gamu tutiziu ara za pala marike tavaraguadigamu ria na tinoni karovodi za gamu. ");
INSERT INTO ghn_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kubo tinoni za na dia rangerange mina lotu ko mari taloi rijodia taqu, beto ko mari varigabala vikere beto marike varitavaragua ria. ");
INSERT INTO ghn_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Beto kubo tinoni korokorotai sekesekedi za mari votu lame ko pala mari toka vapiruria ria zoku tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pala zara mina koi vei gigiri vei za na reregena na toa ikikerena ko na toa variroqu tadiria na tinoni za mina lomozo betonana. ");
INSERT INTO ghn_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ba aza gu za vangaju kamua na betobetona za mina taalo. ");
INSERT INTO ghn_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ko na nongoro leana ani, aza na veveina na binangara tana Tamaza, za mina tatarae pa kasia guguzu doruna ko ria doru tinoni karovodi mari nongoria. Pa liguna tu aza za mina lame za na vinabetobetona na totozo,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","<<Pala muna batia za na Zakazava Ikikerena Jola aza vei za tori pojai tu i Daniela na tinoni korokorotai. Ko na Zakazava Ikikerena Jola aza za mina turu pa ia madina pa ruma zelepade (Gamu gamu tiroa na paranga ani za mu vakoinonoa na ginuana). ");
INSERT INTO ghn_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Totonai mina vei aza za ria qari suvere pa Jiudia za mari uku zagereria tu ria na kubo ketakoi. ");
INSERT INTO ghn_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Aza za korapa suvere pa narena na nana ruma za mike mule gore qaqiriria na nana zakazava pa leo ruma. ");
INSERT INTO ghn_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aza na tinoni za korapa pa nana inuma za mike mule tekua na nana poko. ");
INSERT INTO ghn_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Na totozo takulangadi tadiria na reko qari bogata beto ko tadiria qari izongo melalu ria na rane ria! ");
INSERT INTO ghn_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mu varavara tepai na Tamaza, ko nake pa totozo lomozo babi na rane Minyere za mu uku gamu. ");
INSERT INTO ghn_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ura na tapata pa totozo aza za mina lavata joladi ria na tapata qari jola totonai vei za podalai na kasia guguzu ko za lame kamu koviria. Ko pa liguna za kepore za maka tapata mina ikikerena jola vei ani. ");
INSERT INTO ghn_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ba za tori vapapakia tu na Tamaza za na ngutidi na rane totonai. Goto bike vei za kepore maka tinoni bi boka toa. Ba koko vei gu za roquroquria na nana tinoni tamijatadi za na Tamaza za vei za mina vapapakia za na ngutidi na rane pa totozo tapata aza. ");
INSERT INTO ghn_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Vei ari bi paranga veinigo maka tinoni totonai, <Dotu, nari za na Karisito!> babi, <Zana aza!> bi gua, ba keta vazotoa. ");
INSERT INTO ghn_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ura pala mari votu lame ria na karisito sekesekedi beto na tinoni korokorotai sekesekedi ko mari roitidi ria na roiti varivagabara poreveveidi beto mari vavoturia na dia vinagilagila, ko vei mari boka za mari toka vapiruria tugu vei ria na tinoni tamijatadi tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mu vainongoro! Za oqoro kamua na totozo aza za qa korapa pojadigamu ara ani. ");
INSERT INTO ghn_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ko vei ari bari ule veini vadigamu ria na tinoni, <Nari! Korapa suverenana gu pa qega aza!> bari gua, za keta votu lao. Babi, <Zana! Korapa gu suverenana pa leo ruma aza!> bari gua, za keta vazotoria. ");
INSERT INTO ghn_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ura na bola lame tana Tuna na Tinoni za pala mina vei gu na kapi za malara podalai pa kale zagere tapo ko za kamu pa kale suvu tapo. ");
INSERT INTO ghn_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ketakoi za kole na kobukobu tinoni ukena za pala mari varikamu ketakoi za na nyae,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","<<Mina jola za na tapata pa rane ria, za pala mina rodomo za na tapo, na popu minake kabere, na seru pa noka mari lotu, beto doru zakazava pa noka mari tajou vakanoko beto. ");
INSERT INTO ghn_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Beto mina tabata votu lame pa vavagalo kota za na vinagilagilana na Tuna na Tinoni. Beto za mari lukana tadungana beto ria doru tinoni pa kasia guguzu totonai mari batia na lamena na Tuna na Tinoni pa lei pa noka, mina lame tavitia na neqi lavatana beto na kabere lavatana. ");
INSERT INTO ghn_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mina taivu vaqovaqoro viva za na kuvili, beto mina garunu laodi aza ria na nana mateana pa doru kota pa kasia ababana, ko mari toka varikamudi na nana tinoni tamijatadi pa doru uququdi na kasia guguzu pa maka uququna na noka kamua maka uquna. ");
INSERT INTO ghn_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mu dogoria na suvege piqi ko mu tekua maka vinakabere. Totonai mina ijoko ko mina podalai equru ko mina bu valeana, nari za qu gilagilai za tori takelai tu za na suvege aza ko za tata gu za nana totozo vua. ");
INSERT INTO ghn_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Pala zara tugu muna vei za gamu na totozo aza. Tonai muna batiria gamu ria doru zakazava ari, za pala muna gilagilaimiu gu za tata za na totozo, ko za tata vitivitigi gu za na Tuna na Tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ara ma poja zozotodigamu ara gamu: doru zakazava ari za pala mari gore votu totonai mari oqoro uke beto na zazae tinoni koviria. ");
INSERT INTO ghn_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Na oka beto na pezo za mari maragutu, ba ria na qua paranga za marike izongo maragutu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","<<Goto na veveina na rane beto na totozo aza za kepore maka tinoni bi gilagilai. Ria na mateana pa noka babi na Tuna ba zake gilagilai, goto makana gu na Tamana za gilagilai. ");
INSERT INTO ghn_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Na bola lame tana Tuna na Tinoni za pala mina maka moqaza podeke vei tugu pa totozo ti Noa. ");
INSERT INTO ghn_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ria na rane totonai za oqoro dururu na abana, za ria na tinoni za qari kole ganiganigedi, qari kole bukubukugedi, beto ria na marene na reko za qari varivarielavadia, tinganai ko za kamu za na ranena za luge pa leo aka i Noa. ");
INSERT INTO ghn_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ba qarike izongo vagilagila podekia tugu ria za na za korapa taroiti, tinganai ko za gore na vae ko za pogozo vakeni beto paledi. Pala zara tugu mina lame vasiboro vei za na lamena tana Tuna na Tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Na totozo aza za kori tinoni mari korapa roiti pa inuma, za maka za mina tateku vakeni goto maka za mina taloi pale. ");
INSERT INTO ghn_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kori reko za mari korapa kija vaavururia na dia kiko vuiti, za maka za mina tateku vakeni goto maka za mina taloi pale. ");
INSERT INTO ghn_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ko za vei za mu suvere gelegele, ura gamuke gilagilai gamu za na rane mina lame na miu Bangara. ");
INSERT INTO ghn_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Gamu gilagila valeaniamiu gamu za vei bi tori gilagila momoenana tu na tinoni kolenana ruma za ae totozo mina kamu na tinoni ikiko, za pala mina suvere gelegele ko minake boka pururu lugea na tinoni ikikona za nana ruma. ");
INSERT INTO ghn_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ko za vei za gamu mu kole suvere vanaqiti doru totozo, ura na Tuna na Tinoni za mina lame na totozo gamuke rove veini mina lame,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","<<Ego koviria ma vavakato vadigamu na veveina na nabulu tarangena. Na nabulu tarangena za aza tugu maka za vatiolatai na bangara ko za kopu valeadi ko za iadi na ganigani ria pa tatamana tana bangara pa totozo za nguti vakoledi na bangara. ");
INSERT INTO ghn_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mina tamana za na nabulu aza totonai mina mule na nana bangara za mina batia za korapa tugu roitini aza za na roiti za taiani ko mina roitini. ");
INSERT INTO ghn_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ma poja zozotodigamu ara gamu: pala mina vatiolata lavatia zozoto na nana bangara aza, ko mina kopu vani doru nana izizongo. ");
INSERT INTO ghn_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ba vei bike nabulu leana aza ko bi roquroqua aza za pala minake oqanai mule lame za nana bangara bi gua, ");
INSERT INTO ghn_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ko bi podalai majamajaria ria na nabulu tavitina, beto bi somana tekuteku beto bukubuku tavitiria ria na tinoni bukubukudi. ");
INSERT INTO ghn_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ego beto mina mule kamu za na bangara tana nabulu ani na rane beto na totozo mina korapa suvere muma ko minake gilagilai aza. ");
INSERT INTO ghn_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na bangara mina lomoto kobukobu pale aza, beto mina vakole tavitidi ria na tinoni sekesekedi. Ketakoi za mari lukana uui beto mina ngingizi tu na livodi ria na tinoni,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","<<Pana totozo aza za na binangara pa noka za pala ari mina vei. Koledia ari ka manogaputa reko koregadi qari okoto pogozoria na dia juke ko mari lao gozoria za na tinoni mina varielava tonai mina lame ko mina tekua na maqotana qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ari ka lima za na duviduvilidi goto ari ka lima za na tavagigaladi. ");
INSERT INTO ghn_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ari ka lima duviduvilidi qarike pogozo vatanadi na oela za na dia juke. ");
INSERT INTO ghn_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Goto ria na tavagigaladi za qari pogozoria na dia juke beto qari okoto toto pogozo vatanadi pa dia tototodi za na oela. ");
INSERT INTO ghn_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ego za vavabongi na kamuna za na tinoni varielava, ko qari doki ko qari puta beto ria doru. ");
INSERT INTO ghn_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ko za tori varikorapai bongi tu na kota, za tanongoro za na kuku, <Vainongoro! Ani za na tinoni varielava! Mu votu lame gozoria!> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nari qari okoto sasuru iqolo beto ari ka manogaputa reko koregadi ko qari okoto piju vatoria za na dia juke. ");
INSERT INTO ghn_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Beto za ari ka lima reko duviduvilidi qari paranga laoria ari ka lima tavagigaladi, ari qari gua vei, <Muna vadigami tu kaki miu oela, ura iapeki gu mina pidili gapugapu na mami juke gami,> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ba qari oe lao ria na tavagigaladi, <Dai, ura nake padada gita doru ria na mami oela ari. Goto mu mule lao vai sogamiu tadiria qari vavai oela,> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ego ko pa ligudi tu qari korapa keni nyaqo oela ari ka lima reko duviduvilidi ari, za kamu gu za na tinoni varielava. Ko ari ka lima reko tavagigaladi qari tori vatana vakoledia tu za qari luge lao tavitia aza pa vavolo varielava. Ko qari luge beto ria za tapate gu za na atakamana. ");
INSERT INTO ghn_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ko liguligu tu beto za qari kamu ari ka lima reko koregadi duviduvilidi. Ko qari kamu kole kukuku, ari qari gua, <Bangara! Bangara! Mu revanga vadigami!> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ba za oe laoria na tinoni varielava ria, <Ma poja zozotodigamu ara za gamu: qake izongo gilagilagamu ara za gamu,> za gudi na tinoni varielava. ");
INSERT INTO ghn_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ko za vei za mu suvere gelegele, ura gamuke gilagilai gamu za na ranena beto na totozo tonai mina lame na Tuna na Tinoni,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","<<Ura pana totozo aza za na binangara pa noka za ari mina vei. Kolenana za maka tinoni za taloi keni pa maka nana rererege. Tonai za oqoro keni za kukuria ria na nana nabulu ko za okoto ia vadi na nana zakazava ko mari kopu vani za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ko tana maka za vani ka lima baeke poata, tana maka za vani kori baeke poata, beto tana maka mule za vani maka baeke poata. Ria doru za okoto vadi na padana na dia boka beto za taloi keni pa nana rererege. ");
INSERT INTO ghn_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ego na nabulu aza za tekua ka lima baeke poata za aza tugu za tekua za keni gu varoitia za na poata, ko na vuana za tekua za ka lima baeke poata mutugu. ");
INSERT INTO ghn_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Aza na tinoni za tekua kori baeke poata ba za vei tugu, ko na vuana za tekua za kori baeke poata mutugu. ");
INSERT INTO ghn_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Goto aza na tinoni za tekua maka baeke poata, za za keni gelia na pezo ko za golomo vapaea za na poata tana nana bangara. ");
INSERT INTO ghn_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ego za zovai tu beto za gabala mule kamu za na bangara tadi ari kue nabulu ari ko mi dogoria ae qari varoiti veini ria ari ria na nana poata za gua. ");
INSERT INTO ghn_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na nabulu za tekua ka lima baeke poata za luge lao, ko za kaqama laoni aza ka lima baeke poata beto ka lima baeke poata mule na vuana. Beto za paranga aza, <Bangara, ka lima baeke poata za qu vaniziu ao. Dogoro! Qa vavuai ko ka lima baeke poata mule za qa tamo laoni ara tonai,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nari za parangia na bangara aza, <Leana jola. Na nabulu leleamu beto na tarangemu ao. Qu tarange pa kopuna ka viza poata ari ao, ko koviria mana vakopunigo kubo zakazava ara ao. Mae lame ko mu somanani na qeraqera tana mua bangara,> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Beto za luge lao gu mule aza na tinoni za tekuria kori baeke poata, ko ari za guni vei, <Bangara, kori baike poata za qu vaniziu ao. Dogoro! Qa vavuai ko kori baeke poata mule za qa tamo laoni ara,> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nari za parangia na bangara aza, <Leana jola. Na nabulu leleamu beto na tarangemu ao. Qu tarange pa kopuna ka viza poata ao, ko koviria mana vakopunigo kubo zakazava ara ao. Mae lame ko mu somanani na qeraqera tana mua bangara,> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Beto za luge liguligu lao za na nabulu za tekua maka baeke poata, ko za paranga, <Bangara, qa gilagilaiqua ara za maka tinoni tapatamu ao. Ura ao qu boka ababu ketakoi quke umuma, beto qu aqaqono varikamu ketakoi quke vavuvuzia maka kiko. ");
INSERT INTO ghn_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ko qa matagutuqua ara, ko qa keni geli golomo vapaea pa pezo za na mua poata. Ko, dogoro, ani aza na mua,> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nari za oea na nana bangara, ari za guni vei, <Na nabulu ikikeremu beto na ududapelumu ao! Beko qu tori gilagilaimua tugu ao za ara qa ababu ketakoi qake umuma beto qa aqaqono varikamu ketakoi qake vavuvuzia maka kiko. ");
INSERT INTO ghn_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ko za vei za vei buke nyorogua varoitia ao aza, za bu valugea gu pa banga za na qua poata. Ko bu vei ao za totonai ba mule kamu za ba kamu tekua za na qua poata taviti vuana. ");
INSERT INTO ghn_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ego ko, ka viza nabulu, mu tekua za na poata tana tinoni ani, ko mu valao vani aza na tinoni za izongia manogaputa baeke poata. ");
INSERT INTO ghn_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ura na tinoni za kolenana za mina taia mutugu ko mina pugele nyonyoa na nana. Goto na tinoni za kepore nana za mina tateku pale za aza vei iapeki za izongia aza. ");
INSERT INTO ghn_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mu tekua za na nabulu kepore maka za bi vapodoa ani, ko mu gona votu laoni pa peguru rorodomona. Ketakoi mari lukana uui beto mina ngingizi tu na livodi ria na tinoni,> za gudi,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","<<Tonai mina lame pana neqi tana bangara za na Tuna na Tinoni za pala mari tutia ria doru mateana, ko mina nyumu pa nana nyumunyumuna bangara aza. ");
INSERT INTO ghn_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ko ria doru puku tinoni za mari varikamu lao pa moena aza. Ko aza mina varipikataidi pa kori pikatana maka moqaza podeke vei na sepati za mijata pikata tekuria na sipi tadiria na qoti. ");
INSERT INTO ghn_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ko mina vakoledi pa kale matuana ria na sipi, goto ria na qoti za mina vakoleria pa kale merina. ");
INSERT INTO ghn_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Beto za mina parangaria na bangara ria na tinoni pa kale matuana, <Mae, lame gamu za manadigamu na Tamaqu! Mu teku izongia na binangara, aza za vatana vakole vadigamu na Tamaza pa podapodalaina tu tonai za taroiti na kasia guguzu. ");
INSERT INTO ghn_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ura tonai qa burana ara za gamu iaziu, qa kidepe ara za gamu vabukuziu, na tinoni gotoqu ara ba gamu vatoga valeaziu gamu pa miu ruma. ");
INSERT INTO ghn_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na gadogadoqu, ba gamu vapokopokoziu; qa mo, ba gamu kopuniziu gamu; tonai qa tapiu, ba gamu ovikiziu tugu gamu,> mina gua. ");
INSERT INTO ghn_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nari mari oea ria na tinoni tuvizidi, ari mari gua, <Bangara, pa viza za qu burana ao ko gami iago gami? Toto za qu kidepe ao za gami lao vanigo na pie gami? ");
INSERT INTO ghn_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Pa viza za na tinoni gotomu gamigunigo, ko gami vatogago pa mami ruma gami? Beto pa viza gami batigo na gadogadomu ko gami vapokopokogo gami? ");
INSERT INTO ghn_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Toto za gami batigo qu korapa momomu ao beto ko pa viza za na suveremu pa ruma varipiuna ko gami lalao ovikigo gami?> mari gua. ");
INSERT INTO ghn_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nari mina oeria na Bangara ria, ari mina gudi vei, <Ma poja zozotodigamu ara gamu: tonai gamu roiti laoni gamu maka roiti leana tana maka ria na taiqu nake poreveveidi ari, za gamu korapa tugu roiti valame vaniziu ara aza,> mina gua. ");
INSERT INTO ghn_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Beto za mina paranga laoria aza ria pa kale merina, ari mina gua vei, <Mu taloi taqu za gamu, gamu za tori levelevedigamu tu na Tamaza. Mu lao pa iku kole jolana aza za tavatana vakole vani na bangaradi na tomete beto ko ria doru nana mateana! ");
INSERT INTO ghn_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ura tonai qa burana ara, ba gamuke izongo ia podekeziu tugu ara za gamu; tonai qa kidepe, ba gamuke vabukuziu; ");
INSERT INTO ghn_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","tonai na tinoni gotoqu tugu ara, ba gamuke vatogaziu pa miu ruma ara za gamu; na gadogadoqu tugu, ba gamuke vapokopokoziu ara za gamu; tonai na momoqu tugu beto na tapiuqu tugu pa ruma varipiuna, ba gamuke galaniziu ara,> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nari za mari oea ria za na Bangara, ari mari gua vei, <Bangara, toto za gami batigo gami qu kole burana, na kidepe, na tinoni gotomu, na gadogadomu, qu mo, babi qu tapiu ao, beto gamike pavu galanigo na tokanigo gami?> mari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nari mina oeria na Bangara ria, ari mina gua vei, <Ma poja zozotodigamu ara za gamu: tonai gamu daimiu tokani za maka ria nake poreveveidi ari, za gamu daimiu tokaniziu tugu ara,> mina gudi. ");
INSERT INTO ghn_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ko ria na tinoni ikeredi ari za mari tavalao pa vinakilasa kole jolana, goto ria na tinoni tuvizidi za mari lao pa toa jola,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ego totonai za beto varivagigalaidi i Jisu ria doru zakazava ari, za ari za gudi vei ria nana sepele, ");
INSERT INTO ghn_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","<<Gamu tori gilagilaimiu tu gamu za kori rane gu za kole beto mina kamua za na rane vavolo Alokata, ko totonai za pala mina tavalao pa limadi ria na tinoni za na Tuna na Tinoni ko mina tavauke pa korosi,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ko na totozo tugu aza za ria na kuta iama beto ria na tiolata matamata tadiria na tinoni za qari varikamu pa ruma ti Kaiapasi aza na kuta iama lavata. ");
INSERT INTO ghn_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ko qari roitidi kaki roquroqu vei beto mari aru tamana golomia ko mari vaukea i Jisu qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ba ari qari kole variparanga vei ria, <<Dai, taneke roitini na roiti aza pa totozo vavolo Alokata, ura keta takole variperadi ria na tinoni,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ego za lao suverenana pa Betani i Jisu, pa ruma ti Saimone aza za rajai na poqupoqu perangaina. ");
INSERT INTO ghn_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ko tonai za korapa tekuteku i Jisu za luge lao za maka reko za pogozia maka tototona za taroiti pa maka patu batabata leana. Za pugelia na lumu omanga lea beto za zae viva na vaina za na tototona aza. Ko za lobitia, beto za vuvani pa batuna i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nari totonai qari batia ria na sepele ani, za qari tagigiri ria ko qari paranga, <<Ae za vei ko za korapa aru vikevikeria na lumu zana! ");
INSERT INTO ghn_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aza bi boka tatekuni poata lavatana zana, ko bi iadi ria na tinoni varivasevidi!,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ba za tori gilagilainana tu i Jisu za na paranga qari pojai ria, ko ari za gudi vei, <<Ae za vei ko gamu korapa tu poja vikevikeria gamu za na reko ani? Maka roiti leana za roiti lameni aza taqu. ");
INSERT INTO ghn_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ura gamu suvere tavitiriamiu gu gamu doru totozo ria na tinoni varivasevidi, goto ara za manake suvere tavitigamu lalaoqua. ");
INSERT INTO ghn_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tonai za vuvani na lumu na reko ani za na tiniqu ara, za vatanani aza ko mina tagolomo za na tiniqu ara. ");
INSERT INTO ghn_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ma poja zozotodigamu ara gamu: doru kota pa kasia guguzu mina tatarae na nongoro leana ani, za mina tavavavakato tugu za na roiti za roitini na reko ani taqu, ko minake tamuma za na reko aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pa liguna aza za maka ari ka manogori sepele, na izongona i Jiudasi Isikarioti, za lao tadiria na kuta iama, ");
INSERT INTO ghn_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ko ari za gudi vei, <<Na za muna vaniziu ara gamu, ko mana boka tokadigamu ko muna boka aru tamania gamu i Jisu?>> za gudi. Nari qari nguti tekuria za ka uengavuluputa poata siliva, ko qari vani. ");
INSERT INTO ghn_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ko za podalai tugu na totozo aza za podalai nyaqonyaqoa i Jiudasi za maka lolomo leana vei beto mina tokadi ko mari boka aru tamania ria i Jisu za gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tonai za kamua za na rane momoe tonai mina taroiti za na vavolona na Bereti Nake Kovuruna, za qari lao ria na nana sepele ko qari nanazia i Jisu, <<Pae za qu nyoroguani ao ketakoi mami vatana vanigo gami za na vavolo Alokata?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nari ari za gudi vei, <<Mu lao tana tinoni ani pa Jerusalema, ko ari muna guni vei, <Ari za gua vei za na tinoni varivagigalai, za tata kamua za na qua totozo. Ko koviria za ara beto ria na qua sepele za mami tekua na vavolo Alokata pa ruma tamu za gua,> muna guni,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ko qari lao tugu ria na sepele ko qari vatanani za na tekutekuna Alokata aza vei za pojadi i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ego ko totonai za gore na veluvelu za nyumu tekuteku tavitiria i Jisu ari ka manogori nana sepele. ");
INSERT INTO ghn_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ko tonai qari korapa tekuteku ria za paranga i Jisu, <<Ma poja zozotodigamu ara za gamu: maka gamu ari za mina gabala kanaziu ara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nari za qari takulanga beto ria na sepele, ko qari okoto nananaza makamakai aza, <<Bangara, nake ara za qu guniziu ao, uve?>> qari okoto gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nari za oeria i Jisu, ari za gudi vei, <<Aza za somana togotogolo tavitiziu pa baolo ara na gana bereti za aza tugu za mina gabala kanaziu ara. ");
INSERT INTO ghn_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Na Tuna na Tinoni za mina tavauke vei tugu aza za pojai na Kutikuti Tabuna, ba mina gana na takulanga aza na tinoni za gabala kanai aza! Za leana jola za bike pavu tavapodo za na tinoni aza!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nari za paranga i Jiudasi, aza na tinoni za malumu ko mina gabala kanai i Jisu, <<Rabi, nake ara za qu guniziu ao, uve?>> za gua. Nari za oea i Jisu aza, <<Aza makamu qu pojai aza,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ego totonai qari korapa tekuteku ria, za tekua i Jisu za na bereti, ko za manani, beto za kipakipai ko za iadi ria na nana sepele, beto za paranga, <<Pia ko mu tekua, ani za na tiniqu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Beto aza za ovulia za na kapa, ko za paranga leana laoni tana Tamaza, ko za vadi ria na nana sepele beto za paranga, <<Mu bukua gamu doru ani; ");
INSERT INTO ghn_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","na orunguqu ani, aza na vamauruna na taringutinguti tana Tamaza tadiria nana tinoni. Na orunguqu ani za nyoro ko na vulazadi na sela tadiria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ma poja valeadigamu: pala manake buku sogai ara za na vaini ani, tinganai tu mina kamua na rane mana buku tavitidigamu ara na vaini korega pa binangara tana Tamaqu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Beto za jola gu za vei zara, za qari kerani maka kera, beto qari votu ko qari taloi lao pa kubo pa Olive. ");
INSERT INTO ghn_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ego ketakoi za parangaria i Jisu ria na nana sepele, <<Pana veveiqu ara za ngena bongi za gamu doru pala muna uku loi pale betoniziu ara, ura ari za gua vei za na Kutikuti Tabuna, <Ara mana vaukea za na sepati, ko na varikamu godo sipi za mari okoto nyanyalia na kota,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ba pa liguna mana turu mule pa uke ara, za mana lao momoe pa Qalili ara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nari ari za gua vei i Pita, <<Goto ara za vei mari uku loi palenigo tu ria doru, ba manake uku loi palenigo ara!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nari ari za guni vei i Jisu aza, <<Ma poja zozotonigo ara ao: pa na bongi tugu ani tonai mina oqoro kiu na kokorako za pala muna kilu paleniziu kue totozo ara ao,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nari za paranga i Pita, <<Vei mana uke tavitigo tugu ao, ba manake izongo kilu palenigo tugu ara,>> za gua. Ko ria doru sepele za qari paranga vei beto tugu zara. ");
INSERT INTO ghn_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ego beto za tokaria i Jisu ria na nana sepele, ko qari lao pa maka ia na izongona pa Qetisemani. Beto za poja veidi ari, <<Mu nyumu pani za gamu, goto ara ma jola lao varavara pata lao pa nari,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ko i Pita gu beto kori tuna marene gu i Jebeti za tokaria. Za takulanga beto za roquroqu mamata vitivitigi aza, ");
INSERT INTO ghn_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ko za parangaria ari kue, <<Za lavata jola pa buloqu za na takulanga ani, ko pala mina boka vagojoziu tu. Mu suvere pani ko mu suvere gelegele tavitiziu,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Beto za rerege rijo lao iapeki aza, ko za gona kole opo kokou pa pezo, ko za varavara, <<Tamaqu, bi vei bu boka ao, za mu varijoia taqu za na kapa vitigi ani. Ba nake aza vei qa nyoroguani ara za mina taroiti, goto aza tu vei qu nyoroguani ao,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Beto za rerege mule lao tadi ari ka kue sepele, ko za batiria qari korapa putagedi nari za parangia i Pita, <<Ai vei, quke boka suvere gelegele tavitiziu ara maka totozo papakana za gamu? ");
INSERT INTO ghn_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mu suvere gelegele beto mu varavara ko muke gozoria na toketoke. Na ongongu za malumu, ba na tini za munyala,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Beto za gabala mule soga lao varavara i Jisu, ari za gua vei, <<Tamaqu, vei minake boka tavarijo za na kapa vitigi ani goto mana bukua tugu ara, ba leana gu. Aza gu qu nyoroguani ao za mi taroiti,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Za beto aza za gabala mule soga lame mutugu tadi ari ka kue sepele za batiria qari korapa puta betogedi, ura za ngaolo vitivitigiria na nyoro puta. ");
INSERT INTO ghn_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ego za loiria mutugu i Jisu ari ka kue ko za mule keni soga varavara na vinaue totozo, ko za maka pojaria mutugu aza ria za tori varavaradi tu. ");
INSERT INTO ghn_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Beto za gabala mule tadi ari ka kue sepele, ko ari za gudi vei, <<Gamu korapa tugu putagemiu beto minyeremiu za gamu? Dogoro! Mi kamua gu za gua za na totozo na Tuna na Tinoni mina tavakarovo lao pa limadi ria na tinoni seladi. ");
INSERT INTO ghn_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Turu ko talao. Dogoro! Za kamu gu ani na tinoni za gabala kanaziu ara,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ko za korapa tugu paranga vei zara i Jisu za bola gu i Jiudasi, aza maka ari ka manogori sepele. Qari garunu vatutini ria na kuta iama beto na tiolata matamata tadiria na tinoni za maka puku minete tinoni lavata. Qari okoto pogozo benete variperana beto na kubau. ");
INSERT INTO ghn_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ko za tori poja vakoledi tu ria i Jiudasi perangaina za maka vinagilagila mina roitini ti Jisu, ari za gudi vei, <<Aza na tinoni mana lao aoa ara, za aza tugu za na tinoni gamu nyoroguani gamu, ko muna lao gu aru tamania aza,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ko za rerege toto lao gu i Jiudasi i Jisu, ko za gozoro qeraqerani, <<Leana, Rabi!>> za gua, beto za aoa i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nari ari za guni vei i Jisu aza, <<Baere, na za za qu lameni ao?>> za gua aza. Beto za qari aru tamania ria i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na totozo tugu aza za maka ria na sepele za tutia i Jisu za saputu tekua za na nana benete variperana ko za taqaza teusu pale za maka kale talingana na pinauzu tana kuta iama lavata. ");
INSERT INTO ghn_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nari za lao i Jisu ko za tokea za na tinoni aza, <<Mu soba muleni pa nana sobasobana za na mua benete zana! Ria doru qari aru benete varipera za mari uke tugu pa benete varipera. ");
INSERT INTO ghn_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ae za vei quke gilagilai tu ao za nake tapatana taqu za ara ba boka tepai gu na Tamaqu ko bi garunu lageredi ria na zoku vuro mateana ko bari tokaniziu? ");
INSERT INTO ghn_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ba vei mana roiti vei zara ara, za minake boka gore votu za aza vei za pojai pa Kutikuti Tabuna na veveina aza qa korapa gozoria ara,>> za guni i Jisu aza. ");
INSERT INTO ghn_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Na totozo aza za ari za gudi vei i Jisu ria na minete tinoni, <<Maka tinoni raja ikikoqu ara ko gamu pogozo bola tariniziu tu na benete beto na kubau ko muna tekuziu? Doru rane za pa kakabarena na zelepade gu qa kole suvere varivagigalai ara, ba gamuke aru tamanaziu. ");
INSERT INTO ghn_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ba doru zakazava ari za qari taroiti ko vei tugu ko mi gore votu beto ria na korokorotai tadiria na tinoni korokorotai,>> za gua aza. Beto za ria doru sepele za qari okoto uku loi pale aza. ");
INSERT INTO ghn_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ego ko ria tugu qari aru tamana tekua i Jisu za qari toka laoni aza pa ruma ti Kaiapasi, aza na kuta iama lavata. Ko ketakoi qari kole suvere varivarikamudia ria qari varivagigalaini na Vavanau beto ko ria na tiolata matamata. ");
INSERT INTO ghn_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ba i Pita za kole tututi vazozounana tu pa liguligu, tinganai za lame kamu pa bolebole sebesebe na ruma tana kuta iama lavata. Beto za luge lao pa leo kakabarena na ruma ko za lao nyumu varirurainana tadiria na nabulu kopu ko mi dogoria aza za na roiti mari roitini ria ti Jisu za gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Qari podekia ria na kuta iama beto ko ria doru tiolata pa kauniseli ko mari nyaqo votudi za kaki vinazozoto sekesekedi, ko mari boka vaukea i Jisu qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ko kubo ria za qari turu vavotuvoturia na paranga sekesekedi, ba kepore za maka ginugua leana bari batia vei bari boka vaukea aza. Pana vinabetobetona za qari turu za kori tinoni, ");
INSERT INTO ghn_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ko ari qari gua vei, <<Za paranga za na tinoni ani, <Mana boka jegara pale ara za na zelepade madina tana Tamaza, beto pa rane vinaue za mana vaturu sogai ara,> za gua,>> qari gua ari kori. ");
INSERT INTO ghn_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nari za turu za na kuta iama lavata ko za nanazia i Jisu, <<Ae vei, quke boka oeia ao aza qari jutunigo ari kori zara?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ba zake vagala i Jisu. Nari za paranga za na kuta iama lavata, <<Pa korapa izongona na Tamaza toana za qa pojanigo ara ao: mu ule valeana vadigami, ao tugu za na Karisito na Tuna na Tamaza?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nari za paranga i Jisu, <<Aza tugu qu pojai ao. Ba ma poja valeanadigamu ara ani: podalai koviria ko mi lao pala muna batia gamu za na Tuna na Tinoni mina nyumu pa kale matuana na Tamaza vivana jola, beto mina mule lame vei pa lei pa noka!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aza tugu za nongoria za paranga vei zara i Jisu za bako rikata pale na kuta iama lavata za nana poko beto ari za gua vei, <<Za vamoroania na Tamaza za na tinoni ani! Na vinazozoto za mule za tana nyaqoa gita? Dogoro, gamu tori nongoriamiu tugu gamu za poja vikevikeria na Tamaza ani! ");
INSERT INTO ghn_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ko na za na roquroqu gamu vanyumua za gamu ka viza bangara?>> za gudi. Nari qari oe ria na tinoni lavalavata, <<Za pada vitivitigi gu ko mina tavauke aza,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Beto nari za qari tue taria na izumatana beto qari iriruni na variiriruna. Ria kaki tinoni qari kole popoaria ");
INSERT INTO ghn_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","za ari qari paranga veini aza, <<Ego tu, ao na Karisito! Mu ule vadigami tu moko i zei za korapa majago?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ego totonai za korapa nyumunana pa kakabarena na ruma tana kuta iama lavata i Pita, za lame za maka nabulu reko ko za parangia, <<Ao tugu za maka qu tututia i Jisu na tinoni Qalili!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ba za kilu paleni aza pa moedi ria doru, ari za gua vei, <<Qake gilagilai ara za na manugu qu korapa pojai ao zana,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tonai za votu lao pa atakamanana na kakabarena na ruma za batia mule maka nabulu reko aza, ko ari za gudi vei ria na tinoni qari suvere ketakoi, <<Na tinoni ani za kole tugu tututi ti Jisu na tinoni Nazareti!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ba za kilu pale mutugu taviti maulu i Pita, ari za gua vei, <<Qake izongo gilagila podekia tugu ara za na tinoni zana!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Za oqoro zovai gu za vei zara, beto za qari lao gu ria na tinoni qari kole turu ketakoi ko ari qari guni vei i Pita, <<Ao zozoto gu za maka ria qari tututia i Jisu, ura na vakerana na mua vokele paranga za ulenigo zozoto ao,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nari za paranga i Pita, <<Qa maulu ara ko qa korapa pojai na zozoto! Vei mana sekeseke za mina vakilasaziu na Tamaza! Qake gilagilai ara za na tinoni gamuguni gamu zana!>> za gua. Ego aza tugu za paranga vei zara i Pita, nari za kiu gu za na kokorako. ");
INSERT INTO ghn_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Beto za gilagilai kamua i Pita za aza vei za pojai perangaina i Jisu tonai ari za guni vei, <<Mina oqoro kiu na kokorako, za ao muna kilu paleniziu kue totozo,>> za guni. Ko za votu pa peguru i Pita ko za lukana vapazani. ");
INSERT INTO ghn_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na volavolaza leana za qari varikamu ria na kuta iama beto ria na tiolata matamata, ko qari kole varingodoni kaki roquroqu vei beto mari vaukea i Jisu qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Beto za qari piua i Jisu ko qari toka laoni ti Paelati na qavuna. ");
INSERT INTO ghn_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ego tonai za gilagilai i Jiudasi, aza za gabala kanai i Jisu, za tapitu ko mina tavauke i Jisu, nari za roqu mule aza ko za pogozo mule laodi tadiria na kuta iama beto na tiolata matamata za ka uengavuluputa poata siliva, ");
INSERT INTO ghn_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ari za gua vei, <<Qa sela ara, ura na tinoni tuvizina za qa gabala kanai ara ko mina tavauke,>> za gua. Nari ari qari guni vei ria aza, <<Ko ae mami veini gami? Aza na mua ginugua tu makamu ao aza,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nari za lao gona paleni pa zelepade madina i Jiudasi za na poata, beto za taloi keni boru ukenana. ");
INSERT INTO ghn_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ko qari tekua ria na kuta iama za na poata, beto ari qari gua vei, <<Na poata laona na orungu za ari, ko nake tavamalumuna pana Vavanau za mina tavalao pa poata ruma zelepade,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ko qari varingodoni ria za na roquroquna na poata aza ko qari vaini maka iapeki kobu pezo tana tinoni za roiti raro patu, ko ketakoi za na varivarigolomona tadiria na tinoni gotodi. ");
INSERT INTO ghn_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Zara za vei ko na ia aza za qari vaizongoni na Kobu Pezo Orungu, ko za korapa kole tinganai za kamua tu pa rane pa ngenari ani aza. ");
INSERT INTO ghn_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ko za gore votu tugu za na korokorotai aza za lame vei ti Jeremae na tinoni korokorotai, ari za gua vei, <<Ko qari tekuria za ka uengavuluputa poata siliva, na vaina aza qari malumu vaini ria na tinoni Izireli, ");
INSERT INTO ghn_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ko qari vaini iapeki kobu pezo tana tinoni roiti raro patu, aza za garununiziu na Bangara ara ko mana roitini,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ego ko za lao turu pa moena i Paelati na qavuna i Jisu, ko za nanazia na qavuna aza, <<Na bangara tugu tadiria na Jiu ao?>> za guni. Nari ari za gua vei i Jisu, <<Aza tugu qu pojai ao zana,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tonai qari jutuni doru paranga ria na kuta iama beto na tiolata matamata, za zake pavu oeria i Jisu ria. ");
INSERT INTO ghn_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nari za parangia i Paelati aza, <<Ae vei, quke nongororia ao za doru zakazava qari jutunigo zara?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ba kepore tugu za maka pakata paranga peki bi oe laoni i Jisu, ko ketakoi za gabara jola za na qavuna. ");
INSERT INTO ghn_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ego pa doru totozo vavolo Alokata za na nana tutina tugu na qavuna za boka ruvata vadi ria na tinoni Jiu za maka tinoni tapiuna mari tepai. ");
INSERT INTO ghn_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ko pa totozo aza za kolenana za maka tinoni tapiuna na tagilagila valeanana za maka tinoni ikikerena jola aza, na izongona i Jisu Barabasi. ");
INSERT INTO ghn_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ko totonai qari lao varikamu beto ria doru tinoni za nanazaria i Paelati ria, <<I zei ari kori za gamu nyoroguani gamu ba ruvata vadigamu ara? I Jisu Barabasi ba i Jisu aza za tapoja na Karisito?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ura za gilagila valeanarianana i Paelati ari ka viza tiolata matamata za qari konoa gu i Jisu ko vei za qari loi laoni tana. ");
INSERT INTO ghn_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Totonai za korapa nyumunana pa nana nyumunyumuna pa ia varivaritutina i Paelati, za garunu laoni na maqotana tana za maka nongoro, ari za gua vei, <<Muke kotia ao na tinoni tuvizina zana, ura kubo zakazava varivatakulangadi za qa putagitaria ara pa bongi na veveina na tinoni zana,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ego pa totozo aza za ria na kuta iama beto na tiolata matamata za qari paranga sorisoriria ria na minete tinoni, ko mari parangia tugu i Paelati ko mi ruvatia i Barabasi goto i Jisu za mina tavauke tugu qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ba i Paelati za nanazaria mule ria na minete tinoni, <<I zei ari kori ari za gamu nyoroguani gamu ko ba ruvata vadigamu ara?>> za gudi. Nari za, <<I Barabasi!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nari za parangaria i Paelati ria, <<Ko ae mana veini ara i Jisu aza za tapoja na Karisito?>> za gua. Nari za qari oe lao ria doru, <<Aza za mi tavauke gu pa korosi!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ba za nanaza liguria mutugu i Paelati ria, <<Na sela za za roitini aza?>> za gudi. Ba totonai za qari velavela vaiolo viviva ria, ari qari gua vei, <<Vaukea pa korosi!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Totonai za dogoro gilagilai i Paelati za kepore mule maka za mina boka roitini aza goto na varipera gu za pala mina podo za gua, nari za lao nobu pie ko za loqa lima pa moedi ria na minete tinoni, beto ari za paranga vei, <<Ara za qa talegazani za na uke tana tinoni ani! Koviria za na miu ginugua tu makamiu gamu ani,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Qari paranga ria na minete tinoni doruna, <<Leana, gami beto ria na tumami mami gozoroni vinakilasa za na uke tana tinoni zana!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ko za garunuria i Paelati ria na solodia ko qari ruvatia i Barabasi, beto za pa liguna qari iruni variiriruna i Jisu za loi lao vadi ko mari vaukea za gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Beto za qari toka laoni ria na solodia ti Paelati pa kakabaarena na ruma tana qavuna i Jisu, ko qari lao turu varilivutai betoni ria na minete solodia doruna aza. ");
INSERT INTO ghn_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Qari jokolo vagore pale za nana poko, beto qari vazae sogani maka poko gojo jemejemerena. ");
INSERT INTO ghn_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Beto qari tekua na kae suvege variokana ko qari polo vadididolai varipilupiluaini beto za qari vasolapani pa batuna, beto qari tekua maka kolu ko qari vaaruni pa lima kale matuana. Beto za qari kole totodongo pa moena ko qari kole vavagoreni qera, ari qari gua vei, <<Mi toa vakakaza tu na bangara tadiria na Jiu!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Beto za qari tue taria, beto qari majai na batuna. ");
INSERT INTO ghn_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pa liguna qari beto vavagoreni qera veini zara, za qari vagore pale za na poko jemere qari vazaeni, ko qari vazae sogani nana poko, beto za qari toka votu laoni ko mari vaukea pa korosi qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ego totonai qari taloi keni za qari lao gozoria za maka tinoni pa Saerini, na izongona i Saimone. Qari juju tarini ko qari vapogozoni aza ria na solodia za na korosi ti Jisu. ");
INSERT INTO ghn_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Qari lao kamua ria za maka ia na izongona pa Qoloqota, na ginuana za na Kota Batu Tomete. ");
INSERT INTO ghn_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pa ia ketakoi za qari vani na vaini aza qari varisomanaini na zakazava pazana za vamalibua na vitigi. Ba tonai za gilagilai na lingilingina za paza nari za dainana bukua. ");
INSERT INTO ghn_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Qari vaukea pa korosi ria aza, beto za qari gonani na patu mijamijata ko qari mijatia i zei mina tekuria ria nana poko. ");
INSERT INTO ghn_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Beto nari za qari kole nyumu dogoro kopuni. ");
INSERT INTO ghn_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Qari kuti vakolea pa korosi pa toto batuna pa narena aza ria na paranga za tajutuni aza, ari za gua vei: ANI I JISU NA BANGARA TADIRIA NA JIU. ");
INSERT INTO ghn_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ko qari makarai vauke tavitini aza za kori tinoni raja ikikodi, maka keta pa kale matuana, maka keta pa kale merina. ");
INSERT INTO ghn_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ria na tinoni qari rerege jola za qari begobegolo beto bekubekuturia na batudi beto qari au beto poja vikevikere pale i Jisu, ");
INSERT INTO ghn_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ari qari gua vei, <<Ao na tinoni muna jegaria na zelepade madina beto pa rane vinaue muna roiti sogani qu gua! Ego tu mu alo mulenigo makamu vei muna Tuna na Tamaza ao. Mu tavizu goremua pa korosi!>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ko ria na kuta iama, ria qari varivagigalaini na Vavanau beto ko ria na tiolata matamata ba qari kole ngangangulu veini tugu zara i Jisu, ari qari gua vei, ");
INSERT INTO ghn_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","<<Na goto tinoni tu za aloria, goto makana zake boka alo muleni makana! Na Bangara pa Izireli aza za gua ke! Ko koviria mi tavizu gore lagere tu pa korosi ko tavazozotoa. ");
INSERT INTO ghn_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Za rangea ko na Tamaza beto makana ba, <Ara za na Tuna na Tamaza,> za gua. Ko aria ko tadogodogoro kopuni moko! Mina nyorogua tugu beka aloa na Tamaza aza!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ari kori tinoni raja ikikodi qari titi tavitia aza pa kori kalena ba qari somana paranga ngangangulu veini tugu aza. ");
INSERT INTO ghn_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ego podalai na korapa rane za udea na rodomo kunikuni za na doru kota, ko za kole rodomo pada kue aoa. ");
INSERT INTO ghn_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ko za kamua padapada vei kue koloko za kukuku lukana i Jisu, <<Elai, Elai, Lama Sabakatani?>> za gua. (Na ginuana za ari za gua vei, <<Qua Tamaza, qua Tamaza! Ae za vei ko qu loi paleniziu tu ao?>> za gua.) ");
INSERT INTO ghn_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kaki ria qari korapa turu ketakoi za qari nongoriadia za paranga vei zara aza, ko qari paranga ria, <<Na tinoni zana za korapa kukua i Elaija,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ko maka ria za siqarai abutu lao tekua maka poko, ko za vatubuluni maka buku pazana, ko za vakolea pa uquna na kolu, beto za alaka zaeni ko mi vabukua za gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ba qari paranga ria kaki, <<Loia ko! Tadogodogoria mae, palu pala mina kamu aloa i Elaija zana!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Beto za maka lukana vaiolo viviva i Jisu, beto za loia na singo. ");
INSERT INTO ghn_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ko pana totozo tugu aza za na toba poko babana za piko pa ia madina pa zelepade za tarikataori, za podalai tu pa nulu ko za gore tu kamu pa uquna pa pezo. Ko za jojou za na pezo ko qari tapaqapaqala za na patu, ");
INSERT INTO ghn_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ria na bevi varivarigolomona za qari tajejegara ko qari tarevanga, ko na motadi ria na tinoni tana Tamaza qari tori uke tu pa moa za qari tavatoa mule. ");
INSERT INTO ghn_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ko qari turu taloi pa dia bevi, ko pa liguna za turu mule i Jisu za qari luge lao pa guguzu tabuna pa Jerusalema, ko qari batiria ria na mota tinoni suveredi ketakoi. ");
INSERT INTO ghn_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na tinoni matamata gogoto beto ko ria na tinoni varipera qari suvere tavitia aza ko qari kole kopuni i Jisu za qari matagutu vitivitigi totonai qari vagilagilai na nunu beto doru zakazava qari taroiti, ko qari paranga ria, <<Zozoto na Tuna tugu na Tamaza za na tinoni ani!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ego na motadi ria na reko qari rererege tavitia i Jisu na koko lame veidi pa Qalili ko qari tokatokani aza za qari kole tugu suveredia ketakoi. Qari turu pa zouna ko qari kole dogodogoro lao. ");
INSERT INTO ghn_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ko ari Mere pa guguzu Magadalene, i Mere na tinadi ari Jekopi i Josepa, beto na maqotana i Jebeti za qari kole tugu suvere varisomanaidia tadiria na reko ketakoi. ");
INSERT INTO ghn_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ego totonai za gore za na veluvelu za kamu i Josepa maka tinoni izizongo pa Arimatia. Maka sepele tugu ti Jisu aza. ");
INSERT INTO ghn_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Za lao ti Paelati aza ko za tepai za na kobukobu tinina i Jisu. Nari za vamalumia i Paelati ko mari loi lao vani i Josepa za na kobukobu tinina i Jisu za gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ko za lao teku vagorea i Josepa za na kobukobu tinina i Jisu, ko za udeni maka poko liosona. ");
INSERT INTO ghn_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Beto za lao vakolea pa nana bevi koregana, aza za koni ruri vaoqilia pa patu. Ko za bokili laoni maka patu lavata za pa atakamanana na bevi, beto za keninana. ");
INSERT INTO ghn_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ko i Mere pa guguzu Magadalene, beto maka goto Mere mule za qari kole tugu nyumu bata lao veidia tugu pa bevi aza. ");
INSERT INTO ghn_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ego za rane soga na kota, na rane Minyere, za qari makarai lao kamua i Paelati ria na kuta iama beto na Parese. ");
INSERT INTO ghn_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ko qari paranga ria, <<Bangara, gamike roqu mumani gami za na paranga tana tinoni sekesekena zana totonai za korapa toana aza za pojai, ari za gua vei, <Pa rane vinaue mana toa mule pa uke ara,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ko muna garunu laodi tu kaki tinoni kopu za pa bevi ko mari kopu valeanani tinganai mina jola tu kue rane. Keta ria na nana sepele gu mari kamu iko tekua za na kobukobu tinina beto mari lao sekeseke tadiria na tinoni, <Za tori toa mule tu pa uke aza,> keta mari gua. Ko aza na sekeseke aza za keta mi ikerena jolani na momoena,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nari za ari za gudi vei i Paelati, <<Mu lao tekuria kaki solodia ko mu kopu valeana veini aza muna bokai gamu za na bevi,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nari qari taloi keni ria ko qari lao varamata valeania maka vinagilagila pa patu patena na bevi, beto za qari vasuvereria na tinoni kopu ko mari kopu valeanani qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ego pa liguna na rane Minyere ko na volavolaza leana na rane momoe pa vuiki, za i Mere na reko pa guguzu Magadalene beto maka goto Mere mule za qari lao ko mari dogoria na bevi qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nari za raja za maka nunu lavata, ura maka mateana tana Bangara pa noka za gore lagere beto ko za bokili varijo pale za na patu za tapateni na bevi, beto za keza kole nyumunana pa narena. ");
INSERT INTO ghn_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ko na dogorona na tinoni aza za vei na malarana na kapi, beto nana poko ba qari keka keala lelei. ");
INSERT INTO ghn_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ria na tinoni kopu ba qari matagutu vitivitigini aza, ko qari gona kole neqeneqere vei na tinoni mari uke qegua. ");
INSERT INTO ghn_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Beto ari za gudi vei na mateana ari kori reko, <<Muke matagutu! Qa gilagilaiqua ara za gamu korapa nyaqoa gamu i Jisu aza za tavauke pa korosi. ");
INSERT INTO ghn_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kepore pani aza, ura za tori toa mule tu aza aza mina vei za gua za tori poja vakolea tu perangaina. Mae, lame ko mu dogoria za ketakoi za kole aza perangaina. ");
INSERT INTO ghn_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Beto za muna siqarai lao pojadi ari ka viza nana sepele, <Za tori toa mule tu pa uke aza, ko koviria za tori lao momoe tu pa Qalili aza. Ketakoi tu za muna batini gamu!> muna gudi. Mu roquroqua aza qa koni pojadigamu ani,>> za gua za na mateana. ");
INSERT INTO ghn_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ko qari taloi siqasiqarai pa bevi ari kori. Qari matagutudia tugu, ba qari qera vitivitigi tugu, ko qari abutu keni ko qari lao pojadi ria na nana sepele qari gua, ");
INSERT INTO ghn_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","za lame tugu gozoro qeraqeradi i Jisu, <<Leana!>> za gua. Nari qari lao tana ari kori, ko qari todongo aru tamana pa kori nenena, ko qari vatarazaea aza. ");
INSERT INTO ghn_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Beto za parangaria i Jisu ari kori, <<Muke matagutu! Mu lao pojadi ria na taiqu ko mari lao pa Qalili. Ko ketakoi tu za pala mari batiziu ria ara,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ego ko totonai qari korapa rerege mule kenidia ria na reko, za kaki ria na solodia qari kopu pa bevi za qari lao pa Jerusalema, ko qari lao vavakatodi tadiria na kuta iama ria doru ginugua qari podo ari. ");
INSERT INTO ghn_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nari qari varikamu ria na kuta iama na tiolata matamata ko qari vaturua za maka roquroqu ko qari vani vazokudi na poata ria na solodia qari kopu pa bevi, ");
INSERT INTO ghn_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","beto ari qari naqu veidi, <<Ari muna gua za gamu, <Gami kole puta gami na bongi za qari kamu iko tekua ria na nana sepele za na tinina,> muna gua. ");
INSERT INTO ghn_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Vei mina nongoria na qavuna za na ginugua ani, za gami pala mami paranga valomolomozia aza ko gamu munake gozoro tapata,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ko qari aru vakarovia ria na solodia qari kopu pa bevi za na poata, beto qari tutia tugu aza vei muna roiti vei qari gudi ria na kuta iama. Ko na vavakato aza za tavarerege tadiria na tinoni Jiu tinganai za kamua pa rane pa ngenari. ");
INSERT INTO ghn_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ego ko qari taloi lao pa Qalili ria na nana sepele pa kubo ketakoi za poja vakoledi i Jisu mari adono za gudi. ");
INSERT INTO ghn_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ko totonai qari batia ria i Jisu za qari vatarazaea ria aza, ba kaki qari orirabeke tugu vei. ");
INSERT INTO ghn_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Beto za rerege tata laoria i Jisu ria, ko za parangaria, <<Qa tori taiani tu ara za doru neqi pa noka beto pa pezo. ");
INSERT INTO ghn_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ko za vei za mu lao ko mu vasepele vaniziu ria doru puku tinoni, muna paputaisoria pa izongona na Tamana, na Tuna, beto na Ongu Tabuna. ");
INSERT INTO ghn_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Beto ko muna varivagigalaidi ko mari vataberia ria doru sakasava qa garunudigamu ara. Beto ko ara za mana vavaburogamu doru totozo, tinganai mina kamua na vinabetona na totozo,>> za gua i Jisu.");
INSERT INTO ghn_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ani za na podapodalaina na nongoro leana na veveina i Jisu Karisito, na Tuna na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Na paranga tana Tamaza za takuti pa kutikuti ti Aisea na tinoni korokorotai za ari za gua vei, <<Mu vainongoro! Ara mana garunu laoni pa moemu ao za na qua tinoni pogozo nongoro. Aza za mina vatana vanigo na zona ao, ");
INSERT INTO ghn_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Maka mamalaingi za korapa kukuku pa qega, ari za gua vei, <Gamu za mu vatanani na zona tana Bangara. Mu vaemese vani na zona aza,> za gua,>> za gua i Aisea. ");
INSERT INTO ghn_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ego ko i Jone za na tinoni pogozo nongoro za koko lame vei pa qega ko za kole taraeni aza za na veveidi ria na tinoni mari gabala beto mari paputaiso ko na Tamaza mi taleozodi na dia sela za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nari ria doru pa varilivutaina pa Jiudia beto ria doru pa Jerusalema za qari votu lao tana, ko qari ule votudi na dia sela ko aza za paputaisoria pa leo pie Jodani. ");
INSERT INTO ghn_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ego ko i Jone za vazaea na poko vurungu kameli, na beleti za doko livutuni na sikisikirina, beto na kupo na muji pirudi na gana tekutekuna. ");
INSERT INTO ghn_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ko na nongoro za kole taraeni aza ari za gua vei, <<Pa liguqu ara mina tuti lame maka tinoni aza za poreveveina jolaniziu ara. Ara qa peki jola ko nake padaqu mana opo gore ruvata vani na pikona na nana sadolo aza. ");
INSERT INTO ghn_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ara qa paputaisodi gamu na kolo za gamu, ba aza tu makana za mina paputaisodi gamu na Ongu Tabuna,>> za gua i Jone. ");
INSERT INTO ghn_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pa totozo tugu aza i Jisu za kamu koko vei pa guguzu pa Nazareti pa Qalili ko za lame tapaputaiso ti Jone pa Jodani. ");
INSERT INTO ghn_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ko aza tugu za podaka votu aza pa kolo za batia aza za na noka za revanga beto na Ongu Tabuna za tigoro lagere vei maka kuru kau tana. ");
INSERT INTO ghn_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Beto maka mamalaingi za votu lagere vei pa noka, ari za gua vei, <<Ao za na Tuqu qa roquroqu vitivitigigo ara. Ao za qa qera jolanigo ara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ko pa liguna tugu aza, za toka votu laoni pa qega na Ongu Tabuna i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ko ka madengavuluputa rane za kole toketokea i Setani pa qega aza. Aza za kole suvere tavitiria ria na manugu piru mademade nenedi, ba ria na mateana qari kopu valeanani aza. ");
INSERT INTO ghn_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ego pa liguna za tapiu i Jone, za lugea i Jisu za na ia pa Qalili ko za kole taraeni aza za na nongoro leana na veveina na Tamaza, ");
INSERT INTO ghn_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ari za gua vei, <<Za okoto gu za na totozo beto mi toga gu za gua za na binangara tana Tamaza. Mu gabala gamu ko mu vazozotoa gamu za na nongoro leana,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ego totonai za korapa popoana pa keketaina na ovuku pa Qalili i Jisu, za batiria ari Saimone beto i Aduru na taina marene. Qari korapa vaqaradia pa ovuku ari kori, ura na tinoni abu za ari kori. ");
INSERT INTO ghn_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Nari za kukuria i Jisu ari kori, ari za gudi vei, <<Mae, lame! Tutiziu, ko ma roitidigamu na tinoni abu tinoni,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nari totonai tugu qari turu loi pale gu ari kori za na dia vaqara, ko qari lao tutiadia gu i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ko totonai za rerege rijo lao gu mule iapeki, za batiria gu mule ari Jekopi beto i Jone, kori tamatazi tuna marene i Jebeti, qari korapa tuvaka dia vaqara pa leo dia koaka. ");
INSERT INTO ghn_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Totonai tugu aza za kukuria i Jisu ari kori tamatazi. Nari qari turu loi paleni ari kori pa koaka za na tamadi i Jebeti beto ria na dia tinoni roiti ko qari tutiadia gu i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ego za lao pa guguzu pa Kepaniami i Jisu beto ko ria nana sepele. Ko totonai za kamua za na rane Minyere nari i Jisu za lao luge pa ruma varivarikamuna ko za podalai varivagigalai. ");
INSERT INTO ghn_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ko qari gabara betoni ria na tinoni za na varivagigalai tana aza, ura aza zake varivagigalai vei ria qari varivagigalaini na Vavanau, goto za varivagigalai vei na tinoni za kolea na neqi. ");
INSERT INTO ghn_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pa totozo tugu aza za korapa suverenana pa leo ruma varivarikamuna aza za maka tinoni za kolea na ongu ikerena ko za lukana uui, ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","<<Na za na mua ginugua tadigami za ao Jisu pa Nazareti? Qu lame ko mu piaragami gami qu gua? Ara qa gilagilagoqua za ao! Ao za na Liosona tana Tamaza!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nari za tokea i Jisu za na ongu ikerena ani, ari za guni vei, <<Mu nogoto ko mu votu keni tana tinoni zana,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nari za lao tu na ongu ikerena ko za tuaria ko za aru vitivitigi paleni za na tinoni aza, beto za uui viva beto za votu keni pana tana. ");
INSERT INTO ghn_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nari qari gabara vitivitigi za doru tinoni ko qari vari gua makadi, ari qari gua vei, <<Na zava za pu vei ari? Na varivagigalai koregana za tavitia na neqi za ani! Ko ria na ongu ikeredi za iju paledi ba qari nongoria tu ko qari vatabea tu!>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ko na nongorona na roiti ti Jisu za zake oriavo tu tapiara rerege doru kota pa varilivutaina pa Qalili. ");
INSERT INTO ghn_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Aza tugu qari votu keni pa ruma varivarikamuna, nari za i Jisu beto ari Jekopi beto i Jone qari rerege vatuvizi lao pa ruma tadi ari Saimone i Aduru. ");
INSERT INTO ghn_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na qoele roana i Saimone za mangini na tinina, ko za korapa kole pa lovu. Aza tugu za kamu i Jisu za qari ule vani gu aza za na veveina na moona na qoele ani. ");
INSERT INTO ghn_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nari za lame arua za na limana, ko za bako vatatakolea. Nari za taloi tana qoele za na mo mangini, ko aza tugu za vatana vadi za na tekutekuna ria. ");
INSERT INTO ghn_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ego ko totonai za gore na veluvelu tonai za koni suvu za na tapo, nari za qari toka kamudi tana ria za doru tinoni momodi beto ko ria za lugeria na tomete ikikeredi. ");
INSERT INTO ghn_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ko na minete tinoni lavata pa guguzu aza za qari varikamu pa atakamanana na ruma aza. ");
INSERT INTO ghn_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ko za salanaria i Jisu za na tinoni za rajaria na okokoto mo, beto za iju votu paledi aza za doru tomete ikikeredi. Zake vamalumuria aza za na tomete ikikeredi ari ko bari pojai kaki paranga, ura qari gilagilaidia ria na tomete aza. ");
INSERT INTO ghn_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na volavolaza rorodomo totonai za oqoro kabere na kota za iqolo ko za votu keni lao pa maka ia kaloina i Jisu ko ketakoi za kole varavara nana. ");
INSERT INTO ghn_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Totonai za i Saimone beto ria kaki nana baere za qari nyaqo tututia aza. ");
INSERT INTO ghn_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ko totonai qari batia aza nari za ari za qari guni vei, <<Ria doru qari korapa dogoro nyaqonyaqogo za ao,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ba ari za gudi vei i Jisu ria, <<Aria ko ta jola lao pa kaki guguzu pata lao nari ko ara ma tarae mule ketakoi, ura aza za qa lameni ara,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ko za leko ria aza za doru kota pa Qalili, ko za tarae pa dia ruma varivarikamuna beto za iju votu paledi aza za doru tomete ikikeredi qari kole tadiria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Maka tinoni za poqupoqu za lame ti Jisu, ko za nyumu sori tungutunguna pa moena aza ko za tepa tokatokai i Jisu, ari za gua vei, <<Vei bu malumu ao, za muna boka valiosoziu gu ara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Za roquroqu vitivitigia i Jisu za na tinoni ani, ko za kaqamani na limana ko za ulia aza, beto ari za guni vei, <<Ara qa malumu gu, ko mu lioso tu ao,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Na totozo tugu aza za tataloso valioso za na poqupoqu ko za lioso aza. ");
INSERT INTO ghn_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Pa liguna aza za i Jisu za vani na vavanau neqineqina beto za garunu vakenia aza. ");
INSERT INTO ghn_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ari za vavanau veini i Jisu aza, <<Munake izongo vavakatoni ao tana maka goto tinoni za na veveina ani. Goto mu lao makamu ko mi dogoro vilotigo na iama beto mu valaoa na mua vavavui vulavulaza za varigarununi i Mosese, ko ria doru tinoni mari vazozotoa za ao qu tori tavalioso tu,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ba aza tugu za taloi keni za na tinoni ani, za podalai velavelani gu beto za valekoia gu aza za na nongoro ani. Za jola zozoto za na vavakato tana tinoni ani ko i Jisu zake boka rerege vakabekabere lao pa guguzu, goto za suvere vakaloinana tu pa peguruna na guguzu. Ko ria na tinoni pa doru varilivutaina ketakoi za qari lame tana. ");
INSERT INTO ghn_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ego za jola gu ka viza rane tonai za mule lao soga pa Kepaniami i Jisu, nari za qarike oriavo tugu nongoroni ria na tinoni za aza za tori korapa tu pa ruma qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Qari kubo jola ria na tinoni qari varikamu ko kepore tugu za maka rora bi kole ko za jutu lao tu pa moena na atakamana, ko ketakoi za kole vavakatoni i Jisu za na paranga. ");
INSERT INTO ghn_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Totonai tugu za qari pogozo kamuni ari ka made tinoni za maka tinoni za uke maka kale kobu tinina ko zake boka rerege. ");
INSERT INTO ghn_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ba qarike boka pogozo laoni tana ria za na tinoni ani ura za pugelia na tinoni za na leo ruma. Ko qari keza ko qari kakelia tu za na arena na ruma pa totona zozoto i Jisu. Ko za korapa tugu kolenana pa nana lovu za qari vasikulu gorea za na tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tonai za batia i Jisu za ae na koi vei lavatana na rangerange tadiria nari za paranga laoa aza za na tinoni za uke kale maka kobu tinina, ari za guni vei, <<Tuqu, qari tori taleozo tu ria na mua sela,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ba ria kaki qari varivagigalaini na Vavanau za qari korapa nyumu tata ketakoi ko qari kole variperani pa bulodi za ari qari gua vei, ");
INSERT INTO ghn_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","<<Ae za vei ko za paranga vei tu zara za na tinoni ani? Za vamoroania na Tamaza za na tinoni zana! Ura makana gu na Tamaza za boka taleozoni za na sela!>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ba za tori gilagilainana tu i Jisu pa totozo aza za na za vei qari kole variperani ria pa bulodi, ko za paranga laoria aza ria, ari za gudi vei, <<Ae za vei ko gamu variperani tu pa bulomiu gamu za ari? ");
INSERT INTO ghn_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ae ari kori paranga ari za munyalana ko bi paranga laoni tana tinoni za uke maka kale tinina zana? <Qari tori taleozo tu ria na mua sela,> bi guni, ba, <Mu turu, mu teku pogozia na mua lovu ko mu rerege!> bi guni tu? ");
INSERT INTO ghn_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ba vei ko mu gilagilai gamu za na Tuna na Tinoni za kolea na neqi ko mina taleozodi ria na sela pa pezo za ari ropi ma roiti vei ara,>> za gua. Ko za paranga laoa za na tinoni za uke maka kale tinina, ");
INSERT INTO ghn_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ari za guni vei, <<Ma pojanigo ara ao: turu, mu teku pogozia na mua lovu ko mu mule laomua pa mua ruma,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Pa totozo tugu aza za turu, za teku pogozia na nana lovu ko za votu keninana pa moedi ria doru za na tinoni aza. Ko qari gabara beto ria doru beto qari vatarazaea ria za na Tamaza, ari qari gua vei, <<Za oqoro tabata tadigita za maka zakazava vevei ari!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ego i Jisu za gore soga lao pa poanana pa ovuku Qalili ko ria na minete tinoni qari lame varikamuni, ko aza za kole vagigalairia. ");
INSERT INTO ghn_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tonai za korapa rerege jola i Jisu, za batia i Livai na tuna i Alepiasi, za korapa nyumunana pa ruma tekutekuni takisina. Nari za paranga laoia i Jisu aza, ari za guni vei, <<Mae tutiziu,>> za guni. Nari za turu ko za tutianana tugu i Jisu aza. ");
INSERT INTO ghn_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ko tonai za korapa nyumu tekutekunana pa ruma ti Livai i Jisu, za zoku ria na tinoni tekuteku takisi beto ria na tinoni seladi za qari kole nyumu tavitia i Jisu beto ria na nana sepele. Ura na motadi ria qari tututia dia i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ria na Parese qari varivagigalaini na Vavanau za qari korapa tugu ketakoi. Ko tonai qari batia i Jisu za korapa tekuteku tavitiria ria na tinoni seladi beto ria na tinoni tekuteku takisi, nari za qari nanazaria ria nana sepele, ari qari gua vei, <<Ae za vei ko za tekuteku tavitiria tu ria na tinoni tekuteku takisi beto ria na tinoni seladi za na tinoni ani?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tonai za nongoro vairia i Jisu ria nari ari za gudi vei, <<Ria na tinoni toa valeadi za qarike nyaqoa za na tinoni varisalana, goto ria tu na tinoni moodi. Ara qake lame ko ma kukuria ria na tinoni tuvizidi qa gua, goto ria tu na tinoni seladi,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ego ria na sepele ti Jone paputaiso beto ria na Parese za qari tabutabu ganigani. Ko ria na tinoni za qari lame ko qari nanazia i Jisu, ari qari guni vei, <<Ae za vei ko ria na sepele ti Jone beto ria na sepele tadiria na Parese za qari tabutabu ganigani, goto ria na sepele tamu za qarike tabutabu ganigani tu?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nari za oe laoria i Jisu ria, ari za gudi vei, <<Ae za vei, ria na tinoni tasorudi mari somanani na vavolo varielava za pala mari boka tabutabu ganigani tonai mina korapa suvere tavitirianana za na marene za varielava? Dai! Tonai qari korapa suvere tavitia ria za na tinoni za koni varielava ani za marike boka tabutabu ganigani ria. ");
INSERT INTO ghn_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ba za korapa lame za na rane tonai mina tateku vakenidi za na marene za varielava ani. Ko pa liguna tu aza za mari tabutabu ganigani ria. ");
INSERT INTO ghn_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kepore za maka tinoni za tekua za maka rikata poko koregana ko za tuvakani na poko leluna. Ura vei mina roiti vei aza, nari za na rikata poko koregana mina pijoko ko mina bako rikatia za na poko leluna, ko na taraqama ikerena jola mutu za mina taroiti. ");
INSERT INTO ghn_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Beto kepore za maka tinoni za toto laoni vaini koregana za na tototona leluna. Ura vei mina roiti vei aza, nari za na vaini koregana za pala mina pujaka pokatia za na tototona leluna, ko mari ikere varitakoi za na vaini beto na tototona. Goto na vaini koregana za tatoto laoni pa tototona koregana tugu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pana maka rane Minyere totonai za rerege lao vei pa korapa inuma vuiti i Jisu, nari za qari podalai ravuzu tekugedi kiko vuiti ria nana sepele. ");
INSERT INTO ghn_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nari qari paranga ria na Parese, ari qari guni vei, <<Dogoro, ae za vei ko qari roitini tu pa rane Minyere ria na sepele tamu za na roiti zake tavamalumu pana Vavanau?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nari za oeria i Jisu ria, ari za gudi vei, <<Ae vei, gamu oqoro tu tiro vakaberia gamu za aza vei za roitini i Devita beto ria nana tinoni tonai za keporedi na ganigani ko qari burana varivasevi? ");
INSERT INTO ghn_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pana totozo za korapa kuta iama lavata i Abiata, azae za lugea i Devita za na ruma tana Tamaza ko za tekua aza za na bereti madina ko za gania. Na vavanauna na bereti madina aza za makadi gu ria na iama za qari tavamalumuni ko mari boka tekua aza. Ba i Devita za tekua tu beto za iadi mutugu vei ria na nana tinoni,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Beto ari za gudi vei mule, <<Na rane Minyere za taroiti vani na tinoni, nake tinoni za taroiti vani za na rane Minyere. ");
INSERT INTO ghn_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ko na Tuna na Tinoni za bangarani tugu vei za na rane Minyere,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ego tonai za lao mule pa ruma varivarikamuna i Jisu, za korapa ketakoi za maka tinoni za raiqo maka kale limana. ");
INSERT INTO ghn_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ko ria kaki tinoni qari kole dogoro kopuni i Jisu ko vei mina salania pana rane Minyere za na tinoni ani nari za mari jutuni za sela aza mariguni qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Za paranga laoa i Jisu za na tinoni za raiqo na limana, ari za guni vei, <<Mae, mu turu zale pa momoe,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Beto za nanaza laoria i Jisu ria na tinoni, ari za gudi vei, <<Na za za tavamalumu pana Vavanau ko mina boka taroiti pa rane Minyere? Na roiti valeana, ba na roiti vikevikere? Na alona na toa tana tinoni, ba na vaukena?>> za gudi. Ba qarike vagala. ");
INSERT INTO ghn_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ego ko za dogoro varilivutadi tagigiridi i Jisu ria beto za takulanga tugu vei ura za patu na bulodi. Beto za paranga laoa za na tinoni ani, ari za guni vei, <<Mu radonia na limamu,>> za guni. Ko za varadonia nari za leana soga za na limana. ");
INSERT INTO ghn_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Aza tugu qari taloi pa ruma varivarikamuna ria na Parese, za qari siqasiqarai lao kamuria ria qari jukajukai i Herodi ko qari makarai varingodoni na roquroqu ko mari vaukea i Jisu qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ego ko i Jisu beto ria nana sepele za qari taloi keni veidia pa ovuku pa Qalili, ko maka minete tinoni lavata za qari tuti koko pa Qalili, pa Jiudia, ");
INSERT INTO ghn_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","pa Jerusalema, pa Idumea, pa maka karovona pa Jodani, beto pa varilivutaidi pa Turosi beto pa Sidoni. Ria doru ari za qari nongorodi ria doru roiti za roitidi aza, ko qari varikamu lame tana. ");
INSERT INTO ghn_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ko totonai za pojadi i Jisu ria na nana sepele ko mari vatana vakole vani za maka koaka za gua ura qari zoku jola ria na tinoni ko keta mari jupe variamuni ria za gua. ");
INSERT INTO ghn_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ura zoku jola ria na tinoni za salanaria aza ko ria na tinoni vagaurudi za qari jujuku laoa aza ko vei ko mari ulia aza qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ria na tinoni za koleria na ongongu ikeredi ba tonai qari batia i Jisu nari za qari lotu kole pa moena aza beto qari velavela votu, ari qari gua vei, <<Ao za na Tuna na Tamaza!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ba za paranga suquturia i Jisu ria na ongongu ikikeredi ko marike pojai ria za na veveina aza za gua. ");
INSERT INTO ghn_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ego za zagere zae pa maka kubo i Jisu beto za kuku varikamudi ria za nyorogudi ko mari tutia, ko qari varikamu lao tana aza ria. ");
INSERT INTO ghn_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ko za mijataria i Jisu ari ka manogori beto za gigaladi na tinoni tagarunudi ria, ko mari suvere tavitia aza beto ko mina garunu votudi ko mari tarae za gua. ");
INSERT INTO ghn_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Beto za vadi na neqi ko mari boka ijiju pale na tomete ikikeredi za gua. ");
INSERT INTO ghn_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ko ari za na izongodi ari ka manogori za mijataria i Jisu: i Saimone (aza za vaizongoni i Pita), ");
INSERT INTO ghn_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","i Jekopi beto i Jone kori tuna i Jebeti (ria za gigaladi Boneage, na ginuana za na tuna na paka oka), ");
INSERT INTO ghn_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","i Aduru, i Pilipi, i Batolomiu, i Matiu, i Tomasi, i Jekopi na tuna i Alepiasi, i Tadaeasi, i Saimone aza perangaina za somana talea na qavuna Romu, ");
INSERT INTO ghn_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","beto ko i Jiudasi Isikarioti aza na tinoni za gabala kanai i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ego tonai za kamu pa ruma i Jisu za qari kamu varitakoi tugu ria na minete tinoni ko i Jisu beto ria nana sepele za qarike boka teku totozo ko bari boka tekutekudia. ");
INSERT INTO ghn_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Totonai za qari lame ria na turana ko mari ragata toka vakenia i Jisu qari gua, ura qari nongoroni za tori tuturu tu za na tinoni zana qari gua ria kaki. ");
INSERT INTO ghn_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Beto ria qari varivagigalaini na Vavanau na lagere veidi pa Jerusalema za qari kole pojapojai, ari qari gua vei, <<Za kolea i Beelizebulu beto pa neqi tana na bangaradi ria na tomete za boka ijiju paledi na tomete za na tinoni ani,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nari za kuku tekuria i Jisu ria qari varivagigalaini na Vavanau ko za vavakato vadi na vavakato vavapada, ari za gudi vei, <<Ae vei i Setani mina boka iju vakenia tu i Setani makana? ");
INSERT INTO ghn_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Na binangara za varipikapikatai muleni makana za pala minake boka turu vaneqi. ");
INSERT INTO ghn_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Beto na tatamana za varipikapikatai muleni makana za pala mina tajegajegara. ");
INSERT INTO ghn_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ko vei i Setani mina kana muleni makana beto mina varipikapikatai muleni makana, za minake turu vamauru aza goto pala mina manyao gu aza. ");
INSERT INTO ghn_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Beto ko kepore za maka tinoni mina boka soqolo luge lao pa leo ruma tana tinoni neqina ko mina iko tekuria za na zakazava tana aza vei bi oqoro piu vakole momoea mae tu za na tinoni neqina aza. Momoe za mina piu vakolea mae tu aza za na tinoni neqina ani, beto za mina boka iko vaputiputia aza za na zakazava pa ruma tana. ");
INSERT INTO ghn_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ma poja vazozotodigamu ara gamu: pala mari boka taleozodi gu za doru sela bari roitidi ria na tinoni beto doru vamoroanana na Tamaza qari poja votudi. ");
INSERT INTO ghn_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ba na tinoni za vamoroania na Ongu Tabuna za minake taleozoni kamua na kamua, ura aza za tori roitini tu za na sela kole jolana,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Zara za varivagigalai vei i Jisu ura kaki tinoni za ari za qari kole paraparanga vei, <<Za kolea na ongongu ikikerena za na tinoni ani,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ego na tinana beto ria na taina marene i Jisu za qari kamu. Ko qari turu pa sebesebe ruma aza beto qari garunu valugea za na nongoro ko mi votu lame i Jisu qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na varikamu tinoni za qari korapa nyumu pa varilivutaina i Jisu ko ria kaki za qari paranga laoa aza, ari qari guni vei, <<Qokolo, na tinamu beto ko ria na taimu marene za pa peguru ko qari korapa nyaqogo ao,>> qari guni i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nari za oe laoria i Jisu za ria, ari za gudi vei, <<I zei za na tinaqu beto ko ari zei ria na taiqu marene ara?>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Beto za dogoro varilivutaidi ria qari nyumu pa varilivutaina aza beto ari za gudi vei, <<Dogoro! Ari tugu ria na tinaqu beto na taiqu marene ara. ");
INSERT INTO ghn_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Na tinoni za roitini aza vei za nyoroguani na Tamaza za aza tugu za na taiqu marene, na luluqu reko, beto na tinaqu ara,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ego za podalai varivagigalai mule pa poanana pa ovuku Qalili i Jisu. Ko na minete tinoni lavata za qari varikamu lame tana, ko za lao tu zae ko za nyumu pa maka koaka titina pa kolo, goto ria na minete tinoni za qari turu pa poanana. ");
INSERT INTO ghn_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ko za kole varivagigalaidi aza za zoku vavakato vavapadapada. Ko pa nana varivagigalai aza ari za vavakato vei. ");
INSERT INTO ghn_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","<<Mu vainongoro ko! Kolenana za maka tinoni umuma za votu keni ko za vavuvuzuria na kiko. ");
INSERT INTO ghn_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ko tonai za kole vavuvuzuria aza na kiko, za kaki kiko za qari lotu lao pa lodaka zona, ko qari tatava kamu tu na manugu ko qari tobiki gani betoria na gedi. ");
INSERT INTO ghn_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kaki kiko za qari lotu lao pa butubuturuna ketakoi zake mota na pezo, ko qarike oriavo tu na pidokodi ura zake zoku na pezo. ");
INSERT INTO ghn_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ba totonai za zagere na tapo ko za alangaria nari za qari malei ukedia, ura zake gore vakori na bageredi. ");
INSERT INTO ghn_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kaki kiko za qari lotu lao pa kota za kolea na gazoro varivarioka, ko tonai qari pidoko za na kiko ari, za na gazoro varivarioka za amu tariria ko qarike boka vua. ");
INSERT INTO ghn_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Goto kaki kiko za qari lotu lao pa pezo leleana, ko tonai qari pidoko beto qari toa zae qari vua vunguvungu. Ko kaki qari vua uengavulu, kaki vonomongavulu, beto kaki za maka gogoto tu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Beto ari za gudi vei i Jisu, <<Na tinoni za pore na talinga nongonongorona za mi vainongoro!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ego totonai za korapa suverenana makana i Jisu, za qari lame ria kaki tinoni qari tututia aza beto ko ari ka manogori sepele ko qari nanazani za na ginuana na vavakato vavapada ani. ");
INSERT INTO ghn_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nari za oeria i Jisu ria, ari za gudi vei, <<Gamu za gamu tori taiani tu gamu za na gigalai golomona na veveina na binangara tana Tamaza, goto ria qari zou tana aza za doru gigalai za qari tekuria pa vavakato vavapada gu. ");
INSERT INTO ghn_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ko za gore votu za na ginuana na Kutikuti Tabuna: <Mari dogoro ko mari dogodogoro ba marike batia, mari nongoro ko mari nongonongoro ba marike vakaberia. Ura keta mari gabala mule lame ko mari taleozodi,> za gua,>> za gudi i Jisu ria. ");
INSERT INTO ghn_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Beto ari za gudi vei mule i Jisu ria, <<Ae za vei, gamuke vakaberia tu gamu za na vavakato vavapadapada ani? Ego ko zara za vei za pala munake boka tugu vakabereria gamu za doru vavakato vavapadapada. ");
INSERT INTO ghn_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Na tinoni umuma za vavuvuzia za na paranga. ");
INSERT INTO ghn_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ria kaki tinoni qari vei na kiko qari lotu lao pa lodaka zona, ketakoi za tavavuvuzu na paranga. Ko tonai qari nongoria za na paranga nari zake oriavo tugu lame teku paleni i Setani za na paranga za tavavuvuzu pa bulodi. ");
INSERT INTO ghn_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ria na kiko qari lotu lao pa pezo butubuturudi za ria na tinoni aza tugu qari nongoria na paranga nari qarike oriavo tu teku ngalingali qeraqerani, ");
INSERT INTO ghn_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","beto za kepore na bageredi makadi ba qari toa vakakaza tu iapeki totozo. Ba tonai qari gozoro taleni tapata beto na varikomiti za na paranga, nari za qarike oriavo tugu lotudi. ");
INSERT INTO ghn_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ria kaki mule za ria qari tavavuvuzu pa varikorapaidi na gazoro varivarioka. Ari za ria qari nongoria na paranga, ");
INSERT INTO ghn_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ba na takulangana na suvesuvere pa kasia guguzu, na nyoroguadi na izizongo pa pezo, beto na nyonyoroguadi mule kaki zakazava mule za qari lugeria na bulodi. Ko za amu ria na zakazava ari za na paranga ko zake boka vua. ");
INSERT INTO ghn_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Goto ria qari tavavuvuzu pa pezo leana za ria na tinoni qari nongoro vakoititiria na paranga beto qari teku vakatapia ria za na paranga. Ko ria za qari vua vunguvungu: kaki uengavulu, kaki vonomongavulu, beto kaki za maka gogoto tu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Beto ari mule za gudi vei i Jisu ria, <<Ae za vei, na juke za tapogozo luge pa ruma ko mina tavakole pa kauru kadikita babi pa kauru sape putaputana? Dai! Pa nana nyumunyumuna tu za na nana laona mina nyumu aza. ");
INSERT INTO ghn_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Doru zakazava qari kole vapae za marina bola votu, beto doru zakazava qari kole golomo za mari votu lame pa kabekaberena. ");
INSERT INTO ghn_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Na tinoni za pore talinga nongonongorona za mi vainongoro!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Beto ari mule za gudi vei, <<Mu viloto valeania aza gamu nongoria. Aza tugu za na pada gamu variiani za aza tugu za na pada muna taiani gamu, beto mina jolani mutugu aza za muna tekua gamu. ");
INSERT INTO ghn_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ura aza za kolenana na nana za na motana mina taia vatamoni. Goto na tinoni za keporenana za aza tugu iapeki za izongia aza ba mina taragata vakenini tugu aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Beto za paranga mule i Jisu, <<Na binangara tana Tamaza za vei vaputaputa maka tinoni za ipaporodi pa pezo za na kiko, ");
INSERT INTO ghn_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","beto ko za puta mumagana na bongi beto za kamua na rane nari za iqolo. Qari pidoko votu beto ko qari toa zae na kiko, ba aza makana ba zake gilagilai za ae qari vei beto qari toa ria na kiko ari. ");
INSERT INTO ghn_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Na pezo gu makana za vatoaia za na umuma ko qari vua: momoe za votu lame na equruna, beto qari lavata zae na talingadi, beto qari matumatua za na talingadi na vuiti. ");
INSERT INTO ghn_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ko tonai qari matua za na vuvua nari za garunuria aza ria na tinoni ababu ko qari lao ababu, ura za kamua gu za na totozo ababu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Beto za paranga mutu i Jisu, <<Na za tana vavapadani gita za na binangara tana Tamaza? Babi ae vavakato vavapada veveina za tana boka vavakato vakabereni gita aza? ");
INSERT INTO ghn_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Za vei vaputaputa gu maka kikona na masitadi aza. Za peki joladi doru kiko pa kasia guguzu za na kiko aza, ");
INSERT INTO ghn_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ba tonai za tauma pa pezo nari za toa zae ko za lavata joladi mutu za ria doru umuma. Ko za kakae lavalavata ko ria na manugu qari tatava kamu ko qari roiti dia alale na vorivori pa kaedi za ongongu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Zoku vavakato vavapada vevei ari za vavakatodi i Jisu tonai za kole ule vadi na paranga. Ko za vavakatodi za aza ria vei qari boka nongoro vakaberia ria. ");
INSERT INTO ghn_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Doru nana varivagigalai za vakoleria pa vavakato vavapada aza tonai za vavakato tadiria doru. Totonai tu za suvere tavitiria makana ria na nana sepele za ule vakabekabere vadi za doru maka za. ");
INSERT INTO ghn_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ego totonai za gore na veluveluna na rane aza, i Jisu za parangaria ria nana sepele, ari za gudi vei, <<Aria ko ta karovo lao pa maka kalena na ovuku,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ko qari loia za na minete tinoni ko qari zae pa maka koaka ria na sepele ko qari tokai i Jisu za tori zaenana tu pa koaka. Kaki koaka ba qari korapa tugu titidia ketakoi. ");
INSERT INTO ghn_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Totonai qari toka karovo lao za maka gava lavata za rajaria beto za talokuloku tataria na ololobagea za na koaka ko za pugelia tu na kolo. ");
INSERT INTO ghn_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ba i Jisu za tarubatuni maka tarubatu ko za korapa putagana pa tavatavana na koaka. Ko qari lao jou vaiqolia aza beto ari qari guni vei, <<Tinoni varivagigalai! Ta uke taqe gua gita! Ae za vei zake vatakulangigo ao za vei zara?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nari za tatakole tu i Jisu ko za tokea za na gava beto ari za guni vei na kolo, <<Bule! Mu nogoto!>> za gua. Tonai za nogoto za na gava beto za bule elava za na kolo. ");
INSERT INTO ghn_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Beto ari za gudi vei ria nana sepele, <<Ae za vei ko gamu matagutu tu? Oqoro pore tugu na miu rangerange za gamu?>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Qari matagutu vikevikeredi ria ko qari kole varivarinanaza makadi, ari qari gua vei, <<Ko i zei tu za na tinoni ani ko ria tu na gava beto na kolo ba qari nongoria tugu nana paranga?>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ego ko qari lao paro za pa maka kalena na ovuku pa Qerasini. ");
INSERT INTO ghn_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ko aza tugu za taloi pa koaka ko za paro i Jisu, za maka tinoni za kolea na ongu ikikerena za votu koko lame vei pa bevi varivarigolomona ko za lame gozoria i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Na suvesuverena pa bevi varivarigolomodi za na tinoni ani, ko qari podeke piuni seni tu ba kepore tugu maka tinoni bi boka piu vakolea. ");
INSERT INTO ghn_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Zoku totozo qari tori pikoni seni tu na nenena beto na limana ba za rabutu palepaledi ria na seni ari beto za piara paledi ria na aeana pa nenena. Kepore maka tinoni bi neqi jolani ko bi boka tale vamomozia. ");
INSERT INTO ghn_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Na rane na bongi za kole gu vidulai lao lame pa bevi varivarigolomodi beto pa kubokubo za kole gu lukana uui beto za kole vapalepaleka muleni pa patupatu. ");
INSERT INTO ghn_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ko za batia pa zouna tu aza i Jisu, nari za abutu toto lao opo nyumu sori tungutungu pa moena aza. ");
INSERT INTO ghn_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ko za velavela votu, ari za gua vei, <<Na za na mua ginugua taqu ara ao Jisu na Tuna na Tamaza Ululuna Jola? Pipaqu tana Tamaza, ao munake vakilasaziu ara!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ura perangaina tu za tori poja veini tu ari i Jisu aza, <<Ongu ikeremu, mu votu keni tana tinoni ani ao!>> za tori guni tu. ");
INSERT INTO ghn_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ko za nanazia i Jisu aza, <<I zei na izongomu ao?>> za guni. Nari za paranga na tinoni aza, ari za gua vei, <<I Zokuvuro za na izongoqu ara, ura na zoku jola gami,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ko za tepa tokatoka vitivitigia aza i Jisu ko mike iju votudi pa guguzu aza ria na ongu ikikeredi za gua. ");
INSERT INTO ghn_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ego qari korapa nyubenyubele ganiganigedi pa maka kalena na kubo ketakoi za na godo borogo. ");
INSERT INTO ghn_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ko qari tepa tokatoka vitivitigia ria na ongu ikikeredi i Jisu, ari qari guni vei, <<Mu garunu laodigami tadiria na borogo rari, ko mami lao lugeria,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nari za vamalumuria aza, ko qari votu taloi tana tinoni ani za na ongu ikikeredi ko qari lao lugeria za na borogo. Ko na godo borogo doruna, na ngutidi ria za kori vuro, za qari tuara gorea za na taba mamavarana ko qari gore kuju uke betodia pa leo kolo. ");
INSERT INTO ghn_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ko ria na tinoni qari kopudi na borogo ari za qari uku kenidia ko qari lao vavakatoni pa guguzu beto pa varilivutaina ketakoi. Ko qari lame ria na tinoni ko mari dogoria za na zakazava za taroiti ketakoi qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tonai qari lame kamu ti Jisu ria na tinoni ari, za qari batia ria za na tinoni perangaina qari lugea mae na zoku vuro ongu ikeredi. Ba koviria za tori pokopoko valeananana tu beto za tori tavagigalana tu ko za korapa nyumunana za na tinoni aza. Ko qari matagutu ria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ria na tinoni qari somana batia ae qari vei na godo borogo beto na tinoni za lugea na ongu ikeredi ani za qari vavakato vadi ria na goto tinoni. ");
INSERT INTO ghn_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ko ria na tinoni qari tepa tokatokai ria i Jisu ko mi iolo votu keni pa dia guguzu qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ego ko totonai mi zae pa koaka za gua i Jisu, nari za lame ko za tepa vitivitigia i Jisu za na tinoni qari koni loia na ongu ikeredi ani ko mi tutianana i Jisu za gua. ");
INSERT INTO ghn_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ba i Jisu zake vamalumia, goto ari tu za guni vei, <<Dai, mu mule lao pa mua guguzu tadiria na turamu ko mu ule vadi za na roiti poreveveina za roiti vanigo na Bangara beto na veveina na variroqu varitokai za vadogoronigo,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ko za taloi keni aza ko za podalai vavakatodi gu pa doru guguzu pa ia pa Manogaguguzu aza za na roiti za roitidi i Jisu tana ko qari gabara beto ria doru tinoni. ");
INSERT INTO ghn_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ego tonai za karovo soga lao pa maka kalena na ovuku i Jisu, nari za maka minete tinoni lavata za qari lame variamuni aza pa poanana pa ovuku. ");
INSERT INTO ghn_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pa totozo tugu aza za lame za maka tinoni matamata pa ruma varivarikamuna, na izongona i Jaerasi. Tonai za batia aza i Jisu, za lao gona nyumuni pa nenena aza, ");
INSERT INTO ghn_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ko za tepa tokatoka vitivitigia aza i Jisu, ari za guni vei, <<Na tuqu reko za mo vitivitigi ko za korapa laolao vei pa uke. Mu lame vaoponi na limamu, ko mu alo muleni nana toa!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nari za tutia aza i Jisu. Ego maka minete tinoni lavata za qari tutia aza ko qari jupe varikaleni aza. ");
INSERT INTO ghn_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Za korapa tugu pa varikamu tinoni ketakoi za maka reko za kole vakeni orungu laonana gu pa korapana ka manogori aoro. ");
INSERT INTO ghn_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Na reko ani za tori dori kole gozororia tu zoku tapata pa kopu tadiria na tinoni varisalana beto doru nana izizongo za gona paledi pa kole nyaqo salana nagu, ba zake izongo leana podeke tu goto tonai za viva tu lalaonana za na tapata tana aza. ");
INSERT INTO ghn_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tonai za nongoroni na reko ani za na vavakatona na veveina i Jisu, azae za tuti ligu pa leo varikamu tinoni aza ko za lao ulia za na poko ti Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ura ari za kole roquroqu golomo vei pa bulona aza, <<Vei mana ulia gu ara za na poko tana, za pala mana tasalanaqua gu ara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ko aza tugu za ulia aza za na poko ti Jisu, za totonai tugu za nogoto keni za na orungu, beto za vagilagilai pa tinina za tori tasalana tu aza pa nana mo za gua. ");
INSERT INTO ghn_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pa totozo tugu aza za vagilagilai makana i Jisu za na neqi za votu keni pa tinina. Ko za balinga muleria za na varikamu tinoni ko za nanazaria, ari za gudi vei, <<I zei za ulia na poko taqu?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nari qari paranga tu ria nana sepele, ari qari guni vei, <<Qu batiamua ao za na rave tinoni qari jupe variamunigo, ba ae za vei ko qu nanaza tu ao, <I zei za uliziu?> qu gua tu,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ba za kole tugu dogoro varilivutai i Jisu ko mi batia za na reko za ulia aza za gua. ");
INSERT INTO ghn_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Za vagilagilai na reko ani za na tasalana za gore votu pa tinina ko za matagutu neqeneqereni, ko za lao gona nyumuni pa moena i Jisu ko za uleni gu aza za na vavakato doruna. ");
INSERT INTO ghn_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nari ari za guni vei i Jisu aza, <<Tuqu, na mua rangerange za tori salanigo tu. Mu lao pa bule beto mu tasalanamua tu pa mua tapata,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Totonai za korapa paranga i Jisu, za qari bolabola kamu gu ria kaki tinoni na koko lame veidi pa ruma ti Jaerasi na tinoni matamata pa ruma varivarikamuna, ko ari qari guni vei i Jaerasi, <<Na tumu reko za koviria ari za tori uke tu. Keta vapavu lame goboria na tinoni varivagigalai,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ba i Jisu zake pavu tugu vatalingadi za na paranga qari pojai ria, goto tonai za ari tu za guni vei za na tinoni matamata pa ruma varivarikamuna, <<Muke matagutu, mu vazozoto gu,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ego ko kepore tu za maka tinoni za vamalumia ko bi tutia aza, goto makadi gu ari Pita, i Jekopi beto ko i Jone na taina marene gu i Jekopi. ");
INSERT INTO ghn_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tonai qari lame kamu pa ruma ti Jaerasi, azae za batia i Jisu za na rura takulangadi ria na tinoni qari romaroma beto qari lukana kebokebo. ");
INSERT INTO ghn_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ko za luge aza ko ari za gudi vei, <<Ae za vei ko gamu rura takulanga beto gamu korapa kebokebo romaroma tu za gamu? Na koburu zana za zake uke, goto za korapa putagana gu,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tonai za paranga vei aza nari za qari auni ria na tinoni aza. Nari za iju vavoturia i Jisu ria doru, goto na tinana gu beto na tamana na koburu beto ari ka kue nana sepele gu za toka lugedi ketakoi za kole na koburu. ");
INSERT INTO ghn_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Beto za arua i Jisu za na limana na koburu beto ari za guni vei, <<Talita kumi,>> za gua (Na ginuana za, <<Ngore, qa parangaigo ara ao, mu tatakole tu!>> za gua). ");
INSERT INTO ghn_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Pa totozo tugu aza za tatakole tu za na reko peki ani ko za reregenana, ura za tori manogori aorona tu za na reko aza. Ko qari gabara vitivitigidi ria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ba za naqu vaneqineqiria i Jisu ria ko marike vavakatoni tana maka tinoni za aza vei za taroiti ani za gudi. Beto za garunuria ko mari vani kaki zava za na koburu reko ko mi tekutekunana za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ego i Jisu za taloi pa guguzu aza ko za mule lao pa guguzu ketakoi za lavata zae ko ria nana sepele qari tuti laoa aza. ");
INSERT INTO ghn_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Totonai za kamua na rane Minyere, nari za podalai varivagigalai pa ruma varivarikamuna aza. Ko ria doru qari nongoria aza za qari gabara vitivitigi, ko ari qari gua vei, <<Pae koko veidi za na roquroqu ari? Na gigalai za za izongia za na tinoni ani? Ko na roiti varivagabaradi tu ba za roiti votudi! ");
INSERT INTO ghn_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Na kamada gu ani! Ko na tuna gu i Mere beto ko na tugadi gu ari Jekopi, Josesi, Jiudasi beto i Saimone ani! Na luluna reko ba qari korapa gu zara!>> qari gua ria. Ko qarike tavaraguani ria i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nari ari za gudi vei i Jisu ria, <<Na tinoni korokorotai za doru kota za tapangaga gu, goto pa nana guguzu lavata zaena gu ko tadiria na turana beto pa nana tatamana gu makana za zake tapangaga,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ko zake boka roitidi ketakoi aza ria na roiti varivagabaradi, goto ria kaki tinoni qari mo gu za vaopodi na limana ko za salanaria. ");
INSERT INTO ghn_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ko za gabara vitivitigini i Jisu za na veveina keporedia vinazozoto tana. Ego za leko beto ria i Jisu ria na guguzu pa varilivutaina ketakoi ko za kole varivagigalai. ");
INSERT INTO ghn_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Beto za kuku varikamudi aza ari ka manogori nana sepele ko zava okoto pikata vakorikori tinoniria pa maka reregena, za vadi na neqi ijudi ria na ongu ikeredi, beto za garunu vakeniria. ");
INSERT INTO ghn_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ko za pojadi tugu ko marike pogozia maka za pa dia rerege lao, goto na dia opata gu. Marike pogozo besa, na mane, beto na poata ininamane za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mari vazaeria gu na dia sadolo, goto marike vazae tamo poko za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Beto ari mutugu za gudi vei, <<Tonai muna tavakamu pa maka ruma, za muna suvere gu ketakoi tinganai muna taloi keni pa ia aza za gamu. ");
INSERT INTO ghn_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ria kaki guguzu bari daidia vakamugamu beto bari daidia nongorogamu, za mu turu loi paleni za na guguzu aza beto mu tavuzu paledi ria na kavuru pezo pa nenemiu. Ko aza za na vinagilagilana pala mari tavakilasa ria,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ko qari taloi keni ria ko qari taraeni za na veveina ria na tinoni mari gabala loiria na dia sela qari gudi, ");
INSERT INTO ghn_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","qari iju votuvotu paledi zoku tomete ikikeredi, beto qari oradi na oela tugu vei ria na zoku tinoni qari mo ko qari salana beto ria. ");
INSERT INTO ghn_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ego za nongorodi i Herodi na bangara ria doru zakazava vei za roitidi i Jisu, ura na izongona aza za tagilagila pa doru guguzu. Beto ko ria kaki tinoni ba ari qari paranga vei, <<I Jone Paputaiso za tori turu mule tu qari gua. Ko zara za vei za qari roiti tana ria na roiti varivagabaradi,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ba ria kaki mule za ari tu qari paranga vei, <<I Elaija ani!>> qari gua. Beto kaki mule za ari tu qari paranga vei, <<Maka tinoni korokorotai ani, maka veveina ria na tinoni korokorotai pa moa zana!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ko tonai za nongoria zara qari paranga vei ria, azae za paranga i Herodi, ari za gua vei, <<Aza tugu i Jone Paputaiso qa tori kujukia tu ara za turu mule zana!>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ura i Jone za perangaina tu i Herodi tugu makana za garununi tinoni ko qari piu valugea pa ruma varipiuna. Na ginuana za tapiuni i Jone za na veveina gu i Herodiasi. I Herodiasi za na maqotana tu i Pilipi aza na taina gu makana i Herodi, ba za elavia tu nana i Herodi i Herodiasi. ");
INSERT INTO ghn_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ko i Jone tugu za kole manogai pojani i Herodi, ari za guni vei, <<Nake tavamalumuna pana Vavanau za vei ao qu suvere tavitia na maqotana na taimu,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ko i Herodiasi za puku vakoleni pa bulona za ani ko za nyorogua vaukea i Jone, ba zake boka. ");
INSERT INTO ghn_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ura i Herodi ba za matagutuni i Jone ura za gilagilainana aza i Jone za maka tinoni tuvizina beto na liosona aza ko za vei za kopu vasareni aza. Ko tonai za nongoria za na paranga ti Jone za takulanga tugu, ba za kole nongoro qeraqerani tugu aza. ");
INSERT INTO ghn_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ego tonai za kamua za na rane podo ti Herodi zana za tekua na totozo leana i Herodiasi. Za roitini i Herodi za maka vavolo rane podo beto za soruria ria na tiolata lavalavata pa qavuna, ria na kutadi ria na tinoni varipera, beto tadiria na butubutu tinoni pa Qalili ko qari lao somana tekuteku. ");
INSERT INTO ghn_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ko pa varikamu aza za luge lao pekapeka za na tuna reko i Herodiasi, ko za vaqerai i Herodi beto ria na tinoni za soruria. Ko za paranga lao tana koburu reko zana na bangara, ari za guni vei, <<Mu tepaniziu aza vei qu nyoroguani. Ara pala mana vanigo za na mua nyorogua,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Beto za maulu lao tana reko, ari za guni vei, <<Ae tu zakazava veveina za muna tepaniziu ago, ba pala mana vanigo gu ara. Bi na kobuna na qua binangara bu gua tu ao, ba leana gu!>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nari za votu lao nanazia na tinana za na reko ani, ari za guni vei, <<Na zava za mana tepai ara,>> za guni. Nari za oe lao za na tinana, ari mu gua vei, <<Na batuna i Jone Paputaiso, muguni,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nari za siqasiqarai mule lao tana bangara aza ko ari za gua vei, <<Qa nyoroguani ko mu petalani pa peleta za na batuna i Jone Paputaiso beto mu pogozo lame vaniziu koviria tugu,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Za takulanga vitivitigi tugu na bulona za na bangara, ba za tori maulu tu pa moedi ria na tiolata lavata aza ko zake boka dainanani za na tepa tana reko. ");
INSERT INTO ghn_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ko pa totozo tugu aza za garunia i Herodi za maka tinoni kopu tadiria na solodia ko mi pogozo lameni za na batuna i Jone za guni. Ko za lao za na tinoni aza ko za kujukia pa ruma varipiuna i Jone, ");
INSERT INTO ghn_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","beto za petalani pa peleta ko za pogozo lame vani za na reko. Ko na reko ani za tekua ko za pogozo laoni tana tinana. ");
INSERT INTO ghn_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Totonai qari nongoro ria na sepele ti Jone za qari kamu pogozia za na kobukobu tinina i Jone Paputaiso ko qari lao golomia pa maka bevi varivarigolomona. ");
INSERT INTO ghn_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ego qari mule varikamu ti Jisu ari ka manogori tinoni tagarunudi, ko qari vavakato vani aza ria doru zakazava vei qari roitidi beto qari varivagigalaidi. ");
INSERT INTO ghn_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nari ari za gudi vei i Jisu ria, <<Mae, aria ko ta lao pa maka ia kaloina makada, ko gamu ba mu minyere mae,>> za gudi. Ura qari zoku jola ria na tinoni qari kamu varisoga, ko i Jisu beto ria nana sepele ba qarike boka teku totozo ko bari tekutekudia. ");
INSERT INTO ghn_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ko qari zae pa maka koaka ko qari lao pa maka ia kaloina makadi. ");
INSERT INTO ghn_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ba ria na kubo tinoni za qari dogoro gigalariadia ria tonai qari toka. Ko qari abutu poana momoe lao ria na tinoni na lame veidi pa doru okoto guguguzu ko qari lao valiguliguria ko qari adono momoedia pa ia ketakoi mari korapa lao paro qari gua ari Jisu beto ria nana sepele. ");
INSERT INTO ghn_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tonai za jorotongana paro pa poanana i Jisu, za batia za na minete tinoni lavata ko za roquroqu vitivitigiria, ura qari vei vaputaputa na sipi kepore na dia sepati. Ko za podalai varivagigalaidi zoku zakazava i Jisu tadiria. ");
INSERT INTO ghn_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ego ko tonai za gore na veluvelu za qari lame pana tana za ria nana sepele ko ari qari paranga vei, <<Na ia kaloina za pani, beto ko za tori gore tu za na veluvelu. ");
INSERT INTO ghn_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ko mu pojadi ria na tinoni ari ko mari lao pa guguzu varilivutaidi zara ko mari vaigedi ganigani makadi,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ba za oe laoria i Jisu ria, ari za gudi vei, <<Dai. Gamu tu mu vadi na tekutekuna ria zara,>> za gudi. Nari qari paranga ria nana sepele, <<Ae vei qu nyoroguani ko mami lao vaini ganigani kori gogoto poata siliva beto mami iaria ko mari tekuteku qu gua?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nari za nanaza laoria tu i Jisu ria, ari za gudi vei, <<Ka viza batu bereti gamu pogozoria? Mu lao moko dogororia,>> za gudi. Ko tonai qari batiria za ari qari gua vei, <<Ka lima batu bereti, beto kori igana,>> qari guni aza. ");
INSERT INTO ghn_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nari za pojadi i Jisu ria doru ko qari pikapikata pa okoto pukuna beto za qari nyumu pa buruburu. ");
INSERT INTO ghn_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ko qari nyumu variitivi pana okoto dia puku tinoni, kaki pukupuku tinoni za maka gogoto, kaki limangavulu. ");
INSERT INTO ghn_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Beto nari za tekua i Jisu za ka lima batu bereti beto kori igana ko za enga zae pa noka, za manadi, beto za kipakiparia za na bereti beto za vadi ria nana sepele ko qari iaria ria na tinoni. Beto za kipakiparia mule za kori igana beto za qari iaria mutugu ria doru. ");
INSERT INTO ghn_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ko ria doru za qari tekuteku beto qari pote beto. ");
INSERT INTO ghn_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Beto za qari aru varivarikamudi ria na kipakipa bereti beto na igana qari kole joladi, ko qari vapugeleria za ka manogori topa. ");
INSERT INTO ghn_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ko na nguti varikamudi ria doru tinoni qari tekuteku za ka lima vuro marene. ");
INSERT INTO ghn_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ego za pojadi i Jisu ria nana sepele ko mari zae pa koaka ko mari toka lao momoe pa Betiseda pa maka kalena na ovuku za gudi, goto aza za suvere jola ko za dogoro vakeniria mae tu ria na minete tinoni. ");
INSERT INTO ghn_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ko pa liguna za loloi vakeniria nari za zagere zae pa maka kubokubo aza ko za varavara. ");
INSERT INTO ghn_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ko totonai za gore na veluvelu za na koaka qari zaea ria na sepele za tori lao tu pa korakorapa kolo, goto aza makana za korapa pa pezo tu. ");
INSERT INTO ghn_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ko za gelegele laodi za qari korapa variukegedi na qelu ria nana sepele, ura za raja lame vei pa koimoa za na gava. Ko padapada vei varikorapaina kue ko vonomo koloko volavolaza lea za rerege tuti lao pa vuliti kolo ko za lao kamuria aza. Ko mi valaqao joladi za gua. ");
INSERT INTO ghn_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ba totonai qari batia aza za korapa rerege pa vuliti kolo, za palu na tomete qari gua ria ko qari lukana uui tu. ");
INSERT INTO ghn_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ria doru sepele za qari bati betoadia ko qari matagutu neqeneqeredi beto. Ba pa totozo tugu aza za paranga laoria aza, ari za gudi vei, <<Mu varene! Ara gu ani, muke matagutu!>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Beto za tonai za lao zae pa koaka aza, za bule betonana za na gava. Ko qari gabara vitivitigi ria nana sepele. ");
INSERT INTO ghn_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ura qarike dogoro vakaberia za na ginuana ka lima batu bereti za varivatekutekuni i Jisu ura za oqoro revanga na dia roquroqu. ");
INSERT INTO ghn_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ego tonai qari karovia ria za na kolo za qari lame paro pa ia pa Qenesareti, ko qari vatitia ketakoi za na dia koaka. ");
INSERT INTO ghn_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Aza tugu qari tete paro ria, za qarike oriavo tugu dogoro gigalia ria na tinoni ketakoi i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ko qari abuturia ria na doru kota ketakoi beto ko qari okoto pogozo kamu tavitidi tugu na dia lovu ria na tinoni qari mo. Ketakoi qari nongoroni pa zanu za korapa i Jisu qari gua nari za qari varipogozo lao beto vei tugu ketakoi. ");
INSERT INTO ghn_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ko pa dorudi na ia ketakoi za rijo lao vei i Jisu, bi pa guguzu pekipekidi babi pa guguzu lavalavatadi, za qari pogozo kamudi tugu pa ia makemaketina ketakoi ria na tinoni momodi beto qari tepa tokatokaia ria i Jisu ko mari ulia gu na uquna nana poko ba leana gu qari gua. Ko ria doru tinoni momodi qari ulia na uquna nana poko za qari tasalanadia tugu. ");
INSERT INTO ghn_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ego ria na Parese beto ria kaki qari varivagigalaini na Vavanau na koko lame veidi pa Jerusalema za qari varikamu lame ti Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Qari batiria za kaki sepele tana qari tekutekuni na limadi nake liosodi ura qarike loqa lima vei qari varivagigalaini ria na Parese qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ura ria na Parese beto ria doru tinoni Jiu za qari kopudi ria na uana tututi tadiria na dia tite pa moa ko qarike tekuteku ria tonai qari oqoro loqa lima. ");
INSERT INTO ghn_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Beto tonai mari mule pa maketi za mari iu valioso mae tu beto za mari tekuteku. Beto kubo mule ria na tuti pa dia uana vavalioso vevei pa nyanyapa valioso kapa, na raro, na titinudi, za qari kopudi tugu vei. ");
INSERT INTO ghn_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ko ria na Parese beto ria qari varivagigalaini na Vavanau za qari nanazia i Jisu, ari qari guni vei, <<Ae za vei ko qarike tutia tu ria na sepele tamu ria na uana tututi tadiria na nada tite, goto qari tekutekuni gu ria za na limadi nake liosodi?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nari za oe laoria i Jisu za ria, ari za gua vei, <<Za zotonana gu i Aisea tonai za ululeni za na veveimiu gamu na tinoni vavabata sekesekemiu. Ari za na paranga za kutiria aza, <Ria na tinoni ari za qari vatarazaeniziu na beruberudi gu, ba na bulodi za zou vitivitigi pana taqu. ");
INSERT INTO ghn_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Na goborodi gu ria na dia vinatarazaequ ara, qari varivagigalaidi na varivagigalaidi na vinaturu tadiria na tinoni gu,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Gamu loi paledi gamu za ria na garunu tana Tamaza, ko gamu kopu valeleana ria gamu na uana tututi tadiria na tinoni gu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Beto ari za gudi vei mule, <<Gamu gigalai jola za gamu! Ko gamu vakeporea ginuana gamu za na garunu tana Tamaza ko gamu vaturu neqiria za ria na miu uana tututi makamiu! ");
INSERT INTO ghn_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ari za gua vei i Mosese, <Mu pangagadi ria na tinamiu beto na tamamiu, beto, na tinoni mina paranga vapiruni na tinana babi na tamana, za mina tavauke tugu aza,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ba gamu za ari tu gamu gamu pojai tu za vei maka tinoni ari bi gudi vei ria na tinana na tamana, <Na zakazava ba boka tokadigamu gamu kori za za kobani,> bi gua (na ginuana na paranga ani za nana varivana madina na Tamaza), ");
INSERT INTO ghn_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","nari za gamuke vamalumia aza ko bi tokadi ari kori tinana beto na tamana qari varivasevi. ");
INSERT INTO ghn_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ko pa zona vei zara za gamuke dogoro vapore veveinaia gamu za na paranga tana Tamaza tonai gamu tutia gamu za na miu uana tututi qu teku izongoria. Ko kubo uana tututi vevei ari za gamu roitidi gamu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ego za kuku varikamu sogadi mule i Jisu ria na minete tinoni ko ari za gudi vei, <<Mu vainongoro lame za gamu doru, ko mu vakaberia ani. ");
INSERT INTO ghn_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kepore za maka zava za teku lugeni pa tinina na tinoni mina boka vapajia aza. Goto aza tu za koko votu lame vei pa bulona na tinoni za vapajia za na tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Na tinoni za pore talinga nongonongorona za mi vainongoro,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ego ko tonai za loiria ria na minete tinoni ko za lao luge pa ruma aza, nari za qari nanazani ria nana sepele za na veveina na vavakato vavapada ani. ");
INSERT INTO ghn_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nari za paranga laoria aza ria, ari za gudi vei, <<Ko gamu ba gamuke gilagilai tugu za? Gamuke vakoinonoa tu gamu za? Kepore maka zava za teku ponyolia na tinoni za vapajia nana toa. ");
INSERT INTO ghn_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ura zake luge pa bulona na tinoni aza goto pa borina gu, beto za vavotu keni pale gu,>> za gua i Jisu. (Ko tonai za paranga vei zara i Jisu za vakaberia aza za doru ganigani za qari liosodi beto.) ");
INSERT INTO ghn_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Beto ari za gua vei mule i Jisu, <<Aza tu za koko votu lame vei pana tana tinoni za aza tu za vapajia aza. ");
INSERT INTO ghn_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ura pa leo bulona tu na tinoni qari koko votu lame vei za na roquroqu ikikeredi, na roiti valulasa, na ikiko, na varivai, ");
INSERT INTO ghn_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","na barabarata, na mumuino, na roiti ikikeredi, na nyonyorava, na uana pajidi, na konokono, na vamoroana tinoni, na vavatarazae mule, beto na uana duviduvilidi. ");
INSERT INTO ghn_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Doru zakazava ikikeredi ari za qari votu lame vei pa leo bulona na tinoni ko qari vapajia za na tinoni aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ego za taloi pa guguzu aza i Jisu ko za lao pa guguzu pa varilivutaina pa Turosi. Ko tonai za kamu ketakoi aza, azae za lao luge pa maka ruma ura zake nyoroguani ko bari gilagilai ria na tinoni za na suverena aza ketakoi za gua. Ba zake lea ovo aza. ");
INSERT INTO ghn_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kolenana pa guguzu ketakoi za maka tiolata reko za kolea na ongu ikerena za na tuna reko. Ko aza tugu za nongoroni i Jisu nari za lame ko za nyumu sori tungutunguna pa nenena aza, ");
INSERT INTO ghn_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","beto za tepai i Jisu ko mi iju pale na tomete ikikerena za kole tana tuna reko za gua. Ego na tiolata reko ani za na tinoni karovona tu, ko na podona keta pa kale Poinikia tu pa guguzu pa Siria. ");
INSERT INTO ghn_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nari za oe laoa i Jisu za na reko ani, ari za guni vei, <<Momoe za ria na koburu mae tu za mari tekuteku, ura zake gozoro za vei bari tateku za ria na ganigani tadiria na koburu ko bari tagona lao vadi na sie,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ba za oe lao tu za na reko, ari za gua vei, <<Bangara, ria na sie pa kauru tevolo ba qari memeagedi gu za pa vuvuzudi na ganigani qari vavaloturia ria na koburu,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nari ari za guni vei i Jisu aza, <<Ego vei muna oe vei zara ao, za leana mu mule laomua pa mua ruma ropi. Na tomete ikikerena za tori taloi tu tana tumu reko,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ko tonai tugu za mule lao pa nana ruma aza, azae za batia na tuna reko za tori loia tu na tomete ikikerena ko za korapa kolenana pa nana lovu aza. ");
INSERT INTO ghn_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ego za taloi pana guguzu pa Turosi i Jisu ko za rerege vei pa guguzu pa Sidoni, beto za gore vei pa Manogaguguzu ko za lao pa ovuku pa Qalili. ");
INSERT INTO ghn_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ko tonai za qari toka kamuni ria kaki tinoni za maka tinoni kikiqilina beto na pokapokana zake boka paranga valeana, ko qari tepa tokatokai i Jisu ko mi vaoponi na limana ko mi tasalana aza qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nari za teku varijoa pa varikamu tinoni ko za toka kaleni makana i Jisu za na tinoni ani, beto za totuni pa leona kori talingana na tinoni ani za na karukarusuna, beto za odolo taria na karukarusuna beto za totuni pa meana na tinoni ani. ");
INSERT INTO ghn_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Beto za enga zae pa noka, za vagorea maka vazaenga lavata, beto za paranga lao pana tana tinoni, ari za guni vei aza, <<Epata!>> (na ginuana na paranga ani za <<Mu revanga tu!>> za gua). ");
INSERT INTO ghn_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Pana totozo tugu aza za tavonga za na talingana na tinoni aza, beto na meana za puku tari za za taruvata, ko za paranga valeanana. ");
INSERT INTO ghn_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Beto za naquria i Jisu ria na tinoni ko marike vavavakatoni za na roiti ani za gudi. Ba tonai za naquria i Jisu nari za tonai za qari gigiri tugu vaqavaqatani ria na tinoni za na veveina aza. ");
INSERT INTO ghn_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ko qari gabara vitivitigi beto ria doru, ko ari qari gua vei, <<Doru zakazava za roiti valeana betoria za na tinoni ani. Ko ria tu na kiqili ba za vanongonongororia beto ria na poka ba za vaparangaria,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ego maka totozo mule totonai za varikamu lame za maka minete tinoni, ko kepore vagila za na dia tekutekuna vei bari tekua. Ko za kuku tekuria i Jisu ria nana sepele ko ari za gudi vei, ");
INSERT INTO ghn_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","<<Qa roquroqu vitivitigiria ara ria na minete tinoni ari, ura tori kue ranedi tu qari suvere tavitiziu ko koviria kepore maka za mari tekua. ");
INSERT INTO ghn_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Vei mana garunu vakeni buraburanaria ara pa dia guguguzu, za pala mari tabulobulo pa zona za ari. Ko ria kaki ari na dia guguzu ba za zou jola,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nari qari oe laoa ria nana sepele aza, ari qari gua vei, <<Ura pa qega vei ari za pae mule tana boka teku ganigani za gita beto tana boka vatekutekuria ria na tinoni ari?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nari za nanaza ria i Jisu ria, ari za gudi vei, <<Ka viza batu bereti gamu pogozoria gamu?>> za gua. Nari qari paranga ria, <<Ka vitu gu!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nari za pojadi ria na minete tinoni ko qari nyumu pa pezo. Beto za tekuria za ka vitu batu bereti, ko za paranga leanani, za kipakiparia, beto za vadi ria nana sepele ko mari iadi na tinoni za gua. Nari qari roiti vei tugu ria na sepele. ");
INSERT INTO ghn_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ka viza igana mutugu za qari pogozoria, ko aza za manadi, beto za pojadi mutugu ko qari iadi ria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Qari tekuteku ko qari pote beto ria doru tinoni. Beto za qari aru varivarikamudi za doru kipakipa kole joladi ko ka vitu topa tu za qari kurakura vapugeledi. ");
INSERT INTO ghn_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ko na ngutidi ria za padapada vei ka made vuro marene. Pa liguna aza za vamule keniria i Jisu ria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Beto pa totozo tugu aza za taloi aza ko za lao zae tavitiria ria nana sepele pa koaka ko qari toka lao vei pa kota pa Dalamanuta. ");
INSERT INTO ghn_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ego qari lame ti Jisu za ria na Parese ko qari podalai varigua lao tana. Qari tepai ko mi roitini aza za maka roiti vinagilagila varivagabarana koko lagere veina pa noka qari gua. Ko qari vei ko mari podekia qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nari za vagorea maka vazaenga lavata i Jisu beto ari za gudi vei, <<Ae za vei ko gamu tepai tu na roiti vinagilagila varivagabaradi za gamu na zazae tinoni koviria? Ma poja zozotodigamu ara gamu: kepore za maka vinagilagila vinazozoto mina taroiti vadi ria na zazae tinoni ari!>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Beto za turu loi paledi aza ria ko za zae soga pa koaka ko za karovo laonana pa maka kale ovuku. ");
INSERT INTO ghn_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ego qari roqu mumani ko qarike pogozo vazoku bereti ria na sepele, goto maka moqamoqazana gu za qari surania pa koaka. ");
INSERT INTO ghn_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ko za pojadi i Jisu ria, ari za gudi vei, <<Mu suvere kopu! Mu balaudi za na vavakovuruni palava tadiria na Parese beto ti Herodi,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Qari kole varivarivavakato makadi ria na sepele, ari qari gua vei, <<Za kepore gada bereti za poja veidigita zara aza,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ba za tori gilagilainana tu i Jisu za aza qari kole pojai ria, ko ari za gudi vei, <<Ae za vei ko gamu korapa tu varivavakatoni za kepore gemiu bereti gamu gua? Gamuke vakoinonoa beto gamuke gilagilai tu gamu za? Za oqoro tu revanga za na bulomiu? ");
INSERT INTO ghn_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Na beko kolenana na matamiu, ba gamuke boka batabata tu za? Beko pore talingamiu tu, ba gamu oqoro tu tavonga? Gamuke roqu vakoititia tu gamu za na veveina ");
INSERT INTO ghn_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","totonai qa kipakiparia ara ka lima bereti ko qa iadi ari ka lima vuro tinoni? Ka viza za na topa gamu vapugeledi na kipakipa bereti kole joladi?>> za gudi. Nari za qari paranga ria, <<Ka manogori,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nari za paranga i Jisu, <<Goto tonai qa kipakiparia ka vitu bereti ko qa iadi ka made vuro tinoni ara, za ka viza topa za gamu vapugeledi na kipakipa bereti kole joladi?>> za gudi. Nari za qari oe lao tu ria, <<Ka vitu,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","<<Ba ae za vei? Gamu korapa oqoro tu gilagilai gamu za?>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ego qari lame kamu pa Betiseda ari Jisu beto ria nana sepele. Ko ketakoi za qari toka lameni ria na tinoni pana tana za maka tinoni nake batabatana, beto qari tepa vitivitigia ko mi vaoponi na limana qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nari za aru tekua i Jisu za na limana na tinoni zake batabata ani ko za toka votuni pa peguruna na guguzu. Ketakoi tu za lao odolo taria aza za na matana beto za vaoponi na limana beto za nanazia, ari za guni vei, <<Ae za vei, qu boka batia tu kaki zakazava?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nari za enga za na tinoni ani, beto za paranga, <<Qa batiria tugu ria na tinoni, ba qari vei gu na suvege qari korapa rereregedia,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Beto za vaopo sogani mule na limana i Jisu za kori matana na tinoni ani. Nari za dogoro dodola beto za leana ligunana za na nana dogoro, ko za dogoro vakabekabere betoria za doru zakazava. ");
INSERT INTO ghn_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Beto za garunu vakenia pa nana guguzu i Jisu aza, ari za guni vei, <<Muneke lao oqa votu pa guguzu pa Betiseda,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ego za taloi keni i Jisu beto ria nana sepele ko qari lao vei pa guguguzu pa Sizaria Pilipae. Tonai qari korapa rerege lao pa zona azae za nanazaria i Jisu ria nana sepele, ari za gudi vei, <<I zei qari guniziu ara ria na tinoni?>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nari za ari qari gua vei ria, <<I Jone Paputaiso ao qari gua ria kaki. Goto kaki za i Elaija ao qari gua. Goto ria kaki mutu za maka ria na tinoni korokorotai pa moa ao qari gunigo,>> qari gua ria na sepele. ");
INSERT INTO ghn_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Beto za nanazaria mule aza ria, <<Goto gamu i zei gamuguniziu ara?>> za gudi. Nari za oe lao tana i Pita, ari za guni vei, <<Ao tugu za na Karisito,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Beto za naquria i Jisu ria ko marike vavakatoni tana maka goto tinoni za na veveina aza za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ego ko za podalai varivagigalaini tadiria i Jisu za na veveina na Tuna na Tinoni mina gozororia zoku vitigi beto mari kilu paleni ria na tiolata matamata, na kuta iama beto ria qari varivagigalaini na Vavanau ko mina tavauke aza, ba pa liguna kue rane za mina turu mule soga pa uke aza za gua. ");
INSERT INTO ghn_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ko za poja lodalodakia i Jisu tadiria za vei aza. Nari za teku kaleni i Pita i Jisu ko za podalai tokea. ");
INSERT INTO ghn_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nari za balinga i Jisu ko za dogoro lao ria kaki nana sepele beto za tokea i Pita, ari za guni vei, <<Mu lao pa liguqu Setani! Ao quke korapa roquroqua na nyorogua tana Tamaza ao, goto tana tinoni gu,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Beto za kuku varikamudi i Jisu ria na minete tinoni beto ria nana sepele ko ari za gudi vei, <<Na tinoni za nyorogua tutiziu ara za mi roqu muma paleni nana toa makana, beto mi pogozia za nana korosi ko mi tutiziu ara. ");
INSERT INTO ghn_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ura na tinoni za nyorogua kopu vasareni nana toa makana za pala mina saivia tugu za nana toa. Goto na tinoni zake rabekeni nana toa pa tutiqu ara beto pa vaqavaqatani na nongoro leana taqu za mina aloa za nana toa. ");
INSERT INTO ghn_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Na za mina boka vagavoria na tinoni vei bi gona pale aza za nana toa ko bi izongia na kasia guguzu doruna? Bi mijatu! ");
INSERT INTO ghn_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ko na za mina roitini aza ko mina boka alo muleni za nana toa? Bi mijatu! ");
INSERT INTO ghn_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Na tinoni za keaniziu ara beto na qua paranga pa zazae tinoni ikikerena beto na selana ani, nari za na Tuna na Tinoni ba mina keani tugu aza tonai mina lame tavitiria ria na mateana tabuna pa neqi lavata tana Tamaza na Tamana aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Beto ari za gudi vei mule i Jisu ria, <<Ma poja zozotodigamu ara gamu: kaki gamu qari korapa turu ari za marike tori uke tu tinganai mari batia na binangara tana Tamaza mina lame tavitia na neqi,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ego za jola ka vonomo rane, azae za tekuria i Jisu ari Pita i Jekopi beto i Jone ko za toka zaedi pa maka kubo ululuna ko qari suvere makadi ketakoi. Ko pa moedi ria ketakoi za soga za na tinina i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Na nana poko za keka kilakilanga joladi doru zakazava qari vakeka veidi ria na tinoni pa pezo. ");
INSERT INTO ghn_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Beto qari bola votu kamuria za ari Elaija i Mosese ko qari kole paraparangia i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ko totonai za paranga lao ti Jisu i Pita, ari za guni vei, <<Rabi, za leana jola za gami korapa pani gami! Ko mami roitini tu ropi kue aqaqo, maka tamu, maka ti Mosese, beto maka ti Elaija, uve?>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ura qari matagutu vitivitigi ari kue ko zake gilagilai na za za pojai i Pita. ");
INSERT INTO ghn_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Beto za bola amuria maka lei beto totonai qari nongoria za maka mamalaingi koko veina pa korapa lei, ari za gua vei, <<Ani za na tuqu, aza qa roquroqu vitivitigia ara. Mu nongoria aza!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nari qari siboro ria ko qari dogoro varilivutai ba kepore mule za maka tinoni bari batia, goto makana gu i Jisu za korapa suvere tavitiria. ");
INSERT INTO ghn_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ko tonai qari loia na kubo ko qari korapa oqa votu goregoredia, azae za naquria i Jisu ari kue sepele ko marike vavakatoni aza vei qari batia, tinganai mina turu mule mae tu pa uke za na Tuna na Tinoni za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ko qari kole kopuni gu makadi ria za ani, ba qari kole varigua makadi za na za beka na ginuana za na turu mule pa uke za guni aza qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Beto qari nanazia aza, ari qari guni vei, <<Ae za vei ko qari pojai ria qari varivagigalaini na Vavanau za i Elaija mae tu za mina lame momoe?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nari za oe laoria i Jisu ria, ari za gudi vei, <<Zozoto tugu i Elaija za mina lame momoe tu ko mina vatana vatuvizi liguria ria doru zakazava. Ba ae za vei ko za pojai tu na Kutikuti Tabuna za mina gozororia zoku vitigi beto mina tadogoro vakepore za na Tuna na Tinoni? ");
INSERT INTO ghn_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ba ara ma pojadigamu, za tori lame tu i Elaija ba qari tutini dia roquroqu vei qari nyoroguani ria aza, vei tugu za tori pojai tu na Kutikuti Tabuna,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ego tonai qari mule gore kamu pana tadiria nana sepele ari Jisu beto ari kue sepele za tokaria, za qari batia za maka minete tinoni lavata korapa suvere ketakoi beto ria qari varivagigalaini na Vavanau za qari korapa varigua lao tadiria na sepele. ");
INSERT INTO ghn_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Aza tugu qari batia i Jisu ria doru tinoni, za qari gabara beto qari abutu lao gozogozo qeraqerani aza. ");
INSERT INTO ghn_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Beto za nanazaria i Jisu ria nana sepele, ari za gua vei, <<Na za gamu kole variguani gamu pana tadiria?>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nari za paranga za maka tinoni pa varikamu tinoni aza, ari za gua vei, <<Tinoni varivagigalai, na tuqu marene ara za qa toka lameni tamu, ura za kolea na ongu ikikerena ko zake boka paranga. ");
INSERT INTO ghn_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Pae tu mina korapa aza ba tonai mina vakamuni nari za iruni tu pa pezo ko za dadao tu na ngujuna, za garata beto za getozo beto nana tu na tinina. Ko qa teparia ara ria na mua sepele ko mari iju votu paleni za na ongu ikikerena qa gudi, ba qarike bokai tu,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nari za oe laoria i Jisu ria, ari za gudi vei, <<Gamu na zazae tinoni koviria za kepore zozoto na miu rangerange! Ae tu koi vei zovaina vei za mana kole suvere tavitigamu ara za gamu! Ae tu koi vei zovaina vei za mana kole tapatianadi gamu ara za gamu? Mu toka lameni taqu za na koburu aza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ko qari toka laoni tana za na koburu marene aza. Ko aza tugu za dogoro lao za na ongu ikikerena ani ko za batia i Jisu, nari za sasuria za na koburu marene, ko za valotua ko za titolo tabokibokili tu pa pezo, beto za dadao tu na ngujuna. ");
INSERT INTO ghn_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Beto za nanazia i Jisu za na tamana na koburu, ari za guni vei, <<Ae totozo za podalai veini aza zara?>> za gua. Nari za oe lao za na tamana, <<Za podalaini na melaluna tu. ");
INSERT INTO ghn_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ko kubo totozo za gona laoni tu pa iku beto pa kolo ko mi vaukea za gua. Ko vei bu boka ao nari za mu roquroqugami ko mu tokadigami,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nari za oe lao i Jisu, ari za guni vei, <<Vei bu boka qu gua tu ao! Doru zakazava za bokai gu na tinoni za vazozoto,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aza tugu za gua vei zara i Jisu nari za velavela votu za na tamana na koburu ani, ari za gua vei, <<Qa vazozoto gu ara, mu tokaniziu ketakoi zake neqi na qua vinazozoto!>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ego ko tonai za batiria i Jisu qari abutu varikamu lame ria na minete tinoni, azae za tokea aza za na ongu ikikerena, ari za guni vei, <<Ao na ongu kikiqilimu na pokapokamu qa parangaigo ara ao ko mu votu keni tana koburu marene ani beto ko munake kamu kole soga pana tana,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nari za kuku uui za na ongu ikikerena ko za raja vaneqeneqeria za na koburu marene ani beto za votu taloi pana tana. Ko za dogoro vei na tinoni ukena za na koburu marene ani. Ko ria zoku tinoni za qari paranga vei ari, <<Koi, za tori uke tu zana,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ba za arua i Jisu za na limana na koburu ko za bako vatatakolea nari za turunana za na koburu. ");
INSERT INTO ghn_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ego ko totonai za luge pa leo ruma i Jisu, za qari peki nanaza golomia ria nana sepele aza, ari qari guni vei, <<Ae za vei ko gamike boka tu iju paleni gami za na ongu ikikerena?>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nari za oe lao i Jisu, ari za gua vei, <<Na zakazava vevei zara za zake taroiti goboro goto pa varavara gu beto za boka taiju votu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ego ko za taloi ketakoi i Jisu beto ria nana sepele ko qari jola vei tu pa Qalili, ura zake nyoroguani i Jisu za bari gilagilai ria na tinoni za ketakoi za suvere aza za gua. ");
INSERT INTO ghn_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ko za kole vagigalairia aza ria nana sepele, ari za gudi vei, <<Na Tuna na Tinoni za pala mina tavalao pana limadi ria na tinoni ko mari vaukea, ba pana liguna gu kue rane mina tavauke za pala mina turu mule aza,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Qari rurani ria za na ginuana na paranga ani, ba qari pangagadia ko qarike tumani nanazia ria aza. ");
INSERT INTO ghn_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ego tonai qari kamu pa Kepaniami ko qari luge pa ruma nari za nanazaria i Jisu ria nana sepele, ari za gudi vei, <<Na za gamu kole variperani paranga gamu pa zona lamena?>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ba qari okoto ke vagala beto ria, ura pa zona lamena za qari kole variperani paranga ria za na veveina: <<I zei za na poreveveina jola?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nari za nyumu ko za kuku varikamudi i Jisu ari ka manogori nana sepele beto ari za gudi vei, <<Na tinoni za nyorogua tavaululu za mi kole vapekai tadiria doru ko mi nabuludi ria doru,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Beto za aru vakatapia aza za maka koburu pekina ko za vaturua pa moedi ria doru, beto za ovulu vakatapia beto ari za gudi vei, ");
INSERT INTO ghn_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","<<Na tinoni za vakamu valeania pana izongoqu ara za maka koburu peki vevei ani, za vakamu valeanaziu tugu ara. Ko aza na tinoni za vakamu valeanaziu ara, za nake ara gu makaqu za vakamuziu na tinoni aza, goto aza tugu vei za garunuziu ara,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ego za paranga lao tana i Jone, ari za gua vei, <<Tinoni varivagigalai, gami batia gami za maka tinoni za ijiju pale tomete ikikeredi pa izongomu ao ko gami vanogotia, ura nake somanana tadigita aza,>> za gua i Jone. ");
INSERT INTO ghn_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ba za paranga i Jisu, <<Muke vanogotia! Ura kepore mule za maka tinoni za roitini maka roiti varivagabarana pa izongoqu ara mina boka poja vikevikereziu ara pa liguna. ");
INSERT INTO ghn_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ura na tinoni zake kanagita za kole vei tadigita aza. ");
INSERT INTO ghn_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ma poja zozotodigamu ara gamu: na tinoni za vadigamu maka kapa pie pa izongoqu ara ura za gilagilai aza za gamu na tinoni tana Karisito, nari na tinoni aza za mina tekua tugu za nana pinia,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","<<Na tinoni za vagabala pirua maka koburu peki za rangeziu ara za leana jola za bi piluni maka patu doa lavata na ruana ko bi lupi pale pa kolo. ");
INSERT INTO ghn_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Beto vei bi vatatupego ko bi varoitinigo na sela za maka kale limamu, za mu lomoto vaqopu pale! Ura za leleana jola za na qopuqopumu gu ao ba bu tekua za na toa jola. Aza za leana jolani vei bu izongo betoria kori limamu ko bari tagona lao beto pa heli na iku zake tailili vaukena. ");
INSERT INTO ghn_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Beto vei bi vatatupego ko bi varoitinigo na sela za maka kale nenemu za mu lomoto vaqopu pale gu! Ura za leana jola za na qopuqopumu gu ao ba bu tekua za na toa jola. Aza za leana jolani vei bu izongo betoria kori kale nenemu ko bari tagona lao beto pa heli. ");
INSERT INTO ghn_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Beto vei bi vatatupego ko bi varoitinigo na sela za maka kale matamu, za mu lobiti pale gu! Ura za leleana jola za bi maka matamu gu bu luge pa binangara tana Tamaza. Aza za leleana jolani vei bu izongo betoria za kori matamu ko bari tagona lao beto pa heli, ");
INSERT INTO ghn_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ketakoi qari kole na ulozo qarike boka uke beto ko na iku vuruvurunguna zake boka tailili vauke. ");
INSERT INTO ghn_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ura doru tinoni za mari tavalioso pa iku, maka moqaza podeke vei na vavavui za tavalioso pa solo. ");
INSERT INTO ghn_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Na leleana za na solo. Ba vei mina maragutu za na lingilingina, za ae mule muna roiti vei beto muna boka valingilingi sogai? Mu izongia na solo pa miu toa ko mu makarai suvere varibaere valeana,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ego za taloi ketakoi i Jisu ko za gore vei pa guguguzu pa Jiudia beto pa maka kalena pa pie Jodani. Ko na minete tinoni mule za qari varikamu lame pana tana ko aza za varivagigalai vei tugu za tori manogai roroitidi tu doru totozo. ");
INSERT INTO ghn_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ego ko ria kaki Parese za qari nyorogua vagonai i Jisu ko qari lame nanazia, ari qari guni vei, <<Ae vei, na tavamalumuna tugu pana Vavanau za na tiolata marene za mina boka loi pale za na maqotana?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nari za oe laoria i Jisu ria, ari za gudi vei, <<Na za za garunudigamu i Mosese gamu?>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nari za ari qari gua vei, <<I Mosese za vamalumia za na tiolata marene mina boka kutia maka pepa variloi beto mina boka vakeni paleni za na maqotana za gua,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ba za parangaria i Jisu ria, ari za gudi vei, <<Ura koko vei tu za duviduvili na roqumiu gamu vei gu zara azae za kuti vadigamu i Mosese za na garunu aza. ");
INSERT INTO ghn_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Goto pa podapodalaina na vinapodaka za na Tamaza za roiti vamarenia beto za varekoa za na tinoni. ");
INSERT INTO ghn_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ko za vei aza za na marene za mina loiria na tamana beto na tinana, ko mina kole maka tana maqotana. ");
INSERT INTO ghn_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ko ari kori za mari maka tinoni gu. Ko qarike pikataori goto qari maka gu ari kori. ");
INSERT INTO ghn_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ko aza za tori varipuku taridi tu na Tamaza, za na tinoni mike varipikataidi,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ko tonai qari mule pa ruma za qari nanazani mule ria na sepele za na ginugua ani. ");
INSERT INTO ghn_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nari za parangaria i Jisu ria, <<Na marene za loi pale na maqotana ko za elava sogai maka reko gotona mule za barabarata tugu aza. ");
INSERT INTO ghn_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ko na reko ba vei bi loi pale na marenena ko bi elava sogai maka goto marene mule za barabarata mutugu za na reko aza,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ego qari toka kamudi ria kaki tinoni ti Jisu ria na koburu ko mi vaopodi na limana aza qari gua, ba qari vatokedi ria na sepele. ");
INSERT INTO ghn_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Totonai za batiria i Jisu qari roiti vei zara za tagigiri ko ari za gudi vei, <<Mu vamalumuria ria na koburu ko mari lame pana taqu. Muke suquturia, ura tadiria tugu veveidi ari za na binangara tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ma poja zozotodigamu ara gamu: na tinoni zake vei maka koburu peki pa tekuna na binangara tana Tamaza, za minake luge lao tugu aza,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Beto za aru vakataparia aza ria na koburu ko za vaopodi na limana ko za manadi. ");
INSERT INTO ghn_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ego tonai za taloi keni ko za korapa lalaonana pa zona i Jisu, azae za abutu lame nyumu sori tungutunguna pa moena i Jisu za maka tinoni, ko za nanazia, ari za gua vei, <<Tinoni varivagigalai leleamu, na za za mana roitini ara beto mana teku izongia ara na toa jola?>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nari ari za guni vei i Jisu aza, <<Ae za vei ko qu gigalaniziu tu na leleaqu ara ao? Kepore za maka bi leleana, goto makana gu na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Qu gilagilariamua ao ria na vavanau: <Muke varivai, muke barabarata, muke ikiko, muke jutu sekeseke, muke teku izizongo pa sekeseke, mu pangagadi na tinamu na tamamu,>' qari gua,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nari ari za gua vei za na tinoni ani, <<Tinoni varivagigalai, doru garunu vevei ria za toto vei na pekiqu tu qa podalai tutiria ara za ria,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tonai za dogoro taria beto za roquroqua i Jisu aza, ko ari za guni vei, <<Maka zakazava gu za oqoro okotonigo ao. Mu lao ko mu vavaidi ria doru zakazava qu izongoria, ko mu iadi ria na tinoni golabadi ko mi kole na mua izizongo pa noka. Beto za mu lame tutiziu ara,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tonai za paranga vei zara i Jisu nari za titigore aza, beto za tabekele ko za pogozo kenini aza za na bulo takulangana, ura na tinoni izizongo vitivitigi aza. ");
INSERT INTO ghn_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Beto za dogoro varilivutai i Jisu beto ari za gudi vei ria nana sepele, <<Za tapata vitivitigi ko mari lugea ria na tinoni izizongo za na binangara tana Tamaza,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nari qari gabarani ria nana sepele za na paranga tana. Ba za paranga soga laoria mule i Jisu ria, <<Boko tuqu, za tapata jola na lugena za na binangara tana Tamaza! ");
INSERT INTO ghn_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Na manugu tapatana jola za na kameli mina sulingi lugea na lobogona na nila, ba za tapata jolani mutu aza za na tinoni izizongo mina lugea za na binangara tana Tamaza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ko tonai za qari gabara vitivitigi ria na sepele ko qari okoto varivarinanaza lao lame, ari qari gua vei, <<Ko mina vei za i zei gu za mina taalo?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nari za dogoro laoria i Jisu ria beto ari za gua vei, <<Tana tinoni za tapata jola ani, ba tana Tamaza zake tapata. Ura kepore maka zakazava za tapatia na Tamaza,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Beto za paranga i Pita, ari za gua vei, <<Dogoro! Gami za gami tori loi vakole paledi tu za doru zakazava ko gami korapa tutigomami ao,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nari za paranga i Jisu, ari za gua vei, <<Ma poja zozotodigamu ara gamu: na tinoni za loiria nana ruma, na luluna marene na luluna reko, na tamana na tinana, na tuna babi na kobu pezo, pa ginuaqu ara beto na nongoro leana, ");
INSERT INTO ghn_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","za aza za mina tamo vazoku vani na Tamaza koviria. Ko pala mina izongoria zoku gogoto jola ruma, beto mina zoku gogoto luluna marene na luluna reko, na tinana, na tuna, na pezo, beto mina tangangangulu tugu vei aza. Beto pa totozo za korapa lame za mina izongia na toa jola za na tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ko ria na zoku qari momoe za mari na liguligu, beto ria na zoku qari liguligu za mari momoe,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ego za tutia i Jisu beto ko ria nana sepele za na zona zaena pa Jerusalema ko i Jisu za momoedi. Ria na sepele qari gabara vitivitigini aza beto ko ria na tinoni qari tuti liguria ba qari matagutudia tugu. Ko za toka kaledi mule i Jisu ari ka manogori sepele ko za podalai pojadi ria na zakazava mina gozororia aza ketakoi, ");
INSERT INTO ghn_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ari za gudi vei, <<Mu vainongoro. Taqe korapa rerege zae pa Jerusalema za gita. Ketakoi za na Tuna na Tinoni za pala mina tavalao pa limadi ria na kuta iama beto ria qari varivagigalaini na Vavanau. Pala mina tajutu ko mina tavauke beto pala mari valaoa tadiria na tinoni karovodi aza ");
INSERT INTO ghn_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ko mari vavaledeni, mari tue taria beto mari piqolia ko mari vaukea aza, beto mina jola gu kue rane za mina turu mule aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ego qari lame ti Jisu ari Jekopi beto ko i Jone kori tuna marene i Jebeti, ko ari qari guni vei, <<Tinoni varivagigalai, gami nyoroguani ko na manugu babi tepanigo gami kori za bu roiti vadigami ao,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nari ari za gua vei i Jisu, <<Na za gamu nyoroguani gamu kori ko ba roiti vadigamu ara qamuguni?>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nari qari oe lao ari kori, ari qari gua vei, <<Dai, mu vamalumugami gu ko tonai muna nyumua ao za na mua nyumunyumuna bangara pa mua binangara lavata, za maka gami kori mi nyumu keta pa kale matuamu goto maka keta pa kale merimu,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nari ari za gudi vei Jisu ari kori, <<Gamuke gilagilai gamu kori za na manugu gamu korapa tepai. Ae vei, muna boka lugeria tu gamu kori za na vitigi mana gozororia ara? Muna boka tapaputaisoni gamu kori za na paputaiso vitigi veveina mana gozororia ara?>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nari ari qari gua vei ari kori, <<E, mami boka gu,>> qari gua. Nari ari za gudi vei i Jisu ari kori, <<E, na vitigi mana lugeria ara za muna gozororia tugu gamu kori, beto ko muna tapaputaisoni gu gamu kori za aza mana tapaputaisoni ara. ");
INSERT INTO ghn_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ba nake ara mana mijatia za i zei za mina nyumu pa kale matuaqu beto pa kale meriqu. Goto na Tamaza tu mina vadi ria za tori vatana vadi tu za kori nyumunyumudi ari,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ego tonai qari nongoria ari ka manogaputa sepele za vei zara, za qari tagigiri vikevikeredi ari Jekopi i Jone. ");
INSERT INTO ghn_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nari za kuku varikamudi i Jisu ria nana sepele, ko ari za gudi vei, <<Gamu gilagilaimiu gamu za ria qari tadogoro vei na bangaradi ria na tinoni karovodi za qari lalae betodi gu za na toa tadiria na dia tinoni, beto ria na tinoni za koleria na neqi za qari kole kuta uanadi za ria na tinoni pa kauraidi. ");
INSERT INTO ghn_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ba gamu za munake roiti vei zara. Goto na tinoni za nyoroguani ko mina tinoni poreveveina za mina kole nabulu betodigamu tu za gamu doru. ");
INSERT INTO ghn_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Beto gamu za na tinoni za nyorogua momoedigamu za aza za mi pinauzu tadigamu doru tu aza. ");
INSERT INTO ghn_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ura na Tuna na Tinoni za zake lame ko mi porenana nabulu za gua, goto za nabulu tugu beto za vani tu nana toa ko za pajuku aloria ria na kubo tinoni,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ego qari gore kamu pa Jeriko ria. Ko tonai mi taloi pa Jeriko za gua i Jisu beto ria nana sepele beto ko na minete lavata, za maka tinoni zake batabata na izongona i Batimiasi, na tuna marene i Timiasi, za korapa nyumu tepatepa poata pa keketai zona. ");
INSERT INTO ghn_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ko totonai za nongoroni aza i Jisu pa Nazareti za korapa rerege jola qari gua azae za podalai kuku votu, ari za gua vei, <<Jisu na Tuna i Devita! Mu roquroqu tokaniziu!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nari ria zoku tinoni qari tokea ko mi nogoto qari guni. Ba totonai za vaiolo zaea mutu za nana kukuku, ari za gua vei, <<Jisu na Tuna i Devita! Mu roquroqu tokaniziu!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nari za turu vanogoto i Jisu ko ari za gua vei, <<Mu kuku valamea,>> za gua. Ko qari kukua za na tinoni zake batabata ani, ari qari guni vei, <<Mu varene! Mu turu! Aza za korapa kukugo,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nari za teku vagore paleni za na poko za udeni, za soqolo turu ko za lame ti Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nari za paranga laoa i Jisu aza, ari za guni vei, <<Na za qu nyoroguani ao ko mana tokanigo ara?>> za guni. Nari ari za gua vei za na tinoni zake batabata ani, <<Rabi, ara qa nyoroguani ko ba batabata soga qa gua,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nari ari za guni vei i Jisu aza, <<Mu lao, na mua rangerange za tori salanigo tu ao,>> za guni. Pa totozo tugu aza za boka dogodogoro soga aza ko za somana tutianana i Jisu pa zona. ");
INSERT INTO ghn_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Totonai qari tata pa Jerusalema ria ko qari kamu pa Betipezi beto pa Betani pa Kubo pa Olive, za garunu lao momoedi i Jisu ari kori nana sepele, ");
INSERT INTO ghn_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ari za gudi vei, <<Mu lao pa guguzu maka karovona pa moemiu nari. Ko aza tugu muna bola lao za pala muna batia za maka dongiki koregana na tapiko vaturu kolena aza oqoro zaea tugu maka tinoni aza. Mu ruvatia aza ko muna toka lameni. ");
INSERT INTO ghn_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Vei mari nanazagamu kaki tinoni, <Ae za vei gamu korapa tu roiti vei zara?> mari gudigamu, za ari muna oe veidi, <Na Bangara za nyoroguani mae beto nake zovaina mina vamule lamea za gua,> muna gudi,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ego ko qari taloi lao ari kori ko qari batia za na dongiki koregana na tapiko vaturu kolena pa peguruna na atakamana pa keketai zona, ko qari lao ruvatia. ");
INSERT INTO ghn_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nari za qari paranga ria kaki tinoni qari suvere tata ketakoi, ari qari gua vei, <<Na za gamu korapa roitini? Ae za vei ko gamu korapa tu ruvatia na dongiki zana?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nari za qari pojai ari kori za aza vei za poja veidi i Jisu. Nari za qari vamalumu vadi. ");
INSERT INTO ghn_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ko qari toka vakamuni ti Jisu, ko qari lovaza vakeni na poko za na pokotona na dongiki, beto za zae i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Zoku jola ria na tinoni qari lovazaria pa zona za na dia poko, goto ria kaki qari kaele teku equru suvege ko qari lovazadi pa zona. ");
INSERT INTO ghn_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Beto za ria na tinoni qari rerege momoe lao beto qari tuti pa liguligu za qari kukuku, <<Aroia! Za tamana aza za lame pa izongona na Bangara! ");
INSERT INTO ghn_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Za tamana za na binangara tana tamada i Devita. Aroia pa nulu vavagalo,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ego ko za kamu pa Jerusalema aza ko za lao luge pa kakabarena na zelepade. Ko za kole dogoro varilivutaidi aza za doru zakazava ketakoi, ba za tori gore tu za na veluvelu ko za votu laonana pa Betani aza beto ari ka manogori nana sepele. ");
INSERT INTO ghn_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ego ko za rane na kota qari taloi koko lame vei pa Betani, za vaia na burana i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tonai tu za korapa lamelamenana pa zona azae za batia za maka suvege piqi za mota jola na equruna, ko za lao dogoria palu kolenana na vuana za gua. Ba tonai za lao kamua za kepore za maka vuana bi batia goto na galegale equruna gu ura za oqoro kamua nana totozo vua. ");
INSERT INTO ghn_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nari ari za guni i Jisu za na suvege piqi aza, <<Kepore tugu maka tinoni mi gania na vuamu ao!>> za guni aza. Ko qari nongoriadia tugu ria nana sepele za na parangana i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ego tonai qari kamu pa Jerusalema nari za luge lao pa kakabarena na zelepade i Jisu ko za podalai adu votuvotudi ria qari korapa vavai beto ria qari vavaidi na zakazava pa kakabarena na zelepade, beto za peluku vaopo paledi aza ria na tevolo tadiria qari sogasoga poata karovodi beto ria na nyumunyumudi tadiria na tinoni qari kole vavaidi na kuru vavavuidi ");
INSERT INTO ghn_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","beto za suquturia ko kepore maka tinoni bi pogozo varikarovaini maka za pa kori uquna na kakabarena na zelepade. ");
INSERT INTO ghn_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Beto za kole varivagigalai, ari za gudi vei, <<Gamuke gilagilai tu gamu za aza vei za pojai na Tamaza za takuti pa Kutikuti Tabuna? <Na ruma taqu za mina tavaizongo na ruma varavarana tadiria doru puku tinoni,> za gua! Ba gamu gamu roiti veini tu na bevi ovovona tadiria na tinoni raja ikikodi,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ko tonai qari nongoroni ria na kuta iama beto ria qari varivagigalaini na Vavanau za vei zara i Jisu, za qari podalai nyaqonyaqo zona golomona ko mari vaukea aza qari gua. Ba qari matagutuni aza, ura doruna na tinoni za qari gabarani za nana varivagigalai. ");
INSERT INTO ghn_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ego totonai za gore na veluvelu nari za qari votu lao pa peguruna na guguzu i Jisu beto ko ria nana sepele. ");
INSERT INTO ghn_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ego totonai qari rerege jola na volavolaza za qari batia ria za na suvege piqi za tori malei uke tu, za podalai tu pa batuna ko za gore tu kamu pa bagerena. ");
INSERT INTO ghn_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nari za roquroqu kamua i Pita za na veveina na suvege piqi ani ko ari za guni vei i Jisu, <<Rabi, dogoro! Na suvege piqi qu leveni ao za tori ukenana tu!>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nari za paranga laoria i Jisu ria, ari za gudi vei, <<Mu rangea na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ma poja zozotodigamu ara gamu: na tinoni za paranga laoa za na kubo ani, <Mu tajopu ko mu gona laonigo makamu pa ivere,> za gua, beto zake orirabeke pa bulona goto za vazozotoa gu za aza vei za pojai za mina gore votu tugu za gua aza, nari za pala mina gore votu vei tugu za pojai aza. ");
INSERT INTO ghn_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ko za vei aza za ma pojadigamu: doru zakazava gamu varavara ko gamu tepai, za mu vazozoto za gamu tori tekua tu, beto za pala muna izongia tugu ao aza. ");
INSERT INTO ghn_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ko totonai muna turu varavara za mu taleozoni za na sela gamu puku tutini na goto tinoni, ko na Tamamiu pa noka ba mi taleozodigamu na miu sela za gamu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ego za kamu soga mule pa Jerusalema i Jisu beto ria nana sepele. Ko totonai za korapa rerege pa kakabarena na zelepade i Jisu, za qari varikamu lao tana ria na kuta iama beto ria qari varivagigalaini na Vavanau beto ria na tiolata matamata. ");
INSERT INTO ghn_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ko qari nananazia aza, ari qari gua vei, <<Ae neqi veveina za qu izongia ao ko qu roitidi na roiti veveidi zara? I zei za vanigo na neqi ko qu roitidi za ari?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nari ari za gudi vei i Jisu ria, <<Ego ara ba ma nanazadigamu mae maka nanaza ropi za gamu. Ko vei muna oeziu gamu za pala mana ule vadigamu ara za pana neqi ti zei qa roitidi ara ria na roiti ari. ");
INSERT INTO ghn_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Pae za koko lame vei za na neqi za izongia i Jone ko za paputaiso? Za lame vei tana Tamaza pa noka, ba na koko lame veina tadiria na tinoni gu? Mu oeziu moko,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nari qari kole varigua makadi, ari qari gua vei, <<Vei tana Tamaza pa noka tana gua gita nari za pala ari mina gua vei, <Ba ae za vei ko gamuke vazozotoa tu gamu i Jone,> pala mina gudigita. ");
INSERT INTO ghn_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Goto lao vei tana paranga za gita <Na lame veina tadiria na tinoni gu,> tana gua, za varivamatagutu za,>> qari gua. (Qari matagutudi ria na tinoni, ura doru tinoni za qari rovea i Jone zozoto za maka tinoni korokorotai qari gua). ");
INSERT INTO ghn_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ko ari gu qari oe veini i Jisu, <<Dai, gamike gilagilai gami za!>> qari gua. Nari ari za gudi vei i Jisu ria, <<Ego, ko vei za ara ba manake ule vadigamu tugu za pae qa teku neqi beto qa roitidi ara ria na zakazava ari,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ego za podalai vavakato pa vavakato vavapada tadiria i Jisu, ari za gua vei, <<Kolenana za maka tinoni za roitini maka inuma qurepi beto za bara varilivutaini. Za ruri kori vaoqili valolua aza za maka patu ketakoi mina tamuja teku za na kolona na qurepi, beto za vaturua aza za maka ruma gelegelena ketakoi mina takopu za na inuma qurepi. Beto za loi valao vadi ria kaki tinoni roiti ko qari roiti za pa inuma aza ko qari kopuni, beto za taloi keni pa maka guguzu zouna aza. ");
INSERT INTO ghn_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ego totonai za kamua za na totozo lokelokete nari za garunu vamulea na tinoni porenana inuma ani za maka nana pinauzu ko mi lao tadiria na tinoni kopu ko mi teku vani za na iana tonai mari lokelokete za gua. ");
INSERT INTO ghn_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ba qari lao tu ria na tinoni kopu ketakoi ko qari aru tamania za na pinauzu aza ko qari maja vitivitigi pale beto qari iju vamule galegale paleni. ");
INSERT INTO ghn_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nari za garunu laoni mule na tinoni porenana inuma ani za maka goto pinauzu. Ba qari lao mutugu ria na tinoni kopu ko qari maja vapalepaleka pale za na batuna beto qari vakea vikevikere pale. ");
INSERT INTO ghn_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ba za maka garunu laoni mutugu za maka goto pinauzu mule, ba tonai za qari vauke zozotoa aza. Ko na motadi ria za garunu laodi, ba zara tugu qari veidi, kaki qari piqoloria goto kaki qari vaukeria. ");
INSERT INTO ghn_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ego maka moqamoqazana gu za kole jola, aza tugu na tuna za roquroqu vitivitigia. Ko liguligu betobeto, za garunu laoni aza tadiria qari kopu inuma za na tuna ani ura ari za roquroqu vei aza, <Na tuqu zozoto gu ara ani, ko pala aza mari pangagani,> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ba totonai za ria na tinoni kopu inuma za ari qari variparanga vei, <Aza pala mina izongo vakarovoria na izizongo tana tamana ani! Mae, lame! Aria ko ta vai vauke pale aza, ko na izizongo tana tamana za tana teku vakarovoria nada gita!> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ko qari aru tamania ko qari vauke paleni, beto qari gona votu paleni pa peguruna na inuma za na kobukobu tinina aza. ");
INSERT INTO ghn_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ko zara za vei nari za na za mina roitini za na bangara porenana inuma ani? Pala ari gu mina roiti vei aza: mina kamu aza, ko mina vai vauke beto paledi ria na tinoni kopu inuma beto za mina vakarovo lao vadi mule ria kaki goto tinoni kopu za nana inuma qurepi ani. ");
INSERT INTO ghn_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ae vei gamu oqoro tugu tiro vakabekaberia gamu za aza za tapoja pa Kutikuti Tabuna? Ari za gua vei aza, <Aza tugu na patu qari kilu pale ria na tinoni vavaturu ruma, aza tugu za na kuta patu vizovizo. ");
INSERT INTO ghn_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Na roiti tana Bangara ani ko za varivagabara jola pa nada dogodogoro!> za gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ko qari gilagilai ria na kuta iama, na tinoni varivagigalai vavanau beto boko tiolata lavalavata za na vavakato vavapada ani za juturia gu ria qari gua, ko qari nyaqoni zona ko mari aru tamania qari gua. Ba qari matagutuni ria za na minete tinoni ko qari loia i Jisu ko qari kenidia gu. ");
INSERT INTO ghn_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ego ria kaki Parese beto ria qari jukajukai i Herodi za qari tagarunu lao ti Jisu ko mari vagonai pa kaki paranga aza qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ko qari lame tana ria ko ari qari guni vei aza, <<Tinoni varivagigalai, gami gilagilaimami gami za qu zotomua gu ao, beto kepore za maka tinoni qu matagutuni ao. Beto za kepore veveina tamu za na tuturuna tana tinoni, goto qu varivagigalaini gu ao za na zona zozotona tana Tamaza. Ae vei, na tavamalumuna tugu pana Vavanau za mina tatabara lao tana bangara Siza za na takisi, ba dai? Ko mami tabaria tugu gami za na mami takisi, ba mamike pavu tabaria?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ba za tori bati poai tu i Jisu za na dia sekeseke, ko ari za gudi vei, <<Ae za vei ko gamu korapa nyorogua vagonaziu ara za gamu? Valamea maka poata siliva ko ma dogoria ko,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ko tonai qari pogozo laoni za maka nari ari za gudi vei, <<I zei na izumatana beto na izongona za pa poata ani?>> za gudi. Nari za ari qari guni vei aza, <<Na bangara Siza,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nari za paranga i Jisu, <<Ego mu vani i Siza aza ti Siza, beto mu vani na Tamaza aza tana Tamaza,>> za gudi. Ko qari gabara ria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ego qari lame ti Jisu ria na Sadusisi, ria na tinoni qarike vazozotoa na turumule pa uke, ko qari nanazia, ari qari guni vei, ");
INSERT INTO ghn_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","<<Tinoni varivagigalai, za kuti vakole vadigita i Mosese gita za vei mina uke loi paleni maka tinoni za na maqotana ba bi kepore na tuna, za mina elava sogai na taina marene za na naboko ani ko mina vapore vani na tuna vuana za na tugana za tori uke tu. ");
INSERT INTO ghn_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ko koledia ari ka vitu tamatazi marene. Na tugadi pa moa za elavia za maka reko ba kepore na tuna vuana za na marene aza beto za ukenana. ");
INSERT INTO ghn_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ego ko za teku elavia na tuti vinaori za na naboko aza, ba kepore mutugu na tuna vuana beto za uke mutugu aza. Ko na taidi marene vinaue ba za vei mutugu. ");
INSERT INTO ghn_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ko ari ka vitu tamatazi doru za qari elavia za na reko nabonaboko aza, ba kepore beto tugu na tudi vuadi. Pa liguna qari uke beto ari ka vitu doru ari, beto za uke za na reko nabonaboko aza. ");
INSERT INTO ghn_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ego ko pa rane turumule tonai mari turu mule ria na tinoni za pala i zei na maqotana za na reko ani? Ura ari ka vitu doru qari elavia aza,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nari ari za gudi vei i Jisu ria, <<Gamu sela za gamu! Ura gamuke gilagilai gamu za na Kutikuti Tabuna beto na neqi tana Tamaza! ");
INSERT INTO ghn_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ura tonai mari turu mule pa uke ria qari tori uke tu, za pala marike varielava lao lame ria na marene na reko, goto pala mari suvere vei gu ria na mateana pa noka za ria. ");
INSERT INTO ghn_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na veveidi ria qari turu mule pa uke za gamu oqoro tu tiro vakaberia gamu pa buka za kutia i Mosese? Pana ia ketakoi za pojai na veveina na tokutoku toana za vuruvurungu, ketakoi za paranga ti Mosese za na Tamaza, ari za guni vei, <Ara za na Tamaza ti Ebarahami, na Tamaza ti Aisake, beto na Tamaza ti Jekopi,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ko aza za nake Tamaza tadiria na tinoni ukedi, goto tadiria tu na tinoni toadi. Ko gamu sela za gamu!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ego maka tinoni za varivagigalaini na Vavanau za lame ko za nongororia tugu aza ria na zakazava qari variguani ria. Ko tonai za dogoria aza za oe valeanaria i Jisu ria na Sadusisi, nari za nanazia aza, ari za gua vei, <<Ae garunu za za momoe joladi ria doru?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nari za oe lao i Jisu, ari za guni vei, <<Na garunu za momoe za ani, <Vainongoro, gamu na tinoni Izireli! Na Bangara na nada Tamaza, na Bangara za maka moqamoqazana gu. ");
INSERT INTO ghn_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ko mu roquroqua na Bangara na mua Tamaza pa doruna bulomu, pa doruna mua toa, pa doruna roqumu, beto pa doruna mua neqi,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na vinaori garunu za ani, <Mu roquroqua na goto tavitimu aza vei qu roquroqu veinigo makamu,> za gua. Kepore za maka garunu za poreveveina joladi kori garunu ari,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tonai za paranga lao ti Jisu za na tinoni za varivagigalaini na Vavanau, ari za gua vei, <<Vavagua, tinoni varivagigalai! Qu zotomua gu za aza vei qu pojai maka moqamoqazana gu za na Tamaza, ko kepore za maka za vinaoria aza. ");
INSERT INTO ghn_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Beto ko na tinoni za mina roquroqua na Tamaza pa doruna bulona, pa doruna nana gigalai, beto pa doruna nana neqi, beto mina roqua na goto tavitina vei za roquroqu veini makana. Mina tutiria na tinoni za kori garunu ari, za leana jolani mina valaoa na nana varivana beto nana vavavui tana Tamaza,>> za gua za na tinoni ani. ");
INSERT INTO ghn_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ko tonai za nongoria i Jisu na tuvizina za na oe tana tinoni ani nari za ari za guni vei, <<Ao za quke zou pa binangara tana Tamaza,>> za guni. Ko pa liguna za paranga vei zara i Jisu qari pangaga nanazia mule ria aza. ");
INSERT INTO ghn_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ego totonai za kole varivagigalai pa leo kakabarena na zelepade i Jisu za ari za paranga vei, <<Ae za vei ko qari varivagigalaini tu ria qari varivagigalaini na Vavanau za na Karisito za na tuna i Devita qari gua? ");
INSERT INTO ghn_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","I Devita makana za titai na Ongongu Tabuna za ari tu za paranga vei, <Za paranga za na Tamaza tana qua Bangara: Mu nyumu pani pa kale matuaqu, ko koi vei tu mana tete vakilasaria ara ria na mua kana, za gua,> za gua i Devita. ");
INSERT INTO ghn_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Makana i Devita za gigalani na <Bangara> tu aza, ko ae za vei mina boka tuna tu i Devita za na Karisito za vei?>> za gua i Jisu. Ko qari qerani ria na tinoni i Jisu tonai qari kole vainongoro. ");
INSERT INTO ghn_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ko pa nana varivagigalai za ari za paranga vei i Jisu, <<Mu balaudi ria qari varivagigalaini na Vavanau, qari nyorogua pokopoko vakakaza beto qari lekoleko ko mari gozoro qeraqeradi ria na tinoni pa ia makemaketina qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Beto ko qari mijataria na nyumunyumuna poreveveidi pa leona na ruma varivarikamuna beto na nyumunyumuna tadiria na tinoni lavalavata pa ivata vavolo. ");
INSERT INTO ghn_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Qari ragaragata vakenidi na dia zakazava ria na nabonaboko, beto qari varavara vakakaza ko mari tabata tadiria na tinoni qari gua. Ba na vinakilasa mari tekua ria za mina lavatana jola,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ego tonai za korapa nyumu nana pa moena na vavakoleni poatana pa kakabarena na zelepade i Jisu, za dogoro lao za batiria aza ria na minete tinoni qari okoto lao loiria na dia poata varivana. Ko ria kubo tinoni izizongo za qari okoto kole lao loloiria na dia baeke poata. ");
INSERT INTO ghn_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Beto za tuti lao za maka reko nabonaboko golagolabana ko za lao loia za kori poata kopa peki moqamoqazana, na padadi za maka pene gu. ");
INSERT INTO ghn_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pana totozo aza za kuku varikamudi i Jisu ria nana sepele ko ari za gudi vei, <<Ma poja zozotodigamu ara gamu: aza za loia na nabonaboko golagolabana ani za zoku jolani aza qari loia pa loloi poatana ria doru tinoni izizongo. ");
INSERT INTO ghn_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ura ria doru za qari teku gu pa dia zoku izizongo za qari valao, goto na nabonaboko ani za aza tugu doruna za izongia pa nana toa golaba ko bi toani za valao betoa gu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tonai za korapa taloi votu pa kakabarena na zelepade i Jisu, za maka ria nana sepele za paranga, <<Tinoni varivagigalai, dogoro! Na beko patu lavalavata beto na rumaruma batabata lea!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nari ari za guni vei i Jisu aza, <<Qu batiria doru ruma lavalavata ari? Kepore zozoto maka patu qari kole varivariake topare pani za mina kole jola, goto doruna za pala ria na tinoni mari qovara betoria,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ego ko tonai za korapa nyumu nana pa kubo pa Olive ko za bata lao vei pa ia tana zelepade i Jisu, za qari peki nanaza golomia ari Pita, i Jekopi, i Jone, beto i Aduru aza, ari qari guni vei, ");
INSERT INTO ghn_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","<<Mu ule vadigami! Pa viza za mari gore votu ari, beto na za na vinagilagila beto mari raja ria doru zakazava qu koni pojaria ao zara?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nari za paranga laoria i Jisu ria, <<Mu suvere vabalau, ko marike toka vapirugamu ria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kubo ria na tinoni pala mari lame pana izongoqu ara ko mari paranga vei ari, <Ara za aza,> mari gua, ko mari toka vapiru paledi ria na zoku tinoni. ");
INSERT INTO ghn_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tonai muna nongorodi gamu ria na varipera beto na vavakatodi na varipera, za muke matagutudi ria. Ura pala mari pidoko lame tugu ria na zakazava ari ba za oqoro kamua za na vinabetona. ");
INSERT INTO ghn_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Pala maka puku tinoni mina turu talea maka goto puku tinoni, beto maka binangara mina turu talea maka goto binangara. Mina nunu zoku kota beto pala mina raja na songe. Na zakazava ari za vei na podapodalaina na vitivitigi teku koburu. ");
INSERT INTO ghn_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ko gamu mu dogoro kopudigamu makamiu. Ura pala mari teku valaogamu pa varikamu tadiria qari varivarituti beto ko mari piqopiqologamu pana ruma varivarikamuna. Beto pala muna turu pa moedi ria na qavuna beto ko ria na bangabangara pana veveina na izongoqu ara, ko muna vavakato vadi za na veveina na nongoro leana. ");
INSERT INTO ghn_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ko momoe na nongoro leana za mina tatarae mae tu pana tadiria doru puku tinoni. ");
INSERT INTO ghn_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ko tonai mari toka laodigamu pa ia varivaritutina za gamu, za munake takulangani na za muna pojai keta mu gua. Aza tugu na paranga muna taiani na totozo aza za muna poja votuni. Ura nake gamu za muna paranga, goto na Ongu Tabuna tu. ");
INSERT INTO ghn_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Na totozo aza ari kori tamatazi marene ba mari varitoka valao tugu pa uke, ria na tamadi ba mari veidi tugu ria na tudi, beto ria na koburu za mari raja vaukeria ria na tamadi na tinadi. ");
INSERT INTO ghn_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Beto gamu za pana veveiqu ara za pala marike tavaraguadigamu doru tinoni. Ba na tinoni mina aru tamana vamauru ko mina kamua na vinabetona za mina taalo,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","<<Ba tonai muna batia gamu za na beku tana tamaza sekeseke mina turu pa ia madina pa zelepade ketakoi za tabunana mina lao (gamu gamu tiroa ani za mu vakoinonoa na ginuana ani!), nari za ria na tinoni qari suvere pa Jiudia za tonai mari uku zagereria ria na okokoto kubo ketakoi. ");
INSERT INTO ghn_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Aza na tinoni za korapa suvere pa arena nana ruma za mike mule gore qaqiriria nana zakazava pa leona nana ruma. ");
INSERT INTO ghn_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na tinoni za korapa pa inuma za mike mule tekuria nana poko pa nana ruma. ");
INSERT INTO ghn_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Na totozo takulangadi jola tadiria na reko qari bogata beto ria qari izongo melalu ria na rane ria! ");
INSERT INTO ghn_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mu varavara tepatepa lao tana Tamaza, ko na zakazava ari za marike raja lame pa totozo za lomozo vitivitigi na kota. ");
INSERT INTO ghn_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ura na tapata mari gozororia ria na tinoni pana rane ria za mina lavata joladi doru tapata qari jola, podalai tu totonai za vapodakia na kasia abana na Tamaza ko za kamua koviria ko pa liguna aza za kepore mule za maka zakazava veveina mina raja ligu. ");
INSERT INTO ghn_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Vei bike kobu vapapakaria na Bangara ria na rane ria, nari za kepore za maka tinoni bi toa. Goto koko vei za roquria aza ria na tinoni tamijatadi za tori mijataria tu aza, azae za vapapakaria na Bangara za ria na rane ria. ");
INSERT INTO ghn_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ko vei bi paranga gamu maka tinoni, <Dogoro! Ani za na Karisito!> babi <Dogoro! Zana aza!> bi gua, za banabana vazozotoa aza. ");
INSERT INTO ghn_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ura pala mari bolabola kamu ria na karisito sekesekedi beto na tinoni korokorotai sekesekedi. Pala mari roiti votudi ria na dia vinagilagila beto na roiti varivagabaradi, ko vei mari boka za pala mari toka vapiruria tugu ria na tinoni tamijatadi tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ko gamu za mu suvere vabalau! Qa tori poja vakoledigamu tu ara ria doru zakazava ari tonai qari oqoro tu gore votu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","<<Ba pana rane ria totonai mina kamua na totozo tapata, mina rodomo za na tapo beto na popu ba minake kabere; ");
INSERT INTO ghn_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","mari lotu lagere za ria na seru pa noka beto ria na neqi pa noka za mari tajou vakanoko. ");
INSERT INTO ghn_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Beto mari batia ria za na Tuna na Tinoni mina lame vei pa lei tavitia na neqi beto na kabere lavata. ");
INSERT INTO ghn_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ego beto za pala mina garunu laodi aza pa made uquna na kasia guguzu ria na mateana ko mari varikamudi ria nana tinoni tamijatadi, podalai pa maka uquna na kasia guguzu ko mari lao vaokotia pa vinabetona,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","<<Mu teku vinakabere pa suvege piqi. Tonai mina takelai za na equruna beto mari podalai ijoko ligu za na boko kaena, nari za gamu gilagilai gamu za tata lame za na totozo mangini. ");
INSERT INTO ghn_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ko gamu ba vei tugu aza. Tonai muna batiria mari gore votu ria na zakazava qa pojadigamu ara, za mu gilagilai za tata vitivitigi gu pa atakamana aza. ");
INSERT INTO ghn_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ma poja zozotodigamu ara gamu: tonai mari oqoro uke beto ria na zazae tinoni koviria za pala mari gore votu za na zakazava ari. ");
INSERT INTO ghn_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Na noka beto na pezo za mari na maragutu, ba na paranga taqu za marike izongo maragutu podeke,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","<<Goto na veveina na rane babi na totozo aza za kepore maka tinoni za gilagilai. Ria na mateana pa noka ba qarike gilagilai, na Tuna ba zake gilagilai tugu. Makana gu na Tamana za gilagilai. ");
INSERT INTO ghn_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mu suvere vabalau beto mu suvere kopu, ura gamuke gilagilai gamu za na totozo. ");
INSERT INTO ghn_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Maka moqaza podeke vei gu maka tinoni za keni lekolekonana pa maka guguzu zouna. Tonai za oqoro taloi keni nari za okoto iadi na roiti ria nana nabulu ko mari okokoto roiti za gua. Beto za poja vakoleni tugu za na tinoni za kopu pa atakamana ko mina suvere gelegeleni za na mule lamena za guni. ");
INSERT INTO ghn_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ko za vei za gamu ba mu suvere gelegele, ura gamuke gilagilai gamu za na totozo mina mule lame na bangarana na ruma. Zake tagilagila za bi lame pana veluvelu za, pana korapa bongi za, babi pana kiu kokorako za, babi na volavolaza lea. ");
INSERT INTO ghn_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Keta mi lame kamu vasiboro, nari mi bati gamu mu korapa puta mumagemiu za gamu. ");
INSERT INTO ghn_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ko aza tugu qa korapa poja veidigamu gamu ari, za qa poja veidi tugu ria doru: mu suvere gelegele,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ego kori rane za kole beto mina kamua za na vavolo Alokata beto na vavolo Bereti Nake Kovuruna. Ko ria na kuta iama beto ria qari varivagigalaini na Vavanau za qari kole nyaqonyaqoni zona ko mari aru tamania ko mari vaukea i Jisu qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ari qari kole paraparanga vei zana, <<Nake totozo vavolo Alokata, tana arua, keta ta kole variperadi ria na tinoni,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ego za korapa pa Betani i Jisu ko za korapa suvere pa ruma ti Saimone, aza na tinoni za rajai mae na poqupoqu perangaina. Ko tonai za korapa tekuteku i Jisu za pogozo kamuni maka reko za maka jagi patu alabasita za pugelia na oela liosona, na oela aza za taroiti pa suvege nadi ko za zae jola na vaina. Za lobitia aza za na jagi ani beto za vuvani pana batuna i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ba kaki ria qari suvere ketakoi za qari kole variparaparanga tagigiri makadi, ari qari gua vei, <<Koi, ae za vei ko za korapa tavuva vikevikere goboro vei zara za na oela vavaguana jola zana? ");
INSERT INTO ghn_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bi boka vavaini ko bi tekuni jolani kue gogoto poata siliva za na oela ani beto ko bi vadi ria na tinoni golabadi za na poata!>> qari gua. Ko qari tagigiri vikevikereni za na reko aza. ");
INSERT INTO ghn_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ba za paranga i Jisu, <<Tari tu, loia! Ae za vei ko gamu korapa vatapatia? Maka roiti leana tugu za korapa roitini aza taqu. ");
INSERT INTO ghn_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ura ria na tinoni golaba varivasevidi za pala mari suvere tavitigamu doru totozo, ko tonai muna nyorogua tokadi za muna boka tokadi gu. Goto ara za manake suvere tavitigamu doru totozo. ");
INSERT INTO ghn_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Na reko ani za korapa roitini za aza vei za bokai. Za vuvani oela omomanga lea za na tiniqu ara, ko za varoquroqu momoeni na golomoqu ara. ");
INSERT INTO ghn_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ko ma poja zozotodigamu ara gamu: doru kota pa kasia guguzu mina tavavakato za na nongoro leleana ani za mina tavavakato tugu ko na varoquroquna na reko aza za na roiti za korapa roiti lameni aza pana taqu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ego i Jiudasi Isikarioti, maka ari ka manogori sepele, za taloi lao tadiria na kuta iama ko mina toka valao vadi aza i Jisu za gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ko totonai qari nongoria ria na parangana i Jiudasi za qari qera ko qari poja vakoleni ko pala mari vani na poata aza qari gua. Ko za podapodalai nyaqonyaqoa i Jiudasi za maka totozo leana tonai mina boka toka valao vadi i Jisu za gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ego pa rane momoena na vavolo Bereti Nake Kovuruna, totonai qari kubokuboloria ria na lami vavolo Alokata, za qari nanazia ria nana sepele i Jisu, ari qari gua vei, <<Pae za na ia qu nyoroguani ao, ko mami vatana vanigo za na tekutekuna vavolo Alokata?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nari za garunuria i Jisu ari kori nana sepele, ari za poja veidi, <<Mu lao pa guguzu lavata pa Jerusalema. Maka tinoni za korapa pogopogozianana maka bogu pie za pala mina gozorogamu. Muna tutia aza ");
INSERT INTO ghn_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ko ketakoi mina lao luge aza za muna parangia za na tinoni porenana ruma aza, ari muna guni vei, <Na mami Bangara za ari za gua vei, Pae za na lose ketakoi mana tekua na tekutekuna vavolo Alokata za ara beto ria na qua sepele? za gua,> muna guni. ");
INSERT INTO ghn_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ko aza pala mina ule vadigamu za maka lose lavata pa nulu za tori tavanaqiti vakole tu. Ketakoi za muna vatanani gamu za na tekutekuna tadigita,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ko tonai qari taloi keni ko qari lao kamu pa guguzu lavata ari kori nana sepele, za qari bati beto ria tugu vei za pojadi i Jisu, ko qari vatanai za na tekutekuna vavolo Alokata. ");
INSERT INTO ghn_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ko totonai za gore za na veluvelu, i Jisu za lame tavitiria ari ka manogori nana sepele ko qari lao varikamu ketakoi. ");
INSERT INTO ghn_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tonai qari varikamu ko qari korapa tekuteku, za paranga i Jisu, <<Ma poja zozotodigamu ara gamu: maka gamu gamu korapa tekuteku tavitiziu ara za pala mina gabala kanaziu ara,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tonai za qari mamata ria na sepele ko qari okoto nanaza makamakai i Jisu, ari qari gua vei, <<Ae vei, nake ara za qu guniziu ao?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nari za oe laoria i Jisu ria, <<Pala maka gu gamu ka manogori ari, aza za somana vavanoti bereti pa baolo tavitiziu ara. ");
INSERT INTO ghn_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Na Tuna na Tinoni za mina tavauke vei za tori pojai tu na Kutikuti Tabuna, ba mina gania na takulanga za na tinoni za gabala kanai na Tuna na Tinoni! Za leleana jola za bike pavu gu podo za na tinoni aza!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ego totonai qari korapa tekuteku ria, azae za tekua i Jisu za na bereti ko za manani beto za kipakipai ko za iadi ria na sepele, beto ari za gua vei, <<Pia tekua, ani za na tiniqu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Beto za tekua mule za na kapa vaini ko za paranga leana laoni tana Tamaza beto za vadi ko qari varibukuni ria doru. ");
INSERT INTO ghn_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Beto za paranga vei ari, <<Ani za na orunguqu ara za nyoa ko na vulazadi ria na zoku tinoni ko na vamauruna na taringutinguti. ");
INSERT INTO ghn_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ma poja zozotodigamu ara gamu: manake buku sogai ara za na vaini ani tinganai mina kamua na rane totonai mana bukua ara za na vaini korega pa binangara tana Tamaza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Beto qari kerani ria za maka kera, beto za qari taloi votu lao pa kubo pa Olive. ");
INSERT INTO ghn_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ego beto za parangaria i Jisu ria, <<Gamu doru za pala muna uku loi paleniziu ara, ura za paranga za na Kutikuti Tabuna, <Ara mana vaukea na sepati, ko mari okoto nyanyalia na kota ria na sipi,> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ba pa liguna mana turu mule pa uke ara, za mana lao momoe adonogamu pa Qalili,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nari za paranga lao pana tana i Pita, <<Goto ara za mari uku loi palenigo tu ria doru, ba ara za manake izongo loigo ao!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nari za paranga lao pana tana i Jisu, <<Pita, ma poja zozotonigo ara ao: ao za pala pa bongi tugu ani totonai mina oqoro kiu vinaori na kokorako za muna kilu paleniziu kue totozo ara ao,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ba za paranga vivivagana tugu i Pita, ari za gua vei, <<Ara vei mana uke tavitigo tugu ao ba manake izongo ozonigo tugu ao,>> za gua. Ko ria doru sepele ba qari paranga vei tugu zara. ");
INSERT INTO ghn_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ego totonai qari kamu ria pa maka ia na izongona pa Qetisemani, za ari za gudi vei i Jisu ria nana sepele, <<Mu suvere adono pani, goto ara ma lao varavara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Beto za tokaria gu ari Pita, i Jekopi, beto i Jone. Za tori podalai mamata na takulanga vitivitigi tu aza, ");
INSERT INTO ghn_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ko ari za gudi vei ari kue, <<Na takulanga pa buloqu za lavata jola ko mi vaukeziu za gua. Mu suvere pani ko mu suvere gelegele gamu,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Beto za rerege lao vazou iapeki i Jisu beto za opo gore pa pezo ko za varavara ko vei bi boka za bi tavarijo tu pana tana za na totozo vitigi ani za gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Beto ari za gua vei, <<Aba, Tamaqu. Kepore za maka zava za tapatigo ao. Mu varijo pale taqu za na totozo vitigi ani, ba nake aza vei qa nyoroguani ara za mi taroiti goto aza tu vei qu nyoroguani ao,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Totonai za beto varavara ko za mule lame nari za batiria qari korapa puta mumagedi tu, ko ari za guni vei i Pita, <<Saimone, qu korapa putagemu ao? Ae vei, quke boka zozoto tugu suvere gelegele maka aoa? ");
INSERT INTO ghn_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mu suvere gelegele beto mu varavara ko muke lotu pa toketoke. Na ongongu za malumu ba na tini za munyala,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Beto za maka gabala lao soga ko za varavara vei mutugu tonai za varavara momoe i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tonai za mule lame soga nari za batiria qari korapa mutugu puta mumagedi, ura za ngaolo vitivitigiria na nyoro puta. Ko qarike gilagilai na za mari boka paranga laoni pana tana aza. ");
INSERT INTO ghn_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tonai za mule lame na vinaue totozo, nari ari za gudi vei, <<Gamu korapa tugu puta minyere valeanamiu za gamu? Koviria za pada gu! Dogoro, za kamu gu za na totozo mina tavalao pa limadi ria na tinoni seladi za na Tuna na Tinoni. ");
INSERT INTO ghn_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Aria, turu ko ta lao gozororia. Dogoro! Za kamu gu ani za na tinoni za gabala kanaziu ara,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ego ko totonai tugu za korapa paraparanga vei zara i Jisu za bola gu i Jiudasi, aza maka ari ka manogori sepele. Za toka bolani aza za na puku minete tinoni qari pogozo benete varivarisobena beto na maja kubau. Ria na tinoni ari za na tagarunudi tadiria na kuta iama, ria qari varivagigalaini na Vavanau beto ko ria na tiolata matamata. ");
INSERT INTO ghn_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Maka vinagilagila za tori poja vakoledi tu i Jiudasi na tinoni za gabala kanai za ria na minete za tokaria, za ari za gudi vei, <<Aza na tinoni mana lao aoia na paparana ara za aza za na tinoni muna lame aru tamania ko muna toka kenini,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ko aza tugu za bola kamu i Jiudasi nari za rerege tuvizi lao gu za ti Jisu, ko za paranga, <<Rabi!>> za gua, beto za aoa na paparana. ");
INSERT INTO ghn_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Totonai tugu za qari lao ragata tekua ko qari aru tamania i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ba maka ria qari korapa turu ketakoi za saputu votuni za nana benete varivarisobena ko za maja teusu paleni za maka kale talingana na pinauzu tana kuta iama lavata. ");
INSERT INTO ghn_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nari za paranga i Jisu, ari za gudi vei, <<Na tinoni raja ikikoqu ara ko gamu pogozo tariniziu na benete varivarisobena beto na maja kubau ko muna teku aru tamanaziu? ");
INSERT INTO ghn_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Beko doru rane za qa kole gu suvere tavitigamu pa kakabarena na zelepade ko qa kole varivagigalai ba gamuke izongo aru tamanaziu gamu. Ba leana ko mi gore votu tugu za na Kutikuti Tabuna,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ego tonai za qari uku loi paleni ria doru sepele aza. ");
INSERT INTO ghn_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ego maka koburu marene korekoregana za pokopokoni maka tivitivi gu za somana tututia tugu i Jisu. Ko aza ba mari aru tamania tugu qari gua, ");
INSERT INTO ghn_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nari za uele vadi gu nana poko beto na gadogadona gu za oqai na taba. ");
INSERT INTO ghn_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ego ko qari toka laoni pana tana kuta iama lavata i Jisu, ko ria doru kuta iama, na tiolata matamata beto ria qari varivagigalaini na Vavanau za qari varikamu beto ketakoi. ");
INSERT INTO ghn_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ego i Pita za kole pekipeki tuti liguligu pa zouna tu ko za lao luge laonana pa sebesebe ruma tana kuta iama lavata. Ko ketakoi za lao nyumu varisomanai nana tadiria na nabulu kopu ko za davanganana pana keketai iku. ");
INSERT INTO ghn_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ko qari kole podepodeke nyaqo votuni ria na kuta iama beto ria doru tiolata pa kauniseli za vei bi kolenana maka vavakato vei mina boka uleni maka roiti ikikerena za roitini i Jisu ko mari boka vaukea i Jisu qari gua. Ba qarike boka batia kaki vavakato. ");
INSERT INTO ghn_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ura na mota joladi ria qari jutu tarini sekeseke i Jisu, ba na dia vavakato za qarike varivaritoto. ");
INSERT INTO ghn_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Beto qari soqolo turu ria kaki ko qari jutu tarini sekeseke i Jisu, ari qari gua vei, ");
INSERT INTO ghn_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","<<Gami nongoriamami za ari za paranga vei zana, <Ara mana jegara paleni za na ruma zelepade madina qari roitini ria na tinoni, beto pa liguna kue rane gu za mana vaturu sogai ara za maka aza nake ria na tinoni qari roitini,> za gua,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ba ria ba zake varivaritoto tugu za na dia vavakato. ");
INSERT INTO ghn_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ego beto za turu pa moedi ria doru za na kuta iama lavata ko za nanazia i Jisu, ari za guni vei, <<Ae za vei munake oe ao? Na za ria na vavakato qari korapa jutu tarinigo ria ari?>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ba zake vagala beto zake pojai tugu maka pakata paranga i Jisu. Nari za maka nanaza mule za na kuta iama lavata, ari za gua vei, <<Ao tugu za na Karisito, na Tuna na Tamaza tamanana?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Totonai za oe i Jisu, <<Ara tugu. Beto pala muna batia gamu za na Tuna na Tinoni mina nyumu nana pa kale matuana na Tamaza vivana jola beto pala muna batia mina lagere vei pana lei pa noka,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tonai za paranga vei zara i Jisu nari za bako rikata paleni na kuta iama lavata za nana poko, beto ari za gua vei, <<Na vavakato vinazozoto za mule za taqe korapa adonia gita? ");
INSERT INTO ghn_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Gamu tori nongoriamiu tugu gamu za za vamoroania na Tamaza za na tinoni ani. Ko na za za gua na miu roquroqu za gamu?>> za gua aza. Ko qari vaegoa gu ria doru za sela gu i Jisu ko za pada tugu ko mina tavauke qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Pana totozo tugu aza za ria kaki za qari podalai tue taria i Jisu, beto qari ude pikoni poko na izumatana beto qari piqolia beto za ari qari guni vei, <<Ego mu uleni moko za i zei za majago!>> qari guni. Beto za qari saputu tekua ria na nabulu kopu aza ko qari kole popoaria. ");
INSERT INTO ghn_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Totonai za korapa suverenana pa kakabarena pa kauruna na ruma i Pita, azae za rerege tata lao za maka nabulu reko tana kuta iama lavata. ");
INSERT INTO ghn_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ko tonai za batia aza i Pita za korapa davanganana, za dogoro taria beto za parangia, <<Ao tugu za maka qu somasomana tutia na tinoni Nazareti zana?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ba za kilu pale aza, ari za gua vei, <<Ara qake izongo vagilagilai beto qake vakaberia aza qu korapa pojai ao zana,>> za gua aza. Beto za peki rijo votu laonana pana atakamanana na kakabarena na ruma. ");
INSERT INTO ghn_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ego za bati sogai mutugu na nabulu reko ketakoi aza, ko za ule vadi ria qari kole turu tavitia aza ketakoi, ari za gudi vei, <<Aza tugu za maka ria qari tututi tana!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ba za kilu pale mutugu aza. Ba za oqoro izongo zovai za ria mule na tinoni qari kole turu tavitia ketakoi za qari parangia mule aza, ari qari gua vei, <<Ao zozoto tugu za maka ria! Ura na tinoni Qalili ao!>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ba tonai za maulu tarini makana na leveleve i Pita, ari za gua vei, <<Qake izongo gilagila podekia tugu ara za na tinoni gamu korapa pojai gamu zana!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Totonai tugu aza za kiu vinaori gu za na kokorako. Nari za roquroqu kamua i Pita za aza za paranga veini i Jisu tonai ari za guni vei, <<Mina oqoro kiu vinaori na kokorako za pala muna kilu paleniziu ara kue totozo ao,>> za guni. Ko tonai tugu za takakoto gu ko za vodangia na lukana i Pita. ");
INSERT INTO ghn_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ego na volavolaza rorodomo za qari siqasiqarai varikamu ria na kuta iama, na tiolata matamata, ria qari varivagigalaini na Vavanau beto ria doru tiolata pa kauniseli, ko qari makarai variroveni za na vaukena i Jisu. Beto qari piu varikamudi za na limana i Jisu ko qari toka laoni ti Paelati aza. ");
INSERT INTO ghn_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nari za nanazia i Paelati aza, <<Ao tugu za na bangara tadiria na Jiu?>> za guni. Nari za oe lao i Jisu, <<E, aza tugu qu pojai ao zana!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Qari kole jutu tarini zoku zakazava ikikeredi ria na kuta iama i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Beto za maka nanazia mule i Paelati aza, <<Ae za vei ko quke oe tu ao? Dogoro! Tori kubo zakazava ikikeredi tu za qu tajutuni ao!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ba zake pojai tugu maka za i Jisu, ko za gabara vitivitigi i Paelati. ");
INSERT INTO ghn_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ego tori nana tutina tu i Paelati za doru totozo pa vavolo Alokata za ruvatia za maka tinoni tapiuna aza qari nyoroguani ria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ko pana totozo aza za maka tinoni na izongona i Barabasi za somana tapiu tavitiria ria qari varipera lao tana qavuna beto qari vaitinoni. ");
INSERT INTO ghn_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ko qari zae varikamu ti Paelati ria na minete tinoni ko qari tepai aza ko mi vamalumu vadi aza vei za roroitidi aza pa doru vavolo Alokata qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nari za oe lao i Paelati, ari za gua vei, <<Ae vei, gamu nyoroguaniziu ko ma ruvata vadigamu za na bangara tadiria na Jiu?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ura za tori gilagila valeanianana tu i Paelati za qari konokonoa gu ria na kuta iama i Jisu, ko za vei za qari loi lameni tana. ");
INSERT INTO ghn_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ba qari soriria ria na kuta iama ria na minete tinoni, ko i Barabasi tu za mi ruvata vadi qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ba za maka nanaza soga lao mule tadiria i Paelati, ari za gua vei, <<Ko ae tu mana aru veini ara i Jisu, aza gamu gigalani na bangara tadiria na Jiu gamu?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nari qari maka velavela mule ria, <<Vaukea pa korosi aza!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ba za nanaza soga mule i Paelati, ari za gua vei, <<Ba na sela za za roitini aza?>> za gua. Ba tonai za qari kuku velavela viviva tugu ria na minete tinoni, <<Vaukea pa korosi aza!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ko za nyorogua vaqeraria i Paelati ria na tinoni ko za ruvata valao vadi gu i Barabasi. Goto i Jisu za loi lao vadi ria na solodia ko mari iriruni na varivariiriruna beto za mari keni vaukea pa korosi za gua. ");
INSERT INTO ghn_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ego ko qari toka lugeni pa leo kakabarena na ruma tana qavuna ria na solodia i Jisu, beto za qari kuku varikamudi ria na minete solodia doruna. ");
INSERT INTO ghn_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ko qari vazaeni na poko kala davala beto qari viria maka vasuvasu varivarioka za vei na vasuvasu bangara beto qari sobani pa batuna. ");
INSERT INTO ghn_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Beto za qari kole vavabangara sekeseke leleonidia ria aza, beto ko ari qari guni vei, <<Mu toa vakakazamua tu ao na bangara tadiria na Jiu!>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Beto za qari okoto kole vavagore tarini kolu za na batuna, qari tutue taria, beto qari nyumunyumu sori tungutungu vavatarazae leleonidia ria aza. ");
INSERT INTO ghn_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pa liguna qari beto ngangangulu veini zara aza, za qari vagore paleni ria za na poko kala davala qari vazae momoeni ko qari vazae liguni na nana poko makana, beto za qari toka votuni ko mari lao vaukea pa korosi qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ego tonai qari korapa lalaodia pa zona za qari gozoria za maka tinoni pa Saerini, na izongona i Saimone, na tamadi ari Alekezada i Ruposi. Na koko lame veina pa nana guguzu ko na koni kamuna tugu pa Jerusalema aza. Qari garunu tokatokai ria na solodia aza ko za pogozia za na korosi ti Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Beto za qari titai i Jisu ko qari lao pana maka ia na izongona pa Qoloqota, na ginuana za na Kota Batu Tomete. ");
INSERT INTO ghn_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ketakoi za qari vani na vaini pazana aza qari qaliri varisomanaini na moa, ba za dainana bukua. ");
INSERT INTO ghn_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Beto za qari patani pa korosi aza, beto za qari kole gonani na patu mijamijata ko mi tagilagila za i zei mina tekua za na okokoto rikarikatana na poko tana qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ego ko na sia koloko volavolaza tu za qari patani pa korosi i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ko na paranga za tajutuni aza za ari za gua vei: NA BANGARA TADIRIA NA JIU. ");
INSERT INTO ghn_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Beto qari vauke tavitini i Jisu ari kori tinoni raja ikikodi, maka pa kale matuana beto maka pa kale merina. ");
INSERT INTO ghn_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ko ria na tinoni qari rerege jola za qari poja vikevikeria beto qari begobegolodi na batudi, <<Aha! Ao za muna jegaria na zelepade madina beto kue rane gu muna vaturu sogai qu gua! ");
INSERT INTO ghn_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ego mu alo mulenigo tu makamu, mu tavizu lageremua tu pa korosi!>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ko ria na kuta iama beto ria qari varivagigalaini na Vavanau ba qari kole tugu vavagoreni qera, ari qari gua vei, <<Ria na goto tinoni za aloria, goto makana zake boka alo muleni! ");
INSERT INTO ghn_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Koviria za mi gore lagere tu pa korosi za na Karisito, na bangara tadiria na tinoni Izireli, ko gita ba ta batia ko ta vazozotoa,>> qari gua. Ari kori qari tavauke tavitini aza ba qari paranga ngangangulia tugu aza. ");
INSERT INTO ghn_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ego totonai za kamua na korapa rane za rodomo beto za doruna na guguzu, tinganai ko za kamua tu kue koloko goregore tapo. ");
INSERT INTO ghn_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tonai za kamu kue koloko nari za lukana uui i Jisu, ari za gua vei, <<Eloi, Eloi, lama sabakatani?>> za gua (Na ginuana za ari za gua vei, <<Qua Tamaza, qua Tamaza, ae za vei ko qu loi paleniziu tu?>> za gua.). ");
INSERT INTO ghn_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ria kaki qari turu tata ketakoi za qari nongoria, ko ari qari gua vei, <<Dogoro! Za korapa kukua i Elaija zana!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tonai za maka ria za pogozo abutu laoni za maka puqapuqana ko za vatubuluni na vaini, ko za sunini pa uquna maka kolu, beto za alaka zaeni ti Jisu ko mi vabukuni za gua. Beto za paranga, <<Loia ko! Ta dogodogoronada. Keta pu kamu vizu vagorea i Elaija,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Beto za vagorea maka uui lavata i Jisu, beto za loia na singo. ");
INSERT INTO ghn_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tonai za tarikataori za na poko tobana na zelepade madina, za podalai tarikata pa nulu ko za gore kamu pa pezo. ");
INSERT INTO ghn_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na tinoni matamata gogoto za korapa tugu turunana pa moena na korosi ko za batianana za vei beto za loia na singo i Jisu, ko za paranga, <<Zozoto! Na tinoni ani za na Tuna na Tamaza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ego qari korapa tugu turudia pa zouna ketakoi ria kaki reko, ko qari kole dogodogoro laodia. Qari kole turu varisomanaidia tugu ketakoi ari Mere Magadalene, i Salome, beto i Mere na tinadi ari Jekopi na tinoni peki beto i Josesi. ");
INSERT INTO ghn_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tonai za suvesuvere pa Qalili i Jisu za ria na reko ari za qari tututia aza beto qari tokatokani tugu vei. Ria kaki gotogoto reko mutugu qari makarai tutia zae i Jisu pa Jerusalema za qari korapa tugu turudia ketakoi. ");
INSERT INTO ghn_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ego za tori gore tu za na veluvelu, ko na rane Vatana aza beto za mina kamua za na rane Minyere, ");
INSERT INTO ghn_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ko i Josepa pa Arimatia za turu varene ko za lao vatuvizi ti Paelati ko za tepai za na kobukobu tinina i Jisu (I Josepa za maka tinoni tapangagana pa kauniseli tadiria na Jiu, beto makana ba za korapa tugu adonia za na lamena na binangara tana Tamaza). ");
INSERT INTO ghn_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nari za gabara i Paelati totonai za nongoroni i Jisu za tori uke tu qari gua. Ko za kuku tekua za na tinoni matamata gogoto, ko za nanazia, <<Ae za vei, za tori uke zozoto tugu i Jisu?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ko totonai za nongoro valeania mae tu tana tinoni matamata gogoto za aza za tori uke tu za gua, beto za vamalumu vani i Josepa ko mina boka tekua za na kobukobu tinina i Jisu za gua. ");
INSERT INTO ghn_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ego za vai tekua i Josepa za maka poko koregana, beto za vizu vagorea za na kobukobu tinina i Jisu ko za udeni, beto za lao vakoleni pa maka bevi takori vakolena pa patu mamavarana. Beto za bokili vatitolo lao pateni maka patu lavata za na atakamanana na bevi. ");
INSERT INTO ghn_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ko ari Mere Magadalene beto i Mere na tinana i Josesi za qari batiadia za na ia ketakoi za tavakole na kobukobu tinina i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ego totonai za jola na rane Minyere, za qari vai vakole oela omomanga lea ari Mere Magadalene, i Salome, beto i Mere na tinana i Jekopi, ko mari lao lumuni na kobukobu tinina i Jisu qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ko pana volavolaza lea pana rane momoe pana vuiki aza tugu za bola zagere na tapo za qari lao pa bevi ria. ");
INSERT INTO ghn_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Totonai qari korapa rerege lalaodia za qari kole varivarinanaza makadi, ari qari gua vei, <<I zei mina bokili varijo vadigita za na patu lavata pa ngujuna na bevi?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ura nake patu qeraqerana aza. Ba beto mari dogoro valeana lao qari gua, azae za tori tabokili varijo tu za na patu. ");
INSERT INTO ghn_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ko tonai qari luge lao pa leo bevi, za qari batia za maka tinoni korekoregana za vazaea na poko keala gojo doruru, beto za korapa nyumu nana pa kale matuadi. Ko qari gabara na matagutu ria. ");
INSERT INTO ghn_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ba za paranga za na tinoni aza, <<Muke matagutu na gabara! I Jisu pa Nazareti aza za tavauke pa korosi za gamu korapa nyaqoa gamu! Za tori turu mule tu! Kepore pani aza! Dogoro! Pani tugu za na ia ketakoi qari vakoleni aza. ");
INSERT INTO ghn_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Goto gamu mu lao ko mu vavakato vadi ria nana sepele beto i Pita, ari mugudi vei, <Za tori lao momoe tu pa Qalili aza. Ko ketakoi tu za pala muna batini aza, vei za tori pojadigamu tu perangaina,> mugudi,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ko qari abutu votu ko qari uku loi pale za na bevi, ura qari matagutu beto qari gabara vikevikeredi. Ko qarike izongo vavakato vani tugu maka tinoni, ura qari matagutu. ");
INSERT INTO ghn_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","(Ego pa liguna za turu mule na volavolaza lea pa rane momoe pa vuiki i Jisu, za bola votu momoe ti Mere Magadalene aza. Pana tana tugu na reko ani za iju votudi ka vitu tomete ikikeredi i Jisu perangaina. ");
INSERT INTO ghn_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ko za lao ko za pojadi aza ari ka viza qari tututia i Jisu, tonai qari korapa lukana takulanga. ");
INSERT INTO ghn_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Totonai qari nongoroni za i Jisu za tori toa mule tu beto ko i Mere ba za batianana tu za gudi, ba qarike vazozoto tu ria. ");
INSERT INTO ghn_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pana liguna aza za i Jisu za bola vagoto tadi ari kori sepele tonai qari korapa rerege lao pa maka guguzu. ");
INSERT INTO ghn_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ko ari kori qari gabala mule vavakato vadi ria doru nana sepele, ba qarike vazozotoria tugu. ");
INSERT INTO ghn_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pa liguligu tu za bola votu tadiria ka manogamaka sepele totonai qari korapa tekuteku. Ko za tokeria, ura kepore na dia vinazozoto beto za patu na bulodi ko qarike vazozotoria za ria qari batia pa liguna za turu mule aza. ");
INSERT INTO ghn_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Beto ari za gudi vei, <<Mu votu lao pa doru kota pa kasia guguzu, ko mu taraeni na nongoro leana tadiria doru tinoni. ");
INSERT INTO ghn_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Na tinoni mina vazozoto ko mina tapaputaiso za mina taalo. Goto aza minake vazozoto za mina tavakilasani tugu za nana sela. ");
INSERT INTO ghn_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Beto na vinagilagila ari za mari tuti katakataparia ria mari vazozoto: pa izongoqu ara za pala mari ijiju pale tomete ikikeredi, beto mari parangani na goto parangadi. ");
INSERT INTO ghn_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bari aru dole ba bari buku zakazava varivukedi tugu ria, ba kepore tugu maka za mina apuluria. Pala mari vaopodi na limadi ria na tinoni qari mo, nari za pala mari leanadia gu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ego ko totonai za beto parangaria i Jisu na Bangara ria nana sepele za tateku zae pa noka, ko za nyumu pa kale matuana na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Beto qari keni tarae doru kota ria na sepele, ko na Bangara za roiti tavitiria ko qari tavaneqi za na dia paranga tonai qari tabata ria na vinagilagila varivagabaradi. Agua.)");
INSERT INTO ghn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ego tori motadi tu ria na tinoni qari podepodeke ko qari kuti varitutidi ria na vavakatodi na roiti qari gore votu tadigami. ");
INSERT INTO ghn_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ko na roiti ari za na veveidi tugu qari tori ule vakarovo vadigami tu gami ria qari batini matadi zozoto podalai tu pa podapodalaina beto ko ria qari nabulu kopuni na nongoro leana aza. ");
INSERT INTO ghn_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Bangara Tiopilasi, ko zara za vei za pa liguna tu qa tuti vikitivokotoria na totozo kakazana za doru roiti ria, nari qa rove vaporeveveinaia za ara ma kuti varituti valeana vanigo ao qa gua. ");
INSERT INTO ghn_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Qa korapa roiti vei ari ara ko vei ko mu gilagila valeanaria ao za na zozotodi tugu ria na zakazava qari tori ule vanigo tu ao ria na tinoni qa gua. ");
INSERT INTO ghn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ego na totozo za korapa suvere bangara i Herodi pa ia pikata guguzu pa Jiudia, za suverenana tugu ketakoi za maka iama, na izongona i Zakarae, ko na puku iama tuti lame veina ti Abija aza. Ko i Elizabeti na maqotana ba maka butubutu iama lame veina tugu ti Eroni. ");
INSERT INTO ghn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ko na tinoni tuvizidi pa dogodogoro tana Tamaza ari kori, qari tuti valeanaria ari kori ria doru garunu beto na uana tuvizidi tana Bangara ko za kepore na dia pake pa toa. ");
INSERT INTO ghn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ba za kepore na tudi ari kori ura i Elizabeti za na egoro beto ko ari kori doru za qari tori baragozo na qoele beto tu. ");
INSERT INTO ghn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ego maka rane totonai za kamua za na totozo tadiria na puku iama za somanani i Zakarae, nari za kole roitini na roiti tana iama pa moena na Tamaza i Zakarae. ");
INSERT INTO ghn_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ko pa tutina vei beto qari tamijata tonai qari gonani na patu mijamijata ria na iama qari roiti, za tauduku i Zakarae ko aza za mina lao roitini za na vavavui omanga lea pa zelepade madina. ");
INSERT INTO ghn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ko totonai za korapa vavavui aza, za ria na minete tinoni za qari korapa varavara pa peguruna. ");
INSERT INTO ghn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ko pa totozo tugu aza za votu za na mateana tana Bangara, ko za kole turunana pa kale matuana na ia vavavuina na zakazava omanga lea. ");
INSERT INTO ghn_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ko totonai za batia za za vakamuni na matagutu i Zakarae. ");
INSERT INTO ghn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ba za paranga lao tana za na mateana, ari za gua vei, <<Zakarae, muke matagutu! Ura za tori nongoria tu na Tamaza za na mua varavara. Ko pala mina vaporea na maqotamu i Elizabeti za maka tumu marene, beto ko muna vakukuni i Jone aza. ");
INSERT INTO ghn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ko pala muna qeraqera jola ao beto ko ria na kubo tinoni za pala mari qera tugu tonai mina podo aza. ");
INSERT INTO ghn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ura pala mina maka tinoni poreveveina pa moena na Bangara aza. Minake izongo buku vaini babi na buku neqina aza, beto na Ongu Tabuna za mina kole tana podalai tu tonai mina korapa pa iapana na tinana aza. ");
INSERT INTO ghn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Pala aza mina vagabala mule laoria tana Bangara na dia Tamaza ria na motadi na tinoni Izireli. ");
INSERT INTO ghn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Aza za mina lao momoeni na Bangara. Pala mina lao pa neqi tana Ongonguna na Tamaza maka moqaza podeke vei i Elaija, ko mina vagabalaria na bulodi ria na tamadi ko mari roquroquria na tudi. Beto mina vagabalaria ria na tinoni ikikeredi ko mari izongia na tavagigala tadiria na tinoni tuvizidi. Pala mina roiti vei zara aza ko mina vatana vakole vani na Bangara ria na tinoni,>> za gua za na mateana. ");
INSERT INTO ghn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nari za paranga lao tana mateana i Zakarae, ari za gua vei, <<Ae vei beto mana boka gilagilai ara na zozotona za vei aza? Ura ara za qa tori baragozo tu beto ko na maqotaqu ba za tori qoele tu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nari za oe lao tana za na mateana, <<Ara Qebereli ani! Ara za qa turu pa moena na Tamaza. Ko ara tugu za garunuziu aza ko mana parangaigo beto mana ule vanigo za na nongoro leana ari. ");
INSERT INTO ghn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ko dogoro! Na nongoro qa ule vanigo ara za pala mina gore votu tugu pa totozo tamijatana tana Tamaza. Ba quke vazozoto ao, ko koviria muna poka ko munake boka paranga ao tinganai mina kamua na rane mari gore votu ria na zakazava ari,>> za gua za na mateana. ");
INSERT INTO ghn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ego ria na tinoni za qari kole adonia i Zakarae za qari kole rurani za na veveina za tori zovaini tu pa zelepade madina aza ba zake oqanai votu lame. ");
INSERT INTO ghn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Totonai za votu lame ko zake boka parangaria, nari za qari gilagilai za batia maka dogodogoro pa leona na lose madina aza qari gua. Ko zake boka paranga ko za kole podepodeke pokapokaria gu ria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Totonai za beto ko za okoto ria na rane nabulu za mule laonana pa nana ruma i Zakarae. ");
INSERT INTO ghn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pa liguna za vei aza beto za bogata gu i Elizabeti na maqotana, ko za kole gu suvere ovonana zake kanoko pa ruma ka lima popu. Ari za paranga vei aza, ");
INSERT INTO ghn_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","<<Koviria na Bangara za tokaniziu ara ko qa vei ari. Za dogoro kopuniziu ko na qua kea pa moedi ria na tinoni za varijo paleni aza,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ego totonai za vonomo i Elizabeti, za garunia na Tamaza za na mateana i Qebereli ko za lao pa maka guguzu pa Qalili, na izongona pa Nazareti. ");
INSERT INTO ghn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ko za lao za tana maka reko koregana, aza za tori tavatiolata vakolena tu ko mina elavia maka marene na izongona i Josepa, maka tinoni za podo lame vei pa tutina i Devita na bangara. Ko na izongona na reko koregana aza i Mere. ");
INSERT INTO ghn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ko za lao za na mateana ko za parangia, <<Na mana mi kole tamu! Qu tamana ao! Na Bangara mi somana tamu!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ba tonai za nongoria za na paranga ani za matagutu vitivitigi i Mere, ko za kole roquroqu nyaqonyaqoa aza za ae beka paranga varigozoro veveina ani za gua. ");
INSERT INTO ghn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ba za paranga lao tana za na mateana, <<Mere, muke matagutu! Ura za qeranigo na Tamaza ao. ");
INSERT INTO ghn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ko dogoro! Pala muna bogata ao ko muna vaporea za maka tumu marene ko muna vakukuni i Jisu ao aza. ");
INSERT INTO ghn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pala mina poreveveina aza beto mina tagigala na Tuna na Tamaza ululuna jola, beto na Tamaza aza na Bangara za mina vani na binangara ti Devita aza na nana tite pa moa. ");
INSERT INTO ghn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ko mina bangaradi aza ria na bubutuna i Jekopi kamua na kamua beto ko na nana binangara za mina kepore na vinabetona,>> za gua za na mateana. ");
INSERT INTO ghn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nari za oe lao tana mateana i Mere, <<Ae za vei mina boka gore votu za vei qu pojai ao, ura qa oqoro laoa maka marene ara?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nari za oe laoa na mateana aza, ari za guni vei, <<Na Ongu Tabuna mina lagere tamu ko mina ongugo ao. Ko za vei aza za na koburu mina podo za mina tagigala na liosona beto na Tuna na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Dogoro! I Elizabeti na tavitimu za tori qoele tu aza ba koviria za tori korapa tu bogatani aza za maka koburu marene. Za egoro qari guni na tinoni aza ba koviria za tori vonomo popu tu aza. ");
INSERT INTO ghn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ura kepore za maka zakazava za tapatia na Tamaza,>> za gua za na mateana. ");
INSERT INTO ghn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nari ari za gua vei i Mere, <<Ani ara na nabulu tana Bangara. Mi gore votu tu taqu aza na paranga qu pojai ao,>> za gua. Ego beto za taloi tana za na mateana. ");
INSERT INTO ghn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ego ko pa totozo aza za qaqiri gu i Mere ko za siqarai taloi zae pa kubo pa ia pa Jiudia. ");
INSERT INTO ghn_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ko totonai za kamu za lao luge pa ruma ti Zakarae, ko za lao gozoro qeraqerani i Elizabeti. ");
INSERT INTO ghn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tonai za nongoro tekua i Elizabeti za na varigozoro qeraqera ti Mere, za kanoko za na koburu pa iapana, beto za tavapugeleni na Ongu Tabuna i Elizabeti, ");
INSERT INTO ghn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ko ari za paranga viva vei, <<Na tamanamu joladi ria doru reko ao, ko mina tamana mutugu za na koburu za korapa pa iapamu. ");
INSERT INTO ghn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","I zei ara ko na tinana na qua Bangara za lame tu ovikiziu? ");
INSERT INTO ghn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ura ani! Aza tugu qa nongoria na varigozoro qeraqeramu ao, nari za kanoko gu za na koburu pa iapaqu ura za qeraqera. ");
INSERT INTO ghn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Muna tamana jola ao Mere, ura qu vazozotoa ao aza vei za pojanigo na Bangara za pala mina gore votu!>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Beto ari za gua vei i Mere <<Na buloqu za valavatia na Bangara, ");
INSERT INTO ghn_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","beto na ongonguqu za qerani na Tamaza aza na qua inaalo. ");
INSERT INTO ghn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ura zake dogoro paleniziu ara maka nana nabulu kepore veveiqu. Dogoro! Koviria ko mi lao mari gigalaniziu na reko tamanana ria doru zazae tinoni ara, ");
INSERT INTO ghn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ura na Tamaza neqina jola za roitidi taqu na roiti varivagabaradi. Aza za na liosona na izongona. ");
INSERT INTO ghn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Za vabatidi na nana variroqu varitokai ria na okokoto zazae tinoni, ria qari pangagani aza. ");
INSERT INTO ghn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Na limana za roitidi na roiti neqidi jola, za vanyanyaladi neqa ria qari roquroqu valavata muledi makadi. ");
INSERT INTO ghn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Za vagore paledi aza pa dia tuturuna bangara ria na matamata neqidi, beto za valavataria aza ria na tinoni kepore veveidi. ");
INSERT INTO ghn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Za vapugele vadi na zakazava leadi ria qari burana, goto ria qari izizongo za iju vakeni galegale paledi. ");
INSERT INTO ghn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Za tori tokani tu aza za nana nabulu i Izireli, zake mumani aza za nana variroqu varitokai. ");
INSERT INTO ghn_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Aza tugu mina vei za gua za taringutingutini aza tadiria na tamada pa moa, ti Ebarahami beto tana tutina i Ebarahami kamua na kamua,>> za gua i Mere. ");
INSERT INTO ghn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ego ko za suvere mae tu ti Elizabeti kue popu i Mere, beto za mule pa nana guguzu. ");
INSERT INTO ghn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ego za kamua na nana popu okotona i Elizabeti, ko za vapodoa aza za maka koburu marene. ");
INSERT INTO ghn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ko totonai qari nongoroni ria qari suvere pa varilivutaina beto ria na turana za vei za roquroqu toka veini na Bangara aza, za qari somana qeraqera tavitia aza ria. ");
INSERT INTO ghn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ego beto za totonai za vesu ranena za na koburu, za qari lame somanani na pobena na koburu beto ko mari vizongo tutini i Zakarae na izongona na tamana qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ba za paranga tu za na tinana, <<Dai! I Jone tu za na izongona,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nari ari qari gua vei ria na tinoni tana, <<Ba kepore maka turamu ao za bi tori tavaizongoni mae tu za na izongo aza,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Beto za qari podeke pokapoka laoa ria za na tamana na koburu, ko qari nanazia i zei beka bi vaizongoni aza za na koburu qari guni. ");
INSERT INTO ghn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nari za tepai i Zakarae za maka patu ketakoi mina kutia na izongo, beto za ari za gua vei za kutia, <<Na izongona za i Jone,>> za gua. Nari za qari gabara beto ria doru. ");
INSERT INTO ghn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ego pa totozo tugu aza za revanga za na ngujuna beto za munyala za na meana, ko za paranga vatarazaea aza za na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ko ria doru qari suvere ketakoi za qari matagutu beto. Za tapiara rerege pa doru guguguzu pa kubo Jiudia za na nongoro ari. ");
INSERT INTO ghn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ko ria doru tinoni vei qari nongoria za qari kole roquroquria pa bulodi za ari, ko qari paranga ria, <<Ae beka pala mina koburu veveina za na koburu ani?>> qari gua. Ura za tabata vakabere gu tana za na neqi tana Bangara. ");
INSERT INTO ghn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ego za tavapugeleni na Ongu Tabuna i Zakarae ko za ulule votuni, ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","<<Za pada mina tavatarazae za na Bangara na Tamaza tadiria na tinoni Izireli, ura aza za lame tokadi beto za ruvataria ria na nana tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Beto ko za tori vadigita tu aza za maka inaalo varenena pa tutina i Devita na nana nabulu. ");
INSERT INTO ghn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Aza vei za tori taringutingutini tu aza tadiria na nana tinoni korokorotai madidi pa moa, ");
INSERT INTO ghn_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","za aza mina vasaregita tadiria na nada kana beto pa neqi tadiria doru qarike tavaraguadigita qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ko na Tamaza za vabatidi na variroqu varitokai ria na nada tite, beto zake mumani aza za nana taringutinguti madina. ");
INSERT INTO ghn_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Aza za na taringutinguti za mauluni ti Ebarahami ko mina vadigita za gua: ");
INSERT INTO ghn_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","za taringutinguti vakoleni aza za aza mina vasaregita tadiria na nada kana, ko taneke matagutu nabuluni gita aza za gua. ");
INSERT INTO ghn_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ko gita tana nabuluni aza pa uana liosona beto na tuvizina pa moena aza doru rane pa nada toa za gua. ");
INSERT INTO ghn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ko ao, na tuqu, za muna tagigala na tinoni korokorotai tana Tamaza ululuna jola. Ura muna lao momoeni na Bangara ao, ko muna vatana vakole vani na zona, ");
INSERT INTO ghn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ko muna vagigalaidi ria na nana tinoni na veveina mari taalo ria tonai mina taleozae na dia sela. ");
INSERT INTO ghn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Aza mina roquroqu tokadi ura na nada Tamaza za izongia na bulo variroqu. Pala mina valamea aza tadigita za na kabere volavolaza lea za koko vei pa nulu vavagalo. ");
INSERT INTO ghn_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ko mina vagonadi na kabere ria qari suvere pa rorodomona beto ria qari matagutuni na uke, ko mina gaitia na nada vakasa lao pa zona bule,>> za gua i Zakarae. ");
INSERT INTO ghn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ko za lavata zae ko za neqi pa nana toa ongongu za na koburu. Za suvere pa qega aza tinganai tu za kamua na totozo tonai za votu vakabere tadiria na tinoni Izireli. ");
INSERT INTO ghn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pana totozo aza za vaturua i Siza Oqasitasi na bangara pa Romu za maka vavanau ko mari tanguti ko mari takuti beto ria doru tinoni pa nana binangara za gua. ");
INSERT INTO ghn_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ani za na totozo momoe qari tanguti ria na tinoni ko na nguti tinoni aza za taroiti tonai i Kurinisi za na qavuna pa pikata guguguzu pa Siria. ");
INSERT INTO ghn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ko ria doru tinoni za qari okoto mulemule keni pa dia guguzu togazadi ko mari takuti qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ko i Josepa ba za keni tugu pa Nazareti maka guguzu pa Qalili, ko za zae pa Jiudia pa guguzu Betilihema, na guzu ti Devita, ura na podo lame veina pa butubutu ti Devita aza. ");
INSERT INTO ghn_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ko za toka zaeni aza i Mere ko mari makarai takuti za gua. I Mere za tori tavatiolata vakole tu ko mina elavia aza, beto ko za tori bogata tu za totonai. ");
INSERT INTO ghn_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ko tonai qari korapa suvere pa Betilihema ari kori, za kamu gu za nana totozo okotona i Mere. ");
INSERT INTO ghn_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ko za vapodoa i Mere za na tuna marene podo moena, ko za udeni maka galu poko beto za vakolea ketakoi qari vavavakole vadi na ganigani ria na manugu mademade nenedi, ura za pugele za na ruma suvesuverena tadiria na tinoni kamudi ko kepore za maka lose bari suveria. ");
INSERT INTO ghn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ego qari korapa suveredia tugu pa ia ketakoi ria kaki tinoni kopu sipi, qari korapa kopudi na dia godo sipi na bongi. ");
INSERT INTO ghn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ko totonai za bola vasiboro tadiria za maka mateana tana Bangara beto ko za ude varilivutaidi za na kabere lavata tana Bangara, ko qari matagutu vitivitigi ria. ");
INSERT INTO ghn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Beto ari za gudi vei za na mateana, <<Muke matagutu! Dogoro! Ura ara za qa pogozo lame vadigamu maka nongoro varivaqerana jola ko aza mina vaqera betoria doru tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Za tori podo tu pa ngenari pa guguzu ti Devita za na miu inaalo, na Karisito Bangara! ");
INSERT INTO ghn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ko ani za na vinagilagila muna batia gamu. Tonai muna lao za muna batia maka koburu, za taudeni maka galu poko ko za korapa kolenana ketakoi qari vavavakoledi na ganigani tadiria na manugu mademade nenedi,>> za gua za na mateana. ");
INSERT INTO ghn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Beto za pa totozo tugu aza za lagere somana tavitia na mateana aza za maka minete mateana lavata pa noka, ko qari kera vatarazaea ria za na Tamaza, ari qari gua vei, ");
INSERT INTO ghn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","<<Mi tavatarazae za na Tamaza ululuna jola, beto na bule za mi kole pa pezo tadiria za qeradi aza,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ego ko ligudi qari taloi mule zae pa noka ria na mateana, za qari kole varivariparanga ria na tinoni kopu sipi, ari qari gua vei, <<Aria moko ko talao pa Betilihema, ko talao dogoria za na manugu za pidoko, aza vei za ule vadigita na Bangara,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ko qari siqarai taloi keni ria, ko qari lao tugu batiria ari Mere, i Josepa beto ko na koburu melalu. Ko na koburu za korapa tugu kolenana ketakoi qari vavangojadi na manugu mademade nenedi. ");
INSERT INTO ghn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ko totonai qari batia ria na tinoni kopu sipi za na koburu, nari za qari vavakatoni aza za pojadi na mateana na veveina na koburu. ");
INSERT INTO ghn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nari ria doru qari nongoria na vavakato tadiria na tinoni kopu sipi za qari gabara beto. ");
INSERT INTO ghn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Goto i Mere za kopudi ko za kole roquroquria pa bulona doru zakazava ari. ");
INSERT INTO ghn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ego beto za qari taloi mule kenidia ria na tinoni kopu sipi, ko qari vatarazaea ria za na Tamaza, ura doru zakazava qari nongororia ko qari batiria za zake goto, goto aza tugu vei za pojai na mateana. ");
INSERT INTO ghn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ego ko tonai za vesu ranena ko za tapobe za na koburu, nari za tavakukuni i Jisu na izongona aza, aza vei za tori poja veidi tu na mateana totonai za oqoro tu pidoko pa iapana i Mere. ");
INSERT INTO ghn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ego tonai za kamua za na totozo ko mari roitini ari Josepa i Mere za na vavavui vulavulaza aza vei za pojai na Vavanau ti Mosese, nari za qari pogozo zaeni tugu pa Jerusalema ari kori za na melalu ko mari vamadia tana Bangara qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Qari tutia ari kori za aza vei za takuti kolena pa Vavanau tana Bangara, ari za gua vei, <<Doru koburu marene qari poraka moenia na kolekolena koburu za mari tamijata kale vani na Bangara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ko qari lao vavavuini aza vei za pojai na Vavanau tana Bangara: kori kuru lavata babi kori tuni kuru, za gua. ");
INSERT INTO ghn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ego ko ani za korapa suverenana pa Jerusalema pa totozo aza za maka tinoni, na izongona i Simione, maka tinoni tuvizina beto za izongia na pangagana na Tamaza. Ko za korapa tugu adono valeani aza za na totozo tonai na Tamaza mina vamanotoria ria na tinoni Izireli, ko za gorea na Ongu Tabuna aza. ");
INSERT INTO ghn_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Za tori ule vamoeni tu na Ongu Tabuna aza za minake oqanai uke aza tinganai mina batia mae tu aza za na Karisito tana Bangara za guni. ");
INSERT INTO ghn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ko za tokai na Ongu Tabuna i Simione ko za lao luge pa zelepade. Ko tonai qari pogozo laoni ari kori tinana na tamana pa kakabarena zelepade za na koburu i Jisu ko mari vamadia ko mina taroiti vei aza za tapoja pa vavanau tana Bangara qari gua, ");
INSERT INTO ghn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","nari za teku pogozia i Simione za na koburu ko za vatarazaea za na Tamaza, ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","<<Bangara, qu tori vagore votua tu ao za na mua taringutinguti. Ko koviria mu ruvataziu ara na mua nabulu, ko ma taloi keniqua pa bule. ");
INSERT INTO ghn_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Qa tori batini mataqu tu ara za na inaalo za koko lame vei tamu, ");
INSERT INTO ghn_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","aza qu vatana vakoleni ao pa moedi ria doru tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Aza za na kabere za vadi na kabere ria na tinoni karovodi, beto na neqi ria na tinoni Izireli,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ego ko qari gabarani ari kori tinana na tamana na koburu ria na paranga veveina na koburu za pojaria i Simione. ");
INSERT INTO ghn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Beto za manadi i Simione ria beto ari za guni vei i Mere, na tinana na koburu, <<Dogoro! Na koburu ani za na tamijatana tana Tamaza ko mina valoturia beto mina vatururia ria na kubo tinoni Izireli, beto ko aza za maka vinagilagila tana Tamaza mari kanai ria kubo tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ko ria na roquroqu qari kole golomo pa bulodi na tinoni za mina vavotu betoria aza pa kaberena. Goto ao makamu za na takulanga aza za gani vei na likoto za mina sobea na bulomu,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ego za suverenana tugu vei ketakoi i Hana maka reko korokorotai, na tuna i Panuela, na butubutuna i Asa. Totonai za tori qoele tu aza. Na varielavana perangaina aza, ko ka vitu aoro mae tu qari varisuvere taviti ari kori marenena beto za uke za na marenena. ");
INSERT INTO ghn_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ko za suvere nabonaboko tinganai za kamua na totozo aza tonai za vesungavulu made aorona aza. Na rane na bongi zake selani aza za na lalao vatarazaea na Tamaza pa kakabarena na zelepade. Za toani aza za na toa madimadi ko nake tekuteku beto na toa varavara. ");
INSERT INTO ghn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ko pa totozo tugu aza za kamu i Hana ketakoi, ko za paranga leana lao tana Tamaza, beto za vaqatani aza tadiria za na veveina na koburu, tadiria qari korapa adonia na totozo na Tamaza mina ruvatia na guguzu Jerusalema. ");
INSERT INTO ghn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ego ko totonai qari vaokoto betoria ari Josepa i Mere doru ginugua qari tapoja pa vavanau tana Bangara, nari za ari kue tatamana qari muledia pa Qalili, pa dia guguzu zozoto pa Nazareti. ");
INSERT INTO ghn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ko za lavata zae ko za neqi za na koburu beto za izongo valeania aza za na gigalai tavagigala, beto ko na mana tana Tamaza za kole somana tana. ");
INSERT INTO ghn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ego doru aoro za ari kori tinana na tamana i Jisu za qari zazae somanani na varikamu vavolo Alokata pa Jerusalema. ");
INSERT INTO ghn_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ko tonai za manogori aorona i Jisu za qari zae mutugu somana pa varikamu, qari vevei tugu doru totozo vavolo. ");
INSERT INTO ghn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ego ko tonai za jola za na varikamu, nari za qari gabala mule kenidia ari Mere i Josepa, goto na tudi marene i Jisu za suvere jola tu pa Jerusalema. Ba ari kori tinana na tamana za qarike gilagilai za vei aza. ");
INSERT INTO ghn_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Qari roquroqua ari kori za palu za tori tuti tu pa minete tinoni zara qari gua. Ko za jola tu maka doru rane nari beto za qari kole dogoro nyaqonyaqoa tadiria na tavitidi beto na dia baere. ");
INSERT INTO ghn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ba qarike batia ari kori aza, ko qari gabala mule soga tu pa Jerusalema ko qari mule nyaqoa. ");
INSERT INTO ghn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ko na rane vinaue tu za qari batia ari kori pa kakabarena na zelepade aza. Za korapa nyumu varisomanai tavitiria ria na tinoni qari varivagigalaini na Vavanau aza, ko za korapa nongonongoro beto za nananazaria. ");
INSERT INTO ghn_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ko ria doru qari nongoria za qari gabara jolani za na gigalai beto na nanaza tana. ");
INSERT INTO ghn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ko totonai qari batia aza ari kori tinana na tamana, nari za qari gabara, beto ari za guni vei na tinana, <<Tuqu, ae za vei ko qu roiti vei tu zara? Dogoro! Na tamamu beto ko ara! Gami takulanga jola na kole varivasevi nyaqogo ao gami kori,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nari za oeria aza ari kori, <<Ae za vei ko gamu nyaqoziu tu? Gamuke gilagilai tu gamu za na padaqu tugu mana suvere pa ruma tana Tamaqu ara?>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ba qarike gilagilai ari kori na ginuana aza vei za pojadi aza. ");
INSERT INTO ghn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ego pa liguna za vei aza za beto za tuti muleria aza ari kori na tinana na tamana ko qari gore pa Nazareti. Ko za suvere vataberia aza ketakoi ari kori. Ko na tinana za kopudi ko za kole roquroquria pa bulona doru zakazava ari. ");
INSERT INTO ghn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ego ko za ijoko zae pa tinina beto pa gigigalai tavagigala i Jisu, ko za qerani na Tamaza beto ria na tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ego pa vinamanogalima aorona na binangara ti Tiberiosi, aza na kuta bangara pa Romu, za i Ponitiasi Paelati za na qavuna pa Jiudia, i Herodi na bangara pa Qalili, goto i Pilipi na taina za na bangara pa Ituria beto pa Tarakonitisi, goto i Lusaniasi za na bangara pa Abilini, ");
INSERT INTO ghn_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","beto ari Hanazi i Kaiapasi za na kuta iama lavata. Na totozo aza za lame pa qega ti Jone, na tuna i Zakarae, za na paranga tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ko za reregeia i Jone za doruna na ia pa kori kale varikarovona na pie Jodani ko za taraeni aza za na veveina ria na tinoni za mari gabala loi paledi na dia sela beto mari tapaputaiso ko na Tamaza mi taleozodi za gua. ");
INSERT INTO ghn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ko za gore votu za aza vei za takuti pa buka ti Aisea na tinoni korokorotai, aza ari za gua vei, <<Maka mamalaingi za korapa kukuku pa qega, ari za gua vei, <Mu vatanani na zona tana Bangara, vaemesia ketakoi mina rerege lao vei aza. ");
INSERT INTO ghn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Doru lolomo za mari tavapugele, doru kubo na goregore za mari tavaarare varitoto. Ria na zona kekeqodi za mari tavatuvizi, ria na zona ikikeredi za mari tavaemese. ");
INSERT INTO ghn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ko doru tinoni za mari batia na inaalo tana Tamaza!> za gua.>> ");
INSERT INTO ghn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ego na motadi ria na puku tinoni qari votuvotu lao ti Jone ko mari tapaputaiso qari gua. Nari za ari za gudi vei aza ria, <<Boko tuni dole ikikeremiu! I zei za pojadigamu za muna boka ukuni gamu za na vinakilasa za korapa jojoro lame? ");
INSERT INTO ghn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Goto mu gabala ko mari tabata ria na vua leadi pa miu uana. Muke sianani za na tutina i Ebarahami gami ko pala mami taalomami gu keta mu gua. Ura ma poja valeadigamu gu ara za gamu: na Tamaza za mina boka roiti vani na koburu gu i Ebarahami pana varikamu patu ari! ");
INSERT INTO ghn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ko koviria na varituti za tori tavanaqiti vakole tu, za vei na rio za tavakole pa kutana na suvege ko mi paduru paledi na bageredi na suvege za gua. Ko ria na suvege qarike vuani na vua leana za pala mari tario pale ko mari tagona lao pale pa iku!>> za gua i Jone. ");
INSERT INTO ghn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nari qari nanaza ria na minete tinoni, <<Ego ko na za mami roitini gami?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nari za oeria aza ria, <<Aza na tinoni za kori na nana soti, za mi vani maka aza kepore nana. Beto aza za poregana ganigani, za mi iaria tugu ria za keporedi,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ego ko ria na tinoni tekuteku takisi ba qari lame ko mari tapaputaiso tana qari gua, ko qari nanazia ria aza, <<Tinoni varivagigalai, gami ari za na za mami roitini?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nari za oeria aza ria, <<Na padana gu vei za varigarununi na qavuna za mu tekua, goto muke teku vajolai na takisi,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ria na solodia ba qari lame mutugu tana ko qari nanazia, <<Goto gami ari za ae mami vei? Na za za mami roitini?>> qari gua. Nari za oe laoria aza ria, <<Muke teku ragataria babu jutu goboro sekesekeria ko bu teku vakenidi na dia poata ria na tinoni! Mu qerani gu za na miu tabara!>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ego totonai za ria na tinoni za qari kole adonia pala kaki zakazava mari pidoko qari gua. Ko qari kole variperani ria doru pa dia roquroqu za palu i Jone tugu za na Karisito qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nari za poja betodi i Jone ria doru, <<Ara za qa paputaisodigamu na kolo, goto aza tu za poreveveina jolaniziu ara za korapa tuti lame. Ko ara ba nake padaqu ko mana ruvatia na pikona nana sadolo aza. Aza tu za mina paputaisodigamu na Ongu Tabuna beto na iku. ");
INSERT INTO ghn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ura na sevolo varivaripikatai za tori aruni tu pa limana aza ko mi pikata paledi za gua ria na kopo ikika pa ia iru varipikapikatadi ria na kiko, beto ko mi boko varikamudi pa nana ruma vavakoleni ganigani za ria na kiko vuiti za gua. Goto ria na ikikadi za mari tagona lao pale pa na iku zake boka tailili vaukena,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ko zoku mule ria na vavanau za kole tarae vabalauria i Jone totonai za taraeni aza na nongoro leana tadiria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","I Jone za kole tugu udukia vei i Herodi na bangara, ura za elava tekua i Herodiasi, na maqotana i Pilipi na taina gu beto ko koledia mule kaki roiti zake vagozoro vei za roitidi i Herodi. ");
INSERT INTO ghn_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ego beto za vatamo laoni mule i Herodi za maka roiti ikikerena jola, za vakoleni aza pa ruma varipiu i Jone. ");
INSERT INTO ghn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ego pa liguna qari beto tapaputaiso ria na tinoni za lao i Jisu ko za somana tapaputaiso tugu. Ko totonai za korapa varavara aza za tarevanga za na oka, ");
INSERT INTO ghn_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ko za gore lagere vei na tinonina na kuru tana za na Ongu Tabuna, ko za gore nyumu ake tana. Beto maka mamalaingi za gore lagere vei pa noka, ari za gua vei, <<Ao za na Tuqu qa roquroqugo ara! Qa qera jolanigo ara ao!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ego ko totonai za podalaini na nana roiti i Jisu za pada vei uengavuluputa aorona aza. Pana dogodogoro tadiria na tinoni za i Jisu za na tuna gu i Josepa qari gua, na tuna i Eli. ");
INSERT INTO ghn_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ko i Eli na tuna i Matati aza na tuna i Livai, aza na tuna i Meleki, ko aza na tuna i Janai ti Josepa. ");
INSERT INTO ghn_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ko i Josepa ani na tuna i Matatiasi ti Emosi, na tuna i Nahumi, aza na tuna i Nahumi, na tuna i Esili ti Nagai. ");
INSERT INTO ghn_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ko aza i Nagai ani za na tuna i Maati, na tuna i Matatiasi, na tuna i Semeini ti Joseki, na tuna i Joda. ");
INSERT INTO ghn_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ko i Joda za na tuna i Joanani, aza na tuna i Resa, aza na tuna i Zorobabele, aza na tuna i Salatieli ti Neri, ");
INSERT INTO ghn_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","aza na tuna i Meleki ti Adi, aza na tuna i Kosamu, aza na tuna i Elamadamu ti Ea. ");
INSERT INTO ghn_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ko i Ea za na tuna i Josua ti Elieza, aza na tuna i Jorimi, aza na tuna i Matati ti Livai. ");
INSERT INTO ghn_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","I Livai za na tuna i Simione, aza na tuna i Jiuda, aza na tuna i Josepa, aza na tuna i Jonamu ti Eliakimi. ");
INSERT INTO ghn_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ko i Eliakimi za tuna i Melea ti Mena, aza na tuna i Matata ti Netani, aza na tuna i Devita. ");
INSERT INTO ghn_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ego ko i Devita za na tuna i Jese, aza na tuna i Obedi, aza na tuna i Boazi ti Salamoni, aza na tuna i Nasoni. ");
INSERT INTO ghn_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ko i Nasoni za na tuna i Aminadabi ti Adamini, aza na tuna i Ani ti Hezironi, i Hezironi za na tuna i Perezi ti Jiuda. ");
INSERT INTO ghn_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ko i Jiuda ani za na tuna i Jekopi, aza na tuna i Aisake, aza na tuna i Ebarahami, aza na tuna i Tera, aza na tuna i Nahoa. ");
INSERT INTO ghn_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ko i Nahoa za na tuna i Seruqi ti Raqau, aza na tuna i Peleqi, aza na tuna i Ebea ti Sala. ");
INSERT INTO ghn_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ko i Sala ani za na tuna i Keinani, aza na tuna i Apakazadi ti Semu, aza na tuna i Noa, aza na tuna i Lameki. ");
INSERT INTO ghn_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ko i Lameki za na tuna i Metusela, aza na tuna i Inoke, aza na tuna i Jareti, aza na tuna i Maleleili, aza na tuna i Keinami. ");
INSERT INTO ghn_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ego ko i Keinami ani za na tuna i Enosi ti Seti, ko i Seti za na tuna i Adama, aza na tuna na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ego za pugelia na Ongu Tabuna i Jisu, ko za taloi pa pie Jodani ko mi mulenana za gua. Ko tonai za mule za titai lao pa qega na Ongu Tabuna aza, ");
INSERT INTO ghn_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ko za kole qoraqorai na bangaradi na tomete ka madengavuluputa rane aza. Ko pa doruna na totozo aza za kepore maka za bi tekua aza, ko tonai za jola ka madengavulu rane za burana. ");
INSERT INTO ghn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Beto ari za guni vei na bangaradi na tomete aza, <<Vei muna Tuna zozoto na Tamaza ao, za mu parangia na patu ani ko mi peluku bereti,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nari za oea i Jisu aza, <<Ari tu za gua vei za kole pa Kutikuti Tabuna, <Na tinoni za zake toani na bereti galegale makana,> za gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ego beto na bangaradi na tomete za toka zaeni mule pa maka ia ululuna i Jisu ko za vabatini pa maka iapeki totozo za doruna na binangara pa kasia guguzu. ");
INSERT INTO ghn_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Beto za ari za guni vei na bangaradi na tomete aza, <<Ao mana vani betogo ria dorudi na neqi ari beto na dia izizongo, ura ara gu qa tori taiadi tu za ari ko na tinoni mana nyorogua vani ara za mana boka vani gu. ");
INSERT INTO ghn_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ko ao za vei muna vatarazaeziu ara, nari za muna izongo betoria ao mana vanigo ria dorudi ari,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nari za oea i Jisu aza, ari za guni vei, <<Ba ari tu za gua vei za na Kutikuti Tabuna, <Na Bangara na mua Tamaza mu vatarazaea, beto ko aza gu makana mu nabuluni,> za gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ego beto za toka laoni na bangaradi na tomete pa Jerusalema i Jisu, ko za toka keza vaturua pa batu babanana na kakabarena zelepade, beto ari za guni vei, <<Vei muna Tuna na Tamaza ao, za mu koko pani mu soqolo gore. ");
INSERT INTO ghn_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ura za paranga na Kutikuti Tabuna, <Na Bangara mina garunuria ria na nana mateana ko mari kopu vasarego. ");
INSERT INTO ghn_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Beto ko mari kalogo ria pa limadi ko marike izongo paleka podeke pa patu ria na nenemu,> za gua,>> za gua za na bangaradi na tomete. ");
INSERT INTO ghn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nari za oea i Jisu aza, ari za guni vei, <<Ari tu za gua vei za na paranga pa Kutikuti Tabuna, <Muke podeke vagonai na Bangara na mua Tamaza,> za gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ego ko pa liguna za vaokotoria na bangaradi na tomete ria doru nana toketoke, za taloi keni gu mae tinganai za kamua mule maka totozo leana. ");
INSERT INTO ghn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ego totonai za beto doru ginugua ari za mule laonana pa Qalili i Jisu, ko na neqi tana Ongu Tabuna za kole tana. Ko na nongorona aza za tapiara rerege pa doruna na ia ketakoi. ");
INSERT INTO ghn_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ko za varivagigalai aza pa okokoto ruma varivarikamuna ketakoi, ko qari vatarazae betoa doru tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Beto za mule lao pa Nazareti i Jisu, aza na guguzu ketakoi za lavata zae. Ko pa rane Minyere za lao somana pa ruma varivarikamuna za vevei tugu doru totozo. Ko totonai za turu aza ko za tiroa na Kutikuti Tabuna. ");
INSERT INTO ghn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Na buka za kolea na paranga ti Aisea na tinoni korokorotai za qari valao vani ria, ko za viloto revatia aza za ketakoi qari takuti vakole ria na paranga qari poja vei ari ko za tiroa, ");
INSERT INTO ghn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","<<Na Ongonguna na Bangara za kole taqu, ura za mijataziu aza ara ko mana taraeni na nongoro leana tadiria qari golaba. Za garunuziu aza ara ko mana ule votuni na toa taruvatana tadiria qari tapiu, beto na revangana na matadiria qarike batabata, ko mana ruvataria ria qari nganganguluria ria na tinoni, ");
INSERT INTO ghn_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","beto ko mana taraeni ara na totozo mina aloria na tinoni na Bangara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Beto za polo vijongo sogai aza za na Kutikuti Tabuna ko za vamule lao vani na nabulu kopu, beto za nyumu ko mi podalai varivagigalai tadiria na tinoni za gua. Ko qari dogoro vatogatogazia ria doru tinoni pa leo ruma varivarikamuna, ");
INSERT INTO ghn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","za paranga aza, <<Pa rane pa ngenari tugu ani za gore votu za na Kutikuti Tabuna gamu koni nongoria zana!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ko qari paranga vazae betoa ria doru aza beto qari gabarani ria ria doru nana paranga vavaguadi za paranga votudi aza. Ko qari kole paranga vei ari ria, <<Bi goto zake tagua ko na tuna gu i Josepa zana, akae!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nari ari za gudi vei ria, <<Qa gilagila valeaniaqua ara za pala muna gona lameni gamu taqu za na paranga vei ari, <Ao na tinoni varisalana mu salana mulenigo moko! Ria na zakazava gami nongorodi qu roitidi pa Kepaniami za mu roitidi pani pa mua guguzu ketakoi qu lavata zae!> muna guniziu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Beto ari za gua vei mule, <<Ma poja zozotodigamu ara gamu: na tinoni korokorotai za zake tavalavata pa nana guguzu ketakoi za lavata zae. ");
INSERT INTO ghn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Na zozotona za ma pojadigamu gamu. Pa totozo ti Elaija za na motadi tugu ria na nabonaboko qari suvere pa Izireli pa kue aoro kobuna tonai kepore na okoro, beto ko tonai za raja na songe lavata pa doruna na ia ketakoi. ");
INSERT INTO ghn_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ba na Tamaza zake garunu laoni tana maka ria ari pa Izireli i Elaija, goto za tagarunu laoni tu tana maka nabonaboko pa guguzu pa Sarepata, maka guguzu pa pikata guguzu pa Sidoni aza. ");
INSERT INTO ghn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Beto ko pa totozo ti Elaisa na tinoni korokorotai za qari motadi ria na tinoni poqupoqudi qari korapa suveredia tugu pa Izireli, ba kepore za maka ria bi tataloso valioso, goto i Neamani tinoni pa Siria gu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ko totonai qari nongoria doru tinoni pa leo ruma varivarikamuna aza vei zara za qari tagigiri vikevikeredi. ");
INSERT INTO ghn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ko qari soqolo turu ko qari lao ragata votuni pa peguruna na guguzu aza, beto ko qari toka zagere zaeni pa narena na kubo ketakoi za taroiti na dia guguzu, ko mari juju vatitolo paleni pa taba qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ba za rerege sulopo votu kenana pa varikorapai varikamu tinoni lavata aza ko za kenana. ");
INSERT INTO ghn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ego i Jisu za gore pa Kepaniami maka guguzu pa Qalili, ko za lao varivagigalai tadiria na tinoni pa rane Minyere. ");
INSERT INTO ghn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Qari gabara betoni ria doru za nana varivagigalai, ura za somania na neqi za na nana paranga za parangadi aza. ");
INSERT INTO ghn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ego pa leona na ruma varivarikamuna aza za za korapa za maka tinoni za kolea na ongonguna na tomete ikikerena. Ko za uui votu aza, ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","<<Kei! Na za qu nyorogua roitini tadigami ao Jisu pa Nazareti? Qu lame ko mu piaragami gami qu gua? Qa gilagilagoqua ara ao! Ao za na Liosona tana Tamaza!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nari za tokea i Jisu za na tomete ikikerena aza, <<Ao mu nogoto ko mu votu keni tana tinoni zana!>> za guni. Nari za valotua na tomete ikikerena za na tinoni ani pa moedi ria na tinoni, beto za keninana aza, ba kepore tugu makaza bi veini za na tinoni ani. ");
INSERT INTO ghn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ko qari gabara beto ria doru tinoni, ko qari variparanga vei ari, <<Na paranga za pu vei ari! Za kolea na neqi za na tinoni ani, ko tonai za iju paledi aza ria na tomete ikikeredi tana tinoni nari za qari votu kenidia tugu,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ko na nongorona i Jisu za tapiara rerege pa doruna na ia pa varilivutaina ketakoi. ");
INSERT INTO ghn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ego totonai za taloi pa ruma varivarikamuna i Jisu nari za lao pa ruma ti Saimone. Ko na qoqoele roana i Saimone za za vakamuni na mo mangini lavata, ko qari lao pojani i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nari za lao turu pa kekerena na reko za mo i Jisu, ko za tokea za na mo mangini nari za taloi tana za na mo. Ko pa totozo tugu aza za tatakole za na reko aza ko za vatanaria ria. ");
INSERT INTO ghn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ego totonai za suvu na tapo za qari toka kamudi ria ketakoi ti Jisu ria na tinoni za vairia na okokoto vagauru. Ko za vaopodi na limana aza, ko za salana betoria. ");
INSERT INTO ghn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ria na tomete ikikeredi ba qari okoto votu taloidia tadiria na tinoni ko qari uui, ari qari gua vei, <<Ao tugu za na Tuna na Tamaza!>> qari gua. Ba za tokeria i Jisu ria na tomete ikikeredi, beto ko zake vamalumuria ko bari paranga, ura qari tori gilagilaidia tugu ria za aza za na Karisito. ");
INSERT INTO ghn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ego totonai za volavolaza rane na kota za taloi pa gugusu aza i Jisu, ko za lao pa maka ia kaloina. Ba qari lao tugu nyaqo tututia ria na tinoni aza, ko qari lao tugu batia, beto qari aru vasuveria ko mike loiria aza qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ba ari za gudi vei ria, <<Tadiria kaki goto guguzu za ara ba mana taraeni tugu za na nongoro leana veveina na binangara tana Tamaza, ura aza tugu za garunu lameniziu ara na Tamaza ko mana roitini,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ko za kole tarae pa rumaruma varivarikamuna tadiria na tinoni pa Jiudia i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ego maka rane totonai za korapa turunana pa poanana pa nole pa ovuku Qenesareti i Jisu, za qari varijujuku upupele lao tana ria na minete tinoni, ko mari nongonongorodia pa paranga tana Tamaza qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ko za dogoro vairia aza tonai za kori koaka qari korapa titidia pa keketai ovuku. Goto ria na tinoni abu poredia koaka za qari korapa valiosoria na dia vaqara. ");
INSERT INTO ghn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ko za lao zaea aza za maka, aza na koaka ti Saimone, beto za garunia i Saimone ko mi vaiolo zae iapeki pa kolona za guni. Ko za nyumu ketakoi i Jisu beto za kole varivagigalai paro tadiria na minete tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ego tonai za beto parangaria na minete tinoni za ari za guni vei i Saimone, <<Mu vaiolo jola zaea pa lilisina za na koaka, beto za mu gonani ketakoi za na miu vaqara,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nari za paranga i Saimone, ari za gua vei, <<Qokolo! Gami tori pavu talea tu na bongi doruna gami, ba kepore zozoto tugu maka za babi tekuamami! Ba qu paranga ao, ko leana ara ma lao tu ropi vagorea za na vaqara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ko totonai qari ipa goreni na vaqara za varivagabara za na igana qari gona, ko na vaqara ba iapeki bi taraqama tu. ");
INSERT INTO ghn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ko qari sipu laoria ria na tavitidi pa maka goto koaka ko mari lame tokadi qari gua. Ko qari makarai vapugeledi na igana ria za kori koaka ria, ko iapeki bari dururu tu. ");
INSERT INTO ghn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ego totonai za batia i Saimone Pita za na roiti za podo vei ari, za lao nyumu sori tungutungu aza pa moena i Jisu, beto ari za gua vei, <<Mu taloi taqu Bangara, ura na tinoni sela ara!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ura za gabara vitivitigini i Pita beto ria doru qari tutia aza za na ae koi vei motadi na igana qari tekuria. ");
INSERT INTO ghn_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ko ria na tinoni abu tavitina i Pita, ari Jekopi i Jone (kori tuna marene i Jebeti) ba qari gabara tugu. Nari ari za guni vei i Jisu i Saimone, <<Muke matagutu! Podalai koviria za muna abu tinoni ao,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ko pa liguna qari juju vaparoria za na dia koaka, za qari loi vakole beto paledi ria doru dia zakazava ko qari tutiadia ria i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ego maka totozo tonai za korapa suvere pa maka guguzu i Jisu, za ani maka tinoni za vaia na poqupoqu. Ko totonai za batia aza i Jisu, za gona opo goreni pa pezo na izumatana, beto za tepa vitivitigi, ari za gua vei, <<Bangara, vei muna malumu ao, za muna boka tataloso valiosoziu gu ara!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nari za kaqama laoni na limana ko za ulia i Jisu aza, beto ari za gua vei, <<Qa malumu gu ara, ko mu lioso tu ao,>> za guni. Ko pa totozo tugu aza za tataloso valioso tana za na poqupoqu. ");
INSERT INTO ghn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Beto za paranga vabalaua i Jisu aza, <<Munake lao vavavakatoni tadiria tinoni ani, goto mu rerege tuvizi lao gu tana iama ko mi dogoro vilovilotigo. Pa liguna aza za muna lao roitini na vavavui vulavulaza aza vei za varigarununi i Mosese, ko mari vazozotoa ria na tinoni za qu tori tavalioso tu ao mari gua,>> za guni aza. ");
INSERT INTO ghn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ba tonai zake mako gore na reregena za na nongorona i Jisu, ko ria na minete tinoni za qari varikamu lao tana ko mari nongonongorodia beto mari tasalanadia pa okoto dia vagauru qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ba za tuturu rijo keninana pa qega i Jisu ko za kole varavaranana. ");
INSERT INTO ghn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ego maka rane totonai za korapa varivagigalai i Jisu, za na suveredi tugu ketakoi kaki Parese beto ria qari varivagigalaini na Vavanau, na lame veidi pa okoto guguzu pa Qalili, pa Jiudia, beto pa Jerusalema. Ko na neqi tana Bangara za tori kolenana tu ti Jisu ko mina boka varisalana. ");
INSERT INTO ghn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ego ko ani qari pala kamuni ria kaki tinoni pa nana lovu za maka tinoni za uke kale na tinina, ko qari podepodeke ko mari pogozo valugea pa leo ruma, ko mari vakolea pa moena i Jisu qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ba qarike boka batia ria za na zona vei beto mari pala valugea, ura qari pugele ria na tinoni. Ko qari pogozo keza zaeni pa nare ruma ko qari kakelia za na arena na ruma, beto qari vasikulu gorea pa varikamu tinoni pa moena i Jisu za na tinoni aza tonai za korapa kolenana tugu pa lovu. ");
INSERT INTO ghn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ko totonai za batia i Jisu za na dia rangerange, za parangia aza za na tinoni za mo, <<Qua tinoni, qari tori taleozo tu ria na mua sela,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nari qari podalai varipera paranga makadi ria qari varivagigalaini na Vavanau beto ria na Parese, <<Ae tinoni veveina ani! Za korapa vamoroania na Tamaza za na tinoni ani! Kepore za maka tinoni mina boka taleozoni na sela, goto makana gu na Tamaza!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ba za tori livutia tu i Jisu aza vei qari kole variperani paranga ria, ko ari za gudi vei ria, <<Na za gamu kole variperani pa bulomiu gamu? ");
INSERT INTO ghn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ae za munyala na pojana? <Qari tori taleozo tu ria na mua sela!> bi gua, ba <Mu tatakole ko mu rerege!> bi gua? ");
INSERT INTO ghn_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ba ma vadogorodigamu ara za na Tuna na Tinoni za kolenana nana neqi pa pezo ko mina taleozodi na sela,>> za gua. Beto za ari za guni vei za na tinoni za uke maka kale tinina, <<Qa parangaigo ara ao, mu turu, mu pogozia na mua lovu, ko mu mule laomua pa mua ruma!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nari pa totozo tugu aza za soqolo turu pa moedi ria doru tinoni za na tinoni ani, za pogozia nana lovu aza za koleni, ko za mule keninana pa nana ruma, beto za vatarazaea aza za na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ko qari gabara beto ria doru tinoni totonai qari batia za vei zara. Qari vatarazaea ria za na Tamaza, beto qari matagutu tugu vei ko qari varivariparanga, <<Koi, na zakazava varivagabaradi za taqe batiria gita pa ngenari!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ego liguna aza za taloi ketakoi i Jisu, ko za lao dogoria za maka tinoni tekuteku takisi na izongona i Livai, za korapa nyumunana pa ruma tekuteku takisi. Ko za parangia i Jisu aza, <<Lame tutiziu,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nari za turu loi paledi tugu i Livai za doru nana zakazava, ko za lao tutia i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Beto za roitini i Livai pa nana ruma za maka vavolo lavata ko za tekuteku tavitia i Jisu. Ko na motadi ria na tinoni tekuteku takisi tavitina beto ria kaki tinoni mule qari tasoru ko qari somana tekuteku. ");
INSERT INTO ghn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ba ria na Parese beto ria na dia tinoni qari varivagigalaini na Vavanau za qari qumiqumidi ria na sepele ti Jisu, ko ari qari gua vei ria, <<Ae za vei ko gamu tekuteku tavitiria tu ria na tinoni tekuteku takisi beto na tinoni seladi za gamu?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nari za oeria i Jisu ria, ari za gudi vei, <<Ria na tinoni toa valeanadi za qarike nyaqoa za na tinoni za varisalana, goto ria gu qari mo. ");
INSERT INTO ghn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Qake lame ara ko ma kukuria na tinoni tuvizidi qa gua, goto ria tu na tinoni seladi ko mari gabala qa gua!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Beto za qari nanazia ria na Parese beto ria na dia tinoni qari varivagigalaini na Vavanau i Jisu, ari qari guni vei, <<Ae za vei ko ria na sepele ti Jone beto ko ria na sepele tadiria na Parese za qari tabutabu ganigani beto qari varavara zoku totozo, goto ria na sepele tamu za qari kole gu tekuteku beto buku laodia gu?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nari ari za gudi vei i Jisu, <<Ae vei, muna boka vatabutabu ganiganiria tu ria na tinoni tasorudi mari somanani na vavolo varielava totonai za korapa suvere tavitirianana na tinoni varielava? Dai! ");
INSERT INTO ghn_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ba qari korapa lame ria na rane tonai mina tateku varijo tadiria za na tinoni za varielava. Ko pa totozo tu aza za mari tabutabu ganigani ria,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Beto za pojadi mutugu i Jisu za na vinakabere ani, <<Kepore za maka tinoni mina boka rikata tekua maka rikata poko koregana, ko mina piti valaoni pa maka poko leluna. Mina roiti vei za pala mina tarikata za na poko koregana, beto ko na poko leluna za minake lao totoa za na poko tuvatuvaka koregana. ");
INSERT INTO ghn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Beto kepore mutugu za maka tinoni mina toto laoni na vaini koregana za na tototona vaini leluna. Ura mina taroiti vei za pala mina tapokatanana za na tototoni vaini leluna ko mina tavuva vikerenana za na vaini, beto ko na tototoni vaini ba mina taaru vikere tugu. ");
INSERT INTO ghn_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Goto na vaini koregana za mina tatoto valao tugu pa tototona koregana. ");
INSERT INTO ghn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ko kepore za maka tinoni za bukubuku vaini leluna bi nyorogua bukua za na vaini koregana. Ura za paranga za na tinoni aza, <Na vaini leluna tu za giropo!> za gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ego pa maka rane Minyere tonai za rerege jola lao vei pa leo inuma vuiti i Jisu beto ria na nana sepele, za qari kole ravuravuzu teku kiko vuiti ria na nana sepele, ko qari ngaja ganiganigedi. ");
INSERT INTO ghn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ba qari bati poaria ria na Parese ria, ko qari nanazaria, <<Ae za vei za gamu roitini tu na roiti zake tavamalumu pa rane Minyere?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nari za oeria i Jisu ria, <<Beko gamu tori tiroamiu tu gamu za na roiti za roitini i Devita pa moa, ba gamu oqoro tu vakaberia za? Totonai za burana i Devita beto ko ria na tinoni qari tutia, ");
INSERT INTO ghn_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","za luge lao aza pa leona na ruma tana Tamaza, ko za tekua aza za na bereti madina ko za gania beto za vadi tugu vei ria na nana tinoni. Ba kepore maka tinoni za tavamalumuni ko mina boka tekua za na bereti aza, goto ria na iama gu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Beto za parangaria i Jisu ria, <<Na Tuna na Tinoni za na bangarana na rane Minyere,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ego pa maka rane Minyere mule tonai za luge pa maka ruma varivarikamuna i Jisu za korapa suverenana ketakoi za maka tinoni za raiqo na lima kale matuana. ");
INSERT INTO ghn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ko ria qari varivagigalaini na Vavanau beto ria na Parese za qari nyaqoa kaki zona ko mari jutuni za sela i Jisu qari gua, ko qari kole dogoro kopu totoni za vei mina salana tinoni tu beka pa rane Minyere aza qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ba za tori gilagilaria tu i Jisu ria na dia roquroqu, ko ari za guni vei za na tinoni za raiqo maka kale limana, <<Mu turu, ko mu rerege lame pa korapa,>> za guni. Nari za soqolo turu za na tinoni aza ko za lao turu ketakoi. ");
INSERT INTO ghn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Beto ari za gudi vei i Jisu ria na tinoni, <<Ego ma nanazagamu ara gamu. Ae za za vamalumia na Vavanau ko mina boka taroiti pa rane Minyere? Na roitini na leana, ba na roitini na ikerena? Na aloa na toa, ba na piara pale?>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Beto za kole dogoro varilivutaidi aza ria doru beto ari za guni vei aza za na tinoni. <<Mu radonia na limamu!>> za guni. Nari za radonia tugu, ko za leana soga za na limana aza. ");
INSERT INTO ghn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Totonai za qari tagigiri vitivitigi ria, ko qari kole varivavakatoni makadi ria za na za mari boka roiti laoni ti Jisu qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ego ko pa maka totozo za zagere zae pa maka kubo i Jisu ko za varavara. Ko za suvere na bongi doruna pa batu kubo aza ko za kole varavara lao tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ko totonai za volavolaza rane na kota za kuku tekuria ria doru nana sepele ko za mijata tekuria aza ari ka manogori ko ria za kukudi na tinoni tagarunudi. ");
INSERT INTO ghn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ko ari ria za mijataria aza: i Saimone aza za vaizongoni i Pita beto i Aduru na taina, ari Jekopi i Jone, i Pilipi i Batolomiu, ");
INSERT INTO ghn_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ari Matiu, i Tomasi, i Jekopi na tuna i Alepiasi, beto i Saimone aza perangaina na somanana mae tadiria qari nyorogua adu paleni na qavuna pa Romu, ");
INSERT INTO ghn_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","i Jiudasi na tuna i Jekopi, beto i Jiudasi Isikarioti aza na tinoni za gabala kanai i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ego totonai za mule gore pa kubo tavitiria ria na nana tinoni tagarunudi i Jisu nari za turu tavitiria aza pa maka ia ararena ria zoku nana sepele. Ko na minete tinoni lavata za tori korapa tu ketakoi, ria na lame veidi pa doru ia pa Jiudia, pa Jerusalema, beto ko vei tugu pa guguzu babatana pa Turosi beto pa Sidoni. ");
INSERT INTO ghn_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ria na tinoni za qari lame ko mari nongoria aza beto mari tasalanadia pa okoto dia vagauru qari gua. Ko ria za koleria na ongongu ikeredi ba qari tasalana tugu. ");
INSERT INTO ghn_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ko ria doru za qari kole podepodeke vitivitigi ko mari ulia aza ko mari tasalanadia qari gua, ura na neqi za votu tana ko zoku tinoni qari tori tasalana tu. ");
INSERT INTO ghn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ego za dogoro laoria na nana sepele i Jisu ko za paranga, <<Gamu tamana za gamu gamu golaba, ura tadigamu za na binangara tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Gamu tamana za gamu gamu burana koviria, ura gamu za pala muna tavapote valeana. Gamu tamana za gamu gamu lukana takulanga koviria, ura pala muna au qeraqera za gamu. ");
INSERT INTO ghn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Gamu tamana za gamu tonai marike tavaraguadigamu ria na tinoni beto tonai mari ijugamu, mari poja vikevikeregamu, beto mari jutudigamu na tinoni ikikeremiu pa ginuana gamu tutia na Tuna na Tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mu qera ko mu soqolo qeraqera tu za pa totozo aza, ura nu vainongoro! Na lavatana jola za na miu pinia pa noka. Na roiti ngangangulu vei tugu zara za qari roitidi ria na boko tamadi lao tadiria na tinoni korokorotai pa moa. ");
INSERT INTO ghn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Goto gamu na tinoni izizongo za mu takulangagemiu tu, ura gamu tori tekua tu gamu za na toa leana. ");
INSERT INTO ghn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mu takulangagemiu tu za gamu gamu pote valeanagemiu koviria, ura kolenana za na totozo muna burana za gamu. Mu takulangagemiu tu za gamu gamu au kidokidolo koviria, ura kolenana za na totozo tonai muna lukana takulanga za gamu. ");
INSERT INTO ghn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mu takulangagemiu tu za gamu tonai mari paraparanga vatarazaegamu ria doru tinoni, ura ria na tamadi ba qari roiti veidi tugu ria na tinoni korokorotai sekesekedi pa moa,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","<<Ba ma pojadigamu za gamu gamu nongoroziu ara: mu roquroquria ria qari kanagamu, mu roiti valeana lao tadiria qarike tavaraguadigamu, ");
INSERT INTO ghn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","mu tepa vadi na mana ria qari levelevedigamu, beto mu varavara tokadi ria qari ngangangulugamu. ");
INSERT INTO ghn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bi tapalia maka kale paparamu za maka tinoni, za mu balinga lao vani mule maka kalemu. Bi tekua na mua koti za maka tinoni, za muke suqutia ko mi tekua mutugu za na mua soti. ");
INSERT INTO ghn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Na tinoni za tepanigo na zakazava za mu iai, na tinoni za teku vakeninigo maka mua zakazava za muke tepa muleni. ");
INSERT INTO ghn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ko aza tugu vei qu nyoroguani ko ria na tinoni mari roiti lameni tadigamu za aza tugu za mu roiti laoni tadiria na goto tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Vei muna roquroqu kalekaleria gu gamu ria qari roquroqugamu, za keta mu kole roquroqua pala muna tekuni na mana za na roiti vei aza! Ura ria na tinoni seladi gu ba qari roquroquriadia ria qari roquria. ");
INSERT INTO ghn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Vei muna roiti kalekale valeana lao tadiria gu qari roiti valeana lame vadigamu, za keta mu kole roquroqua muna tekuni na mana gamu za vei aza! Ura ria na tinoni seladi gu ba qari roiti valeana lao tugu za tadiria na tinoni qari roiti valeana lao vadi. ");
INSERT INTO ghn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ko vei tadiria gu qu gilagilai pala muna boka teku muledi na miu zakazava za qu vamalumuria ko mari tekua maqalai na miu zakazava, za keta mu kole roquroqu muna tekuni na mana gamu za vei zara! Ura ria na tinoni seladi gu ba qari bokadia vamalumu ria na dia zakazava ria na tinoni seladi vei ko mari teku muledi ria na padana tugu aza vei qari valaoa qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ba gamu za muke roiti vei zara! Mu roquroquria tu ria qari kanagamu, beto mu roiti valeana lao tadiria. Mu vadi gu aza na manugu mari tekua gu mae qari gudigamu beto muke kole roqu totoni za na miu zakazava aza. Muna vei za pala mina lavatana jola za na miu pinia pa noka beto ko tonai za qu roiti vei na boko koburu tana Tamaza ululu jolana za gamu. Ura na Tamaza za roquroqu betoria gu ria qarike boka paranga leana lao tana beto ria na tinoni ikikeredi. ");
INSERT INTO ghn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Na Tamaza za roquroquria beto za roiti valeana lao tadiria doru tinoni, ko gamu ba mu roquroquria beto mu roiti valeana lao tugu tadiria doru tinoni,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","<<Muke tutidi na sela tadiria na goto tinoni, ko mike pitugamu na Tamaza. Muke jutu taridi na varituti tana Tamaza ria na goto tinoni, ko gamu ba muke tajutu taridigamu tugu za na varituti tana Tamaza. Mu taleozodi na goto tinoni, ko na Tamaza ba mi taleozodigamu tugu. ");
INSERT INTO ghn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mu ia valeanaria na tinoni, ko mi ia valeanagamu na Tamaza. Aza mina iadigamu aza za na ia nabuna, mina vei na boko kiko bou za tasaqiti ko za tanyoqonyoqoro valeana ko za pugele nyonyoa beto gamu tinu boruboruria na miu. Ura aza tugu na pada gamu ia valeana veidi ria na goto tinoni, nari za aza tugu mina ia valeana veidigamu na Tamaza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Beto aza za pojadi mule i Jisu za na vavakato vavapada ani, ari za gua vei, <<Na tinoni zake batabata za minake boka titai za maka goto tinoni nake batabatana. Vei mina titai za pala mari makarai lotu loposo pa maka pou ari kori. ");
INSERT INTO ghn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Na sepele za zake poreveveina jolani na nana tinoni varivagigalai. Goto totonai mina vakoititi valeanaria mae tu na sepele ria na varivagigalai tana nana tinoni varivagigalai za beto za mina kamua za na bokaboka tana nana tinoni varivagigalai. ");
INSERT INTO ghn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ae za vei ko qu tapatianani dogoria tu ao za na opopu pa matana na taimu, ba na lomoto kobukobu pa matamu makamu za quke pavu galani? ");
INSERT INTO ghn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ae za vei ko qu boka paranga veini tu ari na taimu, <Taiqu, mae! Ma kazi pale na opopu pa matamu,> qu gua tu? Ba na lomoto kobukobu pa matamu quke batia! Na tinoni vavabatamu na sekesekemu ao! Momoe mu kazi pale mae za na lomoto kobukobu pa matamu, beto za muna batabata valeana ko muna boka kazi pale za na opopu pa matana na taimu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","<<Na suvege leana za zake vuani na vua ikerena, beto na suvege ikerena za zake vuani na vua leana. ");
INSERT INTO ghn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Doru suvege za qari tagilagila na leadi babi na ikeredi tonai tana dogoria na vuadi. Munake boka lokete teku vua suvege piqi ao pa suvege varivariokana, beto ko munake boka teku vunguvungu qurepi ao pa gazoro varivariokana. ");
INSERT INTO ghn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Na tinoni leana za vavoturia ria na uana leadi qari kole pa bulona ko za roitini na roiti leana, goto na tinoni ikikerena za vavoturia na uana ikikeredi qari kole pa bulona ko za roitini na roiti ikikerena. Ura aza tugu za pugele nyonyoa pa bulona na tinoni za taparanga votuni pa ngujuna,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","<<Ae za vei ko gamu kukuniziu, <Bangara! Bangara!> ara za gamu, beto gamuke tutiria aza vei qa pojadigamu ara? ");
INSERT INTO ghn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Aza za lame taqu ko za vainongorodi na qua paranga beto za vataberia, za ma ule vadigamu ara ae tinoni veveina aza. ");
INSERT INTO ghn_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Na tinoni aza za maka moqaza podeke vei na tinoni za roitini na nana ruma, za kori valolu gore ko tinganai za kamua na patu beto za vaturua aza za nana kokovana ruma, beto za vaturua za nana ruma. Ko totonai za gore na qolapezo, za vae na pie ko za raja pa ruma aza ba zake boka jou kanoko za na ruma aza, ura za tapatu biti vamauru pa patu aza. ");
INSERT INTO ghn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ba aza na tinoni za nongorianana tugu za na qua paranga ba zake vataberia, za maka moqaza podeke vei na tinoni za roitini na nana ruma pa pezo munyalana kepore patu bitina aza. Ko totonai za gore na qolapezo, za vae na pie ko za raja pa ruma aza, za zake oriavo tugu lotuna za na ruma aza, ko za tajegara pipiara betonana!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Totonai za beto pojaria i Jisu ria doru zakazava ari tadiria na tinoni, za taloi lao pa Kepaniami aza. ");
INSERT INTO ghn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ego na suverena tugu ketakoi za maka tinoni matamata gogoto. Ko kolenana za maka nana nabulu aza za roquroqu vitivitigia aza za mo ko za tata uke. ");
INSERT INTO ghn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Totonai za nongoroni na tinoni matamata gogoto ani za na veveina i Jisu, za garunuria aza ria kaki tiolata tadiria na tinoni Jiu ko mari lao tepai i Jisu ko mi lame salania na nana nabulu za gua. ");
INSERT INTO ghn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ko tonai qari kamu ria ti Jisu za qari tepa tokatokai aza, ari qari gua vei, <<Na bangara ani za garo tugu muna lao tokani ao. ");
INSERT INTO ghn_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ura aza za roquroqugita za gita na tinoni Jiu beto aza tugu makana za roiti vadigita za na nada ruma varivarikamuna,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ego leana za gua i Jisu ko za tuti laoria ria. Ba totonai za tata kamua gu aza za na ruma, nari za garunuria na tinoni matamata gogoto ani ria kaki nana baere ko qari lao poja veini ari i Jisu, <<Bangara, keta mu kole pavu goboro. Ara nake padaqu ko ao muna lame luge pa qua ruma. ");
INSERT INTO ghn_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ko za vei tugu aza za ara ba qake dogoro vapadaniziu ko mana lame tamu! Goto mu leve lameni gu tana za na salana ko mi toanana za na qua nabulu. ");
INSERT INTO ghn_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ura ara ba ria tugu na tinoni za koleria na neqi qari kopuniziu beto koledia mutugu ria na tinoni varipera qari takopu pa neqi taqu, ko ara qa gilagilaiqua za ae za vevei tonai za izongo neqi na tinoni. Ko vei, <Lao ao!> baguni ara za maka, nari za lao gu aza. Beto vei, <Lame!> baguni mule ara za maka, za lame tugu aza. Vei nari mu vei baguni na qua nabulu, nari za roitini tugu aza. Goto ao na mua neqi za na lavatana jola ko muna paranga gu pani, nari pala mina tasalana tugu koviria aza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Totonai za nongoria i Jisu na paranga tana bangaradi na tinoni varipera za vei zara za gabara, ko za gabala ko za paranga laoria aza ria na minete tinoni qari tutia, <<Ma poja valeadigamu ara za gamu: qa oqoro izongo batia ara pa Izireli za maka tinoni za izongia na rangerange lavatana jola vevei tana tinoni ani,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Beto za qari gabala mule lao pa ruma tana bangaradi na tinoni varipera ari ka viza qari pogozo nongoro, ko qari lao kamu za qari batia za na nabulu za tori tasalana tu. ");
INSERT INTO ghn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ego za oqoro zovai gu za jola za vei zara za taloi lao pa maka guguzu na izongona pa Neini i Jisu. Ko ria na nana sepele beto ko maka minete tinoni lavata za qari tutia aza. ");
INSERT INTO ghn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ko aza tugu za tata kamua na atakamanana na guguzu lavata aza, nari za qari pogozo bola lameni gu ria za maka tinoni za uke ko mari keni golomia qari gua. Na tinoni za uke aza za aza tugu maka tuna makamakai maka nabonaboko. Ko maka minete tinoni lavata pa guguzu lavata aza za qari tutia votu na nabonaboko. ");
INSERT INTO ghn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ego totonai za dogoria na Bangara za na naboko ani za roquroqu vitivitigia, ko ari za guni vei, <<Muke lukana!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Beto za rerege lao ko za arua za na kobukobu tomete taudena, ko ria qari pogozia na kobukobu tomete za qari turu nogoto. Beto za paranga laoa aza za na tinoni ukena, <<Koburu marene korega, ara qa parangaigo ao ko mu tatakole!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nari za toa mule ko za tatakole nyumu za na tinoni za uke ko za podalai paranga. Beto za toka laoni i Jisu tana na tinana za na tinoni ani. ");
INSERT INTO ghn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Qari matagutu beto ria doru, ko qari vatarazaea ria za na Tamaza, ari qari gua vei, <<Maka tinoni korokorotai lavata za kamugita beto na Tamaza za lame ovikiria ko mi aloria na nana tinoni za gua,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ko aza na nongorona na roiti za roitini i Jisu ani za tapiara rerege pa doru kota pa Jiudia beto ko tadiria doru guguzu pa varilivutaina na ia aza. ");
INSERT INTO ghn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ego totonai qari vavakato vani ria na nana sepele i Jone za na veveidi doru roiti za roitidi i Jisu, za kuku tekuria aza ari kori nana sepele ");
INSERT INTO ghn_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ko za garunu laodi ti Jisu ko ari mari nanaza veini za gudi, <<<Ao tugu za aza qari roverove veini na tinoni za korapa lamelamenana qari guni? Ba maka goto tu za mami adonia gami?> muna guni,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ko tonai qari lao kamu ari kori ti Jisu za qari nanazia aza, <<Za garunugami i Jone Paputaiso gami kori ko ari muna nanaza veini za gudigami, <Ao tugu za aza qari roverove veini na tinoni za korapa lamelamenana qari guni? Ba maka goto tu za mami adonia gami?> za gua,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ego totonai tugu qari korapa suveredia ari kori za i Jisu za salanaria ria na kubo tinoni qari mo beto qari gozororia na vagauru, beto ko ria za rajaria na tomete ikikeredi. Beto kubo ria qarike batabata za vabatabataria aza. ");
INSERT INTO ghn_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ko za oeria aza ari kori tinoni pogozo nongoro ti Jone, ari za gudi vei, <<Mu mule lao ko mu vavakato vani i Jone ria vei gamu batiria beto gamu nongororia gamu. Ria qarike batabata za qari batabata, ria na qao qari rerege, ria na poqupoqu za qari tataloso valioso, ria na kiqili za qari tavonga, ria qari uke za qari tavatoa mule, beto ria na golabadi qari tekua na nongoro leana. ");
INSERT INTO ghn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Qari tamana ria qarike tatupe taleniziu ara, muguni,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pa ligudi qari mule keni ria na sepele ti Jone, za podalai vavakatoni i Jisu tadiria na minete tinoni za na veveina i Jone. Za paranga aza, <<Totonai gamu lao pa qega ko gamu dogoria i Jone gamu gua za gamu, za na za gamu lao dogoria gamu gua? Maka tinoni za malemalei vei na equru buruburu za jou vakanokanokia na gava? Dai ke! ");
INSERT INTO ghn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ko na za tu za gamu nyorogua lao dogoria gamu? Maka tinoni za pokopokodi na poko batabata leadi? Dai, ria na tinoni qari pokopoko valeana vei zara za qarike suvesuvere pa qega, goto qari kole gu suvesuvere valeanadia pa ruma tadiria na bangara! ");
INSERT INTO ghn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ego ko na za zozoto za vei gamu nyorogua lao dogoria gamu? Maka tinoni korokorotai? E, zozoto na tinoni korokorotai tugu aza, ko za poreveveina joladi ria na tinoni korokorotai aza. ");
INSERT INTO ghn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ani za pojai na Kutikuti Tabuna na veveina aza, ari za gua vei, <Dogoro! Ara qa garunu laoni pa moemu ao za na qua tinoni pogozo nongoro. Aza za mina vatana momoea za na zona tamu,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ma poja valeadigamu ara za gamu: kepore za maka tinoni za podo lame pa kasia guguzu ani bi poreveveina jolani i Jone, ba aza tu za kepore veveina jola pa binangara tana Tamaza za poreveveina jolani i Jone,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ko tonai qari nongoria i Jone nari za ria doru tinoni beto ko ria na tinoni tekuteku takisi qari vazozotoa za na Tamaza za tuvizi qari gua, ko qari tapaputaisodia tana. ");
INSERT INTO ghn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Goto ria na Parese beto ria qari varivagigalaini na Vavanau za qarike tavaraguani za aza vei za nyoroguani na Tamaza ko bari roitini, ko qari daidia tapaputaiso ti Jone. ");
INSERT INTO ghn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ko za paranga i Jisu, <<Ego, ko na za mana vavapodekedi ara ria na zazae tinoni pa rane pa ngenari? Ae tinoni veveidi ria? ");
INSERT INTO ghn_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ria na zazae tinoni pa rane pa ngenari za qari varitoto vei tugu ria na koburu qari kole nyumu leleodia pa ia makemaketina. Ko qari kole varivarikuku karovo, ari qari gua vei, <Gami mikedi gami ria na kera varielava, ba gamu gamuke peka tu. Gami keradi gami ria na kera uke, ba gamuke lukana romaroma tu za gamu!> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Totonai za lame i Jone Paputaiso za madi ko zake tekuteku beto ko zake buku vaini aza, nari ari gamu gua vei za gamu, <Za kolea na tomete ikikerena zana!> gamuguni. ");
INSERT INTO ghn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ego totonai za lame mule za na Tuna na Tinoni ko za tekuteku beto za buku aza, nari za ari mule gamuguni vei, <Dogoro! Na ngoja mota beto na tinoni bukubukuna zana, beto na baere tadiria na tinoni tekuteku takisi beto ria na tinoni seladi zana!> gamu gua mutugu. ");
INSERT INTO ghn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ba na tavagigala tana Tamaza za ulule gu pa roiti uana tadiria na tinoni qari tutia,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ego za beto gu za vei zara beto za sorua maka Parese i Jisu ko mi lao tekuteku tavitia pa nana ruma za gua. Ko za lao tugu pa ruma tana i Jisu, ko za kole tekuteku tavitia aza. ");
INSERT INTO ghn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ego ko na suverena tugu pa guguzu aza za maka reko za toani na toa selana. Tonai za nongoroni aza i Jisu za korapa tekuteku pa ruma tana Parese za pogozia aza za maka jaqi alabasita za pugelia na lumu omanga lea. ");
INSERT INTO ghn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Za pogozo lao turu lukalukana pa liguna i Jisu tata pa nenena, beto za vaoni taridi na kolo matana aza za kori nenena i Jisu, beto za puqa vapidilidi na vurunguna. Beto za aoria za na nenena i Jisu, beto za vuva taridi na nenena i Jisu za na lumu omanga lea. ");
INSERT INTO ghn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Totonai za batia na Parese za vei aza zara, za ari za gua golomo makana, <<Bi vei maka tinoni korokorotai zozoto za na bangara ani, za bi tori gilagilainana tu ae reko veveina za za korapa ulia aza zana ura na reko selana zana!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nari za paranga lao i Jisu tana, <<Saimone! Ara qa nyorogua pojanigo maka zava,>> za guni. <<Ego tu ao Tinoni varivagigalai, mu pojai tu,>> za gua i Saimone. ");
INSERT INTO ghn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nari za parangia i Jisu aza, ari za guni vei, <<Koledia za kori tinoni poredia lipulipu tana maka tinoni kolenana poata. Maka ari kori za ka lima gogoto poata siliva, goto maka za ka limangavuluputa. ");
INSERT INTO ghn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ba ari kori doru za qarike boka vaukea na dia lipulipu ko za taleozodi gu na tinoni kolenana poata ari kori beto za anyu paledi gu za na dia lipulipu. Ego ko ae ari kori ari za qu roquroqua ao za pala mina roquroqu vitivitigia za na tinoni kolenana poata?>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nari za oe lao i Saimone, ari za gua vei, <<Pana roverove taqu za aza za lavata jola na nana lipulipu ba za taleozoni na tinoni kolenana poata,>> za gua. <<Qu zotomua tugu ao,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Beto za balinga mule za tana reko, ko za paranga laoa i Saimone, <<Qu batiamua za na reko ani? Qu soruziu ara ao, ba totonai qa luge lame pa mua ruma ara, za quke vaniziu na pie ao ko ba loqaria na nenequ. Goto na reko ani za za vatubuluni na kolo matana za kori nenequ beto za puqa vapidilidi na vurunguna. ");
INSERT INTO ghn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ao za quke ao vakamuziu ara, goto na reko ani za totonai vei qa kamu ara pani za oqoro beto aoria na nenequ. ");
INSERT INTO ghn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ao za quke lumuni na oela olive na batuqu tonai qu vakamuziu, goto aza za vuva tataridi na lumu omanga lea pore vaina za na nenequ. ");
INSERT INTO ghn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ko ara ari ma poja veinigo ao Saimone: ria na sela tana qari kubo jola za qari tori taleozo beto tu, ko na nana roquroqu za roiti votuni aza taqu za uleni za za tori taleozo tu aza. Ba aza zake kubo nana sela za taleozo za nake lavatana tugu za nana roquroqu za roiti votuni,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Beto ari za guni vei i Jisu za na reko, <<Qari tori taleozo tu ria na mua sela,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Totonai qari nongoria ria na tinoni qari somana tekuteku pa tevolo za paranga vei zara aza za qari kole qumiqumi gologolomo, ari qari gua vei, <<Ae na tinoni veveina ani ko na sela ba za taleozodi?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Beto ari za guni vei i Jisu za na reko, <<Na mua rangerange za tori alogo tu. Mu lao pa bule,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ego za jola gu za vei zara za rerege taraeni i Jisu pa guguzu lavalavata beto na pekipekidi za na nongoro leana na veveina na binangara tana Tamaza. Ko ari ka manogori nana sepele ba qari tutia tugu aza, ");
INSERT INTO ghn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","beto ko vei tugu ria kaki reko za iju paledi na tomete ikikeredi pa dia toa aza beto za salanaria tugu kaki dia vagauru. I Mere na koko veina pa guguzu Magadalene za maka, aza perangaina qari kolea mae ka vitu tomete ikikeredi ba za iju paledi tugu i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Goto i Joana za maka, na maqotana i Kuza na nabulu ti Herodi; maka i Susana, beto ko kubo mule ria na reko. Ko ria ari za qari varoitiria na dia izizongo ko qari tokatokani i Jisu beto ria na nana sepele. ");
INSERT INTO ghn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ego ria na tinoni pa okokoto guguzu za qarike koroto kamukamu ti Jisu. Ko totonai za varikamu lame tana za maka minete tinoni lavata, za pojai aza za na vavakato vavapada ani: ");
INSERT INTO ghn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","<<Kolenana za maka tinoni umuma za keni vavuvuzuria na kiko pa nana inuma. Ko totonai za kole iparadi na kiko aza nari za kaki za qari lotu lao pa lodaka zona ko qari teteria na tinoni, beto ko qari tatava kamu tobiki betoriagedi na manugu. ");
INSERT INTO ghn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kaki za qari lotu lao pa pezo patupatuna, ko tonai qari pidoko zae za qari malei ukedia ura za pidili kepore piena za na pezo pa ia aza. ");
INSERT INTO ghn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kaki kiko mule za qari lotu lao pa gazogazoro varivarioka, ko qari toa tavitiria tugu na gazoro varivarioka, beto ko za pilu vaukeria aza. ");
INSERT INTO ghn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Goto kaki kiko za qari lotu lao pa pezo leana, ko qari toa valeana beto qari vua valeana ko za vunguvungu gogoto na vuana,>> za gua i Jisu. Pa liguna aza za ari za paranga viva veidi, <<Na tinoni za pore talinga nongonongorona za mi vainongoro valeana,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ego qari lao nanazia ria na nana sepele na za ginuana za na vavakato vavapada ani, ");
INSERT INTO ghn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","nari ari za gudi vei, <<Gamu gamu tori taiani tu za na gigalai golomona na veveina na binangara tana Tamaza, goto ria na goto tinoni za qari tavagigalai pa vavakato vavapada ria, ko mari dogodogorodia, ba marike batia; mari nongonongorodia, ba marike vakaberia,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","<<Ego na ginuana na vavakato vavapada ani za ari za vei: na kiko za na paranga tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ria na kiko qari lotu lao pa lodaka zona za ria na tinoni qari nongoriadia tugu na paranga tana Tamaza, ba za lame na bangaradi na tomete ko za teku paleni za na paranga aza za kole pa bulodi, keta mari vazozoto ko mari taalo za gua. ");
INSERT INTO ghn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ria na kiko qari lotu lao pa pezo patupatuna za ria aza tugu qari nongoria na paranga tana Tamaza nari qari teku vakatapia pa qeraqera. Ba zake kori gore vamauru vei na bagere, ko qari vazozoto mae iapeki totozo ba totonai za lame na toketoke ko za podekeria za qari lotu kenidia. ");
INSERT INTO ghn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ria na kiko qari lotu lao pa ia za kolea na gazoro variokana za ria qari nongoriadia tugu na paranga tana Tamaza, ba tonai qari korapa lalaodia nari na takulangadi na roquroqudi na izizongo beto na qeraqera goborodi pa toa kasia guguzu za piluria ko qarike boka vua vamatua. ");
INSERT INTO ghn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Goto ria na kiko qari lotu pa pezo leana za ria na tinoni qari nongoria na paranga tana Tamaza ko qari kopu valeanani pa bulodi beto qari turu vangaju ko qari vua valeana,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","<<Kepore za maka tinoni za vatoai na juke beto za vaopo tarini na besini babi vaturua pa kauru sape putaputana za na juke, goto pa nana nyumunyumuna tu za vanyumuni, ko ria na tinoni mari luge lame za mari batia na kabere. ");
INSERT INTO ghn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Doru zakazava qari kole vapae za pala mari tabata votu, beto doru zakazava qari kole golomo za mari votu lame pa kabekaberena. ");
INSERT INTO ghn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ko zara za vei za mu dogoro valeania na zona gamu vainongoroni na paranga tana Tamaza. Ura aza na tinoni za izongo vazoku za pala na motana mule za pala mina taiani. Goto aza zake izongia maka zava za aza tu za rove veini za izongia ba mina tateku vakenini tugu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ego za lame ti Jisu za na tinana beto ko ria na boko taina marene, ba qarike boka kamua aza ura za mota jola na minete tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ko maka ria na tinoni za lao pojani i Jisu, <<Na tinamu beto ria na taimu marene za rari, qari korapa turu adonigo pa sebesebe. Qari nyorogua dogorigo qari gua,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ba za oeria i Jisu ria, ari za gudi vei, <<Ria qari nongoria na paranga tana Tamaza ko qari vatabea za ria za na tinaqu beto ko na taiqu marene ara,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Maka rane tonai za zae pa koaka i Jisu beto ria nana sepele nari ari za gudi vei ria na nana sepele, <<Aria ko ta karovo lao pa maka kale karovona na ovuku Qalili,>> za gudi. Nari za qari toka lao. ");
INSERT INTO ghn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Totonai qari korapa epepe lalaodia ria nari za kole ko za putagana i Jisu. Beto za gore raja pa kolo aza za na gava lavata, ko za pugelia na kolo za na koaka ko tata bari dururu. ");
INSERT INTO ghn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nari qari lao vaiqolia ria na sepele i Jisu, ari qari gua vei, <<Qokolo, Qokolo, taqe tata uke za gita!>> qari guni. Nari za tatakole i Jisu ko za tokea za na gava beto na ololobagea, nari qari nogoto ko za bule emese za na kota. ");
INSERT INTO ghn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Beto ari za gudi vei i Jisu ria na nana sepele, <<Kepore na miu rangerange za gamu?>> za gua. Nari qari gabara beto qari matagutu ria, ko qari kole varivariparanga makadi, <<I zei tu za na tinoni ani? Ko tonai za parangaria na gava beto na kolo nari qari nongoria tu!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ego pa liguna za vei zara za qari epe gore paro pa guguzu pa Qerasini pa maka kalena pa ovuku Qalili. ");
INSERT INTO ghn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Aza tugu za tete paro i Jisu pa paroparona pa guguzu aza za gore tugu za maka tinoni aza za kolea na tomete ikikeredi ko mi lao gozoria aza za gua. Na zovai jolana na gadogadona za na tinoni ani, ko zake suvesuvere pa ruma goto pa bevi varivarigolomodi tu. ");
INSERT INTO ghn_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Aza tugu za dogoro laoa aza i Jisu za uui, za lao nyumu sori tungutungu pa moena i Jisu, ko za kuku velavela vei ari, <<Na za qu nyorogua roitini taqu ao Jisu na Tuna na Tamaza ululuna jola? Qa tepago ara ao, muke vakilasaniziu na vitigi!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Zara za paranga vei aza, ura perangaina tu za ijua i Jisu za na tomete ikikerena ko mi votu keni tana tinoni aza za guni. Ura kubo totozo za vavavituluni na tinoni ani za na tomete ikikerena. Ko ae tu qari piu veini na seni na limana nenena beto qari kole kopu veini maka tinoni tavalugena pa ruma varipiu, ba za korokoroto paledi tugu za na seni beto za toka keni pale na tomete ikikerena pa qega aza. ");
INSERT INTO ghn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Za nanaza laoa i Jisu za na tinoni ani, <<I zei na izongomu ao?>> za guni. Nari ari za gua vei, <<I Zokuvuro,>> za gua, ura qari zoku ria na tomete ikikeredi qari lugea na tinoni ani. ");
INSERT INTO ghn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ko qari kole tepa tokatoka i Jisu ria na tomete ikikeredi, ko keta mi garunu laodi pa ia ketakoi mari tavakilasa ria na ongongu ikikeredi qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ego zake zou pa ia aza za maka godo borogo lavata, qari korapa nyubenyubele ganiganigedi pa maka kalena na kubo. Ko qari tepa tokatokai ria na tomete ikikeredi i Jisu ko mi vamalumuria ko mari lao lugedia tadiria na borogo qari gua. Nari za vamalumuria tugu. ");
INSERT INTO ghn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ko qari votu keni tana tinoni ani ria na tomete ikikeredi, ko qari lao lugedia tadiria na borogo. Nari za qari tulai gore na taba za na godo borogo ari ko qari gore tuluzu pa kolo ko qari kuju uke betodia. ");
INSERT INTO ghn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ego ria na tinoni qari kopudi na borogo za totonai qari batia za vei zara nari za qari uku. Qari lao vavakato vadi ria pa guguzu beto ria na tinoni pa varilivutaina na guguzu aza. ");
INSERT INTO ghn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nari qari votu lao ria na tinoni ko mari dogoria aza na manugu za podo qari gua. Tonai qari kamu ti Jisu za qari batia za na tinoni aza za kolea na tomete ikikerena za tori tasalana tu. Ko za korapa nyumu valeana nana pa kekere nenena i Jisu aza, za tori vazae poko tu, beto za tori tavagigala tu. Ko qari matagutu beto ria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ko ria na tinoni qari batini matadi na manugu za podo beto aza vei beto za tasalana za na tinoni aza, za qari vavakato vadi ria na tinoni qari koni kamu. ");
INSERT INTO ghn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nari qari tepai ria na tinoni pa Qerasini i Jisu ko mi iolo rijo pa ia ketakoi qari guni, ura qari matagutu vitivitigini. Nari za qaqiri lao pa koaka i Jisu ko za mule keninana. ");
INSERT INTO ghn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ba tonai za oqoro toka i Jisu za lao kole tepa tuti ti Jisu aza na tinoni za koni tasalana ani, ba za garunu mulea i Jisu aza, ari za guni vei, ");
INSERT INTO ghn_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","<<Mu mule lao pa mua guguzu, ko mu vavavakatoni aza vei za roiti vanigo na Tamaza,>> za guni. Nari za mule lao za na tinoni ani, ko za velavelani aza tadiria doru pa nana guguzu aza vei za roitini i Jisu tana. ");
INSERT INTO ghn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Totonai za gabala mule lao kamu pa maka karovona na kolo i Jisu, za qari adono vakamua ria na tinoni aza. Ura qari kole tugu adonia ria doru tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pana totozo tugu aza za bola kamu gu za na kuta tinoni matamata pa ruma varivarikamuna, na izongona i Jaerasi. Za lao nyumu sori tungutungu pa nenena i Jisu aza, ko za tepa tokatokai ko mi lao pa nana ruma za gua, ");
INSERT INTO ghn_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ura makamakaina tuna reko peki tata manogori aorona za mi uke gu za gua. Ego totonai za korapa rerege lalaonana i Jisu za qari jupejupe varikaleni ria na minete tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na somanana tugu pa varikamu minete tinoni aza za maka reko za keni gojo na orungu pa tinina ka manogori aoro. Ria doru vei za izongoria za tori gona pale betodi tu pa nyaqodi ria na tinoni varivarisalana, ba kepore maka ria bi boka salania. ");
INSERT INTO ghn_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ko za somana rerege tuti pa liguna i Jisu aza. Ko aza tugu za lao ulia za na uquna na poko ti Jisu, nari za totonai tugu za nogoto keni za na orungu. ");
INSERT INTO ghn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tonai za nanaza i Jisu, <<I zei za uliziu ara?>> za gua aza. Ba qari oso ria doru, <<Ura! Nake gami!>> qari gua. Nari ari za gua vei i Pita, <<Qokolo, qu batiamua ao ko na varikamu tinoni za qari jupe varilivutainigo zara!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ba ari za gua vei i Jisu, <<Dai, maka tinoni za uliziu ara, ura qa vagilagilai ara pa tiniqu za za votu taloi taqu za na neqi,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Totonai za gilagilai na reko za tori tavotu tu za na roiti za roitini aza za gua, nari za matagutu neqeneqere vitivitigi aza, ko za lao nyumu sori tungutungu pa nenena i Jisu, ko za ule votuni aza ti Jisu pa moedi ria doru tinoni za aza vei beto ko za ulia na poko ti Jisu beto veveina zake oriavo tugu tasalanana aza. ");
INSERT INTO ghn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nari ari za guni vei i Jisu aza, <<Tuqu, na mua rangerange za tori salanigo tu. Mu lao pa bule,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Totonai tugu za korapa paranga vei zara i Jisu nari za bola kamu gu za maka tinoni pogozo nongoro, na koko lame veina pa ruma ti Jaerasi na tinoni matamata pa ruma varivarikamuna, ko ari za gua vei, <<Za tori uke tu za na tumu reko. Keta vapavu lame goboria na tinoni varivagigalai,>> za guni i Jaerasi. ");
INSERT INTO ghn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ba tonai za nongoria i Jisu za na vavakato tana tinoni pogozo nongoro, nari ari za guni vei i Jaerasi, <<Muke matagutu. Mu vazozoto gu beto pala mina leana gu za na tumu,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Totonai za lao kamu aza pa ruma ti Jaerasi, za zake vamalumuria aza ko mari luge tavitia ria na tinoni, goto ari Pita, i Jone, i Jekopi, beto ko ari kori tinana na tamana gu na reko. ");
INSERT INTO ghn_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ria doru tinoni za qari korapa romaroma qari lukana takulangania na koburu za uke. Nari ari za gudi vei i Jisu ria, <<Muke lukana! Zake uke za na koburu zana, za korapa putagana gu,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tonai za paranga vei zara aza nari za qari aauni ria doru aza, ura qari gilagila valeaniadia za tori uke tu za na koburu reko. ");
INSERT INTO ghn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ba za arua i Jisu za na limana na koburu beto za paranga, <<Ngore, mu tatakole!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nari za toa mule ko zake oriavo tugu tatakolena za na koburu ko za garunuria i Jisu ria ko mari vani na ganigani ko mi tekuteku za gua. ");
INSERT INTO ghn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ko qari gabara vitivitigi ari kori na tamana beto na tinana, ba za paranga vabalauria i Jisu ria ko marike vavavakatoni pa tinoni aza vei na roiti za taroiti. ");
INSERT INTO ghn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ego za kuku varikamudi i Jisu ari ka manogori sepele, ko za vadi na neqi ko mari ijiju pale tomete ikikeredi beto mari salanaria ria za vairia na mo za gua. ");
INSERT INTO ghn_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Beto za garunuria tugu vei ria ko mari taraeni na binangara tana Tamaza, beto mari salanaria ria qari mo za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Beto ari za gudi vei, <<Munake pogozia maka za pa miu rerege lao, munake pogozo kolu opopatana, na mane, na besa, na poata beto ko munake pogozo vakori soti. ");
INSERT INTO ghn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ketakoi mari tavaragua vatogagamu ko mari vasuveregamu za muna suvere gu pa ruma aza, tinganai muna taloi keni pa guguzu aza. ");
INSERT INTO ghn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ketakoi marike tavaragua vatogagamu ria na tinoni za muna turu loi pale za na guguzu aza. Tonai muna taloi keni za muna tavuzu paledi za na kavuruna na pezo pa guguzu aza qari ramata pa nenemiu. Ko aza za na vinagilagilana pala mina vakilasaria na Tamaza ria,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ego ko qari taloi keni ria na sepele, ko qari rerege lao pa doru guguguzu, qari taraeni na nongoro leana beto qari salanaria ria qari mo pa doru kota qari lao vei. ");
INSERT INTO ghn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ego totonai za nongoroni i Herodi, na bangara pa Qalili, ria doru zakazava za roitidi i Jisu, za rura betonana aza. Ura qari pojani ria kaki tinoni za i Jone Paputaiso za tori toa mule tu qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ria kaki mule za qari paranga za i Elaija za tori bola tu qari gua, goto kaki ria za qari paranga za maka ria na tinoni korokorotai pa moa za tori toa mule tu qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ari za gua vei i Herodi, <<I Jone za qa tori kujuku pale tu na batuna ara. Goto i zei za na tinoni aza za roitidi doru ginugua qa nongorodi ari?>> za gua aza. Ko za nyoroguani aza ko bi batia i Jisu za gua. ");
INSERT INTO ghn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ego tonai qari mule kamu ria na tinoni tagarunudi za qari vavakato vani i Jisu doru zakazava qari roitidi. Nari za tokaria aza ria ko qari lao pa maka ia kaloina pa maka guguzu na izongona pa Betiseda. ");
INSERT INTO ghn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ba totonai qari gilagilai ria na minete tinoni za ketakoi za lao vei, za qari tuti laoia ria i Jisu. Nari za vakamu valeanaria tugu aza ria, za taraeni tugu aza tadiria za na veveina na binangara tana Tamaza, beto ko za salanaria tugu ria qari mo ko qari nyorogua tasalana. ");
INSERT INTO ghn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ego totonai za podalai gore za na veluvelu, za qari lao tana ari ka manogori sepele ko ari qari guni vei, <<Mu garunu vakeniria pa guguzu lavalavata beto pekipekidi pa vailivutaina ria na tinoni, ko mari boka nyaqogedi ganigani beto mari nyaqoa ketakoi mari puta. Ura na ia taqe korapa suveria ani za na qega ko za kepore maka zavana,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nari ari za gudi vei i Jisu ria, <<Gamu gu za mu iadi na tekutekuna!>> za gua. Nari ari qari gua vei, <<Kepore mutugu za maka za babi vagaroa goto aza tugu ka lima bereti beto kori igana moqamoqazadi gu za qari kole ari! Ko ae vei? Qu nyoroguadigami ao ko mami lao vai vadi na ganigani gami ria na minete tinoni lavata ari?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Ura za pada vei ka lima vuro za na ngutidi ria na marene gu.) Nari ari za gudi vei i Jisu ria na nana sepele, <<Mu vanyumu okoto bokobokoria ria na tinoni padapada vei ka limangavulu pa maka pukuna,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ego ko tonai qari beto vanyumu betoria ria na sepele ria na tinoni, ");
INSERT INTO ghn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","za tekuria i Jisu za ka lima bereti beto kori igana, ko za enga zae pa noka ko za manadi, beto za kipakiparia, beto za vadi ria na nana sepele, ko ria qari iaria ria na minete tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ko qari tekuteku ko qari pote beto ria doru, beto za qari buti kura vapugeledi na kipakipa ganigani kole joladi ria na sepele za ka manogori topa lavatadi. ");
INSERT INTO ghn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ego maka rane totonai za korapa varavara makana i Jisu, za qari lame varikamuni ria na nana sepele. Nari za nanazaria i Jisu ria, <<I zei qari guniziu ria na minete tinoni ara?>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nari qari oea ari qari guni vei, <<I Jone Paputaiso ao qari gua, goto kaki za i Elaija ao qari gua, goto kaki mutu za maka ria na tinoni korokorotai pa moa ao qari gua,>> qari gua ria na sepele. ");
INSERT INTO ghn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nari za nanazaria mule aza ria, <<Goto gamu za i zei gamuguniziu ara?>> za gudi. Nari za oea i Pita aza, ari za guni vei, <<Ao tugu za na Karisito tamijatana tana Tamaza!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Beto za naquria beto za paranga vaneqineqidi i Jisu ria na nana sepele ko marike tori vavakatoni tu tadiria na tinoni za na veveina aza za na Karisito za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ko za pojadi mutugu ria, <<Na Tuna na Tinoni za pala mina gozororia zoku vitigi, beto mari kilu pale ria na tinoni matamata, na kuta iama beto ko ria qari varivagigalaini na Vavanau. Pala mina tavauke aza ba pa rane vinaue za mina tavatoa mule,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Beto za paranga laoria ria doru aza, <<Na tinoni za nyorogua tutiziu ara za mi kilu pale tu za nana toa makana, ko mi pogozia na nana korosi doru rane ko mi tutiziu ara. ");
INSERT INTO ghn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ura na tinoni za nyorogua kopu vasareni nana toa makana za pala mina saivia tugu za nana toa. Goto na tinoni zake rabekeni nana toa pa nana tutiqu ara za aza za mina aloa nana toa. ");
INSERT INTO ghn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ura na za mina boka vagavoria na tinoni bi gona pale na nana toa ko bi izongia na kasia guguzu doruna? Bi julingai tu! ");
INSERT INTO ghn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Na tinoni za keaniziu ara beto na qua paranga za na Tuna na Tinoni ba mina keani tugu aza totonai mina lame aza pa nana neqi lavata, pa neqi tana Tamaza beto tadiria na mateana tabuna. ");
INSERT INTO ghn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ma poja zozotodigamu ara za gamu: kaki gamu gamu korapa suvere ari za mari oqoro uke tinganai mari batia na binangara tana Tamaza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ego pa liguna za pojaria aza za na zakazava ari ko pa vinavesu rane, za tokaria aza ari Pita, i Jone, beto i Jekopi ko qari zae pa kubo ko za kole varavara. ");
INSERT INTO ghn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ko totonai za korapa varavara aza, nari za dogoro goto za na izumatana beto na nana poko za keka valavalaka. ");
INSERT INTO ghn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Beto ani! Kori tinoni ari Mosese i Elaija ");
INSERT INTO ghn_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","qari bola votu pa leo kabere noka ko qari kole paraparangia i Jisu ko qari kole vavavakatoni ari kori ti Jisu za na zona vei beto mina taloi aza za tata pala mina gore votu pa Jerusalema. ");
INSERT INTO ghn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","I Pita beto ari kori sepele tavitina za tori ngaoloria tu na nyoroputa, ba qari iqolo ria ko qari batia za na tinina i Jisu za kabere beto ko vei tugu ari kori tinoni qari turu tavitia aza. ");
INSERT INTO ghn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ego ko totonai qari korapa iolo taloi ti Jisu qari gua ari kori, za paranga lao ti Jisu i Pita, <<Qokolo, za leana jola za gami suvere pani gami! Ko mami roitini kue aqaqo ropi, ko maka tamu, maka ti Mosese beto maka ti Elaija, uve?>> za gua. Ba zake gilagila valeania i Pita za na manugu za korapa pojai aza. ");
INSERT INTO ghn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Totonai za korapa tugu paranga vei zara i Pita za lame gu za maka lei ko za amu vapaeria ria doru, ko qari matagutu ria na sepele totonai qari luge zae pa lei ari Mosese i Elaija. ");
INSERT INTO ghn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Beto maka mamalaingi za votu lame vei pa lei, ari za gua vei, <<Ani za na Tuqu aza qa mijatia ara. Mu nongoria aza!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Totonai za nogoto na mamalaingi, za i Jisu gu makana za suvere jola. Qarike izongo vavavakatoni tugu ari ka viza sepele ari tadiria tinoni veveidi ria doru ginugua qari batiria ari. ");
INSERT INTO ghn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ego ko za rane na kota za taloi mule gore koko pa kubo i Jisu beto ari kue sepele, za maka minete tinoni lavata za gore gozoria i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ko maka tinoni pa varikamu tinoni aza za kuku velavela, ari za gua vei, <<Tinoni varivagigalai! Qa tepa vitivitigigo ara ao ko mu lame mae dogoria na tuqu marene, ura aza tugu maka tuqu makamakaina aza. ");
INSERT INTO ghn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Za lugea na tomete ikikerena, ko lao vei za kamua za kukuku vasiboro, beto za gonagona pedalani pa pezo ko za dadao tu na ngujuna. Ko za aru vavitivitigi paleni mae tu beto za taloi tana za na tomete ikikerena. ");
INSERT INTO ghn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Qa tori pojadi tugu ria na mua sepele ko mari iju paleni za na tomete ikikerena qa gudi, ba qarike bokai,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nari za oea i Jisu aza, ari za guni vei, <<Koi, na zazae tinoni kepore miu rangerange beto na ikikeremiu za gamu! Ae tu mina koi vei zovaina za mana suvere tavitigamu beto mana tapatianadigamu ara? Ao mu toka lameni taqu za na tumu zana!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ego ko totonai za korapa rerege lao za na koburu, za vakamu vaikikeria mule, ko za gona pedalani na tomete ikikerena pa pezo ko za neqeneqere beto za garata tu. Ba za lao i Jisu ko za iju paleni za na tomete ikikerena, ko za salania za na koburu marene, beto za vamule lao vani na tamana. ");
INSERT INTO ghn_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ko qari gabara betoni ria doru tinoni za na neqi lavata tana Tamaza. Totonai qari korapa gabarani ria na tinoni za na veveidi doru zakazava za roitidi i Jisu, nari za ari za gudi vei ria na nana sepele, ");
INSERT INTO ghn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","<<Gamu mu nongoro vakoititiria ria na paranga mana ule vadigamu ari. Na Tuna na Tinoni za pala mina tavakarovo lao pa limadi ria na tinoni,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ba qarike vakaberia ria na sepele za na ginuana na paranga za pojai aza. Za tavapae tadiria za na ginuana, ko qarike gilagilai, beto ko makadi ba qari pangaga nanazani za na ginuana na paranga za pojai aza. ");
INSERT INTO ghn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ego maka varitoke na veveina i zei za na poreveveina jola qari gua za poraka votu pa varikorapaidi ria na sepele. ");
INSERT INTO ghn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ba za tori gilagilainana tu i Jisu za aza qari roquroqu vei pa bulodi ria, ko za aru tekua aza za maka koburu peki ko za vaturua pa kekerena, ");
INSERT INTO ghn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","beto ari za gudi vei ria, <<Na tinoni za vakamu valeania pa izongoqu ara za maka ria na koburu vevei ani, za vakamu valeanaziu tugu aza ara. Beto na tinoni za vakamu valeanaziu ara za vakamu valeania tugu aza aza za garunuziu ara. Ura aza za kepore veveina joladigamu gamu doru za aza tugu za poreveveina jola,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Beto za oe i Jone, ari za gua vei, <<Qokolo, maka tinoni za gami batia gami za ijiju pale tomete ikikeredi pa izongomu ao, ko gami pojani gami aza ko mi nogoto gamiguni, ura zake somana tavitigami gami pa tutimu ao aza,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nari ari za guni vei i Jisu aza, <<Muke vanogotia! Ura na tinoni zake kanagamu za kole vei pa miu kalena,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ego totonai za adanga lame na totozo beto mina mule zae pa noka i Jisu, nari za vanyumu valeania za nana roquroqu ko mi zae pa Jerusalema za gua. ");
INSERT INTO ghn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Za garunu momoe laodi aza ria kaki nana tinoni pogozo nongoro ko qari lao pa maka guguzu pa Sameria ko mari vatana momoe vani za ketakoi mari vajola bongi tonai mari kamu ketakoi za gua. ");
INSERT INTO ghn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ba qari daidia vakamua ria pa guguzu aza aza, ura qari gilagilaidia ria za pa Jerusalema tu za korapa gore vei aza qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Totonai qari nongoria ari kori nana sepele, na izongodi ari Jekopi i Jone, za vei zara za ari qari gua vei ari kori, <<Bangara, vei leana muna gua ao, za mu kuku vagore lageria na iku pa noka ko mi vurungu beto paledi ria na tinoni ketakoi!>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ba za balinga i Jisu ko za tokeria ari kori. ");
INSERT INTO ghn_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Beto za rerege jola laonana pa maka goto guguzu i Jisu beto ko ria na nana sepele. ");
INSERT INTO ghn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Totonai qari korapa rerege lalaodia pa zona za lame za maka tinoni ko za parangia i Jisu, ari za gua vei, <<Ara mana tutigo doru kota muna lao vei ao,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nari ari za guni vei i Jisu aza, <<Ria na pokese za kolenana na dia baongo, beto ria na manugu tatava za kolenana na dia vorivori, goto na Tuna na Tinoni za kepore na nana ia mina kole minyere,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Beto ari za guni vei aza za maka goto tinoni, <<Ao mu lame tutiziu ara,>> za guni. Ba ari za gua vei za na tinoni aza, <<Bangara, mu vamalumuziu ko ma mule golomia mae na tamaqu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nari ari za guni vei i Jisu aza, <<Mu loiria ria na ukedi ko mari varigolomo makadii. Goto ao za mu lao ko mu taraeni na binangara tana Tamaza,>> za guni i Jisu aza. ");
INSERT INTO ghn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Beto za ari mutugu za gua vei za maka goto tinoni, <<Bangara, ara za mana tutigo ao. Ba mu vamalumuziu mae ko ma mule lao loloiria ria pa qua tatamana,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ba ari za guni vei i Jisu za na tinoni aza, <<Na tinoni za tori aru tamana tu pa geligelini pezo taragatana beto za balibalilanga za zake pada pa binangara tana Tamaza aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ego pa liguna za vei ari za mijataria mule i Jisu ari ka vitungavulu kori tinoni, ko za garunu vakeniria, korikori tinoni pa maka reregena, ko mari lao momoe pa guguzu beto pa ia ketakoi mina laoria aza za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ko za pojadi i Jisu ria, <<Za matua nyanyalu za na vuvua, ba ria na tinoni ababu za qari vizaviza gu. Ko mu varavara lao tana aza za bangarani na vuvua, ko mi garunu laodi na tinoni roiti ko mari ababu pa nana inuma. ");
INSERT INTO ghn_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mu lao za gamu! Dogoro! Qa garunu lao veidigamu na tudi na sipi pa varikorapaidi ria na vulupu pirudi ara za gamu. ");
INSERT INTO ghn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Muke pogozo vakori kurakurani poatana, babi na mane, na sadolo, beto muke vavakato vajola goboro totozo tadiria na tinoni muna gozoro qeraqeradi pa zona. ");
INSERT INTO ghn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Tonai muna luge za gamu pa maka ruma, za momoe ari muna paranga vei, <Na bule beto na mana tana Tamaza mi somana tadigamu pa ruma ani!> muna gua. ");
INSERT INTO ghn_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Vei mina korapa suverenana pa ruma aza za maka tinoni bulebule nari za mi kole tana za na mana gamu tepa vani. Goto vei minake pore za maka tinoni bulebule za pala mina mule gu tadigamu za na mana aza. ");
INSERT INTO ghn_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ko aza tugu pa ruma qari vatogagamu za muna suvere, ko muna tekuria beto muna bukuria ria vei mari kaqamadigamu ria, ura na tinoni roiti za pada tugu mina tekua na tabarana. Munake leko varikarovai ruma tinganai muna taloi keni pa guguzu aza. ");
INSERT INTO ghn_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Totonai muna lao kamu za gamu pa maka guguzu ko mari vakamu valeanagamu, za muna tekuria tugu ria na ganigani qari vatana vadigamu, ");
INSERT INTO ghn_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","muna salanaria ria qari mo pa guguzu aza, beto ari muna poja veidi, <Na binangara tana Tamaza za mi togagamu za gua,> muna gudi. ");
INSERT INTO ghn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Goto totonai muna lao kamu za gamu pa maka guguzu ba barike vakamugamu, nari za muna rerege votu lao pa zona, ko ari muna gua vei, ");
INSERT INTO ghn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","<Za kamu tu pa kavuruna na pezona na miu guguzu qari ramata pa nenemami ba gami tavuzu paledi tugu. Ba muna roquroqua gamu za na binangara tana Tamaza za mi toga gu za gua!> muna gudi. ");
INSERT INTO ghn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ma poja valeadigamu ara za gamu: na vinakilasa mina gozoria na guguzu aza pa rane varituti za mina lavata jolani aza vei qari gozoria ria pa guguzu Sodomo,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","<<Mu takulangagemiu tu za gamu pa Korazini! Mu takulangagemiu tu za gamu pa Betiseda! Ura vei bi taroiti tadiria na tinoni karovodi pa Turosi beto pa Sidoni ria na roiti varivagabaradi qari taroiti tadigamu koviria, za pa moa tu bari gabala ko bari nyumu ora bilubiludi na kau beto bari pokodi na poko tarikarikatadi ria! ");
INSERT INTO ghn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ba gamuke gabala za gamu ko na vinakilasa muna gozoria gamu pa rane varituti za mina lavata jolani aza vei mari gozoria ria pa Turosi beto pa Sidoni. ");
INSERT INTO ghn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Goto gamu ka viza pa Kepaniami! Gamu rovea za gamu na poreveveimiu ko pala muna taovulu zae pa noka vavagalo gamu gua? Ba dai! Pala muna tagona gore pa kauruna na kasia guguzu!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","<<Na tinoni za nongorogamu gamu za nongoroziu tugu ara, beto na tinoni za kilu paledigamu gamu za kilu paleniziu tugu ara. Ko na tinoni za kilu paleniziu ara za kilu paleni tugu za na Tamaza aza za garunuziu ara,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ego ko qari mule kamu ari ka vitungavulu kori qari tagarunu vakeni, ko qari qeraqera jola, ko ari qari gua vei, <<Bangara, ria na tomete ikikeredi tu ba qari nongorogami tugu totonai gami iju paledi gami pa izongomu ao!>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nari ari za gudi vei i Jisu ria, <<Qa tori batia tu ara i Setani, za vei na kapi za lotu lagere koko pa noka. ");
INSERT INTO ghn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Dogoro! Qa tori vadigamu tu ara za na neqi, ko muna boka teteria gu gamu ria na dole beto na mede, beto muna vakilasa paledi tugu gamu ria doru neqi tana kana i Setani, ko kepore za maka zava mina apulugamu. ");
INSERT INTO ghn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ba muke qerani gu gamu za na veveina ria na tomete ikikeredi qari nongorogamu, goto aza tu muna qerani gamu za na veveina na izongomiu qari tori takuti tu pa noka,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ego ko pa totozo aza za vapugeleni qeraqera na Ongu Tabuna i Jisu, ko ari za gua vei, <<Tamaqu, ao na bangarana na oka beto na pezo! Qa paranga leana lao tamu ara, ura qu tori vabatidi tu ao ria na tinoni qarike boka ria vei qu golomodi ria na tinoni gigigalaidi beto na tinoni koridi. E, Tamaqu, pa mua roquroqu tugu ao za taroiti vei aza. ");
INSERT INTO ghn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Doru neqi beto na gigalai za tori vaniziu tu ara. Ko kepore za maka tinoni za gilagilai na Tuna goto na Tamana gu; beto kepore za maka tinoni za gilagilai na Tamana goto na Tuna gu beto ko ria gu za mijataria na Tuna ko mi vabatidi za gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ego tonai qari suvere makadi nari za balinga lao tadiria na nana sepele i Jisu, ko ari za gudi vei ria, <<Gamu tamana za gamu ko gamu batiria ria na zakazava gamu dogororia koviria! ");
INSERT INTO ghn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ura ma pojadigamu ara za gamu: kubo ria na tinoni korokorotai beto na bangara pa moa qari nyorogua vitivitigi dogororia na nongororia ria vei gamu batiria na nongororia gamu ari, ba qarike boka,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ego maka tinoni gigigalai pa Vavanau za turu lao nyorogua podekia i Jisu, ko za paranga aza, <<Tinoni varivagigalai, na za za mana roitini ara beto mana teku izongia za na toa jola?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nari ari za guni vei i Jisu aza, <<Na za za takuti pa Vavanau? Na za za qu tiroa ao ketakoi?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nari za oea na tinoni ani aza, ari za guni vei, <<Mu roquroqua na Bangara na mua Tamaza pa doruna bulomu, pa doruna mua toa, pa doruna mua neqi beto pa doruna mua roquroqu; beto mu roquroqua na tavitimu makamu aza vei qu roquroqu mule veinigo makamu za gua,>> za gua za na tinoni nari. ");
INSERT INTO ghn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nari ari za guni vei i Jisu aza, <<Na tuvizina za na oe tamu. Ko mu roiti vei gu aza beto za pala muna toa,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ba za nyorogua tadogoro vei na nana nanaza za na tuvizina za gua za na tinoni ani, ko za maka nanaza laoa mule i Jisu, <<I zei za na tavitiqu ara?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nari za vataqolia i Jisu za na nanaza tana, ari za gua vei, <<Kolenana za maka tinoni za taloi pa Jerusalema ko za rerege gore pa Jeriko. Pana korapana na nana rerege gore aza za qari raja vasiboria na tinoni raja ikikodi pa zona aza, qari ragata vagorea na nana poko beto qari ikoa nana poata, beto za qari maja vapalepalekia, beto qari loi vakole pale na tata ukena, beto za qari kenidia. ");
INSERT INTO ghn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pana totozo tugu aza za gore vei ketakoi za maka iama, ko totonai za batia na tinoni za tavapalepaleka za rerege paja keninana pa maka kale zona aza. ");
INSERT INTO ghn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Beto na zona mutugu aza za tokai gore za maka tinoni na butubutu Livai. Tonai za gore kamua za na ia ketakoi za korapa kole za na tinoni za tavapalepaleka ko za batia, nari za rerege paja keninana pa maka kale zona mutugu. ");
INSERT INTO ghn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Beto maka tinoni Sameria za rerege gore vei tugu ketakoi, za lao kamua za ketakoi za kole na tinoni palepalekana. Totonai za batia za roquroqu vitivitigia ko za nyorogua tokani. ");
INSERT INTO ghn_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ko za lao aza ko za vuva valaoni oela beto na vaini ko za piuria za na palekana. Beto za ovulu surana vaakea pa pokotona na nana dongiki, ko za tokai ko za lao vakolea pa maka ruma ketakoi qari suvesuvere minyere ria na tinoni rerege, ko za kopuni ketakoi. ");
INSERT INTO ghn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ego ko za rane na kota, za tekua aza za kori poata siliva ko za vani za na tinoni za kopuni na ruma, beto ari za poja veini, <Muna kopuni za na tinoni ani, uve? Beto vei kolenana mule za kaki za muna gona paledi ao pa kopuna aza, za pala mana soga vanigo ria tonai mana mule lame vei pani,> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ego, ko pa roverove tamu za i zei ari kue tinoni ari za vei na tavitina za na tinoni qari ngangangulia ria na tinoni raja ikikodi?>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nari ari za gua vei za na tinoni aza, <<Aza gu na tinoni za roquroqu tokani,>> za gua. Nari ari za guni vei i Jisu aza, <<Ego, ko ao ba mu lao, ko mu roiti vei tugu aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ego totonai za jokai na nana rerege i Jisu beto ko ria na nana sepele za qari kamua ria za maka guguzu, ko maka reko ketakoi na izongona i Mata za vatogaria pa nana ruma. ");
INSERT INTO ghn_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Na taina reko, na izongona i Mere, za kole nyumu tata pa kekerena i Jisu, ko za kole vainongorodi na varivagigalai ti Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Goto i Mata za kole tadunganadi beto za tapatianadi na zoku vinatana, ko za lao ti Jisu ko ari za guni vei, <<Bangara, ae vei za leana tugu tamu za loi tari vamakainiziu na roiti ninabulu ara na taiqu? Mu pojani ko mi lame tokoniziu,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nari za oea i Jisu aza, <<Mata, Mata! Qu takulangadi beto qu tadunganadi zoku ngavulu zakazava ao! ");
INSERT INTO ghn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ba maka gu za pada muna izongia, ko i Mere za mijatia aza na zakazava leleana jola. Ko minake tateku vakenini aza za na zakazava aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Maka rane za lao varavara pa maka ia i Jisu. Ko totonai za beto varavara, za lao za maka ria na nana sepele ko ari za gua vei, <<Bangara, mu vagigalaidigami na varavara maka moqaza podeke vei i Jone ba za vagigalaidi tugu na varavara ria na nana sepele,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nari ari za gudi vei i Jisu ria, <<Tonai muna varavara za ari mu gua vei: <Tamamami, Mi tapangaga za na izongomu liosona. Mu valamea na mua binangara. ");
INSERT INTO ghn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Doru rane mu vadigami na tekutekuna mami toani na rane aza. ");
INSERT INTO ghn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mu taleozodi ria na mami sela, ura gami ba gami taleozodi tugu ria qari roiti lame sela tadigami. Beto muke valaogami pa toketoke!> mu gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Beto ari za gudi vei ria na nana sepele, <<Vei maka gamu za bi lao na korapa bongi pa ruma tana nana baere, ko ari bi guni vei, <Qokolo, mu vaniziu mae kue batu bereti, ");
INSERT INTO ghn_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ura maka qua baere za korapa lekoni maka nana rerege za za koni kamu vasiboroziu, ko kepore na gequ ganigani mana vani!> bi gua. ");
INSERT INTO ghn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nari ari bi gua vei za na nana baere pa leo ruma, <Muke vaduviliziu, za tori pate tu za na atakamana, ko ara beto ria na qua koburu ba gami tori puta tu. Maneke boka tatakole lao vanigo aza vei qu nyoroguani ao,> bi gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ba ma pojadigamu ara za gamu: vei minake tatakole vani tu na bereti aza ura nana baere leana gu ke bi gua tu aza, ba pa ginuana keta mi kea taleni za pala mari pojai ria na tinoni mina gua, nari za pala mina tatakole gu za na tinoni za tori kole tu ani ko mina vani gu ria za nyoroguani na tinoni za tepa zana. ");
INSERT INTO ghn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ko za vei za ara ma pojadigamu gamu: mu tepa ko mi taiadigamu, mu nyaqo ko mu batia, mu kikia ko mi tarevanga vadigamu. ");
INSERT INTO ghn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ura na tinoni za tepa za za tekua tugu, na tinoni za nyaqo za za batia tugu, beto na tinoni za kikia za za tarevanga vani tugu. ");
INSERT INTO ghn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Gamu na tamadi na koburu za vei bi tepagana igana za maka tumiu, za ae vei pala muna vani na dole? ");
INSERT INTO ghn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Babi tepagana toruru aza, za ae vei pala muna vani na mede? ");
INSERT INTO ghn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Gamu na tinoni ikikeremiu tu ba gamu balaumiu vadi tugu na zakazava leadi ria na tumiu. Ko ae mina koi vei leana jola za na variia tana Tamamiu pa noka, ura aza za leana joladi ria na tinoni. Pala na Ongu Tabuna tu ba mina vadi ria qari tepa lao tana!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ego maka totozo za iju paleni i Jisu za maka tomete pokapokana tana maka tinoni ko totonai za votu keni na tomete za podalai paranga za na tinoni aza. Ko tonai qari batia za vei aza za qari gabara beto ria doru tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ba kaki ria za ari qari gua vei, <<I Beelizebulu gu, na bangaradi na tomete, za vani na neqi za boka ijiju paledi na tomete ikikeredi zana!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Goto kaki ria za qari nyorogua podekia i Jisu ko qari tepai aza ko mi roitini maka roiti varivagabarana, ko mari boka vazozotoa za na lame veina tugu tana Tamaza aza qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ba za tori gilagilarianana tu i Jisu za na dia roquroqu, ko ari za gudi vei, <<Na binangara za tapikapikata pa okokoto pukuna ko qari varivaripera mule makadi za pala mina tajegara. Beto na tatamana za pikata muleni ko mari varikana makadi ba mina tajegara tugu. ");
INSERT INTO ghn_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ko zara za vei ko vei na binangara ti Setani za bi okoto tapikapikata ko bari varivaripera makadi, za ae mina vei beto mina boka turu vamauru? Pala minake boka! Gamu paranga za gamu, <I Beelizebulu gu za vaniziu na neqi ara za qa boka iju paledi ara ria na tomete ikikeredi,> gamu gua. ");
INSERT INTO ghn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ego, vei bi zozoto tugu za pa neqi ti Beelizebulu tugu za ba iju paledi na tomete ikikeredi ara, za pa neqi ti zei za qari ijiju pale tomete ria na miu sepele makamiu za gamu? Mina vei zara za ria na miu sepele makamiu gu ba qari pitugamu za gamu sela tugu za gamu! ");
INSERT INTO ghn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ba ara za pa neqi tu tana Tamaza za qa iju paledi ria na tomete ikikeredi, ko zara za vei za kaberena gu za na binangara tana Tamaza za tori togagamu tu gamu. ");
INSERT INTO ghn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Tonai za vatana valeanani mae tu na tinoni neqi ria na nana zakazava varipera beto za kole kopu valeanani za na nana ruma, za marike boka tangangulu ria na nana zakazava. ");
INSERT INTO ghn_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ba totonai mina kamu mule za maka goto aza za neqina jolani za na tinoni neqi ani ko mina raja vakilasia, nari za mina boka teku vakeni betoni ria doru nana zakazava varipera za kole rangerangeria na tinoni neqi aza ko mina ia varipikataidi ria doru zakazava tana. ");
INSERT INTO ghn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Aza zake somana vei taqu za za taleziu ara aza, beto aza zake varikamu tokaniziu ara za za varipipiarai aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","<<Tonai za taiju pale za na tomete ikikerena tana maka tinoni, nari za reregia aza za doruna na qega kepore na piena, ko za kole nyaqoa na ia ketakoi mina boka minyere. Totonai zake boka batia aza za maka ia vei mina boka suveria, za paranga aza, <Ma mule soga gu pa qua ruma ketakoi qa suvere momoe ara,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ko totonai za mule kamu za batia za tori tasaqu valioso tu beto za tori tavatana valeana tu za na ruma. ");
INSERT INTO ghn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nari za mule keni aza ko za toka kamudi mutugu ari ka vitu tomete qari ikere jolani makana ko qari kamu kole tana tinoni aza. Ko pa liguna qari kamu kole ria za na toa tana tinoni aza za ikere jolani na totozo momoe,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ego totonai za korapa paranga vei zara i Jisu, za kuku votu pa varikamu tinoni za maka reko, ari za gua vei, <<Za tamana za na reko za vapidokigo beto za vasusugo ao,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nari ari za gua vei i Jisu, <<E, ba ria tu qari tamana jola za ria qari nongoria beto qari tutia na paranga tana Tamaza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ego tonai qari varikamuni ria na minete tinoni, za podalai paranga aza, <<Na zazae tinoni koviria za zake tuvizi! Qari nyoroguani bi taroiti mae tu maka roiti varivagabarana beto bari vazozoto qari gua, ba kepore za maka vinagilagila mana vadigamu ara goto aza tugu na vinagilagila veveina i Jona. ");
INSERT INTO ghn_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Maka moqaza podeke vei i Jona za na vinagilagila tadiria na tinoni pa Ninive, nari za na Tuna na Tinoni ba pala na vinagilagila tugu tadiria na zazae tinoni koviria. ");
INSERT INTO ghn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Pa rane varituti za pala mina turu na kalao pa Siba ko mina tokegamu za gamu na zazae tinoni koviria. Ura na zouna jola za nana guguzu ba za lame ukukeni tugu nongoria aza za na bokaboka beto na varivagigalai ti Solomone. Ba ma pojadigamu ara za gamu: Korapa gu koviria pani aza maka za lavata jolani i Solomone. ");
INSERT INTO ghn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Pa rane varituti za pala mari turu ko mari tokegamu ria na tinoni pa Ninive za gamu na zazae tinoni koviria. Ura ria za qari gabala loiria na dia sela totonai qari nongoria na tarae ti Jona. Ba dogoro! Korapa gu koviria pani aza maka za lavata jolani i Jona,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","<<Kepore za maka tinoni mina vatoai beto mina vaturua pa ia paena babi vaopo tarini kadikita za na juke, goto mina vanyumua tugu pa nana nyumunyumuna ko mina vakabereria ria doru tinoni mari luge pa leo ruma. ");
INSERT INTO ghn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Na jukena na tini za na matamu. Vei na matamu za mina leana, za na tinimu doruna pala mina tolangani na kabere. Goto vei mina ikere za na matamu, za pala na tinimu mina rodomo. ");
INSERT INTO ghn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ko za vei za mu dogoro valeania ko! Keta na kabere za korapa kole pa mua toa za na rodomo gu. ");
INSERT INTO ghn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ko vei bi kabere beto za doru tinimu ko bi kepore zozoto maka rodomo bi kolea, nari za pala mina kabere beto pudala za doruna na mua toa. Ko mina varipodekai puta na juke za toa ko za vanigo na kabere,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ego pa liguna za beto paranga vei zara i Jisu, za sorua maka Parese aza ko mi lao tekuteku tavitia aza za gua. Ko za lao tugu pa ruma tana i Jisu, ko za tekuteku tavitia. ");
INSERT INTO ghn_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ba za gabara za na Parese ani totonai za batia zake loqa lima mae beto za tekuteku i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ko ari za guni vei na Bangara aza, <<Gamu na Parese za na pegurudi gu na miu kapa beto na peleta gamu valiosoria, ba na leomiu za pugelia na ngangangulu beto na ikerena. ");
INSERT INTO ghn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Gamu duviduvili za gamu! Beko gamu tori gilagilaimiu tu za aza tugu na Tamaza za roitini na peguruna na tinina na tinoni za roitini na leo tinina na tinoni! ");
INSERT INTO ghn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mu iadi ria qari varivasevi ria vei gamu kuradi pa miu kapa beto pa miu peleta, beto za pala mari tavalioso vadigamu za doru zakazava. ");
INSERT INTO ghn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Mu takulangagemiu tugu za gamu na Parese! Ura gamu kole gu varivanani gamu tana Tamaza za makamaka pa manogaputa na miu vuvua pa inuma vevei na miniti, na ru, beto kaki umuma pekipeki, ba gamuke pavuni gamu za na roiti vatuvizi lao tadiria na tinoni beto na roquroquna na Tamaza. Ari tu ria na kuta varivagigalai qari garo ko bu kopudi gamu, beto liguligu tu bu kopudi mule gamu ria kaki vavanau vevei na maka pa manoga zana. ");
INSERT INTO ghn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Mu takulangagemiu tugu za gamu na Parese! Ura gamu nyonyorogua nyumuria gamu ria na nyumunyumudi poreveveidi pa ruma varivarikamudi, beto gamu nyonyoroguni ko mari gozoro qeraqeradigamu ria na tinoni pa ia makemaketidi. ");
INSERT INTO ghn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mu takulangagemiu tugu za gamu! Ura gamu maka moqaza podeke vei ria na pou tomete qarike tavakoledi na vinagilagila ko ria na tinoni qarike batiria za na pou ria ko qari kezaria totonai qari rerege jola,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nari za paranga laoa maka ria qari varivagigalaini na Vavanau aza, <<Tinoni varivagigalai, tonai zara qu paranga vei ao za qu komiti vikevikeregami tugu vei gami!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nari ari za gua vei i Jisu, <<Gamu na tinoni varivagigalai gamu varivarivagigalaini na Vavanau ba mu takulangagemiu tugu vei! Ura pa miu ruvaruvatana na Vavanau za gamu vapogozodi na pogozo mamata gamu ria na tinoni. Ko qarike boka tuti betoria. Beto makamiu gamu ba kepore maka karusumiu bi aru lao ko bu podeke vakopele vadi na pogozo ria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mu takulangagemiu tugu za gamu! Ura gamu roiti vasari valeleanaria gamu ria na poudi ria tugu na tinoni korokorotai qari bosolauria na miu tite pa moa. ");
INSERT INTO ghn_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ko za tabata vakabere gu pa miu roiti za gamu ba gamu vaegoa tugu za na roiti ikikerena qari roitidi ria na miu tite pa moa. Ura ria tu ke qari varivuke, goto gamu gu ko gamu roitidi na poudi ria na tinoni korokorotai. ");
INSERT INTO ghn_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Pana ginugua tugu ani za paranga za na Tamaza pa nana gigalai tavagigala, ari za gua vei, <Mana garunu laodi ara ria na tinoni korokorotai beto ria na tinoni pogozo nongoro, ko kaki ria za pala mari vaukeria, goto kaki pala mari nganganguluria,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ko zara za vei za pala mina tagoreni tugu na zazae tinoni koviria za na vinakilasa lavata pa ginuana qari tavauke ria na tinoni korokorotai tonai vei za roitini na kasia guguzu na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ko za podalai tugu pa vaukena i Ebolo ko za kamu ti Zakarae aza za tavauke pa leo ruma zelepade, pa varikorapaidi na lose tabuna beto na ia vavavavuina. E! Ma poja valeadigamu ara za gamu: Ria na zazae tinoni koviria za mari gozoroni vinakilasa! ");
INSERT INTO ghn_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mu takulangagemiu za gamu gamu varivagigalaini na Vavanau! Ura gamu teku paleni gamu za na viduluna na atakamana za luge lao pa gigigalaina na Tamaza. Ko makamiu ba gamuke lugea tugu, beto gamu suquturia tugu gamu ria qari korapa podepodeke lao luge ketakoi>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Totonai za taloi pa ia aza i Jisu za qari podalai kanai ria qari varivagigalaini na Vavanau beto ria na Parese aza, ko qari nanaza jujukuni aza ria na veveidi zoku zakazava vei ko mi paraparanga aza qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ria qari kole gu dogoro kopuni aza ko mari dogoro poai ketakoi mina paranga vaseladi aza kaki paranga qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ego totonai za qari varikamu lao tana zoku vuro tinoni. Ko qari korapa varivaritete kalekale tu makadi, za paranga momoeria i Jisu ria na nana sepele, <<Muna balauni gamu za na toa vavabata sekeseke tadiria na Parese za vei na vavakovuruni palava. ");
INSERT INTO ghn_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ura na zakazava za tatuki tari za mina tatakele votu, beto na roquroqu tagolomona za pala mina tagilagila tadiria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Aza gamu variparaparangani gamu pa rorodomona za mu velavelani pa kabekaberena ko mi tanongoro, beto ko aza gamu varimanamanazani pa leo lose za mina tavelavela pa are ruma,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","<<Ego ma pojadigamu, ka viza qua baere, muke matagutudi ria qari boka vaukea na tini gu ba pa liguna aza za qarike boka roitini mule maka zakazava ikerena pa miu toa. ");
INSERT INTO ghn_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ba ma ule vadigamu ara za aza vei mu matagutuni gamu. Mu matagutuni za na Tamaza, aza tu za kolenana na nana neqi ko pa liguna za vaukea aza na tini za pala mina boka valaogamu tugu vei pa iku pa heli. Na zozotona ani ko aza za mu matagutuni gamu! ");
INSERT INTO ghn_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Na tagilagilana za na laedi ka lima pitikole za kori moqaza pene gu! Ba kepore maka ria za roqu mumani na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Goto gamu za na vurungumiu gu pa batumiu ba za tori gilagila betorianana tu na ngutidi na Tamaza. Ko za vei za muke matagutu. Ura gamu za gamu poreveveina joladi zoku ngavulu pitikole!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","<<Ma poja valeadigamu ara za gamu: na tinoni za ule votuniziu ara pa moedi ria na tinoni ko aza za maka taqu za gua, za pala mina ule votuni tugu na Tuna na Tinoni pa moedi ria na mateana tana Tamaza aza. ");
INSERT INTO ghn_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Goto na tinoni za kilu paleniziu ara pa moedi ria na tinoni, za pala mina kilu paleni tugu pa moedi ria na mateana tana Tamaza na Tuna na Tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Na tinoni za paranga vasela laoia na Tuna na Tinoni za mina boka taleozoni gu. Goto na tinoni za vamoroania na Ongu Tabuna za minake izongo taleozoni zozoto aza. ");
INSERT INTO ghn_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Tonai mari toka ragata laodigamu pa varituti pa ruma varivarikamuna, pa moedi ria na bangara babi na qavuna, za munake roquroqu mamatani ae mami paranga vei babi na za mami pojai za mami talegaza muna gua. ");
INSERT INTO ghn_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ura pala na Ongu Tabuna tu mina ule vadigamu pa totozo aza ria na paranga tuvizidi muna pojaria gamu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ego maka tinoni pa varikamu minete tinoni za ari za guni vei i Jisu, <<Tinoni varivagigalai, mu pojani na tugaqu marene ko mi pikata vaniziu na izizongo za loi vakole vadigami na tamamami,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nari ari za guni vei i Jisu aza, <<Qokolo, nake qua roiti ara za mana pitugamu beto mana pikata vadigamu na miu zakazava gamu izongoria gamu kori!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Beto ari za gudi vei i Jisu ria doru, <<Mu kopu muledigamu! Muke vapugeleni na nyoroguana na izizongo za na miu toa. Ura na toa tana tinoni za zake kole pa pugele zokuna na nana izizongo,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Beto za pojadi za na vavakato vavapada ani: <<Kolenana za maka tinoni izizongo ko na nana pezo za masuru valeana. ");
INSERT INTO ghn_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Za kole varipera na roquna makana aza, ari za gua vei, <Kepore mule za ketakoi vei mana vakoledi na qua vuvua mana tekuria pa qua inuma ara. Ko na za beka za mana roitini ara?> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Beto ari za gua vei mule, <Leana, ari gu mana roiti vei ara. Mana jegara paledi ria na qua ruma vavakoleni ganiganina ko mana roiti valavataria. Ko ketakoi za mana vakoledi na gequ ganigani mana tekudi pa qua inuma beto kaki qua zakazava mule.> ");
INSERT INTO ghn_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Beto za ari mana paranga veiniziu makaqu, <Marene! koviria tu za vavagua za na mua toa! Qari kubo jola na mua zakazava leadi na padana na kubo aoro. Mu pekipekini gu, mu tekuteku beto mu bukubuku vapotepotegemu, beto mu suvere qeraqeramua!> managuniziu,>> za gua za na tinoni izizongo. ");
INSERT INTO ghn_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ba ari za guni vei na Tamaza aza, <<Na duviduvili ao! Pa bongi tugu ani mina tateku pale za na toa tamu. Ko i zei mina izongoria ria na mua zakazava qu buti varikamudi zara?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","<<Ko zara pala mina vei za na tinoni za boko varikamu nana zakazava makana pa pezo ba zake izizongo pa dogodogoro tana Tamaza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Beto ari za gudi vei i Jisu ria na nana sepele, <<Ko za vei zara za ara ma pojadigamu: muke kole mamatani na miu toa beto na za muna gania, babi na tinimiu beto na za muna pokoni. ");
INSERT INTO ghn_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Na miu toa za poreveveina jolani na ganigani, beto na tinimiu za poreveveina jolani na poko. ");
INSERT INTO ghn_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mu dogoro laoria ria na manugu qari tatava ko! Ria za qarike umuma beto qarike ababu, beto za kepore tugu vei na dia ruma vavavakoleni ganiganina, ba na Tamaza za vatekutekuria gu ria! Ba gamu tu za gamu poreveveina joladi ria na manugu tatatavadi! ");
INSERT INTO ghn_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","I zei gamu tonai za kole suvere takulanga nari za tori boka vakakazia mae tu iapeki za na nana toa? Bi mija tugu! ");
INSERT INTO ghn_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ko vei muna oqoro boka roitini gamu za maka zakazava peki vei zara, nari za ae za vei gamu korapa takulangadi mule kaki goto zakazava? ");
INSERT INTO ghn_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mu dogoro laoria ria na gavoro pirudi ko! Qarike pavu taleni na roiti beto qarike pitipitidia poko ria. Ba ma poja valeadigamu ara za gamu: pa doruna na izizongo ti Solomone na bangara, za kepore maka poko tana za bi batabata leana vei maka ria na gavoro ari. ");
INSERT INTO ghn_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ria gu na gavoro qarike toa vazovai beto qari tagona lao pale pa iku ba za vapokopokoria tugu na Tamaza ria. Ba gamu za gamu poreveveina joladi ria na gavoro, ko za zozoto jola za pala mina vapokopokogamu aza. Za peki jola na miu rangerange za gamu! ");
INSERT INTO ghn_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ko zara za vei za, muke nyaqo gojogojoria doru totozo gamu za na zakaza muna gania na bukua beto mike rabeke na miu roquroqu. ");
INSERT INTO ghn_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ura ria doru zakazava ari za ria na tinoni rodomo pa kasia guguzu za qari nyaqo vitivitigiria, goto gamu na tamamiu pa noka ba za tori gilagila betorianana tu za muna toadi gamu ria na zakazava veveidi ari. ");
INSERT INTO ghn_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Goto gamu za mu nyaqo momoea mae tu na binangara tana Tamaza, beto mina vadigamu aza ria doru zakazava veveidi ari,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","<<Muke matagutu, qua minete, ura na Tamamiu pa noka za na nana binangara tu ba za tori valeanaia tu ko mina iadigamu. ");
INSERT INTO ghn_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mu vavaidi ria na miu izizongo beto na poatadi za mu iadi ria qari golaba. Mu tekua na pausu aza zake boka taunyara mumutu, aza za na izizongo pa noka ketakoi minake boka murimuri, kepore na tinoni mari boka ikoa, beto na tamo minake boka ganiria. ");
INSERT INTO ghn_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ura ketakoi qari kole na miu izizongo za ketakoi tugu qari kole za na bulomiu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","<<Mu suvere vanaqiti doru totozo. Mu vei ria qari saqiti vamaururia na dia poko roiti ko qari vanaqiti roiti, beto muke vakipuria na miu juke. ");
INSERT INTO ghn_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mu suvere gelegele vei ria na nabulu qari korapa adonia na mule lamena na dia bangara za lao somana pa vavolo varielava. Ko totonai mina mule lame ko mina kikia pa atakamana, za mari siqarai revanga vani na atakamana. ");
INSERT INTO ghn_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mari qera ria na nabulu ria totonai za lame kamu na dia bangara za qari korapa suvere gelegeleni aza! Ma poja zozotodigamu ara gamu: mina vazaea aza za nana poko ninabulu, mina valao adonoria pa tevolo ari ka viza nabulu ari ko mina vatana vadi na tekutekuna ko mari tekuteku. ");
INSERT INTO ghn_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ko vei bi na korapa bongi tu za babi na jola korapa bongi tu za bi mule lame batiria bari korapa gelegeleni, nari za mari qera tugu ria. ");
INSERT INTO ghn_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mu nongoro vakoititia ani! Vei bi tori gilagila momoea tu na tinoni kolenana ruma za na totozo lame tana tinoni ikikona za pala minake boka pururu luge laoia na tinoni ikikona za nana ruma. ");
INSERT INTO ghn_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ko zara za vei za gamu ba mu kole suvere vanaqiti. Ura na Tuna na Tinoni za pala mina mule lame pa totozo gamuke rove veini mina lame,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nari ari za gua vei i Pita, <<Bangara, tadigami na sepele gu qu guni ao za na vavakato vavapada ani, ba tadigami doru tinoni tugu?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nari ari za gua vei za na Bangara, <<I zei za na nabulu tarangena beto na tavagigalana? Aza tugu za na nabulu mina vatiolatai na bangara ko aza za mina kopuni nana ruma beto mina iadi mule na ganigani ria kaki nana nabulu pa totozo tamijatana. ");
INSERT INTO ghn_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mina qera za na nabulu aza vei mina korapa roiti valeana vei zara aza totonai mina mule lame batia na nana bangara. ");
INSERT INTO ghn_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ara ma poja valeadigamu zozoto: mina vatiolata lavatia na nana bangara za na tinoni aza, beto mina vakopudi dorudi nana izizongo. ");
INSERT INTO ghn_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ba vei bi roquroqu za na tinoni aza, <Koi, pala minake oqanai mule za na qua bangara,> bi gua, ko bi podalai majamaja laolamedi ria na nabulu marene beto na nabulu reko, beto bi kole gu ngojangoja vapotepotegana beto bi kole bukubuku vadigedigereni gu, ");
INSERT INTO ghn_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","nari za totonai mina korapa gu roiti vei aza zara pa rane na totozo zake rove veini mina mule na nana bangara. Pala mina vakilasa valeania na bangara aza, beto mina gona laoni tadiria qarike vakepore zozotoa na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ko na nabulu za gilagilainana aza vei za nyoroguani na nana bangara ba zake vanaqiti beto zake roitini aza vei za nyoroguani nana bangara, za mina tapiqopiqolo valeana aza. ");
INSERT INTO ghn_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Goto na nabulu zake gilagilai na manugu za nyoroguani na nana bangara, ko za roitini aza bi boka tapiqoloni, za pala minake loka neqina za na piqolo mina tekua aza. Ba aza za ia vakubokubo vani na Tamaza ko mina kopudi, za na kubokubona tugu za nyoroguani ko mina variiani na tinoni aza. Ko aza za taiani na zokuna za pala na zokuna tugu za mari tepani ria na tinoni aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","<<Na iku tu za qa pogozo lagereni ara pa pezo, ko na qua nyorogua za bi oqanai toa vuruvurungu tu aza qa gua! ");
INSERT INTO ghn_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ba maka paputaiso vitigi za pala mana lugea mae ara, ko aza za qa korapa takulangani ara tinganai mina jola tu aza. ");
INSERT INTO ghn_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Keta mu roquroqua gamu za na bule za qa pogozo lameni ara pa pezo keta mu gua. Dai! Ma pojadigamu: Nake bule za qa pogozo lameni ara, goto na varipikatai tu. ");
INSERT INTO ghn_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Podalai koviria za vei ari ka lima za pa maka puku tatamana za pala mari varipikatai ko ari kue pala mari taleria ari kori, ari kori mari taleria ari kue. ");
INSERT INTO ghn_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Pala mari varipikatai ko na tamadi mina kanai na tudi marene, na tudi marene mina kanai na tamadi. Na tinadi mina kanai na tudi reko, na tudi reko mina kanai na tinadi. Na tinadi za mina kanai na nana roroto reko roadi, na roroto reko roadi za mina kanai na roadi reko,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Beto za paranga laoria i Jisu ria na minete tinoni, <<Aza tugu gamu batia gamu za na pauku za lame vei pa kale suvu tapo, nari za gamuke oriavo tugu paranga vei ari za gamu, <Koi, pala mina lame za na qolapezo,> gamu gua, nari za okoro tugu za na kota. ");
INSERT INTO ghn_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Beto aza tugu gamu turu bata lao vei pa suvu tapo ko gamu vagilagilai na gava za raja keta pa kale merimiu, za gamu paranga za gamu, <Koi, pala mina dadanga za na kota,> gamu gua, nari za dadanga tugu za na kota. ");
INSERT INTO ghn_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Na tinoni vavabata sekesekemiu za gamu! Gamu boka dogoro gilagilai gamu za na rijodi beto na kanokodi na pezo beto na vavagalo kota, ba ae za vei ko gamuke boka tu dogoro gilagilai gamu za na roiti za roitidi na Tamaza pa totozo ani?>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","<<Beto ae za vei ko gamuke boka tu dogoro pikatia makamiu gamu za na roiti tuvizina? ");
INSERT INTO ghn_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tonai qu korapa lalaomiu tana tinoni varituti za gamu kori na mua kana, za mu podeke vitivitigia ko mu vatuvizi momoea ko mu popoa mae tu za na mua tapata tonai qu oqoro lao ao pa varituti. Ura vei manake vei, za pala muna tatoka lao tana tinoni za roitini na varivarituti, ko na tinoni za varivarituti aza mina valaogo tana tinoni kopu ruma varipiu, beto ko na tinoni kopu mina valugego pa ruma varipiu ao. ");
INSERT INTO ghn_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ko ma poja veinigo ari ara ao: pala munake votu pa ruma varipiu ao, tinganai muna lipu vaokotia ao za na padana qu tavakilasani,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ego pa totozo aza za qari lao vavakatoni ria kaki tinoni ti Jisu za na veveidi kaki tinoni Qalili i Paelati za vaukeria ko za qaliri varisomanaidi na dia vavavui za na orungudi. ");
INSERT INTO ghn_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nari za oeria i Jisu ria, ari za gudi vei, <<Ae vei? Gamu roquroqua gamu za ria za na tinoni seladi joladi ria doru tinoni Qalili ko za vei za qari tavauke pa zona ikerena vei zara? ");
INSERT INTO ghn_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Dai zozoto! Ma poja zozotodigamu: Vei munake gabala loiria na miu sela, za gamu ba muna uke vei tugu ria! ");
INSERT INTO ghn_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ae vei mule ari ka manogavesu tinoni ria za lotu tako vaukeria na ruma ululuna pa Siloami? Ae vei? Gamu roquroqua gamu za ria za na tinoni ikikeredi joladi ria qari suvere pa Jerusalema ko za vei za qari uke vei zara? ");
INSERT INTO ghn_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Dai zozoto! Ma pojadigamu: vei munake gabala loiria na miu sela, za gamu ba muna uke vei tugu ria zara za gamu!>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Beto za pojadi i Jisu za na vavakato vavapada ani: <<Kolenana za maka tinoni za izongia maka suvege piqi pa nana inuma. Ko za lao ko za nyaqogana vuana ba zake batianana maka. ");
INSERT INTO ghn_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ko za pojani za nana tinoni roiti pa inuma, <Dogoro! Kue aoro qari jola ari qa lamelame ovikia ara za na suvege piqi ani, ba kepore maka vuana ba batia. Mu lao rio paleni! Kepore laona mina turu jola zana, ura za korapa gani vauke goboria na pezo!> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ba za oea ko za paranga za nana tinoni roiti pa inuma, <Koi, bangara! Muke vei! Vakolea mae pa aoro ani. Pala mana geli amu tari varilivutaini na pezo na kutana beto mana vakole vani na teni bulumakau. ");
INSERT INTO ghn_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ko vei mina vua pa aoro za lame ani, nari za muna loia ko mina turunana. Goto vei minake vua tu aza, za tonai za muna rio pale zozoto!> za gua za na tinoni aza>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Maka rane Minyere za kole varivagigalai pa maka ruma varivarikamuna i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Korapa ketakoi za maka reko za varajani na tomete ikikerena ko za mo manogavesu aoro, ko za poguru ko zake boka turu vatuvizi valeana. ");
INSERT INTO ghn_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Totonai za batia i Jisu aza, za kuku tekua ko ari za guni vei, <<Tinaqu, koviria qu tasalana pa mua mo ao!>> za gua aza, ");
INSERT INTO ghn_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","beto za vaoponi na limana aza za na reko. Aza tugu za vei aza za zake oriavo tugu turu vatuvizi soganana gu aza, ko za vatarazaea aza za na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ba na kuta tinoni matamata pa ruma varivarikamuna za tagigirini za na veveina za salana tinoni pa rane Minyere i Jisu, ko ari za gudi vei ria na tinoni, <<Ka vonomo rane za za vamalumia na Vavanau ko tana boka roiti gita na tinoni! Ko mu kamu tasalana pa rane ria, goto nake pa rane Minyere!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nari za oea na Bangara aza, ari za guni vei, <<Na tinoni vavabata sekesekemiu za gamu! Gamu ba gamu ruvaruvata tekuria tugu pa dia tuturuna pa rane Minyere za na miu bulumakau beto na dongiki ko gamu toka keni vabukuria tugu pa rane aza. ");
INSERT INTO ghn_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Na tuvizina gu za taruvata pa nana mo pa rane Minyere aza. Ura na reko ani za maka tuna tugu i Ebarahami aza ba za tapiu ti Setani ka manogavesu aoro,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Totonai za paranga soga veidi i Jisu zara za qari kea ria qari kanai aza, goto ria doru tinoni za qari qera joladi ria na zakazava varivagabaradi za roitidi aza. ");
INSERT INTO ghn_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ego ko za nanazaria i Jisu ria, <<Ae za vevei za na binangara tana Tamaza? Na za mana vavapadani ara aza? ");
INSERT INTO ghn_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Na binangara tana Tamaza za vei na kiko masitadi. Maka tinoni za tekua maka kiko masitadi peki ko za umani pa nana inuma. Ko za pidoko zae aza, ko za vei maka suvege lavata, tinganai qari tatava kamu na manugu ko qari roiti dia vorivori na alale pa okokoto kaena,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Beto za ari mule za gua vei i Jisu, <<Na za mule mana vavapadani ara za na binangara tana Tamaza? ");
INSERT INTO ghn_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Za vevei gu na vavakovuruni palava aza. Maka reko za tekuria kaki vavakovuruni palava ko za qaliri laoni pa maka bakete palava, tinganai ko za kovuru zae beto za na palava,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ego za rerege lao vei pa guguzu lavatadi beto na pekipekidi i Jisu ko za kole varivagigalai tadiria na tinoni, totonai za korapa jola gore vei pa Jerusalema. ");
INSERT INTO ghn_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Totonai za maka ria za nanazia aza, <<Bangara, pala ari ka viza tinoni gu za mari taalo?>> za guni. Nari ari za gudi vei i Jisu ria na tinoni, ");
INSERT INTO ghn_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","<<Mu varipera viviva ko mu luge laoa na atakamana ngijupuna. Ura ma pojadigamu ara za ria na zoku za mari nyorogua luge ba marike boka. ");
INSERT INTO ghn_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Aza tugu mina turu lame za na bangarana na ruma ko mina pate paleni za na atakamana, za muna turumiu tugu pa peguru ko muna kole kikia, beto ari muna gua vei za gamu, <Bangara, mu revanga vadigami na atakamana!> muna gua. Ba tonai mina oe votu aza, <Qake gilagilagamu ara ketakoi na lame veimiu za gamu!> mina gua. ");
INSERT INTO ghn_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tonai za pala ari muna gua vei za gamu, <Koi, gami ko gami tekuteku tavitigo beto gami buku tavitigo ao, beto ko ao gu ko qu kamu varivagigalai pa zona lavata pa mami guguzu!> muna gua. ");
INSERT INTO ghn_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ba mina paranga aza, ari mina gudigamu vei, <Mu keni! Mu taloi taqu gamu doru tinoni ikikeremiu! Ara qake gilagilagamu ketakoi na lame veimiu za gamu!> mina gudigamu aza. ");
INSERT INTO ghn_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ko ketakoi muna lukana uui beto mina ngingizi tu na livomiu za gamu, totonai muna batiria ari Ebarahami, i Aisake, i Jekopi, beto ria doru tinoni korokorotai pa leona na binangara tana Tamaza, goto gamu makamiu za muna tavakole pale pa peguru. ");
INSERT INTO ghn_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Beto ko ria na tinoni mari lame vei pa doru kota pa made uquna na kasia guguzu za mari luge, ko mari somana tekuteku pa vavolo pa binangara tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ko ria qari liguligu za mari momoe, goto ria qari momoe za mari liguligu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ego pa totozo tugu aza za qari lao parangia ria kaki Parese i Jisu, ari qari gua vei, <<Mu siqarai rijo lao pa maka goto kota ao, ura i Herodi za korapa kuonigo ko mi vaukego za gua,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nari ari za gudi vei i Jisu ria, <<Mu lao pojani za na pokese nganganguluna nari, <Ara za koviria qa korapa iju paledi na tomete ikikeredi beto qa varisalana pa ngenari ko uka, ko pa rane vinaue tu za mana vaokotia ara za na qua roiti za gua,> muguni. ");
INSERT INTO ghn_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ba leana, mana jokai na qua rerege lao pa Jerusalema ara pa ngenari, uka ko riza, ura nake pa goto kota goto pa Jerusalema gu za na ukukena tana tinoni korokorotai. ");
INSERT INTO ghn_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Kei, Jerusalema, Jerusalema! Gamu na tinoni pa Jerusalema gamu vai vaukeria na tinoni korokorotai beto gamu buti taridi na patu ria za garunu laodi na Tamaza tadigamu! Kubo totozo za qa nyorogua teku varikamudigamu, ba veidigamu na kokorako za vaonguria na boko tuna pa babanana ko za kopudi qa gua, ba quke vamalumuziu tugu ko ba veidigamu. ");
INSERT INTO ghn_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ko zara za vei za, mina taloi pale ko mina ivulu gogoepe za na miu ruma zelepade. Ma poja zozotodigamu ara za gamu: munake izongo batiziu ara za gamu, tinganai mina kamu na totozo muna paranga vei ari, <Za tamana aza za lame pa korapa izongona na Bangara,> muna gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ego pa maka rane Minyere tonai za lao tekuteku pa ruma tana maka tiolata tadiria na Parese i Jisu, za qari kole dogoro kopukopuni ria na tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ko za korapa ketakoi pa moena i Jisu za maka tinoni za varajani na mo ko za pugepugele na nenena na limana. ");
INSERT INTO ghn_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nari za nanaza laoria i Jisu ria na tinoni qari varivagigalaini na Vavanau beto ko ria na Parese, <<Ae vei, na tavamalumuna tugu pana Vavanau za na varisalana pa rane Minyere, ba dai?>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ba qarike vagala ria. Nari za aru tekua i Jisu za na limana na tinoni za mo ko za salania, beto za vamule kenia. ");
INSERT INTO ghn_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Beto ari za gudi vei, <<Bi vei maka gamu za bi lotu kura pa maka baongo lavata pa rane Minyere za na nana dongiki babi maka nana bulumakau, za ae muna vei za gamu? Munake boka siqarai lao bako votuni aza pa rane Minyere tugu aza?>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ba qarike boka oea ria za na nanaza tana. ");
INSERT INTO ghn_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ego za tori dogoro poaria tu i Jisu ria kaki tinoni qari tasoru za qari mijamijataria na nyumunyumudi poreveveidi pa totozo tekuteku, ko za parangaria, ");
INSERT INTO ghn_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","<<Tonai bu tasoru lao pa maka vavolo varielava ao, za muke jujuku lao pa nyumunyumuna poreveveidi, ura keta mi kolenana mule za maka tinoni za poreveveina jolanigo ao za oqoro kamu. Ko vei mina kamu liguligu aza ");
INSERT INTO ghn_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","za pala mina lao tamu za na tinoni kolenana vavolo, aza za sorugamu gamu kori doru, ko ari mina gunigo vei, <Qokolo, mu vakabere vani na tinoni ani za na nyumunyumuna aza,> mina gunigo. Ko tonai za pala muna kea ao beto muna gore nyumua ao za na nyumunyumuna tadiria kepore veveidi. ");
INSERT INTO ghn_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Goto tonai bu tasoru ao za mu lao nyumu pa nyumunyumuna betobetona kepore veveina. Ko totonai mina lame za na tinoni za sorugo za pala ari mina paranga veinigo, <Qua baere, mu nyumu keza zae pa narena pani,> pala mina gunigo. Pa totozo tu aza za muna tavaporeveveina pa moedi ria doru qari tasoru ao. ");
INSERT INTO ghn_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ura na tinoni za vavalavata muleni makana za pala mina vakeai tugu na Tamaza, goto aza za vapeki muleni makana za pala mina valavatia tugu na Tamaza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Beto za parangia i Jisu za na tinoni za sorua aza, <<Totonai muna vatanani ao za maka tekutekuna babi na vavolo za muke soruria gu ria na mua baere, na taimu marene, na tavitimu babi ria na tinoni izizongo qari suvere tatago. Ura ria za pala mari boka soru sogago mutugu maka totozo ao, ko tonai mari vei ria nari za mina tasoga gu za na roiti leanana qu roiti laoni ao tadiria. ");
INSERT INTO ghn_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Goto tonai muna roitini maka vavolo ao za mu soruria ria tu na varivasevidi, na qao, ria qari gavere, beto ria nake batabatadi tu. ");
INSERT INTO ghn_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mina vei tu aza za muna tamana ao, ura pala marike boka soga vanigo ria aza. Goto ao za na Tamaza tu mina soga vanigo pa rane turumule tadiria na tinoni tuvizidi,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ego ko totonai za nongoria maka ria qari somana tekuteku pa tevolo za na paranga ari, za paranga laoia aza i Jisu, <<Mina tamana valeana za na tinoni mina somana tekuteku pa vavolo pa binangara tana Tamaza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nari za oea i Jisu aza, <<Maka totozo za roitini maka tinoni za maka vavolo lavata beto za soruria aza ria na kubo tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Totonai za kamua za na totozo vavolo za garunia za nana nabulu ko za lao pojadi ria na tinoni tasorudi, <Mae, lame koviria! Tori tana beto tu doru maka za,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ba qari okoto podalai gonagona vapele ria doru. Ari za gua vei za na tinoni momoe, <Ara za maka iapeki kobu pezo za qa koni vaia gu, ko ba lao tu ovikia aza qa gua. Ko mu vamalumuziu gu ko manake lao somana,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Beto maka goto mule ari za gua vei, <Ara za ka manogaputa bulumakau mari ragaragatia na geligelina pa qua inuma za qa koni vai tekuria gu, ko qa korapa nyorogua lao podekeria. Ko mu vamalumuziu ko manake lao somana,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Beto maka mule ari za gua, <Ara za qa koni varielava gu, ko pa ginuana gu aza za manake boka lao ara,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nari za mulenana gu za na nabulu ko za lao vavakato vani nana bangara za na veveidi doru paranga qari pojaria ria. Ko za tagigiri vikevikereni za na bangara za roitini na vavolo, ko ari za guni vei za nana nabulu, <Mu siqasiqarai tokatokaria na zona lavalavata na zona pekipekidi pa leo guguzu, ko mu toka lamedi ria na varivasevidi, na qao, nake batabatadi, beto ria qari gavere!> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pa liguna za roitini aza vei za garununi nana bangara nari za mule kamu za na nabulu, ko ari za gua vei, <Bangara, qa tori toka kamudi tu ara ria qu garununiziu ao, ba za oqoro tu pugele za na ruma,> za gua za na nabulu. ");
INSERT INTO ghn_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nari ari za guni vei na bangara za na nana nabulu, <Mu votu lao mule keta pa peguruna na guguzu lavata pa zona na kota pa zouna ketakoi qari suvere na tinoni, ko mu tepa vitivitigiria ria na tinoni ko mari lame vapugelia na qua ruma. ");
INSERT INTO ghn_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ma pojadigamu ara: kepore maka ria qa soru momoeria za mina meai iapeki ganigani pa qua vavolo!> za gua za na tinoni aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ego totonai za korapa lalaonana i Jisu za maka minete tinoni lavata za tuti laoa, nari za balinga mule aza, ko ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","<<Na tinoni za lame taqu ba zake roqu loiria ria na tamana, na tinana, na maqotana, beto na tuna, ria na taina marene na luluna reko, beto ko nana toa tugu vei za zake pada ko mina sepele taqu za na tinoni vevei aza. ");
INSERT INTO ghn_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Na tinoni zake pogozia nana korosi makana ko zake tutiziu ara za zake pada ko mina sepele taqu aza. ");
INSERT INTO ghn_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Vei maka gamu za bi nyorogua roitini maka ruma lavata, za pala mina nyumu mae aza ko mina nguti votuni mae za na vaina na ruma, ko mina gilagilai mae za bi pada tugu za nana poata na vaokotona na ruma ba dai. ");
INSERT INTO ghn_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ura vei minake vei zara aza, za pa liguna mina vaturua na kokovana beto minake boka vaokotia aza za na ruma, za pala mari au vavaledeni ria doru tinoni qari batia nana roiti aza. ");
INSERT INTO ghn_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Pala mari paranga ria, <Koi, na bangara ani za podalaini nana ruma, ba zake boka vaokotia!> pala marigunigo ria. ");
INSERT INTO ghn_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ko mu nongoria mule ani ko! Na bangara za izongia ka manogaputa vuro tinoni varipera gu ba za nyorogua rajai za maka goto bangara za izongia ka rabeteputa vuro tinoni varipera, za mina nyumu mae ko mina roquroqu valeana mae tu aza. Mina roquroqu valeana ko vei mina bokanana talea aza za na bangara nari ba dai. ");
INSERT INTO ghn_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ko vei mina gilagilai minake boka aza za mina garunu valaoria ria kaki nana tinoni pogozo nongoro ko mari lao gozoria za na bangara neqina tonai za korapa pa zouna tu aza, ko mina tepai aza za na bule. ");
INSERT INTO ghn_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ko gamu za maka moqaza podeke vei tugu. Zara za vei ko mu dogoro valeania za na pore laona na tutiqu ara beto mu tutiziu. Ura kepore maka tinoni gamu za mina boka na qua sepele vei minake boka loi betoria aza za doru nana zakazava za izongoria,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","<<Na solo za na leleana, ba tonai mina maragutu na lingilingina nari za pala minake boka tavalingilingi soga mule aza. ");
INSERT INTO ghn_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Na solo kepore lingilingina za zake pada mina tavaroiti pa pezo babi pa nyanyao nyabodi ko na valaona pa umuma. Goto na padana za mina tagona paleni gu. Na tinoni pore talinga nongonongorona za mi vainongoro!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ego ko qari kanoko lao ti Jisu ria na zoku tinoni tekuteku takisi beto ko ria na tinoni seladi, ko mari nongonongorodia tana qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nari qari podalai qumiqumini ria qari varivagigalaini na Vavanau beto ria na Parese aza, ari qari gua vei, <<Na tinoni ani za vatataria tu ria na tinoni seladi beto ko za tekuteku tavitiria tugu vei!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nari za pojadi i Jisu za na vavakato vavapada ani, ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","<<Vei maka gamu za bi izongia maka gogoto nana sipi ko tonai maka ria na sipi ari za bi muma, nari na za mina roitini aza? Na tinoni aza za loi vasuvereria pa qega ari ka siangavulu ka sia sipi, beto za lao nyaqoa aza za muma tinganai ko za batia tu. ");
INSERT INTO ghn_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Totonai za batia za qera vitivitigi, ko za sugaria pa varana. ");
INSERT INTO ghn_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Beto za sugara muleni pa nana ruma, za kuku varivarikamudi ria na nana baere beto na tavitina, ko ari za gudi vei, <Mae gamu ko mu somana qeraqera tavitiziu! Ura koviria qa tori batia tu ara aza na qua sipi mumana,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ma pojadigamu ara za maka moqaza podeke putaputa vei zara za na qeraqera pa noka za votuni na gabala mulena maka tinoni selana za mina jolani na qeraqera za votuni ari ka siangavulu sia tinoni tuvizidi nake padadi ko mari gabala mule,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","<<Bi kolenana za maka reko za izongia ka manogaputa nana poata siliva ko maka za vamumai, nari na za mina roitini aza? Na reko aza za vurungia na juke, beto za burungia na ruma beto za nyaqo beto paleni aza za na leo ruma ko tinganai za batia tu. ");
INSERT INTO ghn_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Totonai za batia aza za na poata za vamumai, za kuku varikamudi ria na nana baere na tavitina, ko ari za gudi vei, <Mae gamu ko mu somana qeraqera tavitiziu! Ura koviria qa tori batia tu ara za na qua poata aza qa vamumai,> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ma poja valeadigamu ara, maka moqaza podeke vei tugu aza za ria na mateana tana Tamaza za qari qeraqera tonai za gabala mule maka tinoni selana,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","<<Kolenana za maka tinoni kori na tuna marene. ");
INSERT INTO ghn_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ko na tuna marene pa ligu ari za guni vei na tamadi, <Tamaqu, mu vaniziu gu koviria za aza na iaqu pa mua izizongo,> za gua. Nari za okoto pikata vadi na tamadi tadi ari kori tuna marene ria na nana izizongo. ");
INSERT INTO ghn_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ego za jola gu ka viza rane, nari za na tuna pa ligu za vanamaria doru nana zakazava za izongoria beto za taloi keni pa guguzu zouna aza. Ketakoi za lao vanyanyala paledi aza pa toa ikikeredi ria doru nana poata. ");
INSERT INTO ghn_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Totonai za vabetoria aza ria doru vei za izongoria, za kamu pa guguzu aza za maka songe lavata, ko za kepore maka za bi boka toani aza. ");
INSERT INTO ghn_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ko za lao tepa roiti tana maka tinoni pa guguzu aza, nari za garunia na tinoni aza ko za lao kopu vani na nana borogo. ");
INSERT INTO ghn_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Za varivasevi ko za kole dogodogoro nyonyoroguadi tugu aza ria na ganigani tadiria na borogo, ba kepore maka tinoni bi iani ganigani. ");
INSERT INTO ghn_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ko totonai za roqu kamua aza za na roquroqu tavagigala, nari ari za gua vei, <Kei, ria doru nabulu tana tamaqu ba za pugele nyonyoa na gedi ganigani goto na za qa uke talea ko qa suvere varivasevi burana pani ara! ");
INSERT INTO ghn_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Leana, ma siqarai gu mule lao tana tamaqu ara, ko ari mana vavaja vei: Tamaqu, qa sela ara pa moena na Tamaza pa noka beto pa moemu ao. ");
INSERT INTO ghn_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Koviria nake padaqu ko muna kukuniziu na tumu ara, goto mu veiniziu gu ria na mua tinoni roiti mana gua,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ko za soqolo turu ko za taloi mule lao tana tamana aza. Ba totonai za oqoro tata kamua na ruma aza za dogoro vaia na tamana, ko za roquroqu vitivitigia aza, ko za abutu lao borua beto za aoa za na tuna. ");
INSERT INTO ghn_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nari ari za gua vei za na tuna, <Tamaqu, qa sela ara pa moena na Tamaza pa noka beto pa moemu ao. Koviria nake padaqu ko muna kukuniziu na tumu ara,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ba za kuku tekuria na tamana ria na nana nabulu, <Mu siqasiqarai! Tekua na poko batabata leanana ko mu vazaeni, beto mu vasolapani na ringi na karukarusuna, beto mu vazaeni tugu na sadolo na nenena, ");
INSERT INTO ghn_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","beto za mu lao kubolia na tuni bulumakau nyobonyobokona, ko tavavolo qeraqerani! ");
INSERT INTO ghn_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ura na tuqu ani za tori uke tu, ba koviria za toa mule; za tori muma tu aza, ba koviria za tabata ligu!> za gua. Ko qari podalai roitini ria za na vavolo qeraqera. ");
INSERT INTO ghn_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ego totonai za korapa tu pa inuma za na tuna marene pa moa. Ko totonai za mule ko za tata kamu pa ruma, za nongoria za na mikemike beto na pekapeka. ");
INSERT INTO ghn_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nari za kuku tekua aza za maka nabulu ko za nanazia, <Na za za korapa taroiti pani, qokolo!> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nari ari za gua vei za na nabulu, <Na taimu marene za koni mule kamu ko na tamamu za kubolia na tuni bulumakau nyobonyobokona ko qari vavolo qeraqera, ura za mule kamu valeana aza,> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ba za tagigiri za na tuna pa moa, ko za dainana luge pa ruma. Nari za votu za na tamana ko za mamana tokatokai ko mi luge za guni. ");
INSERT INTO ghn_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ba za oea za na tamana, <Dogoro! Na kubo jola aoro ari za qa kole pinauzu vanigo ara ao beto qake izongo maja podekia tugu ara za maka mua garunu. Ba na za mae qu tori vaniziu tu ara? Bi maka qoti peki gu bu vaniziu ko ba tekuteku tavitiria ria na qua baere, ba kepore zozoto tugu! ");
INSERT INTO ghn_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Goto na tumu zana za keni vamanyao betoria tadiria na tugele ria na mua zakazava, ba tonai za mule kamu za qu kubolo vani tu na tuni bulumakau nyobonyobokona ao!> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nari ari za guni vei na tamana aza, <Tuqu, ao za na suveremu gu taqu doru totozo, ko dorudi vei qa izongoria ara za na mua gu ao. ");
INSERT INTO ghn_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ba za leana tugu za taqe roiti ganigani ko taqe qeraqera gita, ura na taimu ani za tori uke tu, ba koviria za toa mule; za tori muma tu aza, ba koviria za tabata soga!> za gua.>> ");
INSERT INTO ghn_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ego za paranga laoria i Jisu ria na nana sepele: <<Kolenana za maka tinoni izizongo za pore maka nana nabulu ko aza za kopudi doru nana zakazava. Ko ria kaki qari vavakato vani na tinoni izizongo ani za na veveina za aru vikevikereria na nabulu za kopudi za na nana poata. ");
INSERT INTO ghn_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nari za kuku valugea na tinoni izizongo za nana nabulu ani, ko ari za guni vei, <Na za aza qa nongoroni ara na veveimu ao ani? Mu valamea na vavakatona na kopu vareregena na qua izizongo, ura koviria munake kopu vareregia na qua izizongo ara ao!> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nari za kole roquroqu makana za na nabulu kopu, <Pala mina vabetoziu na qua bangara pa qua roiti ara. Ko na za beka za mana roitini ara tonai? Qake boka roiti pa inuma ara, beto na tepatepa tadiria na tinoni ba qa keani tugu. ");
INSERT INTO ghn_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ego, leana, ari gu za mana roiti vei ara, ko totonai mana tavabeto pa qua roiti kopu ara ba mari koledia ria na kubo qua baere mari vatataziu pa dia ruma,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ko za kuku makamaka vakamuria aza ria na tinoni qari oqoro tabaria na dia lipulipu tana nana bangara. Za nanazia aza za na tinoni momoe, <Ao ka viza za na mua lipulipu tana bangara taqu?> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nari ari za gua vei za na tinoni aza, <Maka gogoto daramu tototoni oela olive pugeledi,> za gua. Nari za paranga za na tiolata za kopu, <Ego, ani za na mua pepa lipulipu. Mu siqarai nyumu ko mu kutia ka limangavuluputa tototoni oela pugeledi mu gua,> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Beto za nanazia mule za maka, <Goto ao za ae za vei? Ka viza za na mua lipulipu tana bangara taqu?> za guni. Nari za paranga za na tinoni aza, <Maka gogoto baeke vuiti,> za gua. Nari za paranga za na nabulu kopu, <Leana, ani za na mua pepa lipulipu. Mu kutia gu ka vesungavuluputa gu,> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ko za dogoro valavatia na bangara za na nabulu sekesekena ani. Ura za dogoro momoe laoa na totozo uka riza aza, ko za vatanani na nana toa makana. Ria na tinoni pa kasia guguzu ani za qari tavagigala joladi ria na tinoni tana kabere pa roverove vevei zara. ");
INSERT INTO ghn_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Zara za vei ko ma pojadigamu ara za gamu: mu variiadi ria na miu izizongo pa pezo ko mi pore miu baere, ko tonai mina beto pudala nari za mari vatogagamu pa guguzu kole jolana. ");
INSERT INTO ghn_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Aza za tarange pa kopudi na zakazava pekipeki za mina tarange tugu pa kopudi na zakazava lavalavata; goto aza zake tarange pa kopudi na zakazava pekipeki za minake tarange tugu pa kopudi na zakazava lavalavata. ");
INSERT INTO ghn_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Vei munake tarange za gamu pa kopudi na izizongo pa pezo, za i zei mina rangegamu ko mina vakopudigamu na izizongo zozoto? ");
INSERT INTO ghn_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ko vei munake tarange za gamu pa kopuna na izizongo tana goto tinoni, za i zei mina rangegamu ko mina vakopudigamu ria na miu izizongo makamiu? ");
INSERT INTO ghn_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kepore maka nabulu mina boka makarai nabuludi za kori bangara. Pala maka minake tavaraguani goto maka za mina roquroqua; pala mina valavatia maka goto maka mina vakepore veveinai. Ko munake boka makarai nabuludi gamu za na Tamaza beto na izizongo,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ego tonai qari nongoria ria na Parese za vei zara za qari kole vavaledeni ria i Jisu, ura na galegale bulo poata ria. ");
INSERT INTO ghn_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nari ari za gudi vei i Jisu ria, <<Gamu ka viza gu ari za gamu vavadogoro veidigamu na tinoni tuvizimiu makamiu pa moedi na tinoni, ba na Tamaza za gilagilainana na bulomiu. Ura ria na zakazava qari tadogoro vaporeveveidi ta tinoni za qari lulasa ikeredi jola pa dogodogoro tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Na Vavanau beto na kutikuti tadiria na tinoni korokorotai za qari tokaria na tinoni tinganai za kamu pa totozo ti Jone Paputaiso. Podalai pa totozo aza ko za kamu koviria za tatarae za na nongoro leana na veveina na binangara tana Tamaza, ko na kubo tinoni za qari podeke vitivitigia ko mari luge laoa qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ba vei mina murimuri tu za na oka beto na pezo, ba maka gaji ikete pa Vavanau ba minake izongo lotu kenana. ");
INSERT INTO ghn_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Na tinoni za loi pale na maqotana ko za lao elava sogai mule maka goto reko za barabarata tugu aza. Beto aza na tinoni za elavia na reko qari loi pale za barabarata tugu aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","<<Ego kolenana za maka tinoni izizongo za pokodi na poko batabata leadi na poreveveidi beto za suvere ko za tekuteku valeanagana doru rane. ");
INSERT INTO ghn_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ko za kolenana mutugu za maka tinoni varivarivasevina na izongona i Lazarasi, za tubutubu beto doru tinina, ko qari lalao loia ria pa atakamana tana tinoni izizongo aza. ");
INSERT INTO ghn_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ko za kole nyonyoro ganiria na vuvuvuzu ganigani qari lolotu pa tevolo tana tinoni izizongo aza ba zake boka, goto ria na sie tu za qari lao kole memeai na tubuna. ");
INSERT INTO ghn_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ego tonai za uke za na tinoni varivarivasevina, za qari kamu titai ria na mateana aza, ko za lao nyumu kekeria i Ebarahami aza ko za somana tekuteku pa vavolo pa noka. Na tinoni izizongo ba za uke tugu, ko za tagolomo aza. ");
INSERT INTO ghn_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Totonai za kole suvere vitigi pa heli nari za enga zae nari za batia i Ebarahami pa zouna tu beto i Lazarasi za korapa pa keketaina. ");
INSERT INTO ghn_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nari za kuku viviva aza, ari za gua vei, <Kei, Ebarahami, tamaqu! Mu roquroqu tokaniziu. Mu garunia i Lazarasi ko mi totuni pa pie za na karukarusuna gu, ko mi lame valomozia na meaqu, ura qa varivasevi na vitigi ara pa iku ani!> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Nari ari za gua vei i Ebarahami, <Tuqu, mu roquroqua mae aza totonai na toamu ao. Qu izongo betoria ao ria na zakazava leleadi, goto i Lazarasi za suvere varivasevi za totonai. Ba koviria za suvere qeraqera aza, goto ao za qu suvere vitigi. ");
INSERT INTO ghn_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ko nake zakazava ria gu makadi za! Goto maka oqili loluna na revatana jola tugu vei za kole pa varikorapaida gita, ko ria mari nyorogua karovo ko mari lao ketakoi tadigamu mari gua za marike boka, beto ko ria mari nyorogua karovo lame pana tadigami pani mari gua za marike boka,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nari ari za gua vei za na tinoni izizongo, <Ego mina vei za, kei Ebarahami tamaqu, qa tepa vitivitigigo ara ao ko mu garunu laoni gu pa ruma tana tamaqu i Lazarasi zana! ");
INSERT INTO ghn_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ka lima ria na taiqu marene qari korapa ketakoi. Mu pojani i Lazarasi ko mi lao poja vaneqineqidi, keta mari lame pa ia za kolea na vitigi pani,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Nari za paranga i Ebarahami, <Na kutikuti ti Mosese beto ko tadiria na tinoni korokorotai za qari korapa koledia, ko mari vainongoro lao gu tadiria ria,> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nari ari za gua vei za na tinoni izizongo, <Dai, Ebarahami, tamaqu! Vei mina toa mule tu pa uke za maka tinoni ko mina mule lao vavakato vadi za pala mari nongoria, ko mari gabala loiria ria na dia sela,> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nari ari za gua vei i Ebarahami, <Vei marike nyorogua nongoria ria za na kutikuti ti Mosese beto tadiria na tinoni korokorotai, nari za vei mina toa mule tugu pa uke za maka tinoni ko mina mule lao, ba pala mari daidia tugu vazozoto!> za gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ego za paranga laoria na nana sepele i Jisu, <<Ria na zakazava varivatatupe za marike koroto lame, ba mi takulangagana tu aza za valameria. ");
INSERT INTO ghn_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Za leleana jola za na tinoni za roiti vei zara za bi lova momoeni maka patu doa lavata pa ruana, beto bi lao lupi paleni pa kolo lilisina. Aza za leana jolani bi valotua aza na rangerange tana maka tinoni za munyala nana rangerange taqu. ");
INSERT INTO ghn_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ko mu kopu muledigamu pa miu toa ko muke lotu! Bi sela na tavitimu za mu tokea ko mu vabatini nana sela, ko bi gabala aza za mu taleozoni. ");
INSERT INTO ghn_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bi roiti laoni na sela tamu ka vitu totozo pa maka rane aza, ko bi mulemule lao vavaja tamu aza ka vitu totozo tugu, bi paranga vei ari, <Qa sela ara, ko mu taleozoniziu,> bi gua, za muna taleozoni tugu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nari ari qari guni vei na Bangara ria na tinoni tagarunudi, <<Bangara, mu vaneqiria na mami rangerange!>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nari za oeria na Bangara, <<Bi peki vei gu na kikona maka suvege masitadi za na miu rangerange, ba muna boka gu paranga veini ari gamu za na suvege lavata za bagere vakori ani, <Mu tajopu tu ao, ko mu tauma mule pa ivere,> buguni, za pala mina nongorogamu gu. ");
INSERT INTO ghn_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Bi maka gamu za bi kolenana maka nana nabulu za kole varoitiria ria na manugu qari ragatia na piki pa inuma babi kole kopudi na sipi, ko bi beto roiti aza ko bi mule pa ruma, za ae za vei? Pala mina pojani aza aza ko mi tekuteku mae mina guni? ");
INSERT INTO ghn_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Dai, pala minake vei ke! Pala ari tu mina poja veini mule aza za nana nabulu aza, <Mu vatana vaniziu na qua tekutekuna, mu vazaeria na poko nabulu ko muna kole turu kopuniziu totonai mana kole tekutekuqua na bukugequ ara. Liguligu tu beto muna boka tekutekumua ao,> pala mina guni. ");
INSERT INTO ghn_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ae za vei za boka paranga leana laoa tu aza za na nabulu ura za vatabea za na garunu ta nana bangara? Dai! ");
INSERT INTO ghn_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Maka moqaza podeke vei gu aza za gamu. Totonai tu muna vaokotoria gamu ria doru roiti gamu tagarunudi, za ari gu muna paranga vei, <Gami za na nabulu kepore veveimami. Na mami roiti gu za gami roitini!> muna gua gu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ego totonai za korapa rererege zae pa Jerusalema i Jisu, za rerege tutia aza za na varivolozo pikata guguguzu pa Sameria beto pa Qalili. ");
INSERT INTO ghn_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Totonai za korapa lao luge aza pa maka guguzu, za qari lao gozoria ari ka manogaputa tinoni poqupoqudi aza. Qari turu pa zouna ria, ");
INSERT INTO ghn_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ko qari kukuku uui vei ari, <<Jisu! Bangara! Mu roquroqu tokadigami!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nari za batiria i Jisu, ko ari za gudi vei, <<Lao, ko mari dogoro vilotogamu ria na iama,>> za gua aza. Totonai qari korapa lalaodia ria, nari za qari tataloso valioso gu ria. ");
INSERT INTO ghn_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Totonai za gilagila kamua maka ari ka manoga za tori tasalana tu aza, za mule lao ti Jisu aza, za velavela vatarazaea aza za na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ko za lao nyumu sori tungutungu pa nenena i Jisu aza, ko za paranga leana lao tana. (Na tinoni Sameria za na tinoni aza.) ");
INSERT INTO ghn_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nari za paranga i Jisu, ari za gua vei, <<Ari ka manogaputa tu ria na tinoni qa taloso valiosoria ara! Ko pae tu ari ka sia? ");
INSERT INTO ghn_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ae za vei kepore mule za maka za mule lame paranga leana tana Tamaza goto na tinoni karovona gu ani?>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Beto ari za guni vei i Jisu za na tinoni aza, <<Turu, ko mu kenimua. Na mua rangerange za tori salanigo tu,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ego kaki ria na Parese za qari nanazani i Jisu za na totozo mina lame na binangara tana Tamaza. Nari ari za gudi vei i Jisu, <<Na binangara tana Tamaza za minake lame vei pa kaki vinagilagila mari boka tabata. ");
INSERT INTO ghn_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kepore za maka tinoni mina boka paranga vei ari, <Dotu! Pa nari gu aza!> babi <Pani gu aza!> bi gua. Ura na binangara tana Tamaza za korapa gu pa varikorapaimiu gamu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Beto ari za gudi vei ria na nana sepele, <<Qari korapa lame ria na rane totonai pala muna nyorogua batia gamu za maka makamakaina rane gu tana Tuna na Tinoni, ba munake boka batia. ");
INSERT INTO ghn_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pala ari mari poja veidigamu ria na tinoni, <Dotu! Pa nari aza!> babi <Pani aza!> mari gua. Ba keta mu mulongo votu lao tutiria. ");
INSERT INTO ghn_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Za maka moqaza podeke vei na kapi za malara pa noka podalai pa maka kalena ko za lao pa maka kalena, pala zara mina vei za na rane tana Tuna na Tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ba momoe za mina kole gozororia zoku vitigi mae tu aza, beto mina takilu pale mae tadiria na zazae tinoni koviria. ");
INSERT INTO ghn_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mina vei na rane pa totozo ti Noa za na rane tana Tuna na Tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Qari kole tekutekudia na bukugedi ria doru tinoni, beto ria na marene na reko za qari varivarielava ko tinganai za kamu na rane za luge pa aka i Noa, ko za gore na vae ko za vauke betoria ria doru. ");
INSERT INTO ghn_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ko pala mina vei mutugu za taroiti pa totozo ti Loti, qari kole tekutekudia na bukudia, qari kole vavaidia beto qari vavaidi ria na dia zakazava, qari kole umumadia beto qari kole roroitidia ruma. ");
INSERT INTO ghn_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Aza tugu na rane za taloi pa Sodomo i Loti za gore za na iku beto na patu kilakilavadi za qari okoro lagere vei pa noka, ko za vauke betoria ria doru. ");
INSERT INTO ghn_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ko mina maka moqaza podeke vei zara za na rane bola votu lame tana Tuna na Tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Pana rane aza za na tinoni za korapa pa are ruma za minake gore tekuria na nana zakazava pa leo ruma. Maka moqaza podeke vei tugu aza mina korapa pa inuma za minake pavu gabala mule pa nana ruma. ");
INSERT INTO ghn_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mu roqu vakoititia na maqotana i Loti ko! ");
INSERT INTO ghn_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Na tinoni za rabekeni na nana toa za pala mina saivia tugu, goto na tinoni zake rabekeni na nana toa za mina taalo. ");
INSERT INTO ghn_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ma pojadigamu, pa bongina tugu aza za kori tinoni za mari korapa kole varikamudia pa maka lovu; maka za mina tateku vakeni, maka mina taloi pale. ");
INSERT INTO ghn_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kori reko za mari korapa makarai kijagedi vuiti; maka ari kori za mina tateku vakeni, maka mina taloi pale. ");
INSERT INTO ghn_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kori tinoni za mari roiti varikamu pa inuma pa rane aza; maka ari kori za mina tateku vakeni, goto maka mina taloi pale,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nari qari nanazia ari ka viza nana sepele aza, <<Bangara, pala pae mari taroiti ria na zakazava zara?>> qari gua. Nari za oeria i Jisu, <<Ketakoi za kole maka kobukobu manugu ukena za pala mari varikamu ketakoi ria na nyae,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ego beto za pojai mule i Jisu tadiria na nana sepele za maka vavakato vavapada ko mi vagigalairia ko marike munyala pa varavara goto mari varavara laodia gu za gua. Ko ari za gudi vei, ");
INSERT INTO ghn_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","<<Pana maka guguzu za kolenana za maka tinoni varituti zake pangagani na Tamaza beto zake dogoro vaporeveveina ria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ko na suverena tugu pa guguzu aza za maka reko nabonaboko, za lao tepa milimulea na tuvizi tana tinoni varituti ani, ari za gua vei, <Mu mijata vaniziu na tuvizi qa taleni na qua kana,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Na zovaina jola za dainana za na tinoni varituti ani. Ba liguligu tu beto za roquroqu makana za na tinoni varituti ani, ari za gua vei, <Zozoto tugu za qake pangagani ara za na Tamaza, beto ko qake dogoro vaporeveveidi tugu ara ria na tinoni, ");
INSERT INTO ghn_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ba za kamu vaduvili gojoziu ara za na naboko ani. Ko leana ma roiti vani tu ropi na varituti aza za nyoroguani aza. Ura vei manake roiti vei ara za pala mina manogai milimuleziu tugu, ko mina vapavuziu!> za gua za na tinoni varituti,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Beto ari za gua vei za na Bangara, <<Mu nongoria tu aza vei za pojai na tinoni varituti ikikerena ani ko! ");
INSERT INTO ghn_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ba ae za vei? Gamu roquroqua gamu za minake varituti vadi na Tamaza ria na nana tinoni qari kiu alili laoa aza na rane na bongi? Ae vei, pala minake oqanai tokadi tugu na Tamaza ria? ");
INSERT INTO ghn_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Dai! Ma pojadigamu minake oriavo tugu varituti vadi aza ria. Goto ae za vei, tonai mina mule lame na Tuna na Tinoni za pala mina batirianana tu ria kaki tinoni rangerange pa pezo?>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Beto za pojadi mule i Jisu ria kaki qari range muledi na dia toa tuvizidi beto qari dogoro vagoreria ria na goto tinoni za na vavakato vavapada ani, ");
INSERT INTO ghn_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ari za gua vei, <<Koledia za kori tinoni qari zae varavara pa kakabarena zelepade, maka za na Parese goto maka na tinoni tekuteku takisi. ");
INSERT INTO ghn_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Na Parese za turu kalekale makana beto ari za varavara lao vei tana makana, <Tamaza, qa paranga leana ara tamu, ura qake vei ria doru goto tinoni ara. Qake ikiko, nake tinoni ikikerequ, beto qake barabarata, beto qake vevei na tinoni tekuteku takisi pa maka kalequ nari ara. ");
INSERT INTO ghn_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ara za kori totozo pa maka vuiki qa gilagila tabutabu ganigani, beto qa valao vanigo maka pa manoga pa dorudi na qua zakazava qa tekuria,> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Goto na tinoni tekuteku takisi za turu pa zouna tu ko za pangaga enga zae pa noka, goto za kole popoaria pa nana takulanga za na raqoraqona, beto ari za varavara vei, <Tamaza, mu roquroquziu beto mu taleozoniziu, ura ara za na tinoni sela!> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ma pojadigamu ara: na tinoni tekuteku takisi tu ani, nake Parese, za taleozo ko za tuvizi pa dogodogoro tana Tamaza beto za mule laonana pa nana ruma aza. Ura na tinoni za vavalavata muleni makana za mina tavagore, ba na tinoni za vapekai muleni makana za mina tavalavata,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ego qari toka laodi ti Jisu na tudi pekipekidi ria kaki tinoni, ko mi vaopodi na limana aza ko mi manadi qari gua. Tonai qari batiria ria na sepele qari roiti vei zara za qari tokeria ria. ");
INSERT INTO ghn_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ba za kuku tekuria i Jisu ria na koburu pekipekidi ko za parangaria, <<Mu vamalumu lameria taqu ria na koburu pekipekidi, muke suquturia. Ura na binangara tana Tamaza za tadiria tugu qari vevei ria na koburu ari. ");
INSERT INTO ghn_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ma poja zozotodigamu ara gamu: na tinoni zake toa vei na koburu peki pa tekuna na binangara tana Tamaza, za minake boka zozoto lugea aza za na binangara tana Tamaza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ego za lame ti Jisu za maka tinoni matamata tadiria na Jiu, ko za nanaza vei ari, <<Tinoni varivagigalai leleamu, na za za mana roitini ara beto mana teku izongia za na toa jola?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nari ari za guni vei i Jisu aza, <<Ae za vei ko na leleamu qu guniziu tu ara ao? Kepore za maka za leleana, goto na Tamaza gu makana. ");
INSERT INTO ghn_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Qu gilagilariamua ao ria na garunu: <Muke barabarata, muke varivai, muke iko, muke vaijutu sekeseke, beto ko mu valavataria na tamamu na tinamu,> qari gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nari ari za gua vei za na tinoni ani, <<Qa tori tuti betoria tu ara podalai na pekiqu tu ria na garunu ria,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tonai za nongoria i Jisu zara za paranga vei aza za parangia za na tinoni aza, <<Maka zakazava gu za qu oqoro roitini ao. Mu lao vavaidi ria doruna mua zakazava ko na poatadi za mu iadi ria qari varivasevi, beto za muna izongoria ao ria na izizongo pa noka. Pa liguna aza za muna lame ko muna tutiziu ara,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Totonai za nongoro veini aza zara za takulanga aza, ura na tinoni izizongo aza ko za rabekeni nana izizongo. ");
INSERT INTO ghn_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Totonai za dogoria i Jisu za takulanga za na tinoni aza za paranga aza, <<Za tapata vitivitigia na tinoni izizongo za mina lugea na binangara tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","E, zozoto tugu, za tapata jola za na kameli mina sulingi lugea za na lobogona na nila; ba mina tapata jolani mutugu aza za na lugena na tinoni izizongo pa binangara tana Tamaza,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ria na tinoni qari nongoria za vei zara za qari nanazia aza, <<Qokolo, ko vei za, i zei gu za mina boka taalo?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nari ari za gudi vei i Jisu, <<Aza za tapata jola tana tinoni za zake tapata tana Tamaza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Beto ari za gua vei i Pita, <<Dogoria ko! Gami za gami tori loi betoria tu ria doru mami zakazava ko gami tutigomami ao,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nari ari za gudi vei i Jisu, <<Ma poja zozotodigamu ara gamu: na tinoni za loi paleni na nana ruma, na maqotana, ria na taina marene, na tinana na tamana, babi ria na tuna na vei, ko bi nabuluni na binangara tana Tamaza, ");
INSERT INTO ghn_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","za mina tavani vamota koviria, beto pa totozo za korapa lame za mina tekua na toa jola aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ego za toka kaledi i Jisu ria na nana sepele beto ari za gudi vei, <<Mu vainongoro lame! Taqe korapa zae pa Jerusalema za gita, ko pala ketakoi tu za mari gore votu beto za doru zakazava qari korokorotodi ria na tinoni korokorotai pa Kutikuti Tabuna, aza na veveina na Tuna na Tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pala mina tavalao pa limadi ria na tinoni karovodi aza, ko mari vavaledeni, mari komiti vikevikeria, beto mari tue taria. ");
INSERT INTO ghn_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Mari majani na varipiqopiqolona, ko mari vaukea ria aza. Ba pa rane vinaue za mina toa mule pa uke aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ba qarike boka vakaberia ria na sepele ria doru ginugua ari. Ura za tavapae tadiria za na ginuadi ria na nana paranga ari, ko qarike gilagilai aza vei za pojai i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ego totonai za tata lao kamu pa Jeriko i Jisu, za korapa nyumu tepatepanana pa keketai zona za maka tinoni nake batabatana. ");
INSERT INTO ghn_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ko totonai za nongororia na rerege joladi ria na minete tinoni nari za nanazaria na zavagana beka za podo ani za gua. ");
INSERT INTO ghn_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nari qari ule vani, <<I Jisu pa Nazareti za korapa rerege jola pa zona,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ura ko za kuku velavela aza, <<Jisu, Tuna i Devita! Mu roquroqu tokaniziu!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ba qari paranga suqusuqutia na vanogotia ria na tinoni qari momoe aza. Ba tonai za vavivai mutu iapeki za na kuku, <<Tuna i Devita! Mu roquroqu tokaniziu!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nari za turu nogoto i Jisu, za pojadi ko mari toka lameni tana za na tinoni nake batabatana za gua. Ko totonai za tata lao tana za nanazia i Jisu aza, ");
INSERT INTO ghn_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","<<Na za qu nyoroguani ao ko mana roiti vanigo ara?>> za guni. Nari ari za gua vei za na tinoni nake batabatana, <<Bangara, ara za qa nyoroguani ko bi batabata na mataqu qa gua,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nari ari za guni vei i Jisu aza, <<Leana, mu batabata tu ao koviria! Na mua rangerange za tori salanigo tu!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nari zake oriavo tugu batabatana za na tinoni aza, ko za rerege tututinana ti Jisu beto za kole paranga leana na vatarazaea na Tamaza aza. Ko ria na minete tinoni qari batia za vei zara za qari vatarazaea ria doru za na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ego za kamu pa Jeriko i Jisu, ko za rerege jola lao vei ketakoi. ");
INSERT INTO ghn_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Za korapa suverenana tugu ketakoi za maka tinoni na izongona i Zakia. Na tinoni lavata tadiria na tinoni tekuteku takisi, ko na tinoni izizongo aza. ");
INSERT INTO ghn_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Za kole nyonyorogua dogoria aza ae veveina i Jisu, ba na tinoni papapakana gu aza beto ko qari mota jola ria na tinoni, ko zake boka batia i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ko za abutu momoe lao pa moena na puku tinoni ko za soqolo kaiti kezai aza za maka suvege sikamoa ko mi boka batia i Jisu za gua, ura pala ketakoi za mina jola vei aza. ");
INSERT INTO ghn_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Totonai za kamua i Jisu za na ia aza za enga zae ko ari za guni vei i Zakia, <<Zakia, mu siqasiqarai gore! Ura pa ngenari za mana lao suvere pa ruma tamu ara,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Aza tugu za paranga vei zara i Jisu nari za zake oriavo tugu na gorena i Zakia, ko za vakamu valeania pa nana ruma i Jisu beto za qera aza. ");
INSERT INTO ghn_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Totonai qari batia ria na tinoni za vei zara, za qari qumiqumini ria i Jisu, ari qari gua vei, <<Qokolo, na tinoni ani za lao tu suvere pa ruma tana tinoni selana!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ba za turu i Zakia, ko ari za guni vei za na Bangara, <<Bangara, pala mana vadi ara ria na tinoni varivasevidi za na kobuna na qua izizongo. Beto vei ba tekuria ara pa zona sekeseke ria na zakazava tana goto tinoni, za koviria mana vani sogai ara na padana ka made totozo kubo joladi ria qa tekuria ara tana aza,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nari ari za guni vei i Jisu aza, <<Pa rane tugu pa ngenari za taalo za na tatamana ani. Ura i Zakia ba na butubutuna tugu i Ebarahami. ");
INSERT INTO ghn_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Na Tuna na Tinoni za lame ko za nyaqoa ko za aloa na tinoni za muma,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Totonai qari korapa vainongoroni ria na tinoni za na paranga ani, za ule vadi mule aza za maka vavakato vavapada ani. Ura za tata kamu gu pa Jerusalema i Jisu, ko qari roquroqua ria za palu za tata zozoto gu za na totozo mina votu tadiria za na binangara tana Tamaza qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ko ari za gua vei aza, <<Kolenana za maka tinoni, na butubutu bangara, za taloi keni pa maka guguzu pa zouna, ko mi lao tavanyumu bangara beto za mina mule bangara pa nana guguzu za gua. ");
INSERT INTO ghn_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ba totonai za oqoro taloi keni aza za kukuria ari ka manogaputa nana nabulu, ko za ia okoto makadi maka puku poata, beto ari za gudi vei, <Mu varoiti ria tinganai mana mule kamu,> za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ego, ko za taloi keni aza, ba ria na tinoni pa nana guguzu za qarike tavaraguani aza, ko qari garunu vatuti laoni na paranga za na bangara pa guguzu aza, ari qari gua vei, <Gamike nyoroguani gami za na tinoni zana ko mina bangaradigami,> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ba za tavabangara tugu za na tinoni aza ko totonai za mule kamu za kukuria ria na nana nabulu, ko mi dogororia ria na vuadi na poata za iadi za gua. ");
INSERT INTO ghn_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ego ko za luge za na nabulu momoe, ko za paranga, <Bangara, aza na puku poata qu vaniziu ao za koviria za vuani ka manogaputa puku poata mule,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","<Leana jola na mua roiti! Na nabulu leleamu ao! Qu tarange pa kopuna maka zakazava peki ao ko koviria mana vakopunigo ka manogaputa guguzu,> za gua za nana bangara. ");
INSERT INTO ghn_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Beto za luge lao mule za na nabulu vinaori, ko ari za gua vei, <Bangara, na puku poata qu vaniziu za koviria za vuani ka lima puku poata mule,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nari za paranga za na bangara, <Ao za mana vakopunigo ka lima guguzu,> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Beto aza za luge mule za maka nabulu, ko za paranga, <Bangara, ani za na mua puku poata. Qa ude vakole paleni gu ara pa maka poko peki. ");
INSERT INTO ghn_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Qa matagutunigo ara ao, ura maka tinoni tapatamu ao. Qu tekua na mua aza quke vakolea makamu, beto ko qu abua aza quke umani,> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nari ari za gua vei za na bangara, <Na nabulu ikikeremu ao! Na mua paranga makamu mari vakilasigo ao! Beko qu tori gilagilaziumua tu za maka tinoni tapataqu ara. Qa tekua aza qake vakolea, beto qa abua aza qake umani. ");
INSERT INTO ghn_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ba ae za vei za quke lao valugea gu ao pa banga za na qua poata, ko totonai ba mule lame za ba teku votu mule tavitini na vuana?> za gua za nana bangara. ");
INSERT INTO ghn_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Beto ari za gudi vei na bangara ria qari kole turu ketakoi, <Lame ko mu teku vakenini za na puku poata za izongia na tinoni ani, ko mu valao vani na nabulu za izongia ka manogaputa puku poata,> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ba ari qari guni vei ria aza, <Koi, bangara, ba za tori izongorianana tu aza za ka manogaputa puku poata!> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nari ari za gudi vei na bangara, <Na tinoni za tori kolenana tu za mina tavani tamo vakubo mutugu, goto na tinoni kepore nana za mina tateku pale aza iapeki za izongia aza. ");
INSERT INTO ghn_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ego, goto koviria za mu lao tekuria ria qarike tavaraguaniziu beto qarike nyoroguaniziu ko ba bangaradi ara. Toka lamedi ko mu vauke betoria pa moequ ara!> za gua za na tinoni aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Totonai za poja betoa i Jisu za na vavakato vavapada ani, za qari taloi zae ria, ko za rerege pa moedi ria na sepele aza ko za zae pa Jerusalema. ");
INSERT INTO ghn_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tonai za tata kamu pa Betipezi beto pa Betani, pa kubo pa Olive, za garunu momoe laodi aza ari kori sepele, ");
INSERT INTO ghn_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ari za gudi vei, <<Mu lao pa guguzu pa maka karovona pa moemiu nari ko tonai muna kamu za pala muna batia za maka dongiki talova vaturu kolena aza oqoro pore maka tinoni bi tori zaea mae tu aza. Mu ruvatia ko mu toka lameni. ");
INSERT INTO ghn_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Vei mina nanaza veidigamu ari maka tinoni, <Ei, ae za vei ko gamu korapa tu ruvatia zana?> mina gudigamu, za ari muna guni vei, <Na Bangara za nyoroguani,> muna guni,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ko qari taloi lao ari kori sepele, ko qari lao tugu batiria ria vei putaputa tugu za pojadi i Jisu ari kori. ");
INSERT INTO ghn_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ko totonai qari korapa ruvata tekua ari kori za na tuni dongiki, za qari lame nanazaria ria na tinoni poredia ari kori, <<Ei, ae za vei ko gamu korapa ruvatia zana?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nari ari qari gua vei ari kori, <<Na Bangara za nyoroguani,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Qari toka laoni ti Jisu za na tuna na dongiki beto qari lovaza vakeni pa pokotona za na dia poko, beto qari vasurania i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Totonai za korapa surana lao pa dongiki i Jisu, za qari lovazadi pa zona ria na tinoni ria na dia poko. ");
INSERT INTO ghn_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Totonai za tata lao kamu pa Jerusalema i Jisu, pa zona gorena na Kubo pa Olive, za na minete sepele tana za qari podalai velavela vatarazaea za na Tamaza ura qari qeradi na roiti poreveveidi qari batiria. ");
INSERT INTO ghn_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ari qari gua vei, <<Za tamana za na Bangara, aza za lame pa izongona na Tamaza! Na bule za kole pa noka beto mi tavalavata za na Tamaza pa nulu,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kaki ria na Parese pa varikamu tinoni ari qari guni vei i Jisu, <<Tinoni varivagigalai, mu tokeria ria na mua sepele ko mari nogoto!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nari za oeria i Jisu, ari za gudi vei, <<Ma poja valeadigamu ara za gamu: vei marike vagala ria, za ria na patu makadi za pala mari velavela votu,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Totonai za tata kamu pa Jerusalema i Jisu ko za dogoro lao ko za batia nari za lukania. ");
INSERT INTO ghn_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ari za gua vei aza, <<Vei bu gilagilai gu ao pa ngenari za na zakazava qari vagore votua na bule za bi leana! Ba za pae pa matamu ao! ");
INSERT INTO ghn_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Jerusalema! Za korapa lame za na totozo mari lame na mua kana, ko mari sepo varikamuni pezo za na varilivutaimu ko mina zae tu kamua na tobana na guguzu, beto mari suvere varilivutainigo ko munake boka votu luge. ");
INSERT INTO ghn_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mari jegara piaria ria za na guguzu Jerusalema, beto ko mari vaukegamu za gamu gamu suvere pa leona na tobana na guguzu, beto ko kepore za maka patu pa miu ia mina varitopare kole jola, ura gamuke izongo gilagilai gamu za na totozo tonai za lame na Tamaza ko mi alogamu za gua!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Beto za luge lao aza pa leona na kakabarena zelepade, ko za adu votuvotudi ria qari korapa vavaidi na zakazava, ");
INSERT INTO ghn_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","beto za parangaria aza ria, <<Ari tu za poja vei pa Kutikuti Tabuna za na Tamaza, <Na qua ruma za na ruma varavarana, ba gamu roiti veini na bevi tadiria na tinoni raja ikikodi gamu!> za gua,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ego ko na varituti rane za kole varivagigalai pa kakabarena zelepade i Jisu. Qari kole nyaqoa ria na kuta iama, ria qari varivagigalaini na Vavanau beto ko ria na tinoni matamata tadiria na tinoni Jiu za na zona vei beto mari vaukea aza qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ba qarike boka batia za maka zona ko bari boka roitini, ura ria doru tinoni za qari nyorogua vitivitigi ko mari nongonongorodia pa paranga ti Jisu qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Maka rane totonai za korapa varivagigalai beto za taraeni na nongoro leana tadiria na tinoni pa kakabarena zelepade i Jisu, za qari lao tana ria na kuta iama, ria qari varivagigalaini na Vavanau, beto ria kaki tinoni matamata, ");
INSERT INTO ghn_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ko ari qari gua vei, <<Mu ule vadigami moko. Pa neqi za, beto i zei za vanigo na neqi za qu roitidi ao ria na zakazava ari?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nari za oeria, ari za gudi vei, <<Ara ba ma nanazadigamu mae tugu vei maka nanaza ropi. Mu pojaniziu moko: ");
INSERT INTO ghn_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","i zei za vani na neqi i Jone beto za papaputaiso tinoni? Na Tamaza pa noka ba ria gu na tinoni?>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nari qari kole varigonani makadi za na roverove, <<Na za tana gua za? Vei tana paranga, <Pana tana Tamaza pa noka,> tana gua, za pala ari mina gudigita, <Ba ae za vei ko gamuke vazozotoa?> mina gudigita vei. ");
INSERT INTO ghn_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ba vei tana paranga, <Pana tadiria na tinoni gu,> tana gua, za pala mari buti tavurudigita na patu ria na minete tinoni ari. Ura ria doru za qari vazozotoa za maka tinoni korokorotai tugu tana Tamaza i Jone,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ko qari lao oe veini gu ari, <<Gamike gilagilai,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nari ari za gudi vei i Jisu ria, <<Ego, ko ara ba manake ule vadigamu tugu za na veveina na neqi za qa izongia beto qa roitidi ara na zakazava ari,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Beto za pojadi mule i Jisu ria na tinoni za na vavakato vavapada ani: <<Kolenana za maka tinoni za umani na nana inuma qurepi, beto za vakopudi kaki tinoni umuma ko mari varoitia za gua, beto za taloi keni ko za suvere vazovai tu pa maka guguzu karovona pa zouna aza. ");
INSERT INTO ghn_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Totonai za kamua na totozo padupaduku, za garunu laoni tadiria za maka nana nabulu ko mi teku vani na iana na vuadi pa inuma qurepi za gua. Ba qari majamajai ria na tinoni umuma za na nabulu ani, beto qari iju vamule galegale paleni gu. ");
INSERT INTO ghn_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nari za garunu laoni mule aza za maka nana nabulu, ba aza ba qari majamaja vakekea paleni mutugu ria na tinoni umuma, beto qari iju vamule galegale paleni. ");
INSERT INTO ghn_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ba za garunu laoni mule aza za na nabulu vinaue. Ego aza za qari raja vapalekia mutugu ria na tinoni umuma, beto qari gona votu paleni pa peguruna na inuma qurepi. ");
INSERT INTO ghn_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Pa liguna za vei zara za kole roverove za na tinoni porenana inuma ko ari za gua vei, <Na za beka za mana roitini ara? Ego leana, ma garunu laoni gu ara za na tuqu marene aza qa roquroqua. Palu aza za pala mari pangagani,> za gua aza, ko za valaoa. ");
INSERT INTO ghn_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ba totonai qari batia ria na tinoni umuma za na tuna marene aza, nari za ari qari kole varingodo vei makadi, <Ani za na tinoni pala mina teku vakarovoria na izizongo tana tamana ani! Ariagada ko ta vai pale, ko na izizongo tana tamana za tana teku vakarovoria nada,> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ko qari lao gona votu lao paleni pa peguruna na inuma, ko qari vaukea aza,>> za gua i Jisu. <<Ko gamu roquroqua gamu za ae pala mina roiti veidi na tinoni porenana inuma ari ka viza tinoni umuma ari? ");
INSERT INTO ghn_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pala mina kamu vauke beto paledi aza ria doru tinoni qari kopuni na inuma, beto mina vakarovo lao vadi tu ria na tinoni gotodi tu za na inuma!>> za gua i Jisu. Totonai qari nongoria ria na tinoni za poja vei zara aza za ari qari gua vei ria, <<Dai ko dai! Minake izongo vamalumia na Tamaza aza!>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nari za dogoro tari vatogatogazaria i Jisu ria, beto ari za gua vei, <<Na za ropi na ginuana za na Kutikuti Tabuna, aza ari za gua vei, <Na patu qari kilu paleni ria na tinoni vavaturu ruma, za aza tugu za na kuta patu vizovizo.>? ");
INSERT INTO ghn_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Aza za lotuni pa patu aza za mina paleka talomolomoto tugu, beto aza mina lotu takoa na patu aza za mina muja vaavavuru veini na kau,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ria na kuta iama beto ria qari varivagigalaini na Vavanau za qari podepodeke ko mari aru tamania i Jisu pa totozo tugu aza qari gua, ura qari gilagilai ria za na vavakato vavapada ani za jutu lamegami gu gami qari gua. Ba qarike boka aru tamania ria aza, ura qari matagutudi na tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ko qari kole dogoro kopuni za ae totozo ria mari boka tekua maka totozo leana. Qari garunu golomoria ria ria kaki tinoni, ko mari lao paranga sekeseke kale mari vei na tinoni tuvizidi qari gua, beto mari podeke vagonai i Jisu pa kaki nanaza sekesekedi ko mari boka teku valaoa aza pa neqi tana qavuna ko mi tajutu qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Qari lao paranga vei ari ria na tinoni ari ti Jisu, <<Tinoni varivagigalai, gami gilagilaimami gami za aza qu pojai beto qu varivagigalaini ao za na tuvizina. Aza na zozotona beto na zona tana Tamaza za qu varivagigalaini ao, beto ko kepore veveidi tamu ria na tuturuna tadiria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ae vei? Za tavamalumu tugu pana Vavanau za gami mami tabara lao takisi ti Siza, ba dai?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ba za tori dogoro pururia tu i Jisu za na dia nyonyorava ko ari za gudi vei ria, ");
INSERT INTO ghn_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","<<Vabatiniziu moko za maka poata? I zei na izumatana beto na izongona za kole pa poata zana?>> za gua aza. <<I bangara Siza,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nari ari za gudi vei i Jisu ria, <<Ego leana, mu valao vani i Siza ria ti Siza, beto mu valao vani na Tamaza ria tana Tamaza!>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Qari gabara jolani ria za nana oe ko qarike vaqeu, beto ko qarike boka valotuni ria pa dia sekeseke aza pa moedi ria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ego qari lame tana ria kaki Sadusisi, ria qarike vazozotoa za na veveina ria na tinoni ukedi mari turu mule, ko ari qari gua vei, ");
INSERT INTO ghn_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","<<Tinoni varivagigalai, ari za gua vei za kuti vadigita i Mosese, <Bi uke loia maka tinoni za na maqotana ko bi kepore tuna, za pala na taina marene tugu mina elavia za na nabokona aza, ko mina vapore vani na tuna vuana za na tugana za tori uke tu nari,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ego ko koledia ari ka vitu tamatazi marene. Na tugadi pa moa za elavia maka reko ba oqoro pore tuna beto za uke. ");
INSERT INTO ghn_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ko za elava sogai mutugu aza za tuti tana pa moa za na naboko aza, ba za vei mutugu. ");
INSERT INTO ghn_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nari za teku sogai mutugu na vinaue, ba za vei mutugu. Ko qari okoto betodia tu ari ka vitu tamatazi, ba kepore beto tugu na tudi. ");
INSERT INTO ghn_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pa liguligu tu beto za uke za na reko nabonaboko. ");
INSERT INTO ghn_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ego, ko pa rane mari turu mule ria qari uke za pala i zei ari ka vitu ari na maqotana za na reko ani? Ura ari ka vitu doru za qari elavia aza!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nari ari za gudi vei i Jisu ria, <<Na varielava za tadiria gu na tinoni pana toa pa totozo ani, ");
INSERT INTO ghn_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","goto ria na tinoni qari pada ko mari kamua na totozo za korapa lame beto mari turu mule pa uke za marike varielava. ");
INSERT INTO ghn_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ura totonai za marike boka uke ria, goto pala mari suvere vei gu ria na mateana ria, marike uke. Ria za na koburu tana Tamaza, ura na tavatoa muledi pa uke ria. ");
INSERT INTO ghn_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Goto na veveina ria na tinoni mari turu mule pa uke za i Mosese ba za tori vakabere vadigita tu. Ura pa vavakatona na iku za vuruvurungu memea pa tokutoku za pojai i Mosese za, <Na Tamaza ti Ebarahami, na Tamaza ti Aisake, beto na Tamaza ti Jekopi,> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ko na Tamaza tadiria na tinoni toadi aza, nake tadiria na tinoni ukedi. Ura tana Tamaza za ria doru za na toadi beto,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nari qari oe ria kaki qari varivagigalaini na Vavanau, ari qari gua vei, <<Tinoni varivagigalai, za leana jola za na mua oe!>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ego pa liguna aza za qari pangagani ko qarike tuma nanaza soga mulea ria na tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ego ari za gudi vei i Jisu ria, <<Ae za vei ko qari paranga tu ria na tinoni, <Na Karisito za na Tuna i Devita,> qari gua? ");
INSERT INTO ghn_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ba i Devita tugu makana za paranga vei ari pa buka Kera Vatarazae, <Ari za gua vei tana qua Bangara za na Tamaza: mu nyumu keta pa kale matuaqu, ");
INSERT INTO ghn_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tinganai mana veidi na mua tetetena na nenemu ria na mua kana,> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ego za kukuni na Bangara i Devita za na Karisito, ba ae za vei ko mina boka na tuna tu i Devita aza?>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Totonai qari korapa vainongoro ria doru tinoni nari ari za gudi vei i Jisu ria nana sepele, ");
INSERT INTO ghn_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","<<Muna balaudi ria qari varivagigalaini na Vavanau. Qari pokopoko vakakakaza, beto qari lekoleko ria. Qari nyoroguani bari gozoro qeraqeradi ria na tinoni pa ia makemaketina qari gua. Beto qari mijamijataria na nyumunyumuna tadiria na tinoni poreveveidi pa leo ruma varivarikamuna beto pa vavolo. ");
INSERT INTO ghn_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Qari ragaragata tekuria na izizongo tadiria na nabonaboko, beto qari varavara vakakakaza ko mari tadogoro tadiria na tinoni qari gua. Ba na dia vinakilasa za mina ikerena jola>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ego tonai za dogoro laoria i Jisu ria na tinoni izizongo qari loloi poata pa vavakoleni poatana pa leo ruma zelepade, ");
INSERT INTO ghn_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","za batia aza za maka nabonaboko varivarivasevina za lao loiria kori poata kopa peki. ");
INSERT INTO ghn_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nari ari za gua vei aza, <<Ma poja valeadigamu ara za gamu: na naboko varivarivasevina ani za valao vakubo joladi ria doru. ");
INSERT INTO ghn_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ura ria doru zara za qari valaoia gu aza vei za kole jola gu pa dia izizongo, goto na nabonaboko ani za pa nana varivasevi za valao betoa aza tugu vei bi toani aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Totonai qari kole varivavakatoni ria kaki sepele za na veveina na ruma zelepade beto na veveina za tavasari vabatabata leani na patu poreveveidi beto ria na varivana qari tavalao tana Tamaza, za ari za gua vei i Jisu, ");
INSERT INTO ghn_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","<<Ria doru vei gamu batiria gamu ari za korapa lame za na totozo, ko doru patu zara za kepore maka mina varitopatopare kole jola soga, goto mari taqovara beto,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nari za qari nanazia ria i Jisu, ari qari gua vei, <<Tinoni varivagigalai, toto za mina gore votu ria beto ko na za za na vinagilagila ko mina boka tagilagila valeana za na totozo mari taroiti vei zara?>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nari ari za gua vei i Jisu, <<Mu suvere kopu ko kepore maka tinoni mina toka vapirugamu. Ura na motadi ria mari lame pa izongoqu ara, ko ari mari gua vei, <Ara tugu za na Karisito!> mari gua, beto kaki za mari paranga, <Za tori kamu tugu za na totozo!> mari gua. Ba keta mu mulongo tutiria. ");
INSERT INTO ghn_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Munake matagutu tonai muna nongoroni na nongorona na varipera, beto na varipikataidi ko na okoto turu kaledia na guguzu. Ria na zakazava vevei zara za pala mari gore votu mae tu, ba nake aza za na vinabetona,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Beto za parangaria aza ria, <<Maka puku tinoni mina turu talea maka goto puku tinoni, beto maka binangara mina turu talea maka goto binangara. ");
INSERT INTO ghn_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Pala kubo ia mari raja ria na nunu lavalavata, na songe beto na oja, beto pala mari tabata ria na vinagilagila varivamatamatagutudi pa noka. ");
INSERT INTO ghn_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ba totonai mari oqoro taroiti na zakazava ari, za pala muna taaru tamana beto muna tangangangulu tadiria na tinoni pa veveiqu ara za gamu. Muna tavalao ko mari tutidigamu pa ruma varivarikamuna tadiria na Jiu, beto mari valugegamu pa ruma varipiuna, beto mari toka laodigamu pa moedi ria na bangabangara beto na qavuna pa ginuguaqu ara za gamu. ");
INSERT INTO ghn_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ba aza za maka totozo leana tadigamu ko muna vavakato vadi na nongoro leana za tonai. ");
INSERT INTO ghn_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ko mu vanyumu valeania pa miu roquroqu za na veveina munake pavu roquroqu mamatani aza ae tana oe lao veidi ria mari tutidigita muna gua. ");
INSERT INTO ghn_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ura ara tu mana vadigamu ria na paranga beto na bokaboka muna pojaria gamu, ko kepore maka za raja kolokolosogamu mina boka oeria babi vasekeria ria na miu paranga. ");
INSERT INTO ghn_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ria na tinamiu na tamamiu, na taimiu marene, na tavitimiu, na miu baere qarike vazozoto, ba pala mari toka laodigamu tugu pa varituti, ko kaki gamu za pala muna tavauke tugu. ");
INSERT INTO ghn_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pana ginuguaqu ara za marike tavaraguadigamu ria doru tinoni za gamu. ");
INSERT INTO ghn_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ba maka galu vurungu gu pa batumiu ba minake izongo tapuki pale za gamu. ");
INSERT INTO ghn_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Vei muna turu vangajuria za muna tekua gamu za na toa jola!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","<<Totonai muna batia qari variidi livutaini ria na nana kana za na guguzu Jerusalema, za totonai za pala muna gilagilaimiu za za tata za na totozo mina tajegara aza. ");
INSERT INTO ghn_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ko pa totozo aza za ria na suveredi pa Jiudia za mari uku zagere beto pa okoto kubo ketakoi, ria qari suvere pa leona na guguzu pa Jerusalema za mari uku votu keni beto, beto ko ria qari suvere pa peguruna na guguzu Jerusalema za marike mule luge lao pa korapa guguzu Jerusalema. ");
INSERT INTO ghn_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ura ria za na rane varivakilasa tonai mari gore votu ria dorudi vei za pojai na Kutikuti Tabuna. ");
INSERT INTO ghn_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Na rane takulanga tadiria na reko pore iapadi beto ria poredia melalu za totonai! Ura na tapata lavata za mina kamu pa abana, ko na vinakilasa tana Tamaza za mina raja tadiria na tinoni ari! ");
INSERT INTO ghn_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kaki ria za pala mari tasobe vauke, kaki pala mari teku vapinauzu laodi tadiria na doru tinoni karovodi. Mari lame kole pipiaria ria na tinoni karovodi za na guguzu Jerusalema ko tinganai mina okoto tu za na totozo tadiria na tinoni karovodi,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","<<Kaki vinagilagila za pala mina tabata pa tapo, pa popu, beto pa seru. Pa pezo, ria na pukupuku tinoni mari nyunyala ko mari kununu rura, ura mari matagutuni ria za na ovangana na ivere beto na tovogo lavalavata. ");
INSERT INTO ghn_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mina vadigereria beto mari matagutu ria na tinoni totonai mari kole adono dogororia ria na zakazava ikikeredi mari lame pa kasia guguzu, ura ria na neqi pa vavagalo za pala mari tajou vakanoko. ");
INSERT INTO ghn_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ego pa liguna aza za mari batia za na Tuna na Tinoni mina bola pa lei, ko mina lame tavitia na neqi lavatana beto na kabere. ");
INSERT INTO ghn_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ko totonai mina korapa podalai taroiti za na roiti vevei ari za muna turu gu ko muna enga zae ko muna gelegeleni, ura za tata gu mina bola votu lame za na miu inaalo,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Beto za pojadi i Jisu za maka vavakato vavapada: <<Mu dogoria za na suvege piqi beto ria doru goto suvege ko! ");
INSERT INTO ghn_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Totonai muna batiria mari podalai ijoko ria za gamu gilagilaimiu makamiu gamu za tata za na totozo mangini. ");
INSERT INTO ghn_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Maka moqaza podeke vei tugu za tonai muna batiria gamu mari taroiti ria na zakazava ari za pala muna gilagilaimiu gu gamu za tata lame za na binangara tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ma poja zozotodigamu ara gamu: totonai mari oqoro uke beto ria na zazae tinoni pa totozo koviria, za mari gore votu ria doru zakazava ari. ");
INSERT INTO ghn_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mina maragutu tu za na oka beto na pezo, ba ria na qua paranga za marike izongo maragutu podeke,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","<<Mu kopu muledigamu, ko na roqumiu muke vamamatani na toa goborona, na tapatianani na bukubuku, beto na takulangadi na zakazava tana toa pa pezo, ura keta mi vasiborogamu na lame tana rane aza. ");
INSERT INTO ghn_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ura na rane aza za pala mina lame vasiboro veidi na saduru ria doru tinoni qari suvere pa doruna na guguzu pa pezo. ");
INSERT INTO ghn_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ba gamu mu suvere kopu beto mu varavara doru totozo, ko muna boka varene za gamu totonai muna luge laoria gamu ria na ginugua ari beto ko muna boka turu varene pa moena na Tuna na Tinoni,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ego ko za suvere varivagigalai pa kakabarena zelepade i Jisu beto doru veluvelu za lao aza pa kubo Olive ko za puta ketakoi na bongi. ");
INSERT INTO ghn_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ko doru volavolaza za qari lalao pa ruma zelepade ria doru tinoni, ko qari nongonongoro pa varivagigalai tana. ");
INSERT INTO ghn_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ego ko za tata gu za na vavolo Bereti Nake Kovuruna, aza qari gigalani na vavolo Alokata. ");
INSERT INTO ghn_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Qari matagutudi ria na kuta iama beto ko ria qari varivagigalaini na Vavanau ria na tinoni, ko za vei za qari kole nyaqoa maka zona ko mari aru tamana golomia i Jisu ko mari vaukea qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ego beto za lugea i Setani i Jiudasi, aza qari kukuni i Isikarioti, aza tugu maka ari ka manogori sepele. ");
INSERT INTO ghn_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ko za turu keni i Jiudasi ko za lao tadiria na kuta iama beto na matamata tadiria na tinoni kopu pa ruma zelepade, ko qari vavakatoni ria za vei beto mina boka gabala kana vadi aza i Jisu qari guni. ");
INSERT INTO ghn_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nari qari qerani ria za na vinatuvizi za roiti vadi i Jiudasi, ko qari varivaegoni tugu ria za mari vani na poata aza qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Za vaegoa tugu i Jiudasi za na dia nyorogua ko za podalai nyaqoa gu aza za maka totozo leana vei beto marike boka gilagilai na tinoni, ko mina teku valao vadi ria i Jisu za gua. ");
INSERT INTO ghn_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ego za kamu za na ranena na vavolo Bereti Nake Kovuruna totonai qari kuboloria na lami vavolo Alokata. ");
INSERT INTO ghn_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ko za garunuria i Jisu ari Pita i Jone, ari za gudi vei, <<Mu lao, ko mu vanaqitia za na tekutekuna Alokata tadigita ko tana tekuteku,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nari ari qari guni vei aza, <<Pae za qu nyoroguani ao ko mami lao vatanani gami?>> qari gua ari kori. ");
INSERT INTO ghn_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nari ari za gudi vei i Jisu, <<Vainongoro! Tonai muna lao kamu gamu kori pa guguzu pa Jerusalema, za pala muna gozoria gamu kori za maka tinoni za pogozo jagi kolo. Muna tutia za na tinoni aza ko muna lao luge pa ruma za luge aza. ");
INSERT INTO ghn_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ko ari muna poja veini za na tinoni porenana ruma, <Ari za gua vei za na Tinoni varivagigalai, Pae za na lose ketakoi mana tekuni ara beto ria na qua sepele za na tekutekuna Alokata? za gua,> muna guni. ");
INSERT INTO ghn_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Pala mina vadogorodigamu aza za maka lose lavata pa narena pa nulu, za tori tavatana vadigita tu. Ko ketakoi za muna lao vatanani gamu za nada tekutekuna,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Qari taloi keni ari kori, ko qari lao tugu batia ari kori doru zakazava vei tugu za tori pojadi tugu i Jisu. Ko qari vatana vakolea ari kori za na tekutekuna Alokata ketakoi. ");
INSERT INTO ghn_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Totonai za kamua za na totozo tana Alokata, za tekuteku tavitiria i Jisu pa tevolo ria na nana tinoni tagarunudi. ");
INSERT INTO ghn_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ari za gudi vei aza ria, <<Qa nyorogua vitivitigini tugu ara ko ba tekuteku tavitidigamu gamu za na tekutekuna Alokata ani, totonai qa oqoro kamua ara za na vitigi. ");
INSERT INTO ghn_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ura ma poja veidigamu ari: manake izongo teku sogai mule ara za na tekutekuna Alokata, tinganai mina tavagore votu za na ginuana pa binangara tana Tamaza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Beto za tekua i Jisu za na kapa vaini, ko za paranga leanani, beto ari za gudi vei, <<Pia, tekua, ko mu okoto bukua. ");
INSERT INTO ghn_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ma pojadigamu: podalai koviria za manake buku sogai ara za na vaini ani, tinganai mina lame na binangara tana Tamaza,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Beto za tekua mule za maka kipa bereti, ko za paranga leanani, za kipakipai ko za okoto iadi, beto ari za gua vei, <<Ani za na tiniqu qa vadigamu ara gamu. Mu tekua pana roquroququ ara,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ego ko pa zona vei mutugu aza za, liguna za beto na tekutekuna Alokata, za tekua aza za maka kapa vaini, ko ari za gudi vei, <<Na kapa vaini ani za na vinaego koregana tana Tamaza, za vei na orunguqu za nyoa pa laemiu gamu. ");
INSERT INTO ghn_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ba dogoro! Aza mina gabala kanaziu ara za korapa gu nyumu tavitiziu ara pa tevolo ani! ");
INSERT INTO ghn_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mina tavauke za na Tuna na Tinoni vei za nyoroguani na Tamaza, ba mina tekua na takulanga lavata za na tinoni za gabala kanaziu ara!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Totonai qari nongoria zara za gua vei aza, za qari varigua makadi ria na sepele i zei beka ari ka viza za mina roiti vei qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Maka varitoke veveina i zei ria za pala na tinoni poreveveina jola qari gua za poraka votu lame vei tadiria na sepele. ");
INSERT INTO ghn_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nari ari za gudi vei i Jisu, <<Ria na bangaradi ria na tinoni karovodi za qari lalaedi gu makadi ria za na toa tadiria na dia tinoni, beto ko ria pore dia viva ba qari nyorogua tagigala <Na Tinoni Leadi Ko Na Baere Tadiria Na Tinoni> tugu. ");
INSERT INTO ghn_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ba gamu za munake vei zara. Aza mina poreveveina jola tadigamu za mina vapeki muleni tadiria doru, beto aza za suvere matamatadigamu za mina kole vei na miu nabulu tu. ");
INSERT INTO ghn_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ura i zei za na poreveveina jola? Aza za tekuteku pa tevolo, ba aza na tinoni za vatana? Aza tugu za tekuteku pa tevolo ke! Ba ara za na qua suvere tadigamu za qa vei gu aza na nabulu. ");
INSERT INTO ghn_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Gamu za gamu tori suvere tavitiziu tu pa tapata qa gozororia ara. ");
INSERT INTO ghn_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ko za vei za maka moqaza vei na Tamaqu za tori vaniziu tu na binangara, nari za gamu ");
INSERT INTO ghn_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ba muna somana tekuteku na buku pa qua tevolo pa qua binangara za gamu, beto gamu muna nyumu pa nyumunyumuna bangara ko muna totolidi ari ka manogori butubutu Izireli,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Beto i Jisu ari za guni vei i Saimone, <<Saimone! Saimone! Za tori vamalumia tu na Tamaza i Setani ko mina podekegamu, ko mina varipikataidi na leadi beto na ikeredi. Maka moqaza podeke vei na tinoni umuma za pikataria na ikikadi na kiko pa kikodi. ");
INSERT INTO ghn_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ba ara qa tori varavaranigo tu ao Saimone, ko na mua rangerange mike munyala. Ko tonai muna neqi soga mule pa mua rangerange ao, za muna tokadi ao ari ka viza taimu sepele zara ko muna vaneqiria na dia rangerange,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nari ari za gua vei i Pita, <<Bangara, ara za qa vanaqiti ko mana tuti lugego ao pa ruma varipiuna ko mana uke tavitigo tugu!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nari ari za guni vei i Jisu aza, <<Ma pojanigo, Pita! Mina oqoro kiu na kokorako ngena bongi, za muna kilu paleniziu ara kue totozo ao,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Beto ari za gudi vei i Jisu ria na nana sepele, <<Totonai qa garunu vakenigamu ara, beto qa pojadigamu ko munake pogozo kurakurani poata, na mane beto ko na sadolo qa gudigamu, za ae za vei? Za papakadigamu tu kaki zakazava?>> za gua aza. Nari ari qari gua vei ria, <<Kepore tugu maka za babi papakani,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nari ari za gudi vei i Jisu, <<Ego, ba koviria za aza za kolenana kurakurani poatana babi na mane, za mi pogozia tugu. Ko aza kepore nana benete varipera, za mi lao vavaini na nana koti ko mi vai tekua maka benete. ");
INSERT INTO ghn_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ura ma pojadigamu aza vei za kole pa Kutikuti Tabuna, aza ari za gua vei, <Za somana tanguti tavitidi ria na tinoni ikikeredi aza,> za gua, za mina tavagore votu. Ura aza za takuti na veveiqu ara, za pala mari gore votu tugu,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nari ari qari gua vei ria na sepele, <<Bangara, dogoro! Ari za kori benete varipera tadigita!>> qari gua. Nari ari za gudi vei i Jisu, <<Leana, beto gu koviria!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ego za taloi pa Jerusalema i Jisu, ko za zae pa kubo pa Olive, za vei tugu za tori roroitini tugu aza kubo totozo. Ko qari tuti laoa tugu aza ria na nana sepele. ");
INSERT INTO ghn_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Totonai za kamu aza pa ia ketakoi, za ari za gudi vei ria na nana sepele, <<Mu suvere varavara, ko muke lotu pa toketoke,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Beto za rerege lao vazou iapeki aza, pada zouna boka gona laoni maka patu, ko za nyumu sori tungutungu pa pezo, ko za varavara vei ari, ");
INSERT INTO ghn_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","<<Tamaqu, vei muna vamalumia ao, za mu varijoa taqu za na totozo vitigi ani. Ba nake qua nyorogua ba na nyorogua tu tamu za mina tatuti,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Beto za bola votu kamu vei pa noka za maka mateana ko za vaneqia aza. ");
INSERT INTO ghn_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Za takulanga vitivitigi aza, ko za varavara vaneqineqi jola ko na ipatana za vei na orungu qari ononi gore pa pezo. ");
INSERT INTO ghn_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Beto za turu aza ko za rerege mule lao tadiria na nana sepele za gua, za batiria qari tori puta tu, ura za mabo pavu na tinidi pa takulangana aza. ");
INSERT INTO ghn_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nari za ari za gudi vei, <<Ae za vei ko gamu puta tu? Mu iqolo ko mu tatakole varavara, ko muke lotu pa toketoke,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Totonai za korapa paraparanga vei zara i Jisu, za bola kamu gu za maka minete tinoni za tokaria i Jiudasi, aza maka ari ka manogori sepele. Za rijo lao tatai aza i Jisu ko za aoa. ");
INSERT INTO ghn_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nari ari za guni vei i Jisu aza, <<Jiudasi, qu gabala kanani ago pa ao vei zara za na Tuna na Tinoni?>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Totonai qari batia ria na sepele qari tutia aza za na ginugua mina taroiti qari gua, za qari nanazia i Jisu, <<Bangara, mami lao qatadi na mami benete varipera?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Beto maka ari ka viza nana sepele za lao taqaza teusu paleni za na kale talinga matuana na nabulu tana kuta iama lavata. ");
INSERT INTO ghn_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ba za tokeria i Jisu, ari za gudi vei, <<Beto gu, za pada gu munake vajolai!>> za gua. Beto za lao arua aza za na talingana na nabulu, ko za salania. ");
INSERT INTO ghn_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Beto ari za gudi vei i Jisu ria na kuta iama, na matamata tadiria na tinoni kopu pa kakabarena zelepade, beto tadiria na tinoni matamata tadiria Jiu, ria qari aru tamania, <<Ae za vei? Na tinoni raja ikiko beto na tinoni varivarivai ara, ko gamu pogozo bolaniziu na benete na kubau gamu? ");
INSERT INTO ghn_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Beko doru rane qari jola zara na suverequ gu pa kakabarena zelepade ara, ba gamuke aru tamanaziu tu! Ba ani gu ko na miu totozo gamu nyoroguani muna roitini, aza na totozo za kole bangara na neqi tana rodomo!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Beto za qari aru tamania ria i Jisu ko qari toka laoni pa ruma tana kuta iama lavata. I Pita za tututi vazozounana tu pa ligudi ria. ");
INSERT INTO ghn_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ko totonai za qari vatoaia ria za maka iku pa varikorapaina na bolebole sebesebe na ruma tana kuta iama lavata beto qari kole nyumu varilivutaini ria, za lao somana nyumu nana tugu tadiria i Pita. ");
INSERT INTO ghn_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Totonai za bati vaia maka nabulu reko pa malarana na iku i Pita, za dogoro taria, beto za parangia, <<Ani tugu za maka tinoni za tututia i Jisu!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ba za kilu pale i Pita aza, ari za gua vei, <<Koi, siu, qake gilagilai ara za na tinoni zana!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ko za zovai gu iapeki beto za dogoro vaia mule maka tinoni aza, ko ari za guni vei, <<Ao ba maka tugu gamu qu tutia i Jisu ao!>> za guni. Nari ari za gua vei i Pita, <<Qokolo, nake ara za!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ego ko za jola padana maka aoa za lamegana gu mule za maka tinoni, ko ari za paranga vaneqineqi vei, <<Ani vapura zozoto gu za maka ria qari tutia i Jisu, ura maka tinoni Qalili za na bangara ani!>> za gua za na tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ba ari za gua vei i Pita, <<Qokolo, qake izongo vagilagila podekia tugu ara aza qu korapa pojai ao zana!>> za gua. Aza tugu za korapa paranga vei zara i Pita, za kiu gu za na kokorako. ");
INSERT INTO ghn_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Totonai za balinga za na Bangara ko za dogoro taria i Pita, nari za roquroqu kamua i Pita totonai aza vei za tori pojani tu na Bangara aza perangaina, aza ari za gua vei, <<Mina oqoro kiu na kokorako ngena bongi, za pala muna kilu paleniziu ara kue totozo ao,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ko za votu lao pa peguru i Pita ko za lukana vapazani. ");
INSERT INTO ghn_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ego ria na tinoni qari sadereni i Jisu za qari vavaledeni beto qari majamajai aza. ");
INSERT INTO ghn_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Qari piko suqutu vapaea na matana, beto qari totepia, <<Ego, mu uleni tu! I zei moko za korapa majago?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Beto kubo mule za na paranga ikikeredi qari poja tarini aza. ");
INSERT INTO ghn_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Totonai za rane na kota za qari varikamu ria na tinoni matamata tadiria na Jiu, na kuta iama, beto ria qari varivagigalaini na Vavanau, ko za tatoka lao pa moena na kauniseli tadiria na Jiu i Jisu, ");
INSERT INTO ghn_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ko qari parangia ria i Jisu, <<Vei mina Karisito ao, za mu ule vadigami moko!>> qari gua. Nari ari za gudi vei aza, <<Vei mana pojadigamu ara tugu za na Karisito mana gua, ba munake vazozotoziu tugu gamu. ");
INSERT INTO ghn_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Beto vei mana nanaza laodigamu maka nanaza ara, ba munake boka oeziu za gamu. ");
INSERT INTO ghn_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ba nake zovaina za na Tuna na Tinoni za mina nyumu pa kale matuana na Tamaza vivana jola,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Qari nanaza beto laoa ria doru aza, <<Ko ae vei? Ao za na Tuna na Tamaza?>> qari guni. Nari za oeria aza ria, <<Gamu korapa pojaimiu tugu gamu ko ara za na Tuna na Tamaza,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nari za qari paranga ria, <<Na vavakato vinazozoto za mule taqe nyaqoa? Ura taqe nongoria makada pa beruberuna makana aza,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ego ko qari turu ria doru qari somana pa kauniseli, ko qari toka laoni ti Paelati i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Qari podalai jutua ria ketakoi aza, ari qari gua vei, <<Gami poai gami za na tinoni ani za kole toka vapiruria na nada tinoni: za pojadi na tinoni ko marike tabara takisi lao tana bangara Siza, beto ko za gigala muleni tugu makana aza za na Karisito maka bangara za gua,>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ko za nanazia i Paelati i Jisu, <<Ao tugu za na bangara tadiria na Jiu?>> za guni. Nari za oea aza, ari za gua vei, <<Vei tugu qu korapa pojai ao zana,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nari ari za gudi vei i Paelati ria na kuta iama beto ria na minete tinoni, <<Kepore za maka sela ba batia ara ko bi boka tavakilasani za na tinoni ani,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ba qari jutu tokatokai ria aza, ko ari qari gua vei, <<Pa nana varivagigalai za varivarivatagigiridi na tinoni doru ia pa Jiudia zana. Za podalai tu pa Qalili, ko koviria za kamu pani,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Totonai za nongoria i Paelati za vei zara, za nanaza aza, <<Ae vei, na tinoni Qalili za na bangara ani?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ko totonai za gilagilai i Paelati na lame veina pa Qalili i Jisu, pa ia ketakoi za bangara i Herodi, nari za garunu laoni aza ti Herodi i Jisu. Totonai i Herodi ba za korapa tugu vei pa Jerusalema. ");
INSERT INTO ghn_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Totonai za batia i Jisu za qera vitivitigi i Herodi, ura za nongorianana tugu za na veveina i Jisu ko za nyorogua batia tugu i Jisu. Ko za kole nyorogua batiria za kaki roiti varivagabaradi mina roitidi i Jisu za gua. ");
INSERT INTO ghn_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ko za kole doru nanazia i Herodi i Jisu, ba kepore maka oe bi valaoa i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ko qari turu votu lao ria na kuta iama beto ria qari varivagigalaini na Vavanau, ko qari jutu vivivai i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Za paranga ngangangulia beto za roiti veini maka tinoni ikikerena i Herodi beto ko ria na solodia i Jisu, beto za qari vazaeni maka poko gojo doru batabata leana tana bangara, beto za qari garunu mule laoni ti Paelati. ");
INSERT INTO ghn_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ko pa rane tugu aza za qari varibaere mule ari Herodi i Paelati, goto tonai oqoro kamua na totozo aza za na varikana koledi ari kori. ");
INSERT INTO ghn_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ego za kuku varikamudi i Paelati ria na kuta iama, na tinoni matamata tadiria na tinoni Jiu, beto ko ria na tinoni, ");
INSERT INTO ghn_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","beto ari za gudi vei aza ria, <<Gamu toka kamuni gamu taqu za na tinoni ani, ko gamu jutua aza za kole toka vapeleria ria na tinoni gamu gua. Ba totonai qa kole nanaza vilovilotia ara pa moemiu za qake boka batia ara za maka sela tana pa ginugua gamu jutuni gamu aza. ");
INSERT INTO ghn_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ko i Herodi ba zake batia tugu maka sela tana, ko za vei za garunu valamea mule tadigita. Ko gamu batia? Ko na kaberena gu za kepore za maka ginugua ikikerena za roitini na padana vei beto mina tavaukeni aza. ");
INSERT INTO ghn_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Ko vei za mana majai gu ropi beto za mana ruvata vakenia gu,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ba qari makarai velavela votu ria na tinoni, <<Vaukea na tinoni zana, goto i Barabasi tu za mu ruvata valame vadigami!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","I Barabasi ani za tavaluge pa ruma varipiuna ura za somana tadiria qari rajai na qavuna beto za varivai. ");
INSERT INTO ghn_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Za nyorogua ruvatia i Paelati i Jisu, ko za paranga laoria mule ria na minete tinoni. ");
INSERT INTO ghn_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ba qari velavela laoa tugu ria i Paelati, <<Vaukea pa korosi! Vaukea pa korosi!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nari ari za gudi vei na vinaue totozo i Paelati, <<Ura ae vei, na za na roiti ikikerena za roitini aza? Ara qake izongo batini tana za maka sela vei padana beto mina tavauke aza! Ko ma majai gu ropi beto mana ruvata vakenia,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ba qarike koroto tugu kukuku velavela za mina tavauke tugu i Jisu qari gua, ko tinganai qari vamunyalia tu ria za na roquna i Paelati. ");
INSERT INTO ghn_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ko za vaegoa i Paelati ko mina tavauke aza, vei qari nyoroguani ria. ");
INSERT INTO ghn_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ko za ruvatia aza vei qari nyoroguani ria za aza na tinoni za tavaluge pa ruma varipiuna. Goto i Jisu za loi laoni aza ko mari roitini za aza vei qari nyorogua roiti veini ria tana. ");
INSERT INTO ghn_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ego totonai qari toka kenini ria na solodia i Jisu, za qari lao ko qari aru tamania ria na solodia i Saimone, maka tinoni pa Saerini, na koni bola kokona pa peguruna guguzu, ko qari vapogozoni na korosi ko za pogozo tutini i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Maka minete tinoni lavata za tutia i Jisu, kaki ria za ria na reko qari kole lukana takulangani i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nari za balinga mule tadiria na reko i Jisu, ko ari za gua vei, <<Gamu na reko pa Jerusalema! Muke lukanaziu ara, goto mu lukana muledigamu makamiu beto ko ria na tumiu. ");
INSERT INTO ghn_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ura qari korapa lame ria na rane, tonai ari mari paranga vei na tinoni, <Qari vavaguadia tugu na vapuradi ria na egoro, beto ko ria qarike vapodo koburu na varivasusu!> mari gua. ");
INSERT INTO ghn_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Beto za mari paranga laoria ria na kubo, <Mu taqovara tari gami!> marigu, beto ria na goregore za <Mu amu tarigami!> mari gudi. ");
INSERT INTO ghn_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Vei mari roiti lamedi ria taqu ara qa vei na suvege toana za na zakazava ari, za ae pala mari roiti veidigamu za gamu gamu vei na suvege ukemiu? Pala mina ikerena jola za mari roiti laoni ria tadigamu!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ari kori tinoni ikikeredi za qari toka kamudi tugu ko mari vauke tavitini i Jisu qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ko totonai qari kamu ria pa maka ia na izongona pa Batu Tomete za qari patani pa korosi ketakoi i Jisu, beto ko vei tugu ari kori tinoni ikikeredi, maka keta pa kale matuana beto maka keta pa kale merina. ");
INSERT INTO ghn_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Za paranga i Jisu, <<Tamaqu, mu taleozodi, ura qarike gilagilai ria za na manugu qari roitini,>> za gua aza. Beto qari gonani ria na solodia za na patu mijamijata beto qari tekua ria za na nana poko. ");
INSERT INTO ghn_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ko na minete tinoni za qari kole gu turu dogodogoro lao. Goto ria na matamata tadiria Jiu za qari kole vavaledeni beto qari kole ngangangulia i Jisu, ari qari gua vei, <<Na goto tinoni tu za aloria aza. Ego, koviria za mi alo muleni tu makana vei mina aza zozoto tugu za na Karisito tana Tamaza, aza na tamijatana!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ria na solodia ba qari vavaledeni tugu aza, beto qari vani na vaini pazana, ");
INSERT INTO ghn_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","beto qari paranga laoa ria aza, <<Vei mina Bangara tugu tadiria na Jiu ao, za mu alo mulenigo makamu!>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Keta pa batuna na korosi pa narena aza za takuti ria na paranga ari, na tinajutuna aza. Ari za gua vei: NA BANGARA TADIRIA NA JIU ZA ANI! ");
INSERT INTO ghn_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ego maka ari kori na tinoni ikikerena za tavatiti pana maka korosi ketakoi, za paranga vikevikere laoa aza, <<Qokolo, nake Karisito ao? Mu alogo makamu beto gami kori tugu vei!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ba maka ari kori za tokea aza za koni paranga zana, ari za guni vei, <<Qokolo, quke matagutuni ao za na Tamaza? Ao ba qu tavakilasa vei tugu za vei aza. ");
INSERT INTO ghn_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ba gita kori za na padada tugu tana tavakilasa, ura gita kori za taqe taiani na laedi ria na nada roiti ikikeredi. Goto na tinoni ani za kepore nana sela,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Beto za paranga laoa i Jisu, <<Jisu, mu roquroquziu totonai muna lame vei na Bangara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nari za oe laoa i Jisu aza, <<Ma poja zozotonigo ara ao: pa ngenari tugu ani muna somana tavitiziu ara pa guguzu leleana ao,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ego padapada vei manogori koloko korapa rane za rodomo za na tapo ko za udea na rodomo za na guguzu tinganai za kamua na kue koloko. ");
INSERT INTO ghn_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ko za tarikataori za na poko tobana na zelepade madina pa Jerusalema. ");
INSERT INTO ghn_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Beto za lukana velavela i Jisu, ari za gua vei, <<Tamaqu, qa loi laoni ara pa limamu ao za na onguqu!>> za gua, beto za loia za na singo betobetona. ");
INSERT INTO ghn_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Totonai za batia na tinoni matamata gogoto ria na roiti vei qari pidoko ari, za vatarazaea aza za na Tamaza, beto ari za gua vei, <<Zozoto! Na tinoni tuvizina ani,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ria doru tinoni za qari varikamu kole dogodogoria na vaukena i Jisu. Ko totonai qari batia na roiti qari taroiti zara za qari okoto poararia na raqoraqodi pa dia takulanga, beto qari okoto mule kenidia pa dia ruma. ");
INSERT INTO ghn_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ria doru vei qari gilagila valeania i Jisu beto ko ari ka viza reko qari koko tutia lame aza pa Qalili za qari turu pa zouna ko qari kole dogoro laoria ria na roiti ari. ");
INSERT INTO ghn_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ego kolenana za maka tinoni na izongona i Josepa, na somana mebana pa kauniseli tadiria na Jiu, beto maka tinoni leana beto na tuvizina aza. ");
INSERT INTO ghn_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Zake somana vaegoa aza za na mijamijata tadiria na kauniseli ko mina tavauke i Jisu. Na tinoni pa guguzu pa Arimatia maka guguzu pa ia pa Jiudia aza, beto ko za kole tugu adonia aza za na lamena na binangara tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ko za lao pa moena i Paelati aza, ko za tepai za na kobukobu tinina i Jisu ko mi keni golomia za gua. ");
INSERT INTO ghn_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ko za teku vagorea aza za na tinina i Jisu, beto za udeni maka poko keala liosona, ko za lao vakolea pa leona maka bevi patu na tagura kori vakolena, ko oqoro pore maka kobukobu tinoni bi tori tavakoleni mae tu za na bevi aza. ");
INSERT INTO ghn_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na rane vatana za tonai, beto za tata na rane Minyere. ");
INSERT INTO ghn_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ria na reko kokodi pa Qalili beto qari tuti lamea i Jisu za qari tuti laoa i Josepa, ko qari dogoria za na bevi beto ko aza vei qari vakole veini na kobukobu tinina i Jisu pa bevi. ");
INSERT INTO ghn_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Beto za qari mule kenidia ketakoi na suveredi ria na reko, qari lao vatanani na oela omanga lea mari valaoni pa tinina i Jisu qari gua. Ko totonai za kamu na rane Minyere za qari minyere aza na tutina na garunu. ");
INSERT INTO ghn_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ego na volavolaza lea na rane momoe pa vuiki, za qari munu volavolaza lao pa bevi ria na reko ko qari pogozoria ria na oela omanga lea qari vatanai. ");
INSERT INTO ghn_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ba tonai qari lao kamu nari za qari batia za tori tabokili varijo tu pa atakamanana na bevi za na patu qari pateni, ");
INSERT INTO ghn_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ko tonai qari luge lao nari qarike batia za na kobukobu tinina na Bangara i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tonai qari korapa rurani ria aza za vei aza, za kori marene qari vazaeria na poko kilakilangadi za qari lame turu pa keketaidi. ");
INSERT INTO ghn_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ko qari matagutu vikevikeredi ria na reko ko qari turu titigore betodia pa pezo, nari qari paranga ari kori marene, ari qari gua vei, <<Ae za vei ko gamu lame nyaqoa na tinoni toana ketakoi qari kole ria na kobukobu tinoni ukedi? ");
INSERT INTO ghn_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nake pani aza, za tori turu mule tu. Gamu gilagilaimiu aza vei za pojadigamu totonai za korapa suvere pa Qalili? ");
INSERT INTO ghn_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Za pojai aza totonai za na veveina na Tuna na Tinoni za pala mina tavalao pa limadi ria na tinoni seladi ko mina tavauke pa korosi, ba pa vinaue rane za pala mina turu mule za gua,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Totonai za qari roquroqu kamuria ria za na paranga tana, ");
INSERT INTO ghn_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ko qari taloi pa bevi ko qari mule vavakato vadi ari ka manogamaka sepele beto ria doru qari tututia i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ko ari Mere Magadalene, i Joana, i Mere na tinana i Jekopi beto ria kaki reko qari tutiria za qari vavakatoni tadiria na tinoni tagarunudi za na vavakato ani. ");
INSERT INTO ghn_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ba na vavakato ani za vei maka vavakato iliganigani gu tadiria na tinoni tagarunudi, ko qarike vazozotoria ria na reko. ");
INSERT INTO ghn_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ba i Pita za soqolo turu ko za abutu lao za pa bevi, ko za opo ko za oviki lao, nari za batiria na poko gu qari korapa koledia. Ko za taloi ko za gabala mule pa ruma aza beto ko za kole tugu roquroqua za na za beka za podo za gua. ");
INSERT INTO ghn_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ego pa ranena tugu aza za ari kori sepele ti Jisu za qari korapa lalaodia pa maka guguzu na izongona pa Imeasi, na zouna koko pa Jerusalema za padapada vei manogori kilomita. ");
INSERT INTO ghn_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ko qari kole varivavakatodi ari kori doru zakazava qari koni pidoko ari. ");
INSERT INTO ghn_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Totonai qari korapa variparaparanga beto qari variguadi ari kori ria na zakazava ari, za i Jisu makana za lame kamuria ko za makarai rerege tavitiria. ");
INSERT INTO ghn_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ko qari batiadia tugu ari kori aza ba qarike dogoro gigalia ari kori aza. ");
INSERT INTO ghn_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nari za nanaza laoria i Jisu ari kori, ari za gua vei, <<Na za na vavakato gamu korapa varigonani gamu kori pa miu rerege lame?>> za gudi. Nari za qari turu vanogoto, korapa dogoro takulangadi. ");
INSERT INTO ghn_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Beto za maka ari kori, na izongona i Kiliopasi, za oe laoa, <<Qokolo, ao gu makamu za na tinoni koni kamumu pa Jerusalema? Ko za vei za quke gilagilaria ria na zakazava qari pidoko pa rane qari koni jola ari?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nari za nanazaria i Jisu, <<Ae zakazava veveidi za gamu pojaria gamu kori?>> za gudi. Nari ari qari gua vei ari kori, <<Na veveina i Jisu pa Nazareti. Maka tinoni korokorotai za neqi pa nana paranga beto na nana roiti pa moena na Tamaza beto ria na tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ko ria na mami kuta iama beto na mami tinoni matamata za qari tekua ko qari varivaegoni na nana uke, ko qari vaukea pa korosi aza. ");
INSERT INTO ghn_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Gami gami kole roveroveni za aza tugu za na tinoni mina aloa za na butubutu Izireli gami gua. Pa riso gu qari taroiti doru zakazava ari. ");
INSERT INTO ghn_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ego beto za ria kaki reko tavitimami gami za qari varuragami gu mule. Qari lao pa bevi pa ngena volavolaza lea ");
INSERT INTO ghn_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ba qarike batia za na kobukobu tinina. Ego beto za qari mule pojadigami za qari batiria pa dogodogoro ria na mateana, ko ria na mateana qari pojadi za tori toa mule tu aza qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ko ria kaki tavitimami mule za qari lao pa bevi, nari za qari batia za aza tugu vei qari pojai ria na reko, goto aza za qarike batia,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nari ari za gudi vei i Jisu ari kori, <<Gamu duviduvili za gamu ko na roqumiu za pekipeki vitivitigi pa vazozotodi doru zakazava qari pojaria ria na tinoni korokorotai! ");
INSERT INTO ghn_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Na tanguti vakolena za na Karisito za mina gozororia mae ria na vitigi ari beto za mina tavalavata!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ego beto za podalai pa kutikuti ti Mosese ko za kamu pa kutikuti tadiria doru tinoni korokorotai, za kole ruvata vakabere vadi aza doru zakazava qari tapoja pa Kutikuti Tabuna na veveina makana. ");
INSERT INTO ghn_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ego ko tonai qari lame tata kamua za na guguzu qari korapa rerege laoa, nari za roiti vei mi jola laonana za gua aza, ");
INSERT INTO ghn_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ba qari tepa vitivitigia ari kori aza, ari qari guni vei, <<Mu suvere tavitigami, ura za tori veluvelu tu beto mi rodomo gu za gua za na kota,>> qari guni. Nari za lao suvere tavitiria pa ruma. ");
INSERT INTO ghn_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ego totonai za lao tekuteku tavitiria pa tevolo za tekua aza za na bereti ko za manani, za kipakipai, beto za iadi. ");
INSERT INTO ghn_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Pana totozo tu aza za revanga za na matadi ari kori ko qari gigalia aza, beto za pae gu pa dia dogodogoro aza. ");
INSERT INTO ghn_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nari qari variparanga vei ari ari kori, <<Qokolo, kale pu vei na iku vuruvurungu zara pu vei za na buloda totonai za kole parangagita pa zona, beto totonai za kole revanga vadigita na Kutikuti Tabuna, akae?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ko qari soqolo turu tugu pa totozo aza ari kori ko qari mule lao za pa Jerusalema. Qari lao kamu za qari batiria ari ka manogamaka sepele beto ria kaki mule, ");
INSERT INTO ghn_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ko ari qari gua vei, <<Zozoto! Na Bangara za toa mule, ko za tori votu mutu ti Saimone!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ego beto za ari kori ba qari vavakato vadi za aza veveina qari gozoria aza pa zona laona, beto na veveina qari gigalia tonai za kipakipai na bereti. ");
INSERT INTO ghn_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ego totonai qari korapa vavakatoni ria za na zakazava ari, za i Jisu makana za turu pa varikorapaidi ria doru, beto ari za gudi vei, <<Na bule mi somana tadigamu!>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Qari matagutu vitivitigi ria, beto qari rovea za palu qari batia na onguna maka tinoni qari gua. ");
INSERT INTO ghn_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nari za paranga laoria i Jisu ria, <<Ae za vei ko gamu takulanga, beto ae za vei ko za rabeke na roqumiu? ");
INSERT INTO ghn_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mu dogororia tu na limaqu na nenequ ko, ura ara tugu ani! Mu uliziu beto mu dogoroziu, ura na onguna na tinoni za kepore na masana beto na pudapudana, goto ara za koledia na masaqu beto na pudapudaqu,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pa liguna za paranga vei ari, nari za vadogorodi na limana beto na nenena. ");
INSERT INTO ghn_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ego ko tonai qari korapa qera tugu ba qarike boka vazozotoa tugu, nari za nanazaria, <<Ae vei kolenana kaki miu tekutekuna?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nari qari vani maka kipa igana parogona, ");
INSERT INTO ghn_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ko za tekua ko za gania pa moedi ria doru. ");
INSERT INTO ghn_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Beto ari za gudi vei, <<Ari ria na qua paranga qa tori ule vadigamu tu totonai qa suvere tavitigamu. Doru zakazava veveiqu ara qari takuti pa Vavanau ti Mosese, tadiria na tinoni korokorotai beto pa Kera Vatarazae za mari tavagore votu tugu qa gudigamu,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Beto za revangia aza za na roqudi ko qari boka dogoro vakabereria ria na ginuadi na paranga pa Kutikuti Tabuna, ");
INSERT INTO ghn_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","beto ari za gudi vei, <<Na takuti vakolena pa Kutikuti Tabuna za na Karisito za mina gozoro vitigi ko mina uke beto na rane vinaue mina turu mule pa uke aza. ");
INSERT INTO ghn_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Beto ko na nongorona ria na tinoni mari gabala ko na dia sela mi taleozae za mina tatarae pa nizongona aza tadiria doru puku tinoni, podalai tugu pa Jerusalema. ");
INSERT INTO ghn_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Gamu za muna vavakatodi ria na zakazava gamu batiria ari. ");
INSERT INTO ghn_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ko ara mana garunu valagere vadigamu za na varivana za taringutinguti vakole vadigamu na Tamaqu. Ba mu suvere pa guguzu pa Jerusalema tinganai muna izongia mae tu za na neqi mina lagere vei pa nulu vavagalo,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ego beto za toka votu lao veidi pa Betani i Jisu ria, beto za alakadi na limana ko za manadi. ");
INSERT INTO ghn_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Totonai za korapa manadi nari za rijo tadiria aza ko za iolo taloi tadiria ko za zae vei pa noka. ");
INSERT INTO ghn_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ego ko pa liguna qari vatarazaea, nari za qari muledia pa Jerusalema beto na qera lavata za kole pa bulodi. ");
INSERT INTO ghn_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Beto ko qarike nogoto lao vatarazaea ria pa kakabarena na zelepade za na Tamaza.");
INSERT INTO ghn_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pana podapodalaina za tori kolenana tu za na paranga, ko na paranga aza za suvere tavitia na Tamaza, ko na Tamaza za na paranga. ");
INSERT INTO ghn_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Pana podapodalaina za na paranga za suvere tavitia na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Qari podaka votu lame vei gu tana paranga ria doru zakazava za roitidi na Tamaza, ko kepore maka za pa vinapodaka za bike taroiti pa neqi tana paranga. ");
INSERT INTO ghn_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Na paranga gu za kolea na toa, ko na toa ani za na kabere tadiria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na kabere za tolanga pa rodomo, ba na rodomo zake boka amua za na kabere aza. ");
INSERT INTO ghn_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ego kolenana za maka tinoni za garunia na Tamaza, na izongona aza i Jone. ");
INSERT INTO ghn_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Aza za lame maka tinoni ulule ko za uleni za na veveina na kabere, ko pana tana doru tinoni mari vazozoto za gua. ");
INSERT INTO ghn_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ba aza makana za nake kabere, goto za lame gu uleni na veveina na kabere aza. ");
INSERT INTO ghn_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Na kabere tu ani za na kabere zozoto za lame pa kasia guguzu, ko za vakabereria doru tinoni. ");
INSERT INTO ghn_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Aza za lame suvere pa kasia guguzu, ko aza tugu za varoitia na Tamaza ko za roitini na kasia guguzu, ba na kasia guguzu za zake dogoro gilagilai aza. ");
INSERT INTO ghn_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Za lame pa nana guguzu makana zozoto aza, ba qarike vatogai ria tugu nana tinoni makana aza. ");
INSERT INTO ghn_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ba ria doru qari vakamua aza ko qari vazozotoa na izongona, za vadi na neqi ko mari na koburu tana Tamaza ria. ");
INSERT INTO ghn_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Qarike podo pa zona kolena bi pa masa na orungu babi pa roquroqu tana marene ria, goto na Tamaza tu makana za vapodoria. ");
INSERT INTO ghn_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ego ko za lame tini tinoni za na paranga, beto ko za suvere varisomanai tadigami ko gami gami dogoria za nana malakapi vavaguana za izongia aza ura aza za na Tuna makamakai na Tamana, za pugelia na variroqu varialona beto na zozoto. ");
INSERT INTO ghn_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ko za ululeni i Jone za na veveina aza, ari za velavela votu vei, <<Zana aza qa pojai ara na veveina totonai ari qa gua vei perangaina, <Aza na tinoni mina tuti ligu lameziu ara za lavata jolaniziu ara, ura qa oqoro tu podo ara za tori suverenana tu aza!> qa gua,>> za gua i Jone. ");
INSERT INTO ghn_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Pa nana tinamaza pugelena aza za gita doru taqe somana teku varitakoini ria nana variroqu varialona. ");
INSERT INTO ghn_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ura na Vavanau za tavagore vei tu ti Mosese, ba na variroqu varialona beto na zozoto za lame vei ti Jisu Karisito. ");
INSERT INTO ghn_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kepore za maka tinoni bi tori batini matana tu mae za na Tamaza, ba na Tuna makamakai gu, aza na Tamaza, aza za togaza tana Tamana, aza za ule vakabere vadigita za na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ego ani za na ulule ti Jone totonai qari garunuria ria na tinoni matamata tinoni Jiu pa Jerusalema ria kaki iama beto kaki na butubutu Livai, ko qari lao nanazia aza, <<I zei ao?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nari i Jone za ule votuni beto zake dainana pojadi, goto za ule votuni gu, ari za gua vei, <<Ara za nake Karisito,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nari za qari nanazia, <<Ko i zei tu ao? I Elaija?>> qari guni. <<Dai ara nake aza,>> za gua i Jone. <<Goto i zei tu? Na tinoni korokorotai ao?>> qari guni. Nari za oeria i Jone ria, <<Dai,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nari za ari qari guni vei, <<Ko i zei za ao? Mu ule vadigami ko mami mule pojadi ria qari garunu valamegami. I zei qu dogoro veinigo makamu ao?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nari ari za gua vei i Jone, <<Ara za Maka mamalaingi ari za kukuku vei pa qega: <Mu vatanani za na zona tana Bangara!> Aza vei za korotoni i Aisea na tinoni korokorotai,>> za gua i Jone. ");
INSERT INTO ghn_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ria tu na Parese qari garunuria ria na tinoni ari ");
INSERT INTO ghn_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ko qari nanazia i Jone, ari qari guni vei, <<Vei nake Karisito, nake i Elaija, beto nake tinoni korokorotai ao, nari za ae za vei ko qu korapa varipaputaiso tu?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nari za oe laoria i Jone ria, <<Ara za qa paputaisodi na kolo ria na tinoni, ba za korapa gu suverenana pa varikorapaimiu gamu za aza gamuke gilagilai gamu. ");
INSERT INTO ghn_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Aza za korapa tuti ligu lameziu ara, ba ara za qake pada ko mana ruvataria na piko buti tana,>> za gua i Jone. ");
INSERT INTO ghn_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Na roiti ari za qari taroiti pa Betani, pa kale zagere tapo pa pie Jodani, ketakoi za kole varipaputaiso i Jone. ");
INSERT INTO ghn_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ego ko za rane soga na kota za i Jone za batia i Jisu za korapa rerege lame tana, nari za paranga, <<Dogoro! Nari za na lami tana Tamaza, aza mina vulaza paledi na sela tana kasia guguzu! ");
INSERT INTO ghn_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Na veveina aza za qa pojai ara tonai ari qa gua vei, <Maka tinoni za korapa tuti ligu lameziu ara za poreveveina jolaniziu ara, ura za tori suverenana tu aza beto za qa pore ara,> qa gua. ");
INSERT INTO ghn_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ara ba perangaina qake gilagilai i zei aza, ba qa lame varipaputaisoni gu na kolo ara ko mi bola tadiria na tinoni Izireli aza qa gua,>> za gua i Jone. ");
INSERT INTO ghn_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ko za ululedi i Jone ria za batiria, ari za gua vei, <<Qa batia ara za na Ongu Tabuna za tigoro gore vei maka kuru pa noka ko za gore nyumua aza. ");
INSERT INTO ghn_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ko perangaina za qake gilagilai tugu ara aza, ba aza tu na Tamaza za garunuziu ko qa varipaputaisoni na kolo za ari za guniziu vei, <Aza muna batia mina tigoro gorea ko mina nyumua na Ongu Tabuna, za aza tugu za varipaputaisoni na Ongu Tabuna,> za guniziu. ");
INSERT INTO ghn_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ko qa tori bati zozotoa tu ko qa ululeni ara za aza tugu za na Tuna na Tamaza,>> za gua i Jone. ");
INSERT INTO ghn_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ego ko za rane soga na kota totonai za korapa turu tavitiria kori nana sepele i Jone, ");
INSERT INTO ghn_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ko za batia aza za korapa rerege lao vei ketakoi i Jisu, za paranga i Jone, <<Dogoro! Nari za na lami tana Tamaza!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ego ko tonai qari nongoria ari kori sepele aza vei za parangani aza, nari za qari lao tutiadia i Jisu ari kori. ");
INSERT INTO ghn_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ego ko totonai za balinga i Jisu ko za batiria qari korapa tutia ari kori aza, za nanazaria, <<Na za za gamu nyaqoa gamu kori?>> za gudi. Nari ari qari gua vei ari kori, <<Rabi, pae qu suvesuvere ao?>> qari guni. (Na ginuana Rabi za na Tinoni Varivagigalai.) ");
INSERT INTO ghn_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nari za parangaria i Jisu ari kori, <<Mae, lame tutiziu ko mu batia,>> za gudi. Ko qari tutia tugu ko qari lao batia za na ruma ketakoi za suvere aza, beto ko za tori made koloko veluvelu tu za totonai, ko qari kole suveredia tana tinganai za bongi za na kota. ");
INSERT INTO ghn_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","I Aduru, na taina i Saimone Pita, za maka ari kori za nongoria na parangana i Jone perangaina ko za tutia i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ba i Aduru za keni mae tu nyaqoa za na tugana makana, i Saimone, ko ari za guni vei, <<Qokolo, gami gami batia gu za na Mesaea,>> za gua. (Na ginuana na Mesaea za na Karisito.) ");
INSERT INTO ghn_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Beto za toka laoni ti Jisu i Saimone. Ko totonai za batia, za ari za guni vei i Jisu aza, <<Ao i Saimone, na tuna i Jone, ba koviria za muna takukuni i Sipasi za na izongomu ao,>> za gua i Jisu. (Na ginuana nizongo Sipasi za varitoto vei tugu na ginuana nizongo Pita.) ");
INSERT INTO ghn_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ego ko za rane soga na kota nari za taloi lao pa Qalili i Jisu, nari za bati gozoria aza i Pilipi ko ari za guni vei, <<Mae, tutiziu!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","I Pilipi za na tinoni Betiseda, aza na guguzu ketakoi qari suvere ari Aduru i Pita. ");
INSERT INTO ghn_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","I Pilipi za nyaqoa i Nataniela ko za parangia, <<Aza na tinoni i Mosese za kutia na veveina pana Vavanau beto ria na tinoni korokorotai qari kutia na veveina za gami batia gami. Aza i Jisu pa Nazareti, na tuna i Josepa,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nari ari za guni vei i Nataniela aza, <<Qokolo, mina boka tugu votu lame vei pa Nazareti za maka zakazava leana?>> za gua. Nari za paranga i Pilipi, <<Mae, lame tutiziu, ko mu batia,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ego ko i Jisu za batia za korapa lamelamenana tana i Nataniela, za ari za paranga vei, <<Dogoro, ani za na tinoni Izireli zozoto, aza zake izongo kolea maka sekeseke!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nari za paranga i Nataniela, <<Ae za vei ko qu boka tu gilagilaziu?>> za gua. Nari za oea i Jisu aza, ari za guni vei, <<Totonai za oqoro lao kukugo i Pilipi, nari za ara qa tori bati momoegoqua tu qu kole nyumumua pa kuta suvege piqi ao,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nari ari za gua vei i Nataniela, <<Rabi, ao tugu za na Tuna na Tamaza, ao za na bangara tadiria na tinoni Izireli!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Nari za oe i Jisu, ari za guni vei, <<Ae vei, koko vei qa pojanigo gu qa tori bati momoegoqua tu totonai qu kole nyumu pa kuta suvege piqi qa gua ara za qu vazozoto? Pala muna batiria ria na zakazava mari lavata jolani aza qu batia koviria!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Beto za paranga i Jisu, ari za gua vei, <<Zozoto pa zozoto ma poja zozotodigamu ara gamu: pala muna batia za na noka mina tarevanga beto ria na mateana tana Tamaza mari gore zae tana Tuna na Tinoni,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ego pana vinaue rane za taroiti za maka tekuteku varielava pa Kena pa Qalili, ko na tinana i Jisu za korapa ketakoi. ");
INSERT INTO ghn_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ko i Jisu beto ko ria nana sepele ba qari somana tasoru valao tugu pa vavolo varielava aza. ");
INSERT INTO ghn_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Totonai za pidili za na buku vaini, nari za paranga laoa i Jisu za na tinana, <<Tuqu, za betodi na vaini ria,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nari za paranga i Jisu, <<Ko na zavana taqu beto tamu za vei zara, tinaqu? Ara ba na qua totozo za oqoro kamua,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nari za parangaria na tinana ria na nabulu, <<Muna roitini gu gamu aza vei mina garunudigamu aza,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ego na tututi pa vatarazae tadiria na tinoni Jiu za koledia za pa kalena na vavalioso, ko na juki vatanana na vei aza za koledia ketakoi za ka vonomo bogu patu lavata vutuvutugu tarini kolo, padana pa varikorapaina vitungavulu lima ko maka gogoto manoga lita maka. ");
INSERT INTO ghn_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ko za paranga laoria i Jisu ria na nabulu, <<Mu vapugeledi na pie galegale za na bogu jagi zara,>> za gua. Nari qari vapugele jutudi na pie tugu ria za na bogu ria. ");
INSERT INTO ghn_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Beto za garunuria i Jisu ria, <<Ego koviria mu tinuria kaki kolo, ko mu pogozo laoni tana tinoni za kopuni na vavolo,>> za gua. Nari qari pogozo laoni tugu aza vei za pojadi i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ko za buku podekia na tinoni kopu vavolo za na kolo za tapeluku vaini nari za valingilingini, ba zake gilagilai pae za koko lame vei za na vaini aza. (Ba ria na nabulu qari tinua na kolo ko qari gilagilaidia za.) Ko za kukua za na tinoni za varielava, ");
INSERT INTO ghn_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ko ari za guni vei, <<Qokolo, ria doru tinoni za na vaini leana jola mae tu za qari iia momoea, beto totonai qari tori dori buku tu ria na tinoni za beto qari iai za na vaini nake loka leana. Ba ao za qu kopu vakolea ko koviria tu qu vavotua za na vaini leana jola,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ani za na roiti vinagilagila momoe za roitini i Jisu pa Kena pa Qalili, ko ketakoi za vatadogoroni aza za nana neqi, ko ria nana sepele qari vazozotoa aza. ");
INSERT INTO ghn_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ego pa liguna aza za qari goredia pa Kepaniami ari Jisu, na tinana, ria na taina marene beto ko ria nana sepele, ko qari doru suvesuveredia mae tu ka viza rane ketakoi ria. ");
INSERT INTO ghn_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ego za tori tata tugu za na totozo vavolo Alokata tadiria na Jiu, ko za taloi zae pa Jerusalema i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Totonai za kamu aza ketakoi, za rerege lao pa kakabarena na zelepade, nari za batiria ria na tinoni qari korapa vavaidi na bulumakau, na sipi, na kuru, beto ko ria na tinoni sogasoga poata qari korapa nyumu roitini na dia roiti. ");
INSERT INTO ghn_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nari za roitini aza maka gazoro variiriruna, ko za adu votuvotudi pa kakabarena zelepade za doru manugu, na sipi, na bulumakau. Beto za upele valotu enga paledi ria na tevolo tadiria qari sogasoga poata, ko za ipaporodi doru kota za na dia poata. ");
INSERT INTO ghn_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Beto ari za gudi vei ria qari vavaidi na kuru, <<Mu pogozo votu kenidi pa ia pani ria na zakazava ari! Muke roiti veini na ruma makemaketina za na ruma tana Tamaqu!>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Totonai qari batia ria na sepele zara za vei, nari za qari gilagila kamua ria aza vei za pojai na Kutikuti Tabuna, ari za gua vei, <<Tamaza, na qua roquroquna na mua ruma ao za vei na iku vuruvurungu pana taqu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ego ko tonai za roiti vei zara i Jisu za qari lao nanazia ria na matamata tinoni Jiu aza, ari qari guni vei, <<Na roiti vinagilagila ae veveina za muna roiti vadigami ao ko gami mami boka vazozotoa za qu izongia tugu ao za na neqi ko muna boka roiti vei zara?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nari za oeria i Jisu ria, ari za gudi vei, <<Mu jegaria za na zelepade madina ani, beto za na rane vinaue pala mana vaturu sogai ara ani,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nari za ari qari gua vei ria na matamata tinoni Jiu, <<Qokolo, ko ka madengavulu vonomo aoro tu qari kole roitini ria za na zelepade madina ani! Ba ao muna vaturu sogai pa kue rane gu?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ba na zelepade madina za guni aza za na tinina gu makana. ");
INSERT INTO ghn_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ko pa liguna za turu mule pa uke aza, nari za qari roquroqu kamua ria na sepele aza za poja veini aza ani. Ko qari vazozotoa ria za na Kutikuti Tabuna beto ko na parangana i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ego totonai za korapa suvere pa Jerusalema pa totozo vavolo Alokata i Jisu, nari za kubo tinoni za qari vazozotoa aza tonai qari batiria na roiti vinagilagila za roitidi aza. ");
INSERT INTO ghn_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ba i Jisu makana zake totoravuzuria ria, ura za tori gilagila betoria nana tu aza ria. ");
INSERT INTO ghn_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Beto ko zake nyaqoa tadiria na tinoni aza za na vavakato vinazozoto veveidi ria na goto tinoni, ura aza makana za tori gilagila valeana betoria nana tu za na roquroqu za kole pa bulodi na tinoni. ");
INSERT INTO ghn_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ego kolenana za maka kuta tinoni matamata tadiria na tinoni Jiu, maka ria na Parese, na izongona i Nikodimasi. ");
INSERT INTO ghn_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ko na tinoni ani za lao ti Jisu maka bongi, ko ari za guni vei i Jisu, <<Rabi, gami gilagilagomami gami za ao za maka tinoni varivagigalai na tagarunu lame veimu tana Tamaza ao. Ura kepore za maka tinoni bi boka roitidi za na roiti vinagilagila vevei qu korapa roitidi ao zara vei bike somana tana za na Tamaza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nari za oea i Jisu aza, ari za guni vei, <<Zozoto pa zozoto ma pojanigo ara ao: kepore za maka tinoni mina boka batia na binangara tana Tamaza, vei minake podo mule mae tu aza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nari za paranga i Nikodimasi, <<Ae mina vei beto mina boka maka podo mule mutu za na tinoni za tori baragozo tu? Na tinoni lavatana za minake boka lugea na iapana na tinana ko mina podo na vinaori totozo!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nari za oea i Jisu aza, <<Zozoto pa zozoto ma pojanigo ara ao: kepore za maka tinoni mina boka luge pa binangara tana Tamaza, vei minake podo kolo beto na Ongongu aza. ");
INSERT INTO ghn_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Aza za podo masa za na masa tugu, goto aza za podo Ongongu za na Ongongu tugu. ");
INSERT INTO ghn_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Muke gabarani aza qa korapa pojanigo na veveina muna podo mule mae tu za gamu doru qa guni. ");
INSERT INTO ghn_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Na gava za iru lao vei ketakoi za nyorogua lao vei aza. Qu nongoriamua za na ovangana, ba quke gilagilai pae za koko lame vei beto pae za korapa lao vei aza. Maka moqaza podeke vei tugu aza za na tinoni za podo pana Ongongu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nari za nanaza i Nikodimasi, <<Ko ae mina vei mina boka gore votu zana?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nari za oea i Jisu aza, ari za guni vei, <<Beko ao tu za na tinoni varivagigalai tadiria pa Izireli, ba quke gilagilai tu ari? ");
INSERT INTO ghn_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Zozoto pa zozoto ma pojanigo ara ao: gami za gami paranga votudi ria vei gami gilagilaria, beto gami ulule votudi ria vei gami bati zozotoria, ba kepore maka gamu bi vazozotoria ria na mami ulule. ");
INSERT INTO ghn_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Vei mana vavakato vadigamu ara ria na zakazava gu qari gore votu pa kasia guguzu ba munake vazozoto za gamu, nari za vei mana vavakato vadigamu ara ria na zakazava qari gore votu pa noka za totonai za pala munake izongo vazozoto podeke za gamu. ");
INSERT INTO ghn_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kepore za maka tinoni bi tori zae mae tu pa noka, ba kolenana za aza za gore lagere vei pa noka, na Tuna na Tinoni. ");
INSERT INTO ghn_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Za varitoto vei tugu pa qega za alaka vaiolo zaeni i Mosese pa nulu za na dole pa uqu kolu, nari za mina taovulu vaiolo zae vei tugu aza za na Tuna na Tinoni, ");
INSERT INTO ghn_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ko ria doru mari vazozotoa aza za mari tekua na toa jola. ");
INSERT INTO ghn_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ura pa zona vei ani za roquroqua na Tamaza za na kasia guguzu: za valamea aza za na Tuna makai, ko ria doru mari rangea aza za marike uke manyao goto mari tekua na toa jola. ");
INSERT INTO ghn_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ura na Tamaza zake garunu valageria pa kasia guguzu za na tuna ko mi pitua aza za na kasia guguzu zake guni, goto za garunu lagereni ko mi aloa tu aza za na kasia guguzu za gua. ");
INSERT INTO ghn_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Aza za vazozotoa na Tuna za zake tapitu; goto aza zake vazozotoa na Tuna za tori tapitu tu, ura za tori ke vazozotoa tu aza za na Tuna makai na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ari za vei za na varituti: za tori lame tu pa kasia guguzu za na kabere, ba ria na tinoni za nake kabere goto na rodomo tu za qari nyoroguani, ura na dia roiti za na seladi. ");
INSERT INTO ghn_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Aza na tinoni za roitidi na roiti ikikeredi za zake tavaraguani za na kabere, ko zake lame pa kabere aza, ura zake nyorogudi aza ria nana roiti ikikeredi bari tauduku votu. ");
INSERT INTO ghn_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ba aza za roitini na zozoto za lame pa kabere, ko qari bola votu ria nana roiti za roitidi aza ura za vatabea na Tamaza aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ego pa liguna aza za i Jisu beto ria nana sepele za qari lao pa ia pa Jiudia, ko ketakoi za suvere tavitiria iapeki totozo kakazana ko za kole paputaiso tinoni. ");
INSERT INTO ghn_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","I Jone ba za paputaiso tinoni tugu pa Aenoni, maka guguzu za tata pa Saleimi, ura za kubo za na pie pa kota ketakoi, ko qari lalao tana ria na tinoni ko za kole paputaisoria aza ria. ");
INSERT INTO ghn_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Pa totozo aza za qari oqoro vakolea pa ruma varipiuna i Jone.) ");
INSERT INTO ghn_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ego ko kaki ria na sepele ti Jone za qari variguani tana maka tinoni Jiu za na veveina na loqaloqa vavalioso pa vavanau tadiria na tinoni Jiu. ");
INSERT INTO ghn_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Beto za qari lao ria kaki nana sepele ko ari qari guni vei i Jone, <<Rabi, qu gilagilaimua ao aza na tinoni za somana suvere tavitigo totonai qu suvere pa kale zagere tapo pa pie Jodani, aza na veveina qu kole mae ululeni ao? Dogoro! Koviria za korapa varipaputaiso aza, ko na rave tinoni za qari korapa lalao tana!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nari za oeria i Jone ria, ari za gudi vei, <<Kepore za maka tinoni mina boka izongia maka zakazava vei minake vani na Tamaza aza. ");
INSERT INTO ghn_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Gamu makamiu za gamu tori nongoria tu ko muna boka ululeni za aza qa pojai ara tonai ari qa gua vei, <Ara za nake Karisito ara, goto qa tagarunu vamomoe lao gu pa moena aza,> qa gua. ");
INSERT INTO ghn_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Na reko mina varielava za nana tugu na marene mina elavaia, nake tana tinoni aza ari kori na baere leana. Goto na baere leana ani za kole turu vainongoro, ko za somana qera totonai za nongoria aza za na mamalaingi lamena na nana tinoni. Ko ara za qa vei gu aza, ko za okoto valeana za na qua qeraqera. ");
INSERT INTO ghn_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aza za mina iolo zae, goto ara za mana gore peki tugu,>> za gua i Jone. ");
INSERT INTO ghn_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","<<Aza na koko lagere veina pa nulu za ululu joladi doruna. Aza na koko veina pa pezo za tana pezo tugu, beto za kole tugu vavavakatodi na zakazava pa pezo. Goto aza za gore lagere vei pa noka za ululu joladi doruna. ");
INSERT INTO ghn_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Aza za tori batia tu beto za tori nongoria tu za ululeni aza, ba kepore tinoni bi vazozotoa za nana vavakato. ");
INSERT INTO ghn_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ba aza za vazozotoa na nana ulule za vaegoia tugu za na Tamaza za na zozoto. ");
INSERT INTO ghn_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Aza za garunia na Tamaza za ule votudi na paranga tana Tamaza, ura na Tamaza zake vani kobukobua na Ongongu pugelena aza. ");
INSERT INTO ghn_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Na Tamana za roquroqua za na Tuna ko za tori vakolea tu pa limana aza za doru zakazava. ");
INSERT INTO ghn_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Aza za vazozotoa na Tuna za tekua na toa jola. Aza na tinoni za kilupaleni na Tuna za minake tekua na toa jola, goto za tavapogozoni aza za na vinakilasa tana Tamaza,>> za gua i Jone. ");
INSERT INTO ghn_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ego qari nongoroni ria na Parese za i Jisu za teku vazoku sepele beto ko za paputaisoria zoku tinoni joladi ria za paputaisoria i Jone qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ba i Jisu makana zake varipaputaiso za, goto ria tu na nana sepele za qari vei.) ");
INSERT INTO ghn_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ko totonai za nongoria i Jisu zara qari paranga vei ria na tinoni, nari za taloi pa Jiudia ko za mule gorenana pa Qalili aza. ");
INSERT INTO ghn_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ko pa nana rerege mule pa Qalili za rovea za mina jola vei tugu pa korapa ia pa Sameria aza za gua. ");
INSERT INTO ghn_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ko pa Sameria za kamu pa maka guguzu lavata na izongona pa Suka, nake zouna pa kobu pezo ti Jekopi za vani i Josepa na tuna. ");
INSERT INTO ghn_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ego na kolena tugu ketakoi za na oqili pie takorina ti Jekopi, ko za pavu taleni na kole rerege i Jisu ko za nyumu nana tugu pa keketai oqili pie aza. Ko na korapa rane za totonai. ");
INSERT INTO ghn_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Maka reko pa Sameria za lame ko mi vutugu pie za gua, nari za paranga lao pana tana i Jisu, <<Bu vaniziu iapeki buku qa gua,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Totonai za qari tori taloi keni tu pa guguzu ria nana sepele ko mari keni vaiganigani qari gua.) ");
INSERT INTO ghn_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nari za paranga za na reko Sameria, <<Ao ko na Jiu tu, goto ara na tinoni Sameria tu, ba ae za vei qu korapa tu tepaniziu na pie ara?>> za gua. (Ura pa dia tuti za qarike makarai tekuteku pa maka peleta ganigani babi qarike makarai buku pa maka vutuvutuguni pie ria na Jiu beto na Sameria.) ");
INSERT INTO ghn_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nari za oea i Jisu aza, ari za guni vei, <<Vei bu gilagilai ao aza na varivana tana Tamaza beto ko i zei aza za korapa tepanigo na pie, za bu tori tepani buku tu beto ko aza bi tori vanigo tu na pie varivatoana ao,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nari za paranga za na reko, <<Kepore na mua titinuna ao beto ko na dori kori gorena za na oqili pie ani. Ko pae muna tekuni ao za na pie varivatoana? ");
INSERT INTO ghn_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ao quke lavata jolani i Jekopi na tamamami gami, za akae? I Jekopi tu za vadigami na oqili pie ani, ko aza makana beto ria na tuna, na nana papauzu za qari buku beto tugu pa pie zana,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nari za oea i Jisu aza, ari za guni vei, <<Aza za bukua na pie za kole pa oqili pie ani za pala mina kidepe soga gu aza, ");
INSERT INTO ghn_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","goto aza mina bukua na pie mana vani ara za minake izongo kidepe soga. Ba na pie mana vani ara za mina bukabukala vuvugu za pa bulona, ko mina vani na pie za kolea na toa ko mina vani na toa kole jolana,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nari za paranga za na reko, <<Bangara! Vei mu vaniziu tu ropi za na pie aza, ko make kidepe soga, beto make papavu lamelame vutugu soga pie pani,>> za gua za na reko. ");
INSERT INTO ghn_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nari ari za guni vei i Jisu aza, <<Mu lao, ko mu kukua na marenemu ko mu toka lameni pani,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nari za paranga za na reko, <<Koi, ara kepore marenequ!>> za gua. Nari ari za guni vei i Jisu aza, <<Qu zotomua tugu ao tonai kepore marenequ qu gua. ");
INSERT INTO ghn_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ura ari ka lima marene mae tu za qu tori nagoria tu ao, ko aza qu korapa nagoa ao koviria za nake marenemu zozoto ao aza. Ko na zozotona gu za qu pojai ao,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nari za paranga za na reko, <<Bangara, koviria tu qa gilagilai ara za maka tinoni korokorotai ao! ");
INSERT INTO ghn_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ura ria na mami tite pa moa gami za pa kubo tugu ani za qari vatarazaea na Tamaza, ba gamu na tinoni Jiu za gamu paranga za pa Jerusalema tu za na ia tana vatarazaea gita na Tamaza gamu gua,>> za gua za na reko. ");
INSERT INTO ghn_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nari za parangia i Jisu aza, <<Siu, mu vazozotoa ani! Za korapa lame za na totozo totonai nake pa kubo ani babi pa Jerusalema za muna vatarazaeni gamu za na Tamada. ");
INSERT INTO ghn_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Gamu na tinoni Sameria za gamuke gilagila valeania aza gamu vatarazaea; goto gami na tinoni Jiu za gami gilagila valeaniamami aza gami vatarazaea, ura na inaalo za votu lame vei tadigami tu na tinoni Jiu. ");
INSERT INTO ghn_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ba za korapa lame za na totozo ko koviria za tori kamua tu za na totozo aza, tonai ria na tinoni vatarazae zozoto za mari vatarazaea pa ongongu beto pa zozoto za na Tamana. Aza za na vinatarazae zozoto za nyoroguani na tamana. ");
INSERT INTO ghn_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Na Tamaza za na Ongongu ko ria mari vatarazaea aza za mari vatarazaea pa Ongongu beto pa zozoto tu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nari za paranga za na reko, <<Qa gilagilaiqua ara za pala mina lame za na Mesaea (aza za tagigala na Karisito), ko mina kamu tu aza za mina ule vadigita za doru zakazava,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Nari za oe laoa i Jisu aza, <<Ara tugu aza, ara qa korapa parangaigo koviria ani,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Pana totozo tugu aza za qari mule kamu ria na nana sepele ko qari gabarani za qari mule batia za korapa paraparangia maka reko aza. Ba kepore maka ria za bi paranga, babi nanaza lao veini ari, <<Koi, na za qu nyoroguani?>> bi guni na reko aza, babi, <<Ae za vei ko qu vavakato tavitia tu na reko zana ao?>> qarike guni tugu i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Beto za loi vakole pale na reko za na nana bogu pie, ko za mule lao tu pa guguzu, ko za parangaria ria na tinoni, ");
INSERT INTO ghn_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","<<Mae, lame! Mu dogoria maka tinoni za pojaniziu doru qua toa qa roitidi ara. Nake ani tugu beka za na Karisito?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ko qari taloi pa guguzu ketakoi ria na tinoni ko qari votu lao ti Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Totonai qari oqoro bola lame ria na tinoni rari za qari kole garugarunia ria na sepele i Jisu, <<Rabi, mu tekuteku mae tu,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ba ari za gudi vei i Jisu ria, <<Ara za kolenana na qua tekutekuna aza gamuke gilagilai na veveina gamu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nari qari podalai varivarinanaza makadi ria na sepele, <<Kaki tinoni beka qari tori pogozo kamu vani tu na tekutekuna aza?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nari za parangaria i Jisu ria, <<Na qua tekutekuna za ara ma vatabea gu na nyorogua tana aza za garunuziu beto ko ma vaokotia za na roiti tana. ");
INSERT INTO ghn_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ari gamu paranga vei za gamu, <Ka made popu gu za za kole beto mina kamu na totozo ababu,> gamu gua za gamu. Ba vainongoro ko ma pojadigamu ara: mu vaengaria na matamiu ko mu dogororia ria na inuma! Qari tori matua tu ko qari tori pada taabu tu ria na umuma! ");
INSERT INTO ghn_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Na tinoni za ababu za tatabara beto za pogozo varikamudi ria na vuvua ko mari tekua na toa jola, ko na tinoni za umuma beto aza za ababu za mari makarai qera beto. ");
INSERT INTO ghn_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Za zozoto gu za na paranga ari za gua vei, <Maka tinoni za umuma beto maka goto tinoni tu za ababu,> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ara qa garunugamu za gamu ko gamu keni abua aza gamuke pavu taleni. Ria kaki tu qari pavu taleni za na roiti, goto gamu za gamu abua na vuana gu na pavu tadiria na goto tinoni,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ego ko kubo ria na tinoni Sameria pa guguzu aza za qari vazozotoa i Jisu, tonai qari nongoria na ulule tana reko aza, ari za gua vei, <<Za poja betoniziu ria doru roiti qa roitidi ara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ko tonai qari lao kamua aza ria na tinoni Sameria, za qari tepa vitivitigi lao tana ko bi suvere iapeki mae tadiria qari gua. Nari za suvere ketakoi kori rane aza. ");
INSERT INTO ghn_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ego ko na kubo jola mule ria na tinoni qari vazozoto tonai qari nongoria na paranga ti Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ko qari parangia za na reko, <<Koviria za nake parangamu gu ao za gami vazozotoa, goto koviria gami vazozoto ura gami batia beto gami nongoria makamami za aza tugu zozoto za na inaalo pa kasia guguzu,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ego za jola kori rane beto za taloi ketakoi i Jisu, ko za mule gore pa Qalili. ");
INSERT INTO ghn_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(I Jisu makana za tori ululeni tu za na tinoni korokorotai za pa nana guguzu ketakoi za lavata zae gu za zake tatavaragua za gudi.) ");
INSERT INTO ghn_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ko tonai za kamu pa Qalili aza za qari vatoga valeania ria na tinoni ketakoi aza, ura qari tori somanani tu ria za na vavolo Alokata pa Jerusalema ko qari tori batiadia tu ria ria na zakazava za roitidi aza pa totozo vavolo aza. ");
INSERT INTO ghn_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ego za gabala mule lame pa Kena pa Qalili i Jisu, ketakoi za pelukuni vaini na kolo perangaina. Ko na suverena tugu ketakoi za maka tinoni matamata qavuna, za mo na tuna marene pa Kepaniami. ");
INSERT INTO ghn_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ko za nongoroni na tinoni matamata aza i Jisu za tori taloi tu pa Jiudia ko za gore vei tu pa Qalili qari gua, nari za lao gozoria ko za tepaia ko bi lao salania za na tuna marene pa Kepaniami, ura za tata zozoto mina uke aza za gua. ");
INSERT INTO ghn_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nari ari za guni vei i Jisu aza, <<Gamu za gamu nyorogua izongo batiria mae tu na roiti vinagilagila beto na roiti varivagabaradi beto za bu vazozoto gamu gua,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nari za paranga za na tinoni matamata aza, <<Bangara, mu siqarai tuti lame pinokoi za oqoro uke na tuqu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nari za parangia i Jisu aza, <<Mu mule lao, na tumu marene za pala mina toanana gu!>> za guni. Nari za vazozotoa tugu na tinoni matamata ani za na paranga ti Jisu ko za mule keni nana. ");
INSERT INTO ghn_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ko tonai za korapa goregorenana aza za qari gozoria pa zona ria na nana nabulu, ko qari pojani, <<Za tori leana tu za na tumu marene,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nari za nanazaria ria padapada ae totozo za vei za podalai leana aza za gudi, nari ari qari guni vei, <<Pada maka koloko korapa rane pa nyoro za gore na mangini,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nari za gilagila kamua na tinoni matamata ani za aza tugu za na totozo za poja veini ari i Jisu, <<Na tumu marene za pala mina toanana gu,>> za guni. Ko aza beto ria na nana tatamana doruna za qari vazozotoa i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ani za na roiti vinagilagila vinaori za roitini i Jisu pa liguna za taloi pa Jiudia ko za gore pa Qalili. ");
INSERT INTO ghn_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pa liguna na zakazava ari za taroiti za maka vavolo tadiria na tinoni Jiu, ko za zae pa Jerusalema i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ko za tata pa Atakamana Sipi pa Jerusalema ketakoi za kolenana za maka lolu pie, na izongona za na Betizata pa paranga Aramaiki, ko za kolea ka lima ongonguna aza. ");
INSERT INTO ghn_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ketakoi za qari kubo ria na varikamu minete tinoni momodi qari kole loka, ria qarike batabata, na qao beto ria za uke kale na kobu tinidi. ");
INSERT INTO ghn_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ko za kolenana ketakoi za maka tinoni za kole mo ka uengavulu vesu aoro. ");
INSERT INTO ghn_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ko za batia i Jisu za korapa kole ketakoi aza ko za dogoro gilagilai i Jisu na kakazana jola za na totozo za kole mo aza, ko za parangia, <<Ae vei qu nyorogua tasalana tugu ao?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nari za oe lao za na tinoni mo aza, <<Bangara, ara za kepore maka tinoni bi tokaniziu, ko bi toka laoniziu pa lolu pie totonai za nyakili na kolo. Totonai qa korapa podepodeke ko ba lao qa gua, nari za kaki goto tinoni tu za qari tori lao momoe tu,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nari za paranga laoia i Jisu aza, <<Mu turu, mu pogozia na mua lovu ko mu rerege,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aza tugu za paranga vei aza nari zake oriavo tugu za tasalana nana za na tinoni aza, ko za teku pogozia za na nana lovu beto za rerege keni nana. Ko na rane Minyere za roiti vei zara i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ko ria na matamata tadiria na tinoni Jiu qari kole paraparanga laoia za na tinoni za koni tasalana ani, ari qari guni vei, <<Na rane Minyere za pa ngenari, ko zake tavamalumu pana Vavanau za ao qu korapa pogozo lovu,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nari za oe laoria aza ria, <<Ura ara na tinoni tu za salanaziu za ari za garunu veiniziu, <Mu pogozia na mua lovu ko mu rerege!> za guniziu,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nari qari nanaza laoia aza, <<I zei za na tinoni aza za garunigo ko mu pogozia na mua lovu ko mu rerege za gunigo ao?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ba zake dogoro gilagilai na tinoni za tasalana ani i Jisu, ura qari kubo za na varikamu tinoni ketakoi ko i Jisu ba za tori pae keni nana tu pa varikamu tinoni. ");
INSERT INTO ghn_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Liguligu tu za batia i Jisu pa kakabarena zelepade tu aza, ko ari za guni vei, <<Dogoro! Koviria qu tori leana tu ao! Ko mu nogoto roitidi na toa ikerena keta mu gozoria na tapata lavatana jola,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ko totonai tu za taloi za na tinoni ani ko za keni ule vadi ria na matamata tadiria na tinoni za i Jisu za salania aza za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Pa totozo aza za qari podalai roiti komikomitia ria i Jisu, ura za roitidi na roiti vevei ari pa rane Minyere. ");
INSERT INTO ghn_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ba za pojadi i Jisu ria, <<Ara na Tamaqu za roiti lao gu doru totozo. Ko ara ba mana roiti vei tugu aza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Totonai za paranga vei zara aza za qari tagigiri ria na matamata Jiu, ko qari nyorogua vitivitigi vaukea i Jisu, ura nake makana gu na rane Minyere za majai aza, goto za pojai tugu vei za na Tamaza za na Tamana makana za gua, ko za vei za maka moqaza podeke muleni makana tana Tamaza aza. ");
INSERT INTO ghn_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nari za oeria i Jisu ria na matamata Jiu, ari za gudi vei, <<Zozoto pa zozoto ma pojadigamu ara za gamu: na tuna za zake boka roitini maka za makana, goto aza gu vei za batia za roitini na Tamana za roitini za na Tuna. ");
INSERT INTO ghn_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ura na Tamana za roquroqu vitivitigia za na Tuna ko za vadogoroni na Tuna ria doru vei za roitidi makana aza. Beto ko pala mina vabatini mutugu na tamana aza ria na zakazava poreveveidi mina roitidi ko mina joladi ari, ko muna gabara beto za gamu doru. ");
INSERT INTO ghn_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Za varitoto vei tugu za vatoa muleria na tamana ria qari tori uke tu ko za vadi na toa, nari za na Tuna ba za vadi tugu na toa ria za nyorogua vadi. ");
INSERT INTO ghn_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Na tamana makana ba zake pitua maka tinoni, goto za tori ia lao vani tu na Tuna za na neqi ko na Tuna za mina tutidi ria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ko mari valavatia ria doru tinoni za na Tuna, varitoto vei tugu qari valavatia ria za na Tamana. Na tinoni zake valavatia na Tuna za zake valavatia tugu za na Tamana aza za garunia za na Tuna. ");
INSERT INTO ghn_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Zozoto pa zozoto ma pojadigamu ara za gamu: aza za nongororia na qua paranga beto za vazozotoa aza za garunuziu ara, za tekua na toa jola ko minake tapitu aza; goto za tori jolani tu aza za na uke ko za tori karovo lao tu pana toa. ");
INSERT INTO ghn_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Zozoto pa zozoto ma pojadigamu ara za gamu: za korapa lamelamenana za na totozo, ko koviria tugu za na totozo aza, tonai mari nongoria ria na tinoni qari tori uke tu za na mamalaingina na Tuna na Tamaza, ko ria mari nongoria za mari toa. ");
INSERT INTO ghn_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ura na Tamana makana za na kutana na toa, beto ko za tori vani tu na neqi vei za na Tuna ko na Tuna tugu za na kutana na toa. ");
INSERT INTO ghn_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Beto za vani tugu vei na tuna za na neqi ko na Tuna mina boka tutidi ria na tinoni, ura na Tuna na Tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Muke gabarani aza qa pojadigamu ani; ura za korapa lamelamenana za na totozo tonai pala mari nongoria ria qari tori tagolomodi tu za na mamalaingina aza. ");
INSERT INTO ghn_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ko mari okoto votu ketakoi qari tagolomo ria ko ria qari roiti valeana za pala mari turu mule ko mari tekua na toa jola, goto ria qari roitini na ikerena za mari turu mule ko mari tapitu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","<<Ara qake boka roitini maka za pa qua neqi makaqu; ba aza gu vei qa nongoria tana tamaqu za qa pitua ko na qua varituti za na tuvizina, ura qake tutia na qua roquroqu makaqu goto na nyorogua tu tana aza za garunuziu za qa tutia. ");
INSERT INTO ghn_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Vei ba ulule muleniziu makaqu ara, nari za na qua ulule za bike pada tavazozoto. ");
INSERT INTO ghn_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ba kolenana za maka za ululeni na veveiqu ara, ko ara qa gilagilaiqua za na ulule veveiqu ara za pojai aza za na zozotona tugu. ");
INSERT INTO ghn_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Gamu tori garunu laoni tu gamu ti Jone ria kaki tinoni pogozo nongoro ko za tori ululeni tu aza za na zozoto aza. ");
INSERT INTO ghn_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ara nake vei ko na ulule tana maka tinoni qa teku vazozotoa qa gua za, goto qa pojaria ara ria na zakazava ari ko mu boka taalo gamu qa gua. ");
INSERT INTO ghn_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","I Jone za na juke za toa beto za tolanga vakabere, ko gamu gamu qerani mu suvere mae pa iapeki totozo za pa kabere tana. ");
INSERT INTO ghn_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ba kolenana za na ulule veveiqu ara za poreveveina jolani na ulule ti Jone. Ura ria na roiti za vaniziu na Tamaqu ko qa vaokotoria ara za ria tugu za na roiti qari ululeni na veveiqu ara beto qari uleni za ara za na Tamaqu tu za garunuziu. ");
INSERT INTO ghn_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ko aza na tamaqu za garunuziu aza za tori uleni tu na veveiqu ara. Gamu gamu oqoro izongo nongoria na mamalaingina beto gamu oqoro batia na tinonina aza, ");
INSERT INTO ghn_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","beto ko gamuke teku vakatapia pa miu toa za na nana paranga, ura gamuke vazozotoa gamu aza za garunia na Tamaqu. ");
INSERT INTO ghn_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Gamu tiro vilovilotoria gamu ria na paranga pa Kutikuti Tabuna, ura gamu roquroqua za ketakoi pala muna batini na toa jola gamu gua, ba ria na paranga qari takuti ketakoi za qari ululeni za na veveiqu gu ara. ");
INSERT INTO ghn_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ba gamu gamu daimiu tu lame za taqu ko bu tekua na toa jola. ");
INSERT INTO ghn_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ara za qake korapa nyaqo zona ko bari vatarazaeziu ria na tinoni qa gua. ");
INSERT INTO ghn_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ba qa gilagila valeanagamuqua ara za gamu; qa gilagilaiqua ara za kepore na variroqu lao tana Tamaza bi kole pa miu toa. ");
INSERT INTO ghn_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ara za qa lame pana neqi tana Tamaqu, ba gamu daimiu vatogaziu ara gamu; goto vei bi kamu tu pa nana neqi makana za maka tinoni, za pala muna vatogai gamu aza. ");
INSERT INTO ghn_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Na vatarazae gu tadiria na tinoni za gamu kole nyaqoa gamu ko bu tekua gamu gua, goto gamuke nyaqoa gamu za na vatarazae tana Tamaza makamakaina; ko ae mina vei beto muna boka vazozotoziu ara za vei? ");
INSERT INTO ghn_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Keta mu roquroqua za ara pala mana pitugamu pa moena na tamaqu. I Mosese tu aza gamu tori vakoleni tu na miu totoravuzu gamu za aza tugu za pala mina tutidigamu. ");
INSERT INTO ghn_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ura vei bu vazozotoa gamu i Mosese, nari za ara ba bu vazozotoziu tugu, ura aza tugu na veveiqu gu ara za kutia i Mosese. ");
INSERT INTO ghn_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ba gamuke vazozotoria ke za na kutikuti za kutiria aza, ko ae muna vei muna boka vazozotoria gamu ria na paranga taqu za vei!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ego pa liguna za vei zara, za i Jisu za karovo lao pa maka kalena na ovuku pa Qalili, maka izongona qari vakukuni za pa Tiberiasi. ");
INSERT INTO ghn_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ko maka minete tinoni lavata za qari kole tututia aza, ura qari tori batiria tu na roiti vinagilagila za roitidi aza tonai za salanaria ria qari mo. ");
INSERT INTO ghn_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nari za zagere zae pa kubokubo i Jisu, ko ketakoi za nyumu tavitiria ria na nana sepele. ");
INSERT INTO ghn_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ego ko za tori tata tu za na totozo vavolo Alokata tadiria na Jiu. ");
INSERT INTO ghn_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ego ko totonai za vaengaria na matana i Jisu ko za batia za na minete tinoni lavata za korapa lame tana, nari za nanaza laoia i Pilipi, <<Pae za tana boka vai ganigani ko tana vatekutekuria ria na tinoni ari?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Ba za paranga vei zara aza ko mi podekia gu i Pilipi za gua, goto aza za tori gilagilainana tu aza mina roitini.) ");
INSERT INTO ghn_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nari za oe lao i Pilipi, <<Ura vei mari okoto iapeki gu ria doru ari ba pala mina jolani tu kori gogoto poata siliva za mina tavaini na ganigani,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Azae maka ria na nana sepele, i Aduru, na taina i Saimone Pita, za paranga, ");
INSERT INTO ghn_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","<<Korapa makia nari za maka koburu marene ka lima gana bereti beto kori gana igana, ba pa varikamu tinoni vei ari na za mina vagavoria za ka viza moqamoqaza ganigani vevei zara?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nari ari za gua vei i Jisu, <<Ego vanyumu betoria ria na tinoni,>> za gua. Na ia kubo buruburuna za ketakoi, ko qari nyumu beto ria doru tinoni, na nguti varikamudi ria na marene za padapada vei lima tina. ");
INSERT INTO ghn_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Beto za tekuria i Jisu za na bereti, ko za paranga leana laodi tana Tamaza beto za iadi na tinoni qari nyumu. Beto za roiti veidi tugu za na igana, ko qari pote beto ria doru. ");
INSERT INTO ghn_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Pa liguna qari pote beto ria doru, nari za parangaria ria na nana sepele, <<Mu buti varikamu betodi ria na ganigani kole joladi, keta mari taaru vikevikere goboro,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ko qari buti teku varikamudi ria na ganigani kole taridi pa lima batu bereti qari teku tariria, ko qari vapugeledi ka manogori topa. ");
INSERT INTO ghn_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ko tonai qari batia ria na tinoni za na roiti vinagilagila za roitini i Jisu ani, za qari paranga, <<Ani zozoto tugu za na tinoni korokorotai mina lame pa kasia guguzu qari guni ria,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ego ko totonai za gilagilai i Jisu za qari qaqirini ko mari lame teku vabangaria aza qari gua, nari za taloi keni nana mule makana pa kubo aza. ");
INSERT INTO ghn_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ego totonai za gore na veluvelu, za qari oqa votu gore pa ovuku pa Qalili ria na sepele ti Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Qari zae pa maka koaka ria, ko qari toka karovo tuvizi lao pa Kepaniami. Ko za rodomo gu za na kota ba i Jisu za oqoro lame kamuria. ");
INSERT INTO ghn_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Za podalai gu raja lame za na gava lavata ko za nyakili ranebongi za na kolo. ");
INSERT INTO ghn_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ko qari tori qelu lao tu pada lima babi vonomo kilomita zouna ria na nana sepele beto qari dogoro vaia i Jisu za korapa rerege lamelame nana pa kolo. Totonai za rerege tata lame aza pa koaka za qari matagutu vitivitigi ria. ");
INSERT INTO ghn_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nari za parangaria aza, <<Ara gu ani, muke matagutu!>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Beto za qari malumu surania pa koaka ria aza. Aza tugu za zae pa koaka i Jisu nari za qari paro gu za pa ia ketakoi qari gona toto laoia ria. ");
INSERT INTO ghn_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ego ko za rane soga na kota nari za qari gilagilai ria na minete tinoni lavata qari suvere jola pa maka karovona na ovuku pa Qalili za maka moqamoqazana gu za na koaka za titi ketakoi. Beto ko qari batiadia tugu i Jisu ba zake zae tavitiria ria na nana sepele tonai qari toka, goto ria na sepele gu makadi za qari zae. ");
INSERT INTO ghn_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ba kaki koaka na lame veidi pa guguzu Tiberiasi za qari kamu paro tata pa ia ketakoi za manani na bereti i Jisu beto za iadi na minete tinoni ko qari tekuteku. ");
INSERT INTO ghn_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ko totonai qari gilagilai ria na minete tinoni za zake suvere ketakoi i Jisu beto ria nana sepele, za qari lao zaeria na koaka ko qari toka karovo lao pa Kepaniami ko qari kole nyaqoa i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Totonai qari lao paro pa maka kale karovona na ovuku pa Qalili ria na tinoni, za qari batia i Jisu ketakoi, ko qari nanazia, <<Rabi, pa viza tu qu kamu pani ao?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nari za oeria i Jisu ria, ari za gudi vei, <<Zozoto pa zozoto ma pojadigamu ara za gamu: aza vei beto gamu korapa nyaqo tutiniziu ara za nake vei ko gamu gilagilai gamu na ginuadi na qua roiti vinagilagila za, goto ura za teku leagamu gu na bereti ko gamu pote valeana. ");
INSERT INTO ghn_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nake tekutekuna zake oriavo na ikerena za mu tapatianani gamu, goto na tekutekuna tu aza za kole jola kamua na toa jola. Aza za na tekutekuna mina vadigamu na Tuna na Tinoni, ura na Tamaza Tamana za tori vakolea tu nana vinaego za tana tuna,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nari qari nanazia ria i Jisu, <<Na za mami roitini gami, ko mami roitidi ria na roiti tana Tamaza?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nari za oeria i Jisu ria, ari za gudi vei, <<Aza na roiti tana Tamaza za nyoroguadigamu ko mu roitini za mu vazozotoa aza za garunia aza za gua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nari ari qari guni vei ria aza, <<Na roiti vinagilagila ae veveina za muna roitini ao tadigami ko gami mami batia, beto za mami vazozotogo ao? Na za za muna roitini ao? ");
INSERT INTO ghn_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ria na nada tite za qari tekua na mana tekutekuna pa qega vei za pojai na Kutikuti Tabuna, ari za gua vei, <Aza za iadi na bereti za lagere vei pa noka ria ko qari tekuteku,> za gua,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nari ari za gua vei i Jisu, <<Zozoto pa zozoto ma pojadigamu ara za gamu: nake i Mosese za iadigamu gamu na bereti lagere veina pa noka, goto na tamaqu tu ara za vadigamu za na bereti zozotona za lagere vei pa noka. ");
INSERT INTO ghn_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Na bereti tana Tamaza za aza tugu na lagere veina pa noka, ko za vani na toa za na kasia guguzu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nari ari qari guni vei i Jisu, <<Bangara, mu vadigami ropi doru totozo za na bereti aza,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Nari ari za gudi vei i Jisu, <<Ara tugu za na bereti toana. Aza mina lame taqu za minake izongo burana beto aza mina vazozotoziu ara za minake izongo kidepe. ");
INSERT INTO ghn_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ba aza tugu vei qa tori pojadigamu tugu za gamu za gamu tori batiziumiu tugu ara za gamu ba gamuke vazozotoziu tugu. ");
INSERT INTO ghn_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ria doru za vaniziu na Tamaqu za mari lame tugu taqu, ko ria mari lame taqu za ara manake izongo tupele paledi ara. ");
INSERT INTO ghn_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ura ara za qa lagere vei pa noka ko manake tutia na qua nyorogua makaqu, goto na nyorogua tu tana aza za garunuziu ara za mana tutia. ");
INSERT INTO ghn_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ko na nyorogua tana aza za garunuziu za ara manake valumua za maka ria za tori vaniziu tu aza, goto mana vatoa mule betoria pa rane liguligu. ");
INSERT INTO ghn_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ura aza na nyorogua tana Tamaqu za ria doru qari batia na Tuna beto qari vazozotoa aza za mari izongia na toa jola, beto ara mana vatoa muleria pa rane liguligu ria,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nari qari podalai qumiqumini ria na tinoni Jiu aza, ura ari za gua vei, <<Ara za na bereti za lagere vei pa noka,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ko ari qari kole paranga vei ria, <<Qokolo, nake i Jisu na tuna i Josepa ani? Zake gua ko taqe gilagilarianada ria na tinana na tamana! Ba ae za vei za paranga tu, <Ara na lagere veiqu pa noka,> za gua?>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nari za oeria i Jisu ria, ari za gudi vei, <<Mu nogoto qumiqumi golomo makamiu. ");
INSERT INTO ghn_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kepore za maka tinoni mina boka lame taqu, vei minake toka lameni na tamaqu aza za garunuziu ara. Ko aza mina lame taqu za ara mana vatoa muleria pa rane liguligu aza. ");
INSERT INTO ghn_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ari za gua vei za qari kutia ria na tinoni korokorotai, <Mari tavavanau tana Tamaza ria doru tinoni,> za gua. Aza na tinoni za nongoria beto za vakoinonoa na parangana na Tamaqu za lame taqu. ");
INSERT INTO ghn_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nake vei ko kaki tinoni qari tori batini matadi tu za na Tamaza qake gua za. Goto makana gu aza na lagere veina tana Tamaza za tori batia tu za na Tamana. ");
INSERT INTO ghn_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Zozoto pa zozoto ma pojadigamu ara za gamu: aza za vazozoto za izongia na toa jola. ");
INSERT INTO ghn_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ara za na bereti toana. ");
INSERT INTO ghn_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ria na miu tite za qari tekua tugu na bereti mana pa qega, ba beto qari tori uke tu ria. ");
INSERT INTO ghn_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ba ani tu za na bereti za lagere vei pa noka, ko aza na tinoni mina tekua aza za minake uke. ");
INSERT INTO ghn_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ara za na bereti varivatoana na gore lagere veina pa noka. Na tinoni mina tekua za na bereti ani za mina toa kamua na kamua. Ura na bereti ani za na masaqu, ko aza za na toa tana kasia guguzu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nari za qari varigua makadi ria na tinoni Jiu, ari qari gua vei, <<Ae mina vei beto mina vaganidigita na tinoni ani za na masana?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nari ari za gudi vei i Jisu ria, <<Zozoto pa zozoto ma pojadigamu ara za gamu: vei munake gania gamu za na masana na Tuna na Tinoni beto vei munake bukua na orunguna aza, za gamu munake izongia za na toa. ");
INSERT INTO ghn_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Aza za nyapulia na masaqu beto za bukua na orunguqu ara, za izongia aza za na toa jola beto ara mana vaturu muleria pa rane liguligu aza. ");
INSERT INTO ghn_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ura na masaqu ara za na ganigani zozotona, na orunguqu ara za na buku zozotona. ");
INSERT INTO ghn_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Aza za nyapulia na masaqu beto za bukua na orunguqu ara za togaza taqu aza, beto ara qa togaza tana. ");
INSERT INTO ghn_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Maka moqaza podeke vei tugu na tamaqu za garunuziu ara za na toana ko ara ba qa tavatoa tugu vei tana, nari za na tinoni za nyapuluziu ara za mina toa tugu aza, ura na toaqu ara. ");
INSERT INTO ghn_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ani aza na bereti za gore lagere vei pa noka; na bereti ani za zake vevei na bereti qari tekua ria na miu tite beto pa liguna qari ukedia. Goto aza mina tekua na bereti ani za mina toa kamua na kamua,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Zara za na paranga za pojaria i Jisu totonai za varivagigalai aza pa ruma varivarikamuna pa Kepaniami. ");
INSERT INTO ghn_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ego ko kubodi ria na nana sepele za qari nongoria na paranga za pojai aza za qari paranga, <<Qokolo, za tapata na ponyolona za na varivagigalai ani! I zei mina boka gilagilai na ginuana ani!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ba za tori gilagilainana tu i Jisu makana za aza vei qari kole qumiqumini ria na nana sepele, ko ari za gudi vei, <<Ae za vei, gamu vatapatia tu gamu ani, ko gamu nyorogua taloimiu tu? ");
INSERT INTO ghn_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ae za vei, vei totonai bu batia gamu bi mule zae pa noka za na Tuna na Tinoni ketakoi za suvesuvere mae perangaina, nari ae bu vei? ");
INSERT INTO ghn_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Na Ongonguna gu na Tamaza za varivatoa. Na tinoni makana za zake boka vapodoa maka za. Ria na paranga qa tori paranga laodi tu ara tadigamu za na Ongongu beto na toa. ");
INSERT INTO ghn_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ba kaki gamu za gamuke vazozoto,>> za gudi. (Ura za tori gilagilarianana tu i Jisu pa podalaina zozoto tu ria qarike vazozoto, beto i zei ria za mina gabala kanai aza.) ");
INSERT INTO ghn_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Beto za paranga aza, <<Ko za vei za qa tori pojadigamu tugu, kepore za maka tinoni mina boka lame taqu, koi vei tu mina vamalumia na tamaqu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tonai zara za paranga vei aza, nari za na motadi ria na sepele tana za qari gabala muledia ko qarike tuti sogai aza. ");
INSERT INTO ghn_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nari ari za gudi vei i Jisu ari ka manogori sepele, <<Ae vei gamu? Gamu ba muna taloi kenimiu mutugu?>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nari za oe lao i Saimone Pita, <<Bangara, ti zei za mami lao gami? Ura ao gu qu izongia za na paranga za kolea na toa jola. ");
INSERT INTO ghn_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Beto gami za gami tori vazozoto tu beto gami tori gilagilaia tu za ao gu za na Liosona tana Tamaza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Nari za oeria i Jisu, <<Qa tori mijatagamu tu ara za gamu ka manogori, uve? E, ba maka gamu za na bangaradi na tomete,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(I Jiudasi gu, na tuna i Saimone Isikarioti, za guni aza, ura aza tugu za maka ari ka manogori sepele mina gabala kanai i Jisu.) ");
INSERT INTO ghn_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ego pa liguna za vei zara, za i Jisu za rerege ovikiria na guguzu pa Qalili. Zake nyorogua lekoia aza za pa Jiudia, ura ria na matamata tinoni Jiu za qari kole kuoni ko mari vaukea qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ego za tori tata tu za na totozo vavolo tonai qari suvere pa dia aqaqo ria na Jiu. ");
INSERT INTO ghn_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nari ari qari paranga lao vei tana aza ari ka viza taina marene, <<Mu tavaturu tu ao ko mu zae pa Jiudia ko ria na mua sepele mari batiria ria na mua roiti varivagabaradi qu roroitidi! ");
INSERT INTO ghn_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ura na tinoni za nyorogua tagilagila vakabere za kepore maka roiti za roitini pa paena! Ao za qu korapa roitidi ria na zakazava zara, ko mu bola votu tu tana kasia guguzu ko mari gilagilago ao!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Ura makadi gu ria na taina ba qarike vazozotoa aza.) ");
INSERT INTO ghn_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nari za parangaria i Jisu ria, <<Na totozo taqu za oqoro kamu. Goto gamu za doru totozo za na miu totozo gu. ");
INSERT INTO ghn_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Gamu za za boka tavaraguadigamu za na kasia guguzu, goto ara tu zake tavaraguaniziu ura qa ululeni za nana roiti za na ikikeredi qa guni. ");
INSERT INTO ghn_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gamu za mu zae tu somana pa vavolo, goto ara za manake zae pa vavolo zana, ura na qua totozo za oqoro kamu,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ko zara za paranga vei aza, beto za suverenana tugu pa Qalili. ");
INSERT INTO ghn_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ego pa liguna qari tori zae tu pa vavolo ari ka viza taina, nari za aza ba za tuti zae tugu, ba zake rerege vakabekabere pa varikamu tinoni goto za rerege gologolomonana tu. ");
INSERT INTO ghn_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ego ko ria na tinoni Jiu za qari kole nyaqonyaqoa pa vavolo aza, <<Ae aza?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Qari kole varimanamanaza golomoni ria na tinoni pa varikamu za na veveina i Jisu. Kaki qari paranga, <<Na tinoni leana aza,>> qari gua. Goto kaki za qari paranga, <<Dai, za toka varururaria na tinoni zana,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ba kepore za maka bi paranga votu lodalodakani za na veveina i Jisu, ura qari matagutudi ria na matamata tinoni Jiu. ");
INSERT INTO ghn_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ego totonai za tori varikorapai tu za na vavolo nari za zae pa kakabarena zelepade ko za kole varivagigalai i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ko qari kole gabara ria na matamata tinoni Jiu, ko qari paranga, <<Ae za vei ko nake sikuluna, ba za gigalai jola tu za na tinoni zana?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nari za oeria i Jisu ria, ari za gudi vei, <<Aza qa varivagigalaini ara za nake varivagigalai taqu, ba nana tu na Tamaza aza za garunuziu. ");
INSERT INTO ghn_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Na tinoni za malumu roitini aza za nyoroguani na Tamaza za pala mina gilagilai na veveina na qua varivagigalai. Pala mina dogoro pikatia za vei na koko lame veina tugu tana Tamaza za babi na qua gu makaqu. ");
INSERT INTO ghn_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Na tinoni za vavakato muleni na veveina makana za korapa gu nyaqoa na valavata muleni makana. Goto aza za nyorogua valavatia aza za garunia aza, za aza za na zozotona beto kepore maka zakazava sekesekena za kole tana. ");
INSERT INTO ghn_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","I Mosese tugu za vadigamu ko na Vavanau, ba kepore maka gamu bi vatabea za na Vavanau. Ae za vei gamu korapa tu nyorogua vaukeziu ara?>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Qari oe lao ria na minete tinoni, <<Qokolo, za vituligo gu na tomete ikikerena ao! I zei za korapa nyorogua vaukego ao?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nari za oe lao i Jisu, ari za gua vei, <<Maka roiti varivagabarana gu za qa roitini ara, nari gamu gabara beto tu za gamu doru. ");
INSERT INTO ghn_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","I Mosese za garunugamu ko mari tapobe ria na tumiu marene za gua (ba nake i Mosese za roiti momoeni za, goto ria na miu tite tu qari podalai momoeni), ko gamu poberia gamu pa rane Minyere ria na koburu marene. ");
INSERT INTO ghn_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ko vei pa rane Minyere bi tapobe za na tinoni ko vei ko mike tamaja za na Vavanau ti Mosese, nari za ae za vei za gamu tagigiriniziu tu ara tonai qa salana valeania maka tinoni pa rane Minyere? ");
INSERT INTO ghn_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Muke pitua na toa peguruna tana tinoni, goto mu pitua na varituti tuvizina tu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nari ari qari kole varivarinanaza vei ria kaki tinoni pa Jerusalema, <<Nake tinoni ani za qari korapa nyorogua vaukea ria na matamata? ");
INSERT INTO ghn_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ko dogoro! Za korapa paraparanga lodalodaka, ba kepore maka rari vei bi gua lao tana! Palu qari gilagilaidia ria na matamata za aza tugu beka za na Karisito? ");
INSERT INTO ghn_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ba totonai mina lame za na Karisito, za kepore maka tinoni mina gilagilai ketakoi na lame veina aza. Goto na tinoni ani za gita taqe tori gilagilai betoanada tugu gita ketakoi na lame veina,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ego ko totonai za korapa varivagigalai pa kakabarena zelepade i Jisu, za velavela votu, <<Ae za vei, gamu gilagila valeanaziumiu tugu gamu beto gamu gilagilaimiu ketakoi na lame veiqu ara? Ara za qake lame pa qua neqi makaqu, goto aza tu za garunuziu za na zozoto, ba gamu gamuke izongo gilagilai tu aza. ");
INSERT INTO ghn_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ara qa gilagilaiqua aza, ura ara za na koko veiqu tana beto ara za aza tugu za garunuziu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nari qari nyorogua aru tamania ria aza, ba kepore maka bi ulini limana aza, ura za oqoro kamua za na totozo tana. ");
INSERT INTO ghn_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ba kubo tinoni pa varikamu tinoni za qari vazozotoa aza, beto ari qari gua vei, <<Totonai mina lame na Karisito, za ae vei pala mina roitidi tugu aza za na zoku roiti vinagilagila joladi vei za roitidi na tinoni ani?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Qari nongoro vaia ria na Parese za qari kole varimanamanazani na veveina i Jisu ria na tinoni, ko qari garunuria ria na Parese beto na kuta iama ria na nabulu kopu, ko mari lao aru tamania i Jisu qari gudi. ");
INSERT INTO ghn_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Nari za ari za gudi vei i Jisu ria, <<Ara za mana suvere iapeki totozo mule tadigamu, beto za pala mana laoqua tana aza za garunuziu. ");
INSERT INTO ghn_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ko pala muna nyaqoziu ara za gamu ba munake boka batiziu, beto ketakoi mana lao suvere ara za gamu munake boka lao,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ego ko totonai qari nongoria ria na Jiu zara za gua vei aza, za qari variparanga makadi, <<Pae za mina lao za guni aza ko tanake boka batia gita? Mina lao pa kaki guguzu tadiria na tinoni Qiriki ketakoi qari korapa ria kaki tavitida tinoni Jiu ko mina lao varivagigalai tadiria na tinoni Qiriki? ");
INSERT INTO ghn_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Na za ginuana za na paranga tana? Ari za gua vei aza, <Pala muna nyaqoziu ara za gamu, ba munake boka batiziu, beto ketakoi mana lao suvere ara za gamu munake boka lao,> za gua,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ego pa rane betobetona na vavolo, aza na rane poreveveina, za turu i Jisu ko za velavela votu, ari za gua vei, <<Aza za kidepe za mi lame taqu ko mi buku! ");
INSERT INTO ghn_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Aza za vazozotoziu ara, za pala mina vei tugu za pojai na Kutikuti Tabuna, Pala mina bukabukala votu pa bulona na tinoni aza za na kolo toana,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Aza za guni i Jisu za na Ongonguna na Tamaza aza ria mari vazozotoa aza za mari tekua. Ba oqoro taiani ria za na Ongongu tabuna pa totozo aza, ura za oqoro turu mule zae pa nana neqi lavatana tana Tamana i Jisu.) ");
INSERT INTO ghn_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ego ko kaki tinoni pa varikamu za tonai qari nongoria za na parangana i Jisu, za qari paranga ria, <<Zozoto, aza zozoto tugu za na tinoni korokorotai lavatana za taadono!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Qari paranga ria kaki, <<Ani za na Karisito!>> qari gua. Goto kaki mule za qari paranga, <<Dai, nake pa Qalili mina votu lame vei za na Karisito! ");
INSERT INTO ghn_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Na Kutikuti Tabuna za pojainana tu za na karisito za mina lame pa tutina i Devita ko mina podo pa Betilihema tu, na guguzu ketakoi za suvere i Devita za gua,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ko pa veveina gu i Jisu, za tapikapikata za na minete tinoni. ");
INSERT INTO ghn_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Kaki ria za qari nyorogua aru tamania i Jisu, ba kepore tugu maka ria bi uli laoni limana aza. ");
INSERT INTO ghn_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ego ko totonai qari mule kamu ria na nabulu kopu pa zelepade, za qari nanaza ria na kuta iama na Parese, ari qari gua vei, <<Ae za vei ko gamuke toka lameni aza?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nari qari oe lao ria na nabulu kopu, ari qari gua vei, <<Oqoro maka tinoni bi paraparanga vei za paranga vei na tinoni ani,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nari qari paranga ria na Parese, <<Ko gamu ba koviria za tori toka vapirugamu tugu aza? ");
INSERT INTO ghn_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ae za vei, gamu tori gilagilaimiu tu gamu za maka matamata babi maka Parese bi tori vazozotoa mae tu aza? Bi mija tu! ");
INSERT INTO ghn_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ria na minete tinoni ari za qarike tavagigalani za na Vavanau, ko pala mari gozoria na vinakilasa tana Tamaza ke!>> qari gua ria na Parese. ");
INSERT INTO ghn_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nari za i Nikodimasi, maka ria aza za lao ti Jisu maka bongi, za parangaria, ");
INSERT INTO ghn_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","<<Na tutina pa nada Vavanau za gita taqeke oqanai pitua za na tinoni totonai za oqoro tanongoro ko bi oqoro tagilagila aza za roitini na tinoni aza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nari qari oea ria aza, ari qari guni vei, <<Ko ae vei, ao ba maka tinoni Qalili tugu ke, uve? Mu tiro vilotia tu na Kutikuti Tabuna ko, beto za muna gilagilai za na tinoni korokorotai za minake votu lame vei pa Qalili,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","(Ego ko qari okoto mule kenidia pa dia guguzu ria doru tinoni. ");
INSERT INTO ghn_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Goto i Jisu za laonana tu pa kubo pa Olive. ");
INSERT INTO ghn_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ko tonai za rane volavolaza na kota za mule lao pa kakabarena zelepade aza, ko tonai qari varikamuni ria doru tinoni nari za nyumu ko za varivagigalai lao tadiria aza. ");
INSERT INTO ghn_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Totonai za qari toka kamuni ria qari varivagigalaini na Vavanau beto ria na Parese za maka reko za tapoa tonai za kole barata, ko qari vaturua pa moedi ria doru tinoni. ");
INSERT INTO ghn_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Beto qari parangia i Jisu, <<Tinoni varivagigalai, na reko ani za tapoa zozoto tonai za kole barabarata. ");
INSERT INTO ghn_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ko pa nada Vavanau za vadigita i Mosese za na reko za roiti vei zara za mina tagona vaukeni patu tugu. Ba na za qu gua ao?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","(Zara qari paranga veini i Jisu, vei ko mari vagonai qari gua, beto vei ko mari jutua gu qari gua.) Nari za opo ovoro gore pa pezo i Jisu, ko za kole kutikutini na karukarusuna pa pezo. ");
INSERT INTO ghn_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ko tonai qari kole tugu nanazia lalaodia ria, nari za turu vatuvizi ko ari za gudi vei, <<Aza za kepore nana sela gamu za mi gonani na patu momoe za na reko zana,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Beto za opo soga gore pa pezo ko za kole mutugu kutikuti pa pezo. ");
INSERT INTO ghn_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Totonai qari nongoria zara za paranga vei aza, za qari okoto taloloi keni makamaka ria doru, podalai tadiria na tinoni momoadi ko mi gore, ko tinganai za taloi vamakai i Jisu, beto ko na reko ba za kole tugu turunana ketakoi. ");
INSERT INTO ghn_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Beto za turu vatuvizi soga mule i Jisu, ko ari za guni vei za na reko, <<Siu, ae ria? Ko Kepore maka za pitugo ao?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nari ari za gua vei za na reko, <<Kepore tugu, Bangara,>> za gua. Nari ari za gua vei i Jisu, <<Ego, leana, ara ba qake pitugo tugu ao. Ko mu taloi kenimua gu, goto munake roiti sogani na sela,>> za gua.) ");
INSERT INTO ghn_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ego ko za paranga laoria mule i Jisu ria na Parese, ari za gua vei, <<Ara za na kabere tana kasia guguzu. Aza na tinoni za tutiziu ara za mina izongia na kabere za varivatoa beto minake izongo rerege pa rodomo,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nari za ari qari gua vei ria na Parese, <<Koi, ko koviria qu korapa gu ululeni veveimu gu makamu gu ao; ko na mua vavakato za nake zozotona,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nari za oeria i Jisu ria, ari za gua vei, <<E, za zozoto tugu qa ulule muleniziu tugu makaqu ara, ba aza qa ululeni ara za zozoto, ura qa gilagilaiqua ketakoi na lame veiqu beto ketakoi mana lao vei ara. Goto gamu za gamuke gilagilai ketakoi qa koko vei beto ketakoi qa korapa lao vei ara. ");
INSERT INTO ghn_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Gamu za gamu varituti pa zona varitutidi tadiria na tinoni pa pezo gu, goto ara za qake pitua maka tinoni. ");
INSERT INTO ghn_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ba vei ba varituti tugu ara nari za zozoto tugu za na qua varituti, ura nake makaqu qa roitini, goto ara za gami kori na Tamaqu tu aza za garunuziu za gami roitini za na varituti. ");
INSERT INTO ghn_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ko za tori takuti kolena tu pa miu Vavanau za ari za gua vei, <Totonai mari varitoto za na ulule tadi ari kori tinoni za zozoto tugu za na dia vavakato,> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ara za qa ululeni na veveiqu makaqu, beto ko na tamaqu aza za garunuziu ba za ululeni tugu za na veveiqu ara,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nari qari nanaza ria, <<Ae za na tamamu?>> qari guni. Nari za oeria i Jisu, <<Gamuke gilagilaziu ara za gamu, beto ko na tamaqu ba gamuke gilagilai tugu. Vei bu gilagilaziu ara, nari na tamaqu ba bu gilagilai tugu vei,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Zara ria na paranga za pojaria i Jisu totonai za kole varivagigalai aza pa kakabarena zelepade, pa ia ketakoi qari vakolekoledi na bokese vavakoleni poata varivana. Ba kepore tugu maka tinoni bi aru tamania ketakoi aza, ura za oqoro kamua za na totozo tana. ");
INSERT INTO ghn_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ego ko ari za gudi vei mule i Jisu ria, <<Qa korapa keni ara, ko gamu pala muna nyaqoziu ara, ba gamu za pala muna pogozo ukedi na miu sela. Ketakoi qa korapa lao ara za gamu munake boka lao,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nari qari variparanga makadi ria na tinoni Jiu, <<Mina vauke muleni makana beka za korapa guni aza? Ura ari za gua vei, <Ketakoi qa korapa lao ara za gamu munake boka lao,> za gua,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nari za parangaria i Jisu ria, <<Gamu za na koko veimiu pa kauruna, goto ara za na gore lagere veiqu tu pa narena. Gamu za tana kasia guguzu ani, goto ara za nake tana kasia guguzu ani. ");
INSERT INTO ghn_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ko za vei za qa tori pojadigamu tu ara za pala muna uke tavitiria na miu sela za gamu. Ura vei munake vazozotoa gamu za ara za aza, za pala muna pogozo ukedi na miu sela za gamu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nari qari nanaza ria, <<I zei ao?>> qari guni. Nari za ari za gudi vei i Jisu, <<Beko qa tori pojadigamu tu pa podalaina zozoto. ");
INSERT INTO ghn_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kubo ria na zakazava veveimiu gamu mana boka pojadigamu ara beto mana pitudigamu ara. Ba aza za garunuziu ara za zozoto jola, ko ara za ria gu vei qa nongorodi tana za qa pojani na kasia guguzu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","(Qarike gilagilai ria za na veveina gu na Tamana za poja veidi i Jisu ria.) ");
INSERT INTO ghn_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ko ari za gudi vei i Jisu ria, <<Totonai muna ovulu vaiolo zaea za na Tuna na Tinoni, za beto muna gilagilai gamu za ara za aza. Ko totonai muna gilagila valeania gamu za kepore za maka zakazava qa boka roitini ara pa qua neqi makaqu, goto ria gu za vagigalainiziu na tamaqu za qa pojaria. ");
INSERT INTO ghn_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ko aza za garunuziu ara za somana tavitiziu ara. Zake loi vamakaziu ara, ura ara doru totozo qa roitidi na roiti qari vaqeraia aza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ria kubo tinoni qari nongoria zara za paranga vei aza za qari vazozotoa aza. ");
INSERT INTO ghn_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ego ko za parangaria i Jisu ria na tinoni Jiu qari tori vazozotoa tu, <<Vei muna togazaria gamu ria na qua paranga, nari za na qua sepele zozoto ara za gamu. ");
INSERT INTO ghn_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ko pala muna gilagilai gamu za na zozoto, beto na zozoto aza za mina ruvatagamu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Qari oea ria aza, <<Na tutina tu i Ebarahami gami, ko oqoro pore maka totozo babi tavapinauzu. Ko ae za vei za pala muna taruvata gamu qu gua tu ao?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nari za oeria i Jisu ria, <<Zozoto pa zozoto ma pojadigamu ara za gamu: ria doru qari roitini na sela za na pinauzu tugu tana sela. ");
INSERT INTO ghn_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Na pinauzu za nake suvere togazana pa tatamana, goto na tuna tu za na suvere togazana ketakoi ko mina kamua na kamua. ");
INSERT INTO ghn_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ko vei mina ruvatagamu na Tuna za gamu, nari za muna taruvata zozoto tugu za gamu. ");
INSERT INTO ghn_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Qa gilagilaiqua tugu ara za na tutina tugu i Ebarahami za gamu. Ba gamu tugu za gamu korapa nyorogua vaukeziu ara, ura gamuke teku vatogai na qua paranga. ");
INSERT INTO ghn_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ara za ria vei qa tori batiria tu tana tamaqu za qa pojaria, goto gamu za ria vei za pojadigamu na tamamiu za gamu roitidi,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Qari oea ria aza, <<I Ebarahami tugu za na tamamami gami,>> qari gua. Nari za oeria i Jisu ria, <<Vei bi na tuna zozoto tugu i Ebarahami za gamu, ko bu roitidi tu za na roiti vei za roitidi i Ebarahami. ");
INSERT INTO ghn_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ba koviria za gamu nyorogua vaukeziu tu ara, aza ara tugu qa ule vadigamu na zozoto aza qa nongoria tana Tamaza. I Ebarahami zake roiti vei aza! ");
INSERT INTO ghn_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Goto gamu za na roiti tana tamamiu gu za gamu korapa roitidi,>> za gua i Jisu. Nari ari qari guni vei aza, <<Gami za nake podo goboromami. Na Tamaza gu makana za na tamamami,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nari za ari za gudi vei i Jisu ria, <<Vei na Tamaza tugu za bi tamamiu zozoto gamu, nari bu roquroquziu tu ara, ura ara za na koko lamequ tana Tamaza beto za qa lame kamu pani. Ara za qake lame pa qua neqi makaqu, goto aza tu za garunuziu. ");
INSERT INTO ghn_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ae za vei ko gamuke boka tu gilagilaria gamu ria na paranga taqu? Na ginuana gamu vei aza za ura gamu daimiu vainongorodi gamu za na parangaqu ara. ");
INSERT INTO ghn_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Gamu za na koko veimiu tana tamamiu, aza na bangaradi na tomete, ko za vei za gamu nyorogua tutiria na nyorogua tana tamamiu. Ura na tinoni varivuke aza podalai tu pa podalaina zozoto, beto zake izongo turu vei pa zozoto aza ura na zozoto zake kole tana. Totonai za sekeseke aza, nari za roiti vavotuni gu aza za na nana toa, ura na kutana na sekeseke aza beto na tamadi ria doru tinoni sekesekedi aza. ");
INSERT INTO ghn_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ba ara qa pojai ko na zozoto, ko za vei za gamuke vazozotoziu gamu. ");
INSERT INTO ghn_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","I zei gamu za mina boka udukuziu za ara qa sela, mina gua? Ba vei na zozoto gu za qa pojai ara, nari za ae za vei gamuke vazozotoziu tu ara za gamu? ");
INSERT INTO ghn_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Aza na koko veina tana Tamaza, za nongoria na paranga tana Tamaza; ko za vei za gamuke boka vazozotoziu ara, ura gamu za nake koko veimiu tana Tamaza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Qari oea ria na Jiu aza, ari qari guni vei, <<Gami zotomami gu gami tonai gami gigalanigo na tinoni Sameria ko za tigorigo na tomete gami gunigo gami ao!>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nari za oeria i Jisu, <<Ara zake tigoroziu na tomete, goto qa valavatia na tamaqu, ba gamu gamuke valavataziu ara. ");
INSERT INTO ghn_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ara za qake nyaqoa ko ma tavalavata qa gua, goto kolenana tu za aza za korapa nyaqoa na vinalavata beto aza tu za varituti. ");
INSERT INTO ghn_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Zozoto pa zozoto ma pojadigamu ara za gamu: aza za vataberia na qua paranga za minake izongo uke,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nari ari qari guni vei ria na Jiu aza, <<Koviria za gami gilagila valeanigo za tigorigo tugu na tomete ao! I Ebarahami za tori uke tu beto ko ria na tinoni korokorotai, ba qu paranga ao, <Aza za vatabea na qua paranga za minake izongo gozoria na uke,> qu gua. ");
INSERT INTO ghn_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Quke dogoro veinigo qu poreveveina jolani i Ebarahami na tamamami ao, uve? I Ebarahami za uke, beto ko ria na tinoni korokorotai ba qari uke tugu! Goto i zei qu roverove veinigo makamu ao?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nari za oeria i Jisu, <<Vei ba valavata muleniziu ara, nari za bi kepore veveina za na vinalavata aza. Ba na tamaqu tu aza qu gigalani na miu Tamaza gamu, aza tu za valavataziu ara. ");
INSERT INTO ghn_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Gamuke izongo gilagila podekia gamu aza, goto ara qa gilagilaiqua aza. Vei qake gilagilai ara aza ba gua, nari za ba tinoni sekesekequ varitoto vei tugu gamu ara. Goto qa gilagilaiqua ara aza beto qa vatabea ara za na nana paranga aza. ");
INSERT INTO ghn_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Na tamamiu i Ebarahami ba za qerani za mina batia za na lame taqu, ko za batianana tugu beto za qerani,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nari ari qari guni vei ria na Jiu aza, <<Koi! Ao za oqoro izongo limangavulu aoromu podeke tugu, ko ae bu boka bati veini i Ebarahami?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nari ari za gudi vei i Jisu ria, <<Zozoto pa zozoto ma pojadigamu ara za gamu: totonai tu za oqoro pore i Ebarahami, za ara za aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nari za qari buti patu ko mari gonagonai qari gua, ba za golomo vapae muleni makana i Jisu beto za taloinana pa kakabarena zelepade. ");
INSERT INTO ghn_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ego totonai za korapa rerege lao i Jisu, za batia aza za maka tinoni na podo nake batabatana. ");
INSERT INTO ghn_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nari qari nanazia ria na nana sepele aza, ari qari guni vei, <<Rabi, i zei za sela ko za podo nake batabatana za na tinoni ani? Na tinoni ani, ba ria na tinana na tamana?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nari za oeria i Jisu ria, ari za gudi vei, <<Na nake batabata za vaia na tinoni ani za nake pa nana sela tugu, beto nake sela tugu tadiria na tinana na tamana vei, goto vei gu ko mi bola votu tana za na roiti tana Tamaza za gua. ");
INSERT INTO ghn_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Pinokoi za korapa kabere na rane, nari za ara ma roitidi ria na roiti tana aza za garunuziu ara, ura na bongi za korapa nono lame totonai minake boka roiti za na tinoni. ");
INSERT INTO ghn_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Totonai qa korapa pa kasia guguzu ara za ara tugu za na kaberena na kasia guguzu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pa liguna za poja vei zara aza, nari za odolo pa pezo ko za vanyelakia aza za na pezo beto za ora laoni pa matana na tinoni nake batabatana ani. ");
INSERT INTO ghn_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Beto ari za guni vei za na tinoni nake batabata ani, <<Mu lao ko mu subi pa lolu pie pa Siloami,>> za guni. (Na ginuana na izongo Siloami za na tagarunu.) Nari za keni tugu za na tinoni aza ko za subi ko za batabata za na matana beto za mule lame. ");
INSERT INTO ghn_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ria kaki tavitina beto ria na tinoni vei qari tori batibatiadia tu na kole tepatepana aza perangaina za qari varivarinanaza, <<Nake aza tugu na tinoni za kole nyumunyumu tepatepa pa nari ani?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Qari paranga ria kaki, <<Aza tugu ani!>> qari gua. Goto kaki qari paranga, <<Dai, nake aza zana, goto za dogoro vei gu aza!>> qari gua. Nari za paranga makana za na tinoni aza, <<E, ara tugu aza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nari qari nanazia ria aza, <<Ko ae za vei beto qari boka tu batabata na matamu ao koviria?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nari za oeria aza ria, <<Maka tinoni na izongona i Jisu za odolo vanyelakia na pezo ko za oradi na mataqu, beto za garunuziu ko mu lao subi pa lolu pie pa Siloami za guniziu. Ko qa keni ko qa subi nari za beto qa batabata soga,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nari qari nanazia aza, <<Ko ae aza?>> qari gua. <<Ura! Qake gilagilai!>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ego ko qari toka laoni tadiria na Parese za na tinoni za podo nake batabatana zana. ");
INSERT INTO ghn_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Aza na ranena za odolo vanyelakia na pezo i Jisu ko za salania na tinoni nake batabatana aza za na rane Minyere. ");
INSERT INTO ghn_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ko qari maka nanaza sogai ria na Parese za na tinoni aza ae vevei zozoto beto qari batabata na matana qari guni. Nari za ari za gudi vei, <<Za orani nyelaka za na mataqu, beto qa subi nari za koviria za qa batabataqua,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nari qari paranga ria kaki Parese, <<Nake koko veina tana Tamaza za na tinoni aza, ura zake kopuni aza za na rane Minyere,>> qari gua. Ba kaki za qari paranga, <<Ba ae za vei beto za boka tu roitini na roiti vinagilagila veveidi zara za na tinoni selana?>> qari gua. Ko za varipikapikata za na roquroqu tadiria. ");
INSERT INTO ghn_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ko qari nanaza sogai mutugu ria na Parese za na tinoni aza, <<Ko i zei qu guni ao za na tinoni aza, ura za salana vabatabataria aza za na matamu ao?>> qari guni. Nari za ari za gudi vei na tinoni aza, <<Maka tinoni korokorotai qa guni ara aza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ba qarike vazozotoa tugu ria na tinoni Jiu za nake batabatana perangaina ko koviria za batabata aza, tinganai ko qari kuku tekuria tu ari kori tamana na tinana, ");
INSERT INTO ghn_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ko qari nanazaria, <<Ani tugu za na tumiu marene aza za podo nake batabatana gamuguni gamu kori? Ko ae za vei beto za boka batabata koviria?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nari qari oeria ari kori tamana na tinana, ari qari gudi vei, <<E, gami gilagilaimami za na tumami marene tugu gami kori aza, beto ko na podo nake batabatana tugu vei aza. ");
INSERT INTO ghn_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ba ae za vei beto koviria za boka tu batabata za gamike gilagilai, beto ko i zei za vadogodogoria na matana ba gamike gilagilai tugu. Aza gu mu nanazia ko, nake koburuna zana! Pala makana mina ule vadigamu na veveina!>> qari gua ari kori. ");
INSERT INTO ghn_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Zara qari paranga vei ari kori tamana na tinana, ura qari matagutudi ria na tinoni Jiu. Ura qari tori varivaegoni tu ria na tinoni Jiu za na tinoni vei mina ule votuni i Jisu za na Karisito mina gua za mina taiju pale pa ruma varivarikamuna qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ko za vei za qari paranga gu ari kori tamana na tinana na koburu, <<Nake koburuna zana, aza gu mu nanazia ko!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nari qari kuku sogai na vinaori totozo ria za na tinoni za podo nake batabatana, ko ari qari guni vei, <<Mu pojai na zozoto pa moena na Tamaza! Ura gami gilagilaimami za na tinoni za salanigo ao zana za na tinoni selana,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nari za oe za na tinoni ani, <<Bi tinoni selana aza za ara qake gilagilai. Goto maka zakazava gu qa gilagilai ara za qake batabata perangaina ara, ba koviria za qa batabata,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nari ari qari guni vei, <<Ae za roiti veinigo? Na za za roitini beto za vabatabataria na matamu?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nari za oeria, <<Na beko qa tori ule vadigamu tu, ba gamu daimiu vainongoro! Ae za vei ko gamu nyorogua nongoro sogai mutu? Gamu ba gamu nyoroguani ko bu na sepele tugu tana gamu gua za gamu?>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Zara za gua vei aza, za qari paranga sasuria aza, <<Ao tugu za na sepele tana nari, goto gami za na sepele tu ti Mosese. ");
INSERT INTO ghn_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Gami gilagilaimami na Tamaza za paranga zozoto ti Mosese, goto aza na tinoni zana za gami gamike gilagilai pae koko veina aza,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nari za oe za na tinoni aza, ari za gua vei, <<Koi, ko za varivagabara! Ura gamuke gilagilai gamu pae koko veina aza, ba ara za vabatabataria tu na mataqu! ");
INSERT INTO ghn_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Taqe gilagilainada gita na Tamaza zake nongororia ria na tinoni seladi, goto ria gu qari madini aza beto qari tutia na nana roquroqu za nongororia aza. ");
INSERT INTO ghn_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Pa moa vei tu totonai za podalai na totozo za zake tanongoro podeke za maka tinoni bi tori vabatabatai mae tu maka tinoni podo nake batabatana. ");
INSERT INTO ghn_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ko vei bike lame veina tana Tamaza za na tinoni ani za bike boka roitini aza za na roiti vevei aza,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nari qari oea ria aza, ari qari guni vei, <<Ao za na galegale podo lamemu pa sela ao, ba qu korapa nyorogua vagigalaigami gami!>> qari gua. Ko qari iju votu pale pa dia ruma varivarikamuna aza. ");
INSERT INTO ghn_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Totonai za nongoria i Jisu za qari tori iju votu pale tu aza, nari za nyaqoa aza ko za nanazia, <<Ae za vei, qu vazozotoa tugu ao za na Tuna na Tinoni?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nari za oe za na tinoni aza, ari za gua vei, <<Bangara, mu ule vaniziu i zei za na tinoni aza, ko ma vazozotoa!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nari ari za guni vei i Jisu aza, <<Qu tori batia tu ao aza, ko aza tugu za korapa parangaigo koviria ani,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nari za paranga, <<Bangara, qa vazozoto ara koviria!>> za gua, beto za koqomo sori tungutungu gore pa moena i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nari ari za gua vei i Jisu, <<Ara za qa lame ko mana varituti pikapikata pa kasia guguzu ani, ko ria qarike batabata za mari batabata goto ria na batabatadi za marike batabata,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Kaki ria na Parese qari somana suvere tavitia aza ketakoi za qari nongoria ari za paranga vei aza, ko qari nanaza laoa, <<Ko gami ba gamike batabata qu gudigami ao?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Nari ari za gudi vei i Jisu ria, <<Vei buke batabata za bi kepore na miu sela, ba koviria gamu paranga za na batabatamami gami gamu gua, ko za vei za korapa kolenana tugu na miu sela za gamu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Za paranga i Jisu, <<Zozoto pa zozoto ma pojadigamu ara za gamu: na tinoni zake luge vei pa atakamanana na toba sipi, goto za keza goboro vei tu pa goto ia, za na tinoni ikikona beto na tinoni raja ikikona aza. ");
INSERT INTO ghn_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ba na tinoni za luge vei pa atakamanana na toba za na sepati tadiria na sipi aza. ");
INSERT INTO ghn_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Na tinoni kopu za revanga vani na atakamana aza. Ria na godo sipi qari nongoro gilagilai na mamalaingina beto za gigalaria na okoto izongodi ria na nana sipi, ko za toka votudi. ");
INSERT INTO ghn_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Pa liguna za toka vavoturia, nari za rerege pa moedi ria na sipi aza beto ria za qari tutia aza, ura qari tori nongoro gilagilai tu ria za na mamalaingina aza. ");
INSERT INTO ghn_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ria za marike izongo tuti goboria mule za maka goto tinoni. Pala mari ukuni tu aza, ura qarike nongoro gilagilai ria za na mamalaingina na goto tinoni,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ko ani za na vavakato vavapada za vavakato vadi i Jisu, ba qarike vagilagilai tu ria za na ginuana. ");
INSERT INTO ghn_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nari ari za gua vei mule i Jisu, <<Zozoto pa zozoto ma pojadigamu ara za gamu: Ara za na atakamana tadiria na sipi. ");
INSERT INTO ghn_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ria doru qari valiguliguziu ara ko qari lao momoe za na tinoni ikikodi beto na tinoni raja ikikona, ba na sipi qarike nongororia ria. ");
INSERT INTO ghn_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ara za na atakamana. Aza za lame luge vei pana taqu za mina tavasare; mina luge na votu keni nyaqogana buruburu ganigani. ");
INSERT INTO ghn_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Na tinoni ikikona za lame ko za iko, za kubolo vaukegana beto za pipiaranana gu. Ba ara za qa lame ko ria na tinoni mari boka izongia za na toa beto ko mari izongia na toa pugelena qa gua. ");
INSERT INTO ghn_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ara za na sepati leana. Na sepati leana za vadi na sipi za na nana toa. ");
INSERT INTO ghn_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Na tinoni za tatabara gu beto za roiti za nake sepati beto zake izongoria za na sipi, ko totonai za batia na lamena maka vulupu nari za uku loi paledi za na sipi. Ko za garataria na vulupu ria na sipi qari taloi pale beto za adu vaqavaqata laodi doru kota. ");
INSERT INTO ghn_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Za uku keni nana za na tinoni za tatabara, ura za tatabara gu aza ko zake roquroquria za na sipi. ");
INSERT INTO ghn_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ara za na sepati leana, ko qa gilagilaria ria na qua sipi beto ria na qua sipi qari gilagilaziu ara. ");
INSERT INTO ghn_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Maka moqaza podeke vei na Tamaqu za gilagilaziu ara beto ara ba qa gilagilai na Tamaqu, nari za ara ba qa vadi na sipi za na qua toa. ");
INSERT INTO ghn_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ba koledia mule za kaki qua sipi qari oqoro somana kole pa toba ani. Pala mana toka lamedi tugu ria, ko mari nongoria na mamalaingiqu ko mari varikamu lame pa godo sipi tana maka sepati gu. ");
INSERT INTO ghn_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Na Tamaqu za roquroquziu ara, ura qake rabeke varivanani ara za na qua toa, ko za vei za mana boka teku muleni gu za na qua toa. ");
INSERT INTO ghn_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kepore za maka tinoni za boka ragata vakeniniziu na qua toa, goto qa vamalumia gu pa qua roquroqu makaqu ara za na qua toa. Ara qa boka valaoa za na qua toa beto ara mana boka teku muleni aza. Na garunu ani za qa tekuni ara tana Tamaqu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ego ko za maka tapikapikata mule za na tinoni tonai qari nongoria na paranga aza. ");
INSERT INTO ghn_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kubodi ria za qari paranga, <<Za kolea na tomete ko za tuturu zana! Ae za vei ko gamu nyorogua nongoria gamu za?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ba kaki za qari paranga, <<Na tinoni za kolea na tomete za zake boka paranga vei zara! Na tomete mina boka vabatabatai tugu na tinoni nake batabatana?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ego pa totozo za lomozo na kota za taroiti za maka varikamu qeraqera na roquroquna na vatabunana sogana na zelepade pa Jerusalema, ");
INSERT INTO ghn_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ko i Jisu za kole rerege lao vei pa ia qari gigalani na suvesuverena ti Solomone pa korapana na kakabarena na zelepade. ");
INSERT INTO ghn_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nari qari varikamu varilivutaini ria na Jiu aza, beto qari nanazia, <<Ae zovai veina za muna kole varura gami ao? Vei na Karisito zozoto ao, za mu lodaka vadigami gu,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nari za oeria i Jisu ria, <<Qa tori pojadigamu tu za gamu, ba gamuke vazozoto. Ria na roiti qa roitidi ara pa neqi tana tamaqu za ria tugu za qari ululeni na veveiqu ara; ");
INSERT INTO ghn_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ba gamu za gamuke vazozotoziu ara, ura koko vei nake qua sipi ara za gamu. ");
INSERT INTO ghn_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Na sipi taqu za qari nongoria tugu na mamalaingiqu, ko ara qa gilagilaria ria, beto ria ba qari gilagilaziudia ko qari tutiziu ara. ");
INSERT INTO ghn_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ara qa vadi na toa jola ko marike izongo uke manyao, beto ko kepore maka tinoni mina ragata vizu tekuria pa limaqu ria. ");
INSERT INTO ghn_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Na Tamaqu aza za vaniziu ria za lavata joladi doruna na zakazava, ko kepore maka tinoni mina boka ragata vizu tekuria pa limana aza ria. ");
INSERT INTO ghn_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Na Tamaqu beto ko ara za maka gu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Totonai za paranga vei zara aza za qari maka volozo buti patu mule ria na Jiu ko mari gonagonai qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Za paranga laoria i Jisu ria, <<Na kubo roiti leadi za vaniziu na tamaqu za qa tori vadogorodigamu tu. Ko ae ria na roiti leadi ari za gamu nyorogua gonaniziu ara na patu gamu?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Qari oea ria na Jiu aza, <<Nake roiti leadi ria za gami nyorogua gonanigo na patu gami ao, goto na mua vamoroanana tu na Tamaza! Ura ao ko na tinoni gu, ba qu vatamaza mulenigo makamu!>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nari za oeria i Jisu ria, <<Na takutina pa miu Vavanau za ari za paranga vei na Tamaza, <Ara qa paranga za gamu za na tamaza,> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Taqe gilagilainada gita za na Kutikuti Tabuna za zake tamaja goboro. Ko vei na Tamaza tu mina kukudi na tamaza ria na tinoni qari vatogai na paranga tana Tamaza, ");
INSERT INTO ghn_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","nari za ae za vei za gamu gamu jutuniziu tu qa vamoroania na Tamaza ara tonai ari qa gua vei, <Ara za na Tuna na Tamaza,> qa gua? Ba ara tugu za mijata vamadiziu beto za garunu lameniziu pa kasia guguzu. ");
INSERT INTO ghn_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Vei bake roitidi ria na roiti tana tamaqu za muke pavu vazozotoziu. ");
INSERT INTO ghn_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ba vei ba roitidi tugu ara ria, nari vei buke vazozotoziu tugu gamu ara, nari ba mu vazozotoria gu ropi ria na roiti qa roitidi, ko mu boka gilagila valeania za na tamaqu za somana tavitiziu ara, beto ara qa somana tana,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Totonai za gua vei zara aza nari za mari maka aru tamania mule i Jisu qari gua, ba za peki sulopo votu keni nana tadiria i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ego beto za taloi ketakoi aza, ko za maka karovo lao mule pa maka karovona na pie Jodani, pa ia ketakoi za varivapaputaiso perangaina i Jone, ko za lao suverenana ketakoi. ");
INSERT INTO ghn_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ko kubo tinoni za qari kamu tana, beto ko ari qari gua vei ria, <<I Jone za kepore maka roiti vinagilagila bi roitini, ba doruna vei za pojai i Jone na veveina na tinoni ani za zozoto tugu,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ko ria na kubo tinoni ketakoi za qari vazozotoa aza. ");
INSERT INTO ghn_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Maka tinoni na suverena pa Betani za mo, na izongona i Lazarasi. Pa Betani za na guguzu ketakoi qari suvere ari Mere beto i Mata ari kori tamatazi. ");
INSERT INTO ghn_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(I Mere ani aza za vuvani na oela omanga lea pa nenena na Bangara beto ko za puqani tugu na vurunguna, ko na luluna aza i Lazarasi za mo.) ");
INSERT INTO ghn_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ko qari garunu laoni nongoro ari kori tamatazi reko ari i Jisu, ari qari guni vei, <<Bangara, dogoro! Aza na mua baere leana qu roquroqu vitivitigia ao za mo,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Totonai za nongoroni, za ari za gua vei i Jisu, <<Na mo zana za minake lao jutu pa uke, goto vei ko mi tavalavata za na Tamaza, beto pa ginuana na mo aza ba mina tavalavata mutugu za na Tuna na Tamaza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","(Za roquroquria i Jisu ari Mere i Mata, kori tamatazi, beto na luludi i Lazarasi.) ");
INSERT INTO ghn_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ko totonai za nongoria i Jisu za mo i Lazarasi, nari za suverenana mae tu ketakoi za kole suvere kori rane mule i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pa liguna aza beto za paranga laoria ria na sepele aza, <<Aria koviria ko ta mule zae soga tu pa Jiudia,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Qari parangia ria na sepele aza, <<Rabi, za oqoro zovai pa viza gu zana ba mari gonanigo na patu qari gua ria na Jiu, ko na za mule qu nyorogua mule zaeni ketakoi?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nari za oeria i Jisu, <<Gamu gilagilaimiu gamu za na rane za tapikapikata pa manogori aoa? Ko za vei za na tinoni mina rerege pa rane kaberena za minake izongo tatupe tugu, ura za batabata pa kaberena na kasia guguzu ani. ");
INSERT INTO ghn_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Goto vei mina rerege na bongi aza, nari za pala mina tatupe za na tinoni aza, ura kepore na nana kabere,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Za beto gu paranga vei zara aza, beto ari za gua vei mule, <<Na nada baere leana i Lazarasi za tori puta tu, ba mana lao ko mana vaiqolia gu ara aza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nari za ari qari guni vei ria na sepele aza, <<Bangara, vei mina tori puta tu za pala mina leana gu aza,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","(Ba aza vei na ginuana za pojai i Jisu za tori uke tu i Lazarasi, goto ria qari roquroqua za putagana gu za guni aza qari gua.) ");
INSERT INTO ghn_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nari za lodaka vadi gu i Jisu za na nongoro, ari za gudi vei, <<Za tori uke tu i Lazarasi, ");
INSERT INTO ghn_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ba ura pa ginuguamiu gamu za qa qera za ara qake suvere tavitia aza, ko mu vazozoto za gamu. Ko aria ko ta lao tana koviria,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nari ari za gudi vei i Tomasi ria kaki sepele, aza qari vaizongoni Patavivi, <<Ego, ariagada ko gita doru ta tutia tu, ko ta uke tavitia aza!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ego totonai za kamu pa Betani i Jisu za tori jola tu ka made ranena za tagolomo i Lazarasi. ");
INSERT INTO ghn_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Na guguzu pa Betani za tata kue kilomita gu na zouna pa Jerusalema, ");
INSERT INTO ghn_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ko kubodi ria pa Jiudia qari varikamu suvere vamanotoria ari Mata i Mere pa uke tana luludi marene i Lazarasi. ");
INSERT INTO ghn_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ego ko totonai za nongoroni i Mata za korapa lamelamenana i Jisu, nari za votu lao gozoria, goto i Mere za suverenana tu pa ruma. ");
INSERT INTO ghn_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Nari i Mata ari za guni vei i Jisu, <<Bangara, vei bu suveremua ao pani, za bike uke za na luluqu marene! ");
INSERT INTO ghn_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ba koviria ba qa gilagilaiqua na za aza muna tepai tana Tamaza nari na Tamaza pala mina vanigo gu ao,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Za paranga laoa i Jisu aza, <<Pala mina turu mule gu za na lulumu marene,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nari za oe lao i Mata, <<Qa gilagilaiqua za pala mina turu mule pa rane turumule pa rane liguligu aza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nari ari za guni vei i Jisu aza, <<Ara za na turumule beto na toa. Aza mina vazozotoziu ara za mina uke tugu, ba pala mina toa; ");
INSERT INTO ghn_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","beto aza za korapa toa ba za vazozotoziu ara za marike izongo uke kamua na kamua. Ae vei, qu vazozotoa tugu ao za ani?>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nari za oe lao i Mata, <<E, Bangara, ara qa tori vazozotoa tu za ao tugu za na Karisito, na Tuna na Tamaza, aza za korapa lamelamenana pa lame pa kasia guguzu qari guni,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pa liguna za paranga vei zara, nari za mule lao pa ruma i Mata ko za peki kuku golomia za na taina i Mere ko za ule vani, ari za gua vei, <<Na Tinoni varivagigalai za tori korapa tu nari, ko za nanazanigo tugu ao,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ko aza tugu za nongoro i Mere, za soqolo turu ko za lao gozoria aza. ");
INSERT INTO ghn_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Za oqoro bola kamu pa guguzu i Jisu, goto za korapa tu ketakoi za lao parangani i Mata.) ");
INSERT INTO ghn_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ko ria na tinoni qari kole suvere vamanotia i Mere pa leo ruma za qari tuti votu totonai qari batia na siqarai votu kenina i Mere. Qari roquroqua ria za palu mina lao lukana pa bevi ketakoi qari golomoni i Lazarasi ba za qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ego za lao kamu ketakoi za korapa suvere i Jisu i Mere, ko aza tugu za batia i Jisu nari za todongo pa nenena i Jisu, beto za paranga, <<Bangara, vei bu suveremua ao pani, za bike uke za na luluqu marene!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Totonai za batia i Jisu na kebokebona aza beto ko ria na tinoni Jiu qari tutia aza ba qari lukana tugu, nari za tadungana na mamata na bulona aza. ");
INSERT INTO ghn_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Beto za nanazaria i Jisu ria, <<Pae gamu vapaeni gamu za na kobukobuna i Lazarasi?>> za gua. Qari oe lao ria, <<Bangara, mae lame ko mu dogoria,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Za lukana i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nari qari paranga ria na tinoni Jiu, <<Dogoro! Za koi vei roquroqu vitivitigia aza i Lazarasi!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ba kaki ria za qari paranga, ari qari gua vei, <<Na tinoni nake batabatana tu ba za vabatabatai, ko bi boka gu vasarea aza pa uke i Lazarasi!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ego ko za maka vazaenga tadungana mule pa bulona i Jisu beto za lao pa bevi. (Ko na bevi aza za qari pateni maka patu lavata na ngujuna.) ");
INSERT INTO ghn_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Za garunuria i Jisu ria, <<Mu varijo pale za na patu,>> za gudi. Nari za paranga i Mata, aza na luluna na tinoni za uke, <<Koi Bangara, za tori nyabo omanga ikere tu. Koviria za tori ka made ranena tu zana!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Za parangia i Jisu aza, <<Ae vei, qa oqoro tu pojanigo ara za vei muna vazozoto nari za pala muna batia ao za na neqi lavatana tana Tamaza?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nari za qari varijo pale ria za na patu. Beto za enga zae pa noka i Jisu beto za paranga, <<Tamaqu, qa paranga leana ara tamu ura qu nongoroziu ara ao. ");
INSERT INTO ghn_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Qa gilagilaiqua za qu nongoroziu tugu doru totozo, ba koko vei gu ria na tinoni ari qari korapa za qa korapa paranga vei ari, ko mari vazozotoa za ao tugu qu garunuziu ara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pa liguna za beto paranga vei aza, nari za kuku viva, <<Lazarasi, mu votu lame!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nari za turu votu lame i Lazarasi, na limana na nenena za qari korapa tugu taudeni poko, beto za taude livutuni poko tugu za na izumatana. Za paranga laoria i Jisu ria, <<Mu ruvatia ko mi boka kenana,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ego ko na kubodi ria na tinoni Jiu, ria qari kamu bolai i Mere, za qari dogoria aza za roitini i Jisu, ko qari vazozotoa aza. ");
INSERT INTO ghn_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Goto kaki ria za qari mule tu vavakato vadi ria na Parese ko qari ule vadi aza vei za roitini i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nari qari nyumu tavitiria ria na kauniseli ria na Parese na kuta iama, ko ari qari gua vei ria, <<Na za tana roitini gita? Ura na tinoni ani za korapa roitidi kubo roiti vinagilagila! ");
INSERT INTO ghn_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Vei tana loi pale ko mina roiti tokatokai vei tugu zara aza, za pala doru tinoni mari vazozotoa aza, ko mari lame ria pa Romu ko mari jegaria za na nada ia beto na butubutu,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ba maka ria, na izongona i Kaiapasi aza na kuta iama lavata pa aoro aza, za ari za gudi vei, <<Kepore maka za bu gilagilai za gamu! ");
INSERT INTO ghn_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Gamuke gilagilai tu gamu za leana jola za maka tinoni mina uke vadi ria na tinoni, ko mike tapiara za na puku tinoni doruna?>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","(Ba na paranga za poja votuni aza za zake votu lame pa nana roquroqu makana, goto aza za na kuta iama lavata pa aoro aza ko za ulule votuni aza za i Jisu za mina uke vadi ria na puku tinoni Jiu za gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ba nake ria gu na puku tinoni Jiu makadi za mina uke vadi, goto vei ko mari tateku varikamu pa maka puku tinoni ria doru tinoni tana Tamaza qari nyanyala lao doru kota.) ");
INSERT INTO ghn_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ego ko za podalai pa rane aza za qari kukitini ko mari vaukea qari guni ria na tinoni matamata tadiria na tinoni Jiu i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ko za vei zara za zake rerege vakabekabere aza pa nana rererege pa Jiudia, goto za loia za na ia aza ko za laonana tu pa maka ia tata pa qega pa maka pikata guguzu na izongona pa Iparemi, ko ketakoi za suvere tavitiria ria na nana sepele. ");
INSERT INTO ghn_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ego za tata za na totozo vavolo Alokata tadiria na Jiu ko qari okoto taloloi pa dia guguguzu ria na tinoni ko qari zae pa Jerusalema, ko mari keni tavulaza totonai za oqoro kamu na vavolo aza qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ko qari kole nyaqoa ria i Jisu beto qari kole varivarinanaza totonai qari varikamu pa kakabarena zelepade, ari qari gua vei, <<Na za gamu roquroqua gamu? Gamuke rovea gamu mina kamu tugu beka somana pa vavolo aza?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","(Qari tori vanyumua tu ria na kuta iama beto ko ria na Parese za na garunu, ko ria na tinoni mari batia ketakoi za korapa suvere vei i Jisu za mari uleni ko mina taaru tamana aza qari gua.) ");
INSERT INTO ghn_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ego ko ka vonomo rane za kole beto mina kamua za na rane vavolo Alokata, nari za lao pa Betani i Jisu, pa guguzu za suvesuvere i Lazarasi, aza na tinoni za vaturu mulea pa uke. ");
INSERT INTO ghn_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ko ketakoi za qari roiti vani maka tekutekuna i Jisu. I Mata za somana vatanaia za na tekutekuna aza, beto ko i Lazarasi tugu za maka ria qari somana tekuteku tavitia i Jisu pa tevolo. ");
INSERT INTO ghn_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ego ko totonai za pogozo lameni i Mere za maka bogu oela peki beto na omanga leana jola za taroiti pa maka suvege nadi ko za zae jola na vaina. Za tekua aza za na oela aza ko za vuvani pa nenena i Jisu beto za puqa vapidilini na vurunguna. Ko na givorona na omanga leana na oela ani za pugelia na ruma. ");
INSERT INTO ghn_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nari za maka ria na sepele ti Jisu, i Jiudasi Isikarioti (aza na tinoni pala mina gabala kanai i Jisu), za ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","<<Ae za vei ko zake tavavaini za na oela ani? Bi boka tatekuni kue gogoto poata siliva ko bi tokadi ria na tinoni varivasevidi za na poata ani!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","(Ba za paranga vei zara i Jiudasi nake vei ko za roquroquria ria na tinoni varivasevidi za, goto na tinoni ikikona aza. Na baeke poata za aza za pogopogozia, ko koledia na totozo za pekipeki rarau gologolomia na poata.) ");
INSERT INTO ghn_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nari za ari za gua vei i Jisu, <<Mu loia, tari tu! Muke kotia ko mi tutini nana roquroqu aza za vatanani na ranena mana tagolomo ara. ");
INSERT INTO ghn_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ura ria na tinoni varivasevidi za pala munake beto izongoria gamu, goto ara za pala munake izongoziu lalaomiu gamu,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ego ko qari nongoroni ria maka minete tinoni lavata i Jisu za korapa ketakoi qari gua, nari za nake i Jisu gu makana za qari laoni, goto vei ko mari dogoria tugu vei i Lazarasi, aza za vaturu mulea pa uke i Jisu qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ko ria na kuta iama za qari kukitini ko mari vaukea tugu vei i Lazarasi qari gua, ");
INSERT INTO ghn_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ura pa ginuana aza za qari taloidia ria zoku tinoni Jiu ko qari vazozotoa i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ego ko za rane soga na kota, nari za qari nongoroni ria na minete tinoni qari varikamu pa vavolo Alokata za i Jisu za korapa luge lamelamenana pa Jerusalema qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nari za qari kaele tekuria na kaedi na suvege pamu ko qari votu lao gozogozoria aza ko qari kuku velavela, ari qari gua vei, <<Aroia! Za tamana aza za lame pana izongona na Bangara! na Bangara pa Izireli!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Za tekua i Jisu za maka dongiki ko za zaea, ko za gore votu aza vei za takuti pa Kutikuti Tabuna, ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","<<Muke matagutu, ao na guguzu pa Zaione! Dogoro! Na mua Bangara za korapa lame zana! Za zae pa maka tuni dongiki aza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","(Ria na zakazava ari za perangaina za qarike gilagilai na ginuana ria nana sepele, goto tonai za tori taovulu zae tu i Jisu za beto qari boka roquroqu kamua ria za na veveina gu aza za na kutikuti ari beto ko na zakazava ari za qari roiti laodi ria tana.) ");
INSERT INTO ghn_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ko ria na tinoni qari somana batia i Jisu tonai za kuku votuni pa bevi ko za vaturu mulea pa uke i Lazarasi za qari kole ululeni za na veveina aza. ");
INSERT INTO ghn_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ko za vei za ria na minete tinoni qari lame gozoria aza, ura qari tori nongoroni tu ria za na roiti vinagilagila za roitidi aza. ");
INSERT INTO ghn_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ko qari kole variparanga makadi ria na Parese, ari qari gua vei, <<Taqe batia za koviria? Kepore maka za taqe bokai za gita! Dogoro! Na kasia guguzu doruna za koviria za qari tutiadia aza,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ego kaki ria na tinoni Qiriki za qari somana zae vatarazae pa totozo vavolo Alokata. ");
INSERT INTO ghn_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ko ria za qari lao ti Pilipi (aza za maka tinoni pa Betiseda pa Qalili), ko ari qari guni vei, <<Bangara, gami za gami nyorogua dogoria i Jisu,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nari za lao i Pilipi ko za pojani i Aduru, ko ari kori qari makarai lao pojani i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nari za oeria i Jisu ria, <<Za tori kamu tu za na totozo ko mina tavalavata za na Tuna na Tinoni. ");
INSERT INTO ghn_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Zozoto pa zozoto ma pojadigamu ara za gamu: vei minake tavavuvuzu mae pa pezo ko mina uke mae tu za na kiko vuiti, nari za pala mina kole gu kolenana aza. Goto vei mina uke mae tu aza, nari za pala mina vua vazoku aza. ");
INSERT INTO ghn_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Na tinoni za roqua nana toa za pala mina saivia tugu aza, ba na tinoni zake rabekeni nana toa pa kasia guguzu ani nari za aza za pala mina kopuni nana toa ko mina kamua na toa jola. ");
INSERT INTO ghn_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Aza za nabuluniziu ara za mi tutiziu, ko ketakoi mana suvere ara za na qua nabulu ba mi suvere tugu. Aza za nabuluniziu ara za na Tamaqu tu mina valavatia aza,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Beto ari za gua vei mule i Jisu, <<Koviria na buloqu ara za mamata taduanga, ko na za mana gua ara? <Tamaqu, mu vasareziu pa totozo ani,> mana gua? Ba aza tugu za na ginuana qa lameni ara, ko mana gozoria tugu ara za na totozo vitigi ani. ");
INSERT INTO ghn_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tamaqu, mu valavatia nizongomu!>> za gua i Jisu. Nari za lagere vei pa noka za maka mamalaingi, ari za gua vei, <<Qa tori valavatia tugu ara aza, ko mana maka valavatia mutugu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nari za ria na minete tinoni qari korapa turu ketakoi ko qari nongoria na mamalaingi za qari paranga, <<Koi, na paka oka!>> qari gua. Goto ria kaki ari qari gua vei, <<Dai, maka mateana za parangia zana!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nari za oeria i Jisu ria, ari za gua vei, <<Nake pa ginuaqu ara za lame za na mamalaingi ani, goto pa ginuamiu tu gamu. ");
INSERT INTO ghn_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Koviria za na totozo tapitu tana kasia guguzu ani, ko koviria mina taadu votu za na bangarana na kasia guguzu ani. ");
INSERT INTO ghn_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Tonai mana taovulu zae vaiolo pa kasia guguzu ara, za pala mana vatata lameria ara taqu ria doru tinoni,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Tonai za paranga vei zara aza, nari za uleni aza za na zona vei beto mina uke aza.) ");
INSERT INTO ghn_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nari qari oe laoa ria na minete tinoni aza, <<Gami gami nongoroni pa Vavanau za na Karisito mina toa kamua na kamua. Ko ae za vei za pala mina taovulu zae vaiolo za na Tuna na Tinoni qu gua tu ao? I zei tu za na Tuna na Tinoni ani?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nari za oeria i Jisu ria, <<Iapeki totozo mule mina kole tadigamu za na kabere. Mu rerege tonai qu korapa izongia na kabere, ko na rodomo mike udegamu. Ura na tinoni za rerege pa rodomo za zake gilagilai ketakoi za lao vei aza. ");
INSERT INTO ghn_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ko tonai qu korapa izongia za na kabere za mu vazozotoa za na kabere, ko mu vei na tinoni za suvere pa kabere,>> za gua i Jisu. Ego pa liguna za paranga vei zara, nari za taloi keni suvere vapaenana i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Za tori roitidi tugu i Jisu pa moedi ria doru ria na roiti vinagilagila ari, ba qarike vazozotoa ria aza. ");
INSERT INTO ghn_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ko na korokorotai ti Aisea na tinoni korokorotai za gore votu gu aza ari za guni vei, <<Bangara, i zei za vazozotoa na mami ulule? Beto ti zei mina tadogoro za na neqi tana Bangara?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ko vei beto qarike boka vazozoto za aza tugu vei za pojai mule tugu i Aisea, ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","<<Zake tavabatabata na matadi beto za pate na bulodi, ko na matadi qarike boka dogodogoro beto na bulodi qarike vakoinonoa maka za ko qarike boka gabala mule lame taqu, goto bari vei ria za ba salanaria ara ria,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ari za pojaria i Aisea ura za batia na vinalavata tana Karisito ko za vei za vavakatoni na veveina aza. ");
INSERT INTO ghn_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Koledia tugu ria zokudi na tinoni matamata qari vazozotoa aza ba qarike ule votuni na dia vinazozoto, ura qari matagutudi ria na Parese keta mari taiju pale pa ruma varivarikamuna qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ura qari nyoroguani ria za na vinalavata tadiria na tinoni jolani na vinalavata tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ego beto za velavela votu i Jisu, ari za gua vei, <<Aza za vazozotoziu ara za nake ara gu za vazozotoziu aza, goto aza tugu za garunuziu vei ara. ");
INSERT INTO ghn_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Beto ko aza za batiziu ara, za batia tugu aza za garunuziu ara. ");
INSERT INTO ghn_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Qa tori lame vei tu na kabere tana kasia guguzu ara, ko ria doru qari vazozotoziu ara za marike suvere pa rodomo. ");
INSERT INTO ghn_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Na tinoni za nongororia na qua paranga ba zake kopudi, nari za nake ara qa pitua aza. Ura ara qake lame ko ma pitua na kasia guguzu qa gua, goto qa lame ko ma aloa tu na kasia guguzu qa gua. ");
INSERT INTO ghn_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Aza za dainananiziu ara beto zake teku vakataparia na qua paranga, za kolenana aza mina pitua aza. Na paranga qa tori pojai tu ara za aza tugu za mina pitua pa rane liguligu za na tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ura ara za qake vavakato pa qua neqi makaqu, goto aza tu na Tamaqu tu za garunuziu za aza tu za vaniziu na garunu ko na za mana pojai beto na za mana vavakatoni. ");
INSERT INTO ghn_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ko qa gilagilaiqua ara za na garunu tana za na toa jola. Ko ria na zakazava qa vavakatodi ara, za aza tugu za ule veini vaniziu na Tamaqu nari za aza tugu qa ule veini vadigamu za gamu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ego za kamua gu za na rane betobetona beto mina kamua za na rane vavolo Alokata, ko za gilagilai i Jisu za na aoa tana za kamua ko mina loia aza za na kasia guguzu ani ko mina mule lao aza tana Tamana. Za tori kole tu roquroqu vitivitigiria aza ria doru nana tinoni pa kasia guguzu qari vazozotoa, ko za roquroquria tugu tinganai za kamua na vinabetona. ");
INSERT INTO ghn_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ego qari varikamu ko qari makarai tekuteku i Jisu beto ria nana sepele. Ba na bangaradi na tomete za tori vavuvuzia tu pa bulona i Jiudasi, na tuna i Saimone Isikarioti, za na roquroqu ko aza za mina gabala kanai i Jisu za gua. ");
INSERT INTO ghn_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ko za gilagilainana i Jisu za na Tamana za tori vani vaokoto betoni tu aza za na neqi ko mina roitidi doru maka za, beto ko za gilagilainana aza za aza za na koko lame veina tana Tamaza beto ko za korapa mule lao tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ko za turu pa totozo tekuteku aza, za vagorea za nana koti, beto za piluni pa sikisikirina za maka puqapuqana. ");
INSERT INTO ghn_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Beto za vuva laoni pa maka jagi za kaki pie beto za podalai vuva taridi ko za loqaria za na nenedi ria nana sepele beto za puqa vapidilidi tugu na puqapuqana za piluni pa sikisikirina. ");
INSERT INTO ghn_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tonai za lame kamu ti Saimone Pita, nari za paranga i Pita, <<Koi, Bangara, ao muna loqaria tugu za na nenequ ara?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nari za oe i Jisu, ari za guni vei, <<Aza qa korapa roitini ara za ao quke gilagilai na ginuana koviria, ba pa liguligu tu pala muna gilagilai na ginuana,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Nari za paranga i Pita, <<Uu! Ara munake izongo loqaria tugu za na nenequ!>> za gua. Nari za oea i Jisu aza, <<Vei manake loqago ara ao, nari za kepore na iamu taqu ao,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Za paranga i Saimone Pita, <<Bangara, ego vei za nake nenequ gu makana, goto ria na limaqu beto na batuqu tugu vei ropi!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nari za parangia i Jisu aza, <<Na tinoni za tori iu tu za tori lioso tu ko pore laona mina iu ligu, goto na nenena gu za mina loqaria. Gamu doru za na liosomiu, goto maka gu za zake lioso,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Ura i Jisu za tori gilagilainana tu za na tinoni pala mina gabala kanai aza, ko za vei za ari za gua vei, <<Maka gu za zake lioso,>> za gua.) ");
INSERT INTO ghn_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ego ko pa liguna za loqa betoria aza za na nenedi ria nari za vazae sogai za nana koti beto za nyumu soga pa nana nyumunyumuna, beto za nanazaria, <<Ae vei gamu gilagilai tu na ginuana za aza qa koni roitini tadigamu ara? ");
INSERT INTO ghn_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Gamu gamu kukuniziu na <Tinoni Varivagigalai> beto na <Bangara> ara, ko gamu zotomiu tugu za tonai gamu gigala veiniziu aza, ura aza tugu ara. ");
INSERT INTO ghn_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ko vei ara, na miu Bangara beto na tinoni varivagigalai, za qa koni loqaria gu za na nenemiu, nari za pada vitivitigi gu za gamu mu variloqa lao lamedi na nenemiu. ");
INSERT INTO ghn_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Maka dogodogoro tutina za qa koni vadogorodigamu gamu, ko aza tugu qa roiti veini vadigamu ara, nari za gamu ba mu roitini tugu. ");
INSERT INTO ghn_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Zozoto pa zozoto ma pojadigamu ara za gamu: na pinauzu za zake poreveveina jolani na nana bangara, beto na tinoni pogozo nongoro za zake poreveveina jolani aza za garunia aza. ");
INSERT INTO ghn_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Gamu tori gilagilai tu gamu za na zakazava ari, ko muna tamana za gamu vei muna roitidi ria! ");
INSERT INTO ghn_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nake veveimiu gamu doru za qa korapa pojai ara. Ara qa gilagilariaqua za na uana tadiria qa mijataria. Ba mina gore votu tugu aza na paranga pa Kutikuti Tabuna, aza ari za gua vei, <Aza za somana nyapulu tavitiniziu na gequ bereti za taka liguziuni na kijukijulu nenena,> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Koviria qa korapa ule momoe vadigamu ara za ari tonai qari oqoro gore votu, ko tonai mina gore votu nari za muna vazozotoa za ara za aza. ");
INSERT INTO ghn_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Zozoto pa zozoto ma pojadigamu ara za gamu: aza za vakamua za maka tinoni qa garunia ara za za vakamuziu tugu ara, beto ko aza za vakamuziu ara za za vakamua tugu aza za garunuziu ara,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ego pa liguna za pojaria na zakazava ari, za mamata takulanga na bulona i Jisu ko za paranga lodaka zozoto gu aza, ari za gua vei, <<Zozoto pa zozoto ma pojadigamu ara za gamu: maka gamu za mina gabala kanaziu ara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nari qari kole varidogoro makadi ria na sepele, qari kole rurani i zei beka za guni aza qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Maka ria na sepele, aza za roquroqu vitivitigia i Jisu, za nyumu tata ti Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ego ko za ebo zaea i Saimone Pita aza, beto ari za guni vei, <<Mu nanazia moko, i zei za qu pojai ao, muguni moko,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nari za paranga aza na sepele za totoravuzu ti Jisu, ari za gua vei, <<Bangara, i zei za qu guni ao?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nari za oe lao i Jisu, <<Aza na tinoni mana notini na kipa bereti ko mana vani ara, za aza,>> za gua. Beto za tekua za na kipa bereti, ko za notini, beto za vani i Jiudasi, na tuna i Saimone Isikarioti. ");
INSERT INTO ghn_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ko aza tugu za tekua i Jiudasi za na bereti, za lugea gu i Setani aza. Nari za paranga lao ti Jiudasi i Jisu, <<Aza mu roitini qu gua, za mu siqarai roitini gu!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ba kepore tugu maka ria qari korapa tekuteku tavitia i Jisu bari gilagilai za na ginuana za paranga vei zara i Jisu tana. ");
INSERT INTO ghn_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","I Jiudasi za kopuni za na baeke poata, ko ria kaki sepele za qari rovea za palu i Jisu za garunia aza ko mi lao vairia kaki besa mari tekuria pa totozo vavolo Alokata beka, babi na iadi beka ria na tinoni varivasevidi beka qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ego ko aza tugu za tekua i Jiudasi za na kipa bereti, za votu keni gu. (Ko na bongi za totonai.) ");
INSERT INTO ghn_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ego ko pa liguna za taloi keni i Jiudasi, za ari za gua vei i Jisu, <<Koviria za tavalavata za na Tuna na Tinoni, beto ko za tavalavata tana za na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ko na vinalavata tana Tamaza za tori tabata tu tana, ko za vei za na Tamaza ba mina valavatia makana aza, ko nake zovaina beto mina valavatia gu na Tamaza aza. ");
INSERT INTO ghn_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ka viza qua koburu, nake zovaina mana kole suvere tavitigamu ara za gamu. Pala muna nyaqoziu, ba aza tugu vei qa tori pojadi tu ria na Jiu za ma pojadigamu mule za gamu: ketakoi qa korapa lao ara za gamu munake boka lao. ");
INSERT INTO ghn_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Maka garunu koregana za ma vadigamu gamu: mu makarai variroqu. Aza tugu qa roqu veidigamu gamu ara, za gamu ba mu makarai variroqu vei tugu makamiu. ");
INSERT INTO ghn_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Vei muna makarai variroqu gamu, za beto mari gilagilai ria doru tinoni za gamu za na qua sepele ara,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ego za paranga lao tana i Saimone Pita, <<Bangara, pae muna lao ao?>> za gua. Nari za oea i Jisu aza, <<Ketakoi qa korapa lao vei ara za gamu munake boka tutiziu koviria, ba liguligu tu pala muna tutiziu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Za oe lao i Pita, <<Bangara, ae za vei ko manake boka tutigo tu koviria? Ara za mana uke vanigo ao!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nari za oe lao i Jisu, <<Ao za muna uke vaniziu ara qu gua? Zozoto pa zozoto ma pojanigo ara ao: mina oqoro kiu na kokorako za ao muna tori kilu paleniziu tu kue totozo ara ao,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ari za gua vei i Jisu, <<Muke vatakulangaria na bulomiu gamu. Mu vazozotoa na Tamaza beto mu vazozotoziu ara. ");
INSERT INTO ghn_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Pa ruma tana Tamaqu za zoku jola ria na ia suvesuverena. Vei bike zozoto za bake pojadigamu na veveina ara ani, goto ara za koviria za ma lao vatana vadigamu maka ia za gamu. ");
INSERT INTO ghn_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ko pa liguna tu mana lao vatana vadigamu za maka ia aza, za beto mana mule lame ko mana toka laodigamu ketakoi qa suvere, ko ketakoi qa suvere ara za gamu ba muna suvere tugu. ");
INSERT INTO ghn_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ko ketakoi qa korapa lao vei ara za gamu gilagilaimiu na zona laona,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Za paranga lao tana i Tomasi, <<Bangara, gamike gilagilai gami za na ia ketakoi qu korapa lao vei ao. Ko ae mami vei mami gilagilai gami za na zona laona ketakoi?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Nari za oea i Jisu aza, <<Ara za na zona beto na zozoto beto na toa. Kepore za maka tinoni mina lao tana Tamaqu vei minake lame vei pana taqu. ");
INSERT INTO ghn_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Vei muna gilagilaziu ara, za pala muna gilagilai za na Tamaqu. Ko podalai koviria za gamu gilagilai aza beto gamu batia aza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Za paranga lao tana i Pilipi, <<Bangara, mu vabatidigami na Tamamu, beto za mina kamua gu za na padamami gami,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nari za oea i Jisu aza, <<Na beko tori totozo kakazana tu qa suvere tavitigamu ara za gamu, ba qu oqoro tu gilagilaziu ara ao, uve Pilipi? Aza za batiziu ara, za tori batia tugu za na Tamaqu. Ko ae za vei za qu paranga tu ao, <Mu vabatidigami na Tamamu,> qu gua? ");
INSERT INTO ghn_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Quke gilagilai tu ao Pilipi za ara za qa somana tana Tamaqu beto na Tamaqu za somana taqu? Na paranga qa pojadigamu ara za nake koko veidi taqu makaqu gu, goto na Tamaza tu za somana taqu za roitini nana roiti. ");
INSERT INTO ghn_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mu vazozotoa gu gamu za ara qa somana tana Tamaqu beto na Tamaqu za somana pana taqu. Ba vei munake vazozotoa na qua paranga, nari za mu vazozotoa tonai qu batiria ria na roiti ari. ");
INSERT INTO ghn_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Zozoto pa zozoto ma pojadigamu ara za gamu: aza za vazozotoziu ara za ria na roiti qa roitidi ara za mina roitidi, beto ko mina lavata joladi na roiti ari za mina roitidi aza, ura ara za qa korapa lao tana Tamaqu. ");
INSERT INTO ghn_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Beto ko aza muna tepai pa izongoqu ara za aza tugu za mana roitini, ko na Tamaqu mi tavalavata tana Tuna. ");
INSERT INTO ghn_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Doru maka za muna tepai taqu, za ara mana roiti vadigamu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Beto ari za gua vei i Jisu, <<Vei muna roquroquziu ara za gamu, nari za muna kopudi na qua garunu. ");
INSERT INTO ghn_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Beto ko mana tepai ara za na Tamaqu ko mina vadigamu maka varitokai, ko aza za mina suvere tavitigamu kamua na kamua. ");
INSERT INTO ghn_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ko aza za na Ongongu za kolea na zozoto. Na kasia guguzu zake boka izongia aza, ura zake batia beto zake gilagilai aza. Goto gamu za gamu gilagilaimiu aza, ura aza za suvere tavitigamu beto pala mina somana tadigamu. ");
INSERT INTO ghn_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Pala manake loi vanyata veidigamu ria kepore tinadi na tamadi ara za gamu, goto pala mana mule lame kamugamu tu. ");
INSERT INTO ghn_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Maka iapeki totozo mule beto na kasia guguzu za minake bati sogaziu ara, goto gamu pala muna batiziu ara, beto ko ara na toaqu ko gamu ba muna toa tugu vei. ");
INSERT INTO ghn_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Na ranena aza za gamu muna gilagilai za ara qa kole somana tana Tamaqu beto gamu gamu kole somana taqu, beto ara qa kole somana tadigamu. ");
INSERT INTO ghn_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Aza za izongoria na qua garunu beto za tutiria, za aza za roquroquziu ara aza. Ko na Tamaqu mina roquroqua aza za roquroquziu ara, beto ko ara ba mana roquroqua aza beto mana vatadogoroniziu makaqu tana,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Za paranga i Jiudasi (nake i Jiudasi Isikarioti za), <<Bangara, ko ae za vei za tadigami gu muna vatadogoronigo makamu ao, goto nake tana kasia guguzu?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nari za oea i Jisu aza, ari za guni vei, <<Aza na tinoni za roquroquziu ara, za kopudi na qua paranga, beto ko na Tamaqu mina roquroqua aza beto gami kori mami lame tana ko mami roitini na mami ia suvesuverena tana. ");
INSERT INTO ghn_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Aza zake roquroquziu ara, za zake kopudi na qua paranga. Beto na paranga qu nongororia qa pojaria ara za nake taqu, goto na nana tu na Tamaqu aza za garunuziu ara. ");
INSERT INTO ghn_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ria na zakazava ari za qa tori pojadigamu tu ara totonai qa korapa suvere tavitigamu. ");
INSERT INTO ghn_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ba na varitokai tu, na Ongu Tabuna, aza na Tamaqu mina garunu lagereni pa izongoqu ara, za mina vagigalaidigamu doru zakazava beto mina varoquroqu kamudigamu ria doru zakazava qa ule vadigamu ara. ");
INSERT INTO ghn_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Na bule za qa loi vadigamu gamu ara; na qua bule za qa vadigamu gamu ara. Nake pa zona za vatekudigamu na bule na kasia guguzu ani za qa vadigamu ara za na bule ani. Muke vatakulangaria na bulomiu beto muke matagutu. ");
INSERT INTO ghn_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Gamu tori nongoriamiu tu gamu za ari qa paranga veidigamu ara, <Mana taloi keni ara, ba pala mana lame gu tadigamu,> qa gua. Ko vei bu roquroquziu ara za bu qerani tu gamu za ara za pala mana lao tana Tamaqu, ura na Tamaqu tu za poreveveina jolaniziu ara. ");
INSERT INTO ghn_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ko koviria tu totonai za oqoro gore votu qa pojadigamu ara ani, ko tonai mina gore votu za mu vazozoto. ");
INSERT INTO ghn_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Manake parangagamu lalaoqua ara za gamu, ura na bangarana na kasia guguzu ani za korapa lamelamegana. Kepore mina aru veiniziu ara aza, ");
INSERT INTO ghn_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ba vei ko na kasia guguzu mi gilagilai za ara qa roquroqua na Tamaqu. Ko za vei za aza tugu vei za pojaniziu na Tamaqu za qa roitini ara. Aria, turu ko ta loia na ia ani,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ari za gua vei i Jisu, <<Ara za na suvege zozotona na qurepi, beto na Tamaqu za na tinoni umuma. ");
INSERT INTO ghn_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ria doru kaequ ara qarike vua za kaele paledi aza, goto ria doru kae qari vua za kabikabisi valiosoria ko mari boka vua valeana. ");
INSERT INTO ghn_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Gamu za gamu tavaliosoni na paranga qa tori pojadigamu tu ara. ");
INSERT INTO ghn_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mu togaza pana taqu beto ara ba mana togaza tadigamu. Na kaena na gazoro qurepi za zake boka vua tonai mina turu kale makana, goto mina togaza tugu pa kuta suvegena aza beto za mina vua. Ko za varitoto vei tugu aza za gamu ba munake boka vua vei munake togaza pana taqu. ");
INSERT INTO ghn_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ara za na suvegena na gazoro qurepi, goto gamu za na kakaena. Aza za togaza taqu beto ara qa togaza tana, za aza tugu za mina vua valeana. Ura kepore maka za muna bokai za gamu vei munake togaza pana taqu. ");
INSERT INTO ghn_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Aza zake togaza taqu za tagona votu vei pale maka kae suvege ko za ukenana. Ko na kae suvege vei zara za qari taboko varikamu ko qari tagona lao pale pa iku, ko qari tavato pale. ");
INSERT INTO ghn_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Vei muna togaza pana taqu za gamu beto na qua paranga mari togaza pana tadigamu, nari za aza gamu nyoroguani ko muna tepai za pala muna tekua tugu. ");
INSERT INTO ghn_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tonai muna qua sepele ara za gamu ko muna vua valeana, nari za tavalavata za na Tamaqu ara. ");
INSERT INTO ghn_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Maka moqaza vei na Tamaqu za roquroquziu ara, nari za ara ba qa roquroqugamu tugu za gamu. Ko mu togaza pa variroqu taqu. ");
INSERT INTO ghn_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Vei muna kopudi ria na qua garunu, nari za pala muna togaza pana qua variroqu za gamu, maka moqaza vei ara ba qa kopudi za na garunu tana Tamaqu ko qa togaza pa variroqu tana ara. ");
INSERT INTO ghn_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ria na zakazava ari za qa tori ule vadigamu tu gamu ara ko na qua qera mi kole tadigamu beto na qera tadigamu mi okoto valeana qa gua. ");
INSERT INTO ghn_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ani za na garunu taqu: Mu makarai variroqu za gamu maka moqaza vei tugu ara qa roquroqugamu za gamu. ");
INSERT INTO ghn_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kepore mutugu za maka variroqu za lavata jolani na variroqu tana tinoni za varivanani za nana toa ko za tokadi ria nana baere. ");
INSERT INTO ghn_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ko gamu za na qua baere ara vei muna roitidi ria qa garunudigamu ara. ");
INSERT INTO ghn_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Koviria za qake kukudigamu na pinauzu ara za gamu, ura na pinauzu zake gilagilai za aza za roitini na nana bangara. Ba koviria qa gigaladigamu na baere za gamu, ura ria doru zakazava qa nongororia tana Tamaqu za qa tori ule vadigamu tu za gamu. ");
INSERT INTO ghn_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nake gamu gamu mijataziu ara; goto ara tu za qa mijatagamu gamu beto qa udukugamu ko muna lao vua valeana, ko na vuamiu mi kole jola. Beto ko aza muna tepani na Tamaqu pa izongoqu ara za mina vadigamu tugu. ");
INSERT INTO ghn_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ko ani aza qa garunudigamu gamu: mu makarai variroqu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ari za gua vei i Jisu, Vei minake tavaraguadigamu na kasia guguzu, nari za mu gilagilai gu za ara mae tu za tori ke tavaraguaniziu tu. ");
INSERT INTO ghn_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Vei bi na nana na kasia guguzu za gamu, nari za na kasia guguzu bi roquroqu veidigamu na nana baere makana aza za gamu. Ba ura nake tana kasia guguzu za gamu, goto ara tu qa tori mijata kaledigamu tu pa kasia guguzu za gamu, ko za vei za zake tavaraguadigamu na kasia guguzu za gamu. ");
INSERT INTO ghn_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mu roqu vakoititia za na paranga qa tori pojadigamu tu: Kepore za maka pinauzu za poreveveina jolani za nana bangara. Vei mari komitiziu ara, nari za gamu ba mari komitigamu tugu; vei mari kopuni za na paranga taqu, nari za pala mari kopuni tugu za na paranga tadigamu. ");
INSERT INTO ghn_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ba ria na zakazava ari pala mari roiti laodi tugu tadigamu koko vei gamu gamu pogozia na izongoqu ara, ura qarike gilagilai ria aza za garunuziu ara. ");
INSERT INTO ghn_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Vei bake lame ko bake pojadi ara, nari za barike tagoreni ria za na dia sela; goto koviria za marike boka talegazani ria za na tinajutuna na dia sela. ");
INSERT INTO ghn_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Aza za zake tavaraganiziu ara za zake tavaraguani tugu za na Tamaqu. ");
INSERT INTO ghn_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Vei bake roitidi ara pana tadiria ria na roiti kepore mule maka tinoni bi tori roitidi mae tu, nari za barike tagoreni ria za na dia sela. Ba koviria za qari tori batiadia tugu ria qa roitidi ara, ba qarike tavaraguaniziu tugu ara beto na Tamaqu. ");
INSERT INTO ghn_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ba zara za vei za vei gu ko mi gore votu aza za takuti pa dia Vavanau, aza ari za gua vei, Qarike tavaragua goboroniziu ara, za gua. ");
INSERT INTO ghn_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Na varitokai, aza na Ongongu za kolea na zozoto beto za koko vei tana Tamaqu, za mina lame. Ara mana garunu lagere vadigamu koko vei tana Tamaqu aza, ko totonai mina lame za mina ululeni na veveiqu ara aza. ");
INSERT INTO ghn_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Beto ko gamu ba muna ululeniziu tugu ara, ura pa podapodalaina tu na qua roiti ara gamu podalai suvere tavitiziu ara za gamu. ");
INSERT INTO ghn_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ari za gua vei i Jisu, <<Ria na zakazava ari za qa tori ule vadigamu tu za gamu, ko gamu muke tatupe. ");
INSERT INTO ghn_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pala mari iju paledigamu pa ruma varivarikamuna za gamu, beto ko za korapa lame za na totozo tonai ria doru mari vaukegamu gamu za pala mari dogoro veini qari korapa roiti laoni maka roiti leana tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ko na roiti vei zara za mari roitidi ria ura qarike gilagilai ria za na Tamaqu beto ara. ");
INSERT INTO ghn_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ba ari ria na zakazava qa tori pojadigamu tu za gamu, ko tonai mina kamua za na totozo mari roiti vei ria za gamu muna roqu vakoititiria ria na paranga qa tori pojadigamu tu ara,>> za gua i Jisu. <<Ego na zakazava ari za qake oqanai pojadigamu ara pa podapodalaina, ura ara qa suvere tavitigamuqua gu za gamu. ");
INSERT INTO ghn_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ba koviria za ara qa korapa lao tana aza za garunuziu ara, ba kepore maka gamu bi nanazaziu, <Pae muna lao?> bi guniziu. ");
INSERT INTO ghn_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ba koviria tu qa ule vadigamu na zakazava ari ara, za pugelia na takulanga za na bulomiu gamu. ");
INSERT INTO ghn_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ba ma pojadigamu na zozoto ara za gamu: za leana jola tadigamu za ara mana taloi keni. Ura vei manake taloi keni ara, nari za na varitokai za minake lame tadigamu. Goto vei mana taloi keni ara, za beto mana garunu lagereni tadigamu ara aza. ");
INSERT INTO ghn_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ko tonai mina lame aza za mina udukuria ria pa kasia guguzu na veveina na sela, na veveina na tuvizi beto na veveina na varituti. ");
INSERT INTO ghn_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Qari selani ria za na veveina na sela, ura koko vei qarike vazozotoziu ara. ");
INSERT INTO ghn_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Qari selani ria za na veveina na tuvizi, ura qa korapa lao tana Tamaqu ko munake bati sogaziu ara. ");
INSERT INTO ghn_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Qari selani ria za na veveina na varituti, ura na bangarana na kasia guguzu ani za tori tapitu tu. ");
INSERT INTO ghn_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Qari zoku jola ria na zakazava qa oqoro pojadigamu ara, ba koviria za pala munake boka vakoititiria gamu ria. ");
INSERT INTO ghn_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ba tonai tu mina lagere aza, na Ongongu za kolea na zozoto, za mina toka laodigamu pa doruna na zozoto. Minake vavakatoni na nana makana aza, goto mina vavakatodi aza ria za nongorodi beto mina ule vadigamu ria na zakazava qari korapa lame. ");
INSERT INTO ghn_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Aza za mina valavataziu ara, ura pala mina teku vakarovo gu taqu beto za mina ule vadigamu za gamu. ");
INSERT INTO ghn_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Doruna za izongia na Tamaqu za taqu, ko za vei aza za qa parangani ara, <Na Ongu Tabuna pala mina teku vakarovo gu taqu beto za mina ule vadigamu za gamu,> qa guni ara,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ari za gua vei mule i Jisu, <<Pana maka iapeki totozo beto za munake batiziu ara, beto za pa maka iapeki totozo mule pa liguna aza beto za muna batiziu ara,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nari za kaki ria na nana sepele za qari kole varinanaza, <<Na za ginuana ani aza vei za pojadigita aza, <Pana maka iapeki totozo beto za munake batiziu ara, beto za pa maka iapeki totozo mule pa liguna aza beto za muna batiziu ara za,> guni aza? Beto ko na za ginuana aza, <Ara za qa korapa lao tana Tamaqu,> za guni aza? ");
INSERT INTO ghn_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ko na za ginuana aza <Maka iapeki totozo> za guni zana? Ura, ko gita ko ba taqeke gilagilai za aza za pojai aza!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ba za tori gilagilainana tu i Jisu za qari kole nyorogua nanazia ria aza, ko ari za gudi vei, <<Aza tugu na paranga qa pojai ara, <Pa maka iapeki totozo beto za munake batiziu ara, beto za pa maka iapeki totozo mule pa liguna aza beto za muna batiziu ara,> qa guni ara, za gamu korapa varinanazani gamu? ");
INSERT INTO ghn_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Zozoto pa zozoto ma pojadigamu ara za gamu: pala muna lukana na kebokebo za gamu, ba na kasia guguzu za mina qera. Gamu za muna takulanga, ba na miu takulanga mina peluku qera. ");
INSERT INTO ghn_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Totonai mi podopodo za gua za na reko za kolea aza za na takulanga, ura za kamua za nana totozo okotona. Ba pa liguna za tori vaporea tu aza za na koburu, nari za muma pale aza za na vitigi ura za qerani aza za maka tinoni za tori podo lame tu pa kasia guguzu. ");
INSERT INTO ghn_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ko gamu za koviria za kolegamu na takulanga, ba totonai mana maka dogoro ligugamu mule ara nari za na bulomiu za mina pugelia na qera, ko na qera aza za minake tateku varijo tadigamu. ");
INSERT INTO ghn_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ko pa rane aza za munake tepai maka za taqu za gamu. Zozoto pa zozoto ma pojadigamu ara za gamu: aza muna tepani na Tamaqu pa izongoqu ara za mina vadigamu tugu. ");
INSERT INTO ghn_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Za kamua koviria za gamu oqoro tepai maka za pa izongoqu ara za gamu; Mu tepa ko mu tekua, ko na miu qera mi okoto valeana,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Za paranga mule i Jisu, <<Ria na zakazava ari za qa tori ule vadigamu tu ara pa vavakato vavapada. Ba na totozo za korapa lame tonai manake ule vadigamu pa vavakato vavapada za gamu, goto pala mana ule lodalodaka vadigamu gu na veveina na Tamaqu za gamu. ");
INSERT INTO ghn_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Pa rane aza za gamu tu za muna tepa pa izongoqu ara za gamu; ara pala mana tepa vadigamu tana Tamaqu qake gua ara. ");
INSERT INTO ghn_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ura na Tamaqu makaqu za roquroqugamu za gamu. Za roquroqugamu aza ura gamu gamu roquroquziu beto gamu tori vazozotoa tu za ara na kokoqu tana Tamaqu ara. ");
INSERT INTO ghn_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Qa koko lagere vei tana Tamaqu nari qa lagere pa kasia guguzu ara, beto ko koviria mule za mana taloi pa kasia guguzu ani ko mana mule lao tana Tamaqu ara,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nari qari paranga ria na nana sepele, <<Dogoro! Koviria qu ulule lodalodaka ao, quke ulule pa vavakato vavapada. ");
INSERT INTO ghn_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Koviria gami vakabere valeania gami za ao qu gilagilai doru maka za, ko marike kilu nanazigo na tinoni beto muna gilagilaimua ao za na manugu qari rovea. Ko za vei aza za gami gami vazozotoa za na lame veimu tana Tamaza ao,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nari za oeria i Jisu ria, <<Ae vei, koviria gamu vazozoto? ");
INSERT INTO ghn_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Vainongoro ko! Na totozo za korapa lamelamenana, ko za tori kamu tu za koviria, tonai muna okoto nyanyalia na okoto miu kota mari veidigamu za gamu, ko muna loi vamakaziu ara. Ba ara za nake makaqu zozoto, ura na Tamaqu za korapa suvere tavitiziu ara. ");
INSERT INTO ghn_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ria na zakazava ari za qa tori pojadigamu tu ko pa miu kole maka taqu muna izongia gamu za na bule. Pa kasia guguzu pala muna gozoria na vitigi. Ba mu varene! Ara qa tori vakilasia tu za na kasia guguzu!>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ego pa liguna gu za beto paranga vei zara i Jisu, za enga zae pa noka beto ari za gua vei, <<Tamaqu, za tori kamu tu za na totozo. Mu valavatia na Tumu, ko na Tumu mi valavatigo ao. ");
INSERT INTO ghn_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ura qu tori vani tu ao na neqi aza ko mina lalaedi doru tinoni, ko mina vadi na toa jola ria qu tori iadi tu ao. ");
INSERT INTO ghn_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na toa jola ani: mari gilagilago ao, maka makai Tamaza zozotona, beto mari gilagilai tugu i Jisu Karisito, aza qu garunu lagereni ao. ");
INSERT INTO ghn_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ara qa tori valavatigo tu pa kasia guguzu tonai qa vaokotoria ria na roiti qu ianiziu ao ko qa roitidi. ");
INSERT INTO ghn_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ko koviria za, Tamaqu, mu valavataniziu pa moemu za na vinalavata qa tori somana izongo tavitinigo tu ao totonai za oqoro podaka na kasia guguzu. ");
INSERT INTO ghn_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Qa tori vabatidi tu ara tadiria na tinoni qu ia kale vaniziu ao pa kasia guguzu za na veveimu ao. Na mua ao ria, ba qu tori vaniziu tu ara ria, ko qari tori vataberia tu ria za na mua paranga. ");
INSERT INTO ghn_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ko koviria qari gilagilai ria za doru zakazava qu tori vaniziu tu ao za na koko lame veidi pana tamu. ");
INSERT INTO ghn_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Na nongoro qu vaniziu ao za qa tori pojadi tu ria, ko qari tori teku vazozotoa tugu beto qari gilagilai zozoto za na koko veiqu tamu ara, beto ko qari vazozotoa za ao tugu qu garunuziu ara. ");
INSERT INTO ghn_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ara za qa varavara tokadi ria. Nake kasia guguzu doruna za qa varavara tokadi ara, goto ria tu qu vaniziu ao za qa varavara tokadi ura ria tu za tamu. ");
INSERT INTO ghn_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ria doru qa izongoria ara za tamu, beto ria doru qu izongoria ao za taqu, ko tadiria qa tekuni ara za na vinalavata taqu. ");
INSERT INTO ghn_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Qa korapa ma mule lao tamu qa gua ara, ko manake suvere lalaoqua pa kasia guguzu, goto ria tu ari za mari suvere pa kasia guguzu. Tamaqu liosomu, mu kopudi pa izongomu aza qu vaniziu ara ria ari, ko mari kole maka maka moqaza podeke vei ao beto ara taqe maka. ");
INSERT INTO ghn_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Totonai qa suvere tavitiria za qa kopudi pa izongomu qu vaniziu ara za ari. Qa kopu vasareria ko kepore maka ria za bi muma goto aza tugu za taudukuni ko mina tanyuara za muma, ko za gore votu gu za na Kutikuti Tabuna. ");
INSERT INTO ghn_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Koviria za qa korapa mule lao tamu ara, ko qa korapa parangadi za ari totonai qa korapa suvere pa kasia guguzu, ko mari izongo vapugepugelia ria za na qua qera pa okokoto bulodi qa gua. ");
INSERT INTO ghn_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ara qa tori vadi tu ria za na mua paranga, ba na kasia guguzu za zake tavaraguadiria ria, ura ria za nake tana kasia guguzu, maka moqaza podeke vei tugu ara ba nake tana kasia guguzu. ");
INSERT INTO ghn_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Qake tepaigo ara ao ko mu varijo ioloria pa kasia guguzu ria, goto vei ko mu kopu vasareria tana kutana nikerena qa gua. ");
INSERT INTO ghn_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nake tana kasia guguzu ria, maka moqaza podeke vei tugu ara ba nake tana kasia guguzu. ");
INSERT INTO ghn_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mu vamadi ria pa zozoto; na mua paranga za na zozoto. ");
INSERT INTO ghn_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Maka moqaza podeke vei tugu ara ba qu garunu lameniziu pa kasia guguzu, nari za ara ba qa garunu laodi tugu pa kasia guguzu ria! ");
INSERT INTO ghn_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ko pa ginuadi ria za ara qa vamadi muleniziu makaqu, ko ria ba mari tavamadi tugu pa zozoto. ");
INSERT INTO ghn_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ba nake ria gu makadi ari za qa varavara tokadi ara, goto ria tugu vei qari vazozotoziu ara tonai qari ululeniziu ara ria ari. ");
INSERT INTO ghn_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Qa varavara ara ko ria doru za mari maka. Tamaqu, qa varavara ko mari kole tadigita kori ria. Maka moqaza vei tugu ao qu kole taqu beto ko ara qa kole tamu, nari za ria ba mari kole maka tadigita, ko na kasia guguzu mi vazozotoa za ao qu garunuziu ara. ");
INSERT INTO ghn_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ara za aza tugu na vinalavata qu vaniziu ao za qa vadi ria, ko mari maka maka moqaza vei tugu ao beto ara taqe maka. ");
INSERT INTO ghn_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ara za qa suvere tadiria beto ao taqu, ko mi okoto za na kole maka tadiria, ko mi gilagilai na kasia guguzu za ao qu garunuziu ara beto qu roquroquria ria maka moqaza vei tugu qu roquroquziu ara. ");
INSERT INTO ghn_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tamaqu! Ria qu tori valame vaniziu tu ao za qa nyorogudi ko mari suvere ketakoi mana suvere ara ko mari batia za na qua vinalavata, aza na vinalavata qu vaniziu ao. Qu vaniziu ao za na vinalavata ura qu roquroquziu totonai tu za oqoro taroiti na kasia guguzu. ");
INSERT INTO ghn_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tamaqu, ao na tuvizimu! Na kasia guguzu zake gilagilago ao, goto ara qa gilagilago, beto ko ria ari qari gilagilai za ao qu garunuziu ara. ");
INSERT INTO ghn_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Qa tori vagilagiladi tu ria za na veveimu ao, ko manake koroto tugu roiti veidi, ko aza qu roquroqu veiniziu ao ara za mari roquroqu veini za na goto tinoni, beto ko ara ba ma kole somana tadiria,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pa liguna za beto varavara vei ari i Jisu, za taloi tavitiria tugu ria na nana sepele ko qari karovia na lolomo nyonyola pie pa Kidoroni. Kolenana pa ia aza za maka inuma, ko i Jisu beto ria na nana sepele za qari lao ketakoi. ");
INSERT INTO ghn_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","(Ego i Jiudasi, aza na tinoni za gabala kanai aza, za tori gilagilainana tu za na ia aza, ura tori kubo totozo tu za i Jisu beto ko ria na nana sepele qari varikamu ketakoi.) ");
INSERT INTO ghn_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ko za tokaria i Jiudasi ria maka minete solodia beto ria kaki nabulu kopu tadiria na kuta iama beto na Parese, ko qari lao bola za pa inuma aza. Qari pogozia na juke, na juke ito beto na zakazava variperadi. ");
INSERT INTO ghn_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ba za tori gilagila betoria tu i Jisu ria doru zakazava mari taroiti lame tana, ko za rerege lao ko za nanazaria, <<I zei za gamu korapa nyaqoa gamu?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nari qari oe lao ria, <<I Jisu pa Nazareti,>> qari gua. Nari za paranga i Jisu, <<Ara za aza,>> za gua. (I Jiudasi na tinoni za gabala kanai aza za kole tugu turu tavitiria ria ketakoi.) ");
INSERT INTO ghn_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ko totonai <<Ara za aza>> za gudi i Jisu, nari za qari togolo mule ko qari lotudi tu pa pezo. ");
INSERT INTO ghn_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Beto za nanazaria mule i Jisu ria, <<I zei za gamu korapa nyaqoa gamu?>> za gua. Nari qari paranga ria, <<I Jisu pa Nazareti,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Nari za paranga i Jisu, <<Qa tori pojadigamu tugu za ara za aza. Ko vei ara gu za gamu korapa nyaqoziu gamu, nari za mu loi vakeniria ropi ria ari,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Zara za paranga vei aza ko mi gore votu aza za tori pojai tu aza, tonai ari za gua vei <<Qa oqoro valumua ara za maka ria qu vaniziu ao,>> za gua.) ");
INSERT INTO ghn_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ego za kole tugu pogopogozianana i Saimone Pita za maka benete, ko za unuzu votuni gu ko za maja teusu paleni za na talinga kale matuana na nabulu tana kuta iama lavata. (Na izongona na nabulu aza i Malakasi.) ");
INSERT INTO ghn_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nari za ari za guni vei i Jisu i Pita, <<Mu soba kura muleni pa nana kolekolena za na benete zana! Pala mana bukua tugu ara za na kapa vitigi za tori vaniziu tu ara na Tamaqu. Ae vei, quke gilagilai ao za vei aza?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ego ko qari aru tamania ria na minete solodia beto na dia tinoni matamata beto ko ria na nabulu kopu tadiria na Jiu i Jisu, ko qari piua na limana, ");
INSERT INTO ghn_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","beto qari toka laoni ti Hanasi mae. I Hanasi ani za na roana i Kaiapasi, aza na kuta iama lavata pa aoro aza. ");
INSERT INTO ghn_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","(Beto ko i Kaiapasi tugu aza za vavanauria ria na tinoni matamata tadiria na Jiu, ari za gudi vei, <<Za leana jola za maka tinoni gu bi uke vadi ria doru tinoni,>> za gua.) ");
INSERT INTO ghn_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ego i Saimone Pita beto maka goto sepele za qari tutia i Jisu. Maka sepele aza za na tagilagilana tana kuta iama lavata ko za luge tuti laoia i Jisu pa kakabarena na ruma tana kuta iama lavata, ");
INSERT INTO ghn_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","goto i Pita za kole turunana pa peguruna na atakamanana na bara. Ego beto za rerege votu lame aza na sepele na tagilagilana tana kuta iama lavata ko za lao parangia za na nabulu reko za kopu atakamana, ko za toka lugeni i Pita. ");
INSERT INTO ghn_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nari za paranga lao ti Pita za na reko nabulu za kopu atakamana, <<Nake ao tugu vei za maka sepele tana tinoni nari?>> za guni. Nari za paranga i Pita, <<Dai, nake ara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ego ko za lomozo za na kota, ko qari vatoai ria na nabulu beto ria na nabulu kopu za na iku naji, beto qari turu varilivutaini ko qari kole davangadia. Ko i Pita ba za lao tugu turu tavitiria ria ko za somana davanganana. ");
INSERT INTO ghn_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ego za nanazani na kuta iama lavata ti Jisu za na veveidi ria na nana sepele beto ko ria na nana varivagigalai. ");
INSERT INTO ghn_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Nari za oea i Jisu aza, <<Ara za qa tori paranga lodalodaka tu tana kasia guguzu. Ko ara doru totozo qa kole varivagigalai pa ruma varivarikamuna beto pa kakabarena zelepade gu, ketakoi qari varikamu ria na tinoni Jiu. Kepore tugu maka za ba peki poja golomia pa paena ara. ");
INSERT INTO ghn_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ko ae za vei za qu nanazaziu tu ara? Mu nanaza laoria tu ria na tinoni qari nongororia na zakazava qa pojadi ara. Dogoro! Ria qari gilagilaidia ria na paranga qa pojaria ara,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Totonai za paranga vei zara i Jisu za maka ria na nabulu kopu pa keketaina za tapalia aza beto ari za guni vei, <<Zara muna oe veini ao za na kuta iama lavata?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nari za oea i Jisu aza, Vei ba paranga vasela ara, nari za mu ule vadi tu ropi ria doru za na sela aza. Ba vei ba zotoqua gu ara, nari ae za vei ko qu poaraziu tu ara? za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ego ko za korapa tu tapiu kolena za garunu laoni mule i Hanasi ti Kaiapasi na kuta iama lavata i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ego i Saimone Pita za kole tugu turu davanganana makana ketakoi. Nari qari paranga laoa ria kaki aza, <<Nake ao tugu za maka sepele tana tinoni zana?>> qari gua. Ba za kilu pale mutugu i Pita, ari za gua vei, <<Dai, nake ara,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ba maka ria na nabulu tana kuta iama lavata aza na turana na tinoni za taqaza teusu pale na talingana i Pita za paranga votu, <<Goto ao zozoto tu za qa bati tavitinigo aza pa inuma akae?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nari za maka kilu pale mutugu i Pita aza, <<Dai tugu,>> za gua, beto za pa totozo tugu aza za kiu gu za na kokorako. ");
INSERT INTO ghn_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ego pa volavolaza lea za qari toka votuni pa ruma ti Kaiapasi i Jisu, ko qari toka laoni pa kakabarena na ruma tana qavuna. Ba ria na tinoni matamata tadiria na Jiu za qarike luge lao pa kakabarena na ruma tana qavuna, ura qarike nyorogua pajidia, keta marike boka tekua na vavolo Alokata qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ko i Paelati tu za votu kamuria pa peguru ria ko za nanazaria, <<Na sela za gamu jutuni gamu na tinoni ani?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Qari oe lao ria, <<Vei bike maka tinoni roroiti ikerena za na tinoni ani za babike toka lameni gami tamu zana,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Nari za ari za gudi vei i Paelati ria, <<Ego vei za mu toka kenini tu makamiu ko mu pitua pa miu Vavanau makamiu,>> za gudi. Ari qari gua vei ria na tinoni Jiu, <<Ba gamike tavamalumuni pana Vavanau ko mami vauke tinoni gami,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Tonai qari paranga vei zara za gore votu gu za aza za pojai perangaina i Jisu aza na veveina na uke mina uke vei aza.) ");
INSERT INTO ghn_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nari za mule luge pa nana ruma i Paelati beto za kukua i Jisu ko za parangia, <<Ao za na bangara tadiria na tinoni Jiu?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nari za oe i Jisu, <<Ae vei, na mua gu makamu za na nanaza aza, ba ria kaki qari pojanigo za na veveiqu ara?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Za oe i Paelati, <<Ae vei, na tinoni Jiu ara ko qu nanaza veiniziu zara? Ria tugu na mua puku tinoni makamu ao beto ko ria na kuta iama za qari toka lamenigo taqu pani. Ko na za tu qu roitini ao?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nari za paranga i Jisu, <<Na binangara taqu za nake koko veina tana kasia guguzu ani. Vei bi tana kasia guguzu za na binangara taqu, za ria na qua nabulu kopu bari varipera viviva, ko barike aru tamanaziu ria na matamata tadiria na tinoni Jiu ara. Ba ura na qua binangara nake tana kasia guguzu ani,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nari ari za guni vei i Paelati aza, <<Ko maka bangara tugu ao, akae?>> za gua. Nari za oe lao i Jisu, <<Ao qu pojai za ara za maka bangara. Aza qa podoni ara beto ko qa lagereni ara pa kasia guguzu ani za vei ko ara mana uleni za na veveina na zozoto. Ko ria doru tinoni qari kole vei pa zozoto za qari vainongoro lame taqu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Za paranga lao i Paelati, <<Na za za na zozoto?>> za gua. Pa liguna za paranga vei zara, za votu pa peguru tadiria na tinoni Jiu i Paelati ko ari za gudi vei, <<Qake batia ara za maka ginugua selana bi boka tajutuni aza. ");
INSERT INTO ghn_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ba aza vei za kole pa miu tututi za ara mana boka ruvata vadigamu maka tinoni tapiuna pa totozo vavolo (Alokata). Ko ae vei, gamu nyoroguani ko ma ruvata valao vadigamu za na bangara tadiria na Jiu?>> za gua i Paelati. ");
INSERT INTO ghn_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nari qari maka kuku velavela tu ria, <<Dai, nake aza! I Barabasi tu za gami nyoroguani gami!>> qari gua. (I Barabasi za na tinoni raja ikikona.) ");
INSERT INTO ghn_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ego ko za teku varijo vadi i Paelati i Jisu ko qari piqopiqolo vitivitigi paleni ria na solodia. ");
INSERT INTO ghn_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Beto qari viri vadidolaia ria na solodia za maka vasuvasu bangara varivariokana ko qari vasobani pa batuna, beto qari vazaeni na poko davalana. ");
INSERT INTO ghn_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Beto qari kole lalao paraparanga veini ari, <<Mi toa vakakaza tu za na bangara tadiria na tinoni Jiu!>> qari gua. Beto ko qari vanivani na tapala aza. ");
INSERT INTO ghn_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Beto za votu soga mule tadiria na minete tinoni i Paelati ko za paranga, <<Dogoro! Koviria mana toka votuni ara tadigamu aza, ko gamu mu batia za ara qake batia maka ginugua tana vei bi tajutuni aza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ko za votu lame i Jisu, za korapa tugu vazazaeria nana za na vasuvasu bangara varivariokana qari vasobani beto na poko davalana. Beto za parangaria i Paelati ria, <<Zana za na tinoni!>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ego aza tugu qari batia ria na kuta iama beto na nabulu kopu aza, nari za qari kuku velavela, <<Vaukea pa korosi! Vaukea pa korosi!>> qari gua. Za paranga laoria i Paelati ria, <<Gamu tu mu titai ko mu vaukea pa korosi! Ura ara za qake izongo batia maka ginugua vei bi tajutuni aza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Qari oea ria na tinoni Jiu aza, <<Gami za kolenana za na mami Vavanau ko pa mami Vavanau za pada mina uke tugu aza, ura za poja tarini na Tuna na Tamaza makana aza,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ko totonai za nongororia i Paelati zara qari gua vei ria, za matagutu tugu lalaonana za totonai. ");
INSERT INTO ghn_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ko za maka mule luge mutugu pa nana ruma qavuna ko za nanazia i Jisu, <<Pae na tinonimu ao?>> za guni. Ba zake pavu oea i Jisu aza. ");
INSERT INTO ghn_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nari za parangia i Paelati aza, <<Ae za vei ko quke oeziu ara ao? Quke gilagilai ao za ara gu qa izongia za na neqi ko mana boka ruvatigo beto mana boka vaukego pa korosi ao?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nari za oea i Jisu aza, <<Na neqi muna boka varoiti lameni ao taqu za nake mua neqi makamu ao, goto na Tamaza gu pa nulu za vanigo. Ko na sela tana tinoni za valameziu ara tamu za ikerena jolani na sela tamu,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Totonai za nongoria i Paelati zara za gua vei aza, za nyaqoa aza za na zona ae vei ko bi ruvatia aza i Jisu za gua. Ba qari kole tugu kuku velavela ria na tinoni Jiu, Vei muna ruvatia ao aza, za nake baere ti bangara Siza ao! Ura na tinoni za vavabangara muleni makana za na kana tana bangara Siza aza! qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ego ko totonai za nongororia i Paelati za na paranga ari, nari za toka votuni aza i Jisu, ko za lao nyumu pa nana nyumunyumuna varivaritutina pa ia za tasapeni patu (qari gigalani Qabata pa paranga Aramaiki). ");
INSERT INTO ghn_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","(Ego ko za kamua gu za na rane vatana na vavolo Alokata, ko za tata korapa rane za totonai.) Ko za parangaria i Paelati ria na tinoni Jiu, <<Dogoro! Zana za na miu bangara!>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nari qari kuku velavela ria na tinoni, <<Toka vakenia! Toka vakenia! Vaukeagana pa korosi aza!>> qari gua. Za nanazaria i Paelati ria, <<Ae za vei ma vauke pale pa korosi za na miu bangara?>> za gua. Qari oe ria na kuta iama, <<Gami za kepore mule na mami bangara, goto i Siza gu!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ego ko za loi lao vadi i Paelati i Jisu ko ria mari vaukea pa korosi za gua. Nari qari teku vakarovia ria i Jisu, ");
INSERT INTO ghn_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ko qari vapogozoni na nana korosi makana beto za votu lao pa maka ia qari kukuni na Batu Tomete (pa paranga Aramaiki na izongona za Qoloqota). ");
INSERT INTO ghn_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ketakoi za qari pata vatitia pa korosi ria aza. Ko kori tinoni za qari pata vatitidi mutugu pa dia korosi pa kori kalena i Jisu, goto i Jisu pa korapa. ");
INSERT INTO ghn_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ko za kutia i Paelati za maka kutikuti beto za varamatia pa korosi keta pa batuna, ko ari za gua vei za na kutikuti: I JISU PA NAZARETI, NA BANGARA TADIRIA NA JIU! ");
INSERT INTO ghn_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ko na kubo tinoni Jiu qari tiroa za na kutikuti aza, ura na ia aza ketakoi qari pata vatitini pa korosi i Jisu ria za zake zou pa guguzu lavata beto ko na kutikuti za takuti pa paranga Aramaiki, pa Latini, beto pa Qiriki. ");
INSERT INTO ghn_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nari qari paranga laoa i Paelati ria na kuta iama, <<Muke kuti veini NA BANGARA TADIRIA NA JIU, muke gua, goto ari tu mu gua vei, <NA TINONI ANI ZA ARI ZA GUA VEI: ARA NA BANGARA TADIRIA NA TINONI JIU! ZA GUA,> mu gua tu,>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Za oe lao i Paelati, <<Na za qa tori kutia tu ara za mina takuti kolenana tugu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ego pa liguna qari vatitia pa korosi i Jisu ria na solodia, za qari tekua za na nana poko koti ko qari jiraka madea beto qari okoto makaria ria na solodia za ka made jirakadi ari, beto ko qari tekua tugu vei za na nana poko gojo doru. (Na poko gojo doru ani za nake tapitina za podalai pa batuna ko za gore kamu pa uquna.) ");
INSERT INTO ghn_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Beto qari kole variparanga ria na solodia, <<Take rikatia za na poko ani. Goto ta gonani na patu mijamijata ko ta gilagilai i zei za mina tekua,>> qari gua. Ko zara qari roiti veini aza, ko za gore votu za aza vei za tori pojai tu na Kutikuti Tabuna ari za gua vei, <<Qari varijirakani ria za na qua poko, beto ko qari gonani patu mijamijatana za na qua poko gojo doru,>> za gua. Ko ria tugu na zakazava ari za qari roitidi ria na Solodia. ");
INSERT INTO ghn_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ego ko qari korapa tugu turu tatadia pa korosi qari vatitini i Jisu ari Mere na tinana, beto na taina reko tugu i Mere, beto i Mere na maqotana i Kolopasi, beto ko i Mere na lame veina pa Magadalene. ");
INSERT INTO ghn_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ko za dogoro lao za gua i Jisu ko za batia za na tinana beto aza na sepele za roquroqu vitivitigia aza za korapa tugu turu ketakoi, nari za paranga lao tana tinana i Jisu, <<Tinaqu, dogoro! Aza za na tumu marene,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Beto za paranga laoa na sepele, <<Dogoro! Aza za na tinamu,>> za guni. Ko podalai gu totonai za tokai na sepele za na tinana ko za lao suvere pa ruma tana sepele aza. ");
INSERT INTO ghn_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ego ko za gilagilai i Jisu za doru zakazava za qari okoto valeana beto za koviria, ko vei ko mi gore votu za na Kutikuti Tabuna za gua, nari za paranga, <<Qa kidepe,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kolenana tugu ketakoi za maka jaqi za pugelia na kolo vaini pazana, ko qari tekua za maka poko puqapuqana ko qari vatubuluni na vaini aza beto qari vatogazani pa uquna na kolu hizopi ko qari jotini pa beruberuna i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ko pa liguna za bukua i Jisu za na vaini, za ari za gua vei, <<Za tori okoto zozoto tugu!>> za gua. Beto za vatiti gorea za na batuna ko za loia za na singo. ");
INSERT INTO ghn_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ego na rane vatana za na rane aza, ko na ligunana na rane aza za na rane Minyere aza na rane poreveveina jola. Ko zake tanyorogua za totonai mina kamua za na rane Minyere za bari korapa titi jola pa korosi na tinidi ari kue qari gua ria na tinoni Jiu. Ko qari lao tepa vinamalumu ti Paelati ria na matamata tinoni Jiu, ko bari poe paledi na nenedi ari kue beto ko bari tateku vagore pa korosi qari gua. ");
INSERT INTO ghn_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ko qari lao ria na solodia ko qari poe paledi za na nenena na tinoni momoe, beto vei tugu aza maka ari kori qari vatiti tavitini i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Goto totonai qari lame kamua i Jisu nari za qari batia za tori uke tu aza, ko qarike poe ria na nenena. ");
INSERT INTO ghn_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ba maka ria na solodia za tekua za na opere ko za qata laoni maka kale sikisikirina ko za nyoa votu za na orungu beto na kolo. ");
INSERT INTO ghn_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Ko aza na tinoni za batia zozoto na roiti vei za taroiti ani za korapa ululeni ani, ko gamu mu vazozoto za gua. Ko na ulule tana za na zozotona beto za gilagilainana aza za parangani na zozoto aza.) ");
INSERT INTO ghn_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Za taroiti vei zara, ko za gore votu za na Kutikuti Tabuna, ari za gua vei, <<Kepore maka pudapudana za bi tapoe,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Beto ko kolenana mule za maka kutikuti pa Kutikuti Tabuna ari za gua vei, <<Mari batia ria na tinoni aza qari qatani na opere,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pa ligudi na roiti ari, za lao i Josepa, na tinoni pa Arimatia, ko za tepani ti Paelati za na kobukobu tinina i Jisu. (I Josepa za maka sepele tugu ti Jisu aza ba za suvere gologolomo, ura za matagutudi na matamata tadiria na tinoni Jiu.) Ko za vamalumia i Paelati nari za lao ko za pogozia za na kobukobuna i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Beto ko i Nikodimasi tugu vei, aza na tinoni za lao dogoria i Jisu na bongi, za tutia i Josepa, ko za pogozia aza za na vuva tini za taroiti pa moa beto na aloe, na padana uengavulu kilo na mamatana. ");
INSERT INTO ghn_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ko qari teku vagorea ari kori za na kobukobu tinina i Jisu ko pa liguna qari vavuvuzu tarini na mereseni omanga lea nari za qari udeni na poko lineni. Qari ude veini tugu qari tututi vei ria na tinoni Jiu totonai qari vatanani na kobukobu tini tinoni beto mina tagolomo. ");
INSERT INTO ghn_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Za kolenana za maka inuma za tata gu ketakoi qari vatitini i Jisu pa korosi, ko maka bevi korega za pa inuma ketakoi, oqoro pore maka tinoni ukena bari vakoleni. ");
INSERT INTO ghn_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ko ketakoi qari lao vakolea za na kobukobu tinina i Jisu, ura za tata gu ketakoi za na bevi aza, beto ko na rane vatana tadiria na Jiu za totonai ura za tata na rane Minyere. ");
INSERT INTO ghn_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ego na volavolaza rorodomo oqoro kabere pa rane momoe pana vuiki, za munu lao pa bevi i Mere na reko pa Magadalene, ko za dogoro lao za gua nari za tori tavatitolo rijo tu za na patu patena na ngujuna na bevi. ");
INSERT INTO ghn_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nari za abutu mule lao ti Saimone Pita beto tana maka sepele aza za roquroqu vitivitigia i Jisu aza, ko ari za gudi vei, <<Qari tori teku vakeni paleni tu pa bevi na Bangara, ko gamike gilagilai pae qari vakoleni,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nari qari taloi ko qari lao pa bevi ari Pita beto na sepele aza. ");
INSERT INTO ghn_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Qari makarai abutu lao ari kori, ba za abutu valiguligu paleni na sepele aza i Pita ko za lao kamu momoe pa bevi. ");
INSERT INTO ghn_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ko za opo oviki luge pa bevi za gua aza, nari za batia za na poko lineni gu aza qari udeni na kobukobu tinina aza, ba zake luge lao pa leo bevi aza. ");
INSERT INTO ghn_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nari za tuti liguligu kamu i Saimone Pita, ko za luge jola lao pa leona na bevi. Ko za batia tugu za na poko lineni galegale gu za korapa kole ketakoi, ");
INSERT INTO ghn_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","beto ko aza na poko qari pikoni pa batuna. Na poko piko batu aza za zake kole tavitia za na lineni, goto za tavijongo beto ko za kole kalenana tu. ");
INSERT INTO ghn_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ego beto za luge tuti lao aza na sepele za kamu momoe pa bevi, ko za batia nari za vazozoto. ");
INSERT INTO ghn_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Ura qarike gilagila kamua ria aza na kutikuti pa Kutikuti Tabuna za pojai pala mina turu mule tugu pa uke aza za gua.) ");
INSERT INTO ghn_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ego beto za qari muledia pa dia ruma ria na sepele. ");
INSERT INTO ghn_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ba i Mere za kole tugu turu lukalukana nana pa peguruna na bevi. Ko totonai za korapa tu lukalukana nana za opo oviki luge pa leo bevi, ");
INSERT INTO ghn_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","nari za batiria za kori mateana qari pokopoko keala, qari korapa nyumudia ketakoi qari vakoleni na tinina i Jisu, maka keta pa kale batuna maka pa kale nenena. ");
INSERT INTO ghn_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nari qari nanazia ari kori, <<Siu, ae za vei ko qu korapa tu lukana ao?>> qari gua. Nari za oe lao i Mere, <<Qari tori teku varijo keni pale tu za na qua Bangara, ko qake gilagilai pae qari vakoleni!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Beto za balinga gu za gua nari za batia i Jisu za korapa tugu turu nana ketakoi; ba zake dogoro gigalia i Mere i Jisu tugu aza. ");
INSERT INTO ghn_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Za nanaza lao tana reko i Jisu, <<Siu, ae vei ko qu korapa lukana tu ao? I zei za qu korapa nyaqoa ao?>> za gua. Nari za roquroqua i Mere za palu na tinoni roiti pa inuma aza za gua, ko za paranga veini ari, <<Bangara, vei ao bu pogoso varijoa aza, nari za mu ule vaniziu ketakoi qu vakoleni ko ma lao tekua,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Za paranga lao tana i Jisu, <<Mere!>> za gua. Za balinga lao tana i Mere beto za paranga laoia pa paranga Aramaiki, <<Raboni!>> za gua. (Na ginuana Raboni za na Tinoni Varivagigalai.) ");
INSERT INTO ghn_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Za paranga lao tana i Jisu, <<Muke uliziu, ura qa oqoro mule zae tana Tamaqu ara. Goto mu lao tadi ari ka viza taiqu ko ari muna gudi vei, <Ara qa korapa mule lao tana Tamaqu beto na Tamamiu tugu gamu, na qua Tamaza beto na miu Tamaza tugu vei gamu ara,> muna gudi,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nari za mule keni vavakato tadiria na sepele i Mere pa Magadalene, ari za gua vei, <<Ara qa batia za na Bangara!>> za gua, beto za ule vadi na paranga za pojaria i Jisu pana tana. ");
INSERT INTO ghn_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ego na veluveluna tugu na rane momoe pa vuiki aza, za qari varikamu ria na sepele ko qari pate loka takoria pa maka lose, ura qari matagutudi ria na matamata tadiria na Jiu. Nari za kamu turu pa varikorapaidi i Jisu, ko ari za guadi, <<Na bule mi somana tadigamu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ko pa liguna za paranga vei zara aza, za vabatidi za na limana, beto na sikisikirina. Ko totonai qari batia ria za na Bangara za qari qeraqera vitivitigi. ");
INSERT INTO ghn_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nari za ari za gudi vei mule i Jisu ria, <<Na bule mi somana tadigamu. Maka moqaza vei tugu na Tamaqu za garunuziu ara, nari ara ba qa garunugamu tugu za gamu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pa liguna za paranga veidi zara, za singo lao tadiria, beto ari za gua vei, <<Mu tekua za na Ongu Tabuna. ");
INSERT INTO ghn_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ria muna taleozodi gamu na dia sela za mari taleozo tugu ria, goto ria munake taleozodi gamu ria za marike taleozo tugu ria,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ego i Tomasi (aza za tavaizongo i Patavivi), maka ari ka manogori sepele tana, za zake somana suvere perangaina totonai za kamu votu tadiria i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ko qari kole vavakato vani ari ka viza sepele aza, <<Gami batia za na Bangara,>> qari guni. Ba ari za gudi vei i Tomasi ria, Vei manake batiria mae na buridi na pata pa limana, ko manake totuni karukarusuqu mae za ketakoi qari suni na pata, beto manake aruni limaqu mae za na kale sikisikirina, za manake izongo vazozoto tugu ara, za gua. ");
INSERT INTO ghn_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ego ko pa vinavesu rane nari za qari varikamu mule pa maka lose ria na sepele, ko totonai za somana suvere tavitiria i Tomasi. Ko korapa tugu pate vamauruna za na atakamana, za kamu turu pa varikorapaidi i Jisu, beto ari za gua vei, <<Na bule mi somana tadigamu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Beto ari za guni vei i Tomasi, <<Ego, mu totu lameni na karukarusumu pa buri pa limaqu, beto mu dogoro viloto valeanaria na limaqu, beto mu kaqama lameni na limamu ko mu ulia za na kale sikisikiriqu. Mu nogoto vasekeseke ko mu vazozoto!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nari za oe i Tomasi, ari za gua vei, <<Na qua Bangara beto na qua Tamaza!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Za paranga lao tana i Jisu, <<Ae vei qu batiziu gu za qu vazozoto? Mari tamana ria qari oqoro batiziu ara, ba qari vazozoto!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ego totonai za korapa suvere tavitiria i Jisu ria na nana sepele, za na kubo jola ria na roiti vinagilagila za roitidi i Jisu ba qarike takuti pa buka ani. ");
INSERT INTO ghn_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Goto ari gu za qari takuti, ko mu vazozotoa gamu i Jisu tugu za na Karisito, na Tuna na Tamaza, ko pa miu vazozotona aza, za muna tekua gamu za na toa jola. ");
INSERT INTO ghn_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pa liguna ari nari za bola votu mule tadiria na nana sepele pa ovuku Tiberiasi i Jisu, ko ari za vei aza totonai za bola votu tadiria. ");
INSERT INTO ghn_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Qari korapa tugu makarai suveredia ari Saimone Pita, i Tomasi (aza qari kukuni i Patavivi), i Nataniela (aza na lame veina pa Kena pa guguzu Qalili), beto ria na tuna marene i Jebeti, beto ko ari kori goto sepele mule ti Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nari za paranga laoria i Saimone Pita, <<Koi, ara ma keni tu abuqua,>> za gudi. Qari paranga ria, <<Gami ba mami tutigomami tugu ao,>> qari guni. Ko qari lao zae pa maka koaka ko qari keni, ba pa bongi lavata aza za kepore zozoto maka za bari tekuadia. ");
INSERT INTO ghn_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ko na volavolaza za gore turu pa poanana i Jisu, ba qarike dogoro gigalia ria na sepele i Jisu aza. ");
INSERT INTO ghn_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Beto za paranga laoria i Jisu ria, <<Boko marene, gamu abua tu kaki igana?>> za gua. Qari paranga lao ria, <<Qokolo, ko kepore tu!>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nari ari za gudi vei, <<Ego, mu ipani keta pa kale matuana na koaka za na vaqara, beto pala muna batia,>> za gua. Nari qari ipani za na vaqara qari gua nari za beto qarike boka vaiolia za na vaqara, ura za koi vei pugelia na igana. ");
INSERT INTO ghn_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nari za paranga lao ti Pita za na sepele za roquroqu vitivitigia i Jisu, <<Qokolo, na Bangara zana!>> za guni. Ego ko aza tugu za nongoria i Saimone Pita za na Bangara zana za gua tugu aza, za piluni gu za na nana poko koti (ura za vagore pale totonai qari kole abu), ko za tuluzu oqa gore pa kolo. ");
INSERT INTO ghn_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Goto ria na sepele qari suvere jola pa koaka za qari qelu gore pa pezo, ko qari kaoa za na vaqara za pugelia na igana. Ura qarike zou pa paroparona ria, pada maka gogoto vakaza gu na zouna. ");
INSERT INTO ghn_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ko totonai qari tete paro pa pezo, za qari batia za maka noara iku za akea na igana beto kaki bereti. ");
INSERT INTO ghn_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Za paranga lao ria i Jisu ria, <<Mu pogozo lamedi kaki igana gamu koni tekuria,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nari za lao zae soga pa koaka i Saimone Pita, ko za ragata vaparoa za na vaqara za pugelia na igana lavalavata, na ngutidi za maka gogoto limangavulu kue ria doru. Qari kubo jola za na igana, ba zake tarikata tugu za na vaqara. ");
INSERT INTO ghn_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Za paranga laoria i Jisu ria, <<Mae, lame ko mu tekuteku,>> za gudi. Ba kepore maka ria na sepele za bi varene ko bi nanaza, <<I zei ao?>> bi guni, ura qari tori gilagilai tu za na Bangara tugu aza. ");
INSERT INTO ghn_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Za lao i Jisu ko za tekua za na bereti ko za vadi, beto za roiti veini mutugu za na igana. ");
INSERT INTO ghn_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ko ani za na totozo vinaue za bola votu i Jisu tadiria na nana sepele pa liguna za turu mule pa uke. ");
INSERT INTO ghn_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ego pa liguna qari beto tekuteku ria, nari za paranga lao ti Saimone Pita i Jisu, ari za gua vei, <<Saimone, na tuna i Jone, ae za vei, qu roquroquziu joladi ria ari ara ao?>> za guni. Za oe lao i Pita, <<E, Bangara, ao qu gilagilaziumua za qa roquroquigo tugu ara ao,>> za gua. Za paranga i Jisu, <<Mu kopudi na qua lami,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Za paranga lao mule na vinaori totozo tana i Jisu, <<Saimone, na tuna i Jone, ae vei qu roquroquziu tugu ara ao?>> za guni. Za oe lao i Saimone, <<E, Bangara, ao qu gilagilaziumua qa roquroqugo tugu ara ao,>> za gua. Za paranga i Jisu, <<Mu kopudi na qua sipi,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Za paranga lao mule na vinaue totozo i Jisu, <<Saimone, na tuna i Jone, qu roquroquziu tugu ara ao?>> za gua. Nari za takulanga i Pita, ura za nanazia kue totozo i Jisu aza, ari za guni vei, <<Qu roquroquziu tugu ara ao?>> za guni. Ko za paranga laoa aza, <<Bangara, doru zakazava za ao qu gilagilariamua; ko qu gilagilaziumua ao za ara qa roquroquigo tugu ao!>> za gua. Za oe lao i Jisu, <<Ego, mu vatekutekuria na qua sipi. ");
INSERT INTO ghn_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Zozoto pa zozoto ma pojanigo ara ao: totonai na koburumu za qu doko mulenigo na beleti, ko qu lao ketakoi qu nyorogua lao. Ba totonai muna baragozo ao, za pala muna kaqamadi na limamu beto ria kaki tu mari dokonigo na beleti beto mari toka laonigo ketakoi quke nyorogua lao vei ao,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Pa nana paranga vei ani za uleni i Jisu za na zonana mina uke vei i Pita, ko mina boka tavalavata za na Tamaza za gua.) Beto za paranga lao tana i Jisu, <<Mae, tutiziu!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ego ko za balinga za gua i Pita, za batia za korapa tututi nana za maka ria na sepele aza za roquroqu vitivitigia i Jisu. Aza za na sepele za totoravuzu pa raqoraqona i Jisu totonai qari kole tekuteku, beto ko za nanaza laoia i Jisu, <<Bangara, i zei za mina gabala kanago ao?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Totonai za batia i Pita za na tinoni aza, za nanaza laoia i Jisu, <<Bangara, goto ae vei za na tinoni ani?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Nari za oea i Jisu aza, <<Vei mana nyoroguani ara ko mina toa kamua na mule lame taqu, nari za ae mina vei tamu aza? Goto ao za mae gu ko mu tutiziu!>> za gua. ");
INSERT INTO ghn_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ego ko na nongoro za rerege tadiria qari tutia i Jisu za minake uke za na sepele ani qari gua. Ba i Jisu zake pojai za minake uke aza zake gua, goto ari tu za gua vei, <<Vei mana nyoroguani ara ko mina toa kamua aza za na mule lame taqu, nari za ae mina vei tamu aza,>> za gua tu aza. ");
INSERT INTO ghn_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ko aza tugu za na sepele za korapa uleni na veveidi ari, beto za kuti vakoleria na zakazava ari. Ko gami gami gilagilai za na ulule tana aza na zozotona tugu. ");
INSERT INTO ghn_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ego ba koledia mule za kubo roiti za roitidi i Jisu, ko vei bari takuti vikitivokotia beto nari za qa roquroqua ara za na kasia guguzu tu ba bi keporeni na kota ketakoi bi vakoledi ria na buka bari takuti ria.");
INSERT INTO ghn_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiopilasi, pa qua buka momoe qa tori kuti valao vanigo tu za qa ululedi doru zakazava za roitidi beto za varivagigalaidi i Jisu podalai tu totonai za podalaini na nana roiti ");
INSERT INTO ghn_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ko tinganai za kamua na ranena za tateku zae pa noka aza. Totonai za oqoro tateku zae aza, za ule vadi aza pa neqi tana Ongu Tabuna ria na tinoni tagarunudi za tori mijataria tu, ria na nana tinoni tagarunudi. ");
INSERT INTO ghn_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tadiria za votu tabata kubo totozo pa okoto zona pa leona ka madengavuluputa rane pa liguna na nana uke. Ko za tavazozoto valeana za na toana zozoto tugu aza, beto ko pa totozo tugu ria za ule vadi aza za na veveina na binangara tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ego totonai qari korapa makarai tekuteku ria za pojadi i Jisu ria, ari za gudi vei, <<Muneke taloi pa Jerusalema za gamu, goto muna adonia za na neqi aza za taringutingutini na Tamaqu, aza vei gamu tori nongoria tu qa pojadigamu ara. ");
INSERT INTO ghn_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ura i Jone za varipaputaisoni na kolo, goto gamu za ka viza rane gu qari kole pa moemiu ari za pala muna tapaputaisoni na Ongu Tabuna tu,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ego ko totonai tugu qari korapa suvere varikamudia ria doru, nari za qari kole nanazia i Jisu, ari qari guni vei, <<Bangara, ae vei pa totozo koviria za muna vamule vadi na butubutu tinoni Izireli ao za na binangara?>> qari guni. ");
INSERT INTO ghn_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nari ari za gudi vei i Jisu ria, <<Nake miu laona gamu ko muna gilagilaria ria na rane na totozo, goto na Tamaqu tu pa nana neqi makana za mijataria. ");
INSERT INTO ghn_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Goto gamu za muna tekua za na neqi totonai mina lageregamu na Ongu Tabuna, ko muna ululeniziu ara pa Jerusalema, doru kota pa Jiudia, pa Sameria, ko tinganai muna kamua tu na vinabetobetona na abana,>> za gua i Jisu. ");
INSERT INTO ghn_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ego ko za beto tugu paranga vei zara aza, nari za tonai tugu qari korapa dogodogorodia ria za tateku zae, beto za lame maka lei ko za vapaea ko qarike batia za totonai. ");
INSERT INTO ghn_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ego ko qari korapa tugu enga dogoro tututia ria za na zaena aza, nari za qari votu vasiboro turu tavitiria za kori tinoni qari pokopoko keala, ");
INSERT INTO ghn_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ko ari qari gua vei, <<Boko minete tinoni Qalili! Ae za vei ko gamu korapa tu turu enga zae vei pa noka za gamu? Aza tugu i Jisu ani, aza za tapikata tadigamu ko za tateku zae pa noka, za mina mule lagere pa zona vei tugu gamu batia za zae pa noka aza,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ego pa liguna aza za qari taloi pa kubo pa Olive ko qari gabala muledia pa Jerusalema, na zouna za na padana maka kilomita. ");
INSERT INTO ghn_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ko tonai qari kamu pa Jerusalema, nari za qari zae pa lose pa nulu ko ketakoi qari suvere. Ria na tinoni ari za ari Pita, i Jone, i Jekopi, i Aduru, i Pilipi, i Tomasi, i Batolomiu, i Matiu, beto i Jekopi na tuna i Alepiasi, i Saimone aza perangaina na somanana tadiria qari nyorogua adu paleni na qavuna pa Romu, beto ko i Jiudasi na tuna i Jekopi. ");
INSERT INTO ghn_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ko ria doru ari za qari makarai suvere varikamu ko qari aru tokatokai na varavara, tavitiria ria na reko beto i Mere na tinana i Jisu beto vei tugu ria na taina marene. ");
INSERT INTO ghn_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ego ko maka rane vevei ria totonai qari varikamu (na padana maka gogoto rabeteputa tinoni ria qari varikamu), za turu i Pita pa varikorapaidi ria, ko ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","<<Boko tavitiqu, za tori gore votu tu za na Kutikuti Tabuna, aza perangaina tu za pojai na Ongu Tabuna ti Devita, na veveina i Jiudasi aza za koimatadi ria qari aru tamania i Jisu. ");
INSERT INTO ghn_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Aza za somana tanguti tavitigita mae tugu gita ko za somana aru tugu pa roiti ninabulu ani,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ko aza tugu na tinoni ani za vaini maka kobu pezo za na poata za tekuni pa nana roiti ikikerena, beto za gona tuluzu tapokatani ko za votu beto pudala tu na borina. ");
INSERT INTO ghn_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ko qari gilagila betoa ria doru tinoni qari suvere pa Jerusalema aza za vei zara, ko na kobu pezo aza za pa dia parangana qari vaizongoni Akeledama, na ginuana aza za na Kobu Pezo Orungu.) ");
INSERT INTO ghn_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","<<Ura na takuti kolena pa buka Kera Vinatarazae za ari za gua vei, <Mi tavaivulu za na nana ruma, beto kepore na tinoni mi suveria,> za gua. Beto ari mutu za gua vei, <Na lolomo ninabulu tana aza za na goto tinoni tu mi teku vakarovia,> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ego ko za poreveveina za gita tana mijatia za maka tinoni za suvesuvere tavitigita pa doruna na totozo za suvere tavitigita na Bangara i Jisu, ");
INSERT INTO ghn_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","podalai tugu za varivapaputaiso i Jone ko za lame kamu tadigita totonai za tateku zae pa noka aza. Ko na tinoni aza za mina somana vavakatoni tugu aza za na turumulena na Bangara,>> za gua i Pita. ");
INSERT INTO ghn_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ko qari mijataria ari kori: ari Josepa, aza qari vaizongoni i Basabasi (i Jasitasi tugu vei za maka izongo qari vaizongoni), beto i Mateasi. ");
INSERT INTO ghn_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Beto za qari varavara, ari qari gua vei, <<Bangara, ao qu gilagila betoria za na bulodi doru tinoni. Ko mu ule vadigami i zei ari kori ari za qu mijatia ao ");
INSERT INTO ghn_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ko mina aru tokai za na roiti ninabulu tana tinoni tagarununa, aza za loi paleni i Jiudasi ko za laonana pa ia varivakilasana za taiani,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Beto qari gonani ria za na patu mijamijata nari za tauduku i Mateasi, ko aza za somana tanguti tavitiria ari ka manogamaka tinoni tagarunudi. ");
INSERT INTO ghn_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ego totonai za kamua za na rane Penitikositi, nari za qari makarai suvere varikamu pa maka ia ria doru ari. ");
INSERT INTO ghn_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tonai za ovanga vasiboro lagere vei pa vavagalo za maka za za vei na ovangani pogopogozo gava lavata, ko za vapugelia za na leona na ruma qari korapa suveria ria. ");
INSERT INTO ghn_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Beto za qari batia ria za maka za za vei na iku za memea tapikapikata za lagere nyumu tadiria na okokoto tinoni ketakoi. ");
INSERT INTO ghn_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ko ria doru za pugeleria na Ongu Tabuna, beto ko qari podalai parangadi ria ria na gotogoto paranga pa bokaboka paranga za vadi na Ongu Tabuna. ");
INSERT INTO ghn_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ego ko qari korapa tugu suveredia ketakoi pa Jerusalema ria na tinoni Jiu neqineqidi pa vatarazaena na Tamaza, ria na koko lame veidi pa okokoto puku tinoni pa kauruna na oka. ");
INSERT INTO ghn_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ko tonai qari nongoria za na ovanga lavata ani, nari za qari varikamu ria na mota tinoni ko qari rura gu mari koledia, ura qari okoto kole nongonongororiadia gu ria na okokoto dia paranga qari parangadi ria. ");
INSERT INTO ghn_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ko qari kole rura beto qari gabara, ko ari qari gua vei, <<Dotu, kue qokolo! Ria doru tinoni qari korapa paranga ari za na galegale tinoni Qalili beto tu! ");
INSERT INTO ghn_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ba ae za vei ko gita taqe korapa tu nongonongororianada pa okokoto nada paranga ria na zakazava qari korapa pojaria ria? ");
INSERT INTO ghn_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ura gita za na okoto lame veida tu pa Patia, Midia, Elami, Mesapotamia, Jiudia beto pa Kapadosia, Ponitasi, beto ko pa Esia. ");
INSERT INTO ghn_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Gita kaki mule ari za na lame veida tu pa Piruqia, Pamipilia, Ijipi, pa kota pa Libia tata vei pa Saerini, beto kaki gita za na kokoda pa Romu tu. ");
INSERT INTO ghn_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Na tinoni Jiu beto ko na tinoni karovo gabalada za gita, kaki gita za na lame veida pa nuza Kiriti tu beto ko pa Arabia tu, ba taqe okoto korapa nongoro betorianada gita pa okokoto nada parangana ria na roiti poreveveidi tana Tamaza qari korapa pojaria ari!>> qari gua ria. ");
INSERT INTO ghn_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ko pa dia gabara beto na rura, za qari kole varivarinanaza makadi, <<Koi, na za na ginuana za vei ari?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Goto ria kaki za qari vavagoreni qera ko ari qari paraparanga vei, <<Koi, za apo learia gu na vaini lomozona ko qari digere zara!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ego ko totonai za turu pa varikorapaidi ari ka manogamaka tinoni tagarunudi i Pita ko za paranga velavelaria ria na minete tinoni, ari za gua vei, <<Ka viza tinoni Jiu tavitiqu beto ko gamu doru na suveremiu pa Jerusalema! Mu vainongoro lamedi na qua paranga ko mu gilagilai za na ginuana aza za gore votu ani! ");
INSERT INTO ghn_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Qarike bukubuku vadigeredi ria ari, aza vei gamu roquroqua gamu. Nake totozo bukubuku za koviria, ura za koni sia koloko volavolaza gu za na rane. ");
INSERT INTO ghn_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Goto aza gamu batia koviria za na vagore votuna na korokorotai ti Joili na tinoni korokorotai, ari za gua vei aza, ");
INSERT INTO ghn_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","<Ego ari mina vei za pa rane liguligu, za gua za na Tamaza: Mana vakijara taridi ria doru tinoni na qua Ongongu. Ko mari ule votuni ria na tumiu marene beto na tumiu reko za na qua nongoro. Ria na zazae korega za mari bati dogodogoro, beto ria na miu barabaragozo za mari putagitaria na putagita. ");
INSERT INTO ghn_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ko na rane ria za ria na qua nabulu marene na qua nabulu reko ba mana vakijara taridi tugu na qua Ongongu. Ko ria ba mari ule votuni tugu na qua nongoro. ");
INSERT INTO ghn_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Pala mana roitidi na zakazava varivagabaradi pa noka vavagalo beto na vinagilagila neqidi pa pezo ani, na orungu, na iku beto na rovu nune tula. ");
INSERT INTO ghn_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Na tapo za mina rodomo beto na popu za mina jemere orungu, totonai mina oqoro lame za na rane lavata tana Bangara. ");
INSERT INTO ghn_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ba ria doru qari kiu alili lao tana Bangara za mari taalo! za gua za na Tamaza,> za gua i Joili. ");
INSERT INTO ghn_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ka viza tinoni Izireli tavitiqu, mu vainongorodi na paranga ari ko! Aza tugu i Jisu pa Nazareti za na tinoni za tavadogoro vaporeveveina pa moena na Tamaza. Ko gamu makamiu ba gamu tori dogoro vazozoto valeana ria tu ria na roiti varivagabaradi, na zakazava varivagabaradi, beto na vinagilagila neqidi za roiti votudi na Tamaza tana ko qari tabata pa varikorapaimiu gamu. ");
INSERT INTO ghn_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Aza tugu za na tinoni za tori mijatia tu na Tamaza pa nana nyorogua beto pa nana gigalai perangaina tu, beto ko za taloi valao pa limamiu gamu aza ko gamu gamu vaukea aza tonai gamu valao vadi ria na tinoni ikikeredi ko qari patani pa korosi. ");
INSERT INTO ghn_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ko aza tugu za tori vaturu mulea tu na Tamaza ko za ruvatia pa vitigina na uke, ura na uke zake boka piu tamana vakole jolai aza. ");
INSERT INTO ghn_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ura ari za gua vei za pojai i Devita na veveina aza, <Qa batibatiaqua ara pa moequ doru totozo za na Bangara, ura pa kale matuaqu gu za nyumu aza ko za vei za ara manake boka tajou vakanoko. ");
INSERT INTO ghn_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ko za vei za qeraqera za na buloqu beto na qua paranga za pugelia na qera, beto ko na tiniqu ba mina kole toa gelegele lao momoe. ");
INSERT INTO ghn_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ura ao munake vakole jolaziu pa ia tadiria qari uke ara, beto munake loi pale na mua Liosona ko bi kole nyabo goboronana. ");
INSERT INTO ghn_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Qu tori vabatiniziu tu za na zonana na toa, beto na mua suvere somana taqu za mina pugeleniziu na qera,> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ego ko, ka viza tavitiqu, ma lodaka vadigamu gu ara za na veveina i Devita na bangara, aza na tamada pa moa. I Devita za uke ko za tagolomo, ko na pouna aza za korapa gu kole tavitigita gita kamua tu pa rane pa ngenari. ");
INSERT INTO ghn_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ko i Devita ba maka tinoni korokorotai tugu ko za gilagilainana aza za pa maulu tu za taringutingutini na Tamaza za na veveina maka ria pa tutina i Devita za mina nyumu bangara vei i Devita. ");
INSERT INTO ghn_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ko za tori dogoro lao momoea tu i Devita aza mina roitini na Tamaza uka riza, ko za vei za pojai aza za na veveina na turumule tana Karisito, ari za gua vei, <Aza zake taloi pale pa ia tadiria qari uke, beto na tinina zake taloi pale goboro ko bi kole nyabo goboronana,> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ko aza tugu i Jisu aza za vaturu mulea na Tamaza pana uke, ko gami doru ari za gami bati valeaniamami ko mami boka vavakatoni gu za vei aza. ");
INSERT INTO ghn_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ko za taovulu zae pa kale matuana na Tamaza. Ko za tekua aza za na Ongu Tabuna aza na taringutinguti tana Tamana, beto za vuva lagereni ko aza za gamu batia beto gamu nongoria gamu koviria. ");
INSERT INTO ghn_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ura i Devita zake zae pa noka, ba ari tu za gua vei aza, <Na Bangara Tamaza za parangia na qua Bangara: Mu nyumu pa kale matuaqu, ");
INSERT INTO ghn_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tinganai mana veidi na mua tetetena pa nenemu ria na mua kana,> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Zara za vei ko mu gilagila valeania gamu doru tinoni Izireli ani: za tori vabangaria tu beto za vakarisitoia na Tamaza za aza tugu i Jisu ani, aza gamu tugu gamu vaukea pa korosi,>> za gua i Pita. ");
INSERT INTO ghn_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ego ko totonai qari nongororia ria na minete tinoni ria na paranga ari, za tasuni za na bulodi, ko qari paranga laoa i Pita beto ria doru tinoni tagarunudi, ari qari gua vei, <<Ko, boko tavitimami, na za vei mami boka roitini gami za vei?>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nari ari za gudi vei i Pita, <<Gamu doru za mu okokoto gabala ko mu tapaputaiso pa korapa izongona i Jisu Karisito ko mari taleozo ria na miu sela, beto za muna tekua gamu za na varivana tana Tamaza, aza na Ongu Tabuna. ");
INSERT INTO ghn_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ura na taringutinguti tana Tamaza ani za tadigamu tugu, tadiria na tumiu gamu beto tadiria doru qari suvere pa zouna, ko tadiria doru gu ria na Bangara na nada Tamaza mina kukuria,>> za gua i Pita. ");
INSERT INTO ghn_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ego ko zoku paranga mule za poja vaneqineqidi i Pita beto ko za kole tepa vaneqidi, ari za gudi vei, <<Mu alo muledigamu pa vinakilasa mina gozoria na zazae tinoni za tori rerege vapiru tu ani!>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ko ria qari vazozotoa na paranga ti Pita za qari tapaputaiso, ko pa rane tugu aza za padapada kue vuro tinoni za qari somana tanguti tamo lao tadiria na tinoni tana Bangara. ");
INSERT INTO ghn_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Qari somana ngalingalini ria za na varivagigalai tadiria na tinoni tagarunudi beto na toa makarai variia, na toa makarai tekuteku beto na makarai suvere varavara. ");
INSERT INTO ghn_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ego ko qari kole matagutu ria doru tinoni tonai qari batiria zoku roiti varivagabaradi beto na vinagilagila neqidi qari kole roroitidi ria na tinoni tagarunudi. ");
INSERT INTO ghn_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Goto ria qari vazozoto za qari makarai suvere varikamu beto qari makarai variizongodi doru dia zakazava. ");
INSERT INTO ghn_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ko na dia izizongo beto na dia zakazava za qari okoto vavaidi ko na poatadi za qari okoto ia betodi ria qari varivasevi. ");
INSERT INTO ghn_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Na varituti rane gu za qari makarai makani ria za na lao varavara pa kakabarena zelepade beto na makarai varikamu tekuteku pa okokoto ruma. Qari makarai varitekudi na ganigani pa qeraqera beto pa bulo pangaga. ");
INSERT INTO ghn_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Qari vatarazaea na Tamaza beto qari tavaraguadi ria na minete tinoni. Ko na varituti rane gu za na Bangara za nguti vatamo lao vadi ria qari taalo. ");
INSERT INTO ghn_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ego maka rane za ari Pita i Jone za qari zae pa kakabarena zelepade pa totozo varavara kue koloko goregore tapo. ");
INSERT INTO ghn_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ko maka tinoni na podo qaqaona za maka tapogozo kamu mule. Na varituti rane gu za qari pogopogozo lao vavanyumua pa kakabarena zelepade pa atakamana aza qari vaizongoni na Atakamana Batabataleana, ko mi tepatepadi na poata ria mari luge lao pa kakabarena zelepade qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ko totonai za batiria ari Pita i Jone qari korapa luge lao pa kakabarena zelepade qari gua, nari za tepadi na poata. ");
INSERT INTO ghn_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nari qari dogoro tari vatogazia ari Pita i Jone aza, beto za paranga lao pana tana i Pita, ari za gua vei, <<Mu dogoro lame tadigami kori!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nari za dogoro lao tadi ari kori aza, za rovea palu mari vaniziu kaki zava za gua. ");
INSERT INTO ghn_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ba za paranga i Pita, <<Na poata siliva beto na qolo za kepore vagila na qua ara, ba aza vei qa izongia za ma vanigo ao: pa korapa izongona i Jisu Karisito pa Nazareti za mu turu ko mu rerege!>> za guni. ");
INSERT INTO ghn_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Beto za lao arua i Pita za na lima kale matuana na tinoni za qao ani, ko za bako vaturua. Nari pa totozo tugu aza qari neqi za na nenena beto na varivarijoka pa kuta nenena na tinoni aza, ");
INSERT INTO ghn_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ko za soqolo turu ko za podalai rerege gu beto za tutiria luge pa kakabarena zelepade ari kori. Ko za rerege, za soqosoqolo beto za kole vatarazaea aza za na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ko ria na minete tinoni za qari batiadia tu za na kole reregena aza beto aza vei za kole vatarazaea na Tamaza aza. ");
INSERT INTO ghn_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Beto qari dogoro vatavagigaliadia ria za aza tugu za na tinoni za kolekole nyumu tepatepa pa kakabarena zelepade pa Atakamana Batabataleana. Ko qari gabara betoni ria aza vei za taroiti pana tana. ");
INSERT INTO ghn_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ego ko totonai za korapa aru tamana tadi ari Pita i Jone za na tinoni za tasalana ani, nari za ria doru tinoni za qari abutu varikamu lao tadi ari kue pa ia ketakoi qari gigalani na Suvesuverena ti Solomone, ko qari gabara beto pudaladia ria doru. ");
INSERT INTO ghn_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ko totonai za batiria i Pita ria na minete tinoni qari varikamu, za paranga lao tadiria, ari za gua vei, <<Ka viza tinoni Izireli tavitiqu! Ae za vei ko gamu gabarani tu gamu za na ginugua ani? Ae za vei ko gamu dogoro tari veidigami kale tu na mami neqi babi na mami pangagana na Tamaza gami kori za tasalanani ko za rerege za na tinoni ani? ");
INSERT INTO ghn_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Na Tamaza tadi ari Ebarahami i Aisake beto i Jekopi, aza na Tamaza tadiria na boko tamada pa moa, za tori valavatia tu i Jisu na nana nabulu, aza gamu tugu gamu loi laoni tana qavuna ko za tavauke. Ko gamu kilu paleni gamu aza pa moena i Paelati, totonai za nyorogua ruvatia aza. ");
INSERT INTO ghn_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Gamu tugu za gamu kilu paleni na tinoni liosona beto na tuvizina, goto gamu tepaia tu gamu ti Paelati za na tinoni varivarivaina ko za taruvata vadigamu aza. ");
INSERT INTO ghn_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Na kutana na toa za gamu vaukea gamu, ba aza tugu za na Tamaza za tori vaturu mulea tu pa uke. Ko pa nana turumule aza za gami za na tinoni gami batia ko koviria gami korapa vavakatoni na veveina. ");
INSERT INTO ghn_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ko pa vinazozotona na izongona aza za tavaneqi soga za na tinoni gamu batiamiu beto gamu gilagilaimiu ani. Ko koko vei pa rangena gu na izongona aza za tasalana valeana za na tinoni pa moemiu gamu doru ani. ");
INSERT INTO ghn_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ba, ka viza tavitiqu, qa gilagila valeaniaqua ara za pana rura gu gamu roitini gamu beto ria na tinoni qari matamatadigamu za na ginugua ari. ");
INSERT INTO ghn_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Na Tamaza za vagore votua aza vei za tori pojai tu perangaina tadiria doru tinoni korokorotai na veveina mina gozoro vitigi vei tugu zara za na nana Karisito za gua. ");
INSERT INTO ghn_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ko koviria mu loi paledi ria na miu sela ko mu gabala lao tana Tamaza, ko aza mina taleozodigamu. ");
INSERT INTO ghn_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ko muna vei gamu nari za ria na totozo minyere pana tapata za mari lame vei tana Bangara ko mari tavakopele ria na bulomiu, beto mina garunu lameni za na Karisito za tori uduku vadigamu tu gamu, aza i Jisu. ");
INSERT INTO ghn_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ba mina suvere mae pa noka aza tinganai mina kamua mae tu za na totozo mina vakorega sogaria doru zakazava na Tamaza, aza vei za tori pojai pa moa tu aza tadiria na nana tinoni korokorotai madidi. ");
INSERT INTO ghn_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ura ari za tori paranga vei tu i Mosese, <Maka tinoni korokorotai vevei ara za mina vaturua na Bangara na miu Tamaza, ko na tinoni aza za maka pana tavitimiu zozoto gamu. Aza za muna vatabea gamu pa doru zakazava vei rari vei mina gudigamu aza. ");
INSERT INTO ghn_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Aza na tinoni minake vatabea za na tinoni korokorotai aza za mina tapikata pale zozoto tadiria na tinoni tana Tamaza aza,> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ko ria doru tinoni korokorotai za podalai ti Samuela ko mi lame za qari tori paranga vakoledi tu ria na totozo ari. ");
INSERT INTO ghn_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Gamu tu ko na tudi ria na tinoni korokorotai, ko tadigamu tugu za na taringutinguti za roitini na Tamaza tadiria na tamamiu pa moa tonai ari za gua vei ti Ebarahami, <Ko pana maka tutimu ao za mana manadi ara ria doru pukupuku tinoni pa kasia guguzu,> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ko tadigamu momoe mae tu za garunu lameni na Tamaza za na nana nabulu tonai za vaturua, ko mi manadigamu tonai muna gabala loi paledi ria na miu roiti ikikeredi gamu za gua,>> za gua i Pita. ");
INSERT INTO ghn_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ego totonai qari korapa vavakato tadiria na tinoni ari Pita i Jone, nari za qari lame tadi ari kori ria na kuta iama, na matamata tadiria na tinoni kopu pa kakabarena zelepade, beto ko ria na Sadusisi. ");
INSERT INTO ghn_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Qari tagigirini ria aza vei qari korapa varivagigalai ari kori tadiria na tinoni beto na veveina qari taraeni za ria na tinoni ukedi za pala mari turu mule maka moqaza vei i Jisu ba za turu mule pa uke qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ko qari aru tamanaria ari kori ko qari lao valugeria pa leo ruma varipiuna ko mari adonia mina rane soga qari gua, ura za tori tata tu za na bongi. ");
INSERT INTO ghn_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ego ba kubodi ria qari nongoria na tinarae ti Pita za qari vazozoto, ko na ngutidi ria qari vazozoto za padapada vei ka lima vuro tinoni za totonai. ");
INSERT INTO ghn_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ego ko za rane soga na kota nari za qari varikamu pa Jerusalema ria na tinoni matamata tadiria na Jiu, ria na tiolata matamata, beto ria qari varivagigalaini na Vavanau. ");
INSERT INTO ghn_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ego ko qari somana ari Hanasi na kuta iama lavata, i Kaiapasi, i Jone, i Alekezada, beto ria kaki tavitina mule na kuta iama lavata. ");
INSERT INTO ghn_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ko qari lao vatururia pa moedi ria na tiolata ari Pita i Jone, beto za qari nanazaria, ari qari gudi vei, <<Na neqi zavana babi pana izongona i zei za gamu roitidi gamu kori ria na zakazava ari?>> qari gudi. ");
INSERT INTO ghn_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ego nari za tapugeleni i Pita za na neqi tana Ongu Tabuna, ko za oe laoria, ari za gua vei, <<Gamu ka viza na tinoni matamata beto na tiolata matamata tadiria na tinoni! ");
INSERT INTO ghn_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ego pa rane pa ngenari ani za gami tananaza vilovilotoni gami za na veveina na roiti leana za taroiti tana na tinoni za qao ani beto ko pana ae zona vei za tasalana aza. ");
INSERT INTO ghn_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ko leana, mu gilagila valeania ropi gamu doru beto ria doru tinoni Izireli ani: Pana izongona i Jisu Karisito pa Nazareti aza gamu tugu gamu vaukea pa korosi ba na Tamaza za tori vaturu mulea tu, za turu pa moemiu gamu na tinoni tasalana valeanana za na tinoni ani. ");
INSERT INTO ghn_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ko aza tugu i Jisu ani za pojai na veveina na Kutikuti Tabuna, ari za gua vei, <Na patu qu kilu paleni gamu na tinoni vavaturu ruma, za aza tugu za na kuta patu vizovizo,> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ko zake kole mule tana maka goto tinoni za na inaalo, ura kepore mule za maka izizongo za tavakukuni na tinoni pa kauruna na noka pa kasia guguzu vei mina boka alogita za gita,>> za gua i Pita. ");
INSERT INTO ghn_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ego ko totonai qari batia ria na tiolata qari varikamu za na paranga varene tadi ari Pita i Jone, beto ko qari gilagilaidia tugu vei ria na tiolata za na tinoni suvesuveredi gu nake sikulu valeadi ria, nari za qari gabara. Ba qari gilagila kamua tugu ria na tiolata za na tinoni qari tututi ti Jisu za ari. ");
INSERT INTO ghn_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Beto ko qari batiadia tugu za korapa turu tavitirianana ari Pita i Jone vei za na tinoni za tasalana, ko qarike boka pojai maka za. ");
INSERT INTO ghn_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ko qari vavoturia ari kori, ko qari kole varivavakato makadi ria. ");
INSERT INTO ghn_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Qari varivarinanaza, ari qari gua vei, <<Ae tana roiti veidi gita ari kori ari? Ura maka roiti varivagabarana za qari roitini ari kori, ko ria doru tinoni Jerusalema ba qari tori gilagila betoadia tugu, beto ko gita ba taneke boka vasekea za na roiti ani. ");
INSERT INTO ghn_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Goto keta vei ko mi tapiara lao tadiria doru tinoni za na ginugua ani, nari za ta paranga vabalauria gu ko koviria marike vavakato sogani tadiria na tinoni za na izongona i Jisu,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ko qari kuku valuge sogaria ari kori, ko qari pojadi za marike izongo vavakato sogani babi varivagigalai pana izongona i Jisu ari kori qari gudi. ");
INSERT INTO ghn_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nari qari oe lao tadiria ari Pita i Jone, ari qari gua vei, <<Vei mina tuvizina pa moena na Tamaza za gamu za muna tavatabe babi na Tamaza tu, za gamu mu dogoro pikatia aza. ");
INSERT INTO ghn_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ura gami za mamike boka ngujupukuni aza vei gami batia beto gami nongoria,>> qari gua ari kori. ");
INSERT INTO ghn_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nari za qari vanyumu vamauria ria na tiolata za na dia paranga vinabalau lao tadi ari kori, beto za qari vavotu keniria. Qarike boka batia ria na tiolata za ae zona vei bari vakilasaria ari kori, ura ria doru tinoni za qari vatarazaea na Tamaza pana roiti varivagabarana za taroiti. ");
INSERT INTO ghn_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ura na tinoni za tasalana ba za tori jola tu madengavuluputa aorona. ");
INSERT INTO ghn_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ego ko pa liguna qari ruvata vakeniria, nari za qari lao tadiria na boko tavitidi ari Pita i Jone ko qari vavakato vadi aza vei qari gudi ria na kuta iama beto na tiolata matamata. ");
INSERT INTO ghn_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ko tonai qari nongoria ari ka viza tinoni qari vazozotoa aza vei qari pojai ari Pita i Jone, nari za qari makarai maka pana varavara ko qari makarai paranga lao tana Tamaza. Ari qari gua vei ria, <<Bangara lavata, ao qu vapodakia za na noka na pezo na ivere beto doru zakazava qari kole pa leodi. ");
INSERT INTO ghn_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ari za qu parangadi ao pana Ongongu Tabuna aza vei za pojai na mua nabulu i Devita na tamamami, <Ae za vei ko qari kukiti tu ria na puku tinoni beto ko qari varingododi tu ria na roverove goborodi? ");
INSERT INTO ghn_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Qari tori turu vanaqiti tu ko mari varipera qari gua ria na bangara pa pezo, beto ria na tinoni matamata qari varikamu ko mari variraja lao za tana Tamaza beto na nana Karisito qari gua,> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ko aza tugu za na varikamu qari tori roitini tu pana ia pani. Ari Herodi i Ponitiasi Paelati beto vei tugu ria na tinoni karovodi beto ria na tinoni Izireli za qari varikamu ko qari rajai i Jisu aza na mua nabulu liosona qu tori udukia tu ao. ");
INSERT INTO ghn_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ko qari roiti vagore voturia gu ria ria na zakazava qu tori pada vakoleria tu ao pana mua neqi beto na nyorogua. ");
INSERT INTO ghn_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Zara za vei, Bangara, ko mu dogororia ria na roiti varivamatagutudi mari roiti lamedi qari gua, beto ko mu vadigami na vinavarene gami na mua nabulu ko mami pogozo turuni na mua paranga. ");
INSERT INTO ghn_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Mu alaka lameni tu na limamu ao ko mari taroiti ria na salana, na roiti neqidi beto na roiti varivagabaradi pa korapa izongona na mua nabulu liosona i Jisu,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ego aza tugu qari beto varavara, nari za jojou za na ia ketakoi qari kole varikamu ria. Beto ko za pugeleria na Ongu Tabuna ria doru ko qari vareneni ria za na vavakatoni na paranga tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ego ko ria na minete tinoni qari vazozoto za qari makarai maka pana bulo beto pana roquroqu, ko kepore maka ria bi pojani na nana gu makana ria na nana zakazava za izongoria, goto ria doru za qari makarai variizongodi gu doru dia zakazava. ");
INSERT INTO ghn_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ko pa korapana na neqi lavata za qari kole vavakatoni ria na tinoni tagarunudi za na turumule ti Jisu, beto ko na mana lavata tana Tamaza za somana tavitiria ria doru. ");
INSERT INTO ghn_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kepore maka ria za bi qaqani maka zakazava. Ura ria na poredia pezo babi na ruma za qari okoto vavaidi za na dia izizongo ria, ko na poatadi na zakazava qari vavaidi ");
INSERT INTO ghn_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","za qari okoto pogozo laodi tadiria na tinoni tagarunudi, ko qari tavaia lao tadiria vei bari qaqani maka zakazava. ");
INSERT INTO ghn_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ko i Josepa, maka tinoni na butubutu Livai na podona pa nuza Saeparasi, za roiti vei aza. Ria na tinoni tagarunudi qari vaizongoni i Banabasi aza (na ginuana za na tinoni za juka vaneqiria na goto tinoni). ");
INSERT INTO ghn_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Za vavaini aza za maka nana iapeki kobu pezo, beto za pogozo lao vadi ria na tinoni tagarunudi za na poatana za tekua. ");
INSERT INTO ghn_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ego ko kolenana za maka tinoni na izongona i Hananisi beto na maqotana i Sapira. I Hananisi ba za vavaini tugu za iapeki nana izizongo ");
INSERT INTO ghn_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","beto za pogozo laoni tadiria na tinoni tagarunudi za maka kobuna na poata, goto maka kobuna za peki aru golomia. Ko na maqotana ba za gilagila valeania nana beto za vaegoa tugu za vei aza. ");
INSERT INTO ghn_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nari za paranga laoa i Pita aza, ari za guni vei, <<Hananisi! Ae za vei ko qu vamalumia tu ao i Setani ko za lalaeni na bulomu, ko qu sekesekea tu ao za na Ongu Tabuna beto ko qu peki aru golomia tu ao za na kobuna na poatana na pezo qu vavaini ao? ");
INSERT INTO ghn_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Totonai qu oqoro vavaini ao za na mua tugu ao za na pezo, beto ko pa liguna qu vavaini ao nari za kole tugu pana neqi tamu za na poata ko muna boka varoiti veini aza vei qu nyoroguani. Ko ae za vei za qu vakolea tu pa bulomu ao za na roquroqu ikerena ani ko qu sekesekeni tu ao za na kobuna qu valamea? Nake tinoni za qu sekesekea ao, goto na Tamaza tu!>> za gua i Pita. ");
INSERT INTO ghn_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Aza tugu za nongoro betoria i Hananisi za na paranga ari, nari za lotu ko za loia gu aza za na singo. Ko qari matagutu vitivitigi ria doru tinoni qari nongoria na ginugua aza. ");
INSERT INTO ghn_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Goto ria kaki tinoni zazae korega za qari lao udea za na kobukobu tinina ko qari pala keni golomia. ");
INSERT INTO ghn_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ego ko za jola padana kue aoa, nari za na maqotana za lao gu mule bola, ba za oqoro nongoroni aza za na veveina na marenena. ");
INSERT INTO ghn_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nari za nanaza laoa mule i Pita aza, <<Ae vei, ani tugu za na doruna na poata gamu tekuni na laena na pezo gamu kori tamabaragozo?>> za gua i Pita. Nari za paranga i Sapira, <<E, aza tugu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Beto za paranga lao tana i Pita, <<Ae za vei za gamu varivaegoni tu gamu kori baragozo ko gamu podekia za na Ongu Tabuna tana Bangara? Dogoro ko! Ria na tinoni qari koni pala keni golomia na marenemu za qari tori korapa tu turudia pa atakamana zara, ko koviria ao mule za mari pala votunigo,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nari pa totozo tugu aza za lotu pa moena i Pita i Sapira ko za loia gu za na singo. Ko qari lao qari gua ria na tinoni koregadi nari za qari batia za tori uke tu, ko qari pala votu keni golomia gu mule aza pa keketaina na marenena. ");
INSERT INTO ghn_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ko za matagutu vitivitigi za na ekelesia doruna beto ria doru qari nongorodi na zakazava ari. ");
INSERT INTO ghn_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ego ko kubo vinagilagila neqidi beto na roiti varivagabaradi za qari roitidi ria na tinoni tagarunudi tadiria na tinoni. Beto ria doru tinoni qari vazozotoa na Bangara za qari makarai varivarikamu pa ia pa zelepade qari gigalani na Suvesuverena ti Solomone. ");
INSERT INTO ghn_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kepore mule za maka tinoni bi varene lao somana tavitiria ria, ba qari dogoro valavataria ria na tinoni qarike vazozoto ria na tinoni tana Bangara ari. ");
INSERT INTO ghn_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ko qari mota tugu lalaodia ria qari vazozotoa na Bangara ko qari somana tanguti taviti tadiria na tinoni tana Bangara, ria na tiolata marene na reko. ");
INSERT INTO ghn_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Qari koi vei tanongoro za na roiti varivagabaradi qari roitidi ria na tinoni tagarunudi ko pa lodaka zona tu ba ria na tinoni za qari pala laodi ria qari mo ko qari lovanga vadi na lovu beto qari vakoleria pa dia kolekoledi. Qari roiti vei zara ko totonai mi rerege jola vei ketakoi i Pita nari za na onguna gu ba mina onguria qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ko ria na minete tinoni lame veidi pa guguzu varilivutaina pa Jerusalema za qari okoto toka kamudi ria qari mo beto ria na tinoni za koleria na tomete ikikeredi, ko qari tasalana beto ria doru. ");
INSERT INTO ghn_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ego ko na kuta iama lavata beto ria doru nana tinoni varitokai (ria na minete tadiria na Sadusisi) za pugeleria na kono. ");
INSERT INTO ghn_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ko qari aru tamanaria ria na tinoni tagarunudi, ko qari valugeria pa ruma varipiuna. ");
INSERT INTO ghn_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ba maka mateana tana Tamaza za lao na bongina tugu aza ko za revangia za na atakamanana na ruma varipiuna, ko za toka votudi ria na tinoni tagarunudi. Beto ari za gudi vei, ");
INSERT INTO ghn_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","<<Mu lao turu pa kakabarena zelepade ko mu vavakatoni tadiria na tinoni za doruna na veveina na nongorona na toa ani,>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ko pa liguna qari nongoria aza za poja veidi na mateana, nari za na volavolaza lea qari lao luge pa kakabarena zelepade ko qari podalai varivagigalai mutugu tadiria na tinoni. Ego na kuta iama lavata beto ria na nana tinoni varitokai za qari kuku varikamudi ria na tiolata pa kauniseli beto ria doru tiolata tadiria na Jiu, beto za qari valaoa za na garunu pa ruma varipiuna ko mari tatoka lame pa moedi ria na tinoni tagarunudi qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ba tonai qari lao kamu pa ruma varipiuna ria na nabulu kopu, nari za qarike batiria ria na tinoni tagarunudi. Ko qari mule vavakato vadi ria na minete tiolata, ");
INSERT INTO ghn_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ari qari gua vei, <<Koi! Na ruma varipiuna za gami lao batia za na tapate vamauru kolena beto ko ria na tinoni kopu za qari korapa tugu turu katapadia pana atakamana. Ba totonai mami revanga gami gua, nari za kepore maka tinoni babi batia pa leona,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ego totonai qari nongoria ria na kuta iama beto aza na matamata tadiria na tinoni kopu pa kakabarena zelepade za vei zara, za qari rura gu koledia. Na za beka za mina pidoko pa ginugua ani qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Beto za bola gu za maka tinoni, ko ari za gudi vei, <<Koi, boko tiolata! Ari ka viza tinoni gamu valugeria pa ruma varipiuna za rari, qari tori korapa tu turu varivagigalai tadiria na tinoni pa leo kakabarena zelepade,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nari za taloi keni za na matamata tadiria na tinoni kopu pa ruma zelepade beto ko ria na nana nabulu kopu, ko qari lao toka muledi ria na tinoni tagarunudi. Ba qarike toka arariadi na vavitigiria, ura qari matagutu tagona patu tadiria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ego ko qari toka lugedi ria na tinoni tagarunudi ko qari lao vatururia pa moedi ria na kauniseli. Beto za nanazaria na kuta iama lavata, ");
INSERT INTO ghn_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ari za gua vei, <<Gami tori vakoledigamu tu na suqutu gami ko munake varivagigalaini tadiria na tinoni za na izongona na tinoni ani gamigudigamu. Ba dotu! Gamu valekoia doru kota pa Jerusalema za na miu varivagigalai, beto ko gamu vagoredigami mutu gami za na uke tana tinoni ani!>> za gudi. ");
INSERT INTO ghn_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nari za oe lao i Pita beto ria na tinoni tagarunudi, ari qari gua vei, <<Za poreveveina jola za na Tamaza gu za mina tavatabe, nake ria na tinoni! ");
INSERT INTO ghn_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Na Tamaza tadiria na tamada pa moa za tori vaturu mulea tu i Jisu, aza gamu tugu gamu patani pa korosi ko gamu vaukea. ");
INSERT INTO ghn_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ba aza tugu za valavatia na Tamaza pa kale matuana, ko na tuni Bangara beto na inaalo aza. Ko aza za mina vadi na totozo ria na tinoni Izireli ko mari gabala pa dia sela ko mari taleozo. ");
INSERT INTO ghn_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ko gami tugu ari beto vei tugu na Ongu Tabuna za na vinazozotodi ria na zakazava ari, ko na Ongu Tabuna aza za na varivana tana Tamaza tadiria qari vatabea aza,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ego ko totonai qari nongororia ari ka viza meba pa kauniseli za vei zara, nari za qari tagigiri vikevikeredi ko mari vaipaledi qari gua ria na tinoni tagarunudi. ");
INSERT INTO ghn_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ba za soqolo turu za maka ria na Parese na izongona i Qamalieli (maka tinoni varivagigalai tugu pa Vavanau ti Mosese aza beto ko maka tinoni tapangagana tugu tadiria doru tinoni), ko za pojadi ria na tinoni kopu ko mari vavoturia iapeki totozo ria na tinoni tagarunudi za gua. ");
INSERT INTO ghn_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Beto za parangaria ria pa kauniseli, ari za gua vei, <<Ka viza tinoni Izireli! Mu dogoro viloto valeania aza gamu korapa roitini gamu tadiria na tinoni ari gamu gua. ");
INSERT INTO ghn_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nake zovaina pa viza gu ari za bola votu lame i Teudasi ko maka tinoni poreveveina aza za gua. Ria pada vei made gogoto tinoni za qari tutia aza. Ba totonai za tavauke aza, nari za ria na tinoni qari kole tututia aza za qari okoto tapipiara, ko za manyao gu za na roiti tana. ");
INSERT INTO ghn_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pa liguna aza za turu votu lame mule pa totozo qari tanguti ria na tinoni za maka tinoni Qalili, na izongona i Jiudasi. Ko maka puku minete tinoni mutugu za qari tutia aza. Ba aza ba za tavauke mutugu, ko ria qari kole tututia aza za qari okoto nyanyalia mutugu na kota. ");
INSERT INTO ghn_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ko pana ginugua taqe dogoria ani, za ani gu za na qua vavanau tadigamu: Muke kotiria ria na tinoni ari! Mu loi vakeniria gu! Ura vei mina lame veina gu pana tinoni za na nyorogua babi na roiti ani, nari za pala mina tapiaranana gu ani. ");
INSERT INTO ghn_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ba vei mina koko lame veina tana Tamaza aza, nari za pala munake boka vanogotoria gamu ria, goto pala muna raja mulea gu na Tamaza za vei,>> za gudi. Nari qari vaego betoa ria za na paranga ti Qamalieli, ");
INSERT INTO ghn_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ko qari kuku valuge sogaria ria na tinoni tagarunudi ko qari majamajaria. Beto za qari suquturia ko marike vavakato soga pa izongona i Jisu qari gudi, beto za qari loi vakeniria. ");
INSERT INTO ghn_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ko qari taloi votu keni pa kauniseli beto qari qeraqera tu ria na tinoni tagarunudi, ura qari dogoro veini maka zakazava poreveveina ria za na Tamaza za vamalumuria ko qari somana gozoroni vitigi varivakekeana ria za na izongona i Jisu. ");
INSERT INTO ghn_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Beto ko doru rane pa kakabarena na zelepade beto ko tinganai vei doru rumaruma tadiria na tinoni za qarike koroto varivagigalaini na vavakatoni ria za na nongoro leana na veveina na Karisito i Jisu qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ego pa totozo ria totonai qari kubo tugu lalaodia ria qari vazozotoa na Bangara, nari za pidoko votu za maka qumiqumi tadiria na tinoni Jiu qari parangani na paranga Qiriki. Qari qumiqumidi ria ria na tinoni Jiu qari parangani na paranga Hiburu, ura ria na tinoni Jiu qari parangani na paranga Qiriki za qari tadogoro pale pa totozo ia doru rane ria na dia nabonaboko reko. ");
INSERT INTO ghn_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nari qari kuku varikamudi ari ka manogori tinoni tagarunudi ria doru tinoni qari vazozotoa na Bangara, ko ari qari gudi vei, <<Zake leana za gami mami loi pale na paranga tana Tamaza ko mami kole gu tapatianani na ia ganigani na poata. ");
INSERT INTO ghn_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ko, ka viza tavitimami, mu mijataria ka vitu tinoni pa varikorapaimiu, ria za pugeleria na Ongu Tabuna beto na tavagigala. Ko ria za mami udukudi na roiti varivariiani na ganigani na poata ari. ");
INSERT INTO ghn_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Goto gami za mami aru tokatokai za na varavara beto na roiti ninabuluna na paranga tana Tamaza,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ego ko qari qerani ria doru tinoni qari tutia na Bangara za na roquroqu ani, ko qari mijataria ari: I Sitivini (aza na tinoni za togaza vaneqi pa rangerange beto za pugelia na Ongu Tabuna), i Pilipi, i Porokorosi, i Nikano, i Timoni, i Pamenasi, beto i Nikolasi na tinoni pa Anitioki, aza maka tinoni karovona za gabala lao pa zona vatarazae tadiria na Jiu mae perangaina. ");
INSERT INTO ghn_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ko ria ari za qari toka laodi tadiria na tinoni tagarunudi, ko qari varavaradi beto qari vaopodi na limadi. ");
INSERT INTO ghn_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ko na paranga tana Tamaza za tapiara rerege doru ia beto ko na ngutidi ria pa Jerusalema qari tutia na Bangara za zake oriavo tugu motana. Na motadi ria na iama za qari vatabea ko qari tutia za na nongorona na Bangara. ");
INSERT INTO ghn_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ego i Sitivini, za pugelia na bokaboka beto na neqi tana Tamaza, za kole roitidi zoku roiti varivagabaradi beto na vinagilagila lavatadi tadiria na tinoni. ");
INSERT INTO ghn_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ba kaki tinoni ria na somanadi pa ruma varivarikamuna tadiria na tinoni qari tagigala Na Tinoni Taruvatadi za qari podalai varigua lao ti Sitivini. Ria na tinoni Jiu ari za na lame veidi pa Sairini, pa Alekezadaria, beto pa pikata guguguzu pa Silisia beto pa Esia. ");
INSERT INTO ghn_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ba qarike boka kolosia ria za na gigalai beto na neqi tana Ongongu za izongia i Sitivini totonai za paranga. ");
INSERT INTO ghn_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ko qari peki tabara golomoria ria kaki tinoni ko ari qari gua vei, <<Gami nongoriamami gami za kole poja vikevikeria na tinoni zana i Mosese beto na Tamaza,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ko pa zona vei aza qari vatagigiriria ria na tinoni, na tiolata matamata beto na tinoni qari varivagigalaini na Vavanau ti Mosese, ko qari lame aru tamania ria i Sitivini ko qari toka laoni pa kauniseli tadiria na Jiu. ");
INSERT INTO ghn_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Beto qari tekuria ria na tinoni mari vavakato sekeseke, ko ari qari gua vei, <<Na tinoni ani za zake beto tugu poja zazaea za na zelepade madina ani beto ko na Vavanau ti Mosese. ");
INSERT INTO ghn_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ko gami nongoriamami tugu gami za ari za gudi vei aza, <Aza i Jisu na tinoni Nazareti ani za pala mina jegara paleni za na zelepade ani beto ko mina soga paledi ria na uana tututi i Mosese tu za vakarovo lame vadigita gita,> za gua,>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ego ko totonai za qari dogoro tari vatogazia ria doru qari somana nyumu pa kauniseli i Sitivini, ura na izumatana za kabere vei na izumatana na mateana. ");
INSERT INTO ghn_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ego beto za nanazia na kuta iama lavata i Sitivini, <<Ae za vei, qari zozoto tugu doru zakazava qari jutunigo ria ari?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nari za oe lao i Sitivini, ari za gua vei, <<Ka viza turaqu beto na tamaqu, mu nongoro lameziu! Na Tamaza lavata za vatadogoroni makana tana tamada i Ebarahami totonai tu za korapa suvere aza pa Mesapotamia, totonai za oqoro lao suvere pa Harani aza. ");
INSERT INTO ghn_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ko ari za gua vei za na Tamaza tana, <Mu taloi pana mua guguzu zozoto beto tadiria na mua butubutu tinoni, ko mu lao suveria na ia mana vabatinigo ara,> za guni. ");
INSERT INTO ghn_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nari za taloi pa guguzu tadiria na tinoni Kaladia i Ebarahami, ko za lao suvere pa Harani. Pana liguna tu za uke na tamana beto za pojani na Tamaza aza ko za rijo lame suveria za na ia gamu korapa suveria gamu pani koviria. ");
INSERT INTO ghn_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ba na Tamaza zake vani maka iapeki izizongo babi maka kobu pezo za pa ia pani; goto za taringutingutini za aza beto ria na tutina aza uka riza tu za mari izongia, ba pana totozo aza za oqoro pore na tuna i Ebarahami. ");
INSERT INTO ghn_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ari za paranga vei na Tamaza ti Ebarahami, <Ria na tutimu ao za mari lao suvere vei na tinoni karovodi pa maka goto guguzu, ko mari tavapinauzu na tangangangulu ka made gogoto aoro. ");
INSERT INTO ghn_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ba pana liguna aza mana vakilasia ara za na puku tinoni za vapinauzuria ria, ko mari tavavotu keni ria pana guguzu aza ko mari kamu suvere vatarazaeziu ara pana ia ani,> za gua na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Beto na Tamaza za vani maka vinagilagilana na nana paranga vinaego aza, ko na vinagilagilana na paranga vinaego aza za i Ebarahami za tapobe. Ko tonai za podo i Aisake nari za i Ebarahami ba za pobea tugu aza tonai za vesu ranena, ko i Aisake ba za pobea mutugu i Jekopi, ko i Jekopi ba za poberia mutugu ari ka manogori tuna marene, ari ka manogori tamada gita pa moa. ");
INSERT INTO ghn_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ego ko qari konokonoa tugu ari ka viza tamada zara i Josepa na taidi zozoto, ko qari vavaini ko pa Ijipi tu za gore suvere. Ba na Tamaza za suvere somana tana, ");
INSERT INTO ghn_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ko za vasarea pa doruna na nana tapata, beto za vani tugu vei na gigalai beto za tadogoro valavata pa moena i Pero, na bangara Ijipi. Beto ko i Pero za vaqavunaia pa Ijipi beto pa nana ruma aza. ");
INSERT INTO ghn_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ego beto za raja pa doruna na guguzu Ijipi beto pa Kenani za maka songe lavata, ko za kamuria na tapata lavata ria na tinoni, ko kepore ketakoi bari teku ganigani ria na tamada totonai. ");
INSERT INTO ghn_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ego totonai za nongoroni i Jekopi za pa Ijipi za kolenana na ganigani qari gua, nari za garunu vagoreria ria na tamada na totozo momoe. ");
INSERT INTO ghn_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ego na vinaori totozo qari gore, nari za i Josepa za ule vakabere vadi na boko tugana za na veveina makana. Ko totonai za gilagilaria i Pero ria pana tatamana ti Josepa. ");
INSERT INTO ghn_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ego beto za kuku vagorea i Josepa i Jekopi na tamana, beto ria doru tatamana; ari ka vitungavulu lima ria doru. ");
INSERT INTO ghn_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ko za rijo gore pa Ijipi i Jekopi, ko ketakoi za uke aza beto vei tugu ria na boko tamada gita. ");
INSERT INTO ghn_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Na kobukobu tinidi za qari tapogozo mule zae pa Sukemi, ko qari tagolomo pa leo bevi aza i Ebarahami tu za vaini poata tadiria na tuna i Hamoa pa Sukemi. ");
INSERT INTO ghn_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ego totonai za tata za na totozo beto mina vagore votua na Tamaza za nana taringutinguti za ule votuni ti Ebarahami, za qari mota tugu lalaodia ria na tinoni tadigita ko qari zoku pa Ijipi. ");
INSERT INTO ghn_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ego za turu soga pa Ijipi za maka goto bangara aza zake gilagilai i Josepa. ");
INSERT INTO ghn_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Za tutidi na nana roquroqu na bangara aza ria na nada tinoni ko za ngangaguluria ria na tamada, beto za vakoledi na vavanau ko qari vakole votu paledi ria na dia koburu melalu ko qari tavauke pale. ");
INSERT INTO ghn_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Pana totozo aza za podo i Mosese, ko maka koburu batabata leana pana tana Tamaza aza. Kue popu za tapauzu pa ruma tana tamana aza, ");
INSERT INTO ghn_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","beto totonai za tavavotu keni aza pa ruma tana tamana, nari za buti tekua na tuna reko i Pero aza ko za pauzia beto za kopu veini na tuna zozoto aza. ");
INSERT INTO ghn_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ko za tavagigalai pana doruna na varivagigalai pa Ijipi i Mosese, ko maka tinoni bokaboka pana paranga beto pana roiti aza. ");
INSERT INTO ghn_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ego totonai za madengavuluputa aorona, nari za pidoko lame pa roquna i Mosese za na roquroqu ko mi lao tu ovikiria mae ria na tavitina ria na tinoni Izireli za gua. ");
INSERT INTO ghn_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ko tonai za lao kamu nari za batia za maka tinoni Ijipi za korapa majamajai za maka tinoni Izireli. Nari za lao tu aza ko za tokani za na tinoni Izireli, ko za maja vauke pale za na tinoni Ijipi. ");
INSERT INTO ghn_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Za kole roquroqua i Mosese za palu pala mari dogoro vakaberia ria na tavitina za na Tamaza pala mina varoitia aza ko mina ruvataria ria za gua, ba qarike boka dogoro vakaberia ria za vei aza. ");
INSERT INTO ghn_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ego za rane soga mule na kota nari za batiria ari kori tinoni Izireli qari korapa varipera. Nari za lao toke vabuleria aza ari kori, ari za gudi vei, <Ei, kori qokolo, gamu kori za na tamatazi gu, ko muke varikomiti!> za gudi. ");
INSERT INTO ghn_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ba maka ari kori aza za vaimoeni na varipera za juju varijoa i Mosese, beto ari za guni vei, <I zei za mijatigo ko muna matamatadigami beto muna tutidigami gami na tinoni ao? ");
INSERT INTO ghn_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Qu nyorogua vai veiniziu na tinoni Ijipi pa nyoro ara ao?> za guni. ");
INSERT INTO ghn_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nari za uku i Mosese totonai za nongoria na paranga ani, ko za keni tu suvere veinana gu na tinoni karovona pa guguzu pa Midiani. Ko ketakoi za vaporeria aza za kori tuna marene. ");
INSERT INTO ghn_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ego pa liguna ka madengavulu aorona aza ketakoi, nari za votu tana pa qega pa kubo pa Saenai za maka mateana pa maka suvege za vurungu memea vei na iku. ");
INSERT INTO ghn_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ko totonai za batia nari za gabara i Mosese, ko za rerege tata lao ko mi dogoro valeania za gua nari za nongoria aza za na mamalaingina na Bangara, ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","<Ara za na Tamaza tadiria na tamamu; na Tamaza tadi ari Ebarahami, i Aisake, beto i Jekopi,> za gua. Za matagutu vitivitigi i Mosese ko zake boka dogoro valeania. ");
INSERT INTO ghn_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Beto za paranga lao tana za na Bangara: <Mu ruvata vagoreria na sadolo pa nenemu, ura na ia qu korapa turua zana za na pezo madina. ");
INSERT INTO ghn_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Qa tori batia tu ara za na vitigi tadiria na qua tinoni qari korapa pa Ijipi beto qa tori nongoria tu ara za na lukana uuidi, ko qa gore lagere ara ko mana aloria. Ko koviria mana garunu gorenigo pa Ijipi ara ao,> za gua za na Bangara. ");
INSERT INTO ghn_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ko i Mosese tugu ani, aza qari kilu paleni ria beto ari qari paranga veini, <I zei za mijatigo ko muna matamatadigami beto muna varitutidigami gami ao?> qari guni, za aza tugu za garunia na Tamaza ko aza za na dia tinoni matamata beto za ruvataria pa varitokai tana mateana za votu pa iku za vuruvurungu pa suvege. ");
INSERT INTO ghn_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Aza tugu i Mosese ani za toka votudi beto za roitidi na roiti beto na vinagilagila varivagabaradi pa Ijipi, pa Kolo Jemere, beto pa qega, pa korapana ka madengavulu aoro. ");
INSERT INTO ghn_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","I Mosese tugu ani za ari za poja veidi ria na tinoni Izireli, <Maka tinoni korokorotai vevei ara ko na tinonimiu zozoto gamu za mina vaturu vadigamu na Tamaza,> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ko i Mosese za na somanana tugu tadiria na varikamu tinoni pa qega, ria na tamada, beto ko za somana vavakato tavitia na mateana pa kubo pa Saenai. Ko aza za tekua za na vavanau toana, beto za vakamu lamea tadigita. ");
INSERT INTO ghn_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ego ba qari daidia vatabea ria na tamada i Mosese, goto qari kilu paleni tu beto na bulodi za gabala mulenana pa Ijipi. ");
INSERT INTO ghn_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Beto ari qari guni vei i Eroni, <Mu roiti vadigita kaki nada tamaza ko mari tokagita moko. Goto aza i Mosese ani, aza za toka votudigita pa Ijipi, za koviria taqeke gilagilai na manugu za beka za varajani!> qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ko pa totozo ria za qari roitini ria za maka beku bulumakau, ko qari vavavui lao tana beto ko qari qerani za na roitina na limadi gu makadi. ");
INSERT INTO ghn_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nari za kiludi na Tamaza ria ko za loi laodi ko qari vatarazaeria ria na seru pa noka, vei za takuti pa buka tadiria na tinoni korokorotai, aza ari za gua vei, <Ka viza tinoni Izireli, nake taqu gamu pogozo lamedi ria na miu varivana beto na vavavui pa korapana ka madengavulu aoro pa qega. ");
INSERT INTO ghn_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Na ruma aqaqo vavavuina gu tana tamaza Moleki za gamu pogozia gamu, beto ko na beku kirena tu i Raipani, na miu tamaza seru, beto ria tu na beku gamu roitidi makamiu za gamu vatarazaeria. Ko pala mana adu vaqavaqata laolamedigamu ara pa guguguzu zoudi, pa maka kale laona pa Babiloni za gamu,> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Na ruma aqaqo tabuna, aza na vinagilagilana na Tamaza za somana tadiria, za qari izongia pa qega ria na tamada pa moa. Na aqaqo tabuna aza za taroiti tuti vei tugu aza na Tamaza za garununi i Mosese ko mina roiti tuti veini aza na kirena za vabatini. ");
INSERT INTO ghn_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ko aza za na aqaqo tabuna qari teku vakarovia ria na tamada pa moa, ko pa totozo ti Josua qari pogozia tugu aza totonai qari luge lao ko na Tamaza za jupe vakeniria ria na puku tinoni qari suvere pa guguzu ani. Ko na aqaqo tabuna aza za kole kamua tu na totozo ti Devita. ");
INSERT INTO ghn_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ko na Tamaza za qerani i Devita, ko za tepa laoa aza za na Tamaza ko mi roitini za maka ruma tabuna tana Tamaza ti Jekopi za gua. ");
INSERT INTO ghn_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ba i Solomone tu za vaturu vani na ruma aza. ");
INSERT INTO ghn_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ba na Tamaza ululuna jola za zake suvere pa ruma za taroiti pa limana na tinoni, za vei za pojai na tinoni korokorotai, aza ari za gua vei, ");
INSERT INTO ghn_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","<Na noka za na qua nyumunyumuna bangara, goto na pezo za na qua tetetena. Ko na ruma ae veveina mule za muna vaturu vaniziu ao, za gua za na Bangara, babi ae ia minyeminyerena veveina za taqu? ");
INSERT INTO ghn_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ae vei? Nake pa limaqu makaqu ara qa roitidi doru zakazava ari?> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Boko duviduvili! Za patu na bulomiu beto zake lea tavonga na talingamiu za gamu! Gamu za doru totozo gamu upele pale na Ongu Tabuna, qari vei tugu ria na tamamiu za gamu vei tugu za gamu! ");
INSERT INTO ghn_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","I zei mae za maka tinoni korokorotai barike koti ngangagulia ria na tamamiu? Qari vai paledi ria qari korokorotaini na lame tana nabulu tuvizina, ko koviria na nabulu tuvizina aza za gamu gamu gabala kanai beto gamu vaukea. ");
INSERT INTO ghn_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ba gamu tugu za gamu teku vakarovia za na vavanau qari valameria na mateana ba gamuke tutia tu za na vavanau aza,>> za gua i Sitivini. ");
INSERT INTO ghn_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ego ko totonai qari nongoria ria na meba pa kauniseli za na paranga ti Sitivini, nari za qari tagigiri vitivitigi ko qari garata ngaburukae tu. ");
INSERT INTO ghn_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ba i Sitivini, za tapugeleni na Ongu Tabuna, za enga zae pa noka za gua, nari za batia za na malakapi tana Tamaza beto za batia i Jisu za korapa turunana pa kale matuana na Tamaza. ");
INSERT INTO ghn_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Beto ari za gua vei, <<Dotu ko!>> <<Qa batia na noka za tarevanga, ko na Tuna na Tinoni za korapa turunana pa kale matuana na Tamaza,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ego totonai za qari kuku iranga, ko qari suqutudi na limadi za na talingadi, beto ko qari makarai abutu toto laoia aza. ");
INSERT INTO ghn_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Qari ragata votuni pa peguruna na guguzu, beto qari kole buti tarini patu aza. Ria na tinoni qari somana lame dogoria na tagonana i Sitivini za qari vagoreria na dia poko ko qari vakoleria pa kekere nenena maka tinoni koregana, na izongona i Saula. ");
INSERT INTO ghn_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ko totonai qari korapa gonagonai ria, nari za ari za varavara kiu alili vei i Sitivini, <<Kei, Bangara Jisu, mu teku vakarovia na ongonguqu,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Pa liguna za poja vei zara, nari za nyumu sori tungutungu pa pezo, ko za velavela vei ari, <<Kei Bangara, muke nguti taridi ria ari za na dia sela ani,>> za gua, beto za loia za na singo. ");
INSERT INTO ghn_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ego ko pa ranena tugu aza za podalai takomiti vikevikere za na ekelesia pa Jerusalema, ko ria doru tinoni vazozoto za qari okoto tapiara lao vei tu pa ia pikata guguzu pa Jiudia beto pa Sameria, goto ria na tinoni tagarunudi gu za qarike keni. ");
INSERT INTO ghn_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Goto kaki ria na tinoni za neqi na dia rangerange za qari lao lukana romaromai beto qari keni golomia za na kobukobu tinina i Sitivini. ");
INSERT INTO ghn_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","I Saula za mi vamanyao pale za na ekelesia za gua, ko za luge makamakaria ria na ruma tadiria na tinoni, ko za ragata votuvotudi ria doru qari vazozotoa na Bangara, maqota na marene, ko za valugeria pa ruma varipiuna. ");
INSERT INTO ghn_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ego ko ria tugu qari okoto tapiara lao vei doru kota za qari vavakatoni rerege za na paranga tana Bangara. ");
INSERT INTO ghn_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ko maka ria i Pilipi. Za lao aza pa guguzu pa Sameria, ko za tarae velavelani tadiria na tinoni ketakoi za na veveina na Karisito. ");
INSERT INTO ghn_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ego ko totonai qari nongoria beto qari batiria ria na roiti varivagabaradi za roitidi i Pilipi, nari za qari makarai vainongoro valeanadi ria na puku minete tinoni ria na tinarae ti Pilipi. ");
INSERT INTO ghn_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ria na zoku za koleria na ongongu ikeredi za qari lukana gagateana totonai za ijiju votu paledi aza tadiria ria na ongongu ikeredi, beto zoku ria za uke kale kaki kobu tinidi beto qari qao za qari tasalana tugu. ");
INSERT INTO ghn_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ko qari qera beto ria doru pa guguzu aza. ");
INSERT INTO ghn_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ego na suverena tugu pa guguzu aza za maka tinoni porenana potana varivagabarana, na izongona i Saimone. Ko za tori dori zovai tu qari kole gabagabarani ria na tinoni Sameria ria na nana roiti varivagabaradi za kole roroitidi pa nana potana. Ko makana ba za pojai za maka tinoni poreveveina jola aza za gua. ");
INSERT INTO ghn_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ko na guguzu doruna, peki na lavata, za perangaina qari kole vainongoro lao valeanani aza, beto ari qari gua vei, <<Ani tugu aza na neqi tana Tamaza, aza za tagigala na Neqi Lavata,>> qari gugua. ");
INSERT INTO ghn_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ko na totozo kakazana za qari kole nongonongoro valeania ria aza, ura za kole valoposo gabaradi na nana potana. ");
INSERT INTO ghn_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ba totonai qari vazozotoa ria za na nongoro leana na veveina na binangara tana Tamaza beto na veveina na izongona i Jisu Karisito za taraeni i Pilipi, nari za qari paputaiso beto ria, na maqota na marene. ");
INSERT INTO ghn_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ko i Saimone makana ba za somana vazozoto tugu ko za paputaiso beto za kole tututia i Pilipi. Ko tonai za batiria aza ria na roiti varivagabaradi beto na roiti neqidi lavalavata ti Pilipi, nari za kole gabagabaranana. ");
INSERT INTO ghn_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ego totonai qari nongoroni ria na tinoni tagarunudi pa Jerusalema za na veveina qari tori teku vazozotoa tu ria pa Sameria za na paranga tana Tamaza, nari za qari garunu goredi tadiria ari Pita i Jone. ");
INSERT INTO ghn_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ko totonai qari gore kamu, nari za qari varavaradi ria qari vazozoto ko mari tekua na Ongu Tabuna qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","(Ura qari tapaputaiso gu pa izongona i Jisu na Bangara ria, goto za oqoro goreria na Ongu Tabuna.) ");
INSERT INTO ghn_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ko qari vaopodi na limadi ari Pita i Jone ria, ko qari tekua za na Ongu Tabuna. ");
INSERT INTO ghn_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ego totonai za batia i Saimone za totonai qari vaopodi na limadi ria na tinoni tagarunudi nari qari tekua na Ongu Tabuna ria na tinoni, nari za pogozo lame vadi na poata ari kori, ");
INSERT INTO ghn_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ko ari za gua vei, <<Ara ba mu vaniziu tugu za na neqi zana, ko aza ma vaoponi na limaqu nari mi tekua tugu za na Ongu Tabuna,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nari za oe lao tana i Pita, <<Na mua poata siliva beto ao za mu uke manyaomiu! Ura qu roquroqua muna vaini na poata ao za na varivana tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kepore na iamu beto nake somanamu pa roiti gami korapa roitini gami ani ao, ura na bulomu za zake gozoro pa dogodogoro tana Tamaza. ");
INSERT INTO ghn_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mu gabala ko mu loi pale za na mua roiti ikikerena ani beto ko mu varavara lao tana Bangara, ko aza mi taleozonigo za na mua roquroqu ikerena za kole pa bulomu. ");
INSERT INTO ghn_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ura qa batia ara za pugeligo na konokono nyonyorogua beto qu korapa tapiu pa mua sela ao,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nari za tepa lao i Saimone, ari za gua vei, <<Ego, mu varavara lao vaniziu tu tana Bangara ropi, ko mike taroiti taqu aza qu guni ao zana,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ego pa liguna qari poja vaneqineqini beto qari varivagigalaini ari kori za na paranga tana Bangara, nari za qari gabala mule pa Jerusalema. Pana dia rerege mule za qari kole vavakatoni za na nongoro leana tinganai vei guguzu pa Sameria. ");
INSERT INTO ghn_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ego maka mateana tana Bangara za lame ti Pilipi, ko ari za gua vei, <<Mu turu ko mu taloi zae keta pa kale gorena pa zona za koko pa Jerusalema ko za gore vei pa Qaza, na zona qega,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Nari za taloi i Pilipi ko za keni. Ko pa nana rerege za lao kamua aza za maka tinoni Itiopia. Maka tinoni matamata poreveveina aza, beto maka nabulu za kopudi na izizongo ti Kanadesi, na kalao pa Itiopia. Na tiolata ani za zae somanani na vinatarazaena na Tamaza pa Jerusalema, ");
INSERT INTO ghn_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ko pa totozo aza za korapa mule keni nana. Ko za korapa zae goregorenana pa nana topitopilina aza, beto za korapa tiroa aza za na buka ti Aisea na tinoni korokorotai. ");
INSERT INTO ghn_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nari ari za gua vei ti Pilipi za na Ongu tabuna, <<Mu lao ko mu rerege tata pa topitopilina zana,>> za guni. ");
INSERT INTO ghn_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nari za abutu tata lao pa topitopilina i Pilipi za gua, nari za nongoria za korapa tiroa aza za na kutikuti ti Aisea na tinoni korokorotai, ko za nanazia, <<Ae vei qu gilagilaimua tugu ao na ginuana aza qu korapa tiroa zana?>> za guni. ");
INSERT INTO ghn_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nari za oe lao za na tiolata aza, <<Qokolo, ko bi mija tu! Kepore maka tinoni bi vakabere vaniziu vei ari, za ae vei beto mana boka vakaberia?>> za gua. Ko za kukua i Pilipi, nari za keza i Pilipi ko za nyumu tavitia pa topitopilina. ");
INSERT INTO ghn_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na kobu kutikuti ti Aisea za kole tiroa aza za ari za gua vei, <<Za maka moqaza podeke vei na sipi za tatoka lao ko mina takubolo vauke aza, beto za vei tugu na lami zake vaqeu pa moena na tinoni za ngabungabuturia na vurungu sipi, nari za aza ba zake izongo vaqeu podeke tugu. ");
INSERT INTO ghn_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Za tavakea pa ngangangulu beto zake tatoka totonai qari pitua. Kepore maka tinoni bi gilagilai na tutina, ura za tateku pale pa pezo za nana toa,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ego ko za nanaza laoia na tiolata ani i Pilipi, <<Mu ule vaniziu, na veveina i zei za pojai na tinoni korokorotai ani? Na veveina makana tugu, ba maka goto tinoni tu?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nari za podalai vavakato tugu pa titiro ani i Pilipi, ko za vakabere lao vani za na nongoro leana na veveina i Jisu. ");
INSERT INTO ghn_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ego ko pa korapana na dia rerege gore pa zona ari kori za qari kamua za maka ia za kolea na pie, nari za paranga lao ti Pilipi za na tiolata ani, <<Dotu ko, zana gu za na pie! Ae za vei ko manake boka tapaputaiso ara?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ko za vanogotoia na tiolata za na topitopilina, ko qari makarai gore pa pie ari kori Pilipi, ko za paputaisoia i Pilipi aza. ");
INSERT INTO ghn_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Totonai qari paro pa pie ari kori, nari zake oriavo tugu oqanai toka vakenia na Ongonguna na Bangara i Pilipi, ko na tiolata ani zake bati sogai i Pilipi. Beto za tutia na zona ko za qeraqera mi keni nana za na tinoni aza. ");
INSERT INTO ghn_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Goto i Pilipi za pa guguzu pa Azotasi mule za tabata. Ko za rerege vavakatoni aza za na nongoro leana tadiria doru guguguzu, tinganai za kamu tu pa Sizaria. ");
INSERT INTO ghn_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ego ko i Saula za kole singo manginidi za nana paranga varivamatagutu ko mina vaukeria ria na sepele tana Bangara za gua. Ko za lao aza tana kuta iama lavata, ");
INSERT INTO ghn_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ko za teparia ria na leta mari lao tadiria pa ruma varikamudi pa Damasikasi, ko vei mina bati poaria ria qari tutia na Zona tana Bangara, nari za mina piuria, marene na reko, ko mina toka muledi pa Jerusalema za gua. ");
INSERT INTO ghn_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ego ko pa nana rerege lao ko za tata kamua pa Damasikasi aza, za malara votu lame vasiboro pa noka za maka kabere ko za gona varilivutai lao tana. ");
INSERT INTO ghn_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nari za lotu gore pa pezo aza, beto za nongoria za maka mamalaingi ari za gua vei, <<Saula! Saula! Ae za vei ko qu komitiziu ara ao?>> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nari za oe lao aza, <<I zei ao, Bangara?>> za gua. Nari ari za gua vei aza, <<Ara i Jisu aza qu korapa komitia ao. ");
INSERT INTO ghn_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ba mu turu, ko mu luge lao pa guguzu pa Damasikasi, ko ketakoi tu pala mina taule vanigo aza muna roitini ao>> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ko ria na tinoni qari somana tutia i Saula za qari turu ke vagala gu koledia. Qari nongoriadia tugu za na mamalaingi, ba qarike batia na tinonina. ");
INSERT INTO ghn_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Beto za turu pa pezo i Saula, ko mi vaiqolia za na matana za gua, ba zake boka batabata. Ko qari arua gu na limana beto qari tita laoni pa Damasikasi aza. ");
INSERT INTO ghn_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ko kue rane zake batabata, zake tekuteku na buku aza. ");
INSERT INTO ghn_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ego ko na suverena tugu pa Damasikasi za maka sepele, na izongona i Hananisi. Ko na Bangara za paranga tana pa dogodogoro, <<Hananisi!>> za guni. <<Ani ara, Bangara,>> za gua aza. ");
INSERT INTO ghn_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Nari za paranga lao tana za na Bangara, <<Mu turu, ko mu lao pa zona na izongona Tuvizi, ko mu nyaqoa pa ruma ti Jiudasi za maka tinoni pa Tasosi, na izongona i Saula. Ura za korapa varavara aza, ");
INSERT INTO ghn_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ko za tori batia tu aza pa dogodogoro za maka tinoni na izongona i Hananisi za luge ko za vaoponi na limana aza ko mi batabata soga za gua,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nari za oe lao i Hananisi, <<Bangara, qa tori nongoroni tu tadiria kubo tinoni ara na veveina za na tinoni ani, ko na kubo ngangangulu za tori roitidi tu tadiria na tinoni tamu pa Jerusalema ani. ");
INSERT INTO ghn_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ko koviria za teku neqi tadiria na kuta iama aza, ko mina piu tekuria ria doru qari vatarazaego ao,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nari za paranga lao tana za na Bangara, <<Mu lao gu, ura ani za na tinoni tamijatana taqu ko mina pogozo laoni na izongoqu tadiria na tinoni karovodi, tadiria na bangabangara, beto ko tadiria na tinoni Izireli. ");
INSERT INTO ghn_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ura ara mana vabatini ria na vitigi mina gozoro taleni na izongoqu ara aza,>> za gua za na Bangara. ");
INSERT INTO ghn_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nari za taloi lao i Hananisi, ko za lao tugu kamua za na ruma za suveria i Saula, ko za vaoponi na limana aza. Beto ari za guni vei, <<Saula, taiqu, na Bangara, aza i Jisu za votu tamu totonai qu korapa lamelamemua ao pa zona, za garunuziu ara, ko ao mu boka batabata soga beto ko mu tavapugeleni na Ongu Tabuna za gua,>> za gua. ");
INSERT INTO ghn_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Pana totozo tugu aza za lotu pa matana i Saula za maka za za vei na kadena na igana, ko za batabata soga aza. Beto za turu ko za tapaputaiso aza, ");
INSERT INTO ghn_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","beto pa liguna za tekuteku nari za neqi soga za na tinina. Ego ko za suvere tavitiria ria qari vazozotoa na Bangara pa Damasikasi ka viza rane mae tu i Saula. ");
INSERT INTO ghn_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ego beto nake zovaina za podalai tarae velavelani gu i Saula pa doru ruma varivarikamuna i Jisu, ko i Jisu tugu za na Tuna na Tamaza za gua. ");
INSERT INTO ghn_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ko ria doru qari nongoria aza za qari gabara beto, ko ari qari gua vei, <<Qokolo, ani tugu za na tinoni za komiti vikevikereria ria pa Jerusalema, ria qari vatarazaea nizongona tugu na Bangara ani! Ko na kuta lame tana pani za mina piu tekuria ria na tinoni vevei ria ko mina toka mule laodi tadiria na kuta iama za gua!>> qari gua. ");
INSERT INTO ghn_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ba zake mako gore za na neqina na tarae ti Saula, 