﻿USE sofia;
DROP TABLE IF EXISTS sofia.gel_vpl;
CREATE TABLE gel_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gel_vpl WRITE;
INSERT INTO gel_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","U̱r-taku̱n, Ru̱-u̱ no̱mu̱g do̱m u-ru̱, u-dak-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","U̱ da-u o̱ dak-u̱ zatte̱ u̱ka u̱t-senu̱sse̱ da, tu̱msu̱ o̱ zatte̱ o̱ko̱n da, cwu̱m-u̱ taku̱ste̱ shu̱-u̱ radu̱ m-bu̱, tu̱msu̱ Yar-u u-Ru̱ o̱ u̱t-riig u̱-do̱m m-bu̱. ");
INSERT INTO gel_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Se̱ Ru̱-u̱ zu̱, <<Yage̱ u̱ zu̱n-mu̱ rwu̱u̱n.>> Se̱ zu̱n-mu̱ mok. ");
INSERT INTO gel_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Se̱ Ru̱-u̱ hog u̱r-zwar u̱ zu̱n-mu̱ mok-te̱. Se̱ wa ké m-zu̱n du̱gu̱ u-cwu̱m. ");
INSERT INTO gel_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ru̱-u̱ fog m-zu̱n <<U-ho̱.>> Tu̱msu̱ wa fog u-cwu̱m <<M-gyu̱p.>> U̱ da-u o̱ na kume̱ m-rim tu̱msu̱ na kum u̱r-wu̱n. De̱ o̱ ho̱-du̱ u̱r-taku̱n. ");
INSERT INTO gel_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Se̱ Ru̱-u̱ zu̱, <<Yage̱ hu̱k-du̱ shu̱'u̱t du̱ do̱'e̱ u̱ ke̱-du̱ bu̱-mu̱ o̱ do̱m u̱ bu̱-mu̱ o̱ ta u-dak-ne̱, tu̱msu̱ yage̱ de̱ kè̱ m-bu̱ u-yu̱r.>> ");
INSERT INTO gel_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ru̱-u̱ nom u̱r-hu̱k de̱ keet-u̱t m-bu̱ mu̱ o̱o̱ge̱ do̱m-u̱ hu̱k-du̱ u-ru̱ u̱ bu̱-mu̱ o̱o̱ge̱ u̱-ta u̱r-hu̱k ne̱. Tu̱msu̱ iya o̱ nomte̱ u̱ka Ru̱-u̱ zu̱tte̱. ");
INSERT INTO gel_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ru̱-u̱ fog hu̱k-u̱r re̱, <<Hu̱k-du̱ do̱m u-ru̱.>> U̱ da-u o̱ na kume̱ m-rim tu̱msu̱ na kum u̱r-wu̱n, de̱ o̱ ho̱-du̱ u-yu̱ru̱mse̱. ");
INSERT INTO gel_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Se̱ Ru̱-u̱ zu̱, <<Yage̱ bu̱-mu̱ o̱o̱ge̱ ta-u̱ hu̱k-du̱ do̱m u-ru̱ mo̱ karu̱g u̱r-be u̱r-gan, tu̱msu̱ yage̱ u̱ dak-u u-gagu̱n rwu̱u̱n.>> Tu̱msu̱ iya o̱ nomte̱ u̱ka Ru̱-u̱ zu̱tte̱. ");
INSERT INTO gel_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ru̱-u̱ fog gas-u̱ o̱o̱ge̱ u-gagu̱n <<u-dak.>> Tu̱msu̱ bu̱-mu̱ karge̱ u̱r-be u̱r-gan wa fog mo̱ <<M-sa.>> Se̱ Ru̱-u̱ hyen no̱m-u̱ wa no̱me̱ no̱ng u̱ so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Se̱ Ru̱-u̱ zu̱, <<Yage̱ dak-u̱ apu̱n go̱-tu̱ u̱t-ku̱wu̱t u̱s-te ne̱ su̱ mu̱te̱ u̱t-ya u̱ go̱ ne̱ u̱-me̱ to̱. Ko̱yu̱he̱ u̱ka du̱ wa go̱-de̱.>> Tu̱msu̱ iya o̱ nomte̱ u̱ka Ru̱-u̱ zu̱tte̱. ");
INSERT INTO gel_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Iya o̱ hen dak-u̱ apu̱n go̱-tu̱ u̱t-ku̱wu̱t tu̱ mat-du̱ go̱ ko̱yu̱he̱ u̱ka go̱-u̱r wa o̱tte̱ u̱ u̱s-te ne̱ su̱ mu̱te̱ u̱t-ya u̱ go̱ ne̱ me̱. Se̱ Ru̱-u̱ hyen no̱m-u̱ wa no̱me̱ no̱ng u̱ so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","U̱ da-u o̱ na kume̱ m-rim tu̱msu̱ na kum u̱r-wu̱n, de̱ o̱ u̱ ho̱-du̱ u-tu̱tu̱rse̱. ");
INSERT INTO gel_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Se̱ Ru̱-u̱ zu̱, <<Yage̱ zu̱n-mu̱ shu̱'u̱t u̱ hu̱k-du̱ do̱m u-ru̱ u̱ kè̱ u-ho̱ u̱ m-gyu̱p ne̱, tu̱msu̱ yage̱ to̱ shu̱'u̱t u̱s-nap su̱ ko̱se̱-du̱ u-da, u̱t-ho̱ ne̱, tu̱msu̱ u̱s-hak ne̱. ");
INSERT INTO gel_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Tu̱msu̱ yage̱ to̱ shu̱'u̱t u̱ka m-zu̱n u̱ hu̱k-du̱ do̱m u-ru̱ u̱ ya' m-zu̱n u̱-do̱m u-dak.>> Tu̱msu̱ iya o̱ nomte̱ u̱ka Ru̱-u̱ zu̱tte̱. ");
INSERT INTO gel_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ru̱-u̱ no̱ng zu̱n-m yat-mo̱ m-yu̱r, zu̱n-m yat-mo̱ mo̱ no̱m faru̱k-du̱ u-ho̱ tu̱msu̱ zu̱nu̱n-m re̱k-mo̱ no̱m faru̱k-du̱ m-gyu̱p. Tu̱msu̱ wa nom re̱ge̱r. ");
INSERT INTO gel_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ru̱-u̱ sak u̱r-ho̱, u-pyaat u̱ re̱ge̱r ne̱ u̱-do̱m u-ru̱, remu̱ e̱ ye'et m-zu̱n u-dak, ");
INSERT INTO gel_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","remu̱ e̱ no̱m-u̱t faru̱k-du̱ u-ho̱ m-gyu̱p ne̱, tu̱msu̱ u̱ kè̱ m-zu̱n du̱gu̱ u-cwu̱m. Se̱ Ru̱-u̱ hyen no̱m-u̱ wa no̱me̱ no̱ng u̱ so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","U̱ da-u o̱ na kume̱ m-rim tu̱msu̱ na kum u̱r-wu̱n, de̱ o̱o̱ge̱ ho̱-du̱ u-nasu̱rse̱. ");
INSERT INTO gel_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Se̱ Ru̱-u̱ zu̱, <<Yage̱ u̱ bu̱-mu̱ rwu̱u̱tu̱n no̱m u̱r-fat u̱ shi m-bu̱, tu̱msu̱ u̱ no ne̱ u̱ yu̱ne̱ u̱t-kap u̱ do̱m hu̱k-du̱ u-ru̱.>> ");
INSERT INTO gel_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Iya o̱ Ru̱-u̱ nomte̱ no̱m-u̱ u̱r-fat i-yate̱ m-sa, tu̱msu̱ ko̱yu̱he̱ no̱m u̱r-fat ne̱ tu̱ o̱o̱ge̱ m-yu̱ u̱-me̱ m-bu̱, ko̱wan u̱ du̱ wa go̱-de̱, tu̱msu̱ u̱ ko̱yu̱he̱ no yu̱ u̱t-kap ne̱ ko̱wan u̱ du̱ wa go̱de̱. Se̱ Ru̱-u̱ hyen no̱m-u̱ wa no̱me̱ o̱ u̱ so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Se̱ Ru̱-u̱ wa'-u̱ to̱ nu-u so̱-o̱ wa zu̱, <<De̱e̱n no̱ mat yaag no̱ sur u-tát no̱ shi m-sa, tu̱msu̱ yage̱ no e̱ sur u-tát e̱ shi u-dak.>> ");
INSERT INTO gel_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","U̱ da-u o̱ na kume̱ m-rim tu̱msu̱ na kum u̱r-wu̱n, de̱ o̱ ho̱-du̱ u-tanu̱rse̱. ");
INSERT INTO gel_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ru̱-u̱ zu̱, <<Yage̱ dak-u̱ rwu̱tu̱n ko̱-uyan go̱-du̱ no̱m-tu̱ u̱r-fat tu̱ o̱o̱ge̱ u̱t-kurup kowan u̱du̱ wa go̱-de̱, bisa-tu̱ u-bu u̱ no̱m u̱r-fat ne̱ u̱ i o̱o̱ge̱ u̱t-kurup ne̱ u̱-do̱m u-dak u̱ bisa-tu̱ u̱r-do̱g ne̱ u̱ ko̱-uyan no̱m-u̱ u̱r-fat ne̱.>> Iya o̱ nomte̱ u̱ka Ru̱-u̱ zu̱tte̱. ");
INSERT INTO gel_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Iya o̱ Ru̱-u̱ nomte̱ bisa-tu̱ u-dak u̱t-be̱e̱t ko̱-uyan no̱m u̱r-fat be̱e̱t ko̱yu̱he̱ u̱ka du̱ wa go̱-de̱. Wa no̱mu̱g bisa-tu̱ u-bu u̱ no̱m u̱r-fat ne̱ u̱ i u̱t-kurup be̱e̱t u-dak ko̱yu̱he̱ u̱du̱ ya go̱-de̱. Se̱ Ru̱-u̱ hyen no̱m-u̱ wa no̱me̱ no̱ng u̱ so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Se̱ Ru̱-u̱ zu̱, <<Yage̱ it no̱m ne̱t wu̱ o̱tte̱ u-ryu̱n u̱ sha-m in. Yage̱ e̱ no̱m u̱r-faru̱k u̱ do̱m-u̱ jan m-bu̱, u̱ do̱m-u̱ no ne̱, tu̱msu̱ u̱ do̱m-u̱ bisa-tu̱ u-bu ne̱, tu̱msu̱ dak u-be̱e̱t ne̱, tu̱msu̱ no̱m-u̱ u̱r-fat ne̱ be̱e̱t i o̱ u̱t-kurup u̱ u-dak u-be̱e̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","I ya-o̱ Ru̱-u̱ no̱m-te̱ ne̱t u̱-me̱ sha-m wa, u̱-me̱ sha-mu̱ Ru̱-u̱ o̱, Ru̱-u̱ no̱m-te̱ ne̱t, campa u̱ ne̱ta Ru̱-u̱ nom e̱. ");
INSERT INTO gel_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Se̱ Ru̱-u̱ wa'-u̱ u̱n nu-u so̱-o̱ wa zu̱, <<De̱e̱n no̱ mat yaag, yage̱ e̱ no̱m u-tát, e̱ shi u-dak u-be̱e̱t tu̱msu̱ e̱ no̱m faru̱k-du̱ o̱. E̱ no̱m faru̱k-du̱ jan-u̱ me̱ m-sa, tu̱msu̱ u̱ do̱m-u̱ no ne̱ i do̱m-u̱ u-ru̱, tu̱msu̱ u̱ do̱m-u̱ ko̱-uyan no̱m-u̱ u̱r-fat u̱ o̱ u̱-do̱m u-dak.>> ");
INSERT INTO gel_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Se̱ Ru̱-u̱ zu̱, <<U̱m yaag no̱ ko̱-uyan go̱-du̱ ku̱-u o̱ u-be̱e̱t u̱ mu̱te̱ yaag u-dak u-be̱e̱t tu̱msu̱ u̱ ko̱-uyan go̱-yu̱ u-te yu̱ o̱tte̱ u̱t-ya u̱ go̱ ne̱ u̱-me̱ ya. To̱ shu̱'u̱t no̱m-tu̱ u̱t-re̱ no̱. ");
INSERT INTO gel_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","U̱m yaag u̱t-ran u̱t-gwa ne̱ u̱t-be̱e̱t to̱ u̱ shu̱'u̱t no̱m u̱t-re̱ u̱du̱ ko̱-uyan bisa-o̱ u̱ o̱ u-dak, ko̱-uyan no-ya u̱-do̱m u-ru̱, tu̱msu̱ ko̱yu̱he̱ no̱m-yu̱ u̱r-fat ya yu̱ o̱ u̱t-kurup u-dak, u̱ no̱m-u̱ o̱ u̱r-fat ne̱ u-be̱e̱t.>> Tu̱msu̱ iya o̱ nomte̱ u̱ka Ru̱-u̱ zu̱tte̱. ");
INSERT INTO gel_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Se̱ Ru̱-u̱ hyen no̱m-u̱ wa no̱me̱ u-be̱e̱t, o̱ no̱mu̱g u̱ so̱-o̱ sok. Se̱ na kum u̱r-wu̱n tu̱msu̱ na kum m-rim, de̱ o̱ ho̱-du̱ u̱t-shishin. ");
INSERT INTO gel_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Iya-o̱ Ru̱-u̱ taaste̱ no̱m-du̱ do̱m u-ru̱ u-dak-ne̱, u̱ no̱m-tu̱ o̱ me̱ ne̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Kanda ho̱-du̱ u̱r-ta'er u̱, Ru̱-u̱ taaste̱ no̱m-du̱ ank-mu̱ wa o̱o̱ge̱ u̱t-no̱m u-be̱e̱t; se̱ wa hure̱ du̱gu̱ ank-m wa u̱ ho̱-du̱ u̱r-ta'er. ");
INSERT INTO gel_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Se̱ Ru̱-u̱ wa'-u̱ ho̱-du̱ u̱r-ta'er nu-u so̱-o̱, wa muut de̱ ho̱-du̱ u-he̱n. Ru̱-u̱ no̱ng iya remu̱ zu̱ u̱ ho̱-u̱r re̱ wa hure̱ du̱gu̱ ank-mu̱ wa no̱me̱ m-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Tun-to̱ to̱ o̱o̱ge̱ ogu̱r-tu̱ do̱m u-ru̱ u̱ u-dak-ne̱ da na tase̱ no̱m-du̱ to̱. Da Yawe u-Ru̱ no̱me̱ u-dak u̱ do̱m u-ru̱ ne̱, ");
INSERT INTO gel_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","tu̱msu̱ gwa-tu̱ zaar tu̱ apne̱ u-dak da. Tu̱msu̱ ku̱w-u̱t tu̱ zaar tu̱ rwu̱ne̱ u-dak da, remu̱ zu̱ Yawe Ru̱-u̱ wa'ag yu̱-u̱ rob da uro, tu̱msu̱ ne̱t zaar wu̱ de̱ u̱ ku̱w u̱r-to̱m ne̱ u-dak da. ");
INSERT INTO gel_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Se̱di rap-u̱t u̱ rwu̱u̱n du̱gu̱ u-dak, o̱ mu̱st u-dak u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Se̱ Yawe u-Ru̱ nom ne̱t u̱ rwab-tu̱ u-dak. Wa fur mya-mu̱ u̱r-fat u̱ swa-du̱ ne̱t, se̱ ne̱t kum u̱r-fat. ");
INSERT INTO gel_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Yawe u-Ru̱ zo̱ngte̱ u-tak, u̱ de̱ku̱n be-de̱ du̱ na foge̱ Idin, gas-u̱ ho̱-du̱ rwu̱tu̱n. Ku̱na wa cinte̱ ne̱t-u̱ wa no̱me̱. ");
INSERT INTO gel_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Yawe u-Ru̱ wa'ag ko̱-uyan go̱-du̱ u-te ya u̱ apu̱n ku̱n, te-su̱ o̱ zwarru̱ m-hyan ne̱ tu̱msu̱ u̱ zwarru̱ u̱t-re̱ ne̱. Te-yu̱ u̱r-fat o̱ro te̱k-u̱ tak-u o̱. U̱ te-yu̱ wadu̱ ne̱t-ne̱ u̱ nap-mu̱ no̱m-u̱ so̱-o̱ u̱ no̱m-u yo̱-o̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Gi-yu̱ yu̱'e̱ u-tak m-bu̱ ya jagu̱n du̱gu̱ Idin, du̱gu̱ ku̱n ya mot m-te u̱s-gi u̱s-nas. ");
INSERT INTO gel_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Dim-du̱ gi-yu̱ u̱r-taku̱n na zu̱ ya Piso̱n. Gi-u ya gu̱pe̱ m-nar gas-u̱ dak-u̱ Havira u-be̱e̱t, be-du̱ o̱tte̱ kwam-tu̱ shik tu̱ bu̱-mu̱ u̱t-ro. ");
INSERT INTO gel_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Kwam-tu̱ shik tu̱ dak-u̱ Havira to̱ zatte̱ u̱r-waak u̱ o̱ko̱n no̱m-o̱ ne̱ u̱ de̱ naasu̱ o̱ da. Tu̱msu̱ u̱n o̱tte̱ dap-mu̱ wu̱s u-haku̱n, u̱ ta'ar-u̱t rim-to̱ ne̱ tu̱ shik sok. ");
INSERT INTO gel_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Dim-du̱ gi-yu̱ u-yu̱ru̱mse̱ na zu̱ ya Giho̱n, gi-u ya gu̱p m-nar u̱ gas-u̱ dak-u̱ Kus u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Dim-du̱ gi-yu̱ u-tu̱tu̱rse̱ Tigris, ja-mu̱ gi-u ya gu̱p u̱ gas-u̱ u-do̱m u̱ gu̱r-u̱ Asur. Dim-du̱ gi-yu̱ u-nasu̱rse̱ na zu̱ ya Yupireti. ");
INSERT INTO gel_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yawe u-Ru̱ wu̱ ne̱t u̱-me̱ u-tak u̱ Idin, remu̱ ne̱t-u̱ no̱m-u̱t to̱m-du̱ o̱ tu̱msu̱ wa gwat o̱. ");
INSERT INTO gel_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Se̱ Yawe u-Ru̱ no̱mu̱ ne̱t-u̱ wa u̱t-him, <<Bo̱ keru̱ re̱-du̱ yaa-tu̱ u̱s-te u̱s-be̱e̱t su̱ o̱ u-tak, ");
INSERT INTO gel_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","se̱di A-bo̱ re̱ yaa-tu̱ te-yu̱ nap-mu̱ no̱m-u̱t so̱-to̱ u̱ tu̱ yo̱-to̱ ne̱ da, remu̱ zu̱ ho̱-du̱ bo̱ re̱ yaa-tu̱ te-u ya bo̱ de̱ m-mar za u-sakna.>> ");
INSERT INTO gel_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Se̱ Yawe u-Ru̱ zu̱, <<No̱ng u̱r-zwar u̱ ne̱t u̱ shu̱'u̱t wa u-gan da. Yage̱ u̱m no̱mu̱ wa, wa-u̱r-se̱ge̱ wu̱ o̱ ho̱n-ho̱n u̱ wu̱n ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Du̱gu̱ u-dak Yawe u-Ru̱ nomte̱ ko̱-uyan go̱-du̱ u̱t-bisa u̱ no ne̱. Wa hatu̱n e̱ u̱du̱ ne̱t wa te̱'e̱ e̱ u̱t-dim, tu̱msu̱ ko̱-uyan dim-de̱ wa fogte̱ bisa-u̱t to̱ u̱ no ne̱, de̱ shu̱'u̱te̱ dim-u̱r wa. ");
INSERT INTO gel_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Adamu te̱'e̱ bisa-u̱t to̱ u̱ no ne̱ u̱ bisa-tu̱ u̱r-do̱g u̱t-be̱e̱t u̱t-dim. Ko̱ ba shu̱'u̱te̱ iya Adamu zatte̱ wa-u̱r-se̱ge̱ ho̱n-ho̱n u̱ wa ne̱ da. ");
INSERT INTO gel_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Se̱ Yawe u-Ru̱ wu̱ roog-m yat-mo̱ ship ne̱t-u̱ wa. Da-u̱ wa o̱ te̱k m-roog, Ru̱-u̱ for shar-yu̱ u-gas u-gan yu̱ ne̱t-u̱ wa, se̱ wa zwape̱ be-u̱r re̱ du̱ wa forte̱ shar-yu̱ u-gas u̱ ap-mu̱ u-war. ");
INSERT INTO gel_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Iya o̱ Yawe u-Ru̱ ku̱bte̱ shar-yu̱ u-gas yu̱ wa fare̱ du̱gu̱-du̱ ne̱t-u̱ wa, wa nom ne̱ta. Se̱ wa haatu̱n ne̱ta-u ya u̱du̱ ne̱t-u̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Se̱ ne̱t-u̱ wa zu̱, <<M-vaste̱! Sham-m ri ya, shar-ya yu̱ rwu̱ne̱ du̱gu̱ shar-u̱t ri, Tu̱msu̱ ap-m wa du̱gu̱ ap-m ri. Na de̱ fag-du̱ wa <Ne̱ta,> remu̱ zu̱, Ru̱-o̱ rwu̱tu̱n ne̱ta du̱gu̱ war-u̱ ne̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Remu̱ iya, campa de̱ yagu̱ u̱so-u wa u̱ ino-u wa ne̱, wa dap ne̱ta wa, e̱ shu̱'u̱te̱ u-war u-gan. ");
INSERT INTO gel_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ne̱t-u̱ wa e̱ ne̱ta wa ne̱ be̱e̱t e̱ o̱ u̱t-so, se̱di e̱ ho̱k m-'e̱ da. ");
INSERT INTO gel_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Fa-yu̱ ze̱k ko̱-uyan bisa-tu̱ Yawe u-Ru̱ no̱me̱ u̱s-ve̱r. Se̱ fa-yu̱ zu̱ ne̱ta, <<¿Ko̱ Ru̱-u̱ zu̱u̱g A no̱ re̱ u̱ te̱k-u̱ yaa-tu̱ ko̱-uyan te ya yu̱ o̱ me̱ tak-u̱ Idin da?>> ");
INSERT INTO gel_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Se̱ ne̱ta zu̱ u-fa, <<Ru̱-u̱ zu̱u̱g it u̱ kere̱ re̱-du̱ yaatu̱ u̱s-te su̱ o̱o̱ge̱ u-tak, ");
INSERT INTO gel_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Se̱di Ru̱-u̱ zu̱u̱g, <A no̱ jaru̱n no̱ re̱ yaa-tu̱ te-u ya yu̱ o̱o̱ge̱ u̱-te̱k u-tak da, tu̱msu̱ A no̱ tam ya da, taas no̱ mar da.> >> ");
INSERT INTO gel_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Tu̱msu̱ fa-yu̱ zu̱ ne̱ta, <<Iya o̱ da, no̱ za m-mar da. ");
INSERT INTO gel_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ru̱-u̱ zu̱u̱g iya remu̱ zu̱ wa nak u̱zu̱ a no̱ re̱ye̱ is-u̱ no̱ de̱ u̱t-upus, no̱ shu̱'u̱t u̱ka u-Ru̱, no̱ nap no̱m-u̱t so̱-to̱ u̱ tu̱ yo̱-to̱ ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Da-u̱ ne̱ta-yu̱ hyane̱ u̱zu̱ yaatu̱ u-te̱ o̱ so̱-to̱ u̱du̱ u̱t-re̱, tu̱msu̱ o̱tte̱ zwarru̱ m-hyan, u̱t-no̱m u̱r-zwar remu̱ ya-du̱ m-nap; se̱ wa ku̱ wa re. Wa yaase̱ to̱ko̱n u̱du̱ campa wa, wu̱ o̱o̱ge̱ u̱r-kot u̱ wa ne̱, se̱ wa re. ");
INSERT INTO gel_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Za rem se̱ is-u̱ u̱n be̱e̱t u-pus u̱n nu̱p u̱zu̱ so-to̱ u̱n o̱ye̱. Se̱ e̱ saan ran-tu̱ u-te yu̱ mu̱te̱ u̱t-ya yu̱ na foge̱ te-yu̱ u-rumba. ");
INSERT INTO gel_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Da-u̱ rim-mu̱ tore̱ se̱ e̱ hog ram-u̱s Yawe u-Ru̱ u-tak. Ne̱t-u̱ wa e̱ ne̱ta wa e̱ pu̱k te-su̱ u-tak, taas u̱ Ru̱-u̱ hyan e̱ da. ");
INSERT INTO gel_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Se̱ Yawe u-Ru̱ fog ne̱t-u̱ wa u̱zu̱, <<¿He̱ bo̱ o̱tte̱?>> ");
INSERT INTO gel_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Se̱ wa zu̱, <<U̱m ho̱k ram-u̱s ró u-tak, se̱di u̱m ho̱k u-gye̱r, remu̱ zu̱ so-de̱ u̱m o̱ye̱, se̱ u̱m pu̱k.>> ");
INSERT INTO gel_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Yawe u-Ru̱ zu̱, <<¿Wana waru̱ bo̱ u̱zu̱ so̱-de̱ bo̱ o̱ye̱? ¿Ko̱ bo̱ re̱ m-re̱ yaatu̱ u-te tu̱ u̱m zu̱ a-bo̱ re̱ da?>> ");
INSERT INTO gel_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Se̱ ne̱t-u̱ wa zu̱, <<Ne̱ta wa wu̱ bo̱ ya me̱ wa ya' me̱ yaatu̱ te-u ya, tu̱msu̱ u̱m re.>> ");
INSERT INTO gel_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Se̱ u-Ru̱ Yawe zu̱ ne̱ta-u ya, <<¿Yan-o̱ bo̱ no̱me̱ inya?>> Se̱ ne̱ta-u ya zu̱, <<Fa-ya e̱ngu̱sse̱ me̱ se̱ u̱m re.>> ");
INSERT INTO gel_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Se̱ Yawe u-Ru̱ zu̱ u-fa, Remu̱ zu̱ bo̱ e̱ngu̱sse̱ ne̱ta, U̱m wa'agu̱ bo̱ nu-u yo̱-o̱ bo̱ o̱ do̱'e̱ u̱t-do̱r u̱ war ró u̱-me̱ bisa-tu̱ u-bu u̱ bisa-tu̱ u̱r-do̱g ne̱ u̱t-be̱e̱t. Bo̱ de̱ u̱t-fu̱k u̱t-me̱n tu̱msu̱ huug-mo̱ de̱ shu̱'u̱tu̱ no̱m u̱t-re̱ ró u̱ yu̱u̱r-u̱r ró u̱r-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Me̱ wa'-u̱ yu̱-u̱r yo̱-de̱ u̱ te̱k-u̱ ko̱-u̱r ró u̱ du̱ ne̱ta-u ya ne̱, ko̱-u̱r ne̱ta tu̱msu̱ u̱ ko̱-u̱r ró ne̱, Wa jangu̱ hi-u̱r ró tu̱msu̱ hen bo̱ de̱ ke̱t-du̱ du̱ku̱nte̱-u̱t e̱. ");
INSERT INTO gel_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Se̱ Ru̱-u̱ zu̱ ne̱ta, <<Me̱ swu̱ru̱ bo̱ swadu̱ u̱r-ko̱b u̱du̱ u̱r-mat, u̱ te̱k-u̱ swadu̱ u̱r-ko̱b de̱ bo̱ do̱te̱ mat-du̱ yaag-u̱ ró, Cwan-u̱t ró do̱'e̱ u̱t-shu̱'u̱t remu̱ campa ró, se̱di wa de̱ u̱t-shu̱'u̱t yu̱-Yat-ya ró.>> ");
INSERT INTO gel_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Wa zu̱ Adamu, <<Remu̱ bo̱ erte̱ cwar-yu̱ ne̱ta ró, bo̱ re yaatu̱ te̱-u ya, <yu̱ u̱m zu̱ bo̱ a-bo̱ re̱ da,> <<U̱m wa'agu̱ u-dak nu-u yo̱-o̱ remu̱ ró, se̱ bo̱ no̱ng m-ank sok mu̱ swadu̱ u̱r-ko̱b kanda bo̱ kum no̱m u̱t-re̱ u̱ bo̱ de̱ u̱t-re̱, u̱ yu̱-u̱r ró u̱r-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Dak-u̱ do̱'e̱ apu̱n-du̱ u̱s-hir m-baat ne̱ remu̱ ró, u̱ same̱ u̱s-gwa ne̱ su̱ na-su̱ u̱t-ku̱wu̱t. ");
INSERT INTO gel_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","U̱s-hund se̱ bo̱ do̱te̱ re̱-du̱ no̱m u̱t-re̱, M-te̱ ho̱-du̱ bo̱ do̱'e̱ m-mar tu̱msu̱ bo̱ de̱ mu̱-du̱ u-dak, remu̱ zu̱ du̱gu̱ me̱ u-dak o̱ bo̱ rwu̱ne̱. Bo̱ rwab-to̱ tu̱msu̱ bo̱ de̱ u̱t-baru̱m u̱t-rwab.>> ");
INSERT INTO gel_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ne̱t-u̱ wa fog dim-du̱ ne̱ta wa Hawa, remu̱ zu̱ wa o̱ye̱ ino-u̱ u̱t-ne̱t u̱t-be̱e̱t tu̱ o̱ u̱r-fat. ");
INSERT INTO gel_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Se̱ Yawe u-Ru̱ no̱mu̱ Adamu e̱ ne̱ta wa u̱t-kus u̱ ka-tu̱ u̱t-bisa tu̱msu̱ wa taku̱s so-u̱t u̱n. ");
INSERT INTO gel_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Se̱ Yawe u-Ru̱ zu̱ hi-u̱r wa, <<Gwat u̱ da-o̱ ne̱t shu̱'u̱te̱ u̱s-gan u̱ in ne̱, wa o̱tte̱ nap-mu̱ no̱m-u̱ so̱-o̱ u̱ yo̱-o̱ ne̱. Na zaaru̱ yage̱ wu̱n u jaku̱s u-kom u̱ wa ka yaatu̱ te-yu̱ u̱r-fat, taas wa re̱, u̱ wa no̱m u̱r-yu̱ m-mo̱mmo̱ da.>> ");
INSERT INTO gel_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Remu̱ iya Yawe u-Ru̱ wa yanu̱g Adamu e̱ Hawa du̱gu̱ tak-u̱ Idin, remu̱ zu̱ Adamu nom-u̱t u̱r-to̱m u̱ dak-u̱ Ru̱-u̱ nom-tu̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Da-u̱ Yawe u-Ru̱ buze̱ Adamu e̱ Hawa du̱gu̱ me̱ tak-u̱ Idin, se̱ wa wu̱' e̱ke̱n a-to̱mu̱ wa i na foge̱ ke̱ro̱bin u̱r-'e u̱r-kot u-van ne̱ yu̱ o̱ m-re̱ sha-mu̱ u-ra m-baku̱t ne̱, u̱ gas-u̱ u-do̱m e̱ no̱m u̱r-'e u̱ fu̱n-yu̱ cwadu̱ be-du̱ te-yu̱ u̱r-fat. ");
INSERT INTO gel_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu roogte̱ u̱ ne̱ta wa ne̱ Hawa, wa nom u̱t-me̱n, wa mu̱t Kayinu. Hawa zu̱, <<U̱m kwu̱mu̱g ya-du̱ u̱r-campa, remu̱ se̱ge̱-u̱r Yawe.>> ");
INSERT INTO gel_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Hawa mu̱t tu̱msu̱ hu̱no̱-u wa, wa te̱'e̱ wa u̱r-dim Habira. Habira shu̱'u̱t wa-gwat-du̱ ban-du̱ u̱t-bisa, Kayinu shu̱'u̱t wa-u̱r-to̱m. ");
INSERT INTO gel_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","U̱ te̱k-u̱ da-u o̱ Kayinu haatu̱n nya-u̱ no̱m-tu̱ u̱r-to̱mu̱ wa u̱ du̱ Yawe. ");
INSERT INTO gel_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Tu̱msu̱ Habira haatu̱n mat-tu̱ u̱r-taku̱n u̱ te̱k-u̱ ban-du̱ bisa-u̱t wa tu̱ se̱me̱, Yawe ku̱b nya-u Habira, Habira kum hyu̱-m pus-mo̱ u̱ nya-u̱ wa haatu̱n. ");
INSERT INTO gel_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Se̱di Yawe o̱nkte̱ Kayinu u̱ nya-u wa no̱me̱ ne̱ da, se̱ Kayinu hog u̱s-ryab sok, wa naas u-shu̱. ");
INSERT INTO gel_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ku̱na Yawe zu̱tte̱ Kayinu, <<¿Yan-o̱ wa'e̱ jab-u̱ ró nu̱u̱t? ¿Yan-o̱ wa'e̱ bo̱ naaste̱ u-shu̱? ");
INSERT INTO gel_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Me̱ kabu̱ nya-u ró, a-bo̱ no̱me̱ no̱m-tu̱ u-ho̱n-ho̱n. Ba'as-tu̱ ya u̱r-e' u̱ bo̱n-du̱ is, a-bo̱ gu̱gme̱ no̱m-du̱ no̱m-tu̱ u-ho̱n-ho̱n; to̱ o̱ u̱t-sa to̱ ship bo̱. Se̱ bo̱ ze̱k be̱b-du̱ to̱.>> ");
INSERT INTO gel_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","U̱ te̱k-u̱ da-u o̱ Kayinu zu̱ du̱-fade̱ wa Habira, <<Haane̱ in cwa u̱r-do̱g.>> Da-u̱ e̱ o̱ u̱r-do̱g, Kayinu ku̱t du̱-fade̱ wa Habira se̱ wa ho wa. ");
INSERT INTO gel_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Da-u̱ waase̱, Yawe zu̱ Kayinu, <<¿Du̱-fade̱ ró Habira yu̱?>> Wa shu̱s wa zu̱, <<U̱m nak da! ¿Me̱ wa o̱ wa-gwat-du̱ du̱-fade̱ ri?>> ");
INSERT INTO gel_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Yawe zu̱, <<¿Yan o̱ bo̱ no̱me̱ inya? Hyu̱-mu̱ du̱-fade̱ ró no̱ng u̱s-kan du̱gu̱ u-dak u̱ haan u̱du̱ ri! ");
INSERT INTO gel_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","U̱ da-o̱, bo̱ o̱ nu-u yo̱-o̱ ne̱ tu̱msu̱ u̱m de̱ bu̱z-du̱ bo̱ du̱gu̱ u-dak, u̱ upse̱ u-nu o̱ so hyu̱-mu̱ du̱-fade̱ ró du̱gu̱ kom-u̱t ró. ");
INSERT INTO gel_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Da-u̱ bo̱ no̱me̱ u̱r-to̱m bo̱ za kwu̱m-du̱ no̱m-tu̱ u̱r-to̱m da, bo̱ de̱ u̱t-shu̱'u̱t wa-za u̱r-hure̱ wa riig-tu̱ m-zan u-dak.>> ");
INSERT INTO gel_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Se̱ Kayinu zu̱ Yawe, <<kwu̱p-du̱ u̱s-rem ri, ze̱k be̱b-u̱r ri. ");
INSERT INTO gel_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Bo̱ yanu̱g me̱ du̱gu̱ u-dak, tu̱msu̱ du̱gu̱ shu̱ ró, tu̱msu̱ u̱m de̱ u̱t-shu̱'u̱t wa-za u̱r-hure̱ u̱ riig-tu̱ m-zan u-dak. Tu̱msu̱ ko̱wana hyane̱ me̱ wa de̱ ho̱-du̱ me̱.>> ");
INSERT INTO gel_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tu̱msu̱ Yawe zu̱ wu̱n, <<Iya-o̱ da! Ko̱wana ho̱ bo̱, u̱m de̱ to̱p-u̱ bo̱ u̱r-mag u-u̱so u-ta'er.>> Se̱ Yawe wa'-u̱ Kayinu u̱s-nap su̱ u̱t-him remu̱ u̱zu̱ ko̱wana hyanu̱ wa, wa za ho̱ wa da. ");
INSERT INTO gel_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kayinu yu̱ne̱ wa aru̱k du̱gu̱-du̱ Yawe, wa do̱'e̱ wa shu̱'u̱t u̱ dak-u̱ No̱d, u-dom u̱ Idin ne̱. ");
INSERT INTO gel_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kayinu roog u̱ ne̱ta wa ne̱, wa no̱m u̱t-me̱n se̱ wa mu̱t E̱no̱k. U̱ da-u o̱ Kayinu o̱ ma-du̱ o̱ko̱n bo̱-o̱, se̱ wa te̱'e̱ bo̱-u o̱ dim-du̱ zwar-u̱ wa E̱no̱k. ");
INSERT INTO gel_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","E̱no̱k o̱tte̱ zwar wu̱ na foge̱ Irad, tu̱msu̱ Irad wa mate̱ Mehujaye̱r, tu̱msu̱ Mehujaye̱r wa mate̱ Metushaye̱r, tu̱msu̱ Metushaye̱r wa mate̱ Rame̱k. ");
INSERT INTO gel_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Rame̱k gaag ne̱ta-ne̱ yu̱r, wa u̱r-taku̱n na zu̱ wa Ada, wa-u-yu̱ru̱mse̱ na zu̱ wa Zira. ");
INSERT INTO gel_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada wa mate̱ Jabar, wu̱na o̱ ne̱t u̱r-taku̱n wu̱ he̱e̱se̱ gwat-du̱ u̱t-bisa tu̱msu̱ wa yi u̱t-rimpa. ");
INSERT INTO gel_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Dim-du̱ o̱r-u̱ wu̱n wa na zu̱ye̱ Jubar, wu̱na o̱ taku̱n-du̱ a o̱s-du̱ u-mo̱ro̱ u̱r-tu̱kku̱rma ne̱. ");
INSERT INTO gel_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zira wu̱ o̱ye̱ ne̱ta u-yu̱ru̱mse̱, wa mate̱ Tubar-Kayinu wa shu̱'u̱te̱ wu̱ tak-ne̱ m-ank u̱ kwam-tu̱ bu̱-mu̱ u-dak tu̱ shik tu̱ no̱m-du̱ to̱ko̱n no̱m-to̱ ne̱. Hu̱no-u̱ wa-ne̱ta Tubar-Kayinu dim-u̱r wa Naama. ");
INSERT INTO gel_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","De̱ku̱n ho̱-de̱ Ramek zu̱ ne̱ta-u̱t wa, <<Ada e̱ Zira, ganu̱n u̱t-to̱ u̱du̱-ri, ne̱ta-u̱t Rame̱k, ho̱go̱n no̱m-u̱ u̱m de̱ waru̱ no̱. U̱m ho̱o̱g wa'-u̱ zwar, Remu̱ zu̱ wa zwargu̱n me̱ tu̱msu̱ wa ho̱nse̱ me̱. ");
INSERT INTO gel_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","A mu̱ne̱ u̱zu̱ na ya'u̱ wu̱ ho̱ye̱ Kayinu u̱r-ko̱b u-so u-ta'er, ko̱wana ho̱ me̱, wa de̱ swadu̱ u̱r-ko̱b u-so u̱t-shik u̱t-tu̱t u̱ o̱p-u̱ ta'e̱r 77.>> ");
INSERT INTO gel_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu roog u̱ ne̱ta wa ne̱ tu̱msu̱. Hawa no̱m u̱t-me̱n, wa sur m-mat ya-du̱ u̱r-campa. Hawa te̱'e̱ wa u̱r-dim Se̱t. Wa zu̱, <<Ru̱-u̱ yaag me̱ de̱ku̱n ya-du̱ u̱r-campa de̱ u̱ swas-m Habira wu̱ Kayinu ho̱ye̱.>> ");
INSERT INTO gel_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Da-u̱ Se̱t rogme̱ wa kum zwar wu̱ na zu̱ye̱ E̱no̱sh. U̱ da-u o̱ ne̱t-tu̱ he̱e̱se̱ no̱mu̱ dim-u̱r Yawe u̱t-huuk. ");
INSERT INTO gel_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Tun-to̱ o̱ dim-tu̱ ya'ag-u̱ ko̱-u̱r Adamu. Da-u̱ Ru̱-u̱ no̱me̱ ne̱t, wa nom wa u̱ka sha-m wa. ");
INSERT INTO gel_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Wa no̱mu̱g campa u̱ ne̱ta-ne̱, se̱ wa wa'-u̱ e̱ nu-u so̱-o̱. Da-u̱ wa no̱mu̱ u̱n, wa foge̱ <<u̱t-ne̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Da-u̱ Adamu no̱me̱ u̱r-yu̱ u̱s-hak u-ko̱k u-gan u̱r-shik u̱ o̱p 130, wa kum zwar wu̱ o̱tte̱ sha-m wa, u̱-me̱ ryu̱n-u wa u̱ sha-m wa; tu̱msu̱ wa te̱'e̱ wa u̱r-dim Se̱t. ");
INSERT INTO gel_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ba Adamu mate̱ Se̱t, Adamu no̱m u̱r-yu̱ u̱s-hak u̱t-ko̱k u̱t-nas 800 u̱ te̱k-u̱ hak-su̱ u̱t-ko̱k u̱t-nas wa kum e̱ke̱n ya'ag-u̱ campa-ne̱ u̱ yaat u̱t-gwu̱p-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adamu no̱ng u̱r-yu̱ u̱s-hak u̱t-ko̱k u̱t-jwu̱u̱r u̱r-shik u̱ o̱p 930 se̱ wa mu̱ru̱s. ");
INSERT INTO gel_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Da-u̱ Se̱t no̱me̱ u̱r-yu̱ u̱s-hak u̱t-shik u̱t-tan u̱s-tan 105, wa mu̱t E̱no̱sh. ");
INSERT INTO gel_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Tu̱msu̱ ba wa mate̱ E̱no̱sh, Se̱t sur m-no̱m u̱r-yu̱ u̱s-hak u̱t-ko̱k u̱t-eer u̱s-ta'er 807 u̱ te̱k-u̱ hak-su̱ u̱t-ko̱k u̱t-nas u̱s-ta'er wa sur m-mat e̱ke̱n ya'ag-u̱ campa-ne̱ u̱ yaat u̱t-gwu̱p-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Hak-su̱ Se̱t no̱me̱ se̱ o̱ u̱s-hak u̱t-ko̱k u̱t-jwu̱u̱r u̱ o̱p u̱s-yu̱r 912, se̱ wa mu̱ru̱s. ");
INSERT INTO gel_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Da-u̱ E̱no̱sh no̱me̱ u̱r-yu̱ u̱s-hak u̱t-shik u̱t-nas u̱-o̱p 90, wa mu̱t zwar wu̱ na zu̱ye̱ Kenan. ");
INSERT INTO gel_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Tu̱msu̱ ba wa mate̱ Kenan, E̱no̱sh sur m-no̱m u̱s-hak u̱t-ko̱k u̱t-eer u̱ o̱p u̱t-tan 815 u̱ te̱k-u̱ hak-su̱ u̱t-ko̱k u̱s-nas u̱ o̱p u̱s-tan wa mu̱t e̱ke̱n ya'ag-u̱ campa-ne̱ u̱ yaat u̱t-gwu̱p-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Hak-u̱s E̱no̱sh su̱ wa nome̱ u̱s-be̱e̱t se̱ o̱ u̱s-hak u̱t-ko̱k u̱t-nas u̱ o̱p u̱s-tan 905, wa mu̱ru̱s. ");
INSERT INTO gel_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Da-u̱ Kenan no̱me̱ u̱r-yu̱ u̱s-hak u̱t-shik u̱t-tu̱t u̱ o̱p 70 wa mu̱t Maharare̱r. ");
INSERT INTO gel_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ba wa mate̱ Maharare̱r, Kenan sur m-no̱m u̱s-hak u̱t-ko̱k u̱t-eer u̱ u̱t-shik u̱t-yu̱r 840, u̱ te̱k-u̱ hak-su̱ u̱t-ko̱k u̱t-nas u̱t-shik u̱t-yu̱r wa mu̱t e̱ke̱n ya'ag-u̱ campa-ne̱ u̱ yaat u̱t-gwu̱p-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Hak-su̱ Kenan no̱me̱ se̱ o̱ u̱t-ko̱k u̱t-jwu̱u̱r u̱ u̱s-o̱p 910 se̱ wa mu̱ru̱s. ");
INSERT INTO gel_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Da-u̱ Maharare̱r no̱me̱ u̱r-yu̱ u̱s-hak u̱t-shik u̱t-tu̱t u̱s-tan 65 wa mu̱t Jare̱d. ");
INSERT INTO gel_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ba Maharare̱r mate̱ Jare̱d, wa sur m-no̱m u̱s-hak u̱t-ko̱k u̱t-eer u̱r-shik-u̱ o̱p 830 u̱ te̱k-u̱ hak-su̱ u̱t-ko̱k u̱t-nas u̱ u̱r-shik-u̱ o̱p wa mu̱t e̱ke̱n ya'ag-u̱ campa-ne̱ u̱ yaat u̱t-gwu̱p-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Hak-su̱ Maharare̱r no̱me̱ se̱ o̱ u̱t-ko̱k u̱t-eer u̱ u̱t-shik u̱t-nas u̱ o̱p u̱s-tan 895, se̱ wa mu̱ru̱s. ");
INSERT INTO gel_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Da-u̱ Jare̱d no̱me̱ u̱r-yu̱ u̱s-hak u-ko̱k u-gan u̱t-shik u̱t-tu̱t u̱s-yu̱r 162, wa mu̱t E̱no̱k. ");
INSERT INTO gel_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Tu̱msu̱ ba Jare̱d mate̱ E̱no̱k, wa sur m-no̱m u̱s-hak u̱t-ko̱k u̱t-eer 800 u̱ te̱k-u̱ hak-su̱ u̱t-nas wa mu̱t e̱ke̱n ya'ag-u̱ campa-ne̱ u̱ yaat u̱t-gwu̱p-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Hak-u̱s Jare̱d su̱ wa no̱me̱ se̱ o̱ u̱t-ko̱k u̱t-jwu̱u̱r u̱t-shik u̱t-tu̱t u̱s-yu̱r 962, se̱ wa mu̱ru̱s. ");
INSERT INTO gel_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Da-u̱ E̱no̱k no̱me̱ u̱r-yu̱ u̱s-hak u̱t-shik u̱t-tu̱t u̱s-tan 65 wa mu̱t Me̱tuse̱ra. ");
INSERT INTO gel_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Tu̱msu̱ ba wa mate̱ Me̱tuse̱ra, E̱no̱k no̱m u̱s-hak u̱t-ko̱k u̱t-tu̱t 300, wa no̱ng m-ha u̱r-kot u-Ru̱-ne̱, tu̱msu̱ wa sur m-mat e̱ke̱n ya'ag-u̱ campa-ne̱ u̱ yaat u̱t-gwu̱p-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Hak-su̱ E̱no̱k no̱me̱ se̱ o̱ u̱t-ko̱k u̱t-tu̱t u̱t-shik u̱t-tu̱t u̱s-tan 365. ");
INSERT INTO gel_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","E̱no̱k no̱ng m-ha u̱r-kot u-Ru̱-ne̱, se̱ Ru̱-u̱ ku̱b wu̱n, wa umus wu̱n m-da u-ru̱. ");
INSERT INTO gel_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Da-u̱ Me̱tuse̱ra no̱me̱ u̱r-yu̱ u̱s-hak u-ko̱k u-gan u̱t-shik u̱t-nas u̱s-ta'e̱r 187, se̱ wa mu̱t Rame̱k. ");
INSERT INTO gel_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Tu̱msu̱ ba wa mate̱ Rame̱k, Me̱tuse̱ra sur m-no̱m u̱s-hak u̱t-ko̱k u̱t-ta'er u̱t-shik u̱t-nas u̱t-yu̱r 782, u̱ te̱k-u̱ hak-su̱ u̱t-ko̱k u̱t-ta'er u̱t-shik u̱t-nas u̱t-yu̱r wa mu̱t e̱ke̱n ya'ag-u̱ campa-ne̱ u̱ yaat u̱t-gwu̱p-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Hak-su̱ Me̱tuse̱ra no̱me̱ u̱s-be̱e̱t se̱ o̱ u̱s-hak u̱t-ko̱k u̱t-jwu̱u̱r u̱t-shik u̱t-tu̱t u̱s-jwu̱u̱r 969, se̱ wa mu̱ru̱s. ");
INSERT INTO gel_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Da-u̱ Rame̱k no̱me̱ u̱s-hak u-ko̱k u-gan u̱t-shik u̱t-nas u̱s-yu̱r 182, se̱ wa mu̱t ya-du̱ u̱r-campa. ");
INSERT INTO gel_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Rame̱k te̱'e̱ wa u̱r-dim Nuhu, wa zu̱, <<Yage̱ unwa hatu̱n it ru̱s-du̱ jab du̱gu̱ pama-u swadu̱ u̱r-ko̱b-u̱ it u̱ remu̱ ank-mu̱ u̱t-kom mu̱ it ne̱ u̱ dak-u̱ Yawe wa'e̱ nu-u yo̱-o̱.>> ");
INSERT INTO gel_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ba Rame̱k mate̱ Nuhu, Rame̱k no̱m u̱s-hak u̱t-ko̱k u̱t-tan u̱t-shik u̱t-nas u̱ o̱p u̱s-tan 595, u̱ te̱k-u̱ hak-su̱ u̱t-ko̱k u̱t-tan u̱t-shik u̱t-nas u̱ o̱p u̱s-tan wa mu̱t e̱ke̱n ya'ag-u̱ campa-ne̱ u̱ yaat u̱t-gwu̱p-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Hak-su̱ Rame̱k no̱me̱ u̱s-be̱e̱t se̱ o̱ u̱s-hak u̱t-ko̱k u̱t-ta'er u̱t-shik u̱t-tu̱t u̱ o̱p-u̱s ta'er 777, se̱ wa mu̱ru̱s. ");
INSERT INTO gel_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ba Nuhu no̱me̱ u̱s-hak u̱t-ko̱k u̱t-tan 500, se̱ wa mu̱t She̱m, Ham, u̱ Jape̱t ne̱. ");
INSERT INTO gel_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Se̱ ne̱t-ne̱ he̱e̱se̱ u̱t-no̱m u-tát u-dak, tu̱msu̱ na matu̱ u̱n ya-u̱t-gwu̱p. ");
INSERT INTO gel_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Se̱ to̱ko̱n yar-tu̱ m-mya tu̱ do̱m u-ru̱ hyen ya-u̱t-gwu̱p u̱t-ne̱t o̱ so̱-ye̱ so̱k, tu̱msu̱ u̱n gaan ya-u̱t-gwu̱p i he̱ u̱n u̱ jab. ");
INSERT INTO gel_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Yawe zu̱, <<Yar-u ri zaru̱ u̱t-shu̱'u̱t u̱-me̱ ne̱t m-mo̱mmo̱ da, remu̱ zu̱ war-tu̱ m-mar to̱ u̱n o̱tte̱. Se̱di u̱ ane̱ u-shu̱, hak-u̱s wa zaar u̱t-ze̱g u-ko̱k u-gan u̱r-shik 120.>> ");
INSERT INTO gel_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","U̱ da-u o̱, tu̱msu̱ da tase̱, to̱ko̱n ne̱t-to̱ o̱ró be̱b-ne̱ i na zu̱ye̱ <<Nepirim.>> E̱ o̱ u̱r-yu̱ u-dak, da-u̱ to̱ko̱n yar-tu̱ m-mya tu̱ do̱m u-ru̱ rooge̱ u̱ ya'at u̱t-gwu̱p u̱ ne̱t-ne̱, se̱ e̱ matu̱ e̱ yaag. E̱ shu̱'u̱te̱ campa-ne̱ tu̱msu̱ be̱b-ne̱ i na o̱ m-ho̱g u̱ e̱ ne̱ i da-u̱ dim. ");
INSERT INTO gel_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Se̱ Yawe hyen jab-u̱ yo̱-o̱ ne̱t no̱ng u-tát u-dak, dorog-su̱ jab-u̱ wa u̱s-be̱e̱t o̱ko̱n zarra se̱ no̱m-u̱t yo̱-to̱ u-da u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yawe nom namu̱ jab sok u̱ wa nomte̱ ne̱t u-dak, tu̱msu̱ wa shi u̱ remu̱ jab. ");
INSERT INTO gel_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Se̱ Yawe zu̱, <<Me̱ hastu̱ u̱t-ne̱t u̱t-be̱e̱t tu̱ u̱m no̱me̱, du̱gu̱ me̱ u-dak, ne̱t-ne̱, u̱t-bisa ne̱ u̱ no̱m-tu̱ o̱o̱ge̱ u̱t-kurup ne̱, u̱ no ne̱ e̱ o̱ u̱t-riig u̱-do̱m u-ru̱, remu̱ jab naag me̱ u̱m no̱m-tu̱ e̱.>> ");
INSERT INTO gel_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Se̱di Nuhu kwu̱mu̱g hyu̱-m pusmo̱ u̱du̱ Yawe. ");
INSERT INTO gel_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Tun-to̱ o̱o̱ge̱ ogor-tu̱ ko̱-u̱r Nuhu. Nuhu ne̱t-u̱ gye̱r u-Ru̱ wa, wa zatte̱ u̱r-pyap u̱ ne̱t-tu̱ da-u wa da. Tu̱msu̱ wa no̱ng m-ha u̱r-kot u-Ru̱-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhu mak-u̱t ya'ag-u̱ campa-ne̱ tu̱t: She̱m u̱ Ham u̱ Jape̱t ne̱. ");
INSERT INTO gel_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Se̱di Ru̱-u̱ hyen u̱zu̱ ne̱t-tu̱ u-dak u̱ naag tu̱msu̱ o̱ shu̱g u̱ yu̱nu̱s-du̱ jab ne̱. ");
INSERT INTO gel_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ru̱-u̱ hyen u̱ka dak-u̱ nu̱u̱te, ne̱t-tu̱ u-dak u̱t-be̱e̱t e̱ naag u̱ yu̱u̱r e̱. ");
INSERT INTO gel_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ru̱-u̱ zu̱ Nuhu, <<U̱m no̱ng u̱s-dorog u̱zu̱ me̱ ho̱ru̱ssu̱ u̱t-ne̱t u̱t-be̱e̱t, remu̱ zu̱ u̱n shu̱u̱ste̱ u-dak u̱ jab-u̱s yo̱-se̱ ne̱. Iya o̱ hen, u̱m de̱ ho̱ru̱ssu̱ u̱n be̱e̱t u-dak-ne̱! ");
INSERT INTO gel_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","De̱'e̱ bo̱ no̱mu̱ hi-u̱r ró u-hat u̱ u̱t-bak tu̱ te-yu̱ u-jarin. Bo̱ no̱m u̱t-kur tu̱msu̱ bo̱ rake̱ o̱ dap-mu̱ u-te, u̱-do̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ka bo̱ do̱te̱ u̱ no̱m-du̱ hat-u ya: wu̱r-mu̱ hat-u ya do̱'e̱ u̱t-shu̱'u̱t u̱s-na u̱t-ko̱k u̱t-nas u̱t-shik u̱t-yu̱r o̱p 450, bo̱ no̱m m-hu̱k u̱s-na u̱t-shik u̱t-tu̱t u̱ o̱p u̱s-tan 75, tu̱msu̱ ja-mu̱ shu̱'u̱t u̱s-na u̱t-shik u̱t-yu̱r u̱ u̱s-tan 45. ");
INSERT INTO gel_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Bo̱ no̱mu̱ hat-u ya u̱r-byam, bo̱ yage̱ u-na u-gan u̱r-mo̱t du̱gu̱ do̱m. Se̱ bo̱ no̱m u-is u̱-me̱ gas-yu̱ u-hat. Bo̱ no̱m ya u̱t-kur u̱t-tu̱t ko̱-u̱-he̱ do̱m-u̱ o̱ru̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Gwat! U̱m do̱'e̱ tage̱ du̱ u-dak u̱ bu̱-mu̱ do̱'e̱ re̱-du̱ u-dak, mu̱ do̱'e̱ ho̱ru̱sse̱ no̱m-tu̱ u̱r-fat u̱t-be̱e̱t tu̱ u̱s-vu̱'e̱. Ko̱-uyan u-dak o̱ do̱'e̱ u̱t-mar. ");
INSERT INTO gel_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Se̱di u̱m de̱ este̱du̱ u̱s-rem ri u̱ bo̱ ne̱, tu̱msu̱ bo̱ de̱ cwadu̱ u-hat, bo̱ u̱ ya'ag-u̱ ró ne̱ u̱ ne̱ta ró ne̱ u̱ ne̱ta-tu̱ ya'ag-u̱ ró ne̱ u̱r-kot u̱ bo̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Tu̱msu̱ u̱m o̱ u̱t-sa u̱m guu ko̱yu̱he̱ go̱-tu̱ no̱m-tu̱ na no̱me̱ u̱t-be̱e̱t. Remu̱ iya se̱ bo̱ haatu̱n yu̱r u̱-me̱ no̱m-tu̱ u̱r-fat u̱t-be̱e̱t, u-so̱ u̱ u-gob ne̱ u̱ no̱mu̱ o̱o̱ge̱ u̱t-kurup ne̱ u-dak, u̱-me̱ u-hat u̱r-kot u̱ bo̱ ne̱, ko̱ e̱ u̱t-kwu̱s u̱r-fat. ");
INSERT INTO gel_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Kab yu̱r u̱ te̱k-u̱ go̱-tu̱ ko̱yu̱he̱ bisa ya m-cwa u̱-me̱ u-hat u-so̱ u̱ u-gob ne̱ tu̱msu̱ ko̱yu̱he̱ no ya ne̱, ko̱ e̱ u̱t-kwu̱s u̱r-fat. ");
INSERT INTO gel_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Bo̱ do̱'e̱ u̱ kab-du̱ go̱-du̱ no̱m-tu̱ u̱t-re̱ u̱ do̱'e̱ ko̱ru̱ bo̱ u̱t-be̱e̱t u̱ ne̱t-tu̱ u-bu ró ne̱ u̱ no̱m-tu̱ u̱r-fat ne̱ u̱t-be̱e̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuhu no̱m ko-uyan u̱ka Ru̱-u̱ zu̱tte̱ wa no̱m u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Se̱ Yawe zu̱ Nuhu, <<Cwa u-hat, bo̱ u̱ bu-u̱ ró ne̱ be̱e̱t, remu̱ zu̱ u̱m hyanu̱g bo̱ wa jab-u̱ so̱-o̱ wa u̱-me̱ ne̱t-tu̱ uno̱ da-o̱. ");
INSERT INTO gel_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Bisa-tu̱ u-he̱n u̱t-be̱e̱t, kab kag ta'er u̱ so̱ ne̱ ta'er du̱gu̱ ko̱du̱he̱ go̱-de̱. Bisa-tu̱ za u-he̱n u̱t-be̱e̱t, kab u-kag u-gan u̱ so̱ ne̱ u-gan du̱gu̱ ko̱du̱he̱ go̱-de̱. ");
INSERT INTO gel_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Go̱-tu̱ no u̱t-be̱e̱t, kab kag ta'er u̱ ro̱b ne̱ ta'er, u̱ remu̱ go̱-u̱t e̱ reet u-shu̱ u̱r-yu̱ ne̱ da-u̱ bu̱-mu̱ re̱-du̱ u-dak arke̱. ");
INSERT INTO gel_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kwu̱ku̱s m-roog u̱t-ta'er du̱gu̱ da-o̱, u̱m do̱'e̱ kasnu̱ u-yu̱ u̱ re̱-du̱ u-dak u̱t-ho̱ u̱t-shik u̱t-yu̱r 40 m-gye̱p ne̱ u̱t-ho̱ u̱t-shik u̱t-yu̱r 40, har se̱ u̱m haste̱ no̱m-tu̱ u̱r-fat tu̱ u̱m no̱me̱ u-dak u-be̱e̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Se̱ Nuhu no̱m ko̱-uyan u̱ka Yawe zu̱tte̱ wa no̱m. ");
INSERT INTO gel_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","U̱ da-u o̱ Nuhu o̱o̱g u̱s-hak u̱t-ko̱k u̱t-shishin 600 da-u̱ bu̱-mu̱ takse̱ u-dak. ");
INSERT INTO gel_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Tu̱msu̱ Nuhu, u̱ ya'ag-u̱ wane̱, u̱ ne̱ta wa ne̱, u̱ ne̱ta-tu̱ ya'ag-u̱ wa ne̱, e̱ to u-hat remu̱ e̱ poste̱ bu̱-mu̱ do̱'e̱ re̱-du̱ u-dak. ");
INSERT INTO gel_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","U̱ dame̱ ya-ubu Nuhu ne̱, bisa-tu̱ to u-me̱ u-hat: u̱t-bisa u̱t-go̱ u̱t-go̱ tu̱ u-he̱n u̱ tu̱ za u-he̱n ne̱, u̱ go̱-tu̱ no ne̱ u̱ no̱mu̱ ho̱g ne̱ i o̱ u̱t-riig u-dak. E̱ to u-hat u-so̱ u̱ u-gob ne̱ yu̱r yu̱r ka Ru̱-u̱ zu̱tte̱ Nuhu. ");
INSERT INTO gel_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Da-u̱ roog-mu̱ u̱t-ta'er no̱me̱, se̱ bu̱-mu̱ re̱-du̱ u-dak haan mo̱ taku̱s u-dak. ");
INSERT INTO gel_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Da-u̱ Nuhu o̱ u̱s-hak u̱t-ko̱k u̱t-shishin 600, u̱ ho̱-du̱ o̱p u̱t-ta'er 17 u̱ pyaat-yu̱ u-yu̱r, bu̱-mu̱ ta u-dak mo̱ bo̱ko̱n du̱gu̱ me̱ u-dak, na nom yu̱-u̱ u̱t-tu̱ru̱m so̱k du̱gu̱ do̱m u-ru̱. ");
INSERT INTO gel_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Yu̱-u̱ re u-shu̱ u̱r-rob ne̱ m-te u̱t-ho̱ u̱t-shik u̱t-yu̱r 40 u̱ m-gyu̱p ne̱. ");
INSERT INTO gel_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","U̱ gandi ho̱-u̱r re̱ de̱ Nuhu to u-hat, u̱r-kot u̱ ya'ag-u̱ wa ne̱ She̱m, Ham, u̱ Jape̱t ne̱, u̱r-kot u̱ ne̱ta wa ne̱ u̱ ne̱ta-tu̱ ya'ag-u̱ wa ne̱ tu̱t. ");
INSERT INTO gel_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","U̱n to u-hat u̱ ko̱-uyan go̱-du̱ u̱t-bisa tu̱ u-bu, u̱ ko̱-uyan bisa-tu̱ u̱r-do̱g ne̱ tu̱ o̱ u̱t-riig u-dak kowan u̱ du̱ wa go̱de̱, u̱ ko̱-uyan bisa-tu̱ u̱t-kurup ne̱ u̱r-kot, u̱ no ne̱ u̱t-go̱ u̱t-go̱. ");
INSERT INTO gel_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","No̱m u̱r-fat i ko̱-uyan go̱-de̱ e̱ haan u̱du̱ Nuhu u-kag u-so̱ ne̱ e̱ to u-hat. ");
INSERT INTO gel_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Campa u̱ ne̱ta-ne̱ u̱ go̱-tu̱ u̱t-bisa ne̱ u̱t-be̱e̱t e̱ to u-hat u̱ka Ru̱-u̱ zu̱tte̱ Nuhu. Se̱ Yawe tage̱ u-is yu̱ u-hat u̱-dim. ");
INSERT INTO gel_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","M-roog u̱t-shik u̱t-yu̱r 40 na o̱ u̱ rob-du̱ u-yu̱ u-dak, bu̱-mu̱ hu̱ swu̱ru̱n, mo̱ hu̱ jak-su̱ u-hat du̱gu̱ u-dak m-da u-ru̱. ");
INSERT INTO gel_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Se̱ bu̱-mu̱ sur m-no̱m u-tát mo̱ no̱m m-ja so̱k du̱gu̱ u-dak, hat-yu̱ hu̱ u̱t-riig u̱-do̱m m-bu̱. ");
INSERT INTO gel_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","M-vaste̱ bu̱-mu̱ taku̱s m-ha ro̱r-tu̱ zu̱ge̱ m-ja u̱t-be̱e̱t u-dak. ");
INSERT INTO gel_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Bu̱-mu̱ nom m-ja mo̱ pu̱s ja-mu̱ u̱t-ro̱r m-te u̱s-na u̱r-shik 20, tu̱msu̱ mo̱ taku̱s u̱t-ro̱r u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","No̱m-tu̱ u̱r-fat u̱t-be̱e̱t tu̱ o̱o̱ge̱ u-dak to̱ mu̱ru̱s. E̱ mu̱ru̱mu̱ste̱ be̱e̱t: u̱ no ne̱, u̱ bisa-tu̱ u-bu ne̱, u̱ bisa-tu̱ u̱r-do̱g ne̱, u̱ no̱m-tu̱ u̱r-fat tu̱ re̱k-to̱ u̱ i o̱o̱ge̱ u̱t-riig u-dak, u̱ ne̱t-ne̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","No̱m-tu̱ u̱r-fat u̱t-be̱e̱t, e̱ mu̱rmu̱sse̱, tu̱ nome̱ u̱s-vu̱'e̱ i o̱o̱ge̱ u̱t-riig u̱ dak-u gagu̱n. ");
INSERT INTO gel_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ru̱-u̱ hast no̱m-tu̱ o̱o̱ge̱ u-dak u̱t-be̱e̱t, ne̱t-ne̱ u̱t-bisa ne̱ u̱ no̱m u̱r-fat ne̱ i o̱ u̱t-riig u-dak u̱ no do̱m u-ru̱ ne̱ be̱e̱t na hast e̱ du̱gu̱ me̱ u-dak. Nuhu wa Ru̱-u̱ yage̱ u̱ i o̱ u̱r-kot u̱ wa ne̱ u-hat. ");
INSERT INTO gel_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Bu̱-mu̱ re̱-du̱ u-dak mo̱ rees u-dak m-te m-roog u-ko̱k u-gan u̱ roog-mu̱ u̱r-shik u̱t-yu̱r u̱ o̱p 150. ");
INSERT INTO gel_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Se̱di Ru̱-u̱ baku̱ste̱ Nuhu u̱ bisa-tu̱ u̱r-do̱g ne̱ u̱t-be̱e̱t u̱ bisa-tu̱ u-bu ne̱, tu̱ o̱o̱ge̱ u̱r-kot u̱ wa ne̱ u-hat. Se̱ wa yagne̱ m-mya u-dak, tu̱msu̱ bu̱-mu̱ hu̱b. ");
INSERT INTO gel_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Se̱ Ru̱-u̱ wu̱ bu̱-mu̱ u-dak yage̱ u̱r-rwu̱n, tu̱msu̱ wa wu̱ bu̱-mu̱ do̱m u-ru̱ yage̱ u̱r-rob. ");
INSERT INTO gel_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Se̱ bu̱-mu̱ he̱e̱se̱ u̱t-hab u-dak cashi cashi, da-u̱ roog-mu̱ u̱t-shik u̱t-ta'er u̱ o̱p 150 arke̱, se̱ bu̱-mu̱ hu̱b m-cu̱m. ");
INSERT INTO gel_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Tu̱msu̱ u̱ ho̱-du̱ o̱p u̱t-ta'er 17 u̱ pyat-yu̱ u-ta'er se̱ hat-yu̱ ees u̱ do̱m-u̱ ro̱r-tu̱ Ararat. ");
INSERT INTO gel_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Bu̱-mu̱ re̱ u-shu̱ m-hab m-te taku̱n-du̱ pyat-yu̱ u-o̱p, u̱ taku̱n-du̱ pyat-u ya, do̱s-tu̱ u̱t-ro̱r rwu̱u̱n u̱-do̱. ");
INSERT INTO gel_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Da-u̱ to̱ku̱n ho̱-to̱ u̱t-shik u̱t-yu̱r 40 arke̱, Nuhu upus pyam-yu̱ wa no̱me̱ u-hat. ");
INSERT INTO gel_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Se̱ wa tom u-ryag, se̱ ya hu̱ u̱t-riig ya hu̱ pam-du̱ u̱t-kap u-dim u-shu̱ ne̱ se̱ da bu̱-mu̱ hose̱ du̱gu̱ u-dak. ");
INSERT INTO gel_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Tu̱msu̱ wa tom u̱r-gorop u̱ de̱ hyan u̱zu̱ bu̱-mu̱ hab-u̱g ko̱ de̱ hyanu̱ gagu̱n u-dak. ");
INSERT INTO gel_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Se̱di gorop-du̱ kwu̱mu̱g be-du̱ u̱r-ju̱z da remu̱ zu̱ bu̱-mu̱ taku̱ste̱ u-dak, se̱ de̱ barmu̱n u-hat. Tu̱msu̱ se̱ Nuhu nu̱b u-kom wa maas de̱ wa muut de̱ u̱ me̱n-tu̱ u-hat. ");
INSERT INTO gel_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Wa sur m-e̱ste̱ m-roog u̱t-ta'er se̱ wa sur m-to̱m u̱r-gorop du̱gu̱ u-hat. ");
INSERT INTO gel_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Da-u̱ gorop-du̱ mu̱u̱ne̱ u̱du̱ wu̱n m-rim, se̱ wa mu̱u̱n u̱ ran-u yar-o̱ ne̱ u̱ te̱-yu̱ ze̱tun u-nu! Se̱ Nuhu nu̱p u̱zu̱ bu̱-mu̱ habu̱g du̱gu̱ u-dak. ");
INSERT INTO gel_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Wa sur m-e̱ste̱ to̱ko̱n ho̱-to̱ u̱t-ta'er, se̱ wa sur m-to̱m u̱r-gorop, se̱di u̱ da-u o̱ de̱ swu̱ru̱g m-mu̱u̱n u̱du̱ wu̱n da. ");
INSERT INTO gel_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","U̱ ho̱-du̱ u̱r-taku̱n du̱ u-pyaat, da-u̱ Nuhu no̱me̱ u̱s-hak u̱t-ko̱k u̱t-shishin u-gan 601, se̱ bu̱-mu̱ tu̱u̱s du̱gu̱ u-dak. Se̱ Nuhu hast is-yu̱ u-hat se̱ wa hyen dak-u̱ gu̱u̱ste̱. ");
INSERT INTO gel_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","M-vaste̱ da-u̱ pyat-yu̱ rooge̱ u̱r-shik u̱t-ta'er u̱ pyaat-yu̱ u-yu̱r dak-u̱ gu̱u̱s u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Se̱ Ru̱-u̱ zu̱ Nuhu, ");
INSERT INTO gel_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","<<Rwu̱u̱ne̱ du̱gu̱ me̱ u-hat, no̱ be̱e̱t u̱ ne̱ta ró ne̱, u̱ ya'ag-u̱ ró ne̱, u̱ ne̱ta-u̱t u̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Rwu̱tu̱n go̱-tu̱ no̱m-tu̱ u̱r-fat u̱t-be̱e̱t tu̱ o̱o̱ge̱ u̱r-kot u̱ bo̱ ne̱: u̱ no ne̱, u̱ bisa-tu̱ u-bu ne̱, u̱ no̱m-tu̱ na no̱me̱ ne̱ u̱t-be̱e̱t tu̱ o̱o̱ge̱ u̱r-da u-dak. No̱m iya ko̱ e̱ u̱t-no̱m u̱r-ke̱s u-dak e̱ no̱m u-tát u-dak.>> ");
INSERT INTO gel_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nuhu rwu̱u̱n u̱-do̱, u̱r-kot u̱ ne̱ta wa ne̱, u̱ yaag-u̱ wa ne̱, u̱ ne̱ta-tu̱ yaag-u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","U̱t-bisa u̱t-be̱e̱t u̱ no̱m-tu̱ u̱r-fat ne̱ u̱t-be̱e̱t tu̱ o̱o̱ge̱ u̱t-riig u-dak u̱ no ne̱ be̱e̱t, u̱ ko̱-uyan u̱ o̱o̱ge̱ u̱r-no̱k u-dak rwu̱u̱n du̱gu̱ u-hat, ko̱yu̱he̱ u̱ du̱ wa go̱-de̱. ");
INSERT INTO gel_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Se̱ Nuhu ma-u̱ Yawe u̱r-sak. Se̱ wa ku̱b to̱ku̱n bisa-tu̱ u-he̱n to̱ u̱t-be̱e̱t u̱ no ne̱ i u-he̱n, wa yu̱' u̱r-to̱o̱g u̱-do̱m u̱r-sak. ");
INSERT INTO gel_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yawe hog wu̱s u-haku̱n se̱ wa zu̱ u̱-me̱ jab-u̱ wa: <<U̱m zamu̱n u̱t-sur wa'-u̱ u-dak nu-u yo̱-o̱ re̱mu̱ ne̱t da, ko̱ ba shu̱'u̱te̱ u̱zu̱ dorog-u̱s wa du̱gu̱ u̱r-ya no̱m-u̱t yo̱-to̱ to̱. U̱m zamu̱n u̱t-sur ho̱ru̱sse̱te̱ no̱m-tu̱ u̱r-fat da, ka u̱m nomte̱. ");
INSERT INTO gel_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","<<Abite̱ dak u-be̱e̱t o̱ro: na no̱mu̱ da-u̱ ku̱w u̱ da-u̱ ket ne̱, da-u̱ m-to̱r u̱ da-u̱ hund ne̱, da-u̱ u-go̱s u̱ da-u̱ u-zwu̱u̱n ne̱, u-ho̱ m-gyu̱p ne̱, to̱ zamu̱n u̱t-yage̱ da.>> ");
INSERT INTO gel_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Se̱ Ru̱-u̱ wa'-u̱ Nuhu u̱ ya'ag-u̱ campa-ne̱ wa nu-u so̱-o̱. Tu̱msu̱ wa waru̱ e̱, Matu̱n yaag tu̱msu̱ no̱ no̱m u-tát, no̱ shu̱u̱s u-dak. ");
INSERT INTO gel_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Bisa-tu̱ u-dak u̱t-be̱e̱t, u̱ no do̱m u-ru̱ ne̱ be̱e̱t, bisa-m re̱k-mo̱ m-be̱e̱t i o̱ u̱t-riig u-dak, tu̱msu̱ u̱ jan ne̱ me̱ m-bu̱, e̱ do̱'e̱ ho̱g-du̱ gye̱r-u no̱. U̱m wa'ag to̱ u̱t-be̱e̱t u̱ ta-u̱ be̱b-u̱r no̱. ");
INSERT INTO gel_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","No̱m-u̱ o̱o̱ge̱ u̱r-fat tu̱msu̱ u̱t-riig u̱m yaag no̱ to̱ shu̱'u̱t no̱m u̱t-re̱ no̱ u̱t-be̱e̱t. U̱ka u̱m yete̱ no̱ hyu̱ u̱t-ran ne̱, u̱m yaag no̱ ko̱-uyan u̱ da-o̱ u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","A no̱ jaru̱n no̱ tu̱ ap-mu̱ bisa-yu̱ za na pan da. ");
INSERT INTO gel_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ko̱wana kabe̱ fat-du̱ ne̱t, na no̱mu̱ wa kwu̱p-du̱ u̱s-rem. A bisa-yu̱ u̱r-do̱g u̱ ho̱ye̱ ne̱t, na ho̱ ya. Tu̱msu̱ ko̱wana ho̱ o̱r-u̱ wa ne̱t ko̱wana ho̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","<<Ko̱wana azge̱ hyu̱-mu̱ o̱r-u̱ wa ne̱t, ne̱t wa do̱'e̱ u̱ ho̱-du̱ wa, Remu̱ u̱zu̱ sha-mu̱ u-Ru̱ mo̱ na nomte̱ ne̱t. ");
INSERT INTO gel_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","<<U̱ da-o̱ matu̱n yaag no̱ no̱m u-tát, tu̱msu̱ no̱ sur m-shu̱s u-dak.>> ");
INSERT INTO gel_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Se̱ Ru̱-u̱ waru̱ Nuhu u̱ ya'ag-u̱ campa wa ne̱ tu̱msu̱ wa zu̱, ");
INSERT INTO gel_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","<<U̱ da-o̱ u̱m no̱ng este̱du̱ u̱s-rem u̱ bo̱ ne̱ u̱ yaag-u̱ ró ne̱ i do̱'e̱ haan, ");
INSERT INTO gel_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","tu̱msu̱ u̱t-bisa ne̱ tu̱ o̱o̱ge̱ u-hat u̱ bo̱ ne̱ u̱ no ne̱, u̱ bisa-tu̱ u-bu ne̱, tu̱msu̱ u̱ bisa-tu̱ u̱r-do̱g ne̱, u̱ no̱m-tu̱ na no̱me̱ ne̱ tu̱ o̱o̱ge̱ u-dak. ");
INSERT INTO gel_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","U̱m no̱ng este̱du̱ u̱s-rem ri u̱ no̱ ne̱: U̱m zamu̱n tu̱msu̱ ho̱-du̱ no̱m-u̱ u̱r-fat u-be̱e̱t u̱ bu̱-mu̱ re̱-du̱ u-dak da, u̱m zamu̱n tu̱msu̱ no̱m-du̱ bu̱-mu̱ re̱-du̱ u-dak mu̱ de̱ ho̱-du̱ u-dak da.>> ");
INSERT INTO gel_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Se̱ Ru̱-u̱ zu̱, <<U̱m o̱ ko̱se̱ no̱ sha-mu̱ este̱du̱ remu̱-u̱s ri tu̱msu̱ u̱ no̱m-tu̱ u̱t-fat ne̱ u̱t-be̱e̱t, este̱du̱ u̱s-rem u̱ ne̱t-tu̱ da-u̱ do̱'e̱ u̱ haan ne̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","U̱m wa'ag u-ro̱ko̱ro̱mb u̱t-ku̱'u̱t. Ya o̱ ko̱se̱-du̱ sha-mu̱ este̱du̱ u̱s-remu̱ ri u̱ no̱ ne̱ tu̱msu̱ u-dak-ne̱ u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Da-u̱ u̱m haatu̱n u̱t-ku̱'u̱t u̱-do̱m u-ru̱, ro̱ko̱ro̱mb-yu̱ do̱'e̱ u̱t-rwu̱n u̱t-ku̱'u̱t, ");
INSERT INTO gel_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","tu̱msu̱ me̱ baksu̱ este̱du̱ u̱s-remu̱ ri u̱ no̱ ne̱ tu̱msu̱ u̱ no̱m-tu̱ u̱r-fat ne̱ u̱t-be̱e̱t. U̱m zamu̱n u̱ ho̱-du̱ u̱t-fat u̱ bu̱-mu̱ re̱-du̱ u-dak da. ");
INSERT INTO gel_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Da-u̱ u̱m hyane̱ u-ro̱ko̱ro̱mb u̱t-ku̱'u̱t, me̱ baksu̱ este̱du̱ u̱s-rem su̱ m-mo̱mmo̱ su̱ u̱m no̱me̱ u̱ no̱m u̱r-fat ne̱ u-dak.>> ");
INSERT INTO gel_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ru̱-u̱ zu̱ Nuhu <<Inya ya o̱ u̱t-ko̱se̱ sha-mu̱ este̱du̱ u̱s-rem su̱ u̱m no̱me̱ u̱ mo̱t-tu̱ no̱m-tu̱ u̱m no̱me̱ tu̱ u-dak u-be̱e̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Yaag-u̱ campa-ne̱ Nuhu i rwu̱ne̱ du̱gu̱ me̱ u-hat u̱ uso-u e̱ ne̱ na zu̱ e̱: She̱m, Ham u̱ Jape̱t (Ham wa mate̱ Kan'ana). ");
INSERT INTO gel_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","U̱n tu̱t e̱ o̱ yaag-u̱ Nuhu, du̱gu̱-du̱ e̱ de̱ na kume̱ ne̱t-tu̱ bu̱rgu̱sse̱te̱ u-dak. ");
INSERT INTO gel_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Da-u̱ bu̱-mu̱ arke̱, Nuhu he̱e̱se̱ u̱r-to̱m u-dak, tu̱msu̱ wa o̱o̱ge̱ ne̱t wu̱ tak-ne̱ kau-du̱ u-tak u̱ inabi. ");
INSERT INTO gel_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Da-u̱ wa swaye̱ ke̱, se̱ ke̱ ho̱ wa. Wa ru̱t u̱r-so u̱ rimpa-u̱r wa. ");
INSERT INTO gel_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham (u̱so u̱ Kan'ana) wa hyen u̱zu̱ u̱so-u wa o̱ u̱r-so, wa aru̱k m-rwu̱ u̱-do̱ wa waru̱ o̱r-u̱t wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Se̱di She̱m ne̱ e̱ Jape̱t e̱ ku̱b u-kus e̱ ho̱bo̱g o̱ u̱ zag u̱t-kap-u̱ e̱. E̱ hu̱ m-ha m-targadim e̱ do̱'e̱ e̱ taku̱s so-du̱ u̱so-u e̱. Se̱ e̱ hast shu̱u̱t e̱ u̱ kit taas e̱ hyan so-du̱ u̱so-u e̱ da. ");
INSERT INTO gel_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Da-u̱ Nuhu yu̱ne̱ du̱gu̱ ho̱du̱ ke̱, wa nu̱p no̱mu̱ vaste̱-u̱r wa no̱mu̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Se̱ wa wa'-u̱ Kan'ana nu-u yo̱-o̱, <<Yage̱ u̱ Kan'ana shu̱'u̱t u̱ nu-u yo̱-o̱ ne̱! Yage̱ tu̱msu̱ wa shu̱'u̱t to̱k u̱ te̱k-u̱ o̱r-u̱t wa ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Tu̱msu̱ wa zu̱, <<Yage̱ Yawe, Ru̱-u̱ She̱m, wa wa'-u̱ She̱m nu-u so̱-o̱, tu̱msu̱ Kan'ana do̱'e̱ shu̱'u̱t to̱k-u̱ She̱m. ");
INSERT INTO gel_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Yage̱ Ru̱-u̱ sur tat-u̱ kwu̱m-u̱t Jape̱t, yage̱ Jape̱t no̱m u̱r-yu̱ rimpa-u̱t She̱m, tu̱msu̱ u̱ Kan'ana shu̱'u̱t to̱k-u̱ Jape̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Da-u̱ bu̱-mu̱ re̱-du̱ u-dak arke̱, Nuhu sur m-no̱m se̱ke̱n hak-se̱ u̱t-ko̱k u̱t-tu̱t u̱ u̱t-shik u̱t-yu̱r u̱ o̱p 350. ");
INSERT INTO gel_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nuhu no̱ng u̱s-hak u̱t-ko̱k u̱t-jwu̱r u̱r-shik u̱t-yu̱r u̱ o̱p 950, se̱ wa mu̱ru̱s. ");
INSERT INTO gel_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Tun-to̱ o̱ ogor-tu̱ ya'ag-u̱ Nuhu: She̱m, Ham, u̱ Jape̱t. Na mak-u̱t ya'ag-u̱ campa-ne̱ e̱ da-u̱ bu̱-mu̱ re̱-du̱ u-dak arke̱. ");
INSERT INTO gel_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yaag-u̱ campa-ne̱ Jape̱t e̱ o̱ye̱: Gomar, Mago̱g, Midiya, Jaban, Tubar, Meshek, u̱ Tiras. ");
INSERT INTO gel_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Yaag-u̱ campa-ne̱ Gomar e̱ o̱ye̱: Asukenaz, Ripat, u̱ Togarma. ");
INSERT INTO gel_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yaag-u̱ campa-ne̱ Jaban e̱ o̱ye̱: Erisha, Tarshish, Kittim, u̱ Rodanin. ");
INSERT INTO gel_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ine̱ ya'ag-u̱ ne̱t-u̱t to̱ ne̱, e̱ rwu̱ne̱ du̱gu̱ ko̱-u̱r Jaban i o̱ u̱r-yu̱ u̱-kit m-sa. Yaag-u̱ e̱ shu̱'u̱t u̱t-ko̱, ko̱wan u̱du̱ e̱ rem-de̱, u̱ dak-u e̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Yaag-u̱ campa-ne̱ Ham e̱ o̱ye̱: Kush, Masar, Put, u̱ Kan'ana. ");
INSERT INTO gel_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Yaag-u̱ campa-ne̱ Kush e̱ o̱ye̱: Seba, Havira, Sabata, Raama, u̱ Sabateka. Yaag-u̱ campa-ne̱ Raama e̱ o̱ye̱: Sheba u̱ Dedan. ");
INSERT INTO gel_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kush wa mate̱ Nimro̱, wa o̱ye̱ ne̱t u̱r-taku̱n wu̱ shu̱'u̱te̱ u-ke̱g u̱du̱ m-gag u-dak. ");
INSERT INTO gel_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Wa o̱ye̱ yu̱-shu̱ a u-sa ne̱ u̱-shu̱ Yawe; <<O̱ wa-e̱ na zu̱t Nimro̱, wa o̱ yu̱-shu̱ a u-sa ne̱ u̱-shu̱ Yawe.>> ");
INSERT INTO gel_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Bo̱-tu̱ wu̱n taktu̱n u̱r-faru̱k to̱ o̱o̱ge̱ Babira, u̱ Ere̱k, Akat u̱ Karne̱ ne̱. Bo̱-u̱t to̱ u̱t-nas u̱t-be̱e̱t to̱ o̱ me̱ dak-u̱ Shinar. ");
INSERT INTO gel_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Du̱gu̱ dak-u̱ o̱ wa aru̱k m-ha Asur, se̱ wa mu̱ bo̱-tu̱ Neneba, Rehobot-Ir, Kara-ne̱, ");
INSERT INTO gel_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","tu̱msu̱ Resen, u̱ o̱o̱ge̱ u̱-te̱k u̱ Neneba u̱ Kara-ne̱; o̱ o̱ye̱ bo̱-u yat-o̱. ");
INSERT INTO gel_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Masar wa mate̱: Ruda-ne̱, Anama-ne̱, Rehabita-ne̱, u̱ Naputa-ne̱, ");
INSERT INTO gel_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patarus-ne̱, Kasaruhi-ne̱ (ku̱na Firistiya-ne̱ rwu̱tu̱n), u̱ Kapator-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kan'ana wa mate̱: Sidon, Sidon mat-du̱ u̱r-taku̱n wa, tu̱msu̱ u̱ He̱t-ne̱, ");
INSERT INTO gel_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","u̱ Jebusi-ne̱, u̱ Amoriya-ne̱, u̱ Giragashi-ne̱, ");
INSERT INTO gel_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","u̱ Hiwi-ne̱, u̱ Araki-ne̱, u̱ Sinite-ne̱, ");
INSERT INTO gel_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","u̱ Awadi-ne̱, u̱ Zemara-ne̱, u̱ Hamati-ne̱. Da-u̱ tase̱ ko̱-u̱r Kan'ana, se̱ e̱ bu̱ru̱g ko̱he̱ne̱. ");
INSERT INTO gel_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Tu̱msu̱ bo̱r-su̱ Kan'ana teeg du̱gu̱ Sidon m-ha gas-u̱ Gerar m-te Gaza, tu̱msu̱ m-te bo̱-tu̱ So̱do̱m, u̱ Gomora, u̱ Adma, u̱ Zeboyim ne̱ (u̱t-mo̱r u̱ Rasha ne̱). ");
INSERT INTO gel_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Tunto̱ o̱ye̱ ko̱-tu̱ ya'ag-u̱ campa-ne̱ ko̱-u̱r Ham, ko̱du̱he̱ ko̱-de̱ u̱ du̱ wa rem-de̱, tu̱msu̱ dak-u wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Na mak-tu̱ She̱m ya'ag-u̱ campa-ne̱, wu̱ o̱o̱ge̱ yu̱-wu̱ya Jape̱t. Tu̱msu̱ She̱m wa o̱o̱ge̱ u̱so-u̱ ko̱-u̱r Eber u̱r-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Yaag-u̱ campa-ne̱ She̱m e̱ o̱ye̱: Eram, Ashu̱r, Arpazad, Rud, u̱ Aram. ");
INSERT INTO gel_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Yaag-u̱ Aram e̱ o̱ye̱: Uz, Hur, Geta, u̱ Mash. ");
INSERT INTO gel_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpazad wa mate̱ Shera, Shera wa mate̱ Eber. ");
INSERT INTO gel_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber wa mate̱ ya'ag-u̱ campa-ne̱ yu̱r, Wa gan na zu̱ wa Pereg, remu̱ u̱ da-u o̱ dak-u̱ mo̱te̱, du̱-dim-u̱ wa na zu̱ wa Jokta. ");
INSERT INTO gel_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Jokta wa mate̱: Armodad, Sherep, Hazaramave̱t, Jera, ");
INSERT INTO gel_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzar, Dikara, ");
INSERT INTO gel_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","O̱bar, Abimayer, Sheba, ");
INSERT INTO gel_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opir, Havira u̱ Jobab. Ayan-ne̱ o̱ye̱ ya'ag-u̱ ko̱-u̱r Jokta be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Gas-u̱ dak-u̱ u̱n shu̱'u̱te̱ o̱ yu̱nge̱ du̱gu̱ Mesha m-ha Separ m-ha gas-u̱ ro̱r-tu̱ u-do̱m. ");
INSERT INTO gel_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Tunto̱ o̱o̱ge̱ ko̱-tu̱ ya'ag-u̱ She̱m u̱ka ko̱-u̱t e̱ u̱ rem-u̱t e̱ ne̱, be-tu̱ u̱r-shu̱'u̱t-u̱ e̱ u̱ dak-u̱t e̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Armo̱ ne̱ o̱ye̱ ko̱-du̱ ya'ag-u̱ Nuhu, du̱gu̱ taku̱n-u̱r e̱. Du̱gu̱-du̱ e̱ de̱ rem-tu̱ bu̱rge̱ u-dak u-be̱e̱t, da-u̱ bu̱-mu̱ re̱-du̱ u-dak arke̱. ");
INSERT INTO gel_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","U̱ da-u̱ taku̱n-du̱ u-dak rem-de̱ u̱r-gan du̱ ne̱t-tu̱ nomte̱ u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Da-u̱ ne̱t-tu̱ rwu̱ne̱ du̱gu̱ u-do̱m, e̱ kum dak-u̱ o̱o̱ge̱ nu̱ru̱gse̱ u̱-me̱ dak-u̱ Shinar e̱ shu̱'u̱t u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","E̱ zu̱ o̱r-u̱t e̱ ne̱, <<Haanu̱n in no̱m u̱t-kunku in zom-to̱ so̱k.>> U̱n no̱m u̱t-kunku to̱ shu̱'u̱t u̱ka u̱t-taar, tu̱msu̱ rwab-tu̱ shu̱'u̱t u̱ka m-kwarta. ");
INSERT INTO gel_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","E̱ zu̱, <<Haanu̱n, in no̱mu̱ hi-du̱ war in u-bo̱, u̱ ma-u̱ m-wu̱r u̱ do̱'e̱ te-du̱ do̱m u-ru̱ in no̱mo̱n hi-du̱ war in u̱r-dim taas in bu̱ru̱gse̱ u-dak da.>> ");
INSERT INTO gel_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Tu̱msu̱ Yawe cu̱zu̱n u̱ remu̱ wa got bo̱-u̱ ma-u̱ m-wu̱r u̱ ya'ag-u̱ u̱t-ne̱t o̱ u̱t-ma. ");
INSERT INTO gel_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Yawe zu̱, <<A-mu̱u̱ne̱ zu̱ ne̱t-tu̱ o̱ same̱-du̱ u̱t-hi ne̱ tu̱msu̱ e̱ wu̱r u̱r-rem u̱r-gan e̱ taku̱n no̱m-du̱ go̱-du̱ u̱no̱ no̱m-o̱, o̱ko̱n zaar u̱ e̱ do̱'e̱ u̱t-zo̱ng u̱t-no̱m u̱ do̱'e̱ ze̱g-du̱ be̱b-u̱r e̱ da. ");
INSERT INTO gel_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Haane̱, in ciz u-dak, in wagu̱sse̱ rem-u̱r u̱n, u̱ka u̱n zatte̱ u̱t-nap rem-du̱ o̱r-u̱t u̱n ne̱ o̱ u̱t-war da.>> ");
INSERT INTO gel_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Iya-o̱ Yawe bu̱rgu̱sse̱ u̱n ko̱he̱ne̱ u-dak u-be̱e̱t, se̱ u̱n yage̱ ma-du̱ u-bo̱. ");
INSERT INTO gel_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Remu̱ iya na fogte̱ be-u̱r re̱ Babira, remu̱ zu̱ ku̱na Yawe e̱ngu̱sse̱ u̱t-rem tu̱ u-dak u-be̱e̱t, u̱ ku̱na Yawe bu̱rgu̱sse̱ u̱t-ne̱t u-dak u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Tun-to̱ o̱o̱ge̱ ogor-tu̱ ya'ag-u̱ ko̱-u̱r She̱m. Da-u̱ hak-su̱ u̱s-yu̱r arke̱ ba na tase̱ bu̱-mu̱ re̱-du̱ u-dak, She̱m wa mu̱te̱ Arpazad. Da-u She̱m o̱ u̱s-hak u̱t-shik u̱t-tan 100. ");
INSERT INTO gel_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ba wa mate̱ Arpazad, She̱m sur m-no̱m u̱s-hak u̱t-ko̱k u̱t-tan 500, u̱ te̱k-u̱ hak-su̱ u̱t-ko̱k u̱t-tan wa mu̱t e̱ke̱n ya'ag-u̱ campa-ne̱ u̱ yaat u̱t-gwu̱p-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Da-u̱ Arpazad no̱me̱ u̱r-yu̱ u̱s-hak u̱r-shik u̱ o̱p u̱s-tan 35, se̱ wa mu̱t Shera. ");
INSERT INTO gel_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ba wa mate̱ Shera, Arpazad sur m-no̱m u̱r-yu̱ u̱s-hak u̱t-ko̱k u̱t-nas u̱s-tu̱t 403, u̱ te̱k-u̱ hak-su̱ u̱t-ko̱k u̱t-nas u̱ o̱p u̱s-tu̱t wa mu̱t e̱ke̱n ya'ag-u̱ campa-ne̱ u̱ yaat u̱t-gwu̱p-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Da-u̱ Shera no̱me̱ u̱r-yu̱ u̱s-hak u̱r-shik-u̱ o̱p 30, wa mu̱t Eber. ");
INSERT INTO gel_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ba wa mate̱ Eber, Shera sur m-no̱m u̱s-hak u̱t-ko̱k u̱t-nas u̱s-tu̱t 403, u̱ te̱k-u̱ hak-su̱ u̱t-ko̱k u̱t-nas u̱s-tu̱t wa mu̱t e̱ke̱n ya'ag-u̱ campa-ne̱ u̱ yaat u̱t-gwu̱p-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Da-u̱ Eber no̱me̱ u̱r-yu̱ u̱s-hak u̱r-shik u̱s-o̱p u̱s-nas 34, wa mu̱t Pereg. ");
INSERT INTO gel_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ba wa mate̱ Pereg, Eber sur m-no̱m u̱s-hak u̱t-ko̱k u̱t-nas u̱r-shik u̱ o̱p 430, u̱ te̱k-u̱ hak-su̱ u̱t-ko̱k u̱t-nas u̱ o̱p wa mu̱t e̱ke̱n ya'ag-u̱ campa-ne̱ u̱ yaat u̱t-gwu̱p-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Da-u̱ Pereg no̱me̱ u̱r-yu̱ u̱s-hak u̱r-shik u̱ o̱p 30, se̱ wa mu̱t Re̱wi. ");
INSERT INTO gel_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Tu̱msu̱ ba wa mate̱ Re̱wi, Pereg sur m-no̱m u̱s-hak u̱t-ko̱k u̱t-yu̱r u̱ hak-su̱ u̱s-jwu̱r 209, u̱ te̱k-u̱ hak-su̱ u̱t-ko̱k u̱t-yu̱r u̱ o̱p wa mu̱t e̱ke̱n ya'ag-u̱ campa-ne̱ u̱ yaat u̱t-gwu̱p-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Da-u̱ Re̱wi no̱me̱ u̱r-yu̱ u̱s-hak u̱r-shik u̱ o̱p u̱s-yu̱r 32, se̱ wa mu̱t Shu̱ru̱g. ");
INSERT INTO gel_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ba wa mate̱ Shu̱ru̱g, Re̱wi sur m-no̱m u̱s-hak u̱t-ko̱k u̱t-yu̱r u̱s-ta'e̱r 207, u̱ te̱k-u̱ hak-su̱ u̱t-ko̱k u̱t-yu̱r u̱s-ta'e̱r wa mu̱t e̱ke̱n ya'ag-u̱ campa-ne̱ u̱ yaat u̱t-gwu̱p-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Da-u̱ Shu̱ru̱g no̱me̱ u̱r-yu̱ u̱s-hak u̱r-shik u̱s-o̱p 30, se̱ wa mu̱t Naho̱r. ");
INSERT INTO gel_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ba wa mate̱ Naho̱r, Shu̱ru̱g sur m-no̱m u̱s-hak u̱t-ko̱k u̱t-yu̱r 200, u̱ te̱k-u̱ hak-su̱ u̱t-ko̱k u̱t-yu̱r wa mu̱t e̱ke̱n ya'ag-u̱ campa-ne̱ u̱ yaat u̱t-gwu̱p-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Da-u̱ Naho̱r no̱me̱ u̱r-yu̱ u̱s-hak u̱r-shik u̱s-jwu̱r 29, se̱ wa mu̱t Tera. ");
INSERT INTO gel_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ba wa mate̱ Tera, Naho̱r sur m-no̱m u̱s-hak u̱t-shik u̱t-tan u̱ o̱p u̱s-jwu̱r 119, u̱ te̱k-u̱ hak-su̱ u̱t-shik u̱t-tan u̱ o̱p u̱s-jwu̱u̱r wa mu̱t e̱ke̱n ya'ag-u̱ campa-ne̱ u̱ yaat u̱t-gwu̱p-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ba Tera no̱me̱ u̱r-yu̱ u̱s-hak u̱t-shik u̱t-tu̱t u̱ o̱p 70, se̱ wa mu̱t Ibram, Naho̱r u̱ Haran. ");
INSERT INTO gel_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tun-to̱ o̱ ogu̱r-tu̱ ko̱-u̱r ya'ag-u̱ Tera. Tera wa mate̱ Ibram, u̱ Naho̱r u̱ Haran. Tu̱msu̱ Haran wa mate̱ Ro̱t. ");
INSERT INTO gel_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Da-u̱ u̱so-u wu̱n Tera o̱o̱ge̱ u̱r-fat, Haran mu̱ru̱s u̱ bo̱-u̱ Ur u̱ dak-u̱ Kardiya-ne̱, be-du̱ u̱r-mat u̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ibram no̱mu̱g u̱r-gu̱, tu̱msu̱ Naho̱r nom u̱r-gu̱. Dim-du̱ ne̱ta Ibram wa na zu̱ye̱ Sera, ne̱ta Naho̱r wana zu̱ye̱ Mirka. Mirka u̱ hu̱no-u wa Iska e̱ o̱ye̱ yaat u̱t-gwu̱p u̱ Haran. ");
INSERT INTO gel_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sera o̱ u-maku̱t wa zatte̱ yaag da. ");
INSERT INTO gel_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera kagu̱b wa'-u̱ wa Ibram, u̱ Ro̱t ne̱ zwaru̱ wa'-u̱ wa Haran, u̱ Sera ne̱ ku̱mu̱wa wu̱ o̱ ne̱ta wa'-u̱ wa Ibram. E̱ aru̱k u̱r-kot du̱gu̱ bo̱-u̱ Ur dak-u̱ Kardiya-ne̱ m-ha u̱ dak-u̱ Kan'ana. Tu̱msu̱ da-u̱ e̱ tene̱ bo̱-u̱ Haran, e̱ shu̱'u̱t u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera no̱mu̱g u̱s-hak u̱t-ko̱k u̱t-yu̱r u̱s-tan 205, se̱ wa mu̱ru̱s u̱ Haran. ");
INSERT INTO gel_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yawe zu̱ Ibram, <<Yu̱ne̱, bo̱ yage̱ dak-u ró, u̱ ne̱t-u̱t ró ne̱, u̱ bu-u̱ u̱so-u ró ne̱, bo̱ do̱'e̱ u̱ dak-u̱ u̱m de̱ ko̱su̱ bo̱. ");
INSERT INTO gel_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","<<Me̱ ya'u̱ bo̱ ya'ag, tu̱msu̱ ko̱-u̱r ro u̱t-shu̱'u̱t dak-u yat-o̱, me̱ wa'-u̱ bo̱ nu-u so̱-o̱; Me̱ u̱t-wa bo̱ no̱m u̱r-dim so̱k, remu̱ bo̱ shu̱'u̱te̱ fu̱n-yu̱ kwu̱m-du̱ nu-u so̱-o̱ u̱du̱ e̱ke̱n. ");
INSERT INTO gel_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Me̱ wa'-u̱ nu-u so̱-o̱, u̱du̱ i wa'-u̱ bo̱ nu-u so̱-o̱. Tu̱msu̱ ko̱wana wa'-u̱ bo̱ nu-u yo̱-o̱ me̱ wa'-u̱ wa nu-u yo̱-o̱, Ko̱-tu̱ u-dak u̱t-be̱e̱t e̱ kwu̱m-u̱ nu-u so̱-o̱ du̱gu̱-du̱ ró.>> ");
INSERT INTO gel_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Se̱ Ibram aru̱k, u̱ka Yawe war-tu̱ wa, se̱ Ro̱t dor wa. Da-u̱ wa arke̱ du̱gu̱ bo̱-u̱ Haran, Ibram o̱ u̱s-hak u̱t-shik u̱t-tu̱t u̱ o̱p u̱s-tan 75. ");
INSERT INTO gel_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ibram ku̱b ne̱ta wa Sera, u̱ Ro̱t wa'-u̱ yu̱-wu̱ya wa, u̱ no̱m-tu̱ wa otte̱ ne̱ u̱t-be̱e̱t, u̱ ca wa u̱ na u̱ wa u̱ gwar-u̱ wa u̱ to̱k-ne̱ i u-bu wa ne̱ be̱e̱t tu̱ wa kargu̱sse̱ u̱ dak-u̱ Haran, wa aru̱k m-ha u̱ dak-u̱ Kan'ana. U̱n te ku̱n. ");
INSERT INTO gel_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ibram u̱ ne̱t-tu̱ bu-u wa yu̱ne̱ e̱ aru̱k m-ha me̱n-tu̱ bo̱-u̱ She̱ke̱m. Wa de̱ wa cu̱st-u̱ kug-du̱ yaku̱n te-yu̱ O̱k yu̱ na foge̱ More. U̱ da-u o̱, ne̱t-tu̱ Kan'ana to̱ o̱o̱ge̱ u̱ shu̱'u̱t u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yawe ko̱se̱ hi-u̱r wa u̱du̱ Ibram wa zu̱, <<Me̱ ya'u̱ bo̱ uno̱ dak-o̱ u̱du̱ ko̱-u̱r ró.>> Se̱ Ibram ma'e̱ Yawe u̱r-sak, wu̱ ko̱se̱ hi-u̱r wa u̱du̱ rò. ");
INSERT INTO gel_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Du̱gu̱ ku̱na wa arke̱ m-ha u̱ gas-u̱ ro̱r-tu̱ u-do̱m u̱ Be̱te̱r ne̱. Wa nom rimpa-u̱r wa u̱ku̱n, u̱ te̱k-u̱ Be̱te̱r u̱ gas-u̱ u-ta tu̱msu̱ Ai u̱ gas-u̱ u-do̱m. Wa mu̱ u̱r-sak du̱ no̱m-du̱ to̱o̱g u̱ku̱n wa no̱mu̱ Yawe u̱t-huuk. ");
INSERT INTO gel_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ibram yu̱ne̱ wa re u-shu̱ m-haane̱ m-sa gas-u̱ Ne̱giv. ");
INSERT INTO gel_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","U̱ da-u o̱ na no̱ng u̱s-me̱r u̱ dak-u̱ Kan'ana sok, wa'ag Ibram u̱ cwadu̱ dak-u̱ Masar. Wa shu̱'u̱t u̱ku̱n u̱ka ham-u̱t u-da cashi. ");
INSERT INTO gel_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Da-u̱ e̱ nome̱ u̱t-mo̱r u̱ cwadu̱ Masar ne̱, Ibram zu̱ ne̱ta wa Sera, <<U̱m nak u̱zu̱ bo̱ ne̱ta so̱-wa wa bo̱ o̱o̱ge̱. ");
INSERT INTO gel_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Da-u̱ ne̱t-tu̱ dak-u̱ Masar u̱ hyane̱ bo̱, e̱ do̱'e̱ u̱t-zu̱, <Ne̱ta wu̱nu̱ ya.> E̱ do̱'e̱ ho̱-du̱ me̱ se̱di e̱ yagu̱ bo̱ u̱r-fat. ");
INSERT INTO gel_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Zu̱ u̱n bo̱ hu̱no-u ri o̱, remu̱ zu̱ a-bo̱ waru̱ u̱n iya, u̱nu̱ yagu̱ me̱ u̱r-fat. U̱n za ho̱-du̱ me̱ da u̱ remu̱ ró.>> ");
INSERT INTO gel_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Da-u̱ Ibram tene̱ Masar, ne̱t-tu̱ Masar hyen u̱zu̱ Sera o̱ so̱-ya so̱k. ");
INSERT INTO gel_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Da-u̱ tu̱-yat-to̱ pyu̱-u̱ faru̱k hyane̱ wu̱n, se̱ e̱ no̱m-u̱ wu̱n u̱t-vam u̱-shu̱ Faru̱k-u̱ Masar, na ku̱b wa m-cwa u̱ pyu̱-u̱ faru̱k. ");
INSERT INTO gel_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Remu̱ iya Faru̱k-u̱ Masar no̱m-u̱ Ibram u-nya u-tát u̱ remu̱ Sera: ban-du̱ ca, u̱ gwar-ne̱, u̱ na-ne̱, u̱ so-u̱ janka ne̱, u̱ gob-u̱ janka ne̱, u̱ to̱k-ne̱ ne̱ta-ne̱, u̱ to̱k-ne̱ campa-ne̱, u̱ rakum-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tu̱msu̱ Yawe haatu̱n go̱m-u̱s yasse̱, u̱ bu-u̱ Faru̱k-u̱ Masar u-be̱e̱t u̱ remu̱ Sera, wu̱ o̱o̱ge̱ ne̱ta Ibram. ");
INSERT INTO gel_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Se̱ Faru̱k-u̱ Masar fog Ibram, wa zu̱, <<¿Yan o̱ bo̱ no̱mu̱ me̱ iya? ¿Remu̱ yan-o̱ wa-e̱ bo̱ wargu̱ me̱ u̱zu̱ ne̱ta ró wa da? ");
INSERT INTO gel_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","¿Remu̱ yan-o̱ bo̱ no̱mtu̱ me̱, u̱s-bi u̱zu̱ hu̱no-u ró wa? Bo̱ za nom-u̱t iya da! U̱ da-o̱ kab ne̱ta ró, bo̱ yage̱ be-u̱r rinde̱ bo̱ aru̱k.>> ");
INSERT INTO gel_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Se̱ Faru̱k-u̱ Masar wu̱ e̱ke̱n to̱k-ne̱ wa u̱ e̱ shu̱'e̱ Ibram u̱ ne̱t-u̱t wa ne̱. Se̱ u̱n ku̱b Ibram tu̱msu̱ u̱n tok wa, wa aru̱k, u̱ ne̱ta wa ne̱ u̱ no̱mu̱ wa otte̱ ne̱ u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ibram e̱ ne̱ta wa e̱ yage̱ Masar, e̱ ku̱b no̱m-tu̱ e̱ o̱tte̱ u̱t-be̱e̱t, tu̱msu̱ Ro̱t dor u̱n m-no̱k m-cwa do̱g-du̱ Ne̱giv ");
INSERT INTO gel_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ibram shu̱'u̱te̱ wa u̱t-kwu̱m sok, u̱t-bisa ne̱, u̱ kwam-tu̱ shik ne̱ tu̱ bu̱-mu̱ u̱t-ro u̱ tu̱ pus-to̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ibram ne̱ hu̱ u̱t-riig du̱gu̱ Ne̱giv m-te bo̱-u̱ Be̱te̱r m-ha de̱ku̱n be-de̱ u̱ te̱k-u̱ bo̱-u̱ Be̱te̱r u̱ bo̱-u̱ Ai ne̱, e̱ tamu̱g u̱t-cu̱st e̱ nom rimpa-u̱t e̱ u̱ be-u̱r re̱. ");
INSERT INTO gel_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Tu̱msu̱ be-du̱ Ibram maate̱ Yawe u̱r-sak. Ku̱na Ibram nomte̱ Yawe u̱t-huuk u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ro̱t, wu̱ no̱me̱ m-ha e̱ Ibram, ko̱wa wa o̱tte̱ ban-tu̱ ca, u̱ ban-tu̱ gwaar ne̱, u̱ ban-tu̱ na ne̱, u̱t-rimpa ne̱ u-tát. ");
INSERT INTO gel_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Se̱di e̱ o̱tte̱ u̱t-bisa u-tát, tu̱ do̱'e̱ hosu̱ u̱n u̱r-shu̱'u̱t u̱r-be u̱r-gan. Do̱g-du̱ gwat-du̱ u̱t-bisa nom u̱n cashi u̱ bu̱-mu̱ u̱s-swa ne̱, u̱ no̱m-tu̱ u̱t-re̱ tu̱ u̱t-bisa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Se̱ har u̱ to u̱ te̱k-u̱ a-gwat-du̱ bisa-u̱t Ro̱t ne̱ u̱ a-gwat-du̱ bisa-u̱t Ibram ne̱. Tu̱msu̱ ne̱t-tu̱ Kan'ana u̱ ne̱t-tu̱ Periziya-ne̱ o̱ shu̱'u̱t u̱ku̱n u̱ da-u o̱. ");
INSERT INTO gel_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ibram zu̱ Ro̱t, <<Remu̱ u̱zu̱ in hu̱u̱b-tu̱ u̱r-mat to̱ na o̱o̱ge̱, no̱ng u̱r-zwar na ho̱g in u-har da, ko̱ te̱k-u̱ a-gwat-du̱ u̱t-bisa ró u̱ a-gwat-du̱ u̱t-bisa ri ne̱ da. ");
INSERT INTO gel_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","¿Dak-u u-no u-be̱e̱t o̱ za u̱-shu̱ ró da? Du̱ste̱ gas-u̱ cite̱ bo̱ u̱ bo̱ o̱o̱ge̱ u̱ssa, u̱ yu̱-u mo̱t. Abite̱ Gas-u̱ kom u̱r-beer o̱ bo̱ o̱o̱ge̱ u̱ssa, se̱ u̱m kab Gas-u̱ kom u̱t-cwa. Abite̱ u̱zu̱ kom u̱t-cwa o̱ bo̱ o̱o̱ge̱ u̱ssa, se̱ u̱m kab Gas-u̱ kom u̱r-beer.>> ");
INSERT INTO gel_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ro̱t jaku̱s is-u̱ wa wa hyen gas-u̱ fu̱g-yu̱ Jodan u-be̱e̱t, m-te Zo̱war, o̱tte̱ m-bu̱ ko̱he̱ne̱. Gas-u o̱ u-be̱e̱t, be-to̱ so̱-to̱ u̱ka tak-u̱ Yawe tu̱msu̱ u̱ka dak-u̱ Masar. (Na no̱ng iya kanda Yawe ho̱ru̱sse̱ So̱do̱m u̱ Gomora ne̱.) ");
INSERT INTO gel_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Se̱ Ro̱t du̱stu̱ hi-du̱ war-wa gas-u̱ gote̱ fu̱g-yu̱ Jodan m-sa gas-u u-do̱m. Wa aru̱k u̱ gas-u o̱ u̱ bisa-u̱t wa ne̱ u̱ to̱k-ne̱ wa ne̱ be̱e̱t, tu̱msu̱ e̱ bu̱rgu̱sse̱ e̱ Ibram. ");
INSERT INTO gel_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ibram aru̱k u̱ gas-u̱ dak-u̱ Kan'ana, Ro̱t shu̱'u̱t u̱ gas-u̱ bo̱-tu̱ gi-yu̱ Jodan se̱ wa ku̱ u̱t-rimpa u̱ dapu̱s So̱do̱m. ");
INSERT INTO gel_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ne̱t-tu̱ bo̱-u̱ So̱do̱m ne̱t-u̱t yo̱-to̱ to̱ tu̱msu̱ e̱ o̱ yu̱-du̱ u̱t-ba'as sok u̱du̱ Yawe. ");
INSERT INTO gel_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","U̱-dim da-u̱ Ibram mo̱te̱ u̱ Ro̱t ne̱, Yawe zu̱ Ibram, <<Bir bo̱ gwat be-du̱ bo̱ o̱tte̱ u̱r-be̱e̱t. Gwat gas-u̱ kom u̱r-beer gas-u̱ kom u̱t-cwa ne̱, u-do̱m u-ta ne̱. ");
INSERT INTO gel_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Me̱ ya'u̱ bo̱ dak-u u-no u-be̱e̱t, bo̱ u̱ ya'ag-u̱ ró ne̱ m-mo̱mmo̱. ");
INSERT INTO gel_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Me̱ u̱t-wa ko̱-u̱r ró no̱m u-tát u̱ka tat-u̱ m-hereg! Wu̱ kere̱ o̱gru̱ hereg-mu̱ u-gi wa keru̱ o̱gru̱ u̱ ko̱-u̱t ró. ");
INSERT INTO gel_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Yu̱ne̱ bo̱ nar dak-u o̱ u-be̱e̱t ko̱he̱ne̱, u̱m o̱ yasu̱ bo̱ o̱.>> ");
INSERT INTO gel_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Se̱ Ibram hast rimpa-u̱t wa, wa aru̱k, wa shu̱'u̱t u̱ dapu̱s se̱ke̱n te-u̱s yat-se̱ su̱ O̱k u̱ Mamre u̱ bo̱-u̱ He̱bro̱n. U̱ be-u̱r re̱, wa maate̱ Yawe u̱r-sak du̱ to̱o̱g. ");
INSERT INTO gel_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","U̱ da-u o̱ gag-mu̱ yu̱nne̱ u̱ gas-u o̱. U̱ da-u̱ Amraper faru̱k-u̱ Shinar, u̱ Ariyo faru̱k-u̱ u̱ Erasar, u̱ Kedoramar faru̱k-u̱ Eram, u̱ Tidar faru̱k-u̱ Goyim, ");
INSERT INTO gel_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","e̱ ru u̱ remu̱ e̱ nom-u̱t m-gag u̱ Bera ne̱ faru̱k-u̱ So̱do̱m ne̱, Birha faru̱k-u̱ Gomora, Shinab faru̱k-u̱ Adma, u̱ Shimeba faru̱k-u̱ Zeboyim, u̱ faru̱k-u̱ Bera ne̱ Tu̱msu̱ ne̱t-tu̱ fog bo̱-u̱ Bera <<Zo̱war.>> ");
INSERT INTO gel_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Tun-to̱ faru̱k-to̱ u̱t-tan e̱ same̱ ne̱t-tu̱ m-gagu̱ e̱ fu̱g-yu̱ Sidim <<yu̱ na foge̱ Sa-mu̱ u̱t-ma.>> ");
INSERT INTO gel_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","U̱s-hak o̱p u̱s-yu̱r e̱ o̱ do̱rru̱ Kedoramar faru̱k-u̱ Eram, se̱di u̱ hak-yu̱ o̱p u-tu̱tu̱rse̱ u̱n nom gu̱g-mu̱ u̱s-rem u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","U̱ hak-yu̱ o̱p u̱s-nas 14, se̱ Kedoramar faru̱k-u̱ Eram u̱ farkina-ne̱ i o̱o̱ge̱ u̱r-kot u̱ wa ne̱, e̱ do̱'e̱ e̱ re ne̱t-tu̱ bo̱-u̱ Refatis m-gag u̱ bo̱-u̱ Asterot Karayin ne̱, u̱ ne̱t-tu̱ Zuzi-ne̱ u̱ bo̱-u̱ Ham, tu̱msu̱ ne̱t-tu̱ Emim-ne̱ ne̱ u̱ bo̱-u̱ She̱ve̱ u̱ Kiriyatim ne̱, ");
INSERT INTO gel_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","u̱ ne̱t-tu̱ Hori ne̱ u̱ do̱m-u̱ ro̱r-du̱ Seyir, m-sa gas-u̱ Er-paran-ne̱ u̱ dapu̱s u̱r-do̱g. ");
INSERT INTO gel_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Se̱ u̱n mu̱u̱n u-dim u̱n do̱'e̱ u̱ bo̱-u̱ Mispat (du̱ na foge̱ u̱ da-u o̱ Kades). U̱n re gas-u̱ ne̱t-tu̱ Amerek o̱tte̱ u̱ shu̱'u̱t m-gag, tu̱msu̱ u̱r-kot u̱ Amoriya-ne̱ i o̱ shu̱'u̱t bo̱-u̱ Hazazon Tamar. ");
INSERT INTO gel_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Se̱ farku̱ So̱do̱m u̱ farku̱ Gomora ne̱, u̱ faru̱k-u̱ Adma ne̱, u̱ faru̱k-u̱ Zeboyim ne̱ u̱ faru̱k-u̱ Bera (tu̱msu̱ u̱ na zu̱ye̱ Zo̱war) e̱ do̱'e̱ e̱ nom zo̱ng-su̱ m-gag fu̱g-yu̱ Sidim. ");
INSERT INTO gel_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","E̱ ru e̱ nom m-gag u̱ Kedoramar ne̱ faru̱k-u̱ Eram, u̱ Tidar ne̱ faru̱k-u̱ Goyim, u̱ Amraper ne̱ faru̱k-u̱ Shinar, u̱r-kot u̱ Ariyo ne̱ faru̱k-u̱ Erasar. U̱t-faru̱k u̱t-nas to̱ nom m-gag u̱ faru̱k-tu̱ u̱t-tan ne̱. ");
INSERT INTO gel_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Fu̱g-yu̱ Sidim otte̱ u̱t-kub u̱ u-rwabu̱r ne̱. Tu̱msu̱ da-u̱ faru̱k-u̱ So̱do̱m u̱ faru̱k-u̱ Gomora ne̱ ku̱sme̱, to̱ko̱n ne̱t-to̱ heemse̱ u-rwabu̱r tu̱msu̱ e̱ke̱n som m-da do̱m u̱t-ro̱r. ");
INSERT INTO gel_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Faru̱k-tu̱ u̱t-nas e̱ ku̱b cwu̱-tu̱ ne̱t-tu̱ So̱do̱m u̱ Gomora ne̱ u̱ no̱m-tu̱ u̱t-re̱ e̱ ne̱ u̱t-be̱e̱t, se̱ e̱ yu̱ne̱ e̱ aru̱k. ");
INSERT INTO gel_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Tu̱msu̱ u̱n maas Ro̱t wa'-u̱ yu̱wu̱ya Ibram. Ro̱t o̱ u̱ shu̱'u̱t u̱ So̱do̱m, tu̱msu̱ u̱n ku̱b no̱m-tu̱ wa otte̱ ne̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Se̱di wa-gan u̱ te̱k-u̱ ne̱t-u̱t Ro̱t wa ku̱su̱m wa do̱'e̱ wa waru̱ Ibram no̱mu̱ u̱n no̱me̱ u-be̱e̱t u̱ ne̱t-u̱t Eber-ne̱. Da-u o̱ Ibram o̱ shu̱'u̱t u̱ dapu̱s te-u̱s yat-se̱ su̱ Mamre, ne̱tu̱ Amoriya-ne̱. Ibram no̱ng este̱du̱ u̱s-rem u̱ Mamre u̱ o̱r-u̱t wa ne̱ yu̱r Esko̱r u̱ Aner ne̱, e̱ same̱ u̱t-hi u̱ Ibram ne̱. ");
INSERT INTO gel_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Da-u̱ Ibram ho̱ge̱ u̱zu̱ na maste̱ wa'-u̱ yu̱-wu̱ya wa Ro̱t, wa kargu̱sse̱ ne̱t-tu̱ na iise̱ m-gag ne̱t-tu̱ me̱ bu-u wa u̱t-ko̱k u̱t-tu̱t u̱ o̱p-u̱ eer 318. E̱ yu̱ne̱ e̱ buz karma-ne̱ Kedoramar m-ha u̱ Dan. ");
INSERT INTO gel_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Da-u̱ gyu̱p-mu̱ no̱me̱, Ibram mo̱t ne̱t-u̱t wa u̱t-kir u̱t-kir. E̱ he̱e̱se̱ karma-ne̱ u̱n m-gag ko̱yu̱he̱ gas-ya u̱n re e̱ m-gag. U̱n buz u̱n m-te Hoba, u̱ o̱o̱ge̱ u̱ m-eru̱g mu̱ kom u̱r-beer u̱ bo̱-u̱ Dimaskus ne̱. ");
INSERT INTO gel_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ibram o̱nku̱n no̱m-tu̱ na kabe̱ u̱t-be̱e̱t. Wa o̱nku̱n Ro̱t wa'-u̱ yu̱wu̱ya wa u̱ no̱m-tu̱ Ro̱t otte̱ ne̱ u̱t-be̱e̱t u̱ ne̱ta wa ne̱ u̱ to̱ku̱n ne̱t-to̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ba Ibram mu̱u̱ne̱ da wa tase̱ re̱-du̱ ne̱t-tu̱ Kedoramar u̱ ne̱t-u̱t wa ne̱ m-gag, faru̱k-u̱ So̱do̱m do̱'e̱ wa bit Ibram u̱ fu̱g-yu̱ She̱ve̱ (yu̱ na zu̱ye̱ Fu̱g-yu̱ Faru̱k). ");
INSERT INTO gel_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Merkize̱de̱k faru̱k-u̱ Sare̱m wa rwu̱tu̱n u̱r-be̱re̱di u̱ ke̱ ne̱. Wa o̱o̱ge̱ wa-to̱o̱g yu̱ u-Ru̱ wu̱ Zu̱ge̱ u̱r-Be̱b. ");
INSERT INTO gel_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Se̱ wa wa'-u̱ Ibram nu-u so̱-o̱, wa zu̱, <<Yage̱ u-Ru̱ wu̱ Ze̱ge̱ u̱r-Be̱b, wu̱ no̱me̱ do̱m u-ru̱ u-dak-ne̱, u̱ wa wa'-u̱ bo̱ nu-u so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Yage̱ na no̱mu̱ u-Ru̱ wu̱ ze̱ge̱ u̱t-vam, wu̱ ya'u̱ bo̱ re̱-du̱ u̱r-ko̱rro̱ do̱m-u̱ hu̱u̱b-u̱t yo̱-to̱ ró.>> Se̱ Ibram yase̱ Merkize̱de̱k u̱r-kwu̱s u̱r-gan u̱ te̱k u̱t-o̱p u̱-me̱ no̱m-tu̱ wa o̱nko̱n u̱ kom-u̱t u̱n u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Se̱ faru̱k-u̱ So̱do̱m zu̱ Ibram, <<Mu̱tu̱n me̱ ne̱t-u̱t ri tu̱ na mase̱. Se̱di cinu̱ hi-du̱ war ró cwu̱-tu̱ bo̱ o̱nku̱n u̱t-be̱e̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Se̱ Ibram zu̱ faru̱k-u̱ So̱do̱m, <<U̱m no̱ngu̱ Yawe este̱du̱ u̱s-rem, u-Ru̱ wu̱ Zu̱ge̱ u̱r-Be̱b, wu̱ nome̱ do̱m u-ru̱ u-dak-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","U̱m zu̱u̱g u̱m zaar u̱ kab-du̱ o̱ko̱n no̱m-o̱ du̱gu̱-du̱ ró da, ko̱ u-randi u-gan, ko̱ na-u̱ u-kaat u-gan, remu̱ zu̱ taas bo̱ zu̱, <Me̱ wa wa'e̱ Ibram kum-u̱t no̱m u̱t-kom.> ");
INSERT INTO gel_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Me̱ o̱nk-u̱ no̱mu̱ ya'ag-u̱ be̱b-ne̱ ri i m-gag tase̱ u̱t-rees u̱ war-o. Tu̱msu̱ u̱m o̱ u̱ ko̱n-u̱s ró bo̱ ya' hu̱u̱b-u̱t ri Aner, Esko̱r, u̱ Mamre o̱g-du̱ cwu̱-tu̱ e̱ o̱nku̱n m-gag.>> ");
INSERT INTO gel_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ba da-u̱ arke̱, Yawe no̱m u̱s-rem u̱ Ibram ne̱ u̱ bo' u̱zu̱, <<Ibram, a-bo̱ ho̱g u-gye̱r da, remu̱ u̱zu̱ me̱ u̱t-e̱' bo̱, o̱g-u̱r ró u̱t-no̱m u-tát.>> ");
INSERT INTO gel_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ibram zu̱, <<Yawe, U̱so-u̱ u-bu ri, ¿remu̱ re̱me̱r-mu̱ yan-o̱ bo̱ do̱te̱ ya'u̱ me̱ tun-to̱ no̱m-to̱ me̱ ya u̱m zatte̱ wa' da? Bo̱ yaag me̱ ya'ag da, ¿ko̱ Eriyazer du̱gu̱ Dimaskus, to̱k u-bu ri wa do̱'e̱ u̱ re̱-du̱ no̱m u̱t-kom-u̱ ri? ");
INSERT INTO gel_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Bo̱ yaag me̱ ya'ag da, to̱k-u̱ u-bu ri de̱ shu̱'u̱tu̱ wa re̱-du̱ no̱m-u̱ u̱t-kom ri.>> ");
INSERT INTO gel_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Se̱ Yawe no̱m u̱s-rem, <<Iya-o̱ da, to̱k-u̱ ró zaar u̱t-shu̱'u̱t wu̱ do̱'e̱ u̱ re̱-du̱ o̱g-du̱ u-bu ró da. Bo̱ do̱'e̱ u̱ kwu̱m-du̱ ya-du̱ u̱r-campa du̱ hi-u̱r ró wa do̱'e̱ u̱ re̱-du̱ no̱m-u̱ u̱t-kom tu̱ u-bu ró.>> ");
INSERT INTO gel_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Wa-ko-uyan rwu̱tu̱n wu̱n u̱-do̱ wa zu̱ wu̱n, <<Jakse̱ is bo̱ gwat do̱m u-Ru̱ bo̱ ogor re̱ge̱r abite̱ bo̱ u̱t-ker. Iya-o̱ ko̱-u̱r ró do̱te̱ u̱t-shu̱'u̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Se̱ Ibram ye jab u̱du̱ Yawe, tu̱msu̱ Yawe got wu̱n wa no̱m-du̱ no̱m-u̱t so̱-to̱ u̱ remu̱ yadu̱ jab-u̱ wu̱n u̱du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Se̱ wa zu̱ wu̱n, <<Me̱ wa Yawe wu̱ rwu̱tu̱n bo̱ du̱gu̱ Ur dak-u̱ Kardiya-ne̱ remu̱ u̱m ye'et bo̱ uno̱ dak-o̱, o̱ shu̱'u̱t u̱ ró.>> ");
INSERT INTO gel_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Se̱ Ibram shu̱s wa zu̱, <<U̱so-u̱ u-bu ri Yawe ¿re̱-o̱ u̱m do̱te̱ u̱t-nap u̱zu̱ dak-u uno̱ u̱t-shu̱'u̱t u̱ ri?>> ");
INSERT INTO gel_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Yawe zu̱ wu̱n, <<Haatu̱n me̱ so̱-yu̱ u-na yu̱ u̱s-hak u̱s-tu̱t, u̱ so̱-yu̱ u-gwaar ne̱ yu̱ u̱s-hak u̱s-tu̱t, u̱ kag-yu̱ u-ca ne̱ yu̱ u̱s-hak u̱s-tu̱t, u̱r-gorop ne̱, u̱r-tu̱ntu̱bu̱r ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ibram haatu̱n no̱m-u̱t to u̱t-be̱e̱t u̱du̱ u-Ru̱. Se̱ wa kwu̱pu̱rse̱ bisa-u̱t to̱ wa mot to̱ u-yu̱r ho̱n-ho̱n wa cin to̱ ko̱wan m-gwat o̱r-u̱ wa. Se̱di wa kwu̱pu̱rte̱ no e̱ da. ");
INSERT INTO gel_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Da-u̱ sagra he̱e̱ne̱ u-dak e̱ tu̱'u̱t ap-mu̱ no̱m-u̱t to̱, Ibram buz e̱. ");
INSERT INTO gel_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Da-u̱ ho̱-du̱ do̱'e̱ m-he̱, roog-mu̱ ho Ibram, se̱ cwu̱m-yu̱ ya-du̱ u-gye̱r taku̱s wu̱n. ");
INSERT INTO gel_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Se̱ Yawe zu̱ Ibram, <<Nap u̱zu̱ ko̱-u̱r ró u̱t-shu̱'u̱t u̱ka u̱t-hamu̱t u̱ dak-u̱ zaare̱ dak-u e̱ da. Na do̱'e̱ wadu̱ e̱ m-to̱k tu̱msu̱ e̱ do̱'e̱ swadu̱ u̱r-ko̱b u̱s-hak u̱t-ko̱k u̱t-nas 400. ");
INSERT INTO gel_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Se̱di me̱ u̱t-ya dak-u̱ u̱n no̱me̱ m-to̱k u̱r-ko̱b, da tase̱ u̱m do̱'e̱ u̱t-wa u̱n ru du̱gu̱ dak-u o̱ u̱ no̱m-u̱ u̱t-kwu̱m ne̱ u-tát. ");
INSERT INTO gel_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Bo̱ tu̱msu̱, bo̱ u̱t-ha u̱du̱ u̱so-u̱t ró m-yar tu̱msu̱ na do̱'e̱ u̱ jwak-du̱ bo̱ u̱ teku̱ wu̱u̱r so̱-de̱. ");
INSERT INTO gel_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ba te̱k-u̱ cara-u u-nasu̱rse̱ ko̱-u̱r ró do̱'e̱ u̱t-mu̱u̱n u̱ ane̱, tu̱msu̱ e̱ kab dak-u uno̱ u̱ e̱ re ne̱t-tu̱ Amoriya-ne̱ m-gag remu̱ zu̱ ba'as-tu̱ ne̱t-u̱t to̱ shu̱u̱g u-ro ne̱ da u̱ na do̱te̱ ya-du̱ e̱ u̱r-ko̱b da.>> ");
INSERT INTO gel_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Da-u̱ ho̱-du̱ he̱ye̱ dak-u̱ no̱ngo̱n u-cwu̱m, se̱ Ibram hyen rem-du̱ u-ra u̱ rwu̱du̱ m-fu̱'u̱t u̱ u-ra ne̱ u̱ o̱ m-to̱k de̱ rwu̱u̱n, de̱ haan de̱ o̱ m-da u̱ te̱k-u̱ ap-mu̱ Ibram keme̱. ");
INSERT INTO gel_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","U̱ ho̱-u̱r re, Yawe no̱m este̱du̱ u̱s-rem u̱ Ibram ne̱ wa zu̱, <<Me̱ ya'u̱ ya'ag-u̱ ró uno̱ dak-o̱, du̱gu̱ gi-yu̱ Masar m-ha u̱ gi-u yat-ya yu̱ Yupireti ne̱. ");
INSERT INTO gel_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Me̱ u̱t-ya bo̱ dak-u̱ Keni-ne̱, u̱ Kenizi-ne̱, u̱ Kadmona-ne̱, ");
INSERT INTO gel_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","u̱ ne̱t-tu̱ He̱t-ne̱, u̱ Periziya-ne̱, u̱ Rifatis-ne̱, ");
INSERT INTO gel_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","u̱ Amoriya-ne̱, u̱ Kan'ana-ne̱, u̱ Giragashi-ne̱, u̱ Jebusi-ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sera ne̱ta Ibram, wa mak-tu̱ wa yaag da, se̱di wa o̱tte̱ to̱k-u̱ ne̱ta wu̱ o̱o̱ge̱ ne̱tu̱ dak-u̱ Masar wu̱ na zu̱ye̱ Hajara. ");
INSERT INTO gel_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sera zu̱ Ibram, <<Yawe hooste̱ me̱ u̱r-mat, cwa bo̱ roog u̱ to̱k-u̱ ri ne̱, jiya me̱ u̱t-kwu̱m yaag du̱gu̱-du̱ wa.>> Ibram ees u̱ no̱mu̱ Sera waru̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Da-u̱ Ibram no̱me̱ u̱s-hak u̱s-o̱p u̱ shu̱'u̱t dak-u̱ Kan'ana, Sera, ne̱ta wa, ku̱b Hajara wu̱ Masar wa yasu̱ Ibram u̱ wa shu̱'u̱t ne̱ta wa. ");
INSERT INTO gel_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ibram roog u̱ Hajara ne̱, wa nom me̱n-tu̱ ub. Da-u̱ Hajara hyane̱ u̱zu̱ wa u̱t-me̱n ne̱, wa hu̱ u̱ ju̱rmu̱ ino-u̱ u-bu wa. ");
INSERT INTO gel_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sera zu̱ Ibram, <<Bo̱ wa wa-e̱ uno̱ no̱m o̱ u-be̱e̱t. U̱m ya'aste̱ bo̱ Hajara, da-u̱ wa hyane̱ wa kwu̱mu̱g me̱n-tu̱ ub wa hu̱ u̱ ju̱rmu̱ me̱. Yage̱ Yawe no̱mu̱ in kwu̱b-du̱ u̱s-rem u̱ no̱m-u uno̱ u̱ bo̱ no̱mu̱ me̱.>> ");
INSERT INTO gel_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ibram shasu̱ Sera, <<To̱k-u̱ ró wa, no̱mu̱ wu̱n u̱ka cittu̱ bo̱.>> Se̱ Sera hu̱ ko̱su̱ wu̱n m-to̱k, se̱ Hajara som du̱gu̱-du̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Wa-to̱m-u̱ Yawe hyen Hajara u̱ kit-u̱ pe̱r-mu̱ m-bu̱ u̱r-do̱g, u̱ dapu̱s fu̱n-yu̱ ha-mu̱ bo̱-u̱ Shur. ");
INSERT INTO gel_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Wa zu̱, <<Hajara to̱k-u̱ Sera ¿du̱gu̱ he̱ne̱ o̱ bo̱ o̱o̱ne̱, tu̱msu̱ he̱ bo̱ o̱tte̱ m-ha?>> Wa zu̱, <<U̱m so̱mgo̱n du̱gu̱-du̱ ino-u̱ u-bu ri Sera.>> ");
INSERT INTO gel_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Wa-to̱m Yawe zu̱ wu̱n, <<Barme̱ u̱du̱ ino-u̱ u-bu ró, bo̱ yase̱ hi-u̱r ró u̱du̱ wa.>> ");
INSERT INTO gel_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Wa-to̱m Yawe sur m-zu̱ wu̱n, <<Me̱ u̱t-wa ya'ag-u̱ ró no̱m u-tát, na za ke̱rru̱ ogru̱ e̱ da.>> ");
INSERT INTO gel_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Wa-to̱m Yawe zu̱ wu̱n, <<Bo̱ ya me̱n-tu̱ ub ne̱, bo̱ do̱'e̱ u̱ mat-du̱ ya-du̱ u̱r-campa. Bo̱ te̱'e̱ wa'-u̱ wa u̱r-dim Ismaru, remu̱ zu̱ Yawe ho̱k kan-u̱s rò su̱ swadu̱ u̱r-ko̱b ro ne̱. ");
INSERT INTO gel_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Wa do̱'e̱ u̱t-shu̱'u̱t u̱ka janka-yu̱ u̱r-do̱g yu̱ ne̱t, Tu̱msu̱ wa do̱'e̱ u̱ no̱m-du̱ shu̱'u̱t-u̱r yo̱-de̱ u̱ ko̱wan ne̱, ko̱wan do̱'e̱ u̱ no̱m-du̱ shu̱'u̱t-u̱r yo̱-de̱ u̱ wu̱n ne̱. Wa do̱'e̱ u̱t-shu̱'u̱t m-ra u̱ o̱r-u̱t wa ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Du̱gu̱ ku̱n, Hajara fog Yawe u̱ de̱ku̱n dimde̱, wu̱ no̱me̱ u̱s-rem u̱ wane̱, wa zu̱, <<Bo̱ wa u-Ru̱ u̱ hyene̱ me̱.>> Wa sur m-zu̱, <<¿Nip-to̱ u̱zu̱ u̱m hyanu̱g wu̱ hyene̱ me̱?>> ");
INSERT INTO gel_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Remu̱ iya-o̱ wu̱te̱ na fog-u̱t du-u̱r re̱ Beer-Rahai Roi, wata <<Ru̱-u̱ u̱r-fat wu̱ hyene̱ me̱.>> De̱ o̱ u̱ku̱n u̱ te̱k-u̱ bo̱-tu̱ Kades u̱ Bered ne̱. ");
INSERT INTO gel_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hajara matu̱ Ibram ya-du̱ u̱r-campa, Ibram te̱'e̱ wa u̱r-dim Ismaru. ");
INSERT INTO gel_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ibram o̱o̱g u̱s-hak u̱t-shik u̱t-nas u̱s-shishin 86 da-u̱ Hajara matu̱ wa Ismaru. ");
INSERT INTO gel_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Da-u̱ Ibram no̱me̱ u̱s-hak u̱t-shik u̱t-nas u̱ o̱p u̱s-jwu̱u̱r 99, Yawe haan u̱du̱ wu̱n wa zu̱ wu̱n, <<Me̱ wa Yawe u-Ru̱ wu̱ o̱tte̱ be̱b-du̱ ko̱-uyan, no̱mu̱ me̱ m-to̱k u-me̱ jab-u̱ so̱-o̱ tu̱msu̱ bo̱ shu̱'u̱t za u̱r-pyap. ");
INSERT INTO gel_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Me̱ u̱t-no̱m este̱du̱ u̱s-rem u̱ bo̱ ne̱, me̱ u̱t-wa ko̱-u̱r ró e̱ no̱m u-tát sok.>> ");
INSERT INTO gel_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Se̱ Ibram kaku̱s hi-u̱r wa u-dak, tu̱msu̱ Ru̱-u̱ zu̱ wa, ");
INSERT INTO gel_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","<<Este̱du̱ u̱s-rem-u̱ ri ya u̱ bo̱ ne̱, ne̱t-tu̱ u̱t-dak u-tát to̱ do̱'e̱ u̱t-shu̱'u̱t ko̱-u̱t ró. ");
INSERT INTO gel_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Na zamu̱n u̱ fag-du̱ bo̱ Ibram da, dim-u̱r ró do̱'e̱ u̱t-shu̱'u̱t Ibrahi, rem u̱zu̱ u̱m wa'ag bo̱ shu̱'u̱t u̱so u̱ u̱t-dak u-tát. ");
INSERT INTO gel_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Me̱ u̱t-wa bo̱ mat yaag u-tát, ya'ag-u̱ ró do̱'e̱ u̱t-shu̱'u̱t u̱t-dak u-tát, du̱gu̱-du̱ ró de̱ faru̱k-tu̱ do̱te̱ u̱ rwu̱u̱n. ");
INSERT INTO gel_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Me̱ u̱t-no̱m este̱du̱ u̱s-rem su̱ m-mo̱mmo̱ u̱ bo̱ ne̱ tu̱msu̱ u̱ ya'ag-u̱ ró ne̱ u̱ ko̱-u̱r ró du̱ do̱'e̱ u̱ haan ne̱. U̱m shu̱'u̱t Ru̱-u ró u̱ Ru̱-u̱ ko̱-u̱t ró ne̱ tu̱ do̱'e̱ u̱ haan u̱ dim-u̱ ró. ");
INSERT INTO gel_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Dak-u̱ Kan'ana u-be̱e̱t, u̱ bo̱ o̱o̱ge̱ shu̱'u̱t-du̱ u̱r-hamu̱t o̱, me̱ ya'u̱ bo̱ dak-u o̱ u̱ o̱ shu̱'u̱t u̱ ró m-mo̱mmo̱ u̱ ya'ag-u̱ ró ne̱ i do̱'e̱ haan u̱ dim-u̱ ró, me̱ u̱t-shu̱'u̱t Ru̱-u e̱.>> ");
INSERT INTO gel_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ru̱-u̱ zu̱ Ibrahi, <<Se̱di bo̱ u̱m u̱t-sa bo̱ ship este̱du̱ u̱s-rem-u ri, bo̱ u̱ ko̱-u̱t ró ne̱ be̱e̱t i do̱'e̱ u̱ haan u̱ dim-u̱ ró remu̱ dak-tu̱ de̱ haan. ");
INSERT INTO gel_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Este̱du̱ u̱s-rem u̱ ri ya su̱ u̱m o̱o̱ge̱ u̱t-no̱m u̱ bo̱ ne̱ u̱ ya'ag-u̱ ró ne̱, ya-du̱ u̱r-campa u̱r-be̱e̱t se̱ na no̱ngu̱ de̱ u̱r-pe̱s. ");
INSERT INTO gel_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Se̱ na no̱ngu̱ no̱ u̱r-pe̱s, u̱t-ko̱se̱ u̱zu̱ u̱m no̱ng este̱du̱ u̱s-rem u̱ no̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Du̱gu̱ u-cara m-te̱ o̱ko̱n cara-o̱, ya-du̱ u̱r-campa u̱r-be̱e̱t se̱ na no̱ngu̱ de̱ u̱r-pe̱s u̱ ho̱-du̱ roog-mu̱ u̱t-eer u̱r-mat ne̱. Za ya-ubu ró ne̱ war-e̱ da tu̱msu̱ u̱ to̱k-ne̱ i na mate̱ bu-u ró tu̱msu̱ u̱ to̱k-ne̱ i bo̱ o̱ne̱ u̱ shik du̱gu̱ do̱ i mate̱. ");
INSERT INTO gel_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Se̱ na no̱ngu̱ e̱ be̱e̱t u̱r-pe̱s, ko̱ i na mate̱ bu-u̱t no̱ ko̱ i na o̱ne̱ u̱ shik, war-u̱t no̱ do̱'e̱ ko̱se̱-du̱ sha-mu̱ este̱du̱ rem-u̱s ri su̱ m-mo̱mmo̱. ");
INSERT INTO gel_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Campa u-be̱e̱t wu̱ na no̱me̱ u̱r-pe̱s da, na ruutu̱ wa du̱gu̱ o̱r-u̱t wa remu̱ zu̱ wa paku̱s este̱du̱ u̱s-rem.>> ");
INSERT INTO gel_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Se̱ Ru̱-u̱ sur m-no̱m u̱s-rem u̱ Ibrahi ne̱, <<Ne̱ta ró Sera na za u̱t-swu̱r m-fag wa Sera da, dim-u̱r wa do̱'e̱ u̱t-shu̱'u̱t <Saratu.> ");
INSERT INTO gel_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Me̱ wa'-u̱ wu̱n nu-u so̱-o̱, me̱ u̱t-wa wu̱n matu̱ bo̱ ya-du̱ u̱r-campa. Me̱ wa'-u̱ Saratu nu-u so̱-o̱, tu̱msu̱ ne̱t-tu̱ u̱t-dak u-tát to̱ shu̱'u̱t ko̱-u̱t ró, faru̱k-tu̱ do̱'e̱ u̱ rwu̱u̱n du̱gu̱-du̱ ko̱-u̱r Saratu.>> ");
INSERT INTO gel_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ibrahi kaku̱s hi-u̱r wa u-dak. Wa no̱m u̱t-nu̱mu̱s wa o̱ u̱s-dorog jab-u̱ wa, wa zu̱, <<¿U̱t-no̱me̱ ne̱nge̱n-yu̱ u̱s-hak u̱t-shik u̱t-tan 100 nazu wa shu̱'u̱te̱ u̱so u̱ wa'? ¿U̱t-no̱me̱ Saratu u̱t-shik u̱t-nas u̱ o̱p 90 na zu̱ wa maku̱t u̱r-ya?>> ");
INSERT INTO gel_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ibrahi zu̱ u-Ru̱, <<Yage̱ Ismaru u̱ kum nu-u so̱-o̱ u̱du̱ ró!>> ");
INSERT INTO gel_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Se̱di Ru̱-u̱ zu̱, <<E̱, ne̱ta ró Saratu wa matu̱ bo̱ ya-du̱ u̱r-campa. Bo̱ te̱'e̱ wa u̱ wa u̱r-dim Ishaku. Me̱ shu̱su̱ este̱du̱ u̱s-rem su̱ u̱m no̱me̱ u̱ bo̱ ne̱ u̱du̱ ko̱-u̱r wa. Este̱du̱ u̱s-rem se̱ u̱t-shu̱'u̱t m-mo̱mmo̱ u̱du̱ wa u̱ ko̱-u̱r wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Se̱di ko̱n-u̱s ró mo̱ttu̱ Ismaru ne̱, u̱m ho̱k ko̱n-u̱s ró. Me̱ wa'-u̱ wu̱n nu-u so̱-o̱ tu̱msu̱ me̱ ya'u̱ wu̱n yaag u-tát. Me̱ u̱t-wa ya'ag-u̱ wu̱n e̱ no̱m u-tát. Wa u̱t-shu̱'u̱t u̱so u̱t-faru̱k o̱p u̱ u̱t-yu̱r. Me̱ u̱t-ya wu̱n u̱t-ko̱ u-tát wu̱ do̱'e̱ u̱t-shu̱'u̱t dak-u yat-o̱. ");
INSERT INTO gel_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Se̱di este̱du̱ u̱s-rem-u̱ ri u̱ Ishaku ne̱. Hak-yu̱ o̱o̱ne̱, Saratu do̱'e̱ matu̱ bo̱ Ishaku.>> ");
INSERT INTO gel_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Da-u̱ Ru̱-u̱ tase̱ u̱s-rem u̱ Ibrahi ne̱, se̱ wa aru̱k. ");
INSERT INTO gel_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","U̱ gandi ho̱-u̱r de̱, Ibrahi ku̱b wa'-u̱ wa Ismaru, u̱ yaag-u̱ campa-ne̱ be̱e̱t i o̱o̱ge̱ bu-u wa, u̱r-kot i na mate̱ ne̱ bu-u wa, tu̱msu̱ u̱ i wa o̱o̱ne̱-ne̱. Se̱ wa no̱mu̱ e̱ u̱r-pe̱s be̱e̱t, ka Ru̱-u̱ zu̱tte̱ wa no̱m. ");
INSERT INTO gel_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Da-u̱ na no̱mu̱ Ibrahi u̱r-pe̱s, wa o̱o̱g u̱s-hak u̱t-shik u̱t-tan za u-gan 99. ");
INSERT INTO gel_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Da-u o̱ wa'-u̱ wa Ismaru o̱ u̱s-hak u̱s-o̱p u̱s-tu̱t da-u̱ na no̱mu̱ wa u̱r-pe̱s 13. ");
INSERT INTO gel_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","U̱ gandi ho̱-du̱ u̱r-ganu̱ de̱, na no̱mu̱ Ibrahi ne̱ e̱ Ismaru u̱r-pe̱s. ");
INSERT INTO gel_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Campa-ne̱ be̱e̱t i o̱o̱ge̱ me̱ bu-u Ibrahi, u̱ i na o̱o̱ne̱ ne̱ u̱ shik du̱gu̱ do̱, na no̱mu̱ e̱ u̱r-pe̱s u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Da-u̱ Ibrahi o̱o̱ge̱ u̱ shu̱'u̱t u̱ is-yu̱ cwadu̱ rimpa-u̱r wa u̱ da-u̱ ho̱-yu̱ du̱nge̱ sok, Yawe haan u̱du̱ Ibrahi u̱ dapu̱s se̱ke̱n te-u̱s yat-se̱ su̱ O̱k su̱ Mamre. ");
INSERT INTO gel_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Se̱ Ibrahi jaku̱s is u-ru̱ wa hyen ne̱t-ne̱ tu̱t u̱ ees u̱ dapu̱s wa. Da-u̱ wa hyane̱ u̱n, se̱ wa ku̱su̱m m-so̱m du̱gu̱ is-yu̱ rimpa-u̱r wa m-ha u̱du̱ u̱n. Wa he̱ u̱t-kwu̱ku̱t u-dak u̱ yadu̱ m-ze̱g. ");
INSERT INTO gel_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ibrahi zu̱, <<U̱so-u̱ u-bu ri, a u̱m kume̱ hyu̱-m pusmo̱ u̱du̱ ró, a-bo̱ aru̱k bu-u ri da. ");
INSERT INTO gel_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Yagu̱n na haatu̱n no̱ m-bu̱, u̱ no̱ jaas na-u̱s no̱, u̱ no̱ hure̱ u̱ kug-du̱ te-u inya. ");
INSERT INTO gel_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Yage̱ u̱m haatu̱n no̱ no̱m u̱t-re̱ u̱ no̱ re̱, ko̱ no̱ kumu̱ be̱b-du̱ u̱r-no̱k. Bashu̱te̱ no̱ haagu̱n u̱ bu-u̱ to̱k-u̱ no̱, yagu̱n u̱m no̱m iya.>> U̱n zu̱, <<No̱nge̱, no̱m u̱ka cittu̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ibrahi aru̱k m-mu̱ m-so̱m u̱ rimpa-u̱r wa. Wa zu̱ Saratu, <<No̱m m-ho̱r, bo̱ kab ko̱k-tu̱ m-hyu̱ u̱t-tu̱t, bo̱ kwu̱u̱t to̱, bo̱ no̱m u̱t-kak.>> ");
INSERT INTO gel_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Se̱ Ibrahi do̱'e̱ u̱du̱ ban-du̱ bisa-u̱t wa, wa du̱g gob-du̱ u-na du̱ o̱ so̱-de̱ wa yasu̱ to̱k-u̱ wa, se̱ to̱k-u̱ wa do̱'e̱ wa ho̱ tu̱msu̱ wa mang ya m-ho̱r m-ho̱r. ");
INSERT INTO gel_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Da-u̱ na tase̱ no̱m-du̱ no̱m u̱t-re̱, Ibrahi ku̱b no̱mtu̱ m-be̱ngu m-me̱ ne̱ u̱ ap-mu̱ na mange̱ mo̱ ne̱, wa hu̱u̱tu̱ hamu̱t-u̱t wa. Da-u̱ u̱n o̱ te̱k-u̱ re̱-du̱ no̱m u̱t-re̱, Ibrahi ees u̱ kit-u̱ u̱n u̱ dapu̱s yaku̱n te-ya. ");
INSERT INTO gel_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Da-u̱ u̱n tase̱ re̱-du̱ no̱m u̱t-re̱, u̱n shit wa, <<¿Ne̱ta ró Saratu yu̱?>> Wa zu̱ u̱n, <<Wa o̱ me̱n-tu̱ u̱r-rimpa.>> ");
INSERT INTO gel_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Wa-gan u̱ te̱k-u̱ ne̱t-u̱t to̱ wa zu̱, <<Hak-yu̱ o̱ne̱ badane̱, u̱m o̱ u̱ mu̱u̱n u̱du̱ ró, Saratu ne̱ta ró wa u̱t-kab u̱r-ya.>> Saratu o̱ u̱ e̱rru̱ wu̱n u̱ u̱r-rimpa. ");
INSERT INTO gel_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","U̱ da-u o̱ Saratu ne̱ e̱ Ibrahi e̱ wu̱u̱mte̱, Saratu yakke̱ hyan-du̱ u-pyaat. ");
INSERT INTO gel_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Saratu no̱m u̱t-nu̱mu̱s u̱ war-wa u̱zu̱, <<U̱r-wu̱ ba me̱ ne̱, tu̱msu̱ u̱so u-bu ri wa wu̱mte̱ ko̱wa. ¿U̱m zamtu̱n m-ho̱g zwarru̱ m-roog u̱ campa-ne̱ u̱m do̱te̱ u̱r-mat da?>> ");
INSERT INTO gel_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Se̱ Yawe zu̱ Ibrahi, <<¿Yan o̱ wa'e̱ Saratu u̱t-nu̱mu̱s? ¿Remu̱ yan-o̱ wa zu̱tte̱, <U̱r-mang ba me̱ ne̱ u̱t-kab u̱r-ya?> ");
INSERT INTO gel_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Oko̱n o̱ro u̱ ze̱ge̱ be̱b-u̱r Yawe? Me̱ u̱t-mu̱u̱n m-moon u̱ go̱-du̱ da-u uno̱, Saratu u̱t-kab u̱r-ya du̱ u̱r-campa.>> ");
INSERT INTO gel_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saratu hog u-gye̱r, wa no̱m m-se mu̱ no̱mu̱ wa ware̱. Wa zu̱, <<U̱m nu̱mu̱ste̱ da.>> Se̱di Yawe zu̱ wu̱n, <<Bo̱ no̱ng u̱t-nu̱mu̱s.>> ");
INSERT INTO gel_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Da-u̱ ne̱t-ne̱ tu̱t-u̱ e̱ yu̱ne̱ u̱r-aru̱k, Ibrahi shu̱'u̱ u̱n. Da-u̱ u̱n o̱ te̱k-u̱ u̱r-no̱k u̱ fu̱n-u u̱n, u̱n teen de̱ku̱n be-de̱. E̱ gwatu̱n u-dak u-fu̱g, e̱ hyen bo̱-u̱ So̱do̱m. ");
INSERT INTO gel_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Se̱ Yawe zu̱ hi-u̱r wa, <<No̱ng u̱r-zwar u̱zu̱ u̱m yase̱ Ibrahi no̱m-u̱ u̱m zo̱nge̱ u̱t-no̱m da. ");
INSERT INTO gel_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ko̱-u̱r Ibrahi u̱t-shu̱'u̱t dak-u yat-o̱ tu̱msu̱ u̱r-be̱b ne̱ so̱k, tu̱msu̱ dak-tu̱ u-dak u-be̱e̱t u̱t-kwu̱m nu-u so̱-o̱ du̱gu̱-du̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","U̱m dak Ibrahi remu̱ zu̱ wa wartu̱ ya'ag-u̱ wa u̱ a bu-u wa ne̱ i do̱'e̱ u̱ haan u̱ dim-u̱ wa e̱ ship fu̱n-u̱ Yawe, u̱ remu̱ no̱m-du̱ no̱m-tu̱ o̱ tu̱ so̱-to̱ u̱r-zwar ne̱. U̱ da-u o̱ u̱m do̱'e̱ no̱mu̱ Ibrahi no̱m-u̱ u̱m nomte̱ este̱du̱ u̱s-rem.>> ");
INSERT INTO gel_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Se̱ Yawe waru̱ Ibrahi, <<U̱m ho̱k u̱s-rem u-tát su̱ nom-u̱t yo̱-to̱ u̱ mo̱ttu̱ So̱do̱m u̱ Gomora ne̱, remu̱ zu̱ ba'as-u̱t e̱ no̱ng u-tát. ");
INSERT INTO gel_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","U̱m do̱'e̱ u̱t-cu̱zu̱n u̱m hyan ko̱ u̱zu̱ ko̱ yu̱r u̱n no̱ng u̱ yo̱-de̱ u̱ka u̱m ho̱kte̱ re̱, u̱m u̱t-sa u̱m nap.>> ");
INSERT INTO gel_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Se̱ ne̱t-u̱t to̱ aru̱k du̱gu̱ ku̱n m-ha So̱do̱m, se̱di Yawe kus u̱ ees u̱-shu̱ Ibrahi. ");
INSERT INTO gel_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ibrahi hikne̱ u̱ kit-u̱ wu̱n. Wa zu̱, <<¿Bo̱ ho̱rru̱sse̱ a-jab-u̱s so̱-se̱ ne̱ u̱ a-za-jab-u̱s yo̱-se̱ ne̱? ");
INSERT INTO gel_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","A-na kume̱ ne̱t-ne̱ a-jab-u̱s so̱-se̱ ne̱ u̱t-shik u̱t-yu̱r u̱ o̱p 50 u-bo̱, ¿bo̱ ho̱ru̱sse̱ u̱n be̱e̱t bo̱ za yage̱ e̱ u̱ remu̱ ne̱t-ne̱ u̱t-shik u̱t-yu̱r u̱ o̱p a-jab-u̱s so̱-se̱? ");
INSERT INTO gel_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","U̱m nu̱pu̱ste̱ bo̱ zaar u̱ no̱m-du̱ go̱ no̱m-u o̱ da, bo̱ ho̱ru̱sse̱ a-jab-u̱s so̱-se̱ ne̱ u̱r-kot u̱ i yo̱-ye̱ ne̱. ¿Remu̱ yan-o̱ bo̱ do̱te̱ u̱ ho̱ru̱sse̱ i yo̱-ye̱ u̱s-gan u̱ i so̱-ye̱ ne̱? Za u-sakna bo̱ zaar u̱ no̱m-du̱ go̱-o̱ no̱m-o̱ iya da. Bo̱ de̱ no̱mu̱ u-dak u-be̱e̱t kwu̱p-du̱ u̱s-rem, tu̱msu̱ bo̱ no̱mu̱ no̱m-u̱ o̱o̱ge̱ ho̱n-ho̱n.>> ");
INSERT INTO gel_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yawe shu̱s wa zu̱, <<A mu̱ne̱ u̱zu̱ u̱m kwu̱mu̱g ne̱t-ne̱ u̱t-shik u̱t-yu̱r u̱ o̱p u̱ bo̱-u̱ So̱do̱m a-jab-u̱s so̱-se̱ ne̱, me̱ yage̱ bo̱-u o̱ u-be̱e̱t u̱ remu̱ a-jab-u̱s so̱-se̱ ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ibrahi sur m-shas wa zu̱, <<Remu̱ u̱zu̱ u̱m ke̱rge̱ no̱m-du̱ u̱s-rem za u-gye̱r u̱du̱ U̱so-u̱ u-bu ri, ko̱ u̱zu̱ a waku̱n wa u̱m o̱o̱ge̱ da se̱di m-huug m-cwa ne̱, ");
INSERT INTO gel_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","a mu̱ne̱ u̱zu̱ na kwu̱mu̱g ne̱t-ne̱ u̱t-shik u̱t-yu̱r u̱ tan 45 a-jab-u̱s so̱-se̱ ne̱, ¿bo̱ u̱t-ho̱ u-bo̱ u-be̱e̱t u̱ remu̱ ko̱b-du̱ tan?>> Yawe zu̱, <<U̱m za ho̱ru̱sse̱ o̱ da a mu̱ne̱ zu̱ u̱m kwu̱mu̱g ne̱t ne̱ u̱t-shik u̱t-yu̱r u̱ tan 45 ne̱t-tu̱ o̱ u̱ku̱n.>> ");
INSERT INTO gel_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ibrahi sur m-zu̱, <<¿M-ha iya ne̱ bo̱ ho̱ru̱sse̱ bo-u̱ So̱do̱m, a mu̱ne̱ u̱zu̱ na kwu̱mu̱g ne̱t-ne̱ a-jab-u̱s so̱-se̱ ne̱ u̱t-shik u̱t-yu̱r 40?>> Yawe zu̱, <<U̱m za ho̱ru̱sse̱ u̱n da u̱ remu̱ ne̱t-ne̱ jab-u̱s so̱-se̱ ne̱ u̱t-shik yu̱r 40.>> ");
INSERT INTO gel_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ibrahi zu̱, <<U̱so-u̱ u-bu ri, a jab-u̱ ró na u̱ re̱mu ri da, yage̱ u̱m no̱m u̱s-rem. ¿Bo̱ ho̱ru̱sse̱ bo̱-u̱ So̱do̱m, a mu̱ne̱ u̱zu̱ shik-de̱ na kume̱ u̱ o̱p 30 a-jab-u̱s so̱-se̱ ne̱?>> Se̱ wa zu̱ wu̱n, <<U̱m za ho̱-du̱ u̱n da, a mu̱ne̱ zu̱ u̱m kwu̱mu̱g ne̱t-ne̱ u̱r-shik u̱ o̱p 30 u̱ku̱n a-jab-u̱s so̱-se̱ ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ibrahi zu̱, <<U̱ da-o̱ remu̱ zu̱ u̱m kwu̱mu̱g be̱b-du̱ u̱s-rem u̱ U̱so-u̱ u-bu ri ne̱, a mu̱ne̱ u̱zu̱ shik-de̱ 20 na kume̱ warre̱ u̱ku̱n ne̱.>> Wa zu̱, <<U̱ remu̱ kwaz-u̱r re̱ 20, u̱m zaar u̱ ho̱ru̱ssu̱ bo̱-u o̱ da.>> ");
INSERT INTO gel_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ibrahi zu̱, <<U̱so-u̱ u-bu ri, a jab-u̱ ró na da, yage̱ u̱m sur m-no̱m u̱s-rem u-so̱ u-gan. ¿A mu̱ne̱ u̱zu̱ ne̱t-ne̱ o̱p e̱ na kume̱ a-jab-u̱s so̱-se̱ ne̱?>> Yawe zu̱ wu̱n, <<A u̱m kume̱ ne̱t-ne̱ o̱p a-jab-u̱s so̱-se̱ ne̱, u̱m zaar u̱ ho̱ru̱sse̱ bo̱-u o̱ da.>> ");
INSERT INTO gel_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Da-u̱ Yawe tase̱ u̱s-rem u̱ Ibrahi ne̱, wa aru̱k wa, se̱ Ibrahi aru̱k m-mu̱ u̱ rimpa-u̱r wa. ");
INSERT INTO gel_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","A-to̱m u-Ru̱ ne̱ yu̱r e̱ haan u̱ So̱do̱m m-rim, tu̱msu̱ Ro̱t o̱ u̱ shu̱'u̱t u̱ is-yu̱ cwadu̱ u-bo̱. Da-u̱ wa hyane̱ u̱n, wa yu̱ne, wa bit u̱n, wa kwu̱ku̱t u̱t-jwu̱n u-dak wa kaku̱s shu̱-u wa u-dak. ");
INSERT INTO gel_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Wa zu̱ u̱n, <<Haanu̱n u̱ bu-u̱ to̱k-u̱ no̱, u̱ no̱ jaas naas no̱ tu̱msu̱ no̱ roog u̱ ane̱ a is-u̱ gase̱ u̱r-wu̱n te̱p te̱p se̱ no̱ aru̱k m-mu̱.>> Se̱di u̱n zu̱ wa, <<O'o, yage̱ it roog u̱ ane̱ kat-du̱ u-bo̱.>> ");
INSERT INTO gel_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Se̱ Ro̱t e̱kse̱ u̱n, da tase̱ u̱n aru̱k m-mu̱ u̱nu̱ e̱ ne̱ u̱ bu-u wa. Ro̱t zo̱nge̱ u̱n mo̱ro̱g-du̱ re̱-du̱ no̱m u̱t-re̱, wa no̱mu̱ u̱n u̱r-be̱re̱di du̱ za m-yis, se̱ u̱n re. ");
INSERT INTO gel_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Kandi u̱n toot m-roog, campa-ne̱ i o̱o̱ge̱ bo̱-u̱ So̱do̱m u-be̱e̱t, u̱ yaag-u̱ be̱b-ne̱ u̱t-ne̱nge̱n ne̱ gu̱nu̱s bu-u̱ u̱n o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Se̱ u̱n fog Ro̱t, u̱n zu̱, <<¿Ne̱t-u̱t to̱ yu̱ tu̱ haane̱ u̱du̱ ró m-gyu̱p? Rwu̱tu̱n u̱n u̱ ane̱ u̱du̱ it, it roog u̱ e̱ ne̱!>> ");
INSERT INTO gel_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Se̱ Ro̱t aru̱k m-rwu̱ u̱-do̱ wa tage̱ u-is u̱ dim-u̱ wa, wa do̱'e̱ u̱nu̱ e̱ ne̱ no̱m u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Wa zu̱ u̱n, <<Gagu̱n jab, o̱r-u̱t ri, a no̱ jaru̱n no̱ no̱m go̱ no̱m-u yo̱-o̱ uno̱ da. ");
INSERT INTO gel_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Gwatu̱n, u̱m o̱ yaat u̱t-gwu̱p-ne̱ yu̱r i tame̱ nap-du̱ campa da. Yagu̱n u̱m rwu̱tu̱n no̱ e̱ u̱du̱ no̱, u̱ no̱ nom no̱m-u̱ citu̱ no̱ u̱ e̱ ne̱. Se̱di a no̱ no̱mu̱ ne̱t-u̱t tun-to̱ oko̱n da, ham-tu̱ u̱t-ri to̱ u̱ bu-u ri.>> ");
INSERT INTO gel_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Se̱di u̱n zu̱ wa, <<Ya it u̱r-be!>> Tu̱msu̱ u̱n zu̱ hi-u̱r u̱n, <<Unwa ne̱t wa ham-u̱t wa, se̱di wa o̱ u̱ssa wa shu̱'u̱t wa kwu̱pu̱ in u̱s-rem. U̱ da-o̱ it u̱ no̱mu̱ bo̱ m-ze̱g no̱mu̱ it o̱o̱ge̱ u̱ssa u̱ u̱n ne̱.>> Se̱ u̱n hu̱ e̱kse̱ Ro̱t so̱k. U̱n o̱ u̱t-sa u̱n vu̱ku̱s is-yu̱ u-bu. ");
INSERT INTO gel_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Se̱di hamu̱t-u̱t to̱ nabu̱n u-kom e̱ nu̱k Ro̱t m-cwa u-bu. Se̱ e̱ tage̱ is-yu̱ u-bu. ");
INSERT INTO gel_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Se̱ u̱n muut ne̱t-u̱t to̱ po̱-ne̱ be̱e̱t, u̱ ya'ag-u̱ campa-ne̱, u̱t-ne̱nge̱n ne̱, i o̱o̱ge̱ u̱ ees u̱ is-yu̱ u-bu, taas e̱ hyan is-yu̱ cwadu̱ u-bu da. ");
INSERT INTO gel_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Se̱ ne̱t-ne̱ yu̱r-u̱ e̱ zu̱ Ro̱t, <<¿Ko̱ bo̱ o̱tte̱ waku̱n u̱ ane̱, ko̱ maan-u̱t ró, ya'ag-u̱ campa-ne̱ ko̱ yaat u̱t-gwu̱p, ko̱ waku̱n u̱-me̱ bo̱-u uno̱ wu̱ o̱o̱ge̱ wu̱ ró? Rwu̱tu̱n e̱ du̱gu̱ ane̱, ");
INSERT INTO gel_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","remu̱ u̱zu̱ it do̱'e̱ u̱ ho̱ru̱ssu̱ bo̱-u uno̱ u-be̱e̱t. Yawe ho̱k u̱zu̱ no̱m-u̱t yo̱-to̱ ne̱t-u̱t tunto̱ no̱ng u-tát o̱ wa'e̱ wa to̱mto̱n it ho̱ru̱sse̱ bo̱-u uno̱.>> ");
INSERT INTO gel_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Se̱ Ro̱t aru̱k m-rwu̱ wa do̱'e̱ wa no̱m u̱s-rem u̱ maan-u̱t wa ne̱, e̱ sa'e̱ gu̱tu̱ ya-u̱t-gwu̱p-u̱ wa. Wa zu̱ e̱, <<Zo̱ngu̱n no̱ aru̱k m-rwu̱ du̱gu̱ ane̱, remu̱ zu̱ Yawe o̱ mo̱ttu̱ ho̱ru̱ssu̱ bo̱-u uno̱!>> Se̱di maan-u̱t wa ku̱b u̱zu̱ ho̱ro̱ wa o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Da-u̱ is u̱t-sa u̱t-gas, se̱ a-to̱m u-Ru̱ ne̱ waru̱ Ro̱t u̱zu̱, <<No̱m m-ho̱r, bo̱ kab ne̱ta ró u̱ ya-u̱t-gwu̱p-u̱ ró ne̱ yu̱r i o̱o̱ge̱ ane̱, taas na haan na ho̱ru̱ssu̱ bo̱-u uno̱ u̱r-kot u̱ no̱ ne̱ remu̱ ba'as-u̱t u̱n da.>> ");
INSERT INTO gel_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Da-u̱ Ro̱t gu̱gme̱ no̱m-du̱ m-ho̱r, se̱ ne̱t-u̱t to̱ shipu̱s wa u-kom, u̱ ne̱ta wa ne̱, u̱ yaat u̱t-gwu̱pu̱ wa ne̱ yu̱r, e̱ ruut u̱n m-yar du̱gu̱ bo̱-u o̱, remu̱ zu̱ Yawe o̱ ho̱g-du̱ o̱n-u̱r u̱n. ");
INSERT INTO gel_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Da-u̱ na ruute̱ u̱n m-yar du̱gu̱ bo̱-u o̱, wa-to̱m u-Ru̱ wa-gan zu̱ u̱n, <<Somtu̱n fat-u̱t no̱! A no̱ gwat u-dim da ko̱ no̱ ees u̱ be̱du̱ o̱ nu̱ru̱gse̱ da. Du̱su̱n u̱ do̱m-u̱ u̱r-ro̱r, taas na ho̱ru̱ssu̱ no̱ da.>> ");
INSERT INTO gel_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Se̱di Ro̱t zu̱ u̱n, <<O'o, U̱so-tu̱ u-bu ri. ");
INSERT INTO gel_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","U̱m kwu̱mu̱g hyu̱-m pusmo̱ du̱gu̱-du̱ no̱, no̱ gu fat-u̱r ri u̱ no̱mu so̱-o̱ u̱ no̱ no̱mu̱ me̱. U̱m zaar u̱ kerru̱ te-du̱ do̱m-u̱ u̱r-ro̱r kanda bo̱ ho̱ru̱sse̱ So̱do̱m da. U̱no̱ no̱m-u yo̱-o̱ u̱ masu̱ me̱, tu̱msu̱ me̱ u̱t-mar. ");
INSERT INTO gel_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Gwat, o̱ko̱n bo̱-u re̱k-o̱ o̱ro u̱ kit-u̱ ku̱n. Yage̱ u̱m do̱'e̱ u̱ku̱n, no̱ hyang o̱ re̱k-o̱, u̱ da-u o̱ fat-u̱r ri u̱t-ku̱su̱m.>> ");
INSERT INTO gel_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Wa-to̱m u-Ru̱ shu̱s wa zu̱ wu̱n, <<U̱m ho̱k ko̱n-u̱s ró, u̱m zaar u̱ ho̱-du̱ bo̱-u re̱k-o̱ o̱ da. ");
INSERT INTO gel_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Zo̱nge̱ m-ho̱r-m-ho̱r bo̱ so̱m m-ha u̱ku̱n, u̱m zaar u̱ no̱m-du̱ o̱ko̱n da se̱ bo̱ teeg ku̱n.>> (O̱ wa-e̱ na fog-u̱t bo̱-u o̱ Zo̱war, wata be-u̱r re̱k-de̱). ");
INSERT INTO gel_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Da-u̱ ho̱-du̱ o̱o̱ge̱ u̱ rwu̱u̱n, Ro̱t u̱ bu-u wa ne̱ te u-bo̱ u̱ na foge̱ Zo̱war. ");
INSERT INTO gel_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Se̱ Yawe hu̱ u̱ dasu̱n eng-tu̱ u-ra du̱gu̱ do̱m u-ru̱ u̱ bo̱-tu̱ So̱do̱m u̱ Gomora ne̱. ");
INSERT INTO gel_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Wa ho̱ru̱sse̱te bo̱-u̱t to̱ u̱ ne̱t-tu̱ o̱o̱ge̱ u̱r-yu̱ ne̱ u̱-me̱ to̱, u̱ bo̱-tu̱ o̱ nu̱ru̱gse̱ ne̱ u̱t-be̱e̱t, u̱t-ran ne̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Se̱di ne̱ta Ro̱t bir u-dim da-u̱ wa o̱o̱ge̱ u̱ do̱rru̱ dim-u̱ wa, se̱ wa baru̱m kirru̱ u̱t-ma. ");
INSERT INTO gel_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Da-u̱ is gase̱ u̱r-wu̱n te̱p te̱p, Ibrahi baru̱m m-mu̱ u-dim u̱ be-du̱ wa tamte̱ u̱r-ees u̱-shu̱ Yawe. ");
INSERT INTO gel_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Se̱ wa gwatu̱n u-dak u̱ gas-u̱ So̱do̱m u̱ Gomora ne̱, u̱ be-du̱ o̱ nu̱ru̱gse̱ ne̱ u̱r-be̱e̱t, wa hyu̱n fu̱'u̱t-u yat-o̱ u̱ rwu̱u̱n du̱gu̱ me̱ bo̱-u̱t to̱ sha-mu̱ m-fu̱'u̱t du̱gu̱ ra-u yat-o̱. ");
INSERT INTO gel_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Se̱di Ru̱-u̱ ho̱k ko̱n-u̱s Ibrahi, wa yage̱ Ro̱t u̱r-fat. Wa ruut Ro̱t du̱gu̱ swadu̱ u̱r-ko̱b du̱ he̱e̱ne̱ bo̱-u̱t to̱. ");
INSERT INTO gel_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Da-u̱ tase̱ Ro̱t yage̱ bo̱-u̱ Zo̱war remu̱ zu̱ wa o̱ gye̱r-u̱ ne̱t-tu̱ o̱o̱ge̱ u̱ku̱n. Wa do̱'e̱ wa shu̱'u̱t u̱ do̱m-u̱ u̱r-ro̱r u-so' u̱ ya-u̱t-gwu̱p-u̱ wa ne̱ yu̱r. ");
INSERT INTO gel_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","De̱ku̱n ho̱-de̱ yu̱-wu̱ya zu̱ hu̱no-u wa, <<Campa-ne̱ zamu̱n u̱ gas-u̱ uno̱ da. In zaar u̱ kwu̱m-du̱ campa wu̱ do̱'e̱ ga-du̱ in u̱ka na nomte̱ da. Za m-tumb u̱so in do̱'e̱ no̱m-du̱ u̱r-wu̱' za yaag. ");
INSERT INTO gel_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Haane̱, yage̱ yu̱-u ya' wu̱n ke̱ wu̱n swa, se̱ yu̱-u roog u̱ wu̱n ne̱, ko̱ in u̱ cinu̱ go̱ du̱gu̱-du̱ u̱so-u in.>> ");
INSERT INTO gel_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Da-u̱ gye̱p-mu̱ no̱me̱, u̱n yu̱' wa ke̱ e̱ ho wa, se̱ yu̱-wu̱ya to wa roog u̱ wu̱n ne̱. Wu̱n nak da-u̱ gwu̱p-u̱ wu̱n ru̱te̱ da ko̱ da-u̱ wa yu̱ne̱ da. ");
INSERT INTO gel_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Da-u̱ is gase̱ yu̱-wu̱ya zu̱ hu̱no-u wa, <<Gyu̱p-ne̱, u̱m roogte̱ u̱ u̱so ri ne̱, yage̱ u̱ in sur m-ya wu̱n ke̱ u̱ da-o̱ m-gye̱p. Se̱ bo̱ cwa u̱ no̱ wa ne̱ roog u̱ wu̱n ne̱ ko̱ in u̱ cinu̱ yaag du̱gu̱-du̱ u̱so-u in.>> ");
INSERT INTO gel_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Se̱ u̱n wu̱' u̱so-u u̱n wa swa ke̱ e̱ ho wa u̱ gyu̱p-m mo̱. Se̱ du̱-dim to wa roog u̱ wa ne̱. Wu̱n nak da-u̱ gwu̱p-u̱ wu̱n ru̱te̱ da ko̱ da-u̱ wa yu̱ne̱ da. ");
INSERT INTO gel_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","U̱ remu̱ iyane̱, ya-u̱t-gwu̱p-u̱ Ro̱t be̱e̱t u̱n no̱m me̱n-tu̱ uub du̱gu̱-du̱ u̱so-u u̱n. ");
INSERT INTO gel_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Yu̱-wu̱ya mu̱t ya-du̱ u̱r-campa, wa te̱'e̱ de̱ u̱r-dim Mowab, ya'ag-u̱ Mowab e̱ na fu̱ge̱ da-o̱ Mowab-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Du̱-dim sur m-mat ya-du̱ u̱r-campa, wa te̱'e̱ wa u̱r-dim Amona. Wa na foge̱ ya-du̱ ne̱t-u̱t ri, ya'ag-u̱ Amona e̱ na fu̱ge̱ Amona-ne̱ u̱ haan da-u uno̱. ");
INSERT INTO gel_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ibrahi u̱ ne̱t-u̱t wa ne̱ e̱ yu̱ne̱ u̱n aru̱k, se̱ da-u̱ e̱ te̱ye̱ gas-u̱ do̱g-du̱ Ne̱giv. E̱ do̱'e̱ e̱ shu̱'u̱t u̱ te̱k-u̱ bo̱-tu̱ Kades u̱ Shur ne̱ u-da cashi. Se̱ wa shu̱'u̱t sha-mu̱ ham-u̱t bo̱-u̱ Gerar. ");
INSERT INTO gel_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","U̱ku̱n Ibrahi ware̱ u̱t-ne̱t u̱zu̱ Saratu, <<Hu̱no-u ri wa.>> Se̱ Abime̱re̱k, faru̱k-u̱ Gerar, to̱m na fagu̱n Saratu wa ku̱b wa. ");
INSERT INTO gel_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","M-gyu̱p Ru̱-u̱ haan u̱du̱ Abime̱re̱k u̱ bo' wa zu̱ wa, <<Bo̱ u̱ wu̱ mare̱ ganse̱ u̱ remu̱ ne̱ta wu̱ bo̱ kabne̱, ne̱ta waku̱n wa.>> ");
INSERT INTO gel_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Se̱di Abime̱re̱k haag u̱ kit-u̱ wu̱n da, se̱ wa zu̱, <<U̱so-u̱ u-bu ri, ¿bo̱ ho̱ru̱sse̱te̱ ne̱t-tu̱ za u̱t-ba'as? ");
INSERT INTO gel_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ibrahi wa zu̱ me̱ hu̱no-u wa o̱, tu̱msu̱ Saratu u̱ hi-u̱r wa zu̱u̱g me̱ iya, <O̱ru̱ ri wa.> U̱m to̱ u̱ sa'u wa jab gan, kom-u̱t ri zatte̱ u̱t-ba'as da.>> ");
INSERT INTO gel_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Se̱ Ru̱-u̱ zu̱ wu̱n, <<E̱, u̱m nak u̱zu̱ bo̱ saag wa jab gan. O̱ wa'e̱ u̱m hooste̱ bo̱ no̱m-du̱ u̱t-ba'as u̱du̱ ri, tu̱msu̱ o̱ wa'e̱ u̱m hooste̱ bo̱ tamdu̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","U̱ da-o̱ muute̱ campa-u ya ne̱ta wa, wa no̱mu̱ bo̱ u̱s-to̱o̱g. Wa-warru̱ rem-su̱ u-Ru̱ wa, u̱ da-u o̱ bo̱ u̱t-no̱m u̱r-fat. Se̱di a-bo̱ gu̱gme̱ muutu̱ ne̱ta-u ya u̱du̱ campa wa, bo̱ nap u̱zu̱ bo̱ u̱ ne̱t-tu̱ u-bu-u ró ne̱ u̱t-be̱e̱t no̱ u̱t-mar.>> ");
INSERT INTO gel_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Da-u̱ is gase̱ u̱r-wu̱n te̱ te̱p Abime̱re̱k fog mo̱ro̱g-du̱ to̱k-ne̱ wa be̱e̱t. Da-u o̱ wa waru̱ e̱ no̱mu̱ na no̱me̱, u̱n hog u-gye̱r u̱n be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Se̱ Abime̱re̱k fog Ibrahi wa zu̱, <<¿Yan-o̱ bo̱ no̱mu̱ it inya? ¿Yan ba'as-to̱ u̱m no̱mu̱ bo̱? Bo̱ haatu̱n me̱ tun-to̱ no̱m-u̱t yo̱-to̱ yatto̱ tunto̱ u̱ dak-u ri u̱ ne̱t-u̱t ri ne̱ u̱t-be̱e̱t. Bo̱ no̱ngu̱ me̱ no̱mtu̱ kame̱ da.>> ");
INSERT INTO gel_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abime̱re̱k shit Ibrahi, <<¿Remu̱ yan-o̱ bo̱ nomte̱ go̱-du̱ uno̱ no̱m-o̱?>> ");
INSERT INTO gel_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ibrahi zu̱, <<U̱m no̱mu̱g u̱s-dorog u̱zu̱, <Gye̱r u-Ru̱ zaar u̱du̱ ne̱t-tu̱ dinde̱ be-de̱ da, e̱ keru̱ ho̱-du̱ me̱ e̱ kab ne̱ta ri.> ");
INSERT INTO gel_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","U̱t-nip hu̱no̱ ri wa. U̱so-u it u̱ wa ne̱ o̱ u-gan, se̱di ko̱wan o̱ u̱ ino-u wa, se̱di u̱m gu̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Da-u̱ Ru̱-u̱ fagu̱ me̱ u̱m yage̱ bu-u̱ u̱so-u ri, u̱m zu̱ Saratu, <Ka bo̱ de̱ttte̱ u̱ ko̱su̱ me̱ u̱t-cwanu̱ ya, be-du̱ yu̱-u hu̱u̱te̱ u̱r-be̱e̱t, bo̱ zu̱ me̱ hu̱no-u ró wa u̱m o̱o̱ge̱.> >> ");
INSERT INTO gel_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Se̱ Abime̱re̱k ku̱b e̱ke̱n u̱ te̱k-u̱ ban-tu̱ ca wa u̱ gwaar ne̱ u̱ na ne̱, tu̱msu̱ u̱ to̱k-ne̱ ne̱ta-ne̱ u̱ campa-ne̱, wa yasu̱ Ibrahi e̱, tu̱msu̱ wa mu̱tu̱n Saratu ne̱ta wa. ");
INSERT INTO gel_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abime̱re̱k zu̱ Ibrahi, <<Dak-u ri ya u̱ku̱n u̱du̱ ró, shu̱'u̱te̱ u̱ be-du̱ citu̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Se̱ Abime̱re̱k zu̱ Saratu, <<U̱m yaag campa ró kwam-u̱t pus-to̱ tu̱ shik u̱t-ko̱k u̱t-o̱p 1,000, remu̱ zu̱ u̱ shu̱'u̱t u̱s-nap u̱ ne̱t-tu̱ bo̱ o̱o̱ge̱ u̱ to̱ ne̱ u̱t-be̱e̱t u̱zu̱ bo̱ no̱mu̱g o̱ko̱n u̱ za so̱-o̱ da.>> ");
INSERT INTO gel_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ibrahi no̱m u̱s-ko̱n u̱du̱ u-Ru̱, Ru̱-u̱ yu̱ Abime̱re̱k m-yar, u̱ ne̱t-u̱t wa ne̱ u̱ to̱k-u̱ wa ne̱, ne̱ta-ne̱, ko̱ e̱ kumu̱ mat-du̱ yaag tu̱msu̱, ");
INSERT INTO gel_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","remu̱ zu̱ Yawe wa'ag ne̱ta-ne̱ be̱e̱t i o̱o̱ge̱ u̱ bu-u Abime̱re̱k, u̱zu̱ e̱ za u̱r-mat da remu̱ zu̱ Abime̱re̱k kab-u̱g ne̱ta Ibrahi Saratu. ");
INSERT INTO gel_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yawe este̱ u̱s-rem tu̱msu̱ wa no̱mu̱ Saratu no̱mu̱ wa zu̱ wa u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","No̱ng ho̱n-ho̱n u̱ da-u̱ Ru̱-u̱ waru̱ Ibrahi, Saratu ku̱b me̱n-tu̱ ub, se̱ wa matu̱ Ibrahi ya-du̱ u̱r-campa u̱ da-u̱ wu̱-u̱r wa. ");
INSERT INTO gel_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ibrahi te̱'e̱ ya-du̱ u̱r-campa wa u̱r-dim Ishaku. ");
INSERT INTO gel_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Da-u̱ Ishaku no̱me̱ m-roog u̱t-eer, Ibrahi no̱mu̱ wa u̱r-pe̱s u̱ka Ru̱-u̱ zu̱tte̱ wa no̱m. ");
INSERT INTO gel_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ibrahi no̱ng u̱s-hak u̱t-shik u̱t-tan 100 da-u̱ wa mate̱ Ishaku. ");
INSERT INTO gel_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saratu zu̱, <<Ru̱-u̱ wa'ag me̱ u̱t-nu̱mu̱s; ko̱wana ho̱ge̱ wa se̱gu̱ me̱ no̱m-du̱ u̱t-nu̱mu̱s. ");
INSERT INTO gel_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","¿Wana tame̱ u̱t-zu̱ Ibrahi u̱zu̱ Saratu u̱ wu̱rgu̱ wa'? M-ha iyane̱ u̱m mak-tu̱ Ibrahi ya-du̱ u̱r-campa u̱ da-u̱ wu̱-u̱r wa.>> ");
INSERT INTO gel_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Da-u̱ Ishaku rogme̱ na o̱ u̱ mo̱ttu̱ kasdu̱ wa u̱r-de̱, Ibrahi bu̱n mo̱ro̱g-u̱r yat-de̱ du̱ u̱r-so̱. ");
INSERT INTO gel_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","De̱ku̱n ho̱-de̱, Ismaru wa'-u̱ Hajara wa dak-u̱ Masar o̱ ho̱r e̱ Ishaku, Saratu hyen Ismaru u̱ no̱mu̱ Ishaku nu̱mu̱s-tu̱ u̱s-ju̱ru̱m. ");
INSERT INTO gel_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Se̱ Saratu zu̱ Ibrahi, <<Buz to̱k-u̱ ne̱ta unwa e̱ wa'-u̱ wa ne̱, wa za re̱-du̱ no̱m-u̱ u̱t-kom ri u̱r-kot u̱ Ishaku wa'-u̱ ri ne̱ da!>> ");
INSERT INTO gel_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Rem-u̱s se̱ tu̱m jab-u̱ Ibrahi sok remu̱ zu̱ Ismaru wa'-u̱ rò wa. ");
INSERT INTO gel_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Se̱ Ru̱-u̱ zu̱ Ibrahi, <<A jab-u̱ ró na u̱ remu̱ bu̱z-du̱ to̱k-u̱ ne̱ta unwa Hajara e̱ wa'-u̱ wa ne̱ da. No̱m no̱m-u̱ Saratu zu̱ bo̱ no̱m, remu̱ zu̱ du̱gu̱-du̱ Ishaku de̱ na do̱te̱ fag-du̱ ko̱-u̱r ró. ");
INSERT INTO gel_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Se̱di me̱ u̱t-no̱m dak-u yat-o̱ du̱gu̱-du̱ wa'-u̱ to̱k-u̱ ne̱ta ró wa shu̱'u̱t u-dak, remu̱ zu̱ wa'-u̱ ró wa o̱o̱ge̱ ko̱wa.>> ");
INSERT INTO gel_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Se̱ Ibrahi yu̱ne̱ u̱r-wu̱n te̱p te̱p, wa ku̱b no̱m u̱t-re̱ u̱ kub-du̱ m-bu̱ ne̱, wa yasu̱ Hajara. Ibrahi su̱bgu̱ Hajara to̱ u̱t-kap, wa yasu̱ Hajara wa zu̱ wa aru̱k u̱ wa'-u̱ e̱ ne̱. Se̱ Hajara aru̱k, wa hu̱ u̱t-riig u̱r-do̱g du̱ o̱ dapu̱s bo̱-u̱ Be̱rshe̱ba. ");
INSERT INTO gel_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Da-u̱ bu̱-mu̱ u̱r-kub tu̱se̱, se̱ Hajara ru̱st u̱r-ya u̱ kug-du̱ m-yara u̱ yaku̱n te-ya u̱r-do̱g. ");
INSERT INTO gel_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Se̱ wa aru̱k, wa do̱'e̱ m-ra wa shu̱'u̱t u̱ka ra-mu̱ ta-u̱ u-ta, wa dorog u̱ jab-u̱ wa u̱zu̱, <<U̱m za u̱ssa u̱m hyan mar-mu̱ wa'-u̱ ri da.>> Se̱ wa hu̱ u̱s-kan. ");
INSERT INTO gel_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Se̱di da-u̱ Ru̱-u̱ ho̱ge̱ kan-su̱ u̱r-ya, wa-to̱m u-Ru̱ fog Hajara. Wa zu̱, <<Hajara, ¿yan-o̱ no̱me̱? A-bo̱ ho̱g u-gye̱r da, Ru̱-u̱ ho̱k kan-su̱ u̱r-ya u̱ be-du̱ de̱ o̱tte̱ m-ru̱t. ");
INSERT INTO gel_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","De̱'e̱, bo̱ yu̱nu̱s wa'-u̱ wa, u̱ bo̱ par wa, remu̱ zu̱ du̱gu̱ ko̱-u̱r wa de̱, u̱m do̱te̱ kadu̱ dak-u yat-o̱.>> ");
INSERT INTO gel_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Se̱ Ru̱-u̱ upus is-u̱ Hajara, wa hyen du-du̱ m-bu̱. Wa do̱'e̱ wa shu̱u̱s kub-du̱ m-bu̱ wa yu̱ ya-u̱r wa, wa so. ");
INSERT INTO gel_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ru̱-u̱ o̱ u̱r-kot u̱ wa'-u̱ wa ne̱, wa nen. Wa nom u̱r-yu̱ u̱-me u̱r-do̱g wa shu̱'u̱t wa nap-mu̱ ta-u̱ u-ta. ");
INSERT INTO gel_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Da-u̱ wa o̱o̱ge̱ shu̱'u̱t do̱g-du̱ Paran, ino̱-u rò kwu̱mnu̱ wu̱n ne̱ta du̱gu̱ dak-u̱ Masar. ");
INSERT INTO gel_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","U̱ te̱k-u̱ da-u o̱, Abime̱re̱k e̱ Piko̱r yu̱-Yat-ya karma-ne̱ e̱ do̱'e̱ u̱du̱ Ibrahi. E̱ zu̱ wa, <<Ru̱-u̱ o̱ u̱r-kot u̱ bo̱ ne̱ u̱ te̱k-u̱ no̱m-u̱ bo̱ o̱o̱ge̱ u̱t-no̱m u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Remu̱ iyane̱, to̱n-de̱ u-Ru̱ ne̱ u̱zu̱ bo̱ zaru̱ re̱ ra-u ri da, u̱ ya'ag-u̱ ri ne̱, ko̱ a ko̱-u̱r ri ne̱. No̱mu̱ me̱ no̱m-u̱t so̱-to̱, u̱ dak-u ri ne̱ u̱ bo̱ o̱tte̱ shu̱'u̱t mu̱ u̱r-hamu̱t u̱ka u̱m nomte̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ibrahi zu̱, <<U̱m to̱ndte̱.>> ");
INSERT INTO gel_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ibrahi haatu̱n Abime̱re̱k u̱s-kan u̱ mo̱ttu̱ du-du̱ m-bu̱ du̱ to̱k-ne̱ Abime̱re̱k ru̱mse̱ u̱r-be̱b du̱gu̱-du̱ to̱k-ne̱ Ibrahi. ");
INSERT INTO gel_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abime̱re̱k zu̱, <<U̱m nak wu̱ no̱me̱ uno̱ no̱m-o̱ da. Bo̱ wargu̱ me̱ da, taku̱n-du̱ m-ho̱g-u̱ ri ya u̱ ya-o̱.>> ");
INSERT INTO gel_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Se̱ Ibrahi yu̱ Abime̱re̱k ban-du̱ ca u̱ gwaar ne̱ u̱ na ne̱, se̱ e̱ yu̱r e̱ no̱m este̱du̱ u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ibrahi du̱gu̱r ya'ag-u̱ ca ta'e̱r du̱gu̱ me̱ ban-du̱ ca wa. ");
INSERT INTO gel_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abime̱re̱k zu̱ Ibrahi, <<¿Rem-u yan-o̱ bo̱ du̱gu̱rte̱ ine̱ yaag-u̱ ca-ye̱ u̱ war-e̱?>> ");
INSERT INTO gel_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Wa zu̱, <<Kab ca e̱, e̱ shu̱'u̱t u̱s-nap u̱zu̱ me̱ wa kawe̱ du-u̱r re̱.>> ");
INSERT INTO gel_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Remu̱ iya na fu̱g dim-du̱ be-u̱r re̱ Be̱rshe̱ba, remu̱ zu̱ ku̱na e̱ nomte̱ u̱s-to̱nd. ");
INSERT INTO gel_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Da-u̱ e̱ taase̱ no̱m-du̱ u̱s-to̱nd u̱ be-du̱ na zu̱ye̱ <<Du-du̱ u̱s-to̱nd,>> se̱ Abime̱re̱k e̱ Piko̱r yu̱-Yat-ya karma-ne̱, e̱ yu̱ne̱ e̱ aru̱k m-mu̱ u̱ dak-u̱ Firistiya-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ibrahi ser u-te go̱-du̱ te-yu̱ m-yara u̱ Be̱rshe̱ba ku̱na wa fu̱kte̱ u̱ te̱k-u̱ dim-u̱r Yawe, u-Ru̱ u̱ za u̱r-ma. ");
INSERT INTO gel_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Se̱ Ibrahi shu̱'u̱t wa dak-u̱ Firistiya-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Da-u̱ na no̱me̱ u̱s-hak u-tát, se̱ Ru̱-u̱ re̱g ya-du̱ jab-u̱ Ibrahi, se̱ Ru̱-u̱ fu̱g wu̱n wa zu̱, <<Ibrahi!>> Ibrahi zu̱, <<Me̱ ya.>> ");
INSERT INTO gel_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Se̱ Ru̱-u̱ zu̱, <<Kab wa'-u̱ ró, ya-du̱ u̱r-gan u̱ ró Ishaku, wu̱ bo̱ zege̱ u̱t-cwan, bo̱ aru̱k m-ha u̱ dak-u̱ na zu̱ye̱ Moriya. Bo̱ yasu̱ wu̱n u̱ku̱n sha-mu̱ ya-du̱ to̱o̱g u̱ do̱m-u̱ de̱ku̱n ro̱r-de̱ du̱ u̱m do̱'e̱ ko̱su̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ibrahi yu̱ne̱ u̱r-wu̱n te̱p te̱p. Wa zo̱ng janka-u wa, wa zu̱ to̱k-ne̱ yu̱r u̱ do̱r wa, u̱ wa'-u̱ wa ne̱ Ishaku. Da-u̱ wa bu̱kre̱ u̱t-te tu̱ no̱m-du̱ to̱o̱g, se̱ e̱ he̱e̱se̱ m-ha u̱ be-du̱ Ru̱-u̱ waru̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Da-u̱ e̱ no̱me̱ m-roog u̱t-tu̱t, Ibrahi jaku̱s is wa hyan be-u̱r re̱ du̱gu̱ m-ra. ");
INSERT INTO gel_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ibrahi zu̱ to̱k-ne̱ wa, <<E̱stu̱n it u̱ ane̱ u-janka ne̱, it u̱ Ishaku do̱'e̱ m-ha u̱ ane̱ jit, it no̱mo̱n u̱t-huuk, it do̱'e̱ u̱t-mu̱u̱n u̱du̱ no̱.>> ");
INSERT INTO gel_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ibrahi to̱ksu̱ Ishaku u̱t-te tu̱ no̱m-du̱ to̱o̱g, wa ku̱b u-ra u-van ne̱, e̱ wane̱ aru̱k m-no̱k u̱r-kot. ");
INSERT INTO gel_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ishaku bir wa got Ibrahi, wa zu̱, <<U̱so-u ri.>> Ibrahi zu̱, <<Wa'-u̱ ri, me̱ ya.>> Ishaku shit wa zu̱, <<U̱m hyanu̱g u-ra, u̱t-te ne̱, se̱di u̱m hyanu̱g ca-yu̱ na do̱te̱ no̱m-du̱ to̱o̱g da.>> ");
INSERT INTO gel_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ibrahi shu̱s wa zu̱, <<Wa'-u̱ ri, Ru̱-u̱ de̱ haatu̱n ca-yu̱ to̱o̱g.>> Se̱ u̱n re shu̱ m-ha ne̱ u̱n yu̱r. ");
INSERT INTO gel_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Da-u̱ u̱n teye̱ be-du̱ Ru̱-u̱ waru̱ wu̱n, Ibrahi no̱m u̱r-sak wa su̱k u̱t-te u-do̱m. Wa gu̱gru̱sse̱ wa'-u̱ wa Ishaku, wa su̱k wa u̱-do̱m u̱r-sak, u̱-do̱m u̱t-te. ");
INSERT INTO gel_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Se̱ Ibrahi kabu̱n u-van, u̱ remu̱ wa pu̱nu̱t wa'-u̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","U̱ da-u o̱ wa-to̱m Yawe fog wu̱n du̱gu̱ do̱m u-ru̱, wa zu̱, <<Ibrahi! Ibrahi!>> Wa shu̱s, <<Me̱ ya.>> ");
INSERT INTO gel_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Wa zu̱ wu̱n, <<A-bo̱ ho̱ wa'-u̱ ró da, u̱ da-o̱ u̱m nak u̱zu̱ bo̱ wa u-gye̱r u-Ru̱ wa bo̱ o̱ye̱, remu̱ zu̱ bo̱ hooste̱ me̱ wa'-u̱ ró da, ya-du̱ u̱r-gan u̱ ró.>> ");
INSERT INTO gel_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Se̱ Ibrahi jaku̱s u̱r-hi, wa hyu̱n kag-yu̱ u-ca kar-u̱s wa su̱rgu̱sse̱ u̱s-hir, se̱ Ibrahi do̱'e̱ wa maas ca-u ya, wa do̱'e̱ wa nom to̱o̱g u̱ ya u̱ swas-mu̱ wa'-u̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ibrahi te̱'e̱ be-u̱r re̱ u̱r-dim, <<Yawe de̱'e u̱t-ya.>> Iya o̱ na fu̱gte̱ u̱ haan u̱ da-o̱, <<U̱ do̱m-u̱ u̱r-ro̱r de̱ Yawe do̱te̱ u̱t-ya.>> ");
INSERT INTO gel_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Se̱ wa-to̱m Yawe sur m-fag Ibrahi du̱gu̱ do̱m u-ru̱, u-yu̱ru̱mse̱. ");
INSERT INTO gel_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Se̱ wa Yawe zu̱, <<Remu̱ zu̱ bo̱ ho̱k re̱m-u̱s ri bo̱ hoostu̱ me̱ wa'-u̱ ró da, ya-du̱ u̱r-gan-u̱ ró, u̱m no̱ng u̱s-to̱nd u̱ hi-du̱ war ri ne̱, me̱ wa'-u̱ bo̱ nu-u so̱-o̱ tu̱msu̱ ko̱-u̱r ró do̱'e̱ u̱t-no̱m u-tát. ");
INSERT INTO gel_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Me̱ wa'-u̱ bo̱ nu-u so̱-o̱, u̱m wa ko̱-u̱r ró de̱ shu̱'u̱t u-tát u̱ka re̱ge̱r i do̱m u-ru̱, de̱ shu̱'u̱t tu̱msu̱ u̱ka hereg-mu̱ u-gi, ya'ag-u̱ ró de̱ re̱-du̱ dak-tu̱ hu̱u̱b-u̱t yo̱-to̱ ró m-gag. ");
INSERT INTO gel_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Du̱gu̱-du̱ ya'ag-u̱ ró de̱ ne̱t-tu̱ u-dak u̱t-be̱e̱t to̱ do̱te̱ u̱ kwu̱m-du̱ kom-u u-Ru̱ remu̱ zu̱ bo̱ do̱ro̱g rem-u̱s ri.>> ");
INSERT INTO gel_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Se̱ Ibrahi e̱ Ishaku mu̱u̱n u̱ be-du̱ to̱k-ne̱ wa o̱tte̱ e̱stu̱ u̱n, u̱nu̱ e̱ ne̱ aru̱k m-mu̱ u̱ Be̱rshe̱ba. Ku̱na Ibrahi retu̱ u-shu̱ u̱r-yu̱ ne̱ u̱ bo̱-u̱ u̱ Be̱rshe̱ba. ");
INSERT INTO gel_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Da-u̱ sure̱ m-waas, na waru̱ Ibrahi u̱zu̱, <<Mirka mak-tu̱ Naho̱r hu̱no-u rò ya'ag-u̱ campa-ne̱ eer.>> ");
INSERT INTO gel_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Wa u̱r-taku̱n na zu̱ wa Uz, hu̱no-u wa na zu̱ wa Buz, u̱ Ke̱muwe̱r (Ke̱muwe̱r wa o̱ u̱so-u̱ Aram), ");
INSERT INTO gel_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Ke̱sed, Hazo, Pirdas, Jidrab u̱ Be̱tuwe̱r ne̱. ");
INSERT INTO gel_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Be̱tuwe̱r wa matu̱ Rebeka, Mirka wa matu̱ hu̱no-u Ibrahi Naho̱r ya'ag-u̱ campa-ne̱ eer. ");
INSERT INTO gel_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Naho̱r mu̱t yaag nas du̱gu̱ ne̱ta wu̱ do̱, wu̱ na zu̱ye̱ Re̱ma, dim-tu̱ ya'ag-u̱ e̱ na zu̱: Teba, u̱ Gaham, u̱ Tahas, u̱ Maaka ne̱. ");
INSERT INTO gel_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saratu no̱mu̱g u̱s-hak u-ko̱k u-gan u̱r-shik u̱s-ta'er 127. ");
INSERT INTO gel_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Wa maru̱g u̱ bo̱-u̱ Kiriyat Arba (be-du̱ na fu̱ge̱ u̱ da-o̱ He̱bro̱n) dak-u̱ Kan'ana. Ibrahi no̱m u̱s-kan sok, wa no̱m u̱t-bomos u̱ remu̱ mar-m Saratu. ");
INSERT INTO gel_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Se̱ Ibrahi yage̱ u-du̱ ne̱ta wa, wa de̱'e wa no̱m u̱s-rem u̱ ne̱t-tu̱ He̱t-ne̱. Wa zu̱ u̱n, ");
INSERT INTO gel_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","<<Me̱ ham-u̱t wa u̱m o̱o̱ge̱ u̱du̱ no̱, babu̱n me̱ u̱r-ke̱ngi, u̱ de̱ shu̱'u̱t be-du̱ u-dok-u̱ ri ko̱ me̱ jwak-u̱ ne̱ta ri.>> ");
INSERT INTO gel_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ne̱t-tu̱ He̱t e̱ shasu̱ Ibrahi, e̱ zu̱, ");
INSERT INTO gel_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","<<U̱so u-bu it, e̱r rem-u̱s it, bo̱ ne̱t-u̱ yat-o̱ wa bo̱ o̱ye̱ it. Dag be-u̱r so̱-de̱ du̱ bo̱ u̱t-sa, bo̱ jwak ne̱ta ró u̱ku̱n. Waku̱n zaar u̱ te̱k-u̱ it wu̱ do̱'e̱ u̱t-zu̱ wa gu̱gu̱m ya-du̱ bo̱ be-du̱ jwak-du̱ ne̱ta ró da.>> ");
INSERT INTO gel_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Se̱ Ibrahi he̱ u̱t-jwu̱n u̱-shu̱ ne̱t-tu̱ dak-u He̱t. ");
INSERT INTO gel_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Wa zu̱ u̱n, <<Remu̱ zu̱ no̱ o̱ u̱ssa no̱ no̱mu̱ me̱ u̱r-se̱ge̱, u̱m o̱ u̱ssa no̱ ko̱nu̱ me̱ Eparo̱n wa'-u̱ Zohar. ");
INSERT INTO gel_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Wa babu̱ me̱ u-pu̱ku̱s u̱ jwak-du̱ u̱t-ne̱t u̱ Mape̱ra u̱ o̱o̱ge̱ u-ta u̱ madu̱ tak-u wa, shu̱tu̱n me̱ wu̱n wa babu̱ me̱ be-u̱r re̱ me̱ u̱t-to̱p no̱m-u̱ wa zu̱ u̱m to̱p. U̱m u̱t-sa ke̱ngi-u̱r re̱ u̱ka de̱ do̱te̱ shu̱'u̱t ke̱ngi-u̱r ri du̱ mo̱mmo du̱ jwak-du̱ me̱ u̱ ne̱t-tu̱ bu-u ri.>> ");
INSERT INTO gel_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Eparo̱n o̱g u̱ shu̱'u̱t u̱ku̱n u̱r-kot u̱ ne̱t-tu̱ He̱t-ne̱. Wa zu̱ Ibrahi u̱ ho̱g-mu̱ ne̱t-tu̱ He̱t u̱t-be̱e̱t i haane̱ u̱ku̱n u̱ is-yu̱ u-bo̱. ");
INSERT INTO gel_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Se̱ wa zu̱ Ibrahi, <<U̱so u-bu ri, iya-o̱ da, e̱r rem-u̱s ri. Me̱ ya bo̱ u̱r-ke̱ngi u-pu̱ku̱s ne̱, u̱ ane̱ u̱ shu̱ ne̱t-u̱t ri u̱t-be̱e̱t, bo̱ jwak u-du̱ ne̱ta ró.>> ");
INSERT INTO gel_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ibrahi kwu̱ku̱t u̱t-jwu̱n u̱ shu̱ ne̱t-tu̱ dak-u o̱. ");
INSERT INTO gel_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Se̱ wa no̱m rem-su̱ no̱m-u̱t to̱ u̱du̱ Eparo̱n u̱ ho̱g-mu̱ ne̱t-tu̱ o̱ u̱ku̱n u̱t-be̱e̱t, <<U̱m ko̱no̱g no̱, a no̱ eese̱, me̱ to̱p-u̱ shik-u̱ be-u̱r re̱ u̱r-be̱e̱t remu̱ u̱m kum-u̱t be-du̱ u̱m do̱te̱ u̱ ha jwak-du̱ ne̱t-u̱t ri a e̱ mare̱ u̱ku̱n.>> ");
INSERT INTO gel_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Eparo̱n shasu̱ Ibrahi wa zu̱, ");
INSERT INTO gel_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","<<U̱so u-bu ri, e̱r me̱, be-u̱r re̱ teeg kwam-u̱t pus-to̱ tu̱ shik u̱t-ko̱k u̱t-nas 400, u̱ka shu̱'u̱t-u̱r yu̱-u shik-u̱ e̱ o̱ko̱n no̱m-o̱ o̱ da, do̱'e̱ bu̱ jwak ne̱ta ró.>> ");
INSERT INTO gel_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibrahi hog re̱m-u̱s Eparo̱n, wa to̱p wa no̱mu̱ wa zu̱ye̱ wa to̱p kwam-u̱t pus-to̱ tu̱ shik u̱t-ko̱k u̱t-nas 400 iya na bu̱bte̱ u-tu̱rru̱. Wa no̱ng no̱m-u̱t to̱ u̱t-be̱e̱t u̱-shu̱ ne̱nge̱n-tu̱ He̱t. ");
INSERT INTO gel_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Iya-o̱ tak-u Eparo̱n u̱ o̱ u̱ Mape̱ra u̱-dapu̱s Mamre, u̱ u̱r-dame̱ u-pu̱ku̱s ne̱, u̱s-te ne̱ u̱s-be̱e̱t su̱ o̱ bo̱r-yu̱ u-tak, shu̱'u̱t u̱ Ibrahi u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Se̱ be-u̱r re̱ shu̱'u̱t be-u̱r Ibrahi du̱ m-mo̱mmo̱ u̱ shu̱ ne̱nge̱n-tu̱ He̱t u̱ is u-bo̱. ");
INSERT INTO gel_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Se̱ Ibrahi dok ne̱ta wa Saratu u̱ku̱n u̱ me̱n-tu̱ Kan'ana, pu̱ku̱s u̱ Mape̱ra u̱ dapu̱s Mamre (u̱ na foge̱ He̱bro̱n) ");
INSERT INTO gel_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Iya-o̱ tak-u o̱ u-pu̱ku̱s ne̱ u̱ o̱ ne̱t-tu̱ He̱t babu̱ Ibrahi o̱ shu̱'u̱t be-u̱r wa du̱ u-dok. ");
INSERT INTO gel_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibrahi wu̱'u̱mte̱ tu̱msu̱ hak-u̱s wa no̱ng u-tát, tu̱msu̱ Yawe wa'-u̱ wu̱n nu-u so̱-o̱ u̱-me no̱m-u̱ wa o̱ u̱t-no̱m u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","De̱ku̱n ho̱-de̱ Ibrahi zu̱ to̱k-u̱ wa wu̱ ze̱ge̱ m-tumb, wu̱ shu̱'u̱te̱ wa-gwat-du̱ bu-u wa, Ibrahi zu̱, <<Kab to̱nd bo̱ wa kom-u̱t ró u̱-ta kut-u̱t ri. ");
INSERT INTO gel_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","U̱m o̱ u̱t-sa bo̱ to̱n-de̱ Yawe ne̱ wu̱ no̱me̱ dom-u u-ru̱ u-dak-ne̱ u̱zu̱ bo̱ za yage̱ wa'-u̱ ri unwa ga ne̱ta-tu̱ dak-u̱ Kan'ana tun-to̱ da. ");
INSERT INTO gel_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Se̱di bo̱ ha u̱ dak-u ri u̱ te̱k-u̱ ko̱-u̱r ri bo̱ kwu̱mnu̱ wa'-u̱ ri Ishaku ne̱ta u̱r-gu̱.>> ");
INSERT INTO gel_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Se̱ to̱k-u̱ wa zu̱ wu̱n, <<A mu̱ne̱ u̱zu̱ gwu̱p cwanu̱g wa do̱ro̱n it u̱ mu̱u̱n u̱ dak-u uno̱ da, ¿U̱m shu̱'e̱ wa'-u̱ ró m-mu̱ u̱ dak-u̱ bo̱ rwu̱tu̱n?>> ");
INSERT INTO gel_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ibrahi zu̱ wu̱n, <<Gwat so̱k taas bo̱ jaru̱n bo̱ kab wa'-u̱ ri m-mu̱ be-du̱ u̱m rwu̱tu̱n da! ");
INSERT INTO gel_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yawe, Ru̱-u̱ do̱m u-ru̱, wu̱ rwu̱tu̱n me̱ du̱gu̱ dak-u̱ u̱so-u ri u̱ ko̱-u̱r ri ne̱, wa no̱ng este̱du̱ u̱s-rem u̱s-to̱nd ne̱ u̱zu̱ wa ya' dak-u uno̱ u̱du̱ ya'ag-u̱ ri. Wa de̱ to̱mnu̱ wa-to̱mu̱-u̱ wa u̱-shu̱ ró wa de̱ u̱t-wa bo̱ kwu̱mnu̱ wa'-u̱ ri ne̱ta u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Abite̱ u̱zu̱ wa zaar u̱ssa wa do̱ro̱n bo̱ u̱ mu̱u̱n da, bo̱ rwu̱u̱g du̱gu̱ to̱nd-su̱ u̱m no̱me̱ bo̱ ne̱. Se̱di ko̱ re̱ o̱ nomte̱ a-bo̱ jaru̱n bo̱ muut wa'-u̱ ri u̱ku̱n da.>> ");
INSERT INTO gel_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Se̱ to̱k-u̱ wa ku̱b to̱nd-u̱s se̱ wa wu̱ komu̱t wa kut-u u̱so u-bu wa Ibrahi. Wa nom este̱du̱ u̱s-rem u̱zu̱ wa do̱r no̱m-u̱ wa zu̱ wa u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Se̱ to̱k-u̱ wa ku̱b rakum Ibrahi o̱p tu̱msu̱ wa saku̱ e̱ cwu̱-tu̱ shik tu̱ u-nya u̱t-go̱ u̱t-go̱ du̱gu̱ u̱so-u̱ u-bu wa. Se̱ wa dor u-fu̱n m-ha dak-u̱ Aram, m-te bo̱-u̱ Naho̱r. ");
INSERT INTO gel_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Se̱ wa wu̱ rakum e̱ he̱ u̱t-jwu̱n u̱ dapu̱s du-du̱ ne̱t-tu̱ soye̱ u̱-do̱ u-bo̱, rim-mu̱ no̱mu̱g u̱ da-u o̱ ne̱ta-ne̱ o̱ haan u̱ yu̱bdu̱ bu̱-mu̱ u̱t-swa u̱ du-u̱r re̱. ");
INSERT INTO gel_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Se̱ wa nom u̱s-to̱o̱g, <<Yawe, Ru̱-u̱ u̱so u̱ u-bu ri Ibrahi, ya me̱ re̱ u-shu̱ bo̱ ko̱se̱ cwan-u̱t ró u̱du̱ u̱so u-bu ri Ibrahi. ");
INSERT INTO gel_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Me̱ ya ees u̱ is-u̱ u̱r-dù, ya-u̱t-gwu̱p i bo̱-u uno̱ de̱ haan u̱ du-u̱r rinde̱ u̱ yu̱bdu̱ m-bu̱. ");
INSERT INTO gel_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Sin-se̱ se̱ o̱ ko̱n-u̱s ri, me̱ u̱t-shu̱t wa-gan, <Ya me̱ m-bu̱ mu̱ u̱t-swa du̱gu̱ kub-du̱ m-bu̱ wa,> a wa zu̱ye̱ me̱, <Swa m-bu̱ tu̱msu̱ me̱ u̱t-ya rakum-u̱ ró e̱ swa> — yage̱ wa shu̱'u̱t ne̱ta wu̱ bo̱ du̱ste̱ Ishaku. Iya o̱ u̱m do̱te̱ u̱t-nap u̱zu̱ bo̱ ko̱ske̱ cwan-u̱t ró u̱du̱ u̱so u-bu ri.>> ");
INSERT INTO gel_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Kanda wu̱n taaste̱ u̱s-to̱o̱g, Rebeka rwu̱n u̱ shar-du̱ m-bu̱ wa ne̱ m-sak u̱t-kap, wa o̱ wa'-u̱ gwu̱p-u̱ Be̱tuwe̱r wu̱ o̱ wa'-u̱ zwaru̱ Mirka wu̱ o̱o̱ge̱ ne̱ta hu̱no-u Ibrahi Naho̱r. ");
INSERT INTO gel_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebeka gwu̱p-u̱ So̱-wa wa so̱k wa maag ha-mu̱ u̱r-gu̱, se̱di wa nak campa da. Wa aru̱k m-he̱ u̱ be-du̱ yu̱bdu̱ m-bu̱, wa shu̱su̱n shar-du̱ m-bu̱ wa rwu̱n. ");
INSERT INTO gel_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","To̱k-u̱ wa no̱m m-ho̱r wa bit wu̱n, wa zu̱ wa, <<U̱m o̱ u̱ ko̱n-u̱s ró, ya me̱ m-bu̱ mu̱ shar-u̱r ró cashi u̱m swa.>> ");
INSERT INTO gel_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Gwu̱p-u̱ wa zu̱ wu̱n, <<U̱so u-bu ri, o̱nko̱ bo̱ swa.>> Se̱ wa no̱m m-ho̱r wa cu̱st sharru̱ m-bu̱ wa du̱gu̱ zagu̱ u̱t-kap-u̱ wa, wa yasu̱ wu̱n, wu̱n swa. ");
INSERT INTO gel_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Da-u̱ wa ya'e̱ wu̱n bu̱-mu̱ u̱t-swa, wa zu̱, <<Me̱ u̱t-ya rakum-u̱ ró ko̱ e̱ m-bu̱ e̱ swa u̱ ko̱ru̱ e̱.>> ");
INSERT INTO gel_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Wa nom m-ho̱r wa daas bu̱-mu̱ u̱r-sharu̱ wa u-kora u̱ ya-du̱ u̱t-bisa m-bu̱ wa baru̱m u̱du̱ u̱r-dù u̱ yu̱bu̱ndu̱ m-bu̱ wa yu̱'u̱t rakum-u̱ wa be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","To̱k-u̱ wa ho'u̱s u̱s-ram wa o̱ gwat-du̱ wu̱n. Wa o̱ u̱s-dorog u̱zu̱ ko̱ Yawe yaag wu̱n re̱-du̱ u-shu̱ u̱du̱ sa-u̱ Ishaku ne̱ta. ");
INSERT INTO gel_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Da-u̱ rakum tase̱ swadu̱ m-bu̱, se̱ to̱k-u̱ wa ku̱b kwat-yu̱ u̱r-swa u̱ u̱s-kwa ne̱ su̱ u̱t-kom su̱ kwam-tu̱ bu̱-mu̱ u̱t-ro su̱ shik so̱k wa yasu̱ Rebeka. ");
INSERT INTO gel_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Se̱ wa shit Rebeka u̱zu̱, <<¿Gwu̱p-u̱ wan wa bo̱ o̱ye̱? Gye̱r jab waru̱ me̱, ¿ko̱ u̱so-u ró o̱tte̱ kur-tu̱ it do̱te̱ m-roog u̱ gyu̱p-mu̱ ya-o̱?>> ");
INSERT INTO gel_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Wa shu̱s wa zu̱, <<U̱so-u ri wa na zu̱ye̱ Be̱tuwe̱r, tu̱msu̱ u̱so-u rò u̱ ino-u rò ne̱ e̱ na zu̱ye̱ Naho̱r e̱ Mirka.>> ");
INSERT INTO gel_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Wa sur m-zu̱ wu̱n, <<It o̱tte̱ u̱t-zan u̱ no̱m-tu̱ u̱t-re̱ ne̱ tu̱ rakum, u̱ kur-tu̱ m-roog ne̱ tu̱ u̱t-hamu̱t ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Se̱ to̱k-u̱ wa kug wa nom Yawe u̱t-huuk. ");
INSERT INTO gel_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Wa zu̱, <<U̱t-vam u̱du̱ Yawe, Ru̱-u̱ u̱so-u ri Ibrahi, Yawe ko̱ske̱ cwan-u̱t wa nip-u̱t wa ne̱ jab-u̱ so̱-o̱ wa ne̱ u̱du̱ u̱so-u̱ u-bu ri, remu̱ u̱zu̱ wa dor-u̱t te̱ me̱ m-ha u̱du̱ ko̱-du̱ u̱so-u̱ u-bu ri.>> ");
INSERT INTO gel_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Wa-gwu̱pu̱ aru̱k m-mu̱ m-so̱m wa waru̱ a-u-bu ne̱ no̱m-u̱ no̱me̱ u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka o̱tte̱ yu̱-wu̱ya wu̱na zu̱ye̱ Raban, wa ku̱su̱m m-so̱m u̱ haan u̱ be-du̱ ne̱t-u̱ wa o̱tte̱ u̱-kit u̱r-du. ");
INSERT INTO gel_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Da-u̱ wa hyane̱ kwat-yu̱ u̱r-swa ya u̱du̱ Rebeka, u̱ kwasu̱ u̱t-kom ne̱ su̱ o̱ m-wa u̱ ko̱m-u̱t wa, tu̱msu̱ wa ho̱k no̱m-u̱ Rebeka ware̱ u-be̱e̱t no̱m-u̱ ne̱t-u̱ wa zu̱ye̱, wa ru m-ha u̱ du-du̱ m-bu̱ de̱, be-du̱ ne̱t-u̱ wa o̱tte̱ ees u̱-kit u-rakum. ");
INSERT INTO gel_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Raban zu̱ wu̱n, <<Bo̱ yu̱ Yawe wa'e̱ nu-u so̱-o̱. Haane̱ bo̱ shu̱'u̱t u̱ it ne̱. ¿Rem yan-o̱ bo̱ o̱tte̱ u̱ shu̱'u̱t u̱ ane̱ u̱-dim u-bo̱? Me̱ ya u̱m mangte̱ bo̱ u̱t-kur u̱ be-du̱ cu̱n-du̱ rakum-u̱ ró ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Se̱ ne̱t-u̱ wa aru̱k m-ha bu-u Raban. Raban cu̱st-u̱ rakum cwu̱-tu̱ e̱ o̱tte̱ u̱-do̱ m-sak, wa yu̱' e̱ u̱t-zan tu̱ e̱ do̱'e̱ u̱t-roog u̱t-tu̱. Se̱ wa hatu̱n ne̱t-u̱ wa m-bu̱ u̱ remu̱ i o̱ nak-du̱ rakum ne̱ e̱ jaaste na-u̱s e̱ be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Wa haatu̱n wa no̱m u̱t-re̱, se̱ to̱k-u̱ wa zu̱ wu̱n, <<U̱m za re̱-du̱ no̱m u̱t-re̱ uno̱ da se̱ u̱m wargu̱ bo̱ no̱m-u̱ hatu̱n me̱.>> Raban zu̱ wu̱n, <<Waru̱ me̱ no̱m-u̱ hatu̱n bo̱.>> ");
INSERT INTO gel_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Se̱ wa zu̱ wu̱n, <<Me̱ to̱k-u̱ Ibrahi wa u̱m o̱ye̱. ");
INSERT INTO gel_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yawe wa'agu̱ u̱so u-bu ri ko̱m-u u-Ru̱, wa shu̱'u̱te̱ ne̱t wu̱ o̱tte̱ no̱m-u̱ u̱t-kom. Ru̱-u̱ yaag wu̱n ban-tu̱ ca, u̱ ban-tu̱ gwaar ne̱, u̱ ban-du̱ na ne̱, u̱ kwam-u̱t pus-to̱ u̱ tu̱ bu̱-mu̱ u̱t-ro ne̱ tu̱ shik, u̱ to̱k-ne̱ u-tát (campa-ne̱ u̱ ne̱ta-ne̱) u̱ janka ne̱, u̱ rakum ne̱. ");
INSERT INTO gel_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Da-u̱ Saratu ne̱ta u̱so-u̱ u-bu ri wu̱u̱me̱ so̱k, se̱ wa mu̱t ya-du̱ u̱r-campa, u̱so u-bu ri yase̱ wu̱n no̱m u̱t-kom-u̱ wa u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","U̱so u-bu ri to̱ndu̱ste̱ me̱ u̱zu̱, <A-bo̱ yage̱ u̱ wa'-u̱ ri wa ga ne̱ta-tu̱ dak-u̱ Kan'ana da i u̱m o̱o̱ge̱ u̱ shu̱'u̱t dak-u e̱. ");
INSERT INTO gel_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Se̱di bo̱ do̱'e̱ bu-u u̱so-u ri, du̱gu̱ me̱ ko̱-du̱ u̱so-u ri bo̱ kwu̱mnu̱ wa'-u̱ ri ne̱ta.> ");
INSERT INTO gel_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","<<U̱m zu̱ u̱so u-bu ri, <¿A mu̱ne̱ u̱zu̱ u̱m kwu̱mu̱g wa'-u̱ gwu̱p wu̱ zu̱ wa do̱rnu̱ me̱ da?> ");
INSERT INTO gel_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","<<Wa zu̱ me̱, <Yawe, wu̱ u̱m o̱ u̱t-do̱r, wa to̱mnu̱ Wa-to̱m-u̱ wa u̱r-kot u̱ bo̱ ne̱. Wa do̱'e̱ u̱t-wa bo̱ kum re̱-u̱ u-shu̱ u̱ no̱mu̱ bo̱ u̱t-no̱m ne̱. Ka u̱t-no̱m zarra se̱ bo̱ kwu̱mgu̱n wa'-u̱ ri ne̱ta du̱gu̱ ko̱-du̱ u̱so-u ri, u̱du̱ me̱ ne̱t-tu̱ bu-u̱ u̱so-u ri. ");
INSERT INTO gel_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Da-u̱ bo̱ do̱'e̱ u̱du̱ u̱so-u̱t ri, bo̱ rwu̱u̱g du̱gu̱ u̱s-to̱nd ko̱ da zu̱ e̱ gu̱gu̱mte̱ yanu̱ bo̱ ne̱ta bo̱ rwu̱u̱g du̱gu̱ sese to̱nd se̱.> ");
INSERT INTO gel_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","<<Da-u̱ u̱m haane̱ be-du̱ du-du̱ m-bu̱ u̱ ya-o̱, se̱ u̱m no̱m u̱s-to̱o̱g u̱zu̱, <Yawe, Ru̱-u̱ u̱so u-bu ri Ibrahi no̱me̱ u̱t-huuk, ya me̱ re̱-u̱ u-shu̱ u̱ ha-m m-mo̱. ");
INSERT INTO gel_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Gwat, me̱ ya ees u̱-kit-u̱ du-du̱ m-bu̱ dinde̱, to̱o̱g-u̱s se̱ u̱zu̱, da-u̱ wa'-u̱ gwu̱p-u̱ haane̱ u̱ nak-du̱ m-bu̱, u̱m do̱'e̱ zu̱ du̱ wa, <<Ya me̱ m-bu̱ u̱m swa du̱gu̱ sharru̱ m-bu̱ ró.>> ");
INSERT INTO gel_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Se̱di wa zu̱ me̱, <<Swa, me̱ u̱t-ya rakum-u̱ ró m-bu̱ ko̱ya,>> yage̱ wa shu̱'u̱t ne̱ta wu̱ Yawe dage̱ wa'-u̱ u̱so-u̱ u-bu ri.> ");
INSERT INTO gel_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","<<Kanda u̱m taaste̱ u̱s-to̱o̱g jab-u̱ ri, Rebeka rwu̱u̱n u̱r-shar ne̱ m-sak u̱ do̱s u̱ wa, wa aru̱k m-sa u̱r-du wa yu̱bu̱n m-bu̱, se̱ u̱m zu̱ wa, <Ya me̱ m-bu̱ m-swa.> ");
INSERT INTO gel_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","<<Wa no̱m m-ho̱r m-ho̱r wa cu̱st sharru̱ m-bu̱ du̱gu̱ zagu̱ zag-u̱t-kap wa zu̱, <Swa, me̱ u̱t-ya rakum-u̱ ró ko̱ e̱,> se̱ u̱m so, wa yu̱ rakum ko̱'e̱ e̱ so. ");
INSERT INTO gel_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","<<Se̱ u̱m shit wa, <¿Gwu̱p-u̱ wan wa bo̱ o̱ye̱?> <<Wa zu̱ me̱, <Gwu̱p-u̱ Be̱tuwe̱r yu̱ wa'-u̱ Naho̱r, wu̱ Mirka matu̱ wa.> <<Da-u o̱ u̱m wa'-u̱ wu̱n u-kwaat u̱r-swa u̱ kwa-yu̱ u̱t-kom ne̱. ");
INSERT INTO gel_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Se̱ u̱m he̱ u̱t-jwu̱n u̱m no̱me̱ Yawe u̱t-huuk, tu̱msu̱ u̱m no̱mu̱ Yawe u̱t-vam, Ru̱-u u̱so u-bu ri Ibrahi, remu̱ zu̱ wa dor-u̱t te̱ me̱ fu̱n-yu̱ u̱t-nip m-ha u̱du̱ ko̱-du̱ u̱so-u wa remu̱ u̱m kwu̱mtu̱n wa'-u̱ wa ne̱ta. ");
INSERT INTO gel_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","U̱ da-o̱, abite̱ u̱zu̱ bo̱ u̱t-re̱ u-shu̱ u̱ ko̱su̱ jab-u̱ so̱-o̱ u̱du̱ u̱so-u̱ u-bu ri, waru̱ me̱, abite̱ bo̱ zaar u̱t-ko̱se̱ da waru̱ me̱, ko̱ me̱ u̱t-nap fu̱n-yu̱ u̱m do̱'e̱ u̱t-do̱r.>> ");
INSERT INTO gel_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ku̱na Raban ne̱ e̱ Be̱tuwe̱r zu̱, <<Yawe hattu̱n bo̱ u̱ ane̱, o̱ko̱n no̱m-o̱ zaar u̱ it do̱'e̱ u̱t-zu̱ da. ");
INSERT INTO gel_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka ya u̱-shu̱ ró, kab wa bo̱ aru̱k, yage̱ wa shu̱'u̱t ne̱ta wa'-u̱ u̱so-u̱ u-bu ró u̱ka Yawe zu̱tte̱.>> ");
INSERT INTO gel_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Da-u̱ to̱k-u̱ Ibrahi ho̱ge̱ shas-u u̱n, wa he̱ u-dak u̱t-jwu̱n wa no̱me̱ Yawe u̱t-huuk. ");
INSERT INTO gel_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Se̱ to̱k-u̱ wa rwu̱tu̱n kwam-u̱t pus-to̱ u̱ kwam-tu̱ bu̱-mu̱ u̱t-ro ne̱ u̱s-re̱ge̱z ne̱ su̱ shik so̱k u̱ cwu̱-tu̱ m-wa ne̱ tu̱ so̱-to̱ wa yase̱ Rebeka, se̱ tu̱msu̱ wa yu̱ u-nya u̱ no̱m-tu̱ shik u̱du̱ yu̱-wu̱ya wa u̱ ino̱-u wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Se̱ to̱k-u̱ Ibrahi u̱ campa-ne̱ o̱ u̱r-kot u̱ wa ne̱, re e̱ so tu̱msu̱ e̱ roog u̱ku̱n. Se̱ e̱ yu̱ne̱ u̱r-wu̱n, wa zu̱, <<Yagu̱n it aru̱k m-mu̱ u̱du̱ u̱so-u̱ u-bu ri.>> ");
INSERT INTO gel_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Se̱di yu̱-wu̱ya Rebeka u̱ ino-u rò ne̱ shu̱s e̱ zu̱, <<It u̱t-sa u̱ Rebeka shu̱'u̱t u̱ it ne̱ m-ha m-roog u̱t-o̱p, kanda no̱ aru̱k.>> ");
INSERT INTO gel_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Se̱ wa zu̱ u̱n, <<A no̱ naas it u-da u̱ ane̱ da, Yawe yaag me̱ re̱ u-shu̱ u̱ ha-m ri, yagu̱n it aru̱k, it mu u̱du̱ u̱so-u̱ u-bu ri.>> ");
INSERT INTO gel_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Se̱ u̱n zu̱, <<Yage̱ it fagu̱n gwu̱p it shit wa u̱ mo̱t-u̱t to̱ ne̱ it ho̱g.>> ");
INSERT INTO gel_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Se̱ u̱n fagu̱n Rebeka u̱n shit wa, <<¿Bo̱ do̱ru̱ ne̱t-u̱ wa m-mu̱?>> Wa shu̱s wa zu̱, <<Me̱ u̱t-do̱r wu̱n.>> ");
INSERT INTO gel_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Se̱ u̱n yage̱ u̱ Rebeka u̱ ne̱ta waru̱g wa ne̱, u̱ to̱k-u̱ Ibrahi ne̱ u̱ hu̱u̱b-tu̱ m-ha wa ne̱ e̱ aru̱k. ");
INSERT INTO gel_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Se̱ u̱n wa'-u̱ Rebeka nu-u so̱-o̱ kanda wa aru̱k, u̱n zu̱ wa, <<Hu̱no-u it, u̱ bo̱ shu̱'u̱t ino̱ u̱ yaag u̱t-zo̱ngu u̱-do̱m u̱t-zo̱ngu Yage̱ ya'ag-u̱ ró e̱ re u̱r-ko̱rro̱ u̱ e̱ o̱nk bo̱-tu̱ hu̱u̱b-u̱t yo̱-to̱ e̱ ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Se̱ Rebeka u̱ to̱k-u̱t wa ne̱, e̱ du̱u̱s u̱-do̱m u-rakum e̱ do̱r ne̱t-u̱ wa. Se̱ to̱k-u̱ Ibrahi ku̱b Rebeka e̱ aru̱k m-mu̱. ");
INSERT INTO gel_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","U̱ da-u o̱ Ishaku mu̱gu̱n du̱gu̱ Beer-Rahai Roi wa o̱ shu̱'u̱t do̱g-du̱ Ne̱giv. ");
INSERT INTO gel_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","De̱ku̱n ho̱-de̱ Ishaku rwu̱gu̱n m-rim wa o̱ m-da tu̱msu̱ wa o̱ u̱s-dorog, se̱ wa jaku̱s u̱r-hi, wa hyen rakum u̱ daan. ");
INSERT INTO gel_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Da-u̱ Rebeka jakse̱ is wa hyan Ishaku, wa no̱m m-ho̱r wa cu̱zu̱n du̱gu̱ u-rakum yu̱ wa o̱tte̱ m-sak. ");
INSERT INTO gel_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Rebeka zu̱ to̱k-u̱ Ibrahi, <<¿Wana unwa jit wu̱ o̱ haan u̱du̱ ine̱?>> To̱k-u̱ wa zu̱, <<U̱so u-bu ri Ishaku wa.>> Rebeka ku̱b u-ge̱re̱ wa taku̱s shu̱-u wa. ");
INSERT INTO gel_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Se̱ to̱k-u̱ wa waru̱ Ishaku no̱m-u̱ wa no̱me̱ u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ishaku ku̱b Rebeka wa hu̱u̱t wa u̱ be-du̱ rimpa-du̱ ino̱-u wa Saratu, se̱ wa gu Rebeka. Wa shu̱'u̱t ne̱ta wa, wa cwanu̱g wa so̱k; iya o̱ hen Ishaku kumte̱ ru̱s-du̱ jab ba ino-u wa mare̱. ");
INSERT INTO gel_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibrahi gu̱ yaku̱n ne̱ta ya dim-u̱r wa Ketura. ");
INSERT INTO gel_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura mu̱t ya'ag-u̱ campa-ne̱ shishin e̱ na foge̱ Zimran, Jokshan, Medan, Midiya, Ishbak, u̱ Suya ne̱. ");
INSERT INTO gel_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan wa mate̱ Sheba u̱ Dedan. Yaag-u̱ Dedan e̱ na zu̱ye̱ Assur-ne̱, u̱ Retushi-ne̱, u̱ Remin-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Yaag-u̱ campa-ne̱ Midiya e̱ o̱ye̱: Epa ne̱, u̱ Epe̱r ne̱, u̱ Hano̱k ne̱, u̱ Abida ne̱, u̱ Erdak ne̱. Ine̱ be̱e̱t e̱ o̱o̱ge̱ ko̱r Ibrahi du̱gu̱ gasu Ketura. ");
INSERT INTO gel_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibrahi yasu̱ no̱m-u̱ u̱t-ko̱mu̱ wa u-be̱e̱t u̱du̱ Ishaku. ");
INSERT INTO gel_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Kanda Ibrahi mu̱r-u̱t, wa no̱mu̱ ya'ag-u̱ ne̱ta-tu̱ u̱s-kit-u̱ wa u-nya wa tom e̱ be̱e̱t m-ha dak-u̱ u-do̱m, m-ra u̱ Ishaku ne̱. ");
INSERT INTO gel_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ibrahi no̱ng u̱s-hak u̱t-shik u̱t-eer u̱ o̱p u̱s-tan 175 ");
INSERT INTO gel_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ibrahi maru̱g u̱ te̱k-u̱ u̱s-hak su̱ so̱-se̱, ne̱nge̱n-yu̱ u̱s-hak u-tát, wa dor u̱so-tu̱ u̱so-u̱t wa. ");
INSERT INTO gel_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Yaag-u̱ wu̱n Ishaku ne̱ e̱ Ismaru, e̱ dok wu̱n u̱ pu̱ku̱s u̱ Mape̱ra, u̱ dapu̱s Mamre u̱-me tak-u Eparo̱n wa'-u̱ Zohar ne̱t-u̱ He̱t-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Tak-u o̱ Ibrahi o̱ye̱ du̱gu̱-du̱ He̱t-ne̱ ku̱na wa dokte̱ Saratu ne̱ta wa. ");
INSERT INTO gel_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Da-u̱ Ibrahi mare̱, Ru̱-u̱ wa'-u̱ Ishaku nu-u so̱-o̱, wu̱ shu̱'u̱te̱ dap-u̱s bo̱-u̱ na foge̱ Beer-Rahai. ");
INSERT INTO gel_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Uno̱ o̱ ogu̱r-tu̱ ya'ag-u̱ Ismaru wa'-u̱ Ibrahi. Hajara ne̱t-u̱ dak-u̱ Masar to̱k-u̱ Saratu, wa matu̱ Ismaru. ");
INSERT INTO gel_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Dim-tu̱ ya'ag-u̱ campa-ne̱ Ismaru ya, na pang to̱ u̱ka mat-u̱r e̱: Nebayo̱t wa o̱o̱ge̱ mat-du̱ u̱r-taku̱n Ismaru, u̱ Kedar, u̱ Adbeer, u̱ Misam, ");
INSERT INTO gel_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","u̱ Mishma, u̱ Duma, u̱ Masa, ");
INSERT INTO gel_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","u̱ Hada, u̱ Tema, u̱ Je̱tur, u̱ Napu̱hish, u̱ Kedema ne̱. ");
INSERT INTO gel_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ine̱ o̱ ya'ag-u̱ Ismaru, tu̱msu̱ tun-to̱ to̱ o̱ dim-tu̱ faru̱k-tu̱ u̱t-ko̱ e̱ ko̱wan u̱ be-du̱ u̱r-shu̱'u̱t-u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismaru no̱mu̱g u̱s-hak u̱t-shik u̱t-shishin u̱ o̱p-u̱ ta'er 137, se̱ mu̱ru̱s wa do̱r u̱so-tu̱ u̱so-u̱t wa. ");
INSERT INTO gel_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Yaag-u̱ wa e̱ shu̱'u̱t u̱ gas-u̱ bo̱-u̱ Havira, m-ha Shur ne̱. U̱ dapu̱s bo̱r-yu̱ Masar, a-bo̱ o̱o̱ge̱ m-ha u̱ bo̱-u̱ Asur. Tu̱msu̱ e̱ nom shu̱'u̱t-u̱r yo̱-de̱ u̱ hu̱no-tu̱ u̱r-mat-u̱ e̱ ne̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Uno̱ o̱ ogor-tu̱ ya'ag-u̱ Ishaku wa'-u̱ Ibrahi. Ibrahi wa matu̱ Ishaku. ");
INSERT INTO gel_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Da-u̱ Ishaku o̱o̱ge̱ u̱s-hak u̱t-shik u̱t-yu̱r 40, wa gu̱ Rebeka gwu̱p-u̱ Be̱tuwe̱r, ne̱t-u̱ bo̱-u̱ Aram du̱gu̱ Padan-aram hu̱no̱ Raban ne̱t-u̱ Aram-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ishaku nom u̱s-to̱o̱g u̱du̱ Yawe u̱ remu̱ ne̱ta wa, remu̱ zu̱ wa matu̱k yaag da. Ru̱-u̱ o̱nk to̱o̱g-u̱s Ishaku, se̱ Rebeka ku̱b me̱n-tu̱ ya'ag-u̱ yu̱r. ");
INSERT INTO gel_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Se̱ ya'ag-u̱ e̱ hu̱ u̱t-noos u̱ me̱n-tu̱ u̱t-me̱n. Se̱ Rebeka do̱'e̱ wa shit Yawe, wa zu̱ <<¿Yan-o̱ wa e̱ uno̱ no̱m o̱ o̱tte̱ u̱t-no̱m ne̱?>> ");
INSERT INTO gel_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Se̱ Yawe zu̱ wu̱n, <<Ne̱t-ne̱ yu̱r e̱ o̱ye̱ u̱ me̱n-u̱t ró damra tu̱ u̱t-dak to̱ u̱t-yu̱r. Du̱gu̱ u̱r-taku̱n, dak-tu̱ u̱t-yu̱r u̱ to̱ do̱'e̱ u̱t-mo̱t du̱gu̱ me̱ u̱t-me̱n. Wa-gan do̱'e̱ ze̱g-du̱ wa-gan u̱r-be̱b, ya'ag-u̱ e̱ wu̱ do̱'e̱ rwu̱u̱n u̱r-taku̱n wa do̱'e̱ no̱mu̱ wu̱ m-vaste̱ m-to̱k.>> ");
INSERT INTO gel_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Da-u̱ ho̱-tu̱ u̱r-mat no̱me̱, Rebeka nu̱p u̱zu̱ ya'ag-u̱ yu̱r e̱ wa o̱tte̱ mu̱n-u̱t wa. ");
INSERT INTO gel_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Wu̱ rwu̱ne̱ u̱r-taku̱n wa o̱ jaz-ya, war-u wa o̱ u̱s-can ne̱ sha-mu̱ can-tu̱ u-gwaar, na wa'-u̱ wa u̱r-dim Isuwa. Iya-o̱ na fogte̱ dim-u̱r re̱ u̱ rem-du̱ Ibra-ne̱. <<Wa u̱s-can.>> ");
INSERT INTO gel_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Se̱ wu̱ rwu̱ne̱ u-yu̱ru̱mse̱ na mak-u̱t wa m-shu̱p-u̱ du̱ku̱nte̱-u̱r Isuwa ne̱, dim-u̱r wa de̱ Yakubu. U̱ rem-du̱ Ibra-ne̱ iya-o̱ na fogte̱ dim-u̱r re̱ <<U̱r-du̱ku̱nte̱.>> Da-u̱ na mate̱ ya'ag-u̱ yu̱r, Ishaku o̱ u̱s-hak u̱t-shik u̱t-tu̱t 60. ");
INSERT INTO gel_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Da-u̱ ya'ag-u̱ campa-ne̱ e̱ ne̱ne̱, Isuwa shu̱'u̱t wa sa-u̱ u̱r-do̱g, wa o̱ u̱ka ne̱t u̱r-do̱g. Se̱di Yakubu wa zatte̱ u̱s-rem da, wa ze̱k-u̱ cwan-tu̱ shu̱'u̱t-du̱ u̱t-rimpa. ");
INSERT INTO gel_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ishaku ze̱k-u̱ cwan-u̱t Isuwa remu̱ zu̱ wa ze̱k-u̱ cwan-tu̱ ap-mu̱ u̱r-do̱g, se̱di Rebeka ze̱k-u̱ cwan-u̱t Yakubu. ");
INSERT INTO gel_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","De̱ku̱n ho̱-de̱ Yakubu o̱ u̱ no̱m-du̱ cwa-su̱ m-re̱re̱m, Isuwa mu̱u̱n du̱gu̱ u̱r-do̱g wa pogu̱n wa-o u̱ ho̱g-du̱ u̱s-me̱r. ");
INSERT INTO gel_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Wa zu̱ Yakubu, <<Gye̱r jab, u̱m o̱ ho̱g-du̱ u̱s-me̱r, ya me̱ cwa-u̱s jasse̱ su̱ m-re̱re̱m-u̱ ró se̱ u̱m re̱!>> (Iya o̱ Isuwa kumte̱ dim-u̱r re̱, du̱ na zu̱ye̱ Edo̱m tu̱msu̱ na zu̱ de̱ <<jas-de̱.>>) ");
INSERT INTO gel_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakubu shu̱s wa zu̱, <<Me̱ ya bo̱, se̱di u̱m o̱ u̱ssa bo̱ babu̱ me̱ o̱g-du̱ mat-du̱ u-shu̱ ró.>> ");
INSERT INTO gel_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Isuwa zu̱, <<Me̱ ya u̱m o̱ m-mar u̱s-me̱r, ¿yan-o̱ shu̱'u̱t-u̱r ri mat-du̱ u-shu̱ no̱mu̱ me̱ u̱ da-o̱?>> ");
INSERT INTO gel_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakubu zu̱, <<U̱ da-o̱ u̱m o̱ u̱ssa bo̱ to̱n-de̱ u̱zu̱ bo̱ yasu̱ me̱ o̱g-du̱ mat-du̱ u-shu̱.>> Da-u o̱ Isuwa to̱n-de̱, wa bu̱psu̱ Yakubu du̱-dim-u̱ wa o̱g-du̱ mat-du̱ u-shu̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Da-u o̱ Yakubu ya'e̱ Isuwa u̱t-be̱re̱di u̱ cwa-su̱ yaar ne̱, Isuwa re̱ no̱m u̱t-re̱, wa yu̱ne wa aru̱k. Iya o̱ Isuwa ju̱ru̱mte̱ o̱g-du̱ mat-du̱ u-shu̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","U̱ da-u o̱ na no̱ng se̱ke̱n me̱r-u̱s yasse u-dak, u̱ka na nomte̱ da-u Ibrahi. Ishaku aru̱k m-ha u̱du̱ Abime̱re̱k faru̱k-u̱ Firistiya-ne̱ bo̱-u̱ Gerar. ");
INSERT INTO gel_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yawe haan u̱du̱ Ishaku wa zu̱ wa, <<A-bo̱ o̱ m-ha dak-u̱ Masar da, se̱di bo̱ no̱m ka u̱m zu̱tte̱ bo̱. ");
INSERT INTO gel_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Shu̱'u̱te̱ ane̱ sha-mu̱ ham-u̱t u-dak, me̱ u̱t-no̱m u̱r-kot u̱ bo̱ ne̱. Tu̱msu̱ me̱ wa'-u̱ bo̱ nu-u so̱-o̱, me̱ ya'u̱ bo̱ u̱ ko̱-u̱r ró ne̱ uno̱ dak-o̱. U̱m shu̱u̱s to̱nd-u̱s ri su̱ u̱m no̱me̱ u̱ u̱so-u ró ne̱ Ibrahi. ");
INSERT INTO gel_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Me̱ u̱t-wa ya'ag-u̱ ró e̱ shu̱'u̱t u-tát u̱ka re̱ge̱r i do̱m u-ru̱, tu̱msu̱ me̱ yasu̱ e̱ uno̱ dak-o̱. Tu̱msu̱ du̱gu̱-du̱ ya'ag-u̱ ró de̱ ne̱t-tu̱ dak-u uno̱ u-be̱e̱t e̱ do̱te̱ kwu̱m-du̱ kom-u so̱-o̱ u̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Me̱ no̱mu̱ uno̱ no̱m-o̱ remu̱ zu̱ Ibrahi ho̱k rem-u̱s ri tu̱msu̱ wa no̱mu̱g no̱m-tu̱ u̱m zu̱ye̱ wa no̱m, wa do̱ro̱g rem-u̱s ri, u̱ bo̱r-u̱t ri ne̱ u̱t-be̱e̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ishaku shu̱'u̱t Gerar. ");
INSERT INTO gel_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Da-u̱ ne̱t-tu̱ o̱ shu̱'u̱t u̱ku̱n e̱ shite̱ Ishaku mo̱ttu̱ ne̱ta wa, wa zu̱ u̱n, <<Hu̱no-u ri wa.>> Rem u̱zu̱ wa o̱ u̱ ho̱g-du̱ u-gye̱r wa zu̱, <<Ne̱ta ri wa.>> Wa no̱ng u̱s-dorog u̱zu̱, <<Taas u̱ ne̱t-u̱t tun-to̱ ho̱ me̱ u̱ remu̱ Rebeka, remu̱ zu̱ wa so̱-ya sok.>> ");
INSERT INTO gel_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Da-u̱ Ishaku tumbe̱ u̱ku̱n, Abime̱re̱k faru̱k-u̱ Firistiya-ne̱ wa wu̱kse̱ du̱gu̱ pyam-yu̱ u-kur wa hyu̱n Ishaku o̱ tamgu̱ war-u̱ ne̱ta wa Rebeka. ");
INSERT INTO gel_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Za naas u-da, Abime̱re̱k fog Ishaku. Wa zu̱, <<Za o̱ko̱n sakna o̱ ne̱ta rò wa! ¿Remu̱ yan-o̱ bo̱ zu̱tte̱, <Hu̱no-u ri wa>?>> Ishaku shu̱s wa zu̱, <<U̱m o̱ ho̱g-du̱ u-gye̱r u̱zu̱ na ho̱ me̱ na kab ne̱ta ri.>> ");
INSERT INTO gel_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abime̱re̱k zu̱, <<¿Yan-o̱ wa'e̱ bo̱ no̱mtu̱ it go̱-du̱ uno̱ no̱m-o̱? Waku̱n u̱ te̱k-u̱ ne̱t-u̱t ri wa kere̱ m-roog u̱ wa ne̱, a-za shu̱'u̱te̱ iya bo̱ za wa'ag it no̱m-du̱ baas-u̱t u̱t-yatto̱!>> ");
INSERT INTO gel_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Se̱ Abime̱re̱k no̱m u̱r-do̱nse̱, wa nu̱k ne̱t-ne̱ u̱t-to̱. Wa zu̱ e̱, <<Ko̱wan wu̱ tame̱ ne̱t unwa ko̱ ne̱ta wa na ho̱ wa.>> ");
INSERT INTO gel_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Da-u̱ Ishaku kawe̱ no̱m-tu̱ u-go̱s u̱ hak-u ya, wa kum no̱m-tu̱ u̱r-to̱m u-so u-ko̱k u-gan m-ze̱g no̱mu̱ wa kawe̱, Yawe wa'agu̱ wa kom-u so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Wa shu̱'u̱t wa-u̱t-kwu̱m so̱k, no̱m u̱t-kom-u̱ wa re̱ u-shu̱ m-swu̱r-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Wa kum ban-tu̱ ca u̱ ban-tu̱ gwaar ne̱, u̱ ban-tu̱ na ne̱, u̱ to̱k-ne̱ u-bu ne̱ u-tát, Firistiya-ne̱ hu̱ shu̱b-u̱r wa. ");
INSERT INTO gel_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Firistiya-ne̱ e̱ shu̱u̱s du-tu̱ m-bu̱ tu̱ to̱k-ne̱ u̱so-u wa Ibrahi kawe̱ m-huug. ");
INSERT INTO gel_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abime̱re̱k zu̱ Ishaku, <<Yu̱ne̱ bo̱ yage̱ bo̱-u it, remu̱ zu̱ bo̱ be̱b-u̱r it.>> ");
INSERT INTO gel_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Se̱ Ishaku yu̱ne̱ wa muus u̱ gas-u̱ fu̱g-yu̱ Gerar, ku̱na wa ku̱u̱te u̱r-rimpa, wa shu̱'u̱t u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ishaku sur m-kaw du-tu̱ u̱so-u wa kawe̱, du-tu̱ Firistiya-ne̱ takse̱ da-u̱ Ibrahi mare̱, wa muut dim-tu̱ na o̱o̱ge̱ na wa'agu̱ du̱-u̱t to̱ wa wa'-u̱ go̱-du̱ dim-du̱ Ibrahi te̱'e̱ to̱. ");
INSERT INTO gel_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","To̱k-ne̱ Ishaku e̱ ku̱w de̱ku̱n du-de̱ u̱ me̱n-tu̱ fu̱g-u ya e̱ kum bu̱-m so̱-mo̱. ");
INSERT INTO gel_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Se̱di ne̱t-tu̱ Gerar haan e̱ hu̱ kadu̱ gwu̱z-u̱ a-gwat-du̱ u̱t-bisa ne̱ Ishaku e̱ zu̱, <<Du-du̱ m-bu̱ e̱ de̱!>> Se̱ Ishaku te̱'e̱ du-u̱r re̱ u̱r-dim E̱sek no̱m-u̱ na zu̱ye̱ kadu̱ <<u-gwu̱z.>> ");
INSERT INTO gel_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Se̱ ne̱t-u̱t Ishaku sur m-kaw de̱ku̱n du-de̱ tu̱msu̱ na sur m-ka gwu̱z-u̱ de̱ ne̱. Se̱ Ishaku sur m-te̱'e̱ du-u̱r re̱ u̱r-dim, <<U̱t-gu̱gu̱m.>> ");
INSERT INTO gel_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Wa yu̱ne̱ be-u̱r re̱ wa sur m-kaw de̱ku̱n du-de̱, se̱di e̱ swu̱ru̱g m-ka gwu̱z-u̱ de̱ ne̱ da. Se̱ wa fog du-u̱r re̱ u̱r-dim Rehobo̱t, du̱ na foge̱, Be-du̱ na upse̱ remu̱ zu̱ wa zu̱u̱g, <<Yawe upuste̱ u̱r-ke̱ngi u-tát du̱ it do̱te̱ u̱t-shu̱'u̱t m-yang ne̱ u-dak.>> ");
INSERT INTO gel_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Du̱gu̱ ku̱n Ishaku aru̱k m-ha Be̱rshe̱ba. ");
INSERT INTO gel_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","U̱ gyu̱p-m mo̱ Yawe haan u̱du̱ rò wa zu̱, <<Me̱ wa o̱ u-Ru̱ u̱ u̱so-u ró Ibrahi. Wa zu̱ wu̱n a-bo̱ ho̱g u-gye̱r da u̱m o̱ u̱r-kot u̱ bo̱ ne̱ tu̱msu̱ me̱ wa'-u̱ bo̱ nu-u so̱-o̱. Me̱ u̱t-wa ya'ag-u̱ ró no̱m u-tát, e̱ do̱'e̱ u̱t-shu̱'u̱t damra u-dak. Me̱ u̱t-no̱m iya remu̱ este̱du̱ u̱s-rem su̱ it u̱ Ibrahi to̱k-u̱ ri no̱me̱.>> ");
INSERT INTO gel_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ishaku mu̱ u̱r-sak du̱ no̱m-du̱ to̱o̱g u̱ku̱n wa no̱mu̱ Yawe u̱t-huuk. Wa nom rimpa-u̱r wa u̱ku̱n, se̱ to̱k-ne̱ wa e̱ sur m-kaw de̱ku̱n du-de̱. ");
INSERT INTO gel_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Da-u̱ arke̱ Abime̱re̱k tamge̱ haan du̱gu̱ Gerar, u̱ Ahuzza wa ya-du̱ wa u̱s-rem, u̱ Piko̱r ne̱ yu̱-Yat-ya karma wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ishaku zu̱ u̱n <<¿Rem u-yan o no̱ haatu̱n u̱ ane̱? No̱ gu̱gu̱mte̱ me̱ sok, no̱ yanu̱g me̱ du̱gu̱ dak-u no̱!>> ");
INSERT INTO gel_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","E̱ shu̱s, e̱ zu̱, <<It hyanu̱g u̱ is-u̱ it u̱zu̱ Yawe o̱ u̱r-kot u̱ bo̱ ne̱. Remu̱ iya it o̱ u̱ssa it no̱m u̱s-to̱nd su̱ same̱-du̱ u̱t-hi u̱ bo̱ ne̱, yage̱ in no̱mo̱n este̱du̱ u̱s-rem u̱ bo̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","It o̱ u̱ssa u̱zu̱ bo̱ to̱n-de̱ bo̱ za no̱mu̱ it no̱m-u̱t yo̱-to̱ da, u̱ka it no̱m-tu̱ bo̱ da. U-da u-be̱e̱t it o̱ no̱mu̱ bo̱ no̱m-u̱t so̱-to̱, it buz bo̱ du̱gu̱ dak-u it m-yar, u̱ da-o̱ it gwak-u̱t u̱ka Yawe watu̱ bo̱ kom-u so̱-o̱.>> ");
INSERT INTO gel_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Se̱ Ishaku no̱mu̱ u̱n mo̱ro̱g-du̱ este̱du̱ u̱s-rem, u̱n re̱ no̱m u̱t-re̱ u̱ no̱m-u̱t u̱t-swa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Tun u̱r-wu̱n, u̱n nom u̱s-to̱nd su̱ m-yar u̱ o̱r-u̱t u̱n ne̱, se̱ Ishaku to̱k u̱n m-mu̱, u̱n aru̱k u̱n yage̱ wa m-yar. ");
INSERT INTO gel_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","U̱ ho̱-u̱r re̱ to̱k-ne̱ Ishaku haan e̱ waru̱ wa mo̱ttu̱ du-u̱r po-de̱ du̱ e̱ kawe̱, e̱ zu̱, <<It kwu̱ng m-bu̱!>> ");
INSERT INTO gel_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Se̱ Ishaku fog dim-du̱ be-u̱r re̱ Shiba, du̱ na foge̱ du-du̱ u̱s-to̱nd u̱r-ma u̱ haan u̱ uno̱ da-o̱, iya-o̱ na fogte̱ be-u̱r re̱ Be̱rshe̱ba du̱ na foge̱ Be̱rsheba. ");
INSERT INTO gel_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Da-u̱ Isuwa o̱o̱ge̱ u̱t-shik u̱t-yu̱r (40), wa gu̱ Judit gwu̱p-u̱ Beeri ne̱t-u̱ He̱t-ne̱, tu̱msu̱ u̱ Basemat ne̱ gwu̱p-u̱ Ero̱n ne̱t-u̱ He̱t-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Se̱di ne̱ta-u̱t to̱ naknu̱ Ishaku namu̱ jab-u̱ Rebeka. ");
INSERT INTO gel_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","De̱ku̱n ho̱-de̱ da-u̱ Ishaku wu̱u̱me̱ tu̱msu̱ wa he̱e̱ste̱ m-po̱, se̱ wa fog Isuwa, mat-du̱ u-shu̱ wa, wa zu̱, <<Wa'-u̱ ri.>> Wa shu̱s wa zu̱, <<Me̱ ya.>> ");
INSERT INTO gel_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ishaku zu̱, <<U̱ da-o̱ u̱m wu̱u̱mte̱ u̱m nak ho̱-du̱ m-mar u̱ ri da. ");
INSERT INTO gel_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","U̱ da-o̱ kab ta-u ró u-por ne̱ u̱s-e̱r ne̱, bo̱ cwa u̱r-do̱g bo̱ ho̱o̱nu̱ me̱ ap-mu̱ u̱r-do̱g. ");
INSERT INTO gel_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Bo̱ no̱mu̱ me̱ no̱m u̱t-re̱ m-re̱re̱m u̱ u̱m ze̱ge̱ u̱t-cwan, bo̱ hatu̱n me̱ u̱m re̱, da-u o̱ me̱ wa'-u̱ bo̱ nu-u so̱-o̱ u̱ o̱o̱ge̱ u̱ mat-du̱ u-shu̱ kanda u̱m mar.>> ");
INSERT INTO gel_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Se̱di Rebeka o̱ u̱ ho̱g-du̱ no̱m-u̱ Ishaku o̱o̱ge̱ waru̱ wa'-u̱ wa Isuwa. Da-u Isuwa arke̱ m-cwa u̱r-do̱g u̱ sa-u̱ ap-mu̱ u̱r-do̱g, ");
INSERT INTO gel_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka zu̱ Yakubu, <<U̱m ho̱k no̱mu̱ u̱so-u ró o̱o̱ge̱ waru̱ o̱r-u̱ ró Isuwa. ");
INSERT INTO gel_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Wa zu̱ wa, <Ho̱o̱nu̱ me̱ ap-mu̱ u̱r-do̱g, bo̱ ryu̱su̱ me̱ no̱m u̱t-re̱ u̱ m-re̱re̱m da-u o̱ u̱m wa'-u̱ bo̱ nu-u so̱-o̱ Yawe m-ho̱g kanda u̱m mar.> ");
INSERT INTO gel_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","U̱ da-o̱ wa'-u̱ ri ho̱g no̱m u̱m do̱'e̱ waru̱ bo̱ u-be̱e̱t: ");
INSERT INTO gel_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","De̱'e̱ bo̱ cwa me̱n-tu̱ ban-du̱ gwaar bo̱ haatu̱n ya'ag-u̱ gwaar yu̱r. U̱m do̱'e̱ ryu̱su̱ u̱so-u ró no̱m u̱t-re̱ m-re̱re̱m u̱ wa o̱o̱ge̱ u̱t-cwan. ");
INSERT INTO gel_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Da-u o̱ bo̱ do̱'e̱ u̱ kabdu̱ no̱m u̱t-re̱ o̱ bo̱ hu̱u̱tu̱ uso-u ró wa re̱, wa wa'-u̱ bo̱ nu-u so̱-o̱ kanda wa mar.>> ");
INSERT INTO gel_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Se̱ Yakubu zu̱ Rebeka, <<Yu̱-wu̱ya ri Isuwa o̱tte̱ war u̱t-can, me̱ u̱m zatte̱ da. ");
INSERT INTO gel_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","¿A mu̱ne̱ u̱zu̱ u̱so-u̱ ri tamu̱g war-u ri? Wa do̱'e̱ u̱t-gwat u̱zu̱ u̱m o̱ u̱ssa u̱m no̱mu̱ wa u̱s-ve̱r, wa do̱'e̱ wa'-u̱ me̱ nu-u yo̱-o̱ m-ze̱g nu-u so̱-o̱.>> ");
INSERT INTO gel_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Se̱di ino-u rò zu̱ wu̱n, <<Yage̱ nu-u yo̱-o̱ mu̱u̱nu̱ me̱ wa'-u̱ ri. Bo̱ di no̱m no̱m-u̱ u̱m zu̱ bo̱, do̱'e̱ bo̱ masu̱n gwaar bo̱ hatu̱n me̱.>> ");
INSERT INTO gel_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Se̱ Yakubu do̱'e̱ wa masu̱n gwaar yu̱r, wa hatu̱n ino-u wa. Rebeka ku̱b e̱ wa do̱'e̱ wa ryu̱su̱n no̱m u̱t-re̱ m-re̱rem, u̱ka Ishaku o̱tte̱ u̱t-cwan ne̱. ");
INSERT INTO gel_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rebeka kabu̱n cwu̱-u̱t so̱-to̱ tu̱ Isuwa wa'-u̱ u̱r-taku̱n wa, tu̱ o̱o̱ge̱ u̱ku̱n u-bu, wa kabu̱n to̱ wa wa'-u̱ Yakubu du̱-fade̱ Isuwa. ");
INSERT INTO gel_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Se̱ wa ku̱b can-tu̱ u-gwaar wa wa'-u̱ Yakubu, u̱t-kom u̱ ge̱ksu̱ wa ne̱ be-tu̱ o̱o̱ge̱ za u̱t-can. ");
INSERT INTO gel_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Se̱ wa ku̱b no̱m u̱t-re̱ u̱ wu̱s u-haku̱n wa yasu̱ Yakubu u̱r-be̱re̱di ne̱ du̱ wa no̱me̱. ");
INSERT INTO gel_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakubu ku̱b no̱m u̱t-re̱ o̱ wa yasu̱ u̱so-u wa, wa zu̱ <<Uso-u ri.>> Wa shu̱s wa zu̱, <<Wa'-u̱ ri.>> Ishaku shu̱s wa zu̱, <<¿Bo̱ na zu̱ wane̱?>> ");
INSERT INTO gel_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakubu shu̱s wa zu̱, <<Me̱ wa Isuwa wa'-u̱ u̱r-taku̱n u̱ ró. U̱m no̱mu̱g u̱ka bo̱ zu̱tte̱ u̱m no̱m, ap-mu̱ u̱r-do̱g-u̱ mo̱ ya. Yu̱ne̱ u̱r-shu̱'u̱t bo̱ re̱ ko̱ bo̱ wa'-u̱ me̱ nu-u so̱-o̱.>> ");
INSERT INTO gel_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ishaku zu̱, <<Wa'-u̱ ri ¿Re̱ o̱ bo̱ kwu̱mtu̱n iya m-ho̱r m-ho̱r?>> Yakubu shu̱s wa zu̱, <<Yawe Ru̱-u ró wa no̱mu̱ me̱ u̱r-se̱ge̱ u̱m kwu̱mtu̱n.>> ");
INSERT INTO gel_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ishaku zu̱ Yakubu, <<Hane̱ u̱ kit-u̱ ri u̱m tam bo̱, u̱m nu̱pu̱t u̱zu̱ ko̱ bo̱ wa Isuwa.>> ");
INSERT INTO gel_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Se̱ Yakubu do̱'e̱ u̱ kit-u̱ u̱so-u wa. Ishaku tu̱m wu̱n, wa zu̱, <<Cwar-u Yakubu ya, se̱di u̱t-kom tu̱ Isuwa to̱.>> ");
INSERT INTO gel_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Se̱di wa kerge̱ u̱t-nap u̱zu̱ Yakubu wa da, remu̱ kom-u̱t Yakubu o̱ u̱t-can ne̱ sha-m Isuwa. Se̱ Ishaku zo̱ng wa wa'-u̱ wu̱n nu-u so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Wa shit wu̱n, <<¿Bo̱ wa u̱t-nip wa'-u̱ ri Isuwa?>> Yakubu zu̱, <<Me̱ wa.>> ");
INSERT INTO gel_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ishaku zu̱, <<Hatu̱n me̱ ap-mu̱ u̱r-do̱g u̱m tu̱ da-u o̱ se̱ u̱m wa'-u̱ bo̱ nu-u so̱-o̱.>> Se̱ Yakubu ku̱b no̱m u̱t-re̱ o̱ wa hu̱u̱tu̱ u̱so-u wa, Ishaku re̱ no̱m u̱t-re̱ o, wa so ke̱ i Yakubu hatu̱n wa. ");
INSERT INTO gel_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Se̱ Ishaku zu̱ Yakubu <<Wa'-u̱ ri, gag jab haane̱ kit-u̱ ri bo̱ ham-u̱t me̱.>> ");
INSERT INTO gel_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakubu do̱'e̱ wa ham-u̱t wu̱n. Da-u̱ Ishaku ho̱ge̱ wu̱s-u̱ kus-tu̱ war-u wu̱n, da-u o̱ wa he̱e̱se̱ wa'-u̱ wu̱n nu-u so̱-o̱, wa zu̱, <<Wu̱s-u̱ kus-tu̱ wa'-u̱ ri to̱ o̱ sha-mu̱ wu̱s-u̱ u̱r-do̱g ne̱, wu̱ Yawe wa'e̱ nu-u so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Yage̱ Ru̱-u̱ ya bo̱ u̱t-rapu̱t tu̱ do̱m u-ru̱, u̱ no̱m u̱t-kom ne̱ u-dak, yage̱ Ru̱-u̱ ya bo̱ no̱m-tu̱ u̱r-to̱m u-tát, tu̱msu̱ m-mu̱di ne̱. ");
INSERT INTO gel_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Yage̱ ne̱t-tu̱ u-dak u̱ no̱m-u̱ bo̱ m-to̱k tu̱msu̱ e̱ kwu̱ktu̱ bo̱ u̱t-jwu̱n. Bo̱ shu̱'u̱t yu̱-Yat-ya o̱r-u̱t ró ne̱, yage̱ ya'ag-u̱ ino̱ ró e̱ kwu̱ktu̱ bo̱ u̱t-jwu̱n. Ko̱wana wa'-u̱ bo̱ nu-u yo̱-o̱ yage̱ u̱ nu-u yo̱-o̱ mu u̱du̱ wa, tu̱msu̱ ko̱wana wa'-u̱ bo̱ nu-u so̱-o̱ u̱ nu-u so̱-o̱ mu u̱du̱ wa.>> ");
INSERT INTO gel_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Da-u̱ Ishaku tase̱ wa'-u̱ Yakubu nu-u so̱-o̱, ba Yakubu o̱ yage̱ u-kur du̱gu̱-du̱ u̱so-u wa, se̱ Isuwa mu̱u̱n du̱gu̱ u-sa. ");
INSERT INTO gel_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Isuwa ryu̱su̱n no̱m u̱t-re̱ m-re̱re̱m wa haatu̱n u̱so-u wa. Se̱ wa zu̱, <<U̱so-u ri, yu̱ne̱, bo̱-tu̱ ap-mu̱ u̱r-do̱g remu̱ bo̱ watu̱ me̱ nu-u so̱-o̱ ró.>> ");
INSERT INTO gel_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ishaku shit wu̱n, <<¿Bo̱ wa na zu̱ wa ne̱?>> Isuwa shu̱s wa zu̱, <<Wa'-u̱ ró wa, mat-du̱ u-shu̱ ró, Isuwa.>> ");
INSERT INTO gel_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ishaku he̱e̱se̱ zap-mu̱ namu̱ jab sok, wa zu̱, <<¿Wana haatu̱n me̱ ap-mu̱ u̱r-do̱g? U̱m taaste̱ u̱t-re̱, tu̱msu̱ u̱m wa'agu̱ wa nu-u so̱-o̱ kanda bo̱ mu̱u̱n, tu̱msu̱ za o̱ko̱n sakna o̱ wa shu̱'u̱te̱ wa nu-u so̱-o̱!>> ");
INSERT INTO gel_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Da-u̱ Isuwa ho̱ge̱ no̱mu̱ u̱so wa zu̱ye̱, se̱ wa kau̱s u-jar yu̱ u̱s-kan m-yat. Wa no̱m u̱s-ko̱n wa zu̱ u̱so-u wa, <<U̱so ri, ¿re̱-o̱ me̱ ho̱mo̱? Wa-u̱ me̱ nu-u so̱-o̱ ko̱me̱!>> ");
INSERT INTO gel_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ishaku shu̱s wa zu̱, <<Hu̱no-u ró haagu̱n u̱ ane̱, wa no̱mu̱ me̱ u̱s-ve̱r, wa o̱nkte̱ nu-u so̱-o̱ ró u-be̱e̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Isuwa zu̱, <<Rekku̱n ho̱n-ho̱n u̱ka dim-u̱r rò Yakubu, <Wa re̱-u̱ u-ra.> Remu̱ zu̱ wa e̱ngu̱sse̱ ve̱r-u̱s ri u-so u-yu̱r. U̱r-taku̱n, wa kabu̱g o̱g-du̱ mat-du̱ u-shu̱ ri, tu̱msu̱ wa ku̱b nu-u so̱-o̱ ri.>> Se̱ wa shit, <<¿Bo̱ zatte̱ nu-u so̱-o̱ u̱ bo̱ kwu̱su̱ me̱ da?>> ");
INSERT INTO gel_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ishaku shu̱s wa zu̱ Isuwa, <<Wa'-u̱ ri, u̱m wa'ag Yakubu wa shu̱'u̱t yu̱-Yat-ya ró. Tu̱msu̱ u̱m zu̱u̱g o̱r-u̱t wa ne̱ be̱e̱t e̱ do̱'e̱ u̱t-shu̱'u̱t to̱k-u̱ wa ne̱, u̱ no̱m-tu̱ u̱r-to̱m tu̱ u-tak u̱ wa ne̱, u̱ ke̱ ne̱. U̱ da-o ¿yan-o̱ u̱m do̱'e̱ no̱m-u̱ bo̱?>> ");
INSERT INTO gel_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Isuwa zu̱ u̱so wa, <<¿Bo̱ zamu̱n u̱ nu-u so̱-o̱ ko̱ u-gan da? U̱so ri, wa'-u̱ me̱ ko̱me̱ nu-u so̱-o̱!>> Isuwa ku̱st gu̱t-du̱ u̱s-kan. ");
INSERT INTO gel_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","M-vaste̱ u̱so-u rò Ishaku zu̱ wu̱n, <<Bu-u ró do̱'e̱ u̱t-shu̱'u̱t m-ra u̱ kwu̱m-tu̱ u-dak-ne̱, tu̱msu̱ o̱ do̱'e̱ u̱t-shu̱'u̱t m-ra u̱ rapu̱t ne̱ du̱gu̱ do̱m-u̱ u-ru̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Van-yu̱ m-wu̱r ró ya bo̱ do̱te̱ u̱r-yu̱, tu̱msu̱ bo̱ do̱'e̱ no̱mu̱ hu̱no̱ ró m-to̱k. Se̱di a-bo̱ o̱o̱ge̱ u̱ssa u̱ bo̱ ru du̱gu̱ m-to̱k, bo̱ keru̱ cu̱st-u̱ nom-mo̱ du̱gu̱ ge̱ksu̱ ró.>> ");
INSERT INTO gel_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Du̱gu̱ da-u o̱ Isuwa gu̱gu̱m hu̱no-u wa Yakubu, remu̱ zu̱ u̱so wa ya'aste̱ Yakubu nu-u so̱-o̱. Isuwa he̱e̱se̱ u̱s-dorog u̱zu̱, <<Da-u̱ u̱so-u ri mare̱, it taas namu̱ jab, da-u o̱ u̱m de̱ ho̱-du̱ Yakubu!>> ");
INSERT INTO gel_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Se̱di Rebeka ho̱k no̱m-u̱ Isuwa u̱t-sa u̱t-no̱m, se̱ wa-to̱m na fagnu̱ wa Yakubu wa waru̱ wa, wa zu̱, <<E̱r me̱, Isuwa wa'agu̱ jab-u̱ wa, wa no̱ng u̱s-dorog wa de̱ ho̱-du̱ bo̱. ");
INSERT INTO gel_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Wa'-u̱ ri, u̱m o̱ u̱ssa bo̱ e̱r me̱ sok. So̱m za naas u-da m-ha u̱du̱ yu̱-wu̱ya ri campa wu̱ na zu̱ye̱ Raban u̱ bo̱-u̱ Haran. ");
INSERT INTO gel_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","De̱'e̱ bo̱ shu̱'u̱t u̱ku̱n u̱ wu̱n ne̱, se̱ da-u̱ jab-u̱ hu̱no̱ ró ru̱te. ");
INSERT INTO gel_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Da-u̱ jab-u̱ wa ru̱te u̱zu̱ kaag wa u̱t-to̱ u̱ no̱m-u̱ bo̱ no̱mu̱ wa ne̱, me̱ u̱t-to̱mo̱n bo̱ mu̱u̱n. ¿Remu̱ yan-o̱ u̱m do̱te̱ u̱t-taag u̱ no̱ ne̱ be̱e̱t u̱r-ho̱ u̱r-gan?>> ");
INSERT INTO gel_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebeka zu̱ Ishaku, <<Me̱ ha u̱m zatte̱ m-yar da remu̱ ne̱ta-tu̱ He̱t tun-to̱ ne̱. U̱t-ze̱g m-ku̱k u̱zu̱ mar-to̱ u̱m mare̱ u̱ Yakubu gu̱u̱t u̱ te̱k-u̱ ne̱ta-u̱t tun-to̱.>> ");
INSERT INTO gel_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Se̱ Ishaku fog Yakubu, se̱ wa wa'-u̱ wa nu-u so̱-o̱, wa zu̱, <<A-bo̱ jaru̱n bo̱ o̱ m-ga u̱ te̱k-u̱ ne̱ta-tu̱ dak-u̱ Kan'ana tun-to̱ da. ");
INSERT INTO gel_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","De̱'e̱ u̱ dak-u̱ Padan-aram u̱ bu-u Be̱tuwe̱r, u̱so ino-u ró. Bo̱ ga waku̱n u̱ te̱k-u̱ ya-u̱t-gwu̱p Raban, yu̱-wu̱ya ino-u ró. ");
INSERT INTO gel_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Yage̱ u-Ru̱ wu̱ o̱tte̱ be̱b-du̱ ko̱-uyan be̱e̱t, wa wa'-u̱ bo̱ kom-u so̱-o̱ tu̱msu̱ bo̱ mat ya'agu̱ e̱ tu̱msu̱ yage̱ Ru̱-u̱ wa bo̱ shu̱'u̱t u̱so u̱ u̱t-dak u-tát. ");
INSERT INTO gel_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Yage̱ Ru̱-u̱ wa'-u̱ bo̱ u̱ ya'ag-u̱ ró ne̱ nu-u so̱-o̱ u̱ka wa watu̱ Ibrahi, remu̱ bo̱ reet dak-u uno̱ u̱ bo̱ o̱tte̱ shu̱'u̱t u̱ka ham-u̱t, dak-u̱ Ru̱-u̱ ya-e̱ Ibrahi.>> ");
INSERT INTO gel_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ishaku tok Yakubu wa aru̱k, se̱ wa aru̱k m-ha u̱ Padan-Aram, u̱du̱ Raban wa'-u̱ Be̱tuwe̱r ne̱t-u̱ Aram, yu̱-wu̱ya Rebeka, wu̱ o̱o̱ge̱ ino̱ Yakubu e̱ Isuwa. ");
INSERT INTO gel_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Se̱ Isuwa nu̱p u̱zu̱ u̱so-u wa Ishaku wa'agu̱ Yakubu nu-u so̱-o̱, wa tom wa m-ha u̱ Padan-Aram u̱ wa gatu̱n ne̱ta u̱ku̱n, tu̱msu̱ Ishaku nong-u̱ Yakubu u̱t-him u̱zu̱, <<A-bo̱ jaru̱n bo̱ o̱ m-ga ne̱ta ne̱ta-tu̱ Kan'ana da.>> ");
INSERT INTO gel_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Wa nu̱p tu̱msu̱ u̱zu̱ Yakubu kabu̱g him-tu̱ i matu̱ wa, Yakubu aru̱k m-ha Padan-Aram. ");
INSERT INTO gel_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Isuwa nu̱p u̱zu̱ u̱so-u wa Ishaku zaru̱ cwan-tu̱ ne̱ta-tu̱ Kan'ana da. ");
INSERT INTO gel_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Se̱ Isuwa do̱'e̱ u̱du̱ Ismaru wa gaan Maharat, Maharat wa o̱ hu̱no-u Nebayo̱t u̱ gwu̱p-u̱ Ismaru ne̱ wa'-u̱ Ibrahi, u̱r-dame̱ ne̱ta-tu̱ wa ba-e̱ m-gaan u̱r-taku̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakubu yage̱ bo̱-u̱ Be̱rshe̱ba wa do̱'e̱ Haran. ");
INSERT INTO gel_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Da-u̱ wa teye̱ de̱ku̱n be-de̱, wa ees remu̱ zu̱ gyu̱p-mu̱ no̱mu̱g ho̱-du̱ he̱e̱g. Se̱ wa ku̱b u̱r-ta'ar, wa peg u̱r-hi wa ru̱t u̱ wa roogte̱. ");
INSERT INTO gel_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","M-gyu̱p wa o̱ u̱ te̱k m-roog, se̱ wa hyu̱n u-kan du̱gu̱ u-dak m-da u̱ do̱m u-ru̱, se̱ wa hyen a-to̱m u-Ru̱ e̱ o̱ u̱r-da u̱-cu̱zu̱n u̱-do̱m u-kan. ");
INSERT INTO gel_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Se̱ wa hyen Yawe u̱ ees u̱-do̱m u-kan, se̱ wa zu̱, <<Me̱ wa Yawe, Ru̱-u̱ u̱so-u̱ u̱so no̱ Ibrahi, tu̱msu̱ Ru̱-u̱ u̱so-u no̱ Ishaku. Dak-u̱ no̱ o̱tte̱ m-ru̱t o̱, u̱m o̱ ya-du̱ o̱ u̱du̱ ró u̱ ya'ag-u̱ ró ne̱. ");
INSERT INTO gel_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Yaag-u̱ ró do̱'e̱ u̱t-shu̱'u̱t u-tát ba huug-mu̱ u-dak, no̱ do̱'e̱ u̱t-bu̱ru̱g u-do̱m u-ta ne̱, tu̱msu̱ no̱ do̱'e̱ u̱t-bu̱ru̱g kom-u̱ u̱t-cwa u̱ kom u̱r-beer ne̱. Tu̱msu̱ du̱gu̱-du̱ ró u̱ ya'ag-u̱ ró de̱ u-dak u-be̱e̱t e̱ do̱te̱ kwu̱m-du̱ kom-u so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","U̱m o̱ u̱r-kot u̱ bo̱ ne̱ me̱ u̱t-gwat bo̱ ko̱he̱ne̱ o̱ bo̱ o̱tte̱ m-ha. Tu̱msu̱ me̱ mu̱u̱tu̱n bo̱ u̱ uno̱ dak-o̱. U̱m da yaag-u̱ bo̱ da se̱ u̱m taaste̱ ya-du̱ bo̱ u̱t-no̱m u̱t-be̱e̱t tu̱ u̱m no̱mu̱ bo̱ este̱du̱ u̱s-rem su̱ u̱m no̱mu̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Da-u̱ Yakubu yu̱ne̱ du̱gu̱ m-roog, wa zu̱, <<Nip-to̱ Yawe o̱ro u̱ be-u̱r rin-de̱, se̱di u̱m nak da.>> ");
INSERT INTO gel_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Se̱di wa o̱ u̱ ho̱g-du̱ u-gye̱r, wa zu̱, <<Be-u̱r rin-de̱ o̱ u-gye̱r ne̱, za u-sakna be-u̱r rin-de̱ bu-u̱ u-Ru̱ o̱, is-yu̱ cwa-du̱ do̱m u-Ru̱.>> ");
INSERT INTO gel_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Tun u̱r-wu̱n Yakubu ku̱b ta'ar-du̱ wa pegte̱ u̱r-hi, wa yu̱nu̱s de̱ m-kim u̱ka ta'ar-du̱ u̱t-hu̱ktin wa da'as m-no̱o̱g u̱ do̱m-u̱ de̱. ");
INSERT INTO gel_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Wa fog dim-du̱ be-u̱r re̱ Be̱te̱r (du̱ na foge̱ <<bu-u̱ u-Ru̱>>) na o̱o̱g m-fag be-u̱r re̱ bo̱-u̱ Ruz. ");
INSERT INTO gel_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Se̱ Yakubu no̱m u̱s-to̱nd, wa zu̱, <<Abite̱ u̱zu̱ Ru̱-u̱ o̱ u̱r-kot ne̱, tu̱msu̱ wa u̱t-gwat me̱ u̱ ha-mu̱ u̱m o̱tte̱, tu̱msu̱ wa ya' me̱ no̱m u̱t-re̱ u̱ cwu̱-tu̱ m-wa ne̱, ");
INSERT INTO gel_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","A u̱m mu̱ne̱ m-yar u̱ bu-u̱ u̱so-u ri, Yawe u̱t-shu̱'u̱t Ru̱-u ri. ");
INSERT INTO gel_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Tu̱msu̱ din-de̱ ta'ar-de̱ du̱ u̱m yu̱nse̱ m-kim be-u̱r re̱ u̱t-shu̱'u̱t be-du̱ u̱t-huuk, me̱ u̱t-ya u-Ru̱ u̱t-ho̱ o̱p no̱m-u̱ wa ya' me̱ u-be̱e̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakubu re̱ u-shu̱ u̱ ha-m wa ne̱ wa te dak-u̱ ne̱t-tu̱ u-do̱m. ");
INSERT INTO gel_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Wa hyu̱n u̱r-du du̱ m-bu̱ du̱gu̱ m-ra, u̱ ban-tu̱ ca u̱ gwaar ne̱ u̱t-tu̱t e̱ o̱ ru̱ku̱sse̱ u̱ dapu̱s u̱r-du, e̱ o̱ u̱r-e' na ya' e̱ m-bu̱ e̱ swa, se̱di damra u-ta'ar o̱ na zwapte̱ nu-u̱ du-u̱r re̱. ");
INSERT INTO gel_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Da-u̱ ca karge̱ be̱e̱t u̱ku̱n, a-gwat-du̱ ca ne̱ karu̱g be̱e̱t da-u o̱ e̱ haste̱ u̱r-ta'ar du̱gu̱ nu-u̱ u̱r-du e̱ yu̱ ban-tu̱ ca e̱ m-bu̱ e̱ so, da-u o̱ tu̱msu̱ e̱ karge̱ e̱ muut ta'ar-u̱r re̱ u̱ nu-u̱ u̱r-du e̱ tage̱. ");
INSERT INTO gel_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakubu do̱'e̱ u̱du̱ a-gwat-du̱ ca ne̱ wa shit, <<Hu̱u̱b-u̱t ri, ¿du̱gu̱ he̱ no̱ rwu̱ne̱?>> E̱ zu̱ wu̱n, <<It rwu̱gu̱n du̱gu̱ Haran.>> ");
INSERT INTO gel_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Wa zu̱ e̱, <<¿No̱ nak waku̱n wu̱na zu̱ye̱ Raban, wa'-u̱ Be̱tuwe̱r, wa'-u̱ Naho̱r?>> U̱n zu̱ wa, <<It nak wa.>> ");
INSERT INTO gel_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yakubu zu̱ u̱n, <<¿Wa o̱ m-yar?>> Se̱ u̱n zu̱ wa, <<Wa o̱ m-yar, gwu̱p-u̱ wa Rahira ya jit u̱ daan u̱ ban-du̱ ca ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakubu zu̱, <<Ho̱-du̱ o̱mo̱n teeg da-u̱ kargu̱sse̱ ban-tu̱ ca da. Ya ca m-bu̱ bo̱ muut e̱ u̱du̱ u̱t-re̱e̱g.>> ");
INSERT INTO gel_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Se̱ u̱n zu̱ wa, <<It zaar u̱t-kere̱ da se̱ ban-tu̱ ca karu̱gte̱ u̱t-be̱e̱t na hast u̱r-ta'ar du̱gu̱ nu-u̱ u̱r-du. Da-u o̱ it do̱'e̱ u̱ ya-du̱ ca m-bu̱.>> ");
INSERT INTO gel_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakubu o̱ te̱k-u̱ no̱mu̱ u̱n u̱s-rem se̱ Rahira teen u̱ ban-du̱ ca du̱ u̱so-u wa ne̱, wu̱na gote̱ ca e̱. ");
INSERT INTO gel_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Da-u̱ Yakubu hyane̱ Rahira gwu̱p-u̱ Raban, yu̱-wu̱ya ino̱-u wa, u̱ ban-du̱ ca Raban ne̱ wa do̱'e̱ wa hast u̱r-ta'ar du̱gu̱ nu-u u̱r-du wa yu̱' ca yu̱-wu̱ya ino̱-u wa m-bu̱. ");
INSERT INTO gel_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Se̱ Yakubu ham-u̱t Rahira, wa ku̱st gu̱t-du̱ u̱s-kan su̱ u̱r-so̱. ");
INSERT INTO gel_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakubu tamu̱g waru̱ Rahira u̱zu̱, <<Me̱ du̱gu̱ ko̱-du̱ u̱so-u ró de̱, Rebeka wa matu̱ me̱.>> Se̱ wa ku̱su̱m m-so̱m wa waru̱ u̱so-u wa. ");
INSERT INTO gel_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Da-u̱ Raban ho̱ge̱ u̱zu̱ Yakubu, wa'-u̱ du̱-dim-u̱ wa tegen, wa ku̱su̱m m-so̱m wa bit wa. Se̱ wa shipis wa, wa ham-u̱t wu̱n tu̱msu̱ wa mu̱u̱tu̱n wa u-bu. Se̱ Yakubu waru̱ wu̱n no̱mu̱ no̱me̱ u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Raban zu̱ wu̱n, <<Nip-to̱, war-u ri bo̱ o̱o̱ge̱ u̱ hyu̱-m ri ne̱.>> Yakubu shu̱'u̱t u̱ku̱n u-pyat u-gan. ");
INSERT INTO gel_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Raban zu̱ Yakubu, <<Remu̱ zu̱ bo̱ wa ko̱-u̱r ri wa bo̱ o̱ye̱, bo̱ za no̱mu̱ me̱ m-to̱k za u-top da. Waru̱ me̱ no̱mu̱ u̱m do̱'e̱ to̱p-du̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Raban o̱tte̱ ya-u̱t-gwu̱p yu̱r, yu̱ wu̱ya na zu̱ wa Riya, yu̱ dim tu̱msu̱ na zu̱ wa Rahira. ");
INSERT INTO gel_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Riya zatte̱ is-u̱t so̱-to̱ so̱k da, se̱di Rahira o̱tte̱ shu̱-u so̱-o̱ u̱ war-u so̱-o̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakubu o̱ u̱t-cwan e̱ Rahira, wa waru̱ u̱so wa, u̱zu̱, <<Abite̱ bo̱ ya'u̱ me̱ Rahira, gwu̱p-u̱ re̱k-wa ró wa shu̱'u̱t ne̱ta ri, me̱ no̱m-u̱ bo̱ m-to̱k u̱s-hak u̱s-ta'er.>> ");
INSERT INTO gel_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Raban zu̱, <<U̱m eeste̱, u̱m yasu̱ bo̱ Rahira du̱ u̱m ya'aste̱ waku̱n Rahira. Bo̱ shu̱'u̱t u̱ ane̱ u̱ me̱ ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yakubu nom go̱ro̱m u̱s-hak u̱s-ta'er remu̱ wa gu̱u̱t Rahira. Se̱di hak-u̱s se̱ wa hyen se̱ cashi remu̱ cwan-tu̱ wa o̱tte̱ Rahira. ");
INSERT INTO gel_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Se̱ Yakubu zu̱ Raban, <<Ya me̱ ne̱ta ri, remu̱ zu̱ hak-su̱ go̱rmu̱ ri taag, u̱m o̱ u̱ssa u̱m ga Rahira u̱ da-o̱.>> ");
INSERT INTO gel_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Raban kargu̱sse̱ a-u̱s-bo̱r-u̱ wa ne̱, wa bu̱n mo̱ro̱g-du̱ gag-du̱ u̱r-gu̱ du̱ re̱-du̱ no̱m u̱t-re̱. ");
INSERT INTO gel_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Se̱di da-u̱ gyu̱p-mu̱ no̱me̱ Raban ku̱b Riya wa hu̱u̱tu̱ Yakubu, wa roog u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Raban yase̱ gwu̱p-u̱ wa-m-to̱k-u̱ wa Zirpa u̱du̱ gwu̱p-u̱ wa Riya wa shu̱'u̱t wa-m-to̱k-u̱ wa.) ");
INSERT INTO gel_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Se̱di da-u̱ Yakubu yu̱ne̱ u̱r-wu̱n se̱ wa hyen Riya! Wa zu̱ Raban, <<¿Yan-o̱ bo̱ no̱mu̱ me̱ inya? ¿U̱m no̱ng m-to̱k u̱ remu̱ Rahira, ko̱ iya o̱ da? ¿Rem-u yan-o̱ bo̱ no̱m-tu̱ me̱ u̱s-bi?>> ");
INSERT INTO gel_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Raban zu̱, <<U̱r-ma it ho̱n-ho̱n o̱ da, u̱ du̱-dim-u̱ gwu̱p wa ba yu̱-wu̱ya m-ha u̱r-gu̱ da. ");
INSERT INTO gel_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Yage̱ ho̱-tu̱ u̱t-ta'er tu̱ po-mu̱ u̱r-gu̱ u̱ aru̱k, it do̱'e̱ ya'u̱ bo̱ Rahira tu̱msu̱, se̱di se̱ bo̱ swu̱ru̱g m-no̱m u̱s-hak u̱s-ta'er su̱ go̱ro̱m.>> ");
INSERT INTO gel_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakubu ees wa sur se̱ku̱n hak-se̱ u̱s-ta'er. Da-u̱ roog-mu̱ u̱t-ta'er mu̱ e̱ nomte̱ u̱r-gu̱ e̱ Riya arke̱, Raban yasu̱ wu̱n Rahira tu̱msu̱. ");
INSERT INTO gel_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Raban yase̱ gwu̱p-u̱ wa-m-to̱k-u̱ wa Biru̱ha u̱du̱ gwu̱p-u̱ wa Rahira wa shu̱'u̱t wa-m-to̱k-u̱ wa.) ");
INSERT INTO gel_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakubu roog tu̱msu̱ u̱ Rahira ne̱. Wa cwanu̱g Rahira m-ze̱g Riya. Se̱di wa sur m-no̱mu̱ Raban m-to̱k u̱s-hak u̱s-ta'er. ");
INSERT INTO gel_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Da-u̱ Yawe hyane̱ Yakubu cwanu̱g Rahira m-ze̱g Riya, se̱ wa yu̱' wa mat-du̱ yaag, se̱di Rahira kwu̱ng u̱r-mat da. ");
INSERT INTO gel_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Se̱ Riya no̱m u̱t-me̱n wa mu̱t ya-du̱ u̱r-campa. Se̱ wa te̱'e̱ wa u̱r-dim Rube̱n, no̱mu̱ na zu̱ye̱ dim-u̱r re̱ u̱ rem-du̱ u̱t-Ibra-ne̱, gwat, u̱r-ya. Riya zu̱u̱g, <<Remu̱ u̱zu̱ Yawe gwak-u̱t swadu̱ u̱r-ko̱b-u̱ ri. Za u-sakna campa ri u̱t-cwan me̱ u̱ da-o̱.>> ");
INSERT INTO gel_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Wa sur m-no̱m u̱t-me̱n tu̱msu̱ wa kum de̱ku̱n ya-du̱ u̱r-campa de̱, wa te̱'e̱ wa u̱r-dim Simiyo̱n, u̱ka na fogte̱ dim-u̱r re̱ na zu̱, <<Yawe hokos.>> Se̱ wa zu̱, <<Yawe ho̱k u̱zu̱ na cwanu̱g me̱ sok da se̱ wa sur m-ya me̱ de̱ku̱n ya-du̱ u̱r-campa de̱.>> ");
INSERT INTO gel_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Se̱ wa sur m-no̱m u̱t-me̱n, da-u̱ wa mate̱ ya-du̱ u̱r-campa, wa zu̱, <<U̱ da-o̱ u̱m nak u̱zu̱ campa ri u̱ dapu̱rse̱ me̱, remu̱ u̱m maktu̱ wa ya'ag-u̱ campa-ne̱ tu̱t.>> Se̱ wa te̱'e̱ wa u̱r-dim Re̱wi u̱ka na fogte̱ dim-u̱r re̱ u̱ rem-du̱ u̱t-Ibra-ne̱ na zu̱, <<u̱t-same̱ u̱r-be u̱r-gan.>> ");
INSERT INTO gel_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Tu̱msu̱ Riya sur m-no̱m me̱n-tu̱ ub wa mu̱t de̱ku̱n ya-du̱ u̱r-campa de̱. Wa wa'-u̱ wa u̱r-dim Yahuda, haka na fu̱kte̱ dim-u̱r re na zu̱ de̱ <<U̱t-vam.>> Wu̱n zu̱, <<U̱ da-o̱ me̱ no̱me̱ Yawe u̱t-vam.>> Se̱ Riya te̱'e̱ wu̱n u̱r-dim Yahuda. Se̱ Riya yage̱ mat-du̱ yaag. ");
INSERT INTO gel_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Da-u̱ Rahira hyane̱ wa maktu̱ Yakubu ya'ag da, wa hu̱ shu̱b-du̱ yu̱-wu̱ya wa. Wa kon Yakubu wa zu̱, <<Ya me̱ yaag ko̱ u̱m mar!>> ");
INSERT INTO gel_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakubu ho̱g u̱s-ryab, wa zu̱ Rahira, <<¿Me̱ wa u-Ru̱, wu̱ hose̱ bo̱ u̱r-mat-du̱ yaag?>> ");
INSERT INTO gel_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rahira zu̱, <<Kab Biru̱ha to̱k-u̱ ri, no̱ wa ne̱ roog ko̱ wa matu̱ me̱ yaag ko̱me̱ u̱t-kwu̱m yaag du̱gu̱-du̱ wa.>> ");
INSERT INTO gel_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Se̱ wa yasu̱ wa Biru̱ha to̱k-u̱ wa u̱ wa shu̱'u̱t ne̱ta wa, Yakubu roog u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Biru̱ha nom me̱n-tu̱ ub wa matu̱ Yakubu ya-du̱ u̱r-campa. ");
INSERT INTO gel_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rahira zu̱, <<Ru̱-u̱ no̱ngu̱ me̱ kwu̱p-du̱ u̱s-rem su̱ so̱-se̱ wa ho̱k kan-u̱s ri wa ye me̱ u̱r-ya du̱ u̱r-campa.>> Se̱ wa te̱'e̱ wa u̱r-dim Dan, no̱m-u̱ na zu̱ye̱ dim-u̱r re̱ u̱ rem-du̱ u̱t-Ibra-ne̱ na zu̱ <<kwu̱p-du̱ u̱s-rem ho̱n-ho̱n.>> ");
INSERT INTO gel_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rahira to̱k-u̱ Biru̱ha nom u̱t-me̱n u-yu̱ru̱mse̱ wa matu̱ Yakubu ya-du̱ u̱r-campa. ");
INSERT INTO gel_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Se̱ Rahira zu̱, <<U̱m no̱ng u̱t-noos so̱k u̱ yu̱-wu̱ya ri ne̱, u̱m re̱e̱g m-gag.>> Se̱ wa te̱'e̱ ya-u̱r re̱ u̱r-dim Napari u̱ka na fogte̱ dim-u̱r re u̱ rem-du̱ u̱t-Ibra-ne̱ na zu̱ <<u̱t-noos.>> ");
INSERT INTO gel_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Da-u̱ Riya hyane̱ wa yakke̱ u̱r-mat, wa ku̱b to̱k-u̱ wa Zirpa, wa yasu̱ Yakubu wa shu̱'u̱t ne̱ta wa. ");
INSERT INTO gel_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Riya to̱k-u̱ Zirpa matu̱ Yakubu ya-du̱ u̱r-campa. ");
INSERT INTO gel_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Se̱ Riya te̱'e̱ wa u̱r-dim Gad, dim-u̱r re̱ na zu̱ye̱ <<Re̱ u̱r-ko̱rro̱,>> remu̱ zu̱ wa zu̱u̱g, <<U̱m re̱e̱g u̱r-ko̱rro̱!>> ");
INSERT INTO gel_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Riya to̱k-u̱ Zirpa matu̱ Yakubu ya-du̱ u̱r-campa du̱ u-yu̱ru̱mse̱. ");
INSERT INTO gel_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Se̱ Riya zu̱, <<Me̱ wa u̱r-so̱ wa m-o̱ge̱, ne̱ta-ne̱ do̱'e̱ fag-du̱ me̱ u̱r-so̱.>> Wa te̱'e̱ wa u̱r-dim Ashu̱r, no̱mu̱ na zu̱ye̱ Ashu̱r <<U̱r-so̱.>> ");
INSERT INTO gel_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Da-u̱ gos-mu̱ fat no̱me̱, se̱ Rube̱n to u̱r-do̱g wa kwu̱mu̱n u̱s-baat su̱ kab-du̱ u̱t-me̱n su̱ cwu̱u̱ne̱ wa ge̱tu̱n se̱ wa mu̱tu̱n ino-u wa Riya. Se̱ Rahira ko̱n Riya wa zu̱, <<Gag jab, ya me̱ baat-su̱ kab-du̱ u̱t-me̱n su̱ zwaru̱ ró getnu̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Se̱di Riya zu̱ wu̱n, <<¿No̱m-u̱ bo̱ no̱mu̱ me̱ u-be̱e̱t u̱ bo̱ o̱nkte̱ me̱ campa o̱ ko̱rge̱ bo̱ da? ¿U̱ da-o̱ tu̱msu̱ bo̱ u̱t-sa bo̱ o̱nk baat-su̱ zwaru̱ ri mu̱tu̱n me̱ tu̱msu̱?>> Rahira zu̱, <<U̱ gyu̱p-mu̱ ya-o̱ me̱ zu̱ campa ri u̱ roog u̱ bo̱ ne̱ abite̱ u̱zu̱ bo̱ ya me̱ baat-su̱ kab-du̱ u̱t-me̱n su̱ zwaru̱ ró saannu̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","U̱ ho̱-u̱r re̱ m-rim, da-u̱ Yakubu o̱o̱ge̱ mu̱u̱n du̱gu̱ u-tak, se̱ Riya do̱'e̱ wa bit wa. Riya zu̱ Yakubu, <<Se̱ bo̱ roogte̱ me̱ ne̱ u̱ ya-o̱ m-gyu̱p, u̱m ooste̱ bo̱ u̱ baat-su̱ kab-du̱ u̱t-me̱n su̱ zwaru̱ ri sanu̱ me̱.>> Se̱ u̱ gyu̱p-m mo̱ wa roog u̱ Riya ne̱. ");
INSERT INTO gel_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ru̱-u̱ o̱nk to̱o̱g-u̱s Riya, wa no̱m me̱n-tu̱ ub. Wa matu̱ Yakubu ya-du̱ u̱r-campa du̱ u̱r-tanu̱rse̱. ");
INSERT INTO gel_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Se̱ Riya zu̱, <<Ru̱-u̱ yaag me̱ o̱g-u̱r so̱-de̱ remu̱ u̱m ya'aste̱ campa ri gwu̱p m-to̱k-u̱ ri.>> Se̱ wa te̱'e̱ wa u̱r-dim Issakar, no̱m-u̱ na fu̱ge̱ dim-u̱r re̱ u̱ rem-du̱ u̱t-Ibra-ne̱ <<u-to̱p.>> ");
INSERT INTO gel_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Riya sur m-no̱m me̱n-tu̱ ub wa matu̱ Yakubu ya-du̱ u̱r-campa du̱ u-shishin. ");
INSERT INTO gel_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Riya zu̱, <<Ru̱-u̱ no̱ngu̱ me̱ nya-u so̱-o̱, uno̱ da-o̱ campa ri ya'u̱ me̱ m-ze̱g, remu̱ zu̱ u̱m maktu̱ wa ya'ag-u̱ campa-ne̱ shishin.>> Wa te̱'e̱ wa u̱r-dim Ze̱burun. No̱m-u̱ na zu̱ Ze̱be̱run o̱ <<m-ze̱g.>> ");
INSERT INTO gel_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Da-u̱ wa sure̱ m-mat ya-du̱ u̱r-gwu̱p wa te̱'e̱ de̱ u̱r-dim Dinatu. ");
INSERT INTO gel_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Se̱ Ru̱-u̱ baku̱s u̱ Rahira ne̱, wa e̱r ko̱n-u̱s wa se̱ wa yu̱ wa u̱r-mat. ");
INSERT INTO gel_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Wa no̱m u̱t-me̱n wa mu̱t ya-du̱ u̱r-campa. Wa zu̱, <<Ru̱-u̱ haste̱ me̱ m-'e̱.>> ");
INSERT INTO gel_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Se̱ Rahira te̱'e̱ wa u̱r-dim Yusuhu, no̱m-u̱ na zu̱ dim-u̱r re̱ m-swu̱r, remu̱ zu̱ wu̱n zu̱u̱g, <<Yawe swu̱ru̱ wu̱n de̱ku̱n ya-de̱ bu-u ri.>> ");
INSERT INTO gel_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Da-u̱ Rahira mate̱ Yusuhu, Yakubu zu̱ Raban, <<U̱m o̱ u̱ssa bo̱ yagu̱ iya u̱m u̱t-sa u̱m mu u̱ dak-u ri iya. ");
INSERT INTO gel_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ya me̱ ya'ag-u̱ ri u̱ ne̱ta-u̱t ri ne̱, i u̱m no̱m-tu̱ bo̱ m-to̱k, u̱m u̱t-sa u̱m mu, bo̱ nak tat-u̱ m-ank mu̱ u̱m no̱m-u̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Raban zu̱ wu̱n, <<A u̱m kume̱ hyu̱-m pusmo̱ u̱du̱ ró, gag jab e̱r me̱, u̱m shu̱'u̱te̱ wa no̱m u̱t-kom so̱k, u̱m nak du̱gu̱ u-gwat u̱zu̱ Yawe wa'agu̱ me̱ kom-u so̱-o̱ u̱ rem-u ró. ");
INSERT INTO gel_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Waru̱ me̱ no̱m-u̱ bo̱ doru̱ me̱, me̱ to̱p-u̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakubu zu̱ wu̱n, <<Bo̱ nak u̱zu̱ u̱m nong-u̱ bo̱ m-to̱k, bo̱ nak u̱ka bisa-u̱t ró surte̱ u̱ kom-u̱t ri. ");
INSERT INTO gel_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Bisa-u̱t ró o̱o̱g cashi kanda u̱m haan, se̱di no̱m u̱t-kom-u̱ ró swu̱ru̱g u-tát sok. Yawe wa'agu̱ bo̱ kom-u so̱-o̱ u̱ ko̱-uyan u̱m no̱me̱ u-be̱e̱t. ¿Se̱di u̱ da-o̱, re̱ne̱ o̱ me̱? ¿Mu̱ne̱ o̱ u̱m do̱'e̱ he̱e̱se̱ cu̱n-du̱ o̱kon remu̱ ya'ag-u̱ ri?>> ");
INSERT INTO gel_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Raban shit Yakubu, <<¿Yan-o̱ u̱m do̱'e̱ ya-du̱ bo̱?>> Yakubu shu̱s wa zu̱, <<A-bo̱ ya me̱ o̱ko̱n no̱m-o̱ da. Se̱di abite̱ u̱zu̱ bo̱ no̱m-u̱ me̱ u-no̱m u-gan, me̱ u̱t-re̱ u-shu̱ u̱ gwat-du̱ ban-tu̱ ca ró: ");
INSERT INTO gel_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Yage̱ u̱m cwa ban-tu̱ u̱t-bisa ró u̱ ya-o̱, u̱m hast ca u̱ gwaar ne̱ i o̱tte̱ daku̱r-u̱t rim-to̱, u̱ same̱ u̱ ya-tu̱ kag-u̱ ca ne̱ tu̱ o̱o̱ge̱ rim-to̱ u̱t-be̱e̱t. Bo̱ ya me̱ to̱ u̱t-be̱e̱t e̱ shu̱'u̱t o̱g-du̱ m-ank-u̱ ri. ");
INSERT INTO gel_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","U̱ ane̱ u-shu̱, a-bo̱ gwate̱ bisa-tu̱ bo̱ ya'u̱ me̱ to̱ shu̱'u̱t o̱g-u̱r ri, bo̱ u̱t-kere̱ u̱t-nap u̱zu̱ me̱ wa-u̱t-nip wa. Abite̱ u̱zu̱ bo̱ hyanu̱g gwaar i zatte̱ u̱t-daku̱r da ko̱ kag-u̱ ca i za rim-e̱ da, bo̱ nak u̱zu̱ hiw-to̱ u̱m hiwe̱ du̱gu̱-du̱ ró.>> ");
INSERT INTO gel_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Raban zu̱, <<Yage̱ u̱ shu̱'u̱t u̱ka bo̱ zu̱tte̱.>> ");
INSERT INTO gel_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","U̱ gandi ho̱-u̱r re̱ Raban hast gob-u̱ gwaar e̱ o̱tte̱ u̱s-ker u̱t-daku̱r ne̱, u̱ so-u̱ gwaar ne̱ be̱e̱t i o̱tte̱ u̱t-daku̱r ko̱ daku̱r-u̱t pus-to̱ ne̱, u̱ kag-u̱ ca rim-e̱ ne̱ be̱e̱t, wa yasu̱ ya'ag-u̱ wa e̱ ha u̱t-gwat. ");
INSERT INTO gel_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Se̱ Raban ku̱b u̱t-bisa wa no̱m ha-mu̱ m-roog u̱t-tu̱t, rem u̱zu̱ wa o̱ u̱ssa wa no̱m m-ra u̱ Yakubu ne̱, Yakubu re̱ u-shu̱ u̱ gwat-du̱ ban-du̱ u̱t-bisa Raban tu̱ kuse̱. ");
INSERT INTO gel_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Se̱ Yakubu ge̱tu̱n fe̱-su̱ tesu̱ po̱pra u̱ te-yu̱ armo̱m ne̱ u̱ te̱-yu̱ pe̱re̱n ne̱, wa nyu̱u̱k kwu̱k-tu̱ do̱m, wa yage̱ me̱r-du̱ u-te u̱ pus-de̱. ");
INSERT INTO gel_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Wa ku̱b fe̱-su̱ u̱s-te̱ se̱ wa guns be-du̱ ban-du̱ bisa-u̱t sote̱ m-bu̱, remu̱ zu̱ ku̱na e̱ nom-tu̱ u̱s-naar da-u̱ e̱ haane̱ u̱ swadu̱ m-bu̱. ");
INSERT INTO gel_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Da-u̱ e̱ no̱me̱ u̱s-naar u-shu̱ fe̱-su̱ u̱s-te̱ su̱ pusse̱ se̱, e̱ mu̱t yaag i o̱tte̱ u̱s-ke̱r u̱t-daku̱r ne̱ u̱ war-u̱t e̱. ");
INSERT INTO gel_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakubu hast kag-u̱ ca e̱ du̱gu̱ ban-du̱ ca Raban, da-u̱ e̱ o̱ u̱s-naar se̱ wa muut e̱ m-gwat bisa-u̱t Raban tu̱ o̱o̱ge̱ u̱ daku̱r-u̱t rim-to̱ ne̱. Iya-o̱ wa nomte̱ u̱t-bisa wa reet u-shu̱, wa ku̱ngu̱sse̱ bisa-u̱t wa du̱gu̱-du̱ bisa-u̱t Raban. ");
INSERT INTO gel_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Da-u̱ bisa-tu̱ zege̱ m-yar o̱ u̱s-naar, se̱ Yakubu ru̱st fe̱-su̱ te-u̱s se̱ su̱ wa ku̱na u̱-shu̱ ban-du̱ bisa-u̱t to̱. Remu̱ e̱ no̱m-u̱t u̱s-naar u̱-shu̱ fe̱-su̱ te-u̱s se̱. ");
INSERT INTO gel_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Se̱di wa no̱m-u̱t iya u̱ i o̱o̱ge̱ za m-yar da. Ban-du̱ u̱t-bisa tu̱ zatte̱ u̱r-be̱b so̱k da e̱ muus u̱du̱ Raban, i o̱o̱ge̱ u̱r-be̱b e̱ muus u̱du̱ Yakubu. ");
INSERT INTO gel_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Iya-o̱ hen, Yakubu kumte̱ re̱-u̱ u-shu̱ so̱k, wa kum ban-du̱ u̱t-bisa u̱ gwaar ne̱ u-tát, u̱ to̱k-ne̱ campa-ne̱ u̱ to̱k-ne̱ ne̱ta-ne̱, u̱ rakum ne̱ u̱ janka ne̱. ");
INSERT INTO gel_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakubu ho̱k ya'ag-u̱ campa-ne̱ Raban u̱s-rem u̱zu̱, <<Yakubu kooste̱ no̱mu̱ u̱so-u in o̱tte̱ u-be̱e̱t tu̱msu̱ wa kwu̱mu̱g no̱m u̱t-kom uno̱ u-be̱e̱t du̱gu̱ no̱m-tu̱ o̱o̱ge̱ tu̱ uso-u in.>> ");
INSERT INTO gel_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakubu hyen u̱zu̱ jab-u̱ Raban zamu̱n u̱ wa ne̱ u̱ka o̱tte̱ da. ");
INSERT INTO gel_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Se̱ Yawe zu̱ Yakubu, <<Barme̱ m-mu̱ u̱ dak-u̱ u̱so-u ró u̱ bu-u wa ne̱, me̱ u̱t-no̱m u̱r-kot u̱ bo̱ ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Se̱ Yakubu fog Riya e̱ Rahira e̱ haan u̱r-do̱g u̱ be-du̱ wa o̱tte̱ u̱ gwat-du̱ ban-du̱ bisa-u̱t wa. ");
INSERT INTO gel_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Wa zu̱ e̱, <<U̱m hyanu̱g jab-u̱ u̱so-u no̱ o̱ zamu̱n u̱ka it u̱ wa ne̱ o̱tte̱ da, se̱di Ru̱-u̱ u̱so-u ri o̱ u̱r-kot u̱-me̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","No̱ nak u̱ka u̱m nomte̱ u̱so-u no̱ m-to̱k u̱ be̱b-du̱ war-u̱ ri ne̱ u̱r-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Se̱di wa no̱ngu̱ me̱ no̱m-u yo̱-o̱, wa swaske̱ o̱g-u̱r ri u̱so u-o̱p. Se̱di Ru̱-u̱ yaag wu̱n fu̱n-yu̱ wa do̱te̱ u̱ ho̱n-su̱ me̱ da. ");
INSERT INTO gel_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","A wa zu̱ye̱, <Gwaar i u̱t-kaap e̱ o̱o̱ge̱ i ri,> se̱ gwaar be̱e̱t e̱ ha mat-du̱ yaag u̱t-kaap ne̱. Tu̱msu̱ a wa swase̱ jab-u̱ wa u̱zu̱, <Gwaar i u̱s-ker u̱s-ker e̱ o̱o̱ge̱ o̱g-u̱r rò,> se̱ ban-du̱ gwaar be̱e̱t e̱ ha mat-du̱ yaag u̱s-ker u̱s-ker. ");
INSERT INTO gel_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Iya o Ru̱-u̱ nomte̱, wa ku̱b bisa-tu̱ u̱so-u no̱, wa yasu̱ me̱. ");
INSERT INTO gel_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","<<Da-u̱ kab-du̱ u̱t-me̱n u̱ ban-du̱ u̱t-bisa no̱me̱, u̱m no̱mu̱g bo'. U̱m hyen gob-u̱ gwaar e̱ o̱ u̱s-naar u̱ so̱-yu̱ u-gwaar ne̱ e̱ o̱ u̱s-ker u̱s-ker, ko̱ u̱t-daku̱r, ko̱ u̱t-kaap ne̱. ");
INSERT INTO gel_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Se̱ bo' u̱m no̱me̱, Wa-to̱m u-Ru̱ zu̱ me̱, <Yakubu!> se̱ u̱m zu̱ wa <Me̱ ya.> ");
INSERT INTO gel_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Wa-to̱m-u-Ru̱ zu̱ me̱, <Gwat, bo̱ hyan gob-u̱ gwaar i o̱o̱ge̱ u̱s-naar ban-du̱ u̱t-bisa i o̱ u̱s-ker u̱s-ker, ko̱ u̱t-daku̱r, ko̱ u̱t-kaap ne̱, remu̱ zu̱ u̱m hyanu̱g no̱m-u̱ Raban o̱o̱ge̱ no̱m-u̱ bo̱ u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Me̱ o̱o̱ge̱ u-Ru̱ u̱ Be̱te̱r, be-du̱ na watu̱ bo̱ yu̱nu̱ste̱ u̱t-ta'ar m-kim u̱ka ta'ar-du̱ u̱t-hu̱ktin tu̱msu̱ be-du̱ bo̱ nomte̱ u̱s-to̱nd u̱-me̱ ne̱. U̱ da-o̱ yage̱ dak-u uno̱ za naas u-da bo̱ mu u̱ dak-u̱ u̱r-mat-u̱ ró.> >> ");
INSERT INTO gel_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rahira e̱ Riya e̱ shu̱s, e̱ zu̱, <<No̱ng it u̱r-zwar sok, it zamu̱n u̱ re̱-du̱ no̱m-tu̱ u̱t-kom tu̱ u̱so-u it. ");
INSERT INTO gel_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Wa muute̱ it u̱ka ham-u̱t ne̱. Wa babu̱g it, tu̱msu̱ wa ho̱ru̱sse̱ shik-u̱ bo̱ to̱pe̱ remu̱ it be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","No̱m-u̱ u̱t-kom u̱ Ru̱-u̱ ya bo̱ du̱gu̱-du̱ u̱so-u it, o̱g-u̱r it de̱ u̱ ya'ag-u̱ it ne̱, u̱ remu̱ iya no̱mo̱n no̱m-u̱ Ru̱-u̱ zu̱ bo̱ no̱m.>> ");
INSERT INTO gel_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Se̱ Yakubu su̱k ne̱ta-u̱t wa u̱ ya'ag-u̱ wa ne̱ u̱-do̱m rakum. ");
INSERT INTO gel_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Se̱ wa yu̱n bisa-u̱t wa u̱t-be̱e̱t u̱ shu̱ wa, wa kargu̱sse̱ u̱ no̱m-tu̱ wa kume̱ ne̱ u̱t-be̱e̱t u̱ Padan-aram se̱ wa aru̱k m-mu̱ u̱ dak-u̱ Kan'ana, u̱ Gas-u̱ u̱so-u wa Ishaku o̱tte̱ u̱ shu̱'u̱t. ");
INSERT INTO gel_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Kanda Yakubu u̱ ne̱ta-u̱t wa, u̱ ya'ag-u̱ wa ne̱ aru̱k, Raban o̱ m-ra remu̱ wa or-u̱t can-tu̱ ca. Rahira hiwis ru̱-tu̱ u-bu tu̱ na maye̱ tu̱ e'-du̱ bu-u tu̱ o̱o̱ge̱ tu̱ Raban. Tu̱msu̱ wa aru̱k u̱ to̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakubu e̱ngu̱sse̱ ve̱r-u̱s Raban ne̱t-u̱ Aram, u̱ wa gu̱gu̱mte̱ waru̱ wa u̱zu̱ wa do̱'e̱ u̱ aru̱k. ");
INSERT INTO gel_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yakubu aru̱k u̱ no̱m-tu̱ wa o̱tte̱ ne̱ u̱t-be̱e̱t. Wa pu̱s gi-yu̱ Yufiretis, wa aru̱k m-da u̱-do̱mu̱ ro̱r-tu̱ dak-u̱ Giriyad. ");
INSERT INTO gel_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Da-u̱ rooge̱ u̱t-tu̱t, na waru̱ Raban u̱zu̱ Yakubu so̱mo̱g. ");
INSERT INTO gel_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Se̱ wa kargu̱sse̱ ne̱t-tu̱ bu-u wa u̱t-be̱e̱t u̱r-ko̱t u̱ wa ne̱ e̱ aru̱k m-so̱m m-do̱r Yakubu m-roog u̱t-ta'er. Wa o̱ do̱rru̱ dim-u̱ wa u̱t-mo̱r u̱ wa ne̱ m-te̱ ro̱r-tu̱ dak-u̱ Giriyad. ");
INSERT INTO gel_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Se̱ Ru̱-u̱ haan u̱du̱ Raban ne̱t-u̱ Aram u̱ bo' m-gyu̱p da-u̱ wa o̱o̱ge̱ m-roog, wa zu̱ wa, <<A-bo̱ o̱ jaru̱n bo̱ zu̱ Yakubu o̱ko̱n no̱m-o̱ da, ko̱ u̱ so̱-o̱ ko̱ u̱ yo̱-o̱ da.>> ");
INSERT INTO gel_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Raban bit wu̱n da-u̱ is gase̱ u̱ be-du̱ wa nomte̱ u̱r-rimpa u̱ do̱m-u̱ ro̱r-du̱ dak-u̱ Giriyad, Raban u̱ ne̱t-u̱t wa ne̱ e̱ nom du̱ e̱ rimpa-de̱ u̱t-mo̱r u̱ Yakubu ne̱. ");
INSERT INTO gel_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Raban zu̱ Yakubu, <<¿Yan-o̱ bo̱ no̱mu̱ me̱ iya? Bo̱ e̱ngu̱sse̱ me̱ u̱s-ve̱r, tu̱msu̱ bo̱ ku̱b ya-u̱t-gwu̱p-u̱ ri m-no̱k sha-mu̱ to̱k-ne̱ i m-gag. ");
INSERT INTO gel_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Rem-u yan-o̱ bo̱ somte̱ m-yasa bo̱ e̱ngu̱sse̱ me̱ u̱s-ve̱r? ¿Remu̱ yan-o̱ bo̱ gu̱gu̱mte̱ waru̱ me̱, se̱ u̱m yage̱ bo̱ aru̱k m-yar u̱-te̱k u̱r-so̱, u̱t-se̱p ne̱, u̱ go̱ngu tu̱ u̱r-so̱ ne̱, u̱s-mo̱ro̱ ne̱? ");
INSERT INTO gel_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","¿Yan-o̱ hose̱ bo̱ yage̱ u̱m ham-u̱t ya-u̱t-gwu̱p-u̱ ri u̱ ya'ag-u̱ ya'ag-u̱ ri ne̱ u̱m waru̱ e̱ u̱zu̱ se̱ u̱r-ho̱? Bo̱ no̱mu̱g no̱m-tu̱ m-rag. ");
INSERT INTO gel_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","U̱m o̱ u̱r-be̱b ne̱, du̱ u̱m do̱te̱ u̱ ho̱n-su̱ bo̱, se̱di gyu̱p-ne̱ m-gyu̱p Ru̱-u̱ u̱so-u ró hyu̱mu̱g me̱ u̱zu̱, a u̱m o̱ jaru̱n u̱m zu̱ bo̱ o̱ko̱n, ko̱ u̱ so̱-o̱ ko̱ u̱ yo̱-o̱ da. ");
INSERT INTO gel_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","U̱ da-o̱ bo̱ aru̱kte̱ remu̱ zu̱ bo̱ e̱ku̱ste̱ m-tumb ne̱ u̱zu̱ bo̱ mu u̱ bu-u̱ u̱so ró. ¿Se̱di remu̱ yan-o̱ wa-e̱ bo̱ hiwiste̱ me̱ u̱t-ru̱?>> ");
INSERT INTO gel_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakubu shu̱s, wa zu̱ Raban, <<U̱m o̱ ho̱g-du̱ u-gye̱r, u̱m kabu̱g u̱ jab-u̱ ri u̱zu̱ bo̱ kab ya-u̱t-gwu̱p-u̱ ró du̱gu̱-du̱ ri u̱r-be̱b. ");
INSERT INTO gel_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Se̱di a-bo̱ hyane̱ waku̱n u̱ ru̱-u ró ne̱, wa za u̱t-shu̱'u̱t u̱r-fat da. U̱ shu̱ ne̱t-tu̱ ko̱-u̱r ró be̱e̱t, gwat u̱ hi-du̱ warró ko̱ abite̱ zu̱ o̱ko̱n o̱ro u̱ it kabne̱ du̱gu̱-du̱ ró u̱ ane̱ u̱du̱ ri. A-bo̱ hyane̱, se̱ bo̱ kab.>> Yakubu nak hyen u̱zu̱ Rahira hiwistu̱n cu̱n-du̱ e'-du̱ u-bu Raban da. ");
INSERT INTO gel_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Raban to rimpa-u̱r Yakubu u̱ku̱n, wa to me̱ rimpa-u̱r Riya wa got, wa to tu̱msu̱ be-du̱ rimpa-du̱ to̱k-ne̱ ne̱ta-u̱t rò u̱t-yu̱r se̱di wa hyanu̱g o̱ko̱n da. M-vaste̱ wa to rimpa-u̱r Rahira. ");
INSERT INTO gel_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Se̱di, Rahira kabgu̱n ru̱-tu̱ u-bu tu̱ na maye̱ tu̱ e'-du̱ bu-u tu̱ o̱o̱ge̱ tu̱ Raban wa guns u̱ no̱m-du̱ u̱r-shu̱'u̱t u̱ do̱m-u̱ u-rakum wa shu̱'u̱t u̱ do̱m-u̱ de̱. Raban gotu̱sse̱ ko̱he̱ne̱ wa hyanu̱g o̱ku̱n da. ");
INSERT INTO gel_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rahira zu̱ u̱so-u wa, <<U̱so u-bu ri, a jab-u̱ ró na u̱-me̱ ne̱ da. U̱m da ke̱rre̱ u̱r-yu̱ne̱ u̱-shu̱ ró da, remu̱ zu̱ u̱m o̱ hyu̱-mu̱ u-pyaat yu̱ ne̱ta-ne̱.>> Se̱ wa go̱tu̱sse̱ wa hyanu̱g ru̱-u̱ e'-du̱ u-bu wa da. ");
INSERT INTO gel_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jab-u̱ Yakubu nu̱ so̱k wa shit Raban u̱zu̱, <<¿Yan-o̱ u̱m no̱me̱ u̱ yo̱-o̱? ¿Yan ba'as-to̱ u̱m no̱mu̱ bo̱, tu̱ bo̱ o̱tte̱ u̱ gotu̱ me̱? ");
INSERT INTO gel_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Bo̱ cwagu̱sse̱ cwu̱-u̱t ri u̱t-be̱e̱t tu̱ u̱m o̱tte̱. U̱ da-o̱ ko̱su̱ me̱ o̱kon o̱ro u̱ bo̱ hyane̱ u̱ o̱o̱ge̱ u̱ ró! Cin o̱ u̱ ane̱ u̱-shu̱ it, u̱-shu̱ ne̱t-u̱t in, u̱ ko̱wan u̱ hyan. Yage̱ e̱ no̱mu̱ in kwu̱p-du̱ u̱s-rem! ");
INSERT INTO gel_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","<<U̱m shu̱'u̱te̱ u̱ bo̱ ne̱ u̱s-hak u̱r-shik (20). Mangu̱ ca ró u̱ so-u̱ gwar-u̱ ró ne̱ e̱ tamu̱g naas-du̱ u̱t-me̱n da. U̱m tamu̱g tu̱-du̱ ko̱ u-ca u-gan ban-du̱ ca ró da. ");
INSERT INTO gel_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","U̱m tamu̱g mu̱tu̱n bo̱ u-du̱ u-bisa u̱ no̱m-yu̱ u̱r-do̱g ho̱ye̱ da, bo̱ wu̱ me̱ u̱m to̱p no̱m-u̱ e̱nke̱ u-be̱e̱t. Tu̱msu̱ bo̱ zu̱ u̱m to̱p bo̱ i na hiwe̱ ko̱ u-ho̱ ko̱ m-gyu̱p. ");
INSERT INTO gel_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","U̱m swaag u̱r-ko̱b u̱ no̱m-u̱ bo̱ m-ank u-ho̱, m-tor ne̱, u̱m kum-u̱t m-roog m-gyu̱p da. ");
INSERT INTO gel_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Iya-o̱ hak-u̱s ri u̱r-shik u̱m o̱ no̱m-u̱ bo̱ m-to̱k u̱ bu-u ró! U̱m no̱ng u̱s-hak o̱p u̱s-nas 14 u̱ remu̱ bo̱ ye'et me̱ ya-u̱t-gwu̱p-u̱ ró, tu̱msu̱ u̱s-hak u̱s-shishin u̱ remu̱ ban-du̱ bisa-u̱t ró. Bo̱ swase̱ me̱ no̱m-u̱ o̱o̱ge̱ o̱g-u̱r ri u-so u-o̱p. ");
INSERT INTO gel_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","U̱zu̱ u-Ru̱ u̱ u̱so-u̱t ri, Ru̱-u Ibrahi tu̱msu̱ u̱ Ru̱-u̱ u̱so-u ri Ishaku wu̱ wa no̱me̱ m-zap u̱ gye̱r-u wa ne̱, u̱zu̱ wa o̱ u̱r-ko̱t u̱-me̱ ne̱ da, bo̱ za yanu̱g me̱ u̱t-kom zan. Se̱di Ru̱-u̱ hyanu̱g pama-u ri tu̱msu̱ u̱ka u̱m nomte̱ m-ank sok, o̱ wa'e̱ wa nomte̱ bo̱ u̱t-him gyu̱p-ne̱ m-gye̱p u̱zu̱ a-bo̱ jaru̱n bo̱ zu̱ me̱ o̱kon da.>> ");
INSERT INTO gel_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Raban zu̱ Yakubu, <<Ne̱ta-u̱t ró ya'ag-u̱ ri e̱, ya'ag-u̱ e̱ ya'ag-u̱ ri e̱, ban-du̱ bisa-u̱t ró tun-to̱ tu̱ ri to̱, no̱m-u̱ bo̱ hyane̱ u-be̱e̱t u̱ ri o̱, bo̱ o̱ m-ha ne̱ ¿yan-o̱ u̱m do̱'e̱ u̱t-no̱m u̱ da-o̱ u̱ mo̱ttu̱ ya'ag-u̱ ri ne̱, ko̱ u̱ ya'ag-u̱ e̱, mate̱ ne̱? ");
INSERT INTO gel_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Haane̱ u̱ da-o̱, u̱ yo-u no̱m este̱du̱ u̱s-rem, yage̱ u̱ shu̱'u̱t u̱s-nap u̱du̱ yo-u.>> ");
INSERT INTO gel_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yakubu kabu̱n u̱r-ta'ar wa ser de̱ u-dak m-kim u̱ka ta'ar-du̱ u̱t-hu̱ktin, u̱ shu̱'u̱t u̱s-nap. ");
INSERT INTO gel_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Se̱ Yakubu zu̱ ne̱t-u̱t wa, <<Kargu̱ssu̱n u̱t-ta'ar.>> Se̱ e̱ kabu̱n u̱t-ta'ar e̱ kargu̱sse̱ to̱ u̱r-kir, e̱ re no̱m u̱t-re̱ u̱ kit-u̱ kir-ru̱ u̱t-ta'aru̱ de̱. ");
INSERT INTO gel_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Raban te'e be-u̱r re̱ u̱r-dim Jegar-sahaduta, no̱m-u̱ na zu̱ iya (u̱r-kir du̱ u̱t-baku̱s) tu̱msu̱ Yakubu fog be-u̱r re̱ Gareed, no̱m-u̱ na zu̱ye̱ iya tu̱msu̱ u̱ rem-du̱ Ibraniyawa <<u̱r-kir du̱ u̱t-baku̱s.>> ");
INSERT INTO gel_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Raban zu̱ Yakubu, <<Dinde̱ kir-du̱ u̱t-ta'ar de̱ du̱ u̱s-nap de̱ u̱du̱ ró ne̱ u̱ ya-o̱.>> O̱ wu̱te̱ na fog-u̱t de̱ Gareed. ");
INSERT INTO gel_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Na fog be-u̱r re̱ tu̱msu̱ Mizupa, (no̱m-u̱ na zu̱ye̱ iya be-du̱ wadu̱ u̱r-is), remu̱ zu̱ Raban zu̱u̱g, <<Yage̱ Yawe wa u̱r-is u̱ do̱m-u̱ yo, yo-u ship este̱du̱ u̱s-remu̱ din-de̱, da-u̱ waku̱n zare̱ u hyan-du̱ o̱ru̱ wa da. ");
INSERT INTO gel_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","A mu̱ne̱ u̱zu̱ bo̱ no̱ngu̱ ya'ag-u̱ ri no̱m-u̱ yo̱-o̱ ko̱ bo̱ sur m-ga to̱ko̱n ne̱ta to̱, ko̱ ba shu̱'u̱te̱ u̱zu̱ waku̱n zaaru̱ kit-u̱ yo-u da, bakse̱ u̱zu̱ Ru̱-u̱ gwat-du̱ yo.>> ");
INSERT INTO gel_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Raban zu̱ Yakubu, <<Kir-du̱ u̱t-ta'ar u̱ dinde̱, tu̱msu̱ u̱ ta'ar u̱r-dinde̱ du̱ u̱m se̱re̱ u̱ te̱k-u̱ me̱ yo. ");
INSERT INTO gel_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Dinde̱ kir-de̱ de̱ o̱ u̱s-nap, tu̱msu̱ damra du̱ u̱r-ta'ar dinde̱ de̱ de'e̱ bak-su̱ yo-u, u̱zu̱ u̱m zaaru̱ pas-du̱ ta'ar-du̱ rinde̱ rem u̱m no̱m-tu̱ bo̱ no̱m-u yo̱-o̱ da, tu̱msu̱ bo̱ zaaru̱ pas-du̱ de̱ rem bo̱ no̱m-tu̱ me̱ no̱mu yo̱-o̱ da. ");
INSERT INTO gel_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Yage̱ Ru̱-u Ibrahi u̱ Ru̱-u Naho̱r ne̱, u̱ Ru̱-u̱ u̱so-u e̱ ne̱, u̱ wa no̱m-u̱ yo-u kwu̱p-du̱ u̱s-rem.>> Yakubu no̱m u̱s-to̱nd u̱ dim-du̱ u-Ru̱ u̱ ya-du̱ u-gye̱r u̱ u̱so-u wa Ishaku. ");
INSERT INTO gel_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakubu yaag u̱r-to̱o̱g u̱du̱ u-Ru̱ u̱ku̱n u̱-do̱m u̱r-ro̱r wa bu̱n ko̱-u̱r wu̱n e̱ haan u̱ be-du̱ re̱-du̱ no̱m u̱t-re̱. Da-u̱ e̱ tase̱ re̱-du̱ no̱m u̱t-re̱, ku̱na e̱ roogte̱ u̱ gyu̱p-m mo̱. ");
INSERT INTO gel_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Da-u̱ is gase̱ u̱r-wu̱n te̱p te̱p, Raban ham-u̱t ya-u̱t u̱t-gwu̱p u̱ wa u̱ ya'ag-u̱ ya'ag-u̱ wa ne̱ wa wa'-u̱ e̱ nu-u so̱-o̱. Wa yu̱ne̱ wa aru̱k m-mu̱. ");
INSERT INTO gel_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakubu tu̱msu̱ wa re u-shu̱ u̱ ha-m wa ne̱, a-to̱m u-Ru̱ haan e̱ bit wu̱n do̱m-u̱ u-fu̱n. ");
INSERT INTO gel_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Da-u̱ Yakubu hyane̱ u̱n, wa zu̱, <<Din-de̱ be-de̱, be-du̱ u-Ru̱ de̱.>> Wa wa'-u̱ be-u̱r re̱ u̱r-dim Mahanayim. No̱mu̱ na zu̱ye̱ Mahanayim <<u̱t-rimpa u̱t-yu̱r.>> ");
INSERT INTO gel_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakubu tom a-to̱mu̱ wa ne̱ u̱-shu̱ wa m-ha u̱du̱ yu̱-wu̱ya wa Isuwa u̱ gas-u̱ Seyir, dak-u̱ Edo̱m. ");
INSERT INTO gel_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Wa zu̱ u̱n, <<No̱m-u̱ no̱ de̱ zu̱ Isuwa u̱so u-bu ri o̱r-u̱ ri ya, <No̱m-u̱ to̱k-u̱ ró Yakubu zu̱ye̱ ya, u̱m shu̱'u̱te̱ u̱du̱ Raban tu̱msu̱ ku̱na u̱m o̱tte̱ m-te uno̱ da-o̱. ");
INSERT INTO gel_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","U̱m o̱tte̱ ban-du̱ na, u̱ ca ne̱, u̱ janka ne̱, u̱ gwaar ne̱, u̱ to̱k-ne̱ ne̱ta-ne̱ u̱ campa-ne̱. U̱ da-o̱ u̱m o̱ to̱mtu̱n sin-se̱ rem-se̱ u̱du̱ u̱so u-bu ri, u̱zu̱ ko̱me̱ kwu̱mu̱ hyu̱-m pusmo̱ u̱du̱ ró.> >> ");
INSERT INTO gel_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Da-u̱ a-to̱m ne̱ mu̱u̱ne̱ u̱du̱ Yakubu, e̱ zu̱, <<It haag u̱du̱ o̱r-u̱ ró Isuwa, wa o̱o̱n u̱ campa-ne̱ u̱t-ko̱k u̱t-nas 400, u̱ no̱ wa ne̱ gotu̱n.>> ");
INSERT INTO gel_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakubu hog u-gye̱r sok u̱ no̱m-u̱ na waru̱ wa ne̱, se̱ wa mot ne̱t-tu̱ o̱o̱ge̱ u̱r-kot u̱ wa, u̱ ban-tu̱ ca ne̱ u̱ gwaar ne̱ u̱ rakum ne̱, u̱t-ban u̱t-yu̱r. ");
INSERT INTO gel_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Wa no̱ng u̱s-dorog u̱zu̱, <<Ko̱ da Isuwa kwu̱ku̱p ban-du̱ u̱r-gan, jiya ban-du̱ u̱r-gan u̱t-ku̱su̱m.>> ");
INSERT INTO gel_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Se̱ Yakubu no̱m u̱s-to̱o̱g, <<Ru̱-u̱ u̱so-u ri Ibrahi, Ru̱-u̱ u̱so-u ri Ishaku, Yawe, bo̱ zu̱ me̱, <Arke̱ m-mu̱ u̱ dak-u ró u̱ ko̱-u̱r ró ne̱, tu̱msu̱ me̱ u̱t-wa bo̱ re̱ u-shu̱.> ");
INSERT INTO gel_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Me̱ u̱m ko̱rge̱ na zu̱ bo̱ ko̱sku̱ me̱ cwan-u̱t ró tu̱msu̱ nip-u̱t ró ne̱ tu̱ bo̱ ko̱su̱ me̱ da, me̱ yu̱ o̱o̱ge̱ to̱k-u̱ ró. Da-u̱ u̱m yage̱ u-bu tu̱msu̱ u̱m pu̱s gi-yu̱ Jodan, u̱m zatte̱ o̱ko̱n da se̱ ko̱m-yu̱ m-ha, me̱ ya u̱ da-o̱ bu-u ri shu̱'u̱te̱ u̱ yat-o̱ u̱t-ban u̱t-yu̱r. ");
INSERT INTO gel_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Yawe, me̱ ya u̱m o̱ u̱s-to̱o̱g u̱du̱ ró, bo̱ gu me̱ du̱gu̱ kom-tu̱ o̱r-u̱ ri Isuwa. U̱m o̱ ho̱g-du̱ u-gye̱r u̱zu̱ wa o̱o̱n u̱ zwarnu̱ it m-dum, u̱ ya'ag-u̱ ri ne̱ u̱ ne̱ta-u̱t ri ne̱. ");
INSERT INTO gel_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Bakse̱ u̱zu̱ bo̱ no̱ngu̱ me̱ este̱du̱ u̱s-rem, bo̱ u̱t-wa u̱m re̱ u-shu̱ tu̱msu̱ bo̱ u̱t-wa u̱ ya'ag-u̱ ri shu̱'u̱t u-tát ba m-hereg mu̱ m-sa, mu̱ zaare̱ u̱t-ogre̱ da.>> ");
INSERT INTO gel_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yakubu roog u̱ku̱n be-du̱ wa o̱tte̱ m-gyu̱p m-gan, se̱ wa du̱gu̱r cwu̱-tu̱ u-nya du̱gu̱ no̱m-tu̱ u̱t-kom-u̱ wa, wa tom-u̱t to̱ u̱du̱ yu̱-wu̱ya wa Isuwa: ");
INSERT INTO gel_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Mangu̱ gwaar ne̱ u̱t-ko̱k u̱t-yu̱r 200, gob-u̱ gwaar u̱r-shik 20, mangu̱ ca ne̱ u̱t-ko̱k u̱t-yu̱r 200, tu̱msu̱ kag-u̱ ca u̱r-shik 20, ");
INSERT INTO gel_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","u̱ rakum ne̱ u̱r-shik u̱ o̱p 30, u̱ mangu̱ na ne̱ u̱t-shik u̱t-yu̱r 40, gob-u̱ na o̱p, mangu̱ janka u̱r-shik 20, tu̱msu̱ gob-u̱ janka o̱p. ");
INSERT INTO gel_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Wa wu̱ to̱k-ne̱ wa e̱ gwat bisa-u̱t to̱, u̱t-ban u̱t-ban, wa zu̱ to̱k-ne̱ wa, <<Arku̱n u̱ shu̱ ri, u̱ no̱ ya' u̱r-ke̱r u̱ ko̱du̱he̱ ban-du̱ u̱t-bisa de̱.>> ");
INSERT INTO gel_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Wa zu̱ ban-du̱ o̱o̱ge̱ u̱ shu̱, <<Da-u̱ o̱r-u̱ ri Isuwa haane̱ u̱du̱ no̱ wa shit no̱, <¿No̱ ne̱t wan to̱ no̱ o̱o̱ge̱? ¿Tu̱msu̱ he̱ne̱ o̱ no̱ o̱tte̱ m-ha? ¿Wana tu̱msu̱ o̱tte̱ tun-to̱ bisa to̱ tu̱ no̱ o̱tte̱ u̱t-be̱e̱t?> ");
INSERT INTO gel_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Se̱ no̱ zu̱ wa, <Bisa-tu̱ to̱k-u̱ ró Yakubu to̱. Se̱di tu̱ u-nya to̱ tu̱ wa zu̱ na yase̱ u̱so u-bu ri Isuwa. Wa o̱o̱n u̱ dim-u̱ it.> >> ");
INSERT INTO gel_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Wa sur m-no̱mu̱ ban-du̱ u-yu̱ru̱mse̱ u̱t-him, u̱du̱ u-tu̱tu̱rse̱ ne̱ u̱ i o̱o̱ge̱ u̱ gwat-du̱ ban-tu̱ u̱t-bisa ne̱ u̱t-be̱e̱t: <<No̱ be̱e̱t no̱ do̱'e̱ zu̱ Isuwa no̱m-u̱ u-gan u̱ka u̱m zu̱tte̱ o̱r-u̱t no̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Se̱di no̱ do̱'e̱ zu̱du̱ wu̱n, <Gwat to̱k-u̱ ró Yakubu o̱o̱n u̱ dim-u̱ it.> >> Yakubu no̱ng u̱s-dorog u̱zu̱ <<U̱m o̱ u̱ssa u̱m swaan hi-u̱r rò u̱ remu̱ nya-u̱ u̱m tomte̱ u̱-shu̱ ri, da-u̱ u̱m hyane̱ wu̱n, jiya wu̱nu̱ kabu̱ me̱ u̱t-kom u̱t-yu̱r.>> ");
INSERT INTO gel_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Se̱ cwu̱-tu̱ u-nya tu̱ Yakubu aru̱k u̱-shu̱ wa, se̱di Yakubu roog u̱-dim m-gyu̱p u̱r-rimpa. ");
INSERT INTO gel_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Da-u̱ gyu̱p-mu̱ no̱me̱ Yakubu yu̱ne̱ wa ku̱b ne̱ta-u̱t wa u̱t-yu̱r, u̱ to̱k-u̱ ne̱ta-u̱t wa ne̱, u̱ ya'ag-u̱ campa-ne̱ wa ne̱ o̱p u-gan wa pu̱s gi-yu̱ Jabok u̱ e̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Da-u̱ wa pase̱ u̱ u̱n ne̱ u̱ din-de̱ jit gwu̱g-du̱ u-koor de̱, wa pu̱st no̱m-tu̱ wa o̱tte̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yakubu wa kuse̱ u̱ war-wa u̱ku̱n, yaku̱n campa-ya haan wa nom u̱t-noos u̱ wu̱n ne̱ se̱ u̱r-gas is. ");
INSERT INTO gel_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Da-u̱ ne̱tu̱ wa hyane̱ wa kerge̱ wu̱n da, se̱ wa tu̱m sharru̱ u-kut u̱ Yakubu de̱ shate̱ da-u̱ wa o̱o̱ge̱ u̱t-noos u̱ campa-u ya ne̱. ");
INSERT INTO gel_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Se̱ ne̱tu̱ wa zu̱, <<Yage̱ me̱ u̱m aru̱k, is haag m-gas.>> Yakubu shu̱s wa zu̱, <<U̱m da yagu̱ bo̱ da se̱ bo̱ wage̱ me̱ nu-u so̱-o̱.>> ");
INSERT INTO gel_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ne̱tu̱ wa shit wa zu̱, <<¿Dim-u̱r ró de̱ na zu̱ wane̱?>> Wa shu̱s wa zu̱, <<Dim-u̱r ri de̱ na zu̱ye̱ Yakubu.>> ");
INSERT INTO gel_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Se̱ ne̱tu̱ wa zu̱ wu̱n, <<Na zamu̱n u̱t-swu̱r m-fag bo̱ Yakubu da, se̱di Isra, rem u̱zu̱ bo̱ no̱ng u̱t-noos u-Ru̱ ne̱ u̱t-ne̱t ne̱ tu̱msu̱ bo̱ re u̱r-ko̱rro̱.>> ");
INSERT INTO gel_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakubu shit wu̱n, wa zu̱, <<Gag jab waru̱ me̱ dim-u̱r ró.>> Wu̱n zu̱ wa, <<¿Remu̱ u-yan o̱ bo̱ o̱tte̱ u̱ssa bo̱ nap dim-u̱r ri?>> Se̱ wa wa'-u̱ Yakubu nu-u so̱-o̱ u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Se̱ Yakubu fog dim-du̱ be-u̱r re̱ Peniye̱r du̱ na zu̱ye̱, <<Shu̱-u̱ u-Ru̱ remu̱ zu̱ u̱m hyanu̱g u-Ru̱ u-shu̱ u-shu̱ ne̱, m-ha iya ne̱ u̱m maru̱g da.>> ");
INSERT INTO gel_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Da-u̱ ho̱-du̱ o̱ rwu̱u̱n se̱ Yakubu yage̱ Pe̱niye̱r, wa o̱ m-da u̱s-teger remu̱ sharru̱ u-kut-u̱ wa shakte̱. ");
INSERT INTO gel_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","De̱ wu̱te̱ Isra-ne̱ tu̱-u̱t ap-mu̱ u-kut da, u̱ haan u̱ da-o̱, remu̱ zu̱ kut-o̱ na tu̱mte̱ Yakubu. ");
INSERT INTO gel_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Se̱ Yakubu jaku̱s is wa hyen Isuwa, u̱ daan u̱ campa-ne̱ wa ne̱ u̱t-ko̱k u̱t-nas 400, se̱ wa mo̱t ya'ag-u̱ wa u̱ te̱k-u̱ Riya, Rahira, u̱ to̱k-ne̱ ne̱ta-u̱t wa ne̱ u̱t-yu̱r. ");
INSERT INTO gel_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Se̱ wa wu̱ to̱k-ne̱ ne̱ta-u̱t wa u̱ ya'ag-u̱ e̱ ne̱ u̱-shu̱, Riya do̱ro̱n e̱ u̱ ya'ag-u̱ wa ne̱, tu̱msu̱ Rahira ne̱ e̱ Yusuhu m-vaste̱. ");
INSERT INTO gel_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakubu aru̱k u̱ nu-du̱. Da-u̱ wa no̱me̱ mo̱ttu̱ te-du̱ be-du̱ Isuwa o̱tte̱, wa do̱'e̱ wa he̱ u̱t-jwu̱n u̱ shu̱ wa u-dak u̱so u-ta'er. ");
INSERT INTO gel_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Se̱di Isuwa nom m-so̱m wa bit wu̱n wa ham-u̱t wu̱n, se̱ wa haatu̱n hi-u̱r wu̱n u̱ zag u̱t-kap-u̱ wa, ko̱wan su gu̱t-du̱ o̱r-u̱ wa. U̱n be̱e̱t ko̱wan hu̱ u̱s-kan. ");
INSERT INTO gel_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Isuwa got u̱t-ne̱ta u̱ yaag ne̱. Wa shit, <<¿Ne̱t-u̱t tun-to̱ tu̱ o̱o̱ge̱ u̱r-kot u̱ bo̱ ne̱ wanne̱ e̱?>> Yakubu zu̱, <<Yaag-u̱ u-Ru̱ ya'u̱ to̱k-u̱ ró e̱.>> ");
INSERT INTO gel_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Se̱ to̱k-ne̱ ne̱ta-u̱t rò, da-u̱ e̱ o̱ mo̱ttu̱ be-du̱ wu̱n o̱tte̱ e̱ hikne̱ e̱ haan e̱ he u̱t-jwu̱n shu̱-u e̱ u-dak u̱ ya'ag-u̱ e̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Riya haan u̱ i wa yaag-e̱ ne̱, e̱ so̱ko̱t u-dak u̱ shu̱ wu̱n. M-vaste̱ Rahira haan e̱ Yusuhu e̱ he u̱t-jwu̱n u̱ shu̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Isuwa shit, <<¿Yan-o̱ dorog-u̱s ró, u̱m hyanu̱g ban-tu̱ u̱t-bisa tun-to̱, ca, u̱ gwaar ne̱, u̱ na ne̱ tu̱ u̱m goone̱ u̱ to̱ ne̱ u-fu̱n?>> Wa zu̱ wu̱n, <<U̱so u-bu ri, u̱m u̱t-sa u̱m kum hyu̱-m pusmo̱ u̱du̱ ró.>> ");
INSERT INTO gel_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Se̱di Isuwa zu̱, <<U̱m o̱tte̱ no̱m-tu̱ ko̱ru̱ me̱, shipse̱ no̱m-u̱t ró hi-du̱ war ró.>> ");
INSERT INTO gel_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakubu zu̱, <<O'o, gag jab, abite̱ u̱m kwu̱mu̱g hyu̱-m pusmo̱ u̱du̱ ró, kab nya-u ri, remu̱ u̱zu̱ hyan-du̱ shu̱-u ró o̱ sha-mu̱ hyan-du̱ shu̱-u u-Ru̱, bo̱ ya u̱ da-o̱ bo̱ kabu̱g me̱ u̱ te̱k u̱r-so̱. ");
INSERT INTO gel_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Gag jab o̱nke̱ nya-u̱ u̱m haatu̱n bo̱, remu̱ zu̱ u-Ru̱ o̱ u̱r-kot u̱-me̱ ne̱ u̱m o̱tte̱ no̱m-u̱ u̱m o̱ u̱ssa u-be̱e̱t.>> Yakubu e̱kse̱ wu̱n, wu̱n kab no̱m-tu̱ wa to̱mtu̱n wu̱n, Isuwa o̱nk to̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Isuwa zu̱, <<To̱, zo̱nge̱ yo-u no̱k, me̱ ko̱su̱ bo̱ u-fu̱n.>> ");
INSERT INTO gel_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Se̱di Yakubu zu̱, <<U̱so u-bu ri, bo̱ hyanu̱g ya'ag-u̱ ri e̱ke̱n o̱mo̱n u̱ re̱k-e̱, tu̱msu̱ ban-tu̱ u̱t-bisa e̱ke̱n o̱tte̱ ya-u̱t re̱kto̱ ko̱'e̱, a it buze e̱ m-so̱m, e̱ u̱t-mu̱rmu̱sse̱ be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","U̱so u-bu ri, gag jab, arke̱ u̱-shu̱ to̱k-u̱ ró, it no̱ko̱n cashi cashi, u̱ka bisa-tu̱ do̱te̱ u̱ ke̱rru̱ u̱r-no̱k u̱ ya-u̱t e̱ ne̱, me̱ bitu̱ bo̱ u̱ Seyir.>> ");
INSERT INTO gel_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Isuwa zu̱, <<Yage̱ u̱m yage̱ to̱ko̱n ne̱t-u̱t ri to̱ u̱du̱ ró.>> Se̱di Yakubu zu̱ wu̱n, <<U̱so u-bu ri, a se̱ bo̱ no̱ng iya da! No̱m-u̱ u̱m o̱o̱ge̱ u̱ssa bo̱ ho̱g re̱me̱r-m ri.>> ");
INSERT INTO gel_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","U̱ gandi ho̱-u̱r re̱ Isuwa aru̱k m-mu̱ u̱ dak-u̱ Seyir. ");
INSERT INTO gel_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yakubu aru̱k m-mu̱ u̱ dak-u̱ Sukot, ku̱na wa muute̱ u̱r-be remu̱ a-u-bu wa ne̱ nom-u̱t u̱r-yu̱ u̱ku̱n. Tu̱msu̱ wa no̱me̱ bisa-u̱t wa u-shingi, o̱ wa-e̱ wa fog-u̱t be-u̱r re̱ Sukot, no̱m-u̱ na zu̱ye̱ Sukot be-du̱ u̱r-hure̱. ");
INSERT INTO gel_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","M-vaste̱, da-u̱ Yakubu haane̱ du̱gu̱ Padan-Aram, wa teeg bo̱-u̱ She̱ke̱m m-yar, dak-u̱ Kan'ana, wa no̱m u̱r-rimpa u̱t-mo̱r u-bo̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Yakubu o̱o̱g u̱r-ke̱ngi du̱ u-tak be-du̱ wa nomte̱ u̱r-shu̱m u̱ kwam-u̱t pus-to̱ tu̱ u-ko̱k u-gan 100. Du̱gu̱-du̱ a-u-bu Hamor, u̱so-u She̱ke̱m, wa babe̱ Yakubu ke̱ngi-u̱r re. ");
INSERT INTO gel_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ku̱na wa mate u̱r-sak wa wa'-u̱ de̱ u̱r-dim E̱r E̱ro̱hi Isra, dim-u̱r re̱ na zu̱ye̱, Ru̱-u̱ Isra-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","De̱ku̱n ho̱-de̱ Dinatu, gwu̱p-u̱ Yakubu ne̱ e̱ Riya, wa do̱'e̱ u̱ wa hatu̱ e̱ke̱n ya-u̱t-gwu̱p u̱t-riig i o̱o̱ge̱ u̱ shu̱'u̱t u̱ dak-u o̱. ");
INSERT INTO gel_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Se̱di da-u̱ zwar-u̱ Hamor ne̱t-u̱ Hiwi, faru̱k-u̱ dak-u̱ She̱ke̱m hyane̱ Dina, wa ku̱b wa, wa no̱m-u̱ wa u̱r-ryapu̱k u̱r-be̱b. ");
INSERT INTO gel_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Jab-u̱ wa to u̱du̱ Dinatu gwu̱p-u̱ Yakubu. Wa o̱ cwan-tu̱ gwu̱p-u̱ wa sok, wa no̱m u̱s-rem u̱ka wa do̱te̱ u̱ nak-du̱ jab-u̱ Dinatu u̱ gom-u̱t wa. ");
INSERT INTO gel_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Se̱ She̱ke̱m zu̱ u̱so wa Hamor, <<U̱m o̱ u̱t-sa bo̱ kwu̱mnu̱ me̱ gwu̱p unwa, u̱ wa shu̱'u̱t ne̱ta ri.>> ");
INSERT INTO gel_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakubu hog u̱zu̱ Shekem naaste̱ gwu̱p-u̱ wa Dinatu. Ba shu̱'u̱te̱ u̱zu̱ ya'ag-u̱ campa-ne̱ wa zaar u-bu da e̱ o̱ u̱r-do̱g u̱ be-du̱ gwat-du̱ u̱t-bisa, wa zu̱u̱g o̱ko̱n da se̱ da-u̱ e̱ mu̱ne̱. ");
INSERT INTO gel_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamor, u̱so She̱ke̱m, wa haan u̱du̱ Yakubu wa no̱m u̱s-rem u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Da-u̱ e̱ o̱ te̱k u̱s-rem, ya'ag-u̱ campa-ne̱ Yakubu mu̱u̱n du̱gu̱ u̱r-do̱g. Da-u̱ e̱ ho̱ge̱ no̱m-u̱ no̱me̱, jab-u̱ e̱ nu̱ sok, remu̱ zu̱ Shekem no̱mu̱g no̱m-tu̱ m-'e̱ u̱ te̱k-u̱ ne̱t-tu̱ Isra du̱ wa roogte̱ u̱ gwu̱p-u̱ Yakubu ne̱, no̱m-u̱ kame̱ da. ");
INSERT INTO gel_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor nom u̱s-rem u̱ Yakubu u̱ ya'ag-u̱ wa ne̱. Wa zu̱, <<Zwaru̱ ri She̱ke̱m o̱ u̱ cwan-tu̱ gwu̱p-u̱ no̱, u̱m o̱ u̱s-ko̱n, no̱ ya' wa'-u̱-gwu̱p-u̱ no̱, Dina shu̱'u̱t ne̱ta wa. ");
INSERT INTO gel_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","U̱m o̱ u̱ssa u̱ in no̱m u̱t-gu̱ u̱ te̱k-u̱ in, u̱ no̱ ya' ya-u̱t-gwu̱p-u̱ no̱ u̱du̱ ya'ag-u̱ campa-ne̱ it, tu̱msu̱ it u̱t-ya no̱ ya-u̱t-gwu̱p-u̱ it u̱du̱ ya'ag-u̱ campa-ne̱ no̱. ");
INSERT INTO gel_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","No̱ u̱t-kere̱ u̱r-shu̱'u̱t it, dak-u it u̱ ya u̱du̱ no̱. Shu̱'u̱tu̱n u̱no̱ no̱m u-cerpa u̱ it ne̱, a no̱ kume̱ u-tak u̱ no̱ o̱o̱ge̱ u̱ssa, no̱ u̱t-kere̱ u̱t-o̱.>> ");
INSERT INTO gel_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","She̱ke̱m no̱m u̱s-rem u̱ u̱so-u Dinatu ne̱ u̱ tu̱-wu̱to̱ wa ne̱. Wa zu̱, <<Yagu̱n u̱m kum hyu̱-m pusmo̱ u̱du̱ no̱, me̱ ya'u̱ no̱ no̱m-u̱ no̱ zu̱ye̱ u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Kwu̱pu̱n me̱ shik-u̱ go̱ro̱m u̱ cwu̱-tu̱ u̱r-gu̱ ne̱ u-tát u̱ka no̱ o̱tte̱ u̱ssa, me̱ u̱t-to̱p no̱mu̱ no̱ u̱ssa u-be̱e̱t. No̱m-u̱ u̱m o̱o̱ge̱ u̱ssa u̱ war-o̱ ya me̱, wa-gwu̱p ko̱ wa u̱t-shu̱'u̱t ne̱ta ri.>> ");
INSERT INTO gel_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Remu̱ zu̱ She̱ke̱m naaste̱ Dinatu, ya'ag-u̱ campa-ne̱ Yakubu po̱o̱t She̱ke̱m e̱ u̱so-u wa Hamor. ");
INSERT INTO gel_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","E̱ zu̱ u̱n, <<It zaar u̱ keru̱ u̱t-no̱m iya da. It za ya-du̱ gwu̱p-u̱ it u̱du̱ i zatte̱ u̱r-pe̱s da, u̱t-shu̱'u̱t no̱m-tu̱ m-'e̱ u̱du̱ it. ");
INSERT INTO gel_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Fu̱n-yu̱ u̱t-do̱ru̱ ya, yu̱ it do̱te̱ u̱t-ees, abite̱ zu̱ no̱ u̱t-ees na no̱ no̱mu̱ no̱ u̱r-pe̱s u̱ka it o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Da-u o̱ it do̱'e̱ ya'u̱ no̱ ya-u̱t-gwu̱p-u̱ it, it u̱t-kab ya-u̱t-gwu̱p-u̱ no̱, it-u̱ u̱t-shu̱'u̱t u̱-me̱ no̱, in shu̱'u̱tu̱n u̱s-gan. ");
INSERT INTO gel_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Se̱di a no̱ gu̱gme̱ u̱t-ees u̱ na no̱m-u̱ no̱ u̱r-pe̱s, it-u̱ kabu̱ hu̱no̱ it Dinatu, it aru̱k u̱ su̱ it.>> ");
INSERT INTO gel_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamor e̱ wa'-u̱ wa She̱ke̱m e̱ ees u̱ no̱mu̱ u̱n waru̱ e̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","She̱ke̱m naaste̱ u-da u̱ no̱m-du̱ ko̱n-u̱s sin-se̱ da, remu̱ wa o̱ u̱ cwan-tu̱ gwu̱p-u̱ Yakubu sok. She̱ke̱m wa na ze̱ge̱ m-ya m-ze̱g a-u-bu wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor ne̱ e̱ She̱ke̱m e̱ aru̱k, e̱ hu̱u̱t rem-u̱s se̱ u̱du̱ ne̱nge̱n-tu̱ u-bo̱ u̱ is-yu̱ u-bo̱. ");
INSERT INTO gel_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","E̱ zu̱ u̱n, <<Ne̱t-u̱t tun-to̱ hu̱u̱b-u̱t in to̱, in yagu̱n u̱n shu̱'u̱t in u̱ ane̱ jab gan. Dak-u̱ uno̱ o̱ u-tát o̱ ko̱rge̱ cu̱ndu̱ u̱n. Se̱ in gaan ya-u̱t-gwu̱p-u̱ u̱n tu̱msu̱ in yasu̱n u̱n ya-u̱t-gwu̱p-u̱ in e̱ ga. ");
INSERT INTO gel_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Se̱di u̱n u̱t-shu̱'u̱t u̱ in ne̱ u̱ ane̱ in shu̱'u̱t u̱s-gan u̱ u̱n ne̱ a shu̱'u̱te̱ u̱zu̱ inu̱ campa-ne̱ in u̱t-no̱m u̱r-pe̱s, u̱ka u̱n o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Se̱di a in no̱me̱ iya, bisa-u̱t u̱n u̱ no̱m-tu̱ u̱n o̱tte̱ ne̱ to̱ u̱t-shu̱'u̱t tu̱ in, yagu̱n in ees u̱ rem-u̱s u̱n ne̱, u̱n shu̱'u̱t u̱ in ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ne̱t-tu̱ haane̱ u̱t-be̱e̱t u̱ be-du̱ u̱r-mo̱ro̱g du̱ u-bo̱ e̱ ees e̱ ku̱b Hamor ne̱ e̱ She̱ke̱m. Na no̱mu̱ campa-ne̱ be̱e̱t i o̱ u-bo̱ u̱r-pe̱s. ");
INSERT INTO gel_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ba rooge̱ u̱t-tu̱t, ba shu̱'u̱te̱ u̱n o̱mo̱n u̱ ho̱g-du̱ m-re̱ mu̱ u̱r-pe̱s, ya'ag-u̱ Yakubu yu̱r, Simiyo̱n e̱ Re̱wi, tu̱-wu̱to̱ Dinatu, e̱ yu̱ne̱ e̱ ku̱b u̱s-van, e̱ do̱'e̱ e̱ he̱e̱se̱ u-bo̱ za nap-u̱r e̱, e̱ ho̱ru̱sse̱ ya'ag-u̱ campa-ne̱ be̱e̱t, ");
INSERT INTO gel_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","m-ha Hamor ne̱ e̱ wa'-u̱ wa Shekem. U̱n ho̱ru̱sse̱ e̱ u̱ van-su̱ m-wu̱r u̱ u̱n, se̱ u̱n kabu̱n Dinatu du̱gu̱ bu-u She̱ke̱m m-mu̱ rimpa-u̱r e̱. ");
INSERT INTO gel_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Se̱ ya'ag-u̱ campa-ne̱ Yakubu, i kuse̱, e̱ haan u̱ be-du̱ u-tu̱ ne̱t-ne̱ tu̱t o̱tte̱, u-bo̱ e̱ koos no̱m-tu̱ e̱ o̱tte̱ u̱t-be̱e̱t, remu̱ zu̱ e̱ naaste̱ hu̱no-u e̱. ");
INSERT INTO gel_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","E̱ haan e̱ koos ban-du̱ na u̱n, u̱ ca ne̱, u̱ janka ne̱, u̱ no̱m-tu̱ u̱n o̱tte̱ u̱t-be̱e̱t u-bo̱ tu̱msu̱ u̱-do̱ ne̱ u̱t-ke̱ngi. ");
INSERT INTO gel_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","E̱ ku̱b no̱m-tu̱ u̱t-kom-u̱ u̱n ne̱ u̱ ya'ag-u̱ u̱n ne̱ u̱ ne̱ta-u̱t u̱n ne̱, u̱ no̱m-tu̱ u̱n o̱tte̱ bu-u̱t u̱n ne̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakubu zu̱ Simiyo̱n e̱ Re̱wi, <<No̱ hattu̱n me̱ swa-u̱ u̱r-ko̱b. No̱ wa'ag u̱m shu̱'u̱te̱ no̱m u̱t-gu̱gu̱m u̱du̱ ne̱t-tu̱ Kan'ana u̱ ne̱t-tu̱ Periziya-ne̱, ne̱t-tu̱ o̱ u̱ shu̱'u̱t u̱ dak-u uno̱. In za u-tát da, a u̱n same̱ ne̱t-u̱t u̱n, u̱n he̱e̱se̱ me̱ m-dum, u̱nu̱ ho̱ me̱ u̱ bu-u ri ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Se̱ u̱n shu̱s u̱n zu̱, <<It zaar u̱ yage̱ u̱n no̱mu̱ du̱-dim-u̱ it iya da. Dina a gwu̱p wa wu̱ ko̱wan do̱'e̱ m-roog u̱ wa ne̱ da.>> ");
INSERT INTO gel_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ru̱-u̱ zu̱ Yakubu, <<Yu̱ne̱ bo̱ zo̱ng bo̱ aru̱k m-mu̱ Be̱te̱r bo̱ shu̱'u̱t u̱ku̱n. Bo̱ ma-u̱ u-Ru̱ be-du̱ to̱o̱g wu̱ haane̱ u̱du̱ ró da-u̱ bo̱ so̱me̱ du̱gu̱-du̱ hu̱no-u ró Isuwa.>> ");
INSERT INTO gel_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yakubu zu̱ ne̱t-tu̱ u-bu wa u̱ ne̱t-tu̱ o̱ u̱r-kot u̱ wa ne̱, <<U̱ ko̱wan u̱ ru̱st ham-u̱t tu̱ u̱t-ru̱ tu̱ za u̱r-fat tu̱ wa o̱ u̱ to̱ ne̱, tu̱msu̱ mu̱u̱tu̱n hi-u̱r no̱ u-he̱n ne̱ tu̱msu̱ no̱ swase̱ cwu̱-tu̱ u-war u̱ no̱. ");
INSERT INTO gel_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Yu̱nu̱n in no̱ko̱n m-ha u̱ Be̱te̱r, be-du̱ u̱m do̱te̱ ma-u̱ u-Ru̱ u̱r-sak du̱ to̱o̱g, wu̱ o̱nke̱ ko̱n-u̱s ri da-u̱ u̱m o̱o̱ge̱ u̱ swadu̱ u̱r-ko̱b wu̱ o̱o̱ge̱ u̱r-kot ne̱ ko̱he̱ne̱ o̱ u̱m hu̱u̱te̱.>> ");
INSERT INTO gel_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Se̱ u̱n yasu̱ Yakubu ham-u̱t tu̱ u̱t-ru̱ tu̱ u̱n o̱tte̱ u̱ no̱m-tu̱ u̱t-to̱ u̱n ne̱. Yakubu ku̱b no̱m-u̱t to̱ wa taku̱s u-dak u̱ kug-du̱ yaku̱n teyu̱ u-kwu̱k ya u̱ bo̱-u̱ She̱ke̱m. ");
INSERT INTO gel_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Da-u u̱n zo̱nge̱ u̱n aru̱k, se̱ gye̱r-u̱ haan du̱gu̱-du̱ u-Ru̱ maas ne̱t-tu̱ bo̱-tu̱ kit-su̱ bo̱-u o̱ u-be̱e̱t waku̱n kerge̱ no̱m-du̱ m-dum u̱ Yakubu ne̱ da. ");
INSERT INTO gel_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakubu u̱ ne̱t-tu̱ o̱o̱ge̱ u̱r-kot u̱ wa ne̱ haan u̱ bo̱-u̱ Ruz (u̱ na zu̱ye̱ Be̱te̱r) u̱ dak-u̱ Kan'ana. ");
INSERT INTO gel_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yakubu mu̱ be-du̱ to̱o̱g, u̱ku̱n wa te̱'e̱ de̱ u̱r-dim Er-Be̱te̱r, (no̱m-u̱ na zu̱ye̱, u-Ru̱ u̱ Be̱te̱r) remu̱ zu̱ ku̱na Ru̱-u̱ hatu̱n u̱du̱ wu̱n u̱ku̱n da-u̱ wa o̱o̱ge̱ u̱ so̱m-mu̱ o̱r-u̱ wa Isuwa. ");
INSERT INTO gel_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Da-u̱ Debora wu̱ wu̱rge̱ Rebeka mare̱, se̱ na dok wa u̱ kug-du̱ te̱-yu̱ u-kwu̱k u-ta u̱ Be̱te̱r ne̱. Se̱ na fog dim-du̱ be-u̱r re̱ Aron-bekot (na zu̱ <<te-yu̱ u-kwu̱k yu̱ u̱s-kan>>). ");
INSERT INTO gel_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Da-u̱ Yakubu mu̱ne̱ du̱gu̱ Padan-Aram, Ru̱-u̱ sur m-haan u̱du̱ wu̱n, wa wa'-u̱ wu̱n nu-u so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ru̱-u̱ zu̱ wu̱n, <<Dim-u̱r ró de̱ na zu̱ye̱ Yakubu se̱di na zamu̱n u̱t-swu̱r m-fag bo̱ Yakubu da. Du̱gu̱ da-o̱ dim-u̱r ró do̱'e̱ u̱t-shu̱'u̱t Isra.>> Ru̱-u te̱'e̱ wu̱n u̱r-dim Isra. ");
INSERT INTO gel_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ru̱-u̱ zu̱, <<Me̱ wa Ru̱-u̱ o̱tte̱ u̱r-be̱b du̱ ko-uyan. No̱m u̱r-mat u̱ bo̱ kum yaag u-tát, u̱t-dak u-tát to̱ de̱ rwu̱u̱n, faru̱k-tu̱ do̱'e̱ u̱ rwu̱u̱n du̱gu̱ ya'ag-u̱ ró. ");
INSERT INTO gel_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tu̱msu̱ me̱ ya'u̱ bo̱ dak-u̱ u̱m tame̱ ya-du̱ Ibrahi ne̱ e̱ Ishaku. Me̱ ya'u̱ bo̱ dak-u o̱ u̱du̱ ya'ag-u̱ ró I do̱'e̱ haan u̱ dim-u̱ ró.>> ");
INSERT INTO gel_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ru̱-u̱ aru̱k wa yagu̱ wu̱n u̱ku̱n u̱ be-du̱ wa nomte̱ u̱s-rem u̱ wu̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakubu ser taar-u̱r yadde̱ u̱ka ta'ar-du̱ u̱t-hu̱ktin wa yu̱nu̱s de̱ m-kim be-du̱ Ru̱-u̱ nomte̱ u̱s-rem u̱ wa ne̱, se̱ wa agu̱z ke̱ u̱-do̱m sha-mu̱ ya-du̱ to̱o̱g u̱ no̱m-tu̱ u̱t-swa ne̱ u̱-do̱m, wa daas m-no̱o̱g u̱-do̱m tu̱msu̱. ");
INSERT INTO gel_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakubu fu̱g be-du̱ Ru̱-u̱ nomte̱ u̱s-rem u̱ wa ne̱ Be̱te̱r. ");
INSERT INTO gel_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Se̱ u̱n aru̱k u̱n yage̱ Be̱te̱r. Tun u̱n o̱ m-ra u̱ bo̱-u̱ Eparat ne̱, Rahira he̱e̱se̱ re̱mu̱ u̱t-me̱n tu̱ u̱r-mat wa so̱ u̱r-ko̱b so̱k. ");
INSERT INTO gel_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Da-u̱ wa swa u̱r-ko̱b u̱du̱ u̱r-mat, ne̱ta wu̱ gwat-du̱ wu̱n u̱du̱ u̱r-mat zu̱ wu̱n, <<A-bo̱ ho̱g u-gye̱r da, u̱ da-o̱ bo̱ swu̱ru̱g m-kwu̱m ya-du̱ u̱r-campa de̱.>> ");
INSERT INTO gel_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Da-u̱ Rahira o̱o̱ge̱ u̱ mo̱ttu̱ m-mar, se̱di u̱ vu̱'e̱ su̱ m-vaste̱ wa, wa fu̱g dim-du̱ ya-du̱ u̱r-campa wa Benomi (no̱m-u̱ na zu̱ye̱ iya, <<Wa'-u̱ swadu̱ u̱r-ko̱b>>). U̱so u̱r-ya fu̱g u̱r-ya Banyamin (na zu̱ <<Wa'-u̱ kom u̱t-cwa u̱ ri>>). ");
INSERT INTO gel_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rahira mu̱ru̱s na dok wa u̱ fu̱n-yu̱ ha-mu̱ Eparat (na zu̱ Be̱tarami). ");
INSERT INTO gel_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakubu ser u̱r-ta'ar du̱ u̱t-baku̱s u̱ saag-u Rahira, had da-o̱ ta'ar-u̱r re̱ o̱mo̱n u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isra sur m-hikne̱ wa do̱'e̱ wa ser u̱r-rimpa u̱ Migdar Edar. ");
INSERT INTO gel_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Da-u̱ Isra o̱o̱ge̱ u̱ shu̱'u̱t u̱ku̱n, Rube̱n roog u̱ Biru̱ha ne̱, ne̱ta u̱r-kit u̱ u̱so wa. Yakubu hog rem-u̱s se̱ za naas u-da. Yakubu o̱tte̱ ya'ag-u̱ campa-ne̱ o̱p u̱ yu̱r. ");
INSERT INTO gel_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Yaag-u̱ campa-ne̱ Riya: Rube̱n (mat-du̱ u-shu̱ Yakubu), u̱ Simiyo̱n, u̱ Re̱wi, u̱ Yahuda, u̱ Issakar, u̱ Ze̱burun. ");
INSERT INTO gel_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Yaag-u̱ campa-ne̱ Rahira o̱: Yusuhu u̱ Banyamin. ");
INSERT INTO gel_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Yaag-u̱ campa-ne̱ Biru̱ha, to̱k-u̱ Rahira o̱: Dan u̱ Napari. ");
INSERT INTO gel_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Yaag-u̱ campa-ne̱ Zirpa, to̱k-u̱ Riya o̱: Gad u̱ Ashu̱r. Tun-to̱ to̱ o̱o̱ge̱ dim-tu̱ ya'ag-u̱ campa-ne̱ Yakubu e̱ na matu̱ wa u̱ Padan-Aram. ");
INSERT INTO gel_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakubu haan u-bu u̱du̱ u̱so wa Ishaku u̱ Mamre, u̱ dapu̱s Kiriyat Arba (u̱ na zu̱ye̱ He̱bro̱n), be-du̱ Ibrahi ne̱ e̱ Ishaku shu̱'u̱te̱. ");
INSERT INTO gel_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ishaku no̱ng u̱s-hak u̱t-shik u̱t-jwu̱r 180. ");
INSERT INTO gel_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Ishaku no̱m vu̱'e̱ su̱ m-vaste̱ wa, wa mu̱ru̱s wa bit u̱so-tu̱ u̱so-u̱t wa. Wa no̱ng u̱s-hak u-tát, ya'ag-u̱ campa-ne̱ wa Isuwa ne̱ e̱ Yakubu dok wa. ");
INSERT INTO gel_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Unto̱ to̱ o̱o̱ge̱ ogu̱r-tu̱ ko̱-u̱r Isuwa (Tu̱msu̱ wa na fu̱ge̱ Edo̱m). ");
INSERT INTO gel_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Isuwa gaan ya-u̱t-gwu̱p yu̱r du̱gu̱ Kan'ana: Ada, gwu̱p-u̱ Ero̱n ya-He̱t-ne̱, u̱ O̱ho̱ribama, gwu̱p-u̱ A-na tu̱msu̱ wa'-u̱ wa'-u̱ Zibe̱yon wa-Hiwi-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Isuwa sur m-ga ne̱ta u-tu̱tu̱rse̱ wu̱ na foge̱ Basemat. Basemat wa o̱o̱ge̱ gwu̱p-u̱ Ismaru tu̱msu̱ du̱-dim-u̱ Nebayo̱t. ");
INSERT INTO gel_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada matu̱ Isuwa Eripa, Basemat mu̱t Re̱we̱r. ");
INSERT INTO gel_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Tu̱msu̱ O̱ho̱ribama mu̱t ya'ag-u̱ campa-ne̱, Jewus, Jaram, u̱ Kora ne̱. Yaag-u̱ campa-ne̱ e̱ be̱e̱t na mak-tu̱ Isuwa e̱ dak-u̱ Kan'ana. ");
INSERT INTO gel_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Isuwa ku̱b ne̱ta-u̱t wa, u̱ ya'ag-u̱ wa ne̱ u̱ no̱m-tu̱ u-bu wa ne̱ u̱t-be̱e̱t bisa-u̱t wa ne̱, u̱ no̱m-tu̱ u̱t-kom-u̱ wa kume̱ u̱ dak-u̱ Kan'ana u̱t-be̱e̱t, wa hate̱ m-ra du̱gu̱-du̱ hu̱no̱ wa Yakubu. ");
INSERT INTO gel_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Remu̱ tat-u̱ bisa-u̱t u̱n, za u̱t-no̱me̱ u̱n shu̱'u̱t u̱r-be u̱r-gan da, be-du̱ u̱n o̱tte̱ u̱ shu̱'u̱t de̱ zaar u̱ ko̱ru̱ u̱n be̱e̱t da. ");
INSERT INTO gel_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Isuwa (wu̱ na zu̱ye̱ Edo̱m) shu̱'u̱t u̱ gas-u̱ ro̱r-tu̱ dak-u̱ Seyir. ");
INSERT INTO gel_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Unto̱ o̱o̱ge̱ ogu̱r-tu̱ ya'ag-u̱ Isuwa, ne̱t-u̱ Edo̱m, wu̱ o̱o̱ge̱ u̱ shu̱'u̱t u̱ gas-u̱ ro̱r-tu̱ dak-u̱ Seyir. ");
INSERT INTO gel_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Dim-tu̱ ya'ag-u̱ campa-ne̱ Isuwa ya: E̱ripaz (wa'-u̱ Ada ne̱ta Isuwa) u̱ Re̱we̱r (wa'-u̱ Basemat ne̱ta Isuwa). ");
INSERT INTO gel_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Yaag-u̱ campa-ne̱ E̱ripaz: Te̱man, u̱ O̱mar, u̱ Ze̱paho, u̱ Gatama, u̱ Kenaz. ");
INSERT INTO gel_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Eripaz o̱tte̱ ne̱ta u̱r-kit wu̱ na foge̱ Timu̱na. Wa mate̱ Amare̱k wu̱ o̱o̱ge̱ ne̱ta u̱s-kit E̱ripaz. E̱ o̱o̱ge̱ ya'ag-u̱ ya'ag-u̱ campa-ne̱ i ne̱ta Isuwa Ada. ");
INSERT INTO gel_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Yaag-u̱ campa-ne̱ Re̱we̱r: Nahat, u̱ Zera, u̱ Shamma, u̱ Miza. Ine̱ e̱ o̱ ya'ag-u̱ ya'ag-u̱ ne̱ta Isuwa Basemat. ");
INSERT INTO gel_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Yaag-u̱ campa-ne̱ ne̱ta Isuwa O̱ho̱ribama gwu̱p-u̱ Ana tu̱msu̱ wa'-u̱ wa'-u̱ Zibe̱yon, e̱ wa mate̱ Isuwa: Jewus, u̱ Jaram, u̱ Kora ne̱. ");
INSERT INTO gel_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ine̱ e̱ o̱o̱ge̱ u̱t-faru̱k u̱ te̱k-u̱ ya'ag-u̱ Isuwa wu̱ shu̱'u̱te̱ yu̱-Yat-ya u̱t-ko̱ u-tát. Yaag-u̱ campa-ne̱ E̱ripaz mat-du̱ u-shu̱ Isuwa, Wa shu̱'u̱te̱ yu̱-Yat-ya ko̱-u̱r Te̱man, O̱mar, Ze̱paho, Kenaz, ");
INSERT INTO gel_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","u̱ Kora, u̱ Gatama, u̱ Amare̱k ne̱. Ine̱ e̱ o̱o̱ge̱ i-yate̱ u̱r-ko̱ dak-u̱ Edo̱m wu̱ rwu̱ne̱ du̱gu̱ E̱ripaz. Ine̱ be̱e̱t e̱ o̱o̱ge̱ ya'ag-u̱ ya'ag-u̱ Ada. ");
INSERT INTO gel_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Yaag-u̱ campa-ne̱ wa'-u̱ Isuwa Re̱we̱r: Nahat, u̱ Zera, u̱ Shamma, u̱ Miza ne̱. Ine̱ i-yate̱ ko̱du̱ rwu̱ne̱ du̱gu̱ Re̱we̱r Edo̱m; e̱ o̱o̱ge̱ ko̱-du̱ ya'ag-u̱ ne̱ta Isuwa Basemat. ");
INSERT INTO gel_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Yaag-u̱ campa-ne̱ ne̱ta Isuwa Ohoribama: Yu̱-Yat-ya Jewus, u̱ Jaram, u̱ Kora ne̱. E̱ o̱o̱ge̱ i-yate̱ i rwu̱ne̱ du̱gu̱ ne̱ta Isuwa O̱ho̱ribama gwu̱p-u̱ Ana. ");
INSERT INTO gel_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ine̱ o̱ ya'ag-u̱ campa-ne̱ Isuwa (wu̱ na zu̱ Edo̱m), tu̱msu̱ tunto̱ o̱ faru̱k-u̱t e̱. ");
INSERT INTO gel_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Tunto̱ o̱ dim-tu̱ u̱t-ko̱ tu̱ ya'ag-u̱ campa-ne̱ i rwu̱ne̱ du̱gu̱-du̱ Seyir ya-Ho̱ri-ne̱, e̱ o̱ u̱ shu̱'u̱t u̱ dak-u̱ Edo̱m: Ro̱tan, Shobar Zibe̱yon, Ana, ");
INSERT INTO gel_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, u̱ Dishan. Ine̱ o̱ i-yate̱ ko̱-du̱ ya'ag-u̱ campa-ne̱ Hori, ya'ag-u̱ Seyir, e̱ o̱ shu̱'u̱t u̱ dak-u̱ Edo̱m. ");
INSERT INTO gel_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Yaag-u̱ campa-ne̱ Ro̱tan e̱ o̱: Hori u̱ Heman, hu̱no̱-u ya-i ne̱ta Ro̱tan wa na zu̱ye̱ Timna. ");
INSERT INTO gel_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Yaag-u̱ campa-ne̱ Shobar: Arban, Manahat, Ebar, Shepaho, u̱ Onam ne̱. ");
INSERT INTO gel_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Yaag-u̱ campa-ne̱ Zibe̱yon e̱ o̱: Aya u̱ Ana. A-na wu̱ hyane̱ fu̱g-su̱ m-pe̱r yu̱ bu̱-mu̱ m-du̱ng u̱r-do̱g da-u̱ wa o̱o̱ge̱ u̱ gwat-du̱ janka u̱so wa. ");
INSERT INTO gel_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana o̱tte̱ yaag yu̱r: Ya-du̱ u̱r-campa na zu̱ wa Dishon tu̱msu̱ ya-du̱ u̱r-gwu̱p na zu̱ wa O̱ho̱ribama. ");
INSERT INTO gel_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Yaag-u̱ campa-ne̱ Dishon e̱ o̱: Hemadan, Eshaban, Itaran, u̱ Keran. ");
INSERT INTO gel_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Yaag-u̱ campa-ne̱ Ezer e̱ o̱: Birhan, Zaaban, u̱ Akan ne̱. ");
INSERT INTO gel_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Yaag-u̱ campa-ne̱ Dishan e̱ o̱: Uz u̱ Aran ne̱. ");
INSERT INTO gel_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ine̱ e̱ o̱ i-yate̱ ko̱-du̱ Hori: Ro̱tan, Shobar, Zibe̱yon, Ana, ");
INSERT INTO gel_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Ezer, u̱ Dishan. Na panu̱g dim-tu̱ ko̱-u̱r Hori u̱ dim-tu̱ i-yate̱ ne̱, e̱ o̱ u̱ shu̱'u̱t u̱ dak-u Seyir. ");
INSERT INTO gel_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Tunto̱ o̱ dim-tu̱ u̱t-faru̱k tu̱ o̱o̱ge̱ u̱r-faru̱k u̱ dak-u̱ Edo̱m kanda waku̱n faru̱k wa no̱m u̱r-faru̱k dak-u̱ Isra: ");
INSERT INTO gel_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bera (zwaru̱ Beyor), wa shu̱'u̱t faru̱k-du̱ Edo̱m. Dim-du̱ bo̱-u na zu̱ye̱ Dinahaba. ");
INSERT INTO gel_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Da-u̱ Bera mare̱, Jobab zwaru̱ Zera du̱gu̱ Bozara, wa shu̱'u̱t u̱r-faru̱k. ");
INSERT INTO gel_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Da-u̱ Jobab mare̱, Husan du̱gu̱ dak-u̱ Tema-ne̱ wa du̱u̱s u̱r-faru̱k. ");
INSERT INTO gel_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Da-u̱ Husan mare̱, Hadad zwaru̱ Bedad wu̱ re̱ bo̱-u̱ Midiya dak-u̱ Mowab, wa re̱ u̱r-faru̱k. Dim-du̱ bo̱-u wa o̱ na zu̱ye̱ Afit. ");
INSERT INTO gel_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Da-u̱ Hadad mare̱, Samara wu̱ rwu̱ne̱ du̱gu̱ bo̱-u̱ Masare̱ka wa shu̱'u̱t faru̱k. ");
INSERT INTO gel_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Da-u̱ Samara mare̱, Shawuru wu̱ rwu̱ne̱ du̱gu̱ bo̱-u̱ Rehobot u̱ Gas-u̱ gi-yu̱ Yufiretis wa shu̱'u̱t faru̱k. ");
INSERT INTO gel_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Da-u̱ Shawuru mare̱, Baar-hanan (zwaru̱ Akubor) wa du̱u̱s u̱r-faru̱k. ");
INSERT INTO gel_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ba Baar-hanan zwaru̱ Akubor mare̱, Hadar shu̱'u̱t faru̱k, dim-du̱ bo̱-u wa na zu̱ye̱ Pawa. Dim-du̱ ne̱ta wu̱n de̱ na zu̱ye̱ Mehetaber gwu̱p-u̱ Matad, gwu̱p-u̱ Mezahab. ");
INSERT INTO gel_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Tun-to̱ to̱ o̱ dim-tu̱ i-yate̱ i rwu̱ne̱ du̱gu̱-du̱ Isuwa, i o̱o̱ge̱ u̱ shu̱'u̱t u̱t-be e̱ te̱'e̱ u̱ka ko̱-u̱t e̱: Timna, Arba, Jetet, ");
INSERT INTO gel_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Ohoribama, Era, Pinon, ");
INSERT INTO gel_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Ke̱naz, Te̱man, Mibazar, ");
INSERT INTO gel_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magadiyer u̱ Iram ne̱. E̱ o̱o̱ge̱ i-yate̱ Edo̱m, u̱ e̱ o̱tte̱ u̱ shu̱'u̱t u̱ dak-u̱ e̱ o̱tte̱. Isuwa o̱o̱ge̱ u̱so u̱ Edo̱m-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakubu shu̱'u̱t u̱ dak-u̱ Kan'ana, be-du̱ u̱so wa tamte̱ shu̱'u̱t-du̱ u̱r-hamu̱t. ");
INSERT INTO gel_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ogor-tu̱ ya'ag-u̱ Yakubu ya: Da-u̱ Yusuhu o̱o̱ge̱ u̱s-hak o̱p u̱s-ta'e̱r 17, wa o̱ u̱ gwat-du̱ ban-du̱ u̱t-bisa u̱ tu̱-wu̱to̱ wa ne̱, ya'ag-u̱ campa-ne̱ Biru̱ha u̱ ya'ag-u̱ campa-ne̱ Zirpa, ne̱ta-tu̱ u̱so-u wa, se̱ wa haatu̱n u̱so e̱ rem-su̱ za so̱-se̱ u̱ mo̱ttu̱ no̱mu̱ tu̱-wu̱to̱ wa o̱o̱ge̱ u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isra cwanu̱g Yusuhu m-ze̱g ya'ag-u̱ campa-ne̱ wa be̱e̱t, remu̱ zu̱ wa matu̱k wa' u̱ da-u̱ ne̱nge̱n-u̱r wa. Isra no̱mu̱ Yusuhu to̱ggo̱-u so̱-ya. ");
INSERT INTO gel_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Da-u̱ tu̱-wu̱to̱ wa hyane̱ u̱zu̱ u̱so-u e̱ ze̱k-u̱ cwan-u̱t wu̱n, e̱ gu̱gu̱m wu̱n. E̱ no̱mtu̱ wu̱n rem-u̱s so̱-se̱ da. ");
INSERT INTO gel_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yusuhu nom bo' da-u̱ wa ware̱ tu̱-wu̱to̱ wa ne̱ bo'u̱ wa no̱me̱, e̱ sur m-gu̱gu̱m wa. ");
INSERT INTO gel_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Wa zu̱ u̱n <<Ho̱go̱n bo'u̱ u̱m no̱me̱. ");
INSERT INTO gel_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Da-u̱ in o̱o̱ge̱ u̱ gu̱gu̱r-du̱ gu̱g-tu̱ fat u-tak se̱ du̱ ri gu̱g-de̱ yu̱ne̱ u̱r-ees m-kim, da-u o̱ tu̱ no̱ gu̱g-to̱ haane̱ to̱ gu̱nu̱s du̱ ri gu̱g-de̱ to̱ kwu̱ku̱t u-dak.>> ");
INSERT INTO gel_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Tu̱-wu̱to̱ wu̱n zu̱ wu̱n, <<¿Bo̱ u̱t-sa bo̱ shu̱'u̱t faru̱k u̱-do̱mu̱ it? ¿Bo̱ u̱t-gwat u̱zu̱ bo̱ u̱t-shu̱'u̱t faru̱k-u̱ it?>> Se̱ e̱ sur m-gu̱gu̱m wu̱n remu̱ bo'u̱ wa no̱me̱ u̱ no̱m-u̱ wa waru̱ e̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Da tase̱ sur m-no̱m o̱ko̱n bo' o̱. Wa waru̱ tu̱-wu̱to̱ bo'-u̱ o̱, wa zu̱, <<Ho̱go̱n, u̱m swu̱ru̱g m-no̱m o̱ko̱n bo' o̱, se̱di u̱ uno̱ da-o̱, u̱r-ho̱, u̱ pyaat ne̱, u̱ re̱ge̱r ne̱ o̱p-u̱ yu̱r e̱ he u̱t-jwu̱n u̱ shu̱ ri.>> ");
INSERT INTO gel_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Uno̱ da-o̱ wu̱n wargu̱ u̱so rò bó̱-u̱ o̱ u̱ka wa wartu̱ o̱r-u̱t wa ne̱, se̱ u̱so wu̱n hagu̱sse̱ wu̱n. Wa zu̱ wu̱n, <<¿Bo̱ m-hyan u̱zu̱ ino̱ ró u̱-me̱ ne̱ u̱ tu̱-wu̱to̱ ró ne̱ it-u̱ u̱t-haan it he̱ u̱t-jwu̱n u-dak u̱-shu̱ ró?>> ");
INSERT INTO gel_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Se̱di tu̱-wu̱to̱ Yusuhu o̱ u̱r-shu̱b, u̱so wu̱n hu̱ u̱s-dorog u̱zu̱, yan-o̱ bo'u̱ no̱ o̱o̱ge̱ u̱t-zu̱. ");
INSERT INTO gel_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","De̱ku̱n ho̱-de̱ o̱r-u̱t wu̱n o̱ u̱ gwat-du̱ ban-du̱ u̱t-bisa tu̱ u̱so e̱ u̱ She̱ke̱m. ");
INSERT INTO gel_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Isra zu̱ Yusuhu, <<U̱ka bo̱ nu̱pte̱, tu̱-wu̱to̱ ró o̱ u̱ gwat-du̱ u̱t-bisa u̱ dapu̱s She̱ke̱m. Zo̱nge̱ u̱m to̱m bo̱ u̱du̱ e̱.>> Wa zu̱ wu̱n, <<U̱m zo̱ngte̱.>> ");
INSERT INTO gel_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Se̱ u̱so u̱n zu̱ wu̱n, <<De̱'e̱, bo̱ hyan tu̱-wu̱to̱ ró ne̱ u̱ ban-du̱ u̱t-bisa ne̱ u̱ka e̱ o̱tte̱, se̱ bo̱ mu̱n bo̱ waru̱ me̱ u̱ka e̱ o̱tte̱.>> Yakubu tom Yusuhu du̱gu̱ fu̱g-yu̱ He̱bro̱n m-ha Gas-u̱ She̱ke̱m. Da-u̱ Yusuhu teye̱ bo̱-u̱ She̱ke̱m, ");
INSERT INTO gel_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","waku̱n ne̱t wa hyen wu̱n u̱t-riig u̱r-do̱g wa shit wu̱n, wa zu̱ wu̱n, <<¿Yan-o̱ bo̱ o̱o̱ge̱ u̱t-goot?>> ");
INSERT INTO gel_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusuhu zu̱, <<U̱m o̱ gotu̱ tu̱-wu̱to̱ ri ne̱. Gag jab, ¿ko̱ bo̱ waru̱ me̱ be-du̱ e̱ o̱tte̱ u̱ gwat-du̱ u̱t-bisa?>> ");
INSERT INTO gel_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Se̱ ne̱t-u̱ wa zu̱ wu̱n, <<U̱, u̱n yu̱nge̱ du̱gu̱ ane̱, se̱di u̱m ho̱k u̱n o̱ u̱t-zu̱, <Yage̱ in de̱'e u̱ gas-u̱ Dotan.> >> Se̱ Yusuhu dor o̱r-u̱t wa ne̱ m-ha Dotan, wa bit u̱n u̱ku̱n u̱ Dotan. ");
INSERT INTO gel_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Da-u̱ o̱r-u̱t Yusuhu hyanne̱ wa u̱ daan, e̱ nu̱p wa du̱gu̱ m-ra. Da-u̱ wa no̱mne̱ u̱t-mo̱r u̱ u̱n ne̱, u̱n gu̱g nu-u̱t u̱n u̱zu̱ u̱n ho̱ Yusuhu. ");
INSERT INTO gel_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","U̱n zu̱ o̱r-u̱t u̱n ne̱, <<Wa-bo'-u̱ wa ya jit u̱ o̱ne̱. ");
INSERT INTO gel_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Haanu̱n, yagu̱n in ho̱o̱n wu̱n na guns wu̱n u̱ me̱n-tu̱ u̱r-gan u̱-me̱ du̱-u̱t tun-to̱ se̱ na zu̱ no̱m-yu̱ u̱r-do̱g hooste̱ wu̱n. Na hyan ma-du̱ bo'-u̱ wu̱n u̱ka o̱ do̱te̱ u̱t-no̱m!>> ");
INSERT INTO gel_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Da-u̱ Rube̱n ho̱ge̱ no̱m-u̱ u̱n o̱ u̱t-sa u̱t-no̱m, wa su̱ wa ruut wu̱n du̱gu̱ kom-u̱t u̱n, Rube̱n zu̱ u̱n, <<Ana ho̱ wu̱n da. ");
INSERT INTO gel_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ana agu̱z m-hyu̱ da. Gunsu̱n wu̱n u̱ me̱n-tu̱ ut-u̱r u̱r-dù u̱ ane̱ u̱-me u̱r-do̱g, se̱di taas u̱ waku̱n o̱ m-tam wu̱n da.>> Rube̱n zu̱u̱g iya remu̱ u̱zu̱ wa ruut te̱ wu̱n m-yasa du̱gu̱-du̱ e̱ u̱ wa muut wu̱n u̱du̱ u̱so wu̱n. ");
INSERT INTO gel_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Da-u̱ Yusuhu teene̱ be-du̱ o̱r-u̱t wa ne̱ o̱tte̱, se̱ e̱ kemu̱sse̱ to̱ggo̱-u so̱-ya yu̱ wu̱n o̱tte̱ m-wa e̱ host ya. ");
INSERT INTO gel_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Se̱ u̱n ku̱b wa, u̱n guns wa u̱ me̱n-tu̱ u̱r-dù du̱ zatte̱ m-bu̱ da, bu̱-mu̱ zaar de̱ da. ");
INSERT INTO gel_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","U̱n o̱ u̱ shu̱'u̱t u̱ re̱-du̱ no̱m u̱t-re̱, se̱ u̱n jaku̱s is u̱n hyan ban-du̱ Isma'iru-ne̱ a-u-ce̱rpa-ne̱, e̱ o̱o̱n du̱gu̱ Giriyad. E̱ gakku̱n rakum-u̱ e̱ cwu̱-tu̱ wu̱s u-haku̱n ne̱ u̱t-go̱ u̱t-go̱, u̱ no̱o̱g-mu̱ mu̱r ne̱, e̱ o̱ do̱m-u̱ u-fu̱n u̱ hu̱u̱tu̱ to̱ u̱ Masar u̱t-bab. ");
INSERT INTO gel_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yahuda zu̱ hu̱no̱-u̱t wa, <<¿Yan swu̱rmo̱ in do̱'e̱ u̱t-kwu̱m a in ho̱o̱n o̱r-u̱ in tu̱msu̱ in taku̱s hyu̱-m wa? ");
INSERT INTO gel_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Haanu̱n, in bu̱pu̱s wu̱n u̱du̱ ne̱t-u̱ Isma'iru-ne̱. A in o̱ m-tam wu̱n da, ba shu̱'u̱te̱ o̱r-u̱ in wa u o̱ye̱. War-u in o̱ u̱ hyu̱-m in ne̱.>> O̱r-u̱t wu̱n ees u̱ no̱mu̱ wu̱n waru̱ e̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Da-u̱ ne̱tu̱ u-ce̱rpa tu̱ Midiya-ne̱ ne̱ haane̱, tu̱-wu̱to̱ Yusuhu rwu̱tu̱n wa du̱gu̱ ut-u̱ u̱r-dù. E̱ bu̱pu̱s wa u̱du̱ ne̱t-u̱t to̱ kwam-u̱t pus-to̱ shik u̱r-shik 20, na ku̱b wa m-cwa u̱ Masar. ");
INSERT INTO gel_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Da-u̱ Rube̱n barme̱ u̱ be-du̱ du-u̱r re̱ wa hyanu̱g Yusuhu da, se̱ wa kemu̱sse̱ cwu̱-tu̱ u-war u̱ wa u̱ remu̱ namu̱ jab. ");
INSERT INTO gel_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Wa aru̱k m-mu̱ u̱du̱ o̱r-u̱t wa ne̱ wa zu̱ e̱, <<Wa'-u̱ wa zamu̱n u̱ku̱n da, u̱ da-o̱ ¿re̱-o̱ u̱m do̱te̱ u̱t-no̱m?>> ");
INSERT INTO gel_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Se̱ o̱r-u̱t Yusuhu ho gobor-du̱ u-gwaar, e̱ guns to̱ggo̱-u Yusuhu hyu̱-mu̱ u-gwaru̱ mo̱. ");
INSERT INTO gel_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","U̱n ku̱b to̱ggo̱-u so̱-ya ya u̱n muutu̱ u̱so u̱n tu̱msu̱ u̱n zu̱, <<It kwu̱mu̱g to̱ggo̱-u inya. Gwat bo̱ hyan ko̱ to̱ggo̱-yu̱ zwaru̱ ró ya re̱.>> ");
INSERT INTO gel_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Wa nu̱p ya. Wa zu̱, <<To̱ggo̱-yu̱ zwaru̱ ri ya, yaku̱n no̱m-yu̱ u̱r-do̱g tu̱u̱ste̱ wa, za u-sakna na tu̱u̱ste̱ Yusuhu.>> ");
INSERT INTO gel_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakubu kemu̱sse̱ to̱ggo̱-yu̱ u-waru̱ wa. Wa wu̱ cwu̱-tu̱ ko̱se̱-du̱ namu̱ jab wa no̱m m-roog u-tát wa o̱ dorog-u̱s Yusuhu. ");
INSERT INTO gel_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Yaag-u̱ wa be̱e̱t e̱ haan e̱ ru̱stu̱ wa jab, se̱di e̱ kerge̱ ru̱stu̱ jab-u̱ wa da. Wa zu̱, <<U̱ te̱k-u̱ namu̱ jab se̱, u̱m he̱e̱g u-sag u̱ be-du̱ zwaru̱ ri o̱tte̱.>> Se̱ wa nom u̱s-kan u̱ remu̱ Yusuhu. ");
INSERT INTO gel_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Da tase̱, ne̱t-tu̱ Midiya-ne̱ e̱ bu̱pse̱ Yusuhu u̱du̱ Potipa wu̱ o̱o̱ge̱ u̱ te̱k-u̱ i-yate̱ Faru̱k-u̱ Masar, Po̱tipa wa o̱o̱ge̱ yu̱-Yat-ya e'-du̱ pyu̱. ");
INSERT INTO gel_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","U̱ da-u o̱, Yahuda yage̱ tu̱-wu̱to̱ wa u̱ tu̱-dimu̱ wa ne̱. Wa do̱'e̱ wa shu̱'u̱t u̱du̱ waku̱n campa wa wu̱ bo̱-u̱ Aduram na zu̱ wa Hira. ");
INSERT INTO gel_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ku̱na Yahuda hyente̱ gwu̱p ne̱t-u̱ Kan'ana wa'-u̱ Shuwa. Yahuda gu̱ wa wa roog u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Wa no̱m u̱t-me̱n wa mu̱t ya-du̱ u̱r-campa, na te̱'e̱ wa u̱r-dim Er. ");
INSERT INTO gel_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Wa sur m-no̱m u̱t-me̱n wa mu̱t ya-du̱ u̱r-campa na te̱'e̱ wa u̱r-dim Onan. ");
INSERT INTO gel_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Wa mu̱t tu̱msu̱ ya-du̱ u̱r-campa wa te̱'e̱ de̱ u̱r-dim Shera. U̱ da-u̱ Yahuda o̱ Kezib da-u o̱ wa matu̱ Shera. ");
INSERT INTO gel_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yahuda no̱ngu̱ mat-du̱ u-shu̱ wa Er u̱r-gu̱, na zu̱ ne̱ta wa Tamar. ");
INSERT INTO gel_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Se̱di Er, mat-du̱ u-shu̱ Yahuda, ne̱t-u̱ yo̱-wa wa u̱du̱ Yawe; se̱ Yawe ho wa. ");
INSERT INTO gel_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Se̱ Yahuda zu̱ Onan, <<Rooge̱ u̱ ne̱ta yu̱-wu̱ya ró ne̱, yu̱-wu̱ya ró maru̱g za wa'. Remu̱ iya ga bomsu̱ wa bo̱ roog u̱ wa ne̱ ko̱ bo̱ kwu̱mu̱ yu̱-wu̱ya ró yaag i do̱'e̱ re̱-du̱ o̱g-u̱r wa rem u̱zu̱ iya-o̱ kim-u̱s in zu̱tte̱ bo̱ no̱m.>> ");
INSERT INTO gel_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Se̱di Onan nu̱p u̱zu̱ ya'ag-u̱ e̱ za shu̱'u̱tu̱ ya'ag-u̱ wa da; da-u̱ wa o̱o̱ge̱ m-roog u̱ ne̱ta yu̱-wu̱ya wa ne̱, se̱ wa daas u̱t-bas u-dak u̱ taas wa matu̱ yu̱-wu̱ya wa yaag da. ");
INSERT INTO gel_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Se̱di no̱m-u̱ wa no̱me̱ shu̱'u̱te̱ no̱m-u yo̱-o̱ u̱du̱ Yawe; se̱ wa ku̱b fat-u̱r rò. ");
INSERT INTO gel_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yahuda zu̱ Tamar ku̱mu̱ wa, <<Shu̱'u̱te̱ u̱ka bom-u̱s u̱ bu-u̱ u̱so-u ró, se̱ Shera zwaru̱ ri rogomte̱.>> Wa no̱ng iya remu̱ zu̱ wa no̱ng u̱s-dorog u̱zu̱, <<Wa kere̱ u̱t-mar ko̱wa, u̱ka tu̱-wu̱to̱ wa.>> Se̱ Tamar aru̱k m-mu̱ wa shu̱'u̱t u̱ bu-u̱ u̱so wa. ");
INSERT INTO gel_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Da-u̱ hak-su̱ no̱me̱ u-tát ne̱ta Yahuda, gwu̱p-u̱ Shuwa, maru̱g. Da-u̱ Yahuda tase̱ namu̱ jab, wa do̱'e̱ u̱ Timna, u̱du̱ ne̱t-tu̱ o̱o̱ge̱ o̱rru̱ can-tu̱ ca wa, u̱ hu̱u̱b-u̱ wu̱n ne̱ Hira ne̱tu̱ Aduram wa do̱'e̱ u̱ wu̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Da-u̱ na waru̱ Tamar, <<U̱zu̱ u̱so-u campa rò u̱ fu̱n-yu̱ ha-mu̱ Timna u̱ remu̱ wa or-u̱t ca wa.>> ");
INSERT INTO gel_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamar nak u̱zu̱ Shera rogomte̱, se̱di o̱kon no̱mo̱ zaar u̱ na nome̱ u̱zu̱ u̱ wa haan wa ga wa da. Remu̱ iya wa host cwu̱-tu̱ u̱t-bomos wa ho̱bo̱gse̱ hi-u̱r wa u-ge̱re̱ remu̱ wa e̱ngu̱sse̱ hi-u̱r wa. Se̱ Tamar shu̱'u̱t u̱ kit u-fu̱n yu̱ na tote̱ me̱ bo̱-u re̱k-o̱ u̱ na zu̱ye̱ Enayim, yu̱ o̱o̱ge̱ do̱m-u̱ fu̱n-yu̱ ha-mu̱ Timna. ");
INSERT INTO gel_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Da-u̱ Yahuda hyane̱ wu̱n, wa ku̱b u̱zu̱ wa-u-as wa, remu̱ u̱zu̱ wa ho̱gopte̱ shu̱-u wa u-ge̱re̱. ");
INSERT INTO gel_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Wa nak u̱zu̱ ku̱mu̱ wa da, wa do̱'e̱ u̱du̱ wa u̱ kit-u̱ fu̱n. Wa zu̱, <<Haane̱ u̱m roog-u̱ bo̱ ne̱.>> Se̱ Tamar zu̱, <<¿Yan o̱ bo̱ de̱ ya'u̱ me̱ u̱ bo̱ roogte̱ u̱-me̱ ne̱?>> ");
INSERT INTO gel_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Se̱ wa zu̱, <<Me̱ ya'u̱ bo̱ ya-u gwaar ban-du̱ gwaar-u̱ ri.>> Tamar zu̱, <<¿O̱ko̱n o̱ro u̱ bo̱ do̱'e̱ ya'u̱ me̱ u̱ do̱'e̱ u̱t-shu̱'u̱t u̱s-nap kanda bo̱ to̱mtu̱n me̱ u-gwaar?>> ");
INSERT INTO gel_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Wa zu̱, <<¿Yan go̱-du̱ u̱s-nap se̱ bo̱ u̱t-sa?>> Tamar zu̱ wu̱n, <<Hatu̱n me̱ ko̱m-yu̱ m-ha ró, u-re̱ge̱z yu̱ ge̱ke̱s ne̱ u̱ kwat-yu̱ u-kom u̱ ró ne̱ yu̱ o̱tte̱ dim-u̱r ró ne̱.>> Se̱ wa yase̱ to̱ u̱du̱ wu̱n. Se̱ Yahuda roog u̱ wu̱n ne̱, se̱ Tamar nom u̱t-me̱n du̱gu̱-du̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Da u̱n tase̱, Tamar yu̱ne̱ m-mu̱, wa hast ge̱rre̱-yu̱ wa ho̱pse̱, se̱ wa wu̱ cwu̱-tu̱ u̱t-bomos wa. ");
INSERT INTO gel_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Da tase̱ Yahuda tom hu̱u̱b-u̱ wa Hira ne̱tu̱ Aduram u̱ ya-u gwaar ne̱, u̱ remu̱ wa kabtu̱n no̱m-tu̱ wa yase̱ ne̱ta-u ya, se̱di Hira hyanu̱g Tamar da. ");
INSERT INTO gel_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Se̱ wa shit campa-ne̱ i o̱o̱ge̱ u̱ku̱n, wa zu̱, <<¿He̱ne̱ o̱ kaar-yu̱ be-du̱ m-gir yu̱ o̱o̱ge̱ u̱ ana o̱tte̱, kaar-yu̱ nome̱ u̱t-huuk u̱ Enayim u̱ kit u-fu̱n?>> E̱ zu̱ wu̱n, <<Yaku̱n kaar ya yu̱ be-du̱ m-gir zaar u̱ shu̱'u̱t u̱ ane̱ da.>> ");
INSERT INTO gel_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Se̱ wa mu u̱du̱ Yahuda, wa zu̱, <<U̱m hyanu̱g wu̱n da. Ne̱t-tu̱ o̱ u̱ku̱n e̱ zu̱u̱g, <E̱ tamu̱g nap-du̱ u-kaar o̱ u̱ku̱n u̱ be-du̱ m-gir da.> >> ");
INSERT INTO gel_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yahuda zu̱, <<Yage̱ wa shipu̱s no̱m-tu̱ wa o̱tte̱, taas in shu̱'u̱t no̱mtu̱ u̱t-nu̱mu̱s da. Me̱ ya u̱m tom-u̱t te̱ wu̱n ya-u gwaar yu̱ o̱ yu̱nne̱, se̱di bo̱ hyanu̱g wu̱n da.>> ");
INSERT INTO gel_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Da pyaat-su̱ u̱s-tu̱t arke̱, na waru̱ Yahuda, <<Ku̱mu̱ ró Tamar cwaag u̱ fu̱n-yu̱ m-kaar, u̱ remu̱ iya wa o̱ u̱t-me̱n ne̱.>> Yahuda zu̱, <<Rwu̱tu̱n wu̱n u̱ dim-u u-bo̱, no̱ doos wu̱n u-ra se̱ wa maru̱g.>> ");
INSERT INTO gel_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Da-u̱ na rwu̱tu̱n Tamar u̱ remu̱ na hoot wa, se̱ wa no̱m to̱m u̱du̱ ku̱mu̱wa u̱zu̱, <<Se̱ wa zu̱ u̱m o̱ u̱t-me̱n ne̱ du̱gu̱-du̱ ne̱t wu̱ o̱tte̱ tun-to̱ no̱m-to̱. Gwatu̱n to̱ no hyan ko̱ wana otte̱ to̱. Ko̱m-yu̱ m-ha wa ya u̱ kwat-yu̱ u-kom u̱ wa ne̱ u̱ re̱ge̱z yu̱ ge̱ku̱s wa ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Se̱ Yahuda baku̱s no̱m-u̱t to̱. Wa zu̱ iya o̱ <<Wu̱n ze̱k me̱ u̱r-mo̱t, remu̱ zu̱ u̱m yaag wu̱n wa'-u̱ ri Shera wa ga wu̱n da. U̱m no̱m-u̱g no̱mu so̱-o̱ da.>> Wa swu̱ru̱g m-roog u̱ wu̱n ne̱ tu̱msu̱ da. ");
INSERT INTO gel_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Da da-u̱ u̱r-mat no̱me̱, se̱ Tamar mu̱t ya-u̱t-zwar yu̱r. ");
INSERT INTO gel_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Da-u̱ wa o̱o̱ge̱ u̱r-mat, wa-gan rwu̱tu̱n ko̱m-u wa u̱-do̱; Se̱ wu̱ o̱o̱ge̱ u̱ mastu̱ wu̱n wa ku̱b u-randi wa gagu̱ wa u̱r-kwaz-du̱ u-kom. Wa zu̱, <<Unwa wa ba-e̱ m-rwu̱u̱n.>> ");
INSERT INTO gel_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Se̱di da-u̱ wa haste̱ ko̱mu wa, oru̱ wa bu̱ m-rwu̱u̱n. Wa mastu̱ wu̱n zu̱, <<Gwat u̱ka bo̱ mo̱rtu̱n m-yat iya!>> Se̱ wa te̱'e̱ wa u̱r-dim Pe̱re̱z. ");
INSERT INTO gel_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Du̱-dim rwu̱u̱n u̱ randi-u jaz-ya ne̱ m-gag u̱ kom-u wa, na zu̱ wa Ze̱ra. ");
INSERT INTO gel_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Da tase̱, ko̱-du̱ Isma'iru-ne̱ e̱ ku̱b Yusuhu m-ha u̱ Masar. Ku̱na Potipa o̱o̱t-u̱n Yusuhu du̱gu̱-du̱ u̱n. Potipa ne̱t-u̱ Masar wa wu̱ o̱o̱ge̱ u̱ te̱k-u̱ i-yate̱ Faru̱k tu̱msu̱ yu̱-Yat-ya yu̱ u̱r-e' wu̱ no̱me̱ e'-du̱ faru̱k. ");
INSERT INTO gel_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yawe o̱ u̱r-kot u̱ Yusuhu ne̱. Da-u̱ wa o̱o̱ge̱ u̱ shu̱'u̱t u̱ bu-u̱ yu̱-Yat-ya wa ne̱tu̱ Masar, wa shu̱'u̱t wa re̱-du̱ u̱r-ko̱rro̱ u̱ no̱m-u̱ wa o̱ u̱t-no̱m u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potipa hyanu̱g u̱zu̱ Yawe u-Ru̱ o u̱r-koto u̱ Yusuhu ne̱, remu̱ zu̱ wa yaag Yusuhu re̱-du̱ u̱r-ko̱rro̱ u̱ no̱m-u̱ wa o̱ u̱t-no̱m u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yusuhu kum hyu̱-m pus-mo̱ u̱du̱ Potipa wa no̱m u̱r-so̱ u̱ wa ne̱. Wa wu̱ Yusuhu shu̱'u̱t wa-gwat-du̱ bu-u wa u̱ no̱mu̱ wa otte̱ ne̱ u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Du̱gu̱ da-u o̱ Potipa wu̱ Yusuhu wa shu̱'u̱t yu̱-Yat-ya bu-u wa u̱ no̱mu̱ wa o̱tte̱ ne̱ u-be̱e̱t, Yawe wa'agu̱ bu-u ne̱t-u̱ Masar Potipa nu-u so̱-o̱ u̱ rem-u Yusuhu. No̱m-tu̱ u-bu wu̱n u̱t-be̱e̱t to̱ hu̱ m-da ho̱n-ho̱n, u̱ no̱m-tu̱ u̱r-to̱mu̱ wu̱n ne̱, u̱ bisa-tu̱ u-bu ne̱ to̱ hu̱ u̱ re̱-u̱ u-shu̱. ");
INSERT INTO gel_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potipa yasu̱ gwat-du̱ no̱m-tu̱ wa o̱tte̱ u̱t-be̱e̱t, ko̱-uyan shu̱'u̱t u̱ kom-u̱t Yusuhu. Potipa ruus-u̱ fu̱n-u̱ ko̱-uyan u-be̱e̱t. Ga-du̱ u̱t-re̱ de̱ Potipa do̱te̱ u no̱m-du̱ u̱s-dorog u̱ warre̱. Yusuhu o̱tte̱ u-ma u-war u̱ so̱-o̱ u zwarru̱ m-hyan u̱ zwarru̱ u-shu̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Remu̱ iya, da o̱ku̱n da-o̱ no̱me̱ ne̱ta Potipa got war-u Yusuhu wa he̱e̱se̱ cwan-u̱t Yusuhu. De̱ku̱n ho̱-de̱ wa zu̱ wa, <<Haane̱ bo̱ roog u̱-me̱ ne̱!>> ");
INSERT INTO gel_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yusuhu gu̱gu̱m, wa zu̱ ne̱ta yu̱-Yat-ya wa, <<Gwat! U̱so u-bu ri, za wadu̱ jab-u̱ o̱ko̱n u̱ bu-u uno̱ da. No̱m-u̱ wa o̱tte̱ u-be̱e̱t wa ya'aste̱ ko̱-uyan u̱ kom-u̱t ri u̱m ha gwat-du̱ to̱. ");
INSERT INTO gel_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","U-bu ane̱ waku̱n zaar wu̱ ze̱ge̱ me̱ da. Yu̱-Yat-ya ri hooste̱ me̱ o̱ko̱n u̱ ana da se̱ bo̱, u̱ remu̱ zu̱ bo̱ ne̱ta wa bo̱ o̱ye̱. ¿Re̱-o̱ u̱m do̱te̱ u̱ no̱m-du̱ no̱m-u̱t yo̱-to̱ u̱t-ba'as ne̱ u̱ shu̱ u-Ru̱?>> ");
INSERT INTO gel_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ne̱ta-u ya re u-shu̱ no̱mu̱ Yusuhu u̱s-rem ko̱-uyan ho̱-de̱, Yusuhu gu̱gu̱m wa roog u̱ wu̱n ne̱, ko wa dapu̱rse̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","De̱ku̱n ho̱-de̱ Yusuhu cwaag u-bu remu̱ wa no̱m-u̱t ank-mu̱ u-bu, u̱ te̱k-u̱ to̱k-ne̱ waku̱n zaar u-bu da. ");
INSERT INTO gel_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Se̱ ne̱ta-u ya shipis to̱ggo̱-u Yusuhu. Wa zu̱, <<Rooge̱ u̱-me̱ ne̱!>> Yusuhu ru m-so̱m u̱-do̱, se̱di wa yage̱ to̱ggo̱-u wa u̱ kom-u̱t wu̱n. ");
INSERT INTO gel_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Da-u̱ wu̱n hyane̱ Yusuhu somo̱g, wa yage̱ kus-tu̱ m-wa u̱ wa u̱du̱ wu̱n wa aru̱k m-so̱m m-rwu̱ u̱-do̱, ");
INSERT INTO gel_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","se̱ ne̱ta-u ya fog to̱k-ne̱ u-bu wa. Wa zu̱ u̱n, <<Gwatu̱n! Campa ri haatu̱n to̱k ne̱tu̱ Ibra-ne̱ u̱ ane̱ wa muute̱ na ragne̱! Wa cwagu̱n u̱ kur-u ri u̱ remu̱ wa no̱mtu̱ me̱ u̱r-ryapu̱k, u̱m nom u̱t-jar m-yat. ");
INSERT INTO gel_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Da-u̱ wa ho̱ge̱ u̱m no̱ng u̱t-jar, se̱ wa ru u-bu m-so̱m, wa yage̱ to̱ggo̱-yu̱ do̱ u̱ wa u̱du̱ ri.>> ");
INSERT INTO gel_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Wa cin to̱ggo̱-yu̱ u-war u̱ Yusuhu se̱ da-u̱ yu̱-Yat-ya wa mu̱u̱ne̱. ");
INSERT INTO gel_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Se̱ wu̱n ware̱ campa rò no̱mu̱ no̱me̱, u̱zu̱, <<To̱k-u̱ wa wu̱ bo̱ kabne̱ in du̱gu̱ Ibra-ne̱, wa cwagu̱n u̱-me̱ kur-u ri wa o̱ u̱ssa wa no̱mu̱ me̱ u̱r-ryapu̱k. ");
INSERT INTO gel_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Tu̱msu̱ da u̱m no̱me̱ u̱t-jar, wa aru̱k m-so̱m. Wa yage̱ to̱ggo̱-yu̱ do̱ wa u̱ kom-u̱t ri, wa som m-rwu̱ u̱-do̱.>> ");
INSERT INTO gel_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Da-u̱ yu̱-Yat-ya Yusuhu ho̱ge̱ no̱mu̱ ne̱ta wa ware̱, u̱zu̱ iya o̱ to̱k-u̱ wa nomte̱ ne̱ta wa, se̱ Potipa no̱m jab so̱k. ");
INSERT INTO gel_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Se̱ yu̱-Yat-ya Yusuhu hu̱u̱t wa u̱ bu m-to̱k be-du̱ faru̱k cinte̱ i no̱me̱ wa u̱t-ba'as, wa shu̱'u̱t u̱r-kot u̱ to̱k-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Yawe o̱ u̱r-kot u̱ Yusuhu ne̱ u̱ bu-u̱ m-to̱k, wa ko̱se̱ wa u̱t-cwan, wa kum hyu̱-m pusmo̱ u̱du̱ wa e'-du̱ bo̱-u̱ m-to̱k. ");
INSERT INTO gel_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Yu̱-Yat-ya a e'-du̱ bu-u̱ m-to̱k yasu̱ Yusuhu gwadu̱ a-bu-u̱ m-to̱k, ko̱-uyan o̱ na o̱ u̱t-no̱m Yusuhu wa o̱ yu̱-Yat-ya. ");
INSERT INTO gel_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Yu̱-Yat-ya a-bu-u̱ m-to̱k yage̱ ko̱-uyan u̱ kom-u̱t Yusuhu. Yawe o̱ u̱r-kot u̱ Yusuhu ne̱, wa yaag wa re̱-du̱ u̱r-ko̱rro̱ u̱ bu-u̱ m-to̱k. ");
INSERT INTO gel_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Da-u̱ o̱ko̱n da-o̱ arke̱, se̱ to̱k-ne̱ Faru̱k-u̱ Masar yu̱r no̱m no̱m-u̱ nase̱ faru̱k jab. Yu̱-Yat-ya ya-du̱ faru̱k no̱mtu̱ u̱t-swa u̱ yu̱-Yat-ya zwa-u̱ wa u̱r-be̱re̱di ne̱ e̱ be̱e̱t e̱ no̱mu̱ yu̱-Yat-ya e̱ no̱m-u̱ na-su̱ Faru̱k-u̱ Masar jab. ");
INSERT INTO gel_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Se̱ Faru̱k-u̱ Masar naas jab so̱k u̱ remu̱ i-yate̱ wa ne̱ yu̱r, yu̱-Yat-ya ya-du̱ faru̱k no̱mtu̱ u̱t-swa u̱ yu̱-Yat-ya zwa-u̱ wa u̱r-be̱re̱di ne̱. ");
INSERT INTO gel_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Wa tage̱ e̱ u̱ bu-u̱ yu̱-Yat-ya a-gwat-du̱ bu-u m-to̱k ne̱ u̱ be-du̱ Yusuhu o̱tte̱ tage̱. ");
INSERT INTO gel_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Yu̱-Yat-ya a-gwat-du̱ bu-u̱ m-to̱k wu̱' Yusuhu wa shu̱'u̱t wa-gwat-du̱ u̱n. Da-u̱ u̱n o̱o̱ge̱ me̱ bu-u̱ m-to̱k u-da u-tát. ");
INSERT INTO gel_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","M-gyu̱p m-gan, yu̱-Yat-ya ya-du̱ faru̱k no̱mtu̱ u̱t-swa u̱ yu̱-Yat-ya zwa-u̱ wa u̱r-be̱re̱di ne̱ e̱ nom bo' u-da u-gan bu-u̱ m-to̱k, bo' u̱n be̱e̱t ko̱wan o̱ mu̱ wa sha-mo̱. ");
INSERT INTO gel_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Da-u̱ Yusuhu haane̱ u̱du̱ u̱n u̱r-wu̱n, wa hyen u̱zu̱ u̱n o̱ namu̱ jab. ");
INSERT INTO gel_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Yusuhu shit i-yate̱ i o̱ m-to̱k u̱du̱ Faru̱k-u̱ Masar, i o̱ye̱ u̱r-kot u̱ wa ne̱ u̱ bu-u̱ m-to̱k-u̱ yu̱-Yat-ya wa. Wa zu̱ e̱, <<¿Yan-o̱ no̱ o̱tte̱ u̱ na-su̱ shu̱u̱t no̱ inya?>> ");
INSERT INTO gel_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","E̱ zu̱ wu̱n, <<It no̱ng bo' it yu̱r. Waku̱n zaar hen wu̱ de̱ waru̱ it zu̱n-mu̱ bo'-u̱s o̱ da.>> Se̱ Yusuhu zu̱ u̱n, <<Ru̱-o̱ yu̱'e̱ zu̱n-mu̱ ko̱-uyan, waru̱n me̱ bo̱'-su̱ no̱ no̱me̱.>> ");
INSERT INTO gel_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Yu̱-Yat-ya ya-du̱ faru̱k no̱m-tu̱ u̱t-swa waru̱ Yusuhu bo'-u̱ wa no̱me̱, wa zu̱, <<U̱-me̱ bo' u̱m hyang te̱-yu̱ inabi u̱-shu̱ ri. ");
INSERT INTO gel_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Te̱-yu̱ inabi ya o̱ u̱s-fe̱ ne̱ u̱s-tu̱t. A wa tak-ne̱ no̱m-du̱ u̱t-ran, se̱ pyak-u̱t tu̱ rwu̱u̱n, za wa'as ya'ag-u̱ inabi rwu̱u̱n. ");
INSERT INTO gel_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Me̱ hen u̱m o̱ m-shu̱p u̱ ko̱k-u̱ m-bu̱ faru̱k ne̱ u̱ kom-u ri, se̱ u̱m ku̱b yaag-u̱ inabi u̱m vins e̱ ko̱k-du̱ m-bu̱ tu̱msu̱ u̱m yasu̱ Faru̱k-u̱ Masar de̱ u̱ kom-u wa.>> ");
INSERT INTO gel_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusuhu zu̱ wu̱n, <<Zu̱n-mu̱ bo'-u̱ ró ya. Fe̱-u̱s se̱ u̱s-tut roog-mo̱ u̱t-tu̱t. ");
INSERT INTO gel_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ba roog-mu̱ u̱t-tu̱t ar-ke̱, Faru̱k-u̱ Masar do̱'e̱ rwu̱tu̱n bo̱ du̱gu̱ bu-u̱ m-to̱k, wa de̱ mutu̱ bo̱ u̱ o̱g-u̱r ró. Tu̱msu̱ bo̱ shu̱'u̱t wa ya-du̱ faru̱k no̱m-tu̱ u̱t-swa u̱ka bo̱ o̱tte m-no̱m u̱r-taku̱n. ");
INSERT INTO gel_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Bakse̱ me̱ a no̱mu̱ u̱m waru̱ bo̱ shiye̱. No̱mu̱ me̱ u̱r-se̱ge̱ bo̱ no̱mu̱ Faru̱k-u̱ Masar u̱s-rem u̱ remu̱ ri, u̱ remu̱ na rwu̱u̱tu̱n me̱ du̱gu̱ bu-u̱ m-to̱k uno̱. ");
INSERT INTO gel_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Me̱ na kabu̱n me̱ u̱r-be̱b du̱gu̱ dak-u̱ Ibra-ne̱, u̱ haan u̱ Masar. U̱m no̱ng o̱ko̱n u̱ ko̱re̱ u̱zu̱ na hatu̱n me̱ u̱ ana bu-u̱ m-to̱k da.>> ");
INSERT INTO gel_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Da-u̱ wu̱ zwa-u̱ Faru̱k u̱t-be̱re̱di ho̱ge̱ zu̱n-m so̱mo̱ mu̱ na ya'e̱ wa ya-du̱ faru̱k no̱mtu̱ u̱t-swa u̱ bo'-u̱ wa, se̱ wa zu̱ Yusuhu, <<Ko̱ me̱ u̱m no̱mu̱g bo' u̱m o̱ ko̱o̱r-tu̱ u̱t-be̱re̱di ne̱ u̱t-tu̱t u̱-do̱mu̱ hi-u̱r ri. ");
INSERT INTO gel_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","U̱-do̱m ko̱o̱r-du̱ shu̱u̱g u̱ no̱m u̱t-re̱ so̱-to̱ ne̱ u̱t-go̱ u̱t-go̱ u̱ na no̱me̱ remu̱ Faru̱k-u̱ Masar, tu̱msu̱ no o̱ re̱-du̱ o̱ du̱gu̱ ko̱o̱r-du̱ o̱ hi-u̱r ri.>> ");
INSERT INTO gel_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusuhu zu̱, <<Zu̱n-mu̱ bo' ró ya, ko̱o̱r-u̱t to̱ u̱t-tu̱t roog-mo̱ u̱t-tu̱t. ");
INSERT INTO gel_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","No̱m-u̱ bo' o̱ ya-du̱ m-zu̱nu̱ ya. U̱ te̱k-u̱ ro̱o̱g-mu̱ u̱t-tu̱t, Faru̱k-u̱ Masar de̱ kupsu̱ hi-u̱r ró, du̱gu̱ war-u ró. No u̱r-do̱g do̱'e̱ tu̱-du̱ war-u ró.>> ");
INSERT INTO gel_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","U̱ ho̱-du̱ u̱r-tu̱tu̱rse̱, de̱ o̱ye̱ ho̱-du̱ baku̱s-du̱ mat-u̱r Faru̱k-u̱ Masar ne̱, wa zo̱ngte̱ i-yate̱ wa u̱r-mo̱ro̱g. Se̱ wa rwu̱u̱tu̱n wa yu̱-Yat-ya ya-du̱ faru̱k-u̱ no̱m-tu̱ u̱t-swa, u̱ yu̱-Yat-ya zwa-u̱ faru̱k u̱r-be̱re̱di ne̱, wa haatu̱n e̱ u̱ shu̱ ne̱nge̱n-u̱t wa. ");
INSERT INTO gel_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Se̱ wa muut yu̱-Yat-ya ya-du̱ faru̱k no̱m-tu̱ u̱t-swa u̱ o̱g-du̱ wa o̱tte, ko̱wa u̱t-re̱ u-shu̱ u̱ ya-du̱ Faru̱k-u̱ Masar m-bu̱ u̱ kom-u wa. ");
INSERT INTO gel_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Tu̱msu̱ Faru̱k-u̱ Masar tu̱r yu̱-Yat-ya a zwa-du̱ u̱t-be̱re̱di u-ho u̱-do̱m u-te u̱ka Yusuhu wartu̱ u̱n da-u̱ wa o̱o̱ge̱ ya-du̱ u̱n m-zu̱n. ");
INSERT INTO gel_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","M-ha iya ne̱ yu̱-Yat-ya ya-du̱ faru̱k no̱m-tu̱ u̱t-swa baku̱ste̱ u̱ Yusuhu ne̱ da, wa ku̱u̱s u̱t-to̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Da-u̱ shu̱-du̱ hak-su̱ u̱s-yu̱r arke̱, Faru̱k-u̱ Masar nom bo', u̱zu̱ wa o̱ ees u̱ kit-u̱ gi-yu̱ Niru. ");
INSERT INTO gel_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Da-u̱ na' ta'er, i o̱ye̱ m-yar ne̱, u̱t-birig ne̱, rwu̱u̱n du̱gu̱ gi-yu̱ Niru. E̱ he̱e̱se̱ tu̱du̱ gwa-tu̱ o̱ye̱ u̱-kit u-gi. ");
INSERT INTO gel_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Se̱ e̱ke̱n na'-e̱ ya ta'er za u̱t-birig, m-ga ne̱ za so̱-ye̱, e̱ rwu̱u̱n tu̱msu̱ du̱gu̱ gi-yu̱ Niru. E̱ ees u̱ dim-u̱ na' ta'er i o̱tte̱ u̱t-birig ne̱ dap-u̱s u-gi. ");
INSERT INTO gel_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Se̱ na' i m-ga i za so̱-ye̱ toromse̱ na' u̱t-birig. Da-u o̱ Faru̱k-u̱ Masar zu̱te̱. ");
INSERT INTO gel_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Tu̱msu̱ roog-mu̱ kos wa. Wa sur m-no̱m bo' u-yu̱ru̱mse̱, ro̱p-tu̱ hyu̱ u̱t-ta'er, tu̱ so̱-to̱ sok tu̱ shu̱u̱se̱ yaag sok, to̱ cwu̱n u̱-do̱mu̱ kamb-yu̱ u-hyu u-gan. ");
INSERT INTO gel_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","U̱ dim-u̱ u̱n, se̱ke̱n kamb-su̱ hyu̱ se̱ u̱s-ta'er se̱ apu̱n, su̱ za u̱t-birig. Da-u̱ mya-mu̱ udo̱m fu̱rne̱, se̱ ro̱p-tu̱ hyu̱ to̱ ryamu̱sse̱, to̱ gu̱u̱s. ");
INSERT INTO gel_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ro̱p-tu̱ hyu̱ to̱ tu̱ za u̱t-birig to̱ toromse̱ ro̱p-tu̱ hyu̱ u̱t-ta'er tu̱ m-yar, tu̱ shu̱se̱ yaag. Se̱ Faru̱k-u̱ Masar zu̱te̱; wa hyen u̱zu̱ bo' o̱. ");
INSERT INTO gel_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Se̱ u̱r-wu̱n, jab-u̱ Faru̱k-u̱ Masar nu̱u̱s. Se̱ wa tom na fagnu̱ wa a-u-gwat-ne̱ u̱ a-m-nap-ne̱ i dak-u̱ Masar be̱e̱t. Se̱ wa waru̱ e̱ bo'-u̱s wa. Na kwu̱mu̱g wu̱ waru̱ wa nu-du̱ bo'-u̱s se̱ da. ");
INSERT INTO gel_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Da-u o̱ yu̱-Yat-ya ya-du̱ Faru̱k-u̱ Masar no̱m-tu̱ u̱t-swa zu̱ye̱, <<U̱ ya-o̱, u̱m baku̱ste̱ u̱ baas-u̱t ri ne̱. ");
INSERT INTO gel_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Faru̱k-u̱ Masar hog u̱s-ryap u̱ to̱k-u̱ wa ne̱, tu̱msu̱ Faru̱k-u̱ Masar hu̱u̱t me̱ u̱ wa zwa-u̱ faru̱k u̱r-be̱re̱di ne̱ u̱ bu-u̱ yu̱-Yat-ya a-gwat-du̱ bu-u m-to̱k ne̱. ");
INSERT INTO gel_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","It no̱mu̱g u̱s-bo' it be̱e̱t m-gyu̱p m-gan, ko̱he̱ne̱ bo' o̱ o̱tte̱ mu̱ wa zu̱n-mo̱. ");
INSERT INTO gel_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Waku̱n zwar-wa o̱ro u̱ku̱n u̱r-ko̱t u̱ it ne̱, ne̱t-u̱ Ibra-ne̱, to̱k-u̱ yu̱-Yat-ya a-gwat-du̱ bu-u m-to̱k ne̱. It waru̱ wa bo'-u̱s it, se̱ wa waru̱ it zu̱n-mu̱ bo'-u̱s it. Wa waru̱ ko̱wan zu̱n-mu̱ bo'-u̱ wa no̱me̱. ");
INSERT INTO gel_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ko̱-uyan nom ho̱n-ho̱n u̱ka wa zu̱tte̱. Na mu̱tu̱n me̱ u̱ o̱g-u̱r ri u̱ka wa zu̱tte̱ wu̱ ya-du̱ faru̱k no̱m-tu̱ u̱t-swa. Wa zwa-u̱ faru̱k u̱r-be̱re̱di na ho wa.>> ");
INSERT INTO gel_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Da-u̱ faru̱k ho̱ge̱ iya, wa tom to̱k-ne̱, na fagu̱n Yusuhu. E̱ do̱'e̱ e̱ fagu̱n Yusuhu, du̱gu̱ bu-u̱ m-to̱k. Da-u̱ Yusuhu tase̱ u-o̱r se̱ wa wu̱ to̱ko̱n kus-to̱, wa aru̱k m-cwa wa ees u̱-shu̱ Faru̱k-u̱ Masar. ");
INSERT INTO gel_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Faru̱k-u̱ Masar zu̱ Yusuhu, <<U̱m no̱mu̱g bo'. U̱m kwu̱mu̱g waku̱n wu̱ waru̱ me̱ zu̱n-mu̱ bo'-u̱ o̱ da. Tu̱msu̱ u̱m ho̱k u̱zu̱ bo̱ ye'e̱ zu̱n-mu̱ bo'.>> ");
INSERT INTO gel_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusuhu zu̱ Faru̱k-u̱ Masar, <<Me̱ wa ye'e̱ zu̱n-mu̱ bo' da, se̱di Ru̱-o̱ ya'u̱ Faru̱k-u̱ Masar zu̱n-mu̱ wa o̱o̱ge̱ u̱ssa.>> ");
INSERT INTO gel_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Se̱ Faru̱k-u̱ Masar zu̱ Yusuhu, <<U̱ bo'-u̱ ri, u̱m o̱ ees u̱ kit-u̱ gi-yu̱ Niru. ");
INSERT INTO gel_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Se̱ na' ta'e̱r rwu̱u̱n m-yar ne̱, u̱t-birig ne̱, du̱gu̱ me̱ u-gi yu̱ Niru, se̱ e̱ he̱e̱se̱ tu̱-du̱ gwa-tu̱ o̱ u̱ kit-u̱ u-gi. ");
INSERT INTO gel_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Tu̱msu̱ e̱ke̱n na'-e̱ rwu̱u̱n u̱ dim-u̱ e̱ za u̱t-birig, za so̱-ye̱. U̱m tamu̱g hyan-du̱ go̱-du̱ e̱ u̱ dak-u̱ Masar da. ");
INSERT INTO gel_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Se̱ na' ta'er, i za u̱t-birig i za so̱-ye̱, toromse̱ na' ta'er i u̱t-birig. ");
INSERT INTO gel_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tu̱msu̱ da u̱n toromse̱ e̱, waku̱n zaar u̱t-nap u̱zu̱ u̱n cwaru̱g o̱ko̱n da, remu̱ zu̱ e̱ o̱mo̱n m-ga ne̱ u̱ka u̱r-taku̱n. Da-u o̱ u̱m yu̱ne̱. ");
INSERT INTO gel_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","<<Se̱ roog-mu̱ sur m-kab me̱, tu̱msu̱ u̱m no̱m o̱kon bo' o̱, u̱m hyanu̱g ro̱p-tu̱ hyu̱ u̱t-ta'er, to̱ shu̱u̱se̱ yaag sok tu̱ so̱-to̱, to̱ cwu̱gu̱n u̱-do̱m u-kamb u-gan. ");
INSERT INTO gel_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","U̱ dim-u̱ e̱, to̱ko̱n ro̱p-tu̱ hyu̱ to̱ u̱t-ta'er to̱ cwu̱u̱n to̱ zatte̱ yaag da. Da-u̱ mya-mu̱ udo̱m fu̱rne̱, se̱ ro̱p-tu̱ tu̱ hyu̱ to̱ ryamu̱sse̱, to̱ gu̱u̱s. ");
INSERT INTO gel_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Se̱ ro̱p-tu̱ ryaamse̱ toros ro̱p-tu̱ hyu̱ u̱t-ta'er tu̱ so̱-to̱ to̱. U̱m wargu̱ a-u-gwat-ne̱ se̱di waku̱n kerge̱ waru̱ me̱ bo'-u̱ ri da.>> ");
INSERT INTO gel_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yusuhu zu̱ Faru̱k-u̱ Masar, <<Bo'-u̱s ró o̱ u̱s-gan. Ru̱-u̱ wargu̱ Faru̱k-u̱ Masar nom-u̱ wa o̱o̱ge̱ u̱ssa u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Na'-u̱ so̱-ye̱ ta'er hak-se̱ u̱s-ta'er, ro̱p-tu̱ hyu̱ to̱ u̱t-ta'er hak-se̱ u̱s-ta'er, no̱m-o̱ u-gan tu̱msu̱ bo'-se̱ u̱s-gan. ");
INSERT INTO gel_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Na' ta'er i o̱tte̱ m-ga za u̱t-birig, i rwu̱u̱ne̱ u̱-dim tu̱msu̱ hak-se̱ u̱s-ta'er. Tu̱msu̱ ro̱p-tu̱ hyu̱ to̱ u̱t-ta'er za yaag i mya-mu̱ u-do̱m fu̱rne̱ e̱ ryamu̱sse̱: to̱ o̱o̱ge̱ hak-su̱ u̱s-ta'er su̱ u̱s-me̱r. ");
INSERT INTO gel_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","<<Iya o̱tte̱ u̱ka u̱m zu̱tte̱ Faru̱k-u̱ Masar, Ru̱-u̱ ko̱ksu̱ Fir'una no̱mu̱ wa do̱'e̱ u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Na do̱'e̱ u̱ no̱m-du̱ u̱s-hak u̱s-ta'e̱r su̱ no̱m-u̱t-re̱ so̱k dak-u̱ Masar u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Se̱di hak-su̱ u̱s-me̱r u̱s-ta'er do̱'e̱ u̱ do̱rnu̱ dim. U̱ da-u o̱ na do̱'e̱ u̱ ku̱'u̱s u̱t-to̱ u̱ no̱m u̱t-re̱ u̱ na no̱me̱ ne̱ u-be̱e̱t u̱ dak-u Masar. Tu̱msu̱ me̱r-su̱ do̱'e̱ u̱ no̱m-du̱ u-tát u-dak u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Me̱r-su̱ do̱'e̱ u̱t-shu̱'u̱t u̱ka zu̱ na tamu̱g no̱m-du̱ no̱m u̱t-re̱ u̱ Masar da, u̱ remu̱ tat-u̱ u̱s-me̱r su̱ na do̱'e̱ u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","No̱mu̱ wa-e̱ bo' hatu̱n u̱s-fu̱n u̱s-yu̱r u̱du̱ Faru̱k-u̱ Masar na o̱ u̱ssa wa nap no̱mu̱ do̱'e̱ u̱t-no̱m u̱zu̱ Ru̱-o̱ no̱me̱ dorog-su̱ no̱m-du̱ o̱ no̱m-o u̱ hi-du̱ war-wa, tu̱msu̱ Ru̱-u̱ do̱'e̱ u̱ no̱m-du̱ o̱ za m-tumb. ");
INSERT INTO gel_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","<<Remu̱ iya, yage̱ Faru̱k-u̱ Masar sa ne̱t wa-m-nap u̱ ne̱t wu̱ o̱tte̱ dorog-u̱s so̱-se̱ ne̱, wa shu̱'u̱t yu̱-Yat-ya u̱ gwat-du̱ dak-u̱ Masar. ");
INSERT INTO gel_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Yage̱ Faru̱k-u̱ Masar wa i-yate̱ u-dak u̱ Masar. E̱ kargu̱sse̱ u-gan u̱t-tan u̱ te̱k-u̱ no̱m-tu̱ u̱r-to̱m tu̱ na do̱'e̱ u̱t-kwu̱m hak-su̱ u̱s-ta'er su̱ na do̱te̱ no̱m-du̱ no̱m u̱t-re̱ sok. ");
INSERT INTO gel_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","E̱ do̱'e̱ u̱ kargu̱sse̱ no̱m-tu̱ u̱t-re̱ tu̱ hak-u̱s so̱-se̱ su̱ no̱m u̱t-re̱ su̱ o̱ne̱ u̱ te̱k-u̱ be̱b-u̱r Faru̱k-u̱ Masar, na cin to̱ u̱t-bo̱ u̱ na kum-u̱t no̱m u̱t-re̱. ");
INSERT INTO gel_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","No̱m u̱t-re̱ o̱ do̱'e̱ u̱t-shu̱'u̱t u̱r-cu̱n u̱ re̱mu u-dak, u̱ na kum-u̱t no̱m u̱t-re̱ u̱ hak-su̱ u̱s-ta'e̱r su̱ u̱s-me̱r su̱ do̱'e̱ u̱ haan dak-u̱ Masar, taas u̱ ne̱t-tu̱ u-dak u̱ mar u̱s-me̱r da.>> ");
INSERT INTO gel_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Rem-u̱s se̱ nom Faru̱k-u̱ Masar u̱r-zwar u̱ tu̱-yat-to̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Faru̱k-u̱ Masar zu̱ tu̱-yat-to̱, <<¿Inu̱ kwu̱mu̱ ne̱t go̱-du̱ wa wu̱ o̱tte̱ Yar u-Ru̱?>> ");
INSERT INTO gel_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Faru̱k-u̱ Masar zu̱ Yusuhu, <<Remu̱ zu̱ Ru̱-u̱ ko̱ksu̱ bo̱ tun-to̱ no̱m-to̱, waku̱n zaar wa dorog-u̱s so̱-se̱ wa-m-nap u̱ka bo̱ da. ");
INSERT INTO gel_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Bo̱ shu̱'u̱t yu̱-Yat-ya u̱ pada-u ri. Tu̱msu̱ ne̱t-u̱t ri u̱t-be̱e̱t e̱ do̱'e̱ yasu̱ hi-du̱ war-e̱ u̱du̱ ró, e̱ ya bo̱ m-ze̱g. U̱-do̱mu̱ pora-du̱ u̱r-faru̱k de̱ u̱m do̱te̱ u̱ ze̱g-du̱ bo̱ u̱ warre̱.>> ");
INSERT INTO gel_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Faru̱k-u̱ Masar zu̱ Yusuhu, <<Gwat, u̱ da-o̱ u̱m wa'ag bo̱ shu̱'u̱t u̱r-faru̱k dak-u̱ Masar u-be̱e̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Se̱ Faru̱k-u̱ Masar host kwaat-yu̱ u̱t-komu̱ wa, wa wa'-u̱ Yusuhu ya u-jo̱-u, tu̱msu̱ wa wa'-u̱ Yusuhu cwu̱-u̱t so̱-to̱. Tu̱msu̱ faru̱k wa'-u̱ wu̱n re̱ge̱z shik yu̱ u-kwam yu̱ bu̱-mu̱ u̱t-ro u̱ ge̱ksu̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Faru̱k-u̱ Masar zo̱nge̱ Yusuhu wa sak u̱-do̱mu̱ ke̱ke̱-yu̱ u-jwaak ka wa u̱r-se̱ge̱ wa, remu̱ wa shu̱'u̱t wa u̱r-se̱ge̱ faru̱k. Se̱ ne̱t-tu̱ yu̱ne̱ u̱t-jar u̱zu̱, <<Ya u̱n u̱r-be!>> Na wa'ag Yusuhu wa shu̱'u̱t yu̱-Yat-ya dak-u̱ Masar u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Se̱ Faru̱k-u̱ Masar zu̱ Yusuhu, <<Me̱ o̱ Faru̱k-u̱ Masar, tu̱msu̱ da ees-u̱t ró ne̱ da, waku̱n zaar Masar wu̱ do̱'e̱ u̱ no̱m-du̱ o̱kon no̱mo̱ da.>> ");
INSERT INTO gel_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Faru̱k-u̱ Masar wa'-u̱ Yusuhu dim-u̱r po-de̱ na zu̱ Zapena-Paneya. Se̱ wa yu̱ Yusuhu Asenat gwu̱p-u̱ Potipara u̱r-gu̱ wa-to̱o̱g bo̱-u̱ O̱n. Yusuhu aru̱k m-cwa dak-u̱ Masar u-be̱e̱t, u̱ wa shu̱'u̱t ne̱ta wa. ");
INSERT INTO gel_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","U̱ da-u o̱ Yusuhu o̱ u̱s-hak u̱r-shik-u̱ o̱p 30, da-u̱ wa cwaye̱ u̱ no̱mu̱ Faru̱k-u̱ Masar m-ank. Remu̱ wa no̱m-u̱t ank-m wa, wa yage̱ u-pada u̱ faru̱k m-caw dak-u̱ Masar. ");
INSERT INTO gel_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Da u̱ hak-su̱ u̱s-ta'e̱r no̱me̱ su̱ no̱m-u̱t-re̱ no̱m u̱t-re̱ no̱m u-tát u-dak u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yusuhu kargu̱sse̱ no̱m u̱t-re̱ u̱ hak-su̱ u̱s-ta'e̱r su̱ no̱m-u̱t-re̱ u̱ dak-u̱ Masar. Tu̱msu̱ wa cin no̱m u̱t-re̱ u̱t-bo̱. Ko̱-u̱-he̱ bo̱-o̱ wa wu̱ na kargu̱sse̱ no̱m u̱t-re̱ u̱ na gwaye̱ u̱ tak-tu̱ u̱s-kit u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yusuhu kargu̱sse̱ no̱m u̱t-re̱ u-tát, u̱ka hereg-mu̱ u-gi. Se̱ wa yage̱ u̱t-ogor remu̱ zu̱ waku̱n zaar u̱ keru̱ u̱t-ogor da. ");
INSERT INTO gel_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kanda hak-su̱ u̱s-me̱r u̱ teen, Asenat gwu̱p-u̱ Potipara wa-to̱o̱g-u̱ bo̱-u̱ O̱n, ne̱ta Yusuhu wa matu̱ Yusuhu yaag-u̱ campa-ne̱ yu̱r. ");
INSERT INTO gel_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusuhu te̱'e̱ mat-du̱ u̱r-taku̱n u̱r-dim Manase. Wa zu̱, <<Ru̱-u̱ wa'ag u̱m ku̱u̱ste̱ u̱t-to̱ u̱ to̱k-m ri ne̱ u̱ ne̱t-tu̱ bu-u̱ u̱so ri ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ya-du̱ u̱r-zwar du̱ u-yu̱ru̱mse̱ Yusuhu zu̱ wa Ifaramu. Wa zu̱, <<Remu̱ zu̱ Ru̱-u̱ yaag me̱ yaag u̱ dak-u̱ u̱m nomte̱ m-to̱k.>> ");
INSERT INTO gel_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Hak-su̱ u̱s-ta'e̱r su̱ no̱m u̱t-re̱ u-tát teeg u̱r-ma u̱ dak-u̱ Masar. ");
INSERT INTO gel_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Se̱ hak-su̱ u̱s-ta'e̱r su̱ u̱s-me̱r taku̱n, u̱ka Yusuhu zu̱tte̱. Se̱ me̱r-su̱ haan u̱ dak-tu̱ o̱ m-gan u̱ Masar u̱t-be̱e̱t. Se̱di Masar no̱m u̱t-re̱ o̱ró. ");
INSERT INTO gel_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Da-u̱ me̱r-su̱ he̱e̱se̱ Masar, ne̱t-tu̱ do̱'e̱ u̱du̱ Faru̱k-u̱ Masar e̱ no̱mu̱ wa u̱s-kan u̱zu̱ no̱m u̱t-re̱ zarra. Se̱ wa zu̱ u̱n <<De̱e̱n u̱du̱ Yusuhu, no̱m-u̱ wa zu̱ no̱ u-be̱e̱t, se̱ no̱ no̱m.>> ");
INSERT INTO gel_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Da-u̱ me̱r-su̱ goone̱ ko̱he̱ne̱ u-dak u-be̱e̱t, Yusuhu tu̱ku̱s be-tu̱ no̱m u̱t-re̱ o̱tte̱. Wa babu̱ u̱n remu̱ zu̱ me̱r-su̱ no̱mu̱g u-tát Masar. ");
INSERT INTO gel_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Tu̱msu̱ ne̱t-tu̱ haan du̱gu̱ dak-tu̱ u̱s-kit u̱ Masar e̱ oot no̱m u̱t-re̱ u̱du̱ Yusuhu, remu̱ zu̱ me̱r-su̱ no̱ng u-tát u-dak u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Da-u̱ Yakubu nape̱ u̱zu̱ no̱m u̱t-re̱ o̱ro u̱ dak-u̱ Masar, wa zu̱ ya-u̱t-zwaru̱ wa, <<¿Remu-u yan o̱ no̱ o̱tte̱ u̱ shu̱'u̱t u̱ gwat-du̱ hi-du̱ war-no̱? ");
INSERT INTO gel_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","U̱m ho̱k u̱zu̱ no̱m u̱t-re̱ o̱ro u̱ Masar, de̱e̱n no̱ o̱o̱nu̱ in no̱m u̱t-re̱ ko̱ in u̱t-no̱m u̱r-fat, u̱ taas in mar da.>> ");
INSERT INTO gel_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Se̱ tu̱-wu̱to̱ Yusuhu ne̱t-ne̱ o̱p e̱ aru̱k m-ha u̱ Masar, u̱ remu̱ e̱ o̱o̱tu̱n no̱m u̱t-re̱. ");
INSERT INTO gel_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Se̱di Yakubu to̱mo̱g Banyamin hu̱no-u Yusuhu da, wa o̱ u̱t-ge̱r taas o̱ko̱n no̱m-u yo̱-o̱ kum wa da. ");
INSERT INTO gel_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ya-u̱t-zwaru̱ Isra yu̱ne̱ du̱gu̱ Kan'ana m-ha u̱ Masar e̱ o̱o̱tu̱n no̱m u̱t-re̱, remu̱ zu̱ me̱r-su̱ o̱ró Kan'ana sok. ");
INSERT INTO gel_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yusuhu wa o̱ye̱ wa-u-dak u̱ Masar. Wa o̱ wa bab-du̱ hyu̱ u̱du̱ ne̱t-tu̱ haane̱ u̱ dak-u̱ Masar u-be̱e̱t. Se̱ o̱r-u̱t Yusuhu haan, e̱ he̱ u̱ shu̱ wa u̱t-jwu̱n, e̱ kaku̱s u̱t-hi u-dak. ");
INSERT INTO gel_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Da-u̱ Yusuhu hyane̱ o̱r-u̱t wa ne̱, wa nu̱p u̱zu̱ hu̱no-u̱t wa to̱. Se̱ wa nom u̱ka ham-u̱t wa wa o̱ye̱ wa no̱mu̱ u̱n u̱s-rem u̱ namu̱ jab ne̱. Wa zu̱, <<¿Du̱gu̱ he̱ne̱ no̱ rwu̱ne̱?>> E̱ zu̱, <<It rwu̱gu̱n du̱gu̱ dak-u̱ Kan'ana, it haagu̱n it o̱ no̱m u̱t-re̱.>> ");
INSERT INTO gel_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusuhu nak o̱r-u̱t wa, se̱di e̱ baku̱ste̱ u̱zu̱ ne̱t wu̱ o̱o̱ge̱ ees u̱-shu̱ e̱ Yusuhu wa da. ");
INSERT INTO gel_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yusuhu baku̱s bo'-u̱ wa no̱me̱. Wa zu̱ u̱n, <<No̱ haan m-haan, remu̱ no̱ gwat u̱ka dak-u it o̱tte̱. A-gwat-du̱ u-dak-ne̱ e̱ no̱ o̱ye̱.>> ");
INSERT INTO gel_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","E̱ zu̱ wa, <<O'o u̱so u-bu ri, to̱k-ne̱ ró hagu̱n remu̱ e̱ o̱ no̱m u̱t-re̱. ");
INSERT INTO gel_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","It ya'ag-u̱ wa-gan ne̱ it o̱ye̱ be̱e̱t. It ne̱t-tu̱ u̱t-nip to̱ to̱k-ne̱ ró e̱. A-gwat-du̱ u-dak-ne̱ e̱ da.>> ");
INSERT INTO gel_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yusuhu zu̱ u̱n, <<O'o, no̱ haan m-haan remu̱ no̱ hyen-u̱t u̱ka be̱b-du̱ dak-u̱ it o̱tte̱.>> ");
INSERT INTO gel_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Se̱ e̱ zu̱ wu̱n, <<It rwu̱gu̱n u-bu u-gan, it ya'ag-u̱ wa-gan ne̱, it o̱ o̱p u̱ yu̱r 12 campa-ne̱. It haagu̱n du̱gu̱ dak-u̱ Kan'ana. Vaste̱-u̱r it o̱ u̱r-ko̱t u̱ u̱so-u it ne̱, wa-gan it wa zamu̱n u̱r-fat da.>> ");
INSERT INTO gel_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yusuhu zu̱ u̱n, <<U̱ka u̱m zu̱tte̱ no̱, no̱ a-gwat-du̱ u-dak-ne̱ e̱. ");
INSERT INTO gel_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ka u̱m do̱te̱ no̱m-du̱ reg-mu̱ rem-u̱s no̱ iya. U̱m no̱m-u̱g e̱ste̱ du̱ u̱s-rem u̱m zaar u̱ mu̱-du̱ u-dim u̱ no̱mu̱ u̱m ware̱ ne̱ da inde u̱zu̱ Faru̱k-u̱ Masar o̱ u̱r-be̱b ne̱: No̱ zaar yage̱ Masar da se̱ no̱ haagu̱n u̱ du̱-dim-u̱ no̱ ne̱ u̱ ane̱. ");
INSERT INTO gel_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","To̱mo̱n wa-gan no̱, wa do̱'e̱ wa kabu̱n du̱-fade̱ no̱. Na do̱'e̱ u̱ tagu̱ i kuse̱ u̱ bu-u̱ m-to̱k, ko̱ me̱ no̱mu̱ no̱ reg-mu̱ rem-u̱s no̱ u̱zu̱ no̱ nip-to̱ ne̱ re̱. Abite̱ nip-to̱ da, u̱m to̱ndte̱ u̱ fat-du̱ faru̱k ne̱, no̱ a-gwat-du̱ u-dak-ne̱ e̱.>> ");
INSERT INTO gel_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Se̱ Yusuhu wu̱ u̱n u̱ bu-u m-to̱k m-roog u̱t-tu̱t. ");
INSERT INTO gel_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","U̱ ho̱-du̱ u-tu̱tu̱rse̱, Yusuhu zu̱ u̱n, <<Me̱ ne̱t-u̱ u-gye̱r u-Ru̱ wa. A no̱ no̱me̱ no̱m-u̱ u̱m zu̱ no̱ no̱m, no̱ u̱t-no̱m u̱r-fat. ");
INSERT INTO gel_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","A mu̱ne̱ u̱zu̱ no̱ a-u̱t-nip-ne̱ e̱, yagu̱n waku̱n wa shu̱'u̱t u̱ bu-u̱ m-to̱k, se̱ i kuse̱ e̱ mutu̱ a-u-bu u̱s-me̱r no̱ no̱m u̱t-re̱. ");
INSERT INTO gel_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Remu̱ iya se̱ no̱ hatu̱n du̱-dim-u̱ no̱ u̱du̱ ri, ko̱ na gwat-u̱ rem-u̱s no̱ taas u̱ no̱ mar da.>> E̱ ees e̱ nom iya. ");
INSERT INTO gel_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Se̱ e̱ zu̱ hi-du̱ war-e̱, <<Za u-sakna na o̱ yadu̱ in u̱r-ko̱b u̱ remu̱ no̱mu̱ in no̱me̱ hu̱no-u in. In hyanu̱g ka jab-u̱ wu̱n nu̱u̱te da-u̱ wa o̱o̱ge̱ u̱ ko̱n-du̱ in u̱ remu̱ fat-u̱r rò, se̱di in gu̱gu̱m u̱t-e̱r, o̱ wa'e̱ din-de̱ swadu̱ u̱r-ko̱b de̱ haatu̱n in.>> ");
INSERT INTO gel_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rube̱n zu̱, <<¿U̱m wargu̱ no̱ u̱zu̱ a no̱ no̱mu̱ wa'-u̱ wa o̱ko̱n da? No̱ gu̱gu̱m ho̱g-du̱ me̱. Tu̱msu̱ to̱p-u̱ no̱m-u̱ in no̱mu̱ wa na o̱ no̱mu̱ in.>> ");
INSERT INTO gel_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","U̱n nak u̱zu̱ Yusuhu o̱ ho̱gu̱ u̱n da, u̱ remu̱ zu̱ a wa o̱ u̱s-rem u̱ u̱n ne̱ waku̱n o̱ u̱t-bargu̱sse̱ u̱t-war. ");
INSERT INTO gel_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Se̱ Yusuhu hast shu̱-u wa u̱-kit, wa hu̱ u̱s-kan. Tu̱msu̱ se̱ wa byu̱ru̱n u̱du̱ u̱n wa no̱mu̱ u̱n u̱s-rem. Wa umus Simiyo̱n du̱gu̱ me̱ u̱n wa wu̱' na gu̱ku̱s wa u̱ hyan-mu̱ is-u̱ u̱n. Na hu̱u̱t wa u̱ bu-u̱ m-to̱k. ");
INSERT INTO gel_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusuhu ye u-nu u̱zu̱ na shu̱u̱s ba-tu̱ tu̱-wu̱to̱ wa ne̱ u̱ hyu̱, tu̱msu̱ na muutu̱ ko̱wan ko̱nko̱ shik-u̱ wa u̱ ba-u̱r wa. Wa zu̱ na ya u̱n no̱m u̱t-re̱ u̱n de̱ u̱t-re̱ u̱-fu̱n. Iya o̱ na no̱m-tu̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Se̱ u̱n gagu̱ janka u̱n ba-tu̱ hyu̱, se̱ u̱n aru̱k, u̱n dor u-fu̱n m-mu̱. ");
INSERT INTO gel_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Be-du̱ u̱n eeste̱ remu̱ u̱n roogte̱ m-gyu̱p, wa-gan upus ba-u̱r wa u̱ remu̱ wa ye'et u-janka no̱m u̱t-re̱, Se̱ wa bit ko̱nko̱ shik-u̱ wa do̱m-u̱ ba-u̱r wa. ");
INSERT INTO gel_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Wa zu̱ o̱r-u̱t wa, <<Na mu̱ttu̱n me̱ shik-u̱ ri. E̱ ya ba-u̱r ri.>> Se̱ jab-u̱ u̱n mor u̱n hog u-gye̱r ko̱wan bir wa got o̱r-u̱ wa, wa zu̱, <<¿Yan o̱ iya u̱ Ru̱-u̱ no̱me̱ ine̱?>> ");
INSERT INTO gel_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Da-u̱ u̱n muye̱ u̱du̱ u̱so-u u̱n Yakubu u̱ dak-u̱ Kan'ana, u̱n waru̱ wa no̱m-u̱ no̱me̱ u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","E̱ zu̱ wu̱n, <<Ne̱t wu̱ o̱o̱ge̱ wa-u-dak u̱ Masar wa no̱ngu̱ it u̱s-rem u̱ namu̱ jab ne̱. Wa kagu̱b it a-gwat-du̱ u-dak-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Tu̱msu̱ it zu̱ wa, <It ne̱t-tu̱ u̱t-nip to̱, za a-gwat-du̱ u-dak-ne̱ e̱ da. ");
INSERT INTO gel_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","It ne̱t-ne̱ o̱p u̱ yu̱r 12, it ya'ag-u̱ campa-ne̱ u̱so u̱ u-gan ne̱. Wa-gan maru̱g, du̱-fade̱ it o̱ u̱r-kot u̱ u̱so-u it ne̱ u̱ Kan'ana.> ");
INSERT INTO gel_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","<<Ne̱t wu̱ o̱o̱ge̱, wa-u-dak zu̱ it, <Ka u̱m do̱te̱ u̱t-nap u̱zu̱ no̱ ne̱t-tu̱ u̱t-nip to̱, yagu̱n wa-gan u̱ ana no̱ muut-u̱ a-u-bu no̱ ne̱ i o̱o̱ge̱ u̱s-me̱r no̱m u̱t-re̱. ");
INSERT INTO gel_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Se̱ no̱ hattu̱n du̱-dim-u̱ no̱ u̱du̱ ri. O̱ do̱'e̱ u̱t-wa u̱m nap u̱zu̱ no̱ a-wu̱ksu̱ u-dak-ne̱ e̱ da, se̱di a-u̱t-nip-ne̱ e̱. Da-u o̱ u̱m do̱'e̱ yasu̱ no̱ du̱-dim-u̱ no̱, u̱ da-u o̱ no̱ u̱t-no̱m u-ce̱rpa dak-u uno̱.> >> ");
INSERT INTO gel_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Da-u̱ u̱n o̱ dasu̱ hyu̱ du̱gu̱ ba-u̱t u̱n, se̱ ko̱wan hyen shik-u̱ wa ba-u̱r wa. Da-u̱ u̱n u̱ u̱so u̱n ne̱ hyane̱ put-tu̱ shik, u̱n hog u-gye̱r. ");
INSERT INTO gel_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","U̱so u̱n Yakubu zu̱ u̱n, <<No̱ wa'ag u̱m taag u̱ yaag yu̱r, Yusuhu zarra tu̱msu̱ Simiyo̱n zarra, u̱ da-o̱ tu̱msu̱ no̱ u̱t-sa no̱ kab Banyamin. Me̱ o̱ wa swadu̱ u̱r-ko̱b u̱ no̱mu̱ o̱ m-da ne̱ u-be̱e̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rube̱n zu̱ u̱so-u e̱, <<Me̱ ya bo̱ ya-u̱t-zwaru̱ ri yu̱r ri yu̱r bo̱ ho̱, a u̱m mu̱tu̱n Banyamin u̱du̱ ró da. Me̱ gwat-u̱ wa, tu̱msu̱ me̱ mu̱tu̱n bo̱ wa.>> ");
INSERT INTO gel_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Tu̱msu̱ Yakubu zu̱, <<Banyamin za m-ha u̱ no̱ ne̱ da, remu̱ zu̱ Yusuhu maru̱g tu̱msu̱ wa kuse̱ u̱ war-wa. A o̱ku̱n no̱mu yo̱-o̱ kume̱ wa u̱ do̱m-u u-fu̱n, no̱ u̱t-wa me̱ ne̱nge̱n-yu̱ hi-u̱r pus-de̱, m-mar u̱ remu̱ namu̱ jab.>> ");
INSERT INTO gel_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Me̱r-su̱ re̱g u-shu̱ u̱ no̱m-du̱ u-tát u̱ dak-u̱ Kan'ana. ");
INSERT INTO gel_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","M-vaste̱, Yakubu u̱ ya-u-bu wa ne̱ tase̱ re-du̱ no̱m u̱t-re̱ u̱ u̱n kabne̱ du̱gu̱ dak-u̱ Masar, Yakubu zu̱ u̱n, <<Barmu̱n u̱ Masar no̱ sur m-o̱o̱n in no̱m u̱t-re̱.>> ");
INSERT INTO gel_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Se̱di Yahuda zu̱ wu̱n, <<Ne̱t wu̱ babne̱ it no̱m u̱t-re̱ no̱ngu̱ it u̱s-rem u̱r-be̱b ne̱ u̱zu̱, <A no̱ haane̱ u̱ du̱-dim-u̱ no̱ ne̱ da, no̱ za hyanu̱ shu̱-u ri da.> ");
INSERT INTO gel_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","A mu̱ne̱ u̱zu̱ bo̱ yaag it do̱'e̱ u̱du̱ du̱-fade̱ it ne̱, it u̱ u̱t-ha it o̱o̱nu̱ bo̱ no̱m u̱t-re̱. ");
INSERT INTO gel_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Tu̱msu̱ a-bo̱ zu̱ye̱ it do̱'e̱ u̱ du̱-dim-u̱ it ne̱ da, it zaar m-ha da. U̱m zu̱u̱g iya remu̱ zu̱ ne̱t-u̱ wa zu̱u̱g it, <No̱ za hyanu̱ shu̱-u ri da, se̱ no̱ hagu̱n u̱ du̱-dim-u̱ no̱ ne̱.> >> ");
INSERT INTO gel_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Isra shit wa zu̱ u̱n, <<¿Ya wa'e̱ no̱ no̱mtu̱ me̱ no̱mtu̱ za so̱-to̱? ¿Yan-o̱ wa'e̱ no̱ wartu̱ ne̱t-u̱ wa u̱zu̱ no̱ o̱tte̱ du̱-dim?>> ");
INSERT INTO gel_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","E̱ shu̱s e̱ zu̱ wu̱n, <<Ne̱t-u̱ wa no̱mgu̱ it u̱r-shu̱t du̱ yu̱-du̱ u-bu it. Wa shit it, <¿U̱so-u no̱ o̱mo̱n u̱r-fat? ¿No̱ o̱mo̱n u̱ du̱-dim-u̱ no̱ ne̱?> Da-u o̱ it o̱nke̱ shu̱t-du̱ wa no̱me̱ it, ¿it nak u̱zu̱ wa do̱'e̱ u̱t-zu̱, <Kabnu̱n du̱-dim-u̱ no̱ u̱ haan u̱ ana>?>> ");
INSERT INTO gel_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yahuda zu̱ Isra u̱so-u wa, <<Yage̱ it ha u̱du̱ du̱-dim-u̱ it ne̱, remu̱ it do̱'e̱ it kwu̱mu̱n no̱m u̱t-re̱, remu̱ zu̱ tass in mar u̱ ya'ag-u̱ in ne̱ da. ");
INSERT INTO gel_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Me̱ hi-du̱ war ri me̱ mu̱u̱tu̱n wu̱n m-yar. Gwat wu̱n u̱ ko̱m-u̱t ri, a mu̱ne̱ u̱zu̱ u̱m mu̱u̱tu̱n wu̱n u̱-shu̱ ró da, yage̱ hyu̱-m ró u̱ shu̱'u̱t u̱ hi-u̱r ri m-mo̱mmo̱. ");
INSERT INTO gel_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Abite̱ u̱zu̱ in naaste̱ u-da da, in za haag u-yu̱r u̱ Masar kanda uno̱ da-o̱.>> ");
INSERT INTO gel_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Se̱ u̱so-u u̱n Isra zu̱ u̱n, <<A mu̱ne̱ u̱zu̱ yaku̱n fu̱n-ya zaar da, se̱ no̱ kab no̱m-u̱t so̱-to̱ tu̱ u-dak no̱ wa u̱t-ba. No̱ hu̱tu̱ wu̱n u-nya. No̱m-tu̱ wu̱s u-haku̱n ne̱, u̱ bu̱-mu̱ so̱ ne̱, u̱ po̱'o̱g-tu̱ fistashiyo ne̱ u̱ po̱'o̱g-tu̱ arman ne̱. ");
INSERT INTO gel_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Kabu̱n shik i ze̱ge̱ i no̱ kabe̱ u-so u-yu̱r, no̱ kab shik i na wa'-u̱ no̱ u̱t-ba, remu̱ jiya u̱zu̱ swas-mo̱ na no̱me̱. ");
INSERT INTO gel_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Kabu̱n du̱-dim-u̱ no̱ Banyamin tu̱msu̱, u̱ no̱ aru̱k m-mu̱ u̱du̱ ne̱t-u̱ wa za rem. ");
INSERT INTO gel_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Me̱ u̱t-ko̱n u-Ru̱ wa-u̱r-be̱b du̱ ko̱-uyan, u̱ wa wa' ne̱tu̱ wa ho̱g o̱n-u̱r no̱ u̱ka wa do̱te̱ yagu̱ no̱ mu̱u̱n u̱r-kot u̱ Simiyo̱n ne̱ u̱ du̱-dim-u̱ no̱ Banyamin ne̱. Se̱di me̱ a mu̱ne̱ u̱zu̱ me̱ u̱t-taag u̱ ya'ag-u̱ ri ne̱, yage̱ u̱ shu̱'u̱t iya.>> ");
INSERT INTO gel_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Se̱ ne̱t-u̱t to̱ ku̱b nya-u̱ u̱so-u u̱n zu̱ye̱ u̱n kab, u̱ shik ne̱ i ze̱ge̱ i u̱r-taku̱n u-so u-yu̱r, se̱ e̱ ku̱b Banyamin. E̱ aru̱k m-ho̱r m-ho̱r m-ha u̱ Masar, e̱ ees shu̱ Yusuhu. ");
INSERT INTO gel_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Da-u̱ Yusuhu hyane̱ Banyamin u̱ u̱n ne̱, wa zu̱ wa-gwat-du̱ bu-u wa, <<Kab ne̱t-u̱t to̱ m-ha u̱ bu-u ri. Bo̱ ho̱-u̱ e̱ u-bisa bo̱ no̱mu̱ u̱n no̱m u̱t-re̱ u-ho̱. U̱n de̱ re̱-du̱ no̱m u̱t-re̱ u̱r-ho̱ te̱k u̱ me̱ ne̱ u̱r-koto.>> ");
INSERT INTO gel_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ne̱t-u̱ wa nom u̱ka Yusuhu zu̱tte̱ wa no̱m, wa toot e̱ u̱ bu-u Yusuhu. ");
INSERT INTO gel_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","E̱ hog u-gye̱r so̱k remu̱ zu̱ na kagu̱b e̱ m-ha u̱ bu-u Yusuhu. E̱ nom u̱s-dorog u̱zu̱, <<Remu̱ zu̱ na wa'ag-u̱ in shik-u̱ ba-u̱t in o̱ wa'e̱ na ku̱bu̱t in m-ha u-bu, wa u̱t-sa wa maas in u̱t-baas ne̱, u̱ remu̱ wa muut in to̱k-ne̱ tu̱msu̱ wa o̱nk janka in.>> ");
INSERT INTO gel_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Da-u̱ u̱n teene̱ is-u̱ bu-u Yusuhu, u̱n no̱mu̱ wa-gwat-du̱ bu-u Yusuhu u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","U̱n zu̱ wa, <<Gag jab, u̱so u-bu ri, it hagu̱n u̱ ana u̱r-taku̱n remu̱ it oot no̱m u̱t-re̱. ");
INSERT INTO gel_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Da-u̱ it teye̱ be-du̱ it do̱te̱ u̱-cu̱s m-gye̱p, it u-pus ba-u̱t it, it bit shik i ko̱wan u̱ ba-u̱r wa. It mu̱tu̱n e̱ ho̱n-ho̱n u̱ka na ya'aste̱ it. Rem iya it mu̱u̱tu̱n e̱. ");
INSERT INTO gel_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","It haagu̱n u̱ e̱ke̱n shike̱ ne̱ remu̱ it oot o̱ko̱n no̱m u̱t-re̱ o̱. It nak ko̱wana wa'e̱ it shik u̱t-ba da.>> ");
INSERT INTO gel_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Wa zu̱ u̱n, <<No̱nge̱, a no̱ ho̱g u-gye̱r da. Ru̱-u no̱, o̱ye̱ Ru̱-u̱ u̱so-u no̱, wa wa'-u̱ no̱ shik-u̱ ba-u̱t no̱, u̱m o̱nkte̱ shik no̱ to̱pe̱.>> Se̱ wa rwu̱tu̱n Simiyo̱n u̱ be-du̱ u̱n o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Wa-gwat-du̱ bu-u Yusuhu ku̱b u̱n m-ha bu-u Yusuhu. Wa ye u̱n m-bu̱ u̱n jaas u̱s-na u-bu, se̱ wa ye janka u̱n no̱m u̱t-re̱. ");
INSERT INTO gel_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","U̱n zo̱ng no̱mu̱ Yusuhu u-nya a wa mu̱ne̱ u-ho̱, remu̱ zu̱ u̱n ho̱k u̱zu̱ u̱n u̱ e̱ ne̱ do̱'e̱ no̱m-du̱ u-re̱ u̱r-kot. ");
INSERT INTO gel_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Da-u̱ Yusuhu mu̱ne̱ u-bu, se̱ u̱n kabnu̱ wa nya-u̱ u̱n haane̱ u̱ o̱ne̱ u-bu, u̱n he̱ u-dak u̱-shu̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Wa shit u̱ka u̱n o̱tte̱, se̱ wa zu̱, <<¿Re̱-o̱ u-ne̱nge̱n u̱so no̱ wu̱ no̱ waru̱ me̱? ¿Wa o̱mo̱n u̱r-fat?>> ");
INSERT INTO gel_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","U̱n shu̱s u̱n zu̱, <<U̱, to̱k-u̱ ró u̱so-u it o̱ m-yar.>> Se̱ u̱n host u̱t-ka'at u̱n kaku̱s hi-u̱t u̱n u-dak u̱n yu̱ wa m-ze̱g. ");
INSERT INTO gel_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Da-u̱ Yusuhu gwate̱ se̱ wa hyen du̱-dim-u̱ wa Banyamin, (wu̱ na mate̱ e̱ wane̱ u-ino̱ u-gan), wa zu̱, <<¿Unwa o̱ du̱-dim-u̱ no̱, wu̱ no̱ ware̱ me̱?>> Wa zu̱ Banyamin, <<Ru̱-u̱ nom u̱r-kot u̱ bo̱ ne̱, wa wa'-u̱ bo̱ u-kom, wa'-u̱ zwar.>> ");
INSERT INTO gel_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Se̱ gu̱t-du̱ u̱s-kan haan Yusuhu u̱ shu̱ o̱r-u̱t wa ne̱, se̱ wa aru̱k m-cwa u-kur u̱-me̱, wa nom u̱s-kan u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Da-u̱ wa tase̱ u̱s-kan, wa sa'ap u-shu̱ wa mu̱u̱n u̱du̱ u̱n. Wa garu̱g hi-u̱r wa, wa zu̱ na mo̱t no̱m u̱t-re̱. ");
INSERT INTO gel_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Na yu̱ Yusuhu u̱-wa no̱m u̱t-re̱ o̱, na ye tu̱-wu̱to̱ Yusuhu u̱ e̱ no̱m u̱t-re̱ o̱, na yu̱ ne̱t-u̱ Masar u̱ e̱ no̱m u̱t-re̱ o̱. E̱ no̱ng iya remu̱ zu̱ ne̱t-tu̱ Masar reet u̱r-kot u̱ Ibra-ne̱ da remu̱ zu̱ no̱m-tu̱ m-'e̱ to̱ u̱du̱ ne̱t-tu̱ Masar e̱ no̱m u-re̱ ne̱t-tu̱ Ibra-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Na shu̱gu̱sse̱ o̱r-u̱t Yusuhu u̱-shu̱ wa, ko̱wan u̱ka hak-su̱ u̱r-mat-u̱ wa, du̱gu̱ yu̱-wu̱ya u̱-haan u̱ du̱-dim, u̱n got o̱r-u̱t u̱n kowan hu̱ mu̱rimmo̱. ");
INSERT INTO gel_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yusuhu wu̱ na ya u̱n no̱m u̱t-re̱ u̱ na haatu̱n u̱ shu̱ wa. Tu̱msu̱ na yu̱ Banyamin o̱g-u̱r yadde̱ m-ze̱g du̱ ko̱wan uso̱ u-tan, se̱ u̱n re u̱n so jab gan. ");
INSERT INTO gel_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yusuhu yu̱ wa-gwat-du̱ bu-u wa tun-to̱ bo̱r-to̱, <<Shu̱u̱se̱ ba-u̱t u̱n u̱ hyu̱ u̱ka u̱n do̱te̱ u̱t-kere̱ u̱t-kab m-mu̱, tu̱msu̱ bo̱ wa'u̱ shik-u̱ ko̱wan u̱ ba-u̱r wa.>> ");
INSERT INTO gel_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Yusuhu zu̱ wa-gwat-du̱ bu wa, <<Wa ko̱k-du̱ swadu̱ m-bu̱ ri du̱ m-baku̱t, ba-du̱ du̱-dim-u̱ u̱n, u̱r-kot u̱ shik-u̱ hyu̱ wu̱n ne̱.>> Wa no̱m u̱ka Yusuhu zu̱tte̱ wa no̱m. ");
INSERT INTO gel_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Da-u̱ is gase̱, na tom ne̱t-u̱t to̱ e̱ aru̱k m-mu̱ u̱ janka u̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Da-u̱ u̱n arke̱ u̱n teeg m-ra u-bo̱ ne̱ sok da, Yusuhu tom wa-gwat-du̱ bu-u wa, <<Abo̱ bite̱ u̱n bo̱ zu̱ u̱n, <It no̱mgu̱ no̱ no̱m-u̱t so̱-to̱, ¿Remu̱ u-yan o̱ wa'e̱ no̱ top-u̱t no̱m-u so̱-o̱ u̱ yo̱-o̱? ");
INSERT INTO gel_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","¿Dinde̱ a ko̱k-du̱ m-bu̱ du̱ u̱so u-bu ri da du̱ wa gotte̱ no̱mu̱ do̱'e̱ u̱t-no̱m u-shu̱? Uno̱ no̱mu yo̱-o̱ o̱ no̱ no̱me̱.> >> ");
INSERT INTO gel_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Da-u̱ wa bite̱ u̱n, se̱ wa waru̱ u̱n no̱mu̱ Yusuhu zu̱ wa u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","E̱ shu̱s e̱ zu̱ wa, <<¿Yan o̱ wa'e̱ u̱so u-bu ri bo̱ u̱t-zu̱ inya? It to̱k-ne̱ ró e̱, it tamu̱g no̱m-du̱ o̱ko̱n go̱-du̱ uno̱ da. ");
INSERT INTO gel_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","It mu̱u̱tu̱n shik-u̱ it bite̱ u̱ ba-u̱t it da-u̱ it muye̱ Kan'ana. ¿Remu̱ yan-o̱ it do̱te̱ hiw-du̱ kwam-tu̱ shik tu̱ bu̱-mu̱ u̱t-ro u̱ tu̱ pus-to̱ ne̱ du̱gu̱-du̱ u̱so-u̱ bu-u ró? ");
INSERT INTO gel_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","A-bo̱ hyane̱ waku̱n u̱ ko̱k-du̱ m-bu̱ de̱ ne̱ it, ho̱ wa. Tu̱msu̱ it i kuse̱ be̱e̱t e̱ shu̱u̱t to̱k-ne̱ ró.>> ");
INSERT INTO gel_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ne̱t-u̱ wa zu̱, <<No̱nge̱, me̱ no̱mu̱ no̱m-u̱ no̱ zu̱ye̱. Se̱di wu̱ na hyane̱ u̱ ko̱k-du̱ m-bu̱ ne̱ wa do̱'e̱ u̱t-shu̱'u̱t to̱k-u̱ ri, no̱ i kuse̱ no̱ aru̱k m-mu̱ u-bu.>> ");
INSERT INTO gel_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Se̱ u̱n be̱e̱t kowan cu̱stu̱n ba-u̱r wa du̱gu̱ janka u̱n, tu̱msu̱ e̱ upus to̱. ");
INSERT INTO gel_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Wa-gwat-du̱ bu-u Yusuhu he̱e̱se̱ u̱t-goot, du̱gu̱-du̱ yu̱-wu̱ya u̱ haan u̱du̱ du̱-dim. Se̱ na hyen ko̱k-du̱ m-bu̱ de̱ ba-u̱r Banyamin. ");
INSERT INTO gel_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Remu̱ iya, se̱ e̱ keemse̱ kus-u̱t e̱. Tu̱msu̱ e̱ gagu̱ janka u̱t-cwu̱, e̱ bir m-mu̱ u-bo̱. ");
INSERT INTO gel_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Da-u̱ Yahuda u̱ o̱r-u̱t wa ne̱ mu̱ne̱ u-dim, se̱ e̱ to bu-u Yusuhu. Yusuhu o̱mo̱n u̱ shu̱'u̱t, wa-gwat-du̱ Yusuhu wa waru̱ wa no̱mu̱ no̱me̱ u-be̱e̱t. Tu̱-wu̱to̱ Yusuhu ne̱ be̱e̱t e̱ he u-dak u̱-shu̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusuhu zu̱ u̱n, <<¿Yan-o̱ no̱ no̱me̱ inya? ¿No̱ nak u̱zu̱ ne̱t ba me̱ u̱ napu̱ no̱mu̱ waku̱n nape̱ da?>> ");
INSERT INTO gel_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yahuda shu̱s, wa zu̱, <<U̱so u-bu ri, ¿Yan rem-se̱ it de̱ u̱t-no̱me̱? ¿Re̱-o̱ it do̱te̱ ko̱su̱ ko̱b-du̱ u̱t-ba'as u̱ it? Ru̱-o̱ no̱mu̱ it to̱p-u̱ no̱mu̱ it no̱me̱. Remu̱ iya it be̱e̱t it-u̱ u̱t-shu̱'u̱t to̱k-ne̱ u̱ wu̱ na bite̱ u̱ ko̱k-du̱ m-bu̱ ba-u̱r wa.>> ");
INSERT INTO gel_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yusuhu zu̱, <<U̱m za kere̱ no̱m-du̱ o̱ko̱n u̱ka no̱ zu̱tte̱ da, u̱ Ru̱-u̱ mang. Wu̱ hiwe̱ ko̱k-du̱ m-bu̱ wa do̱'e̱ u̱t-shu̱'u̱t to̱k-u̱ ri. No̱ kuse̱ se̱ no̱ aru̱k m-mu̱ u̱ bu-u̱ u̱so-u no̱ u̱ jab-u̱ pus-o̱.>> ");
INSERT INTO gel_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yahuda haan u̱du̱ Yusuhu wa zu̱, <<U̱so u-bu ri, gag jab, yage̱ to̱k-u̱ ró no̱m u̱s-rem u̱ bo̱ ne̱. A-bo̱ no̱m u̱s-ryab u̱ to̱k-u̱ ró da, ko̱ ba shu̱'u̱te̱ u̱zu̱ bo̱ o̱ u̱r-be̱b ne̱ u̱ka Faru̱k-u̱ Masar. ");
INSERT INTO gel_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","U̱so u-bu ri shu̱ku̱t to̱k-u̱ wa, <¿No̱ o̱mo̱n u u̱so ne̱ ko̱ tu̱ dim-u̱ no̱ u̱r-fat?> ");
INSERT INTO gel_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","It zu̱ u̱so u-bu ri, <Wa o̱mo̱n u̱r-fat se̱di wa wu̱u̱mte̱. Se̱di wa o̱tte̱ u̱r-vaste̱ du̱ wa mate̱ da-u̱ wa wu̱u̱me̱. Yu̱-wu̱ya wa maru̱g, hu̱no-u wa kuse̱ u-gan u̱du̱ ino-u wa, u̱so-u e̱ o̱ cwan-u̱t wa sok.> ");
INSERT INTO gel_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","<<Bo̱ zu̱ to̱k-ne̱ ró haatu̱n wa u̱du̱ ró, bo̱ hyan wa u̱ hi-du̱ war ró. ");
INSERT INTO gel_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","It wargu̱ u̱so u-bu ri u̱zu̱, <Wa'-u̱ wa yakte̱ u̱so-u wa da, u̱-re̱m u̱zu̱ awa yage̱ wa, u̱so wa u̱t-mar.> ");
INSERT INTO gel_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Bo̱ zu̱ it to̱k-u̱ ne̱ ró, <A du̱-dim-u̱ no̱ haane̱ u̱r-kot u̱ no̱ ne̱ da, u̱m da yage̱ no̱ sur m-hyan shu̱-u ri da.> ");
INSERT INTO gel_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Da it muye̱ u̱du̱ u̱so-u it, it waru̱ wa no̱mu̱ u̱so u-bu ri zu̱ye̱. ");
INSERT INTO gel_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","<<U̱so-u it zu̱, it mu̱u̱n it sur m-o̱o̱n no̱m u̱t-re̱. ");
INSERT INTO gel_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Tu̱msu̱ it zu̱ wa, <It zaaru̱ mu̱u̱n da, se̱ du̱-dim-u̱ it no̱k u̱r-kot u̱ it ne̱ u̱ da-u o̱ it do̱'e̱ u̱r-mu̱n. A du̱-dim-u̱ it do̱'e̱ u̱r-kot u̱ it ne̱ da, it zaar u̱t-sur m-hyan shu̱-u̱ ne̱t-u̱ wa da.> ");
INSERT INTO gel_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","<<To̱k-u̱ ró u̱so-u it zu̱, <U̱ka no̱ nu̱pte̱, ne̱ta ri o̱tte̱ ya'ag-u̱ campa-ne̱ yu̱r, i wa mate̱ u̱du̱ ri. ");
INSERT INTO gel_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Wa-gan aru̱kte̱ du̱gu̱-du̱ ri, se̱di u̱m zu̱, <<Na kemu̱sse̱ wu̱n u̱t-kik u̱t-kik.>> Du̱gu̱ da-u o̱, u̱m hyanu̱g wa da. ");
INSERT INTO gel_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","A no̱ kabe̱ unwa, tu̱msu̱ o̱ko̱n no̱m-o̱ kume̱ wa, no̱ wa'-u̱ hi-u̱r pus-de̱ ri de̱ ha u̱du̱ i mare̱ ne̱ u̱ remu̱ namu̱ jab.> ");
INSERT INTO gel_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","<<U̱-da o̱, u̱m za kere̱ u̱r-mu̱ u̱du̱ u̱so-u it za wa'-u̱ wa da. Remu̱ zu̱ jab-u̱ u̱so-u it o̱ m-sak u̱ fat-du̱ wa'-u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","A mu̱ne̱ u̱zu̱ u̱so-u it hyanu̱g me̱ za wa'-u̱ wa, wa u̱t-mar. It to̱k-ne̱ ró it u̱t-wa u̱ hi-u̱r pus-de̱ u̱so-u it he̱ u-sag remu̱ namu̱ jab. ");
INSERT INTO gel_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","U̱m no̱mu̱g es-du̱ u̱s-rem u̱du̱ u̱so-u ri, u̱zu̱ me̱ mu̱tu̱n wu̱n u-bu m-yar. U̱m zu̱ wa, <A mu̱ne̱ u̱zu̱ u̱m mu̱u̱tu̱n wu̱n u̱du̱ ró da, me̱ kabu̱ no̱mu̱ do̱'e̱ kwu̱m-du̱ wu̱n mo̱mmo a-mu̱u̱ne̱ u̱zu̱ u̱m mu̱u̱tu̱n wu̱n u̱ du̱ ró da.> ");
INSERT INTO gel_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","<<U̱ da-o̱, gag jab, yage̱ u̱ wa-m-ank-u̱ ró shu̱'u̱t to̱k-u̱ u̱so u-bu ri u̱ swas-mu̱ wa'-u̱ wa. Yage̱ wa'-u̱ wa aru̱k m-mu̱ e̱ tu̱-wu̱to̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","¿Re̱-o̱ u̱m do̱te̱ u̱r-mu̱ u̱du̱ u̱so-u ri, a mu̱ne̱ u̱zu̱ wa zaar u̱r-kot u̱ me̱ ne̱ da? A-bo̱ yage̱ u̱m swa u̱r-ko̱b du̱ do̱'e̱ u̱ haan u̱ u̱so ri da.>> ");
INSERT INTO gel_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yusuhu ke̱rge̱ ho̱-du̱ u̱s-ram u̱ka wa o̱tte u̱t-ho̱g da. Wa zu̱ u̱ to̱k-ne̱ wa be̱e̱t e̱ aru̱k m-rwu̱ u̱-do̱ u̱ cwar-yu̱ u̱r-be̱b. E̱ yage̱ wa u-kur u̱ tu̱-wu̱to̱ wa ne̱. Da-u o̱ wa waru̱ u̱n u̱zu̱, <<Me̱ wa o̱ye̱ Yusuhu!>> ");
INSERT INTO gel_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Wa jaku̱s cwar-yu̱ u̱s-kan m-yat! Se̱ ne̱t-tu̱ Masar tu̱ o̱o̱ge̱ u̱-do̱ hog wu̱n, tu̱msu̱ u̱ ne̱t-tu̱ pyu̱-u̱ Faru̱k-u̱ Masar ne̱ e̱ hog wu̱n. ");
INSERT INTO gel_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusuhu zu̱ o̱r-u̱t wa ne̱, <<Me̱ o̱ Yusuhu. ¿U̱so-u ri o̱mo̱n u̱r-fat?>> E̱ kerge̱ zu̱du̱ wu̱n o̱ko̱n da, remu̱ zu̱ gye̱r-yu̱ shu̱ku̱p e̱ sok. ");
INSERT INTO gel_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Se̱ Yusuhu zu̱ o̱r-u̱t wa, <<Hiknu̱n u̱t-mo̱r u̱-me̱ ne̱.>> Da u̱n hikne̱, wa zu̱ u̱n, <<Me̱ wa du̱-dim-u̱ no̱ wu̱ na zu̱ye̱ Yusuhu, wu̱ no̱ babe̱ to̱k-u̱ Masar.>> ");
INSERT INTO gel_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","A no̱ naas jab da ko̱ no̱ hyan na-m waku̱n da. U̱m zu̱u̱g iya remu̱ zu̱ Ru̱-o̱ ba m-haatu̱n me̱ u̱ ana remu̱ u̱m guut fat-u̱t no̱. ");
INSERT INTO gel_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Na no̱ng u̱s-hak u̱s-yu̱r u̱s-me̱r u̱ da-o̱, kwu̱ku̱s u̱s-hak u̱s-tan, su̱ na za u̱r-to̱m da, na za tu̱msu̱ ket da. ");
INSERT INTO gel_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ru̱-o̱ to̱mnu̱ me̱ u̱m haan u̱-shu̱ no̱, remu̱ zu̱ na kus u̱t-ne̱t u̱-me̱ ko̱-u̱r no̱, iya o̱ fu̱n-yu̱ Ru̱-u̱ zo̱ngte̱ gwu̱du̱ no̱. ");
INSERT INTO gel_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","<<Remu̱ iya a no̱ haatu̱n me̱ u̱ ana da, Ru̱-o̱ haatu̱n me̱ u̱ ana! Wa wa'ag u̱m shu̱'u̱t sha-mu̱ u̱so u̱du̱ Faru̱k-u̱ Masar. U̱m o̱ u̱so u-bu u̱ ko̱-uyan u̱-me̱ bu wa tu̱msu̱ u̱m o̱ wa-u̱r-faru̱k u̱ Masar u-be̱e̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","U̱-da o̱ no̱mo̱n m-ho̱r no̱ waru̱ u̱so u-bu ri u̱zu̱ no̱mu̱ wa'-u̱ wa Yusuhu zu̱ye̱ ya, <<Ru̱-u̱ muutu̱ me̱ u̱so ubu u̱ Masar u-be̱e̱t. Haane̱ u̱du̱ ri za naas u-da. ");
INSERT INTO gel_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Bo̱ u̱t-ker shu̱'u̱t u̱t-mo̱r ne̱ u̱ Gas-u̱ Go̱sen, bo̱, u̱ ya'ag-u̱ ró ne̱, u̱ ya'ag-u̱ ya'ag-u̱ ró ne̱, u̱-ban-tu̱ ca u̱ ban-tu̱ gwaar ne̱, u̱ ban-tu̱ na-u̱ ró ne̱, u̱ ko̱-uyan u̱ o̱ye̱ u̱ ró. ");
INSERT INTO gel_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Me̱ gwat-u̱ bo̱ u̱ hak-su̱ u̱s-tan su̱ u̱s-me̱r su̱ o̱o̱ne̱. Me̱ no̱mu̱ ka u̱m do̱te̱ u̱t-no̱m u-be̱e̱t u̱m ya bo̱ no̱m u̱t-re̱. A-bo̱ haane̱ u̱ ana da no̱ u̱ a-u-bu ró ne̱ u̱ to̱k-ne̱ ró be̱e̱t bo̱ u̱t-ho̱g u̱s-me̱r.>> ");
INSERT INTO gel_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yusuhu zu̱ u̱n, <<U̱ da-o̱ no̱ hyanu̱g hi-du̱ war-no̱, o̱r-u̱ ri Banyamin hyanu̱g u̱zu̱ me̱ wa o̱ye̱ Yusuhu, me̱ o̱ye̱ u̱s-remu̱ u̱ no̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","De̱e̱n, no̱ waru̱ u̱so-u ri u̱zu̱ na ya me̱ o̱g-u̱r yat-de̱ u̱ dak-u̱ Masar. De̱e̱n, no̱ waru̱ wu̱n no̱m-u̱ no̱ hyane̱ no̱ hatu̱n wu̱n u̱ ana za naas u-da.>> ");
INSERT INTO gel_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Wa ham-u̱t Banyamin, wa hu̱ u̱s-kan su̱ u̱r-so̱. Banyamin ham-u̱t wa tu̱msu̱ wa hu̱ u̱s-kan. ");
INSERT INTO gel_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yusuhu ham-u̱t tu̱-wu̱to̱ wa ne̱ be̱e̱t wa hu̱ u̱s-kan. Da wa tase̱ se̱, e̱ he̱e̱se̱ u̱s-rem u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Da waku̱n hu̱u̱te̱ u̱s-rem u̱du̱ pyu̱-u̱ Faru̱k-u̱ Masar u̱zu̱ o̱r-u̱t Yusuhu hagu̱n, faru̱k-u̱ ne̱t-u̱t wa ne̱ nom u̱r-so̱ sok. ");
INSERT INTO gel_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Faru̱k-u̱ Masar zu̱ Yusuhu, <<Waru̱ tu̱-wu̱to̱ ró no̱mu̱ u̱m u̱t-sa no̱ no̱m-u̱ ya: Saku̱n bisa-u̱t no̱ hyu̱ no̱ aru̱k m-mu̱ u̱ dak-u̱ Kan'ana. ");
INSERT INTO gel_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","De̱'e̱ bo̱ waru̱ u̱so-u ró u̱ ne̱t-tu̱ u-bu ró ne̱ e̱ mu̱u̱n u̱du̱ ri. Me̱ ya bo̱ dak-u̱ ze̱ge̱ u̱r-zwar, dak-u̱ Masar, bo̱ re̱ kwu̱m-tu̱ u-dak.>> ");
INSERT INTO gel_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","<<Tu̱msu̱ waru̱ u̱n u̱zu̱, <No̱mu̱ u̱m u̱t-sa no̱ no̱m-u̱ ya,> Kabu̱n ke̱ke̱-yu̱ u-jwaak du̱gu̱ Masar, remu̱ no̱ kabtu̱n ya'ag-u̱ re̱k-e̱ u̱ ne̱ta-u̱t no̱ ne̱, no̱ haan u̱ u̱so-u no̱ ne̱ u̱ ana u̱ dak-u̱ Masar. ");
INSERT INTO gel_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","A no̱ naas jab-u̱ kwu̱m-u̱t no̱ ne̱ da, remu̱ zu̱ no̱m-u̱t so̱-to̱ tu̱ Masar to̱ do̱'e̱ u̱t-shu̱'u̱t tu̱ no̱. Rem iya, a se̱ no̱ kabgu̱n u̱t-no̱m du̱gu̱ Kan'ana da.>> ");
INSERT INTO gel_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Yaag-u̱ campa-ne̱ Isra nom iya u̱ka faru̱k zu̱tte̱ e̱. Yusuhu yu̱' u̱n ke̱ke̱-su̱ jwaak u̱ka Faru̱k-u̱ Masar zu̱tte̱. Tu̱msu̱ wa yu̱' u̱n no̱m u̱t-re̱ u̱n do̱'e̱ u̱t-re̱ u̱-do̱mu̱ fu̱n. ");
INSERT INTO gel_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yusuhu yaag u̱n be̱e̱t kus-u̱t po-to̱, tu̱msu̱ u̱du̱ Banyamin wa yase̱ ko̱nko̱ shik u̱t-ko̱k u̱t-tu̱t 300, u̱ kus-u̱t po-to̱ ne̱ uso̱ u-tan. ");
INSERT INTO gel_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Tu̱msu̱ no̱m-tu̱ wa to̱mtu̱n u̱so-u wa ya, no̱m-u̱t so̱-to̱ tu̱ Masar wa wu̱' to̱ do̱m-u̱ gob-u̱ janka o̱p. Wa yu̱' wu̱n hyu̱ u̱ u̱r-be̱re̱di ne̱ u̱ remu̱ ha-m wu̱n u̱ Masar tu̱msu̱ wa wu̱' to̱ do̱m-u̱ mangu̱ janka o̱p. ");
INSERT INTO gel_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Tu̱msu̱ da u̱n o̱o̱ge̱ u̱ mo̱ttu̱ u̱r-aru̱k wa zu̱ u̱n, <<A no̱ no̱m u-har u̱ do̱m u-fu̱n da!>> Se̱ wa tok o̱r-u̱t wa ne̱ u̱n aru̱k. ");
INSERT INTO gel_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","E̱ yage̱ Masar, e̱ aru̱k m-mu̱ u̱du̱ u̱so-u e̱ Yakubu u̱ dak-u̱ Kan'ana. ");
INSERT INTO gel_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","U̱n zu̱ u̱so-u u̱n, <<Yusuhu o̱mo̱n u̱r-fat! Faru̱k-u̱ Masar wa'ag wu̱n damra ne̱t Masar.>> Se̱ jab-u̱ Yakubu yu̱ne̱ wa kerge̱ u̱s-rem da. ");
INSERT INTO gel_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Da-u̱ u̱n waru̱ wa no̱m-u̱ Yusuhu zu̱ye̱ u-be̱e̱t, da-u̱ wa hyane̱ ke̱ke̱-su̱ u-jwaak su̱ wa to̱mtu̱n na kabu̱n wu̱n u̱ haan u̱ Masar, se̱ jab-u̱ u̱so u̱n Yakubu tor. ");
INSERT INTO gel_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Tu̱msu̱ Isra zu̱, <<U̱m eeste̱ u̱ da-o̱ u̱zu̱ wa'-u̱ ri Yusuhu o̱mo̱n u̱r-fat. Me̱ u̱t-do̱'e̱ u̱m hyan wa kanda u̱m mar.>> ");
INSERT INTO gel_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Se̱ Isra ku̱b ko̱-uyan u̱ wa o̱tte̱ wa aru̱k m-ha u̱ dak-u̱ Masar. Da-u̱ wa teene̱ bo̱-u̱ Be̱rshe̱ba, wa no̱m ya-du̱ to̱o̱g u̱du̱ Ru̱-u̱ u̱so-u wa Ishaku. ");
INSERT INTO gel_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","M-gyu̱p Isra nom u-hyan Ru̱-u̱ no̱m u̱s-rem u̱ wa ne̱. Wa zu̱, <<Yakubu! Yakubu!>> Wa shu̱s wa zu̱, <<Me̱ ya ana!>> ");
INSERT INTO gel_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Se̱ wa zu̱, <<Me̱ o̱o̱ge̱ u-Ru̱ u̱ u̱so-u ró. A-bo̱ ho̱g u-gye̱r da do̱'e̱ u̱ Masar. Remu̱ zu̱ u̱ ku̱na, u̱m do̱te̱ u̱t-wa u̱ ko̱-u̱r ró no̱m u-tát u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Me̱ u̱t-ha u̱ no̱ ne̱ u̱ dak-u̱ Masar, me̱ mu̱u̱tu̱n no̱ tu̱msu̱ u̱ dak-u̱ Kan'ana. Bo̱ u̱t-mar u̱ dak-u̱ Masar, wa'-u̱ ró Yusuhu wa do̱'e̱ jwak-du̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Da-u̱ Yakubu yage̱ bo̱-u̱ Be̱rshe̱ba, ya'ag-u̱ campa-ne̱ wu̱n ku̱b wu̱n m-ha u̱ Masar. E̱ ku̱b Isra, u̱ yaag ne̱, u̱ ne̱ta-u̱t e̱ ne̱, u̱ ke̱ke̱-su̱ u-jwaak yu̱ Faru̱k-u̱ Masar yase̱ na kabu̱n u̱n. ");
INSERT INTO gel_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","E̱ ku̱b na e̱ u̱ bisa-tu̱ u-bu ne̱ tu̱ e̱ kume̱ u̱ dak-u̱ Kan'ana, tu̱msu̱ Yakubu u̱ ko̱-u̱r wa ne̱ u̱r-be̱e̱t e̱ aru̱k m-ha u̱ dak-u̱ Masar. ");
INSERT INTO gel_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Yakubu aru̱k m-ha u̱ Masar u̱ ya'ag-u̱ wa ne̱ be̱e̱t, u̱ ya'ag-u̱ ya'ag-u̱ wa ne̱, ya'ag-u̱ campa-ne̱, u̱ ya'ag-u̱ ne̱ta-ne̱, u̱ ko̱-u̱r wa ne̱ u̱r-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Unto̱ to̱ o̱ye̱ dim-tu̱ ya'ag-u̱ campa-ne̱ Isra (Yakubu u̱ ko̱-u̱r wa ne̱) e̱ do̱'e̱ u̱ dak-u̱ Masar: Rube̱n wa o̱ye̱ mat-du̱ u-shu̱ Yakubu. ");
INSERT INTO gel_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Yaag-u̱ campa-ne̱, i na mate̱ Rube̱n dim-u̱t e̱ na zu̱ye̱: Hano̱k, Paru, He̱zo̱n, Hazro̱n u̱ Karami ne̱. ");
INSERT INTO gel_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Yaag-u̱ campa-ne̱ Simiyo̱n e̱ o̱ye̱: Je̱miye̱r, Jamin, O̱had, Jakin, Zo̱har, u̱ Shawuru (wa'-u̱ ne̱ta yu̱ Kan'ana). ");
INSERT INTO gel_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Yaag-u̱ campa-ne̱ Re̱wi e̱ na zu̱ye̱: Gaso̱n, Ko̱hat, u̱ Mirari. ");
INSERT INTO gel_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yaag-u̱ campa-ne̱ Yahuda e̱ na zu̱ye̱: Er, u̱ Onan, u̱ Shera, Pe̱re̱z, u̱ Ze̱ra. (Tu̱msu̱ Er u̱ Onan maru̱g u̱ dak-u̱ Kan'ana). Yaag-u̱ Pe̱re̱z e̱ o̱ye̱: He̱zo̱n u̱ Hamur. ");
INSERT INTO gel_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Yaag-u̱ campa-ne̱ Issakar e̱ o̱ye̱: Tora, u̱ Fo̱wa, u̱ Yashub, u̱ Shimaro̱n. ");
INSERT INTO gel_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Yaag-u̱ campa-ne̱ Ze̱burun e̱ o̱ye̱: Se̱re̱, E̱ro̱n, u̱ Yareyer. ");
INSERT INTO gel_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ine̱ e̱ o̱ye̱ ya'ag-u̱ campa-ne̱ Riya i wa mate̱ Yakubu u̱ dak-u̱ Padan-aram, u̱r-kot u̱ gwu̱p-u̱ e̱ ne̱ Dinatu. Tat-u̱ ya'ag-u̱ Yakubu (ya'ag-u̱ ne̱ta-ne̱ ya'ag-u̱ campa-ne̱) i wa kume̱ du̱gu̱-du̱ Riya u̱r-shik u̱r-gan u̱ o̱p-u̱ tu̱t 33. ");
INSERT INTO gel_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Yaag-u̱ campa-ne̱ Gad e̱ o̱ye̱: Zifiyon, Hagai, Shuni, Ezbon, E̱ri, Arodi, u̱ Are̱ri. ");
INSERT INTO gel_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Yaag-u̱ Ashu̱r campa-ne̱ e̱ o̱ye̱: Imna, Isba, Isbi, u̱ Beriya u̱ hu̱no̱ e̱ ne̱ Sera. Yaag-u̱ campa-ne̱ Beriya e̱ o̱ye̱: Heba u̱ Markiyer ne̱. ");
INSERT INTO gel_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ine̱ e̱ o̱ye̱ ya'ag-u̱ Zirpa matu̱ Yakubu, i Raban yasu̱ gwu̱p-u̱ wa Riya e̱ o̱ o̱p u̱ shishin 16. ");
INSERT INTO gel_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yaag-u̱ campa-ne̱ Rahira ne̱ta Yakubu, yaag-e̱ yu̱r: Yusuhu ne̱ e̱ Banyamin. ");
INSERT INTO gel_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","U̱ dak-u̱ Masar, o̱ na mat-tu̱ Yusuhu Manase ne̱ e̱ Ifaramu. Dim-du̱ ino u̱n na zu̱ye̱ Asenat, gwu̱p-u̱ Potipera wa-to̱o̱g-u̱ bo̱-u̱ O̱n. ");
INSERT INTO gel_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Yaag-u̱ campa-ne̱ Banyamin e̱ o̱ye̱: Bera, Bekar, Asaber, Gera, Na'aman, Ehi, Rosh, Muppim, Huppim, u̱ Arada. ");
INSERT INTO gel_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ine̱ o̱ye̱ ya'ag-u̱ campa-ne̱ Rahira i wa matu̱ Yakubu, yaage̱ o̱p-u̱ nas 14. ");
INSERT INTO gel_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Ya-du̱ u̱r-campa Dan wa na zu̱ye̱: Husim. ");
INSERT INTO gel_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Yaag-u̱ campa-ne̱ Napari e̱ na zu̱ye̱: Jahazir, Guni, Jezar, u̱ Shirem. ");
INSERT INTO gel_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ine̱ e̱ o̱ye̱ ya'ag-u̱ campa-ne̱ Biru̱ha i wa matu̱ Yakubu, wu̱ Raban ya'e̱ gwu̱p-u̱ wa Rahira da-u̱ wa o̱o̱ge̱ ha-mu̱ u̱r-gu̱, ya'ag-u̱ wa o̱ ta'er 7. ");
INSERT INTO gel_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ne̱t-tu̱ haye̱ u̱ Masar u̱ Yakubu ne̱, i o̱ye̱ du̱gu̱ ko̱-u̱r wa, za u̱r-kot u̱ ne̱ta-tu̱ ya'ag-u̱ wa da, ne̱t-to̱ u̱t-shik u̱t-tu̱t u̱ ne̱t-tu̱ u̱t-shin 66. ");
INSERT INTO gel_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yusuhu o̱tte̱ ya'ag-u̱ campa-ne̱ yu̱r i na wa matu̱ wa u̱ Masar. Ne̱t-tu̱ bu-u Yakubu i haane̱ Masar, ne̱t-to̱ u̱t-shik u̱t-tu̱t u̱ o̱p 70 i o̱o̱ge̱ shu̱'u̱t Masar. ");
INSERT INTO gel_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakubu to̱mo̱g Yahuda, wa do̱'e̱ u̱du̱ Yusuhu u̱ remu̱ zu̱, wa ko̱snu̱ wa fu̱n-yu̱ do̱'e̱ wa u̱t-do̱r m-ha u̱ Gas-u̱ Go̱sen. Da-u̱ e̱ teene̱ Gas-u̱ Go̱sen dak-u̱ Masar. ");
INSERT INTO gel_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusuhu zo̱ng ke̱ke̱-yu̱ jwaak-u̱ wa, wa yu̱ne̱ wa aru̱k m-ha u̱ Go̱sen wa bit u̱so wa Isra. Za naas u-da da wa te shu̱ wu̱n, wa ham-u̱t u̱so wa, wa tumb u̱s-kan. ");
INSERT INTO gel_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isra zu̱ Yusuhu, <<Yage̱ u̱m m-mar u̱ da-o̱, remu̱ zu̱ u̱m hyanu̱g u̱ hi-du̱ war ri u̱zu̱ bo̱ o̱mo̱n u̱r-fat.>> ");
INSERT INTO gel_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Se̱ Yusuhu zu̱ o̱r-u̱t wa ne̱ u̱ ne̱t-tu̱ u̱ bu-u̱ u̱so-u wa ne̱, <<Me̱ u̱t-do̱'e̱ u̱m no̱m u̱s-rem u̱ Faru̱k-u̱ Masar ne̱. U̱m de̱ zu̱ wa, <Tu̱-wu̱to̱ ri ne̱ u̱ ne̱t-tu̱ bu-u̱ u̱so-u ri ne̱, i o̱o̱ge̱ u̱ shu̱'u̱t u̱ dak-u̱ Kan'ana, e̱ haagu̱n u̱du̱ ri. ");
INSERT INTO gel_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ne̱t-u̱t to̱ ne̱t-tu̱ gwat-du̱ u̱t-bisa to̱ u̱ gwaar ne̱, tu̱msu̱ e̱ haagu̱n u̱ ban-tu̱ ca e̱ ne̱ u̱ ban-tu̱ na ne̱, u̱ no̱mu̱ e̱ o̱tte̱ ne̱ u-be̱e̱t.> ");
INSERT INTO gel_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Da-u̱ Faru̱k-u̱ Masar fagu̱ no̱, wa shit, <¿Yan-o̱ o̱ ank-m no̱?> ");
INSERT INTO gel_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","No̱ de̱ zu̱ wa, <It a-gwat-du̱ ban-tu̱ u̱t-bisa ne̱ e̱, du̱gu̱ da-u̱ it o̱o̱ge̱ ya'ag-u̱ re̱k-e̱. It a-gwat-du̱ u̱t-bisa ne̱ e̱, u̱ka u̱so-u it nomte̱.> Da-u o̱ wa yagu̱ no̱ u̱ no̱ ne̱ shu̱'u̱t u̱ gas-u̱ Go̱sen, remu̱ zu̱ ne̱t-tu̱ Masar e̱ gu̱gu̱mte̱ a-gwat-du̱ u̱t-bisa ne̱ no̱m-tu̱ m-'e̱ to̱ u̱du̱ e̱.>> ");
INSERT INTO gel_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Yusuhu kagu̱b o̱r-u̱t wa ne̱ ne̱t-ne̱ tan, wa do̱'e̱ u̱-shu̱ Faru̱k-u̱ Masar. Wa waru̱ wa, <<U̱so ri u̱ o̱r-u̱t ri ne̱ e̱ haagu̱n du̱gu̱ Kan'ana u̱ ban-tu̱ ca ne̱ u̱ ban-tu̱ gwar-u̱ e̱ ne̱, u̱ ban-tu̱ na-u̱ e̱ ne̱, u̱ no̱m-tu̱ e̱ o̱tte̱ ne̱ u̱t-be̱e̱t. E̱ o̱ da-o̱ u̱ Gas-u̱ Go̱sen.>> Se̱ wa ko̱se̱ o̱r-u̱t wa u̱-shu̱ Faru̱k. ");
INSERT INTO gel_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Faru̱k-u̱ Masar shit u̱n u̱zu̱, <<¿Yan o̱ o̱ye̱ ank-m no̱?>> E̱ shu̱s e̱ zu̱, <<It a-gwat-du̱ u̱t-bisa ne̱ e̱, u̱ka u̱so-tu̱ u̱so-u̱t it.>> ");
INSERT INTO gel_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Tu̱msu̱ e̱ zu̱ Faru̱k-u̱ Masar, <<It haagu̱n it shu̱'u̱t u-da cashi, remu̱ zu̱ me̱r-su̱ no̱ng u-tát u̱ Kan'ana. Tu̱msu̱ be-du̱ u-re̱e̱g du̱ u̱t-bisa zaar da. It o̱ u̱s-ko̱n bo̱ yage̱ to̱k-ne̱ ró it shu̱'u̱t u̱ Gas-u̱ Go̱sen.>> ");
INSERT INTO gel_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Faru̱k-u̱ Masar zu̱ Yusuhu, <<U̱so ró u̱ tu̱-wu̱to̱ ró ne̱ e̱ haagu̱n u̱du̱ ró. ");
INSERT INTO gel_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","E̱ u̱t-kere̱ u̱r-shu̱'u̱t ko̱he̱ne̱ dak-u̱ Masar u-be̱e̱t. Ya u̱so-u ró u̱ o̱r-u̱t ró ne̱ dak-u̱ ze̱ge̱ u̱r-zwar. E̱ kere̱ u̱r-shu̱'u̱t Go̱sen. Tu̱msu̱ abite̱ u̱zu̱ waku̱n o̱ro u̱n wu̱ nape̱ gwat-du̱ u̱t-bisa sok, bo̱ kere̱ wadu̱ wa u̱ gwat-du̱ bisa-u̱t ri.>> ");
INSERT INTO gel_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Se̱ Yusuhu haatu̱n uso-u wa Yakubu, wa hu̱u̱t wa u̱-shu̱ Faru̱k-u̱ Masar. Tu̱msu̱ Yakubu wa'-u̱ Faru̱k-u̱ Masar nu-u so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Faru̱k-u̱ Masar shit Yakubu, <<¿Hak-u̱s ró se̱ u̱s-nu̱?>> ");
INSERT INTO gel_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakubu shu̱s wa zu̱ Faru̱k-u̱ Masar, <<U̱m no̱mu̱g u̱s-hak u̱t-shik u̱t-shishin u̱ o̱p 130. Se̱di hak-u̱s ri o̱ cashi ana gwate̱ hak-su̱ u̱so-u̱t ri tu̱ mare̱.>> ");
INSERT INTO gel_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakubu wa'-u̱ Faru̱k-u̱ Masar nu-u so̱-o̱, se̱ wa aru̱k m-rwu̱ du̱gu̱-du̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusuhu shu̱gu̱sse̱ u̱so-u wa u̱ o̱r-u̱t wa ne̱ u̱ dak-u̱ Masar. Wa yasu̱ e̱ dak-u̱ ze̱ge̱ u̱r-zwar u̱ Masar, u̱ na zu̱ye̱ Ramase, u̱ka Faru̱k-u̱ Masar zu̱tte̱. ");
INSERT INTO gel_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusuhu hatu̱n u̱so-u wa u̱ tu̱-wu̱to̱ wa u̱ ne̱t-tu̱ bu-u wa ne̱ u̱t-be̱e̱t no̱m u̱t-re̱, u̱ka tat-u e̱, u̱ ya'ag-u̱ e̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","U-dak u-be̱e̱t no̱m u̱t-re̱ zaar da rem u̱zu̱ me̱r-su̱ no̱ng u-tát; ne̱t-tu̱ o̱ swadu̱ u̱s-me̱r sok u̱ dak-u̱t to̱ Masar u̱ Kan'ana-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusuhu o̱nk shik be̱e̱t i na kume̱ Masar u̱ Kan'ana-ne̱ i ne̱t-tu̱ ote̱ hyu̱, wa hu̱u̱t shik-u̱ e̱ u̱ pyu̱-u̱ Faru̱k-u̱ Masar. ");
INSERT INTO gel_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Da-u̱ ne̱t-tu̱ Masar u̱ ne̱t-tu̱ Kan'ana tase̱ hosu̱ shik-u̱ e̱ o̱tte̱ be̱e̱t u̱ remu̱ o̱-du̱ hyu̱, ne̱t-tu̱ Masar ne̱ be̱e̱t e̱ haan u̱du̱ Yusuhu. E̱ zu̱, <<Ya it no̱m u̱t-re̱. ¿Re̱-o̱ it do̱te̱ u̱t-mar bo̱ gwat-du̱ it? Shik-u̱ it tu̱u̱ste̱ be̱e̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusuhu shu̱s wa zu̱, <<Hatu̱n me̱ bisa-u̱t no̱, me̱ ya' no̱ no̱m u̱t-re̱ remu̱ zu̱ shik-u̱ no̱ tu̱u̱ste̱.>> ");
INSERT INTO gel_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Du̱gu̱ da-u o̱, u̱n hatu̱n u̱t-bisa u̱du̱ Yusuhu, wa yu̱ u̱n nom-u̱t re̱ u̱ swas-mu̱ bisa-u̱t u̱n: jwaak ne̱, ban-tu̱ ca, u̱ gwaar ne̱, u̱ na ne̱, u̱ janka ne̱. Tu̱msu̱ u̱ hak-u ya wa yu̱ u̱n no̱m u̱t-re̱ u̱ swasmu̱ bisa-tu̱ u-bu u̱n. ");
INSERT INTO gel_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Da-u̱ hak-yu̱ arke̱, yaku̱n hak-ya byu̱ru̱n u̱n haan u̱du̱ wa, u̱n zu̱, <<U̱so u-bu it, it zaar u̱ yasu̱ bo̱ u̱t-nip da. It zamu̱ttu̱n shik da e̱ tu̱u̱ste̱ be̱e̱t, tu̱msu̱ bisa-u̱t it u̱t-be̱e̱t to̱ mu̱u̱g tu̱ ró. O̱ko̱n zamu̱n u̱ it do̱'e̱ u̱ haatu̱n bo̱ da war-u̱t it to̱ kuse̱ u̱ tak-u̱t it ne̱. ");
INSERT INTO gel_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","¿Re̱ne̱ o̱ it do̱te̱ m-mar bo̱ gwat-du̱ it u̱ is-u̱ ró? Ya it nom-u̱t re̱ u̱ swas-mu̱ tak-u̱t it, it ya'aste̱ Faru̱k-u̱ Masar tak-u̱t it u̱ hi-du̱ war it ne̱ u̱du̱ Faru̱k-u̱ Masar it shu̱'u̱t to̱k-ne̱. Bo̱ di ya' it no̱m u̱t-re̱ taas it mar da, tu̱msu̱ taas u̱ dak-u̱ shu̱'u̱t za ne̱t sha-mu̱ u̱r-do̱g da.>> ");
INSERT INTO gel_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yusuhu o̱gu̱ Faru̱k-u̱ Masar dak-u̱ Masar u̱t-be̱e̱t. Ne̱t-tu̱ Masar u̱t-be̱e̱t e̱ bu̱pu̱s tak-u̱t e̱ remu̱ zu̱ me̱r-su̱ no̱ng u-tát sok, tak-tu̱ shu̱'u̱t tu̱ Faru̱k-u̱ Masar u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Remu̱ iya Yusuhu muut ne̱t-tu̱ Masar u̱t-be̱e̱t, ne̱t-tu̱ shu̱'u̱t to̱k-ne̱ faru̱k be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ko̱ ba shu̱'u̱te̱ iya, Yusuhu o̱o̱g tak-tu̱ a-to̱o̱g-ne̱ da. Remu̱ u̱zu̱ a-to̱o̱g-ne̱ o̱nk no̱m u̱t-re̱ e̱ du̱gu̱-du̱ Faru̱k-u̱ Masar. Remu̱ iya e̱ zatte̱ mo̱ttu̱ bab-du̱ tak-u̱t e̱ da. ");
INSERT INTO gel_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yusuhu zu̱ u̱n, <<Remu̱ u̱zu̱ u̱ da-o̱ u̱m o̱o̱g no̱ u̱ tak-u̱t no̱ ne̱ u̱du̱ Faru̱k-u̱ Masar. Go̱ hyu̱ ya o̱nko̱n no̱ do̱'e̱ no̱ kaw u̱t-tak. ");
INSERT INTO gel_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Da-u̱ no̱ tase̱ ket, no̱ de̱ yase̱ u̱r-ho̱ u̱r-gan u̱ te̱k u̱t-ho̱ u̱t-tan, u̱du̱ Faru̱k-u̱ Masar. Ho̱-tu̱ u̱t-nas tu̱ kuse̱ to̱ shu̱'u̱t go̱ i no̱ do̱'e̱ u̱t-kaw u̱ tak-u̱t no̱, tu̱msu̱ no̱m u̱t-re̱ u̱du̱ tak-u̱t no̱, u̱ ne̱t-tu̱ u-bu no̱ ne̱ be̱e̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","E̱ shu̱s, e̱ zu̱, <<Bo̱ gwu̱u̱g fat-u̱t it, yage̱ it kum hyu̱-m pusmo̱ u̱du̱ u̱so u-bu ri; it shu̱'u̱t to̱k-ne̱ Faru̱k-u̱ Masar.>> ");
INSERT INTO gel_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yusuhu nom u̱t-bo̱r u̱ dak-u̱ Masar tu̱ o̱mne̱ m-ank u̱ haan u̱ da-o̱, u̱zu̱ u̱r-ho̱ u̱r-gan u̱-me̱ u̱t-tan du̱ no̱m-tu̱ u̱r-to̱m u̱ dak-u̱ Masar du̱ Faru̱k de̱. Se̱di tak-tu̱ a-to̱o̱g-ne̱ to̱ zare̱ tu̱ Faru̱k-u̱ Masar da. ");
INSERT INTO gel_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Se̱ Isra-ne̱ e̱ shu̱'u̱t u̱ Masar u̱ gas-u̱ Go̱sen, e̱ nom u̱t-kwu̱m u-tát. E̱ mu̱t yaag u-tát, tu̱msu̱ e̱ nom u̱r-ban sok. ");
INSERT INTO gel_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakubu shu̱'u̱te̱ u̱ Masar u̱s-hak o̱p u̱s-ta'er 17, hak-u̱s Yakubu su̱ wa no̱me̱, hak-se̱ u-ko̱k u-gan u̱ hak-su̱ u̱t-shik u̱t-yu̱r u̱ hak-su̱ u̱s-ta'e̱r 147. ");
INSERT INTO gel_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Da-u̱ Isra nape̱ u̱zu̱ da-u̱ mar-m wa no̱ng u̱t-mo̱r, se̱ wa fog wa'-u̱ wa Yusuhu. Wa zu̱ wa, <<A u̱m kume̱ hyu̱-m pusmo̱ u̱du̱ ró, wa kom-u ró u̱-ta kut-u ri, bo̱ ko̱se̱ me̱ u̱t-nip u̱ yadu̱ jab ne̱ u̱zu̱ a u̱m mare̱ bo̱ za jwak-u̱ me̱ u̱ ana u̱ dak-u̱ Masar. ");
INSERT INTO gel_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Tu̱msu̱ da-u̱ u̱m mare̱, kabu̱n war-u ri du̱gu̱ Masar m-ha u̱ be-du̱ na dokte̱ u̱so-tu̱ tu̱ u̱so-u̱t ri.>> Yusuhu zu̱, <<Me̱ no̱mu̱ bo̱ u̱ka bo̱ zu̱tte̱.>> ");
INSERT INTO gel_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakubu zu̱, <<To̱nde̱ u̱zu̱ bo̱ u̱t-no̱m iya.>> Yusuhu to̱n-de̱ wu̱n. Da-u o̱ Isra kakse̱ hi-u̱r wa u̱-do̱mu̱ yu̱n-u̱ wa, wa nome̱ u-Ru̱ u̱t-huuk. ");
INSERT INTO gel_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Da-u̱ wase̱ ca, na waru̱ Yusuhu u̱zu̱, u̱so-u wa o̱ za m-yar. Yusuhu ku̱b ya'ag-u̱ campa-ne̱ wa yu̱r, Manase u̱ Ifaramu u̱ wane̱, e̱ do̱'e̱, e̱ hyan u̱so-u wa. ");
INSERT INTO gel_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Da-u̱ na ware̱ Yakubu u̱zu̱, <<Wa'-u̱ ró Yusuhu haagu̱n, wa hyan bo̱.>> Se̱ Isra sur u̱r-be̱b tu̱msu̱ wa shu̱'u̱t u̱-do̱m u-yu̱n. ");
INSERT INTO gel_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakubu zu̱ Yusuhu, <<Ru̱-u̱ u-be̱e̱t haagu̱n u̱du̱ ri u̱ Ruz u̱ dak-u̱ Kan'ana, tu̱msu̱ wa wa'-u̱ me̱ nu-u so̱-o̱ u̱ ku̱n. ");
INSERT INTO gel_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Wa zu̱ me̱, <Me̱ ya'u̱ bo̱ yaag, tu̱msu̱ me̱ u̱t-wa bo̱ no̱m u-tát. Me̱ u̱t-wa u̱ bo̱ shu̱'u̱t wa u̱t-ko̱ u-tát, me̱ ya'u̱ bo̱ uno̱ dak-o̱ Kan'ana, tu̱msu̱ me̱ ya'u̱ bo̱ uno̱ dak-o̱ u̱ shu̱'u̱t u̱ ko̱-u̱t ró u̱ de̱ haan dim-u̱ ró m-mo̱mmo̱.> >> ");
INSERT INTO gel_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yakubu zu̱ wu̱n, <<Yaag-u̱ campa-ne̱ yu̱r i na mate̱ bo̱ u̱ dak-u̱ Masar, Ifaramu u̱ Manase kanda u̱m haan u̱ ana, e̱ do̱'e̱ u̱t-shu̱'u̱t ya'ag-u̱ ri u̱ka Rube̱n u̱ Simiyo̱n. ");
INSERT INTO gel_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Tu̱msu̱ da-u̱ ko̱-u̱r no̱ u̱r-be̱e̱t e̱ mu̱u̱ne̱ u̱ Kan'ana, ya'ag-u̱ ri ko̱wan do̱'e̱ kwu̱m-du̱ u̱r-o̱g dak-u o̱. Se̱di e̱ke̱n yaage̱ i bo̱ de̱ u̱t-kwu̱m u̱ dim-u̱ u̱n e̱ do̱'e̱ kwu̱m-du̱ o̱g-du̱ u-dak du̱gu̱ o̱ru̱ e̱ Ifaramu ko̱ Manase. ");
INSERT INTO gel_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","U̱s-hak u-tát su̱ arke̱, da u̱m o̱o̱ge̱ mu̱u̱n du̱gu̱ Padan-Aram, Rahira mu̱ru̱s dak-u̱ Kan'ana. It o̱ u̱ te̱k m-ha u̱ do̱m u-fu̱n, m-ra ne̱ du̱gu̱ bo̱-u̱ Eparat (U̱ na fu̱ge̱ Be̱tarami). U̱ te̱k-u̱ namu̱ jab se̱ u̱m dok wa u̱ kit-u̱ fu̱n-yu̱ ha-mu̱ Eparat.>> ");
INSERT INTO gel_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Da-u̱ Isra hyanne̱ ya'ag-u̱ campa-ne̱ Yusuhu yu̱r, se̱ wa shit, <<¿Wa zu̱ wanne̱ e̱ ine̱?>> ");
INSERT INTO gel_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusuhu shu̱s wa zu̱, <<E̱ o̱ye̱ yaag campa-ne̱ i Ru̱-u̱ ya'u̱ me̱ u̱ ana, da-u̱ u̱m o̱o̱ge̱ u̱ Masar.>> Yakubu zu̱, <<Haatu̱n u̱n u̱du̱ ri u̱m wa'-u̱ u̱n nu-u so̱-o̱.>> ");
INSERT INTO gel_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Is-u̱ Isra no̱ng u-cu̱m u̱ remu̱ u̱r-wu̱, wa hyen-u̱t sok da. Yusuhu haatu̱n ya'ag-u̱ campa-ne̱ wa yu̱r u̱du̱ Yakubu. Yakubu ham-u̱t e̱ tu̱msu̱ wa su gu̱t-u̱t e̱. ");
INSERT INTO gel_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Isra zu̱ Yusuhu, <<U̱m no̱ng u̱s-dorog u̱zu̱ me̱ hyanu̱ bo̱ da. Se̱di u̱ da-o̱ Ru̱-u̱ yakku̱ me̱ u̱m hyan ya'ag-u̱ ró tu̱msu̱.>> ");
INSERT INTO gel_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Se̱ Yusuhu hast ya'ag-u̱ wa du̱gu̱-du̱ jwu̱n-u̱t Yakubu, se̱ Yusuhu he̱ u-dak u̱t-jwu̱n wa kaku̱s hi-u̱r wa u-dak. ");
INSERT INTO gel_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yusuhu kagu̱b u̱n yu̱r be̱e̱t, Ifaramu u̱ kom-u̱t u̱t-cwa u̱ Yusuhu m-gwat kom u̱r-beer u̱ Isra, tu̱msu̱ Manase u̱ kom u̱r-beer Yusuhu m-gwat kom u̱t-cwa u̱ Isra. Wa haatu̱n e̱ u̱t-mo̱r u̱ Yakubu ne̱. ");
INSERT INTO gel_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Tu̱msu̱ Isra no̱mu̱g no̱mu̱ Yusuhu u̱t-sa wa no̱m da. Se̱di wa dor kom u̱s-cwa u̱ hi-u̱r Ifaramu, ko̱ ba shu̱'u̱te̱ u̱zu̱ wa o̱ye̱ du̱-fade̱, kom u̱r-beer u̱ do̱m-u̱ hi-u̱r Manase wu̱ o̱ mat-du̱ u-shu̱. ");
INSERT INTO gel_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Se̱ wa wa'-u̱ Yusuhu nu-u so̱-o̱, wa zu̱, <<Yage̱ u-Ru̱ wu̱ u̱so-u u̱so-u̱t ri Ibrahi u̱ u̱so ri Ishaku ne̱ e̱ no̱nge̱ u-Ru̱ m-ank. Ru̱-u̱ du̱u̱te̱ me̱ tu̱msu̱ wa got me̱ u̱ka wa-gwat-du̱ u̱t-bisa gotte̱ ca wa. Ru̱-u̱ no̱ng iya u̱ fat-u̱r ri u̱r-be̱e̱t u̱ teen din-de̱ ho̱-de̱. ");
INSERT INTO gel_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Wa-to̱m u-Ru̱ wu̱ guu me̱ du̱gu̱ no̱m-u̱t yo̱-to̱, u̱m no̱ng u̱s-to̱o̱g u̱zu̱, wa wa'-u̱ yaag ine̱ nu-u so̱-o̱. U̱m no̱ng u̱s-to̱o̱g u̱zu̱ na do̱'e̱ ha fag-du̱ u̱n u̱ dim-u̱r ri, tu̱msu̱ u̱ dim-u̱r Ibrahi u̱ Ishaku ne̱ remu̱ no̱mu̱ Ru̱-u̱ no̱mu̱ u̱n. U̱m no̱ng u̱s-to̱o̱g u̱zu̱ u̱n kum u̱t-ko̱ u-tát i do̱'e̱ u̱r-yu̱ u-dak u-be̱e̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Da-u̱ Yusuhu hyane̱ u̱so-u wa u̱ wadu̱ kom u̱t-cwa u̱ wa u̱ hi-u̱r Ifaramu, se̱ jab-u̱ wa nu̱. Se̱ wa ku̱b kom u̱t-cwa u̱ u̱so-u wa, du̱gu̱ hi-u̱r Ifaramu, wa muut o̱ u̱ hi-u̱r Manase. ");
INSERT INTO gel_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yusuhu zu̱ u̱so-u wa, <<Iya-o̱ da, u̱so-u ri, unwa wa o̱o̱ge̱ mat-du̱ u-shu̱, wa kom u̱s-cwa ró u̱ hi-u̱r wa.>> ");
INSERT INTO gel_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tu̱msu̱ u̱so-u wa gu̱gu̱m. Wa zu̱, <<U̱m nak wa'-u̱ ri, u̱m-nak, Manase do̱'e̱ u̱t-shu̱'u̱t ko̱-u̱r yat-de̱, tu̱msu̱ Ifaramu du̱-dim-u̱ Manasse̱ u̱t-shu̱'u̱t ko̱-u̱r yadde̱ m-ze̱g du̱ yu̱-wu̱ya wa, ko̱-u̱r wa u̱t-shu̱'u̱t dak-u yat-o̱.>> ");
INSERT INTO gel_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Remu̱ iya Yakubu wa'-u̱ u̱n yu̱r nu-u so̱-o̱ u̱r-ho̱ u̱r-gan wa zu̱, <<Du̱gu̱-du̱ dim-u̱r ro de̱ ne̱t-tu̱ Isra-ne̱ do̱te̱ wa'-u̱ u̱t-ne̱t nu-u so̱-o̱, e̱ do̱'e̱ u̱t-zu̱, <Yage̱ Ru̱-u̱ wa'-u̱ no̱ nu-u so̱-o̱ u̱ka Ifaramu ne̱ e̱ Manase.> >> Remu̱ iya Yakubu wu̱ Ifaramu u̱-shu̱ Manase. ");
INSERT INTO gel_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Da-u o̱ Isra zu̱ Yusuhu, <<Bo̱ hyanu̱g u̱m u̱t-sa m-mar, tu̱msu̱ Ru̱-o̱ u̱t-no̱m u̱r-kot u̱ bo̱ ne̱, tu̱msu̱ wa do̱'e̱ u̱ muutu̱ bo̱ dak-u̱ u̱so-tu̱ u̱so-u̱t in. ");
INSERT INTO gel_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Tu̱msu̱ bo̱, me̱ ya bo̱ m-ze̱g no̱m-u̱ u̱m ya tu̱-wu̱to̱ ró. Me̱ ya'u̱ bo̱ tak-u̱ ze̱ge̱ u̱r-be̱b u̱ gas-u̱ She̱che̱m. U̱m o̱nkte̱ dak-u o̱ du̱gu̱ ne̱t-tu̱ Amoriya-ne̱, da-u̱ u̱m no̱me̱ m-dum u̱ e̱ ne̱ van-yu̱ m-wu̱r ri u̱ ta-u ri ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Se̱ Yakubu fog ya'ag-u̱ campa-ne̱ wa tu̱msu̱ wa zu̱: <<Kargu̱n u̱du̱ ri, u̱m waru̱ no̱ no̱m-u̱ do̱'e̱ kwu̱m-du̱ no̱ u̱ da-u̱ de'e̱ u̱ haan.>> ");
INSERT INTO gel_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","<<Kargu̱n no̱ e̱r, Yaag-u̱ ri Yakubu; E̱re̱n Isra u̱so-u no̱.>> ");
INSERT INTO gel_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rube̱n, bo̱ o̱ye̱ mat-du̱ u-shu̱ ri. Bo̱ wa u̱m mate̱ da-u̱ u̱m o̱o̱ge̱ u̱ fa-u̱r ri, u̱ da-u̱ u̱m o̱o̱ge̱ u̱ ho̱g-mu̱ u̱r-be̱b. Bo̱ wa o̱ yu̱-shu̱ tu̱msu̱ wu̱ ze̱ge̱ u̱r-be̱b. ");
INSERT INTO gel_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ko̱ ba shu̱'u̱te̱ zu̱ bo̱ wa-ko̱b-du̱ shu̱p-du̱ u̱r-hi wa u̱ka bu̱-mu̱ u̱r-be̱b. U̱ da-o̱ bo̱ za kwu̱m-du̱ re̱-u̱ u-shu̱ da, remu̱ zu̱ bo̱ daag u̱ yu̱n-u ri bo̱ naas o̱. Bo̱ roogte̱ u̱ to̱k-ne̱, wu̱ shu̱'u̱te̱ wa-gan u̱ te̱k-u̱ ne̱ta-u̱t ri. Bo̱ wa'ag me̱ u̱so-u ró u̱ ho̱g-du̱ m-'e̱. ");
INSERT INTO gel_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simiyo̱n e̱ Re̱wi jab-u̱s e̱ o̱ u̱s-gan, van-su̱ m-wu̱r u̱n no̱m-tu̱ yu̱nu̱s-du̱ jab-su̱ u̱t-ne̱t se̱. ");
INSERT INTO gel_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","U̱m zaar u̱ cwadu̱ mo̱ro̱g-u̱r u̱n da, U̱m za tu̱msu̱ same̱ u̱t-hi u̱ no̱m-du̱ no̱m-u̱t yo̱-to̱ u̱n ne̱ da. U̱n ho̱o̱rte̱ u̱t-ne̱t remu̱ ryab-u̱s u̱n. Tu̱msu̱ e̱ kwu̱pru̱sse̱ tu̱ru̱g-su̱ na, remu̱ ho̱g-du̱ u̱r-zwaru̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Nu-u yo̱-o̱ u̱du̱ ryab-u̱s u̱n, remu̱ zu̱ ryab-u̱s u̱n no̱ng u-tát. Me̱ bu̱ru̱gse̱ u̱n du̱gu̱ ko̱-u̱r Yakubu, u̱m bu̱ru̱gse̱ u̱n du̱gu̱ me̱ Isra-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","<<Yahuda, o̱r-u̱t ró ne̱ do̱'e̱ no̱mu̱ bo̱ u̱t-vam. Bo̱ do̱'e̱ u̱ shu̱p-du̱ ge̱ku̱stu̱ hu̱u̱b-u̱t yo̱-to̱ ró. Yaag-u̱ u̱so-u ró do̱'e̱ u̱t-he̱ u̱t-jwu̱n u̱ shu̱ ró. ");
INSERT INTO gel_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yahuda wa'-u̱ ri, ya-du̱ u-zur de̱ wa o̱o̱ge̱, wu̱ tase̱ tu̱du̱ ap-mu̱ u̱r-do̱g mu̱ wa mase̱, Wa ru̱t wa nu̱ku̱s m-kim da-u̱ wa tase̱ re̱-du̱ no̱m u̱t-re̱. Bo̱ o̱ sha-mu̱ ya-du̱ uzur, waku̱n zaar wu̱ de̱ yu̱nsu̱ bo̱ da. ");
INSERT INTO gel_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Bo̱ Yahuda, ko̱m-yu̱ u̱r-faru̱k za u̱t-rwu̱ du̱gu̱-du̱ ró da. Ko̱m-yu̱ u̱r-faru̱k zaar u̱t-mo̱t u̱ ne̱t-u̱t ró ne̱ da. Se̱ teeg u̱du̱ wu̱ kame̱ wa re̱. U̱t-dak u̱t-be̱e̱t to̱ ya'u̱ bo̱ m-ze̱g. ");
INSERT INTO gel_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Bo̱ gagu̱ janka-u ró u̱ te-yu̱ inabi, jwaak-u wu̱n u̱t-no̱m u̱t-re̱e̱g u̱s-nag-nag su̱ cite̱ e̱, Wa jasu̱ kus-u̱t wa u̱ bu̱-mu̱ inabi, no̱ u̱t-no̱m m-jaas u̱ bu̱-mu̱ inabi mu̱ o̱ u̱ jaz-mo̱ u̱ka m-hyu̱. ");
INSERT INTO gel_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Is-u̱ ró u̱t-no̱m u̱s-rim m-ze̱g bu̱-mu̱ ke̱, tu̱msu̱ ni-nu̱ wu̱n u̱t-no̱m u̱r-myak m-ze̱g m-me̱. ");
INSERT INTO gel_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","<<Ze̱burun u̱t-shu̱'u̱t u̱ kit-yu̱ m-sa. U̱ shu̱'u̱t be-du̱ e̱e̱s-du̱ hat-su̱ m-bu̱, Ma-du̱ u-bo̱r wa u̱t-te bo̱-u̱ Sidon. ");
INSERT INTO gel_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","<<Issakar, janka-yu̱ u̱r-be̱b ya. Wa o̱ m-ru̱t u̱ te̱k-u̱ kapu-tu̱ gag-du̱ u̱t-cwu̱ u̱t-yu̱r. ");
INSERT INTO gel_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Wa u̱t-hyan u̱zu̱ be-du̱ u̱r-hure̱ wa o̱ so̱-de̱, tu̱msu̱ wa u̱t-ho̱g u̱ka re̱me̱r-mu̱ u-dak o̱tte̱. Wa yasu̱ shin-u wa remu̱ kab-du̱ cwu̱-tu̱ m-no, wa yase̱ hi-u̱r wa u̱ no̱m-du̱ m-to̱k mu̱ u̱r-be̱b. ");
INSERT INTO gel_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan, do̱'e̱ u̱t-shu̱'u̱t wa kwu̱p-du̱ u̱s-rem u-me̱ ne̱t-u̱t wa, u̱ka to̱ku̱n ko̱-to̱ u̱-me̱ Isra-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan wa do̱'e̱ u̱t-shu̱'u̱t u-fa u̱ kit-u̱ u-fu̱n, fa-yu̱ m-rab u̱ kit u-fu̱n, Yu̱ epe̱ du̱ku̱nte̱ du̱ jwaak, remu̱ i o̱ m-sak e̱ he̱'e̱ u̱-dim. ");
INSERT INTO gel_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Yawe, u̱m o̱ wadu̱ is u̱ u̱ku̱r-u ró. ");
INSERT INTO gel_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","<<Gad, hyu̱w-ne̱ kwu̱p-du̱ u̱s-fu̱n ne̱ do̱'e̱ u̱ haan u̱ bo̱, se̱di bo̱ doru̱ dim-u̱ u̱n wa to̱p u̱r-mag. ");
INSERT INTO gel_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","<<Ashu̱r, bo̱ no̱mu̱ no̱m u̱t-re̱ tu̱ m-re̱rem u-tát tu̱ farkina-ne̱. Tu̱msu̱ i nome̱ no̱m-tu̱ u̱t-re̱ tu̱ m-re̱me̱r tu̱ faru̱k. ");
INSERT INTO gel_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","<<Napari, bo̱ do̱'e̱ u̱t-shu̱'u̱t u̱ka u-nu̱m, wa do̱'e̱ mat-du̱ yaag-u̱ so̱ye̱. ");
INSERT INTO gel_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","<<Yusuhu, bo̱ matu̱ yaag u-tát, bo̱ o̱ sha-mu̱ te-yu̱ inabi yu̱ o̱o̱ge̱ kit-u̱ u-gi yu̱ mu̱te̱ u̱t-ya, yu̱ fe̱k-u̱s wa rogme̱ m-pas ja-mu̱ u̱r-bo̱ngo̱. ");
INSERT INTO gel_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Hu̱u̱b-u̱t yo̱-to̱ u̱n do̱'e̱ he̱e̱se̱ u̱n m-dum za u̱r-o̱n, hu̱u̱b-u̱t yo̱-to̱ u̱n do̱'e̱ tadu̱ wu̱n u̱s-ta u̱t-e̱r ne̱. ");
INSERT INTO gel_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Se̱di ta-u wu̱n u̱t-shu̱'u̱t u̱ go̱ri-go̱ri, tu̱msu̱ kom-u̱t wu̱n u̱t-shu̱'u̱t u̱r-be̱b ne̱, U̱-remu̱ kom-u̱ wa-u̱r-be̱b wu̱ Yakubu, tu̱msu̱ u̱ remu̱ wa-gwat-du̱ na, ta'ar-du̱ Isra-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","U-Ru̱, wu̱ u̱m no̱me̱ u̱t-huuk, wa no̱me̱ ko̱-u̱r ró u̱r-se̱ge̱. Ru̱-u̱ ko̱-uyan wa wa'-u̱ u̱n kom-u so̱-o̱, u̱ to̱mto̱n u̱n m-bu̱ du̱gu̱ do̱m u-ru̱, tu̱msu̱ wa ya'u̱ u̱n bu̱-mu̱ ta u-dak, m-ra u̱ ta u-dak-ne̱. Wa ya'u̱ u̱n na u-tát u̱ yaag ne̱. ");
INSERT INTO gel_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Yage̱ nu-u so̱-o̱ tu̱ u̱so-u ró, to̱ ze̱k nu-u so̱-o̱ tu̱ ro̱r-tu̱ da-u̱ tu̱ arke̱ m-tumb ne̱, m-te jamu̱ ro̱r-tu̱ mo̱mmo. Yusuhu, u̱m no̱ng u̱s-ko̱n u̱zu̱ na ya'u̱ bo̱ to̱ haan u̱du̱ ró, bo̱ yu̱ shu̱'u̱te̱ yu̱-shu̱ o̱r-u̱t ró ne̱. ");
INSERT INTO gel_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","<<Banyamin bo̱ o̱ye̱ u-go yu̱ u̱r-do̱g yu̱ o̱o̱ge̱ ho̱g-du̱ u̱s-me̱r, u̱r-wu̱n bo̱ ho̱ hu̱u̱b-u̱ u̱t-yo̱-to̱ ró, tu̱msu̱ m-rim bo̱ de̱ mo̱t-du̱ kwu̱m-tu̱ bo̱ o̱nke̱ du̱gu̱-du̱ hu̱u̱b-u̱t yo̱-to̱ ró.>> ");
INSERT INTO gel_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Tun-to̱ to̱ o̱ye̱ ko̱-tu̱ Isra-ne̱ o̱p-u̱t yu̱r, tu̱msu̱ no̱mu̱ u̱so-u̱ u̱n zu̱ye̱ u̱n u̱ ya da-u̱ wa o̱o̱ge̱ wa'-u̱ u̱n nu-u so̱-o̱. Wa wa'-u̱ ko̱wan nu-u so̱-o̱ u̱ kame̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Yakubu yu̱ u̱n tunto̱ bo̱r-to̱: <<U̱m o̱ u̱t-mo̱r m-mar ne̱ u̱m byu̱tu̱n u̱so-u̱t ri. Jwaku̱n me̱ u̱ u̱so-u̱t ri ne̱ u-pu̱ku̱s u-tak u̱ Eparo̱n ne̱t-u̱ He̱t-ne̱. ");
INSERT INTO gel_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Pu̱ku̱s u̱ o̱o̱ge̱ tak-u̱ Mape̱ra, u̱ dapu̱s Mamre Kan'ana, u̱ Ibrahi o̱ye̱ u̱ka be-du̱ u-dok u̱du̱ Eparo̱n ne̱t-u̱ He̱t-ne̱, u̱r-same̱ u-tak ne̱. ");
INSERT INTO gel_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ku̱na na dokte̱ Ibrahi e̱ ne̱ta wa Saratu. Ku̱na na dokte̱ Ishaku e̱ ne̱ta wa Rebeka. Ku̱na tu̱msu̱ na dokte̱ Riya. ");
INSERT INTO gel_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ibrahi o̱o̱g u-tak u̱ pu̱ku̱s ne̱ du̱gu̱-du̱ ne̱t-tu̱ He̱t.>> ");
INSERT INTO gel_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Da-u̱ Yakubu tase̱ waru̱ ya'ag-u̱ wa u̱s-rem, se̱ wa ru̱t u̱-do̱m u-yu̱n. Wa nom vu̱'e̱ su̱ m-vaste̱, wa dor u̱so-u̱t wa, wa mu̱ru̱s. ");
INSERT INTO gel_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yusuhu he u̱ war-u̱ u̱so-u wa, wa nom u̱s-kan, wa ham-u̱t wa. ");
INSERT INTO gel_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Se̱ Yusuhu zu̱ a-gwat-du̱ yar-mu̱ u̱so-u wa ne̱, e̱ wa'-u̱ war-u̱ u̱so-u wa Isra u̱s-baat su̱ de̱ hoosu̱ wa u̱t-zu̱m. Se̱ a-gwat-du̱ war-u wa wa'-u̱ wa baat-su̱ hoos-du̱ u̱t-zu̱m. ");
INSERT INTO gel_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","E̱ nom m-roog u̱t-shik u̱t-yu̱r 40, to̱ o̱ye̱ roog-mu̱ kame̱ na no̱m u̱ tamu̱ u̱s-baat su̱ hoos-du̱ u̱r-u u̱t-zu̱m. Ne̱t-tu̱ Masar no̱m m-roog u̱t-shik u̱t-tu̱t u̱ o̱p e̱ o̱ namu̱ jab-u̱ rem-u wu̱n 70. ");
INSERT INTO gel_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Da-u̱ ru̱ttu̱ namu̱ jab arke̱, se̱ Yusuhu no̱m u̱s-rem u̱ ne̱nge̱n-tu̱ bu-u Faru̱k-u̱ Masar ne̱. Wa zu̱, <<A mu̱ne̱ me̱ kwu̱mu̱ hyu̱-m pusmo̱ u̱du̱ no̱, ko̱no̱n me̱ Faru̱k-u̱ Masar u̱ no̱ no̱mu̱ wa u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","<Da-u̱ u̱so-u ri o̱o̱ge̱ u̱t-sa m-mar, wa wa'ag u̱m nom u̱s-to̱nd u̱zu̱, <<U̱m o̱ mo̱ttu̱ m-mar, jwaku̱n me̱ u̱ sag-u̱ u̱m kawe̱ u̱ hi-u̱r ri u̱ dak-u̱ Kan'ana.>> Yage̱ u̱m do̱'e̱ u̱m jwaku̱n u̱so-u ri, a u̱m tase̱ jwak-du̱ wa me̱ u̱t-mu̱u̱n za naas u-da.> >> ");
INSERT INTO gel_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Se̱ Faru̱k-u̱ Masar shu̱s wa zu̱, <<De̱'e̱ bo̱ jwaku̱n u̱so-u ró u̱ka bo̱ to̱ndte̱ u̱zu̱ bo̱ u̱t-no̱m.>> ");
INSERT INTO gel_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Se̱ Yusuhu aru̱k m-ha u̱ jwak-du̱ u̱so-u wa. Tu̱-yat-to̱ Faru̱k-u̱ Masar shu̱-u̱ wu̱n be̱e̱t u̱ i-yate̱ kur-tu̱ kwu̱p-du̱ u̱s-rem u̱ i-yate̱ dak-u̱ Masar ne̱ be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yusuhu ku̱b ne̱t-tu̱ bu-u wa u̱t-be̱e̱t, u̱ o̱r-u̱t wa ne̱ u̱ ne̱t-tu̱ o̱o̱ge̱ ya bu-u̱ u̱so wu̱n ne̱ be̱e̱t. Se̱di e̱ yage̱ ya'ag-u̱ e̱ u̱ ban-tu̱ bisa-u̱t e̱ u̱ gwaar ne̱ u̱ ca ne̱ u̱ na ne̱ u̱ gas-u̱ Go̱sen. ");
INSERT INTO gel_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ke̱ke̱-su̱ jwaak u̱ ya-sak-mu̱ jwaak ne̱ tu̱msu̱ e̱ dor Yusuhu m-no̱k. Ne̱t-to̱ u-tát tu̱ doru̱ Yusuhu m-ha. ");
INSERT INTO gel_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Da-u̱ u̱n teene̱ be-du̱ u̱t-sogor du̱ Atad, u-do̱m u̱ gi-yu̱ Jodan, e̱ nom namu̱ jab u̱s-kan ne̱ m-yat so̱k. Tu̱msu̱ ku̱na Yusuhu nomte̱ m-roog u̱t-ta'er u̱ namu̱ jab-u̱ remu̱ u̱so-u wa. ");
INSERT INTO gel_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Da-u̱ Kan'ana-ne̱ i o̱ye̱ u̱ shu̱'u̱t u̱ku̱n e̱ hyane̱ u̱n iya u̱ be-du̱ na nomte̱ u̱r-vu du̱ Atad, e̱ zu̱, <<Din-de̱ be-de̱ be-du̱ namu̱ jab de̱ sok du̱ ne̱t-tu̱ Masar!>> Se̱ u̱n te̱'e̱ be-u̱r re̱ u̱r-dim u̱ dapu̱s gi-yu̱ Jodan <<Aber-mizrayim,>> Aber-mizrayim o̱ na zu̱ye̱, <<Be-du̱ namu̱ jab mu̱ ne̱t-tu̱ Masar.>> ");
INSERT INTO gel_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Inya-o̱ ya'ag-u̱ campa-ne̱ Yakubu nomte̱ wa u̱ka wa zu̱tte̱ e̱ no̱m. ");
INSERT INTO gel_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","E̱ ku̱b wa m-ha u̱ dak-u̱ Kan'ana. E̱ dok wa u̱ pu̱ku̱s tak-u̱ Mape̱ra, u̱ dapu̱s Mamre, u̱ tak-u̱ Ibrahi o̱ye̱ be-du̱ u-dok du̱gu̱ Eparo̱n ne̱t-u̱ He̱t-ne̱, u̱ dame̱ u-tak ne̱. ");
INSERT INTO gel_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Da-u̱ na tase̱ jwak-du̱ Yakubu, Yusuhu arku̱n u̱ mu̱u̱n u̱ Masar u̱ o̱r-u̱t wa ne̱ u̱ i shu̱'e̱ wa ne̱ u̱ ha-mu̱ jwak-du̱ u̱so-u wa. ");
INSERT INTO gel_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Da-u̱ tu̱-wu̱to̱ Yusuhu ne̱ hyane̱ u̱zu̱ u̱so-u e̱ maru̱g, se̱ e̱ zu̱, <<¿A mu̱ne̱ u̱zu̱ Yusuhu o̱ m-shu̱p u̱ in ne̱ u̱-jab wa to̱p no̱m-u̱t yo̱-to̱ tu̱ in no̱mu̱ wa?>> ");
INSERT INTO gel_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","U̱ remu̱ iya u̱n nom tom u̱du̱ Yusuhu u̱zu̱, <<Kandi u̱so-u in u̱ mar wa yakke̱ tun-to̱ bo̱r-to̱: ");
INSERT INTO gel_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Waru̱n Yusuhu, <Bo̱ no̱mu̱ tu̱-wu̱to̱ ró ne̱ ho̱-du̱ ba'as-u̱t e̱, no̱m-u̱t yo̱-to̱ tu̱ e̱ no̱mu̱ bo̱, u̱ka e̱ yu̱te̱ bo̱ u̱r-ko̱b.> Remu̱ iya it o̱ u̱s-ko̱n bo̱ no̱mu̱ u̱n u̱r-ho̱, it to̱k-ne̱ i Ru̱-u̱ u̱so-u ró.>> Da-u̱ se̱ re̱m-se̱ tene̱ du̱ wu̱n, Yusuhu nom u̱s-kan. ");
INSERT INTO gel_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Tu̱-wu̱to̱ wa ne̱ haan e̱ he̱ u̱-shu̱ wa u̱t-jwu̱n, e̱ zu̱, <<It tu̱ ya to̱ku̱ ne̱ ró e̱.>> ");
INSERT INTO gel_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Tu̱msu̱ Yusuhu zu̱ u̱n, <<A no̱ ho̱g u-gye̱r da! ¿Me̱ wa u-Ru̱ u̱m do̱te̱ ya-du̱ no̱ u̱r-ko̱b? ");
INSERT INTO gel_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","No̱ zo̱ngte̱ no̱ no̱mu̱ me̱ no̱m-u̱t yo̱-to̱, se̱di Ru̱-u̱ zo̱ngte̱ to̱ no̱m-u̱t so̱-to̱ rem wa shu̱u̱ste̱ no̱m-u̱ na no̱me̱ da-o̱, u̱ rem wa guut fat-tu̱ u̱t-ne̱t u-tát. ");
INSERT INTO gel_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Remu̱ iya a no̱ ho̱g u-gye̱r da! Me̱ ya'u̱ no̱ no̱m u̱t-re̱ u̱ de̱ ko̱ru̱ no̱ u̱ ya'ag-u̱ no̱ ne̱. Iya-o̱ wa nomte̱ wa ru̱ste̱ jab-u̱s u̱n u̱r-be u̱r-gan.>> ");
INSERT INTO gel_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusuhu shu̱'u̱te̱ u̱ Masar, u̱ yu̱-du̱ u-bu u̱so-u wa ne̱. Wa shu̱'u̱te̱ u̱s-hak u̱t-shik u̱t-tan u̱ o̱p 110. ");
INSERT INTO gel_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yusuhu no̱ng u̱r-yu̱ u̱s-hak u-tát wa hyen ya'ag-u̱ ya'ag-u̱ Makir, wu̱ o̱o̱ge̱ zwaru̱ Manase, i wa mate̱ kandi Yusuhu mar, tu̱msu̱ Yusuhu ku̱b ya'ag-u̱ e̱, e̱ shu̱'u̱t ya'ag-u̱ wa. ");
INSERT INTO gel_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Se̱ Yusuhu zu̱ tu̱-wu̱to̱ wa ne̱, <<Da-u̱ u̱m do̱'e̱ m-mar no̱ngo̱n u̱t-mo̱r. Za o̱ku̱n sakna o̱ Ru̱-u̱ u̱t-haan u̱du̱ no̱ u̱ wa ruut no̱ du̱gu̱ dak-u̱ Masar m-ha dak-u̱ este̱du̱ u̱s-rem su̱ wa no̱mu̱ Ibrahi, Ishaku, u̱ Yakubu ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Se̱ Yusuhu wu̱ ya'ag-u̱ Isra e̱ no̱m u̱s-to̱nd, wa zu̱, <<Ru̱-o̱ u̱t-haan u̱du̱ no̱ o̱ du̱-u̱t no̱. No̱ tabbe̱ u̱zu̱ no̱ kab-u̱g shar-u̱t ri du̱gu̱ din-de̱ be-de̱.>> ");
INSERT INTO gel_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yusuhu maru̱g wa o̱tte̱ u̱s-hak u̱t-shik u̱t-tan u̱ o̱p 110. Da-u̱ u̱n wa'-u̱ u-u̱r wa ba'at-su̱ hoos-du̱ u̱t-zu̱m, na wu̱ u-u̱r wa u adaka u̱ cu̱ndu̱ u̱r-u u̱-me̱ Masar.");
INSERT INTO gel_vpl VALUES ("ET1_1","018_1_1","EST","1","1","1","No̱m-tu̱ no̱me̱ ya da-u̱ Zarake̱s o̱ye̱ u̱r-faru̱k, u̱t-dak u̱t-shik u̱t-shishin u̱ ta'er 127 du̱gu̱ Indiya m-ha u̱ Kus. ");
INSERT INTO gel_vpl VALUES ("ET1_2","018_1_2","EST","1","2","2","U̱ da-u o̱ Faru̱k Zarake̱s o̱ye̱ pora-du̱ u̱r-faru̱k du̱ bo̱-u yat-o̱ u̱ sar m-ja u̱r-be̱b ne̱ sok u̱ Susha. ");
INSERT INTO gel_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","U̱ hak-yu̱ u-tu̱tu̱rse̱ yu̱ u̱r-faru̱k, se̱ wa bu̱n mo̱ro̱g-du̱ re̱-du̱ no̱m-u̱ u̱t-re̱ tu̱-yat-to̱ wa u̱ to̱k-ne̱ wa ne̱. Wa bu̱n karma-ne̱ u̱ i-yate̱ dak-u̱ Pasiya u̱ Midiya, u̱ i-yate̱ gas-u o̱ ne̱ e̱ o̱ u̱ku̱n be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","Mo̱ro̱g-du̱ tumb m-te̱ m-roog u̱t-shik u̱t-jwu̱u̱r 180 wa ko̱se̱ tat-u̱ kwu̱m-u̱t wa tu̱ u̱r-faru̱k, u̱ o̱gu̱r yat-de̱ wa ne̱, u̱ fu̱u̱bse̱-u̱t wa ne̱. ");
INSERT INTO gel_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","Da-u̱ ho̱-u̱t to̱ arke̱, se̱ faru̱k Zarake̱s zo̱ng mo̱ro̱g-du̱ u-re̱ u̱ u̱t-ne̱t u̱t-be̱e̱t, u̱ bo̱-u̱ Susha u̱ o̱tte̱ sar m-ja u̱r-be̱b ne̱ sok, du̱gu̱ i-yate̱ m-ha ne̱t-u̱t re̱k-to̱ ne̱, na tumb m-te̱ m-roog u̱t ta'er u̱-me̱ be-du̱ na se̱rte̱ u̱s-te u̱-do̱ u̱ pyu̱-u̱ faru̱k. ");
INSERT INTO gel_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","Na no̱mu̱g kat-du̱ u-bu Faru̱k u̱t-u̱k tu̱ kus-u̱t pus-to̱ u̱ tu̱ bu̱-mu̱ u̱t-ran ne̱, tu̱msu̱ na gu̱g to̱ u̱ ho-u̱s pus-se̱ su̱ so̱-se̱, u̱ kwat-yu̱ m-baku̱t ne̱ yu̱ na su̱bge̱ u̱r-bo̱ngo̱ tu̱msu̱ pora-tu̱ o̱ró u̱ kwam-tu̱ shik ne̱ tu̱ bu̱-mu̱ u̱t-ro u̱ tu̱ pus-to̱ ne̱, na cin to̱ u̱ kat-du̱ u-bu faru̱k. U̱n dam-u̱t kat-du̱ u-bu faru̱k u̱t-taar tu̱ m-baku̱t u̱t-go̱ u̱t-go̱ tu̱ shik sok. ");
INSERT INTO gel_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","Na mo̱k-te̱ u̱t-ne̱t ke̱ u̱-me̱ ko̱k-tu̱ m-bu̱ tu̱ u̱t-kwam tu̱ shik-u̱ tu̱ kwam-tu̱ shikne̱ tu̱ bu̱-mu̱ u̱t-ro, tu̱msu̱ na haatu̱n ke̱ u̱r-faru̱k u-tát, u̱ka kwu̱m-tu̱ faru̱k. ");
INSERT INTO gel_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","Remu̱ bo̱r-u̱t faru̱k na yu̱' ko̱wan wa swa u̱ka wa o̱tte̱ u̱t-sa, remu̱ u̱zu̱ faru̱k yaag u̱t-bo̱r u̱du̱ a no̱mu̱ wa pama e̱ ya ko̱wan u̱ka wa o̱tte̱ u̱t-sa. ");
INSERT INTO gel_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","U̱ te̱k-u̱ da-u o̱, U-re̱n Vasti zo̱ngte̱ ne̱ta-ne̱ mo̱ro̱g-du̱ re̱-du̱ no̱m u̱t-re̱ u̱ pyu̱-u̱ Faru̱k Zarake̱s. ");
INSERT INTO gel_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","U̱ ho̱-du̱ u̱t-ta'er, u̱ da-u̱ Faru̱k Zarake̱s o̱o̱ge̱ u̱ ho̱-du̱ ke̱ ne̱, se̱ wa no̱me̱ a-to̱mu̱ wa man ne̱ u̱t-ne̱t u̱t-ta'er u̱t-bo̱r tu̱ no̱mu̱ wa u̱s-pama, Me̱human, u̱ Bizta, u̱ Harbona, u̱ Bigta, Abagta, u̱ Ze̱tar, u̱ Karkas ne̱, ");
INSERT INTO gel_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","wa zu̱ e̱ hatu̱n U-re̱n Vasti, u̱du̱ wa m-wa u̱ to̱p-du̱ u̱r-faru̱k-u̱ wa ne̱ u̱ hi-u̱r wa, remu̱ wa ko̱ste̱ zwarru̱ u-shu̱ wa u̱du̱ tu̱-yat-to̱, remu̱ wa ne̱ta so̱-wa wa sok. ");
INSERT INTO gel_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","Da-u̱ a-to̱mu̱ faru̱k hu̱u̱te̱ u̱t-bo̱r wa, U-re̱n Vasti gu̱gu̱m u̱r-haan. Se̱ faru̱k naas jab so̱k u̱s-ryab ne̱. ");
INSERT INTO gel_vpl VALUES ("ET1_13","018_1_13","EST","1","13","13","Za naas u-da, se̱ faru̱k no̱m u̱s-rem u̱ ya-m-nap i yadu̱ wa u̱s-rem ne̱, i nape̱ bo̱r-tu̱ ne̱t-tu̱ Pasiya, remu̱ u̱zu̱ ko̱-uyan da wu̱n no̱m u̱s-remu̱ u̱ a-nap-mu̱ u̱t-bo̱r ne̱. ");
INSERT INTO gel_vpl VALUES ("ET1_14","018_1_14","EST","1","14","14","Dim-tu̱ i-yate̱ faru̱k to̱ o̱ye̱ Karshe̱na, Shetar, Admata, Tarshis, Me̱re̱s, Marse̱na, u̱ Me̱mukan, ayan-ne̱ o̱ye̱ tu̱-yat-to̱ ne̱t-tu̱ Pasiya u̱ Midiya-ne̱. U̱ na shu̱'u̱te̱ faru̱k ne̱ u-da u-be̱e̱t u̱n o̱ tu̱msu̱ m-shu̱p u̱ o̱g-u̱t yat-to̱ ne̱ u̱-me̱ u-dak. ");
INSERT INTO gel_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","Se̱ faru̱k shit wa u̱zu̱ <<¿Remu̱ u̱t-bo̱r yan o̱ na do̱'e̱ no̱mu̱ U-re̱n Vasti? Wa do̱ro̱g u̱t-bo̱r yu̱ yu̱-Yat-ya a-to̱mu̱ Faru̱k Zarake̱s ya'e̱ wa da.>> ");
INSERT INTO gel_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","Me̱mukan shu̱s u̱ shu̱ faru̱k tu̱msu̱ u̱ shu̱ tu̱-yat-to̱, <<U-re̱n Vasti no̱ng no̱mu̱ za kame̱ da, za u̱du̱ faru̱k de̱ u̱ war-wa da m-ha tu̱-yat-to̱ ne̱ u̱t-be̱e̱t, tu̱msu̱ u̱du̱ u̱t-ne̱t u̱t-be̱e̱t u̱ i o̱ me̱ faru̱k-u̱r Faru̱k Zarake̱s u̱r-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","Remu̱ u̱zu̱ no̱m-u̱ u-re̱n no̱me̱ u̱t-shu̱'u̱t u̱s-nap u̱du̱ ko̱ ne̱ta he̱, e̱ shu̱'u̱t a-za yadu̱ m-ze̱g u̱du̱ campa-u̱t e̱ ne̱, <Faru̱k Zarake̱s zu̱ na haatu̱n U-re̱n Vasti u̱-shu̱ wa, wa zu̱, <<U̱m za u̱ haan u̱du̱ wa da.>> Remu̱ iya, a se̱ in no̱mu̱g no̱mu̱ campa-u̱t in ware̱ in da.> ");
INSERT INTO gel_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","U̱ kanda ho̱-u̱r rinde̱ aru̱k, ne̱ta-tu̱ tu̱-yat-to̱ faru̱k-u̱ tu̱-yat-to̱ Pasiya u̱ Midiya-ne̱ a e̱ ho̱ge̱ no̱mu̱ u-re̱n no̱me̱, tu̱msu̱ e̱ do̱'e̱ no̱mu̱ campa-u̱t e̱ rem-su̱ u̱s-ju̱ru̱m u̱ka wa nomte̱. Tu̱msu̱ do̱'e̱ haatu̱n u̱s-ju̱ru̱m u̱ ko̱b-du̱ shu̱'u̱t-du̱ m-yar ne̱. ");
INSERT INTO gel_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","<<Remu̱ iya, a mu̱ne̱ u̱zu̱ no̱ngu̱ faru̱k u̱r-zwar, yage̱ wa no̱m u̱t-bo̱r tu̱ u̱r-faru̱k tu̱msu̱ yage̱ na no̱m u̱s-pan u̱ bo̱r-tu̱ Pasiya u̱ Midiya-ne̱, tu̱ na za u̱t-pas da, tu̱msu̱ u̱zu̱ U-ren Vasti zamu̱n u̱ cwadu̱ shu̱ faru̱k Zarake̱s da, tu̱msu̱ yage̱ faru̱k-u̱ yase̱ waku̱n o̱g-du̱ u̱r-faru̱k u̱du̱ waku̱n wu̱ ze̱ge̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","Da-u̱ ko̱wan ho̱ge̱ do̱nse̱-du̱ faru̱k no̱me̱ u̱-me̱ gas-u̱ wa o̱tte̱ u̱r-faru̱k u-be̱e̱t, tu̱msu̱ ne̱ta-ne̱ do̱'e̱ yadu̱ m-ze̱g u̱du̱ campa-u̱t e̱ du̱gu̱ ne̱ta yat-o̱ u̱ m-ha wu̱ re̱k-wa ne̱.>> ");
INSERT INTO gel_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","Se̱ faru̱k u̱ tu̱-yat-to̱ wa ne̱ e̱ ho̱g u̱r-zwar du̱ rem-u̱s se̱ so̱k, se̱ faru̱k no̱m u̱ka Me̱mukan zu̱tte̱ wa no̱m. ");
INSERT INTO gel_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","Se̱ wa tomot u̱s-pan m-ha ko̱yu̱he̱ gas-ya u̱ dak-u̱ u̱r-faru̱k-u̱ wa u-be̱e̱t, ko̱yu̱he̱ gas-ya u̱ su̱wa pan-se̱ tu̱msu̱ ko̱tu̱he̱ ne̱t-to̱ u̱ rem-u̱r e̱, u̱zu̱ ko̱ campa he̱ no̱m u̱r-faru̱k u̱ bu-u wa. ");
INSERT INTO gel_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","Da-u̱ jab-u̱ Faru̱k Zarake̱s tore̱, se̱ wa baku̱s Vasti u̱ no̱m-u̱ wa no̱me̱ ne̱ tu̱msu̱ u̱ bo̱r-tu̱ na no̱me̱ u̱ mo̱t-u̱t wa ne̱. ");
INSERT INTO gel_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","Se̱ e̱ke̱n u̱ te̱k-u̱ a no̱mu̱ faru̱k m-to̱k i o̱ye̱ u̱t-mo̱r u̱ wa ne̱ e̱ zu̱, <<Yage̱ na kwu̱mu̱ faru̱k ya-u̱t-gwu̱p i so̱-ye̱ i nape̱ campa da. ");
INSERT INTO gel_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","Yage̱ faru̱k wa i-yate̱ du̱gu̱ ko̱-u̱-he̱ gas-o̱ u̱-me̱ u-dak, u̱ remu̱ e̱ haatu̱n ya-u̱t-gwu̱p i o̱ so̱-ye̱ i nape̱ campa-ne̱ da, u-bu u̱ na nomte̱ u̱r-cu̱n du̱ ya-u̱t-gwu̱p faru̱k u̱ bo̱-u̱ Susha u̱ o̱tte̱ sar m-ja u̱r-be̱b ne̱ sok. Yage̱ na wa Hegai wa shu̱'u̱t man faru̱k, wu̱ shu̱'u̱te̱ wa-gwat-du̱ ya-u̱t-gwu̱p faru̱k i nape̱ campa-ne̱ da, u̱ shu̱'u̱t u̱zu̱ wa wa'ag u̱n no̱m u̱s-mang u̱ no̱o̱g-mu̱ mangu̱ u-war u̱ka wa o̱tte̱ u̱t-sa. ");
INSERT INTO gel_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","Se̱ gwu̱p wu̱ cite̱ faru̱k wa kabu̱ wa wa shu̱'u̱t u-re̱n ba Vasti.>> Se̱ rem-u̱s se̱ no̱me̱ faru̱k u̱r-zwar, wa dor se̱. ");
INSERT INTO gel_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","Waku̱n o̱ro u̱ku̱n ne̱t-u̱ Yahuda wa o̱ m-yu̱ u̱ bo̱-u̱ Susha u̱ o̱tte̱ sar u̱ m-ja u̱r-be̱b ne̱ sok. Wa o̱o̱n du̱gu̱ ko̱-u̱r Banyamin. Na zu̱ wa Modekai. Wa'-u̱ Jir, Jir o̱g wa'-u̱ Shimi, Shimi wa'-u̱ Kis. ");
INSERT INTO gel_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","U̱s-hak u-tát su̱ arke̱ wa o̱ teku̱ ne̱t-tu̱ Faru̱k Nebukanezar kabne̱ du̱gu̱ Urusharima m-ha Babira, i na kabne̱ ko̱-u̱r Jekoniya ne̱ faru̱k-u̱ Yahuda. ");
INSERT INTO gel_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","Modekai o̱tte̱ du̱-dim-u̱ wa'-u̱ hu̱no̱ u̱so-u wa ya-du̱ u̱r-gwu̱p de̱ o̱ so̱-de̱ so̱k na zu̱ wa, Hadassa, tu̱msu̱ na zu̱ Esta. Da-u̱ i mate̱ wa mare̱, Modekai ku̱b wa u̱ bu-u wa wa shu̱'u̱t u̱ka wa'-u̱ wa. ");
INSERT INTO gel_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","Da-u̱ na no̱me̱ do̱nse̱-du̱ bo̱r-u̱t faru̱k, na haatu̱n ya-u̱t-gwu̱p u-tát u̱ bo̱-u̱ Susha u̱ o̱tte̱ sar u̱ m-ja u̱r-be̱b ne̱ sok na zu̱ u̱ Hagai u̱ ha gwat-du̱ e̱. Tu̱msu̱ Esta o̱ teku̱ i na kabne̱ m-ha u̱ pyu̱-u̱ faru̱k, Hegai wa shu̱'u̱t wa gwat-du̱ e̱. ");
INSERT INTO gel_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","Esta cite̱ Hagai so̱k wa kwu̱mu̱g hyu̱-m pus-mo̱ u̱du̱ wa. Za naas uda wu̱n kwu̱mnu̱ wa no̱m u̱t-re̱ u̱ no̱o̱g-mu̱ mang u̱ u-war ne̱. U̱ na zo̱nge̱ u̱ remu̱ Esta na yu̱' wa ya'ag u̱t-gwu̱p ta-e̱r du̱gu̱ pyu̱-u̱ Faru̱k se̱ na ku̱b wa na toot wa u̱ be-du̱ ze̱ge̱ u̱r-zwar u̱ be-du̱ na cinte̱ ya-u̱t-gwu̱p-u̱ faru̱k. ");
INSERT INTO gel_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","Esta waru̱g u̱zu̱ wa-Yahuda wa o̱o̱ge̱ da tu̱msu̱ bu-u wan o̱ wa rwu̱tu̱n da remu̱ u̱zu̱ Modekai hoste̱ wa waru̱ waku̱n. ");
INSERT INTO gel_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","Ko̱ mu̱ne̱ Modekai hu̱ u-shu̱ u̱ dim ne̱ u̱ dapu̱s kat-du̱ u-bu be-du̱ na cinte̱ ya-u̱t-gwu̱p remu̱ wa hyan u̱ka Esta o̱tte̱ tu̱msu̱ wa hyan no̱mu̱ do̱'e̱ kwu̱m-du̱ wa. ");
INSERT INTO gel_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","Ko̱wu̱he̱ gwu̱pwa wu̱ nape̱ campa da na yu̱' wa m-gyu̱p m-gan u̱ wa shu̱'u̱t u̱ faru̱k ne̱. Kanda na kab gwu̱p m-ha u̱ yu̱n-u Faru̱k Zarake̱s, se̱ wa no̱ng u̱s-pyat u̱s-o̱p u̱s-yu̱r u̱ mangu̱ u-war, u̱s-pyat u̱s-shishin na o̱ tamu̱ wa m-no̱o̱g, tu̱msu̱ u̱s-pyat u̱s-shishin na o̱ tamu̱ wa m-no̱o̱g mu̱ wu̱s u-haku̱n. ");
INSERT INTO gel_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","Da da-u̱ teye̱ u̱ wa do̱te̱ u̱ cwadu̱ pyu̱-u̱ faru̱k, na yu̱ wa u̱r-ke̱r wa du̱st no̱mu̱ wa o̱o̱ge̱ u̱ssa u-be̱e̱t du̱gu̱ bu-u̱ na cinte̱ ne̱ta-ne̱ m-cwa u̱du̱ Faru̱k. ");
INSERT INTO gel_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","M-rim wa do̱'e̱ m-ha u̱-ku̱n, u̱r-wu̱n wa mu̱u̱n u̱ o̱ko̱n gas-o̱ u̱ be-du̱ na cinte̱ ya-u̱t-gwu̱p i Faru̱k, i o̱o̱ge̱ u̱ ko̱m-u̱t Shaasgaz, wu̱ o̱o̱ge̱ man faru̱k wu̱ gote̱ ne̱ta-tu̱ u̱s-kit i faru̱k rooge̱ u̱ e̱ ne̱. Wu̱n zaar u̱t-mu̱u̱n da se̱ bit-u̱k u̱zu̱ cikte̱ faru̱k wa fagu̱ wu̱n u̱ dim-u̱r ró. ");
INSERT INTO gel_vpl VALUES ("ET2_15","018_2_15","EST","2","15","15","Da da-u Esta byu̱r-ne̱ (wu̱ Modekai kabne̱ wa shu̱'u̱t wa'-u̱ wa, gwu̱p-u̱ hu̱no-u̱ u̱so wa Abiher) u̱ wa do̱te̱ cwadu̱ du̱ faru̱k, Esta shu̱k-u̱t o̱ko̱n da se̱ no̱mu Hagai man faru̱k wa gwat-du̱ bu-u̱ na cinte̱ ya-u̱t-gwu̱p i Faru̱k waru̱ wa. Tu̱msu̱ wa kum hyu̱-m pusmo̱ u̱du̱ ko̱wan wu̱ hyane̱ wa. ");
INSERT INTO gel_vpl VALUES ("ET2_16","018_2_16","EST","2","16","16","Na ku̱b Esta m-ha u̱du̱ Faru̱k Zarake̱s u̱ pyu̱-u̱ wa u̱ pyat-yu̱ na foge̱ Tibet (pyat-yu̱ u-o̱p yu̱ Yahuda-ne̱), u̱ hak-yu̱ u-ta'er yu̱ faru̱k-u̱r wa. ");
INSERT INTO gel_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","Faru̱k o̱ cwan-u̱t Esta m-ze̱g ko̱wu̱he̱ gwu̱p wa. Wa o cwan-u̱t wa so̱k tu̱msu̱ wa kum hyu̱-m pusmo̱ u̱du̱ wa m-ze̱g ya-u̱t-gwu̱p be̱e̱t. Remu̱ iya wa wa'u̱ Esta to̱p-du̱ u̱r-faru̱k wa zu̱ wa o̱ u-re̱n u̱ka Vasti. ");
INSERT INTO gel_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","Se̱ faru̱k no̱m mo̱ro̱g-du̱ re̱-du̱ no̱m-u u̱t-re̱, u̱ ya-du̱ Esta m-ze̱g. Wa bu̱n i-yate̱ pyu̱-u̱ wa u̱ to̱k-ne̱ wa ne̱ be̱e̱t tu̱msu̱ wa yu̱' u̱r-hure̱ u̱s-gas u̱s-be̱e̱t tu̱msu̱ wa no̱mu̱ u̱t-ne̱t u-nya u-tát u̱ka kwu̱m-tu̱ faru̱k-u̱r wa. ");
INSERT INTO gel_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","Da-u̱ na o̱ye̱ u̱ kargu̱sse̱ ya-u̱t-gwu̱p-u̱ da-u yu̱ru̱m-se̱, Modekai o̱ shu̱'u̱t u̱ is-u̱ bu-u faru̱k. ");
INSERT INTO gel_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","Esta wargu̱ waku̱n u̱zu̱ wa-Yahuda wa o̱o̱ge̱ da tu̱msu̱ u̱ bu-u̱ wa ko̱ du̱gu̱ ko̱-u̱r wande̱ wa rwu̱tu̱n da, u̱ka Modekai zu̱tte̱ wa no̱m. Wa re̱ u-shu̱ do̱rru̱ no̱m-u̱ Modekai waru̱ wa da-u̱ wa o̱ re̱k-de̱. ");
INSERT INTO gel_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","Da-u̱ Modekai o̱ u̱ shu̱'u̱t u̱ is-u̱ bu-u faru̱k, se̱ to̱ko̱n ne̱t-to̱ i-yate̱ faru̱k i o̱ e'-du̱ is-u̱ bu-u faru̱k, Bigtan u̱ Te̱re̱s e̱ no̱ng u̱s-ryab u̱ Faru̱k Zarake̱s ne̱, har e̱ zo̱ngte̱ e̱ u̱t-sa e̱ ho̱ wa. ");
INSERT INTO gel_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","Modekai hog no̱m-u̱t yo̱-to̱ tu̱ u̱n zo̱nge̱ u̱t-no̱m, wa ware̱ U-re̱n Esta. Se̱ Esta waru̱ faru̱k u̱zu̱ Modekai wa ho̱ge̱ no̱mu̱ u̱n zo̱nge̱ u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","Da-u̱ na gwate̱ se̱ na nu̱p u̱zu̱ rem-u̱s Modekai nip-to̱ se̱ na tu̱r u̱t-ne̱t u̱t-yu̱r u-kan. Faru̱k yaag u̱t-bo̱r u̱zu̱ na no̱m u̱s-pan su̱ rem-u̱s se̱ u-me̱ u̱t-ran tu̱ cu̱n-du̱ u̱s-rem u̱-shu̱ faru̱k. ");
INSERT INTO gel_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","Da da-u̱ arke̱, Faru̱k Zarake̱s yu̱' Haman wa'-u̱ Hamedata m-ze̱g, ne̱t-u̱ Agagite, wa yu̱ns wa m-pas tu̱-yat-to̱ faru̱k be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","To̱k-ne̱ faru̱k be̱e̱t e̱ do̱'e̱ u̱t-he̱ u̱t-jwu̱n u̱ shu̱ Haman e̱ ya' wa m-ze̱g, remu̱ u̱zu̱ faru̱k zu̱u̱g na no̱m-u̱ wa iya da-u̱ wa o̱ aru̱k. Se̱di Modekai gu̱gu̱m ya-du̱ wa m-ze̱g. ");
INSERT INTO gel_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","Se̱ to̱k-ne̱ faru̱k i o̱ye̱ u̱ ees u̱ is-u̱ faru̱k e̱ shit Modekai, u̱zu̱ <<¿Yan-o̱ wa'e̱ bo̱ yaag faru̱k m-ze̱g u̱ bo̱r-tu̱ wa ya'e̱ da?>> ");
INSERT INTO gel_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","E̱ no̱m u̱s-rem u̱ wa ne̱ ko̱du̱he̱ ho̱-de̱, se̱di wa hen wa gu̱gu̱m u̱t-e̱r. Se̱ u̱n waru̱ Haman no̱mu̱ no̱me̱ remu̱ u̱n hyan no̱m-u̱ wa do̱'e̱ no̱mu̱ Modekai, ko̱ wu̱n u̱ ho̱gu̱ o̱n-u̱r wa ko̱ ba shu̱'u̱t u̱zu̱ wa zu̱u̱g ne̱t-u̱ Yahuda wa o̱ye̱. ");
INSERT INTO gel_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","Da-u̱ Haman hyane̱ u̱zu̱ Modekai he̱e̱g u̱t-jwu̱n wa yu̱' wa m-ze̱g da, se̱ wa no̱m jab so̱k. ");
INSERT INTO gel_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","Da-u̱ Haman nape̱ u̱zu̱ Modekai ne̱t-u̱ Yahuda wa, se̱ wa zu̱ Modekai ko̱rge̱ na ho̱ wa u̱ war-wa da, wa zu̱ na ho̱ Yahuda-ne̱ be̱e̱t i o̱ye̱ u̱ faru̱k-u̱r Zarake̱s. ");
INSERT INTO gel_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","U̱ te̱k-u̱ hak-su̱ o̱p u̱s-yu̱r su̱ Faru̱k Zarake̱s, u̱ pyat-yu̱ na foge̱ Nisan wato pyat-yu̱ u-nas (pyat-yu̱ u̱r-taku̱n yu̱ Yahuda-ne̱) u̱n no̱m u-gwe̱mbi u̱ shu̱ Haman na du̱g u̱r-ho̱ u̱ u-pyat ne̱. Se̱ du̱k-tu̱ he̱e̱n u̱ pyat-yu̱ na foge̱ Adar wato pyat-yu̱ u-ta'er (pyat-yu̱ o̱p u-yu̱r yu̱ Yahuda-ne̱). ");
INSERT INTO gel_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","Se̱ Haman zu̱ Faru̱k Zarake̱s, <<To̱ko̱n ne̱t-to̱ o̱rò u̱ bu̱rgu̱sse̱ u̱ te̱k-u̱ ne̱t-u̱t rò u̱ te̱k-u̱ dak u̱r-faru̱k-u̱ rò ko̱ u-yan u̱ e̱ o̱ m-sha u̱r-ko̱b u̱-me̱ ne̱t-u̱t rò e̱ yaag m-sek u̱ bo̱r-u̱t faru̱k da. Remu̱ iya kamu̱g u̱ faru̱k ho̱g o̱n-u̱r u̱n da. ");
INSERT INTO gel_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","A mu̱ne̱ u̱zu̱ no̱ng faru̱k u̱r-zwar, yage̱ u̱ bo̱r-tu̱ rwu̱n u̱zu̱ na ho̱ru̱sse̱ u̱n, tu̱msu̱ u̱m do̱'e̱ wadu̱ kwam-u̱t pus-to̱ tu̱ o̱tte̱ no-mu̱ u̱t-kwano u̱t-zo̱ngu u̱t-ko̱k u̱t-tu̱t u̱ u̱t-zo̱ngu tu̱ kwaz-tu̱ u̱t-yu̱r u̱ o̱p 350,000 u̱-me̱ cu̱n-du̱ faru̱k remu̱ campa-ne̱ i kabe̱ no̱m-du̱ mo̱ ank-mo̱.>> ");
INSERT INTO gel_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","Se̱ faru̱k ku̱b kwat-yu̱ o̱ye̱ m-wa u̱ jow wa. Kwat-yu̱ o̱tte̱ nap-su̱ u̱r-faru̱k u̱ do̱m-u̱ ya. Wa yase̱ ya u̱du̱ Haman. Haman wa o̱o̱ge̱ wa'-u̱ Hamedata, ne̱t-u̱ Agagite, hu̱u̱b-u̱ yo̱-o̱ Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","Faru̱k zu̱ Haman, <<Cin shik tu̱msu̱ bo̱ no̱me̱ ne̱t-u̱t to̱ u̱ka bo̱ tonte̱.>> ");
INSERT INTO gel_vpl VALUES ("ET3_12","018_3_12","EST","3","12","12","Se̱ u̱ ho̱-du̱ o̱p u̱t-tu̱t u̱ pyat-yu̱ na foge̱ Nisan (pyat-yu̱ u̱r-taku̱n yu̱ Yahuda-ne̱) se̱ na fog a-u̱s-ge̱n u̱ faru̱k ne̱, e̱ no̱m u̱s-ge̱n m-ha me̱ ko̱du̱he̱ ko̱-de̱ tu̱msu̱ m-ha u̱du̱ Wa-u-dak ko̱-u̱-he̱ gas-o̱ u̱-me̱ u̱t-ne̱t u̱t-be̱e̱t u̱ka Haman yu̱te̱ u̱t-bo̱r u̱du̱ to̱k-ne̱ faru̱k yu̱-Yat-ya u̱t-ne̱t ne̱. Na no̱m u̱s-ge̱n u̱ dim-u̱r Faru̱k Zarake̱s u̱ hi-u̱r wa u̱ wa-du̱ kom-u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("ET3_13","018_3_13","EST","3","13","13","Na yase̱ ran-tu̱ u̱s-ge̱n u̱du̱ to̱k-ne̱ faru̱k-u̱ e̱ yase̱ u̱ dak-u wa u-be̱e̱t, no̱mu̱ na zu̱ye̱ u̱-me̱ u̱s-pan ya u̱ ho̱-du̱ o̱p u̱t-tu̱t u̱ pyat-yu̱ o̱p u-yu̱r, wata u̱ ho̱-du̱ u̱t-ta'er u̱ pyat-yu̱ u-tu̱t yu̱ na foge̱ Adar, na do̱'e̱ ho̱du̱ Yahuda-ne̱ i re̱k-e̱ u̱t-ne̱ta ne̱ be̱e̱t, u̱ campa-ne̱, u̱ ya-u̱t-gwu̱p, u̱ ya-u̱t-zwar ne̱ na ho̱ e̱ be̱e̱t na o̱nk no̱m-tu̱ e̱ o̱tte̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","No̱mu̱ o̱ye̱ m-pan u̱-me̱ u-ran na wa'u̱ o̱ shu̱'u̱t u̱t-bo̱r ko̱he̱ne̱, na no̱m u̱r-do̱nse̱ u̱du̱ u̱t-ne̱t u̱t-be̱e̱t u̱-me̱ u-dak rem u̱zu̱ ko̱wan shu̱'u̱t u̱s-zo̱ng ne̱ u̱ ho̱-u̱r re̱. ");
INSERT INTO gel_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","U̱ka faru̱k yu̱te̱ u̱t-bo̱r, se̱ ne̱t-tu̱ o̱o̱ge̱ m-sak do̱m-u̱ jwaak e̱ ku̱b ran-tu̱ u̱s-pan m-ho̱ m-ho̱r m-cwa u̱-me̱ bo̱-u̱ Susha u̱ o̱tte̱ sar m-ja u̱r-be̱b ne̱ sok. Faru̱k e̱ Haman da-u̱ e̱ shu̱'u̱te̱ e̱ o̱ swadu̱ ke̱, se̱di ne̱t-tu̱ bo̱-u̱ Susha u-be̱e̱t e̱ o̱ te̱k u-gwu̱z. ");
INSERT INTO gel_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","Da-u̱ Modekai kume̱ zu̱n-mu̱ no̱mu̱ no̱me̱ u-be̱e̱t, se̱ wa kees u̱t-kus tu̱ u-war, u̱ remu̱ namu̱ jab. Se̱ wa wu̱' cwu̱-tu̱ namu̱ jab m-cwa-ne̱, se̱ wa aru̱k m-cwa u-bo̱ wa o̱ u̱s-kan m-yat sok. ");
INSERT INTO gel_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","Se̱di da-u̱ wa tene̱ is u-bu u̱ faru̱k, na yaag wa aru̱k m-cwa u̱-me̱ u-bu da rem u̱zu̱ waku̱n zaar wu̱ do̱'e̱ cwadu̱ bu-u faru̱k-u̱ ku̱s-tu̱ namu̱ jab ne̱ da. ");
INSERT INTO gel_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","Ko̱he̱ne̱ u̱ dak-u̱t faru̱k u-be̱e̱t u̱ be-du̱ bo̱r-u̱t wa te̱ye̱ u-be̱e̱t, se̱ Yahuda-ne̱ no̱m u̱s-kan m-yat sok u̱ namu̱ jab ne̱ tu̱msu̱ u-swaat ne̱, u̱t-ne̱t u-tát u̱-me̱ u̱n e̱ wu̱ kus-tu̱ namu̱ jab e̱ re̱t u̱-me̱ m-cwa. ");
INSERT INTO gel_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","Da-u̱ ya-u̱t-gwu̱p u̱r-shu̱-e̱ i o̱ye̱ no̱mu̱ U-re̱n Esta m-to̱k e̱ haan e̱ waru̱ wa mo̱t-u̱t Modekai, se̱ Esta no̱m namu̱ jab so̱k. Se̱ Esta tomtu̱ u̱t-kus u̱ Modekai swase̱ kus-tu̱ namu̱ jab, se̱di Modekai o̱nkte̱ da. ");
INSERT INTO gel_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","Se̱ Esta o̱tte̱ to̱k wu̱ na zu̱ye̱ Hatak, wu̱ faru̱k ya'u̱ wa. Se̱ Esta fog wa, Esta zu̱, <<Do̱'e̱ bo̱ hyan u̱zu̱ yan-o̱ kume̱ Modekai tu̱msu̱ bo̱ shit wu̱n u̱zu̱ yan-o̱ kume̱ wa tu̱msu̱ u̱zu̱ yan-o̱ wa o̱tte̱ u̱ namu̱ jab.>> ");
INSERT INTO gel_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","Se̱ Hatak do̱'e̱ u̱du̱ Modekai u̱ be-du̱ m-zu̱n u̱-do̱ u-bo̱ u̱-shu̱ is-yu̱ cwadu̱ pyu̱-u̱ faru̱k. ");
INSERT INTO gel_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","Modekai waru̱ wu̱n no̱mu̱ no̱me̱ u-be̱e̱t. Wa waru̱ Hatak shik-u̱ Haman no̱m-te̱ e̱s-du̱ u̱s-rem u̱zu̱ wa u̱t-hu̱u̱t be-du̱ u̱r-cu̱nu̱ faru̱k, a mu̱ne̱ u̱zu̱ na ho̱o̱g Yahuda-ne̱ be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","Modekai yasu̱ Hatak bo̱r-tu̱ na pane̱ u̱ Susha tu̱ zu̱ye̱ na ho̱ Yahuda-ne̱ be̱e̱t. Modekai kon Hatak u̱zu̱ wa ko̱se̱ Esta ran-tu̱ bo̱r-u̱ to̱ wa waru̱ wa u̱zu̱ wa do̱'e̱ u̱du̱ Faru̱k wa kon wa, wa no̱m u̱s-ko̱n u̱ remu̱ ne̱t-u̱t wa. ");
INSERT INTO gel_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","Se̱ Hatak mu u̱du̱ Esta wa waru̱ wa no̱m-u̱ Modekai zu̱ye̱. ");
INSERT INTO gel_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","Se̱ Esta waru̱ Hatak u̱zu̱ wa mu wa waru̱ Modekai u̱zu̱, ");
INSERT INTO gel_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","<<Bo̱r-tu̱ o̱ró tu̱ ha-mu̱ hyan-du̱ faru̱k, tu̱msu̱ i-yate̱ wa u̱ ne̱t-u̱t wa ne̱ u̱t-be̱e̱t e̱ nak u̱ mo̱t-tu̱ bo̱r-u ya ne̱. Ko̱wana u̱r-cwa u̱du̱ faru̱k za faru̱k-u̱ fag wa na ho̱ wa. Fu̱n-ya u-gan u̱ war-ya yu̱ ne̱t de̱te̱ u̱t-ku̱su̱m a mu̱ne̱ faru̱k nabu̱g ko̱m-yu̱ m-baku̱t yu̱ u̱r-faru̱k-u̱ wa u̱du̱ ne̱t. U̱ ya-o̱ teeg m-roog u̱r-shik u̱ o̱p u̱ faru̱k fu̱gte̱ me̱ u̱ pyu̱-u̱ wa.>> ");
INSERT INTO gel_vpl VALUES ("ET4_12","018_4_12","EST","4","12","12","Da-u̱ na waru̱ Modekai no̱m-u̱ Esta zu̱ye̱, ");
INSERT INTO gel_vpl VALUES ("ET4_13","018_4_13","EST","4","13","13","Modekai mutu̱ Esta u-nu wa zu̱, <<A-bo̱ gwat u̱zu̱ bo̱ u̱t-ku̱su̱m rem u̱zu̱ bo̱ o̱ shu̱'u̱t u̱-me̱ bu-u faru̱k da. A mu̱ne̱ u̱zu̱ na hog Yahuda-ne̱ be̱e̱t na da yagu̱ bo̱ da. ");
INSERT INTO gel_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","Remu̱ u̱zu̱ a bo̱ hose̱ u̱s-ram gwu̱du̱ Yahuda-ne̱ do̱'e̱ rwu̱u̱n u̱ yaku̱n fu̱n-ya, tu̱msu̱ bo̱ u̱ bu-u no̱ ne̱ u-be̱e̱t na do̱'e̱ ho̱du̱ no̱ be̱e̱t. ¿Wana nape̱ ko̱ jiya remu̱ go̱-du̱ uno̱ da-o̱ wa'e̱ na du̱g-u̱t bo̱ u-re̱n?>> ");
INSERT INTO gel_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","Esta no̱m to̱m u̱du̱ Modekai, u̱zu̱, ");
INSERT INTO gel_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","<<De̱'e̱ bo̱ kargu̱sse̱ Yahuda-ne̱ i o̱ye̱ u̱ Susha, e̱ no̱m u-swa'at u̱ remu̱ ri. A no̱ re̱ ko no̱ swa da m-roog u̱t-tu̱t m-gyu̱p u-ho̱ ne̱. Me̱ u̱ ya-u̱t-gwu̱p-u̱ ri ne̱ it u̱t-no̱m u̱ka no̱ nomte̱. Da-u̱ na tase̱, me̱ u̱t-ha u̱du̱ faru̱k, ko̱ ba shu̱'u̱te̱ u̱zu̱ pas-du̱ u̱t-bo̱r de̱. A shu̱'u̱te̱ u̱zu̱ m-mar, se̱di m-mar.>> ");
INSERT INTO gel_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","Modekai aru̱k wa no̱m no̱m-u̱ Esta zu̱ye̱ wa no̱m. ");
INSERT INTO gel_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","U̱ ho̱-du̱ tu̱tu̱rse̱ Esta wu̱' u̱t-kus tu̱ u-re̱n. Wa to u̱ kur-u̱ me̱ m-gwat pyu̱, Faru̱k o̱ u̱ shu̱'u̱t u̱ pora-du̱ u̱r-faru̱k, du̱ o̱ye̱ m-gwat is-yu̱ u̱r-cwa. ");
INSERT INTO gel_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","Da-u̱ faru̱k hyane̱ U-re̱n Esta u̱ ees u̱-shu̱ pyu̱-u̱ faru̱k no̱m u̱r-so̱ so̱k, se̱ wa nu̱b ko̱m-yu̱ m-bak-u̱t yu̱ bu̱-mu̱ u̱t-rò yu̱ u̱r-faru̱k yu̱ o̱ye̱ u̱ ko̱m-u̱t wa. Tu̱msu̱ Esta haan se̱ wa tu̱m ko̱m-yu̱ u̱r-faru̱k. ");
INSERT INTO gel_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","Se̱ faru̱k shit, <<¿Yan-o̱, U-re̱n Esta? ¿Yan-o̱ bo̱ u̱t-sa? Ko̱ u̱zu̱ u̱k u̱r-faru̱k o̱ bo̱ u̱t-sa, me̱ ya'u̱ bo̱ o̱.>> ");
INSERT INTO gel_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","Esta zu̱, <<A mu̱ne̱ u̱zu̱ no̱nge̱ faru̱k u̱r-zwar yage̱ faru̱k-u̱ haan ya-o̱ u̱r-ko̱t u̱ Haman ne̱, u̱r-mo̱ro̱g du̱ re̱-du̱ no̱m u̱t-re̱ u̱m zo̱nge̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","Se̱ faru̱k zu̱, <<Na haatu̱n Haman u̱ ana za wa'as remu̱ it nomot no̱m-u̱ Esta zu̱ye̱.>> Se̱ faru̱k e̱ Haman do̱'e̱ u̱du̱ mo̱ro̱g-du̱ Esta zo̱nge̱. ");
INSERT INTO gel_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","Da-u̱ e̱ o̱ye̱ swa-u̱ ke̱, faru̱k shit Esta, <<¿U̱ da-o̱ yan-o̱ bo̱ u̱t-sa? Na ya'u̱ bo̱ o̱. ¿U̱ da-o̱ yan-o̱ o̱o̱ge̱ ko̱n-u̱s ró? Ko̱ da u̱k u̱r-faru̱k-u̱ ri o̱, na ya'u̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","Esta o̱nk wa zu̱, <<Ko̱n-u̱s ri u̱ no̱m-u̱ u̱m u̱t-sa ne̱ ya: ");
INSERT INTO gel_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","A mu̱ne̱ u̱zu̱ no̱ng faru̱k u̱r-zwar tu̱msu̱ a mu̱ne̱ u̱zu̱ u̱m kwu̱mu̱g hyu̱-m pusmo̱ u̱du̱ faru̱k wa o̱nk ko̱n-u̱s ri tu̱msu̱ wa no̱mu̱ me̱ no̱m-u̱ u̱m u̱t-sa, yage̱ faru̱k-u̱ Haman u̱ haan u-sot u̱du̱ u̱r-mo̱ro̱g du̱ u̱m zo̱nge̱ no̱. Da-u o̱ u̱m do̱'e̱ o̱nku̱ shu̱t-u̱r u̱r-faru̱k.>> ");
INSERT INTO gel_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","Haman aru̱k m-rwu̱ u̱r-so̱ da-u̱ wa yage̱ be-du̱ u̱r-mo̱ro̱g! Se̱di da-u̱ wa hyane̱ Modekai u̱ shu̱'u̱t u̱ is-yu̱ pyu̱-u̱ faru̱k, wa yu̱nge̱ wa ko̱se̱ ho̱g-du̱ u-gye̱r u̱-shu̱ wa da, se̱ Haman no̱m jab so̱k. ");
INSERT INTO gel_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","M-ha iyane̱, Haman aru̱k m-mu̱ u̱ u-bu wa rest jab-u̱ wa. Se̱ wa-to̱mu̱-u̱ hu̱u̱b-u̱t wa u̱ ne̱ta wa Zere̱s, u̱zu̱ e̱ haan. ");
INSERT INTO gel_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","Haman no̱mu̱g hi-u̱t yat-to̱ u̱du̱ u̱n remu̱ tat-u̱ kwu̱m-u̱t wa u̱ tat-u̱ ya'ag-u̱ wa ne̱, u̱s-fu̱n u̱s-be̱e̱t su̱ faru̱k yu̱te̱ wu̱n m-ze̱g, tu̱msu̱ u̱ka na yu̱te̱ wa m-sek m-ze̱g u̱t-ne̱t u̱t-be̱e̱t u̱ tu̱-yat-to̱ faru̱k ne̱. ");
INSERT INTO gel_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","Se̱ Haman sur m-zu̱, <<Me̱ wa u-gan wu̱ U-re̱n Esta bane̱ m-haan u̱ faru̱k ne̱ u̱du̱ u̱r-mo̱ro̱g du̱ wa bane̱. Tu̱msu̱ wa banu̱g me̱ u̱ faru̱k ne̱ u-sot.>> ");
INSERT INTO gel_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","Se̱ Haman zu̱, <<To̱ no̱m-to̱ u̱t-be̱e̱t to̱ zaar o̱kon no̱mo̱ u̱du̱ ri da, a mu̱ne̱ u̱m o̱ hyan-du̱ ne̱t-u̱ Yahuda-ne̱ Modekai u̱ shu̱'u̱t u̱ is-yu̱ pyu̱-u̱ faru̱k.>> ");
INSERT INTO gel_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","Ne̱ta wa Zere̱s u̱ hu̱u̱b-u̱t wa ne̱ u̱t-be̱e̱t, e̱ zu̱ wa, <<Yage̱ na yu̱nu̱s u-kan yu̱ tarru̱ u̱t-ne̱t yu̱ wu̱ru̱m ya te̱ye̱ daag-su̱ m-ha u̱t-shik u̱t-yu̱r u̱ o̱p 50. U-sot u̱r-wu̱n bo̱ no̱m u̱s-rem u̱ faru̱k ne̱ u̱zu̱ na tar Modekai u-kan. Se̱ no̱ faru̱k ha u̱ mo̱ro̱g-du̱ re̱-du̱ no̱m-u̱t-re̱ u̱ te̱k-u̱ ho̱g-du̱ u̱r-zwar.>> Se̱ Haman ho̱g u̱r-zwar so̱k se̱ wa zu̱ na yu̱nu̱s u-kan yu̱ tarru̱ u̱t-ne̱t. ");
INSERT INTO gel_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","U̱ gyu̱p-m mo̱ faru̱k kerge̱ m-roog da. Se̱ wa wu̱' na hatu̱n ran-tu̱ cu̱n-du̱ u̱s-rem tu̱ ogor-tu̱ faru̱k-u̱r wa, u̱ na karu̱nte̱ u̱-shu̱ wa. ");
INSERT INTO gel_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","Se̱ na bit m-pan u̱ku̱n u̱zu̱ Modekai upuste̱ no̱m-u̱ Bigtan ne̱ e̱ Te̱re̱s o̱o̱ge̱ u̱t-sa e̱ no̱m, tu̱-yat-to̱ Faru̱k i o̱o̱ge̱ e-du̱ is-yu̱ u-bu. I zo̱ngte̱ remu̱ e̱ ho-u̱t Faru̱k Zarake̱s. ");
INSERT INTO gel_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","Faru̱k shit, <<¿Yan go̱-du̱ u̱r-o̱g de̱ ko̱ m-sek mo̱ na do̱'e̱ ya-du̱ Modekai?>> No̱m-u̱ i o̱o̱ge̱ u̱r-kot u̱ wu̱n ne̱ shase̱, <<Na no̱ngu̱ wu̱n o̱ku̱n da.>> ");
INSERT INTO gel_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","Faru̱k zu̱, <<¿Wana o̱o̱ge̱ ku̱n u̱-do̱ u̱-me̱ kat-du̱ u-bu?>> U̱ da-u o̱ Haman cwaag u̱-me̱ kat-du̱ u-bu u̱ o̱o̱ge̱ u̱-do̱ u̱ pyu̱-u̱ faru̱k. Wa o̱ u̱t-sa wa no̱m u̱s-rem u̱ faru̱k ne̱ u̱ka na de̱te̱ su̱rgu̱sse̱ Modekai u̱ do̱m-u̱ u-kan yu̱ wa zo̱nge̱ u̱ remu̱ wa. ");
INSERT INTO gel_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","Ne̱t-tu̱ o̱o̱ge̱ wu̱n ne̱ zu̱, <<Haman o̱ ees u̱-me̱ kur-u̱ kwu̱p-du̱ u̱s-rem.>> Faru̱k shu̱s wa zu̱, <<Cwatu̱n wu̱n u̱-me̱.>> ");
INSERT INTO gel_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","Da-u̱ Haman cwaye̱ u̱-me̱, faru̱k shit wa, <<¿Yan-o̱ na do̱'e̱ no̱mu̱ ne̱t wu̱ faru̱k o̱o̱ge̱ u̱r-so̱ u̱zu̱ wa ya' wa m-sek?>> Se̱ Haman nom u̱s-dorog u̱ hi-u̱r wa, <<¿Wana o̱o̱ge̱ u̱-ku̱n wu̱ faru̱k do̱'e̱ yadu̱ m-sek m-pas me̱?>> ");
INSERT INTO gel_vpl VALUES ("ET6_7","018_6_7","EST","6","7","7","Se̱ Haman zu̱ faru̱k, <<In di u̱zu̱ waku̱n o̱ró wu̱ bo̱ do̱'e̱ yadu̱ m-sek, ");
INSERT INTO gel_vpl VALUES ("ET6_8","018_6_8","EST","6","8","8","yage̱ na hatu̱n to̱ggo̱-yu̱ u̱r-faru̱k yu̱ faru̱k tame̱ u̱t-wa, u-jwaak ne̱ yu̱ faru̱k tamte̱ m-sak, yu̱ o̱tte̱ u̱t-u̱k go̱-du̱ tu̱ u̱r-faru̱k u̱ do̱m-u̱ hi-u̱r ya. ");
INSERT INTO gel_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","Yage̱ na yase̱ waku̱n u̱ te̱k-u̱ i-yate̱ faru̱k wu̱ zu̱ge̱ m-sek. Yage̱ e̱ wa-u̱ wu̱ faru̱k o̱o̱ge̱ u̱t-sa wa ya' wa m-sek. Tu̱msu̱ wa sak u-jwaak na kab wa m-cwa u̱-me̱ fu̱n-su̱ me̱ u-bo̱, na war u̱-shu̱ ne̱t-u̱ wa u̱zu̱, <Gwat no̱m-u̱ na no̱me̱ ne̱t wu̱ faru̱k o̱o̱ge̱ u̱t-sa wa ya' wa m-sek!> >> ");
INSERT INTO gel_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","Faru̱k zu̱ Haman, <<Do̱'e̱ bo̱ no̱m m-ho̱r m-ho̱r! Bu̱ kab to̱ggo̱-u ri u̱ jwaak-u ri ne̱, tu̱msu̱ bo̱ no̱m no̱m-u̱ bo̱ zu̱ye̱ na no̱m! Bo̱ no̱mu̱ Modekai iya, ne̱t-u̱ Yahuda, wu̱ o̱o̱ge̱ u̱ shu̱'u̱t u̱ is-yu̱ cwadu̱ pyu̱. Tass o̱ku̱n no̱mo̱ ka bo̱ u̱t-to̱ u̱ te̱k-u̱ no̱m-u̱ bo̱ zu̱ye̱ da.>> ");
INSERT INTO gel_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","Se̱ Haman kabu̱n u-to̱ggo̱ u-jwaak ne̱. Wa wa'u̱ Modekai, wa ku̱b wa m-cwa u̱-me̱ fu̱n-su̱ u-bo̱, wa u̱t-war u̱-shu̱ wa, <<Gwatu̱n no̱m-u̱ na no̱me̱ wu̱ faru̱k o̱o̱ge̱ u̱t-sa wa ya' wa m-sek!>> ");
INSERT INTO gel_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","Da tase̱ Modekai aru̱k m-mu̱ u̱ fu̱n-yu̱ bu-u faru̱k, se̱ Haman aru̱k m-mu̱ m-so̱m u̱ me̱n-u̱t rim-to̱ ne̱. Wa hog m-'e̱ sok. ");
INSERT INTO gel_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","Se̱ Haman waru̱ Zere̱s ne̱ta wa u̱ hu̱u̱b-u̱t wa ne̱ no̱mu̱ na no̱me̱ wa u-be̱e̱t u̱ ho̱-u̱r re̱. Se̱ ne̱ta wa u̱ hu̱u̱b-u̱t wa ne̱, e̱ zu̱ wa, <<Modekai, ne̱t wu̱ wa'e̱ bo̱ ho̱g-du̱ m-'e̱, ne̱t-u̱ Yahuda wa. Bo̱ zaaru̱ ke̱ru̱ re̱-du̱ Modekai m-gag da. Wa re̱ bo̱ m-gag!>> ");
INSERT INTO gel_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","Da-u̱ u̱n o̱ te̱k-u̱ no̱mu̱ wa u̱s-rem, se̱ te̱k-u̱ tu̱-yat-to̱ faru̱k haan e̱ ku̱b Haman m-ha u̱ be-du̱ re̱-du̱ no̱m u̱t-re̱ u̱ Esta zo̱nge̱. ");
INSERT INTO gel_vpl VALUES ("ET7_1","018_7_1","EST","7","1","1","Se̱ faru̱k ne̱ e̱ Haman aru̱k m-ha u̱ be-du̱ re̱-du̱ no̱m u̱t-re̱ U-re̱n Esta bane̱. ");
INSERT INTO gel_vpl VALUES ("ET7_2","018_7_2","EST","7","2","2","Da-u̱ u̱n o̱ te̱k-u̱ swadu̱ ke̱, faru̱k sur m-shu̱'u̱t, <<U-re̱n Esta, ¿yan-o̱ o̱o̱ge̱ ko̱n-u̱s ró? Na ya'u̱ bo̱ o̱. ¿Yan-o̱ o̱o̱ge̱ ko̱n-u̱s ró? Me̱ ya'u̱ bo̱ ko̱ da u̱k u̱r-faru̱k-u̱ ri o̱, me̱ ya'u̱ bo̱ o̱.>> ");
INSERT INTO gel_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","U-re̱n Esta zu̱, <<A mu̱ne̱ u̱zu̱ u̱m kwu̱mu̱g hyu̱-m pusmo̱ u̱du̱ faru̱k, tu̱msu̱ a mu̱ne̱ u̱zu̱ no̱ng faru̱k u̱r-zwar wa ya' me̱ ko̱n-u̱s ri. U̱m u̱s-ko̱n u̱zu̱ fat-u̱r ri u̱ fat-tu̱ ne̱t-u̱t ri ne̱ kum u̱t-pos. ");
INSERT INTO gel_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","Remu̱ u̱zu̱ me̱ u̱ ne̱t-u̱t ri ne̱ na bu̱pu̱ste̱ it u̱du̱ i do̱'e̱ ho̱du̱ it, u̱t-pan, u̱ na hast it. A-za mu̱ne̱ u̱zu̱ na bu̱pu̱ste̱ it sha-mu̱ to̱k-ne̱, u̱m da zu̱t o̱kon da, rem u̱zu̱ da shu̱'u̱te̱ no̱m-u yat-o̱ u̱ do̱'e̱ e̱kse̱ Faru̱k da.>> ");
INSERT INTO gel_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","Faru̱k Zarake̱s shit U-re̱n Esta, <<¿Wana do̱'e̱ no̱m-du̱ go̱-du̱ o̱ no̱m-o̱? ¿Wana ne̱t-u̱ wa wu̱ do̱'e̱ u̱t-jaru̱n wa tam bo̱?>> ");
INSERT INTO gel_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","Esta zu̱, <<Ne̱t wu̱ o̱o̱ge̱ hu̱u̱b-u̱ yo̱-wa it u̱ ya Haman ne̱t-u̱ yo̱-wa!>> Haman hog u-gye̱r so̱k da-u̱ wa o̱o̱ge̱ ees u̱-shu̱ faru̱k e̱ U-re̱n Esta. ");
INSERT INTO gel_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","Se̱ faru̱k yu̱ne̱ u̱ te̱k-u̱ namu̱ jab. Wa yage̱ ke̱ wa aru̱k m-cwa me̱ be-du̱ na se̱rte̱ u̱s-te u̱ pyu̱-u̱ faru̱k. Se̱di Haman, wa ees wa o̱ ko̱n-du̱ U-re̱n Esta wa guu fat-u̱r wa, remu̱ u̱zu̱ wa nak no̱m-u yo̱-o̱ u̱ faru̱k do̱'e̱ no̱mu̱ wa. ");
INSERT INTO gel_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","Da-u̱ Faru̱k mu̱u̱ne̱ be-du̱ na se̱rte̱ u̱s-te du̱ pyu̱-u̱ Faru̱k wa o̱ m-cwa u-me̱ pyu̱, Haman he̱e̱g u̱-do̱mu̱ u̱r-wu̱ndi u̱ Esta o̱tte̱ m-ru̱t. Se̱ faru̱k no̱m u̱t-jar m-yat, wa zu̱, <<¿Wa o̱ u̱ssa wa no̱mu̱ U-re̱n Esta u̱r-ryapu̱k u̱ ana u̱-me̱ u-pada, u̱ hyan-mu̱ is-u̱ ri?>> Za naas u-da faru̱k no̱m u̱s-rem, ne̱t-tu̱ o̱o̱ge̱ u̱r-ko̱t u̱ wu̱n ne̱ e̱ taku̱s shu̱-u Haman. ");
INSERT INTO gel_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","Se̱ Harbona, wagan u̱ te̱k-u̱ a no̱mu̱ faru̱k m-ank, wa shu̱s zu̱, <<Haman shirge̱ u-kan yu̱ no̱me̱ m-ja mu̱ daag-su̱ m-ha u̱t-shik u̱t-yu̱r u̱ o̱p 50 u̱-me̱ bu-u wa. Wa zo̱ngte̱ ya u̱ remu̱ wa tu̱ru̱t Modekai, wu̱ guu fat-du̱ faru̱k.>> Faru̱k shu̱s wa zu̱, <<Su̱rgu̱ssu̱n Haman u̱ kan-u ya.>> ");
INSERT INTO gel_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","Se̱ u̱n su̱rgu̱sse̱ Haman u̱-do̱mu̱ u-kan yu̱ wa zo̱nge̱ u̱ remu̱ Modekai. Se̱ namu̱ jab faru̱k ciz. ");
INSERT INTO gel_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","U̱ gandi ho̱-u̱r re̱ Faru̱k Zarake̱s yase̱ U-re̱n Esta no̱m-u̱ u̱t-kom-u̱ Haman u-be̱e̱t, hu̱u̱b-u̱ yo̱-wa Yahuda-ne̱. Modekai haan u̱-shu̱ faru̱k, rem u̱zu̱ Esta waru̱g u̱ka wa o̱tte̱ u̱t-mo̱r u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","Se̱ faru̱k host kwat-yu̱ ge̱r-u̱ wa, yu̱ wa o̱nke̱ du̱gu̱-du̱ Haman, wa yase̱ Modekai. Tu̱msu̱ Esta wu̱' wa gwat-u̱ wa no̱m-tu̱ Haman o̱tte̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","Esta sur m-no̱m u̱s-ko̱n u̱du̱ faru̱k, wa he u-dak u̱ na-u̱s wa. Esta no̱m u̱s-ko̱n m-is ne̱ u̱ wa hast no̱m-u̱t yo̱-to̱ tu̱ Haman wa-Agagite shire̱ m-ha u̱du̱ Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","Tu̱msu̱ faru̱k nu̱b ko̱m-yu̱ m-bak-u̱t wa u̱du̱ Esta: se̱ wa yu̱ne̱ wa ees u̱-shu̱ faru̱k. ");
INSERT INTO gel_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","Esta zu̱, <<A mu̱ne̱ u̱zu̱ no̱mu̱g faru̱k u̱r-zwar, tu̱msu̱ a u̱m kume̱ hyu̱-m pusmo̱ u̱du̱ wa, tu̱msu̱ a wa hyane̱ u̱zu̱ no̱ng u̱r-zwar, tu̱msu̱ a wa ho̱ge̱ zwar-u̱r ri. Yage̱ wa no̱m u̱t-bo̱r tu̱ do̱'e̱ bargu̱sse̱ bo̱r-u̱t Haman wa'-u̱ Hamedata, ne̱t-u̱ ko̱-du̱ Agagite, tu̱ wa no̱me̱ u̱zu̱ na ho̱ru̱sse̱ ne̱t-tu̱ Yahuda-ne̱ u̱-me̱ dak-tu̱ u̱r-faru̱k-u̱ ró. ");
INSERT INTO gel_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","¿Re̱ne̱ o̱ u̱m de̱te̱ kere̱ du̱ u̱r-ees u̱m hyan no̱m-u yo̱-o̱ u̱ he̱e̱n u̱du̱ ne̱t-u̱t ri? ¿Re̱ne̱ o̱ u̱m do̱te̱ kere̱ du̱ hyan-du̱ mar-mu̱ ne̱t-tu̱ u-bu ri?>> ");
INSERT INTO gel_vpl VALUES ("ET8_7","018_8_7","EST","8","7","7","Faru̱k Zarake̱s zu̱ U-re̱n Esta ne̱ e̱ Modekai ne̱t-u̱ Yahuda, <<Rem u̱zu̱ Haman he̱se̱te̱ Yahuda-ne̱, u̱m yaste̱ no̱m-u̱ u̱t-kom-u̱ Haman u̱du̱ Esta, tu̱msu̱ na su̱rgu̱sse̱ wu̱n u-kan. ");
INSERT INTO gel_vpl VALUES ("ET8_8","018_8_8","EST","8","8","8","U̱ da-o̱ sur m-pan to̱ku̱n bo̱r-to̱ u̱ dim-du̱ faru̱k-u̱ ees-mu̱ Yahuda-ne̱ u̱ka cittu̱ bo̱. Tu̱msu̱ bo̱ rake̱ ran-u̱t to̱ u̱ kwat-yu̱ faru̱k, remu̱ u̱zu̱ no̱m-u̱ na pane̱ u-be̱e̱t u̱ dim-du̱ faru̱k tu̱msu̱ na rake̱ to̱ u̱ kwat-yu̱ faru̱k waku̱n zaar wu̱ do̱'e̱ swase̱ o̱ da.>> ");
INSERT INTO gel_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","Za naas u-da se̱ na fog ya-u̱s-panu̱ faru̱k ne̱. Na no̱ng iya u̱ ho̱-du̱ u̱r-shik u̱t-tu̱t u̱ pyat-yu̱ na foge̱ Sivan (pyat-yu̱ u-tu̱t yu̱ Yahuda-ne̱). U̱n pu̱n bo̱r-u̱t Modekai m-ha du̱ Yahuda-ne̱, tu̱msu̱ m-ha tu̱-yat-to̱ ne̱, u̱ faru̱k-u̱t yat-to̱ ne̱ tu̱msu̱ u̱ i na o̱ m-ho̱g-u̱ e̱ ne̱ u̱t-gas u̱t-kwaz u̱t-shishin u̱t-ta'er 127 du̱gu̱ Indiya m-ha Kus ne̱. Na pu̱n ran-u̱t to̱ tu̱msu̱ u̱-me̱ u̱ pan-u̱s e̱ tu̱msu̱ u̱ rem-tu̱ ne̱t-tu̱ gas-u o̱ u̱t-be̱e̱t, u̱ dame̱ u̱s-pan ne̱ u̱ rem-du̱ Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","Modekai nom u̱s-pan u̱ dim-du̱ Faru̱k Zarake̱s, se̱ na rake̱ ran-tu̱ na pane̱ to̱ u̱ kwat-yu̱ faru̱k. Na yase̱ a-u̱s-to̱m-u̱ Faru̱k ne̱, e̱ su̱k u̱ jwaak i ze̱ge̱ m-so̱m i o̱o̱ge̱ go̱-u̱r yat-de̱ i na dage̱ u̱ remu̱ to̱m-su̱ faru̱k. ");
INSERT INTO gel_vpl VALUES ("ET8_11","018_8_11","EST","8","11","11","Faru̱k yu̱' Yahuda-ne̱ i ko̱ bo̱-u̱ he̱ne̱ u̱r-ke̱r e̱ same̱ hi-u̱t e̱, remu̱ e̱ guut fat-u̱t e̱. Na yu̱' e̱ u̱r-ke̱r e̱ ho̱, e̱ pan, tu̱msu̱ e̱ ho̱ru̱sse̱ ko̱ i he̱ karma-ne̱ i m-gag du̱gu̱ ko̱-yu̱-he̱ gas-ya i do̱'e̱ he̱e̱se̱ u̱n m-dum ko̱ ya'ag-u̱ u̱n u̱ ne̱ta-u̱t u̱n ne̱. Tu̱msu̱ e̱ o̱nk cwu̱-tu̱ hu̱u̱b-tu̱ m-gag u̱ u̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("ET8_12","018_8_12","EST","8","12","12","Ho̱-du̱ na este̱ u̱zu̱ ne̱t-tu̱ Yahuda-ne̱ no̱m iya u̱-me̱ gas-su̱ Faru̱k Zarake̱s o̱tte̱ u̱r-faru̱k de̱ o̱ ho̱-du̱ o̱p u̱t-tu̱t u̱ pyat-yu̱ na foge̱ Adar (pyat-yu̱ o̱p u-yu̱r yu̱ Yahuda-ne̱). ");
INSERT INTO gel_vpl VALUES ("ET8_13","018_8_13","EST","8","13","13","Ran-tu̱ na pane̱ na rake̱ to̱ na tomot to̱ u̱ka u̱t-bo̱r u̱s-gas u̱t-be̱e̱t. Tu̱msu̱ na karu̱nte̱ to̱ u̱-shu̱ ne̱t ne̱, u̱ remu̱ Yahuda-ne̱ e̱ zo̱ng e̱ to̱p no̱m-u̱ hu̱u̱b-u̱t yo̱-to̱ e̱ no̱mu̱ u̱n u̱ ho̱-u̱r re̱. ");
INSERT INTO gel_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","Faru̱k yu̱' ne̱t-tu̱ hu̱u̱te̱ ran-u̱t to̱ u̱-me̱ u̱s-gas u̱r-ke̱r e̱ da m-ho̱r-m-ho̱r u̱ do̱m-u̱ jwaak-u̱ i m-so̱m faru̱k. Tu̱msu̱ ran-tu̱ na pane̱ to̱ na tom-u̱t to̱ u̱ na karu̱nte̱ to̱ u̱-me̱ bo̱-u yat-o̱ u̱ o̱tte̱ sar m-ja u̱r-be̱b ne̱ sok u̱ Susha. ");
INSERT INTO gel_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","Se̱ Modekai yage̱ shu̱ faru̱k, m-wa u̱ cwu̱-tu̱ u̱r-faru̱k ne̱ tu̱ o̱tte̱ sha-mu̱ bu̱mu̱ u̱t-ran u̱ mu̱ pus-mo̱ ne̱, na wa'u̱ wa u̱r-to̱p du̱ yat-de̱ du̱ u̱r-faru̱k du̱ na no̱me̱ u̱ kwam-tu̱ shik tu̱ bu̱-mu̱ u̱t-rò u̱ hi-u̱r wa. Tu̱msu̱ na wa'u̱ wa to̱ggo̱ yat-ya yu̱ u̱s-ke̱e̱r yu̱ bu̱-m jaz-mo̱. Tu̱msu̱ bo̱-u̱ Susha u-be̱e̱t o̱ ku̱b jar-tu̱ u̱r-so̱. ");
INSERT INTO gel_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","Yahuda-ne̱ i o̱ me̱n-tu̱ Susha e̱ nom u̱r-so̱, tu̱msu̱ e̱ yu̱' u̱n m-sek. ");
INSERT INTO gel_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","U̱-me̱ ko̱yu̱he̱ gas-ya tu̱msu̱ u̱ ko̱-u̱-he̱ bo̱-o̱, be-du̱ bo̱r-tu̱ Faru̱k tote̱ u̱r-be̱e̱t, ne̱t-tu̱ Yahuda-ne̱ nom u̱r-so̱. Tu̱msu̱ e̱ bu̱n u̱r-mo̱ro̱g du̱ re̱-du̱ no̱m u̱t-re̱ u̱r-so̱ ne̱ tu̱msu̱ ho̱-du̱ u̱r-hure̱ ne̱. Tu̱msu̱ ne̱t-tu̱ u-dak u-tát e̱ baru̱m Yahuda-ne̱ u̱ hi-u̱r e̱, rem u̱zu̱ e̱ o̱ ho̱g-du̱ gye̱r-u̱ no̱m-u̱ Yahuda-ne̱ do̱'e̱ no̱mu̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","U̱ ho̱-du̱ o̱p u̱t-tu̱t u̱ pyat-yu̱ na foge̱ Adar (pyat-yu̱ o̱p u-yu̱r yu̱ Yahuda-ne̱) bo̱r-tu̱ faru̱k wa'e̱ ho̱-du̱ teeg u̱zu̱ na no̱m no̱m-u̱ faru̱k zu̱ye̱. U̱ gandi ho̱-du̱ u̱r-gan de̱ hu̱u̱b-u̱t yo̱-to̱ Isra-ne̱ e̱ o̱ u̱t-gwat e̱ re Yahuda-ne̱ m-gag. Se̱di no̱m-tu̱ bargu̱sse̱, Isra-ne̱ e̱ muye̱ e̱ re hu̱u̱b-u̱t yo̱-to̱ e̱ tu̱ gu̱gme̱ e̱ m-gag. ");
INSERT INTO gel_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","Yahuda-ne̱ kargu̱sse̱ hi-u̱t e̱ u̱-me̱ bo̱-u̱ e̱ u̱-me̱ gas-su̱ Faru̱k Zarake̱s o̱tte̱ u̱r-faru̱k u̱s-be̱e̱t u̱ remu̱ e̱ he̱se̱te̱ wu̱ o̱o̱ge̱ u̱ssa wa ho̱nse̱ e̱ u-be̱e̱t. Se̱di waku̱n kerge̱ u̱t-zu̱ wa no̱m ees-u̱r yo̱-de̱ u̱ e̱ ne̱ da, rem u̱zu̱ kowan o̱ u̱ ho̱g-du̱ u-gye̱r u̱ he̱e̱se̱ u̱n m-dum. ");
INSERT INTO gel_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","Tu̱msu̱ ne̱t-u̱t yat-to̱ tu̱ u̱s-gas u̱s-be̱e̱t u̱ tu̱-yat-to̱ faru̱k ne̱ u̱ ne̱t-tu̱ na o̱o̱ge̱ ho̱g-du̱ e̱ ne̱ be̱e̱t u̱-me̱ u̱s-gas u̱s-be̱e̱t e̱ se̱ge̱ Yahuda-ne̱, remu̱ u̱zu̱ e̱ o̱ ho̱g-du̱ gye̱r-u Modekai. ");
INSERT INTO gel_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","Modekai shu̱'u̱te̱ ne̱t-u̱ yat-wa u̱-me̱ pyu̱-u̱ faru̱k; na hog dim-u̱r wa u̱-me̱ u̱s-gas u̱s-be̱e̱t. Wa shu̱'u̱t ne̱t wa-u̱r-be̱b sok. ");
INSERT INTO gel_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","Se̱ Yahuda-ne̱ re u-shu̱ u̱ gandi ho̱-du̱ u̱r-gan tu̱msu̱ e̱ he̱e̱se̱ ketu̱rru̱ hu̱u̱b-u̱t yo̱-to̱ e̱ u̱ van-u̱s e̱. E̱ nom no̱m-u̱ e̱ u̱t-sa u-be̱e̱t u̱ hu̱u̱b-u̱t yo̱-to̱ e̱ ne̱, e̱ ho̱ru̱sse̱ tu̱msu̱ e̱ hast hu̱u̱b-u̱t yo̱-to̱ e̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","U̱-me̱ Susha bo̱-u yat-o̱ u̱ o̱tte̱ sar m-ja u̱r-be̱b ne̱ sok, Yahuda-ne̱ ho u̱t-ne̱t u̱t-ko̱k u̱t-tan 500. ");
INSERT INTO gel_vpl VALUES ("ET9_7","018_9_7","EST","9","7","7","U̱ te̱k-u̱ ne̱t-tu̱ e̱ ho̱ye̱ u̱ dame̱ u̱ yaag-u̱ Haman ne̱. Dim-u̱t e̱ o̱o̱ge̱ Parasadata, Dafon, Asapata, ");
INSERT INTO gel_vpl VALUES ("ET9_8","018_9_8","EST","9","8","8","Porata, Adariya, Aridata, ");
INSERT INTO gel_vpl VALUES ("ET9_9","018_9_9","EST","9","9","9","Paramasata, Arisayi, Aridayi, u̱ Bayizata, ");
INSERT INTO gel_vpl VALUES ("ET9_10","018_9_10","EST","9","10","10","yaag o̱p i Haman wa'-u̱ Hamedata, hu̱u̱b-u̱ yo̱-o̱ Yahuda-ne̱. Se̱di e̱ kabu̱g cwu̱-u̱t u̱n da. ");
INSERT INTO gel_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","Se̱ na waru̱ faru̱k tat-u̱ ne̱t-tu̱ na ho̱ye̱ u̱-me̱ bo̱-u Susha u̱ o̱tte̱ sar u̱ m-ja u̱r-be̱b ne̱ sok u̱ gandi ho̱-u̱r re̱. ");
INSERT INTO gel_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","Se̱ faru̱k zu̱ U-re̱n Esta, <<Yahuda-ne̱ ho̱o̱g u̱t-ne̱t u̱t-ko̱k u̱t-tan 500 u̱-me̱ bo̱-u̱ Susha u̱ o̱tte̱ sar u̱ m-ja u̱r-be̱b ne̱ sok u̱ war-o̱, u̱ dame̱ yaag-u̱ Haman ne̱ o̱p. U̱ da-o̱ du̱ u̱n nomte̱ iya u̱ ane̱ war-o̱, ¿re̱-o̱ de̱te̱ u̱t-shu̱'u̱t u̱ gas-su̱ kuse̱ ne̱? Se̱di da-o̱, ¿Yan-o̱ kuse̱ u̱ bo̱ u̱t-sa? Yan-o̱ ko̱n-u̱s ró tu̱msu̱ me̱ no̱mu̱ bo̱ o̱.>> ");
INSERT INTO gel_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","Esta shu̱s wa zu̱, <<A mu̱ne̱ zu̱ no̱mu̱g faru̱k u̱r-zwar, ya' Yahuda-ne̱ i o̱o̱ge̱ u̱-me̱ Susha u̱r-ke̱r u-sot tu̱msu̱ e̱ no̱m no̱m-u̱ bo̱ zu̱ na no̱m. Bo̱ ya' u̱r-ke̱r u̱zu̱ birig-tu̱ ya'ag-u̱ Haman o̱p na su̱rgu̱sse̱ to̱ u-kan.>> ");
INSERT INTO gel_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","Se̱ faru̱k ees, na wu̱' u̱r-do̱nse̱ u̱-me̱ Susha. Se̱ u̱n su̱rgu̱sse̱ biru̱k-tu̱ ya'ag-u̱ Haman o̱p. ");
INSERT INTO gel_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","Se̱ Yahuda-ne̱ i me̱ Susha e̱ karu̱g u̱r-be u̱r-gan u̱ ho̱-du̱ o̱p u̱t-nas u̱ pyat-yu̱ na foge̱ Adar (pyat-yu̱ o̱p u-yu̱r yu̱ Yahuda-ne̱) tu̱msu̱ e̱ sur m-ho̱ ne̱t-ne̱ u̱t-ko̱k u̱t-tu̱t 300, tu̱msu̱ e̱ kabu̱g kwu̱m-u̱t u̱n da. ");
INSERT INTO gel_vpl VALUES ("ET9_16","018_9_16","EST","9","16","16","Da tase̱ tu̱msu̱, Yahuda-ne̱ i kuse̱ u̱ gas-u̱ faru̱k o̱tte̱ tu̱msu̱ e̱ karu̱g u̱ remu̱ e̱ guut hi-u̱r e̱ u̱ remu̱ e̱ kum-u̱t u̱r-hure̱ du̱gu̱-du̱ hu̱u̱b-u̱t yo̱-to̱ e̱. U̱n ho ne̱t-ne̱ u̱t-zo̱ngu u̱t-shik u̱t-tu̱t u̱ o̱p u̱t-tan 75,000, se̱di u̱n tamu̱g no̱m-tu̱ u̱t-kom-u̱ u̱n da. ");
INSERT INTO gel_vpl VALUES ("ET9_17","018_9_17","EST","9","17","17","Na no̱mu̱g iya u̱ gas-u̱ o̱ u-be̱e̱t tu̱msu̱ u̱ ho̱-du̱ o̱p u̱t-tu̱t u̱ pyat-yu̱ na foge̱ Adar (pyat-yu̱ o̱p u-yu̱r yu̱ Yahuda-ne̱) tu̱msu̱ ho̱-du̱ o̱p u̱t-nas se̱ u̱n hure̱ u̱n muude̱ ho̱-du̱ re̱-du̱ no̱m u̱t-re̱ u̱ ho̱-du̱ u̱r-so̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","Yahuda-ne̱ i o̱o̱ge̱ u̱-me̱ Susha, iya tu̱msu̱, e̱ karu̱g u̱ ho̱-du̱ o̱p u̱t-tu̱t u̱ ho̱-du̱ u̱t-o̱p u̱t-nas ne̱, tu̱msu̱ iya u̱ ho̱-du̱ o̱p u̱t-tan u̱n hure̱ se̱ u̱n muut ho̱-u̱r re̱ ho̱-du̱ u̱r-so̱ u̱ re̱-du̱ no̱m-u̱t-re̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","O̱ wa'e̱ Yahuda-ne̱ i o̱o̱ge̱ shu̱'u̱t u̱-me̱ bo̱-tu̱ u̱r-do̱g e̱ ship-u̱t ho̱-du̱ o̱p u̱t-nas u̱ pyat-yu̱ na foge̱ Adar (pyat-yu̱ o̱p u-yu̱r yu̱ Yahuda-ne̱) de̱ shu̱'u̱t ho̱-du̱ u̱r-so̱ u̱ ho̱-du̱ re̱-du̱ no̱m u̱t-re̱ ne̱, tu̱msu̱ de̱ shu̱'u̱t ho̱-du̱ u-nya u̱du̱ o̱ru̱-u̱t u̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","Modekai pu̱n no̱m-u̱t to̱ wa tomot u̱t-ran u̱du̱ Yahuda-ne̱ i o̱o̱ge̱ m-ra u̱t-mo̱r ne̱, u̱-me̱ gas-u̱ Faru̱k Zarake̱s o̱tte̱ u̱r-faru̱k u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","Wa waru̱ u̱n u̱zu̱ e̱ nom u̱r-so̱ u̱ ho̱-du̱ o̱p u̱t-nas u̱ ho̱-du̱ o̱p u̱t-tan ne̱ u̱ pyat-yu̱ na foge̱ Adar (pyat-yu̱ o̱p u̱t-yu̱r yu̱ Yahuda-ne̱) ko̱yu̱he̱ hak-ya. ");
INSERT INTO gel_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","Wa waru̱ Yahuda-ne̱ u̱zu̱ e̱ no̱m so̱-du̱ ho̱-u̱t to̱ u̱ re̱-du̱ no̱m u̱t-re̱ ne̱ u̱r-so̱ ne̱ tu̱msu̱ u̱ no̱mu̱ o̱r-u̱t e̱ ne̱ u-nya u̱ no̱m u̱t-re̱ ne̱ tu̱msu̱ e̱ no̱mu̱ i o̱ u̱-me̱ u̱r-ko̱b u-nya. Din-de̱ de̱ o̱o̱ge̱ mo̱ro̱g-du̱ u̱r-so̱ da-u̱ Yahuda-ne̱ kume̱ u̱r-hure̱ du̱gu̱-du̱ hu̱u̱b-u̱t yo̱-to̱ e̱. ");
INSERT INTO gel_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","Se̱ Yahuda-ne̱ ees u̱zu̱ e̱ do̱'e̱ re̱-du̱ u-shu̱ u̱t-no̱m iya ko̱yu̱he̱ hak-ya u̱ka e̱ taktu̱n, u̱ no̱m-du̱ no̱m-u̱ Modekai panu̱ e̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("ET9_24","018_9_24","EST","9","24","24","Haman wa'-u̱ Hamedata ne̱t-u̱ Agagite, hu̱u̱b-u̱ yo̱-o̱ Yahuda-ne̱, wa no̱ng dorog-su̱ no̱mu yo̱-o̱ u̱du̱ Yahuda-ne̱ u̱zu̱ na ho̱ru̱sse̱ e̱. Tu̱msu̱ na hast e̱ u̱ ho̱-du̱ e̱ cine̱ u̱zu̱ na ho̱ru̱sse̱ Yahuda-ne̱ u̱ fu̱n-yu̱ gwu̱n-du̱ u-gwe̱mbi (yu̱ na foge̱ Purim). ");
INSERT INTO gel_vpl VALUES ("ET9_25","018_9_25","EST","9","25","25","Se̱di da-u̱ Esta haane̱ u̱ shu̱ faru̱k, se̱ faru̱k pu̱n u̱t-ran u̱zu̱ no̱mu yo̱-o̱ Haman dorge̱ no̱mu̱ Yahuda-ne̱ u̱ o̱ mu u̱-do̱mu̱ hi-u̱r wa. Se̱ Haman u̱ ya'ag-u̱ wa ne̱ na su̱rgu̱sse̱ e̱ u̱-do̱m u-kan. ");
INSERT INTO gel_vpl VALUES ("ET9_26","018_9_26","EST","9","26","26","Rem iya o̱ wu̱te̱ na fog-u̱t ho̱-tu̱ u̱r-so̱ to̱ Purim. Yahuda-ne̱ fak ho̱-u̱t to̱ Furim, rem u̱zu̱ Fur de̱ o̱ gom-du̱ gwu̱n-du̱ u-gwe̱mbi. U̱ remu̱ no̱m-u̱ u̱n hyane̱ ne̱ tu̱msu̱ u̱ no̱m-u̱ kume̱ u̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","Se̱ Yahuda-ne̱ i o̱o̱ge̱ u̱-me dak-u o̱ be̱e̱t u̱n ees u̱zu̱ u̱n kab ho̱-u̱t to̱ to̱ shu̱'u̱t u-kim u̱du̱ u̱n m-ha ya'ag-u̱ u̱n ne̱ u̱ dame̱ i barme̱ Yahuda-ne̱. U̱n ku̱b u̱zu̱ u̱n zaaru̱ yagu̱ no̱m-du̱ so̱-du̱ ho̱-tu̱ u̱t-yu̱r u̱ to̱ ko̱yu̱he̱ hak-ya da, u̱ka na iiste̱ e̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","Tunto̱ ho̱-to̱ na do̱'e̱ baksu̱ to̱ tu̱msu̱ na shipto̱ du̱gu̱ uno̱ cara-o̱ m-ha o̱ku̱n cara-o̱ tu̱msu̱ ko̱-u̱-he̱ bo̱-o̱, tu̱msu̱ u̱ ko̱yu̱he̱ gas-ya m-ha bo̱-u̱t yat-to̱ ne̱. Tunto̱ ho̱-tu̱ Purim to̱ na zaar u̱ yagu̱ no̱m-du̱ so̱-du̱ ho̱-u̱t to̱ u̱du̱ Yahuda-ne̱ da, ko̱ u̱zu̱ u̱ ho̱-u̱t to̱ ka u̱t-to̱ u̱-me̱ ko̱-u̱t u̱n. ");
INSERT INTO gel_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","U-re̱n Esta, gwu̱p-u̱ Abiher, u̱ dame̱ Modekai ne̱ ne̱t-u̱ Yahuda, e̱ pu̱n u-ran u̱ o̱tte̱ u̱r-be̱b so̱k u̱ remu̱ na egu̱sse̱ ran u-yu̱ru̱mse̱ u̱ mo̱ttu̱ mo̱ro̱g-du̱ Purim ne̱. ");
INSERT INTO gel_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","Se̱ Modekai tomot u̱t-ran m-ha u̱du̱ Yahuda-ne̱ u̱-me̱ gas-su̱ Faru̱k Zarake̱s o̱tte̱ u̱r-faru̱k u-ko̱k u-gan u̱ kwaz-tu̱ u̱t-yu̱r u̱s-ta'e̱r 127 u̱-me̱ ran-u̱t to̱ na waru̱ Yahuda-ne̱ gom-tu̱ ru̱s-du̱ jab-u̱ shu̱'u̱t-du̱ m-yar ne̱. ");
INSERT INTO gel_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","Remu̱ na egu̱sse̱ ho̱-tu̱ Purim u̱ da-u̱ kame̱, u̱ka Modekai ne̱t-u̱ Yahuda u̱ U-re̱n Esta yaste̱ u̱n u̱t-bo̱r, u̱ka tu̱msu̱ u̱n egu̱sse̱ hi-du̱ war-e̱ u̱ ko̱-u̱t u̱n ne̱ u̱zu̱ u̱n ship ho̱-tu̱ u-swaat u̱ ho̱-tu̱ namu̱ jab ne̱. ");
INSERT INTO gel_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","Se̱ bo̱r-tu̱ Esta pane̱ u̱ mo̱ttu̱ so̱-du̱ Purim ne̱, tu̱msu̱ na cin to̱ u̱-me̱ ran-u̱ u̱r-cu̱n. ");
INSERT INTO gel_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","Faru̱k Zarake̱s wu̱' na to̱p shik-u̱ tar u̱-me̱ gas-su̱ wa o̱tte̱ u-be̱e̱t, tu̱msu̱ m-ha i o̱ shu̱'u̱t u̱ dak-tu̱ o̱o̱ge̱ u̱-te̱k m-sa e̱ top shik-u̱ tar ko̱'e̱. ");
INSERT INTO gel_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","A-u̱s-ge̱n Faru̱k panu̱g no̱m-u̱t yat-to̱ tu̱ Faru̱k no̱me̱ u̱ da-u̱ wa o̱o̱ge̱ u̱r-faru̱k. Tu̱msu̱ e̱ pu̱n tat-u̱ re̱ u-shu̱ Modekai u̱ka wa shu̱'u̱te̱ remu̱ zu̱ Faru̱k yaag wa m-sek. A-u̱s-ge̱n ne̱ pu̱n no̱m-u̱t to̱ u̱t-be̱e̱t u̱-me̱ u̱t-ran u̱ mo̱ttu̱ no̱mu̱ Faru̱k-tu̱ Midiya u̱ Pasiya ne̱ no̱me̱. ");
INSERT INTO gel_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","Modekai ne̱t-u̱ Yahuda, wa o̱o̱ge̱ wu̱ do̱rne̱ Faru̱k Zarake̱s u̱r-be̱b. U̱-me̱ ne̱t-tu̱ Yahuda-ne̱ u̱n yu̱' wa m-ze̱g. Modekai shu̱'u̱t ne̱t-u̱ yat-wa u̱-me̱ Yahuda-ne̱, rem u̱zu̱ wu̱n no̱ng m-ank u̱ remu̱ ho̱g-du̱ u̱r-zwar du̱ ne̱t-u̱t wu̱n tu̱msu̱ wu̱n nom u̱s-rem u̱ remu̱ shu̱'u̱t-du̱ m-yar u̱ Yahuda-ne̱ be̱e̱t.");
INSERT INTO gel_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Rem-u̱s Yawe haagu̱n u̱du̱ Yunana wa'-u̱ Amitai. ");
INSERT INTO gel_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","<<Yu̱ne̱ bo̱ do̱'e̱ u̱ Neneba bo̱-u yat-o̱, bo̱ waru̱ u̱n rem-u̱s ri, remu̱ no̱m-u̱t yo̱-to̱ u̱n teegu̱n u̱du̱ ri.>> ");
INSERT INTO gel_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Se̱di Yunana gu̱gu̱m. Wa som u̱ irig m-ha bo̱-u yat-o̱ u̱ na foge̱ Jopa tu̱msu̱ wa top shik, se̱ wa irig u̱-me̱ hat-u yat-ya m-ha bo̱-u̱ Tarshis. Wa aru̱k remu̱ u̱zu̱ wa o̱o̱g u̱ssa wa so̱m du̱gu̱-du̱ Yawe. ");
INSERT INTO gel_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","U̱n o̱ te̱k u̱r-no̱k, Yawe to̱ko̱n mya-mu̱ u̱r-be̱b u̱-me̱ m-sa, hat-yu̱ u̱t-sa u̱t-u̱ku̱s. ");
INSERT INTO gel_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","A-nak-du̱ hat-u yat-ya hog u-gye̱r sok. Ko̱wan hu̱ ko̱n-du̱ ru̱-u wa. U̱n guns cwu̱-u̱t u̱n u̱-me̱ m-sa remu̱ hab-du̱ m-no hat-u yat-ya. Se̱di Yunana o̱ u̱-me̱ dak-u̱ hat-u yat-ya wa roog-mu̱ ho̱o̱g wa. ");
INSERT INTO gel_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Da-u o̱ yu̱-Yat-ya yu̱ hat-u yat-ya haan u̱du̱ Yunana wa zu̱, <<¿Remu̱ yan-o̱ bo̱ o̱tte̱ m-roog? Yu̱ne̱! Bo̱ ko̱n ru̱-u ró, ko wa ho̱gu̱ o̱n-u̱r in, wa u̱ku̱r in du̱gu̱ m-mar.>> ");
INSERT INTO gel_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Ku̱na a-nak-du̱ hat-u yat-ya ne̱ zu̱tte̱, <<Haanu̱n, in gunu̱n u-gwe̱mbi remu̱ na nu̱pu̱t wa-u̱t-ba'as.>> U̱ da-u o̱ u̱n nom u-gwe̱mbi, u̱n nu̱p u̱zu̱ Yunana wa, wa-u̱t-ba'as. ");
INSERT INTO gel_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","U̱n zu̱ wu̱n, <<U̱ da-o̱ waru̱ it. ¿Yan-o̱ bo̱ no̱me̱ na o̱tte̱ swadu̱ u̱r-ko̱b? ¿Yan-o̱ o̱ ank-m ró? ¿He̱ne̱ bo̱ rwu̱tu̱n ne̱? ¿Yan-o̱ dim-du̱ bo̱-u̱ bo̱ rwu̱tu̱n? ¿Yan ko̱-de̱ bo̱ rwu̱tu̱n?>> ");
INSERT INTO gel_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Yunana zu̱ u̱n, <<Me̱ ne̱t-u̱ Isra wa, tu̱msu̱ me̱ wa doru̱ Yawe wa, Ru̱-u̱ do̱m u-ru̱, wu̱ no̱me̱ m-sa u-dak ne̱.>> ");
INSERT INTO gel_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Tu̱msu̱ wa waru̱ u̱n, u̱zu̱ wa o̱ u̱ so̱m-du̱ Yawe. Da-u o̱ gye̱r-u̱ ship ne̱t-u̱t to̱, u̱n zu̱ wu̱n, <<¿Remu̱ yan-o̱ bo̱ nomte̱ iya?>> ");
INSERT INTO gel_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Yu̱-u̱ m-mya u̱-me̱ m-sa sur u̱r-be̱b sok, u̱n zu̱ wu̱n, <<¿Yan-o̱ it do̱'e̱ no̱mu̱ bo̱ u̱ yu̱-u̱ m-mya yakte̱ no̱mu̱ in u-gwu̱z?>> ");
INSERT INTO gel_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Yunana zu̱ u̱n, <<U̱m nak yu̱-u̱ m-mya haagu̱n u̱-do̱mu̱ no̱ u̱ remu̱ ba'as-u̱t ri. Kabu̱n me̱ no̱ guns me̱ u̱-me̱ m-sa ko̱-uyan o̱ u̱t-re̱s.>> ");
INSERT INTO gel_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Se̱di u̱n waste̱ u̱ rem-u̱s Yunana ne̱ da. A-nak-du̱ hat-u yat-ya ne̱ hu̱ mat-du̱ u̱s-hund e̱ teet kit m-sa, remu̱ be̱b-du̱ m-mya re u-shu̱ m-swu̱r u̱n kerge̱ da. ");
INSERT INTO gel_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","U̱n nom u̱s-kan u̱du̱ Yawe, u̱n zu̱, <<Yawe u-Ru̱, it ko̱no̱g bo̱, a-bo̱ yage̱ it mar remu̱ kab-du̱ fat-du̱ ne̱t unwa da. Yawe u-Ru̱, a-bo̱ ship it a-u̱t-ba'as remu̱ kab-du̱ fat-du̱ wa-za-u̱t-ba'as unwa da. Se̱di no̱m no̱m-u̱ citu̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","U̱n ku̱b Yunana, u̱n guns wa u̱-me̱ m-sa. Da-u̱ u̱n gu̱nse̱ Yunana, yu̱-u̱ m-mya res te̱k. ");
INSERT INTO gel_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Da-u o̱, ne̱t-tu̱ hog gye̱r-u̱ Yawe sok. U̱n no̱m este̱du̱ u̱s-rem u̱du̱ Yawe, tu̱msu̱ u̱n nom u̱r-to̱o̱g u̱du̱ wa. ");
INSERT INTO gel_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Da-u̱ u̱n gunse̱ Yunana m-sa, Yawe to̱mo̱n jan-u yat-ya, ya toros Yunana. Yunana shu̱'u̱t u̱-me̱ me̱n-tu̱ u-jan u̱t-ho̱ u̱t-tu̱t. ");
INSERT INTO gel_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Da-u̱ wa o̱o̱ge̱ u̱-me̱ me̱n-tu̱ u-jan, Yunana no̱ng u̱s-to̱o̱g u̱du̱ Yawe u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Wa zu̱, <<U̱m fak Yawe u̱ te̱k-u̱ swadu̱ u̱r-ko̱b u̱ ri, tu̱msu̱ wa shu̱s to̱o̱g-u̱s ri. U̱-me̱ be-du̱ u̱r-shu̱'u̱t du̱ marimari ne̱, tu̱msu̱ bo̱ hog ko̱n-u̱s ri. ");
INSERT INTO gel_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Bo̱ gwu̱nu̱g me̱ u̱-me̱ m-bu̱ mu̱ u̱r-ra, u̱ te̱k-u̱ dak-u̱ m-sa. U̱m o̱ u̱-me̱ m-bu̱, tu̱msu̱ jwak m-bu̱, re̱e̱g be̱b-u̱r ri. ");
INSERT INTO gel_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","U̱m zu̱u̱g, <Ko̱ bo̱ hastu̱ me̱ du̱gu̱-du̱ ró, ko ba shu̱'u̱te̱ iya, me̱ u̱t-sur m-hyan pyu̱-u̱ u-he̱n u̱ ró.> ");
INSERT INTO gel_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Bu̱-mu̱ re̱e̱g me̱ u̱r-hi, bu̱-mu̱ m-sa taku̱ste̱ me̱ u-be̱e̱t. Gwa-su̱ me̱ m-sa taku̱ste̱ hi-u̱r ri. ");
INSERT INTO gel_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","U̱m yi'iste̱ u̱-ta m-sa m-te u̱ be-du̱ u̱t-ta'ar. U̱m o̱ u̱-me̱ be-du̱ marimari ne̱. Yawe, u-Ru̱ u̱ ri, bo̱ wa ruutu̱ me̱ u̱-me̱ u-kub. ");
INSERT INTO gel_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","<<Yawe, da-u̱ u̱m ho̱ge̱ fat-u̱r ri o̱ m-rwu̱; tu̱msu̱ u̱m nom u̱s-to̱o̱g u̱du̱ ró, Tu̱msu̱ bo̱ hog ko̱n-u̱s ri u̱-me̱ be-du̱ u-he̱n u̱ ró. ");
INSERT INTO gel_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","<<Ne̱t-tu̱ o̱o̱ge̱ no̱m-du̱ u̱t-huuk m-gir, e̱ gu̱gu̱mte̱ o̱n-du̱ u̱ cwan-tu̱ u-Ru̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Se̱di me̱, u̱ nu-u̱ u̱t-vam. U̱m de̱ no̱m-du̱ to̱o̱g u̱du̱ ró. Me̱ shu̱su̱ este̱du̱ u̱s-rem u̱ ri, remu̱ u̱ku̱r u̱ o̱o̱n du̱gu̱ Yawe.>> ");
INSERT INTO gel_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Se̱ Yawe wu̱' jan-yu̱ gwa'u̱n Yunana u̱-kit m-sa. ");
INSERT INTO gel_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Rem-u̱s Yawe sur m-haan u̱du̱ Yunana u-yu̱ru̱mse̱. Wa zu̱, ");
INSERT INTO gel_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","<<Yu̱ne̱ bo̱ ha u̱ Neneba bo̱-u yat-o̱, bo̱ waru̱ ne̱t-tu̱ o̱ u̱ku̱n rem-su̱ u̱m waru̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Yunana er rem-u̱s Yawe, se̱ wa yu̱ne̱ wa hu̱ u̱ Neneba. Bo̱-u̱ Neneba o̱o̱g u̱ yat-o̱ o̱ sok, se̱ ne̱t no̱ng m-roog u̱t-tu̱t kanda wa hyan bo̱-u o̱ u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Ho̱-du̱ Yunana cwaye̱ u̱-me̱ bo̱-u̱ Neneba, wa nom u̱r-hoot u̱r-gan. Se̱ wa he̱e̱se̱ no̱m-du̱ u̱r-do̱nse̱ u̱zu̱, <<Kwu̱ku̱s m-roog u̱t-shik u̱t-yu̱r u̱ na haatu̱n u̱ ho̱-du̱ bo̱-u̱ Neneba.>> ");
INSERT INTO gel_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Ne̱t-tu̱ Neneba hog rem-u̱s u-Ru̱, e̱ dor se̱. E̱ nom u̱r-do̱nse̱ kowan u̱ no̱m u-swaat, iya o̱ hen u̱ ne̱t-u̱t wu̱to̱ u̱ ya'ag-u̱ re̱k-e̱, kowan nom u-swaat, tu̱msu̱ e̱ wu̱ cwu̱-tu̱ ko̱se̱-du̱ namu̱ jab remu̱ ba'as-u̱t u̱n. ");
INSERT INTO gel_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Da-u̱ faru̱k-u̱ Neneba ho̱ge̱ rem-su̱ Yunana ware̱, wa yu̱ne̱ du̱gu̱ pora-du̱ u̱r-faru̱k-u̱ wa. Wa wu̱' cwu̱-tu̱ ko̱se̱ namu̱ jab. Wa shu̱'u̱t u-dak u̱ do̱m m-cwa remu̱ ko̱ste̱ u̱zu̱ wa yakke̱ u̱t-ba'as. ");
INSERT INTO gel_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","U̱ da-u o̱, faru̱k wu̱' na no̱m u̱r-do̱nse̱ u̱-me̱ bo̱-u wa u-be̱e̱t u̱zu̱: Du̱gu̱ nu-u faru̱k-u̱ i-yate̱ wa ne̱. <<Ana yage̱ ne̱t ko̱ u-bisa o̱ rak no̱m u̱t-re̱ da, a waku̱n u̱ re no̱m u̱t-re̱ ko̱ wa swa m-bu̱ da. ");
INSERT INTO gel_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Yage̱ ne̱t, u̱t-bisa ne̱ u̱ wa' kus-tu̱ ko̱se̱ namu̱ jab. Tu̱msu̱ yage̱ ko̱wan u̱ fag u-Ru̱ m-ho̱r-m-ho̱r. Ko̱wan byu̱ru̱n du̱gu̱ fu̱n-u̱s yo̱-se̱ wa, u̱ yu̱nu̱s-du̱ jab-su̱ u̱t-ne̱t ne̱. ");
INSERT INTO gel_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Jiya Ru̱-o̱ u̱t-ho̱g u̱r-o̱n, wa toros jab-u̱ wa remu̱ ba'as-u̱t in, wa yage̱ mo̱ttu̱ ho̱-du̱ in.>> ");
INSERT INTO gel_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Da-u̱ Ru̱-u̱ hyane̱ u̱zu̱ u̱n yakke̱ u̱t-ba'as u̱ remu̱ yage̱-du̱ no̱m-du̱ no̱m-u̱t yo̱-to̱ u̱n, se̱ wa hog o̱n-u̱r u̱n. Wa yage̱ mo̱ttu̱ ho̱-du̱ u̱n tu̱ wa o̱o̱ge̱ wa zo̱ngte̱. ");
INSERT INTO gel_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Yunana hog u̱s-ryab sok, remu̱ o̱n-du̱ Ru̱-u̱ ho̱ge̱ u̱ do̱m-u̱ ne̱t-tu̱ Neneba. ");
INSERT INTO gel_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Yunana nom u̱s-to̱o̱g u̱du̱ Yawe wa zu̱, <<¿Yawe, inya o̱ u̱m zu̱tte̱ da-u̱ u̱m o̱o̱ge̱ u̱ bo̱-u ri? De̱ wu̱te̱ u̱m somot m-ho̱r m-ho̱r m-ha u̱ Tarshis. Ko̱ ba u̱m nape̱ u̱zu̱ bo̱ wa-u-nya wa tu̱msu̱ Ru̱-u̱ u̱r-o̱n, tu̱msu̱ wa za ho̱r-mu̱ u̱s-ryab, bo̱ o̱ u̱t-cwan ne̱ tu̱ baru̱mte̱ da, tu̱msu̱ ko mu̱ne̱ bo̱ o̱ zo̱ngi zo̱ngi bo̱ hast jab-u̱ ró du̱gu̱ hatu̱n swadu̱ u̱r-ko̱b. ");
INSERT INTO gel_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Yawe, kab fat-u̱r ri da-o̱, rem u̱zu̱ ze̱k u̱r-zwar u̱m mar.>> ");
INSERT INTO gel_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Yawe zu̱, <<¿No̱ng u̱r-zwar bo̱ no̱m u̱s-ryab u̱ mo̱t-u̱t tun-to̱?>> ");
INSERT INTO gel_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Yunana aru̱k m-rwu̱ du̱gu̱ me̱ u-bo̱ wa do̱'e̱ wa shu̱'u̱t u̱ de̱ku̱n be-de̱ u-do̱m u-bo̱ ne̱. Wa no̱m de̱ku̱n rimpa-de̱ remu̱ wa kum-u̱t m-yara. Wa shu̱'u̱t u̱ me̱, wa hyen-u̱t no̱m-tu̱ Ru̱-u̱ de̱ no̱mu̱ bo̱-u̱ Neneba. ");
INSERT INTO gel_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Da-u̱ wa o̱o̱ge̱ u̱-me̱ u̱r-rimpa, Yawe u-Ru̱ wu̱' yaku̱n ku̱wu̱t-du̱ u̱t-ran apu̱n remu̱ ya habte̱ wu̱n du̱ng-mu̱ u̱r-hi, ya rogom ya no̱mu̱ wu̱n m-yara. Yunana nom u̱r-so̱ sok remu̱ ku̱wu̱t-du̱ u̱t-ran ya. ");
INSERT INTO gel_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Da-u̱ is gase̱ u̱r-wu̱n te̱p te̱p, Ru̱-u to̱mo̱n u̱t-zwa, tu̱ tu̱'se̱ ku̱wu̱t-du̱ u̱t-ran ya, ya gu̱u̱s. ");
INSERT INTO gel_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Da-u̱ ho̱-du̱ rwu̱ne̱, Ru̱-u̱ to̱mo̱n mya-m yat-mo̱ du̱gu̱ u-do̱m. Ho̱-yu̱ gu̱p Yunana u̱r-hi har wa o̱o̱g u̱ssa u̱t-byu̱z, wa o̱ u̱t-sa m-mar. Se̱ wa zu̱, <<Ze̱k u̱r-zwar u̱m m-mar u̱zu̱ u̱m fot ne̱.>> ");
INSERT INTO gel_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Ru̱-u̱ zu̱ Yunana, <<¿No̱mu̱g bo̱ u̱r-zwar bo̱ no̱m u̱s-ryab u̱ remu̱ mar-mu̱ ku̱wu̱t-du̱ u̱t-ran de̱?>> Yunana zu̱, <<Kamu̱g u̱m no̱m u̱s-ryab, ryab-su̱ te m-mar.>> ");
INSERT INTO gel_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Yawe zu̱, <<¿Kamu̱g bo̱ ho̱g o̱n-du̱ ku̱wu̱t-du̱ u̱t-ran yu̱ o̱ zu̱ bo̱ kawe̱ ya da? Bo̱ wa'e̱ tu̱msu̱ ya ne̱n-u̱t da. Ya apku̱n u̱ gyu̱p-mu̱ m-gan ya mu̱r u̱ mo̱ko̱n gyu̱p-mo̱. ");
INSERT INTO gel_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","¿Kamu̱g u̱m ho̱g o̱n-du̱ Neneba bo̱-u yat-o̱ da? Bo̱-u̱ o̱tte̱ ya'ag i ze̱ge̱ u̱t-zo̱ngu u-ko̱k u̱ kwaz-du̱ u̱r-gan (120,000) i nape̱ no̱m-u so̱-o̱ u̱ yo̱-o̱ ne̱ da. Tu̱msu̱ bisa-tu̱ o̱ro u-tát u̱-me bo̱-u o̱. ¿Ku̱mge̱ u̱m ho̱g o̱n-du̱ bo̱-u o̱ da?>>");
INSERT INTO gel_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tun-to̱ to̱ dim-tu̱ u̱so-tu̱ u̱so-u̱t Ye̱so̱ Kiristi, wu̱ rwu̱ne̱ du̱gu̱ ko̱-u̱r Dawuda u̱ Ibrahi ne̱. ");
INSERT INTO gel_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahi wa o̱ye̱ u̱so-u Ishaku. Ishaku u̱so-u Yakubu. Yakubu u̱so-u Yahuda, u̱ hu̱u̱b-tu̱ u̱r-matu̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda u̱so-u Pe̱res u̱ Zera (ino-u e̱ wa o̱ye̱ Tamar). Pe̱res u̱so-u Hezu̱ron. Hezu̱ron u̱so-u Ram. ");
INSERT INTO gel_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram u̱so-u Aminadab. Aminadab u̱so-u Nasho̱n. Nashon u̱so-u Saru̱mo̱n. ");
INSERT INTO gel_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saru̱mo̱n u̱so-u Boaz (wu̱ ino-u e̱ wa o̱ye̱ Rahab). Boaz u̱so-u Obida (ino-u e̱ wa o̱ye̱ Rutu). Obida u̱so-u Jesse. ");
INSERT INTO gel_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse u̱so-u Dawuda Faru̱k. Dawuda u̱so-u Suremanu (wu̱ ino-u wa o̱o̱ge̱ ne̱ta Yuriya). ");
INSERT INTO gel_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Suremanu u̱so-u Rehobowam. Rehobowam u̱so-u Abija. Abija u̱so-u Asa. ");
INSERT INTO gel_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa u̱so-u Jehoshapat. Jehoshapat u̱so-u Yoram. Yoram u̱so-u Uziya. ");
INSERT INTO gel_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziya u̱so-u Jotam. Jotam u̱so-u Ahaz. Ahaz u̱so-u Hezekiya. ");
INSERT INTO gel_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiya u̱so-u Manase. Manase uso-u E̱mo̱s. E̱mo̱s u̱so-u Josiya. ");
INSERT INTO gel_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Tu̱msu̱ Josiya u̱so-u Jekoniya u̱ hu̱u̱b-tu̱ u̱r-matu̱ wa ne̱, u̱ da-u̱ karma-ne̱ i Babira kabe̱ ne̱t-tu̱ Isra m-ha u̱du̱ m-to̱k u̱ dak-u̱ Babira. ");
INSERT INTO gel_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Da-u̱ na kabu̱ e̱ m-ha u̱du̱ m-to̱k Babira, Jekoniya wa o̱ u̱so-u She̱yartiye̱r. She̱yartiye̱r u̱so-u Zerubaber. ");
INSERT INTO gel_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubaber u̱so-u Abihuda. Abihuda u̱so-u Eriyakim. Eriyakim u̱so-u Azo̱r. ");
INSERT INTO gel_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azo̱r u̱so-u Zado̱k. Zado̱k u̱so-u Akim. Akim u̱so-u Eriyuda. ");
INSERT INTO gel_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eriyuda u̱so-u Eriyaza. Eriyaza u̱so-u Matana. Matana u̱so-u Yakubu. ");
INSERT INTO gel_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Tu̱msu̱ Yakubu wa o̱ye̱ u̱so-u Yusuhu, campa Me̱ri. Me̱ri mate̱ Ye̱so̱ wu̱ na foge̱ Kiristi. ");
INSERT INTO gel_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Du̱gu̱ da-u Ibrahi u̱ do̱'e̱ da-u Dawuda sara-to̱ o̱p u̱t-nas, du̱gu̱-du̱ Dawuda u̱ do̱'e̱ da-u̱ na kabe̱ Isra-ne̱ m-to̱k u̱ Babira, sara-to̱ o̱p u̱t-nas, du̱gu̱ ku̱n u̱ do̱'e̱ da-u Ye̱so̱ Kiristi sara-to̱ o̱p u̱t-nas. ");
INSERT INTO gel_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Inya o̱ na mu̱tte̱ Ye̱so̱ Kiristi. Da-u̱ a u̱r-matu̱ Me̱ri eese̱ yadu̱ gu̱-u̱r Me̱ri u̱du̱ Yusuhu, se̱di kanda na ga-gu̱ u̱n u̱r-gu̱ na bit Me̱ri u̱t-me̱n ne̱ du̱gu̱-du̱ Yar-u u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ko̱ ba o̱ye̱ u̱zu̱ Yusuhu ne̱t u̱r-ka wa, wa za u̱ssa wa ya' Me̱ri m-'e̱ u̱ te̱k u̱t-ne̱t da, se̱ wa dorog u̱ jab-u̱ wa, wa yagu̱ wu̱n m-yasa. ");
INSERT INTO gel_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wa o̱ u̱ te̱k-u̱ dorog-u̱s se̱, se̱ wa-to̱m Wa-ko-uyan haan u̱du̱ ro u̱ bo', wa zu̱, <<Yusuhu wa'-u̱ Dawuda, a-bo̱ ho̱g u-gye̱r u̱ kab-du̱ Me̱ri wa shu̱'u̱t ne̱ta ró da, remu̱ zu̱ no̱mu̱ o̱ u̱ me̱n-u̱t wa du̱gu̱ Yar-u u-Ru̱ o̱. ");
INSERT INTO gel_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Wa de̱ mat-du̱ ya-du̱ u̱r-campa, na do̱'e̱ te̱'u̱ wa u̱r-dim Ye̱so̱, remu̱ zu̱ wa de̱ u̱ku̱r ne̱t-u̱t wa du̱gu̱ ba'as-u̱t e̱.>> ");
INSERT INTO gel_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tun-to̱ no̱m-to̱ u̱t-be̱e̱t na no̱mu̱g to̱ remu̱ no̱m-tu̱ Ru̱-u̱ ware̱ Wa-warru̱ rem-su̱ u-Ru̱ Ishaya u̱zu̱, ");
INSERT INTO gel_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","<<Gwu̱p-u̱ nape̱ campa da de̱ no̱m-du̱ u̱t-me̱n, wa de̱ mat-du̱ yadu̱ u̱r-campa na do̱'e̱ te̱ wa u̱r-dim Imanuwe̱r>> no̱mu̱ dim-u̱r re̱ o̱ye̱, <<U-Ru̱ u̱r-kot u̱ na ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Da-u̱ Yusuhu yu̱ne̱ du̱gu̱ m-roog, se̱ wa no̱m no̱mu̱ wa-to̱m u-Ru̱ zu̱ye̱ wa no̱m, wa ku̱b Me̱ri m-mu̱ u-bu, wa shu̱'u̱t ne̱ta wa. ");
INSERT INTO gel_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Se̱di wa tamu̱g m-roog u̱ wa ne̱ da se̱ da-u̱ wa mate̱ yadu̱ u̱r-campa. Yusuhu te̱'e̱ wa u̱r-dim Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ba Mari mate̱ Ye̱so̱ u̱ bo̱-u̱ Be̱tarami u̱ dak-u̱ Yahudiya, da-u̱ Here̱ o̱o̱ge̱ u̱r-faru̱k, a-nap-mu̱ re̱ge̱r-ne̱ du̱gu̱ u-do̱m e̱ rwu̱n du̱gu̱ u-do̱m e̱ do̱'e̱ u̱ Urusharima. ");
INSERT INTO gel_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","E̱ shit u̱t-ne̱t u̱zu̱, <<¿He̱ne̱ wu̱na mate̱, Faru̱k-u̱ Yahuda-ne̱? It hyanu̱g re̱ge̱r-u wa du̱gu̱ u-do̱m, it haagu̱n it no̱mu̱ wa u̱t-huuk.>> ");
INSERT INTO gel_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Da-u̱ Here̱ Faru̱k ho̱ge̱ iya se̱ jab-u̱ wa yu̱ne̱, u̱ jab-u̱ ne̱t-tu̱ Urusharima ne̱ ko̱'e̱. ");
INSERT INTO gel_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Se̱ wa fo̱g i-Yate̱ a-To̱o̱g-ne̱ be̱e̱t u̱ a-kwu̱p-du̱ u-bo̱r ne̱, wa shit u̱n, <<¿He̱ne̱ na do̱te̱ mat-du̱ Kiristi?>> ");
INSERT INTO gel_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","E̱ zu̱ wu̱n, <<U̱ Be̱tarami u̱ dak-u̱ Yahudiya, u̱ka wa-warru̱ rem-su̱ u-Ru̱ pu̱nte̱: ");
INSERT INTO gel_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","<<No̱ ne̱t-tu̱ Bo̱-u̱ Be̱tarami, u̱ dak-u̱ Yahuda, bo̱-u no̱ o̱ m-sek ne̱ sok, Remu̱ zu̱ du̱gu̱ bo̱-u no̱ na do̱te̱ kwu̱m-du̱ faru̱k wu̱ de̱ dor-tu̱ ne̱t-u̱t ri Isra-ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Here̱ fog a-nap-mu̱ re̱ge̱r-ne̱ m-yasa, wa nu̱pu̱t ko̱-uyan da-o̱ re̱ge̱r-yu̱ he̱ne̱. ");
INSERT INTO gel_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Se̱ wa tom u̱n u̱ Be̱tarami u̱zu̱, <<De̱'e̱n no̱ goot so̱k u̱r-zwar ne̱ be-du̱ na mu̱tte̱ wa'-u̱ wa. A no̱ hyanu̱ wa se̱ no̱ no̱m m-ho̱r no̱ haan no̱ waru̱ me̱, ko̱me̱ u̱m do̱'e̱ u̱m no̱mu̱ wu̱n u̱t-huuk.>> ");
INSERT INTO gel_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Da-u̱ u̱n ho̱ge̱ no̱mu̱ faru̱k ware̱ u̱n hu̱ m-ha u̱su̱ u̱n. E̱ o̱ te̱k m-ha, e̱ hyen re̱ge̱r-yu̱ u̱n hyane̱ du̱gu̱ u-do̱m. Da-u̱ e̱ hyane̱ ya, e̱ hu̱ mu̱rimmo̱, e̱ hu̱ u̱r-so̱ sok, ya hu̱ m-da u̱ shu̱ u̱n, se̱ be-du̱ ya eeste̱ u̱ be-du̱ yadu̱ o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Da-u̱ e̱ cwaye̱ u̱-me̱ u-bu, e̱ hyen u̱r-ya e̱ ino-u wa Me̱ri. Se̱ e̱ kug e̱ no̱mu̱ wa u̱t-huuk. Se̱ e̱ upus ba-u̱t e̱, e̱ no̱mu̱ wu̱n u-nya' u̱t-no̱m u-tát u̱ ta'ar-tu̱ m-baku̱t ne̱ u̱ no̱m mu̱ wu̱s u-haku̱n ne̱, mu̱ na foge̱ <<farakanse̱,>> m-dap ne̱ mu̱ wu̱s u-haku̱n mu̱ na foge̱ <<mur.>> ");
INSERT INTO gel_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Remu̱ zu̱ Ru̱-u̱ baag u̱ no̱ngu̱ u̱n u̱t-him u̱ bo' u̱zu̱ a u̱n mu u̱du̱ Here̱ da, se̱ u̱n dor yaku̱n fu̱n-ya m-mu̱ bo̱-u u̱n. ");
INSERT INTO gel_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Da-u̱ a-nap-mu̱ re̱ge̱r-ne̱ arke̱, wa-to̱m Wa-ko-uyan haan u̱du̱ Yusuhu u̱ bo'. Wa zu̱, <<Yu̱ne̱, bo̱ kab wa' e̱ ino-u̱ wa bo̱ so̱m m-ha dak-u̱ Masar. Bo̱ shu̱'u̱t u̱ku̱n se̱ da-u̱ u̱m waru̱ bo̱, remu̱ zu̱ Here̱ o̱ gotu̱ ya-u̱r re̱ wa hoot wa.>> ");
INSERT INTO gel_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Se̱ wa yu̱ne̱, wa ku̱b u̱r-ya e̱ ino-u wa ne̱ m-gyu̱p e̱ do̱'e̱ u̱ Masar. ");
INSERT INTO gel_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ku̱na u̱n shu̱'u̱te̱ se̱ da-u̱ Here̱ mare̱. Ru̱-u̱ zu̱u̱g na no̱mu̱g no̱m-u̱t to̱ da-u̱ wa ware̱ wa-warru̱ rem-su̱ u-Ru̱ Hosiya u̱zu̱: <<Du̱gu̱ dak-u̱ Masar me̱ fagu̱ Wa'-u̱ ri.>> ");
INSERT INTO gel_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Da-u̱ Here̱ nape̱ u̱zu̱ ve̱r-se̱ a-nap-mu̱ re̱ge̱r-ne̱ no̱mu̱ wa, se̱ wa hog m-ku̱wu̱t. Se̱ wa wu̱ na ho̱o̱rse̱ ya'ag-u̱ campa-ne̱ be̱e̱t i o̱ u̱-me̱ bo̱-u̱ Be̱tarami u̱ kit-su̱ bo̱-u o̱ ne̱, du̱gu̱ u̱s-hak u̱s-yu̱r u̱ saan u-dak, wa regnu̱sse̱ ho̱n-ho̱n u̱ da-u̱ a-nap-mu̱ re̱ge̱r ne̱ waru̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Irmiya wa-warru̱ rem-su̱ u-Ru̱ waru̱g u̱zu̱ na u̱t-no̱m iya da-u̱ wa zu̱ye̱: ");
INSERT INTO gel_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","<<Na ho̱k u̱s-kan du̱gu̱ bo̱-u̱ Rama, Cwar-yu̱ u̱s-kan u̱ namu̱ jab ne̱ Rahira o̱gu̱ u̱s-kan remu̱ ya'ag-u̱ wa, na hoku̱ste̱ parru̱ wa da, Remu̱ zu̱ e̱ zamu̱n da.>> ");
INSERT INTO gel_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Da-u̱ Here̱ mare̱, wa-to̱m Wa-ko-uyan rwu̱n u̱du̱ Yusuhu u̱ bo'-u̱ dak-u̱ Masar. Wa zu̱, ");
INSERT INTO gel_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","<<Yu̱ne̱, bo̱ kab wa' e̱ ino-u wa no̱ do̱'e̱ u̱ dak-u̱ Isra, remu̱ zu̱, i o̱o̱ge̱ u̱ssa fat-du̱ wa' e̱ mu̱ru̱ste̱.>> ");
INSERT INTO gel_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Se̱ wa yu̱ne̱ wa ku̱b wa' u̱ ino-u wa ne̱, wa do̱'e̱ u̱ dak-u̱ Isra. ");
INSERT INTO gel_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Da-u̱ wa ho̱ge̱ u̱zu̱ Arkirayus wa'-u̱ Here̱ o̱ u̱r-faru̱k u̱ gas-u̱ Yahudiya, se̱ wa hog u-gye̱r u̱ ha-mu̱ ku̱n. E̱ aru̱k m-ha u̱ dak-u̱ Gariri remu̱ zu̱ Ru̱-u̱ no̱ngu̱ wu̱n u̱t-him u̱ bo'. ");
INSERT INTO gel_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Se̱ e̱ do̱'e̱ e̱ shu̱'u̱t u̱ o̱ko̱n bo̱-u̱ u̱ na foge̱ Nazara, remu̱ u̱ ko̱ste̱ u̱zu̱ no̱mu̱ a-warru̱ rem-su̱ u-Ru̱ ne̱ ware̱ nip-to̱, <<Na de̱ fag-du̱ wu̱n wa-Nazara.>> ");
INSERT INTO gel_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","U̱ te̱k-u̱ ho̱-u̱t to̱, Yohanna Wa-u̱t-yu̱bu̱sse̱ m-bu̱ rwu̱u̱n wa o̱ u̱t-bu̱t u̱-me̱ do̱g-du̱ Yahudiya. ");
INSERT INTO gel_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Wa o̱ u̱t-zu̱, <<Yagu̱n u̱t-ba'as, no̱ byu̱rnu̱n u̱du̱ u-Ru̱ remu̱ faru̱k-du̱ u-Ru̱ o̱ u̱t-mo̱r.>> ");
INSERT INTO gel_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Unwa wa wa-warru̱ rem-su̱ u-Ru̱ Ishaya nomte̱ u̱s-rem u̱zu̱, <<U-cwar yu̱ o̱ u̱s-fag u̱-me̱ u̱r-do̱g u̱zu̱, <Mangu̱n fu̱n-u Yawe, Yu̱nsu̱n u-fu̱n m-kim.> >> ");
INSERT INTO gel_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","To̱ggo̱-yu̱ Yohanna wa'e̱ yu̱ na no̱me̱ u̱ ka-u̱ u-rakum to̱, tu̱msu̱ wa o̱ m-gag u̱ hap-yu̱ u-ka ne̱ u-byu̱n. I o̱ no̱m u̱t-re̱ rò u̱ bu̱-mu̱ so̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ne̱t-tu̱ do̱'e̱ u̱du̱ wu̱n du̱gu̱ bo̱-u̱ Urusharima u̱ dak-tu̱ gas-u̱ Yahudiya-ne̱ u̱t-be̱e̱t, u̱ ne̱t-tu̱ o̱ gas-u̱ Gi-yu̱ Yodan ne̱. ");
INSERT INTO gel_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","U̱n hu̱ warru̱ ba'as-u̱t u̱n, se̱ wa no̱mu̱ u̱n u̱t-yu̱bu̱sse̱ m-bu̱, u̱ Gi-yu̱ Yodan. ");
INSERT INTO gel_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Da-u̱ Yohanna hyane̱ Farisa-ne̱ u-tát u̱ Saduki-ne̱ u̱ haan u̱du̱ rò, u̱ be-du̱ wa o̱tte̱ no̱mu̱ ne̱t-ne̱ u̱t-yu̱bu̱sse̱ m-bu̱, wa zu̱ u̱n, <<No̱ ban-du̱ ya'ag-u̱ ko̱ko̱s! ¿Wana hi-mu̱ no̱, no̱ som ryab-su̱ u-Ru̱ su̱ o̱ haane? ");
INSERT INTO gel_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","U̱ka te-su̱ mu̱tte̱ u̱t-ya, to̱ ko̱se̱ ko̱-uyan go̱-du̱ u-te ya, remu̱ iya ko̱ no̱ no̱mo̱n no̱m-tu̱ de̱ ko̱se̱ u̱t-ne̱t u̱zu̱ no̱ yakke̱ no̱m-du̱ u̱t-ba'as no̱ byu̱rgu̱n u̱du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","A no̱ dorog u̱ jab-u̱s no̱ u̱zu̱ Ibrahi wa o̱ u̱so-u no̱ da, u̱m o̱ waru̱ no̱ u̱zu̱ Ru̱-u̱ o̱ u̱t-kere̱ wa no̱m yaag du̱gu̱ me̱ ta'ar-u̱t tun-to̱ to̱ shu̱'u̱t ya'agu̱ Ibrahi. ");
INSERT INTO gel_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","U̱m o̱ waru̱ no̱ Ru̱-u̱ de̱ yadu̱ no̱ u̱r-ko̱b a no̱ byu̱r-ne̱ no̱ yage̱ yu̱du̱ u̱t-ba'as da, u̱ka ne̱t wu̱ ka'e̱ u̱r-goog u̱ kug-du̱ u̱s-te. Te-yu̱ mate̱ ya-u̱t so̱-to̱ da, wa de̱ kupsu̱ ya, wa gun u-ra. ");
INSERT INTO gel_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","<<U̱m no̱ngu̱ no̱ u̱t-yu̱bu̱sse̱ m-bu̱, remu̱ u̱ ko̱ste̱ u̱zu̱ no̱ byu̱rgu̱n u̱du̱ u-Ru̱ no̱ yakke̱ u̱t-ba'as, se̱di u̱ dim-u̱ ri waku̱n de̱ haan wu̱ ze̱gu̱ me̱ m-shin. Ko̱ go̱r-su̱ ka'at-u̱t wa u̱m ko̱rge̱ u̱m ust se̱ da. Wa de̱ no̱mu̱ no̱ u̱t-yu̱bu̱sse̱ u̱ Yar-u u-Ru̱ tu̱msu̱ u-ra ne̱. ");
INSERT INTO gel_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wa o̱ m-shu̱p u-sota ne̱, wa de̱ mangu̱ do̱r-u̱ m-der, wa so̱tu̱sse̱ so i o̱ so-ye̱ wa wa' u̱r-bya, wa doos kon u̱ ra-u̱ u̱ na da hoks u̱t-ryu̱m da.>> ");
INSERT INTO gel_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Da-u̱ Ye̱so̱ haane̱ du̱gu̱ Gariri u̱ Gi-yu̱ Yodan u̱ Yohanna no̱m-tu̱ wa u̱t-yu̱bu̱sse̱ m-bu̱, ");
INSERT INTO gel_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yohanna sa'ag u̱t-gu̱gu̱m. Wa zu̱, <<¿Me̱ hi-du̱ warri u̱m u̱t-sa bo̱ no̱mu̱ me̱ u̱t-yu̱bu̱sse̱ m-bu̱, bo̱ mu bo̱ haan u̱du̱ ri?>> ");
INSERT INTO gel_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Se̱ Ye̱so̱ zu̱, <<Yage̱ na no̱m iya u̱ da-o̱, remu̱ na nom-u̱t no̱m-u̱ Ru̱-u̱ u̱t-sa na no̱m.>> Se̱ Yohanna ees. ");
INSERT INTO gel_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Da-u̱ Yohanna no̱mu̱ Ye̱so̱ u̱t-yu̱bu̱sse̱ m-bu̱, Ye̱so̱ rwu̱u̱n du̱gu̱ m-bu̱, za rem do̱m u-ru̱ u-pus se̱ Ye̱so̱ hyen Yar u-Ru̱ u̱ hye̱e̱n u̱ka u̱r-gorop u̱ do̱m-u̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Se̱ Ru̱-u̱ nom u̱s-rem du̱gu̱ do̱m u-ru̱ wa zu̱, <<Unwa o̱ Wa'-u̱ ri, wu̱ u̱m o̱ u̱t-cwan, tu̱msu̱ u̱m o̱ ho̱g-du̱ zwar-u̱r wa sok.>> ");
INSERT INTO gel_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Se̱ Yar u-Ru̱ dor-u̱t Ye̱so̱ m-cwa u̱t-kanda u̱ remu̱ faru̱k-u̱ no̱m u̱s-te no̱m-tu̱ wa m-reg. ");
INSERT INTO gel_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Da-u̱ Ye̱so̱ no̱me̱ u-swaat m-roog u̱t-shik u̱t-yu̱r u̱t-ho̱ ne̱ u̱t-shik u̱t-yu̱r, se̱ wa hog u̱s-me̱r. ");
INSERT INTO gel_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Faru̱k-u̱ no̱m u̱s-te haan u̱du̱ ro wa zu̱, <<Abite̱ Wa'-u̱ u-Ru̱ wa bo̱ o̱ye̱, zu̱ ta'ar-u̱r rinde̱ de̱ mu no̱m u̱t-re̱.>> ");
INSERT INTO gel_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ye̱so̱ shu̱s wa zu̱, <<Rem-su̱ u-Ru̱ zu̱u̱g, a-no̱m u̱t-re̱ u̱ war-o̱ ne̱t do̱te̱ u̱r-fat da, se̱ rem-su̱ rwu̱ne̱ du̱gu̱ nu-u̱ u-Ru̱.>> ");
INSERT INTO gel_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Faru̱k-u̱ no̱m u̱s-te ku̱b wu̱n m-ha u̱ bo̱-u̱ Urusharima bo̱-u̱ u-he̱n, se̱ wa du̱u̱t wu̱n u̱ be-du̱ m-ja be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan. ");
INSERT INTO gel_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Tu̱msu̱ wa zu̱ wu̱n, <<Abite̱ Wa'-u̱ u-Ru̱ wa bo̱ o̱ye̱, tane̱ tari mak bo̱ he̱e̱n u-dak. Remu̱ zu̱ na panu̱g u̱zu̱, << <Ru̱-u̱ de̱ wadu̱ a-to̱mu̱ wa, e̱ 'e̱ bo̱, E̱ e̱r bo̱ u̱ kom-u̱t e̱, Taas u̱ na-u ro u̱ gap u̱r-ta'ar da.>>> ");
INSERT INTO gel_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ye̱so̱ shu̱s wa zu̱, <<Na panu̱g u̱zu̱, <A-bo̱ no̱mu̱ Wa-ko-uyan Ru̱-u ro m-reg da.> >> ");
INSERT INTO gel_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Se̱ faru̱k-u̱ no̱m u̱s-te ku̱b wu̱n m-ha ro̱r-du̱ zege̱ m-ja, wa ko̱se̱ wu̱n faru̱k-tu̱ dak-u uno̱, u̱ zwar-u̱r wa ne̱. ");
INSERT INTO gel_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Se̱ wa zu̱, <<Me̱ ya u̱ bo̱ no̱m-u̱t to̱ u̱t-be̱e̱t, a-bo̱ no̱mu̱ me̱ u̱t-huuk.>> ");
INSERT INTO gel_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Se̱ Ye̱so̱ zu̱ wu̱n, <<Faru̱k-u̱ no̱m u̱s-te, hate̱ du̱gu̱ kit-u̱ ri, remu̱ na panu̱g u̱zu̱, <Bo̱ no̱mu̱ Wa-ko-uyan Ru̱-u ró u̱t-huuk, tu̱msu̱ wa bo̱ do̱'e̱ u̱t-do̱r, wa u-gan.> >> ");
INSERT INTO gel_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Faru̱k-u̱ no̱m u̱s-te yage̱ wu̱n, se̱ a-to̱m u-Ru̱ haan, e̱ no̱mu̱ wu̱n u̱r-se̱ge̱. ");
INSERT INTO gel_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Da-u̱ Ye̱so̱ ho̱ge̱ u̱zu̱ Here̱ Faru̱k Antipas wa'ag Yohanna wa-u̱t-yu̱bu̱sse̱ m-bu̱ u̱ bu-u̱ m-to̱k, se̱ wa mu u̱ dak-u̱ Gariri. ");
INSERT INTO gel_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ye̱so̱ yage̱ bo̱-u̱ Nazara wa do̱'e̱ wa shu̱'u̱t u̱ Kapanahum, u̱ dap-su̱ m-sa mu̱ Gariri u̱-me̱ dak-u̱ Ze̱be̱run u̱ Naptari-ne̱. ");
INSERT INTO gel_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","No̱m-u̱ wu̱te̱ wu̱n m-ha u̱ku̱n, remu̱ wa hyen-u̱t no̱mu̱ Ishaya Wa-warru̱ rem-su̱ u-Ru̱ zu̱ na u̱t-no̱m, na no̱m o. ");
INSERT INTO gel_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","<<Dak-u̱ Ze̱be̱run u̱ dak-u̱ Naptari-ne̱, o̱ do̱m-u̱ fu̱n-yu̱ o̱ dapu̱s sa-mu̱ u̱ gas-u̱ u-do̱m u̱ gi-yu̱ Yodan, Dak-to̱ u̱-me̱ dak-u̱ Gariri be-tu̱ i za-Yahuda-ne̱ zegte̱ u-tát da. ");
INSERT INTO gel_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ne̱t-tu̱ o̱ u̱r-yu̱ u̱-me̱ u-cwu̱m, e̱ hyanu̱g zu̱n-m yat-mo̱. U̱du̱ i o̱o̱ge̱ u̱r-yu̱ u̱-me̱ dak-u̱ yara-mu̱ m-mar. Zu̱n-mu̱ rwu̱gu̱n e̱.>> ");
INSERT INTO gel_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Du̱gu̱ da-u o̱ Ye̱so̱ he̱e̱se̱ u̱t-bu̱t, u̱zu̱, <<Yagu̱n u̱t-ba'as no̱ byu̱ru̱n u̱du̱ u-Ru̱, remu̱ zu̱ da-u̱ Ru̱-u̱ de̱ u̱r-faru̱k o̱ u̱t-mo̱r.>> ");
INSERT INTO gel_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Da-u̱ Ye̱so̱ o̱o̱ge̱ m-ha u̱ dapu̱s m-sa mu̱ Gariri, se̱ wa hyen ne̱t-ne̱ yu̱r, u̱ Simo̱n wu̱na foge̱ Biturus u̱ o̱r-u̱ wu̱n ne̱ Andarawus, e̱ o̱ gwu̱n-du̱ no̱m-tu̱ masu̱ jan, u̱-me̱ m-sa, remu̱ zu̱ u̱n a masu̱ jan ne̱ e̱. ");
INSERT INTO gel_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ye̱so̱ zu̱ u̱n, <<Dornu̱n me̱, me̱ mutu̱ no̱ a naknu̱ u̱t-ne̱t u̱ haan u̱du̱ ri.>> ");
INSERT INTO gel_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Za rem, u̱n yage̱ no̱m-tu̱ masu̱ jan-u̱ u̱n, u̱n dor wa. ");
INSERT INTO gel_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Da-u̱ wa re̱ shu̱ m-ha ne̱, se̱ wa hyen e̱ke̱n ne̱t-ne̱ yu̱r, u̱ Yakubu e̱ Yohanna ya'ag-u̱ Zabadi. E̱ o̱ u̱-me̱ u-hat u̱ u̱so-u u̱n ne̱ Zabadi, e̱ o̱ mangu̱ no̱m-tu̱ masu̱ jan-u̱ e̱. Ye̱so̱ fog u̱n. ");
INSERT INTO gel_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Za rem u̱n yage̱ u-hat u̱ u̱so-u u̱n ne̱, u̱n dor wa. ");
INSERT INTO gel_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ye̱so̱ rigu̱sse̱ dak-u̱ Gariri wa o̱ no̱mu̱ u̱n u̱t-ko̱se̱ u̱-me̱ bu-u̱ u̱t-ko̱se̱ u̱ Yahuda-ne̱, wa o̱ no̱mu̱ u̱n u̱t-bu̱t tu̱ Rem-su̱ m-Re̱me̱r su̱ Faru̱k-du̱ u-Ru̱, tu̱msu̱ u̱ has-tu̱ ne̱t-ne̱ u̱s-go̱m m-re̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Rem-su̱ no̱m-tu̱ Ye̱so̱ no̱me̱ nu̱ru̱s dak-u̱ Suriya u-be̱e̱t, Ne̱t-tu̱ hu̱ haatu̱n wu̱n a u̱s-go̱m u̱ a-ko̱b-du̱ m-yar ne̱, u̱ a swadu̱ u̱r-ko̱b ne̱ m-re̱, u̱ a-no̱m u̱s-te ne̱, u̱ i o̱tte̱ go̱m-su̱ u̱r-he̱'e̱, u̱ a remu̱ swadu̱ ne̱t-ne̱ u̱t-be ne̱, se̱ wa yu̱' e̱ m-yar. ");
INSERT INTO gel_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mo̱ro̱g-du̱ u̱t-ne̱t du̱gu̱ Gariri, u̱ Dikaporis, u̱ Urusharima, u̱ Gas-u̱ Yahudiya, tu̱msu̱ u̱ gas-u̱ gwu̱g-du̱ gi-yu̱ Yodan dor wu̱n. ");
INSERT INTO gel_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Da-u̱ Ye̱so̱ hyane̱ ban-du̱ u̱t-ne̱t, se̱ wa du̱u̱s u̱ do̱m u̱r-ro̱r wa shu̱'u̱t m-shu̱'u̱t. Se̱ a-doru̱ wa o̱p u̱ yu̱r e̱ haan u̱du̱ wa, ");
INSERT INTO gel_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Se̱ Ye̱so̱ he̱e̱se̱ no̱mu̱ u̱n u̱t-ko̱se̱, wa zu̱, ");
INSERT INTO gel_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","<<Kom u-Ru̱ u̱du̱ i nape̱ ku̱shin-m e̱ u̱-me̱ u-Yar, remu̱ faru̱k-du̱ u-Ru du̱ e̱ de̱. ");
INSERT INTO gel_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kom u-Ru̱ u̱du̱ a namu̱ jab-ne, na de̱ yadu̱ e̱ jab m-shiriktin. ");
INSERT INTO gel_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kom u-Ru̱ u̱du̱ i zatte̱ hu̱k-mu̱ u̱t-hi da, e̱ de̱ kwu̱m-du̱ dak-u uno̱. ");
INSERT INTO gel_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kom u-Ru̱ u̱du̱ a ho̱g-du̱ u̱s-me̱r u̱ swa'at m-bu̱ ne̱, tu̱ no̱m-u̱t so̱-to̱, na de̱ shu̱ksu̱ e̱. ");
INSERT INTO gel_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kom u-Ru̱ u̱du̱ a ho̱g-du̱ u̱r-o̱n ne̱, remu̱ Ru̱-u̱ de̱ ho̱gu̱ o̱n-u̱r e̱. ");
INSERT INTO gel_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kom u-Ru̱ u̱du̱ i o̱ jab-u̱ so̱-o̱ ne̱, remu̱ e̱ de̱ hyan-du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kom u-Ru̱ u̱du̱ i wu̱'e̱ u̱t-ne̱t u̱ shu̱'u̱t-du̱ jab-u̱ pus-o̱, na de̱ fag-du̱ e̱ ya'ag u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kom u-Ru̱ u̱du̱ i ne̱t-tu̱ o̱ yadu̱ u̱r-ko̱b u̱ remu̱ no̱m-u̱t so̱-to̱, remu̱ faru̱k-du̱ u-Ru̱ du̱ e̱ de̱. ");
INSERT INTO gel_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","<<Kom u-Ru̱ u̱du̱ no̱ da ne̱t-tu̱ o̱ pe̱pru̱ no̱, e̱ o̱ u̱ yadu̱ no̱ u̱r-ko̱b, e̱ o̱ ke̱tu̱ no̱ u̱s-rem su̱ no̱m-u̱t yo̱-to̱ u̱ remu̱ ri. ");
INSERT INTO gel_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","No̱mo̱n u̱r-so̱ u̱ no̱ no̱m jab-u̱ pus-o̱ u̱ remu̱ u̱zu̱ to̱p-u no̱ o̱ yat-o̱ u̱ do̱m u-ru̱, iya o̱ u̱n nomte̱ a-warru̱ rem-su̱ u-Ru̱ ne̱ i ba no̱ m-haan. ");
INSERT INTO gel_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","<<No̱ o̱ ma-tu̱ dak-u uno̱. Se̱di a matu̱ taye̱ u̱r-gag, ¿re̱ne̱ o̱ na do̱te̱ mangu̱ to̱? Na za no̱m-du̱ o̱ko̱n u̱ to̱ da, se̱di na agu̱sse̱ u̱ ne̱t-tu̱ jangu̱sse u̱s-na. ");
INSERT INTO gel_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","<<No̱ o̱ye̱ zu̱n-mu̱ dak-u uno̱. Bo̱-u̱ o̱ m-sak u̱ do̱m u̱r-ro̱r na za yasu̱ o̱ da. ");
INSERT INTO gel_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ne̱t za dapu̱s u̱s-hitirra u̱ wa wu̱gu̱b ya u-ko̱k da. Se̱di na sak ya u̱ do̱m naas wa u̱ ya ya' m-zu̱n u̱du̱ ne̱tu̱ o̱ye̱ u-bu u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Iya o̱ hen, yagu̱n u̱ zu̱n-m no̱ mo̱k, u̱ka ne̱t-tu̱ do̱te̱ hyan-du̱ ank-m so̱mo̱ no̱, remu̱ e̱ no̱m-tu̱ U̱so-u no̱ wu̱ o̱ do̱m u-ru̱ u̱t-vam. ");
INSERT INTO gel_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","<<A no̱ no̱m u̱s-dorog u̱zu̱ u̱m haagu̱n u̱m haste̱ rem-su̱ u-Ru̱ su̱ Mosa pane̱ u̱ su̱ a-warru̱ rem-su̱ u-Ru̱ ne̱ da. U̱m haagu̱n u̱m haste̱ se̱ da se̱di u̱m shu̱u̱ste̱ se̱. ");
INSERT INTO gel_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","U̱m o̱ waru̱ no̱ u̱t-nip kanda do̱m u-ru̱ u-dak ne̱ o̱ e̱nkte̱, ko̱ u-pan u-re̱k ya ko̱ u-de̱ u-gan ya za u̱t-e̱nk u̱ te̱k-u̱ rem-su̱ u-bo̱r da se̱ na no̱ng ko-uyan. ");
INSERT INTO gel_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ko̱wana pase̱ bo̱r-u re̱k-ya u̱ te̱k-u̱ bo̱r-u̱s sin-se̱ tu̱msu̱ wa ko̱se̱ u̱t-ne̱t e̱ pas, na do̱'e̱ fagu̱ wa yu̱ re̱k-ya u̱ te̱k-u̱ faru̱k-du̱ u-Ru̱. Wa hene kabe̱ rem-su̱ u-bo̱r sin-se̱ wa ko̱se̱ e̱ke̱n ne̱ na do̱'e̱ fagu̱ wa yu̱ yat-ya u̱ te̱k-u̱ faru̱k-du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","U̱m o̱ waru̱ no̱ a no̱ zege̱ Farisa-ne̱ u̱ a-ko̱se̱-tu̱ rem-su̱ u-bo̱r ne̱ u̱ no̱m-du̱ no̱m-u̱t so̱-to̱ da, no̱ za cwa-du̱ faru̱k-du̱ u-Ru̱ da. ");
INSERT INTO gel_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","<<No̱ ho̱k na zu̱u̱g ne̱t-tu̱ da-u̱ dim, <A e̱ ho̱ ne̱t da, ko̱ wa ho̱ ne̱t na hu̱u̱tu̱ wa u̱ be-du̱ kwu̱p-du̱ u̱s-rem.> ");
INSERT INTO gel_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Se̱di u̱m o̱ waru̱ no̱ ko̱wana o̱ u̱s-ryab su̱ o̱r-u̱ wa na de̱ kwu̱pu̱ wa u̱s-rem. Tu̱msu̱ ko̱wana zu̱ye̱ o̱r-u̱ wa, <M-zan,> mo̱ro̱g-du̱ u̱t-ne̱nge̱n de̱ kwu̱pu̱ wa u̱s-rem. Wu̱ fage̱ o̱r-u̱ wa <Rag!> wa o̱ fu̱n-yu̱ ha-mu̱ bu-u u-ra. ");
INSERT INTO gel_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","<<Remu̱ iya, a bo̱ o̱ no̱m-du̱ u-nya u̱r-sak u-me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan se̱ bo̱ baku̱s u̱zu̱ bo̱ no̱ngu̱ waku̱n no̱m-u̱ kame̱ da. ");
INSERT INTO gel_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Yage̱ no̱m-tu̱ u-nya' u̱ ró u̱-shu̱ u̱r-sak bo̱ do̱'e̱ u̱du̱ wa. Ko̱n wa wa no̱mu̱ bo̱ u̱r-ho̱ remu̱ no̱mu̱ bo̱ no̱mu̱ wa. Se̱ bo̱ haan bo̱ yase̱ no̱m-tu̱ nya-u ró u̱du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","<<A waku̱n o̱ hu̱u̱tu̱ bo̱ u̱ be-du̱ kwu̱p-du̱ u̱s-rem, sa u-mang no̱ wa ne̱ za naas u-da. No̱mo̱n iya du̱gu̱ u-fu̱n, a-za iya da wa de̱ hu̱u̱tu̱ bo̱ u̱du̱ wa kwu̱p-du̱ u̱s-rem, wa kwu̱p-du̱ u̱s-rem de̱ hen u̱ yasu̱ bo̱ u̱du̱ no̱m u̱s-ko̱m, no̱m u̱s-ko̱m tu̱msu̱ e̱ hu̱u̱t bo̱ u̱ bu-u̱ m-to̱k. ");
INSERT INTO gel_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","U̱m o̱ waru̱ no̱ u̱t-nip bo̱ da rwu̱u̱n u̱ku̱n da se̱ bo̱ to̱po̱k no̱mu̱ na shu̱t-ne̱ wa u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","<<No̱ ho̱k bo̱r-tu̱ u-Ru̱ u̱zu̱, <A no̱ no̱m m-o̱ da.> ");
INSERT INTO gel_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Se̱di u̱m o̱ waru̱ no̱, ko̱wana gwate̱ ne̱ta gwat u̱zu̱ wa roog u̱ wa ne̱, wa taaste̱ m-o̱ u̱ wa ne̱ u̱-me̱ jab-u̱ wa. ");
INSERT INTO gel_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","A is-du̱ kom u̱t-cwa u̱ ró u̱ o̱ wadu̱ bo̱ u̱ no̱m-du̱ u̱t-ba'as, hoste̱ de̱ bo̱ rest taas bo̱ no̱m u̱t-ba'as. Ze̱k u̱r-zwar bo̱ taag u̱ o̱g-du̱ u̱r-gan du̱ war-u ró, u̱zu̱ na gun bo̱ u-ra u̱ o̱g-tu̱ war-u ró ne̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","A kom u̱t-cwa ró o̱ wadu̱ bo̱ u̱ no̱m-du̱ u̱t-ba'as, kupse̱ o̱ bo̱ rest. Ze̱k u̱r-zwar u̱ bo̱ taag u̱ o̱g-du̱ u̱r-gan du̱ war-u ró u̱zu̱ na gun bo̱ u-ra u̱ o̱g-tu̱ war-u ró ne̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","<<Tu̱msu̱ na wargu̱ no̱ u̱zu̱, <Ko̱wana yane̱ ne̱ta wa, wa zatte̱ ka u̱t-no̱m da, se̱ wa yaag wa ran-u̱ u̱t-yan.> ");
INSERT INTO gel_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tu̱msu̱ u̱m o̱ waru̱ no̱ u̱zu̱, ko̱wana yane̱ ne̱ta wa, a-za remu̱ ba'as-tu̱ m-o̱ da, wa wa'ag wa-u-as. Tu̱msu̱ wu̱ gaye̱ ne̱ta-yu̱ na yanne̱ wa no̱ng m-o̱ u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","<<No̱ ho̱k na wargu̱ ne̱t-tu̱ da-u̱ dim a e̱ no̱m to̱nd-su̱ u̱s-bi da, <A no̱ pas no̱mu̱ no̱ nomte̱ este̱du̱ u̱s-rem da, se̱di ne̱tu̱ no̱m no̱m-u̱ wa nomte̱ este̱du̱ u̱s-rem u̱du̱ Yawe.> ");
INSERT INTO gel_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tu̱msu̱ no̱m u̱m waru̱ no̱ u̱zu̱, a no̱ no̱m u̱s-to̱nd da, ko̱ u̱ do̱m u-ru̱, remu̱ u̱zu̱ be-du̱ u̱r-shu̱'u̱t du̱ u-Ru̱ de̱ du̱ u̱r-faru̱k u̱ wa. ");
INSERT INTO gel_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tu̱msu̱ a no̱ to̱n-de̱ u-dak ne̱ da, remu̱ u̱zu̱ ku̱na Ru̱-u̱ cinte̱ na-u̱s wa. Tu̱msu̱ a no̱ to̱nd u̱ Urusharima ne̱ da, remu̱ u̱zu̱ bo̱-u yat-o̱ u̱ Farkina-ne̱ o̱. ");
INSERT INTO gel_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","A-bo̱ to̱n-de̱ tu̱msu̱ u̱ hi-du̱ war ró ne̱ da, remu̱ u̱zu̱ ko̱ hi-u ró u-gan bo̱ za keru̱ mutu̱ ya u̱ pus-ya ko̱ u̱ rim-ya da. ");
INSERT INTO gel_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","A no̱ u̱t-sa no̱m-du̱ o̱ko̱n no̱mu̱ kame̱ no̱ zu̱, <U̱, me̱ u̱t-no̱m,> ko̱ <O'o, u̱m za u̱t-no̱m da.> No̱m-u̱ ze̱ge̱ iya du̱ faru̱k-u̱ no̱m u̱s-te de̱ o̱ rwu̱tu̱n. ");
INSERT INTO gel_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","<<No̱ ho̱k no̱m-tu̱ a-ko̱se̱-tu̱ u-bo̱r ne̱ zu̱ye̱, u̱zu̱ bo̱r-u̱t zu̱u̱g, <Wu̱ nase̱ is-du̱ o̱r-u̱ wa, waku̱n de̱ na-su̱ du̱ wa is-de̱. Wu̱ tu̱msu̱ fare̱ nin-yu̱ o̱r-u̱ wa, waku̱n de̱ far-du̱ yu̱ wa nin-ya.> ");
INSERT INTO gel_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tu̱msu̱ u̱m o̱ waru̱ no̱ a no̱ to̱p waku̱n u̱ no̱m-u yo̱-o̱ remu̱ zu̱ wa no̱ngu̱ no̱m-u̱t yo̱-to̱ da. A waku̱n u̱ gapu̱ bo̱ u̱ gar-yu̱ kom u̱s-cwa bir u̱ gar-yu̱ kuse̱. ");
INSERT INTO gel_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A waku̱n u̱t-sa wa hu̱u̱t bo̱ u̱ be-du̱ kwu̱p-du̱ u̱s-rem remu̱ u̱zu̱ wa o̱ngte̱ to̱ggo̱-u ró, yasu̱ wa to̱ggo̱-yu̱ do̱m. ");
INSERT INTO gel_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","A karma-yu̱ wa bo̱ u̱ kabu̱ wa u̱r-ba u̱ ha-mu̱ u-mer u-gan u̱r-be̱b, no̱m ha-mu̱ u̱s-me̱r u̱s-yu̱r u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","A waku̱n u̱ ko̱nu̱ bo̱ u-no̱m, ya' wa. Wu̱ haane̱ m-se̱g u̱du̱ ró, a-bo̱ hoos wa da. ");
INSERT INTO gel_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","<<No̱ ho̱k Mosa panu̱g u̱zu̱, <Cwanu̱n o̱r-u̱t no̱ ne̱,> no̱ gu̱gu̱m i gu̱gmu̱ no̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Se̱di u̱m o̱ waru̱ no̱, cwanu̱n i gu̱gmu̱ no̱ ne̱, i o̱ ne̱ u̱ yadu̱ no̱ u̱r-ko̱b no̱mu̱n e̱ u̱s-to̱o̱g. ");
INSERT INTO gel_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","No̱mo̱n iya remu̱ no̱ shu̱'u̱te̱ ya'agu̱ U̱so-u no̱ wu̱ o̱ u̱ do̱m u-ru̱. Wa wu̱' ho̱-du̱ ya' m-zu̱n u̱du̱ ne̱t-u̱t so̱-to̱ u̱du̱ tu̱ za so̱-to̱ ne̱. Wa rob u-yu̱ u̱du̱ ne̱t-u̱t so̱-to̱ ne̱ u̱ tu̱ yo̱-to̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","A no̱ o̱ cwan-tu̱ i o̱ cwan-u̱t no̱ ne̱, ¿yan to̱p-o̱ no̱ de̱ u̱t-kwu̱m? Ko̱ a-o̱nku̱ shik tar ne̱ iya o̱ e̱ nomte̱! ");
INSERT INTO gel_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","A no̱ o̱ vu̱k-su̱ o̱r-u̱t no̱ u̱ war'e̱, ¿yan-o̱ u̱ no̱ nome̱ u̱ no̱ zekte̱ e̱ke̱n ne̱? Ko̱ i nape̱ u-Ru̱ da, e̱ nom iya! ");
INSERT INTO gel_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","U̱ remu̱ iya, se̱ no̱ shu̱'u̱t shu̱yi-shu̱yi u̱ka U̱so-u no̱ u̱ do̱m u-ru̱ o̱tte̱ u-shu̱yi shu̱yi. ");
INSERT INTO gel_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","<<Ye̱so̱ re shu̱ u̱ no̱mu̱ a-doru̱ wa-u̱t-ko̱se̱ u̱zu̱, <A no̱ o̱ no̱m-du̱ no̱m-u̱t so̱-to̱,> a no̱ no̱m o̱ da-u̱ ne̱t-tu̱ o̱ madu̱ no̱ remu̱ e̱ vom-u̱t no̱ da. A no̱ no̱me̱ o̱ko̱n remu̱ ne̱t-tu̱ vom-u̱t no̱, no̱ za kwu̱m-du̱ u-to̱p u̱du̱ U̱so-u no̱ wu̱ o̱ do̱m u-ru̱ da. ");
INSERT INTO gel_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","<<U̱ remu̱ iya a no̱ o̱ nya-du̱ waku̱n wa u̱r-ko̱b u-no̱m, a no̱ no̱m u̱r-do̱nse̱ da, u̱ka a-ha-mu̱ u̱r-no̱ ne̱ nomte̱ u̱-me bu-u̱ u̱t-ko̱se̱ u̱ Yahuda-ne̱ u̱s-fu̱n ne̱ u̱ remu̱ zu̱ u̱ ne̱t-tu̱ vom-u̱t e̱. U̱m o̱ waru̱ no̱ u̱t-nip e̱ taaste̱ o̱nk-u̱ to̱p-u e̱ u-be̱e̱t iya. ");
INSERT INTO gel_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tu̱msu̱ a no̱ o̱ yadu̱ waku̱n o̱ko̱n no̱m-o̱, a-bo̱ yage̱ u̱ to̱ko̱n ne̱t-to̱ u̱ nap no̱m-u̱ bo̱ u̱t-no̱m da. ");
INSERT INTO gel_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Iya o̱ no̱ do̱te̱ no̱m-du̱ u-Nya m-yasa. Tu̱msu̱ U̱so-u no̱, wa hyene̱ no̱m-tu̱ m-yasa u̱t-be̱e̱t, wa no̱mu̱ bo̱ u-to̱p. ");
INSERT INTO gel_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","<<Tu̱msu̱ a no̱ o̱ u̱ no̱m-du̱ u̱s-to̱o̱g, a no̱ no̱m u̱ka a-ha-mu̱ u̱r-no̱ ne̱ nomte̱ da, e̱ ton e̱ ees u̱-me̱ bu-u̱ u̱t-ko̱se̱ u̱ Yahuda-ne̱ u̱s-fu̱n ne̱ remu̱ ne̱t-tu̱ hyen-u̱t e̱. U̱m o̱ waru̱ no̱ u̱t-nip, e̱ taaste̱ o̱nk-u̱ to̱p-u e̱ u-be̱e̱t iya. ");
INSERT INTO gel_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Se̱di a-bo̱ o̱ no̱m-du̱ u̱s-to̱o̱g, cwa u̱-me u-kur bo̱ tage̱ u-is, se̱ bo̱ no̱m u̱s-to̱o̱g u̱du̱ U̱so-u ró wu̱ na hyente̱ da. U̱so-u ró wu̱ hyene̱ no̱m-tu̱ m-yasa wa de̱ no̱mu̱ bo̱ u-to̱p. ");
INSERT INTO gel_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","A no̱ o̱ no̱m-du̱ u̱s-to̱o̱g, a no̱ ha u̱ sop-su u-no̱m u̱r-ba da u̱ka i nape̱ ne̱ u-Ru̱ da, i o̱ m-hyan u̱ka zu̱, a e̱ no̱me̱ iya da, ru̱-u u̱n za ho̱g-du̱ to̱o̱g-u̱s u̱n da. ");
INSERT INTO gel_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","A no̱ no̱m u̱ka e̱ da, remu̱ U̱so-u no̱ nak no̱m-tu̱ no̱ u̱t-sa kanda no̱ ko̱n wa. ");
INSERT INTO gel_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","<<No̱mo̱n u̱s-to̱o̱g inya, << <U̱so-u it, wu̱ o̱ do̱m u-ru̱, U̱m u̱t-sa u̱ ne̱t-tu̱ vam bo̱ u̱ no̱m-u̱ e̱ o̱ u̱t-no̱m u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","U̱ faru̱k-u̱r ró u̱ haan, No̱m-tu̱ bo̱ u̱t-sa na no̱m-to̱, u-dak u̱ka na nomte̱ u̱ do̱m u-ru̱. ");
INSERT INTO gel_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bo̱ ya' it no̱m u̱t-re̱ u̱ ko-uyan ho̱-de̱. ");
INSERT INTO gel_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bo̱ no̱mu̱ it ho̱-du̱ ba'as-u̱t it, u̱ka it nomte̱ i no̱mu̱ it u̱t-ba'as u̱r-ho̱. ");
INSERT INTO gel_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","A-bo̱ hu̱u̱t it u̱ be-du̱ m-reg da, se̱di bo̱ e̱' it u̱du̱ faru̱k-u̱ no̱m u̱s-te.> ");
INSERT INTO gel_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","A no̱ no̱mu̱ ne̱t-tu̱ no̱mu̱ no̱ u̱t-ba'as u̱r-ho̱, U̱so-u no̱ wu̱ o̱ do̱m u-ru̱ wa de̱ no̱mu̱ no̱ ho̱-du̱ ba'as-u̱t no̱. ");
INSERT INTO gel_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Se̱di a no̱ no̱me̱ u̱t-ne̱t ho̱-du̱ ba'as-u̱t e̱ da, U̱so-u no̱ wa za no̱mu̱ no̱ ho̱-du̱ ba'as-u̱t no̱ da. ");
INSERT INTO gel_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","<<A no̱ kabe̱ u-swaat, a no̱ naas shu̱u̱t no̱ u̱ka a-ha-mu̱ u̱r-no̱ ne̱ nomte̱ da. E̱ naas u̱t-shu̱ u̱ remu̱ e̱ ko̱ste̱ u̱t-ne̱t u̱zu̱ e̱ o̱ u-swaat. U̱m o̱ waru̱ no̱ u̱t-nip, u̱n taaste̱ o̱nk-u̱ to̱p-u u̱n u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tu̱msu̱ a-bo̱ o̱ no̱m-du̱ u-swaat, saape̱ shu̱-u ró, bo̱ taam m-no̱o̱g u̱ hi-u̱r ró, ");
INSERT INTO gel_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ta'as na nap u̱zu̱ bo̱ o̱ u-swaat da. U̱so-u ró de̱ no̱mu̱ bo̱ u-to̱p, wu̱na hyene̱ no̱m-tu̱ na nome̱ m-yasa. ");
INSERT INTO gel_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","<<Ano̱ cin kwu̱m-u̱t no̱ u-dak uno̱ da, be-du̱ rog m-kaari ne̱ do̱te̱ u̱t-naas, u̱ be-du̱ hyu̱w-ne̱ do̱te̱ u̱r-cwa e̱ no̱m u-hiw. ");
INSERT INTO gel_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Se̱di no̱ no̱m u̱r-cu̱n u̱ do̱m u-ru̱ u̱ be-du̱ orog u̱ m-kaari ne̱ zatte̱ u̱t-na'as da, u̱ be-du̱ hyu̱w-ne̱ tu̱msu̱ e̱ zatte̱ u̱t-hyu̱w da. ");
INSERT INTO gel_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Be-du̱ kwu̱m-u̱t no̱ o̱tte̱ ku̱na jab-u̱ ró o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","<<Is-de̱ o̱ye̱ zu̱n-mu̱ u-war. A is-u̱r ró o̱ye̱ m-yar ne̱, war-u ró u-be̱e̱t u̱t-shu̱'u̱t m-zu̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Se̱di a is-u̱ ró za so̱ye̱ da, war-u ró u-be̱e̱t o̱ de̱ shu̱'u̱t u-cwu̱m ne̱. Abite̱ zu̱n-mu̱ o̱ me̱ no̱ cwu̱m o̱, re̱-o̱ tat-u̱ cwu̱m-u o̱! ");
INSERT INTO gel_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","<<Waku̱n za no̱mu̱ tu̱-shu̱ u̱t-yu̱r m-to̱k da. Se̱di wa gu̱gu̱m wa-gan u̱ wa cwan wa-gan, ko̱ wa no̱m no̱m-u̱ wa-gan u̱t-sa wa ju̱ru̱m wa-gan. No̱ za wadu̱ do̱rru̱ u-Ru̱ u̱ jab tu̱msu̱ no̱ wa-cwan-tu̱ shik-u̱ jab u-da u-gan da. ");
INSERT INTO gel_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","<<U̱ remu̱ iya, u̱m o̱ waru̱ no̱, a no̱ naas jab-u̱ remu̱ no̱mu̱ no̱ de̱ u̱t-re̱ ko̱ u̱ no̱ de̱ u̱t-swa, ko̱ kus-tu̱ no̱ de̱ u̱t-wa u̱ war-u no̱ da. Fat-du̱ ze̱k no̱m u̱t-re̱, tu̱msu̱ war-u̱ ze̱k u̱t-kus tu̱ no̱ de̱ u̱t-wa. ");
INSERT INTO gel_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gwatu̱n no i do̱m u-ru̱. E̱ no̱m-u̱t ku̱w da. E̱ no̱m-u̱t ket da. E̱ cin-u̱t u̱r-bya da. Napu̱n u̱zu̱ U̱so-u no̱ wu̱ do̱m u-ru̱, wa re̱gu̱sse̱ e̱, wa de̱ ya'u̱ no̱ no̱m-u̱ no̱ u̱t-sa no̱ nom-u̱t u̱r-yu̱. No̱ ze̱k no u-so u-tát! ");
INSERT INTO gel_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Wana u̱ te̱k-u̱ me̱ no̱ u̱ remu̱ namu̱ jab wa de̱ keru̱ swu̱ru̱ hi-u̱r wa, u-kwam u-gan u̱ te̱k-u̱ ru̱t-u̱t wa? ");
INSERT INTO gel_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","<<¿U̱ remu̱ yan o̱ no̱ o̱tte̱ u̱ na-su̱ jab-u̱ remu̱ u̱t-kus tu̱ no̱ de̱ u̱t-wa? Gwatu̱n pyak-u̱t tu̱ u̱r-do̱g u̱ka to̱ hopte̱ u̱ ne̱n. To̱ no̱m-u̱t m-to̱k ko̱ u-te̱ u̱t-kus da. ");
INSERT INTO gel_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","U̱m o̱ u̱ waru̱ no̱, ko̱ Suremanu Faru̱k-u̱ m-sek, wa tamu̱g no̱m-du̱ u̱t-u̱k ba pyak-u̱t du̱ u̱r-gan da! ");
INSERT INTO gel_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","A shu̱'u̱te̱ u̱zu̱ Ru̱-u̱ de̱ no̱mu̱ gwa-su̱ u̱r-do̱g u̱t-u̱k su̱ o̱ye̱ u̱zu̱ u̱ ya-o̱ se̱ o̱ye̱, u-sot u̱ na gu̱n se̱ u-ra, za u-sakna Ru̱-u̱ de̱ ya'u̱ no̱ cwu̱-tu̱ m-wa. No̱ a-yadu̱ jab ne̱ cashi! ");
INSERT INTO gel_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","U̱ remu̱ iya, a no̱ naas jab u̱zu̱, <¿yan-o̱ it de̱ u̱t-re̱?> Ko̱ <¿yan-o̱ it de̱ u̱t-swa?> Ko̱ <¿yan-o̱ in do̱'e̱ u̱t-wa'e̱?> ");
INSERT INTO gel_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","I nape̱ ne̱ u-Ru̱ da, e̱ u̱t-sa no̱m-u̱t to̱. U̱so-u no̱ wu̱ o̱ye̱ u̱ do̱m u-ru̱ wa nak u̱zu̱ no̱ u̱t-sa no̱m-u̱t to̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Se̱di no̱m-u̱ ze̱ge̱ u̱r-zwar, no̱ sa' faru̱k-du̱ u-Ru̱ u̱ no̱m-u̱t so̱-to̱ wa ne̱, no̱m-u̱t to̱ u̱t-be̱e̱t wa ya'u̱ no̱ to̱. ");
INSERT INTO gel_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","U̱ remu̱ iya, a no̱ naas jab-u̱ remu̱ u-sot da, sot-u̱ de̱ haan u̱ to̱k-m wa ne̱. Ko̱-uyan ho̱-de̱ to̱k-m wa ko̱rge̱ wa. ");
INSERT INTO gel_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","<<A no̱ kwu̱pu̱ waku̱n u̱s-rem da, tas na kwu̱pu̱ no̱ u̱s-rem da. ");
INSERT INTO gel_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Remu̱ zu̱, ka no̱ kwu̱pte̱ u̱t-ne̱t u̱s-rem, iya o̱ Ru̱-u̱ do̱te̱ u̱ kwu̱pu̱ no̱. Ko̱k-du̱ no̱ mu̱'u̱ste̱ u̱t-ne̱t, de̱ Ru̱-u̱ do̱te̱ mu̱su̱ no̱. ");
INSERT INTO gel_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","<<¿Remu̱ u-yan o̱ bo̱ o̱tte̱ u̱ gwat-du̱ pyar i-te o̱ is-du̱ o̱r-u̱ ró, bo̱ hak bo̱, bo̱ gwat king-u̱ o̱ u̱ is-u̱r ró da? ");
INSERT INTO gel_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Tu̱msu̱ re̱ne̱ o̱ bo̱ do̱te̱ zu̱ o̱r-u̱ ró, <Yage̱ u̱m has-tu̱ bo̱ pyar i-te u̱ is-u̱r ró,> bo̱ ya hen u-king ne̱ u̱-me̱ u̱ is-u̱r ró? ");
INSERT INTO gel_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Bo̱ wa ha-mu̱ u̱r-no̱, ba m-has king-u̱ o̱ u̱-me̱ is-u̱r ró, da-u o̱ bo̱ de̱ u̱t-hyan u̱r-zwar ne̱, bo̱ haste̱ pyar i-te i o̱ is-du̱ o̱r-u̱ ró. ");
INSERT INTO gel_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","<<A no̱ nya' o̱' no̱m-tu̱ u-he̱n tu̱ u-Ru̱ da. A no̱ no̱me̱ iya, e̱ u̱t-byu̱ru̱n e̱ yap no̱ ko̱ ho̱nsu̱ no̱. Tu̱msu̱ a no̱ gwu̱nu̱ u̱t-are̱de̱ no̱m-tu̱ shik da, remu̱ u̱zu̱ e̱ de̱ jangu̱ to̱ u̱s-na. ");
INSERT INTO gel_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","<<No̱mo̱n u̱s-ko̱n, na de̱ ya'u̱ no̱; sa'an no̱, de̱ u̱t-kwu̱m; ko̱to̱n u-is, na de̱ u̱ up-su̱ no̱. ");
INSERT INTO gel_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Remu̱ zu̱ ko̱wana ko̱ne̱ na ya'u̱ wa; ko̱wana de̱ u̱t-sa wa u̱t-kwu̱m; tu̱msu̱ ko̱wana ko̱o̱te̱ u-is na up-su̱ wa. ");
INSERT INTO gel_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","<<¿Wana u̱ te̱k-u̱ me̱ no̱, wu̱ wa'-u̱ wa de̱ ko̱n-du̱ wa u̱r-be̱re̱di, se̱ wa ya' wa u̱r-ta'ar re? ");
INSERT INTO gel_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Ko̱ a wa'-u̱ wa u̱ ko̱n wa u-jan wa ya' wa u-fa? ");
INSERT INTO gel_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","No̱ o̱ye̱ ne̱t-u̱t yo̱-to̱, no̱ nak yadu̱ no̱m-u̱t so̱-to̱ u̱du̱ ya'ag-u̱ no̱. Re̱ne̱ o̱ do̱te̱ u̱t-shu̱'u̱t, U̱so-u no̱ wu̱ o̱ do̱m u-ru̱, wa de̱ yadu̱ no̱m-u̱t so̱-to̱ u̱du̱ i o̱ ko̱n-du̱ wa! ");
INSERT INTO gel_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","No̱m-tu̱ no̱ o̱ u̱t-sa u̱ ne̱t-tu̱ no̱mu̱ no̱, no̱mu̱n e̱ iya, iya o̱ Mosa u̱ a-warru̱ rem-su̱ u-Ru̱ pu̱nte̱ m-tumb ne̱. ");
INSERT INTO gel_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","<<Cwaan u̱ is-u re̱k-ya. U̱m zu̱u̱g iya remu̱ u̱zu̱ is-yu̱ hu̱ye̱ u̱ be-u̱r yo̱-de̱ ya o̱ m-hu̱k ne̱. Tu̱msu̱ fu̱n-u ya o̱tte̱ m-ku̱k mu̱ u̱t-do̱r, i o̱ye̱ u̱r-cwa u̱ fu̱n-u ya e̱ o̱ u-tát. Is-u ya hu̱u̱t u̱t-ne̱t u-me̱ bu-u u-ra. ");
INSERT INTO gel_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tu̱msu̱ is-yu̱ ha-mu̱ be-du̱ u̱r-fat, ya o̱ re̱k-ya. Fu̱n-u ya tu̱msu̱ na so u̱r-ko̱b u̱ do̱rru̱ ya. I o̱ u̱ do̱rru̱ ya e̱ za u̱ u-tát da. ");
INSERT INTO gel_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","<<No̱mo̱n ga' u̱ a-warru̱ rem-su̱ u-Ru̱ ne̱ i u̱s-bi ne̱, i de̱ haan u̱du̱ no̱ u̱ka ca u̱ hyan-mu̱ u-shu̱, se̱di u̱ me̱n-tu̱ me̱, e̱ o̱ u̱ka go'. ");
INSERT INTO gel_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","No̱ napu̱ u̱n remu̱ no̱m-tu̱ u̱n o̱ u̱t-no̱m. ¿Ne̱t-tu̱ ka ya-tu̱ inabi u̱ war-u̱ u-hir, ko̱ ya-tu̱ u-bab u̱ war-u̱ te-yu̱ tu̱ntu̱r? ");
INSERT INTO gel_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Iya hen te̱-u so̱-ya, ya mu̱t ya'at so̱-to̱, te-yu̱ za so̱-ya da ya mu̱t ya-tu̱ za so̱-to̱. ");
INSERT INTO gel_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Te̱-u so̱-ya ya za mat-du̱ ya'at so̱-to̱ da, iya o̱ tu̱msu̱ te̱-u yo̱-ya, ya za ke̱rru̱ mat-du̱ ya'at so̱-to̱ da. ");
INSERT INTO gel_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ko̱-uyan te-ya yu̱ mate̱ ya'at so̱-to̱ da, na de̱ kup-su̱ ya, na guns ya u-ra. ");
INSERT INTO gel_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Iya o hen, no̱ napu̱ a-warru̱ rem-su̱ u̱s-bi remu̱ no̱m-tu̱ u̱n o̱ u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","<<Za ko̱wana de̱ fag-du̱ me̱, <Wa-ko-uyan, Wa-ko-uyan,> wa de̱ cwa-du̱ faru̱k-du̱ u-Ru̱ da. Se̱ wu̱ no̱me̱ no̱m-tu̱ U̱so-u ri wu̱ o̱ye̱ u̱ do̱m u-ru̱ o̱ u̱t-cwan. ");
INSERT INTO gel_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","U̱ ho̱-du̱ kwu̱p-du̱ u̱s-rem, e̱ke̱n do̱'e̱ u̱t-zu̱, <Wa-ko-uyan! Wa-ko-uyan! It no̱mu̱g u̱t-bu̱t u̱ te̱k-u̱ dim-u̱r ró, it yu̱n no̱m u̱s-te u̱ te̱k-u̱ dim-u̱r ró tu̱msu̱ it no̱m no̱m-tu̱ m-shin tu̱-yat-to̱ u̱ te̱k-u̱ dim-u̱r ró> ");
INSERT INTO gel_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","U̱ da-u o̱ u̱m de̱ zu̱ u̱n, <U̱m nak no̱ da. Hatu̱n du̱gu̱ kit-u̱ ri no̱ a no̱m-du̱ no̱m-u̱t yo̱-to̱ ne̱!> ");
INSERT INTO gel_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","<<U̱ remu̱ iya, ko̱wana ho̱ge̱ re̱m-u̱s ri, wa dor se̱, wa o̱ ba wa u̱s-ve̱ru̱ wa, wu̱ maye̱ bu-u wa u̱ do̱m-u̱ po̱k u-ta'ar. ");
INSERT INTO gel_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Da-u̱ yu̱-u̱ kasne̱, gi-su̱ shi m-bu̱, mya-mu̱ yu̱nne̱ mo̱ gu̱p u-bu tu̱msu̱ o̱ he̱e̱g da. Remu̱ u̱zu̱ na maag o̱ u̱ do̱m-u̱ po̱k u-ta'ar. ");
INSERT INTO gel_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ko̱wana ho̱ge̱ re̱m-u̱s ri wa kagu̱b se̱ da, wa o̱ ba ragu̱ ne̱t-tu̱ wa, wu̱ maye̱ bu-u wa u̱ do̱m m-hereg. ");
INSERT INTO gel_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Da-u̱ yu̱-u̱ kasne̱, se̱ gi-su̱ shi m-bu̱, mya-mu̱ yu̱nne̱ mo̱ gu̱p u-bu, se̱ bu-u o̱ he, he̱-u̱r yo̱-de̱.>> ");
INSERT INTO gel_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Da-u̱ Ye̱so̱ tase̱ warru̱ no̱m-u̱t to̱, se̱ ban-du̱ u̱t-ne̱t hu̱ mu̱rimmo̱ u̱ remu̱ ko̱se̱-u̱t wa, ");
INSERT INTO gel_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","remu̱ zu̱ wa ko̱kse̱ u̱ te̱k-u̱ m-shin, za ba a-ko̱se̱-tu̱ re̱m-su̱ u-bo̱r ne̱ da. ");
INSERT INTO gel_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","17 Da-u̱ Ye̱so̱ cu̱zne̱ du̱gu̱ u̱r-ro̱r, ban-du̱ u̱t-ne̱t u-tát dor wa. ");
INSERT INTO gel_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Se̱ yaku̱n campa-ya kim, wa haan wa he u̱t-jwu̱n u̱ shu̱ Ye̱so̱ wa zu̱, <<U̱so-u̱ u-bu ri, a-bo̱ cwane̱, bo̱ u̱t-kere̱ bo̱ haste̱ me̱ m-kim.>> ");
INSERT INTO gel_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ye̱so̱ jaku̱s kom-u wa wa tu̱m wu̱n, wa zu̱, <<U̱m cwanu̱g, bo̱ kum m-yar!>> Za rem, se̱ kim-mu̱ yagu̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Se̱ Ye̱so̱ zu̱ wu̱n, <<Gwat, a-bo̱ waru̱ waku̱n da, se̱di bo̱ do̱'e̱ bo̱ ko̱se̱ hi-du̱ war ró u̱du̱ yu̱-Yat-ya a-to̱o̱g-ne̱, tu̱msu̱ bo̱ no̱m u-nya u̱ka bo̱r-u̱t Mosa ko̱ste̱ u̱-me̱ re̱m-su̱ u-bo̱r, u̱zu̱ bo̱ no̱m iya u̱ ko̱ste̱ u̱zu̱ bo̱ kwu̱mu̱g m-yar.>> ");
INSERT INTO gel_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Da-u̱ Ye̱so̱ cwaane̱ u̱ Kapanahum se̱ yu̱-shu̱ karma-ne̱ yu̱ Roma, wa haan wa ko̱n wu̱n u̱zu̱, ");
INSERT INTO gel_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","<<Wa-m-nap, to̱k-u ri wa o̱ m-ru̱t u-bu wa kerte̱ u̱s-zo̱o̱g da, wa o̱ swadu̱ u̱r-ko̱b.>> ");
INSERT INTO gel_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ye̱so̱ zu̱, <<Me̱ u̱t-haan U̱m ya wu̱n m-yar.>> ");
INSERT INTO gel_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Se̱ karma-yu̱ zu̱ wu̱n, <<Wa-m-nap, u̱m ko̱rge̱ bo̱ haan u̱ bu-u ri da. Se̱di bo̱ no̱m u̱s-rem du̱gu̱ ana, to̱k-u ri wa u̱t-kwu̱m m-yar. ");
INSERT INTO gel_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","U̱m zu̱u̱g iya, remu̱ zu̱ u̱m o̱ te̱k u̱r-faru̱k du̱ hi-du̱ war ri, tu̱msu̱ u̱m o̱tte̱ karma-ne̱ u̱ ta'u̱ ri a u̱m zu̱ye̱ warmo, <No̱k,> se̱ wa no̱k, u̱m zu̱ warmo <Haane̱,> wa u̱t-haan, u̱m zu̱ to̱k-u̱ ri wa <No̱m inya,> wa u̱t-no̱m.>> ");
INSERT INTO gel_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Da-u̱ Ye̱so̱ ho̱ge̱ iya se̱ wa nom mu̱rimmo̱, wa zu̱ ne̱t-tu̱ o̱ do̱rru̱ wa, <<U̱m o̱ waru̱ no̱ u̱t-nip, ko̱ te̱k-u̱ Isra-ne̱ u̱m tamu̱g hyan-du̱ wa yadu̱ jab ba campa-u inya da. ");
INSERT INTO gel_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","U̱m o̱ waru̱ no̱, u̱ te̱k-u̱ a-yadu̱ jab ne̱ u̱ me̱ e̱ de̱ u̱t-haan du̱gu̱ u-ta u-do̱m ne̱, e̱ u̱t-shu̱'u̱t e̱ re no̱m u̱t-re̱ u̱r-kot e̱ Ibrahi u̱ Ishaku u̱ Yakubu ne̱ u̱ teku̱ Faru̱k-du̱ do̱m u-ru̱. ");
INSERT INTO gel_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","No̱ ne̱t-tu̱ Isra-ne̱, Ru̱-u̱ de̱ gwu̱n-du̱ no̱ u̱-me̱ u-cwu̱m, u̱ be-du̱ u̱s-kan sok u̱ ep-mu̱ nin ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Se̱ Ye̱so̱ zu̱ yu̱-shu̱ karma-yu̱ Roma, <<No̱k, na no̱ngu̱ bo̱ ka bo̱ o̱tte̱ u̱ssa remu̱ yadu̱ jab-u̱ ró.>> Za rem to̱k-u̱ wa kum m-yar. ");
INSERT INTO gel_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Da-u̱ Ye̱so̱ cwaye̱ u̱ bu-u Biturus se̱ wa he̱n ino-u ne̱ta Biturus m-ru̱t u-yu̱n hyam-u̱ o̱tte̱ wa. ");
INSERT INTO gel_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Se̱ Ye̱so̱ tu̱m kom-u wu̱n, se̱ hyam-u̱ yage̱ wu̱n. Se̱ wa yu̱ne̱ wa no̱mu̱ u̱n nom-u̱t re̱. ");
INSERT INTO gel_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Da-u̱ rim-mu̱ tore̱, se̱ ne̱t-tu̱ hatu̱n Ye̱so̱ i no̱m u̱s-te shipse̱ wa buz no̱m u̱s-te u̱ re̱m-su̱ nu-u wa. Tu̱msu̱ wa hast u̱t-ne̱t u̱t-be̱e̱t u̱s-go̱m. ");
INSERT INTO gel_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Wa no̱mu̱g iya u̱ remu̱ na shu̱u̱ste̱ no̱mu̱ wa-warru̱ rem-su̱ u-Ru̱ Ishaya zu̱ye̱, <<Wa ku̱bu̱ste̱ go̱m-u̱s in, wa hast ko̱b-du̱ m-yaru̱ in.>> ");
INSERT INTO gel_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Da-u̱ Ye̱so̱ hyane̱ ban-du̱ u̱t-ne̱t gu̱nu̱ste̱ wa, se̱ wa zu̱, <<Yagu̱n in pasu̱n u̱ din-de̱ jit gwu̱g-du̱ m-sa de̱.>> ");
INSERT INTO gel_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Se̱ wa ko̱se̱-tu̱ re̱m-su̱ u-bo̱r haan wa zu̱ wu̱n, <<Wa-u̱t-ko̱se̱, me̱ do̱ru̱ bo̱ ko̱he̱ne̱ bo̱ o̱tte̱ m-ha.>> ");
INSERT INTO gel_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Se̱ Ye̱so̱ zu̱ wu̱n, <<O̱' u̱r-do̱g o̱tte̱ u̱s-hu̱ su̱ m-roog, no do̱m u-ru̱ o̱tte̱ u̱t-tu̱ku̱s tu̱ m-roog, se̱di Wa'-u̱ Ne̱t zatte̱ be-du̱ res-du̱ hi-u̱r wa da.>> ");
INSERT INTO gel_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Waku̱n u̱ te̱k-u̱ a-doru̱ Ye̱so̱ ne̱ wa zu̱ wu̱n, <<Wa-m-nap, yage̱ u̱m do̱'e̱ u̱m jwaku̱n u̱so-u ri u-ro.>> ");
INSERT INTO gel_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Se̱ Ye̱so̱ zu̱ wu̱n, <<Do̱rnu̱ me̱, yage̱ i mare̱, e̱ jwak o̱ru̱t e̱ marimari ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Da-u̱ Ye̱so̱ cwaye̱ u-hat, a-doru̱ wa dor wu̱n. ");
INSERT INTO gel_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Se̱ mya-mu̱ yu̱nne̱ u̱r-be̱b ne̱ u̱-me̱ m-sa se̱ bu̱-mu̱ hu̱ m-cwa u-hat. Tu̱msu̱ Ye̱so̱ o̱ m-roog. ");
INSERT INTO gel_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Se̱ u̱n do̱'e̱, u̱n yu̱ns wa, u̱n zu̱, <<Wa-m-nap, u̱kru̱ in! In do̱'e̱ u̱t-is m-bu̱!>> ");
INSERT INTO gel_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Se̱ wa zu̱ u̱n, <<¿Remu̱ yan-o̱ no̱ o̱tte̱ u̱ ho̱g-du̱ u-gye̱r, no̱ a-yadu̱ jab ne̱ cashi?>> Se̱ wa yu̱nne̱ wa hagu̱sse̱ m-mya u̱ jwak m-bu̱ ne̱ se̱ mo̱ ho u̱s-ram te̱k. ");
INSERT INTO gel_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Se̱ ne̱t-tu̱ hu̱ u̱ mu̱rimmo̱ e̱ zu̱, <<¿Yan ne̱t wa unwa wu̱ mya-mu̱ ho̱ge̱ re̱m-u̱s wa u̱ jwak m-bu̱ ne̱?>> ");
INSERT INTO gel_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Da-u̱ wa teene̱ u̱ dak-u̱ Gadari, se̱ e̱ke̱n campa-ne̱ yu̱r i no̱m-u̱s u̱s-te̱ shipe rwu̱u̱n u̱ be-du̱ u̱t-sag e̱ bit wu̱n. E̱ no̱ng u̱ yo̱-ye̱ sok, e̱ yu̱u̱t u̱ ne̱t-tu̱ do̱r fu̱n-u ya da. ");
INSERT INTO gel_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Za rem e̱ he̱e̱se̱ u̱t-jar e̱ zu̱, <<¿Bu̱-m ró yu̱ u̱ it ne̱ Wa'-u̱ u-Ru̱? ¿Bo̱ haagu̱n bo̱ ya it u̱r-ko̱b kanda da-u̱ no̱me̱?>> ");
INSERT INTO gel_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nu̱ku̱stu̱n sok u̱ku̱n ne̱ da, ban-du̱ u̱t-are̱de̱ o̱ u̱t-re̱e̱g. ");
INSERT INTO gel_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Se̱ no̱m u̱s-te kon Ye̱so̱ e̱ zu̱, <<A-bo̱ ruut it da, yage̱ it cwa u̱-me̱ ban-du̱ u̱t-are̱de̱.>> ");
INSERT INTO gel_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Se̱ wa zu̱, <<No̱ko̱n no̱ cwa u̱-me̱ u̱t-are̱de̱.>> Se̱ ban-du̱ u̱t-are̱de̱ u̱t-be̱e̱t to̱ ru m-so̱m to̱ irig du̱gu̱ u-pingse̱ m-he̱ u̱-me̱ m-sa bu̱-mu̱ rees to̱. ");
INSERT INTO gel_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Se̱ a-gwat-du̱ u̱t-are̱de̱ ne̱, e̱ som m-mu̱ u-bo̱ e̱ wu̱r no̱m-tu̱ kume̱ i o̱tte̱ no̱m u̱s-te. ");
INSERT INTO gel_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Se̱ ne̱t-tu̱ u-bo̱ u-be̱e̱t e̱ rwu̱u̱n u̱ remu̱ e̱ hyen-u̱t Ye̱so̱. Da-u̱ u̱n hyane̱ wa, u̱n kon wa yage̱ dak-u u̱n. ");
INSERT INTO gel_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ye̱so̱ cwaag u̱-me̱ u-hat, wa pu̱s m-ha u̱ Kapanahum u̱ bo̱-u wa. ");
INSERT INTO gel_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ne̱t-tu̱ hatu̱n wu̱n wa go̱m-su̱ m-ryam m-ru̱t u̱r-wu̱ndi. Da-u̱ Ye̱so̱ hyane̱ yadu̱ jab-u̱ u̱n, se̱ Ye̱so̱ zu̱ wu̱ o̱tte̱ u̱s-go̱m, <<Wa zwar, a-bo̱ naas jab da, na haste̱ bo̱ ba'as-u̱t ró.>> ");
INSERT INTO gel_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Da-u̱ a-ko̱se̱-tu̱ u-bo̱r ne̱ ho̱ge̱ iya, se̱ e̱ zu̱, <<Ne̱t unwa o̱ warru̱ rem-su̱ u̱t-ba'as! ¿Wa o̱ m-hyan u̱ka zu̱ wa o̱ u-Ru̱?>> ");
INSERT INTO gel_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ye̱so̱ nak no̱m-u̱ o̱ jab-u̱s u̱n, se̱ wa zu̱ u̱n, <<¿Remu̱ u-yan o̱ no̱ o̱tte̱ dorog-u̱s yo̱-se̱ u̱ jab-u̱s no̱? ");
INSERT INTO gel_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Yan-o̱ ze̱ge̱ m-ku̱ke na zu̱ ne̱t, <Na haste̱ wa u̱t-ba'as,> ko̱ na zu̱, <Yu̱ne̱ bo̱ ha m-ha>? ");
INSERT INTO gel_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","U̱m u̱t-sa no̱ nap u̱zu̱, Wa'-u̱ Ne̱t o̱tte̱ m-shin mu̱ hastu̱ ba'as-tu̱ ne̱t-u̱ dak-u uno̱.>> Se̱ wa zu̱ wa go̱m-su̱ m-ryam, <<Yu̱ne̱ bo̱ kab wu̱ndi-u̱r ró bo̱ mu u-bu.>> ");
INSERT INTO gel_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Campa-u ya yu̱ne̱ wa aru̱k m-mu̱ u-bu. ");
INSERT INTO gel_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Da-u̱ ban-du̱ u̱t-ne̱t hyane̱ iya, e̱ hog u-gye̱r, e̱ no̱mu̱ u-Ru̱ u̱t-vam wu̱ ya' u̱t-ne̱t go̱-du̱ mo̱mo̱ shin-mo̱. ");
INSERT INTO gel_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Da-u̱ Ye̱so̱ re̱ u-shu̱ m-ha ne̱, se̱ wa hyen yaku̱n campa-ya, wu̱na foge̱ Matiyu, wa o̱ shu̱'u̱t u̱ o̱nk-u̱ shik-u̱ tar. Se̱ Ye̱so̱ zu̱ wu̱n, <<Do̱rnu̱ me̱.>> Se̱ wa yu̱ne̱ wa do̱r Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","A sure̱ m-wa'as, Ye̱so̱ o̱ u-re̱ u̱ bu-u Matiyu, se̱ a-o̱nku̱ shik-u̱ tar u̱ a-u̱t-ba'as-ne̱ haan e̱ shu̱'u̱t e̱ nom u-re̱ u̱ be-du̱ wa o̱tte̱ u̱ a-doru̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Da Farisa-ne̱ hyane̱ iya, se̱ e̱ zu̱ a-doru̱ wa, <<¿Remu̱ u-yan o̱ wa-u̱t-ko̱se̱ no̱ o̱tte̱ u-re̱ u̱ a-o̱nku̱ shik-u̱ tar ne̱ u̱ a-u̱t-ba'as-ne̱?>> ");
INSERT INTO gel_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Da-u̱ Ye̱so̱ ho̱ge̱ iya, se̱ wa zu̱, <<A-m-yar ne̱ za u̱ssa wa u̱s-baat da, se̱di a-ko̱b-du̱ m-yar ne̱. ");
INSERT INTO gel_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","No̱ko̱n no̱ iis nap-mu̱ re̱m-su̱ u-Ru̱ su̱ zu̱ye̱, <Ho̱g-du̱ u̱r-o̱n de̱ u̱m u̱t-sa, za to̱o̱g da.> Remu̱ zu̱ u̱m haagu̱n u̱m fag a-jab-u̱s so̱-se̱ ne̱ da, se̱di a-u̱t-ba'as.>> ");
INSERT INTO gel_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","A-doru̱ Yohanna haan u̱du̱ Ye̱so̱ e̱ zu̱, <<¿Yan-o̱ wu̱te̱ it u̱ Farisa-ne̱ be̱e̱t it no̱m u-swaat, se̱di a-doru̱ ró no̱m-u̱t da?>> ");
INSERT INTO gel_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ye̱so̱ zu̱ u̱n, <<Hu̱u̱b-tu̱ zwar u̱r-gu̱ no̱m-u̱t namu̱ jab da-u̱ wa u̱r-kot u̱ u̱n ne̱ da. Se̱di da-u̱ o̱o̱n u̱ na do̱te̱ kab-du̱ wu̱n u̱ teku̱ u̱-me̱ u̱n, Da-u o̱ u̱n de̱ no̱m-du̱ u-swaat.>> ");
INSERT INTO gel_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","<<Waku̱n zaar wu̱ de̱ kara-du̱ to̱ggo̱-yu̱ u-ut u̱ kus-u po-o̱ da, remu̱ zu̱ ana jaase̱ to̱ggo̱-u ya kara-u̱r re̱ de̱ u̱t-kees, ke̱-u̱t to̱ he̱n u̱t-ze̱g u̱r-taku̱n m-yo̱. ");
INSERT INTO gel_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Waku̱n zaar wu̱ de̱ dasu̱ ke̱' po-ye̱ u̱ me̱n-tu̱ ut-u̱r shar-du̱ u-ka da. A wa no̱mu̱ iya ke̱' po-ye̱ de̱ yo̱gu̱sse̱ shar-du̱ u̱r-ut du̱ u-ka, u̱ bu̱-mu̱ ke̱' azu̱g, shar-du̱ u-ka de̱ nu̱u̱s. Bu̱-m po-mo̱ mu̱ ke̱' na da'as mo̱ u̱ shar-u̱r po-de̱ du̱ u-ka. Bu̱-mu̱ ke̱ po'ye̱ na daas mo̱ u̱ sharru̱ u-ka du̱ po-de̱ u̱ka mo̱ zatte̱ u̱t-agu̱z da.>> ");
INSERT INTO gel_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ye̱so̱ o̱ te̱k-u̱ waru̱ u̱n iya, se̱ te̱k-u̱ tu̱-shu̱ bu-u̱ u̱t-ko̱se̱ u̱ Yahuda-ne̱ haan wa he u̱t-jwu̱n u̱ shu̱ Ye̱so̱ wa zu̱, <<Wa'-u̱ ri wa'-u̱-gwu̱p maru̱g za m-tumb, se̱di haane̱ bo̱ tam wu̱n, wa u̱t-yu̱ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ye̱so̱ yu̱ne̱ u̱ a-doru̱ wa ne̱, e̱ do̱r campa-u ya. ");
INSERT INTO gel_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na o̱ u̱ te̱k-u̱ se̱, yaku̱n ne̱ta-ya wu̱ no̱me̱ u̱s-hak o̱p-u̱s yu̱r 12, wa o̱ pama wu̱du̱ m-hyu̱, wa haan wa tu̱m kwak-yu̱ to̱ggo̱-u Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ne̱ta-yu̱ no̱ng iya remu̱ zu̱ wa cu̱nu̱g u̱ jab-u̱ wa u̱zu̱, <<A u̱m tame̱ to̱ggo̱-u Ye̱so̱ me̱ u̱t-kwu̱m m-yar.>> ");
INSERT INTO gel_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Da-u̱ Ye̱so̱ bire̱ wa got wu̱n, se̱ wa zu̱, <<Ne̱ta, a-bo̱ naas jab da, yadu̱ jab-u̱ ró yaag bo̱ m-yar.>> Za rem ne̱ta-yu̱ kum m-yar. ");
INSERT INTO gel_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Da-u̱ Ye̱so̱ cwaye̱ bu-u̱ yu̱-Yat-ya yu̱ Kur-u̱ u̱t-Ko̱se̱, wa bit ne̱t-ne̱ u̱t-jar u̱ fu̱u̱-du̱ se̱p-tu̱ m-mar ne̱. ");
INSERT INTO gel_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Wa zu̱, <<Yu̱nu̱n u̱ ane̱, wa'-u̱-gwu̱p maru̱g da, roog-mo̱ wa o̱tte̱.>> E̱ hu̱ no̱mu̱ wu̱n nu̱mu̱s-tu̱ u̱s-ju̱ru̱m. ");
INSERT INTO gel_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Da-u̱ ne̱t-tu̱ ru̱ye̱ u̱-do̱, se̱ wa to̱, wa ship kom-u̱ wa'-u̱-gwu̱p, za rem wa yu̱ne̱! ");
INSERT INTO gel_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Rem-su̱ no̱m-u o̱ te̱ ko̱he̱ne̱ u̱-me̱ dak-u o̱. ");
INSERT INTO gel_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ye̱so̱ o̱ yagu̱ be-u̱r re̱, se̱ e̱ke̱n po̱-ne̱ yu̱r hu̱ fag-u̱s rò u̱zu̱, <<Wa'-u̱ Dawuda ho̱g o̱n-u̱r it!>> ");
INSERT INTO gel_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Da-u̱ Ye̱so̱ cwaye̱ u̱-me̱, se̱ po̱-ne̱ e̱ haan u̱du̱ rò. Se̱ wa zu̱ u̱n, <<¿No̱ yaag jab u̱zu̱ me̱ ke̱ru̱ yan-o̱ m-yar?>> E̱ zu̱ wu̱n, <<Wa-m-nap, it o̱ yadu̱ jab.>> ");
INSERT INTO gel_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Se̱ wa tu̱m is-u̱ u̱n, wa zu̱, <<U̱ remu̱ yadu̱ jab-u̱ no̱, na ya'ag no̱ m-yar.>> ");
INSERT INTO gel_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Da-u̱ is-u̱ u̱n upse̱, Ye̱so̱ no̱mu̱ u̱n u̱t-him u̱zu̱, <<A no̱ waru̱ waku̱n da.>> ");
INSERT INTO gel_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Da-u̱ e̱ ruye̱, e̱ hu̱ warru̱ rem-u̱s se̱ ko̱he̱ne̱, u̱-me̱ dak-u o̱. ");
INSERT INTO gel_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Da-u̱ e̱ o̱ mo̱ttu̱ u̱r-aru̱k, se̱ ne̱t-tu̱ hattu̱n waku̱n wu̱ o̱tte̱ no̱m u̱s-te u̱du̱ Ye̱so̱ tu̱msu̱ wa kerte̱ u̱s-rem da. ");
INSERT INTO gel_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Da-u̱ na rute̱ no̱m u̱s-te, se̱ campa-u ya he̱e̱se̱ u̱s-rem. Mo̱ro̱g-du̱ u̱t-ne̱t hu̱ mu̱rimmo̱, e̱ zu̱, <<Na tamu̱g hyan-du̱ o̱ko̱n no̱m-u̱ inya u̱-me̱ Isra da, se̱ u̱ ya-o̱.>> ");
INSERT INTO gel_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Se̱ Farisa-ne̱ zu̱, <<U̱ be̱b-du̱ faru̱k-u̱ no̱m u̱s-te de̱ wa o̱tte̱ rutu̱ no̱m u̱s-te.>> ");
INSERT INTO gel_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ye̱so̱ do̱r u̱t-bo̱ u̱t-taas ne̱ u̱t-be̱e̱t, wa o̱ no̱mu̱ ne̱t-ne̱ u̱t-ko̱se̱, u̱-me̱ bu-u̱ u̱t-ko̱se̱ u̱ Yahuda-ne̱, wa o̱ bu̱t-tu̱ Rem-su̱ m-Re̱me̱r su̱ Faru̱k-du̱ u-Ru̱, wa o̱ tu̱msu̱ hastu̱ ne̱t-ne̱ u̱s-go̱m su̱ ko̱-uyan re̱-mo̱. ");
INSERT INTO gel_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Da-u̱ wa hyane̱ ne̱t-tu̱ mo̱ro̱gte̱ u-tát, se̱ wa ho̱g o̱n-u̱r u̱n, remu̱ zu̱, e̱ o̱ swadu̱ u̱r-ko̱b, za wa u̱r-se̱ge̱, u̱ka ca i za wa-u̱t-got. ");
INSERT INTO gel_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Se̱ wa zu̱ a-doru̱ wa ne̱, <<Ket o̱ u-tát, se̱di a-ke̱t-ne̱ o̱ cashi. ");
INSERT INTO gel_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Remu̱ iya ko̱no̱n Wa-ko-uyan, wa to̱mto̱n a-ke̱t-ne̱ u̱ tak-u wa.>> ");
INSERT INTO gel_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ye̱so̱ fak a-doru̱ wa o̱p u̱ yu̱r 12. Wa yu̱' e̱ u̱r-faru̱k, e̱ ruut no̱m u̱s-te, tu̱msu̱ e̱ hast ko̱-uyan go̱mse̱ u̱ ko̱b-du̱ m-yar ne̱. ");
INSERT INTO gel_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tunto̱ to̱ o̱ dim-tu̱ a-to̱mu̱ Ye̱so̱ o̱p-u̱ yu̱r 12: Wa u̱r-taku̱n Simo̱n o̱r-u̱ wu̱na foge̱ Biturus, u̱ O̱r-u̱ wa ne̱ Andarawus, u̱ Yakubu wa'-u̱ Zabadi u̱ O̱r-u̱ wa Yohanna, u̱ ");
INSERT INTO gel_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Firibi, u̱ Bataromi, u̱ Tomas, u̱ Matiyu ne̱ wa-o̱nku̱ shik-u̱ tar, u̱ Yakubu wa'-u̱ Aru̱payes, u̱ Tadiyus ne̱, u̱ ");
INSERT INTO gel_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simo̱n wa shu̱b-du̱ u-dak, Yahudas Iskariyoti ne̱ wu̱ yasu̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ye̱so̱ to̱mo̱g a-doru̱ wa o̱p-u̱ yu̱r, wa zu̱ e̱, <<A no̱ cwa u̱ bu-u̱ a-za Yahuda-ne̱ da, tu̱msu̱ a no̱ cwa u̱ o̱ko̱n bo̱-o̱ u̱ Samariya-ne̱ da. ");
INSERT INTO gel_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Se̱di no̱ do̱'e̱ u̱du̱ ne̱t-tu̱ Isra i o̱ u̱ka ca i e̱nke̱. ");
INSERT INTO gel_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","De̱'e̱n no̱ no̱m u̱t-bu̱t u̱zu̱, <Faru̱k-du̱ u-Ru̱ o̱ u̱t-mo̱r!> ");
INSERT INTO gel_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","No̱ hast u̱t-ne̱t u̱s-go̱m, no̱ yu̱ns i mare̱ ne̱, no̱ hastu̱ ne̱t-ne̱ m-kim, tu̱msu̱ no̱ ruut no̱m u̱s-te. A no̱ o̱ se̱gu̱ u̱t-ne̱t a no̱ o̱nk shik da, remu̱ Ru̱-u̱ o̱nkte̱ shik da-u̱ wa se̱gu̱ no̱ da. ");
INSERT INTO gel_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","A no̱ kab shik ko̱ o̱ko̱n no̱m-o̱ u̱ka shik-u̱ no̱ do̱te̱ no̱m-du̱ o̱ko̱n u̱-me̱ ba-u̱t no̱ da. ");
INSERT INTO gel_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Tu̱msu̱ a no̱ kab ba-du̱ m-ha, ko̱ yaku̱n to̱ggo̱-ya da, a no̱ kab se̱ke̱n na-su̱ u̱t-ka'at u̱s-yu̱r da, ko̱ yaku̱n ko̱m-yu̱ m-ha da, remu̱ zu̱ wa u-pama u-be̱e̱t wa kamu̱g kwu̱m-du̱ to̱p-u̱ pama-u̱ wa no̱me̱ u̱-me̱ u̱t-ne̱t, remu̱ iya no̱ kwu̱mu̱ no̱m u̱t-re̱, u̱ to̱ko̱n no̱m-to̱ ne̱ u-me̱ ne̱t-tu̱ no̱ do̱'e̱ u̱du̱ e̱. ");
INSERT INTO gel_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","<<Bo̱-u̱ no̱ tote̱ ko̱ u-taas, sa'an ne̱t u̱r-ka, no̱ shu̱'u̱t u̱ wa ne̱ kanda no̱ yu̱ne̱ u̱r-aru̱k. ");
INSERT INTO gel_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bu-u̱ no̱ tote̱ u-be̱e̱t, no̱ vu̱ku̱s e̱. ");
INSERT INTO gel_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Bu-u̱ no̱ tote̱ u-be̱e̱t, a e̱ gu̱ no̱, no̱mu̱n u̱n u̱s-to̱o̱g u̱ Ru̱-u̱ ya u̱n ru̱s-du̱ jab, tu̱msu̱ bu-u̱ no̱ tote̱ a e̱ kabe̱ hamtu̱-u̱r no̱ da, Ru̱-u̱ za yadu̱ u̱n res-du̱ jab da. ");
INSERT INTO gel_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Wu̱ gu no̱ da u-be̱e̱t, ko̱ wa gu̱gu̱m re̱m-u̱s no̱, pamtu̱n huug-mu̱ u̱s-na no̱, no̱ ru u̱-me̱ bu-u o̱ ko̱ u-bo̱, u̱t-shu̱'u̱t u̱t-him u̱du̱ u̱n u̱zu̱ Ru̱-u̱ de̱ ya-du̱ u̱n u̱r-ko̱b ba u̱n gu̱gme̱ e̱rru̱ rem-u̱s no̱. ");
INSERT INTO gel_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","U̱m o̱ waru̱ no̱ u̱t-nip, Ru̱-o̱ u̱t-ze̱g m-ho̱g o̱n-du̱ ne̱t-tu̱ dak-u̱ Saduma u̱ Gomora ne̱, m-ze̱g ne̱t-tu̱ bo̱-u o̱ u̱ ho̱-du̱ kwu̱p-du̱ u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","<<U̱m o̱ to̱m-du̱ no̱, u̱ka ca u̱-me̱ go', remu̱ iya shu̱'u̱tu̱n a-u̱s-ve̱r-ne̱ u̱ka fa, tu̱msu̱ m-yar ne̱ u̱ka u̱r-gorop. ");
INSERT INTO gel_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","No̱mo̱n ga', u̱t-ne̱t ne̱, remu̱ zu̱ e̱ de̱ hu̱tu̱ no̱ u̱ bu-tu̱ kwu̱p-du̱ u̱s-rem, tu̱msu̱ e̱ no̱mu̱ no̱ u̱s-ryap u̱ bu-u̱ u̱t-ko̱se̱ u̱ Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Remu̱ zu̱ no̱ yaag jab u̱du̱ ri, u̱n de̱ hu̱u̱tu̱ no̱ u̱du̱ a-u-dak-ne̱ u̱ farkina-ne̱ u̱ remu̱ e̱ kwu̱p-tu̱ no̱ u̱s-rem tu̱msu̱ e̱ ya' no̱ u̱r-ko̱b. Yagu̱n u̱ shu̱'u̱t u̱r-ke̱r u̱du̱ no̱, remu̱ no̱ war-tu̱ farkina-ne̱ u̱ a-za Yahuda-ne̱ Re̱m-su̱ m-Re̱me̱r. ");
INSERT INTO gel_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Da-u̱ e̱ yasu̱ no̱, a no̱ ha u̱s-dorog u̱ remu̱ no̱m-u̱ no̱ de̱ u̱t-war da, remu̱ Yar u-Ru̱ o̱ do̱r-tu̱ no̱ u̱ no̱mu̱ no̱ de̱ u̱t-war. ");
INSERT INTO gel_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","U̱m zu̱u̱g iya remu̱ zu̱, a no̱ o̱ u̱s-rem da, Yar-u U̱so-u no̱ o̱ u̱s-rem u̱-me̱ no̱. ");
INSERT INTO gel_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","<<Ne̱t-tu̱ de̱ yasu̱ o̱r-u̱t e̱ na hoot, u̱so u̱ de̱ yasu̱ wa'-u̱ wa na hoot, ya'ag de̱ zwarnu̱ i matu̱ e̱ ne̱, e̱ wa na hoot e̱. ");
INSERT INTO gel_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ne̱t-ne̱ be̱e̱t, e̱ de̱ gu̱gmu̱ no̱ remu̱ do̱ro̱g me̱. Se̱di wu̱ gagu̱ jab m-ha m-vaste̱, wa u̱t-kwu̱m u-u̱ku̱r. ");
INSERT INTO gel_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","A e̱ o̱ yadu̱ no̱ u̱r-ko̱b u̱-me̱ o̱ko̱n bo̱-o̱, so̱mo̱n m-ha o̱ko̱n bo̱-o̱. U̱m o̱ waru̱ no̱ u̱t-nip, no̱ za u̱tte taas padu̱ bo̱-tu̱ Isra u̱t-be̱e̱t da, Wa'-u̱ Ne̱t de̱ mu̱u̱n. ");
INSERT INTO gel_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","<<Wa-u-iis zaru̱ ze̱gu̱ wa-u̱t-ko̱se̱ wa da, tu̱msu̱ to̱k ze̱k u̱so-u̱ bu-u wa da. ");
INSERT INTO gel_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Wa-u-iis u̱t-kere̱ u̱t-shu̱'u̱t ba wa-u̱t-ko̱se̱ wa tu̱msu̱ to̱k u̱t-kere̱ u̱t-shu̱'u̱t ba u̱so-u bu-u wa. Ana fage̱ u̱so u̱ u-bu faru̱ku̱ no̱m u̱s-te, u̱n de̱ fag-du̱ a-u-bu wa ne̱ ko̱'e̱ m-ze̱g iya! ");
INSERT INTO gel_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","<<A no̱ ho̱g gye̱r-u u̱t-ne̱t da, remu̱ zu̱ o̱ko̱n za u̱ o̱ u̱r-tage̱ u̱ na za u̱t-upus da, tu̱msu̱ o̱ko̱n za m-yasa u̱ na za u̱t-rwu̱tu̱n m-zu̱n da. ");
INSERT INTO gel_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","No̱m-u̱ u̱m o̱ waru̱ no̱ u-cwu̱m waru̱n o̱ m-zu̱n; tu̱msu̱ no̱m-u̱ u̱m waru̱ no̱ m-yasa, no̱mo̱n do̱nse̱-du̱ o̱. ");
INSERT INTO gel_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","A no̱ ho̱g gye̱r-u̱ i de̱ ho̱-du̱ u-war da, se̱di e̱ za ke̱rru̱ ho̱-du̱ yar-u ne̱t da. Ho̱go̱n gye̱r-u̱ wu̱ de̱ ho̱-du̱ yar-u̱ ne̱t u̱ war-u wa ne̱ tu̱msu̱ wa gun to̱ u̱-me̱ bu-u u-ra. ");
INSERT INTO gel_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Na bu̱b no yu̱r u̱ ko̱nko̱ shik u-gan. Ko̱ u-gan u̱ te̱k-u̱ me̱ u̱n ya za u̱t-he̱ u-dak za nap-du̱ U̱so-u no̱ wu̱ o̱ do̱m-u̱ u-ru̱ da. ");
INSERT INTO gel_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Wa o̱ u̱r-kot u̱ no̱ ne̱, ko̱ hi-su̱ hi-u̱r no̱ wa nak nu̱se̱ no̱ o̱tte̱ ");
INSERT INTO gel_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Remu̱ iya, a no̱ ho̱g u-gye̱r da. No̱ ze̱k no u̱so u-tát. ");
INSERT INTO gel_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","<<Wu̱ ko̱se̱ u̱zu̱ wa, wu̱ ri wa, u̱ te̱k-u̱ me̱ u̱t-ne̱t, ko̱ me̱, me̱ u̱t-ko̱se̱ wa wu̱ ri wa u̱ u̱du̱ U̱so-u ri wu̱ o̱ do̱m-u̱ u-ru̱. ");
INSERT INTO gel_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tu̱msu̱ wu̱ no̱me̱ se-m ri, u̱du̱ u̱t-ne̱t, ko̱ me̱, me̱ no̱mu̱ se-m wa u̱du̱ U̱so-u ri wu̱ o̱ me̱ do̱m-u̱ u-ru̱. ");
INSERT INTO gel_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","<<A no̱ kab u̱zu̱ ru̱s-du̱ jab de̱ u̱m hatu̱n u̱-me̱ u-dak da. U̱m hatu̱n res-du̱ jab da, se̱di van-u̱ m-wu̱r. ");
INSERT INTO gel_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","<<U̱m hagu̱n remu̱ u̱m samte̱. << <U-u̱so e̱ wa'-u̱ wa, wa'-u̱ gwu̱p tu̱msu̱ e̱ ino-u wa, U-ku̱mro, e̱ ku̱mu̱ wa. ");
INSERT INTO gel_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Hu̱u̱b-u̱t yo̱-to̱ ró de̱ u̱t-shu̱'u̱t u̱-me̱ ne̱t-tu̱ bu-u ró.> >> ");
INSERT INTO gel_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Se̱ Ye̱so̱ zu̱, <<Ne̱t be̱e̱t wu̱ ze̱ge̱ m-cwan uso-u wa ko̱ ino-u wa, m-ze̱g me̱, wa ko̱rge̱ wa shu̱'u̱t wa doru̱ ri da. Tu̱msu̱ wu̱ cwane̱ wa'-u̱ wa m-ze̱g me̱, wa ko̱rge̱ wa shu̱'u̱t wu̱ ri da. ");
INSERT INTO gel_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Wu̱ kabe̱ kan-u wa, wa do̱r me̱ da, wa ko̱rge̱ wa shu̱'u̱t ne̱tu̱ ri da. ");
INSERT INTO gel_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Wu̱ cwane̱ fat-u̱r wa, wa de̱ u̱t-taag u̱ de̱. Tu̱msu̱ wu̱ taage̱ u̱ fat-u̱r wa, u̱ remu̱ ri, wa de̱ kwu̱m-du̱ de̱. ");
INSERT INTO gel_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","<<Wu̱ kabe̱ no̱, wa kagu̱b me̱, tu̱msu̱ wu̱ kabu̱ me̱, wa kagu̱b wu̱ to̱mnu̱ me̱. ");
INSERT INTO gel_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wu̱ kabe̱ wa-warru̱ rem-su̱ u-Ru̱ remu̱ zu̱ wa o̱ wa-warru̱ rem-su̱ u-Ru̱, wa de̱ kwu̱m-du̱ to̱p-u̱ wa-warru̱ rem-su̱ u-Ru̱ du̱gu̱-du̱ u-Ru̱. Tu̱msu̱ wu̱ kabe̱ wa jab-u̱ so̱-o̱ remu̱ wa o̱ wa jab-u̱ so̱-o̱, wa de̱ kwu̱m-du̱ to̱p-u̱ wa jab-u̱ so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Wu̱ ya'e̱ ko̱k-du̱ bu̱-mu̱ m-tor, wa yu̱' u̱ te̱k-u̱ i-re̱k-e̱ ine̱, remu̱ zu̱ e̱ o̱ a-doru̱ ri, u̱m o̱ waru̱ no̱ u̱t-nip, wa za he̱n u̱t-taag u̱ to̱p-u wa da.>> ");
INSERT INTO gel_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Da-u̱ Ye̱so̱ tase̱ no̱mu̱ a-doru̱ wa ne̱ o̱p u̱ yu̱r u̱t-him, se̱ wa yu̱ne̱ wa do̱'e̱ wa o̱ u̱t-ko̱se̱ u̱t-bu̱t ne̱ u̱-me̱ bo̱-tu̱ Gariri. ");
INSERT INTO gel_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Da-u̱ Yohanna wa-u̱t-yu̱bu̱sse̱ m-bu̱, o̱o̱ge̱ u̱ tage̱ u̱ bu-u̱ m-to̱k. Da-u̱ wa ho̱ge̱ no̱m-tu̱ Ye̱so̱ Kiristi o̱ u̱t-no̱m, se̱ wa tom a-doru̱ wa u̱du̱ Ye̱so̱, ");
INSERT INTO gel_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","e̱ shit wu̱n, <<¿Bo̱ wa wu̱ de̱ haana, ko̱ it wa u̱r-is u̱ waku̱n?>> ");
INSERT INTO gel_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ye̱so̱ shu̱s wa zu̱, <<Mu̱u̱n no̱ waru̱ Yohanna no̱mu̱ no̱ o̱ u̱t-hyan tu̱msu̱ no̱mu̱ no̱ o̱ u̱t-ho̱g. ");
INSERT INTO gel_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Po̱-ne̱ o̱ kwu̱m-du̱ m-hyan, a-za-u̱s-na ne̱ e̱ o̱ m-ha, kim-ne̱ kwu̱ng m-yar, a-za m-ho̱g, e̱ hog u̱s-rem, na o̱ yu̱nsu̱ i mare̱ ne̱, tu̱msu̱ a-u̱r-ko̱b-ne̱ o̱ ho̱g-du̱ Rem-su̱ m-Re̱me̱r. ");
INSERT INTO gel_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ru̱-u̱ de̱ wa u̱ ko̱wan u-kom wu̱ no̱me̱ u-sakna u̱ yadu̱ jab u̱du̱ ri da.>> ");
INSERT INTO gel_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Da-u̱ a-doru̱ Yohanna arke̱, Ye̱so̱ he̱e̱se̱ no̱mu̱ mo̱ro̱g-du̱ u̱t-ne̱t u̱s-rem u̱ Yohanna wa zu̱, <<¿Yan-o̱ no̱ de̱ u̱t-hyan u̱t-kanda? ¿Ko̱ no̱ do̱'e̱ hyan-du̱ tampur u̱ mya-mu̱ ru̱ste̱? ");
INSERT INTO gel_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Yan go̱ ne̱t-wa no̱ de̱ u̱ku̱n u̱t-hyane? ¿No̱ de̱ m-do̱'e̱ u̱ku̱n no̱ hyan ne̱t wu̱ wa'e̱ kus-tu̱ shik? O'o! Ne̱t-tu̱ wu̱'e̱ kus-tu̱ shik o̱ bu-tu̱ u̱t-faru̱k. ");
INSERT INTO gel_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿To̱ yan-o̱ no̱ de̱ u̱t-hyane? ¿Ko̱ wa-warru̱ rem-su̱ u-Ru̱ wa? U̱, u̱m o̱ waru̱ no̱ he̱n wa ze̱k wa-warru̱ rem-su̱ u-Ru̱.>> ");
INSERT INTO gel_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yohanna wa re̱m-su̱ u-Ru̱ nomte̱ u̱s-rem u̱zu̱, << <U̱m de̱ to̱mnu̱ wa-to̱mu̱-u̱ ri, kanda Kiristi hatu̱n, wu̱ de̱ mangu̱ jab-su̱ u̱t-ne̱t kanda wa haatu̱n.> ");
INSERT INTO gel_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","U̱m o̱ waru̱ no̱ u̱t-nip, na tamu̱g mat-du̱ waku̱n mat-du̱ ne̱ta wu̱ teye̱ Yohanna wa-u̱t-yu̱bu̱sse̱ m-sek da. Se̱di wu̱ o̱ wu̱ re̱k-ya u̱-me̱ faru̱k-du̱ u-Ru̱ ze̱k wu̱n. ");
INSERT INTO gel_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Du̱gu̱ da-u Yohanna wa-u̱t-yu̱bu̱sse̱ m-bu̱, u̱ haan u̱ uno̱ da-o̱ faru̱k-du̱ u-Ru̱ o̱ swadu̱ u̱r-ko̱b, tu̱msu̱ i o̱ yadu̱ o̱ u̱r-ko̱b e̱ u̱t-sa e̱ rum o̱ u̱r-be̱b. ");
INSERT INTO gel_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ko̱se̱-tu̱ Mosa no̱me̱, u̱ ran-tu̱ a-warru̱ rem-su̱ u-Ru̱ ne̱, to̱ no̱mu̱g rem-su̱ faru̱k-u̱r re̱ kanda haan-u̱r Yohanna. ");
INSERT INTO gel_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A no̱ eese̱ rem-su̱ u̱m o̱ u̱t-war, Yohanna wa na nomte̱ u̱s-rem u̱zu̱ wu̱na o̱ Iriya. Wu̱na a-warru̱ rem-su̱ u-Ru̱ ne̱ zu̱ wa de̱ mu̱u̱n. ");
INSERT INTO gel_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yage̱ wa to̱-tu̱ m-ho̱g, wa ho̱g.>> ");
INSERT INTO gel_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Se̱ Ye̱so̱ zu̱, <<Me̱ waru̱ no̱ ko̱ yan ne̱t-to̱ no̱ o̱ye̱, ne̱t-tu̱ uno̱ cara-o̱. No̱ u̱ka yaag i o̱ shu̱'u̱t u̱-me̱ u-tu̱rru̱, e̱ o̱ fag-du̱ hu̱u̱b-tu̱ ho̱r u̱n u̱zu̱, ");
INSERT INTO gel_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","<< <It fu̱ru̱g u-kar, no̱ gu̱gu̱m u̱s-he̱w; It fu se̱p-tu̱ m-mar, no̱ gu̱gu̱m u̱s-kan.> ");
INSERT INTO gel_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Da-u̱ Yohanna haane̱ wa o̱ u-swaat, wa soot m-mu̱di da, e̱ zu̱, <Wa o̱tte̱ no̱m u̱s-te.> ");
INSERT INTO gel_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Da-u̱ Wa'-u̱ Ne̱t haane̱, wa o̱ u-re̱, wa o̱ u̱t-swa e̱ zu̱, <Hyanu̱n! Wa tat u-re̱ u̱ u-swa ne̱, tu̱msu̱ hu̱u̱b-u̱ a-o̱nku̱ shik-u̱ tar u̱ a-u̱t-ba'as-ne̱!> Se̱di nap-mu̱ u-Ru̱ na nu̱p mo̱ du̱gu̱ ank-m wa.>> ");
INSERT INTO gel_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ye̱so̱ he̱e̱se̱ no̱mu̱ ne̱t-tu̱ bo̱-tu̱ wa nomte̱ no̱m-tu̱ m-shin u̱s-rem u̱zu̱ e̱ no̱mu̱g no̱m-tu̱ kame̱ da, remu̱ zu̱ e̱ gu̱gu̱mte̱ yage̱-du̱ ba'as-u̱t e̱. ");
INSERT INTO gel_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","<<No̱m-tu̱ u̱r-o̱n, u̱du̱ ne̱t-tu̱ bo̱-u̱ Corazin! No̱m-tu̱ u̱r-on, u̱du̱ ne̱t-tu̱ bo̱-u Basayada ko̱ e̱! Abite̱ no̱m-tu̱ m-shin tu̱ na no̱me̱ u̱ te̱k-u̱ me̱ no̱ na no̱mu̱g u̱ bo̱-u̱ Taya u̱ bo̱-u̱ Sido̱n ne̱, e̱ za yakke̱ u̱t-ba'as m-tumb ne̱ e̱ wo kus-tu̱ u̱t-kemi, e̱ shu̱'u̱t, e̱ asu̱ hi-u̱t e̱ m-cwa remu̱ e̱ ko̱ste̱ u̱zu̱ e̱ yakke̱ u̱t-ba'as. ");
INSERT INTO gel_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","U̱m o̱ di waru̱ no̱, u̱ ho̱-du̱ kwu̱p-du̱ u̱s-rem, Ru̱-o̱ u̱t-ze̱g m-ho̱g o̱n-du̱ ne̱t-tu̱ Taya u̱ Sido̱n ne̱ m-ze̱g no̱. ");
INSERT INTO gel_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Tu̱msu̱ no̱ ne̱t-tu̱ bo̱-u̱ Kapanahum, a no̱ kab u̱ka zu̱ Ru̱-u̱ de̱ se̱kmu̱ssu̱ no̱ cwa u̱ do̱m-u̱ u-ru̱ da, no̱ da. Ru̱-u̱ de̱ di gwu̱n-du̱ no̱ u̱ kub-u̱ za u̱r-ma. U̱zu̱ ne̱t-tu̱ dak-u̱ Saduma hyanu̱g no̱m-tu̱ m-shin tu̱ na no̱me̱ u̱ ane̱, e̱ za yakke̱ u̱t-ba'as u̱ bo̱-u̱ e̱ tu̱msu̱ na za dooste̱ bo̱-u o̱ da. ");
INSERT INTO gel_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Se̱di u̱m o̱ waru̱ no̱, u̱ ho̱-du̱ kwu̱p-du̱ u̱s-rem, Ru̱-o̱ u̱t-ze̱g m-ho̱g o̱n-du̱ ne̱t-tu̱ dak-u̱ Saduma u̱ no̱ ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","U̱ da-u o̱ Ye̱so̱ zu̱, <<U-u̱so Wa-ko-uyan wu̱ no̱me̱ u-ru̱ u-dak ne̱, u̱m no̱ngu̱ bo̱ u̱t-vam, remu̱ zu̱ bo̱ yaske̱ no̱m-u̱t tun-to̱ u̱du̱ a-u̱s-ve̱r, u̱ a-m-nap ne̱, bo̱ ko̱se̱-to̱ u̱du̱ ya'ag-u̱ re̱ke̱. ");
INSERT INTO gel_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iya o̱, U̱so-u ri, iya o̱ nomte̱ bo̱ u̱r-zwar bo̱ no̱m iya. ");
INSERT INTO gel_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","<<U̱so-u ri ya'aste̱ me̱ ko̱-uyan. Tu̱msu̱ waku̱n zaar wu̱ nape̱ Wa' da se̱ u-U̱so, tu̱msu̱ waku̱n nak u-U̱so da se̱ Wa' tu̱msu̱ wu̱ Wa' cwane̱ se̱ wa ko̱se̱ wa. ");
INSERT INTO gel_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","<<Haanu̱n u̱du̱ ri, no̱ be̱e̱t i po'e̱, i o̱ swadu̱ u̱r-ko̱b u̱ cwu̱-tu̱ m-no, me̱ ya' no̱ u̱r-hure̱. ");
INSERT INTO gel_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kabu̱n kan-u ri no iis du̱gu̱-du̱ ri, remu̱ zu̱ u̱m zatte̱ hu̱k-mu̱ u̱r-hi da, ne̱t m-yar wa u̱m o̱ye̱, no̱ u̱t-kwu̱m u̱r-hure̱ u̱ jab-u̱s no̱. ");
INSERT INTO gel_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kan-u ri zatte̱ u̱t-po̱ da, tu̱msu̱ cwu̱-u̱t ri zatte̱ m-no da.>> ");
INSERT INTO gel_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Da-u̱ Ho̱-du̱ u̱r-Hure̱ Yahuda-ne̱ no̱me̱, Ye̱so̱ dor u̱-me̱ tak-tu̱ arkama. A-doru̱ wa o̱ ho̱g-du̱ u̱s-me̱r, e̱ he̱e̱se̱ getmu̱ ro̱p-tu̱ arkama e̱ hu̱ u̱t-he̱ke̱m m-tu̱ m-tu̱. ");
INSERT INTO gel_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Da-u̱ Farisa-ne̱ hyane̱ iya, se̱ e̱ zu̱ wu̱n, <<Hyan, a-doru̱ ró e̱ o̱ no̱m-du̱ no̱m-u̱ bo̱r-tu̱ hose̱ u̱t-no̱m u̱ Ho̱-du̱ u̱r-Hure̱.>> ");
INSERT INTO gel_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ye̱so̱ shu̱s wa zu̱ u̱n, <<¿No̱ karu̱nte̱ no̱m-u̱ Dawuda no̱me̱, da-u̱ wa u̱ hu̱u̱b-u̱t wa ne̱ ho̱ge̱ u̱s-me̱r da? ");
INSERT INTO gel_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","U̱ka wa tote̱ u̱-me̱ bu-u̱ u-Ru̱, wa u̱ hu̱u̱b-u̱t wa ne̱, e̱ re no̱m u̱t-re̱ u̱r-sak, u̱ o̱tte̱ ge̱r u̱ kame̱ wa ko̱ hu̱u̱b-tu̱ m-ha wa ne̱ e̱ re̱ da, se̱di a-to̱o̱g-ne̱. ");
INSERT INTO gel_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","No̱ karu̱nte̱ u̱-me̱ bo̱r-tu̱ Ru̱-u̱ yase̱ Mosa, u̱ka a-to̱o̱g-ne̱ hopte̱ pas-du̱ bo̱r-tu̱ Ho̱-du̱ u̱r-Hure̱ u̱-me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan, u̱ wa nomte̱ m-ank u̱ ho̱-u̱r re̱, tu̱msu̱ shu̱'u̱te̱ u̱t-ba'as da. ");
INSERT INTO gel_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","U̱m o̱ waru̱ no̱, wu̱ ze̱ge̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan u̱ ya u̱ ane̱. ");
INSERT INTO gel_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","U̱zu̱ no̱ nak zu̱n-mu̱ rem-u̱s sin-se̱, <O̱n-de̱ u̱m u̱t-sa, za to̱o̱g da,> no̱ za kabu̱g a-za u̱t-ba'as u̱ka a-u̱t-ba'as-ne̱ da. ");
INSERT INTO gel_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","U̱m zu̱u̱g iya remu̱ zu̱ Wa'-u̱ ne̱t o̱tte̱ u̱r-faru̱k u̱ o̱ Ho̱-du̱ u̱r-Hure̱.>> ");
INSERT INTO gel_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ye̱so̱ yage̱ be-du̱ wa o̱tte̱, wa to u̱-me̱ bu-u̱ u̱t-ko̱se̱ u̱ Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Yaku̱n campa-ya o̱ u̱ku̱n wu̱ kom-u̱ so̱se̱. E̱ u̱t-sa e̱ kum no̱mu̱ e̱ ke̱tu̱ wu̱n, se̱ e̱ shit wu̱n u̱zu̱, <<¿Bo̱r-tu̱ zu̱u̱g u̱ ne̱t u̱ hast u̱s-go̱m u̱ Ho̱-du̱ u̱r-Hure̱?>> ");
INSERT INTO gel_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Wa zu̱ u̱n, <<¿A waku̱n u̱ te̱k-u̱ no̱ o̱tte̱ u-ca, se̱ ya he u̱-me̱ u̱r-du u̱ Ho̱-du̱ u̱r-Hure̱, wa za rwu̱tu̱n ya da? ");
INSERT INTO gel_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ne̱t ze̱k u-ca m-sek sok. Remu̱ iya, bo̱r-u̱t it hooste̱ it se̱gu̱ waku̱n u̱ Ho̱-du̱ u̱r-Hure̱ da.>> ");
INSERT INTO gel_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tu̱msu̱ wa zu̱ campa-u ya wu̱ kom-u̱ so̱-se̱, <<Nabne̱ kom-u ró!>> Wa nu̱b u-kom hen, za rem kom-u̱ kum m-yar u̱ka kom u-gan. ");
INSERT INTO gel_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farisa-ne̱ ru e̱ zo̱ng u̱ka e̱ do̱te̱ ho̱du̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Da-u̱ Ye̱so̱ nape̱ no̱m-u̱ e̱ zo̱nge̱, se̱ wa yage̱ be-u̱r re̱. U̱t-ne̱t u-tát e̱ do̱r wu̱n, tu̱msu̱ e̱ kwu̱ng m-yar be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Wa no̱mu̱ u̱n u̱t-him, u̱zu̱ a u̱n waru̱ waku̱n mo̱t-u̱t rò da. ");
INSERT INTO gel_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tunto̱ u̱t-be̱e̱t na no̱ng to̱ remu̱ na shu̱u̱ste̱ no̱mu̱ wa-warru̱ rem-su̱ u-Ru̱ Ishaya ware̱. ");
INSERT INTO gel_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","<<Gwat To̱k-u̱ ri ya, wu̱ u̱m dage̱, tu̱msu̱ wu̱ u̱m o̱ u̱t-cwan, wu̱ u̱m o̱ ho̱g-du̱ zwar-u̱r wa sok. U̱m do̱'e̱ wa'-u̱ wu̱n Yar-u ri, tu̱msu̱ wa do̱'e̱ u̱ u̱t-bu̱t u̱zu̱ Ru̱-u̱ de̱ no̱mu̱ a-za Yahuda-ne̱ kwu̱p-du̱ u̱s-rem u̱ka ku̱mte̱. ");
INSERT INTO gel_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Wa za no̱m-du̱ inan, ko̱ rem-su̱ u-har da, waku̱n za ho̱g-du̱ cwar-u wa u̱s-fu̱n da. ");
INSERT INTO gel_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wa za ge̱t-du̱ tampur u̱ u̱t-sa u̱t-ge̱t da, Hitirra yu̱ u̱t-sa u̱t-mu̱ru̱s wu̱n za ryu̱m-du̱ ya da. Se̱ wa wa'ag nip-tu̱ re u̱r-ko̱rro̱. ");
INSERT INTO gel_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","I za-Yahuda-ne̱ da, e̱ de̱ wadu̱ jab-u̱s e̱ u̱-me̱ dim-u̱r Ye̱so̱.>> ");
INSERT INTO gel_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","U̱n hatu̱n wu̱n waku̱n wu̱ o̱tte̱ no̱m u̱s-te, wa zatte̱ is da tu̱msu̱ wa kerte̱ u̱s-rem da. Ye̱so̱ ye' wa m-yar, campa-u ya no̱m u̱s-rem tu̱msu̱ wa hyen. ");
INSERT INTO gel_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ne̱t-tu̱ no̱m mu̱rimmo̱ sok e̱ zu̱, <<¿A ne̱t unwa o̱ye̱ Mesaya da, wu̱ rwu̱ne̱ du̱gu̱ ko̱-u̱r Dawuda, wu̱ in wote̱ jab?>> ");
INSERT INTO gel_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Da-u̱ Farisa-ne̱ ho̱ge̱ iya, e̱ zu̱, <<Be̱b-u̱r Beyerzebu, faru̱k-u̱ no̱m u̱s-te de̱, wa o̱tte̱ rutu̱ no̱m u̱s-te.>> ");
INSERT INTO gel_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ba Ye̱so̱ nape̱ no̱mu̱ o̱ dorog-u̱s u̱n, se̱ wa zu̱ u̱n, <<Faru̱k-du̱ mo̱te̱ u-yu̱r, kowan o̱ shu̱'u̱t-u̱r yo̱-de̱ e̱ o̱r-u̱ wa ne̱, de̱-de̱ faru̱k de̱ za u̱t-ees da. Tu̱msu̱ u-bo̱, ko̱ bu-u̱ ne̱t-tu̱ u-bu za shu̱'u̱t-u̱r so̱-de̱ da, bu-u o̱ za u̱t-es da. ");
INSERT INTO gel_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","A-no̱m u̱s-te du̱gu̱-du̱ faru̱k-du̱ faru̱k-u̱ no̱m u̱s-te mo̱te̱, shu̱'u̱te̱ faru̱k-u̱ no̱m u̱s-te o̱ m-dum u̱ hi-u̱r wa ne̱, ¿re̱ faru̱k-u̱r wa do̱te̱ u̱t eese? ");
INSERT INTO gel_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Abite̱ Beyerzebu be̱b-du̱ faru̱k-u̱ no̱m u̱s-te de̱ u̱m o̱tte̱ rutu̱ no̱m u̱s-te, ¿A-doru̱ no̱ be̱b-u̱r wan do̱'e̱ rutte̱? A-doru̱ no̱, de̱ kwu̱pu̱ no̱ sin-se̱ rem-se̱. ");
INSERT INTO gel_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Abite̱ me̱ he̱n be̱b-du̱ Yar-u u-Ru̱ o̱ u̱m o̱tte̱ rutu̱ no̱m u̱s-te, shu̱'u̱te̱ u̱zu̱ faru̱k-du̱ u-Ru̱ hagu̱n u̱ me̱ no̱. ");
INSERT INTO gel_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","<<Waku̱n zaar wu̱ de̱ cwa-du̱ bu-u̱ wa-u̱r-be̱b wa koos cwu̱-u̱t wa da, se̱ da wa gu̱gru̱sse̱ wa u-ro, kanda wa kerte̱ koosu̱ cwu̱-tu̱ bu-u wa. ");
INSERT INTO gel_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","<<Wu̱ za u̱r-kot u̱ me̱ ne̱ da, wa o̱ shu̱'u̱t-u̱r yo̱-de̱ u̱ me̱ ne̱; tu̱msu̱ wu̱ se̱gu̱ me̱ u̱t-kargu̱sse̱ da, bu̱rgu̱sse̱ to̱ wa o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Iya o̱ he̱n, u̱m o̱ waru̱ no̱, na de̱ no̱mu̱ ne̱t-ne̱ u̱r-ho̱ du̱ ko̱-uyan ba'as-to̱, u̱s-ju̱ru̱m ne̱ su̱ e̱ no̱me̱ u-Ru̱, se̱di wu̱ no̱me̱ rem-su̱ u̱s-ju̱ru̱m u̱du̱ Yar u-Ru̱ na za no̱mu̱ wa hastu̱ ba'as-tu̱ da. ");
INSERT INTO gel_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wu̱ pyape̱ Wa'-u̱ Ne̱t na no̱mu̱ wa u̱r-ho̱, se̱di wu̱ pyape̱ Yar-u u-Ru̱, na za no̱mu̱ wa u̱r-ho̱ da, u̱ uno̱ da-o̱ ko̱ da-u̱ o̱o̱ne̱. ");
INSERT INTO gel_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","<<Te-yu̱ o̱ so̱-ya, ya mu̱t ya-tu̱ o̱ so̱-to̱. Te-yu̱ za so̱-ya ya mu̱t ya-u̱t yo̱-to̱, na nu̱p u-te du̱gu̱ ya-u̱t wa. ");
INSERT INTO gel_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","No̱ fa' u̱ yo̱-ye̱, ¿re̱ no̱ do̱te̱ keru̱ warru̱ no̱m-tu̱ o̱ so̱-to̱ ba shu̱'u̱te̱ u̱zu̱ no̱ ne̱t-u̱t yo̱-to̱ to̱? No̱mu̱ o̱ me̱ jab o̱ rwu̱ne̱ u-nu. ");
INSERT INTO gel_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ne̱t-u̱ so̱-wa wu̱r no̱mu̱ o̱ so̱-o̱, du̱gu̱ me̱ jab-u̱ wa u̱ so̱-o̱, tu̱msu̱ ne̱t-u̱ yo̱-o̱ rwu̱tu̱n no̱m-u̱t yo̱-to̱ tu̱ o̱ jab-u̱ yo̱-o̱ wa. ");
INSERT INTO gel_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Se̱di u̱m o̱ waru̱ no̱, u̱ ho̱-du̱ kwu̱p-du̱ u̱s-rem, ko̱wan de̱ shu̱'u̱t na kwu̱pu̱ wa u̱s-rem u̱ka ku̱mte̱, ko̱ remu̱ rem-su̱ m-zan su̱ ware̱. ");
INSERT INTO gel_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Remu̱ rem-su̱ bo̱ ware̱, se̱ na do̱te̱ kwu̱pu̱ bo̱ u̱s-rem, ko̱ se̱ ruut bo̱, ko̱ tu̱msu̱ se̱ ru̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","E̱ke̱n u̱ te̱k-u̱ a-ko̱se̱-tu̱ u-bo̱r ne̱, u̱ Farisa-ne̱ e̱ zu̱, <<Wa-m-nap, it u̱t-sa bo̱ no̱m no̱m-tu̱ m-shin u̱ka do̱te̱ ko̱se̱ it u̱zu̱ Ru̱-o̱ to̱mnu̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Se̱ wa shu̱s wa zu̱, <<Ne̱t-tu̱ u̱no̱ da-o̱ no̱ no̱ng u̱ yo̱ye̱, tu̱msu̱ no̱ zatte̱ gye̱r-u u-Ru̱ da. E̱ u̱t-sa e̱ hyan u̱s-nap, se̱di na za ko̱su̱ e̱ se̱ke̱n napse̱ da, se̱di go̱-du̱ su̱ wa-warru̱ rem-su̱ u-Ru̱ Yunana. ");
INSERT INTO gel_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","U̱ka Yunana nomte̱ m-roog u̱t-tu̱t m-gyu̱p u-ho̱ ne̱ u̱-me̱ me̱n-tu̱ jan-u yat-ya, iya o̱ he̱n Wa'-u̱ Ne̱t do̱te̱ no̱m-du̱ m-roog u̱t-tu̱t, m-gyu̱p u-ho̱ ne̱ u̱ me̱n-tu̱ u-dak. ");
INSERT INTO gel_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","U̱ ho̱-du̱ kwu̱p-du̱ u̱s-rem, ne̱t-tu̱ Neneba de̱ rwu̱u̱n u̱ kur-u̱ kwu̱p-du̱ u̱s-rem. E̱ waru̱ u-Ru̱ u̱zu̱ ne̱t-tu̱ uno̱ da-o̱ no̱mu̱g u̱t-ba'as tu̱msu̱ kamu̱g na ya u̱n u̱r-ko̱b. U̱n de̱ u̱t-zu̱ iya, remu̱ zu̱ e̱ ho̱k Yunana u̱t-bu̱t, u̱n yage̱ no̱m-du̱ u̱t-ba'as. Waku̱n wu̱ ze̱ge̱ Yunana ya u̱ ane̱, no̱ gu̱gu̱m yage̱-du̱ u̱t-ba'as. ");
INSERT INTO gel_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","U̱ ho̱-du̱ kwu̱p-du̱ u̱s-rem, u-Re̱n wu̱ Sheba, wa de̱ rwu̱u̱n u̱-me̱ kur u̱ kwu̱p-du̱ u̱s-remu̱ wa waru̱ u-Ru̱ u̱zu̱ ne̱t-tu̱ uno̱ da-o̱ no̱mu̱g u̱t-ba'as tu̱msu̱ kamu̱g na ya u̱n u̱r-ko̱b. U̱m zu̱u̱g iya remu̱ wa hagu̱n du̱gu̱ dak-u̱ m-ra remu̱ u̱m hog-u̱t ve̱r-u̱s Suremanu. U̱ da-o̱ wu̱ ze̱ge̱ Suremanu ya u̱ ane̱, se̱di no̱ gu̱gmu̱ u̱t-e̱r. ");
INSERT INTO gel_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","<<A no̱m-yu̱ u̱s-te ru war-u̱ ne̱t, wa ru wa no̱m u̱t-riig u̱t-be tu̱ za m-bu̱, remu̱ wa kum-u̱t be-du̱ u̱r-hure̱. Se̱di a wa kume̱ da, ");
INSERT INTO gel_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","se̱ wa zu̱, <Me̱ u̱t-mu̱ u̱ be-du̱ u̱m rwu̱tu̱n> A wa mu̱ne̱ wa bit waku̱n zarra, tu̱msu̱ na oposte̱ bu-u o̱, na mangte̱ o̱. ");
INSERT INTO gel_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Wa u̱t-mu̱ wa kabu̱n no̱m u̱s-te ta'er i ze̱gu̱ wu̱n m-yo̱, tu̱msu̱ u̱ e̱ cwa u̱ me̱ ne̱tu̱ wa e̱ shu̱'u̱t. M-vaste̱ yu̱du̱ ne̱tu̱ wa u̱t-ze̱g u̱r-taku̱n m-yo̱. Iya o̱ he̱n do̱te̱ u̱t-shu̱'u̱t u̱ ne̱t-tu̱ u̱no̱ da-o̱.>> ");
INSERT INTO gel_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ye̱so̱ o̱ te̱k-u̱ no̱mu̱ mo̱ro̱g-du̱ u̱t-ne̱t u̱s-rem. Ino-u wa u̱ hu̱u̱b-tu̱ u̱r-matu̱ wa ne̱ e̱ o̱ ees u̱-do̱, e̱ u̱t-sa e̱ no̱m u̱s-rem u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Se̱ na zu̱ wu̱n, <<Ino-u ro u̱ hu̱u̱b-tu̱ u̱r-matu̱ ró ne̱ e̱ o̱ ees u̱-do̱, e̱ u̱t-sa e̱ no̱m u̱s-rem u̱ bo̱ ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ye̱so̱ shu̱s wa zu̱, <<¿Wana o̱ ino-u ri tu̱msu̱ wana o̱ hu̱u̱b-tu̱ u̱r-matu̱ ri?>> ");
INSERT INTO gel_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Se̱ wa og a-doru̱ wa u-jou wa zu̱, <<Ino-u ri ya, hu̱no-u̱t ri ya u̱ ane̱. ");
INSERT INTO gel_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ne̱t be̱e̱t wu̱ no̱me̱ no̱mu̱ Uso-u ri wu̱ o̱ do̱m-u̱ u-ru̱ u̱t-sa, wa o̱ hu̱u̱b-u̱ u̱r-matu̱ ri u̱ ino-u ri ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","U̱ te̱k-u̱ ho̱-u̱r re̱, Ye̱so̱ ru du̱gu̱ u-bu, wa shu̱'u̱t u̱-kit m-sa. ");
INSERT INTO gel_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ban-du̱ u̱t-ne̱t u-tát e̱ haan e̱ gu̱ns wu̱n, m-te da-u̱ wa cwa u̱-me̱ u-hat wa shu̱'u̱t, ne̱t-tu̱ mo̱ro̱g u̱-kit m-sa e̱ hog-u̱t wu̱n. ");
INSERT INTO gel_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ye̱so̱ waru̱ u̱n u̱t-no̱m u-tát u̱ te̱k-u̱ sha-mu̱ u̱s-rem, wa zu̱, <<Waku̱n wa-u̱r-to̱m wa haag u-tak remu̱ wa no̱m-u̱t ku̱w. ");
INSERT INTO gel_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wa o̱ te̱k-u̱ as-du̱ go', se̱ e̱ke̱n go̱'e̱ he u̱ do̱m u-fu̱n, no haan u̱ du̱gru̱sse̱ e̱. ");
INSERT INTO gel_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","E̱ke̱n tu̱msu̱ he u̱ be-du̱ u̱t-ta'ar, be-du̱ zatte̱ m-huug sok da. E̱ apu̱n za rem, remu̱ zu̱ huug-mo̱ u̱-do̱m u̱t-ta'ar u̱-ta. ");
INSERT INTO gel_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Se̱di da-u̱ ho̱-yu̱ no̱me̱ m-du̱ng, se̱ e̱ baru̱sse̱ e̱ gu̱u̱s, remu̱ zu̱ e̱ zatte̱ u̱s-gu̱r sok da. ");
INSERT INTO gel_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tu̱msu̱ e̱ke̱n go̱'e̱ he u̱ be-du̱ u̱s-hir, hir-su̱ rogom se̱ hoos e̱ u̱t-rogom. ");
INSERT INTO gel_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","E̱ke̱n he u̱ be-u̱r so̱-de̱, e̱ nom so, e̱ke̱n u-ko̱k u-gan 100, e̱ke̱n u̱t-shik u̱t-tu̱t 60, tu̱msu̱ e̱ke̱n u̱r-shik u̱ o̱p 30. ");
INSERT INTO gel_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yage̱ wa to̱-tu̱ u̱t-ho̱g, wa ho̱g.>> ");
INSERT INTO gel_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","A-doru̱ Ye̱so̱ haan e̱ shit wu̱n u̱zu̱, <<¿Remu̱ u-yan o̱ bo̱ o̱tte̱ no̱mu̱ ne̱t-tu̱ tun-to̱ sha-mu̱ u̱s-rem?>> ");
INSERT INTO gel_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Wa shu̱s wa zu̱, <<Ru̱-u̱ yaag no̱ nap-mu̱ no̱m-tu̱ m-yasa tu̱ Faru̱k-du̱ u-Ru̱, se̱di u̱n na yaag u̱n da. ");
INSERT INTO gel_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ne̱t wu̱ o̱tte̱ u-no̱m wa na de̱ u̱t-swu̱re̱ u-tát. Tu̱msu̱ wu̱ zatte̱ da, ko̱ no̱m-u̱ wa o̱tte̱ na de̱ u̱t-o̱nk du̱gu̱-du̱ wa. ");
INSERT INTO gel_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","De̱ wu̱te̱ u̱m o̱tte̱ no̱mu̱ u̱n sha-mu̱ u̱s-rem: <<Remu̱ zu̱ ko̱ u̱n gwak-u̱t u̱n za u̱t-hyan da, ko̱ u̱n e̱re̱g u̱n za u̱t-nap da. ");
INSERT INTO gel_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","No̱mu̱ wa-warru̱ rem-su̱ u-Ru̱ Ishaya ware̱ m-tumb ne̱ o̱ shu̱u̱g u̱ hi-u̱r u̱n, u̱zu̱: <No̱ de̱ ho̱g-du̱ no̱m-u̱ u̱m o̱ u̱t-war, se̱di no̱ za u̱t-nap da; No̱ de̱ u̱t-gwat, se̱di no̱ za u̱t-hyan da. ");
INSERT INTO gel_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Remu̱ zu̱ jab-su̱ ne̱t-u̱t tun-to̱ rindu̱sse̱, to̱-u̱t u̱n za u̱t-ho̱g da, tu̱msu̱ u̱n ryu̱bu̱kte̱ is-u̱ u̱n, u̱n za u̱t-hyan da. U̱zu̱ iya da, u̱n za hyanu̱g u̱ is-u̱ u̱n no̱m-u̱ u̱m o̱ u̱t-no̱m, u̱n za ho̱k no̱m-u̱ u̱m o̱ waru̱ u̱n, tu̱msu̱ u̱n za nak no̱m-u̱ u̱m o̱ waru̱ u̱n, U̱n za yakke̱ yu̱du̱ u̱t-ba'as u̱n byu̱ru̱n u̱du̱ ri, tu̱msu̱ u̱m za no̱ngu̱ u̱n u-u̱ku̱r.> ");
INSERT INTO gel_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","<<No̱ kwu̱ng kom u-Ru̱ remu̱ zu̱ no̱ hyanu̱g no̱m-tu̱ m-shin tu̱ u̱m o̱ u̱t-no̱m, tu̱msu̱ no̱ nak no̱m-tu̱ u̱m o̱ waru̱ no̱. ");
INSERT INTO gel_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","U̱m o̱ waru̱ no̱ u̱t-nip, a-warru̱ rem-su̱ u-Ru̱ ne̱ u-tát, u̱ ne̱t-tu̱ jab-u̱s so̱-se̱ ne̱, e̱ cwanu̱g e̱ hyan no̱m-u̱ no̱ hyane̱ tu̱msu̱ no̱ hog, e̱ kerge̱ da. ");
INSERT INTO gel_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","<<Ho̱go̱n nap-mu̱ sha-mu̱ u̱s-rem su̱ wa-ku̱w: ");
INSERT INTO gel_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Go̱ i he̱ u̱-do̱m u-fu̱n e̱ o̱ u̱ka ne̱t wu̱ ho̱ge̱ rem-su̱ Faru̱k-du̱ u-Ru̱, wa gwa'ag u̱r-nu da, faru̱k-u̱ no̱m u̱s-te haan u̱ kos no̱m-u̱ na kawe̱ u̱-me̱ jab-u̱ wa. ");
INSERT INTO gel_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ne̱t-u̱ ho̱ge̱ u̱s-rem za rem wa ku̱b se̱ u̱r-so̱ ne̱, wa o̱ u̱ka go̱ i he̱'e̱ u̱-me̱ be-du̱ u̱t-ta'ar. ");
INSERT INTO gel_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ba shu̱'u̱te̱ u̱zu̱ wa zatte̱ u̱s-gu̱r da wa tumbte̱ sok da. Da da-u̱ swadu̱ u̱r-ko̱b haane̱ wa yage̱ do̱rru̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Tu̱msu̱ go̱ i he̱ be-du̱ u̱s-hir, e̱ o̱ u̱ka ne̱t wu̱ ho̱ge̱ rem-su̱ u-Ru̱ wa ku̱b, se̱di da-u̱ no̱m-tu̱ namu̱ jab haane̱ u̱ e̱nk-tu̱ kwu̱m-tu̱ dak-u uno̱, se̱ soos wu̱n, se̱ hoos ya mat-du̱ u̱t-ya. ");
INSERT INTO gel_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Se̱di go̱ i he̱'e̱ u̱ be-u̱r so̱-de̱ e̱ o̱ u̱ka ne̱t wu̱ ho̱ge̱ rem-su̱ u-Ru̱, wa nu̱p se̱. Wa mu̱t u̱t-ya u̱t-ko̱k u-gan ko̱ u̱t-shik u̱t-tu̱t ko̱ u̱r-shik u̱ o̱p u̱ no̱m-u̱ wa kawe̱.>> ");
INSERT INTO gel_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ye̱so̱ no̱mu̱ u̱n sha-mu̱ u̱s-rem tu̱msu̱ wa zu̱, <<Faru̱k-du̱ u-Ru̱ o̱ u̱ka wa-u̱r-to̱m wu̱ kawe̱ go̱ so̱-ye̱ u̱-me̱ tak-u wa, se̱ wa aru̱k. ");
INSERT INTO gel_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","U̱ te̱k m-gyu̱p da kowan o̱ m-roog, hu̱u̱b-u̱ yo̱-o̱ rò haan wa-ku̱w go̱ za so̱-ye̱ u̱-me̱ tak-u rò, se̱ wa aru̱k. ");
INSERT INTO gel_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Da da-u̱ go̱ so̱-ye̱ o̱ u̱t-rogom e̱ no̱m yaag, iya o̱ hen go̱ za so̱-ye̱ rogom ko̱ e̱. ");
INSERT INTO gel_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","<<To̱k-ne̱ bu-u wa-u-tak haan wa waru̱ wu̱n u̱zu̱, <Wa-u-bu, be-du̱ bo̱ nomte̱ ku̱w arkama, u̱m byu̱k-u̱t bambara u̱-me̱. ¿He̱ne̱ bambara rwu̱tu̱n?> ");
INSERT INTO gel_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","<<Wa zu̱, <Hu̱u̱b-u̱ yo̱-o̱ no̱me̱ se̱.> <<To̱k-ne̱ shit wu̱n u̱zu̱, <¿Bo̱ u̱t-sa it do̱'e̱ it hast bambara?> ");
INSERT INTO gel_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","<<Se̱ wa zu̱ u̱n, <A no̱ hast bambara da, taas u̱du̱ u̱t-has no̱ same̱ u̱ arkama ne̱. ");
INSERT INTO gel_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yagu̱n e̱ rogom u̱r-kot m-te da-u̱ ket. U̱ da-u o̱ u̱m de̱ waru̱ a-ket ne̱, e̱ hast uro bambara u̱n gag u̱t-gu̱g u̱t-gu̱g e̱ gun u-ra. Se̱di na gun arkama u̱-me̱ u̱r-bya.> >> ");
INSERT INTO gel_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tu̱msu̱ Ye̱so̱ no̱mu̱ u̱n sha-mu̱ u̱s-rem u̱zu̱, <<Faru̱k-du̱ u-ru̱ o̱ u̱ka ya-yu̱ mastad yu̱ na kawe̱ u-tak. ");
INSERT INTO gel_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ya zege̱ u̱s-re̱k u̱ te̱k-u̱ go̱ no̱m, se̱di ya ne̱ne̱ ya nom te-u yat-ya u-me̱ u-tak, no cu̱st u̱-do̱m e̱ no̱m u̱t-tu̱ku̱s u̱ do̱m u̱s-fe̱.>> ");
INSERT INTO gel_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ye̱so̱ sur m-ya u̱n sha-mu̱ u̱s-rem u̱zu̱, <<Faru̱k-du̱ u-Ru̱ de̱ o̱ u̱ka m-yis mu̱ ne̱ta wake̱ u̱-me̱ hyu̱-m yat-mo̱ kanda hyu̱m-mo̱ hok-u̱t m-yis.>> ");
INSERT INTO gel_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ye̱so̱ waru̱g sha-mu̱ rem-u̱s se̱ u̱s-be̱e̱t u̱-me̱ mo̱ro̱g-du̱ u̱t-ne̱t. Wa waru̱g o̱ko̱n u̱-me̱ u̱n za wa no̱mu̱ u̱n sha-mu̱ u̱s-rem da. ");
INSERT INTO gel_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Sin-se̱ u̱s-be̱e̱t u̱ remu̱ na shu̱u̱ste̱ no̱mu̱ wa-warru̱ rem-su̱ u-Ru̱ Ishaya ware̱ u̱zu̱, Sha-mu̱ u̱s-rem mo̱ u̱m do̱te̱ u̱s-rem. Me̱ u̱t-wa u̱ ne̱t-tu̱ nap no̱m-tu̱ o̱ m-yasa, tu̱ du̱gu̱ da-u̱ u̱r-taku̱n du̱ dak-u uno̱. ");
INSERT INTO gel_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ye̱so̱ yage̱ mo̱ro̱g-du̱ u̱t-ne̱t wa to u̱-me̱ u-bu. A-doru̱ wa haan e̱ zu̱ wu̱n, <<Waru̱ it hi-du̱ sha-mu̱ u̱s-rem su̱ go̱ za so̱-ye̱ u-tak.>> ");
INSERT INTO gel_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Se̱ wa shu̱s wa zu̱, <<Wu̱ kawe̱ go̱ so̱-ye̱ wa o̱ Wa'-u̱ Ne̱t. ");
INSERT INTO gel_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","U-tak hen dak-u uno̱ o̱, go̱ so̱-ye̱ hen e̱ o̱ u̱t-ne̱t i o̱ no̱mu̱ u-Ru̱ u̱t-huuk. Go̱ za so̱-ye̱ e̱ o̱ ya'ag-u̱ faru̱k-u̱ no̱m u̱s-te. ");
INSERT INTO gel_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tu̱msu̱ hu̱u̱b-u̱ yo̱-o̱ kawe̱ go̱ za so̱-ye̱ wa o̱ faru̱k-u̱ no̱m u̱s-te. Ket hen, o̱ madu̱ uno̱ da-o̱, a-ke̱t-ne̱ a-to̱m u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","<<U̱ka ne̱t-tu̱ kargu̱sse̱ go̱ za so̱-ye̱ na doos e̱ u-ra, iya o̱ Ru̱-u̱ do̱te̱ u̱t-shu̱'u̱t ma-du̱ dak-u uno̱. ");
INSERT INTO gel_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Wa'-u̱ Ne̱t de̱ to̱mnu̱ a-to̱m u-Ru̱, e̱ de̱ kargu̱ssu̱ a wadu̱ ne̱t-ne̱ no̱m-du̱ u̱t-ba'as, tu̱msu̱ u̱ a no̱m-du̱ no̱m-u̱t yo̱-to̱ ne̱, e̱ ruut e̱ u̱-me̱ faru̱k-u̱r wa. ");
INSERT INTO gel_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","A-to̱m u-Ru̱ de̱ gwu̱n-du̱ e̱ u̱-me̱ u-ra u̱ m-du̱ng sok. U̱ be-u̱r re̱ ku̱na e̱ do̱te̱ u̱s-kan u̱ ep-mu̱ nin ne̱. ");
INSERT INTO gel_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","U̱ da-u o̱ he̱n a-jab-u̱s so̱-se̱ de̱ no̱m-du̱ m-zu̱n u̱ka u̱r-ho̱ u̱-me̱ faru̱k-du̱ U̱so-u u̱n. Wu̱ o̱tte̱ to̱-tu̱ m-ho̱g yage̱ wa ho̱g. ");
INSERT INTO gel_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","<<Faru̱k-du̱ u-Ru̱ de̱ o̱ u̱ka u̱t-kwu̱m tu̱ o̱ m-yasa. Da-u̱ ne̱t-u̱ kume̱ o̱, wa mang u̱t-yase̱. U̱ remu̱ u̱r-so̱ wa de̱ bab no̱m-tu̱ wa o̱tte̱ wa o̱ tak-u o̱. ");
INSERT INTO gel_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","<<Tu̱msu̱ Faru̱k-du̱ u-Ru̱ de̱ o̱ u̱ka wa-u-tu̱rru̱ wu̱ o̱ sa-u̱ taar-tu̱ shik sok. ");
INSERT INTO gel_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Da-u̱ wa kume̱ ta'ar-u̱r re̱ du̱ shik, wa de̱ m-ha wa bab no̱m-tu̱ wa o̱tte̱ u̱t-be̱e̱t remu̱ wa oot ta'ar-u̱r re̱. ");
INSERT INTO gel_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","<<Tu̱msu̱ Faru̱k-du̱ u-Ru̱ o̱ u̱ka re̱n-tu̱ masu̱ jan, tu̱ na gune̱ u̱-me̱ m-sa to̱ maas jan ko̱-uyan go̱de̱. ");
INSERT INTO gel_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Da-u̱ re̱n-tu̱ shiye̱, a masu̱ jan ne̱ naku̱n u̱ rwu̱u̱n, e̱ shu̱'u̱t e̱ du̱gu̱r jan-u̱ so̱-ye̱ e̱ wo u̱ me̱ u̱r-ko̱o̱r, na azu̱g jan i za so̱-ye̱. ");
INSERT INTO gel_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Iya o̱ do̱te̱ u̱t-shu̱'u̱t u̱ ho̱-du̱ u̱r-vaste̱. Wa-to̱m u-Ru̱ de̱ u̱t-haan wa mo̱t a-jab-u̱s yo̱-se̱ ne̱ u̱ a-jab-u̱s so̱-se̱ ne̱, ");
INSERT INTO gel_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","wa gun e̱ u̱-me̱ u-ra u̱ m-du̱ng sok, be-du̱ e̱ do̱te̱ u̱s-kan u̱ ep-mu̱ nin ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ye̱so̱ shit u̱n u̱zu̱, <<¿No̱ gwa'ag u̱r-nu a?>> U̱n shu̱s u̱n zu̱, <<U̱.>> ");
INSERT INTO gel_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Se̱ Ye̱so̱ zu̱ u̱n, <<Ko̱-uyan wa-u̱t-ko̱se̱ tu̱ u-bo̱r wu̱ na iise̱ mo̱ttu̱ Faru̱k-du̱ u-Ru̱, wa o̱ u̱ka wa-u-bu wu̱ gasne̱ kwu̱m-u̱t po-to̱ u̱t-ut ne̱ du̱gu̱ be-du̱ u̱r-cu̱nu̱ wa.>> ");
INSERT INTO gel_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Da-u̱ Ye̱so̱ tase̱ no̱mu̱ u̱n sha-mu̱ u̱s-rem, wa yage̱ be-u̱r re̱. ");
INSERT INTO gel_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ye̱so̱ haagu̱n u̱-me̱ bo̱-u wa, wa hu̱ no̱mu̱ ne̱t-ne̱ u̱t-ko̱se̱ u̱-me̱ bu-u̱ u̱t-ko̱se̱ u̱ Yahuda-ne̱. U̱n hu̱ mu̱rimmo̱ u̱zu̱, <<¿He̱ne̱ ne̱t uno̱ kumte̱ mummo̱ nap-mo̱ inya, u̱ shin-mu̱ no̱m-du̱ no̱m-tu̱ m-shin tun-to̱ ne̱ u̱t-be̱e̱t? ");
INSERT INTO gel_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Unwa a wa'-u̱ kahinta-u yaya da? ¿A ino-u rò na zu̱ Me̱ri da? ¿A o̱r-u̱t rò ne̱ o̱ye̱ Yakubu, u̱ Yusuhu u̱ Simo̱n u̱ Yahudas ne̱ da? ");
INSERT INTO gel_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Za o̱r-u̱t rò ne̱ ya-u̱t-gwu̱p i o̱ u̱r-kot u̱ in ne̱ da? ¿He̱ne̱ wa kwu̱mtu̱n shin-mu̱ no̱m-du̱ no̱m-tu̱ m-shin tun-to̱?>> ");
INSERT INTO gel_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Remu̱ iya e̱ gu̱gu̱m wu̱n. Ye̱so̱ zu̱ u̱n, <<Ne̱t-tu̱ ye' wa-warru̱ rem-su̱ u-Ru̱ m-sek, se̱di ne̱t-tu̱ bo̱-u rò u̱ ne̱t-tu̱ bu-u rò ne̱, e̱ nomte̱ da.>> ");
INSERT INTO gel_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tu̱msu̱ wa no̱ng no̱m-tu̱ m-shin u-tát u̱ku̱n sok da remu̱ ko̱b-du̱ yadu̱ jab-u̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","U̱ da-u o̱, Here̱ Antipas Faru̱k ho̱ge̱ u̱zu̱ Ye̱so̱ o̱ no̱m-du̱ no̱m-tu̱ m-shin. ");
INSERT INTO gel_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Se̱ wa zu̱ to̱k-ne̱ bu-u wa, <<Unwa o̱ Yohanna wa-u̱t-yu̱bu̱sse̱ m-bu̱ wa yu̱ne̱ du̱gu̱ marimari-ne̱ de̱ wu̱te̱ wa kerte̱ no̱m-du̱ no̱m-tu̱ m-shin tun-to̱.>> ");
INSERT INTO gel_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","No̱m-u̱ wu̱te̱ Here̱ no̱m-u̱t dorog-u̱s se̱: Here̱ gaag Herodiya ne̱ta hu̱u̱b u̱r-matu̱ wa Firibi, u̱ Firibus ne̱ u̱r-fat. De̱ wu̱te̱ Yohanna o̱gu̱ waru̱ wu̱n u̱zu̱, <<No̱m-u̱ bo̱ no̱me̱ bo̱ gu̱ ne̱ta hu̱no-u ró u̱ wane̱ u̱r-fat, bo̱ paku̱s bo̱r-tu̱ u-Ru̱.>> Remu̱ Here̱ mangte̱ jab-u̱ Herodiya, wa waru̱ karma-ne̱ e̱ maas Yohanna, e̱ gag wa u̱ ho-su̱ kwam, e̱ gun wa u̱-me̱ bu-u m-to̱k. ");
INSERT INTO gel_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Here̱ cwang wa ho̱ Yohanna, se̱di wa o̱ u-gye̱r u̱t-ne̱t remu̱ zu̱ e̱ kabu̱g wu̱n wa-warru̱ rem-su̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","U̱ ho̱-du̱ bak-su̱ ho̱-du̱ u̱r-matu̱ Here̱, wa'-u̱ Herodiya no̱ngu̱ u̱n u̱s-he̱w sok har Here̱ ho̱k u̱r-zwar. ");
INSERT INTO gel_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Here̱ no̱m este̱du̱ u̱s-rem u̱s-to̱nd ne̱ u̱zu̱ wa ya' wu̱n ko-uyan u̱ wa u̱t-sa. ");
INSERT INTO gel_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ino-u rò yu̱ wu̱n u̱s-rem u̱ no̱m-u̱ u do̱'e̱ u̱t-ko̱n u̱zu̱, <<U̱m u̱t-sa hi-u̱r Yohanna wa yu̱bu̱sse̱ m-bu̱ u̱-me̱ u-ko̱k.>> ");
INSERT INTO gel_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Faru̱k ho̱k u̱r-zwar da, se̱di ba shu̱'u̱te̱ u̱zu̱ wa no̱ng este̱du̱ u̱s-rem u̱s-to̱nd ne̱, tu̱msu̱ remu̱ ham-u̱t tu̱ o̱ u̱ku̱n ne̱, se̱ wa zu̱ karma-ne̱ e̱ yasu̱ no̱mu̱ wa ko̱ne̱. ");
INSERT INTO gel_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Wa tom m-ha bu-u̱ m-to̱k u̱zu̱ na kwu̱pu̱n hi-u̱r Yohanna. ");
INSERT INTO gel_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Na hatu̱n hi-u̱r Yohanna u̱-me̱ u-ko̱k na yasu̱ wa'-u̱-gwu̱p, wa ku̱b m-ha u̱du̱ ino-u wa. ");
INSERT INTO gel_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","A-doru̱ Yohanna haan e̱ ku̱b birig-du̱ u-war e̱ dok. E̱ do̱'e̱ e̱ waru̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Da-u̱ Ye̱so̱ ho̱ge̱ u̱zu̱ Here̱ wa'ag karma e̱ ho̱o̱g Yohanna, se̱ wa to u-hat m-ha u̱ de̱ku̱n be-de̱ du̱ za u̱t-ne̱t remu̱ wa shu̱'u̱t wa u-gan u̱ku̱n. Da-u̱ ne̱t-tu̱ ho̱ge̱ iya, e̱ rwu̱n du̱gu̱ u̱t-bo̱, e̱ dor wu̱n u̱s-na. ");
INSERT INTO gel_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Da-u̱ Ye̱so̱ ruye̱ u̱-me̱ u-hat, se̱ wa hyen u̱t-ne̱t to̱ mo̱ro̱gte̱ u-tát. Wa hog u̱r-o̱n wa hast a-ko̱b-du̱ m-yar ne̱ u̱s-go̱m i o̱ u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Da-u̱ rim-mu̱ tore̱, a-doru̱ Ye̱so̱ e̱ zu̱ wu̱n, <<In o̱ u̱-me̱ be-du̱ zatte̱ u̱t-ne̱t da, yage̱ u̱t-ne̱t e̱ cwa u̱-me̱ u̱t-taas e̱ kum-u̱t no̱m u̱t-re̱ e̱ o̱.>> ");
INSERT INTO gel_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ye̱so̱ zu̱ u̱n, <<Kamu̱g u̱zu̱ se̱ u̱n haag u̱ aku̱n da. No̱ ya' u̱n no̱m u̱t-re̱ u̱n re̱.>> ");
INSERT INTO gel_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Se̱ e̱ zu̱ wu̱n, <<It zatte̱ o̱ko̱n u̱ ane̱ da, be̱re̱di-to̱ u̱t-tan u̱ jan ne̱ u̱t-yu̱r.>> ");
INSERT INTO gel_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ye̱so̱ zu̱ u̱n, <<Hatu̱n to̱ u̱ ane̱.>> ");
INSERT INTO gel_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Se̱ wa zu̱ u̱n zu̱u̱n ne̱t-tu̱ shu̱'u̱t u̱ do̱m u̱s-gwa. Wa ku̱b be̱re̱di-u̱t to̱ u̱t-tan u̱ jan yu̱r, wa jaku̱s u̱r-hi u̱ do̱m u-ru̱, wa no̱mu̱ u-Ru̱ u̱t-vam. Wa mo̱t be̱re̱di-u̱t to̱ wa yasu̱ a-doru̱, tu̱msu̱ a-dor wa mo̱tu̱ ban-du̱ u̱t-ne̱t. ");
INSERT INTO gel_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kowan re, wa shig, a-doru̱ wa kargu̱sse̱ no̱m u̱t-re̱ kuse̱ ko̱o̱r-u̱t yatto̱ o̱p-u̱t yu̱r. ");
INSERT INTO gel_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tat-u̱ ne̱t-tu̱ re̱ no̱m u̱t-re̱ o̱, ne̱t-to̱ campa-ne̱ u̱t-zo̱ngu u̱t-tan 5,000, a-dor ogorte̱ ne̱ta-ne̱ u̱ ya'ag ne̱ i re̱ no̱m u̱t-re̱ o̱ da. ");
INSERT INTO gel_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Da-u̱ u̱n tase̱ Ye̱so̱ zu̱ a-dor e̱ cwa u̱-me̱ u-hat, e̱ do̱'e̱ u̱ din-de̱ jit gwu̱g-de̱. Wa hen wa ees kanda ne̱t-tu̱ aru̱k. ");
INSERT INTO gel_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Da-u̱ wa yu̱nse̱ u̱t-ne̱t, wa du̱ do̱m u̱r-ro̱r remu̱ wa no̱m-u̱t u̱s-to̱o̱g. Rim-mu̱ tor wu̱n u̱ku̱n wu̱n u-gan. ");
INSERT INTO gel_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","U̱ da-u o̱ hen hat-yu̱ o̱ te̱k m-sa, ya ragu̱n u-dak ne̱, tu̱msu̱ jwak m-bu̱ o̱ gab-du̱ m-mya tu̱msu̱ mya-mu̱ no̱ng u-tát. ");
INSERT INTO gel_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","U̱ka u̱s-kwam u̱s-tu̱t su̱ u̱r-wu̱n, Ye̱so̱ yu̱ne̱ wa o̱ jang m-bu̱ u̱-me̱ m-sa m-ha u̱du̱ a-doru̱ wa. ");
INSERT INTO gel_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Da-u̱ a-dor hyanu̱ wu̱n m-ha u̱-me̱ m-sa, e̱ hog u-gye̱r, e̱ zu̱, <<No̱m-tu̱ m-bu̱ to̱!>> E̱ no̱m u̱t-jar u̱ remu̱ u-gye̱r. ");
INSERT INTO gel_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Za rem Ye̱so̱ zu̱ u̱n, <<No̱mo̱n be̱b-du̱ jab, tu̱msu̱ a no̱ ho̱g u-gye̱r da, me̱ wa Ye̱so̱.>> ");
INSERT INTO gel_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Biturus zu̱, <<Wa-m-nap, abite̱ bo̱ wa, zu̱ me̱ u̱m jangu̱n u̱ haan u̱du̱ ró u̱ do̱m m-bu̱.>> ");
INSERT INTO gel_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ye̱so̱ zu̱, <<Jangu̱n.>> Biturus ru̱ du̱gu̱ me̱ u-hat, wa hu̱ m-ha u̱ do̱m m-bu̱ m-ha u̱du̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Da-u̱ wa hyane̱ m-mya, wa hog u-gye̱r wa he̱e̱se̱ u̱t-iis, se̱ wa no̱m u̱t-jar, <<Wa-m-nap! Gu me̱!>> ");
INSERT INTO gel_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Za rem Ye̱so̱ nu̱b u-kom wa ship wu̱n. Wa zu̱, <<Bo̱ wa yadu̱ jab cashi, ¿remu̱ yan-o̱ bo̱ no̱m-te̱ u-sakna?>> ");
INSERT INTO gel_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Da-u̱ Ye̱so̱ e̱ Biturus cwa u̱-me̱ u-hat, mya-mu̱ ho u̱s-ram te̱k. ");
INSERT INTO gel_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ne̱t-tu̱ o̱ u̱-me̱ u-hat e̱ no̱mu̱ Ye̱so̱ u̱t-huuk, e̱ zu̱, <<Nip-to̱ bo̱ Wa'-u̱ u-Ru̱ wa!>> ");
INSERT INTO gel_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Da-u̱ e̱ pase̱ m-sa, e̱ ciz u̱ dak-u̱ Janisarata. ");
INSERT INTO gel_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Da-u̱ ne̱t-tu̱ bo̱-u o̱ nape̱ u̱zu̱ Ye̱so̱ wa, e̱ tom na waru̱ kowan wu̱ o̱tte̱ wa-ko̱b-du̱ m-yar u̱-me̱ dak-u o̱ e̱ haan u̱ Ye̱so̱ ya u̱n m-yar. ");
INSERT INTO gel_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","E̱ kon Ye̱so̱ u̱zu̱, wa yage̱ a-ko̱b-du̱ m-yar ne̱ e̱ tam ko̱ nu-du̱ to̱ggo̱-u rò. Tu̱msu̱ ne̱t-ne̱ be̱e̱t i tame̱ wu̱n e̱ kwu̱ng m-yar. ");
INSERT INTO gel_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Farisa-ne̱ u̱ a-ko̱se̱-tu̱ u-bo̱r ne̱ haan u̱du̱ Ye̱so̱ du̱gu̱ Urusharima. E̱ zu̱, ");
INSERT INTO gel_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","<<¿Remu̱ u-yan o̱ a-doru̱ ró o̱tte̱ pas-du̱ u̱r-ma'in du̱ ne̱nge̱n-u̱t in? Remu̱ zu̱ e̱ saapte̱ u̱t-kom kanda e̱ re̱ no̱m-u̱ u̱t-re̱ da!>> ");
INSERT INTO gel_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ye̱so̱ shu̱s wa zu̱, <<¿No̱ remu̱ yan-o̱ no̱ o̱tte̱ pas-du̱ bo̱r-tu̱ u-Ru̱ remu̱ no̱m-tu̱ ne̱nge̱n-u̱t no̱ is-u̱ no̱? ");
INSERT INTO gel_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ru̱-u̱ zu̱u̱g, <Ya' u̱so-u ró u̱ ino-u ró ne̱ m-ze̱g,> tu̱msu̱ <Ne̱t wu̱ pyape̱ u̱so-u wa ko̱ ino-u wa na do̱'e̱ ho̱-du̱ wa.> ");
INSERT INTO gel_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","No̱ no̱mu̱ ne̱t-ne̱ u̱t-ko̱se̱ u̱zu̱, bo̱ keru̱ zu̱ u̱so-u ró ko̱ ino-u ró: <No̱m-u̱ u̱m o̱tte̱ u-be̱e̱t u̱ kame̱ u̱m nya' no̱, u̱m no̱mu̱g este̱du̱ u̱s-rem u̱zu̱ u̱m de̱ yasu̱ o̱ u̱du̱ u-Ru̱.> ");
INSERT INTO gel_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tu̱msu̱ a no̱ no̱me̱ iya, no̱ dorog u̱zu̱ o̱ko̱n zaar u̱ no̱ de̱ yadu̱ i mate̱ no̱ da. Iya o̱ hen, no̱ o̱ no̱mu̱ ne̱t-ne̱ ko̱se̱-tu̱ u̱r-ma no̱, no̱ yage̱ bo̱r-tu̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","No̱ a-ha-mu̱ u̱r-no̱ ne̱, no̱mu̱ Ishaya ware̱ u̱ no̱ nip-to̱, u̱ wa nomte̱ u̱r-do̱nse̱ remu̱ no̱ u̱zu̱, ");
INSERT INTO gel_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","<< <Ne̱t-u̱t tun-to̱ no̱mu̱ me̱ m-sek u̱ go̱p-tu̱ u-nu. Se̱di jab-u̱s u̱n za u̱r-kot u̱-me̱ da. ");
INSERT INTO gel_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","E̱ no̱mu̱ me̱ huuk-tu̱ m-zan; Ko̱se̱-u̱t u̱n ko̱se̱-tu̱ u̱t-ne̱t to̱.> >> ");
INSERT INTO gel_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ye̱so̱ fog u̱t-ne̱t wa zu̱ u̱n, <<Ho̱go̱n no̱ nap. ");
INSERT INTO gel_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Za no̱m-u̱ o̱ m-cwa u̱ nu-u̱ ne̱t o̱ mutu̱ wa, wa-za-u-he̱n u̱du̱ u-Ru̱ da, se̱di no̱m-u̱ o̱ rwu̱u̱n u̱ nu-u wa.>> ");
INSERT INTO gel_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","A-dor haan u̱du̱ rò, e̱ zu̱ wu̱n, <<Farisa-ne̱ ho̱k zwarru̱ rem-u̱s se̱ da, da-u̱ e̱ ho̱gu̱ se̱.>> ");
INSERT INTO gel_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ye̱so̱ zu̱, <<Ku̱w be̱e̱t u̱ U̱so-u ri wu̱ o̱ do̱m u-ru̱ kawe̱ da, na de̱ musu̱ o̱ u̱s-gu̱r ne̱. ");
INSERT INTO gel_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yagu̱n ne̱t-tu̱ Farisa, e̱ u̱ka po̱-ne̱ e̱, a-nak-du̱ o̱r-u̱t e̱ po̱-ne̱. A po̱ o̱ nak-du̱ o̱r-u̱ wa po̱, e̱ be̱e̱t e̱ de̱ he̱du̱ u-kub.>> ");
INSERT INTO gel_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Biturus zu̱ wu̱n, <<Gwa-su̱ it nu-du̱ sha-mu̱ u̱s-rem sin-se̱.>> ");
INSERT INTO gel_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ye̱so̱ zu̱, <<¿No̱ gwa'ag u̱r-nu uro da? ");
INSERT INTO gel_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","No̱ hyang, no̱m-u̱ ne̱tu̱ re̱ u-be̱e̱t u̱r-taku̱n o̱ de̱ u̱t-cwa u̱ nu-u wa, o̱ fang u̱t-me̱n, m-vaste̱ o̱ de̱ rwu̱u̱n m-ha u̱ zan. ");
INSERT INTO gel_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","No̱m-u̱ o̱ rwu̱n du̱gu̱ u-nu, du̱gu̱ jab o̱, o̱ rwu̱ne̱. O̱ hen u̱ de̱ mutu̱ ne̱t wa-za-u-he̱n u̱du̱ u-Ru̱ u̱ ne̱t-ne̱. ");
INSERT INTO gel_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","U̱m zu̱u̱g iya remu̱ zu̱ du̱gu̱ jab o̱ dorog-su̱ no̱m-u̱t yo̱-to̱ rwu̱tu̱n, wato, ho̱-du̱ ne̱t, m-o̱, m-o̱ ne̱, u-hiw, ke̱t-du̱ u̱s-bi, u̱ na-su̱ dim-u̱r e̱ke̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tunto̱ to̱ no̱m-to̱ wu̱te̱ ne̱t u̱ shu̱'u̱t wa-ko̱b-du̱ u-he̱n u̱du̱ u-Ru̱, se̱di re̱-du̱ no̱m u̱t-re̱ za saap u̱t-kom wa'ag ne̱t u̱ shu̱'u̱t wa-za-u-he̱n u̱du̱ u-Ru̱ da.>> ");
INSERT INTO gel_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Da-u̱ Ye̱so̱ yage̱ ku̱n, se̱ wa do̱'e̱ u-dak, u̱ be-du̱ bo̱-tu̱ Taya u̱ Sido̱n ne̱ o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Yaku̱n ne̱ta ya wa-za Yahuda, wu̱ o̱ u̱ dak-u̱ o̱, wa jaku̱s u-cwar wa zu̱, <<Wa-m-nap! Wa'-u̱ Dawuda, ho̱g o̱n-u̱r ri! Yaku̱n no̱m-yu̱ u̱s-te ya o̱ yadu̱ wa'-u̱ ri wa-gwu̱p u̱r-ko̱b.>> ");
INSERT INTO gel_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ye̱so̱ shaku̱s o̱ko̱n no̱m-o̱ da. Se̱ a-doru̱ wa haan e̱ kon wu̱n e̱ u̱zu̱, <<Buz ne̱ta-u inya remu̱ zu̱ wa o̱ do̱rru̱ in wa o̱ e̱kse̱ in!>> ");
INSERT INTO gel_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Se̱ Ye̱so̱ shu̱s wa zu̱, <<Ru̱-u̱ to̱mgu̱n me̱ u̱du̱ ca Isra-ne̱ i e̱nke̱ u̱ war-e̱.>> ");
INSERT INTO gel_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ne̱ta-u ya haan wa he u̱t-jwu̱n wa no̱mu̱ Ye̱so̱ u̱t-huuk, wa zu̱. <<Wa-m-nap, se̱gu̱ me̱!>> ");
INSERT INTO gel_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ye̱so̱ zu̱, <<No̱ng u̱r-zwar na kab no̱m u̱t-re̱ yaag na yasu̱ o̱' da.>> ");
INSERT INTO gel_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ne̱ta-u ya zu̱, <<Wa-m-nap, o̱' re ko̱ te̱k-u̱ no̱m u̱t-re̱ u̱ wa u-bu u̱ he̱ u-dak.>> ");
INSERT INTO gel_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Se̱ Ye̱so̱ zu̱, <<Ne̱ta yadu̱ jab-u̱ ró o̱ u-tát, na kabu̱g ko̱n-u̱s ró,>> Za rem wa'-u̱ rò kum m-yar. ");
INSERT INTO gel_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Du̱gu̱ ku̱n Ye̱so̱ dor kit m-sa yu̱ Gariri, wa du̱u̱s u-do̱m u̱r-ro̱r wa shu̱'u̱t. ");
INSERT INTO gel_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","U̱t-ne̱t u-tát e̱ haan u̱du̱ rò, e̱ hatu̱n ryam-ne̱, u̱ po̱-ne̱ u̱ a-za-u̱s-na ne̱, u̱ a-za ho̱g-du̱ u̱s-rem ne̱ u̱t-ne̱t ne̱ u-tát, na haatu̱n u̱n na ru̱st u̱ shu̱ Ye̱so̱, tu̱msu̱ wa yu̱ u̱n m-yar. ");
INSERT INTO gel_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ne̱t-tu̱ hu̱ mu̱rimmo̱ da-u̱ e̱ hyane̱ a-za u̱s-rem ne̱, u̱ a-za-u̱s-na kwu̱ng m-yar, ryam-ne̱ o̱ m-ha, po̱-ne̱ kwu̱ng m-hyan, e̱ be̱e̱t e̱ no̱mu̱ u-Ru̱ u̱ Isra-ne̱ u̱t-vam. ");
INSERT INTO gel_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Se̱ Ye̱so̱ fog a-doru̱ wa, wa zu̱, <<U̱m o̱ ho̱g-du̱ o̱n-du̱ ne̱t-u̱t tun-to̱, remu̱ zu̱ u̱ ya-o̱ e̱ o̱tte̱ m-roog u̱t-tu̱t e̱ o̱ ane̱ u̱ me̱ ne̱, tu̱msu̱ e̱ zatte̱ no̱m u̱t-re̱ da. U̱m za u̱ssa u̱m to̱k u̱n u̱s-me̱r da, remu̱ zu̱ e̱ke̱n u̱t-byu̱z u̱ do̱m u-fu̱n.>> ");
INSERT INTO gel_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Se̱ a-doru̱ rò zu̱ wu̱n, <<¿He̱ne̱ o̱ na do̱te̱ kwu̱m-du̱ no̱m u̱t-re̱ u̱ de̱ re̱gu̱ssu̱ ban-du̱ u̱t-ne̱t u̱-me̱ do̱g-u̱r din-de̱?>> ");
INSERT INTO gel_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ye̱so̱ shit u̱n, <<¿Be̱re̱di-to̱ u̱t-nu̱ tu̱ no̱ o̱tte̱?>> E̱ zu̱, <<It o̱tte̱ u̱t-be̱re̱di u̱t-ta'er, u̱ jan ne̱ cashi.>> ");
INSERT INTO gel_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Wa zu̱ ban-du̱ u̱t-ne̱t e̱ shu̱'u̱t u-dak. ");
INSERT INTO gel_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Wa ku̱b u̱t-be̱re̱di u̱t-ta'er u̱ jan ne̱ cashi. Da-u̱ wa no̱me̱ u̱t-vam, wa bosor wa yasu̱ a-doru̱ wa, e̱ hen e̱ mo̱tu̱ u̱t-ne̱t. ");
INSERT INTO gel_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","E̱ re, e̱ shig. Da-u̱ e̱ tase̱ a-dor kargu̱sse̱ tu̱ kuse̱ m-te̱ u̱t-ko̱o̱r u̱t-shu̱yi u̱t-ta'er. ");
INSERT INTO gel_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tat-u̱ campa-ne̱ re̱ no̱m u̱t-re̱ o̱, campa-ne̱ u̱t-zo̱ngu u̱t-nas, na ogorte̱ ne̱ta-ne̱ u̱ ya'ag ne̱ da. ");
INSERT INTO gel_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Da-u̱ ne̱t-tu̱ bu̱rge̱, se̱ Ye̱so̱ to u̱-me̱ u-hat m-ha u̱ dak-u̱ Magadan. ");
INSERT INTO gel_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisa-ne̱ u̱ Saduki-ne̱ haan u̱du̱ Ye̱so̱ remu̱ e̱ reg-u̱t wu̱n. E̱ kon wu̱n wa ko̱su̱ u̱n nap-su̱ no̱m-tu̱ m-shin du̱gu̱ do̱m u-ru̱, remu̱ u̱ ko̱ste̱ u̱zu̱ Ru̱-o̱ to̱mnu̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ye̱so̱ shu̱s wa zu̱ u̱n, <<A do̱m u-ru̱ zane̱, no̱ zu̱, <Na de̱ no̱m-du̱ m-ya.> ");
INSERT INTO gel_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tu̱msu̱ a do̱m u-ru̱ rime̱ u̱t-ku̱u̱t, no̱ zu̱, <U̱ ya-o̱ na u̱t-no̱m u-yu̱.> No̱ kere̱ senu̱sse̱ u̱ka da-u̱ o̱tte̱ u̱ do̱m u-ru̱, se̱di no̱ muute̱ jab-u̱s no̱ no̱ nap no̱m-tu̱ Ru̱-u̱ o̱ u̱t-no̱m da. ");
INSERT INTO gel_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ne̱t-u̱t yo̱-to̱ a-za gye̱r-u u-Ru̱ ne̱, no̱ u̱t-sa u̱s-nap su̱ no̱m-tu̱ m-shin, to̱ko̱n no̱m-tu̱ m-shin zaar he̱n da se̱ tu̱ Yunana.>> Ye̱so̱ yage̱ u̱n wa aru̱k. ");
INSERT INTO gel_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Da-u̱ a-dor pase̱ u̱ de̱ku̱n gwu̱gde̱ du̱ m-sa, e̱ baku̱ste̱ kab-du̱ u̱t-be̱re̱di da. ");
INSERT INTO gel_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ye̱so̱ zu̱ u̱n, <<No̱mo̱n ga' u̱ go̱-du̱ yis-mu̱ Farisa-ne̱ u̱ Saduki-ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","E̱ he̱e̱se̱ u̱s-rem m-e̱ m-e̱ u̱zu̱, <<Jiya ko̱b-du̱ u̱r-haan u̱t-be̱re̱di ne̱ o̱ wu̱te̱ wu̱n u̱ rem-u̱s sin-se̱.>> ");
INSERT INTO gel_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Da-u̱ Ye̱so̱ nape̱ no̱m-u̱ e̱ o̱tte̱ u̱s-rem se̱ wa zu̱, <<No̱ a-yadu̱ jab-u̱ ne̱ cashi, ¿remu̱ u-yan o̱ no̱ o̱tte̱ u̱s-rem u̱ te̱k-u̱ no̱ u̱t-zu̱ no̱ zatte̱ u̱t-be̱re̱di da? ");
INSERT INTO gel_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿No̱ gwa'ag u̱r-nu uro da? ¿Kaag no̱ u̱t-to̱ u̱ka u̱m re̱gu̱sse̱ ne̱t-ne̱ u̱t-zo̱ngu u̱t-tan u̱t-be̱re̱di u̱t-tan da? ¿Tu̱msu̱ ko̱o̱r-u̱t yatto̱ u̱t-nu̱ to̱ kuse̱? ");
INSERT INTO gel_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿No̱ baku̱ste̱ ne̱t-ne̱ u̱t-zo̱ngu u̱t-nas i u̱m re̱gu̱sse̱ u̱t-be̱re̱di u̱t-ta'er da? ¿Tu̱msu̱ ko̱o̱r-u̱t yat-to̱ u̱t-nu̱ to̱ kuse̱? ");
INSERT INTO gel_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kamu̱g no̱ nap u̱zu̱, za ma-tu̱ be̱re̱di-du̱ o̱tte̱ m-yis de̱ u̱m o̱tte̱ u̱s-rem da. Se̱di no̱mo̱n ga' u̱ yis-mu̱ Farisa-ne̱ u̱ Saduki-ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","A-doru̱ Ye̱so̱ nu̱p u̱zu̱ Ye̱so̱ za u̱ rem-su̱ u̱ mo̱ttu̱ yis-mu̱ na wu̱ye̱ u̱t-be̱re̱di da, se̱di wa o̱ u̱s-rem o̱ u̱zu̱ e̱ no̱m ga' u̱ go̱-du̱ ko̱se̱-u̱t Farisa-ne̱ u̱ Saduki-ne̱. ");
INSERT INTO gel_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Da-u̱ Ye̱so̱ haane̱ u̱ dak-u̱ Kasariya Firibi, wa shit a-doru̱ wa u̱zu̱, <<¿Wana ne̱t-tu̱ zu̱ Wa'-u̱ Ne̱t o̱ye̱?>> ");
INSERT INTO gel_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Se̱ e̱ zu̱, <<E̱ke̱n zu̱ Yohanna wa-u̱t-yu̱bu̱sse̱ m-bu̱, e̱ke̱n zu̱ Iriya wa, tu̱msu̱ e̱ke̱n zu̱ Irmiya, ko̱ waku̱n u̱ te̱k-u̱ a-warru̱ rem-su̱ u-Ru̱ ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ye̱so̱ zu̱ u̱n, <<¿No̱ wa no̱ o̱ u̱t-zu̱ wa u̱m o̱ye̱?>> ");
INSERT INTO gel_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simo̱n Biturus shu̱s wa zu̱, <<Bo̱ wa Kiristi Wa'-u̱ u-Ru̱ u̱r-fat.>> ");
INSERT INTO gel_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ye̱so̱ shu̱s wa zu̱, <<Bo̱ o̱ kom u-Ru̱ ne̱ Simo̱n wa'-u̱ Yunana! U̱m zu̱u̱g iya remu̱ zu̱ a ne̱t wa waru̱ bo̱ sin-se̱ rem-se̱ da, se̱di U̱so-u ri wu̱ o̱ do̱m u-ru̱. ");
INSERT INTO gel_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","U̱m o̱ hen u̱ waru̱ bo̱, bo̱ wa o̱ Biturus (wu̱ foge̱ u̱r-taar), u̱ do̱m-u̱ taar-u̱r rinde̱ de̱ u̱m de̱te̱ ma-du̱ a-doru̱ Ye̱so̱ ne̱, tu̱msu̱ be̱b-du̱ m-mar de̱ za kwu̱m-du̱ u̱r-be̱b u̱ do̱m-u̱ o̱ da. ");
INSERT INTO gel_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","U̱m de̱ yadu̱ bo̱ go̱r-yu̱ Faru̱k-du̱ u-ru̱, no̱m-u̱ no̱ hoose̱ u̱-me̱ u-dak, Ru̱-u̱ de̱ hoosu̱ o̱ do̱m u-ru̱, tu̱msu̱ no̱m-u̱ bo̱ ya be̱b-du̱ u̱t-no̱m u̱-me̱ u-dak, Ru̱-u̱ de̱ yadu̱ be-du̱ u̱t-no̱m u̱ do̱m u-ru̱.>> ");
INSERT INTO gel_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Se̱ wa nu̱k a-doru̱ wa u̱t-to̱ u̱zu̱ a e̱ waru̱ waku̱n u̱zu̱ wa o̱ Kiristi da. ");
INSERT INTO gel_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Du̱gu̱ da-u o̱ Ye̱so̱ he̱e̱se̱ waru̱ a-doru̱ wa u̱zu̱, zatte̱ ka u̱t-no̱m da, se̱ wa de̱ge̱ u̱ Urusharima wa swa u̱r-ko̱b u̱t-go̱ u̱t-go̱ u̱ kom-tu̱ u̱t-ne̱nge̱n, u̱ i-Yate̱ a-To̱o̱g-ne̱, u̱ a-ko̱se̱-tu̱ u-bo̱r ne̱, tu̱msu̱ e̱ ho̱ wa, u̱ ho̱-du̱ u-tu̱tu̱rse̱ wa yu̱ne̱ du̱gu̱ marimari-ne̱. ");
INSERT INTO gel_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Biturus nu̱k wu̱n u̱ kit wa no̱mu̱ wu̱n u̱t-him u̱zu̱, <<U̱ Ru̱-u̱ hast, Wa-m-nap, se̱se̱ zaru̱ kwu̱m-du̱ bo̱ da!>> ");
INSERT INTO gel_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ye̱so̱ bir wa zu̱ Biturus, <<Hate̱ u̱ be-du̱ u̱m o̱tte̱, bo̱ faru̱k-u̱ no̱m u̱s-te! Bo̱ yu̱ u̱t-sa wadu̱ me̱ u̱r-he̱'e̱, remu̱ zu̱ dorog-u̱s ró su̱ ne̱t se̱, za u̱ka u-Ru̱ da.>> ");
INSERT INTO gel_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ye̱so̱ zu̱ a-doru̱ wa, <<Wu̱ u̱t-sa do̱rru̱ me̱ se̱ wa gu̱gu̱mte̱ hi-u̱r wa, wa kab kan-u wa, wa do̱r me̱. ");
INSERT INTO gel_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wu̱ o̱ u̱kru̱ fat-u̱r wa, wa de̱ u̱t-taag u̱ de̱. Tu̱msu̱ wu̱ taage̱ fat-u̱r wa remu̱ ri, wa de̱ kwu̱m-du̱ de̱. ");
INSERT INTO gel_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Yan-o̱ ne̱t de̱ u̱t-kwu̱me, da-u̱ wa kume̱ kwu̱m-tu̱ dak-u uno̱ wa taag u̱ fat-u̱r wa? ¿Ko̱ yan-o̱ ne̱t de̱ u̱t-ya u̱ka m-swasa remu̱ fat-u̱r wa? ");
INSERT INTO gel_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Wa'-u̱ ne̱t de̱ haan u̱ a-to̱m u-Ru̱ ne̱ u̱-me̱ fu̱'u̱bse̱-u̱t U̱so-u wa, wa to̱p kowan to̱p-u̱ no̱mu̱ wa no̱me̱. ");
INSERT INTO gel_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","U̱m o̱ waru̱ no̱ u̱t-nip, e̱ke̱n o̱ro u̱ ees u̱ ane̱ i za m-mar da, se̱ e̱ hyanu̱g haan-du̱ Wa'-u̱ Ne̱t u̱-me̱ faru̱k-u̱r wa.>> ");
INSERT INTO gel_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Da-u̱ roog-mu̱ shishin arke̱ Ye̱so̱ ku̱b Biturus, u̱ Yakubu, u̱ Yohanna ne̱ hu̱u̱b u̱r-matu̱ wane̱ Yakubu, wa hu̱u̱t u̱n u̱ de̱ku̱n ro̱r-de̱ du̱ m-wu̱r, u̱ war u̱n. ");
INSERT INTO gel_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","U̱n o̱ u̱ku̱n se̱ sha-m Ye̱so̱ baru̱m. Shu̱-u wa no̱m m-zu̱n u̱ka zu̱n-mu̱ u̱r-ho̱, tu̱msu̱ kus-tu̱ wa wa'e̱ to̱ no̱m u̱ pus-to̱ u̱ka m-zu̱n. ");
INSERT INTO gel_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Za rem, se̱ Iriya wa-warru̱ rem-su̱ u-Ru̱ u̱ Mosa ne̱ rwu̱n u̱du̱ u̱n, e̱ o̱ u̱s-rem u̱ Ye̱so̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Biturus zu̱ Ye̱so̱, <<Wa-m-nap, no̱ng u̱r-zwar u̱ na o̱tte̱ u̱ ane̱. A-bo̱ ese̱ u̱m de̱ kadu̱ u̱t-rimpa u̱t-tu̱t, du̱ ró u̱r-gan, u̱r-gan du̱ Mosa u̱r-gan tu̱msu̱ du̱ Iriya wa-warru̱ rem-su̱ u-Ru̱.>> ");
INSERT INTO gel_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wa o̱ te̱k-u̱ u̱s-rem, se̱ de̱ku̱n ku̱'u̱t-de̱ du̱ m-zu̱n gu̱ru̱s u̱n be̱e̱t, tu̱msu̱ e̱ ho̱g u-cwar u̱-me̱ u̱r-ku̱'u̱t ya o̱ u̱t-zu̱, <<Unwa o̱ Wa'-u̱ ri, wu̱ u̱m o̱ u̱t-cwan, tu̱msu̱ u̱m hog zwar-u̱r rò sok, e̱re̱n wu̱n.>> ");
INSERT INTO gel_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Da-u̱ a-dor ho̱ge̱ iya gye̱r-u̱ ship u̱n sok har e̱ he m-ho̱bo̱g. ");
INSERT INTO gel_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ye̱so̱ haan wa tu̱m u̱n wa zu̱, <<Yu̱nu̱n, a no̱ ho̱g u-gye̱r da!>> ");
INSERT INTO gel_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Da-u̱ e̱ jakse̱ u̱t-hi, e̱ hyang waku̱n da, se̱ Ye̱so̱ u̱ war-wa. ");
INSERT INTO gel_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Da-u̱ e̱ o̱ cu̱zu̱n du̱gu̱ do̱m u̱r-ro̱r, Ye̱so̱ no̱mu̱ u̱n u̱t-him, wa zu̱, <<A no̱ waru̱ waku̱n no̱mu̱ no̱ hyane̱ da, se̱ Wa'-u̱ Ne̱t yu̱nge̱ du̱gu̱ marimari-ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","A-dor shit wu̱n e̱ zu̱, <<¿Yan-o̱ wu̱te̱ a-ko̱se̱-tu̱ u-bo̱r ne̱ u̱t-zu̱, se̱ wa-warru̱ rem-su̱ u-Ru̱ Iriya baag m-haane̱?>> ");
INSERT INTO gel_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ye̱so̱ shu̱s wa zu̱, <<Iya o̱ Iriya de̱ haan wa mang ko-uyan. ");
INSERT INTO gel_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Se̱di u̱m o̱ waru̱ no̱, Iriya baag u̱ hagu̱n, e̱ nak wu̱n da, har e̱ no̱mu̱ wu̱n no̱mu̱ cwane̱ u̱ jab-u̱s e̱. Iya hen Wa'-u̱ Ne̱t de̱ swadu̱ u̱r-ko̱b u̱ ko̱m-u̱t u̱n.>> ");
INSERT INTO gel_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","A-dor nu̱p u̱zu̱, rem-u̱s Yohanna wa-u̱t-yu̱bu̱sse̱ m-bu̱ se̱ wa o̱ no̱mu̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Da-u̱ e̱ cwaye̱ be-du̱ mo̱ro̱g-du̱ u̱t-ne̱t o̱tte̱, yaku̱n campa-ya haan u̱du̱ Ye̱so̱ wa he u̱t-jwu̱n u̱ shu̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","<<Wa-m-nap, ho̱g o̱n-du̱ wa zwar-u̱ ri. Wa o̱tte̱ go̱m-su̱ u̱r-he̱'e̱, tu̱msu̱ wa o̱ swadu̱ u̱r-ko̱b sok. O̱ko̱n da-o̱ wa he̱ u̱-me̱ u-ra, o̱ko̱n da-o̱ u̱-me̱ m-bu̱. ");
INSERT INTO gel_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","U̱m hu̱u̱te̱ wu̱n u̱du̱ a-doru̱ ró, e̱ hen e̱ kerge̱ has-tu̱ go̱m-u̱s se̱ da.>> ");
INSERT INTO gel_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ye̱so̱ zu̱, <<No̱ ne̱t-tu̱ uno̱ da-o̱, a-ko̱b-du̱ yadu̱ jab, a-jab-u̱s yo̱-se̱! ¿Yan da-o̱ u̱m de̱ u̱t-kere̱ u̱r-shu̱'u̱t u̱ no̱ ne̱? Hatu̱n wa'-u̱ ró u̱ ane̱.>> ");
INSERT INTO gel_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ye̱so̱ hagu̱sse̱ no̱m-yu̱ u̱s-te, no̱m-yu̱ u̱s-te ru, wa zwar kum m-yar. ");
INSERT INTO gel_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","A-doru̱ Ye̱so̱ haan u̱du̱ Ye̱so̱ da-u̱ waku̱n zare̱ u̱ku̱n da, e̱ shit Ye̱so̱ u̱zu̱, <<¿Remu̱ yan o̱ wu̱te̱ it kerge̱ rutu̱ no̱m-yu̱ u̱s-te ya da?>> ");
INSERT INTO gel_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ye̱so̱ zu̱ u̱n, <<No̱ kerge̱ bu̱z-du̱ no̱m-yu̱ u̱s-te ya da, remu̱ zu̱ yadu̱ jab-u̱ no̱ o̱ cashi. U̱m o̱ waru̱ no̱ u̱t-nip, a no̱ o̱tte̱ yadu̱ jab u̱ka ya-yu̱ mastad, ya-yu̱ zege̱ u̱s-re̱k u̱ te̱k-u̱ go̱ u̱t-no̱m, no̱ keru̱ zu̱ ro̱r-u̱r din-de̱, <Mu'us m-ha u̱ ana> jit, tu̱msu̱ de̱ mu'us. O̱ko̱n zaar u̱ ze̱ge̱ be̱b-u̱r no̱ da.>> ");
INSERT INTO gel_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Da-u̱ a-dor mo̱rge̱ u̱ dak-u̱ Gariri, se̱ Ye̱so̱ zu̱ u̱n, <<E̱ke̱n de̱ yasu̱ Wa'-u̱ Ne̱t u̱ kom-tu̱ u̱t-ne̱t. ");
INSERT INTO gel_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tu̱msu̱ e̱ do̱'e̱ ho̱-du̱ wu̱n. U̱ ho̱-du̱ u-tu̱tu̱rse̱ na de̱ yu̱nsu̱ wa du̱gu̱ marimari-ne̱.>> No̱mu o̱ zusu̱ a-dor-ne̱ sok. ");
INSERT INTO gel_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Da-u̱ Ye̱so̱ u̱ a-doru̱ wa ne̱ te bo̱-u̱ Kapanahum, a-o̱nku̱ shik-u̱ tar haan u̱du̱ Biturus u̱ mo̱ttu̱ ta'ar-ru̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan e̱ zu̱, <<Waru̱n it ko̱ wa-u̱t-ko̱se̱ no̱ top-u̱t shik-u̱ tar.>> ");
INSERT INTO gel_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Biturus zu̱, <<U̱, wa top.>> Da-u̱ Biturus mu̱ne̱ u-bu, se̱ Ye̱so̱ he̱e̱se̱ no̱mu̱ wu̱n u̱s-rem u̱zu̱, <<¿Yan o̱ bo̱ hyane̱ u̱ mo̱ttu̱ shu̱t-u̱r re̱? ¿No̱ o̱ m-hyan faru̱k-tu̱ o̱nk shik-u̱ tar u̱du̱ ne̱t-tu̱ bo̱-u̱ e̱? ¿Ko̱ no̱ o̱ m-hyan faru̱k-tu̱ o̱nk shik-u̱ tar u̱du̱ ne̱t-tu̱ na re̱ m-gag?>> ");
INSERT INTO gel_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Biturus zu̱, <<U̱du̱ e̱ke̱n.>> Ye̱so̱ zu̱, <<Shu̱'u̱te̱ u̱zu̱ u̱n top-u̱t da. ");
INSERT INTO gel_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ko ba shu̱'u̱te̱ iya, taas u̱ ne̱t-u̱t tun-to̱ ho̱g ryab-u̱s in da, do̱'e̱ bo̱ gun kwe̱nhi-yu̱ masu̱ jan, bo̱ upus nu-u̱ jan-yu̱ bo̱ he̱e̱se̱ u̱t-mas bo̱ u̱t-hyan shik u̱-me̱. Kab e̱ bo̱ to̱p shik-u̱ tar i ró u̱ i ri ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","U̱ te̱k-u̱ da-u o̱, a-dor haan u̱du̱ Ye̱so̱ e̱ shit wu̱n u̱zu̱, <<¿Wana o̱ yu̱-shu̱ u̱-me̱ faru̱k-du̱ u-Ru̱?>> ");
INSERT INTO gel_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ye̱so̱ kabu̱n ya-u̱r re̱k-de̱, wa egu̱sse̱ wa u̱-me̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ye̱so̱ zu̱, <<U̱m o̱ waru̱ no̱ u̱t-nip, a ne̱t u̱ muute̱ hi-u̱r wa u̱ka ya-u̱r re̱k-de̱ wa za tamu̱ cwadu̱ Faru̱k-du̱ u-ru̱ da. ");
INSERT INTO gel_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Remu̱ iya wu̱ mute̱ hi-u̱r wa u̱ka ya-u̱r re̱k-de̱ wa de̱ shu̱'u̱tu̱ yu̱-Yat-ya u̱-me̱ faru̱k-du̱ u-ru̱. ");
INSERT INTO gel_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","<<Tu̱msu̱ i kabe̱ ya-u̱r re̱k-de̱ din-de̱ remu̱ zu̱ e̱ o̱ cwan-u̱t ri, me̱ wa e̱ kabe̱. ");
INSERT INTO gel_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ko̱wana wa'e̱ wa-gan u̱ te̱k-u̱ i-re̱k-e̱ ine̱ i ya' jab u̱du̱ ri u̱ no̱m-du̱ u̱t-ba'as, u̱t-ze̱g u̱r-zwar na gagu̱ wa ta'ar-du̱ u̱r-na u̱ ge̱ksu̱ wa, na gun wa u̱-me̱ m-sa. ");
INSERT INTO gel_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","<<No̱m-tu̱ u̱r-o̱n u̱du̱ dak-u uno̱ u̱ remu̱ no̱m-tu̱ wadu̱ ne̱t u̱ no̱m-du̱ u̱t-ba'as de̱ haan. No̱m-tu̱ wadu̱ ne̱t u̱t-ba'as to̱ haan, Se̱di u̱ shu̱'u̱tu̱ no̱m-tu̱ u̱r-o̱n u̱ wu̱ de̱ wadu̱ waku̱n u̱ no̱m-du̱ u̱t-ba'as. ");
INSERT INTO gel_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","A kom-u ró ko̱ na-u ró o̱ wadu̱ bo̱ u̱ no̱m-du̱ u̱t-ba'as, kupse̱ bo̱ ju̱re̱. U̱t-ze̱g bo̱ cwa u̱ fat-du̱ za u̱r-ma u-kom ne̱ u-gan ko̱ u-na u-gan ko̱ ryam, u̱ na gunt bo̱ u̱ me̱n-tu̱ u-ra u̱ za u̱t-mar da, u̱ kom-u̱t ró ne̱ u̱t-yu̱r ko̱ u̱s-na u̱s-yu̱r. ");
INSERT INTO gel_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","A mu̱ne̱ is-u̱r ró u̱ wa bo̱ u̱ no̱m-du̱ u̱t-ba'as, se̱ bo̱ hast bo̱ rest. U̱t-ze̱g bo̱ cwa u̱ fat-du̱ za u̱r-ma u̱r-is ne̱ u̱r-gan u̱na gun bo̱ u̱ bu-u ra-u̱ za u̱t-mar da u̱ is-ne̱ yu̱r. ");
INSERT INTO gel_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","<<Gwatu̱n a no̱ ju̱ru̱m waku̱n u̱ te̱k-u̱ ine̱ yaage̱ da. Remu̱ u̱m o̱ waru̱ no̱ a-to̱m u-Ru̱ u̱n ne̱, o̱ u̱r-yu̱ u̱du̱ U̱so-u ri wu̱ o̱ do̱m u-ru̱, e̱ de̱ waru̱ u-Ru̱ a no̱ no̱mu̱ yaag no̱m-u̱t so̱-to̱ da. ");
INSERT INTO gel_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Yan o̱ no̱ o̱ m-hyane̱? A wa-gwat-du̱ ca u̱t-shik u̱t-tan, u-gan u̱ te̱k-u̱ e̱ ya e̱nk, ¿wa da yagu̱ ca u̱t-shik u̱t-tan za u-gan wa do̱'e̱ go-tu̱ yu̱ e̱nke̱ da? ");
INSERT INTO gel_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A mu̱ne̱ zu̱ wa hyanu̱g ya, u̱m o̱ waru̱ no̱ u̱t-nip, so̱-du̱ wa de̱ u̱t-no̱m remu̱ yu̱ e̱nke̱ ya, u̱t-ze̱g u̱t-ko̱k u̱t-tan za u-gan i o̱ za e̱nk. ");
INSERT INTO gel_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Iya o̱ he̱n, cwan-tu̱ U̱so-u no̱ to da wu̱ o̱ do̱m u-ru̱ u̱ wa-gan u̱ e̱nk u̱ te̱k-u̱ me̱ yaag ine̱. ");
INSERT INTO gel_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","<<A o̱r-u̱ ró no̱mu̱ bo̱ u̱t-ba'as do̱'e̱ bo̱ ko̱su̱ wa u̱zu̱ wa no̱ngu̱ bo̱ u̱t-ba'as, no̱ wa ne̱ yu̱r. A ne̱tu̱ wa e̱ru̱ bo̱, bo̱ mu̱ttu̱n wa u̱-do̱m u-fu̱n. ");
INSERT INTO gel_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Se̱di a wa e̱ru̱ bo̱ da, se̱ bo̱ mang m-ha u̱ ne̱t gan ne̱ ko̱ ne̱t-ne̱ yu̱r, remu̱ ko̱-uyan rem-se̱ na ku̱b remu̱ war-mu̱ ne̱t-ne̱ yu̱r ko̱ ne̱t-ne̱ tu̱t. ");
INSERT INTO gel_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","A o̱r-u̱ ró gu̱gme̱ e̱rru̱ u̱n, se̱ bo̱ waru̱ a-doru̱ Ye̱so̱ ne̱, a wa gu̱gme̱ e̱rru̱ a-dor-ne̱, muute̱ wa u̱ka wu̱ nape̱ u-Ru̱ da, ko̱ wa-o̱nku̱ shik-u̱ tar. ");
INSERT INTO gel_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","<<U̱m o̱ waru̱ no̱ u̱t-nip, no̱m-u̱ no̱ hoose̱ u̱-me̱ u-dak, Ru̱-u̱ de̱ hoosu̱ o̱ do̱m u-ru̱, tu̱msu̱ no̱m-u̱ bo̱ ya be̱b-du̱ u̱t-no̱m u̱-me̱ u-dak, Ru̱-u̱ de̱ yadu̱ be̱b-du̱ no̱m-du̱ o̱ u̱ do̱m u-ru̱. ");
INSERT INTO gel_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","<<U̱m o̱ hen u̱ waru̱ no, a ne̱t-ne̱ yu̱r u̱ ane̱ u-dak, e̱ eese̱ e̱ kon o̱ko̱n no̱m-o̱, U̱so-u ri wu̱ o̱ do̱m u-ru̱ wa no̱mu̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","U̱m zu̱u̱g iya remu̱ zu̱ be-du̱ ne̱t-ne̱ yu̱r ko̱ tu̱t mo̱ro̱gte̱ remu̱ zu̱ e̱ yaag jab u̱du̱ ri, u̱m o̱ u̱r-kot u̱ e̱ ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Na o̱ u̱ku̱n Biturus haan wa zu̱ Ye̱so̱, <<Wa-m-nap, ¿so-o̱ u-nu o̱r-u̱ ri de̱ no̱mu̱ me̱ u̱t-ba'as, u̱m no̱mu̱ wa u̱r-ho̱? ¿U-so u-ta'er?>> ");
INSERT INTO gel_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ye̱so̱ zu̱ wu̱n, <<Za u-so u-ta'er da, se̱di u-so u̱t-shik u̱t-tu̱t u̱ o̱p u-so u-ta'er 490 za u̱r-ma. ");
INSERT INTO gel_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","<<Remu̱ iya, faru̱k-du̱ u-Ru̱ o̱ u̱ka waku̱n faru̱k wa wu̱ u̱t-sa wa ogor kwu̱m-u̱t wa tu̱ o̱ kom-tu̱ to̱k-ne̱ wa. ");
INSERT INTO gel_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Da-u̱ faru̱k tak-ne̱ u̱t-ogor, se̱ na haatu̱n wa waku̱n ne̱t wa, wu̱ faru̱k dore̱ u̱r-mag, shik u-tát i ne̱t za u̱t-kere̱ u̱t-to̱p u̱ yu̱-u̱r wa u̱r-be̱e̱t da. ");
INSERT INTO gel_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ba wa ku̱su̱n u̱t-to̱p se̱ faru̱k wu̱ na bu̱b wa u̱ ne̱ta wa ne̱ u̱ ya'ag-u̱ wa ne̱, u̱ no̱m-u̱ wa o̱tte̱ ne̱ u-be̱e̱t wa to̱p u̱r-mag. ");
INSERT INTO gel_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","<<Se̱ to̱k-u̱ wa he u̱t-jwu̱n u̱ shu̱ faru̱k wa o̱ u̱s-ko̱n wa zu̱, <Ho̱g o̱n-u̱r ri, me̱ to̱p-u̱ ko-uyan!> ");
INSERT INTO gel_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Se̱ faru̱k hog o̱n-du̱ to̱ku̱ wa, wa yagu̱ wu̱n wa aru̱k, wa zu̱ a wa to̱p mag-u̱r re̱ da. ");
INSERT INTO gel_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","<<Se̱di to̱k-u̱ wa da-u̱ wa ruye̱ se̱ wa bit hu̱u̱b m-ank wa, wu̱ wa dore̱ u̱r-mag shik cashi, wa soos wu̱n u-cwar, wa zu̱, <To̱p me̱ no̱m-u̱ u̱m dore̱ bo̱!> ");
INSERT INTO gel_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","<<Se̱ hu̱u̱b m-ank-u̱ rò he u̱t-jwu̱n u̱ shu̱ rò, wa kon wu̱n wa zu̱, <No̱mu̱ me̱ u̱r-ho̱, me̱ to̱p-u̱ bo̱!> ");
INSERT INTO gel_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","<<Se̱di to̱ku̱ wa gu̱gu̱m, wa hu̱u̱t wu̱n u̱ bu-u̱ m-to̱k, wa zu̱ se̱ wa to̱po̱k mag-u̱r re̱. ");
INSERT INTO gel_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Da-u̱ hu̱u̱b-tu̱ m-ank-u̱ rò ho̱ge̱ no̱mu̱ no̱me̱, e̱ ho̱k u̱r-zwar da. Se̱ e̱ do̱'e̱ e̱ waru̱ faru̱k no̱mu̱ no̱me̱ u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","<<Faru̱k fog to̱ku̱ wa wa zu̱, <Bo̱ to̱k yo̱-o̱ wa. U̱m no̱ngu̱ ho̱-du̱ mag-du̱ u̱m doru̱ bo̱ remu̱ zu̱ bo̱ ko̱no̱g me̱. ");
INSERT INTO gel_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Kamu̱g u̱zu̱ bo̱ ho̱g o̱n-du̱ hu̱u̱b m-ank-u̱ ró, u̱ka u̱m hogte̱ o̱n-u̱r ró da?> ");
INSERT INTO gel_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Faru̱k hog m-ku̱wu̱t sok, se̱ wa wu̱ na ya' wu̱n u̱r-ko̱b wa to̱p no̱m-u̱ wa doru̱ wa u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","<<Iya o̱ hen Uso-u ri wu̱ do̱m u-ru̱ do̱te̱ no̱mu̱ wu̱ gu̱gme̱ no̱mu̱ o̱r-u̱ wa u̱r-ho̱ jab gan.>> ");
INSERT INTO gel_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Da-u̱ Ye̱so̱ tase̱ warru̱ rem-u̱s se̱, wa yage̱ Gariri, wa do̱'e̱ u̱ dak-u̱ Yahudiya u̱ gwu̱g-du̱ u-do̱m du̱ Gi-yu̱ Yodan. ");
INSERT INTO gel_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ban-du̱ u̱t-ne̱t dor wu̱n u̱ku̱n, tu̱msu̱ wa hastu̱ ne̱t-ne̱ go̱m-u̱s e̱. ");
INSERT INTO gel_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","E̱ke̱n Farisa-ne̱ haan e̱ reg-u̱t wu̱n u̱ din-de̱ shu̱t-de̱ u̱zu̱, <<¿Bo̱r-u̱t in tu̱ Yahuda-ne̱ yaag ne̱t be̱b-du̱ yan-du̱ ne̱ta wa u̱ remu̱ ko̱-uyan rem o̱?>> ");
INSERT INTO gel_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ye̱so̱ zu̱ u̱n, <<No̱ karu̱nte̱ rem-su̱ u-Ru̱, kamu̱g no̱ nap u̱zu̱ da-u̱ Ru̱-u̱ no̱me̱ ne̱t du̱gu̱ u̱r-taku̱n, <Ru̱-u̱ no̱mu̱g campa gan wa nom ne̱ta gan remu̱ e̱ shu̱'u̱te̱ ne̱ta e̱ campa.> ");
INSERT INTO gel_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ko̱ske̱ no̱m-u̱ Ru̱-u̱ ware̱ u̱zu̱, <Ne̱t de̱ yagu̱ Uso-u wa u̱ ino-u wa ne̱ wa dap ne̱ta wa, e̱ yu̱r hen e̱ shu̱'u̱t ne̱t gan.> ");
INSERT INTO gel_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Remu̱ iya e̱ zamu̱n ne̱t-ne̱ yu̱r da se̱di ne̱t gan. Remu̱ iya hen, no̱mu̱ Ru̱-u̱ same̱ a waku̱n u̱ mo̱t da.>> ");
INSERT INTO gel_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","E̱ shit u̱zu̱, <<¿Remu̱ yan-o̱ Mosa wu̱rte̱ bo̱r-tu̱ yan-du̱ ne̱ta, u̱zu̱ wu̱ o̱ yan-du̱ ne̱ta wa, wa pan ran-u̱ u̱t-yane̱?>> ");
INSERT INTO gel_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ye̱so̱ zu̱ u̱n, <<Remu̱ hok-tu̱ u̱t-to̱ no̱ o̱ wu̱te̱ Mosa yagte̱ u̱ ne̱t u̱ yan ne̱ta wa. Se̱di da Ru̱-o̱ no̱me̱ campa e̱ ne̱ta, wa cu̱ng u̱zu̱ e̱ mo̱t da. ");
INSERT INTO gel_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","U̱m o̱ hen u̱ waru̱ no̱, wu̱ yane̱ ne̱ta wa, wa gu̱ waku̱n, a-za remu̱ m-o̱ da, as-o̱ wa o̱tte̱.>> ");
INSERT INTO gel_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","A-doru̱ Ye̱so̱ zu̱ wu̱n, <<Abite̱ iya o̱, ze̱k u̱r-zwar u̱ ne̱t u̱ shu̱'u̱t za u̱r-gu̱.>> ");
INSERT INTO gel_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ye̱so̱ zu̱ u̱n, <<Ru̱-u̱ se̱gu̱ to̱ko̱n ne̱t-to̱ e̱ kab ko̱se̱-u̱t tun-to̱. E̱ war-e̱ de̱ kere̱ u̱r-yu̱ za no̱m-du̱ u̱r-gu̱. ");
INSERT INTO gel_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","E̱ke̱n o̱ro i na mate̱ maku̱t-ne̱, e̱ke̱n hen ne̱t-tu̱ muute̱ e̱ iya, tu̱msu̱ e̱ke̱n o̱ro i zu̱ e̱ za u̱r-gu̱ da remu̱ Faru̱k-du̱ u-Ru̱. Yage̱ wa u̱t-kab wa kab rem-u̱s sin-se̱.>> ");
INSERT INTO gel_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","De̱ku̱n ho̱-de̱ na hatu̱n Ye̱so̱ yaag remu̱ wa do̱r-tu̱ e̱ u̱t-kom tu̱msu̱ wa no̱m-tu̱ e̱ u̱s-to̱o̱g. A-doru̱ Ye̱so̱ hagu̱sse̱ a ya'ag ne̱ u̱zu̱ e̱ o̱ e̱kse̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ye̱so̱ zu̱, <<Yagu̱n u̱ yaag u̱ haan u̱du̱ ri! A no̱ buz u̱n da, remu̱ zu̱ Faru̱k-du̱ u-Ru̱ o̱ do̱m-u̱ i o̱ u̱ka yaag ine̱.>> ");
INSERT INTO gel_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wa doru̱ u̱n u-kom wa wa'-u̱ u̱n nu-u so̱-o̱ kanda wa yagte̱ ku̱n. ");
INSERT INTO gel_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Waku̱n haan u̱du̱ Ye̱so̱ wa zu̱, <<Wa-m-nap, ¿yan no̱m-u so̱-o̱ u̱m de̱ u̱t-no̱m u̱m kum-u̱t fat-du̱ za u̱r-ma?>> ");
INSERT INTO gel_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ye̱so̱ zu̱ wu̱n, <<¿Remu̱ u-yan o̱ bo̱ shit-tu̱ mo̱t-tu̱ no̱m-u so̱-o̱? Ru̱-o̱ o̱ so̱-o̱ war-wa. A-bo̱ u̱t-sa bo̱ kum fat-du̱ za u̱r-ma, se̱ bo̱ do̱ro̱g bo̱r-u̱t wa ho̱n-ho̱n.>> ");
INSERT INTO gel_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Campa-u ya zu̱, <<¿Yan bo̱r-to̱?>> Ye̱so̱ shu̱s wa zu̱, << <A-bo̱ ho̱ ne̱t da, a-bo̱ no̱m m-o̱ da, a-bo̱ no̱m u-hiw da, a-bo̱ ke̱tu̱ waku̱n u̱s-rem da. ");
INSERT INTO gel_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ya u̱so-u ró m-ze̱g u̱ ino-u ró ne̱, tu̱msu̱ bo̱ cwan wa-bo̱ru̱ ró u̱ka bo̱ o̱tte̱ cwan-tu̱ hi-du̱ war ró.> >> ");
INSERT INTO gel_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Wa-u̱ be̱b zu̱, <<U̱m do̱ro̱g bo̱r-u̱t to̱ u̱t-be̱e̱t. ¿Yan-o̱ kuse̱ u̱m de̱ u̱t-no̱me̱?>> ");
INSERT INTO gel_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ye̱so̱ zu̱ wu̱n, <<A-bo̱ u̱t-sa bo̱ shu̱'u̱t u-shu̱yi shu̱yi, do̱'e̱ bo̱ bab no̱m-tu̱ bo̱ o̱tte̱ u̱t-be̱e̱t, bo̱ mo̱tu̱ a-u̱r-ko̱b-ne̱ shik-u̱ e̱. Bo̱ de̱ no̱m-du̱ u̱t-kwu̱m u̱ do̱m u-ru̱, se̱ bo̱ haan bo̱ do̱r me̱.>> ");
INSERT INTO gel_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Da-u̱ wa-u̱ be̱b ho̱ge̱ iya, se̱ wa aru̱k jab nayi-nayi, remu̱ zu̱ wa o̱tte̱ u̱t-kwu̱m sok. ");
INSERT INTO gel_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ye̱so̱ zu̱ a-doru̱ wa, <<U̱m o̱ waru̱ no̱ u̱t-nip, u̱t-shu̱'u̱t u̱t-po̱ ne̱ u̱ wa-u̱t-kwu̱m u̱ to-u̱t u̱ Faru̱k-du̱ u-ru̱. ");
INSERT INTO gel_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","U̱m o̱ tu̱msu̱ waru̱ no̱, u̱t-ze̱g m-ku̱k u̱ rakum-yu̱ cwa u̱-me̱ hu̱-yu̱ u-be̱r, u̱ wa-u̱t-kwu̱m u̱ to-u̱t u̱ Faru̱k-du̱ u-Ru̱.>> ");
INSERT INTO gel_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Da-u̱ a-dor ho̱ge̱ iya e̱ hu̱ mu̱rimmo̱, e̱ zu̱, <<¿Abite̱ iya o̱ wana de̱ kwu̱m-du̱ u-u̱ku̱r?>> ");
INSERT INTO gel_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ye̱so̱ got u̱n wa zu̱, <<U̱du̱ ne̱t za u̱t-no̱me̱ da se̱di u̱du̱ u-Ru̱ ko-uyan su̱ u̱t-no̱me̱ se̱.>> ");
INSERT INTO gel_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Biturus zu̱, <<Gwat, it yakke̱ ko-uyan remu̱ it dor-u̱t bo̱, ¿se̱di yan-o̱ it de̱ u̱t-kwu̱m?>> ");
INSERT INTO gel_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ye̱so̱ zu̱ u̱n, <<U̱m o̱ waru̱ no̱ u̱t-nip, da-u̱ o̱ haan, da-u̱ Wa'-u̱ Ne̱t do̱'e̱ u̱t-shu̱'u̱t u̱ pora-du̱ u̱r-faru̱k du̱ u̱t-fu̱'u̱bse̱ wa. No̱ do̱ru̱ me̱, no̱ do̱'e̱ u̱t-shu̱'u̱t u̱ pora-tu̱ u̱r-faru̱k tu̱ u̱t-rem o̱p-u̱t yu̱r, no̱ kwu̱pu̱ rem-tu̱ o̱p u̱ u̱t-yu̱r tu̱ Isra-ne̱ u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tu̱msu̱ wu̱ yage̱ u̱t-bu, ko̱ hu̱no-u̱t wa ne̱ ne̱ta-ne̱ ko̱ campa-ne̱, ko̱ u̱so-u wa u̱ ino-u wa ne̱ ko̱ yaag, ko̱ u̱t-tak, remu̱ wa o̱ do̱rru̱ me̱, wa de̱ u̱t-kwu̱m u-so u-tát, tu̱msu̱ wa de̱ kwu̱m-du̱ fat-du̱ za u̱r-ma. ");
INSERT INTO gel_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tu̱msu̱ ne̱t-ne̱ u-tát i o̱ u̱r-taku̱n, e̱ de̱ u̱t-mu̱ a u̱r-vaste̱, a u̱r-vaste̱ e̱ de̱ u̱t-shu̱'u̱t a u̱r-taku̱n.>> ");
INSERT INTO gel_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ye̱so̱ re shu̱ u̱t-zu̱, <<Faru̱k-du̱ u-ru̱ o̱ u̱ka wa-u-bu, wu̱ ruye̱ u̱r-wu̱n u̱r-wu̱n u̱ sa-u̱ i de̱ no̱mu̱ wa-m-ank-u̱ tak-u̱ inabi. ");
INSERT INTO gel_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Da-u̱ e̱ ho̱ngu̱sse̱ u̱ no̱mu̱ wa do̱'e̱ u̱t-to̱p shik u̱r-hoot, se̱ wa tok u̱n u̱ tak-u̱ inabi. ");
INSERT INTO gel_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","<<U̱s-kwam ko̱b-du̱ u-gan su̱ u̱r-wu̱n se̱ wa ru u̱ kat-du̱ u-tu̱rru̱, wa hyen e̱ke̱n u̱ shu̱'u̱t-du̱ m-zan. ");
INSERT INTO gel_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Se̱ wa zu̱ u̱n, <Haanu̱n no̱ do̱'e̱ u̱ tak-u inabi ri, me̱ to̱p-u̱ no̱ no̱m-u̱ kame̱.> ");
INSERT INTO gel_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","E̱ yu̱ne̱ e̱ do̱'e̱. <<Se̱ wa do̱'e̱. Wa ru u̱ te̱k u-ho̱, tu̱msu̱ u̱s-kwam u̱s-tu̱t su̱ m-rim wa sur m-kab a-m-ank ne̱. ");
INSERT INTO gel_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","U̱ka u̱s-kwam u̱s-tan su̱ m-rim, wa ru, wa bit e̱ke̱n u̱ ees, e̱ za no̱m-du̱ o̱ko̱n da. Se̱ wa zu̱ u̱n, <¿Remu̱ yan-o̱ wu̱te̱ no̱ no̱mu̱g m-ank u̱ ho̱-du̱ ya-o̱ da?> ");
INSERT INTO gel_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","<<E̱ zu̱ wu̱n, <Waku̱n yaag it no̱mu̱ u̱t-no̱m da.> <<Se̱ wa zu̱ u̱n, <No̱ko̱n ko̱no̱ m-ha u̱ tak-u inabi ri.> ");
INSERT INTO gel_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","<<Da-u̱ rim-mu̱ tore̱, se̱ wa tak-u inabi wa zu̱ wu̱ o̱ se̱gu̱ wa ank-mu̱ u-tak, wa fag i o̱ no̱mu̱ wa-m-ank ne̱, wa to̱p e̱, tu̱msu̱ wa he̱e̱se̱ du̱gu̱ a m-vaste̱ m-ha a u̱r-taku̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","<<Ne̱t-tu̱ haye̱ u̱ka u̱s-kwam u̱s-tan su̱ m-rim, kowan na top wa shik u̱ka ku̱mte̱ u̱ to̱p-u̱ u̱r-hoot. ");
INSERT INTO gel_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ne̱t-tu̱ haane̱ u̱r-taku̱n cu̱ng u̱zu̱ na de̱ to̱p-du̱ e̱ shik m-ze̱g o̱r-u̱t e̱ ne̱ i haane̱ m-rim, ko̱ ba shu̱'u̱te̱ iya kowan kwu̱ng no̱mu̱ kame̱ na to̱p wa u̱r-hoot. ");
INSERT INTO gel_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Da-u̱ e̱ o̱nke̱, se̱ e̱ hu̱ no̱mu̱ wa-u-tak m-kwe̱ remu̱ zu̱ wa to̱po̱k e̱ ho̱n-ho̱n. ");
INSERT INTO gel_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","E̱ zu̱ wu̱n, <Ne̱t-tu̱ haane̱ u̱-dim, ank-mu̱ u-da cashi mo̱ e̱ no̱me̱> to̱p-u it u̱ e̱ne̱ u̱s-gan, it u̱ no̱me̱ m-ank, u̱ du̱ng-mu̱ u-ho̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","<<Se̱ wa zu̱ waku̱n u̱ te̱k-u̱ me̱ u̱n, <Hu̱u̱b-u̱ ri, u̱m re̱e̱g ra-u ró da. U̱m zu̱u̱g iya remu̱ zu̱ yo cu̱ng u̱zu̱ me̱ to̱p-u̱ bo̱ shik no̱mu̱ na tope̱ u̱r-hoot. ");
INSERT INTO gel_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kab no̱m-u̱ o̱ u̱ ró bo̱ no̱k. Me̱ ke̱e̱re̱ u̱ jab-u̱ ri u̱m to̱p o̱r-u̱t ró ne̱ i haane̱ u̱ dim-u ró no̱m-u̱ u̱m to̱p-u̱ bo̱. ");
INSERT INTO gel_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Me̱ keru̱ no̱m-du̱ no̱m-u̱ u̱m ke̱e̱re̱ u̱ jab-u̱ ri, u̱ no̱m-u̱ o̱ u̱ ri, ¿shu̱b-de̱ bo̱ o̱tte̱ u̱ remu̱ no̱m-u so̱-o̱ u̱m no̱me̱?> ");
INSERT INTO gel_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","<<Iya o̱ hen, a m-vaste̱ de̱ u̱t-shu̱'u̱t a u̱r-taku̱n, a u̱r-taku̱n hen e̱ shu̱'u̱t a m-vaste̱.>> ");
INSERT INTO gel_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Da-u̱ Ye̱so̱ u̱ a-doru̱ wa ne̱ o̱ m-ha u̱ Urusharima, se̱ wa nu̱k a-dor-ne̱ u̱-kit. Wa zu̱ u̱n, ");
INSERT INTO gel_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","<<Ho̱go̱n in do̱'e̱ u̱r-cwa u̱ Urusharima. Na de̱ yasu̱ Wa'-u̱ Ne̱t u̱ kom-tu̱ i-Yate̱ a-To̱o̱g-ne̱ u̱ a-ko̱se̱-tu̱ u-bo̱r ne̱. Tu̱msu̱ e̱ u̱t-kwu̱p u̱zu̱ na ho̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tu̱msu̱ e̱ yasu̱ wu̱n u̱du̱ i za-Yahuda-ne̱ da, e̱ no̱mu̱ wu̱n rem-su̱ u̱s-ju̱ru̱m, e̱ no̱mu̱ wu̱n u̱s-ryap, e̱ tar wu̱n u-kan, tu̱msu̱ e̱ ho̱ wu̱n u̱ ho̱-du̱ u-tu̱tu̱rse̱ wa de̱ u̱r-yu̱ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Se̱ ino-u Yakubu e̱ Yohanna ya'ag-u̱ Zabadi e̱ haan u̱du̱ Ye̱so̱. Wa he u̱t-jwu̱n u̱ shu̱ Ye̱so̱ wa kon wu̱n o̱ko̱n no̱m-o̱. ");
INSERT INTO gel_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ye̱so̱ zu̱ wu̱n, <<¿Yan-o̱ bo̱ u̱t-sa?>> Wa zu̱, <<U̱m o̱ ko̱n-u̱s ró, yage̱ yaag-u̱ ri ine̱ yu̱r u̱ shu̱'u̱t u̱ ane̱ u̱ be-du̱ m-sek-u̱ ró u̱r-kot u̱ bo̱ ne̱, wa-gan u̱ kom u̱t-cwa tu̱msu̱ wa-gan u̱ kom u̱r-beer.>> ");
INSERT INTO gel_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ye̱so̱ zu̱ Yakubu e̱ Yohanna, <<No̱ nak no̱m-u̱ no̱ o̱ u̱t-ko̱n da, ¿no̱ keru̱ swadu̱ ko̱b-du̱ u̱m de̱ u̱t-swa?>> E̱ zu̱, <<It u̱t-kere̱.>> ");
INSERT INTO gel_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ye̱so̱ zu̱ u̱n, <<No̱ de̱ swadu̱ u̱r-ko̱b u̱ka u̱m do̱te̱ swadu̱ u̱r-ko̱b, se̱di mo̱t-tu̱ u̱r-shu̱'u̱t u̱ kom u̱s-cwa ri ko̱ kom u̱r-beer, U̱so-u ri wu̱ o̱ do̱m u-ru̱ wa o̱o̱ge̱ wa u̱t-ya. Wu̱na de̱ ya-du̱ be-u̱t to̱ u̱du̱ wu̱ wa cwane̱ u̱t-ya.>> ");
INSERT INTO gel_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Da-u̱ a-dor o̱p i kuse̱ ho̱ge̱ u̱zu̱ Yakubu e̱ Yohanna no̱ng u̱r-shu̱t iya, e̱ hog ryab-u̱s u̱n sok. ");
INSERT INTO gel_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ye̱so̱ fak in be̱e̱t wa zu̱, <<No̱ nak ne̱t-tu̱ o̱ u̱r-faru̱k i za-Yahuda-ne̱ da, e̱ hog zwarru̱ ko̱su̱ e̱ u̱zu̱ e̱ o̱ u̱r-be̱b ne̱. Tu̱-shu̱ hog zwarru̱ ko̱se̱ u̱r-be̱b u̱du̱ i e̱ o̱tte̱ u̱r-faru̱k. ");
INSERT INTO gel_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","A no̱ no̱m u̱ka u̱n da. Remu̱ iya hen wu̱ u̱t-sa wa shu̱'u̱t yu̱-Yat-ya u̱-me̱ no̱, se̱ wa shu̱'u̱te̱ to̱k u̱du̱ o̱r-u̱t wa ne̱. ");
INSERT INTO gel_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tu̱msu̱ wu̱ u̱t-sa wa shu̱'u̱t yu̱-shu̱ u̱-me̱ no̱, wa shu̱'u̱te̱ to̱k. ");
INSERT INTO gel_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wa'-u̱ Ne̱t hagu̱n remu̱ na no̱m-tu̱ wa-m-ank da, se̱di remu̱ zu̱ wa no̱m-u̱t m-ank, wa yase̱ fat-u̱r wa remu̱ u̱kru̱ u̱t-ne̱t u-tát.>> ");
INSERT INTO gel_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Da-u̱ Ye̱so̱ u̱ a-doru̱ wa ne̱ de̱ yagu̱ bo̱-u̱ Yeriko, ban-du̱ u̱t-ne̱t dor u̱n. ");
INSERT INTO gel_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Da-u̱ e̱ o̱o̱ge̱ u̱r-no̱k, e̱ke̱n po̱-ne̱ yu̱r o̱ shu̱'u̱t u̱ kit u-fu̱n. Da-u̱ e̱ ho̱ge̱ Ye̱so̱ o̱ aru̱k, se̱ e̱ yu̱ns u̱s-cwar e̱ zu̱, <<Wa-m-nap, Wa'-u̱ Dawuda! Ho̱g o̱n-u̱r it!>> ");
INSERT INTO gel_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ne̱t-tu̱ hagu̱sse̱ u̱n, u̱zu̱ u̱n ho̱o̱n u̱s-ram, E̱ sur m-jaku̱s u̱s-cwar e̱ zu̱, <<Wa-m-nap, Wa'-u̱ Dawuda! Ho̱g o̱n-u̱r it!>> ");
INSERT INTO gel_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ye̱so̱ ees, wa zu̱ u̱n, <<¿Yan-o̱ no̱ u̱t-sa u̱m no̱mu̱ no̱?>> ");
INSERT INTO gel_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","E̱ zu̱ wu̱n, <<Wa-m-nap, it u̱t-sa it kum m-hyan.>> ");
INSERT INTO gel_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Remu̱ u̱r-o̱n, Ye̱so̱ tu̱m is-u̱ u̱n. Za rem, e̱ kum m-hyan, e̱ dor wu̱n. ");
INSERT INTO gel_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Da-u̱ Ye̱so̱ u̱ a-doru̱ wa ne̱ ha m-te Urusharima, u̱ bo̱-u̱ Bafaji u̱ dapu̱s Ro̱r-du̱ Te-su̱ Ze̱tun, Ye̱so̱ tom a-doru̱ wa yu̱r. ");
INSERT INTO gel_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Wa zu̱ u̱n, <<Cwaan u̱ taas-u̱ o̱ u̱ shu̱ no̱, no̱ u̱t-hyan u-janka m-gag u̱ku̱n u̱ ya-u̱r wa ne̱, ustu̱n e̱ no̱ hatu̱n me̱. ");
INSERT INTO gel_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","A waku̱n u̱ shitu̱ no̱m-u̱ no̱ u̱t-no̱m, waru̱n wa u̱zu̱, <Wa-m-nap wa u̱t-sa e̱,> tu̱msu̱ wa de̱ yasu̱ no̱ e̱ za na-su̱ u-da.>> ");
INSERT INTO gel_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Na no̱ng sin-se̱ u̱s-be̱e̱t remu̱ na shu̱u̱ste̱ no̱mu̱ wa-warru̱ rem-su̱ u-Ru̱ ware̱ u̱zu̱, ");
INSERT INTO gel_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","<<Waru̱ ne̱t-tu̱ bo̱-u̱ Urusharima, <Gwatu̱n faru̱k-u̱ no̱ o̱ haan u̱du̱ no̱, wa zatte̱ hu̱k-mu̱ u̱r-hi da. Wa o̱ u̱r-no̱k u̱ do̱m u-janka, Wa muute̱ hi-u̱r wa za o̱ko̱n, ya-du̱ u-janka wa nokte̱.> >> ");
INSERT INTO gel_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","A-doru̱ Ye̱so̱ yu̱r no̱m u̱ka Ye̱so̱ war-tu̱ e̱. ");
INSERT INTO gel_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","E̱ hatu̱n ya-du̱ u̱r-janka u-janka ne̱ u̱du̱ rò, e̱ su̱k kus-u̱t e̱ u̱ do̱m-u̱ u-janka u̱ ya-u̱r wa ne̱, wa du̱u̱s u̱ do̱m wa shu̱'u̱t u̱ do̱m-u̱ ya-du̱ u-janka. ");
INSERT INTO gel_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","U̱t-ne̱t u-tát e̱ hu̱ nu̱rgu̱sse̱ kus-u̱t e̱ u̱ do̱m-u̱ u-fu̱n, tu̱msu̱ e̱ke̱n getmu̱n fe̱-su̱ u̱s-te e̱ nu̱rgu̱sse̱ u̱ do̱m-u̱ u-fu̱n. ");
INSERT INTO gel_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ban-du̱ u̱t-ne̱t o̱ró u̱-shu̱ Ye̱so̱ tu̱msu̱ ban-du̱ u̱t-ne̱t i o̱ dim-u̱ rò be̱e̱t. E̱ jaku̱s u̱s-cwar, e̱ zu̱, <<U̱t-vam u̱du̱ Wa'-u̱ Dawuda! Nu-u so̱-o̱ u̱du̱ wu̱ haane̱ u̱ shin-m Yawe, u̱t-vam u̱du̱ u-Ru̱ wu̱ o̱o̱ge̱ do̱m u-ru̱ u̱ zu̱ge̱ ko̱he̱ne̱!>> ");
INSERT INTO gel_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Da-u̱ Ye̱so̱ cwaye̱ u̱ Urusharima, gwu̱z yu̱ne̱ u̱zu̱, <<¿Wana unwa?>> ");
INSERT INTO gel_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ne̱t-tu̱ o̱ do̱rru̱ Ye̱so̱ e̱ zu̱, <<Unwa o̱ wa-warru̱ rem-su̱ u-Ru̱ Ye̱so̱ du̱gu̱ Nazara u̱ Gariri.>> ");
INSERT INTO gel_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ye̱so̱ to u̱-me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan wa buz a u̱t-o̱ u̱ a bab-du̱ u̱t-bisa ne̱ u̱-me̱, wa ju̱rgu̱sse̱ cu̱mu̱s-tu̱ a swasa-mu̱ shikne̱, u̱ no̱m-tu̱ u̱r-shu̱'u̱t-u̱ a bab-du̱ u̱t-gorop. ");
INSERT INTO gel_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ye̱so̱ zu̱ u̱n, <<Rem-su̱ u-Ru̱ zu̱u̱g, <Bu-u ri de̱ shu̱'u̱tu̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan,> se̱di no̱ mutte̱ o̱ be-du̱ pak-du̱ hyu̱w-ne̱!>> ");
INSERT INTO gel_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ku̱na po̱-ne̱ u̱ ryam-ne̱ hatu̱n u̱du̱ rò u̱-me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan, tu̱msu̱ wa yu̱ u̱n m-yar. ");
INSERT INTO gel_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","I-Yate̱ a-To̱o̱g-ne̱, u̱ a-ko̱se̱-tu̱ bo̱r-u̱t Mosa ne̱, hog u̱s-ryab da-u̱ e̱ hyane̱ no̱m-tu̱ m-shin tu̱ Ye̱so̱ no̱me̱, u̱ yaag ne̱ be̱e̱t e̱ o̱ u̱t-jar u̱-me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan e̱ o̱ u̱t-zu̱, <<U̱t-vam u̱du̱ Wa'-u̱ Dawuda>> se̱ e̱ hog u̱s-ryab. ");
INSERT INTO gel_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","E̱ zu̱ wu̱n, <<¿Bo̱ ho̱k no̱m-u̱ ya'ag-u̱ ine̱ o̱ u̱t-zu̱?>> Ye̱so̱ shu̱s wa zu̱, <<U̱, no̱ karu̱nte̱ no̱m-u̱ rem-su̱ u-Ru̱ ware̱ u̱zu̱, <Bo̱ iiste̱ u̱t-ya' u̱ ya'ag-u̱ re̱ke̱ ne̱ u̱ka e̱ do̱te̱ vam-u̱t ró u̱ka ku̱mte̱.> >> ");
INSERT INTO gel_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Du̱gu̱ ku̱n se̱ wa yagu̱ u̱n, wa ru u̱ bo̱-u o̱. Wa do̱'e̱ u̱ Bataniya, wa roog u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Da-u̱ is gase̱ u̱r-wu̱n, wa o̱ u̱ mu̱u̱n u̱-me̱ u-bo̱, se̱ wa hog u̱s-me̱r. ");
INSERT INTO gel_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Da wa hyane̱ yaku̱n te-ya u̱ kit u-fu̱n, se̱ wa do̱'e̱ u̱ kug-du̱ te-u ya, wa kwu̱ng o̱ko̱n da se̱ u̱t-ran. Wa zu̱ te-u ya, <<Bo̱ za u̱r-mat da m-mo̱mmo̱.>> Za rem te-yu̱ gu̱u̱s. ");
INSERT INTO gel_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Da-u̱ a-doru̱ Ye̱so̱ hyane̱ iya, e̱ hu̱ mu̱rimmo̱ u-tát. E̱ zu̱, <<¿Re̱ o̱ te-yu̱ gu̱u̱ste̱ za rem inya?>> ");
INSERT INTO gel_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ye̱so̱ shu̱s wa zu̱, <<U̱m o̱ waru̱ no̱ u̱t-nip, a no̱ o̱ u̱ yadu̱ jab ne̱ tu̱msu̱ no̱ no̱ng u-sakna da ko̱ cashi, no̱ u̱t-no̱m no̱m-tu̱ ze̱ge̱ no̱mu̱ u̱m no̱mu̱ te-u inya. Tu̱msu̱ no̱ zu̱ ro̱r-u̱r yat-de̱ din-de̱, <Yu̱ne̱ bo̱ he̱ u̱-me̱ m-sa,> u̱t-shu̱'u̱t iya. ");
INSERT INTO gel_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","A no̱ no̱me̱ yadu̱ jab, no̱m-u̱ no̱ ko̱ne̱ u-Ru̱ u-be̱e̱t u̱ te̱k-u̱ u̱s-to̱o̱g, no̱ u̱t-kwu̱m.>> ");
INSERT INTO gel_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Da-u̱ Ye̱so̱ cwaye̱ u̱-me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan, wa o̱ te̱k-u̱ u̱t-ko̱se̱, se̱ i-Yate̱ a-To̱o̱g-ne̱ u̱ u̱t-ne̱nge̱n ne̱, e̱ haan u̱du̱ rò. E̱ zu̱, <<¿Shin-m wan mo̱ bo̱ o̱tte̱ no̱m-du̱ no̱m-u̱t tun-to̱? ¿Tu̱msu̱ wana ya shin-m mo̱?>> ");
INSERT INTO gel_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Se̱ Ye̱so̱ shu̱s wa zu̱, <<Ko̱ me̱, me̱ no̱mu̱ no̱ u̱r-shu̱t. A no̱ shase̱ shu̱t-u̱r ri, me̱ ware̱ no̱ ko̱ shin-m wan mo̱ u̱m o̱tte̱ no̱m-du̱ no̱m-u̱t tun-to̱. ");
INSERT INTO gel_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Wana ya'e̱ Yohanna be̱b-du̱ u̱t-yu̱bu̱sse̱ m-bu̱? ¿Ru̱-o̱ ya'u̱ wu̱n ko̱ ne̱t-u̱ ya'u̱ wu̱n?>> U̱n hu̱ pama inan u̱ te̱k-u̱ u̱n u̱zu̱, <<A in zu̱ye̱ <Du̱gu̱-du̱ u-Ru̱ de̱,> wa zu̱, <¿Remu̱ u-yan o̱ no̱ ya'ag jab-u̱ wu̱n da?> ");
INSERT INTO gel_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tu̱msu̱ a in zu̱ye̱, <Du̱gu̱-du̱ u̱t-ne̱t de̱,> in o̱ ho̱g-du̱ gye̱r-u̱ no̱m-u̱ ne̱t-tu̱ de̱ no̱mu̱ na, remu̱ zu̱ ne̱t-tu̱ kabu̱g Yohanna wa-warru̱ rem-su̱ u-Ru̱ wa.>> ");
INSERT INTO gel_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Se̱ e̱ zu̱ Ye̱so̱, <<It nak da.>> Ye̱so̱ zu̱ u̱n, <<U̱m za waru̱ no̱ ko̱ shin-m wan mo̱ u̱m o̱tte̱ no̱m-du̱ no̱m-u̱t tun-to̱ da.>> ");
INSERT INTO gel_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ye̱so̱ zu̱ tu̱-shu̱ a-to̱o̱g u̱ tu̱-shu̱ u̱t-ne̱t ne̱, <<¿Yan-o̱ no̱ hyane̱? Na no̱ng yaku̱n campa-ya wu̱ o̱tte̱ yaag-u̱ campa-ne̱ yu̱r. Wa do̱'e̱ u̱du̱ wu̱ u̱r-taku̱n wa zu̱, <Wa'-u̱ ri, yu̱ne̱ bo̱ do̱'e̱ u̱ tak-u̱ inabi u̱ ya-o̱.> ");
INSERT INTO gel_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","<<Wa'-u̱ rò zu̱, <U̱m za m-ha da,> a sure̱ m-wa'as wa sur m-dorog, wa hu̱. ");
INSERT INTO gel_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","<<Se̱ u̱so u̱ do̱'e̱ u̱du̱ wu̱ u-yu̱ru̱mse̱, wa waru̱ wu̱n no̱m-u̱ wa ware̱ yu̱ wu̱ya. Se̱ wa'-u̱ wa zu̱, <To̱, u-u̱so, me̱ u̱t-ha,> se̱ wa gu̱gu̱m m-ha. ");
INSERT INTO gel_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","<<U̱ te̱k-u̱ ya'ag-u̱ e̱ yu̱r ¿wana no̱me̱ no̱mu̱ u̱so u̱ u̱t-sa?>> E̱ zu̱, <<Wa u̱r-taku̱n wa.>> Ye̱so̱ zu̱ u̱n, <<U̱m o̱ waru̱ no̱ u̱t-nip, a-o̱nku̱ shik-u̱ tar ne̱ u̱ a-u-as ne̱, e̱ ba-u̱ no̱ m-cwa u̱ faru̱k-du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","U̱m zu̱u̱g iya remu̱ zu̱ Yohanna wa-u̱t-yu̱bu̱sse̱ m-bu̱ haagu̱n wa o̱ ko̱su̱ no̱ fu̱n-u so̱-ya, no̱ yaag jab da. Se̱di a-o̱nku̱ shik-u̱ tar u̱ a-u-as ne̱ e̱ yaag u̱t-nip. Ko̱ ba no̱ hyane̱ iya, no̱ byu̱rgu̱n no̱ yage̱ u̱t-ba'as no̱ yu̱' jab u̱du̱ rò da. ");
INSERT INTO gel_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","<<Se̱ke̱n sha-mu̱ rem-su̱ ya. Yaku̱n campa-ya wa no̱ng tak-u̱ inabi, wa gu̱nu̱s o̱ u-du̱nni, tu̱msu̱ wa no̱m be-du̱ no̱m-du̱ m-mu̱di mu̱ yaa-tu̱ inabi, tu̱msu̱ wa no̱m kur-u̱ wa-u̱r-e' u̱ do̱m. Se̱ wa yu̱' a-u̱r-to̱m-ne̱ se̱g-mu̱ tak-u inabi o̱, wa aru̱k m-ha u̱ o̱ko̱n dak-o̱. ");
INSERT INTO gel_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Da da-u̱ re̱-du̱ tesse̱ teye̱, se̱ wa-to̱m waku̱n u̱ te̱k-u̱ to̱k-ne̱ rò, wa do̱'e̱ u̱du̱ i wa ya'e̱ se̱g-mu̱ u-tak, e̱ o̱ko̱n o̱gu̱r wa du̱ no̱m-tu̱ u-tak. ");
INSERT INTO gel_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","<<I na ya ne̱ se̱g-mu̱ u-tak, e̱ maas to̱k-ne̱ wa, e̱ gapu̱r wa-gan, e̱ ho wa-gan, e̱ ju̱ru̱g wa-gan u̱t-ta'ar. ");
INSERT INTO gel_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Se̱ wa sur m-to̱m e̱ke̱n to̱k-ne̱ m-ze̱g u̱r-taku̱n, na no̱mu̱ e̱ u̱ka na no̱m-tu̱ a u̱r-taku̱n. ");
INSERT INTO gel_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Da tase̱ wa u-tak to̱m wa'-u̱ wa u̱du̱ u̱n. Wa zu̱, <U̱m nak u̱zu̱ u̱ da-o̱ u̱n u̱t-ya wa m-ze̱g.> ");
INSERT INTO gel_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","<<Da-u̱ i na ya se̱g-mu̱ u-tak hyane̱ wa'-u̱ wa-u-tak, se̱ e̱ zu̱ o̱ru̱t e̱, <No̱nge̱! Wu̱ de̱ re̱-du̱ kwu̱m-tu̱ u-tak u̱ ya. Yagu̱n in ho̱ wu̱n, u̱ tak-u̱ shu̱'u̱t u̱ in.> ");
INSERT INTO gel_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Se̱ e̱ maas wu̱n, e̱ gu̱n wu̱n u̱-do̱ u̱ tak-u̱ inabi, e̱ ho wu̱n. ");
INSERT INTO gel_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","<<U̱ da-o̱, ¿a wa-u-tak mu̱ne̱ yan-o̱ wa de̱ no̱mu̱ i wa se̱ge̱ tak-u̱ inabi?>> ");
INSERT INTO gel_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","E̱ zu̱ wu̱n, <<Wa de̱ ho̱-du̱ ne̱t-u̱t yo̱-to̱ to̱. Wa ya' e̱ke̱n tak-u o̱, i de̱ ha yadu̱ wu̱n du̱ rò o̱gde̱ du̱ no̱m-tu̱ tak-u̱ inabi.>> ");
INSERT INTO gel_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ye̱so̱ zu̱ u̱n, <<¿No̱ karu̱nte̱ no̱m-u̱ rem-su̱ u-Ru̱ ware̱ da: << <Ta'ar-du̱ a u-ma ne̱ gu̱gme̱, de̱ shu̱'u̱te̱ ta'ar-du̱ ze̱ge̱ u̱r-zwar du̱ u-ma. Ru̱-o̱ no̱me̱ sin-se̱, tu̱msu̱ no̱m-tu̱ m-shin to̱ u̱ na hyan>? ");
INSERT INTO gel_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","<<Remu̱ iya, u̱m o̱ waru̱ no̱, na de̱ kab-du̱ faru̱k-du̱ u-Ru̱ du̱gu̱-du̱ no̱, na yasu̱ to̱ko̱n ne̱t-to̱ tu̱ de̱ no̱m-du̱ no̱m-tu̱ kame̱ tu̱ faru̱k-du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ko̱wana he̱ u̱ do̱m-u̱ ta'ar-u̱r re̱, de̱ cakmu̱ wa, tu̱msu̱ wa ta'ar-u̱r re̱ he̱ u̱ do̱m-u̱ wa de̱ namu̱ wa u̱ka m-hyu̱.>> ");
INSERT INTO gel_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Da-u̱ i-Yate̱ a-To̱o̱g-ne̱ u̱ Farisa-ne̱ ho̱ge̱ sha-mu̱ u̱s-rem su̱ Ye̱so̱ ware̱, e̱ nu̱p u̱zu̱ u̱nu̱ wa o̱tte̱ u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","U̱n haan u̱n maas wu̱n, se̱di u̱n o̱ ho̱g-du̱ u-gye̱r, remu̱ zu̱ ne̱t-tu̱ kabu̱g wu̱n wa-warru̱ rem-su̱ u-Ru̱ wa. ");
INSERT INTO gel_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ye̱so̱ sur m-no̱m sha-mu̱ u̱s-rem u̱zu̱, ");
INSERT INTO gel_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","<<Na hyanu̱ sha-mu̱ faru̱k-du̱ u-Ru̱ u̱ka waku̱n faru̱k wu̱ zo̱nge̱ no̱mu̱ wa'-u̱ wa mo̱ro̱g-du̱ u̱r-gu̱. ");
INSERT INTO gel_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wa tom to̱k-ne̱ rò e̱ fagu̱n ne̱t-tu̱ na bane̱ u̱ mo̱ro̱g-du̱ u̱r-gu̱, se̱di ne̱t-tu̱ na bane̱ haagu̱n da. ");
INSERT INTO gel_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","<<Wa sur m-to̱m e̱ke̱n to̱k-ne̱ wa zu̱, <Waru̱n ne̱t-tu̱ na bane̱ u̱zu̱, u̱m zo̱ngte̱ no̱m u̱t-re̱, na pu̱nu̱mte̱ na i m-se̱m. Na taaste̱ zo̱ngu̱ ko̱-uyan, haan u̱ u̱du̱ u̱r-mo̱ro̱g.> ");
INSERT INTO gel_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","<<Se̱di e̱ e̱re̱g da. E̱ aru̱k u̱ su̱ e̱, waku̱n aru̱k u̱ tak-u wa, waku̱n aru̱k u-tu̱rru̱. ");
INSERT INTO gel_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tu̱msu̱ e̱ke̱n maas to̱k-ne̱ e̱, e̱ pepu̱r e̱, na ho e̱. ");
INSERT INTO gel_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Faru̱k hog u̱s-ryab sok. Wa tom karma-ne̱ wa ho̱rru̱sse̱ i ho̱ to̱k-ne̱ e̱, e̱ doos bo̱-u u̱n u-ra. ");
INSERT INTO gel_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","<<U̱ da-u o̱ wa zu̱ to̱k-ne̱ wa, <Na taaste̱ zo̱ngu̱ u̱r-mo̱ro̱g, se̱di i na bane̱ e̱ kamu̱g da. ");
INSERT INTO gel_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Remu̱ iya, do̱ro̱n u̱s-fu̱n, no̱ waru̱ i no̱ hyane̱ be̱e̱t e̱ haan u̱ mo̱ro̱g-du̱ u̱r-gu̱.> ");
INSERT INTO gel_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","To̱k-ne̱ e̱ dor u̱s-fu̱n e̱ kargu̱ssu̱n ne̱t-tu̱ e̱ kume̱, ne̱t-tu̱ u̱r-ka u̱ i za u̱r-ka ne̱, be-du̱ u̱r-mo̱ro̱g haan de̱ shi u̱t-ne̱t sok. ");
INSERT INTO gel_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","<<Da faru̱k cwane̱ wa hyan ne̱t-tu̱ haane̱, se̱ wa hyen waku̱n, wa wagu̱n to̱o̱go̱-yu̱ mo̱ro̱g-du̱ u̱r-gu̱ da. ");
INSERT INTO gel_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Se̱ wa zu̱ ne̱tu̱ wa, <Hu̱bu̱ ri, ¿re̱ o̱ bo̱ nomte̱ bo̱ cwatu̱n u̱ ane̱ za bo̱ wa to̱o̱go̱-yu̱ mo̱ro̱g-du̱ u̱r-gu̱?> Ne̱tu̱ wa taag u̱ no̱m-u̱ wa de̱ u̱t-war. ");
INSERT INTO gel_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","<<Faru̱k zu̱ i o̱ no̱mu̱ wa-m-ank, <Gu̱ksu̱n naas-u̱s rò, u̱t-kom ne̱, no̱ gun wu̱n u̱-do̱ u̱-me̱ u-cwu̱m, ku̱na wa do̱te̱ u̱s-kan u̱ ep-mu̱ jo-u ne̱.> >> ");
INSERT INTO gel_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ye̱so̱ zu̱, <<Ru̱-u̱ fak u̱t-ne̱t u-tát, se̱di ne̱t-to̱ cashi i wa dage̱.>> ");
INSERT INTO gel_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Da-u̱ Ye̱so̱ zu̱ye̱ iya, Farisa-ne̱ do̱'e̱ e̱ do̱ro̱g u̱ka e̱ do̱te̱ no̱mu̱ wu̱n u̱r-re̱n u̱ remu̱ no̱mu̱ wa ware̱. ");
INSERT INTO gel_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Se̱ e̱ to̱mo̱n a-doru̱ u̱n u̱r-kot u̱ ne̱t-u̱t Here̱ ne̱. E̱ zu̱, <<Wa-u̱t-ko̱se̱, it nak bo̱ o̱ m-shu̱p u̱t-nip ne̱, tu̱msu̱ bo̱ o̱ no̱mu̱ na ko̱se̱-tu̱ fu̱n-yu̱ u-Ru̱ te̱k-u̱ u̱t-nip. It zu̱u̱g iya remu̱ zu̱ ne̱t-to̱ u̱s-gan u̱du̱ ró, tu̱msu̱ bo̱ ko̱ste̱ m-ku̱u̱k da. ");
INSERT INTO gel_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Waru̱ it u̱zu̱, ¿Yan-o̱ bo̱ zu̱ye̱, no̱ng u̱r-zwar na to̱p shik-u̱ tar u̱du̱ Kaisar Faru̱k, ko̱ ana to̱p da?>> ");
INSERT INTO gel_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ba shu̱'u̱te̱ u̱zu̱ Ye̱so̱ nak no̱m-u̱ u̱n u̱t-sa, se̱ wa zu̱ u̱n, <<No̱ a-ha-mu̱ u̱r-no̱ ne̱! ¿Remu̱ u-yan o̱ no̱ o̱tte̱ no̱mu̱ me̱ m-re̱ge? ");
INSERT INTO gel_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ko̱su̱n me̱ shik i na topte̱ tar.>> Se̱ e̱ haatu̱n wu̱n ko̱nko̱ shik. ");
INSERT INTO gel_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Se̱ wa zu̱ u̱n, <<¿Ryu̱n-u wan o̱? Tu̱msu̱ ¿dim-u̱r wande̱ u̱ ane̱?>> ");
INSERT INTO gel_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","E̱ shu̱s e̱ zu̱, <<Kaisar wa.>> Se̱ Ye̱so̱ zu̱, <<Na ya' Sisar no̱m-u̱ o̱ u̱ wa, tu̱msu̱ no̱ ya' u-Ru̱ no̱m-u̱ o̱ u-Ru̱.>> ");
INSERT INTO gel_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Da-u̱ e̱ ho̱ge̱ iya, e̱ ship u̱t-nu e̱ hu̱ mu̱rimmo̱. E̱ yagu̱ wu̱n, e̱ aru̱k. ");
INSERT INTO gel_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","U̱ ho̱-u̱r re̱ hen, e̱ke̱n Saduki-ne̱ haan u̱du̱ Ye̱so̱. U̱na zu̱ye̱ yu̱ne̱-du̱ marimari ne̱ zarra. E̱ shit wu̱n. ");
INSERT INTO gel_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","E̱ zu̱, <<Wa-u̱t-ko̱se̱, Mosa zu̱u̱g, <A ne̱tu̱ mare̱ wa kwu̱mu̱g wa' da, ka u̱t-no̱m zarra, se̱ hu̱no-u wa gaag ne̱ta-u ya u̱ remu̱ wa kwu̱m-tu̱ wa yaag.> ");
INSERT INTO gel_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","E̱ke̱n o̱ro u̱ te̱k-u̱ it, campa-ne̱ ta'er ya'ag-u̱ wa-gan. Wa u̱r-taku̱n no̱ng u̱r-gu̱ wa haan wa mu̱r za wa', wa yaksu̱ hu̱no-u wa ne̱ta. ");
INSERT INTO gel_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ganse̱ tu̱msu̱ u̱ wu̱ u-yu̱ru̱mse̱, u̱ u-tu̱tu̱rse̱ ne̱ m-te̱ wa u-ta'er. ");
INSERT INTO gel_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Da-u̱ e̱ mu̱rme̱ be̱e̱t, ne̱ta-u ya mu̱r ko̱wa. ");
INSERT INTO gel_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","U̱ da-o̱, u̱ ho̱-du̱ yu̱ne̱-du̱ marimari ne̱, ¿ne̱ta wana wa de̱ u̱t-shu̱'u̱t remu̱ zu̱ ne̱t-ne̱ ta'er gaag wa?>> ");
INSERT INTO gel_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ye̱so̱ shu̱s wa zu̱, <<Dorog-u̱s no̱ za ho̱n-ho̱n da, remu̱ zu̱ no̱ nak rem-su̱ u-Ru̱ su̱ o̱ m-pan da, tu̱msu̱ no̱ nak shin-mu̱ o̱ u̱ se̱ da. ");
INSERT INTO gel_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Da-u̱ yu̱ne̱-du̱ marimari ne̱, ne̱t-tu̱ za re̱-du̱ shu̱ no̱m-du̱ u̱r-gu̱ u̱-me̱ dak-u uno̱ da, tu̱msu̱ ne̱ta-ne̱ za ha-mu̱ u̱r-gu̱ da, ne̱t-tu̱ de̱ u̱t-shu̱'u̱t u̱ka a-u̱s-to̱m u-Ru̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tu̱msu̱ u̱ mo̱t-tu̱ yu̱ne̱-du̱ marimari ne̱, ¿no̱ karu̱nte̱ no̱m-u̱ Ru̱-u̱ waru̱ no̱ da? Na panu̱g u̱zu̱, ");
INSERT INTO gel_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","<Me̱ wa o̱ Ru̱-u̱ Ibrahi, Ru̱-u̱ Ishaku tu̱msu̱ Ru̱-u Yakubu.> Wu̱n Ru̱-u̱ a u̱r-fat ne̱ o̱ za marimari ne̱ da.>> ");
INSERT INTO gel_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Da-u̱ ne̱t-tu̱ ho̱ge̱ iya, e̱ hu̱ mu̱rimmo̱ u̱ remu̱ ko̱se̱-u̱t Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Da Farisa-ne̱ ho̱ge̱ u̱zu̱ Saduki-ne̱ taagte̱ u̱ no̱m-u̱ e̱ de̱ shasu̱ Ye̱so̱, se̱ Farisa-ne̱ mo̱ro̱g u̱r-be u̱r-gan. ");
INSERT INTO gel_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Waku̱n wa ko̱se̱-tu̱ bo̱r-u̱t Mosa u̱ te̱k-u̱ me̱ u̱n, wa no̱m u̱r-shu̱t remu̱ wa reg-u̱t Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Wa zu̱, <<Wa-u̱t-ko̱se̱, ¿yan bo̱r-ya zege̱ u̱ te̱k-u̱ me̱ bo̱r-u̱t Mosa?>> ");
INSERT INTO gel_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ye̱so̱ shu̱s wa zu̱, << <Cwan u-Ru̱ Yawe u̱ jab-u̱ ró ne̱ be̱e̱t, u̱ fat-u̱r ró ne̱ be̱e̱t, u̱ dorog-u̱s ró ne̱ be̱e̱t.> ");
INSERT INTO gel_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Inya ya o̱o̱ge̱ bo̱r-u yat-ya tu̱msu̱ yu̱ ze̱ge̱ u̱r-zwar. ");
INSERT INTO gel_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Bo̱r-yu̱ u-yu̱ru̱mse̱ yu̱ zege̱ u̱r-zwar ya o̱ u̱s-gan u̱ yu̱ u̱r-taku̱n ne̱, <Bo̱ cwan wa-bo̱ru̱ ró u̱ka bo̱ o̱tte̱ cwan-tu̱ hi-u̱r ró.> ");
INSERT INTO gel_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ko̱se̱-u̱t Mosa u̱t-be̱e̱t u̱ a-warru̱ rem-su̱ u-Ru̱ ne̱, to̱ rwu̱gu̱n u̱-me̱ bo̱r-u̱t tun-to̱ u̱t-yu̱r.>> ");
INSERT INTO gel_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Da Farisa-ne̱ mo̱rge̱ u̱r-be u̱r-gan, se̱ Ye̱so̱ shit u̱n, ");
INSERT INTO gel_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","wa zu̱, <<¿Yan-o̱ dorog-u̱s no̱ u̱ mo̱t-u̱t Kiristi? ¿Wa'-u̱ wana?>> E̱ zu̱ wu̱n, <<Wa'-u̱ Dawuda.>> ");
INSERT INTO gel_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ye̱so̱ zu̱ u̱n, <<¿Re̱-o̱ Dawuda u̱ te̱k-u̱ Yar u-Ru̱ fogte̱ wu̱n Wa-ko-uyan ri? U̱m zu̱u̱g iya remu̱ zu̱ Dawuda zu̱u̱g, ");
INSERT INTO gel_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","<< <Yawe zu̱u̱g Wa-ko-uyan ri, Shu̱'u̱te̱ u̱ ane̱ u̱ be-du̱ m-sek du̱ kom u̱t-cwa ri, Se̱ u̱m re̱e̱g u̱r-ko̱rro̱ du̱ hu̱u̱b-u̱t yo̱-to̱ ró u̱ ta u̱s-na ró.> >> ");
INSERT INTO gel_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","<<A Dawuda zu̱ Kiristi <Wa-ko-uyan> ¿Re̱ o̱ Kiristi shu̱'u̱te̱ wa'-u̱ rò?>> ");
INSERT INTO gel_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Waku̱n kerge̱ shas-du̱ Ye̱so̱ da. Du̱gu̱ ho̱-u̱r re̱ waku̱n swu̱ru̱g m-kwu̱m be̱b-du̱ no̱mu̱ wu̱n de̱ku̱n shu̱t-de̱ da. ");
INSERT INTO gel_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Da-u̱ ne̱t-tu̱ mo̱rge̱ u-tát u̱ a-doru̱ wa ne̱, se̱ Ye̱so̱ zu̱ u̱n, ");
INSERT INTO gel_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","<<A-ko̱se̱-tu̱ bo̱r-u̱t Mosa u̱ Farisa-ne̱ e̱ na ya'e̱ be̱b-du̱ no̱m-du̱ ko̱se̱-u̱t Mosa. ");
INSERT INTO gel_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Remu̱ iya, no̱mu̱n be̱e̱t no̱m-u̱ u̱n o̱ is-u̱ no̱. A no̱ no̱m u̱ka u̱n o̱tte̱ u̱t-no̱m da, remu̱ zu̱ u̱n nom-u̱t no̱m-tu̱ u̱n o̱ u̱t-war da. ");
INSERT INTO gel_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","E̱ su̱k cwu̱-tu̱ m-no, tu̱ zatte̱ ku̱k-mu̱ u̱t-kab da, e̱ saku̱ ne̱t-ne̱ to̱ u̱t-kap, se̱di u̱n u̱ hi-du̱ war u̱n, u̱n za keru̱ wadu̱ ko̱ u-jow u̱n no̱m u̱r-se̱ge̱ da. ");
INSERT INTO gel_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","<<U̱n nom pama-u̱s u̱n u̱s-be̱e̱t remu̱ ne̱t-ne̱ vom-u̱t u̱n. Hi-du̱ rem-u̱s se̱ ya: u̱n o̱ gag-du̱ fe̱-u̱s yat-se̱ su̱ rem-su̱ u-Ru̱ u̱ po̱ng-u̱t u̱n u̱ka u̱r-du̱pu̱r. U̱n o̱ wadu̱ bar-su̱ m-randi u̱ to̱ggo̱-u̱s u̱n. ");
INSERT INTO gel_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","E̱ ton na ya' u̱n be-u̱t so̱-to̱ tu̱ be-tu̱ u̱r-mo̱ro̱g u̱ be-tu̱ m-sek ne̱ u̱-me̱ bu-u̱ u̱t-ko̱se̱ u̱ Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Tu̱msu̱ e̱ ton na ha vu̱k-su̱ u̱n u̱-me̱ u-tu̱rru̱, na ha fag-du̱ u̱n, <Wa-m-nap.> ");
INSERT INTO gel_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","<<No̱ hen, ana zu̱ no̱ <Wa-m-nap da> remu̱ wa-m-nap-u̱ no̱ wa-gan wa, no̱ hen ganse̱ no̱ o̱ye̱ u̱ka u̱t-hu̱no, campa-ne̱ u̱ ne̱ta-ne̱. ");
INSERT INTO gel_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","A no̱ zu̱ waku̱n <u-u̱so> u̱ dak-u uno̱ da, remu̱ zu̱ U̱so-u no̱ o̱ u-gan, wu̱ o̱ do̱m u-ru̱. ");
INSERT INTO gel_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tu̱msu̱ ana fag no̱ <Yu̱-shu̱ da> remu̱ zu̱ yu̱-shu̱ ya u-gan no̱ o̱tte̱, wato Kiristi. ");
INSERT INTO gel_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ne̱t be̱e̱t wu̱ u̱t-sa u̱ Ru̱-u̱ nya wa u̱r-o̱g, yage̱ wa shu̱'u̱t wa no̱mu̱ no̱ m-to̱k. ");
INSERT INTO gel_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wu̱ kabu̱ hi-u̱r wa o̱ko̱n, na de̱ mutu̱ wa m-zan. Tu̱msu̱ wu̱ mutu̱ hi-u̱r wa m-zan, wa de̱ kwu̱m-du̱ m-sek. ");
INSERT INTO gel_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","<<Se̱di no̱m-tu̱ u̱r-o̱n to̱, u̱du̱ a-ko̱se̱-tu̱ bo̱r-u̱t Mosa, u̱ Farisa-ne̱! No̱ a-ha-mu̱ u̱r-no̱ ne̱! No̱ beeste̱ u-is yu̱ cwa-du̱ faru̱k-du̱ do̱m u-ru̱, tu̱msu̱ no̱ cwaag da, tu̱msu̱ no̱ o̱ ho-su̱ a cwan-tu̱ u̱r-cwa ne̱ u̱r-cwa. ");
INSERT INTO gel_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","No̱m-tu̱ u̱r-o̱n u̱du̱ a-ko̱se̱-tu̱ bo̱r-u̱t Mosa, u̱ Farisa-ne̱ u̱ a-ha-mu̱ u̱r-no̱ ne̱! No̱ o̱ re̱-du̱ cwu̱-tu̱ bomos-ne̱, tu̱msu̱ no̱ o̱ to̱o̱g-su̱ m-wu̱r u̱ remu̱ na hyan no̱. Remu̱ iya hen no̱ de̱ swadu̱ u̱r-ko̱b u-tát. ");
INSERT INTO gel_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","<<No̱m-tu̱ u̱r-o̱n u̱du̱ a-ko̱se̱-tu̱ bo̱r-u̱t Mosa, u̱ Farisa-ne̱. No̱ a-ha-mu̱ u̱r-no̱ ne̱! No̱ pu̱s m-sa, no̱ te bo̱-tu̱ m-ra remu̱ sa-u wa-gan wu̱ de̱ do̱rru̱ ko̱se̱-u̱t no̱. A no̱ kume̱ wa, se̱ no̱ muut wa, wa bu-u u-ra m-ze̱g no̱ u-so u-yu̱r. ");
INSERT INTO gel_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","<<No̱m-tu̱ u̱r-o̱n u̱du̱ no̱, no̱ o̱ u̱ka po̱-ne̱ i u̱t-sa dor-tu̱ ne̱t-ne̱ u-fu̱n! No̱ zu̱, <O̱ko̱n zarra a ne̱t-u̱ to̱n-de̱ u̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan u-Ru̱, se̱di wu̱ to̱n-de̱ u̱ ta'ar-tu̱ m-baku̱t ne̱ tu̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan, se̱ wa no̱ng no̱m-u̱ wa to̱n-de̱ u̱zu̱ wa u̱t-no̱m.> ");
INSERT INTO gel_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","No̱ rag-ne̱, no̱ o̱ u̱ka po̱-ne̱! Ta'ar-tu̱ m-baku̱t tu̱ o̱ u̱-me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan to̱ o̱ so̱-to̱, se̱di be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan ze̱k u̱r-zwar, remu̱ zu̱ u̱-me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan o̱ cinte̱ ta'ar-tu̱ m-bak-u̱t tu̱ to̱ u̱-kit remu̱ ank-mu̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","No̱ zu̱, <Wu̱ to̱n-de̱ u̱ be-du̱ to̱o̱g-ne̱, o̱ko̱n zarra, se̱di wu̱ to̱n-de̱ u̱ be-du̱ ya-du̱ to̱o̱g ne̱, se̱ wa no̱mu̱g no̱m-u̱ wa zu̱ wa u̱t-no̱m.> ");
INSERT INTO gel_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","No̱ o̱ u̱ka po̱-ne̱! To̱o̱g-du̱ na nomte̱ to̱o̱g de̱ so̱-de̱, se̱di sak-du̱ na nomte̱ to̱o̱g de̱ ze̱k u̱r-zwar, remu̱ zu̱ u̱ do̱m-u̱ u̱r-sak de̱ na nomte̱ to̱o̱g, remu̱ ank-mu̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Remu̱ iya, wu̱ to̱n-de̱ u̱r-sak ne̱, wa to̱ndu̱te̱ u̱ de̱ ne̱, tu̱msu̱ wa to̱ndu̱te̱ u̱ ko-uyan ne̱ u̱ o̱ do̱m u̱r-sak. ");
INSERT INTO gel_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tu̱msu̱ wu̱ to̱n-de̱ u̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan ne̱, wa to̱ndu̱te̱ u̱ o̱ ne̱, tu̱msu̱ u-Ru̱ ne̱ wu̱ o̱ u̱ shu̱'u̱t u̱-me̱ o̱. ");
INSERT INTO gel_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Wu̱ to̱n-de̱ u̱ do̱m u-ru̱ ne̱, wa to̱ndu̱te̱ u̱ pora-du̱ faru̱k-du̱ u-Ru̱ ne̱, tu̱msu̱ u̱ wu̱ o̱ shu̱'u̱t u̱ do̱m-u̱ pora re̱. ");
INSERT INTO gel_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","<<No̱m-tu̱ u̱r-o̱n u̱du̱ a-ko̱se̱-tu̱ bo̱r-u̱t Mosa, u̱ Farisa-ne̱! No̱ a-ha-mu̱ u̱r-no̱ ne̱! No̱ haatu̱n o̱g-du̱ u-Ru̱ u̱ te̱k-u̱ o̱p u̱ no̱m-tu̱ u̱s-cwa, u̱ka, zangarri, ran-tu̱ u-zwu̱u̱n ne̱, u̱t-ryu̱mb ne̱, se̱di no̱ yakke̱ no̱m-tu̱ ze̱ge̱ u̱r-zwar u̱ te̱k-u̱ me̱ u̱t-bo̱r, to̱ o̱: no̱m-du̱ no̱m-u̱t so̱-to̱ u̱du̱ u̱t-ne̱t, u̱r-o̱n, u̱ yadu̱ jab ne̱. Tun-to̱ kame̱ u̱zu̱ no̱ no̱m, a no̱ yage̱ to̱ko̱n no̱m-to̱ da. ");
INSERT INTO gel_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","No̱ o̱ u̱ka po̱-ne̱ i u̱t-sa dor-tu̱ ne̱t-ne̱ u-fu̱n, no̱ pu̱st no̱m-i u̱r-fat u̱-me̱ m-bu̱ taas no̱ cwar-ya da, se̱di no̱ tor u-rakum. ");
INSERT INTO gel_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","<<No̱m-tu̱ u̱r-o̱n u̱du̱ a-ko̱se̱-tu̱ bo̱r-u̱t Mosa, u̱ Farisa-ne̱! No̱ a-ha-mu̱ u̱r-no̱ ne̱! No̱ jaas dim u-ko̱k, se̱di u̱ me̱n-tu̱ me̱, o̱ shu̱u̱g u̱ cwan-tu̱ m-jigin ne̱, u̱ ko̱b-du̱ e'-du̱ u̱r-hi ne̱. ");
INSERT INTO gel_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","No̱ po̱ Farisa-ne̱, jaasu̱n me̱n-tu̱ me̱ u-ko̱k u-ro, u̱ka do̱ do̱te̱ u̱t-shu̱'u̱t u̱ so̱-o̱ ko̱ o̱. ");
INSERT INTO gel_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","<<No̱m-tu̱ u̱r-o̱n u̱du̱ a-ko̱se̱-tu̱ bo̱r-u̱t Mosa, u̱ Farisa-ne̱! No̱ a-ha-mu̱ u̱r-no̱ ne̱! No̱ shu̱'u̱te̱ u̱ka sag-tu̱ na wa'e̱ rwab-u pus-o̱, u̱ zwarru̱ m-hyan u̱-do̱, se̱di me̱, se̱ shar-tu̱ ne̱t-tu̱ mare̱ m-jigin ne̱ u̱t-go̱ u̱t-go̱. ");
INSERT INTO gel_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Iya o̱ hen no̱ o̱tte̱, u̱-do̱ ne̱t-tu̱ hen no̱ u̱ka ne̱t-tu̱ jab-u̱s so̱-se̱, se̱di u̱ me̱n-tu̱ me̱, se̱ ha-mu̱ u̱r-no̱, u̱ no̱m-u̱t yo̱-to̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","<<No̱m-tu̱ u̱r-o̱n u̱du̱ a-ko̱se̱-tu̱ bo̱r-u̱t Mosa, u̱ Farisa-ne̱! No̱ a-ha-mu̱ u̱r-no̱ ne̱! No̱ mu̱ sag-u̱t so̱-to̱ u̱ remu̱ a-warru̱ rem-su̱ u-Ru̱ ne̱, tu̱msu̱ no̱ no̱mu̱ sag-tu̱ ne̱t-tu̱ jab-u̱s so̱-se̱ u̱t-u̱k. ");
INSERT INTO gel_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","No̱ zu̱, <U̱zu̱ it o̱o̱g u̱ da-u̱ i mate̱ u̱so-u̱t it, it za se̱gu̱ u̱n ho̱-du̱ a-warru̱ rem-su̱ u-Ru̱ ne̱ da.> ");
INSERT INTO gel_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Iya o̱ no̱ ko̱ste̱ u̱zu̱ no̱ o̱ ya'ag-u̱ i ho̱ a-warru̱ rem-su̱ u-Ru̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","No̱ shu̱'u̱te̱ u̱ka i zo̱nge̱ ho̱-du̱ u̱t-ne̱t, u̱ka i mate̱ u̱so-u̱t no̱ o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","<<No̱ fa, No̱ yagu̱ ko̱ko̱s! ¿Re̱ no̱ do̱te̱ ku̱s-mu kwu̱p-du̱ u̱s-rem su̱ cwa-du̱ bu-u u-ra? ");
INSERT INTO gel_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Remu̱ iya, u̱m de̱ to̱mtu̱n no̱ a-warru̱ rem-su̱ u-Ru̱ ne̱, u̱ a-m-nap ne̱, u̱ a-ko̱se̱-tu̱ ne̱. No̱ de̱ ho̱-du̱ e̱ke̱n, no̱ tar e̱ke̱n u-kan, tu̱msu̱ no̱ no̱mu̱ e̱ke̱n u̱s-ryap u̱-me̱ bu-u̱ u̱t-ko̱se̱ u̱ Yahuda-ne̱, no̱ o̱ do̱rru̱ u̱n u̱t-bo̱ u̱t-bo̱. ");
INSERT INTO gel_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ru̱-u̱ de̱ yadu̱ no̱ u̱r-ko̱b, remu̱ zu̱ no̱ ho̱o̱g ne̱t-tu̱ jab-u̱s so̱-se̱ ne̱ be̱e̱t u̱-me̱ dak-u uno̱. No̱m-u̱ no̱ no̱me̱ o̱ u̱t-mu̱u̱n u̱ hi-u̱r no̱, i mare̱ ne̱ du̱gu̱ da-u Habira wa jab-u̱ so̱-o̱ m-ha u̱ Zakariya wa'-u̱ Berekiya, wu̱ no̱ ho̱ye̱ u̱ te̱k-u̱ be-du̱ u-he̱n u̱r-sak ne̱. ");
INSERT INTO gel_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","U̱m o̱ waru̱ no̱ u̱t-nip, sin-se̱ u̱s-be̱e̱t na no̱mu̱ se̱ u̱-me̱ ne̱t-tu̱ uno̱ da-o̱. ");
INSERT INTO gel_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","<<Ku̱s! Urusharima, no̱ a ho̱-du̱ a-warru̱ rem-su̱ u-Ru̱ ne̱, a ju̱rgu̱ i na to̱mne̱ ne̱ u̱du̱ no̱. U̱m saag u̱m kargu̱sse̱ no̱ u̱ka ku̱u̱t-yu̱ kargu̱sse̱ ya'at wa u̱ kap-u̱t wa, se̱di no̱ gu̱gu̱mte̱. ");
INSERT INTO gel_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","U̱ da-o̱ hen na yaku̱ste̱ no̱ bo̱-u no̱ za waku̱n. ");
INSERT INTO gel_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","U̱m o̱ waru̱ no̱, no̱ za tu̱msu̱ hyan-du̱ me̱ da, se̱ ho̱-du̱ no̱ zu̱ye̱, <Kom-u̱ u-Ru̱ u̱du̱ wu̱ haane̱ u̱-te̱k dim-u̱r Yawe.> >> ");
INSERT INTO gel_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ye̱so̱ ru du̱gu̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan. Wa o̱ te̱k-u̱ u̱r-no̱k, se̱ a-dor waru̱ wa, zwarru̱ ma-u̱t to̱ u-tát tu̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan. ");
INSERT INTO gel_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Se̱ wa shit u̱n wa zu̱, <<No̱ hyang tun-to̱ ma-to̱, u̱m o̱ waru̱ no̱ u̱t-nip, na za yage̱ u̱r-ta'ar u̱ do̱m-u̱ u̱r-ta'ar da. To̱ u̱t-he̱ u̱t-be̱e̱t.>> ");
INSERT INTO gel_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ye̱so̱ o̱ shu̱'u̱t u̱ do̱m-u̱ Ro̱r-du̱ Te-su̱ Ze̱tun, se̱ a-doru̱ wa haan e̱ war'e̱. E̱ zu̱, <<Waru̱ it, ¿mu̱ne̱ o̱ na de̱ no̱m-du̱ no̱m-u̱t tun-to̱? ¿Tu̱msu̱ re̱-o̱ nap-su̱ haan-u̱r ró, u̱ ma-du̱ u-da ne̱?>> ");
INSERT INTO gel_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ye̱so̱ shu̱s wa zu̱: <<No̱mo̱n ga', a waku̱n u̱ e̱ngu̱sse̱ no̱ u̱ remu̱ no̱mu̱ de̱ u̱t-no̱m da. ");
INSERT INTO gel_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Remu̱ ne̱t-tu̱ de̱ rwu̱u̱n u-tát e̱ zu̱ u̱m yaag e̱ shin-m ri, e̱ de̱ u̱t-zu̱, <Me̱ o̱ Kiristi.> E̱ de̱ e̱ngu̱sse̱ ne̱t-ne̱ u-tát. ");
INSERT INTO gel_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","No̱ de̱ ho̱g-du̱ rem-su̱ m-gag, u̱ u-na zu̱ ne̱ u̱ m-gag. A no̱ ho̱g u-gye̱r da, remu̱ zu̱ o̱ko̱n za u̱t-hoos da, se̱di vaste̱-mu̱ no̱ng da u-ro. ");
INSERT INTO gel_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dak-u̱ de̱ yu̱nsu̱ m-gag m-ha o̱ko̱n dak-o̱, tu̱msu̱ faru̱k-du̱ yu̱ns m-gag m-ha de̱ku̱n faru̱k de̱. Na de̱ no̱m-du̱ u̱s-me̱r u̱ ru̱mu̱s-du̱ u-dak ne̱ to̱ko̱n dak-to̱ u̱t-go̱ u̱t-go̱. ");
INSERT INTO gel_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Se̱di se̱ u̱s-be̱e̱t taku̱n-du̱ swa-u̱ u̱r-ko̱b de̱. ");
INSERT INTO gel_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","<<Na de̱ yasu̱ no̱ u̱du̱ swadu̱ u̱r-ko̱b, tu̱msu̱ na ho̱ no̱. Ne̱t-tu̱ u̱t-dak u-be̱e̱t e̱ de̱ gu̱g-mu̱ no̱ remu̱ zu̱ no̱ o̱ a-doru̱ ri. ");
INSERT INTO gel_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tu̱msu̱ u̱t-ne̱t u-tát e̱ de̱ yage̱ yadu̱ jab-u̱ e̱ u̱du̱ ri. E̱ yasu̱ o̱r-u̱t e̱, tu̱msu̱ e̱ gu̱gu̱m o̱r-u̱t e̱. ");
INSERT INTO gel_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","A-warru̱ rem-su̱ u-Ru̱ ne̱ i u̱s-bi ne̱ e̱ de̱ rwu̱n u-tát, e̱ e̱ngu̱sse̱ u̱t-ne̱t u-tát. ");
INSERT INTO gel_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Remu̱ tat-u̱ no̱m-u̱t yo̱-to̱, cwan-u̱t e̱ke̱n o̱ no̱mu̱ o̱r-u̱t e̱ de̱ u̱t-hab. ");
INSERT INTO gel_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Se̱di wu̱ eese̱ u̱r-be̱b ne̱ m-te̱ u̱r-ma, wa de̱ kwu̱m-du̱ u-u̱ku̱r. ");
INSERT INTO gel_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tu̱msu̱ na de̱ do̱nse̱-du̱ Rem-u̱s sin-se̱ su̱ m-Re̱me̱r su̱ faru̱k-du̱ u-ru̱ remu̱ u̱s-nap u-me̱ u-dak u-be̱e̱t, kanda vaste̱-mu̱ no̱m. ");
INSERT INTO gel_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","<<Se̱di kanda vaste̱-mu̱ no̱m, da-u̱ no̱m-tu̱ m-'e̱ tu̱ de̱ naasu̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan to̱ u̱t-wa u̱t-ne̱t e̱ yage̱ o̱, to̱ u̱ ees u̱-me̱ Bu-u̱ u̱s-to̱o̱g. Wa-warru̱ rem-su̱ u-Ru̱ Daniyer waru̱g tu̱msu̱ wa pu̱n se̱ m-tumb ne̱. Yage̱ wa-m-karu̱nte̱ wa nap. ");
INSERT INTO gel_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ne̱t-tu̱ o̱ gwu̱g-du̱ Yahudiya, e̱ de̱ so̱m-mu̱ rutu̱ u̱r-hi m-ha u̱t-ro̱r. ");
INSERT INTO gel_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wu̱ o̱ do̱m-u̱ go̱nt-du̱ u-kur, a wa zu̱, <Yage̱ u̱m cu̱zu̱n u̱m kab o̱ko̱n u-bu kanda m-so̱m da.> ");
INSERT INTO gel_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wu̱ o̱ u-tak, a wa mu u̱zu̱ wa kabu̱n kus-u̱ u̱t-ho̱po̱s wa da. ");
INSERT INTO gel_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","No̱m-tu̱ u̱r-o̱n u̱du̱ ne̱ta-ne̱ o̱tte̱ u̱t-me̱n, u̱ i o̱ u̱r-wu̱ru̱g ne̱ u̱ da-u̱ o̱. ");
INSERT INTO gel_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","No̱mo̱n u̱s-to̱o̱g taas so̱mu̱-m mo̱ shu̱'u̱t u̱ da-u̱ u-go̱s ko̱ u̱ ho̱-du̱ u̱r-hure̱ da. ");
INSERT INTO gel_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","U̱ da-u o̱, na de̱ no̱m-du̱ de̱ku̱n swa-u̱ u̱r-ko̱b de̱, du̱ na tame̱ u̱t-no̱m da, du̱gu̱ taku̱n-du̱ dak-u uno̱ u̱ haan u̱ da-o̱, tu̱msu̱ na za u̱t-swu̱r m-no̱m go̱-du̱ o̱ da. ");
INSERT INTO gel_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","U̱zu̱ na habu̱g u̱t-ru̱t da, waku̱n zaar wu̱ de̱ kwu̱n-du̱ u-u̱ku̱r da. Se̱di remu̱ ne̱t-tu̱ na dage̱ Ru̱-u̱ de̱ hab-du̱ u̱t-ho̱. ");
INSERT INTO gel_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","U̱ da-u o̱, ko̱ wana zu̱ no̱, <Gwat Kiristi ya> ko̱ <Wa ya' jit> a no̱ ya' jab da. ");
INSERT INTO gel_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Remu̱ zu̱, e̱ke̱n de̱ yu̱ne̱ e̱ zu̱ e̱ haagu̱n u̱ shin-m Kiristi, u̱ a-warru̱ rem-su̱ u-Ru̱ ne̱ i u̱s-bi, e̱ no̱m no̱m-tu̱ m-shin u-tát u̱ remu̱ e̱ e̱ngu̱sse̱ u̱t-ne̱t, a mu̱ne̱ u̱t-no̱me̱, ko̱ i Ru̱-u̱ dage̱ na e̱ngu̱sse̱ e̱. ");
INSERT INTO gel_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Me̱ he̱n u̱m o̱ waru̱ no̱ kanda da-u̱ no̱m. ");
INSERT INTO gel_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","<<Remu̱ iya, ana zu̱ no̱, <Gwat, Kiristi ya jit u̱r-do̱g,> A no̱ rwu̱n da. Ana zu̱ no̱, <Wa ya' jit u̱ yase̱ u̱-me̱ kur-u̱ me̱,> A no̱ ya' jab da. ");
INSERT INTO gel_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","U̱ka no̱ hyente̱ yak-u̱t yu̱ nomte̱ m-zu̱n du̱gu̱ u-do̱m m-cu̱z u-ta, iya o̱ haan-du̱ Wa'-u̱ ne̱t do̱te̱ u̱t-shu̱'u̱t. ");
INSERT INTO gel_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Be-du̱ u-du̱ o̱tte̱, ku̱na sag-ra mo̱ro̱gte̱. ");
INSERT INTO gel_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","<<Za naas u-da, da-u̱ ho̱-tu̱ swa-u̱ u̱r-ko̱bu̱ to̱ arke̱, << <Ho̱-du̱ de̱ no̱m-du̱ u-cwu̱m, pyat-yu̱ za no̱m-du̱ m-zu̱n da, Re̱ge̱r de̱ hemu̱n du̱gu̱ u-ru̱, tu̱msu̱ na de̱ ru̱m-su̱ faru̱k-tu̱ do̱m u-ru̱.> ");
INSERT INTO gel_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","<<U̱ da-u o̱ nap-su̱ Wa'-u̱ Ne̱t de̱ u̱t-ko̱se̱ u̱ do̱m u-ru̱. Ne̱t-tu̱ u-dak u-be̱e̱t e̱ de̱ u̱s-kan u̱ remu̱ u-gye̱r. E̱ de̱ hyan-du̱ Wa'-u̱ Ne̱t u̱ haan u̱-me̱ u̱r-ku̱u̱t, m-shin ne̱ u̱ m-sek ne̱ u-tát. ");
INSERT INTO gel_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Wa de̱ to̱mnu̱ a-to̱mu̱ wa du̱gu̱ do̱m u-ru̱, e̱ fur u-kar yu̱ u̱t-wan sok. E̱ de̱ kargu̱sse̱ ne̱t-tu̱ na dage̱ du̱gu̱ u-do̱m u̱ u-ta ne̱ u̱ m-ereg ne̱ u̱ kom u̱t-cwa u̱ kom u̱r-beer ne̱, du̱gu̱ din-de̱ ma-du̱ u-dak ne̱ m-ha de̱ku̱n ma-du̱ u-dak de̱. ");
INSERT INTO gel_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","<<Isu̱n o̱ko̱n du̱gu̱ sin-se̱ sha-mu̱ u̱s-rem su̱ te-yu̱ u-baab: Da-u̱ fe̱-u̱s wa he̱e̱se̱ u̱t-baru̱m, se̱ o̱ rwu̱tu̱n ran-u̱t po-to̱, napu̱n u̱zu̱ go̱s-u̱ teegu̱n. ");
INSERT INTO gel_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Iya o̱ hen, a no̱ hyane̱ no̱m-u̱t tun-to̱ u̱t-be̱e̱t tu̱ u̱m waru̱ no̱, napu̱n u̱zu̱ da-u̱ no̱ng, u̱ bo̱ndu̱ u-is. ");
INSERT INTO gel_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","U̱m o̱ waru̱ no̱ u̱t-nip, ne̱t-tu̱ uno̱ da-o̱ za m-mar da, se̱ no̱m-u̱t tun-to̱ u̱t-be̱e̱t to̱ no̱ng. ");
INSERT INTO gel_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Do̱m u-ru̱ u-dak ne̱ to̱ u̱t-ta, se̱di rem-u̱s ri za u̱t-ta ko̱ cashi. ");
INSERT INTO gel_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","<<Se̱di waku̱n nak u̱r-ho̱ ko̱ u-da, da-u̱ no̱m-u̱t to̱ de̱ u̱t-no̱m da, ko̱ a-to̱m u-Ru̱ i o̱ do̱m u-ru̱, ko̱ Wa se̱di u-U̱so wa u-gan. ");
INSERT INTO gel_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","U̱ka na nomte̱ u̱ ho̱-u̱t Nuhu, iya o̱ do̱te̱ u̱t-shu̱'u̱t u̱ ho̱-tu̱ haan-du̱ Wa'-u̱ Ne̱t. ");
INSERT INTO gel_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","U̱ka na nomte̱ u̱ da-u o̱, kanda yu̱-u u-hat, na o̱ u-re̱, na o̱ u̱t-swa, campa-ne̱ o̱ u̱t-gu̱, tu̱msu̱ na o̱ hu̱tu̱ ne̱ta-ne̱ u̱t-gu̱, m-te̱ da-u̱ Nuhu cwa u̱-me̱ u-hat. ");
INSERT INTO gel_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Kanda e̱ nu̱pu̱t no̱m-u̱ o̱ u̱ te̱k, yu̱-u yat-o̱ hagu̱n u̱ koos-tu̱ u̱n be̱e̱t. Iya o̱ mu̱u̱n-du̱ Wa'-u̱ Ne̱t do̱te̱ u̱t-shu̱'u̱t. ");
INSERT INTO gel_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","U̱ da-u o̱, ne̱t-ne̱ yu̱r, e̱ o̱ u-tak na de̱ kab-du̱ wa-gan na yage̱ wa-gan. ");
INSERT INTO gel_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ne̱ta-ne̱ yu̱r e̱ o̱ u̱r-na u̱r-kot, Ru̱-u̱ de̱ kab-du̱ wa-gan wa yage̱ wa-gan. ");
INSERT INTO gel_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","<<Remu̱ iya, shu̱'u̱tu̱n u̱s-zo̱ng ne̱, remu̱ no̱ nak ho̱-du̱ Wa-ko-uyan de̱ mu̱u̱n da. ");
INSERT INTO gel_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Se̱di napu̱n, u̱zu̱ wa u-bu do̱'e̱ nap-du̱ ho̱-du̱ hyu̱w de̱ haan m-gyu̱p, wa za roogte̱ da, tu̱msu̱ wa za u̱t-yage̱ na cwa wa u-bu da. ");
INSERT INTO gel_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Remu̱ iya, shu̱'u̱tu̱n u̱s-zo̱ng ne̱, remu̱ da-u̱ no̱ wa wa' jab da, da-u o̱ Wa'-u̱ Ne̱t de̱ haan. ");
INSERT INTO gel_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","<<To̱k-u̱ u̱r-ka tu̱msu̱ wa u̱s-ve̱r, wa o̱ wu̱ wa-u-bu wa ya'u̱ wa gwa-tu̱ wa u-bu, wa o̱ hen u̱ yadu̱ to̱k-ne̱ kuse̱ no̱m u̱t-re̱ u̱ da-u̱ kame̱. ");
INSERT INTO gel_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","No̱m-tu̱ u̱r-so̱ to̱ u̱du̱ to̱k wu̱ wa-u-bu haane̱ wa bit wa u̱ no̱m-du̱ no̱mu̱ na wu̱te̱ wa. ");
INSERT INTO gel_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","U̱m o̱ waru̱ no̱ u̱t-nip, wa de̱ wadu̱ to̱ku̱ wa gwa-tu̱ cwu̱-u̱t wa u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Jiya to̱k-ne̱ yo̱-o̱ wa, wa de̱ u̱t-zu̱, <Wa-u-bu ri tumbtu̱n.> ");
INSERT INTO gel_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Se̱ wa he̱e̱se̱ gapru̱ hu̱u̱b-tu̱ m-ank-u̱ wa, wa o̱ u-re̱ u-swa ne̱ u̱r-kot u̱ a u-swa ne̱. ");
INSERT INTO gel_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","A to̱k-u̱ wa no̱me̱ iya, wa-u-bu rò de̱ mu̱u̱n za napu̱r rò tu̱msu̱ u̱ ho̱-du̱ wa nape̱ da. ");
INSERT INTO gel_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Wa-u-bu de̱ vu̱du̱ wu̱n sok, tu̱msu̱ wa de̱ gwu̱n-du̱ wu̱n be-du̱ na gunte̱ a-ha-mu̱ u̱r-no̱ ne̱. Ku̱na wa do̱te̱ u̱s-kan u̱ ep-mu̱ jo-u ne̱. ");
INSERT INTO gel_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","<<Faru̱k-du̱ u-ru̱ de̱ o̱ u̱ka ya-u̱t-gwu̱p o̱p i nape̱ campa-ne̱ da i kabe̱ hitirra-u̱s e̱. E̱ nok u̱ bu-u̱ gwu̱p u̱r-gu̱ u̱ e'-du̱ campa u̱r-gu̱. ");
INSERT INTO gel_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ya-u̱t-gwu̱p tan u̱ te̱k-u̱ u̱n, e̱ zatte̱ u̱s-ve̱r da, tan hene e̱ o̱ u̱s-ve̱r ne̱. ");
INSERT INTO gel_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Da-u̱ ya-u̱t-gwu̱p tan i za u̱s-ve̱r kabe̱ hitirra-u̱s e̱, e̱ kabu̱g m-no̱o̱g mu̱ u̱t-swu̱r da. ");
INSERT INTO gel_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","I o̱tte̱ u̱s-ve̱r hen, e̱ kabu̱g mo̱ko̱n no̱o̱g-mo̱ u̱-me̱ u̱r-kub u̱ hitirra-u̱s e̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Campa u̱r-gu̱ teegu̱n m-byanne̱ da, e̱ be̱e̱t e̱ hu̱ degem-tu̱ m-roog, a tase̱ e̱ deku̱s m-roog. ");
INSERT INTO gel_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","<<U̱ te̱k-u̱ m-gyu̱p sok, na fog u̱zu̱ na rwu̱u̱n, <Campa u̱r-gu̱ ya, rwu̱nu̱n na gu wa!> ");
INSERT INTO gel_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","<<Ku̱na ya-u̱t-gwu̱p-u̱ e̱ o̱p i nape̱ campa-ne̱ da yu̱nte̱ e̱ mang hitirra-u̱s e̱. ");
INSERT INTO gel_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ya-u̱t-gwu̱p i za u̱s-ve̱r zu̱ i o̱ u̱s-ve̱r ne̱, <Ke̱re̱n it no̱o̱g-m no̱ cashi. Hitirra-u̱s it u̱t-sa m-mar.> ");
INSERT INTO gel_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","<<I o̱tte̱ u̱s-ve̱r zu̱ u̱n, <No̱o̱g-m mo̱ zaru̱ ko̱ru̱ in u̱r-kot da, se̱di no̱ko̱n u̱ be-du̱ na bu̱bte̱ no̱ o̱o̱n.> ");
INSERT INTO gel_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","<<Da-u̱ e̱ ruye̱ u̱ remu̱ e̱ o̱o̱tu̱n m-no̱o̱g, kanda e̱ mu̱u̱n campa u̱r-gu̱ te̱e̱n. Ne̱t-tu̱ zo̱nge̱ hen e̱ to̱ u̱ campa u̱r-gu̱ ne̱ u̱du̱ u̱r-gu̱, se̱ to̱k u-bu tage̱ u-is. ");
INSERT INTO gel_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","<<Da wase̱, se̱ ya-u̱t-gwu̱p-u̱ e̱ mu̱u̱n, e̱ zu̱, <Wa-u-bu, Wa-u-bu, up-su̱ it u-is.> ");
INSERT INTO gel_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","<<Se̱ campa u̱r-gu̱ zu̱, <U̱m o̱ waru̱ no̱ u̱t-nip, u̱m nak no̱ da!> ");
INSERT INTO gel_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","<<Remu̱ iya, shu̱'u̱tu̱n u̱s-zo̱ng ne̱ remu̱ mu̱u̱n-u̱r ri, remu̱ no̱ nak u̱r-ho̱ ko̱ u-da da. ");
INSERT INTO gel_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","<<Faru̱k-du̱ u-Ru̱ o̱ u̱ka ne̱t wu̱ de̱ no̱m-du̱ m-ha, se̱ wa fog to̱k-ne̱ wa, wa mo̱-tu̱ u̱n shik. ");
INSERT INTO gel_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Wa yasu̱ wa-gan ba-tu̱ shik u̱t-tan, wa-gan na yasu̱ wa ba-tu̱ shik u̱t-yu̱r, tu̱msu̱ wa-gan ba-du̱ u̱r-gan, kowan u̱ka wa do̱te̱ u̱t-kere̱. Se̱ wa aru̱k. ");
INSERT INTO gel_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Wu̱ na yase̱ ba-tu̱ shik u̱t-tan, za rem wa do̱'e̱ wa hu̱ u-cerpa u̱ e̱, wa kum bu̱-mu̱ u̱t-ba u̱t-tan. ");
INSERT INTO gel_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Iya o̱ hen wu̱ na yase̱ ba-tu̱ u̱t-yu̱r ko̱wa wa kum bu̱-mu̱ ba-tu̱ shik u̱t-yu̱r. ");
INSERT INTO gel_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Se̱di wu̱ na yase̱ u-gan, wa do̱'e̱ wa-ku̱w u̱r-kub u-dak wa yase̱ ba-du̱ shik-u̱ wa-u-bu wa. ");
INSERT INTO gel_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","<<Da-u̱ tumbe̱, se̱ wa-u-bu u̱ to̱k-ne̱ wa e̱ mu̱u̱n, remu̱ wa got no̱m-u̱ e̱ kume̱ u̱ shik-u̱ e̱. ");
INSERT INTO gel_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Se̱ wu̱ kabe̱ ba-tu̱ shik u̱t-tan, wa haan wa hatu̱n to̱ko̱n tan-to̱ wa zu̱, <Wa-u-bu, bo̱ yaste̱ me̱ ba-tu̱ shik u̱t-tan. E̱ ya u̱m kwu̱ng bu̱-mu̱ to̱ko̱n ba-to̱ u̱t-tan.> ");
INSERT INTO gel_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","<<Se̱ wa-u-bu rò zu̱ wu̱n, <No̱nge̱, to̱k-u̱ so̱-wa, bo̱ no̱ng u̱r-ka u̱ no̱m-u re̱k-o̱. U̱m de̱ yasu̱ bo̱ u̱ zege̱ uno̱, haane̱ bo̱ no̱m u̱r-so̱ u̱r-kot u̱ me̱ ne̱.> ");
INSERT INTO gel_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","<<Wu̱ kabe̱ ba-tu̱ shik u̱t-yu̱r, wa haan wa zu̱, <Wa-u-bu, bo̱ yaste̱ me̱ ba-tu̱ shik u̱t-yu̱r. E̱ ya u̱m kwu̱mu̱g bu̱-mu̱ to̱ko̱n yu̱r-to̱.> ");
INSERT INTO gel_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","<<Se̱ wa-u-bu zu̱ wu̱n, <No̱nge̱ to̱k-u̱ so̱-wa, bo̱ no̱ng u̱r-ka u̱ no̱m-u̱ re̱k-o̱. U̱m de̱ yasu̱ bo̱ u̱ zege̱. Haane̱ bo̱ no̱m u̱r-so̱ u̱r-kot u̱ me̱ ne̱.> ");
INSERT INTO gel_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","<<Wu̱ kabe̱ ba-du̱ shik u̱r-gan, wa haan wa zu̱, <Wa-u-bu, u̱m nak waku̱n goot nu-u̱r ró da, bo̱ nom ket u̱ be-du̱ bo̱ kawe̱ da. Bo̱ kargu̱sse̱ u̱ be-du̱ bo̱ u̱s-te̱ go̱ da. ");
INSERT INTO gel_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","De̱ wu̱te̱ u̱m hog-u̱t u-gye̱r, u̱m ku̱w u̱r-kub u-dak u̱m yase̱ ba-du̱ shik-u̱ de̱. O̱nko̱ shik-u̱ ró.> ");
INSERT INTO gel_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","<<Se̱ wa-u-bu rò shu̱s wa zu̱ to̱k-u̱ wa, <Bo̱ ne̱t-u̱ yo̱-o̱ wa bo̱ o̱ye̱ za u̱r-ka, bo̱ nak u̱zu̱ u̱m nom ket be-du̱ u̱m kawe̱ da, tu̱msu̱ u̱m kargu̱sse̱ be-du̱ u̱m a se̱ go̱ da. ");
INSERT INTO gel_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","U̱zu̱ bo̱ wagu̱ me̱ shik-u̱ u̱-me̱ be-du̱ u̱r-cu̱n, a u̱m mu̱ne̱ u̱m o̱nk shik-u̱ ri m-swu̱r ne̱. ");
INSERT INTO gel_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","<< <Remu̱ iya o̱nko̱n ba-du̱ shik-u̱ de̱ u̱du̱ rò, yasu̱n wa ba-tu̱ shik u̱t-o̱p. ");
INSERT INTO gel_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Remu̱ zu̱ wu̱ o̱tte̱ u-no̱m wa na de̱ u̱t-swu̱re̱, u̱ wa kum u-tát. Wu̱ zatte̱ o̱ko̱n da, ko̱ cashi u̱ wa o̱tte̱ na de̱ u̱t-o̱nk. ");
INSERT INTO gel_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kabu̱n to̱k-u̱ yo̱-wa unwa, no̱ gun u̱-do̱ u̱-me̱ u-cwu̱m. Ku̱na wa do̱te̱ u̱s-kan u̱ ep-mu̱ jo-u ne̱.> ");
INSERT INTO gel_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","<<Da-u Wa'-u̱ Ne̱t de̱ haan, u̱-me̱ sek-m wa u̱r-kot u̱ a-to̱mu̱ wa ne̱ be̱e̱t, da-u o̱ wa de̱ u̱t-shu̱'u̱t u̱ pora-du̱ u̱r-faru̱k wa. ");
INSERT INTO gel_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na de̱ kargu̱sse̱ ne̱t-tu̱ u̱t-dak u̱t-be̱e̱t u̱du̱ wa. Wa de̱ mo̱t-du̱ e̱ u̱t-go̱ u̱t-go̱ u̱ka wa-u̱t-got motte̱ ca u̱ me̱n-tu̱ gwaar. ");
INSERT INTO gel_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Wa de̱ cu̱n-du̱ ca u̱ kom u̱s-cwa wa, gwaar hen u̱ kom u̱r-beer. ");
INSERT INTO gel_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","<<Se̱ Faru̱k de̱ u̱zu̱ i o̱ kom u̱s-cwa wa, <Haanu̱n no̱ i U̱so-u ri wa'e̱ nu-u so̱-o̱, no̱ cwa faru̱k-du̱ u-Ru̱ du̱ wa zo̱nge̱ no̱ du̱gu̱ taku̱n-du̱ u-dak. ");
INSERT INTO gel_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","U̱m zu̱u̱g iya remu̱ zu̱, da-u̱ u̱m o̱ ho̱g-du̱ u̱s-me̱r, no̱ yaag me̱ no̱m u̱t-re̱. Tu̱msu̱ u-swaat no̱ yu̱' me̱ bu̱-mu̱ u̱t-swa. U̱m o̱ u̱r-hamu̱t no̱ cwatu̱n me̱. ");
INSERT INTO gel_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","U̱m zatte̱ cwu̱-tu̱ u̱t-wa da, no̱ yu̱' me̱ to̱. U̱m zatte̱ m-yar da, no̱ got me̱. U̱m o̱ bu-u̱ m-to̱k, no̱ haan u̱ hyan-du̱ me̱.> ");
INSERT INTO gel_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","<<Du̱gu̱ ku̱n a-jab-u̱s so̱-se̱ ne̱ de̱ u̱t-zu̱, <Wa-ko-uyan, ¿mu̱ne̱ it hyane̱ bo̱ u̱s-me̱r it ye' bo̱ no̱m u̱t-re̱? ¿Ko̱ bo̱ o̱ ho̱g-du̱ u-swaat it ye' bo̱ bu̱-mu̱ u̱t-swa? ");
INSERT INTO gel_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Mu̱ne̱ o̱ it hyane̱ bo̱ u̱r-hamu̱t it cwatu̱n bo̱, ko̱ bo̱ o̱ za cwu̱-tu̱ u̱t-wa it yu̱' bo̱? ");
INSERT INTO gel_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Tu̱msu̱ mu̱ne̱ o̱ it hyane̱ bo̱ za m-yar ko̱ u̱-me̱ bu-u̱ m-to̱k it haan u̱ hyan-du̱ bo̱?> ");
INSERT INTO gel_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","<<Faru̱k de̱ u̱t-zu̱, <U̱m o̱ waru̱ no̱ u̱t-nip, ba shu̱'u̱te̱ no̱ no̱ngu̱ wa-gan u̱ te̱k-u̱ o̱r-u̱t ri, wu̱ re̱k-wa, me̱ wa no̱ no̱me̱.> ");
INSERT INTO gel_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","<<Da-u̱ o̱ wa de̱ zu̱ i o̱ kom u̱r-beer, <Hatu̱n u̱ ane̱, no̱ ne̱t-tu̱ Ru̱-u̱ wa'e̱ u-nu. Cwan u̱-me̱ u-ra u̱ na za u̱t-kere̱ u̱t-ryu̱m da m-mo̱mmo̱, u̱ na zo̱nge̱ faru̱k-u̱ no̱m u̱s-te u̱ a-to̱mu̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","U̱m zu̱u̱g iya remu̱ zu̱, da-u̱ u̱m o̱o̱ge̱ u̱s-me̱r, no̱ yaag me̱ no̱m u̱t-re̱ da. U̱m o̱ ho̱g-du̱ u-swaat no̱ yaag me̱ bu̱-mu̱ u̱t-swa da. ");
INSERT INTO gel_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","U̱m o̱ u̱r-hamu̱t, no̱ cwatu̱n me̱ da. U̱m zatte̱ cwu̱-tu̱ u̱t-wa da, no̱ yaag me̱ da. U̱m no̱ng ko̱b-du̱ m-yar, tu̱msu̱ u̱m o̱ bu-u̱ m-to̱k, no̱ hagu̱n u̱ hyan-du̱ me̱ da.> ");
INSERT INTO gel_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","<<Iya o̱ hen e̱ do̱te̱ u̱t-zu̱, <Wa-ko-uyan, ¿mu̱ne̱ o̱ it hyane̱ bo̱ u̱ ho̱g-du̱ u̱s-me̱r, ko̱ u-swaat m-bu̱, ko̱ u̱r-hamu̱t ko̱ za u̱t-cwu̱, ko̱ u̱ ko̱b-du̱ m-yar ko̱ u̱ me̱ bu-u̱ m-to̱k, it gwak-u̱t bo̱ da?> ");
INSERT INTO gel_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","<<Wa de̱ zu̱ u̱n, <U̱m o̱ waru̱ no̱ u̱t-nip, ba shu̱'u̱te̱ no̱ no̱nge̱ wu̱ re̱k-wa wa-gan u̱ te̱k-u̱ no̱ da, me̱ no̱ no̱me̱ da.> ");
INSERT INTO gel_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","<<E̱ de̱ cwa-du̱ swadu̱ u̱r-ko̱b du̱ za u̱r-ma, ne̱t-tu̱ jab-u̱s so̱-se̱ cwaan u̱ be-du̱ fat-du̱ za u̱r-ma.>> ");
INSERT INTO gel_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Da-u̱ Ye̱so̱ tase̱ warru̱ rem-u̱s se̱ u̱s-be̱e̱t se̱ wa zu̱ a-doru̱ wa ne̱, ");
INSERT INTO gel_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","<<No̱ nak kwu̱ku̱s m-roog u̱t-yu̱r kanda na he̱e̱ste̱ Mo̱ro̱g-du̱ u̱r-Pas, na de̱ u̱ yasu̱ Wa'-u̱ Ne̱t na tar wa u-kan.>> ");
INSERT INTO gel_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Se̱ i-Yate̱ a-To̱o̱g-ne̱, u̱t-ne̱nge̱n ne̱, e̱ mo̱ro̱g u̱ bu-u yu̱-Yat-ya a-To̱o̱g, wu̱ na foge̱ Kayafa. ");
INSERT INTO gel_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","E̱ ye u̱s-rem, e̱ maas Ye̱so̱ m-yasa tu̱msu̱ e̱ ho̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Se̱di e̱ zu̱, <<Za u̱ da-u̱ Mo̱ro̱g-du̱ u̱r-Pas da, tasu̱ ne̱t-tu̱ yu̱nsu̱n u-gwu̱z da.>> ");
INSERT INTO gel_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Da-u̱ Ye̱so̱ o̱o̱ge̱ u̱ Bataniya, wa do̱'e̱ u̱ bu-u Simo̱n kim. Wu̱na Ye̱so̱ haste̱ go̱m-su̱ kim u̱ war-u wa. ");
INSERT INTO gel_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yaku̱n ne̱ta ya haan u̱du̱ Ye̱so̱ u̱ de̱ku̱n bakta-du̱ m-no̱o̱g ne̱ mu̱ shik sok, no̱o̱g-mu̱ wu̱s u-haku̱n. Da-u̱ Ye̱so̱ o̱ te̱k-u̱ u-re̱, wa dasu̱ wu̱ no̱o̱g-m mo̱ u̱r-hi. ");
INSERT INTO gel_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Se̱di da-u̱ a-doru̱ Ye̱so̱ hyane̱ iya, e̱ hog u̱s-ryab. E̱ zu̱ o̱r-u̱t e̱ ne̱, <<¿Uno̱ naas o̱? ");
INSERT INTO gel_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","U̱zu̱ wa babu̱g no̱o̱g-m mummo̱, na za kwu̱mu̱g shik u-tát, na mo̱tu̱ a-u̱r-ko̱b-ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ye̱so̱ nak no̱m-u̱ e̱ o̱ u̱t-war, se̱ wa zu̱ u̱n, <<¿Remu̱ u-yan o̱ no̱ o̱tte̱ e̱kse̱ ne̱ta-u inya remu̱ no̱m-u̱ so̱-o̱ wa no̱mu̱ me̱? ");
INSERT INTO gel_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","A-u̱r-ko̱b-ne̱ o̱ u̱r-kot u̱ no̱ ne̱ ko̱ mu̱ne̱, se̱di me̱, u̱m za u̱r-kot u̱ no̱ne̱ ko̱ mu̱ne̱ da. ");
INSERT INTO gel_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","No̱o̱g-m mummo̱ mu̱ wa dase̱ u̱ war-u ri, wa o̱ m-o̱ zo̱ngu̱ me̱ kanda na jwak me̱. ");
INSERT INTO gel_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","U̱m o̱ waru̱ no̱ u̱t-nip, be-du̱ no̱ do̱te̱ do̱nse̱-du̱ Rem-su̱ m-Re̱me̱r sin-se̱ u-me̱ u-dak u-be̱e̱t, na de̱ ha bak-su̱ no̱m-u̱ ne̱ta inya nome̱.>> ");
INSERT INTO gel_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Wa-gan u̱ te̱k-u̱ a-doru̱ rò o̱p u̱ yu̱r wu̱ na zu̱ye̱ Yahudas Iskariyoti, wa do̱'e̱ u̱du̱ i-Yate̱ a-To̱o̱g-ne̱. ");
INSERT INTO gel_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Wa zu̱, <<¿Yan o̱ no̱ de̱ yadu̱ me̱, a u̱m yasu̱ no̱ wu̱ne̱?>> E̱ ye' wu̱n ko̱nko̱ shik u̱r-shik u̱ o̱p. ");
INSERT INTO gel_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Du̱gu̱ da-u̱ o̱, Yahuda hu̱ sa-u̱ fu̱n-su̱ yasu̱ Ye̱so̱ u̱du̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","U̱ te̱k-u̱ ho̱-du̱ u̱r-taku̱n du̱ Mo̱ro̱g-du̱ u̱r-Be̱re̱di du̱ za m-Yis, se̱ a-dor haan u̱du̱ Ye̱so̱ e̱ zu̱, <<¿He̱ne̱ o̱ bo̱ o̱tte̱ u̱ssa it zo̱ngu̱ bo̱, bo̱ re̱ no̱m u̱t-re̱ u̱ Mo̱ro̱g-du̱ u̱r-Pas?>> ");
INSERT INTO gel_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wa zu̱, <<Cwaan u-bo̱ u̱du̱ yaku̱n campa-ya, no̱ zu̱ wa, <Wa-u̱t-ko̱se̱ zu̱u̱g, da-u wa teegu̱n, wa de̱ re̱-du̱ Mo̱ro̱g-du̱ u̱r-Pas u̱-me̱ bu-u ró u̱ a-doru̱ wa ne̱.> >> ");
INSERT INTO gel_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","A-dor nom u̱ka Ye̱so̱ zu̱tte̱ e̱ no̱m, tu̱msu̱ e̱ zo̱ng no̱m u̱t-re̱ u̱ Mo̱ro̱g-du̱ u̱r-Pas. ");
INSERT INTO gel_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Da-u̱ rim-mu̱ tore̱, se̱ Ye̱so̱ shu̱'u̱t m-shu̱'u̱t remu̱ wa re-u̱ no̱m u̱t-re̱ u̱ a-doru̱ wa ne̱ o̱p u̱ yu̱r. ");
INSERT INTO gel_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","U̱n o̱ te̱k u-re̱, Ye̱so̱ zu̱ u̱n, <<U̱m o̱ waru̱ no̱ u̱t-nip, u̱ te̱k-u̱ me̱ no̱ waku̱n de̱ yasu̱ me̱.>> ");
INSERT INTO gel_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","No̱m-u o̱ e̱kse̱ u̱n sok. E̱ he̱e̱se̱ shu̱t-du̱ wu̱n u-gan u-gan u̱zu̱, <<¿Wa-m-nap, me̱ wa?>> ");
INSERT INTO gel_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Se̱ wa shu̱s wa zu̱, <<Wu̱ o̱ re̱-du̱ no̱m u̱t-re̱ u̱r-kot u̱ me̱ ne̱, wa de̱ yasu̱ me̱. ");
INSERT INTO gel_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Wa'-u̱ Ne̱t de̱ m-mar u̱ka na pu̱nte̱ u̱-me̱ rem-su̱ u-Ru̱ u̱ mo̱t-u̱t wa. Se̱di no̱m-tu̱ u̱r-o̱n u̱du̱ wu̱ de̱ yasu̱ Wa'-u̱ Ne̱t! U̱t-ze̱g m-ku̱k u̱zu̱ na mak-u̱t ne̱tu̱ wa da, u̱ na mu̱tte̱ wa tu̱msu̱ wa ya'aste̱ Wa'-u̱ Ne̱t.>> ");
INSERT INTO gel_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Se̱ Yahudas wu̱ yasu̱ wu̱n wa zu̱, <<Wa-m-nap, ¿ko̱ me̱ wa?>> Ye̱so̱ shu̱s wa zu̱, <<Bo̱ waru̱g.>> ");
INSERT INTO gel_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","U̱n o̱ te̱k-u̱ u-re̱, se̱ Ye̱so̱ ku̱b u̱r-be̱re̱di, wa no̱m u̱t-vam u̱du̱ u-Ru̱ Wa bos de̱ wa yasu̱ a-doru̱ wa ne̱. Wa zu̱, <<Kabu̱n no̱ re̱, uno̱ war-u ri o̱.>> ");
INSERT INTO gel_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wa ku̱b ko̱k-du̱ bu̱-mu̱ inabi. Da-u̱ wa no̱me̱ u̱t-vam u̱du̱ u-Ru̱, se̱ wa yasu̱ u̱n. Wa zu̱, <<Swaan no̱ be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Hyu̱-m ri mo̱ mu̱ na nomte̱ este̱du̱ u̱s-rem, mu̱ na de̱ u̱t-azu̱g remu̱ jaas-du̱ ba'as-tu̱ u̱t-ne̱t u-tát. ");
INSERT INTO gel_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","U̱m o̱ waru̱ no̱, u̱m za u̱t-swu̱r m-swa bu̱-mu̱ inabi mo̱ da, se̱ ho̱-du̱ u̱m de̱ swa-u̱ bu̱-mu̱ inabi mu̱ po-mo̱ u̱r-kot u̱ no̱ ne̱ u̱ faru̱k-du̱ U̱so-u ri.>> ");
INSERT INTO gel_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Da-u̱ Ye̱so̱ u̱ a-doru̱ wa ne̱ fu Se̱p-u̱ u̱t-Vam, se̱ e̱ aru̱k m-rwu̱ m-ha Ro̱r-du̱ Te-su̱ Ze̱tun. ");
INSERT INTO gel_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ye̱so̱ zu̱ u̱n, <<No̱ be̱e̱t no̱ de̱ u̱t-som no̱ yagu̱ me̱ u̱ ane̱ u̱ gyu̱pu̱-m mummo̱, remu̱ no̱m-u̱ de̱ kwu̱m-du̱ me̱, remu̱ zu̱ o̱ m-pan u̱zu̱: << <U̱m de̱ gap-du̱ wa-u̱t-got, tu̱msu̱ ban-du̱ ca de̱ u̱t-bu̱ru̱g,> ");
INSERT INTO gel_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Se̱di a u̱m yu̱ne̱ du̱gu̱ m-mar me̱ ba-u̱ no̱ ha-mu̱ Gariri.>> ");
INSERT INTO gel_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Se̱ Biturus zu̱ wu̱n, <<Ko̱ ne̱t-tu̱ so̱mo̱g remu̱ no̱m-u̱ de̱ kwu̱m-du̱ bo̱, me̱ u̱m za m-so̱m da ko̱ ca.>> ");
INSERT INTO gel_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ye̱so̱ shu̱s wa zu̱, <<U̱m o̱ waru̱ bo̱ u̱t-nip, u̱ gyu̱p-mu̱ ya-o̱, kanda kan-su̱ ku̱u̱t, bo̱ de̱ no̱mu̱ se-m ri u-so u-tu̱t.>> ");
INSERT INTO gel_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Biturus zu̱ wu̱n, <<Ko̱ na ho̱ me̱, u̱m za no̱mu̱ se̱-mu̱ napu̱-m ró da.>> Iya o̱ hen a-dor zu̱tte̱ be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Se̱ Ye̱so̱ u̱ a-doru̱ wa ne̱ aru̱k m-ha u̱ de̱ku̱n be-de̱ du̱ na foge̱ Gesemani. Wa zu̱ a-doru̱ wa ne̱, <<shu̱'u̱tu̱n u̱ ane̱, u̱m de̱ m-ha u̱ ane̱ jit u̱m no̱m u̱s-to̱o̱g.>> ");
INSERT INTO gel_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Se̱ wa ku̱b Biturus u̱ yaag-u̱ Zabadi ne̱ yu̱r, Yakubu u̱ Yohanna. Se̱ wa he̱e̱se̱ namu̱ jab-u̱ dorog-su̱ jab ne̱ sok. ");
INSERT INTO gel_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Se̱ wa zu̱ u̱n, <<Namu̱ jab mu̱ o̱ jab-u̱ ri o̱ keru̱ ho̱-du̱ me̱. Shu̱'u̱tu̱n u̱ ane̱ no̱ no̱m u̱r-e' u̱ me̱ ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Da-u̱ wa hike̱ cashi, se̱ wa ru̱t m-ho̱bo̱g u-dak wa no̱m u̱s-to̱o̱g wa zu̱, <<U̱so-u ri, abite̱ u̱t-no̱me̱ has-tu̱ me̱ din-de̱ ko̱k-du̱ swa-u̱ u̱r-ko̱b de̱. Se̱di, za no̱m-u̱ u̱m zu̱ye̱ o̱ na de̱ u̱t-no̱m da, se̱ no̱m-u̱ bo̱ u̱t-sa.>> ");
INSERT INTO gel_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wa mu̱u̱n u̱du̱ a-doru̱ wa ne̱, wa bite̱ m-roog. Wa zu̱ Biturus, <<¿No̱ za keru̱ no̱m-du̱ u̱r-e' u̱ me̱ ne̱ ko̱ u-da u-gan da? ");
INSERT INTO gel_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","No̱mu̱n u̱r-e̱', tu̱msu̱ no̱mu̱n u̱s-to̱o̱g taas no̱ he̱ u̱-me̱ m-reg da. Jab u̱t-sa se̱di war-u̱ zatte̱ u̱r-be̱b da.>> ");
INSERT INTO gel_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Se̱ wa sur m-mu̱ wa no̱m u̱s-to̱o̱g wa zu̱, <<Uso-u ri, abite̱ din-de̱ swadu̱ u̱r-ko̱b za u̱t-yage̱ da, yage̱ na no̱m no̱m-u̱ bo̱ u̱t-sa.>> ");
INSERT INTO gel_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wa sur m-mu̱u̱n wa bit u̱n m-roog, remu̱ zu̱ is-u̱ u̱n shu̱u̱g m-roog. ");
INSERT INTO gel_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Wa yagu̱ u̱n, wa mu u-tu̱tu̱rse̱, wa nom u̱s-to̱o̱g, wa sur m-no̱m to̱o̱g-su̱ wa no̱me̱ u̱r-taku̱n. ");
INSERT INTO gel_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Wa mu̱u̱n u̱du̱ a-doru̱ wa ne̱, wa zu̱ u̱n, <<¿No̱ o̱ pama m-roog u̱r-hure̱ ne̱ ko̱? Da-u̱ no̱ng u̱ na do̱te̱ yasu̱ Wa'-u̱ Ne̱t u̱ kom-tu̱ a-u̱t-ba'as-ne̱. ");
INSERT INTO gel_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yu̱nu̱n, na no̱k, wu̱ de̱ yasu̱ me̱ ya wa teegu̱n.>> ");
INSERT INTO gel_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kanda Ye̱so̱ tagte̱ u-nu, Yahudas wa-gan u̱ te̱k-u̱ a-doru̱ rò u̱ mo̱ro̱g-du̱ u̱t-ne̱t teen, e̱ o̱ m-shu̱p u̱s-van ne̱ u̱s-te ne̱. I-Yate̱ a-To̱o̱g-ne̱ u̱ u̱t-ne̱nge̱n ne̱ e̱ to̱mnu̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Wu̱ de̱ yasu̱ Ye̱so̱ baag u̱ wargu̱ u̱n u̱zu̱, <<Wu̱ no̱ hyane̱ u̱m hamu̱tte̱ wa, masu̱n wa.>> ");
INSERT INTO gel_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Da-u̱ wa tene̱ wa do̱'e̱ u̱du̱ Ye̱so̱, wa zu̱ wu̱n, <<Wa-m-nap, u̱m o̱ ho̱su̱ bo̱.>> Se̱ Yahuda ham-u̱t wu̱n. ");
INSERT INTO gel_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ye̱so̱ zu̱ wu̱n, <<Hu̱u̱b-u̱ ri, no̱m no̱m-u̱ hatu̱n bo̱.>> Ku̱na ne̱t-tu̱ hatu̱n, e̱ maas Ye̱so̱, e̱ ship. ");
INSERT INTO gel_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Da-u̱ e̱ hyane̱ iya, te̱k-u̱ ne̱t-tu̱ o̱ u̱r-kot u̱ Ye̱so̱ ne̱, wa faru̱n van-u wa, wa ket waku̱n u̱ te̱k-u̱ to̱k-u̱ yu̱-Yat-ya a-to̱o̱g-ne̱ u-to̱. ");
INSERT INTO gel_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ye̱so̱ zu̱ wu̱n, <<Mute̱ van-u ró u̱-me̱ u̱r-paku̱m, remu̱ zu̱ wu̱ kabe̱ u-van, van-ya de̱ ho̱-du̱ wa. ");
INSERT INTO gel_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿No̱ o̱ m-hyan u̱zu̱ u̱m zatte̱ u̱r-be̱b u̱m ko̱n u̱r-se̱ge̱ u̱du̱ U̱so-u ri da, tu̱msu̱ za rem wa to̱mnu̱ me̱ a-to̱mu̱ wa u̱t-zo̱ngu u-tát i ze̱ge̱ karma no̱? ");
INSERT INTO gel_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","¿Re̱ na do̱te̱ shu̱su̱ no̱m-u̱ rem-su̱ u-Ru̱ su̱ na pane̱ u̱zu̱ tun-to̱ u̱t-be̱e̱t na no̱mu̱ to̱?>> ");
INSERT INTO gel_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Da Ye̱so̱ zu̱ ne̱t-u̱t to̱, <<¿No̱ rwu̱gu̱n u̱s-van ne̱ u̱s-te ne̱ no̱ maaste̱ me̱ u̱ka hyu̱w a? Ko̱ mu̱ne̱ u̱m o̱ u̱r-ko̱t u̱ no̱ne̱ u̱ me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan u̱m o̱ no̱mu̱ no̱ u̱t-ko̱se̱ no̱ maaste̱ me̱ da. ");
INSERT INTO gel_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ko̱ ba shu̱'u̱te̱ na no̱ng inya remu̱ na shu̱u̱ste̱ no̱mu̱ a-warru̱ rem-su̱ u-Ru̱ ne̱ pane̱ u̱-me̱ rem-su̱ u-Ru̱.>> Da-u̱ a-dor-ne̱ ho̱ge̱ iya, e̱ som. ");
INSERT INTO gel_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Se̱ i mase̱ Ye̱so̱, e̱ hu̱u̱t wu̱n u̱du̱ Kayafa, yu̱-Yat-ya a-to̱o̱g-ne̱, ku̱na a-ko̱se̱-tu̱ bo̱r-u̱t Mosa u̱ u̱t-ne̱nge̱n ne̱ mo̱ro̱gte̱. ");
INSERT INTO gel_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Se̱ Biturus dor u̱n m-ra m-ra, m-te bu-u̱ yu̱-Yat-ya a-to̱o̱g-ne̱. Wa do̱'e̱ wa shu̱'u̱t u̱du̱ a-u̱r-e'-ne̱ u̱ remu̱ wa hyen-u̱t u̱ka na do̱te̱ u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","I-Yate̱ a-To̱o̱g-ne̱, u̱ ne̱t-tu̱ Mo̱ro̱g-du̱ u̱t-Ne̱nge̱n ne̱ be̱e̱t karu̱g, e̱ o̱ go-tu̱ bi-su̱ na de̱ ke̱-tu̱ Ye̱so̱ u̱ka na do̱te̱ kwu̱m-du̱ be̱b-du̱ ho̱-du̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Se̱di u̱n kwu̱mu̱g da, ko̱ ba shu̱'u̱te̱ e̱ke̱n u-tát e̱ ke̱k-tu̱ wu̱n rem-su̱ u̱s-bi u-tát. A tase̱ ne̱t-ne̱ yu̱r rwu̱u̱n. ");
INSERT INTO gel_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","E̱ zu̱, <<Ne̱t unwa zu̱u̱g, <Me̱ keru̱ ru̱-du̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan u-Ru̱, tu̱msu̱ wa ma o̱ u̱ te̱k-u̱ m-roog u̱t-tu̱t.> >> ");
INSERT INTO gel_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Yu̱-Yat-ya a-to̱o̱g-ne̱ yu̱ne̱ wa zu̱, <<¿Bo̱ zatte̱ no̱m-u̱ bo̱ de̱ u̱t-zu̱ da? ¿Re̱ o̱ mo̱ttu̱ no̱m-u̱ e̱ zu̱ bo̱ no̱nge̱?>> ");
INSERT INTO gel_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ye̱so̱ ho̱ u̱s-ram. Yu̱-Yat-ya a-To̱o̱g zu̱ wu̱n, <<U̱m samgu̱ bo̱ u-Ru̱ ne̱ wu̱ u̱r-fat, waru̱ it ko̱ bo̱ wa o̱ Kiristi Wa' u-Ru̱!>> ");
INSERT INTO gel_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ye̱so̱ zu̱, <<U̱ka bo̱ wu̱rte̱. Se̱di u̱m o̱ waru̱ no̱, du̱gu̱ da-o̱, no̱ de̱ hyan-du̱ Wa'-u̱ Ne̱t u̱ be-du̱ u̱r-faru̱k du̱ kom u̱s-cwa u-Ru̱, wa o̱ haan u̱-me̱ u̱r-ku̱u̱t du̱gu̱ u-ru̱.>> ");
INSERT INTO gel_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Se̱ yu̱-Yat-ya a-to̱o̱g-ne̱ kemu̱sse̱ to̱ggo̱-u wa remu̱ u̱s-ryab. Wa zu̱, <<¿Yan o̱ tu̱msu̱ na u̱t-sa na ho̱ge̱? No̱ ho̱k wa no̱ngu̱ u-Ru̱ u̱t-ba'as. ");
INSERT INTO gel_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Yan-o̱ no̱ hyane̱?>> E̱ shu̱s e̱ zu̱, <<Ko̱rge̱ na ho̱ wu̱n.>> ");
INSERT INTO gel_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","E̱ top-su̱ wu̱n m-ta u-shu̱, e̱ gapu̱r wu̱n. E̱ke̱n zo̱o̱r wu̱n u̱t-gap, ");
INSERT INTO gel_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","E̱ o̱ u̱t-zu̱, <<No̱m m-hyan, abite̱ bo̱ wa Kiristi, ¿war wu̱ gapu̱ bo̱?>> ");
INSERT INTO gel_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","U̱ da-u o̱ hen Biturus o̱ shu̱'u̱t u̱ kat-du̱ bu-u o̱, se̱ e̱ke̱n gwu̱p-e̱ i o̱ m-ank u̱ bu-u o̱, wa haan u̱du̱ ró wa zu̱, <<Ko̱ bo̱, bo̱ o̱ u̱r-kot u̱ Ye̱so̱ ne̱ ne̱t-u̱ Gariri.>> ");
INSERT INTO gel_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Biturus no̱m m-se̱ u̱du̱ u̱n, wa zu̱, <<Me̱ m-nak no̱m-u̱ bo̱ o̱tte̱ u̱s-rem da!>> ");
INSERT INTO gel_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Da-u̱ wa rwu̱ne̱ u̱ pyu̱, e̱ke̱n gwu̱p-e̱ tu̱msu̱ wu̱ o̱ m-nak u̱ bu-u o̱ hyen wu̱n wa zu̱ ne̱t-tu̱ o̱ u̱ ees u̱ku̱n, <<Ne̱t unwa o̱ u̱r-ko̱t u̱ Ye̱so̱ wa-Nazara ne̱.>> ");
INSERT INTO gel_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Biturus sur m-no̱m m-se' u̱s-to̱nd ne̱ u̱zu̱, <<U̱m nak campa-u ya da!>> ");
INSERT INTO gel_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","A sure̱ m-waas cashi, ne̱t-tu̱ o̱ ees u̱ku̱n e̱ haan, e̱ zu̱ Biturus, <<Nip-to̱ bo̱ o̱ te̱k-u̱ u̱n. Ka bo̱ o̱tte̱ u̱s-rem ko̱ske̱.>> ");
INSERT INTO gel_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Se̱ Biturus hu̱ u̱s-to̱nd u̱zu̱, <<U̱ Ru̱-u̱ ya me̱ u̱r-ko̱b abite̱ bise̱ u̱m o̱tte̱, u̱m nak ne̱t-u̱ wa da.>> Za rem ku̱u̱t he̱e̱se̱ u̱s-kan. ");
INSERT INTO gel_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Biturus baku̱s rem-u̱s Ye̱so̱ no̱mu̱ wa u̱zu̱, <<Kanda kan-su̱ ku̱u̱t, bo̱ de̱ no̱mu̱ se-m ri u-so u-tu̱t.>> Biturus ru u̱du̱ wa no̱m u̱s-kan sok. ");
INSERT INTO gel_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Da-u̱ is gase̱ u̱r-wu̱n, se̱ yu̱-Yat-ya a-to̱o̱g-ne̱, u̱t-ne̱nge̱n ne̱ e̱ e̱ ye u̱s-rem u̱zu̱ e̱ ho̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Se̱ e̱ gu̱g wu̱n, e̱ aru̱k u̱ wu̱n ne̱ m-ha u̱du̱ Biratus, wa-u-dak yu̱ Roma. ");
INSERT INTO gel_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Da-u̱ Yahudas wu̱ yase̱ wu̱n na hoot, hyane̱ na kwu̱pku̱ u̱s-rem u̱zu̱ na ho̱ Ye̱so̱, se̱ wa sur m-dorog. Wa mu̱u̱n u̱du̱ i-Yate̱ a-To̱o̱g-ne̱, u̱t-ne̱nge̱n ne̱, wa muutu̱ u̱n ko̱nko̱ shik-u̱ u̱n u̱r-shik u̱ o̱p. ");
INSERT INTO gel_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Wa zu̱, <<U̱m no̱ng u̱t-ba'as, u̱m ya'aste̱ wa za u̱t-ba'as na ho̱.>> Se̱ e̱ zu̱ wu̱n, <<¿Bu̱-m it mu̱ yu̱? Se̱se̱ su̱ ró se̱.>> ");
INSERT INTO gel_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Se̱ wa gun shik-u̱ u̱-me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan. Wa aru̱k m-rwu̱, wa su̱rgu̱sse̱ hi-u̱r wa u-ho, wa mu̱r. ");
INSERT INTO gel_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ku̱na i-Yate̱ a-To̱o̱g-ne̱ kooste̱ shik-u̱ e̱, e̱ zu̱, <<No̱ng u̱r-zwar na muut shik-u̱ e̱ u̱ cu̱n-du̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan da, remu̱ zu̱ shik m-hyu̱ e̱.>> ");
INSERT INTO gel_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","E̱ ye u̱s-rem, e̱ o de̱ku̱n be-de̱, remu̱ zu̱ e̱ muute̱ be-u̱r re̱ be-du̱ jwak-du̱ u̱t-hamu̱t ne̱ a e̱ mare̱. Na zu̱ be-u̱r re̱, be-du̱ wa ma-u̱ u̱t-tur. ");
INSERT INTO gel_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Remu̱ iya, na o̱mnu̱ fag-du̱ be-u̱r re̱, Be-du̱ m-Hyu̱. ");
INSERT INTO gel_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Iya o̱ na shu̱u̱ste̱ no̱m-u̱ wa-warru̱ rem-su̱ u-Ru̱ Irmiya ware̱ u̱zu̱, <<Na kabu̱g ko̱nko̱ shik u̱r-shik u̱ o̱p 30, shik-u̱ Isra-ne̱ zu̱ na to̱p-u̱ remu̱ rò. ");
INSERT INTO gel_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Se̱ e̱ o be-du̱ wa ma-u̱ u̱t-tur u̱ shik-u̱ e̱, u̱ka rem-su̱ Yawe zu̱tte̱.>> ");
INSERT INTO gel_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ye̱so̱ o̱ ees u̱ shu̱ faru̱k wa-u-dak, wa shit Ye̱so̱ u̱zu̱, <<¿Bo̱ wa o̱ faru̱k-u̱ Yahuda-ne̱?>> Ye̱so̱ zu̱, <<Bo̱ waru̱g.>> ");
INSERT INTO gel_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Se̱di da i-Yate̱ a-To̱o̱g-ne̱ u̱ u̱t-ne̱nge̱n ne̱ ke̱tu̱ Ye̱so̱ u̱s-rem, u zu̱u̱g o̱ko̱n da. ");
INSERT INTO gel_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Se̱ Biratus zu̱ wu̱n, <<¿Bo̱ ho̱k no̱m-u̱t tun-to̱ tu̱ na zu̱ bo̱ no̱mu̱g da?>> ");
INSERT INTO gel_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ye̱so̱ shaku̱s ko̱ u̱r-shu̱t u̱r-gan da. Remu̱ iya wa-u-dak hu̱ mu̱rimmo̱ sok. ");
INSERT INTO gel_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Wa-u-dak ve̱k-u̱t u̱ da-u̱ Mo̱ro̱g-du̱ u̱r-Pas u-be̱e̱t, wa restu̱n wa-gan u̱ te̱k-u̱ ne̱t-tu̱ o̱ tage̱ wu̱ ne̱t-tu̱ u̱t-sa. ");
INSERT INTO gel_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","U̱ da-u hen, waku̱n o̱ro u̱ tage̱ wu̱ kowan nape̱ wa u̱t-ba'as wa, na zu̱ wa Barabas. ");
INSERT INTO gel_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Da-u̱ ne̱t-tu̱ mo̱rge̱, se̱ Biratus zu̱ u̱n, <<¿Wana no̱ u̱t-sa na restu̱n no̱? ¿Barabas wa ko̱ Ye̱so̱ wu̱ na zu̱ Kiristi?>> ");
INSERT INTO gel_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Biratus zu̱u̱g iya, remu̱ zu̱ Biratus nak u̱zu̱ rem u̱r-shu̱b de̱ na ya'aste̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Da-u̱ Biratus shu̱'u̱te̱ u̱ be-du̱ kwu̱p-du̱ u̱s-remu̱ wa, se̱ ne̱ta wa to̱mo̱n na waru̱ wa u̱zu̱, <<Ruute̱ kom-u̱t ró u̱ rem-su̱ wa za u̱t-ba'asu̱ wa, remu̱ iya o̱ u̱m soote̱ u̱r-ko̱b sok m-gyu̱p u̱ bo'-u̱ mo̱ttu̱ ne̱tu̱ wa.>> ");
INSERT INTO gel_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ku̱na i-Yate̱ a-To̱o̱g-ne̱ u̱t-ne̱nge̱n ne̱ tokte̱ u̱t-ne̱t u̱zu̱ na restu̱n Barabas, na ho̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Wa-u-dak sur m-zu̱, <<¿Wana u̱m de̱ restu̱n no̱, u̱ te̱k-u̱ ne̱t-u̱t tun-to̱?>> E̱ zu̱, <<Barabas wa!>> ");
INSERT INTO gel_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Se̱ Biratus zu̱ u̱n, <<¿Yan o̱ u̱m de̱ no̱mu̱ Ye̱so̱ wu̱ na zu̱ Kiristi?>> E̱ be̱e̱t kowan zu̱, <<Tar wu̱n u-kan!>> ");
INSERT INTO gel_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Biratus zu̱, <<¿Remu̱ u-yane̱? ¿Yan o̱ wa no̱me̱ u̱ yo̱-o̱?>> Ne̱t-tu̱ sur m-yu̱ns u̱s-cwar u̱zu̱, <<Tar wu̱n u-kan!>> ");
INSERT INTO gel_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Da-u̱ Biratus hyane̱ wa kerge̱ swan-du̱ hi-tu̱ u̱t-ne̱t da, tu̱msu̱ ne̱t-tu̱ o̱ mo̱t-tu̱ yu̱nsu̱ gwu̱z u̱ku̱n, se̱ wa yib m-bu̱ wa jaas ko̱m-u̱t wa u̱ hyan-mu̱ u̱t-ne̱t. Wa zu̱, <<Me̱ bu̱-m ri zarra, u̱m kabu̱g ra-u̱ wa za u̱t-ba'asu̱ unwa ne̱ da. No̱ wa.>> ");
INSERT INTO gel_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Se̱ ne̱t-u̱t to̱ u̱t-be̱e̱t e̱ yu̱ns u̱s-cwar u̱zu̱, <<Yage̱ ra-u o̱ u̱ do̱r it u̱ ya'ag-u̱ it ne̱!>> ");
INSERT INTO gel_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Se̱ wa restu̱n u̱n Barabas. Da-u̱ wa wa'e̱ na no̱mu̱ Ye̱so̱ u̱s-ryap, se̱ wa yasu̱ wu̱n na tar wa u-kan. ");
INSERT INTO gel_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Du̱gu̱ ku̱n karma-ne̱ i wa-u-dak ku̱b Ye̱so̱ e̱ toot u̱ pada-u wa-u-dak, e̱ kargu̱ssu̱n karma-ne̱ u-tát u̱du̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","E̱ horom wu̱n u̱t-cwu̱, e̱ wa'-u̱ wu̱n yaku̱n to̱ggo̱-u jaz-ya go̱-du̱ yu̱ farkina-ne̱. ");
INSERT INTO gel_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","E̱ no̱mu̱ de̱ku̱n no̱m-du̱ u̱r-hi du̱ u̱s-hir de̱ go̱-du̱ farkina-ne̱, e̱ wa'-u̱ wu̱n u̱r-hi, e̱ yasu̱ wu̱n u-ko̱m wa ship u̱ kom u̱s-cwa rò, e̱ so̱k-u̱t u̱ ke̱nu̱ rò e̱ no̱m wu̱n huuk-tu̱ u̱s-bi, e̱ o̱ zu̱ wu̱n, <<Ho̱'o̱ faru̱k-u̱ Yahuda-ne̱!>> ");
INSERT INTO gel_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","E̱ to̱p-su̱ wu̱n m-ta, e̱ o̱nk ko̱m-yu̱ e̱ yasu̱ wu̱n, e̱ hu̱ gapru̱ wu̱n u̱ ya u̱r-hi. ");
INSERT INTO gel_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Da-u̱ e̱ tase̱ no̱mu̱ wu̱n u̱s-ju̱ru̱m, e̱ for to̱ggo̱-u jaz-ya ya, e̱ wa-u̱ wu̱n cwu̱-u̱t rò. E̱ aru̱k u̱ wu̱n ne̱ remu̱ na tu̱r-u̱t wu̱n u-kan. ");
INSERT INTO gel_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","U̱n o̱ te̱k-u̱ m-ha, u̱n goone̱ u̱ yaku̱n campa-ya ne̱ ne̱t-u̱ bo̱-u̱ Sayirin, dim-u̱r Simo̱n. E̱ wu̱ wa u̱ kab-du̱ kan-u Ye̱so̱ u̱r-be̱b. ");
INSERT INTO gel_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","E̱ te de̱ku̱n be-de̱ du̱ na zu̱ye̱ Gorgota, (na zu̱ de̱ <<Ko̱g-du̱ u̱r-Hi>>). ");
INSERT INTO gel_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","E̱ ye' wu̱n bu̱-mu̱ ke̱' u̱r-waak u̱t-gag ne̱ u̱ remu̱ wa soot. Da-u̱ wa rake̱, wa gu̱gu̱m u̱t-swa. ");
INSERT INTO gel_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Da-u̱ e̱ taru̱ wu̱n u-kan, se̱ e̱ gun u-kwe̱mbi e̱ mo̱t to̱ggo̱-u rò. ");
INSERT INTO gel_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","A tase̱ u̱n shu̱'u̱t u̱ku̱n u̱n o̱ er-u̱r wu̱n. ");
INSERT INTO gel_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","U̱ do̱m-u̱ hi-u̱r rò, u̱n pu̱n ba'as-tu̱ wa no̱me̱ u̱zu̱, <<UNWA O̱ YE̱SO̱ FARU̱K-U̱ YAHUDA-NE̱.>> ");
INSERT INTO gel_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tu̱msu̱ na tu̱r Ye̱so̱ u̱ e̱ke̱n ne̱ hyu̱w-ne̱ yu̱r, wa-gan u̱ kom u̱s-cwa wa-gan u̱ kom u̱r-beer. ");
INSERT INTO gel_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ne̱t-tu̱ o̱ aru̱k e̱ hu̱ ru̱m-su̱ u̱t-hi u̱ no̱mu̱ wu̱n u̱s-ju̱ru̱m, ");
INSERT INTO gel_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","e̱ o̱ u̱t-zu̱, <<Bo̱ yu̱ do̱'e̱ ru̱-du̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan, tu̱msu̱ bo̱ ma o̱ u̱ te̱k-u̱ m-roog u̱t-tu̱t, gu hi-du̱ war ró! Abite̱ bo̱ Wa'-u̱ u-Ru̱ wa, cu̱zne̱ u̱ do̱m u-kan.>> ");
INSERT INTO gel_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Iya o̱ hen, i-Yate̱ a-To̱o̱g-ne̱ a-ko̱se̱-tu̱ bo̱r-u̱t Mosa ne̱ u̱t-ne̱nge̱n ne̱ hu̱u̱te̱ no̱mu̱ wu̱n u̱s-ju̱ru̱m. ");
INSERT INTO gel_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","E̱ o̱ u̱t-zu̱, <<Wa gwu̱g e̱ke̱n, tu̱msu̱ wa kerge̱ gwu̱du̱ hi-u̱r wa da. Abite̱ wu̱n faru̱k-u̱ Isra-ne̱ wa, yage̱ wa cu̱zu̱n u̱-do̱m u-kan na hyan, da-u o̱ it de̱ yadu̱ jab-u̱ wu̱n ne̱! ");
INSERT INTO gel_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Wa ya'aste̱ jab u̱du̱ u-Ru̱. Yage̱ Ru̱-u̱ gu wu̱n u̱ da-o̱, a u u̱t-sa, wa zu̱u̱g Wa'-u̱ u-Ru̱ wa o̱ye̱.>> ");
INSERT INTO gel_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Iya o̱, hyu̱w-ne̱ e̱, i na taru̱ e̱ u-kan u̱r-kot, e̱ no̱ngu̱ wu̱n gom-u̱ rim-o̱. ");
INSERT INTO gel_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","U̱ te̱k-u̱ u-ho̱, cwu̱m-yu̱ tage̱ u-dak u-be̱e̱t, m-te̱ kwam-su̱ u̱s-tu̱t su̱ m-rim. ");
INSERT INTO gel_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","U̱ te̱k-u̱ u̱s-kwam u̱s-tu̱t, Ye̱so̱ jaku̱s u-cwar wa zu̱, <<E̱ri, E̱ri, ¿Rama sabaktani?>> Wata, <<Ru̱-u ri, Ru̱-u ri, ¿remu̱ yan o̱ bo̱ yaktu̱ me̱?>> ");
INSERT INTO gel_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ne̱t-tu̱ o̱o̱ge̱ ees u̱ku̱n da-u̱ e̱ ho̱ge̱ iya, e̱ zu̱, <<Ne̱t uno̱ o̱ fag-du̱ Iriya.>> ");
INSERT INTO gel_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Du̱gu̱ ku̱n waku̱n yu̱ne̱ za naas u-da wa kabu̱n soso. Wa mu̱s de̱ u̱-me̱ bu̱-mu̱ u-zu̱r, wa su̱k-de̱ u̱ do̱m u-te wa nabu̱ wu̱n wa soot. ");
INSERT INTO gel_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","E̱ke̱n zu̱, <<Yagu̱n wu̱n u̱su̱ rò, na hyan ko̱ Iriya u̱t-haan wa gu wu̱n!>> ");
INSERT INTO gel_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Se̱ Ye̱so̱ sur m-yu̱ns u-cwar u̱r-be̱b ne̱, du̱gu̱ ku̱n wa ku̱b u̱r-fat. ");
INSERT INTO gel_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","U̱ da-u o̱ kus-u̱ u-is u̱ na erge̱ u-me̱ be-du̱ u-he̱n du̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan o̱ kees u̱t-kik u̱t-yu̱r, du̱gu̱ do̱m u-ru̱ m-cu̱z u-dak. Na no̱m ru̱mu̱s-du̱ u-dak, tu̱msu̱ tar-tu̱ yo̱'o̱k. ");
INSERT INTO gel_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Sag-tu̱ u-pus, ne̱t-tu̱ u-Ru̱ u-tát i mare̱ e̱ yu̱ne̱ u̱r-fat. ");
INSERT INTO gel_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","(Da-u̱ e̱ bite̱ Ye̱so̱ yu̱nge̱ du̱gu̱ m-mar, e̱ yage̱ u̱t-sag. Se̱ e̱ to u̱ bo̱-u̱ u-he̱n, u̱t-ne̱t u-tát e̱ hyen u̱n.) ");
INSERT INTO gel_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","U̱ da-u̱ yaku̱n yu̱-shu̱ karma Roma u̱ e̱ke̱n karma-ne̱, i o̱ e-u̱r Ye̱so̱ e̱ hyen no̱mu̱ nome̱ u-be̱e̱t, e̱ hog u-gye̱r sok. E̱ zu̱, <<U̱t-nip, unwa Wa'-u̱ u-Ru̱ wa!>> ");
INSERT INTO gel_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","To̱ko̱n ne̱ta to̱ o̱ro u̱ku̱n u-tát tu̱ do̱ru̱ Ye̱so̱ du̱gu̱ Gariri e̱ o̱ no̱mu̱ wu̱n u̱s-pama. E̱ ees m-ra e̱ o̱ madi-du̱ no̱mu̱ na o̱ u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","U̱ te̱k-u̱ u̱n, Me̱ri o̱ro du̱gu̱ Magadarin, u̱ Me̱ri ino-u Yakubu u̱ Yusuhu, tu̱msu̱ ino-u yagu̱ Zabadi. ");
INSERT INTO gel_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Da rim-mu̱ tore̱, se̱ waku̱n wa-u̱t-kwu̱m wa ne̱t-u̱ Arimatiya, dim-u̱r wa Yusuhu, wa haan, ko̱wa wa o̱ te̱k-u̱ a-doru̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Wa do̱'e̱ u̱du̱ Biratus, wa kon u̱zu̱ na ya wa u-u̱r Ye̱so̱. Biratus hen wa zu̱ na yasu̱ wu̱n u̱r-u. ");
INSERT INTO gel_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Se̱ Yusuhu ku̱b u-u̱r re̱ wa ho̱po̱s de̱ u̱ kus-u pus-o̱ u̱ so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Wa gu̱n u-u̱r re̱ u̱-me̱ sag-u po-o̱ wa, u̱ na kawe̱ u̱-me̱ u̱t-tar. Wa kabu̱n ta'ar-u̱r yat-de̱ wa wu̱gu̱b is-yu̱ u-sag, wa aru̱k. ");
INSERT INTO gel_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Me̱ri Magadarin u̱ inya jit Me̱ri ya, e̱ o̱ shu̱'u̱t u̱ dapu̱s u-sag. ");
INSERT INTO gel_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Da-u̱ is gase̱, ba ho̱-du̱ u̱t-zo̱ng arke̱, i-Yate̱ a-To̱o̱g-ne̱ u̱ Farisa-ne̱ e̱ mo̱ro̱g u̱ shu̱ Biratus. ");
INSERT INTO gel_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","U̱n haan u̱du̱ wa-u-dak u̱n zu̱, <<It baku̱ste̱ u̱zu̱ da-u̱ ne̱t unwa wa u̱s-bi o̱o̱ge̱ u̱r-fat wa zu̱u̱g, <U̱m de̱ u̱r-yu̱ne̱ du̱gu̱ m-mar u̱ ho̱-du̱ u-tu̱tu̱rse̱.> ");
INSERT INTO gel_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Remu̱ iya na e̱' sag-u o̱ u̱r-zwar ne̱, m-ha u̱ ho̱-du̱ u-tu̱tu̱rse̱, u̱ remu̱ zu̱ a taase̱ u̱ a-doru̱ rò haan e̱ hast war-u rò, e̱ zu̱ u̱t-ne̱t wa yu̱nge̱ du̱gu̱ marimari ne̱. A shu̱'u̱te̱ iya e̱nk-su̱ m-vaste̱ mo̱ u̱t-ze̱g u̱r-taku̱n m-yo̱.>> ");
INSERT INTO gel_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Biratus zu̱ u̱n, <<Sa'an karma-ne̱, e̱ do̱'e̱ e̱ no̱m u̱r-e' u̱ka no̱ hyente̱ kamu̱g.>> ");
INSERT INTO gel_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Se̱ e̱ aru̱k, e̱ wo ge̱r u̱-do̱mu̱ ta'ar-du̱ o̱ do̱m-u̱ u-sag taas u̱ waku̱n u̱ tam da, tu̱msu̱ e̱ wo karma-ne̱ e'-du̱ sag-u o̱. ");
INSERT INTO gel_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ba Ho̱-du̱ u̱r-Hure̱ du̱ roog-mu̱ u̱t-ta'er arke̱, u̱ te̱k-u̱ ho̱-du̱ u̱r-taku̱n du̱ roog-mu̱ u̱t-ta'er, u̱r-is gas, Me̱ri Magadarin u̱ yaku̱n ne̱ta-ya wu̱ na foge̱ Me̱ri e̱ yu̱ne̱ e̱ do̱'e̱ u̱du̱ u-sag. ");
INSERT INTO gel_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Za rem, na no̱m de̱ku̱n ru̱mu̱s-du̱ u-dak de̱ u-tát, se̱ waku̱n wa-to̱m Wa-ko-uyan wa haan du̱gu̱ do̱m u-ru̱, wa irgu̱sse̱ ta'ar-u̱ na taku̱ste̱ u-sag, wa shu̱'u̱t u̱ do̱m-u̱ ta'ar-u o̱. ");
INSERT INTO gel_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Wa o̱ m-baku̱t, tu̱msu̱ cwu̱'u̱t wa u̱ pus-to̱ pu̱t u̱ka u̱t-randi. ");
INSERT INTO gel_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Da-u̱ a-u̱r-e'-ne̱ hyane̱ wu̱n, e̱ hog u-gye̱r sok, e̱ o̱ m-zap, e̱ he u-dak u̱ka marimari ne̱. ");
INSERT INTO gel_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ku̱na wa-to̱m u-Ru̱ zu̱tte̱ ne̱ta-u̱t to̱, <<A no̱ ho̱g u-gye̱r da! U̱m nak no̱ o̱ sa-u Ye̱so̱ wa, wu̱ na tare̱ u-kan. ");
INSERT INTO gel_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wa za ane̱ da. Wa yu̱nge̱ u̱ka wa zu̱tte̱. Haanu̱n no̱ hyan be-du̱ wa o̱tte̱ m-ru̱t. ");
INSERT INTO gel_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","No̱mu̱n m-ho̱r no̱ do̱'e̱, no̱ waru̱ a-doru̱ wa u̱zu̱, <Ye̱so̱ yu̱nge̱ du̱gu̱ marimari ne̱. Wa de̱ hen u̱ ba-du̱ no̱ m-te̱ Gariri, ku̱na no̱ do̱te̱ hyan-du̱ wu̱n.> Baksu̱n no̱m-u̱ u̱m waru̱ no̱.>> ");
INSERT INTO gel_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Se̱ e̱ yage̱ be-du̱ u-sag, u-gye̱r ne̱ sok, tu̱msu̱ u̱r-so̱ ne̱ sok. E̱ ku̱su̱m m-so̱m remu̱ e̱ war-tu̱ a-doru̱ Ye̱so̱, ");
INSERT INTO gel_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ye̱so̱ u̱ hi-u̱r wa, wa goone̱ u̱ u̱n ne̱, wa zu̱ u̱n, <<Jab-u̱s pusse̱ u̱du̱ no̱!>> E̱ hikne̱ e̱ ham-u̱t na-u̱s rò, e̱ no̱mu̱ wu̱n u̱t-huuk. ");
INSERT INTO gel_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ye̱so̱ zu̱ u̱n, <<A no̱ ho̱g u-gye̱r da! No̱ko̱n no̱ waru̱ o̱r-u̱t ri ne̱ na goone̱ u̱ Gariri, ku̱na e̱ do̱te̱ hyan-du̱ me̱.>> ");
INSERT INTO gel_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Da-u̱ ne̱ta-u̱t to̱ o̱ te̱k-u̱ m-ha, te̱k-u̱ ne̱t-tu̱ e'-du̱ sag-u o̱, e̱ to u-bo̱, e̱ waru̱ i-Yate̱ a-To̱o̱g-ne̱ no̱m-u̱ na no̱me̱ u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ku̱na yu̱-Yat-ya a-To̱o̱g-ne̱ u̱t-ne̱nge̱n ne̱ gu̱gte̱ u̱t-hi, e̱ ye' karma-ne̱ shik u-tát, ");
INSERT INTO gel_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","E̱ zu̱, <<Waru̱n u̱t-ne̱t u̱zu̱, <A-doru̱ rò haane m-gyu̱p e̱ hiwis wu̱n da-u̱ no̱ o̱o̱ge̱ m-roog.> ");
INSERT INTO gel_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","A rem-su̱ teye̱ u̱du̱ wa-u-dak, it no̱mu̱ wa u̱s-rem taas no̱ swa u̱r-ko̱b da.>> ");
INSERT INTO gel_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ku̱na karma-ne̱ o̱nkte̱ shik, e̱ nom u̱ka na zu̱tte̱ e̱ no̱m. No̱m-u o̱ gu̱ru̱s u̱-me̱ Yahuda-ne̱ u̱ haan u̱ da-o̱. ");
INSERT INTO gel_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","A-dor o̱p u-gan do̱'e̱ u̱ Gariri, e̱ do̱'e̱ u̱ ro̱r-du̱ Ye̱so̱ zu̱tte̱ e̱ goone̱. ");
INSERT INTO gel_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Da-u̱ e̱ hyane̱ wu̱n, e̱ no̱mu̱ wu̱n u̱t-huuk, se̱di e̱ke̱n no̱ng u-sakna. ");
INSERT INTO gel_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Se̱ Ye̱so̱ hikne̱ u̱t-mo̱r wa zu̱ u̱n, <<U̱so-u ri ya'aste̱ me̱ faru̱k-du̱ do̱m u-ru̱ u-dak ne̱ u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Remu̱ iya, do̱'e̱n no̱ no̱mu̱ ne̱t-tu̱ u-dak u̱t-be̱e̱t ko̱se̱-tu̱ rem-u̱s ri, u̱ka e̱ do̱te̱ shu̱'u̱tu̱ a-doru̱ ri. No̱ no̱mu̱ e̱ u̱t-yu̱bu̱sse̱ m-bu̱ e̱ shu̱'u̱t u̱-me̱ faru̱k-du̱ U̱so-u ri, u̱du̱ ri ne̱, Wa'-u̱ wa, tu̱msu̱ u̱du̱ Yar-u u-Ru̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","No̱ is-u̱ u̱n e̱ do̱r no̱m-u̱ u̱m zu̱ no̱ no̱m u-be̱e̱t. U̱m o̱ u̱r-kot u̱ no̱ ne̱ ko-uyan da m-te ma-du̱ u-da.>>");
INSERT INTO gel_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiyapo̱rus, u̱ ran-u ri u̱r-taku̱n u̱m pangu̱n bo̱ u̱ remu̱ no̱m-tu̱ Ye̱so̱ tak-ne̱ u̱t-no̱m u̱t-ko̱se̱ ne̱, ");
INSERT INTO gel_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","m-te̱ ho̱-du̱ wa du̱se̱ u̱-do̱m u-ru̱. Kanda na ku̱b-u̱t wa m-da u-ru̱, da-u̱ wa taase̱ no̱m-du̱ u̱t-him du̱gu̱ Yar-u u-he̱n u̱du̱ ne̱t-tu̱ wa dage̱ u̱ka a-to̱mu̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Da Ye̱so̱ yu̱ne̱ du̱gu̱ m-mar, wa ko̱ske̱ hi-u̱r wa u̱du̱ a-doru̱ wane̱ u̱zu̱ wa o̱ u̱r-fat. U̱t-Ho̱ u̱t-shik u̱t-yu̱r wa o̱ no̱mu̱ u̱t-ne̱t rem-su̱ Faru̱k-du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Da-u̱ wa o̱o̱ge̱ u-re̱ u̱ u̱n ne̱, wa zu̱ u̱n, <<A no̱ yagu̱ Urusharima da. No̱ e̱' este̱du̱ u̱s-rem su̱ u̱so u̱ ri no̱me̱ u̱ka u̱m wartu̱ no̱, ");
INSERT INTO gel_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohanna no̱nge̱ u̱t-ne̱t u̱t-yu̱bu̱sse̱ m-bu̱, za m-tumb na do̱'e̱ no̱mu̱ no̱ u̱t-yu̱bu̱sse̱ u̱ Yar-u u-Ru̱.>> ");
INSERT INTO gel_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","A-to̱mu̱ Ye̱so̱ mo̱ro̱g u̱r-be u̱r-gan e̱ no̱mu̱ wa u̱r-shu̱t, <<¿Wa-ko-uyan, yan da-o̱ bo̱ do̱'e̱ mu̱u̱tu̱n Isra-ne̱ u̱r-faru̱k u̱ kom-u̱t e̱, e̱ hure̱ du̱gu̱ faru̱k-tu̱ Roma-ne̱?>> ");
INSERT INTO gel_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ye̱so̱ zu̱ u̱n, <<Nap-mu̱ u-da u̱ ho̱-tu̱ u-go̱s ne̱ u-zwu̱u̱n ne̱, se̱se̱ su̱ no̱ se̱ da, u̱ka U̱so u̱ este̱ u̱ be̱b-u̱r wa.>> ");
INSERT INTO gel_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","No̱ do̱'e̱ kwu̱m-du̱ u̱r-be̱b da-u̱ Yar-u u-Ru̱ he̱e̱ne̱ u̱ do̱m-u̱ no̱. No̱ do̱'e̱ u̱t-shu̱'u̱t a-warru̱ rem-u̱s ri u̱ Urusharima m-ha u̱ dak-u̱ Yahudiya ne̱, u̱ dak-u̱ Samariya-ne̱, m-te̱ ma-du̱ u-dak. ");
INSERT INTO gel_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Da-u̱ wa taase̱ zu̱ iya, na ku̱b wu̱n m-da u̱ do̱m u-ru̱ u̱-me̱ u̱r-ku̱u̱t. U̱n o̱ te̱k-u̱ u̱t-gwat har u e̱nk u̱n m-hyan. ");
INSERT INTO gel_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","U̱n o̱ te̱k-u̱ sak-du̱ is u̱ aru̱k-u̱r rò u̱ do̱m u-ru̱, ku̱na ne̱t-ne̱ yu̱r rwu̱u̱tu̱n m-wa u̱ cwu̱-u̱t pus-to̱ ne̱ e̱ o̱ ees u̱ ke̱nu̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ku̱na e̱ zu̱te̱, <<No̱ campa-ne̱ Gariri, ¿remu̱ u-yan o̱ no̱ o̱tte̱ ees u̱ ana u̱ gwat-du̱ do̱m u-ru̱? Ye̱so̱ wu̱ na kabe̱ m-da u̱ do̱m u-ru̱, wa de̱ u̱t-mu̱u̱n u̱ka no̱ hyente̱ da-u̱r rò u̱ do̱m u-ru̱.>> ");
INSERT INTO gel_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","A-To̱mu̱ Ye̱so̱ baru̱m u̱ Urusharima du̱gu̱ Ro̱r-du̱ Te-su̱ Ze̱tun, ro̱r-du̱ o̱ dapu̱s Urusharima ra-mu̱ be-u̱r re̱ o̱ u̱ka ha-mu̱ u-kirometa u-gan. ");
INSERT INTO gel_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Da-u̱ e̱ cwaye̱ u̱-me̱ u-bo̱, e̱ du̱u̱s u̱ kur-u̱ do̱m u̱ be-du̱ e̱ o̱tte̱ roog. I o̱ u̱ku̱n, Biturus, u̱ Yohanna, u̱ Yakubu, u̱ Andarawus, u̱ Firibi, u̱ Tomas, u̱ Bataromi, u̱ Matiyu, u̱ Yakubu (wa'-u̱ Aru̱payes), u̱ Simo̱n (wu̱ na zu̱ye̱ wa shu̱b-du̱ u-dak), tu̱msu̱ u̱ Yahudas ne̱ (wa'-u̱ Yakubu). ");
INSERT INTO gel_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","U̱n be̱e̱t u̱n same̱ u̱t-hi u̱s-to̱o̱g u̱ no̱m u-gan, u̱r-koto u̱t-ne̱ta ne̱ u̱ Me̱ri ne̱ ino-u Ye̱so̱, u̱ hu̱no-u̱t rò ne̱. ");
INSERT INTO gel_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","U̱ ho̱-u̱t to̱ na o̱ mo̱ro̱g-du̱ a-dor-ne̱ ne̱t-tu̱ teeg u̱t-shik u̱t-shishin 120. Biturus yu̱ne̱ u̱r-ees, ");
INSERT INTO gel_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","wa zu̱, <<O̱r-u̱t ri ne̱, no̱mu̱ na pane̱ o̱ shu̱u̱g u̱ rem-su̱ u-Ru̱ su̱ Yar u-Ru̱ ware̱ m-tumb ne̱ u̱ nu-u Dawuda u̱ remu̱ Yahudas, wu̱ ko̱se̱ u̱ka na do̱te̱ masu̱ Ye̱so̱.>> ");
INSERT INTO gel_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Wa o̱gu̱ te̱k-u̱ me̱ in, tu̱msu̱ wa o̱tte̱ u̱r-o̱g u̱ te̱k-u̱ me̱ in. ");
INSERT INTO gel_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","U̱ to̱p-u̱ u̱ shik-u̱ pama-u̱s yo̱-se̱ Yahudas o̱ wa ote̱ u̱r-be, ku̱na wa he̱e̱tu̱n m-gwakka u̱r-hi, me̱n-tu̱ yo̱'o̱k, yaag-u̱ me̱n rwu̱u̱n u̱-do̱. ");
INSERT INTO gel_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kowan u̱ Urusharima ho̱k no̱mu̱ no̱me̱, har na te̱ge̱ be-u̱r re̱ u̱r-dim, <<Akardama>> wato u̱ rem-u̱r u̱n na zu̱, <<Be-du̱ m-Hyu̱.>> ");
INSERT INTO gel_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Biturus zu̱, <<Na panu̱g u̱ Se̱p-tu̱ u̱t-Vam u̱zu̱, << <Yage̱ be-du̱ u̱r-shu̱'u̱t rò u̱ shu̱'u̱t u̱r-kanda, Ana yage̱ waku̱n u̱ shu̱'u̱t u̱ku̱n da.> Tu̱msu̱, <Yage̱ waku̱n u̱ kab o̱g-u̱r rò.> ");
INSERT INTO gel_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Remu̱ iya in dagu̱n waku̱n u̱ te̱k-u̱ ne̱t-u̱t tun-to̱, wu̱ o̱ u̱r-kot u̱ in ne̱ ko-uyan da, u̱ da-u̱ Wa-ko-uyan Ye̱so̱ o̱o̱ge̱ u̱r-no̱k u̱ in ne̱. ");
INSERT INTO gel_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ne̱tu̱ wa shu̱'u̱t wu̱ hyane̱ da-u̱ Yohanna no̱mu̱ Ye̱so̱ u̱t-yu̱bu̱sse̱ m-bu̱ m-ha da-u̱ Ru̱-u̱ kabe̱ Ye̱so̱ m-da u̱ do̱m u-ru̱. Tu̱msu̱ wa shu̱'u̱t wu̱ o̱ u̱r-kot u̱ in ne̱ da-u̱ mar-m Ye̱so̱ u̱ yu̱ne̱-u̱r wa ne̱ du̱gu̱ m-mar.>> ");
INSERT INTO gel_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","U̱n haatu̱n ne̱t-ne̱ yu̱r: Yusuhu wu̱ na foge̱ Barsaba (tu̱msu̱ na zu̱ wa Justus), u̱ Matiyas ne̱. ");
INSERT INTO gel_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","A-doru̱ Ye̱so̱ no̱m u̱s-to̱o̱g u̱zu̱, <<Wa-ko-uyan bo̱ nak jab-u̱ kowan. Ko̱su̱ it wu̱ bo̱ dage̱ u̱ te̱k-u̱ ne̱t-ne̱ yu̱r-u̱ ine̱, ");
INSERT INTO gel_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","wa kab pama-u̱ Wa-to̱m-u̱ Ye̱so̱ u̱ Yahudas yage̱ wa do̱'e̱ u̱ be-du̱ wa dage̱.>> ");
INSERT INTO gel_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Se̱ e̱ gu̱n u-gwe̱mbi u̱ te̱k-u̱ me̱ u̱n, Matiyas re, wa shu̱'u̱t wa-to̱m-u̱ te̱k-u̱ me̱ a-To̱mu̱ Ye̱so̱ o̱p u-gan. ");
INSERT INTO gel_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Da-u̱ ho̱-du̱ Pe̱ntiko̱s tene̱, a-dor o̱ be̱e̱t u̱r-be u̱r-gan. ");
INSERT INTO gel_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Za m-nap na ho̱g dum-du̱ mya-mu̱ u̱r-be̱b u̱-do̱m u-ru̱ mo̱ shi kur-u̱ u̱n o̱tte̱ u̱-me̱. ");
INSERT INTO gel_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ku̱na u̱n hyente̱ u̱t-ne̱t u̱t-be̱e̱t tu̱ o̱ u̱ku̱n u̱ o̱ko̱n no̱m-o̱ ne̱ u̱ka rem-tu̱ u-ra hi-u̱r kowan. ");
INSERT INTO gel_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","U̱n be̱e̱t u̱n shu̱u̱g u-Yar u-Ru̱ ne̱ u̱n hu̱ u̱s-rem u̱ to̱ko̱n rem-to̱ ne̱ u̱t-go̱ u̱t-go̱, u̱ka Yar u-Ru̱ yu̱te̱ u̱n be̱b-du̱ u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","U̱ da-u o̱ e̱ke̱n o̱ro u̱ku̱n a-doru̱ fu̱n-yu̱ Yahuda-ne̱ i o̱ u̱r-shu̱'u̱t u̱ Urusharima e̱ haagu̱n du̱gu̱ be-tu̱ m-ra tu̱ dak-u o̱. ");
INSERT INTO gel_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Da-u̱ e̱ ho̱ge̱ u̱t-ne̱t u̱s-rem u̱ to̱ko̱n rem-to̱, se̱ mo̱ro̱g-du̱ u̱t-ne̱t karu̱g, e̱ hu̱ mu̱rimmo̱, remu̱ zu̱ u̱n ho̱k a-dor o̱ u̱s-rem u̱ rem-du̱ dak-u e̱. ");
INSERT INTO gel_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","U̱n hu̱ mu̱rimmo̱ so̱k, u̱n o̱ u̱t-zu̱, <<¿Ne̱t-u̱t tunto̱ a ne̱t-tu̱ Gariri to̱ da? ");
INSERT INTO gel_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Re̱ne̱ o̱ nomte̱ it o̱ ho̱g-du̱ u̱n u̱s-rem u̱ rem-u̱r it? ");
INSERT INTO gel_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","It hen ne̱t-tu̱: Dak-u̱ Fartiya to̱, u̱ Dak-u̱ Madiya ne̱, u̱ Dak-u̱ Erama ne̱, Tu̱msu̱ u̱ Dak-u̱ Me̱sofotamiya ne̱, u̱ Dak-u̱ Yahudiya, u̱ Dak-u̱ Kafadokiya ne̱, u̱ Dak-u̱ Fantus ne̱, u̱ Dak-u̱ Asiya-ne̱, u̱ ");
INSERT INTO gel_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Dak-u̱ Firijiya-ne̱, u̱ Dak-u̱ Famfiriya-ne̱, tu̱msu̱ u̱ Dak-u̱ Masar ne̱, u̱ Dak-u̱ Ribiya ne̱ dapu̱s bo̱-u̱ Sayirin, u̱ Ne̱t-tu̱ dak-u̱ Roma-ne̱ i haane̱ u̱t-riig ");
INSERT INTO gel_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","i na mate̱ Yahuda-ne̱ u̱ i-za-yahuda-ne̱ da i byu̱r-ne̱ e̱ dor fu̱n-u it. E̱ke̱n u̱ te̱k-u̱ me̱ it ne̱t-tu̱ dak-u̱ Kiritiya to̱, u̱ dak-u̱ Raraba ne̱. It o̱ ho̱g-du̱ u̱n u̱s-rem u̱ rem-u̱r it, it o̱ ho̱g-du̱ u̱n u̱ warru̱ no̱m-tu̱ m-shin tu̱ Ru̱-u̱ no̱me̱ u̱ rem-u̱r it!>> ");
INSERT INTO gel_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","No̱m-u̱ ho u̱n u̱ mu̱rimmo̱, u̱n o̱ shu̱t-du̱ hi-u̱t u̱n u̱zu̱, <<¿Yan-o̱ inya?>> ");
INSERT INTO gel_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","E̱ke̱n no̱mu̱ u̱n rem-su̱ u̱s-ju̱ru̱m u̱zu̱, <<Bu̱-mu̱ ke̱ mo̱ u̱n swaye̱.>> ");
INSERT INTO gel_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Biturus yu̱ne̱ u̱r-ees u̱r-kot u̱ a-To̱mu̱ Ye̱so̱ ne̱ o̱p u-gan, wa jaku̱s u-cwar wa zu̱, <<O̱r-u̱t ri Yahuda-ne̱ be̱e̱t i o̱ u̱r-yu̱ u̱ Urusharima, ho̱go̱n, tu̱msu̱ e̱re̱n u̱t-to̱ no̱ ho̱g no̱m-u̱ u̱m de̱ waru̱ no̱. ");
INSERT INTO gel_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ne̱t-u̱t tun-to̱ swaag ke̱' da, u̱ka no̱ o̱tte̱ m-hyan, wu̱ndu̱ o̱mo̱n uro ne̱. ");
INSERT INTO gel_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","No̱m-u̱ wa-warru̱ rem-su̱ u-Ru̱ Jowe̱r ware̱ o̱ u̱zu̱, ");
INSERT INTO gel_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","<< <Ru̱-u̱ zu̱: U̱ ho̱-tu̱ u̱r-vaste̱, u̱m de̱ to̱knu̱ Yar-u ri u̱du̱ u̱t-ne̱t. Yaag-u̱ no̱ campa-ne̱ u̱ yaagu̱ ne̱ta-ne̱ do̱'e̱ no̱m-du̱ bu̱t-tu̱ rem-u̱s ri, Yaagu̱ be̱b-ne̱ de̱ no̱m-du̱ u-hyan, Ne̱nge̱n-tu̱ de̱ no̱m-du̱ u̱s-bo'. ");
INSERT INTO gel_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","U̱t-nip u̱ da-u̱ o̱, u̱m de̱ haatu̱n Yar-u ri u̱du̱ to̱k-ne̱ ri campa-ne̱ u̱ ne̱ta-ne̱, E̱ do̱'e̱ no̱m-du̱ bu̱t-tu̱ u̱m waru̱ e̱. ");
INSERT INTO gel_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","U̱m de̱ ko̱su̱ no̱m-tu̱ m-shin u̱ do̱m-u̱ u-ru̱, u̱ no̱m-tu̱ m-shin ne̱ u-dak, wato m-hyu̱, u-ra ne̱, u̱ u̱t-fu̱'u̱t ne̱ tu̱ rim-to̱. ");
INSERT INTO gel_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","U̱m de̱ muut u̱r-ho̱ u-cwu̱m, pyaat-yu̱ de̱ u̱t-shu̱'u̱t u̱ka m-hyu̱, kanda ho̱-du̱ Yawe de̱ haan, ho̱-u̱r yat-de̱ du̱ m-sek. ");
INSERT INTO gel_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","U̱ da-u o̱ wu̱ no̱me̱ u̱s-to̱o̱g u̱ dim-u̱r Yawe wa do̱'e̱ kwu̱m-du̱ u-u̱ku̱r.> ");
INSERT INTO gel_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","<<O̱r-u̱t ri Isra-ne̱, ho̱go̱n rem-u̱s sin-se̱: Ye̱so̱ wa-Nazara wa Ru̱-u̱ yase̱ tu̱msu̱ wa ees. Ru̱-u̱ ko̱ske̱ tun-to̱ u̱t-be̱e̱t remu̱ no̱m-tu̱ m-shin tu̱ no̱me̱, u̱s-nap ne̱ su̱ wa no̱me̱ u̱-me̱ Ye̱so̱ u̱ te̱k-u̱ me̱ no̱, u̱ka no̱ nu̱pte̱ u̱r-zwar ne̱. ");
INSERT INTO gel_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Iya o̱ Ru̱-u̱ zo̱ngte̱ wa ya'aste̱ wa u̱du̱ no̱, tu̱msu̱ u̱ nap-du̱ u-Ru̱ de̱, no̱ tu̱rte̱ wa u-kan, no̱ ho wa u̱ se̱ge̱-du̱ ne̱t-u̱t yo̱-to̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wa swaag u̱r-ko̱b sok da-u̱ wa mare̱, se̱di Ru̱-u̱ u̱ku̱r wu̱n du̱gu̱ be̱b-du̱ m-mar, tu̱msu̱ wa yu̱ns wu̱n du̱gu̱ marimari-ne̱, remu̱ zu̱ za u̱t-no̱me̱ u̱ mar-mu̱ ship wu̱n da. ");
INSERT INTO gel_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Faru̱k Dawuda no̱mu̱g u̱s-rem u̱ wu̱n u̱zu̱, << <U̱m nak Yawe o̱ u̱r-kot u̱ me̱ ne̱ ko mu̱ne̱, wa o̱ u̱ daps kom u̱t-cwa ri, u̱m za ho̱g-du̱ u-gye̱r da. ");
INSERT INTO gel_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Remu̱ iya jab-u̱ ri o̱ u̱r-so̱, rem-u̱r ri o̱ fu̱-du̱ u̱t-se̱p tu̱ u̱r-so̱, war-u ri u̱t-shu̱'u̱t u̱ te̱k-u̱ wadu̱ jab. ");
INSERT INTO gel_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Remu̱ zu̱ wa za yagu̱ fat-u̱r ri u̱-me̱ u-sag da. Ko wa yage̱ Wa-u-he̱n wa zu̱m da. ");
INSERT INTO gel_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Bo̱ ko̱sku̱ me̱ fu̱n-yu̱ de̱ hu̱u̱tu̱ me̱ u̱du̱ u̱r-fat. Bo̱ de̱ wadu̱ me̱ u̱r-so̱ remu̱ zu̱, bo̱ o̱ u̱r-kot u̱ me̱ ne̱.> >> ");
INSERT INTO gel_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","<<O̱r-u̱t ri Isra-ne̱, me̱ keru̱ no̱mu̱ no̱ u̱s-rem za u-sakna u̱ mo̱ttu̱ u̱so-u̱ u̱so-u̱t in Dawuda. Dawuda maru̱g, na dok wa, sag-u wa o̱ u̱du̱ in har u̱ da-o̱. ");
INSERT INTO gel_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Wu̱n wa-warru̱ rem-su̱ u-Ru̱ wa, tu̱msu̱ wa nak u̱zu̱ Ru̱-u̱ este̱ u̱s-rem u̱s-to̱nd ne̱, u̱zu̱ wa de̱ wadu̱ waku̱n u̱r-faru̱k du̱gu̱ ko̱-u̱r rò, u̱ka wa wote̱ Dawuda u̱r-faru̱k. ");
INSERT INTO gel_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dawuda hyangu̱n iya, se̱ wa no̱m u̱s-rem u̱ mo̱ttu̱ yu̱ne̱-u̱r Ye̱so̱ Kiristi du̱gu̱ m-mar, u̱zu̱ wa za yagu̱ wu̱n u̱ me̱ u-sag da, tu̱msu̱ war-u rò za u̱t-zu̱m da. ");
INSERT INTO gel_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ru̱-u̱ yu̱nu̱ste̱ Ye̱so̱ du̱gu̱ m-mar, it be̱e̱t a-doru̱ wa kowan hyanu̱g tu̱msu̱ it o̱ u̱t-war. ");
INSERT INTO gel_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","<<Ru̱-u̱ yaag Ye̱so̱ m-sek u̱ kom u̱t-cwa u-Ru̱, tu̱msu̱ wa kabu̱g Yar-u u-Ru̱ du̱gu̱-du̱ u-U̱so, u̱ka wa este̱ u̱s-rem. U̱ da-o̱ hen, wa haatu̱n Yar-u o̱ u̱ do̱m-u̱ in jab gan. Wa haatu̱n no̱mu̱ no̱ hyane̱ tu̱msu̱ no̱ hog. ");
INSERT INTO gel_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dawuda tamu̱g da-du̱ u-ru̱ da, se̱di wa zu̱u̱g, << <Yawe zu̱u̱g Wa-ko-uyan u̱ ri: <<Shu̱'u̱te̱ u̱ kom-u̱ u̱t-cwa ri ");
INSERT INTO gel_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","U̱m te̱ da u̱m de̱ wa-du̱ hu̱u̱b-u̱t yo̱-to̱ ró u ta-u̱ u̱s-na ró.>> > ");
INSERT INTO gel_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","<<U̱ remu̱ iya yage̱ ne̱t-tu̱ Isra-ne̱ be̱e̱t e̱ nap sin-se̱, Ye̱so̱ u-ya yu̱ no̱ tare̱ u-kan Ru̱-u̱ mutte̱ wa Wa-ko-uyan tu̱msu̱ Kiristi.>> ");
INSERT INTO gel_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Da-u̱ ne̱t-tu̱ ho̱ge̱ iya, no̱m-u o̱ do u̱n jab sok, se̱ u̱n zu̱ Biturus u̱ a-To̱mu̱ Ye̱so̱ ne̱ i o̱ u̱ku̱n, <<O̱r-u̱t it, ¿yan-o̱ it de̱ u̱t-no̱m?>> ");
INSERT INTO gel_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Biturus zu̱, <<Yagu̱n u̱t-ba'as na no̱mu̱ no̱ u̱t-yu̱bu̱sse̱ m-bu̱, u̱ dim-u̱r Ye̱so̱ Kiristi remu̱ has-du̱ u̱t-ba'as. Tu̱msu̱ no̱ u̱t-kwu̱m nya-u̱ Yar-u u-Ru̱ du̱gu̱-du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Este̱du̱ u̱s-rem remu̱ no̱ o̱, u̱ yaagu̱ no̱ ne̱ be̱e̱t, u̱ e̱ke̱n ne̱ i za-Yahuda-ne̱ da, i Ru̱-u in Wa-ko-uyan bane̱ u̱ hi-u̱r wa.>> ");
INSERT INTO gel_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Biturus re shu̱ u̱ no̱mu̱ u̱n u̱t-bu̱t u-tát, tu̱msu̱ wa no̱mu̱ u̱n u̱t-him u̱zu̱, <<Ko̱no̱n u-Ru̱ taas wa nya no̱ u̱r-ko̱b da-u̱ wa haane̱ u̱ yadu̱ a no̱m-du̱ no̱m-u̱t yo̱-to̱ ne̱ u̱r-ko̱b i gu̱gme̱ Ye̱so̱.>> ");
INSERT INTO gel_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ne̱t-tu̱ kabe̱ bu̱t-tu̱ Biturus no̱me̱ na no̱ngu̱ e̱ u̱t-yu̱bu̱sse̱ m-bu̱. U̱ ho̱-u̱r re̱ ne̱t-tu̱ swu̱rne̱ u̱-me̱ a-doru̱ Ye̱so̱ u̱ remu̱ bu̱t-u̱t to̱ teeg ne̱t-ne̱ u̱t-zo̱ngu u̱t-tu̱t 3,000. ");
INSERT INTO gel_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","U̱n muut jab-u̱s u̱n u̱r-be u̱r-gan u̱ ko̱se̱-tu̱ a-To̱mu̱ Ye̱so̱ o̱tte̱ tu̱msu̱ u̱ same̱-du̱ u̱t-hi ne̱. U̱n re shu̱ u̱ re̱-du̱ no̱m u̱t-re̱ u̱r-pas u̱ Wa-ko-uyan tu̱msu̱ u̱s-to̱o̱g ne̱. ");
INSERT INTO gel_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ne̱t-tu̱ o̱ u̱ Urusharima e̱ hu̱ shu̱p-du̱ u̱t-nu remu̱ no̱m-tu̱ m-shin tu̱ a-To̱mu̱ Ye̱so̱ ne̱ o̱ u̱t-no̱m u̱t-go̱ u̱t-go̱. ");
INSERT INTO gel_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","I kabe̱ rem-u̱s se̱, e̱ same̱ hi-u̱t u̱n ne̱ tu̱msu̱ ko-uyan da u̱n mo̱ro̱g u̱r-be u̱r-gan. Tu̱msu̱ u̱n mot no̱m-tu̱ u̱n o̱tte̱ u-be̱e̱t u̱r-kot. ");
INSERT INTO gel_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","U̱n bu̱b no̱m-tu̱ u̱n o̱tte̱ na ye kowan u̱ka wa o̱tte̱ u̱ssa. ");
INSERT INTO gel_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ko mu̱ne̱ u̱n hu̱ m-ha u̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan. U̱n re no̱m u̱t-re̱ u̱ baksu̱n u̱n war-u Ye̱so̱ u̱ hyu̱-m wa ne̱ u̱r-kot u̱ bu-u̱t u̱n. U̱n o̱ u-re̱ u-swa ne̱ u̱ te̱k-u̱ u̱r-so̱ jab gan. ");
INSERT INTO gel_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","U̱ka u̱n zo̱ngte̱ u̱t-no̱m, u̱n o̱ vam-tu̱ Wa-ko-uyan. U̱n o̱tte̱ po̱ng-u̱r pus-de̱ u̱du̱ kowan u̱ me̱ Urusharima, da-u̱ no̱m-u̱t to̱ o̱ u̱t-no̱m, Ru̱-u̱ o̱ swu̱ru̱n u̱n ne̱t-tu̱ o̱ cwan-tu̱ u-u̱ku̱r du̱gu̱ baas-u̱t u̱n. ");
INSERT INTO gel_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","De̱ku̱n ho̱-de̱ Biturus e̱ Yohanna e̱ o̱ ha-mu̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan u̱ da-u̱ u̱s-to̱o̱g, u̱s-kwam u̱s-tu̱t su̱ u-ho̱. ");
INSERT INTO gel_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","U̱ is-yu̱ na foge̱ Is-u So̱-ya, waku̱n ne̱t-wa o̱ro ryam du̱gu̱ da-u̱ na mate̱ wa. Ko mu̱ne̱ na hatu̱n wa u̱ Is-yu̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan, remu̱ wa no̱m-u̱t u̱s-ko̱n su̱ shik u̱du̱ i o̱ u̱r-cwa u̱ me̱. ");
INSERT INTO gel_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Da-u̱ wa hyane̱ Biturus e̱ Yohanna u̱ mo̱ttu̱ cwa-du̱ kat-du̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan, se̱ wa kon u̱n shik. ");
INSERT INTO gel_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Biturus e̱ Yohanna hu̱ gwat-du̱ wu̱n, Biturus zu̱, <<Gwat it!>> ");
INSERT INTO gel_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Se̱ jab-u̱ ryam mu u̱du̱ u̱n, wa o̱ m-hyan u̱zu̱ e̱ ya wu̱n o̱ko̱n. ");
INSERT INTO gel_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Biturus zu̱, <<U̱m zatte̱ shik da, se̱di no̱m u̱m o̱tte̱ o̱ u̱m de̱ yadu̱ bo̱. U̱ te̱k-u̱ dim-u̱r Ye̱so̱ Kiristi wa-Nazara, yu̱ne̱ bo̱ no̱m m-ha!>> ");
INSERT INTO gel_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Se̱ Biturus ship kom u̱s-cwa rò, wa yu̱ns wu̱n. Za rem na-su̱ yu̱ne̱ m-kim u̱ is-tu̱ u̱s-na rò ne̱ se̱ nom u̱r-be̱b. ");
INSERT INTO gel_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Wa tu̱ mak wa yu̱ne̱ u̱r-ees, wa he̱e̱se̱ m-ha. Wa dor Biturus ne̱ m-cwa u̱-me̱ kat-du̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan, wa o̱ m-ha u̱s-mak ne̱, wa o̱ vam-du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","U̱t-ne̱t u̱t-be̱e̱t e̱ hyen wu̱n wa o̱ m-ha, u̱ vam-tu̱ u-Ru̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ne̱t-tu̱ nu̱p u̱zu̱ wu̱na shu̱'u̱te̱ u̱ Is-u So̱-ya yu̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan u̱s-ko̱n. E̱ hu̱ mu̱rimmo̱ remu̱ no̱m-u̱ no̱me̱ u̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Da-u̱ rya-mu̱ wa o̱o̱ge̱ m-shu̱p u̱ Biturus ne̱ e̱ Yohanna, ne̱t-tu̱ ku̱smu̱n m-so̱m e̱ haan u̱ de̱ku̱n be-de̱ du̱ na zu̱ye̱ u̱ pyu̱-u̱ Suremanu e̱ o̱ mu̱rimmo̱. ");
INSERT INTO gel_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Da-u̱ Biturus hyane̱ iya, se̱ wa no̱mu̱ ne̱t-ne̱ u̱s-rem wa zu̱, <<No̱ Isra-ne̱ ¿remu̱ yan-o̱ no̱ o̱tte̱ u̱ mu̱rimmo̱? ¿Remu̱ yan-o̱ no̱ o̱tte̱ madi-u̱r ite̱ se̱ bo̱ zu̱ be̱b-du̱ hi-du̱ war it de̱, ko na zu̱ wadu̱ jab-u̱ it de̱ u̱ dor u-Ru̱ de̱ wu̱te̱ campa-u inya m-ha? ");
INSERT INTO gel_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ru̱-u Ibrahi, u̱ Ishaku, u̱ Yakubu, Ru̱-u u̱so-tu̱ u̱so-u̱t in, wa ye' Ye̱so̱ m-sek. Wu̱na hen tu̱-shu̱ no̱ yaase̱, tu̱msu̱ no̱ gu̱gu̱m wa u̱ ke̱nu̱ Biratus, ko ba shu̱'u̱te̱ Biratus cwanu̱g wa rest wa. ");
INSERT INTO gel_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Se̱di no̱ gu̱gu̱m Wa-u-He̱n, wa jab-u̱ so̱-o̱, no̱ kon na yage̱ wa ho̱-du̱ u̱t-ne̱t, ");
INSERT INTO gel_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","No̱ ho wu̱ de̱ keru̱ yadu̱ ne̱t fat-du̱ za u̱r-ma. Tu̱msu̱ Ru̱-u̱ yu̱ns wu̱n du̱gu̱ m-mar, in hyanu̱g wu̱n da-u̱ wa yu̱ne̱ du̱gu̱ marimari-ne̱, tu̱msu̱ it o̱ waru̱ no̱ sin-se̱. ");
INSERT INTO gel_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","U̱ remu̱ yadu̱ jab m-shin ne̱ mu̱ Ye̱so̱, ne̱t unwa no̱ hyane̱ tu̱msu̱ no̱ nu̱p o̱ wa kumte̱ m-yar. Remu̱ zu̱ it yaag u̱t-nip u̱ Ye̱so̱ o̱ wa'e̱ ne̱t unwa o̱tte̱ m-yar. No̱ be̱e̱t hen no̱ hyanu̱g. ");
INSERT INTO gel_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","<<U̱ da-o̱ o̱r-u̱t ri, u̱m nak no̱mu̱ no̱ no̱mu̱ Ye̱so̱ u̱ tu̱-shu̱ no̱ ne̱, no̱ no̱mu̱g u̱ remu̱ zu̱ no̱ nak u̱zu̱ wu̱na o̱ Kiristi da. ");
INSERT INTO gel_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Se̱di u̱ remu̱ iya o̱ Ru̱-u̱ shu̱u̱ste̱ no̱m-u̱ wa ware̱ u̱ nu-tu̱ a-warru̱ rem-su̱ u-Ru̱ u̱zu̱, Ru̱-u̱ de̱ to̱mnu̱ Kiristi u remu̱ wa u̱ku̱rte̱ ne̱t-u̱t wa, tu̱msu̱ wa de̱ swadu̱ u̱r-ko̱b. ");
INSERT INTO gel_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Remu̱ iya yagu̱n u̱t-ba'as, no̱ byu̱ru̱n u̱du̱ u-Ru̱, remu̱ wa jaaste̱ ba'as-u̱t no̱. ");
INSERT INTO gel_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","A no̱ no̱me̱ iya, Wa-Ko̱-uyan de̱ mutu̱ jab-u̱s no̱ u̱ pose̱, Wa de̱ to̱mnu̱ Kiristi u̱du̱ no̱ tun du̱gu̱ u̱r-taku̱n, wato Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nip-to̱ Ye̱so̱ wa shu̱'u̱te̱ u̱ do̱m u-ru̱, har da-u̱ wa de̱ mutu̱ ko-uyan u̱ po-o̱, u̱ka Ru̱-u̱ zu̱tte̱ du̱gu̱ u̱r-taku̱n u̱ nu-tu̱ a-warru̱ rem-su̱ u-Ru̱ ne̱ i u-he̱n. ");
INSERT INTO gel_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mosa zu̱u̱g, <Yawe Ru̱-u no̱ de̱ to̱mtu̱n no̱ waku̱n wa-warru̱ rem-su̱ u-Ru̱ u̱ te̱k-u̱ me̱ no̱, u̱ka na tomtu̱ me̱. Ku̱mge̱ hen no̱ ho̱g no̱m-u̱ wa de̱ waru̱ no̱. ");
INSERT INTO gel_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","U̱t-shu̱'u̱t hen wu̱ gu̱gme̱ ho̱g-du̱ wa-warru̱ rem-su̱ u-Ru̱ wa, na de̱ rutu̱ wa te̱k-u̱ me̱ u̱t-ne̱t.> ");
INSERT INTO gel_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Iya o̱ hen te̱k-u̱ a-warru̱ rem-su̱ u-Ru̱ ne̱ be̱e̱t i no̱me̱ u̱s-rem, du̱gu̱ da-u Samaira u̱ haan u̱ i haane̱ u̱-dim, e̱ no̱ng u̱s-rem u̱ remu̱ ho̱-u̱t tun-to̱. ");
INSERT INTO gel_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Rem-su̱ u-Ru̱ su̱ a-warru̱ rem-su̱ u-Ru̱ ne̱ no̱me̱, remu̱ no̱ o̱ na nomte̱, tu̱msu̱ no̱ de̱ re̱-du̱ este̱du̱ u̱s-rem su̱ Ru̱-u̱ no̱me̱ u̱ u̱so-tu̱ u̱so-u̱t in ne̱, u̱ wa zu̱tte̱ Ibrahi, <U̱ me̱ ko̱-u̱r rò de̱ rem-tu̱ dak-u uno̱ u-be̱e̱t de̱ kwu̱m-du̱ kom-u̱ u-Ru̱.> ");
INSERT INTO gel_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Da-u̱ Ru̱-u̱ yu̱nse̱ to̱k-u̱ wa, wa tom wa u̱r-taku̱n m-ha du̱ no̱ u̱ wa wa-u̱ no̱ kom-u̱ so̱-o̱ u̱ wa muutu̱ no̱ u̱ yage̱-du̱ fu̱n-u̱s yo̱-se̱ no̱.>> ");
INSERT INTO gel_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","A-to̱o̱g u̱ yu̱-shu̱ a e'-du̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan ne̱ u̱ Saduki-ne̱ e̱ haan u̱du̱ Biturus u̱ Yohanna da-u̱ e̱ o̱o̱ge̱ u̱s-rem u̱t-ne̱t ne̱. ");
INSERT INTO gel_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","E̱ hog u̱s-ryab remu̱ zu̱ a-To̱mu̱ Ye̱so̱ o̱ iis-u̱ u̱t-ne̱t u̱zu̱, remu̱ shin-m Ye̱so̱ i mare̱ e̱ de̱ u̱r-yu̱ne̱ u̱r-fat u̱ka Ye̱so̱ yu̱nte̱. ");
INSERT INTO gel_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","U̱n maste̱ Biturus e̱ Yohanna, u̱n tage̱ e̱ m-ha gas-du̱ is remu̱ zu̱ rim-mu̱ torog u̱ da-u o̱. ");
INSERT INTO gel_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tu̱msu̱ u̱t-ne̱t u-tát e̱ hog re̱m-su̱ Biturus ne̱ ware̱ e̱ ku̱b tu̱msu̱ ne̱t-tu̱ kabe̱ e̱ teeg campa-ne̱ u̱t-zo̱ngu u̱t-tan 5,000. ");
INSERT INTO gel_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Da-u̱ is gase̱, a-shu̱ ne̱, u̱t-ne̱nge̱n ne̱, u̱ a-ko̱se̱-tu̱ u-bo̱r ne̱, e̱ mo̱ro̱g u̱ Urusharima. ");
INSERT INTO gel_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas yu̱ yat-ya a-to̱o̱g, wa o̱ u̱ku̱n, u̱ Kayafa, u̱ Yohanna, u̱ Are̱kzanda, u̱ to̱ko̱n ne̱t-to̱ ne̱ tu̱ o̱ bu-u̱ yu̱ yat-ya a-to̱o̱g-ne̱. ");
INSERT INTO gel_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","U̱n wu̱ na haatu̱n Biturus e̱ Yohanna. U̱n no̱mu̱ u̱n u̱r-shu̱t u̱zu̱, <<¿Be̱b-u̱r wande̱ tu̱msu̱ dim-u̱r wande̱ no̱ o̱tte̱ no̱m-du̱ no̱m-u̱t tun-to̱?>> ");
INSERT INTO gel_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Yar-u u-Ru̱ dor-u̱t Biturus, wa zu̱ u̱n, <<No̱ a-shu̱ u̱t-ne̱t ne̱, u̱ ne̱nge̱n-tu̱ Isra-ne̱, ");
INSERT INTO gel_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","¿u̱ ya-o̱ no̱ o̱ u̱r-shu̱t remu̱ se̱ge̱-du̱ rya-mu̱ wa kume̱? ¿Tu̱msu̱ no̱ u̱t-sa na nap wu̱ ya' wu̱n m-yar? ");
INSERT INTO gel_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","It u̱t-sa no̱ be̱e̱t u̱ ne̱t-tu̱ Isra-ne̱ u̱t-be̱e̱t no̱ nap u̱zu̱, u̱ te̱k-u̱ dim-u̱r Ye̱so̱ Kiristi wa-Nazara. Wu̱ no̱ tare̱ u-kan, Ru̱-u̱ yu̱ns wa du̱gu̱ m-mar. Ye̱so̱ yaag wu̱n m-yar u̱ da-o̱ hen no̱ hyanu̱g se̱. ");
INSERT INTO gel_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ye̱so̱ wa na nomte̱ u̱s-rem u̱-me̱ rem-su̱ u-Ru̱ u̱zu̱, << <Ta'ar-du̱ u̱r-tak du̱ u-ma du̱ a u-ma ne̱ gu̱gme̱, de̱ shu̱'u̱te̱ ta'ar-du̱ ze̱ge̱ u̱r-zwar.> ");
INSERT INTO gel_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ru̱-u̱ to̱mgu̱n in ne̱t gan kyak wu̱ de̱ u̱kru̱ in du̱gu̱ ba'as-u̱t in, tu̱msu̱ dim-du̱ zaar u̱-me̱ dak-u uno̱ du̱ ko̱re̱ kwu̱m-du̱ u-u̱ku̱r da se̱ dim-u̱r Ye̱so̱.>> ");
INSERT INTO gel_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tu̱-shu̱ hu̱ mu̱rimmo̱ remu̱ hyan-du̱ be̱b-du̱ jab-u̱ Biturus e̱ Yohanna. E̱ haan e̱ nu̱p u̱zu̱ Biturus u̱ Yohanna e̱ za te̱k-u̱ ne̱t-u̱t yat-to̱ da tu̱msu̱ e̱ no̱ng m-karu̱nte̱ da. Du̱gu̱ da-u̱ o̱ u̱n nu̱p u̱zu̱ u̱n o̱o̱g u̱r-kot u̱ Ye̱so̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Da-u̱ tu̱-shu̱ hyane̱ wu̱ kume̱ m-yar u̱ ees u̱du̱ Biturus u̱ Yohanna ne̱, e̱ kerge̱ zu̱-du̱ o̱ko̱n da. ");
INSERT INTO gel_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","E̱ nom u-shaura u̱ te̱k-u̱ me̱ u̱n u̱zu̱, Biturus ne̱ u̱ Yohanna e̱ yage̱ Mo̱ro̱g-du̱ u̱t-Ne̱nge̱n. ");
INSERT INTO gel_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","E̱ zu̱, <<¿Yan-o̱ in do̱'e̱ u̱t-no̱m u̱ ne̱t-u̱t tun-to̱ ne̱? Remu̱ zu̱ kowan u̱ Urusharima nak u̱zu̱ ne̱t-tu̱ hyanu̱g no̱m-tu̱ m-shin u̱du̱ ne̱t-u̱t tun-to̱, fu̱n zaar u̱ na do̱te̱ u̱t-zu̱, <Bise̱ da.> ");
INSERT INTO gel_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Se̱di it o̱ gye̱r-u̱ rem-u̱s sin-se̱ cwa ko he̱ne̱, se̱ na nak u̱n u̱t-to̱, a u̱n no̱mu̱ waku̱n u̱s-rem da, ko u̱n no̱m u̱t-ko̱se̱ u̱ dim-u̱r Ye̱so̱ da.>> ");
INSERT INTO gel_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Se̱ u̱n fagu̱n a-To̱m ne̱, u̱n nu̱k u̱n u̱t-to̱ u̱zu̱, a u̱n waru̱ waku̱n u̱s-rem, ko u̱n no̱m u̱t-ko̱se̱ u̱ dim-u̱r Ye̱so̱ da. ");
INSERT INTO gel_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Biturus e̱ Yohanna shu̱s e̱ zu̱ u̱n, <<¿No̱ o̱ m-hyan u̱zu̱ Ru̱-u̱ u̱t-sa it ho̱g rem-u̱s no̱ m-ze̱g su̱ wa? ");
INSERT INTO gel_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Remu̱ zu̱ it, it za keru̱ ho̱-du̱ u̱s-ram u̱ warru̱ no̱m-u̱ it ho̱ge̱ tu̱msu̱ it hyen da.>> ");
INSERT INTO gel_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tu̱-shu̱ u̱t-ne̱nge̱n sur m-nak u̱n u̱t-to̱ sok, da tase̱ u̱n rest u̱n. U̱n taag u̱ka u̱n do̱te̱ yadu̱ u̱n u̱r-ko̱b, remu̱ zu̱ u̱t-ne̱t u̱t-be̱e̱t to̱ o̱ no̱mu̱ u-Ru̱ m-sek remu̱ no̱mu̱ u̱ no̱me̱. ");
INSERT INTO gel_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ne̱t-u̱ wa wu̱ kume̱ m-yar mu̱ m-shin wa ze̱k u̱s-hak u̱t-shik u̱t-yu̱r 40. ");
INSERT INTO gel_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Da-u̱ na reste̱ Biturus e̱ Yohanna, se̱ e̱ do̱'e̱ u̱du̱ o̱r-u̱t u̱n, u̱n waru̱ u̱n no̱m-u̱ i-yate̱ a-To̱o̱g u̱ u̱t-ne̱nge̱n ne̱ waru̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","U̱n hen da-u̱ u̱n ho̱ge̱ iya, u̱n jaku̱s cwar-u̱s u̱n u̱du̱ u-Ru̱ jab gan u̱n zu̱, <<Wa Ko-uyan, Wu̱ no̱me̱ do̱m u-ru̱ u-dak ne̱, m-sa ne̱, u̱ no̱m-tu̱ o̱ me̱ to̱. ");
INSERT INTO gel_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Bo̱ no̱mu̱g u̱s-rem m-tumb ne̱ u̱ be̱b-du̱ Yar-u u-Ru̱ tu̱msu̱ remu̱ to̱k-u̱ ro, wato wu̱ mate̱ u̱so-u it Dawuda: << <¿Remu̱ yan-o̱ i za-yahuda-ne̱ da nomte̱ u̱s-ryab? ¿Remu̱ yan-o̱ tu̱msu̱ ne̱t-tu̱ nomte̱ dorog-su̱ m-zan? ");
INSERT INTO gel_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Farkina-ne̱ i u-dak yu̱ne̱ e̱ zo̱ng m-gag, tu̱msu̱ tu̱-shu̱ u̱t-ne̱t same̱ u̱r-hi u̱ u̱n ne̱, u̱n o̱ yu̱r yo̱-de̱ u̱ Yawe, u̱ Kiristi ne̱ wu̱ Ru̱-u̱ dage̱ wa-u-u̱ku̱r in.> ");
INSERT INTO gel_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Remu̱ u̱zu̱ nip-to̱, Here̱ Antipas u̱ Biratus samge̱ u̱t-hi u̱-me̱ bo̱-u uno̱ u̱ i za-yahuda-ne̱ da u̱ ne̱t-tu̱ Isra-ne̱. U̱n no̱ng zo̱ngu̱sse̱ remu̱ u̱n ho-u̱t Ye̱so̱, wu̱ bo̱ dage̱ u wa shu̱'u̱t to̱k-u u-he̱n ró. ");
INSERT INTO gel_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Remu̱ zu̱ bo̱ o̱ m-shin ne̱, ne̱t-u̱t to̱ no̱mu̱g no̱mu̱ bo̱ zu̱ e̱ no̱m. No̱mu̱ bo̱ zo̱nge̱ u̱t-no̱m m-tumb ne̱ o̱ de̱ u̱t-shu̱'u̱t. ");
INSERT INTO gel_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Wa-ko-uyan, ho̱g u̱ka u̱n o̱tte̱ rem-su̱ mo̱t-tu̱ yadu̱ it u̱r-ko̱b. Ya to̱k-ne̱ ro be̱b-du̱ jab du̱ warru̱ rem-u̱s ro za u-gye̱r. ");
INSERT INTO gel_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nabne̱ kom-u ró bo̱ hatu̱n m-yar u̱ no̱m-tu̱ wadu̱ ne̱t u̱ mu̱rimmo̱ u̱ no̱m-tu̱ m-shin ne̱, u̱ remu̱ dim-du̱ to̱k-u̱ ro Ye̱so̱, Wa-u-He̱n.>> ");
INSERT INTO gel_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Da-u̱ e̱ no̱me̱ u̱s-to̱o̱g, be-du̱ e̱ mo̱ro̱gte̱ ru̱mu̱s. Se̱ Yar-u u-Ru̱ dor-u̱t u̱n be̱e̱t u̱, u̱n hu̱ warru̱ rem-su̱ u-Ru̱ za u-gye̱r. ");
INSERT INTO gel_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mo̱ro̱g-du̱ a-dor e̱ o̱ jab gan, waku̱n zaar wu̱ de̱ u̱t-zu̱, <<No̱m-u ri ya>> da, se̱di u̱n mot no̱m-u̱ u̱n o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","U̱r-be̱b ne̱ so̱k, a-To̱mu̱ Ye̱so̱ wu̱r u̱ka yu̱ne̱-du̱ Wa-ko-uyan Ye̱so̱ du̱gu̱ marimari-ne̱. Kowan u̱ te̱k-u̱ me̱ u̱n kum kom-u̱ u-Ru̱, ");
INSERT INTO gel_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tu̱msu̱ waku̱n zaar wu̱ tage̱ u̱ o̱ko̱n no̱m-o̱ u̱ te̱k-u̱ me̱ u̱n da. E̱ke̱n a-dor-ne̱ i o̱tte̱ u̱t-tak ko̱ u̱t-bu, o̱ko̱n da-o̱ e̱ bu̱b to̱ko̱n no̱m-to̱. Tu̱msu̱ e̱ hatu̱n shik-u̱ no̱m-tu̱ e̱ babe̱. ");
INSERT INTO gel_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","U̱n haatu̱n shik u̱-shu̱ a-To̱mu̱ Ye̱so̱ ne̱, na ye' kowan u̱ka wa o̱tte̱ u̱ssa. ");
INSERT INTO gel_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Waku̱n o̱ro wu̱na zu̱ye̱ Yusuhu, wu̱ a-To̱mu̱ Ye̱so̱ te̱'e̱ u̱r-dim Baraba (wato, Wa'-u̱ wa shiriktin-mu̱ jab). Wa o̱ u̱ te̱k-u̱ me̱ ko̱-u̱r Re̱wi ne̱, tu̱msu̱ wa hagu̱n du̱gu̱ Gas-u̱ Sayifurus. ");
INSERT INTO gel_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Baraba bu̱b o̱ko̱n tak-o̱ u̱ wa, wa haatu̱n shik-u̱ ke̱nu̱ a-To̱mu̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tu̱msu̱ waku̱n ne̱t wa wu̱na zu̱ye̱ Hananiya u̱ ne̱ta wane̱ Safiratu, wa bu̱b o̱ko̱n tak-o̱ u̱ wa o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","U̱ nap-du̱ ne̱ta-ne̱, wa yase̱ u-u̱k u̱ me̱ shik tak-u̱ u̱n babe̱, wa hatu̱n u-u̱k u̱ ke̱nu̱ a-To̱mu̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ku̱na Biturus zu̱tte̱, <<Hananiya, re̱-o̱ bo̱ yakte̱ faru̱k-u̱ no̱m u̱s-te ze̱g-u̱t be̱b-du̱ jab-u̱ ró, bo̱ no̱mu̱ Yar-u u-Ru̱ u̱s-bi. Bo̱ yaske̱ e̱ke̱n shike̱ u̱-me̱ shik-u̱ tak-u bo̱ babe̱. Bo̱ no̱mu̱g u̱ka u̱zu̱ bo̱ hattu̱n it shik be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kanda bo̱ babu̱ ro o̱, ko ba bo̱ babe̱, bo̱ keru̱ no̱m-du̱ no̱mu̱ bo̱ cwane̱ u̱ shik-u̱ e̱. ¿Remu̱ yan-o̱ bo̱ wu̱te̱ sin-se̱ dorogse̱ u̱ jab-u̱ ro? Ne̱t wa bo̱ no̱me̱ u̱s-bi da, Ru̱-o̱ bo̱ no̱me̱.>> ");
INSERT INTO gel_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Da-u̱ Hananiya ho̱ge̱ iya, se̱ wa he̱'e̱ u-dak wa mu̱ru̱s. Ne̱t-tu̱ ho̱ge̱ u̱t-be̱e̱t hen, gye̱r-u̱ u-tát ship e̱. ");
INSERT INTO gel_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ya'agu̱ be̱b-ne̱ haan e̱ ho̱po̱s wu̱n u-kus, e̱ ku̱b wu̱n m-rwu̱, e̱ dok wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Da sure̱ m-wa'as u̱ka u̱s-kwam u̱s-tu̱t, ne̱ta Hananiya cwan, wa nak no̱mu̱ na no̱me̱ da. ");
INSERT INTO gel_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Biturus zu̱ wu̱n, <<¿Waru̱ me̱, taas-du̱ shik-de̱ ane̱ i no̱ bu̱bte̱ u-tak?>> Wa zu̱, <<U̱, tase̱ u̱ku̱n iya.>> ");
INSERT INTO gel_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Biturus zu̱ wu̱n, <<¿Remu̱ yan-o̱ no̱ gu̱gte̱ u-nu no̱ reg-u̱t Yar-u̱ Wa-ko-uyan? Gwat ba-tu̱ u̱s-na i jwake̱ campa ró. E̱ o̱ hen u̱ is, e̱ do̱'e̱ u̱ kab-du̱ bo̱ e̱ ruut.>> ");
INSERT INTO gel_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Za rem wa he̱'e̱ u-dak, wa mu̱ru̱s. Da-u̱ ya'agu̱ be̱b-ne̱ cwane̱, e̱ bit wa maru̱g, e̱ ku̱b wu̱n, e̱ ruut, e̱ dok wu̱n u̱ dapu̱s campa ro. ");
INSERT INTO gel_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Gye̱r-u̱ ship a-doru̱ Ye̱so̱ ne̱ be̱e̱t, u̱ ne̱t-ne̱ u̱t-be̱e̱t tu̱ ho̱ge̱ rem-u̱s sin-se̱. ");
INSERT INTO gel_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","A-To̱mu̱ Ye̱so̱ no̱mo̱g no̱m-tu̱ m-shin u-tát u̱ me̱ u̱t-ne̱t. Tu̱msu̱ a-dor-ne̱ be̱e̱t mo̱ro̱g u̱r-be u̱r-gan u̱ka e̱ vette̱ u̱ pyu̱ Suremanu, u̱-me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan. ");
INSERT INTO gel_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","U̱ te̱k-u̱ u̱t-ne̱t u̱t-be̱e̱t i te m-kab Ye̱so̱ da, e̱ o̱ ho̱g-du̱ gye̱r u̱r-cwa u̱du̱ a-dor, remu̱ zu̱ e̱ nak u̱zu̱ a e̱ no̱me̱ no̱m-u̱t yo̱-to̱ Ru̱-u̱ de̱ rwu̱tu̱n to̱ m-zu̱n tu̱msu̱ wa ya' u̱n u̱r-ko̱b. Ko ba shu̱'u̱te̱ iya ne̱t-tu̱ o̱ yadu̱ u̱n m-ze̱g. ");
INSERT INTO gel_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ko̱ ba shu̱'u̱te̱ iya, a-dor-ne̱ hu̱ m-swu̱r u-tát u̱du̱ Wa-ko̱-uyan campa-ne̱ u̱ ne̱ta-ne̱. ");
INSERT INTO gel_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","No̱m-tu̱ a-To̱m o̱ u̱t-no̱m, wa'ag u̱t-ne̱t u̱ rwu̱tu̱n a-ko̱b-du̱ m-yar ne̱ u̱ do̱m u̱s-fu̱n, na o̱ ru̱stu̱ e̱ do̱m u̱t-yu̱n u̱t-wu̱ndi ne̱ u̱ka o̱tte̱ a Biturus o̱ aru̱k wa tam u̱n ko ryu̱n-u wa o̱ tame̱ e̱ke̱n e̱ kum m-yar. ");
INSERT INTO gel_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","U̱t-Ne̱t u-tát e̱ hu̱ mo̱ro̱g du̱gu̱ bo̱-tu̱ o̱ dapu̱s Urusharima, e̱ o̱ hatu̱n a-ko̱b-du̱ m-yar ne̱, u̱ i no̱m u̱s-te o̱ yadu̱ u̱r-ko̱b ne̱, e̱ be̱e̱t e̱ kum m-yar. ");
INSERT INTO gel_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Se̱ yu̱ yat-ya a-to̱o̱g u̱ mo̱ro̱g-du̱ ne̱t-tu̱ Saduki-ne̱ i o̱ u̱r-kot u̱ wu̱n ne̱, e̱ nom u̱r-shu̱b u-tát remu̱ zu̱ ne̱t-tu̱ o̱ kab-du̱ no̱mu̱ a-To̱mu̱ Ye̱so̱ o̱ u̱t-war. ");
INSERT INTO gel_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","U̱n maas a-To̱mu̱ Ye̱so̱ u̱n tage̱ e̱, u̱ bu-u̱ m-to̱k u̱ ne̱t-ne̱ be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","U̱ te̱k-u̱ m-gyu̱p Wa-to̱m-u̱ Wa-ko-uyan rwu̱n wa upus u-is u̱ kur-u̱ m-to̱k. Wa rwu̱tu̱n u̱n, wa zu̱, ");
INSERT INTO gel_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","<<De̱'e̱n u̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan no̱ waru̱ ne̱t-ne̱ rem-su̱ u̱r-fat u̱ sin-se̱.>> ");
INSERT INTO gel_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Da-u̱ u̱n ho̱ge̱ iya, u̱n yu̱ne̱ u̱n to̱ u̱ me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan u̱r-wu̱n u̱r-wu̱n, u̱n hu̱ u̱t-ko̱se̱. Da-u̱ yu̱ yat-ya a-to̱o̱g u̱ ne̱t-tu̱ o̱ u̱r-kot u̱ wu̱n ne̱ mo̱rge̱, e̱ fog Mo̱ro̱g-du̱ u̱t-Ne̱nge̱n, u̱ tu̱-shu̱ ne̱ tu̱ Isra-ne̱, e̱ tom na hatu̱n a-To̱mu̱ Ye̱so̱ i na wa'e̱ bu-u̱ m-to̱k. ");
INSERT INTO gel_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Da-u̱ a-u̱r-e' teye̱ bu-u̱ m-to̱k, e̱ hyanu̱g a-to̱mu̱ Ye̱so̱ u-me̱ da. E̱ mu̱u̱n e̱ waru̱ u̱n, u̱zu̱, ");
INSERT INTO gel_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","<<It byu̱k-u̱t bu-u̱ m-to̱k u-go̱ri go̱ri, tu̱msu̱ a u̱r-e̱' e̱ o̱ is u-bu u̱r-e̱', se̱di da-u̱ it gwate̱ it hyanu̱g waku̱n u̱-me̱ da.>> ");
INSERT INTO gel_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Da-u̱ yu̱-shu̱ u̱ got-tu̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan u̱ yu̱-Yat-ya a-to̱o̱g-ne̱ ho̱ge̱ iya, no̱m-u̱ ho u̱n u̱ mu̱rimmo̱ sok, e̱ o̱ u̱s-dorog u̱zu̱ yan-o̱ de̱ u̱t-no̱m u̱-shu̱. ");
INSERT INTO gel_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Waku̱n haan wa zu̱ u̱n, <<Ho̱go̱n, ne̱t-u̱t to̱ tu̱ no̱ wa'e̱ u̱ bu-u̱ m-to̱k, e̱ u̱-me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan u̱ da-o̱, e̱ o̱ no̱mu̱ ne̱t-ne̱ u̱t-ko̱se̱!>> ");
INSERT INTO gel_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yu̱-shu̱ a-gwat-du̱ Bu-u u-Ru̱ yu̱ne̱ e̱ maas a-To̱mu̱ Ye̱so̱, se̱di za o̱kon gwu̱z-o̱, remu̱ zu̱ u̱n o̱ u-gye̱r taas u̱ ne̱t-tu̱ bong u̱n u̱t-ta'ar. ");
INSERT INTO gel_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Da-u̱ u̱n hatu̱n a-To̱mu̱ Ye̱so̱, u̱n egu̱sse̱ u̱n u̱ shu̱ Mo̱ro̱g-du̱ u̱t-Ne̱nge̱n remu̱ yu̱-Yat-ya a-to̱o̱g u̱ no̱m-tu̱ u̱n u̱r-shu̱t. ");
INSERT INTO gel_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Wa zu̱, <<It nak no̱ u̱t-to̱ u̱zu̱ a no̱ sur m-no̱m u̱t-ko̱se̱ u̱ te̱k-u̱ dim-u̱r Ye̱so̱ da. Se̱di no̱ re̱e̱g shu̱ u̱t-ko̱se̱, tu̱msu̱ kowan u̱ Urusharima wa nak u̱ ko̱se̱-u̱t no̱ ne̱, har no̱ u̱t-sa no̱ saku̱ it ra-u̱ ne̱t unwa u̱ hi-u̱r it.>> ");
INSERT INTO gel_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Se̱ Biturus u̱ a-To̱mu̱ Ye̱so̱ ne̱ shu̱s e̱ zu̱, <<Ka u̱t-no̱m zarra ze̱k u̱r-zwar it dor rem-su̱ u-Ru̱ m-ze̱g rem-su̱ ne̱t-ne̱! ");
INSERT INTO gel_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","No̱ ho wa tu̱msu̱ no̱ tu̱r wa u̱-do̱m u-kan. Se̱di Ru̱-u̱ u̱so-tu̱ u̱so-u̱t in, wa yu̱nse̱ Ye̱so̱ du̱gu̱ marimari-ne̱. ");
INSERT INTO gel_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Wu̱na Ru̱-u̱ sekmu̱sse̱ u̱ kom u̱s-cwa ro, wa shu̱'u̱t yu̱-Yat-ya tu̱msu̱ Wa-u-u̱ku̱r. Wa no̱ng iya remu̱ wa upuste̱ Isra-ne̱ fu̱n-yu̱ yage̱-du̱ u̱t-ba'as, tu̱msu̱ na no̱mu̱ u̱r-ho̱ du̱ ba'as-u̱t u̱n. ");
INSERT INTO gel_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","It waru̱ ne̱t-ne̱ no̱m-u̱t tun-to̱ tu̱ it nape̱ tu̱ kume̱ Ye̱so̱, tu̱msu̱ Yar-u u-Ru̱, u̱ Ru̱-u̱ to̱mtu̱n it a do̱rru̱ rem-u̱s wa, o̱ ko̱ske̱ u̱zu̱ no̱m-u̱t to̱ nip-to̱.>> ");
INSERT INTO gel_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Da-u̱ tu̱-shu̱ ho̱ge̱ iya, e̱ hog u̱s-ryab sok, har e̱ cwanu̱g e̱ ho̱ a-To̱mu̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Se̱ waku̱n wa Farisa-wa o̱ro wu̱na zu̱ye̱ Gamariye̱r. Wa o̱o̱ge̱ wa ko̱se̱-tu̱ u-bo̱r, tu̱msu̱ ne̱t-tu̱ ye wu̱n m-ze̱g sok. Wa yu̱ne̱ u̱-me̱ Mo̱ro̱g-du̱ u̱t-Ne̱nge̱n wa zu̱, a-u̱r-e' u̱zu̱ e̱ ruut ne̱t-u̱t tun-to̱ u̱-do̱ u-ro. ");
INSERT INTO gel_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Da-u̱ u̱n ruute̱ a-To̱mu̱ Ye̱so̱ u̱-do̱, se̱ Gamariye̱r zu̱ mo̱ro̱g-du̱ u̱t-ne̱t, <<O̱r-u̱t ri Isra-ne̱, gwatu̱n no̱m-u̱ no̱ u̱t-sa no̱ no̱mu̱ ne̱t-u̱t tun-to̱. ");
INSERT INTO gel_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","U̱ hak-su̱ dim, waku̱n rwu̱gu̱n na zu̱ wa Tudas, wa ku̱b hi-u̱r wa o̱ko̱n. Wa kwu̱mu̱g ne̱t-ne̱ u̱t-ko̱k u̱t-nas 400 i do̱ru̱ wa, se̱di karma-ne̱ ho̱o̱g wa, tu̱msu̱ na bu̱rgu̱sse̱ ne̱t-tu̱ o̱ u̱r-no̱k u̱ wa ne̱. U̱n kerge̱ hen no̱m-du̱ no̱m-u̱ u̱n zo̱nge̱ u̱t-no̱m da. ");
INSERT INTO gel_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","U̱ o̱ko̱n da-o̱ tu̱msu̱ waku̱n wu̱ na foge̱ Yahudas, ne̱t-u̱ Gariri wa. Da-u̱ na o̱o̱ge̱ u̱ ogor-tu̱ u̱t-ne̱t, wa wa'ag ne̱t-tu̱ dor wa, iya o̱ ko̱wa karma-ne̱ ho̱o̱g wa tu̱msu̱ e̱ bu̱rgu̱sse̱ ne̱t-u̱t wa. ");
INSERT INTO gel_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","<<U̱ da-o̱, u̱m o̱ waru̱ no̱ ruun u̱ fu̱n-yu̱ ne̱t-u̱t to̱, no̱ yagu̱n u̱n aru̱k. Abite̱ u̱zu̱ no̱m-u̱ u̱n o̱ u̱t-no̱m u̱ ne̱t o̱, o̱ de̱ u̱t-natu̱sse̱. ");
INSERT INTO gel_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Abite̱ u̱zu̱ pama-u̱ u-Ru̱ o̱, no̱ za keru̱ hosu̱ ne̱t-u̱t tun-to̱ da. No̱ u̱t-taas no̱ bit hi-u̱r no̱ m-gag u-Ru̱ ne̱.>> Ku̱na hen Mo̱ro̱g-du̱ u̱t-Ne̱nge̱n ku̱bte̱ rem-u̱s Gamariye̱r ");
INSERT INTO gel_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","U̱n fagu̱n a-To̱mu̱ Ye̱so̱ u-me̱, u̱n no̱mu̱ u̱n u̱s-ryap. Tu̱msu̱ u̱n nu̱k u̱n u̱t-to̱ u̱zu̱ a u̱n sur m-no̱m u̱t-ko̱se̱ u̱ dim-u̱r Ye̱so̱ da. Se̱ u̱n rest a-To̱m e̱ no̱k m-mu̱. ");
INSERT INTO gel_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","A-To̱mu̱ Ye̱so̱ yu̱ne̱ du̱gu̱ Mo̱ro̱g-du̱ u̱t-Ne̱nge̱n u̱ te̱k-u̱ u̱r-so̱, remu̱ zu̱ na hyang u̱n ko̱rge̱ swa-u̱ m-'e̱ remu̱ dim-u̱r Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tu̱msu̱ ko mu̱ne̱, u̱ me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan ko u̱t-bu, u̱n yakke̱ no̱mu̱ ne̱t-ne̱ u̱t-ko̱se̱ u̱ rem-su̱ m-re̱me̱r u̱zu̱, <<Ye̱so̱ wa o̱ Kiristi.>> ");
INSERT INTO gel_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","U̱ da-u̱ o̱ a-dor u-tát he̱e̱se̱ u̱t-swu̱ru̱n. E̱ke̱n rwu̱gu̱n du̱gu̱ to̱ko̱n dak-to̱, tu̱msu̱ rem-du̱ u̱t-Girik do̱'e̱ warge̱, se̱di e̱ke̱n i shu̱'u̱te̱ u̱ dak-u̱ Isra-ne̱ e̱ waru̱g rem-du̱ Yahuda-ne̱. I warge̱ rem-du̱ u̱t-Girik he̱e̱se̱ m-kwe̱ u̱ remu̱ Yahuda-ne̱ i warge̱ rem-du̱ Yahuda-ne̱. E̱ o̱ u̱t-zu̱, <<Da-u̱ a-dor i warge̱ rem-du̱ Yahuda-ne̱ o̱ mo̱t-du̱ no̱m u̱t-re̱ u̱ shik ne̱ u̱du̱ bomos-ne̱ ko mu̱ne̱, no̱ ye'et matu̱ u-mo̱t u̱du̱ bomos-ne̱ i warge̱ rem-du̱ u̱t-Girik da>>. ");
INSERT INTO gel_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Se̱ a-To̱mu̱ Ye̱so̱ o̱p u̱ yu̱r mo̱ro̱g, e̱ zu̱, <<Ku̱mge̱ na yage̱ warru̱ rem-su̱ u-Ru̱, na mu̱ u̱ mo̱ttu̱ no̱m-u̱t re da. ");
INSERT INTO gel_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Remu̱ iya o̱r-u̱t ri, no̱ dag ne̱t-ne̱ ta'er u̱ te̱k-u̱ me̱ no̱, i o̱tte̱ dim-u̱r so̱-de̱, tu̱msu̱ i Yar-u u-Ru̱ dorte̱, u̱s-ve̱r ne̱. It de̱ yasu̱ e̱ uno̱ pama-u o̱. ");
INSERT INTO gel_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","It hen it de̱ wadu̱ jab-u̱ no̱m-du̱ u̱s-to̱o̱g u̱ warru̱ rem-su̱ u-Ru̱ ne̱.>> ");
INSERT INTO gel_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ne̱t-ne̱ be̱e̱t hog zwar-ru̱ rem-u̱s se̱. Se̱ e̱ du̱g Istifanus. (Ne̱t wa wu̱ yadu̱ jab u̱du̱ u-Ru̱ sok tu̱msu̱ Yar-u u-Ru̱ o̱ dor-tu̱ wa). U̱n du̱g Firibus, u̱ Burokoras, u̱ Nikano, u̱ Timon, u̱ Barminas, u̱ Nikoras du̱gu̱ Antakiya (ne̱t-u̱ wa kabu̱g fu̱n-yu̱ Yahuda-ne̱, kanda wa ya' u̱t-nip u̱ Ye̱so̱). ");
INSERT INTO gel_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ne̱t-tu̱ haatu̱n a-To̱mu̱ Ye̱so̱ ne̱t-u̱t to̱ u̱t-ta'er. Na do̱ru̱ u̱n u̱t-kom u̱r-hi na no̱mu̱ e̱ u̱s-to̱o̱g. ");
INSERT INTO gel_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Rem-su̱ u-Ru̱ re shu̱ u̱r-cwa ko he̱ne̱. Tu̱msu̱ tat-u̱ a-doru̱ bo̱-u̱ Urusharima sur u-tát, a-to̱o̱g u-tát e̱ kum yadu̱ jab remu̱ rem-u̱s Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Istifanus o̱tte̱ yadu̱ jab u-tát u̱ be̱b-du̱ u-Yar ne̱, wa no̱ng u̱t-no̱m u-tát tu̱ m-shin u̱ me̱ u̱t-ne̱t. ");
INSERT INTO gel_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Se̱ to̱ko̱n ne̱t-to̱ zwaru̱n Istifanus. Ne̱t-tu̱ Yahuda-ne̱ to̱, i mo̱rge̱ ko-uyan da u̱ Kur-u̱ u̱t-Ko̱se̱ u̱ ne̱t-tu̱ foge̱ <<Kur-u̱ i kume̱ u̱r-rwu̱ du̱gu̱ m-to̱k.>> Ne̱t-u̱t to̱ rwu̱gu̱n du̱gu̱ bo̱-tu̱ Sayirin u̱ Are̱kzandariya tu̱msu̱ e̱ke̱n rwu̱gu̱n du̱gu̱ Gas-u̱ bo̱-tu̱ Kirikiya u̱ Asiya-ne̱. E̱ he̱e̱se̱ inan u̱ Istifanus ne̱. ");
INSERT INTO gel_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Se̱di u̱n kerge̱ u̱ inan u̱ wane̱ da, remu̱ zu̱ wa nom u̱s-rem u̱s-ve̱r ne̱, tu̱msu̱ Yar-u u-Ru̱ o̱ do̱m-u̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Se̱ e̱ ye' e̱ke̱n re̱ u̱r-swa remu̱ e̱ ke̱-tu̱ Istifanus u̱s-rem u̱zu̱, <<It ho̱k wu̱n warru̱ no̱m-u̱t yo̱-to̱ u̱ remu̱ wa-warru̱ rem-su̱ u-Ru̱ Mosa u̱ u-Ru̱ ne̱.>> ");
INSERT INTO gel_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Iya-o̱ u̱n yu̱nu̱ste̱ jab-su̱ u̱t-ne̱t, u̱ i-yate̱ ne̱ tu̱msu̱ u̱ a-ko̱se̱-tu̱ u-bo̱r ne̱. E̱ yu̱nne̱ wu̱n, e̱ maas wu̱n. E̱ hu̱u̱t wu̱n u̱-me̱ Mo̱ro̱g-du̱ u̱t-Ne̱nge̱n. ");
INSERT INTO gel_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Se̱ i shu̱ u̱t-ne̱t hatu̱n rem-su̱ u̱s-bi, har e̱ zu̱, <<Ne̱t-u̱ unwa ko mu̱ne̱ wa o̱ rem-su̱ m-zan u̱ mo̱ttu̱ be-u̱r rinde̱ du̱ u-he̱n tu̱msu̱ u̱ ko̱se̱-u̱t Mosa ne̱. ");
INSERT INTO gel_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","It ho̱k wu̱n u̱t-zu̱ Ye̱so̱ wu̱ Nazara de̱ ru̱-du̱ be-u̱r re̱, tu̱msu̱ wa bargu̱sse̱ u̱r-main du̱ wa-warru̱ rem-su̱ u-Ru̱ Mosa yak-su̱ in.>> ");
INSERT INTO gel_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","I o̱ shu̱'u̱t u̱ be-du̱ Mo̱ro̱g-du̱ u̱t-Ne̱nge̱n, e̱ saku̱ wu̱n u̱r-is, e̱ hyen shu̱-u ro baru̱mte̱ u̱ka wa-To̱m u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Yu̱-Yat-ya a-to̱o̱g-ne̱ shit Istifanus u̱zu̱, <<¿Rem-u̱s se̱ nip-to̱?>> ");
INSERT INTO gel_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Istifanus zu̱, <<O̱r-u̱t ri, ganu̱n u̱t-to̱ no̱ ho̱g me̱, u-Ru̱ wa ko-uyan ko̱ske̱ hi-u̱r wa u̱du̱ u̱so-u in Ibrahi da-u̱ wa o̱o̱ge̱ u̱ dak-u̱ Me̱sofotamiya kanda wa shu̱'u̱t u̱ Haran. ");
INSERT INTO gel_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ru̱-u̱ zu̱ wu̱n, <Yu̱ne̱ du̱gu̱ dak-u no̱, bo̱ yage̱ o̱r-u̱t ro, bo̱ do̱'e̱ u̱ dak-u̱ u̱m de̱ ko̱su̱ bo̱.> ");
INSERT INTO gel_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","<<Ibrahi yu̱ne̱ du̱gu̱ dak-u̱ Kardiya-ne̱ wa do̱'e̱ wa shu̱'u̱t u̱ Haran. <<Da-u̱ uso-u ro mare̱, Ru̱-u̱ hatu̱n wu̱n u̱ dak-u uno̱ u̱ no̱ o̱tte̱ u̱ da-o̱. ");
INSERT INTO gel_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ko ba shu̱'u̱te̱ iya Ru̱-u̱ yaag Ibrahi kwu̱m-tu̱ dak-u o̱ da ko cashi, se̱di wa este̱ u̱s-rem u̱zu̱, wa de̱ u̱t-wa u̱ dak-u o̱ shu̱'u̱t u̱ ro, wu̱n u̱ ko̱-u̱r ro ne̱, u̱ da-u o̱ hen Ibrahi zatte̱ wa' da. ");
INSERT INTO gel_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tu̱msu̱ Ru̱-u̱ zu̱ ko̱-u̱r Ibrahi de̱ cwadu̱ bo̱-u̱ e̱ nape̱ da, tu̱msu̱ ne̱t-tu̱ bo̱-u o̱ de̱ muutu̱ u̱n to̱k-ne̱, e̱ de̱ yadu̱ u̱n u̱r-ko̱b m-te u̱s-hak u̱t-ko̱k u̱t-nas. ");
INSERT INTO gel_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ru̱-u̱ zu̱, <U̱m de̱ yadu̱ ne̱t-tu̱ dak-u o̱ u̱r-ko̱b, tu̱msu̱ ko̱-u̱r Ibrahi e̱ u̱t-byu̱ru̱n e̱ no̱mu̱ me̱ u̱t-huuk u̱ be-u̱r rinde̱ du̱ u̱m nomte̱ este̱du̱ u̱s-rem u̱zu̱ me̱ u̱t-ya.> ");
INSERT INTO gel_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ru̱-u̱ ye' Ibrahi este̱du̱ u̱s-rem u̱zu̱, yadu̱ u̱r-campa u̱r-be̱e̱t u̱-me̱ bu-u wa, u̱ ko̱-u̱r ro ne̱ u̱r-be̱e̱t du̱ na mate̱ na no̱mu̱ de̱ u̱r-pe̱s. U̱t-ko̱se̱ u̱zu̱ u̱n be̱e̱t ne̱t-tu̱ u-Ru̱ to̱ tu̱msu̱ u̱nu̱ do̱rru̱ no̱m-u̱ wa ware̱ Ibrahi wa no̱m. De̱ wu̱te̱ da-u̱ Ibrahi mate̱ Ishaku wa no̱mu̱ wa u̱r-pe̱s da-u̱ Ishaku no̱me̱ m-roog u̱t-eer. Isyaku mu̱t Yakubu tu̱msu̱ wa no̱mu̱ wa u̱r-pe̱s. Tu̱msu̱ iya o̱ Yakubu mu̱t u̱so-tu̱ u̱so-u̱t in o̱p-u̱t yu̱r wa no̱mu̱ e̱ u̱r-pe̱s. ");
INSERT INTO gel_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","<<U̱so-tu̱ u̱so-u̱t in ba shu̱'u̱te̱ u̱zu̱ e̱ o̱ shu̱b-u̱r Yusuhu remu̱ zu̱ u̱so-u e̱ o̱ cwan-u̱t Yusuhu sok. Remu̱ iya e̱ bu̱b wu̱n u̱du̱ a serpa-ne̱, e̱ ku̱b Yusuhu m-ha Masar remu̱ wa no̱m-u̱t m-to̱k. Se̱di Ru̱-u̱ o̱ u̱r-kot u̱ wu̱n ne̱, ");
INSERT INTO gel_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Wa ruut wu̱n du̱gu̱ swadu̱ u̱r-ko̱b. Ru̱-u̱ muut wu̱n wa u̱s-ve̱r, tu̱msu̱ wa hyu̱-m pus-mo̱ u̱du̱ Faru̱k-u̱ Masar. Faru̱k wu̱ wu̱n u̱r-faru̱k u̱ dak-u̱ Masar u-be̱e̱t tu̱msu̱ wa yasu̱ Yusuhu gwat-du̱ no̱m-tu̱ bu-u̱t wa u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","<<De̱ku̱n ho̱-de̱ me̱r-su̱ he̱e̱n u̱-me̱ dak-tu̱ Masar u̱ Kan'ana-ne̱, ne̱t-tu̱ o̱ swadu̱ u̱r-ko̱b sok u̱ ko̱b-du̱ no̱m u̱t-re̱. ");
INSERT INTO gel_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Da-u̱ Yakubu ho̱ge̱ u̱zu̱ no̱m u̱t-re̱ o̱ro u̱ Masar, se̱ wa tom hu̱no̱-u̱t Yusuhu, wato u̱so-tu̱ u̱so-u̱t in m-ha u̱ dak-u̱ Masar, u̱ da-u o̱ u̱n he̱e̱se̱ m-ha. ");
INSERT INTO gel_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","U̱ ha-mu̱ u-yu̱ru̱mse̱ Yusuhu ko̱se̱ hir-u̱r wa u̱du̱ o̱r-u̱t wa ne̱, ne̱t-tu̱ waru̱ Faru̱k-u̱ Masar u̱zu̱ ne̱t-u̱t Yusuhu ne̱t-tu̱ Yahuda-ne̱ to̱. Tu̱msu̱ ne̱t-tu̱ haane̱ du̱gu̱ Kanan hu̱u̱b-tu̱ u̱r-matu̱ rò to̱. ");
INSERT INTO gel_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Se̱ Yusuhu tom u̱zu̱ u̱ uso-u rò Yakubu wa haan u̱ a-u-bu u̱n ne̱ be̱e̱t, u̱n be̱e̱t u̱n teeg ne̱t-ne̱ u̱t-shik u̱t-tu̱t u̱ o̱p-u̱ tan 75. ");
INSERT INTO gel_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakubu do̱'e̱ u̱ Masar, ku̱na wa mu̱rte̱, u̱ u̱so-tu̱ u̱so-u̱t in ne̱. ");
INSERT INTO gel_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Na kabu̱n u-u̱r Yakubu u̱ du̱ Yusuhu ne̱, na mu̱tu̱n u̱ She̱ke̱m, na dok Yakubu u̱ sag-u̱ Ibrahi o̱ye̱, tu̱msu̱ na dok Yusuhu u̱ be-du̱ Yakubu o̱ye̱ u̱ kom-tu̱ yaag-u̱ Hamo̱r u̱ku̱n u̱ She̱ke̱m. ");
INSERT INTO gel_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","<<Da da-u̱ shu̱su̱ este̱du̱ u̱s-rem su̱ Ru̱-u̱ no̱me̱ Ibrahi teene̱, ne̱t-tu̱ sur, e̱ nom u-tát sok u̱ dak-u̱ Masar. ");
INSERT INTO gel_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","U̱ da-u o̱ na nom faru̱k-u̱ powa u̱ Masar, wa nak Yusuhu da. ");
INSERT INTO gel_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Faru̱k-u̱ wa no̱ngu̱ ne̱t-u̱t it no̱m-u̱t yo̱-to̱ sok, wa wu̱ na ju̱ru̱g yaag i mat-u̱r pode̱, tas e̱ fat da. ");
INSERT INTO gel_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","<<U̱ da-u o na mate̱ Mosa, ya-u̱r so̱de̱ de̱ sok u̱du̱ u-Ru̱. Na wu̱ru̱g wa u̱ bu-u̱ uso-u wa u̱s-pyaat u̱s-tu̱t. ");
INSERT INTO gel_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Da-u̱ na rwu̱tu̱n wa du̱gu̱ u-bu na rest, wa'-u̱ Faru̱k-u̱ Masar yadu̱ u̱r-gwu̱p ku̱b wu̱n. Wa got wu̱n sok u̱ka wa'-u̱ ro. ");
INSERT INTO gel_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Se̱ a-u̱t-ko̱se̱ tu̱ Masar is-u̱ Mosa nap-mu̱ ne̱t-tu̱ Masar, tu̱msu̱ wu̱n ne̱t wa wu̱ o̱tte̱ be̱b-du̱ u̱s-rem, u̱ no̱mu̱ wa o̱ u̱t-no̱m ne̱ u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","<<Da-u̱ wa teye̱ u̱s-hak u̱t-shik u̱t-yu̱r, se̱ wa dorog u̱zu̱ wa do̱'e̱ wa hyan o̱r-u̱t wa Isra-ne̱. ");
INSERT INTO gel_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Da-u̱ wa hyane̱ ne̱t-u̱ dak-u̱ Masar wa o̱ m-dum u̱ ne̱t-u̱ Isra-ne̱ se̱ wa do̱'e̱ wa se̱gu̱ ne̱t-u̱ Isra-ne̱, se̱ wa gu̱p ne̱t-u̱ Masar har wa mu̱r. ");
INSERT INTO gel_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Wa kabu̱g u̱zu̱ o̱r-u̱t ro ne̱ e̱ u̱t-nap u̱zu̱ Ru̱-o̱ se̱gu̱ wu̱n remu̱ wa u̱ku̱r o̱r-u̱t wa Isra-ne̱ du̱gu̱ m-to̱k, se̱di e̱ nak da. ");
INSERT INTO gel_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Da-u̱ is gase̱, se̱ wa hyen e̱ke̱n Isra-ne̱ m-dum, wa haan u̱ wa mot u̱n. Wa zu̱ u̱n, <No̱ ne̱t-u̱t tun-to̱, no̱ hu̱no̱ to̱ no̱, ¿remu̱ u-yan o̱ no̱ o̱tte̱ yadu̱ o̱r-u̱t no̱ u̱r-ko̱b?> ");
INSERT INTO gel_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","<<Ne̱tu̱ o̱ ho̱n-su̱ o̱ru̱ wa, se̱ wa to̱k Mosa u̱-kit wa zu̱, <¿Wana wa'e̱ bo̱, u̱ bo̱ shu̱'u̱t yu̱-Yat-ya it, tu̱msu̱ wa kwu̱p-du̱ u̱s-rem? ");
INSERT INTO gel_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Bo̱ u̱t-sa bo̱ ho̱ me̱ u̱ka bo̱ hote̱ ne̱t-u̱ Masar gyu̱p?> ");
INSERT INTO gel_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Da-u̱ Mosa ho̱ge̱ iya, se̱ wa som wa do̱'e̱ u̱ dak-u̱ Midiyan remu̱ wa pu̱k-u̱t. Ku̱na wa mu̱tte̱ ya'ag-u̱ campa-ne̱ yu̱r. ");
INSERT INTO gel_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","<<Da-u̱ hak-su̱ u̱t-shik u̱t-yu̱r arke̱, wa-To̱m u-Ru̱ rwu̱u̱n u̱du̱ Mosa u̱-me̱ u̱r-do̱g u̱ te̱k-u̱ rem-du̱ u-ra u̱ de̱ku̱n cwu̱k-de̱, u̱ be-du̱ u̱r-gagu̱n du̱ m-hyu̱ru̱g u̱ dapu̱s Ro̱r-du̱ Sinai. ");
INSERT INTO gel_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Da-u̱ Mosa hyane̱ iya, no̱m-u̱ ho wa u̱ mu̱rimmo̱. Da-u̱ wa hikne̱ u̱t-mo̱r u̱ wa hyen-u̱t, se̱ wa hog cwar-u Yawe ya o̱ u̱t-zu̱, ");
INSERT INTO gel_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","<Me̱ wa u-Ru̱ u̱ u̱so-tu̱ u̱so-u̱t ro, Ru̱-u Ibrahi, u̱ Ishaku, u̱ Yakubu ne̱.> Ku̱na war-u Mosa he̱e̱ste̱ m-zap, wa hog gye̱r u̱t-gwat. ");
INSERT INTO gel_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","<<Yawe zu̱, <Far ka'at-u̱t ro, remu̱ be-du̱ bo̱ o̱tte̱ ees, be-du̱ u-he̱n de̱. ");
INSERT INTO gel_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","U̱m hyanu̱g ko̱b-du̱ na o̱ yadu̱ ne̱t-u̱t ri tu̱ o̱ Masar, u̱m ho̱k kan-u̱s u̱n tu̱msu̱ u̱m cu̱zgu̱n remu̱ u̱m ruut u̱n du̱gu̱ Masar, u̱ da-o̱ haane̱, u̱m do̱'e̱ to̱m-du̱ bo̱ m-mu̱ Masar.> ");
INSERT INTO gel_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","<<U̱zu̱ Mosa yu̱ u̱n gu̱gme̱, e̱ zu̱, <¿Wana wa bo̱, bo̱ shu̱'u̱t yu̱-Yat-ya it, tu̱msu̱ wa-kwu̱p-du̱ u̱s-rem?> Wu̱na Ru̱-u̱ to̱mne̱ wa shu̱'u̱t yu̱-Yat-ya tu̱msu̱ Wa-u-u̱ku̱r remu̱ se̱ge̱-du̱ wa-To̱m u-Ru̱ wu̱ rwu̱ne̱ u̱du̱ ro u̱-me̱ u̱r-ke̱ngi. ");
INSERT INTO gel_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Tu̱msu̱ wu̱na rwu̱tu̱n u̱n da-u̱ wa no̱me̱ no̱m-tu̱ m-shin tu̱msu̱ u̱s-nap ne̱ u̱ dak-u̱ Masar u̱ m-sa ne̱ yu̱ jaz-ya, tu̱msu̱ u̱-me̱ u̱r-do̱g u̱s-hak u̱t-shik u̱t-yu̱r. ");
INSERT INTO gel_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","<<Mosa zu̱ye̱ ne̱t-tu̱ Isra-ne̱, <Ru̱-u̱ de̱ to̱mnu̱ no̱ waku̱n wa-warru̱ rem-su̱ u-Ru̱ u̱ te̱k-u̱ me̱ no̱, u̱ka wa to̱mtu̱n me̱.> ");
INSERT INTO gel_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosa wa kargu̱sse̱ yaag-u̱ Isra-ne̱ u̱ me̱ u̱r-do̱g. Tu̱msu̱ wa shu̱'u̱t u̱ u̱so-tu̱ u̱so-u̱t in, da-u̱ wa-To̱m u-Ru̱ wu̱ no̱me̱ u̱s-rem u̱ wu̱n ne̱ u̱ do̱m-u̱ Ro̱r-du̱ Sinai. Tu̱msu̱ wu̱na kabne̱ rem-su̱ yadu̱ u̱r-fat du̱gu̱-du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","<<Se̱di u̱so-tu̱ u̱so-u̱t in gu̱gu̱m kabdu̱ rem-u̱s se̱, e̱ gu̱gu̱m rem-u̱s ro, e̱ ton e̱ mu u̱ dak-u̱ Masar. ");
INSERT INTO gel_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","E̱ zu̱ Haruna, <No̱mu̱ it m-gir, u̱ de̱ dor-tu̱ it remu̱ zu̱ Mosa rwu̱tu̱n it du̱gu̱ dak-u̱ Masar it nak no̱mu̱ kume̱ wu̱n da.> ");
INSERT INTO gel_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","U̱ da-u o̱ u̱n nom ryu̱n-u̱ yadu̱ u-na, e̱ no̱mu̱ yadu̱ u-na de̱ to̱o̱g, e̱ hu̱ u̱r-so̱ remu̱ no̱m-u̱ e̱ no̱me̱ u̱ hi-u̱r e̱. ");
INSERT INTO gel_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Remu̱ iya Ru̱-u̱ ju̱nu̱ u̱n wa yagu̱ u̱n, u̱n no̱mu̱ re̱ge̱r u̱t-huuk. Rem-u̱s sin-se̱ no̱ng ho̱n-ho̱n u̱ no̱mu̱ na pane̱ u̱ ran-u̱ a-warru̱ rem-su̱ u-Ru̱ u̱zu̱, << <No̱ ne̱t-tu̱ Isra, ¿me̱ wa no̱ pane̱ u̱t-bisa no̱ nom to̱o̱g m-te u̱s-hak u̱t-shik u̱t-yu̱r u̱ me̱ u̱r-do̱g? ");
INSERT INTO gel_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","U̱-me̱ be-du̱ m-gir du̱ More̱k de̱ no̱ o̱tte̱ u̱t-riig, u̱ re̱ge̱r ne̱ i m-gir i na foge̱ Rifan, wato gir-mu̱ no̱ no̱me̱ u̱ remu̱ no̱ hu̱u̱tu̱ no̱mu̱ e̱ u̱t-huuk. Me̱ hen u̱m de̱ to̱k-du̱ no̱ m-to̱k m-ra> u̱-shu̱ u̱ Babira. ");
INSERT INTO gel_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","<<Da-u̱ u̱so-tu̱ u̱so-u̱t in o̱o̱ge̱ u̱-me̱ u̱r-do̱g, e̱ no̱ngu̱ u-Ru̱ u̱t-huuk u-me̱ u̱r-rimpa du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan, u̱ ko̱se̱ u̱zu̱ wa o̱o̱g u̱r-kot u̱ u̱n ne̱. Go̱-du̱ be-u̱r re̱ de̱ Ru̱-u̱ zu̱ye̱ Mosa no̱m, tu̱msu̱ u̱n no̱mu̱g rimpa-u̱r re̱ u̱ka Ru̱-u̱ ko̱ste̱ Mosa u̱ do̱m u̱r-ro̱r. ");
INSERT INTO gel_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Rimpa-u̱r re̱ de̱ u̱so-tu̱ u̱so-u̱t in kabne̱ tu̱msu̱ e̱ hatu̱n u̱ dak-u uno̱. U̱ da-u Josuwa o̱o̱ge̱ dor-tu̱ u̱n e̱ haan u̱ dak-u uno̱. U̱ da-u̱ u̱n o̱nke̱ dak-u o̱ u̱ kom-tu̱ ne̱t-tu̱ yi'e̱ m-tumb ne̱ Ru̱-u̱ buz e̱. U̱r-rimpa du̱ shu̱u̱t du̱ Wa-ko̱-uyan re̱ o̱ u̱ku̱n m-te̱ da-u̱ Dawuda o̱ u̱r-faru̱k. ");
INSERT INTO gel_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawuda kwu̱ng hyu̱-m pus-mo̱ u̱du̱ u-Ru̱ wa nom u̱s-ko̱n u̱ remu̱ zu̱ wa no̱m-u̱t u-ma u̱ bu-u̱ Ru̱-u Yakubu du̱ m-mo̱mmo̱, ku̱na wu̱n u̱ ne̱t-tu̱ Isra-ne̱ be̱e̱t do̱te̱ no̱mu̱ u-Ru̱ u̱t-huuk. ");
INSERT INTO gel_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Suremanu wa maye̱ be-du̱ ne̱t-tu̱ do̱te̱ no̱mu̱ u-Ru̱ u̱t-huuk. ");
INSERT INTO gel_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","<<Ko ba shu̱'u̱te̱ iya, Wa Ko-uyan shu̱'u̱te̱ u̱ be-du̱ ne̱t maye̱ u̱ kom-u̱t wa da. U̱ka wa-warru̱ rem-su̱ u-Ru̱ zu̱tte̱, ");
INSERT INTO gel_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","<< <Yawe zu̱, do̱m u-ru̱ o̱ be-du̱ u̱r-shu̱'u̱t-u̱ ri, u-dak be-du̱ jang-u̱t ri. ¿Yan go̱-du̱ u-bu o̱ no̱ de̱ ma-u̱ me̱? ¿Yan go̱-du̱ u̱r-be de̱ o̱ be-du̱ u̱r-hure̱ ri? ");
INSERT INTO gel_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Me̱ wa no̱me̱ no̱m-u̱t tun-to̱ u̱t-be̱e̱t da?> ");
INSERT INTO gel_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","<<No̱ a hu̱k-mu̱ u̱r-hi, a jab-su̱ u̱t-ta'ar, a to̱-tu̱ u̱t-shar, ko mu̱ne̱ no̱ dor-u̱t rem-su̱ Yar-u u-Ru̱ da. U̱so-tu̱ u̱so-u̱t gu̱gu̱mte̱ do̱rru̱ no̱m-u̱ Yar-u̱ u-Ru̱ ware̱ tu̱msu̱ iya o̱ no̱ o̱tte̱ u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","U̱so-tu̱ u̱so-u̱t no̱ yaag a-warru̱ rem-su̱ u-Ru̱ ne̱ u-tát u̱r-ko̱b, tu̱msu̱ e̱ ho i no̱me̱ do̱nse̱-du̱ haan-u̱r Wa-u-He̱n u-Ru̱. No̱ tok wu̱n u̱ kom-tu̱ ne̱t-u̱t yo̱-to̱ tu̱msu̱ no̱ ho wa. ");
INSERT INTO gel_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","No̱ o̱nke̱ u̱s-bo̱r u̱du̱ wa-To̱m u-Ru̱, se̱di no̱ dorogse̱ da.>> ");
INSERT INTO gel_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Da-u̱ u̱n ho̱ge̱ iya, e̱ hog u̱s-ryab sok, e̱ epru̱ u̱t-go̱p remu̱ u̱s-ryab. ");
INSERT INTO gel_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Yar-u u-Ru̱ dor-u̱t Istifanus, wa wu̱ is u̱ do̱m u-ru̱ se̱ wa hyen sek-mu̱ u-Ru̱, tu̱msu̱ wa hyen Ye̱so̱ u̱ ees u̱ kom u̱t-cwa u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Istifanus zu̱, <<Gwatu̱n! U̱m o̱ hyan-du̱ do̱m u-ru̱ u̱r-hu̱k tu̱msu̱ <Wa'-u̱ Ne̱t> o̱ ees u̱ kom u̱t-cwa u-Ru̱.>> ");
INSERT INTO gel_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Se̱ u̱n he̱e̱se̱ u̱t-jar u-tát, u̱n tage̱ to̱-u̱t u̱n, u̱n he wu̱n u-da u-gan. ");
INSERT INTO gel_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","U̱n tok wu̱n m-rwu̱ u̱-dim u-bo̱, u̱n hu̱ bongu̱ wu̱n u̱t-ta'ar. Ne̱t-tu̱ o̱o̱ge̱ ke̱-tu̱ wu̱n u̱s-rem, e̱ horom to̱ggo̱-u̱s yat-se̱ su̱ do̱m u̱ka e̱ do̱te̱ keru̱ bongu̱ wu̱n u̱t-ta'ar, e̱ hu̱u̱t cwu̱-u̱t e̱ u̱r-cu̱n u̱du̱ o̱ko̱n zwar-o̱ wu̱ na zu̱ye̱ Shawuru. ");
INSERT INTO gel_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","E̱ bongu̱ Istifanus, wa hen se̱ wa nom u̱s-to̱o̱g wa zu̱, <<Wa-ko-uyan Ye̱so̱, kab fat-u̱r ri.>> ");
INSERT INTO gel_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Se̱ wa he u̱t-jwu̱n, wa jaku̱s u-cwar wa zu̱, <<Wa-ko-uyan a-bo̱ ship ba'as-u̱t u̱n da.>> Da-u̱ u̱t-war iya, se̱ wa mu̱ru̱s. ");
INSERT INTO gel_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Shawuru o̱ u̱ku̱n, tu̱msu̱ wa yaag u̱r-be̱b u̱zu̱ na ho̱ Istifanus. U̱ te̱k-u̱ ho̱-u̱r re̱, o̱ko̱n gwu̱z-o̱ yu̱ne̱ za rem u̱ te̱k-u̱ a-doru̱ Urusharima. Na bu̱rgu̱sse̱ o̱ u̱ gas-u̱ Yahudiya u̱ Samariya-ne̱, a-To̱mu̱ Ye̱so̱ e̱ kuse̱ u̱ war'e̱ u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","E̱ke̱n a-dor u-Ru̱ ne̱ haan e̱ dok Istifanus. E̱ kanu̱g sok remu̱ Istifanus. ");
INSERT INTO gel_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Se̱ Shawuru re shu̱ u̱ yadu̱ a-doru̱ Ye̱so̱ u̱r-ko̱b sok. Wa o̱ cwaag u̱t-bu wa o̱ naknu̱ campa-ne̱ u̱ ne̱ta-ne̱ u̱ tagu̱ e̱, u̱ me̱ kur-u̱ m-to̱k. ");
INSERT INTO gel_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ne̱t-tu̱ na bu̱rgu̱sse̱, hu̱ u̱t-riig u̱ bu̱t-tu̱ Rem-su̱ m-Re̱me̱r su̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Firibus hu̱ u̱ bo̱-o̱ Samariya u̱ waru̱ ne̱t-ne̱ u̱zu̱ Ye̱so̱ wa o̱ Kiristi. ");
INSERT INTO gel_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Da-u̱ ne̱t-tu̱ ho̱ge̱, tu̱msu̱ e̱ hyen no̱m-tu̱ m-shin tu̱ Firibus o̱ u̱t-no̱m, e̱ muut jab-u̱s e̱ u̱r-be u̱r-gan u̱ no̱m-u̱ na o̱ u̱t-war ne̱. ");
INSERT INTO gel_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","No̱m u̱s-te he̱e̱se̱ u̱t-jar, e̱ hu̱ m-so̱m du̱gu̱ war-tu̱ u̱t-ne̱t u-tát, tu̱msu̱ na ye u̱t-ne̱t u-tát i o̱tte̱ go̱m-su̱ swa-u̱ ne̱t u̱t-be m-yar, u̱ a-za-u̱s-na ne̱. ");
INSERT INTO gel_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","U̱ remu̱ iya na nom u̱r-so̱ sok u̱ bo̱-u o̱. ");
INSERT INTO gel_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Waku̱n ne̱t wa o̱ro wu̱na zu̱ye̱ Simo̱n, wu̱ nome̱ u-gwat u̱ bo̱-u o̱. Tu̱msu̱ wa ho Samariya-ne̱ u̱ mu̱rimmo̱ sok, wa ku̱b hi-u̱r wa u̱ka ne̱t-u̱ yat-wa. ");
INSERT INTO gel_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ne̱t-tu̱ o̱ u̱ku̱n be̱e̱t a-u̱t-kwu̱m ne̱ u̱ a-za-u̱t-kwu̱m ne̱, byu̱ru̱n u̱du̱ wu̱n. E̱ o̱ u̱t-zu̱, <<Ne̱t unwa o̱tte̱ be̱b-du̱ u-Ru̱, tu̱msu̱ Ru̱-u̱ wa'ag wa, wa shu̱'u̱t ne̱tu̱ yat-wa.>> ");
INSERT INTO gel_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","U̱n muut jab-u̱s u̱n u̱du̱ ro sok, remu̱ zu̱ wa tumbte̱ wa o̱ no̱m-du̱ no̱m-tu̱ m-shin u̱ be̱b-du̱ m-bo̱n. ");
INSERT INTO gel_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Se̱di da-u̱ u̱n ya u̱t-nip u̱ Firibus wa bu̱t-tu̱ Rem-su̱ m-Re̱me̱r su̱ faru̱k-du̱ u-Ru̱ u̱ dim-u̱r Ye̱so̱ Kiristi ne̱, na no̱mu̱ u̱n u̱t-yu̱bu̱sse̱ m-bu̱, u̱ dame̱ campa-ne̱ u̱t-ne̱ta ne̱. ");
INSERT INTO gel_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simo̱n yu̱' jab ko̱wa, da-u̱ na no̱mu̱ wa u̱t-yu̱bu̱sse̱ m-bu̱ se̱ wa du̱p Firibus u̱r-shu̱'u̱t. Da-u̱ wa hyane̱ no̱m-tu̱ m-shin u̱s-nap ne̱ tu̱ na no̱me̱, se̱ wa hu̱ mu̱rimmo̱. ");
INSERT INTO gel_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Da-u̱ a-To̱mu̱ Ye̱so̱ i o̱ u̱ Urusharima ho̱ge̱ u̱zu̱ Samariya-ne̱ kabu̱g rem-su̱ u-Ru̱, se̱ e̱ tok Biturus e̱ Yohanna u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Da-u̱ Biturus e̱ Yohanna do̱'e̱ u̱ku̱n, u̱n no̱mu̱ u̱n u̱s-to̱o̱g, remu̱ e̱ kum-u̱t Yar-u u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Biturus e̱ Yohanna nu̱p remu̱ zu̱ Yar-u teegu̱ haan u̱du̱ u̱n da, se̱di na no̱mgu̱ u̱n u̱t-yu̱bu̱sse̱ m-bu̱ u̱ dim-du̱ Wa-ko-uyan Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Biturus e̱ Yohanna do̱ru̱ u̱n u-kom e̱ wa'-u̱ u̱n nu-u so̱-o̱, e̱ kum-u̱t Yar-u u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Da-u̱ Simo̱n hyane̱ u̱zu̱ Ru̱-u̱ yaag be̱b-du̱ Yar-u wa u̱du̱ u̱t-ne̱t, da-u̱ a-To̱mu̱ Ye̱so̱ do̱ru̱ u̱t-ne̱t u̱t-kom. Se̱ wa nabu̱ a-To̱mu̱ Ye̱so̱ shik. ");
INSERT INTO gel_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Wa zu̱, <<Na ya' me̱ ko̱me̱ be̱b-u̱r re̱, remu̱ zu̱ ko̱wana u̱m do̱re̱ u-kom se̱ wa kum Yar-u u-Ru̱.>> ");
INSERT INTO gel_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Biturus zu̱ wu̱n, <<Bo̱ u̱ shik-u̱ ro ne̱, ¿no̱ do̱r m-zan, bo̱ o̱ m-hyan u̱zu̱ u̱ shike̱ bo̱ do̱te̱ kwu̱m-du̱ ya' u-Ru̱? ");
INSERT INTO gel_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ru̱-u̱ wa'ag bo̱ u̱ no̱m-du̱ o̱ko̱n u̱r-kot u̱ it ne̱ u̱ pama-u̱ it o̱ u̱t-no̱m ne̱ da. Remu̱ zu̱ Ru̱-u̱ nak u̱zu̱ dorog-u̱s ro za u̱ so̱-se̱ da. ");
INSERT INTO gel_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Se̱ bo̱ byu̱ru̱n bo̱ yage̱ no̱m-du̱ no̱m-u̱t yo̱-to̱ tun-to̱, bo̱ ko̱n u-Ru̱ wa has-tu̱ bo̱ no̱m-tu̱ bo̱ zo̱nge̱ u̱t-no̱m u̱ jab-u̱ ro. ");
INSERT INTO gel_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","U̱m zu̱u̱g iya remu̱ zu̱ u̱m hyang bo̱ o̱ u̱r-shu̱b ne̱ sok, tu̱msu̱ bo̱ o̱ m-wa u̱-me̱ u̱t-ba'as.>> ");
INSERT INTO gel_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Se̱ Simo̱n zu̱, <<Ko̱no̱n me̱ Wa-Ko-uyan, taas no̱m-tu̱ no̱ ware̱ u̱t-be̱e̱t to̱ kum me̱ da.>> ");
INSERT INTO gel_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Da-u̱ Biturus e̱ Yohanna ware̱ u̱t-ne̱t no̱mu̱ e̱ nape̱ u̱ hi-u̱r e̱ u̱ mo̱t-u̱t Wa-ko-uyan Ye̱so̱ tu̱msu̱ e̱ nom do̱nse̱-du̱ rem-u̱s Ye̱so̱. Da-u̱ e̱ o̱o̱ge̱ u̱ fu̱n-yu̱ u̱r-mu̱ u̱ Urusharima e̱ hu̱ warru̱ Rem-su̱ m-Re̱me̱r u̱ taas-tu̱ Samariya. ");
INSERT INTO gel_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Wa-To̱m u-Ru̱ zu̱ Firibus, <<Yu̱ne̱ bo̱ do̱r m-ereg, bo̱ do̱r fu̱n-yu̱ rwu̱ne̱ du̱gu̱ Urusharima m-ha u̱ Gaza>> wato fu̱n-yu̱ u̱r-do̱g. ");
INSERT INTO gel_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Se̱ wa yu̱ne̱ wa do̱'e̱. Ku̱na wa bitte̱ waku̱n ne̱t-u̱ dak-u̱ Itiyofiya tu̱msu̱ man. Wa o̱tte̱ o̱g-u̱r yat-de̱ u̱ faru̱k-u̱r Kandis u-Re̱n yu̱ Itiyofiya, wu̱na wa u̱r-cu̱n u-re̱n. Wa hagu̱n u̱ Urusharima remu̱ wa no̱m-u̱t u̱t-huuk. ");
INSERT INTO gel_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Da-u̱ wa o̱o̱ge̱ u̱ te̱k-u̱ u̱r-no̱k m-mu̱ u-bu u̱ shu̱'u̱t u̱ do̱m-u̱ ke̱ke̱-yu̱ jwaak, se̱ wa u-pus ran-u̱ wa-warru̱ rem-su̱ u-Ru̱ Ishaya wa hu̱ u̱t-karu̱nte̱. ");
INSERT INTO gel_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Se̱ Yar-u u-Ru̱ zu̱ Firibus, <<Dapu̱rse̱ be-du̱ ke̱ke̱-yu̱ jwaak-u ya.>> ");
INSERT INTO gel_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Se̱ Firibus nom m-so̱m wa do̱'e̱ u̱du̱ ro, wa hog wu̱n u̱ karu̱nte̱ ran-u̱ wa-warru̱ rem-su̱ u-Ru̱ Ishaya. Se̱ Firibus shit wu̱n u̱zu̱, <<¿Bo̱ nak no̱m-u̱ bo̱ u̱t-karu̱nte̱?>> ");
INSERT INTO gel_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Se̱ wa shu̱s wa zu̱, <<A'o, se̱ waku̱n ko̱sku̱ me̱.>> Se̱ wa zu̱ Firibus, <<Daane̱ u̱ do̱m-u̱ Ke̱ke̱-yu̱ u-jwaak yo shu̱'u̱t.>> ");
INSERT INTO gel_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","U̱ te̱k-u̱ no̱m-u̱ wa o̱ u̱t-karu̱nte̱ o̱ u̱t-zu̱, <<Na nak wu̱n u̱ka u-ca m-ha u̱du̱ u̱t-ho̱, u̱ka kag-u̱ u-ca hote̱ u̱s-ram u̱du̱ a wa o̱r-ru̱ wa, iya o̱ hen wa hak nu-u̱ u̱s-rem da. ");
INSERT INTO gel_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ne̱t-tu̱ no̱ngu̱ wu̱n no̱m-u̱t yo̱-to̱, tu̱msu̱ e̱ yaag wu̱n u-mo̱t da. Waku̱n zaar wu̱ de̱ keru̱ warru̱ u̱ka ko̱-u̱r ró da, Remu̱ zu̱ na kabu̱g fat-u̱r wa du̱gu̱ u-dak.>> ");
INSERT INTO gel_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Se̱ manu̱ wa shit Firibus, <<¿Wa-warru̱ rem-su̱ u-Ru̱ wana wa o̱tte̱ u̱s-rem? ¿Rem-su̱ hi-u̱r wa se̱ wa o̱tte̱ ko waku̱n?>> ");
INSERT INTO gel_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Se̱ Firibus he̱e̱se̱ yadu̱ wu̱n m-zu̱n u̱-me̱ rem-su̱ u-Ru̱ su̱ u karu̱nte̱. Wa waru̱ wu̱n Rem-su̱ m-Re̱me̱r su̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","U̱n o̱ te̱k-u̱ m-ha se̱ u̱n te be-du̱ m-bu̱. Se̱ campa-u ya man zu̱, <<Gwat bu̱-mu̱ ya u̱ ane̱, ¿yan o̱ de̱ u̱t-hoos na no̱mu̱ bo̱ u̱t-yu̱bu̱sse̱ m-bu̱?>> ");
INSERT INTO gel_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Se̱ wa zu̱ u̱ na egu̱sse̱ ke̱ke̱-yu̱ jwaak, u̱n yu̱r be̱e̱t u̱n to u̱ me̱ m-bu̱, ku̱na Firibus no̱m-tu̱ campa-u ya u̱t-yu̱bu̱sse̱ m-bu̱. ");
INSERT INTO gel_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Da-u̱ u̱n rwu̱ne̱ du̱gu̱ m-bu̱, Yar-u u-Ru̱ ku̱b Firibus. Campa-u ya man swu̱ru̱g hyan-du̱ wu̱n da tu̱msu̱, se̱ wa hu̱ m-ha u̱ te̱k-u̱ u̱r-so̱. ");
INSERT INTO gel_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Firibus bit hi-u̱r wa u̱ bo̱-u̱ Azotus. Se̱ wa nu̱r bo̱-u̱t to̱ u̱t-be̱e̱t, wa o̱o̱gu̱ warru̱ Rem-su̱ m-Re̱me̱r har wa te bo̱-u̱ Kasariya. ");
INSERT INTO gel_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Shawuru re shu̱ u̱t-war m-ku̱wu̱t ne̱ u̱zu̱, <<U̱m do̱'e̱ yadu̱ i ya jab u̱zu̱ Ye̱so̱ wa o̱ Wa-ko-uyan u̱r-ko̱b.>> Se̱ e̱ do̱'e̱ u̱du̱ yu̱-Yat-ya a-To̱o̱g u̱ Urusharima. ");
INSERT INTO gel_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Wa ko̱no̱g wu̱n u̱zu̱, wa ya' wu̱n u-ran m-ha Kur-u̱ u̱t-Ko̱se̱ u̱ Yahuda-ne̱ tu̱ Dimaku remu̱ zu̱ a wa bite̱ a-dor u-Ru̱ u̱ku̱n campa-ne̱ ko ne̱ta-ne̱ se̱ wa maas e̱ wa mu̱tu̱n e̱ u̱ bo̱-u̱ Urusharima wa tage̱ e̱. ");
INSERT INTO gel_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Wa o̱ te̱k-u̱ m-ha wa haag m-te Dimaku, za rem zu̱n-mu̱ rwu̱u̱n du̱gu̱ do̱m u-ru̱ mo̱ gu̱nu̱s wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Se̱ wa he̱'e̱ u-dak tu̱msu̱ wa hog yaku̱n cwar-ya yu̱ o̱ zu̱ wu̱n, <<Shawuru, Shawuru, ¿remu̱ u-yan o̱ bo̱ o̱tte̱ yadu̱ me̱ u̱r-ko̱b?>> ");
INSERT INTO gel_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Se̱ wa zu̱, <<¿Wana bo̱ o̱ye̱ yu̱-Yat-ya?>> Cwar-yu̱ shu̱s ya zu̱, <<Me̱ wa Ye̱so̱ wu̱ bo̱ o̱ yadu̱ u̱r-ko̱b. ");
INSERT INTO gel_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Yu̱ne̱ bo̱ cwa u̱ me̱ u-bo̱, ku̱na na do̱te̱ waru̱ bo̱ no̱m-u̱ bo̱ de̱ u̱t-no̱m.>> ");
INSERT INTO gel_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Hu̱u̱b-tu̱ m-ha ro kerge̱ no̱m-du̱ u̱s-rem da remu̱ u-gye̱r. E̱ o̱ ho̱g-du̱ u-cwar, se̱di e̱ hyanu̱g ne̱t da. ");
INSERT INTO gel_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Se̱ Shawuru yu̱ne̱. Da-u̱ wa upse̱ is wa hyen-u̱t da. Se̱ hu̱u̱b-tu̱ m-ha ro nu̱k wu̱n u-kom, e̱ haatu̱n wu̱n u̱ Dimaku. ");
INSERT INTO gel_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Wa no̱mu̱g m-roog u̱t-tu̱t wa hyen-u̱t da, wa re̱e̱g o̱ko̱n da, tu̱msu̱ wa swaag o̱ko̱n da. ");
INSERT INTO gel_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yaku̱n campa-ya o̱ro wa-dor u̱ Dimaku, wu̱ na foge̱ Hananiya. Wa-ko-uyan no̱mu̱ wu̱n u̱s-rem u̱ bo̱ wa zu̱, <<Hananiya!>> Se̱ wa shu̱s wa zu̱, <<Me̱ ya Wa-ko-uyan.>> ");
INSERT INTO gel_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Wa-ko-uyan zu̱ wu̱n, <<Yu̱ne̱ bo̱ dor u-fu̱n yu̱ na zu̱ yu̱ <m-Kim,> bo̱ do̱'e̱ u̱ bu-u Yahuda, bo̱ shit ko ne̱t-u̱ bo̱-u̱ Tarsus o̱ro u̱ku̱n wu̱ na zu̱ye̱ Shawuru. Shawuru o̱ te̱k-u̱ u̱s-to̱o̱g u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Burus nom u-hyan, wa hyen waku̱n ne̱t-wa wu̱ na zu̱ye̱ Hananiya wa haagu̱n, wa do̱ru̱ wa u-kom remu̱ wa mu̱ttu̱n wa m-hyan.>> ");
INSERT INTO gel_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Se̱ Hananiya shu̱s wa zu̱, <<Wa-ko-uyan, u̱m swaag ho̱g-du̱ rem-su̱ campa-u ya u̱du̱ u̱t-ne̱t u-tát, u̱ remu̱ no̱m-u̱t yo̱-to̱ tu̱ wa no̱me̱ a-doru̱ ro u̱ Urusharima. ");
INSERT INTO gel_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Tu̱msu̱ a-to̱o̱g i-yate̱ swu̱rgu̱ wu̱n u̱r-be̱b, wa i no̱me̱ u̱s-to̱o̱g u̱ dim-u̱r ro.>> ");
INSERT INTO gel_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Wa-ko-uyan zu̱, <<De̱'e̱ di remu̱ ne̱t wa wu̱ u̱m dage̱ wa nom-u̱t pama-u ri, tu̱msu̱ wa no̱m do̱nse̱-du̱ dim-u̱r ri u̱du̱ i za-yahuda-ne̱ da, u̱ farkina-ne̱ tu̱msu̱ u̱ Isra-ne̱. ");
INSERT INTO gel_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Me̱ hi-du̱ warri, me̱ ko̱su̱ wu̱n ko̱b-du̱ u do̱'e̱ u̱t-swa remu̱ dim-u̱r ri.>> ");
INSERT INTO gel_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Se̱ Hananiya do̱'e̱ wa to u̱ bu-u o̱ wa saku̱ Shawuru u-kom u̱r-hi. Wa zu̱, <<O̱ru̱ ri Shawuru, Wa-ko-uyan wa to̱mnu̱ me̱, wato, Ye̱so̱ wu̱ ko̱se̱ hi-u̱r wa u̱du̱ ro u̱ do̱m-u̱ u-fu̱n, remu̱ bo̱ kum-u̱t m-hyan tu̱msu̱ Yar-u u-Ru̱ dor-u̱t bo̱.>> ");
INSERT INTO gel_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Za rem se̱ o̱ko̱n no̱m-o̱ u̱ka u-ku hye̱e̱n du̱gu̱ Is-u̱ Shawuru, se̱ wa kum m-hyan du̱gu̱ ku̱n wa yu̱ne̱ na no̱mu̱ wa u̱t-yu̱bu̱sse̱ m-bu̱. ");
INSERT INTO gel_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Wa re̱e̱g no̱m u̱t-re̱ wa sur m-kwu̱m u̱r-be̱b. Tu̱msu̱ Shawuru shu̱'u̱t u̱ku̱n u̱du̱ e̱ke̱n a-dor-ne̱ i o̱ u̱ Dimaku. ");
INSERT INTO gel_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Za m-tumb, Shawuru he̱e̱se̱ warru̱ rem-u̱s Ye̱so̱ u̱ Kur-u̱ u̱t-Ko̱se̱ u̱ Yahuda-ne̱ tu̱ Yahuda-ne̱, u̱zu̱ Ye̱so̱ wa o̱ Wa'-u̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","U̱t-ne̱t u̱t-be̱e̱t I ho̱ge̱, e̱ hu̱ mu̱rimmo̱. E̱ zu̱, <<Ne̱t unwa ho̱re̱ u̱t-ne̱t, ¿tu̱msu̱ wa bu̱rgu̱sse̱ u̱t-ne̱t i foge̱ dim-u̱r Ye̱so̱ u̱ Urusharima da? Jiya haan de̱ wa haane̱ u̱ wa maas e̱, wa hu̱u̱t u̱ ke̱nu̱ a-to̱o̱g i-yate̱!>> ");
INSERT INTO gel_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Se̱di Ru̱-u̱ yaag Shawuru be̱b-du̱ u̱t-bu̱t u̱du̱ u̱t-ne̱t tu̱msu̱ wa hu̱ nak-du̱ jab-su̱ Yahuda-ne̱ i o̱ u̱r-yu̱ u̱ Dimaku. Wa o̱ waru̱ u̱n u̱zu̱ Ye̱so̱ o̱ Kiristi, wu̱ Ru̱-u̱ dage̱. ");
INSERT INTO gel_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Da rooge̱ u-tát, Yahuda-ne̱ zo̱ng e̱ ho̱ Shawuru. ");
INSERT INTO gel_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Se̱ Shawuru hog no̱m-u̱ u̱n zo̱nge̱ u̱t-no̱m. U-ho̱ m-gyu̱p ne̱ u̱n o̱ wadu̱ u̱r-is, u̱ is-tu̱ u-bo̱ u̱ka u̱n do̱te̱ ho̱-du̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","M-gyu̱p a-doru̱ Ye̱so̱ haan e̱ gun wu̱n u̱-me̱ u-ko̱o̱r e̱ ruut wu̱n u̱ yaku̱n pyam-ya yu̱ na hune̱ sar. ");
INSERT INTO gel_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Da-u̱ Shawuru haane̱ u̱ Urusharima, se̱ wa nom u̱ka wa cwa u-me̱ a-doru̱ Ye̱so̱. Se̱di u̱n be̱e̱t kowan hog gye̱r-u ro, remu̱ zu̱ u̱n eeste̱ u̱zu̱ wa o̱ te̱k-u̱ a-doru̱ Ye̱so̱ da. ");
INSERT INTO gel_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Baraba ku̱b wu̱n u̱du̱ a-To̱mu̱ Ye̱so̱. Wa waru̱ u̱n u̱ka Shawuru hente̱ Wa-ko-uyan u-fu̱n, u̱ bo̱-u̱ Dimaku ne̱ u̱ka Ru̱-u̱ no̱m-tu̱ wu̱n u̱s-rem, tu̱msu̱ u̱ka Shawuru wu̱rte̱ rem-u̱s Ye̱so̱ u̱ Dimaku za u-gye̱r. ");
INSERT INTO gel_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Du̱gu̱ ku̱n Shawuru he̱e̱se̱ u̱t-riig u̱ u̱nne̱ u̱ Urusharima. Wa o̱ waru̱ rem-su̱ Wa-ko-uyan za u-gye̱r. ");
INSERT INTO gel_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Tu̱msu̱ wa hu̱ u̱s-rem u̱ Yahuda-ne̱ i ho̱ge̱ rem-u̱r u̱t-Girik, wa o̱ inan u̱ u̱n ne̱, tu̱msu̱, e̱ u̱t-sa e̱ ho̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Da-u̱ o̱r-u̱t ro nape̱ iya, se̱ e̱ hu̱u̱t wu̱n u̱ bo̱-u̱ Kasariya e̱ tok wu̱n u̱ bo̱-u̱ Tarsus. ");
INSERT INTO gel_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Du̱gu̱ ku̱n a-doru̱ Ye̱so̱ i dak-u̱ Yahudiya, u̱ Gariri ne̱, u̱ Samariya-ne̱, e̱ kum shu̱'u̱t-du̱ m-yar, remu̱ zu̱ waku̱n zaar wu̱ o̱ yadu̱ u̱n u̱r-ko̱b da. Yar-u u-Ru̱ yaag u̱n u̱r-be̱b tu̱msu̱ wa swu̱ru̱ u̱n shiriktin-mu̱ jab. Mo̱ro̱g-du̱ a-dor kum u̱r-be̱b. Tu̱msu̱ e̱ sur u-tát remu̱ se̱ge̱-du̱ Yar-u u-Ru̱, dak-u̱ e̱ o̱ u̱r-yu̱ e̱ ye' Wa-ko-uyan m-ze̱g. ");
INSERT INTO gel_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Da-u̱ Biturus cwaage̱ gas-u o̱ u-be̱e̱t, se̱ wa do̱'e̱ u̱du̱ a-doru̱ Ye̱so̱ ne̱ i o̱ u̱r-shu̱'u̱t u̱ bo̱-u̱ Ridda. ");
INSERT INTO gel_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ku̱na wa bite̱ waku̱n wu̱ na zu̱ye̱ Iniyas wa o̱tte̱ go̱m-su̱ swadu̱ ne̱t u̱t-be. Wa o̱ m-ru̱t u̱s-hak ko̱b-du̱ u̱s-yu̱r. ");
INSERT INTO gel_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Biturus zu̱ wu̱n Iniyas, <<Ye̱so̱ Kiristi yaag bo̱ m-yar. Yu̱ne̱ bo̱ hust wu̱ndi-u̱r ro.>> Za rem Iniyas yu̱ne̱. ");
INSERT INTO gel_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ne̱t-tu̱ Ridda u̱t-be̱e̱t u̱ tu̱ dak-u̱ Sharo̱n ne̱, e̱ hyen wu̱na ya' m-yar, se̱ e̱ byu̱ru̱n u̱du̱ Wa-ko-uyan. ");
INSERT INTO gel_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","U̱ Jopa yaku̱n ne̱ta ya o̱ro, wa-doru̱ Ye̱so̱, wu̱ na zu̱ye̱ Tabita. A-bo̱ bargu̱sse̱ u̱ rem-du̱ u̱t-Girik na zu̱ Dorkas. Ne̱ta-u ya ya'aste̱ hi-u̱r wa u̱ no̱m-du̱ no̱m-u̱t so̱-to̱ tu̱msu̱ u̱ no̱m-du̱ u̱r-se̱ge̱ ne̱ u̱du̱ a-u̱r-ko̱b-ne̱. ");
INSERT INTO gel_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","U̱ da-u o̱ wa nom ko̱b-du̱ m-yar, har wa mu̱ru̱s. Da-u̱ na tase̱ zo̱rru̱ u̱r-u, e̱ ru̱st u̱r-u u̱ me̱ kur-u̱ do̱m. ");
INSERT INTO gel_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ridda o̱ u̱t-mo̱r u̱ Jopa ne̱, da-u̱ a-dor ho̱ge̱ u̱zu̱ Biturus o̱ u̱ Ridda, se̱ e̱ tom ne̱t-ne̱ yu̱r u̱du̱ wu̱n, remu̱ e̱ kon-u̱t wu̱n wa haan u̱du̱ u̱n m-ho̱r m-ho̱r. ");
INSERT INTO gel_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Se̱ Biturus yu̱ne̱ wa dor u̱n. Da-u̱ wa teye̱, u̱n ku̱b wu̱n m-da u̱ kur-u̱ do̱m. Bomos-ne̱, e̱ o̱ ees u̱ dapu̱s wu̱n, e̱ o̱ u̱s-kan, e̱ o̱ ko̱su̱ wu̱n u̱s-to̱ggo̱ u̱ to̱ko̱n cwu̱-to̱ ne̱ tu̱ Tabita no̱mu̱ u̱n da-u̱ wa o̱o̱ge̱ u̱r-kot u̱ u̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Biturus zu̱ u̱n ru u̱-do̱, se̱ wa he u̱t-jwu̱n wa no̱m u̱s-to̱o̱g, wa bir u̱du̱ u̱r-u wa zu̱, <<Tabita yu̱ne̱!>> Se̱ Tabita upus is. Da-u̱ wa hyane̱ Biturus, se̱ wa yu̱ne̱ u̱ shu̱'u̱t m-shu̱'u̱t. ");
INSERT INTO gel_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Biturus nu̱b u-kom, wa ship wu̱n u̱du̱ u̱r-yu̱ne̱ se̱ wa fog a-doru̱ bomos-ne̱ wa nabu̱ u̱n wa u̱r-fat ne̱. ");
INSERT INTO gel_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Rem-u̱s se̱ te ko̱he̱ne̱ u̱ Joffa, tu̱msu̱ u̱t-ne̱t u-tát e̱ ye u̱t-nip u̱du̱ Wa-ko-uyan. ");
INSERT INTO gel_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Biturus shu̱'u̱t u̱t-ho̱ u-tát u̱ Jopa, u̱ bu-u waku̱n (Wa u-swam u̱t-ka) dim-u̱r wa Simo̱n. ");
INSERT INTO gel_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Waku̱n ne̱t-wa o̱ro u̱ Kasariya na zu̱ wa Koniriyus. U o̱ yu̱ yat-ya a-m-gag ne̱ Roma-ne̱ wa, u̱ mo̱ro̱g-du̱ na foge̱, <<Mo̱ro̱g-du̱ Itariya.>> ");
INSERT INTO gel_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wa cwanu̱g u-Ru̱ u̱ jab-u̱ ro ne̱ be̱e̱t, tu̱msu̱ o̱o̱g wu̱ <<No̱mu̱ u-Ru̱ u̱t-huuk>> ne̱t-tu̱ bu-u ro ne̱ u̱t-be̱e̱t. Wa o̱ no̱mu̱ Yahuda-ne̱ u̱r-se̱ge̱ u-tát, i o̱ u̱r-ko̱b tu̱msu̱ wa nom u̱s-to̱o̱g u̱du̱ u-Ru̱ ko mu̱ne̱. ");
INSERT INTO gel_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","De̱ku̱n ho̱-de̱ u̱ dapu̱s u̱s-kwan u̱s-tu̱t su̱ m-rim, se̱ wa no̱m u-hyan. Wa hyen wa-To̱m u-Ru̱, wu̱ cwaane̱ u̱du̱ rò u̱zu̱, <<Koniriyus!>> ");
INSERT INTO gel_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Koniriyus hen se̱ wa hu̱ gwat-du̱ wu̱n u-gye̱r ne̱, wa zu̱, <<¿U̱so-u̱ u-bu ri, yan-o̱?>> Wa-To̱m u-Ru̱ zu̱ wu̱n, <<To̱o̱g-u̱s ró u̱ se̱ge̱-u̱r ró u̱du̱ a-u̱r-ko̱b-ne̱, teeg u̱du̱ u-Ru̱ tu̱msu̱ to̱ shu̱'u̱te̱ no̱m-u̱ u̱t-baku̱s u̱du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","U̱ da-o̱ to̱m u̱t-ne̱t m-ha u̱ Jopa, na mu̱tu̱n yaku̱n campa-ya wu̱ na zu̱ye̱ Simo̱n wu̱ na foge̱ Biturus. ");
INSERT INTO gel_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wa cu̱st-u̱ bu-u Simo̱n wa-swam u̱t-ka, wu̱ bu-u wa o̱ dapu̱s m-sa>> ");
INSERT INTO gel_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Da-u̱ wa-To̱m u-Ru̱ wu̱ no̱mu̱ u̱s-rem u̱ wu̱n ne̱ arke̱, Koniriyus fog to̱k-u̱ wa yu̱r, u̱ wa m-gag wu̱ ya' u̱r-hi sok u̱du̱ ro, i no̱mu̱ wu̱n u̱s-pama ne̱ ko mu̱ne̱. ");
INSERT INTO gel_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Wa waru̱ u̱n u̱t-no̱m u̱t-be̱e̱t u̱ka na nomte̱ se̱ wa-To̱m u̱n u̱ Jopa. ");
INSERT INTO gel_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Da-u̱ is gase̱, u̱ te̱k-u̱ u-ho̱, a-to̱mu̱ Koniriyus tu̱t o̱ te̱k-u̱ m-ha. E̱ haag m-te̱ bo̱-u Jopa, Biturus yu̱ne̱ wa du̱u̱s u̱ ku̱r-u̱ do̱m wa nom-u̱t u̱s-to̱o̱g. ");
INSERT INTO gel_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Se̱ wa ho̱o̱g u̱s-me̱r, wa u̱t-sa no̱m u̱t-re̱. Da-u̱ na o̱ te̱k-u̱ no̱m-du̱ no̱m-u̱t re, se̱ wa nom u-hyan. ");
INSERT INTO gel_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Se̱ wa hyen do̱m u-ru̱ upuste̱, o̱ko̱n no̱m-o̱ cu̱zu̱n u̱ka kus-u yat-o̱, o̱ cu̱zu̱n u-dak nu-u̱t wane̱ u̱t-nas. ");
INSERT INTO gel_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","U̱-me̱ kus-u o̱ ko̱-uyan go̱-du̱ bisa u̱r-do̱g o̱ o̱ro u̱-me̱, i u̱s-na u̱s-nas o̱ro u̱ i za u̱s-na ne̱, u̱ no ne̱ i u̱r-do̱g. ");
INSERT INTO gel_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Cwar-yu̱ zu̱ wu̱n, <<Biturus, yu̱ne̱, bo̱ pan, bo̱-tu̱.>> ");
INSERT INTO gel_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Biturus zu̱, <<Wa-ko-uyan, za u̱t-no̱me̱ da, u̱m tamu̱g tu̱du̱ m-ap mu̱ Bo̱r-u̱t Mosa hose̱ it u̱t-tu̱ da.>> ");
INSERT INTO gel_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Cwar-yu̱ sur no̱mu̱ wu̱n u̱s-rem u-yu̱ru̱mse̱ u̱zu̱, <<No̱m-u̱ Ru̱-u̱ mute̱ u-he̱n, a-bo̱ zu̱ o̱ zatte̱ u-he̱n da.>> ");
INSERT INTO gel_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Na nom iya u̱so u-tu̱t, za rem na ku̱b u-kus u̱ do̱m u-ru̱. ");
INSERT INTO gel_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Da-u̱ Biturus o̱ te̱k-u̱ u̱s-dorog u̱zu̱ yan go̱ bo' o̱ iya, se̱ ne̱t-tu̱ Koniriyus to̱me̱ teen bu-u Simo̱n. E̱ o̱ ees u̱ is u-bu. ");
INSERT INTO gel_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","E̱ fo̱g, e̱ shit u̱zu̱ ko Simo̱n wu̱na foge̱ Biturus cu̱ste̱ u̱ ane̱. ");
INSERT INTO gel_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Biturus o̱ te̱k-u̱ u̱s-dorog, Yar-u̱ zu̱ wu̱n, <<Simo̱n, ne̱t-ne̱ tu̱t o̱ sa-u ró. ");
INSERT INTO gel_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Yu̱ne̱ bo̱ ciz, bo̱ do̱r u̱n, a-bo̱ no̱m sakna u̱ o̱ko̱n da remu̱ zu̱ me̱ wa to̱mnu̱ u̱n.>> ");
INSERT INTO gel_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Biturus ciz u̱du̱ ne̱t-u̱t to̱, se̱ wa zu̱ u̱n, <<¿Me̱ wa no̱ u̱t-sa? ¿Yan-o̱ hatu̱n no̱?>> ");
INSERT INTO gel_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ne̱t-u̱t to̱ zu̱, <<Yu̱-shu̱ a-m-gagu̱ Roma-ne̱ wa to̱mnu̱ it. Wa o̱tte̱ dim-u̱r so̱-de̱, tu̱msu̱ wu̱ no̱me̱ u-Ru̱ u̱t-huuk. Ne̱t wa wu̱ ne̱t-tu̱ Yahuda-ne̱ no̱me̱ rem-u̱s so̱-se̱ u̱ wa ne̱. Wa-To̱m u-Ru̱ wu̱ u-he̱n wa zu̱ wu̱n wa-to̱m bo̱ haan u̱ bu-u ro, wa ho̱g no̱m-u̱ bo̱ de̱ u̱t-war.>> ");
INSERT INTO gel_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Se̱ Biturus toot u̱n u̱-me̱ u-bu, wa yu̱' u̱n be-de̱ m-roog. Da-u̱ is gase̱ Biturus nok u̱ u̱n ne̱, tu̱msu̱ e̱ke̱n a-doru̱ Ye̱so̱ du̱gu̱ Jopa e̱ shu̱'u̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","U̱ ho̱-du̱ u-tu̱tu̱rse̱ u̱n to̱ u̱ Kasariya. Koniriyus o̱gu̱ e̱stu̱ u̱n, se̱ wa fagu̱n o̱r-u̱t wa ne̱ u̱ hu̱u̱b-tu̱ u̱r-shu̱'u̱t u̱ wane̱ be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Da-u̱ Biturus cwaye̱ u-bu, Koniriyus bit wu̱n wa he u̱t-jwu̱n wa no̱mu̱ wu̱n sekmu̱sse̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Biturus zu̱ wa yu̱ne̱, wa zu̱, <<Yu̱ne̱ u̱r-ees, Ko̱me̱ ne̱t wa u̱m o̱ye̱.>> ");
INSERT INTO gel_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Biturus o̱ te̱k-u̱ u̱s-rem, wa aru̱k m-cwa u̱-me̱ se̱ wa bit u̱t-ne̱t u-tát. ");
INSERT INTO gel_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Wa zu̱ u̱n, <<No̱ nak u̱zu̱ pas-du̱ bo̱r-u Yahuda-ne̱ de̱ u̱ wa-yahuda no̱m-u̱t u̱r-karu̱g u̱ wa za-Yahuda-ne̱. Se̱di Ru̱-u̱ ko̱sku̱ me̱ u̱zu̱ a u̱m fag waku̱n za u-he̱n da ko̱ wa-u̱s-gu̱r da. ");
INSERT INTO gel_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","De̱ wu̱te̱ da na to̱mne̱ u̱m haan u̱m gu̱gu̱mte̱ da, u̱ da-o̱ hen u̱m u̱t-sa u̱m nap no̱m-u̱ no̱ fog-tu̱ me̱.>> ");
INSERT INTO gel_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koniriyus shu̱s wa zu̱, <<U̱t-ho̱ u̱t-nas tu̱ arke̱, ho̱n-ho̱n u̱s-kwam u̱s-tu̱t su̱ m-rim, u̱m o̱ te̱k-u̱ u̱s-to̱o̱g u̱ bu-u ri, se̱ u̱m hyen waku̱n u̱ ees u̱ shu̱ ri u̱ cwu̱-tu̱ m-baku̱t ne̱ sok. ");
INSERT INTO gel_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ne̱t-u̱ wa zu̱ me̱, <Koniriyus Ru̱-u̱ ho̱k to̱o̱g-u̱s ró, u̱ se̱ge̱-du̱ bo̱ no̱me̱ a-u̱r-ko̱b-ne̱ be̱e̱t, Ru̱-u̱ baku̱ste̱ u̱ bo̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","To̱m u̱ Jopa na fagu̱n Simo̱n, wu̱na zu̱ye̱ Biturus, wa cu̱ste̱ u̱ bu-u Simo̱n wa-swam u̱t-ka, wu̱ bu-u wa o̱ dapu̱s m-sa.> ");
INSERT INTO gel_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","De̱ wu̱te̱ u̱m tom na fagu̱n bo̱, tu̱msu̱ no̱ng u̱r-zwar u̱ bo̱ hatu̱n. It mo̱ro̱gte̱ u̱ ke̱nu̱ u-Ru̱, remu̱ it ho̱g no̱m-u̱ wa u̱t-sa bo̱ waru̱ it.>> ");
INSERT INTO gel_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Biturus he̱e̱se̱ no̱mu̱ u̱n u̱s-rem u̱zu̱, <<U̱ da-o̱ u̱m nak u̱t-nip u̱zu̱ Ru̱-u̱ ko̱ste̱ m-ku̱u̱k da. ");
INSERT INTO gel_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Wa ku̱b ne̱t-tu̱ ko̱-uyan dak-o̱ i o̱ gye̱r-u ro, tu̱msu̱ ne̱t-tu̱ o̱ no̱m-du̱ no̱m-u̱ Ru̱-u̱ u̱t-sa. ");
INSERT INTO gel_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","No̱ nak to̱mu̱ Ru̱-u̱ no̱me̱ m-ha u̱du̱ ne̱t-tu̱ Isra-ne̱, warru̱ Rem-su̱ m-Re̱me̱r su̱ shu̱'u̱t-du̱ m-yar su̱ Ye̱so̱ Kiristi, wu̱na o̱ Wa-ko-uyan u̱ kowan. ");
INSERT INTO gel_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","No̱ nak no̱m-u̱ no̱me̱ u̱-me̱ dak-u̱ Yahudiya, na takku̱n u Gariri, da Yohanna he̱e̱se̱ bu̱t-tu̱ u̱t-yu̱bu̱sse̱ m-bu̱. ");
INSERT INTO gel_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","No̱ nak mo̱t-u̱t Ye̱so̱ wa-Nazara. No̱ nak Ru̱-u̱ shu̱u̱ste̱ wa u̱ Yar-u u-Ru̱, tu̱msu̱ u̱r-be̱b ne̱. Tu̱msu̱ no̱ nak u̱ka Ye̱so̱ hu̱u̱te̱ u̱r-cwa, u̱ no̱m-du̱ no̱m-u̱t so̱-to̱, u̱ hastu̱ ne̱t-ne̱ u̱s-go̱m. Wa yadu̱ m-yar u̱du̱ ne̱t-tu̱ faru̱k-u̱ no̱m u̱s-te shipse̱, remu̱ zu̱ Ru̱-u̱ o̱ u̱r-kot u̱ wu̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","<<In be̱e̱t kowan hyanu̱g tu̱msu̱ wa wu̱r no̱m-u̱ Ye̱so̱ no̱me̱ u̱ dak-u̱ Yahuda-ne̱ u̱ Urusharima ne̱. Tu̱-shu̱ tu̱ Urusharima ho̱o̱g wu̱n e̱ tu̱r wu̱n u̱ do̱m u-kan. ");
INSERT INTO gel_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ru̱-u̱ wa'ag wa yu̱ne̱ u̱ ho̱-du̱ u-tu̱tu̱rse̱ du̱gu̱ m-mar, tu̱msu̱ ne̱t-tu̱ hyanu̱g wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ne̱t-to̱ u̱t-be̱e̱t tu̱ hyane̱ wu̱n da, se̱di in, i Ru̱-u̱ dage̱ remu̱ in hyen-u̱t tu̱msu̱ in waru̱n e̱ke̱n no̱m-tu̱ in hyane̱. Tu̱msu̱ it re̱g tu̱msu̱ it swaag u̱r-kot u̱ wu̱n ne̱ da-u̱ wa yu̱ne̱ du̱gu̱-du̱ m-mar. ");
INSERT INTO gel_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Wa wargu̱ u̱zu̱ na no̱m u̱t-bu̱t u̱du̱ u̱t-ne̱t, tu̱msu̱ na waru̱ e̱ u̱zu̱ wu̱na Ru̱-u̱ dage̱ wa shu̱'u̱t wa kwu̱p-du̱ u̱s-rem su̱ i o̱ te̱k-u̱ u̱r-fat u̱ i mare̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","A-warru̱ rem-su̱ u-Ru̱ ne̱ be̱e̱t e̱ waru̱g u̱zu̱ wu̱ ya' jab-u̱ wu̱n ne̱ wa u̱t-kwu̱m jaas-du̱ u̱t-ba'as u̱ te̱k-u̱ dim-u̱r ro.>> ");
INSERT INTO gel_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Biturus o̱ te̱k-u̱ warru̱ rem-u̱s sin-se̱, Yar-u u-Ru̱ he̱e̱n u̱ do̱m-u̱ kowan wu̱ ho̱ge̱ rem-se̱. ");
INSERT INTO gel_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yahuda-ne̱ a-dor i haane̱ u̱r-kot u̱ Biturus ne̱ e̱ hu̱ mu̱rimmo̱ remu̱ zu̱ i za-yahuda-ne̱ da kwu̱mu̱g Yar-u u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","A-doru̱ Yahuda-ne̱ ho̱k no̱mu̱ Ru̱-u̱ no̱me̱ remu̱ zu̱ u̱n ho̱k ne̱t-u̱t to̱ u̱s-rem u̱ to̱ko̱n rem-to̱ e̱ vom u-Ru̱. Se̱ Biturus zu̱, ");
INSERT INTO gel_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","<<¿Waku̱n o̱ro wu̱ de̱ u̱t-hoos na no̱mu̱ ne̱t-u̱t tun-to̱ u̱t-yu̱bu̱sse̱ m-bu̱? E̱ kwu̱mu̱g Yar-u u-Ru̱ u̱ka in kumte̱.>> ");
INSERT INTO gel_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Se̱ Biturus zu̱ o̱r-u̱t wa no̱mo̱n u̱n u̱t-yu̱bu̱sse̱ m-bu̱, u̱ dim-u̱r Ye̱so̱ Kiristi. Se̱ ne̱t-tu̱ bu-u Ko̱niriyus kon u̱zu̱ Biturus u̱ shu̱'u̱t u̱ u̱n ne̱ u̱t-ho̱ cashi. ");
INSERT INTO gel_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","A-To̱mu̱ Ye̱so̱ u̱ a-dor-ne̱ u̱-me̱ dak-u̱ Yahudiya u-be̱e̱t e̱ ho̱k u̱zu̱ i za-Yahuda-ne̱ da, e̱ kabu̱g rem-su̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Da-u̱ Biturus do̱'e̱ u̱ Urusharima e̱ke̱n i-yate̱ Yahuda-ne̱ a-dor, i na no̱me̱ u̱r-pe̱s, e̱ no̱mu̱ wu̱n u-har. ");
INSERT INTO gel_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","E̱ zu̱, <<¿Remu̱ u-yan o̱ bo̱ de̱te̱ u̱du̱ i nomte̱ u̱r-pe̱s da, har bo̱ re̱ no̱m u̱t-re̱ u̱ u̱n ne̱?>> ");
INSERT INTO gel_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Biturus he̱e̱se̱ waru̱ u̱n u̱r-zwar ne̱. Wa zu̱, ");
INSERT INTO gel_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","<<U̱m o̱ u̱ bo̱-u̱ Jopa u̱m o̱ u̱s-to̱o̱g, se̱ u̱m nom u-hyan. U̱m hyen o̱ko̱n no̱m-o̱ u̱ cu̱zu̱n du̱gu̱ do̱m u-ru̱ u̱ka kus-u yat-o̱ u̱ nu-u̱t wa ne̱ u̱t-naas, har o̱ teen u̱ dapu̱s me̱. ");
INSERT INTO gel_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Da-u̱ u̱m gwate̱ u̱r-zwar ne̱, u̱m hyen u̱t-bisa i na-su̱ u̱s-nas, u̱ bisa-tu̱ u̱r-do̱g ne̱, u̱ i za u̱s-na ne̱, u̱ no i me̱ u̱r-do̱g ne̱. ");
INSERT INTO gel_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tu̱msu̱ u̱m hog yaku̱n cwar-ya yu̱ zu̱ me̱, <Biturus, yu̱ne̱, bo̱ pan, bo̱ tu̱.> ");
INSERT INTO gel_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","<<Se̱ u̱m zu̱, <Iya o̱ da! Wa-ko-uyan, u̱m tamu̱g re̱-du̱ o̱ko̱n no̱m-o̱ u̱ bo̱r-u̱t it Yahuda-ne̱ kabe̱ u̱ za u-he̱n da.> ");
INSERT INTO gel_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","<<U̱m sur m-ho̱g u-cwar u-yu̱ru̱mse̱ du̱gu̱ u-ru̱ yu̱ zu̱ye̱, <No̱m-u̱ Ru̱-u̱ muute̱ u-he̱n a-bo̱ kab o̱ za u-he̱n da.> ");
INSERT INTO gel_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Na no̱ng inya u̱so u-tu̱t kanda na ku̱b-u̱t no̱m-u̱t to̱ m-mu̱ u̱ do̱m-u̱ u-ru̱. ");
INSERT INTO gel_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","<<U̱ te̱k-u̱ da-u o̱ se̱ ne̱t-ne̱ tu̱t rwu̱u̱n, e̱ ees u̱ is u-bu u̱ u̱m o̱tte̱. Na to̱mgo̱n e̱ du̱gu̱ Kasariya u̱ haan u̱du̱ ri. ");
INSERT INTO gel_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Se̱ Yar-u u-Ru̱ zu̱ me̱, a u̱m no̱m dorog-su̱ o̱ko̱n no̱m-o̱ da, u̱m dor u̱n. O̱r-u̱t ri ne̱t-ne̱ ine̱ shishin e̱ shu̱'u̱ me̱ m-ha u̱ Jopa har u̱ me̱ bu-u Kaniriyus. ");
INSERT INTO gel_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Se̱ wa waru̱ it u̱ka wa hente̱ wa-To̱m u-Ru̱ eeste̱ u̱ bu-u ro, wa-To̱m u-Ru̱ zu̱, <To̱m m-ha u̱ Jopa na fagu̱n Simo̱n, wu̱ na zu̱ye̱ Biturus. ");
INSERT INTO gel_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Wa de̱ haatu̱n bo̱ rem-su̱ bo̱ do̱te̱ kwu̱m-du̱ u-u̱ku̱r bo̱ u̱ ne̱t-tu̱ bu-u ro ne̱ be̱e̱t.> ");
INSERT INTO gel_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","<<Ba u̱m he̱e̱se̱ no̱mu̱ u̱n u̱s-rem, se̱ Yar-u u-Ru̱ he̱e̱n u̱ do̱m-u̱ u̱n, u̱ka he̱te̱n it u̱r-taku̱n. ");
INSERT INTO gel_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Se̱ u̱m baku̱s rem-su̱ Wa-ko-uyan u̱ka se̱ zu̱tte̱, <Yohanna no̱ng u̱t-yu̱bu̱sse̱ m-bu̱, na de̱ no̱mu̱ no̱ u̱ Yar-u u-Ru̱.> ");
INSERT INTO gel_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ba shu̱'u̱te̱ u̱zu̱ Ru̱-u̱ no̱ngu̱ u̱n u-nya ho̱n-ho̱n u̱ka wa yete̱ in, da-u̱ in ya'e̱ u̱t-nip u̱du̱ Wa-ko-uyan Ye̱so̱ Kiristi, tu̱msu̱ u̱m ko̱rge̱ u̱m hoos u-Ru̱ da!>> ");
INSERT INTO gel_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Da Yahuda-ne̱ u̱ a-doru̱ Ye̱so̱ ne̱ ho̱ge̱ iya, e̱ taag u̱ no̱m-u̱ e̱ de̱ u̱t-zu̱. Se̱ e̱ vo̱m u-Ru̱, e̱ o̱ u̱t-zu̱, <<Ko i za-yahuda-ne̱ da Ru̱-u̱ no̱ngu̱ e̱ fu̱n-yu̱ yage̱-du̱ u̱t-ba'as u̱ kwu̱m-du̱ u̱r-fat ne̱.>> ");
INSERT INTO gel_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Da-u̱ na ho̱ Istifanus, Yahuda-ne̱ hu̱ yadu̱ a-doru̱ Ye̱so̱ u̱r-ko̱b. Remu̱ iya a-doru̱ Ye̱so̱ bu̱ru̱g m-ha to̱ko̱n bo̱-to̱. E̱ke̱n do̱'e̱ dak-u̱ Finikiya u̱ Sayifurus ne̱ u̱ bo̱-u̱ Antakiya ne̱. E̱ o̱ warru̱ rem-su̱ u-Ru̱ u̱du̱ Yahuda-ne̱ u̱ wa-u̱r-e'. ");
INSERT INTO gel_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Se̱di e̱ke̱n a-dor-ne̱ o̱ro du̱gu̱ Sayifurus u̱ Sayirin-ne̱ e̱ do̱'e̱ u̱ Antakiya e̱ no̱me̱ i za-yahuda-ne̱ da u̱s-rem, e̱ o̱ waru̱ u̱n Rem-su̱ m-Re̱me̱r su̱ Wa-ko-uyan Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Be̱b-du̱ u-Ru̱ o̱ u̱r-kot u̱ u̱n ne̱ har ne̱t-ne̱ u-tát e̱ yage̱ u̱t-ba'as e̱ byu̱ru̱n u̱du̱ Wa-ko-uyan. ");
INSERT INTO gel_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Rem-su̱ no̱mu̱ na no̱me̱ u̱ Antakiya teeg u̱du̱ a-dor i o̱ u̱ Urusharima, ban-du̱ a-doru̱ Ye̱so̱ tok Baraba m-ha u̱ Antakiya. ");
INSERT INTO gel_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Da-u̱ wa haane̱ se̱ wa hyen no̱m-u̱ Ru̱-u̱ no̱me̱ u̱n, se̱ wa nom u̱r-so̱. Se̱ wa sur m-ya u̱n shiriktin-mu̱ jab u̱zu̱, u̱n shu̱'u̱t u̱ te̱k-u̱ yadu̱ jab u̱du̱ Wa-ko-uyan u̱-me̱ jab-u̱s u̱n. ");
INSERT INTO gel_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Baraba ne̱t-u̱ u̱r-ka wa, tu̱msu̱ Yar-u u-Ru̱ o̱ dor-tu̱ wu̱n, tu̱msu̱ wa o̱tte̱ yadu̱ jab. U̱t-ne̱t u-tát e̱ byu̱ru̱n u̱du̱ Wa-ko-uyan. ");
INSERT INTO gel_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Du̱gu̱ ku̱n se̱ Baraba do̱'e̱ u̱ Tarsus u̱ sa-u Shawuru. ");
INSERT INTO gel_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Da-u̱ wa bite̱ wu̱n u̱ ku̱n, se̱ wa haatu̱n wu̱n u̱ Antakiya. U-hak u-gan ho̱n-ho̱n, u̱n o̱ u̱ a-doru̱ Ye̱so̱ ne̱, e̱ o̱ no̱mu̱ ne̱t-ne̱ u-tát u̱t-ko̱se̱. U Antakiya o̱ na he̱e̱ste̱ fag-du̱ a-dor Kirista-ne̱. ");
INSERT INTO gel_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","U da-u o̱ e̱ke̱n a-warru̱ rem-su̱ u-Ru̱ haan u̱ Antakiya du̱gu̱ Urusharima. ");
INSERT INTO gel_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Wagan u̱ te̱k-u̱ me̱ u̱n, na zu̱ wa Agabus, wa yu̱ne̱ u̱r-ees, wa nom u̱s-rem u̱ te̱k-u̱ be̱b-du̱ Yar-u u-Ru̱. Wa zu̱ na u̱t-no̱m u̱s-me̱r u-dak u-be̱e̱t. (Na no̱ng se̱ hen u̱ da-u̱ Sisar Kawudikiya o̱o̱ge̱ u̱r-faru̱k.) ");
INSERT INTO gel_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Se̱ a-dor Ye̱so̱ dorog u̱ jab-u̱ e̱ u̱zu̱ e̱ tom-tu̱ o̱r-u̱t e̱ ne̱ i o̱ Yahudiya u̱r-se̱ge̱, kowan ku̱b no̱m wa de̱ u̱t-kere̱ u̱t-ya. ");
INSERT INTO gel_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Iya o̱ hen e̱ nomte̱, e̱ yasu̱ Baraba tom e̱ Shawuru se̱ge̱-u̱r e̱ m-ha u̱du̱ tu̱-shu̱ a-doru̱ Ye̱so̱ u̱ Urusharima. ");
INSERT INTO gel_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","U̱ te̱k-u̱ da-u o̱ Here̱ Agarifa Faru̱k he̱e̱se̱ yadu̱ e̱ke̱n a a-doru̱ Ye̱so̱ ne̱ u̱r-ko̱b. ");
INSERT INTO gel_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Here̱ wa'ag karma-ne̱ ho Yakubu hu̱no-u Yohanna u-van. ");
INSERT INTO gel_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Da-u̱ wa hyane̱ u̱zu̱ Yahuda-ne̱ ho̱k zwarru̱ no̱m-u̱ wa no̱me̱, se̱ wa maas Biturus ko̱wa. Tun-to̱ no̱m-to̱ u̱t-be̱e̱t na no̱mu̱g to̱ u̱ da-u̱ Mo̱ro̱g-du̱ u̱r-Be̱re̱di du̱ za m-Yis. ");
INSERT INTO gel_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Da-u̱ Here̱ maase̱ Biturus wa wu̱ wu̱n u̱ me̱ bu-u m-to̱k, wa wu̱ karma-ne̱ o̱p u̱ shishin e̱ e̱' wu̱n. Wa wa'ag jab u̱zu̱ ana tase̱ Mo̱ro̱g-du̱ za m-Yis, wa de̱ kwu̱pu̱ wu̱n u̱s-rem tu̱msu̱ wa wu̱n u̱r-ko̱b u̱-me̱ u̱t-ne̱t. ");
INSERT INTO gel_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Da-u̱ Biturus o̱ u̱ me̱ bu-u m-to̱k ban-du̱ a-doru̱ Ye̱so̱ hu̱ u̱ no̱m-du̱ u̱s-to̱o̱g u̱du̱ u-Ru̱ u̱ remu̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","U̱ te̱k-u̱ m-gyu̱p kanda Here̱ woot jab u̱zu̱ a is-u̱ gase̱ wa de̱ kwu̱pu̱ Biturus u̱s-rem, Biturus o̱ m-gag u̱ ho-su̱ kwam-ne̱ u̱s-yu̱r tu̱msu̱ wa o̱ m-roog u̱ te̱k-u̱ me̱ a-m-gag ne̱ yu̱r. Ne̱t-tu̱ o̱ e'-du̱ bu-u̱ m-to̱k e̱ o̱o̱g u̱ is bu-u̱ m-to̱k u̱r-e'. ");
INSERT INTO gel_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Za rem wa-To̱m u-Ru̱ rwu̱u̱n, zu̱n-mu̱ mok u-kur u-be̱e̱t. Se̱ wa-to̱m u-Ru̱ tu̱m Biturus u̱-kit wa zu̱st wu̱n. Wa zu̱ wu̱n, <<Yu̱ne̱!>> Se̱ ho-su̱ kwam ku̱smu̱sse̱ du̱gu̱ kom-u̱t Biturus. ");
INSERT INTO gel_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Wa-To̱m u-Ru̱ zu̱ wu̱n, <<Wa to̱ggo̱-u ró, u̱t-ka'at ne̱.>> Se̱ wa wu̱, wa-To̱m u-Ru̱ zu̱ wu̱n, <<Ho̱bge̱ bo̱rgo̱-u ró, bo̱ do̱ro̱n me̱.>> ");
INSERT INTO gel_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Se̱ Biturus yu̱ne wa dor wu̱n, wa nak u̱zu̱ no̱m-u̱ wa-To̱m u-Ru̱ o̱ u̱t-no̱m nip-to̱ da, wa kabu̱g u̱zu̱ bo̱-o̱ wa o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Da-u̱ u̱n arke̱ a-u̱r-e'-ne̱ i u̱r-taku̱n u̱ i u-yu̱ru̱mse̱ ne̱ u̱n te is-yu̱ u-kwam yu̱ cwa-du̱ gas-u̱ u-bo̱. Is-yu̱ upus u̱ hi-u̱r wa, se̱ u̱n ru, u̱n teeg be-du̱ fu̱n-yu̱ tu̱u̱ste̱, se̱ wa-to̱m u-Ru̱ yage̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Da tase̱ Biturus mu̱u̱n u̱ te̱k-u̱ dorog-u̱s se̱ wa zu̱, <<U̱ da-o̱ u̱m nak Ru̱-o̱ to̱mne̱ wa-to̱m-u̱ wa, wa u̱ku̱r me̱ du̱gu̱ kom-u̱t Here̱ tu̱msu̱ u̱ no̱m-u̱t yo̱-to̱ ne̱ tu̱ Yahuda-ne̱ o̱gu̱ zo̱ngte̱ no̱mu̱ me̱.>> ");
INSERT INTO gel_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Da-u̱ Biturus hyane̱ iya, se̱ wa hu̱ u̱ bu-u Me̱ri ne̱ ino-u Yohanna wu̱ na zu̱ye̱ Markus. Ku̱na ne̱t-tu̱ mo̱ro̱gte̱ e̱ o̱ u̱s-to̱o̱g. ");
INSERT INTO gel_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Da-u̱ wa ko̱o̱te̱ is-u̱ pyu̱ u-bu, e̱ke̱n gwu̱p-e̱, i o̱ m-ank u̱ bu-u o̱ wu̱na zu̱ye̱ Roda, wa rwu̱u̱n wa hyan wu̱ o̱ u̱-do̱. ");
INSERT INTO gel_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Da-u̱ wa nape̱ u̱zu̱ cwar-u Biturus ya, se̱ wa nom u̱r-so̱ sok. U̱ remu̱ u̱r-so̱ wa haag u̱ ups-u is da, se̱ wa jaru̱g m-so̱m m-mu̱ wa waru̱ u̱n u̱zu̱ Biturus o̱ ees u̱ is u-bu. ");
INSERT INTO gel_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Se̱ e̱ zu̱ wu̱n, <<Bo̱ o̱ u-dak!>> Se̱di Roda hen wa re shu̱ u̱ waru̱ u̱n u̱zu̱ Biturus wa, e̱ hen e̱ zu̱, <<Yar-u rò o̱.>> ");
INSERT INTO gel_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Biturus hu̱ ko̱o̱t u-is. Da-u̱ e̱ upse̱, e̱ hyen Biturus no̱m-u̱ ho e̱ mu̱rimmo̱ sok. ");
INSERT INTO gel_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Wa hen wa no̱mu̱ u̱n u-kom u̱zu̱ u̱n ho̱ u̱s-ram, u̱ da-u o̱ wa waru̱ u̱n u̱ka Ru̱-u̱ rwu̱ttu̱n wu̱n u̱ me̱ bu-u̱ m-to̱k. Tu̱msu̱ wa zu̱, <<Waru̱n Yakubu u̱ o̱r-u̱t ri ne̱ be̱e̱t rem-u̱s sin-se̱>> Du̱gu̱ ku̱n wa yu̱ne̱ wa do̱'e̱ u̱ de̱ku̱n be-de̱. ");
INSERT INTO gel_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Da-u̱ is gase̱, gwu̱z yu̱ne̱ u̱ te̱k-u̱ me̱ a-m-gag ne̱ u̱ remu̱ no̱mu̱ kume̱ Biturus. ");
INSERT INTO gel_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Da-u̱ Here̱ wa'e̱ karma-ne̱ goot wu̱n e̱ hyanu̱g Biturus da. Se̱ wa no̱mu̱ u̱n u̱r-shu̱t u̱zu̱, <<¿Remu̱ u-yan o̱ no̱ yakte̱ Biturus ruut?>> E̱ kerge̱ zu̱du̱ o̱ko̱n da. Se̱ wa zu̱ karma-ne̱, e̱ kab karma-ne̱ i no̱me̱ u̱r-e' e̱ do̱'e̱ e̱ ho̱rru̱sse̱ e̱. Du̱gu̱ ku̱n se̱ Here̱ aru̱k m-ha Yahudiya tu̱msu̱ wa no̱mo̱n u̱t-ho̱ cashi Kasariya. ");
INSERT INTO gel_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","U̱ te̱k-u̱ da-u̱ o̱ Here̱ hog u̱s-ryab u̱ ne̱t-tu̱ Taya u̱ Sido̱n ne̱. Se̱ u̱n du̱g to̱ko̱n ne̱t-to̱ e̱ haan u̱du̱ Here̱. U̱n baag u̱ kwu̱ng u̱r-be̱b du̱gu̱-du̱ Biratus yu̱-shu̱ i o̱ m-ank u̱-me̱ u-pada u̱zu̱ wa waru̱ Here̱ u̱zu̱ u̱n o̱ sa-u̱ shu̱'u̱t-du̱ m-yar u̱ wane̱ remu̱ zu̱ du̱ ro de̱ u̱n wu̱te̱ jab-u̱ kwu̱m-du̱ no̱m u̱t-re̱. ");
INSERT INTO gel_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","U̱ te̱k-u̱ ho̱-du̱ u̱n dage̱, Here̱ Faru̱k wu̱ cwu̱-tu̱ u̱r-faru̱k, wa shu̱'u̱t u̱ pora-du̱ u̱r-faru̱k wa no̱mu̱ u̱t-ne̱t u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Da-u̱ ban-du̱ u̱t-ne̱t ho̱ge̱ iya, se̱ e̱ yu̱ns u̱s-cwar u̱n hu̱ u̱t-zu̱, <<Ho̱go̱n sin-se̱, Cwar-yu̱ o̱ko̱n ru̱-u̱ o̱, yu̱ ne̱t ya da.>> ");
INSERT INTO gel_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Za rem, ku̱na wa-To̱m u-Ru̱ gu̱pte̱ wu̱n, remu̱ zu̱ wa no̱ngu̱ u-Ru̱ m-sek da, se̱ zwatu̱ hu̱ re̱-du̱ wu̱n har wa mu̱ru̱s. ");
INSERT INTO gel_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Se̱ rem-su̱ u-Ru̱ re u-shu̱ m-cwa ko he̱ne̱, Ne̱t-tu̱ kabe̱ Ye̱so̱ hu̱ swu̱ru̱n. ");
INSERT INTO gel_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Da-u̱ e̱ tase̱ pama-u e̱, se̱ Baraba e̱ Shawuru mu̱u̱n du̱gu̱ Urusharima. E̱ mu̱u̱n u̱ Yohanna ne̱ wu̱ na zu̱ye̱ Markus. ");
INSERT INTO gel_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","U̱-me̱ a-doru̱ Ye̱so̱ u̱ i o̱o̱ge̱ u̱ Antakiya u̱ dak-u̱ Siriya-ne̱ a-warru̱ rem-su̱ u-Ru̱ u̱ a-u̱t-ko̱se̱ ne̱, wato: Baraba e̱ Simiyo̱n wu̱ na zu̱ye̱, <<Ne̱t-u̱ rim-o̱,>> U̱ Rushiyo̱s du̱gu̱ Sayirin, U̱ Manayen wu̱ yu̱ne̱ u̱r-kot e̱ Here̱ Antipas Faru̱k, Tu̱msu̱ u̱ Shawuru. ");
INSERT INTO gel_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Da-u̱ e̱ o̱o̱ge̱ no̱mu̱ u-Ru̱ u̱t-huuk, u-swaat ne̱, se̱ Yar-u̱ u-Ru̱ zu̱, <<Ku̱ngu̱ssu̱n me̱ Baraba e̱ Shawuru remu̱ pama-u̱ u̱m dagu̱ u̱n u̱n no̱m.>> ");
INSERT INTO gel_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Da-u̱ u̱n tase̱ u-swaat u̱s-to̱o̱g ne̱, se̱ u̱n doru̱ Baraba e̱ Shawuru u̱t-kom u̱n wa-u̱ u̱n nu-u so̱-o̱, remu̱ pama-u̱ Ru̱-u̱ ya e̱, u̱n zu̱ e̱, e̱ aru̱k. ");
INSERT INTO gel_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Da Yar-u u-Ru̱ to̱me̱ Baraba e̱ Shawuru, e̱ do̱'e̱ u̱ bo̱-u̱ Sarukiya, du̱gu̱ ku̱n u̱n to u̱-me̱ u-hat m-ha Sayifurus. ");
INSERT INTO gel_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Da u̱n teye̱ bo̱-u̱ Saramis, u̱n wu̱r rem-su̱ u-Ru̱ u̱ Kur-u̱ u̱t-Ko̱se̱ u̱ Yahuda-ne̱ tu̱ Yahuda-ne̱. Yohanna e̱ Markus o̱ u̱r-kot u̱ u̱n ne̱, wa o̱ se̱gu̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Da-u̱ u̱n tase̱ narru̱ Sibirin u-be̱e̱t m-ha da-u̱ u̱n tene̱ bo̱-u̱ Bafos. Ku̱na u̱n goton u̱ waku̱n wa-u-gwat wa ne̱, wu̱na foge̱ Wa'-u̱ Joshuwa. Wa-Yahuda wa, wu̱ ko̱se̱ u̱zu̱ wa-warru̱ rem-su̱ u-Ru̱ wa, se̱di wu̱ u̱s-bi wa. ");
INSERT INTO gel_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Wa o̱ hu̱u̱b-u̱ Wa-u-dak Sarjiyus Burus, Burus ne̱t wa-m-nap ne̱ sok. Se̱ wa fog Baraba e̱ Shawuru remu̱ zu̱ wa u̱t-sa wa ho̱g rem-su̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Se̱ Arimas wa-u̱ Joshuwa wa-u-gwatu̱ wa, wa gu̱gu̱m do̱rru̱ rem-u̱s u̱n, wa u̱t-sa wa par Wa-u-dak a wa ya' jab u̱du̱ Ye̱so̱ da. ");
INSERT INTO gel_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Se̱ Shawuru wu̱ na zu̱ye̱ Burus, Yar-u u-Ru̱ dor-u̱t wa, se̱ wa saku̱ Arimas u̱r-is. ");
INSERT INTO gel_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Wa zu̱, <<Bo̱ wa'-u̱ faru̱k-u̱ no̱m u̱s-te! Bo̱ tonte̱ no̱m-u so̱-o̱ da, bo̱ o̱tte̱ jab-u̱ rak-su̱ u̱t-ne̱t, u̱ jab-u̱ yo̱-o̱ ne̱. Yage̱ bargu̱ssu̱ nip-u̱t Wa-ko-uyan u̱s-bi ");
INSERT INTO gel_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","U̱ da-o̱ hen Ru̱-u̱ de̱ ya bo̱ u̱r-ko̱b, bo̱ de̱ u̱t-shu̱'u̱t po̱. Bo̱ de̱ no̱m-du̱ u-da, bo̱ za hyan-du̱ zu̱n-mu̱ u̱r-ho̱ da.>> Za rem se̱ wa po̱, u̱ka wu̱ o̱ u̱-me̱ u-cwu̱m, se̱ wa hu̱ pama u̱t-vu̱bu̱g remu̱ wa kum-u̱t wu̱ de̱ shu̱p-du̱ wa u-kom wa nak-du̱ wa. ");
INSERT INTO gel_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Da-u̱ Wa-u-dak hyane̱ no̱m-u̱ no̱me̱, se̱ wa yu̱' jab wa o̱ mu̱rimmo̱ u̱ ko̱se̱-tu̱ Wa-ko-uyan Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Se̱ Burus u̱ hu̱u̱b-u̱t wa ne̱ yu̱ne̱ du̱gu̱ Bafos u̱ me̱ u-hat, e̱ do̱'e̱ u̱ Ferga u̱ dak-u̱ Famfiriya. Yohanna wu̱ na zu̱ye̱ Markus wa som u̱n, wa mu̱ u̱ Urusharima. ");
INSERT INTO gel_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","U̱n hen u̱n re shu̱ du̱gu̱ Ferga, u̱n do̱'e̱ u̱ bo̱-u̱ Antakiya u̱ dak-u̱ Bisidiya. U̱ Ho̱-du̱ u̱r-Hure̱ Yahuda-ne̱ u̱n cwaag u̱ Kur-u̱ u̱t-Ko̱se̱ u̱n shu̱'u̱t. ");
INSERT INTO gel_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Da-u̱ na tase̱ m-karu̱nte̱ du̱gu̱ ko̱se̱-u̱t Mosa, u̱ ran-tu̱ a-warru̱ rem-su̱ u-Ru̱ ne̱, se̱ yu̱-shu̱ bu-u̱ u̱t-ko̱se̱ tom u̱du̱ u̱n u̱zu̱, <<O̱r-u̱t it, a no̱ o̱tte̱ no̱mu̱ no̱ de̱ waru̱ ne̱t-u̱t tun-to̱ no̱ swu̱r-tu̱ e̱ shiriktin-mu̱ jab, waru̱n it.>> ");
INSERT INTO gel_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Se̱ Burus yu̱ne̱ u̱r-es, wa jaku̱s kom-u̱ u̱s-cwa rò u̱ka ne̱t-tu̱ do̱te̱ e̱r-ru̱ wu̱n. Se̱ wa zu̱, <<No̱ o̱r-u̱t ri Isra-ne̱, u̱ i za-Yahuda-ne̱ da, i no̱me̱ u-Ru̱ u̱t-huuk, ho̱o̱n u̱s-ram. ");
INSERT INTO gel_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ru̱-u̱ it Isra-ne̱ no̱me̱ u̱t-huuk, wa dak u̱so-tu̱ u̱so-u̱t in e̱ shu̱'u̱t ne̱t-u̱t wa, tu̱msu̱ wa wa'ag e̱ sur u-tát, da-u̱ e̱ o̱o̱ge̱ u̱r-yu̱ u̱ dak-u̱ Masar. Da-u̱ hak-su̱ arke̱, Ru̱-u̱ se̱kku̱ u̱n u̱ be̱b-u̱r wa. Wa rwu̱tu̱n du̱gu̱ dak-u o̱. ");
INSERT INTO gel_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Wa kere̱ gag-du̱ jab-u̱ u̱n ne̱ m-te u̱s-hak u̱t-shik u̱t-yu̱r u̱ me̱ u̱r-do̱g. ");
INSERT INTO gel_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Da-u̱ wa wa'e̱ Isra-ne̱ re u̱t-rem u̱t-ta'er m-gag i o̱o̱ge̱ u̱r-yu̱ u̱ dak-u̱ Kan'ana, wa ye Isra-ne̱ kwu̱m-tu̱ dak-u o̱. ");
INSERT INTO gel_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tunto̱ no̱m-to̱ u̱t-be̱e̱t, na no̱ng to̱ u̱ te̱k-u̱ u̱s-hak u̱t-ko̱k u̱t-nas u̱t-shik u̱t-yu̱r u̱ o̱p. <<Da tase̱ Ru̱-u̱ wa'-u̱ u̱n a-kwu̱p-du̱ u̱s-rem ne̱, har u̱ haan u̱ da-u wa-warru̱ rem-su̱ u-Ru̱ Samaira. ");
INSERT INTO gel_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","U̱ da-u o̱ u ko̱n u̱ na ya' u̱n faru̱k wu̱ de̱ shu̱'u̱tu̱ faru̱ku̱ u̱n. Se̱ Ru̱-u̱ ye u̱n Shawuru wa'-u̱ Kish, ne̱t u̱ ko̱-u̱r Banyami, wu̱ no̱me̱ u̱r-faru̱k u̱s-hak u̱t-shik u̱t-yu̱r. ");
INSERT INTO gel_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Da-u̱ Ru̱-u̱ haste̱ Shawuru, wa ye' u̱n Dawuda wa shu̱'u̱t faru̱k-u̱ u̱n. Ru̱-u̱ no̱ng u̱s-rem u̱ Dawuda u̱zu̱, <U̱m byu̱k-u̱t Dawuda wa'-u̱ Jesse, ne̱t wa wu̱ u̱t-sa wa no̱m no̱m-u̱ u̱m u̱t-sa. Tu̱msu̱ wa de̱ no̱m-du̱ no̱m-u̱ u̱m u̱t-sa u-be̱e̱t.> ");
INSERT INTO gel_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","<<Du̱gu̱ ko̱-u̱r ne̱t uno̱ Ru̱-u̱ hattu̱n Isra-ne̱ Wa-u-U̱ku̱r, Ye̱so̱, u̱ka wa este̱ u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kanda haan-u̱r Ye̱so̱, Yohanna Wa-u̱t-yu̱bu̱sse̱ m-bu̱ wargu̱ ne̱t-tu̱ Isra-ne̱ u̱t-be̱e̱t e̱ yage̱ u̱t-ba'as tu̱msu̱ e̱ ko̱n u-Ru̱ wu̱ nome̱ u̱r-ho̱, na no̱mu̱ e̱ u̱t-yu̱bu̱sse̱ m-bu̱. ");
INSERT INTO gel_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Da Yohanna ha taas no̱m-u̱ wa u̱t-no̱m, se̱ wa zu̱, <¿No̱ o̱ m-hyan me̱ wa o̱ Kiristi, wu̱ Ru̱-u̱ nomte̱ este̱du̱ u̱s-rem wa u̱t-to̱mo̱n? Me̱ wa da. Se̱di Kiristi de̱ haan za m-tumb. U̱m ko̱rge̱ u̱m ust go̱r-su̱ ka'at-u̱t wa da.> ");
INSERT INTO gel_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","<<No̱ o̱r-u̱t ri, ko̱-u̱r Ibrahi, tu̱msu̱ u̱ i za-yahuda-ne̱ da I no̱me̱ u-Ru̱ u̱t-huuk, u̱du̱ in do̱'e̱ Ru̱-u̱ to̱mtu̱n rem-su̱ u-u̱ku̱r u̱ sin-se̱. ");
INSERT INTO gel_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Remu̱ zu̱ i o̱ shu̱'u̱t u̱ Urusharima u̱ i-yate̱ ne̱ be̱e̱t e̱ nak u̱zu̱ wu̱na o̱ Wa-u-U̱ku̱r da. Ko-uyan ho̱-du̱ u̱r-hure̱ de̱ du̱ Yahuda-ne̱, u̱n karu̱nte̱ no̱m-tu̱ Wa-warru̱ rem-su̱ u-Ru̱ pane̱, u̱n gwa'ag nu-du̱ no̱m-u̱ wa-warru̱ rem-su̱ u-Ru̱ pane̱ u̱ mo̱ttu̱ Ye̱so̱ Kiristi da. U̱n no̱mu̱g no̱mu̱ shu̱u̱ste̱ rem-su̱ a-warru̱ rem-su̱ u-Ru̱ ne̱ ware̱, remu̱ ho̱-du̱ Ye̱so̱ du̱ u̱n no̱me̱. ");
INSERT INTO gel_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ko ba shu̱'u̱te̱ u̱zu̱ na byu̱k-u̱t wa u̱t-ba'as ne̱ tu̱ ko̱re̱ na ho wa da, se̱di ne̱t-tu̱ kon Biratus u̱zu̱ na ho̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","U̱n no̱ngu̱ Ye̱so̱ no̱m-u̱t to̱ u̱t-be̱e̱t tu̱ A-warru̱ rem-su̱ u-Ru̱ ne̱ pane̱ m-tumb ne̱ u̱zu̱ ne̱t-to̱ no̱mu̱ wu̱n. U̱n cu̱stu̱n war-u ro du̱gu̱ do̱m u-kan u̱n cin u̱-me̱ u-sag. ");
INSERT INTO gel_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Se̱di Ru̱-u̱ yu̱ns wu̱n du̱gu̱ marimari-ne̱. ");
INSERT INTO gel_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","U̱t-ho̱ u-tát u ko̱se̱ hi-u̱r ro u̱du̱ i no̱ke̱ u̱ wu̱n ne̱ m-ha du̱gu̱ Gariri m-ha Urusharima. U̱n shu̱'u̱te̱ u̱ka i hyane̱ tu̱msu̱ e̱ o̱ war-ru̱ rem-u̱s ro u̱du̱ u̱t-ne̱t u̱ da-o̱. ");
INSERT INTO gel_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","<<It o̱ waru̱ no̱ Rem-su̱ m-Re̱me̱r, no̱m-u̱ Ru̱-u̱ este̱ u̱s-rem u̱du̱ u̱so-tu̱ u̱so-u̱t in, ");
INSERT INTO gel_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","tu̱msu̱ Ru̱-u̱ shu̱u̱ste̱ to̱ u̱ remu̱ in yaag-u̱ u̱n, remu̱ yu̱nsu̱ Ye̱so̱, u̱ka o̱tte̱ m-pam u̱ o̱ko̱n se̱p-o̱ u-me̱ Ran-u̱ Se̱p-u̱ u̱t-Vam: << <Bo̱ o̱ wa'-u̱ ri, u̱m o̱ u̱so-u ro u̱ ya-o̱.> ");
INSERT INTO gel_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ru̱-u̱ yu̱nste̱ Ye̱so̱ du̱gu̱ marimari-ne̱, se̱ ko̱ske̱ u̱zu̱ hen Ye̱so̱ za m-mar ko u̱t-zu̱m da. Ru̱-u̱ no̱ng no̱mu̱ wa zu̱ wa u̱t-no̱m da-u̱ wa yu̱nse̱ Ye̱so̱ du̱gu̱ marimari-ne̱. Da-u̱ Ru̱-u̱ zu̱ye̱, <U̱m de̱ hen u̱ se̱gu̱ no̱ ne̱t-u̱t ri u̱ka u̱m no̱m-tu̱ Dawuda este̱du̱ u̱s-rem u̱ no̱mu̱ u̱m de̱ u̱t-no̱m.> ");
INSERT INTO gel_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","U̱-me̱ Ran-u̱ Se̱p-tu̱ u̱t-vam, o̱ko̱n Se̱p-u̱ u̱t-vam o̱ zu̱u̱g, <Bo̱ za u̱t-yage̱ u̱ Wa-u-he̱n u̱ ro u̱ zu̱m da.> ");
INSERT INTO gel_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","<<Da-u̱ Dawuda o̱o̱ge̱ u̱r-fat, wa no̱mo̱g no̱m-u̱ Ru̱-u̱ wa'e̱ wa u̱t-no̱m. Se̱ wa mu̱r, ne̱t-tu̱ jwak wa, u̱ka e̱ nomte̱ u̱so-tu̱ u̱so-u̱t wa, tu̱msu̱ war-u ro zu̱mu̱s. Sin-se̱ ko̱ske̱ u̱zu̱ Dawuda rem-su̱ hi-u̱r wa se̱ wa o̱tte̱ u̱-me̱ Se̱p-u̱ u̱t-vam uno̱ da. ");
INSERT INTO gel_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Se̱di Ye̱so̱ wu̱ Ru̱-u̱ yu̱nse̱ du̱gu̱ m-mar wa zu̱mu̱g u̱-me̱ u-sag da. ");
INSERT INTO gel_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","<<Remu̱ iya o̱r-u̱t ri, u̱m u̱t-sa no̱ nap u̱zu̱ u̱-me̱ Ye̱so̱ inya o̱ it no̱m-tu̱ no̱ do̱nse̱-du̱ yage̱-du̱ u̱t-ba'as. ");
INSERT INTO gel_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","U̱m o̱ hen u̱ waru̱ no̱, u̱-me̱ Ye̱so̱, ne̱t be̱e̱t wu̱ ya' jab u̱du̱ wu̱n, wa u̱t-kwu̱m u-u̱ku̱r du̱gu̱ u̱t-ba'as, u̱ku̱r u̱ wa kume̱ u̱ te̱k-u̱ me̱ bo̱r-tu̱ Mosa pane̱ da. ");
INSERT INTO gel_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Gwatu̱n hi-u̱t no̱ so̱k tas no̱mu̱ Ru̱-u̱ ware̱ u̱-me̱ ran-tu̱ a-warru̱ rem-su̱ u-Ru̱ u̱ kum no̱ da, u̱zu̱, ");
INSERT INTO gel_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","<< <Ho̱go̱n no̱ a u-shiga ne̱! No̱ no̱m mu̱rimmo̱, no̱ mar. U̱m de̱ no̱m-du̱ o̱ko̱n u̱ te̱k-u̱ ho̱-u̱t no̱, u̱ no̱ zatte̱ yadu̱ jab da, Ko waku̱n wargu̱ no̱.> >> ");
INSERT INTO gel_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Burus e̱ Baraba o̱ m-rwu̱ u̱-me̱ Kur-u̱ u̱t-Ko̱se̱ se̱ ne̱t-tu̱ kon u̱n, u̱n sur m-no̱m u̱s-rem. U̱n zu̱ Burus ne̱ u̱ no̱m rem-u̱s se̱ u̱ Ho̱-du̱ u̱r-Hure̱ du̱ o̱o̱ne̱. ");
INSERT INTO gel_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Da-u̱ ne̱t-tu̱ bu̱rge̱ du̱gu̱ Kur-u̱ u̱t-Ko̱se̱, Yahuda-ne̱ u̱ u̱t-ne̱t ne̱ u-tát u̱ i barme̱ e̱ dor fu̱n-u Yahuda-ne̱, e̱ dor Burus e̱ Baraba. E̱ hen e̱ ye' u̱n shiriktin-mu̱ jab. Burus baku̱stu̱n u̱n, u̱n no̱m u̱r-yu̱ u̱ nap-mu̱ nya-u u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Da-u̱ Ho̱-du̱ u̱r-Hure̱ byu̱r-ne̱, u̱ka ne̱t-tu̱ bo̱-u o̱ u̱t-be̱e̱t e̱ karu̱gte̱ u̱ remu̱ e̱ hog-u̱t rem-su̱ Wa-ko-uyan. ");
INSERT INTO gel_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Da-u̱ e̱ke̱n Yahuda-ne̱ hyane̱ mo̱ro̱g-du̱ u̱t-ne̱t no̱ng u-tát, e̱ hu̱ u̱r-shu̱b, e̱ hu̱ se̱-mu̱ no̱mu̱ Burus ware̱, tu̱msu̱ e̱ hu̱ pepru̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Burus e̱ Baraba nom u̱s-rem za u-gye̱r. E̱ zu̱, <<No̱ Yahuda-ne̱, kamu̱g it he̱e̱se̱ no̱mu̱ no̱ Yahuda-ne̱ bu̱t-tu̱ rem-su̱ u-Ru̱ u̱r-taku̱n. Ba shu̱'u̱te̱ no̱ gu̱gu̱mte̱ se̱, tu̱msu̱ no̱ ko̱ske̱ u̱zu̱ no̱ kamu̱g kwu̱m-du̱ fat-du̱ za u̱r-ma da, remu̱ iya hen it de̱ u̱t-ha u̱du̱ i za-yahuda-ne̱ da. ");
INSERT INTO gel_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Remu̱ zu̱, Wa-ko-uyan baag u̱ wargu̱ it u̱zu̱, << <U̱m wa'ag bo̱ shu̱'u̱t m-zu̱n u̱du̱ i za-yahuda-ne̱ da, Remu̱ bo̱ hattu̱n to̱m u̱zu̱ Ru̱-u̱ de̱ no̱mu̱ it u-u̱ku̱r ko̱he̱ne̱ u̱-me̱ u-dak.> >> ");
INSERT INTO gel_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Da-u̱ i za-yahuda-ne̱ da ho̱ge̱ rem-u̱s se̱, e̱ hu̱ u̱r-so̱ sok. E̱ vom Wa-ko-uyan Ye̱so̱ remu̱ rem-u̱s wa. I za-yahuda-ne̱ da i Ru̱-u̱ dage̱ remu̱ kwu̱m-du̱ fat-du̱ za u̱r-ma'e̱ yu̱' jab. ");
INSERT INTO gel_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Rem-u̱s Wa-ko-uyan re shu̱ u̱r-cwa ko̱he̱ne̱ u̱ dak-u o̱ u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Se̱di to̱ko̱n tu̱-shu̱ tu̱ Yahuda-ne̱ zu̱ngu̱sse̱ to̱ko̱n ne̱ta to̱ tu̱ na o̱ m-ho̱g u̱ e̱ ne̱ u̱-me̱ u-bo̱ u̱ to̱ko̱n ne̱ta-to̱ ne̱ i za-yahuda-ne̱ da, i no̱me̱ u-Ru̱ u̱t-huuk. I za-yahuda-ne̱ da e̱ he̱e̱se̱ yadu̱ Burus u̱ Baraba ne̱ u̱r-ko̱b. Remu̱ iya, e̱ buz u̱n du̱gu̱ bo̱-u e̱. ");
INSERT INTO gel_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Da-u̱ a-To̱mu̱ Ye̱so̱ o̱ mo̱ttu̱ u̱r-aru̱k, e̱ pamtu̱sse̱ huug-mu̱ naas e̱ remu̱ u̱ shu̱'u̱te̱ u̱s-nap u̱du̱ tu̱-shu̱ Yahuda-ne̱ u̱zu̱ Ru̱-u̱ gu̱gu̱mte̱ u̱n tu̱msu̱ wa de̱ yadu̱ u̱n u̱r-ko̱b. E̱ aru̱k u̱ bo̱-u̱ Ikoniya. ");
INSERT INTO gel_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","A-doru̱ Ye̱so̱ i o̱ u̱ bo̱-u̱ Antakiya e̱ hu̱ u̱r-so̱, tu̱msu̱ Yar-u u-Ru̱ dor-u̱t e̱. ");
INSERT INTO gel_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","U̱ Ikoniya Burus e̱ Baraba cwaag u̱ka e̱ vette̱ u̱ Kur-u̱ u̱t-Ko̱se̱ u̱ Yahuda-ne̱ u̱ka e̱ vette̱. E̱ waru̱g rem-su̱ u-Ru̱ u̱ be̱b-du̱ Yar-u u-Ru̱, u̱t-ne̱t u-tát Yahuda-ne̱ u̱ i za-Yahuda-ne̱ da e̱ yu̱' jab. ");
INSERT INTO gel_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Se̱di e̱ke̱n Yahuda-ne̱ gu̱gu̱mte̱ yadu̱ jab. E̱ hu̱ yadu̱ i za-Yahuda-ne̱ da u̱s-rem. M-vaste̱ e̱ke̱n i za-Yahuda-ne̱ da hu̱ ho̱g-du̱ ryab-su̱ a-doru̱ Ye̱so̱ i o̱ u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ko ba shu̱'u̱te̱ iya Burus e̱ Baraba tumbte̱ u̱ku̱n sok, e̱ warru̱ rem-su̱ u-Ru̱ jab gan u̱ be̱b-du̱ Wa-ko-uyan. Wa-ko-uyan Ye̱so̱ yaag u̱n u̱r-be̱b du̱ no̱m-du̱ no̱m-tu̱ m-shin, u̱s-nap ne̱ u̱t-ko̱se̱ u̱zu̱ bu̱t-u̱t u̱n nip-to̱. ");
INSERT INTO gel_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ne̱t-tu̱ bo̱-u o̱ mot u-so u-yu̱r, e̱ke̱n o̱ do̱rru̱ Yahuda-ne̱, tu̱msu̱ e̱ke̱n o̱ do̱rru̱ a-To̱mu̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Se̱ i za-yahuda-ne̱ da u̱ tu̱-shu̱ Yahuda-ne̱, e̱ zo̱ngte̱ e̱ ya' a-To̱m u̱r-ko̱b, tu̱msu̱ e̱ bong e̱ u̱t-ta'ar. ");
INSERT INTO gel_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Da-u̱ a-to̱mu̱ Ye̱so̱ ne̱ ho̱ge̱ iya, e̱ som m-ha u̱ bo̱-tu̱ Risitira u̱ Darbe ne̱ u̱ ta'as-tu̱ gu̱r-u o̱ u̱-me̱ dak-u̱ Rikoniya. ");
INSERT INTO gel_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ku̱na u̱n rete̱ shu̱ u̱ warru̱ Rem-su̱ m-Re̱me̱r. ");
INSERT INTO gel_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","U̱ Risitira yaku̱n campa-ya o̱ro ryam, wa tamu̱g no̱m-du̱ m-ha da du̱gu̱ da-u̱ na matu̱ wa. ");
INSERT INTO gel_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Wa o̱ e̱rru̱ no̱mu̱ Burus o̱ u̱t-war. Se̱ Burus saku̱ wu̱n u̱r-is. Da-u̱ Burus hyane̱ ne̱tu̱ wa o̱tte̱ yadu̱ jab-u̱ ko̱re̱ na hastu̱ wa u̱s-go̱m, ");
INSERT INTO gel_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","se̱ wa yu̱ns u-cwar u̱r-be̱b ne̱. Wa zu̱, <<Yu̱ne̱ bo̱ ees u̱ na-u̱s ró!>> Da-u̱ campa-u ya ho̱ge̱ iya, se̱ wa tu̱ mak wa yu̱ne̱ wa he̱e̱se̱ m-ha. ");
INSERT INTO gel_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Da-u̱ mo̱ro̱g-du̱ u̱t-ne̱t hyane̱ no̱mu̱ Burus no̱me̱, se̱ e̱ jaku̱s u̱s-cwar u̱ rem-u̱r Rikoniya-ne̱. U-da u-gan e̱ zu̱, <<U̱t-nip, ru̱-tu̱ hagu̱n u̱du̱ in u̱ wartu̱ u̱t-ne̱t!>> ");
INSERT INTO gel_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Se̱ e̱ ye Baraba u̱r-dim Zeyus, Burus hen e̱ zu̱ wa Hame̱s, remu̱ zu̱ wu̱na o̱o̱ge̱ wa hi-du̱ u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Se̱ Wa-u̱s-to̱o̱g u̱ m-giru̱ Zeyus, wu̱ kur-u̱ m-giru̱ wa o̱ u̱-do̱ u-bo̱, wa hatu̱n na u̱ u̱t-pyaku̱t ne̱ u̱ is u-bo̱. Wa-u̱s-to̱o̱gu̱ m-gir u̱ ne̱t-u̱t wane̱ e̱ u̱t-sa e̱ no̱mu̱ Burus ne̱ e̱ Barabas to̱o̱g. ");
INSERT INTO gel_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Da-u̱ a-to̱mu̱ Ye̱so̱ Baraba e̱ Burus ho̱ge̱ iya, se̱ e̱ keem to̱ggo̱-u̱s e̱ remu̱ namu̱ jab. U̱n to u̱ me̱ ban-du̱ u̱t-ne̱t m-so̱m u̱t-jar u̱n o̱ u̱t-zu̱, ");
INSERT INTO gel_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","<<¿Remu̱ u-yan o̱ no̱ o̱tte̱ u̱t-no̱m inya? It ne̱t-to̱ u̱ka no̱. It hattu̱n no̱ Rem-su̱ m-Re̱me̱r, u̱ remu̱ zu̱ no̱ yakte̱ no̱m-tu̱ m-zan, no̱ byu̱ru̱n u̱du̱ u-Ru̱ wu̱ u̱r-fat, wu̱ no̱me̱ u-dak u̱ do̱m u-ru̱ ne̱, m-sa u̱ ko-uyan u̱ no̱m-tu̱ o̱ me̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","U̱ da-u̱ dim, Ru̱-u̱ yakke̱ i za-yahuda-ne̱ da e̱ no̱m u̱t-huuk u̱du̱ ru̱-tu̱ e̱ o̱ u̱t-cwan. ");
INSERT INTO gel_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ko ba shu̱'u̱te̱ iya u tamu̱g yage̱ hi-u̱r wa za u̱s-nap da. Wu̱na yu̱'e̱ na m-bu̱ mu̱ u-yu̱ tu̱msu̱ wa wu̱ no̱m-tu̱ na kawe̱ to̱ rogom. Wa shu̱ku̱s na u̱ no̱m u̱t-re̱, tu̱msu̱ wa ye na jab-u̱ pus-o̱.>> ");
INSERT INTO gel_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ko ba u̱n no̱me̱ rem-u̱s se̱, Burus ne̱ e̱ Barabas kerge̱ hosu̱ ne̱t-u̱t to̱ no̱m-du̱ to̱o̱g u̱ remu̱ u̱n da. ");
INSERT INTO gel_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Se̱di e̱ke̱n Yahuda-ne̱ haan du̱gu̱ Antakiya u̱ Ikoniya ne̱ e̱ pu̱r ban-du̱ u̱t-ne̱t, e̱ bong Burus u̱t-ta'ar. E̱ nu̱k wu̱n m-ha u̱ u̱-do̱ u-bo̱, e̱ rest wu̱n u̱zu̱ wa maru̱g. ");
INSERT INTO gel_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Da-u̱ a-doru̱ Ye̱so̱ kate̱ wu̱n, se̱ wa yu̱ne̱ wa to u̱ me̱ u-bo̱. Da is gase̱ wa do̱'e̱ u̱ Darbe e̱ Baraba. ");
INSERT INTO gel_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Da Burus e̱ Baraba ware̱ Rem-su̱ m-Re̱me̱r u̱ Darbe, e̱ kum a-doru̱ Ye̱so̱ u-tát. Tu̱msu̱ e̱ mu̱gu̱n u̱ Risitira, u̱ Ikoniya ne̱, u̱ Antakiya u̱ dak-u̱ Bisidiya ne̱. ");
INSERT INTO gel_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","E̱ o̱ swu̱ru̱ a-dor Ye̱so̱ shiriktin-mu̱ jab, e̱ o̱ yadu̱ u̱n u̱s-rem u̱zu̱ e̱ re̱ shu̱ u̱ yadu̱ jab. E̱ zu̱, <<Se̱ it swaag u̱r-ko̱b sok kanda it to-u̱t u̱ Faru̱k-du̱ u-Ru̱.>> ");
INSERT INTO gel_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Burus e̱ Baraba du̱g u̱t-ne̱nge̱n du̱gu̱ ko̱-u̱-he̱ a-doru̱ Ye̱so̱ ne̱ be̱e̱t. E̱ nom u̱s-to̱o̱g u-swaat ne̱, e̱ yage̱ u̱n u̱ kom-tu̱ u-Ru̱ wu̱ e̱ ya jab u̱du̱ wa. ");
INSERT INTO gel_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","E̱ do̱ro̱g dak-u̱ Bisidiya m-ha u̱ dak-u̱ Famfiriya. ");
INSERT INTO gel_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","E̱ waru̱g rem-su̱ u-Ru̱ u̱ bo̱-u̱ Ferga, tu̱msu̱ e̱ do̱'e̱ u̱ bo̱-u̱ Atariya. ");
INSERT INTO gel_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Du̱gu̱ ku̱n u̱n to u̱-me̱ u-hat u̱n mu u̱ bo̱-u̱ Antakiya u̱ gu̱r-u̱ Siriya. Ku̱na a-dor Ye̱so̱ ne̱ tomte̱ Burus e̱ Barabas e̱ do̱'e̱ u̱ to̱ko̱n be-to̱ e̱ no̱m u̱t-bu̱t. Antakiya be-de̱ du̱ a-dor-ne̱ konte̱ u-Ru̱ wa se̱gu̱ Burus e̱ Barabas u̱ pama-u̱ e̱ tase̱ u̱ da-o̱. ");
INSERT INTO gel_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Da-u̱ u̱n teene̱, u̱n kargu̱sse̱ a-doru̱ Ye̱so̱ ne̱. U̱n ware̱ u̱n no̱mu̱ Ru̱-u̱ ya u̱n be̱b-du̱ u̱t-no̱m, tu̱msu̱ e̱ waru̱ u̱n u̱ka Ru̱-u̱ se̱g-tu̱ ne̱t-tu̱ za-Yahuda-ne̱ da u̱ka e̱ yu̱te̱ jab u̱du̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","U̱n tumbte̱ u̱ku̱n u̱r-kot u̱ a-dor-ne̱. ");
INSERT INTO gel_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","To̱ko̱n ne̱t-to̱ haan u̱ Antakiya du̱gu̱ gu̱r-u̱ Yahudiya, e̱ o̱ no̱mu̱ a-dor u̱t-ko̱se̱ u̱zu̱, <<Ana no̱mu̱ no̱ u̱r-pe̱s u̱ka bo̱r-u̱t Mosa zu̱tte̱ da, no̱ za kwu̱m-du̱ u-u̱ku̱r da.>> ");
INSERT INTO gel_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","No̱m-u̱t to̱ haatu̱n mo̱t-du̱ u̱t-hi u̱du̱ Burus ne̱ e̱ Baraba e̱ nom inan u̱ u̱n ne̱. Du̱gu̱ ku̱n u̱n tok Burus e̱ Baraba u̱ e̱ke̱n a a-doru̱ Ye̱so̱ ne̱, e̱ do̱'e̱ u̱ Urusharima u̱du̱ a-To̱mu̱ Ye̱so̱ ne̱ u̱ to̱ko̱n ne̱nge̱n-to̱ ne̱, remu̱ e̱ nom-u̱t rem-u̱s se̱. ");
INSERT INTO gel_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Da-u̱ a-doru̱ Ye̱so̱ i Antakiya yase̱ Burus u̱ Barabas u̱ to̱ko̱n ne̱t-to̱ ne̱ to̱ko̱n no̱m-to̱ tu̱ ha-m e̱, e̱ aru̱k, e̱ dor dak-u̱ Finikiya u̱ Samariya-ne̱. Da-u̱ e̱ ese̱ u̱ to̱ko̱n be-to̱ u̱ dak-u o̱, e̱ wu̱r u̱zu̱ i za-yahuda-ne̱ da u-tát e̱ yaag jab. Remu̱ iya hen, a-dor be̱e̱t i o̱ u̱ be-u̱t to̱ no̱mo̱g u̱r-so̱ sok. ");
INSERT INTO gel_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Da-u̱ e̱ teye̱ Urusharima, a-doru̱ Ye̱so̱ u̱ a-To̱mu̱ Ye̱so̱ ne̱, u̱ u̱t-ne̱nge̱n ne̱, mo̱ro̱g-du̱ a-dor gu u̱n. Burus e̱ Baraba waru̱ u̱n no̱m-tu̱ Ru̱-u̱ no̱me̱ u̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Se̱di e̱ke̱n a-dor-ne̱ i o̱ te̱k-u̱ ban-du̱ Farisa-ne̱, e̱ yu̱ne̱ u̱r-ees e̱ zu̱, <<Ka u̱t-no̱m zarra se̱ na no̱mgu̱ a-dor i za-yahuda-ne̱ da u̱r-pe̱s tu̱msu̱ na wa' e̱ do̱r no̱mu̱ wa-warru̱ rem-su̱ u-Ru̱ Mosa ware̱ u̱-me̱ bo̱r-u̱t wa.>> ");
INSERT INTO gel_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","A-To̱mu̱ Ye̱so̱ ne̱ u̱ u̱t-ne̱nge̱n ne̱, e̱ mo̱ro̱g remu̱ e̱ no̱m-u̱t rem-u̱s se̱. ");
INSERT INTO gel_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Da-u̱ na tase̱ inan sok, se̱ Biturus yu̱ne̱ u̱r-ees wa zu̱ u̱n, <<O̱r-u̱t ri, no̱ nak m-tumb ne̱ u̱zu̱ Ru̱-u̱ dak me̱ u̱ te̱k-u̱ me̱ no̱, u̱zu̱ du̱gu̱-du̱ ri de̱ i za-yahuda-ne̱ hogte̱ Rem-su̱ m-Re̱me̱r, tu̱msu̱ e̱ yu̱'u̱t jab. ");
INSERT INTO gel_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","U-Ru̱ wu̱ nape̱ jab-u̱ kowan, wa ko̱ske̱ u̱zu̱ wa kabu̱g u̱n u̱ wa ye'et u̱n Yar-u u-Ru̱, u̱ka wa yete̱ in. ");
INSERT INTO gel_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tu̱msu̱ wa ko̱ske̱ m-ku̱u̱k u̱-me̱ in u̱ u̱n ne̱ da, remu̱ zu̱ wa jatu̱sse̱ jab-u̱s u̱n remu̱ yadu̱ jab-u̱s u̱n. ");
INSERT INTO gel_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¿U̱ da-o̱ remu̱ yan-o̱ no̱ o̱tte̱ re̱g-du̱ u-Ru̱ u̱ no̱ o̱tte̱ saku̱ a-doru̱ Ye̱so̱ u̱t-cwu̱, bo̱r-tu̱ in u̱ i mate̱ u̱so-tu̱ u̱so-u̱t in kere̱ u̱t-kab da? ");
INSERT INTO gel_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Se̱di in yaag jab u̱zu̱ remu̱ nya-u Wa-ko-uyan Ye̱so̱ de̱ in kumte̱ u-u̱ku̱r, u̱ka in kumte̱.>> ");
INSERT INTO gel_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Se̱ mo̱ro̱g-du̱ u̱t-ne̱t ho u̱s-ram, e̱ hu̱ e̱rru̱ Burus e̱ Baraba da-u̱ e̱ o̱o̱ge̱ warru̱ no̱m-tu̱ m-shin tu̱ Ru̱-u̱ no̱me̱ u̱ te̱k-u̱ me̱ i za-yahuda-ne̱ de̱. ");
INSERT INTO gel_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Da-u̱ u̱n tase̱ u̱s-rem, Yakubu shu̱s wa zu̱, <<O̱r-u̱t ri, ho̱go̱n me̱. ");
INSERT INTO gel_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simiyo̱n he̱e̱se̱ warru̱ ka Ru̱-u̱ he̱ste̱ ko̱su̱ cwan-u̱t wa u̱du̱ i za-yahuda-ne̱ da, u̱ wa ku̱bte̱ to̱ko̱n ne̱t-to̱ e̱ shu̱'u̱t ne̱t-u̱t wa. ");
INSERT INTO gel_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Byu̱rnu̱r i za-yahuda-ne̱ da, no̱ng ho̱n-ho̱n u̱ no̱mu̱ a-warru̱ rem-su̱ u-Ru̱ ne̱ ware̱. U̱ka na pu̱nte̱ u̱zu̱, ");
INSERT INTO gel_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","<< <Da tase̱ u̱m de̱ u̱t-mu̱u̱n u̱m ma bu-u Dawuda u̱ hemu̱sse̱. Ko ba o̱ hemu̱sse̱ me̱ u̱t-swu̱r m-ma o̱, tu̱msu̱ u̱m yu̱nu̱s o̱. ");
INSERT INTO gel_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Iya o̱ hen ne̱t-tu̱ kuse̱ do̱te̱ sa-u Yawe, I za-yahuda-ne̱ da i u̱m dage̱ i hi-du̱ war ri. Iya o̱ Yawe zu̱tte̱,> ");
INSERT INTO gel_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","U̱m yaag ne̱t-u̱t ri nap-mu̱ no̱m-u̱t tun-to̱ m-tumb ne̱. ");
INSERT INTO gel_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","<<U̱ hyan-m ri zatte̱ u̱r-zwar na e̱kse̱ a-za Yahuda-ne̱ i o̱ byu̱ru̱n u̱du̱ u-Ru̱ da. ");
INSERT INTO gel_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Se̱di yage̱ in panu̱ u-ran m-ha u̱du̱ u̱n taas u̱n re̱ no̱m u̱t-re̱ u̱ sake̱ ru̱-tu̱ za u̱r-fat da. Tu̱msu̱ a u̱n no̱m m-o̱ da, a u̱n tu̱ o̱ko̱n bisa-o̱ u̱ na myu̱gre̱ u̱r-ge̱ku̱s da. Tu̱msu̱ taas u̱n tu̱ ko̱ u̱n swa hyu̱-mu̱ u̱t-bisa da. ");
INSERT INTO gel_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","In u̱t-kere̱ u̱t-zu̱ iya remu̱ da-u̱ ar-ke̱, ne̱t-tu̱ o̱o̱g u̱ no̱m-du̱ do̱nse̱-du̱ bo̱r-u Mosa u̱-me̱ ko̱he̱ne̱ bo̱-o̱, tu̱msu̱ ko̱du̱he̱ ho̱-du̱ u̱r-hure̱ de̱ u̱n karu̱nte̱ o̱ u̱-me̱ Kur-u̱ u̱t-Ko̱se̱ u̱ Yahuda-ne̱.>> ");
INSERT INTO gel_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Se̱ a-To̱m Ye̱so̱, u̱t-ne̱nge̱n ne̱, u̱ a-doru̱ Ye̱so̱ ne̱ be̱e̱t u̱ Urusharima, e̱ hyen no̱ng u̱r-zwar. U̱n dag e̱ke̱n u̱ te̱k-u̱ me̱ u̱n, e̱ to̱m u̱n m-ha u̱ Antakiya u̱ Burus ne̱ e̱ Baraba, se̱ u̱n du̱g Yahudas, (wu̱ na zu̱ye̱ Barsaba) u̱ Sira, e̱ o̱ tu̱-shu̱ tu̱ a-doru̱ Ye̱so̱ ne̱ u̱ Urusharima. ");
INSERT INTO gel_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Na yasu̱ u̱n u-ran u̱ zu̱ye̱: Du̱gu̱-du̱ o̱r-u̱t no̱, a-To̱mu̱ Ye̱so̱ u̱ ne̱nge̱n-tu̱ a-dor, m-ha u̱du̱ a-dor i o̱ taku̱n-u̱r i za-yahuda-ne̱ da, u̱ bo̱-u̱ Antakiya u̱ dak-tu̱ Suriya-ne̱ u̱ Kirikiya ne̱. It o̱ u̱s-vu̱k. ");
INSERT INTO gel_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","It ho̱k u̱zu̱, e̱ke̱n u̱ te̱k-u̱ me̱ it naaste̱ jab-u̱s no̱, u̱ rem-u̱s u̱n ne̱. U̱n yu̱ns jab-u̱s no̱ u̱zu̱, se̱di na no̱ngu̱ no̱ u̱r-pe̱s no̱ do̱r bo̱r-u Mosa, it to̱mo̱g u̱n da hen. ");
INSERT INTO gel_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Da-u̱ it mo̱rge̱, it hyen no̱ng u̱r-zwar it to̱mo̱n e̱ke̱n u̱du̱ no̱, u̱r-kot u̱ Baraba e̱ Burus ne̱, ");
INSERT INTO gel_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","I zo̱nge̱ m-mar, remu̱ e̱ no̱m-tu̱ Wa-ko-uyan Ye̱so̱ Kiristi u̱s-pama. ");
INSERT INTO gel_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Remu̱ iya o̱ it to̱mto̱n Yahudas u̱ Sira. E̱ de̱ waru̱ no̱ no̱m-u̱t tun-to̱ m-sha m-gan u̱ no̱m-tu̱ it pane̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Yar-u u-Ru̱ u̱ it ne̱, it hyanu̱g no̱ng u̱r-zwar it e̱kse̱ no̱ do̱rru̱ bo̱r-to̱ tu̱ Yahuda-ne̱ be̱e̱t da. Se̱di it u̱t-sa no̱ do̱r tun-to̱ bo̱r-to̱ u̱ war-to̱: ");
INSERT INTO gel_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Se̱di a no̱ re̱ no̱m u̱t-re̱ u̱ sake̱ m-gir da, u̱ tu̱du̱ m-ap m-hyu̱ ne̱, u̱ tu̱du̱ bisa-tu̱ na myu̱gre̱ u̱r-ge̱ku̱s ne̱, tu̱msu̱ m-o̱ ne̱. A no̱ so̱me̱ du̱gu̱ no̱m-u̱t to̱, no̱ de̱ no̱m-du̱ no̱m-u̱ kame̱ iya. Se̱ wa'aste̱. ");
INSERT INTO gel_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Na tom u̱n m-ha Antakiya, da-u̱ u̱n kargu̱sse̱ mo̱ro̱g-du̱ a-dor u yasu̱ u̱n u-ran. ");
INSERT INTO gel_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Da-u̱ ne̱t-tu̱ karu̱nte̱ ran-u o̱, e̱ nom u̱r-so̱ sok, remu̱ shiriktin-mu̱ jab mu̱ e̱ kume̱. ");
INSERT INTO gel_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yahudas e̱ Sira hen, u̱n a-warru̱ rem-su̱ u-Ru̱ ne̱ e̱, u̱n nak u-da u̱ no̱mu̱ u̱t-ne̱t u̱t-ko̱se̱ tu̱msu̱ u̱ swu̱ru̱ u̱n be̱b-du̱ jab ne̱. ");
INSERT INTO gel_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Da-u̱ u̱n no̱me̱ u̱t-ho̱ cashi u̱ku̱n, se̱ a-dor-ne̱ zu̱ Yahudas e̱ Sira aru̱k e̱ mu̱u̱n u̱du̱ i to̱me̱ u̱n u̱ Urusharima m-yar. ");
INSERT INTO gel_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Burus e̱ Baraba shu̱'u̱t u̱ Antakiya, u̱ to̱ko̱n ne̱t-to̱ ne̱. E̱ o̱o̱ge̱ u̱t-ko̱se̱ u̱ waru̱ ne̱t-ne̱ rem-su̱ Wa-ko-uyan u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","De̱ku̱n ho̱-de̱ Burus zu̱ Baraba, <<Haane̱ yu̱-u do̱'e̱ u̱t-bo̱ u̱t-be̱e̱t tu̱ yo o̱tte̱ m-no̱m u̱t-bu̱t tu̱ rem-su̱ Wa-ko-uyan da-u̱ dim, yu̱-u hyan u̱ka a-dor-ne̱ rete̱ shu̱ yadu̱ jab u̱du̱ Ye̱so̱.>> ");
INSERT INTO gel_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Baraba cwang wa no̱k u̱ Yohanna ne̱ wu̱na foge̱ Markus wa dor u̱n. ");
INSERT INTO gel_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Se̱di Burus hyen kamu̱g u̱n no̱k u̱ Markus ne̱ da, remu̱ zu̱ da-u̱ dim wa yakku̱ u̱n u̱ dak-u̱ Famfiriya, wa gu̱gu̱mte̱ re̱-du̱ shu̱ u-pama u̱ u̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Rem-u̱s se̱ shu̱'u̱t u̱n inan, se̱ u̱n mot. U̱n mot, Baraba ku̱b Markus u̱n to̱ u-hat m-ha u̱ Sayifurus. ");
INSERT INTO gel_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Burus hen wa du̱g Sira. A-doru̱ Ye̱so̱ ko̱n Wa-ko-uyan wa no̱mu̱ Burus e̱ Sira u̱r-se̱ge̱ tu̱msu̱ wa ko̱su̱ u̱n nya-u wa. Se̱ u̱n aru̱k. ");
INSERT INTO gel_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","U̱n dor dak-tu̱ Suriya u̱ Kirikiya ne̱, u̱n o̱ cwaag u̱ be-u̱t to̱ remu̱ e̱ se̱g-tu̱ a-doru̱ Ye̱so̱ ne̱ u̱ka e̱ do̱te̱ yadu̱ jab-u̱s u̱r-be̱b ne̱ u̱du̱ Wa-ko-uyan Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Se̱ Burus hu̱ u̱ bo̱-tu̱ Darbe u̱ Risitira ne̱. Waku̱n wa-doru̱ Ye̱so̱ o̱ro u̱ku̱n wu̱ na zu̱ye̱ Timoti. Ino-u wa, wa-Yahuda wa. U̱so-u ro o̱ ne̱t-u̱ Girik. ");
INSERT INTO gel_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","A-dor-ne̱ be̱e̱t i bo̱-tu̱ Risitira u̱ Ikoniya ne̱ waru̱g no̱m-u̱t so̱-to̱ u̱ Timoti. ");
INSERT INTO gel_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Burus cwanu̱g Timoti u̱ shu̱'u̱ wa remu̱ ya o̱ wa ku̱bte̱ wa da-u̱ wa do̱'e̱ to̱ko̱n be-to̱, se̱ wa no̱mu̱ Timoti u̱r-pe̱s. Wa no̱ng iya remu̱ zu̱ Yahuda-ne̱ be̱e̱t i o̱ u̱ku̱n u̱ be-u̱t to̱ e̱ kabu̱ Timoti, e̱ nak u̱zu̱ uso-u rò ne̱tu̱ Yahuda wa da, wa eeste̱ u̱ waku̱n u̱ no̱mu̱ wa'-u̱ wa u̱r-pe̱s da. ");
INSERT INTO gel_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Se̱ Timoti aru̱k e̱ Burus u̱ Sira ne̱. E̱ do̱'e̱ to̱ko̱n bo̱-to̱ u-tát, e̱ o̱ waru̱ a-dor-ne̱ u̱ i za-yahuda-ne̱ da u̱ e̱ do̱r rem-su̱ a-To̱mu̱ Ye̱so̱ u̱ u̱t-ne̱nge̱n ne̱ tu̱ Urusharima cine̱ u̱ e̱ do̱r se̱. ");
INSERT INTO gel_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ru̱-u̱ o̱gu̱ se̱gu̱ a-doru̱ Ye̱so̱ ne̱ i o̱ u̱-me̱ u̱t-bo̱ u̱ka e̱ do̱te̱ yadu̱ jab u̱r-be̱b ne̱ u̱du̱ Wa-ko-uyan Ye̱so̱, tu̱msu̱ ko mu̱ne̱ ne̱t-tu̱ sur u-tát. ");
INSERT INTO gel_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Burus u̱ hu̱u̱b-tu̱ m-ha wa ne̱ to u̱ Gas-u̱ dak-tu̱ Firijiya u̱ Garatiya-ne̱, remu̱ zu̱ Yar-u u-Ru̱ hooste̱ u̱n warru̱ rem-su̱ u-Ru̱ u̱ dak-u̱ Asiya. ");
INSERT INTO gel_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Da-u̱ u̱n tene̱ ma-du̱ dak-u̱ Misiya, e̱ nom u̱ka e̱ cwa u̱ dak-u̱ Bitiniya, se̱ Yar-u Ye̱so̱ hoos u̱n. ");
INSERT INTO gel_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Se̱ e̱ dor gas-u̱ dak-u̱ Misiya, e̱ irig m-ha u̱ bo̱-u̱ Toruwa. ");
INSERT INTO gel_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","M-gyu̱p Burus nom u-hyan, wa hyen waku̱n u̱ dak-u̱ Makidoniya u̱ ees. Wa o̱gu̱ ko̱n-du̱ wu̱n u̱zu̱, <<Haane̱ u̱ Makidoniya bo̱ se̱gu̱ it!>> ");
INSERT INTO gel_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Da-u̱ Burus no̱me̱ u-hyan, za rem it yu̱ne̱ it pu̱s m-ha u̱ Makidoniya, remu̱ it kwu̱ng m-nap u̱zu̱ Ru̱-u̱ o̱ fagu̱ it, it war Rem-su̱ m-Re̱me̱r. ");
INSERT INTO gel_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","It nok u̱ me̱ u-hat du̱gu̱ dak-u̱ Toruwa m-ha u̱ Samutakiya, tu̱msu̱ u̱r-is gas it te bo̱-u̱ Niyaporis. ");
INSERT INTO gel_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tu̱msu̱ du̱gu̱ ku̱n it aru̱k m-ha u̱ bo̱-u̱ Firibi u̱ o̱ u̱-me̱ faru̱k-du̱ dak-u̱ Roma, tu̱msu̱ o̱ o̱ye̱ bo̱-u yat-o̱ u̱ kwu̱n-u̱ dak-u̱ Makidoniya. It no̱mo̱g u̱t-ho̱ u̱ku̱n cashi. ");
INSERT INTO gel_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","U̱ Ho̱-du̱ u̱r-Hure̱ it ru u̱ is u-bo̱, it do̱'e̱ u̱ kit u-gi be-du̱ it o̱o̱g m-hyan it u̱t-kwu̱m be-du̱ u̱s-to̱o̱g du̱ Yahuda-ne̱. Se̱ it shu̱'u̱t it nom u̱s-rem u̱ ne̱ta-ne̱ i haane̱ u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Yaku̱n ne̱ta ya o̱ro na zu̱ wa Ridiya, wu̱ no̱mu̱ u-Ru̱ u̱t-huuk, wa o̱gu̱ ho̱g-du̱ it. Wa ne̱t-u̱ bo̱-u̱ Tayatira wa, wa bu̱b kus-tu̱ randi-m jaz-mo̱ mu̱ shik u-tát. Wa-ko-uyan upuste̱ jab-u̱ rò wa wu̱ jab-u̱ e̱rru̱ no̱mu̱ Burus o̱o̱ge̱ u̱t-war. ");
INSERT INTO gel_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Da-u̱ na no̱mu̱ wu̱n u̱t-yu̱bu̱sse̱ m-bu̱ u̱r-kot u̱ ne̱t-tu̱ bu-u rò ne̱, se̱ wa ko̱n u̱zu̱, <<A no̱ eese̱ u̱zu̱ me̱ ma-tu̱ wa yadu̱ jab wa u̱du̱ Wa-ko-uyan, haanu̱n no̱ cu̱st u̱ bu-u ri.>> Wa pu̱r it, it ees. ");
INSERT INTO gel_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","De̱ku̱n ho̱-de̱ it o̱gu̱ ha-mu̱ be-du̱ u̱s-to̱o̱g, se̱ it goone̱ u̱ e̱ke̱n gwu̱p-e̱ ne̱ to̱k wu̱ nome̱ u-gwat u̱ be̱b-du̱ no̱m u̱s-te. I u o̱ u̱ kom-u̱t e̱ o̱ kwu̱m-du̱ shik u-tát remu̱ gwat-u o̱ u̱ wa nome̱. ");
INSERT INTO gel_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Se̱ gwu̱p-i e̱ hu̱ Burus ne̱, wa o̱ u̱t-jar wa o̱ u̱t-zu̱, <<Ne̱t-u̱t tun-to̱ to̱k u-Ru̱ e̱ wu̱ m-sek, wu̱ zege̱ ko-uyan ru̱-o̱, e̱ o̱ warru̱ fu̱n-yu̱ kwu̱m-du̱ u-u̱ku̱r!>> ");
INSERT INTO gel_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Wa haag u̱t-no̱m iya u̱t-ho̱ u-tát. Se̱ Burus hog u̱s-ryab sok, wa zu̱ no̱m-yu̱ u̱s-te, <<U̱ te̱k-u̱ shin-mu̱ o̱ dim-u̱r Ye̱so̱ Kiristi, yagu̱ wu̱n!>> Za rem no̱m-yu̱ u̱s-te yagu̱ wa'-u̱-gwu̱p. ");
INSERT INTO gel_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Da-u̱ ne̱t-tu̱ u o̱ kom-u̱t e̱ hyane̱ fu̱n-yu̱ e̱ kumte̱ shik zwapke̱, se̱ e̱ maas Burus u̱ Sira ne̱. E̱ nu̱k u̱n m-ha u̱-me̱ ban-du̱ u̱t-ne̱t m-te be-du̱ a-kwu̱p-du̱ u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Da-u̱ e̱ hu̱tu̱ u̱n u̱du̱ a-kwu̱p-du̱ u̱s-rem ne̱, e̱ zu̱, <<Ne̱t-u̱t tun-to̱ Yahuda-ne̱ e̱, e̱ o̱ yu̱n-su̱ jab-su̱ u̱t-ne̱t u̱-me̱ u-bo̱. ");
INSERT INTO gel_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","E̱ o̱ iis-u̱ u̱t-ne̱t u̱r-ma'e̱ no̱mu̱ in nomtu̱n da, remu̱ zu̱ in Roma-ne̱ e̱.>> ");
INSERT INTO gel_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Se̱ ne̱t-tu̱ ku̱gu̱n u-da u-gan u̱ haan u̱du̱ Burus ne̱ e̱ Sira, a-kwu̱p-du̱ u̱s-rem ne̱ zu̱ ne̱t-tu̱ kemu̱sse̱ Burus e̱ Sira u̱t-kus, na vu' e̱. ");
INSERT INTO gel_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Da-u̱ na vu' e̱ sok, a-kwu̱p-du̱ u̱s-rem ne̱ wu̱ u̱n u̱ me̱ kur-u̱ m-to̱k. A-kwu̱p-du̱ u̱s-rem zu̱ wa e'-du̱ bu-u̱ m-to̱k wa e̱' u̱n sok. ");
INSERT INTO gel_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Wa e'-du̱ bu-u̱ m-to̱k hen wa ku̱b rem-u̱s se̱, wa wu̱ u̱n u̱ me̱n-tu̱ me̱ kur-u̱ m-to̱k wa gu̱g naas u̱n u̱ king u-te. ");
INSERT INTO gel_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","U̱ te̱k-u̱ m-gyu̱p, Burus u̱ Sira e̱ o̱o̱g u̱s-to̱o̱g u̱ se̱p-tu̱ vam-tu̱ u-Ru̱ ne̱. Ne̱t-tu̱ u̱-me̱ bu-u̱ m-to̱k o̱ ho̱g-du̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Za rem dak-u̱ ru̱mu̱s u̱r-be̱b ne̱, har kan-tu̱ bu-u̱ m-to̱k to̱ ru̱mu̱s. Za rem is-tu̱ u-pus, i o̱o̱ge̱ m-gag u̱-me̱ bu-u̱ m-to̱k ust. ");
INSERT INTO gel_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Da-u̱ wa e'-du̱ bu-u̱ m-to̱k yu̱ne̱ du̱gu̱ m-roog, wa hyen u̱t-is u̱r-hu̱k, wa cu̱ng u̱zu̱ ne̱t-tu̱ o̱ tage̱ u̱ bu-u̱ m-to̱k so̱mo̱g. Se̱ wa naku̱n u-van wa ho-u̱t hi-u̱r wa, wa nak u̱zu̱ tu̱-shu̱ u̱ keru̱ ho̱-du̱ wu̱n a ne̱t-u̱t to̱ so̱me̱. ");
INSERT INTO gel_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Burus yu̱ns u-cwar wa zu̱, <<A-bo̱ ho̱nsu̱ hi-u̱r ró da! It o̱ ane̱ be̱e̱t!>> ");
INSERT INTO gel_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Se̱ wa e'-du̱ bu-u̱ m-to̱k zu̱ na hatu̱n u̱s-hitirra, se̱ wa to̱ m-so̱m wa he u̱ ke̱nu̱ Burus e̱ Sira. ");
INSERT INTO gel_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Wa rwu̱tu̱n u̱n u̱-do̱, wa zu̱, <<I-yate̱, ¿yan-o̱ u̱m de̱ u̱t-no̱m u̱m kum-u̱t u-u̱ku̱r?>> ");
INSERT INTO gel_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","E̱ zu̱ wu̱n, <<Ya jab u̱du̱ Wa-ko-uyan Ye̱so̱, bo̱ u̱ a bu-u ro ne̱ u-be̱e̱t, no̱ u̱t-kwu̱m u-u̱ku̱r.>> ");
INSERT INTO gel_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Du̱gu̱ ku̱n u̱n waru̱ wu̱n rem-su̱ Wa-ko-uyan, wu̱n u̱ ne̱t-tu̱ to̱ bu-u ro ne̱ be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","U̱ te̱k-u̱ da-u̱ o̱ m-gyu̱p, wa rwu̱tu̱n u̱n, wa jasu̱ u̱n nat-u̱t u̱n, za rem na no̱mu̱ wu̱n u̱t-yu̱bu̱sse̱ m-bu̱, wu̱n u̱ a bu-u ro ne̱ be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Du̱gu̱ ku̱n wa cwan u̱ u̱nne̱ u̱ me̱ bu-u ro, wa hatu̱n no̱m u̱t-re̱. Wu̱n u̱ a bu-u ro u̱n shi u̱r-so̱ ne̱ sok, remu̱ zu̱ u̱n be̱e̱t kowan yaag jab u̱du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Da-u̱ is gase̱, a-kwu̱p-du̱ u̱s-rem to̱mo̱n A-u̱s-ko̱m ne̱ u̱zu̱, <<Reste̱ ne̱t-u̱t to̱.>> ");
INSERT INTO gel_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Se̱ wa e'-du̱ bu-u̱ m-to̱k hatu̱n Burus ne̱ to̱m u̱zu̱, <<Wa kwu̱p-du̱ u̱s-rem to̱mgo̱n u̱zu̱ u̱m rest no̱. Remu̱ iya rwu̱nu̱n no̱ yu̱r no̱, ha m-ha. No̱ te m-yar.>> ");
INSERT INTO gel_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Se̱di Burus zu̱ u̱n, <<U̱ te̱k-u̱ u̱t-ne̱t o̱ na no̱m-tu̱ it u̱s-ryap, za na kwu̱pu̱ it u̱s-rem, ko ba it o̱ Roma-ne̱. Tu̱msu̱ na gu̱n it u̱ bu-u̱ m-to̱k, ¿u̱n u̱t-sa u̱n rest it m-yasa? Za u̱t-no̱me̱ da, u̱n haan u̱n ruut it u̱ hi-du̱ war u̱n.>> ");
INSERT INTO gel_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","A-u̱s-ko̱m do̱'e̱ e̱ waru̱ a-kwu̱p-du̱ rem-u̱s se̱. Da-u̱ e̱ ho̱ge̱ u̱zu̱ Burus e̱ Sira ne̱t-tu̱ Roma to̱, no̱m-u o̱ yaag a-kwu̱p-du̱ u̱s-rem ne̱ hog u-gye̱r. ");
INSERT INTO gel_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Du̱gu̱ ku̱n a-kwu̱p-du̱ u̱s-rem ne̱ haan e̱ kon Burus e̱ Sira e̱ no̱mu̱ u̱n u̱r-ho̱. Du̱gu̱ ku̱n u̱n rwu̱tu̱n u̱n, se̱ u̱n kon Burus e̱ Sira e̱ yagu̱ bo̱-u o̱. ");
INSERT INTO gel_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Da-u̱ Burus ne̱ ruye̱ du̱gu̱ bu-u̱ m-to̱k, se̱ e̱ do̱'e̱ u̱du̱ Ridiya. Da-u̱ e̱ hyane̱ a-dor-ne̱, e̱ swu̱ru̱ e̱ shiriktin-mu̱ jab, e̱ aru̱k. ");
INSERT INTO gel_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Burus e̱ Sira do̱ro̱g u̱-me̱ bo̱-tu̱ Ampiporis u̱ Aporiniya ne̱, e̱ mu̱u̱n u̱ bo̱-u̱ Tasaronika, u̱ be-du̱ Kur-u̱ u̱t-Ko̱se̱ u̱ Yahuda-ne̱ o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","U̱ ho̱-du̱ u̱r-hure̱, Burus cwaag u̱ Kur-u̱ u̱t-Ko̱se̱ u̱ka wa vette̱, u̱t-ho̱ u̱t-tu̱t tu̱ Ho̱-du̱ u̱r-Hure̱ tu̱ wa no̱me̱ u̱ku̱n wa o̱o̱g u̱r-orop u̱ u̱n ne̱ u̱ no̱m-tu̱ na pane̱ u̱-me̱ Rem-su̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Wa o̱gu̱ warru̱ rem-su̱ u-Ru̱, tu̱msu̱ wa ko̱se̱ u̱n u̱zu̱ Kiristi de̱ swa-u̱ u̱r-ko̱b tu̱msu̱ wa yu̱ne̱ du̱gu̱ marimari. Burus zu̱, <<Ye̱so̱ wu̱ u̱m o̱ waru̱ no̱, wa o̱ Kiristi.>> ");
INSERT INTO gel_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ban-du̱ Yahuda-ne u̱ i za-yahuda-ne̱ da i no̱me̱ u-Ru̱ u̱t-huuk tu̱msu̱ u̱ to̱ko̱n ne̱ta-to̱ ne̱ tu̱ na nape̱ ko̱he̱ne̱, e̱ ku̱b rem-u̱s se̱, e̱ same̱ u̱r-hi u̱ Burus u̱ Sira ne̱. ");
INSERT INTO gel_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Se̱di e̱ke̱n Yahuda-ne̱ hu̱ u̱r-shu̱b, e̱ kargu̱sse̱ a-ko̱b-du̱ m-e̱' ne̱ u-tu̱rru̱, e̱ mo̱ro̱g e̱ yu̱ns gwu̱z u̱-me̱ u-bo̱. E̱ aru̱k m-so̱m m-cwa u̱ bu-u Jason, u̱ sa-u Burus e̱ Sira, u̱ remu̱ e̱ hatu̱n e̱ u̱du̱ mo̱ro̱g-du̱ u̱t-ne̱t. ");
INSERT INTO gel_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Se̱di ba u̱n hyane̱ u̱n da, u̱n naku̱n Jason u̱ e̱ke̱n a-dor-ne̱ m-ha u̱du̱ tu̱-yat-to̱ tu̱ u-dak. E̱ hu̱ u̱t-jar u̱zu̱, <<Tunto̱ ne̱t-to̱ e̱ hatu̱n yu̱nu̱s-du̱ u̱s-jab ko̱he̱ne̱ u̱ me̱ u-dak, e̱ ya e̱ teegu̱n u̱ ane. ");
INSERT INTO gel_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jason cu̱ste̱ u̱n hen u̱-me̱ bu-u wa. E̱ be̱e̱t e̱ o̱ pas-du̱ bo̱r-u̱t Kaisar Faru̱k u̱zu̱ waku̱n faru̱k wa o̱ro na zu̱ wa Ye̱so̱.>> ");
INSERT INTO gel_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Da-u̱ ne̱t-tu̱ ho̱ge̱ iya u̱ tu̱-yat-to̱ tu̱ u-dak ne̱, jab-u̱s e̱ yu̱ne̱. ");
INSERT INTO gel_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","U̱n gu̱gu̱m res-tu̱ Jason u̱ e̱ke̱n a-dor-ne̱, se̱ da-u̱ a-doru̱ Ye̱so̱ to̱pe̱ u̱n shik. ");
INSERT INTO gel_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","U̱ te̱k-u̱ gyu̱p-m mo̱ a-dor to̱mo̱g Burus e̱ Sira e̱ no̱k u̱ Biriya. Da-u̱ e̱ teye̱ ku̱n, e̱ do̱'e̱ u̱ Kur-u̱ u̱t-Ko̱se̱ u̱ Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Yahuda-ne̱ i o̱ du̱gu̱ Biriya, e̱ ze̱k ne̱t-tu̱ Tasaronika-ne̱ u̱ jab-u̱ so̱-o̱, remu̱ zu̱ e̱ kabu̱g rem-u̱s se̱ u̱t-kom u̱t-yu̱r. Tu̱msu̱ ko mu̱ne̱ u̱n o̱ is no̱m-u̱ na pane̱ u̱ rem-su̱ u-Ru̱, u̱ remu̱ e̱ hyen-u̱t no̱m-u̱ Burus ware̱ ko̱ nip-to̱ re̱. ");
INSERT INTO gel_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Yahuda-ne̱ u-tát e̱ yaag jab u̱du̱ Ye̱so̱, u̱ to̱ko̱n ne̱ta to̱ ne̱ tu̱ napi napi tu̱ Girik tu̱msu̱ u̱ campa-ne̱ tu̱ Girik u-tát yaag jab ko̱ e̱. ");
INSERT INTO gel_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Da-u̱ Yahuda-ne̱ i Tasaronika nape̱ u̱zu̱ Burus o̱ warru̱ rem-su̱ u-Ru̱ u̱ Biriya, e̱ hu̱ u̱ku̱n u̱ to̱k-du̱ u̱t-ne̱t tu̱msu̱ u̱ yu̱n-su̱ jab-su̱ u̱t-ne̱t ne̱. ");
INSERT INTO gel_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Za rem a-dor tok Burus m-ha u̱ dapu̱s m-sa, se̱di Sira u̱ Timoti e̱ ees u̱ Biriya. ");
INSERT INTO gel_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","I no̱me̱ Burus u̱r-shu̱'e̱, e̱ hu̱u̱t wu̱n u̱ bo̱-u̱ Atina. Da-u̱ e̱ o̱ mu̱u̱n Burus to̱mo̱n ne̱t-tu̱ o̱ u̱r-kot u̱ wane̱ wa zu̱ u̱n, <<Waru̱n Sira e̱ Timoti u̱zu̱ e̱ no̱mo̱n m-ho̱r e̱ bit me̱ u̱ ane̱ u̱ Atina.>> Se̱ ne̱t-u̱t to̱ yage̱ bo̱-u̱ Atina m-mu̱ Biriya. ");
INSERT INTO gel_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Da-u̱ Burus o̱o̱ge̱ e̱stu̱ Sira e̱ Timoti u̱ bo̱-u̱ Atina, jab-u̱ rò naag sok u̱ka wa hyente̱ bo̱-u o̱ shu̱u̱g u̱ no̱m-tu̱ m-gir sok tu̱ ne̱t-tu̱ no̱me̱ u̱t-huuk. ");
INSERT INTO gel_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Wa to u̱-me̱ Kur-u̱ u̱t-Ko̱se̱ wa nom u̱t-orop u̱ Yahuda-ne̱ u̱ i za Yahuda-ne da, i no̱me̱ u-Ru̱ u̱t-huuk. Tu̱msu̱ u̱n to̱ u̱-me̱ u-tu̱rru̱ ko mu̱ne̱, u̱ to̱ko̱n ne̱t-to̱ ne̱ u̱ku̱n i haane̱ wa no̱mu̱ u̱n u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Burus kwu̱mu̱g to̱ko̱n ne̱t-to̱ i tone̱ no̱m-du̱ rem-su̱ no̱m-tu̱ ne̱t-tu̱ do̱te̱ ya-du̱ jab. Ne̱t-tu̱ fog ne̱t-u̱t to̱ Ipikuriya-ne̱ u̱ Sitokiya-ne̱. E̱ke̱n zu̱, <<¿Yan-o̱ wa u-sorom unwa u̱t-sa u̱t-zu̱?>> E̱ke̱n zu̱, <<U o̱ u̱ka ne̱t-tu̱ warru̱ no̱m-tu̱ to̱ko̱n ru̱-to̱ tu̱ za tu̱ ane̱ da.>> E̱ zu̱u̱g iya remu̱ zu̱ Burus haagu̱n wa o̱ warru̱ Rem-su̱ m-Re̱me̱r su̱ Ye̱so̱ u̱ yu̱ne̱-u̱r wa ne̱. ");
INSERT INTO gel_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Se̱ e̱ ku̱b Burus e̱ hu̱u̱t wu̱n u̱du̱ tu̱-shu̱ tu̱ u-bo̱, u̱ be-du̱ na foge̱ Arasa. Ku̱na e̱ zu̱tte̱ wu̱n, <<Waru̱ it ka ko̱se̱-u̱t po-to̱ tun-to̱ o̱tte̱ tu̱ bo̱ no̱mu̱ it. ");
INSERT INTO gel_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","It tamu̱g ho̱g-du̱ go̱-du̱ sin-se̱ rem-se̱ da, it u̱t-sa it nap ko̱ re se̱ o̱tte̱.>> ");
INSERT INTO gel_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atina-ne̱ be̱e̱t u̱ to̱ko̱n ham-u̱t to̱ ne̱ i o̱o̱ge̱ u̱r-shu̱'u̱t u̱ Atina e̱ shu̱'u̱t u̱ku̱n e̱ naasu̱ u-da za no̱m-du̱ o̱ko̱n se̱di remu̱ e̱ hog-u̱t rem-su̱ no̱m-u̱t po-to̱ to̱, tu̱msu̱ e̱ nom-tu̱ u̱s-rem.) ");
INSERT INTO gel_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Burus yu̱ne̱ u̱r-ees u̱-shu̱ tu̱-shu̱ u-bo̱, wa zu̱, <<No̱ ne̱t-tu̱ Atina, u̱m hyang u̱zu̱ no̱ ze̱k u̱ cwan-tu̱ do̱rru̱ u̱t-ru̱ u-tát. ");
INSERT INTO gel_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Da-u̱ u̱m o̱ narru̱ u-bo̱, u̱m got u̱r-zwar ne̱ u̱m hyen no̱m-tu̱ no̱ no̱me̱ u̱t-huuk. Tu̱msu̱ u̱m hyen de̱ku̱n sak-de̱ u̱m hyen na no̱ng se̱ke̱n pan-se̱ u̱zu̱, <U̱du̱ Ru̱-u̱ na nape̱ da.> Yagu̱n u̱m waru̱ no̱ ko̱wana Ru̱-u̱ no̱ o̱ no̱me̱ u̱t-huuk u̱ no̱ nape̱ da. ");
INSERT INTO gel_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","<<Ru̱-u̱ no̱me̱ u-dak u̱ ko̱-uyan u̱ o̱ u̱-me̱ u-dak, wu̱na o̱ Ru̱-u̱ u-do̱m u-dak ne̱. Ba shu̱'u̱te̱ u̱zu̱ wu̱na o̱ u̱r-faru̱k du̱ no̱m-tu̱ u̱r-fat tu̱ do̱m u-Ru̱ u-dak ne̱, wa shu̱'u̱te̱ u̱ bu-u̱ ne̱t maye̱ u̱t-kom da. ");
INSERT INTO gel_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Tu̱msu̱ wa za u̱ sa-u̱ u̱r-se̱ge̱ u̱du̱ u̱t-ne̱t da, wa za sa-u̱ o̱ko̱n da, remu̱ zu̱ wu̱na ya'e̱ kowan u̱r-fat u̱ u̱s-vu̱'e̱ ne̱, u̱ ko̱-uyan ne̱ u̱ ne̱t do̱te̱ u̱r-yu̱. ");
INSERT INTO gel_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Du̱gu̱ u̱r-taku̱n, Ru̱-u̱ no̱ng ne̱t gan, du̱gu̱-du̱ ne̱t gan de̱ wa nomte̱ go̱-du̱ u̱t-ne̱t u̱t-go̱ u̱t-go̱ i o̱ u̱r-yu̱ u̱-me̱ u-dak. Tu̱msu̱ wa du̱g u̱ka rem-tu̱ u̱t-ne̱t do̱te̱ u̱r-yu̱ tu̱msu̱ u̱ da-u̱ e̱ u̱t-no̱m ne̱ u̱ be-u̱t to̱. ");
INSERT INTO gel_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ru̱-u̱ no̱ng inya remu̱ ne̱t-tu̱ su̱-u̱t wa, u̱ka o̱tte̱, jiya u̱nu̱ kwu̱mu̱ wa, ko ba shu̱'u̱te̱ iya, wa za m-ra u̱ in ne̱ da. ");
INSERT INTO gel_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Remu̱ zu̱, du̱ wu̱n de̱ in o̱tte̱ u̱r-yu̱, in o̱ u̱s-ru̱mu̱s tu̱msu̱ in shu̱'u̱te̱ u̱t-ne̱t, u̱ka e̱ke̱n a u̱t-se̱p ne̱ zu̱tte̱ u̱zu̱, <In yaag-u̱ rò e̱.> ");
INSERT INTO gel_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","<<Ko ba shu̱'u̱te̱ u̱zu̱ in yaag u-Ru̱ e̱, ku̱mge̱ in gwat u̱zu̱ Ru̱-u̱ o̱ u̱ka sha-mu̱ zinariya ko azurfa ko u̱t-ta'ar da. No̱m-tu̱ ne̱t-tu̱ kere̱ u̱ jab-u̱s e̱, tu̱msu̱ u̱ kom-u̱t e̱, se̱di to zatte̱ u̱r-fat da. ");
INSERT INTO gel_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","U̱ da-u̱ ne̱t-tu̱ nape̱ no̱m-u̱ Ru̱-u̱ u̱t-sa e̱ no̱m da, wa haag u̱ yadu̱ u̱n u̱r-ko̱b za naas u-da remu̱ no̱mu̱ e̱ no̱me̱ da. Se̱di u̱ da-o̱ Ru̱-u̱ zu̱u̱g u̱ kowan u̱ byu̱ru̱n ko̱he̱ne̱ wa byu̱ru̱n du̱gu̱ kim-u̱s yo̱-se̱ e̱ ");
INSERT INTO gel_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Remu̱ zu̱ wa wa'ag ho̱-du̱ wa de̱ mu̱n, wa no̱mu̱ ne̱t-ne̱ be̱e̱t kwu̱p-du̱ u̱s-rem. Wa dak waku̱n wu̱ de̱ no̱mu̱ in kwu̱p-du̱ u̱s-rem, tu̱msu̱ ne̱tu̱ wa no̱m-du̱ kwu̱p-du̱ u̱s-rem su̱ u̱t-nip wa. Ru̱-u̱ ko̱ske̱ ne̱t-ne̱ be̱e̱t u̱zu̱ wa dak ne̱tu̱ wa, wa no̱mu̱ kowan kwu̱p-du̱ u̱s-rem, Ru̱-u̱ este̱ u̱zu̱ wa u̱t-no̱m inya remu̱ yu̱nsu̱ wayan du̱gu̱ marimari-ne̱.>> ");
INSERT INTO gel_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Da-u̱ e̱ ho̱ge̱ Burus no̱ng mo̱ttu̱ yu̱ne̱-du̱ marimari-ne̱, e̱ke̱n no̱mu̱ wu̱n u-shiga. Se̱di e̱ke̱n zu̱, <<It u̱t-sa it sur m-ho̱g no̱mu̱ bo̱ de̱ u̱t-war u̱ mo̱ttu̱ rem-u̱s se̱.>> ");
INSERT INTO gel_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Da-u̱ e̱ zu̱ye̱ iya, ku̱na Burus aru̱kte̱ wa yagte̱ mo̱ro̱g-du̱ u̱t-ne̱t. ");
INSERT INTO gel_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","E̱ke̱n dor Burus e̱ yu̱' jab. U̱ te̱k-u̱ u̱n waku̱n o̱ro wu̱ na zu̱ye̱ Diyoniyus waku̱n u̱ teku̱ i-yate̱ i Arasa, u̱ yaku̱n ne̱ta ya wu̱na zu̱ye̱ Damaris tu̱msu̱ u̱ e̱ke̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Da tase̱ Burus yage̱ bo̱-u̱ Atina wa hu̱ u̱ bo̱-u̱ Ko̱rintiya. ");
INSERT INTO gel_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ku̱na wa bitte̱ waku̱n wu̱na zu̱ye̱ Akira, ne̱t-u̱ dak-u̱ Po̱ntus. Akira tumbte̱ u̱r-haan du̱gu̱ dak-u̱ Itariya, e̱ ne̱ta wa Biskira, remu̱ zu̱ Kawudikiya u̱ka Kaisar, Faru̱k-u̱ Roma wa no̱ng u̱r-do̱nse̱ u̱zu̱ ne̱tu̱ dak-u̱ Yahuda u-be̱e̱t wa yage̱ bo̱-u̱ Roma. Burus do̱'e̱ wa hyan u̱n. ");
INSERT INTO gel_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ne̱t-ne̱ yu̱ru̱ e̱, te̱-u̱ u̱t-rimpa e̱ no̱me̱ e̱ kum-u̱t shik. Te̱-u̱ u̱t-rimpa Burus nome̱ ko̱wa, se̱ wa shu̱'u̱t u̱du̱ u̱n e̱ nom m-ank u̱r-kot. ");
INSERT INTO gel_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ko̱-uyan Ho̱-du̱ u̱r-Hure̱ de̱, Burus to u̱-me̱ Kur-u̱ u̱t-Ko̱se̱ wa nom u̱r-orop u̱ Yahuda-ne̱ u̱ i za-Yahuda-ne̱ da. Tu̱msu̱ wa sur m-waru̱ u̱n u̱zu̱ Ye̱so̱ wa o̱ Kiristi. ");
INSERT INTO gel_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Da-u̱ Sira e̱ Timoti haane̱ du̱gu̱ Makidoniya, Burus muut jab-u̱ bu̱t-tu̱ rem-su̱ u-Ru̱, wa o̱ waru̱ Yahuda-ne̱ u̱zu̱ Ye̱so̱ wa o̱ Kiristi. ");
INSERT INTO gel_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Se̱ Yahuda-ne̱ gu̱gu̱m rem-u̱s ro, e̱ hu̱ pepru̱ wu̱n. Remu̱ iya Burus pam-u̱t cwu̱-u̱t wa, wa zu̱, <<Hyu̱-m no̱ o̱ do̱m-u̱ hi-u̱t no̱, me̱ di u̱m rutte̱ hi-u̱r ri. Du̱gu̱ da-o̱ u̱m de̱ m-ha u̱du̱ i za-yahuda-ne̱ da.>> ");
INSERT INTO gel_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Da tase̱ wa do̱'e̱ u̱ o̱ko̱n bu-o̱ u̱ o̱ dapu̱s Kur-u̱ u̱t-Ko̱se̱ u̱ waku̱n wu̱na zu̱ye̱ Titiyus Jostus, <<A no̱mu̱ u-Ru̱ u̱t-huuk.>> ");
INSERT INTO gel_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kiribus yu̱-shu̱ bu-u̱ u̱t-ko̱se̱ u̱ bu-u wa ne̱ u-be̱e̱t e̱ yu̱' jab u̱du̱ Wa-ko-uyan. Tu̱msu̱ u-tát u̱ teku̱ Korintiya-ne̱ e̱ ye jab na no̱mu̱ e̱ u̱t-yu̱bu̱sse̱ m-bu̱. ");
INSERT INTO gel_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","U̱ mo̱ko̱n gyu̱p-mo̱ Wa-ko-uyan no̱mo̱g u̱s-rem u̱ Burus ne̱ u̱ da-u̱ wa no̱me̱ u-hyan u̱zu̱, <<A-bo̱ ho̱g u-gye̱r da, ha u̱t-war. A-bo̱ ho̱ u̱s-ram da. ");
INSERT INTO gel_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Remu̱ zu̱ u̱m o̱ u̱r-kot u̱ bo̱ ne̱, ko̱ ba shu̱'u̱te̱ u̱zu̱ ne̱t-tu̱ zwargu̱n Burus, tu̱msu̱ waku̱n ho̱nsu̱ bo̱ da, remu̱ zu̱ u̱m o̱tte̱ u̱t-ne̱t u-tát u̱-me̱ bo̱-u uno̱.>> ");
INSERT INTO gel_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Burus shu̱'u̱t u̱ku̱n m-te u-hak u̱ pyaat-su̱ shishin, u̱ is-u̱ u̱n rem-su̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Da-u̱ Gariyo o̱o̱ge̱ Wa-u-dak u̱ Akaya, e̱ke̱n Yahuda-ne̱ same̱ u̱t-hi, e̱ zwar Burus, e̱ hu̱u̱t wa u̱du̱ Gariyo na kwu̱pu̱ wa u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","E̱ zu̱, <<Ne̱t uno̱ wa wadu̱ ne̱t-ne̱ e̱ do̱r u-Ru̱ u̱ fu̱n-yu̱ bo̱r-u̱t hose̱.>> ");
INSERT INTO gel_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Kanda Burus u̱ nom-u̱t u̱s-rem, se̱ Wa-u-dak Gariyo zu̱ Yahuda-ne̱, <<U̱zu̱ o̱ko̱n no̱m-u yo̱-o̱ wa no̱me̱ u̱ yat-o̱, me̱ e̱ru̱ no̱. ");
INSERT INTO gel_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ba shu̱'u̱te̱ u̱zu̱ nan-e̱ i u̱t-gom u̱ u̱t-dim ne̱ tu̱msu̱ u̱ bo̱r-u̱t no̱ ne̱, se̱ no̱ ho̱ rem-u̱s sin-se̱ u̱ te̱k-u̱ me̱ no̱. U̱m za kwu̱p-du̱ go̱-du̱ sin-se̱ rem-se̱ da.>> ");
INSERT INTO gel_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Se̱ wa buz u̱n du̱gu̱ kur-u̱ kwu̱p-du̱ u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Se̱ u̱n be̱e̱t u̱n maas Sostanus yu̱-shu̱ bu-u̱ u̱t-ko̱se̱. E̱ gap-u̱r wa u̱ shu̱ kur-u̱ kwu̱p-du̱ u̱s-rem. Gariyo gwak-u̱t u̱n da. ");
INSERT INTO gel_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Da tase̱ Burus swu̱ru̱g to̱ko̱n ho̱-to̱ u̱ Korintiya, se̱ wa yage̱ a-dor-ne̱. U̱n aru̱k m-ha u̱ Kankiriya, Burus nom u-o̱r remu̱ este̱du̱ u̱s-rem su̱ wa no̱me̱. Se̱ wa to u̱-me̱ u-hat e̱ Biskira u̱ Akira m-ha u̱ Suriya. ");
INSERT INTO gel_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Da-u̱ e̱ te̱ye̱ bo̱-u̱ Afisa ku̱na Burus yakte̱ Biskira e̱ Akira. Se̱ wa to̱ u̱-me̱ Kur-u̱ u̱t-Ko̱se̱ u̱n wa u̱r-orop u̱ Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Se̱ e̱ kon wu̱n wa sur m-no̱m to̱ko̱n ho̱-to̱ u̱ku̱n wa gu̱gu̱m. ");
INSERT INTO gel_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Kanda wa aru̱k se̱ wa zu̱, <<Me̱ u̱t-mu̱u̱n u̱du̱ no̱ a Ru̱-u̱ zu̱ye̱.>> Se̱ wa aru̱k u̱ me̱ u-hat m-ha du̱gu̱ Afisa. ");
INSERT INTO gel_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Da-u̱ wa cize̱ u̱ Kasariya, se̱ wa do̱'e̱ u̱-me̱ a-doru̱ Ye̱so̱ u̱ Urusharima wa vu̱ku̱s u̱n, wa aru̱k m-te̱ u̱ Antakiya. ");
INSERT INTO gel_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Da-u̱ wa tumbe̱ u̱ku̱n cashi, se̱ wa yu̱ne̱ wa to̱ u̱ dak-tu̱ Garatiya-ne̱ u̱ Firijiya-ne̱. Wa o̱gu̱ do̱rru̱ u̱t-bo̱ u̱t-bo̱, u̱ swu̱ru̱ a-doru̱ Ye̱so̱ be̱e̱t shiriktin-mu̱ jab. ");
INSERT INTO gel_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Da-u̱ Burus o̱ te̱k-u̱ m-ha u̱ dak-tu̱ Garatiya u̱ Firiya-ne̱, yaku̱n campa haan du̱gu̱ bo̱-u̱ Afisa. Wa-yahuda wa wu̱ na foge̱ Apo̱ro̱s. Ne̱tu̱ bo̱-u̱ Are̱kzandariya wa. Wa nak u̱s-rem sok. Tu̱msu̱ wa nak Rem-su̱ u-Ru̱ u̱r-zwar ne̱. ");
INSERT INTO gel_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","E̱ke̱n a-dor-ne̱ iis-tu̱ wu̱n u̱-me̱ fu̱n-yu̱ Wa-ko-uyan. Tu̱msu̱ wa kere̱ no̱m-du̱ u̱s-rem u̱ teku̱ u̱t-ne̱t so̱k, tu̱msu̱ wa o̱gu̱ is-u̱ u̱t-ne̱t u̱t-nip u̱ mo̱ttu̱ Ye̱so̱ u̱ka ku̱mte̱. Se̱di wa nak Ye̱so̱ ko-uyan u̱-me̱ Ye̱so̱ da, wa nak di mo̱t-tu̱ u̱t-yu̱bu̱sse̱ m-bu̱ u̱ no̱mu̱ u̱t-ne̱t u̱ wa nape̱ du̱gu̱ Yohanna Wa-u̱t-yu̱bu̱sse̱ m-bu̱. ");
INSERT INTO gel_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Wa he̱e̱se̱ no̱m-du̱ u̱s-rem za u-gye̱r u̱-me̱ Kur-u̱ u̱t-Ko̱se̱. Biskira u̱ Akira hog rem-u̱s ro, se̱ e̱ fog wu̱n u̱-kit m-yasa. E̱ sur m-waru̱ wu̱n u̱r-zwar ne̱ u̱ka fu̱n-yu̱ u-Ru̱ o̱tte̱ yu̱ wa yete̱ ne̱t-ne̱ fat-du̱ za u̱r-ma. ");
INSERT INTO gel_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Da-u̱ Apo̱ro̱s o̱o̱ge̱ u̱ssa wa do̱'e̱ u̱ dak-u̱ Akaya, a-doru̱ Ye̱so̱ se̱gu̱ wu̱n. E̱ pu̱n u-ran m-ha u̱du̱ a-dor-ne̱ i o̱ u̱ Akaya e̱ kab wu̱n u̱t-kom u̱t-yu̱r. Da-u̱ wa haye̱ u̱ku̱n, ha-m ro shu̱'u̱t u̱r-se̱ge̱ sok u̱du̱ a-dor-ne̱ i ya jab-u̱ nya-u u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Wa no̱ng iya remu̱ zu̱ wa ru̱u̱g Yahuda-ne̱ u-tát u̱r-orop u̱ te̱k-u̱ u̱t-ne̱t, wa o̱gu̱ waru̱ u̱n u̱ te̱k-u̱ no̱m-tu̱ na pane̱ me̱ Rem-su̱ u-Ru̱ u̱zu̱ Ye̱so̱ wa o̱ Kiristi. ");
INSERT INTO gel_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Da-u̱ Apo̱ro̱s o̱o̱ge̱ u̱ Ko̱rintiya, Burus to u̱-me̱ dak-u o̱ wa te bo̱-u̱ Afisa, ku̱na wa bitte̱ e̱ke̱n a-doru̱ Ye̱so̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Se̱ wa zu̱ u̱n, <<¿No̱ kwu̱ng Yar-u u-Ru̱ da-u̱ no̱ ya' jab?>> Se̱ e̱ zu̱, <<O'o, it ho̱k u̱zu̱ Yar-u u-Ru̱ o̱ro da.>> ");
INSERT INTO gel_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Tu̱msu̱ wa zu̱, <<¿Yan go̱-du̱ u̱t-yu̱bu̱sse̱ tu̱ m-bu̱ to̱ na no̱mu̱ no̱?>> E̱ zu̱, <<Go̱-du̱ tu̱ Yohanna to̱.>> ");
INSERT INTO gel_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Burus zu̱, <<Yohanna no̱ng u̱t-yu̱bu̱sse̱ m-bu̱ no̱ngu̱ ne̱t-ne̱ u̱t-yu̱bu̱sse̱ m-bu̱, i byu̱r-ne̱ e̱ yage̱ yu̱du̱ ba'as-u̱t e̱, wa o̱gu̱ waru̱ ne̱t-ne̱ e̱ ya jab-u̱ waku̱n wu̱ de̱ haan u̱ dim-u̱ wa, wato Ye̱so̱.>> ");
INSERT INTO gel_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Da-u̱ u̱n ho̱ge̱ iya, na no̱mu̱ u̱n u̱t-yu̱bu̱sse̱ m-bu̱ u̱ te̱k-u̱ dim-u̱r Wa-ko-uyan Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Da-u̱ Burus do̱ru̱ u̱n u-kom, Yar-u u-Ru̱ he̱e̱n u̱ do̱m-u̱ u̱n, u̱n hu̱ no̱m-du̱ u̱s-rem u̱ to̱ko̱n rem-to̱ u̱ warru̱ no̱m-tu̱ Yar-u u-Ru̱ ko̱su̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","U̱n teeg campa-ne̱ u̱ka o̱p-u̱ yu̱r 12. ");
INSERT INTO gel_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Se̱ Burus to u̱-me̱ Kur-u̱ u̱t-Ko̱se̱ wa o̱gu̱ warru̱ rem-su̱ u-Ru̱ jab gan. Wa teeg u̱s-pyaat u̱s-tu̱t u̱ku̱n wa, wa o̱gu̱ parru̱ u̱n u̱ waru̱ mo̱ttu̱ Faru̱k-du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Se̱di e̱ke̱n gu̱gu̱m kab-du̱ rem-u̱s se̱ remu̱ hu̱k-mu̱ u̱r-hi har e̱ no̱mu̱ e̱ke̱n a-dor-ne̱ gom-u̱ rim-o̱ u̱ te̱k-u̱ u̱t-ne̱t. Remu̱ iya Burus yage̱ u̱n, wa nok u̱ a-dor-ne̱, wa o̱ u̱t-ko̱se̱ ko mu̱ne̱ u̱ makaranta-u Tiranus. ");
INSERT INTO gel_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Burus no̱ng iya m-te̱ u̱s-hak u̱s-yu̱r, har ne̱t-tu̱ o̱gu̱ u̱r-shu̱'u̱t u̱ Asiya e̱ hog rem-su̱ Wa-ko-uyan Ye̱so̱, Yahuda-ne̱ u̱ i za-yahuda-ne̱ da be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ru̱-u̱ yaag Burus m-shin mu̱ no̱m-du̱ no̱m-tu̱ m-shin so̱k. ");
INSERT INTO gel_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Abite̱ i o̱tte̱ u̱s-go̱m haagu̱n u̱du̱ Burus da, e̱ke̱n no̱m-du̱ ko̱o̱k u̱s-hund ko u̱t-kus tu̱ Burus tame̱, na de̱ u̱t-kab na do̱ru̱ a-ko̱b-du̱ m-yar ne̱. Remu̱ iya, ne̱t-tu̱ o̱tte̱ ko̱b-du̱ m-yar e̱ de̱ kwu̱m-du̱ m-yar, tu̱msu̱ i no̱m-u̱s u̱s-te o̱o̱ge̱ yadu̱ u̱r-ko̱b, e̱ de̱ u̱r-rwu̱ remu̱ no̱mu̱ Burus no̱me̱. ");
INSERT INTO gel_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Se̱ e̱ke̱n Yahuda-ne̱ a riig-tu̱ ruutu̱ no̱m-u̱s u̱s-te ne̱, e̱ u̱t-sa e̱ kab dim-u̱r Ye̱so̱ e̱ hu̱u̱tu̱ rutu̱ no̱m-u̱s u̱s-te. E̱ zu̱, <<U̱m zu̱ u̱ dim-u̱r Wa-ko-uyan Ye̱so̱ du̱ Burus o̱ bu̱t-u̱t wa, ruun!>> ");
INSERT INTO gel_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","E̱ke̱n yaage̱ o̱ro ta'er, yaag-u̱ Siba, wa-Yahuda, wu̱ foge̱ hi-u̱r wa yu̱-Yat-ya a-To̱o̱g. ");
INSERT INTO gel_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","De̱ku̱n ho̱-de̱ e̱ o̱ te̱k u̱t-no̱m iya, no̱m-yu̱ u̱s-te gu̱gu̱m u̱r-rwu̱. Se̱ no̱m-yu̱ u̱s-te shu̱s ya zu̱ u̱n, <<U̱m nak Ye̱so̱, u̱m nak Burus. ¿Se̱di no̱ wanne̱ no̱ o̱ye̱?>> ");
INSERT INTO gel_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Campa-yu̱ o̱tte̱ no̱m-yu̱ u̱s-te tu̱ mak wa he u̱n u̱t-war. Wa zeg be̱b-u̱r u̱n wa kemu̱sse̱ u̱n u̱t-kus wa ho̱n-su̱ u̱n, u̱n ru du̱gu̱ bu-u o̱ m-so̱m u̱t-so tu̱msu̱ u-war m-ja m-hyu̱. ");
INSERT INTO gel_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ne̱t-tu̱ o̱o̱ge̱ u̱ Afisa be̱e̱t, u̱ Yahuda-ne̱ u̱ i za-yahuda-ne̱ da ho̱ge̱ rem-su̱ no̱m-u̱ na no̱me̱, gye̱r-u̱ ship e̱, tu̱msu̱ u̱n sekmu̱sse̱ dim-du̱ Wa-ko-uyan Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","U-tat u̱ te̱k-u̱ i ya jab e̱ haan e̱ o̱ warru̱ no̱m-u̱t yo̱-to̱ tu̱ e̱ no̱me̱ u̱ te̱k-u̱ u̱t-ne̱t. ");
INSERT INTO gel_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","U̱t-ne̱t u-tát i nome̱ u-gwat, e̱ gargu̱ssu̱n ran-u̱t u̱n tu̱ u̱s-pan, e̱ doos u-ra u̱ te̱k u̱t-ne̱t u̱t-be̱e̱t. Da-u̱ e̱ do̱re̱ shik-u̱ ran-tu̱ u̱s-pan tu̱ e̱ dose̱ u-ra, shik teeg shik-u̱ pama-u̱ u̱t-ho̱ u̱t-zo̱ngu u̱t-o̱p u-so u-tan 50,000. ");
INSERT INTO gel_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Remu̱ iya rem-su̱ Wa-ko-uyan sur m-cwa ko̱he̱ne̱, se̱ tu̱m jab-su̱ u̱t-ne̱t u-tát. ");
INSERT INTO gel_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Da-u̱ na no̱me̱ no̱m-u̱t to̱ u̱t-be̱e̱t, Burus o̱gu̱ u̱ssa wa do̱'e̱ u̱ Urusharima, se̱di wa dorog u̱zu̱ wa ba m-ha u̱ Gas-u̱ dak-tu̱ Makidoniya u̱ Akaya ne̱ uro. Tu̱msu̱ Burus zu̱, <<A u̱m cwaye̱ u̱ Urusharima, me̱ u̱t-fang m-te̱ bo̱-u̱ Roma.>> ");
INSERT INTO gel_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Se̱ wa tom ne̱t-ne̱ yu̱r u̱ te̱k-u̱ a-u̱r-se̱ge̱ ro ne̱, Timoti u̱ Eratus ne̱ m-ha u̱ Makidoniya, wa hen wa tumb cashi u̱ dak-u̱ Asiya. ");
INSERT INTO gel_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Da-u na no̱me̱ iya, e̱ke̱n u̱ te̱k-u̱ ne̱t-tu̱ Afisa, yu̱nu̱s jab-su̱ ne̱t-tu̱ ya jab u̱du̱ Ye̱so̱. E̱ ho̱k u̱s-ryab sok remu̱ zu̱ a-dor zu̱u̱g Ye̱so̱ wa o̱ fu̱n-yu̱ kwu̱m-du̱ fat-du̱ za u̱r-ma. ");
INSERT INTO gel_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Yu̱nu̱s-du̱ u̱s-jab takku̱n u̱du̱ yaku̱n campa-ya wa-u̱ u-zwa na zu̱ wa Dimitiriyus. Wa mu̱ye̱ pyu̱-m re̱k-mo̱ u̱ azurfa mu̱ o̱tte̱ sha-mu̱ pyu̱ yat-o̱ u̱ Atemis. Ne̱t-tu̱ o̱ pyu̱-m mo̱ remu̱ e̱ ye'et Atemis m-ze̱g. Dimitiriyus u̱ to̱ko̱n ne̱t-to̱ ne̱ kwu̱mu̱g shik sok u̱ remu̱ cerpa-u o̱. ");
INSERT INTO gel_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Wa fog u̱n be̱e̱t, u̱r-kot u̱ a go̱-du̱ sa-u o̱ ne̱, wa zu̱, <<No̱ ne̱t-ne̱, no̱ nak u̱zu̱ sa-u uno̱ o̱ it kumte̱ shik sok. ");
INSERT INTO gel_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","No̱ hyang tu̱msu̱ no̱ ho̱k, bo̱-u̱ Afisa o̱ war-o̱ da, dak-u̱ Asiya u-be̱e̱t, Burus uya paru̱g u̱t-ne̱t u-tát sok. Wa byu̱u̱g hi-u̱t u̱n u̱zu̱ ru̱-u̱ ne̱t no̱me̱ kom-u̱t wa, a ru̱-o̱ da. ");
INSERT INTO gel_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Za hen u̱t-no̱m u̱ so̱-se̱ iya da. U̱n de̱ na-su̱ dim-du̱ cerpa-u in. A Burus u̱ re̱ shu̱ u̱t-no̱m inya, u̱t-wa u̱ ne̱t-tu̱ yage̱ no̱mu̱ Atemis ru̱-u yat-o̱ u̱t-huuk. Tu̱msu̱ na de̱ mo̱t-du̱ o̱ u̱ sek-m wa ne̱, no̱m-u̱ ne̱t-tu̱ dak-u̱ Asiya u-be̱e̱t har dak-u uno̱ o̱ no̱me̱-du̱ u̱t-huuk.>> ");
INSERT INTO gel_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Da-u̱ e̱ ho̱ge̱ inya, se̱ e̱ hog u̱s-ryab sok, e̱ yu̱ns u̱s-cwar u-da u-gan e̱ zu̱, <<m-Sek u̱du̱ Atemis u̱ Afisa-ne̱!>> ");
INSERT INTO gel_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Bo̱-u̱ rukuste̱, ne̱tu̱ ku̱su̱n m-ha u̱ be-du̱ u̱r-mo̱ro̱g, u̱n o̱ nak-du̱ Gayus u̱ Aristakus ne̱, i rwu̱ne̱ du̱gu̱ dak-u̱ Makidoniya, e̱ o̱ye̱ hu̱u̱b-tu̱ u̱r-no̱ku̱ Burus. ");
INSERT INTO gel_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Burus cwang wa cwa u̱du̱ u̱r-mo̱ro̱g, se̱di a-doru̱ Ye̱so̱ ne̱ hoos wu̱n m-ha. ");
INSERT INTO gel_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","To̱ko̱n ne̱nge̱n-tu̱ dak-u̱ Asiya, i o̱ hu̱u̱b-u̱t Burus ko̱ e̱, e̱ tom waku̱n u̱du̱ rò m-ho̱r m-ho̱r u̱zu̱ a wa jar wa cwa u̱ be-du̱ u̱r-mo̱ro̱g da. ");
INSERT INTO gel_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ne̱t-ne̱ be̱e̱t i mo̱rge̱ no̱m-u̱ zuste̱ kowan, remu̱ zu̱ u̱n nak ko yan-o̱ wa u̱n u̱t-mo̱ro̱g da. E̱ke̱n jaku̱s u̱s-cwar e̱ o̱ se̱ke̱n rem-se̱, tu̱msu̱ e̱ke̱n hu̱ warru̱ su̱ e̱. ");
INSERT INTO gel_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Yahuda-ne̱ tok waku̱n u-shu̱ wu̱ e̱ foge̱ Are̱kzandariya, wa jaku̱s kom-u̱t wa u-ru̱ remu̱ ne̱t-tu̱ ho-u̱t u̱s-ram. Wa u̱t-sa wa waru̱ u̱n u̱zu̱ yu̱ns-du̱ jab ku̱mge̱ u̱du̱ Yahuda-ne̱ da. ");
INSERT INTO gel_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Da-u̱ nape̱ u̱zu̱ wu̱n wa-yahuda wa u̱n yu̱ns cwar-u̱s u̱n uda u-gan u̱n zu̱. <<M-Sek u̱du̱ Atemis wu̱ Afisa!>> U̱n teeg u̱s-kwam u̱s-yu̱r u̱ no̱m-du̱ u-no̱m u-gan. ");
INSERT INTO gel_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Da-u̱ wa-u̱s-ge̱n yu̱ bo̱-u o̱ wa u̱ u̱n u̱ ho̱-du̱ u̱s-ram, se̱ wa zu̱, <<No̱ ne̱t-tu̱ Afisa, kowan nak u̱zu̱ bo̱-u̱ Afisa o̱ u̱ gwat-du̱ pyu̱-u̱ yat-o̱ u̱ Atemis, tu̱msu̱ wu̱ sha-m wa he̱ne̱ du̱gu̱ do̱m u-ru̱. ");
INSERT INTO gel_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ba shu̱'u̱te̱ ka u̱t-no̱m zaar na se̱ no̱m-u̱t to̱ da, ku̱mge̱ no̱ rest jab, a no̱ no̱m ko-uyan u̱ te̱k-u̱ m-ho̱r da. ");
INSERT INTO gel_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","No̱ hattu̱n ne̱t-u̱t tun-to̱ u̱ ane̱, remu̱ zu̱ e̱ no̱ng no̱m-u̱t yo̱-o̱ da. E̱ no̱ng u-hiw u̱-me̱ pyu̱-u̱ yat-o̱ u̱ Atemis. Tu̱msu̱ e̱ pyapu̱k ru̱-u in da. ");
INSERT INTO gel_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Se̱di abite̱ Dimitiriyus u̱ i o̱ u̱r-kot u̱ wane̱ o̱tte̱ o̱ko̱n no̱m-o̱ u̱ e̱kse̱ e̱ u̱ waku̱n ne̱, kur-u̱ kwu̱p-du̱ u̱s-rem u̱ ya u̱r-hu̱k, tu̱msu̱ a-kwu̱p-du̱ u̱s-rem o̱ro, se̱ e̱ hu̱u̱t u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Tu̱msu̱ abite̱ o̱ko̱n o̱ro u̱ no̱ u̱t-sa no̱ shit, se̱ na mang ko-uyan u̱-me̱ u̱r-mo̱ro̱g. ");
INSERT INTO gel_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","U̱t-nip, u̱m o̱ m-hyan u̱zu̱ in o̱ te̱k-u̱ a swadu̱ u̱r-ko̱b ne̱, ba shu̱'u̱te̱ u̱zu̱ in za keru̱ warru̱ o̱ko̱n no̱m-o̱ u̱ hatu̱n uno̱ gwu̱z-o̱ u̱ ya-o̱ da. A faru̱k-u̱ Roma u̱ shite̱ u̱zu̱ gwu̱z-u̱ yan-o̱ na o̱tte̱, in zatte̱ no̱m-u̱ u̱t-zu̱ da.>> ");
INSERT INTO gel_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Da-u̱ wa tase̱ u̱s-rem inya se̱ wa zu̱ u̱ ne̱t-tu̱ aru̱k. ");
INSERT INTO gel_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Da-u̱ gwu̱z habe̱, Burus tom fagu̱n a-dor Ye̱so̱. Wa ye' e̱ shiriktin-mu̱ jab. Se̱ wa aru̱k, wa do̱'e̱ u̱ dak-u̱ Makidoniya. ");
INSERT INTO gel_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Da-u̱ wa nu̱rse̱ be-u̱t to̱ u̱t-be̱e̱t, wa ye' e̱ shiriktin-mu̱ jab sok, se̱ wa te u̱ dak-u̱ Giris. ");
INSERT INTO gel_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ku̱na wa shu̱'u̱te̱ m-te u̱s-pyaat u̱s-tu̱t. Wa o̱gu̱ te̱k-u̱ zo̱ng-su̱ cwadu̱ u-hat wa do̱te̱ u̱ dak-u̱ Suriya. E̱ wa hog u̱zu̱ e̱ke̱n Yahuda-ne̱ zo̱ngte̱ no̱mu̱ wu̱n no̱m-u̱t yo̱-to̱. Remu̱ iya wa hyen wa dor u-dak m-mu̱, se̱ wa aru̱k wa dor u̱-me̱ Makidoniya. ");
INSERT INTO gel_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ne̱t-u̱t tun-to̱ to̱ shu̱'e̱ wu̱n, Sufata wa'-u̱ Farus du̱gu̱ Biriya, u̱r-kot u̱ Aristakus ne̱ u̱ Sandu̱nkus (ne̱t-tu̱ Tasaronika), u̱ Gayus (du̱gu̱ Darbe), u̱ Timoti, u̱ Tikikus ne̱, u̱ Tarofimus (ne̱t-tu̱ Asiya). ");
INSERT INTO gel_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","E̱ ba'ag it m-aru̱k, e̱ e̱stu̱ it u̱ Toruwa. ");
INSERT INTO gel_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Da-u̱ na tase̱ Mo̱ro̱g-du̱ u̱r-Be̱re̱di du̱ za m-Yis, It he̱n it yu̱ne̱ du̱gu̱ bo̱-u̱ Firibi u̱-me̱ u-hat. Da-u̱ roog-mu̱ u̱t-tan arke̱ it te̱ Toruwa it bit ne̱t-u̱t to̱ i arku̱n kanda it no̱ko̱n u̱ku̱n. Se̱ it shu̱'u̱t u̱ Toruwa m-roog u̱t-ta'er. ");
INSERT INTO gel_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","U̱ ho̱-du̱ u̱r-taku̱n du̱ roog-mu̱ u̱t-ta'er it mo̱ro̱g remu̱ it Mot u̱r-Be̱re̱di it baku̱ste̱ u̱ mar-m Wa-ko-uyan. Se̱ Burus hu̱ no̱mu̱ ne̱t-ne̱ u̱t-him u̱ te̱k-u̱ m-gyu̱p, remu̱ zu̱ wa o̱ zo̱ng-su̱ u̱r-aru̱k u̱r-is gas. ");
INSERT INTO gel_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","It mo̱ro̱gte̱ u̱ kur-u̱ do̱m. Ku̱na hitirra-su̱ o̱tte̱ u-tát u̱r-do̱. ");
INSERT INTO gel_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Da-u̱ Burus o̱o̱ge̱ u̱s-rem, e̱ke̱n zwar-e̱ o̱ shu̱'u̱t u̱ do̱m pyam-yu̱ u-kur na zu̱ wa Yutikus, roog-mu̱ kos wa. Da-u̱ Burus o̱o̱ge̱ u̱s-rem za u̱r-ma, roog-mu̱ kost Yutikus har wa he̱e̱n du̱gu̱ u-kur u̱ do̱m-u̱ o̱, na ku̱b wa u̱r-u. ");
INSERT INTO gel_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Se̱ Burus ciz u-dak wa ku̱b wu̱n. Wa zu̱, <<Ana naas jab da, wa o̱ u̱r-fat!>> ");
INSERT INTO gel_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Se̱ Burus mu u̱ do̱m kur-u̱ do̱m, wa Mot u̱t-Be̱re̱di, it re. Wa re shu̱ u̱ no̱mu̱ u̱n u̱s-rem har is gu̱s da-u o̱ wa aru̱k. ");
INSERT INTO gel_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Se̱ u̱n nok i-zwar ne̱ u̱r-fat ne̱, u̱n nom u̱r-so̱ sok. ");
INSERT INTO gel_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Burus aru̱kte̱ m-ha bo̱-u̱ Asus u̱ fu̱n-yu̱ u-dak, ku̱na wa zo̱ngte̱ u̱zu̱ it bit wu̱n. It hen it dor u-hat. ");
INSERT INTO gel_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Da-u̱ wa bite̱ it u̱ Asus, it ku̱b wu̱n u-hat it haan u̱ bo̱-u̱ Mitirin. ");
INSERT INTO gel_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tu̱msu̱ du̱gu̱ ku̱n it re shu̱ m-ha ne̱ u̱-me̱ u-hat. Is o̱ m-gas it te u̱ Gas-u̱ Kiyos. Tu̱msu̱ da is gase̱ it u̱ ya Gas-u̱ Samos. Da tase̱ it aru̱k m-ha u̱ bo̱-u̱ Miretus. ");
INSERT INTO gel_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Burus o̱gu̱ zu̱u̱g wa za u̱r-cu̱z u̱ bo̱-u̱ Afisa da, remu̱ gye̱r-u̱ naasu̱ u-da u̱ dak-u̱ Asiya. Wa o̱gu̱ m-ho̱r, wa cwang u̱zu̱ a-za no̱me̱ wa te Urusharima kanda ho̱-du̱ Mo̱ro̱g-du̱ Fentikos. ");
INSERT INTO gel_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Da-u̱ hat-yu̱ te bo̱-u̱ Miretus Burus to̱m na fagnu̱ wa ne̱nge̱n-tu̱ a-doru̱ Ye̱so̱ tu̱ bo̱-u̱ Afisa wa no̱m u̱s-rem u̱ e̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Da-u̱ e̱ haane̱ u̱du̱ ro se̱ wa zu̱ u̱n, <<No̱ hi-du̱ war-no̱, no̱ nak ko̱ yan go̱-du̱ u̱r-yu̱ de̱ u̱m no̱me̱ tun du̱gu̱ da-u̱ u̱m cwane̱ u̱ dak-u̱ Asiya. ");
INSERT INTO gel_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","No̱ nak u̱ka u̱m dorte̱ Wa-ko-uyan Ye̱so̱ u̱ yadu̱ m-ze̱g ne̱, tu̱msu̱ u̱m nom u̱s-kan u̱ remu̱ u̱t-ne̱t. Tu̱msu̱ no̱ nak u̱zu̱ u̱m swaag u̱r-ko̱b sok, remu̱ Yahuda-ne̱ i za dor da cwang e̱ ho̱nsu̱ me̱. ");
INSERT INTO gel_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Tu̱msu̱ u̱m yakke̱ za waru̱ no̱ o̱ko̱n u̱ de̱ se̱gu̱ no̱ da, u̱m waru̱ no̱ rem-su̱ u-Ru̱ tu̱msu̱ u̱m is-u̱ no̱ u̱ te̱k-u̱ u̱r-ban tu̱msu̱ u̱ me̱ u̱t-bu ne̱. ");
INSERT INTO gel_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","U̱m no̱ngu̱ Yahuda-ne̱ u̱ i za-yahuda-ne̱ da u̱t-bu̱t u̱ mo̱ttu̱ u̱t-byu̱ru̱n u̱du̱ u-Ru̱ e̱ yage̱ u̱t-ba'as, tu̱msu̱ e̱ ya' jab u̱du̱ Wa-ko-uyan Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","<<Yar-u̱ u-Ru̱ ko̱sku̱ me̱ u̱zu̱ u̱m do̱'e̱ u̱ Urusharima, se̱di u̱m nak no̱m-u̱ de̱ kwu̱m-du̱ me̱ u̱ku̱n da. ");
INSERT INTO gel_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ko ba shu̱'u̱te̱ u̱zu̱ Yar-u u-Ru̱ o̱gu̱ waru̱ me̱ ko̱ bo̱-u̱ he̱ na do̱'e̱ tagu̱ me̱ u̱ kur-u̱ m-to̱k, tu̱msu̱ swadu̱ u̱r-ko̱b o̱ e̱stu̱ me̱ u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Se̱di me̱, u̱m mutte̱ fat-u̱r ri o̱ko̱n no̱m-o̱ da, abite̱ me̱ keru̱ tasu̱ no̱m-u̱ Wa-ko-uyan Ye̱so̱ wa me̱ u̱t-no̱m. Wa dak me̱ u̱m no̱m do̱nse̱-du̱ Rem-su̱ m-Re̱me̱r u̱zu̱ Ru̱-o̱ Wa-u-u̱ku̱r tu̱msu̱ u̱ nya-u u-Ru̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","<<U̱m no̱ngu̱ no̱ u̱t-bu̱t u̱ka Ru̱-u̱ o̱tte̱ u̱ssa wa dor-u̱t jab-su̱ u̱t-ne̱t. Se̱di u̱m nak u̱ ya-o̱ o̱ m-vaste̱ u̱zu̱ no̱ o̱r-u̱t ri ne̱ a-dor do̱te̱ hyan-du̱ me̱ da tu̱msu̱. ");
INSERT INTO gel_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","U̱m u̱t-sa no̱ nap u̱zu̱, wu̱ ho̱ge̱ bu̱t-u̱t ri, tu̱msu̱ wa mu̱r za kab Ye̱so̱ ba'as-u̱t ri to̱ da. ");
INSERT INTO gel_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","U̱m zu̱u̱g iya remu̱ zu̱ u̱m wargu̱ no̱ no̱m-u̱ Ru̱-u̱ u̱t-sa u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Gwatu̱n hi-u̱t no̱ u̱r-zwar ne̱, u̱ ne̱t-tu̱ Yar-u u-Ru̱ ya'u̱ no̱ u̱t-gwat ne̱. Re̱e̱n shu̱ u̱ gwat-du̱ a-doru̱ Ye̱so̱ i Ru̱-u̱ kwu̱mne̱ u̱ hi-u̱r wa tu̱msu̱ u̱ hyu̱-mu̱ Wa'-u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","U̱m nak da-u̱ u̱m arke̱, ne̱t-tu̱ nome̱ ko̱se̱-tu̱ u̱s-bi de̱ haan. E̱ u̱t-sa e̱ ho̱ru̱sse̱ ban-du̱ a-dor u̱ka o̱-yu̱ u-dak nomte̱ ban-du̱ ca. ");
INSERT INTO gel_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ko te̱k-u̱ me̱ no̱, e̱ke̱n do̱'e̱ u̱r-yu̱ne̱ e̱ no̱m rem-su̱ u̱s-bi remu̱ zu̱ e̱ naktu̱n u̱t-ne̱t u̱ haan u̱du̱ e̱. ");
INSERT INTO gel_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Remu̱ iya, shu̱'u̱tu̱n u̱s-zo̱ng ne̱, tas waku̱n u̱ te̱k-u̱ me̱ no̱ wa yage̱ yadu̱ jab u̱du̱ Wa-ko-uyan Ye̱so̱, baksu̱n u̱ da-o̱ u̱zu̱ u-ho̱ m-gyu̱p ne̱ u̱zu̱ u̱m no̱ng u̱s-hak u̱s-tu̱t u̱m no̱ngu̱ no̱ u̱t-him m-is ne̱ u̱ is-u̱ ri tas no̱ kab to̱ko̱n ko̱se̱-to̱ da. ");
INSERT INTO gel_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","<<U̱ da-o̱ hen u̱m yakku̱ no̱ u̱ kom-tu̱ u-Ru̱ tu̱msu̱ u̱ rem-su̱ nya-u wa u̱ no̱m u̱r-kot u̱ no̱ ne̱, no̱ u̱t-shu̱'u̱t u̱r-be̱b ne̱ tu̱msu̱ o̱ ya' no̱ u̱r-o̱g u̱r-kot u̱ i o̱ ne̱t-tu̱ u-Ru̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","U̱m za cwan-tu̱ shik ko cwu̱-u̱t waku̱n da. ");
INSERT INTO gel_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","No̱ hi-du̱ war-no̱, no̱ nak u̱zu̱ u̱m no̱ng pama-u̱ hi-du̱ war ri, remu̱ u̱m ho̱tu̱ hi-du̱ war ri m-'e̱ u̱ i o̱ u̱r-kot u̱ me̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","U̱ te̱k-u̱ tun-to̱ u̱t-be̱e̱t tu̱ u̱m no̱me̱, U̱m no̱ng to̱ remu̱ u̱m ko̱s-tu̱ no̱ u̱zu̱ a in o̱ u̱t-no̱m iya, inu̱ keru̱ se̱gu̱ ku̱shin ku̱shin ne̱. Tu̱msu̱ in baksu̱n u̱ rem-su̱ Wa-ko-uyan Ye̱so̱ ne̱ su̱ zu̱ye̱, <In nom u̱r-so̱ a ne̱t-tu̱ nya in no̱mu̱ in u̱t-sa, se̱di u̱t-ze̱g m-no̱m u̱r-so̱ a in nya u̱t-ne̱t no̱mu̱ e̱ u̱t-sa.> >> ");
INSERT INTO gel_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Da-u̱ Burus tase̱ u̱t-war inya, se̱ wa u̱t-jwu̱n wa nom u̱s-to̱o̱g u̱ u̱n ne̱ be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Se̱ u̱n be̱e̱t u̱n hu̱ u̱s-kan, u̱n ham-u̱t Burus u̱n hu̱ pa-tu̱ wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","U̱n naas jab sok remu̱ rem-su̱ wa no̱me̱ u̱zu̱ u̱n zamnu̱ hyan-du̱ wu̱n da tu̱msu̱, se̱ u̱n shu̱'u̱ wu̱n m-ha u̱du̱ u-hat. ");
INSERT INTO gel_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Da-u̱ it zu̱ ne̱nge̱n-tu̱ Afisa se̱ u̱r-ho̱, se̱ it to u̱-me̱ u-hat m-ha u̱ bo̱-u̱ Kos, u̱ be-du̱ hat-su̱ eeste̱ m-gyu̱p. Da-u̱ is gase̱ it aru̱k m-ha u̱ gi-yu̱ Rods tu̱msu̱ u̱ be-du̱ hat-su̱ eeste̱. Tu̱msu̱ du̱gu̱ ku̱n it aru̱k m-ha u̱ bo̱-u̱ Fatara. ");
INSERT INTO gel_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Da-u̱ it kume̱ hat-yu̱ ha-mu̱ dak-u̱ Finikiya, it to m-ha u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Da-u̱ it hyanne̱ dak-u̱ Sayifurus, it hu̱t it tok o̱ u̱ kom u̱r-beer it, it aru̱k m-ha u̱ dak-u̱ Suriya. Se̱ it ciz u̱ bo̱-u̱ Taya remu̱ zu̱ ku̱na hat-yu̱ do̱te̱ cu̱st-u̱ u̱t-cwu̱. ");
INSERT INTO gel_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Da-u̱ it te be-du̱ a-dor-ne̱ o̱tte̱, it shu̱'u̱t u̱ku̱n har m-roog u̱t-ta'er. Yar-u u-Ru̱ wargu̱ a-doru̱ Ye̱so̱ u̱zu̱ ne̱t-to̱ ya Burus u̱r-ko̱b a wa do̱'e̱ u̱ Urusharima. Remu̱ iya hen u̱n zu̱ a wa do̱'e̱ da. ");
INSERT INTO gel_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","A da-u̱ u̱r-yu̱ne̱ it no̱me̱, it yu̱ne̱ it hu̱ m-ha. A-dor-ne̱ be̱e̱t i o̱ u̱ku̱n ne̱ta-ne̱ u̱ yaag-u̱ u̱n ne̱, e̱ shu̱'u̱ it m-ha dim-u̱ u-bo̱, se̱ it he u̱t-jwu̱n u̱ku̱n u̱ kit m-bu̱ it nom u̱s-to̱o̱g. ");
INSERT INTO gel_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","It kowan zu̱ o̱ru̱ wa se̱ wa'aste̱. Se̱ it to u̱-me̱ u-hat, se̱ a-dor-ne̱ i o̱ u̱ku̱n kowan aru̱k m-mu̱ bu-u wa. ");
INSERT INTO gel_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Da-u̱ it teye̱ bo̱-u̱ Taya it eeste̱ u̱ aku̱n da se̱ da it tene̱ bo̱-u̱ Toremayis It vu̱ku̱s o̱r-u̱t it ne̱, it ees u̱ku̱n u̱ gyu̱p-m mo̱ u̱du̱ e̱. ");
INSERT INTO gel_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Da-u̱ is gase̱ it aru̱k m-pas u̱ bo̱-u̱ Kasariya, it to u̱ bu-u Firibus wa-warru̱ Rem-su̱ m-Re̱me̱r. Wa o̱ te̱k-u̱ ne̱t-ne̱ ta'er i na dage̱ remu̱ e̱ nom-tu̱ u-pama u̱ a-dor-ne̱ u̱ Urusharima, it ciz u̱du̱ ro. ");
INSERT INTO gel_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Wa o̱tte̱ ya-u̱t-gwu̱p nas i no̱me̱ u̱t-gu̱ da, e̱ be̱e̱t kowan wu̱r no̱mu̱ Yar-u u-Ru̱ zu̱ wa war. ");
INSERT INTO gel_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Da-u̱ it no̱mu̱ u̱t-ho̱ u̱ku̱n cashi, se̱ waku̱n wa-warru̱ rem-su̱ u-Ru̱ haan du̱gu̱ gas-u̱ Yahudiya na zu̱ wa Agabus. ");
INSERT INTO gel_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Da-u̱ Agabus haane̱ u̱du̱ it, se̱ wa ku̱b hap-u Burus. Agabus gu̱g hi-u̱r wa, kom-u̱t wa u̱s-na ne̱ se̱ wa zu̱, <<No̱m-u̱ Yar-u u-Ru̱ zu̱ye̱ ya, <Iya o̱ Yahuda-ne̱ i Urusharima do̱te̱ gu̱ksu̱ wu̱ o̱tte̱ hap-u inya, tu̱msu̱ e̱ yasu̱ wa u̱du̱ i za-yahuda-ne̱ da.> >> ");
INSERT INTO gel_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Da-u̱ it ho̱ge̱ iya it u̱ ne̱t-tu̱ o̱ ku̱n ne̱ u̱t-be̱e̱t, it kon Burus a wa do̱'e̱ u̱ Urusharima da. ");
INSERT INTO gel_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Se̱ Burus zu̱, <<¿Remu̱ yan-o̱ no̱ o̱tte̱ u̱t-no̱m inya? ¿Re̱ no̱ o̱tte̱ u̱s-kan u̱ na-su̱ me̱ jab? U̱m zo̱ngte̱ u̱ ne̱t-tu̱ gu̱g-u̱t me̱ tu̱msu̱ e̱ ho̱ me̱ u̱ Urusharima remu̱ zu̱ u̱m o̱ no̱mu̱ Wa-ko-uyan Ye̱so̱ u̱t-huuk.>> ");
INSERT INTO gel_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ba it kere̱ parru̱ wu̱n da, se̱ it ho u̱s-ram it zu̱, <<Yage̱ Ru̱-u̱ no̱m no̱m-u̱ cite̱ wa.>> ");
INSERT INTO gel_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Da tase̱, it zo̱ng it do̱'e̱ u̱ Urusharima. ");
INSERT INTO gel_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","E̱ke̱n a-dor-ne̱ du̱gu̱ Kasariya e̱ shu̱'u̱ it, e̱ hu̱u̱t it u̱du̱ Manason wu̱ it de̱ u̱r-cu̱z u̱du̱ wa, ne̱tu̱ bo̱-u̱ Sayifurus wa, wa o̱ te̱k-u̱ a-dor-ne̱ i u̱r-taku̱n. ");
INSERT INTO gel_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Da-u̱ it teene̱ Urusharima, or-u̱t it ne̱ gu it u̱t-kom u̱t-yu̱r. ");
INSERT INTO gel_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Da-u̱ is gase̱ Burus do̱'e̱ u̱ it ne̱ u̱du̱ Yakubu, ne̱nge̱n-tu̱ a-doru̱ Ye̱so̱ u̱t-be̱e̱t hen e̱ o̱ u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Da-u̱ Burus vu̱k-se̱ u̱n, se̱ wa waru̱ u̱n u̱t-no̱m u-tát tu̱ Ru̱-u̱ no̱me̱ u̱-me̱ ne̱t-tu̱ i za-yahuda-ne̱ da du̱gu̱ ank-m wa. ");
INSERT INTO gel_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Da-u̱ e̱ ho̱ge̱ iya, se̱ e̱ no̱mu̱ u-Ru̱ u̱t-vam, e̱ zu̱ Burus, <<Bo̱ hyang u̱t-ne̱t u̱t-zo̱ngu u-tát e̱ yaag jab-u̱ te̱k-u̱ me̱ Yahuda-ne̱, tu̱msu̱ u̱n be̱e̱t hen a shu̱b-du̱ do̱rru̱ u̱t-bo̱r tu̱ Mosa ya it. ");
INSERT INTO gel_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Na wargu̱ Yahuda-ne̱ a-dor, u̱zu̱ bo̱ o̱ iis-u̱ Yahuda-ne̱ be̱e̱t i o̱ te̱k-u̱ i za-yahuda-ne̱ da, e̱ yage̱ do̱rru̱ ko̱se̱-u̱t wa-warru̱ rem-su̱ u-Ru̱ Mosa, tu̱msu̱ bo̱ zu̱ a u̱n no̱mu̱ yaag-u̱ u̱n u̱r-pe̱s da, ko e̱ no̱m u̱ka in nomte̱ u̱r-ma'in da. ");
INSERT INTO gel_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Yan-o̱ in do̱'e̱ u̱t-no̱m? Za u-sakna u̱n do̱'e̱ u̱t-ho̱g u̱zu̱ haagu̱n. ");
INSERT INTO gel_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Remu̱ iya se̱ bo̱ no̱m no̱m-u̱ it waru̱ bo̱. It o̱tte̱ ne̱t-ne̱ nas u̱ te̱k-u̱ me̱ it i no̱me̱ este̱du̱ u̱s-rem u̱r-be̱b ne̱ u̱du̱ u-Ru̱ remu̱ o̱ko̱n no̱m-o̱. ");
INSERT INTO gel_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kabu̱n ne̱t-u̱t tunto̱, tu̱msu̱ jaasu̱n hi-u̱t no̱ u̱r-kot u̱ u̱n ne̱ u̱ka bo̱r-u̱t zu̱tte̱, tu̱msu̱ no̱ to̱p no̱m-u e̱ haatu̱n u̱du̱ to̱o̱g, ko̱ e̱ u̱t-no̱m u-o̱r. Ko̱ ko̱wan u̱t-nap u̱zu̱ no̱m-u̱ na o̱ u̱t-war u̱ u̱n ne̱ a nip-to̱ da, tu̱msu̱ e̱ u̱t-nap u̱zu̱ no̱ hi-u̱r no̱, no̱ o̱ yu̱-du̱ do̱rru̱ u̱t-bo̱r. ");
INSERT INTO gel_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","U̱ mo̱ttu̱ i za-yahuda-ne̱ da i ya jab, It u̱t-ne̱nge̱n u̱ Urusharima, it no̱ng u̱s-rem u̱ mo̱ttu̱ bo̱r-tu̱ e̱ do̱'e̱ u̱t-do̱r, tu̱msu̱ it pangu̱ u̱n u-ran, it waru̱ u̱n u̱ka it cinte̱ u̱s-rem. It panu̱g u̱zu̱ a u̱n tu̱ ap-mu̱ na pane̱ m-gir da, ko̱ e̱ tu̱ hyu̱-mu̱ u-bisa da, tu̱msu̱ a u̱n tu̱ ap-mu̱ bisa-u̱ na myu̱gre̱ u̱r-ge̱ke̱s da. Tu̱msu̱ it wargu̱ u̱n u̱zu̱ a u̱n no̱m m-o̱ da.>> ");
INSERT INTO gel_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Da-u̱ is gase̱, Burus ku̱b ne̱t-u̱t to̱ wa aru̱k u̱nu̱ e̱ ne̱ remu̱ e̱ no̱m-u̱t no̱mu̱ Mosa waru̱ u̱n u̱ mo̱ttu̱ jaasu̱ u-war u̱ remu̱ u̱t-huuk. Sin-se̱ o̱ este̱du̱ u̱s-rem su̱ u̱n no̱me̱ u-Ru̱ u̱r-taku̱n. Se̱ wa to̱ u̱ me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan remu̱ wa nom-u̱t do̱nse̱-du̱ ho̱-du̱ u-zo̱ru̱ u̱n, wato ho̱-du̱ u̱n de̱ ho̱-du̱ u̱t-bisa tu̱ to̱o̱g u̱ remu̱ kowan u̱ teku̱ me̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Da-u̱ ho̱-tu̱ u̱t-ta'er ha m-ta, e̱ke̱n Yahuda-ne̱ du̱gu̱ Asiya e̱ hyen Burus u̱-me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan. Se̱ e̱ yu̱nse̱ gwu̱z u-me̱ mo̱ro̱g-du̱ u̱t-ne̱t. E̱ maas wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","E̱ o̱gu̱ u̱t-jar u̱zu̱, <<No̱ ne̱t-tu̱ Isra-ne̱ no̱mu̱n u̱r-se̱ge̱! Ne̱tu̱ wa ya', wu̱ o̱ u̱t-riig ko̱he̱ne̱ wa o̱ pepru̱ ne̱t-u̱t in, wa hosu̱ ne̱t-ne̱ do̱rru̱ bo̱r-u̱t in. Tu̱msu̱ wa o̱ warru̱ rem-su̱ m-zan mo̱ttu̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan uno̱ ne̱. Wa naaste̱ be-du̱ u-he̱n cwatu̱n ne̱t-tu̱ za-Yahuda-ne̱ u̱-me̱ Bu-u u̱s-To̱o̱g.>> ");
INSERT INTO gel_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(E̱ zu̱u̱g iya remu̱ zu̱ e̱ hyang Burus e̱ Tarofimus, ne̱tu̱ Afisa u̱-me̱ u-bo̱, kabu̱g u̱zu̱ wa o̱o̱g u̱r-kot u̱ wu̱n ne̱ u̱-me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan.) ");
INSERT INTO gel_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Bo̱-u̱ rukus, ne̱t-tu̱ yu̱nne̱ m-so̱m e̱ maas Burus. E̱ ruut wu̱n u̱ me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan, za rem na tage̱ u̱t-is. ");
INSERT INTO gel_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","E̱ o̱ u̱t-sa e̱ ho̱ wu̱n, se̱ rem-su̱ se̱ haan u̱du̱ yu̱-Yat-ya a-m-gag u̱zu̱ Urusharima u-be̱e̱t o̱ te̱k-u̱ gwu̱z sok. ");
INSERT INTO gel_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Za rem se̱ a-m-gag ne̱, u̱ a-m-gag ne̱ i-yate̱ i Roma, e̱ do̱'e̱ u̱ku̱n za naas u-da. Da ne̱t-tu̱ hyane̱ a-m-gag i-yate̱ se̱ e̱ yage̱ gap-du̱ Burus. ");
INSERT INTO gel_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Se̱ yu̱-Yat-ya haan wa maas Burus, wa wu̱ na gu̱g wu̱n u̱ ho-su̱ kwam-u̱s yu̱r. Da-u o̱ yu̱-shu̱ a-m-gag shitu̱ wu̱n u̱zu̱, <<¿Wana bo̱ o̱ye̱? Tu̱msu̱ ¿yan-o̱ bo̱ no̱me̱?>> ");
INSERT INTO gel_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Mo̱ro̱g-du̱ u̱t-ne̱t o̱ hen u̱ pama-u̱ gwu̱z unwa war su̱ unwa war su̱ wa. Remu̱ tat-u̱ gwu̱z, yu̱ yat-ya gwa'ag hi-du̱ rem-u̱s se̱ da. Se̱ wa zu̱ na hu̱u̱t Burus u̱ bu-u̱ a-m-gag. ");
INSERT INTO gel_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Da-u̱ Burus tene̱ be-du̱ u̱t-jang se̱ gwu̱z mang u̱r-yu̱ne̱, se̱ da a-m-gag haane̱ e̱ ku̱b wu̱n u̱ hi-du̱ war u̱n. ");
INSERT INTO gel_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Mo̱ro̱g-du̱ u̱t-ne̱t dor dim-u̱ pama u̱t-jar u̱zu̱, <<Na ho̱ wu̱n! Na ho̱ wu̱n!>> ");
INSERT INTO gel_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Na o̱ mo̱ttu̱ u̱r-cwa u̱ Burus ne̱ u̱-me̱ bu-u̱ karma-ne̱ se̱ wa zu̱ yu̱ yat-ya karma-ne̱, <<¿Ko bo̱ u̱t-ees u̱m no̱m u̱s-rem u̱ bo̱ ne̱?>> Se̱ yu̱ yat-ya karma-ne̱ zu̱ wu̱n, <<¿Bo̱ nak u̱t-Girik rem-u̱r it? ");
INSERT INTO gel_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Bo̱ wa ne̱t-u̱ Masar wu̱ hatu̱n wa yu̱nu̱s-du̱ jab-su̱ u̱t-ne̱t u̱ da-u̱ dim har wa ku̱b ne̱t-ne̱ u̱t-zo̱ngu u̱t-nas a ho̱-du̱ ne̱t-ne̱ u̱-me̱ u̱r-do̱g da?>> ");
INSERT INTO gel_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Se̱ Burus zu̱ wu̱n, <<A'o, me̱ ne̱t-u̱ Yahudiya wa'. Tu̱msu̱ ne̱t-u̱ bo̱-u yat-o̱ o̱, wa Tarsus u̱ dak-u̱ Kirikiya. Remu̱ iya u̱m u̱s-ko̱n yagu̱ me̱ u̱m no̱mu̱ ne̱t-u̱t tun-to̱ u̱s-rem.>> ");
INSERT INTO gel_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Se̱ wa yagu̱ wu̱n. Burus ees u̱ be-du̱ na jange̱, wa jaku̱s u-kom u̱ mo̱ro̱g-du̱ u̱t-ne̱t e̱ ho̱ u̱s-ram. Se̱ e̱ ho u̱s-ram te̱k, se̱ wa no̱mu̱ u̱n u̱s-rem u̱ rem-du̱ u̱t-Ibraniya. ");
INSERT INTO gel_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Burus zu̱, <<O̱r-u̱t ri, u̱t-ne̱nge̱n ne̱, e̱re̱n no̱mu̱ u̱m de̱ waru̱ no̱ u̱ da-o̱, u̱m u̱t-sa u̱m shasu̱ i o̱ ke̱tu̱ me̱ u̱s-rem.>> ");
INSERT INTO gel_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Da-u̱ u̱n ho̱ge̱ u no̱ng u̱s-rem u̱ rem-du̱ u̱t-Ibraniya, se̱ u̱n ho u̱s-ram. Se̱ wa zu̱: ");
INSERT INTO gel_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Me̱ ne̱tu̱ Yahudiya wa, na mak-u̱t me̱ u̱ Tarsus, u̱ dak-u̱ Kirikiya, se̱di ane̱ a u̱m nente̱. U̱m no̱ng u-makaranta u̱ makaranta-u Gamariye̱r, wu̱na is-u̱ me̱ ko-uyan u̱ mo̱ttu̱ bo̱r-tu̱ i mate̱ u̱so-u̱t in. U̱m o̱tte̱ cwan-tu̱ do̱rru̱ u-Ru̱ u̱ka kowan u̱ te̱k-u̱ me̱ no̱ o̱tte̱ u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","De̱ wu̱te̱ u̱m yaag ne̱t-ne̱ i ya jab u̱r-ko̱b u̱ da-u̱ dim-u̱ fu̱n-u ya yu̱ ne̱t-tu̱ foge̱ fu̱n-yu̱ ko̱se̱-u̱t Ye̱so̱. U̱m ho̱o̱g u̱n, u̱m wu̱ na gu̱g u̱t-ne̱t campa-ne̱ u̱ ne̱ta-ne̱ be̱e̱t, u̱m wu̱ u̱n u̱ kur-u̱ m-to̱k. ");
INSERT INTO gel_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Wa-To̱o̱g yu̱-Yat-ya u̱ i shu̱ u̱t-ne̱t ne̱ be̱e̱t e̱ nak tu̱msu̱ e̱ kere̱ u̱t-war u̱ka nomte̱. Du̱gu̱-du̱ u̱n de̱ u̱m ku̱bte̱ u̱t-ran m-ha u̱du̱ o̱r-u̱t it ne̱ Yahuda-ne̱ u̱-me̱ Dimaku. U̱m de̱ge̱ u̱ku̱n u̱m maaste̱ a-doru̱ fu̱n-u ya, u̱m hatu̱n u̱n u̱ Urusharima remu̱ na yu̱'u̱t u̱n u̱r-ko̱b. ");
INSERT INTO gel_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","<<U̱m o̱ te̱k-u̱ u̱r-no̱k, u̱m haag m-te Dimaku, u̱r-ho̱ u̱ te̱k se̱ m-zu̱n du̱gu̱ do̱m u-ru̱ mo̱ gu̱ru̱s me̱. ");
INSERT INTO gel_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Se̱ u̱m he̱'e̱ u-dak, u̱m hog yaku̱n cwar-ya yu̱ o̱ zu̱ me̱, <Shawuru, Shawuru, ¿remu̱ yan-o̱ bo̱ o̱tte̱ yadu̱ me̱ u̱r-ko̱b?> ");
INSERT INTO gel_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","<<U̱m shu̱s u̱zu̱, <¿Wana bo̱ o̱ye̱, yu̱-Yat-ya?> <<Se̱ wa zu̱ me̱, <Me̱ wa Ye̱so̱ wu̱ Nazara wu̱ bo̱ o̱ yadu̱ u̱r-ko̱b.> ");
INSERT INTO gel_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ne̱t-tu̱ o̱ u̱r-kot u̱ me̱ ne̱, e̱ hyang m-zu̱n, se̱di e̱ ho̱k cwar-yu̱ o̱ u̱s-rem u̱ me̱ ne̱ da. ");
INSERT INTO gel_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","<<Se̱ u̱m shit, u̱m zu̱, <¿Wa-ko-uyan, yan-o̱ u̱m de̱ u̱t-no̱m?> <<Se̱ wa zu̱, <Yu̱ne̱ bo̱ cwa u̱ Dimaku, ku̱na na do̱te̱ waru̱ bo̱ no̱m-u̱ bo̱ de̱ u̱t-no̱m.> ");
INSERT INTO gel_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Remu̱ myak-du̱ zu̱nu̱m-mo̱ is-u̱ ri poos, se̱ i it u̱ e̱ ne̱ o̱ye̱ e̱ nu̱k me̱ m-cwa u̱ Dimaku. ");
INSERT INTO gel_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","<<Ku̱na yaku̱n campa-ya wu̱ na zu̱ye̱ Hananiya haan u̱du̱ ri. Wa do̱ru̱ u-Ru̱ wa sok, tu̱msu̱ wa dor bo̱r-u̱t in Yahuda-ne̱. Yahuda-ne̱ be̱e̱t i o̱ u̱r-yu̱ u̱ Dimaku e̱ wu̱r no̱m-u̱t tu̱ wa no̱me̱. ");
INSERT INTO gel_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Wa haan wa zu̱ me̱, <O̱ru̱ ri Shawuru, bo̱ keru̱ kwu̱m-du̱ m-hyan.> Za rem is-u̱ ri upus, u̱m hyen wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","<<Se̱ wa zu̱, <Ru̱-u̱ mate̱ u̱so-u̱t u̱so-u̱t in, wa u̱t-sa bo̱ nap no̱m-u̱ wa u̱t-sa, bo̱ hyan Wa Jab-u̱ So̱-o̱ uno̱, tu̱msu̱ bo̱ ho̱g rem-u̱s ro. ");
INSERT INTO gel_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Bo̱ de̱ shu̱'u̱tu̱ wa-warru̱ rem-u̱s ro u̱du̱ u̱t-ne̱t u̱t-be̱e̱t remu̱ no̱m-u̱ bo̱ hyane̱ tu̱msu̱ bo̱ hog. ");
INSERT INTO gel_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","¿U̱ da-o̱ yan-o̱ bo̱ o̱ u̱t-e̱ste̱? Yu̱ne̱, yage̱ u̱m no̱mu̱ bo̱ u̱t-yu̱bu̱sse̱ m-bu̱, u̱m no̱m u̱s-to̱o̱g u̱du̱ Wa-ko-uyan Ye̱so̱, ko̱n u-Ru̱ wa no̱mu̱ bo̱ ho̱-du̱ ba'as-u̱t ró.> ");
INSERT INTO gel_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","<<Da-u̱ u̱m mu̱ne̱ u̱ Urusharima, u̱m o̱gu̱ u̱s-to̱o̱g u̱-me̱ Bu-u̱ u̱s-to̱o̱g, u̱m nom m-hyan. ");
INSERT INTO gel_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","U̱ te̱k-u̱ hyanu̱-m mo̱ hen, u̱m hyang Ye̱so̱. Wa zu̱ me̱, <Ne̱nge̱ bo̱ yu̱ne̱ bo̱ yage̱ Urusharima m-ho̱r m-ho̱r, remu̱ zu̱ u̱n za u̱t-ees u̱ no̱m-u̱ bo̱ ware̱ e̱ u̱ me̱.> ");
INSERT INTO gel_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","<<Se̱ u̱m zu̱, <Wa-ko-uyan ko u̱n, u̱n nak u̱zu̱ u̱m haag u̱ ko̱-uyan Kur-u̱ u̱t-Ko̱se̱ o̱ u̱m gak i ya jab-u̱ bo̱ ne̱, tu̱msu̱ u̱m gapu̱rte̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Tu̱msu̱ da-u̱ na ho̱ye̱ Istifanus wa-warru̱ rem-u̱s ro, me̱ hi-du̱ war ri u̱m yaag u̱r-be̱b u̱ no̱mu̱ na no̱me̱ u-be̱e̱t, har u̱m o̱ e'-du̱ cwu̱-tu̱ i ho̱ wu̱n ne̱.> ");
INSERT INTO gel_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","<<Se̱ Wa-ko-uyan zu̱ me̱, <Yu̱ne̱ bo̱ no̱k, me̱ to̱mu̱ bo̱ m-ra u̱du̱ i za-yahuda-ne̱ da.> >> ");
INSERT INTO gel_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ban-du̱ u̱t-ne̱t e̱ o̱ e̱rru̱ Burus se̱ da-u̱ wa zu̱ Ru̱-u̱ to̱mo̱g wa u̱du̱ i za-yahuda-ne̱ da. Se̱ e̱ nom u̱t-jar e̱ zu̱, <<Na ho̱ wu̱n! Wa kamu̱g na yagu̱ wa u̱r-fat da!>> E̱ zu̱u̱g iya remu̱ zu̱ e̱ kabu̱g u̱zu̱ Ru̱-u̱ za gwu̱-du̱ waku̱n da se̱ Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Se̱ u̱n hu̱ pama u̱t-jar, u̱n hu̱ gwu̱n-du̱ kus-tu̱ u̱t-ho̱bgu̱ u̱n, tu̱msu̱ u̱n hu̱ as-du̱ m-hyu̱ru̱g m-mya u̱ ko̱se̱ u̱zu̱ u̱n ho̱k u̱s-ryab sok. ");
INSERT INTO gel_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Remu̱ iya se̱ yu̱-shu̱ a-m-gag ne̱ zu̱ na hu̱u̱t wu̱n u̱ bu-u̱ a-m-gag ne̱. Na zwu̱tu̱r wu̱n u̱s-ryap remu̱ u̱n kum-u̱t nap-mu̱ no̱m-u̱ wu̱te̱ ne̱t-tu̱ no̱m-tu̱ wu̱n u̱t-jar. ");
INSERT INTO gel_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Da-u̱ u̱n gu̱gse̱ wu̱n remu̱ e̱ no̱m-tu̱ wu̱n u̱s-ryap, se̱ Burus zu̱ yu̱-shu̱ a-m-gag yu̱ Roma wu̱ o̱ ees u̱ dapu̱s wu̱n, <<Gwatu̱n no̱m-u uno̱ u̱r-zwar ne̱, no̱ do̱'e̱ pas-du̱ no̱m-u̱ bo̱r-tu̱ zu̱ye̱ a no̱ zwu̱tru̱ me̱ ne̱t-u̱ bo̱-u̱ Roma, wu̱na na bite̱ u̱ to̱ko̱n ba'as-to̱ u̱du̱ wa da.>> ");
INSERT INTO gel_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Da-u̱ yu̱-shu̱ karma-ne̱ ho̱ge̱ iya, se̱ wa do̱'e̱ u̱du̱ yu̱-Yat-ya wa zu̱, <<¿Yan-o̱ bo̱ u̱t-sa u̱t-no̱m? Ne̱t unwa wa Roma wa, u̱m kabu̱g u̱zu̱ bo̱ u̱t-wa it no̱mu̱ wu̱n u̱s-ryap da.>> ");
INSERT INTO gel_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Da-u o̱ yu̱-Yat-ya haane̱ wa zu̱ Burus, <<Waru̱ me̱ u̱t-nip, ¿bo̱ ne̱tu̱ Roma wa?>> Se̱ Burus zu̱, <<U̱.>> ");
INSERT INTO gel_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Se̱ yu̱-Yat-ya a-m-gag ne̱ zu̱, <<Me̱, se̱ da u̱m to̱pe̱ shik u-tát kanda u̱m shu̱'u̱te̱ wa Roma.>> Burus zu̱, <<Se̱di me̱ ne̱t-u̱ Roma na ma-tu̱ me̱.>> ");
INSERT INTO gel_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Da-u̱ karma o̱ mo̱ttu̱ he̱e̱se̱ zwu̱tru̱ Burus tu̱msu̱ e̱ shit wu̱n no̱m-u̱ wa no̱me̱. Da-u̱ e̱ ho̱ge̱ no̱mu̱ Burus ware̱, e̱ yagu̱ wu̱n za rem. Ko yu̱-Yat-ya u̱ hi-u̱r wa, wa nak u̱zu̱ Burus ne̱tu̱ Roma wa, se̱ wa hog u-gye̱r remu̱ wa wa'ag karma-ne̱ gu̱g kom-u̱t Burus. ");
INSERT INTO gel_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Da-u̱ is gase̱ yu̱-Yat-ya a-m-gag u̱t-sa wa nap ko yan-o̱ wu̱te̱ Yahuda-ne̱ maaste̱ Burus. Se̱ wa zu̱ karma-ne̱ e̱ ustu̱n Burus. Wa zu̱ a-to̱o̱g i-yate̱ u̱ mo̱ro̱g-du̱ u̱t-ne̱t e̱ kargu̱n. Se̱ wa haatu̱n Burus u̱ shu̱ u̱t-ne̱t. ");
INSERT INTO gel_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Burus saku̱ Mo̱ro̱g-du̱ u̱t-Ne̱nge̱n is, se̱ wa zu̱, <<O̱r-u̱t ri, yu̱-u̱r ri du̱ u̱m no̱me̱ u̱ te̱k-u̱ yadu̱ Ru̱-u̱ in m-ze̱g, tu̱msu̱ u̱m nak o̱kon no̱m-o̱ u̱m no̱me̱ u̱ u̱m nape̱ u̱zu̱ o̱ zaru̱ so̱-o̱ da.>> ");
INSERT INTO gel_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Da-u̱ Hananiya yu̱-Yat-ya a-To̱o̱g-ne̱ ho̱ge̱ no̱mu̱ Burus ware̱, se̱ wu̱ i o̱ ees u̱ dapu̱s Burus e̱ gap wa u-nu. ");
INSERT INTO gel_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Burus zu̱ u̱n, <<Ru̱-u̱ de̱ ya bo̱ u̱r-ko̱b bo̱ wa ha-mu̱ u̱r-no̱! Bo̱ shu̱'u̱te̱ u̱ku̱n bo̱ o̱ kwu̱pu̱ me̱ u̱s-rem su̱ u-bo̱r, tu̱msu̱ bo̱ ya u̱ gap-du̱ me̱, no̱m-u̱ bo̱r-tu̱ hose̱.>> ");
INSERT INTO gel_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","I o̱ ees u̱ku̱n e̱ zu̱ Burus, <<¿Bo̱ yu̱-Yat-ya a-To̱o̱g u-Ru̱ wa bo̱ de̱ u̱t-pyap?>> ");
INSERT INTO gel_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Burus shu̱s wa zu̱, <<O̱r-u̱t ri ne̱, u̱m nak ko yu̱-shu̱ a-to̱o̱g-ne̱ ya da. Na panu̱g u̱zu̱ a-bo̱ pyap yu̱-shu̱ u̱t-ne̱t da.>> ");
INSERT INTO gel_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Da-u̱ Burus nape̱ u̱zu̱ ne̱t-tu̱ o̱ u̱ku̱n e̱ke̱n Saduki-ne̱ e̱ tu̱msu̱ u̱ e̱ke̱n Farisa-ne̱, se̱ wa yu̱ns u-cwar wa zu̱, <<O̱r-u̱t ri, me̱ wa u Farisa wa u̱m o̱ye̱ yadu̱ Farisa-ne̱. No̱ o̱ kwu̱pu̱ me̱ u̱s-rem remu̱ zu̱ u̱m wa'ag jab-u̱ yu̱ne̱-du̱ marimari-ne̱.>> ");
INSERT INTO gel_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Da-u̱ u ware̱ iya, se̱ nan-i yu̱ne̱ u̱ te̱k-u̱ Saduki-ne̱ e̱ Farisa-ne̱, har mo̱ro̱g-du̱ u̱t-ne̱t mot u-yu̱r. ");
INSERT INTO gel_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Remu̱ zu̱ Saduki-ne̱ zu̱u̱g yu̱ne̱-du̱ marimari-ne̱ zarra, tu̱msu̱ a-to̱m u-Ru̱ zarra ko u̱t-yar da se̱di Farisa-ne̱ yaag jab-u̱ no̱m-u̱t to̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Se̱ gwu̱z yu̱ne̱ u̱ku̱n, e̱ke̱n u̱ te̱k-u̱ a-ko̱se̱-tu̱ bo̱r-u̱t Farisa-ne̱ yu̱ne̱ u̱r-ees e̱ no̱ng inan sok, u̱zu̱, <<It, it hyang no̱m-u̱t yo̱-to̱ tu̱ ne̱t uno̱ no̱me̱ da. Jiya o̱ko̱n yar-o̱ no̱mu̱ wu̱n u̱s-rem ko wa-to̱m u-Ru̱.>> ");
INSERT INTO gel_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Gwu̱z nom u-tát, se̱ yu̱-Yat-ya a-m-gag ne̱ hog u-gye̱r tasu̱ na no̱m Burus u̱t-kik u̱t-kik. Se̱ wa zu̱ a-m-gag ne̱ e̱ o̱ko̱n Burus u̱r-be̱b, e̱ hu̱u̱t wa u̱ bu-u̱ a-m-gag ne̱. ");
INSERT INTO gel_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Da-u̱ gyu̱p-mu̱ no̱me̱, Burus nom m-hyan se̱ wa hyen Wa-ko-uyan Ye̱so̱ haan u̱ kit-u̱ Burus wa zu̱, <<No̱m be̱b-du̱ jab, u̱ka bo̱ nomte̱ bu̱t-u̱t ri u̱ Urusharima, iya hen bo̱ do̱te̱ bu̱t-u̱t ri u̱ Roma.>> ");
INSERT INTO gel_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Da-u̱ is gase̱, Yahuda-ne̱ zo̱ngte̱ e̱ hoot Burus. E̱ eeste̱ u̱s-rem u̱zu̱ e̱ za u-re̱ ko̱ e̱ u-swa o̱ko̱n da se̱ e̱ ho̱o̱g Burus. ");
INSERT INTO gel_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ne̱t-tu̱ zo̱nge̱ no̱m-u̱ yo̱-o̱ uno̱ e̱ ze̱k ne̱t-ne̱ u̱t-shik u̱t-yu̱r. ");
INSERT INTO gel_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Se̱ e̱ do̱'e̱ u̱du̱ i-Yate̱ a-To̱o̱g u̱ i shu̱ u̱t-ne̱nge̱n ne̱. E̱ zu̱, <<It no̱ng to̱nd-u̱s yatse̱ u̱zu̱ it za re̱-du̱ o̱ko̱n da se̱ it ho̱o̱g Burus. ");
INSERT INTO gel_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Remu̱ iya no̱ Mo̱ro̱g-du̱ u̱t-Ne̱nge̱n u̱ tu̱-shu̱ u̱t-ne̱t ne̱ zu̱u̱n yu̱-Yat-ya karma-ne̱ i Roma no̱ ko̱n wa na haatu̱n no̱ wu̱n. Waru̱ yu̱-Yat-ya karma-ne̱ u̱zu̱ no̱ u̱t-sa no̱ sur m-gwat rem-u̱s ro u̱r-zwar ne̱, it hen it zo̱ngte̱ ho̱-du̱ wu̱n kanda wa teen.>> ");
INSERT INTO gel_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Da-u̱ wa'-u̱ hu̱no-u Burus ne̱ta ho̱ge̱ no̱mu̱ u̱n zo̱nge̱ u̱t-no̱m, se̱ wa to u̱ bu-u̱ a-m-gag ne̱ wa waru̱ Burus. ");
INSERT INTO gel_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Burus hen wa fog waku̱n u̱ te̱k-u̱ tu̱-shu̱ karma-ne̱ i Roma. Wa zu̱, <<Hu̱tu̱ zwaru̱ unwa u̱du̱ yu̱-Yat-ya karma-ne̱, wa o̱tte̱ no̱m-u̱ wa de̱ waru̱ wa.>> ");
INSERT INTO gel_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Yu̱-shu̱ karma-yu̱ Roma ku̱b i-zwar wa hu̱u̱t wu̱n u̱du̱ yu̱-Yat-ya karma-ne̱. Yu̱-shu̱ karma-ne̱ i Roma zu̱, <<Burus wa-m-to̱k, wa ko̱ne̱ u̱m haatu̱n zwaru̱ unwa u̱du̱ ró, remu̱ zu̱ wa o̱tte̱ no̱m-u̱ wa de̱ waru̱ bo̱.>> ");
INSERT INTO gel_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Yu̱ yat-ya ship kom-u̱ i-zwar, wa nu̱k wu̱n u̱-kit, wa shit wu̱n wa u-gan, <<¿Yan-o̱ bo̱ de̱ waru̱ me̱?>> ");
INSERT INTO gel_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Wa zwar zu̱, <<Tu̱-shu̱ Yahuda-ne̱ zo̱ngte̱ e̱ ko̱n bo̱, bo̱ hu̱u̱t Burus u̱du̱ Mo̱ro̱g-du̱ u̱t-Ne̱nge̱n u-sot. U̱n de̱ u̱t-zu̱ u̱n u̱t-sa u̱n sur m-gwat rem-u̱s wa u̱r-zwar ne̱. ");
INSERT INTO gel_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Se̱di a-bo̱ ees da, remu̱ u̱n ze̱k ne̱t-ne̱ u̱t-shik u̱t-yu̱r, tu̱msu̱ u̱n u̱t-sa u̱n ho̱ wu̱n, u̱n no̱ng u̱s-to̱nd u̱zu̱ u̱n za u-re̱ ko̱ swa-u̱ o̱ko̱n da se̱ u̱n ho̱o̱g wu̱n. U̱ da-o̱ hen u̱n taaste̱ u̱t-zo̱ng, bo̱ wa u̱n o̱ u̱t-e̱ste̱.>> ");
INSERT INTO gel_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Se̱ yu̱-Yat-ya nu̱k wu̱n u̱t-to̱ wa zu̱, <<A-bo̱ waru̱ waku̱n u̱zu̱ bo̱ wargu̱ me̱ rem-u̱s sin-se̱ da.>> Se̱ wa zu̱ wa, wa mu. ");
INSERT INTO gel_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Da-u o̱ yu̱-Yat-ya karma-ne̱ fog tu̱-shu̱ karma-ne̱ i Roma yu̱r wa zu̱, <<Zo̱ngo̱n remu̱ zu̱ no̱ de̱ ha-mu̱ Kasariya u̱ ya-o̱ kwam-su̱ u̱s-jwu̱u̱r su̱ m-gyu̱p, u̱r-kot u̱ karma-ne̱ u̱t-ko̱k u̱t-yu̱r, u̱ karma-ne̱ u̱t-shik u̱t-tu̱t u̱ o̱p a sak-du̱ jwak, tu̱msu̱ u̱ a-m-gag ne̱ u̱t-ko̱k u̱t-yu̱r a m-dum ne̱ u̱s-sap. ");
INSERT INTO gel_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","No̱ko̱n no̱ kwu̱mu̱n jwaak i Burus do̱te̱ u̱r-da. Se̱ no̱ hu̱u̱t wu̱n u̱du̱ Wa-u-dak Fe̱rik m-yar.>> ");
INSERT INTO gel_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Yu̱-Yat-ya a-m-gag ne̱ pu̱n u-ran: ");
INSERT INTO gel_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Du̱gu̱-du̱ Kawudikiya Risiyas, m-ha u̱du̱ Wa-u-dak Fe̱rik. U̱m o̱ u̱s-vu̱k. ");
INSERT INTO gel_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yahuda-ne̱ o̱gu̱ maaste̱ campa-u inya, e̱ u̱t-sa ho̱-du̱ wa, se̱ u̱m nom m-ho̱r u̱ a-m-gagu̱ ri rwu̱mu̱n wu̱n, remu̱ zu̱ u̱m m-hyan u̱zu̱ u o̱ du̱gu̱ Roma. ");
INSERT INTO gel_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ba shu̱'u̱te̱ u̱zu̱ u̱m u̱t-sa u̱m nap no̱m-u̱ wa no̱me̱ u̱ u̱n o̱tte̱ rem-u̱s rò, se̱ u̱m hu̱u̱t wu̱n u̱ be-du̱ Mo̱ro̱g-du̱ u̱t-Ne̱nge̱n. ");
INSERT INTO gel_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Tu̱msu̱ u̱m ho̱k u̱n u̱s-rem u̱zu̱ u o̱ pas-du̱ bo̱r-u̱t u̱n, se̱di no̱m-u̱ na zu̱ wa no̱mo̱g ko̱rge̱ na gag wa ko na ho̱ wa da. ");
INSERT INTO gel_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Da-u̱ waku̱n waru̱ me̱ no̱m-u̱ u̱n zo̱nge̱ no̱mu̱ campa-u inya, de̱ wu̱te̱ za rem u̱m to̱kto̱n wa u̱du̱ ró. U̱m zu̱u̱g i hatu̱n rem-u̱s ro e̱ warru̱ bo̱ no̱m-tu̱ wa no̱me̱. ");
INSERT INTO gel_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Remu̱ iya o̱ Karma-ne̱ ku̱bte̱ Burus u̱ka na wartu̱ e̱, u̱n hu̱u̱t wu̱n u̱ bo̱-u̱ Antifatiris m-gyu̱p. ");
INSERT INTO gel_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Da-u̱ is gase̱, Karma-ne̱ a da-du̱ jwake̱ aru̱k u̱ Burus ne̱ m-ha Kasariya. Se̱di Karma-ne̱ i o̱ ha-mu̱ u̱s-na u̱ a u̱s-sap ne̱ nok m-mu̱ u̱ bu-u̱ Karma-ne̱. ");
INSERT INTO gel_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Da a-m-gag a dadu̱ jwak teye̱ Kasariya, se̱ e̱ yasu̱ Wa-u-dak u-ran tu̱msu̱ e̱ yagu̱ Burus u̱ kom-u̱t ro. ");
INSERT INTO gel_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Da-u̱ wa u-dak karu̱nte̱ no̱m-u̱ na panne̱, se̱ wa shit Burus du̱gu̱ gu̱r-u̱ he̱ wa o̱o̱ne̱. Da-u̱ wa ho̱ge̱ u̱zu̱ du̱gu̱ Kirikiya o̱, ");
INSERT INTO gel_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","se̱ wa zu̱, <<Me̱ ho̱gu̱ rem-u̱s ró, da-u̱ i hu̱tu̱ rem-u̱s ro haane̱.>> Se̱ Wa-u-dak zu̱ karma-ne̱ do̱'e̱ e̱' wu̱n u̱-me̱ bu-u̱ Here̱ Faru̱k. ");
INSERT INTO gel_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Da-u̱ roog-mu̱ u̱t-tan arke̱, se̱ yu̱-Yat-ya a-to̱o̱g Hananiya, yage̱ Urusharima m-ha u̱ Kasariya u̱ to̱ko̱n ne̱nge̱n-tu̱ Yahuda-ne̱ u̱ wa nap-mu̱ u̱t-bo̱r wu̱ na zu̱ye̱ Taturus. Ku̱na war-tu̱ Wa-u-dak nom-tu̱ Burus no̱me̱ tu̱ za so̱-to̱ da. ");
INSERT INTO gel_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Wa-u-dak zu̱ na cwatu̱n Burus, se̱ Taturus he̱e̱se̱ ke̱-tu̱ Burus u̱s-rem u̱du̱ Wa-u-dak. Wa zu̱, <<Wa-u-dak, hak-su̱ bo̱ o̱o̱ge̱ u̱r-faru̱k u̱du̱ it, it no̱ng shu̱'u̱t-du̱ m-yar, remu̱ zu̱ ve̱r-su̱ no̱m-tu̱ re̱-u̱ shu̱ u̱ bo̱ hatu̱n, wa'ag dak-u uno̱ re-u̱t shu̱. ");
INSERT INTO gel_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Remu̱ iya Wa-u-dak, it no̱ng u̱t-vam u̱du̱ ró Fe̱rik remu̱ no̱m-tu̱ bo̱ no̱mu̱ it be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","U̱ remu̱ gye̱r-u̱ na-su̱ bo̱ u-da, u̱m o̱ ko̱n-u̱s ró bo̱ ya' me̱ u-da cashi, gag jab bo̱ e̱r no̱m-u̱ u̱m de̱ waru̱ bo̱. ");
INSERT INTO gel_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","<<Ne̱t unwa gu̱gu̱di u̱ no̱mo̱g wa u-tát, wa o̱ hatu̱n yu̱nu̱s-du̱ u̱s-jab ko he̱ne̱ u̱ dak-u̱ Yahuda-ne̱ u-be̱e̱t, tu̱msu̱ wu̱na o̱ yu̱ yat-ya Nazara-ne̱, wato a-doru̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Wa u̱t-sa wa muut be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan it za u-he̱n, se̱ it maas wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","A-bo̱ shite̱ campa-u inya, bo̱ ho̱gu̱ to̱-u̱ ro no̱m-u̱t to̱ u̱t-be̱e̱t u̱ka it war-tu̱ bo̱ to̱.>> ");
INSERT INTO gel_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yahuda-ne̱ ees, e̱ zu̱ iya o̱ no̱m-u̱t to̱ o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Da-u̱ Wa-u-dak ya wu̱n u-da wa no̱m u̱s-rem, se̱ Burus zu̱, <<U̱m de̱ haatu̱n hi-du̱ war ri u̱ te̱k-u̱ u̱r-so̱, u̱m nak bo̱ tumbte̱ bo̱ o̱ kwu̱p-du̱ u̱s-rem u̱-me̱ ne̱t-u̱t tun-to̱. ");
INSERT INTO gel_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","A no̱ gwate̱ u̱r-zwar ne̱, no̱ u̱t-nap u̱zu̱, ze̱k m-roog o̱p-u̱t yu̱r da, da u̱m do̱'e̱ u̱ Urusharima u̱m nom-tu̱ u̱t-huuk. ");
INSERT INTO gel_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","I hatu̱n rem-u̱s ri ne̱, e̱ tamu̱g ho̱g-du̱ it u̱ waku̱n inan da, ko yu̱nsu̱ jab-su̱ u̱t-ne̱t u̱-me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan da, ko Kur-tu̱ u̱t-Ko̱se̱ ko u̱ me̱ u-bo̱ da. ");
INSERT INTO gel_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","No̱m-u̱t tun-to̱ tu̱ e̱ o̱ waru̱ bo̱, e̱ za keru̱ u̱r-wu̱u̱n e̱ war u̱zu̱ nip-tu̱ to̱ da. ");
INSERT INTO gel_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","No̱m u-gan o̱ u̱m eese̱ u̱ o̱ ne̱, o̱ o̱ u̱zu̱ u̱m do̱r u-Ru̱ u̱ u̱so-tu̱ u̱so-u̱t in nomte̱ u̱t-huuk. No̱ng ho̱n-ho̱n u̱m dor fu̱n-yu̱ Ye̱so̱ is-u̱ it (Tu̱-shu̱ Yahuda-ne̱ zu̱ fu̱n-u ya zatte̱ u̱t-nip da). Tu̱msu̱ u̱m o̱ ya-du̱ jab-u̱ no̱m-tu̱ Mosa u̱ e̱ke̱n a-warru̱ rem-su̱ u-Ru̱ ne̱ pane̱. ");
INSERT INTO gel_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","U̱m o̱o̱g wa'ag jab u̱du̱ u-Ru̱, u̱ka armo̱ ne̱ nomte̱ ko e̱, u̱zu̱ na de̱ yu̱nsu̱ marimari-ne̱, a-jab-u̱s so̱-se̱ ne̱ u̱ a-za-jab-u̱s yo̱-se̱ ne̱ be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","De̱ wu̱te̱ u̱m o̱tte̱ wa'ag jab-u̱ ho̱-u̱r re̱, ko mu̱ne̱ u̱m no̱m no̱m-u̱ Ru̱-u̱ u̱t-sa tu̱msu̱ no̱m-u̱ ne̱t-tu̱ u̱t-sa. ");
INSERT INTO gel_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","<<Da-u̱ hak-su̱ arke̱ u-tát, se̱ u̱m mu̱u̱n u̱ Urusharima u̱ remu̱ u̱m hattu̱n u̱r-se̱ge̱ u̱du̱ ne̱t-u̱t it i o̱ cwan-tu̱ u̱r-se̱ge̱, tu̱msu̱ u̱m o̱ no̱m-du̱ to̱o̱g u̱du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","U̱m o̱ te̱k-u̱ u̱t-no̱m inya, se̱ e̱ke̱n Yahuda-ne̱ bit me̱ u̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan, u̱m ta'aste̱ jasu̱ hi-u̱r ri remu̱ u̱t-huuk u̱ka bo̱r-u̱t zu̱tte̱. Tu̱msu̱ mo̱ro̱g-du̱ u̱t-ne̱t za u̱r-kot u̱ me̱ ne̱ da, tu̱msu̱ yu̱nu̱s-du̱ u̱s-jab zarra ko̱ gwu̱z. ");
INSERT INTO gel_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Se̱di e̱ke̱n Yahuda-ne̱ o̱ro i du̱gu̱ dak-u̱ Asiya i o̱ u̱ku̱n. Kamu̱g u̱zu̱ e̱ o̱ u̱ ane̱ e̱ hattu̱n rem-u̱s ri u̱du̱ ró, abite̱ e̱ hyanu̱g u̱ka u̱zu̱ u̱m no̱ng no̱m-u̱ kame̱ da. ");
INSERT INTO gel_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ko ne̱t-u̱t tun-to̱ e̱ war ba'as-tu̱ e̱ bite̱ me̱ u̱ to̱ ne̱ da-u̱ u̱m ese̱ u̱-me̱ Mo̱ro̱g-du̱ u̱t-Ne̱nge̱n, ");
INSERT INTO gel_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Se̱di jiya rem-su̱ u̱m no̱me̱, da-u̱ u̱m jakse̱ u-cwar u̱m zu̱, <No̱ o̱ kwu̱pu̱ me̱ u̱s-rem u̱ ya-o̱ remu̱ zu̱ u̱m yaag jab u̱zu̱ Ru̱-u̱ de̱ yu̱nsu̱ ne̱t-ne̱ be̱e̱t i mare̱ du̱gu̱ marimari-ne̱.> >> ");
INSERT INTO gel_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Fe̱rik wa u-dak nu̱pu̱ste̱ no̱m-u̱t to̱ u̱t-be̱e̱t u̱ mo̱t-u̱t Ye̱so̱, se̱ wa zu̱ u̱n, <<Da-u̱ yu̱-Yat-ya Karma-ne̱ Risiya teene̱, da-u o̱ u̱m de̱ kwu̱pu̱ no̱ u̱s-rem.>> ");
INSERT INTO gel_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Fe̱rik zu̱ yu̱-Yat-ya a-m-gagu̱ Roma wa e̱' Burus, se̱di a wa e̱kse̱ wu̱n u-tát da, tu̱msu̱ a wa hoos hu̱u̱b-u̱t wa u̱r-haan u̱du̱ wa remu̱ e̱ gwat wu̱n da. ");
INSERT INTO gel_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Da-u̱ roge̱ cashi, Fe̱rik e̱ ne̱ta wa Durusira wa-Yahuda e̱ mu̱u̱n Kasariya. Se̱ wa tom na hatu̱n Burus wa ho̱g rem-su̱ mo̱ttu̱ yadu̱ jab-u̱ Ye̱so̱ Kiristi. ");
INSERT INTO gel_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Da-u o̱ Burus he̱e̱se̱ u̱s-rem u̱ mo̱ttu̱ jab-u̱ so̱-o̱. Tu̱msu̱ wa wu̱r u̱ka ne̱t do̱te̱ re̱-du̱ be̱b-du̱ cwan-tu̱ u-war. Burus nom u̱s-rem u̱zu̱ da-u̱ o̱o̱n u̱ da-u̱ Ru̱-u̱ de̱ kwu̱pu̱ ne̱t-ne̱ u̱s-rem. Da-u̱ Fe̱rik ho̱ge̱ rem-u̱s se̱, se̱ gye̱r-u̱ maas wa. Se̱ wa zu̱ Burus, <<U̱m kwu̱mu̱g no̱m-u̱ u̱m u̱t-sa u̱m ho̱g u̱ da-o̱. A u̱m kume̱ u-da me̱ u̱t-swu̱r m-fag bo̱, bo̱ haan.>> ");
INSERT INTO gel_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Fe̱rik zu̱u̱g iya remu̱ zu̱ wa o̱ m-hyan u̱ka zu̱ Burus u̱ ya wu̱n shik, wu̱n hu̱ pama-u̱ fag-du̱ wu̱n ko̱-uyan da, Burus hu̱ hen m-ha u̱du̱ wu̱n u̱n o̱ u̱r-wa'as, se̱di wa yaag Fe̱rik o̱ko̱n da, Fe̱rik hen wa gu̱gu̱m zu̱ du̱ Karma-ne̱ rest wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Da hak-su̱ u̱s-yu̱r arke̱, se̱ Fokiyus Fe̱stus shu̱'u̱t Wa-u-dak u̱ porar Fe̱rik. Fe̱rik hen remu̱ zu̱ wa u̱t-sa u̱ ne̱t-tu̱ Yahuda e̱ cwan wa sok, se̱ wa gu̱gu̱m restu̱n Burus du̱gu̱ bu-u̱ m-to̱k. ");
INSERT INTO gel_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Da-u̱ Fe̱stus o̱o̱ge̱ u̱r-faru̱k du̱ Wa-u-dak, se̱ wa teen u̱ bo̱-u̱ Kasariya, da-u̱ ho̱-tu̱ u̱t-tu̱t arke̱ wa yu̱ne̱ du̱gu̱ Kasariya wa do̱'e̱ u̱ Urusharima. ");
INSERT INTO gel_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","I-Yate̱ a-to̱o̱g-ne̱ u̱ tu̱-shu̱ Yahuda-ne̱ e̱ waru̱ Wa-u-dak Fe̱stus no̱m-tu̱ Burus no̱me̱ tu̱ yo̱-to̱. ");
INSERT INTO gel_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","E̱ kon Fe̱stus u̱zu̱ wa zu̱ karma-ne̱ e̱ muut Burus u̱ Urusharima. E̱ cwang u̱zu̱ wa no̱ng iya, remu̱ e̱ ho-u̱t wu̱n u̱ do̱m-u̱ u-fu̱n. ");
INSERT INTO gel_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fe̱stus shu̱s wa zu̱, <<Na shipu̱s Burus u̱ Kasariya, me̱ hi-du̱ war ri u̱m de̱ m-ha u̱ku̱n za m-tumb. ");
INSERT INTO gel_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Remu̱ iya yage̱ i-yate̱ no̱ do̱ro̱n me̱, abite̱ ne̱tu̱ wa o̱tte̱ to̱ko̱n ba'as-to̱ se̱ u̱n war.>> ");
INSERT INTO gel_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Da-u̱ Wa-u-dak Fe̱stus u̱ka m-roog u̱t-eer ko u̱t-o̱p u̱ Urusharima, se̱ wa mu u̱ Kasariya. Da-u̱ is gase̱ se̱ wa shu̱'u̱t u̱ pora-du̱ u̱r-faru̱k wa. Se̱ wa zu̱ karma-ne̱ cwatu̱n Burus u̱-me̱ remu̱ wa kwu̱p-tu̱ wa u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Da-u̱ Burus teene̱, Yahuda-ne̱ i haane̱ du̱gu̱ Urusharima e̱ yu̱ne̱ e̱ gu̱ns wu̱n. E̱ o̱gu̱ warru̱ rem-u̱s yo̱-se̱ u-tát u̱ Burus, su̱ u̱n za kere̱ u̱t-ko̱se̱ u̱zu̱ rem-su̱ u̱n ke̱tu̱ Burus nip-to̱ da. ");
INSERT INTO gel_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Burus hen wa ruut hi-u̱r wa. Wa zu̱, <<Me̱ u̱m paku̱s bo̱r-u̱t Yahuda-ne̱ da, tu̱msu̱ u̱m no̱ngu̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan, ko Kaisar u̱t-ba'as da ko cashi.>> ");
INSERT INTO gel_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Se̱di Fe̱stus u̱t-sa wa mangu̱ tu̱-shu̱ Yahuda-ne̱ jab se̱ wa shit Burus u̱zu̱, <<¿Ko bo̱ u̱t-ees bo̱ do̱'e̱ u̱ Urusharima bo̱ ho̱g no̱m-u̱ ne̱t-u̱t to̱ do̱'e̱ u̱t-war u̱ remu̱ ró u̱ ke̱nu̱ ri?>> ");
INSERT INTO gel_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Burus zu̱, <<U̱m o̱ ees ke̱nu̱ be-du̱ kwu̱p-du̱ u̱s-rem u̱ Kaisar, ane̱ ku̱mte̱ na kwu̱pu̱ me̱ u̱s-rem. Bo̱ nu̱pu̱ste̱ u̱s-be̱e̱t, u̱m no̱ngu̱ Yahuda-ne̱ to̱ko̱n ba'as-to̱ da. ");
INSERT INTO gel_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Abite̱ me̱ wa u̱t-ba'as wa, har u̱zu̱ u̱m no̱ng u̱t-ba'as, u̱m za so̱m-du̱ u̱r-ho̱ da. A shu̱'u̱te̱ rem-su̱ u̱m ware̱ u̱zu̱ bise̱ u̱n no̱me̱, waku̱n ko̱rge̱ hen wa yasu̱ me̱ u̱ kom-u̱t u̱n da. Tu̱msu̱ u̱m de̱ nok-tu̱ u̱s-rem m-ha du̱ Kaisar!>> ");
INSERT INTO gel_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Da-u̱ Fe̱stus tase̱ u̱s-rem u̱ a-yadu̱ wa u̱s-rem ne̱ u-pada ne̱, se̱ wa zu̱, <<To̱ bo̱ ko̱no̱g na hu̱u̱t rem-u̱s sin-se̱ u̱ ke̱nu̱ Kaisar, du̱ Sisar hen de̱ bo̱ do̱te̱ m-ha.>> ");
INSERT INTO gel_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","A rooge̱ cashi, Agarifa faru̱k teen Kasariya e̱ yu̱-faya wa ya-i-gwu̱p na zu̱ wa Banis. E̱ hagu̱n remu̱ e̱ vu̱ku̱ste̱ Fe̱stus remu̱ cwa-u̱r wa u̱ faru̱k-du̱ Wa-u-dak. ");
INSERT INTO gel_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ba shu̱'u̱te̱ u̱zu̱, u̱n u̱t-tumb u̱ku̱n, se̱ Fe̱stus haatu̱n rem-u̱s Burus u̱du̱ Faru̱k. Fe̱stus zu̱, <<Waku̱n ne̱t wa o̱ro u̱-me̱ bu-u̱ m-to̱k wu̱ Fe̱rik yage̱ u̱ da-u̱ wa o̱o̱ge̱ Wa-u-dak. ");
INSERT INTO gel_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Da-u̱ u̱m o̱o̱ge̱ Urusharima i-yate̱ a-to̱o̱g u̱ ne̱nge̱n-tu̱ Yahuda-ne̱ e̱ hattu̱n me̱ rem-su̱ ne̱t unwa, e̱ kon me̱ u̱m kwu̱pu̱ wu̱n rem-su̱ u̱r-ho̱. ");
INSERT INTO gel_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","<<Se̱di u̱m waru̱ u̱n u̱zu̱ Roma-ne̱ kwu̱p-tu̱ wa u̱t-ba'as u̱s-rem da, se̱ na haatu̱n wa u̱ ke̱nu̱ i haatu̱n rem-u̱s rò, tu̱msu̱ na ya wa u-da wa ruut hi-u̱r wa du̱gu̱-du̱ i haatu̱n rem-u̱s wa. ");
INSERT INTO gel_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Da-u̱ u̱n haane̱ u̱ me̱ ne̱ ane̱, u̱m naaste̱ u-da da, da-u̱ is gase̱ u̱m shu̱'u̱t u̱ do̱m-u̱ pora-du̱ kwu̱p-du̱ u̱s-rem, u̱m zu̱ na hatu̱n ne̱tu̱ wa. ");
INSERT INTO gel_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Da-u̱ i hatu̱n rem-u̱s ro yu̱ne̱, e̱ hattu̱n rem-u̱s ro u̱ no̱m-u̱ u̱m o̱o̱gu̱ wa'ag jab u̱n u̱t-haatu̱n da. ");
INSERT INTO gel_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Remu̱ iya, u̱n hu̱ inan u̱ to̱ko̱n ko̱se̱-to̱ tu̱ e̱ke̱n Yahuda-ne̱ yete̱ jab tu̱msu̱ e̱ke̱n yaag jab da. U̱n o̱ inan u̱ remu̱ yaku̱n campa-ya wu̱ na foge̱ Ye̱so̱, wu̱ mare̱, se̱di Burus yu̱ u̱n o̱ ke̱tu̱ u̱s-rem, wa hu̱ u̱zu̱, <Ye̱so̱ o̱ u̱r-fat.> ");
INSERT INTO gel_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Me̱ hen u̱m nak u̱ka u̱m do̱te̱ u̱ no̱m-du̱ rem-u̱s sin-se̱ da. Se̱ u̱m shit Burus ko wa u̱t-ha u̱ Urusharima u̱ remu̱ na kwu̱p-tu̱ wa u̱s-rem u̱ku̱n u̱ mo̱t-tu̱ rem-u̱s sin-se̱. ");
INSERT INTO gel_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Da-u̱ Burus sa'e̱ u̱zu̱ faru̱k-u̱ yat-wa Sisar wa de̱ kwu̱pu̱ wu̱n u̱s-rem, se̱ u̱m zu̱ na e̱' wu̱n m-ha da-u̱ u̱m de̱ to̱m-du̱ wu̱n u̱du̱ Kaisar.>> ");
INSERT INTO gel_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Se̱ Agarifa Faru̱k zu̱ Fe̱stus, <<Ko me̱ u̱m cwang u̱m e̱r campa inya u̱ hi-du̱ war ri.>> Fe̱stus Wa-u-dak zu̱, <<Bo̱ ho̱gu̱ wu̱n hen u-sot.>> ");
INSERT INTO gel_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Da-u̱ is gase̱ se̱ Agarifa Faru̱k e̱ Banis e̱ wu̱ cwu̱-tu̱ u̱r-faru̱k e̱ to u̱-me̱ u̱t-ne̱t, u̱n haan u̱ i-yate̱ karma-ne̱ u̱ tu̱-shu̱ u-bo̱ ne̱. Se̱ Fe̱stus zu̱ na cwatu̱n Burus. ");
INSERT INTO gel_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Se̱ Fe̱stus zu̱, <<Agarifa Faru̱k, u̱ ne̱t-tu̱ o̱ ane̱ u̱t-be̱e̱t, ne̱tu̱ wa ya' wu̱ Yahuda-ne̱ hatu̱n me̱ rem-u̱s wa u̱ Urusharima, u̱ ana ne̱, har e̱ zu̱ kamu̱g na yage̱ wa u̱r-fat da. ");
INSERT INTO gel_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Se̱di me̱ u̱m hyang u no̱ng o̱ko̱n u̱ ko̱re̱ na ho̱ wu̱n da. Remu̱ u̱zu̱ wu̱na zu̱ye̱ na haatu̱n rem-u̱s se̱ u̱du̱ yu̱-Yat-ya yu̱ Sisar, u̱m zu̱ hen me̱ to̱mtu̱n wu̱n. ");
INSERT INTO gel_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Se̱di u̱m zatte̱ o̱ko̱n no̱m-o̱ u̱m de̱ panu̱ yu̱-Yat-ya yu̱ Roma u̱ mo̱ttu̱ sin-se̱ rem-u̱s se̱ da. De̱ wu̱te̱ u̱m hatu̱n wu̱n u̱du̱ no̱ tu̱msu̱ u̱du̱ ro Agarifa Faru̱k no̱ e̱r no̱m-u̱ wa de̱ u̱t-war. A in no̱me̱ wu̱n u̱t-shu̱t jiya me̱ u̱t-kwu̱m no̱mu̱ u̱m de̱ u̱t-pan. ");
INSERT INTO gel_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","U̱ hyanu̱m ri rag-mo̱ a u̱m to̱me̱ wu̱ o̱ tage̱ u̱du̱ Sisar u̱ Roma za na war ba'as-tu̱ wa no̱me̱ da.>> ");
INSERT INTO gel_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","29 A tase̱ Agarifa zu̱ Burus, <<Na yaag bo̱ u-da bo̱ jaas hi-du̱ war ró.>> Se̱ Burus jaku̱s u-kom, wa he̱e̱se̱ u̱s-rem: ");
INSERT INTO gel_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","<<Faru̱k Agarifa, iya o̱ hen u̱m ho̱k u̱r-zwar u̱ shu̱'u̱te̱ u̱zu̱ du̱ ró de̱ u̱m do̱te̱ taasu̱ hi-du̱ war ri u̱ remu̱ rem-su̱ Yahuda-ne̱ ke̱-tu̱ me̱. ");
INSERT INTO gel_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","U̱m no̱ng u̱r-so̱ sok remu̱ zu̱ bo̱ ne̱t wa wu̱ nape̱ u̱r-ma it du̱ Yahuda-ne̱ u̱r-be̱e̱t u̱ no̱m-tu̱ e̱ nomte̱ inan u̱ to̱. Remu̱ iya u̱m o̱ ko̱n-u̱s ró bo̱ gag jab bo̱ e̱r rem-u̱s ri. ");
INSERT INTO gel_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","<<Yahuda-ne̱ be̱e̱t e̱ nak yu̱-du̱ u̱m no̱me̱ u̱ fa-u̱r ri, du̱gu̱ dak-u̱ na mu̱tte̱ me̱ tu̱msu̱ u̱ haan u̱ Urusharima. ");
INSERT INTO gel_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","U̱n nak me̱ m-tumb ne̱, har a u̱n haane̱ u̱nu̱ keru̱ waru̱ no̱ u̱zu̱ me̱ wa Farisa wa tu̱msu̱ u̱m dor u̱r-ma'it u̱r-zwar ne̱, u̱ka e̱ke̱n Farisa-ne̱ no̱m-te̱. ");
INSERT INTO gel_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Me̱ ya u̱ da-o̱ u̱ ees u̱ ke̱nu̱ no̱ u̱ kwu̱p-tu̱ me̱ u̱s-rem, remu̱ zu̱ u̱m wa'ag jab-u̱ este̱du̱ u̱s-rem su̱ Ru̱-u̱ no̱me̱ i mate̱ u̱so-u̱t in. ");
INSERT INTO gel_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Este̱du̱ u̱s-rem de̱, ko̱-du̱ u̱t-rem o̱p-u̱t yu̱r wu̱te̱ jab e̱ hyan o̱ shu̱u̱g, de̱ wu̱te̱ e̱ o̱tte̱ do̱rru̱ u-Ru̱ u-ho̱ m-gyu̱p ne̱. Agarifa Faru̱k remu̱ zu̱ u̱m wa'ag jab-u̱ este̱du̱ rem-u̱s se̱ de̱ wu̱te̱ Yahuda-ne̱ o̱tte̱ ke̱-tu̱ me̱ u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¿Ya wu̱te̱ no̱ o̱tte̱ m-hyan u̱zu̱ za u̱t-no̱me̱ Ru̱-u̱ yu̱ns ne̱t-u̱ mare̱ u̱r-fat da? ");
INSERT INTO gel_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","<<Me̱ hi-du̱ war ri, u̱ da-u̱ dim u̱m nom no̱m-tu̱ de̱ hosu̱ re̱-u̱ shu̱ rem-u̱s Ye̱so̱ wa-Nazara. ");
INSERT INTO gel_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","No̱m-u̱ u̱m no̱me̱ o̱ hen u̱ Urusharima, har u̱m kum u̱r-be̱b du̱gu̱ i-yate̱ a-to̱o̱g remu̱ u̱m wu̱'u̱t a-doru̱ Ye̱so̱ u̱-me̱ bu-u̱ m-to̱k. Da-u̱ Yahuda-ne̱ e̱ u̱t-sa ho̱-du̱ a-doru̱ Ye̱so̱ ne̱, u̱m yaag u̱r-be̱b ko me̱ u̱zu̱ na ho̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","U̱m do̱ro̱g u-so u-tát Kur-tu̱ u̱t-Ko̱se̱ u̱n u̱ yadu̱ u̱n u̱r-ko̱b tu̱msu̱ u̱m ton u̱n ju̱ru̱m dim-u̱r Ye̱so̱. Remu̱ zu̱ u̱m o̱ ho̱g-du̱ ryab-u̱s u̱n sok, se̱ u̱m ha do̱rru̱ u̱t-bo̱ tu̱ to̱ko̱n dak-to̱ u̱m o̱ yadu̱ u̱n u̱r-ko̱b. ");
INSERT INTO gel_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","<<Yu̱-Yat-ya a-To̱o̱g u̱ Urusharima yaag me̱ u̱r-be̱b tu̱msu̱ wa tom me̱ u̱m masu̱n a-dor i o̱ u̱ku̱n. De̱ku̱n ho̱-de̱, u̱m o̱ te̱k-u̱ m-ha u̱ bo̱-u̱ Dimaku u̱m nom-u̱t iya. ");
INSERT INTO gel_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Faru̱k, u̱ te̱k-u̱ u-ho̱, se̱ u̱m hen mo̱ko̱n zu̱n-mo̱ mu̱ ze̱ge̱ zu̱n-mu̱ u̱r-ho̱, mo̱ mo̱ko̱n du̱gu̱ do̱m-u u-ru̱, mo̱ gu̱ru̱s me̱ u̱ hu̱u̱b-tu̱ m-ha ri ne̱ be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","It be̱e̱t it he u-dak, ku̱na u̱m hogte̱ yaku̱n cwar-ya ya zu̱ me̱ u̱ rem-du̱ u̱t-Ibraniya-ne̱, <Shawuru, Shawuru, ¿remu̱ yan-o̱ bo̱ o̱tte̱ yadu̱ me̱ u̱r-ko̱b? Bo̱ o̱ Yadu̱ hi-du̱ war ro u̱r-ko̱b u̱ bo̱ o̱tte̱ gu̱g-mu̱ me̱.> ");
INSERT INTO gel_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","<<Se̱ u̱m zu̱, <¿Wana bo̱ o̱ye̱ yu̱-Yat-ya?> <<Ku̱na Wa-ko-uyan zu̱tte̱ me̱, <Me̱ wa Ye̱so̱ wu̱ bo̱ o̱ yadu̱ u̱r-ko̱b. ");
INSERT INTO gel_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Yu̱ne̱ u̱r-ees. U̱m haagu̱n u̱du̱ ro remu̱ u̱m war-tu̱ bo̱ u̱zu̱ u̱m dak bo̱, bo̱ shu̱'u̱t to̱k-u̱ ri, tu̱msu̱ bo̱ war no̱m-tu̱ bo̱ hyane̱ u̱du̱ ri, u̱ no̱m-tu̱ u̱m de̱ ko̱su̱ bo̱ ane̱ u̱-shu̱. ");
INSERT INTO gel_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Me̱ u̱kru̱ bo̱ du̱gu̱ ne̱t-u̱t ró, u̱ i za-yahuda-ne̱ da, i u̱ u̱m de̱ to̱m-du̱ bo̱ u̱du̱ e̱. ");
INSERT INTO gel_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Bo̱ de̱ upse̱ e̱ is, e̱ byu̱ru̱n du̱gu̱ u-cwu̱m u̱ haan m-zu̱n, du̱gu̱ faru̱k-u̱r faru̱k-u̱ no̱m u̱s-te, m-ha u̱du̱ u-Ru̱. Remu̱ iya o̱ e̱ do̱te̱ kwu̱m-du̱ has-du̱ u̱t-ba'as, tu̱msu̱ u̱n kum u̱r-o̱g u̱r-kot u̱ i o̱ shu̱'u̱t be-du̱ u-he̱n i ya jab u̱du̱ ri.> ");
INSERT INTO gel_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","<<Agarifa Faru̱k, remu̱ iya u̱m do̱ro̱g no̱m-u̱ Wa-ko-uyan Ye̱so̱ waru̱ me̱ u̱m no̱m u-be̱e̱t, da-u̱ wa no̱mu̱ u̱s-rem du̱gu̱ do̱m u-ru̱. ");
INSERT INTO gel_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","U̱m he̱e̱ste̱ no̱m-du̱ u̱t-bu̱t u̱du̱ Yahuda-ne̱ be̱e̱t u̱ Dimaku. Tu̱msu̱ u̱m no̱mu̱ Yahuda-ne̱ u̱t-bu̱t u̱ Urusharima m-ha gu̱r-u̱ Yahudiya u-be̱e̱t, tu̱msu̱ u̱m no̱ng u̱t-bu̱t u̱du̱ i za-yahuda-ne̱ da u̱zu̱ u̱n byu̱ru̱n du̱gu̱ yu̱-du̱ u̱t-ba'as, e̱ muut jab-u̱s e̱ u̱du̱ u-Ru̱, u̱n no̱m no̱m-tu̱ de̱ u̱t-ko̱se̱ u̱zu̱ u̱n yakke̱ u̱t-ba'as. ");
INSERT INTO gel_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","De̱ wu̱te̱ Yahuda-ne̱ maaste̱ me̱ u̱ me̱ be-du̱ u̱r-shu̱'u̱t du̱ Wa-ko̱-uyan, u̱n o̱tte̱ sa-u̱ ho̱-du̱ me̱. ");
INSERT INTO gel_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Se̱di u̱m kwu̱ng se̱ge̱-du̱ u-Ru̱ u̱ haan u̱ da-o̱, de̱ wu̱te̱ u̱m o̱tte̱ ane̱ u̱m o̱ waru̱ wu̱ re̱k-wa u̱ wu̱ yat-wa ne̱ u̱ kowan u̱ ho̱g. O̱ko̱n-o̱ u̱m o̱ u̱t-war u̱ waku̱n yage̱ za nap da, se̱di no̱m-tu̱ a-warru̱ rem-su̱ u-Ru̱ ne̱ u̱ Mosa ne̱ ware̱ u̱zu̱ na u̱t-no̱m to̱. ");
INSERT INTO gel_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","U̱n panu̱g u̱zu̱, Kiristi de̱ swadu̱ u̱r-ko̱b tu̱msu̱ wa mar. Tu̱msu̱ u̱n panu̱g u̱zu̱ wa de̱ shu̱'u̱tu̱ ne̱t u̱r-taku̱n wu̱ de̱ he̱e̱se̱ u̱r-yu̱ne̱ du̱gu̱ marimari-ne̱ remu̱ wa hattu̱n zu̱n-mu̱ u-u̱ku̱r u̱du̱ u̱t-ne̱t u̱t-be̱e̱t, Yahuda-ne̱ u̱ i za-yahuda-ne̱ da.>> ");
INSERT INTO gel_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Burus o̱ te̱k-u̱ ruutu̱ hi-u̱r wa, se̱ Fe̱stus jaku̱s u-cwar u̱r-be̱b ne̱ wa zu̱, <<Burus bo̱ o̱ u-dak, nap-mu̱ no̱me̱ bo̱ u-tát mo̱ daku̱s-tu̱ bo̱!>> ");
INSERT INTO gel_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Burus zu̱, <<Wa-u-dak wa u̱m o̱ye̱ da Fe̱stus. Nip-to̱ u̱m o̱ u̱t-war jab gan. ");
INSERT INTO gel_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Faru̱k-u̱ hi-u̱r wa, wa nak, de̱ wu̱te̱ u̱m o̱tte̱ no̱mu̱ wu̱n u̱s-rem za u-gye̱r. U̱m eeste̱ u̱zu̱ hen u nak no̱m-u̱t tun-to̱ u̱t-be̱e̱t, remu̱ zu̱ yasa-mo̱ na no̱me̱ to̱ da. ");
INSERT INTO gel_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Agarifa Faru̱k, ¿bo̱ yaag jab-u̱ a-warru̱ rem-su̱ u-Ru̱ ne̱? U̱m nak u̱zu̱ bo̱ yaag jab.>> ");
INSERT INTO gel_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Se̱ Agarifa zu̱ Burus, <<A-bo̱ dorog u̱ka zu̱ u̱ te̱k-u̱ no̱m-u̱t tunto̱ cashi tu̱ bo̱ ware̱ u̱ da-o̱ to̱ bo̱ do̱te̱ rak-su̱ me̱ u̱m shu̱'u̱t wa-doru̱ Ye̱so̱ Kiristi da!>> ");
INSERT INTO gel_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Burus zu̱, <<Ko u-da cashi, ko u-tát, To̱o̱g-u̱s ri se̱ u̱du̱ u-Ru̱, u̱ bo̱ u̱ ne̱t-u̱t tun-to̱ i o̱ ho̱g-du̱ me̱ u̱ ya-o̱ e̱ shu̱'u̱t u̱ka u̱m o̱tte̱, se̱di za u̱ka wa m-to̱k u̱ka u̱m o̱tte̱ da.>> ");
INSERT INTO gel_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Se̱ Agarifa Faru̱k yu̱ne̱, u̱ Fe̱stus Wa-u-dak, u̱ Banis ko̱wa u̱ to̱ko̱n ne̱t-to̱ ne̱ i o̱ u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Da-u̱ u̱n ruye̱ du̱gu̱ kur-u̱ kwu̱p-du̱ u̱s-rem, u̱n zu̱, <<Ne̱t unwa no̱ng no̱mu̱ ko̱re̱ na gag wa ko na ho̱ wa da.>> ");
INSERT INTO gel_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Se̱ Agarifa zu̱ Fe̱stus, <<U̱zu̱ ne̱t unwa hu̱u̱te̱ rem-u̱s sin-se̱ u̱du̱ Kaisar da, it za res-tu̱ wu̱n.>> ");
INSERT INTO gel_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Da-u̱ Wa-u-dak zo̱nge̱ u̱zu̱ da-u̱ no̱ng aru̱k-u̱r it, it to u̱-me̱ u-hat m-ha dak-u̱ Itariya, se̱ u̱n yasu̱ Burus u̱du̱ yaku̱n karma-ya yu̱ Roma-ne̱ wu̱ na zu̱ye̱ Juriyo̱s, yu̱-shu̱ karma-ne̱ wu̱ o̱ te̱k-u̱ <<Mo̱ro̱g-du̱ Karma Sisar ne̱.>> ");
INSERT INTO gel_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Da-u̱ it cwa u̱-me̱ u-hat yu̱ bo̱-u̱ Adimiritiyum, yu̱ o̱ zo̱ng-su̱ ha-mu̱ to̱ko̱n bo̱-to̱ tu̱ dapu̱s Asiya, it he̱e̱se̱ m-ha. Waku̱n ne̱t wa o̱ro wu̱ rwu̱ne̱ du̱gu̱ Tasaronika u̱ dak-u̱ Makidoniya. Dim-u̱r wa Aristakus ne̱t-u̱ tu̱msu̱ wa do̱ro̱g it. ");
INSERT INTO gel_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Da-u̱ is gase̱ it te bo̱-u̱ Sido̱n. Juriyo̱s no̱mu̱ Burus no̱m-u so̱-o̱, wa yagu̱ wu̱n wa do̱'e̱ remu̱ wa hyen-u̱t hu̱u̱b-u̱t ro e̱ yu̱'u̱t wu̱n no̱m-u̱ u u̱t-sa. ");
INSERT INTO gel_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Da-u̱ it yu̱ne̱ du̱gu̱ ku̱n u̱-me̱ u-hat, mya-mu̱ hu̱ gapu̱n u̱du̱ it. Remu̱ iya it pu̱' u̱ dim-u̱ Sayifurus, gu̱ru̱ mya-mu̱ zatte̱ u̱r-be̱b ne̱ da. ");
INSERT INTO gel_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Da-u̱ it pase̱ m-sa mu̱ o̱ dapu̱s dak-u̱ Kirikiya u̱ Famfiriya-ne̱, it te bo̱-u̱ Mira u̱ dak-u̱ Rikiya. ");
INSERT INTO gel_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ku̱na yu̱-shu̱ karma-ne̱ ku̱mte̱ u-hat yu̱ du̱gu̱ bo̱-u̱ Are̱kzandariya yu̱ o̱ ha-mu̱ dak-u̱ Itariya, wa wu̱ it u̱-me̱ hat-u ya. ");
INSERT INTO gel_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","It no̱ng u̱t-ru̱t u-tát u̱ te̱k-u̱ u̱r-pas remu̱ zu̱ ha-mu̱ no̱ng m-ho̱r da. It swaag u̱r-ko̱b sok kanda it teet Kinidus. Da mya-mu̱ hosu̱ it u̱r-aru̱k, se̱ it pu̱s m-ha dak-u̱ Kirit, it aru̱k u̱ kit-yu̱ dak-u o̱ be-du̱ na foge̱ Sarmoni. ");
INSERT INTO gel_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","It aru̱k u̱r-kyat, har it te de̱ku̱n be-de̱ u̱ dak-u̱ Kirit du̱ na zu̱ye̱ <<Be-u̱r So̱de̱ du̱ u̱r-Pak,>> u̱ dapu̱s bo̱-u̱ Rikiya. ");
INSERT INTO gel_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","In naaste̱ u-da u-tát, remu̱ zu̱ ha-mu̱ shu̱'u̱te̱ in u̱r-ge̱t u̱r-gas ne̱. Da-u̱ kab-du̱ u-swaat aru̱kte̱. Se̱ Burus zu̱ ne̱t-tu̱ o̱ u̱-me̱ u-hat, ");
INSERT INTO gel_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","wa zu̱ u̱n, <<Ha-m mum-mo̱ de̱ shu̱'u̱tu̱ in swa-u̱ u̱r-ko̱b sok, tu̱msu̱ de̱ hatu̱n in u-taag u̱ to̱ko̱n no̱m-to̱, za u̱t-cwu̱ u̱ u-hat ne̱ u̱ war to̱ da, har u̱ fat-u̱t in ne̱.>> ");
INSERT INTO gel_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Juriyos gu̱gu̱m u̱t-ees u̱ no̱mu̱ Burus ware̱. Wa er rem-su̱ wa nak-du̱ u-hat u̱ wa u-hat ne̱. ");
INSERT INTO gel_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","<<Be-u̱r So̱de̱ du̱ u̱r-Pak>> du̱ Rikiya zatte̱ zwarru̱ u̱r-pak u-go̱s da. Se̱ e̱ke̱n zu̱ na re̱ shu̱ m-ha ne̱, na nom m-ho̱r a no̱me̱, na te bo̱-u̱ Finikiya, remu̱ e̱ nom-u̱t u-go̱s u̱ku̱n. Finikiya u̱ o̱ u-me̱ dak-u̱ Kirit o̱tte̱ hen be-u̱r so̱-de̱ du̱ u̱r-ees du̱ u̱s-hat. Dak-u̱ gu̱nste̱ be-u̱r re̱, se̱di mya-mu̱ kere̱ u̱r-cwa u̱ gas-u̱ u̱ o̱ gwat-du̱ kom u̱s-cwa u̱ gas u-ta u̱ kom u̱r-beer ne̱ u̱ gas u-ta u̱ bo̱ru̱ o̱. ");
INSERT INTO gel_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Da-u̱ mya-mu̱ he̱e̱se̱ u̱t-fu̱ru̱n du̱gu̱ m-ereg u̱ kom-u̱t u̱s-cwa, se̱ ne̱t-tu̱ hyen u̱ka zu̱ e̱ de̱ kwu̱m-du̱ no̱m-u̱ e̱ o̱ u̱ssa. Se̱ e̱ naku̱n kwam-yu̱ shipe̱ u-hat, u̱n he̱e̱se̱ u̱r-pas u̱ dapu̱s dak-u̱ Kirit. ");
INSERT INTO gel_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Za m-tumb mya-m yo̱-mo̱ gagu̱n mu̱ na foge̱, <<Kom u̱r-beer u̱ gas u-do̱m>> mo̱ gapu̱n du̱gu̱ Kirit. ");
INSERT INTO gel_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Da-u̱ mya-mu̱ gapne̱ du̱gu̱ Kom u̱r-beer u̱ gas u-do̱m u-hat, a-nak-du̱ u-hat ne̱ cwang e̱ bir u-hat u̱ gas-u̱ mya-mu̱ o̱tte̱. E̱ kerge̱ byu̱r-ru̱ ya da, se̱ e̱ yage̱ mya-mu̱ hu̱ to̱k-du̱ it. ");
INSERT INTO gel_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Da-u̱ it do̱re̱ gas-u̱ Kawuda, be-du̱ mya-mu̱ zatte̱ sok da. U̱r-kyat o̱ it kerte̱ naknu̱ hat-u re̱k-ya it gu̱g ya u̱du̱ hat-u yat-ya. ");
INSERT INTO gel_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Da tase̱ u̱n nakne̱ hat-u re̱k-ya u̱n su̱k ya u̱ do̱m-u̱ hat-u yat-ya, Se̱ u̱n gu̱gru̱sse̱ hat-u yat-ya u̱s-ho. U̱n no̱ng iya remu̱ taas ya caku̱mse̱ u̱t-kik u̱t-kik da. U̱n ust kap-tu̱ u-hat taasu̱ mya-mu̱ hu̱tu̱ to̱k-du̱ ya da. U̱n gun kwam-u yat-ya yu̱ shipe̱ u-hat remu̱ u̱n hooste̱ u-hat u̱r-no̱k. U̱n no̱ng inya remu̱ gye̱r-u̱ taas u̱n he̱ u̱-me̱ hereg-mu̱ Sirtis mu̱ de̱ na-su̱ u-hat. ");
INSERT INTO gel_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Remu̱ zu̱ bu̱-mu̱ no̱ng u-gwu̱z sok, tu̱msu̱ mo̱ o̱gu̱ ru̱m-su̱ it, da-u̱ is gase̱, a-nak-du̱ u-hat ne̱ he̱e̱se̱ koos-du̱ cwu̱-tu̱ o̱ u̱-me̱ u-hat e̱ gun u̱-me̱ m-bu̱. ");
INSERT INTO gel_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","U̱ ho̱-du̱ u-tu̱tu̱rse̱, u̱n u̱ hi-u̱r u̱n u̱ ju̱rge̱ to̱ko̱n no̱m-to̱ tu̱ u-hat remu̱ gye̱r-u̱ m-no. ");
INSERT INTO gel_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Da-u̱ it tumbe̱ it hyanu̱g u̱r-ho̱ ko re̱ge̱r da, tu̱msu̱ mya-m yat-mo̱ mu̱ u-yu̱ mo̱ o̱ gapdu̱ it, se̱ it ruut jab be̱e̱t u̱zu̱ it u̱t-fat. ");
INSERT INTO gel_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ba shu̱'u̱te̱ u̱zu̱ u̱n tumbte̱, waku̱n re̱e̱g no̱m u̱t-re̱ da, se̱ Burus yu̱ne̱ wa zu̱, <<U̱zu̱ no̱ kabu̱g rem-u̱s ri du̱gu̱ Kirit, no̱m-u̱t tunto̱ nu̱se̱ u̱ no̱m-u̱t yo̱-to̱ ku̱me̱ in, to za ku̱m-u̱t in da. ");
INSERT INTO gel_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Se̱di u̱ da-o̱ u̱m o̱ waru̱ no̱, no̱ no̱m be̱b-du̱ jab, remu̱ zu̱ waku̱n zaru̱ u̱t-taag u̱ fat-u̱r wa da, se̱di na taag u-hat. ");
INSERT INTO gel_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","U̱m zu̱u̱g iya remu̱ zu̱ Wa-to̱m Ru̱-u ri, tu̱msu̱ wu̱ u̱m o̱ u̱t-do̱r, wa haagu̱n u̱ dapu̱s du̱ ri gyu̱p-ne̱ m-gyu̱p. ");
INSERT INTO gel_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Wa zu̱, <Burus, a-bo̱ ho̱g u-gye̱r da. Se̱ bo̱ haag Roma tu̱msu̱ bo̱ u̱t-ees u̱ ke̱nu̱ Kaisar Faru̱k remu̱ wa kwu̱p-tu̱ bo̱ u̱s-rem. U̱m u̱t-sa bo̱ nap u̱zu̱ remu̱ nya-u u-Ru̱, wa de̱ tetu̱ bo̱ m-yar u̱ hu̱u̱b-tu̱ m-ha ró ne̱ u̱t-be̱e̱t.> ");
INSERT INTO gel_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Remu̱ iya hen no̱mu̱n be̱b-du̱ jab, me̱ u̱m yaag jab u̱du̱ u-Ru̱ u̱zu̱ no̱m-u̱ na waru̱ me̱ iya o̱ do̱te̱ u̱t-shu̱'u̱t. ");
INSERT INTO gel_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Se̱di mya-mo̱ gwu̱nu̱ in u̱-do̱mu̱ hereg-mu̱ o̱ko̱n dak-o̱.>> ");
INSERT INTO gel_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","U̱ gyu̱p-mu̱ o̱p u̱t-nas, mya-mu̱ o̱ pama-u̱ to̱kdu̱ it u̱ Sa-mu̱ Adiriya. U̱ te̱k-u̱ m-gyu̱p a to̱kdu̱ u-hat hyen u̱ka zu̱ na haag u̱ teen dak-u o̱. ");
INSERT INTO gel_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","U̱n mu̱'u̱s ra-du̱ m-bu̱, u̱n hyen teeg u̱s-daag u̱t-shik u̱t-shishin. Da-u̱ it re̱ shu̱ cashi, se̱ u̱n sur u̱t-mu̱'u̱s u̱n bit u̱s-daag u̱t-shik u̱t-nas u̱ o̱p. ");
INSERT INTO gel_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Remu̱ gye̱r-u̱ hat-yu̱ gap u̱t-ta'ar, u̱n gun u̱s-kwam u̱s-nas su̱ shipe̱ u-hat remu̱ u̱n hooste̱ u-hat u̱r-no̱k. U̱ da-u o̱ hen u̱n hu̱ u̱s-to̱o̱g u̱du̱ ru̱-u u̱n u̱ is-u̱ gas m-ho̱r m-ho̱r. ");
INSERT INTO gel_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Se̱di u̱ teku̱ a to̱k-du̱ u-hat e̱ke̱n sa'ag e̱ fat. E̱ nom u̱ka zu̱ u̱n o̱ cu̱st-u̱ kwam-tu̱ m-no du̱gu̱ hat-u yat-ya. ");
INSERT INTO gel_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Se̱ Burus zu̱ yu̱-shu̱ karma-ne̱ Roma u̱ a-m-gag ne̱ o̱ u̱ku̱n, <<A ne̱t-u̱t tun-to̱ eese̱ u̱-me̱ hat-u inya da, no̱ zaaru̱ u̱t-fat da.>> ");
INSERT INTO gel_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Da-u̱ e̱ ho̱ge̱ iya, se̱ a-m-gag ne̱ kwu̱pru̱sse̱ u̱s-ho su̱ hat-u re̱k-ya, e̱ yage̱ ya aru̱k u̱ me̱ m-bu̱. ");
INSERT INTO gel_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Da-u̱ is ha m-gas, se̱ Burus kon u̱n, u̱n re̱ no̱m u̱t-re̱. Wa zu̱, <<U̱ ya-o̱ m-roog o̱p u̱t-nas u̱ ya-o̱ no̱ o̱ wadu̱ jab, za no̱ re̱ o̱ko̱n. ");
INSERT INTO gel_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Remu̱ iya u̱m o̱ ko̱n-u̱s no̱, no̱ re̱ no̱m u̱t-re̱. Otte̱ u̱r-zwar u̱ na re̱, remu̱ na nom-u̱t u̱r-fat. U̱m o̱ waru̱ no̱ no̱mo̱n iya rem u̱zu̱ waku̱n zaar wu̱ de̱ u̱t-taag u̱ hi-yu̱ hi-u̱r wa da ko u-gan.>> ");
INSERT INTO gel_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Da-u̱ wa ware̱ iya, se̱ wa ku̱b u̱r-be̱re̱di, wa nom u̱t-vam u̱du̱ u-Ru̱ u̱ hyanu̱m u̱n be̱e̱t. Wa mot de̱, wa he̱e̱se̱ u̱t-re̱. ");
INSERT INTO gel_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Da-u o̱ kowan kum shiriktin-mu̱ jab, u̱n re ko u̱n. ");
INSERT INTO gel_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Tat-u it u̱ me̱ u-hat, it ne̱t u̱t-ko̱k u̱t-yu̱r u̱ u̱t-shik u̱t-tu̱t u̱ o̱pu̱ shishin (276). ");
INSERT INTO gel_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Da-u̱ u̱n re̱ no̱m u̱t-re̱ u̱n shig, u̱n habu̱ u-hat m-no, u̱n daas arkama u̱ me̱ m-bu̱. ");
INSERT INTO gel_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Da-u̱ is gase̱, a to̱k-du̱ u-hat nak be-du̱ e̱ o̱tte̱ da. Se̱di u̱n hyen de̱ku̱n gwu̱g-de̱ du̱ o̱tte̱ m-hereg. Se̱ u̱n zo̱ng u̱n hu̱u̱t u-hat u̱ku̱n a no̱me̱. ");
INSERT INTO gel_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","U̱n kwu̱pru̱sse̱ u̱s-ho su̱ na gu̱gte̱ u̱s-kwam su̱ m-no, u̱n yage̱ se̱ u̱-me̱ m-bu̱. U̱ te̱k-u̱ da-o̱ hen u̱n ust u̱s-gu̱ku̱t su̱ bire̱ u-hat, se̱ u̱n yu̱ns kap-tu̱ u-hat u̱ka mya-mu̱ do̱te̱ to̱kdu̱ u̱n u̱ shu̱. U̱n hu̱ u̱r-no̱k m-sa u-pingse̱. ");
INSERT INTO gel_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Se̱ hat-yu̱ gu̱p m-hereg u̱-me̱ m-bu̱, hat-yu̱ kerge̱ u̱r-no̱k da. Se̱ hat-yu̱ he̱e̱se̱ u̱t-yo̱'o̱k u̱-dim remu̱ be̱b-du̱ m-bu̱. ");
INSERT INTO gel_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","A-m-gag zo̱ng e̱ hoot ne̱t-tu̱ e̱ o̱ m-shu̱p u̱ e̱ ne̱, remu̱ gye̱r-u̱ taas waku̱n u̱ te̱k-u̱ me̱ u̱n wa no̱m u-swab wa so̱m. ");
INSERT INTO gel_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Se̱di yu̱-shu̱ karma-ne̱ Roma u̱t-sa wa gu Burus, se̱ wa hoos u̱n. Wa zu̱ u̱n be̱e̱t wu̱ nape̱ u-swab u-be̱e̱t wa he̱ m-bu̱ wa no̱m u-swab m-ha u̱ kit m-sa. ");
INSERT INTO gel_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","I za keru̱ u-swab da e̱ ship te-su̱ u-hat, ko u̱k-tu̱ u-hat tu̱ kuse̱. Iya o̱ hen u̱n be̱e̱t kowan te kit m-sa m-yar. ");
INSERT INTO gel_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Da-u̱ it kume̱ u-u̱ku̱r it te̱ u-pingse̱, it hog u̱zu̱ dim-du̱ dak-u o̱ foge̱ Marta. ");
INSERT INTO gel_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ne̱t-tu̱ be-u̱r re̱ e̱ gu it be̱e̱t tu̱msu̱ e̱ no̱mu̱ it no̱m-u̱t so̱-to̱ sok. E̱ dap-su̱ it u-ra it fa'at remu̱ zu̱ na o̱ u-yu̱ u̱ da-u o̱ tu̱msu̱ tor-mu̱ o̱ro. ");
INSERT INTO gel_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Burus kargu̱ssu̱n u̱t-te wa wu̱ u-ra, se̱ yaku̱n fa-ya u-ko̱ko̱s ya rwu̱u̱n remu̱ du̱ng-mu̱ u-ra, ya ship kom-u Burus. ");
INSERT INTO gel_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Da-u̱ ne̱t-tu̱ u-bo̱ hyane̱ u-fa u̱ kom-u Burus, se̱ e̱ zu̱ o̱r-u̱t e̱ ne̱, <<Ne̱t unwa wa ho̱-du̱ u̱t-ne̱t wa, ko ba wa ruye̱ du̱gu̱ m-sa, ra-o̱ do̱rru̱ wu̱n se̱ wa maru̱g.>> ");
INSERT INTO gel_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Burus pam-u̱t u-fa u̱ do̱m-u̱ kom-u wa, wa gun ya u̱-me̱ u-ra, tu̱msu̱ wa ho̱k m-re̱ da. ");
INSERT INTO gel_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","U̱n o̱ m-hyan u̱zu̱ kom-u o̱ u̱t-huus ko wa he̱'e̱ wa mar. Da-u̱ u̱n hyane̱ wa tumbte̱ o̱ko̱n kwu̱ng wa da, se̱ u̱n he̱e̱se̱ u̱s-dorog u̱zu̱ wu̱n o̱ko̱n ru̱-o̱ o̱. ");
INSERT INTO gel_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","U̱ dapu̱s be-du̱ ne̱t-tu̱ dapu̱ste̱ u-ra, to̱ko̱n tak-to̱ o̱ro tu̱ yaku̱n campa-ya dim-u̱r wa Fubiriyus. Wu̱na o̱ yu̱-shu̱ u̱ o̱ko̱n dak-o̱ u̱ o̱ m-gan m-bu̱. Wa bu̱n it, it haan it shu̱'u̱t u̱ bu-u rò. Wa ye' it be-du̱ u̱r-cu̱st du̱ so̱-de̱ m-te m-roog u̱t-tu̱t. ");
INSERT INTO gel_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","U̱so-u Fubiriyus o̱gu̱ m-ru̱t u̱ ko̱b-du̱ m-yar, wa o̱tte̱ du̱ng-mu̱ u-war u̱ remu̱ u̱t-me̱n ne̱. Se̱ Burus to u̱du̱ ro, wa do̱ru̱ wu̱n u-kom u̱r-hi wa no̱mu̱ wu̱n u̱s-to̱o̱g. Ne̱tu̱ wa kum m-yar. ");
INSERT INTO gel_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Da-u̱ wa no̱me̱ iya, se̱ a-ko̱b-du̱ m-yar ne̱ i o̱ u̱ dak-u o̱ haan u̱du̱ rò wa haste̱ e̱ u̱s-gom. ");
INSERT INTO gel_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ne̱t-tu̱ dak-u̱ o̱ m-gan m-sa e̱ ye' it u̱t-no̱m u-tát, e̱ no̱ng iya remu̱ e̱ ko̱ste̱ it u̱zu̱ e̱ o̱ yadu̱ it m-ze̱g sok. Da-u̱ it o̱ zo̱ng-su̱ u̱r-aru̱k, se̱ e̱ kargu̱ssu̱n it no̱m u̱t-re̱ u̱ to̱ko̱n no̱m-to̱ ne̱ tu̱ it u̱t-sa u̱t-be̱e̱t u̱-me̱ u-hat. ");
INSERT INTO gel_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Da-u̱ pyaat-su̱ u̱s-tu̱t arke̱, it to u̱ u-hat yu̱ ha-mu̱ Itariya, it aru̱k. Hat-yu̱ go̱se̱ u̱ku̱n u̱ da-u̱ u-go̱s u̱ dak-u o̱ u̱ o̱ m-gan m-sa. Hat-ya yu̱ rwu̱ne̱ du̱gu̱ Are̱kzandariya yu̱ o̱tte̱ m-sha mu̱ u̱t-ru̱ u̱t-yu̱r, Kasto u̱ Parus ne̱. ");
INSERT INTO gel_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Da-u̱ it teye̱ bo̱-u̱ Sirakus, it no̱m m-roog u̱t-tu̱t u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Se̱ it aru̱k u̱-me̱ u-hat, it te bo̱-u̱ Rigiyum. Da-u̱ roog-mu̱ u̱r-gan arke̱, mya-mu̱ yu̱nne̱ du̱gu̱ m-ereg it pu̱s m-ho̱r m-ho̱r. Da-u̱ is gase̱ it te bo̱-u̱ Futiyori ku̱na it yakte̱ u-hat. ");
INSERT INTO gel_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","U̱ ku̱na it gotu̱n u̱ e̱ke̱n a-doru̱ Ye̱so̱ ne̱. E̱ kon it u̱zu̱ it no̱m m-roog u̱t-ta'er u̱ u̱n ne̱. It ees u̱du̱ u̱n, se̱ it re shu̱ m-te dak-u̱ Roma. ");
INSERT INTO gel_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Da-u̱ a-doru̱ Ye̱so̱ i bo̱-u̱ Roma ho̱ge̱ u̱zu̱ it o̱ haan, se̱ e̱ haan e̱ gu it e̱ke̱n bit it u̱ <<Tu̱rru̱ u̱ Afisa,>> tu̱msu̱ e̱ke̱n bit it u̱ de̱ku̱n be-de̱ du̱ na zu̱ye̱ be-du̱ <<U̱t-kur u̱t-Tu̱t.>> Da-u̱ Burus hyane̱ u̱n wa no̱mu̱ u-Ru̱ u̱t-vam, tu̱msu̱ wa sur m-kwu̱m be̱b-du̱ jab. ");
INSERT INTO gel_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Da-u̱ it teye̱ u̱ Roma tu̱-shu̱ tu̱ Roma yagu̱ Burus wa shu̱'u̱t u̱ bu-u̱ m-se̱g u̱r-kot u̱ Karma-ne̱ i o̱ er-u̱r ro. ");
INSERT INTO gel_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Da-u̱ roog-mu̱ u̱t-tu̱t arke̱, Burus fog tu̱-shu̱ Yahuda-ne̱. Da-u̱ e̱ mo̱rge̱ se̱ wa zu̱ u̱n, <<No̱ o̱r-u̱t ri, ko ba shu̱'u̱te̱ u̱zu̱ u̱m no̱ngu̱ ne̱t-u̱t in to̱ko̱n ba'as-to̱ da, ko o̱ko̱n u̱ te̱k-u̱ u̱r-ma'in du̱ i mate̱ u̱so-u̱t in, ko iyane̱ na maaste̱ me̱ u̱ Urusharima. E̱ yasu̱ me̱ u̱du̱ Roma-ne̱ na tagu̱ me̱. ");
INSERT INTO gel_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","U̱n hen da-u̱ u̱n gwate̱, u̱n u̱t-sa u̱n yagu̱ me̱, remu̱ zu̱ u̱n byu̱k-u̱t me̱ u̱ to̱ko̱n ba'as-to̱ ne̱ tu̱ ko̱re̱ na ho̱ me̱ da. ");
INSERT INTO gel_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Da Yahuda-ne̱ gu̱gme̱ u̱t-ees, shu̱'u̱te̱ u̱zu̱ u̱m hu̱u̱t rem-u̱s se̱ m-ha u̱du̱ Kaisar, ko ba shu̱'u̱te̱ u̱zu̱ u̱m zatte̱ se̱ke̱n rem-se̱ su̱ u̱m haatu̱n remu̱ ne̱t-u̱t in da. ");
INSERT INTO gel_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","De̱ wu̱te̱ u̱m kon-u̱t u̱zu̱ no̱ haan u̱ ane̱ u̱ka u̱m do̱te̱ waru̱ no̱ ko̱ remu̱ u-yan o̱ u̱m o̱tte̱ wa bu-u̱ m-to̱k. U̱m o̱ u̱-me̱ u̱ bu-u̱ m-to̱k remu̱ zu̱ u̱m wa'ag jab u̱du̱ Kiristi. U̱m tumb-ne̱ Ru̱-u̱ este̱ u̱s-rem u̱zu̱ wa to̱mtu̱n Kiristi u̱du̱ in Yahuda-ne̱. Tu̱msu̱ wa haagu̱n.>> ");
INSERT INTO gel_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Se̱ e̱ zu̱ wu̱n, <<It, it hyang o̱ko̱n ran-o̱ du̱gu̱ gas-u̱ Yahudiya u̱ mo̱ttu̱ rem-u̱s ró da. Waku̱n haagu̱n hen wa waru̱ it rem-u̱s ró da, ko wa war se̱ke̱n rem-se̱ su̱ yo̱-se̱ u̱ bo̱ da. ");
INSERT INTO gel_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Se̱di it u̱t-sa it ho̱g ya-du̱ jab-u̱ ró, no̱mu̱ it nape̱ di mo̱t-tu̱ fu̱n-u Ye̱so̱ Kiristi yu̱ Burus o̱ bu̱t-tu̱ ya. Ko̱he̱ne̱ ne̱t-tu̱ o̱ warru̱ no̱m-u̱t yo̱-to̱ u̱ fu̱n-u inya.>> ");
INSERT INTO gel_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","E̱ wa'ag ho̱-du̱ e̱ de̱ u̱r-shu̱'u̱t u̱ Burus ne̱. Se̱ e̱ haan u̱ be-du̱ wa cu̱ste̱, u̱n haagu̱n hen u-tát. Du̱gu̱ u̱r-wu̱n m-ha m-rim, wa o̱ yadu̱ u̱n m-zu̱n u̱ mo̱ttu̱ Faru̱k-du̱ u-Ru̱. Wa u̱t-sa wa naku̱n u̱n u̱ haan u̱du̱ Ye̱so̱ remu̱ ko̱se̱-tu̱ u o̱ no̱mu̱ u̱n tu̱ rem-u̱s Mosa u̱ ran-tu̱ a-warru̱ rem-su̱ u-Ru̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","E̱ke̱n Yahuda-ne̱ yaag Jab-u̱ rem-u̱s ro, tu̱msu̱ e̱ke̱n yaag jab da. ");
INSERT INTO gel_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Remu̱ iya e̱ke̱n eeste̱ u̱ o̱r-u̱t e̱ ne̱ da. Burus nu̱p u̱zu̱ e̱ke̱n o̱ro i za u̱ssa e̱r-ru̱ wa da, da-u̱ e̱ o̱ mo̱t-tu̱ u̱r-aru̱k, se̱ wa zu̱, <<Yar-u u-Ru̱ no̱ngu̱ i mate̱ u̱so-u̱t in u̱s-rem. Wa no̱ng rem-u̱s se̱ u̱du̱ wa-warru̱ rem-su̱ u-Ru̱ Ishaya tu̱msu̱ no̱m-u̱ wa ware̱ u̱ remu̱ no̱ nip-to̱. ");
INSERT INTO gel_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","<< <De̱'e̱ u̱du̱ ne̱t-u̱t tun-to̱ bo̱ zu̱, <<No̱ u̱t-ho̱g, se̱di no̱ za u̱t-nap da; no̱ u̱t-hyan, se̱di no̱ za gwadu̱ u̱r-nu da.>> ");
INSERT INTO gel_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ru̱-u̱ zu̱u̱g a-warru̱ rem-u̱s wa, ne̱t-u̱t tunto̱ gwa'ag u̱r-nu da, remu̱ zu̱ jab-u̱s u̱n rindu̱sse̱. U̱n o̱tte̱ u̱t-to̱, se̱di u̱n gwa'ag nu-du̱ no̱m-u̱ o̱ u̱t-ho̱g da, u̱n takke̱ is-u̱ u̱n, remu̱ zu̱ u̱n za u̱ssa u̱n hyan da. A u̱n u̱t-sa u̱n dor no̱m-u̱ u̱m waru̱ u̱n, u̱n za gwa'ag u̱r-nu u̱ jab-u̱s u̱n, no̱m-u̱ u̱n hyane̱ me̱ u̱t-no̱m tu̱msu̱ no̱m-u̱ e̱ ho̱ge̱ me̱ u̱t-war. E̱ za byu̱rgu̱n du̱gu̱ fu̱n-su̱ u̱t-ba'as u̱ u̱n tu̱msu̱ u̱m za u̱ku̱rte̱ u̱n.> ");
INSERT INTO gel_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","<<U̱m u̱t-sa no̱ nap u̱zu̱, Ru̱-u̱ to̱mgu̱n rem-su̱ u-u̱ku̱r m-ha u̱du̱ i za-yahuda-ne̱ da. Tu̱msu̱ e̱ de̱ kab-du̱ se̱.>> ");
INSERT INTO gel_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Burus shu̱'u̱t u̱ bu-u̱ m-se̱g m-te u̱s-hak u̱s-yu̱r, wa o̱ kab-du̱ kowan wu̱ haane̱ u̱du̱ ro. ");
INSERT INTO gel_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Burus no̱ng u̱t-bu̱t tu̱msu̱ u̱t-ko̱se̱ ne̱ u̱ka Ru̱-u̱ dor-u̱t te̱ jab-u̱s e̱ tu̱msu̱ wa no̱mu̱ u̱n u̱t-ko̱se̱ u̱ mo̱t-tu̱ Ye̱so̱ Kiristi. Wa no̱ng iya za u-gye̱r, tu̱msu̱ waku̱n hooste̱ wu̱n da.");
INSERT INTO gel_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Me̱, Burus wa-doru̱ Kiristi Ye̱so̱, me̱ pane̱ uno̱ ran-o̱. Ru̱-u̱ dak me̱ Wa-to̱m-u̱ Ye̱so̱. Wa dak me̱ remu̱ u̱m nom-u̱t bu̱t-tu̱ Rem-su̱ m-Re̱me̱r su̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Kanda haan-u̱r Ye̱so̱, Ru̱-u̱ no̱ng este̱du̱ Rem-u̱s se̱ m-tumb ne̱, su̱ rwu̱ne̱ du̱gu̱ nu-u̱ a-warru̱ Rem-su̱ u-Ru̱ ne̱, u̱ka o̱tte̱ m-pan u̱-me̱ Ran-u̱ Rem-su̱ u-Ru̱ u-he̱n. ");
INSERT INTO gel_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Rem-su̱ m-Re̱me̱r u̱ se̱, su̱ mo̱ttu̱ Wa'-u̱ wa se̱, wu̱ shu̱'u̱te̱ ne̱t tu̱msu̱ wa rwu̱u̱n du̱gu̱ ko̱-u̱r Dawuda. ");
INSERT INTO gel_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Tu̱msu̱ Ru̱-u̱ ko̱ske̱ u̱zu̱ Wa'-u̱ u-Ru̱ wa Ye̱so̱ o̱ye̱. Ru̱-u̱ no̱ng iya remu̱ be̱b-du̱ Yar-u wa da-u̱ na yu̱nsu̱ Ye̱so̱ du̱gu̱ m-mar. Wu̱na o̱ Ye̱so̱ Kiristi Wa-ko-uyan in. ");
INSERT INTO gel_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Wu̱na dage̱ me̱ remu̱ u̱m shu̱'u̱te̱ Wa-to̱m-u̱ wa. Ru̱-u̱ yaag me̱ u-nya u̱m shu̱'u̱t Wa-to̱m-u̱ Ye̱so̱. Wa no̱ng iya remu̱ i-za-Yahuda-ne̱ da, e̱ de̱ yadu̱ wu̱n m-ze̱g tu̱msu̱ e̱ do̱r rem-u̱s rò remu̱ yadu̱ jab-u̱ e̱ no̱me̱ remu̱ bu̱t-tu̱ u̱m no̱mu̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","No̱ ne̱t-tu̱ bo̱-u̱ Roma, no̱ o̱ te̱k-u̱ ne̱t-tu̱ Ru̱-u̱ fage̱ e̱ shu̱'u̱t a-doru̱ Ye̱so̱ Kiristi. ");
INSERT INTO gel_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","U̱m o̱ panu̱ no̱ uno̱ ran-o̱, no̱ a-dor-ne̱ Roma be̱e̱t i Ru̱-u̱ o̱ u̱t-cwan tu̱msu̱ wa du̱g e̱ shu̱'u̱t ne̱t-u̱t wa: U̱m no̱ng u̱s-to̱o̱g u̱du̱ u-Ru̱ U̱so-u in u̱ Ye̱so̱ Kiristi ne̱ Wa-ko-uyan, wa re̱ shu̱ u̱ no̱mu̱ no̱ u-nya tu̱msu̱ wa ya' no̱ jab-u̱ pus-o̱. ");
INSERT INTO gel_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","No̱m u̱m u̱t-sa u̱t-zu̱ u̱r-taku̱n, u̱m no̱ng u̱t-vam remu̱ no̱ a-dor be̱e̱t i bo̱-u̱ Roma. U̱m kerge̱ no̱mu̱ u-Ru̱ u̱t-vam remu̱ no̱m-u̱ Ye̱so̱ Kiristi no̱me̱, yaag in u-fu̱n in no̱m-u̱t u̱s-rem u-Ru̱ ne̱. Tu̱msu̱ u̱m no̱me̱ u-Ru̱ u̱t-vam remu̱ zu̱ ne̱t-tu̱ o̱ rem-su̱ yadu̱ jab-u̱ no̱ u̱-me̱ u-dak u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ru̱-u̱ nak u̱ka u̱m hopte̱ no̱mu̱ no̱ u̱s-to̱o̱g ko̱-uyan da-o̱. U-ho̱ m-gyu̱p ne̱ u̱-me̱ to̱o̱g-u̱s ri u̱m haatu̱n ko̱n-u̱s no̱ u̱du̱ Ru̱-u ri, wu̱ u̱m o̱ u̱t-do̱r jab gan, tu̱msu̱ u̱m o̱ do̱nse̱-du̱ Rem-su̱ m-Re̱me̱r su̱ Wa'-u̱ wa. ");
INSERT INTO gel_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","To̱o̱g-u̱s ri ko-uyan da, Ru̱-u̱ upse̱ me̱ u-fu̱n u̱m haan u̱m hyen-u̱t no̱, abite̱ iya wa o̱tte̱ u̱ssa. ");
INSERT INTO gel_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","U̱m cwanu̱g u̱r-haan u̱du̱ no̱, u̱m no̱mu̱ no̱ u̱s-to̱o̱g no̱ kum-u̱t nya-u̱ u-Yar remu̱ no̱ shu̱'u̱te̱ u̱t-mo̱r u-Ru̱ tu̱msu̱ no̱ sur m-wa jab-u̱s no̱ u̱du̱ rò. ");
INSERT INTO gel_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Cwan-u̱t ri o̱ u̱zu̱, me̱ u̱ no̱ ne̱ in swu̱ru̱n hi-u̱t in m-shiriktin u̱ yadu̱ jab u̱du̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","O̱r-u̱t ri, u̱m u̱t-sa no̱ nap, u̱s-fu̱n u-tát, u̱m saag u̱m haan u̱du̱ no̱. Se̱di u̱m kwu̱mu̱g u̱r-ke̱r da u̱ haan u̱ da-o̱. U̱m cwanu̱g u̱m haan u̱m se̱gu̱ no̱ u̱ka no̱ do̱te̱ swu̱ru̱ u̱r-be̱b u̱-me̱ Ye̱so̱ Kiristi. U̱m cwanu̱g u̱m no̱mu̱ no̱ iya u̱ka u̱m no̱mtu̱ e̱ke̱n ne̱ i za-Yahuda-ne̱ da. ");
INSERT INTO gel_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Shu̱'u̱te̱ me̱ u̱ka u̱r-mag u̱-me̱ jab-u̱ ri u̱du̱ u̱t-ne̱t u̱t-be̱e̱t. Shu̱'u̱te̱ me̱ u̱r-mag u̱du̱ ne̱t-tu̱ Girik u̱ ya za Girik-ne̱ da, tu̱msu̱ u̱du̱ a-m-nap-ne̱ u̱ a-za-m-nap-ne̱. ");
INSERT INTO gel_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","O̱ wu̱te̱ u̱m zo̱ngte̱ u̱t-bu̱t su̱ Rem-su̱ m-Re̱me̱r u̱du̱ no̱ i o̱ bo̱-u̱ Roma. ");
INSERT INTO gel_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","U̱m za ho̱g-du̱ e̱'-mu̱ warru̱ Rem-su̱ m-Re̱me̱r da. Remu̱ zu̱ Rem-su̱ m-Re̱me̱r u̱ se̱ o̱ be̱b-du̱ u-Ru̱ ne̱ du̱ u-u̱ku̱r u̱du̱ ne̱t-tu̱ ya jab: Ru̱-u̱ taku̱n u̱kru̱ Yahuda-ne̱ i ya jab, se̱ i-za-Yahuda-ne̱ da. ");
INSERT INTO gel_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Remu̱ me̱ rem-su̱ m-Re̱me̱r jab-u̱ so̱-o̱ du̱gu̱-du̱ u-Ru̱ ko̱ske̱, jab-u̱ so̱-o̱ u̱ o̱o̱ge̱ u̱du̱ yadu̱ u̱t-nip du̱gu̱ u̱r-taku̱n m-ha m-vaste̱, u̱ka rem-su̱ u-Ru̱ pu̱nte̱ se̱ u̱zu̱ <<Ne̱t-u̱ jab-u̱ so̱-o̱ wa u̱t-kwu̱m u̱r-fat a wa ya' jab u̱du̱ u-Ru̱.>> ");
INSERT INTO gel_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ru̱-u̱ ko̱ske̱ ryab-u̱s wa su̱ rwu̱ne̱ du̱gu̱ do̱m u-ru̱ u̱du̱ a-za-jab-u̱s so̱-se̱ ne̱ u̱ a no̱m-du̱ no̱m-u̱t yo̱-to̱ ne̱. Remu̱ no̱m-u̱t yo̱-to̱ tu̱ ne̱t-tu̱ o̱ u̱t-no̱m wa'ag e̱ takke̱ u̱t-nip. ");
INSERT INTO gel_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kamu̱g u̱ kowan u̱ nap u̱ka Ru̱-u̱ o̱tte̱, remu̱ zu̱ Ru̱-u̱ ko̱ske̱ e̱ m-zu̱n ko̱wana wa o̱o̱ge̱. ");
INSERT INTO gel_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Du̱gu̱ da-u̱ Ru̱-u̱ no̱me̱ u-dak, no̱m-tu̱ u-Ru̱, tu̱ na hyente̱ u̱ is da, u̱ shin-m wa mu̱ za u̱t-ta da, tu̱msu̱ u̱ka wa o̱tte̱ ne̱, ko̱ske̱ m-zu̱n cas u̱-me̱ no̱m-tu̱ Ru̱-u̱ no̱me̱. Remu̱ iya ka u̱t-no̱m zarra u̱ ne̱t-u̱ zu̱ wa nak u-Ru̱ da. ");
INSERT INTO gel_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","E̱ nak u-Ru̱, se̱di e̱ ye'et wa m-sek u̱ka u-Ru̱ da, tu̱msu̱ e̱ no̱m-tu̱ wa u̱t-vam remu̱ no̱m-u̱ wa no̱me̱ da. Remu̱ zu̱ dorog-u̱s u̱n shu̱'u̱te̱ m-zan, tu̱msu̱ jab-u̱s e̱ shu̱u̱g u-cwu̱m. ");
INSERT INTO gel_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","E̱ o̱ m-hyan u̱ka zu̱ u̱n o̱ u̱s-ve̱r ne̱, se̱di dorog-u̱s u̱n su̱ m-rag se̱. ");
INSERT INTO gel_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","E̱ swase̱ no̱m-du̱ u̱t-huuk u̱du̱ u-Ru̱ wu̱ za u̱r-ma da, se̱di e̱ hu̱ no̱mu̱ u̱t-ryu̱n tu̱ o̱tte̱ sha-mu̱ u̱t-ne̱t tu̱ de̱ m-mar u̱ no ne̱ u̱ u̱t-bisa ne̱ u̱ no̱m-u̱ u̱r-fat ne̱. ");
INSERT INTO gel_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Remu̱ iya, Ru̱-u̱ yage̱ u̱n, e̱ hu̱ no̱m-du̱ no̱m-tu̱ e̱ cwane̱ u̱ jab-u̱s e̱. E̱ hu̱ yu̱-du̱ m-o̱ u̱-me̱ du̱ ko̱b-du̱ ya-du̱ war-tu̱ o̱r-u̱t u̱n ne̱ m-ze̱g. ");
INSERT INTO gel_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","E̱ yage̱ do̱rru̱ Ru̱-u̱ u̱t-nip, e̱ ship u̱s-bi. E̱ hu̱ u̱t-huuk u̱ m-to̱k ne̱ u̱du̱ no̱m-tu̱ Ru̱-u̱ no̱me̱, se̱di Ru̱-o̱ no̱me̱ u̱n be̱e̱t. Ru̱-o̱ ko̱re̱ na no̱me̱ u̱t-vam za u̱r-ma. U̱ shu̱'u̱t iya. ");
INSERT INTO gel_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Remu̱ iya, Ru̱-u̱ yage̱ e̱, e̱ nom-u̱t no̱m-tu̱ e̱ cwane̱ tu̱ m-'e̱. Ko̱ ne̱ta-ne̱ e̱ yage̱ m-roog campa-u̱t e̱ ne̱, e̱ hu̱ m-roog u̱ o̱r-u̱t e̱ ne̱ ne̱ta-ne̱. ");
INSERT INTO gel_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Campa-ne̱ tu̱msu̱ e̱ yage̱ m-roog u̱ ne̱ta-u̱t e̱ ne̱. Se̱di e̱ to m-o̱ u̱ o̱r-u̱t e̱ ne̱. Campa-ne̱ no̱mo̱g cwu̱-tu̱ m-'e̱ u̱ o̱r-u̱t e̱ ne̱, tu̱msu̱ e̱ swaag u̱r-ko̱b remu̱ no̱m-tu̱ e̱ no̱me̱. ");
INSERT INTO gel_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ba shu̱'u̱te̱ u̱zu̱ e̱ gu̱gu̱mte̱ e̱ kum nap-mu̱ u-Ru̱, se̱ wa yage̱ e̱ dor dorog-su̱ m-zan u̱n. E̱ hu̱ no̱m-du̱ no̱m-tu̱ kame̱ u̱zu̱ u̱n no̱ng da. ");
INSERT INTO gel_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Jab-u̱s u̱n o̱ shu̱yi-shu̱yi u̱ no̱m-u̱t yo̱-to̱. E̱ o̱ u̱ no̱mu̱ ne̱t-ne̱ no̱m-u̱t yo̱-to̱. E̱ paste̱ cwan-tu̱ m-zan. E̱ o̱ no̱mu̱ ne̱t-ne̱ no̱m-tu̱ de̱ naasu̱ e̱ jab. E̱ paste̱ u̱r-shu̱b. E̱ o̱ u̱ ho̱-du̱ u̱ ne̱t-ne̱. E̱ paste̱ u-har. E̱ parru̱ ne̱t-ne̱. E̱ o̱ jab-u̱ rim-o̱ ne̱. E̱ o̱ m-shat. ");
INSERT INTO gel_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","E̱ o̱ tu̱du̱ dim-tu̱ ne̱t-ne̱. E̱ yakke̱ u-Ru̱. E̱ paste̱ ju̱rmu̱ u̱t-ne̱t. E̱ paste̱ jaksu̱ u̱t-do̱s. E̱ yu̱kke̱ hu̱k-mu̱ u̱r-hi. Dorog-u̱s e̱ su̱ yo̱-se̱ se̱. E̱ o̱ ko̱b-du̱ kab-du̱ rem-su̱ i mate̱ e̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","E̱ zatte̱ u̱r-hi da. E̱ nom-u̱t no̱mu̱ e̱ cinte̱ u̱s-rem da. E̱ hog-u̱t o̱n-du̱ ne̱t da. ");
INSERT INTO gel_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","E̱ nak u̱zu̱ Ru̱-u̱ zu̱u̱g, i nome̱ no̱m-u̱t to̱ e̱ ko̱rge̱ na ho̱ e̱. Se̱di e̱ ze̱nge̱ u̱ no̱m-du̱ no̱m-tu̱ za so̱-to̱. E̱ maag u̱ku̱n da, e̱ hu̱ swu̱ru̱ e̱ke̱n be̱b-du̱ no̱m-du̱ no̱m-u̱t yo̱-to̱ to̱. ");
INSERT INTO gel_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","O̱r-u̱ ri, bo̱ wa hyan-du̱ ba'as-tu̱ o̱r-u̱ ró, bo̱ zatte̱ no̱m-u̱t war da. Remu̱ zu̱ da-u̱ bo̱ kwu̱pu̱ waku̱n u̱s-rem, bo̱ o̱ e̱ngu̱sse̱ hi-du̱ war ró, remu̱ zu̱ no̱m-u̱ bo̱ o̱tte̱ kwu̱pu̱ waku̱n u̱s-rem, o̱ bo̱ o̱ u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","U̱m zu̱u̱g iya remu̱ zu̱ Ru̱-u̱ nak u̱t-nip da-u̱ wa o̱ kwu̱p-du̱ u̱s-rem su̱ ne̱t-tu̱ o̱ no̱m-du̱ go̱-du̱ no̱m-u̱t yo̱-to̱ to̱. ");
INSERT INTO gel_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Bo̱ ne̱t, wa kwu̱pu̱ ne̱t-ne̱ u̱s-rem remu̱ no̱m-du̱ no̱m-u̱t yo̱-to̱, se̱ bo̱ o̱ no̱m-du̱ no̱m-u̱t yo̱-to̱ ko̱ bo̱, ¿Bo̱ o̱ m-hyan u̱zu̱ bo̱ ku̱s-mu̱ kwu̱p-du̱ u̱s-rem su̱ u-Ru̱? ");
INSERT INTO gel_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Kamu̱g in napu̱n u̱zu̱ Ru̱-u̱ no̱ngu̱ in no̱m-u̱t so̱-to̱, u̱ o̱n-u̱r wa ne̱ tu̱msu̱ wa zatte̱ ho̱r-mu̱ u̱s-nip da. A in ju̱ru̱m wu̱n da remu̱ gag-du̱ jab-u̱ wa u̱du̱ in. Napu̱n u̱zu̱ Ru̱-u̱ ko̱su̱ in o̱n-u̱r wa, remu̱ in byu̱rtu̱n u̱du̱ wa tu̱msu̱ in yage̱ no̱m-du̱ u̱t-ba'as. ");
INSERT INTO gel_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Se̱di remu̱ ko̱b-du̱ ho̱g-mu̱ u̱s-rem, u̱ ko̱b-du̱ u̱t-byu̱ru̱n ne̱ u̱du̱ u-Ru̱, bo̱ o̱ naknu̱ hi-u̱r ró swadu̱ u̱r-ko̱b u̱ ho̱-du̱ ryab-su̱ u-Ru̱. U̱ Ho̱-u̱r re̱ wa de̱ no̱mu̱ ne̱t-ne̱ kwu̱p-du̱ u̱s-rem ho̱n-ho̱n. ");
INSERT INTO gel_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Ru̱-u̱ <<de̱ top ko̱wan ho̱n-ho̱n u̱ go̱-du̱ pama-u̱ wa no̱me̱.>> ");
INSERT INTO gel_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ru̱-u̱ de̱ yadu̱ fat-du̱ za u̱r-ma u̱du̱ ne̱t-tu̱ o̱ no̱m-du̱ no̱m-u̱t so̱-to̱, tu̱msu̱ u̱du̱ i wa jab e̱ kum u̱t-fu̱'u̱bse̱, m-sek ne̱ u̱ wadu̱ jab ne̱ u̱ Ru̱-u̱ ya u̱n fat-du̱ za u̱r-ma. ");
INSERT INTO gel_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Se̱di to̱ko̱n ne̱t-to̱ o̱tte̱ cwan-tu̱ u̱r-hi, e̱ yaag jab-u̱ no̱m-u̱ Ru̱-u̱ zu̱ye̱ nip-to̱ da. E̱ re shu̱ u̱ no̱m-du̱ no̱m-tu̱ za so̱-to̱. Ru̱-u̱ de̱ yadu̱ u̱n u̱r-ko̱b sok. ");
INSERT INTO gel_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Wa de̱ yadu̱ ne̱t be̱e̱t wu̱ o̱ no̱m-du̱ no̱m-u̱t yo̱-to̱ u̱r-ko̱b sok u̱ namu̱ jab ne̱, Ru̱-u̱ de̱ he̱e̱se̱ yadu̱ Yahuda-ne̱ u̱r-ko̱b, kanda wa ya' i-za-Yahuda-ne̱ u̱r-ko̱b. ");
INSERT INTO gel_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Se̱di Ru̱-u̱ de̱ yadu̱ ko̱wan wu̱ o̱ no̱m-du̱ no̱m-u̱t so̱-to̱, m-ze̱g, m-sek ne̱, u̱ res-du̱ jab ne̱. Ru̱-u̱ de̱ u̱t-taku̱n u̱du̱ Yahuda-ne̱, kanda wa ya' i-za-Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Remu̱ zu̱ Ru̱-u̱ ko̱ste̱ m-ku̱u̱k da. ");
INSERT INTO gel_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","I za-Yahuda-ne̱ da, a e̱ no̱me̱ u̱t-ba'as, Ru̱-u̱ de̱ kwu̱pu̱ e̱ u̱s-rem ko̱ u̱ka e̱ zatte̱ bo̱r-u̱t Ru̱-u̱ yase̱ Mosa da. Tu̱msu̱ Yahuda-ne̱ i o̱tte̱ bo̱r-u̱t Mosa, a e̱ no̱me̱ u̱t-ba'as, Ru̱-u̱ de̱ kwu̱pu̱ e̱ u̱s-rem remu̱ ko̱b-du̱ do̱rru̱ u̱t-bo̱r. ");
INSERT INTO gel_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","No̱ng ho̱n-ho̱n na ya u̱n u̱r-ko̱b, remu̱ za ne̱t be̱e̱t wu̱ nape̱ bo̱r-tu̱ u-Ru̱ wa o̱ ne̱t-u̱ jab-u̱ so̱-o̱ da. Se̱di ne̱t-tu̱ o̱ do̱rru̱ no̱m-u̱ bo̱r-tu̱ Ru̱-u̱ yase̱ Mosa, Ru̱-u̱ de̱ fag-du̱ ne̱t-u̱ wa, wa jab-u̱ so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","E̱ke̱n i za-Yahuda-ne̱ dor bo̱r-tu̱ Ru̱-u̱ yase̱ Mosa. Ko̱ske̱ u̱zu̱ bo̱r-tu̱ u-Ru̱ o̱ u̱-me̱ jab-u̱s u̱n, ko̱ ba shu̱'u̱te̱ u̱zu̱ waku̱n ya'aste̱ u̱n bo̱r-tu̱ Ru̱-u̱ yaase̱ Mosa da. ");
INSERT INTO gel_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Yu̱-u̱r u̱n ko̱ske̱ u̱zu̱ e̱ nak u̱-me̱ jab-u̱s e̱ no̱m-u̱ Ru̱-u̱ u̱t-sa u̱-me̱ u̱t-bo̱r. Remu̱ zu̱ da-u̱ e̱ no̱me̱ no̱m-u̱ za so̱-o̱, jab-u̱s e̱ ko̱su̱ e̱, tu̱msu̱ a no̱me̱ u̱ so̱-o̱ jab-u̱s e̱ ko̱su̱ e̱. ");
INSERT INTO gel_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Remu̱ iya, u̱ka no̱ hogte̱ me̱ bu̱t-tu̱ Rem-su̱ m-Re̱me̱r o̱ u̱t-war, iya do̱te̱ shu̱'u̱te̱. Ru̱-u̱ de̱ yadu̱ Ye̱so̱ Kiristi m-shin mu̱ wa do̱te̱ kwu̱pu̱ ne̱t-ne̱ u̱s-rem, ko̱ dorog-su̱ m-yasa su̱ jab-su̱ u̱t-ne̱t u̱s-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Bo̱ foge̱ hi-u̱r ró <<Wa-Yahuda wa,>> bo̱ to̱ste̱ jab-u̱ ró u̱ do̱m-u̱ bo̱r-tu̱ u-Ru̱, tu̱msu̱ bo̱ o̱ u̱t-u̱k u̱ yu̱-u̱r ró u̱zu̱ bo̱ ne̱t-u̱ u-Ru̱ wa. ");
INSERT INTO gel_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Bo̱ nak no̱m-u̱ Ru̱-u̱ o̱ u̱t-cwan. Remu̱ zu̱ ne̱t-tu̱ iis-tu̱ bo̱ bo̱r-tu̱ u-Ru̱, tu̱msu̱ bo̱ nak no̱m-tu̱ kame̱ bo̱ dag tu̱ o̱ ho̱n-ho̱n. ");
INSERT INTO gel_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","A mu̱ne̱ u̱zu̱ bo̱ zatte̱ u-sakna da u̱zu̱ bo̱ o̱o̱ge̱ dor-u̱t ne̱t-tu̱ o̱ po̱-ne̱, tu̱msu̱ bo̱ o̱ bo̱ m-zu̱n u̱du̱ ne̱t-tu̱ o̱ u̱-me̱ u-cwu̱m. ");
INSERT INTO gel_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Bo̱ kabe̱ u̱zu̱ bo̱ wa-u̱t-ko̱se̱ a-ko̱b-du̱ m-nap ne̱ wa u̱ ya'ag-u̱ re̱k-e̱ ne̱, remu̱ zu̱ bo̱ nak u̱zu̱ bo̱r-tu̱ Ru̱-u̱ yase̱ Mosa o̱tte̱ m-nap u̱ u̱t-nip ne̱. ");
INSERT INTO gel_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Bo̱ wa iis-u̱ e̱ke̱n, ¿bo̱ iiste̱ hi-u̱r ró? Bo̱ wu̱ o̱ u̱t-bu̱t u̱zu̱ ne̱t-tu̱ yage̱ u-hiw, ¿bo̱ gwak-u̱t no̱m-u̱ bo̱ o̱ u̱t-war u̱r-zwar ne̱ u̱zu̱ bo̱ nom-u̱t u-hiw da? ");
INSERT INTO gel_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Bo̱ wu̱ o̱ u̱t-zu̱ a ne̱t-tu̱ no̱m m-o̱ da, ¿bo̱ gwak-u̱t no̱m-u̱ bo̱ o̱ u̱t-war u̱r-zwar ne̱ u̱zu̱ bo̱ no̱m-u̱t m-o̱ da? Bo̱ wu̱ tonte̱ m-gir da, ¿bo̱ nom-u̱t u-hiw u̱ pyu̱ m-gir da? ");
INSERT INTO gel_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Bo̱ wu̱ o̱ u̱t-u̱k u̱zu̱ bo̱ o̱tte̱ bo̱r-tu̱ Ru̱-u̱ yase̱ Mosa. ¿Se̱di bo̱ gwak-u̱t u̱zu̱ bo̱ naaste̱ dim-du̱ u-Ru̱ da-u̱ bo̱ pase̱ rem-su̱ u-bo̱r da? ");
INSERT INTO gel_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","De̱ wu̱te̱ Rem-su̱ u-Ru̱ zu̱u̱t, <<No̱m-u̱ Yahuda-ne̱ o̱ u̱t-no̱m wa'ag i-za-Yahuda-ne̱ o̱tte̱ ju̱rmu̱ Ru̱-u Yahuda-ne̱ ko̱he̱ne̱.>> ");
INSERT INTO gel_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","No̱m-du̱ u̱r-pe̱s o̱tte̱ u̱r-zwar, a ne̱t-u̱ do̱re̱ bo̱r-tu̱ u-Ru̱. Se̱di a ne̱t do̱re̱ bo̱r-tu̱ u-Ru̱ da wa shu̱'u̱te̱ u̱s-gan u̱ ne̱t-tu̱ na no̱me̱ u̱r-pe̱s ne̱ da. ");
INSERT INTO gel_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","A shu̱'u̱te̱ zu̱ i zatte̱ u̱r-pe̱s da, e̱ o̱ do̱rru̱ bo̱r-tu̱ u-Ru̱, Ru̱-u̱ de̱ kab-du̱ e̱ ne̱t-u̱t wa. ");
INSERT INTO gel_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Na de̱ kwu̱pu̱ no̱ u̱s-rem remu̱ zu̱ no̱ o̱tte̱ bo̱r-u̱t Mosa tu̱msu̱ no̱ no̱mo̱g u̱r-pe̱s, se̱di no̱ o̱ pas-du̱ bo̱r-u̱t to̱. ");
INSERT INTO gel_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Wa-Yahuda wu̱ u̱t-nip wa bo̱ o̱ye̱ da, a-bo̱ shu̱'u̱te̱ wa-Yahuda u-war. Se̱di o̱tte̱ u̱r-zwar bo̱ shu̱'u̱t wa-Yahuda u̱ jab u-war ne̱. ");
INSERT INTO gel_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Wa-Yahuda u̱t-nip wa o̱ wu̱ jab-u̱ wa o̱o̱ge̱ ho̱n-ho̱n u̱du̱ u-Ru̱. Yar u-Ru̱ o̱ do̱'e̱ no̱mu̱ jab-u̱ ne̱t u̱r-pe̱s za bo̱r-tu̱ ne̱t pane̱ da. Go̱-du̱ ne̱t-u̱ wa kum u̱t-vam du̱gu̱-du̱ u-Ru̱, za du̱gu̱-du̱ ne̱t da. ");
INSERT INTO gel_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","¿De̱ku̱n se̱ge̱-de̱ o̱ro du̱ Yahuda-ne̱ kume̱ du̱ i-za-Yahuda-ne̱ kumte̱ da? ¿Yan-o̱ ne̱t de̱ u̱t-kwu̱m ana no̱mu̱ wa u̱r-pe̱s? ");
INSERT INTO gel_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Se̱ge̱-du̱ o̱ro du̱ ne̱t do̱'e̱ u̱t-kwu̱m u̱s-fu̱n u-tát! Ru̱-u̱ ya'aste̱ rem-u̱s wa u̱du̱ Yahuda-ne̱ remu̱ e̱ got se̱ u̱r-zwar ne̱. ");
INSERT INTO gel_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Yahuda-ne̱ u-tát e̱ zatte̱ yadu̱ jab u̱du̱ u-Ru̱ u̱ka e̱ nomte̱ este̱du̱ u̱s-rem u̱zu̱ u̱t-ya jab da. Waku̱n u̱t-kere̱ u̱t-shu̱t u̱zu̱, <<¿No̱ o̱ m-hyan u̱zu̱ a Yahuda-ne̱ shu̱'u̱te̱ a-ko̱b-du̱ yadu̱ jab, u̱t-wa u̱ Ru̱-u̱ yage̱ no̱m-du̱ no̱m-u̱ wa nom-tu̱ Yahuda-ne̱ es-du̱ u̱s-rem?>> ");
INSERT INTO gel_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Za u̱t-no̱me̱ da iya! Ko̱ ne̱t-ne̱ be̱e̱t shu̱'u̱te̱ a-u̱s-bi, u-Ru̱ wa-u̱t-nip wa, u̱ka Rem-su̱ u-Ru̱ zu̱tte̱: <<Remu̱ ne̱t-ne̱ hyen-u̱t u̱zu̱ no̱m-u̱ bo̱ ware̱ u̱ mo̱ttu̱ ba'as-u̱t u̱n nip-to̱, tu̱msu̱ bo̱ re̱ u̱r-ko̱rro̱ ana o̱ kwu̱p-du̱ rem-u̱s ró.>> ");
INSERT INTO gel_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Abite̱ no̱m-u̱t yo̱-to̱ in o̱ u̱t-no̱m ko̱ske̱ no̱m-u̱t so̱-to̱ tu̱ Ru̱-u̱ no̱me̱, ¿In de̱e̱n u̱t-zu̱ Ru̱-u̱ no̱ng ho̱n-ho̱n da a wa ya' in u̱r-ko̱b? (Sin-se̱ dorog-su̱ u̱r-ma ne̱t se̱.) ");
INSERT INTO gel_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Za u̱t-no̱me̱ iya da! A shu̱'u̱te̱ Ru̱-u̱ no̱me̱ ho̱n-ho̱n da ko̱-uyan da, ¿re̱ne̱ o̱ wa do̱te̱ no̱mu̱ ne̱t-tu̱ u-dak kwu̱p-du̱ u̱s-rem ho̱n-ho̱n ne̱? ");
INSERT INTO gel_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Waku̱n wa u̱t-kere̱ u̱t-zu̱, <<A mu̱ne̱ u̱zu̱ bis-u̱s ri hatu̱n m-swu̱r mu̱ nip-tu̱ Ru̱-u̱ u̱ swu̱r-mu̱ ze̱g-m wa ne̱, ¿Remu̱ u-yan o̱ Ru̱-u̱ do̱te̱ kwu̱pu̱ me̱ u̱s-rem u̱zu̱ me̱ wa-u̱t-ba'as wa?>> ");
INSERT INTO gel_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","To̱ko̱n ne̱t-to̱ ke̱k-tu̱ it u̱s-rem u̱zu̱ it zu̱u̱g, <<Yage̱ it no̱m u̱t-ba'as, remu̱ no̱m-u̱t so̱-to̱ nom-u̱t.>> Se̱di Ru̱-u̱ de̱ kwu̱pu̱ u̱n u̱s-rem ho̱n-ho̱n. ");
INSERT INTO gel_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","¿Yan-o̱ in do̱'e̱ u̱t-zu̱? ¿In Yahuda-ne̱ ze̱g m-ze̱g i-za-Yahuda-ne̱ da? Ko̱ o̱ko̱n, na ko̱sku̱ u̱zu̱ u̱t-ne̱t u̱t-be̱e̱t! U̱ Yahuda-ne̱ u̱ i-za-Yahuda-ne̱ da ganse̱ na o̱ye̱ remu̱ be̱b-du̱ u̱t-ba'as de̱ o̱ dor-tu̱ na. ");
INSERT INTO gel_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","U̱-me̱ Rem-su̱ u-Ru̱, na panu̱g no̱m-u̱t tun-to̱ u̱t-be̱e̱t: <<Ne̱t-u̱ jab-u̱ so̱-o̱ zarra, ko̱ wa-gan; ");
INSERT INTO gel_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","waku̱n zaar wu̱ o̱ m-nap ne̱ da, waku̱n zaar wu̱ o̱ sa-u̱ u-Ru̱ da. ");
INSERT INTO gel_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ne̱t-ne̱ be̱e̱t e̱ yakke̱ fu̱n-yu̱ u-Ru̱, Ne̱t-ne̱ be̱e̱t e̱ zatte̱ fu̱n da; Waku̱n zaar wu̱ nome̱ no̱m-u̱t so̱-to̱ da, ko̱ wa-gan.>> ");
INSERT INTO gel_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","<<Nu-u̱t e̱ o̱ u̱ka u̱t-sag tu̱ o̱ u̱r-hu̱k, Rem-u̱t e̱ shu̱u̱g u̱s-bi.>> <<Rem-u̱s e̱ u̱ka m-rab mu̱ fa-u yo̱-ya.>> ");
INSERT INTO gel_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","<<Nu-u̱t e̱ shu̱u̱g u̱ rem-u̱s yo̱-se̱, u̱s-pyap ne̱.>> ");
INSERT INTO gel_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","<<E̱ waaste̱ ho̱-du̱ ne̱t da. ");
INSERT INTO gel_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Ko̱ he̱ e̱ hu̱u̱te̱ e̱ hatu̱n u-naas u̱ namu̱ jab ne̱ u̱du̱ u̱t-ne̱t tu̱msu̱ hi-du̱ war'e̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","E̱ nak fu̱n-yu̱ res-du̱ jab da.>> ");
INSERT INTO gel_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","<<Gye̱r-u u-Ru̱ zaar u̱ jab-u̱s u̱n da.>> ");
INSERT INTO gel_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","U̱ da-o̱ in nak u̱zu̱ Yahuda-ne̱ e̱ na u̱t-sa e̱ do̱r bo̱r-tu̱ u-Ru̱ tu̱ Mosa pane̱. Na no̱mo̱g iya hen remu̱ ne̱t-tu̱ taagte̱ no̱m-u̱t war, tu̱msu̱ Ru̱-u̱ de̱ kwu̱pu̱ ne̱t-tu̱ dak-u uno̱ u-be̱e̱t u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Remu̱ iya, waku̱n zaar wu̱ de̱ u̱t-shu̱'u̱t wa za u̱t-ba'as remu̱ do̱rru̱ no̱m-u̱ bo̱r-tu̱ zu̱ na no̱m da. No̱m-u̱ bo̱r-tu̱ nome̱ o̱ ko̱su̱ ne̱t u̱ka ba'as-u̱t wa o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Se̱di u̱ da-o̱ Mosa u̱ a-warru̱ Rem-su̱ u-Ru̱ ne̱ ko̱ske̱ in fu̱n-yu̱ yadu̱ jab-u̱ so̱-o̱, za remu̱ do̱rru̱ no̱m-tu̱ bo̱r-tu̱ u̱t-sa da. ");
INSERT INTO gel_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Uno̱ jab-u̱ so̱-o̱ du̱gu̱-du̱ u-Ru̱ hagu̱n du̱gu̱-du̱ yadu̱ jab u̱du̱ Kiristi u̱du̱ i ya'e̱ u̱t-nip be̱e̱t. Mo̱ko̱n ku̱u̱k-mo̱ zaar da. ");
INSERT INTO gel_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Ne̱t-ne̱ kowan no̱ng u̱t-ba'as, tu̱msu̱ e̱ no̱mo̱g m-ra u̱ sek-mu̱ u-Ru̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Tu̱msu̱ Ru̱-u̱ no̱ng se̱ge̱-u̱r wa remu̱ nya-u̱ wa no̱mu̱ in jab gan. Wa no̱mo̱g iya remu̱ Kiristi Ye̱so̱ wu̱ rure̱ in du̱gu̱ swadu̱ u̱r-ko̱b du̱ u̱t-ba'as. ");
INSERT INTO gel_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Ru̱-u̱ ya'aste̱ Ye̱so̱ u̱ka u̱r-to̱o̱g du̱ hastu̱ u̱t-ba'as. Wa no̱mo̱g iya remu̱ wa mu̱tte̱ ne̱t-ne̱ za u̱t-ba'as u̱du̱ u-Ru̱ da-u̱ e̱ ya jab u̱du̱ Ye̱so̱ wu̱ mare̱ u̱ remu̱ in tu̱msu̱ wa azu̱g hyu̱-m wa. To̱o̱g-u̱ o̱ ko̱ske̱ u̱zu̱ Ru̱-u̱ zatte̱ m-ku̱u̱k da, tu̱msu̱ remu̱ gag-du̱ jab-u̱ wa, wa ruuste̱ u̱ fu̱n-u̱ ba'as-tu̱ e̱ no̱me̱ u-dim wa yaag u̱n u̱r-ko̱b da. ");
INSERT INTO gel_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Ru̱-u̱ no̱ng gag-du̱ jab-u̱ uno̱ da-o̱ remu̱ wa ko̱ste̱ u̱zu̱ wa o̱tte̱ jab-u̱ so̱-o̱. Tu̱msu̱ ne̱t be̱e̱t wu̱ ya' jab u̱du̱ Ye̱so̱ wa de̱ u̱t-shu̱'u̱t wa jab-u̱ so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","U̱ da-o̱ hen, ¿yan-o̱ na do̱te̱ u̱t-u̱k? O̱ko̱n zarra! Ru̱-u̱ za kab-du̱ ne̱t remu̱ zu̱ a o̱ do̱rru̱ bo̱r-u̱t Mosa da, se̱di wa kab i o̱ yadu̱ jab u̱du̱ Ye̱so̱ u̱ to̱o̱g-u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","In nak u̱zu̱ Ru̱-u̱ o̱ kab-du̱ u̱t-ne̱t remu̱ yadu̱ jab-u̱ e̱ za remu̱ do̱rru̱ u-bo̱r da. ");
INSERT INTO gel_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","¿Ru̱-u Yahuda-ne̱ o̱ war-o̱? ¿Ru̱-u a-za Yahuda-ne̱ wa ko̱ e̱ da? Iya o̱, Ru̱-u̱ ne̱t-ne̱ be̱e̱t o̱. ");
INSERT INTO gel_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Ru̱-o̱ u-gan, wa de̱ muutu̱ Yahuda-ne̱ e̱ shu̱'u̱t a-jab-u̱s so̱-se̱ u̱du̱ wa, remu̱ yadu̱ jab-u̱ u̱n. Tu̱msu̱ muut i za-Yahuda-ne̱ da a-jab-u̱s so̱-se̱ u̱du̱ wa, remu̱ yadu̱ jab-u̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","¿No̱ o̱ m-hyan in mu̱u̱tu̱n bo̱r-tu̱ Ru̱-u̱ yase̱ Mosa m-zan u̱ remu̱ mo̱ttu̱ ya-du̱ jab? Ko̱ cashi iya o̱ da! Se̱di a inya jab u̱du̱ Ye̱so̱, u̱t-ko̱se̱ u̱zu̱ bo̱r-u̱t Mosa o̱tte̱ m-shin. ");
INSERT INTO gel_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","¿A in o̱ dorog-su̱ mo̱ttu̱ bo̱r-u̱t Mosa tu̱msu̱ u̱ka ne̱t do̱te̱ u̱t-shu̱'u̱t wa jab-u̱ so̱-o̱, kamu̱g in baksu̱n Ibrahi, u̱so-u̱ u̱so-u̱t Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Abite̱ remu̱ no̱m-du̱ no̱m-u̱t so̱-to̱ Ibrahi o̱ Ru̱-u̱ has-tu̱ wa u̱t-ba'as, Ibrahi za kwu̱mu̱g no̱m-u̱ u̱t-u̱k u̱-me̱ u̱t-ne̱t, se̱di wa za kum-u̱t no̱m-u̱ u̱t-u̱k u̱du̱ u-Ru̱ da. ");
INSERT INTO gel_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Rem-su̱ u-Ru̱ zu̱u̱g, <<Ibrahi yaag jab u̱du̱ u-Ru̱, de̱ wu̱te̱ Ru̱-u̱ fog-u̱t wa wa-jab-u̱ so̱-o̱.>> ");
INSERT INTO gel_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Da-u̱ ne̱t-u̱ no̱me̱ u-pama, to̱p-u̱ na do̱'e̱ to̱p-du̱ wa ho̱s-mo̱ da. Se̱di to̱p-u̱ no̱m-u̱ wa no̱me̱ o̱. ");
INSERT INTO gel_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Se̱di na got ne̱t-ne̱ a-jab-u̱s so̱-se̱ ne̱, za remu̱ pama-u̱s e̱ da, se̱di remu̱ yadu̱ jab-u̱ e̱ u̱du̱ u-Ru̱ wu̱ nome̱ ho̱-du̱ u̱t-ba'as. ");
INSERT INTO gel_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Dawuda waru̱g rem-u̱s se̱ da-u̱ wa no̱me̱ rem-su̱ kom-u̱ u-Ru̱ u̱du̱ ne̱t-u̱ wu̱ Ru̱-u̱ fage̱ wa jab-u̱ so̱-o̱ za wa no̱m o̱ko̱n pama-o̱. ");
INSERT INTO gel_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","<<Ne̱t-tu̱ Ru̱-u̱ no̱me̱ ho̱-du̱ ba'as-u̱t e̱, e̱ o̱tte̱ Kom-u̱ u-Ru̱, I na takse̱ baas-u̱t e̱ otte̱ kom-u̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Kom u-Ru̱ u̱du̱ ne̱t, wu̱ Yawe za u̱t-baku̱s u̱ no̱m-tu̱ ba'as-u̱t wa ne̱ da.>> ");
INSERT INTO gel_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","¿Kom-u̱ u-Ru̱ o̱ do̱m-u̱ a-u̱r-pe̱s-ne̱ u̱ war-e̱ kyak i na no̱me̱ u̱r-pe̱s? ¿Ko̱ be̱e̱t u̱ a-za-u̱r-pe̱s-ne̱? No̱m-u̱ in o̱ u̱t-zu̱, <<Ibrahi o̱tte̱ yadu̱ jab u̱du̱ u-Ru̱, de̱ wu̱te̱ Ru̱-u̱ ku̱b-u̱t wu̱n, wa-jab-u̱ so̱-o̱.>> ");
INSERT INTO gel_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","¿Yan da-o̱ Ru̱-u̱ muutu̱ Ibrahi wa jab-u̱ so̱-o̱? ¿Da-u̱ na no̱mu̱ wa u̱r-pe̱s o̱ ko̱ kanda na no̱mu̱ wa u̱r-pe̱s? Ru̱-u̱ fak Ibrahi wa jab-u̱ so̱-o̱ kanda na no̱m-tu̱ wa u̱r-pe̱s o̱. ");
INSERT INTO gel_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Se̱di wa kabu̱g nap-su̱ u̱r-pe̱s remu̱ yadu̱ jab-u̱ rò u̱du̱ u-Ru̱ u̱zu̱ wa haste̱ ba'as-u̱t rò. Remu̱ iya Ibrahi shu̱'u̱te̱ u-u̱so u̱ yadu̱ jab u̱du̱ a-yadu̱ jab ne̱ ko̱ ba na no̱me̱ u̱n u̱r-pe̱s da. Ru̱-u̱ o̱ hyan-du̱ u̱n a-jab-u̱s so̱-se̱ ne̱ remu̱ yadu̱ jab-u̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Tu̱msu̱ wu̱na u̱so-u i na no̱me̱ u̱r-pe̱s, za rem u̱r-pe̱s u̱ warre̱ da se̱di do̱rru̱ da-tu̱ yadu̱ jab-u̱ u̱so-u in Ibrahi kanda na no̱me̱ wa u̱r-pe̱s. ");
INSERT INTO gel_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Ru̱-u̱ no̱ngu̱ este̱du̱ u̱s-rem u̱ yaase̱ u-dak u-be̱e̱t u̱du̱ Ibrahi u̱ ko̱-u̱r wa ne̱, za remu̱ do̱rru̱ bo̱r-tu̱ u-Ru̱ da se̱di remu̱ zu̱ Ibrahi yaag jab u̱du̱ u-Ru̱. Remu̱ iya, Ru̱-u̱ zu̱ Ibrahi ne̱t-u̱ jab-u̱ so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Abite̱ es-du̱ u̱s-rem su̱ u-Ru̱ u̱ i o̱ do̱rru̱ u-bo̱r ne̱ o̱ u̱ war-o̱, ko̱ske̱ u̱zu̱ yadu̱ jab-u̱ ne̱t zan-mo̱, tu̱msu̱ este̱du̱ u̱s-rem su̱ Ru̱-u̱ no̱me̱ zatte̱ m-kim da. ");
INSERT INTO gel_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","U̱m zu̱u̱g iya, remu̱ zu̱ bo̱r-tu̱ naku̱n ryab-su̱ u-Ru̱. Tu̱msu̱ be-du̱ bo̱r-tu̱ zatte̱ da, ne̱t za u̱t-shu̱'u̱t wa-ko̱b-du̱ kab-du̱ rem-su̱ u-bo̱r da. ");
INSERT INTO gel_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Remu̱ iya, este̱du̱ u̱s-rem haan u̱ remu̱ yadu̱ jab. Ru̱-u̱ no̱ngu̱ in o̱ u̱ka m-ho̱s, u̱du̱ ne̱t-tu̱ o̱ u-me̱ ko̱-u̱r Ibrahi, za ne̱t-tu̱ na yaase̱ ne̱ u-bo̱r u̱ war-e̱ da, se̱di u̱r-kot u̱ i o̱tte̱ yadu̱ jab u̱ka Ibrahi. Wu̱na o̱ u-u̱so u̱ i ya jab be̱e̱t u̱du̱ este̱du̱ u̱s-rem su̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Rem-su̱ Ru̱-u̱ waru̱g u̱zu̱, <<Ibrahi, u̱m wa'ag bo̱, bo̱ shu̱'u̱t u̱so-u rem-tu̱ u-dak u-tát.>> Ru̱-u̱ no̱ng iya remu̱ zu̱ Ibrahi yaag jab u̱du̱ u-Ru̱ u̱zu̱ wa o̱tte̱ be̱b-du̱ yadu̱ u̱r-fat u̱du̱ wu̱ mare̱, tu̱msu̱ wu̱ nome̱ no̱m-u̱t po-to̱ u̱-me̱ no̱m-tu̱ za o̱ko̱n da. ");
INSERT INTO gel_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ko̱ ba shu̱'u̱te̱ u̱zu̱ Ibrahi zatte̱ o̱ko̱n u̱ wa do̱te̱ wadu̱ jab da, se̱di wa re̱e̱g shu̱ u̱ yadu̱ jab ne̱ u̱zu̱ wa de̱ shu̱'u̱te̱ u̱so-u̱ u̱t-dak u-tát, u̱ka Ru̱-u̱ zu̱tte̱ wa u̱zu̱, <<Iya o̱ ya'ag-u̱ ró do̱te̱ u̱t-shu̱'u̱t.>> ");
INSERT INTO gel_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ibrahi yakke̱ u̱ yadu̱ jab-u̱ wa u̱ mar da, ko̱ ba shu̱'u̱te̱ u̱zu̱ wa no̱ng u̱s-hak u̱t-shik u̱t-tan, tu̱msu̱ ne̱ta wa Saratu aru̱kte̱ da-u̱ u̱r-mat. ");
INSERT INTO gel_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Se̱di wa no̱ng u-sakna u̱ jab remu̱ este̱du̱ u̱s-rem su̱ Ru̱-u̱ no̱me̱ da, se̱di wa swu̱ru̱g yadu̱ jab, tu̱msu̱ wa no̱mu̱ u-Ru̱ m-sek. ");
INSERT INTO gel_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Ibrahi yaag jab, Ru̱-o̱ keru̱ no̱m-du̱ no̱mu̱ wa zu̱ wa u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Remu̱ yadu̱ jab Ibrahi, Ru̱-u̱ kabu̱g wa, <<wa-jab-u̱ so̱-o̱.>> ");
INSERT INTO gel_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","U̱ka na pu̱nte̱ u̱ Rem-su̱ u-Ru̱, <<Ru̱-u̱ kabu̱g wu̱n wa-jab-u̱ so̱-o̱.>> Tu̱msu̱ za remu̱ Ibrahi o̱ war-o̱ na pu̱nte̱ da. ");
INSERT INTO gel_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Se̱di na panu̱g rem-u̱s sin-se̱ remu̱ in, remu̱ zu̱ Ru̱-u̱ mutte̱ in a-jab-u̱s so̱-se̱, ne̱t be̱e̱t wu̱ ya' jab u̱du̱ wa, wu̱ yu̱nse̱ Ye̱so̱ Wa-ko-uyan in du̱gu̱ m-mar. ");
INSERT INTO gel_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Remu̱ ba'as-u̱t in, to̱ ne̱t-tu̱ hote̱ wa, tu̱msu̱ wa yu̱ne̱ du̱gu̱ m-mar remu̱ wa jaaste̱ ba'as-u̱t in. ");
INSERT INTO gel_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Ba shu̱'u̱te̱ u̱zu̱, Ru̱-u̱ jaaste̱ ba'as-u̱t in remu̱ yadu̱ jab u̱du̱ Ye̱so̱, in o̱tte̱ ru̱s-du̱ jab u-me̱ Wa-ko-uyan in Ye̱so̱ Kiristi. ");
INSERT INTO gel_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Remu̱ yadu̱ jab-u̱ in, Kiristi upuste̱ in ke̱rru̱ kwu̱m-du̱ nya-u̱ u-Ru̱ u̱ in o̱tte̱ u̱r-yu̱. Tu̱msu̱ in no̱ng u̱r-so̱ remu̱ wadu̱ jab-u̱ Ru̱-u̱ de̱ ko̱su̱ in fu̱'u̱bse̱-tu̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Tu̱msu̱ in no̱mo̱n u̱r-so̱ da-u̱ ne̱t-tu̱ o̱ yadu̱ in u̱r-ko̱b remu̱ yadu̱ jab-u̱ in u̱du̱ Kiristi, remu̱ zu̱ in nak u̱zu̱ swadu̱ u̱r-ko̱b u̱ in do̱'e̱ naknu̱ in gag-du̱ jab. ");
INSERT INTO gel_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","A ne̱t-u̱ shu̱'u̱te̱ wa gag-du̱ jab, Ru̱-u̱ de̱ muutu̱ wa ne̱t-u̱ u̱r-ka. Tu̱msu̱ a ne̱t-u̱ shu̱'u̱te̱ ne̱t-u̱ u̱r-ka, wa de̱ shu̱'u̱tu̱ wa wadu̱ jab u̱du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Wadu̱ jab za yadu̱ bo̱ m-'e̱ da ko̱ cashi, remu̱ zu̱ Ru̱-u̱ ko̱ske̱ in cwan-u̱t u̱ wa sok. Wa yaag in Yar-u wa, u̱-me̱ jab-u̱s in. ");
INSERT INTO gel_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Da-u̱ in za keru̱ u̱kru̱ hi-u̱r in da, regne̱ ho̱n-ho̱n da-u̱ Kiristi mare̱ remu̱ ba'as-u̱t in. ");
INSERT INTO gel_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","U̱t-po̱ ne̱ na kum-u̱t waku̱n wu̱ de̱ m-mar remu̱ waku̱n wa-jab-u̱ so̱-o̱, jiya na u̱t-kere̱ kwu̱m-du̱ ne̱t wu̱ de̱ u̱t-mar remu̱ ne̱t-u̱ o̱ no̱m-du̱ no̱m-u̱t so̱-to̱. ");
INSERT INTO gel_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Se̱di Ru̱-u̱ ko̱ske̱ in cwan-u̱t wa, u̱ wa to̱mto̱n in Kiristi wa mu̱r u̱ remu̱ in, da-u̱ in o̱o̱ge̱ a-u̱t-ba'as-ne̱. ");
INSERT INTO gel_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Ru̱-u̱ jaaste̱ ba'as-u̱t in remu̱ hyu̱-m Kiristi, za u-sakna, wa de̱ hen u̱ u̱kru̱ in du̱gu̱ ryab-su̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Da-u̱ in o̱o̱ge̱ m-ra u-Ru̱ ne̱, Ru̱-u̱ ho̱ngu̱ssu̱ in u̱ wa ne̱ remu̱ mar-mu̱ Wa'-u̱ wa. In nak u̱zu̱ Ye̱so̱ u̱ keru̱ u̱kru̱ in, tu̱msu̱ remu̱ zu̱ wa o̱ u̱r-fat. ");
INSERT INTO gel_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Maag u̱ku̱n da, in do̱'e̱ no̱m-du̱ u̱r-so̱ remu̱ mar-mu̱ Wa-ko-uyan Ye̱so̱ Kiristi no̱me̱ wa samge̱ in u-Ru̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","U̱ka ba'as-tu̱ cwatu̱n u̱-me̱ u-dak du̱gu̱-du̱ ne̱t gan, mar-mu̱ cwaan remu̱ zu̱ ne̱t-ne̱ be̱e̱t no̱ng u̱t-ba'as. Tu̱msu̱ mar-mu̱ haan u̱du̱ u̱t-ne̱t u̱t-be̱e̱t, remu̱ ba'as-tu̱ Adamu no̱me̱. ");
INSERT INTO gel_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Kanda na hattu̱n bo̱r-tu̱ Ru̱-u̱ yase̱ Mosa, ne̱t-tu̱ o̱ no̱m-du̱ u̱t-ba'as. Se̱di na kabu̱g se̱ u̱ka u̱t-ba'as da, remu̱ zu̱ bo̱r-tu̱ zaar tu̱ ne̱t de̱ u̱t-pas da. ");
INSERT INTO gel_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ko̱ ba shu̱'u̱te̱ iya, mar-mu̱ takku̱n du̱gu̱ da-u̱ Adamu u̱ haan u̱ da-u̱ Mosa, tu̱msu̱ u̱ i no̱me̱ ne̱ u̱t-ba'as remu̱ pas-du̱ u-bo̱r da u̱ka Adamu nomte̱. Adamu tu̱msu̱ wa o̱o̱ge̱ ryu̱n-u̱ wu̱ de'e̱ haan. ");
INSERT INTO gel_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Se̱di hastu̱ ba'as-u̱t in tu̱ Ru̱-u̱ no̱me̱ o̱ u̱ka m-ho̱s u̱du̱ in, za u̱ka ba'as-u̱t Adamu da. Remu̱ zu̱ ba'as-u̱t wa-gan nakku̱n mar-mu̱ u̱t-ne̱t u-tát. Se̱di nya-u̱ u-Ru̱ o̱ u-tát, remu̱ ho̱s-mu̱ wa no̱me̱ u̱-me̱ ne̱t gan u̱ wa, Ye̱so̱ Kiristi hattu̱n nya-u̱ u-Ru̱ u̱du̱ u̱t-ne̱t u-tát. ");
INSERT INTO gel_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Tu̱msu̱, nya-u u-Ru̱ ganse̱ o̱o̱ge̱ u̱ ba'as-u̱t Adamu ne̱ da. U̱m zu̱u̱g iya remu̱ ba'as-u̱t to̱ tu̱ Adamu no̱me̱ to̱ nakku̱n kwu̱p-du̱ u̱s-rem su̱ u-Ru̱ u̱du̱ ne̱t-tu̱ u-dak u̱t-be̱e̱t. Se̱di nya-u u-Ru̱ muute̱ in za u̱t-ba'as ko̱ ba in no̱me̱ u̱t-ba'as u-tát. ");
INSERT INTO gel_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Mar-m no̱mo̱g u̱r-faru̱k u̱-me̱ u̱t-ne̱t remu̱ ba'as-tu̱ ne̱t gan, Adamu. Se̱di m-ze̱g iya, Ye̱so̱ Kiristi samge̱ in u-Ru̱ ne̱. Ru̱-u̱ yaag in wa u̱ka m-ho̱s u-tát, tu̱msu̱ i kabe̱ wa, e̱ de̱ re̱-du̱ be̱b-du̱ u̱t-ba'as m-mar ne̱ u̱-me̱ Ye̱so̱ Kiristi. ");
INSERT INTO gel_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Remu̱ ba'as-tu̱ wa u-gan no̱me̱, to̱ haatu̱n ne̱t-ne̱ be̱e̱t swadu̱ u̱r-ko̱b, tu̱msu̱ iya-o̱ hen no̱m-u̱ u-gan u̱ Kiristi no̱me̱, o̱ haatu̱n u-u̱ku̱r u̱-me̱ ko̱wan, u̱ka Ru̱-u̱ do̱te̱ yadu̱ ne̱t-ne̱ fat-du̱ za u̱r-ma. ");
INSERT INTO gel_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Remu̱ ba'as-u̱t ne̱t gan no̱me̱, de̱ wu̱te̱ ne̱t-ne̱ be̱e̱t e̱ shu̱'u̱te̱ a-u̱t-ba'as-ne̱. Iya-o̱ hen tu̱msu̱ remu̱ jab-u̱ so̱-o̱ u̱ ne̱t gan no̱me̱, ne̱t-ne̱ u-tát e̱ de̱ u̱t-shu̱'u̱t a-jab-u̱s so̱-se̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Ru̱-u̱ ya'aste̱ bo̱r-u̱t wa u̱du̱ Mosa remu̱ ne̱t-tu̱ hyen-u̱t ba'as-u̱t e̱ m-zu̱n. Se̱di da-u̱ ba'as-tu̱ sure̱ u-tát, nya-u̱ u-Ru̱ zeg u-tát sok. ");
INSERT INTO gel_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","U̱ka ba'as-tu̱ nomte̱ u̱r-faru̱k u̱-me̱ u̱t-ne̱t u̱t-be̱e̱t tu̱msu̱ hatu̱n u̱n m-mar, iya o̱ hen nya-u̱ u-Ru̱ do̱te̱ no̱m-du̱ u̱r-faru̱k remu̱ jab-u̱ so̱-o̱, u̱ de̱ hatu̱n fat-du̱ za u̱r-ma remu̱ Ye̱so̱ Kiristi Wa-ko-uyan in. ");
INSERT INTO gel_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","¿Yan-o̱ in do̱'e̱ u̱t-zu̱? ¿In de̱e̱n u̱ re-du̱ shu̱ u̱ no̱m-du̱ u̱t-ba'as remu̱ wa jaaste̱ ba'as-u̱t in tu̱msu̱ wa swu̱ru̱ in u-nya? ");
INSERT INTO gel_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Za u̱t-no̱me̱ iya da! A in kabe̱ Ye̱so̱, no̱m-tu̱ wadu̱ in u̱ yu̱-du̱ u̱t-ba'as to̱ maru̱g, ¿re̱ do̱te̱ u̱t-no̱m in ha u̱r-yu̱ u-me̱ u̱t-ba'as? ");
INSERT INTO gel_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","4","U̱ka na no̱m-tu̱ in u̱t-yu̱bu̱sse̱ m-bu̱, in maru̱g tu̱msu̱ na dok in u̱ Kiristi ne̱ u̱ka wa mu̱rte̱ tu̱msu̱ na dok wa. Na no̱ngu̱ in u̱t-yu̱bu̱sse̱ m-bu̱ remu̱ in nom-u̱t yu̱-u̱r po-de̱ u̱ka u̱s-gan, u̱ka Ye̱so̱ yu̱nte̱ du̱gu̱ m-mar, u̱-me̱ fu̱'u̱bse̱-tu̱ u-Ru̱ Uso-u in. Iya o̱ in kumte̱ fat-u̱r po-de̱. ");
INSERT INTO gel_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Ba in shu̱'u̱te̱ u̱s-gan u̱ Kiristi ne̱ remu̱ mar-m Kiristi, iya o̱ hen in do̱te̱ u̱t-shu̱'u̱t u̱s-gan u̱ yu̱ne̱-u̱r wa u̱r-fat u̱ka wa yu̱nte̱. ");
INSERT INTO gel_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","U̱ka in nu̱pte̱ u̱zu̱ na taru̱g yu̱-du̱ u̱t-ba'as u̱ in u̱-do̱m u-kan da-u̱ na tare̱ Ye̱so̱ u̱-do̱m u-kan, taas u̱ ba'as-tu̱ kum-u̱t u̱r-be̱b u̱ jab-u̱s in da. Na no̱mo̱g sin-se̱ u̱s-be̱e̱t taas in shu̱'u̱t to̱k-ne̱ i u̱t-ba'as da. ");
INSERT INTO gel_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","In nak u̱zu̱ ba'as-tu̱ zatte̱ u̱r-faru̱k u̱ do̱m-u̱ ne̱t-tu̱ mare̱ da. ");
INSERT INTO gel_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ba shu̱'u̱te̱ u̱zu̱ in maru̱g u̱ Kiristi ne̱, in o̱ yadu̱ jab u̱zu̱ in do̱'e̱ u̱r-fat u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","In nakku̱n u̱zu̱ Ru̱-u̱ yu̱nste̱ Kiristi du̱gu̱ m-mar, tu̱msu̱ wa zamu̱n u̱t-swu̱r m-mar da. Mar-mu̱ zatte̱ u̱r-be̱b u̱du̱ Ye̱so̱ da. ");
INSERT INTO gel_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Remu̱ mar-mu̱ wa mare̱, ba'as-tu̱ zatte̱ u̱r-be̱b u̱-me̱ wu̱n da, tu̱msu̱ u̱ da-o̱ wa o̱ yu̱-du̱ no̱mu̱ u-Ru̱ u̱t-fu̱'u̱bse̱. ");
INSERT INTO gel_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Remu̱ iya hen, kab hi-u̱r ró u̱ka wu̱ mare̱ taas u̱ ba'as-tu̱ dor-u̱t wa da, se̱di bo̱ kab hi-u̱r ró wa u̱r-fat u̱du̱ u-Ru̱ u̱-me̱ Kiristi Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Remu̱ iya, a no̱ yage̱ u̱ ba'as-tu̱ no̱m u̱r-faru̱k u̱-me̱ war-u̱t no̱ tu̱ de̱ m-mar da, taas no̱ do̱r zwarru̱ no̱m-u̱ war-u̱t no̱ o̱ u̱t-sa da. ");
INSERT INTO gel_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","A no̱ yase̱ o̱g-tu̱ war-u no̱ to̱ to̱ shu̱'u̱t cwu̱-tu̱ no̱m-du̱ u̱t-ba'as da. Se̱di no̱ yase̱ hi-u̱r no̱ u̱du̱ u-Ru̱, remu̱ zu̱ no̱ o̱gu̱ maru̱g se̱di u̱ da-o̱ no̱ o̱tte̱ fat-u̱r po-de̱. Remu̱ iya yaase̱ war-u no̱ u̱ shu̱'u̱t u̱ka cwu̱-tu̱ m-ank u̱ no̱m-du̱ no̱m-u̱t so̱-to̱ remu̱ fu̱'u̱bse̱-tu̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","A no̱ yage̱ u̱ ba'as-tu̱ no̱m u̱r-faru̱k u̱-me̱ no̱ da, remu̱ zu̱ bo̱r-tu̱ zatte̱ u̱r-be̱b u̱-me̱ no̱ da. Se̱di, no̱mo̱n u̱r-yu̱ u̱-me̱ shin-mu̱ nya-u̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Ba shu̱'u̱te̱ u̱zu̱ nya-u u-Ru̱ u̱ku̱rte̱ in du̱gu̱ u̱t-bo̱r, ¿u̱t-shu̱'u̱t u̱zu̱ na re̱ shu̱ u̱ no̱m-du̱ u̱t-ba'as ne̱? O'o! Ko̱ ca! ");
INSERT INTO gel_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","¿No̱ nak u̱zu̱ a no̱ yaase̱ hi-u̱r no̱ u̱du̱ waku̱n u̱ka to̱k-ne̱ nomte̱ m-to̱k, no̱ shu̱'u̱te̱ to̱k-u̱ wa, remu̱ zu̱ no̱ o̱ do̱rru̱ wa da? No̱ keru̱ shu̱'u̱tu̱ to̱k-ne̱ u̱t-ba'as tu̱ hu̱u̱tu̱ ne̱t-ne̱ u̱du̱ m-mar, ko̱ no̱ keru̱ do̱rru̱ Rem-su̱ u-Ru̱ su̱ de̱ wadu̱ ne̱t u̱ yu̱-du̱ jab-u̱ so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Se̱di u̱t-vam u̱du̱ u-Ru̱, remu̱ u̱r-taku̱n no̱ o̱o̱g m-to̱k u̱-me̱ u̱t-ba'as, se̱di u̱ da-o̱ no̱ kabu̱g ko̱se̱-tu̱ it no̱mu̱ no̱ jab gan. ");
INSERT INTO gel_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Ru̱-u̱ ruute̱ no̱ du̱gu̱ to̱k-mu̱ u̱t-ba'as, no̱ shu̱'u̱te̱ to̱k-ne̱ u̱ no̱m-du̱ yu̱-du̱ jab-u̱s so̱-se̱. ");
INSERT INTO gel_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","U̱m ko̱sku̱ no̱ sha-mu̱ u̱s-rem mu̱ to̱k remu̱ no̱ gotu̱ u̱r-nu, remu̱ jab-u̱ u̱r-ma ne̱t. U̱r-taku̱n no̱ o̱o̱gu̱ yasu̱ o̱g-tu̱ war-u̱t no̱ u̱ no̱m-du̱ no̱m-tu̱ za u-he̱n tu̱msu̱ u̱ swu̱rru̱ no̱m-u̱t yo̱-to̱. Remu̱ iya u̱ da-o̱, yasu̱n o̱g-tu̱ war-u̱t no̱ remu̱ no̱ no̱m-u̱t yu̱-du̱ jab-u̱s so̱-se̱ u̱ no̱ shu̱'u̱te̱ u-he̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","U̱ da-u̱ dim, no̱ o̱o̱g to̱k-ne̱ u̱t-ba'as, waku̱n wa'ag no̱ u̱ no̱m-du̱ no̱m-u̱t so̱-to̱ u̱r-be̱b da. ");
INSERT INTO gel_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","U̱ da-u̱ dim no̱ no̱mo̱g no̱m-tu̱ no̱ ho̱g-du̱ e̱'-mu̱ no̱m-du̱ to̱ u̱ da-o̱. ¿Yan to̱p-o̱ no̱ kume̱ remu̱ no̱m-du̱ no̱m-u̱t to̱? To̱p-u̱ no̱m-u̱t to̱ mar-mo̱. ");
INSERT INTO gel_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Se̱di u̱ da-o̱, Ru̱-u̱ rwu̱ru̱g no̱ du̱gu̱ u̱t-ba'as, no̱ shu̱'u̱te̱ to̱k-ne̱ u-Ru̱. Nya-u u-Ru̱ u̱ no̱ de̱ u̱t-kwu̱m o̱ jab u-he̱n, tu̱msu̱ no̱ de̱ kwu̱m-du̱ fat-du̱ za u̱r-ma. ");
INSERT INTO gel_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","To̱p-u̱ u̱t-ba'as mar-mo̱, se̱di nya-u u-Ru̱ fat-du̱ za u̱r-ma du̱ u̱-me̱ Ye̱so̱ Kiristi Wa-ko-uyan in. ");
INSERT INTO gel_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","O̱r-u̱t ri ne̱, no̱ nak u̱ka bo̱r-tu̱ o̱tte̱, no̱ nu̱pu̱ste̱ no̱m-u̱ u̱m de̱ u̱t-war, bo̱r-tu̱ nom u̱r-faru̱k u̱-do̱m ne̱t-u̱ o̱ u̱r-fat u̱ war-to̱. ");
INSERT INTO gel_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","A in gwate̱ ne̱ta u̱r-gu̱, wa o̱ m-shu̱p u̱ bo̱r-tu̱ u̱r-gu̱ ne̱, da-u̱ campa wa o̱ u̱r-fat. Se̱di da-u̱ campa wa mare̱, wa rwu̱u̱g u̱ bo̱r-tu̱ u̱r-gu̱. ");
INSERT INTO gel_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Remu̱ iya a wa ga waku̱n campa wa, u̱ campa wa ne̱ u̱r-fat, na zu̱ wa wa-u-as. Se̱di a campa wa mare̱, wa rwu̱u̱g u̱-me̱ ho-yu̱ u̱r-gu̱, a ne̱ta-u ya ga waku̱n, wa no̱ng m-o̱ da remu̱ zu̱ campa wa maru̱g. ");
INSERT INTO gel_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Remu̱ iya no̱ o̱ o̱r-u̱t ri ne̱, mar-m Kiristi u̱-do̱m u-kan o̱ wa'ag no̱ shu̱'u̱te̱ marimari-ne̱ u̱du̱ u-bo̱r. Iya no̱ shu̱'u̱te̱ u̱s-gan, u̱ wu̱ yu̱ne̱ du̱gu̱ m-mar ne̱ remu̱ in no̱m-tu̱ u-Ru̱ u̱s-pama. ");
INSERT INTO gel_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Da-u̱ in o̱ shu̱'u̱t u̱-me̱ yu̱-du̱ u̱t-ba'as tu̱ o̱ u̱r-yu̱ u̱-me̱ in, ko̱se̱-tu̱ u-bo̱r to̱ yu̱nstu̱n dorog-su̱ no̱m-u̱t yo̱-to̱ tu̱ haatu̱n in m-mar. ");
INSERT INTO gel_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Se̱di u̱ da-o̱ in kwu̱ng u-u̱ku̱r, Ru̱-u̱ rwu̱ru̱g in du̱gu̱ u̱t-bo̱r. U̱ da-o̱ hen in o̱ do̱rru̱ u-Ru̱ u̱ fu̱n-yu̱ fat-u̱r po-de̱ yu̱ Yar-u wa. Fu̱n-yu̱ u-ut yu̱ na pane̱ u̱-me̱ u̱t-bo̱r in dor-u̱t ya da. ");
INSERT INTO gel_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","E̱ke̱n o̱ro i o̱ u̱t-zu̱, <<Bo̱r-tu̱ Ru̱-u̱ yase̱ Mosa o̱ yo̱-to̱.>> E̱ o̱ u̱t-zu̱ nap-mu̱ u̱t-bo̱r wa'ag in u̱ no̱m-du̱ u̱t-ba'as u-tát, se̱di no̱ng u̱r-zwar e̱ no̱m u̱s-dorog iya da. Bo̱r-tu̱ u-Ru̱ to̱ ko̱su̱ me̱ ba'as-u̱t ri. U̱m za nak u̱zu̱ shu̱b-du̱ no̱m-u waku̱n ba'as-to̱ da, se̱ da-u̱ bo̱r-tu̱ zu̱, <<A-bo̱ wa u̱r-is u̱ no̱m-u waku̱n da.>> ");
INSERT INTO gel_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Se̱di remu̱ bo̱r-tu̱ u-Ru̱ to̱, de̱ wu̱te̱ ba'as-tu̱ kum-u̱t u̱r-ke̱r to̱ yu̱nsu̱n ko̱-uyan go̱-du̱ dorog-su̱ wadu̱ u̱r-is u̱ no̱m-u waku̱n u̱-me̱ jab-u̱ ri. U̱zu̱ bo̱r-tu̱ o̱ro da, ba'as-tu̱ za o̱tte̱ u̱r-be̱b da. ");
INSERT INTO gel_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","U̱ da-u̱ dim kanda u̱m nap no̱m-u̱ bo̱r-tu̱ u̱t-sa, u̱m o̱o̱g u̱ e̱kse̱ hi-u̱r ri u̱ no̱m-tu̱ u̱m o̱ u̱t-no̱m da. Se̱di da-u̱ u̱m nape̱ ko̱se̱-tu̱ bo̱r-tu̱ u-Ru̱, za rem u̱m nu̱p u̱zu̱ u̱m o̱ no̱m-du̱ u̱t-ba'as. ");
INSERT INTO gel_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Se̱ u̱m mu̱r, bo̱r-tu̱ kame̱ u̱zu̱ to̱ hatu̱n u̱r-fat, to̱ hatu̱n m-mar mu̱ mo̱te̱ me̱ du̱gu̱-du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Ba'as-tu̱ kwu̱ng u̱r-ke̱r, to̱ paru̱g me̱ to̱ wu̱ me̱ u̱s-dorog u̱zu̱ me̱ keru̱ no̱m-du̱ u̱t-ba'as tu̱msu̱ u̱m do̱r u̱t-bo̱r u-da u-gan u̱ka u̱m do̱te̱ kwu̱m-du̱ fat-du̱ za u̱r-ma, se̱di o̱ mo̱k-u̱t du̱gu̱-du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Ko̱ ba shu̱'u̱te̱ iya, bo̱r-u̱t u-Ru̱ to̱ o̱ u-he̱n ne̱ tu̱msu̱ no̱m-tu̱ Ru̱-u̱ zu̱ na no̱m ne̱ to̱ o̱ u-he̱n ne̱ tu̱ jab-u̱ so̱-o̱, tu̱msu̱ tu̱ so̱-to̱ sok. ");
INSERT INTO gel_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","¿Se̱di yan-o̱ in do̱'e̱ u̱t-zu̱, bo̱r-tu̱ u-Ru̱ o̱ so̱-to̱ tu̱msu̱ to̱ hatu̱n in m-mar? Iya o̱ da ko̱ cashi! Ba'as-to̱ hatu̱n me̱ m-mar. Ba'as-tu̱ do̱ro̱g dim-u̱ bo̱r-u̱t so̱-to̱, to̱ hatu̱n me̱ m-mar. No̱ hyanu̱g u̱ka ba'as-tu̱ o̱tte̱ yo̱-to̱. To̱ do̱ro̱g bo̱r-u̱t so̱-to̱ tu̱ u-Ru̱ remu̱ no̱m-du̱ no̱m-u̱t yo̱-to̱. ");
INSERT INTO gel_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","In nak u̱zu̱ bo̱r-tu̱ Ru̱-u̱ yase̱ Mosa, du̱gu̱ Yar-u u-Ru̱ o̱ rwu̱ne̱. Se̱di me̱ ne̱t-wa, tu̱msu̱ to̱k u̱-me̱ u̱t-ba'as. ");
INSERT INTO gel_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","U̱m nak no̱m-u̱ u̱m de̱ u̱t-no̱m da. Remu̱ zu̱ no̱m-u̱ u̱m u̱t-sa u̱t-no̱m, u̱m nom-u̱t o̱ da, no̱m-u̱ u̱m gu̱gme̱ o̱ u̱m o̱ u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Abite̱ no̱m-u̱ u̱m o̱ u̱t-no̱m, o̱ u̱m u̱t-sa u̱t-no̱m da, u̱m kabu̱g u̱zu̱ bo̱r-tu̱ u-Ru̱ to̱ o̱ ho̱n-ho̱n. ");
INSERT INTO gel_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Me̱ wa u̱ hi-u̱r ri u̱ no̱m-du̱ no̱m-u̱t yo̱-to̱ da, se̱di ba'as-tu̱ o̱ me̱n-tu̱ jab-u̱ ri. ");
INSERT INTO gel_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","U̱m nak u̱zu̱ o̱ko̱n za u̱ so̱-o̱ u̱ o̱ u̱-me̱ jab-u̱ ri u̱r-ma ne̱t da, se̱di ba'as-to̱ o̱ u̱-me̱ jab-u̱ ri. U̱m zu̱u̱g iya remu̱ zu̱ u̱m cwanu̱g u̱zu̱ u̱m no̱mo̱g no̱m-u̱t so̱-to̱, se̱di u̱m kerte̱ u̱t-no̱m da. ");
INSERT INTO gel_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","U̱m wa'ag jab u̱m no̱m no̱m-u̱t so̱-to̱, se̱di u̱m o̱ no̱m-du̱ no̱m-u̱t yo̱-to̱ tu̱ u̱m za cwan-tu̱ u̱t-no̱m da. ");
INSERT INTO gel_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","A u̱m no̱me̱ no̱m-u̱ u̱m za u̱ssa u̱t-no̱m da, ko̱ske̱ u̱zu̱ me̱ wa o̱ no̱m-du̱ no̱m-u̱t yo̱-to̱ to̱ da, se̱di ba'as-tu̱ o̱ u̱-me̱ jab-u̱ ri. ");
INSERT INTO gel_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","U̱m hyanu̱g u̱zu̱, no̱m-u̱ u̱m nome̱ ko-uyan da-o̱; a u̱m u̱t-sa no̱m-du̱ no̱m-u so̱-o̱, u̱m hyen no̱m-u̱t yo̱-to̱ u̱r-kot u̱-me̱ ne̱ remu̱ o̱ hooste̱ me̱ no̱m-du̱ no̱m-u so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Du̱gu̱ me̱n-tu̱ jab-u̱ ri, u̱m o̱ cwan-tu̱ bo̱r-tu̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Se̱di u̱ war-u ri u̱m o̱ hyan-du̱ o̱ko̱n u̱ o̱ m-gag u̱-me̱ jab-u̱ ri. O̱ dor-tu̱ me̱, tu̱msu̱ o̱ muutu̱ me̱ to̱k u̱t-ba'as. ");
INSERT INTO gel_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","No̱m-tu̱ u̱r-o̱n to̱ u̱m o̱ye̱! Wana de̱ u̱kru̱ me̱ du̱gu̱ no̱m-u̱ war-u ri u̱t-sa, taas u̱ mo̱t me̱ du̱gu̱-du̱ u-Ru̱? ");
INSERT INTO gel_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","U̱t-vam u̱du̱ u-Ru̱ u̱-me̱ Ye̱so̱ Kiristi Wa-ko-uyan in! Se̱di u̱ka u̱m ku̱bte̱ iya, u̱-me̱ dorog-u̱s ri u̱m u̱t-sa u̱m do̱r no̱m-tu̱ bo̱r-tu̱ zu̱ na no̱m, se̱di war-u o̱ wadu̱ me̱ u̱m shu̱'u̱t u̱ka to̱k u̱t-ba'as. ");
INSERT INTO gel_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Remu̱ iya u̱ da-o̱, kwu̱p-du̱ u̱s-rem su̱ m-mar zamu̱n da, u̱du̱ i o̱ u̱-me̱ Kiristi Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Remu̱ bo̱r-tu̱ u-yar, tu̱ mu̱u̱tu̱n in u̱r-fat u̱ same̱-du̱ u̱t-hi u̱ Kiristi Ye̱so̱ ne̱, to̱ ruute̱ me̱ du̱gu̱-du̱ bo̱r-tu̱ u̱t-baas, u̱ m-mar ne̱. ");
INSERT INTO gel_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","No̱m-u̱ bo̱r-u̱t Mosa kere̱ u̱t-no̱m da remu̱ jab u̱r-ma ne̱t, Ru̱-u̱ no̱mo̱g o̱. Ru̱-u̱ to̱mgo̱n Wa'-u̱ wa u̱ war-u̱ m-ma-ne̱t remu̱ wa shu̱'u̱te̱ u̱r-to̱o̱g remu̱ u̱t-ba'as, tu̱msu̱ wa haste̱ be̱b-du̱ u̱t-ba'as du̱gu̱ war-u̱t in. ");
INSERT INTO gel_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ru̱-u̱ no̱ng iya, remu̱ in no̱m-u̱t no̱m-tu̱ bo̱r-tu̱ zu̱ na nom. In no̱ng iya da-u̱ Yar-u̱ u-Ru̱ o̱ dor-tu̱ in, za m-ma-ne̱t du̱ dor-u̱t in da. ");
INSERT INTO gel_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Ne̱t-tu̱ o̱ u̱r-yu̱ u̱ka dorog-su̱ jab-u̱s e̱ ko̱ste̱ e̱, jab-u̱s e̱ shu̱'u̱t u̱ shi u̱ no̱m-tu̱ dorog-su̱ u̱r-ma ne̱t u̱t-sa. Se̱di i Yar-u u-Ru̱ o̱ dor-tu̱ e̱, e̱ nom dorog-su̱ no̱m-u̱ Yar-u u-Ru̱ u̱t-sa. ");
INSERT INTO gel_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Yagu̱ jab-u̱s no̱ u̱ no̱m-du̱ u̱t-ba'as haatu̱n m-mar, se̱di wadu̱ jab-u̱ no̱ u̱ no̱m-tu̱ Yar-u̱ u-Ru̱ haatu̱n u̱r-fat u̱ ru̱s-du̱ jab ne̱. ");
INSERT INTO gel_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Kowan wu̱ muute̱ jab-u̱ wa u̱ dorog-su̱ u̱r-ma ne̱t, wa shu̱'u̱tu̱ hu̱u̱b-u̱ yo̱-o̱ u-Ru̱ ne̱. U̱m zu̱u̱g iya remu̱ zu̱ wa do̱ro̱g bo̱r-tu̱ u-Ru̱ da, tu̱msu̱ wa u̱t-kere̱ u̱t-do̱r da. ");
INSERT INTO gel_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ne̱t-tu̱ o̱ dorog-su̱ u̱r-ma ne̱t, Ru̱-u̱ za ho̱g-du̱ zwarru̱ go̱-du̱ ne̱t-u̱t to̱ da. ");
INSERT INTO gel_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Se̱di a in yage̱ dorog-su̱ u̱r-ma ne̱t u̱ dor-u̱t in da. Yagu̱n u̱ Yar-u u-Ru̱ o̱ dor-u̱t in, remu̱ zu̱ wa o̱ u̱r-yu̱ u̱-me̱ in. Ne̱t-tu̱ zatte̱ Yar-u̱ rwu̱ne̱ u̱du̱ Kiristi da, Kiristi nak wa da. ");
INSERT INTO gel_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","A regne̱ Kiristi o̱ u̱r-shu̱'u̱t u̱-me̱ no̱, ko̱ da war-u̱t no̱ maru̱g remu̱ u̱t-ba'as, Yar-u u-Ru̱ de̱ ya' no̱ u̱r-fat remu̱ zu̱ Ru̱-u̱ kabu̱g no̱ a-jab-u̱s so̱-se̱. ");
INSERT INTO gel_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Yar-u u-Ru̱, u̱ yu̱nse̱ Ye̱so̱ du̱gu̱ m-mar, o̱ u̱-me̱ jab-u̱s no̱. U̱ka Ru̱-u̱ yu̱nste̱ Kiristi du̱gu̱ m-mar, wa de̱ yadu̱ no̱ u̱r-fat u̱ war-u̱t no̱ tu̱ m-mar remu̱ Yar-u wa u̱ o̱ u̱-me̱ no̱. ");
INSERT INTO gel_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Remu̱ iya, hu̱u̱b-u̱t ri ne̱, in o̱tte̱ no̱m-u̱ u̱t-no̱m, se̱di za u̱ka dorog-su̱ no̱m-tu̱ m-ma-ne̱t du̱ u̱t-sa da. ");
INSERT INTO gel_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","A-bo̱ o̱ u̱r-yu̱ u̱ka m-ma-ne̱t du̱ o̱tte̱ u̱ssa, no̱ do̱'e̱ m-mar. Se̱di abite̱ no̱ o̱ do̱rru̱ no̱m-u̱ Yar-u u-Ru̱ u̱t-sa, tu̱msu̱ no̱ yage̱ u̱t-ba'as, no̱ de̱ kwu̱m-du̱ u̱r-fat. ");
INSERT INTO gel_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Remu̱ zu̱ i Yar-u u-Ru̱ o̱ dor-tu̱ e̱, e̱ o̱ yaag u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","No̱ kwu̱mu̱g Yar-u de̱ muutu̱ no̱ to̱k-ne̱ da, remu̱ iya a no̱ shu̱'u̱t u̱ ho̱g-du̱ u-gye̱r da. Se̱di Yar-u o̱ de̱ u̱t-wa in shu̱'u̱t yaag u-Ru̱, u̱ remu̱ shin-mu̱ Yar-u o̱ in do̱'e̱ fag-du̱ u-Ru̱, <<Baba! U-u̱so in!>> ");
INSERT INTO gel_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Yar-u u-Ru̱ u̱ yar-u in ne̱ o̱ waru̱ in u̱zu̱ yaag u-Ru̱ in o̱ye̱. ");
INSERT INTO gel_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ba shu̱'u̱te̱ u̱zu̱ yaag u-Ru̱ in o̱ye̱, shu̱'u̱te̱ u̱zu̱ a kwu̱m-tu̱ u-U̱so in o̱ye̱. In re̱e̱n kwu̱m-tu̱ u̱t-fu̱'u̱bse̱ tu̱ u-U̱so u̱r-kot u̱ Wa'-u̱ wa Kiristi ne̱. Se̱di a in kume̱ fu̱bu̱sse̱ tu̱ U̱so, ka u̱t-no̱m zarra, se̱ in swaag u̱r-ko̱b u̱r-kot u̱ Kiristi ne̱. ");
INSERT INTO gel_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","U̱m nak u̱zu̱, in za keru̱ ho̱ngu̱sse̱ fu̱'u̱bse̱-tu̱ Ru̱-u̱ de̱ yadu̱ in u̱ ko̱b-du̱ in o̱ u̱t-swa ne̱ u̱ da-o̱ da. ");
INSERT INTO gel_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","No̱m-u̱ Ru̱-u̱ no̱me̱ u-be̱e̱t du̱gu̱ taku̱n-du̱ u-dak, o̱ wadu̱ jab o̱ hyan da-u̱ Ru̱-u̱ de̱ ko̱se̱ ko̱ re̱ ya'ag-u̱ wa o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Remu̱ no̱m-tu̱ ba'as-tu̱ no̱me̱, no̱m-tu̱ Ru̱-u̱ no̱me̱ u̱t-be̱e̱t, e̱ kerge̱ no̱m-du̱ no̱m-u̱ Ru̱-u̱ cwane̱ e̱ no̱m da. Ru̱-u̱ wa'ag jab u̱zu̱ ");
INSERT INTO gel_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","no̱m-tu̱ wa no̱me̱ to̱ u̱t-kwu̱m u̱t-wu̱z du̱gu̱ m-to̱k u̱t-zu̱m ne̱. Wa o̱ wadu̱ jab e̱ de̱ kwu̱m-du̱ u̱t-fu̱'u̱bse̱ tu̱ na de̱ yadu̱ yaag u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","In nak u̱zu̱ no̱m-tu̱ Ru̱-u̱ no̱me̱ u̱t-be̱e̱t e̱ o̱ u̱r-e' u̱ haan u̱ uno̱ da-o̱ e̱ o̱ u̱s-eku̱s u̱ka ne̱ta o̱ ho̱g-du̱ re̱mu̱ u̱r-mat nomte̱. ");
INSERT INTO gel_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Za no̱mu̱ Ru̱-u̱ no̱me̱ o̱ u̱s-eku̱s u̱ war-o̱ da, u̱ in ne̱ be̱e̱t, in i Ru̱-u̱ no̱me̱ u-nya u̱ Yar-u̱ u-Ru̱ in o̱ u̱s-eku̱s u̱-me̱ jab-u̱s in. In o̱ u̱r-'e tu̱msu̱ u̱ wadu̱ jab ne̱ da-u̱ Ru̱-u̱ de̱ muutu̱ in ya'ag-u̱ wa, tu̱msu̱ wa guut war-u̱t in. ");
INSERT INTO gel_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Remu̱ wadu̱ jab, o̱ wu̱te̱ Ru̱-u̱ u̱ku̱rte̱ in. Se̱di wadu̱ jab-u̱ no̱m-u̱ no̱ hyane̱ wadu̱ jab de̱ da. Waku̱n za wadu̱ jab-u̱ no̱m-u̱ wa o̱tte̱ u̱t-kom da. ");
INSERT INTO gel_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Se̱di a in o̱ wadu̱ jab-u̱ no̱m-u̱ in zatte̱ da, ko̱ske̱ u̱zu̱ in o̱ u̱r-'e u̱ gag-du̱ jab ne̱. ");
INSERT INTO gel_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Iya o̱ hen Yar-u u-Ru̱ o̱tte̱ no̱mu̱ in u̱r-se̱ge̱ u̱ ko̱b-du̱ u̱r-be̱b u̱ in. In nak u̱ka no̱m-du̱ u̱s-to̱o̱g da, se̱di Yar-u̱ u-Ru̱ o̱ u̱s-to̱o̱g u̱ u̱t-shig ne̱ u̱du̱ u-Ru̱ remu̱ in u̱t-gom ne̱ tu̱ za u̱t-ware̱ da. ");
INSERT INTO gel_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ru̱-o̱ nape̱ jab u̱t-ne̱t be̱e̱t. Wa nu̱p u̱ka dorog-su̱ Yar-u̱ u-Ru̱ u̱ o̱ u̱s-to̱o̱g u̱ remu̱ ne̱t-u̱t wa. Da-u̱ Yar-u̱ u-Ru̱ no̱mu̱ in u̱s-to̱o̱g wa nak no̱m-u̱ Ru̱-u̱ u̱t-sa. ");
INSERT INTO gel_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","In nak u̱zu̱ u̱ te̱k-u̱ u̱t-no̱m u̱t-be̱e̱t Ru̱-u̱ o̱ no̱m-du̱ no̱m-u̱t so̱-to̱ u̱du̱ i o̱ cwan-u̱t wa ne̱. Wa nom iya u̱du̱ ne̱t-tu̱ wa dage̱ u̱ remu̱ e̱ nom-u̱t no̱m-tu̱ wa zo̱nge̱ e̱ no̱m. ");
INSERT INTO gel_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","I Ru̱-u̱ dage̱ du̱gu̱ u̱r-taku̱n wa dak wa tu̱n e̱ shu̱'u̱t sha-mu̱ wa'-u̱ wa, remu̱ wa-u̱ wa shu̱'u̱te̱ mat-du̱ u̱r-taku̱n u̱-me̱ ban-du̱ o̱r-u̱t wa ne̱. ");
INSERT INTO gel_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Remu̱ i Ru̱-u̱ dage̱, i wa bane̱. E̱ wa jaase̱ ba'as-u̱t e̱. Tu̱msu̱ in i Ru̱-u̱ jaase̱ ba'as-u̱t e̱, wa de̱ no̱mu̱ e̱ u̱t-fu̱'u̱bse̱. ");
INSERT INTO gel_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Gwatu̱n go̱-du̱ rem-u̱s sin-se̱, ¿Yan-to̱ in do̱'e̱ u̱t-zu̱? ¿A Ru̱-u̱ o̱ u̱r-kot u̱ in ne̱, wana de̱ m-gag u̱ in ne̱? ");
INSERT INTO gel_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Ru̱-u̱ hoostu̱ Wa'-u̱ wa m-mar u̱-do̱m u-kan remu̱ in da, se̱di wa ya'aste̱ in Wa'-u̱ wa, wa keru̱ no̱mu̱ in ho̱s-mu̱ ko̱-uyan. ");
INSERT INTO gel_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","¿Wana de̱ saku̱ i Ru̱-u̱ dage̱ u̱t-ba'as? Waku̱n zarra, remu̱ zu̱ Ru̱-u̱ muute̱ u̱n za u̱t-ba'as. ");
INSERT INTO gel_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","¿Wana de̱ kere̱ u̱t-kwu̱p u̱zu̱ na ho̱ in? Ko̱ ne̱t! Ye̱so̱ Kiristi maru̱g, wa yu̱ne̱ du̱gu̱ m-mar, u̱ da-o̱ wa o̱ shu̱'u̱t u̱ kom u̱s-cwa u-Ru̱. Wa o̱ u̱s-to̱o̱g u̱du̱ u-Ru̱ remu̱ in. ");
INSERT INTO gel_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Waku̱n zaar wu̱ de̱ u̱t-wa u̱ Kiristi yage̱ cwan-u̱t in da! Ko̱ u-taag, Ko̱ swa-u̱ u̱r-ko̱b, ko̱ u̱s-me̱r, ko̱ u̱r-so, ko̱ u-ra, u̱r-ho̱nse̱ ne̱, ko̱ m-mar, o̱ko̱n zaar u̱ de̱ hoosu̱ u-Ru̱ cwan-u̱t in da. ");
INSERT INTO gel_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","U̱ka Rem-su̱ u-Ru̱ zu̱tte̱, <<Remu̱ zu̱ it o̱ ne̱t-u̱t ró, ne̱t-tu̱ o̱ u̱t-cwan e̱ ho̱ it. E̱ o̱ kab-du̱ it u̱ka ne̱t-tu̱ na de̱ u̱t-ho̱, u̱ka wa-u-pan ku̱bte̱ ca m-ha u̱du̱ u̱t-pan.>> ");
INSERT INTO gel_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ko̱ ba shu̱'u̱te̱ u̱zu̱, no̱m-u̱t yo̱-to̱ tun-to̱ u̱t-be̱e̱t to̱ kwu̱mu̱ in, in aru̱kte̱ na fag in a re̱-du̱ u̱r-ko̱rro̱, remu̱ Kiristi o̱ cwan-u̱t in. ");
INSERT INTO gel_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","39","U̱m nu̱pu̱ste̱ u̱zu̱, waku̱n zaar wu̱ do̱'e̱ u̱t-wa u̱ Ru̱-u̱ yage̱ cwan-u̱t in da: ko̱ m-mar, ko̱ u̱r-fat, ko̱ a-to̱mu̱ u-Ru̱, ko̱ faru̱k-u̱ no̱m u̱s-te, ko̱ no̱m-u̱ na o̱ te̱k u̱t-no̱m, ko̱ u̱ na de̱ u̱t-no̱m u̱ da-u̱ o̱o̱n ne̱, ko̱ yan go̱-du̱ u̱r-faru̱k, ko̱ m-ja, ko̱ u̱r-ra, ko̱ o̱ko̱n no̱m-o̱ u̱t-kwu̱s u̱t-kwu̱s, to̱ ko̱rge̱ to̱ mo̱t in u̱ cwan-tu̱ Ru̱-u̱ ne̱ da. Ru̱-u̱ ko̱ske̱ u̱zu̱ wa o̱ cwan-u̱t in, u̱ wa to̱mto̱n Ye̱so̱ Kiristi Wa-ko-uyan in wa mu̱r u̱ remu̱ in. ");
INSERT INTO gel_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Remu̱ shu̱'u̱t-u̱r ri wa-doru̱ Kiristi, u̱m o̱ warru̱ u̱t-nip, Yar-u̱ u-Ru̱ o̱ dor-tu̱ jab-u̱ ri tu̱msu̱ o̱ ko̱ske̱ u̱zu̱ bise̱ u̱m o̱tte̱ da. ");
INSERT INTO gel_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Jab-u̱ ri naag sok, me̱n-tu̱ du̱ng-te̱ me̱ za u̱r-ma. ");
INSERT INTO gel_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","U̱m no̱mo̱g dorog-u̱s se̱ remu̱ o̱r-u̱t ri ne̱ Isra-ne̱ campa-ne̱ u̱ u̱t-ne̱ta ne̱, u̱m cwanu̱g u̱zu̱ Ru̱-u̱ yagu̱ me̱ u̱m shu̱'u̱t u̱ka ne̱t wu̱ na wa-e̱ u-nu, na mo̱t me̱ u̱ Kiristi ne̱ remu̱ u̱ku̱r u̱ ne̱t-u̱t ri Isra-ne̱. ");
INSERT INTO gel_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Ne̱t-tu̱ Isra, to̱ o̱ ne̱t-tu̱ Ru̱-u̱ mu̱tte̱ ya'ag-u̱ wa, wa ko̱sku̱ u̱n fu̱u̱bse̱-u̱t wa. Wa no̱ngu̱ u̱n este̱du̱ u̱s-rem, wa yasu̱ u̱n Bo̱r-u̱t wa. Wa ko̱su̱ u̱n fu̱n-yu̱ u̱t-huuk u̱t-nip ne̱ tu̱msu̱ u̱ este̱du̱ u̱s-rem ne̱. ");
INSERT INTO gel_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Ibrahi, Ishaku, u̱ Yakubu e̱ o̱ye̱ ne̱nge̱n-tu̱ u̱so-tu̱ u̱so-u̱t in, tu̱msu̱ Kiristi wa-Isra wa u̱ mat-du̱ ne̱t. Wu̱na o̱ u-Ru̱. Wu̱na o̱ faru̱k-u̱ ko̱wan be̱e̱t, tu̱msu̱ wa ko̱rge̱ na no̱mu̱ wa u̱t-vam za u̱r-ma, U̱ shu̱'u̱t iya! ");
INSERT INTO gel_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Za remu̱ zu̱ es-du̱ u̱s-rem u-Ru̱ zatte̱ u̱r-be̱b da, se̱di remu̱ zu̱ ne̱t-tu̱ Isra to̱ u̱t-be̱e̱t ne̱t-tu̱ u-Ru̱ da. ");
INSERT INTO gel_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Tu̱msu̱ za ne̱t-tu̱ ko̱-u̱r Ibrahi to̱ o̱ ne̱t-tu̱ u-Ru̱ da. Remu̱ iya, Ru̱-u̱ zu̱ Ibrahi, <<U̱-me̱ Ishaku Me̱ rwu̱u̱tu̱n bo̱ yaag i u̱m no̱mu̱ bo̱ este̱du̱ u̱s-rem, za waku̱n u̱ te̱k-u̱ me̱ ya'ag-u̱ ró da.>> ");
INSERT INTO gel_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Yaag-u̱ na mate̱ u-war, e̱ o̱ ya'ag-u̱ Ru̱-u̱ da, se̱di ya'ag-u̱ este̱du̱ u̱s-rem, e̱ o̱ ya'ag-u̱ Ibrahi i u̱t-nip. ");
INSERT INTO gel_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Baksu̱n no̱m-u̱ Ru̱-u̱ zu̱ye̱, da-u̱ wa no̱me̱ este̱du̱ u̱s-rem, <<Ba da-u̱ shiye̱, u̱m de̱ u̱t-mu̱u̱n, Saratu de̱ mat-du̱ yadu̱ u̱r-campa.>> ");
INSERT INTO gel_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Mo̱ko̱n sha-mu̱ o̱ro tu̱msu̱. Yaag-u̱ Rebeka o̱tte̱ u-u̱so u-gan, wu̱na o̱ u̱so-u in Ishaku. ");
INSERT INTO gel_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Se̱di kanda na mat ya'ag-u̱ e̱ yu̱r, Ru̱-u̱ wargu̱ Rebeka u̱zu̱, <<Wa'-u̱ yat-wa de̱ no̱mu̱ wu̱ re̱k-wa m-to̱k.>> Ru̱-u̱ zu̱u̱g iya kanda e̱ nom-u̱t o̱ko̱n no̱m-o̱ u̱ so̱-o̱ ko̱ u̱ yo̱-o̱. Ru̱-u̱ zu̱u̱g iya remu̱ zu̱ wu̱na dage̱ Yakubu remu̱ zu̱ iya-o̱ Ru̱-u̱ cinte̱. ");
INSERT INTO gel_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","U̱ka Rem-su̱ u-Ru̱ zu̱tte̱, <<U̱m cwanu̱g Yakubu, u̱m gu̱gu̱mte̱ Isuwa.>> ");
INSERT INTO gel_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","¿Yan-o̱ in do̱'e̱ u̱t-zu̱? ¿No̱ o̱ m-hyan u̱ka zu̱ Ru̱-u̱ no̱ng ho̱n-ho̱n da? Iya-o̱ da! Ko̱ cashi! ");
INSERT INTO gel_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Remu̱ Ru̱-u̱ zu̱u̱g Mosa, <<Wa u̱m cwane̱ u̱m hyan o̱n-u̱r wa, me̱ ho̱gu̱ o̱n-u̱r wa, wa u̱m cwane̱ u̱m no̱mu̱ u̱r-ho̱, me̱ no̱mu̱ wa u̱r-ho̱.>> ");
INSERT INTO gel_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Remu̱ iya, za remu̱ cwan-mu̱ ne̱t mo̱ ko̱ pama-u̱s wa da, se̱di remu̱ o̱n-du̱ u-Ru̱ kyak. ");
INSERT INTO gel_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Rem-su̱ u-Ru̱ zu̱ye̱ Faru̱k-u̱ Masar, <<U̱m wa'ag bo̱ Faru̱k remu̱ u̱m ko̱ste̱ u̱t-ne̱t shin-m ri u̱du̱ ró remu̱ u-dak u-be̱e̱t nu̱pu̱t me̱.>> ");
INSERT INTO gel_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Iya Ru̱-u̱ hogte̱ o̱n-du̱ wu̱ wa cwane̱ wa ho̱g o̱n-u̱r wa, tu̱msu̱ wa rindu̱sse̱ jab-u̱ wu̱ wa cwane̱ u̱t-rindu̱sse̱. ");
INSERT INTO gel_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Waku̱n u̱t-kere̱ u̱t-zu̱, <<Abite̱ iya-o̱, ¿remu̱ yan-o̱ Ru̱-u̱ o̱tte̱ hyan-du̱ ba'as-u̱t in? ¿Wana de̱ gu̱gmu̱ no̱m-u̱ Ru̱-u̱ cwane̱?>> ");
INSERT INTO gel_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","¿Se̱di wana bo̱ mat-du̱ ne̱t bo̱ no̱m-u̱t inan u-Ru̱ ne̱? ¿No̱m-u̱ Ru̱-u̱ no̱me̱, o̱ u̱t-kere̱ u̱t-zu̱, <<Remu̱ yan-o̱ bo̱ nom-tu̱ me̱ inya?>> ");
INSERT INTO gel_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Wu̱ o̱ ma-u̱ u̱t-tur, wa keru̱ kab-du̱ u̱t-rwab wa no̱m u̱ka wa o̱tte̱ u̱ssa. Wa kere̱ kab-du̱ kwu̱s-du̱ u̱t-rwab u̱r-gan, wa mu̱u̱t u̱t-tur remu̱ ho̱-du̱ u̱r-mo̱ro̱g, tu̱msu̱ to̱ko̱n tur-to̱ hen remu̱ ne̱t-tu̱ daaste̱ u̱t-opos u̱-me̱. ");
INSERT INTO gel_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Iya Ru̱-u̱ nomte̱ pama-u̱s wa, wa ko̱se̱ ryab-u̱s wa remu̱ u̱t-ba'as tu̱msu̱ wa ko̱se̱ u̱zu̱ remu̱ shin-m wa, wa keru̱ yadu̱ ne̱t-ne̱ u̱r-ko̱b i no̱me̱ u̱t-ba'as. Se̱di wa o̱tte̱ gag-du̱ jab u̱du̱ i wa de̱ ko̱su̱ ryab-u̱s wa, ne̱t-tu̱ kame̱ wa ya' e̱ u̱r-ko̱b. ");
INSERT INTO gel_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Iya-o̱ wa o̱tte̱ u̱ssa wa ko̱se̱ fu̱u̱bse̱-u̱t wa u̱du̱ i wa u̱t-sa wa ho̱g o̱n-u̱r e̱, i wa zo̱nge̱ u̱r-taku̱n i de̱ kwu̱m-du̱ fu̱bu̱sse̱ wa. ");
INSERT INTO gel_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","In i Ru̱-u̱ bane̱, za in Yahuda-ne̱ u̱ war in da se̱di u̱ a-za Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","U̱ka wa wu̱rte̱ u̱ ran-u Hoseya u̱zu̱: <<I za ne̱t-u̱t ri da, u̱m de̱ fag-du̱ e̱ <Ne̱t-u̱t ri.> Tu̱msu̱ ko̱-du̱ u̱m o̱o̱g gu̱gu̱mte̱, u̱m de̱ fag-du̱ de̱, <Ko̱-du̱ u̱m o̱ u̱t-cwan.> >> ");
INSERT INTO gel_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Tu̱msu̱ <<U̱ be-u̱r re̱ du̱ na fog-tu̱ u̱n: <No̱ o̱ ne̱t-tu̱ ri i da,> na de̱ fag-du̱ u̱n, <Yaag-u̱ Ru̱-u̱ u̱r-fat.> >> ");
INSERT INTO gel_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Ishaya wa-warru̱ Rem-su̱ u-Ru̱ jaku̱s u-cwar wa no̱m u̱s-rem u̱ mo̱t-tu̱ Isra-ne̱, <<Isra-ne̱ o̱ u-tát u̱ka hereg-mu̱ m-sa, se̱di u̱ be-du̱ u̱n o̱tte̱, ne̱t-to̱ cashi e̱ de̱ kwu̱m-du̱ u-u̱ku̱r. ");
INSERT INTO gel_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Yawe de̱ kwu̱pu̱ u-dak u-be̱e̱t u̱s-rem za naas u-da, tu̱msu̱ wa ho̱o̱g se̱ o̱ko̱n za u̱t-kwu̱s da.>> ");
INSERT INTO gel_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","U̱ka Ishaya wa-warru̱ Rem-su̱ u-Ru̱ zu̱tte̱ u̱ de̱ku̱n be-de̱: <<Se̱di u̱zu̱ Yawe wu̱ ze̱ge̱ m-shin yaku̱ste̱ in e̱ke̱n u̱-me̱ yaag-u̱ in da In za shu̱'u̱te̱ u̱ka ne̱t-tu̱ bo̱-u̱ Saduma, na za ho̱ru̱sse̱ in be̱e̱t u̱ka ne̱t-tu̱ bo̱-u̱ Gomora.>> ");
INSERT INTO gel_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","¿Yan-o̱ in do̱'e̱ u̱t-zu̱ u̱ da-o̱? I za-Yahuda-ne̱ da, zo̱ngte̱ e̱ shu̱'u̱t ne̱t-tu̱ jab-u̱s so̱-se̱ u̱du̱ u-Ru̱ da, u̱ da-o̱ e̱ kwu̱mu̱g, jab-u̱ so̱-o̱ u̱ na kume̱ du̱gu̱-du̱ yadu̱ jab. ");
INSERT INTO gel_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Se̱di Isra-ne̱ i cwane̱ e̱ shu̱'u̱t a-jab-u̱s so̱-se̱ u̱ do̱rru̱ fu̱n-yu̱ u-bo̱r, e̱ kwu̱mu̱g da. ");
INSERT INTO gel_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","¿Yan-o̱ wu̱te̱ iya? Remu̱ zu̱ Yahuda-ne̱ kwu̱mu̱g o̱ u̱ fu̱n-yu̱ yadu̱ jab da, se̱di u̱n cwanu̱g u̱ Ru̱-u̱ kab u̱n remu̱ no̱m-du̱ pama-u̱s so̱-se̱ u̱n. E̱ no̱ng u̱r-pu̱kse̱, <<U̱ do̱m-u̱ ta'ar-ru̱ wadu̱ ne̱t u̱r-pu̱kse̱.>> ");
INSERT INTO gel_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","U̱ka o̱tte̱ m-pan u̱-me̱ Rem-su̱ u-Ru̱ u̱zu̱: <<Gwat! U̱m kaag u̱r-taar u̱ Sihiyona Taar-du̱ u̱r-pu̱kse̱, Se̱di wu̱ ya' jab u̱du̱ wa, na za yadu̱ wa m-e̱' da.>> ");
INSERT INTO gel_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","O̱r-u̱t ri ne̱, no̱m-u̱ jab-u̱ ri ze̱ge̱ m-cwan u̱ to̱o̱g-u̱s ri ne̱ u̱du̱ u-Ru̱ u̱zu̱, u̱ Isra-ne̱ kum u-u̱ku̱r. ");
INSERT INTO gel_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","U̱m nak u̱n yaag hi-u̱t u̱n u̱ no̱m-du̱ pama-su̱ u-Ru̱ sok. Se̱di o̱ za u̱ fu̱n-yu̱ nap-du̱ u̱t-nip da. ");
INSERT INTO gel_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","U̱m zu̱u̱g iya remu̱ zu̱ u̱n nak fu̱n-yu̱ Ru̱-u̱ o̱ u̱t-do̱r wa muute̱ u̱t-ne̱t a-jab-u̱s so̱-se̱ ne̱. Wa cwanu̱g u̱n kum jab-u̱ so̱-o̱ u̱ rwu̱ne̱ u̱du̱ wa. Se̱di e̱ gu̱gu̱mte̱ fu̱n-yu̱ u-Ru̱. De̱ wu̱te̱ e̱ o̱tte̱ u̱ssa e̱ kum jab-u̱ so̱-o̱ remu̱ do̱rru̱ u̱t-bo̱r. ");
INSERT INTO gel_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kiristi shu̱u̱ste̱ no̱m-u̱ wu̱te̱ na nom-u̱t bo̱r-u̱t Mosa, remu̱ ko̱wana ya'e̱ jab u̱du̱ u-Ru̱, Ru̱-u̱ de̱ jaasu̱ ba'as-u̱t wa. ");
INSERT INTO gel_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Ko̱se̱-u̱t Mosa ko̱ske̱ u̱zu̱ ne̱t de̱ keru̱ shu̱'u̱tu̱ wa jab-u̱ so̱-o̱ a wa o̱ do̱rru̱ u̱t-bo̱r. <<A-bo̱ u̱t-sa kwu̱m-du̱ u̱r-fat, se̱ bo̱ no̱ng no̱m-u̱ bo̱r-tu̱ zu̱ye̱.>> ");
INSERT INTO gel_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Se̱di no̱m-u̱ Rem-su̱ u-Ru̱ zu̱ye̱, u̱ka ne̱t do̱te̱ u̱t-shu̱'u̱t wa jab-u̱ so̱-o̱ remu̱ yadu̱ jab, <<A-bo̱ zu̱ u̱-me̱ jab-u̱ ró, <¿Wana de̱ dadu̱ do̱m u-ru̱?> (Remu̱ wa cu̱stu̱n Kiristi u-dak) ");
INSERT INTO gel_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Tu̱msu̱ ko̱ no̱ zu̱, <¿Wana de̱ u̱r-cwa u̱-ta u-dak>?>> (Wa yu̱ns Kiristi du̱gu̱ m-mar.) ");
INSERT INTO gel_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Se̱di no̱m-u̱ Rem-su̱ u-Ru̱ zu̱ye̱ ya: <<Rem-su̱ u-Ru̱ o̱ u̱t-mo̱r u̱ bo̱ ne̱, se̱ o̱ me̱ nu-u ró u̱ jab-u̱ ró ne̱.>> Rem-u̱s se̱ o̱tte̱ ko̱se̱-tu̱ yadu̱ jab se̱ in o̱ u̱t-bu̱t. ");
INSERT INTO gel_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","A-bo̱ ware̱ u̱ nu-u ró u̱zu̱ Ye̱so̱ Wa-ko-uyan wa, tu̱msu̱ bo̱ yu̱' jab u̱zu̱ Ru̱-u̱ yu̱nste̱ wu̱n du̱gu̱ m-mar, bo̱ de̱ u̱t-kwu̱m u-u̱ku̱r. ");
INSERT INTO gel_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","U̱m zu̱u̱g iya remu̱ zu̱ jab o̱ ne̱t do̱te̱ yadu̱ jab wa shu̱'u̱te̱ za u̱t-ba'as u̱du̱ u-Ru̱, tu̱msu̱ nu-o̱ ne̱t do̱te̱ u̱r-do̱nse̱ wa kum-u̱t u-u̱ku̱r. ");
INSERT INTO gel_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","U̱ka o̱tte̱ m-pan u̱-me̱ Rem-su̱ u-Ru̱, <<Wu̱ ya' jab ro u̱du̱ wa, wa za no̱m-du̱ m-'e̱ da.>> ");
INSERT INTO gel_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Ru̱-u̱ ko̱ste̱ m-ku̱u̱k da. Wa o̱ hyan-du̱ Yahuda-ne̱ u̱ i-za-Yahuda-ne̱ da u̱s-gan. Ru̱-u ne̱t-ne̱ be̱e̱t o̱. Tu̱msu̱ wa no̱m u-nya u̱du̱ ne̱t-ne̱ be̱e̱t i foge̱ dim-u̱r wa. ");
INSERT INTO gel_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","U̱ka o̱tte̱ m-pan u̱-me̱ Ran-u̱ u-Ru̱ u̱zu̱, <<Ko̱wana fage̱ Yawe u̱ sa-u̱ u̱r-se̱ge̱, wa do̱'e̱ kwu̱m-du̱ u-u̱ku̱r.>> ");
INSERT INTO gel_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","¿Se̱di re̱ne̱ o̱ ne̱t-tu̱ ya jab u̱du̱ ró da, e̱ do̱te̱ keru̱ fag-du̱ Yawe u̱ sa-u̱ u̱r-se̱ge̱? ¿Re̱ne̱ o̱ e̱ do̱te̱ yadu̱ jab u̱du̱ wu̱ e̱ tame̱ ho̱g-du̱ mo̱t-u̱t wa da? ¿Re̱ne̱ o̱ e̱ do̱te̱ u̱t-ho̱g a waku̱n waru̱ u̱n da? ");
INSERT INTO gel_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","¿Re̱ne̱ o̱ a-u̱t-bu̱t do̱te̱ bu̱t-tu̱ a waku̱n to̱mu̱ u̱n da? U̱ka o̱tte̱ m-pan u̱-me̱ Rem-su̱ u-Ru̱ u̱zu̱, <<Haan-u̱r a-bu̱t-tu̱ Rem-su̱ m-Re̱me̱r ze̱k u̱r-zwar.>> ");
INSERT INTO gel_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Se̱di ne̱t-tu̱ Isra to̱ u̱t-be̱e̱t u̱ kabe̱ Rem-su̱ m-Re̱me̱r se̱ da. U̱ka Ishaya wa-warru̱ Rem-su̱ u-Ru̱ zu̱tte̱, <<Yawe, ¿wana kabe̱ rem-u̱s sin-se̱ su̱ it ware̱?>> ");
INSERT INTO gel_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","De̱ wu̱te̱ yadu̱ jab o̱ haan u̱du̱ in u̱ fu̱n-u̱ ho̱g-du̱ Rem-su̱ M-re̱me̱r, tu̱msu̱ na hog Rem-su̱ m-Re̱me̱r u̱du̱ Rem-u̱s Kiristi. ");
INSERT INTO gel_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Se̱di u̱m o̱tte̱ u̱r-shu̱t, <<¿Nip-to̱ u̱zu̱ ne̱t-tu̱ Isra-ne̱ ho̱k da?>> U̱ka o̱tte̱ m-pan u̱-me̱ Rem-su̱ u-Ru̱: <<U̱n no̱ng do̱nse̱-du̱ rem-u̱s se̱ u-dak u-be̱e̱t, Rem-u̱s u̱n teeg ma-du̱ u-dak u-be̱e̱t.>> ");
INSERT INTO gel_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","U̱m swu̱ru̱g m-shu̱t, <<¿Ne̱t-tu̱ i Isra e̱ gwa'ag nu-du̱ u̱ rem-u̱s se̱ da?>> U̱, e̱ gwa'ag nu-du̱ se̱, remu̱ zu̱ u̱ da-u Mosa, Ru̱-u̱ zu̱u̱g: <<U̱m de̱ wadu̱ Isra-ne̱ no̱m shu̱b-du̱ ne̱t-tu̱ za-Yahuda ne̱. Tu̱msu̱ u̱m de̱ u̱t-wa no̱ ho̱g u̱s-ryab remu̱ ne̱t-tu̱ o̱ a-ko̱b-du̱ m-nap ne̱ i-za-Yahuda-ne̱ da.>> ");
INSERT INTO gel_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ishaya waru̱g Rem-su̱ u-Ru̱ jab gan: <<Ne̱t-tu̱ sa-u̱ me̱ da, e̱ de̱ kwu̱m-du̱ me̱, Ne̱t-tu̱ o̱ro i shite̱ u̱ka e̱ do̱te̱ kwu̱m-du̱ me̱ da. Se̱di u̱m ko̱ske̱ hi-u̱r ri m-zu̱n cas u̱du̱ u̱n.>> ");
INSERT INTO gel_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Se̱di mo̱ttu̱ Isra, Ru̱-u̱ swu̱ru̱g m-waru̱ u̱n, <<Ko̱-uyan da, u̱m u̱t-sa u̱m mu̱u̱tu̱n e̱ u̱du̱ ri, Se̱di e̱ shu̱'u̱t a-ko̱b-du̱ do̱rru̱ u̱s-rem ne̱ u̱ a-ko̱b-du̱ ho̱g-mu̱ u̱s-rem ne̱.>> ");
INSERT INTO gel_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","A waku̱n u̱ shite̱ me̱ u̱zu̱: ¿Shu̱'u̱te̱ u̱zu̱ Ru̱-u̱ yakke̱ ne̱t-u̱t wa? Za, iya o̱ da! Ko̱ me̱ ne̱t-u̱ Isra wa, du̱gu̱ rem-u̱r Ibrahi, tu̱msu̱ du̱gu̱ ko̱-u̱r Banyami ne̱. ");
INSERT INTO gel_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Ru̱-u̱ yakte̱ ne̱t-u̱t wa da, i wa dage̱ du̱gu̱ u̱r-taku̱n. Baksu̱n no̱m-u̱ Rem-su̱ u-Ru̱ ware̱, u̱ka Iriya hu̱u̱te̱ rem-su̱ ne̱t-tu̱ Isra u̱du̱ u-Ru̱ wa zu̱, ");
INSERT INTO gel_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","<<Yawe, e̱ ho̱ru̱ssu̱ a-warru̱ rem-u̱s ró ne̱. Tu̱msu̱ e̱ yo̱'o̱kte̱ sak-u̱r ró. Me̱ wa u-gan u̱ kuse̱ u̱r-fat, tu̱msu̱ e̱ o̱ baku̱ ri remu̱ e̱ hoot.>> ");
INSERT INTO gel_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","¿Yan go̱-du̱ u-shas o̱ Ru̱-u̱ no̱mu̱ wu̱n? Wa shaku̱s wa u̱t-zu̱, <<U̱m cu̱ngu̱ hi-du̱ war ri u̱t-ne̱t u̱t-zo̱ngu u̱t-ta'er i so̱kte̱ e̱ no̱mu̱ ru̱-u o̱ u̱ na foge̱ Ba'ar u̱t-huuk da.>> ");
INSERT INTO gel_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Ko̱ u̱ da-o̱ iya o̱tte̱. Ne̱t-tu̱ o̱ro cashi i kuse̱ i Ru̱-u̱ dage̱ remu̱ nya-u wa. ");
INSERT INTO gel_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Du̱g-u̱t to̱ tu̱ Ru̱-u̱ no̱me̱ remu̱ nya-u wa o̱, za remu̱ u̱s-pama su̱ u̱n no̱me̱ da. U̱zu̱ iya da, nya-u u-Ru̱ za shu̱'u̱te̱ nya-u so̱-o̱ da. ");
INSERT INTO gel_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","No̱m-u̱ o̱ te̱k-u̱ ya: Ne̱t-tu̱ Isra saag fu̱n-yu̱ e̱ do̱te̱ u̱t-shu̱'u̱t ne̱t-u̱t so̱-to̱ u̱du̱ u-Ru̱. Se̱di e̱ kwu̱ng no̱m-u̱ e̱ u̱t-sa da. E̱ke̱n u̱ te̱k-u̱ me̱ u̱n i Ru̱-u̱ dage̱, e̱ kabu̱g jab-u̱ so̱-o̱ u-Ru̱, se̱di u-tát i kuse̱, e̱ shu̱'u̱te̱ a-ko̱b-du̱ ho̱g-du̱ u̱s-rem ne̱ tu̱msu̱ e̱ kwu̱mu̱g da. ");
INSERT INTO gel_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","U̱ka o̱tte̱ m-pan u̱-me̱ Rem-su̱ u-Ru̱ u̱zu̱, <<Ru̱-u̱ muute̱ u̱n u̱ka rag-ne̱ tu̱msu̱ za m-nap. Wa yaag u̱n is se̱di e̱ za u̱t-hyan da, tu̱msu̱ wa yaag u̱n u̱t-to̱, e̱ za u̱t-ho̱g da u̱ haan u̱ ya-o̱.>> ");
INSERT INTO gel_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Se̱ Dawuda zu̱, <<Yage̱ mo̱ro̱g-du̱ u-re̱ u̱n to̱ shu̱'u̱t u̱ka u̱r-re̱n. Tu̱msu̱ yage̱ u̱ shu̱'u̱t u̱n u̱r-pu̱kse̱, u̱ de̱ hatu̱n u̱n swadu̱ u̱r-ko̱b. ");
INSERT INTO gel_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Yage̱ is-u̱ u̱n u̱ no̱m u-cwu̱m, E̱ de̱ swadu̱ u̱r-ko̱b u-tát u̱ka to̱k-ne̱ za u̱r-ma.>> ");
INSERT INTO gel_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","U̱m o̱mo̱n u̱r-shu̱t ne̱ u̱ da-o̱: ¿A Isra-ne̱ pu̱kse̱ e̱ he̱'e̱ e̱ za keru̱ u̱r-yu̱ne̱ da? Iya o̱ da! Remu̱ ba'as-tu̱ Isra-ne̱ no̱me̱, de̱ wu̱te̱ u̱ku̱r-u̱ teet ne̱t-tu̱ za-Yahuda-ne̱ da, remu̱ Isra-ne̱ nom-u̱t shu̱b-u̱r u̱n. ");
INSERT INTO gel_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Ba'as-u̱t Isra-ne̱ haatu̱n kom u-Ru̱ u̱-me̱ u-dak u-be̱e̱t. Tu̱msu̱ ko̱b-du̱ do̱rru̱ u̱s-remu̱ u̱n haatu̱n kom u-Ru̱ u̱du̱ i za-Yahuda-ne̱ da. M-vaste̱, a Isra-ne̱ ya jab u̱du̱ u-Ru̱, in be̱e̱t in do̱'e̱ no̱m-du̱ u̱r-so̱ sok remu̱ kom u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","U̱m o̱ u̱s-rem u̱ no̱ ne̱ i-za-Yahuda-ne̱ da. Me̱ Wa-to̱m-u̱ Ye̱so̱ wa u̱du̱ i za-Yahuda-ne̱ da, u̱m o̱ u̱t-u̱k u̱ remu̱ pama-u̱s ri. ");
INSERT INTO gel_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","U̱ remu̱ iya, u̱m o̱ haan jiya me̱ keru̱ wadu̱ Isra-ne̱ e̱ no̱m u̱r-shu̱b, o̱ u̱t-wa u̱ e̱ke̱n u̱ kum u-u̱ku̱r. ");
INSERT INTO gel_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Se̱di ba na gu̱gmu̱ u̱n, wa'ag is-yu̱ u-pus yu̱ ho̱ngu̱sse̱ ne̱t-tu̱ u-dak u̱t-be̱e̱t u-Ru̱ ne̱. Da-u̱ Yahuda-ne̱ ya jab u̱du̱ Ye̱so̱, shu̱'u̱te̱ u̱ka mu̱u̱tu̱n ne̱t-u̱ mare̱ u̱r-fat! ");
INSERT INTO gel_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Ba Ibrahi u̱ e̱ke̱n u̱so-tu̱ u̱so-u̱t in ne̱ o̱o̱ge̱ u-he̱n ne̱, iya o̱ ko̱-u̱r e̱ do̱te̱ u̱t-shu̱'u̱t u-he̱n ne̱ u̱ka ne̱t haste̱ ro̱p-du̱ hyu̱ u-gan wa hatu̱n de̱ u̱du̱ u-Ru̱, de̱ u̱t-shu̱'u̱t u-he̱n ne̱. Shu̱'u̱te̱ u̱zu̱ gu̱g-du̱ hyu̱ de̱ u̱r-be̱e̱t de̱ u̱t-shu̱'u̱t u-he̱n ne̱. Tu̱msu̱ ana yase̱ gu̱r-yu̱ u-te na hu̱u̱t u̱du̱ u-Ru̱, ya u̱t-shu̱'u̱t u-he̱n ne̱, ko̱ske̱ u̱zu̱ ko̱ fe̱-su̱ te-u ya se̱ o̱tte̱ u-he̱n. ");
INSERT INTO gel_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","No̱mo̱n u̱s-dorog u̱zu̱: ana kwu̱pre̱ fe̱-su̱ te-su̱ ze̱tun su̱ na se̱re̱, se̱ na ku̱b fe̱-yu̱ te-yu̱ ze̱tun yu̱ u̱r-do̱g na dame̱ u̱r-kot. No̱ i za ne̱t-tu̱ Yahuda-ne̱ da, no̱ o̱ u̱ka te-yu̱ ze̱tun yu̱ u̱r-do̱g, ana dame̱ no̱ u̱s-gu̱r ne̱, no̱ de̱ kwu̱m-du̱ nya-u̱ u-Ru̱ remu̱ Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Remu̱ iya, a no̱ no̱m u̱t-u̱k u̱zu̱ no̱ ze̱k fe̱-u̱s se̱ su̱ na kupse̱ da. A no̱ o̱ u̱t-u̱k baksu̱n u̱zu̱, a no̱ shipe̱ u̱s-gu̱r da, se̱di gu̱r-se̱ shipe̱ no̱. ");
INSERT INTO gel_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Se̱di i-za-Yahuda-ne̱ da e̱ u̱t-kere̱ u̱t-zu̱, <<Ru̱-u̱ kwu̱pu̱rte̱ fe̱-su̱ Yahuda-ne̱ remu̱ wa samte̱ in u̱s-gu̱r ne̱.>> ");
INSERT INTO gel_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Nip-to̱, remu̱ ko̱b-du̱ yadu̱ jab-u̱ Yahuda-ne̱, de̱ wu̱te̱ na kwu̱pu̱rte̱ u̱s-fe̱ du̱gu̱ u̱s-gu̱r. Tu̱msu̱ no̱ remu̱ yadu̱ jab-u̱ no̱ o̱ no̱ kumte̱ fu̱n-yu̱ u̱t-to̱st u̱s-gu̱r. Se̱di a no̱ no̱m u̱t-u̱k da se̱di na ho̱g u-gye̱r. ");
INSERT INTO gel_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","A Ru̱-u̱ yage̱ Yahuda-ne̱ da, u̱na o̱ u̱ka fe̱-su̱ u-te su̱ u̱r-taku̱n, wa za hen u̱ yagu̱ no̱ da. ");
INSERT INTO gel_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Iya-o̱ Ru̱-u̱ do̱te̱ keru̱ ko̱su̱ no̱m-u̱t so̱-to̱ wa u̱ ryab-u̱s wa ne̱. Wa ko̱su̱ a-u̱t-ba'as ryab-u̱s wa, se̱di wa no̱mu̱ no̱m-u̱t so̱-to̱ wa. Se̱di a no̱ kabe̱ o̱ jab gan da, na de̱ kwu̱p-ru̱ no̱ du̱gu̱ u̱s-gu̱r. ");
INSERT INTO gel_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","A Isra-ne̱ byu̱r-ne̱ du̱gu̱ ko̱b-du̱ yadu̱ jab, na same̱ e̱ u̱s-gu̱r ne̱, remu̱ zu̱ Ru̱-u̱ de̱ keru̱ muutu̱ u̱n u̱du̱ gu̱r-u ya. ");
INSERT INTO gel_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","No̱ i-za-Yahuda-ne̱ da, no̱ o̱ u̱ka te-yu̱ ze̱tun yu̱ u̱r-do̱g yu̱ na kupse̱, se̱ Ru̱-u̱ same̱ ya u̱ matu̱ te-yu̱ ze̱tun ne̱ yu̱ na se̱re̱. Yahuda-ne̱ e̱ o̱ u̱ka te-yu̱ na se̱re̱ yu̱ so̱-ya, za shu̱'u̱tu̱ no̱m-u̱ m-no u̱ Ru̱-u̱ same̱ u̱-fe̱ yu̱ Yahuda-ne̱ u̱ do̱m-u̱ u-gu̱r yu̱ e̱ rwu̱tu̱n da. ");
INSERT INTO gel_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","No̱ hu̱u̱b-u̱t ri, u̱m za u̱ssa no̱ shu̱'u̱t a-ko̱b-du̱ m-nap ne̱ u̱ remu̱ no̱m-u̱ o̱ yase̱ da, taas u̱ no̱ shu̱'u̱t a u̱t-u̱k ne̱ da. Isra-ne̱ u-tát e̱ de̱ shu̱'u̱tu̱ a-ko̱b-du̱ ho̱g-du̱ u̱s-rem ne̱, se̱ i za-Yahuda-ne̱ u-tát i Ru̱-u̱ dage̱ e̱ o̱ yadu̱ jab u̱du̱ Kiristi. ");
INSERT INTO gel_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Iya-o̱ Isra-ne̱ be̱e̱t e̱ do̱te̱ kwu̱m-du̱ u-u̱ku̱r, u̱ka Rem-su̱ u-Ru̱ zu̱tte̱: <<Wa-u-u̱ku̱r de̱ rwu̱u̱n u̱ Urusharima, wa de̱ hastu̱ jab-u̱ ko̱b-du̱ kab-du̱ u̱s-rem du̱gu̱ ko̱-u̱r Yakubu. ");
INSERT INTO gel_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Sin-se̱ o̱ este̱du̱ u̱s-rem u̱ ri u̱ u̱n ne̱, u̱m de̱ no̱mu̱ u̱n ho̱-du̱ ba'as-u̱t u̱n.>> ");
INSERT INTO gel_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Yahuda-ne̱ shu̱'u̱te̱ hu̱u̱b-tu̱ Rem-su̱ M-re̱me̱r, tu̱msu̱ o̱ shu̱'u̱te̱ swu̱r-m no̱ a-za-Yahuda-ne̱ remu̱ zu̱ e̱ gu̱gu̱mte̱ Rem-su̱ m-Re̱me̱r, se̱di Ru̱-u̱ dak Yahuda-ne̱. Ru̱-u̱ o̱ cwan-u̱t u̱n remu̱ i mate̱ u̱so-tu̱ u̱so-u̱t u̱n. ");
INSERT INTO gel_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","In nu̱pu̱ste̱ u̱zu̱ Ru̱-u̱ re̱e̱g shu̱ u̱ cwan-u̱t u̱n ne̱ remu̱ zu̱ wa za kab-du̱ nya-u̱ wa no̱mu̱ u̱n da ko̱ ne̱t-tu̱ wa dage̱ to̱ ka wa u̱t-to̱. ");
INSERT INTO gel_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","U̱r-taku̱n no̱ i za-Yahuda-ne̱ da, no̱ no̱ng ko̱b-du̱ do̱rru̱ u̱s-rem, se̱di u̱ da-o̱ no̱ kwu̱mu̱g o̱n-du̱ u-Ru̱ remu̱ ko̱b-du̱ do̱rru̱ u̱s-rem u̱ Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","U̱ da-o̱ Yahuda-ne̱ u̱ hi-u̱r e̱, e̱ shu̱'u̱te̱ a-ko̱b-du̱ do̱rru̱ Rem-su̱ u-Ru̱ u̱ka e̱ do̱te̱ kwu̱m-du̱ o̱n-du̱ u-Ru̱, o̱n-du̱ Ru̱-u̱ ko̱su̱ i-za-Yahuda-ne̱ da. ");
INSERT INTO gel_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Ru̱-u̱ mu̱tte̱ u̱t-ne̱t u̱t-be̱e̱t Yahuda-ne̱ u̱ i za-yahuda-ne̱ da a-ko̱b-du̱ do̱rru̱ u̱s-rem. Ru̱-u̱ no̱mo̱g iya remu̱ wa ko̱ste̱ u̱t-ne̱t u̱t-be̱e̱t o̱n-u̱r wa. ");
INSERT INTO gel_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Nip-tu̱ ra-du̱ ve̱r-su̱ u-Ru̱ tu̱msu̱ nap-m rò zatte̱ u̱r-ma da, kwu̱p-du̱ u̱s-rem u̱ rò ze̱k u̱r-shu̱t. No̱m-tu̱ wa o̱ u̱t-no̱m ze̱k nap-mu̱ ne̱t. ");
INSERT INTO gel_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","U̱ka Rem-su̱ u-Ru̱ zu̱tte̱: <<¿Wana nape̱ jab-u̱ Yawe? ¿Wana o̱ hu̱u̱b-u̱ rò, wana he̱e̱se̱ yadu̱ wu̱n u̱s-rem?>> ");
INSERT INTO gel_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","<<Waku̱n zaar wu̱ de̱ yadu̱ u-Ru̱ o̱ko̱n no̱m-o̱ u̱ wa yage̱ za kum du̱gu̱-du̱ u-Ru̱ da. Remu̱ iya waku̱n zaar wu̱ de̱ u̱t-zu̱ u̱ Ru̱-u̱ to̱p wa da.>> ");
INSERT INTO gel_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Remu̱ du̱gu̱-du̱ wu̱n, tu̱msu̱ u̱du̱ wu̱n, tu̱msu̱ u̱du̱ du̱ wu̱n de̱ na no̱m-te̱ ko-uyan. Yage̱ fu̱bu̱sse̱ tu̱ shu̱'u̱t u̱du̱ wu̱n m-mo̱mmo̱! U̱ shu̱'u̱t iya! ");
INSERT INTO gel_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Remu̱ iya, o̱r-u̱t ri, u̱m o̱ ko̱n-u̱s no̱ remu̱ o̱n-du̱ u-Ru̱, no̱ yaase̱ war-u̱t no̱ u̱ka u̱r-to̱o̱g, ko̱ ba no̱ o̱ u̱r-fat, se̱di no̱ yaase̱ hi-u̱t no̱ u̱ pama-u̱ u-Ru̱ u̱ka Ru̱-u̱ do̱te̱ ho̱g-du̱ zwar-u̱r no̱. Ya o̱ fu̱n-yu̱ u̱t-nip yu̱ no̱ do̱te̱ no̱mu̱ u-Ru̱ m-sek. ");
INSERT INTO gel_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","A no̱ yage̱ ne̱t-tu̱ za u̱ do̱rru̱ u-Ru̱ da, e̱ waru̱ no̱ u̱ka no̱ do̱te̱ u̱ yu̱-u̱r no̱ da. Se̱di yage̱ u̱ Ru̱-u̱ mang no̱ u̱ka wa o̱tte̱ u̱ssa, tu̱msu̱ wa ya' no̱ jab-u̱ po-o̱. Da-u o̱ no̱ do̱'e̱ nap-du̱ no̱m-u̱ Ru̱-u̱ u̱t-sa no̱ no̱m, tu̱msu̱ no̱ u̱t-nap u̱ka no̱ do̱te̱ no̱m-du̱ ko̱-uyan u̱ so̱-o̱ u̱ Ru̱-u̱ u̱t-sa. ");
INSERT INTO gel_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Remu̱ nya-u̱ Ru̱-u̱ no̱mu̱ me̱, u̱m o̱ naku̱ no̱ u̱t-to̱ be̱e̱t, a waku̱n u̱ hu̱u̱t hi-u̱r wa u̱ be-du̱ wa teye̱ da. Se̱di no̱ nap u̱ka no̱ gotte̱ hi-u̱t no̱, se̱di no̱ kab hi-u̱t no̱ ho̱n-ho̱n u̱ka yadu̱ jab-u̱ Ru̱-u̱ ya' no̱. ");
INSERT INTO gel_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","U̱ka in ko̱wan o̱tte̱ u-war u-gan u̱t-o̱g ne̱ u-tát, tu̱msu̱ ko̱du̱he̱ o̱gde̱ o̱tte̱ pama-u̱ wa nome̱. ");
INSERT INTO gel_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Ko̱ ba shu̱'u̱te̱ u̱zu̱ in o̱ u-tát, se̱di war-o̱ u-gan o̱ na o̱ye̱ remu̱ shu̱'u̱t-u̱r in u̱ Kiristi ne̱, tu̱msu̱ ko̱wan ganse̱ wa o̱ye̱ e̱ o̱r-u̱ wa ne̱. Taas u̱ waku̱n u̱ hyan u̱ka zu̱ Ru̱-u̱ ze̱k m-cwan wa m-ze̱g waku̱n. ");
INSERT INTO gel_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Remu̱ iya, kamu̱g in no̱mo̱n m-ank u̱ nya-u̱ Ru̱-u̱ no̱mu̱ in, u-nya u̱t-go̱ u̱t-go̱, u̱ka Ru̱-u̱ no̱m-tu̱ in nya-u o̱. A Ru̱-u̱ ya bo̱ nya-u̱ warru̱ rem-u̱s wa, war u̱ yadu̱ jab ne̱ u̱ka Ru̱-u̱ yu̱te̱ bo̱. ");
INSERT INTO gel_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Abite̱ nya-u ró u-pama u̱ dor-u u-Ru̱ o̱, no̱m pama-u o̱. Abite̱ nya-u̱ u̱t-ko̱se̱ o̱, no̱m u̱t-ko̱se̱. ");
INSERT INTO gel_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Abite̱ nya-u ró u̱ swu̱ru̱ ne̱t-ne̱ shiriktin-mu̱ jab mo̱, re̱ u-shu̱ u̱t-no̱m. Abite̱ nya-u̱ m-ho̱s o̱ u̱du̱ u̱t-ne̱t remu̱ u̱r-ko̱b, re̱ u-shu̱ u̱t-no̱m jab gan. Abite̱ dor-tu̱ u̱t-ne̱t o̱, no̱m o̱ jab gan. Abite̱ ho̱g-du̱ o̱n-du̱ u̱t-ne̱t de̱, no̱m-o̱ u̱ te̱k-u̱ u̱r-so̱. ");
INSERT INTO gel_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Cwan o̱r-u̱ ró u̱ cwan-tu̱ u̱t-nip. No̱ gu̱gu̱m no̱m-u̱t yo̱-to̱, se̱di no̱ ship no̱m-u̱ o̱ u̱ so̱-o̱ u̱t-kom u̱t-yu̱r. ");
INSERT INTO gel_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Cwan o̱r-u̱ ró u̱ka hu̱u̱b u̱r-matu̱ ró, gwat ko̱wan u̱ka zu̱ wa ze̱k bo̱. ");
INSERT INTO gel_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","A-bo̱ shu̱'u̱t za no̱m-u̱t no̱m da, se̱di yaase̱ hi-u̱r ró u̱ pama-u̱ Wa-ko-uyan. ");
INSERT INTO gel_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","No̱m u̱r-so̱ remu̱ zu̱ bo̱ o̱ wadu̱ jab-u̱ no̱m-u̱ Ru̱-u̱ de̱ no̱mu̱ bo̱, bo̱ gag jab-u̱ te̱k-u̱ swadu̱ u̱r-ko̱b. Tu̱msu̱ re̱e̱n u-shu̱ u̱s-to̱o̱g ne̱ ko̱-uyan da. ");
INSERT INTO gel_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","A ne̱t-tu̱ u-Ru̱ o̱ swadu̱ u̱r-ko̱b, mo̱-tu̱n u̱n no̱m-u̱ no̱ o̱tte̱. Tu̱msu̱ shu̱'u̱tu̱n a cu̱st-u̱ u̱t-hamu̱t ne̱. ");
INSERT INTO gel_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Kom-u̱ u-Ru̱ u̱du̱ ne̱t-tu̱ o̱ yadu̱ no̱ u̱r-ko̱b, waan u̱n nu-u so̱-o̱. A no̱ wa'-u̱ u̱n nu-u yo̱-o̱ da. ");
INSERT INTO gel_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","No̱mo̱n u̱r-so̱ u̱ ne̱t-tu̱ o̱ u̱r-so̱ ne̱, tu̱msu̱ no̱ no̱m u̱s-kan u̱ i o̱ u̱s-kan ne̱. ");
INSERT INTO gel_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","No̱mo̱n shu̱'u̱t-du̱ m-yar u̱ o̱r-u̱t no̱ ne̱. A no̱ shu̱'u̱t a hu̱k-mu̱ u̱r-hi da, se̱di no̱ shu̱'u̱t u̱r-hu̱u̱b u̱du̱ ne̱t-tu̱ na gu̱gme̱ ne̱. A-bo̱ kab hi-u̱r ró u̱ka zu̱ bo̱ nak ko̱-uyan da. ");
INSERT INTO gel_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","A waku̱n u̱ no̱mu̱ bo̱ no̱m-u yo̱-o̱, a-bo̱ to̱p wa u̱ no̱m-u yo̱-o̱ da. Re̱ shu̱ u̱ no̱m-du̱ ne̱t-tu̱ de̱ u̱t-hyan u̱zu̱ o̱ so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","No̱m no̱m-u̱ bo̱ do̱te̱ u̱t-shu̱'u̱t m-yar u̱ ko̱wan ne̱. ");
INSERT INTO gel_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","O̱r-u̱t ri ne̱, a waku̱n u̱ no̱mu̱ bo̱ no̱m-u yo̱-o̱, a-bo̱ to̱p-u̱ no̱m-u̱ yo̱-o̱ da, se̱di yage̱ u̱ Ru̱-u̱ to̱p-u̱ bo̱ u̱r-mag u̱ ryab-u̱s wa. U̱m zu̱u̱g iya remu̱ zu̱ na panu̱g u̱-me̱ Ran-u̱ u-Ru̱ u̱zu̱, <<Me̱ Yawe, u̱m de̱ to̱p-du̱ ko̱wan remu̱ no̱m-u̱ wa no̱me̱.>> ");
INSERT INTO gel_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Rem-su̱ u-Ru̱ re̱e̱g shu̱ u̱t-zu̱, <<Abite̱ hu̱u̱b-u̱ yo̱-o̱ ró o̱ ho̱g-du̱ u̱s-me̱r, ya wa no̱m u̱t-re̱. A wa ho̱g-du̱ u-swaat m-bu̱, ya wa m-bu̱ wa swa. A-bo̱ no̱me̱ iya shu̱'u̱te̱ u̱ka bo̱ kargu̱sse̱ eng-tu̱ u-ra u̱ hi-u̱r rò. Tu̱msu̱ iya o̱ bo̱ do̱te̱ wadu̱ wu̱n u̱ ho̱g-du̱ m-'e̱.>> ");
INSERT INTO gel_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","A-bo̱ yage̱ jab-u̱ yo̱-o̱ u̱ re̱ jab-u̱ ró da, se̱di bo̱ ze̱g be̱b-du̱ jab-u̱ yo̱-o̱ u̱ fu̱n-yu̱ no̱m-du̱ no̱m-u̱t so̱-to̱. ");
INSERT INTO gel_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Ko̱wan wa ya' m-ze̱g u̱du̱ farkina-ne̱ i u-dak. Waku̱n zaar wu̱ de̱ shu̱'u̱tu̱ faru̱k da, se̱ wu̱ Ru̱-u̱ dage̱. Tu̱msu̱ ko̱wana shu̱'u̱te̱ faru̱k, Ru̱-o̱ gan-du̱ wa u̱r-faru̱k. ");
INSERT INTO gel_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Remu̱ iya, ko̱wana gu̱gme̱ do̱rru̱ faru̱k-tu̱ u-dak, wa gu̱gu̱mte̱ do̱rru̱ no̱m-u̱ Ru̱-u̱ gan-de̱. Tu̱msu̱ i o̱ u̱t-no̱m iya e̱ de̱ naknu̱ hi-u̱r e̱ swadu̱ u̱r-ko̱b. ");
INSERT INTO gel_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","U̱m zu̱u̱g iya remu̱ zu̱ a no̱ o̱ no̱m-du̱ no̱m-u̱t so̱-to̱ no̱ za ho̱g-du̱ gye̱r-u u̱n da. Se̱di ne̱t-tu̱ o̱ no̱m-du̱ no̱m-u̱t yo̱-to̱ e̱ de̱ ho̱g-du̱ gye̱r-u̱ u̱t-faru̱k. A-bo̱ u̱t-sa bo̱ ru gye̱r-yu̱ ne̱t-u̱ o̱ u̱r-faru̱k, no̱m no̱m-u̱t so̱-to̱ wa de̱ hen u̱ vam-du̱ bo̱. ");
INSERT INTO gel_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Wa de̱ vam-du̱ bo̱ remu̱ zu̱ wa to̱k wa u-Ru̱ wa remu̱ ró. Se̱di a-bo̱ o̱ ne̱t-u̱ yo̱-o̱, bo̱ u̱t-ho̱g u-gye̱r remu̱ zu̱ zan-o̱ da, farkina-ne̱ o̱tte̱ be̱b-du̱ yadu̱ bo̱ u̱r-ko̱b. To̱k u-Ru̱ wa tu̱msu̱ u̱du̱ wa de̱ Ru̱-u̱ ko̱ste̱ ryab-u̱s wa u̱du̱ ne̱t-u̱t yo̱-to̱. ");
INSERT INTO gel_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Remu̱ iya yasu̱n hi-u̱r no̱ u̱du̱ faru̱k-tu̱ u-dak, za remu̱ gye̱r-u̱ ryab-su̱ u-Ru̱ u̱ war-o̱ da, se̱di taas u̱ dorog-u̱s no̱ u̱ hoos no̱ ru̱s-du̱ jab. ");
INSERT INTO gel_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","De̱ wu̱te̱ no̱ top-u̱t shik-u̱ tar, remu̱ zu̱ faru̱k-u̱t to̱ to̱k-ne̱ u-Ru̱ e̱, tu̱msu̱ e̱ yaase̱ da-u e̱ remu̱ e̱ nom-u̱t u̱r-faru̱k. ");
INSERT INTO gel_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","To̱po̱n ko̱wan no̱m-u̱ wa doru̱ no̱. Abite̱ shik-u̱ tar-u̱ hi-du̱ war-no̱ e̱, de̱e̱n no̱ to̱p, abite̱ hen shik-u̱ tar-u̱ no̱ e̱, to̱po̱n. Yaan m-ze̱g u̱du̱ wu̱ ko̱re̱ Ho̱go̱n gye̱r-u̱ wu̱ ko̱re̱ na ho̱g gye̱r-u wa, tu̱msu̱ no̱ ya' m-ze̱g u̱du̱ wu̱ ko̱re̱ no̱ ya' m-ze̱g. ");
INSERT INTO gel_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","A no̱ shipis no̱m-u waku̱n da. Se̱di no̱m-du̱ no̱m-tu̱ bo̱r-tu̱ u-Ru̱ zu̱ na no̱m, u̱zu̱ u̱ ne̱t-u̱ cwan o̱r-u̱t wa ne̱. U̱m zu̱u̱g iya remu̱ zu̱ wu̱ cwane̱ o̱r-u̱ wa, wa o̱ do̱rru̱ no̱m-u̱ bo̱r-tu̱ zu̱ na no̱m. ");
INSERT INTO gel_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Bo̱r-u̱t to̱ zu̱u̱g, <<A-bo̱ no̱m m-o̱ da, a-bo̱ ho̱ waku̱n da, a-bo̱ no̱m u-hiw da, a-bo̱ no̱m shu̱b-du̱ no̱m-u̱ ne̱t da.>> U̱ no̱m-tu̱ o̱ m-pan ne̱ u̱t-be̱e̱t u̱-me̱ u̱t-bo̱r, na samge̱ to̱ u̱-me̱ rem-u̱s sin-se̱ su̱ zu̱ye̱, <<Cwan o̱r-u̱ ró u̱ka bo̱ tonte̱ hi-du̱ war ró.>> ");
INSERT INTO gel_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","A-bo̱ o̱ cwan-u̱t waku̱n, bo̱ za no̱mu̱ wa no̱m-u̱t yo̱-to̱ da. A-bo̱ cwane̱ o̱r-u̱ ró, bo̱ o̱ no̱m-du̱ bo̱r-u̱t Mosa zu̱ na no̱m. ");
INSERT INTO gel_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Da-u̱ Kiristi do̱'e̱ mu̱u̱n remu̱ wa ku̱b-u̱t in o̱ u̱t-mo̱r u̱ in ne̱ m-ze̱g da-u̱ u̱r-taku̱n du̱ in kabe̱ wa. Remu̱ iya gwatu̱n ka no̱ o̱tte̱ u̱r-yu̱. No̱ yu̱ne̱ du̱gu̱ m-roog. ");
INSERT INTO gel_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Gyu̱p-mu̱ haag m-ta, is haag m-gas. Remu̱ iya, yagu̱n no̱m-du̱ no̱m-u̱t yo̱-to̱ u̱ka ne̱t-tu̱ o̱ u-cwu̱m, se̱di no̱ kab cwu̱-tu̱ m-gag tu̱ u-Ru̱ u̱ka no̱ do̱te̱ gu̱g-mu̱ faru̱k-u̱ no̱m u̱s-te. ");
INSERT INTO gel_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","In no̱mo̱n shu̱'u̱t-u̱r so̱-de̱, u̱ka ne̱t-tu̱ o̱ u̱r-yu̱ u̱-me̱ m-zu̱n. A no̱ same̱ u̱t-hi u̱ mo̱ro̱g-du̱ a-u-swa ne̱ u̱ i o̱o̱ge̱ yu̱du̱ za so̱de̱ ne̱ u̱ a-u-as ne̱ da, za me̱ u-har u̱r-shu̱b ne̱. ");
INSERT INTO gel_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Se̱di no̱ ya' Wa-ko-uyan Ye̱so̱ Kiristi u̱r-be u̱-me̱ jab-u̱s no̱, remu̱ wa hiktu̱n u̱t-mo̱r u̱ no̱ ne̱ u̱ka cwu̱-tu̱ u-war u̱ no̱ tu̱ no̱ wu̱ye̱. A no̱ no̱m dorog-su̱ yu̱-du̱ u̱t-baas tu̱ cwan-tu̱ war-u̱t no̱ da. ");
INSERT INTO gel_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Kabu̱n ne̱t-u̱ yadu̱ jab-u̱ wa zatte̱ u̱r-be̱b da. A no̱ ha inan u̱ u̱n ne̱ da, abite̱ dorog-u̱s u̱n za ho̱n-ho̱n u̱ su̱ no̱ ne̱ da. ");
INSERT INTO gel_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","To̱ko̱n ne̱t-to̱ o̱tte̱ yadu̱ jab-u̱ de̱ wadu̱ e̱ re̱-du̱ no̱m-u̱ e̱ u̱t-sa u̱t-re̱. Tu̱msu̱ e̱ke̱n o̱tte̱ yadu̱ jab u̱zu̱ Ru̱-u̱ za u̱ssa e̱ tu̱ m-ap da se̱ u̱t-ran u̱ war-to̱. ");
INSERT INTO gel_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Wu̱ re̱ ko̱-uyan no̱m u̱t-re̱ o̱, a wa ju̱ru̱m wu̱ rete̱ da. Tu̱msu̱ wu̱ rete̱ da a wa hyan wa u̱t-re̱ u̱ka wa u̱t-ba'as da, remu̱ zu̱ Ru̱-u̱ kabu̱g e̱. ");
INSERT INTO gel_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","¿Wana bo̱, bo̱ kwu̱p-tu̱ to̱k-u̱ waku̱n u̱s-rem? Ko̱ to̱k-u̱ no̱ng no̱m-u̱t so̱-to̱ u̱du̱ u̱so-u u-bu wa ko̱ tu̱ yo̱-to̱, se̱ u̱s-be̱e̱t su̱ wa-u-bu se̱ wa kwu̱pu̱ wa u̱s-rem. Wa u̱t-kere̱ u̱t-es, remu̱ zu̱ Ru̱-o̱ keru̱ yadu̱ wu̱n be̱b-du̱ u̱r-es. ");
INSERT INTO gel_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Waku̱n u̱t-kere̱ u̱t-zu̱ de̱ku̱n ho̱-de̱ ze̱k to̱ko̱n ho̱-to̱. U̱ hyanu̱m waku̱n ho̱-to̱ u̱s-gan. Ko̱wan u̱ no̱m no̱m-u̱ wa nape̱ Ru̱-u̱ u̱t-sa wa no̱m, a wa ha kwu̱pu̱ ne̱t-ne̱ u̱s-rem da. ");
INSERT INTO gel_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Wu̱ o̱ hyan-du̱ u̱ka zu̱ de̱ku̱n ho̱-de̱ ze̱k to̱ko̱n ho̱-to̱, wa o̱ u̱t-no̱m iya remu̱ yadu̱ u-Ru̱ m-sek. Ne̱t-u̱ o̱ re-du̱ ko̱-uyan no̱m u̱t-re̱ o̱, wa o̱ u-re̱ remu̱ sek-mu̱ u-Ru̱, remu̱ zu̱ e̱ o̱ no̱mu̱ Wa-ko-uyan u̱t-vam remu̱ no̱m u̱t-re̱ o̱. Tu̱msu̱ ne̱t-u̱ rete̱ ko̱-uyan no̱m u̱t-re̱ o̱ da wa o̱ u̱t-no̱m iya remu̱ Se̱k-mu̱ u-Ru̱, wa o̱ no̱mu̱ u-Ru̱ u̱t-vam. ");
INSERT INTO gel_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Waku̱n zaar wu̱ o̱ shu̱'u̱t-mu̱ hi-du̱ war-wa da, tu̱msu̱ waku̱n zaar wu̱ de̱ m-mar remu̱ hi-du̱ war-wa da. ");
INSERT INTO gel_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","A in o̱ u̱r-fat, in o̱ u̱r-fat u̱du̱ u-Ru̱. Remu̱ iya, ko̱ u̱r-fat ne̱ ko̱ za u̱r-fat, in o̱ u̱du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Remu̱ iya, Kiristi maru̱g tu̱msu̱ wa mu̱u̱n u̱r-fat remu̱ wa shu̱'u̱te̱ Wa-ko-uyan u̱ ne̱t-tu̱ u̱r-fat u̱ marimari ne̱. ");
INSERT INTO gel_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","¿Bo̱, remu̱ yan-o̱ bo̱ o̱tte̱ kwu̱pu̱ o̱r-u̱ ró u̱s-rem? ¿Ko̱ yan-o̱ wu̱te̱ bo̱ o̱tte̱ ju̱rmu̱ o̱r-u̱ ró? U̱m zu̱u̱g iya remu̱ in be̱e̱t in do̱'e̱ u̱t-es u̱ pora-du̱ kwu̱p-du̱ u̱s-rem u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Rem-su̱ u-Ru̱ zu̱u̱g: <<Me̱ o̱ Yawe, u̱m to̱ndte̱, Ko̱du̱he̱ jwu̱n-de̱ de̱ u̱t-kwu̱g u̱-shu̱ ri, ko̱du̱he̱ rem-de̱ de̱ u̱t-war u̱ nu-u wa u̱zu̱ me̱ wa u-Ru̱.>> ");
INSERT INTO gel_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Remu̱ iya hen kowan de̱ warru̱ no̱m-u̱ wa no̱me̱ u̱du̱ u-Ru̱. Yaksu̱n u-Ru̱ kwu̱p-du̱ u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Yagu̱n kwu̱pu̱ o̱r-u̱t no̱ u̱s-rem. Tu̱msu̱ yagu̱n u̱t-zu̱ u̱ Ru̱-u̱ ya' o̱r-u̱t in ne̱ a-dor u̱r-ko̱b. Se̱di in waan sin-se̱ u̱ jab-u̱s in u̱zu̱ in za no̱m-du̱ o̱ko̱n no̱m-o̱ u̱ do̱'e̱ wadu̱ waku̱n u̱r-he̱'e̱ ko̱ u̱ wadu̱ wa u̱ no̱m-du̱ u̱t-ba'as da. ");
INSERT INTO gel_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","U̱ka wa-doru̱ Wa-ko-uyan Ye̱so̱ u̱m o̱ waru̱ no̱ rem-u̱s sin-se̱. U̱m nak u̱-me̱ jab-u̱ ri u̱m zatte̱ u-sakna da u̱zu̱ ko̱-uyan no̱m u̱t-re̱ o̱ so̱-o̱. Se̱di a waku̱n u̱ zu̱ye̱, <<A u̱m re̱ no̱m u̱t-re̱ uno̱ me̱ u̱t-no̱m u̱t-ba'as u̱du̱ u-Ru̱,>> a wa re̱ no̱m u̱t-re̱ o̱ hen wa no̱ng u̱t-ba'as. ");
INSERT INTO gel_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Abite̱ no̱m u̱t-re̱ u̱ bo̱ o̱ u̱t-re̱ o̱ de̱ haatu̱n o̱r-u̱ ró u̱r-he̱'e̱, bo̱ za cwan-u̱t wa da. Kiristi maru̱g remu̱ o̱r-u̱ ró, a-bo̱ yage̱ u̱ o̱r-u̱ ró u̱ he̱'e̱ u̱ remu̱ no̱m u̱t-re̱ da. ");
INSERT INTO gel_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","A-bo̱ yage̱ no̱m-u̱ bo̱ o̱ m-hyan u̱ka u̱ so̱-o̱, o̱ shu̱'u̱t u̱ yo̱-o̱ da. ");
INSERT INTO gel_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","U̱m zu̱u̱g iya remu̱ zu̱ faru̱k-du̱ u-Ru̱ za mo̱ttu̱ no̱m u̱t-re̱ u̱t-swa ne̱ o̱ da, se̱di mo̱ttu̱ yu̱du̱ jab-u̱ so̱-o̱, shu̱'u̱t-du̱ m-yar, u̱ u̱r-so̱ ne̱ u̱-me̱ Yar-u̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Ko̱wan wu̱ o̱ do̱rru̱ Kiristi u̱ go̱-du̱ fu̱n-u inya, Ru̱-u̱ de̱ ho̱g-du̱ zwar-u̱r wa tu̱msu̱ ne̱t-tu̱ de̱ ru̱stu̱ jab-u̱s e̱ u̱ wu̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Yagu̱n in no̱mo̱n no̱m-u̱ de̱ haatu̱n shu̱'u̱t-du̱ m-yar a-doru̱ Ye̱so̱. Tu̱msu̱ in se̱ge̱n ne̱t-ne̱ e̱ no̱m u̱r-be̱b u̱ yadu̱ jab ne̱. ");
INSERT INTO gel_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","A-bo̱ naas no̱m-u̱ Ru̱-u̱ no̱me̱ remu̱ no̱m u̱t-re̱ da. Ko̱-uyan no̱m-u̱t u̱t-re̱ o̱ so̱-o̱, se̱di zatte̱ u̱r-zwar u̱ ne̱t u̱ re̱ no̱m u̱t-re̱ u̱ de̱ wadu̱ waku̱n u̱r-he̱'e̱ da. ");
INSERT INTO gel_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","U̱t-ze̱g u̱r-zwar a ne̱t u̱ tu̱ m-ap da ko̱ swadu̱ ke̱' ko̱ no̱m-du̱ o̱ko̱n u̱ do̱'e̱ wadu̱ waku̱n u̱r-he̱'e̱. ");
INSERT INTO gel_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Bo̱ keru̱ yadu̱ jab u̱zu̱ no̱m-u̱ bo̱ o̱ u̱t-no̱m u-be̱e̱t o̱ so̱-o̱, se̱di cin o̱ u̱ te̱k-u̱ jab-u̱ ró u̱ u-Ru̱ ne̱. Kom-u̱ u-Ru̱ u̱du̱ ne̱t wu̱ jab-u̱ wa zatte̱ u̱t-ba'as da, remu̱ no̱m-u̱ wa cwane̱ u̱t-no̱m u̱ so̱-o̱. ");
INSERT INTO gel_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Se̱di ne̱t-u̱ wu̱ o̱tte̱ u-sakna u̱ jab-u̱ wa u̱ no̱m-u̱ wa de̱ u̱t-re̱, wa o̱ naknu̱ hi-u̱r wa kwu̱p-du̱ u̱s-rem du̱gu̱-du̱ u-Ru̱. U̱m zu̱u̱g iya remu̱ zu̱ wa zatte̱ yadu̱ jab da. Tu̱msu̱ no̱m-u̱ zatte̱ yadu̱ jab da ba'as-to̱. ");
INSERT INTO gel_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","In i yadu̱ jab-u̱ in o̱ u̱r-be̱b ne̱, kamu̱g in se̱ge̱n i yadu̱ jab-u̱ e̱ zatte̱ u̱r-be̱b da in kabu̱n no'om e̱. Taas in no̱mo̱n cwan-tu̱ u̱r-hi da. ");
INSERT INTO gel_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Yagu̱n u̱ ko̱wan u̱ mang jab-u̱ o̱r-u̱ wa, remu̱ wa swu̱r-tu̱ wu̱n be̱b-du̱ yadu̱ jab. ");
INSERT INTO gel_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Ko̱ Kiristi wa no̱ng cwan-tu̱ hi-u̱r wa da. U̱ka Rem-su̱ u-Ru̱ zu̱tte̱, <<Pyap-su̱ i o̱ pepru̱ bo̱ u̱m o̱ ho̱g-du̱ se̱ u̱ka u̱zu̱ me̱ u̱n o̱ u̱t-pepu̱r.>> ");
INSERT INTO gel_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","No̱m-u̱ na pane̱ u-be̱e̱t u-me̱ Rem-su̱ u-Ru̱ u̱s-be̱e̱t u̱r-taku̱n, na panu̱g se̱ remu̱ na swu̱r-tu̱ in gag-du̱ jab-u̱ shiriktin-mu̱ jab ne̱, u̱ka in do̱te̱ u̱t-shu̱'u̱t u̱ wadu̱ jab ne̱. ");
INSERT INTO gel_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","U̱m o̱ u̱s-ko̱n u̱du̱ u-Ru̱, wu̱ ye na gag-du̱ jab-u̱ shiriktin-mu̱ jab ne̱, u̱ka no̱ do̱te̱ u̱t-shu̱'u̱t u̱ same̱-du̱ u̱t-hi ne̱ u̱s-dorog ne̱ u̱s-gan, remu̱ do̱rru̱ da'at Kiristi Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","A no̱ no̱me̱ iya, rem-u̱s no̱ u̱ dorog-u̱s no̱ de̱ u̱t-shu̱'u̱t u̱s-gan, u̱ka no̱ do̱te̱ vam-du̱ u-Ru̱ wu̱ o̱ U̱so-u in Wa-ko-uyan, Ye̱so̱ Kiristi. ");
INSERT INTO gel_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","U̱ka Kiristi ku̱bte̱ no̱, kabu̱n o̱r-u̱t no̱ iya remu̱ Ru̱-u̱ kum-u̱t u̱t-fu̱'u̱bse̱. ");
INSERT INTO gel_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","U̱m u̱t-sa no̱ baku̱s u̱zu̱ Kiristi no̱ngu̱ Yahuda-ne̱ u̱r-se̱ge̱ remu̱ wa ko̱ste̱ u̱zu̱ Ru̱-o̱ keru̱ no̱m-du̱ no̱m-u̱ wa zu̱ wa u̱t-no̱m. Ru̱-u̱ no̱ngu̱ i mate̱ u̱so-tu̱ u̱so-u̱t in este̱du̱ u̱s-rem u̱zu̱ wa to̱mnu̱ Kiristi. Da-u̱ Ye̱so̱ haane̱, Ru̱-u̱ nom no̱m-u̱ wa zu̱ wa u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Wa haagu̱n remu̱ a-za Yahuda-ne̱, remu̱ e̱ no̱m-tu̱ u-Ru̱ u̱t-fu̱'u̱bse̱ remu̱ o̱n-u̱r wa. U̱ka Rem-su̱ u-Ru̱ zu̱tte̱: <<Remu̱ iya, U̱m de̱ vam-du̱ no̱ u̱-me̱ a-za Yahuda-ne̱, U̱m de̱ no̱m-du̱ se̱p-tu̱ vam-tu̱ dim-u̱r ró.>> ");
INSERT INTO gel_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Tu̱msu̱ Rem-su̱ u-Ru̱ sur m-zu̱: <<No̱mo̱n u̱r-so̱ no̱ i za-Yahuda-ne̱ da, u̱r-kot u̱ ne̱t-tu̱ u-Ru̱ ne̱.>> ");
INSERT INTO gel_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Tu̱msu̱ na sur m-zu̱: <<No̱ be̱e̱t a-za Yahuda-ne̱ vamu̱n Yawe, ne̱t-ne̱ be̱e̱t e̱ vam wa.>> ");
INSERT INTO gel_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Wa-warru̱ Rem-su̱ u-Ru̱ Ishaya zu̱u̱g: <<Waku̱n do̱'e̱ rwu̱u̱n du̱gu̱ ko̱-u̱r Jesse, wa do̱'e̱ haan wa no̱m u̱r-faru̱k u̱-me̱ i-za-Yahuda-ne̱ da. Tu̱msu̱ e̱ do̱'e̱ wadu̱ jab u̱du̱ wa.>> ");
INSERT INTO gel_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","U̱m no̱ng u̱s-to̱o̱g u̱zu̱, Ru̱-u̱ wadu̱ jab, wa ya' no̱ ya' jab-u̱ pus-o̱ u̱ shu̱'u̱t-du̱ m-yar ne̱, no̱ o̱tte̱ yadu̱ jab u̱du̱ wa. Iya o̱ no̱ wadu̱ jab-u̱ no̱ do̱te̱ u̱t-shu̱'u̱t u-shu̱yi shu̱yi u̱ shin-mu̱ Yar-u u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Hu̱u̱b-u̱t ri, me̱ hi-du̱ war ri u̱m nak u̱zu̱ no̱ o̱tte̱ jab-u̱ no̱m-du̱ no̱m-u̱t so̱-to̱. No̱ o̱tte̱ nap-mu̱ no̱m-u̱t tun-to̱ u̱t-be̱e̱t, tu̱msu̱ no̱ keru̱ is-u̱ o̱r-u̱t no̱ ne̱ no̱m-u̱t to̱. ");
INSERT INTO gel_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Se̱di u̱-me̱ uno̱ ran-o̱, u̱m wargu̱ no̱ no̱m-u̱ o̱ jab-u̱ ri u̱ to̱ko̱n no̱m-to̱ ne̱. U̱m wargu̱ no̱ to̱ko̱n no̱m-to̱ tu̱ u̱m u̱t-sa u̱m baksu̱n no̱, remu̱ nya-u̱ u-Ru̱ u̱ wa no̱mu̱ me̱. ");
INSERT INTO gel_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","U̱m shu̱'u̱te̱ wa pama-u̱s Kiristi Ye̱so̱ u̱du̱ a-za Yahuda-ne̱. U̱m haatu̱n no̱ Rem-su̱ m-Re̱me̱r remu̱ no̱ shu̱'u̱te̱ u̱ka u̱r-to̱o̱g u̱du̱ u-Ru̱ du̱ wa u̱t-sa du̱ u-he̱n, remu̱ Yar u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Remu̱ iya, me̱ u̱t-kere̱ gap-du̱ u-so̱k u̱ Ye̱so̱ Kiristi ne̱ tu̱msu̱ u̱ pama-u̱ u̱m o̱ u̱t-no̱m u̱du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","U̱m za keru̱ gap-du̱ u-so̱k u̱m war o̱ko̱n da, se̱di u̱m war no̱m-u̱ Kiristi no̱me̱, remu̱ u̱m wu̱'u̱t i za-Yahuda-ne̱ da u̱ do̱rru̱ u-Ru̱, remu̱ rem-u̱s ri u̱ pama-u̱s ri ne̱. ");
INSERT INTO gel_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Ru̱-u̱ no̱ng no̱m-u̱t tun-to̱ u̱ remu̱ shin-mu̱ wa ko̱se̱ u̱ no̱m-du̱ m-shin u̱ u̱s-nap ne̱, tu̱msu̱ u̱ be̱b-du̱ Yar-u u-Ru̱. Wa takku̱n se̱ du̱gu̱ Urusharima m-ha Iririkum, u̱m no̱ng bu̱t-tu̱ Rem-su̱ m-Re̱me̱r su̱ Kiristi, se̱ da-u̱ u̱m tase̱ pama-u̱s se̱ u̱s-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Cwan-m ri mo̱ ko̱-uyan da-o̱, u̱m no̱m bu̱t-tu̱ Re̱m-su̱ m-Re̱me̱r su̱ u-Ru̱ u̱ be-tu̱ i nape̱ Kiristi da. U̱m no̱ng iya remu̱ zu̱ u̱m za u̱ssa u̱m shu̱'u̱t u̱ka ne̱t wu̱ no̱me̱ u-ma u̱ do̱m-u̱ ma-u waku̱n da. ");
INSERT INTO gel_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","U̱ka Rem-su̱ u-Ru̱ zu̱tte̱: <<Ne̱t-tu̱ nape̱ wu̱n da, e̱ hyan. Tu̱msu̱ ne̱t-tu̱ ho̱ge̱ rem-u̱s rò da, e̱ nap.>> ");
INSERT INTO gel_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","U-da u-be̱e̱t a u̱m zo̱nge̱ m-haan u̱du̱ no̱, na hoos me̱ u̱r-haan. ");
INSERT INTO gel_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","U̱ da-o̱ u̱m taaste̱ pama-u̱ u̱m de̱ u̱t-no̱m remu̱ ne̱t-tu̱ ho̱k Rem-su̱ m-Re̱me̱r u̱ ru̱g-u o̱. U̱s-hak u-tát u̱m cwanu̱g u̱m haan u̱m hyan no̱. ");
INSERT INTO gel_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","U̱ da-o̱ u̱m wa'ag jab u̱r-haan ne̱ u̱ be-u̱r no̱. A u̱m o̱ m-ha u̱ gas-u̱ Asbaniya, me̱ u̱t-do̱ru̱n u̱m hyan no̱. Me̱ u̱t-ho̱g u̱r-zwar u̱m shu̱'u̱t u̱du̱ no̱ u-da cashi. Da-u̱ u̱m kume̱ se̱ge̱-u̱r no̱ se̱ u̱m re̱ shu̱ m-ha ne̱. ");
INSERT INTO gel_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Se̱di kanda u̱m do̱'e̱ u̱ku̱n, u̱m de̱ m-ha u̱ bo̱-u̱ Urusharima remu̱ u̱m no̱m-u̱t u-nya u̱du̱ ne̱t-tu̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Ne̱t-tu̱ kabe̱ Ye̱so̱ Kiristi i o̱ u̱ gas-u̱ Makidoniya u̱ i o̱ ru̱g-u Akaya ne̱, e̱ ho̱k zwarru̱ yadu̱ cwu̱u̱t e̱ u̱du̱ o̱r-u̱t e̱ ne̱ i o̱ u̱r-ko̱b ne̱ i o̱ u̱-me̱ ne̱t-tu̱ u-Ru̱ u̱ bo̱-u̱ Urusharima. ");
INSERT INTO gel_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","E̱ ho̱k zwarru̱ u̱t-no̱m iya rem u̱zu̱ e̱ ho̱k e̱ dor u̱n u̱r-mag. Remu̱ zu̱ a-za-dor ne̱ o̱nkte̱ nya-u̱ u-yar u̱ kom-u̱ u-Ru̱ u̱ rem-su̱ m-re̱me̱r du̱gu̱-du̱ a-dor-ne̱ u̱ bo̱-u̱ Urusharima, e̱ ho̱k u̱zu̱ no̱mu̱ kuse̱ e̱ no̱m u̱ e̱ top-u̱t u̱n u̱r-mag u̱zu̱ e̱ no̱mu̱ u̱n se̱ge̱-du̱ shik. ");
INSERT INTO gel_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Da-u̱ u̱m tase̱ pama-u uno̱, u̱m do̱'e̱ yasu̱ u̱n shik-u̱ u̱n, u̱m do̱'e̱ shu̱p-du̱ fu̱n-yu̱ ha-mu̱ gas-u̱ Asbaniya. A u̱m o̱ te̱k m-ha u̱ Asbaniya, me̱ u̱t-do̱ru̱n u̱m vu̱ku̱s no̱. ");
INSERT INTO gel_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Da-u̱ u̱m teene̱ u̱ Roma, u̱m nak me̱ u̱t-teen u̱ kom-u̱ u-Ru̱ ne̱ u̱ Kiristi ne̱. ");
INSERT INTO gel_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","O̱r-u̱t ri ne̱, remu̱ Ye̱so̱ Kiristi Wa-ko-uyan tu̱msu̱ u̱t-cwan ne̱ tu̱ Yar-u ya in, u̱m o̱ ko̱n-u̱s no̱, no̱ same̱ u̱t-kom u̱ me̱ ne̱ remu̱ gag-mu̱ no̱mu̱ me̱ u̱s-to̱o̱g u̱du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","No̱mo̱n u̱s-to̱o̱g u̱ka u̱m do̱te̱ u̱t-pos du̱gu̱ kom-tu̱ i za a-doru̱ Ye̱so̱ da, in o̱ dak-u̱ Yahudiya. U̱m o̱ u̱s-to̱o̱g u̱ka se̱ge̱-du̱ u̱m do̱'e̱ u̱t-kab u̱du̱ a-dor i Urusharima e̱ kab o̱. ");
INSERT INTO gel_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","A Ru̱-u̱ tane̱, me̱ u̱t-haan u̱du̱ no̱ u̱r-so̱ ne̱ remu̱ in nomtu̱n u̱r-orop u̱r-kot du̱ de̱ ya in shiriktin-mu̱ jab-u̱ ank-mu̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","U̱m o̱ no̱mu̱ no̱ u̱s-to̱o̱g u̱du̱ u-Ru̱ wu̱ shu̱'u̱t m-yar wa no̱m u̱r-kot u̱ no̱ ne̱! U̱ shu̱'u̱t iya. ");
INSERT INTO gel_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Yaku̱n ne̱ta-ya o̱ro wu̱ de̱ haan u̱du̱ no̱, dim-u̱r wa Fibi. U̱m o̱ waru̱ no̱, ne̱t-u̱ m-kim wa. Tu̱msu̱ wa o̱ wa-m-ank u̱-me̱ a-doru̱ Ye̱so̱ u̱ bo̱-u̱ Kankiriya. ");
INSERT INTO gel_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Kabu̱n wu̱n u̱t-kom u̱t-yu̱r remu̱ zu̱ wa doru̱ Wa-ko-uyan wa, u̱ka na gute̱ ne̱t-tu̱ u-Ru̱. No̱mo̱n wu̱n se̱ge̱-du̱ wa u̱t-sa u̱r-be̱e̱t, remu̱ zu̱ ko̱wa wa no̱ngu̱ ne̱t-ne̱ u-tát u̱r-se̱ge̱ tu̱msu̱ ko̱ me̱ u no̱ngu̱ me̱. ");
INSERT INTO gel_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Vu̱k-su̱ me̱ Biskira u̱ Akira ne̱ o̱r-u̱ ri u̱-me̱ pama-u̱s Kiristi Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","E̱ ya'aste̱ fat-u̱t e̱ u̱ka e̱ mar remu̱ ri. Me̱ wa u-gan u̱ o̱ vam-u̱t u̱n da, a-doru̱ Ye̱so̱ i za-Yahuda-ne̱ da e̱ no̱ng u̱t-vam ko̱'e̱. ");
INSERT INTO gel_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Vu̱ksu̱n mo̱ro̱g-du̱ a-dor i mo̱rge̱ u̱-me̱ bu-u u̱n. Vu̱ksu̱n hu̱u̱b-u̱ ri Apanitus, wa doru̱ Kiristi u̱r-taku̱n u̱ dak-u̱ Asiya. ");
INSERT INTO gel_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Vu̱ksu̱n Me̱ri wu̱ no̱mu̱ u-pama u̱ remu̱ no̱ sok. ");
INSERT INTO gel_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Vu̱ksu̱n Andaronikus u̱ Yuniya ne̱, ne̱t-tu̱ Yahuda to̱ u̱ka u̱m o̱tte̱, it u̱ e̱ ne̱ o̱o̱ge̱ u̱ bu-u̱ m-to̱k. A-doru̱ Ye̱so̱ o̱ yadu̱ u̱n m-sek sok, tu̱msu̱ u̱m nak u̱n u̱ te̱k-u̱ a-To̱mu̱ Ye̱so̱ e̱ kabu̱g Kiristi kanda me̱. ");
INSERT INTO gel_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Vu̱ksu̱n Ampiriyatus, hu̱u̱b-u̱ ri u̱-me̱ Wa-ko-uyan. ");
INSERT INTO gel_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Vu̱ksu̱n Urbanus hu̱u̱b m-anku̱ ri u̱-me̱ Kiristi, u̱ hu̱u̱b-u̱ ri ne̱ Sitakis. ");
INSERT INTO gel_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Vu̱ksu̱n Aperes, to̱k-u̱ so̱-wa wu̱ Kiristi. Vu̱ksu̱n ne̱t-tu̱ o̱ bu-u Aristoburus. ");
INSERT INTO gel_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Vu̱ksu̱n Herodiya, o̱r-u̱ ri wa-yahuda. Vu̱ksu̱n a-dor u-Ru̱ i o̱ bu-u Narkisus. ");
INSERT INTO gel_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Vu̱ksu̱n Tirayipina u̱ Tiraposa. Ne̱ta-u̱t to̱ e̱ no̱ngu̱ Wa-ko-uyan u̱s-pama sok. Vu̱ksu̱n hu̱u̱b-u̱ ri Parsis, yaku̱n ne̱ta-ya tu̱msu̱ yu̱ no̱mu̱ Wa-ko-uyan u̱s-pama. ");
INSERT INTO gel_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Vu̱ksu̱n Rufus, wu̱ Ru̱-u̱ dage̱, u̱ ino-u wane̱ wu̱ shu̱'u̱te̱ u̱ka u-ino u̱du̱ ri. ");
INSERT INTO gel_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Vu̱ksu̱n Asinikiritus, u̱ Pirigona, u̱ He̱rme̱s, u̱ Paturubas, u̱ Haramas u̱ o̱r-u̱t u̱n i o̱ u̱r-kot u̱ u̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Vu̱ksu̱n Pikorogus, u̱ Juriya ne̱ ne̱ta, u̱ Niriyus ne̱ u̱ hu̱no-u wa ne̱ wa ne̱ta, u̱ Orimpas, u̱ a-doru̱ Ye̱so̱ ne̱ be̱e̱t i o̱ u̱ku̱n. ");
INSERT INTO gel_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Vu̱ksu̱n o̱r-u̱t no̱ ne̱ u̱ ham-u̱t tu̱ u-he̱n ne̱. A-doru̱ Ye̱so̱ be̱e̱t to̱mgo̱n u̱s-vu̱k. ");
INSERT INTO gel_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","O̱r-u̱t ri ne̱, u̱m cwanu̱g m-nak no̱ u̱t-to̱ remu̱ ne̱t-tu̱ o̱ mo̱t-du̱ no̱, i wadu̱ u̱t-ne̱t e̱ yage̱ do̱rru̱ u-Ru̱ tu̱msu̱ e̱ gu̱gu̱mte̱ go̱-du̱ ko̱se̱-tu̱ na kabe̱. ");
INSERT INTO gel_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Go̱-du̱ ne̱t-tu̱ o̱ no̱m-du̱ no̱m-u̱t to̱, e̱ za no̱mu̱ Kiristi u̱s-pama da, se̱di cwan-tu̱ war-u̱t e̱. U̱ gom-tu̱ m-re̱me̱r u̱ nu-u̱t e̱, u̱ vam-tu̱ u̱s-bi ne̱, e̱ o̱ parru̱ jab-su̱ u̱t-ne̱t i o̱ e̱r-ru̱ u̱n. Ne̱t-tu̱ o̱ e̱r-ru̱ u̱n e̱ o̱ u̱ka ya'ag-u̱ re̱k-e̱. ");
INSERT INTO gel_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Ko̱wan ho̱k u̱ka no̱ o̱tte̱ do̱rru̱ Rem-su̱ m-Re̱me̱r. U̱m ho̱k u̱r-zwar u̱ remu̱ iya. Se̱di u̱m u̱t-sa no̱ no̱m u̱s-ve̱r u̱ no̱m-u̱ o̱ so̱-o̱. No̱ shu̱'u̱t za u̱t-ba'as tu̱msu̱ no̱ so̱m no̱m-u̱t yo̱-to̱. ");
INSERT INTO gel_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Ru̱-u̱ m-yar de̱ yadu̱ no̱ m-shin u̱ no̱ do̱te̱ jangu̱ faru̱k-u̱ no̱m u̱s-te za m-tumb. Nya-u̱ Wa-ko-uyan in Ye̱so̱ o̱ u̱r-kot u̱ no̱ ne̱! ");
INSERT INTO gel_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timoti hu̱u̱b m-ank ri, wa o̱ vu̱k-su̱ no̱. Iya o̱ tu̱msu̱ Rushiyos, u̱ Jaso̱n ne̱, u̱ Sosipata ne̱, e̱ o̱ vu̱k-su̱ no̱, e̱ be̱e̱t o̱r-u̱t ri ne̱ e̱ Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Me̱, Tartiyus, wu̱ pane̱ uno̱ ran-o̱, u̱m o̱ vu̱k-su̱ no̱ ne̱t-tu̱ o̱ do̱rru̱ Wa-ko-uyan. ");
INSERT INTO gel_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayus o̱ vu̱k-su̱ no̱. Wa gwu̱g me̱ u̱-me̱ bu-u wa, u̱-me̱ bu-u wa o̱ a-doru̱ Ye̱so̱ u̱-me̱ bo̱-u o̱ mo̱ro̱gte̱. Erastus, wa-cu̱n-du̱ shik u-bo̱ wa o̱ vu̱k-su̱ no̱. Tu̱msu̱ u̱ o̱r-u̱ it ne̱ Kwartus wa o̱ vu̱k-su̱ no̱. ");
INSERT INTO gel_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Nya-u̱ u-Ru̱ Ye̱so̱ Kiristi o̱ u̱r-kot u̱ no̱ ne̱ be̱e̱t! U̱ shu̱'u̱t iya. ");
INSERT INTO gel_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Yagu̱n in no̱mu̱n u-Ru̱ m-sek! Wa o̱tte̱ m-shin mu̱ no̱ do̱te̱ u̱t-ees u̱-me̱ yadu̱ jab remu̱ Rem-su̱ m-Re̱me̱r su̱ Ye̱so̱ Kiristi wu̱ u̱m o̱ do̱nse̱-u̱r wa! Rem-su̱ m-Re̱me̱r u̱ sin-se̱ na yaksu̱ se̱ m-tumb ne̱. ");
INSERT INTO gel_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Se̱di u̱ da-o̱ na rwu̱tu̱n se̱ m-zu̱n u̱-me̱ ran-tu̱ a-warru̱ Rem-su̱ u-Ru̱ ne̱. Na no̱ng iya u̱ka Ru̱-u̱ zu̱tte̱, tu̱msu̱ na ko̱sku̱ se̱ m-zu̱n u̱du̱ u̱t-ne̱t, remu̱ i-za-Yahuda-ne̱ da e̱ yu̱'u̱t jab tu̱msu̱ e̱ do̱r rem-u̱s Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","U̱m cwanu̱g u̱zu̱, a Ye̱so̱ Kiristi se̱gu̱ in, in do̱'e̱ no̱mu̱ u-Ru̱ u̱t-vam wu̱ o̱ wa-m-nap m-mo̱mmo̱! U̱ shu̱'u̱t iya.");
INSERT INTO gel_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","Uno̱ ran-o̱ o̱o̱n du̱gu̱-du̱ Burus, Wa-to̱m-u̱ Ye̱so̱ Kiristi wu̱ o̱o̱ge̱ u̱zu̱ ne̱t-to̱ dage̱ wa da, ko̱ du̱gu̱-du̱ waku̱n ne̱t wa da. Se̱di Ye̱so̱ Kiristi wa dage̱ me̱ u̱ u-Ru̱ ne̱ u̱ U̱so, wu̱ yu̱nse̱ Ye̱so̱ du̱gu̱ m-mar. ");
INSERT INTO gel_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","A-doru̱ Ye̱so̱ ne̱ be̱e̱t i o̱o̱ge̱ u̱r-kot u̱ me̱ ne̱ to̱mo̱tto̱n uno̱ ran-o̱ u̱du̱ mo̱ro̱g-tu̱ a-dor-ne̱ tu̱ o̱o̱ge̱ u̱ dak-u̱ Garatiya: ");
INSERT INTO gel_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","U̱m no̱ng u̱s-to̱o̱g u̱zu̱ u-Ru̱ U̱so-u in u̱ Wa-ko-uyan Ye̱so̱ Kiristi ne̱ ya' no̱ u-nya u̱ ru̱s-du̱ jab ne̱. ");
INSERT INTO gel_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","Ye̱so̱ yaste̱ fat-u̱r wa sha-mu̱ to̱o̱g u̱ remu̱ ba'as-u̱t in remu̱ wa guut in du̱gu̱ dak-u yo̱-o̱ uno̱. Uno̱ no̱ng u̱ka cite̱ mu̱ Ru̱-u in u̱ U̱so ne̱. ");
INSERT INTO gel_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","Yage̱ inya m-sek u̱du̱ u-Ru̱ m-mo̱mmo̱! U̱ shu̱'u̱t iya. ");
INSERT INTO gel_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","U̱m no̱ng m-zap u̱zu̱ no̱ o̱ byu̱rru̱ u-dim m-ho̱r du̱gu̱-du̱ u-Ru̱, wu̱ dage̱ no̱ remu̱ nya-u Kiristi. No̱ o̱ do̱rru̱ se̱ke̱n fu̱n-se̱ su̱ o̱o̱ge̱ bam u̱ Rem-su̱ m-Re̱me̱r ne̱ su̱ u̱m no̱mu̱ no̱ bu̱t-tu̱ se̱. ");
INSERT INTO gel_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","Se̱di u̱t-nip a Rem-su̱ m-Re̱me̱r se̱ da. M-ha iya ne̱ to̱ku̱n ne̱t-to̱ o̱ro tu̱ o̱o̱ge̱ e̱ngu̱sse̱ no̱ tu̱msu̱ e̱ u̱t-sa e̱ bargu̱sse̱ Rem-su̱ m-Re̱me̱r su̱ mo̱t-u̱t Kiristi. ");
INSERT INTO gel_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","Se̱di ko̱ da u̱zu̱ it, ko̱ wa-to̱m u-Ru̱ wu̱ o̱o̱ge̱ du̱gu̱ do̱m u-ru̱ wa no̱mu̱ no̱ bu̱t-tu̱ Rem-su̱ m-Re̱me̱r su̱ o̱o̱ge̱ bam u̱ Rem-su̱ m-Re̱me̱r ne̱, su̱ it no̱mu̱ no̱ u̱t-bu̱t du̱gu̱ u̱r-taku̱n, yage̱ nu-u yo̱-o̱ u-Ru̱ he̱e̱n u̱-do̱m-u̱ hi-u̱r wa. ");
INSERT INTO gel_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","U̱ka it war-tu̱ no̱ u̱r-taku̱n, u̱ da-o̱ u̱m swu̱ru̱g m-waru̱ no̱: A waku̱n no̱mu̱ no̱ bu̱t-tu̱ Rem-su̱ m-Re̱me̱r su̱ o̱o̱ge̱ bam u̱ Rem-su̱ m-Re̱me̱r ne̱, su̱ no̱ o̱nke̱ du̱gu̱-du̱ it, u̱m ko̱nu̱g u̱zu̱ Ru̱-u̱ ya' go̱ ne̱t-u̱ wa u̱r-ko̱b sok. ");
INSERT INTO gel_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","¿U̱m u̱t-sa u̱ da-o̱ u̱zu̱ ne̱t-tu̱ ho̱g zwar-u̱r ri, ko̱ u-Ru̱? ¿Ko̱ sha-mu̱ o̱ro u̱zu̱ ne̱t-to̱ u̱m u̱t-sa to̱ ho̱g re̱me̱r-m ri? A mu̱ne̱ u̱zu̱ u̱m o̱mo̱n u̱t-sa u̱ ne̱t-tu̱ ho̱g re̱me̱r-m ri, u̱m da shu̱'u̱te̱ to̱k-u̱ Kiristi da. ");
INSERT INTO gel_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","U̱ da-o̱ u̱m u̱t-sa no̱ nap o̱r-u̱t ri ne̱, u̱zu̱ Rem-su̱ m-Re̱me̱r su̱ u̱m no̱mu̱ no̱ a du̱gu̱-du̱ ne̱t de̱ se̱ rwu̱u̱ne̱ da. ");
INSERT INTO gel_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","U̱m kab-u̱g se̱ du̱gu̱-du̱ waku̱n ne̱t wa da, ko̱ waku̱n wa iise̱ me̱ da. Ye̱so̱ Kiristi wa hi-u̱r wa kwu̱re̱ se̱ rem-se̱ u̱du̱ ri. ");
INSERT INTO gel_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","Remu̱ no̱ ho̱k u̱ka u̱m o̱tte̱ u̱r-yu̱ da-u̱ u̱m o̱o̱ge̱ do̱rru̱ fu̱n-yu̱ Yahuda-ne̱. U̱m yaag a-doru̱ Ye̱so̱ i o̱o̱ge̱ ne̱t-tu̱ u-Ru̱ u̱r-ko̱b so̱k. U̱m no̱ng no̱mu̱ u̱m do̱'e̱ u̱t-ker u̱m ho̱ru̱sse̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","U̱m o̱o̱g u̱-shu̱ o̱r-u̱t ri ne̱ u-tát i o̱o̱ge̱ u̱s-hak u̱s-gan u̱ me̱ ne̱ u̱ do̱rru̱ fu̱n-yu̱ Yahuda-ne̱. Rem u̱zu̱ u̱m wa'ag jab sok u̱ do̱rru̱ kim-su̱ u̱so-tu̱ u̱so-u̱t ri ne̱. ");
INSERT INTO gel_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","Se̱di kanda na mat me̱, Ru̱-u dak me̱ tu̱msu̱ wa fu̱g me̱ remu̱ nya-u wa. Tu̱msu̱ Ru̱-u̱ hog u̱r-zwar, ");
INSERT INTO gel_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","u̱zu̱ wa ko̱se̱ Wa'-u̱ wa u̱du̱ ri rem u̱m no̱m-u̱t bu̱t-tu̱ Rem-su̱ m-Re̱me̱r su̱ mo̱t-u̱t wa u̱-me̱ a-za Yahuda-ne̱. Da-u̱ no̱m-u̱t to̱ no̱me̱ u̱m shu̱k-u̱t waku̱n ne̱t wa mo̱ttu̱ no̱m-u̱ to̱ o̱o̱ge̱ u̱t-zu̱ u̱t-be̱e̱t ko̱ no̱m-u̱ u̱m do̱'e̱ u̱t-no̱m da. ");
INSERT INTO gel_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","Tu̱msu̱ u̱m haag u̱ Urusharima re̱mu̱ u̱m shit a-to̱mu̱ Ye̱so̱ i ba'e̱ me̱ m-haan da. Se̱di u̱m aru̱k m-ha dak-u̱ Arabiya tu̱msu̱ da tase̱ u̱m mu̱u̱n u̱-me̱ bo̱-u̱ Dimaku. ");
INSERT INTO gel_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","Se̱ da-u̱ hak-su̱ u̱s-tu̱t arke̱ u̱m aru̱k m-ha Urusharima rem u̱m nu̱pu̱t Biturus, tu̱msu̱ u̱m shu̱'u̱t u̱ wa ne̱ m-roog o̱p u̱t-tan. ");
INSERT INTO gel_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","Se̱di u̱m hyanu̱g waku̱n u̱ te̱k-u̱ a-to̱mu̱ Ye̱so̱ u̱ da-u o̱ da se̱di Yakubu hu̱u̱b u̱r-matu̱ Wa-ko-uyan. ");
INSERT INTO gel_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","U̱m o̱ warru̱ no̱ u̱t-nip u̱-shu̱ u-Ru̱, no̱m-u̱ u̱m o̱o̱ge̱ panu̱ no̱ a bi-se̱ da. ");
INSERT INTO gel_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","Da tase̱ u̱m aru̱k m-ha gas-su̱ Suriya u̱ Kirikiya ne̱. ");
INSERT INTO gel_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","Se̱di a-doru̱ Ye̱so̱ ne̱ i o̱o̱ge̱ gas-u̱ Yahudiya e̱ tamu̱g hyan-du̱ me̱ u̱r-is u̱ u̱r-is ne̱ da. ");
INSERT INTO gel_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","E̱ ho̱k kyak u̱ mo̱t-u̱t ri ne̱ u̱zu̱: <<Burus, wu̱ o̱o̱ge̱ da-u o̱ m-ya in u̱r-ko̱b wa o̱o̱ge̱ da-o̱ u̱ bu̱t-tu̱ Rem-su̱ m-Re̱me̱r su̱ yadu̱ jab su̱ wa o̱o̱ge̱ u̱t-sa wa ho̱ru̱sse̱.>> ");
INSERT INTO gel_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","Tu̱msu̱ e̱ no̱nge̱ u-Ru̱ u̱t-vam u̱ remu̱ ri. ");
INSERT INTO gel_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","Se̱di da-u̱ hak-su̱ o̱p u̱s-nas arke̱, u̱m sur m-ha Urusharima, uno̱ da-o̱ u̱ Baraba ne̱. U̱m ku̱b Titus tu̱msu̱. ");
INSERT INTO gel_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","U̱m haag u̱ ku̱n re̱mu̱ zu̱ Ru̱-u̱ ko̱sku̱ me̱ u-hyan u̱zu̱ u̱m do̱'e̱. Da-u̱ u̱m o̱o̱ge̱ ku̱n u̱m shu̱'u̱te̱ m-yasa u̱ tu̱-shu̱ a-doru̱ Ye̱so̱ ne̱, tu̱msu̱ u̱m yu̱' e̱ zu̱n-mu̱ Rem-su̱ m-Re̱me̱r su̱ u̱m o̱o̱ge̱ bu̱t-tu̱ se̱ u̱ te̱k-u̱ i za-yahuda-ne̱. U̱m o̱o̱g u̱m cwang u̱zu̱ hi-u̱t it u̱ u̱n ne̱ o̱ u̱r-be u̱r-gan, remu̱ u-gye̱r u̱ shu̱'u̱t u̱zu̱ ank-m ri u̱ da-u̱ ar-ke̱ u̱ uno̱ da-o̱ ne̱ o̱o̱g m-zan da. ");
INSERT INTO gel_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","Se̱di Titus wu̱ o̱o̱ge̱ u̱r-kot u̱ me̱ ne̱, ko̱ ba shu̱'u̱te̱ u̱zu̱ wa ne̱t-u̱ wa-za-Yahuda wa, tu̱-shu̱ wa'ag wa no̱m u̱r-pe̱s za wa cwan da. ");
INSERT INTO gel_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","Sin-se̱ rem-se̱ yu̱ngu̱n remu̱ u̱zu̱ to̱ko̱n ne̱t-to̱ tu̱ o̱o̱ge̱ u̱s-bi u̱zu̱ a-dor-ne̱ e̱ o̱o̱ge̱, e̱ cwagu̱n m-yasa rem e̱ got u̱ku̱r u̱ in kume̱ u̱ same̱-du̱ u̱t-hi in u̱ Kiristi Ye̱so̱ ne̱. E̱ u̱t-sa e̱ muut in to̱k-ne̱ u̱du̱ no̱m-du̱ no̱m-u̱ bo̱r-tu̱ Yahuda-ne̱ zu̱ye̱. ");
INSERT INTO gel_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","Se̱di it yaag u̱n u̱r-ke̱r da ko̱ u-da cashi, remu̱ Rem-su̱ m-Re̱me̱r su̱ u̱t-nip se̱ shu̱'u̱t u̱ remu̱ swu̱r-m no̱. ");
INSERT INTO gel_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","Tu̱msu̱ i o̱o̱ge̱ tu̱-shu̱ a-doru̱ Ye̱so̱ e̱ swu̱ru̱g o̱ko̱n u̱-me̱ rem-u̱s ri da. (Shu̱u̱t-u̱r u̱n tu̱-shu̱ zatte̱ mo̱ko̱n swas-mo̱ u̱du̱ ri da, remu̱ zu̱ Ru̱-u̱ ko̱ste̱ m-ku̱u̱k da.) ");
INSERT INTO gel_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","O̱o̱g ba tu̱-shu̱ sur o̱kon u̱ rem-u̱s ri, e̱ nu̱p u̱zu̱ Ru̱-u̱ yaag me̱ ank-mu̱ bu̱t-tu̱ Rem-su̱ m-Re̱me̱r u̱du̱ a-za Yahuda-ne̱, tu̱msu̱ wa yu̱' Biturus ank-mu̱ bu̱t-tu̱ gandi rem-u̱s se̱ u̱du̱ Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","Remu̱ gandi Ru̱-u̱ wa'e̱ Biturus shu̱'u̱t Wa-to̱m-u̱ Ye̱so̱ remu̱ ank-mu̱ u̱t-bu̱t u̱du̱ Yahuda-ne̱, tu̱msu̱ wa wa'e̱ u̱m shu̱'u̱t Wa-to̱m-u̱ Ye̱so̱ u̱du̱ i za-yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","Da-u̱ Yakubu, u̱ Biturus u̱ Yohanna ne̱, i o̱o̱ge̱ tu̱-shu̱ a-doru̱ Ye̱so̱ ne̱, e̱ nu̱p u̱zu̱ Ru̱-u̱ yaag me̱ uno̱ nya-o̱. E̱ so u̱t-kom u̱ Baraba ne̱ u̱ me̱ ne̱. E̱ ees u̱zu̱ it de'e̱ u̱ it no̱m m-ank u̱du̱ i za-yahuda-ne̱, tu̱msu̱ e̱ no̱m m-ank u̱-me̱ Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","No̱m-u̱ u̱n ko̱ne̱ it u̱ war-o̱ u̱zu̱ it re̱ u-shu̱ u̱ gwat-du̱ I o̱o̱ge̱ u̱r-ko̱b, no̱m-u̱ u̱m o̱o̱ge̱ u̱ssa u̱zu̱ u̱m no̱mo̱g u-da u-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","Se̱di da-u̱ Biturus haane̱ bo̱-u̱ Antakiya, u̱m baste̱ wu̱n u̱-shu̱ a-dor-ne̱, remu̱ u̱zu̱ no̱m-u wa o̱o̱g u̱t-no̱m o̱ za ho̱n-ho̱n da. ");
INSERT INTO gel_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","Remu̱ da-u̱ wa teene̱ u̱r-taku̱n, wa o̱o̱g m-re̱ no̱m u̱t-re̱ u̱ i za-Yahuda-ne̱. Se̱di a tase̱, da-u̱ to̱ko̱n ne̱t-to̱ haan du̱gu̱-du̱ Yakubu, wa he̱e̱se̱ mu̱u̱du̱ u-dim tu̱msu̱ wa mot hi-u̱r wa du̱gu̱-du̱ u̱n. Wa o̱ gye̱r-u̱ Yahuda-ne̱ i zu̱ye̱ se̱ na no̱ngu̱ i za-yahuda-ne̱ da u̱r-pe̱s. ");
INSERT INTO gel_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","Tu̱msu̱ Yahuda-ne̱ u-tát e̱ same̱ u̱t-hi u̱ ha-mu̱ u̱r-no̱ wu̱n ne̱, ko̱ Baraba hi-u̱r wa u̱n e̱ngu̱sse̱ wa tu̱msu̱ wa dor u̱n u̱ ha-mu̱ u̱r-no̱ u̱n ne̱. ");
INSERT INTO gel_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","Da-u̱ u̱m hyane̱ u̱n yakke̱ do̱rru̱ fu̱n-yu̱ u̱t-nip yu̱ Rem-su̱ m-Re̱me̱r, u̱m zu̱ Biturus u-shu̱ ko̱wan, <<Bo̱ ne̱t-u̱ Yahuda wa, m-ha iya ne̱ bo̱ zaar do̱rru̱ bo̱r-tu̱ Mosa yasu̱ Yahuda-ne̱ da. ¿Re̱-o̱ no̱m-te̱ u̱ da-o̱ bo̱ o̱tte̱ wadu̱ a-za Yahuda-ne̱ e̱ dor bo̱r-tu̱ Yahuda-ne̱?>> ");
INSERT INTO gel_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","Burus re shu̱ u̱t-zu̱ ne̱, <<In Yahuda-ne̱ e̱ u̱du̱ u̱r-mat, za <a-za Yahuda-ne̱ i na foge̱ a-u̱t-ba'as-ne̱ da.> ");
INSERT INTO gel_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","Se̱di in nak u̱zu̱ waku̱n zaar u̱t-shu̱u̱t ho̱n-ho̱n u̱du̱ do̱rru̱ bo̱r-tu̱ Ru̱-u̱ yase̱ Mosa da, se̱di u̱du̱ yadu̱ jab u̱du̱ Ye̱so̱ Kiristi. Tu̱msu̱ in Yahuda-ne̱ i ya'e̱ jab u̱-me̱ Kiristi Ye̱so̱, remu̱ in shu̱'u̱te̱ za u̱t-ba'as u̱du̱ u-Ru̱ u̱ yadu̱ jab ne̱ u̱-me̱ Kiristi, tu̱msu̱ za u̱du̱ do̱rru̱ bo̱r-tu̱ Ru̱-u̱ yase̱ Mosa da. Remu̱ waku̱n zaar u̱t-shu̱u̱t za u̱t-ba'as u̱du̱ do̱rru̱ bo̱r-tu̱ Mosa yasu̱ Yahuda-ne̱ da. ");
INSERT INTO gel_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","<<Se̱di a mu̱ne̱ zu̱ da-u̱ in u̱t-sa in shu̱'u̱t ho̱n-ho̱n u̱du̱ u-Ru̱ u̱-me̱ Kiristi, in bit hi-u̱r in u̱t-ba'as ne̱ sha-mu̱ a-za Yahuda-ne̱, ¿u̱t-shu̱'u̱t u̱zu̱ Kiristi yaag in shiriktin-mu̱ u̱t-ba'as? A-a! Iya-o̱ da! ");
INSERT INTO gel_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","No̱m-u̱ u̱m u̱t-war o̱ u̱zu̱, a-mu̱u̱ne̱ u̱zu̱ u̱m byu̱ru̱g u-dim u̱ do̱rru̱ u̱t-bo̱r remu̱ u̱m shu̱'u̱te̱ ho̱n-ho̱n u̱du̱ u-Ru̱, shu̱'u̱te̱ u̱ka u̱m swu̱ru̱g m-ma ma-u̱ u̱m duuse̱ u̱r-taku̱n. ");
INSERT INTO gel_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","Re̱mu̱ bo̱r-tu̱ ko̱ske̱ me̱ u̱zu̱ u̱m o̱ u̱ka ne̱t-u̱ mare̱ u̱du̱ u̱t-bo̱r, rem iya u̱m o̱ u̱r-yu̱ re̱mu u-Ru̱, shu̱'u̱te̱ u̱ka zu̱ na taru̱g me̱ u-do̱m u-kan u̱r-ko̱t u̱ Ye̱so̱ Kiristi ne̱ u̱-do̱m u-kan. ");
INSERT INTO gel_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","Remu̱ da-o̱, u̱m zamu̱n u̱r-yu̱ da, se̱di Kiristi wa o̱o̱ge̱ u̱r-yu̱ u-me̱ ri. Tu̱msu̱ u̱ka u̱m o̱tte̱ u̱r-yu̱ u̱ uno̱ war-u̱ u-dak o̱, u̱m o̱ yu̱-du̱ fat-u̱r ri u̱du̱ yadu̱ jab u̱du̱ Wa' u-Ru̱, wu̱ cwane̱ me̱ tu̱msu̱ wa yase̱ hi-u̱r wa remu̱ ri. ");
INSERT INTO gel_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","U̱m muute̱ nya u-Ru̱ m-zan da. Remu̱ a-mu̱u̱ne̱ u̱zu̱ do̱rru̱ bo̱r-tu̱ Ru̱-u̱ yase̱ Mosa in shu̱'u̱t za u̱t-ba'as u̱du̱ u-Ru̱, shu̱'u̱te̱ u̱zu̱ Kiristi maru̱g m-zan!>> ");
INSERT INTO gel_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","No̱ ragne̱ Garatiya-ne̱! ¿Wana e̱ngu̱sse̱ jab-u̱s no̱? Remu̱ u̱m wargu̱ no̱ m-zu̱n mo̱ttu̱ mar-m Ye̱so̱ Kiristi u̱-do̱m u-kan. ");
INSERT INTO gel_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","Waru̱n me̱ u-no̱m u-gan: Ko̱ no̱ o̱nkte̱ Yar u-He̱n remu̱ do̱rru̱ u̱t-bo̱r tu̱ Yahuda-ne̱, ¿ko̱ remu̱ ya-du̱ jab u̱-me̱ rem-su̱ no̱ ho̱ge̱ u̱ mo̱t-u̱t Ye̱so̱ Kiristi ne̱? ");
INSERT INTO gel_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","¿Yan o̱ wu̱te̱ no̱ o̱tte̱ m-rag ne̱ u-tát? Ba no̱ tak-ne̱ u̱ Yar u-He̱n, ¿yan-o̱ wu̱te̱ no̱ otte̱ u̱t-sa no̱ vaste̱ ank-mu̱ u-Ru̱ u̱ be̱b-du̱ u-war? ");
INSERT INTO gel_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","¿Ko̱b-du̱ no̱ swaye̱ u-tát du̱ m-zan de̱? Za u-sakna o̱ da shu̱'u̱t o̱ku̱n no̱mo̱! ");
INSERT INTO gel_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","¿U̱m o̱ shu̱t-du̱ no̱ tu̱msu̱, u̱t-shu̱'u̱t u̱zu̱ Ru̱-u̱ yaag no̱ Yar u-He̱n u̱ ank-mu̱ no̱m-tu̱ m-shin u̱ te̱k-u̱ no̱ remu̱ zu̱ no̱ do̱ro̱g u̱t-bo̱r? Iya-o̱ da! Wa yaag no̱ remu̱ u̱zu̱ no̱ yaag jab-u̱ re̱m-su̱ no̱ ho̱ge̱ u̱ mo̱t-u̱t Kiristi ne̱. ");
INSERT INTO gel_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","Gwat Ibrahi: <<Wa yaag jab u̱du̱ u-Ru̱ tu̱msu̱ Ru̱-u̱ og wu̱n ne̱t ho̱n-ho̱n.>> ");
INSERT INTO gel_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","No̱ nap u̱zu̱, ya'ag-u̱ Ibrahi i u̱t-nip e̱ o̱o̱ge̱ i ya'e̱ jab u̱du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","Tu̱msu̱ remu̱ Ran-u̱ u-Ru̱, Ru̱-u̱ zu̱u̱g Ibrahi da-u̱ dim u̱zu̱, a-za Yahuda-ne̱ do̱'e̱ u̱t-shu̱'u̱t ho̱n-ho̱n u̱du̱ u-Ru̱ remu̱ yadu̱ jab-u̱ e̱ u̱du̱ wa. Ru̱-u̱ zu̱ Ibrahi: <<Ne̱t-tu̱ u̱t-dak u̱t-be̱e̱t e̱ do̱'e̱ kwu̱m-du̱ nu-u so̱-o̱ du̱gu̱-du̱ ró.>> ");
INSERT INTO gel_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","Remu̱ iya, i wa'e̱ yadu̱ jab-u̱s e̱ u̱du̱ Kiristi e̱ kwu̱mu̱g gandi nu-u so̱-o̱ u̱ Ibrahi o̱nke̱ remu̱ yadu̱ jab-u̱ wa. ");
INSERT INTO gel_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","Ko̱wana wu̱ to̱ste̱ u̱du̱ do̱rru̱ u̱t-bo̱r u̱ remu̱ wa muute̱ hi-u̱r wa ho̱n-ho̱n u̱du̱ u-Ru̱ wa o̱ u̱r-yu̱ u̱-me̱ nu-u yo̱-o̱. Remu̱ zu̱ o̱ m-pan u̱-me̱ Ran-u̱ u-Ru̱: <<Ko̱wana wu̱ gu̱gme̱ re̱-du̱ u-shu̱ u̱ no̱m-du̱ ko-uyan u̱ o̱o̱ge̱ m-pan u̱-me̱ ran u-bo̱r wa o̱ u̱ nu-u yo̱-o̱ ne̱!>> ");
INSERT INTO gel_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","O̱ m-zu̱n u̱zu̱ waku̱n zaar u̱t-shu̱'u̱t ho̱n-ho̱n u̱du̱ u-Ru̱ remu̱ do̱rru̱ u̱t-bo̱r da. U̱m zu̱u̱g inya remu̱ o̱ m-pan u̱-me̱ Ran-u̱ u-Ru̱: <<Se̱ remu̱ yadu̱ jab ne̱t o̱ ho̱n-ho̱n de̱te̱ u̱r-fat.>> ");
INSERT INTO gel_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","Inya fu̱n-yu̱ yadu̱ jab ya zaar u̱s-gan u̱ fu̱n-yu̱ u̱t-bo̱r ne̱ da, yu̱ zu̱ye̱, <<Se̱ u̱du̱ do̱rru̱ u̱t-bo̱r de̱ ne̱t do̱te̱ kwu̱m-du̱ u̱r-fat.>> ");
INSERT INTO gel_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","Se̱di Kiristi gwu̱u̱g in du̱gu̱ nu-u yo̱-o̱ u̱ u-bo̱r du̱ wa shu̱'u̱te̱ nu-u yo̱-o̱ remu̱ in. Rem u̱zu̱ o̱ m-pan u̱-me̱ Ran-u̱ u-Ru̱: <<Nu-u yo̱-o̱ u̱du̱ ko̱wana na tare̱ do̱m u-te.>> ");
INSERT INTO gel_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","Wa gwu̱u̱g in remu̱ nu-u so̱-o̱ u̱ Ru̱-u̱ ya'e̱ Ibrahi o̱ u̱t-haan u̱du̱ a-za Yahuda-ne̱ remu̱ Kiristi Ye̱so̱. Na no̱ng iya remu̱ in o̱nkte̱ este̱du̱ u̱s-rem du̱ Yar u-Ru̱ remu̱ yadu̱ jab. ");
INSERT INTO gel_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","O̱r-u̱t ri a-dor-ne̱ yage̱ u̱m ya' no̱ sha-mu̱ ko̱du̱he̱ ho̱-de̱. Da-u̱ ne̱t-ne̱ yu̱r wa'e̱ u-kom u-ran e̱ cin u̱s-rem, waku̱n zaar wu̱ do̱'e̱ has-tu̱ se̱ ko̱ wa sur o̱ku̱n da. Iya o̱tte̱ u̱ sin-se̱ rem-se̱. ");
INSERT INTO gel_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","Ru̱-u̱ yaste̱ este̱du̱ u̱s-rem wa u̱du̱ Ibrahi tu̱msu̱ u̱du̱ wa'-u̱ wa ne̱. Napu̱n u̱zu̱ Ran-u̱ zu̱u̱g da <<U̱du̱ ya'ag-u̱ ró>> U̱ka na zu̱ ko̱-u̱t wa. Se̱di, o̱ zu̱u̱g <<U̱du̱ wa'-u̱ ró,>> no̱mu̱ o̱ o̱o̱ge̱ u̱t-war ne̱t gan, u̱du̱ Kiristi. ");
INSERT INTO gel_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","No̱m u̱m o̱o̱ge̱ u̱t-zu̱ ya: Bo̱r-u̱t Mosa, tu̱ haane̱ u̱s-hak u̱t-ko̱k u̱t-nas u̱ hak-su̱ u̱r-shik u̱s-o̱p ba wa no̱me̱ Ibrahi este̱du̱ u̱s-rem, to̱ haste̱ este̱du̱ u̱s-rem su̱ Ru̱-u̱ no̱me̱ m-tumb ne̱ da, remu̱ zu̱ Ru̱-u̱ haste̱ este̱du̱ u̱s-rem wa da. ");
INSERT INTO gel_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","Remu̱ a mu̱ne̱ u̱zu̱ na o̱nk-u̱ o̱g-du̱ u̱r-mat u̱du̱ do̱rru̱ bo̱r-u Mosa, se̱ zaar u̱t-shu̱'u̱t u̱zu̱ u̱ remu̱ este̱du̱ u̱s-rem da. Se̱di Ru̱-u̱ yaste̱ este̱du̱ u̱s-rem u̱ka nya-u̱ m-ho̱s u̱du̱ Ibrahi. ");
INSERT INTO gel_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","¿Rem-u yan-o̱ Ru̱-u̱ ya'aste̱ bo̱r-u̱t Mosa? Wa ya'aste̱ u̱t-bo̱r u̱ remu̱ to̱ ko̱ste̱ u̱t-ne̱t ba'as-u̱t e̱. Se̱di Ru̱-u̱ cu̱nu̱g u̱zu̱ u̱ bo̱r-tu̱ tumb u̱ war-to̱ m-te haan-du̱ wa' wu̱ Ru̱-u̱ nomte̱ este̱du̱ u̱s-rem u̱ mo̱t-u̱t wa. Ru̱-u̱ ya'aste̱ bo̱r-u̱t wa u̱du̱ a-to̱m u-Ru̱ m-ha u̱du̱ Mosa, wu̱ eese̱ te̱k-u̱ u-Ru̱ u̱t-ne̱t ne̱. ");
INSERT INTO gel_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","U̱ da-o̱ wa-u̱r-ees u̱-te̱k o̱tte̱ u̱r-se̱ge̱ a-mu̱u̱ne̱ zu̱ m-zu̱u̱g kir-du̱ u̱t-ne̱t u̱r-gan u̱t-sa e̱ egu̱sse̱ u̱s-rem. Se̱di u-Ru̱, wu̱ o̱o̱ge̱ u-gan, wa no̱ng m-ank u̱ wa-u̱r-ees u̱-te̱k da-u̱ wa yase̱ este̱du̱ u̱s-rem u̱du̱ Ibrahi da. ");
INSERT INTO gel_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","¿Shu̱'u̱te̱ u̱zu̱ bo̱r-tu̱ gu̱gu̱mte̱ este̱du̱ u̱s-rem su̱ Ru̱-u̱ no̱me̱? A'a, iya-o̱ da! Remu̱ a mu̱ne̱ u̱zu̱ bo̱r-u̱t Mosa tu̱ na yaase̱ to̱ keru̱ yadu̱ u̱r-fat, shu̱'u̱t du̱ ho̱n-ho̱n za haagu̱n du̱gu̱-du̱ u-bo̱r. ");
INSERT INTO gel_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","Se̱di Ran-u̱ u-Ru̱ o̱ u̱t-war u̱zu̱ ba'as-to̱ do̱r-tu̱ u-dak u-be̱e̱t. Remu̱ iya Ru̱-u̱ yu̱ este̱du̱ u̱s-rem su̱ u̱ku̱r u̱du̱ i ya'e̱ jab-u̱ e̱ u̱du̱ Ye̱so̱ Kiristi. ");
INSERT INTO gel_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","Kanda din-de̱ yadu̱ jab haan, in o̱o̱g u̱ me̱n-tu̱ u̱r-tage̱ u̱du̱ do̱rru̱ u-bo̱r. In o̱o̱g u̱r-tage̱ kanda na upse̱ in yadu̱ jab. ");
INSERT INTO gel_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","Remu̱ bo̱r-u̱t o̱o̱g u̱ dor-tu̱ u-dak u-be̱e̱t kanda Kiristi haan. No̱mu̱ wu̱te̱ wa haatu̱n remu̱ na muute̱ in ho̱n-ho̱n u̱du̱ u-Ru̱ remu̱ yadu̱ jab. ");
INSERT INTO gel_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","Se̱di da-o̱ yadu̱ jab haagu̱n, bo̱r-u̱t zamu̱n u̱ dor-tu̱ in da. ");
INSERT INTO gel_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","Remu̱ u̱du̱ same̱-du̱ u̱t-hi no̱ u̱ Kiristi Ye̱so̱ ne̱ ya'ag u-Ru̱ no̱ o̱o̱ge̱ be̱e̱t remu̱ yadu̱ jab. ");
INSERT INTO gel_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","Tu̱msu̱ ne̱t-ne̱ be̱e̱t i same̱ u̱t-hi u̱ Kiristi ne̱ u̱-me̱ u̱t-yu̱bu̱sse̱ m-bu̱ e̱ wa'ag Kiristi u̱ka na wu̱te̱ kus-u̱t po-to̱. ");
INSERT INTO gel_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","Remu̱ i o̱o̱ge̱ same̱-du̱ u̱t-hi u̱ Kiristi ne̱ mo̱ttu̱ Yahuda-ne̱ ko̱ a-za Yahuda-ne̱, to̱k ko̱ za m-to̱k, campa ko̱ ne̱ta to̱ zamu̱n da. Remu̱ no̱ be̱e̱t no̱ shu̱'u̱te̱ u̱s-gan u̱-me̱ Kiristi Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","Tu̱msu̱ a mu̱ne̱ no̱ ne̱t-u̱t Kiristi to̱, no̱ ko̱-u̱r Ibrahi de̱ no̱ o̱o̱ge̱. No̱ do̱'e̱ re̱-du̱ o̱g-du̱ u̱r-mat-u̱ wu̱n. Tu̱msu̱ este̱du̱ u̱s-rem su̱ u-Ru̱ u̱du̱ Ibrahi du̱ no̱ de̱. ");
INSERT INTO gel_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","U̱ da-o̱ no̱m-u̱ u̱m o̱o̱ge̱ u̱t-zu̱ ya: Abite̱ zu̱ wa re̱-du̱ o̱g-du̱ u̱r-mat o̱mo̱n wa'-u̱ re̱k-wa, wa o̱ u̱s-gan u̱ka to̱k, ko̱ u̱zu̱ wa o̱tte̱ ko̱-uyan u̱ u̱so wa o̱tte̱. ");
INSERT INTO gel_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","Tu̱msu̱ ne̱t-tu̱ o̱ro tu̱ gwat-du̱ wa, se̱ wa teeg da-u̱ u̱so wa cine̱. ");
INSERT INTO gel_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","Iya o̱ in o̱tte̱ kanda Kiristi haan. In o̱o̱g sha-mu̱ ya'ag-u̱ re̱k-e̱ in o̱ u̱-me̱ m-to̱k u̱ ta-u̱ yar-u̱t yo̱-to̱ tu̱ o̱o̱ge̱ u̱r-faru̱k du̱ uno̱ dak-o̱. ");
INSERT INTO gel_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","Se̱di da da-u̱ na cine̱ teene̱, Ru̱-u̱ to̱mo̱n Wa'-u̱ wa. Wu̱ ne̱ta mate̱ tu̱msu̱ wa dor bo̱r-tu̱ Ru̱-u̱ yase̱ Mosa. ");
INSERT INTO gel_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","Ru̱-u̱ to̱mo̱n wu̱n remu̱ wa guut ne̱t-u̱t to̱ tu̱ o̱o̱ge̱ do̱rru̱ bo̱r-u̱t Yahuda-ne̱ remu̱ in o̱nkte̱ o̱g-u̱r in du̱ shu̱yi-shu̱yi, u̱ka ya'ag-u̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","Tu̱msu̱ rem u̱zu̱ no̱ ya'ag-u̱ wu̱n ne̱, Ru̱-u̱ to̱mo̱n Yar-u̱ Wa'-u̱ wa u̱-me̱ jab-u̱s in, Yar-u wa wu̱' in fog u-Ru̱, <<U̱so ri! U̱so ri!>> ");
INSERT INTO gel_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","Remu̱ iya, bo̱ zamu̱n to̱k da, se̱di wa'-u̱ u-Ru̱ bo̱ o̱o̱ge̱. Tu̱msu̱ remu̱ u̱zu̱ bo̱ o̱ wa'-u̱ wu̱n, wa wa'ag bo̱ re̱ o̱g-du̱ u̱r-mat-u̱ wa. ");
INSERT INTO gel_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","U̱r-taku̱n, da-u̱ no̱ nape̱ u-Ru̱ da, no̱ o̱o̱g to̱k-ne̱ u̱du̱ ru̱-tu̱ za u̱r-fat. ");
INSERT INTO gel_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","Se̱di u̱ da-o̱ ba no̱ haane̱ u̱-me̱ same̱-du̱ u̱t-hi u̱ u-Ru̱ ne̱ ko̱ u̱m zu̱, Ru̱-u̱ haagu̱n u̱-me̱ same̱-du̱ u̱t-hi u̱ no̱ ne̱, ¿re̱-o̱ no̱ o̱tte̱ u̱t-sa no̱ sur m-mu̱ u-dim tu̱msu̱ no̱ shu̱'u̱t to̱k-ne̱ u̱du̱ yar-tu̱ za u̱r-be̱b tu̱msu̱ tu̱ m-zan tu̱msu̱ u̱du̱ yar-u̱t to̱ ne̱ tu̱ o̱o̱ge̱ u̱r-faru̱k u̱-me̱ uno̱ dak-o̱? ");
INSERT INTO gel_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","No̱ dor to̱ku̱n ho̱-to̱ sok u̱s-pyat ne̱ u̱ u-da ne̱ u̱ u̱s-hak ne̱ u̱ no̱ kum-u̱t hyu̱-m pus-mo̱ u̱du̱ u-Ru. ");
INSERT INTO gel_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","U̱m ho̱k u-gye̱r remu̱ no̱. Jiya pama-u̱s ri u̱ no̱ne̱ o̱o̱g m-zan. ");
INSERT INTO gel_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","U̱m ko̱n-u̱g no̱ o̱r-u̱t ri ne̱, shu̱'u̱tu̱n sha-m ri u̱ka u̱m kumte̱ u̱t-pos du̱gu̱ to̱ no̱m-to̱, remu̱ u̱zu̱ u̱m shu̱'u̱te̱ sha-m no̱ a-za Yahuda-ne̱ i poste̱ du̱gu̱ bo̱r-u̱t to̱. No̱ no̱ngu̱ me̱ no̱m-tu̱ za ho̱n-ho̱n da. ");
INSERT INTO gel_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","No̱ baku̱s u̱zu̱ u̱r-taku̱n remu̱ ko̱b-du̱ m-yar de̱ u̱m no̱mtu̱ no̱ do̱nse̱-du̱ Rem-su̱ m-Re̱me̱r. ");
INSERT INTO gel_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","Tu̱msu̱ ko̱ ba shu̱'u̱te̱ ko̱b-du̱ m-yar ri shu̱'u̱te̱ m-reg u̱du̱ no̱, no̱ ju̱ru̱m me̱ ko̱ no̱ gu̱gu̱m me̱ da. No̱ o̱nkte̱ me̱ tu̱msu̱ no̱ ku̱b me̱ u̱ka u̱zu̱ u̱m o̱ wa-to̱m u-Ru̱, no̱ ku̱b me̱ u̱ka Kiristi Ye̱so̱ hi-u̱r wa. ");
INSERT INTO gel_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","¿Yan-o̱ kume̱ so̱-u̱r no̱ u̱r-be̱e̱t? U̱m nak u̱zu̱ abite̱ o̱o̱g u̱t-no̱me̱, no̱ za hoste̱ is-u̱t no̱ tu̱msu̱ no̱ yase̱ to̱ u̱du̱ ri. ");
INSERT INTO gel_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","¿U̱m shu̱'u̱te̱ hu̱u̱b-u̱ yo̱-o̱ no̱ u̱ da-o̱ remu̱ zu̱ u̱m o̱ waru̱ no̱ u̱t-nip? ");
INSERT INTO gel_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","To̱-to̱ ne̱t-to̱ e̱ku̱ste̱ to̱ ku̱bu̱s jab-u̱s no̱, se̱di no̱m-u̱ u̱n o̱o̱ge̱ zo̱ng-su̱ u̱t-no̱m o̱ zaar so̱-o̱ da. E̱ u̱t-sa e̱ hast no̱ du̱gu̱-du̱ ri remu̱ no̱ muute̱ jab-u̱s no̱ u̱du̱ u̱n. ");
INSERT INTO gel_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","Ko̱ re̱-o̱ nomte̱, o̱tte̱ u̱r-zwar waku̱n ya' jab-u̱ remu̱ no̱mu so̱-o̱, uda u-be̱e̱t, za da-u̱ u̱m o̱o̱ge̱ no̱ne̱ war-o̱ da. ");
INSERT INTO gel_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","Yaag-u̱ ri! U̱ka ne̱ta yu̱ o̱ u̱-me̱ re̱mu̱ me̱n-tu̱ u̱r-mat, iya-o̱ u̱m otte̱ u̱t-swu̱r m-ho̱g gandi go̱-du̱ re̱-mo̱ se̱ Kiristi shu̱u̱g u̱t-rogom u̱-me̱ jab-u̱s no̱. ");
INSERT INTO gel_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","U̱m cwang u̱m haan tu̱msu̱ u̱m shu̱'u̱t u̱r-kot u̱ no̱ ne̱ u̱ da-o̱ tu̱msu̱ u̱m swase̱ cwar-yu̱ u̱s-rem ri, rem u̱zu̱ u̱m e̱ku̱ste̱ mo̱t-u̱t no̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","Waru̱n me̱, no̱ i o̱o̱ge̱ u̱t-sa no̱ shu̱'u̱t u̱ ta-u̱ bo̱r-tu̱ Yahuda-ne̱, ¿no̱ nak no̱m-u̱ bo̱r-tu̱ zu̱ye̱? ");
INSERT INTO gel_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","Ran-u̱ u-Ru̱ o̱ u̱t-zu̱ Ibrahi o̱tte̱ ya'ag yu̱r. Wagan o̱o̱g du̱gu̱ to̱k-u̱ ne̱ta, tu̱msu̱ wagan o̱o̱g du̱gu̱-du̱ ne̱ta wu̱ zaare̱ me̱ m-to̱k da. ");
INSERT INTO gel_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","Se̱di wa'-u̱ o̱o̱ge̱ du̱gu̱-du̱ to̱k-u̱ ne̱ta na mak-u̱t wa u̱ka na vette̱; se̱di wu̱ na mate̱ du̱gu̱-du̱ ne̱ta wu̱ zaare̱ me̱ m-to̱k da wa o̱o̱g u̱ka shu̱-du̱ este̱du̱ u̱s-rem su̱ u-Ru̱ u̱du̱ Ibrahi. ");
INSERT INTO gel_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","Ne̱ta-u̱t tun-to̱ u̱t-yu̱r to̱ o̱ sha-mu̱ este̱du̱ u̱s-rem su̱ u-Ru̱ u̱s-yu̱r. Hajaratu, wa o̱ u̱ka Ro̱r-du̱ Sinai be-du̱ ne̱t-tu̱ o̱nkte̱ bo̱r-tu̱ Yahuda-ne̱, tu̱ mute̱ e̱ to̱k-ne̱. ");
INSERT INTO gel_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","U̱ da-o̱ Hajaratu o̱ ees-mu̱ Ro̱r-du̱ Sinai u̱-me̱ dak-u̱ Arabiya, tu̱msu̱ ees-mu̱ Urusharima u̱ ya-o̱. Remu̱ wa o̱ u̱-me̱ m-to̱k u̱du̱ u-bo̱r u̱r-kot u̱ yaag-u̱ wa ne̱. ");
INSERT INTO gel_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","Se̱di unwa jit ne̱ta wa, Saratu, wa o̱ ees-mu̱ Urusharima u̱ o̱o̱ge̱ u̱-do̱m u-ru̱. Wa zaar me̱ m-to̱k da tu̱msu̱ wa o̱ sha-mu̱ ino̱-u in. ");
INSERT INTO gel_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","Remu̱ zu̱ o̱ m-pan: <<No̱m u̱r-so̱, ne̱ta za u̱r-mat, wu̱ mate̱ ya'ag da. No̱m u̱t-jar m-yat, wu̱ tame̱ nap-du̱ re̱mu̱ u̱r-mat da. Remu̱ u̱zu̱ ne̱ta wu̱ campa wa gu̱gme̱, u̱ da-o̱ wa o̱tte̱ ya'ag, m-ze̱g wu̱ o̱o̱ge̱ u̱r-yu̱ e̱ campa wa.>> ");
INSERT INTO gel_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","Tu̱msu̱ da-o̱ no̱ o̱r-u̱t ri ne̱, no̱ o̱ ya'ag i na mate̱ sha-mu̱ shu̱-du̱ este̱du̱ u̱s-rem su̱ u-Ru̱, u̱ka Ishaku. ");
INSERT INTO gel_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","Se̱di u̱ da-u o̱ wa' wu̱ na mate̱ u̱ka na vette̱ wa yu̱' wa'-u̱ na mate̱ u̱du̱ be̱b-du̱ u-yar u̱r-ko̱b. Gandi no̱m-u̱t to̱ o̱o̱ge̱ m-da u̱ da-o̱. ");
INSERT INTO gel_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","Se̱di ¿yan-o̱ Ran-u̱ u-Ru̱ zu̱ye̱ u̱ mo̱t-tu̱ iya ne̱? <<Buz to̱k-u̱ ne̱ta-u ya u̱ wa'-u̱ wa ne̱. Rem u̱zu̱ wa'-u̱ to̱k-u̱ ne̱ta wa zaar u̱ re̱-du̱ o̱g-du̱ u̱r-mat-u̱ wa'-u̱ ne̱ta wu̱ zaare̱ m-to̱k da.>> ");
INSERT INTO gel_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","Remu̱ iya o̱r-u̱t ri ne̱, in zaar ya'ag-u̱ to̱k-u̱ ne̱ta da, se̱di ya'ag-u̱ ne̱ta yu̱ zaare̱ me̱ m-to̱k da. ");
INSERT INTO gel_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","Kiristi ruute̱ in remu̱ in shu̱'u̱te̱ i na ruute̱ u̱t-nip. Se̱ no̱ ees u̱r-be̱b ne̱ u̱-me̱ yadu̱ hi-u̱t no̱, tu̱msu̱ a no̱ shu̱'u̱t to̱k-ne̱ u̱du̱ do̱rru̱ bo̱r-u̱t Yahuda-ne̱ da. ");
INSERT INTO gel_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","E̱re̱n! Me̱, Burus, u̱m o̱ waru̱ no̱ iya: A no̱ to̱ste̱ jab-u̱s no̱ u̱du̱ no̱m-du̱ u̱r-pe̱s u̱ remu̱ no̱ shu̱'u̱te̱ ho̱n-ho̱n u̱du̱ u-Ru̱, se̱di shu̱'u̱te̱ u̱zu̱ no̱m-u̱ Kiristi no̱me̱ remu̱ no̱ zatte̱ mo̱ko̱n swu̱r-mo̱ u̱du̱ no̱ da. ");
INSERT INTO gel_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","Tu̱msu̱ u̱m do̱'e̱ u̱t-sur waru̱ no̱ ko̱wana yage̱ na no̱mu̱ wa u̱r-pe̱s, se̱ wa do̱ro̱g no̱mu̱ bo̱r-u̱t Yahuda-ne̱ zu̱ye̱ u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","Tu̱msu̱ a no̱ o̱o̱ge̱ u̱t-sa no̱ no̱m ho̱n-ho̱n u̱-shu̱ u-Ru̱ u̱du̱ do̱rru̱ u-bo̱r, no̱ kupu̱ste̱ hi-u̱r no̱ du̱gu̱-du̱ same̱-du̱ u̱t-hi no̱ u̱ Kiristi ne̱. No̱ byu̱ru̱g shin-u̱t no̱ du̱gu̱-du̱ nya-u̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","Se̱di u̱du̱ in, Yar-o̱ yu̱'e̱ in u̱r-be̱b in o̱ wadu̱ jab u̱-me̱ yadu̱ jab tu̱msu̱ u̱du̱ shu̱'u̱t-du̱ jab-u̱ so̱-o̱ u̱ u-Ru̱ no̱me̱ in este̱du̱ u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","Remu̱ da-u̱ in o̱o̱ge̱ same̱-du̱ u̱t-hi u̱ Kiristi Ye̱so̱, u̱r-pe̱s ko̱ ko̱b-du̱ u̱r-pe̱s zatte̱ mo̱ko̱n swu̱r-mo̱ da. No̱m-u̱ na o̱o̱ge̱ u̱t-gwat u̱ war-o̱ yadu̱ jab-u̱ o̱ ko̱se̱ hi-u̱r o̱ u̱du̱ u̱t-cwan. ");
INSERT INTO gel_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","No̱ o̱o̱g u̱ so̱m-mu̱ maga u̱ka ku̱mte̱, ¿wana kupse̱ no̱ u-fu̱n du̱gu̱ do̱rru̱ u̱t-nip? ");
INSERT INTO gel_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","U-Ru̱, wu̱ dage̱ no̱, a wa wa'e̱ no̱ nom-u̱t go̱-du̱ se̱ dorogse̱ da! ");
INSERT INTO gel_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","Tun-to̱ ko̱se̱-tu̱ u̱s-bi to̱ o̱ sha-mu̱ <<yisti cashi mo̱ wu̱' u̱r-tu̱ng u̱r-be̱e̱t de̱ yu̱ne̱.>> ");
INSERT INTO gel_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","U̱m to̱ste̱ jab u̱du̱ Wa-ko-uyan u̱zu̱ wa do̱'e̱ e̱'-du̱ no̱ du̱gu̱ do̱rru̱ ko̱se̱-tu̱ u̱s-bi. Se̱di Ru̱-u̱ do̱'e̱ no̱mu̱ ne̱t wa kwu̱p-du̱ u̱s-rem, wu̱ o̱o̱ge̱ e̱ngu̱sse̱ no̱. ");
INSERT INTO gel_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","U̱ da-o̱ o̱r-u̱t ri ne̱, a mu̱ne̱ u̱zu̱ u̱m o̱mo̱n u̱t-bu̱t u̱zu̱ se̱ na no̱ngu̱ no̱ u̱r-pe̱s, ¿yan-o̱ wa-e̱ na o̱mton u̱ yadu̱ me̱ u̱r-ko̱b? A mu̱ne̱ u̱zu̱ u̱m o̱ u̱t-ko̱se̱ u̱zu̱ se̱ na no̱nge̱ i ya'e̱ jab u̱r-pe̱s, ne̱t-tu̱ za hok-u̱t ryab-su̱ mo̱ttu̱ bu̱t-tu̱ rem-su̱ u-kan da. ");
INSERT INTO gel_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","U̱m cwang u̱zu̱ a-yu̱nsu̱ u̱s-jab ne̱ i o̱o̱ge̱ u̱ssa e̱ ho̱nsu̱ no̱ u̱r-pe̱s u̱zu̱ e̱ no̱mu̱ hi-u̱r e̱ u̱r-vu. ");
INSERT INTO gel_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","Remu̱ na fak no̱ u̱ no̱ no̱m u̱r-yu̱ u̱-me̱ u-u̱ku̱r o̱r-u̱t ri ne̱. Se̱di a no̱ yage̱ u̱ku̱r u̱ no̱ kume̱ o̱ shu̱'u̱t ke̱rru̱ yage̱-du̱ cwan-tu̱ u-waru̱ no̱ du̱u̱t no̱ da. Se̱di no̱mo̱n m-ank u̱ u̱ku̱r-u̱ no̱ kume̱ no̱ no̱me̱ o̱r-u̱t no̱ ne̱ u̱s-pama u-me̱ u̱t-cwan. ");
INSERT INTO gel_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","Remu̱ bo̱r-u̱t Yahuda-ne̱ na samge̱ to̱ u̱t-be̱e̱t u̱-me̱ u-bo̱r u-gan: <<Cwan ko̱wan u̱ka bo̱ tonte̱ hi-u̱r ró.>> ");
INSERT INTO gel_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","Se̱di a no̱ u̱t-no̱m sha-mu̱ u̱t-bisa, u̱ tu̱du̱ o̱r-u̱t no̱ ne̱ tu̱msu̱ u̱ ho̱nsu̱ e̱ ne̱, gwatu̱n sok, tass no̱ ho̱ru̱sse̱ o̱r-u̱t no̱ ne̱ da. ");
INSERT INTO gel_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","Se̱di u̱m o̱ u̱t-zu̱, yagu̱n u̱ Yar-u̱ du̱u̱t fat-u̱t no̱. A no̱ no̱me̱ iya, no̱ zaar u̱ shu̱ksu̱ cwan-tu̱ u-war u̱ no̱. ");
INSERT INTO gel_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","Remu̱ zu̱ cwan-tu̱ u-waru̱ no̱ ton no̱m-u̱ Yar-u̱ u-Ru̱ zare̱ u̱t-sa da, tu̱msu̱ Yar-u̱ u-Ru̱ ton no̱m-u̱ cwan-tu̱ u-waru̱ no̱ tonte̱ da. Tunto̱ no̱m-to̱ u̱t-yu̱r to̱ o̱ m-dum o̱r-u̱t e̱ ne̱, tass bo̱ no̱m no̱m-u̱ cwan-tu̱ u-war u̱ no̱ u̱t-sa da. ");
INSERT INTO gel_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","Se̱di a no̱ no̱me̱ no̱m-u̱ Yar-u̱ waru̱ no̱, no̱ zamu̱n u̱ ta-u̱ ko̱se̱-tu̱ bo̱r-u̱t Yahuda-ne̱ da. ");
INSERT INTO gel_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","U̱ da-o̱ ank-mu̱ ba'as-tu̱ u-war o̱ m-zu̱n. To̱ o̱: M-o̱, Ko̱b-du̱ u-he̱n, Cwan-tu̱ ho̱g-du̱ re̱me̱r-mu̱ u-war, ");
INSERT INTO gel_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","Do̱rru̱ ru̱-tu̱ zare̱ u̱r-fat, M-bo̱n ne̱, U̱t-gu̱gu̱m ne̱, U-har ne̱, U̱r-shu̱b ne̱, U̱ du̱u̱s-du̱ jab ne̱, U̱ cwan-tu̱ m-ze̱g ne̱, U̱ ko̱b-du̱ shu̱'u̱t-du̱ m-yar ne̱, U̱ mo̱t-du̱ u̱t-hi ne̱, ");
INSERT INTO gel_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","shu̱b-du̱ re̱ u-shu̱ e̱ke̱n, U̱ swa ne̱, Cwan-tu̱ mo̱ro̱g-du̱ m-zan ne̱, U̱ to̱ko̱n no̱m-u̱t yo̱-to̱ ne̱. U̱m o̱ no̱mu̱ no̱ u̱t-him u̱ka u̱m no̱mtu̱ no̱ u̱r-taku̱n, ko̱wana o̱ no̱m-du̱ go̱-du̱ to̱ no̱m-to̱ wa za re̱-du̱ o̱g-du̱ Faru̱k-du̱ u-Ru̱ da. ");
INSERT INTO gel_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","Se̱di Yar-u̱ mu̱t go̱-du̱ tun-to̱ no̱m-to̱ u̱-me̱ fat-u̱t in: U̱t-cwan, U̱r-so̱ ne̱, Ru̱s-du̱ jab ne̱, Gag-du̱ jab ne̱, U̱r-o̱n ne̱, No̱m-du̱ no̱m-u̱t so̱-to̱ ne̱, Yadu̱ jab ne̱, ");
INSERT INTO gel_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","Swu̱u̱mse̱ du̱ u̱r-hi, U̱ shu̱pdu̱ u̱r-hi ne̱. Bo̱r-yu̱ zaar yu̱ do̱'e̱ u̱t-zu̱ a ne̱t-tu̱ no̱m no̱m-to̱ da. ");
INSERT INTO gel_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","Tu̱msu̱ i o̱o̱ge̱ i Kiristi Ye̱so̱ e̱ taru̱g cwan-tu̱ ba'as-tu̱ u-war u̱ cwan-tu̱ no̱m-u̱t yo̱-to̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","Ba shu̱'u̱te̱ u̱zu̱ in o̱ u̱r-yu̱ u̱du̱ u-Yar, yage̱ in no̱mo̱n u̱r-no̱k u-me̱ du̱'u̱t-du̱ Yar-u̱. ");
INSERT INTO gel_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","Taas in shu̱'u̱t hi-u̱t yat-to̱ ne̱ da, ko̱ in wa o̱r-u̱t in ne̱ du̱u̱s jab da, ko̱ in no̱m shu̱b-du̱ o̱r-u̱t in ne̱ da. ");
INSERT INTO gel_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","O̱r-u̱t ri ne̱, a ba'as-tu̱ shipe̱ waku̱n, no̱ i Yar-u̱ o̱o̱ge̱ u̱t-du̱'u̱t se̱ no̱ mu̱tu̱n go̱-du̱ ne̱t-u̱ wa u-fu̱n u̱-te̱k u̱t-swu̱u̱mse̱. Se̱di gwatu̱n hi-u̱r no̱ sok, tass no̱ he u̱ gandi go̱-du̱ mo̱ reg-mo̱ da. ");
INSERT INTO gel_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","Kabu̱n no-mu̱ o̱r-u̱t no̱ ne̱, tu̱msu̱ a no̱ no̱me̱ iya no̱ o̱ do̱rru̱ bo̱r-u̱t Kiristi. ");
INSERT INTO gel_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","A waku̱n u̱s-dorog u̱zu̱ o̱ko̱n-o̱ wa o̱o̱ge̱, tu̱msu̱ wa zaar o̱ko̱n da, wa o̱ e̱ngu̱sse̱ hi-u̱r wa. ");
INSERT INTO gel_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","Yage̱ ko̱wan no̱mu̱ hi-u̱r wa m-reg, da-u o̱ wa kere̱ no̱m-du̱ u̱t-u̱k u̱ hi-u̱r wa, a se̱ wa samge̱ hi-u̱r wa u̱ waku̱n ne̱ da. ");
INSERT INTO gel_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","Remu̱ zu̱ kowan do̱'e̱ kabdu̱ no-mu̱ no̱m-u̱ wa no̱me̱. ");
INSERT INTO gel_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","Ko̱wana wu̱ o̱ o̱nk-du̱ u̱t-bo̱r du̱gu̱-du̱ rem-su̱ u-Ru̱ se̱ wa yaag a-u̱t-ko̱se̱ wa ne̱, u̱du̱ mo̱t-du̱ no̱m-u̱t so̱-to̱ wa u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","Taas no̱ e̱ngu̱sse̱ hi-u̱r no̱ da. Waku̱n nomte̱ u-Ru̱ ho̱r da, no̱m-u̱ ne̱t-u̱ kawe̱ o̱ wa do̱'e̱ u̱t-ke̱t. ");
INSERT INTO gel_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","Remu̱ i o̱o̱ge̱ yu̱du̱ ho̱k-su̱ war-tu̱ u̱t-ba'as e̱ m-re̱me̱r e̱ do̱'e̱ ke̱t-du̱ u̱t-zu̱m, u̱ka wa-u̱r-to̱m wu̱ ku̱we̱ go̱ za so̱-ye̱, wa do̱'e̱ ke̱t-du̱ ya-tu̱ za so̱-to̱. Se̱di ne̱t wu̱ o̱o̱ge̱ yu̱du̱ ho̱k-se̱ du̱ u-Yar m-re̱me̱r, wa do̱'e̱ kwu̱m-du̱ fat-du̱ m-mo̱mmo̱ du̱gu̱-du̱ u-Yar, u̱ka wa-u̱r-to̱m wu̱ kawe̱ go̱ so̱-ye̱ wa do̱'e̱ ke̱t-du̱ ya-u̱t so̱-to̱. ");
INSERT INTO gel_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","Se̱di a in pó u̱ no̱m-du̱ no̱m-u̱t so̱-to̱ ne̱ da. Remu̱ da-u̱ kame̱, in do̱'e̱ no̱m-du̱ ke̱t-u̱ so̱-o̱, a in ku̱u̱su̱n da. ");
INSERT INTO gel_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","Remu̱ iya, ko̱dahe̱ in kume̱ u̱r-ke̱r, yage̱ in no̱mu̱ ko̱wan no̱m-u so̱-o̱, hadde̱ i o̱o̱ge̱ me̱ bu-u̱ a-yadu̱ jab ne̱. ");
INSERT INTO gel_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","Gwatu̱n pan-u̱s yasse̱ su̱ u̱m no̱me̱ u̱ka u̱m o̱tte̱ panu̱ no̱ tun-to̱ gom-tu̱ m-vaste̱ u̱ kom-u ri. ");
INSERT INTO gel_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","I o̱o̱ge̱ u̱t-sa e̱ wa no̱ no̱m-du̱ pe̱s-du̱ za cwan e̱ u̱t-sa e̱ke̱n gwat e̱ ne̱t-u̱t so̱-to̱. No̱mu̱ wa'e̱ u̱n no̱m-u̱t iya e̱ zaar u̱t-sa na ya' e̱ u̱r-ko̱b da remu̱ e̱ o̱ no̱m-du̱ u̱t-ko̱se̱ u̱zu̱ mar-m Kiristi u-kan u̱ war-ya na do̱te̱ kwu̱m-du̱ u-u̱ku̱r. ");
INSERT INTO gel_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","Remu̱ i na no̱me̱ u̱r-pe̱s e̱ dor-u̱t u-bo̱r u̱ hi-u̱r e̱ da. Se̱di e̱ u̱t-sa na no̱mu̱ no̱ u̱r-pe̱s ko̱ e̱ no̱m u̱t-u̱k u̱ mo̱ttu̱ do̱rru̱ u̱r-pe̱s no̱. ");
INSERT INTO gel_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","Se̱di me̱, u̱m zatte̱ no̱m-u̱ u̱m do̱'e̱ u̱t-u̱k da se̱ kan-u Wa-ko-uyan in Ye̱so̱ Kiristi. Remu̱ kan-u ya, cwan-u̱t ri remu̱ uno̱ dak-o̱ to̱ maru̱g. Tu̱msu̱ cwan-tu̱ uno̱ dak-o̱ remu̱ ri to̱ maru̱g. ");
INSERT INTO gel_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","U̱r-pe̱s, ko̱ za u̱r-pe̱s o̱ zaar o̱kon no̱m-o̱ da. No̱m-u̱ zu̱ge̱ u̱r-zwar u̱zu̱ Ru̱-u̱ muute̱ in ne̱t-u̱t po-to̱. ");
INSERT INTO gel_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","U̱m no̱ng u̱s-ko̱n Ru̱-u̱ ya' ru̱s-du̱ jab-u̱ u̱r-o̱n ne̱ u̱du̱ i do̱re̱ tun-to̱ ko̱se̱-to̱ be̱e̱t. E̱ o̱ Isra-ne̱ u̱t-nip i u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","M-vaste̱, a waku̱n o̱ e̱kse̱ me̱ u̱ tun-to̱ no̱m-to̱ da. Rem u̱m o̱tte̱ u̱t-ran u̱ war-u ri su̱ ko̱se̱ u̱zu̱ me̱ yu̱ Ye̱so̱ wa u̱m o̱o̱ge̱. ");
INSERT INTO gel_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","O̱r-u̱t ri ne̱, nya-u Wa-ko-uyan in Ye̱so̱ Kiristi o̱ u̱r-kot u̱ yar-u no̱ ne̱. U̱ shu̱'u̱t iya.");
INSERT INTO gel_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","Uno̱ ran-o̱ o̱o̱n du̱gu̱-du̱ Burus, wa-to̱m-u̱ Ye̱so̱ Kiristi remu̱ cite̱ mu̱ u-Ru̱, u̱du̱ ne̱t-tu̱ u-he̱n i o̱ u̱-me̱ bo̱-u̱ Afisa i o̱o̱ge̱ yadu̱ jab u̱-me̱ same̱-du̱ u̱t-hi e̱ u̱ Kiristi Ye̱so̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","U̱m o̱ u̱s-to̱o̱g u̱du̱ u-Ru̱ U̱so-u in, u̱ Wa-ko-uyan Ye̱so̱ Kiristi ne̱, u̱zu̱ wa ya' no̱ u-nya u̱ ru̱s-du̱ jab ne̱. ");
INSERT INTO gel_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","U̱t-vam u̱du̱ u-Ru̱, U̱so-u̱ U̱so-u in Ye̱so̱ Kiristi, wu̱ wa'e̱ in nu-u so̱-o̱ u̱ u̱t-yar ne̱ u̱ ko̱yu̱he̱ fu̱n-ya u̱ wa yu̱te̱ in nu-u so̱-o̱ tu̱ rwu̱ne̱ du̱gu̱ do̱m u-ru̱ remu̱ same̱-du̱ u̱t-hi Kiristi ne̱. ");
INSERT INTO gel_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","Remu̱ wa dak in kanda wa nom do̱m u-ru̱ u-dak ne̱, in shu̱'u̱t u-he̱n ne̱ tu̱msu̱ za u̱r-pyap u̱ shu̱ wa. U̱-me̱ u̱t-cwan, ");
INSERT INTO gel_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","Ru̱-u̱ cu̱nu̱g in shu̱'u̱t ya'ag-u̱ wa remu̱ same̱-du̱ u̱t-hi in u̱ Kiristi Ye̱so̱ ne̱ remu̱ cite̱-m wu̱n u̱ ho̱g-du̱ re̱me̱r-m ne̱. ");
INSERT INTO gel_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","Remu̱ iya in no̱me̱ u-Ru̱ u̱t-vam remu̱ nya-u̱ m-sek u̱ wa ya'e̱ in m-ho̱s remu̱ Wa'-u̱ wa wu̱ wa cwane̱. ");
INSERT INTO gel_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","Ru̱-u̱ rwu̱ru̱g in u̱ hyu̱-m Kiristi, remu̱ same̱-du̱ u̱t-hi in u̱ Kiristi ne̱. In kwu̱mu̱g ho̱du̱ ba'as-u̱t in. Kiristi no̱ng iya remu̱ u̱ tat-u̱ o̱n-du̱ u-Ru̱ u̱du̱ in. ");
INSERT INTO gel_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","Tu̱msu̱ wa ko̱ske̱ in nya-u wa u-tát. Tu̱msu̱ wa wa'ag in shu̱'u̱t u̱s-ve̱r ne̱ tu̱msu̱ in nap ko̱-uyan go̱-tu̱ u̱t-no̱m u̱t-be̱e̱t. ");
INSERT INTO gel_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","Tu̱msu̱ remu̱ zu̱ cikte̱ u-Ru̱, wa ko̱se̱ in zo̱ng-su̱ m-yasa su̱ wa zo̱nge̱ u̱t-no̱m u̱ remu̱ du̱gu̱ no̱m-tu̱ Kiristi de̱ u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","No̱m-u̱ Ru̱-u̱ zo̱nge̱ u̱t-no̱m ya: Ba da-u̱ teye̱, wa zo̱ngte̱ wa haatu̱n ko̱-uyan no̱m-o̱ u̱ do̱m-u̱ u-ru̱ u-dak ne̱ u̱r-koto, u̱du̱ faru̱k Kiristi. ");
INSERT INTO gel_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","Tu̱msu̱ remu̱ zu̱ in samge̱ u̱t-hi u̱ Kiristi ne̱, in kwu̱mu̱g u̱r-o̱g du̱gu̱-du̱ u-Ru̱, remu̱ zu̱ wa dak in du̱gu̱ u̱r-taku̱n, tu̱msu̱ wa wa'ag ko̱-uyan nok ho̱n-ho̱n u̱ka wa zo̱ngte̱ u̱t-no̱m. ");
INSERT INTO gel_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","Ru̱-u̱ zo̱ngte̱ u̱zu̱ it Yahuda-ne̱ i ba'e̱ m-wa jab u̱du̱ Kiristi du̱gu̱ u̱r-taku̱n, in haatu̱n u̱t-vam m-sek ne̱ u̱du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","Tu̱msu̱ no̱ a-za-Yahuda-ne̱, remu̱ same̱-du̱ u̱t-hi u̱ Kiristi ne̱, Ru̱-u̱ yaag no̱ Yar-u̱ u-He̱n, wu̱ wa nomte̱ este̱du̱ u̱s-rem m-tumb ne̱. Na no̱ng iya ba no̱ ho̱ge̱ rem-su̱ u-Ru̱ su̱ u̱t-nip, Rem-su̱ m-Re̱me̱r su̱ u̱ku̱r, da-u̱ no̱ ya'e̱ jab u̱du̱ Kiristi. ");
INSERT INTO gel_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","Ru̱-u̱ yaag in Yar-u wa. Yar-u̱ u-He̱n o̱ o̱o̱ge̱ o̱g-du̱ u̱r-taku̱n du̱ Ru̱-u̱ do̱'e̱ ya-du̱ in. Da-u̱ wa ya'u̱ in Yar-u̱ u-He̱n, uno̱ ko̱ske̱ in u̱zu̱ wa ya'u̱ in no̱m-u̱ wa no̱me̱ in este̱du̱ u̱s-rem. M-vaste̱ wa do̱'e̱ gwu̱-du̱ i o̱o̱ge̱ ne̱t-u̱t wa. Wa no̱ng iya remu̱ vam-tu̱ sek-m wa. ");
INSERT INTO gel_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","Remu̱ iya, du̱gu̱ da-u̱ u̱m ho̱ge̱ yadu̱ jab-u̱ no̱ u̱du̱ Wa-ko-uyan Ye̱so̱ tu̱msu̱ cwan-u̱t no̱ ne̱ remu̱ ne̱t-tu̱ u-Ru̱ u̱t-be̱e̱t, ");
INSERT INTO gel_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","U̱m yakke̱ vam-du̱ u-Ru̱ u̱ remu̱ no̱ da, da-u̱ u̱m bakse̱ u̱ no̱ ne̱ u̱-me̱ to̱o̱g-u̱s ri. ");
INSERT INTO gel_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","U̱m o̱ ko̱n-du̱ u-Ru̱ u̱ Wa-ko-uyan in Kiristi Ye̱so̱ ne̱, U̱so u̱ m-sek, remu̱ se̱ge̱-du̱ Yar-u u-he̱n wa ya' no̱ u̱s-ve̱r u̱ u-hyan ne̱, ko̱ no̱ napu̱ wa u̱ka du̱pke̱. ");
INSERT INTO gel_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","U̱m o̱ u̱s-ko̱n u̱du̱ u-Ru̱ wa u-pus jab-u̱s no̱ ko̱ no̱ napu̱ wadu̱ jab du̱ na fogte̱ no̱, u̱ o̱o̱ge̱ tat-u̱ sek-m wu̱n u̱ wa zo̱nge̱ remu̱ ne̱t-u̱t wa, i o̱ o̱g-u̱r rò. ");
INSERT INTO gel_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","U̱m o̱ u̱s-ko̱n tu̱msu̱ no̱ nap se̱g-mu̱ be̱b-du̱ shin-mu̱ u-Ru̱ mu̱ ze̱ge̱ remu̱ in i ya'e̱ jab u̱du̱ wu̱n. Gandi shin-m mo̱ o̱ u̱s-gan, ");
INSERT INTO gel_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","mo̱ yu̱nse̱ Kiristi du̱gu̱ m-mar, tu̱msu̱ wa shu̱gu̱sse̱ wu̱n u-do̱m u̱ pora-du̱ du̱ sek-mu̱ u-Ru̱ u̱ kom-u̱ u̱s-cwa u-Ru̱ u̱-do̱m u-ru̱ ");
INSERT INTO gel_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","U̱ku̱n Kiristi wa o̱o̱ge̱ u̱r-faru̱k m-ze̱g ko̱tu̱he̱ yar-to̱ tu̱ o̱ u̱r-faru̱k. Tu̱msu̱ wa o̱tte̱ dim-du̱ zege̱ ko̱du̱he̱ dim-de̱ u̱ uno̱ da-o̱ m-ha da-u̱ o̱o̱ne̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","Ru̱-u̱ yaag Kiristi faru̱k-du̱ ko̱-uyan tu̱msu̱ wa wa'ag wu̱n yu̱-shu̱ u̱-do̱mu̱ ko̱-uyan, remu̱ a-doru̱ Ye̱so̱. ");
INSERT INTO gel_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","A-doru̱ Ye̱so̱ e̱ o̱o̱ge̱ i Kiristi, Kiristi wa ya'u̱ o̱ u̱r-fat u-be̱e̱t, wa dorte̱ ko̱-uyan u-be̱e̱t u̱ hi-u̱r wa. ");
INSERT INTO gel_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","Da-u̱ dim no̱ o̱o̱g u̱ka a-za Yahuda-ne̱ remu̱ ba'as-u̱t no̱ u̱ no̱m-u̱t yo̱-to̱ no̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","U̱ ho̱-u̱t to̱ no̱ do̱ro̱g fu̱n-u̱s yo̱-se̱ su̱ u-dak. No̱ do̱ro̱g wu̱ o̱o̱ge̱ u̱r-faru̱k u̱ do̱m-u̱ yar-tu̱ m-mya tu̱ ne̱t-tu̱ hyente̱ da. Wu̱na o̱o̱ge̱ u-yar u̱ o̱o̱ge̱ da-o̱ m-ank u-me̱ jab-su̱ ne̱t-tu̱ gu̱gme̱ do̱rru̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","In be̱e̱t Yahuda-ne̱ tu̱msu̱ in no̱ngo̱n u̱r-yu̱ sha-mu̱ a-za Yahuda-ne̱, u̱ do̱rru̱ cwan-tu̱ u̱t-baas in. In o̱ no̱m-du̱ no̱mu̱ war-u̱t in u̱ jab-u̱s in u̱t-sa in no̱m. Remu̱ iya in wa'ag Ru̱-u̱ hog ryab-u̱s in u̱ka ne̱t-tu̱ kuse̱ i Ru̱-u̱ de̱ no̱mu̱ kwu̱p-du̱ u̱s-rem. ");
INSERT INTO gel_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","Se̱di o̱n-du̱ u-Ru̱ o̱ u-tát, tu̱msu̱ wa cwanu̱g in sok. ");
INSERT INTO gel_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","Ko̱ ba u̱zu̱ in o̱o̱g u̱ka marimari ne̱ remu̱ ba'as-u̱t in, wa yaag in u̱r-fat da-u̱ wa yu̱nse̱ Kiristi du̱gu̱ m-mar. No̱ kwu̱mu̱g u-u̱ku̱r remu̱ nya-u̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","Remu̱ same̱-du̱ u̱t-hi in u̱ Kiristi ne̱, Ru̱-u̱ yu̱nu̱ste̱ in du̱gu̱ m-mar u̱r-koto u̱ Kiristi ne̱, remu̱ in nom-u̱t u̱r-faru̱k u̱r-koto u̱ Kiristi ne̱ u̱ do̱m u-ru̱. ");
INSERT INTO gel_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","Ru̱-u̱ no̱ng iya remu̱ wa ko̱ste̱ ko̱wan da-u̱ de̱ haan, tat-u̱ nya-u wa u̱ zatte̱ u̱t-mu̱gu̱sse̱ da, remu̱ o̱n-u̱r wa du̱ wa ko̱se̱ in, i o̱o̱ge̱ same̱-du̱ u̱t-hi u̱ Kiristi Ye̱so̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","Remu̱ nya-u̱ u-Ru̱ o̱ wu̱te̱ no̱ kum-u̱t u-u̱ku̱r remu̱ yadu̱ jab, za remu̱ be̱b-du̱ hir-u̱r no̱ o̱ da. Ho̱s-mo̱ du̱gu̱-du̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","Ru̱-u̱ u̱ku̱rte̱ no̱ za remu̱ no̱m-u̱t so̱-to̱ tu̱ no̱ no̱me̱ da, remu̱ taas, waku̱n no̱m u̱t-u̱k da. ");
INSERT INTO gel_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","Ru̱-u̱ no̱mo̱g in u̱ka in o̱tte̱. Tu̱msu̱ wa no̱mo̱g in remu̱ same̱-du̱ u̱t-hi in u̱ Kiristi Ye̱so̱ ne̱, remu̱ no̱m-du̱ ank-mu̱ no̱m-u̱t so̱-to̱, no̱mu̱ wa zo̱nge̱ in no̱m du̱gu̱ u̱r-taku̱n. ");
INSERT INTO gel_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","Remu̱ iya baksu̱n u̱zu̱ na maku̱t no̱ a-za Yahuda-ne̱. Tu̱msu̱ i foge̱ hi-u̱r e̱ a-u̱r-pe̱s-ne̱, e̱ o̱ fag-du̱ no̱ a-za-u̱r-pe̱s-ne̱, ko̱ ba shu̱'u̱te̱ u̱zu̱ pe̱s-du̱ u-war de̱, du̱ na nome̱ kom-tu̱ ne̱t. ");
INSERT INTO gel_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","Ho̱to̱ no̱ o̱o̱g m-ra u-Ru̱ ne̱ no̱ o̱o̱g za Kiristi, tu̱msu̱ no̱ o̱o̱g u̱ka ham-u̱t ne̱ u̱-me̱ a-u-dak-ne̱ u̱ Isra. No̱ nak este̱du̱ u̱s-rem su̱ Ru̱-u̱ no̱mu̱ e̱ da. No̱ o̱ u̱r-yu̱ u̱ uno̱ dak-o̱ za u-Ru̱ tu̱msu̱ za wadu̱ jab. ");
INSERT INTO gel_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","Se̱di da-o̱ remu̱ same̱-du̱ u̱t-hi no̱ u̱ Kiristi Ye̱so̱ ne̱, no̱ o̱o̱g m-ra u-Ru̱ ne̱ se̱di da-o̱ Ru̱-u̱ mu̱u̱tu̱n no̱ u̱t-mo̱r u̱ Kiristi ne̱. Wa no̱ng iya remu̱ u̱zu̱ no̱ to̱ste̱ jab u̱-me̱ no̱mu̱ Kiristi shu̱se̱ da-u̱ hyu̱-m wa azge̱ du̱gu̱ war-u wa da-u̱ wa mare̱ u̱ do̱m u-kan. ");
INSERT INTO gel_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","U̱m zu̱u̱g iya remu̱ Kiristi hi-u̱r wa ru̱s-du̱ jab-u̱ in de̱. Wa samge̱ Yahuda-ne̱ u̱ a-za Yahuda-ne̱ u̱ka ne̱t gan remu̱ mar-m wa u̱-do̱m u-kan. Wa hast bo̱r-tu̱ Yahuda-ne̱ ya hatu̱n yu̱-u̱r yo̱-de̱ de̱ du̱ mo̱te̱ Yahuda-ne̱ u̱ a-za Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","Bo̱r-u̱t Yahuda-ne̱ o̱ u-tát, se̱di Kiristi haste̱ to̱ remu̱ mar-m wa. Wa no̱ng iya remu̱ wa no̱mtu̱ hi-u̱r wa ne̱t-u̱t po-to̱, e̱ same̱ u̱t-hi u̱ wa ne̱. Tunto̱ ne̱t-u̱t po-to̱ to̱ dame̱ Yahuda-ne̱ u̱ a-za Yahuda-ne̱ u̱r-koto, remu̱ e̱ no̱m-u̱t shu̱'u̱t-du̱ m-yar. ");
INSERT INTO gel_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","Tu̱msu̱ hen, Kiristi haste̱ bo̱r-u̱t Yahuda-ne̱ remu̱ wa ho̱ngu̱sse̱ Yahuda-ne̱ u̱ a-za Yahuda-ne̱ u̱du̱ u-Ru̱, e̱ shu̱'u̱t ne̱t gan, u̱ wa haste̱ shu̱'u̱t-u̱r yo̱-de̱ u̱ te̱k u-Ru̱ u̱ ne̱t-ne̱ u̱ re̱mu mar-m wa u̱ do̱m u-kan. ");
INSERT INTO gel_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","Kiristi haan wa nom do̱nse̱-du̱ Rem-su̱ m-Re̱me̱r su̱ ru̱s-du̱ jab u̱du̱ no̱ a-za Yahuda-ne̱ i o̱o̱ge̱ m-ra du̱gu̱ u-Ru̱ tu̱msu̱ ru̱s-du̱ jab ne̱ u̱du̱ Yahuda-ne̱ i o̱o̱ge̱ u̱t-mo̱r. ");
INSERT INTO gel_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","Remu̱ du̱gu̱-du̱ wu̱n, in be̱e̱t in kumte̱ u̱r-ke̱r du̱ ha-mu̱ kit-u̱ u-U̱so remu̱ Yar-u u-He̱n u-gan. ");
INSERT INTO gel_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","Remu̱ iya da-o̱ no̱ a-za Yahuda-ne̱ hamu̱t-to̱ no̱ o̱o̱ge̱ da ko̱ ne̱t-tu̱ do̱ da, se̱di no̱ a-u-dak-ne̱ e̱ u̱r-koto u̱ ne̱t-tu̱ u-Ru̱ ne̱ tu̱msu̱ ne̱t-tu̱ bu-u̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","In be̱e̱t a-za Yahuda-ne̱ u̱ Yahuda-ne̱ in o̱ u̱ka u-ma, u̱ na maye̱ u̱-do̱m u̱r-tak du̱ a-to̱mu̱ Ye̱so̱ ne̱ u̱ a-warru̱ rem-su̱ u-Ru̱ ne̱. Tu̱msu̱ taar-du̱ taku̱n-du̱ u-ma Kiristi Ye̱so̱ wa hi-u̱r wa. ");
INSERT INTO gel_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","Na samge̱ in be̱e̱t u̱-me̱ same̱-du̱ u̱t-hi u̱ wu̱n ne̱, u̱ka na nomte̱ u-ma remu̱ in rogom in shu̱'u̱t bu-u u-he̱n u̱s-to̱o̱g be-du̱ Wa-ko-uyan do̱te̱ u̱r-yu̱. ");
INSERT INTO gel_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","Tu̱msu̱ u̱ remu̱ same̱-du̱ u̱t-hi no̱ a-za Yahuda-ne̱ u̱ Yahuda-ne̱ u̱ wu̱n ne̱ o̱ na mu̱te̱ no̱, remu̱ u̱zu̱ no̱ shu̱'u̱te̱ u̱ka be-du̱ du̱ u̱r-shu̱'u̱t du̱ Yar-u u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","U̱ sin-se̱ dorogse̱ ne̱ u jab, me̱, Burus u̱m o̱ no̱mu̱ no̱ u̱s-to̱o̱g, me̱ wu̱ o̱ye̱ wa-m-to̱k-u̱ Kiristi Ye̱so̱ u̱ remu̱ re-u̱ u-shu̱ no̱, a-za Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","Remu̱ u̱m nak za u-sakna u̱zu̱ u̱m o̱o̱g u̱m kabu̱g u̱zu̱ no̱ nak, Ru̱-u̱ yaag me̱ no-mu̱ no̱m-du̱ ank-mu̱ yu̱-du̱ wa-to̱m-u̱ Ye̱so̱, remu̱ re̱-u̱ u-shu̱ no̱ a-za Yahuda-ne̱. ");
INSERT INTO gel_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","Ru̱-u̱ upuste̱ me̱ no̱mu̱ wa zo̱nge̱ u̱t-no̱m m-yasa, u̱ka u̱m pantu̱ no̱ u̱ taku̱n-du̱ ran-u uno̱. ");
INSERT INTO gel_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","Tu̱msu̱ a no̱ karu̱nte̱ no̱mu̱ u̱m panne̱, no̱ u̱t-kere̱ u̱t-nap u̱zu̱ u̱m nak m-zu̱n no̱m-tu̱ m-yasa tu̱ Ru̱-u̱ zo̱nge̱ u̱t-no̱m su̱ mo̱t-u̱t Kiristi. ");
INSERT INTO gel_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","Ru̱-u̱ wargu̱ ne̱t-tu̱ cara-tu̱ arke̱ no̱m-u̱ m-yasa u̱ wa zo̱nge̱ u̱t-no̱m da. Se̱di u̱ da-o̱ wa ko̱ske̱ to̱ remu̱ Yar-u wa u̱du̱ ne̱t-tu̱ wa dage̱ e̱ shu̱'u̱t a-to̱mu̱ Ye̱so̱ u̱ a-warru̱ rem-su̱ u-Ru̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","Tu̱msu̱ no̱m-u̱ Ru̱-u̱ zo̱nge̱ u̱t-no̱m u̱ ya: a-za Yahuda-ne̱ u̱ Yahuda-ne̱, i ya'e̱ jab-u̱ rem-su̱ m-re̱me̱r ne̱, e̱ o̱nkte̱ o̱g-du̱ u̱r-mat ho̱n-ho̱n du̱gu̱-du̱ u-Ru̱. Tu̱msu̱, e̱ o̱ o̱g-tu̱ war-u̱ u-gan, tu̱msu̱ u̱r-koto, e̱ hog re̱me̱r-mu̱ no̱mu̱ Ru̱-u̱ nomte̱ este̱du̱ u̱s-rem, remu̱ same̱-du̱ u̱t-hi e̱ u̱ Kiristi Ye̱so̱ ne̱. ");
INSERT INTO gel_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","U̱m shu̱'u̱te̱ to̱k-u̱ ank-mu̱ rem-su̱ m-re̱me̱r remu̱ nya-u̱ u-Ru̱ ya'u̱ me̱, u̱du̱ wa wu̱te̱ be̱b-u̱r wa de̱ u̱m no̱m m-ank u̱-me̱ ri. ");
INSERT INTO gel_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","Ko̱ ba shu̱'u̱te̱ zu̱ me̱ o̱ u̱r-vaste u̱-me̱ u̱ te̱k-u̱ ne̱t-tu̱ u-Ru̱, Ru̱-u̱ yu̱' me̱ m-mo̱ ank-m yat-mo̱. Wa dak me̱ u̱m shu̱'u̱t wa-warru̱ Rem-su̱ m-Re̱me̱r u̱du̱ a-za Yahuda-ne̱, u̱ mo̱ttu̱ tat-u̱ kwu̱m-tu̱ u-yar u̱ e̱ do̱'e̱ u̱t-kwu̱m u̱du̱ o̱nk-u̱ Kiristi. ");
INSERT INTO gel_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","Tu̱msu̱ na dak me̱ u̱m ya m-zu̱n u̱du̱ ko̱wan u̱ mo̱ttu̱ no̱m-tu̱ m-yasa tu̱ Ru̱-u̱ zo̱nge̱ u̱t-no̱m. Wu̱na no̱me̱ ko̱-uyan tu̱msu̱ wa yakse̱ no̱m-tu̱ m-yasa tu̱ wa zo̱nge̱ du̱gu̱ u̱r-taku̱n. ");
INSERT INTO gel_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","No̱m-u̱ wu̱te̱ Ru̱-u̱ nom-u̱t tun-to̱ no̱m-to̱ u̱t-be̱e̱t remu̱ wa nomot a-doru̱ Ye̱so̱ ne̱ wa ko̱ste̱ tat-u̱ nap-m wa, u̱du̱ u̱t-yar tu̱ o̱o̱ge̱ u̱r-faru̱k u̱-do̱m u-ru̱. ");
INSERT INTO gel_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","Uno̱ o̱ no̱m-u̱ m-mo̱mmo̱ u̱ Ru̱-u̱ zo̱nge̱ u̱t-no̱m, u̱ wa shu̱se̱ remu̱ Kiristi Ye̱so̱ Wa-ko-uyan in. ");
INSERT INTO gel_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","U̱ remu̱ Kiristi tu̱msu̱ u̱ yadu̱ jab-u̱ in ne̱ me̱ wu̱n, in u̱t-kere̱ u̱t-haan za u-gye̱r tu̱msu̱ jab gan u̱-shu̱ u-Ru̱. ");
INSERT INTO gel_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","U̱m o̱ ko̱n-u̱s no̱, a jab-u̱ no̱ ge̱t u̱ remu̱ swadu̱ u̱r-ko̱b u̱ ri da. U̱m o̱ swadu̱ u̱r-ko̱b remu̱ no̱, u̱ o̱o̱ge̱ re̱-u̱ u-shu̱ no̱. ");
INSERT INTO gel_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","Remu̱ no̱m-u̱t to̱ u̱t-be̱e̱t, u̱m he u̱t-jwu̱n u̱m no̱m u̱s-to̱o̱g u̱du̱ U̱so. ");
INSERT 