﻿USE sofia;
DROP TABLE IF EXISTS sofia.geb_vpl;
CREATE TABLE geb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES geb_vpl WRITE;
INSERT INTO geb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Khe Zisas Krais nzɨgi bun nzuai buni khare. Zisas ana Devitan nzɨk ma. Devit ana Abrahaman nzɨk ma. ");
INSERT INTO geb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Aisak tegi, Aisak Zekop tegi. Zekop Zuda gum ntogi tegi. ");
INSERT INTO geb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zuda Peres gu Sara tegi, mani niamuuŋ, ana Tamar tegi. Peres Hesron tegi. Hesron Ram tegi. ");
INSERT INTO geb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram Aminadap tegi. Aminadap Nason tegi. Nason Sarmon tegi. ");
INSERT INTO geb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sarmon Boas tegi, ana niamuuŋ Rahap. Boas Obet tegi. Obet niamuuŋ Rut ma. Obet Zesi tegi. ");
INSERT INTO geb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Zesi Devit tegi. Ana Devit tegim, ana ŋgui vhɨrve gari guman pan kegi. Devit, ana Soromon tegi. Soromon tegi niamuuŋ, ana fhum Uria ga tɨga kegi. ");
INSERT INTO geb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Soromon Rehoboam tegi. Rehoboam Abiza tegim, Abiza Asa tegi. ");
INSERT INTO geb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Zehosafat tegi. Zehosafat Zehoram tegi. Zehoram Usia tegi. ");
INSERT INTO geb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia Zotam tegim, Zotam Ahas tegi. Ahas Hesekia tegi. ");
INSERT INTO geb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia Manase tegi. Manase Emon tegi. Emon Zosaia tegi. ");
INSERT INTO geb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zosaia, ana Zehoiakin gu ntogi tegi. Mba tugen Babironiŋ Isreriŋ shogap mbe ndiga Babironan vegap, mbe ndim bɨna suegim, mbe fhura mben ŋaara gumgi ki. ");
INSERT INTO geb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mba Isreriŋ Babironan bɨnan ki tuge thɨgap, zav, Zehoiakin Seartier tegim, Seartier Serubaber tegi. ");
INSERT INTO geb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubaber Abiut tegi. Abiut Eriakim tegi. Eriakim Asor tegi. ");
INSERT INTO geb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor Sadok tegim, Sadok Akim tegi. Akim Eriut tegi. ");
INSERT INTO geb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eriut Ereasar tegim, Ereasar Matan tegi, Matan Zekop tegi. ");
INSERT INTO geb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zekop Zosep tegi. Zosep Maria man ma. Maria, ana Zisas tegi. Zisas mbe vhɨra kha zɨn ana kaai, Krais, ana Fhe Bakɨme taagip kha nuianan ki gumgi gu mbigi ndir zav farasarigi guma ma. ");
INSERT INTO geb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Maaŋ muuŋgiap, Abrahaman nzɨgi, mbe zav Devit thɨgi, mbe phɨk bavira fethɨgi. Devitan kegap zav, mbe Isreriŋ Babironiŋ mbe shogap, mbe ndiga vov bɨna suegi tugen, Devita nzɨgi vhɨra phɨk bavira fethɨgi. Mbe Babiron bɨnan kav, fhura Babironin ŋgari tugen kega zav, Krais kha nuianan hɨgi tugen, mbe nzɨgi vhɨra phɨk bavira fethɨgi. ");
INSERT INTO geb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Khe Zisas Krais kha nuianan hɨgi ne neŋgi buni khaŋ muuŋgi. Ana niamuuŋ Maria, mbe Zozevan rɨgɨr zav ana ndi fagi. Mbe ana ndi fagim, mani wani ga tɨgi fhuvara. Mbe garim, Maria ndave rɨgi. Fhe Bakɨmen Ŋina Ŋaar nduara mba tarar Maria ndava sarigim, Maria mba tara ndavar ki. ");
INSERT INTO geb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ana man Zosep, ana tɨvir vhuuiŋra zɨn vui guma ma. Maaŋ muuŋgiap, ana Maria mbararagim, ana ndavar kim, ana ana thamthar za mbui. Ana Maria thamthar za mbuav, ana vhɨra mba gumgi gu mbigi nɨman memɨrar Marian nɨɨngeŋ vuzvugi fhuvara. Ana maaŋ muuŋgiap nimra ana thamthar za mbui. ");
INSERT INTO geb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Zosep ana thamthar zav wo ndav vhera mba ndɨkndɨga mbuav ki. Ana mba ndɨkndɨga mbuav kim, maan Fhe Bakɨme enser mbe rɨman ana kharigi. Ana rɨman ana kharav khaŋ ana nzuai, “Zosep, Devitan nzɨk, ndu Marian rɨgɨrgen rɨvɨ thari. Ndu mbarara! Maria ndavar ki tar, Fhe Bakɨmen Ŋina Ŋaar nduara mba tarar ana ndava vhee sarigi. ");
INSERT INTO geb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ana mba ŋguga ruagirim, ndu kha zɨn mba tara tɨgɨri, Zisas. Ne khaŋ muuŋgi, mba tar, ana won gumgi gu mbigi muuŋgi tɨvi mbatɨgi vhɨzɨv, taagi mbe ndirga.” ");
INSERT INTO geb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mba bigi maaŋ muuŋgip hɨgɨp, mba Fhe Bakɨme kamthooŋ guma fhum suaŋgi bunira zɨn ŋgɨgɨrga. Fhe Bakɨme kamthooŋ guma fhum khaŋ suaŋgi, ");
INSERT INTO geb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nde mbarara! Mbigar kama the, ana guma the ndiga kegi fhu, ana ndava rɨgɨp, ŋguga the ruagirga. Ana mba ŋguga ruagirga, mbe kha zɨn ana tɨgɨrga, Emanuer.” Mba zɨ nɨɨngeŋ khaŋ nzuai, Fhe Bakɨme nza phorga ki. ");
INSERT INTO geb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Zosep mba rɨma kuigap, mɨtimanera khavgiap, ana mba Guma Bakɨme enser ana suaŋgi kameŋra zɨn vugi. Ana mba kameŋ zɨn vov won muuŋ Maria ga tɨgi. ");
INSERT INTO geb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Zosep Maria ga tɨgap, ana ndiga wo phenan vugap, ana gura Maria phorga kui fhuvara. Ana fhura ana phorga kav kim, Maria mba ndavar ki ŋguga ruagi. Maria mba ŋguga ruagim, ana kha zɨn ana tɨgi, Zisas. ");
INSERT INTO geb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria Zudia ŋgu bakɨme fhain Betrehem ŋgu bakɨmen Zisas tegi. Maria Zisas tegi tugen, Herot Zudia fhain ki ŋgui vhɨrve gari guman pan ki. Maria Zisas tegim, bigi kaŋgi gumgi mbari, mbe ra ndai fhain kegap, nda zav Zerusareman ndav, tamtam mba gumgir nzav, khaŋ nzambaran mbe mbui. ");
INSERT INTO geb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Mba Zudain ŋgui vhɨrve ganɨnga guman pan kɨrga tar, ana niamuuŋ ana tegi, ana maaŋ ki? Nza mba tara bun nzuai kama bakɨme, ana ra ndai fhain hɨgim, nza ana gangiap, mba tara nɨman thɨvi phɨrɨr zav ana ndi garav zi.” ");
INSERT INTO geb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mbe ne nzuaim, ŋgui vhɨrve gari guman pan Herot ne mbararagiap ndɨkndɨgi vhɨrve ga mbui. Ana ndɨkndɨgi vhɨrve ga mbuim, mba Zerusareman ki gumgi gu mbigi, mbe vhɨra ndɨkndɨgi vhɨrve ga mbui. ");
INSERT INTO geb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mbe ndɨkndɨgi vhɨrve ga mbuim, ŋgui vhɨrve gari guma Herot mbaram mba Fhe Bakɨme rotu gari gumgir pani gum Zudain tɨvi kaŋgi gumgir kamgi. Ana mben kamgim, mbe ana han zim, ana mbe fugap kha nzambaren mbe muuŋgi, “Mba Fhe Bakɨme taagip kha nuianan ki gumgi gu mbigi ndir zav suaŋgiap sarigi guma, ana niamuuŋ maaŋgi ŋgun ana tegi.” ");
INSERT INTO geb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ana mba nzambaren mbe muuŋgim, mbe ana ŋgarkarav khaŋ ana nzuai, “Ana niamuuŋ Zudia fhain Betrehem ŋgun ana tegɨrga. Fhum Fhe Bakɨme kamthooŋ guma maaŋ suaŋgim, mbe mba kameŋ khergim, ne ki. Mba kameŋ khaŋ nzuai, ");
INSERT INTO geb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ndu Betrehem ŋgu, ndu Zudia fhain ki. Ndu ŋgu khɨn fhuvara, ndu ntigem nduara wo ganɨnga. Gu ntigem ndun ki guma the ndi farim, ana nan gumgi Isreriŋ ganɨnga.’ ” ");
INSERT INTO geb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mbe maaŋ suaŋgim, ŋgui vhɨrve gari guman pan Herot ne mbararagiap, mbaram nimnera mba ra ndai fhain kega zegi gumgi ga nzuav kama ndi mbarigim, mbe ana han zegim, ana thukhɨngira mben nzai. Ana kha nzambaran mbe mbui, mba kama bakɨme rasɨn hɨgi. ");
INSERT INTO geb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ana mba nzambaran mbe muuŋgiap, mbe sarigim, mbe Betreheman vuim, ana khaŋ mbe nzuai, “Nde ŋgɨp khaŋ tɨgɨp mba tara suaŋv ganɨri! Nde mba tara gangip, nde vhɨra taagi zɨv na suaŋgirim, gu vhɨra ŋgɨp, mba tara rotur muunga.” ");
INSERT INTO geb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ŋgui vhɨrve gari guman pan Herot maaŋ mbe suaŋgim, mbe ana buneŋ mbararagiap wari vui. Mbe vov, mbe taagia mba ra ndai fhain gangi kama bakɨme, mbe ana garav ana zɨn vui. Mbe mba kama bakɨme zɨn vuim, mba kam vov mba tar ki phena kɨra tugera thɨgi. ");
INSERT INTO geb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mba kam thɨgim, mba ra ndai fhain kega zegi gumgi, mbe mba kama garav, mbe guigira ndikndiga mbatɨga mbui. ");
INSERT INTO geb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mbe ndikndiga mbatɨga mbuav, mba phena vhen verav, mba tara garav, vhɨra ana niamuuŋ Maria gari. Mbe mba tara garav, ana nɨman thɨvi phɨrav wari wo thari ntaav, fhura ana ndɨɨi bigin mba tara ndɨɨi. Mbe gorar ana ndɨɨv, vhɨra ndiga vhuuŋ hi mporiiŋ gum, ndɨga vhuuŋ hi rui phorga ana ndɨɨi. Mba bigi, nta guigira ndɨga vhuuŋ hi. ");
INSERT INTO geb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mbe mba bigin mba tara nɨɨŋgiap, mbe maan kuim, Fhe Bakɨme rɨman mbe kharav khaŋ mbe nzuai, “Nde taagi ŋgɨp ŋgui vhɨrve gari guman pan Herotan hɨ thari.” Ana maaŋ mbe suaŋgim, mbe harigi tuav mbugum, wari wo ki ŋgun vegi. ");
INSERT INTO geb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mba ra ndai fhain kega zegi gumgi, mbe taagia vegim, Guma Bakɨme maan rɨman Zosep kharigi. Ana wo enser mbe sarigim, ana zav khaŋ Zosep ga nzuai, “Ndu khavgip, kha tara ndigip, ana niamuun kov nde rɨɨv Idzɨvan ŋgegɨri. Ndu ŋgɨgɨp, Idzɨvra kɨri, ne khaŋ muuŋgi, ŋgui vhɨrve gari guman pan Herot mba tara ndiv ganɨv, ana shogirim, ana rɨmɨn za mbui.” ");
INSERT INTO geb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Zosep mba rɨma kuigap, ana mba maaŋra khavgiap, mba tara ndigap, ana niamuun kov, mbe maan Betrehem thav khavgiap wari Idzɨvan vegi. ");
INSERT INTO geb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Zosep manin ko vugap, mbe Idzɨvra kim, ŋgui vhɨrve gari guman pan Herot rimgi. Kha bunai ne fhum Fhe Bakɨme kamthooŋ guma suaŋgi kama mɨnara vugi. Ana fhum khaŋ suaŋgi, “Nan Kam Idzɨvra kɨrim, gu nduara ana kamgirim, ana Idzɨp thav zɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herot zumgum mbararagim, mba ra ndai fhain kega zegi gumgi ana guigap, wari taagi wari wo ki ŋgun vegim, ana guigira ndav mbatɨk ana shigi. Ana ndav shigap, mbaram gumgi mbari ga sarigim, mbe Betrehem ŋgun verav, vhɨra mba Betrehem gan ki ŋgu, mbe za nta ruav mpari mpuveni vhɨzgi fhuv tari ndi gari. Mbe mbe garav, mba mbigi tegi tari, mbe gumgi garav, mbe za mbe shogim, mbe vhɨzgi. Herot mba kama bakɨme hɨgi tuga nzuav, mba ra ndai fhain kegap zegi gumgir nzai, ne nɨɨeŋ khaŋ muuŋgi. Ana kha ndɨkndɨga mbui, ana mba tugen hegi tari, ana za mbe shogɨri mbe vhɨzgir za mbui. ");
INSERT INTO geb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kha kameŋ ne Fhe Bakɨme fhum nen wo kamthooŋ guma Zeremaia ga nɨɨŋgim, ana ne suaŋgi, mba kameŋ nera mɨnan vugi. Ana khaŋ suaŋgi, ");
INSERT INTO geb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Nanan gum nzir kama bakɨme Rama ŋgu bakɨmen hɨgɨrga. Mba nzir kam gum nanaman kam, ana Reser won tari ga nzuav nzi nzir kam ma. Ana mbe nzuav nzim, mba gumgi gu mbigi ndava mɨɨtɨgar ana nɨɨŋgirga, tuktɨgi fhuvara. Ana khaŋ muuŋgi ne nzuav, anan tari zam vhɨzgi.” ");
INSERT INTO geb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Zosep gu Maria mba tara ndigap Idzɨvra kim, Herot rimgim, Fhe Bakɨme enser, ana wom zav rɨman Zosep kharigi. ");
INSERT INTO geb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Mba Fhe Bakɨme enser rɨman Zosep kharav khaŋ ana nzuai, “Ndu khavgip, mba tara ndigip, mani niamuuŋ gum ndu mani kov, nde khavgip Isrerar ŋgɨri. Mba tara shogirim, ana rɨmɨn za nzuai gumgi, mbe vhɨzgi.” ");
INSERT INTO geb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ana rɨman Zosep kharav, maaŋ ana suaŋgim, Zosep mbaram mba tara ndigap, ana niamuun kov, mbe taagia khavgiap, Isrera fhain veri. ");
INSERT INTO geb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mbe verav Zosep mbararagim, Arkeraus won ndia Herot ŋana ndigap, ŋgui vhɨrve gari guman pan kav, Zudia fhaiŋ gari. Maaŋ muuŋgiap, Zosep rivgi. Zosep rivgim, Fhe Bakɨme wom rɨman ana kharav kama havharar ana suaŋgim, ana mbaram maaŋ thav, khavgia vov, Gariri fhain vergi. ");
INSERT INTO geb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Zosep manin ko vera vov, mbe kha zɨn rɨgi ŋgun ki. Mba ŋgu zɨ Nasaret, kha kameŋ ne fhum Fhe Bakɨme kamthooŋ guma suaŋgi kameŋra mɨnan vugi. Mba kameŋ khaŋ nzuai, “Mbe khaŋ ana suanga, Nasaret guma.” ");
INSERT INTO geb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Zisas niamuuŋ ana tegim, ana kha nuianan hɨgap ki tugen, mpari mbari vhɨzgim, Zon Gumgi Ruai guma zav Zudian fhain gumgi ki fhuv ŋanen zɨgap, Fhe Bakɨme buni vhuuiŋ bun nzuai. ");
INSERT INTO geb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ana Fhe Bakɨme buni vhuuiŋ bun nzuav khaŋ nzuai, “Nde mba mbui tɨvi mbatɨgi thamthav ndavi domdorɨri. Fhe Bakɨme wo gumgi gu mbigi ganɨri mbe ana piin kɨrga tuk han mbarigi.” ");
INSERT INTO geb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Zon, ana mba fhum Fhe Bakɨme kamthooŋ guma Aisaia bun suaŋgi guma ma. Fhe Bakɨme kamthooŋ guma Aisaia, ana bun nzuav khaŋ suaŋgi, “Guma the gumgi ki fhuv ŋanen kɨv khaŋ suanga, ‘Nde Fhe Bakɨme suaŋv tuavi muuŋri. Nde ana suaŋv tuavir muuŋrim, nta thɨgar maaŋri.’ ” ");
INSERT INTO geb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zon Gumgi Ruai Guma kameran nderar muuŋgi shagi sharav, rerar wo vhaa rɨgi. Ana kuambogi gum gumgi reri phooŋ pi. ");
INSERT INTO geb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ana mba tugen mba gumgi ki fhuv ŋanen hɨga kaav nzuaim, mba Zerusareman ki gumgi gu mbigi, mba Zudian ki gumgi gu mbigi zam, mba Zordan mbɨ gaar han ki ŋgui, mbe za zav Zon gumgi ruai guman han zi. ");
INSERT INTO geb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mbe ana han zav, wari wo muuŋgi tɨvi mbatɨgi bun ana nzuaim, Zon Zordan mbɨn mbe ruai. ");
INSERT INTO geb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mbe zim, Zon Fherasiŋ vhɨrve gum Sadusiŋ vhɨrve garim, mbe vhɨra wari ruar zav zim, ana khaŋ mbe nzuai, “Nde kuruga mbatɨk tegi tari ma. Fhe Bakɨme nde nzuav ndav shigi, ana guigira muumbara mbatɨgar nden muuŋgirga. The nde suaŋgi, nde mba nden hɨr za mbui tuga mbatɨga ŋkɨɨav regɨrie? ");
INSERT INTO geb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nde maaŋ muuŋgip guigira ndavi domdorgip, nden tɨvi guigira ndavi domdorgi tɨvara muuŋrim, mbe gangip kaŋgirga nde guigira ndavi domdorgi. ");
INSERT INTO geb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nde kha ndɨkndɨgar warir muuŋ thari, ‘Abraham ana nzan nzɨk ma.’ Gu guigira nde nzuai, Fhe Bakɨme vuzvuk ma, ana vuzvugirga, ana kha ŋkɨɨar muuŋgirga, Abrahaman nzɨgi hegɨrga. ");
INSERT INTO geb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nde mbarara! Ntigem tuik khira ndɨrir ki, vhɨgi vhuuiŋ mbai fhuv khira, mbe zam nta kɨv, nta fuv, vhava suegɨrga. ");
INSERT INTO geb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Gu nde ndavi domdorgi ne nzuav, gu mbɨn nde ruai. Na zɨn zi guma, ana ŋkasŋka guigira na kambarigi. Gu guman vhuuŋ fhuvara. Gu vhɨra ana ŋkari shariveni ndirga tuktɨgi fhuvara. Ana zɨv Fhe Bakɨmen Ŋina Ŋaar gum vhavar nde ruarga. ");
INSERT INTO geb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ana bigi heei farve khɨga zi. Ana zɨv, mba wit heeŋv, mba wit mbatɨgi ana nta fusurga. Ana nta heeŋv, wit vhuuiŋ, ana nta ndiv wo wit vhuuiŋ vhui phena vhov, mba wit mbatɨgi, ana nta fuv, zazera mbara muuŋgiap shiav ki vhava suegɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Zon Gumgi Ruai Guma mba gumgi gu mbigi ruai tugivigen, Zisas Gariri kegap, Zordan mbɨn vui. Ana vov, Zon han vugap wo ruar zav Zon Gumgi Ruai Guma ga nzuai. ");
INSERT INTO geb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Zon ana thɨvɨr zav khaŋ ana nzuai, “Gu, ndu na ruarga. Ndu ram muuŋgiap wo ruar zav na han zi?” ");
INSERT INTO geb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ana maaŋ nzuaim, Zisas ana ŋgarkarav, khaŋ ana nzuai, “Mbara muuŋ, ndu ntigem gu nzuai kameŋ, ndu ne zɨn ŋgɨri. Ndu maaŋ muuŋgirga, ŋka mba Fhe Bakɨme muun zav suaŋgi buni, ŋka za nta zɨn vui.” Ana maaŋ suaŋgim, Zon ana suaŋgi kameŋ zɨn vui. ");
INSERT INTO geb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Zon Zisas suaŋgi kameŋ zɨn vov Zisas ruagi. Zon Zisas ruagim, ana mbɨ thav kɨrar hɨgap, bɨra thɨvar ndavra thagim, buip fhogim, Fhe Bakɨmen Ŋina Ŋaar fhomne gegap ana han zeri. ");
INSERT INTO geb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ana ana han zerim, guma mbe kamthooŋ buivar kav khaŋ nzuai, “Khe nan Kam ma. Gu guigira ana vuzvugi. Na ndav vhee ana ndikndigi.” ");
INSERT INTO geb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Fhe Bakɨme maaŋ Zisas ga suaŋgim, ana Ŋina Ŋaar ana rugap ana kov gumgi ki fhu ŋanen vugim, Satan ana mpari. ");
INSERT INTO geb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Zisas vugap maaŋ kav 40 rari gu mbarir, ana mba mbegi fhu. Ana maaŋ muuŋgiap guigira thɨ mbatɨk hegi. ");
INSERT INTO geb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ana thɨhegim, ana mpari guma, zav ana hɨgap khaŋ ana nzuai, “Ndu maaŋ muuŋgip guigira Fhe Bakɨmen Kam, ndu suaŋrim, kha ŋkɨɨa vikntuua gegɨri.” ");
INSERT INTO geb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ana maaŋ nzuaim, Zisas ana ŋgarkarav khaŋ ana nzuai, “Fhe Bakɨmen buni vhuuiŋ ki gap khaŋ suaŋgi, ‘Gumgi gu mbigi mbara nzuav bɨɨŋbɨɨŋ ndiav ŋkasŋkagia ki fhuvara. Zakɨra fhuvara! Mbe Fhe Bakɨme suaŋgi buni mbe vhɨra za nta zɨn ŋgɨrga mbe bɨɨŋbɨɨŋ ndiv ŋkasŋkagip kɨrga.’ ” ");
INSERT INTO geb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Zisas maaŋ suaŋgim, Satan mbaram, Zisasan kov Fhe Bakɨme ŋgu ŋaar Zerusareman vugap, ana ko vov Fhe Bakɨme Phena shɨ guarara ndagi. ");
INSERT INTO geb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Satan ana kov ndav, khaŋ ana nzuai, “Ndu maaŋ muuŋgip guigira Fhe Bakɨmen Kama guar, ndu khaŋ thɨgɨp fegɨmbɨra. Fhe Bakɨme buni vhuuiŋ ki gap khaŋ muuŋgi kameŋ ki. Mba kameŋ khaŋ nzuai, ‘Ana wo enseri ga suaŋrim, mbe ndu ganɨnga, bigɨn the ndun farfagirga tuktɨgi fhuvara. Mbe ndu suirav ndu vun fegɨrga, mba kɨma the ndu ŋkari thɨgɨrga tuktɨgi fhu.’ ” ");
INSERT INTO geb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ana maaŋ nzuaim, Zisas ana ŋgarkarav khaŋ ana nzuai, “Fhe Bakɨme buni vhuuiŋ ki gavar ki buna mueŋ wom vhɨra khaŋ nzuai, ‘Ndu Fhe Bakɨme, ana ndu Bakɨme ma! Ndu fhura ana ŋkasŋka ganɨ saŋv anan panɨ thari.’ ” ");
INSERT INTO geb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Zisas maaŋ suaŋgim, Satan wom Zisas ndigap guigira vun ndagi mbɨkshɨma bakɨ mben ndagi. Ana ana kov ndav, za kha nuianan ki bigir vhuuiŋ gu ana ki ŋgui bakɨvi gum ntan ŋkasŋkagi, ana ntan ana khɨvigi. ");
INSERT INTO geb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ana ntan Zisas khɨvav khaŋ ana nzuai, “Ndu maaŋ muuŋgip thɨvani phɨrgip na nɨman fav, na rotur muuŋgirga, gu za kha bigir ndun nɨɨŋgirga.” ");
INSERT INTO geb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ana maaŋ nzuaim, Zisas khaŋ ana nzuai, “Satan ndu sari. Fhe Bakɨme buni vhuuiŋ ki gap khaŋ suaŋgi, ‘Ndu Fhe Bakɨmera piin kɨri, ana nduara ndu Bakɨme ma. Ndu ara rotur muuŋri.’ ” ");
INSERT INTO geb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ana maaŋ ana suaŋgim, Satan ana thav vugi. Satan ana thav vugim, Fhe Bakɨme enseri zav ana kurigi. ");
INSERT INTO geb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Zisas mbararagim, mbe Zon gumgi ruai guma ndi bɨna khɨngim, Zisas vov Garirin fhain hɨgi. ");
INSERT INTO geb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ana zɨgap, Nasaret ŋgu thav vov Kaperneaman ki. Kaperneam ana Gariri mbasɨk taaŋra ki. Ana Seburuniŋ gum Naptariŋ nuianan ki. ");
INSERT INTO geb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Zisas mba tɨva muuŋgiap ana mba fhum Fhe Bakɨme won kamthooŋ guma Aisaia ga suaŋgim, ana suaŋgi kameŋra zɨn vugi. Mba kameŋ khaŋ nzuai. ");
INSERT INTO geb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Mba Seburuniŋ gu Naptarin nuianen ki gumgi gu mbigi, mba nuianeŋ mba mbasɨk taan veri tuav bakɨme hara ki. Mba Zordan mbɨ gaar muen ki nuianeŋ, ne Gariri fhain nuianeŋ ma. Mba fhaiŋ ki nuianeŋ harigi ŋgui gumgi gu mbigi vhɨrve, mbe vhɨra mba nuianen ki. ");
INSERT INTO geb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mba nuianen ki gumgi gu mbigi, mbe ndava vura tɨvi ga mbuav ntan gɨngɨnan ki. Mbe gɨngɨnan kav, mbe vhava ŋaara gangi. Mba tɨvi mbatɨgi gɨngɨnan kav vhɨzgi fara muuŋgi gumgi, vhava ŋaar mben hɨgi.” ");
INSERT INTO geb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Zisas Garirin vergap kav, mba tugivigen ana won ŋaara bakɨme khavgia ana mbuav, Fhe Bakɨmen buni vhuuiŋ bun gumgi gu mbigi ga nzuai. Ana Fhe Bakɨme buni vhuuiŋ bun nzuav, khaŋ mbe nzuai, “Nde wari wo ndavi domdorɨri. Ne khaŋ muuŋgi, Fhe Bakɨme wo gumgi gu mbigi ganɨnga, mbe ana piin kɨrga tuk han mbarigi.” ");
INSERT INTO geb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Zisas mba ŋaara mbuav Gariri mbɨ gaa ga rui. Ana ruav vov fek gu ŋguga phuni gangi. Saimon, mbe kha zɨ phorga anan kaai, Pita, ana ŋguk Andru, ana mani gangi. Mani wo vhaaŋ ndi mbɨ suav ki. Mani mbagan shɨga mbui gumani ma. ");
INSERT INTO geb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Zisas mani gangiap khaŋ mani ga nzuai, “Ŋko na zɨn zɨri, gu gumgi gu mbigi ndirga tɨvar ŋko khɨvɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ana maaŋ mani ga nzuavra thagim, mani fhura wani wo vhaaiŋ thav ana zɨn vui. ");
INSERT INTO geb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mani ana phorga vuim, Zisas wom vov harigi fek gu ŋguga gari. Sebedin kam Zems won ŋguk Zonan kov, ana mani gangi. Mani won ndia Sebedin kov, mbe won keman kav, mben vhaaiŋ goreŋ regim, mbe ntan thoori sai. Zisas mani gangiap, manin kamgi. ");
INSERT INTO geb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Zisas manin kamgim, mani vhemkora wo kema thav, wo ndia thav, mani Zisas phorga vui. ");
INSERT INTO geb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Zisas Fhe Bakɨme buni vhuuiŋ bun nzuav za mba Gariri fhaiŋ ga rui. Ana ruav, mbe Fhe Bakɨme buni mbararagi pheni, ana nta vherir verav, Fhe Bakɨmen buni vhuuin gumgi gu mbigi khɨvav mbe nzuai. Ana mbe nzuav Fhe Bakɨme won gumgi gu mbigi ganɨrim, mbe ana piin kɨrga bunin mbe nzuai. Ana mba bunin mbe nzuav vhɨra mbarkɨrga rɨmrɨɨ ki gumgi gu mbigi, ana mben kurkurav, mbe rɨmrɨɨ ga mbuim, mbe rɨmrɨɨ vhɨzi. ");
INSERT INTO geb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Zisas maaŋ mbuim, ana bun nzuai kameŋ za mba Siria fhaiŋ ga ruigi. Maaŋ muuŋgiap, mba gumgi gu mbigi, mbe mbarkɨrga rɨmrɨɨ kav nta zaagi ndi gumgi gu mbigi, ŋiniŋgi mbatɨgi vhen ndagi gumgi gu mbigi, gum suira gu hari rimgi gumgi gu mbigi, mbe mbe ndiav Zisas han zim, Zisas mbe rɨmrɨɨ ga mbuim, mbe taagia nzezerigi. ");
INSERT INTO geb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Zisas maaŋ mbuim, Gariri gumgi gu mbigi vhɨrve, gum Dekaporis fhaiŋ gumgi, Zerusarem gumgi, Zudia gumgi, mueŋ kovan Zordan mbɨ gaar ki gumgi, mbe za Zisas zɨn vui. ");
INSERT INTO geb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Zisas garim, gumgi gu mbigi vhɨrve guarira ana zɨn zim, ana thav vov, mbɨkshɨma mbe gaar ndav peregi. Ana ndav peregim, ana phorga rui gumgi ana han zi. ");
INSERT INTO geb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Mbe ana han zim, ana mbaram Fhe Bakɨme buni vhuuin mbe khɨvav, mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ana khaŋ mbe nzuai, “Nde tuituigiap Fhe Bakɨme tɨvi kaŋgir za ana nzuav gari gumgi, nde ndikndigɨri. Nde mba khesharigi gumgi, nde Fhe Bakɨme piin ki ana gari bigi nta Hevenan ki nde za nta ndirga. ");
INSERT INTO geb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Nde ntigem nzi gumgi gu mbigi, nde ndikndigɨri. Fhe Bakɨme nde ndavir muuŋgirim, nta mbɨrarga. ");
INSERT INTO geb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Nde ntigem wari wo zɨri mbevigi gumgi gu mbigi, nde ndikndigɨri. Fhe Bakɨme za kha nuianan za nden nɨɨŋgirga. ");
INSERT INTO geb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Nde ntigem, tɨvir vhuuiŋ zɨn ŋgɨr zav, guigira thɨhegap fhɨrkhigi tɨvi mbui gumgi gu mbigi nde ndikndigɨri. Fhe Bakɨme mbe mba tivgi bigi ana guigira ntan mben kurarga. ");
INSERT INTO geb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Nde harigi gumgi gu mbigi kora mbuav fhura mbe mbui tɨvi mbatɨgi ndɨkndɨk ŋangi gumgi gu mbigi, nde ndikndigɨri. Fhe Bakɨme fhura nde korar muuŋv nde mbui tɨvi mbatɨgi ndɨkndɨk ŋangirga. ");
INSERT INTO geb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Nde ndavi ŋgarav ki gumgi gu mbigi, nde ndikndigɨri. Nde Fhe Bakɨme gangirga. ");
INSERT INTO geb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Nde ntari gu rua mbui fhuv gumgi gu mbigi nde ndikndigɨri. Mbe kha zɨrir nden kamɨnga, nde Fhe Bakɨmen tari ma. ");
INSERT INTO geb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Nde tɨvar vhuuŋ zɨn vuim mbe ne nzuav simtɨgar nde ndɨɨi gumgi gu mbigi, nde ndikndigɨri. Fhe Bakɨme gari bigi, nta nde ntɨɨri ma. ");
INSERT INTO geb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mbe nde garim, nde na bɨnan kim, mbe ne nzuav buni mbatɨgir nde nzuav, tɨvi mbatɨgir nde mbuav, fhura mbarkɨrga bigir tamtam nde sav nde shɨshɨgap nde nzuai, nde ndikndigɨri. ");
INSERT INTO geb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nde ne suaŋv ndavi simɨ thari. Nde ndavi mbɨrav wari kɨri. Nden vheza bakɨme nde rarga Hevenan ki. Mbe fhum nde nɨma tɨga fhara vegi Fhe Bakɨmen kamthooŋ gumgi, mbe mba tɨvara mbe muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde kha nuianan mba sui mbasɨga fara muuŋgi. Mbe mbɨ kɨvgip mbasɨga tɨn tɨgɨrga, ana faŋgirga, nde wom ram ana muuŋgirim, ana vhergirie? Maaŋ muuŋgip, mbɨnga fara muuŋgi mbasɨk, ana ŋaar ki fhuvara. Mbe fhura ana si mbur suarga, mbe ana tɨ thivɨ rurga. ");
INSERT INTO geb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nde vhɨra kha nuianan vhava ŋaari ma. Nde khueŋ ndɨkndɨgɨ, mbɨkshɨma vun ki ŋgu bakɨme, ana zorgɨ kegɨrga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Khueŋ vhɨra, gumgi thari fhum raa ga mpov nta ndiv ndarir vhee vhui fhuvara. Mbe nta mpov nta ndi kaagir vurir mbaim, nta vhava ŋaarar mba phenan ki gumgi ga ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nde vhɨra mba tɨvara muuŋri. Nden tɨvar vhuuŋ, ana vhava ŋaara farar muuŋgip, mba gumgi gu mbigi ga shɨrarim, mbe nden mbui tɨvir vhuuŋ ganɨv, nde Ndia kha Hevenan ki, mbe ana zɨ ndiv vun kuamkuarga.” ");
INSERT INTO geb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde khueŋ ndɨkndɨgɨ thari. Gu kha Fhe Bakɨme Moses ga nɨɨŋgi tɨvi, gu mba Fhe Bakɨmen kamthooŋ gumgi suaŋgi buni, gu nta vhɨzɨ zav zɨgi. Zakɨra fhuvara! Gu nta vhɨzɨ zav zɨgi fhuvara, gu nta havharɨv, gu guigira nta tugarɨgɨ zav zɨgi. ");
INSERT INTO geb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Gu guigira khar nde nzuai, kha nuian gu buip vhɨzgirga, kha Fhe Bakɨme Moses ga nɨɨŋgi tɨva, thueŋ, ne vhɨzgirga tuktɨgi fhuvara. Zakɨra fhuvara! Mbe kha Fhe Bakɨme Moses nɨɨŋgi tɨvi, mbe nta khergi, mba ŋkeera thueŋ gu mba ana tɨgi tɨvi thaneŋ vhɨzgirga tuktɨgi fhuvara. Mba tɨvi mbara muuŋgip kɨrim, Fhe Bakɨme mba suaŋgi bigi za hegɨrga. ");
INSERT INTO geb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Maaŋ muuŋgip, guma the Fhe Bakɨme Moses ga nɨɨŋgi tɨva thueŋ gangip, khaŋ ne ga suanga, ne fhura ki tɨveŋ ma. Ana maaŋ suaŋgip, ana harigi guma the suaŋrim, ana vhɨra ana zɨn ŋgɨp, mba ndɨkndɨgen vhɨra mba tɨven muunga. Mba tɨveŋ ne kɨvgi fhu, ne guigira tɨva bisaneŋ ma. Maaŋ mbui guma Hevenan ana zɨ guigira bisaŋgirga. Guma, ana Fhe Bakɨme Moses ga nɨɨŋgi tɨvi, ana nta zɨn vov, mba tɨvir harigi gumgi khɨvav mbe nzuai guma, ana Hevenan Fhe Bakɨme gari bigi, ana mba ŋanan, ana zɨ bakɨme ki. ");
INSERT INTO geb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Gu nde nzuai, nde guigira Fhe Bakɨme vuzvugi zɨn vui fhu. Nden tɨvi vhuuiŋ, nta Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi gum Fherasiŋ gumgi tɨvi kambarigi fhuvara, nde maaŋ muuŋgip, Hevenan Fhe Bakɨme piin kegɨrga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde fhum nden nzɨgi nde suaŋgi buni nde nta ndigi, mba buni khaŋ nzuai, ‘Nde harigi gumgi gu mbigi shogɨrim, mbe vhɨzɨ thari. Guma the maaŋ muuŋgip harigi guma the shogirim, ana rimgirga, mba guma ana bigi ndi thɨgar mbai guman pana nɨma thɨgɨrga.’ ");
INSERT INTO geb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Gu ntigem khaŋ muuŋgia tɨga nde nzuai, Guma, ana won fek the, ana vhega mbatɨgir ana muuŋgi, mba guma, ana vhɨra bigi ndi thɨgar mbai guman pana nɨma thɨgɨrga. Guma the vhɨra buni mbatɨgir won fek the suaŋgirga, mba guma, ana vhɨra buaadegi gumgir guman pana vhari nɨma thɨgɨrga. Guma the vhɨra khaŋ harigi guma the suanga, ‘Ndu ŋanŋangi guma ma.’ Maaŋ ana suaŋgi guma, ana Herar vhavar ŋgirgɨrga. ");
INSERT INTO geb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Nde vhɨra maaŋ muuŋgip, Fhe Bakɨme suaŋv shaman muun zav artarar zɨgap, nde maaŋ muuŋgip simtɨk thueŋ harigi guma the ki, ne ndɨrigi. ");
INSERT INTO geb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Nde mba Fhe Bakɨme nzuav shaman muun zav ndiga zɨgi bigi, nde nta ndiv mba artara hara mbarav, nde taagi ŋgɨp, wari wo fek phorgɨp suaŋ mba bigeŋ ndiv thɨgar mbarari. Nde ne ndiv thɨgar mbarav, nde taagi ŋgɨp Fhe Bakɨme suaŋv shaman muuŋri. ");
INSERT INTO geb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Maaŋ muuŋgip guma the nde suaŋv suan saŋv muunga, nde mba guma, nde wari tɨgɨp bigi ndi thɨgar mbai ŋanen ŋgɨp, nde vhemkora ana phorgɨp suaŋv, ŋko mba tuav sɨgera mba bigeŋ ndi thɨgar mbarari. Ndu muuŋv kɨrga, mba guma ndu ndim, bigi ndi thɨgar mbai guman pana farve khɨngirga. Mba bigi ndi thɨgar mbai guma ana ndu ndim gɨɨtɨvi farve khɨngirim, mbe ndu ndi phena tɨvaneŋ khɨngirga. ");
INSERT INTO geb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Gu guigira nde nzuai, ndu mbara muuŋgip bɨnan kɨv kɨv, ndu mbe vhezɨr za ndu suaŋgi ŋkɨɨa, ndu za nta vheza vhezgirga.” ");
INSERT INTO geb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Zisas mba bunin mbe nzua vov khaŋ nzuai, “Nde mbararagi, mbe fhum khaŋ suaŋgi, ‘Nde mani gu mburi ga rɨgi gumgi gu mbigi, nde ruarin harigi gumgi, mani gu mburi kɨmɨ thari.’ ");
INSERT INTO geb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Gu kha kamen nde nzuai, nde guma the fhura mbiga the ganɨv ndɨkndɨga mbatɨgar ana muuŋgirga, mba guma ana wo ndava vhen ruan mba mbiga ndiga kegi tɨva muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Ndu maaŋ muuŋgip ndun guvar nderen ki rɨmaeŋ ndun muuŋgirim, ndu rɨgɨp tɨva mbatɨga thueŋ muuŋgip, ndu mba rɨmaeŋ sigip fekhɨngiri. Ndu fhava ndera bisaneŋ mbatɨgirga ne nzerara, ne ndun kɨrga, ndu tɨvi mbatɨgir muunga, mbe za nde fegɨp Her khɨngi rivgi. ");
INSERT INTO geb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ndu maaŋ muuŋgip ndun guva hareŋ ndun muuŋgirim, ndu rɨgɨp tɨva mbatɨga thueŋ muuŋgip, nde mba hareŋ sigip, ne fekhɨngiri. Ndu fhava ndera bueŋra mba rɨgi ne nzerara, ne ndun kɨrga, ndu tɨvi mbatɨgir muunga, mbe za ndu fegɨp Her khɨngi rivgi.” ");
INSERT INTO geb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Mbe fhum khaŋ nzuai, ‘Guma won muuŋ thamthar zav, ana gaveŋ khergiap, ana thamtharga kameŋ khergiap, ana nɨɨŋgiap, ana thamthagi.’ ");
INSERT INTO geb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mbe maaŋ mbui, gu kha kamen nde nzuai, guma ana muuŋ ruan harigi guma kɨmgi fhu, ana man fhura ana thagi. Mba guma ana won muuaŋ muuŋgim, ana mani wani ga tɨgi tɨva phɨrgi. Ne khaŋ muuŋgi ana ana thagim, ana vov harigi guma ga tɨgi. Mba mbik, ana ruan harigi guma kɨmgi tɨva muuŋgi. Guma vhɨra, harigi guma wo muuŋ tharga ana kɨrga, guma the ana tɨgɨrga, mba guma vhɨra man gu mburi wari ga rɨgi tɨva khara thɨgap, ana vhɨra ruan harigi guman muuŋ kɨmgi tɨva muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Harigi kama mueŋ nden nzɨgi vhɨra nde suaŋgim, nde vhɨra ne mbararagi, mba kameŋ khaŋ nzuai, ‘Nde fhura gugugɨp vu guma zitɨ thari. Ndu vu guma zitav guigira buna thueŋ suaŋgip, ndu guigira Guma Bakɨme nɨman mba bigen muuŋgiri.’ ");
INSERT INTO geb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Gu nde nzuai, nde fhura vu guma zitɨ thari. Guigi guarara! Nde wo buna thueŋ havharɨ saŋv Heven zitɨ thari. Ne khaŋ muuŋgi, Heven, ana Fhe Bakɨme ŋgui vhɨrve gari guman pan kav pigi mpirmpirɨk ma. ");
INSERT INTO geb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nde vhɨra wari wo buna the havharɨ saŋv nuiana zitɨ thari. Ana vhɨra khaŋ muuŋgi, ana Fhe Bakɨme perav won ŋkarveni ndi si ŋaneŋ ma. Nde vhɨra wari wo buna thueŋ havharɨ saŋv Zerusarem zitɨ thari. Zerusarem, ana vhɨra ŋgui vhɨrve gari guman panan vharir ŋgu bakɨme ma. ");
INSERT INTO geb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nde vhɨra wari wo buna thueŋ havharɨ saŋv wari wo panira zitɨ thari. Ne khaŋ muuŋgi, nde nduarira wari wo pana rɨgin muuŋgirim, nta hurgirga tuktɨgi o, nta phɨgirga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nde buni suaŋv fhura khara suaŋri, ‘Ahaŋ’ o, ‘Fhuvara.’ Nde mbara suaŋri. Nde maaŋ suaŋ thav, nde fhura buni thari suaŋgirga, mba buni nta Satan nde nzuaim, nde nzuai.” ");
INSERT INTO geb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde fhum mbararagim, mbe khaŋ nde suaŋgi, ‘Guma the harigi guma the rɨman farfagirga, nde ana rɨman farfagiri. Maaŋ muuŋgip, guma the harigi guma the tara the korgirim, nde ana tara the korgiri.’ ");
INSERT INTO geb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Gu maaŋ muuŋgiap khaŋ nde nzuai, nde harigi gumgi nde muuŋgi tɨvi mbatɨgi, nde nta ŋgarka thari. Maaŋ muuŋgip, guma the nde kureŋ phɨrgirim, nde dorgɨp harigi kuren ana phɨrarim, ana vhɨra ne phɨrgiri. ");
INSERT INTO geb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Guma the maaŋ muuŋgip ndu fhava shaara ndir suaŋv ndu suaŋ suaŋrim, ndu vhɨra wo fhava shaara mpeeŋ phorgɨv ana nɨɨŋgiri. ");
INSERT INTO geb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Guma the maaŋ muuŋgip wo bigi ndigɨp kiromitar then ŋgɨr saŋv ndu suaŋrim, ndu ana bigi ndigɨp kiromitar phunini ŋgɨgɨri. ");
INSERT INTO geb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Guma the maaŋ muuŋgip bigɨn then ndun nzarim, ndu ana nɨɨŋri. Guma the ndun ŋgarɨgar muun saŋv muuŋrim, ndu kɨr ana sɨ thari.” ");
INSERT INTO geb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Zisas mba buni mbe nzua vov khaŋ mbe nzuai, “Nde mbararagi, mbe fhum khaŋ suaŋgi, ‘Nde guigira won kɨvntogi vuzvugɨp, nde won pana gumgi ga suaŋv ndav shiri.’ ");
INSERT INTO geb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mbe maaŋ nzuaim, gu khaŋ nde nzuai, nde guigira wari won pana gumgi vuzvugɨri. Nde mbe vuzvugɨp, mba tɨvi mbatɨgir nde mbui gumgi, nde mbe suaŋv Fhe Bakɨme phorgɨv suaŋrim, ana mben korar muuŋri. ");
INSERT INTO geb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nde maaŋ muunga, nde Ndia mbu Hevenan ki, nde ana tari kɨrga. Nden Ndia mbu Hevenan ki, ana ra mbuim, ana tɨvi mbatɨgi ga mbui gumgi ga shɨgi, ana vhɨra tɨvir vhuuiŋ ga mbui gumgi ga shɨgi. Ana vhɨra mboga mbuim, ana tɨvir vhuuiŋ ga mbui gumgir nzi, ana vhɨra tɨvi mbatɨgi ga mbui gumgir nzi. ");
INSERT INTO geb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nde maaŋ muuŋgi warira vuzvugi gumgi, nde mbera vuzvugɨrga, nde ram muuŋgi khesharigi vheza ndirie? Mba ŋkɨɨa ndia rui gumgi mbe vhɨra mba tɨvi mbui. ");
INSERT INTO geb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nde maaŋ muuŋgip, raar vhuun wari wo fek gu tarira nɨɨnga, nde mbui tɨvi, nta ram muuŋgi harigi gumgi mbui tɨvi kambarigi? Mba ndava vurar ki gumgi mbe vhɨra mba tɨva mbui. ");
INSERT INTO geb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nde guigira kɨrɨ tɨvir vhuuiŋra mbui gumgi gu mbigi kɨri. Nde Ndia ana Heven ki, nde ana ki kɨrɨ tɨvira muuŋri. Ana guigira kɨrɨ tɨvir vhuuiŋra mbui guma ma.” ");
INSERT INTO geb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde wari rɨvɨri, nde kha gumgi gu mbigi, nde ganɨ saŋv nde tɨvir vhuuiŋ muuŋ thari. Nde maaŋ muunga, nde Ndia Hevenan ki, nde ana han wari won vheza ndigirga fhu. ");
INSERT INTO geb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Nde maaŋ muuŋgip bigɨnan bigi sosuagi gumgir nɨɨn saŋv, nde mba gumgi mbari Fhe Bakɨmen buni mbararagi pheni gum tuavi rɨksɨgivigen mbui tɨvar muuŋv, guma the suaŋrim, ana mbarɨva biv nde nɨman fhara ŋgɨ thari. Mba tɨva mbui gumgi, mbe fhura bigi shɨshɨgi, mbe maaŋ muuŋrim, mbe gumgi gu mbigi, mbe ganɨv khaŋ mbe suanga mbe tɨvar vhuuŋ mbui ntɨɨri ma. Mbe maaŋ mbe suaŋv mbe zɨri ndiv vun kuamkuar zav, mbe maaŋ mbui. Maaŋ mbui gumgi, gu guigira khar nde nzuai, mbe za won vheza ndigi. ");
INSERT INTO geb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nde bigir bigi sosuagi gumgir kurkurar saŋv, ndun ŋkɨn hareŋ ndun guva hareŋ kaŋgirim, ana mba bigɨnan bigi sosuagi gumgir nɨɨŋ thari. ");
INSERT INTO geb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nde maaŋ muunga, nde mba harigi ntɨɨri kora mbuav mbe mbui tɨvi, nta zorgɨ kɨrga. Nde Ndia ana zorga mbui bigi, ana nta kaŋgi, ana ne suaŋv vhezar nden nɨɨnga.” ");
INSERT INTO geb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde Fhe Bakɨme phorgɨ suan saŋv, nde mba bigi shɨshɨgi gumgi mbui tɨvar muuŋ thari. Mbe guigira mba Fhe Bakɨme buni mbararagi pheni vheri thivav, mba tuavi kaa thivɨv Fhe Bakɨme phorgɨ suaŋrim, mba gumgi gu mbigi mbe ganɨnga ne vuzvugi. Mbe maaŋ mbuim, gu guigira nde nzuai, mbe za won vheza ndigi. ");
INSERT INTO geb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nde maaŋ muuŋ thari, nde Fhe Bakɨme phorgɨ suan saŋv, nde ŋgɨp, wari won phena vhen ŋgirgɨp, thɨm puigip, wari wo Fhe Bakɨme phorgɨ suaŋri, ana zorga ki. Nde Ndia, ana zorga mbui bigi, gum zorga ki bigi ana nta gari. Ana ne suaŋv vhezar nden nɨɨnga. ");
INSERT INTO geb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Nde maaŋ muuŋgip Fhe Bakɨme phorgɨp suaŋv nde mba ndava vurar ki gumgi mbui tɨvar muuŋv, fhura tamtam buni suaŋ thari. Mbe khueŋ ndɨkndɨgi nza buni vhɨrve suanga Fhe Bakɨme nza mbarararga. ");
INSERT INTO geb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nde mbe mbui tɨva zɨn ŋgɨ thari. Nde Ndia nde ntigar kamthooŋ ntarav ana phorgɨ suanga, ana fhum nde mba sosuagiap ana nzan za mbui bigi, ana za nta kaŋgi. ");
INSERT INTO geb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Nde kha khesharigi suambarar Fhe Bakɨmen muuŋri, ‘O, nza Ndia Bakɨme, ndu Hevenan ki, ndu zɨ ŋgaravra kɨri. ");
INSERT INTO geb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ndu nza ganɨnga, nza ndun piin kɨrga tuk hɨgɨri. Nza kha nuianan, mbe Hevenan ndu vuzvugi zɨn vui tɨvara, nza kha nuianan vhɨra mba tɨvara muunga. ");
INSERT INTO geb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ndu ntigem kha raa tugɨra tɨgi mban nzan nɨɨŋri. ");
INSERT INTO geb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ndu nza muuŋgi tɨvi mbatɨgi, ndu nta ndɨkndɨk ŋangiri, nza vhɨra mba tɨvara harigi ntɨɨri nza muuŋgi tɨvi mbatɨgi, nza nta ndɨkndɨk ŋangi. Ndu vhɨra mba tɨvara nzan muuŋri. ");
INSERT INTO geb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ndu fhura nza ganɨrim, nzan panɨnga bigɨn thueŋ nzan hɨ thari, ndu nzan hɨr za mbui bigɨna mbatɨgeŋ, ndu nza tɨn ne ndigiri.’ ");
INSERT INTO geb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Nde mbarara! Nde harigi ntɨɨri nde muuŋgi tɨvi mbatɨgi, nde nta ndɨkndɨk ŋangirga, nde Ndia mbu Hevenan ki, ana vhɨra nde muuŋgi tɨvi mbatɨgi, ana nta ndɨkndɨk ŋangirga. ");
INSERT INTO geb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nde maaŋ muuŋgip harigi ntɨɨri nde muuŋgi tɨvi mbatɨgi, nde nta ndɨkndɨk ŋangirga fhu, nde Ndia, ana vhɨra nde muuŋgi tɨvi mbatɨgi, ana nta ndɨkndɨk ŋangirga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Zisas mba bunin mbe nzuav vov khaŋ mbe nzuai, “Nde maaŋ muuŋgip, Fhe Bakɨme phorgɨ suan saŋv mba thav, nde mba bigi shɨshɨgi gumgi mbui tɨvar muuŋv khoo shɨɨŋ thari. Mbe khaŋ mbui, mbe khoo shɨɨrim, mba gumgi gu mbigi mbe ganɨv kaŋgirga, kheiŋ Fhe Bakɨme zɨ ndi vun kuamkuav mba thagi. Nde maaŋ muuŋ thari! Gu guigira khar nde nzuai, mbe za won vheza ndigi. ");
INSERT INTO geb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Gu nde nzuai, nde maaŋ muuŋgip Fhe Bakɨme zɨ ndi vun kuamkuar mba thamthav, nde wari wo khoo ruagip mporiin wari hɨvgip wari wo pani toogiri. ");
INSERT INTO geb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Nde maaŋ muuŋgirga mba gumgi gu mbigi, mbe nde mba thagi ne kaŋgirga tuktɨgi fhuvara. Nde Ndia, ana zorga ki, ana nduara nde kaŋgirga. Nde Ndia ana zorga ki bigi, ana nta kaŋgi, ana nduara ne suaŋv vhezar nden nɨɨnga.” ");
INSERT INTO geb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Zisas mba bunin mbe nzuav vov wom khaŋ mbe nzuai, “Nde kha nuianan khaŋ wari ga suaŋv bigir vhuuiŋ ndiv warira phogir vho thari. Kha nuian, ana baa gum suasuari bigi gori, vhɨra bigi wari tɨ vhiav mbarɨgim, vhɨra kɨɨi gumgi pheni phɨrav bigi kɨɨi nuian ma. ");
INSERT INTO geb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nde Hevenan wari wo bigir vhuuiŋ ndiv phogar vhori. Hevenan baa gum suasuari bigi gori fhu, bigi vhɨra wari tɨ vhi fhu, kɨɨi gumgi vhɨra pheni phɨrav kɨɨi fhu. Mba ŋgun ndun bigi vhuuiŋ nzerara kɨrga. ");
INSERT INTO geb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ndun bigi vhuuiŋ ki ŋgu ndun vuzvuk, ana vhɨra mba ŋgun kɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Zisas mba bunin mbe nzua vov wom khaŋ mbe nzuai, “Nden rɨmgi, nta nden vhavir ŋaari ma. Ndun rɨmani nzerarga, ndu nzerara ruav, ndu vhava ŋaarar ki guma ma. ");
INSERT INTO geb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ndu rɨmani mbatɨgi, ndu ruru tɨvi mbatɨgi, ndu za gɨngɨnan ki guma ma. Maaŋ muuŋgip, ndun vhen ki vhava ŋaar, ana gɨngɨngirga, ndu guigira gɨngɨna bakɨmen ki guma ma.” ");
INSERT INTO geb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Zisas mba bunin mbe nzua vov wom khaŋ mbe nzuai, “Guma the mpiiŋsɨga phunini piin ŋgarigi fhuvara. Ana maaŋ muunga, ana the vuzvugirga, ana panan the kegɨrga. Ana vhɨra the buni mbarararga, ana kɨr the segɨrga. Nde vhɨra, nde ndavir Fhe Bakɨme ndɨɨi nde vhɨra ndavar ŋkɨɨar nɨɨŋ thari.” ");
INSERT INTO geb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Gu maaŋ muuŋgiap khaŋ nde nzuai, nde wari won kɨrɨ tɨvi gu bigi ga ndɨkndɨgɨp khaŋ suaŋ thari, ‘Nza thegir mbɨrie? Nza thagɨna mbɨn mbɨrie?’ Nde mba ndɨkndɨgar muuŋv, vhɨra wari wo fhavi ga ndɨkndɨgɨp khaŋ suaŋ thari, ‘Nza thegi shagi kɨrie?’ Gu khueŋ ndɨkndɨgi ndun bɨɨŋbɨɨŋ ana mba kambarigi, ndun fhav ana vhɨra mba shagi gu bigi kambarigi. ");
INSERT INTO geb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nde kha korigi ganɨ, mbe wari ga nzuav mban pari fhu. Mbe vhɨra wari ga nzuav mba ndia vov mba ndi vhuui pheni ga vhui fhu. Nden Ndia, ana Hevenan ki, ana mban mbe ndɨɨi. Nde ndɨkndɨgi, nde kha korigi kambarigi fhuv thi? ");
INSERT INTO geb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nde the nzerara kɨrga tuavi ga ndɨkndɨgɨp ndɨkndɨgi vhɨrver muuŋv kɨrga, mba ndɨkndɨgi vhɨrve nta ram muuŋgip ana bɨɨŋbɨɨŋ ga phivarim, ana tuga mpeeŋra kegɨrie? Ne tuktɨgi fhuvara. Zakɨra fhuvara! ");
INSERT INTO geb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Nde thaŋ nzuav shagi ga nzuav ndɨkndɨgi vhɨrve, ga mbui? Nde tuituigip kha khira shivi, nta tamtam khar ki, nde nta ganɨri. Nta ram muuŋgiap hegi? Nta ŋaara bakɨme mbui fhuvara. Nta vhɨra wari ga nzuav shagi ga mbui fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Gu nde nzuai, Soromon ana fhum ŋgui vhɨrve gari guman pan kav, ana won sɨɨŋ vhuuŋra mbui. Kha khira shivi, nta nzɨɨi sɨɨŋ, nta guigira ana nzɨɨi sɨɨŋ kambarigi. ");
INSERT INTO geb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ntige khar ki vhazɨgi, gurmaŋgip guma nta gorɨp nta fuv vhava suegɨrga. Mba khesharigi vhazɨgi, nta fhura ki ntɨɨri ma. Fhe Bakɨme sɨɨn vhuuŋra nta mbui. Maaŋ muuŋgip, nde Fhe Bakɨme khothɨgi ndɨkndɨk bisaneŋ ki gumgi gu mbigi, nde guigira khueŋ kaŋgiri, Fhe Bakɨme vhɨra sɨɨn nden nɨɨnga. ");
INSERT INTO geb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nde ndɨkndɨgi vhɨrver muuŋv khaŋ suaŋ thari, ‘Nza thegir mbar mbɨrie? Nza thagɨna mbɨn mbɨrie? Nza vhɨra thegi shagi sharɨrie?’ Fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mba ndava vurar ki gumgi gu mbigi, mbe mba khesharigi bigi ga nzuav gari. Nden Ndia, ana kha Hevenan ki, ana nde mba nzua mbui bigi, ana za nta kaŋgi. ");
INSERT INTO geb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nde fhara muunga tɨv khare. Nde Fhe Bakɨme piin kɨrim, ana ŋgui vhɨrve guman pana farar muuŋgip, nde gari guman pan kɨrim, nde ana tɨvar vhuuŋ zɨn ŋgɨri. Nde ana tɨva vhuuŋ zɨn ŋgɨrim, ana vhɨra mba harigi bigi, ana vhɨra nta phorgɨp nde nɨɨŋgirga. ");
INSERT INTO geb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Maaŋ muuŋgiap, nde gurmaŋgip ndirga bigi, nde nta ndɨkndɨgɨ thari. Gurmaŋgip hɨrga bigi, nta gurmaŋgi bigi ma. Mba raar simtɨgi, nta mba raar simtɨgi ma.” ");
INSERT INTO geb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde harigi gumgi gu mbigi mbui tɨvi ganɨv, khaŋ mbe suaŋ thari, ‘Mbe gumgi gu mbigi mbatɨgi ma.’ Nde muuŋv kɨrim, Fhe Bakɨme vhɨra mba tɨvara nden muuŋgirga. ");
INSERT INTO geb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Fhe Bakɨme nde mba harigi gumgi gu mbigi mbui tɨvi garav mbe nzuai tɨvara ana nden muuŋgirga. Nde mba harigi gumgi gu mbigi ga mbui tɨvira, Fhe Bakɨme vhɨra mba tɨvara nden muuŋgirga. ");
INSERT INTO geb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ndu thaŋ nzuav mba kha nina bisaneŋ ndun ŋguga rɨman kim, ndu ne gangiap nzuai. Ndu ne gangia nzuav, ndu won rɨman mba khanararaŋ bakɨme gangi fhuve? ");
INSERT INTO geb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ndu mba khanararaŋ bakɨme ndu rɨma ŋgorgɨp kɨrim, ndu ram muuŋgip ganɨp khaŋ wo ŋguga suaŋrie, ‘Na ŋguk, gu ndu rɨman ki nduigɨna bisaneŋ ndigirga?’ ");
INSERT INTO geb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ndu bigi shɨshɨgi guma ma. Ndu fharav mba wo rɨman ki khanararaŋ bakɨme ndigiri. Ndu ne ndigip, ndu tuituigip ganɨv, ndu zumgum won ŋguga tɨn mba kha nina bisaneŋ ndirga. ");
INSERT INTO geb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nde Fhe Bakɨme won mbuigi bigi, nde nta ndiv fein nɨɨŋ thari. Nde muuŋv kɨrim, mbe dorgɨp taagi ndera segɨrga. Nde vhɨra wari won karigi vhuuiŋ fuv daa ga su thari. Nde maaŋ muuŋgirga, daa fhura nta thiphogirga.” ");
INSERT INTO geb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde Fhe Bakɨme phorgɨv suaŋv, bigir warir nɨɨn saŋv ana nzaŋrim, ana mba bigir nden nɨɨŋri. Nde bigi ga suaŋv ganɨv, nde bigɨna gangirga. Nde Fhe Bakɨmen kamɨnga ana nde suaŋv thɨma fhɨrgirga. ");
INSERT INTO geb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Fhe Bakɨme phorga nzuai gumgi, mbe bigi ndi. Guma bigi ga nzuav garav, ana mba bigɨna gari. Guma Fhe Bakɨmen kaai, Fhe Bakɨme ana suaŋv thɨma fhɨri. ");
INSERT INTO geb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Maaŋ muuŋgip, nden kama the, ana viktuma suaŋv won ndiar nzanga, ana ndia kɨman ana nɨɨŋgirie? Fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Maaŋ muuŋgip, tara the mbɨgaman won ndiar nzanga, ana ndia kuruga mbatɨga ana nɨɨŋgirie? Ana vhɨra maaŋ ana muuŋgirga fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nde tɨvi mbatɨgi ga mbui ndegi ma. Nde tɨvi mbatɨgi ga mbuav, nde bigir vhuuin wari won tarir nɨɨngeŋ, nde guigira ne kaŋgi. Nde maaŋ muuŋv, nde guigira khueŋ kaŋgiri, nden Ndia, ana kha Hevenan ki, ana phorga nzuai gumgi ana bigir vhuuin mbe nɨɨn zav ndikndigi. ");
INSERT INTO geb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Nde harigi gumgi nden muungeŋ vuzvugi tɨvi, nde vhɨra mba tɨvara harigi gumgir muuŋri. Mba tɨv, ana Fhe Bakɨme suaŋgi tɨvir nɨɨŋge ma. Mba tɨv, ana mba Fhe Bakɨme kamthooŋ gumgi suaŋgi bunin nɨɨŋge ma.” ");
INSERT INTO geb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde thɨmkam bisaneŋ mbugum vhen ŋgirɨri. Ŋgu mbatɨgar vui thɨmkamani, ni kɨvgiap rogi, nin vui tuav ana vhɨra rogim, nin vui tuav nzerigi. Maaŋ muuŋgiap, gumgi gu mbigi vhɨrve mba tuavar vui. ");
INSERT INTO geb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mba zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndi ŋgun vhen veri thɨmkamani, ni guigira bisaŋgi, vhɨra mba thɨmkamanin vui tuav, ana vhɨra bisaŋgim, gumgi gu mbigi ne ŋgɨrgen mbovaragi. Maaŋ muuŋgiap, gumgi gu mbigi babara mba tuav ne gara mba tuavar vui.” ");
INSERT INTO geb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde fhura Fhe Bakɨmen kamthooŋ gumgir wari ga shɨshɨgi gumgi, nde mben rɨvɨri. Mbe fhura nde raaŋ shɨv, buni vhuuiŋra nde suanga. Mben ndɨkndɨgi guari mbu vhen ki, mbe fhura nde guiguigirim, nde mbe zɨn ŋgɨrim, mbe nden farfagir zav mbui. Mbe ruaŋruaŋgi feiŋ fara muuŋgiap, fhura sipsiva rɨgin wari shargia rui. Mbe mba sipsiva rɨgɨnan wari shargip ŋgɨp, sipsivi han ŋgɨp mben suigɨrga. ");
INSERT INTO geb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nde mbe mbui tɨvi gangip kaŋgirga, mbe Fhe kaathoori gumgir wari ga shɨshɨgi gumgi o, fhu. Ram muuŋgi tɨv? Guma the fhum vov tari ki karigi rɨgar wanin vhɨgi khargire? Ee, maaŋ muuŋgip guma fik vhɨgi kharɨ saŋv, ana ŋgɨp sesegi vhazɨgi mbatɨgi rɨgar fik vhɨgi khargire? Zakɨra fhuvara! ");
INSERT INTO geb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mba tɨvara khira vhuuiŋra, nta vhɨgir vhuuiŋra mbai. Khira mbatɨgi, nta vhɨgi mbatɨgi mbai. ");
INSERT INTO geb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Khan vhuuŋ, ana vhɨgi mbatɨgi maaŋgirga tuktɨgi fhu. Kha mbatɨk ana vhɨra vhɨgi vhuuiŋ maaŋgirga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Vhɨgi vhuuiŋ mbai fhuv khira, mbe zam nta kav, nta fov vhava sui. ");
INSERT INTO geb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Maaŋ muuŋgiap, nde mben tɨva ganɨp, nde mba Fhe Bakɨmen kamthooŋ gumgir wari ga shɨshɨgi gumgi nde mbe kaŋgirga. ");
INSERT INTO geb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Nde khueŋ ndɨkndɨgɨ thari, mba kha kakaman na mbui gumgi gu mbigi, ‘Bakɨme,’ mba zɨn nan kaai gumgi gu mbigi, mbe za Hevenan Fhe Bakɨme piin ki ntɨɨri phorgɨ kegɨrga thi? Fhuvara. Guma, na Ndia mbu Hevenan ki, guma ana vuzvugi zɨn vui, mba gumara Fhe Bakɨme piin ki ntɨɨri phorgɨ Hevenan kegɨrga. ");
INSERT INTO geb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Zumgum Fhe Bakɨme za kha nuianan ki gumgi gu mbigi mbui tɨvi mbatɨgi ga suaŋv mbe suanga tuga bakɨmen, gumgi gu mbigi vhɨrve khaŋ na suanga, ‘Bakɨme, Bakɨme, nza ndu zɨn panan ndu kamthooŋ guma ŋgari ŋaara muuŋgi. Nza vhɨra ndu zɨn panan ŋiniŋgi mbatɨgi ga vharvharagi. Nza vhɨra ndu zɨn panan mirikori vhɨrve ga muuŋgi.’ ");
INSERT INTO geb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mbe maaŋ suanga, gu mba tugen khaŋ mbe suanga, ‘Gu thaneŋ nde kaŋgi fhuvara. Nde tɨvi mbatɨgi ga mbui ntɨɨri ma, nde na thav sari.’ ” ");
INSERT INTO geb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Guma gu khar nzuai buni mbararagiap nta zɨn vui guma, ana ndɨkndɨga vhuuŋ ki guma fara muuŋgip, ana ndɨkndɨga vhuuŋ kav, ana ŋkɨɨa tɨn wo phena muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ana wo phena muuŋgim, mbok zerim, mpi bakɨme zerim, bɨɨŋbɨɨŋ bakɨme khavgi, mba bigi zav mba phena sim, mba phen phɨrge rɨgi fhuvara. Ne khaŋ muuŋgi, mba phena muuŋgi simen, ana vov mbu nuiana vhen ki kɨma bakɨme suirav havhargi. ");
INSERT INTO geb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Guma na buni mbararav nta zɨn vui fhu, mba guma, ana ŋanŋangi guma fara muuŋgiap, khɨɨn ki ŋanen wo phena muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ana khɨɨna tɨn wo phena muuŋgim, mbok zeri. Mbok zerim, mpi bakɨme zerim, bɨɨŋbɨɨŋ bakɨme khavgi. Mba bigi zav mba phena sim, mba phen za phɨrge rɨgi. Ahaŋ, mba phen phɨrerav za phɨra koreregi.” ");
INSERT INTO geb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Zisas mba bunin mbe suaŋgim, mba gumgi gu mbigi vhɨrve, zam ana mbe khɨvav mbe suaŋgi buni mbararagiap ŋgava mbatɨga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mbe khaŋ muuŋgiap, ana mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi mbe khɨvav mbe nzuai, tɨva muuŋgi fhuvara. Ana zɨ ki guma mbe khɨvav mbe nzuai tɨva muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Zisas mba bunin mba gumgi gu mbigi vhɨrve ga suaŋgiap, ana mbaram mba mbɨkshɨma thav verim, gumgi gu mbigi vhɨrve ana zɨn veri. ");
INSERT INTO geb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ana verim, ŋkari gu fari goreri rɨmrɨm ki guma mbe zav, wo thɨpanani phɨrgiap, ana nɨman fav, khaŋ ana nzuai, “Guma Bakɨme, ndu vuzvugirga, ndu nan muuŋgirga, gu Fhe Bakɨme nɨman ŋgararga.” ");
INSERT INTO geb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ana maaŋ nzuaim, Zisas wo farven ana khɨngiap khaŋ ana nzuai, “Gu vuzvugi. Ndu rɨmrɨm vhɨzgi, ndu ŋgarari.” Zisas maaŋ nzuavra thagim, mba ŋkari gu fari goreri rɨmrɨm vhemkora mba guma thav vugim, mba guman fhav taagia ŋgarigi. ");
INSERT INTO geb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mba guma fhav ŋgarigim, Zisas mbaram khaŋ ana nzuai, “Ndu tuituigira wo ganɨri. Ndu won hɨgi bigeŋ bun harigi guma the suaŋ thari. Ndu ŋgɨp wo fhavar mba Fhe Bakɨme rotu gari guman pana khɨvav, ndu mba Moses fhum muun zav suaŋgi shaman muuŋri. Ndu mba shaman muuŋrim, mba gumgi gu mbigi ndu gangip kaŋgirga, ndun rɨmrɨm vhɨzgi.” ");
INSERT INTO geb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Zisas vov Kaperneam ŋgu bakɨmen vhen verim, Roman ntari ga mbui gɨɨtɨvi gari guman pan zav khaŋ tɨgap Zisasan nzav, khaŋ ana nzuai, ");
INSERT INTO geb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Guman Rum, nan ŋaara guma rɨmrɨm mbatɨga mbuav, bigi ana rimgim, ana zaa mbatɨga ndiav phenan mbur ki.” ");
INSERT INTO geb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ana maaŋ nzuaim, Zisas mbaram khaŋ ana nzuai, “Gu ŋgɨp ana muuŋgirim, ana nzerarga.” ");
INSERT INTO geb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Zisas maaŋ nzuaim, mba ntari ga mbui gɨɨtɨvi gari guman pan ana ŋgarkarav khaŋ ana nzuai, “Guman Rum, gu guman vhuueŋ, ndu maaŋ muuŋgip na phena vhen ŋgirɨrie. Ndu fhura khara kɨv suaŋrim, nan ŋaara guma taagip nzerarga. ");
INSERT INTO geb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gu khaŋ muuŋgia tɨgap ndu nzuai ne khaŋ muuŋgi, gu vhɨra guma mbe piin ŋgarim, ana na gari guman pan ki. Gu vhɨra gu ntari ga mbui gɨɨtɨvi mbari garim, mbe na piin ki. Gu maaŋ muuŋgip, khaŋ the suanga, ‘Ndu ŋgɨ,’ ana vui. Gu maaŋ muuŋgip khaŋ harigi ne suanga, ‘Ndu zɨ,’ ana zi. Gu maaŋ muuŋgip, khaŋ won ŋaara guma ga suanga, ‘Ndu kha ŋaarar muuŋ,’ ana mba ŋaara mbui.” ");
INSERT INTO geb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ana mba buni nzuaim, Zisas nta mbararagiap ŋgava mbatɨga muuŋgi. Ana ŋgava mbatɨga muuŋgiap, khaŋ mba wo phorga zi gumgi ga nzuai, “Gu guigira khar nde nzuai, gu Isrerin gumgi rɨgar guma the garim, ana kha guma bigi khothɨgi fara muuŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Gu nde nzuai, gumgi gu mbigi vhɨrvera, mbe ra ndai fhain ki ŋguir kegɨp zɨrga, gumgi gu mbigi vhɨrve mbe ra veri fhain kegɨp zɨv, mbe Abraham gu Aisak gu Zekop phorgɨv, mbe Hevenan Fhe Bakɨme piin kɨv mbɨrga. ");
INSERT INTO geb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mba Fhe Bakɨme fharav mba won ŋgun kɨr zav farasarigi gumgi, ana mbe vhararim, mbe ŋgɨp gɨngɨn kɨvgi ŋgun ŋgegɨp ana kɨrga. Mbe maaŋ kɨv nzi mbatɨgar muuŋv, tari ntɨɨri phɨrɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Zisas maaŋ mbe nzuav, khaŋ mba ntari ga mbui gɨɨtɨvi gari guman pana nzuai, “Ndu ŋgɨ! Ndu na khothɨgap, mba nzuai bigi, nta mbara muuŋgip hɨgɨrga.” Ana mba nzuai tugara mba ntari ga mbui gɨɨtɨvi gari guman pana ŋaara guma rɨmrɨm vhɨzgiap taagia nzerigi. ");
INSERT INTO geb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Zisas mbaram vov Pita phenan vergi. Ana verav Pitar muun niamuuŋ garim, ana rɨɨv won kaa ga rɨgap ki. Ana rɨɨv ana fhav ana gurgurgim, ana ki. ");
INSERT INTO geb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Zisas mbaram vov ana farver suirigim, ana rɨmrɨm fhura ana thav mbar vugi. Ana mbaram khavgiap Zisas ga nzuav mba tui. ");
INSERT INTO geb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mba raar ra vera vov vhɨzim, ŋkotuguraagen gumgi gu mbigi vhɨrve ŋiniŋgi mbatɨgi mben vherir ki, mbe mbe ndiav Zisas han zi. Mbe mbe ndiav Zisas han zim, ana mba ŋiniŋgi mbatɨgi ga nzuaim, mbe mba gumgi gu mbigi thamthav kɨrar him, mbe taagia nzezerigi. Ana vhɨra mba rɨɨi gumgi gu mbigi, ana za mbe mbuim, mbe rɨmrɨɨ vhɨzi. ");
INSERT INTO geb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ana mba tɨva mbuav, ana mba Fhe Bakɨme kamthooŋ guma Aisaia fhum suaŋgi kameŋ, ana nera zɨn vugi. Aisaia fhum, khaŋ suaŋgi, “Ana nduara nza tɨn mbarkɨrga rɨmrɨɨ, ana nza tɨn nta ndiv, nta vhɨzɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Zisas mba ana behuigap thivgi gumgi gu mbigi vhɨrve garav khaŋ wo phorga rui gumgi ga nzuai, “Nza kha mbɨ gaar muen ŋgɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Zisas maaŋ mbe nzuaim, Zudaiŋ tɨvir vhuuiŋ kaŋgi guma mbe zav khaŋ ana nzuai, “Guman Rum, ndu mba vui ŋani gu vhɨra ndu phorgɨv ntan ŋgɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ana maaŋ nzuaim, Zisas mbaram khaŋ ana nzuai, “Ruaŋruaŋgi feiŋ, nta kha nuianan kui thoori ki. Kha korigi mbe khoni ki. Kha Fhe Bakɨmen Guma Guar, ana kui phena the ki fhu.” ");
INSERT INTO geb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ana phorga rui guma mbera, vhɨra khaŋ ana nzuai, “Guman Rum, ndu na khɨrarim, gu ŋgɨp won ndia ganɨv kɨrim, ana rimgirim, gu ana mpɨrav zɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ana maaŋ nzuaim, Zisas mbaram khaŋ ana nzuai, “Mba tɨv mbar kɨri, mba rimgi fara muuŋgiap ki gumgi mbe vhɨzɨv, mbe mbar wari ndiv mbogir rɨgɨri. Ndu zɨv na phorgɨv ŋka ŋgɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Zisas mba buni mbe suaŋgi thugap, mbaram fega kema mben mbara vuim, ana phorga rui gumgi ana phorga vui. ");
INSERT INTO geb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mbe vov mba mbɨn rɨgɨgera vuim, bɨɨŋbɨɨŋ bakɨme khavgim, mbɨ phuri za mba kema vhar za mbui. Zisas mba kema vhen ka kui. ");
INSERT INTO geb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mbe mbaram vov ana vhurav khaŋ ana nzuai, “Guman Rum, ndu nzan kura. Nza vhɨzɨr zav mbui.” ");
INSERT INTO geb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Zisas mbaram khavgiap khaŋ mbe nzuai, “Nde na khothɨgi tɨv guigira bisaŋgi. Nde thaŋ nzuav rɨvi?” Ana nen mbe nzuav khavgia thɨgav, mbaram mba mbɨ phuri gum bɨɨŋbɨɨŋ ruma mbui. Ana mani ruma mbuim, mba bɨɨŋbɨɨŋ fhura thuga vugim, mba mbɨ fhura mbɨrira vugap rɨgap ki. Mba mbɨ wom khɨkhɨm thaneŋ hi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mba Zisas phorga rui gumgi mba bigeŋ gangiap, mbe ndɨkndɨgi vhɨrve ga mbuav khaŋ nzuai, “Khe ram mbui khesharigi guma, kha bɨɨŋbɨɨŋ gum mbɨ phuri ana nzuai buni zɨn vui?” ");
INSERT INTO geb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Zisas kema ndigap Gariri mbɨn mueŋ nderen Gadaraiŋ faiŋ nuianeŋ phorgi. Ana vov phorgim, ŋiniŋgi mbatɨgi vhen ndagi guma phunini zav ana hɨgi. Mani mbe gumgi ndi mbogi ga rɨgi ŋanen kegap wani zi. Mani guigira ruaŋruaŋgi gumani ma. Maaŋ muuŋgiap, mba gumgi gu mbigi manin rivgiap mba tuava rui fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mani zav khɨrɨv kaav khaŋ nzuai, “Ndu Fhe Bakɨmen Kam, ndu ram nzan muun za mbui? Tuk ntigar hɨrga, ndu fhumra tɨva mbatɨgar nzan muun zav zi thi?” ");
INSERT INTO geb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mba tugen daa bɨna bakɨ mbe maneŋ samra maaŋ ki. Nta gari gumgi mban nta ndɨɨim, nta pav ki. ");
INSERT INTO geb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mba ŋiniŋgi mbatɨgi mba nzambaren Zisas ga muuŋgiap mbaram, khɨrɨv Zisasan kaav khaŋ ana nzuai, “Ndu nza vharvhara saŋv, ndu nza vharav, nza sararim, nza ŋgɨp mbu daa vherir ŋgirgɨri.” ");
INSERT INTO geb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Mbe mba suambara mbuim, Zisas mbaram, khaŋ mbe nzuai, “Nde hegɨp, ŋgɨri.” Zisas maaŋ nzuaim, mba ŋiniŋgi mbatɨgi mba gumani thav kɨrar hegap, mbaram vov mba daa vherir vergi. Mba daa za khuafua vov mba ŋana mbatɨgeŋra vera vov mbɨ rav, mbɨ pav, za vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mba daa gari gumgi mba daa gangiap, wari za regi. Mbe ra vov, ŋgu bakɨmen vov mba hɨgi bigeŋ bun mba gumgi gu mbigi ga nzuai. Mbe mba bigi bun nzuai, mba ŋiniŋgi mbatɨgi vhen ndagi gumani mbe vhɨra manin hɨgi bigeŋ bun nzuai. ");
INSERT INTO geb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mba ŋgu bakɨmen ki gumgi gu mbigi mba bigi mbararagiap, mbe za Zisas han zi. Mbe zav Zisas garav, mbe khaŋ tɨgap wari wo fhain wo nuianeŋ thav harigi fhain ŋgɨr zav Zisas ga nzuai. ");
INSERT INTO geb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Zisas mba fhaiŋ thav vov, fega kema mben mbarav vov, muen wo ŋgu bakɨmera phorgi. ");
INSERT INTO geb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ana vov phorgim, gumgi mbari bigi rimgi guma mbe, mbe kaan ana ndigap ana han zi. Zisas mbaram mbe garim, mbe guigira ana khothɨgim, ana mba tɨva gangia thav khaŋ mba bigi rimgi guma ga nzuai, “Nan kam, ndu ndav mbɨrari. Ndu fhum muuŋgi tɨvi mbatɨgi, gu nta vhɨzgiap, nta ndɨkndɨk ŋangi.” ");
INSERT INTO geb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Zisas maaŋ ana nzuaim, mba Zudaiŋ tɨvir vhuuiŋ kaŋgi gumgi mbari maaŋ kav ne mbararagiap, nduarira khaŋ wari ga nzuai, “Mbu guma Fhe Bakɨme ŋana ndigi tɨva mbui.” ");
INSERT INTO geb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mbe mba suambara mbuim, Zisas fhum mbe ndɨkndɨgi kaŋgi, ana maaŋ muuŋgiap khaŋ mbe nzuai, “Nde thaŋ nzuav mba ndɨkndɨgi mbatɨgi nde ndavi vherir ki? ");
INSERT INTO geb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Gu ram mbui suambarar muunga ne nzerigi? Ee, gu kha suambarar muunga, ne nzerigire, ‘Gu ndu fhum muuŋgi tɨvi mbatɨgi, gu nta vhɨzgi,’ ee, khueŋ nzerigire, gu khaŋ suanga, ‘Ndu khavgip ŋgɨ’? ");
INSERT INTO geb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Gu nde khueŋ kaŋgirgeŋ nzuav, gu khaŋ muuŋgia tɨga nzuai, Fhe Bakɨmen Guma Guar, ana kha nuianan tɨvi mbatɨgi vhɨzɨrga ŋkasŋka ki.” Zisas maaŋ mbe suaŋgiap, mbaram mba bigi rimgi guma garav khaŋ ana nzuai, “Ndu khavgip, wo kaa ndigip, wo phenan ŋgɨ.” ");
INSERT INTO geb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Zisas maaŋ ana suaŋgim, mba guma khavgiap wo phenan vui. ");
INSERT INTO geb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ana khavgiap, wo phenan vuim, mba gumgi gu mbigi vhɨrve mba bigeŋ gangiap, mbe guigira rivgiap, mbe khueŋ nzuav Fhe Bakɨme zɨ ndiv vun kuamkuagi. Fhe Bakɨme mba khesharigi ŋkasŋka gu zɨ bakɨme gumgi ga ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Zisas mba guman kurav, maaŋ thav khavgia vov, guma mbe gari. Mba guma zɨ, Matiu. Ana Matiu garim, ana wo ŋgari ŋanen mbe ŋkɨɨa ndi sui phena perav ki. Zisas ana gangiap khaŋ ana nzuai, “Matiu, ndu zɨv na phorgɨv ŋka ŋgɨrga.” Ana maaŋ nzuaim, Matiu khavgiap ana phorga vui. ");
INSERT INTO geb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Zumgum tuga mben Zisas vov Matiu phenan mba pi. Mba tugen ŋkɨɨa ndia rui gumgi gum tɨvi mbatɨgi ga mbui gumgi vhɨrve, mbe ana han zegi. Mbe zegap, Zisas gum ana phorga rui gumgi phorga pi. ");
INSERT INTO geb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mbe pim, Fherasiŋ mbe gangiap, mba Zisas phorga rui gumgir nzav kha nzambaran mbe mbui, “Nden Guman Rum thaŋ nzuav mbu ŋkɨɨa ndia rui gumgi gum tɨvi mbatɨgi ga mbui gumgi phorga pi?” ");
INSERT INTO geb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mbe maaŋ mbe nzuaim, Zisas mba kameŋ mbararagiap, khaŋ mbe nzuai, “Rɨmrɨm ki fhuv gumgi, mbe rɨɨi phenan ŋgari guman han vui fhu. Rɨɨi gumgi, mbe nduarira rɨɨi phenan ŋgari guman han vui. ");
INSERT INTO geb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nde ŋgɨp Fhe Bakɨmen buni vhuuiŋ ki gavar ki buni ganɨp, kha nde Fhe Bakɨme buna nɨɨeŋ kaŋgirga, ‘Gu nde fhura na nzuav shama mbui shaa, gu nta vuzvugi fhuvara. Gu guigira khueŋ vuzvugi, nde guigira tɨvir vhuuiŋra harigi ntɨɨri muuŋv guigira mbe vuzvugiri.’ ” Zisas wom khaŋ mbe nzuai, “Gu tɨvir vhuuiaŋ mbui gumgir kamɨ za zɨgi fhuvara. Gu tɨvi mbatɨgi ga mbui gumgir kamɨn za zɨgi.” ");
INSERT INTO geb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mba tugen Zon phorga rui gumgi, mbe Zisas han zav kha nzambara ana muuŋgi. “Ram muuŋgi tɨv khare, nza Zon phorga rui gumgi gum Fherasiŋ, nza Fhe Bakɨme phorga nzuav mba thamthagim, ndu phorga rui gumgi, mbe mba thamthagi fhu?” ");
INSERT INTO geb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mbe mba nzambarar Zisas ga muuŋgim, Zisas khaŋ mbe nzuai, “Maaŋ muuŋgip, guma the muun rɨgɨ saŋv muunga, ana kɨvntogi, ana mbe phorgɨ kɨrga, mben ndavi simgirie? Fhuvara. Mbe zumgum mba guma ndigɨ ŋgɨgɨrga, ana won kɨvntogi phorga ki fhu. Ana kɨvntogi mba tugen mba thamtharga. ");
INSERT INTO geb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Guma the fhum shaa fɨga kameŋ ndigap fhava shaara vura thooŋ phorga samgi fhuvara. Ana maaŋ muuŋgirga, mbe zumgum mba fhava shaa ruagirga, ana mba shaa phorga samgi shaa fɨgeŋ ne ŋgɨp bisaŋgip, mba fhava shaa suirav ana ŋgɨrim, mba shaa thooŋ wom sharav guigira kɨvgirga. ");
INSERT INTO geb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Guma the fhum wain kaman wain rui dama ndera vurar ruigi fhuvara. Mbe maaŋ muuŋgirga, mba dama ndera vur furav, mba wain kam fhura nɨɨn ŋgɨgɨrga, mba dama nder vhɨra mbatɨgirga. Maaŋ muuŋgiap, mbe wain kaman dama ndera kamara rui, mbe maaŋ muuŋgirga, mani vhɨra nzerara kɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Zisas Zon phorga rui gumgi ga nzuavra kim, mba ŋgu gari guman pana mbe, ana han zav wo thɨpanani phɨrgiap ana nɨman fav khaŋ ana nzuai, “Nan kambik ntigera rimgi. Ndu zɨv won farver ana khɨngirim, ana taagi khavgip kɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ana maaŋ suaŋgim, Zisas mbaram khavgiap ana phorga vui. Ana vuim, ana phorga rui gumgi, mbe vhɨra ana phorga vui. ");
INSERT INTO geb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mbe vuim, mba tugen mbiga mbe ki. Mba mbik wo sargori rɨmrɨm anan ki. Mba mbik mba rɨmrɨm anan kim, 12 thɨgi mpari vhɨzgi. Mba mbik zav, Zisas zɨn kɨrar hav, ana sharigi shaar tɨvar suirigi. ");
INSERT INTO geb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mba mbik khaŋ wo nzuai, “Gu maaŋ muuŋgip ana shaa tɨvara suirarga, Fhe Bakɨme na muuŋgirim, gu taagi nzerarga.” ");
INSERT INTO geb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ana ne suaŋgiap, zav, Zisas shaa tɨvar suirigim, Zisas mbaram dorgap ana garav khaŋ nzuai, “Nan kambik, ndu ndav mbɨrav kɨri. Ndu na khothɨgap, ndu taagia nzerigi.” Mba mbik maaŋ muuŋgiap, ana mba tugera taagia nzerigi. ");
INSERT INTO geb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Zisas maaŋ mba mbiga suaŋgim, ana nzerigim, ana mbaram vov mba ŋgu gari guman pana phenan vugi. Ana vov garim, gumgi gu mbigi nziav ki. Mbe nziav, gumgi shɨfhɨri ga bim, gumgi gu mbigi khɨkhɨm bakɨme mbui. ");
INSERT INTO geb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Mbe maaŋ mbuav kim, Zisas khaŋ mbe nzuai, “Nde khaŋ thav sav wari ŋgɨri. Kha mbiga bisaneŋ rimgi fhuvara, ana kui.” Ana ne nzuaim, mbe ana bungia kɨɨ mbatɨga mbui. ");
INSERT INTO geb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mbe ana bungia kim, mbe mba gumgi gu mbigi ga sarigim, mbe kɨrar hegim, Zisas mbaram mba biptara khum ki ŋanen verav, mba biptara harar suirigim, ana khavgia thɨgi. ");
INSERT INTO geb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Zisas mba bigeŋ muuŋgim, mba bigen kameŋ za mba fhaiŋ ga ruigi. ");
INSERT INTO geb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Zisas mba ŋgun kegap mba ŋgu tav khavgia vui. Ana vuim, rɨmani mbatɨgi guma phunini ana zɨn vov, ana kaav nzɨɨv, khaŋ ana nzuai, “Devitan Kam, ndu ŋkan korar muuŋ.” ");
INSERT INTO geb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ana vov phena mbe vhen verim, mba rɨmani mbatɨgi gumani vov ana han vui. Mani ana han vuim, Zisas manin nzarigi, “Ŋko na khothɨgi, gu ŋkon rɨmanin muuŋgirim, ni nzerarie?” Ana maaŋ nzuaim, mani ana ŋgarkarav khaŋ nzuai, “Ahaŋ, Guma Bakɨme, ŋka ndu khothɨgi. Ndu mba bigen muuŋgirga.” ");
INSERT INTO geb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mani maaŋ suaŋgim, ana wo farver mani rɨmani khɨngiap khaŋ mani ga nzuai, “Ŋko na khothɨgi ne nzuav, kha bigeŋ ŋkon hɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Zisas nen mani ga suaŋgim, mani rɨmani taagia nzerigim, mani taagia gari. Mani rɨmani nzerigim, Zisas kama havharar khaŋ mani ga nzuai, “Ŋko shɨshɨgɨp kha ŋkon hɨgi bigeŋ bun harigi guma the suaŋ thari.” ");
INSERT INTO geb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Zisas mba kamen mani ga suaŋgim, mani vov mba kameŋ zɨn vugi fhu. Mani vov mba kameŋ bun za mba fhain ki gumgi gu mbigi ga nzuav, ana mba manin kurkurav mani ga muuŋgi tɨvar vhuueŋ, mani za ana bun suaŋgi. ");
INSERT INTO geb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mba rɨmani mbatɨgia kegi gumani, mani Zisas thav vugim, gumgi gu mbigi mbari, ŋina mbatɨk vhen ndav kav mbuim, thɨɨni mpɨrav buni nzuai fhuv guma mben kov Zisas han zi. ");
INSERT INTO geb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mbe ana kov Zisas han zɨgim, Zisas mbaram, ana tɨn mba ŋina mbatɨga vharigim, mba guma thav kama hegap buni nzuai. Zisas mba tɨvar mba guma ga muuŋgim, mba gumgi gu mbigi vhɨrve ndɨkndɨgi vhɨrve ga mbuav khaŋ nzuai, “Fhum khaŋ muuŋgi bigɨna thueŋ Isrerar hɨgi fhuvara!” ");
INSERT INTO geb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mbe mba ndɨkndɨga mbuim, mba Fherasiŋ hegap khaŋ nzuai, “Ana ŋiniŋgi mbatɨgir guman panan ŋkasŋkan panan ŋiniŋgi mbatɨgi ga vharvharigi.” ");
INSERT INTO geb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Zisas za mba ŋgui bakɨvi gu ŋgui bisarire ga ruigi. Ana ruav, Fhe Bakɨme buni mbararagi pheni vherir verav, Fhe Bakɨme buni vhuuin gumgi gu mbigi khɨvav mbe nzuai. Ana mbe nzuav, Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga buni vhuuiŋra mbe nzuav, vhɨra mbarkɨrga rɨmrɨɨ ki gumgi gu mbigi, ana mben kurkurigim, mbe rɨmrɨɨ vhɨzi. ");
INSERT INTO geb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ana ruav gumgi gu mbigi vhɨrve garav, ana guigira mbe kora muuŋgi. Ana mbe gari, mbe khaŋ muuŋgi. Mben kɨrɨ tɨvi guigira mbatɨgi, mben kurkurarga guman vhuuŋ the ki fhu. Mbe vuavi ki fhuv sipsivi fara muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ana maaŋ muuŋgia gangia thav khaŋ wo phorga rui gumgi ga nzuai, “Mba vhɨrve gɨvav mɨnan kim, mba mba ndirga ŋaara gumgi vhɨrkɨvgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Maaŋ muuŋgiap, nde mba mɨna namkam Guma Bakɨme phorgɨ suaŋrim, ana ŋaara gumgi ga sararim, mbe ŋgɨp, ana mba fukfugɨp nta ndirga.” ");
INSERT INTO geb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Zisas mba farasegi 12 thɨgi ŋaara gumgi, ana mben kamgim, mbe ana han zi. Mbe ana han zɨrim, ana gumgi gu mbigi tɨn ŋiniŋgi mbatɨgi ga vharvhararga ŋkasŋkan mben nɨɨŋv, vhɨra mbe tɨn mbarkɨrga rɨmrɨɨ vhɨzɨrga ŋkasŋkan mben nɨɨnga. ");
INSERT INTO geb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ana mba farasegi 12 thɨgi ŋaara gumgi zɨri khare. Fharigi ne khare, Saimon, ana zɨ mbe khare, Pita, ana ŋguk Andru. Mbevi Zems, Zebedin kam, ana ŋguk Zon. ");
INSERT INTO geb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Mbevi Firip, gu Bartoromiu, Tomas, Matiu. Matiu mba ŋkɨɨa ndia ruigi guma ma. Zems, ana Arfiusan kam ma, gum Tadius. ");
INSERT INTO geb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon, mba Zerotan wari ga rɨgi guma Iskariot guma Zudas, ana zumgum Zisasan mba ana farfarga gumgi, ana ana mbe farve khɨngirga. ");
INSERT INTO geb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Zisas wo 12 thɨgi ŋaara gumgi ga sarigim, mbe vuim, ana kha suambarar mbe mbui. “Nde harigi fhaiŋ ŋguir ŋgɨ thari. Nde vhɨra Samarian ŋguir ŋgɨ thari. ");
INSERT INTO geb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nde ŋgɨ Isreriŋ ŋguir ŋgɨri, mben gumgi gu mbigi, mbe sipsivi fara muuŋgiap vuavi hegi fhu, mbe fhura tamtam vov mbar regap wari ki. ");
INSERT INTO geb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nde ŋgɨp Fhe Bakɨme buni vhuuiŋ bun mbe suaŋv khaŋ mbe suaŋri, ‘Fhe Bakɨme won gumgi gu mbigi ganɨnga tuk han mbarigi.’ ");
INSERT INTO geb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nde ŋgɨp maaŋ mbe suaŋv, nde vhɨra mba rɨɨi gumgi gu mbigi, nde mben kurkurarim, mbe rɨmrɨɨ vhɨzɨri. Nde vhɨra vhɨzi gumgi, nde taagi mbe khavɨri. Nde vhɨra ŋkari gu fari goreri rɨmrɨɨ ki gumgi, nde mbe kurkurari mbe rɨmrɨɨ vhɨra vhɨzɨri. Nde vhɨra ŋiniŋgi mbatɨgi vhen ndav ki gumgi, nde mbe tɨn nta vharvhararim, nta mbe thamthav kɨrar hɨri. Nde kha ndigi bigɨn, nde fhura ana ndigi, ana vhez ki bigɨn fhuvara. Maaŋ muuŋgiap, nde fhura ana harigi gumgi gu mbigir nɨɨŋri. Nde ana mben nɨɨŋv vheza suaŋv mben kamɨ thari. ");
INSERT INTO geb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Nde vhɨra goran muuŋgi ŋkɨɨa ndiv, sirvar muuŋgi ŋkɨɨa, kapan muuŋgi ŋkɨɨa, nde nta ndigi ŋgɨ thari. ");
INSERT INTO geb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nde ŋgɨp, nde vhɨra thar thige rugɨ thari. Nde vhɨra fhava shaar mpugeni ndi thari, nde vhɨra ŋkari shari thaveni sharav, santɨvi sɨgɨma suigɨ thari. Guma ŋaara mbui, mbe mba gu bigir ana nɨɨnga. ");
INSERT INTO geb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Nde maaŋ muuŋgip, ŋgɨp ŋgu bakɨ the o, ŋgu then ŋgɨgɨp, nde tuituigip mba ŋgun ki gumgi ganɨri. Nde mbe ganɨrim, mba ŋgun guma the nde ndigip, nde ganɨngeŋ vuzvugiri, nde mba gumara phorgɨ kɨri. Nde mba gumara phorgɨ kɨv kɨv, nde mba ŋgu thav harigi ŋgun ŋgɨri. ");
INSERT INTO geb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nde maaŋ muuŋgip ŋgɨp, phena then vhen ŋgirɨp, nde khaŋ mba phena vhen ki gumgi ga suaŋri, ‘Fhe Bakɨme tɨvar vhuun nden muuŋri.’ ");
INSERT INTO geb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nde maaŋ mbe suanga, mba phenan ki ntɨɨri, mbe maaŋ muuŋgip, nden ndikndigɨp nde ndigirga, Nde mba suaŋgi kameŋ mbe phorgɨp kɨrga. Mbe maaŋ muuŋgip, nde ndirgeŋ vuzvugi fhu, nde mba suaŋgi kaman vhuueŋ, nde taagip wari wone ndigiri. ");
INSERT INTO geb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nde maaŋ muuŋgip ŋgu then ŋgɨgɨrim, guma the nde ndigip wo phenan ŋgɨgɨrga fhu, mba ŋgun ki gumgi gu mbigi, mbe vhɨra nde nzuai buni mbararagi fhu, nde mba phenan ki ntɨɨri gu mba ŋgu thav ŋgɨr saŋv, nde wo ŋkari vherɨna pɨzgiri. ");
INSERT INTO geb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Gu guigira khar nde nzuai, Fhe Bakɨme kha nuianan ki gumgi gu mbigi muuŋgi tɨvi mbatɨgi ga suaŋv mbe suanga tuga bakɨmen, mba ŋgu bakɨmen ki gumgi gu mbigi ndirga simtɨk, ana guigira mba Sodom gu Gomoran kegi gumgi gu mbigi ndirga simtɨgi kambarigi.” ");
INSERT INTO geb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde mbarara! Gu nde sarigi, nde sipsivi fara muuŋgiap ruaŋruaŋgi feiŋ rɨgar vui. Nde maaŋ muuŋgip, nde tuituigira wari ganɨv, nzerara kɨri. Nde bigɨnan muun saŋv, nde ndɨkndɨga vhuun muuŋgip, nde mba bigɨnan muuŋri. Nde tɨva mbatɨga thuen muungeŋ ndɨkndɨgɨ thari. ");
INSERT INTO geb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nde kha nuianan ki gumgir rɨvɨri. Mbe nde ndigi ŋgɨp, nde suaŋv wari wo buaadegi gumgi phorgɨv suanga, mbe Fhe Bakɨme buni mbararagi pheni vhen phivɨgan nde kharɨrga. ");
INSERT INTO geb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mbe na mbevɨ saŋv nde ndiv wari wo ŋgui gari gumgir pani han ŋgɨp, vhɨra nde ndiv mbe wari won ŋgui vhɨrve gari gumgir pani han ŋgɨrga. Mbe maaŋ muunga, nde Fhe Bakɨme buna vhuueŋ bun mba gumgi bakɨvi ga suaŋv, vhɨra mba harigi fhaiŋ ŋgui gumgi ga suanga. ");
INSERT INTO geb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mbe maaŋ muuŋgip, nde ndigip nde suan saŋv, nde ndigi ŋgegɨrim, nde ndɨkndɨgi vhɨrve muuŋ thari. Nde vhɨra khaŋ suaŋ thari, ‘Nza ram mbui khesharigi buneŋ suaŋrie?’ Fhuvara. Nde mba tugɨra Fhe Bakɨme nduara nde suanga bunen nde suaŋgirim, nde ne suanga. ");
INSERT INTO geb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ne khaŋ muuŋgi, nde nduarira mba buneŋ nzuai fhuvara. Nden Ndiar Ŋina Ŋaar, ana nduara nde rugim, nde mbar nzuai. ");
INSERT INTO geb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Mba tugi vigen, guma wo phorge rɨgi nera suaŋv suaŋrim, mbe ana shogirim, ana rɨmɨnga. Ndegi, mbe vhɨra mba tɨvira wari won ŋkaar muunga. Tari mbe panan wari won ndegi gu ndegmborin kegɨp harigi gumgi ga suaŋrim, mbe mbe shogɨrim, mbe vhɨzɨrga. ");
INSERT INTO geb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kha nuianan ki gumgi, mbe nde suaŋ ndavi shirga. Mbe nde nzuav ndavi shi, ne khaŋ muuŋgi, na zɨ nden ki. Mbe ne suaŋv nde suaŋ ndavi shirga. Kha bigi hɨrga, guma thɨga havhargip kɨv kɨrim, kha nuian za vhɨzi tuk hɨgi, Fhe Bakɨme taagi mba guma ndigɨrga. ");
INSERT INTO geb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nde maaŋ muuŋgip, ŋgɨp ŋgu bakɨ then ŋgɨgɨrim, mba ŋgun ki gumgi gu mbigi, mbe tɨvi mbatɨgir nden muuŋrim, nde mba ŋgu bakɨme thav ŋgɨv, harigi ŋgun bakɨmen ŋgegɨri. Gu guigira khar nde nzuai, nde mba Isreriŋ ŋguir za ŋaar vhɨzgirim, Fhe Bakɨmen Guma Guar taagi zirgɨrga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Suren ki tar, ana won mparmpare kambarigi fhuvara. Ŋaara guma vhɨra, ana wo gari guma bakɨme kharav vun ki fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Suren ki tar, ana won mparmparera farar muuŋgirga tuktɨgi. Ŋaara guma vhɨra, ana wo gari guma bakɨmera farar muuŋgirga. Mbe Berseburar mba phena namkaman kaai, maaŋ muuŋgiap, nza kaŋgi, mbe guigira zɨri mbatɨgira ana ntɨɨrir kamɨnga.” ");
INSERT INTO geb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Mba tɨvi mbatɨgir nden muun za mbui gumgi, nde mben rɨvɨ thari. Mba vhagia ki bigi, nta kɨrar hegɨrga. Mbe mba zorga nzuai buni, gumgi za nta kaŋgirga. ");
INSERT INTO geb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Gu maan nde nzuai buni, nde raar nta bun suaŋgiri. Gu khorthooŋ tɨga nde suaŋgi buni, nde kama bakɨmera nta suaŋrim, nta kha pheni shɨri kharav vun ŋgɨrim, kha gumgi gu mbigi za nta mbarararga. ");
INSERT INTO geb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nde fhura nden fhavi shogim, nta vhɨzi gumgir rɨvɨ thari. Mbe nden vhen ki gumgi shogirim, nta rimgirga tuktɨgi fhuvara. Nde Fhe Bakɨmera rɨvɨri. Ana nden vhen ki gumgi gum nden fhavi, ana nta fuv Her ga suegɨrim, nde za mbatɨgirga. ");
INSERT INTO geb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Nde kaŋgi, kora bisaŋ mpuneni, gumgi kɨma rara bueŋra neni ga vhezgi. Nden Ndia, ana gangana vhuuŋra mba kora neni ga mbui. Ana fhura mba kora thaneŋ ganɨrim, ne rɨv nɨɨeŋ rɨgɨrga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Fhe Bakɨme vhɨra, ana za nden pana rɨgi, ruemgiap, ana za nta kaŋgi. ");
INSERT INTO geb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Maaŋ muuŋgiap, nde rɨvɨ thari. Nde mba korigi bisarire kambarigi.” ");
INSERT INTO geb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai. “Guma khaŋ mba gumgi gu mbigi ga nzuai, ‘Gu ana bɨnan ki.’ Ana maaŋ nzuaim, gu vhɨra na Ndia kha Hevenan ki, gu khaŋ ana suanga, ‘Mbu guma, ana na guma ma.’ ");
INSERT INTO geb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Maaŋ muuŋgip, guma khaŋ mba gumgi gu mbigi ga suanga, ‘Gu ana bɨnan ki fhu.’ Gu vhɨra na Ndia kha Hevenan ki, gu vhɨra khaŋ ana suanga, ‘Mbu guma, ana na guma fhuvara.’ ” ");
INSERT INTO geb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde khueŋ ndɨkndɨgɨ thari, gu kha nuianan ki ntari, gu za nta vhɨzɨ zav zɨgi. Gu mba ntari vhɨzɨ zav zɨgi fhuvara. Zakɨra fhuvara! Gu ntari ga mbui kos ndiga zɨgi. ");
INSERT INTO geb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Gu nde panan wari ga kegɨrga tɨvar kov zɨgi. Guma, ana panan wo ndia ga kegɨrga. Kambik, ana panan wo niamuuŋ ga kegɨrga. Mani ga rɨgi mbigi, mbe panan wari won manin ndegmbori ga kegɨrga. ");
INSERT INTO geb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Guma then fek gu tarira, mbe panan ana kegɨrga. ");
INSERT INTO geb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Guma guigira won niamuuŋ gu ndiara vuzvugiap, ana pim na vuzvugi fhu, mba guman ana na phorga rui guma kegɨrga tuktɨgi fhu. Guma vhɨra, ana guigira won kam o kambik vuzvugiap, ana pim na vuzvugi fhu. Mba guma, ana na phorga rui guma kegɨrga tuktɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Guma wo rɨmɨnga khanarareŋ phufhurav na zɨn zi fhu, mba guma, ana na phorga rui guma kegɨrga tuktɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Guma won tumara ndɨkndɨgɨp ana muuŋgirim, ana nzera saŋv muunga. Mba guman tum, ana za fhɨrgirɨgɨp vhɨzgirga. Guma maaŋ muuŋgip na ndɨrɨgɨp won tuma fekhɨngirga, mba guma ana zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigirga.” ");
INSERT INTO geb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Guma nde ndigap tɨvar vhuun nde mbui, ana na ndigap tɨvar vhuun na mbui. Guma na ndigi, ana vhɨra Fhe Bakɨme ndigi. Ana na sarigi, gu zergi. ");
INSERT INTO geb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Guma the maaŋ muuŋgip kha ndɨkndɨgar muunga, ‘Gu Fhe Bakɨme kamthooŋ guma then kurkurarga.’ Ana maaŋ suaŋgip, Fhe Bakɨmen kamthooŋ guma the ndigip, wo phenan ŋgɨgɨp, ana ganɨv, tɨvar vhuun ana muuŋgirga, Fhe Bakɨme kamthooŋ guma ndi bigir vhuuiŋ, ana mba khesharigi bigir vhuuiŋra ana nɨɨŋgirga. Maaŋ muuŋgip, guma the khueŋ ndɨkndɨgɨrga, ‘Gu tɨvir vhuuiaŋ mbui guma the ndigip, wo phenan ŋgɨgɨp, ana ganɨv, tɨvir vhuuin ana muunga.’ Ana maaŋ suaŋgip, ana mba tɨvir vhuuiaŋ mbui guma ndiga wo phenan tɨgap, ana garav, tɨvar vhuun ana mbui. Mba guma, ana mba tɨvir vhuuiaŋ mbui gumgi ndi bigir vhuuiŋ, ana mba khesharigi bigir vhuuiŋra ndirga. ");
INSERT INTO geb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Maaŋ muuŋgip, guma the kha ndɨkndɨgar muunga, ‘Gu Zisas phorga rui gumgir kurkurarga.’ Ana maaŋ suaŋgip, ana fhura mbɨn ŋamtɨŋ thigen thaman tɨgɨp fhura khar na phorga rui guma o mbiga then nɨɨŋgirga. Gu guigira khar nde nzuai, mba guman vhez fhura mbar ŋgɨgɨrga tuktɨgi fhuvara. Mba guma ana won vheza ndigɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Zisas mba bunin mba farasegi 12 thɨgi ŋaara gumgi ga nzuav mbe khɨvgia thugap, mba ŋgu thav, ana mba Gariri fhain ki ŋgui bakɨvin vov, Fhe Bakɨme buni vhuuiŋ bun gumgi gu mbigi ga nzuav rui. ");
INSERT INTO geb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Zon bɨnan kav, ana Krais mbui ŋaari gu bigir kameŋ mbararagiap, ana wo phorga rui gumgi ga sarigim, mbe Zisas han vui. ");
INSERT INTO geb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ana mbe sarav khaŋ mbe nzuai, “Nde ŋgɨp kha nzambarar Zisasan muuŋgiri, ‘Ndu mba Fhe Bakɨme farasarav sarari zɨr zav mbui gumarame, o nza harigi nen rargɨrie?’ ” ");
INSERT INTO geb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Mbe mba nzambaren ana muuŋgim, Zisas mbaram mbe ŋgarkarav khaŋ nzuai, “Nde ŋgɨp, kha garav mbararagi bigi nde za nta bun Zon ga suaŋgiri. ");
INSERT INTO geb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nde khaŋ ana suaŋri, rɨmgi mbatɨgi gumgi, mbe rɨmgi taagia nzerigim, suira mbatɨgi gumgi, mbe suira taagia nzerigim, mbe thiva rui. Mba ŋkari gu fari goreri rɨmrɨɨ ki gumgi, mbe fhavi taagia nzerigim, mba khuari ŋangi gumgi, mbe taagia buni mbararagi. Mba vhɨzi gumgi, mbe taagia khavim, mba bigi sosuagi gumgi, mbe Fhe Bakɨmen buni vhuuiŋ mbararagi. ");
INSERT INTO geb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na gangiap, na khothɨgap thɨga havhargi gumgi, mbe ndikndigɨri.” ");
INSERT INTO geb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Zisas maaŋ mba Zon phorga rui gumgi ga suaŋgim, mbe taagia vegim, ana Zon ga nzuav mba gumgi gu mbigi ga nzuai, “Nde thagɨna bigɨna ganɨ zav mba gumgi ki fhuv ŋanen vegi? Nde bɨɨŋbɨɨŋ vuruna the rɨgim, nde ana ganɨ zav vegire? Fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ee, nde thagɨna ganɨ zav vegi? Ee, nde shagi vhuuiŋ guarira shargi guma the ganɨ zav vegire? Fhuvara. Mba shagi vhuuiŋ guarira shari gumgi, mbe ŋgui vhɨrve gari gumgir pani phenin ki. ");
INSERT INTO geb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Maaŋ muuŋgiap, nde thaŋ nzuav wari vegi? Ee, nde Fhe Bakɨme kamthooŋ guma the ganɨ zav wari vegire? Ahaŋ, ara. Gu guigira nde nzuai, mba Fhe Bakɨme kamthooŋ guma, ana guigira mba harigi Fhe Bakɨmen kamthooŋ gumgi, ana guigira mbe kambarigi. ");
INSERT INTO geb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Mba gumara, Fhe Bakɨmen buni vhuuiŋ ki gap ana nzuav khaŋ suaŋgi, ‘Nde mbarara! Gu wo buni vhuuiŋ bun suanga guma the sararim, ana fhara ndu nɨman tɨgɨ ŋgɨrga. Ana ŋgɨp ndu suaŋv tuavar muunga!’ ");
INSERT INTO geb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Gu guigira nde nzuai, Zon Gumgi Ruai Guma, ana guigara kha nuianan hegi gumgi kambarigi. Fhe Bakɨme wo gumgi gu mbigi garim, mbe ana piin ki. Mbe phorga ki guma the, ana zɨ ki fhu, ana Zon Gumgi Ruai Guma kambarigi. ");
INSERT INTO geb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Ntigem, Zon Gumgi Ruai Guma fhum Fhe Bakɨmen buni vhuuiŋ bun suaŋgi tugen kegap zav, ntigem, ntari ga mbui gumgir ŋkasŋkagi, mbe khaŋ tɨgap ŋkasŋkagiap Fhe Bakɨme piin ki tɨva zɨn vuim, mbe mbarkɨrga simtɨgir mbe ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Fhe Bakɨmen kaathoori gumgi gum Moses suaŋgi tɨvi, nta Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga tɨva bun nzuavra kim, Zon Gumgi Ruai Guma zɨgi. ");
INSERT INTO geb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nde maaŋ muuŋgip, mba buni khothɨgɨ saŋv, nde mbararari. Fhe Bakɨmen buni vhuuiŋ ki gap khaŋ nzuai, Fhe Bakɨmen kamthooŋ guma Iraiza guigira zɨri. Ne Zonra nzuai. ");
INSERT INTO geb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Guma khuarani kɨv, ana kha buni mbararari. ");
INSERT INTO geb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Gu ntigem maaŋ muuŋgip, kha tugen ki gumgi gu mbigi mbui tɨvi ga suan saŋv, gu mbe vhunama sɨv ram mbui khesharigi buni suaŋrie? Mbe mba tarire fara muuŋgiap, mbe mba phogi ga vhui ŋanin kav, harigi tarir kaav khaŋ mbe nzuai, ");
INSERT INTO geb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nza nde hɨr zav shɨfhɨri ga bim, nde hi fhu. Nza vhɨra nde nzir zav, nza ndaim, nde kora mbuav nzi fhu.’ ” ");
INSERT INTO geb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Zon Gumgi Ruai Guma zɨgap, ana mba kɨvgi fhu, ana vhɨra wain pi fhu. Ana mba tɨva mbuim, mbe khaŋ ana nzuai, ‘Ŋina mbatɨk ana vhen ki.’ ");
INSERT INTO geb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mbe maaŋ ana nzuaim, Fhe Bakɨmen Guma Guar zɨgap, ana mba pav, mbɨ pim, mbe khaŋ ana nzuai, ‘Nde ana ganɨ. Ana mba kɨvgia pav, wain kɨvgia pi guma ma. Ana maaŋ mbuav ŋkɨɨa ndia rui gumgi, ana khurkhuman mbe khuuv, vhɨra tɨvi mbatɨgi ga mbui gumgi, ana vhɨra khurkhuman mbe khuui.’ Mbe maaŋ ana nzuai, ana Fhe Bakɨme ŋaara mbuim, mba ŋaar, mbe ana garim, ana ndɨkndɨk, ana guigira bigɨna guar ma.” ");
INSERT INTO geb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Zisas maaŋ mbua ruav ŋgui bakɨvi mbarir, ana mirikori vhɨrve ga muuŋgi, mba ŋgui bakɨvin ki gumgi, mbe ndavi domdorgi fhu. Maaŋ muuŋgiap, mba tugar Zisas mba ŋgui bakɨvin ki gumgi gu mbigi ga vhegi. ");
INSERT INTO geb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ana mbe vhegap khaŋ mbe nzuai, “Nde Korasin ŋgu bakɨmen ki gumgi gu mbigi, gu guigira nden kora muuŋgi. Nde Betsaida ŋgu bakɨmen ki gumgi gu mbigi vhɨra, gu guigira nden kora muuŋgi. Maaŋ muuŋgiap, guma the Taia gu Saidonan vugap, gu kha nden rɨgar kav mirikori ga muuŋgi fara muuŋgia kake, mba Taia gu Saidonan ki gumgi gu mbigi, mbe fhum ndavi domdorgiap wari wo muuŋgi tɨvi mbatɨgi kora muuŋgiap, shagi gori shargiap, vherɨna ruagiap, piigiap kae. ");
INSERT INTO geb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Maaŋ muuŋgiap, gu nde nzuai, Fhe Bakɨme za kha nuianan ki gumgi gu mbigi muuŋgi tɨvi mbatɨgi ga suaŋv mbe suan zav sarigi tugar, nde ndirga simtɨgi, nta guigira Taia gu Saidonan ki gumgi gu mbigi ndirga simtɨgi kambararga. ");
INSERT INTO geb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nde Kaperneaman ki ntɨɨri, nde ndɨkndɨgɨ, mbe guigira nde zɨri vun fegɨp Hevenan ndarga thi? Zakɨra fhuvara! Mbe za nde mbevarim, nde za ŋgirɨp, mba vhɨzgi gumgi ki ŋgu kambarav, mbar ŋgirgɨrga. Guma the maaŋ muuŋgip ŋgɨp Sodom ŋgun gu kha nde han kav muuŋgi mirikori fara muuŋgi mirikori tharir muuŋgirga, Sodom ŋgu, ana kɨrga. ");
INSERT INTO geb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Maaŋ muuŋgiap, gu nde nzuai, Fhe Bakɨme kha nuianan ki gumgi gu mbigi muuŋgi tɨvi mbatɨgi ga suaŋv mbe suanga tugar, nden hɨrga simtɨgi nta guigira Sodomin hɨrga simtɨgi kambararga.” ");
INSERT INTO geb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Zisas mba tugen mbe nzua vov khaŋ mbe nzuai, “Fhe, ndu Heven gu nuiana gari guma bakɨme ma. Gu khueŋ nzuav ndun ndikndigi. Ndu kha bigir bigi kaŋgiap ndɨkndɨgi vhuuiŋ ki gumgi, ndu ntan mbe vhagiap, ntan bigi kaŋgi fhup gumgi, ndu ntan mbe khɨvigi. ");
INSERT INTO geb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ahaŋ, Fhe, ndu wo vuzvugara zɨn vov mba tɨva muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Zisas mba buni nzua vov khaŋ nzuai, “Nan Ndia, ana za mba bigir na farve khɨngi. Guma the, ana Kama kaŋgi fhuvara. Ana Ndia nduara, ana kaŋgi. Ndia vhɨra, guma the ana kaŋgi fhuvara. Kam nduara ana kaŋgiap, Kam nduara, ana mba khɨvigi gumgi, mbera ana Ndia kaŋgi. ");
INSERT INTO geb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nde ntigem guigira ŋaara mbatɨga mbuav simtɨgi baikɨvi ndi gumgi, nde na han zɨrim, gu vhuksur nden nɨɨnga. ");
INSERT INTO geb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nde na han zɨv, na kaŋgip, na buni zɨn ŋgɨp, na piin kɨri. Gu nde ganɨnga. Nde na kaŋgiri, gu khaŋ mbui. Gu mbarara gumgi garav, tɨvar vhuuŋra mbe mbuav, gu vhɨra wo zɨ ndiv vun fi fhu. Gu guigira wo mbevi. Maaŋ muuŋgiap, bigi thari simtɨgir nden nɨɨŋgirga fhu, nde vhuksurga. ");
INSERT INTO geb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Gu nde nzuai kameŋ nden kurarga, ne pim simtɨgar nde nɨɨnga fhu.” ");
INSERT INTO geb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Zumgum Sabat raa mben Zisas wit mɨni mbave shɨrav vui. Ana vuim, ana phorga rui gumgi ana phorga vov, mbe thihegap, mba wit vhɨgi mbari korav nta pav vui. ");
INSERT INTO geb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mbe nta pav vuim, mba Fherasiŋ mbari mbe gangiap khaŋ Zisas ga nzuai, “Ndu khar ganɨ. Ndu phorga rui gumgi, mbe Sabatar muungeŋ thɨvigi tɨv, mbe ne mbui.” ");
INSERT INTO geb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mbe maaŋ nzuaim, Zisas mbe ŋgarkarav khaŋ mbe nzuai, “Ee, nde mba Devit fhum muuŋgi bigeŋ mbe ne khergim, ne ki, nde ne gangi fhuv thi? Devit fhum, won kɨvntogi kov, mbe thihegap muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Devit mbaram vov Fhe Bakɨme Phena vhen vergap, mbe Fhe Bakɨme nɨma ndarigi vikntuu, ana nta pav, vhɨra won kɨvntogi kua mbegi. Mba vikntuu harigi gumgi mbɨrgeŋ thɨvigi vikntuu ma. Mba vikntuu Fhe Bakɨme rotu gari gumgi nduarira pi vikntuu ma. ");
INSERT INTO geb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Maaŋ muuŋgiap, nde vhɨra mba Moses Fhe Bakɨme ana suaŋgi tɨvi ki gap, nde vhɨra ana gangi fhuv thi? Mba tɨvi khaŋ suaŋgi, mba Fhe Bakɨme rotu gari gumgi, mbe Sabatar ŋgarɨri. Mbe mba tɨva mbuav, mbe Sabat tɨva khiŋgia thɨgi, mbe ne mbuav, mbe ne nzuav simtɨga ndi fhu. ");
INSERT INTO geb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Gu nde nzuai, ntige khar ki bigɨn, ana guigira Fhe Bakɨme Phena kambarigi. ");
INSERT INTO geb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nde maaŋ muuŋgip, tuituigip Fhe Bakɨme buni vhuuiŋ ki gavar ana buni vhuuiŋ nɨɨŋge kaŋgirga, nde tuituigip mba bigi kaŋgirga, ‘Gu nde fhura Fhe Bakɨme nzuav shama mbui shaa, gu nta vuzvugi fhu. Gu vuzvugi, nde tɨvir vhuuin harigi gumgi gu mbigir muuŋgiri.’ Nde maaŋ muuŋv, nde fhura simtɨgar simtɨk ki fhuv gumgi gu mbigir nɨɨnga fhu. ");
INSERT INTO geb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ne khaŋ muuŋgi, Fhe Bakɨme Guma Guar, ana Sabat gari Guma Bakɨme ma.” ");
INSERT INTO geb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Zisas mba bunin mbe suaŋgia thugap, ana mba ŋaneŋ thav vov, mbe Fhe Bakɨme buni vhuuiŋ mbararagi phena vhen vergi. ");
INSERT INTO geb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mba phena vhen hareŋ rimgi guma mbe ki. Mba tugen, gumgi mbari Zisas ga suaŋv suan zav tuavi ndi garav ki. Mbe maaŋ muuŋgiap, kha nzambaran ana muuŋgi, “Ndu Sabatar kha rɨɨi guman kurarga ne, ne Sabatar tɨva khiŋgia thɨgi o, fhu?” ");
INSERT INTO geb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mbe mba nzambaran Zisas ga muuŋgim, Zisas khaŋ mbe nzuai, “Maaŋ muuŋgip, nde rɨgar guma the, ana sipsip the Sabatar mbok thɨgɨrga, nde kaŋgi, mba guma ana Sabatar wo sipsip suirav ana sigirga. ");
INSERT INTO geb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nde khueŋ kaŋgi, guma ana guigira sipsip kambarigi. Maaŋ muuŋgiap, nza Sabatar tɨvar vhuuaŋ mbui ne, ne Sabatar tɨva khiŋgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ana maaŋ mbe suaŋgia thugap khaŋ mba hareŋ rimgi guma ga nzuai, “Ndu wo hareŋ ndegɨ.” Ana maaŋ nzuaim, mba guma wo hareŋ ndegim, ana hareŋ taagia nzerigi. Mba hareŋ nzerav, mba harigi hara vhuueŋra fara muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Zisas ana kurigim, mba Fherasiŋ ne nzuav mba phena thav kɨrar hegap, wari fugap, Zisas shogirim, ana rimgirga tuavi ndi gari. ");
INSERT INTO geb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Zisas mba Fherasiŋ ana muun za mbui bigeŋ, ana ne kaŋgi. Ana maaŋ muuŋgiap, mba ŋgu thav vugi. Ana vuim, gumgi gu mbigi vhɨrve ana zɨn vui. Mbe ana zɨn vuim, ana rɨɨi gumgi gu mbigir vhɨrve, ana mben kurkurav mbe mbuim, mben rɨmrɨɨ vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Zisas mben kurkurav, kama havharan wo bun harigi ntɨɨri ga suangen mbe thɨvigi. ");
INSERT INTO geb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Zisas mba tɨvar mbe mbui, ne guigira mba Fhe Bakɨmen kamthooŋ guma Aisaia suaŋgi kameŋra zɨn vugi. Aisaia fhum khaŋ suaŋgi, ");
INSERT INTO geb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Khe nan ŋaara guma ma. Gu nduara ana farasarigi. Gu guigira ana vuzvugiap, nan ndava vhee guigira ana ndikndigi. Gu won Ŋina Ŋaarar ana nɨɨŋgirga. Ana harigi fhain ki gumgi gu mbigi, gu tɨvar vhuun mben muuŋv, taagi mbe ndirga ne bun mbe suanga. ");
INSERT INTO geb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ana ntarar muuŋv kama bakɨmen fhura suanga fhuvara. Kha gumgi gu mbigi, mbe ana mbarararim, ana fhura tuavi rɨksɨgivigen kɨv buni suaŋgirga fhu. ");
INSERT INTO geb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ne khaŋ muuŋgi, vurun mbɨrav phɨrɨ za mbuim, ana za ana phɨrgirga tuktɨgi fhuvara. Ana vhɨra tuituigiap shi fhuv ram, ana ana ŋguigirga fhu. Ana ŋgarɨv kɨv, ana guigira tɨvar vhuuŋ guarara ndi kɨra khɨngirga. ");
INSERT INTO geb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ana maaŋ muunga mba harigi fhain ki gumgi gu mbigi, mbe ana khothɨgɨp ana rargɨ kɨrim, ana taagi mbe ndirga.” ");
INSERT INTO geb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mba tugen, gumgi mbari, mbe ŋina mbatɨk vhen ndagi guma mbe ndigap ana han zi. Mba guma, ana rɨmani mbatɨgiap, vhɨra thɨni mpɨrav buni nzuai fhu. Mbe ana kov Zisas han zɨgim, Zisas ana kurigim, ana buni nzuav, vhɨra ana rɨmani nzerigim, ana gari. ");
INSERT INTO geb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Zisas maaŋ mba guma ga muuŋgim, mba gumgi gu mbigi ne gangiap, ŋgava mbatɨga muuŋgiap khaŋ nzuai, “Ana Devitan kam fhuve?” ");
INSERT INTO geb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mbe maaŋ nzuaim, mba Fherasiŋ mba bigeŋ mbararagiap, mbe khaŋ ana nzuai, “Mba guma, ana Bersebur ŋkasŋkan panan mba ŋiniŋgi mbatɨgi ga vharvharigi. Bersebur ana ŋiniŋgi mbatɨgir guman pan ma.” ");
INSERT INTO geb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mbe mba suambarar Zisas ga mbuim, ana mbe ndɨkndɨgi kaŋgiap, khaŋ mbe nzuai, “Maaŋ muuŋgip, ŋgu bakɨ the rɨgɨra wari shɨrav wari shogɨrga, mba ŋgu bakɨme guigira mbatɨgirga. Maaŋ muuŋgip, vhɨra ŋgu bakɨ the o, phena bavira ki ntɨɨri, mbe rɨgɨra wari shɨrav wari shogɨrga, mba ŋgu bakɨme gum phen mbara muuŋgip za mbatɨgirga. ");
INSERT INTO geb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mba khesharigi tɨvara, Satan taagip wora vharvhararga, ana ntɨɨri mbe rɨgɨra wari shararga. ");
INSERT INTO geb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Maaŋ muuŋgip, Bersebur guigira nan kurkurarga, gu kha ŋiniŋgi mbatɨgi ga vharvhararga. Maaŋ muuŋgi, the nde ntɨɨrir kurkurigim, mbe ŋiniŋgi mbatɨgi ga vharvharigi? Nde ntɨɨri, mbe nduarira nde suanga, nde buni, nta guigira nzerigi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Maaŋ muuŋgip, Fhe Bakɨmen Ŋina Ŋaar nan kurkurigim, gu ŋiniŋgi mbatɨgi ga vharvharigi, nde kaŋgiri, Fhe Bakɨme nde garim, nde ana piin ki tɨv nden hɨgi. ");
INSERT INTO geb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Guma the ram muuŋgip, guma ŋkasŋka the phena vhen ŋgirgɨp, ana phena vhen ki bigi kɨmgirie? Ana maaŋ muun saŋv, ana fharav mpiiŋ havhara ndigip, mba guma kegɨp, ana ndi khɨngirga. Ana maaŋ muuŋgip, ana za mba guma phenan ki bigi ndirga. ");
INSERT INTO geb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Guma nan kɨvntok fhuv, ana panan na ki. Guma nan kurav, kha gumgi gu mbigi fugfugi fhu, ana mbe zɨtɨgim, mbe rav tamtam vui. ");
INSERT INTO geb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Maaŋ muuŋgiap, gu nde nzuai, Fhe Bakɨme gumgi gu mbigi mbui tɨvi mbatɨgi gum mbe Fhe Bakɨme nzuai buni mbatɨgi, ana za nta vhɨzgirga. Maaŋ muuŋgip, guma the buna mbatɨga thuen Fhe Bakɨme Ŋina Ŋaara suaŋgirga, mba buna mbatɨgeŋ, Fhe Bakɨme ne vhɨzgirga fhu. ");
INSERT INTO geb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Guma maaŋ muuŋgip, buna mbatɨga thuen Fhe Bakɨmen Guma Guara suaŋgirga, Fhe Bakɨme mba guma buneŋ, ana ne vhɨzgirga. Guma buna mbatɨgen ana Ŋina Ŋaara suaŋgirga, mba guma, Fhe Bakɨme, ana ana Ŋina Ŋaara suaŋgi buna mbatɨgeŋ, ana ntige ne vhɨzgirga fhu, ana zumgum vhɨra ne vhɨzgirga fhu.” ");
INSERT INTO geb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Maaŋ muuŋgip, khan vhuuŋ, ana vhɨgi vhuuiŋ mbai. Maaŋ muuŋgip, kha mbatɨk, ana vhɨgi vhɨra mbatɨgi. Gumgi khira vhɨgi gangiap, mbe khaŋ nzuai, ana khan vhuuŋ ma o, ana kha mbatɨk ma. ");
INSERT INTO geb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nde gumgi mbatɨgi, nde kurigi mbatɨgi fara muuŋgi. Nde ram muuŋgip buni vhuuiŋ suaŋrie? Nde wari wo ndavi vheri givav ki buni, nde ntara nzuai. Guma, ana wo ndava vhen givav ki ndɨkndɨgi, ana nta nzuai. ");
INSERT INTO geb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Guman vhuuŋ, ana ndɨkndɨgi vhuuiŋ givav ana ndava vhen ki. Ana maaŋ muuŋgiap tɨvar vhuuaŋ mbui. Guma mbatɨk, ana ndɨkndɨgi mbatɨgi ana ndava vhen givav ki. Ana maaŋ muuŋgiap, ana tɨvi mbatɨgi ga mbui. ");
INSERT INTO geb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Gu nde nzuai, mba Fhe Bakɨme za kha nuianan ki gumgi gu mbigi muuŋgi tɨvi mbatɨgi ga suaŋv mbe suanga tuga sarigi. Ana mba tugar, ana mba gumgi gu mbigi suaŋgi buni mbatɨgi ga ndɨkndɨgɨp mbe suanga. ");
INSERT INTO geb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ndu nzuai bunira, Fhe Bakɨme khaŋ ndu suanga, ‘Ndu tɨvar vhuuaŋ mbui guma ma.’ Ndu nzuai bunira Fhe Bakɨme khaŋ ndu suanga, ‘Ndu guma mbatɨk ma.’ ” ");
INSERT INTO geb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mba tugen Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi mbari gum Fherasiŋ gumgi mbari khaŋ Zisas ga nzuai, “Guman Rum, ndu Fhe Bakɨme nduara mbui bigɨna bakɨ thueŋ muuŋgirim, nza gangip kaŋgirga, ndu Fhe Bakɨmen ŋaara mbui.” ");
INSERT INTO geb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mbe maaŋ nzuaim, Zisas khaŋ mbe nzuai, “Ntige kha tugen ki gumgi gu mbigi, mbe gumgi gu mbigi mbatɨgi ma. Mbe mirikor the gangirga tuktɨgi fhuvara. Mbe za mirikor mbe gangi. Mba mirikor Fhe Bakɨme kamthooŋ guma Zona ne muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Zona raa phuni khegene, maaŋ phuni khegenen mba mbɨgama bakɨme ndava vhen kegi. Mba tɨvara Fhe Bakɨme Guma Guar, ana vhɨra raa phuni khegene maaŋ phuni khegenen kha nuiana vhen kegɨrga. ");
INSERT INTO geb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Fhe Bakɨme zumgum kha nuianan ki gumgi gu mbigi muuŋgi tɨvi mbatɨgi ga suaŋv mbe suanga tuga sarigi. Ana zumgum mbe suanga tugar, mba fhum Ninivan kegi gumgi gu mbigi, mbe Fhe Bakɨme nɨman thivgip, mbe kha tugen kegi gumgi gu mbigi muuŋgi tɨvi bun suanga. Mba Ninivan ki gumgi, mbe khaŋ muuŋgi. Mbe Zona vov Fhe Bakɨme buni vhuuiŋ bun mbe nzuaim, mbe ndavi dorgi. Nde ntigem guma mbe nde rɨgar ki, mba guma, ana guigira Zona kambarigi. ");
INSERT INTO geb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Fhe Bakɨme mba tugen kha nuianan ki gumgi gu mbigi muuŋgi tɨvi mbatɨgi ga suaŋv mbe suanga, mba tugen saut fhain ki kuin, ana vhɨra hɨp Fhe Bakɨme nima thɨgɨp, ntige kha tugen ki gumgi gu mbigi muuŋgi tɨvi mbatɨgi bun suanga. Ne khaŋ muuŋgi, mba kuin ana za kha nuian vhɨzi tɨva guarara ki kuin ma. Ana Soromon won ndɨkndɨgi vhuuiŋ bun suaŋrim, ana nta mbarara zav zɨgi. Ntigem, khar ki guma mbe, ana guigira Soromon kambarigi.” ");
INSERT INTO geb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Ŋina mbatɨk guma mbe thav kɨrar hɨgap, vov ana gumgi ki fhu ŋanen vov, vhuksurga ŋani ndi gari. Ana maaŋ ganɨnga, ana ŋana vhuuŋ thueŋ gangi fhu. ");
INSERT INTO geb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ana maaŋ ganɨvra thav, ana taagi khaŋ suanga, ‘Gu taagi ŋgɨp, fhum wo kegi phenara kɨrga.’ Ana maaŋ suaŋgip, ana taagi zɨp, mba fhum kegi phena ganɨrim, mbe ana bigap, ana sɨɨŋgi. Bigi thari ana vhen ki fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ana ana gangip, taagi ŋgɨp, harigi harathɨgi ŋiniŋgi mbatɨgi, mbe guigira ana kambarav tɨvi mbatɨgi ga mbui ntɨɨri ma, ana mben kuv zɨrga. Ana mbe kuv zɨv, mbe mba phena vhen ŋgirgɨp, mba phena vhen kɨrga. Mba guma, ana fharav maneŋ mbatɨgia kegi, ana ntigem, ana guigira za mbatɨgirga. Kha khesharigi tɨvara kha nuianan ki gumgi gu mbigi mbatɨgir hɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Zisas mba bunin mba gumgi gu mbigi vhɨrve ga nzuavra kim, ana niamuuŋ gum ana ŋgugi, mbe zav ana mba vhen ki phena thɨma thivi. Mbe ana suan za zegi. ");
INSERT INTO geb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mbe zegim, guma mbe khaŋ Zisas ga nzuai, “Ndu mbarara! Ndun niamuuŋ gum ŋgugi, mbe ndu suan zav zegap kɨrar mbur ki.” ");
INSERT INTO geb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mba guma maaŋ Zisas ga nzuaim, Zisas ana ŋgarkarav khaŋ ana nzuai, “Theiŋ nan niamuuŋ, gu theiŋ nan ŋgugi?” ");
INSERT INTO geb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ana nen ana nzuav, wo phorga rui gumgi gu mbigi farasarav khaŋ ana nzuai, “Ndu na niamuuŋ gu ntogi ganɨ. ");
INSERT INTO geb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ne khaŋ muuŋgi, na Ndia kha Hevenan ki, guma o mbik ana nzuai vuzvugi zɨn vui, mba guma gu mbik nan ŋguk, gu bip gum, nan niamuuŋ ma.” ");
INSERT INTO geb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Zisas mba raara mba phena thav kɨrar hɨgap, vov Gariri mbɨ gaar vugap, Fhe Bakɨme buni vhuuin gumgi gu mbigi khɨvɨr zav perav ki. ");
INSERT INTO geb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ana Gariri mbɨ gaar kim, gumgi gu mbigi vhɨrve ana han zi. Gumgi gu mbigi vhɨrve ana han zim, ana thav, fega kema mben mbarav ana peregim, mba gumgi gu mbigi, mbe ana han thɨva thivgi. ");
INSERT INTO geb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mba gumgi gu mbigi ana han thivgim, Zisas Fhe Bakɨme buni vhuuiŋ vhɨrve mbe nzuav, ana vhunaa ga si bunira mbe nzuai. Ana khaŋ mbe nzuai, “Nde mbarara! Guma mbe vov wit vhɨgi ndi mɨna fui. ");
INSERT INTO geb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ana nta ndi fuim, vhɨgi mbari tuav ga regim, korgi zav nta mbegi. ");
INSERT INTO geb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mbari rav, ŋkɨɨa ki nuianeŋ ga regi, mba nuianeŋ nuiana vhuuŋ ki fhuvara, ŋkɨɨra nen ki. Mba nuiana bisaneŋ tɨra ki. Maaŋ muuŋgiap, mba wit vhɨgi regap, vhemkora thooŋgi. ");
INSERT INTO geb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nta thooŋgim, ra ndav nta shɨgim, nta thɨri khɨnan vergi fhu. Nta maaŋ muuŋgiap nzɨɨv, za shɨɨŋgiap, za vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ana nta ndi fuim, vhɨgi mbari, nta tari ki karɨgi ki nuianeŋ ga regi. Nta regap thooŋgim, mba tari ki karɨgi, nta kav nta zɨrgi. ");
INSERT INTO geb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ana nta ndi fuim, mbari rav nuianan vhuueŋ ga regap, mba tegi. Nta mba tav, mbari 100 vhɨgi mbai, mbari 60 vhɨgi mbai, mbari 30 vhɨgi mbarigi. ");
INSERT INTO geb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Guma khuarani kɨv kha buni mbararari.” ");
INSERT INTO geb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Zisas mba buni vhunaa ga sav mbe suaŋgim, zumgum Zisas farasegi 12 thɨgi ŋaara gumgi ana han zav kha nzambarar ana muuŋgi. Mbe khaŋ ana nzuai, “Ndu thaŋ nzuav vhunaa ga si bunin kha gumgi gu mbigi ga nzuai?” ");
INSERT INTO geb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Mbe ne nzuaim, Zisas mbe ŋgarkarav khaŋ mbe nzuai, “Fhe Bakɨme fhura nde garim, nde ana wo gumgi gu mbigi ana piin kɨv muunga tɨvi nɨɨŋge, ana nta vhagi. Ana fhura nde garim, nde nta kaŋgi. Ana ntan mbu gumgi gu mbigi vhagi. ");
INSERT INTO geb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Khueŋ guigira, guma Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga tɨva kaŋgi, Fhe Bakɨme wo gumgi gu mbigi ganɨnga bigi vhɨrve phorgɨp ana khɨvarga, ana guigira kaŋgirga. Guma ana Fhe Bakɨme won gumgi gu mbigi ganɨnga, mbe ana piin kɨrga tɨva kaŋgi fhu, ana mba kaŋgi ndɨkndɨga bisaneŋ, ana ana tɨn ne ndigirga. ");
INSERT INTO geb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Gu mba tɨvi nɨɨŋgera nzuav, gu vhunaa ga si bunin mbe phorga nzuai. Mbe rɨmgi kav, mbe gari, mbe bigɨn the gangirga fhu. Mbe khuari kav bigi mbararagi, mbe mba bigi mbararav bigɨn kaŋgirga fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Fhe Bakɨme kamthooŋ guma Aisaia mba gumgi gu mbigi muunga tɨvi, ana fhum nta bun suaŋgi. Ana mba suaŋgi buni, nta ntigem mbara muuŋgiap hɨgi. Ana fhum khaŋ suaŋgi, ‘Mbe zazera mba buni mbarararga, mbe nta ndɨriveŋ kaŋgirga fhu. Mbe vhɨra zazera ganɨnga, mbe bigɨn thueŋ kaŋgirga fhu. ");
INSERT INTO geb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mba gumgi gu mbigi, mben ndavi havhargi. Mbe khuari ki, mbe buni mbararagi fhu. Mbe vhɨra wari won rɨmgi pɨngi. Mbe rɨmgi taagip ganɨv, mbe mba bigi ganɨv, mbe khuarir nta tɨgɨp, nta mbararav, mbe ndavi vheri mba bigi ndɨriveŋ kaŋgip, mbe ndavi domdorgip, taagip na han zɨrim, gu mbe muuŋgirim, mbe nzera rivgi.’ ");
INSERT INTO geb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Maaŋ muuŋgip, nde ndikndigɨri. Nden rɨmgi mba bigi garim, nde bigi mbararagi. ");
INSERT INTO geb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Gu guigira nde nzuai, fhum Fhe Bakɨmen kamthooŋ gumgi vhɨrve gum, ana piin kav tɨvar vhuuaŋ mbui gumgir vhɨrve, mbe guigira nde ntige khar gari bigi ganɨngeŋ nzuav vuzvuk bakɨme mben ki. Mbe maaŋ muuŋgi, bigɨna thueŋ gangi fhu. Mbe vhɨra kha nde mbararagi buni, mbe nta mbarararga vuzvuk bakɨme ki. Mbe maaŋ muuŋgi buna thueŋ mbararagi fhu.” ");
INSERT INTO geb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde ntigem, guma wit vhɨgi ndi mɨna fui ne vhunama si buna nɨɨeŋ mbarara. ");
INSERT INTO geb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Gumgi gu mbigi, mbe Fhe Bakɨme piin kɨrga buna vhuueŋ, mbe ne mbararagi. Mbe ne mbararav, mba buna nɨɨeŋ kaŋgi fhuv gumgi gu mbigi, mbe khaŋ muuŋgi. Mbe mba tuav ga regi wit vhɨgi fara muuŋgi. Satan zav, mbe mba Fhe Bakɨme mbe ndavi vherir mpɨrigi buna vhuueŋ ana vhemkora mbe tɨn nta vharigi. ");
INSERT INTO geb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mba ŋkɨɨa ki nuianeŋ ga regi wit vhɨgi, nta khaŋ muuŋgi gumgi gu mbigi ma. Mba gumgi gu mbigi, mbe Fhe Bakɨme buna vhuueŋ mbararagiap, mbe vhemkora nta ndigap, ntan ndikndigi. ");
INSERT INTO geb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mba khesharigi wit vhɨgi mbe khaŋ muuŋgi. Mbe thɨri khɨnan vergi fhuvara. Nta maaŋ muuŋgiap tuga tɨvaneŋra kegi. Mba khesharigi gumgi gu mbigi, mbe kim, mbe Fhe Bakɨme buneŋ mbevi buni nzuav simtɨgar mbe ndɨɨim, mba khesharigi gumgi gu mbigi, mbe Fhe Bakɨme khothɨgi tɨv vhemkora mbatɨgiap vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mba tari ki karɨgi ki nuianeŋ ga regi wit vhɨgi, nta kha khesharigi gumgi gu mbigi ma. Mbe Fhe Bakɨme buna vhuueŋ mbararagi, mbe kha nuianan bigi ga nzuav thagine mbui ndɨkndɨk kɨvgia mben ki. Mbe kha nuianan bigi vhɨrve kɨrgeŋ vuzvugi. Maaŋ muuŋgiap, mba ndɨkndɨgi kɨvgia zav Fhe Bakɨme buna vhuueŋ mbevigim, Fhe Bakɨme buna vhuueŋ mba ti fhu. ");
INSERT INTO geb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mba nuiana vhuueŋ ga regi wit vhɨgi, nta khaŋ muuŋgi gumgi gu mbigi ma. Mba gumgi gu mbigi, mbe Fhe Bakɨme buna vhuueŋ mbararav, mbe guigira mba buna nɨɨeŋ kaŋgi. Mbe maaŋ muuŋgiap, mbe mbari 100 vhɨgi mbai, mbe mbari 60 vhɨgi mbai, mbe mbari 30 vhɨgi mbai.” ");
INSERT INTO geb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Zisas harigi buna mueŋ vhunama sav khaŋ mbe nzuai, “Fhe Bakɨme wo gumgi gu mbigi garim, mbe ana piin ki tɨv kha muuŋgi. Ana guma wit vhɨgi vhuuin wo mɨna fui fara muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ana ntan wo mɨna fuigim, maan gumgi gu mbigi kuim, mba guman pana guma zav, vhazɨgi mbatɨgir, anan wit rɨga fuigap, vugi. ");
INSERT INTO geb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ana vugim, zumgum mba wit vhuuŋgiap, vhɨgi maan za mbuim, mbe garim, vhazɨgi mbatɨgi vhɨra nta phorga vhuuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nta vhuuŋgim, mba mɨna namkaman ŋaara gumgi, mbe nta gangiap, vov khaŋ mba mɨna namkama nzuai, ‘Guman Rum, nza khaŋ suaŋgi thi? Ndu wit vhɨgi vhuuiŋra wo mɨna fuigi. Ram muuŋgiap, kha vhazɨgi mbatɨgi hegi?’ ");
INSERT INTO geb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Mbe maaŋ nzuaim, ana khaŋ mbe nzuai, ‘Nan pana guma mbe mba tɨva muuŋgi.’ Ana maaŋ mbe nzuaim, ana ŋaara gumgi wom khaŋ ana nzuai. ‘Ndu vuzvugirim, nza ŋgɨp, mbu vhazɨgi mbatɨgi suagip, nta ndiv phok khɨngirga.’ ");
INSERT INTO geb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mbe maaŋ nzuaim, ana khaŋ mbe nzuai, ‘Fhuvara. Nde mba vhazɨgi mbatɨgi suav kɨv, na wit vhuuiŋ thari phorgɨp suagi rivgi. ");
INSERT INTO geb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nde fhura nta ganɨrim, nta wari tɨgɨp kɨrim, mba vhuvuv, nta ndirga tuk hɨgɨri. Mba mba vhuvuv nta ndirga tugar, gu wo gumgi ga suaŋrim, mbe kha tɨvar muunga, “Nde fharav mba vhazɨgi mbatɨgi, nde nta suav, nta ndiv vhava sur saŋv, nta kɨgi kɨv nta ndi mbarari. Nde nan wit vhuuiŋ, nde nta fugup, na mba ndi vhui phenan vhuigɨri.” ");
INSERT INTO geb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Zisas harigi bigɨna mueŋ vhunama sav khaŋ mbe nzuai, “Fhe Bakɨme wo gumgi gu mbigi garim, mbe ana piin ki tɨv, ana kha zɨn rɨgi mpampara vhɨga fara muuŋgi. Mba mpampara zɨ khare, mastet. Guma mbe kha mpampar mastet, ana ana vhɨga ndiga vov wo mɨnan mpɨrigi. ");
INSERT INTO geb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastet vhɨk, ana harigi mpamparir vhɨgi fara muuŋgiap kɨvgi fhuvara. Ana guigira bisaŋgi. Ana zumgum vhuuv, guigira kɨvgiap, ana mba mɨnan ki mpampari, ana za nta kambarigi. Ana kha vhuui vhuuŋ mbara muuŋgiap, guigira kɨvgiap ŋgagi bakɨvi shɨgim, korgi zav ana ŋgagi khoni ga mbuav anan ki.” ");
INSERT INTO geb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Zisas wom harigi bigɨna mueŋ vhunama dav khaŋ mbe nzuai, “Fhe Bakɨme wo gumgi gu mbigi gari, mbe ana piin ki tɨv kha khesharigi. Mbiga mbe is ndigap, parawa ka bakɨ mbe phorga digi. Ana nta digim, mba parawa vhuuŋgiap ndav kɨvgi.” ");
INSERT INTO geb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Zisas mba bunin mba gumgi gu mbigi ga nzuav, ana vhunaa ga si bunira mbe nzuai. Ana buna thueŋ sigasarav mbe nzuai fhuvara. Ana fhura mba buni vhunaa ga sav mbe phorga nzuai. ");
INSERT INTO geb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ana mba tɨva mbuav, ana fhum Fhe Bakɨme won kamthooŋ guma ga suaŋgi kameŋ, ana ne khergim, ne ki. Ana mba kameŋra zɨn vugi tɨva muuŋgi. Fhe Bakɨme khergi kameŋ khaŋ suaŋgi, “Gu vhunaa ga si bunira nde suanga. Gu mba fhum kha nuiana gu buip hɨgi fhu. Ana mba tugen zorga ki bigi, gu nta bun nde suanga.” ");
INSERT INTO geb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Zisas mba bunin mba gumgi gu mbigi ga suaŋgia thugap, vov phena vhen vergi. Ana phena vhen vergim, ana phorga rui gumgi ana han zav khaŋ ana nzuai, “Ndu mba vhazɨgi mbatɨgi mɨnan ndagi ne vhunama sav suaŋgi buna nɨɨeŋ bun nza suaŋ.” ");
INSERT INTO geb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Mbe maaŋ nzuaim, Zisas mbe ŋgarkarav khaŋ mbe nzuai, “Mba wit vhɨgi ndiv mɨna fui guma, ana Fhe Bakɨme Guma Guar ma. ");
INSERT INTO geb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mba mɨn, ana kha nuiana ma. Mba wit vhɨgir vhuuiŋ, nta Fhe Bakɨme garim, ana piin ki gumgi gu mbigi ma. Mba vhazɨgi mbatɨgi, nta Satan zɨn vui gumgi gu mbigi ma. ");
INSERT INTO geb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mba pana guma mba vhazɨgi mbatɨgi ndi mɨna fui, ana Satan ma. Mba mba vhuvuv nta ndirga tuk, ana kha nuiana gu buip vhɨzɨrga tuk ma. Mba ŋaara gumgi, mbe Fhe Bakɨme enseri ma. ");
INSERT INTO geb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mba gumgi mba vhazɨgi mbatɨgi fugap nta mpooi tɨvara, mbe za kha nuian gu buip vhɨzi tugar mba tɨvara muunga. ");
INSERT INTO geb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Fhe Bakɨme Guma Guar won enseri ga sararim, mbe zirɨv, Fhe Bakɨme khothɨgi tɨvir farfagi gumgi gu mbigi ga mbuim, mbe rav tɨvi mbatɨgi ga mbui gumgi, mbe za mbe fugɨrga. ");
INSERT INTO geb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mbe mbe fugɨp, mbe fuv vhava suegɨrga. Mbe mba vhavara kɨv, zaa mbatɨga ndiv, sɨsɨm mbatɨgar muuŋv, tari ntɨɨri phɨrɨrga. ");
INSERT INTO geb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mba tugen, mba tɨvir vhuuiŋ mbui gumgi gu mbigi, mbe ra shɨgi farar muuŋgip shɨrav, wari wo Ndia phorgɨp Hevenan kɨrga. Guma khuarani kɨv, ana kha buni mbararari!” ");
INSERT INTO geb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Fhe Bakɨme won gumgi gu mbigir ganɨrim, mbe ana piin kɨrga tɨv khaŋ muuŋgi. Guma mbe ŋkɨɨa kovsɨk khɨga nta ndiv mɨnan zorgi fara muuŋgi. Mba guma nta ndiav zorga kim, guma mbe nta gangiap, karav nta ndi zorgi fara muuŋgi. Mba guma maaŋ muuŋgiap, guigira ndikndiga mbatɨga mbua vov, za wo bigi ndi mbaim, mbe za nta vhezgim, ana mbara vov mba mɨna vhezgi.” ");
INSERT INTO geb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Vhunama si buna mueŋ khare, Fhe Bakɨme won gumgi gu mbigir gari, mbe ŋgɨp ana piin kɨrga ŋgun vhen ŋgirɨrga tɨv khaŋ muuŋgi. Shɨga mbui guma mbe karɨgi vhuuiŋra nzuav gari. ");
INSERT INTO geb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ana gara vov, karɨga mbe garim, ana guigira vhergim, ana mbaram vov za wo bigi ndi mbaim, mbe nta vhezgim, ana mbara zav mba karɨgin vhuuiaŋ vhezi.” ");
INSERT INTO geb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Vhunama si buna mueŋ khare. Fhe Bakɨme won gumgi gu mbigir gari, mbe ŋgɨp ana piin kɨrga ŋgun vhen ŋgirɨrga tɨv mbe vhaaŋ ndi mbɨ khɨngiap mbarkɨrga mbaga ndi fara muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mbe mba vhaaŋ ndi khɨngim, ana givigim, mbe ana ŋgɨrga thɨvar ndagi. Mbe nta ŋgɨrga thɨvar ndav, nta heei. Mbe nta heev mbaga vhuuiŋ, mbe nta ndiv thuuri ga suav, mbaga mbatɨgi, mbe nta fuasui. ");
INSERT INTO geb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Zumgum kha nuian vhɨzɨrga tugen, mba tɨvara muunga. Fhe Bakɨme enseri zɨv, mba tɨvara muuŋgirga. Mbe zɨv mba gumgi gu mbigi vhuuiŋ rɨgar mba gumgi gu mbigi mbatɨgi heeŋgirga. ");
INSERT INTO geb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Mbe mba mbatɨgi heeŋgip, mbe fuv vhava bakɨme suegɨrga. Mbe mba vhavar kɨv, sɨsɨm mbatɨgar muuŋv, tari ntɨɨri phɨrɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Zisas mba bunin mbe suaŋgiap, mbaram wo phorga rui gumgir nzarigi, “Nde za kha buni ndɨɨriveŋ kaŋgire?” Mbe khaŋ ana nzuai, “Ahaŋ.” ");
INSERT INTO geb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ana mbaram khaŋ mbe nzuai, “Maaŋ muuŋgiap, mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi, mbe Fhe Bakɨme piin kɨrga tɨva kaŋgiap, mbe ana piin ki, mbe mba phena gari vuavi fara muuŋgi. Mba phen, ana guigira rogi, mbarkɨrga bigir vhuuiŋ guigira givav ana vhen ki. Ana phena vhen verav, bigi ŋkaa gum vuri ndiav kɨrar hi.” ");
INSERT INTO geb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Zisas mba vhunaa ga si bunin mbe suaŋgiap, mba ŋgu thav vui. ");
INSERT INTO geb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ana mba ŋgu thav vov, wo ŋgu nɨɨŋgera vugi. Ana vugap, mbara vov, mbe Fhe Bakɨme buni vhuuiŋ mbararagi phena vhen vergap, Fhe Bakɨme buni vhuuin gumgi gu mbigi khɨvav mbe nzuai. Ana Fhe Bakɨme buni vhuuin mbe nzuaim, mbe ana buni mbararav, ŋgava mbatɨga mbuav khaŋ nzuai, “Kha guma maaŋ kha ndɨkndɨga ndigi? Ana ram muuŋgia kha mirikori ga mbui? ");
INSERT INTO geb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nza ana kaŋgi, ana pheni ga mbui guman kam ma. Ana niamuuŋ Maria ma. Zems gu Zosep, Saimon Zudas, mbe ana ŋgugi ma. ");
INSERT INTO geb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Anan mbiga hɨriŋ, mbe nza phorga khar ki. Ana maaŋ kha bigi ndigi?” ");
INSERT INTO geb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mbe maaŋ ana nzuav, ana khothɨgi fhu. Zisas khaŋ mbe nzuai, “Fhe Bakɨme kamthooŋ guma, ana za kha ŋguir zɨ ki. Ana wo ŋgu nɨɨŋgera, ana wo fegutarira han, ana zɨ ki fhu.” ");
INSERT INTO geb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ana maaŋ muuŋgiap, ana wo ŋgu nɨɨŋgera, ana mirikori vhɨrve ga muuŋgi fhu. Ne khaŋ muuŋgi, mbe ana khothɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Mba tugivigen, ŋgui gari guman pana vhari Herot, ana Zisas mbui bigi kameŋ mbararagiap khaŋ won ŋaara gumgi ga nzuai, “Mbu guma, ana Zon Gumgi Ruai Gumarame? Ana rimgim, mbe ana ndi mboga tɨgim, ana taagia khavgire! Ana maaŋ muuŋgiap, mba ŋkasŋka kav mba mirikori ga mbui.” ");
INSERT INTO geb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herot fhum won ŋguk Firip tɨn ana muuŋ Herodis ga tɨgi. Ana ana tɨgim, Zon Gumgi Ruai Guma khaŋ ana nzuai, “Nza Zudaiŋ nzan tɨv khaŋ nzuai, ndu mba mbiga tɨgi ne nzerigi fhuvara.” Zon Gumgi Ruai Guma ne suaŋgim, Herot ne nzuav ana suirav, shenan ana kegap, ana ndi bɨna khɨngi. ");
INSERT INTO geb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot Zon Gumgi Ruai Guma shogirim, ana rɨmɨn zav mbuav, ana mba gumgi gu mbigir rivgi. Mbe khaŋ muuŋgiap, mbe za khaŋ Zon Gumgi Ruai Guma ga nzuai, “Ana Fhe Bakɨmen kamthooŋ guma ma.” ");
INSERT INTO geb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herot maaŋ muuŋgiap kim, raa mben, ana niamuuŋ ana tegi tuk, ana mba tuga ndɨkndɨgap, gumgi mbarir kamgim, mbe zav ana phorga pi. Mba tugen Herodisan kambik zav mbe nɨman hii. Ana hiim, Herot guigira ana hɨɨ vuzvugi. ");
INSERT INTO geb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Maaŋ muuŋgiap, Herot kha kama havharen ana nzuai, “Gu guigi guarara khar ndu nzuai, kha vun ki guma na kaŋgi, ndu bigɨn then nan nzanga, gu mba bigɨnan ndun nɨɨnga.” ");
INSERT INTO geb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Herot mba suambarar ana muuŋgim, mba biptar niamuuŋ Herodis, ana fhum ndɨkndɨgar ana nɨɨŋgi. Maaŋ muuŋgiap, Herot mba nzambarar ana muuŋgim, mba biptar khaŋ Herot ga nzuai, “Gu Zon Gumgi Ruai Guman pana vuzvugi, ndu anan thuuŋ the khɨngip, ndigɨ na ndi zɨri.” ");
INSERT INTO geb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ana ne nzuaim, mba ŋgui vhɨrve gari guman pan Herot, ana ne mbararagiap guigira ndava simgi. Ana ndav simgiap, ana vhɨra wom wo suaŋgi kama havhareŋ ga ndɨrgap thav, ana vhɨra, mba ana phorga pi gumgi ne mbararagim, ana ne mbergi. Ana maaŋ muuŋgia thav, mbaram mba ntari ga mbui gɨɨtɨvi ga nzuaim, mbe mba biptar suaŋgi kameŋ zɨn vugi. ");
INSERT INTO geb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ana thav guma mbe sarigim, ana mbaram vov mba phena tɨvaneŋ vugap, mba ntari ga mbui gɨɨtɨvi ga suaŋgim, mbe Zon Gumgi Ruai Guma fhɨra thugi. ");
INSERT INTO geb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mbe ana fhɨra thugap, ana ndi thuuŋ mbe khɨngiap, ana ndiga vov mba biptara nɨɨŋgi. Ana ana ndiga vov, won niamuuŋ ga nɨɨŋgi. ");
INSERT INTO geb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mbe Zon fhɨra thugim, ana phorga rui gumgi zav, ana khuma ndiga vov, ana mpɨrigi. Mbe ana khuma mpɨrav vov, ne bun Zisas ga nzuai. ");
INSERT INTO geb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Zisas Zon Gumgi Ruai Guma mbe ana shogim, ana rimgi ne mbararagiap, ana mba ki ŋgu thav, kema ndigap gumgi ki fhuv ŋanen vugi. Ana wo phorga rui gumgira kov mbe vegi. Ana vugim, mba gumgi gu mbigi vhɨrve ana vui ŋaneŋ kaŋgiap, mba gumgi gu mbigi, mbe tamtam wari wo ŋgui bakɨvir kegap Zisas han zi. ");
INSERT INTO geb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Maaŋ muuŋgiap, Zisas vov phogap garim, gumgi gu mbigi vhɨrvera ana rarga ki. Ana mbe gangiap guigira mbe kora muuŋgia thav, mben rɨɨi gumgi, ana mben rɨmrɨɨ ga mbuim, nta vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ana maaŋ mbe mbuav kim, ra verav vhɨzgim, ana phorga rui gumgi ana han zav khaŋ ana nzuai, “Ai, khe gumgi ki fhuv ŋaneŋ khare, kha ra verav vhɨzɨ za mbui, ndu kha gumgi gu mbigi ga sararim, mbe ŋgɨ. Mbe ŋgɨp wari ndi mba vhezɨv, mbɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Zisas phorga rui gumgi maaŋ ana nzuaim, ana khaŋ mbe nzuai, “Mbe thaŋ suaŋv ŋgɨrie? Nde nduarira mban mben kur mbɨ!” ");
INSERT INTO geb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Zisas maaŋ mbe nzuaim, mbe khaŋ ana nzuai, “Nza mba vhɨrve ndiga zegi fhu. Nza meeŋthɨgi vikntuuveŋ mbɨgama shɨɨŋ mpuani phorga ndiga zegi.” ");
INSERT INTO geb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Mbe maaŋ nzuaim, ana khaŋ mbe nzuai, “Nde nta ndigɨ na ndi zɨ.” ");
INSERT INTO geb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mbe nta ndiga zav Zisas ga nɨɨŋgim, Zisas mbaram, mba gumgi gu mbigi ga nzuaim, mbe fhura mba vhazɨgɨna piigi. Mbe piigim, ana mbaram mba meeŋthɨgi vikntuuveŋ ndigap, mba mbɨgama shɨɨŋ phuni phorga ndigap, khogap buiva garav Fhe Bakɨme ndikndigap ana phorga suaŋgiap, mbaram, mba meeŋthɨgi vikntuur phɨrav wo phorga rui gumgi ga ndɨɨim, mbe nta shama mbuav, mba gumgi gu mbigi ga ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mbe ntan za mba gumgi gu mbigi ga nɨɨŋgim, mbe za mbegap ndavi givigi. Mbe za ndavi givav, thagi mban tɨvi mbe nta fugap 12 thɨgi kɨra ga vhuigim, nta za givigi. ");
INSERT INTO geb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mba tugen, mba mba mbegi gumgira, mben vhɨrve 5,000 thɨgi. Mbe mba mbigi gu tari phorga ruemgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mbe mbega thugim, Zisas mbaram wo phorga rui gumgi ga sarigim, mbe kema mbe ndigap, fharav mba mbɨ thugav mueŋ nderen hi. Ana nduara kɨv mba gumgi gu mbigi ga sararim, mbe ŋgegɨrim, ana zumgum ŋgɨrga. ");
INSERT INTO geb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ana mbe sararim, mbe ŋgegɨrim, ana nduara mbɨkshɨman naaŋv Fhe Bakɨme phorgɨp suanga. Mbe vegim, ra verav vhɨzim, ana nduara mba mbɨkshɨman ki. ");
INSERT INTO geb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ana nduara mbɨkshɨman kim, mba ana phorga rui gumgi, mbe kema ndiga mba mbɨn saman vegi. Mbe saman vegim, bɨɨŋbɨɨŋ zav mba kema bena rɨgim, mbɨ phuri zav mba kema shogi. ");
INSERT INTO geb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mbe vuav kim, maaŋ gɨngiap, mɨn gorɨ zav mbuim, Zisas mbɨn tɨn thivav, mben han vui. ");
INSERT INTO geb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ana mbɨn tɨn thivav mben han vuim, mbe ana gangiap, mbe guigira rivgiap, ninɨnga mbatɨga mbui. Mbe ninɨnga mbatɨga mbuav khaŋ nzuai, “Khe tor ma.” Mbe ne nzuav, rɨrɨva mbatɨga muuŋgiap sɨsɨm mbatɨga mbui. ");
INSERT INTO geb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mbe sɨsɨm mbatɨga mbuim, Zisas vhemkora khaŋ mbe nzuai, “Nde rɨvɨ thari, nde havhargiri, gura.” ");
INSERT INTO geb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ana ne nzuaim, Pita ana ŋgarkarav khaŋ ana nzuai, “Guman Rum, guigira ndura, ndu na suaŋrim, gu mbɨn tɨn thivɨv ndu han ŋgɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ana ne nzuaim, Zisas mbaram khaŋ ana nzuai, “Ndu zɨ.” Ana maaŋ nzuaim, Pita mba kema thav, mbɨn tɨn thivav, Zisas han vui. ");
INSERT INTO geb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ana thivav vov, ana kha bɨɨŋbɨɨŋ garim, ana guigira kɨvgim, ana rivgi. Ana rivav thav, mbaranera korgia mbɨn verav thav, kaav khaŋ nzuai, “Guman Rum, nan kura.” ");
INSERT INTO geb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ana ne nzuaim, Zisas vhemkora wo hara ndi mbarav Pitar suirigi. Zisas ana suirav khaŋ ana nzuai, “Ndu na khothɨgi ndɨkndɨk guigira bisaŋgi. Ndu thaŋ nzuav ndɨkndɨk phuniaŋ mbui?” ");
INSERT INTO geb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Zisas nen ana nzuav, mani fega keman mbarigim, mba bɨɨŋbɨɨŋ fhura mbɨrigi. ");
INSERT INTO geb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mba bigeŋ maaŋ muuŋgim, mba keman ki gumgi, mbe Zisas zɨ ndi vun fav ana rotu mbuav khaŋ nzuai, “Guigi guarara, ndu Fhe Bakɨmen Kam ma.” ");
INSERT INTO geb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Zisas wo phorga rui gumgir kov, mbe muen nderen Genesaret fhaiŋ phorgi. ");
INSERT INTO geb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mbe vov phorgim, mba fhain ki gumgi gu mbigi, mbe Zisas gara vov ana kheharav, mbe mbaram ana bun za mba fhain hara ki ŋgui ga suaŋgim, mbe rɨɨi gumgi ndiav ana han zi. ");
INSERT INTO geb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Mbe mba rɨɨi gumgi ndiav Zisas han zav, mbe khaŋ tɨgap mba rɨɨi gumgi Zisas sharigi shagi tɨvir suigɨr zav Zisasan nzai. Mbe ana nzav, mba rɨɨi gumgi ana shaa tɨvar suigap, mbe za rɨmrɨɨ vhɨzi. ");
INSERT INTO geb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mba tugen, Fherasiŋ mbari gu Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi mbari, mbe Zerusareman kegap Zisas han zergi. Mbe zergap kha nzambarar ana muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ram muuŋgi tɨv khare, ndu phorga rui gumgi mbe nzan nzɨgi tɨvi phɨrgiap nzan nzɨgir tɨva zɨn vui fhu? Mbe maaŋ muuŋgiap, mbe mban mbɨr zav, nza fari ruai tɨva zɨn vuav fari ruai fhu!” ");
INSERT INTO geb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mbe mba nzambareŋ ga muuŋgim, Zisas mbe ŋgarkarav khaŋ mbe nzuai, “Maaŋ muuŋgiap, nde thaŋ nzuav Fhe Bakɨme suaŋgi tɨva phɨrgiap, nde wari wo tɨvira zɨn vui? ");
INSERT INTO geb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Fhe Bakɨme suaŋgi tɨv khare, ana khaŋ nzuai, ‘Ndu wo niamuuŋ gu ndia piin kɨv, mani nzuai buni mbararari. Maaŋ muuŋgip, guma the buni mbatɨgir wo niamuuŋ gu ndia ga suaŋgirga, nde ana shogirim, ana rimgiri.’ ");
INSERT INTO geb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nde vhɨra khaŋ nzuai, ‘Guma the wo niamuuŋ gu ndiar kurkurarga ŋkɨɨa kɨrga, ana khaŋ mani ga suanga, “Gu ŋkon nɨɨnga ŋkɨɨa, gu ntan Fhe Bakɨmen mbuigi.” ");
INSERT INTO geb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mba guma maaŋ suaŋgiap, ana wom wo niamuuŋ gu ndiar kurkurarga ndɨkndɨk ana ki fhu.’ Nde mba tɨva mbuav, nde Fhe Bakɨme suaŋgi tɨva mbevav, nde won nzɨgi han ndigi tɨvi, nde nta zɨn vui. ");
INSERT INTO geb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Nde maaŋ mbuav, nde bigi shɨshɨgi gumgi ma. Fhe Bakɨmen kamthooŋ guma Aisaia nzerara nden tɨvara nzuav khaŋ suaŋgi, ");
INSERT INTO geb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Mba gumgi gu mbigi, mbe kaathoorin na zɨ ndi vun fi. Mben ndavi gu mben ndɨkndɨgi na thav samra ki. ");
INSERT INTO geb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mbe gumgi nduarira suaŋgi tɨvi, mbe nta bun nzuav, mbe fhura shɨshɨgap khaŋ nzuai, “Khe Fhe Bakɨme suaŋgi tɨvi ma.” Mbe maaŋ mbuav, mbe fhura shɨshɨgap na rotu mbui.’ ” ");
INSERT INTO geb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Zisas mba buni suaŋgiap, mbaram mba gumgi gu mbigir kamgim, mbe ana han zim, ana khaŋ mbe nzuai, “Nde kha buni mbararagip, nde tuituigip nta ndɨkndɨgɨri. ");
INSERT INTO geb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Guma kamthoon veri bigi, nta guma ndava vhee mbuim, ana Fhe Bakɨme nɨman nzaŋnzai fhu. Fhuvara. Guma kamthoon kegap kɨrar hi bigi, nta guma ndava vhee mbuim, ana Fhe Bakɨme nɨman nzaŋnzai.” ");
INSERT INTO geb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Zisas mba buni suaŋgim, zumgum ana phorga rui gumgi zav khaŋ ana nzuai, “Kha Fherasiŋ ndu suaŋgi buni mbararagiap ndu nzuav ndav shigi ne, ndu ne kaŋgi thi?” ");
INSERT INTO geb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mbe nen ana nzuaim, Zisas mbe ŋgarkarav khaŋ nzuai, “Nan Ndia, ana Hevenan ki, ana ganɨnga, ana nduara won farven pargi fhuv bigi, ana thɨri khɨgɨp, nta siv nta fusuegɨrga. ");
INSERT INTO geb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nde Fherasiŋ ndɨkndɨgɨ thari. Mbe rɨmgi mbatɨgi gumgi fara muuŋgi. Mbe rɨmgi mbatɨga, fhura tuavar harigi gumgi khɨvɨr za mbui. Maaŋ muuŋgip, rɨmani mbatɨgi guma the, ana tuavar harigi rɨmani mbatɨgi guma khɨvɨv, mani ŋgɨrga, mani vhɨra wani tɨgɨra mbok thɨgɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Zisas nen mbe nzuaim, Pita kha nzambarar ana muuŋgi. “Ndu mba vhunama dav kha gumgi gu mbigi ga suaŋgi buna nɨɨeŋ bun nza suaŋ.” ");
INSERT INTO geb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Pita ne nzuaim, Zisas khaŋ nzuai, “Ee, nde ram muuŋgi? Ee, nde vhɨra ne nɨɨeŋ kaŋgi fhuve? ");
INSERT INTO geb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ee, nde vhɨra khueŋ kaŋgi fhuve? Kamthoon veri bigi, nta za mbun verim, mbu zumgum nta ndiga vov vhi phenan nta fuasui. ");
INSERT INTO geb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kamthoon kegap kɨrar hi bigi, nta ndɨkndɨgar kegap kɨrar hi. Mba bigi, nta guma ndava vhee mbuim, ana Fhe Bakɨme nɨman nzaŋnzaŋgi. ");
INSERT INTO geb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gu kha khesharigi bigi, nta guma ndɨkndɨgar kegap, ana kamthoon kɨrar hi, gu nta nzuai. Nta khare, ndɨkndɨgi mbatɨgi, guma sogim ana rimgi, mbarkɨrga tɨvi mbatɨgi ga mbuav ruarin mbigi gu gumgi wari ndiav ki, mani gu mburi wari thamthav ruarin harigi gumgi gu mbigi kɨɨi, fhura gumgi gugugap mbe nzuav nzuai, buni mbatɨgi harigi ntɨɨri ga nzuai. ");
INSERT INTO geb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kha khesharigi bigi gumgi nta mbui, mbe Fhe Bakɨme nɨman nzaŋnzaŋgi. Guma fari ruagiap mba pi fhu, ne mba guma ga muuŋgim, ana nzaŋnzaŋgi fhu.” ");
INSERT INTO geb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Zisas mba bunin mbe suaŋgiap, mba ŋgu thav, Taia gu Saidon ŋgu bakɨni fhain vui. ");
INSERT INTO geb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ana Taia gu Saidon fhain vugim, Kenanan mbiga mbe zav kaav khaŋ ana nzuai, “Guman Rum, ndu Devitan kam ma, ndu nan korar muuŋ. Ŋina mbatɨga mbe guigira nan kambigar farfagi.” ");
INSERT INTO geb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ana maaŋ nzuaim, Zisas buna thuen ana fagi fhuvara. Ana fhura kim, ana phorga rui gumgi ana han zav khaŋ thɨgap ana nzuai, “Mbu mbik kakama mbatɨga mbuav, nza zɨn zi. Ndu ana sarari, ana ŋgɨ.” ");
INSERT INTO geb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mbe ne nzuaim, Zisas mbaram khaŋ nzuai, “Fhe Bakɨme Isreriŋra nzuav na sarigim, gu zɨgi. Gu mben kurkurarga, mbe sipsivi fara muuŋgiap mbararegi.” ");
INSERT INTO geb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ana maaŋ nzuaim, mba mbik Zisas hara zɨgap, ana nɨmara wo thɨpaneni phɨrgiap, ana nɨman fav wo khoma ndi nuiana dav, khaŋ ana nzuai, “Guman Rum, ndu nan kurari.” ");
INSERT INTO geb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ana maaŋ nzuaim, Zisas ana ŋgarkarav khaŋ ana nzuai, “Nza tarir mba ndi feiŋ ga sui ne nzerigi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Zisas ne nzuaim, mba mbik ana ŋgarkarav khaŋ ana nzuai, “Guman Rum, ndu guigira mbar nzuai. Feiŋ mbe won namŋga pi mban tɨvi, mbe nta pi.” ");
INSERT INTO geb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ana ne nzuaim, Zisas ne mbararagiap, ana ŋgarkarav khaŋ ana nzuai, “O, mbik, ndu na khothɨgi ndɨkndɨk guigira kɨvgi. Ndu mba won hɨrgeŋ vuzvugi bigeŋ, ne ndun hɨgɨri.” Zisas nen ana suaŋgim, mba tugara ana kambik taagia nzerigi. ");
INSERT INTO geb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Zisas maaŋ mba mbigar kambigar kurav mba ŋgu thav vov Gariri mbɨ gaan vugi. Ana vov Gariri mbɨ gaan mbɨkshɨman ndav perigi. ");
INSERT INTO geb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ana maaŋ perigim, gumgi gu mbigi vhɨrve ana han zi. Mbe ana han zav, mbe suira mbatɨgi gumgi, mbe mbe ndiav zi, mbe rɨmgi mbatɨgi gumgi, mbe mbe ndiav zi, mbe hari gu bigi kɨzgeregi gumgi, mbe mbe ndia zi, mbe thɨri pɨngiap buni nzuai fhuv gumgi, mbe mbe ndiav zi, mbe vhɨra harigi rɨmrɨɨ ki gumgi vhɨrve, mbe vhɨra mbe ndiav zi. Mbe mbe ndia zav Zisas nɨman fi. Ana mbe mbuim, mbe taagia nzezerigi. ");
INSERT INTO geb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ana maaŋ mbe mbuim, mba gumgi gu mbigi, mbe mba thɨri pɨngi gumgi garim, mbe buni nzuaim, mbe mba hari gu bigi kɨzgeregi gumgi garim, mbe hari gu bigi nzerigim, mbe vhɨra mba suira mbatɨgi gumgi, mbe mbe garim, mbe suira ŋkasŋkagim, mbe thiva ruim, mbe mba rɨmgi mbatɨgi gumgi garim, mbe rɨmgi nzerigim, mbe bigi garim, mbe mbe gangiap, mbe ndɨkndɨgi vhɨrve ga mbui. Mbe ndɨkndɨgi vhɨrve ga mbuav, mbe Isreriŋ Fhe Bakɨme, mbe ana zɨ ndi vun kuagi. ");
INSERT INTO geb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Zisas mba rɨɨi gumgi gu mbigir kurkurav kav, mbaram wo phorga rui gumgir kamgim, mbe zim, ana khaŋ mbe nzuai, “Gu kha gumgi gu mbigi kora muuŋgi. Mbe na phorga kim, ra phuni khegene vhɨzgim, mbe mba ki fhu. Gu thi ndavira mbe sararim, mbe ŋgɨrgeŋ thagi. Gu mbe sararim, mbe ŋgɨp, mbe tuavar thir vhɨzɨv, rɨmgi mbe hiiŋrim, mbe ŋgegɨrga fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ana maaŋ nzuaim, ana phorga rui gumgi khaŋ ana nzuai, “Khe gumgi ki ŋaneŋ fhuvara. Nza maam vikntuu ndigip, khaŋ muuŋgi vhɨrver kurmbegɨrie?” ");
INSERT INTO geb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Mbe maaŋ nzuaim, Zisas mben nzarigi, “Nde rarara vikntuu mbar ki?” Mbe khaŋ ana nzuai, “Nza harathɨgi vikntuu mbaga bisarire babara phorga khar ki.” ");
INSERT INTO geb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Mbe maaŋ nzuaim, Zisas mbara mba gumgi gu mbigi ga nzuaim, mbe fhura mba nuiana piigi. ");
INSERT INTO geb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ana mbara mba harathɨgi vikntuu mba mbagare phorga ndigap, mbaram Fhe Bakɨme ndikndigap ana phorga suaŋgiap, nta phɨrav, wo phorga rui gumgi ga ndɨɨi. Ana nta phɨrav mbe ndɨɨim, mbe nta shama mbuav mba gumgi gu mbigi ga ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mbe ntan mbe ndɨɨim, mba gumgi gu mbigi, mbe za mbegap ndavi givigi. Mbe za mbegap ndavi givav thagi mban tɨvi, mbe nta fugap harathɨgi kɨra ga vhuigim, nta za givigi. ");
INSERT INTO geb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mba tugen, mba mba mbegi gumgira, mben vhɨrve khaŋ muuŋgi, 4,000. Mbe mbigi gu tari vhɨra mbegi, mbe mben ruemgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mbe mbega thugim, Zisas mbe sarigim, mbe vuim, ana mbaram fega keman mbarav, Magadan fhain vui. ");
INSERT INTO geb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Zisas Magadan vugim, Fherasiŋ mbari gu Sadusiŋ mbari, mbe Zisasan panɨ zav ana han zi. Mbe ana han zav, ana mparav khaŋ ana nzuai, “Ndu mirikor then muuŋgirim, nza gangip khaŋ suanga, ana Fhe Bakɨmen ŋaara mbui.” ");
INSERT INTO geb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mbe maaŋ ana nzuaim, ana mbe ŋgarkarav khaŋ mbe nzuai, “Nde ra garim, ana ŋkotuguraagen verav hɨvim, nde khaŋ nzuai, ‘Tugar vhuuŋ ntige kɨrga.’ ");
INSERT INTO geb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nde vhɨra manera buiva garim, ana phɨgiav hɨvgim, nde khaŋ nzuai, ‘Mbok gu bɨɨŋbɨɨŋ ntigem zɨrga.’ Ahaŋ, nde nzerara buiva garav, mba bigi hehegi, ne nzerara. Nde ntige, kha tugen hi bigi garav, nta hehegi fhu. ");
INSERT INTO geb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nde ntige, vhuuŋgia ki gumgi gu mbigi, nde gumgi gu mbigi mbatɨgi ma. Nde guigira wari won ndavir Fhe Bakɨme nɨɨŋgi fhuvara. Mbe zazera mirikori ga nzuav nzai. Mbe nzai mbe mirikor the gangirga tuktɨgi fhuvara. Mbe ganɨnga mirikor bavira Fhe Bakɨmen kamthooŋ guma Zona ana muuŋgi.” Zisas mba kamen mbe suaŋgiap, mbe thav vui. ");
INSERT INTO geb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Zisas mba bunin mbe suaŋgiap, ana wo phorga rui gumgir kov, mbe kema ndigap, Gariri mbɨ thugap mueŋ ndereŋ phorgi. Mbe vov phogiap, ana phorga rui gumgi, mbe vikntuu ndirgeŋ ndɨkndɨk ŋangi. ");
INSERT INTO geb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Zisas mbaram khaŋ mbe nzuai, “Nde tuituigira ganɨri. Nde tuituigira mba Fherasiŋ gu Sadusiŋ is gangiri.” ");
INSERT INTO geb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ana nen mbe nzuaim, ana phorga rui gumgi mbe nduarira khaŋ wari ga nzuai, “Ana nza vikntuu ndiga zɨgi fhuv ne nzuav, ana nen nza nzuai thi?” ");
INSERT INTO geb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mbe ne wari ga nzuaim, Zisas mbe nzuai ne kaŋgiap khaŋ mbe nzuai, “Nde na khothɨgi ndɨkndɨk guigira bisaŋgi. Nde thaŋ nzuav khaŋ nzuai, ‘Nza vikntuu ki fhu?’ ");
INSERT INTO geb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ee, nde kaŋgi fhuve? Nde mba 5,000 gumgi mba meeŋthɨgi vikntuuveŋra mbegap, ndavi givav, mbari thagi. Nde mbe thagi mban tɨvir rarara kɨra ga vhuigim nta givigi? ");
INSERT INTO geb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nde vhɨra mba 4,000 gumgi mba harathɨgi vikntuuveŋra mbegap ndavi givav, mbari thagi. Nde mbe thagi mban tɨvir rarara kɨra ga vhuigim, nta givigi? Nde mba bigi ga ndɨrigi fhuve? ");
INSERT INTO geb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nde ram muuŋgiap khueŋ kaŋgi fhu? Gu vikntuu ga ndɨkndɨgap kha kamen nde nzuai fhuvara. Gu khaŋ nde nzuai, nde mba Fherasiŋ gu Sadusiŋ is, nde tuituigira ana ganɨri.” ");
INSERT INTO geb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ana nen mbe suaŋgim, mbe ne mbararagiap kaŋgi. Ana mbe vikntuu tui is ga nzuai fhuvara. Ana mbe Fherasiŋ gu Sadusiŋ, mbe khɨvav, mbe nzuai buni, ana mbe tuituigira nta ganɨngen mbe gori ruav mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Zisas maaŋ kegap khavgiap, Sisaria Firipai ŋgu bakɨme fhain vui. Ana vov, ana mba tugen, ana kha nzambaren wo phorga rui gumgi ga muuŋgi. Ana khaŋ mbe nzuai, “Kha gumgi gu mbigi, mbe Fhe Bakɨme Guma Guar, mbe ram mbui suambarar ana mbui, ana the guarara?” ");
INSERT INTO geb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ana ne nzuaim, mbe khaŋ ana nzuai, “Mbe mbari khaŋ nzuai, ‘Ndu Zon Gumgi Ruai Guma ma.’ Mbe mbari khaŋ nzuai, ‘Ndu Iraiza ma.’ Mbe mbari khaŋ nzuai, ‘Ndu Zeremaia thi? Ndu mba Fhe Bakɨme kamthooŋ guma mbe ma.’ ” ");
INSERT INTO geb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mbe maaŋ nzuaim, Zisas mben nzarigi, “Mbe mba suambarar na mbuim, nde ram mbui suambarar na mbui, gu the ma?” ");
INSERT INTO geb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ana ne nzuaim, Saimon Pita mbaram ana ŋgarkarav khaŋ ana nzuai, “Nde Fhe Bakɨme taagip za kha nuianan ki gumgi gu mbigi ndir zav suaŋgiap farasarav sarigi guma ma. Ndu zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndi ndɨɨi Fhe Bakɨmen Kam ma.” ");
INSERT INTO geb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ana ne nzuaim, Zisas ana ŋgarkarav, khaŋ ana nzuai, “Saimon, Zonan kam, ndu ndikndigɨri. Kha nuiana guma the mba ndɨkndɨgar ndu ndɨɨim, ndu mba kameŋ suaŋgi fhuvara. Na Ndia, ana mbu Hevenan ki, ana nduara mba kamen ndu khɨvigi. ");
INSERT INTO geb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Maaŋ muuŋgiap, gu ntige khaŋ ndu nzuai. Ndu Pita, gu ndu tɨn wo siosan muuŋgirga, za vhɨzi ŋkasŋka ana mbevarim, ana ŋgirgɨrga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gu Fhe Bakɨme wo gumgi gu mbigi garim, mbe ana piin ki ŋgu Hevenan thɨma fhɨri kii, gu ana ndun nɨɨŋgirga. Ndu kha nɨɨn kama shogip suaŋgirga kameŋ, Fhe Bakɨme vhɨra Hevenan mba kameŋ ndi tɨgɨrga. Ndu kha nuianan kama shogip tharga bigeŋ, Fhe Bakɨme vhɨra Hevenan mba kameŋ tharga.” ");
INSERT INTO geb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Zisas mba bunin wo phorga rui gumgi ga suaŋgiap, wom kama havharar mbe thɨvav khaŋ mbe nzuai, “Nde Fhe Bakɨme taagip kha nuianan ki gumgi gu mbigi ndir zav suaŋgiap na sarigi gu zɨgi ne bun harigi guma the suaŋ thari.” ");
INSERT INTO geb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mba tugivigen Zisas khaŋ wo phorga rui gumgi ga nzuai, “Gu taagip Zerusareman naaŋv, mba ŋgui gari gumgi pani, gu Fhe Bakɨme rotu gari gumgir pani, gu Zudaiŋ tɨvir vhuuiŋ kaŋgi gumgir pani, mbe zaagi vhɨrver nan nɨɨnga. Mbe na shogirim, gu rimgip, ra phuni khegene vhɨzgirim, gu taagip khavgirga.” ");
INSERT INTO geb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ana maaŋ mbe nzuaim, Pita mba kameŋ mbararagiap, ana ndigap gaar vugap, ana vhegi. Ana ana vhegap khaŋ ana nzuai, “Guman Rum, zakɨra fhuvara! Mba khesharigi tɨv ndun hɨgɨrga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pita ne nzuaim, Zisas dorgap ana garav khaŋ ana nzuai, “Satan, ndu na ndi sav na zɨn kɨrar ŋgɨri. Ndu na tuav pɨnɨ za mbui. Ndu Fhe Bakɨme ndɨkndɨga zɨn vui fhuvara. Ndu kha nuiana gumgi ndɨkndɨga zɨn vui.” ");
INSERT INTO geb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Zisas maaŋ Pita suaŋgiap, khaŋ wo phorga rui gumgi ga nzuai, “Guma the na zɨn ŋgɨr za mbui, ana za wo vuzvugi mbevav, wo rɨmɨnga khanarareŋ phufurav na zɨn zɨri. ");
INSERT INTO geb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Maaŋ muuŋgip, guma the won tumara ndɨkndɨgɨrga, ana tum za vhɨzgirga. Guma na ndɨkndɨgɨp, won tuma fekhɨngirga, mba guma, ana tum zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigirga. ");
INSERT INTO geb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Guma the za kha nuianan ki bigi ga suaŋv muuŋv za nta ndigip, ana rimgirga, mba bigi ram muuŋgi ana tuman kurarie? Guma thagɨnan won tuma vhezgirim, ana zazera mbara muuŋgia ki bɨɨŋbɨɨŋ ndigirie? ");
INSERT INTO geb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Fhe Bakɨme Guma Guar, ana zumgum won Ndiar vhava ŋaarar ŋkasŋka bakɨme phorgɨv ana enseri phorgɨp mbe zirɨrga. Ana mba tugen zirɨv, ana kha nuianan ki gumgi gu mbigi muuŋgi tɨvi ga suaŋv, vhezar mben nɨɨnga. ");
INSERT INTO geb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Gu guigira nde nzuai, ntige khar thivgi gumgi gu mbigi, mbe thari vhɨzgirga fhuvara, mbe khara muuŋgip kɨv ganɨrim, Fhe Bakɨme Guma Guar ŋgui vhɨrve gari guman pana farar muuŋgip zirgɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Zisas mba bunin mbe suaŋgiap, zumgum mporathɨgi rari vhɨzgim, ana mbaram Pita gu Zems, anan ŋguga Zon, ana mben kov, mbe vo guigira vun mbar ndagi mbɨkshɨma bakɨ mben ndagi. Ana mben kov ndav, mbe nduarira ki. ");
INSERT INTO geb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mbe kav, mbe Zisas garim, ana fhav harigi khesharav hɨgi. Mbe ana khoma garim, ana khom guigira ŋgarav, ra ndav sharigi fara muuŋgim, ana sharigi shagi, nta guigira hurgiap, ŋgara gari. ");
INSERT INTO geb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mbe ana garim, Moses gu Iraiza za zav ana han thɨgap, ana phorga nzuai. ");
INSERT INTO geb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita maaŋ muuŋgiap gangiap, mbara khaŋ Zisas ga nzuai, “Guman Rum, nza khaŋ ki ne guigira nzerigi. Ndu vuzvugirga, gu mpɨkava phuni khegenen muuŋgirga ndu suaŋv thevi, Moses ga suaŋv thevi, Iraiza ga suaŋv thevi.” ");
INSERT INTO geb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita mba bunin ana nzuavra kim, guigira ŋgarav gari buiva hura mbige zav mbe vharigim, guma mbe mba buiva hurige vhen kav khaŋ mbe nzuai, “Khe nan Kam ma, gu guigira ana vuzvugiap, anan ndikndigi. Nde ana buni mbararari!” ");
INSERT INTO geb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mba guma maaŋ nzuaim, Zisas phorga rui gumgi mba kameŋ mbararagiap, mbe guigira rivgiap, wari wo thɨvi phɨrgiap, rav fegap, wari khoo ndiv nuiana segi. ");
INSERT INTO geb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mbe maaŋ muuŋgim, Zisas thivav mbe han zav, mbe suigiap khaŋ mbe nzuai, “Nde khavik, nde rivɨ thari.” ");
INSERT INTO geb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Zisas maaŋ mbe nzuaim, mbe khavav, rav ana garav, mbe harigi gumani gangi fhu, mbe Zisasra garim, ana mbe han thɨgi. ");
INSERT INTO geb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mbe khavgiap, mba mbɨkshɨma thav wari zeri. Mbe mba mbɨkshɨman zeravra kav, Zisas kama havharar khaŋ mbe nzuai, “Nde kha gangi bigeŋ bun harigi guma the suaŋ thari. Nde nen warira khɨgɨ kɨrim, Fhe Bakɨme Guma Guar rimgip taagi khavgiri.” ");
INSERT INTO geb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Zisas ne mbe nzuaim, ana phorga rui gumgi kha nzambarar ana muuŋgi, “Mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi, mbe ram muuŋgi ne nzuav khaŋ nzuai, ‘Iraiza fharav zɨgɨrga?’ ” ");
INSERT INTO geb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Mbe ne nzuaim, ana mbe ŋgarkarav khaŋ mbe nzuai, “Ne guigira kameŋ ma, Iraiza fharav zɨv bigi ndiv thɨgar maanga. ");
INSERT INTO geb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Gu khaŋ muuŋgia tɨgap nde nzuai, Iraiza guigira zɨgi. Ana zɨgim, kha gumgi gu mbigi, mbe ana kaŋgi fhuvara. Zakɨra fhuvara! Mbe wari wo vuzvugira zɨn vov mbe mbarkɨrga tɨvir ana muuŋgi. Mbe ana muuŋgi tɨvira, mbe mba tɨvi mbatɨgira mbe Fhe Bakɨme Guma Guarar muuŋgirga.” ");
INSERT INTO geb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Zisas mba kamen mbe nzuaim, ana phorga rui gumgi khueŋ kaŋgi, ana Zon Gumgi Ruai Guma ga nzuai. ");
INSERT INTO geb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Zisas wo phorga rui guma phuni khegenen kov, mbe vera vov, gumgi gu mbigir vhɨrver hegi. Mbe mba gumgi gu mbigir hɨgim, guma mbe, ana zav Zisas nɨman wo thɨpanani phɨrgiap, ana nɨman fagi. ");
INSERT INTO geb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ana fav khaŋ Zisas ga nzuai, “Guman Rum, ndu na kaman korar muuŋri. Ana ŋanŋangiap, ana fhav mbatɨgi. Ana tugi vhɨrvera vhavi ga rav, ana vhɨra tugi vhɨrvera daav mbɨ regi. ");
INSERT INTO geb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Gu ana ndigap, ndu phorga rui gumgi han vugap, mbe nzuaim, mbe ana muungen mbovaragi.” ");
INSERT INTO geb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ana maaŋ nzuaim, Zisas ana ŋgarkarav khaŋ nzuai, “Nde bigi khothɨgi gumgi gu mbigi fhuvara. Nde ndɨkndɨgi gum nde mbui tɨvi nzerigi fhuvara. Gu rarara tugir nde phorgɨp kɨrie? Gu rarara tugir nde simtɨgi ndirie? Mba tara ndigip na han zɨ.” ");
INSERT INTO geb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Mbe mba tara ndigap Zisas han zim, Zisas mba tara ndigap Zisas mba ŋina mbatɨga vhegim, mba ŋina mbatɨk vhemkora mba tara thav kɨrar hɨgim, mba tar fhura rɨmrɨm vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Zumgum mba Zisas phorga rui gumgira, mbe nduarira ana han zav, kha nzambaren ana muuŋgi, “Ai, nza ram muuŋgiap mbu ŋina mbatɨga vharvharav ragi?” ");
INSERT INTO geb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Zisas mbara khaŋ mbe nzuai, “Nde na khothɨgi ndɨkndɨk guigira bisaŋgi. Nde maaŋ muuŋgiap tuktɨgi fhuvara. Gu guigira nde nzuai, nde maaŋ muuŋgip na khothɨgi ndɨkndɨk, ana mbe kha zɨn rɨgi mpampara vhɨgar farar muuŋgirga, mastet. Nde maaŋ muuŋgip nde khaŋ mbu mbɨkshɨma suanga, ‘Ndu khavgip, khaŋ thav mbugu ŋgɨ.’ Nde maaŋ suanga, ana ŋgɨrga. Nde vhɨra muungeŋ tuktɨgi fhuv ŋaara the ki fhu.” ");
INSERT INTO geb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Zisas mba farasegi 12 thɨgi ŋaara gumgir kov, mbe Gariri ŋgu phoga vhuiga kav, ana khaŋ mbe nzuai, “Mbe Fhe Bakɨme Guma Guara ndiv gumgi farve khɨngirga. ");
INSERT INTO geb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Mbe ana shogirim, ana rimgirga. Ana rimgirga, raa phuni vhɨzgirga khegenen ana taagi khavgirga.” Ana ne nzuaim, mba ana farasegi 12 thɨgi ŋaara gumgi, mbe ne nzuav guigira ndavi simgi. ");
INSERT INTO geb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Zisas mba kamen mbe suaŋgiap, ana zumgum wo phorga rui gumgir kov, mbe vov Kaperneam ŋgu vegi. Mbe Kaperneam ŋgun vergim, mba Fhe Bakɨme Phenan ŋkɨɨa ndia rui gumgi, mbe zav Pita han zɨgap kha nzambaren ana muuŋgi, “Nde Guman Rum ŋkɨɨa ndiv Fhe Bakɨmen Phena ndɨɨire?” ");
INSERT INTO geb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Mbe ne nzuaim, Pita khaŋ mbe nzuai, “Ahaŋ.” Mbe nen Pita suaŋgim, Pita vhen verav ntigar buna thueŋ suanga, Zisas fhumra kha nzambaren ana muuŋgi, “Saimon, ndu ram mbui ndɨkndɨga mbui? Kha nuianan ki ŋgui vhɨrve gari gumgir pani, mbe mbarkɨrga ŋkɨɨa, mbe nta ndi, mbe theiŋ han nta ndi? Mbe wo ntɨɨrira han nta ndi o, mbe harigi ntɨɨri han nta ndi?” ");
INSERT INTO geb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ana ne nzuaim, Pita khaŋ nzuai, “Mbe harigi ntɨɨri han ndi.” Zisas mbaram khaŋ ana nzuai, “Maaŋ muuŋgiap, mbe ntɨɨrira, mbe ŋkɨɨar mbe ndɨɨi fhuvara! ");
INSERT INTO geb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Maaŋ muuŋgiap, nza khein ndɨkndɨgir farfa rivgi. Ndu ŋgɨp mbarar uk su. Ndu uk suv, mba fhara zav ndu uga ndigi mbɨgam, ndu ana kamthooŋ ntarav, ana kamthooŋ vhen ganɨnga, ndu kɨma raraŋ thueŋ gangirga. Mba kɨma rareŋ ndu ne ndigi zɨv mben nɨɨŋgiri. Ndu ŋka wani khɨnan mba ŋkɨɨan mben nɨɨŋgiri.” ");
INSERT INTO geb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mba tugen Zisas phorga rui gumgi, mbe ana han zav kha nzambaren ana muuŋgi, “The Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga tugar zɨ bakɨme kɨrie?” ");
INSERT INTO geb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Mbe mba nzambaren ana muuŋgim, Zisas mbaram tara mbe nzuaim, ana ana han zim, ana ana nzuaim, ana mbe rɨgɨgera thɨgi. ");
INSERT INTO geb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Mba tar mbe rɨgɨgera thɨgim, ana khaŋ mbe nzuai, “Gu guigira nde nzuai, nde guigira wari wo ndavi domdorgip, kha tari bisarire ndɨkndɨgi ndɨkndɨgar muunga fhu, nde Fhe Bakɨme gari gumgi gu mbigi vhen ŋgirgɨrga tuktɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Guma, ana guigira wo vuzvugi, ana nta mbevar, kha tara bisaneŋ mbui tɨvar muunga, mba guma, ana Fhe Bakɨme gari gumgi gu mbigi rɨgar, zɨ bakɨ guarara kɨrga. ");
INSERT INTO geb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Guma the maaŋ muuŋgip na tɨva zɨn ŋgɨp, ana na ndɨkndɨgɨp ana khaŋ muuŋgi tara bisaŋ thanen kurarga, ana vhɨra nan kurigi.” ");
INSERT INTO geb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Zisas mba bunin mbe nzua vov wom khaŋ mbe nzuai, “Guma the maaŋ muuŋgip kha na khothɨgi tara bisaŋ thanen muuŋgirim, ana rɨgɨp tɨva mbatɨga thueŋ muuŋgirim, nde kɨma bakɨ the ndigip ana fhɨra thɨrav, ana fegɨp mbasɨga rɨgɨra khɨngiri. Nde maaŋ muuŋgi, ne nzerara. ");
INSERT INTO geb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Gu kha nuianan kav harigi gumgi ga mbuim, mbe rav tɨvi mbatɨgi ga mbui gumgi, gu guigira mbe kora muuŋgi. Ne guigira, mba tɨvi mbatɨgi hɨrga. Gu guigira mba tɨva mbui guma kora muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ndu maaŋ muuŋgip, ndun hareŋ o ndu so the ndu ŋgɨrgɨrim, ndu bigɨn mbatɨk thueŋ muuŋgip, ndu mba hareŋ gu soeŋ thugɨ fekhɨngiri. Ndu maaŋ muuŋgip, ndu hara bueŋra o so bueŋra khɨgɨ kɨrga, ndu ŋgun vhuun ŋgɨgɨp zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigirga. Ndu maaŋ muuŋgirga fhu, ndu hara phuni gu so phuni khɨgɨ kɨrga, mbe ndu fegɨp, Herar zazera mbara muuŋgiap ki vhava khɨngirga. ");
INSERT INTO geb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ndun rɨma thueŋ ndu ŋgɨrgɨrim, ndu tɨva mbatɨk thueŋ muuŋgip, ndu mba rɨmaeŋ sigɨp ne fekhɨngiri. Ndu maaŋ muuŋgip, ndu rɨma bueŋra khɨgɨp, ndu ŋgun vhuun ŋgɨgɨp, ndu zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigirga. Ndu maaŋ muuŋgirga fhu, ndu rɨmani vhɨra kɨrga mbe ndu fegɨp Herar vhava khɨngirga. ");
INSERT INTO geb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Nde tuituigira wari ganɨri. Nde khueŋ ndɨkndɨgɨ thari, nde rɨgar kha tarire, mbe fhura ki tarire ma. Fhuvara. Gu nde nzuai, Hevenan Fhe Bakɨme enseri, mbe gari enseri ki, mbe zazera mbe nzuav Hevenan na Dara nɨma thivi.” ");
INSERT INTO geb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Zisas mba bunin mbe nzua vov wom khaŋ mbe nzuai, “Nde ram mbui ndɨkndɨga mbui? Guma the maaŋ muuŋgip 100 sipsivi kɨrga, ntan rɨgar the mbar rɨgɨrga, ana mba mbar rɨgi ne suaŋv ganɨnga fhuv thi? Fhuvara. Ana mba ki 99 sipsivi, ana nta ndi mba mbɨkshɨmara tɨgɨp, ana mba mbar rɨgi ne suaŋv ganɨnga. ");
INSERT INTO geb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Gu guigira nde nzuai, ana maaŋ muuŋgip ana gangirga, ana guigira ndikndiga bakɨmen muunga. Ana mba ki 99 sipsivi, ana vhɨra ntan ndikndigi. Ana mba mbar rɨgi ne gangirga ndikndik, ana guigira mbar ŋgɨrga. ");
INSERT INTO geb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mba tɨvara nden Ndia mbu Hevenan ki, ana fhura kha tara thaneŋ ganɨrim, ana ŋgɨp mbar rɨrgeŋ vuzvugi fhu.” ");
INSERT INTO geb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Zisas mba bunin mbe nzua vov wom khaŋ mbe nzuai, “Maaŋ muuŋgi ndun fek o ŋguk, ana tɨva mbatɨga thuen ndu muuŋgirga, ndu ŋgɨp ana ganɨv, ŋko nuanira kɨv, ndu ana phorgɨv mba bigeŋ ndi thɨgɨra maan saŋv suaŋri. Ana maaŋ muuŋgip ndu nzuai kameŋ mbarararga, ndu taagia won fek o ŋguk, ndu ana ndigi. Ana wom ŋko wani tɨga ndava bavira ki. ");
INSERT INTO geb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ana maaŋ muuŋgip ndu bunai mbararagirga fhu, ndu harigi guma bavira o phuni phorgɨ ndigi ŋgɨri. Maaŋ muuŋgirga, ndu nzuai bunai havhari guma phuni o phuni khegene ki. ");
INSERT INTO geb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ana mbe nzuai buneŋ mbararagi fhu, ndu za mba guigira Zisas khothɨgi gumgi gu mbigi ga suaŋri. Ana vhɨra mbe nzuai buneŋ mbararagirga fhu, ndu kha guigira Zisas khothɨgi fhu guma gum ŋkɨɨa ndia rui guma gari ganganan anan muuŋri. ");
INSERT INTO geb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Gu guigira nde nzuai, nde kha nuianan wari tɨgap nzuav kama thueŋ ndi tɨgɨrga, Fhe Bakɨme Hevenan mba khesharigi bigira, ana Hevenan ne ndi tɨgɨrga. Nde kha nuianan thagi bigeŋ, Fhe Bakɨme vhɨra mba bigeŋ tharga. ");
INSERT INTO geb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Gu wom nde nzuai, nde guma thani, mani kha nuiana wani tɨgap ndava bavira kɨv bigɨn the ndir saŋv Fhe Bakɨme phorgɨ suanga. Na Ndia Hevenan ki, ana mba bigɨnan manin nɨɨŋgirga. ");
INSERT INTO geb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Maaŋ muuŋgip, guma phunini o phuni khegene, nde na zɨn panan wari tɨgɨp phoga vhuigi, gu vhɨra nde phorga ki.” ");
INSERT INTO geb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mba tugen, Pita zav kha nzambaren Zisas ga muuŋgi, “Guman Rum, na fega the bigɨn mbatɨga thueŋ nan muuŋgirim, gu rarara tugir ana muuŋgi bigeŋ ndɨkndɨk ŋangirie? Gu ndɨkndɨgi, harathɨgi tugir?” ");
INSERT INTO geb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ana maaŋ nzuaim, Zisas khaŋ ana nzuai, “Gu harathɨgi tugira ana ndu muuŋgi tɨva mbatɨgeŋ ndɨkndɨk ŋanɨ zav ndu nzuai fhuvara. Gu khaŋ ndu nzuai, ana zazera tɨvi mbatɨgir ndun muuŋrim, ndu nta ruemɨ thari. Ndu zazera ana ndu mbui tɨvi mbatɨgi ndɨkndɨk ŋanɨri. ");
INSERT INTO geb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ndu mbarara! Fhe Bakɨme wo gumgi gu mbigi garim, mbe ana piin ki tɨv, ana khaŋ muuŋgi. Ana ŋgui vhɨrve gari guman pana mbe, ana won ŋaara gumgi bakɨvir kamgim, mbe ana han ŋgarɨga muuŋgi bigi, mbe zav nta ŋgarkai fara muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ana mben kamgim, mbe zav wari wo ŋgarɨga muuŋgi bigi, mbe nta ŋgarkaim, mbe guma mbe kov ana han zi. Mba guma, ana 250 mirion kina ŋgarɨga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ana mba ŋkɨɨa ŋgarɨgar muunga ŋkɨɨa tuktɨgi fhu. Mba ŋgui vhɨrve gari guman pan khaŋ mbe nzuai, ‘Nde mba guma, ana mbik, gu tari, nde mbe ndi maaŋrim, harigi ntɨɨri mbe vhezgirim, mbe fhura mba guman ŋaara gumgi kɨri. Nde ana bigi, nde za nta ndiv maaŋrim, mbe nta vhezgiri. Nde mba tuavar, nde ŋkɨɨa ndigip, ana mba ŋgarɨga muuŋgi ŋgarɨga ŋgarkararga.’ ");
INSERT INTO geb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Mba ŋaara guma ne mbararagiap, ana mbara wo thɨpanani phɨrgiap, mba ŋgui vhɨrve gari guman pana ŋkarve nɨmara fav, khaŋ nzuai, ‘Ndu nan korar muuŋgip, tugar nan nɨɨŋgirim, gu ndu han ŋgarɨga muuŋgi bigi, gu za nta ŋgarkararga.’ ");
INSERT INTO geb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ana maaŋ nzuaim, ŋgui vhɨrve gari guma pan ana kora muuŋgiap, fhura ana thav, vhɨra ana mba ŋgarɨga muuŋgi ŋkɨɨa, ana vhɨra nta ndɨkndɨk ŋangi. ");
INSERT INTO geb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ana maaŋ mba ŋaara guma ga muuŋgim, mba ŋana guma kɨrar hav, za wo phorga ŋgarigi ŋaara guma bakɨme gari. Ana phorga ŋgarigi ŋaara guma bakɨme, ana han 500 kina ŋgarɨga muuŋgi. Ana ana garav, za ana fhɨrar suirav, khaŋ ana nzuai, ‘Ndu na han ŋgarɨga muuŋgi bigi, ndu za nta ŋgarkarari.’ ");
INSERT INTO geb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ana phorga ŋgarigi guma bakɨme ne mbararagiap wo thɨpanani phɨrgiap, ana nɨman fav, khaŋ tɨgɨp ana nzuai, ‘Ndu nan korar muuŋgip, tugar nan nɨɨŋgirim, gu ndu han ŋgarɨga muuŋgi bigi, gu nta ŋgarkarga.’ ");
INSERT INTO geb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ana ne nzuaim, mba guma ne vuzvugi fhu. Ana thav, ana ndiga vov bɨna khɨngi. Ana bɨnan kɨv mba ŋgarɨga muuŋgi bigi ŋgarkararga. ");
INSERT INTO geb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Mba guma phorga ŋgarigi gumgi baikɨvi mbari mbe ana garim, ana maaŋ ana muuŋgim, mbe guigi guarara ana nzuav ndavi mbatɨgi. Mbe thav vov, mba ŋaara guma bakɨme muuŋgi bigi, mbe za nta bun, mbe wo ŋgui vhɨrve gari guman pana suaŋgi. ");
INSERT INTO geb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mba ŋgui vhɨrve gari guman pan mbara mba ŋaara guma bakɨmen kamgiap, khaŋ ana nzuai, ‘Ndu ŋaara guma mbatɨga guar ma. Ndu fharav khaŋ tɨgap, nan nzim, gu ndu ŋgarɨga muuŋgi bigi, gu fhura nta thav, nta ndɨkndɨk ŋangi. ");
INSERT INTO geb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Gu fhura ndu kora muuŋgi. Ndu ram muuŋgip ndu vhɨra wo phorga ŋgarigi guma bakɨme korar muuŋ thagi?’ ");
INSERT INTO geb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mba ŋgui vhɨrve gari guman pan ne nzuav, guigira ana ndav shigap, ana ndiv, zaa ana nɨɨnga gumgir farve khɨngi. Ana mben han kɨv za mba ŋgarɨga muuŋgi bigi ŋgarkararga. ");
INSERT INTO geb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Mba tɨvara, nde harigi gumgi nde mbui tɨvi mbatɨgi, nde guigira nta ndɨkndɨk ŋanɨ tharga, nan Ndia Hevenan ki, ana mba khesharigi tɨvara nden muunga.” ");
INSERT INTO geb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Zisas mba buni mbe suaŋgia thugap, ana Gariri ŋgu fhaiŋ thav kema ndigap, Zordan mbɨ gaar muen Zudia ŋgu fhain vui. ");
INSERT INTO geb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ana vuim, gumgi gu mbigi vhɨrve ana zɨn vui. Mbe ana zɨn vuim, ana maam mben rɨmrɨɨ ga mbuim, nta vhɨzi. ");
INSERT INTO geb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Zisas maaŋ kim, Fherasiŋ ana han zav, ana mpari. Mbe maaŋ muuŋgiap kha nzambareŋ ana muuŋgi, “Ee, nzan tɨv, guma won muuŋ thamthar saŋv ana vuzvuk ma, ne nzerara thi?” ");
INSERT INTO geb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Mbe ne nzuaim, Zisas mbe ŋgarkarav khaŋ nzuai, “Ee, nde Fhe Bakɨmen buni vhuuiŋ ki gap, nde ana gangi fhuv thi? Mba buneŋ khaŋ nzuai, ‘Fhum guarara Fhe Bakɨme za kha bigi ga muuŋgiap, ana gumgi gu mbigi ga muuŋgi. Ana guma ga muuŋgim, ana guma ma. Ana mbiga muuŋgim, ana mbik ma. ");
INSERT INTO geb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Fhe Bakɨme mani ga muuŋgiap, ana khaŋ nzuai, “Maaŋ muuŋgip, guma ana muuaŋ tɨgap, ana won niamuuŋ gu ndia thav, ana won muuŋ phorga kav, mani wani phorgap, mani guma bavira ki. Mani wani hiav ki fhu.” ’ ");
INSERT INTO geb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Fhe Bakɨme maaŋ suaŋgim, mani wani shɨrav wani hiav guma phunini ki fhu. Fhuvara. Mani wani tɨgap guma bavira ki. Maaŋ muuŋgiap, Fhe Bakɨme phorgi bigɨn, guma ana shɨgɨ thari.” ");
INSERT INTO geb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ana ne suaŋgim, mba Fherasiŋ khaŋ ana nzuai, “Ne nzerara, maaŋgiap Moses thaŋ nzuav kha tɨvar nza nɨɨŋgia khaŋ nzuai, ‘Guma won muuŋ thamthar saŋv, ana ana thamthagi kamen gava thueŋ khergip, ana nɨɨŋgip, ana sararim, ana ŋgɨrga?’ ” ");
INSERT INTO geb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Mbe maaŋ nzuaim, Zisas khaŋ mbe nzuai, “Nde rɨɨŋrɨɨŋ kɨvgi ntɨɨri ma. Maaŋ muuŋgiap, Moses fhura nde garim, nde won muuiŋ thamthagi. Fhum guarara mba khesharigi tɨv ki fhu. ");
INSERT INTO geb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","“Gu khaŋ nde nzuai, Maaŋ muuŋgip, guma then muuŋ, ana ruan harigi guma the ndiga kegi fhu. Ana man fhura ana thav ana vharigi, ana vuim, ana harigi mbiga tɨgi, mba guma, ana nduara ruan harigi mbiga ndigi tɨva muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Zisas ne nzuaim, ana farasegi 12 thɨgi ŋaara gumgi khaŋ ana nzuai, “Maaŋ muuŋgiap, gumgi mba tɨvar muuŋv wari won muuiŋ phorgɨ kɨrga. Mbe thaaŋ nzuav muuiaŋ rɨgi, mbe fhura mbar kɨ.” ");
INSERT INTO geb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Mbe ne nzuaim, Zisas khaŋ mbe nzuai, “Kha gumgi, mbe za kha buneŋ zɨn ŋgɨgɨrga tuktɨgi fhuvara. “Fhe Bakɨme mba ndɨkndɨgar nɨɨŋgi gumgi, mbe nduarira kha buneŋ zɨn ŋgɨrga. ");
INSERT INTO geb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nde mbarara! Mbarkɨrga gumgi vhɨrve ki, mbe mbari, mbe muuiaŋ rɨgi fhu. Mbe mbari, mbe ndegmbori ndavi vherira, mbe fhavi mbatɨgi. Mbe mbari, mbe ŋgui vhɨrve gari gumgi panin phenan ŋgarɨr zav, mbe mbe thuuri ndigim, mbe muuin rɨgɨrga vuzvuk ki fhu. Mbe mbari, mbe Fhe Bakɨme wo gumgi gu mbigi garim, mbe ana piin ki ŋgu ndɨkndɨga ŋgarav, mbe muuiaŋ rɨgɨ thagi. Guma, ana kha buni mbararav, ana nta zɨn ŋgɨr saŋv, ana kha buni ndiri.” ");
INSERT INTO geb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mbe mba tugar, mba gumgi gu mbigi, mbe tari bisarire ndiav Zisas han zi. Mbe khueŋ vuzvugiap, Zisas won farver mbe suv, mbe suaŋv, Fhe Bakɨme phorgɨv suanga. Mbe mbe ndia zim, Zisas farasegi 12 thɨgi ŋaara gumgi mba gumgi gu mbigi ga vhegi. ");
INSERT INTO geb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Zisas khaŋ wo farasegi 12 thɨgi ŋaara gumgi ga nzuai, “Nde fhura mba tarire ganɨrim, mbe na han zɨri. Nde mbe thɨvɨ thari. Fhuvara. Kha tarire ndɨkndɨgi ndɨkndɨga mbui gumgi gu mbigi, Fhe Bakɨme wo gumgi gu mbigi garim, mbe ana piin ki ŋgu, ana mbe ne ma.” ");
INSERT INTO geb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ana maaŋ mbe suaŋgiap, mbara won farver mba tari ga sui. Ana farven mbe suegap, ana zumgum mba ŋaneŋ thav vui. ");
INSERT INTO geb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Guma mbe Zisas han zav khaŋ ana nzuai, “Guman Rum, gu ram muuŋgi tɨvar vhuun muuŋgip, gu zumgum zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigirie?” ");
INSERT INTO geb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Zisas mbaram khaŋ ana nzuai, “Ndu thaŋ nzuav tɨvir vhuuiaŋ nzuav nan nzai? Guma bavira, ana tɨvir vhuuiaŋ mbui guma ma. Ndu maaŋ muuŋgip, zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndir za mbui, ndu Fhe Bakɨme nzuai tɨvi zɨn ŋgɨri.” ");
INSERT INTO geb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Zisas maaŋ ana nzuaim, mba guma kha nzambaran Zisas ga muuŋgi, “Ndu ram mbui khesharigi tɨvi, ndu nta nzuai?” Zisas mbara khaŋ ana nzuai, “Mba Fhe Bakɨme nzuai tɨvi, nta khaŋ nzuai, ‘Nde harigi gumgi gu mbigi shogɨrim, mbe vhɨzɨ thari. Nde mani gu mburi ga rɨgi gumgi gu mbigi, nde ruarin harigi gumgi gu mbigi ndi thari. Ne kɨmɨ thari. Nde fhura guiguigip harigi gumgi gu mbigi ga suaŋv suaŋ thari. ");
INSERT INTO geb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nde wari won ndegi gu ndegmbori piin kɨv, mbe nzuai buni mbararari. Nde vhɨra wari vuzvugi tɨvara, nde guigira harigi gumgi vuzvugiri.’ ” ");
INSERT INTO geb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Zisas maaŋ nzuaim, mba guman kam khaŋ ana nzuai, “Gu za mba tɨvi zɨn vui. Gu ram muuŋgi tɨveŋ, gu ne zɨn vui fhu?” ");
INSERT INTO geb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Zisas mbara khaŋ ana nzuai, “Ndu maaŋ muuŋgip tɨvir vhuuiaŋ mbui guma guarara kɨr za mbui, ndu ŋgɨp za wo bigi ndi maaŋrim, mbe nta vhezgirim, ndu mba ŋkɨɨar, bigi sosuagi gumgir nɨɨŋgiri. Ndu maaŋ muuŋgirga, ndu Hevenan bigi vhuuiŋ guarira ndirga. Ndu mba tɨvar muuŋgip, ndu na phorgɨ ru.” ");
INSERT INTO geb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mba guman kam ne mbararagiap, ana ndav ana simgim, ana vugi. Ana khaŋ muuŋgiap, ana guigira bigi vhɨrkɨvgi guma ma. ");
INSERT INTO geb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Zisas mba bunin ana nzua vo khaŋ wo farasegi 12 thɨgi ŋaara gumgi ga nzuai, “Gu guigira nde nzuai, shɨk kav ŋkɨɨa vhɨrve ki gumgi, mbe guigira Fhe Bakɨme wo gumgi gu mbigi garim, mbe ana piin ki ŋgu Hevenan ŋgirɨr saŋv, guigira ŋaara mbatɨgar muuŋgirga. ");
INSERT INTO geb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Gu taagia nde nzuai, kemor, ana shagi sai suuŋ thoon ŋgirɨ saŋv, ana mba shɨk kav ŋkɨɨa vhɨrve ki guma, ana Fhe Bakɨme wo gumgi gu mbigi garim mbe ana piin ki ŋgun ŋgirɨ zav ŋaara mbatɨga mbui, ana mba khesharigi ŋaara mbatɨgar muuŋgirga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Zisas ne suaŋgim, mba ana farasegi 12 thɨgi ŋaara gumgi ne mbararagiap, mbe guigira ŋgava mbatɨga muuŋgi. Mbe ŋgava mbatɨga muuŋgiap khaŋ nzuai, “Maaŋ muuŋgirga, the zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigirie?” ");
INSERT INTO geb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Mbe ne nzuaim, Zisas purara mbe garav khaŋ nzuai, “Guma the ne muuŋgirga tuktɨgi fhuvara. Fhe Bakɨme, ana nduara za mba bigi ga mbui.” ");
INSERT INTO geb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Zisas maaŋ nzuaim, Pita ana kama ŋgarkarav khaŋ nzuai, “Ndu ganɨ. Nza za wari wo bigi thav ndu phorga rui. Nza ne suaŋv, thagɨna ndirie?” ");
INSERT INTO geb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Zisas Pita ŋgarkarav khaŋ mbe nzuai, “Gu guigira nde nzuai, Fhe Bakɨme zumgum muuŋgirga ŋgun kaman, Fhe Bakɨmen Guma Guar, ana zɨ bakɨme ndigɨp, ana ŋgui vhɨrve gari guman pan pigi mpirmpirɨga perarga, mba tugar, nde gu farasarigi 12 thɨgi ŋaara gumgi, nde vhɨra, nde 12 thɨgi mpirmpirɨgi vhuuin pigirga. Nde ntan piigip, nde mba 12 thɨgi Isrerin nzɨgi nde mbe ganɨnga. ");
INSERT INTO geb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mba na zɨ ndɨkndɨgap wari wo pheni, gu won fegi gu ŋgugi, meeiŋ gu bivi, ndegi gu ndegmbori, won tari, won mɨni, mba bigi thagi gumgi gu mbigi, mbe guigira bigi vhuuiŋ vhɨrvera ndiv, mbe vhɨra zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigirga. ");
INSERT INTO geb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Maaŋ muuŋgiap, ntigem zɨ bakɨme ndi ntɨɨri, mbe zumgum zɨ bisaneŋ ndirga.” ");
INSERT INTO geb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Guma Hevenan Fhe Bakɨme piin kɨr za mbui tɨv khaŋ muuŋgi. Guma mbe wain mɨna bakɨme ki. Ana tuga mben manera ra ndav shɨgɨra thagim, ana khavgiap, vov won wain mɨnan ŋgarɨrga gumgi ndiv garav, mbe ndi. ");
INSERT INTO geb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ana mbe ndiga zim, mba ŋaara gumgi, mbe mba raar ŋgargip, mba raa khɨnan vheza ndirga ne vuzvugim, mba mɨna namkam mbara mbe sarigim, mbe ana wain mɨnan ŋgarɨ zav vui. ");
INSERT INTO geb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ana mbe sarigi, mbe vergim, mba mɨna namkam kav kim, ra nda vov saaŋgiap 9 kirok ndigim, mba mɨna namkam vov garim, gumgi mbari mbe fhura mbe phogi ga vhui ŋanan thivgiap ki. ");
INSERT INTO geb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ana mbaram khaŋ mbe nzuai, ‘Nde vhɨra ŋgɨp, na wain mɨnan ŋgarɨrim, gu nde ŋgari ŋaara tugɨra tɨgɨp nde vhezɨrga.’ ");
INSERT INTO geb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ana maaŋ mbe suaŋgim, mbe vhɨra vui. Mbe vegim, ra ndav phɨɨŋ ndigap, vera vov phuni khegene ndim, mba mɨna namkam mba tɨvara mbe muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Mba mɨna namkam kav kim, ra vera vov meeŋ ndim, ana ŋkotuguraagen, ana vov gumgi mbari gari, mbe fhura thivgia ki. Ana mbara mben nzarigi, ‘Nde ram muuŋgiap kha raar fhura thivgiap kim, kha ra vera vov vhɨzgi?’ ");
INSERT INTO geb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Mbe ana ŋgarkarav khaŋ nzuai, ‘Nza guma the ŋaarar nza nɨɨŋgi fhuvara.’ Mba mɨna namkam khaŋ mbe nzuai, ‘Nde vhɨra ŋgɨp na wain mɨnan ŋgarɨri.’ ");
INSERT INTO geb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Mba raan ra verav vhɨzgim, mba mɨna namkam mbara wo ŋaara gari mpiiŋsɨga kamgiap khaŋ ana nzuai, ‘Ndu mba ŋaara gumgir kamgirim, mbe zɨrim, nde vhezar mben nɨɨŋ. Ndu fharav mba zɨn zegi ŋaara gumgir vhezar mben nɨɨŋv ŋgɨv, mba fharav zegi ŋaara gumgir nɨɨŋri.’ ");
INSERT INTO geb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mba zumgum ra vera vov mpora ndim, zav ŋaara ndiga ŋgari ŋaara gumgi, mbe zav mba raar ŋgarigi vhez ndi. ");
INSERT INTO geb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mbe won vheza ndim, mba fhara manera ŋaara ndigi ŋaara gumgi, mbe khueŋ ndɨkndɨgi, mbe zɨv mba ŋkotuguraagen ŋaara ndigi gumgi kambara vhez ndigirga. Mbe mba ndɨkndɨga mbui, ne fhuvara. Mbe zav, mbe vhɨra mba raar ŋgarigi ŋaara tugara tɨgav vheza ndigi. ");
INSERT INTO geb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mbe maaŋ muuŋgiap, ndigap, mbe ne nzuav mba mɨna namkama vhegi. ");
INSERT INTO geb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Mbe ana vhegap khaŋ ana nzuai, ‘Kha gumgi, mbe nza zɨn zegap ŋgargi. Mbe aua bavira ŋgargi, ndu nza vhezi vhezara mbe nɨɨŋgi. Nza guigira ŋaara bakɨme muuŋgi, nza manera khavgia zav ŋgarav kim, ra guigira nza tuegi.’ ");
INSERT INTO geb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Mba mɨna namkam mbe nzuai kameŋ mbararagiap, ne ŋgarkarav khaŋ mba ŋgarigi ŋaara guma mbe nzuai, ‘Nan kɨvntok, gu tɨva mbatɨga muuŋgi fhuvara. Ndu mbarara! Ŋka fharav wani tɨgap mba vheza tha ndi tɨgap, khaŋ wani ga suaŋgi, Raa bavira vhezra! Ŋka wani ga suaŋgiap wani ŋgari. Ee, fhuve? ");
INSERT INTO geb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ndu won vheza ndigip ŋgɨri! Gu wo vuzvugara, gu ndu ndɨɨ vhezra, gu mba zɨn zegap ŋgarigi gumgi gu mba vhezar mbe nɨɨŋgi. ");
INSERT INTO geb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ana na bigɨn ma. Ee, gu wo vuzvuga zɨn ŋgɨp won ŋkɨɨa shɨgɨp nden nɨɨnga fhuve? Ee, gu maaŋ muuŋgip tɨvar vhuun mba gumgir muunga, ndu thaaŋ nzuav, ndav shigi?’ ” ");
INSERT INTO geb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Zisas ne nzuav khaŋ nzuai, “Mba tɨvara, ntige zɨ bisaneŋ ki gumgi, mbe zɨ bakɨme kɨrga. Mba ntigem zɨn ki gumgi, mbe zumgum fhararga, mba fharigi gumgi, mbe zɨn kɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Zisas mba bunin mbe suaŋgiap, khavgiap Zerusareman ndai. Mbe ndav ana wo phorga rui 12 thɨgi gumgira kov mbe phogia ŋana muen vov, Zisas khaŋ mbe nzuai, ");
INSERT INTO geb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nde mbarara! Nza ntigem, Zerusareman ndai. Nza naanga, mbe Fhe Bakɨmen Guma Guara ndiv, Fhe Bakɨme rotu gari gumgir pani gum Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi farve khɨngirga. Mbe ana ndiv mbe farve khɨngirim, mbe ana suaŋv kama shogip, ana shogirim, ana rimgirga. ");
INSERT INTO geb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Mbe ana ndi harigi fhaiŋ gumgir farve khɨngirim, mbe ana sɨɨŋv, phivɨgar ana kharɨv, ana ndiv khanarareŋ ga tɨgɨp fugɨrga. Ana rimgip ra phuni vhɨzgirga, ana khegenen taagip khavgirga.” ");
INSERT INTO geb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zumgum, Sebedin muuŋ won kamanin kov Zisas han zi. Mbe zav thɨpanani phɨrgiap bigɨn mueŋ nzuav Zisasan nzan zav mbui. ");
INSERT INTO geb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Zisas mbaram kha nzambarar ana muuŋgi, “Ndu thagɨna vuzvugi?” Mba mbik mbara khaŋ Zisas ga nzuai, “Gu khueŋ vuzvugi, ndu khaŋ nan kamani ga suanga, mani ndu ŋgui vhɨrve gari guman pan kɨrim, mani the ndun guva haren perarga, the ndu ŋkɨn haren perarga.” ");
INSERT INTO geb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ana ne nzuaim, Zisas ana mbararagiap ana ŋgarkarav khaŋ nzuai, “Nde mba bigeŋ nde tuituigiap ne kaŋgiap ne ga nzuav nan nzai fhuvara. Ee, ŋko gu mbɨrga mbɨ khɨnigeŋ ŋko niŋgen mbegɨrie?” Ana ne nzuaim, mani ana ŋgarkarav khaŋ nzuai, “Ŋka tuktɨgi.” ");
INSERT INTO geb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mani ne nzuaim, Zisas ne mbararagiap, khaŋ mani ga nzuai, “Ŋko guigira gu mbɨrga mbɨ khɨnigen mbɨrga. Ŋko mba the nan guva haren pigɨrga, the nan ŋkɨn haren pigɨrga ne, ne na bigeŋ fhuvara. Gu mba ŋanenin pigɨrga gumgi ndi fɨrga tuktɨgi fhuvara. Mba mpirmpirɨganin pigɨrga gumgi, nan Ndia mba gumgi kaŋgiap, ana mbe ndi fegi mpirmpirɨgani ma.” ");
INSERT INTO geb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Zisas maaŋ mani ga nzuaim, mba Zisas phorga rui phɨk thɨgi gumgi ne mbararagiap, mbe mba bigeŋ ga nzuav mba fek gu ŋguga vhegi. ");
INSERT INTO geb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Zisas mbe hiav mben kamgim, mbe zim, ana khaŋ nzuai, “Nde kaŋgi, harigi ŋgui vhɨrve gari gumgir pani, mbe guigira wo ntɨɨri gari. Mben gumgir pani khaŋ tɨgap wari wo piin kɨv wo buni zɨn ŋgɨr zav wari won gumgi gu mbigi ga nzuai. ");
INSERT INTO geb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nde mba tɨv, nden ki thari. Nde rɨgar, nde the zɨ bakɨme kɨr saŋv, ana za nden ŋaara guma kɨri. ");
INSERT INTO geb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Gu nde rɨgar zɨ kɨr saŋv ana fhura nden ŋaara guma kɨri. ");
INSERT INTO geb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mba tɨvara Fhe Bakɨme Guma Guar, ana gumgi ana kurkura zav ana zɨgi fhuvara. Ana mben kurkurav zav zɨgi. Ana mben kurkura, mbe suaŋv won tuma fekhɨngip, rimgip, taagip gumgi gu mbigi vhɨrve ndir zav zergi.” ");
INSERT INTO geb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Zisas maaŋ kegap wo phorga rui gumgir kov, mbe Zeriko ŋgu bakɨme thav wari vui. Mbe vuim, gumgi gu mbigi vhɨrvera Zisas zɨn vui. ");
INSERT INTO geb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mbe vuim, guma phunini, mani tuav gaa ga perav ki. Mani vhɨra rɨmani mbatɨgi. Mani perav kav Zisas mbararagim, ana zim, mani khɨrɨp kaav khaŋ nzuai, “Guma Bakɨme, Devitan Kam, ndu ŋkan korar muuŋ.” ");
INSERT INTO geb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mani kaav nzuaim, mba gumgi gu mbigi mani mbararagiap, khaŋ tɨgap thɨni pɨnɨn zav mani ga nzuai. Mbe mani ga nzuaim, mani khaŋ tɨgap khɨrɨv kaav khaŋ nzuai, “Guma Bakɨme, Devitan Kam, ndu ŋkan korar muuŋ.” ");
INSERT INTO geb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Mani maaŋ nzuaim, Zisas mbara thɨgap, manin kaav, khaŋ mani ga nzuai, “Ŋko vuzvugi, gu ram ŋkon muuŋrie?” ");
INSERT INTO geb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Mani ana ŋgarkarav khaŋ ana nzuai, “Guma Bakɨme, ŋka vuzvugi, ndu ŋkan rɨmanin muuŋgirim, ŋka ganɨnga.” ");
INSERT INTO geb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Mani maaŋ nzuaim, Zisas manin kora muuŋgi. Ana manin kora muuŋgiap, mbara won farven manin rɨmani khɨngim, manin rɨmani vhemkora nzerigim, mani bigi gari. Manin rɨmani nzerigim, mani mbara Zisas phorga vui. ");
INSERT INTO geb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Zisas wo phorga rui gumgir kov, mbe nda vov Zerusareman han mbai. Mbe nda vov Zerusareman han Oriv mbɨkshɨman Betfage ŋgugen hegi. Mbe maaŋ hegap, Zisas wo phorga rui guma phuni ga sarav khaŋ mani ga nzuai, ");
INSERT INTO geb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Ŋko ŋgɨp, nza ntige mba gari ŋgugen ŋgɨri. Ŋko ŋgɨp, ŋko vhemkora doŋki the ganɨnga, mbe ana ndi thɨrigim, ana ki. Ana ŋguk vhɨra, ana phorga ki. Ŋko ana mpiiŋ fhɨrgip, mani ndigip, na han zɨri. ");
INSERT INTO geb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ŋko ni ndirim, guma the buna thuen ŋko suaŋrim, ŋko khaŋ mba guma ga suaŋri. ‘Guma Bakɨme ŋaar manin ki.’ Ana vhemkora mani ga sararim, mani taagi zɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kha bigeŋ fhum Fhe Bakɨme kamthooŋ guma suaŋgi kameŋra zɨn vugi. ");
INSERT INTO geb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kha kamen Saionan ki ntɨɨri ga suaŋri. ‘Nde ganɨ! Nden ŋgui vhɨrve gari guman pan ntige zi. Ana zɨ ki fhuv guma fara muuŋgiap zi. Ana doŋki mbe tɨ perav zi. Ana doŋki ŋguga mbe tɨ perav zi.’ ” ");
INSERT INTO geb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Zisas maaŋ wo phorga rui gumani ga suaŋgim, mani vov, ana mba suaŋgi buneŋra zɨn vugi. ");
INSERT INTO geb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mani vov, mba doŋki niamuuŋ gu ŋguga ndiga zav, mani won shaa mpeeni zorgia mani kɨrani khɨngim, Zisas nda vov mbe perigi. ");
INSERT INTO geb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Zisas ana perigim, gumgi vhɨrve wari wo shagi mpeeiŋ zorav, tuav ga sɨgim, Zisas nta tɨn ndai. Gumgi mbari, mbe khira ŋgagi phɨrav, tuav ga suim, ana nta tɨn ndai. ");
INSERT INTO geb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ana ndaim, gumgi gu mbigi mbari, mbe ana nɨman fharav ndaim, mbe mbari ana zɨn ndai. Mbe ndav kaav khaŋ nzuai, “Nde Devitan Kama zɨ ndi vun kuamkuari. Fhe Bakɨme tɨvar vhuun kha guman muuŋri, ana Guma Bakɨme zɨn panan zi. Nde vu guarara ki Fhe Bakɨme zɨ ndi vun kuamkuari.” ");
INSERT INTO geb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Zisas ndav vov, Zerusareman vhen verim, mba gumgi gu mbigi mba ŋgu bakɨmen kegap ŋgava mbatɨga mbuav tamtam nzav khaŋ nzuai, “Kha guma, ana the ma?” ");
INSERT INTO geb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mba ndai gumgi gu mbigi, mbe khaŋ nzuai, “Ana Zisas ma! Ana Fhe Bakɨmen kamthooŋ guma ma. Ana Garirin ŋgu bisaneŋ Nasaretan kegap ndai.” ");
INSERT INTO geb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Zisas vov Fhe Bakɨme phena bɨna vhen verav, ana bɨna vhen kav bigi ndi mbav sɨga mbui gumgi zɨtɨgap, mbe ndi kɨrar mbai. Ana mbe ndiv kɨrar mbav, mba ŋkɨɨar kurkurigi gumgi, ana mbe kaagi suigap, nta daasuav, mba korgi ndi mbai gumgi, ana vhɨra mbe piigi mpirmpirɨgi, ana nta suigap, nta daasui. ");
INSERT INTO geb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ana maaŋ mbe mbuav khaŋ mbe nzuai, “Fhe Bakɨme buni vhuuiŋ ki gavar ki buni khaŋ nzuai, ‘Na phen, ana na phorga nzuai phen ma.’ Nde ana mbuim, ana kɨɨi gumgi zomzori ŋaneŋ fara muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Zisas maaŋ mbe muuŋgiap, mba Fhe Bakɨme phena bɨna vhera kim, rɨmgi mbatɨgi gumgi gum suira mbatɨgi gumgi, mbe ana han zim, ana mben kurkurav mbe mbuim, mbe taagia nzezerigi. ");
INSERT INTO geb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Zisas maaŋ mbuim, mba Fhe Bakɨmen rotu gari gumgir pani gum Zudaiŋ tɨvir vhuuiŋ kaŋgi gumgi, mbe ana mbui mirikori garav, tari bisarire mbararagim, mbe Fhe Bakɨme phena bɨna vhen kav kaav khaŋ nzuai, “Nde Devit Kaman ndikndigɨri.” Mbe maaŋ nzuaim, mbe ne nzuav ndavi mbe mbatɨgi. ");
INSERT INTO geb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mbe ne nzuav ndavi mbatɨgiap, mbe Zisasan nzav khaŋ ana nzuai, “Ndu kheiŋ nzuai buni mbararagire?” Mbe maaŋ nzuaim, Zisas mbe ŋgarkarav khaŋ nzuai, “Ahaŋ, gu mbe mbararagi. Ee, nde mba Fhe Bakɨme buni vhuuiŋ ki gavar kha kameŋ gangi fhuve? Mba kameŋ khaŋ nzuai, ‘Ndu tari bisarire gum mba tira pavra ki tari ga muuŋgim, mbe vhɨra ndu zɨ ndi vun kuamkuagi.’ ” ");
INSERT INTO geb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Zisas maaŋ mbe suaŋgiap, mbe thav, mba ŋgu bakɨme thav kɨrar hɨgap, vov Betanin vugi. Ana mba maan Betani ga kuigi. ");
INSERT INTO geb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Zisas Betani ga kuigap, mba mɨtimanera ana taagia ŋgu bakɨmen ndai. Ana ndav thɨ anan hegi. ");
INSERT INTO geb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ana ndav garim, fik kha mbige tuav gaa thɨgap ki. Ana vov niŋge han vugap, niŋge garim, niŋge vhɨgi mbarigi fhuvara, fari khɨnira. Ana thav khaŋ mba fik khage nzuai, “Ndu wom vhɨgi mbararga tuktɨgi fhuvara. Zakɨra fhuvara!” Ana ne nzuavra thagim, mba fik khage za shɨɨŋgi. ");
INSERT INTO geb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mba khage shɨɨŋgim, ana phorga rui gumgi niŋge gangiap, ŋgava mbatɨga muuŋgi. Mbe ŋgava mbatɨga muuŋgiap khaŋ nzuai, “Kha fik khage ram muuŋgiap vhemkora shɨɨŋgi?” ");
INSERT INTO geb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mbe maaŋ nzuaim, Zisas mbe ŋgarkarav khaŋ nzuai, “Gu guigira nde nzuai, nde guigira na khothɨgɨv nde ndɨkndɨga phunin muuŋ tharga, nde vhɨra gu kha fik khage muuŋgi tɨvar muuŋgirga. Nde vhɨra mba tɨvara muuŋgirga tuktɨgi fhuvara. Nde vhɨra khaŋ kha mbɨkshɨma suanga, ‘Ndu khaŋ thav wo sigɨp, wo fegɨp, mbasɨk khɨnik.’ Nde maaŋ suanga, nde mba nzuai kameŋ hɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nde guigira na khothɨgɨp, nde bigɨn the suaŋv Fhe Bakɨme phorgɨ suanga, nde mba nzuai bigɨna ndirga.” ");
INSERT INTO geb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Zisas vov Fhe Bakɨme phena bɨna vhen vergap, Fhe Bakɨmen buni vhuuin gumgi gu mbigi khɨvav mbe nzuai. Ana mbe nzuaim, mba Fhe Bakɨmen rotu gari gumgir pani gum Zudaiŋ gumgir pani ana han zav kha nzambara ana muuŋgi. Mbe khaŋ ana nzuai, “Ndu maaŋ mba zɨ bakɨme gu ŋkasŋka ndigap kha bigi ga mbui? The mba zɨ bakɨmen ndu nɨɨŋgiap, mba ŋaarar muun za ndu suaŋgim, ndu mba ŋaara mbui?” ");
INSERT INTO geb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Mbe maaŋ nzuaim, Zisas mbe ŋgarkarav khaŋ mbe nzuai, “Gu vhɨra bigɨn mueŋ nzuav nden nzai. Nde gu nzai bigeŋ ŋgarkararga, gu mba zɨ bakɨmen na nɨɨŋgim, gu kha ŋaara mbui guma bun nde suanga. ");
INSERT INTO geb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Na nzambareŋ khare, Zon Gumgi Ruai Guma, ana mba gumgi gu mbigi ruai, ana maaŋ mba zɨ bakɨme ndigap mba tɨva mbui? Ana Hevenan kega zergi tɨv o, ana guma nduara mbui tɨv?” Ana maaŋ mbe nzuaim, mbe nduarira khaŋ wari ga nzuai, “Nza khaŋ suanga, ‘Ana Hevenan kega zergi bigeŋ mbui.’ Nza maaŋ suanga, ana khaŋ nza suanga, ‘Maaŋ muuŋgiap, nde ram muuŋgiap ana khothɨgi fhu?’ ");
INSERT INTO geb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nza vhɨra khaŋ suanga, ‘Ana guma wo ndɨkndɨgar mbui,’ nza maaŋ suanga, nza kha gumgi gu mbigir rivgi. Ne khaŋ muuŋgi, mbe za khueŋ ndɨkndɨgi, Zon Gumgi Ruai Guma, ana Fhe Bakɨmen kamthooŋ guma ma.” ");
INSERT INTO geb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mbe maaŋ muuŋgiap Zisas ŋgarkarav khaŋ nzuai, “Nza kaŋgi fhu.” Mbe maaŋ nzuaim, Zisas khaŋ mbe nzuai, “Gu vhɨra, gu kha zɨ bakɨmen na nɨɨŋgim, gu kha ŋaara mbui guma bun nde suaŋgirga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Zisas wom khaŋ mba Fhe Bakɨmen rotu gari gumgir pani gu Zudain gumgi pani ga nzuai, “Nde ram mbui ndɨkndɨga mbui? Guma mbe, ana kama phunini ki. Ana vov won kama bara han vugap khaŋ ana nzuai, ‘Ndu ntigem ŋgɨp wain mɨnan ŋgarɨri.’ ");
INSERT INTO geb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ana maaŋ nzuaim, ana kam khaŋ ana nzuai, ‘Gu thagi.’ Ana maaŋ ana suaŋgiap, ana zumgum thav won ndɨkndɨgar kurav vov mɨnan vugi. ");
INSERT INTO geb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ana ana suaŋgiap, ana mbara vov won kama ntoga han vugap, ana mba kameŋra ana nzuai. Ana vov ana nzuaim, ana khaŋ ana nzuai, ‘Ahaŋ, Dara, gu ŋgɨrga.’ Ana maaŋ ana suaŋgiap, ana vugi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nde ana kamani ganɨ. Maaŋgi ne won ndia suaŋgi kameŋ zɨn vugi?” Mbe ana ŋgarkarav khaŋ nzuai, “Ana kama bar.” Mbe maaŋ nzuaim, Zisas khaŋ mbe nzuai, “Gu guigira nde nzuai, ŋkɨɨa ndia rui gumgi gum ruarin gumgi ndi mbigi, mbe nde kharav, fharav Fhe Bakɨme wo gumgi gu mbigi gari, mbe ana piin ki ntɨɨri vhen ŋgirgɨrga. ");
INSERT INTO geb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ne khaŋ muuŋgi, Zon Gumgi Ruai Guma, ana fharav nde han zɨgap, ana tɨvar vhuun nde khɨvigim, nde ana khothɨgi fhu. Mba ŋkɨɨa ndia rui gumgi gum, ruarir gumgi ndi mbigi, mbe ana suaŋgi buni, mbe nta khothɨgi. Nde mba bigi gangiap, nde wari wo ndɨkndɨgir kurav, ana khothivɨ thagi.” ");
INSERT INTO geb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Zisas mba bunin mbe nzua vov wom khaŋ mba gumgir pani ga nzuai, “Nde mbarara, harigi vhunama si bunai khare. Guma mbe wain mɨna bakɨ mbe muuŋgiap, ana bɨna vhuigi. Ana ana bɨna vhuigap, mba wain vhɨgi muuŋv nta phooŋ ndir zav mbok bakɨme korgi. Ana mbok korgiap, mba wain mɨna ganɨnga gumgi kɨr zav, mbe nzuav vun mbar ndagi phena muuŋgi. Ana mba bigi ga muuŋgiap, mba wain mɨnan gumgi mbari farve khɨngi, mbe ana shɨgar muunga. Ana anan mbe farve khɨngiap, ana mbe thav shama guarara ki ŋgun vugi. ");
INSERT INTO geb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ana vugap kim, mba wain khira vhɨgi mbai tuk hɨgim, ana mbaram ŋaara gumgi mbari ga sarigim, mbe ana nzuav wain vhɨgi kharɨ zav mba mɨnan vui. ");
INSERT INTO geb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ana mbe sarigim, mbe vuim, mba mɨnan ŋgarav ana shɨga mbui gumgi hegap, ana ŋaara gumgi ndigap, mbevi shogiap, mbe mbevi shogim, ana rimgim, mbe mbevi, mbe ŋkɨɨar ana segi. ");
INSERT INTO geb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mbe maaŋ mbe muuŋgi, mba mɨna namkam, ana zumgum won ŋaara gumgi mbari ga sarigim, mbe mben han vegi. Ana ntigem sarigi ŋaara gumgi, mben vhɨrve, ana mba fharav sarigi ŋaara gumgir vhɨrve kambarigi. Ana mbe sarigim, mbe vuim, mba mɨna garav ana shɨga mbui gumgi, mbe mba tɨvara mba ŋaara gumgi ga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Mbe maaŋ mbe muuŋgim, mba mɨna namkam thav won kamara sarigim, ana mbe han vui. Mba mɨna namkam khaŋ nzuai, ‘Mbe nan kama buni mbarararga.’ ");
INSERT INTO geb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ana ne suaŋgiap, ana sarigim, ana vui. Ana vuim, mba mɨnan ŋgari gumgi ana kama gangiap, nduarira khaŋ wari ga nzuai, ‘Mbur zi guma, ana za won ndia bigi ndigirga. Aria, nde zɨv, nza ana shogirim, ana rimgirim, nza ana mɨna ndigip ana vuavi mbuiarga.’ ");
INSERT INTO geb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mbe ne suaŋgiap, ana suirav, ana ndigap, mba mɨna thav kɨrar hɨgap, ana shogim, ana rimgi. ");
INSERT INTO geb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nde kha buneŋ mbararagiap, nde ram mbui ndɨkndɨga mbui? Mba mɨna namkam zumgum zɨv, ana ram mbui tɨvar mba mɨna garav ana shɨga mbui gumgir muuŋgirie?” ");
INSERT INTO geb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ana ne nzuaim, mbe khaŋ ana nzuai, “Ana zɨv farfa mbatɨgar mba gumgi mbatɨgir muuŋgirga. Ana mba tɨvar mben muuŋv, mben tɨn mba wain mɨna ndigip, harigi gumgir nɨɨŋgirim, mbe mba wain mɨna ganɨv, mba wain vhɨgi mbai tugar, mbe ana wain vhɨgi korɨv, ana ntɨɨrir anan nɨɨnga.” ");
INSERT INTO geb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Mbe ne nzuaim, Zisas mben nzarigi, “Ee, nde Fhe Bakɨme buni vhuuiŋ ki gavar kha kameŋ gangi fhuve? Mba kameŋ khaŋ nzuai, ‘Mba pheni ga mbui gumgi, mbe mba kɨma garim, ana mbatɨgim, mbe ana fekhɨngi. Mba kɨm, ana ntigem mba phena bɨna suirigim, ana havhargiap thɨgi. Fhe Bakɨme, ana nduara mba bigeŋ ga muuŋgim, ne hɨgim, nza ne garim, ne guigira vhergi.’ ");
INSERT INTO geb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Maaŋ muuŋgiap, gu nde nzuai, Fhe Bakɨme nde tɨn ana wo piin ki gumgi gu mbigi ga ndɨɨi bigir vhuuiŋ, ana nde tɨn nta ndigip, ntan wo piin ki tɨvi ga mbui gumgi gu mbigi, ana ntan mben nɨɨŋgirga. ");
INSERT INTO geb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Guma, ana mba kɨma tɨɨi rɨgɨrga, mba guma, ana za phaviregɨrga. Mba kɨm, guma the tɨɨi rɨgɨrga, mba guma za berberɨ regɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Zisas mba vhunama si buneŋ suaŋgim, Fhe Bakɨmen rotu gari gumgir pani gum mba Fherasiŋ gumgi, mbe mba buni mbararagiap, mbe kaŋgi, ana mbera nzuai buni ma. ");
INSERT INTO geb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Mbe maaŋ muuŋgiap, guigira Zisasan suira za mbui. Mbe ana suigɨr za mbuav, mbe wom mba gumgi gu mbigir rivgi. Mbe khaŋ muuŋgiap, mba gumgi gu mbigi, mbe kha ndɨkndɨga mbui, Zisas ana Fhe Bakɨmen kamthooŋ guma ma. ");
INSERT INTO geb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Zisas wom mba gumgi ruu phorga nzuav buna mueŋ vhunama sav khaŋ nzuai, ");
INSERT INTO geb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Fhe Bakɨme wo gumgi gu mbigi garim, mbe ana piin ki tɨv khaŋ muuŋgi. Ana ŋgui vhɨrve gari guman pana mbe, ana kam muun rɨgɨr zav mbuim, ana ana nzuav shama bakɨme mbui fara muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ana fharav mba shaman muun zav, ana kama ndiav gumgi mbari ndi mbarigi. Ana kama ndi mbarav, mba shaman muunga tuk hɨgim, ana won ŋaara gumgi ga sarigim, mbe vov, mba shama bakɨmen zɨr zav mba gumgi ga nzuai. Mbe vov, mbe nzuaim, mbe zɨ thagi. ");
INSERT INTO geb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ana wom won ŋaara gumgi mbari ga sarav khaŋ mbe nzuai, ‘Nde ŋgɨp, gu mba fhum kha shama bakɨmen zɨr zav kama ndu mbarigi gumgi ga suaŋv, khaŋ mbe suaŋri, “Nde mbarara! Ana wo shama bakɨme muuŋgi. Ana wo borombaga puri bakɨvira shogap won sɨgi bakɨvira shogi. Ana nta shogiap, won mba tuegim, ana mba mbur ki. Nde ana kam muuaŋ rɨgi shama bakɨmen zɨri.” ’ ");
INSERT INTO geb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ana mba kamen won ŋaara gumgi ga nɨɨŋgim, mbe vov mba gumgi ga nzuaim, mbe ana kameŋ mbarara thav, wari tamtam mbar vegi. Mbe tamtam vov, mbevi vov wo mɨnan ŋgarim, mbevi vov won shɨga mbui. ");
INSERT INTO geb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mbe vov, mbari ga nzuaim, mbe hegap, mba ŋgui vhɨrve gari guman panan ŋaara gumgi suigiap, hor mbatɨgar mbe mbuav, mbe mbari shogim, mbe vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mbe maaŋ mbe muuŋgim, mba ŋgui vhɨrve gari guman pan, ana guigira ne nzuav ndav ana shigim, ana mbaram, won ntari ga mbui gɨɨtɨvi mbari ga sarigim, mbe vov, za mba ana ŋaara gumgi shogim mba vhɨzgi gumgi, mbe za mbe shogim, mbe vhɨzgi. Mbe mbe vhɨzgiap, vhɨra mbe ŋgu pooŋgi. ");
INSERT INTO geb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Maaŋ muuŋgim, mba ŋgui vhɨrve gari guman pan thav khaŋ won ŋaari gumgi ga nzuai, ‘Kha muuaŋ rɨgi guman shama bakɨmen mba gu bigi, nta za bevahega khar ki. Gu mba shama bakɨmen mbɨr zav kamgi gumgi, mbe gumgir vhuuiŋ fhuvara. Mbe mba mban mbɨrga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Maaŋ muuŋgiap, nde za mba tuavir kaar ŋgɨp, nde gumgi ganɨp, nde mben kamɨv, mbe suaŋrim, mbe zɨv mba shaman mbɨrga.’ ");
INSERT INTO geb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ana maaŋ suaŋgim, anan ŋaara gumgi, mbe vov za mba tuavir kaar vov, mbe mba gari gumgi gu mbigi, mbe za mben kaav, mbe nzuai. Mbe za mba gumgi mbatɨgi gu gumgir vhuuiŋ, mbe za mben kaav, mben kov zegi. Mbe zav mba muuaŋ rɨgi guman shama bakɨme pi. Mbe zav mba phena vhuigim, ana guigira givigi. ");
INSERT INTO geb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Mba gumgi gu mbigi zegap piigiap kim, mba ŋgui vhɨrve gari guman pan, ana verav mbe gari. Ana mbe gara vov, guma mbe garim, mba guma muuaŋ rɨgim shama bakɨmen zav, shari shaar vhuuŋ shaara zɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mba ŋgui vhɨrve gari guman pan ana gangiap, ana nzarigi, ‘Ai, kɨvntok, ndu ram muuŋgiap shaar vhuuŋ sharav vhen zergi fhu?’ Mba guma buna thuen ana famsɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mba ŋgui vhɨrve gari guman pan wo ŋaara gumgir kamgiap khaŋ mbe nzuai, ‘Nde kha guma suani gu harani kegɨp, ana fegɨp kɨra khɨngirim, ana gɨngɨnan kɨrga. Mba gɨngɨngi ŋgun ki gumgi, mbe mba ŋanen kav nziav, tari ntɨɨri phɨri.’ ");
INSERT INTO geb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Nde mbarara! Fhe Bakɨme gumgir vhɨrvera kaai. Ana mben kaaim, mbe rɨgar gumgi babara ana khothɨgim, ana mben won mbuigim, mbe ana han vhen veri.” ");
INSERT INTO geb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Zisas mba buni suaŋgim, mba Fherasiŋ mbara vov kama shogiap Zisas ga suaŋv suanga tuavi ndi gari. Mbe khueŋ ndɨkndɨgi, “Nza ana guigip, ana mpararim, ana pham buna thueŋ suaŋgirim, nza ana suaŋgi buneŋra suaŋv, ana suaŋv suaŋgirga.” ");
INSERT INTO geb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mbe mba kama shogiap, mbe mbaram wari wo phorga rui gumgi mbari gum Herotan gumgi mbari, mbe mbe sarigim, mbe Zisas han vui. Mbe vov khaŋ Zisas ga nzuai, “Guman Rum, nza kaŋgi, ndu guigira wo buni nzuai. Ndu mba buni guari nzuav, ndu mba buni guarir gumgi gu mbigi ga nzuav mbe khɨvav, Fhe Bakɨmen tɨvir mbe khɨvi. Ndu guma then rɨvi guma fhuvara. Ndu mba nzuai buni, ndu mba bunin za mba gumgi ga nzuai. Mba zɨ ki gumgi, mba zɨ ki fhuv gumgi, ndu mba suambarar za mbe mbui. ");
INSERT INTO geb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Maaŋ muuŋgiap, ndu nza suaŋ. Ndu ram mbui ndɨkndɨga mbui? Nza ŋkɨɨar Sisar ndɨɨi, ne nzerarame?” ");
INSERT INTO geb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mbe maaŋ nzuaim, Zisas mbe ndɨkndɨgi mbatɨgi kaŋgiap, khaŋ mbe nzuai, “Nde bigi shɨshɨgi gumgi ma. Nde thaŋ nzuav nan mpari? ");
INSERT INTO geb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nde mba ndɨɨi kɨmararaŋ thuen na khɨva.” Ana ne nzuaim, mbe kɨmararaŋ mueŋ ndigap ana ndi zi. ");
INSERT INTO geb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mbe ana ndiga zav Zisas ga nɨɨŋgim, Zisas kha nzambara mbe muuŋgi, “Kha kɨmararen ki guman tum gu zɨ, ni the nɨɨni ma?” ");
INSERT INTO geb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Mbe khaŋ ana nzuai, “Ni Sisar nɨɨni ma.” Mbe ne nzuaim, ana khaŋ mbe nzuai, “Maaŋ muuŋgi, Sisar bigɨn, nde ana Sisaran nɨɨŋri. Maaŋ muuŋgip, Fhe Bakɨmen bigin, nde ana Fhe Bakɨmen nɨɨŋri.” ");
INSERT INTO geb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Zisas mba kamen mbe suaŋgim, mbe mba kameŋ mbararagiap, ŋgava mbatɨga muuŋgi. Mbe ŋgava mbatɨga muuŋgiap, ana thav wari vui. ");
INSERT INTO geb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Zisas mba bunin mba gumgi ruu ga suaŋgi raara, Sadusiŋ mbari Zisas han zi. Mbe khaŋ nzuai ntɨɨri ma, guma rimgiap taagia khavi fhuvara. Mbe zav kha nzambaran Zisas ga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Mbe khaŋ nzuai, “Guman Rum, Moses khaŋ nzuai, ‘Guma the muun tɨgɨ kɨv, ana ana gon tara the tegɨrga fhu, ana fhura kɨv kɨv rimgirga, mba guman ŋguk mba guman niman tɨgɨrga. Ana ana tɨgɨrga, ana ana gon tegɨrga tar mba guma zɨrarga, mba guman shɨk kɨrga. Ana kuigirga tuktɨgi fhuvara.’ ");
INSERT INTO geb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nza fhum maaŋ muuŋgi harathɨgi fegi gu ŋgugi nzan rɨgar kegi. Mbe kav, mben fega rum mba mbiga tɨgi. Ana mba mbiga tɨgap kav, mba mbik ana gon tara the ndigi fhu. Ana fhura kim, mba guma rimgi. Ana rimgim, ara thɨgi guma, ana ŋguk mba mbiga tɨgi. ");
INSERT INTO geb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ana ŋguk, ana tɨga kav, ana vhɨra rimgi. Mba mbik, ana gon tara the tegi fhu. Ana rimgim, ara thɨgi ne, ana ana nima tɨgi. Ana ana tɨgap, ana mbara muuŋgi. Mbe za mbara mbuav vov mpuun mben ŋgugage, ana harathɨgi ne ma. Ana mpuun mba mbiga tɨgi. ");
INSERT INTO geb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mbe mbara mbuav vov za vhɨzgim, mba mbik mpuun mbe zɨn rimgi. ");
INSERT INTO geb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ndu khar nza suaŋ. Mba vhɨzgi gumgi taagia khavɨrga tugen, mba mbik, ana then muuŋ kɨrie? Ana khaŋ muuŋgi, mba harathɨgi fegi gu ŋgugi, mbe za mba mbiga tɨga kegi. Ndu kaŋgi, mba harathɨgi gumgi, mbe za mba mbiga tɨga kegi.” ");
INSERT INTO geb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Mbe maaŋ nzuaim, Zisas mbe ŋgarkarav khaŋ nzuai, “Nde Fhe Bakɨme buni vhuuiŋ ki gavar ki buni kaŋgi fhuvara. Nde vhɨra Fhe Bakɨmen ŋkasŋka kaŋgi fhuvara. Nde maaŋ muuŋgiap, nde pham buni nzuai. ");
INSERT INTO geb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mba vhɨzgi gumgi, mbe taagi khavɨrga tugen, mba gumgi gu mbigi, mbe warir rɨgɨrga tuktɨgi fhuvara. Mbe Fhe Bakɨme enserin farar muuŋgip kɨrga. ");
INSERT INTO geb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Gu nde mba vhɨzgi gumgi ga nzuai ne nzuav, gu nden nzai. Ee, nde mba Fhe Bakɨmen buni vhuuiŋ ki gavar, Fhe Bakɨme nde suaŋgi kameŋ, nde ne gangi fhuve? ");
INSERT INTO geb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ne khaŋ nzuai, ‘Gu Abrahaman, Aisak, Zekop, gu mben Fhe Bakɨme ma.’ Fhe Bakɨme, ana mba vhɨzgiap za vhɨzgi gumgir Fhe Bakɨme fhuvara. Fhe Bakɨme, ana mba zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigi gumgir Fhe Bakɨme ma.” ");
INSERT INTO geb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Zisas ne suaŋgim, mba gumgi gu mbigi ne mbararagiap, ne ga nzuav ŋgava mbatɨga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Zisas mba kameŋ suaŋgim, mba Fherasiŋ ne mbararagim, mba buneŋ Sadusiŋ thɨri mpɨrigim, mbe wari fugap mbaram Zisas han zi. ");
INSERT INTO geb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mben rɨgar Zudaiŋ tɨvir vhuuiŋ kaŋgi guma mbe ki. Ana Zisasan panɨ zav kha nzambarar ana muuŋgi, ");
INSERT INTO geb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Guman Rum, maaŋgi tɨv ana kha Moses suaŋgi tɨvi, ana za nta kambarav fharigi?” ");
INSERT INTO geb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ana maaŋ nzuaim, Zisas khaŋ ana nzuai, “ ‘Ndu Fhe Bakɨme vuzvugiri, ana nza Bakɨme ma. Nde guigira wari won ndavi vherir ana vuzvugiri. Nde vhɨra wari wo ntuun ana vuzvugiri. Nde vhɨra wari won ndɨkndɨgir ana vuzvugiri.’ ");
INSERT INTO geb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kha tɨv, ana guigira kɨvgiap, ana guigira fharigi tɨv ma. ");
INSERT INTO geb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ara thɨgi tɨv, ana vhɨra ana fara muuŋgi. Mba tɨv khaŋ muuŋgi, ‘Ndu wora vuzvugi tɨvara, ndu harigi ntɨɨri vuzvugiri.’ ");
INSERT INTO geb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kha tɨvani, ni za mba tɨvir nɨɨŋge ma. Ni vhɨra mba Fhe Bakɨme kamthooŋ gumgi suaŋgi bunin nɨɨŋge ma.” ");
INSERT INTO geb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mba Fherasiŋ maaŋ phok ga vhuigap kim, Zisas mben nzarigi, ");
INSERT INTO geb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nde ram mbui ndɨkndɨgar mba Fhe Bakɨme taagiap wo gumgi gu mbigi ndir zav suaŋgiap farasarigi guma ga mbui? Ana then kam ma?” Mbe hegap khaŋ ana nzuai, “Ana Devitan Kam ma.” ");
INSERT INTO geb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Mbe maaŋ nzuaim, Zisas khaŋ muuŋgia tɨgap mben nzarigi. “Ram muuŋgiap, Fhe Bakɨmen Ŋina Ŋaar ndɨkndɨgar Devit ga ndɨɨim, Devit nduara, kha kakaman ana mbui, ‘Guma Bakɨme?’ Devit nduara kha kakaman ana mbui. ");
INSERT INTO geb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Fhe Bakɨme khaŋ na Bakɨme nzuai, “Ndu na guva haren pera kɨrim, gu ndun pana gumgi ndiv ndun piin khɨngirga, mbe ndun piin kɨrga.” ’ ");
INSERT INTO geb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Nde khar mbarara! Devit nduara kha kakaman ana mbui, ‘Guma Bakɨme.’ Ana mba kakaman ana muuŋvra kɨrim, ana ram muuŋgip ana kam kɨrie?” ");
INSERT INTO geb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Zisas nen mbe suaŋgim, ana buneŋ ŋgarkarga guma the ki fhuvara. Zisas mba buneŋ suaŋgi raa thɨgap, Zisas wom buni nzuaim, mbe buna thueŋ ga suaŋv ana nzangen rivgi. ");
INSERT INTO geb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Zumgum, Zisas Fhe Bakɨme buni vhuuin mba gumgi gu mbigi ga nzuav, wo phorga rui gumgi ga nzuai. ");
INSERT INTO geb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ana mbe nzuav khaŋ mbe nzuai, “Mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi gu mba Fherasiŋ, mbe Fhe Bakɨme suaŋgi tɨvir nde khɨvav, mbe Moses muuŋgi tɨva mbui. ");
INSERT INTO geb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Maaŋ muuŋgiap, mbe nde khɨvav nde nzuai buni, nde za nta zɨn ŋgɨri. Nde mbe mbui tɨvi, nde nta zɨn ŋgɨ thari. Mbe buni vhɨrver nde nzuav, mbe nduarira mba buni zɨn vui fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mbe maaŋ mbuav, mbe bigi ntok bakɨme kegap, ana ndiav kha gumgi gu mbigi phɨgi ga suim, mbe ntan simtɨga ndiav kavtuigi. Mbe hara thanen mbe ndɨɨv, mben kurav mba simtɨgi ndi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mbe mba mbui tɨvi, mbe mba gumgi gu mbigi, mbe ganɨ zav mbe mba bigi ga mbui. Nde kaŋgi, Fhe Bakɨme khaŋ muun zav nza suaŋgi. Nza Fhe Bakɨme buni thariveŋ khergip kovsɨk thaneŋ ga suegɨp wari won panin fegɨrga. Nza vhɨra thari khergip wani won hari phok kegɨrga. Nde mba buni thari wari won shagir mpeeiŋ tɨvi phorgɨp samgirga. Nza maaŋ muunga mba gumgi gu mbigi nza gangip kaŋgirga. Nza Fhe Bakɨmen ndikndigap ana piin ki. Mbe gumgi gu mbigi, mbe ne mbuav mbe kovsɨgi bakɨvi ga mbuiav mba kargir ŋkɨɨri vhuuiaŋ mbui. Mbe nta mbuim, nta kɨvgiap, harigi gumgi gu mbigi ntɨɨri kambarigi. ");
INSERT INTO geb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mbe shaa bakɨvir vov, mbe zɨ ki gumgi piigi mpirmpirɨgira piigi. Mbe vhɨra Fhe Bakɨme buni mbararagi phenin vov, mbe vhɨra zɨ ki gumgi piigi mpirmpirɨgira piigi. ");
INSERT INTO geb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mbe vhɨra khueŋ vuzvugi, mbe mba phogi ga vhui ŋanin ŋgɨrim, mba gumgi gu mbigi raar vhuun mbe nɨɨŋv, vhɨra kha kakaman mben muunga, ‘Gumgir Ruua.’ ");
INSERT INTO geb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Mbe maaŋ nzuai, guma the ‘Guma Ruman’ nden kamgirga tuktɨgi fhu. Zakɨra fhuvara! Guman Ruma bavira nde gari, nde za fegi gu ŋgugira ki. ");
INSERT INTO geb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nde vhɨra kha nuianan, nde ‘ndiar’ guma then kamɨ thari. Nde Ndia bavira ki, ana mbu Hevenan ki. ");
INSERT INTO geb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mbe vhɨra gumgir panin nden kamɨnga tuktɨgi fhuvara. Nde guman pana bavira ki. Mba guma, ana Fhe Bakɨme nduara ana farasarigi, ana za kha nuianan ki gumgi gu mbigi ndir zav zergi. Ana nduara nden guman pan ma. ");
INSERT INTO geb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nden guman pan, ana nden ŋaara guma kɨrga. ");
INSERT INTO geb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Guma, ana nduara wo zɨ ndi vun fɨrga, ana zɨ guigira ŋgirgɨrga. Guma, ana wo zɨ mbevigi, mba guma, ana zɨ bakɨme ndirga.” ");
INSERT INTO geb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi gu Fherasiŋ, nde warir rɨvɨri. Nde paaŋ ze gi ntɨɨri ma. Nde Fhe Bakɨme piin ki gumgi gu mbigi ki ŋgu Hevenan veri thɨmkamani mpɨri gumgi ma. Nde vhɨra, nde nduarira ana vhen veri fhu. Nde gumgi gu mbigi mba ŋgun vhen ŋgirɨ za mbuim, nde mba tuav mpɨri. ");
INSERT INTO geb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Nde Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi gu Fherasiŋ, nde warir rɨvɨri. Nde paaŋ ze gi ntɨɨri ma. Nde za kha mbasɨk gu nuiana ruav, nde gumgi bevbevira mbuim, mbe nde zɨn vov, nde phorga rui gumgi ki. Nde mbe muuŋgim, mbe Herar veri. Mbe ndera fara muuŋgi. Nde maaŋ mbe muuŋgim, mbe guigira nde kambarav Herar vheza bakɨ guarara ndir za mbui. ");
INSERT INTO geb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Nde rɨmgi mbatɨgi gumgi, nde tuavar harigi gumgi khɨvɨr za mbui, nde warir rɨvɨri. Nde kha khesharigi buni nzuai, ‘Guma buna thuen Fhe Bakɨme Phena suaŋgirga.’ Nde khaŋ nzuai, mba kameŋ, ne fhura ki kameŋ ma. Nde maaŋ muuŋgip guma the khaŋ suanga, ‘Gor Fhe Bakɨme Phena ki,’ mba guma maaŋ suaŋgirga, ana guigira mba suaŋgi kameŋ zɨn ŋgɨp mba bigen muuŋgiri. ");
INSERT INTO geb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nde ŋanŋangiap, rɨmgi mbatɨgi ntɨɨri ma. Maaŋgi tɨv ana Fhe Bakɨme nɨman fharigi? Ee, gor ana fharigire? Ee, Fhe Bakɨme Phen ee? Nde kaŋgi, gor ana Fhe Bakɨme Phenan ki, ana Fhe Bakɨme bigɨn ma. ");
INSERT INTO geb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nde vhɨra khaŋ nzuai, ‘Guma ana buna thuen artar ga suaŋgirga, nde khaŋ nzuai, ne fhura ki kameŋ ma. Ana maaŋ muuŋgip, Fhe Bakɨme suaŋv shaman muuŋgip mba artar tɨn naanga kameŋ suaŋgi. Ana mba khesharigi kameŋ suaŋgi, ana mba suaŋgi kameŋra zɨn ŋgɨgɨp guigira mba bigen muuŋgiri.’ ");
INSERT INTO geb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nde rɨmgi mbatɨgi gumgi ma. Maaŋgi bigeŋ ne Fhe Bakɨme rɨmani nɨman fharigi? Fhe Bakɨme nzuav shama mbui ne o, ana artar? Artar mba Fhe Bakɨme nzuav shama mbui bigi ga muuŋgim, nta Fhe Bakɨme bigi ma. ");
INSERT INTO geb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Maaŋ muuŋgiap, guma mba artar zitav nzuai, ana mba artar gu anan tɨn ki bigi, ana nta havhara nzuai. ");
INSERT INTO geb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Guma Fhe Bakɨme Phena nzuav, ana won kameŋ havharav, ana vhɨra Fhe Bakɨmera nzuai, ana wo phenan ki. ");
INSERT INTO geb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Guma vhɨra ana won bunai havharɨ zav nzuav vov Heven zitagi. Ana wo bunai havharav Fhe Bakɨme pigi mpirmpirɨk zitagi, Fhe Bakɨme nduara mba mpirmpirɨga pigi. ");
INSERT INTO geb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Nde Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi gu Fherasiŋ, nde warir rɨvɨri. Nde paaŋ ze gi gumgi ma. Nde wari wo mɨnin ki mpampari, nde za nta shama mbuav, phɨkthɨgi phogi ga vhuav, phok mbe, nde ana Fhe Bakɨme ndɨɨi. Maaŋ muuŋgiap, nde thira bisarirer kaŋgiap, nta zɨn vui. Nde maaŋ mbuav, nde Fhe Bakɨme suaŋgi tɨvi bakɨvi, nde nta zɨn vui fhu. Mba tɨvi khaŋ muuŋgi, tɨvi vhuuiŋ ga mbui tɨvi, gumgi tɨvi gari tɨvi, bigi khothɨgi tɨvi. Mba Fhe Bakɨme nzuai tɨvi bakɨvi, nde khaŋ tɨgɨp nta zɨn ŋgɨri. Nde nta zɨn ŋgɨv, nde vhɨra mba harigi tɨvi bisarire, nde vhɨra nta zɨn ŋgɨri. Nde nta thamtha thari. ");
INSERT INTO geb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nde rɨmgi mbatɨgi gumgi, nde tuavar harigi gumgi khɨvɨr za mbuire? Nde phukshaaŋ bisaneŋ garim, ne nde mba rɨgim, nde ne ndigi. Nde mba kemor ruma gangi fhuvara. Nde mba pav ana khɨga mbegi. ");
INSERT INTO geb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Nde Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi gu Fherasiŋ, nde warir rɨvɨri. Nde paaŋ ze gi gumgi ma. Nde mba gu mbɨ pi tha gu thuuri, nde nta kɨri ruai. Nde nta sua pi mba, nde kɨkɨma panan nta ndiav, nde vhɨra warira ndɨkndɨgi. ");
INSERT INTO geb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nde Fherasiŋ, nde rɨmgi mbatɨgi ntɨɨri ma. Nde fharav phara pi tha, nde nta vheri ruagirim, ntan kɨri vhɨra ŋgararga. ");
INSERT INTO geb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nde Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi gu Fherasiŋ, nde warir rɨvɨri. Nde paaŋ ze gi gumgi ma. Nde guma rimgim, mbe ana ndi mbok ga tɨgi mbok fara muuŋgi. Mbe kɨrar pena hurar ana hɨvgim, ana gangan vhergi. Ana mbok vhen guma khurigim, ana hari, ana kim, ana guigira mbatɨgiap nzaŋnzaŋgi. ");
INSERT INTO geb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nde vhɨra mba khesharav ki. Kha gumgi gu mbigi nde fhavi garav khaŋ nde nzuai, nde tɨvir vhuuiaŋ mbui gumgi ma. Nden ndavir vheri gu nde ndɨkndɨgi, nde bigi guiguigiap, Fhe Bakɨme nzuai tɨvi daasui gumgi ma.” ");
INSERT INTO geb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi gu Fherasiŋ, nde warir rɨvɨri. Nde paaŋ ze gi gumgi ma. Nde Fhe Bakɨmen kamthooŋ gumgi ga nzuav mbogir vhuuiŋ korav, nde vhɨra tɨvar vhuuiŋ ga mbui gumgi, nde mbe mbogi nzɨɨi gumgi ma. ");
INSERT INTO geb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nde maaŋ mbuav khaŋ nzuai, ‘Nza fhum wari won nzɨgi tugen kega kake, nza mben kurav Fhe Bakɨmen kamthooŋ gumgi shogɨrim, mbe vhɨzɨrga tuktɨgi fhu.’ ");
INSERT INTO geb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nde mba khesharigi kameŋ nzuai, ne khaŋ muuŋgi, nde nduarira wari ndi khɨvigi, nde mba Fhe Bakɨmen kamthooŋ gumgi shogi mbe vhɨzgi gumgir ŋkaa ma. ");
INSERT INTO geb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aria, nde wari won nzɨgi muuŋgi tɨvi mbatɨgi, nde mbe zɨn ŋgɨp, mba tɨvir muuŋv za mba ŋaara vhɨzgiri. ");
INSERT INTO geb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nde kurigi mbatɨgi ma. Fhe Bakɨme nde muuŋgi tɨvi mbatɨgi ga suaŋv nde suanga, nde Herar ŋgegɨrga ntɨɨri ma. Nde ram muuŋgip Her ŋkɨɨarie? ");
INSERT INTO geb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Maaŋ muuŋgiap, nde mbarara! Gu Fhe Bakɨmen kamthooŋ gumgi, gum mba ndɨkndɨgi vhuuiŋ ki gumgi, gu mba Fhe Bakɨmen tɨvi vhuuin khɨvi gumgi, gu mbe sararim, mbe nde han zɨrga. Nde thari shogɨrim, mbe vhɨzɨrga. Thari, nde mbe ndiv khirararaiŋ ga tɨgɨp fukfugɨrga. Thari, nde Fhe Bakɨme buni mbararagi pheni vherir mpiiŋsɨgar mbe kharɨrga. Nde maaŋ mben muuŋv, nde wari wo ŋgui bakɨvir vhen mbe zɨtɨgɨp, mbe ndi kɨrar maaŋrim, mbe rɨv harigi ŋgui bakɨvir ŋgɨrga. ");
INSERT INTO geb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Maaŋ muuŋgiap, za kha nuianan tɨvi vhuuiaŋ mbui gumgi shogim, mbe vhɨzgi gumgi, mben simtɨgi ndera ndarga. Mbe fhum mba tɨvir vhuuiaŋ mbui guma Aber kegi tugen, mbe mba tɨvir vhuuiaŋ mbui gumgi shoga zav ntigem Sekaraia, Berekiar kam kegi tuge thɨgi. Nde mba tugen mba Fhe Bakɨme Phena gu artara kɨtɨgen, nde Sekaraia shogim, ana rimgi. Nde nduarira za mba tɨvi mbatɨgir simtɨgi ndirga. ");
INSERT INTO geb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Gu guigira nde nzuai, mba tɨvi mbatɨgi, nde ntige khar ki gumgi gu mbigi, nde mba tɨvi mbatɨgir simtɨgi ndirga.” ");
INSERT INTO geb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Zisas mba bunin mbe nzua vov khaŋ nzuai, “O, Zerusarem, O, Zerusarem, ndu the Fhe Bakɨmen kamthooŋ gumgi shogim, mbe vhɨzgim, ndu mba Fhe Bakɨme sasarigi zi gumgi, ndu mbe ndiav ŋkɨɨar mbe sim, mbe vhɨzgi. Gu tugi vhɨrvera, ndun tari, gu mbe ndiav tuara meeŋ won ŋgugi ndi mbarɨva vhui tɨvar mben muun za mbui. Gu maaŋ mbe mbuim, mbe thamthagi. ");
INSERT INTO geb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ndu mbarara! Ndun ŋgu ntigem mbatɨgip fhura kegɨrga. ");
INSERT INTO geb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Gu khaŋ ndu nzuai, ndu wom na gangirga fhu. Ndu fhura kɨv kɨv, ndu thav khaŋ suanga, ‘Fhe Bakɨme tɨvar vhuuŋra mba Guma Bakɨme zɨ muuŋgia zi guman muuŋri.’ Ndu mba tugen wom na gangirga.” ");
INSERT INTO geb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Zisas mba bunin Zerusarem ga suaŋgia thugap, Fhe Bakɨme Phena thav kɨrar hɨgap vui. Ana kɨrar hɨgap vuim, ana phorga rui gumgi ana han zi. Mbe zav Fhe Bakɨme Phena muuŋgi bigi garav, ntan ana khɨvav ana nzuai. ");
INSERT INTO geb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mbe ana nzuaim, ana kha kamen mbe nzuai, “Nde kha phena vhuuaŋ muuŋgi bigi garire? Gu guigira nde nzuai, mbe ana kɨma the ganɨri, ana harigi ne tɨn ndarav kegɨrga tuktɨgi fhuvara. Mbe za nta shogɨp, nta phɨrɨv, za nta fuv nɨɨaŋ suegɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Zisas vov, Oriv mbɨkshɨman ndav perav kim, ana phorga rui gumgi, mbe nduarira ana han zav, kha nzambarar ana muuŋgi, “Ndu khar nza suaŋ, maaŋgi tugar mba bigi nzan hɨrie? Ram mbui khesharigi bigeŋ fharav nzan hɨgɨrim, nza gangip, kaŋgip, khaŋ suanga, ndu taagi nuianan zirɨ za mbui, kha nuian vhɨzɨrga?” ");
INSERT INTO geb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Mbe ne nzuaim, Zisas mbe ŋgarkarav khaŋ mbe nzuai, “Nde warir rɨvɨri. Nde muuŋv kɨrim, guma the zɨv nde guigirga. ");
INSERT INTO geb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ne khaŋ muuŋgi, gumgi vhɨrve mbe zɨv, na zɨn warir rɨgɨp, khaŋ suanga, ‘Gu Fhe Bakɨme taagip kha nuianan ki gumgi gu mbigi ndir zav suaŋgiap farasarav sarigi guma ma.’ Mbe maaŋ suaŋv gumgi gu mbigi vhɨrve guigirga. ");
INSERT INTO geb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Nde ntari bakɨvi khɨkhɨm mbarararga, nde vhɨra ntari baikɨvi mbe ntan muuŋrim, nde ntan bɨɨŋbɨɨin kaa mbararga. Nde warir rɨvɨri. Nde mba bigi mbararav, nde ŋgava mbatɨgar muuŋ thari. Mba bigi maaŋ muuŋgip hɨrga, kha nuian vhɨzɨrga tuk ntigar hɨrga. ");
INSERT INTO geb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Harigi gumgi thari harigi gumgi thari phorgɨ shogɨrga. Harigi ŋgui vhɨrve gari gumgir pani, mbe harigi ŋgui vhɨrve gari gumgir pani phorgɨp shogɨrga. Ŋgui thari, mbe thir vhɨzi tuga mbatɨk mben hɨrga, khɨmkhɨk ŋgui thari muunga. ");
INSERT INTO geb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mba bigi ntan simtɨk, nta mbik fharav tara tɨr zav zaa ndi zaa fara muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Mbe mba tugen nde ndiv zaagir nde nɨɨŋv, simtɨgir nden nɨɨŋv, nde shogɨrim, nde vhɨzɨrga. Kha gumgi gu mbigi, mbe panan nde kɨrga ne khaŋ muuŋgi, na zɨ nden ki. ");
INSERT INTO geb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mba tugen na khothɨgi gumgi vhɨrve, mbe na khothivɨ tharga. Mbe na khothivɨ thav, mbe nduarira panan warira kegɨp, mbe nduarira warira suaŋv wari won pana gumgi ga suanga. ");
INSERT INTO geb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mba tugen Fhe Bakɨmen kamthooŋ gumgir wari ga shɨshɨgi gumgi vhɨrve hegɨp, gumgi gu mbigi vhɨrve guiguigirga. ");
INSERT INTO geb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mba tugen, tɨvi mbatɨgi vhɨrve hɨrga. Gumgi gu mbigi vhɨrve, mbe guigira harigi ntɨɨri vuzvugi tɨva tharga. ");
INSERT INTO geb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mba tugen thɨga havhargiap kav kim, kha nuian za vhɨzi tugar hɨgi gumgi gu mbigi, Fhe Bakɨme taagip mbe ndigirga. ");
INSERT INTO geb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mbe ntigem, Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga buni vhuuiŋ bun za kha nuianan ki gumgi gu mbigi ga suaŋgirga, mbe za Fhe Bakɨme buni mbararagirga, kha nuian za vhɨzi tuk hɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde mba bigɨna mbatɨga guarara ganɨnga, mba bigɨn Fhe Bakɨme kamthooŋ guma Danier fhum ana bun suaŋgi. Mba bigɨn Fhe Bakɨme Phenan vhera thɨgɨrga.” Mba bigɨn Fhe Bakɨme Phena muuŋgirim, ana nzaŋnzaŋgirga. Guma kha bunaiŋ ganɨv, ndɨkndɨga vhuun muuŋri. ");
INSERT INTO geb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Mba tugen mba Zudia ŋgu bakɨme fhaiŋ ki gumgi gu mbigi, mbe za rɨv mba mbɨkshɨɨr ndari. ");
INSERT INTO geb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Guma vhɨra, ana wo phena vun kegɨp, ana taagi wo phena vhen ŋgirɨp wo bigi ndir saŋ muuŋ thari. ");
INSERT INTO geb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Guma vhɨra, ana wo mɨnan kegɨp, ana taagip wo phenan ŋgɨp wo shaa mpeeŋ ndir saŋv ŋgɨ thari. ");
INSERT INTO geb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Gu guigira mba tugen ndavir kav tari hɨvire tegap tiran mbe ndɨɨi mbigi, gu guigira mbe kora muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nde khueŋ suaŋv Fhe Bakɨme phorgɨp suaŋrim, ana nden kurari. Nde mba rugahi tugar nde rɨrga fhu, nde vhɨra Sabatar rɨrga fhu. ");
INSERT INTO geb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mba tugen simtɨga bakɨ guarara hɨrga. Fhum fhara guarara Fhe Bakɨme kha nuiana muuŋgi tugen kegap zav ntige kha tuge thɨgi maaŋ muuŋgi simtɨga the hɨgi fhuvara. Zumtugum mbara muuŋgirga. Mba khesharigi simtɨga the hɨgɨrga fhu. ");
INSERT INTO geb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Fhe Bakɨme maaŋ muuŋgip mba simtɨgi hɨrga tuga tivgi fhu, kha gumgi gu mbigi za vhɨzgirga. Ana mba farasegi gumgi gu mbigi ga ndɨrga, ana maaŋ muuŋgiap mba tuga tivgirga. ");
INSERT INTO geb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Mba tugen guma the khaŋ nde suanga, ‘Nde ganɨ, Fhe Bakɨme taagip kha gumgi gu mbigi ndir zav suaŋgiap farasarav sarigi guma, ana khar hɨgi,’ o, ‘Ana mbur hɨgi.’ Mbe maaŋ suaŋrim, nde mbe khothivɨ thari. ");
INSERT INTO geb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ne khaŋ muuŋgi, gumgi thari, mbe zɨv guiguigɨv khaŋ suanga, ‘Gu Fhe Bakɨme taagip wo gumgi gu mbigi ndir zav suaŋgiap farasarigi guma ma,’ o ‘Gu Fhe Bakɨmen kamthooŋ guma ma.’ Mbe maaŋ suaŋv, mbe mbarkɨrga mirikori, mbe ntan muunga, mbe mbarkɨrga bigi, mbe ntan muunga. Mbe mba gumgi gu mbigi, mbe mbe ndɨkndɨgi ŋgɨrga. Mbe maaŋ muuŋv, mbe tuktɨgɨrga, mbe vhɨra mba Fhe Bakɨme farasegi gumgi gu mbigi, mbe vhɨra mbe ndɨkndɨgi ŋgɨrga. ");
INSERT INTO geb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","“Nde mbarara! Gu mba hɨrga bigi, gu za nta bun nde suaŋgi. ");
INSERT INTO geb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Maaŋ muuŋgip, mbe khaŋ nde suanga, ‘Ana mbu gumgi ki fhuv ŋanen hɨgi,’ nde mba ŋanen ŋgɨ thari. Mbe vhɨra maaŋ muuŋgip khaŋ suanga, ‘Ana mbu phena vhen ki,’ nde mbe nzuai kameŋ khothivɨ thari. ");
INSERT INTO geb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","“Nde kaŋgi, buip vhekvhegi tugen, ana vhekvhegiap, fhura vhemkora ra ndai fhain kegap, za vov ra veri fhain vergi. Mba tɨvara Fhe Bakɨme Guma Guar kha nuianan zirɨrga. ");
INSERT INTO geb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Mba vhɨzgi gumgi, ŋkuua ki ŋanera, mba baŋgari zav phogi ga vhui.” ");
INSERT INTO geb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Mba simtɨgi bakɨvi hegɨ thugɨrim, ra ŋguigirga, maaŋ gɨngirga. Kɨni wom shɨrarga tuktɨgi fhuvara. Ŋkaa kha buiva thav korɨv nɨɨaŋ regɨrga. Kha buivar ki bigi bakɨvi, nta za nɨɨŋkurga. ");
INSERT INTO geb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mba tugen Fhe Bakɨme Guma Guar, kha nuianan zirɨrga ana bun nzuai bigeŋ kha buivar hɨgɨrga, kha nuianan ki gumgi gu mbigi sɨmɨv nzirga. Mbe nziv ganɨnga, Fhe Bakɨme Guma Guar, ana Hevenan kegɨp buiva hura phorgɨp won ŋkasŋka bakɨm gum vhava ŋaara bakɨme phorgɨp zirɨrga. ");
INSERT INTO geb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ana zirɨrga buiva mbarɨp guigira kɨvgip sɨmɨnga, ana won enseri ga sararim, mbe za kha nuianan ŋgɨp, ana mba farasegi gumgi gu mbigi, mbe mbe fukfugɨrga. Mba Fhe Bakɨme enseri mbe za mba gumgi fukfugɨp, ŋgɨp za kha nuian vhɨzi tɨvara ŋgɨgɨp, mbe ndi ana han zɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde fik kha ganɨv kaŋgiri. Mba fik khage mbɨ ndiap, ana ŋgagi khovɨrim, nde kaŋgi, ntigem ra thivɨr za mbui. ");
INSERT INTO geb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nde mba tɨvara, nde kha bigi ganɨrim, nta za hegɨrim, nde kaŋgiri, Fhe Bakɨme Guma Guar zirɨrga tuk han mbarav khakhɨnanera. ");
INSERT INTO geb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Gu guigira nde nzuai, ntige khar ki gumgi gu mbigi, mbe guara vhɨzgirga fhu, mbe khara muuŋgip kɨrim, kha bigi hegɨrga. ");
INSERT INTO geb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kha buip gu nuian, mani vhɨra za vhɨzgirga. Nan buni vhuuiŋ, nta vhɨzgirga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Guma the kha bigi hɨrga raa gu tuga kaŋgi fhuvara. Kha Fhe Bakɨme enseri, mbe vhɨra mba tuga kaŋgi fhuvara. Anan Kam vhɨra, mba tuga kaŋgi fhuvara. Anan Ndia nduara mba tuga kaŋgi. ");
INSERT INTO geb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mbe fhum Noa tugen muuŋgi tɨvara, mbe ntigem Fhe Bakɨme Guma Guar zirga tugar, mbe mba tɨvara muuŋgirga. ");
INSERT INTO geb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mba tugen, mbɨ ntigar naaŋ zɨv mbe phorɨrga. Mbe mba tugen, mbe kav, mbe mba pav, phara pav, mbe mani gu mburi wari ga rɨgap, mbe mbara mbuav kim, Noa vov mba kema vhen vergi. ");
INSERT INTO geb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mbe mba bigeŋ mben hɨrgane kaŋgi fhuvara. Mbe mbara muuŋgiap kim, mbɨ vhuuŋgia ndav za mba gumgi gu mbigi phorgim, mbe vhɨzgi. Mba khesharigi tugara ntigem Fhe Bakɨme Guma Guar taagi zirga, mba khesharigi tɨvara hɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Guma phunini wani tɨgɨp mɨnan kɨrga, Fhe Bakɨme Guma Guar the ndigirga, ana the tharga. ");
INSERT INTO geb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mba tɨvara, mbiga phuni wani tɨgɨp kɨv vikntuu turga parawa mbuvɨv kɨrga, Fhe Bakɨme Guma Guar the ndigirga, ana the tharga. ");
INSERT INTO geb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Maaŋ muuŋgiap, nde tuituigip wari ganɨv kɨri. Nde kaŋgi fhuvara, nde Guma Bakɨme maaŋgi tugar zɨrie? ");
INSERT INTO geb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nde khueŋ ndɨkndɨk. Phena namkam, ana kɨma guma maan zɨv, ana phena phɨrgip ana bigi kɨmɨnga tuga kaŋgirga, ana kav gari. Ana fhura mba kɨma guma ganɨrim, ana zɨv ana phena phɨrgirga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Maaŋ muuŋgia nde vhɨra wari ganɨv kɨri. Fhe Bakɨmen Guma Guar nde ana zɨrgeŋ ndɨkndɨgi fhuv tugera ana zirgɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Maaŋgi ŋaara guma ana ndɨkndɨga vhuuŋ kav, ana zazera ŋaara vhuuŋra mbui? Mba khesharigi ŋaara guma, ana gari guma bakɨme, ana ndi fagim, ana ana ŋaara gumgi garav, ana mba sarigi tugara, ana mban mbe ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mba khesharigi ŋaara guma, ana guma bakɨme taagia zav ana garim, ana won ŋaara mbuav ki. Mba ŋaara guma, ana ndikndigɨri. ");
INSERT INTO geb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Gu guigira nde nzuai, mba khesharigi ŋaara guma, ana gari guma bakɨme, ana ndi farga, ana za ana bigi ganɨnga. ");
INSERT INTO geb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mba ŋaara guma, ana kha ndɨkndɨga mbui, ‘Na gari guma bakɨme, ana vhemkora zɨgɨrga fhuvara.’ ");
INSERT INTO geb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ana mba ndɨkndɨga mbuav, ana wo phorga ŋgari ŋaara gumgi shogɨp, mben muuŋv, mbar mbɨv, phara ŋanŋani pi gumgi phorgɨp pharar mbɨv ŋanŋanɨv kɨrga. ");
INSERT INTO geb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ana maaŋ muuŋv kɨv, ana kha ndɨkndɨgar muunga, ‘Na gari guma bakɨme zɨrga tuk han mbarigi fhuvara.’ Ana mba khesharigi ndɨkndɨgar muuŋv kɨrga, ana guma bakɨme hɨgɨrga, ana ŋgava mbatɨga muunga. ");
INSERT INTO geb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ana zɨrga, ana ana gangip, ana guigira anan farfagirga. Ana mba paaŋ ze gi gumgir farfagi tɨvara anan muuŋgirga. Ana ana ndi mbe phorgɨp khɨngirga, mbe mba ŋanen kɨv nzi mbatɨgar muuŋv, wari wo tari ntɨɨri phɨrɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Mba tugen Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga tɨv, ana phɨkthɨgi mbigir ŋkaa muuŋgi tɨv, mbe ne neŋgegi. Ana mbe farar muuŋgirga. Ana kha tɨvar muuŋgirga. Guma mbe, ana ntigera muun rɨgɨr za mbui. Ana ntigera muun rɨgɨr zav zi. Ana zim, mba phɨkthɨgi mbigir ŋkaa, mbe won raa ndigap, ana kuv zɨr zav, wari ana puav vui. ");
INSERT INTO geb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mbe vov, meeŋthɨgi mbigi, mbe pham bigi ga mbui mbigi ma. Meeŋthɨgi ntɨɨri, mbe ndɨkndɨgi vhuuiŋ kav, mbe nzerara bigi ga mbui. ");
INSERT INTO geb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mbe vov, mba pham bigi ga mbui meeŋthɨgi mbigi, mbe wari won raa ndiga vov, mbe won raa ga nzuav vhava mbɨ phorga ndiga vegi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mba harigi meeŋthɨgi mbigi, mbe ndɨkndɨk vhuuŋ kav, mbe wari won raa mbe vhava mbɨn nta ruigap, mbe vhɨra wari won raa ga nzuav harigi vhavi phara phorga ndiga vegi. ");
INSERT INTO geb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mbe vegap, mba ntigera muun rɨgɨ zav zi guman rargap wari kim, ana vhemkora zɨgi fhu. Mbe maaŋ muuŋgiap ana rarga kav kav, ŋkuu mbe mbuim, mbe rɨmgi, mben simgim, mbe kuav ki. ");
INSERT INTO geb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Mbe kuav kim, maaŋ rɨgar, mbe guma mbe mbararagim, ana kaav khaŋ nzuai, ‘Mba ntigera muuaŋ rɨgi guma, ana mbur zi. Nde zɨv, nza anan puv ŋgɨp, ana kuv zɨrga.’ ");
INSERT INTO geb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ana ne nzuaim, mba mbigir ŋkaa khavgiap wari won raar wigi khavi. ");
INSERT INTO geb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mbe won raar wigi khavim, mba pham bigi ga mbui meeŋthɨgi mbigi, mbe khaŋ mba ndɨkndɨga vhuuŋ ki meeŋthɨgi mbigi ga nzuai, ‘Nde wari wo raa ga rɨgi vhava mbɨ thanen nzan nɨɨŋ, nza raa ŋuimŋguigir zav mbui.’ ");
INSERT INTO geb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mbe maaŋ nzuaim, mba ndɨkndɨk vhuuŋ ki mbigi, mbe mbe ŋgarkarav khaŋ mbe nzuai, ‘Fhuvara. Kha vhava mbɨ, ana nza raar ruiv vhɨra nden raar ruigirga tuktɨgi fhuvara. Nde taagi ŋgɨp, vhezi phenan ŋgegɨp, warira suaŋv vhava mbɨ vhezɨrga, ne nzerara.’ ");
INSERT INTO geb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mbe maaŋ mbe suaŋgim, mba pham bigi ga mbui mbigi, mbe taagia vhava mbɨ vhezɨr zav vhezi phenan vegi. Mbe vegim, mba ntigera muuaŋ rɨgi guma, ana zɨgi. Ana zɨgim, mba ndɨkndɨga vhuuŋ ki mbigi, mbe ana phorgap phena vhen vergap, ana phorga ana mba muuaŋ rɨgi shama bakɨme piigi. Mbe vergim, mba gumgi mba phena thɨma puigi. ");
INSERT INTO geb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Mbe vergim, zumgum, mba pham bigi ga mbui meeŋ thɨgi mbigir ŋkaa, mbe zav khaŋ nzuai, ‘Guman rum, guman rum, ndu zɨv nza ndim thɨma fhɨrik!’ ");
INSERT INTO geb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mbe maaŋ nzuaim, ana mbe ŋgarkarav khaŋ mbe nzuai, ‘Gu guigira nde nzuai, gu nde kaŋgi fhuvara.’ ” ");
INSERT INTO geb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Zisas nen mbe suaŋgiap, khaŋ mbe nzuai, “Nde maaŋ muuŋgip, nde tuituigira wari ganɨri. Nde wari wo Bakɨme zɨrga tuk gu raa kaŋgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Fhe Bakɨme won gumgi gu mbigi ganɨrim, mbe Hevenan ana piin kɨrga tɨv, ana kha fara muuŋgi. Guma mbe, ana won ŋgu thav saman harigi ŋgun ŋgɨr za mbui. Ana ŋgɨr zav, ana mbara won ŋaara gumgir kamgim mbe ana han zim, ana wo bigir mbe farve khɨngi, mbe ana bigi ganɨnga. ");
INSERT INTO geb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ana won ŋaara gumgi, ana mben tɨvi gum mben ŋkasŋka, ana za nta gangiap, ana won ŋkɨɨa shama mbov mbe ndɨɨi. Ana mbevi, ana 5,000 kinan ana nɨɨŋgiap, mbevi, ana 2,000 kinan ana nɨɨŋgiap, ana mbevi, ana 1,000 kinan ana nɨɨŋgi. Ana maaŋ mbe muuŋgiap, mbe thav vugi. ");
INSERT INTO geb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ana mbe thav vugim, mba 5,000 ndigi guma ana hɨgap, mba 5,000 kinan shɨga mbuim, ntan bɨɨŋbɨɨŋ ŋkɨɨa khaŋ muuŋgia hɨgi, 5,000. Ana ntan shɨga mbuav harigi 5,000 kina ndigi. ");
INSERT INTO geb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mba 2,000 kina ndigi guma vhɨra, ana mba 2,000 kinan shɨga mbuav ana vhɨra harigi 2,000 kina ndigi. ");
INSERT INTO geb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mani won ŋkɨɨan shɨga mbui. Mba 1,000 kina ndigi guma maaŋ muuŋgi fhuvara. Ana mba 1,000 kina ndiga vov, mbok korgiap, won guma bakɨmen ŋkɨɨa ndi mbok khɨngiap, nta vhagi. ");
INSERT INTO geb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Mbe maaŋ muuŋgiap kim, tuga mpeeŋra vhɨzgim, mben guma bakɨme taagia zɨgi. Ana zɨgap, ana mba mbe nɨɨŋgi ŋkɨɨa suaŋv mbe phorgɨ suaŋ za mbui. ");
INSERT INTO geb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ana mbe suaŋ za mbuim, mba 5,000 kina ndigi guma, ana mba ana nɨɨŋgi 5,000 kina ndigap, vhɨra harigi 5,000 kina phorga ndiga zav khaŋ ana nzuai, ‘Guma bakɨme, ndu 5,000 kinan na nɨɨŋgi. Ndu ganɨ, gu mba 5,000 kinan shɨga mbuav harigi 5,000 kina ndigi.’ ");
INSERT INTO geb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ana nzuaim, anan guma bakɨme khaŋ ana nzuai, ‘Ndu ŋaara guman vhuuŋ ma, ndu ŋaara vhuuŋra muuŋgi. Ndu tuituigira won ŋaara garav ana muuŋgi. Ndu bigi bisarire, ndu tuituigira nta gari. Maaŋ muuŋgiap, gu ndu vuzvugi, ndu ntigem na bigi vhɨrve ganɨnga. Ndu zɨv na phorgɨv ŋka ndikndigɨrga.’ ");
INSERT INTO geb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Mba 2,000 kina ndigi guma ana vhɨra zi, ana zav khaŋ nzuai, ‘Guma bakɨme, ndu 2,000 kinan na nɨɨŋgi. Ndu ganɨ, gu mba 2,000 kinan shɨga mbuav, harigi 2,000 kina ndigi.’ ");
INSERT INTO geb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ana maaŋ nzuaim, ana guma bakɨme khaŋ ana nzuai, ‘Ndu ŋaara guman vhuuŋ ma, ndu ŋaara vhuuŋra muuŋgi. Ndu tuituigira won ŋaara gari. Ndu bigi bisarire, ndu tuituigira nta gari. Maaŋ muuŋgiap, gu ndu vuzvugi, ndu na bigi vhɨrve ganɨnga. Ndu zɨv na phorgɨp ŋka ndikndigɨrga.’ ");
INSERT INTO geb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Mani vugim, mba 1,000 kina ndigi guma, ana vhɨra zi. Ana zav khaŋ nzuai, ‘Guma Bakɨme, gu kaŋgi, ndu vhav shi guma ma. Ndu harigi gumgi won mɨnin pargi mba, ndu vhɨra nta si guma ma. Ndu harigi nuiana sɨgen guma won mban vhɨgi fuigim, nta thooŋgim, ndu vhɨra nta phorga ndi. ");
INSERT INTO geb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Gu maaŋ muuŋgiap ndun rivgiap, ndun 1,000 kina ndiga vov nuianan mbok korgiap, nta ndu zorgi. Ndu ntɨɨri khare.’ ");
INSERT INTO geb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ana ne nzuaim, ana guma bakɨme, ana ŋgarkarav, khaŋ ana nzuai, ‘Ndu ŋaara guma mbatɨk ma. Ndu vhukvhuga kɨvgi guma ma. Ndu guigira khueŋ kaŋgi, gu harigi gumgi won mɨnin pargim, gu mbe mɨnin mbe mba ndi. Gu vhɨra harigi nuiana sɨgen harigi guma won mba ndim fuigi, gu vhɨra nta ndi. ");
INSERT INTO geb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ndu maaŋ muuŋgiap kaŋgia, ndu ram muuŋgiap, nan ŋkɨɨa ndiav ŋkɨɨa ndia sui phena su thagi? Ndu na ntɨɨri ndi khɨngirim, gu ntige taagi zɨv, gu wantɨɨri ndiv, gu vhɨra ntan bɨɨŋbɨɨŋ ŋkɨɨa phorgɨv ndirga. ");
INSERT INTO geb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Maaŋ muuŋgiap, nde kha guma tɨn kha 1,000 kina ndigip, ntan mbu 10,000 kina ki guman nɨɨŋgiri. ");
INSERT INTO geb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ne khaŋ muuŋgi, guma bigi mbari ki, gu harigi bigi phorgɨv ana nɨɨŋgirga. Guma maaŋ muuŋgia bigi ki fhu, ana mba suirav ki bigɨna bisaneŋ, gu ana tɨn mba bigɨna bisaneŋ ndigirga. ");
INSERT INTO geb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Gu ana tɨn mba bigɨna ndigirga, mba ŋaara guma mbatɨk, nde ana vhararim, ana mba gɨngɨn mbatɨga muuŋgi ŋanen ŋgɨgɨri. Mba ŋanen, mbe nzi mbatɨgar muuŋv wari wo tari ntɨɨri phɨrɨrga.’ ” ");
INSERT INTO geb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Fhe Bakɨmen Guma Guar taagi ŋgui vhɨrve gari guman pana gegɨp won enseri phorgɨp zirɨrga, ana zirɨp ana ŋgui vhɨrve gari guman pan pigi mpirmpirɨk perarga. ");
INSERT INTO geb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ana perarga kha nuianan ki gumgi gu mbigi mbe zam zɨv ana nɨma thivgirga. Mbe zɨv ana nɨma thivgirim, ana nduara mbe ndim, phɨna phunin maanga. Ana mba sipsivi gari gumgi wari wo sipsivi heev, won sipsivi ndiv harigi nderen mbav, memeiŋ ndi harigi nderen mbai, ana mba tɨvar muunga. ");
INSERT INTO geb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ana maaŋ muuŋv, ana sipsivi ndiv won guva haren maaŋv, ana memeiŋ ndi won ŋkɨn haren maanga. ");
INSERT INTO geb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Mba ŋgui vhɨrve gari guman pan won guva haren ki gumgi gu mbigi ana khaŋ mbe suanga, ‘Nde Dara ndɨkndɨga vhuun nden muunga. Ana tɨvar vhuun nden muun za mbui.’ Mba ŋgui vhɨrve gari guman pan khaŋ mbe suanga, ‘Nde zɨv na Dara nde nzuav muuŋgi ŋgu, nde zɨv fharav ana ndigip anan kɨri. ");
INSERT INTO geb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nde khaŋ muuŋgi ne nzuav, gu fhum thɨhegi nde mban na nɨɨŋgi. Gu mbɨ nzuav fhɨr khigim, nde mbɨn na nɨɨŋgi. Gu harigi ŋgu guma ma, gu zim, nde nan kov wari wo phenin vegi. ");
INSERT INTO geb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Gu shaa fhu, nde shaar na nɨɨŋgi. Gu rɨɨim, nde na kirav kegi. Gu phena tɨvanen kim, nde nan kirav kegi.’ ");
INSERT INTO geb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ana maaŋ suanga, mba tɨvir vhuuiaŋ mbui gumgi gu mbigi ana ŋgarkarav khaŋ ana suanga, ‘Guman Rum, nza maaŋgi tugar ndu garim, ndu thɨhegim, nza mban ndu nɨɨŋgi? Nza vhɨra maaŋgi tugar ndu garim, ndu mbɨ nzuav fhɨr khigim, nza mbɨn ndu nɨɨŋgi? ");
INSERT INTO geb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nza vhɨra maaŋgi tugar ndu garim, ndu harigi ŋgu guma fara muuŋgiap zim, nza ndun ko vov wari wo phenin vegi? Nza vhɨra maaŋgi tugar ndu garim ndu shaa fhuv, nza shagir ndu nɨɨŋgi? ");
INSERT INTO geb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nza vhɨra maaŋgi tugar ndu garim, ndu rɨɨv, ndu vhɨra phena tɨvanen kim, nza vov ndu kirav kegi?’ ");
INSERT INTO geb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Mbe maaŋ suanga, mba ŋgui vhɨrve gari guman pan mbe ŋgarkarav khaŋ mbe suanga, ‘Gu guigira nde nzuai, nde mba nan fegi gu ŋgugi mbe zɨri ki fhu, nde ram mbui khesharigi tɨvar vhuun mbe muuŋgi, nde mba tɨvar na mbui.’ ");
INSERT INTO geb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Mba ŋgui vhɨrve gari guman pan maaŋ mbe suaŋgip, mbara khaŋ mba ana ŋkɨn haren ki gumgi gu mbigi ana khaŋ mbe suanga, ‘Nde za vhɨzi gumgi gu mbigi ma. Nde na thav sav, mbu zazera mbara muuŋgiap kav shi vhavar ŋgɨri. Mba vhav mbe Satan gum ana ŋaara gumgi mbe mbe nzuav muuŋgi vhav ma. ");
INSERT INTO geb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nde fhum, gu thɨhegim, nde mban na nɨɨŋgi fhuvara. Ndu gu mbɨ nzuav fhɨr khigim, nde mbɨn na nɨɨŋgi fhu. ");
INSERT INTO geb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Gu harigi ŋgu guma ma, gu zim nde na ndiga wari wo phenin vegi fhu. Gu shaa ga sosuagim, nde shaar nan kurigi fhu. Nde gu rɨɨv ki, gu phena tɨvanen kim, nde zav na gangi fhu.’ ");
INSERT INTO geb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ana maaŋ mbe suanga, mbe vhɨra khaŋ ana suanga, ‘Guman Rum, nza rasɨ tugar ndu garim, ndu thɨhegi, o, ndu mbɨ nzuav fhɨr khigi o, ndu harigi ŋgu guma fara muuŋgiap zi o, ndu shaa ga sosuagi, o, ndu rɨɨi, o, ndu phena tɨvanen kim, nza ndu shashagi?’ ");
INSERT INTO geb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Mbe maaŋ suanga, ana mbe ŋgarkarav khaŋ suanga, ‘Gu guigira nde nzuai, nde mba zɨ ki fhuv gumgi gu mbigi nde tɨvar vhuun mbe muuŋgi fhu, nde vhɨra tɨvar vhuun na muuŋgi fhu.’ ");
INSERT INTO geb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mba gumgi gu mbigi mbe ne suaŋv vheza mbatɨga ndirga, mba vhez khare, mbe zazera mbara muuŋgiap ki vheza ndirga. Mba tɨvar vhuuiŋ muuŋgi gumgi gu mbigi, mbe zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndirga.” ");
INSERT INTO geb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Zisas za mba bunin mbe suaŋgia thugap, khaŋ wo phorga rui gumgi ga nzuai, ");
INSERT INTO geb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nde kaŋgi, ra phunira khar ki, ni vhɨzgirim, Pasova ndɨkndɨgi tuga bakɨme hɨrga. Mba tugar, mbe Fhe Bakɨme Guma Guar ndiv, ana pana gumgi farve khɨngirim, mbe ana ndiv khanarareŋ ga ntorgɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mba tugen, mba Fhe Bakɨme rotu gari gumgir pani gum mba Isrerin gumgir pani, mbe zav Fhe Bakɨme rotu gari guman pana phenan wari fugi. Mba guman pana zɨ khare, Kaiafas. ");
INSERT INTO geb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mbe wari fugap, Zisas guigip, ana suirav ana shogirim, ana rimgirga tuavi ndi garav wari phorga nzuai. ");
INSERT INTO geb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mbe ne nzuav, khaŋ wari ga nzuai, “Nza rotu mbui tuga bakɨmen mba tɨvar muunga fhuvara. Nza mba tugar muunga, kha gumgi gu mbigi nza gangip, ne suaŋv vhegɨp ntara bakɨme khavgirga.” ");
INSERT INTO geb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Zisas Betanin Saimon phenan ki. Saimon, ana fhum ŋkari gu fari goreri rɨmrɨm kegi. ");
INSERT INTO geb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ana Saimon phenan kim, mbiga mbe arabasta kɨman muuŋgi nda ndɨga vhuuŋ hi mporiiŋ anan ki, ana mba ndiga zi, mba mporiin vhez guigira vun ndagi. Ana mba mporiiŋ ndiga zav, Zisas mba pav kim, ana mba mporiiŋ siav Zisas pana suaŋv, ana hɨvi. ");
INSERT INTO geb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ana mba tɨva mbuim, mba Zisas phorga rui gumgi ana gangiap ndav shigi. Mbe ndav shigap khaŋ nzuai, “Ana thaŋ nzuav fhura mbu mporiiŋ vhɨzi? ");
INSERT INTO geb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nza mba mporiiŋ ndi mbav kɨm fɨga bakɨmera ndigap, mba ŋkɨɨar mba bigi sosuagi gumgi gu mbigi ga ndɨɨe.” ");
INSERT INTO geb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mbe mba kameŋ nzuaim, Zisas mbe nzuai kameŋ kaŋgiap khaŋ mbe nzuai, “Nde thaŋ nzuav simtɨgar kha mbiga ndɨɨi? Ana tɨvar vhuuŋra na muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nde mba bigi sosuagi gumgi, mbe zazera nde phorgɨp kɨrga. Gu fhuvara. Gu zazera nde phorgɨ kegɨrga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kha mbik, ana kha mporiiŋ siav, na pana suav, na hɨvi, ana gu mbogar ŋgirɨ za mbuim, ana na khuma hɨvi. ");
INSERT INTO geb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Gu guigira khar nde nzuai, mbe za kha nuianan ŋgɨp, Fhe Bakɨmen buna vhuueŋ bun suanga, mbe vhɨra kha mbik muuŋgi bigeŋ, mbe vhɨra ne bun suanga, mbe vhɨra ana ndɨkndɨgɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mba tugen Zisas phorga rui guma mbe, ana zɨ Zudas Iskariot, ana vov Fhe Bakɨme rotu gari gumgir pani han vugi. ");
INSERT INTO geb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ana mbe han vugap kha nzambarar mbe muuŋgi, “Gu Zisasan nde farve khɨngirim, nde thagɨnan nan nɨɨŋgirie?” Ana maaŋ nzuaim, mbe 30 sirva ŋkɨɨar rarain ana nɨɨŋgi. ");
INSERT INTO geb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mbe mba ŋkɨɨar ana nɨɨŋgim, Zudas mbaram Zisas ndim mbe farve ga surga tuavi ndi gari. ");
INSERT INTO geb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mbe mba vhuui fhup viktuma pi tuga bakɨmen fharigi raar, Zisas phorga rui gumgi zav khaŋ ana nzuai, “Ndu vuzvugi, nza maam bigi bevahegɨrim, ndu mba Pasova shama bakɨme mbar mbɨrie?” ");
INSERT INTO geb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mbe maaŋ nzuaim, Zisas guma mbe bun mbe nzuav khaŋ nzuai, “Nde ŋgɨp, ŋgu bakɨme vhen ŋgirɨp, kha guma nde ana han ŋgɨp khaŋ ana suaŋri, ‘Guman Rum khaŋ nzuai, Nan tuk han mbarigi. Gu wo phorga rui gumgir kov nza ndu phenan Pasova shaman mbɨr za mbui.’ ” ");
INSERT INTO geb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ana maaŋ mbe suaŋgim, ana phorga rui gumgi, mbe ana suaŋgi kameŋ zɨn vugi. Mbe ne zɨn vugap, mba mba bevahegi. ");
INSERT INTO geb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mbe mba bigi bevahegim, Zisas ŋkotugun ana wo phorga rui 12 thɨgi gumgir kov, mbe vov, mba pi kaa ga piigi. ");
INSERT INTO geb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mbe pav kav, ana khaŋ mbe nzuai, “Gu guigira khar nde nzai, nde thera na ndiv, nan pana gumgi farve khɨngirga.” ");
INSERT INTO geb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ana ne nzuaim, ana phorga rui 12 thɨgi gumgi ne mbararagiap, guigira ndavi mben simgi. Mbe bevbevira ana nzav khaŋ ana nzuai, “Guma Bakɨme, ndu na nzuai thi?” ");
INSERT INTO geb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mbe mba nzambarar ana mbuim, ana mbe ŋgarkarav khaŋ mbe nzuai, “Na ndiv nan pana gumgi farve ga surga guma mbera, ana na phorgav wo farve ndi kha thuuaŋ vhui. ");
INSERT INTO geb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Fhe Bakɨme Guma Guar ana rɨmɨnga, ana Fhe Bakɨme buni vhuuiŋ ki gap nera suaŋgi, ana rɨmɨnga. Gu mba Fhe Bakɨme Guma Guara ndiv ana pana gumgi farve khɨngi guma, gu guigira ana kora muuŋgi. Ana niamuuŋ ana tɨ tha kake, nai guigira nzerae.” ");
INSERT INTO geb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mba Zisas ndim ana pana gumgi farve ga sur za mbui guma Zudas, ana kha nzambarar Zisas ga muuŋgi, “Guman Rum, ndu na nzuai thi?” Zisas mbara khaŋ ana nzuai, “Ndu za mbar ne nzuai.” ");
INSERT INTO geb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mbe pav kav, Zisas viktuma mueŋ ndigap, Fhe Bakɨme phorga nzuav ana ndikndigap, mbara mba viktumeŋ phɨrav, wo phorga rui gumgi ga ndɨɨv, khaŋ mbe nzuai, “Nde kha viktumeŋ ndigip nen mbɨ. Khe nan fhava sɨk ma.” ");
INSERT INTO geb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ana maaŋ mbe suaŋgiap, wain mbɨ thama mbe ndigap, ana nzuav Fhe Bakɨme phorga nzuav ana ndikndigap, ana mbe ndɨɨv, khaŋ mbe nzuai, “Nde za khen mbɨri. ");
INSERT INTO geb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Khe na vɨzɨn ma. Fhe Bakɨme fhum nde nzuav suaŋgi vɨzɨn ma. Gu gumgi gu mbigi vhɨrve muuŋgi tɨvi mbatɨgi vhɨzɨ zav ana siasuagi. ");
INSERT INTO geb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Gu nde nzuai, gu wom wain mbegɨrga tuktɨgi fhu. Gu zumgum Dara won gumgi gu mbigi ganɨrim, mbe ana piin kɨrga ŋgun, gu nde phorgɨv mba wain kaman mbɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ana maaŋ mbe suaŋgiap, mbe ŋgava muuŋgiap, mba ŋgu bakɨme thav vov, Oriv mbɨkshɨman ndai. ");
INSERT INTO geb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Zisas khaŋ wo phorga rui gumgi ga nzuai, “Nde ntige kha maan nan hɨrga bigi gangip, nde na khothɨgɨ thav regɨrga. Fhe Bakɨme buni vhuuiŋ ki gap maaŋ nzuai, ‘Gu sipsivi gari guma shogirim, ana rimgirga, mba sipsivi rɨv tamtam ŋgegɨrga.’ ");
INSERT INTO geb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Gu rimgip, taagi khavgirga, gu fharav nde nɨman tɨgɨp Garirin ŋgirgɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita ana ŋgarkarav khaŋ nzuai, “Maaŋ muuŋgip, mba bigeŋ ndun hɨrga, mba harigi ntɨɨri, mba bigeŋ gangip, mbe ndu khothɨgɨ thav regɨrga, gu ndu khothivɨ thav rɨgɨrga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ana maaŋ nzuaim, Zisas khaŋ ana nzuai, “Gu guigira ndu nzuai, ntige kha maaŋra tuar ntigar furga, ndu fhumra na ndi zaahɨ mpuani khegenen muuŋgirga.” ");
INSERT INTO geb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ana maaŋ nzuaim, Pita khaŋ ana nzuai, “Fhuvara, gu ndu phorgɨ rimgirga, gu maaŋ suaŋgip ndu zɨ ndi zaahegɨrga tuktɨgi fhuvara. Zakɨra fhuvara!” Pita ne nzuaim, mba Zisas phorga rui gumgi, mbe za mbara nzuai. ");
INSERT INTO geb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Zisas mba bunin wo phorga rui gumgi ga suaŋgia thugap, mben kov, mbe kha zɨn rɨgi ŋanen vui, Getsemani. Ana mbe kov vugap, khaŋ mbe nzuai, “Nde khara piigip kɨri. Gu ŋgɨp Fhe Bakɨme phorgɨ suanga.” ");
INSERT INTO geb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ana maaŋ mbe suaŋgiap, ana Pita gum Sebedin kamanin kov, mbe vui. Ana mben kov vov, ana ndava vhee guigira simgim, ana wo khɨkhɨm mbararagi, ana khɨkhɨm guigira mbatɨgi. ");
INSERT INTO geb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ana thav khaŋ mbe nzuai, “Na ndava vhee guigira simgim, gu rɨmɨn za bisaŋ khɨnanera. Nde na suaŋv ganɨv khara kɨri.” ");
INSERT INTO geb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ana maaŋ mbe suaŋgiap, ana maneŋ mbe thav shɨva vugap, ana mbara wo fega nɨɨŋ khɨngiap wo khoma ndi nuiana dav, Fhe Bakɨme phorga nzuav khaŋ ana nzuai, “O, Dara, maaŋ muuŋgip harigi tuav the kɨrim, ndu na tɨn kha thama mbɨ ndigiri. Ndu na vuzvuga zɨn ŋgɨ thari. Ndu wo vuzvugara zɨn ŋgɨri.” ");
INSERT INTO geb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Zisas Fhe Bakɨme phorga suaŋgiap, ana taagia vov, wo phorga rui guma phuni khegene garim, mbe kuav ki. Mbe kuav kim, ana kha nzambaren Pita ga muuŋgi, “Ram muuŋgi tɨv khare? Ee, nde na suaŋv ganɨv aua bavira kegɨrga tuktɨgi fhuve? ");
INSERT INTO geb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nde na suaŋv ganɨv, Fhe Bakɨme phorgɨ suaŋv kɨri. Nde muuŋv kɨrim, nden panɨnga bigɨn thueŋ nden hɨrim, nde ne khɨgɨ regɨrga. Gu guigira nde nzuai, nden ndavi vheri bigir muungeŋ vuzvugi, nden fhavi guigira ŋkasŋkagi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ana maaŋ mbe suaŋgiap, ana wom phenatɨtɨgap Fhe Bakɨme phorgɨp suaŋ zav vui. Ana vov khaŋ nzuai, “O, Dara, gu kha thama mbɨ ŋkɨɨarga tuav ki fhu, gu ana mbɨrga. Ndu wo vuzvuga zɨn ŋgɨri.” ");
INSERT INTO geb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ana Fhe Bakɨme phorga suaŋgiap, wom taagia zav wo phorga rui gumgi garim, mbe rɨmgi mben simgim, mbe kuav ki. ");
INSERT INTO geb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ana mbe gangiap, ana wom ruru khegenen vov Fhe Bakɨme phorga nzuai. Ana mba fhum vov Fhe Bakɨme phorga suaŋgi kameŋ, ana nera Fhe Bakɨme nzuai. ");
INSERT INTO geb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ana Fhe Bakɨme phorga suaŋgiap, taagia zav khaŋ wo phorga rui gumgi ga nzuai, “Nde vhɨksuav kuavra kire? Nde mbarara, tuk hɨgi. Mbe Fhe Bakɨme Guma Guara ndiv tɨvi mbatɨgi ga mbui gumgir farve khɨngi. ");
INSERT INTO geb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nde khavgip, nza ŋgɨrga. Nde ganɨ, na ndiv mbe farve ga sui guma, ana zav han mbai.” ");
INSERT INTO geb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Zisas mba bunin mbe nzuavra kim, Zudas, ana mba 12 thɨgi gumgi phorga rui guma mbe, ana zi. Ana zim, gumgi vhɨrvera ana phorga zi. Mbe zav, mbe ntari ga mbui kozi gu fani phorga ndigap wari zi. Mba zi gumgi, Fhe Bakɨme rotu gari gumgir pani gu mba gumgi gu mbigi gari gumgir pani mbe sarigim, mbe zi. ");
INSERT INTO geb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mba Zisas ndiv ana pana gumgi farve ga sur zav nzuai guma, ana kha khesharigi tɨvar mbe khɨvɨr za nzuai, “Gu guma the viavɨv ana khoman panɨnga, mba guma, ana Zisas ma. Nde ana suirari!” ");
INSERT INTO geb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ana nen mbe suaŋgiap, ana vhemkora zav Zisas han zav khaŋ ana nzuai, “Maana vhuuŋ, Guman Rum.” Ana nen ana nzuav, za ana viavav, ana khoman mpari. ");
INSERT INTO geb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ana maaŋ mbuim, Zisas khaŋ ana nzuai, “Nan kɨvntok, ndu mba muun za zɨgi bigeŋ, ndu vhemkora nen muuŋ.” Ana maaŋ ana mbuim, mba gumgi hegap Zisasan suirigi. ");
INSERT INTO geb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mbe maaŋ Zisas ga mbuim, Zisas han ki guma mbe, ana hɨgap wo ntari ga mbui kos suirav, ana sigi. Ana won kos sigap, Fhe Bakɨme rotu gari guman panan ŋaara guma, ana ana khuara mueŋ shogi, ana thugi, ana nɨɨeŋ rɨgi. ");
INSERT INTO geb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Zisas mbaram khaŋ ana nzuai, “Ndu wo ntari ga mbui kos ndi taagip ana nderar rugɨri. Mba ntari ga mbui kozin ntari ga mbui gumgi, mba ntari ga mbui kozira mben farfagirga. ");
INSERT INTO geb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ndu khueŋ kaŋgi fhuve? Gu won Ndia ga suangeŋ tuktɨgi, gu vuzvugirga, gu ana suaŋrim, ana won enseri vhɨrve guarira sararim, mbe zɨv nan kurarga. Mben vhɨrve guigira mba 12 thɨgi ntar ga mbui gumgir phɨni vhɨrve guarira kambarigi. ");
INSERT INTO geb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Gu maaŋ muuŋgirga Fhe Bakɨmen buni vhuuiŋ ki gavar ki kameŋ ne guigira mba tegɨrga fhu. Fhe Bakɨmen buni vhuuiŋ ki gap khaŋ nzuai, kha bigi nan hɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Zisas mba tugera khaŋ mba gumgi ga nzuai, “Nde won ntari ga mbui kozi gu fani ndigap, ntari ga mbuav kɨɨi guman suigɨr za mbui tɨva muuŋgiap zav nan suigɨr zav zegire? Gu zazera rari tugɨratɨgap Fhe Bakɨme phena bɨna vhen pigap Fhe Bakɨme buni vhuuin gumgi gu mbigi khɨvav mbe nzuai. Nde mba tugir nan suigɨ thagi. ");
INSERT INTO geb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nde mba tugar thagi, nde ntige khar mbui ne, ne Fhe Bakɨme kamthooŋ gumgi fhum khergi buneŋra zɨn vugap khar hi.” Mbe maaŋ Zisas ga mbuim, ana phorga rui gumgi, mbe zam ana thav regi. ");
INSERT INTO geb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mba gumgi Zisas suirav, ana ndiga Fhe Bakɨme rotu gari guman pan Kaiafas phenan vegi. Mbe vov garim, Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi gu mben gumgir pani, mbe wari fugap ki. ");
INSERT INTO geb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mbe Zisas ndiga vuim, Pita maneŋ samra kav mbe zɨn vui. Ana mbe zɨn vov, mba Fhe Bakɨme rotu gari guman pana phena bɨna vhen verav, mba gɨɨtɨvi phorga perav ki. Ana Zisasan hɨrga bigeŋ ganɨ zav vugap ki. ");
INSERT INTO geb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ana kav, Fhe Bakɨme rotu gari gumgir pani gu mben buaadegi gumgi, mbe nzuav gari, mbe zɨv Zisas ga shɨshɨgɨp, ana muuŋgi tɨvi bun suaŋrim, mbe ana muuŋgi tɨva mbatɨga thueŋ gangip, ne suaŋ ana shogirim, ana rimgir zav mbui. ");
INSERT INTO geb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mbe ne nzuav, gumgi vhɨrvera zav fhura ana shɨshɨga bunin ana sav ana nzuai. Mbe ana guigira muuŋgi tɨva mbatɨga thueŋ gangi fhuvara. Mbe ne gangip, ne suaŋv ana shogɨrim, ana rɨmɨnga. Mbe ana muuŋgi tɨva mbatɨga thueŋ gangi fhu. Mbe fhura mba bunin ana nzuav kim, guma phunini zumgum zi. ");
INSERT INTO geb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Mani zav khaŋ nzuai, “Mba guma fhum khaŋ suaŋgi, ‘Gu Fhe Bakɨme Phen, gu ana phɨrgip, gu ra phuni khegenera taagip ana muuŋgirim, ana thɨgɨrga.’ ” ");
INSERT INTO geb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mani ne nzuaim, Fhe Bakɨmen rotu gari guman pan khavgia thɨgap, Zisasan nzarigi, “Ndu buna thueŋ ŋgarka thagire? Mbe khar ram muuŋgi khesharigi bunin ndu sav ndu nzuai?” ");
INSERT INTO geb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ana maaŋ Zisas ga nzuaim, Zisas buna thueŋ nzuai fhuvara. Ana fhura kim, Fhe Bakɨme rotu gari guman pan khaŋ ana nzuai, “Gu zazera mbara muuŋgiap ki Fhe Bakɨme zɨ zitav ndu nzuai, ndu ntigem khaŋ suaŋri, kha vun ki guma na kaŋgi guigira. Ndu Fhe Bakɨme taagia wo gumgi gu mbigi ndir zav suaŋgiap sarigi gumaeŋ? Ndu Fhe Bakɨmen Kam o, fhu?” ");
INSERT INTO geb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ana maaŋ nzuaim, Zisas khaŋ ana nzuai, “Ndu za ne suaŋgi. Gu maaŋ muuŋgiap ndu nzuai, nde zumgum Fhe Bakɨme Guma Guara ganɨrim, ana za kha bigi kharav ŋkasŋka bakɨme ki Fhe Bakɨmen guva haren perarga. Ana perav, kegɨv, zumgum Hevenan buiva hurige phorgɨp zirɨrga.” ");
INSERT INTO geb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ana ne suaŋgim, Fhe Bakɨmen rotu gari guman pan mba kameŋ mbararagiap, ŋgava mbatɨga muuŋgiap, nduara won shagi suigap, nta karasuegap, khaŋ nzuai, “Ana Fhe Bakɨme nzɨɨi. Nza wom thaŋ suaŋv harigi gumgir kamɨrim, mbe zɨv kha guma muuŋgi tɨvi mbatɨgi bun suaŋrie? Fhuvara. Nde ntigera mbararagim, ana Fhe Bakɨme sɨɨŋgi. ");
INSERT INTO geb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nde ndɨkndɨgi, nza ram ana muuŋrie?” Mbe ana ŋgarkarav khaŋ nzuai, “Ana bigɨna mbatɨgeŋ muuŋgi, ana rɨmɨnga.” ");
INSERT INTO geb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mbe ne nzuav Zisas khoma parav, ana shogi. Mbe mbari hegap, ana kuruni phɨri. ");
INSERT INTO geb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Mbe ana kuruni phɨrav khaŋ ana nzuai, “Ndu Fhe Bakɨme taagi kha nuianan ki gumgi gu mbigi ndiv zav farasarigi guma. Ndu khar nza suaŋ, the khar ndu shogi?” ");
INSERT INTO geb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita mba phena bɨna vhen hin perav kim, mba phenan ŋaara mbiga mbe ana han zav, khaŋ nzuai, “Ndu vhɨra Gariri guma Zisas phorga kegi.” ");
INSERT INTO geb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ana maaŋ nzuaim, Pita khaŋ nzuai, “Fhuvara.” Ana ne nzuav za mba gumgi nɨman khaŋ nzuai, “Gu ndu nzuai buneŋ kaŋgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ana ne suaŋgiap, mbara khavgia vov, mba bɨna thɨmkamanin ki phenan vui. Ana vuim, harigi ŋaara mbik ana gangiap, khaŋ maaŋ ki gumgi gu mbigi ga nzuai, “Kha guma, ana vhɨra mba Nasaret guma Zisas phorga kegi.” ");
INSERT INTO geb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita wom wo ndi zaahegap khaŋ nzuai, “Guigi guarara, kha vu guma ma, gu mba guma kaŋgi fhuvara!” ");
INSERT INTO geb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ana maaŋ suaŋgim, tuga tɨvaneŋra, maaŋ ana han thivgia ki gumgi mbari, mbe zav khaŋ ana nzuai, “Guigira, ndu mbe guma mbe ma. Nza ndun suambara mbararagiap, nza ndu kaŋgi.” ");
INSERT INTO geb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mbe maaŋ ana nzuai, Pita thav kama havharara khaŋ nzuai, “Guigi guarara, kha vun ki guma na kaŋgi, gu mba guma kaŋgi fhuvara. Gu guigirim, Fhe Bakɨme mbar nan farfa.” Ana ne nzuavra thagim, tuar vhemkora furigi. ");
INSERT INTO geb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tuar furigim, Pita mba Zisas suaŋgi kameŋ ndɨrigi. Zisas fhum khaŋ ana suaŋgi, “Tuar ntigar furga, ndu fhumra na ndi zaahɨ mpuani khegenen muuŋgirga.” Pita nai ndɨrga, thav kɨrar hɨgap, nzi mbatɨga mbui. ");
INSERT INTO geb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mba maan vov mɨn thugim, mba Fhe Bakɨme rotu gari gumgir pani gu mben gumgir ruu, mbe Zisas shogirim, ana rɨmɨn za nzuai. ");
INSERT INTO geb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mbe maaŋ ana suaŋgiap, mbe zumgum mpiiŋ ndigap, ana kegap, ana ndigap, mbe won guman pana vhari Pairat farve khɨngi. ");
INSERT INTO geb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Zudas, ana Zisas ndim ana pana gumgi farve khɨngi guma, ana Zisas garim, mbe ana nzuav nzuav, guigira ana mbevigim, ana vergim, mbe simtɨgar ana ndɨɨi. Ana mba tɨva gangia thav wom ndap dorgav mba Fhe Bakɨme rotu gari gumgir pani gu mben gumgir ruu ana nɨɨŋgi 30 thɨgi sirva fɨgiveiŋ, ana taagia nta ndiga mbe ndi vugi. ");
INSERT INTO geb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ana vov khaŋ nzuai, “Gu tɨva mbatɨga muuŋgi. Gu nde farve khɨngi guma, ana tɨva mbatɨga thueŋ muuŋgi fhuvara. Nde ana shogirim, ana rimgirga.” Ana ne nzuaim, mbe ana ŋgarkarav khaŋ nzuai, “Ne nza bigɨn fhuvara. Ne ndun simtɨgeŋ ma.” ");
INSERT INTO geb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mbe maaŋ Zudas ga nzuaim, Zudas mbaram mba ŋkɨɨa fuav Fhe Bakɨme Phena vhee suegap, mbara vov nduara won fhɨrar fav, wo ndi ntorgap rimgi. ");
INSERT INTO geb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ana mba ŋkɨɨa fuasuegim, mba Fhe Bakɨmen rotu gari gumgir pani mba ŋkɨɨa ndigap khaŋ nzuai, “Khe guma rɨmɨn zav ana nzuav shama muuŋgi ŋkɨɨa ma. Nza nta ndiv Fhe Bakɨmen phena ŋkɨɨa phorgɨ surga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mbe maaŋ suaŋgiap, kama shogiap, mba ŋkɨɨar guma nuianan ndari muunga nuiana sɨgeŋ ga vhezgi. Mbe vhɨra khaŋ nzuai, mba nuiana sɨgeŋ vhɨra, mbe saman kega zegi gumgi mbe vhɨzɨrga, mbe mbe ndi mba nuiana sɨgen mbogir rɨgirga. Maaŋ muuŋgiap, mba nuiana sɨgeŋ mbe kha zɨn ne ga tɨgi, Vɨzɨn Ki Nuianeŋ. ");
INSERT INTO geb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mbe ntigem mba zɨra mba nuianen kaai. ");
INSERT INTO geb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Maaŋ muuŋgiap, fhum Fhe Bakɨmen kamthooŋ guma Zeremaia suaŋgi kameŋ ne guigira mba tegi. Zeremaia fhum khaŋ suaŋgi, “Mbe 30 ŋkɨɨar fɨgiveiŋ ndigi. Mbe Isreriŋ mba ŋkɨɨar fɨgiven mba guma ga nzuav vhezgi. ");
INSERT INTO geb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Mbe mba ŋkɨɨar fɨgir, nuiana ndari ga mbui guma ndiv nuiana sɨgeŋ ga vhezgi. Guma Bakɨme, ana mba kameŋra na suaŋgi.” ");
INSERT INTO geb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mbe Zisas ndiga vov ŋgui gari guman pana vhari Pairat nɨman fagim, ana Pairat nɨman thɨgim, Pairat kha nzambarar ana muuŋgi, “Ndu Zudain ŋgui vhɨrve gari guman pan e?” Ana mba nzambarar Zisas ga muuŋgim, Zisas khaŋ nzuai, “Ndu za mbar ne nzuai.” ");
INSERT INTO geb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ana ne nzuaim, mba Fhe Bakɨmen rotu gari gumgir pani gum mben gumgir ruu, mbe bunin vhɨrver Zisas ga sav ana nzuai. Mbe mba bunin ana sav ana nzuaim, ana buna thuen mbe ŋgarkai fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Maaŋ muuŋgiap, Pairat wom ana nzav khaŋ ana nzuai, “Ndu mbe khar ndu sav ndu nzuai buni, ndu nta mbararagi fhuv thi?” ");
INSERT INTO geb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pairat ne Zisas ga nzuaim, Zisas buna thuen ana fagi fhuvara. Maaŋ muuŋgiap, Pairat ŋgava mbatɨga muuŋgiap ndɨkndɨgi vhɨrve ga mbui. ");
INSERT INTO geb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mbe zazera mpari tugɨratɨgav Pasova shama pi rotu ga mbui tuga bakɨmen, ŋgui gari guman pana vhari kha tɨva mbui. Ana bɨnan ki guma the fhɨrgirim, ana bɨna thav kɨrar hɨgɨp, ŋgɨrga. Mbe gumgi gu mbigi, mbe nduarira mba guma zitarga, Pairat mba guma fhɨrgirim, ana kɨrar hɨgɨp mben han ŋgɨrga. ");
INSERT INTO geb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mba tugen guma mbatɨga guarara ana bɨnan ki, mba gumgi za ana kaŋgi, ana zɨ Barabas. ");
INSERT INTO geb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mba gumgi gu mbigi mbe za zav wari fugim, Pairat kha nzambaren mbe muuŋgi, “Nde vuzvugi, gu the fhɨrgirim, ana nde han ŋgɨrie? Gu Barabas fhɨrgirim, ana nde han ŋgɨrga o, gu mbe khaŋ nzuai guma Fhe Bakɨme sarigi guma Zisas, gu ana fhɨrgirim, ana nde han ŋgɨrga?” ");
INSERT INTO geb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pairat maaŋ mbe nzuai ne khaŋ muuŋgi. Ana mbe kaŋgi, mbe fhura Zisas ga nzuav ndav shigap ana nzuav suan zav ana ndiga zɨgi. ");
INSERT INTO geb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pairat vhɨra, ana buni mbararagi guma pigi mpirmpirɨga perav kim, anan muuŋ ana ndi kama ndi mbav khaŋ ana nzuai, “Ndu mba tɨvir vhuuiaŋ mbui guma, ndu bigɨn thuen ana muuŋ thari. Gu maan rɨman ana gangiap, gu guigira simgi.” ");
INSERT INTO geb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pairat ne mbararagiap kim, mba Fhe Bakɨme rotu gari gumgir pani mben gumgir ruu, mbe mba gumgi gu mbigi ndavi khavav mbe mbui. Mbe Pairatan kamɨv ana suaŋrim, ana Barabas fhɨrgirim, ana ŋgɨrim, ana Zisas shogirim, ana rimgirga. ");
INSERT INTO geb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mbe mbe ndavi khavav mbe nzuav kim, ŋgui gari guman pana vhari wom kha nzambaren mbe muuŋgi, “Nde vuzvugi, gu kha gumani rɨgar the fhɨrgirim, ana ŋgɨrie?” Ana mba nzambaren mbe muuŋgi, mba gumgi gu mbigi, mbe kaav khaŋ nzuai, “Barabas.” ");
INSERT INTO geb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mbe maaŋ nzuaim, Pairat mben nzarigi, “Nde vuzvugi, gu ram mbe khaŋ nzuai guma Fhe Bakɨme sarigi zɨgi guma Krais, gu ram ana muuŋrie?” Ana ne nzuaim, mbe za kaav khaŋ nzuai, “Ana ndiv khanarareŋ ga tɨgɨp fukfugiri.” ");
INSERT INTO geb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mbe maaŋ nzuaim, Pairat mben nzarigi, “Ramgi ne suaŋv? Ana bigɨn mbatɨk thueŋ muuŋgire?” Ana ne nzuaim, mbe thav khɨrɨv kaav khaŋ nzuai, “Ana ndiv khanarareŋ ga tɨgi fugu.” ");
INSERT INTO geb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Mbe maaŋ nzuaim, Pairat kaŋgi, mbe ana nzuai buneŋ mbararagirga fhuvara. Mbe vhɨra ntara bakɨme khavgirga. Ana maaŋ muuŋgiap mbɨ ndiga zav, mba gumgi gu mbigi nɨmara wo farve ruai. Ana wo farve ruav khaŋ nzuai, “Kha guma rimgirga nan simtɨk fhuvara. Ana nde bigɨnara!” ");
INSERT INTO geb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ana ne nzuaim, mba gumgi gu mbigi, mbe za khaŋ nzuai, “Mba simtɨk mbar nzan kɨv, vhɨra nzan tarir kɨ.” ");
INSERT INTO geb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Maaŋ muuŋgiap, Pairat Barabas fhɨrgim, ana mbe han vui. Ana mbara nzuaim, mba ntari ga mbui gɨɨtɨvi, mbe phivɨga ndigap Zisas khari. Mbe ana khargim, ana mbara Zisas ndi mba ntari ga mbui gɨɨtɨvi farve khɨngim, mbe ana ndigɨ ŋgɨp, khanarareŋ ga tɨgɨp fukfugɨrga. ");
INSERT INTO geb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pairat maaŋ mbe suaŋgim, mba ŋgui gari guman pana vharir ntari ga mbui gɨɨtɨvi, mbe Zisas ndiga vov, ŋgui gari guman pan ŋgari phena vhen vergim, mbe za zav, ana nɨman phok ga vhuigi. ");
INSERT INTO geb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mbe phok ga vhuigap, ana shagi zorgiap, mbara shaa hɨva mbe ndiga zav ana sharigi. ");
INSERT INTO geb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mbe shaa hɨvar ana sharav, mbara tari ki karɨga mbe ndiga zav, ŋgui vhɨrve gari guman pan fi khorsɨga fara muuŋgi khorsɨga muuŋgiap, ana panan fagi. Mbe khorar ana fav vurun sɨgɨma ndiga za, ana guva haren suirigi. Mbe maaŋ ana muuŋgiap, mbara wari wo thɨpani phɨrav, ana nɨman fav, ana nzɨɨav khaŋ ana nzuai, “Raar vhuuŋ, Zudaiŋ ŋguir vhɨrve gari guman pan.” ");
INSERT INTO geb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mbe nen ana nzuav, ana parav, mbe mba ana suirigi vuruna, mbe ana tɨn ana ndigap ana pana shogi. ");
INSERT INTO geb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mbe mba tɨvir ana mbuav, za ana nzɨɨv, ana suaŋgia thugap, mbe mba ana sharigi shaa, mbe ana zorgiap, mbara ana shagir taagia ana shargi. Mbe ana shagir ana shargiap, mbara ana ndi khanarareŋ ga tur zav ana ndiga vui. ");
INSERT INTO geb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mba ntari ga mbui gɨɨtɨvi ana ndiga vo garim, Sairini guma mbe, ana zɨ Saimon, ana zi. Ana zim, mbe ana ndigap ana nzuaim, ana Zisas ndim ana khanarareŋ phufhurav vui. ");
INSERT INTO geb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mbe ana ndiga vov, ŋana muen hɨgi. Mba ŋaneŋ, mbe kha zɨn ne ga rɨgi, Gorgota. Mba zɨn nɨɨeŋ khaŋ nzuai, pana tuam ki ŋaneŋ. ");
INSERT INTO geb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mbe mba ŋanen vugap, mbara wain ndigap, gɨrgɨrgi mporiin wain ndigap Zisas ga ndɨɨi. Mbe ana ana ndɨɨim, ana ana mparav ana thagi. Ana ana mbegi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mba ntari ga mbui gɨɨtɨvi Zisas ndiv khanarareŋ ga tɨgap fugap, ana ndi ntorgi. Mbe ana ndi ntorgap, ana shagi gu bigi, mbe nta ndir zav nta nzuav satu suri. ");
INSERT INTO geb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mbe maaŋ muuŋgiap, mba ŋanen piigiap, ana garav ki. ");
INSERT INTO geb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mbe ana ndi ntorgi khanararen, mbe ana pana shɨn, mbe mba ana nzuav suaŋgi kameŋ, mbe ne khergi. Mbe kha kameŋ khergi, “Khe Zisas, Zudain Ŋgui Vhɨrve Gari Guman Pan Ma.” ");
INSERT INTO geb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","39","Mbe Zisas han gumgi shogap, kɨɨi guma phunini, mbe mani ndi ntorgi. Mbe mbevi ndim, ana guva haren ki khanarareŋ ga ntorgi. Mbe mbevi ndim, anan ŋkɨn haren ki khanarareŋ ga ntorgi. Mbe Zisas ndim ntorgim, mba gumgi gu mbigi mbe zav vov, pani kuaŋkuav ana nzɨɨv ana nzuav wari rui. ");
INSERT INTO geb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Mbe pani kuaŋkuav khaŋ nzuai, “Ndu Fhe Bakɨme Phena phɨrgip taagip ra phuni khegenera taagip ana muuŋgir zav nzuai guma ma. Ndu taagip wora kura. Ndu vhɨra guigira Fhe Bakɨmen Kam kɨv, ndu mba khanarareŋ thav nɨɨn zirɨ.” ");
INSERT INTO geb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mba Fhe Bakɨme rotu gari gumgir pani gu mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi, mben gumgi pani, mbe vhɨra ana nzɨɨv ana nzuav, khaŋ nzuai, ");
INSERT INTO geb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ana harigi gumgir kurkurigi, ana nduara won kurarga tuktɨgi fhuvara. Ana Isrerar Ŋgui Vhɨrve Gari Guman Pan e? Maaŋ muuŋgip, ana mbu khanarareŋ thav nɨɨn zirgɨrga, nza ana khothɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ana Fhe Bakɨme khothɨgap khaŋ nzuai, ‘Gu Fhe Bakɨmen Kam ma.’ Fhe Bakɨme maaŋ muuŋgip ana vuzvugirga, ana ntigem ana kurarga.” ");
INSERT INTO geb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mbe mba ana haa ntorgi kɨɨi gumani, mani vhɨra mba khesharigi bunin ana nzuav, ana nzɨɨv, ana nzuai. ");
INSERT INTO geb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mba raar, ra vov phɨɨŋ ndi maaŋ gɨngi. Maaŋ gɨngiap mbara muuŋgiap kim, ra vera vov phuni khegene ndigi. ");
INSERT INTO geb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ra vera vov phuni khegene ndir za mbuim, Zisas khɨrɨp nzɨɨv, kaav khaŋ nzuai, “Eroi, Eroi, rama sabaktani?” Mba kameŋ nɨɨeŋ khaŋ nzuai, “Na Fhe Bakɨme, na Fhe Bakɨme, ndu thaŋ nzuav na thagi?” ");
INSERT INTO geb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mba ana han thivgia ki gumgi, mba kameŋ mbararagiap khaŋ nzuai, “Ana Eraizan kaai.” ");
INSERT INTO geb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mbe ana mbararagiap, mbe mbevi vhemkora khuafɨ vov, spans fɨga mueŋ ndiga vov wain ga rugi. Mba spans fɨgeŋ wanin ne givigim, ana nen kha phokegap Zisas ga ndɨɨi, ana mba wainan mbɨrga. ");
INSERT INTO geb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ana maaŋ mbuim, mba harigi ntɨɨri, mbe khaŋ nzuai, “Ai, ndu ganɨri, nza ganɨnga. Eraiza zɨv ana kurarga o, fhu?” ");
INSERT INTO geb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mbe maaŋ mbuim, Zisas wom khɨrɨv kaav nzɨɨv, ana vhen ki guma, ana thav kɨrar hɨga vuim, ana rimgi. ");
INSERT INTO geb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ana gor vhɨk ŋgi tugera, mbe mba Fhe Bakɨme Phena vhee ntorgi shaa bakɨme, ana rɨgɨra sharagerɨgi. Ana vun kegap shɨrav za vov, nɨɨŋra kargiap fɨga mpuani ga gegi. Khɨmkhɨk mbuim, mba ŋkɨɨr meeiŋ bakɨvi nta phɨreregi. ");
INSERT INTO geb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ŋkɨɨ phɨrerim, vhɨra mba fhum Fhe Bakɨme khothɨgav vhɨzgi gumgi gu mbigi, mbe mbogi fhomsɨgim, mbe taagia khavgi. ");
INSERT INTO geb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Mbe mba mbogi thav taagia khavgiap kim, Zisas rimgiap taagi khavgiap, mben kov Fhe Bakɨmen ŋgu ŋaara bakɨmen vhen vergi. Mbe verim, gumgi vhɨrve mbe gangi. ");
INSERT INTO geb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mba ntari ga mbui gɨɨtɨvi gari guman pan won gɨɨtɨvir kov, mbe Zisas garav ana han maaŋ kim, khɨmkhɨk mbuim, mba bigi maaŋ muuŋgiap hegim, mbe guigira rivgi. Mbe rivgiap khaŋ nzuai, “Guigi guarara, kha guma, ana Fhe Bakɨmen Kam ma.” ");
INSERT INTO geb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mbe mbigi vhɨrvera, mbe vhɨra maaŋ ki. Mba mbigi, mbe Garirin kegap Zisasan kurkura zav ana phorga ndagi. Mba mbigi, mbe maneŋ samra thivgiap kav, ana gari. ");
INSERT INTO geb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mbe rɨgar, mba mbiga mbe, ana Makdarar mbik Maria ma. Mbevi, ana Maria ma, ana Zems gu Zozevan niamuuŋ ma. Mbevi, ana Sebedin kamanin niamuuŋ ma. ");
INSERT INTO geb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mba ŋkotuguraagen, Arimatea ŋgu bakɨmen ŋkɨɨa vhɨrve ki guma Zosep, ana zi. Ana vhɨra Zisas phorga rui guma mbe ma. ");
INSERT INTO geb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ana vov, Pairat han vugap, Pairatar nzarigi, ana ana khɨrarim, ana Zisas khuma ndirga. Ana Pairatan nzarigim, Pairat mbaram mba ntari ga mbui gɨɨtɨvi ga nzuaim, mbe Zisas khuma daaŋgiap, ana Zosep ga nɨɨŋgi. ");
INSERT INTO geb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Zosep ana khuma ndigap, shaa kaman ana khuma zɨgi. ");
INSERT INTO geb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ana shaar ana khuma zigap, ana ndiga vov, won kɨma khoon muuŋgi mbogar kama tɨgi. Mba kɨma thoon muuŋgi mbok Zosep nzuaim, gumgi mbari ana ndim ana korgi. Zosep ana ndiga vov, ana tɨgap, kɨma bakɨ mbe phokphoga zav, mba mbok thɨni mpɨrigi. Ana maaŋ ana muuŋgiap, vugi. ");
INSERT INTO geb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ana maaŋ ana mbuim, Makdarar mbik Maria gu harigi Maria, mani vhɨra ana mbok thɨma perav kav ana gari. ");
INSERT INTO geb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mbe Sabat tuga bakɨme bigi bevahi raa vhɨzgim, Sabat ra hɨgim, mba Fhe Bakɨmen rotu gari gumgir pani gu Fherasiŋ, mbe Pairat ganɨ za vui. ");
INSERT INTO geb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Mbe vov Pairat garav khaŋ ana nzuai, “Guman rum, nza mba bigi guiguigi guma, ana fhum ŋam kav suaŋgi buna mueŋ, nza ne ndɨrgap ndu han zi. Ana fhum khaŋ suaŋgi, ‘Ra phuni khegene vhɨzgirga, gu taagip khavgirga.’ ");
INSERT INTO geb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Maaŋ muuŋgiap, ndu ntige suaŋrim, mbe guigira bigɨna bakɨ thera ana mbok mpɨrav kɨrim, ra phuni khegene vhɨzgiri. Nde muuŋv kɨrim, ana phorga rui gumgi zɨv, ana khuma kɨmgi, ŋgegɨv khaŋ mba gumgi gu mbigi ga suanga, ‘Ana rimgiap taagia khavgi.’ Maaŋ muuŋgirga, mbe guiguigi bunan kameŋ, ne ana fhum suaŋgi buneŋ kambarav guigira mbatɨgirga.” ");
INSERT INTO geb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Mbe maaŋ nzuaim, Pairat khaŋ mbe nzuai, “Gu ntari ga mbui gɨɨtɨvi thari ga suaŋrim, mbe nde phorgɨ ŋgɨp, ana mbok kera kɨrga. Nde ŋgɨp, mba mbok thɨɨŋ mpɨrarim, ni havharɨrga bigi, nde za ntan muuŋgiri.” ");
INSERT INTO geb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ana maaŋ mbe suaŋgim, mbe vov ana mbok thɨmkamani mpɨrigi. Mbe ni mpɨrav, ana mbok thɨmkamani mpɨrigi kɨma bakɨme, mbe tuituigira ana ndarigi, nambara gangiap, mbe ŋgui gari guman panan zɨn ana tɨgap, ntari ga mbui gɨɨtɨvi mbari ga nzuaim, mbe ana mbok thɨmkamani kera ki. ");
INSERT INTO geb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat raa vhɨzgim, mɨn thugim, harigi ŋaren fharigi raa hɨgim, Makdara mbik Maria, gu harigi Maria, mani Zisas mbok ganɨ za vui. ");
INSERT INTO geb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mani vuim, khɨmkhɨk bakɨme vhemkora hɨgi. Mba khɨmkhɨk mbuim, Fhe Bakɨme enser mbe Hevenan kegap zerav, mba mbok thɨmkamani mpɨrigi kɨma bakɨme phokphoga vov mbur ndarav, ana tɨ perav ki. ");
INSERT INTO geb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ana khom guigira ŋgara garav, buip vhekvhegi vhava ŋaara hura fara muuŋgi. Ana shagi hurgiap, buiva hura gari fara muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mba ntari ga mbui gɨɨtɨvi, mbe ana gangiap, mbe guigira rivgiap, ninɨga mbatɨga mbuav, rimgi gumgi fara muuŋgiap fhura vhɨzav mbarigi. ");
INSERT INTO geb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mbe vhɨza mbarigim, Fhe Bakɨme enser khaŋ mba mbigani ga nzuai, “Ŋko rɨvɨ thari. Gu kaŋgi, ŋko Zisas ga nzuav garav zi. Mba guma, mbe ana ndiv khanarareŋ ga ntorgi. ");
INSERT INTO geb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ana khaŋ ki fhuvara! Ana taagia khavgi, ana fhum ne suaŋgi. Ŋko zɨv, ana rɨga kegi ŋaneŋ ganɨ. ");
INSERT INTO geb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ŋko ne gangip, wani vhemkora ŋgɨp, ana phorga ruigi gumgi ga suaŋv, khaŋ mbe suaŋri, ‘Ana mbok thav taagia kavgi. Ana fharav nde nɨma tɨgav Garirin vui, nde mba ŋanen ana ganɨnga.’ Gu mba kamen nde suan zav zergi.” ");
INSERT INTO geb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mba mbigani ana gangiap, guigira rivgiap, mani wom guigira ndikndiga mbatɨga guarara mbui. Mani ndikndigap, wani vhemkora mba mbok thav, wani khuafɨrav, ana phorga ruigi gumgi ga suan zav vui. ");
INSERT INTO geb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mani vuim, Zisas fhura tuavar manin hɨgap, khaŋ mani ga nzuai, “Manera, mbigani.” Ana maaŋ mani ga nzuaim, mani vov anan han vugap, thɨpanani phɨrgiap, vera vov ana suani suira, mbara ana rotu mbui. ");
INSERT INTO geb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mani ana rotu mbuim, Zisas mbara khaŋ mani ga nzuai, “Ŋko rɨvɨ thari. Ŋko ŋgɨp na phorga ruigi gumgi ga suaŋri. Mbe nan fegi gu ŋgugi ma. Mbe Garirin ŋgirɨri. Mbe maaŋ na ganɨnga.” ");
INSERT INTO geb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mba mbigani tuavar vuavra kim, mba Zisas mbogar kerav kegi ntari ga mbui gɨɨtɨvi mbari, mbe vov ŋgu bakɨmen vhen vergap, mba hegi bigi, mbe za nta bun mba Fhe Bakɨme rotu gari gumgir pani ga suaŋgi. ");
INSERT INTO geb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mba Fhe Bakɨmen rotu gari gumgir pani mba buni mbararagiap, mbe hegap, mba gumgir ruu fugap, mbe kama shogi. Mbe kama shogiap, ŋkɨɨa vhɨrvera mba ntari ga mbui gɨɨtɨvi ga nɨɨŋgi. ");
INSERT INTO geb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Mbe ŋkɨɨa vhɨrver mbe ndɨɨav khaŋ mbe nzuai, “Nde khaŋ suaŋri, ‘Nza maan kuigim, ana phorga ruigi gumgi zav, ana khuma kɨmgia vegi.’ ");
INSERT INTO geb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nde maaŋ suaŋrim, ŋgu gari guman panan vhari ne mbararagip, nde suanga, nza ana phorgɨp suaŋv ne ndi thɨgar mbararga, nde simtɨk kɨrga fhu.” ");
INSERT INTO geb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mbe maaŋ suaŋgim, mba ntari ga mbui gɨɨtɨvi mba ŋkɨɨa ndigap, mbe mba gumgir pani suaŋgi kameŋ zɨn vugi. Mbe ne nzuaim, mba kameŋ za mba Zudar vhee ruigi. Mbe mba suaŋgi kameŋ, mbe Zudaiŋ ne suirigim, ne mbara muuŋgiap kav zav, ntigem kha tugen hɨgi. ");
INSERT INTO geb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mba Zisas phorga ruigi 11 thɨgi ŋaara gumgi, mbe Garirin verav, mbe mba Zisas ŋgirɨ zav suaŋgi mbɨkshɨm, mbe vov ana vergi. ");
INSERT INTO geb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mbe vergap, maaŋ Zisas garav, ana rotu mbui. Mbe ana rotu mbuav, mbe mbari tuituigiap Zisas heegi fhuvara. Mbe ndɨkndɨk phuniaŋ mbui. ");
INSERT INTO geb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Zisas mben han zav khaŋ mbe nzuai, “Fhe Bakɨme za kha Heven gu nuiana ganɨn zav zɨ bakɨme gum ŋkasŋkar na nɨɨŋgi. ");
INSERT INTO geb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Maaŋ muuŋgiap, nde ŋgɨp za kha nuianan ki gumgi ga suaŋrim, mbe na khothɨgɨp na zɨn vui gumgi kɨri. Mbe na khothivɨrim, nde Ndia gum, anan Kam, ana Ŋina Ŋaar, nde mben zɨn ŋkasŋkar panan mbe ruari. ");
INSERT INTO geb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nde mbe ruav, gu mba nde suaŋgi buni, nde za ntan mbe khɨvɨri. Nde mbarara! Gu rari tugɨra tɨgɨp nde phorgɨ kɨv kɨrim, kha tuk vhɨzgirga.”");
INSERT INTO geb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Khe fharav Fhe Bakɨmen Kam Zisas Krais bun nzuai buni vhuuiŋ khare. ");
INSERT INTO geb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Fhum Fhe Bakɨme kha kamen wo kamthooŋ guma Aisaia ga nɨɨŋgi. Ana ne khergim, ne ana gavar ki. Mba kameŋ khare. “Gu wo mpuu guma ga sarari. Ana fharav ŋgɨv ndu suaŋv tuavar muuŋgirga. ");
INSERT INTO geb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Guma the, ana gumgi ki fhuv ŋanen kɨv, kamɨv khaŋ suanga, ‘Nde Guma Bakɨme suaŋv tuavi khɨrɨv nta ndi thɨgɨra maaŋri.’ ” ");
INSERT INTO geb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Maaŋ muuŋgiap, Zon zav gumgi ki fhuv ŋanen kav, gumgi ruai. Ana mbe ruav, Fhe Bakɨme buni vhuuin mbe nzuav khaŋ nzuai, “Nde ndavi domdorɨrim, gu nde ruarim, Fhe Bakɨme nde fhum muuŋgi tɨvi mbatɨgi vhɨzgirga.” ");
INSERT INTO geb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ana mba kamen mbe nzuaim, mba Zudian fhain ki ŋgui gum mba Zerusareman ki gumgi gu mbigi, mbe zam ana han zav, wari wo muuŋgi tɨvi mbatɨgi bun ana nzuaim, ana Zordan mbɨn mbe ruai. ");
INSERT INTO geb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Zon Gumgi Ruai Guma, ana sɨga rɨginan muuŋgi shagi shari. Mba sɨga zɨ Kemor. Ana nta sharav, sɨga nderar muuŋgi shaa fɨgeŋ rɨkava fara muuŋgi. Ana nen wo vhaa rɨgi. Ana mba shagi sharav, kuambogi gum gumgi reri phooŋ pi. ");
INSERT INTO geb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ana nzuai kameŋ khare. “Na zɨn zi guma, ana ŋkasŋka guigira na kambarigi. Gu ana fara muuŋgi fhu, gu vhɨra ana ŋkarve nɨman ŋguav, ana ŋgari sharive mpiiŋ fhɨrgirga tuktɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Gu mbɨn nde ruai, ana zumgum Fhe Bakɨmen Ŋina Ŋaarar nde ruarga.” ");
INSERT INTO geb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mba tugen, Zisas Garirin ŋgu Nasaretan kegap, Zon han zim, Zon Zordan mbɨn ana ruai. ");
INSERT INTO geb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Zisas mbɨn vhen kegap kɨrar havra thav gari, Heven fhogim, Fhe Bakɨme Ŋina Ŋaar fhomne fara muuŋgiap gegap, zerap, anan han zeri. ");
INSERT INTO geb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Fhe Bakɨme Hevenan kav khaŋ ana nzuai, “Ndu nan Kam ma! Gu guigira ndu vuzvugiap, ndu nzuav ndikndigi.” ");
INSERT INTO geb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Fhe Bakɨme maam ana suaŋgim, mba Fhe Bakɨmen Ŋina Ŋaar ana sarigi, ana gumgi ki fhuv ŋanen vugi. ");
INSERT INTO geb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ana vugap, 40 rari gum mbarir mba ŋanen kim, Satan anan mpari. Ana mba ruaŋruaŋgi sɨgi rɨgar ki. Fhe Bakɨme enseri ana gari. ");
INSERT INTO geb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mbe zumgum Zon Gumgi Ruai Guma ndi bɨna khɨngi, Zisas vov Garirin vugap, Fhe Bakɨme buni vhuuiŋ bun mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ana mbe nzuav khaŋ nzuai, “Tuk hɨgi, Fhe Bakɨme wo gumgi gu mbigi ganɨnga, mbe ana piin kɨrga tuk han mbarigi. Nde ndavi domdorɨv Fhe Bakɨme buni vhuuiŋ khothivɨri.” ");
INSERT INTO geb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Zisas mba bunin mbe suaŋgiap, Gariri mbɨ gaa ga tɨga vui. Ana vuav Saimon won ŋguga Andrun kov, ana mani gari, mani wo vhaaŋ ndi sui. Mani mbagar shɨga mbui gumani ma. ");
INSERT INTO geb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Zisas khaŋ mani ga nzuai, “Ŋko zɨv na phorgɨv nza ŋgɨrga. Gu ŋko suaŋri, ŋko mbaga ndi tɨvar ŋko gumgi ndirga.” ");
INSERT INTO geb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mani ne mbararara thav, wani wo vhaaiŋ thav ana phorga vui. ");
INSERT INTO geb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ana maaŋ Saimon gu Andru ga suaŋgiap, maam maneŋ sɨga mpeeŋgera vugap, Zebedin kama Zems, ana won ŋguga Zonan kov, ana mani garim, mani wo keman kav wani wo vhaaiŋ thɨthɨm rɨgi. ");
INSERT INTO geb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ana mani garavra, manin kamgi. Mani fhura mba bigi thav, wo ndia Zebedi gum ana ŋaara gumgi thagi. Mbe mba keman kim, mani ana phorga vui. ");
INSERT INTO geb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mbe vov Kaperneaman vegi. Mbe vegap, Sabat havra thagi, Zisas Fhe Bakɨme buni mbararagi phen vhen vergap, mba phena vhen ki gumgi gu mbigi, ana Fhe Bakɨme buni vhuuin mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ana mbe nzuaim, mba gumgi gu mbigi ana buni mbararav, ŋgava mbatɨga mbui. Ana mbe khɨvav mbe nzuai buni, nta ŋkasŋka ki guma mbe khɨvav, mbe nzuai buni fara muuŋgi. Ana mbe nzuai buni, mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi, mbe khɨvav mbe nzuai buni fara muuŋgi fhu. ");
INSERT INTO geb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ana mba bunin mbe nzuav kim, ŋina mbatɨk vhen ndagi guma mbe zav, mba Fhe Bakɨme buni mbararagi phena vhen veravra nzɨɨi. ");
INSERT INTO geb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ana nzɨɨv khaŋ nzuai, “Ndu ram nzan muun za mbui, Nasaret guma Zisas? Ndu nzan farfa za zɨgire? Gu ndu kaŋgi. Ndu Fhe Bakɨmen Guma Ŋaar ma!” ");
INSERT INTO geb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Zisas mbaram kama havharan khaŋ mba ŋina mbatɨga nzuai, “Ndu thɨni mpɨrav, mba guma thav kɨrar hɨgɨ!” ");
INSERT INTO geb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mba ŋina mbatɨk Zisas mbararagiap, mba guma suirav, ana nɨɨkuav, nzɨɨv, mba guma thav kɨrar hɨgi. ");
INSERT INTO geb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mba gumgi gu mbigi mba bigeŋ gangiap, guigira ŋgava mbatɨga muuŋgiap, tamtam warir nzai, “Khe ram muuŋgi bigeŋ? Khe nza nzuai tɨv, ne tɨvar kameŋ ma. Ana ŋkasŋka phorga ki bunin nza nzuai. Ana vhɨra kama havharar ŋiniŋgi mbatɨgi ga nzuaim, nta ana kama zɨn vui.” ");
INSERT INTO geb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mbe ana muuŋgi bigeŋ gangiap, ana bun nzuai kameŋ vhemkora za mba Gariri fhaiŋ ga ruigi. ");
INSERT INTO geb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mbe mba Fhe Bakɨme buni mbararagi phena thav kɨrar hegap, mbaram maaŋ thav Zems gu Zon, phorgav Saimon gum Andru phenan vegi. ");
INSERT INTO geb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon samuuŋ fhav gurgurgiap, rɨɨv kaar kim, mbe ana bun Zisas ga nzuai. ");
INSERT INTO geb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Mbe ana bun Zisas ga suaŋgim, ana mbaram ana han vov, ana hara suirav, ana ragi. Mba rɨmrɨm ana thav, mbar vugi. Ana khavgia mban mbe ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mba raar ra verav vhɨzim, mba gumgi gu mbigi rɨɨi gumgi gum ŋiniŋgi mbatɨgi vherir ndagi gumgi, mbe za mbe ndiav Zisas han zi. ");
INSERT INTO geb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mba ŋgun ki gumgi gu mbigi za zav, mba phena thɨmkamani phok thɨgi. ");
INSERT INTO geb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Zisas mbarkɨrga rɨmrɨɨ vhɨrve ki gumgi gu mbigi vhɨrver kurkurav, mbe rɨmrɨɨ ga mbuim, nta vhɨzi. Ana vhɨra ŋiniŋgi mbatɨgi vhen ndagi gumgi vhɨrve tɨn ŋiniŋgi mbatɨgi ga vharvharigim, nta mbe thav, kɨrar hi. Mba ŋiniŋgi mbatɨgi ana kaŋgi. Ana maaŋ muuŋgiap kama hɨv buni suanga nen mba ŋiniŋgi mbatɨgi thɨvigi. ");
INSERT INTO geb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mba mɨtimanera mɨn ntigar gorɨrga, maaŋ gɨngira kim, Zisas khavgiav, mba phena thav, mɨnakɨnathɨgi ŋanen vugap, Fhe Bakɨme phorga nzuai. ");
INSERT INTO geb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ana vugim, Saimon wo kɨvntogir kov ana nzuav gara rui. ");
INSERT INTO geb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mbe vov ana gangiap, khaŋ ana nzuai, “Kha gumgi gu mbigi zam ndu nzuav gari!” ");
INSERT INTO geb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Zisas mbaram mbe ŋgarkarav khaŋ mbe nzuai, “Nza harigi ŋanen kha hara ki ŋguir ŋgɨrga. Gu vhɨra maaŋ Fhe Bakɨme bunin vhɨra mbe suanga. Gu ne nzuav zɨgi.” ");
INSERT INTO geb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ana ne suaŋgiap, mbaram za mba Gariri fhaiŋ ga ruav, mbe Fhe Bakɨme buni mbararagi phenin Fhe Bakɨme bunin mbe nzuav, gumgi tɨn ŋiniŋgi mbatɨgi ga vharvharigi. ");
INSERT INTO geb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Zisas maaŋ mbuav kim, ŋkari goreri rɨmrɨm ki guma mbe ana han zav, wo thɨpanani phɨrgiap, ana nɨman fav, khaŋ tɨgap ana nzuai, “Ndu vuzvuk ma. Ndu vuzvugip ndu nan kurarim, na fhav taagi nzerarga.” ");
INSERT INTO geb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Zisas ne mbararagiap, guigira ana kora muuŋgiap, mbaram wo hara ŋgav, mba guma suirav khaŋ ana nzuai, “Gu ne vuzvugi. Ndu fhav taagi nzerari!” ");
INSERT INTO geb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Zisas ne nzuavra thagim, mba ŋkari goreri rɨmrɨm fhura mba guma thav mbar vugi, mba guma fhav taagia nzerigi. ");
INSERT INTO geb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Zisas mbaram vhemkora mba guma ga sarav, kama havharan ana goriruav, khaŋ ana nzuai, ");
INSERT INTO geb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ndu khueŋ kaŋgiri, ndu kha bigeŋ bun harigi guma the suaŋ thari. Ndu ŋgɨv wo fhavar mba Fhe Bakɨme rotu gari guma khɨvav, mba Moses fhum suaŋgi tɨv, ndu mba tɨva zɨn ŋgɨv, wo rɨmrɨm vhɨzgi ne suaŋv Fhe Bakɨme suaŋv shaman muuŋgiri. Mbe maaŋ muuŋgip gangip kaŋgirga, ndu rɨmrɨm vhɨzgi.” ");
INSERT INTO geb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mba guma vov, maaŋ muungeŋ thav, mbaram mba bigeŋ bun za mbe suaŋgi. Ana maaŋ muuŋgim, gumgi gu mbigi vhɨrve ne mbararagiap, wari wo rɨmrɨɨ gum bigi vhɨzɨ zav zazera siav Zisas ga sui. Zisas maaŋ muuŋgiap hiiŋra sarav, ŋgu then vhen ŋgirgɨrga tuktɨgi fhu. Ana mba gumgi ki fhuv ŋanira kim, gumgi gu mbigi mbar kav ana han zav ki. ");
INSERT INTO geb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Rari mbari vhɨzgi, Zisas wom taagia Kaperneaman vergi. Ana vergap, wo phenan kim, gumgi gu mbigi vhɨrve ana taagia zergi kameŋ mbararagi. ");
INSERT INTO geb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mbe ne mbararagiap, gumgi gu mbigi vhɨrve siav ana phena suagi. Mba phena vhee za givigim, ana thɨmkamani vhɨra givigi. Zisas mbaram Fhe Bakɨme bunin mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Zisas Fhe Bakɨme bunin mbe nzuav kim, gumgi mbari bigi rimgi guma mbe ndiga ana han zi. Fethɨgi gumgi kaar ana ndigap, mbe zi. ");
INSERT INTO geb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mbe zav garim, mba Zisas ki phena thɨm, ana za givigi. Mbe Zisas han ŋgɨrgane mbovaragi. Mbe thav, mba guma ndigap phena kɨrar ndav mba phena kɨrar thooŋ ga mbui. Mbe ana thooŋ ga muuŋgiap, mbaram mpiin mba guman kaan fegap, ana ndi mbarigim, ana Zisas han veri. ");
INSERT INTO geb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Zisas mba guma garav, ana mba mbe ana khothɨgap muuŋgi bigi gangiap, khaŋ mba bigi rimgi guma ga nzuai, “Nan kam, ndu fhum muuŋgi tɨvi mbatɨgi vhɨzgi.” ");
INSERT INTO geb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Zisas nen ana nzuaim, mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi mbari zegap maaŋ piigiap kav, wari wo ndavi vherira kha ndɨkndɨga mbui, ");
INSERT INTO geb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Khe thaŋ nzuav khaŋ muuŋgi buni nzuai? Ana Fhe Bakɨmen zɨn farfagi? Guma the harigi guma muuŋgi tɨvi mbatɨgi vhɨzgirga tuktɨgi fhu. Fhe Bakɨme nduara.” ");
INSERT INTO geb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mbe mba ndɨkndɨgi ga mbuavra thagim, Zisas wo ndava vhen mbe ndɨkndɨgi kaŋgiap, khaŋ mbe nzuai, “Nde ram muuŋgiap kha ndɨkndɨgi ga mbui? ");
INSERT INTO geb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Maaŋgi kameŋ nzerigi? Gu khaŋ suaŋrie, ‘Gu ndu tɨvi mbatɨgi vhɨzgi’? Ee, gu khaŋ suaŋrie, ‘Ndu khavgip, wo kaa ndigip, ŋgɨri’? ");
INSERT INTO geb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Gu mba tɨvar muuŋgirim, nde gangip kaŋgirga, Fhe Bakɨme Guma Guar, ana kha nuianan tɨvi mbatɨgi vhɨzɨrga ŋkasŋka ki.” ");
INSERT INTO geb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ana nen mbe suaŋgiap, khaŋ mba bigi rimgi guma ga nzuai, “Gu ndu nzuai, ndu khavgip, wo kaa ndigip, taagi wo phenan ŋgɨ.” ");
INSERT INTO geb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Zisas ne nzuavra thagi, mba guma za khavgiap, wo kaa ndigap, kɨrar hi. Mba gumgi gu mbigi zam ana garav, ŋgava mbatɨga mbuav, Fhe Bakɨme zɨ ndi vun kuamkuav khaŋ nzuai, “Nza fhum khaŋ muuŋgi bigeŋ gangi fhu.” ");
INSERT INTO geb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Zisas mba bigeŋ ga muuŋgiap, wo phena thav, khavgiav Gariri mbɨ gaar vergi. Ana vergim, gumgi gu mbigi vhɨrve zav ana phok thɨgi, ana Fhe Bakɨme bunin mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ana mbe nzuav, mbɨ gaa ga tɨgap vui. Ana vuav Arfias kama Rivai garim, ana mbe ŋkɨɨ ndi ndɨɨi phena perav ki. Zisas ana garav, khaŋ ana nzuai, “Rivai, ndu zɨ na phorgɨv ŋka ŋgɨrga.” Rivai ana mbararagiap, khavgiap, ana phorga vui. ");
INSERT INTO geb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Zumgum Zisas Rivai phenan ka pi. Ŋkɨɨa ndia rui gumgi vhɨrve gum, tɨvi mbatɨgi ga mbui gumgi vhɨrve, ana phorga rui gumgi, mbe vhɨra ana phorga pi. Mbe khaŋ muuŋgiap, mba ŋkɨɨa ndia rui gumgi vhɨrve gum, tɨvi mbatɨgi ga mbui gumgi vhɨrve, mbe vhɨra ana phorga rui gumgi mbari ma. ");
INSERT INTO geb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ana mbe phorga pav kim, mba Zudaiŋ tɨvi vhuuiŋ kaŋgi Fherasiŋ gumgi ana gangiap, mbaram ana phorga rui gumgir nzai, “Ana thaŋ nzuav kha ŋkɨɨa ndia rui gumgi gum tɨvi mbatɨgi ga mbui gumgi phorga pi?” ");
INSERT INTO geb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Zisas mbe nzambareŋ mbararagiap, khaŋ mbe nzuai, “Rɨɨi fhuv gumgi, mbe thaŋ suaŋv rɨɨi phenan ŋgari guman han ŋgɨrie? Rɨɨi gumgi, mbe nduarira rɨɨi phenan ŋgari guman han vui. Gu gumgi vhuuiŋ ga nzua zɨgi fhuvara. Gu khaŋ muuŋgi tɨvi mbatɨgi ga mbui gumgir kamɨn za zɨgi.” ");
INSERT INTO geb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tuga mben Zon phorga rui gumgi gum Fherasiŋ phorga rui gumgi, mbe Fhe Bakɨme phorgav suan zav mba thamthagi raa ma. Zisas phorga rui gumgi mba raar pav kim, gumgi mbari Zisas han zav kha nzambaran ana muuŋgi: “Ram muuŋgi tɨv khare? Zon phorga rui gumgi gum Fherasiŋ phorga rui gumgi, mbe ntige Fhe Bakɨme phorgɨv suan zav mba thamthagi. Na ndu phorga rui gumgi, mbe Fhe Bakɨme phorga suan zav mba thamthagi fhu.” ");
INSERT INTO geb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Zisas ne mbararagiap, kha nzambaren mbe muuŋgi. “Guma the muun rɨgɨr zav shama bakɨme mbuav, gumgi mbarir kamgim, mbe zegi. Ana mbe phorga kim, mbe ram muuŋgip mba thamtharie? Fhuvara! Ana mbe phorga kim, mbe mba tharga tuktɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mbe mba tharga tuk ki. Mba tuk hɨgɨrga. Gumgi thari ana suirav ŋgɨgɨrim, mbe mba tugen, mbe mba thamtharga. ");
INSERT INTO geb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Nde vhɨra khueŋ mbarara. Guma the shaa fɨga kameŋ ndigap, shaa vura thooŋ phorga samgirga fhu. Ana maaŋ muuŋgirga, mba shaa fɨga kameŋ mba shaa suirav, ana rɨzgirga, mba shaa thooŋ guigira kɨvgirga. ");
INSERT INTO geb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Guma the wain kama ndigap, wain rui sɨga ndera vurar ruigirga fhu. Ana maaŋ muuŋgirga, mba sɨga ndera vur furav, mba sɨga nder gu wain, mani vhɨra mbatɨgirga. Ana maaŋ muuŋgirga fhu. Ana wain kaman sɨga ndera kamara ruigirga.” ");
INSERT INTO geb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Zisas Sabat raa mbevin rezi fara muuŋgi mba wit mɨni mbave sharav vui. Ana phorga rui gumgi, ana phorga vov, mba wit vhɨgi mbari korav vui. ");
INSERT INTO geb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mbe vuim, Fherasiŋ gumgi mbari, mbe gangiap khaŋ Zisas ga nzuai, “Ndu ganɨ. Mbe thaŋ nzuav Sabat tɨva phɨrgiap, Sabatar kha tɨva mbui?” ");
INSERT INTO geb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Zisas mbe ŋgarkarav khaŋ nzuai, “Nde mba Devit muuŋgi bigeŋ, mbe ne khergi, ne ki. Nde ne gangi fhuve? Ana wo gumgir kov, mbe thir vhɨzgiap ana mba bigeŋ muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ana vov, Fhe Bakɨme Phena vhen vergap, ana Fhe Bakɨme nɨma ndarigi vikntuu, ana nta mbegi. Ana nta pav, vhɨra mbarir wo gumgi ga nɨɨŋgim, mbe vhɨra nta mbegi. Ana nta mbegi tugar, Abiatar Fhe Bakɨme rotu gari guman pan ki. Mbe kha khesharigi tɨv ki. Mba mba, Fhe Bakɨme rotu gari gumgi, mbe nduarira pi mba ma.” ");
INSERT INTO geb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Zisas nen mbe nzua vov khaŋ mbe nzuai, “Fhe Bakɨme guma ga nzuav Sabat ga muuŋgi. Ana Sabat ga nzuav guma ga muuŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nde khueŋ kaŋgiri, Fhe Bakɨme Guma Guar, ana vhɨra Sabat Guma Bakɨme ma.” ");
INSERT INTO geb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Harigi tuga mben Zisas Fhe Bakɨme buni mbararagi phena vhen vergi. Mba gumgi gu mbigi vhɨrve rɨgar hareŋ kongi guma mbe vhɨra mbe phorga mba phena vhen ki. ");
INSERT INTO geb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Gumgi mbari Zisas bigɨn thueŋ muuŋgirim, mbe ne suaŋv ana suan zav tuavi ndi garav, rɨmgi sigap, ara thivgiav ki. Mbe khueŋ nzuav ana gari, ana Sabatar kha guman kurarie? ");
INSERT INTO geb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mbe ne nzuav garav kim, Zisas mbaram khaŋ mba hareŋ kongi guma ga nzuai, “Khavgi zɨ, za kheiŋ nɨma thɨgɨ.” ");
INSERT INTO geb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ana thɨgim, Zisas mbaram mben nzarigi, “Maaŋgi tɨv Sabat tɨva phɨri, tɨvar vhuuaŋ mbui ne, ee, tɨvar mbatɨga mbui ne, ee guman kurkurigi ne, ee guman farfagi ne?” Ana mba nzambaren mbe nɨɨŋgi, mbe za nimra ki. ");
INSERT INTO geb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ana phokphoga mbe garav, mbe nzuav ndap shigi. Ana mbe garim, mbe kora mbui ndɨkndɨk ki fhu. Ana guigira mbe nzuav ndap simgiap, khaŋ mba guma ga nzuai, “Ndu hareŋ ndegɨ.” Mba guma wo hareŋ ndegim, ana har taagia nzerigi. ");
INSERT INTO geb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mba Fherasiŋ gumgi maaŋ kav, mba bigeŋ gangiap, mba phena thav kɨrar hegap, vov Herot gumgi phorga Zisas shogɨrga kama shogi. ");
INSERT INTO geb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Zisas wo phorga rui gumgir kov, mbe Gariri mbɨn veri. Ana verim, gumgi gu mbigi vhɨrve Garirin fhain kegap, ana zɨn veri. Gumgi gu mbigi vhɨrve vhɨra Zudia fhain kegap verim, Zerusareman ŋgu gum, Edumia fhain gum, Zordan mbɨ khiŋgiap muen Taia gu Saidon fhain kegap, ana han veri. Mba gumgi gu mbigi vhɨrve ana mbui bigi kameŋ mbararagiap, ana han veri. ");
INSERT INTO geb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Mbe vergim, Zisas gumgi gu mbigi vhɨrver kurav, mbe muuŋgim, mbe rɨmrɨɨ vhɨzgi. Mba rɨmrɨɨ ki gumgi gu mbigi vhɨrve wari wo rɨmrɨɨ vhɨzɨ zav, wari ga bɨrbɨrav Zisas suigɨr zav ana han zi. Mbe zegav, sia Zisas ga suagi. Zisas mbaram khaŋ wo phorga rui gumgi ga nzuai, “Nde kema the ndigi zɨv khaŋ phorgɨri. Kha gumgi gu mbigi maaŋ muuŋgip na ndirarga fhu.” ");
INSERT INTO geb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Zisas maaŋ mbuim, mba ŋiniŋgi mbatɨgi vhen ndagi gumgi zav Zisas gari. Mbe Zisas garavra thav, mba ŋiniŋgi za mbe mbuim, mbe wari fov Zisas nɨma suav nzɨɨv, za khaŋ ana nzuai, “Ndu Fhe Bakɨmen Kam ma!” ");
INSERT INTO geb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mbe maaŋ mbuim, ana kama havharan mbe thɨvav khaŋ mbe nzuai, “Nde khaŋ suaŋ thari, ‘Ndu Fhe Bakɨmen Kam ma!’ ” ");
INSERT INTO geb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Zisas Gariri mbɨ gaar kegap, khavgiap mbɨkshɨɨ piin ndav, wo vuzvugi gumgi ga nzuaim, mbe ana han ndai. ");
INSERT INTO geb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Mbe ndagim, ana 12 thɨgi gumgi farasegi. Mbe ana phorgɨv kɨri, ana zumgum mbe sararim, mbe ŋgɨv, Fhe Bakɨme buni vhuuiŋ bun suanga. ");
INSERT INTO geb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ana vhɨra wo ŋkasŋkan mben nɨɨŋgiri, mbe vhɨra ŋiniŋgi mbatɨgi ga vharvhararga. ");
INSERT INTO geb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ana mba farasegi gumgi khare, Saimon, ana kha zɨ phorga ana tɨgi, Pita. ");
INSERT INTO geb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedin kamani Zems gu Zon, ana kha zɨ phorga mani ga tɨgi, Buanazis. Kha zɨ nɨɨŋge khaŋ nzuai, ndav shiav san kama ndi gumgi. ");
INSERT INTO geb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru gum, Firip, Bartoromiu, Matiu, Tomas, Arfias kama Zems, Tadius, Saimon, mbe Zerotan rɨgi gumgi. ");
INSERT INTO geb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Askariat guma Zudas, Zisas thuuŋ dorgav ana bun ana pana gumgi ga suaŋgi guma. ");
INSERT INTO geb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Zisas taagia Kaperneaman vergap phena vhen ki. Ana phena vhen kim, gumgi gu mbigi vhɨrve taagia zav ana phok thɨgi. Mba gumgi gu mbigi guigira vhɨrkɨvgi. Mbe maaŋ muuŋgiap, ana wo phorga rui gumgir kov, mbe mban mbɨrga tuktɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Zisas fegi gu ŋgugi kha kameŋ mbararagiap, ana kov ŋgɨr zav zi. Mbe khaŋ nzuai, “Ana ŋanŋangi.” ");
INSERT INTO geb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi mbari Zerusareman kegap zergav khaŋ nzuai, “Ana Bersebur ana vhen ndagi. Ana ŋiniŋgi mbatɨgi gari guman panan ŋkasŋkar kha ŋiniŋgi mbatɨgi ga vharvharigi.” ");
INSERT INTO geb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Zisas mbe nzuai kameŋ mbararagiap, mbaram mben kamgia buna muen mben nzarigi. Ana mben nzav khaŋ mbe nzuai, “Satan ram muuŋgip taagip wora vharvhararie? ");
INSERT INTO geb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ŋgu bakɨ the rɨgɨra wo sharav wari shogɨrga, mba ŋgu kegɨrga fhu. ");
INSERT INTO geb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mba tɨv vhɨra, phena bavira ki ntɨɨri, mbe rɨgɨra wari sharav, wari shogɨrga, mba phenan ki ntɨɨri kegɨrga fhu. ");
INSERT INTO geb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satan vhɨra, ana nduaram wo sharav wo phorgɨv shogɨrga, anan ŋkasŋka kegɨrga fhu. Anan ŋkasŋka za vhɨzgirga. ");
INSERT INTO geb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Nde mbarara! Guma the fhura guma ŋkasŋka the phenan ŋgirgɨp, ana bigi kɨmgirga tuktɨgi fhu. Ana maaŋ muun saŋv, ana fharav mba guma kegɨp, ana ndi tɨgɨp, ana za ana bigi kɨmɨnga. ");
INSERT INTO geb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Gu guigira nde nzuai, Fhe Bakɨme gumgi gu mbigi muuŋgi tɨvi mbatɨgi gum mbe Fhe Bakɨme zɨn farfagi tɨvi, ana nta vhɨzɨrga tuap ki. ");
INSERT INTO geb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Guma the Fhe Bakɨmen Ŋina Ŋaarar farfagirga, Fhe Bakɨme mba guma ana Ŋina Ŋaara zɨn farfagi bigeŋ, ana ne vhɨzgirga tuap ki fhu. Mba bigɨna mbatɨgeŋ mbara muuŋgip kɨrim, ana rimgirga ne mbara muuŋgip kɨrga.” ");
INSERT INTO geb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Mbe khuen ana nzuai, “Ŋina mbatɨk ana vhen ki.” Ana ne nzuav kha kamen mbe suaŋgi. ");
INSERT INTO geb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Zisas mba bunin mbe nzuav kim, ana niamuuŋ gum anan ŋgugi, mbe zav, mba Zisas ki phena thɨma thivgiap, guma mbe sarigim, ana Zisas ga suan zav vhen veri. ");
INSERT INTO geb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Gumgi gu mbigi vhɨrve ana rorgia piigiap kav khaŋ ana nzuai, “Ena, ndu niamuuŋ gum ŋgugi, mbe ndu nzuav zegap kɨrar ki.” ");
INSERT INTO geb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mbe nen ana nzuaim, ana mben nzarigi, “Theiŋ na niamuuŋ gum ŋgugi?” ");
INSERT INTO geb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ana mba nzambaren mbe mbuav, mba ana rorgia piigi gumgi gu mbigi garav khaŋ mbe nzuai, “Khe na niamuuŋ gum na ŋgugi khare. ");
INSERT INTO geb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Guma o mbik Fhe Bakɨme vuzvuga zɨn vui, mba guma gum mbik, ana nan ŋguk, gum nan bip, gum niamuuŋ ma.” ");
INSERT INTO geb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Harigi tuga mben, Zisas Gariri mbɨ gaar kav, Fhe Bakɨme buni vhuuin gumgi gu mbigi mbari ga nzuai. Mba ana buni mbarara zav ana phok thɨgi gumgi gu mbigi, mbe guigira vhɨrkɨvgi. Ana thav, fega kema mben mbarav, ana perav mbɨn ki. Mba gumgi gu mbigi ana han mba mbɨ gaar thɨvar ki. ");
INSERT INTO geb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ana buni vhɨrver mbe nzuav, nta vhunaa ga sav khaŋ mbe nzuai, ");
INSERT INTO geb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nde mbarara! Guma mbe vov, rezi fara muuŋgi mban wit vhɨgi ndiv mɨna fui. ");
INSERT INTO geb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ana nta ndi fuim, mbari tuap ga regim, korgi zav nta mbegi. ");
INSERT INTO geb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mbari ŋkɨɨ ki nuiana regi. Mba nuiana ne thɨɨŋra ki, nta maamgia vhemkora thooŋgi. ");
INSERT INTO geb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Zumgum ra ndav nta sharigim, nta thɨri khɨnan vergi fhu. Nta maaŋ muuŋgiap ŋgaav, nzɨɨv, za vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mbari tari ki kargi ki nuianeŋ ga regi. Nta regav, mba kargi phorgav vhuuŋgim, mba kargi nta kav, nta zɨrgi, nta vhɨgi mbai fhu. ");
INSERT INTO geb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mbari rav, nuiana vhuuaŋ regav, vhuuŋgiap, mbari 30 vhɨgi mbai, mbari 60 vhɨgi mbai, mbari kɨvgia vhɨgi mbav, vov 100 thɨgi vhɨgi maaŋgi.” ");
INSERT INTO geb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Zisas ne mbe nzua vov khaŋ mbe nzuai, “Guma khuarani kɨv, ana mbararari.” ");
INSERT INTO geb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mba gumgi gu mbigi vhɨrve za vegim, Zisas kim, ana mba farasegi 12 thɨgi ŋaara gumgi gu ana han ki gumgi, mbe mba ana vhunaa ga segi buni ga nzuav anan nzai. ");
INSERT INTO geb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ana khaŋ mbe nzuai, “Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨv muunga bigi, Fhe Bakɨme mba zorgi bigi nɨɨŋge, ana ntan nde suaŋgi. Mba harigi gumgi gu mbigi ana fhura vhunaa ga si bunira mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ana maaŋ mbuim, ‘Mbe zazera garav, mbe bigɨn thuen sagi fhu. Mbe vhɨra zazera mbararav mbe bigɨn thueŋ kaŋgi fhu. Ana maaŋ muuŋrim, mbe ndavi domdorgirga fhuv Fhe Bakɨme mbe muuŋgi tɨvi mbatɨgi vhɨzgirga fhu.’ ” ");
INSERT INTO geb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ana mba bunin mbe nzua vov, khaŋ mbe nzuai, “Nde kha vhunama dagi buna nɨɨeŋ kaŋgi fhuve? Nde maaŋ muuŋgip ram muuŋgip mba vhunaa ga si buna thueŋ kaŋgirie?” ");
INSERT INTO geb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ana ne mbe suaŋgiap, mba vhunama dagi buna nɨɨeŋ bun mbe nzuav khaŋ nzuai, “Mba guma Fhe Bakɨme buni fua sui. ");
INSERT INTO geb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Gumgi mbari mba tuap ga regi mban vhɨgi fara muuŋgi. Mbe Fhe Bakɨme buni mbararavra thagim, Satan zav mbe mba mbararagi Fhe Bakɨme buni, ana mbe tɨn nta ndigi. ");
INSERT INTO geb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Gumgi mbari mba ŋkɨɨ ki nuiana regi vhɨgi fara muuŋgi. Mbe Fhe Bakɨme buni mbararav guigira nta nzuav ndikndigi. ");
INSERT INTO geb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mbe vhɨra thɨri khɨnan vergi fhu, mbe vhɨra tuga mpeen ki fhu. Mbe kim, simtɨgi gum Fhe Bakɨme zɨn vui gumgir farfagi tɨvi hi, mbe fhura Fhe Bakɨme buni khothivɨ thagi. ");
INSERT INTO geb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Gumgi mbari, mbe mba tari ki kargi ki nuianeŋ ga regi vhɨgi fara muuŋgi. Mbe mba Fhe Bakɨme buni mbararagi. ");
INSERT INTO geb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Mbe nta mbararagi, mbe vhɨra kha nuiana bigi ga nzuav ndɨkndɨgi vhɨrve ga mbui. Mbe vhɨra kha nuianan ŋkɨɨ vhɨrve kɨrgeŋ nzuav mbuav, kha nuiana bigi vhɨrve garav nta nzuav rɨmgi tui. Mba bigi ndɨkndɨk zav, Fhe Bakɨme buni mbevigi, nta vhɨgi mbai fhu. ");
INSERT INTO geb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Gumgi mbari nuiana vhuuaŋ regi mban vhɨgi fara muuŋgi. Mbe Fhe Bakɨme buni mbararav, guigira nta suirav, nta zɨn vui. Mbe maaŋ mbuav mba vhɨgi mbav, vov mbari 30 vhɨgi mbai, mbari 60 vhɨgi mbai, mbari kɨvgia vhɨgi mbav, vov 100 thɨgi vhɨgi maaŋgi.” ");
INSERT INTO geb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ana mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde the fhum rama durav, ana ndiga zav thuun vhee rugire? Ee, ana ndi kaar piiaŋ ndarigire? Fhuvara. Nde ana durav, ana ndi hiiŋra ntorgi.” ");
INSERT INTO geb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ana mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde mba vhagi bigi, nta zumgum kɨrar hegɨrga, nde vhɨra mba zorga mbui bigi, nta vhɨra zumgum kɨrar hegɨrga. ");
INSERT INTO geb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Guma khuarani kɨv, ana mbararari.” ");
INSERT INTO geb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ana mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde thukhɨngira kha buni mbararari. Nde mba harigi gumgi ga mbui bigira, Fhe Bakɨme mba bigi ŋgarkarav, mba bigira taagi nden muuŋv, vhɨra harigi bigi phorgɨv nden nɨɨŋgirga. ");
INSERT INTO geb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Guma bigi mbari ki, Fhe Bakɨme harigi bigi phorgɨv anan nɨɨŋgirga. Guma bigi ki fhuv, Fhe Bakɨme, ana mba suirav ki bigiveŋ, ana ana tɨn nta ndigirga.” ");
INSERT INTO geb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ana nen mbe nzuav vov vhɨra khuen mbe nzuai, “Fhe Bakɨme wo gumgi gu mbigi ganɨnga, mbe ana piin kɨrga tɨv khaŋ muuŋgi. Guma mbe mban vhɨgi ndi nuiana fuigi. ");
INSERT INTO geb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mba guma nta fuigap, mbari gu rarir ana kov, ana khavi. Mba mban vhɨgi, nta thooŋgiap vhuuim, ana nta thova vhuui ne nɨɨeŋ kaŋgi fhu. ");
INSERT INTO geb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mba mba nuian nduara nta muuŋgim, nta vhuuŋgiap mba tegi. Nta fharav thooŋgiap, mbia ndav, vov khargi hɨgap, mbara ndav vov shivgiap, mba tegi. ");
INSERT INTO geb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nta tegav, mba gɨvigi, mba guma kos ndigap nta gori. Ana kaŋgi, mba gɨvigi nta gori tuk ma.” ");
INSERT INTO geb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ana taagia khaŋ nzuai, “Nza ramgi suambarar Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga tɨva suaŋrie? Ee, nza vhunama sɨv ram muuŋgi nɨɨ sɨgar anan muuŋrie? ");
INSERT INTO geb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ana mastet vhɨgara fara muuŋgi. Mastet, ana khan vhɨga bisaneŋ ma. Harigi khirar vhɨgi zam ana kambara kɨvgi. ");
INSERT INTO geb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ndu ne mpɨrigim, ne zumgum vhuuv guigira kɨvgiap mba mɨnan pari mpampari, ana za nta kambarav guigira kɨvgi. Ana kɨvgiav, ŋgagi bakɨvi shɨgim, korigi zav anan ŋgagir khoni ga mbuav ana vhen ki.” ");
INSERT INTO geb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Zisas mbe ndɨkndɨgi tugara tɨgap mba farara muuŋgi vhunaa ga si buni vhɨrver Fhe Bakɨme buni mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ana zazera bunin mba gumgi gu mbigi ga nzuav, ana zazera vhunaa ga si bunira mbe nzuai. Ana wo phorga rui gumgir kov, mbe nduarira kav, ana mba vhunaa ga si buni ndɨriveŋ bun mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mba raan, ra verav vhɨzi ŋkotuguraagen, Zisas khaŋ wo phorga rui gumgi ga nzuai, “Nza kha mbɨ thugɨp, mueŋ nderen ŋgɨrga.” ");
INSERT INTO geb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ana maaŋ mbe suaŋgiap, mba gumgi gu mbigi mbara kim, ana mba perigi kemara kim, mbe ana khɨgap, toga mueŋ vui. Harigi ŋkee mbari vhɨra mbe phorga muen vui. ");
INSERT INTO geb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Zisas wo phorga rui gumgi phorgav mbe vuim, mbaia, bɨɨŋbɨɨŋ bakɨ khavgi. Mbɨ phuri za fov mba keman mbai, mba kem mbɨ ana givi, ana korgi ŋgirɨ zav bisaŋ khɨnanera. ");
INSERT INTO geb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Zisas mba kema zɨn kɨrar, mbe piigia mba kema togi phararareŋ tɨthogap pana roran wo pana rorgap thoga kuigi. Ana phorga rui gumgi anan vhurap, khaŋ ana nzuai, “Nza ndɨkndɨgi vhuuin nza khɨvi guma, nza mbɨ thuav vhɨzɨ za mbui. Ndu nza ndɨkndɨgi fhuve?” ");
INSERT INTO geb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Zisas mbaram khavgia thɨgap, mba bɨɨŋbɨɨŋ ruma mbuav khaŋ mba mbɨ phuri ga nzuai, “Ndu mbɨra! Fhura mbar kɨ!” Ana ne nzuaim mba bɨɨŋbɨɨŋ gum mbɨ phuri fhura thuga mbar vugim, mba mbɨ fhura mbɨraga rɨgav ki. ");
INSERT INTO geb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ana khaŋ wo phorga rui gumgi ga nzuai, “Nde thaŋ nzuav kha rɨrɨva muuŋgi? Nde guigira Fhe Bakɨme khothɨvi fhuv thi?” ");
INSERT INTO geb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mbe guigira rivgiap tamtam warir nzai, “Khe the khare? Kha bɨɨŋbɨɨŋ gum mbɨ phuri vhɨra ana buni zɨn vui!” ");
INSERT INTO geb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mbe mba mbɨ thugap muen Gereseniŋ ndereŋ phorgi. ");
INSERT INTO geb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mbe phorgap, Zisas mba kema thav thɨvar ndavra thagi, ŋina mbatɨk vhen ndagi guma mbe mba gumgi ndi mbogi ga rɨgi ŋanen kegap Zisasan pura zi. ");
INSERT INTO geb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mba guma mba gumgi ndi mbogi ga rɨgi ŋanen kav ne ga kui. Guma the mba guma suirav ana kegɨrga tuktɨgi fhu. Mbe vhɨra shenin ana kav ragi. ");
INSERT INTO geb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mbe fhum tugi vhɨrvera shenin ana harani kav, ainin ana suani phokav ki. Mba shenin, ana nta suigav nta gora suav, mba ana suani phoki aini ana nta shoga, nta phɨrav, nta ndi sui. Guma the ŋkasŋkagip ana kegɨrga tuktɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ana mbari gu rarir, mba gumgi ndi mbogi ga rɨgi ŋanen kav, mba mbɨkshɨɨr kav nzɨɨv, nduara ŋkɨɨr wo shɨgav, wo gora sua rui. ");
INSERT INTO geb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ana samra Zisas gangiap, khuafɨrav zav wo fegap Zisas nɨma khɨngi. ");
INSERT INTO geb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Zisas khaŋ mba ŋina mbatɨga nzuai, “Ndu Ŋina mbatɨk, ndu mba guma thav kɨrar hɨgɨri.” Zisas nen ana nzuaim, mba guma thav fav, kama bakɨme rugap, khaŋ ana nzuai, “Ndu ram nan muun za mbui, Zisas, za kha bigi kharav vun guarira ki Fhe Bakɨme Kam. Ndu khaŋ na suaŋ, ‘Gu ndu nɨman Fhe Bakɨme zɨ zitarga, gu ndun farfarga fhu.’ ” ");
INSERT INTO geb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ana maaŋ nzuaim, Zisas khaŋ ana nzuai, “Ndu wo zɨ zita.” Mba ŋina mbatɨk ana ŋgarkarav khaŋ nzuai, “Na zɨ Vhɨrve, nza guigira vhɨrkɨvgi.” ");
INSERT INTO geb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ana maaŋ suaŋgiap, pim khaŋ tɨgap Zisas ga nzuai. “Ndu kha fhaiŋ thav ŋgɨrgen nza suaŋ thari.” ");
INSERT INTO geb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mba tugen, daa vhɨrve mba mbɨkshɨɨ piin hanera maaŋ kav pav ki. ");
INSERT INTO geb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Mba ŋiniŋgi mbatɨgi khaŋ tɨgap Zisas ga nzuai, “Ndu nza khɨrav nza sararim, nza ŋgɨv mbu daa vherir ndarga.” ");
INSERT INTO geb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Mbe maaŋ nzuaim, ana mbe khɨrigi. Mba ŋiniŋgi mbatɨgi mba guma thav kɨrar hegap, vov mba daa vherir vergi. Mba daar vhɨrve, 2,000 han mbarigi. Mba daa khuafua vov, mba vhara ntaaŋntaaŋ shaara vera vov, mba mbɨn vergap mbɨ pava vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mba daa gari gumgi, mba daar hɨgi bigeŋ gangiap, ra vov, mba ŋgu bakɨmen vov, mba fhain ki ŋgui bisarirer vov, mba hɨgi bigeŋ bun nzuai. Mba gumgi gu mbigi mba bigeŋ ganɨ zav khavav zi. ");
INSERT INTO geb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mbe zav, Zisas han mba ŋiniŋgi mbatɨgi vhɨrve vhen ndav kegi guma gari. Ana ndɨkndɨga vhuuŋ taagia anan zɨgim, ana wo shagi shargiap, perav ki. Mbe ana garav guigira rivgi. ");
INSERT INTO geb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mba hɨgi bigeŋ gangi ntɨɨri, mbe mba ŋiniŋgi mbatɨgi vhen ndav kegi guman hɨgi bigi bun mba harigi gumgi ga suaŋgi. Mbe nta bun nzuav vov, vhɨra mba daar hɨgi bigeŋ phorga bun suaŋgi. ");
INSERT INTO geb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mba gumgi gu mbigi, mba bigi mbararagiap, wari wo fhaiŋ thav ŋgɨr zav khaŋ tɨgap Zisas ga nzuai. ");
INSERT INTO geb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Zisas mbaram mba fhaiŋ thav ŋgɨr zav keman verim, mba ŋiniŋgi mbatɨgi vhen ndav kegi guma Zisas phorgɨv ŋgɨr zav khaŋ tɨgap ana nzuai. ");
INSERT INTO geb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Zisas ana thɨvav, khaŋ ana nzuai, “Ndu taagi wo fek gu tari han wo phenan ŋgɨv, Guma Bakɨme guigira ndun kurkurav ndu muuŋgi bigi bun mbe suaŋv, ana vhɨra fhura ndu kora muuŋgi ne bun mbe suaŋri.” ");
INSERT INTO geb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mba guma ne mbararagiap, vov mba Zisas ana kurkurav ana muuŋgi bigeŋ bun za mba Dikapores fhaiŋ ki ŋguir vov, za mba bigeŋ bun za mbe suaŋgi. Mba gumgi gu mbigi ne mbararagiap, ŋgava mbatɨga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Zisas kema ndigap, mba mbɨ thugap, taagia mueŋ nderen hɨgi. Ana hɨgap, mba mbɨ gaar kim, gumgi gu mbigi vhɨrve zav ana phok thɨgi. ");
INSERT INTO geb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Mba Fhe Bakɨme buni mbararagi phenan ŋaari gari guman pana mbe, Zairus, ana vhɨra maaŋ zɨgi. Ana zɨgap, Zisas gangiap, wo fegap, Zisas ŋkarveni nɨma khɨngiap, guigira khaŋ tɨgap Zisas ga nzuai, “Na kambik rɨmɨn zav gor vhɨk bisanera, ndu zɨv wo farven ana khɨngirim, ana rɨmrɨm vhɨzgip, taagip khavgip, kɨrga.” ");
INSERT INTO geb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Zisas ne mbararagiap ana phorga vui. Ana vuim, gumgi gu mbigi vhɨrve ana zɨ suegap, wari ga bɨrbɨrav, mbari fharigim, mbari zɨn kav ana phorga vui. ");
INSERT INTO geb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mbe vuim, mben rɨgar wo sargori rɨmrɨm ki mbiga mbe vhɨra mbe phorga vui. Mba mbik, ana mba sargori rɨmrɨm anan kim, 12 thɨgi mpari vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ana fhum mba rɨmrɨm vhɨzgi zav, rɨɨi phenan ŋgari gumgi han vuim, mbe mba rɨmrɨm vhɨzgi zav, zaa bakɨmen ana ndɨɨi. Ana wo rɨmrɨm vhɨzɨ zav fhura won ŋkɨɨar mbe vhezgim, ana ŋkɨɨa za vhɨzgi. Mba bigi anan rɨmrɨman kurigi fhu, ana pim kɨvgia vui. ");
INSERT INTO geb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Ana Zisas kameŋ mbararagiap, ana kha ndɨkndɨga mbui, “Gu ana shaara suirarga, na rɨmrɨm vhɨzgirga.” Ana mba ndɨkndɨga muuŋgiap, mbaram mba gumgi gu mbigi vhɨrve zɨn zav, mbe kevambav, zav Zisas shaa suirigi. ");
INSERT INTO geb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ana ana shaa suigara thagim, ana mba wo sargori rɨmrɨm fhura thuga mbar vugi. Ana wo khɨkhɨm mbararagi, ana fhav taagia nzerigi. ");
INSERT INTO geb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ana maaŋ muuŋgira thagim, Zisas vhemkora wo khɨkhɨm mbararagim, mba Fhe Bakɨme mba gumgir rɨmrɨɨ vhɨzɨ zav ana nɨɨŋgi ŋkasŋka, ana fhava khavgim, ana kaŋgi, nan ŋkasŋka ŋgari. Ana mbaram dorgav, mba gumgi gu mbigi vhɨrve garav, mbe nzarigi, “The na shaa suirigi?” ");
INSERT INTO geb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ana phorga rui gumgi ana ŋgarkarav khaŋ ana nzuai, “Ndu garim, kha gumgi gu mbigi vhɨrve wari ga bɨrbɨrav, mbari ndu nɨman fharigim, mbari ndu zɨ suegap zavra kim, ndu nzarigi, ‘The nan suirigi?’ ” ");
INSERT INTO geb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mbe nen Zisas ga nzuavra kim, Zisas mba wo shaar suirigi guma kaŋgi zav phokphoga mbe garavra ki. ");
INSERT INTO geb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ana phokphoga mbe garavra kim, mba mbik won hɨgi bigeŋ kaŋgiap, guigira rivgiav, ninɨga mbatɨga mbuav, zav wo fega Zisas ŋkarveni nɨma khɨngiap, guigira won hɨgi bigi, ana za nta bun ana suaŋgi. ");
INSERT INTO geb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ana khaŋ ana nzuai, “Nan kambik, ndu na khothɨgi, ndu rɨmrɨm vhɨzgi. Ndu ndav mbɨrav ŋgɨri, ndu wom mba rɨmrɨma zaa ndigirga fhu.” ");
INSERT INTO geb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Zisas mba mbiga nzuavra kim, gumgi mbari mba Fhe Bakɨme buni mbararagi phenan ŋaari gari guma Zairus phenan kegap zegi. Mbe zegap, khaŋ Zairus ga nzuai, “Ndu kambik rimgi. Ndu thaŋ nzuav pim kavtuigar ndɨkndɨgi vhuuiaŋ nza khɨvi guma ruma sui?” ");
INSERT INTO geb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mbe maaŋ nzuaim, Zisas mbe mbararagiap, khaŋ Zairus ga nzuai, “Ndu rɨvɨ thari, ndu fhura na khothɨgɨri.” ");
INSERT INTO geb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mba ana zɨ rui gumgi ana phorgɨv ŋgɨr za mbui. Ana mbe thɨvav, Pita gum, Zon, anan ŋguga Zems, ana mbera kov, mbe vui. ");
INSERT INTO geb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mbe vov, Zairus phenan hav, Zisas mba gumgi gu mbigi mbararagim, mbe khɨkhɨm bakɨme mbuav nzɨɨva nzi. ");
INSERT INTO geb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ana mbe han mba phena vhen verav khaŋ mbe nzuai, “Nde thaŋ nzuav kha khɨkhɨm bakɨme mbuav nzɨɨva nzi? Kha tar rimgi fhuvara, ana kui.” ");
INSERT INTO geb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ana nen mbe nzuaim, mbe thɨri fierav khaŋ ana nzuai, “Ee, nza tarire, ee? Nza kaŋgi, ana guigira rimgi.” Mba gumgi gu mbigi ne nzuaim, ana mbaram za mbe zɨtɨgim, mbe za kɨrar hegi. Mbe za kɨrar hegim, ana mba biptara ndia gu niamuun kov, mba ana phorga rui guma phuni khegene, mbera ana phorga vui. Ana mbera kov, mbe mba biptara khum ki ŋanen vui. ");
INSERT INTO geb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Mbe vov, mba tara khuma han vugap, ana mba biptara hara suirav, khaŋ ana nzuai, “Tarita kum!” Mba kama nɨɨeŋ khaŋ nzuai, “Biptarane, gu ndu nzuai, ndu khavik!” ");
INSERT INTO geb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ana ne nzuavra thagim, mba biptar khavgiap, thiva rui. Mba biptar mbiga ruma muuŋgiap, tira khuri ndai. Anan mpari khaŋ muuŋgi, 12 thɨgi. Ana khavgia thiva ruim, mbe maaŋ muuŋgiap gangiap, guigira ŋgava mbatɨga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ana mbaram kama havhara guarara mbe ndɨɨv khaŋ mbe nzuai, “Nde kha bigeŋ bun harigi guma the suaŋ thari.” Ana maaŋ mbe nzuav, mban ana nɨɨn zav mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Zisas maaŋ thav wo ŋgu nɨɨŋgen ndaim, ana phorga rui gumgi ana phorga ndai. ");
INSERT INTO geb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ana ndav Sabat raa hɨgim, ana Fhe Bakɨme buni mbararagi phena vhen vergap, Fhe Bakɨme buni vhuuin mbe nzuai. Gumgi gu mbigi vhɨrve ana buni mbararav ŋgava mbatɨga mbui. Mbe ŋgava mbatɨga mbuav nzai, “Kha guma maaŋ kha buni ndigi? Kha guma maaŋ kha khesharigi ndɨkndɨga vhuuŋ ndigi? Ana vhɨra maaŋ kha mirikori ga mbui ŋkasŋka ndigi? ");
INSERT INTO geb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Khe mba pheni ga mbui guma fhuve? Ee, khe Marian kam fhuve? Ee, ana Zems gum, Zosep, Zudas, Saimon, ana mben fek fhuve? Ee, khe anan bivi nza phorga ki fhuve?” Mbe ne ana nzuav, ana nzɨɨv, ana nzuav ndap shigi. ");
INSERT INTO geb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Zisas mbaram khaŋ mbe nzuai, “Fhe Bakɨme kamthooŋ guma, ana harigi ŋguir vuim, mbe zɨ bakɨmen ana ndɨɨi. Ana wo ŋgu nɨɨŋgera, ana ntɨɨri, ana fek gu tari, ana phorge regi ntɨɨri mbe nɨman ana zɨ ki fhu.” ");
INSERT INTO geb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ana maaŋ muuŋgiap maam mirikori vhɨrve ga muuŋgi fhu. Ana fhura wo farver rɨɨi gumgi mbari ga suim, mbe rɨmrɨɨ vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ana mbe ana khothɨgi fhuv, ne nzuav ŋgava mbatɨga muuŋgi. Zisas mbaram za mba ŋgui ga rui. Ana ŋgu mben Fhe Bakɨme buni vhuuin mbe suaŋgiap, khavgiav, harigi nen vui. Ana mbara mbua rui. ");
INSERT INTO geb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Zisas maaŋ mbua ruav, mbaram mba farasegi 12 thɨgi ŋaara gumgir kamgim, mbe ana han zi. Mbe ana han zim, ana mbe fugav, mbe nzuav, mbe ndi mbai. Guma phunini wani tɨga vui, guma phunini wani tɨga vui. Ana mbara mbuav mbe ndi mbai. Ana mbe ndi mbav vhɨra ŋiniŋgi mbatɨgi ga vharvhararga ŋkasŋka phorga mbe ndɨɨv mbe ndi mbai. ");
INSERT INTO geb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ana kha suambarar mbe mbuav mbe ndi mbai. “Nde ŋgɨv bigi thari ndigip wari ŋgɨ thari. Nde viktuma thueŋ ndi thari, nde mpaa thara thige rugɨ thari, nde kɨmararaŋ thueŋ suigɨ thari. Nde wo ŋkari sharira shargiv, wari wo sɨgara suigɨv, ŋgɨri.” ");
INSERT INTO geb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ana vhɨra khaŋ mbe nzuai, “Nde maaŋ muuŋgip ŋgɨv, ŋgu then ŋgɨgɨrim, mbe phena then nden nɨɨŋgiri, nde mba phenara kɨvkɨv, mba ŋgu thav, harigi ŋgun ŋgɨri. ");
INSERT INTO geb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nde maaŋ muuŋgip ŋgɨp ŋgu then ŋgɨgɨrim, mbe nde vuzvugi fhuv, mbe vhɨra nde nzuai buni mbararagi fhuv, nde khaŋ muuŋri. Nde mba ŋgu thav ŋgɨv, nde wari wo ŋkari shari nuiana pɨzgip, wari mba ŋgu thav, ŋgɨri. Nde maaŋ muuŋgirim, mbe gangip kaŋgirga, mbe tɨvar vhuun nde muuŋgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ana maaŋ mbe suaŋgiap, mbe ndi mbarigim, mbe mba ŋguir vov Fhe Bakɨme buni vhuuin mba gumgi gu mbigi ga nzuav khaŋ mbe nzuai, “Nde ndavi domdorɨri.” ");
INSERT INTO geb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mbe maaŋ mbe nzuav, mbe vhɨra gumgi vhɨrve tɨn ŋiniŋgi mbatɨgi ga vharvharav, rɨɨi gumgi vhɨrve, mbe mporiin mbe pani hɨvim, mbe rɨmrɨɨ vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Zisas bigi vhɨrve ga mbuim, ana zɨ hɨgim, gumgi vhɨrve ana kaŋgi. Herot, Gariri gum Peria fhaiŋ gari guman pan ne mbararagi. Mbe mbari khaŋ nzuai, “Zon Gumgi Ruai Guma rimgia taagia khavgi. Ana maaŋ muuŋgiap, ŋkasŋka ndigap, kha mirikori ga mbui.” ");
INSERT INTO geb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mbe mbari khaŋ nzuai, “Ana Iraiza ma.” Mbe mbari khaŋ nzuavra ki, “Khe fhum guarara kegi Fhe Bakɨme kamthooŋ gumgi fara muuŋgi guma mbe ma.” ");
INSERT INTO geb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mbe mba buni nzuaim, Herot nta mbararagiap khaŋ nzuai, “Gu fhum nzuaim, guma mbe Zon Gumgi Ruai Guma fhɨra thugim, ana taagia khavgi.” ");
INSERT INTO geb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Herot khaŋ muuŋgiap ne nzuai. Ana fhum won ŋguga Firip tɨn ana muuŋ Herodis ga tɨgi. Zon khaŋ ana nzuai, “Herot, ndu tɨvar vhuuaŋ muuŋgi fhuvara. Ndu tɨva mbatɨga mbuav, wo ŋguga tɨn anan muuaŋ tɨgi.” Zon ne suaŋgim, Herodis ana nzuav guigira ndav shigi. Ana Zon shogirim, ana rimgirga ne nzuav Herot dama mbui. Herot ana vuzvuga zɨn ŋgɨ thav, gumgi mbari ga nzuaim, mbe Zon suirav, ana ndi bɨna khɨngi. Herot kaŋgi, Zon Fhe Bakɨme guman ŋaar ma. Ana ana nzuai tɨvir vhuuiŋra zɨn vui guma ma. Herot maaŋ muuŋgiap, anan rivgiap, ana ndi ŋgɨrgi. Herot vhɨra Zon nzuai buni mbararav ndɨkndɨgi vhɨrve ga mbuav, ana buni mbararageŋ vuzvugi. ");
INSERT INTO geb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodis ntige Zon shogirim, ana rimgirga tuap gangi. Herot ana niamuuŋ ana tegi tuk hɨgi. Ana mba tuga ndɨkndɨgap, shama bakɨme mbui. Ana mba shama mbuav wo ŋaari bakɨvi gari gumgi bakɨvi, gum, won ntara gumgi gari gumgi bakɨvi gum, mba Garirin ki gumgi bakɨvi, ana mben kamgi. Mbe ana phorgɨv mba shaman mbɨr zav zegi. ");
INSERT INTO geb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mbe zegap, mba shama pav kim, Herodis kambik zav mbe mba pi ŋanen vergap, mbe nɨma hii. Ana hiim, Herot gum mba zega ana phorga pi gumgi anan hɨɨ gangiap, guigira anan hɨɨ vuzvugiap, anan ndikndigi. Mbe anan ndikndigap, Herot khaŋ mba biptara nzuai, “Ndu bigɨn the vuzvugip, ndu na nzari. Gu mba bigɨnan ndun nɨɨŋgirga.” ");
INSERT INTO geb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ana ne ana nzuav, kama havharan khaŋ ana nzuai, “Vu guma ma, gu guigira ndu nzuai, ndu bigɨn the vuzvugip, na suaŋri. Ndu gu gari bigi vuzvugip na suaŋri. Gu rɨgɨra nta sharav, tharir ndun nɨɨŋgirga.” ");
INSERT INTO geb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mba biptar mba kameŋ mbararagiap, mbe thav kɨrar hɨgap, vov khaŋ won niamuuŋ ga nzuai, “Mama, gu thagɨna suaŋv nzarie?” Ana niamuuŋ ana ŋgarkarav khaŋ nzuai, “Zon Gumgi Ruai Guman pan.” ");
INSERT INTO geb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mba biptar mba kameŋ mbararagiap, vhemkora taagia vov, Herot han vhen verap, khaŋ ana nzuai, “Ndu ntigera Zon Gumgi Ruai Guman panan thuuŋ the khɨngip, nan nɨɨŋgiri.” ");
INSERT INTO geb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herot ne mbararagiap, guigira ndav simgi. Ana wom ram suaŋrie? Ana fharav kama havharan ana nzuav, vu guma zitagi. Mba zegap ana phorga pi gumgi, ne mbararagi. Ana maaŋ muuŋgiap, ana daaŋ thagi. ");
INSERT INTO geb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Herot ne mbararara thav, kama havharar wo gɨmatɨva mbe nɨɨŋgiap, ana sarigim, ana vov phena tɨvanen vhen vergap, Zon fhɨra thugi. ");
INSERT INTO geb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ana Zon fhɨra thugap, ana pana ndi thuuŋ mbe ndarap, ana ndiga zav mba biptara nɨɨŋgim, ana ana ndiga vov, won niamuuŋ ga nɨɨŋgi. ");
INSERT INTO geb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Zon phorga rui gumgi Zon rimgi ne mbararagiap, zav Zon khuma ndiga vov, ana ndi mboga tɨgi. ");
INSERT INTO geb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Zisas mba farasegi 12 thɨgi ŋaara gumgi ndi mbarigi. Mbe vega kegap, taagia zegap, Zisas han wari fhugi. Mbe wari fhugap, mba ruav muuŋgi bigi gum mba gumgi gu mbigi khɨvav mbe suaŋgi bigi, mbe nta bun Zisas ga nzuai. ");
INSERT INTO geb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mba tugen, gumgi gu mbigi vhɨrve, mbe han zav vuim, mbe mban mbɨrga tuk ki fhu. Zisas mbaram khaŋ mbe nzuai, “Nde zɨv, na phorgɨv nza ŋgɨv gumgi ki fhuv ŋanen ŋgegɨp, nde vhuksurga.” ");
INSERT INTO geb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ana maaŋ mbe suaŋgiap, mbe nduarira kema ndigap gumgi ki fhuv ŋanen vui. ");
INSERT INTO geb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mbe vuim, gumgi gu mbigi vhɨrve mbe gangiap, mbe kheharav, gumgi gu mbigi za mba ŋguir kegap, fhara mbe nɨma tɨgav khuafuav vov, fharav mbe mba vui ŋanen hegi. ");
INSERT INTO geb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mbe vov phorgav, Zisas mba gumgi gu mbigi vhɨrve garim, mbe guigira vhɨrkɨvgi. Ana mbe gangiap, guigira mbe kora muuŋgi. Ana mbe garim, mbe sipsivi fara muuŋgi, mbe vuavi ki fhu, mbe fhura bogbogɨ rui. Ana mbe gangia thav, Fhe Bakɨme buni vhuuiŋ vhɨrver mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ana Fhe Bakɨme buni vhuuin mbe nzuav kim, ra verav vhɨzi. Ana phorga rui ŋaara gumgi ana han zav khaŋ ana nzuai, “Khe gumgi ki fhuv ŋaneŋ khare. Kha ra verav vhɨzi. ");
INSERT INTO geb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ndu kha gumgi gu mbigi ga sararim, mbe kha fhain ki ŋgui gum ruari ŋguivigen ŋgɨp, wari ga suaŋv, mba vhezɨp mbɨrga.” ");
INSERT INTO geb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ana thav mbe ŋgarkarav khaŋ nzuai, “Nde mbɨv mben kurmbɨ.” Mbe khaŋ ana nzuai, “Nza mbe suaŋv mba vhezɨrga ŋkɨɨa, nta sɨgarathɨgi kɨnin ŋgarigi guma ga vhezi vheza tuktɨgi. Nza mba fara muuŋgi ŋkɨɨa ndigi ŋgɨv, mbe suaŋv vikntuua vhezgip mben kurmbɨrie?” ");
INSERT INTO geb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Zisas mbaram mben nzarigi, “Nde rarara vikntuu mbar ki? Nde ŋgɨp, mbar ganɨ.” Mbe vov gangiap, khaŋ ana nzuai, “Nza meeŋthɨgi vikntuu, mbɨgama shɨɨŋ mpuani phorga khar ki.” ");
INSERT INTO geb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Zisas mbaram mbe nzuaim, mbe mba gumgi gu mbigi ga nzuaim, mbe phogi ga vhuav mba vhazɨgɨna piigi. ");
INSERT INTO geb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mbe mba piigi phogi, za mbara muuŋgi, mbari 50, mbari 100. ");
INSERT INTO geb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mbe piigim, Zisas mbaram mba meeŋthɨgi vikntuuveŋ ndigap, mba mbɨgama shɨɨŋ mpuani ndiga khoga buiva garav, Fhe Bakɨme ndikndigap ana phorga suaŋgiap, mba vikntuu phɨra sui. Ana nta phɨra suav wo phorga rui ŋaara gumgi ga nzuaim, mbe nta shama mbuav, mba gumgi gu mbigi ga ndɨɨi. Ana vhɨra mba mbɨgamani phɨrim, mbe vhɨra ni shama mbua mbe ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mba gumgi gu mbigi za mbegap, za ndavi givigi. ");
INSERT INTO geb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mba Zisas phorga rui ŋaara gumgi, mbe mba ndavi givav thagi mban tɨvi, mbe nta ndiav 12 thɨgi kɨra ga vhuigim, nta za givigi. ");
INSERT INTO geb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mba mba mbegi gumgira, mben vhɨrve 5,000 thɨgi. ");
INSERT INTO geb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mba gumgi gu mbigi mba mbegim, Zisas mbaram khaŋ wo phorga rui ŋaara gumgi ga nzuai, “Nde fhara kema ndigip muen Betsaida ŋgun ŋgɨri. Gu nduara kɨv, kha gumgi gu mbigi ga sararim, mbe taagip wari wo ŋguir ŋgɨrga.” ");
INSERT INTO geb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ana mbe sarigim, mbe vegim, ana mbaram Fhe Bakɨme phorgɨv suan zav mbɨkshɨɨ piin ndagi. ");
INSERT INTO geb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mba raan ra verav vhɨzgim, maaŋ gɨngi. Mba kem mbɨn rɨgagera kim, Zisas nduara mbɨkshɨman piin ki. ");
INSERT INTO geb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ana kav wo phorga rui ŋaara gumgi garim, bɨɨŋbɨɨŋ kɨvgia zav mben kema rɨgi. Mbe ana dav togav, ŋaara mbatɨga mbui. Mbe toga vuav kim, mɨn gorɨ za mbuim, Zisas mbɨn tɨn thivav mbe han vui. Ana vov mbe kaman zav mbui. ");
INSERT INTO geb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Mbe ana garim, ana mbɨn tɨn thiva vuim, mbe khueŋ ndɨkndɨgi, “Khe tum ma!” Mbe mba ndɨkndɨga mbuav, zam ana gangiap, guigira rivgiap, zam nzɨɨi. Mbe nzɨɨvra thagim, ana za khaŋ mbe nzuai, “Nde ŋgɨrgiri! Gu ra! Nde gori kuirɨ thari.” ");
INSERT INTO geb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ana maaŋ mbe nzuav, fega mbe han keman mbarigim, mba bɨɨŋbɨɨŋ fhura mbɨrigi. Mbe guigira ne ndɨkndɨga ŋgava mbatɨga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mbe khaŋ muuŋgiap, ana mba 5,000 gumgi gu mbigi, ana mba meeŋthɨgi vikntuuveŋra mben kua mbegi, mbe ne gangiap, nen sagi fhuvara, mbe ndɨkndɨgi tivgi. ");
INSERT INTO geb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mbe vov, mba mbɨ thugap muen Genesaret fhaiŋ phorgav kema ndi thɨrigi. ");
INSERT INTO geb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mbe kema ndi thɨrav thɨvar ndaim, mba gumgi Zisas garavra ana kheharigi. ");
INSERT INTO geb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mbe ana kheharav, mba fhain maaŋ ki gumgi gu mbigi za khuafua ana han zi. Mbe rɨɨi gumgi, mbe kaagir mbe ndiav Zisas han zav mbararagi, Zisas maaŋ ki ŋanen kim, mbe mbe ndiav ana han vui. ");
INSERT INTO geb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Zisas maaŋ mbuav za mba bigi ga ruigi. Ana ŋgui bakɨvir vov, mba ŋgui bisarire gum mba ruari ŋgui ana vhɨra ntan vui. Ana vuim, mba gumgi za kaagir rɨɨi gumgi ndia zav ŋgui rɨgivigen mbav khaŋ tɨga anan nzai, “Ndu nza khɨrarim, nza ndun shaa tɨvara suigɨrga.” Mbe maaŋ nzuav ana shaa tɨva suigi ntɨɨri, mbe rɨmrɨɨ za vhɨzi. ");
INSERT INTO geb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Harigi tuk mben, Fherasiŋ gumgi mbari, Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi mbari, mbe Zerusareman kegap zerav, mbe wari thɨgap Zisas han zav ana phok thɨgi. ");
INSERT INTO geb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mbe maaŋ kav, Zisas phorga rui gumgi mbari garim, mbe mben nzɨgi tɨva zɨn vuav fari ruagiap mba pi fhu. Mbe fhura mba pi. ");
INSERT INTO geb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mba Fherasiŋ gumgi gum mba Zudaiŋ gumgi, mbe won nzɨgi tɨva suiravra ki. Mbe fari ruagiap, za pi. Mbe fhura mban mbegɨrga tuktɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mbe vhɨra phogar kegɨp ndigi zegɨrga mba, mbe fhura ntan mbegɨrga tuktɨgi fhu. Mbe nta ruagiap, za nta pi. Mbe vhɨra wari wo nzɨgi mbui harigi tɨvi mbari, mbe nta suiravra ki. Mbe fhura mba shamgip, mbegɨrga tuktɨgi fhu. Mbe fharav wari wo ndari gum thuuri phara pi tha, mbe nta ruagip, mbe zam ntan mban muunga. ");
INSERT INTO geb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mbe maaŋ muuŋgiap, mba Fherasiŋ gumgi gum mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi, mbe mba tɨva gangiap, Zisasan nzarigi, “Ndu phorga rui gumgi, mbe ram muuŋgiap nzɨgi tɨva zɨn ŋgɨv fari rua thav, fhura mba pi?” ");
INSERT INTO geb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mbe mba nzambaran Zisas ga muuŋgim, Zisas mbe ŋgarkarav khaŋ mbe nzuai, “Nde fhura bigir wari ga shɨshɨgi gumgi ma. Fhum Fhe Bakɨme kamthooŋ guma Aisaia, ana guigira nde mbui tɨvi bun nzuav kherav khaŋ suaŋgi, ‘Kheiŋ thɨriŋkuun na zɨ ndi vun fi, mbe ndɨkndɨgi nan ki fhu. ");
INSERT INTO geb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mbe fhura shɨshɨga na zɨ ndi vun kuamkuav, guma suaŋgi tɨvi, nde ntan wari khɨvav fhura khaŋ nzuai, “Kheiŋ Fhe Bakɨme nzuai tɨvi ma.” ’ ");
INSERT INTO geb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nde maaŋ mbuav, Fhe Bakɨme suaŋgi tɨvi, nde nta kuegap, wari wo nzɨgi suaŋgi tɨvi, nde ntara suirigi.” ");
INSERT INTO geb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ana ne mbe nzuav, khaŋ mbe nzuai, “Nde tɨvar vhuuŋ guarira mbuav ki. Nde kha tɨva mbuav, Fhe Bakɨmen tɨvi ndi mbu gaa khɨngiap, nde won nzɨgi tɨvara zɨn vui. ");
INSERT INTO geb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses khaŋ nde nzuai, ‘Nde wo ndegi gu ndegmbori buni mbararav, mbe piin kɨri. Guma the buna mbatɨga thuen wo niamuuŋ gu ndia ga suaŋgirga, nde mba guma shogirim, ana rimgiri.’ ");
INSERT INTO geb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nde khaŋ nzuai, ‘Guma the wo niamuuŋ gu ndiar kurkura zav tɨgi ŋkɨɨ, ana ntan manin kurkura thav, vov khaŋ mani ga nzuai, “Mba ŋkon kurkura zav tɨgi ŋkɨɨ, nta Koban ma.” ’ (Koban nɨɨeŋ khaŋ nzuai, ‘Fhe Bakɨmen nɨɨnga ne. Gu ntan Fhe Bakɨmen mbuigi.’) ");
INSERT INTO geb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nde maaŋ mbe nzuav, guma the bigɨna then wo niamuuŋ gu ndiar kurarga tuktɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nde maaŋ mbuav, wari wo nzɨgi han ndigi tɨvi, nde nta zɨn vov, Fhe Bakɨme nzuai tɨvi, nde nta mbevigi, nta vergi. Nde mba khesharigi tɨvi vhɨrve, nde nta mbui.” ");
INSERT INTO geb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Zisas mbara taagia mba gumgi gu mbigi vhɨrver kamgim, mbe ana han zim, ana khaŋ mbe nzuai, “Nde za na mbararari. Gu khar nde nzuai buni, nde nta ndiv wari wo ndɨkndɨgir tɨgɨri. ");
INSERT INTO geb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Bigɨn the kɨrar kegap, guma ndav vhen vergap, anan ndava vhee muuŋgim, ana nzaŋnzaŋgirga tuktɨgi fhu. Mba guma ndav vhen kegap kɨrar hi bigi, ana ndava vhee muuŋgim, ana nzaŋnzaŋgi.” ");
INSERT INTO geb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Zisas mba bunin mba gumgi gu mbigi vhɨrve ga suaŋgiap, mbe thav vov, wo phena vhen vergi. Ana wo phena vhen verga kim, ana phorga rui gumgi ana mba suaŋgi buni nɨɨŋge nzuav, anan nzai. ");
INSERT INTO geb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Zisas mbaram khaŋ mbe nzuai, “Ee, nde vhɨra mba kameŋ ndi sagi fhuve?” Ana thav mben nzarigi, “Nde khueŋ kaŋgi fhuve? Guma pi mba, nta ana kamthoon bumgum, ana ndava thoon veri. Mba mba, ana ndava mbuim, ana nzaŋnzai fhu. ");
INSERT INTO geb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mba mba vhɨra guma tuman vhen veri fhuvara. Nta ana mbun veri. Ana zumgum nta vhigi.” (Zisas khaŋ muuŋgia tɨga nza nzuai, ne khaŋ muuŋgi, nza kha pi mba, nta za pi mbara.) ");
INSERT INTO geb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ana ne mbe nzua vov khaŋ mbe nzuai, “Guma ndava vhen kegap kɨrar hi bigi, ana mbui tɨvi mbatɨgi, nta mba guma ndava vhee mbuim, ana nzaŋnzaŋgi. ");
INSERT INTO geb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Guma ndav vhen kegap kɨrar hi tɨvi khare, ndɨkndɨgi mbatɨgi, ruarin mbigi gu gumgi wari ndi, bigi kɨɨi, guma shogi rimgi, ");
INSERT INTO geb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ruarin mani ga rɨgi, mbigi gu gumgi kɨɨi, bigi ga nzuav thagine mbui, bigi farfagi tɨvi, bigi guiguigi, fhura ferfera rui, bigi garav rɨmani mbɨ tui, harigi gumgi zɨrir farfagi, wo ndi vun kuamkuagi, fhura ŋanŋana tɨvi mbatɨgi ga mbui. ");
INSERT INTO geb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kha khesharigi tɨvi mbatɨgi, nta zam guma ndava vhen kegap kɨrar hi, nta anan ndava vhee muuŋgim, ana nzaŋnzaŋgi.” ");
INSERT INTO geb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Zisas mba suaŋgi buni nɨɨŋge bun wo phorga rui gumgi ga suaŋgiap, maaŋ thav, Taia fhain ndagi. Ana ndav, phena mbe vhen vergap, wo vhagi. Ana wo vhagirga tuktɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ana maaŋ kim, mbiga mbe, anan kambik ŋina mbatɨk ana vhen ndagi, mba mbik Zisas maaŋ ki ne mbararagiap, thav Zisas han zi. Ana zav, wo fegap Zisas ŋkarveni nɨma khɨngi. ");
INSERT INTO geb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mba mbik Sairofonisia fhaiŋ mbik ma, ana Grik kamara nzuai. Ana khaŋ tɨgav wo kambiga tɨn mba ŋina mbatɨga vharvhara zav Zisas ga nzuai. ");
INSERT INTO geb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Zisas mbaram khaŋ ana nzuai, “Ndu fharav mba tari vuzvugi mban mben nɨɨŋgirim, mbe fharav ntan mbegɨri. Khe tɨvar vhuuŋ fhuvara. Ndu thaŋ nzuav tarir mba fua feiŋ ga sui?” ");
INSERT INTO geb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mba mbik ana ŋgarkarav khaŋ nzuai, “Ahaŋ, Guma Rum, ndu nzerara nzuai. Feiŋ vhɨra mba kaar piin kav mba tari pi phɨreri fɨgiveiŋ pi.” ");
INSERT INTO geb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Zisas mbaram khaŋ ana nzuai, “Ndu maaŋ na suaŋgi, ndu taagi wo phenan ŋgɨri. Mba ŋina mbatɨk ndu kambik thav kɨrar hɨgi.” ");
INSERT INTO geb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ana taagia wo phenan vov gari, ana kambik wo kaa ga rɨgap ki. Ana ana gangiap, kaŋgi, mba ŋina mbatɨk ana thav kɨrar hɨgi. ");
INSERT INTO geb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Zisas maaŋ kegap, mba Taia fhaiŋ thav khavgia ndai. Ana nda vov Saidon sharav, taagia verav, mba Dikapores fhain sharav Gariri mbɨ gaar vergi. ");
INSERT INTO geb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ana vugap maaŋ kim, gumgi mbari khuarani ŋangiap buni suambara kakagi guma mbe ndigap, ana han zɨgi. Mbe zegap, farven ana sur zav khaŋ tɨgav Zisas ga nzuai. ");
INSERT INTO geb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Zisas mbaram mba guman kov mba gumgi vhɨrve thav, mani nuanira gaar vugap, ana mbaram wo farafenin mba khuarani ŋangi guma khuarani ga rugi. Ana wo farafenin mba guma khuarani ga ruga kegap, ni sigap, mbara wo farafe pargiap, mba guma ze khɨngi. ");
INSERT INTO geb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ana farafen mba guma ze khɨngiap, khoga buiva garav, ana ndava vhee guigira mba guma ga nzuav nziav, khaŋ mba guma ga nzuai, “Epata!” Mba kama nɨɨeŋ khaŋ nzuai, “Fhogɨ!” ");
INSERT INTO geb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Zisas maaŋ mba guma ga muuŋŋgim, ana khuarani taagia bigi mbararagi. Ana bigi mbararav, ana ze bɨkbɨɨgim, ana taagia tuituigia buni nzuai. ");
INSERT INTO geb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Zisas mbaram kama havharar mba bigeŋ bun suangen mbe thɨvigi. Ana mbe thɨvara kim, mbe pim ne bun nzuai. ");
INSERT INTO geb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mbe ne bun nzuaim, mba gumgi gu mbigi ne mbararagiap, guigira ŋgava mbatɨga muuŋgiap, thɨri tuigap, khaŋ nzuai, “Ana za kha bigi ga mbuav nzerara nta mbui guma ma. Ana khuarani ŋangi guman muuŋgirim, ana taagi buni mbararagi. Ana vhɨra buni suangeŋ kakagi guman muuŋgirim, ana taagi tuituigia buni nzuai.” ");
INSERT INTO geb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Zisas mba raarir mbara kim, gumgi gu mbigi vhɨrve siav ana haa suav ana phok thɨgi. Mbe ana han kav kav, thi hegap, mbɨrga mba fhu. Zisas mbaram wo phorga rui gumgir kamgim, mbe ana han zim, ana khaŋ mbe nzuai, ");
INSERT INTO geb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Gu kha gumgi gu mbigi kora muuŋgi. Mbe na han kav kim, ra phuni khegene vhɨzgim, mbe mba vhɨra vhɨzgi. Mbe thi hegi. ");
INSERT INTO geb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Gu thi ndavira mbe sararim, mbe taagi wari wo ŋguir ŋgɨrga, mbe tuavar thir vhɨzɨp, suira wari phogɨv ŋgegɨrga fhuvara. Mbe mbari vhɨra saman kegap zegi.” ");
INSERT INTO geb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ana nen mbe nzuai, ana phorga rui gumgi ana ŋgarkarav khaŋ ana nzuai, “Khe gumgi ki fhuv ŋaneŋ khare. Guma the maam vikntuu ga vhezgip, za kha gumgir kurmbegɨrie?” ");
INSERT INTO geb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mbe maaŋ nzuaim, Zisas mben nzarigi, “Nde rarara vikntuu mbar ki?” Mbe ana ŋgarkarav khaŋ nzuai, “Nza harathɨgi vikntuu khar ki.” ");
INSERT INTO geb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ana mbaram mba gumgi gu mbigi vhɨrve ga nzuaim, mbe nuiana piigi. Ana mba harathɨgi vikntuu ndigap, Fhe Bakɨme ndikndigap ana phorga nzuai. Ana Fhe Bakɨme phorga suaŋgia thugap, mba vikntuu phɨrav, nta shaman muun zav, ntan wo phorga rui gumgi ga ndɨɨi. Ana nta mbe ndɨɨim, mbe nta shama mbuav, mba gumgi gu mbigi ga ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mbe vhɨra mbaga bisaŋri mbarire phorga ki. Ana vhɨra nta ndigap, Fhe Bakɨme ndikndigap ana phorga suaŋgiap, nta shama muun zav wo phorga rui gumgi ga nzuai. ");
INSERT INTO geb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mba gumgi gu mbigi vhɨrve za mbegap, mbe ndavi givigi. Ana phorga rui gumgi hegap, mbe mba ndavi givav, thagi mban tɨvi ndi. Mbe nta ndiav harathɨgi kɨra ga vhuigim, nta za givigi. ");
INSERT INTO geb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mba raan, mba mba mbegi gumgi gu mbigin vhɨrve 4,000 thɨgi. Mba gumgi gu mbigir mbegim, ana mbe sarigi mbe taagia wari wo ŋguir vui. ");
INSERT INTO geb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ana mbe sarigim, mbe vuim, ana wo phorga rui gumgi phorgav mbe kema ndigap, Daramanuta fhain vui. ");
INSERT INTO geb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mbe vov, Daramanuta fhain phogim, Fherasiŋ mbari zav Zisas phorga nzuav ana dav, anan mparav, ana nzuai. Mbe anan mparav khaŋ ana nzuai, “Ndu Hevenan ki ŋkasŋkan mirikor then muuŋrim, nza gangip, kaŋgirga, ndu Fhe Bakɨmen ŋaara mbui.” ");
INSERT INTO geb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Zisas mba kameŋ mbararagiap, mbe nzuav visuav, khaŋ mbe nzuai, “Nde ntige kha tugen vhuuŋgi ntɨɨri, nde thaŋ nzuav nɨɨŋge ki mirikoran muun zav nzai? Gu guigira nde nzuai, gu nɨɨeŋ ki mirikor then nden nɨɨŋgirga fhu.” ");
INSERT INTO geb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ana nera mbe suaŋgia thav, mba Fherasiŋ gumgi thav, wo phorga rui gumgir kov, mbe taagia vov keman vergap, mba mbɨ thugav mueŋ nderen hi. ");
INSERT INTO geb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mbe vov vikntuu ndirgeŋ ŋangi, mbe viktuma bavira ndigi, ana mbe han mba keman ki. ");
INSERT INTO geb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Zisas mbaram mbe goriruap, khaŋ mbe nzuai, “Eke! Nde thukhɨngira mba Fherasiŋ gum Herot is gangiri.” ");
INSERT INTO geb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Zisas ne mbe suaŋgim, mbe nen wari ga nzua vov, khaŋ wari ga nzuai, “Nza vikntuu ndiga zegi fhuv, ana maaŋ muuŋgia nen nza nzuai.” ");
INSERT INTO geb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mbe nen wari ga nzuaim, Zisas mbe nzuai ne kaŋgiap, mben nzarigi, “Nde thaŋ nzuav vikntuu ki fhuv ne ga nzuav wari ga nzuai? Ee, nde kha gu mbui bigi garav, nde ntan sagi fhuve? Ee, nde kaŋgi fhuve? Nde ndɨkndɨgi guigira tivgi. ");
INSERT INTO geb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nde rɨmgi ki, nde gari fhuve? Nde khuari ki, nde mbararagi fhuve? Nde kha bigi ndɨkndɨk suirigi fhuve? ");
INSERT INTO geb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nde gu mba meeŋthɨgi vikntuu phɨrav nde nɨɨŋgi. Nde ntan mba 5,000 gumgi ga nɨɨŋgi. Mbe nta pav ndavi givav thagi ntɨɨri, nde ntan rarara kɨra ga vhuigi?” Mbe ana ŋgarkarav khaŋ ana nzuai, “Nza 12 thɨgi kɨra ga vhuigi.” ");
INSERT INTO geb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ana wom khaŋ mbe nzuai, “Maaŋgi, gu mba harathɨgi vikntuu phɨrav nde nɨɨŋgim, nde ntan mba 4,000 gumgi gu mbigi ga nɨɨŋgi. Mbe nta mbegav ndavi givav thagi ntɨɨri, nde ntan rarara kɨra ga vhuigi?” Mbe ana ŋgarkarav khaŋ ana nzuai, “Nza ntan harathɨgi kɨra ga vhuigi.” ");
INSERT INTO geb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Mbe ne ana nzuaim, ana khaŋ mbe nzuai, “Ee, nde maaŋ muuŋgiap gangiap, nde sagi fhuve?” ");
INSERT INTO geb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Zisas mba bunin mbe suaŋgiap, mbe vov, Betsaidan vegi. Mbe vegim, gumgi mbari rɨmani mbatɨgi guma mbe ndigap, Zisas han zi. Mbe zav, khaŋ tɨgav farven ana suigir zav, Zisas ga nzuai. ");
INSERT INTO geb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Zisas mbaram mba rɨmani mbatɨgi guman harar suirav, anan kov, mba ŋgu thav kɨrar hɨgi. Ana ana kov, ana kɨrar hɨgap, mbaram wo farve ga pargiap, ana rɨmani suirav, anan nzarigi, “Ndu bigɨn the garire?” ");
INSERT INTO geb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mba guma ragia garav, khaŋ nzuai, “Gu gumgi gari. Gu mbe garim, mbe gumgi fara muuŋgiap rui. Gu mbe garim, mbe khira fara muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Zisas mbaram taagia wo farven ana rɨmani suirigim, mba guma rɨmani za ŋgarigi. Ana rɨmani ŋgarav, taagia nzerigim, ana tuituigia bigi gari. ");
INSERT INTO geb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Zisas mbaram ana sarav, khaŋ ana nzuai, “Ndu wo phenan ŋgɨri, ndu taagip kha ŋgun vhen ŋgirɨ thari.” ");
INSERT INTO geb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Zisas maaŋ kegav wo phorga rui gumgir kov, mbe khavgia Sesaria Firipai ŋgu bakɨme han ki ŋgui bisarirer vui. Mbe vov, ana tuavar mbe nzarigi, “Kha gumgi gu mbigi then na rɨgi?” ");
INSERT INTO geb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mbe ana ŋgarkarav khaŋ ana nzuai “Mbe mbari khaŋ nzuai, ndu Zon Gumgi Ruai Guma ma.” Mbe mbari khaŋ nzuai, “Ndu Fhe Bakɨme kamthooŋ guma Iraiza ma,” mbari khaŋ nzuai, “Ndu mba fhum kegi Fhe Bakɨme kamthooŋ guma mbe ma.” ");
INSERT INTO geb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Mbe maaŋ nzuaim, Zisas wom mben nzarigi, “Mbe mba zɨrir na rɨgi, na nde then na rɨgi?” Ana ne nzuaim, Pita mbaram ana ŋgarkarav khaŋ nzuai, “Ndu Krais ma.” ");
INSERT INTO geb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pita ne suaŋgim, Zisas mbaram mbe goriruav, khaŋ mbe nzuai, “Nde na bun harigi guma the suaŋ thari.” ");
INSERT INTO geb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Zisas mba bunin mbe suaŋgia thugap, mbaram za kha buni mbe nzuav khaŋ mbe nzuai, “Fhe Bakɨme Guma Guar zaagi vhɨrve ndirga. Mba gumgi ruu gum, mba Fhe Bakɨme rotu gari gumgir pani, Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi, mbe zam ana shashagip kɨr ana segɨrga. Mbe ana shogirim, ana rimgirga, ra phuni khegene vhɨzgirga, ana taagi khavgirga.” ");
INSERT INTO geb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Zisas wo rɨmɨngane siga sarav mbe nzuaim, Pita mbaram ana kov gaar vugap, ana vhegap, khaŋ ana nzuai, “Ndu maaŋ suaŋ thari.” ");
INSERT INTO geb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ana ne nzuaim, Zisas dorgav wo phorga rui gumgi garav, Pita vhegap khaŋ ana nzuai, “Satan, ndu na thav sari! Ndu Fhe Bakɨme ndɨkndɨgi ndɨkndɨgi kaŋgi fhuvara, ndu gumgi ndɨkndɨgi ndɨkndɨgira kaŋgi.” ");
INSERT INTO geb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ana mba kamen Pita suaŋgia thugap, ana mbaram mba gumgi gu mbigi vhɨrve gum ana wo phorga rui gumgi, ana mben kamgi. Mbe ana han zim, ana khaŋ mbe nzuai, “Guma the na zɨn zɨr saŋv, ana wo vuzvugi mbevav, wo rɨmɨnga khanarareŋ phufhurav, na zɨn zɨri. ");
INSERT INTO geb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Guma the won tumara ndɨkndɨgɨrga, ana tum za fhurigi rɨgɨrga. Guma the na buni vhuuiŋ gum na suaŋv wo tuma fekhɨngirga, anan tum zazera mbara muuŋgip kɨrga. ");
INSERT INTO geb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Khe tɨvar vhuuŋ ee? Guma the wo tumara ndɨkndɨgɨp, za kha nuianan ki bigi, ana zam nta ndigɨp, ntan muuŋv kɨv rimgirga, mba bigi ram muuŋgip ana tuman kurarie? ");
INSERT INTO geb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mba guma thagɨna ndigip, taagip wo tuma vhezgirim, ana tum taagip mbara muuŋgip kɨrie? ");
INSERT INTO geb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nde ntige kha tugen vhuuŋgia ki gumgi o mbigi, nde maaŋ muuŋgip kɨr Fhe Bakɨme segɨp, tɨvi mbatɨgir muuŋv, nde na zɨ gum na buni vhuuiŋ bun suangen mbergi. Nde zumgum Fhe Bakɨme Guma Guar wo Ndia han kegɨp, ana han Hevenan ki enseri gum Fhe Bakɨme ŋkasŋka phorgɨp zirɨrga, ana vhɨra mben mbergirga.” ");
INSERT INTO geb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Zisas mba bunin mbe nzua vov, khaŋ mbe nzuai, “Gu guigira nde nzuai, nde ntige khar ki ntɨɨri, nde thari vhɨzgirga fhu. Nde khara muuŋgip kɨv ganɨrim, Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga ŋkasŋka phorgɨv zirgɨrga.” ");
INSERT INTO geb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mporathɨgi raari vhɨzgim, Zisas Pita gum Zems, Zon, ana mben kov, mbe nduarira ana zɨn mbɨkshɨma bakɨma mben ndagi. Mbe ndav nduarira ana phorga ki. Mbe maaŋ kav, Zisas fhav harigi kheshara hɨgi. ");
INSERT INTO geb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Mbe ana garim, ana mba shargi shagi guigira hurgiap ŋaara gari. Ana shagi fhum guma the kha nuianan ruagi shagi ŋgara gari gangana muuŋgi fhuvara. Nta guigira ŋaara gari. ");
INSERT INTO geb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mbe ana garim, Iraiza gum Moses hav, ana phorga buni nzuai. ");
INSERT INTO geb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Mbe mbe gangiap guigira rivgi. Mbe rivgia Pita suanga buni kakagia thav, khaŋ Zisas ga nzuai, “Guma Rum, nza nzerara khaŋ ndagi. Nza nde suaŋv mpɨkava phuni khegenen muuŋgirga. Ndu suaŋv thevi, Moses ga suaŋv thevi, Iraiza suaŋv thevi.” ");
INSERT INTO geb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pita nen Zisas ga suaŋgim, buiva hur hav, mbe vharigi. Mba buiva hur mbe vharigim, Fhe Bakɨme mba buiva hurigen kav khaŋ mbe nzuai, “Khe nan Kam ma. Gu guigira ana vuzvugi. Nde ana buni mbararari!” ");
INSERT INTO geb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mbe mba kamthooŋ mbararara thav, phokphoga gari. Mbe garav harigi guma the gangi fhu. Mbe Zisasra garim, ana mbe phorga ki. ");
INSERT INTO geb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mbe mba mbɨkshɨman kegap, taagia zerav, Zisas kama havharar khaŋ mbe nzuai, “Nde kha bigen warira khɨgɨ kɨrim, Fhe Bakɨme Guma Guar rimgip, taagi khavgiri.” ");
INSERT INTO geb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mbe ne mbararagiap, ne warira khɨga kav, nen warira nzuai. Mbe khaŋ wari ga nzuai, “Ram muuŋgi ne khare, rimgip, taagi khavgirga?” ");
INSERT INTO geb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mbe ne nzua vov ana nzarigi, “Mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi thaŋ nzuav khaŋ nzuai, ‘Iraiza fhara zɨgɨrga’ ? ” ");
INSERT INTO geb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Zisas mbaram mbe ŋgarkarav khaŋ nzuai, “Guigira Iraiza fharav zɨgɨp, za kha bigi ndi thɨgɨra maanga. Maaŋ muuŋgiap, mbe thaŋ nzuav khaŋ muuŋgi kameŋ khergi? Fhe Bakɨme Guma Guar, ana zaa bakɨme ndirga. Mbe ana shav, kɨr ana segɨrga. ");
INSERT INTO geb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Gu khar nen nde nzuai, Iraiza fhara zɨgim, mbe wari wo vuzvugi zɨn vov, mbar kɨrga tɨvir ana muuŋgi. Mbe ana muuŋgi tɨvi, mbe nta khergi, nta Fhe Bakɨme gavar ki. Mbe mba bunira zɨn vugi tɨvir ana muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mbe zera zav, mba Zisas phorga rui gumgi mbari han zegap, mbe garim, gumgi gu mbigi vhɨrve zav, mbe phok thɨgi. Mbe mbe phok thɨgap, mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi, mbe bigɨn mueŋ nzuav, mbe dav ki. ");
INSERT INTO geb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mbe zergav, mbe han maaŋ kim, mba gumgi gu mbigi Zisas garavra thav ŋgava mbatɨga muuŋgiap khuafuav ana han zav, anan ndikndigi. ");
INSERT INTO geb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Zisas mbaram mben nzarigi, “Nde thagɨna nzuav kheiŋ dav mbe nzuai?” ");
INSERT INTO geb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ana mben nzaim, mba gumgi gu mbigi vhɨrve rɨgar guma mbe kama hegap, khaŋ ana nzuai, “Ndɨkndɨgi vhuuin nza khɨvi guma rum, gu won kama ndiga ndu han zɨgi. Ana ŋina mbatɨga mbe ana vhen kav, ana thɨni mpɨrigim, ana buni nzuai fhu. ");
INSERT INTO geb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ana ana hi tugir, ana zazera ana suigav, ana fov nuiana sui. Ana rav phuvun ana kamaŋɨni thivim, ana tari ndɨri phɨrav bigi thɨgɨra si. Gu ana ndiga zav, ndu phorga rui gumgi han zɨgap, mba ŋina ga vharvhara zav mbe nzuaim, mbe tuktɨgi fhu.” ");
INSERT INTO geb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Zisas ne mbararagiap, mbe ŋgarkarav khaŋ nzuai, “Nde ntige kha tugen vhuuŋgi ntɨɨri, nde Fhe Bakɨme ŋkasŋka khothivi fhu. Gu rarara tugir nde phorgɨ kɨrie? Gu zazera nde phorgɨv kɨv, nde simtɨgi ndirie? Mba tara ndigɨp nan han zɨ.” ");
INSERT INTO geb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ana maaŋ mbe nzuaim, mbe mba tara ndigap Zisas han zi. Mba ŋina mbatɨk Zisas garavra thav, mba tara mbuim, ninɨk anan ndaim, ana ana dagim, ana kɨga vov rɨgap, sakozap, phophogerav, phuvun ana kamaŋɨni thɨgi. ");
INSERT INTO geb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Zisas mbaram mba tara ndiar nzarigi, “Ana ramgi tugar kha bigeŋ anan hɨgi?” Mba tara ndia ana ŋgarkarav khaŋ nzuai, “Ana taranera kim, kha bigeŋ anan hɨgap, mbara muuŋgia khar ki. ");
INSERT INTO geb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ana tugi vhɨrvera anan shogirim, ana rimgir zav, ana fov vhava sui, ana fov mbɨ sui. Ndu bigɨn thuen muuŋgirgeŋ tuktɨgɨp, ndu nza korar muuŋgip, nzan kurari.” ");
INSERT INTO geb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Zisas mbaram khaŋ ana nzuai, “Ndu thaŋ nzua khaŋ na nzuai, ‘Ndu tuktɨgire’? Ndu Fhe Bakɨme ŋkasŋka khothivɨrga, ndu za kha bigir muunga.” ");
INSERT INTO geb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mba tara ndia ne mbaravara kama hegap, nzɨɨv khaŋ nzuai, “Gu Fhe Bakɨme ŋkasŋka khothɨgi. Na ndɨkndɨk tivgi. Ndu nan kurarim, gu Fhe Bakɨme ŋkasŋka khothivi tɨv havhargirga.” ");
INSERT INTO geb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mba guma nen Zisas ga nzuaim, Zisas mba gumgi gu mbigi vhɨrve garim, mbe khuafuav mben han zi. Ana mbaram kama havharar mba ŋina mbatɨga vhegap khaŋ ana nzuai, “Ndu thɨni mpɨrav khuarani ŋangi ŋina mbatɨk, ndu ana thav kɨrar hɨgɨp, taagip ana vhen ŋgirɨ thari.” ");
INSERT INTO geb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ana ne nzuaim, mba ŋina mbatɨk ndarav nzɨɨv, khɨrɨv mba tara mbuim, ana sakozav phophogerim, ana ana thav kɨrar hɨgi. Ana mba tara thav kɨrar hɨgim, mba tar ŋama rimgi. Mba gumgi gu mbigi ana gangiap khaŋ nzuai, “Ana rimgi”. ");
INSERT INTO geb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Zisas mbaram mba tara harar suirav, ana ragim, ana thɨgi. ");
INSERT INTO geb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Zisas zumgum vov phenan vhen vergim, ana phorga rui gumgi, mbe nduarira kav anan nzarigi, “Nza ram muuŋgiap kha ŋina mbatɨga vharvharargeŋ tuktɨgi fhu?” ");
INSERT INTO geb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Zisas mbaram mbe ŋgarkarav khaŋ mbe nzuai, “Nde khaŋ muuŋgi ŋina mbatɨga vharvhara saŋv, tuap bavira. Nde Fhe Bakɨmera phorgɨv suaŋri.” ");
INSERT INTO geb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Zisas maaŋ mbe suaŋgiap, mbe mba ŋgu thav, khavgiav Gariri fhaiŋ sharav vui. Mbe vov, Zisas mba gumgi gu mbigi ana vui ŋaneŋ kaŋgirgane thagi. ");
INSERT INTO geb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ana khaŋ muuŋgiap, ana wo phorga rui gumgi, ana Fhe Bakɨme bunin mbe khɨvɨv mbe nzuai, ana mbe nzuav, khaŋ mbe nzuai, “Guma the Fhe Bakɨme Guma Guara thuuŋ dorgɨp, ana ndim gumgi farve khɨngiri. Mbe ana shogirim, ana rimgirga. Ra phuni khegene vhɨzgirim, ana taagi khavgirga.” ");
INSERT INTO geb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ana nen mbe nzuaim, mbe nen sagi fhuvara. Mbe ne nɨɨeŋ ga suaŋv anan nzan za mbuav, anan rivgiap wari thagi. ");
INSERT INTO geb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mbe mbaram vov Kaperneaman hegap, ana vov phena mbe vhen vergap, mben nzarigi, “Nde kha tuavar zav, thagɨne nzuav warir nzav, wari ga nzuai?” ");
INSERT INTO geb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ana mba nzambaren mbe muuŋgim, mbe the ana kameŋ ŋgarkarigi fhuvara. Mbe kaŋgi, mbe tuavar zav khueŋ nzuav wari kaadogi, “The nzan rɨgar zɨ ki?” ");
INSERT INTO geb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Zisas perav, mba farasegi 12 thɨgi ŋaara gumgir kamgiap, khaŋ mbe nzuai, “Guma the zɨ kɨr saŋv, ana guigira wo mbevav, wo ndi zɨn mbarav, za kha gumgir ŋaara guma kɨri.” ");
INSERT INTO geb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ana nen mbe nzuav, tara mbe nzuaim, ana mbe rɨgar thɨgi. Ana mbe rɨgar thɨgim, ana ana fhurav khaŋ mbe nzuai, ");
INSERT INTO geb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Guma the na zɨn khaŋ muuŋgi tara then kurarga, ana vhɨra nan kurigi. Guma the vhɨra nan kurarga, ana nara kurigi fhuvara. Ana mba na sarigi nen kurigi.” ");
INSERT INTO geb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Zisas mba kamen mbe nzuai, Zon mbaram khaŋ ana nzuai, “Ndɨkndɨgi vhuuin nza khɨvi Guman Rum, nza guma mbe garim, ana ndu zɨn panan ŋiniŋgi mbatɨgi ga vharvharigi. Nza khueŋ nzuav ana thɨvi. Ana nza the fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Zisas mbaram khaŋ ana nzuai, “Ana thɨvɨ thari. Guma the na zɨn panan mirikor then muuŋgirga, ana ntigera buna mbatɨga thuen na suaŋgirga fhuvara. ");
INSERT INTO geb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Guma the panan nza kegi fhu, ana nza ne ma. ");
INSERT INTO geb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Gu guigira nde nzuai, guma the na zɨn mbɨ thama then nden nɨɨŋgirga, ana vhɨra nde kaŋgi, nde Krais ntɨɨri ma, mba guma ana wo vheza tharga fhuvara. Ana wo vheza ndigɨrga.” ");
INSERT INTO geb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ana nen mbe nzua vov khaŋ mbe nzuai, “Guma the kha na khothɨgi tara then muuŋgirim, ana rɨgɨp, na khothivɨ tharga, mbe nzerara kɨma bakɨ then ana fhɨra ntorgɨp, ana fegɨp, mbasɨk rɨga khɨngirim, ana rimgirga, ne nzerara. ");
INSERT INTO geb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ndu hara thueŋ ndun muuŋgirim, ndu rɨgɨv, na khothivɨ tharga, ndu mba hareŋ thugɨp, fekhɨngiri. Ndu hara bueŋra kɨrga, ndu zazera mbara muuŋgia ki bɨɨŋbɨɨŋ ndigirga. Ndu hara mpuani khɨgɨ kɨrga, ndu Herar ŋgɨgɨrga. Ndu mba zazera mbara muuŋgia ki vhavar kegɨrga. ");
INSERT INTO geb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ndu ŋkari thave ndun muuŋgirim, ndu rɨgɨv, na khothivɨ tharga, ndu mba ŋkarve thugɨp, fekhɨngiri. Ndu ŋkari bavira khɨgɨp, ndu zazera mbara muuŋgia ki bɨɨŋbɨɨŋ ndigirga. Ndu ŋkarveni vhɨra kɨrga, mbe ndu fegɨp, Her khɨngirga. ");
INSERT INTO geb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ndu rɨma thueŋ ndun muuŋgirim, ndu rɨgɨv, na khothivɨ tharga, ndu mba rɨmaiŋ sigip, fekhɨngiri. Ndu rɨma bueŋra khɨgɨp Fhe Bakɨme wo gumgi gu mbigi garim, mbe piin ki ŋgun ŋgirɨrga, ne nzerara. Ndu rɨmani vhɨra kɨrga, mbe ndu fegɨp, Her khɨngirga. ");
INSERT INTO geb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Mba ŋanen gumgi fhavi ga bi pigi ki, nta vhɨzi pigi fhuvara. Nta mbara muuŋgia ki pigi ma. Mba ŋanen zazera mbara muuŋgiap shiav ki vhav vhɨra ki.’ ");
INSERT INTO geb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Mba vhav mbe mbasɨgar mba sui, tɨvara muuŋgip, gumgi shirga. ");
INSERT INTO geb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mbasɨk bigɨnan vhuuŋ ma, ana faŋgirga, ndu wom ram anan muuŋgirim, ana taagi vhergirie? “Nde mbasɨk vhergi vherar muuŋgip ndava mɨɨtɨga ndigip, nde wari tɨgɨp kɨri.” ");
INSERT INTO geb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Zisas mbaram mba ŋgu thav, khavgia vov, Zudia fhaiŋ shɨgim, gumgi gu mbigi vhɨrve zav, maam ana phok thɨgi. Ana maam Fhe Bakɨme buni vhuuin mbe suaŋgiap, maaŋ thav vov, Zordan mbɨ thugap mueŋ nderen hɨgi. Ana muen hɨgim, gumgi gu mbigi vhɨrve taagia zav, maaŋ ana phok thɨgi. Mbe maaŋ ana phok thɨgim, ana taagia won tɨva mbuav, maam Fhe Bakɨme buni vhuuin vhɨra mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ana mba tugen Fhe Bakɨme buni vhuuin mbe nzuav kim, Fherasiŋ mbari zav anan mparav anan nzarigi, “Ndu khar nza suaŋ, nzan tɨv ram nzuai. Guma won muuŋ thamthargane nzerarame?” ");
INSERT INTO geb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ana mbe ŋgarkarav khaŋ mbe nzuai, “Moses ramgi tɨvar muun zav nde suaŋgi?” ");
INSERT INTO geb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Mbe khaŋ nzuai, “Moses khuen nza khɨrigi. Guma the wo muuŋ thamtha saŋv, gava thueŋ khergip, ana thamtharga kamen ana suaŋgip, mba gaven anan nɨɨŋgip, zam ana thamtharga.” ");
INSERT INTO geb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Zisas mbe ŋgarkarav khaŋ nzuai, “Nde pani havhargim, Moses maaŋ muuŋgiap nde nzuav mba kameŋ khergi.” ");
INSERT INTO geb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ana thav khaŋ mbe nzuai, “Fhum guarara Fhe Bakɨme za kha nuian gu bigi ga mbuav, ana guma gu mbiga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Maaŋ muuŋgiap, guma won muuaŋ tɨgav, ana wo ndia gu niamuuŋ thav, ana wo muuŋ phorgap, mani wani tɨga ki. Mani wani ga tɨgap, wani phorga havhargi. ");
INSERT INTO geb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Mani wani shɨrav, wani hiarga fhu. Mani wani phorga havhargia, guma bavira gari gangana mbui. ");
INSERT INTO geb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Maaŋ muuŋgip, Fhe Bakɨme bigɨn thanin wani phorgɨrim, guma ni shɨgɨ thari.” ");
INSERT INTO geb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mbe taagia phena vhen vergap, Zisas phorga rui gumgi mba bigeŋ ga nzuav anan nzarigi. ");
INSERT INTO geb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ana mbe ŋgarkarav khaŋ mbe nzuai, “Guma the wo muuŋ thav harigi mbigar tɨgɨrga, mba guma won muun farfagiap, ruan harigi mbiga ndigi tɨva muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mbiga the won mana thav harigi guman tɨgɨrga, ana wo mana farfagiap ruan harigi guma ndigi tɨva muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Gumgi gu mbigi tari bisarire ndigap, Zisas han zi. Mbe ana wo farven mbe sur zav, mbe mbe ndiav ana han zim, ana phorga rui gumgi mbe vhegi. ");
INSERT INTO geb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mbe mbe vhegim, Zisas ne gangiap, ndav ana mbatɨgim, ana khaŋ mbe nzuai, “Nde fhura mba tarire ganɨrim, mbe na han zɨri. Nde mbe thɨvɨ thari. Khaŋ muuŋgi tarire fara muuŋgi ntɨɨri, mbe Fhe Bakɨme wo gumgi gu mbigi garim, mbe ana piin ki ntɨɨri ma. ");
INSERT INTO geb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Gu guigira nde nzuai, maaŋ muuŋgip guma the tara bisaneŋ Fhe Bakɨme vuzvugiap, ana piin ki tɨva fara mbui fhu. Mba guma Fhe Bakɨme wo gumgi gu mbigi garim, mbe ana piin ki ntɨɨri phorgɨ kegɨrga fhu.” ");
INSERT INTO geb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ana nen mbe suaŋgia thugap, mba tari bisarire ndiav, mbe fhuav, wo farven mbe suav, ŋgɨrkama vhuun mbe ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Zisas ŋgɨrkama vhuun mba tari ga nɨɨŋgiap khavgia vuim, guma mbe khuafɨ zav, wo thɨpani phɨrgia Zisas nɨma faav, khaŋ ana nzuai, “Ndɨkndɨgi vhuuin nza khɨvi guma rum, ndu guman vhuuŋ ma. Gu ram muuŋgip zazera mbara muuŋgia ki bɨɨŋbɨɨŋ ndigirie?” ");
INSERT INTO geb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Zisas ana ŋgarkarav khaŋ ana nzuai, “Ndu thaŋ nzuav guman vhuun na rɨgi. Guman vhuuŋ the ki fhuvara, Fhe Bakɨme nduara guman vhuuŋ ma. ");
INSERT INTO geb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ndu Fhe Bakɨme Moses ga nɨɨŋgi tɨvi kaŋgi. Ndu guma shogiri ana rɨmɨ thari, ndu hara guma muuŋ ruarir ana ndi thari, ndu kɨmɨ thari. Ndu bigi shɨshɨgɨ thari, ndu fhura gumgi nɨfhɨ sɨv mbe bigi ndi thari. Ndu wo ndia gu niamuuŋ piin kɨv mani buni mbararari.” ");
INSERT INTO geb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ana ana ŋgarkarav khaŋ nzuai, “Ndɨkndɨgi vhuuin nza khɨvi guman rum, gu fhum taranera mba tɨvi zɨn vuav kav, ntige guma ruma muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Zisas mbaram mba guma garav, ana vuzvugiap, khaŋ ana nzuai, “Ndu bigɨn mueŋ khegi. Ndu ŋgɨv, za wo bigi ndi maaŋrim, mbe nta vhezgirim, ndu mba ŋkɨɨr mba bigi sosuagi gumgir nɨɨŋgiri. Ndu maaŋ muuŋgirga, ndu Hevenan guigira bigi vhuuiŋ guarira kɨrga. Ndu maaŋ muuŋgip, na phorgɨ ruri.” ");
INSERT INTO geb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mba guma mba kameŋ mbararagiap, khom anan fevgi. Ana kaŋgi, ana guigira bigi vhɨrkɨvgi guma ma. Ana maaŋ muuŋgiap ndav simgiap, vugi. ");
INSERT INTO geb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Zisas mbaram phokphoga garav, khaŋ wo phorga rui gumgi ga nzuai, “Ŋkɨɨ kɨvgi gumgi, mbe Fhe Bakɨme wo gumgi gu mbigi garim, mbe ana piin ki ntɨɨri phorgɨv kɨrgane suaŋv, mbe ŋaara mbatɨgar muuŋgirga.” ");
INSERT INTO geb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mba Zisas phorga rui gumgi ana kameŋ mbararagiap ŋgava mbatɨga muuŋgim, Zisas taagia khaŋ mbe nzuai, “Tari, guma Fhe Bakɨme wo gumgi gum mbigi garim, mbe ana piin ki ntɨɨri phorgɨ kɨrgane suaŋv, ana ŋaara mbatɨgar muuŋgirga. ");
INSERT INTO geb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kemor shagi sai suuŋ thoon ŋgɨr zav, ana ŋaara mbatɨgar muuŋgirga fhu. Ŋkɨɨ kɨvgi guma, ana Fhe Bakɨme wo gumgi gu mbigi garim, mbe ana piin ki ntɨɨri, ana mbe phorgɨ kɨrgane saŋv, ana ŋaara mbatɨgar muuŋgirga.” ");
INSERT INTO geb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ana ne mbe nzuaim, mbe guigira ŋgava mbatɨga muuŋgiap, ndɨkndɨgi vhɨrve ga mbuav, nduarira wari ga nzuai, “Maaŋgi the zazera mbara muuŋgia ki bɨɨŋbɨɨŋ ndigirie?” ");
INSERT INTO geb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Zisas mbe garav khaŋ mbe nzuai, “Mba bigi guman tuktɨgi fhu. Fhe Bakɨme za kha bigin muunga ne tuktɨgi.” ");
INSERT INTO geb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita mbaram khaŋ ana nzuai, “Nza ndu zɨn vuav, nza za wo bigi thav ndu zɨ rui!” ");
INSERT INTO geb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Zisas mbaram khaŋ ana nzuai, “Gu guigira ndu nzuai, guma the na buni vhuuiŋ gum na ndɨkndɨgap wo phena thav wo fegi gu ŋgugi, wo meeiŋ gu bivi, wo ndia gu niamuuŋ won tari gu mɨni thav na zɨ rui, ");
INSERT INTO geb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mba guma ntige kha nuianan Fhe Bakɨme guigira bigi vhɨrver ana nɨɨŋgirga. Ana mba fhum ki bigi, ana guigira nta kambararga. Ana pheni vhɨrve guarira anan nɨɨŋv, fegi gum ŋgugi, meeiŋ gum bivi, ndegmbori, gum tari vhɨrve, mɨni, ana ntan ana nɨɨŋgirga. Ana vhɨra kha nuianan gumgi ana farfarga tɨvi, ana vhɨra nta ndirga. Ana zumgum zazera mbara muuŋgia ki bɨɨŋbɨɨŋ ndigirga. ");
INSERT INTO geb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ntige kha tugen fharav ki gumgi vhɨrve, mbe zumgum zɨn kɨrga. Ntige zɨn ki gumgi vhɨrve mbe zumgum fhararga.” ");
INSERT INTO geb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Zisas wo phorga rui gumgir kov mbe Zerusareman ndai. Mbe ndav Zisas fharigim, ana phorga rui gumgi, ana zɨn mbe ndav, mbe ŋgava mbatɨga muuŋgi. Mbe phorga ndai gumgi gu mbigi vhɨra rivgi. Zisas taagia wo farasegi 12 thɨgi ŋaara gumgir kov, mbe gaar vugap, ana won hɨgɨrga bigi bun mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ana khaŋ mbe nzuai. “Nza Zerusareman ndai. Nza Zerusareman ndarim, guma the Fhe Bakɨme Guma Guara thuuŋ dorgɨp, ana suaŋv kama shɨrav, ana ndim, Fhe Bakɨme rotu gari gumgir pani gum Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi farve khɨngirga. Mbe khaŋ ana suanga, ‘Ndu rɨmɨnga.’ Mbe maaŋ ana suaŋgip, ana shogirim, ana rimgirgane suaŋv, ana ndim harigi ŋgu ntɨɨri fararar mbararga. ");
INSERT INTO geb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mba harigi ŋgu ntɨɨri, mbe ŋgɨza bunin ana suaŋv, ana sɨɨŋv, ana parɨv, ana kharɨv, ana shogirim, ana rimgirga. Ana rimgirim, ra phuni khegene vhɨzgirga, ana taagip khavgirga.” ");
INSERT INTO geb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedi kamani, Zems gu Zon, mbaram Zisas han zav khaŋ ana nzuai, “Ndɨkndɨgi vhuuin nza khɨvi guma rum, ŋka bigɨn mueŋ ga nzuav ndun nzai. Ŋka ndun nzararim, ndu ŋkan kurav ŋka ndim mba bigen muuŋgiri.” ");
INSERT INTO geb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Zisas manin nzarigi, “Gu ŋkon kurav ram ŋkon muuŋrie?” ");
INSERT INTO geb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Mani ana ŋgarkarav khaŋ nzuai, “Ndu zɨ bakɨme gum ŋkasŋka ndigip, ndu ŋka the ndim wo guva haren farim, ana ndu guva haren perarim, ŋka the ndu ŋkɨn haren perarga.” ");
INSERT INTO geb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Zisas mani ŋgarkarav khaŋ nzuai, “Ŋko mba bigeŋ nɨɨeŋ kaŋgiap, ne ga nzuav nzai fhuvara. Ŋko gu mbɨrga mbɨ khɨnigeŋ, ŋko niŋgen mbegɨrie? Ee, ŋko gu ruarga mbɨ shirɨ, ŋko vhɨra ana ruagirie?” ");
INSERT INTO geb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Mani ana ŋgarkarav khaŋ nzuai, “Ahaŋ, ŋka tuktɨgi.” Mani maaŋ nzuaim, Zisas mbaram khaŋ mani ga nzuai, “Ŋko gu mbɨrga mbɨ khɨnigeŋ, ŋko niŋgen mbɨrga. Ŋko gu ruarga mbɨ shirɨ, ŋko vhɨra ana ruarga. ");
INSERT INTO geb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ŋko mba na guva hareŋ gum na ŋkɨn haren pigɨ za nzai ne, ne na bigɨn fhuvara. Mba ŋani Fhe Bakɨme bigɨn ma. Ana mba ŋani pigɨrga gumgi, ana mbe kaŋgiap, mbe ndi muuŋgi ŋani ma.” ");
INSERT INTO geb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Zems gu Zon nen Zisas ga suaŋgim, ana mba farasegi phɨkthɨgi ŋaara gumgi mba kameŋ mbararagiap, mbe ne nzuav zam Zems gu Zon ga vhegi. ");
INSERT INTO geb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mbe Zems gum Zon ga vhegim, Zisas mbaram mben kamgim, mbe ana han zim, ana mbe fugap, khaŋ mbe nzuai, “Nde kaŋgi, harigi ŋgui gumgi, mbe won gumgi gu mbigi gari gumgir pani kav, mbe guigira wo gumgi gu mbigi gari. Mbe guigira mben piin kɨv, mbe zɨri ndiv vun kuamkuargane, mbe ne vuzvugi. Mben gumgi bakɨvi, khaŋ tɨgav havhargia mbe buni mbarara nta zɨn ŋgɨr zav mbe gumgi gu mbigi ga nzuai. ");
INSERT INTO geb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","“Gu nde nzuai, mba tɨv nden kɨ thari. Guma the nde rɨgar zɨ bakɨme kɨ saŋv, ana za wo mbevav nde ŋaara guma kɨri. ");
INSERT INTO geb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Guma the vhɨra nde rɨgar fharav kɨr saŋv, ana za wo mbevav, za fhura kha gumgir ŋaara guma kɨri. ");
INSERT INTO geb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Fhe Bakɨme Guma Guar, ana vhɨra ana gumgi anan ŋgarɨ zav ana zɨgi fhuvara. Ana fhura gumgir ŋaara guma kɨr zav zɨgi. Ana fhura mben ŋaara guma kɨv, vhɨra mbe suaŋv rimgiv, taagi gumgi gu mbigi vhɨrve ga vhezgip, mbe ndir zav zɨgi.” ");
INSERT INTO geb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Zisas wo phorga rui gumgir kov, mbe ndav vo, Zerikon hegi. Mbe Zerikon hegap, Zisas wo phorga rui gumgi gum mba Zisas phorga ndai gumgi gu mbigi vhɨrve, mbe Zeriko thav vuim, rɨmani mbatɨgi guma Bartimeus, ana maaŋ ki. Bartimeus ana Timeusan kam ma. Ana mba tuap gaar perav kav, ŋkɨɨ ga nzuav, nzambara mbatɨgar gumgi ga mbui. ");
INSERT INTO geb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ana maaŋ perav kav mbararagim, mbe khaŋ nzuai, “Nasaret guma Zisas mbar zi.” Ana ne mbararagiap, kama bakɨmen kaav khaŋ nzuai, “Zisas, Devitan Kam, ndu nan korar muuŋ!” ");
INSERT INTO geb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ana maaŋ nzuaim, gumgi gu mbigi vhɨrve ana vhegap, khaŋ ana nzuai, “Ndu wo thɨni mpɨra.” Mbe maam ana nzuaim, ana khɨrɨvra kaav khaŋ nzuai, “Devitan Kam, ndu nan korar muuŋ!” ");
INSERT INTO geb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Zisas ana mbararagiap, thav thɨgap, khaŋ nzuai, “Anan kamgirim, ana zɨ.” Zisas ne nzuaim, mbe mba rɨmani mbatɨgi guman kaai. Mbe ana kaav khaŋ ana nzuai, “Ndu gor muuŋ thari. Ana ndun kaai. Ndu khavik!” ");
INSERT INTO geb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mba rɨmani mbatɨgi guma ne mbararara thav, mbaram mba rugaha shari sharige zorgiap, niŋge dagim, niŋge kɨga vov mbur rɨgi. Ana mbaram fega mbur mbarav thivav, Zisas han vui. ");
INSERT INTO geb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ana Zisas han vuim, Zisas anan nzarigi, “Gu ram ndun muuŋrie?” Mba rɨmani mbatɨgi guma khaŋ ana nzuai, “Rabai, ndu na rɨmanin muuŋgirim, ni nzera.” ");
INSERT INTO geb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Zisas mbaram khaŋ ana nzuai, “Ndu ŋgɨ. Ndu Fhe Bakɨme ŋkasŋka khothɨgav, ndu taagia nzerigi.” Zisas ne nzuavra thagim, ana rɨmani fhura ŋgarav nzerigim, ana tuituigia bigi gari. Ana garav Zisas phorgav mba tuavar vui. ");
INSERT INTO geb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Zisas Zeriko sharav, wo phorga rui gumgir kov mbe Zerusareman ndai. Mbe ndav vov, Zerusarem han mbav, Oriv mbɨkshɨma han ki ŋgu bisanenin hɨgi, Betani gum Betfage. Mbe mba ŋgunin hɨgap, Zisas wo phorga rui guma phuni ga sarav khaŋ mani ga nzuai, “Ŋko ŋgɨp, mbu fhara ki ŋgu bisanen ŋgɨri. Ŋko ŋgɨp, ŋgun vhen ŋgirɨvra, ŋko za ganɨnga, mbe doŋki ŋgugar kama mbevi ndi thɨrigi ana ki. Guma the fhum mba doŋki ŋguga kama ruigi fhuvara. Ŋko ana mpiiŋ fhɨrgip, ana ndigi zɨri. ");
INSERT INTO geb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Guma the ŋko gangip khaŋ ŋko suanga ‘Ŋko maaŋ ram mbui?’ ŋko khaŋ ana suaŋri, ‘Guma Bakɨme ŋaar anan ki, ana vhemkora ana ndigi taagi zɨrga.’ ” ");
INSERT INTO geb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Ana maaŋ mani ga suaŋgim, mani vui. Mani vov, mba ŋgun hav garim, mba doŋki ŋgugar kam kɨrar tuavra mbe phena thɨma kamanin thɨrav ki. Mani mbaram ana mpiiŋ fhɨri. Mani ana mpiiŋ fhɨrim, gumgi mbari maaŋ thivgiav kav khaŋ mani ga nzuai, “Ŋko maaŋ ram mbuav, mba doŋki ŋgugar kaman mpiiŋ fhɨri?” ");
INSERT INTO geb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Mani mbe ŋgarkarav mba Zisas mani ga suaŋgi kamen mbe nzuai. Mbe mbaram fhura mani garim, mani ana fhɨrgiap, ana ndiga vui. ");
INSERT INTO geb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mani ana ndiga vov, Zisas han vugap, mbaram mbe wari wo rugahav shari shagi zorgiap, mba doŋki ŋguga kama kɨra suegim, Zisas mbaram ndav, ana tɨ perigi. ");
INSERT INTO geb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Zisas mba doŋki ŋguga kama tɨ perav, mbe ndai. Mbe ndaim, gumgi vhɨrve mbe wari wo rugahav shari shagi zorav, tuap ga sɨgi. Gumgi mbari ruan khira ŋgagi gorav, zav, tuap ga sɨgim, Zisas nta tɨn ndai. ");
INSERT INTO geb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ana nta tɨn ndaim, gumgi mbari ana nɨman fharigim, mbari ana zɨn kav, kaav khaŋ nzuai, “Hosana!” “Nza Fhe Bakɨmen ndikndigi. Ana tɨvar vhuun kha guman muunga, ana Fhe Bakɨme nduara ana sarigi ana zɨgi. ");
INSERT INTO geb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Ana nza nzɨga Devitran nzɨk ma. Ana ntige nzan guman pan kɨrga. Fhe Bakɨme tɨvar vhuuŋra anan muuŋrim, ana nza ganɨnga. “Hosana! Nza ne suaŋv Fhe Bakɨme ndikndigɨp nza ne suaŋv Fhe Bakɨme zɨ ndi vu guarara kuamkuarga!” ");
INSERT INTO geb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Zisas ndav vov Zerusareman hɨgap, mbaram vov Fhe Bakɨme phena bɨna vhen vergap, ana vhen mba bigi ana za nta gara ruigi. Ra verav vhɨzgim, ana wo farasegi 12 thɨgi ŋaara gumgir kov, mbe taagia Betanin vergi. ");
INSERT INTO geb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mbe verav, Betani ga kuigap, mɨtimanera mbe taagia khavgiav, Zerusareman ndai. Mbe ndav, Zisas thɨhegi. ");
INSERT INTO geb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ana thɨhegap, mbe ndav ana samra fik khage garim, niŋge thɨgav ki. Ana niŋge garim, niŋge khovgim, ana khaŋ nzuai, “Niŋge vhɨgi mbarigi thi?” Ana ne ndɨkndɨga vov niŋge garim, niŋge vhɨgi mbarigi fhu, fari khɨnira. Khe fik khira vhɨgi mbai tuk fhuvara. ");
INSERT INTO geb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ana niŋge gangia thav, mbaram khaŋ mba fik khage nzuai, “Guma the taagip ndun vhɨgar mbegɨrga fhu.” Ana ne nzuaim, ana phorga rui gumgi ne mbararagi. ");
INSERT INTO geb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ana maaŋ mba fik khage suaŋgiap, mbe nda vov, Zerusareman hegi. Mbe hegap, Zisas vov Fhe Bakɨme phena bɨna vhen vergap, mba bigi ga vhezav, bigi ndi mbai gumgi zɨtɨgap, mbe ndi kɨrar mbai. Ana mbe ŋkɨɨar kurkurigi kaagi, ana nta siasuav, mbe korigi ndi mbai gumgir mpirmpirɨgi ana vhɨra nta siasui. ");
INSERT INTO geb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ana maaŋ mbe mbuav vhɨra mbe bigɨn the ndigiv fhura Fhe Bakɨme phena bɨna vhee mbugu ŋgirɨrganen mbe thɨvigi. ");
INSERT INTO geb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ana maaŋ mbe muuŋgiap, mbaram Fhe Bakɨme buni vhuuin mbe nzuav, khaŋ mbe nzuai, “Fhe Bakɨme buni vhuuiŋ ki gavar Fhe Bakɨme khaŋ nzuai, ‘Na phen mbe kha zɨn anan rɨgɨrga, za kha nuianan ki ŋgui bakɨvi zɨv na phorgɨv suanga phen ma.’ Nde maaŋ ana muuŋgi fhuvara. Nde kha tɨvar ana mbuim, ana kɨɨi gumgi zomzori ŋaneŋ fara muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ana ne suaŋgim, mba Fhe Bakɨmen rotu gari gumgir pani gum Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi, mbe ana shogiri ana rimgirga tuavi ndi gari. Mbe vhɨra anan rivgi. Mbe garim, gumgi gu mbigi vhɨrve za ana buni mbararav, ŋgava mbatɨga mbui. ");
INSERT INTO geb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Zisas maaŋ kav mbe nzuav kim, ra verav vhɨzim, ana wo phorga rui gumgir kov, mbe mba ŋgu thav kɨrar hegi. ");
INSERT INTO geb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Zisas mba mɨtimanera taagia wo phorga rui gumgir kov, mbe taagia mba tuavar ndav, mba fik khage garim, niŋge za nzɨɨ vov, bira phorga shɨɨŋgi. ");
INSERT INTO geb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Mbe niŋge garav, Pita mba Zisas mba fik khage suaŋgi ne ndɨkndɨk suiravra kav, khaŋ Zisas ga nzuai, “Rabai, ndu ganɨ! Ndu gurum mbu fik khage ruma mbuav niŋge suaŋgim, niŋge za shɨɨŋgi!” ");
INSERT INTO geb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Pita ne nzuaim, Zisas ana ŋgarkarav, khaŋ nzuai, “Nde Fhe Bakɨme ŋkasŋka khothivɨri. ");
INSERT INTO geb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Gu guigira nde nzuai, guma the khaŋ kha mbɨkshɨma suanga, ‘Ndu khaŋ thav sigiv, ŋgɨv, wo fegɨ mbasɨk khɨnik,’ mba guma ndɨkndɨga baviran muuŋv, Fhe Bakɨme ŋkasŋka khothɨgɨp, khaŋ suanga, ‘Gu ntige kha nzuai bigeŋ, nan hɨgɨrga,’ ana maaŋ suanga mba bigeŋ guigira anan hɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Gu maaŋ muuŋgia nde nzuai, nde Fhe Bakɨme ŋkasŋka khothivɨv bigɨn the suaŋv, Fhe Bakɨmen nzanga, ana mba nde nzai bigɨnan nden nɨɨŋgirga. ");
INSERT INTO geb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","“Nde Fhe Bakɨme phorgɨv suaŋv, nde harigi ntɨɨri nde muuŋgi tɨvi mbatɨgi ndɨkndɨk suiravra kɨv, nde nta vhɨzgiri. Nde maaŋ muuŋgirga kha Hevenan ki Fhe Bakɨme, nde muuŋgi tɨvi mbatɨgi vhɨzgirga.” ");
INSERT INTO geb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Zisas wo phorga rui gumgir kov, mbe taagia nda vov Zerusareman hegi. Mbe hegav, Zisas vov Fhe Bakɨme phena bɨna vhen vergap, thiva ruav ki. Ana ruav kim, Fhe Bakɨme rotu gari gumgi pani gum, Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi mbari gum, mben gumgi ruu mbari, mbe Zisas han zi. ");
INSERT INTO geb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Mbe Zisas han zav, anan nzarigi, “Ndu ram muuŋgi ŋkasŋka kav kha bigi ga mbui? The mba ŋkasŋka ndu nɨɨŋgi?” ");
INSERT INTO geb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Mbe ne nzuaim, Zisas mbe ŋgarkarav, khaŋ mbe nzuai “Gu bigɨna thueŋ ga suaŋv nden nzararga. Nde ne ŋgarkararim, gu za the kha ŋkasŋka na nɨɨŋgim, gu kha bigi ga mbui, ne bun nde suanga.” ");
INSERT INTO geb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ana nen mbe suaŋgiap, mben nzarigi, “The mba gumgi ruar zav Zon Gumgi Ruai Guma ga sarigim, ana zɨgi? Fhe Bakɨme o, kha nuiana gumgi? Nde na suaŋ.” ");
INSERT INTO geb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ana mben nzarigim, mbe nen warira nzuav, khaŋ wari ga nzuai, “Nza khaŋ suanga, ‘Fhe Bakɨme ma,’ ana taagi khaŋ nza suanga, ‘Maamgia, nde ram muuŋgiap ana khothivi fhu?’ ");
INSERT INTO geb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Maaŋgi nza khaŋ suanga, ‘Kha nuiana gumgi han.’ ” Mbe wo buni vhɨzgi fhuvara. Mbe kha gumgi gu mbigi vhɨrver rivgi. Mbe kaŋgi, kha gumgi gu mbigi za Zon Gumgi Ruai Guma kaŋgi, ana guigira Fhe Bakɨme kamthooŋ guma ma. ");
INSERT INTO geb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mbe maaŋ muuŋgiap, Zisas ŋgarkarav khaŋ nzuai, “Nza kaŋgi fhu.” Mbe maaŋ nzuaim, Zisas khaŋ mbe nzuai, “Maaŋ muuŋgi, gu the kha ŋkasŋka na nɨɨŋgim, gu kha bigi ga mbui, gu ne nɨɨeŋ bun nde suaŋgirga fhu.” ");
INSERT INTO geb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Zisas mbaram vhunaa ga si bunin mba Fhe Bakɨme rotu gari gumgi pani gum, Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi mbari gum, mba Zudaiŋ gumgi ruu mbari ga nzuai. Ana khaŋ mbe nzuai, “Guma mbe wo wain mɨnan pargi. Ana anan pargiav, mbaram ŋkɨɨ ndigap, ana bɨna vhuigap, mbaram wain numup nta phooŋ ndir zav kɨman mbok korgi. Ana mba mbok korgiap, mbaram mba wain mɨna ganɨv kɨrga gumgi ga nzuav, vun mbar ndagi phena muuŋgi. Ana mba phena muuŋgiap, mbaram mba wain mɨna ganɨv ana shɨgar muunga gumgi, ana mba wain mɨnan mbe farve khɨngi. Ana ana mbe farve khɨngiap, mbe thav, saman ki ŋgun vugi. ");
INSERT INTO geb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ana vuga kim, mba gɨvigi tuk hɨgi. Mba gɨvigi tuk hɨgim, ana wo ŋaara guma mbe sarigim, ana mba mɨna garav, ana ŋgari gumgi han vui. Ana wo khɨnan wain ndir zav ana sarigim, ana vui. ");
INSERT INTO geb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ana vuim, mbe ana suirap, hor mbatɨgar ana muuŋgiap, ana sarigim, ana fhura taagia vugi. ");
INSERT INTO geb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ana vugim, mba mɨna namkam thav, mbaram harigi ŋaara guma mbe sarigim, ana mbe han vugi. Ana vugim, mbe ana shogim, ana vhɨra sharagerɨgi. Mbe ana mbergi fhu. Mbe vhɨra muunga tɨvir ana muuŋgi fhuvara. Mbe tɨva mbatɨga guarara ana muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mba mɨna namkam thav, harigi ne sarigi. Ana vuim, mbe vhɨra ana shogim, ana rimgi. Ana maaŋ mbuav wo ŋaara gumgi vhɨrvera sasarigim, mbe vegi. Mbe vegim, mbe mba tɨvara mbe mbuav, hor mbatɨgar mbari ga mbuav, mbari shogim, mbe vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ana ntige thav garim, guma bavira ana han ki. Mba guma, ana kama gɨrgɨr ma, ana guigira ana vuzvugi. Ana thav mpuur zɨ guarara ana sarav, khaŋ nzuai, ‘Khe nan kam ma, mbe ana piin kɨrga.’ ");
INSERT INTO geb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ana ne suaŋgiap ana sarigi. Ana ana sarigim, ana vuim, mba mɨna garav anan ŋgari gumgi ana gangiap, khaŋ wari ga nzuai, ‘Kha mɨna namkaman kam wo ndia ŋana ndigiv wo ndia bigi ndir zav mbur zi. Aria, nde zɨ. Nde zɨp, nza ana shogiri, ana rimgirim, nza kha mɨna vuavi mbuiarga.’ ");
INSERT INTO geb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mbe ne suaŋgiap, ana suirav, ana shogi ana rimgim, mbe ana khuma fegap, mba mɨna bɨna kɨra khɨngi. ");
INSERT INTO geb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Mba wain mɨna namkam ntige ram muuŋrie? Ana ntige zɨv, mba wain mɨna garav anan ŋgari gumgi shogirim, mbe vhɨzgirim, ana mba mɨnan harigi gumgir nɨɨŋgirim, mbe ana ganɨv anan ŋgarɨrga. ");
INSERT INTO geb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Nde kha Fhe Bakɨme buni ki gavar kha buneŋ gangi fhuve? ‘Mba pheni ga mbui gumgi, mbe mba kɨma garav khaŋ ana nzuai, “Ana kɨma mbatɨk ma.” Mbe maaŋ nzuai kɨm, ana ntige mba phena suirigim, ana thɨgi. ");
INSERT INTO geb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Fhe Bakɨme ntige ana muuŋgim, nza ana garim, ana guigira bigɨna bakɨ ma.’ ” ");
INSERT INTO geb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Zisas mba bunin mbe nzuaim, mba Fhe Bakɨme rotu gari gumgir pani gum, mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi mbari gum, mben gumgi ruu mbari, mbe Zisas suigɨr zav tuavi ndi gari. Mbe ana kaŋgi ana mben vhunamara si. Mbe ana suigɨr za mbuav, mbe vhɨra kha gumgi gu mbigir vhɨrver rivgiav, wari ana suigɨ thav wari ana thav vegi. ");
INSERT INTO geb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mbe vegap, zumgum Fherasiŋ mbari gum Herot gumgi mbari ga sarigim, mbe Zisas han zi. Mbe zegɨp, anan panɨv, ana buni mbarararga. Ana pham buna thueŋ suaŋgirim, mbe ne nzuav ana suira zav wari zegi. ");
INSERT INTO geb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mbe ana han zegap, khaŋ ana nzuai, “Ndɨkndɨgi vhuuin nza khɨvi guman rum, nza kaŋgi, ndu guigira buni guari nzuai guma ma. Ndu mba tɨva bavira za kha gumgi ga mbui. Ndu guma bakɨme gum bisaneŋ, zɨ ki guma gum, zɨ ki fhup guma, ndu za mba tɨvara mbe mbui. Ndu guigira Fhe Bakɨme mbe muungeŋ vuzvugi tɨvir vhuuiŋra mbe khɨvav, buni guarira mbe nzuai. Ndu khar nza suaŋ, nza ŋkɨɨr Sisar ndɨɨi ne nzerarame? ");
INSERT INTO geb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","“Ee nza nɨɨŋrie, ee, fhuve?” Mbe ne nzuaim, Zisas mbe kaŋgi, mbe thɨn kaman ne nzuai. Ana thav, khaŋ mbe nzuai, “Nde thaŋ nzua nan panɨ za mbui? Nde mba kɨma raraŋ thueŋ ndigi na ndi zɨrim, gu ne ganɨnga.” ");
INSERT INTO geb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ana ne mbe nzuaim, mbe kɨma raraŋ mueŋ ndiga zav ana nɨɨŋgim, ana mben nzarigi, “Then tum khare? Mbe the zɨ khergi ana khare?” Mbe ana ŋgarkarav khaŋ nzuai, “Sisar ne ma.” ");
INSERT INTO geb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Zisas thav khaŋ mbe nzuai, “Sisar bigɨn, nde anan Sisar nɨɨŋri. Fhe Bakɨme bigɨn, nde anan Fhe Bakɨmen nɨɨŋri.” Ana ne mbe nzuaim, mbe ne mbararagiap ana nzuav, ŋgava mbatɨga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Zisas mba bunin mbe phorga nzuav kim, Sadusiŋ gumgi mbari buna mueŋ nzuav Zisasan nzan zav ana han zi. Mbe Sadusiŋ, mbe khaŋ nzuai ntɨɨri ma, guma rimgip taagi khavgirga fhu. ");
INSERT INTO geb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Mbe mbari Zisas han zegap, khaŋ ana nzuai, “Ndɨkndɨgi vhuuin nza khɨvi guman rum, Moses fhum nza nzuav khergi kameŋ khaŋ nzuai, ‘Guma the muun tɨgɨv, kɨv kɨrim, anan muuŋ ana gon tara the tegɨrga fhu, mba guma fhura rimgirga, mba guman ŋguk anan muun sɨɨn tɨgɨv, ana tegɨrga tari, mbe anan fega zɨrarga.’ ");
INSERT INTO geb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nza ntige maaŋ muuŋgi harathɨgi fegi gu ŋgugi kegi. Mben fek fharav mba mbiga tɨgim, ana ana gon tara the tegi fhu, ana fhura rimgi. ");
INSERT INTO geb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ana rimgim, mba fegra thɨgi ne, anan ŋguk ana anan nima tɨgi. Ana ana tɨgap, mbara muuŋgi, ana ana gon tara the tegi fhu, ana fhura rimgi. Ana rimgim, mba ŋguga khegene, anan nima tɨgav, ana mbara muuŋgi, ana ana gon tara the tegav rimgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mba harathɨgi fegi gu ŋgugi za mba tɨvara muuŋgi. Mba mbik mbe gon tara the ndigim, mbe vhɨzgi fhuvara. Mbe za vhɨzgim, mba mbik mpuur mbe zɨn rimgi. ");
INSERT INTO geb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nza khueŋ kaŋgi za mbui. Mba vhɨzgi gumgi gum mbigi taagi khavɨrga tugen, mbe khavgirim, mba mbik ana then muuŋ kɨrie? Nza kaŋgi, mba mbik harathɨgi gumgi ga tɨga kegi.” ");
INSERT INTO geb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Mbe ne nzuaim, Zisas mbe ŋgarkarav, khaŋ mbe nzuai, “Nde guigira pham nzuai. Nde khaŋ muuŋgiap, nde Fhe Bakɨme buni vhuuiŋ, nta ana gavar ki, nde nta kaŋgi fhuvara. Nde vhɨra Fhe Bakɨmen ŋkasŋka kaŋgi fhuvara? ");
INSERT INTO geb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nde mbarara, mba vhɨzgi gumgi gu mbigi, mbe taagi khavgip, mbe taagip mani gum mburi warir rɨgɨrga fhuvara. Mbe Fhe Bakɨme enseri farar muuŋgip, ana han Hevenan kɨrga. ");
INSERT INTO geb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Nde mbarara, gu ntige gumgi vhɨzav taagia khavi ne bun nde suanga. Nde mba Moses khergi buni, nta ana gavar kim, nde nta gangi fhuve? Ana mba buni kherav, mba kha bisaneŋ vhav ne thɨga shi ne neŋgegi. Mba kha bisaneŋ vhav ne thɨgav shim, Fhe Bakɨme khaŋ Moses ga nzuai, ‘Gu Abraham gum, Aisak, Zekop, gu mben Fhe Bakɨme ma.’ ");
INSERT INTO geb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mba vhɨzgi ntɨɨri, mbe vhɨzgiap, za vhɨzgi fhuvara, mbe vhɨzgia vov Fhe Bakɨme phorga ki. Ana mbe Fhe Bakɨme gum mba vhɨzgi fhuv ntɨɨri, ana vhɨra mben Fhe Bakɨme ma. Nde ndɨkndɨgi pham guarara vegi.” ");
INSERT INTO geb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mba Sadusiŋ gumgi mba bunin Zisas phorga nzuav ana dav kim, Zudaiŋ tɨvi vhuuiŋ kaŋgi guma mbe zav, Zisas mbararagim, ana ŋgarkar vhuuŋra mbe buni ga mbuim, ana mbaram, Zisasan nzarigi, “Maaŋgi tɨv, ana za kha tɨvi kambarav fharigi?” ");
INSERT INTO geb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Zisas mbaram, ana ŋgarkarav khaŋ ana nzuai, “Mba za kha tɨvi kambarav fharigi tɨv khare. ‘Nde Isreriŋ, nde thukhingira khueŋ mbararagiri. Fhe Bakɨme, ana nduara nza Fhe Bakɨme ma. ");
INSERT INTO geb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ndu guigira wo ndavar anan nɨɨŋgip, ana vuzvugip, wo tum gum, ndɨkndɨk gum, ŋkasŋkar anan nɨɨŋgiri.’ ");
INSERT INTO geb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kha fharigi tɨvara ndegi tɨv khare, ‘Ndu wo vuzvugi tɨvara, ndu harigi ne vuzvugiri.’ Kha tɨvani, ni guigira harigi tɨvi kambarigi, tɨva bakɨni ma.” ");
INSERT INTO geb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mba guma ne Zisasan nzarav, wom khaŋ nzuai, “Ne nzerara ndɨkndɨgi vhuuin nza khɨvi guman rum. Ndu nzerara suaŋgi. Fhe Bakɨ bavira ki, harigi Fhe Bakɨ the, ana phorga ki fhuvara. ");
INSERT INTO geb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ndu guigira wo ndavar Fhe Bakɨmen nɨɨŋv ana vuzvugɨv, wo ndɨkndɨk gum, ŋkasŋka gum, ndu vhɨra wo vuzvugi tɨvara, ndu harigi ne vuzvugiri. Mba tɨvani, ni guigira kha Fhe Bakɨme nzuav shama mbuav mpooi sɨgi ga mpooi ne kambarav, vhɨra Fhe Bakɨme nzuav shama mbuav shogi shɨgi kambarigi.” ");
INSERT INTO geb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Zisas ana mbararagim, ana ndɨkndɨga vhuuŋra kav, nzerara ana ŋgarkarigim, Zisas khaŋ ana nzuai, “Ndu Fhe Bakɨme wo gumgi gu mbigi garim, mba ana piin ki ntɨɨri, ndu mbe phorgɨ kɨrga tuavra thɨgi.” Zisas maaŋ ana suaŋgim, mba gumgi gu mbigi harigi bigi ga suaŋv anan nzangen rivgi. ");
INSERT INTO geb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Zisas mba Fhe Bakɨme phena bɨna vhen kav, Fhe Bakɨme buni vhuuiŋ gumgi gu mbigi vhɨrve ga nzuav kav mben nzarigi, “Mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi thaŋ nzuav, khaŋ nzuai, ‘Krais, ana Devitan Kam ma?’ ");
INSERT INTO geb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi ne nzuai. Devit nduara Fhe Bakɨme Ŋina Ŋaar ndɨkndɨgar ana ndɨɨim, ana khaŋ nzuai, ‘Fhe Bakɨme khaŋ na Guma Bakɨme nzuai, “Ndu na guva haren perav kɨrim, gu ndu pana gumgi ndim, ndu ŋkarve piiŋ khɨngirga.” ’ ");
INSERT INTO geb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Khe Devit nduara anan kaai zɨ khare, ‘Guma Bakɨme’. Ana Guma Bakɨmen anan kamɨvra kɨrim, ana ram muuŋgip anan kam kɨrie?” Zisas ne nzuaim, maaŋ ki gumgi gu mbigi vhɨrve ne mbararagia ndikndiga mbatɨga mbui. ");
INSERT INTO geb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Eke, nde tuituigira mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi ganɨri. Mbe wari ndi vun kuamkuav, shagi mpeeŋmpeeŋra shari. Mbe khueŋ vuzvugi, mbe mba phogi ga vhui ŋanin ŋgɨrim, mba gumgi gu mbigi mbe phorgɨ suaŋv mben ndikndigɨrgane vuzvugi. ");
INSERT INTO geb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mbe vhɨra mba Fhe Bakɨme buni mbararagi phenin, fharav ŋani vhuuiŋra pigɨrgeŋ vuzvugi. Mbe vhɨra shaar tugir, mbe zɨ ki gumgi pi ŋanira pigɨrgeŋ vuzvugi. ");
INSERT INTO geb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mbe vhɨra kha tɨvi ga mbui, mbe mani vhɨzgi ndir mbigi, mbe mbe guiguigiav, mbe pheni kɨɨv, fhura thɨn kaman Fhe Bakɨme phorga nzuav, buni mpeeiŋ nzuai. Mbe zumgum Fhe Bakɨme mbe muuŋgi tɨvi ga suaŋv mbe suanga tugar, mbe guigira zaa mbatɨga guarira ndigirga.” ");
INSERT INTO geb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Zisas mba Fhe Bakɨme phena bɨna vhera kav, mbe mba Fhe Bakɨme ndiv ŋkɨɨ ndi sui kovsɨgi han muaiŋ kovan perav ki. Ana perav kav garim, gumgi gu mbigi vhɨrve za wari wo ŋkɨɨ ndi mba kovsɨgi ga sui. Ana garim, ŋkɨɨ kɨvgia ki gumgi zav, ŋkɨɨ vhɨrvera ndi sui. ");
INSERT INTO geb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ana kav garav kim, bigi sosuagi mana rimgi nima mbe zi. Ana zav, kɨma raraŋ hɨva mpuneni ndi khɨngi. Mba kɨma raraneni mba bisanera vhezgirga tuktɨgi. ");
INSERT INTO geb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Zisas ana gangiap, mbaram wo phorga rui gumgir kamgiap khaŋ mbe nzuai, “Gu guigira nde nzuai, kha bigi sosuagi mana rimgi nim, ana kha kovsɨk khɨngi ŋkɨɨa, nta guigira kheiŋ suegi ŋkɨɨ kambarigi. ");
INSERT INTO geb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kha gumgi gu mbigi, mbe ŋkɨɨa vhɨrve kav, mbe ŋaar ki fhuv ŋkɨɨa, mbe nta ndi za sui. Kha mbik fhuvara. Ana mba ki nɨne, ana za ne ndiga za khar khɨngi. Ana ntige wo ndi mba vhezɨrga ŋkɨɨa ki fhu. Ana mba mba vhezɨrga ŋkɨɨa ana za nta ndiga za suegi.” ");
INSERT INTO geb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Zisas Fhe Bakɨme phena bɨna tha kɨrar him, ana phorga rui guma mbevi khaŋ ana nzuai, “Ndɨkndɨgi vhuuin nza khɨvi guma rum, ndu khar ganɨ. Kha pheni ga muuŋgi ŋkɨɨ guigira kɨvgi. Ntan muuŋgi pheni guigira kɨvgi.” ");
INSERT INTO geb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Zisas ana ŋgarkarav khaŋ nzuai, “Ndu kha muuŋgi pheni bakɨvi garire? Kha pheni ga muuŋgi ŋkɨɨ, nta khara muuŋgip wari tɨɨrin naaŋgi kegɨrga fhuvara. Mbe nta phɨrɨv, za nta fu nɨɨaŋ suegɨrga.” ");
INSERT INTO geb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mbe Fhe Bakɨme Phena thav vov, Zisas Oriv mbɨkshɨman ndaga perav ki. Ana kav, muen Fhe Bakɨme Phena garim, ana thɨgav ki. Ana perav kim, Pita, Zems, Zon gum, Andru, mbe nduarira ana han zav anan nzai, ");
INSERT INTO geb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ndu nza suaŋ, mba bigi maaŋgi tugar hɨrie? Thagɨna bigɨn hɨgɨrim, nza ana gangip kaŋgirie? Mba bigi ntige khar hav, nta ntige mba ti.” ");
INSERT INTO geb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Zisas khaŋ mbe nzuai, “Nde tuituigira ganɨri. Guma the nde guigip, nde ndi tuap mbatɨgar farga. ");
INSERT INTO geb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Gumgi vhɨrve zɨv na zɨn warir rɨgɨp, khaŋ suanga, ‘Gu ana ma.’ Mbe maaŋ suaŋv gumgi vhɨrve guiguigɨp, mbe ndi tuap mbatɨga suegɨrga. ");
INSERT INTO geb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Nde vhɨra hanera gum samra ntari kaa mbararav, wari rɨvɨv, ŋgava mbatɨgar muuŋ thari. Mba khesharigi bigi, nta hɨrga, kha nuianan ki bigi za vhɨzɨrga tuk hɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nde vhɨra mbarararga, ŋgu bakɨm the khavgiv harigi ŋgu bakɨm the phorgɨv shogɨrga. Ŋgui gari guma bakɨm the piin ki ntɨɨri khavgiv, harigi ŋgu gari guma bakɨm piin ki ntɨɨri phorgɨv shogɨrga. Nde vhɨra mbarararga, khɨmkhɨk tamtam mba ŋguir hɨrga. Ŋgui thari mba tivɨv thir vhɨzɨrga. Kha khesharigi tɨvi, nta mbik fhara tara tɨr zav ndi zaa farar muuŋgip fhara hɨrga. ");
INSERT INTO geb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Mba tɨvi hɨrim, nde tuituigira wari ganɨri. Gumgi thari nde ndigip, ŋgɨv ŋgu gari gumgi han ŋgɨgɨrga. Gumgi thari Fhe Bakɨme buni mbararagi phenir hor mbatɨgar nden muunga. Gumgi thari nde ndim ŋgui gari gumgi bakɨvi gum ŋgui vhɨrve za gari gumgi bakɨvi nɨman fɨv, nde ndiv suanga. Mbe na zɨ suaŋv mba tɨvir nden muunga. Nde mbe nɨman thivɨv, mba nden hegi bigi bun mbe suanga. ");
INSERT INTO geb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mbe kha Fhe Bakɨme bunin vhuuiŋ mbe fharav ntan za kha ŋgui bakɨvi ga suaŋgirga. ");
INSERT INTO geb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mbe maaŋgi tugar nde suirav, nde ndigi ŋgɨv, nde suaŋrim, nde suanga buni ga suaŋv ndɨkndɨgi vhɨrver muuŋv rivɨ thari. Nde mba tugar Fhe Bakɨme suan zav nde nzuai buni, nde mba bunira mbe suaŋri. Nde mba tugen nzuai buni, nde wo ndɨkndɨgir nzuai fhuvara. Fhe Bakɨme Ŋina Ŋaar mbar nzuai. ");
INSERT INTO geb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Mba tugivigen fegi gu ŋgugi warira thuuŋ domdorɨv, warira shogɨr saŋv, wari ndi mbur nɨɨnga. Ndegi won tari, mbe warira thuuŋ domdorɨv, warira shogɨr saŋv mbe ndi mbur nɨɨnga. Tari vhɨra wari wo ndegi gu ndegmbori ndav shiv, rɨɨŋrɨɨŋv mbe shogɨr saŋv mbe ndi mbur nɨɨnga. ");
INSERT INTO geb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nde na zɨn vui ne suaŋv kha gumgi za nde sararga. Mba thɨga havhargi guma, ana kɨv rimgirga, Fhe Bakɨme zazera mbara muuŋgia ki bɨɨŋbɨɨn anan nɨɨŋgirga.” ");
INSERT INTO geb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Zisas mbe nzuav, khueŋ phorga mbe nzuai, “ ‘Nde ganɨrim, mba bigi farfagi bigɨna mbatɨk mbe, ana thɨvigi ŋaneŋ, ana ne thɨgɨrga.’ Mba gava gari guma khueŋ kaŋgiri, mba tugar mba Zudia fhain ki gumgi gu mbigi, mbe rɨva ŋgɨv mba mbɨkshɨɨr ndari. ");
INSERT INTO geb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Guma the wo phena vunkaman kegɨp, taagip wo phena ŋgirɨv wo bigi ndir saŋv muuŋ thari. ");
INSERT INTO geb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Guma the wo mɨnan kegɨp, taagi ŋgɨ wo rugaha shari shaage ndir saŋv ŋgɨ thari. ");
INSERT INTO geb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mba tugir, mba ndavir ki mbigi gum tari ririvi ki mbigi, mbe tuga mbatɨga ndigirga. ");
INSERT INTO geb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nde Fhe Bakɨme phorgɨ suaŋri, mba bigeŋ kun tugar hɨ thari. ");
INSERT INTO geb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ne khaŋ muuŋgi, mba tugir gumgi gum mbigi guigira tuga mbatɨga ndigirga. Fhum guarara, Fhe Bakɨme za kha bigi ga muuŋgim, mbe maaŋ muuŋgi tuga mbatɨga the ndiga kav kav, zav ntige kha tuga mbatɨga ndi fhuvara. Kha tuga mbatɨk mben hɨgɨrga, mbe wom maaŋ muuŋgi tuga mbatɨga the ndigirga fhuvara. ");
INSERT INTO geb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Fhe Bakɨme kaŋgi, ana mba tugi gorɨ tivɨ thakake, guma the kegɨrga fhu. Ana mba won mbuigi gumgi gum mbigi ga ndɨrgap mba tugi gorgi. ");
INSERT INTO geb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Mba tugivigen guma the khaŋ nde suanga, ‘Nde khar ganɨ, Kraisra khare! Nde mbur ganɨ, ara mbure.’ Nde mba guma nzuai nei khothivɨ thari. ");
INSERT INTO geb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Gumgi thari hegɨp, guiguigɨp khaŋ suanga, ‘Gu Krais ma.’ Thari hegɨp guiguigɨp khaŋ suanga, ‘Gu Fhe Bakɨme kamthooŋ guma ma.’ Mbe maaŋ suaŋv mirikor gu ŋkasŋka ki bigin muunga. Mbe mba bigir muunga ŋkasŋka ki. Mbe maaŋ muuŋv mba Fhe Bakɨme won mbuigi gumgi gu mbigi guiguigɨv, mbe tuarar muuŋgirga. ");
INSERT INTO geb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mbe maaŋ muuŋrim, nde tuituigira wari ganɨri. Gu fharav za mba zumgum hɨrga bigi bun nde suaŋgi. ");
INSERT INTO geb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Mba tugir ŋgɨv, gumgi gu mbigi guigira tuga mbatɨga ndirim, Maaŋ gɨngirga, ra shɨrarga fhu. Kɨni vhɨra shɨrarga fhuvara. ");
INSERT INTO geb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mbu buivar ki ŋkaa za korɨ nɨɨaŋ regɨrga. Mba buivar ki bigi, nta vhɨra fhum kegi tɨvar muuŋgirga fhuvara, nta za wari ŋgavɨzgirga. ");
INSERT INTO geb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Mba tugar gumgi gu mbigi Fhe Bakɨme Guma Guara ganɨrim, ana buiva huran zirɨrga. Ana wo ŋkasŋka bakɨme gum wo ŋkasŋka vhava ŋaara phorgɨv zirɨrga. ");
INSERT INTO geb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ana mba tugen wo enseri ga sararim, mbe ŋgɨ kha nuianan fethɨgi khoriŋ, mbe za ntan ŋgɨp, ana mba won mbuigi gumgi gu mbigi fugfugɨrga. Mbe kha nuianan ki ntɨɨri, mbe za mbe ndigirga. ");
INSERT INTO geb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nde ntige kha fik khage muuŋgi ne gangip kaŋgiri. Nde mba fik khage ŋgagi garim, nta wom mbɨ ndiap, taagia khovi. Nde maaŋ muuŋgia gangiap kaŋgi, ra thɨvɨr za mbui. ");
INSERT INTO geb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nde mbara muuŋgip khara hi bigi ganɨrim, nta hɨrim, nde kaŋgiri. Fhe Bakɨme Guma Guar, ana taagi zirɨrga tuk guigira han mbarav, khakhɨnanera. ");
INSERT INTO geb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Gu guigira nde nzuai, kha bigi fharav hɨrim, nde mba bigi hi tugen vhɨzgi fhuv ntɨɨri, nde kɨv, za mba bigi ganɨrim, nta hɨrga. ");
INSERT INTO geb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kha buiv gum nuianan ki bigi za vhɨzgirga, nan buni vhuuiŋ vhɨzgirga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Zisas mbe nzuav khueŋ phorga mbe nzuai, “Guma the mba raa gum mba tuk kaŋgi fhu. Mba Fhe Bakɨme enseri, mbe vhɨra kaŋgi fhu. Fhe Bakɨmen Kam, ana vhɨra kaŋgi fhu. Fhe Bakɨme, ana nduara kaŋgi. ");
INSERT INTO geb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Nde mba tuga kaŋgirim, ana nden hɨgɨrga fhuvara. Nde maaŋ muuŋgip tuituigira wari ganɨv, mba tuga rargɨp wari kɨri. ");
INSERT INTO geb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mba tuk, ana guma wo phena thav, harigi ŋanen vui ne fara muuŋgi. Ana wo phena thav vov, wo phenan wo ŋaari gumgi farve khɨngi. Ana wo phenan mbe farve khɨngiap, wo phenan ŋaari, ana za nta shama mbuav mbe ndɨɨv, khaŋ mba phena thɨm kamani gari guma ga nzuai, ‘Ndu tuituigira ganɨri.’ ");
INSERT INTO geb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Nde phena namkam taagi zɨrga tuk kaŋgi fhuvara. Nde tuituigira wari ganɨv, anan rargɨv, wari kɨri. Nde kaŋgi fhuvara. Ana ŋkotugar zɨrga thi, ana maaŋ rɨgar zɨrga thi, ana tuari furim, ana zɨrga thi, ee, ana mɨn thugɨrim, ana zɨrga thi? ");
INSERT INTO geb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nde maaŋ muuŋgip kuv kɨrim, ana hanera nde thɨgɨv, nde ganɨngeŋ nzerigi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Zisas kha bunin mbe suaŋgia thugap, khaŋ mbe nzuai, “Gu khar nde nzuai buni, gu ntan za kha gumgi ga nzuai. Nde tuituigira ganɨri.” ");
INSERT INTO geb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mbe mba Pasova gum vhuui fhuv viktuma pi shaman muunga tuk, ra phunira mbur ki. Mba Fhe Bakɨme rotu gari gumgir pani gum Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi, mbe mooŋgip, Zisas suirap, ana shogirim, ana rimgir za tuavi ndi gari. ");
INSERT INTO geb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mbe khaŋ wari ga nzuai, “Nza shama tugar anan muunga fhuvara. Nza ana muuŋrim kha shaman zegi gumgi ntara bakɨ the khavgirga.” ");
INSERT INTO geb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ana Betanin kav, ana vov Saimon ŋkari goreregi rɨmrɨm kegi guman phenan vugi. Ana vugap, ana mba pi kaa ga piigim, mbiga mbevi kɨman muuŋgi nda mbevi ndiga zi. Mba kɨma zɨ khare, arabasta. Mba nda, ndɨga vhuuŋ hi mporiiŋ mbe anan ki. Mba ndɨga vhuuŋ hi mporiiŋ zɨ khare, naat. Mba ndɨga vhuuŋ hi mporiiŋ vhez guigira vun ndagi. Ana mba ndɨga vhuuŋ hi mporiiŋ phɨrgiap, ana siav Zisas pana suagi. ");
INSERT INTO geb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ana mba ndɨga vhuuŋ hi mporiiŋ siav ana pana suagim, gumgi mbari ana han maaŋ kav, ana nzuav ndav shigav, khaŋ wari ga nzuai, “Khe thaŋ nzuav kha ndɨga vhuuŋ hi mporiin farfagi? ");
INSERT INTO geb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nza kha mporiiŋ ndiv, harigi ntɨɨrir nɨɨŋgirim, mbe mpari bavira ŋgarigi guma ga vhezi, vheza kambarigi ŋkɨɨar ana vhezgirim, nza mba ŋkɨɨar bigi sosuagi gumgir nɨɨnga.” Mbe ne nzuav, ana vhegav ana nzuai. ");
INSERT INTO geb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mbe ana vhegim, Zisas mbe mbararagiap, khaŋ mbe nzuai, “Nde fhura kha mbiga ganɨ. Nde thaŋ nzuav simtɨgar ana ndɨɨi? Ana tɨvar vhuuŋ guarara na muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nde khueŋ kaŋgiri, mba bigi sosuagi gumgi, mbe zazera nde phorgɨ kɨrga. Nde rambui tugar mben kurkura saŋv, nde mbe kurkurarga. Gu fhuvara, gu khara muuŋgip nde phorgɨ kegɨrga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kha mbik, ana muunga bigeŋ muuŋgi. Ana fharav mporiin na fhava hɨvgirim, mbe zumgum na ndim mbogar rɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Gu khar guigira nde nzuai, mbe maaŋgi ŋanen kha nuianan Fhe Bakɨme buni vhuuiŋ bun suanga, mbe vhɨra kha mbik muuŋgi bigeŋ, mbe ne ndɨkndɨk suirav kɨv, mbe vhɨra ne bun suanga.” ");
INSERT INTO geb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mba tugen, Zisas mba farasegi 12 thɨgi ŋaara gumgi rɨgar, Zudas Askariat, khavgia vov Fhe Bakɨme rotu gari gumgir pani han vugap, Zisas thuuŋ dorgap, ana nzuav kama shɨrigi. ");
INSERT INTO geb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mbe ne mbararagiap ne ga nzuav ndikndigap, ŋkɨɨar Zudas ga vhezɨ za nzuaim, Zudas mbaram Zisas ndi mbe farve ga surga tuavi ndi gari. ");
INSERT INTO geb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mbe fharav mba vhuui fhuv viktuma shama pi raar, mba Zudaiŋ zazera mba tugar, mbe sipsiva ŋguga shogiap, ana pi. Mbe mba shama pi fharigi raar, Zisas phorga rui gumgi anan nzarigi, “Ndu maaŋgi ŋanen nza vuzvugi nza ŋgɨv, ndu Pasova mbɨrga ŋaneŋ bevahɨrie?” ");
INSERT INTO geb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Zisas mbaram wo phorga rui guma phunini ga sarav, khaŋ mani ga nzuai, “Ŋko ŋgɨv, ŋgu bakɨme vhen ŋgirɨrim, guma the nuiana nda mbɨ phɨgar ndarav ŋgɨv ŋkon hɨgɨrim, ŋko ana zɨn ŋgɨri. ");
INSERT INTO geb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ŋko ana zɨn ŋgɨrim, ana phena the vhen ŋgirɨrim, ŋko ana zɨn ŋgirɨv, khaŋ mba phena namkama suaŋri, ‘Ndɨkndɨgi vhuuin nza khɨvi guma rum khaŋ nzuai, “Gu wo phorga rui gumgir kov, nza Pasova mbɨrga ŋaneŋ mba?” ’ ");
INSERT INTO geb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ŋko maaŋ suanga, mba guma wo phenan mba vun vundavar ki ŋana bakɨmera ŋko khɨvarga, mbe mba ŋaneŋ bevahegi ne ki. Ŋko fhura nza mbɨrga mbara bevahegɨri.” ");
INSERT INTO geb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Zisas maaŋ wo phorga rui gumani ga suaŋgim, mani vui. Mani vov mba ŋgu bakɨme vhen vergap, mba bigi garim, mba bigi Zisas mani ga suaŋgi kama mɨnan vugim, mani mba Pasova mbɨrga bigi bevahi. ");
INSERT INTO geb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mani mba bigi bevahegim, mba raa verav vhɨzim, Zisas wo farasegi 12 thɨgi ŋaara gumgir kov, mbe zav mba phenan hegi. ");
INSERT INTO geb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mbe mba phenan hegap, Zisas wo farasegi 12 thɨgi ŋaara gumgir kov, mbe mba pi kaa ga piigiap pi. Mbe pav, ana khaŋ mbe nzuai, “Gu guigira nde nzuai, nde khar na phorga pi thera na thuuŋ dorgɨv, na nzuav kama shɨrarga.” ");
INSERT INTO geb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mbe mba kameŋ mbararagiap, ndavi mben simgim, mbe thav bevbevira khaŋ ana nzuai, “Maaŋ gu fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mbe maaŋ nzuaim, ana mbe ŋgarkara khaŋ mbe nzuai, “Nde kha 12 thɨgi gumgi, nde thera. Mba wo viktuma ndi na phorga thuuaŋ vhui gumara. ");
INSERT INTO geb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mbe fhum Fhe Bakɨme Guma Guara nzuav khergi kameŋ Fhe Bakɨme gavan ki, ana mba kameŋra zɨn ŋgɨgɨrga. Gu guigira mba Fhe Bakɨme Guma Guara thuuŋ dorgav ana nzuav kama sharigi guma kora muuŋgi. Ana niamuuŋ thaŋ nzuav ana tegi?” ");
INSERT INTO geb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Zisas mba kamen mbe suaŋgiap, mbe pav, Zisas mbaram viktuma ndigap, Fhe Bakɨme ndikndigap, ana phorga suaŋgiap, mba viktuma phɨrgiap, anan wo phorga rui ŋaara gumgi ga ndɨɨv khaŋ mbe nzuai, “Nde kha viktuman mbɨ. Khe nan fava sɨk ma.” ");
INSERT INTO geb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","A maaŋ mbe suaŋgiap, mbaram mbɨ thama ndigap, Fhe Bakɨme ndikndigap, ana phorga suaŋgiap, anan mbe nɨɨŋgim, mbe za mba thama mbɨ pi. ");
INSERT INTO geb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Mbe mba thama mbɨ pim, ana khaŋ mbe nzuai, “Khe na vɨzɨn ma. Fhe Bakɨme taagia kha nuianan ki gumgi vhɨrve ndir zav suaŋgiap mbe nzuav si surga vɨzɨn ma. ");
INSERT INTO geb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Gu guigira nde nzuai, gu wom taagip kha karɨga vhɨga mbɨn mbegɨrga fhu. Gu zumgum Fhe Bakɨme ana za kɨrar hɨgɨp wo gumgi gum mbigi ganɨnga, gu mba tugar nza wari tɨgɨp kɨv, gu za nde phorgɨv taagip mba karɨga vhɨga mbɨn kaman mbɨrga.” ");
INSERT INTO geb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","A mba bunin mbe nzuav, mbe mbega thugap, ŋgava muuŋgiap, mbe khavgia Oriv mbɨkshɨman ndagi. ");
INSERT INTO geb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Zisas khaŋ mbe nzuai, “Nde za na thav regɨrga. Kha kameŋ mbe ne khergim, ne Fhe Bakɨme buni ki gavar ki. Mba kameŋ khaŋ nzuai, ‘Gu mba sipsivi gari guma shogirim, ana rimgirga, mba sipsivi za rɨv, tamtam ŋgegɨrga.’ ” ");
INSERT INTO geb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Zisas nen mbe nzuav, thav khaŋ mbe nzuai, “Gu rimgip taagi khavgiv, gu fharav nde nɨman thɨgɨv, Garirir ŋgɨgɨrga.” ");
INSERT INTO geb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Zisas maaŋ mbe nzuaim, Pita hɨgap khaŋ ana nzuai, “Mbe za ndu thav regɨrga, gu rɨv ŋgɨgɨrga fhu.” ");
INSERT INTO geb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Zisas mbaram ana ŋgarkarav khaŋ nzuai, “Gu guigira ndu nzuai, ntige kha maan, tuar fu mpuani muuŋgirga, ndu na ndi zaahɨ mpuani khegenen muuŋgirga.” ");
INSERT INTO geb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita ne mbararagiap khaŋ tɨgap, khaŋ ana nzuai “Gu ndu ndim zaahegɨrga tuktɨgi fhu. Gu ndu phorgɨv rimgirga.” Ana ne nzuaim, mba Zisas phorga rui ŋaara gumgi mbari, mbe vhɨra nera nzuai. ");
INSERT INTO geb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mbe maaŋ kegav vov, kha zɨn rɨgi ŋanen vegi, Getsemani. Mbe vov maaŋ vegap, Zisas khaŋ wo phorga rui gumgi ga nzuai, “Nde khara piigip kɨv, na rargɨrim, gu ŋgɨv, Fhe Bakɨme phorgɨv suanga.” ");
INSERT INTO geb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ana maaŋ mbe suaŋgim, mbe kim, ana Pita gum, Zems gum Zon, ana mbera kov, mbe vui. Mbe vov, Zisas ndav guigira anan simgim, ana wo khɨkhɨm mbararav guigira simgi. ");
INSERT INTO geb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ana thav khaŋ Pita gum, Zems gum Zon ga nzuai, “Na ndav guigira simgim, gu wo khɨkhɨm mbararagim, gu rɨmɨn za mbui. Nde ku thari, nde na suaŋv mbur ganɨv, na rargɨ khara kɨri.” ");
INSERT INTO geb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ana maaŋ mbe suaŋgiap, mbe thav maneŋ shɨva vugap, wo fegap nuiana khɨngiap, Fhe Bakɨme phorga nzuav, khaŋ ana nzuai, “O Fhe, harigi tuap the kɨrim, ndu ntige na tɨn kha tuga mbatɨga ndigiri.” ");
INSERT INTO geb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ana ana phorga nzuav, khaŋ ana nzuai, “O, dara, ndu za kha bigi ga mbui ŋkasŋka ki. Ndu na tɨn kha zaagi ndigɨ. Gu ne ndu nzuai, ndu na vuzvuga zɨn ŋgɨ thari. Ndu wo vuzvuga zɨn ŋgɨri.” ");
INSERT INTO geb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ana Fhe Bakɨme phorga suaŋgia taagia vov, wo phorga rui guma phuni khegene garim, mbe kuav kim, ana khaŋ Pita ga nzuai, “Ee, Saimon, ndu kuire? Ndu kha tuga tɨvɨnera na suaŋv mbur ganɨv nan rargɨ kegɨrga fhuve? ");
INSERT INTO geb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ndu na suaŋv mbur ganɨv na rargɨv kɨv, Fhe Bakɨme phorgɨ suaŋri. Ndu kaŋgi fhuvara, maaŋ muuŋgip bigɨn thueŋ nden hɨrga, ndu ne khɨgɨ rɨgɨ rivgi. Ndu ndava vhee bigir vhuuin muungeŋ vuzvugi, ndu fhav ŋkasŋka ki fhu.” ");
INSERT INTO geb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ana maaŋ ana suaŋgiap, taagia vov Fhe Bakɨme phorga nzuav, mba fharav ana phorga suaŋgi kamera ana nzuai. ");
INSERT INTO geb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ana Fhe Bakɨme phorga suaŋgiap, taagia zav mbe garim, mbe rɨmgi guigira mben simgim, mbe kuavra ki. Ana mbaram mben vhurigim, mbe ana suanga buni kakagiap, fhura mbar piigi. ");
INSERT INTO geb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ana ruru mpuani ga muuŋgiap, taagi khegenai ga muuŋgiap, taagia zav, khaŋ mbe nzuai, “Ee, nde vhuksuav kuavra kire? Aria, nde za kuigi. Mba tuk ntige hɨgi. Nde ganɨ, guma mbe Fhe Bakɨme Guma Guara thuuŋ dorgɨv, ana nzuav kama shɨrav, ana ndim, gumgi mbatɨgi farve khɨngi. ");
INSERT INTO geb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nde khavgip nza ŋgɨrga. Mba na thuuŋ dorgap, na nzuav kama shɨrav, na ndim gumgi mbatɨgi farve khɨngi guma mbur zi.” ");
INSERT INTO geb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Zisas maaŋ wo phorga rui gumgi ga nzuavra kim, ana mba farasegi 12 thɨgi ŋaara gumgi mbe rɨgar guma mbe Zudas, ana hɨgi. Ana hɨgim, gumgi vhɨrve za kozi gum fani suigiap, za ana zɨn hav mbar thivgi. Mba gumgi, Fhe Bakɨme rotu gari gumgir pani gum, Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi gum, mben gumgir ruu, mbe mbe khɨrav, mbe sarigim, mbe zegi. ");
INSERT INTO geb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mba Zisas thuuŋ dorgav, ana nzuav kama shɨrav, ana ndim mba gumgi mbatɨgi farve khɨngi guma, Zudas, ana fharav mbe phorga kama shogav, khaŋ mbe suaŋgi, “Nde na ganɨrim, gu guma the khoman panɨv ana viavɨrim, nde mba gumara suirav, ana ganɨv, ana ndigi ŋgɨgɨri.” ");
INSERT INTO geb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mbe vov, Zisasan havram, Zudas zam khaŋ ana nzuai, “Rabai!” Ana maaŋ ana nzuav za vov, ana fhɨre rɨgav, ana khoman mpari. ");
INSERT INTO geb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Zudas maaŋ ana mbuim, mba gumgi hegap, za Zisasan suirigi. ");
INSERT INTO geb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mbe ana suirigim, maaŋ Zisas han maaŋ thɨgi guma mbevi, wo kambigan wo kos sigap, za mba Fhe Bakɨme rotu gari guman panan ŋaara guma khuara mbe shogia thugim, ana nɨɨeŋ rɨgi. ");
INSERT INTO geb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Zisas mbaram kama hegap, khaŋ mbe nzuai, “Gu kɨɨav, pheni phɨrav, gumgi shogi guma thi? Nde maaŋ muuŋgiap kozi gum fani ndigap na suigɨr za zegi? ");
INSERT INTO geb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nde na garim, gu tugi vhɨrvera nde phorgav kav, kha Fhe Bakɨme phena bɨna vhen kav, Fhe Bakɨme buni vhuuin nde nzuai. Nde mba tugir na suigɨrgeŋ thagi. Nde thagi ne khaŋ muuŋgi. Fhe Bakɨme gavar ki buni vhuuiŋ guigira mba tegɨrga.” ");
INSERT INTO geb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ana ne nzuaim, ana phorga rui gumgi zam ana thav, regi. ");
INSERT INTO geb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Mbe regim, Zisas pana gumgi ana ndiga vuim, guman kama mbe rashaa hureŋra kegap, ana zɨn vui. Ana vuim, mbe ana suigim, ana mba rashaa hureŋ fhɨrgiap, mbe farve thav, mbugumra ra vugi. ");
INSERT INTO geb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mbe Zisas ndiga vov, Fhe Bakɨme rotu gari guman pana han vugim, mba Fhe Bakɨme phena ŋgari gumgir pani gum, mben gumgi ruu gum, mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi, mbe za zav wari fugi. ");
INSERT INTO geb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita samra kav Zisas zɨn vov, mba Fhe Bakɨme rotu gari guman pan ŋgari pheni bɨna vhen vergap, mba gɨɨtɨvi haa perav, vhava gurguri. ");
INSERT INTO geb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ana vhava gurgurim, mba Fhe Bakɨme rotu gari gumgir pani gum, mba bigi ndi thɨgɨr mbai gumgir pani zam, mbe Zisas muuŋgi bigɨn thueŋ bun suaŋrim, mbe ne mbararagip, ne suaŋv ana shogirim, ana rimgirga. Mbe ana shogirga tuavi ndi garav, mbe ana muuŋgi bigɨn thueŋ mbararagi fhu. ");
INSERT INTO geb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mbe mba tɨvar ana mbuav, gumgi vhɨrve ana shɨshɨgav, tamtam buni vhɨrver ana nzuai. Mbe buni tuap bavira vugi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Mbe mbovara thav, gumgi mbari khava thivgiav, ana shɨshɨgav khaŋ nzuai, “Nza ana mbararagi, ana khaŋ suaŋgi, ‘Gu kha gumgi wari wo farir muuŋgi Fhe Bakɨme Phena phɨrgiv, raa phuni khegenen, gu taagi anan muuŋgirga. Gu ana muuŋv, gu farver anan muuŋgirga fhuvara.’ ” ");
INSERT INTO geb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mbe vhɨra mba kamen ana shɨshɨgav, mbe tamtam ne nzuai. Mbe buni tuap bavira vugi fhuvara. ");
INSERT INTO geb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mbe mba bunin ana shɨshɨgap kim, Fhe Bakɨme rotu gari guman pan khavgia, mbe nɨma thɨgav, Zisasan nzarigi, “Ndu kheiŋ nzuai buni ŋgarka thagire? Kheiŋ khar ndu muuŋgi bigi, mbe khar ntan ndu sav ndu nzuai, nta guigirame?” ");
INSERT INTO geb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ana mba kamen Zisas ga nzuaim, Zisas buna thuain ana khɨgi fhuvara. Ana fhura thɨgap kim, mba Fhe Bakɨme rotu gari guman pan taagia Zisasan nzarigi, “Ndu Krais, nza ndɨkndɨgi vhuuin mbui Fhe Bakɨmen Kam, e?” ");
INSERT INTO geb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ana mba nzambaren ana muuŋgim, Zisas khaŋ ana nzuai, “Ahaŋ, gu ana ma. Nde zumgum Fhe Bakɨme Guma Guara ganɨrim, ana za kha bigi kharav ŋkasŋka ki Fhe Bakɨme guva haren perav, Hevenan kegɨv, buiva hura phorgɨv zirɨrga.” ");
INSERT INTO geb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ana ne nzuaim, mba Fhe Bakɨme rotu gari guman pan, ana wo shagi suigav, nta rɨza nta ndi suav, khaŋ nzuai, “Nza thaŋ suaŋv ana muuŋgi bigi thari phorgɨv kaŋgi saŋv, harigi ntɨɨri nzarie? ");
INSERT INTO geb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nde ntige za mbararagim, ana Fhe Bakɨme sɨɨŋgi. Nde ram muuŋgi ndɨkndɨgar ana mbui?” Mbe za kama hegap, khaŋ nzuai, “Ana bigɨna mbatɨgeŋ ga muuŋgi, ana rimgirga.” ");
INSERT INTO geb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mbe ne ana nzuav, mbari hav ana parav, mbaram shaa ndiga zav ana rɨmani ndogiap, wari wo fari khorav, zav ana shogi. Mbe ana shogav, khaŋ ana nzuai, “Ndu khar nza suaŋ, the khar ndu shogi?” Mbe maaŋ ana mbuim, mben gɨɨtɨvi ana ndiga vov, hor mbatɨgar ana mbui. ");
INSERT INTO geb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mbe maaŋ Zisas ga mbuim, Pita bumgum, mba Fhe Bakɨme rotu gari guman panan ŋgari phena bɨna vhen perav ki. Ana perav kim, mba Fhe Bakɨme rotu gari guman panan ŋaara mbik thivav zi. ");
INSERT INTO geb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ana thiva zav, Pita garim, ana vhava gurgurav kim, ana zav, ana hara zɨgav, ana gari. Ana ana garav, khaŋ ana nzuai, “Ndu vhɨra mba Nasaret guma Zisas phorga ki guma mbe ma.” ");
INSERT INTO geb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ana ne nzuaim, Pita wo ndi zaahegap, khaŋ ana nzuai, “Gu ndu nzuai buneŋ kaŋgiap nen sagi fhuvara.” Ana nen mba mbiga nzuav, thivav mba phena bɨna thɨm kamanin vui. ");
INSERT INTO geb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ana thivav, mba bɨna thɨm kamanin vuim, mba mbik wom maaŋ ana gangiap, khaŋ maaŋ thivgi gumgi ga nzuai, “Mbu guma ana mba guma mbe ma.” ");
INSERT INTO geb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mba mbik wom maaŋ ana nzuaim, Pita taagia wo ndi zaahegi. Ana wo ndi zaahegap, maaŋ thɨga kav kim, ana han maaŋ thivgia ki gumgi mbari khaŋ ana nzuai, “Ndu guigira mba guma mbe ma, ndu Gariri guma ma.” ");
INSERT INTO geb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mbe wom ne nzuaim, Pita ne mbararagia thav, kama havharar khaŋ mbe nzuai, “Kha vun ki Fhe Bakɨme na kaŋgi. Gu nde guigirim, ana mbar nan farfa. Gu guigira nde nzuai guma, gu thaneŋ ana kaŋgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pita ne nzuavra thagim, tuar wom phenatɨtɨga furigi. Ana furigim, Pita thav, mba Zisas ana suaŋgi kameŋ ndɨrigi. Zisas fhum, khaŋ ana suaŋgi. “Tuar ntigar fu mpuanin muunga, ndu fhumra na ndi zaahɨ mpuani khegenen muuŋgirga.” Pita mba kameŋ ndɨrga thav, fhura nzi mbatɨga mbui. ");
INSERT INTO geb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Zisas mba Fhe Bakɨme rotu gari guman pan ŋgari phenan kim, mɨn thugim, mba Fhe Bakɨme rotu gari gumgir pani gum mben gumgi ruu, mbe zi. Mbe zim, mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi gum, mba bigi ndi thɨgɨr mbai gumgir pani zam, mbe vhɨra zi. Manera mbe zav wari fugap, kama shogiap, Zisas kegap, ana ndiga vov, Pairat farve khɨngi. ");
INSERT INTO geb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mbe ana ndigap, Pairat farve khɨngim, Pairat anan nzai, “Ndu Zudaiŋ gari guman pan, e?” Ana ne nzuaim, Zisas ana ŋgarkarav khaŋ ana nzuai, “Ahaŋ, ndu za mbar ne nzuai.” ");
INSERT INTO geb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pairat mba nzambaran ana mbuim, mba Fhe Bakɨme rotu gari gumgir pani buni vhɨrver ana sav ana nzuai. ");
INSERT INTO geb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pairat mbaram wom anan nzarigi, “Ndu kheiŋ ndu sav ndu nzuai buni ŋgarkarie? Ndu khar mbararagim, mbe kha buni vhɨrver ndu sav ndu nzuai.” ");
INSERT INTO geb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pairat maam Zisas ga nzuaim, Zisas buna thuen anan fagi fhuvara. Pairat thav, ŋgava mbatɨga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mba tugen, Pairat wo tɨva zɨn vov, mba Pasova shama bakɨme pi tugar, anan gumgi gu mbigi nzuaim, ana mben vuzvugar, bɨnan ki guma the fhɨrgirim, ana kɨrar hɨgɨ ŋgɨrga. ");
INSERT INTO geb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mba tugen, gumgi mbari, ŋgu gari guman pana gumgi, mbe phorga ntar khavgiav, guma mbe shogi ana rimgim, mbe ne nzuav mbe ndim bɨna suegim, mbe ki. Mbe phorga bɨnan ki guma mbe, ana zɨ Barabas. ");
INSERT INTO geb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mba tugen, gumgi gum mbigi vhɨrve zav, Pairatan nzav, khaŋ ana nzuai, “Ndu fhum mba zazera nza mbui tɨv, ndu ntige mba tɨvira muuŋri.” ");
INSERT INTO geb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Mbe ne nzuaim, Pairat mben nzarigi, “Nde vuzvugirim, gu nde ndim kha Zudaiŋ gari guman pana fhɨrgirim, ana nde han kɨrar hɨrie?” ");
INSERT INTO geb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ana kaŋgi, mba Fhe Bakɨme rotu gari gumgir pani Zisas nderniniŋgiap, ana suira zav, ana nɨɨŋgi. ");
INSERT INTO geb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mbe maaŋ muuŋgiap, mba Fhe Bakɨme rotu gari gumgir pani mba gumgi gum mbigi vhɨrve ndavi ga sav, khaŋ mbe nzuai, “Nde Pairat ga suaŋrim, ana Zisas fhɨrɨ thari. Nde ana suaŋrim, ana Barabas fhɨrgirim, ana nde han zɨri.” Mbe maaŋ mbe suaŋgim, mba gumgi gu mbigi vhɨrve khaŋ Pairat ga nzuai, “Ndu Barabas fhɨrgiri, ana nza han zɨri.” ");
INSERT INTO geb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mbe maaŋ nzuaim, Pairat mbe mbararagia thav, taagia mben nzarigi, “Maaŋgi, nde mba khaŋ nzuai guma, Zudaiŋ gari guman pan, gu ram anan muuŋrie?” ");
INSERT INTO geb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pairat mba nzambaran mbe muuŋgim, mbe za khavgia ndarav ŋgarŋgarav khaŋ nzuai, “Ana ndim, khanarareŋ ga tɨgɨ fugu!” ");
INSERT INTO geb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mbe maaŋ nzuaim, Pairat taagia mben nzarigi, “Ram muuŋgi ne suaŋv? Ana thagɨna bigɨna mbatɨgeŋ ga muuŋgi?” Pairat ne nzuaim, mbe thav, khaŋ tɨgav khɨrɨv, kaav, ŋgarŋgarav, khaŋ nzuai, “Ana ndim khanarareŋ ga tɨgɨ fugu!” ");
INSERT INTO geb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pairat mba kameŋ mbararagiap, mba gumgi gu mbigi ndavi mbɨra zav, Barabas fhɨrgim, ana mbe han vui. Ana mbara nzuaim, mbe Zisas kharɨgim, Pairat mbaram ana ndim, khanarareŋ ga tɨgɨv fugfugɨ zav, ana ndim, mba ntari ga mbui gɨɨtɨvi farve khɨngi. ");
INSERT INTO geb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pairat Zisas ndim, mba ntari ga mbui gɨɨtɨvi farve khɨngim, mbe Zisas ko vov, mba ŋgu gari guman pana Pairat phena bakɨmen vergi. Mba phena zɨ khare, Petoriam. Mbe ana ko vergap, mbaram, za mba ntari ga mbui gɨɨtɨvir kamgim, mbe zav, za wari fugi. ");
INSERT INTO geb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Mba ntari ga mbui gɨɨtɨvi wari fugim, mbe mbaram shaa hɨva mpeeŋ ndigap zav, anan Zisas sharav, mbaram tari ki karɨga ndigap, ŋgu gari guman pan fi khorsɨga muuŋgiap, anan Zisasan panan fagi. ");
INSERT INTO geb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mbe anan Zisasan fav, anan kaav, khaŋ ana nzuai, “Raar vhuuŋ, Zudaiŋ gari guman pan!” ");
INSERT INTO geb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mbe mba suambarar ana mbuav, mbaram mpiiŋsɨga ndigap ana pana shogiap, ana khoma parav, thɨvi phɨrav ana niman fav, anan surav, ana zɨ ndi vun kuamkuagi. ");
INSERT INTO geb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mbe ana nzɨɨv, mba tɨvir ana muuŋgiap, ana tɨn mba shaa hɨva mpeeŋ zorgiap, mbaram ana shagir taagia ana shargiap, ana ndim khanarareŋ ga tɨgɨ fugfugur zav anan kov kɨrar hi. ");
INSERT INTO geb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mbe ana kov kɨrar hɨgap zav garim, Sairini guma mbe mbar kegap, Zerusareman zi. Mba guma zɨ, Saimon. Saimon, Areksander gum Rufas, ana manin ndia ma. Ana zav mbe kambarav Zerusareman ŋgirɨ za mbuim, mbe ana thɨvav, mba Zisas ndi tɨgɨ fugfugɨrga khanarareŋ ndir zav, ana dama mbuim, ana Zisas ndim mba khanarareŋ phufhurgi. ");
INSERT INTO geb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ana mba khanarareŋ phufhurav, mbe Zisasan ko vov, kha zɨn rɨgi ŋanen vugi, Gorgota. Mba zɨ nɨɨŋge khaŋ nzuai, guman pana tuama fara muuŋgi ŋaneŋ. ");
INSERT INTO geb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mbe mba ŋanen vegap, mbaram, mba zaahɨ mbɨɨi mbɨ meer ndigap wain phorga digap, Zisas ga ndɨɨim, Zisas mba wain mbɨ thagi. ");
INSERT INTO geb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Zisas mba wainan mbɨ thagim, mbe mbaram ana suirav, ana ndim khanarareŋ ga tɨgap, ana ndi fugfugi. Mbe ana ndim fugap, ana shagi ndiga, nta nzuav satu suri. Mbe satu surav, garav, mba shagi shama mbuav nta ndi. ");
INSERT INTO geb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mbe manera raa ndav sharav nzaim, mbe Zisas ndim khanarareŋ ga tɨga fugi. ");
INSERT INTO geb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mbe Zisas ndim khanarareŋ ga ntorgap, mbaram ana shogi ana rimgi kameŋ khergiap, ana pana shɨ tɨgɨ fugi. Mba kameŋ khaŋ nzuai, “Zudaiŋ Gari Guman Pan.” ");
INSERT INTO geb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Mbe vhɨra kɨɨv bigi farfagi guma phunini, mbe vhɨra mani ndim, khanarareni ga ntorgi. Mbe mbevi ndim Zisas guva hareŋ ga ntorgav, mbevi ndim ŋkɨn hareŋ ga ntorgi. ");
INSERT INTO geb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Zisas mba khanarareŋ ga ntorgap kim, gumgi gu mbigi mbur vov khar zav, ana garav, pani kurkurav, ana nzɨɨv, khaŋ ana nzuai, “Ndu khaŋ nzuai guma ma, ‘Gu kha Fhe Bakɨme Phena phɨrgiv, gu taagiv ra phuni khegenera ana muuŋgirga,’ ");
INSERT INTO geb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ndu ntige nduara won kurav, mba khanarareŋ thav nɨn zirɨk!” ");
INSERT INTO geb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mbe maaŋ ana nzuaim, mba Fhe Bakɨme rotu gari gumgir pani gum mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi, mbe vhɨra warira phorga nzuav, ana nzɨɨv khaŋ ana nzuai, “Aa, ana harigi ntɨɨrir kurkurigi, ana wora kurarga tuktɨgi fhuvara! ");
INSERT INTO geb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kha Fhe Bakɨme taagi wo gumgi gu mbigi ndir zav farasarigi guma, Krais, kha Isreriŋ gari guman pan, ana kha khanarareŋ thav nɨn zirgɨrga, nza ana gangip ana khothɨgɨrga.” Mbe maaŋ nzuaim, mba Zisas han khanarareni ga ntorgi gumani, mani vhɨra ana nzɨɨv, ana nzuai. ");
INSERT INTO geb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","34","Ra vov phɨɨŋ ndigim, kha nuian za maaŋ gɨngiap kim, ra vera vov ŋkotuguraagen, ra phuni khegene ndigim, Zisas thav kama bakɨme rugav nzɨɨv khaŋ nzuai, “Eroi, Eroi, rama sabaktani?” Mba kama nɨɨeŋ khaŋ nzuai, “Na Fhe Bakɨme, na Fhe Bakɨme, ndu thaŋ nzuav na thagi?” ");
INSERT INTO geb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Zisas kama bakɨmen ne nzuaim, maaŋ ana han thivgia ki gumgi mbari ne mbararagiap, khaŋ nzuai, “Nde mbur mbarara, ana Iraizan kaai.” ");
INSERT INTO geb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mbe ne nzuav, guma mbe khuafɨ vov, matres fɨga mueŋ ndiga zav, pɨksɨgi wain ga rugap, anan vuruna phokegap, anan Zisasan nɨɨn za mbuim, guma mbe khaŋ ana nzuai, “Ndu mbararari, nza fhura kɨv ganɨnga, Iraiza zɨv, anan kurarim, ana nɨn zirɨrga thi?” ");
INSERT INTO geb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mbe ne suaŋgiap, kav garav kim, Zisas kama bakɨme rugav nzɨɨv, gor vhɨk ŋgɨrgi. ");
INSERT INTO geb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Zisas gor vhɨk ŋgɨrgim, mba Fhe Bakɨme Phena ntorgi rashaa bakɨme rɨgɨra shɨrage rɨgav, vura kegap, zav nɨɨŋra vergi. ");
INSERT INTO geb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mba ntari ga mbui gɨɨtɨvi gari guman pan Zisas nɨman maaŋ thɨgav kav ana mbararagiap, ana garim, ana gor vhɨk ŋgɨrgav, bur huasgia ntorgim, ana thav khaŋ nzuai, “Guigi guarara, khe Fhe Bakɨmen Kam ma.” ");
INSERT INTO geb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mba Zisas gari gumgi gu mbigi rɨgar, mbigi mbari maam maneŋ samra thivgiap ki. Mba mbigi khare, Makdaran mbiga Maria gum, Zoses gum anan ŋguga Zems, manin niamuuŋ, Maria, gu Sorome. ");
INSERT INTO geb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mbe mba mbigi, mbe fhum Zisas Garirin ka ruim, mbe ana zɨ ruav, anan kurkuragi mbigi ma. Mbe Zisas zɨn ndagim, harigi mbigi vhɨrve vhɨra Zerusareman kegap, Zisas phorga ndav vhɨra maaŋ ki. ");
INSERT INTO geb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Mba Zisas rimgi raan, mbe Sabat bigi bevahi ra ma. Mba raa hɨgim, zumgum Sabat raa hi. Mba raan ra verav vhɨzim, Arimatea guma Zosep, ana mba Zudaiŋ bigi ndi thɨgɨr mbai gumgi phorga ki guma mbe ma. Ana vhɨra gumgi gu mbigi ana khothivav, ana piin ki guma ma. Ana Fhe Bakɨme wo gumgi gu mbigi garim, mbe ana piin ki ntɨɨri phorgɨ kɨrgeŋ rarga ki. Ana ŋgɨrɨtɨn wo nɨɨŋgiap Pairat han zav, Zisas khuma ndir zav anan nzai. ");
INSERT INTO geb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ana ne nzuaim, Pairat ana rimgi ne mbararagiap, ŋgava mbatɨga muuŋgiap, khaŋ nzuai, “Ana guigira rimgire?” Ana thav mba ntari ga mbui gɨɨtɨvi gari guman panan nzuav kama ndi mbarigim, ana zi. Ana zim, Pairat anan nzarigim, ana khaŋ ana nzuai, “Ahaŋ, ana guigira rimgi.” ");
INSERT INTO geb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ana ne mbararagia thav, mbaram Zisas khuma ndir zav Zosep khɨrigi. ");
INSERT INTO geb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ana Zosep khɨrigim, Zosep mbaram vov, shaa hura bakɨme vhezgiap, zav, Zisas khuma daaŋgiap, mba shaa hurar ana khuma zigap, ana ndogiap, ana ndiga vov, kɨma thoon muuŋgi mboga tɨgi. Ana ana ndi mboga tɨgap, kɨma bakɨ mbe phophoga zav, mba mbok thɨmkamani mpɨrigi. ");
INSERT INTO geb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Zosep ana khuma ndi mboga rɨgim, Makdara mbiga Maria gum Zoses niamuuŋ Maria, mani ana garim, ana ana khuma ndi mboga tɨgi. ");
INSERT INTO geb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat ra vhɨzgim, Makdara mbiga Maria gum, Zems niamuuŋ Maria, gum, Sarome, mbe Zisas khuma hɨvɨ zav vov, ndɨga vhuuŋ hi mporiiŋ ga vhezgi. ");
INSERT INTO geb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mbe mba mporiiŋ ga vhezgiap, Sanden manera ra ndav shɨgɨra thagim, mbe ana ndi mboga tɨgi kɨma thoon muuŋgi mbogar vui. ");
INSERT INTO geb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mbe vov, khaŋ wari ga nzuai, “The nzan kurav, mbu mbok thɨmkamani puigi kɨma bakɨme phogi mbur ndararie?” ");
INSERT INTO geb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mbe nen wari ga nzuav vov, ragia garim, mba kɨma bakɨme, mbe ana phogia vov, mbur ndarigi. ");
INSERT INTO geb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Mbe vov, mba kɨma thoon muuŋgi mboga vhen vera garim, guman kama mbe shagi huri shargiap, mba mboga vhen guva nderen perav ki. Mbe ana gangiap guigira warir rɨɨngi. ");
INSERT INTO geb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mbe warir rɨɨrim, ana khaŋ mbe nzuai, “Nde warir rɨnɨ thari. Gu kaŋgi, nde mba khanarareŋ ga ntorgi Nasaret guma Zisas ndi gari. Ana khar ki fhu. Ana taagia khavgi. Nde ana rɨga kegi ŋaneŋ ganɨ. ");
INSERT INTO geb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nde ne gangip, taagi ŋgɨv, mba ana phorga ruigi gumgi ga suaŋv, vhɨra Pita suaŋgiri, ‘Ana nde nɨma thɨgav fharav Garirir vui. Nde maaŋ ana gangirga. Ana fhum mba kamen nde suaŋgi.’ ” ");
INSERT INTO geb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mba mbigi mba kameŋ mbararagiap, guigira ŋgava mbatɨga muuŋgiap, ninɨk mbe mbuim, mbe mba mbok thav kɨrar hegap, wari ra vui. Mbe vov, buna thuen guma the suaŋgi fhu. Mbe guigira rivgi. ");
INSERT INTO geb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Zisas rimgiap, Sanden mɨn gorovra thagim, ana manera taagia khavgiap, ana fharav Makdaran mbiga Mariar hɨgi. Ana fhum mba mbiga tɨn harathɨgi ŋiniŋgi mbatɨgi ga vharigim, nta ana thav, kɨrar hegi. ");
INSERT INTO geb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ana fharav ana gangiap, vov, ana phorga ruigi ntɨɨri, ana mbe garim, mbe ana nzuav nzɨɨv, nziav kim, ana ana bun mbe suaŋgi. ");
INSERT INTO geb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ana Zisas taagia khavgim, ana ana gangiap, vov ne bun mbe suaŋgim, mbe ne khothɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Zisas zumgum fhav maneŋ harigi gangana mbuav, wo phorga ruigi guma manin hɨgi. Mani Zerusareman kegap, wani vuim, ana tuap sɨgen manin hɨgi. ");
INSERT INTO geb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ana manin hɨgim, mani taagia Zerusarem ndav, ne bun ana phorga ruigi gumgi mbari ga nzuaim, mbe vhɨra mani khothɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Zumgum ana farasegi 11 thɨgi ŋaara gumgi, mbe nduarira phena vhen ka pav kim, Zisas nduara mben hɨgi. Ana mben hɨgav, mbe vhegi. Ana khueŋ nzuav mbe vhegi. Mbe pani havhargiav, gumgi mbari ana rimgia taagia khavgim, mbe ana gangiap, ne bun mbe nzuaim, mbe ne khothɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ana ne nzuav mbe vhegap thav khaŋ mbe nzuai, “Nde za kha nuianan ŋgɨv, Fhe Bakɨme buni vhuuiŋ bun za kha gumgi gu mbigi ga suaŋri. ");
INSERT INTO geb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Gumgi gu mbigi maaŋ muuŋgip, mba Fhe Bakɨme buni vhuuiŋ mbararav, nta khothivɨv, ruarga, Fhe Bakɨme zazera mbara muuŋgia ki bɨɨŋbɨɨn mben nɨɨŋgirga. Gumgi gu mbigi maaŋ muuŋgip, mba Fhe Bakɨme buni vhuuiŋ mbararav, nta khothivi fhu, mbe zumgum Fhe Bakɨme nɨma thivgirim, ana ne suaŋv mbe fuv Her ga suegɨrga. ");
INSERT INTO geb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Mbe mba Fhe Bakɨme buni vhuuiŋ khothivi ntɨɨri, kha tɨv mben kɨrga. Mbe na zɨn panan ŋiniŋgi mbatɨgi ga vharvharav, mbe vhɨra harigi ŋguir kaar buni suaŋv, mbe kurugir suigɨv, mbe vhɨra thiŋgi mbɨn mbɨrga, mba mbɨ gum kurigi vhɨra mben farfagirga tuktɨgi fhu. Mbe vhɨra wari wo farir rɨɨi gumgi ga surga, mben rɨmrɨɨ vhɨzɨrga.” ");
INSERT INTO geb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Zisas mba bunin mbe suaŋgia thugim, Fhe Bakɨme ana ndiga Hevenan ndagim, ana Fhe Bakɨme han, ana guva hareŋ ga perigi. ");
INSERT INTO geb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Zisas Hevenan ndagim, ana phorga ruigi gumgi za kha nuianan vov, Fhe Bakɨme buni vhuuiŋ bun, mbe nzua rui. Mbe maaŋ mbuim, Fhe Bakɨme Ŋina Ŋaar mbe phorga ruav, ŋkasŋkar mbe ndɨɨim, mbe mirikori ga mbuim, mba gumgi gum mbigi nta garav khaŋ nzuai, “Khe guigira Fhe Bakɨme buni ma!”");
INSERT INTO geb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Guman rum, Tiofirus, ndu kaŋgi, Zisas fhum nza phorga kav, ana nza rɨgar bigi vhɨrve ga muuŋgi. Ana fhum fharav mba bigi ga mbuavra thagim, gumgi vhɨrve, mbe wari wo rɨmgi thugira mba bigi gangi. Mba gumgi mbarira mba buni bun nzua ruigi ŋaara gumgi kav, mba bigi bun nza suaŋgi. Mbe nta bun nza suaŋgim, zumgum gumgi vhɨrve, mbe zam ana mba suaŋgi bigi, mbe zam nta fugap, ana mba nza rɨgar kav suaŋgi bigi bakɨvi, mbe zam nta khergi. Mba bigi gangi gumgi, mbe nta kherav, mbe mba nza suaŋgi bunira, mbe ntara khergi. Gu fhara mba bigi havra thagim, gu tuituigira mba bigi garav, nta mbararagiap, nta nzuav nzav za nta ndɨriveŋ ndigi. Gu vhɨra nta ndigav, gu kha ndɨkndɨga mbui, gu nzerara tuituigira kha bigi khergip ntan ndu ndim mbararga. Gu ne ndɨkndɨgiap, nta khergiap, ndu ndi mbai. Ndu gu khar khergiap ndu ndim mbai bigi, ndu nta gangip kaŋgiri, mbe mba ndu nzuai bigi, nta guigira bigi guarira. ");
INSERT INTO geb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Fhum Herot Zudia fhain ki ŋgui gari guman pan ki. Mba tugen Fhe Bakɨme rotu gari guma mbe ki. Mba guma zɨ Sekaraia. Sekaraia, ana won tor Abaia shɨga ntɨɨri phorgap, mbe wari tɨgap Fhe Bakɨme rotu gari guma ma. Sekaraian muuŋ, Erisabet, mani vhɨra Aron shɨga guma gu mbik ma. ");
INSERT INTO geb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Mani vhɨra guigira Fhe Bakɨme nɨman, mani guigira mbik gu guman vhuuni ma. Mani zazera Fhe Bakɨme buni mbararav, ana nzuai tɨvi, mani guigira nta zɨn vui. Mani ana nɨman tɨva mbatɨk thueŋ muuŋgi fhuvara. Zakɨra fhuvara! Mani nzerara ana nɨman ki. ");
INSERT INTO geb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mani nzerara kav, mani tara the tegi fhu. Mani khaŋ muuŋgiap, Erisabet, ana khurati. Mani maaŋ muuŋgiap, mani vhɨra fhura kim, mpari vhɨrve vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Mani kav kim, mba Sekaraia phorgav Fhe Bakɨme rotu gari gumgi, ŋgarɨrga tuk hɨgi. Sekaraia, ana ntige Fhe Bakɨme nɨman, ana phenan ŋgarɨrga. Mba tuk hɨgim, mbe won tɨva zɨn vuav, satu suri. Mbe satu surav, Sekaraia hegi. Mbe khaŋ ana nzuai, “Ntige Sekaraian tuk ma. Ana ntigem, Fhe Bakɨme phena vhen ŋgirɨp, Fhe Bakɨme suaŋv ndɨga vhuuŋ hi khan nanan poonga.” ");
INSERT INTO geb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mbe ne suaŋgiap, mba tuk hɨgim, Sekaraia vov Fhe Bakɨme phena vhen vergap, Fhe Bakɨme nzuav ndɨga vhuuŋ hi khan nana mpooi. Ana khan nanan mpooim, mba Fhe Bakɨme ndikndigap ana zɨ ndi vun fi gumgi gu mbigi, mbe ana rargap Fhe Bakɨme phena bɨna vhen kav, Fhe Bakɨme phorga nzuai. ");
INSERT INTO geb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mbe Fhe Bakɨme phorga nzuav kim, Sekaraia mbu Fhe Bakɨme phena vhen kav khan nana mpoov kim, Fhe Bakɨme enser mbe fhura hav anan hɨgi. Ana hav, ana mba khan nana mpooi kaa gaar guva haren hav mbar thɨgi. ");
INSERT INTO geb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ana hav thɨgim, Sekaraia ana gangiap, guigira won rɨɨngiap, guigira rivgi. ");
INSERT INTO geb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ana rɨvim, mba Fhe Bakɨmen enser khaŋ ana nzuai, “Ena, Sekaraia, ndu rɨvɨ thari. Fhe Bakɨme ndu ana nzarigi nzambareŋ, ana ne mbararagi. Ndun muuŋ Erisabet, ana ndu gon ŋguga tegɨrga. Ana mba ŋguga tegɨrim, ndu kha zɨn anan nɨɨŋgiri, Zon. ");
INSERT INTO geb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ndu mbarara! Mba tar hɨgɨrga, ndu guigira ndikndigɨrga. Mba tugar gumgi gu mbigi vhɨrvera mba tara hɨgi ne suaŋv ndikndigɨrga. ");
INSERT INTO geb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mbe mba tara suaŋv ndikndigɨrga, ne khaŋ muuŋgi, mba tar, ana Fhe Bakɨme nɨman, ana zɨ bakɨme kɨrga. Ana vhɨra wain gum pan ŋanŋani pharan mbɨrga fhu. Ana vhɨra wo niamuuŋ ndav vhera kɨrim, Fhe Bakɨme won Ŋina Ŋaarar anan nɨɨŋgirim, ana Fhe Bakɨme Ŋina Ŋaara ŋkasŋka phorgɨv kɨrar hɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ana hɨgɨp ana zumgum taagip kha Isreriŋ gumgi gu mbigi vhɨrve ana taagip mbe ndigirim, mbe wo zɨn vuav piin ki Fhe Bakɨmen han ŋgɨrga. ");
INSERT INTO geb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ana vhɨra Iraiza Fhe Bakɨme Ŋina Ŋaarar panan ŋkasŋkagi ŋkasŋkan farar muuŋgip fharav Fhe Bakɨme nɨman ŋgɨrga. Ana suaŋrim, ndegi taagip ndavi domdorɨv guigira wari won tari vuzvugɨrga. Ana mba bigi rɨɨrɨɨi gumgi, ana mbe suaŋrim, mbe taagip ndavi domdorɨp, mba tɨvir vhuuiŋ kaŋgiap, nta mbui gumgi ganɨv, ndɨkndɨgi vhuuiŋ ndiv, taagip bigi mbarararga.” ");
INSERT INTO geb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Fhe Bakɨmen enser, ana mba bunin Sekaraia ga suaŋgim, Sekaraia anan nzarigi, “Gu ram muuŋgip kaŋgirie, ndu khar na nzuai buni guigira mba tegɨrie? Gu kaŋgi, gu guigira vurgim, nan muun saaŋ vhɨra mpari vhɨrve vhɨzgi.” ");
INSERT INTO geb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Sekaraia mba nzambaran ana mbuim, mba Fhe Bakɨmen enser ana ŋgarkarav khaŋ ana nzuai, “Ndu na kaŋgire? Gu Gabrier ma. Gu zazera Fhe Bakɨme han Hevenan ana nɨman ki enser ma. Gu ana han kim, ana kha kama vhuuen na nɨɨŋgiap, na sarigim, gu mba kama vhuuen ndu suan zav zergi. ");
INSERT INTO geb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ndu mbarara! Ndu na buneŋ khothɨgi fhu. Ndu ntigem thɨni mpɨrav, buni suanga fhu. Ndu mbara muuŋgip thɨni mpɨrav kɨrim, gu kha ndu suaŋgi buneŋ mba tegɨrga. Ndu thɨni mpɨrav mbara muuŋgip kɨrim, kha kameŋ guigira Fhe Bakɨme sarigi tugara mba tegɨrga. Mba kameŋ mba tegɨrga, ndu taagip thɨni ntarav buni suanga.” ");
INSERT INTO geb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sekaraia mba Fhe Bakɨme phena vhen ana phorga nzuav kim, mba gumgi gu mbigi, mbe Sekaraia rarga kɨrar kavra thav kha ndɨkndɨga mbui, “Khe thagɨna bigɨnara mbuav tuga mpeen kha Fhe Bakɨme phena vhen ki?” ");
INSERT INTO geb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mbe nen anan ndɨkndɨga kim, Sekaraia kɨrar hi. Ana kɨrar hɨga zav, mbe phorgɨ buni suangen mbovaragim, mbe kaŋgi. Ana Fhe Bakɨme phena vhen, Fhe Bakɨme wo bigɨna mben ana khɨvigi. Ana maaŋ muuŋgiap thɨni mpɨrigi. Mbe mba ndɨkndɨga ana mbuim, ana thɨni mparara kav farvera bigin panpana vov mbe phorga nzuai. ");
INSERT INTO geb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sekaraia mbara mbuav mbe phorga Fhe Bakɨme phenan ŋgarav kim, mbe ŋgari tugi vhɨzgim, Sekaraia taagiap wo ŋgun vugi. ");
INSERT INTO geb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Sekaraia taagia vugap kim, anan muuŋ Erisabet ndave rɨgap, wo vhagiap wo phena vhera kim, meeŋthɨgi kɨni vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Erisabet mba meeŋthɨgi kɨnin phena vhera kav khaŋ nzuai, “Fhe Bakɨme kha tɨvar na muuŋgi. Ana na kora muuŋgi. Gu fhum kha tuga mpeen, gu khuratim, kha gumgi gu mbigi na garim, gu nen mberav ki. Ana ntigem na tɨn mba memɨra ndigi. Mbe ntigem memɨran nan nɨɨnga fhu.” ");
INSERT INTO geb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Erisabet wo ndava kim, mpora thɨgi kɨni hɨgim, Fhe Bakɨme won enser Gebrier ga sarigi. Fhe Bakɨme Gebrier ga sarav khaŋ ana nzuai, “Ndu Gariri ŋgu bisaneŋ Nasaretan ŋgirɨri. Ndu ŋgirɨv, biptara kama mbe, ana fhum guma the phorga kuigi fhuvara. Mbe guma mbe nzuav ana ndi fagim, ana ki. Mba guma zɨ khare, Zosep. Ana Devitan nzɨk ma. Mbe mba fagi biptara kama zɨ khare, Maria.” ");
INSERT INTO geb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Fhe Bakɨme ma Gabrier ga suaŋgim, ana vera vov Maria garim, ana ki. Ana kim, Gabrier mbaram khaŋ ana nzuai, “Raar vhuuŋ, mbik, Fhe Bakɨme ndu phorga ki. Ana guigira ndu vuzvugiap, ndun ndikndigap, ndɨkndɨga vhuun ndu mbui.” ");
INSERT INTO geb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ana ne nzuaim, Maria mba kameŋ mbararagiap, guigira ŋgava mbatɨga muuŋgiap, kavtuik ana thɨgim, ana kha ndɨkndɨga mbui, “Khe ram muuŋgi kamen na nzuai?” ");
INSERT INTO geb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Maria mba ndɨkndɨga mbuim, mba Fhe Bakɨmen enser khaŋ ana nzuai, “Maria, ndu rɨvɨ thari. Fhe Bakɨme ndun tɨva vuzvugiap, ndun ndikndigi. ");
INSERT INTO geb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ndu mbarara! Ndu ndave rɨgɨp ŋguga the ruagirga. Ndu mba ŋguga ruagip kha zɨn anan tɨgɨri, Zisas. ");
INSERT INTO geb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mba tar, ana zumgum guigira zɨ bakɨme kɨrga. Ana za kha bigi kharav vu guarara ki Fhe Bakɨme, ana kha zɨn anan kamɨnga, nan Kam ma. Nza mba zɨn vov piin ki Fhe Bakɨme, ana maaŋ anan muuŋv, ana ndim farim, ana won nzɨga Devita ŋana ndigip ŋgu gari guman pan kɨrga. ");
INSERT INTO geb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ana won nzɨga ŋana ndigip, kha Isreriŋ gari guman pan kɨrga. Ana mben guman pan kɨv, ana zazera mbara muuŋgip kɨrga, ana vhɨzgirga tuktɨgi fhu.” ");
INSERT INTO geb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ana ne nzuaim, Maria thav mba Fhe Bakɨmen enserar nzarigi, “Mba bigeŋ ram muuŋgip nan hɨgɨrie? Gu mana the tɨgi fhu. Gu sɨɨŋra khar ki. Gu vhɨra guma the phorga kuigi fhu.” ");
INSERT INTO geb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Maria ne nzuaim, mba Fhe Bakɨme enser ana ŋgarkarav khaŋ ana nzuai, “Ndu mbarara! Fhe Bakɨme Ŋina Ŋaar ndun han zirgɨrga. Ndu ganɨnga za kha bigi kharav vu guarara ki Fhe Bakɨme won ŋkasŋka bakɨmen ndu vhararga. Fhe Bakɨme maaŋ muuŋgirga. Ndu mba ruagirga tara ŋaar, Fhe Bakɨme kha zɨn anan kamɨnga, nan Kam ma. ");
INSERT INTO geb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Ena, ndu mbarara, ndun niamuuŋ ntok Erisabet, ana guigira vurgi. Mbe fhum khaŋ ana nzuai, ‘Ana khurati.’ Ndu ntige mbarararga ana ndavar kim, mpora thɨgi kɨni vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ndu mbarara! Fhe Bakɨme muungeŋ kakagi bigɨn the ki fhuvara.” ");
INSERT INTO geb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ana nen Maria ga nzuaim, Maria mbaram khaŋ ana nzuai, “Aria, ne nzerara. Gu Guma Bakɨmen ŋaara mbik ma. Ana mbar ndu na suaŋgi tɨvar mbar nan hɨ.” Maria ne suaŋgim, mba Fhe Bakɨme enser ana thav vui. ");
INSERT INTO geb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ana Maria thav vugim, Maria mba tugera wo bigi bevahegap, mbara wo ŋgu thav vhemkora khavgiap, mba Zudia mbɨkshɨman ki ŋgu mben ndai. ");
INSERT INTO geb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ana nda vov ŋgun hɨgap, mbaram Sekaraia phenan vui. Ana vov Sekaraia phena vhen vergap, za Erisabetan kamgia khaŋ ana nzuai, “Raar vhuuŋ, mama Erisabet.” ");
INSERT INTO geb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Maria raar vhuun Erisabet ga ndɨɨim, Erisabet ana mbararavra thagim, mba Erisabet ndava vhen ki tar vhɨra, ana ndava vhen kav fega mbarigi. Mba tar ana ndava vhen kav fega mbarigim, Fhe Bakɨmen Ŋina Ŋaar zera zav Erisabet vharigi. ");
INSERT INTO geb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Fhe Bakɨme Ŋina Ŋaar Erisabet vharigim, ana kama bakɨme rugap khaŋ nzuai, “Ndu za kha mbigi rɨgar Fhe Bakɨme ndɨkndɨga vhuun ndu mbui. Ndu vhɨra mba tegɨrga tar, Fhe Bakɨme vhɨra ndɨkndɨga vhuuŋra ana mbui! ");
INSERT INTO geb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Gu ram muuŋgi khesharigi mbik, maaŋgiap nan Guma Bakɨmen niamuuŋ nan han zi? ");
INSERT INTO geb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ndu na mbarara! Ndu zav raar vhuun na ndɨɨvra thagim, na ndava vhen ki tar, ana guigira ndikndigap na ndav vhen fega mbarigi. ");
INSERT INTO geb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ndu, Fhe Bakɨme ndɨkndɨga vhuun ndu mbui. Ndu Fhe Bakɨme enser, ana Fhe Bakɨme ndun muun za suaŋgi bigeŋ guigira mba tegɨrga ne khothɨgi. Ndu ne suaŋv guigira ndikndigɨri.” ");
INSERT INTO geb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Erisabet nen Maria ga suaŋgim, Maria khaŋ nzuai, “Na ndava vhee guigira Fhe Bakɨmen ndikndigav ana zɨ ndi vun kuagi. ");
INSERT INTO geb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Na ndava vhen ki guma, ana guigira Fhe Bakɨmen ndikndigi. Fhe Bakɨme, ana taagip na ndiv nan kurkurarga guma ma. ");
INSERT INTO geb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Gu anan ŋaara mbiga khɨn ma. Gu zɨ ki mbik fhuvara. Ana nduara na gangiap nan kora muuŋgi. Mbe ntige gum zumgum, kha mbigi gu gumgi, mbe khaŋ na suanga, ‘Fhe Bakɨme ndɨkndɨga vhuuŋ na muuŋgi.’ ");
INSERT INTO geb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Gu kaŋgi, za kha bigi ga muuŋgiap nta kharav ŋkasŋka vun guarara ki Fhe Bakɨme, ana guigira bigɨna bakɨmen na muuŋgi. Ana zɨ ŋgaravra kɨrga. ");
INSERT INTO geb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Fhe Bakɨme vhɨra mba ana rɨvav ana piin ki gumgi gu mbigi, ana guigira mbe kora mbui. Ana ntige khar ki ntɨɨri, ana mbe kora mbui, ana vhɨra zumgum hɨrga ntɨɨri, ana vhɨra mbe korar muuŋgirga. ");
INSERT INTO geb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Fhe Bakɨme won farvenin ŋaari bakɨvin muuŋgirga. Ana mba wo zɨri ndim vun kuamkuarga gumgi, ana mbe sasararga, mbe tamtam ŋgegɨrga. ");
INSERT INTO geb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ana mba ŋgui ganɨnga gumgir pani, ana mben ŋkasŋkagi, ana nta mbevarga, nta ŋgirgɨrga. Ana mba wo mbevigi gumgi, ana mbe suirav mbe vun fegɨrga, mbe zɨri vun ndarga. ");
INSERT INTO geb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ana maaŋ muunga, ana mba bigi sosuagi gumgi, ana bigi vhuuiŋra mbe nɨɨŋgirga, mbe bigi tuktɨgɨrga. Ana mba bigi vhɨrve ki gumgi, ana fhura mbe vharav mbe sararga, mbe fhura ŋgegɨrga. ");
INSERT INTO geb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ana won ŋaara gumgi Isreriŋ, ana mben kurkurarga. Ana mben kurkurav, ana vhɨra fhum Abraham ga suaŋgi kameŋ, ana ne ndɨkndɨk suiravra ki. Ana vhɨra nzan nzɨgi, ana mba kameŋ zɨn ŋgɨv, ana zumgum mbe hɨrga, ana zazera mben korar muuŋgirga.” ");
INSERT INTO geb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria kha buni suaŋgiap, ana Erisabet phorga kim, kɨni phuni khegene vhɨzɨ za mbuim, ana taagia wo ŋgun vugi. ");
INSERT INTO geb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Maria taagia wo ŋgun vugim, Erisabet ki. Ana ka vov, ana mba ndavar ki tara ruarga tuk hɨgim, ana ŋguga ruagi. ");
INSERT INTO geb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Erisabet ŋguga ruagim, mba anan fek gu tari gum, anan ŋgu ntɨɨri, mbe Fhe Bakɨme ana kora muuŋgiap guigira tɨvar vhuuŋra ana muuŋgi ne mbararagiap, mbe ne nzuav ana phorgav ndikndiga mbatɨga mbui. ");
INSERT INTO geb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mba tar hɨgap kim, sɨgarathɨgi raa hɨgim, mba tara ndia gum niamuuŋ, mani phorge regi ntɨɨri, mbe zav an foon za mbui. Mbe ana fooŋgip, ana ndia Sekaraia zɨram anan tɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mbe ne nzuaim, anan niamuuŋ kama hegap khaŋ mbe nzuai, “Fhuvara! Nza kha zɨn anan tɨgɨrga, Zon.” ");
INSERT INTO geb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ana ne nzuaim, mbe khaŋ ana nzuai, “Fhuvara mba tara ndegi gum nzɨgi, anan tori mbe the mba zɨ zɨmgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mbe nen ana niamuuŋ ga nzuav, farveram ana ndia ga nzuav ana zɨ nzuav anan nzai. ");
INSERT INTO geb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mbe Sekaraian nzaim, Sekaraia mbe nzuaim, mbe kheri bigɨn mueŋ ndigap zav ana nɨɨŋgim, ana mba bigɨnen ana zɨ khergi. Ana mba gaveŋ kherav khaŋ nzuai, “Ana zɨ Zon.” Ana mba zɨ khergim, mba gumgi gu mbigi mba zɨ gangiap, mbe ŋgava mbatɨga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sekaraia mba zɨ kheravra thav, Sekaraia wom kama furav buni nzuai. Ana ze ana bɨkbɨɨgim, ana mbaram Fhe Bakɨme zɨ ndi vun kuamkuav, anan ndikndigi. ");
INSERT INTO geb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sekaraia wom buni nzuav Fhe Bakɨme zɨ ndi vun kuamkuagim, mba Sekaraia han ki ntɨɨri gum anan ŋgu ntɨɨri, mbe mba bigi gangiap guigira rivgi. Mbe rivim, mba bigɨnan kameŋ za mba Zudia fhain mba mbɨkshɨɨr ki ŋgui ga ruigi. Mba ŋguir ki gumgi, mbe za mba hɨgi bigi, mbe nta neŋgap nta nzuai. ");
INSERT INTO geb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mbe nta nzuaim, mba nta mbararagi gumgi gu mbigi vhɨrve mbe mba buni mbararav, wari wo ndavi vherira kha ndɨkndɨga mbui, “Mba tar zumgum ram muuŋgi guma kɨrie?” Mbe kaŋgi, Fhe Bakɨme ana phorga kav anan kurkurigi. ");
INSERT INTO geb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mba tara ndia Sekaraia, Fhe Bakɨme won Ŋina Ŋaara sarigim, ana zerav ana vharigim, ana Fhe Bakɨme zumgum muunga bigi, ana nta bun nzuai. Ana nzuav khaŋ nzuai, ");
INSERT INTO geb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","70","“Fhe Bakɨme fhum guarara mba kamen wo kamthooŋ gumgir ŋaari ga suaŋgim, mbe ne bun suaŋgi. Nza Isreriŋ Guma Bakɨme zɨ ndiv vun kuamkuarga. Ana taagip wo gumgi gu mbigi ndir saŋv zɨrga. Ana won ŋaara guma Devit, anan nzɨga mbe taagi nza ndirga guman ŋkasŋka the tegɨrga. Ne ntige khar hɨr za mbui. ");
INSERT INTO geb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mba kameŋ khaŋ nzuai, ‘Ana taagip nza pana gumgi tɨn nza ndigirga. Ana vhɨra mba panan nza kegi gumgi, ana vhɨra mbe farve tɨn nza ndigirga.’ ");
INSERT INTO geb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ana maaŋ muuŋv won kora muumbarar nza ndegi khɨvɨv mben kurkurav, ana vhɨra mba fhum nzan nzɨgi ga suaŋgi kaman ŋaareŋ, ana ne ndɨkndɨk suiravra kɨrga. ");
INSERT INTO geb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ana fhum kha kama ŋaaren nzan nzɨga Abraham ga suaŋgi. ‘Gu ndun Fhe Bakɨme, gu kha vun ki. Gu guigi guarara ndu nzuai, ");
INSERT INTO geb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","gu taagip nden pana gumgi fari tɨn nde ndigirga. Nde nan ŋaarar muuŋv mben rɨvɨrga fhuvara.’ ");
INSERT INTO geb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nza anan ŋaarar muuŋv, nza kha tugivigen ana nzuai tɨvir ŋaarira muuŋv, anan nɨman nzerara kha nuianan kɨrga. ");
INSERT INTO geb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ndu, nan Kam, Fhe Bakɨme zumgum khaŋ ndu suanga, ‘Ndu za kha bigi kharav vun guarara ki Fhe Bakɨmen kamthooŋ guma ma. Ndu khaŋ muunga, ndu fharav ŋgɨp Guma Bakɨme suaŋv tuavar muuŋgirga. ");
INSERT INTO geb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ndu fharav ŋgɨp Fhe Bakɨme taagip wo gumgi gu mbigi ndirgane bun mbe suanga.’ Mbe ndu buni mbararav, ndavi domdorɨrim, Fhe Bakɨme mbe fhum muuŋgi tɨvi mbatɨgi vhɨzɨrga. ");
INSERT INTO geb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Fhe Bakɨme guigira nza kora muuŋgi. Ana maaŋ muuŋgiap ana vhɨra Hevenan kav, ana shɨrigi ra sararim, ana nza han zirɨrga. ");
INSERT INTO geb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ana zirɨv, kha nuianan nza khar kav tɨvi mbatɨgi ga mbui gumgi gu mbigi, nza mba tɨvi mbatɨgi ga mbuim, nta nza vharigim, nza nta gɨngɨnan ki. Nza mba tɨvi mbatɨgi gɨngɨnan kim, nta nza shogim, nza vhɨzgi ntuu ma. Mba ra zirɨp, nza shɨrarim, nza mba tɨvi mbatɨgi thav, kɨrar hegɨp tuituigi tuavar vhuuŋ ganɨv, mba tuavar vhuun ŋgɨv, ndavi mbɨrav wari kɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Sekaraia mba buni suaŋgim, mba tar zumgum vhuuv, Fhe Bakɨme buni mbararav nta khothɨgap, guigira khaŋ tɨgap havhargiap Fhe Bakɨme buni zɨn vui. Ana Fhe Bakɨme buni zɨn vov, gumgi ki fhuv ŋanen kav kav, thav kɨrar hɨgap, mba Fhe Bakɨme ana suaŋgi buni, ana nta bun Isreran ki gumgi gu mbigi ga nzuai. ");
INSERT INTO geb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Erisabet Zon Gumgi Ruai Guma ruagim, ana hɨgap ki. Mba tugivigen Sisar Agastas, ana mba Roman guman pan ki. Ana mbe gari guman pan kav, ana kha kama havhareŋ ndi tɨgi. Mba kameŋ khaŋ nzuai, “Nde kha Roman guman pan gari ŋguir ki gumgi gu mbigi, Rom gari guman pan zɨv za nde zɨri ndirga.” ");
INSERT INTO geb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mbe mba tugen Sisar Kuairinias ndim fagim, ana Siria fhaiŋ gari guman pan ki. Ana Siria gari guman pan kim, mbe fhara guarara, mba gumgi gu mbigi zɨri ndigi. ");
INSERT INTO geb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mba Rom gari guman pan mba kama havhareŋ ndi tɨgav khaŋ nzuai, “Nde kha Roman guman pan gari ŋguir ki gumgi gu mbigi, nde ŋgɨp tamtam harigi ŋguir kɨv, nde taagi ŋgɨp wari wo nzɨgi gum ndegi kegi ŋgu nɨɨŋgera ŋgegɨrim, Rom gari guman pan zɨv nde zɨri ndirga.” Mbe maaŋ suaŋgim, mbe taagia wari wo ŋguir vui. ");
INSERT INTO geb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Maaŋ muuŋgiap, Zosep Garirin ŋgu bisaneŋ Nasaretan kegap, khavgiap, Zudian won nzɨga Devita ŋgu bisaneŋ Betreheman ndai. Ana Devitan shɨk ma. Ana maaŋ muuŋgiap Betreheman ndai. ");
INSERT INTO geb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ana khavgiav ndav, ana vhɨra mbe ana ndim fagi muuŋ Maria, ana ndavar ki, ana vhɨra anan kov mani ndai. Maria vhɨra mba ndavar ki tara tɨrga tuk han mbarigi. Zosep maaŋ muuŋgiap anan kov mani ndai. ");
INSERT INTO geb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mani ndav Betreheman kav, Maria mba ndavar ki tar ana mbuim, ana ana ruagi. ");
INSERT INTO geb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Maria maam won kama bara ruagiap, shagi fɨgir ana zigap, ana ndim mbe tor daa ndim vhazɨgi ndi suim, mbe pi kovsɨga khɨngi. Mani khaŋ muuŋgiap, vov mba tor daa phena kui. Mbe mba harigi ŋgui ndav Betreheman kui pheni za givigi. ");
INSERT INTO geb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mba tugen sipsivi gari gumgi mbari, mbe maan wo sipsivi garav, mba ŋgu bakɨme gaar mba tugi kɨrin ki. ");
INSERT INTO geb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mbe wo sipsivi garav kim, Fhe Bakɨmen enser mbe mben hɨgi. Ana mben hɨgim, Fhe Bakɨmen ŋkasŋka vhava ŋaara fara muuŋgiap mbe shɨrav za mbe behuigi. Mbe mba vhava ŋaar mbe shɨrigim, mbe guigira rɨrɨva mbatɨga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mbe rɨvim, mba Fhe Bakɨme enser khaŋ mbe nzuai, “Nde rɨvɨ thari. Gu buna vhuuŋ goreŋra ndiga nde ndi zi. Mba buna vhuueŋ za kha gumgi ga nzuai buneŋ ma. Kha buneŋ za kha gumgir muuŋgirim, mbe za guigira ndikndigɨrga. ");
INSERT INTO geb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nde na mbarara, ntige kha maan Devit ŋgu bisaneŋ Betreheman, taagi nde ndiv nden kurkurarga guma, ana niamuuŋ ana ruagi. Ana Fhe Bakɨme taagiv kha nuianan ki gumgi gu mbigi ndir zav suaŋgiap farasarav sarigi guma ma, ana Guma Bakɨme ma. ");
INSERT INTO geb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nde ŋgɨp ana ganɨv, nde khaŋ muuŋgip gangip kaŋgirga. Nde ŋgɨp ganɨnga, tara mbe, ana niamuuŋ ntigera ana ruagiap, shagi fɨgir ana zigap, ana ndim tor daa ndim vhazɨgi ndi suim, mbe pi kovsɨga khɨngim, ana rɨga ka kui.” ");
INSERT INTO geb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mba Fhe Bakɨme enser mba kamen mbe suaŋgiap gorovra thagi, mbarkɨrga mbarkɨrga enseri, mbe Fhe Bakɨme han Hevenan kegap hav ana phorgap, mbe Fhe Bakɨme zɨ ndi vun kuamkuagi. ");
INSERT INTO geb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Mbe Fhe Bakɨme zɨ ndiv vun kuamkuav khaŋ nzuai, “Nza Fhe Bakɨme zɨ ndiv vun guarara kuamkuarga. Anan guigira za kha bigi kharav vun guarara ki Fhe Bakɨme ma. Ana kha nuianan vuzvugi gumgi gu mbigi, mbe ndavi mbɨrari.” ");
INSERT INTO geb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mba Fhe Bakɨme enseri, mbe Fhe Bakɨme zɨ ndi vun kuamkuagia wari taagiap Hevenan ndagim, mba sipsivi gari gumgi, mbe khaŋ wari ga nzuai, “Aria, nde khavɨ, nza Betreheman ŋgɨv mba Fhe Bakɨme enser nza suaŋgi bigeŋ ganɨnga.” ");
INSERT INTO geb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mba sipsivi gari gumgi ne wari ga suaŋgiap, mbaram vhemkora khavgiav wari vui. Mbe vov Betreheman hegap garim, Maria gum Zosep ki. Mbe mani garav, mba tara garim, Maria shagir ana zigap ana ndim mbe tor daa ndim mba ndi suim mbe pi kovsɨk khɨngim, ana rɨgap ka kui. ");
INSERT INTO geb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mba sipsivi gari gumgi, mbe ana gangiap, mbaram mbe mba Fhe Bakɨmen enser, ana mba tara bun mbe nzuav suaŋgi kameŋ bun za mbe suaŋgi. ");
INSERT INTO geb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mbe ne bun mbe suaŋgim, mba kameŋ mbararagi gumgi gu mbigi, mbe mba sipsivi gari gumgi mbe suaŋgi kameŋ, mbe mba kameŋ mbararagiap, guigira ŋgava mbatɨga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mbe ŋgava mbatɨga mbuim, Maria mba bigi, ana za nta mbararagiap, mba bigi ndim wo ndava vhee tɨgap, nta ndɨkndɨk suirav ki. ");
INSERT INTO geb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mba sipsivi gari gumgi, mbe taagia vov, khueŋ nzuav Fhe Bakɨme ndikndigap ana zɨ ndiv vun kuamkuav wari vui. Mbe vov Fhe Bakɨme mba tara bun mbe nzuav suaŋgi kameŋ, mbe vov mba bigi garim, nta mba kamera zɨn vugi. ");
INSERT INTO geb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mbe vegim, mba tar hɨgap kim, sɨgarathɨgi raa hɨgi. Mba raa hɨgim, mbe anan foon za mbuav kha zɨn ana nɨɨŋgi, Zisas. Kha zɨ, mba Fhe Bakɨme enser kha tara ndavar kɨr zav Maria ga nzuav, ana anan nɨɨnga zɨ phorga ana suaŋgi. Mbe mba zɨn ana nɨɨŋgi. ");
INSERT INTO geb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mba tar hɨgap kim, Zosep gum Maria, mba Moses fhum mbe nzuav tɨgi tɨva zɨn vui. Maria mbirɨga suirav, ana mba tɨva zɨn vov, mani mba sarigi tugir rargap ki. Mani kav kim, mba tugi vhɨzgim, mani Maria wo nzuav Fhe Bakɨme nɨman taagiv ŋgara zav Fhe Bakɨme nzuav shaman muun zav Zerusareman ndai. Mani ndav vhɨra mba taran Fhe Bakɨmen nɨɨn zav wani ndai. ");
INSERT INTO geb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kha tɨv Guma Bakɨme suaŋgi tɨv ma. Moses ana khergim, ana gavar ki. Mba tɨv khaŋ nzuai, “Guma, anan muuŋ fharav kam bara ruagirim, ana mba taran Fhe Bakɨmen nɨɨŋgiri.” ");
INSERT INTO geb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Zosep gum Maria, mani mba tara ndiga ndav, mani vhɨra mba Fhe Bakɨme suaŋgi tɨva zɨn ŋgɨp, Maria Fhe Bakɨme nɨman taagip ŋgara zav shaman muun zav ndagi. Fhe Bakɨme muun zav mbe nzuav tɨgi tɨv khare. Mbe ana suaŋv shaman muun saŋv, mbe fhomne phunini o kora ntoga phunini, mbe maaŋ muuŋgip ndigɨv ana suaŋv shaman muunga. ");
INSERT INTO geb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mani ndagim, guma mbe, ana Zerusareman ki, ana zɨ Simeon. Ana guigira tɨvir vhuuiŋra mbui guma ma. Ana vhɨra Fhe Bakɨme buni mbararav, ana zazera Fhe Bakɨme nzuai tɨvi zɨn vui guma ma. Ana vhɨra mba Isrerin kurkurav mben simtɨgi ndiv ndava mɨɨtɨgar mben nɨɨn zav zi guma ganɨ zav, anan rarga ki. Simeon Fhe Bakɨme Ŋina Ŋaar guigira ana phorga ki. ");
INSERT INTO geb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mba Fhe Bakɨme Ŋina Ŋaar fhum khaŋ ana suaŋgi, “Ndu gura rimgirga fhuvara. Ndu khara muuŋgip kɨv, Fhe Bakɨme won gumgi gu mbigi, ana mben kurkurav taagi mbe ndir zav sarigi Guma Bakɨme, Krais, ana kha nuianan hɨgɨrim, ndu ana gangip za rɨmɨnga.” ");
INSERT INTO geb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","Ana maaŋ muuŋgiap kav kim, Fhe Bakɨme Ŋina Ŋaar ana rugim, ana khavgia vov Fhe Bakɨme phena bɨna vhen veri. Ana verim, Zisas niamuuŋ gum ndia, mbe Fhe Bakɨme suaŋgi tɨva zɨn vov ana ndi Fhe Bakɨmen nɨɨn zav, vhɨra Fhe Bakɨme phena bɨna vhen veri. Mani ana ndigap, Fhe Bakɨme phena bɨna vhen vergim, Simeon mani han ana ndigap, ana sɨgɨra khɨngiap, Fhe Bakɨme zɨ ndi vun kuamkuav, khaŋ nzuai, ");
INSERT INTO geb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Guma Bakɨme, gu ndu ŋaara guma ma. Ndu ntigem na ganɨrim, gu ndava mɨɨtɨga ndigip ŋgɨrga. ");
INSERT INTO geb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Gu won rɨmanira ndu taagip won gumgi gu mbigi ndiv mben kurkura zav suaŋgiap farasarigi guma gangi. ");
INSERT INTO geb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ndu ntigem za ana bevahegim, kha gumgi gu mbigi, mbe zam ana ganɨnga. ");
INSERT INTO geb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ana anan tuavar vhuun harigi ŋgui gumgi gu mbigi khɨvɨrga vhava ŋaar ma. Ana mbe shɨrarim, mbe tuituigip ndu mbe nzuai tɨvi ganɨp nta kaŋgirga. Mba harigi ŋgui ntɨɨri, mbe nta kaŋgip, nta zɨn ŋgɨp, ne suaŋv, ndu gumgi gu mbigi Isreriŋ, mbe mben ndikndigirga.” ");
INSERT INTO geb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeon ne Zisas ga suaŋgim, an niamuuŋ gum ndia ne mbararagiap ndɨkndɨgi vhɨrve ga mbui. ");
INSERT INTO geb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Maria gum Zosep ne mbararagiap ndɨkndɨgi vhɨrve ga mbuim, Simeon mbaram ŋgɨrkama vhuun mbe muuŋgiap, khaŋ mba tara niamuuŋ Maria ga nzuai, “Ndu mbarara, kha tar, ana zumgum Isreriŋ gumgi gu mbigi vhɨrver muuŋrim, mbe ana khɨgɨ rɨrga. Ana vhɨra taagip Isreriŋ gumgi gu mbigi vhɨrve muuŋrim, mbe taagip khavɨ thivɨrga. Mbe vhɨra ana ganɨnga, ana Fhe Bakɨme vuzvugi tɨvir mbe khɨvɨrga. Mba gumgi gu mbigi vhɨrve mbe ne suaŋv buni mbatɨgir ana suanga. ");
INSERT INTO geb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mba tar, ana vhɨra mba gumgi gu mbigi wari wo ndavi vherir zomzorgia ki ndɨkndɨgi, ana nta suirav nta ndiv kɨra khɨngirga. Ana maaŋ muunga, mba gumgi gu mbigi, mbe panan ana kegɨrga. Ndu maaŋ muuŋgip wo khɨkhɨm mbarararga, mbe kozan ndu gor ga si tɨvar muunga.” ");
INSERT INTO geb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mba tugen Fhe Bakɨme kamthooŋ mbiga mbe, ana vhɨra mba Fhe Bakɨme phena bɨna vhen ki. Ana zɨ Ana. Ana guigira mbiga vur ma. Ana ana Penuer kambik ma. Penuer anan nzɨk Aser. Ana mana tɨgap kim, harathɨgi mpari vhɨzgim, anan mana rimgi. ");
INSERT INTO geb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ana mana rimgim, ana sɨɨŋra ka vov, ana mpari 84 thɨgi. Ana, ana zazera Fhe Bakɨme phena bɨna vhen ki. Ana kav, ana raa gu maan Fhe Bakɨmen ndikndigap ana phorga nzuav, mba thamthav ki. ");
INSERT INTO geb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ana vhɨra mba tugera zav mba tara han zɨgap Fhe Bakɨme zɨ ndi vun kuamkuav, anan ndikndigap, ana phorga nzuai. Ana mba tara nzuav Fhe Bakɨme phorga suaŋgiap, mbaram maaŋ ki gumgi gu mbigi ga nzuai, “Nde Fhe Bakɨme taagip Zerusareman ndir zav suaŋgiap sarigi guman rarga ki gumgi gu mbigi, gu guigira nde nzuai, kha tar, ana mba guma ma.” ");
INSERT INTO geb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mba tugen Maria gu Zosep mba Fhe Bakɨme phena bɨna vhen vhergap, mani mba Guma Bakɨme muun za suaŋgi tɨvi, mani za mba tɨvi ga muuŋgi. Mani mba tɨvi ga muuŋgiap, mbaram mba Fhe Bakɨme Phena thav, wani taagiap, mbe Garirin wo ŋgu bisaneŋ Nasaretan vergi. ");
INSERT INTO geb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Maria gu Zosep taagia vergap Nasaretan kim, mba tar vhuui. Ana vhuuv, guigira ŋkasŋka mbatɨga muuŋgiap, Fhe Bakɨme suaŋgi tɨvi zɨn vui. Ana nta zɨn vov, ndɨkndɨgi vhuuiŋ guigira ana ndɨkndɨgar kim, Fhe Bakɨme guigira ndɨkndɨga vhuun ana mbui. ");
INSERT INTO geb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Zisas niamuuŋ gu ndia mpari tugɨratɨgap Pasova shama bakɨmen muun zav Zerusareman ndai. ");
INSERT INTO geb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","43","Mbe ndagi tugen Zisas tarara kav, anan mpari khaŋ muuŋgi, 12 thɨgi. Anan niamuuŋ gu ndia anan kov, mbe won tɨva zɨn vov mba Pasova shama bakɨme muun zav ndagi. Mbe ndav mba Pasova shama bakɨme muuŋgim, ana vhɨzgim, anan niamuuŋ gu ndia taagia verim, Zisas Zerusaremra ki. Anan niamuuŋ gu ndia ana mbar kagi ne kaŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mani khueŋ ndɨkndɨgi, Zisas ana mba mbe wari tɨgap zeri ntɨɨri, ana mbe phorga zeri. Mani ne suaŋgiap, mbe zerav kim, ra mbe vhɨzgi. Mba ra vhɨzgim, mani ana nzuav garav, mani won kɨvntogi gum mbe wo kaŋgi gumgi gu mbigi, mani mben nzai. ");
INSERT INTO geb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mani mben nzavra thav, mbaram ana ndi garav taagiap Zerusareman ndai. ");
INSERT INTO geb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mani ndav ana ndim gara ruav kim, ra phuni khegene vhɨzgi. Mani vov ana garim, ana Fhe Bakɨme Phena bɨna vhen mba Fhe Bakɨme buni gum tɨvi kaŋgi gumgi ruu rɨgar perav ki. Ana perav kav, mbe buni mbararav, mben nzav, mbe phorga nzuav ki. ");
INSERT INTO geb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ana mbe phorga nzuaim, mbe anan nzaim, ana mbe ŋgarkav mbe nzuai buni, maaŋ ki gumgi gu mbigi, mbe mba buni mbararav, mbe guigira ŋgava mbatɨga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ana mbe phorga nzuav perav kim, anan niamuuŋ gu ndia vov ana gangiap guigira ne nzuav ŋgava mbatɨga muuŋgi. Mani ŋgava mbatɨga muuŋgiap, anan niamuuŋ mbaram khaŋ ana nzuai, “Kha tar, ndu ram nzuav kha tɨvar ŋka muuŋgi? Ndun ndia ŋka ndu nzuav gor kuige rɨgap wani ndu nzuav gara rui.” ");
INSERT INTO geb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Anan niamuuŋ maaŋ nzuaim, ana mani ŋgarkarav mani nzarigi, “Ŋko thaŋ nzuav na ndim gara rui? Ŋko khueŋ kaŋgi fhuve? Gu wo Ndia phenan kɨrga?” ");
INSERT INTO geb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ana nen mani ga nzuaim, mani mba kameŋ nɨɨeŋ kaŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ana nen mani ga suaŋgiap, thav khavgiap, mani phorgav mbe taagia Nasaretan veri. Ana mani phorga vergap, mani buni mbararav tɨvar vhuuŋra mbuav mani phorga ki. Ana mani phorga kim, anan niamuuŋ, ana mba suaŋgi buni gum anan tɨvi, ana nta garav, nta ndi wo ndava vhee tɨgap, nta ndɨkndɨk suirav ki. ");
INSERT INTO geb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Anan niamuuŋ mba bigi ndɨkndɨk suirav kim, Zisas thav vhuuv, guma ruma mbuav, ŋkasŋka mbatɨga muuŋgiap, thɨga havhargia Fhe Bakɨme nzuai tɨvi kaŋgia nta zɨn vui. Ana maaŋ mbuim, Fhe Bakɨme guigira ana vuzvugiap, ana nzuav ndikndigim, gumgi gu mbigi vhɨra ana vuzvugi. ");
INSERT INTO geb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Sisar Taiberias Roma gari guman pan kav kim, anan 15 mparive hɨgi. Mba tugen Pontius Pairat, ana Zudia fhaiŋ gari guman pana vhari ki. Herot, ana mba tugen, ana Gariri fhaiŋ gari guman pan ki. Anan ŋguga Firip, ana Ituria gum Trakonitis fhaiŋ gari guman pan ki. Risanias, ana Abirene fhaiŋ gari guman pan ki. Mba tugen Anas gum Kaiafas, mani Fhe Bakɨme rotu gari guman panani ki. Mba tugen Sekaraian kama Zon, ana gumgi ki fhuv ŋanen kim, Fhe Bakɨme wo bunin mba gumgi gu mbigi ga suan za ana suaŋgi. ");
INSERT INTO geb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Zon Gumgi Ruai Guma mba Zordan mbɨ gani ga ruav Fhe Bakɨme buni vhuuiŋ bun nzuaim, gumgi gu mbigi ana han zi. Mbe zim, ana khaŋ mbe nzuai, “Nde ndavi domdorɨrim, gu nde ruarim, Fhe Bakɨme nde fhum muuŋgi tɨvi mbatɨgi vhɨzgip, nta ndɨkndɨk ŋangirga.” ");
INSERT INTO geb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Fhum Fhe Bakɨme kha kameŋ wo kamthooŋ guma Aisaia ga nɨɨŋgi. Ana ne khergim, ne ana gavar ki. Mba kameŋ khare, “Guma the, ana gumgi ki fhuv ŋanen kɨv kamɨv khaŋ suanga, ‘Nde Guma Bakɨme suaŋv tuavi khɨrɨv nta ndim thɨgara maaŋri. ");
INSERT INTO geb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nde mba tuavar ki rugi ndavi, nde nta pɨnɨv, nde mba mbɨkshɨɨ bakɨvi gum bisaŋrire, nde nta khov, nta ndim thɨgɨra maaŋri. Mba kɨzgeregi tuavi, nde ntan muuŋgirim, nta purara mbarari. Nde mba kora verav ndagi tuavi, nde ntan muuŋgirim, nta guigira mbɨrira ŋgɨgɨri. ");
INSERT INTO geb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nde maaŋ muunga, kha nuianan ki gumgi gu mbigi, mbe zam Fhe Bakɨme taagi mbe ndirga tɨva ganɨnga.’ ” Khe Fhe Bakɨmen kamthooŋ guma Aisaia suaŋgi buni khare. Ana buni zav khara thɨgi. ");
INSERT INTO geb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Zon Gumgi Ruai Guma fhum Fhe Bakɨme kamthooŋ guma Aisaia suaŋgi bunira zɨn vugap, ana zav, gumgi ki fhuv ŋanen hɨgi. Ana hɨgap, Fhe Bakɨme buni vhuuiŋ bun nzuaim, gumgi gu mbigi vhɨrve wari ruar zav khavgiap Zon Gumgi Ruai Guma han zi. Mbe ana han zim, ana khaŋ mbe nzuai, “Nde kurigi mbatɨgi fara muuŋgi gumgi, Fhe Bakɨme ndav shirɨ bakɨme, nden ki. The nde suaŋgim, nde ana ndav shirɨ ŋkɨɨa khɨngip regɨrie? ");
INSERT INTO geb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Gu guigira nde nzuai, nde guigira ndavi domdorgip, nde Fhe Bakɨme nzuai tɨvir muuŋri. Nde mba tɨvir muunga, nde ndavi domdorgi tɨvi mba ti. Nde maaŋ muuŋ thav, thaŋ nzuav fhura khaŋ wari ga nzuai, ‘Nza Abrahaman nzɨgi ma.’ Gu guigira nde nzuai, Fhe Bakɨme vuzvuk ma. Ana vuzvugirga, ana ntige kha ŋkɨɨr gumgi tharir muuŋgirga, mba gumgi mbe Abrahaman nzɨgi kɨrga. ");
INSERT INTO geb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nde khueŋ mbarara. Tuik ntigem khira ndɨɨrin ki. Khira vhɨgi vhuuiŋ mbai fhu, mbe mba khira kɨv, nta gorɨv, nta fuv vhava suegɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ana ne nzuaim, mba gumgi gu mbigi vhɨrve ne mbararagiap anan nzarigi, “Maaŋgi, nza ram muuŋrie?” ");
INSERT INTO geb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Mbe mba nzambareŋ ga muuŋgim, Zon Gumgi Ruai Guma mbe ŋgarkarav khaŋ mbe nzuai, “Guma fhava shaara phunini kɨv, ana then mba fhava shaar ki fhuv guma then nɨɨŋgiri. Guma mba ki, ana vhɨra mba tɨvara muuŋgiri. Ana mban mba mba ki fhuv guman nɨɨŋgiri.” ");
INSERT INTO geb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ana mba bunin mbe nzuav kim, ŋkɨɨa ndia rui gumgi mbari, mbe vhɨra wari ruar zav zegi. Mbe zegap anan nzarigi, “Guma Rum, nza ram muuŋrie?” ");
INSERT INTO geb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ana mbe ŋgarkarav khaŋ mbe nzuai, “Nde mba gumgi han ŋkɨɨa ndiv, nde mba ŋgu gari guman pan ndir zav nde suaŋgi thara zɨn ŋgɨv mbe han ŋkɨɨa ndiri. Nde mba tha kamaŋv fhura mbe guiguigip mbe ŋkɨɨa ndi thari.” ");
INSERT INTO geb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ana maaŋ mbe nzuaim, mba ntari ga mbui gɨɨtɨvi mbari maaŋ kav vhɨra anan nzarigi, “Maaŋgi, nza ram muuŋrie?” Ana mbe ŋgarkarav khaŋ mbe nzuai, “Nde ŋkɨɨa kɨvgip ndirgane suaŋv fhura gumgi ga shɨshɨgɨp, rɨrɨvar mben nɨɨŋv, mbe ŋkɨɨa ndi thari. Nde guman pan nde vhezi vhez, ana nde tugɨra tɨgi.” ");
INSERT INTO geb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Gumgi gu mbigi vhɨrve, mbe Fhe Bakɨme taagip mbe ndir zav farasarigi guman rargap wari ki. Zon Gumgi Ruai Guma mba bunin mbe nzuav mba khesharigi tɨvi ga mbuim, mbe ana garav wari wo ndavi vherira kha ndɨkndɨgi mbui, “Khe nza mba rarga ki gumara khare thi?” ");
INSERT INTO geb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mbe mba ndɨkndɨgi ga mbuim, Zon Gumgi Ruai Guma mbe ŋgarkarav khaŋ mbe nzuai, “Gu mbɨn nde ruai, na zɨn zi guma, ana guigira ŋkasŋka bakɨme ki. Gu vhɨra ana ŋkarve nɨman ŋguav ana ŋkari sharive mpiiŋ fhɨrgirga tuktɨgi fhu. Ana Fhe Bakɨme Ŋina Ŋaar gum vhavar nde ruarga. ");
INSERT INTO geb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ana vhɨra bigi heei rɨmani khɨga zi. Ana zɨv, mba rezi fhara muuŋgi mba wit, ana nta heenga. Ana mba wit vhuuiŋ, ana ntan won wit vhor zav muuŋgi phenan vhorga. Ana mba wit mbatɨgi, ana nta fugɨp, nta fuv mba zazera mbara muuŋgiap shiav ki vhava suegɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Zon Gumgi Ruai Guma, mbe thivgip havhargirga buni vhɨrvera mba gumgi gu mbigi ga nzuav Fhe Bakɨme buni vhuuin mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Zon Gumgi Ruai Guma zumgum harigi tugar, Gariri gari guman pana Herot ga vhegi. Herot tɨvi mbatɨgi vhɨrve ga muuŋgiap, wom hɨgap, won ŋguga tɨn ana muuŋ Herodis ga tɨgi. Zon Gumgi Ruai Guma ne nzuav ana vhegi. Herot hɨgap, harigi bigɨna mbatɨga mueŋ phorga mba bigi tɨkhɨngiap, Zon Gumgi Ruai Guma suirav ana ndim bɨna khɨngi. ");
INSERT INTO geb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Zon Gumgi Ruai Guma Zisas ruagim, Herot zumgum Zon Gumgi Ruai Guma ndim bɨna khɨngi. Zon Gumgi Ruai Guma mba gumgi gu mbigi ruav kim, Zisas zim, Zon vhɨra ana ruagi. Zon Gumgi Ruai Guma Zisas ruagim, ana Fhe Bakɨme phorga nzuaim, Heven fhogim, Fhe Bakɨme Ŋina Ŋaar fhomne fara muuŋgiap gegap, zerap, ana perigi. Ana ana perigim, Fhe Bakɨme Hevenan kav khaŋ nzuai, “Ndu nan Kam ma! Gu guigira ndu vuzvugiap ndun ndikndigi!” ");
INSERT INTO geb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Zisas ruagiap, anan mparive vov 30 thɨgim, ana won ŋaara bakɨme khavgiap, ana mbua rui. Ana Fhe Bakɨmen buni vhuuiŋ bun gumgi gu mbigi ga nzuav, mben kurkura ga rui. Ana maaŋ mbua ruim, mba gumgi gu mbigi, mbe kha ndɨkndɨgar ana mbui, “Nza kaŋgi, ana Zozevan kam ma.” ");
INSERT INTO geb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Zosep, Heri ana tegi. Heri, Matat ana tegi. Matat, Rivai ana tegi. Rivai, Merki ana tegi. Merki, Zanai ana tegi. ");
INSERT INTO geb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Zanai, Zosep ana tegi. Zosep, Matatias ana tegi. Matatias, Amos ana tegi. Amos, Nahum ana tegi. Nahum, Esri ana tegi. Esri, Nagai ana tegi. ");
INSERT INTO geb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai, Mat ana tegi. Mat, Matatias ana tegi. Matatias, Semen ana tegi. Semen, Zosek ana tegi. ");
INSERT INTO geb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zosek, Zoda ana tegi. Zoda, Zoanan ana tegi. Zoanan, Resa ana tegi. Resa, Zerubaber ana tegi. Zerubaber, Seartier ana tegi. Seartier, Neri ana tegi. ");
INSERT INTO geb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri, Merki ana tegi. Merki, Adi ana tegi. Adi, Kosam ana tegi. Kosam, Ermadam ana tegi. Ermadam, Er ana tegi. Er, Zosua ana tegi. ");
INSERT INTO geb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Zosua, Eriesar ana tegi. Eriesar, Zorim ana tegi. Zorim, Matat ana tegi. Matat, Rivai ana tegi. ");
INSERT INTO geb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Rivai, Simeon ana tegi. Simeon, Zuda ana tegi. Zuda, Zosep ana tegi. Zosep, Zonam ana tegi. Zonam, Eraikim ana tegi. ");
INSERT INTO geb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eraikim, Merea ana tegi. Merea, Mena ana tegi. Mena, Matata ana tegi. Matata, Natan ana tegi. Natan, Devit ana tegi. ");
INSERT INTO geb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit, Zesi ana tegi. Zesi, Obet ana tegi. Obet, Boas ana tegi. Boas, Sarmon ana tegi. Sarmon, Nason ana tegi. Nason, Aminadap ana tegi. ");
INSERT INTO geb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadap, Atmin ana tegi. Atmin, Arni ana tegi. Arni, Hesron ana tegi. Hesron, Peres ana tegi. Peres, Zuda ana tegi. Zuda, Zekop ana tegi. ");
INSERT INTO geb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zekop, Aisak ana tegi. Aisak, Abraham ana tegi. Abraham, Tera ana tegi. Tera, Nahor ana tegi. Nahor, Seruk ana tegi. ");
INSERT INTO geb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seruk, Reu ana tegi. Reu, Perek ana tegi. Perek, Eber ana tegi. Eber, Sera ana tegi. ");
INSERT INTO geb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sera, Kainan ana tegi. Kainan, Arpaksat ana tegi. Arpaksat, Siem ana tegi. Siem, Noa ana tegi. Noa, Ramek ana tegi. ");
INSERT INTO geb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ramek, Metusera ana tegi. Metusera, Enok ana tegi. Enok, Zaret ana tegi. Zaret, Mahararer ana tegi. Mahararer, Kenan ana tegi. ");
INSERT INTO geb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan, Enos ana tegi. Enos, Set ana tegi. Set, Adam ana tegi. Adam Fhe Bakɨme fharav muuŋgi guma ma. ");
INSERT INTO geb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Zon Gumgi Ruai Guma Zisas ruagim, Fhe Bakɨme Ŋina Ŋaara zav Zisas vhen vergap, guigira ana vhen kim, ana Zordan mbɨ thav taagia vui. Ana vuim, Fhe Bakɨme Ŋina Ŋaar, ana rugap anan kov gumgi ki fhuv ŋanen vugi. ");
INSERT INTO geb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ana vugap 40 rarir mba ŋanen kim, Satan anan mpari. Mba tugen Zisas mba thaneŋ mbegi fhu. Mba 40 rari vhɨzgim, ana guigira thɨ mbatɨk anan hegi. ");
INSERT INTO geb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ana thɨhegim, Satan zav khaŋ ana nzuai, “Ndu guigira Fhe Bakɨmen Kam, ndu kha kɨma suaŋrim, ana viktuma gegɨri.” ");
INSERT INTO geb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ana maaŋ Zisas ga nzuaim, Zisas ana ŋgarkarav khaŋ ana nzuai, “Fhe Bakɨme buni vhuuiŋ ki gap khaŋ nzuai, ‘Gumgi gu mbigi mbara nzuav ŋkasŋkagiap ki fhuvara.’ ” ");
INSERT INTO geb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ana maaŋ nzuaim, Satan mbaram ana kov ndav vov, vun mbar ndagi ŋanen ndav, mba tuga tɨvaneŋra ana za kha nuianan ki ŋgui ŋkasŋkagir ana khɨvigi. ");
INSERT INTO geb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ana ntan ana khɨvav khaŋ ana nzuai, “Gu kha bigi ganɨnga ŋkasŋkar ndun nɨɨŋgirga, ndu za kha nuianan ki bigi vhuuiŋ ganɨnga. Ndu nta ganɨv guigira zɨ bakɨme kɨrga. Kha bigi, nta za na farven ki. Gu ntan guma then nɨɨn saŋv, gu ntan anan nɨɨnga. ");
INSERT INTO geb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ndu maaŋ muuŋgip ntige thɨpanani phɨrgip na nɨman fav, na zɨ ndiv vun kuamkuav, nan ndikndigɨp, nan piin kɨrga, gu ntige kha nuianan ki bigi, gu za ntan ndun nɨɨŋgirga.” ");
INSERT INTO geb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ana maaŋ nzuaim, Zisas ana ŋgarkarav khaŋ ana nzuai, “Fhe Bakɨme buni vhuuiŋ ki gap khaŋ nzuai, ‘Ndu Guma Bakɨme, ana nduara ndu Fhe Bakɨme ma! Ndu ana zɨra ndiv vun kuamkuav, anan ndikndigɨp, anan piin kɨri!’ ” ");
INSERT INTO geb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Zisas ne ana suaŋgim, Satan mbaram anan kov vov Zerusareman Fhe Bakɨme Phena vun ndagi. Ana anan kov ndav khaŋ ana nzuai, “Ndu Fhe Bakɨmen Kama guar, ndu khaŋ thɨgɨp fegɨ mbarav ŋgirɨ. ");
INSERT INTO geb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kha kameŋ, ne Fhe Bakɨme buni vhuuiŋ ki gavan ki. Mba kameŋ khaŋ nzuai, ‘Ana wo enseri ga suaŋrim, mbe tɨkhɨngira ndu ganɨnga. ");
INSERT INTO geb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mbe ndu suirav ndu vun fegɨrga, ndu mba ŋkɨɨr wo ŋkarveni ndi darga tuktɨgi fhuvara.’ ” ");
INSERT INTO geb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ana ne nzuaim, Zisas mbaram ana ŋgarkarav khaŋ ana nzuai, “Fhe Bakɨme buni vhuuiŋ ki gap khaŋ nzuai, ‘Ndu won Fhe Bakɨmen panɨv fhura ana ŋkasŋka ganɨ saŋ muuŋ thari.’ ” ");
INSERT INTO geb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan kha panpanin Zisas ga muuŋgia thav, ana thav vui. Ana zumgum harigi tugar ana wom anan panɨnga. ");
INSERT INTO geb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Zisas taagia vov Gariri fhain hɨgap, mbaram Fhe Bakɨme Ŋina Ŋaara ŋkasŋkan panan won ŋaara khavgiap ana mbuim, mba kameŋ za mba Gariri fhain ki ŋgui bakɨvi gum ŋgui bisarire ga ruigi. ");
INSERT INTO geb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ana Garirin kav, ana mbe Fhe Bakɨme buni mbararagi pheni vhen verap, Fhe Bakɨme buni vhuuin mba gumgi gu mbigi khɨvav mbe nzuaim, gumgi gu mbigi za ana zɨ ndi vun kuamkuagi. ");
INSERT INTO geb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Zisas taagia vov Nasaretan vergi. Ana niamuuŋ gu ndia Nasaretan kim, ana maaŋ kava vhuuŋgi. Ana vergap, Sabatar ana won tɨva zɨn vov, mbaram vov Fhe Bakɨme buni mbararagi phena vhen vergap, Fhe Bakɨme buni vhuuiŋ ki gavan, ana buna mueŋ ganɨ zav khavgia thɨgi. ");
INSERT INTO geb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Mbe Fhe Bakɨme kamthooŋ guma Aisaia khergi buni ki gavan ana nɨɨŋgi. Ana ana fhogap kha kameŋ gangi. Mba kameŋ khaŋ nzuai, ");
INSERT INTO geb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Fhe Bakɨme won Ŋina Ŋaar na nɨɨŋgim, ana na phorga ki. Ana khaŋ muuŋgiap, ana won buni vhuuiŋ bun bigi sosuagi gumgi ga suan zav nan farasarigi. Ana vhɨra mba gumgi gu mbigi mben pana gumgi mbe suigiap, mbe ndim bɨna suegi, ana mbe suaŋrim, mbe mba bɨna thav kɨrar hɨr zav, ana na sarigim, gu zɨgi. Ana vhɨra mba rɨmgi pɨngi gumgi, ana vhɨra mbe suan zav na sarigim, gu zɨgi. Gu mbe suaŋrim, mbe rɨmgi taaŋv taagiap ganɨnga. Ana vhɨra gumgi simtɨgir harigi ntɨɨri ga ndɨɨi, ana vhɨra mbe tɨn mba simtɨgi vhɨzɨ zav na sarigi gu zɨgi. ");
INSERT INTO geb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ana vhɨra khueŋ bun suan zav na sarigi gu zɨgi. Fhe Bakɨme ntige tɨvar vhuun wo gumgi gu mbigir muunga mparive hɨgi.” ");
INSERT INTO geb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Zisas mba Fhe Bakɨme buni vhuuiŋ ki gava gangia thugap, ana taagia ana dɨmgiap, ana ndim mba gavi garav nta vhuvi guma ga nɨɨŋgiap, mbaram buni suan zav perigi. Ana perav, mba Fhe Bakɨme buni mbararagi phena vhen ki gumgi gu mbigi, mbe zam khɨra Zisasra gari. ");
INSERT INTO geb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mbe khɨrav Zisas garim, Zisas khaŋ mbe nzuai, “Nde ntige kha Fhe Bakɨme buni vhuuiŋ ki gaven kegi buneŋ, gu ne garav nde suaŋgi. Nde ne mbararagi. Ne ntige guigira khar hɨgi.” ");
INSERT INTO geb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ana nen mbe nzuaim, mba gumgi gu mbigi, mbe ana suaŋgi kameŋ, mbe ne mbararagiap, mbe guigira mba kaman vhuueŋ ga nzuav anan ndikndigap, mbe vhɨra ŋgava mbatɨga muuŋgiap, ndɨkndɨgi vhɨrver ana mbuav, khaŋ ana nzuai, “Nza kaŋgi, khe Zozevan kamara. Ana ram muuŋgiap kha khesharigi buni kaŋgip nta suaŋrie?” ");
INSERT INTO geb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mba gumgi gu mbigi mba suambarar ana mbuim, Zisas mbaram khaŋ mbe nzuai, “Nde zumgum khara muuŋgip nan vhunama sɨv suanga. Nde khaŋ suanga, ‘Ndu rɨɨi phenan ŋgari guma, ndu fharav nduara won fhavan muuŋgirim ana nzerari.’ Nde maaŋ suaŋv khaŋ suanga, ‘Nza ndu Kaperneaman ka muuŋgi bigi, nza nta mbararagi. Maaŋ muuŋgip, ndu ntigem won ŋgu nɨɨŋgera, ndu mba khesharigi bigira muuŋgiri.’ ” ");
INSERT INTO geb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ana nen mbe suaŋgiap khaŋ mbe nzuai, “Gu guigira nde nzuai, Fhe Bakɨme kamthooŋ guma ŋgu nɨɨŋgera ki gumgi gu mbigi, mbe ana nzuai buni piin ki fhu. ");
INSERT INTO geb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Gu guigira khar nde nzuai, fhum Iraiza Isreran ki tugen mani rimgi mbigi vhɨrve, mbe Isreran ki. Mba tugen Fhe Bakɨme mbok thɨvigim, mpari mpuveni khegntɨrive, mpora thɨgi kɨnin mbok nzigi fhu. Mba tugen mba Isrer fhain, mbe guigira mba tɨvgiap, gumgi gu mbigi vhɨrve, mbe thir vhɨzi. ");
INSERT INTO geb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","“Mba tugen Fhe Bakɨme Iraiza ga sarigim, ana mba Isrera mbiga the kurkura zav, ana han vugi fhuvara. Ana ana sarigim, ana Saidon ŋgu bakɨme fhain ki ŋgu bisaneŋ Zaraparan mana rimgi mbiga mbe, ana anan kurkura zav ana han vugi. ");
INSERT INTO geb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mba Fhe Bakɨme kamthooŋ guma Iraiza ki tugen, vhɨra ŋkari gum fari goreri rɨmrɨm ki gumgi vhɨrve, mbe Isrerar ki. Mbe rɨgar, mbe guma the rɨmrɨm vhɨzgi fhuvara. Neman Siria guma, ana ndurara Fhe Bakɨme ana rɨmrɨm vhɨzgi.” ");
INSERT INTO geb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Zisas mba bunin mba Fhe Bakɨme buni mbararagi phena vhen ki gumgi gu mbigi ga suaŋgim, mbe mba buni mbararagiap, mbe guigira Zisas ga nzuav ndav shigi. ");
INSERT INTO geb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mbe ana ndav shigap, mbaram Zisas ga vhegap, ana bɨrbɨrav ana ŋgɨrgav mba ŋgu bakɨme thav ana ndi kɨrar mbarigi. Mbe ŋgu mbɨkshɨman ki. Mbe Zisas ndiga vov mba mbɨkshɨman ŋana mbatɨgeŋra ndav ana fusur zav mbui. ");
INSERT INTO geb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Zisas mbaram mbe thav vov, fhura mbe kɨtɨgɨra shɨrav vugi. ");
INSERT INTO geb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Zisas vera vov Garirin Kaperneaman ŋgun vergi. Ana vergap Sabatar ana Fhe Bakɨme buni mbararagi phenan Fhe Bakɨme buni vhuuin gumgi gu mbigi khɨvav mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ana Fhe Bakɨme buni vhuuin mba gumgi gu mbigi khɨvav mbe nzuaim, mba gumgi gu mbigi ana buni mbararav, ŋgava mbatɨga mbui. Mbe khaŋ muuŋgiap, ana mbe khɨvav mbe nzuai buni, nta zɨ ki guma mbe khɨvav mbe nzuai buni fara muuŋgi. ");
INSERT INTO geb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ana mba bunin mbe nzuav kim, ŋina mbatɨk vhen ndagi guma mbe, ana mba Fhe Bakɨme buni mbararagi phena vhen kegap, kama bakɨme rugap nzɨɨv khaŋ nzuai, ");
INSERT INTO geb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ai, kha Nasaret guma Zisas, ndu ram nzan muun za zɨgi? Ndu nzan farfa za zɨgire? Gu ndu kaŋgi, ndu Fhe Bakɨmen Guman Ŋaar ma.” ");
INSERT INTO geb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ana ne nzuaim, Zisas mbaram mba ŋina mbatɨga vhegap khaŋ ana nzuai, “Ndu thɨni mpɨrav, mba guma thav, kɨrar hɨgɨri.” Zisas nen ana nzuaim, mba ŋina mbatɨk mba guma shogim, ana za mba gumgi gu mbigi vhɨrve rɨgara rɨgim, ana fhura ana thav kɨrar hɨgi. Ana bigɨna mbatɨga thuen ana muuŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Zisas maaŋ muuŋgim, mba gumgi gu mbigi za mba bigeŋ gangiap ŋgava mbatɨga muuŋgiap khaŋ wari ga nzuai, “Ai, kha guma ram mbui khesharigi bunin nza khɨvi? Kha guma, ana zɨ kav, ŋkasŋka kav, kama havharan ŋiniŋgi mbatɨgi ga nzuaim, nta gumgi thamthav kɨrar hav vui.” ");
INSERT INTO geb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mbe maaŋ nzuav, mba Zisas muuŋgi bigeŋ, mbe za ne bun nzuaim, mba kameŋ za mba fhain ki ŋgui ga ruigi. ");
INSERT INTO geb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Zisas mba Fhe Bakɨme buni mbararagi phena thav kɨrar hɨgav, Saimon phorgav ana phenan vugi. Saimon samuuŋ fhav ana gurgurgim, ana rɨmrɨm mbatɨga mbuav ki. Mbe ana kurkura zav Zisasan nzarigi. ");
INSERT INTO geb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Zisas mbaram vov ana han thɨgav, mbaram mba rɨmrɨma ruma mbuav ana nzuaim, mba rɨmrɨm fhura ana thav vugi. Ana rɨmrɨm vhɨzavra thav, khavgiap, mbe nzuav mba shai. ");
INSERT INTO geb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mba Sabatar ra vera vhɨzim, gumgi gu mbigi mbe mbarkɨrga rɨmrɨɨ ki gumgi gu mbigi ndiav Zisas han zim, ana won farven za mba rɨɨi ntɨɨri ga suim, mben rɨmrɨɨ vhɨzi. ");
INSERT INTO geb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ana vhɨra gumgi vhɨrve tɨn ŋiniŋgi mbatɨgi ga vharvharigim, nta mbe thamthav kɨrar hegi. Mba ŋiniŋgi mbatɨgi mbe thamthav kɨrar hav kaav khaŋ nzuai, “Ndu Fhe Bakɨmen Kam ma!” Mbe maaŋ nzuaim, ana mbe vhegap, buni suangen mbe thɨvi. Ana khaŋ muuŋgi ne nzuav mbe thɨvi, mbe ana kaŋgi, ana mba Fhe Bakɨme taagi wo gumgi gu mbigi ndir zav suaŋgiap fara sarav sarigi guma ma. ");
INSERT INTO geb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mba mɨtimanera Zisas maaŋra khavgiap Fhe Bakɨme phorgɨv suan zav gumgi ki fhuv ŋanen vugi. Ana vugim, mba gumgi gu mbigi ana nzuav gara rui. Mbe ana nzua gara vov, ana ki ŋanen ana gangiap, ana thɨvi, ana mbe thav ŋgɨrga fhu. ");
INSERT INTO geb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mba gumgi gu mbigi ana thɨvim, ana khaŋ mbe nzuai, “Gu vhɨra mbu harigi ŋguir ŋgɨv Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga bunin vhuuiŋ bun mbe suanga. Fhe Bakɨme mba ŋaarar muun zav na sarigim, gu zɨgi.” ");
INSERT INTO geb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ana maaŋ mbe suaŋgiap, mbaram mba Zudia fhain ki ŋgui ga ruav, mbe Fhe Bakɨme buni mbararagi pheni vhen verap Fhe Bakɨme buni vhuuin mbe khɨvav mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Raa mben Zisas vov Genesaret mbɨn taan thɨgap ki. Ana maaŋ thɨgap kim, gumgi gu mbigi vhɨrve zav, siav ana suav ana phok thɨgim, ana Fhe Bakɨme buni vhuuin mbe nzuaim, mbe nta mbararagi. ");
INSERT INTO geb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ana mba bunin mbe nzuav kav, kema phuni garim, ni phorga ki. Mba vhaaiŋ ndi suav mbaga ndi gumgi, mbe mba kemani ndi phorgap, ni han kav, wari wo vhaaiŋ ruai. ");
INSERT INTO geb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Zisas mbaram mba kema mben vergi. Mba kem, ana Saimon kem ma. Ana mba kema vergap khaŋ Saimon ga nzuai, “Ndu na khɨgɨp kha kema bɨrav thaneŋ mbɨ gaa thav kɨrar hɨgɨ.” Ana ne suaŋgiap mba kema perigim, Saimon ana khɨga maneŋ bɨrav kɨrar hɨgim, ana mba kema perav kav, Fhe Bakɨme buni vhuuin mba gumgi gu mbigi khɨvav mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ana mba Fhe Bakɨme buni vhuuin mbe suaŋgia thugap khaŋ Saimon ga nzuai, “Ndu kha kema togip rɨgar ŋgɨp, won vhaaiŋ ndi suv mbaga ndi.” ");
INSERT INTO geb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ana ne nzuaim, Saimon khaŋ ana nzuai, “Guma Rum, nza maan mpeen ŋaara mbatɨgara mbuav kim, mɨn thugi, nza mbɨgama thaneŋ ndigi fhuvara. Ore, ndu ntigem nzuaim, gu ndu kameŋ zɨn ŋgɨp nta ndi surga.” ");
INSERT INTO geb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mbe Zisas suaŋgi kameŋ zɨn vov mba vhaaiŋ ndi suegim, mbaia, mbarkɨrga mbarkɨrga mbaga vhɨrve zav mba vhaain vergim, mbe mba mbaga khɨgap mba vhaaiŋ ŋgim, mba vhaaiŋ karɨ za mbui. ");
INSERT INTO geb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mbe maaŋ muuŋgiap gangiap thav, mbaram farven wari wo khurkhuu ndi mbaim, mbe won kema ndiga zav, mben kurav, mba mbaga ndiav mba kemani ga sui. Mbe mba mbagan mba kemani ga suav kim, mba kemani vhɨra givav mbɨ thor zav mbui. ");
INSERT INTO geb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita maaŋ muuŋgiap gangia thav vov, wo fegap, Zisas nɨman khɨngiap, khaŋ ana nzuai, “O, Guma Bakɨme, ndu na thav ŋgɨri, gu tɨvi mbatɨgi ga mbui guma ma.” ");
INSERT INTO geb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ana wo khurkhuun kov, mbe mba ndigi mbagan vhɨrve gangiap, mbe guigira ŋgava mbatɨga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Mbe ŋgava mbatɨga mbuim, Saimon khurkhumani Zebedin kamani Zems gum Zon, mani vhɨra ŋgava mbatɨga muuŋgi. Mbe ŋgava mbatɨga muuŋgim, Zisas khaŋ Saimon ga nzuai, “Saimon, ndu rɨvɨ thari, ndu ntigem mbaga ndi. Ndu zumgum gumgi ndirga.” ");
INSERT INTO geb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Mbe mbaram wari wo kemani ŋgɨrga thɨvar ndav, mbara fhura wari wo bigi thav, Zisas phorga vui. ");
INSERT INTO geb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tuga mben Zisas ŋgu bakɨ mben kim, ŋkari gu fari goreri rɨmrɨm za suvgi guma mbe zi. Ana zav Zisas gangiap, mbaram za wo fegap nuiana khɨngiap, nɨm nuiana dav, khaŋ tɨgap Zisas ga nzuai, “O Guma Bakɨme, ndu vuzvugara. Ndu vuzvugip, ndu nan muuŋgirim, gu taagia nzerarga.” ");
INSERT INTO geb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Zisas ana mbararagiap, mbaram wo hara ŋgav, ana suirav, khaŋ ana nzuai, “Gu vuzvugi, ndu rɨmrɨm vhɨzgip, ndu fhav ntige ŋgarav nzerari.” Zisas ne nzuavra thagim, mba ŋkari gu fari goreri rɨmrɨm fhura thuga mbar vugi. ");
INSERT INTO geb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Zisas mbaram kama havharan ana goriruav khaŋ ana nzuai, “Ndu shɨshɨgɨp kha bigeŋ bun harigi guma the suaŋ thari. Ndu ŋgɨp wo fhavan Fhe Bakɨme rotu gari guma khɨvari. Ndu ana khɨvav, mbaram won rɨmrɨm vhɨzgiap fhav ŋgarigi ne suaŋv, Fhe Bakɨme suaŋv, mba Moses fhum suaŋgi shaman muuŋri. Ndu mba shaman muuŋrim, mbe gangip kaŋgirga, ndu rɨmrɨm vhɨzgi.” ");
INSERT INTO geb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Zisas mba bigeŋ bun suangen ana thɨvigi. Mba Zisas muuŋgi bigen kameŋ za vov mbar vugi. Mba kameŋ vugim, gumgi gu mbigi vhɨrve siav Zisas ga suav, ana nzuai buni mbararav, wari wo rɨmrɨɨ vhɨzɨ zav ana nzuaim, ana mben kurkurav, mbe rɨmrɨɨ ga mbuim, nta vhɨzi. ");
INSERT INTO geb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Zisas maaŋ mbe mbuav, ana vhɨra tugi vhɨrvera mba gumgi gu mbigi thamthav vov, gumgi ki fhuv ŋanin vov Fhe Bakɨme phorga nzuai. ");
INSERT INTO geb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Raa mben Zisas Fhe Bakɨme buni vhuuin gumgi gu mbigi ga nzuav mbe khɨvi. Mba raar, Fherasi gumgi gu Zudain tɨvi vhuuiŋ kaŋgi gumgi, mbe vhɨra zegi. Mbe mbari za mba Gariri fhaiŋ ki ŋguir kega zi. Mbe mbari za mba Zudia fhain ki ŋguir kega zim, mbe mbari Zerusareman kega zegi. Mbe zegap, vhɨra maaŋ piigia kav Zisas nzuai buni mbararagi. Mba raar Fhe Bakɨme gumgi gu mbigi rɨmrɨɨ vhɨzɨrga ŋkasŋka, ana Zisas phorga ki. ");
INSERT INTO geb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Zisas maaŋ mbuav kim, gumgi mbari bigi rimgi guma mbe, mbe kaar ana ndigap ana han zi. Mbe ana ndigi zɨv mba Zisas ki phena vhen ŋgirɨv, ana ndim Zisas nɨman nan za mbui. ");
INSERT INTO geb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mbe ana ndiga vov garim, gumgi gu mbigi vhɨrve za mba Zisas ki phena vhen givigim, mba phena thɨmkamani vhɨra givigi. Mbe mba rɨɨi guma ndigi ŋgirɨrga tuap ki fhu. Mbe thav vov, mba Zisas ki phena kɨrar ndav, mbaram mba phena kɨrar thooŋ ga muuŋgiap, mbaram mpiin mba bigi rimgi guman kaar fegap, ana ndi mbarigim, ana Zisas han veri. Mbe ana ndi mbarigim, ana verav, mba gumgi gu mbigi rɨgara shɨrav verav, Zisas nɨmara ndarigi. ");
INSERT INTO geb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Zisas mbaram mba guma garav, mba mbe ana khothɨga muuŋgi tɨva gangiap, khaŋ mba bigi rimgi guma ga nzuai, “Kɨvntok, ndu fhum muuŋgi tɨvi mbatɨgi vhɨzgi.” ");
INSERT INTO geb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Zisas mba kameŋ ana nzuaim, mba Fherasi gumgi gum mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi, mbe mba kameŋ mbararagiap, wari wo ndavi vherira kha ndɨkndɨga mbui. “Khe the khare? Ana kha khesharigi buni nzuav Fhe Bakɨmen ŋana ndiav ana zɨn farfagi. Guma the harigi guma the fhum muuŋgi tɨvi mbatɨgi, ana nta vhɨzgirga tuktɨgi fhu, Fhe Bakɨme nduara.” ");
INSERT INTO geb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mbe mba ndɨkndɨgi ga mbuim, Zisas mbe ndɨkndɨgi kaŋgiap, mben nzarigi, “Nde ram muuŋgiap wari wo ndavi vherira mba ndɨkndɨgi ga mbui? ");
INSERT INTO geb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Gu maaŋgi kameŋ suaŋrim, nde gangip kaŋgirie? Gu khaŋ suaŋrie, ‘Ndu fhum muuŋgi tɨvi mbatɨgi vhɨzgi,’ ee, gu khaŋ suaŋrie, ‘Ndu khavgip ŋgɨ’? ");
INSERT INTO geb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Gu kha tɨvar muuŋgirim, nde gangip kaŋgirga, Fhe Bakɨme Guma Guar, ana kha nuianan tɨvi mbatɨgi vhɨzɨrga ŋkasŋka ki.” Ana nen mbe suaŋgiap, mbaram khaŋ mba bigi rimgi guma ga nzuai, “Gu ndu nzuai, ndu khavgip, won kaa ndigip, wo phenan ŋgɨ.” ");
INSERT INTO geb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Zisas ne nzuavra thagim, mba bigi rimgi guma za khavgiap, mbe nɨman thɨgap, won kaa ndigap, wo phenan vov Fhe Bakɨme zɨ ndi vun kuamkuav vui. ");
INSERT INTO geb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ana vuim, mba gumgi gu mbigi mba bigeŋ gangiap, guigira ŋgava mbatɨga muuŋgiap, Fhe Bakɨme zɨ ndiv vun kuamkuav anan ndikndigi. Mbe guigira Fhe Bakɨme ŋkasŋka gangiap, ndavi mbe khavgim, mbe khaŋ nzuai, “Nza ntige harigi khesharigi tɨvara gangi.” ");
INSERT INTO geb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Zisas maaŋ kegap khavgia vov, ŋkɨɨa ndia rui guma mbe garim, ana won ŋaara mbuav mbe ŋkɨɨa ndia ndɨɨi phena bisaneŋ ga perav ki. Mba guma zɨ khare, Rivai. Zisas ana garav khaŋ ana nzuai, “Ndu zɨv na phorgɨv ŋka ŋgɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Zisas nen Rivai ga nzuaim, Rivai ne mbararagiap, mbaram khavgiap, fhura za mba bigi thav ana phorga vui. ");
INSERT INTO geb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Rivai zumgum wo phenan Zisas phorgɨ mbɨr zav shama bakɨme mbui. Ana mba shama muuŋgim, Zisas ana phorga pim, ŋkɨɨa ndia rui gumgi vhɨrve, gum harigi gumgi vhɨrve mbe zav mani phorga pi. ");
INSERT INTO geb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mbe pim, mba Fherasiŋ gumgi gum mben gumgi mbari, mbe Zudaiŋ tɨvi vhuuiŋ kaŋgi, mbe ne nzuav Zisas phorga rui gumgi ga nzuav mbe mbui. Mbe khaŋ mbe nzuai, “Nde thaŋ nzuav ŋkɨɨa ndia rui gumgi gum tɨvi mbatɨgi ga mbui gumgi phorga pi?” ");
INSERT INTO geb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mbe maaŋ nzuaim, Zisas mbe ŋgarkarav khaŋ mbe nzuai, “Rɨɨi fhuv guma, rɨɨi phenan ŋgari guma thaŋ suaŋv ana han ŋgɨrie? Rɨɨi guma, ana nduara, rɨɨi phenan ŋgari guma han vui. ");
INSERT INTO geb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Maaŋ muuŋgiap, gu gumgi vhuuin kamɨn zav zɨgi fhuvara. Gu khaŋ muuŋgiap tɨvi mbatɨgi ga mbui gumgir kamɨrim, mbe ndavi domdorɨ zav gu zɨgi.” ");
INSERT INTO geb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mbe khaŋ Zisas ga nzuai, “Zon phorga rui gumgi, mbe tugi vhɨrvera mba thamthav Fhe Bakɨme phorga nzuai. Mbe maaŋ mbuim, mba Fherasiŋ phorga rui gumgi, mbe vhɨra maaŋ mbui. Na ndu phorga rui gumgi, mbe maaŋ mbui fhu, mbe shama mbuav pav ki.” ");
INSERT INTO geb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mbe maaŋ nzuaim, Zisas mbaram mbe ŋgarkarav khaŋ mbe nzuai, “Guma the muun rɨgɨr zav shama bakɨme mbuav won kɨvntogir kamgim, mbe ana phorgɨv mba shaman mbɨr zav zegi. Nde ana mbe phorgɨ kɨrim, nde mba tugen mba thamthar saŋv mbe suaŋrim, mbe mba tharie? Zakɨra fhuvara! ");
INSERT INTO geb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mbe mba thamtharga tuk ki. Mba tuk hɨgɨrga, gumgi thari ana suirav ŋgɨgɨrim, mbe mba tugir mba thamtharga.” ");
INSERT INTO geb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ana nen mbe nzuav, bigɨna mueŋ vhunama sav khaŋ mbe nzuai, “Guma the fhum fhava shaa kama the rɨzgiap, anan fɨga thueŋ ndiga vov fhava shaa vura thooŋ phorga samgi fhu. Ana maaŋ muuŋgirga, ana mba fhava shaar kam, ana ana farfagirga. Ana vhɨra mba fhava shaa fɨga kamen mba fhava shaa vura thooŋ phorga samgim, anan gangan harigi khesharigi. Mani mba gangana bavira mbui fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Guma the fhum waina kama ndigap wain rui sɨga ndera vurar ruigi fhu. Ana maaŋ muuŋgirga, mba wainan kam mba sɨga nderar muuŋgirim, ana forarga, mba wain nɨɨn ŋgɨgɨrga. Mba sɨga ndera vur vhɨra mbatɨgirga. ");
INSERT INTO geb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","“Maaŋ muuŋgiap, mbe wain kaman, mbe sɨga ndera kamara rui. ");
INSERT INTO geb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wain vura mbegi guma, ana wain kama vuzvugirga fhu. Ana khaŋ suanga ‘Wain vur nzerara.’ ” ");
INSERT INTO geb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Zisas Sabat raa mbevin rezi fara muuŋgi mba wit mɨni mbave shɨrav vui. Ana phorga rui gumgi ana phorga vov, mba wit vhɨgi mbari korav, farven nta mbuav, ntan vhɨgi pi. ");
INSERT INTO geb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mbe nta pim, Fherasiŋ mbari mbe gangiap mben nzarigi, “Ai, nde thaŋ nzuav Sabat tɨva phɨrgiap, mbe Sabatar muungeŋ thɨvigi tɨva mbui.” ");
INSERT INTO geb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Zisas ne mbararagiap mben ŋgarkarav khaŋ mbe nzuai, “Nde mba Devit muuŋgi bigeŋ, mbe ne khergim, ne ki, nde ne gangi fhuve? Ana won gumgir kov, mbe thir vhɨzgiap, ana mba bigeŋ muuŋgi. ");
INSERT INTO geb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ana vov, Fhe Bakɨme phena vhen vergap, ana mbe Fhe Bakɨme nɨma ndarigi vikntuu, ana nta mbegi. Ana mbe muungeŋ thɨvigi tɨv, ana ne muuŋgi. Ana mba mbegi vikntuu, nta Fhe Bakɨme rotu gari gumgi nduarira pi vikntuu ma. Ana nta pav vhɨra mbarir wo gumgi ga nɨɨŋgim, mbe vhɨra nta mbegi.” ");
INSERT INTO geb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Zisas nen mbe nzua vov khaŋ mbe nzuai, “Fhe Bakɨme Guma Guar, ana Sabat Guma Bakɨme ma.” ");
INSERT INTO geb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Zisas harigi Sabat mbevin, ana vov Fhe Bakɨme buni mbararagi phena vhen vergap, Fhe Bakɨme buni vhuuin gumgi gu mbigi khɨvav mbe nzuai. Mba gumgi gu mbigi rɨgar guva hareŋ kongi guma mbe vhɨra mbe phorgap mba phena vhen ki. ");
INSERT INTO geb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mba tugen, mba Fherasiŋ gumgi gum mba Zudaiŋ tɨvi vhuuiŋ kaŋgi mbari, mbe Zisas bigɨn thueŋ muuŋgirim, mbe ne ga suaŋv ana suan zav tuavi ndi gari. Mbe khueŋ ndɨkndɨgap ana gari, “Ana ntigem Sabatar tɨva phɨrgip, guma then kurarie?” Mbe ne ndɨkndɨgap, rɨmgi siga ara thivgia ki. ");
INSERT INTO geb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mbe mba ndɨkndɨgi ga mbuim, Zisas mbe ndɨkndɨgi kaŋgiap, mbaram khaŋ mba hareŋ kongi guma ga nzuai, “Ndu khavgi zɨv, za kheiŋ nɨman thɨgɨ.” Ana ne nzuaim, mba hareŋ kongi guma khavgia zav thɨgi. ");
INSERT INTO geb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ana zav thɨgim, Zisas khaŋ mbe nzuai, “Gu nden nzai, maaŋgi tɨv ana Sabata tɨva phɨri, tɨvar vhuuaŋ mbui ne, ee tɨva mbatɨga mbui ne? Ee, guman kurkurigi ne, ee guman farfagi ne?” ");
INSERT INTO geb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ana mba nzambaren mbe muuŋgiap phokphoga za mbe garav, thav khaŋ mba hareŋ kongi guma ga nzuai, “Ndu won hareŋ ndegɨ.” Ana ne nzuaim, mba guma won hareŋ ndegim, anan hareŋ taagia nzerigi. ");
INSERT INTO geb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Anan hareŋ nzerigim, mba Fherasiŋ gumgi gum mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi, mbe guigira Zisas ga nzuav ndav shigap khaŋ wari ga nzuai, “Nza ram khen muuŋgirie?” ");
INSERT INTO geb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mba tuga mbigen Zisas vov mbɨkshɨɨr ndav Fhe Bakɨme phorga nzuai. Ana mba maan mpeen Fhe Bakɨme phorga nzuavra kim, mɨn thugi. ");
INSERT INTO geb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mɨn thugim, ana mɨtimanera wo phorga rui gumgir kamgim, mbe ana han ndaim, ana mbe rɨgar wo phorgɨ rurga 12 thɨgi ŋaara gumgi farasegi. ");
INSERT INTO geb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ana farasegi gumgi khare. Saimon, ana kha zɨ phorga ana tɨgi, Pita, ana ŋguk Andru, Zems gum Zon, Firip, Bartoromiu, ");
INSERT INTO geb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiu, Tomas, Arfias kama Zems, Saimon, ana zɨ mbe Zerot, ");
INSERT INTO geb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Zems kama Zudas, Zudas Iskariot, ana mba zumgum Zisas thuuŋ dorgap ana ndim ana pana gumgi farve khɨngi. ");
INSERT INTO geb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Zisas mben kov, mbe mbɨkshɨman kegap taagia vera vov, mbɨrira mbarigi ŋanen vergi. Ana vergim, ana phorga rui gumgi vhɨrve zav ana phorga kim, mba gumgi gu mbigi vhɨrve, mbe za Zudia fhain kegap zi, Zerusareman kegap zi, mba Taia gum Saidon fhain mbasɨk taan kegap zi, mbe za zav Zisas han zegi. ");
INSERT INTO geb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mbe ana han zegap, ana nzuai buni mbararav, wari won rɨmrɨɨ vhɨzɨ zav an han zegi. Mba ŋiniŋgi mbatɨgi vhen ndav vhen kav mba farfagi gumgi, mbe vhɨra Zisas han zegim, ana vhɨra mbe tɨn mba ŋiniŋgi mbatɨgi ga vharvharigi. ");
INSERT INTO geb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ana maaŋ mbuim, gumgi gu mbigi wari won rɨmrɨɨ vhɨzɨ zav an suigɨr zav mbui. Mbe kaŋgi, Fhe Bakɨme mba gumgi rɨmrɨɨ vhɨzɨ zav nɨɨŋgi ŋkasŋka ana ki. Mba ŋkasŋka ana kav, za mba gumgi rɨmrɨɨ vhɨzi. ");
INSERT INTO geb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Zisas mbaram wo phorga rui gumgi garav ŋgɨrkama vhuun ndi ndɨɨv khaŋ nzuai, “Nde ntige bigi sosuagi ntɨɨri, nde ndikndigɨri. Mba Fhe Bakɨme wo gumgi gu mbigi ganɨnga mbe ana piin kɨrga ŋgu, ana nde ne ma. ");
INSERT INTO geb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nde ntige thi hi ntɨɨri, nde ndikndigɨri. Nde zumgum bigi tuktɨgɨrga. Nde ntige nzi ntɨɨri, nde ndikndigɨri. Nde zumgum kɨrsaaŋ muunga. ");
INSERT INTO geb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nde gumgi zumgum nde ganɨnga, nde Fhe Bakɨme Guma Guara zɨn ŋgɨrga gumgi thari nde sarav panan nde kegɨrga. Nde mbe phorgɨv mbe phogir kegɨrga fhu, mbe nde phorgɨv ŋgargirga fhu, buni suaŋgirga fhu, mbegɨrga fhu. Mbe vhɨra buni mbatɨgir nde suanga, mbe vhɨra khaŋ suanga, ‘Nde gumgi mbatɨgi ma’. Mbe mba tɨvir nden muuŋrim, nde ndikndigɨri. ");
INSERT INTO geb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mbe mba tugar mba tɨvi mbatɨgir nden muuŋrim, nde ndikndigɨp fo vun maaŋri. Nde na mbarara, nde zumgum Hevenan Fhe Bakɨme nde nzuav tɨgi vheza bakɨme ana mbur ki, nde zumgum ana ndirga. Mbe ndegi fhum mba khesharigi tɨvira Fhe Bakɨme kamthooŋ gumgi ga muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Zisas mba buni vhuuin mbe suaŋgia thugap, khaŋ mbe nzuai, “Nde ntige shɨga mbuav ŋkɨɨa kɨvgi ntɨɨri, nde warir rɨvɨri. Nde ntige za wari won vheza ndigap za mborga ki. ");
INSERT INTO geb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nde ntige mba mbatɨga mbuav ndikndigi ntɨɨri, nde warir rɨvɨri. Nde zumgum guigira thir vhɨzɨrga. Nde ntige ndikndigap kɨrsaaŋ ga mbui ntɨɨri, nde warir rɨvɨri. Nde zumgum sɨsɨma mbatɨgar muuŋv nzirga. ");
INSERT INTO geb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nde ntige mbe nde nzuav buni vhuuin nde nzuai ntɨɨri, nde warir rɨvɨri. Mbe ndegi, mbe fhum mba tɨvara mba Fhe Bakɨme kamthooŋ gumgir wari ga shɨshɨgi gumgi, mbe fhum mbara mbuav, mbe zɨri ndi vun kuamkuav buni vhuuin mbe suaŋgi.” ");
INSERT INTO geb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nde na mbararagi gumgi, gu nde nzuai. Nde won pana gumgi vuzvugɨp, mba panara thav nde gari gumgi, nde tɨvar vhuuŋra mben muuŋri. ");
INSERT INTO geb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gumgi thari ŋgɨrkama mbatɨgar nden muun saŋv suaŋrim, nde mbe suaŋv Fhe Bakɨmen nzarim, ana ŋgɨrkaman vhuun mben muuŋri. Nde mba tɨva mbatɨgar nde mbui ntɨɨri, nde mbe suaŋ Fhe Bakɨme phorgɨ suaŋri. ");
INSERT INTO geb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Guma the ndu kureŋ phɨrgirim, ndu dorgɨv harigi kuren ana phɨrarim, ana vhɨra ne phɨrgiri. Guma the ndu ruga hav shari fhava shaa ndigirim, ndu fhura ana ganɨrim, ana ndu fhava shaage phorgɨv ndigɨri. ");
INSERT INTO geb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Gumgi bigin ndun nzarim, ndu fhura mben nɨɨŋri. Guma the ndu bigɨn the ndigɨrim, ndu kama havharan ana suaŋv taagi ana tɨn ana ndi thari. ");
INSERT INTO geb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nde harigi gumgi gu mbigi nden muungeŋ vuzvugi tɨvi, nde mba tɨvira harigi gumgi gu mbigin muuŋri. ");
INSERT INTO geb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nde mba nde vuzvugi gumgi gu mbigi, nde mbera vuzvugirga, harigi gumgi gu mbigi, mbe ram muuŋgip nde kaŋgirie, nde tɨvar vhuuiaŋ mbui gumgi gu mbigi ma? Mba tɨvi mbatɨgi ga mbui gumgi, mbe vhɨra mbe vuzvugi gumgi gu mbigi, mbe mbera vuzvugi. ");
INSERT INTO geb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nde mba tɨvar vhuun nde mbui gumgi gu mbigi, nde tɨvar vhuun mbera muunga, harigi gumgi gu mbigi, mbe ram muuŋgip kaŋgire? Nde tɨvar vhuuiaŋ mbui gumgi gu mbigi ma. Mba tɨvi mbatɨgi ga mbui gumgi gu mbigi vhɨra mba tɨva mbui. ");
INSERT INTO geb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nde guma the nden han bigɨn the ŋgarɨgar muun saŋv muunga, nde kha ndɨkndɨgar anan muunga, ‘Ana zumgum ana ŋgarkarga.’ Nde mba ndɨkndɨga muuŋv anan nɨɨŋgirga, the khaŋ nde suaŋrie, ‘Nde gumgi gu mbigir vhuuiŋ ma?’ Mba tɨvi mbatɨgi ga mbui gumgi gu mbigi, mbe vhɨra maaŋ mbui. Mbe guma mben han ŋgarɨga mbuim, mbe za kha ndɨkndɨga mbui, ‘Ana za nta ŋgarkararga.’ ");
INSERT INTO geb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nde maaŋ muuŋ thari. Nde won pana gumgi, nde guigira mbe vuzvugɨri. Nde tɨvar vhuuŋra mben muuŋv, nde bigɨna then mben nɨɨŋgip, nde ana ŋgarɨga suaŋv mbe ndɨkndɨgɨ thari. Nde maaŋ muunga, nde zumgum vheza bakɨme ndirga. Nde vheza bakɨme ndiv, nde za kha bigi kharav vu guarara ki Fhe Bakɨmen ŋkaa gum ŋkarmbigi kɨrga. Nde khaŋ muuŋgiap, nde Fhe Bakɨme mbui tɨvi, nde ntara zɨn vui. Fhe Bakɨme tɨvar vhuuŋra mba anan ndikndigi fhuv gumgi gu mbigi ga mbuav, ana vhɨra tɨvar vhuuŋra mba tɨvi mbatɨgi ga mbui gumgi ga mbui. ");
INSERT INTO geb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nde Ndia Bakɨme mbu Hevenan ki. Ana guigira kha gumgi gu mbigi kora mbuav tɨvar vhuuŋra mbe mbui. Ana mba tɨvara mbe mbui. Nde vhɨra mba tɨvara mben muuŋri.” ");
INSERT INTO geb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Nde harigi gumgi muuŋgi tɨvi mbatɨgi ga suaŋv mbe suaŋv khaŋ mbe suaŋ thari, ‘Nde tɨvi mbatɨgi ga mbui ntɨɨri ma. Nde zumgum ntan vheza ndigirga.’ Nde maaŋ muunga, Fhe Bakɨme vhɨra mba tɨvara nden muunga. Nde harigi gumgi nde muuŋgi tɨvi mbatɨgi, nde nta vhɨzgip, nta ndɨkndɨgɨ thari. Nde maaŋ muunga, Fhe Bakɨme vhɨra nde muuŋgi tɨvi mbatɨgi vhɨzgip nta ndɨkndɨgirga fhu. ");
INSERT INTO geb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nde bigin harigi ntɨɨrir kurkurarga, Fhe Bakɨme harigi bigir nden nɨɨnga. Ana nden nɨɨŋv, ana vhɨra bigir vhuuiŋ vhɨrvera nden nɨɨŋgirga, nde guigira bigi tuktɨgɨrga. Nde mba harigi gumgi gu mbigi ga mbui tɨvi, Fhe Bakɨme mba tɨvara nden muunga.” ");
INSERT INTO geb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ana mbe nzua vov khueŋ vhunama dav mbe nzuai, “Nde ram muuŋgi ndɨkndɨga mbui? Rɨmani mbatɨgi guma the, harigi rɨmani mbatɨgi guma the haran suirav mani ŋgɨgɨrie? Mani maaŋ muuŋgip ŋgɨrga, mani mbok fhaŋ thige thɨgɨp, mani vhɨra rɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sure mbui tar, ana won mparmpare kambarigi fhuvara. Mba sure mbuav, za wo sure vhɨzgi tar, ana won mparmparera fara muuŋgi. ");
INSERT INTO geb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ndu thaŋ nzuav mba ndigɨna bisaneŋ ndun kɨvntogar rɨmatugar kim, ndu ana gangiap, ana ndir zav ana nzuai. Ndu wora gangi fhuve? Kha khanararaŋ rumeŋ ndu rɨmatuga ŋkorgim, ndu ana khɨga rui. ");
INSERT INTO geb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ndu maaŋ muuŋgip ndu ram muuŋgip ganɨv, khaŋ won kɨvntoga suaŋrie? ‘Ena, ndu khar zɨrim, gu ndu rɨmatugar mba ndigɨna bisaneŋ ndigirga.’ Ndu maaŋ ana nzuai, ndu wora gangi fhuvara, khanararaŋ rumeŋ ndu rɨmatuga ŋkorga ki. Ndu bigi shɨshɨgi guma ma. Ndu fharav wo rɨmatugar mba khanararaŋ rumeŋ ndigɨri. Ndu ne ndigɨp, ndu nzerara ganɨv, ndu won kɨvntoga rɨmatuga mba ndigɨna bisaneŋ ndigɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","44","“Ndu khan vhɨga gangiap, ndu kaŋgi, khe kha kha ma, anan vhɨk khare. Nde kaŋgi, khan vhuuŋ, ana vhɨgi mbatɨgi mbai fhuvara. Kha mbatɨk, ana vhɨra, ana vhɨgi vhuuiŋ mbai fhuvara. Guma the fhum vov tari ki kargi rɨgar fik vhɨgi thari garim, nta tuiga kim, ana nta khargi, fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kha khesharigi ndɨkndɨgi guma ndava vhen givav kim, ana kamthoon nta nzuai.” Guma the vhɨra ana vov wain vhɨgi thari garim, nta tari ki kha bisaŋ thaneŋ ga tuiga kim, ana nta khargi fhuvara. Guman vhuuŋ, ana ndɨkndɨgi vhuuiŋ ana ndava vhen kim, ana tɨvir vhuuiŋ ga mbui. Guma mbatɨk, ana ndɨkndɨgi mbatɨgi ana ndava vhen kim, ana tɨvi mbatɨgi ga mbui. ");
INSERT INTO geb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nde thaŋ nzuav kha zɨn nan kaai, Guma Bakɨme ma? Nde mba zɨn nan kav, gu nzuai tɨvi, nde nta zɨn vui fhu. ");
INSERT INTO geb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Gu ntigem na han zav na buni mbararav, nta zɨn vui guma mbui tɨvi bun nde suanga. ");
INSERT INTO geb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ana khaŋ muuŋgi guma fara muuŋgi. Mba guma phena mbui. Ana wo phena mbogi korav verap, khɨna guarara verav, ŋkɨɨr hɨgap, wo phena muuŋgi. Ana wo phena muuŋgim, zumgum mbok bakɨme nzim, mpi bakɨme zeri. Mba mpi zerav, mba phena dagim, ana hɨmgi fhu. Mba guma, ana guigira muumbara vhuuŋra wo phena muuŋgi. ");
INSERT INTO geb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mba na buni mbararav nta zɨn vui fhuv guma, ana khaŋ muuŋgi guma fara muuŋgi. Mba guma vov khɨɨn ki nuianeŋ gangiap, mbaram wo phena mbui. Ana wo phena mbogi korav, khɨnan vera vov, ŋkɨɨr hɨgi fhuvara. Ana phena mbogi thɨɨŋra ki. Ana wo phena muuŋgim, zumgum mbok bakɨme nzi. Mbok zim, mpi bakɨme zeri. Mpi zerav, mba phena dagim, ana fhura hɨmgia vov mbur ndarav, za phɨra koreregi.” ");
INSERT INTO geb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Zisas Fhe Bakɨme buni vhuuin za mba gumgi gu mbigi ga suaŋgia thugap, mbaram khavgiap, Kaperneaman vergi. ");
INSERT INTO geb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ana Kaperneaman vergim, Roman ntari ga mbui gumgi gari guman pana mbe, ana ŋaara guma mbe ki. Ana guigira mba ŋaara guma vuzvugi. Ana rɨɨv rɨmɨn zav gor vhɨk bisanera ki. ");
INSERT INTO geb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mba ntari ga mbui gumgi gari guman pan Zisas zergap Kaperneaman ki kameŋ mbararagiap, mbaram mba Zudaiŋ gari gumgir pani mbari ga sarav, khaŋ mbe nzuai, “Nde ŋgɨp Zisasan nzararim, ana zɨv nan ŋaara guman kurarim, ana rɨmrɨm vhɨzgip taagi khavgirga” ");
INSERT INTO geb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Mbe vov Zisas han vegap guigira khaŋ tɨgav ana nzuav khaŋ ana nzuai, “Mbu ntari ga mbui gɨɨtɨvi gari guman pan, ana guigira guman vhuuŋ ma. Ndu anan kurari, ne guigira nzerarga. ");
INSERT INTO geb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ana guigira nza Zudaiŋ, ana nza vuzvugiap, nzan kurav, nza nzuav Fhe Bakɨme buni mbarararga phena muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mbe nen Zisas ga suaŋgim, Zisas mbe phorga vui. Zisas vov mba ntari ga mbui gɨɨtɨvi gari guman pana phena han mbaim, ana won kɨvntogi mbari ga sarav, khaŋ mbe nzuai, “Nde ŋgɨp khaŋ Zisas ga suaŋri, ‘Guma Bakɨme, ndu na suaŋv ŋaara mbatɨgar muuŋ thari. Ndu mbara thɨgɨri. Gu guman vhuuŋ fhuvara, ndu nan phena vhen zirɨ thari. ");
INSERT INTO geb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Gu maaŋ muuŋgiap gu nduara zɨv ndu suaŋ thagi. Ndu mbara kɨv suaŋrim, na ŋaara guma rɨmrɨm vhɨzgip, taagi nzerarga. ");
INSERT INTO geb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gu khaŋ muuŋgiap kha kameŋ nzuai, gu vhɨra na gari guma ki. Gu ana piin ŋgarim, ana na gari. Gu vhɨra, gu ntara gumgi mbari garim, mbe na piin ŋgari. Gu khaŋ the suanga “Ndu ŋgɨ”, ana vui. Gu khaŋ the suanga, “Ndu zɨ”, ana zi. Gu vhɨra ŋaara guma ki. Gu khaŋ ana suanga, “Ndu kha ŋaarar muuŋ, ana mba ŋaara mbui.” ’ ” ");
INSERT INTO geb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Mbe mba kamen Zisas ga nzuaim, Zisas mba kameŋ mbararagiap, guigira ana nzuav ŋgava mbatɨga muuŋgiap, mbaram dorgav mba wo zɨn zi gumgi gu mbigi vhɨrve garav, khaŋ mbe nzuai, “Gu Isrer guma the garim, ana na khothɨgi tɨv kha guma na khothɨgi tɨva kambarigi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Zisas maaŋ mbe suaŋgim, mba ntari ga mbui gumgi gari guman pan sarigi gumgi, mbe taagia phenan vov garim, mba ŋaara guma rɨmrɨm vhɨzgiap, taagia nzerigi. ");
INSERT INTO geb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Zisas maaŋ kegap, ana mbaram khavgiav vera vov, kha ŋgun vergi. Mba ŋgu zɨ khare, Nain. Ana khavgia Nainan verim, ana phorga rui gumgi gum harigi gumgi gum mbigi vhɨrve guarira, mbe ana phorga veri. ");
INSERT INTO geb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ana vov, mba ŋgun vhen veri thɨmkamanin havra thagim, gumgi mbari rimgi guma khuma mbe, mbe kaan ana ndiga mba ŋgun kegap kɨrar hi. Mba guma, ana mana rimgi mbiga mben kam ma. Mba mbik tari vhɨrve ki fhuvara. Ana mba kama bavira. Mbe ana ndiga zim, mba ŋgun ki gumgi gu mbigi vhɨrve mba mbiga phorga zi. ");
INSERT INTO geb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mba mbik zim, Zisas mba mbiga gangiap, guigira ana kora muuŋgiap khaŋ ana nzuai, “Mama, ndu nzi thari.” ");
INSERT INTO geb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ana maaŋ ana suaŋgiap, mbaram vov mba guma khuma khɨga anan kaa suirigi. Ana ana kaa suirigim, mba ana khuma kɨgav mba kaa phufuiga vui gumgi fhura mbar thivgi. Mbe thivgim, ana khaŋ nzuai, “Guman kam, gu ndu nzuai, ndu khavik.” ");
INSERT INTO geb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ana maaŋ nzuaim, mba rimgi guma taagia khavgiap perigi. Ana taagia khavgiap perav buni nzuaim, Zisas mbaram ana nzuaim, ana taagia won niamuuŋ han vui. ");
INSERT INTO geb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ana taagia wo niamuuŋ han vuim, mba gumgi gu mbigi vhɨrve Fhe Bakɨme ŋkasŋka bakɨme gangiap, mben ndavi mbe khavgim, mbe Fhe Bakɨmen zɨ ndi vun kuamkuagi. Mbe ana zɨ ndim vun kuamkuav khaŋ nzuai, “Fhe Bakɨmen kamthooŋ guma ŋkasŋka mbe ntige nzan rɨgar hɨgi. Fhe Bakɨme ntige won gumgi gu mbigin kurkura zav zɨgi.” ");
INSERT INTO geb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Zisas mba bigeŋ muuŋgim, nen kameŋ za mba Zudia fhaiŋ ga rua vov, mba Zudia gaanin ki ŋgui, mba kameŋ za nta ruigi. ");
INSERT INTO geb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Zon Gumgi Ruai Guma phorga rui gumgi, mbe Zisas mbui bigi bun ana nzuaim, ana mbaram wo phorga rui guma phuninin kamgim, mani ana han zi. ");
INSERT INTO geb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Mani ana han zim, ana mani ga sarav khaŋ mani ga nzuai, “Ŋko ŋgɨp kha nzambaren Zisasan muuŋgiri, ‘Ndu mba zɨr za mbuim, Fhe Bakɨme farasarav bun nzuai gumarame, ee, ana ntigar zɨrie?’ ” ");
INSERT INTO geb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Zon Gumgi Ruai Guma maaŋ mba gumani ga suaŋgim, mani zi. Mba gumani zav Zisas han zɨgap, khaŋ ana nzuai, “Zon Gumgi Ruai Guma ndun nzan zav ŋka sarigim, ŋka zɨgi. Ana khaŋ nzuai, ‘Ndu mba zɨr za mbuim Fhe Bakɨme farasarav bun nzuai gumarame, ee, ana ntigar zɨrie?’ ” ");
INSERT INTO geb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mani mba Zisasan nzan zav vugi tugera, Zisas mba tugeram mbarkɨrga rɨmrɨɨ vhɨrve ki gumgi gu mbigi vhɨrver kurkurav, mbe rɨmrɨɨ ga mbuim, mbe rɨmrɨɨ vhɨzgi. Ana vhɨra gumgi mbari tɨn ŋiniŋgi mbatɨgi ga vharvharigim, nta mbe thamthav kɨrar hegi. Ana vhɨra rɨmgi mbatɨgi gumgi, ana mbe mbuim, mbe taagia gari. ");
INSERT INTO geb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Zisas mba bigi ga mbuav kim, mani vov Zisasan nzarigim, Zisas mbaram mba Zon Gumgi Ruai Guma phorga rui gumanin nzambareŋ ŋgarkarav, khaŋ mani ga nzuai, “Ŋko taagi ŋgɨp kha gangi bigi gum kha mbararagi buni, ŋko nta bun Zon Gumgi Ruai Guma ga suaŋgiri. Ŋko khaŋ ana suaŋri. ‘Mba rɨmgi mbatɨgi gumgi, mbe rɨmgi nzerigim, mbe bigi gari. Mba suira mbatɨgi gumgi, mbe suira nzerigim, mbe rui. Mba ŋkari gum fari goreri rɨmrɨm ki gumgi, mbe favi taagia nzerigi. Mba khuari ŋangi gumgi, mbe khuari nzerigim, mbe bigi mbararagi. Mba vhɨzgi gumgi, mbe taagia khavi. Mba bigi sosuagi gumgi, mbe Fhe Bakɨmen buni vhuuiŋ, mbe nta mbararagi.’ ");
INSERT INTO geb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mba na gangiap guigira na khothɨgap thɨga havhargi gumgi, mbe ndikndigɨri.” ");
INSERT INTO geb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Zisas mba bunin mba Zon Gumgi Ruai Guma phorga rui gumani ga suaŋgim, mani vui. Mani taagia vugim, Zisas mbaram Zon Gumgi Ruai Guma ga nzuav mba gumgi gu mbigi vhɨrve ga nzuai. Ana khaŋ mbe nzuai, “Nde mba gumgi ki fhuv ŋanen vegi. Nde thagɨna ganɨ zav wari vegi? Ee, nde vuruna the garim, bɨɨŋbɨɨŋ ana rɨgim, ana nɨɨŋkuim, nde ana ganɨ zav vegire? Fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nde maaŋ muuŋgia thagɨna ganɨ zav wari vegi? Ee, nde shagi vhuuiŋ shargi guma ganɨ zav vegire? Fhuvara. Mba bigi vhɨrve kav ndɨgi vhuuiŋ hi bigin wari wo fhavi nzɨɨi gumgi, mba khesharigi gumgi, mbe ŋgui gari gumgir pani phenin ki gumgi ma. ");
INSERT INTO geb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nde maaŋgia thagɨna ganɨ zav wari vegi? Ee, nde Fhe Bakɨme kamthooŋ guma ganɨ zav vegire? Ahaŋ, nde Fhe Bakɨme kamthooŋ gumara ganɨ zav wari vegi. Gu guigira nde nzuai, nde mba gangi Fhe Bakɨme kamthooŋ guma, ana guigira mba harigi Fhe Bakɨmen kamthooŋ gumgi kambarigi guma ma. ");
INSERT INTO geb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Fhe Bakɨme fhum mba gumara bun suaŋgim, mbe mba kameŋ khergim, ne Fhe Bakɨme buni vhuuiŋ ki gavan ki. Mba kameŋ khaŋ nzuai, ‘Nde mbarara, gu won mpuu guma ga sararim, ana fharav ŋgɨv ndu suaŋv tuavar muunga.’ ");
INSERT INTO geb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Gu khar nde nzuai, fhum kha nuianan kegi gumgi gum ntige kha nuianan ki gumgi, Zon guigira mbe kambarav zɨ ki guma ma. Fhe Bakɨme wo gumgi gu mbigi ganɨnga, mbe ana piin kɨrga tuk hɨgɨrga. Guma the ana zɨ ki fhu, ana mba tugen Fhe Bakɨme piin ki gumgi gu mbigi phorga kɨrga, mba guma, ana guigira Zon kambarigi.” ");
INSERT INTO geb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Zisas mba bunin mba gumgi gu mbigi vhɨrve ga nzuai. Ana mba bunin mbe suaŋgim, mba gumgi gu mbigi vhɨrve gum mba ŋkɨɨa ndia rui gumgi, mbe mba buni mbararagiap khaŋ nzuai, “Fhe Bakɨmen bunin vhuuiŋ gum ana nzuai tɨvi, nta guigira bunin vhuuiŋ guarira.” Mbe khaŋ muuŋgia ne nzuai, mbe Zon Gumgi Ruai Guma mbe ruagi. ");
INSERT INTO geb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mba tugen mba Fherasi gumgi gum mba guigira Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi, mbe Zon Gumgi Ruai Guma mbe ruagi fhu. Mbe maaŋ muuŋgiap, mba Fhe Bakɨme mbe khɨvi tuavar vhuuŋ, mbe ana thav kɨr ana segi. ");
INSERT INTO geb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Zisas mba bunin mbe nzua vov wom khaŋ mbe nzuai, “Gu ntige kha tugen vhuuŋgia ki gumgi, gu mbe mbui tɨvir vhunama sɨv ram mbui suambarar muuŋrie? Mbe ramgi khesharigi gumgi? ");
INSERT INTO geb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mbe mba tarire fara muuŋgiap, mbe mba phogi ga vhuui ŋanen kav, harigi tarir kaav khaŋ mbe nzuai, ‘Nza nde nzuav shɨfhɨra bim, nde hii fhu. Nza vhɨra nde nzuav nanama mɨɨtɨga mbuim, nde vhɨra nzi fhu.’ ” ");
INSERT INTO geb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Zon Gumgi Ruai Guma, ana zɨgap, ana viktuma pi fhu, ana vhɨra wain pi fhu. Ana maaŋ mbuim, nde khaŋ ana nzuai, ‘Ana ŋina mbatɨk mbe ana vhen ki.’ ");
INSERT INTO geb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nde ntigem Fhe Bakɨme Guma Guar, ana zɨgap mba pav mbɨ pim, nde khaŋ nzuai, ‘Ana guigira mba kɨvgia pav wain kɨvgia pi guma ma. Ana vhɨra ŋkɨɨa ndia rui gumgi gum tɨvi mbatɨgi ga mbui gumgir kɨvntok ma.’ ");
INSERT INTO geb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","“Nde mba bunin ana nzuaim, mba Fhe Bakɨme kaŋgiap, ana han ana ndɨkndɨgi vhuuiŋ ndigi gumgi gu mbigi, mbe nta kaŋgiap khaŋ nzuai, ‘Nta guigira buni guari ma.’ ” ");
INSERT INTO geb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fherasi guma mbe wo phenan ŋgɨp, wo phorgɨv mbɨr zav Zisas ga suaŋgim, Zisas vov ana phenan vugap, mba pi kaa ga perav, mbɨr zav mbui. ");
INSERT INTO geb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ana mbɨr zav mbuim, mba ŋgu bakɨmen tɨvi mbatɨgi ga mbui mbiga mbe, ana ki. Mba mbik Zisas mba Fherasi guma phenan kav pi ne mbararagiap, ana kɨman muuŋgi nda, ana ndɨgar vhuuŋ hi mporiiŋ anan ki, ana mba mporiiŋ ndiga zi. ");
INSERT INTO geb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mba mbik zav Zisas han zɨgap, ana zɨnkɨrar ana suani piiŋ thɨgap nzi. Ana nzim, anan theerphara Zisas ŋkarveni ga ri. Anan theerphara Zisas ŋkarveni ga regim, ana mbaram won pana rɨgira Zisas ŋkarveni mbɨrgiap, Zisas ŋkarveni suirav, ni viavav, ni khoman mpari. Ana mba tɨvar Zisas ŋkarveni ga muuŋgiap, mbaram mba ndɨgar vhuuŋ hi mporiiŋ siav Zisas ŋkarveni ga suav, mba mporiin ana ŋkarveni hɨvi. ");
INSERT INTO geb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mba mbik maaŋ mbuim, mba Zisasan kamgim, ana zav ana phenan zɨgi Fherasi guma, ana mba mbik mbui tɨva gangiap kha ndɨkndɨga mbui, “Ai, kha guma, ana guigira Fhe Bakɨme kamthooŋ guma guar kake, ana khar anan suigi mbik, ana ana kaŋge. Ana vhɨra ana mbui tɨvi mbatɨgi, ana vhɨra nta kaŋge. Kha mbik, ana guigira tɨvi mbatɨgi ga mbui mbik ma.” ");
INSERT INTO geb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ana mba ndɨkndɨga mbuim, Zisas ana ndɨkndɨga kaŋgiap, khaŋ ana nzuai, “Saimon, gu buna muen ndu suan zav mbui.” Ana ne nzuaim, Saimon khaŋ ana nzuai, “Guman Rum, ndu mba na suan zav mbui bunai na suaŋ.” ");
INSERT INTO geb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Saimon ne nzuaim, Zisas mbaram khaŋ ana nzuai, “Guma phunini, mani guma mbe han ŋkɨɨar ŋgarɨga muuŋgi. Guma mbe K500.00, guma mbe K50.00. ");
INSERT INTO geb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mba gumani mba ŋgarɨga muuŋgi ŋkɨɨa, mani nta ŋgarkarga tuktɨgi fhu. Mani maaŋ muuŋgim, mani mba han ŋgarɨga muuŋgi guma, ana fhura mba mani ŋgarɨga muuŋgi ŋkɨɨ ndɨkndɨk ŋangi. Ndu kha buneŋ mbararagiap, ram mbui ndɨkndɨga mbui. Ndu ndɨkndɨgɨ, maaŋgi guma ana guigira mba guma vuzvugirie?” ");
INSERT INTO geb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon Zisas ŋgarkarav khaŋ ana nzuai, “Gu ndɨkndɨgi, mba ana han ŋkɨɨa vhɨrve ŋgarɨga muuŋgi guma ma.” Ana maaŋ nzuaim, Zisas mbaram khaŋ ana nzuai, “Ndu nzerara ndɨkndɨgiap mbar nzuai.” ");
INSERT INTO geb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Zisas maaŋ ana nzuav, mbaram dorgav mba mbiga garav, khaŋ Saimon ga nzuai, “Ndu kha mbiga garire? Gu ndu phenan vhen zeravra thagim, ndu na ŋkarveni ruarga mbɨn na nɨɨŋgi fhu. Ndu kha mbiga gari, ana won theerpharara na ŋkarveni ruagiap, mbaram won pana rɨgiram, na ŋkarveni mbɨ thɨgi. ");
INSERT INTO geb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ndu vhɨra na viavav, na khoman pangi fhu. Gu zerav ndu phenan vhen kim, kha mbik, ana vhen zeravra thav za na ŋkarveni viavav na ŋkarveni khoman mparav, mbara muuŋgia khar ki. ");
INSERT INTO geb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ndu vhɨra mporiin na pana hɨvgi fhu, kha mbik, ana zɨgap ndɨga vhuuŋ hi mporiin na ŋkarveni hɨvgi. ");
INSERT INTO geb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Gu maaŋ muuŋgiap ndu nzuai, Fhe Bakɨme kha mbik muuŋgi tɨvi mbatɨgi vhɨrve, ana nta vhɨzgiap, nta ndɨkndɨk ŋangi. Kha mbik, ana guigira Fhe Bakɨme vuzvugi. Guma tɨvi mbatɨgi vhɨrve ga muuŋgi fhuv, Fhe Bakɨme ana muuŋgi tɨvi mbatɨgire vhɨzgiap, nta ndɨkndɨk ŋangi. Mba guma, ana pim Fhe Bakɨme vuzvugirga fhu.” ");
INSERT INTO geb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Zisas maaŋ Saimon ga suaŋgiap, khaŋ mba mbiga nzuai, “Gu ndu fhum muuŋgi tɨvi mbatɨgi, gu nta vhɨzgiap, nta ndɨkndɨk ŋangi.” ");
INSERT INTO geb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Zisas ne mba mbiga nzuaim, mba Zisas phorgɨp mbɨr zav mba kaa ga piigi gumgi ne mbararagiap, mbaram nduarira khaŋ wari ga nzuai, “Khe the khare, ana gumgi mbui tɨvi mbatɨgi, ana nta vhɨzi?” ");
INSERT INTO geb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mba gumgi mba ndɨkndɨga mbuim, Zisas mbaram khaŋ mba mbiga nzuai, “Ndu na khothɨgi, Fhe Bakɨme ntige taagia ndu ndigi. Ndu ntige ndav mbɨrav ŋgɨv, ndava mɨɨtɨgar kɨri.” ");
INSERT INTO geb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Zisas mba mbigar kurav, mbaram maaŋ thav khavgiap, za mba ŋgui bakɨvi gum ŋgui bisarire ga ruigi. Ana ruav, Fhe Bakɨme won gumgi gu mbigi ganɨrim, mbe ana piin kɨrga buni vhuuiŋ bun mbe nzua rui. Ana khaŋ mbui, ana ŋgu mben vugap, mba Fhe Bakɨme buni vhuuin mbe suaŋgiap, khavgiap, harigi nen vui. Ana mbara mbua rui. Ana ruim, ana mba farasegi 12 thɨgi ŋaara gumgi ana phorga rui. ");
INSERT INTO geb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Mbe mbigi mbari, mbe vhɨra ana phorga rui. Mba mbigi, ana fhum mbe tɨn ŋiniŋgi mbatɨgi ga vharvharav, mbe rɨmrɨɨ ga mbuim, nta vhɨzgi. Mba mbigi zɨri khare. Makdaran mbik Maria, mba mbik Zisas fhum ana tɨn harathɨgi ŋiniŋgi mbatɨgi ga vharigim, nta ana thav kɨrar hegi. ");
INSERT INTO geb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ana phorga ruigi mbiga mbe Zoana, ana Kuzan muuŋ ma. Anan mana Kuza, ana Herot phena gari guma bakɨme ma. Mbe phorga ruigi mbiga mbe khare, Susana. Mbe mbigi vhɨrvera Zisas phorga ruigi. Mba mbigi, mbe won bigira Zisas gu ana phorga rui gumgir kurkurigi. ");
INSERT INTO geb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Zisas maaŋ mbua ruim, gumgi gu mbigi vhɨrve zav ana phok thɨgi. Mba gumgi gu mbigi, mbe zam ana mba rui fhain ŋguir kegap zav ana phok thɨgi. Mbe za ana phok thɨgim, Zisas mbaram buna mueŋ vhunama sav khaŋ mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Guma mbe vov rezi fara muuŋgi mba wit ndi mɨna fui. Ana vov nta ndi mɨna fuim, mbari rav, tuav ga regi. Mba tuav ga regi ntɨɨri, gumgi nta thipoga ruim, korgi zav nta mbegi. ");
INSERT INTO geb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mbari ŋkɨɨ ki nuianeŋ ga regi. Nta regap, thooŋgiap, vhuunga ntɨɨri ki. Mba nuianeŋ vhɨra mbɨ ki fhu, maaŋ muuŋgiap, nta za thooŋgiap, nzɨɨv, vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mbari tari ki kargi ki nuianeŋ ga regi. Nta mba nuianeŋ ga regap, mba tari ki kargi phorga vhuuŋgim, mba tari ki kargi, nta kav, nta zɨrgi. ");
INSERT INTO geb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mbari nuiana vhuueŋ ga regi, nta regap, vhuuŋgiap, mba vhɨrvera tegi. Mbari 100 thɨgi vhɨgi mbarigi.” Zisas mba bunin mbe nzua vov kama bakɨmera khaŋ mbe nzuai, “Guma khuarani kɨv, ana kha buni mbararari.” ");
INSERT INTO geb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Zisas mba bunin mbe suaŋgim, ana phorga rui gumgi ana nzarigi, “Ndu kha vhunama dagi buna nɨɨeŋ ram nzuai?” ");
INSERT INTO geb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Mbe mba nzambaran Zisas ga muuŋgim, Zisas mbe ŋgarkarav khaŋ mbe nzuai, “Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨv muunga bigi, ana mba zorgi bigi, ana ntan nde khɨvav, ana nta nɨɨŋge bun nde suaŋgi. Gu mba harigi gumgi gu mbigi, gu fhura vhunaa ga si bunira mbe nzuai. Mbe maaŋ muuŋgiap, mbe zazera gari, mbe bigɨn thueŋ sarga fhu. Mbe vhɨra zazera mbararagi, mbe bigɨn thueŋ kaŋgirga fhu.” ");
INSERT INTO geb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Zisas nen mbe suaŋgiap khaŋ mbe nzuai, “Gu mba vhunama si buna nɨɨeŋ khare. Mba mban vhɨgi, nta Fhe Bakɨmen buni vhuuiŋ ma. ");
INSERT INTO geb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mban vhɨgi mba tuav gaa ga regi. Mba tuav gaa, ana khaŋ muuŋgi gumgi gu mbigi ma. Mbe Fhe Bakɨme buni mbararagim, Satan zav, mbe ndavi vherir mben tɨn mba Fhe Bakɨme bunin vhuuiŋ, ana nta ndigi. Ana khueŋ ndɨkndɨgi, ana muuŋv kɨrim, mbe Fhe Bakɨme buni vhuuiŋ khothɨgɨrim, ana taagi mbe ndigɨ rivgi. ");
INSERT INTO geb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mban vhɨgi mba ŋkɨɨ ki nuianeŋ ga regi. Mba ŋkɨɨ ki nuianeŋ ne khaŋ muuŋgi gumgi gu mbigi ma. Mbe Fhe Bakɨme buni vhuuiŋ mbararav, guigira nta nzuav ndikndigi. Mbe vhɨra, mbe mba thɨri khɨnan vergi fhuv mban vhɨgi fara muuŋgi. Mbe khaŋ muuŋgi, mbe tuga tɨvaneŋra Fhe Bakɨme buni vhuuiŋ khothɨgap nta zɨn vui. Mbe nta zɨn vovra thagim, mben mpari bigeŋ mben hɨgim, mbe rɨgap za Fhe Bakɨme thagi. ");
INSERT INTO geb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mba mban vhɨgi mba tari ki kargi ki nuianeŋ ga regi. Mba tari ki karɨgi ki nuianeŋ, ne khaŋ muuŋgi gumgi gu mbigi ma. Mbe Fhe Bakɨme buni vhuuiŋ mbararav, nta khothɨgɨ za mbuav, mbe vhɨra kha nuiana bigi ga nzuav thagine mbui ndɨkndɨk kɨvgiap mben ki. Mbe kha nuianan ŋkɨɨ vhɨrve kɨrgeŋ nzuav mbuav, mbe vhɨra kha nuiana bigi vhɨrve garav, nta nzuav rɨmgi phara tui. Mba bigi ndɨkndɨgi zav, mba Fhe Bakɨme buni vhuuiŋ mbevigim, nta mba ti fhu. ");
INSERT INTO geb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mba mban vhɨgi mba nuiana vhuueŋ ga regi. Mba nuiana vhuueŋ khaŋ muuŋgi gumgi gu mbigi ma. Mbe Fhe Bakɨme buni vhuuiŋ mbararav, nta ndim wari wo ndavi vheri ga tɨgap, nta zɨn vui gumgi gu mbigi ma. Mbe maaŋ mbuav thɨga havhargiap, mba ti.” ");
INSERT INTO geb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Guma the fhum rama durav ana ndi ndan vhee rugire, ee, ana ndi kaan piiaŋ ndarigire? Fhuvara. Ana ana durav, ana ndi hiiŋra ntorgim, gumgi zav ana ŋaara gari. ");
INSERT INTO geb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Gu guigira khar nde nzuai, nde mba vhagi bigi, nta zumgum kɨrar hegɨrga. Nde vhɨra mba zomzora mbui bigi, nta vhɨra zumgum kɨrar hegɨrga. ");
INSERT INTO geb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Nde tuituigira wari ganɨv, nde tuituigira kha buni mbararari. Guma bigi mbari ki, Fhe Bakɨme harigi bigi phorgɨv anan nɨɨŋgirga. Guma bigi ki fhuv, Fhe Bakɨme, ana mba suirav kav khaŋ nzuai bigire, ‘Khe na bigire ma. Ana maaŋ nzuai bigi, Ana ana tɨn nta ndigirga.’ ” ");
INSERT INTO geb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Zisas mba bunin mbe nzuav kim, ana niamuuŋ gum anan ŋgugi ana ganɨ zav zi. Mbe zav, ram muuŋgip mba phena vhen ŋgirɨp ana gangirie? Mba gumgi gu mbigi za mba phena thɨmkamani givigi. ");
INSERT INTO geb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mbe mbara kim, guma mbe mbe bun ana nzuai. Mba guma khaŋ ana nzuai, “Ndu niamuuŋ gu ŋgugi, mbe ndu ganɨ zav zegap, ndu rargap kɨrar mbur thivgiap ki.” ");
INSERT INTO geb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Zisas ne mbararagiap, ana ŋgarkarav khaŋ nzuai, “Fhe Bakɨme buni vhuuiŋ mbararav nta zɨn vui ntɨɨri, mbe na ndegmbori gum nan ŋgugi ma.” ");
INSERT INTO geb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Raa mben Zisas khaŋ wo phorga rui gumgi ga nzuai, “Nza kha mbɨ thugɨp mueŋ nderen hɨrga.” Ana maaŋ mbe suaŋgiap, mbe kema mben vergap, mbɨ thugap, muen hi. ");
INSERT INTO geb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mbe kema togap muen vov, Zisas thoga kuigi. Ana kuigim, bɨɨŋbɨɨŋ bakɨme khavgi. Mba bɨɨŋbɨɨŋ bakɨme khavgim, mba mbɨ phuri ra shoga zav fo mbe keman mbaim, ana mbɨ thor zav bisaŋ khɨnanera. Mbe guigira tuga mbatɨga ndi. ");
INSERT INTO geb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mbe tuga mbatɨga ndiav, mba Zisas phorga rui gumgi, mbe vov Zisasan vhurav khaŋ ana nzuai, “Guman Rum, Guman Rum, nza mbɨ thov vhɨzɨr zav mbui.” Mbe maaŋ ana nzuaim, ana khavgiap, mbaram mba bɨɨŋbɨɨŋ gum mbɨ phuri ruma mbuav, mani ga vhegim, mani fhura thuga vugi. Mani thuga vugim, mba mbɨ fhura mbɨrira vugap rɨgap ki. ");
INSERT INTO geb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Zisas mbaram kha nzambaran wo phorga rui gumgi ga mbui, “Nde na khothɨgi tɨv maaŋ ki?” Ana mba nzambaran mbe mbuim, mbe guigira rivgiap, ŋgava mbatɨga muuŋgiap, tamtam warir nzai, “Khe the khare? Ana kha bɨɨŋbɨɨŋ gum mbɨ phuri ga nzuaim, ni vhɨra ana buni mbararav ana buni zɨn vui.” ");
INSERT INTO geb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Mbe mba Gariri mbɨ thugap, muen Gariri fhain Gereseniŋ ndereŋ phorgi. ");
INSERT INTO geb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Mbe phorgap Zisas mba kema thav thɨvar ndavra thagim, ŋina mbatɨk vhen ndagi guma mbe mba ŋgu bakɨmen kegap, anan pura zi. Mba guma shagi shargia ki fhuvara. Ana fhum tuga mpeeŋmpeen, ana fhura mbugumra ki. Ana vhɨra phena kui fhu, ana mba mbe gumgi ndi mbogi ga rɨgi mbogi ga kui. Mba ŋina mbatɨk tugi vhɨrvera ana suigap, ana shogi. Mba guma, mbe fhum shenin ana harani gum suani kav, ana ganɨnga gumgi mbari ndi fim, mbe ana gari. Ana fhum mbe daaga suav, mba sheni gora suav, ruav ki. Ana nta gora suim, mba ŋina mbatɨk anan kov gumgi ki fhuv ŋani ga ruim, ana ntan ki. Mba ŋina mbatɨk vhen ndagi guma Zisas gangiap, nzɨɨv, anan pura zav, wo fega Zisas nɨma khɨngi. Zisas mbaram khaŋ mba ŋina mbatɨga nzuai, “Ndu ŋina mbatɨk, ndu mba guma thav kɨrar hɨgɨri.” Zisas maaŋ ana nzuaim, mba ŋina mbatɨk kama bakɨme rugap, nzɨɨv, khaŋ ana nzuai, “Ndu ram nan muun zav mbui, Zisas, za kha bigi kharav vu guarara ki Fhe Bakɨmen Kam? Gu ndun nzai, ndu zaar nan nɨɨ thari.” ");
INSERT INTO geb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mba ŋina mbatɨk ne nzuaim, Zisas mbaram anan nzarigi “Ndu wo zɨ zita.” Mba ŋina mbatɨk ana ŋgarkarav khaŋ nzuai, “Na zɨ Vhɨrve.” Ana khaŋ muuŋgiap ne nzuai, mbe ŋiniŋgi vhɨrvera, mbe mba guman vhen ndav ana vhen ki. ");
INSERT INTO geb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mba ŋiniŋgi mbatɨgi ne suaŋgiap, mbaram khaŋ tɨgap suambarar mbatɨgar Zisas ga mbuav khaŋ nzuai, “Ndu nza ndim, mbu khɨna gari fhuv mboga su thari.” ");
INSERT INTO geb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mba tugen daa vhɨrve mba mbɨkshɨma piin hanera maaŋ kav pav kim, mba ŋiniŋgi mbatɨgi khaŋ tɨgap Zisas ga nzuai, “Ndu nza khɨrav nza sararim, nza ŋgɨv mbu daa vherir ndarga.” Mba ŋiniŋgi mbatɨgi ne nzuaim, Zisas mbe khɨrigi. ");
INSERT INTO geb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Zisas mba ŋiniŋgi mbatɨgi khɨrigim, mbe mba guma thav kɨrar hegap, vov, mba daar vherir vergi. Mba daar vhɨrve khuafua vov, mba vhara ntaaŋntaan vera vov, mba mbɨn vergap, mbɨ pava vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mba daa gari gumgi mba daar hɨgi bigeŋ gangiap, ra vov mba ŋgu bakɨmen vov, mba fhain ki ŋgui bisarirer vov mba hɨgi bigeŋ bun nzuai. ");
INSERT INTO geb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mba gumgi gu mbigi mba hɨgi bigeŋ ganɨ zav wari zi. Mbe zav Zisas han mba ŋiniŋgi mbatɨgi vhɨrve vhen ndav kegi guma gari. Ana ndɨkndɨga vhuuŋ taagia anan zɨgim, ana wo shagi shargiap Zisas nɨman perav ki. Mbe maaŋ muuŋgia ana gangiap, wari guigira rivgi. ");
INSERT INTO geb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mbe rɨvim, mba hɨgi bigeŋ gangi ntɨɨri, mbe mba ŋiniŋgi mbatɨgi vhen ndav kegi guman hɨgi bigi bun za mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mbe mba bigi bun mbe nzuaim, mba Gereseniŋ fhain ki gumgi gu mbigi, mbe zam mba bigi mbararagiap, guigira rɨrɨva mbatɨga muuŋgiap, wari wo fhaiŋ thav ŋgɨr zav Zisas ga nzuai. Mbe Zisas ga nzuaim, Zisas mbe fhaiŋ thav vov, keman vergap, vui. ");
INSERT INTO geb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Zisas vuim, mba ŋiniŋgi mbatɨgi vhen ndav kegi guma, ana phorgɨv ŋgɨr zav khaŋ tɨgap ana nzuai. Ana nzuaim, Zisas ana thɨvav khaŋ ana nzuai, “Ndu taagip wo fek gu tari han wo phenan ŋgɨv, Fhe Bakɨme guigira ndun kurkurav ndu muuŋgi bigi bun mbe suaŋri.” Zisas maaŋ mba guma ga suaŋgim, ana taagiap wo phenan vov, ana mba Fhe Bakɨme guigira anan kurkurav ana muuŋgi bigi, ana za nta bun mba ŋgu bakɨmen ki gumgi gu mbigi ga suaŋgi. ");
INSERT INTO geb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Zisas kema ndigap, mba mbɨ thugap, taagia mueŋ nderen hɨgim, gumgi gu mbigi vhɨrve anan rarga ki. Ana vov hɨgim, mbe ana gangiap guigira ndikndigi. ");
INSERT INTO geb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Zisas havra thagim, mba Fhe Bakɨme buni mbararagi phenan ŋaari gari guman pana mbe, ana zɨ Zairus, ana Zisas han zi. Ana zav wo fegap Zisas nɨma khɨngiap, guigira khaŋ tɨgap wo phenan ŋgɨr zav Zisas ga nzuai. ");
INSERT INTO geb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ana kambiga banera ki, anan mpari khaŋ muuŋgi, 12 thɨgi. Ana rɨmɨn zav gor vhɨk bisanera ki. Ana maaŋ muuŋgiap wo phenan ŋgɨr zav khaŋ tɨgap Zisas ga nzuai. Zisas ana kameŋ mbararagiap, ana phorga vuim, gumgi gu mbigi vhɨrve ana phorga vov guigira ana nderigi. ");
INSERT INTO geb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mbe vuim, mbe rɨgar vɨzɨna ti rɨmrɨm ki mbiga mbe vhɨra mbe phorga vui. Mba mbik, ana wo sargori rɨmrɨm anan kim, 12 thɨgi mpari vhɨzgi. Ana fhum mba rɨmrɨm vhɨzɨ zav mbuim, guma the anan kurav, mba rɨmrɨm vhɨzgirga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mba mbik mbaram vov, Zisas zɨn kɨrar vugap ana shaa tɨva suirigi. Ana ana shaa tɨva suigavara thagi, mba sargori rɨmrɨm fhura thuga mbar vugi. Ana wo khɨkhɨm mbararagi, ana fhav taagia nzerigi. ");
INSERT INTO geb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mba mbik Zisas shaa tɨva suigara thagim, Zisas khaŋ mbe nzuai, “The nan suirigi?” Ana maaŋ mbe nzuaim, mbe wari ndi zaahav, Pita khaŋ ana nzuai, “Guma Rum, ndu garim, kha gumgi gu mbigi vhɨrve za ndu rorgiap ndu nderigi.” ");
INSERT INTO geb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pita ne nzuaim, Zisas mbaram khaŋ nzuai, “Gu kaŋgi, guma mbe nan suirigi. Gu vhɨra wo khɨkhɨm mbararagim, mba Fhe Bakɨme mba gumgir rɨmrɨɨ vhɨzɨ zav na nɨɨŋgi ŋkasŋka na fhava khavgi.” ");
INSERT INTO geb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Zisas ne nzuaim, mba mbik, ana wo vhargeŋ mbovara thav, ninɨk ana mbuim, ana zav wo thɨpani phɨrgiap, Zisas nɨman fav, wo nɨma ndi nuiana dagi. Ana wo nɨma ndi nuiana dav, mbaram mba gumgi gu mbigi vhɨrve nɨmara mba ana suirigi bigɨna nɨɨeŋ bun Zisas ga nzuai. Ana nen ana nzuav vhɨra khaŋ ana nzuai, “Gu ndu shaa suiravra thagim, nan rɨmrɨm fhura thuga vugi.” ");
INSERT INTO geb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ana maaŋ nzuaim, Zisas mbaram khaŋ ana nzuai, “Na kambik, ndu na khothɨgim, ndu rɨmrɨm vhɨzgi. Ndu ndav mbɨrav ŋgɨri.” ");
INSERT INTO geb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Zisas maam mba mbiga nzuavra kim, guma mbe mba Fhe Bakɨme buni mbararagi phenan ŋaari gari guma Zairus phenan kegap zɨgi. Ana zɨgap khaŋ Zairus ga nzuai, “Ai, ndun kambik rimgi, ndu kavtuigar guma ruma su thari.” ");
INSERT INTO geb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ana nen Zairus ga nzuaim, Zisas ne mbararagiap khaŋ Zairus ga nzuai, “Zairus, ndu rɨvɨ thari, ndu fhura na khothɨgɨrim, ana taagip khavgirga.” ");
INSERT INTO geb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Zisas ne suaŋgiap, mbe vov Zairus phena hegap, ana za mba gumgi gu mbigi thɨvav, mbe ndi kɨra tɨgap, Pita gum Zon, Zems, mba tara ndia gum niamuuŋ, ana mbera kov vhen veri. ");
INSERT INTO geb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ana verap garim, mba tara khuma han ki gumgi gu mbigi, mbe zam mba tara nzuav nzɨɨva nziav ki. Zisas mbe garav khaŋ mbe nzuai, “Ai, nde zam nzigi. Mbige maaŋ rimgi, ana kui.” ");
INSERT INTO geb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Zisas nen mbe nzuaim, mbe thɨri fierav khaŋ ana nzuai, “Ee, nza tarire, e? Nza kaŋgi, ana guigira rimgi.” ");
INSERT INTO geb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mbe ne nzuaim, Zisas mbaram ana hara suirav khaŋ ana nzuai, “Nan tar, ndu khavik.” ");
INSERT INTO geb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Zisas nen ana nzuavra thagim, mba biptara vhen ki guma taagia zav ana rugim, ana taagia khavgia thɨgi. Ana khavgim, Zisas mbaram khaŋ mbe nzuai, “Nde mban mba biptaran nɨɨŋgirim, ana mbɨ.” ");
INSERT INTO geb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Zisas maaŋ mani ga nzuaim, mba biptara niamuuŋ gu ndia ana gangiap, guigira ŋgava mbatɨga muuŋgi. Mani ŋgava mbatɨga mbuim, Zisas mbaram kama havharan mani ga ndɨɨv khaŋ mani ga nzuai, “Ŋko kha hɨgi bigeŋ bun harigi guma the suaŋ thari.” ");
INSERT INTO geb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Zisas wo farasegi 12 thɨgi ŋaara gumgir kamgim, mbe ana han zim, ana mbe fugi. Ana mbe fugap, za ŋiniŋgi mbatɨgi ga vharvharav, vhɨra mbarkɨrga rɨmrɨɨ vhɨzɨrga ne nzuav zɨ bakɨme gum ŋkasŋkan mbe ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ana zɨ bakɨme gum ŋkasŋkan mbe nɨɨŋgip, mbe sararim, mbe ŋgɨp Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga buni vhuuiŋ bun mbe suaŋv, vhɨra gumgi gu mbigi rɨmrɨɨ vhɨzɨrga. ");
INSERT INTO geb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ana kha suambarar mbe mbuav mbe ndim mbai, “Nde ŋgɨv bigi thari ndigip wari ŋgɨ thari. Nde ŋgɨv sɨga suigɨ thari, nde vhɨra mpaa thar thige rugɨ thari, nde mba thaneŋ ndi thari. Nde vhɨra kɨmararaŋ thueŋ suigɨ thari. Nde vhɨra fhava shaara mpugeni ndi thari, nde bagera sharav ŋgɨri. ");
INSERT INTO geb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nde maaŋ muuŋgip ŋgɨv ŋgu then ŋgɨgɨrim, mbe phena then nden nɨɨŋgirim, nde mba phenara kɨv kɨv, mba ŋgu thav harigi ŋgun ŋgɨri. ");
INSERT INTO geb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nde maaŋ muuŋgip ŋgɨp, ŋgu then ŋgɨgɨrim, mbe nde vuzvugi fhuv, mbe vhɨra nde nzuai buni mbararagi fhuv, nde khaŋ muuŋri! Nde mba ŋgu thav ŋgɨv, wari wo ŋkari shari nuiana pɨzgip, wari mba ŋgu thav ŋgɨri. Nde maaŋ muuŋgirim, mbe gangip kaŋgirga, mbe tɨvar vhuun nde muuŋgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ana maaŋ mbe suaŋgiap, mbe sarigim, mbe vui. Mbe vov, ŋgu mben vugap, Fhe Bakɨmen buni vhuuin mbe suaŋgiap, khavgiap, harigi nen vui. Mbe maaŋ mbua ruav, za mba rui ŋguir gumgi gu mbigi vhɨrver kurkurav mbe mbuim, mbe rɨmrɨɨ vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Zisas mba bigi vhɨrve ga mbuim, ana zɨ hɨgim, gumgi vhɨrve ana kaŋgi. Herot, Gariri gum Peria fhaiŋ gari guman pan ne mbararagiap, ndɨkndɨgi vhɨrve ga mbui. Ana gumgi mbari mbararagim, mbe khaŋ nzuai, “Zon Gumgi Ruai Guma, ana rimgiap taagia khavgi.” ");
INSERT INTO geb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mbe mbari khaŋ nzuai, “Iraiza taagia hɨgi.” Mbe mbari khaŋ nzuavra ki, “Khe fhum guarara kegi Fhe Bakɨmen kamthooŋ guma mbe ma. Ana rimgia kegap, taagia khavgi.” ");
INSERT INTO geb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mbe mba khesharigi buni nzuaim, Herot khaŋ nzuai, “Gu Zon Gumgi Ruai Guma, gu ana fhɨra thugim, ana rimgi. The mbar ka mbuim, mbe ana bun nzuaim, gu ana mbararagi?” Ana ne suaŋgiap mparav, ana ganɨ za nzuai. ");
INSERT INTO geb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Zisas mba farasegi 12 thɨgi ŋaara gumgi ga sarigi. Mbe vega kegap, taagia zegap, Zisas han wari fugi. Mbe wari fugap, mba ruav muuŋgi bigi gum, mba gumgi gu mbigi khɨvav mbe suaŋgi bigi, mbe nta bun Zisas ga nzuai. Mbe mba bigi bun ana suaŋgim, ana mben kov, mbe nduarira ŋgu mben vegi. Mba ŋgu zɨ khare, Betsaida. ");
INSERT INTO geb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ana mben kov vugim, mba gumgi gu mbigi, mbe Zisas vugi ŋaneŋ kaŋgiap, mbe ana zɨn vegi. Mbe ana zɨn vegim, ana mbe gangiap, mben ndikndigap, mbaram Fhe Bakɨme won gumgi gu mbigi ganɨnga, mbe ana piin kɨrga buni vhuuiŋ bun mbe nzuai. Ana mba bunin mbe nzuav, mba rɨmrɨɨ ki gumgi gu mbigi, ana mben kurkurav, mbe rɨmrɨɨ vhɨzi. ");
INSERT INTO geb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Zisas maaŋ mbe mbuav kim, ra verav vhɨzim, ana mba farasegi 12 thɨgi ŋaara gumgi ana han zav khaŋ ana nzuai, “Ndu kha gumgi gu mbigi ga sararim, mbe kha fhain ki ŋgui gum ruari ŋguivigen ŋgɨp, wari ga suaŋv mba vhezɨp mbɨv, wari ga suaŋv ŋkuur ŋani ndi ganɨnga. Khe gumgi ki fhuv ŋanen khare.” ");
INSERT INTO geb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mbe nen ana nzuaim, ana mbe ŋgarkarav khaŋ mbe nzuai, “Nde mbɨv mben kurmbɨ.” Mbe ana ŋgarkarav khaŋ nzuai, “Nza meeŋthɨgi vikntuuveŋra mbɨgama shɨɨŋ mpuani phorga khar ki. Ndu vuzvugi, nza ŋgɨp za kha gumgir tuktɨgɨp mba vhezgirie?” ");
INSERT INTO geb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mbe 5,000 gumgi, mbe zegap maaŋ ki. Ana thav khaŋ wo phorga rui gumgi ga nzuai, “Nde mba gumgi gu mbigi ga suaŋrim, mbe khaŋ muuŋgip phogir vhov pigɨri. Mbe 50 thɨgi ntɨɨri phok then pigɨri, mbe 50 thɨgi thari phok then pigɨri, mbe mbara muuŋv phogir pigɨri.” ");
INSERT INTO geb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ana wo phorga rui gumgi ga suaŋgim, mbe ana suaŋgi kamara zɨn vov mbe nzuaim, mbe mbara muuŋgia piigi. ");
INSERT INTO geb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Mbe piigim, Zisas mbaram mba meeŋthɨgi vikntuuveŋ ndigap, mbaram, mba mbɨgama shɨɨŋ mpuani phorgap ndigap, khoga buiva garav, Fhe Bakɨme ndikndigap ana phorga suaŋgiap, nta phɨra sui. Ana nta phɨra suav, wo phorga rui gumgi ga nzuaim, mbe nta shama mbuav, mba gumgi gu mbigi ga ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mba gumgi gu mbigi za mbegap, za ndavi givigi. Mba Zisas phorga rui gumgi, mbe mba ndavi givav thagi mban tɨvi, mbe nta ndiav 12 thɨgi kɨra ga vhuigim, nta za givigi. ");
INSERT INTO geb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tuga mben Zisas wo phorga rui gumgir kov, mbe nduarira wari hiav ŋana mueŋ kav, Zisas Fhe Bakɨme phorga nzuai. Ana Fhe Bakɨme phorga nzuav kav, wo phorga rui gumgir nzarigi, “Kha gumgi gu mbigi vhɨrve then na rɨgi?” ");
INSERT INTO geb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mbe ana ŋgarkarav khaŋ ana nzuai, “Mbe vhɨrve khaŋ nzuai, ‘Ndu Zon Gumgi Ruai Guma ma.’ Mbe mbari khaŋ nzuai, ‘Ndu Fhe Bakɨme kamthooŋ guma Iraiza ma, ana taagia hɨgi.’ Mbe mbari khaŋ nzuavra ki, ‘Mba fhum guarara kegi Fhe Bakɨmen kamthooŋ guma mbe ma. Ana rimgia kegap taagia khavgi.’ ” ");
INSERT INTO geb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mbe maaŋ nzuaim, Zisas wom mben nzarigi, “Mbe maaŋ nzuaim, nde ram mbui ndɨkndɨgar na mbui? Nde then na rɨgi?” Ana ne nzuaim, Pita mbaram ana ŋgarkarav khaŋ nzuai, “Ndu Krais, Fhe Bakɨme taagia kha gumgi gu mbigi ndir zav farasarigi guma ma.” ");
INSERT INTO geb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pita ne nzuaim, Zisas mbaram mbe goriruav, khaŋ mbe nzuai, “Nde na bun harigi guma the suaŋ thari.” ");
INSERT INTO geb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Zisas maaŋ mbe nzua vov khaŋ nzuai, “Fhe Bakɨme Guma Guar zaagi vhɨrve ndirga. Mba gumgi ruu gum, mba Fhe Bakɨme rotu gari gumgir pani gum, mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi, mbe zam ana shashagip kɨr ana segɨrga. Mbe ana shogirim, ana rimgirga, ra phuni khegene vhɨzgirim, ana taagi khavgirga.” ");
INSERT INTO geb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ana nen mbe nzuav khaŋ za mbe nzuai, “Guma the na zɨn zɨr saŋv, ana wo vuzvugi mbevav, zazera wo rɨmɨnga khanarareŋ phufhurav, na zɨn zɨri. ");
INSERT INTO geb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Guma the wora ndɨkndɨgɨrga, anan tum zumgum za fhɨrgi rɨgɨrga. Guma the na ndɨrɨgɨp won tuma sharga, anan tum zazera mbara muuŋgip kɨrga. ");
INSERT INTO geb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Khe tɨvar vhuuŋ e? Guma the wora ndɨkndɨgɨv, za kha nuianan ki bigi, ana zam nta ndigɨp, ntan muuŋv kɨv rimgirga. Ana zumgum vhava bakɨmen ŋgɨgɨp zaa mbatɨga ndirga, mba bigi ram muuŋgip ana tuman kurarie? ");
INSERT INTO geb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nde mbarara, nde guma the ntigem na zɨ gum na buni vhuuin mbergi, Fhe Bakɨme Guma Guar, ana zumgum won Ndia han Hevenan kegɨp, ana won ŋkasŋka vhava ŋaara gum, Fhe Bakɨme ŋkasŋka vhava ŋaar gum, Fhe Bakɨmen enserir ŋaari ŋkasŋka vhava ŋaar, ana mbe phorgɨ zirɨrga. Ana vhɨra mba tugen, mba guman mbergirga.” ");
INSERT INTO geb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Zisas mba bunin mbe nzua vov, khaŋ mbe nzuai, “Gu guigira khar nde nzuai, nde ntige khar thivgia ki ntɨɨri, nde thari vhɨzgirga fhu. Nde khara muuŋgip kɨv ganɨrim, Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga tuk hɨgɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Zisas mba bunin mbe suaŋgim, sɨgarathɨgi rari vhɨzgim, ana Pita, Zon gum Zems, ana mbera kov Fhe Bakɨme phorgɨ suan zav mbɨkshɨman ndagi. ");
INSERT INTO geb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ana mbe kov ndav kav, Fhe Bakɨme phorga nzuai. Ana ana phorga nzuav kim, ana khom harigi khesharav hɨgim, ana mba sharigi shagi, nta guigira hurgiap ŋgara gari. ");
INSERT INTO geb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ana khom gum bigi maaŋ muuŋgim, guma phunini hav, ana phorga thɨgap, ana phorga buni nzuai, Moses gum Iraiza. Mani Fhe Bakɨme ŋkasŋka vhava ŋaara phorga zav ana phorga nzuai. Mani ana Zerusareman ŋgirgɨp, mba Fhe Bakɨme mpuun muun zav ana farasarigi ŋaara bakɨme ana mba ŋaara simtɨga ndirga ne nzuav mani ana phorga nzuai. ");
INSERT INTO geb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mani ana phorga nzuaim, Pita gum mba ana phorga ndagi guma phunini, mbe ŋkuu mbe muuŋgim, mbe kuav ki. Mbe kuav kav semsegap za Zisas ŋkasŋkar vhava ŋaara garav, mba gumani garim, mani Zisas phorga thɨgap ki. ");
INSERT INTO geb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mba guma phunini Zisas thav ŋgɨr zav mbuim, Pita mbaram khaŋ Zisas ga nzuai, “Guman Rum, nza nzerara khaŋ ndagi. Nza mpɨkava phuni khegene muuŋgirga, ndu suaŋv thevi Moses ga suaŋv thevi, Iraiza ga suaŋv thevi.” Pita suanga buni kakagia fhura ne suaŋgi. ");
INSERT INTO geb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita ne Zisas ga nzuaim, buiva hur hav, mbe vharigi. Mba buiva hur hav mbe vharigim, mbe guigira rivgi. ");
INSERT INTO geb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mbe rɨvim, Fhe Bakɨme mba buiva hurige vhen kav khaŋ mbe nzuai, “Khe nan Kam ma! Gu won ŋaarar muun zav ana farasarigi, nde ana nzuai buni mbararari!” ");
INSERT INTO geb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Fhe Bakɨme maaŋ mbe suaŋgim, mbe garim, mba guma phunini fhura mbar vugim, Zisas nduara thɨgap ki. Mba Zisas phorga rui guma phuni khegene mba bigeŋ gangiap, mbe nen warira khɨga ki. Mbe mba tugen ne bun harigi guma the suaŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Zisas mba mbɨkshɨman kegap, mbe mɨtimanera taagia zeri. Mbe zerigim, gumgi gu mbigi vhɨrve zav Zisasan purigi. ");
INSERT INTO geb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mba gumgi gu mbigi vhɨrve rɨgar, guma mbe kama hegap, khaŋ tɨgap Zisas ga nzuai, “Guman Rum, gu khaŋ muuŋgiap ndu nzuai, ndu zɨv nan kama ganɨ, gu mba kama bavira. ");
INSERT INTO geb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ŋina mbatɨga mbe ana vhen kav, zazera ana shogim, ana nzɨɨv, ninɨga suigap, phuvun ana kamaŋɨni thivi. Mba ŋina mbatɨk guigira anan farfav, tugi babara ana thamthagi, ana fhura ki. ");
INSERT INTO geb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Gu ana vharvhara zav khaŋ tɨgap ndu phorga rui gumgi ga nzuai, mbe ana vharvharargen mbovaragi.” ");
INSERT INTO geb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ana nen Zisas ga nzuaim, Zisas mbaram ana ŋgarkarav khaŋ nzuai, “Nde ntige kha tugen vhuuŋgia ki gumgi gu mbigi, nde Fhe Bakɨme mbui bigi khothivi fhuvara. Nden ndɨkndɨgi gum nden tɨvi guigira nzerigi fhuvara. Gu khara muuŋgip nde phorgɨ kɨv, nden simtɨgi ndirie?” Zisas ne mbe suaŋgiap, mbaram khaŋ mba guma ga nzuai, “Ndu won kama ndigi khar zɨ.” ");
INSERT INTO geb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Zisas ne nzuai, mba tara ndia ana kov Zisas han zim, mba ŋina mbatɨk taagiap mba tara shogim, ana rɨgap ninɨga mbatɨga mbui. Zisas mbaram mba ŋina mbatɨga vhegim, ana mba tara thav kɨrar hɨgim, mba tar taagia nzerigi. Zisas mbaram mba tara nzuaim, ana taagia khavgiap, won ndia han vui. ");
INSERT INTO geb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ana wo ndia han vuim, mba gumgi gu mbigi zam, Fhe Bakɨme ŋkasŋka bakɨme gangiap guigira ŋgava mbatɨga muuŋgi. Mbe mba Zisas muuŋgi bigi, mbe za nta gangiap, ŋgava mbatɨga mbuim, Zisas mbaram khaŋ wo phorga rui gumgi ga nzuai, ");
INSERT INTO geb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nde ntige thukhɨngira, gu khar nde suan za mbui buneŋ mbararagiri. Fhe Bakɨme Guma Guar, mbe ana thuuŋ dorgɨp, ana suav kama shɨrav, ana ndim gumgi farve khɨngirga.” ");
INSERT INTO geb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ana ne nzuaim, ana phorga rui gumgi, mbe mba buna nɨɨeŋ kaŋgi fhu. Mbe ana mbararagim, ana mba buna nɨɨeŋ sigasarav, mbe suaŋgi fhuvara. Fhe Bakɨme mba buna nɨɨen mbe vhagi. Mbe maaŋ muuŋgiap kakagiap, anan nzan zav mbov, mbe anan rivgiap wari thagi. ");
INSERT INTO geb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Zisas phorga rui gumgi mbe khueŋ nzuav hegap wari daav wari ga nzuai, the mbe rɨgar zɨ kɨrie? ");
INSERT INTO geb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mbe ne nzuav wari ga nzuaim, Zisas mbe ndɨkndɨgi kaŋgiap, mbaram tara bisaŋ maneŋ ga nzuai, ana zav ana han thɨgi. ");
INSERT INTO geb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ana mbaram khaŋ mbe nzuai, “Guma the na zɨn khaŋ muuŋgi tara then kurarga, ana vhɨra nan kurigi. Guma the nan kurarga, ana vhɨra nara kurigi fhuvara. Ana vhɨra mba na sharigi nen kurigi. Guma nde rɨgar wo mbevav zɨ ki fhu, ana nde rɨgar zɨ ki.” ");
INSERT INTO geb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Zisas mba kamen mbe nzuaim, Zon mbaram khaŋ ana nzuai, “Guman Rum, nza guma mbe garim, ana ndu zɨn panan ŋiniŋgi mbatɨgi ga vharvharigi. Nza khueŋ nzuav ana thɨvi. Ana nza phorga rui ne fhuvara.” ");
INSERT INTO geb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Zisas mbaram khaŋ ana nzuai, “Ana thɨvɨ thari. Guma the panan nde kegi fhu, ana nden kɨvntok ma.” ");
INSERT INTO geb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Zisas Fhe Bakɨme taagip ana ndigip Hevenan naanga tuk han mbarigim, ana ndɨkndɨk bavira mbov Zerusareman nan za mbui. ");
INSERT INTO geb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ana nan zav, ana fharav gumgi mbari ga sarigim, mbe fhara ana nɨma tɨga ana suaŋv bigi bevahɨr zav ndagi. Mbe nda vov, Samaria ŋgu mbe vugap, ana nzuav bigi bevahɨr zav mbui. ");
INSERT INTO geb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mbe maaŋ ana nzuav bigi bevahɨr zav mbuim, mba ŋgun ki gumgi, mbe wo ŋgun Zisas thɨvigi, mbe ana vuzvugi fhuvara. Mbe thav khaŋ nzuai, “Zisas khaŋ zi fhuvara, ana Zerusareman ndai.” ");
INSERT INTO geb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mba Samarian ki gumgi, mbe mba tɨvar Zisas ga muuŋgim, mba Zisas phorga rui guma phunini, Zems gum Zon, mani mba tɨva gangiap kha nzambaran Zisas ga muuŋgi, “Guman Rum, ndu nza vuzvugirim, nza Hevenan Fhe Bakɨmen kamɨrim, ana vhava sararim, ana zɨrɨv kha gumgi shigirim, mbe vhɨzgirga?” ");
INSERT INTO geb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Mani ne nzuaim, Zisas dorga mani garav, mani ga vhegap, mbe maaŋ thav, harigi ŋgun vui. ");
INSERT INTO geb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Zisas maaŋ thav harigi ŋgun vui tuav thɨga vuim, guma mbe khaŋ ana nzuai, “Gu ndu phorgɨv ndu mba vui ŋani, gu zam ntan rurga.” ");
INSERT INTO geb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ana maaŋ nzuaim, Zisas mbaram ana ŋgarkarav khaŋ ana nzuai, “Ruaŋruaŋgi feiŋ, nta kui thoori ki, kha vun gaa rui korigi, nta vhɨra kui khoni ki. Kha Fhe Bakɨme Guma Guar, ana thogɨp wo pana ndim tɨgɨrga ŋana thueŋ ki fhuvara.” ");
INSERT INTO geb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Zisas maaŋ mba guma ga nzuav, mbaram khaŋ harigi guma ga nzuai, “Ena, ndu zɨ na phorgɨ ŋka rurga.” Ana nen mba guma ga nzuaim, mba guma ana ŋgarkarav khaŋ ana nzuai, “Guman Rum, ndu fharav na khɨrarim, gu ŋgɨ wo ndia ganɨv, ana ndi mbogar tɨgɨp, za zɨv ndu phorgɨ rurga.” ");
INSERT INTO geb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ana ne nzuaim, Zisas khaŋ ana nzuai, “Mba vhɨzgi fara muuŋgia ki gumgi, mbe ŋaar ki fhu. Mbe mbar mba vhɨzi gumgi ndiv, mbogir rɨgɨ. Ndu zɨv Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga bunin vhuuiŋ bun gumgi gu mbigi ga suaŋv ru.” ");
INSERT INTO geb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Zisas ne mba guma ga nzuaim, Guma mbe hɨgap khaŋ ana nzuai, “Guman Rum, gu ndu phorgɨ rurga. Ndu fharav na khɨrarim, gu ŋgɨv, wo ndia gum niamuuŋ, won fegutari ganɨv, mben harin suigip, zɨv, ndu phorgɨ rurga.” ");
INSERT INTO geb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mba guma ne nzuaim, Zisas mbaram ana ŋgarkarav khaŋ ana nzuai, “Guma na phorgɨ rur zav, na zɨn zav, ana zazera kɨsfɨga zɨ gari guma, mba guma Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga ŋaarar muuŋgirga tuktɨgi fhu.” ");
INSERT INTO geb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Zisas zumgum harigi 72 gumgi farasegap, mbe sarigim, mbe ana nɨma tɨgap fharav vegi. Ana mbe sasarigim, mbe phuni phuni wari tɨgap vui. Ana mbe sarigim, mbe fharav ana mba ŋgɨrga ŋgui bakɨvi gum ŋgui ntogivige, mbe zam ntan vui. ");
INSERT INTO geb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ana mbe sarav khaŋ mbe nzuai, “Mban vhɨrvera gɨvav mɨnin ki. Mba mba ndirga ŋaara gumgi vhɨrkɨvgi fhuvara. Gu maaŋ muuŋgiap nde nzuai, nde mba mɨni namkama phorgɨ suaŋrim, ana ŋaara gumgi vhɨrve ga sararim, mbe ana mɨnin ŋgɨp, ana mba ndi phogir vhori. ");
INSERT INTO geb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Nde na mbarara. Nde ŋgɨri, gu nde sarigim, nde sipsivi ŋgugi fara muuŋgiap ruaŋruaŋgi feiŋ rɨgar vui. ");
INSERT INTO geb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nde ŋgɨp, ŋkɨɨa ki thar thige, o mpaa thar thige rugɨ thari, nde vhɨra ŋkari shari thaveni ndi thari. Nde vhɨra ŋgip, tuavar guma the gangip, ‘manera’ gum ‘ŋkotuguraagen’ anan nɨɨŋ thari. ");
INSERT INTO geb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nde maaŋ muuŋgip, ŋgɨp, ŋgu then ŋgɨgɨp, nde phena the vhen ŋgirɨ saŋv, nde fhara khaŋ mba phenan ki ntɨɨri ga suaŋri, ‘Nde kha phena vhen ki ntɨɨri, Fhe Bakɨme ndava mɨɨtɨk nde phorgɨ ki.’ ");
INSERT INTO geb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nde maaŋ mba phenan ki ntɨɨri ga suanga, mba phenan ki guma the Fhe Bakɨme ndava mɨɨtɨk ana phorgɨ kɨrga, ana nde nzuai kameŋ ndigirga. Maaŋ muuŋgi guma the mba phenan ki fhu, nde mba nzuai kameŋ, ne taagip ndera zɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nde maaŋ muuŋgip phena then ŋgegɨp, nde mba phenara kɨri. Mba phenan ki ntɨɨri nde ndɨɨi mba gum mbɨ, nde ntara mbɨri. Nde kaŋgi, guma ŋgari, ana won vheza ndirga. Nde fhura tamtam phenin ŋkuu thari. ");
INSERT INTO geb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Nde ŋgɨp ŋgu bakɨ then ŋgɨgɨrim, mbe nde ndigi ŋgɨp wari wo phena then ŋgɨgɨp, mban nden nɨɨŋrim, nde mbɨri. ");
INSERT INTO geb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nde mba ŋgun kɨv, ana ki rɨɨi gumgi, nde mben kurkurav, mben rɨmrɨɨr muuŋrim, nta vhɨzɨri. Nde khaŋ mbe suaŋri, ‘Fhe Bakɨme won gumgi gu mbigi ganɨrim, mbe ana piin kɨrga tuk nden han mbarigi.’ ");
INSERT INTO geb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nde maaŋ muuŋgip ŋgɨp ŋgu bakɨ then ŋgɨgɨrim, mbe nde vuzvugiap nden ndikndigi fhu, nde ŋgɨv mba ŋgun tuavra thɨgɨp khaŋ mbe suaŋri, ");
INSERT INTO geb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nden ŋgun vherɨn nzan ŋkari phoogim, nza nta vherɨna pɨzi. Nde khaŋ muuŋgip gangip kaŋgiri, nde tɨvar vhuun nza muuŋgi fhuvara.’ Nde vhɨra ndɨkndɨga vhuuŋra muuŋv wari kɨri. Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga tuk han mbarigi.” ");
INSERT INTO geb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Zisas mba bunin mbe nzuav khaŋ mbe nzuai, “Gu guigira nde nzuai, Fhe Bakɨme zumgum kha nuianan ki gumgi gu mbigi muuŋgi tɨvi mbatɨgi ga suaŋv mbe suanga tuk hɨgɨrga. Mba tɨvar nde muuŋgi ŋgun ki gumgi gu mbigi, mbe ndirga simtɨgi, nta guigira mba Sodoman kegi gumgi gu mbigi ndirga simtɨgi kambararga.” ");
INSERT INTO geb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Zisas mba bunin mbe nzua vov, wom khuen mbe nzuai, “Nde mba Korasinan ŋgu bakɨmen ki gumgi gu mbigi, nde guigira simtɨga bakɨme ndirga. Nde mba Betsaidan ki gumgi gu mbigi, nde vhɨra guigira simtɨga bakɨme ndirga. Nde kha ŋguni, gu fhum nden rɨgar kav mirikori ga muuŋgi. Guma the Taia gum Saidonan kav, gu mba nde rɨgar kav mirikori ga muuŋgi tɨva muuŋgi kake, gu kaŋgi, Taia gum Saidonan ki gumgi gu mbigi, mbe fhum ndavi domdorge. Mbe maaŋ muuŋgiap ndavi domdorgiap, mbe wari wo muuŋgi tɨvi mbatɨgi kora muuŋgiap, shagi gori shargiap vherɨna piigiap kae. ");
INSERT INTO geb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nde kha Korasin gum Betsaidan ki gumgi gu mbigi, Fhe Bakɨme zumgum kha gumgi gu mbigi tɨvi mbatɨgi ga suaŋv mbe suanga tugar, nde ndirga simtɨgi, nta guigira Taia gum Saidonan kegi gumgi gu mbigi ndirga simtɨgi kambararga. ");
INSERT INTO geb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nde kha Kaperneaman ki gumgi gu mbigi, nde khueŋ ndɨkndɨgi thi? Mba tugen Fhe Bakɨme nde suirav nde vun fegɨrim, nde za kha buiv shɨ guarara phorgirga thi? Fhuvara! Nde Fhe Bakɨme guigira nde mbevarim, nde za kha nuiana khɨna guarara ŋgirɨp, vhɨzgi gumgi ki ŋgun ŋgirgɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Zisas kha bunin mbe nzua vov khaŋ mba wo farasegi 72 ŋaara gumgi ga nzuai, “Guma nde nzuai buni mbararagi, ana na buni mbararagi. Guma nde nzuai buni ana kɨr nta segi, ana kɨr na buni ga segi. Mba guma kɨr na buni ga segi, ana kɨr nara segi fhuvara, ana vhɨra kɨr Fhe Bakɨme segi. Fhe Bakɨme nduara na sarigi gu zɨgi.” ");
INSERT INTO geb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Zisas mba farasegi 72 ŋaara gumgi, mbe vega kegap, taagia ndikndiga mbatɨga mbuav wari zi. Mbe zegap khaŋ Zisas ga nzuai, “Guman Rum, nza ndu zɨn panan bigi vhɨrve ga mbuav, nza vhɨra ndu zɨn panan ŋiniŋgi mbatɨgi ga nzuaim, nta nza buni mbararav nta zɨn vui.” ");
INSERT INTO geb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mbe ne nzuaim, Zisas mbe ŋgarkarav khaŋ mbe nzuai, “Gu Satan garim, ana Hevenan kegap, tor vhekvhegi fara muuŋgiap kɨgira nɨɨaŋ ndarigi. ");
INSERT INTO geb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nde na mbarara! Gu ŋkasŋkan nde nɨɨŋgi. Nde mba kurigi mbatɨgi gum vhezemiŋ, nde nta thipogɨrga, nta nden farfagirga tuktɨgi fhuvara. Nden pana guma Satan, nde vhɨra za ana ŋkasŋka mbevav, nden ŋkasŋka guigira ana kambararga. Kha bigɨn the nden farfagirga tuktɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nde vhɨra khueŋ suaŋv ndikndigɨ thari, ‘Nza nzuaim, ŋiniŋgi mbatɨgi nza nzuai buni mbararav nta zɨn vui.’ Fhuvara. Nde khueŋ suaŋv ndikndigɨri, Fhe Bakɨme Hevenan nde zɨri khergi.” ");
INSERT INTO geb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mba tugen Fhe Bakɨme Ŋina Ŋaar Zisas ndava khavgim, ana Fhe Bakɨme ndikndigap khaŋ ana nzuai, “O, Fhe, ndu kha nuian gum buiva gari Guma Bakɨme ma. Gu ne nzuav ndu zɨ ndi vun kuamkuagi. Ndu khaŋ muuŋgi ne nzuav, ndu kha bigin kha ndɨkndɨgi ga mbui gumgi vhagi. Mbe kha ndɨkndɨgi ga mbui. Mbe ndɨkndɨgi vhuuiŋ kaŋgiap ndɨkndɨgi vhuuiŋ ga mbui gumgi ma. Ndu ntan mba tarire ndɨkndɨgi ndɨkndɨga mbui gumgi, ndu ntan mbe khɨvigi. Ahaŋ, ne nzerara, Fhe Bakɨme, ndu wo vuzvuga zɨn vov maaŋ muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Zisas mba bunin ana nzuav, wom khaŋ mbe nzuai, “Na Fhe Bakɨme mba bigin za na farve khɨngi. Guma the tuituigiap khueŋ kaŋgi fhuvara, gu ana Kam ma. Fhe Bakɨme nduara ana kaŋgi. Fhe Bakɨme vhɨra, guma the ana kaŋgi fhuvara, anan Kam nduara ana kaŋgi. Ana ana kaŋgiap, ana anan mba khɨvɨ zav farasarigi gumgi, ana anan mbe khɨvigi, mbe vhɨra ana kaŋgi.” ");
INSERT INTO geb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Zisas mba bunin mbe suaŋgiap, dorgap, wo phorga rui gumgi garim, mbe nduarira kim, ana khaŋ mbe nzuai, “Nde kha gari bigi, nde phorga nta gari gumgi gu mbigi, mbe ndikndigɨri. ");
INSERT INTO geb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Gu guigira khar nde nzuai, fhum Fhe Bakɨme kamthooŋ gumgir vhɨrve gum ŋgui bakɨvi gari gumgir pani vhɨrve, mbe nde khar gari bigi ganɨngeŋ vuzvugi. Mbe nta gangi fhuvara. Mbe vhɨra nde khar mbararagi buni, mbe nta mbararageŋ vuzvugi. Mbe nta mbararagi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tuga mbe mba guigira Zudaiŋ tɨvir vhuuiŋ kaŋgi guma mbe khavgia thɨgap, Zisasan mparav, anan nzarigi. Ana khaŋ ana nzuai, “Guman Rum, gu ramgip zazera mbara muuŋgia ki bɨɨŋbɨɨŋ ndigirie?” ");
INSERT INTO geb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ana ne nzuaim, Zisas ana ŋgarkarav ana nzarigi, “Mba Fhe Bakɨme nde nzuav tɨgi tɨvi, ana ntan Moses ga nɨɨŋgi, nta ram nzuai? Ndu nta garim, nta ram nzuai?” ");
INSERT INTO geb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ana Zisas ŋgarkarav khaŋ nzuai, “Mba tɨvi khaŋ nzuai, ‘Fhe Bakɨme, ana nduara nza Fhe Bakɨme ma. Ndu guigira wo ndavar anan nɨɨŋgip, ana vuzvugip, wo tum gum ndɨkndɨk gum ŋkasŋkan anan nɨɨŋgiri. Ndu wo vuzvugi tɨvara, ndu won kɨvntoga vuzvugiri.’ ” ");
INSERT INTO geb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ana maaŋ nzuaim, Zisas ana ŋgarkarav khaŋ ana nzuai, “Ena, ndu nzerara mbar nzuai. Ndu mba tɨvara muuŋv, ndu zazera mbara muuŋgia ki bɨɨŋbɨɨŋ ndigirga.” ");
INSERT INTO geb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Zisas nen ana nzuaim, mba guigira Zudaiŋ tɨvi vhuuiŋ kaŋgi guma, ana khuen Zisas ga ndɨkndɨgi. Ana kha ndɨkndɨgar nan muuŋ thari, gu ndɨkndɨga vhuuŋ ki fhuvara. Mba guigira Zudaiŋ tɨvi vhuuiŋ kaŋgi guma mba ndɨkndɨgar Zisas ga mbuav, kha nzambaren ana muuŋgi, “Maaŋgi kha kameŋ khaŋ nzuai, nan kɨvntogi? Nan kɨvntogi, mbe theiŋ?” ");
INSERT INTO geb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ana mba nzambaren Zisas ga muuŋgim, Zisas ana ŋgarkarav kha bigen ana neŋgi, “Guma mbe Zerusareman kegap Zerikon veri. Ana verim, bigi kɨɨv gumgi shogi gumgi mbatɨgi, mbe zomzorgia kegap tuavar anan hegi. Mbe hegap, hor mbatɨgar ana muuŋgim, ana ŋama rimgim, mbe ana ndi tɨgap, ana shagi zorgiap, ana bigi kɨmgiap, wari regi. ");
INSERT INTO geb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mbe regim, Fhe Bakɨme rotu guma mbe, ana mba tuavra veri. Ana vera ana garim, ana rimge rɨgap kim, ana ana gangia thav, fhura ana ŋkɨɨa vugi. ");
INSERT INTO geb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ana vugim, Rivai guma mbe zi. Ana zav ana gangiap, ana vhɨra fhura ana ŋkɨɨa vugi. ");
INSERT INTO geb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Ana vugim, Samaria guma mbe zi. Ana zav mba guma rɨgap ki ŋanen hav, ana garav, guigira ana kora muuŋgi. ");
INSERT INTO geb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ana ana kora muuŋgiap, vov ana han vugap, mbaram wainan ana nzuu ruagiap, mbaram mporiiŋ ana nzuu ndogi. Ana ana nzuu ndogiap, mbaram ana suira vov won doŋkir fav, ana ndiga vui. Ana ana ndiga vov, mba ŋgui gumgi zav kui phena mbe tɨgap, ana gari. ");
INSERT INTO geb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ana mɨtimanera khavgiap, kɨma raraŋ mpuani faŋgiap, mba phena gari guma ga nɨɨŋgi. Ana nta faŋgiap, ana ndɨɨv khaŋ ana nzuai, ‘Ndu kha guma ganɨv, ndu ana suaŋv won ŋkɨɨa thari fusuegɨrga, gu taagip zɨv, gu ndu ŋkɨɨa ŋgarkararga.’ ” ");
INSERT INTO geb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Zisas mba bigen mba guigira Zudaiŋ tɨvi vhuuiŋ kaŋgi guma neŋgegap, mbaram anan nzarigi, “Ndu gu kha neŋgegi bigeŋ mbararagi. Maaŋgi guma kha guma phuni khegene rɨgar kha kɨɨi gumgi shogi guman kɨvntok?” ");
INSERT INTO geb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mba guigira Zudaiŋ tɨvi vhuuiŋ kaŋgi guma ana ŋgarkarav khaŋ ana nzuai, “Mba ana kora muuŋgi guma.” Ana maaŋ nzuaim, Zisas khaŋ ana nzuai, “Nzerara, ndu ŋgɨp mba tɨvara muuŋri.” ");
INSERT INTO geb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Zisas maaŋ kegap, khavgiap, wo phorga rui gumgir kov, mbe vui. Mbe vov ŋgu mben hɨgi. Mbe vov mba ŋgun hɨgim, mba ŋgun ki mbiga mbe, ana zɨ Marta, ana wo phenan kɨr zav Zisas khɨrigi. ");
INSERT INTO geb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Zisas vov Marta phenan kim, Marta biva Maria, ana zav Zisas haa perav, Zisas nzuai buni mbararagi. ");
INSERT INTO geb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ana Zisas buni mbararav kim, Marta Zisas buni mbarara zav mbuav, ana vhɨra mbe mbɨrga mba ndɨkndɨgap, nta mbuav kavtuigi. Ana kavtuigiap, mbaram zav khaŋ Zisas ga nzuai, “Guman Rum, ndu gu kavtuigi ne ndɨkndɨgi fhuve? Na bip na thav, zav khaŋ kim, gu nduara kha mba tuav kavtuigi. Ndu ana suaŋrim, ana zɨv, nan kurav mba turga.” ");
INSERT INTO geb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Marta nen Zisas ga nzuaim, Zisas ana ŋgarkarav khaŋ ana nzuai, “Ai, Marta, ndu bigi vhɨrve ga nzuav mbuav, ndɨkndɨgi vhɨrve ga mbuav ndava simgi. ");
INSERT INTO geb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","“Gu ndu nzuai, ndu ndɨkndɨgɨrga bigɨna bavira. Maria khar mba bigɨna ndir za mbui, ana guigira bigɨna vhuuŋ ma. Ana mba bigɨna vhuuŋ ndir saŋv muuŋrim gu thaŋ suaŋv ana thɨvɨrie?” ");
INSERT INTO geb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Raa mben Zisas ŋana muen kav Fhe Bakɨme phorga nzuai. Ana Fhe Bakɨme phorga suaŋgia thugim, ana phorga rui guma mbe vov khaŋ ana nzuai, “Guman Rum, ndu Zon Gumgi Ruai Guma fhum Fhe Bakɨme phorgɨ suangen wo phorga rui gumgi khɨvigi, khɨvan nzan muuŋ.” ");
INSERT INTO geb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ana ne nzuaim, Zisas mbaram khaŋ mbe nzuai, “Nde Fhe Bakɨme phorgɨ suaŋv khaŋ ana suaŋri. ‘O, Dara Bakɨme, nza bigɨn thueŋ suaŋv ndun zɨn farfarga tuktɨgi fhu, ndu zɨ ŋgaravra kɨrga. Ndu kha nuianan ki gumgi gu mbigi ganɨrim, mbe ndu piin kɨrga tuk guigira hɨgɨri. ");
INSERT INTO geb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ndu mba rari tugɨra tɨgɨv mban zazera nzan nɨɨŋri. ");
INSERT INTO geb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ndu nza muuŋgi tɨvi mbatɨgi, ndu nta vhɨzgip, nta ndɨkndɨk ŋangiri. Nza vhɨra harigi gumgi nza muuŋgi tɨvi mbatɨgi, nza vhɨra nta ndɨkndɨgi fhu. Ndu fhura nza ganɨrim, nzan panɨnga bigɨn thueŋ nzan hɨ thari.’ ” ");
INSERT INTO geb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Zisas mba kamen mbe suaŋgiap khaŋ mbe nzuai, “Nde the kɨvntok the kɨv, ana maaŋ muuŋgip maaŋ rɨgar ŋgɨv, khaŋ ana suanga. ‘Kɨvntok, ndu viktuma phuni khegenen nan kurari. ");
INSERT INTO geb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Gu khaŋ muuŋgiap ndun nzai, nan kɨvntoga mbe tuava mpeeŋmpeen kegap, zav nan hɨgim, gu ana kurmbɨrga mba ki fhu.’ ");
INSERT INTO geb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ana maaŋ ana suanga, anan kɨvntok wo phena vhen kɨv khaŋ ana suanga, ‘Ena, kha maaŋ rɨga furigim, gu thɨma puigap, kha tarir kov nza kui. Ndu thaŋ nzua ntige zi? Nde gurmaŋgip zɨri.’ Mba guman kɨvntok maaŋ ana nzuaim, ana vui fhu. Ana khaŋ thɨgav, anan nzai. ");
INSERT INTO geb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Gu guigira nde nzuai, mba phena namkam khavgirga, ana mba ana kɨvntok vuzvugi bigi, ana zam ntan anan nɨɨŋgirga. Ana khueŋ ndɨkndɨga mba bigin ana ndɨɨi fhuvara, ‘Ana nan kɨvntok ma.’ Fhuvara. Ana khaŋ muuŋgi ne nzuav, ana kɨvntok pim mba bigin ana nzaim, ana maaŋ muuŋgiap mba ana kɨvntok ana nzai bigi, ana zam ntan anan nɨɨŋgirga. ");
INSERT INTO geb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Gu guigira nde nzuai, nde bigɨn the suaŋv Fhe Bakɨme phorgɨv suaŋv ana nzanga, ana mba bigɨnan nden nɨɨnga. Nde bigɨn the suaŋv ganɨnga, Fhe Bakɨme nden kurarga, nde mba bigɨna gangirga. Nde bigɨn the suaŋv Fhe Bakɨmen kamɨnga, Fhe Bakɨme nde mbarararga. ");
INSERT INTO geb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mba Fhe Bakɨme phorga nzuav bigir anan nzai gumgi, mbe za bigi ndi. Mba bigi ga nzuav gari gumgi, mbe mba bigi gari. Mba bigi ga nzuav Fhe Bakɨmen kaai gumgi, Fhe Bakɨme mbe mbararagi. ");
INSERT INTO geb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Nde ntige khar ki ndegi, nde the fhum nden kama the mbɨgaman nden nzaim, nde mbɨgaman anan nɨɨŋ thav kurugan ana nɨɨŋgirie? ");
INSERT INTO geb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ee, ana tuara rerar ndun nzaim, ndu vhezemen ana nɨɨŋgirie? Fhuvara! ");
INSERT INTO geb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nde tɨvi mbatɨgi ga mbui ndegi ma. Nde maaŋ mbuav, nde guigira bigir vhuuiŋra wari won tarir nɨɨngeŋ kaŋgi. Nde mba tɨvar vhuun wari won tari ga mbui. Nde guigira khueŋ kaŋgiri, nden Ndia Bakɨme, ana mbu Hevenan ki, ana guigira wo Ŋina Ŋaarar ana phorga nzuav anan nzai gumgir nɨɨngen ndikndigi.” ");
INSERT INTO geb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Raa mben Zisas guma mbe tɨn ŋina mbatɨga mbe vharigi. Mba guma thɨni mpɨrigi ŋina mbatɨk ana vhen ndav, ana vhen kav, ana thɨni mpɨrigim, ana buni nzuai fhu. Zisas mbaram mba guma tɨn mba ŋina mbatɨga vharigim, mba ŋina mbatɨk ana thav kɨrar hɨgim, mba guma buni nzuai. Ana buni nzuaim, mba gumgi gum mbigi ana gangiap, mbe ŋgava mbatɨga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mbe ŋgava mbatɨga muuŋgiap, mbe mbari khaŋ nzuai, “Ana Bersebur ŋkasŋkan panan kha ŋiniŋgi mbatɨgi ga vharvharigi. Bersebur, ana ŋiniŋgi mbatɨgir guman pan ma.” ");
INSERT INTO geb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mbe mba buni nzuav, gumgi mbari anan mparav khaŋ ana nzuai, “Ndu Hevenan ki ŋkasŋkar mirikor then muuŋ.” ");
INSERT INTO geb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mbe mba ndɨkndɨgi ga mbuim, Zisas mbe ndɨkndɨgi kaŋgiap, khaŋ mbe nzuai, “Nde ŋgu bakɨ the ganɨrim, mba ŋgu rɨgɨra wari shɨrav, wari phorgɨ shogɨrga, mba ŋgu za vhɨzgirga. Nde vhɨra ganɨ ndava bavira, mbe wari shɨrav wari shogɨrga, mba ndav za vhɨzgirga. ");
INSERT INTO geb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satan, vhɨra anan ŋaara gumgi, mbe rɨgɨra wari shɨrav wari shogɨrga, ana ram muuŋgip ŋkasŋkagip won ŋaari gangirie? Gu khaŋ muuŋgia tɨga nde nzuai, ne khaŋ muuŋgi. Nde khaŋ na nzuai, ‘Ndu Bersebur ŋkasŋkan panan ŋgari.’ ");
INSERT INTO geb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nde nen na nzuai, gu guigira maaŋ muuŋgiap Bersebur ŋkasŋkan panan ŋgarɨrga. The ŋkasŋkan nden kaa gumgi ga nɨɨŋgim, mbe mba ŋkasŋkar panan ŋiniŋgi mbatɨgi ga vharvharigi? Nde wari won kaa gumgira ganɨv kaŋgiri, nde mba nzuai buni, nta nzerigi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Fhe Bakɨme maaŋ muuŋgip ŋkasŋkan na nɨɨŋgim, gu kha ŋiniŋgi mbatɨgi ga vharvhararim, nde kaŋgiri, Fhe Bakɨme ntige wo gumgi gu mbigi ganɨnga, mbe ana piin kɨrga tuk nden hɨgi. ");
INSERT INTO geb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nde mbarara. Maaŋ muuŋgip guman ŋkasŋka the, ana won ntara bigi bevahegɨp, kɨv wo phen ganɨnga, ana phenan ki bigi, nta za nzerara kɨrga. ");
INSERT INTO geb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ana maaŋ muuŋgip kɨrga, guman ŋkasŋka guarara zɨv ana phorgɨv shogɨrga, mba guma guigira ana kambarav, ana tɨn ana mba ŋkasŋkagiap kav ntari ga mbui bigi, ana nta ndigip ntan harigi gumgir nɨɨŋgirga. ");
INSERT INTO geb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Guma, ana nan kɨvntok fhuv, ana nan pana guma ma. Guma nan kurav kha gumgi gu mbigi fugfugi fhu, ana mbe zɨtɨgi, mbe rav tamtam vui.” ");
INSERT INTO geb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Zisas mba bunin mbe nzua vov wom khaŋ mbe nzuai, “Ŋina mbatɨk, ana guma thav kɨrar hɨgi. Ana hɨga vov, gumgi ki fhuv ŋanin vov, vhuksurga ŋani ndi gari. Ana maaŋ kɨv vhuksurga ŋani ndi ganɨvra thav khaŋ suanga, ‘Gu taagi ŋgɨv fhum wo kegi phenara kɨrga.’ ");
INSERT INTO geb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ana ne suaŋgip taagi zɨrga. Ana zɨv, mba phena ganɨnga, mbe ana khɨrav, ana biav, ana muuŋgim, ana guigira ŋgarigim, mbe mba phenan ki bigi, mbe nta ndi tuituigia vhuigi. ");
INSERT INTO geb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ana mba phena gangip, taagi ŋgɨp harigi harathɨgi ŋiniŋgi mbatɨgi guarira, ana mbe kov zɨrga. Ana mben kov zɨv, mbe mba phena vhen ŋgirgɨp anan kɨrga. Mbe ŋgirgɨp, mba guman vhen kɨrga, mba guma mba ŋina mbatɨk fharav nduara ana vhen ndav ana vhen kim, ana kɨrɨ tɨvi, nta pim mbatɨgi fhuvara. Ana ntigem mba harigi harathɨgi ŋiniŋgi mbatɨgi guarira, mbe za mba fhum kegi ne phorga anan vhen ndagi. Mba guma, ana ntigem, ana kɨrɨ tɨvi guigira za mbatɨgirga.” ");
INSERT INTO geb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Zisas mba bunin mbe nzuav kim, mba gumgi gu mbigi vhɨrve rɨgar mbiga mbe kama bakɨme rugav khaŋ nzuai, “Ndu tegap tan ndu nɨɨŋgi mbik, Fhe Bakɨme ndɨkndɨga vhuun anan muuŋri.” ");
INSERT INTO geb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ana ne nzuaim, Zisas ana ŋgarkarav khaŋ nzuai, “Nza khaŋ nzuai, ne guigira nzerigi, ‘Mba Fhe Bakɨme buni mbararav nta zɨn vui gumgi gu mbigi, Fhe Bakɨme ndɨkndɨga vhuun mben muuŋri.’ ” ");
INSERT INTO geb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Zisas maaŋ kav mba bunin mbe nzuaim, gumgi gu mbigi vhɨrve mbar kav, ana han zav ki. Mbe ana han zav guigira vhɨrkɨvgim, Zisas khaŋ mbe nzuai, “Nde ntige kha tugen ki gumgi gu mbigi, nde tɨvi mbatɨgi ga mbui gumgi gu mbigi ma. Nde ntigem, mirikor then muun saŋv suanga, mirikor the ntige nden hɨgɨrga tuktɨgi fhuvara. Nde zam Zonan hɨgi mirikor kaŋgi, mba mirikor, ana tugɨra. ");
INSERT INTO geb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Fhum Zonan hɨgi mirikor, ana Fhe Bakɨme Ninivan ki gumgi gu mbigi khɨvigi bigeŋ ma. Ntigem mbara muuŋgi, Fhe Bakɨme Guma Guar, ana ntige kha tugen hi gumgi gu mbigi khɨvi bigeŋ ma. ");
INSERT INTO geb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Zumgum, Fhe Bakɨme mba sarigi tugar, ana za kha nuianan ki gumgi gu mbigi muuŋgi tɨvi mbatɨgi ga suaŋv mbe suanga tugar, mba saut fhain ŋgui gari mbigar pana kuin, ana hɨv, Fhe Bakɨme nɨma thɨgɨv, ana kha tugen kav tɨvi mbatɨgi ga muuŋgi gumgi gu mbigi, ana mbe muuŋgi tɨvi mbatɨgi bun suanga. Mba kuin, ana za kha nuian vhɨzi tɨva guarara ki mbik ma. Ana zɨv, Soromon won ndɨkndɨgi vhuuiŋ, ana nta bun suaŋrim, ana nta mbarararga. Ntigem, vhɨra guma mbe nde rɨgar khar ki, mba guma, ana guigira Soromon kambarigi. ");
INSERT INTO geb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mba tugen Fhe Bakɨme kha nuianan ki gumgi gu mbigi muuŋgi tɨvi mbatɨgi ga suaŋv mbe suanga. Mba Ninivan ki gumgi gu mbigi, mbe mba tugen, mbe Fhe Bakɨme nɨma thivgip, mbe ntige kha tugen kha nuianan ki gumgi gu mbigi muuŋgi tɨvi mbatɨgi bun suanga. Mba Ninivan ki gumgi gu mbigi, mbe khaŋ muuŋgiap, mbe Zona vov Ninivan vugap, Fhe Bakɨme bunin vhuuin mbe nzuaim, mbe mba buni mbararav ndavi domdorgi. Ntigem vhɨra, guma mbe nde rɨgar khar ki, mba guma, ana guigira Zona kambarigi.” ");
INSERT INTO geb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Guma the fhum rama durav, ana ndi zorgi fhuvara. Ana vhɨra ana durav, ana ndi thuun piiaŋ rugi fhuvara. Ana ana durav, ana ndi hiiŋra ntorgim, gumgi zav ana vhava ŋaara gari. ");
INSERT INTO geb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ndun rɨmani, ni ndun ram ma. Ndun rɨmani nzerigi, ndu vhava ŋaarar ki guma ma. Ndun rɨmani mbatɨgi, ndu gɨngɨnan ki guma ma. ");
INSERT INTO geb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Maaŋ muuŋgiap, ndu tuituigira wo gangiri, mba ndun ki vhava ŋaar shiav ki o, ndu gɨngɨnara ki. ");
INSERT INTO geb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ndu maaŋ muuŋgiap ndu za vhava ŋaarar ki, ndu thaneŋ gɨngɨnan ki fhu. Ndu za vhava ŋaarara ki, ne khaŋ muuŋgi, mbe rama bakɨme durigim, ana shim, ana vhava ŋaara bakɨme ndu shɨrigim, ndu ki. ");
INSERT INTO geb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Zisas mba bunin mba gumgi gu mbigi ga suaŋgia thugim, Fherasi guma mbe wo phenan ŋgɨv wo phorgɨv mbɨr zav Zisasan nzarigi. Zisas vov ana phenan vugap, ana phorgɨv mbɨr zav, vo mba pi kaa ga perigi. ");
INSERT INTO geb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ana perav, mbe pav, mba Fherasi guma Zisas garim, ana fharav wo fari ruagiap, mba pi fhuvara. Ana maaŋ muuŋgiap, ana gangiap, ŋgava mbatɨga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ana ŋgava mbatɨga muuŋgim, Zisas mbaram khaŋ ana nzuai, “Nde Fherasiŋ, nde ntigem, nde phara pi tha gum, mba pi thuuri, nde ntan kɨri ruai. Nden ndavi vheri guigira bigi kirpɨgav, tɨvi mbatɨgi ga mbui tɨvi guigira nden vheri givigi. ");
INSERT INTO geb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nde ŋanŋangi gumgi ma. Mba bigɨna muuŋgi guma, ana ana kɨra mbuav, ana vhɨra ana vhee muuŋgi. ");
INSERT INTO geb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nde mba vhen ki bigi, nde ntan mba bigi sosuagi gumgir nɨɨŋri. Nde maaŋ muuŋgirga, nde bigi za ŋgaravra kɨrga. ");
INSERT INTO geb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nde Fherasiŋ, nde guigira warir rɨvɨri. Nde kha tɨvi ga mbui. Nde mba Fhe Bakɨme, nde wo mɨnin mba gum mpampari won nɨɨn zav tɨgi tha, nde guigira mba tha zɨn vov, za mba bigi bisarire, nde zam nta shɨgav, Fhe Bakɨme won nɨɨn zav suaŋgi nderen ana ndɨɨi. Nde maaŋ mbuav Fhe Bakɨme bigi ndiv thɨgar maan za nzuai tɨvi vhuuiŋ gum ana vuzvugi tɨvi, nde zam nta thagi. Nde nta suirav, nta mbui, nde vhɨra ana mba nzuai tɨvi, nde zam ntan muunga, ne nzerarga. ");
INSERT INTO geb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Nde Fherasiŋ, nde vhɨra khueŋ suaŋ wari rɨvɨri. Nde kha tɨva mbui. Nde mba Fhe Bakɨme buni mbararagi phenin, nde mba gumgi nɨman, nde zɨ ki gumgi piigi mpirmpirɨgira pigir za vuzvugi. Nde vhɨra mba phogi ga vhui ŋanin ŋgɨrim, mba gumgi gu mbigi, mbe za nde ganɨv nden ndikndigɨrgeŋ vuzvugi. ");
INSERT INTO geb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Nde Fherasiŋ, nde vhɨra khueŋ suaŋv warir rɨvɨri. Nde mbe gumgi vhɨzgim, mbe mbe ndi mbogi ga rɨgi mbogi fara muuŋgi. Mbe mba gumgi ndi, mbogi ga rɨgiap, mbe phorin mbe mbogi thɨrir parigi fhu. Mba gumgi kav khuri. Mba gumgi gu mbigi ne kaŋgi fhuvara. Mbe fhura mbe mbogi tɨn mbur vuav khar zi. Mbe maaŋ mbuav, mbe Fhe Bakɨme nɨman nzaŋnzaŋgi.” ");
INSERT INTO geb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Zisas mba bunin mbe nzuav kim, mba guigira Zudaiŋ tɨvi kaŋgi guma mbe ana buni mbararav kav, ana ŋgarkarav khaŋ ana nzuai, “Guman Rum, ndu mba bunin mba Fherasiŋ ga nzuav, ndu vhɨra nza mbevigi.” ");
INSERT INTO geb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ana ne nzuaim, Zisas ana ŋgarkarav khaŋ ana nzuai, “Nde guigira Zudaiŋ tɨvi kaŋgi gumgi, nde warir rɨvɨri. Nde khaŋ mbui tɨvi ga mbui. Nde bigi simtɨgi, nde nta ndiav, ntan harigi gumgi phufui, mbe ntan simtɨgi ndiav, ntan kavtuigi. Mbe ntan simtɨgi ndim, nde thaneŋ mben kurav mba simtɨgi ndi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Nde vhɨra khueŋ muuŋgi ne suaŋv warir rɨvɨri. Nden nzɨgi fhum Fhe Bakɨmen kamthooŋ gumgi shogim, mbe vhɨzgim, mbe mbe ndim, mbogi ga rɨgim, nde ntige mbe mbogi kivav, pheni ga muuŋgiap, mbe bun nzuai. ");
INSERT INTO geb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nde mba tɨvi ga mbuav, mba tɨvir harigi gumgi khɨvav khaŋ mbe nzuai, ‘Nzan nzɨgi muuŋgi tɨvi, ne nzerigi.’ Nden nzɨgi mba Fhe Bakɨmen kamthooŋ gumgi shogim, mbe vhɨzgim, nde mben mbogir kivav pheni ga muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Fhe Bakɨme khaŋ muuŋgiap, ana won ndɨkndɨga vhuuaŋ muuŋgiap khaŋ nzuai, ‘Gu won kamthooŋ gumgi gum wo farasegi ŋaara gumgi ga sararim, mbe ŋgɨrga. Mbe ŋgɨrim, mbe thari shogɨp, thari shogɨrim, mbe vhɨzgirga.’ Ana maaŋ suaŋgiap, mbe sarigim, mbe zegi. ");
INSERT INTO geb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Maaŋ muuŋgiap, fhum Fhe Bakɨme fhara guarara kha nuiana muuŋgim, mba tugen kega zav ntige kha tugen, mbe mba Fhe Bakɨme kamthooŋ gumgi shogim, mbe vhɨzgi. Nde ntige kha tugen ki gumgi gu mbigi, nde mba simtɨgi ndirga. Mbe vɨzi nde ruarga. ");
INSERT INTO geb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Mbe fhum Aber shogim, ana vɨzɨn siasuagi tugen kegap zav, mbe Fhe Bakɨme nzuav shama mbui artar gum Fhe Bakɨme Phena kɨtɨgar Sekaraia shogim, ana vɨzɨn siasuagi tuge thɨgi. Mbe mba tugen Fhe Bakɨme kamthooŋ gumgi shogim, mbe vhɨzgi gumgi. Ahaŋ, gu guigira nde nzuai, nde ntige ki gumgi gu mbigi, nde vhɨra, nde mben kurav, mba gumgir mbogir kivav, pheni ga muuŋgi. Nde ne suaŋv ndera mben simtɨga ndirga. ");
INSERT INTO geb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Nde guigira Zudaiŋ tɨvi kaŋgi gumgi, nde khueŋ suaŋ guigira warir rɨvɨri. Nde Fhe Bakɨme ndɨkndɨgir vhuuiŋ ndirga tuav, nde guigira ana mpɨrigi. Nde mba ndɨkndɨgi vhuuiŋ ndi ŋgun ŋgɨrgeŋ thav, harigi gumgi gu mbigi, mbe mba ndɨkndɨgi vhuuiŋ ndi ŋgun ŋgir zav mbuim, nde mba tuava mpɨrigi.” ");
INSERT INTO geb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Zisas mba bunin mbe suaŋgia tugap, mba phena thav kɨrar hɨgi. Ana kɨrar hɨgim, mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi gum mba Fherasiŋ gumgi, mbe ana nzuav ndavi guigira mbe mbatɨgim, mbe mbarkɨrga nzambarir ana mbui. ");
INSERT INTO geb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Mbe khueŋ nzuav, ana guiguigap anan nzai, mbe ana suaŋv kɨrim, ana pham buna thuen mbe ŋgarkarav mbe suaŋgirim, mbe ne suaŋv ana ndi suaŋgir zav anan nzai. ");
INSERT INTO geb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mbe mba nzambarir Zisas ga mbuav kim, mbarkɨrga 1,000 gumgi gu mbigi, mbe siav Zisas ga suav, ana phok thɨgi. Mba gumgi gu mbigi guigira vhɨrkɨvgiap, mbe warira thiphogi. Mba gumgi gu mbigi guigira vhɨrkɨvgim, Zisas fharav kha kamen wo phorga rui gumgi ga nzuav, Zisas bigɨna mueŋ vhunama sav khaŋ mbe nzuai, “Nde tuituigira mba Fherasiŋ isa gangiri. Gu tuituigi ganɨnga ne nzuai ne khaŋ muuŋgi. Gu is guara nzuai fhuvara, gu mba mbe nde guiguigi tɨvi ga nzuai. ");
INSERT INTO geb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Gumgi mba vhagia mbui bigi, nta kɨrar hegɨrga. Mbe mba mooŋgia nzuai buni, nta vhɨra kɨrar hegɨrga. ");
INSERT INTO geb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Maaŋ muuŋgiap, nde mba maan gɨngɨnan zorga ka suaŋgi buni, mba buni raan gumgi gu mbigi nta mbarararga. Nde mba wari khuari ga rɨgap shɨɨŋshɨɨŋ karen wari ga nzuai buni, mbe zumgum kama bakɨmera nta suanga. Mba buni kha pheni shɨri kharav, vu guarara ŋgɨrim, mba gumgi gu mbigi, mbar kɨv nta mbarararga.” ");
INSERT INTO geb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Zisas mba bunin mbe nzua vov wom khaŋ mbe nzuai, “Nan kɨvntogi, gu nde nzuai, nde gumgir nde fhavira shogi nta vhɨzi gumgir rɨvɨ thari. Mbe wom harigi bigɨna then nden muuŋgirga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Gu ntigem nde rɨvɨrga guma bun nde suanga. Nde rimgirga zumgum nden ntuu fuv Her ga surga ŋkasŋka ki guma, nde ana rɨvɨri! Gu ana bun nde nzuai, nde ana rɨvɨri. ");
INSERT INTO geb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Nde khueŋ kaŋgiri, gumgi mbari meeŋthɨgi korigi bisaŋri mbarire, mbe kɨma hɨva phuanira nta vhezgi. Mbe mba vhezgi meeŋthɨgi korigi bisarire, Fhe Bakɨme ana mba kora bisaŋ thaneŋ, ana ne ndɨkndɨk ŋangirga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Gu guigira nde nzuai, Fhe Bakɨme za nden pani rɨgi ruemgiap ntan vhɨrve kaŋgi. Nde rɨvɨ thari. Ana nde ndɨkndɨgi ndɨkndɨk, ana korigi bisarire ga ndɨkndɨgi ndɨkndɨk kambarigi.” ");
INSERT INTO geb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Zisas mba bunin mbe nzua vov wom khaŋ mbe nzuai, “Gu nde nzuai, guma the khaŋ harigi gumgi ga suanga, ‘Gu Zisas bɨnan ki.’ Ana maaŋ suanga, Fhe Bakɨme Guma Guar, ana vhɨra khaŋ mba Fhe Bakɨme enseri ga suanga, ‘Khe na guma ma.’ ");
INSERT INTO geb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Maaŋ muuŋgip guma the khaŋ harigi gumgi ga suanga, ‘Gu Zisas bɨnan ki guma fhuvara.’ Ana maaŋ suanga, gu vhɨra khaŋ mba Fhe Bakɨme enseri ga suanga, ‘Ana na guma fhuvara.’ ");
INSERT INTO geb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Guma buni mbatɨgir Fhe Bakɨme Guma Guara suaŋgirga, Fhe Bakɨme mba guma ana suaŋgi buni mbatɨgi, ana nta vhɨzgip, nta ndɨkndɨk ŋangirga. Guma the maaŋ muuŋgip Fhe Bakɨmen Ŋina Ŋaara zɨn farfagirga, Fhe Bakɨme mba guma, ana Ŋina Ŋaara zɨn farfagi ne ndɨkndɨk ŋangirga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nde na zɨn vui ne suaŋv, mbe nde ndigi ŋgɨp, Fhe Bakɨme buni mbararagi phenin gumgi gum, mbe won ŋgui gari gumgir pani gum, gumgi ruu nɨman nde suaŋ mbe phorgɨp suaŋrim, nde wari ndi zaahɨv, mbe phorgɨp suanga buni ga suaŋ ndɨkndɨgi vhɨrver muuŋv, wari simɨ thari. ");
INSERT INTO geb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nde mba tugen Fhe Bakɨmen Ŋina Ŋaar, ana nduara ndɨkndɨgar nde nɨɨnga, nde mbe phorgɨ suanga.” ");
INSERT INTO geb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Zisas mba bunin mbe nzuav kim, guma mbe mba gumgi gu mbigi vhɨrve rɨgar kav khaŋ ana nzuai, “Guman Rum, na ndia rimgim, gu khueŋ vuzvugi, ndu nan kurav, nan fega suaŋrim, ana ŋka won ndia gari bigi, ana rɨgɨra nta shɨrav thari nan nɨɨnga.” ");
INSERT INTO geb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ana ne nzuaim, Zisas mbaram taagia ana nzarigi, “Ndu ram nzuai, the mba bigi ga suaŋv ŋko suan zav na ndi fagim, gu mba bigi ga suaŋv ŋko suaŋv nta shɨrav ŋkon nɨɨŋrie?” ");
INSERT INTO geb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ana mbaram khaŋ mbe nzuai, “Nde warir rɨvɨv tuituigira wari kɨri. Nde kha ndɨkndɨgir muuŋ thari, ‘Gu kha nuianan garav niihi bigi, gu zam nta ndigirga, gu nzerara kɨv, guigira ndikndigirga.’ Nde khaŋ suanga, nza bigi vhɨrve guarira ndirga. Nde mba bigi ndigirga, nde nzerara kɨv guigira ndikndigirga fhu.” ");
INSERT INTO geb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ana nen mbe nzuav, kha buneŋ vhunama dav mbe nzuai, “Ŋkɨɨ ki guma mbe mɨna bakɨme muuŋgim, ana mɨn guigira mba tegi. ");
INSERT INTO geb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ana kav, nduara kha ndɨkndɨgar wo mbui, ‘Gu ntige ram muuŋrie? Gu ntigem wo mba gum bigi ndi vhorga ŋan tuktɨgi fhu.’ ");
INSERT INTO geb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ana thav khaŋ nzuai, ‘Gu ntigem khaŋ muunga. Gu kha won mba ndi vhui pheni, gu nta phɨrgip, harigi pheni bakɨvir muuŋgip, gu won mba gum won bigir vhuuin ntan vhorga. ");
INSERT INTO geb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Gu maaŋ muuŋgip, gu ntige khaŋ wo suanga. Gu ntigem guigira mba gum bigi tuktɨgi. Gu ntigem mpari vhɨrvera vhuksuv fhura kɨrga. Gu fhura kɨv, zazera mbɨv ndikndigɨrga.’ ");
INSERT INTO geb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ana maaŋ wo nzuaim, Fhe Bakɨme khaŋ ana nzuai, ‘Ndu ŋanŋangi guma ma. Ndu ntige kha maaŋra rimgirga. Ndu rimgirim, ndu mba ndia wora nzua vhuigi mba gum bigir vhuuiŋ, the nta vuavi mbuiarie?’ ” ");
INSERT INTO geb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Zisas ne mbe nzuav vov khaŋ mbe nzuai, “Kha khesharigi tɨva mbuav bigi ndi warira phogi ga vhui gumgi, kha khesharigi tɨv mben hɨrga. Mbe maaŋ mbui, Fhe Bakɨme mbe garim, mbe ana rɨmani nɨman, mbe bigi sosuagi gumgi ma.” ");
INSERT INTO geb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Zisas mba bunin mbe suaŋgiap, mbaram khaŋ wo phorga rui gumgi ga nzuai, “Gu ntige khaŋ nde nzuai, nde wari won ntuura ndɨkndɨgɨp khaŋ wari ga suaŋ thari, ‘Nza thegir mbɨrie?’ Nde maaŋ wari ga suaŋ, thari. Nde vhɨra wari wo fhavi ga ndɨkndɨgɨp khaŋ wari ga suaŋ thari, ‘Nza thegi shagi sharɨrie?’ ");
INSERT INTO geb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nde mbara nzuav bɨɨŋbɨɨŋ ndiav ki fhuvara. Nde fhavi vhɨra, nta shagi ra nzuav nzerara ki fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nde kha vuaa ganɨv nta ndɨkndɨgɨ. Nta wari ga nzuav mban parav ki fhuvara. Nta vhɨra mba gum bigi ndiv vhorga pheni ki fhu. Nde ganɨ, Fhe Bakɨme, ana nduara mbe garav mban mbe ndɨɨi. Nde kha gumgi gu mbigi, nde Fhe Bakɨme nde ndɨkndɨgi ndɨkndɨk, ana guigira kha korigi kambarigi. ");
INSERT INTO geb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nde the won kɨrɨ tɨvi vhuuiŋ ga ndɨkndɨgɨp won bɨɨŋbɨɨŋa phevav thaneŋ tuga mpeeŋra kegɨrie? Ne mbugum tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nde maaŋ muuŋgirga, tuga tɨvaneŋra kegɨrga tuktɨgi fhuvara. Nde thaŋ nzuav harigi bigi vhɨrve ga ndɨkndɨgap nta nzua mbui? ");
INSERT INTO geb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Nde kha khira shivi ganɨ, nta ram muuŋgi hɨɨa muuŋgi? Nta vhɨra wari ga nzuav ŋaara mbatɨga mbui fhuvara. Nta vhɨra wari ga nzuav shagi ga mbui fhuvara. Gu guigira khar nde nzuai, Soromon fhum ŋgui gari guman pan ki, ana guigira shagi vhuuiŋra sharav, sɨɨn vhuuŋra mbui. Ana mba nzɨɨi sɨɨŋ, nta kha khira shivi nzɨɨi sɨɨŋ kambarigi fhuvara. Kha khira shivi nzɨɨi sɨɨŋ guigira ana mba nzɨɨi sɨɨŋ kambarigi. ");
INSERT INTO geb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nde maaŋ muuŋgiap kaŋgiri, Fhe Bakɨme mba tɨvar mba khira shivi gum vhazɨgi ga mbui. Nta khaŋ muuŋgi ntɨɨri ma. Nta ntige ki guma gurmaŋgip nta hɨzgip, nta fov vhava suegim, nta shigi. Mba khesharigi vhazɨgi gum khira shivi, nta zɨri ki fhuvara, Fhe Bakɨme mba tɨvar nta mbui. Na nde ram mbui khesharigi gumgi? Nde guigira Fhe Bakɨme khothɨgi ndɨkndɨgi guigira tivgi. Nde khueŋ kaŋgiri, Fhe Bakɨme nde wari wo fhavi sharɨrga sɨɨn vhɨra nden nɨɨnga. ");
INSERT INTO geb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nde maaŋ muuŋgiap nden ndɨkndɨgi fharav mba gum mbɨn kɨv, ni ga suaŋv ndɨkndɨgi vhɨrver muuŋ thari. ");
INSERT INTO geb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kha nuianan ki gumgi, mbe mba bigi ga nzuav ndɨkndɨgi vhɨrve ga mbuim, nde Ndia Bakɨme, ana nde kaŋgi, nde nta vuzvugi. ");
INSERT INTO geb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nde mba bigir ndɨkndɨgi mbevav, Fhe Bakɨme ndɨkndɨk ana piin kɨrim, ana nde gari guman pan kɨrga, nde mba ndir za mbui bigi, ana vhɨra ntan nden nɨɨnga.” ");
INSERT INTO geb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Zisas mba bunin mbe nzua vov wom khaŋ mbe nzuai, “Nde na bɨnan ki ntɨɨrire, nde rɨvɨ thari. Nde Ndia Bakɨme, ana suaŋgi, ana nde gari guman pan kɨv, ana wo gari bigi, ana ntan nden nɨɨngen ndikndigi. ");
INSERT INTO geb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nde wari wo bigi ndi maaŋrim, harigi gumgi nta vhezgirim, nde mba ŋkɨɨar bigi sosuagi gumgi nɨɨŋgiri. Nde mba ŋkɨɨar mben nɨɨŋgip, nde mba zazera mbara muuŋgiap ki ŋkɨɨa, nde nta ndiri. Nde nta ndiv, nde vhɨra Hevenan ki bigi vhuuiŋ, nde vhɨra nta ndiri. Kha ŋgu Heven, anan ki bigɨn the mbatɨgirga tuktɨgi fhuvara, vhɨra kɨɨi guma the mba bigɨn the kɨmgirga fhu, vhɨra baa gum suasuari bigɨn the gorgirga tuktɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mba ŋgun nden bigi vhuuiŋ anan ki, nden vuzvugi vhɨra anan ki.” ");
INSERT INTO geb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Zisas mba bunin mbe nzua vov khueŋ phorga mbe nzuai, “Nde shagi tɨvivige kegɨp, wari wo ŋaari bigi bevahegɨp, wari wo raan pooŋgip kɨri. ");
INSERT INTO geb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nde kha tɨvar muuŋgiri. Gumgi mbari, mbe wari won guma bakɨme rarga ki. Mben guma bakɨme man gu muuŋ, mani wani ga rɨgim, ana mba shama bakɨmen kegap taagia zim, mbe ana rarga ki. Ana zɨv ra tharim, mbe za ana ndi thɨma fhɨrgirga. ");
INSERT INTO geb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Maaŋ muuŋgip, mba guma bakɨme zɨv won ŋaara gumgi ganɨri, mbe ŋkuu thav anan rarga ki, ne nzerara. Gu guigira khar nde nzuai, mba ŋaara gumgir guma bakɨme, ana vhɨra shaa tɨvige kegɨp zɨv, won ŋaara gumgi ga suaŋrim, mbe ŋgɨp mba pi kaa ga pigirga, ana nduara zɨv mban mben nɨɨnga. ");
INSERT INTO geb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mba ŋaara gumgi vhɨra, mbe won guma bakɨme zɨrga tuk, mbe tuituigia ana kaŋgi fhuvara. Ana maaŋ muuŋgip maaŋ rɨgar mben hɨgɨrga thi? Ana fharigi tuari furim, ana mben hɨrga thi? Ana maaŋ muuŋgip zɨv, won ŋaara gumgi ganɨrim, mbe ŋkuu thav ana rargɨp kɨrga, ana zɨv mbe ganɨri, mba ŋaara gumgi, mbe ndikndigɨri. ");
INSERT INTO geb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Nde vhɨra khueŋ kaŋgiri. Maaŋ muuŋgip, guma the kɨɨma guma ana phena phɨrɨrga tuga kaŋgirga, ana mba kɨɨma guma, ana fhura ana ganɨrim, ana ana phena vhen ŋgirgɨrga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nde vhɨra ku thari, nde kɨv, ganɨv kɨri. Nde Fhe Bakɨme Guma Guar zɨrɨga tuk, nde ana kaŋgi fhuvara. Nde ana zɨrɨga tuga shemshegɨp mbur rɨgɨv kɨrim, ana hanera nden hɨgɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Zisas nen mbe nzuaim, Pita ana nzarigi, “Guma Bakɨme, ndu kha vhunama si kamen nzara nzuaire, o, ndu za kheiŋ ga nzuai?” ");
INSERT INTO geb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Pita mba nzambaren ana muuŋgim, Zisas ana ŋgarkarav khaŋ nzuai, “Ena, maaŋgi mpiiŋsɨk ana ndɨkndɨga vhuuŋ kav, ana wo gari guma bakɨme piin kav ŋaara vhuuŋra mbui? Mba khesharigi mpiiŋsɨk mba ŋaari gari guma bakɨme, ana ana ndi farga, ana ana ŋaari gumgi ganɨv, ana mba sarigi tugara, ana mban mbe ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mba khesharigi ŋaara mbui mpiiŋsɨk, ana ŋgarɨv kɨrim, ana guma bakɨme taagia zav ana garim, ana ndikndigɨri. ");
INSERT INTO geb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Gu guigira nde nzuai, mba khesharigi ŋaara mbui mpiiŋsɨk, ana gari guma bakɨme ana ndi farga, ana za ana ŋaari gu bigi ganɨnga. ");
INSERT INTO geb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mba mpiiŋsɨk maaŋ muuŋgip kɨv khaŋ suanga, ‘Ahaŋ, na gari guma bakɨme gura zɨgɨrie?’ Ana maaŋ suaŋgip wo gari guma bakɨmen ŋaara gumgi gum mbigi, ana mbe shogɨv mben muuŋv, mba gum phara havharir mbɨv, ŋanŋanɨv kɨrga. ");
INSERT INTO geb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ana maaŋ muuŋv kɨrga, ana wo gari guma bakɨme zɨrga tuga nzuav garav ki fhuvara. Ana vhɨra ana zɨrga tuga kaŋgi fhuvara. Ana maaŋ muuŋv kɨrim, ana gari guma bakɨme hanera ana hɨgɨp, ana gangip, ana guigira muumbara mbatɨgar ana muuŋv, ana ndim mba ana buni kaadogi gumgi ki ŋaneŋ khɨngirim, ana mbe phorgɨ kɨrga. ");
INSERT INTO geb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Nde khueŋ mbarara, ŋaara guma, ana wo gari guma bakɨme nzuai buni gum ana ndɨkndɨgi, ana nta kaŋgiap, ana nta zɨn vov, bigi thari ga mbui fhu, ana fhura ki. Mba khesharigi ŋaara guma, ana gari guma bakɨme hor mbatɨgar ana muuŋgirga. ");
INSERT INTO geb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Khaŋ muuŋgi ŋaara guma, ana wo gari guma bakɨme ndɨkndɨgi gum vuzvugi kaŋgi fhu, ana pham bigɨn thueŋ muuŋgip, ana ne suaŋv zaa ndirga. Ana gari guma bakɨme pim ana shogɨrga fhu. Guma bigi vhɨrve ndigi, ana bigi vhɨrvera ŋgarkararga. Fhe Bakɨme maaŋ muuŋgip bigi vhɨrvera guma the farve khɨngirga, ana bigi vhɨrvera ŋgarɨga suaŋv kamɨnga.” ");
INSERT INTO geb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Zisas mba bunin mbe nzua vov wom khaŋ mbe nzuai, “Gu vhavar kha nuiana sur zav zergi. Gu vhɨra khueŋ vuzvugi, mba vhav vhemkora khavgip fogɨp shirga. ");
INSERT INTO geb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Gu vhɨra harigi khesharigi ruarɨr muun zav zergi. Gu ntigem mba ruarɨ ga muuŋgi fhuvara, gu maaŋ muuŋgiap nan ndav guigira simgi. ");
INSERT INTO geb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nde khueŋ ndɨkndɨgi thi? Gu ndava mɨɨtɨga ndigap kha nuianan zergi thi? Fhuvara. Gu guigira nde nzuai, gu kha gumgi gu mbigi shɨgɨr zav zergi. ");
INSERT INTO geb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mba tɨv ntige kha tugen kɨv, vhɨra zumgum vhɨra kɨrga. Ntige kha tugivigen meeŋthɨgi gumgi, mbe wari tɨgɨp phena bavira kɨrga, mbe rɨgɨra wari shɨrav, phuni khegene panan phuni ga kegɨrga, phunini panan phuni khegene ga kegɨrga. ");
INSERT INTO geb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","“Mbe rɨgɨra wari shɨrav, ndia panan kama kegɨrga, kam panan ndia ga kegɨrga. Niamuuŋ panan wo kambiga kegɨrga, kambik panan wo niamuuŋ ga kegɨrga. Guma the niamuuŋ panan ana muuaŋ kegɨrga, mba guman muuŋ panan won manan niamuuŋ ga kegɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Zisas mba buni vhɨrver mbe nzua vov khaŋ mba gumgi gu mbigi vhɨrve ga nzuai, “Nde kha tɨva mbui, nde garim, buiva hurige mbu ra veri fhain hɨgi, nde khaŋ nzuai, ‘Mbok nzirga.’ Nde maaŋ nzuaim, mbok guigira nzi. ");
INSERT INTO geb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nde vhɨra gari bɨɨŋbɨɨŋ bakɨme saut fhain kega zim, nde khaŋ nzuai, ‘Ra ntigem guigira fogɨ shirga.’ Nde maaŋ nzuaim, ra guigira foga shi. ");
INSERT INTO geb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nde guigira bigi guiguigi gumgi ma. Nde kha nuian gum buivar hi bigi, nde guigira nta ganɨv nta heengeŋ kaŋgi. Nde ram muuŋgiap ntige kha tugen hi bigi, nde nta garav nta heenganain kakagi?” ");
INSERT INTO geb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Zisas wom khaŋ mbe nzuai, “Nde ram muuŋgiap nde nduarira tuituigia kha bigi garav ndɨkndɨga vhuun nta mbui fhu, maaŋgi tɨvi nta tɨvir vhuuiŋ? ");
INSERT INTO geb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ndu maaŋ muuŋgip ndun pana guma, ana ndu ndigip, ndu suaŋ bigi ndi thɨgɨra mbai guman han ŋgɨp ndu suaŋv suan saŋv ŋgɨri. Ndu mba tugen ŋko wani tɨgɨp, ana han ŋgɨp, ndu tuav sɨgen ŋko wani phorgɨ suaŋv mba bigeŋ ndi thɨgɨr mbarari. Ndu maaŋ muuŋgirga fhu, ana ndu ndim, mba bigi ndi thɨgɨra mbai guman farve khɨngirga, ana ndu ndim gɨɨtɨvi farve khɨngirim, mbe ndu ndim bɨna khɨngirga. ");
INSERT INTO geb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Gu guigira ndu nzuai, ndu bɨnara kɨvkɨv ndu mba mbe ŋgarka zav ndu suaŋgi ŋkɨɨa, ndu zam nta ŋgarkararga.” ");
INSERT INTO geb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Zisas Fhe Bakɨme buni vhuuin mba gumgi gu mbigi ga suaŋgia thugim, gumgi mbari maaŋ kav, mbe Gariri gumgir hɨgi bigen ana neŋgi. Mbe mba bigen ana neŋgap khaŋ ana nzuai, “Gariri gumgi mbari, mbe Fhe Bakɨme nzuav sɨgi shogav shama mbuav kim, Pairat won ntari ga mbui gɨɨtɨvi ga sarigim, mbe vov, mbe shogi, mbe vɨzi siav, mba Fhe Bakɨme nzuav shogi sɨgi vɨzi tɨ suagi.” ");
INSERT INTO geb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mbe maaŋ nzuaim, Zisas khaŋ mbe nzuai, “Nde ram mbui ndɨkndɨga mbui? Nde ndɨkndɨgi, mbe muuŋgi tɨvi mbatɨgi, mba harigi Gariri gumgi muuŋgi tɨvi mbatɨgi kambarigim, mbe nen vheza ndiav, mbe mba tɨva mbatɨgar mbe muuŋgire? ");
INSERT INTO geb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Gu guigira nde nzuai, Zakɨra fhuvara! Nde vhɨra nde ndavi domdorgirga fhu, mba tɨv vhɨra za nden hɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nde vhɨra mba fhum mba Siroaman mba phena bakɨme phɨrgia rav mba phɨk bavira sɨgarathɨgi gumgi shogim, mbe vhɨzgi. Nde kha ndɨkndɨgar mbe mbuire, mbe muuŋgi tɨvi mbatɨgi za kha Zerusareman ki gumgi muuŋgi tɨvi mbatɨgi kambarigi? ");
INSERT INTO geb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Zakɨra fhuvara! Gu guigira nde nzuai, nde vhɨra nde ndavi domdorgirga fhu, mba tɨv vhɨra za nden hɨgɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ana mbaram bigɨna mueŋ vhunama dav khaŋ mbe nzuai, “Guma mbe fik kha mbige ndim won wain mɨnan mpɨrigi. Ana ana mpɨrigim, ana vhuuŋgim, ana zumgum zav mba fik khagen vhɨgi korɨ zav niŋge gari. Ana zav niŋge garim, niŋge vhɨgi mbai fhu. ");
INSERT INTO geb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ana thav khaŋ mba wain mɨna gari guma ga nzuai, ‘Ai, gu mpari mpuveni khegntɨriven, gu zav kha fik khage garim, niŋge vɨga the mbarigi fhu, ndu niŋge kegɨ nɨɨ khɨnik! Niŋge thaŋ suaŋv fhura khaŋ kɨv, kha nuiana mba vhɨzɨrie?’ ");
INSERT INTO geb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ana ne nzuaim, mba ŋaara guma ana ŋgarkarav khaŋ ana nzuai, ‘Guma rum, ndu ntige ana kɨ thari, ndu rargɨri. Gu ntige kha mpari bavira mparav nuiana khov, ana degan vhov, tor daa buari ndi zɨv, ana dega suegɨp, ana ganɨnga. ");
INSERT INTO geb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ana mbu zɨn mpariven vhɨgi maanga thi, fhuv thi? Ana maaŋ muuŋgip vhɨgi maanga fhu, ndu ana kegɨri.’ ” ");
INSERT INTO geb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat raa mbevin Zisas vov Fhe Bakɨme buni mbararagi phena vhen vhergap, Fhe Bakɨmen buni vhuuin gumgi gu mbigi khɨvav mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mba gumgi gu mbigi rɨgar, ŋina mbatɨk mbe vhen ndav kɨr phɨrgerɨga rui rɨmrɨman nɨɨŋgi mbiga mbe, mbe phorga mba phena vhen ki. Mba ŋina mbatɨk mba rɨmrɨman ana nɨɨŋgim, ana mbara muuŋgiap kɨr phɨrgerɨga ruav kim, phɨk bavira sɨgarathɨgi mpari vhɨzgi. Ana ragia thɨgɨ ruigirga tuktɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Zisas ana gangiap, ana kamgim, ana ana han zim, ana khaŋ ana nzuai, “Ena, gu ntigem ndun rɨmrɨm vhɨzgi.” ");
INSERT INTO geb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ana maaŋ ana suaŋgiap, mbaram wo farven ana suirigi. Ana wo farven ana suigavra thagim, mba mbik vhemkora ragia thɨgap, Fhe Bakɨme zɨ ndim vun kuamkuagi. ");
INSERT INTO geb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Zisas Sabatar mba mbigar kurigi ne nzuav mba Fhe Bakɨme buni mbararagi phena gari guman pan ne nzuav guigira Zisas ga nzuav ndav shigap, khaŋ mba gumgi gu mbigi ga nzuai, “Nza ŋaari ga mbui rari mporathɨgi, nde mba raa then zɨv wari won rɨmrɨɨ vhɨzɨ. Nde thaŋ nzuav zav Sabatar mba ŋaara khavgi?” ");
INSERT INTO geb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ana maaŋ nzuaim, Zisas ana ŋgarkarav khaŋ ana nzuai, “Nde bigi guiguigi gumgi ma! Nde buni nzuav, nde mbui tɨvi mba buni zɨn vui fhuvara. Nde vhɨra Sabatar kha tɨvi ga mbui. Nde vov wari wo tor daa bɨnin vegap, nta thɨɨ fhɨrim, nta kɨrar him, nde ntan ko vuim, nta phara pi. ");
INSERT INTO geb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nde kha mbiga gari, ana harigi mbik fhuvara. Ana vhɨra Abrahaman shɨga mbiga mbe ma. Nde ana garim, Satan kha simtɨgar ana nɨɨŋgim, ana mba simtɨk ana kegim, ana ndiav kim, phɨk bavira sɨgarathɨgi mpari vhɨzgi. Gu maaŋ muuŋgip ana tɨn mba simtɨga gorɨ saŋv, gu Sabat ga suaŋv ana tɨn mba simtɨga gorɨrgeŋ tharie?” ");
INSERT INTO geb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ana ne nzuaim, mba panan ana kegi gumgi, mbe ne mbararagiap, guigira memɨra mbatɨga muuŋgi. Mbe nen mberim, mba gumgi gu mbigi za ana mbui bigir vhuuiŋ ga nzuav ndikndigi. ");
INSERT INTO geb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Zisas mba bunin mbe nzua vov wom mben nzarigi, “Fhe Bakɨme won gumgi gu mbigi ganɨrim, mbe ana piin kɨrga tɨv ram mbui khesharigi? Gu ana vhunama sɨv ram mbui suambarar nden muuŋrie? ");
INSERT INTO geb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ana kha mpamparan vhɨga fara muuŋgi. Mba mpampara zɨ khare, mastet. Guma mbe mastet vhɨga ndiga vov won mɨnan mpɨrigi. Ana zumgum kha fara muuŋgiap, vhuuŋgip, kɨvgiap, ŋgagi shɨgim, korigi zav ana ŋgagi ga piigi.” ");
INSERT INTO geb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Zisas nen mbe suaŋgiap wom mben nzarigi, “Fhe Bakɨme won gumgi gu mbigi ganɨrim, mbe ana piin kɨrga tɨv ram mbui khesharigi? Gu ana vhunama sɨv ram mbui suambarar nden muuŋrie? ");
INSERT INTO geb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ana is fara muuŋgi, mbiga mbe is ndigap parawa phorga digi. Ana nta digim, mba parawa zumgum kav vhuuŋgia ndagi.” ");
INSERT INTO geb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Zisas mba bunin mbe suaŋgia thugav, mbaram khavgia Zerusareman ndai. Ana ndav vov, mba ŋgui bakɨvi gum ŋgui bisarire shɨgav ndav, Fhe Bakɨme buni vhuuin mbe khɨvav mbe nzuav ndai. ");
INSERT INTO geb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ana mba bunin mbe nzuav ndaim, guma mbe ana nzarigi, “Guma Bakɨme, Fhe Bakɨme gumgi gu mbigi vhɨrve, ana taagi mbe ndigirga fhup thi?” Ana ana nzarigim, ana khaŋ mbe nzuai, ");
INSERT INTO geb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Gu khar za nde nzuai, nde nduarira ŋkasŋkagip khaŋ tɨgɨp, nde mba tuav bisaneŋ thɨgɨp ŋgɨp mba ŋgun vhen ŋgirgɨrga. Gu nde nzuai, gumgi gu mbigi vhɨrvera, mbe mba tuav bisaneŋ thɨgɨp ŋgɨp mba ŋgun vhen ŋgirɨrgeŋ nzuav mbui. Mbe ŋgirɨr za mbuav mbe tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mbe mbara muuŋv kɨrim, mba ŋgu namkam khavgip wo ŋgun vhen veri thɨmkamani puigirga. Ana wo ŋgun vhen veri thɨmkamani puigirim, nde zɨv ana ŋgun thɨmkamani thivgip, anan kamɨnga. Nde ana kamɨv khaŋ ana suanga, ‘Guma Rum, Guma Rum, ndu nza ndi thɨma fhɨrik!’ Nde maaŋ suanga, ana nde ŋgarkarav khaŋ nde suanga, ‘Gu nde kaŋgi fhuvara, gu vhɨra nde kega zegi ŋgu kaŋgi fhu.’ ");
INSERT INTO geb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ana maaŋ nde suanga, nde khaŋ suanga, ‘Nza ndu phorga mbegi ntɨɨri ma. Ndu nza ŋgu shɨra veri tuavi rɨksɨgivigen kav Fhe Bakɨme buni vhuuin nza khɨvav nza suaŋgi.’ ");
INSERT INTO geb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nde maaŋ ana suanga, ana khaŋ nde suanga, ‘Gu nde kaŋgi fhuvara, gu vhɨra nde kega zegi ŋgu kaŋgi fhu. Nde tɨvi mbatɨgi ga mbui ntɨɨri ma, nde na thav sari.’ ");
INSERT INTO geb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ana maaŋ nde suaŋgirim, nde nzi mbatɨgar muuŋv tari ndɨɨri phɨrɨrga. Nde maaŋ muuŋv kɨv, Abraham gu Aisak, Zekop, mba fhum kegi Fhe Bakɨme kamthooŋ gumgi, nde mbe ganɨnga, mbe Fhe Bakɨme wo gumgi gu mbigi garim, mbe ana piin ki ŋgun vhen kɨrga. Nde, Fhe Bakɨme nde fuasuegi, nde kɨrar ki. ");
INSERT INTO geb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mba ra ndai fhain ki ŋguir ki gumgi gu mbigi gum mba ra veri fhain ki ŋguir ki gumgi gu mbigi, mbe zɨv Fhe Bakɨme wo gumgi gu mbigi garim, mbe ana piin ki ŋgun wari wo ŋani ndigip ana phorgɨp ana shama bakɨme mbɨrga. ");
INSERT INTO geb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nde mbarara! Ntige fhara ki gumgi gu mbigi thari, mbe zumgum zɨn kɨrga. Ntige zɨn ki gumgi gu mbigi thari, mbe zumgum fhararga.” ");
INSERT INTO geb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Zisas mba buni nzuai tugera, Fherasiŋ mbari, mbe Zisas han zav khaŋ Zisas ga nzuai, “Ndu ntigera kha ŋgu thav harigi ŋanen ŋgɨri. Herot ndu shogiri ndu rɨmɨn za nzuai.” ");
INSERT INTO geb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mbe maaŋ nzuaim, Zisas khaŋ mbe nzuai, “Ndu ŋgɨp khaŋ mba ruaŋruaŋgi fiaŋ ga suaŋri, ‘Ndu mbarara! Ntige gum gurmaŋgip, gu gumgi gu mbigi tɨn ŋiniŋgi mbatɨgi ga vharvharav, mben kurkurav mben rɨmrɨɨ vhɨzɨrga. Gu raa phuni khegenen, gu won ŋaara vhɨzɨrga.’ ");
INSERT INTO geb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Gu maaŋ muuŋgip ntige ŋgɨp kɨv, gurmaŋgip ŋgɨp kɨv, vermaŋgip gu Zerusareman hɨgɨrga. Maaŋ muuŋgip, Fhe Bakɨme kamthooŋ guma harigi ŋgu then kɨrim, mbe ana shogirim, ana rimgirga fhu. Fhuvara. Mbe Zerusaremra ana shogirim, ana rimgirga. ");
INSERT INTO geb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Zerusaremiŋ, Zerusaremiŋ, nde kha Fhe Bakɨmen kamthooŋ gumgi, ndu mbe shogim, mbe vhɨzim, ndu kha Fhe Bakɨme sasarigi ndun han zi gumgi, ndu ŋkɨɨr mbe sav, mbe shogim, mbe vhɨzi ne ma. Gu tugi vhɨrvera, gu ndun tari, gu mbe fugɨp, tuara meeŋ won ŋgugi fugap won vhɨganin mbe vharigi tɨvar ndun tarir muun za mbuim, mbe thagi. ");
INSERT INTO geb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nde mbarara! Nde ŋgu ntigem mbatɨgip fhura kɨrga. Gu guigira khar nde nzuai, nde wom na gangirga fhu. Nde fhura kɨv kɨv, nde khaŋ suanga, ‘Fhe Bakɨme ndɨkndɨga vhuuŋra mba Guma Bakɨme zɨ muuŋgia zi guman muuŋri!’ Nde maaŋ suanga, nde taagi na ganɨnga.” ");
INSERT INTO geb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat raa mben Zisas vov Fherasin zɨ ki guma mbe phenan vugap ana phorga pi. Ana ana phorga pim, mbe tuituigira anan tɨva garav ki. ");
INSERT INTO geb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mba tugar fhav gum bigi za baagi guma mbe vhɨra zɨgap Zisas han maaŋ ki. ");
INSERT INTO geb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Zisas mbaram mba Fherasiŋ gumgi gum mba guigira Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgir nzarigi, “Nde ram mbui ndɨkndɨga mbui? Nza Sabatar guman kurav ana rɨmrɨma vhɨzi ne, ne Sabatar tɨva phɨrire, ee fhuve?” ");
INSERT INTO geb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ana mba nzambaran mbe muuŋgim, mbe thɨri pɨngiap fhura ki. Mbe buna thuen ana fagi fhuvara. Ana mbaram mba fhav gum bigi baagi guman fhava suirav, ana kurigim, ana batɨk fhura ŋgɨrgim, ana mbaram ana nzuaim, ana taagia vui. ");
INSERT INTO geb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ana vuim, Zisas taagia mben nzarigi, “Nde the maaŋ muuŋgip, kama the kɨrga o, borombaga the kɨrga, ana maaŋ muuŋgip Sabat raan mbok thɨgɨrga, nde mba raara vhemkora ŋgɨv ana sigɨrga, o fhu?” ");
INSERT INTO geb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ana mba nzambaren mbe muuŋgim, mbe ana suanga buna thueŋ ki fhu. ");
INSERT INTO geb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Zisas mba tugen mba gumgi garim, mbe mba mban mbɨr zav, mbe zɨ ki gumgi piigi mpirmpirɨgira, mbe ntara piigi. Ana maaŋ muuŋgiap mbe gangiap, thav buna mueŋ vhunama dav khaŋ mbe nzuai, ");
INSERT INTO geb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Guma the maaŋ muuŋgip muun rɨgɨp shama bakɨmen muuŋv, nden kamgirim, nde mba shaman ŋgegɨp, nde mba zɨ ki gumgi pigɨrga mpirmpirɨgira pigɨ thari. Nde kaŋgi fhuvara, mbe mba nde kambarav zɨri bakɨvi ki gumgi, mbe mben kamgiap, mbe ndim fegi mpirmpirɨgi mbar ki. ");
INSERT INTO geb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ndu maaŋ muuŋgip mba mpirmpirɨga perav kɨrim, mba shama mbuav nden kamgim, nde zegi guma zɨv khaŋ ndu suanga, ‘Ndu mba mpirmpirɨk thav khavik, ana kha guma pigɨrga mpirmpirɨk ma.’ Ndu muuŋv kɨrim, mba shama vuavi maaŋ ndu suaŋgirim, ndu guigira nen mbergip, khavgip ŋgɨp, za mbu mpuun guigira zɨ ki fhuv gumgi piigi mpirmpirɨga perarga. ");
INSERT INTO geb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nde maaŋ muuŋgip mbe shama then muuŋv nden kamgirim, nde ŋgɨp, nde mba zɨ guarara mba zɨ ki fhuv gumgi piigi mpirmpirɨgir pigiri. Mba shama mbuav nden kamgi guma bigɨn ma. Ana nduara zɨv nde gangip, khaŋ ndu suanga, ‘Kɨvntok, ndu khavgip, naaŋ ŋgɨp mbu mpirmpirɨga vhuun pera.’ Ana maaŋ ndu suaŋrim, ndu naaŋ ŋgɨp mba mpirmpirɨga perarim, ndu phorga mba shaman vegi gumgi, mbe ndu gangip, khaŋ ndu suanga, ‘Ndu zɨ ki guma ma.’ ");
INSERT INTO geb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Guma the wo zɨ ndi vun kuamkuarga, Fhe Bakɨme mba guma zɨ mbevari ana ŋgirgɨrga. Guma the wo zɨ mbevarga, Fhe Bakɨme mba guma zɨ ndi vun kuarga.” ");
INSERT INTO geb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Zisas mba bunin mbe nzua vov khaŋ mba wo phorgɨ mbɨr zav ana kamgi guma ga nzuai, “Ndu shama bakɨmen muuŋv wo phorgɨ mbɨr saŋv, ndu won kɨvntogira kamɨv, won fek gu tarira kamɨv, won ŋgun ŋkɨɨa vhɨrve ki gumgi, ndu mbera kamɨ thari. Ndu maaŋ muuŋgirga, mbe zumgum ndura kamgirga, ndu ŋgɨp mbe phorgɨ mbɨrim, mbe ndu shama ŋgarkararga. ");
INSERT INTO geb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ndu maaŋ muuŋgip shaman muuŋv, ndu mba shaman zɨrga gumgir kamɨ saŋv, ndu kha khesharigi gumgir kamɨri, bigi sosuagi gumgi, hari gu suira goreregi gumgi, suira mbatɨgi gumgi, rɨmgi mbatɨgi gumgi, ndu maaŋ muuŋgi gumgir kamɨri. ");
INSERT INTO geb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ndu maaŋ muuŋgirga, Fhe Bakɨme tɨvar vhuun ndun muunga. Mba khesharigi gumgi, ndu mben kamgi, mbe zumgum ndu shama ŋgarkararga tuktɨgi fhuvara. Ndu zumgum mba tɨvar vhuuaŋ muuŋgi gumgi, mbe vhɨzgi, mbe taagip khavɨrga, Fhe Bakɨme mba tugen ndu shama ŋgarkararga.” ");
INSERT INTO geb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Zisas mba kamen mbe nzuaim, ana phorga mba mba pi kaa ga perav pi guma mbe ne mbararagiap khaŋ ana nzuai, “Ena, mba Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga ntɨɨri, Fhe Bakɨme wo shama bakɨmen muuŋrim, mbe phorgɨv mba shama bakɨmen mbɨrga guma, ana ndikndigɨri.” ");
INSERT INTO geb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ana maaŋ nzuaim, Zisas ana ŋgarkarav khaŋ ana nzuai, “Ana harigi guma mbe, ana won shama bakɨme mbuav, ana mba gumgi vhɨrver kaai. ");
INSERT INTO geb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ana khaŋ mbui, ana mba shama bakɨmen muunga tuk hɨgim, ana mbaram won ŋaara guma ga sarigim, ana vov ana mba fhum mba shaman zɨr zav farasegi gumgi, ana vov mba shaman zɨr zav mbe nzuai. Ana vov khaŋ mbe nzuai, ‘Nde zɨri, mba shama bakɨme bigi za bevahegim, mba shama bakɨme tuk hɨgi.’ ");
INSERT INTO geb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ana vov mbe nzuaim, mbe za thagi. Mbe thav, mba shama bakɨme mbui guman ŋaara guma fhara vov nzarigi guma, ana khaŋ ana nzuai, ‘Gu ntigera nuiana sɨga mueŋ ga vezgiap, ne ganɨ za vui. Ndu ŋgɨp khaŋ mba shama bakɨme mbui guma ruma suaŋri, ana na ndava simɨ thari. Gu mbar ŋgɨrga fhuvara.’ ");
INSERT INTO geb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ana maaŋ ana suaŋgim, ana vov harigi nen nzarigim, ana khaŋ ana nzuai, ‘Gu ntigera ŋaarar muun zav phɨkthɨgi borombaga ga vhezgiap, gu ntigera ŋaarar ntan panɨ za mbui. Ndu ŋgɨp khaŋ mba shama bakɨme mbui guma ruma suaŋri, ana na ndava simɨ thari. Gu mbar ŋgɨrga fhuvara.’ ");
INSERT INTO geb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ana maaŋ ana suaŋgim, ana mbaram vov harigi nen nzarigim, ana vhɨra khaŋ ana nzuai, ‘Gu ntigera muuaŋ tɨgi, gu mbar ŋgɨgɨrga fhuvara.’ ");
INSERT INTO geb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Mba shama bakɨme mbui guman ŋaara guma, ana mba gumgir nzaim, mbe mba kamen ana suaŋgim, ana mba kameŋ ndiga taagia won guma ruma han vui. Ana vov mba mbe suaŋgi buni bun wo guma ruma suaŋgi. Ana mba buni bun won guma ruma nzuaim, ana ndav shigap, thav kama havharar won ŋaara guma ga ndɨɨv khaŋ ana nzuai, ‘Ndu vhemkora ŋgɨp, kha ŋgu bakɨmen ki tuavi bakɨvi gum tuavi bisarirer ŋgɨp, mba bigi sosuagi gumgi gum, suira mbatɨgi gumgi gum, rɨmgi mbatɨgi gumgi gum, hari gu suira goreregi gumgi, ndu mbe suaŋrim, mbe na phenan zɨv na phorgɨv na shama bakɨmen mbɨrga.’ ");
INSERT INTO geb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ana maaŋ won ŋaara guma ga suaŋgim, ana vugap mba gumgir kov zɨgap, mbaram khaŋ ana nzuai, ‘Guma rum, ndu nzuaim, gu vugap, kha gumgir kov zɨgim, ndu phen givigi fhu, ndu phenan ŋani mbari fhura khar ki.’ ");
INSERT INTO geb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ana maaŋ nzuaim, anan guma rum taagia khaŋ won ŋaara guma ga nzuai, ‘Maaŋ muuŋgim, ndu ntige wom taagip ŋgɨp, kha ŋgu bakɨme thav, ndu ŋgɨp mba tuavi bakɨvi gum mba mɨni ga rui tuavi, ndu nta thivi ŋgɨp, gumgi gu mbigi ganɨv, ndu khaŋ tɨgɨv mbe suaŋrim, mbe zɨv na phorgɨv na shama bakɨmen mbɨrga. Gu khueŋ vuzvugi, na phen za givarga, ne nzerarga.’ ");
INSERT INTO geb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ana nen ana suaŋgiap khaŋ ana nzuai, ‘Gu guigira khar ndu nzuai, gu mba fharav kha shama bakɨmen mbɨr zav farasegi gumgi, gu mbe nzuaim, mbe na shama bakɨmen zɨ thagi. Mbe guigira kha shaman mban tɨva thaneŋ mbegɨrga tuktɨgi fhu.’ ” ");
INSERT INTO geb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tuga mben gumgi gu mbigi vhɨrve, mbe Zisas phorga vuim, ana dorgap mbe garav khaŋ mbe nzuai, ");
INSERT INTO geb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Guma the na phorgɨv rur saŋv, ana kɨr wo ndia gum niamuuŋ gum, won muuŋ gum tari, won fegi gum ŋgugi, meeiŋ gum bivi, ana kɨr mbe segi fhu, ana vhɨra kɨr won vuzvugara segi fhu, ana na phorgɨ rurga guma kegɨrga tuktɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Guma the vhɨra wo rɨmɨnga khanarareŋ phufhurav na phorgɨ ruigirga fhu, ana vhɨra na phorgɨ rurga guma kegɨrga tuktɨgi fhu.” ");
INSERT INTO geb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Zisas mba bunin mbe suaŋgiap, mbaram khaŋ mbe nzuai, “Maaŋ muuŋgip, nde the phena bakɨ then muunga. Nde the mba phenan muun saŋv, ana ram mbui tɨvar muuŋgirie? Ana fhara perav mba phenan muunga bigi, ana nta ndɨkndɨgap, nta ruei. Ana nta ruev won ŋkɨɨa gari, ana mba phenan muunga ŋkɨɨa tuktɨgi o, fhu. ");
INSERT INTO geb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ana fharav maaŋ muuŋgirga fhu, ana mba phena kɨnira suegɨp ganɨnga, ana ŋkɨɨa vhɨzgi, ana fhura mba phena thagi. Ana fhura mba phena tharga, mba gumgi gu mbigi ne suaŋv ana sɨɨnga. ");
INSERT INTO geb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Mbe ana sɨɨŋv khaŋ ana suanga, ‘Kha guma wo gangiap kha phena mbui. Ana ana mbuav, ana vhɨzgi fhu.’ ");
INSERT INTO geb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Maaŋ muuŋgip ŋgui vhɨrve gari guman pana the, ana harigi ŋgui vhɨrve gari guman pana phorgɨv shogɨr saŋv, ana fharav perav won ntari ga mbui gɨɨtɨvi vhɨrve ganɨv khaŋ wo suanga, ‘Gu 10,000 ntari ga mbui gɨɨtɨvira khar ki. Mbu harigi ŋgui vhɨrve gari guman pan, ana won 20,000 ntari ga mbui gɨɨtɨvir ko zi.’ Ana mba ndɨkndɨgar muuŋv, khaŋ wo suanga, ‘Nan ntari ga mbui gɨɨtɨvir vhɨrve khaŋ muuŋgiap 10,000 thɨgi, gu ram muuŋrie? Gu mbu harigi ŋgui vhɨrve gari guman pana phorgɨv shogɨv, gu ana kambararie?’ ");
INSERT INTO geb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ana mba ndɨkndɨgar muuŋv ganɨnga. Ana tuktɨgi fhuv, ana mbaram wo gumgi thari ga sararim, mbe ŋgɨp mba ana phorgɨv shogɨr zav zi guman pan, ana samra kɨrim, mbe ŋgɨv mba ntara vhɨzɨ saŋv ana suanga. ");
INSERT INTO geb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Nde vhɨra mba khesharigi tɨvara muuŋri, nde the na phorgɨ rur saŋv, ana guigira za kɨr wo bigi ga segɨrga, ana na phorgɨ rurga guma kegɨrga. Ana za kɨr wo bigi ga segi fhu, ana na phorgɨ ruigirga guma kegɨrga tuktɨgi fhu.” ");
INSERT INTO geb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Zisas mba bunin mbe suaŋgiap wom khaŋ mbe nzuai, “Mbasɨk, ana bigɨna vhuuŋ ma. Ndu mbasɨk ndi suegɨp, ndu mbɨ kɨvgip, ana tɨgɨrga ana faaŋgirga, ndu wom ram ana muuŋgirim, ana vhergirie? ");
INSERT INTO geb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ndu mba khesharigi mbasɨgar won mɨna suegɨrga, ana ndu mban kurari nta vhuuŋgirga tuktɨgi fhu. Ndu vhɨra mba khesharigi mbasɨgar borombaga buari digip mɨna suegɨrga tuktɨgi fhuvara. Zakɨra fhuvara! Mba khesharigi mbasɨk, ndu fhura ana si mbur suarga. Gu khar nde nzuai bunaiŋ, guma khuarani kɨv, ana kha buni mbararari.” ");
INSERT INTO geb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Raa mben ŋkɨɨa ndia rui gumgi gum tɨvi mbatɨgi ga mbui gumgi, mbe zam Zisas nzuai buni mbarara zav ana han zegi. ");
INSERT INTO geb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mbe zegap, Zisas rorgiap, piigiap kav, ana buni mbararagim, mba Fherasiŋ gumgi gum mba Zudaiŋ tɨvir vhuuiŋ kaŋgi gumgi, mbe mbe gangiap, ne nzuav Zisas ga nzuav ndavi simgi. Mbe Zisas ga nzuav ndavi simgiap khaŋ wari ga nzuai, “Kha guma, ana tɨvi mbatɨgi ga mbui gumgi, ana mben khurkhuu ga mbuav mbe phorga pi.” ");
INSERT INTO geb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mbe maaŋ wari ga nzuaim, Zisas mbaram, kha bunai vhunama sav khaŋ mbe nzuai, ");
INSERT INTO geb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nde rɨgar nde the maaŋ muuŋgip 100 sipsivi kɨrga, nta rɨgar maaŋ muuŋgip the mbar rɨgɨrga. Ana mba 99 sipsivi ndi, mbara tɨgɨrim, nta mbara kɨv, vhazɨgi mbɨv kɨrim, ana ŋgɨp mba mbar rɨgi ne ndi ganɨv, kɨv ana gangirga. ");
INSERT INTO geb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Ana ana gangirga, ana guigira ndikndiga mbatɨgar muuŋv, ana fhurav ŋgun zɨrga. Ana ŋgun zɨv, ana za won kɨvntogir kamɨv, won han ki ntɨɨrir kamɨv, khaŋ mbe suanga, ‘Nde zɨv na phorgɨv na sipsiva suaŋv ndikndigɨri, ana mbarirɨgim, gu taagia ana gangi.’ ” ");
INSERT INTO geb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Zisas mba bunin mbe nzua vov khaŋ mbe nzuai, “Gu guigira nde nzuai, mba guma won sipsiva gangiap ndikndigi ndikndik, mba khesharigi ndikndigi, bakɨme kha nuianan kav tɨvi mbatɨgi ga mbui guma the ndav dorgɨrga, mba khesharigi ndikndigira Heven hɨgɨrga. Mbe vhɨra mba ndav domdorgi 99 gumgi mbe nzerara ki mbe mben ndikndigi. Mbe maaŋ muuŋgip kɨv kɨrim, tɨvi mbatɨgi ga mbui guma bavira, ana ndava dorgɨrga, mbe ne suaŋ Hevenan ndikndiga bakɨ guarara hɨgɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Zisas mba kamen mbe suaŋgiap, wom khuen mbe nzuai, “Maaŋ muuŋgip, mbiga the phɨkthɨgi ŋkɨɨa raraiŋveŋ kɨrga. Maaŋ muuŋgip thueŋ mbar rɨgɨrga, ana ram muuŋrie? Ana rama durav, ana nzuav garav, wo phena vhee bi. Ana mbara muuŋv ana suaŋv ganɨv kɨv, ana taagip ana gangirga. ");
INSERT INTO geb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ana taagi ana gangip, ana mbaram ndikndigap wo kɨvntogir kamɨv mbaram, won ŋgu ntɨɨrir kamɨv khaŋ mbe suanga, ‘Nde zɨv na phorgɨv na kɨma rareŋ ga suaŋv ndikndigɨri. Nan kɨma rareŋ mbar rɨgim, gu ntigem taagia wone gangi.’ ” ");
INSERT INTO geb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Zisas mba bunen mbe suaŋgiap, khaŋ mbe nzuai, “Gu guigira nde nzuai, kha mbik taagia wo kɨma rareŋ gangiap ndikndigi ndikndik, mba khesharigi ndikndigira. Kha nuianan kav tɨvi mbatɨgi ga mbui guma the ndava dorgɨrga, mba khesharigi ndikndigirga mbu Fhe Bakɨme enseri, mbe mba ndava dorgi guma ga suaŋv ndikndigɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Zisas mba bunin mbe nzuav vov wom khaŋ mbe nzuai, “Guma mbe kama phunini ki. ");
INSERT INTO geb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mani kav vov, ana kama ntok khaŋ won ndia ga nzuai, ‘Dara, gu khueŋ ndɨkndɨgi, ndu ntigera ndu mba ŋkan nɨɨn zav mbui bigi, ndu rɨgɨra nta shɨrav, na khɨna ntɨɨrir nan nɨɨŋgiri.’ Ana ne nzuaim, ana ndia rɨgɨra wo bigi shɨrav, ntan wo kamani ga nɨɨŋgi. ");
INSERT INTO geb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ana mba bigi shɨrav mani ga nɨɨŋgim, mani maaŋ kav, mbaram, ana kama ntok hɨgap, za wo bigi fugap, nta ndim mbaim, harigi gumgi zav, nta vhezi. Mbe nta vhezgiap, ŋkɨɨan ana nɨɨŋgim, ana mbaram khavgiap, won ndia gu mbe thav, saman harigi ŋgu bakɨ mben vugi. Ana vugap, mba ŋgun kav, tɨvi mbatɨgi guarira mbuav, ferferav, za won ŋkɨɨa fov mba bigi ga suegim, ana ŋkɨɨa za vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ana za won ŋkɨɨa fuasuegim, nta vhɨzgim, mba tugen ana mba ki ŋgu bakɨme fhain, mbe za mba tivgiap, thir vhɨzi tuga mbatɨk mben hɨgi. Ana mba tugen ana guigira fhɨrge rɨgap, tuga mbatɨga ndigi. Ana bigɨn thaneŋ ki za fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ana thav vov, mba ŋgu nɨɨŋge guma mben hɨgap, ana ŋaara guma ga gegap, ana ŋgari. Ana mba guman ŋgarim, mba guma ana sarigim, ana vov mba tugi kɨrin kav, ana daa gari. ");
INSERT INTO geb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ana vov, ana daa garav, mban nta ndɨɨv kav, ana guigira thɨ mbatɨk anan hegim, ana mbu daa ga sui regir fazɨgi garav, ana vhɨra mba daa phorgɨv ntan mbɨr zav mbui. Ana maaŋ kim, guma the mban ana kurigi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ana maaŋ kav, ndɨkndɨgap kav, thav ndɨkndɨga vhuuŋ ana zim, ana thav khaŋ wo nzuai, ‘Ore, nan ndiar ŋaara gumgi vhɨrve, mbe mbur kav mban tɨn kim, gu khaŋ kav thɨna rɨmɨn zav mbui.’ ");
INSERT INTO geb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ana mba ndɨkndɨga muuŋgiap thav khaŋ wo nzuai, ‘Gu ntige taagiap ŋgɨp, won ndia han ŋgɨp, khaŋ ana suanga, “Dara, gu tɨva mbatɨgar Fhe Bakɨme mbuav vhɨra ndu muuŋgi. ");
INSERT INTO geb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ndu ntigem, wom kaman nan kamɨnga tuktɨgi fhu. Ndu ntigem, won ŋaara guman nan kamɨnga.” ’ ");
INSERT INTO geb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Ana ndɨkndɨga vhuuŋ ana zɨgim, ana maaŋ wo suaŋgiap, mbaram khavgiap, won ndia han vui. “Ana vuim, ana ndia samra ana gangiap, mbaram ana ndava vhee guigira ana nzuav nzim, ana guigira ana kora muuŋgi. Ana ana kora muuŋgiap, mbara khuafɨ vov, ana fhɨre rɨgap, ana viavav, ana khoman mpari. ");
INSERT INTO geb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ana vov, ana viavav, ana khoman mparim, ana kam khaŋ ana nzuai, ‘Dara, gu tɨva mbatɨgar Fhe Bakɨme mbuav vhɨra ndu muuŋgi. Ndu ntigem, wom kaman nan kamɨnga tuktɨgi fhuvara.’ ");
INSERT INTO geb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ana maaŋ wo ndia ga nzuaim, ana ndia ana mbararavram, mbaram won ŋaara gumgir kamgiap khaŋ mbe nzuai, ‘Nde vhemkora ŋgɨp nan shaa vhuun mpeeŋra ndigi zɨv ana sharari. Nde mba shaar ana sharav, mbaram ŋgɨp, farve shari ring ndigi zɨp, ana farve sharav, ŋgɨp ŋkari sharive ndigi zɨv, ana ŋkarveni sharari. ");
INSERT INTO geb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nde maaŋ ana muuŋgip, ŋgɨp borombaga ŋguga kama bakɨmera ndigi zɨv, ana shogip, nza ana suaŋv shama bakɨmen muuŋv ndikndigirga. ");
INSERT INTO geb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kha shama bakɨmen muuŋv ndikndigirga, ne khaŋ muuŋgi. Nan kama mbe, ana rimgia kegap taagia khavgi. Ana vhɨra mbar rɨga, kav, kav taagia zɨgi.’ Ana nen mbe suaŋgiap, mbe shama bakɨme mbuav pav ndikndigi. ");
INSERT INTO geb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Mbe mba shama mbuav pav ndikndigap kim, mba guman kama bar, ana wo mɨnan kegap, taagi ŋgun zi. Ana zav won ndia phena han mbav, ana mbaram gitagi khɨkhɨɨ mbararav, mbaram kha gumgi gu mbigi hii khɨkhɨɨ mbararagi. ");
INSERT INTO geb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ana mba khɨkhɨɨ mbararav, mbara vov wo ndia ŋaara guma mben kamgim, ana ana han zim, ana ana nzarigi. ‘Mbe mbar ram mbui khɨkhɨm mbare?’ ");
INSERT INTO geb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ana mba nzambarar ana muuŋgim, mba ŋaara guma ana ŋgarkarav khaŋ ana nzuai, ‘Ee, ndu kaŋgi fhuve? Ndun ŋguk taagia zɨgi. Ana zɨgim, ndun ndia anan ndikndigap, borombaga ŋguga kama bakɨmera shogiap, shama bakɨme mbui. Ndun ŋguk za rimgi fara muuŋgiap, kegap, taagia nzerara zɨgim, ndun ndia ana nzuav ndikndigap shama bakɨme mbui.’ ");
INSERT INTO geb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ana nen ana suaŋgim, mba guman kaman rum ne mbararagiap, won ndia ga vhegap, mbaram mbe han phena vhen ŋgirɨ thagi. Ana thav kɨrar kim, ana ndia ne mbararagiap, mbaram kɨrar hɨgap zav, khaŋ thɨgav ana ndava mbɨv ana nzuai. ");
INSERT INTO geb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ana ndia ana ndava mbɨv ana nzuaim, ana won ndia ŋgarkarav khaŋ ana nzuai, ‘Ndu na mbarara! Gu kha mparir gu fhura ndun ŋaara guma ga gegap, ndun ŋgarav ki. Gu ndu nzuai buna thueŋ, gu ne kaadogi fhu. Zakɨra fhuvara! Gu fhum ndu phorga ki. Gu fhum ndu phorga kim, ndu maaŋ muuŋgiap na nzuav meme thaneŋra shogim, gu won kɨvntogir kov pav ndikndigi fhu. Zakɨra fhuvara! ");
INSERT INTO geb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ndu mba khesharigi tɨva then na muuŋgi fhu. Ndu ntigem, ndun kam ndu ana nɨɨŋgi bigi, ana nta ndiga vov, fhura ferfera rui mbigi phorga ruav, za ndu bigir mbe nɨɨŋgia zɨgi. Ana zɨgim, ndu ntigem, ana nzuav, borombaga ŋguga kama bakɨme shogi.’ ");
INSERT INTO geb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ana maaŋ nzuaim, ana ndia khaŋ ana nzuai, ‘Ndu na gor ma, ndu zazera na phorga kim, gu ndu kaŋgi, na bigi, nta za ndu bigi ma. ");
INSERT INTO geb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ndu ntigem, ŋka shama bakɨmen muuŋv ndikndigɨrga. Ndun ŋguk khaŋ muuŋgi, ana rimgia kegap taagia khavgi. Ana vhɨra mbar rɨga kav kav, ntigem taagia zɨgi.’ ” ");
INSERT INTO geb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Mba tugen Zisas mba bunin mbe nzua vov khaŋ wo phorga rui ŋaara gumgi ga nzuai, “Shɨk ki guma mbe, ana won shɨga zɨtɨgi zav guma mbe ndi fagim, ana ana shɨga garav ana zɨtɨgi. Mba guma, ana mba guma shɨga zɨtɨgap ana gari mpiiŋsɨk ma. Mba mpiiŋsɨk kav kim, gumgi mbari mbe zav mba shɨga mbui guma bakɨme han zegap khaŋ ana nzuai, ‘Guma rum, ndu wo shɨga ganɨv, ana zɨtɨgɨ zav fagi mpiiŋsɨk, ana ndu shɨga garav fhura ndun bigi ndi ndɨɨim, nta vhɨzi.’ ");
INSERT INTO geb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mbe maaŋ mba shɨga namkama suaŋgim, ana mbaram won mpiiŋsɨgar kamgim, ana ana han vhen zerim, ana ana nzarigi, ‘Ndu thaŋ nzuav kha khesharigi tɨva muuŋgim, mbe ne bun nzuaim, gu ne mbararagi? Ndu ntige taagi ŋgɨv, ndu mba fhura na bigi ndiv nɨɨŋgi, ndu za ntan ntuu khergiri. Ndu ntigem wom na shɨga zɨtɨgɨp, ana ganɨnga mpiiŋsɨk kegɨrga tuktɨgi fhuvara.’ ");
INSERT INTO geb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Mba shɨga namkam maaŋ mba shɨga zɨtɨgap ana gari mpiiŋsɨga suaŋgim, mba mpiiŋsɨk thav khaŋ wo nzuai, ‘Gu ntige ram muuŋrie? Kha shɨga namkam, ana ntige na vhɨzi. Gu vhɨra, gu harigi guman ŋaara guma kɨv, ana mɨna khorga ŋkasŋka ki fhu. Gu vhɨra ŋkɨɨa suaŋv harigi gumgir nzangen mbergi.’ ");
INSERT INTO geb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ana maaŋ wo suaŋgiap khaŋ nzuai, ‘Gu ntige muunga bigeŋ kaŋgi. Gu khaŋ muuŋgirga, mba na gari guma bakɨme kha mpiiŋsɨga ŋaarar na vhɨzgirga, kha gumgi nan kov wari wo phenin ŋgɨv, tɨvar vhuun nan muunga.’ ");
INSERT INTO geb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ana ne suaŋgiap, mbaram mba fhum ana ŋgari guma bakɨme han ŋgarɨga muuŋgi gumgi, ana za mben kamgim, mbe bevbevira ana han zi. Ana mben kamgim, mbevi fharav ana han zim, mba mpiiŋsɨk ana nzarigi, ‘Ndu fhum na gari guma bakɨme han thegi bigira ŋgarɨga muuŋgi.’ ");
INSERT INTO geb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mba guma ana ŋgarkarav khaŋ ana nzuai, ‘Gu ana han 100 mba tui mporiin dara ŋgarɨga muuŋgi.’ Ana maaŋ nzuaim, mba mpiiŋsɨk mbaram khaŋ ana nzuai, ‘Ndu ntige vhemkora khaŋ perav, ndu mba ŋgarɨga muuŋgi bigi ga nzuav ndu ndi khergi gaveŋ khare. Ndu ntige khaŋ muuŋgip ne khergiri, gu 50 mba tui mporiiŋ darara ŋgarɨga muuŋgi.’ ");
INSERT INTO geb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mba fharigi guma zim, ana maaŋ ana suaŋgim, ana vuim, harigi ne zi. Ana zim, mba mpiiŋsɨk ana nzarigi, ‘Ndu rarara bigi ŋgarɨga muuŋgi?’ Ana khaŋ ana nzuai, ‘Gu 100 parawa kira ŋgarɨga muuŋgi.’ Ana maaŋ nzuaim, mba mpiiŋsɨk mbaram khaŋ ana nzuai, ‘Ndu ŋgarɨga muuŋgi bigi, mbe nta nzuav khergi gaveŋ khare. Ndu ntigem, khaŋ muuŋgip ne khergiri, gu 80 parawa kirara ŋgarɨga muuŋgi.’ ");
INSERT INTO geb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Mba mpiiŋsɨk mba tɨva muuŋgim, mba ana gari guma bakɨme mba kameŋ mbararagiap, ana mbaram mba mpiiŋsɨk mbatɨga zɨ ndi vun kuagi. Ana khaŋ mbui tɨva muuŋgi ne nzuav, ana ndɨkndɨga vhuuŋ ki mpiiŋsɨga muunga tɨva muuŋgi. Kha nuianan ki tɨvi zɨn vui gumgi, mbe guigira mba tɨvir muunga tuavi vhɨrve kaŋgiap, mbe won tɨvi ga mbui. Mbe mba tɨvi ga mbuav, mbe mba Fhe Bakɨme zɨn vui gumgi kambarigi. ");
INSERT INTO geb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Gu nde nzuai, nde kha nuianan ki bigi gum ŋkɨɨa, nde tuituigira ntan guigira harigi gumgir kurkurav, mben kɨvntogir muuŋv kɨri. Nde maaŋ muuŋv kɨrim, mba nuiana ŋkɨɨa gum bigi vhɨzɨrga tuk hɨgɨrga, nta vhɨzɨrga, mba tugar nde Fhe Bakɨme gum ana enseri nden kamgirim, nde mbe han mba zazera mbara muuŋgiap ki phenin ŋgirgɨp zazera mbara muuŋgip kɨrga. ");
INSERT INTO geb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Guma bigɨna bisaneŋ ndigap tuituigira ne gari fhu, ana vhɨra bigɨna bakɨme ndigirga, ana vhɨra tuituigira ana gangirga fhu. Nde maaŋ muuŋgiap ntige guma the bigɨna bisaneŋ ndigap, ana tuituigira ne gari, ana vhɨra bigɨna bakɨme ndigirga, ana vhɨra tuituigira ana ganɨnga. ");
INSERT INTO geb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nde kha nuianan ŋkɨɨa, nde nta ndiav tuituigia nta garav, ntan ŋgari fhu. Maaŋgim, Fhe Bakɨme bigɨna guara then nden nɨɨŋgirim, nde ana gangirie? ");
INSERT INTO geb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nde vhɨra harigi gumgi bigi garav, nde tuituigira nta gari fhu, harigi guma the bigɨna then nden nɨɨŋgirim, nde ana vuavi mbuiav ana gangirga tuktɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Guma the fhum mpiiŋsɨga phuninin ŋaara guma kegi fhuvara. Ana maaŋ muunga, ana the vuzvugirga, ana the vuzvugirga fhu. Ana vhɨra the nzuai buni mbararav, ana kɨr the segɨrga. Nde vhɨra kha bigɨna phuni, nde vhɨra nin ŋgargirga tuktɨgi fhuvara. Nde Fhe Bakɨmen ŋgarɨv vhɨra ŋkɨɨa gum bigɨn ŋgargirga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Zisas mba buni nzuaim, mba Fherasiŋ, mbe guigira ŋkɨɨa nzuav thagine mbui ndɨɨri ma. Mbe mba Zisas nzuai buni mbararagiap, ana nzuav ndav shigap, tari ndɨɨri wari thivgiap ana gari. ");
INSERT INTO geb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mbe Zisas garim, ana khaŋ mbe nzuai, “Nde kha ndɨkndɨgi ga mbui ntɨɨri ma. Nde khueŋ vuzvugi, kha gumgi gu mbigi za kha ndɨkndɨgar nden muunga, nde tɨvi vhuuiŋ ga mbui ntɨɨri ma. Nde mba ndɨkndɨgar wari ga mbuim, Fhe Bakɨme, ana nde ndavi vherir zorga ki ndɨkndɨgi, ana nta kaŋgi. Mba ndɨkndɨgi, kha gumgi gu mbigi kha ndɨkndɨgar nta mbui, nta ndɨkndɨgi vhuuiŋ ma. Mbe mba ndɨkndɨgar nta mbuim, Fhe Bakɨme nta gari, nta guigira ndɨkndɨgi mbatɨgi ma. ");
INSERT INTO geb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Fhum Fhe Bakɨme Moses ga nɨɨŋgi tɨvi gum mba Fhe Bakɨme kamthooŋ gumgi suaŋgi buni, mba buni zav Zon Gumgi Ruai Gumara thɨgi. Ntigem, Zon Gumgi Ruai Guma kegi tugen, Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga buni vhuuiŋ hɨgi. Mba buni vhuuiŋ hɨgim, gumgi gu mbigi vhɨrve, mbe Fhe Bakɨme piin kɨrim, ana mbe ganɨngane nzuav ŋaara mbatɨga mbui. ");
INSERT INTO geb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Nde kha nuian gum buiva gari mani vhɨzɨ saŋv mani vhɨzgirga. Kha Fhe Bakɨme Moses ga nɨɨŋgi tɨvi, nta thaneŋ vhɨzgirga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Zisas mba bunin nzua vov khaŋ nzuai, “Guma the won muuŋ thav ŋgɨp harigi mbiga then tɨgɨrga, mba guma, ana ruan harigi mbiga mbe ndiga kegi tɨva muuŋgi. Guma the vhɨra mbiga the, ana man fhum ana thagim, ana kim, mba guma anan tɨgi, mba guma vhɨra, ana ruan harigi mbiga mbe ndiga kegi tɨva muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Zisas mba bunin mbe nzua vov wom khaŋ nzuai, “Fhum ŋkɨɨa kɨvgi guma mbe kegi. Mba ŋkɨɨa kɨvgi guma kav, ana zazera shagi vhuuiŋra sharav, shagi hɨvi vhuuiŋra ki. Ana maaŋ mbuav rari tugɨra tɨgap zazera mban vhuuiŋra pi. ");
INSERT INTO geb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ana mba tugen kim, ana phena bɨna thɨmkamanin, mbe mbevi shiav zɨgzɨgi mbui guma mbatɨga mbe, mbe ana ndi maaŋ tɨgim, ana ki. Ana zɨ khare, Rasarus. ");
INSERT INTO geb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ana maaŋ kav mba ŋkɨɨa kɨvgi guma won mba pim, mba phɨra nɨɨeŋri mban tɨvi, ana ntan mbɨr za mbui. Ana ntan mbɨr zav maaŋ kim, ana nzuu phara gum vɨzi zerim, mba feiŋ zav nta rega pi. ");
INSERT INTO geb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Mba guma mbatɨk maaŋ mbuav kim, ana rɨmɨnga tuk hɨgim, ana rimgim, Fhe Bakɨme enseri, mbe zav ana ndiga vov, Abraham han ŋgun vhuun fagim, ana ana han perav kav, ana phorga pi. Ana rimgim, zumgum mba ŋkɨɨa kɨvgi guma, ana rimgi. Ana rimgim, mbe ana ndi mboga tɨgi. ");
INSERT INTO geb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ana vov mba za vhɨzgi gumgi ki ŋgun vugap zaa mbatɨga guarara ndiav ki. Ana kav khoga garav, Abraham garim, ana kha ŋgun vhuun shama guarara kim, Rasarus ana han ki. ");
INSERT INTO geb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mba ŋkɨɨa kɨvgi guma Abraham gangiap, mbaram ana kaav khaŋ ana nzuai, ‘Fhe Abraham, ndu nan korar muuŋv nan kurkura saŋv Rasarus ga suaŋrim, ana won farafe ndi mbɨn rugɨp, zɨv na ze darim, na ze thaneŋ raŋgirga. Gu kha vhava bakɨmen kav guigira zaa mbatɨga ndi.’ ");
INSERT INTO geb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ana maaŋ nzuaim, Abraham mbaram khaŋ ana nzuai, ‘Ndu nan kam ma, ndu bigɨn thueŋ ndɨrgɨri. Ndu fhum ŋam kav, ndu kha bigi vhuuiŋve, ndu zam nta ndigi. Ndu Rasarus garim, ana bigi mbatɨgi ndigi. Ndu ntigem ana garim, ana kha ŋgun ana mpirmpirɨga vhuuaŋ muuŋgiap, ndav mbɨrav kim, ndu ntigem zaa mbatɨga ndi. ");
INSERT INTO geb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ndu vhɨra khueŋ kaŋgiri, ndu mbar ki ŋaneŋ gum nza khar ki ŋaneŋ, ni kɨtɨgar Fhe Bakɨme thumuuŋ bakɨme thugi. Maaŋ muuŋgiap, khaŋ ki gumgi maaŋ ŋgɨr zav mbui, mbe ram muuŋgip mbar ŋgegɨrie? Maaŋ muuŋgiap, maaŋ ki gumgi mbe ram muuŋgip khar zegɨrie?’ ");
INSERT INTO geb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ana maaŋ nzuaim, mba ŋkɨɨa kɨvgi guma thav khaŋ ana nzuai, ‘Maaŋgi, ndu Rasarus ga sararim, ana taagi ŋgɨp na ntɨɨri han ŋgirɨri. ");
INSERT INTO geb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Na meeŋthɨgi ŋgugi, mbe na ndia phenan mbar ki. Gu vuzvugi, Rasarus ŋgɨp kama havharara mbe suaŋrim, mbe mba mbui tɨvi mbatɨgi, mbe nta thari. Mbe muuŋv kɨv, mbe vhɨra zɨv kha ŋgun zɨgɨp, zaa bakɨme ndigɨ rivgi.’ ");
INSERT INTO geb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ana maaŋ nzuaim, Abraham khaŋ ana nzuai, ‘Ndu kaŋgi, Moses khergi buni gum Fhe Bakɨme kamthooŋ gumgi khergi buni, nta mbur ki. Mbe mba buni mbararav khuaran ntan tɨgɨri.’ ");
INSERT INTO geb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Abraham maaŋ nzuaim, mba ŋkɨɨa kɨvgi guma thav khaŋ ana nzuai, ‘O fhe Abraham, fhuvara. Mba buni tuktɨgi fhu. Maaŋ muuŋgip rimgi guma the taagi khavgip ŋgɨp, mbe suaŋrim, mbe ana khothɨgɨp ndavi domdorgirga.’ ");
INSERT INTO geb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ana maaŋ nzuaim, Abraham thav khaŋ ana nzuai, ‘Mbe maaŋ muuŋgip mba Moses gum mba Fhe Bakɨme kamthooŋ gumgi suaŋgi buni, mbe nta mbarara thagi. Mbarkɨ! Mbe nta mbarara thagim, mbe ram muuŋgip fhum rimgia kegap taagia khavgi guma ŋgɨp mbe suaŋrim, mbe ana khothɨgɨrie?’ ” ");
INSERT INTO geb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Zisas mba bunin mbe nzua vov khaŋ wo phorga rui gumgi ga nzuai, “Kha gumgi gu mbigin muuŋrim, mbe rɨv, tɨvi mbatɨgir muunga bigi vhɨrve hɨrga. Gu guigira mba gumgi gu mbigin muuŋrim, mbe rɨv tɨvi mbatɨgir muunga guma, gu guigira mba guma kora muuŋgi. ");
INSERT INTO geb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Guma the maaŋ muuŋgip, kha tara bisaŋ thanen muuŋgirim, ana rɨgɨp, tɨva mbatɨga thuen muuŋgirim, nde kɨma bakɨ the ndigip, ana fhɨra ntorgɨp, ana fegɨp mbasɨga rɨgɨra khɨngirim, ana rimgirga, ne nzerara. Nde maaŋ ana muuŋgirga, ne nzerarga. ");
INSERT INTO geb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Maaŋ muuŋgiap, nde tuituigira wari ganɨri. Nde phorge rɨgi the maaŋ muuŋgip tɨva mbatɨga thuen muuŋgirim, nde ne suaŋv ana mɨɨv ana suaŋri. Nde ana mɨɨrim, ana ndav dorgɨrim, nde ana muuŋgi tɨva mbatɨgeŋ ga ndɨkndɨgɨ thari. ");
INSERT INTO geb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ana maaŋ muuŋgip raa bavira harathɨgi tugir tɨvi mbatɨgir ndun muuŋgip, taagi ndav dorgɨp, zɨv harathɨgi tugir khaŋ ndu suanga, ‘Gu ndu muuŋgi tɨvi mbatɨgi, gu nta nzuav ndu kora muuŋgi.’ Ana maaŋ ndu suaŋgirim, ndu ana ndu muuŋgi tɨvi mbatɨgi, ndu nta ndɨkndɨgɨ thari.” ");
INSERT INTO geb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Zisas mba farasegi 12 thɨgi ŋaara gumgi khaŋ ana nzuai, “Guma Bakɨme, ndu nzan kurav, nza ndu khothivi tɨvir muuŋgirim, nza ndu khothivi tɨvi havhargirga.” ");
INSERT INTO geb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mbe ne nzuaim, ana mbe ŋgarkarav khaŋ mbe nzuai, “Nde maaŋ muuŋgip na khothɨgi tɨva bisaneŋ kha vuina kuguna bisaneŋ farar muuŋgirga, nde khaŋ kha khage suanga. ‘Ndu khaŋ thav sigi ŋgɨp, mbu mbasɨga rɨga thɨgɨ.’ Nde maaŋ suanga, ana nde nzuai kameŋ zɨn ŋgɨgɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Zisas mba kamen mbe nzua vov wom khaŋ mbe nzuai, “Nde rɨgar guma the maaŋ muuŋgip ŋaara guma the kɨrga. Ana ŋaara guma ŋgɨp ana mɨna khorga o, ŋgɨp ana sipsivi ganɨnga. Ana mba ŋaarar muuŋgip, taagi ŋkotugun phenan zɨrga. Ana maaŋ muuŋgip taagi phen zɨrim, ana gari guma bakɨme, khaŋ ana suaŋrie, ‘Ndu vhemkora zɨv khaŋ perav mban mbɨ?’ ");
INSERT INTO geb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Fhuvara! Ana gari guma bakɨme za khaŋ won ŋaara guma ga suanga, ‘Ndu na suaŋv mba bevahegɨp, wo ruagip, wo shaa vhuuŋ sharav, na ndi mba ndigi zɨrim, gu mbɨrga. Gu mbɨrim, ndu na rargɨ kɨri. Gu mbegɨ thugurim, ndu za mbɨrga.’ ");
INSERT INTO geb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mba ŋaara guma, mba ana gari guma bakɨme ana suaŋgi kameŋ zɨn vov, mba ŋaara muuŋgi ne suaŋv, ana anan ndikndigirie? Fhuvara! ");
INSERT INTO geb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nde vhɨra, nde maaŋ muuŋgip Fhe Bakɨme mba muun za nde suaŋgi bigi, nde zam nta muuŋgi. Nde khaŋ wari ga suaŋ thari, ‘Nza ŋaara gumgir vhuuiŋ ma. Nza khar mbui ŋaar, ana nzan ŋaar ma. Nza won ŋaara mbui.’ ” ");
INSERT INTO geb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Zisas Zerusareman ndai. Ana ndav vov Samaria gum Gariri wanin ndai rirur hɨga ndai. ");
INSERT INTO geb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Ana ndav vov ŋgu mbigen him, phɨkthɨgi gumgi, mbe ŋkari gu fari goreri rɨmrɨm ki, mbe zav maam anan purigi. Mbe zav maam anan purav, mbe vhɨra rɨmrɨm mbatɨk kav, mbe maaŋ muuŋgiap samra thivgiap, kama bakɨmera rugap, ana kaav khaŋ ana nzuai, “Zisas, Guman Rum, ndu nzan korar muuŋv nzan kura!” ");
INSERT INTO geb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Mbe maaŋ ana nzuaim, ana mbe garav khaŋ mbe nzuai, “Nde ŋgɨp wari wo fhavir mba Fhe Bakɨme rotu gari gumgi khɨvari.” Ana maaŋ mbe suaŋgim, mbe wari wo fhavir mbe khɨvɨr za vui. Mbe vov tuav sɨgen, mba ŋkari gu fari goreri rɨmrɨm fhura mben vhɨzgim, mbe fhavi taagia nzerigi. ");
INSERT INTO geb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mbe rɨgar guma mbe, ana wo fhava garim, ana fhav taagia nzerigim, ana kama bakɨmera Fhe Bakɨme zɨ ndiv vun kuamkuav taagia zi. ");
INSERT INTO geb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ana zav wo fega Zisas ŋkarveni nɨma khɨngiap ana ndikndigi. Mba zav ana ndikndigi guma, ana Samaria guma ma. ");
INSERT INTO geb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ana Zisasan ndikndigim, Zisas ana garav ana nzarigi, “Ee, gu khaŋ muuŋgia nde gangi, nde phɨkthɨgi gumgi, nde rɨmrɨɨ vhɨzgim, nde fhavi taagia nzerigi. Mba harigi fari bavira fethɨgi ntɨɨri mba? ");
INSERT INTO geb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ee, guma the taagi zɨv wo rɨmrɨm vhɨzgi ne suaŋv Fhe Bakɨme zɨ ndi vun kuamkua thagire? Kha harigi fhaiŋ ŋgu guma zav nduara Fhe Bakɨme ndikndigirie?” ");
INSERT INTO geb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Zisas maaŋ suaŋgiap, mbaram khaŋ mba guma ga nzuai, “Ndu khavgip ŋgɨ, ndu Fhe Bakɨme khothivav ndun rɨmrɨm vhɨzgim, ndun fhav taagia nzerigi.” ");
INSERT INTO geb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mba Fherasiŋ gumgi, mbe kha nzambaren Zisas ga mbui, “Maaŋgi tugar Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga tuk guigira kɨrar hɨgɨrie?” Mbe mba nzambaren Zisas ga muuŋgim, Zisas mbe ŋgarkarav khaŋ nzuai, “Fhe Bakɨme won gumgi gum mbigi ganɨnga tuk, ana bigɨn the farar muuŋgip hɨrim, nde wo rɨmgir ana gangip, kaŋgip khaŋ suaŋrie, ‘Mba tuk hɨgi?’ ");
INSERT INTO geb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mbe maaŋ muuŋgip ana ganɨv khaŋ suanga, ‘Mba tuk khar hɨgi’ o, mbe khaŋ suanga, ‘Mba tuk mbar hɨgi.’ Fhuvara. Nde mbarara. Fhe Bakɨme won gumgi gu mbigi ganɨnga tuk, ana nden hɨgap nden rɨgar khar ki.” ");
INSERT INTO geb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Zisas mba bunin mbe suaŋgiap, mbaram khaŋ wo phorga rui ŋaara gumgi ga nzuai, “Mba tuk zumgum nden hɨgɨrga, nde taagip Fhe Bakɨme Guma Guara ganɨrim, ana nde phorga kɨr saŋv muunga, nde mba tugar ana gangirga fhu. ");
INSERT INTO geb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Gumgi thari khaŋ nde suanga, ‘Ana mbure! Ana khare!’ Mbe maaŋ suaŋrim, nde fhura khuafɨ mbe zɨn ŋgɨ thari. ");
INSERT INTO geb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nde khueŋ kaŋgiri, Fhe Bakɨme Guma Guar, ana zirɨrga tugar, ana tor vhekvhegi vhava ŋaara farar muuŋgip, ana ŋkasŋkan vhava ŋaar za kha buiva shararga. Kha nuianan ki gumgi gu mbigi, mbe zam ana ganɨnga. ");
INSERT INTO geb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ana ntigem fharav zaagi mbatɨgi guarira ndirga. Ntige kha tugen ki gumgi gu mbigi, mbe zam ana shashagip kɨr ana segɨrga. ");
INSERT INTO geb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Mbe fhum Noa ki tugen muuŋgi tɨvi, mbe ntigem Fhe Bakɨme Guma Guar zɨr saŋv muunga, mbe mba tɨvira muunga. ");
INSERT INTO geb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mbe fhum Noa tugen, mbe mba pav, mbɨ pav, gumgi gu mbigi wari ga rɨgav, mbigi gumgi mbe vhezav, mbe rɨgi. Mbe mbara mbuav kim, Noa mba kema bakɨme muuŋgiap, ana vhen vergi. Noa mba kema vhen vergim, mbok bakɨme nzim, mbɨ vhuuŋgia ndav, za mba gumgi gu mbigi phorgim, mbe vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Mbara muuŋgi tɨv Rot tugen hɨgi. Mbe mbara muuŋgi, mba tugen mbe mba pav, mbɨ pav, bigi ndi mbav nta vhezav, mban parav, pheni ga mbui. ");
INSERT INTO geb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mbe mba tɨvara mbuav kim, Rot raa mben Sodom ŋgu thav sagim, mba raara Fhe Bakɨme shirɨ mbatɨga muuŋgi ŋkɨɨ gum vhava sarigim, nta mbok zeri fara muuŋgiap zerav, za mba Sodoman ki gumgi gu mbigi shigim, mbe vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ntigem Fhe Bakɨme Guma Guar hɨrɨrga tugar, mba raan mbara muuŋgirga. ");
INSERT INTO geb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Mba raan guma the wo vunkaman kegɨp, ana bigi ana phena vhen kim, ana taagip wo phena vhen ŋgirɨp wo bigɨn the ndi thari. Guma the vhɨra wo mɨnan kegɨp, taagip ŋgɨv wo phenan wo bigɨn the ndi thari. ");
INSERT INTO geb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nde Rot muun hɨgi bigeŋ ga ndɨrgɨri. ");
INSERT INTO geb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Guma the won tumara ndɨkndɨgɨrga, ana tum fhɨrgi rɨgɨrga. Guma the won tuma sharga, ana tum zazera mbara muuŋgip kɨrga. ");
INSERT INTO geb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Mba tugar maan guma phunini wani tɨgɨp kaa bavira kuv kɨrim, Fhe Bakɨme the ndigirga, the nduara mba kaar kɨrga. ");
INSERT INTO geb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Mba tugen vhɨra, mbiga phunini wani tɨgɨp parawa mbɨgɨv kɨrim, Fhe Bakɨme the ndigirga, the mbara kɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Zisas mba bunin mbe nzuaim, mbe mba buni mbararav kav, ana nzarigi, “Guma Bakɨme, mba khesharigi tɨvi maaŋ hɨrie?” Ana mbe ŋgarkarav ne vhunama sav khaŋ mbe nzuai, “Mba ŋanen shɨk rimgiv kav khurim, mba baŋgari zav mba ŋanen phogi ga vhui.” ");
INSERT INTO geb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Zisas mba buni suaŋgia thugap, mbaram zazera Fhe Bakɨme phorgɨ suaŋv vhukvhugɨ thargen wo phorga rui gumgi khɨvav, buna mueŋ vhunama sav mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ana khaŋ mbe nzuai, “Ŋgu bakɨ mben bigi ndi thɨgar mbai guman pana mbe ki. Mba bigi ndi thɨgar mbai guman pan, ana Fhe Bakɨmen rɨvi fhu, ana vhɨra gumgi ga ndɨkndɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mba ŋgu bakɨmen mana rimgi mbiga mbe vhɨra ki. Mba mbik, ana kav ana zazera zav khaŋ mba bigi ndi thɨgar mbai guman pana nzuai, ‘Nan pana guma nan farfa zav mbui. Ndu nan kurav ana suaŋv suaŋri.’ ");
INSERT INTO geb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mba mbik maaŋ ana nzuaim, mba bigi ndi thɨgar mbai guman pan fharav ana kurkura thagi. Ana zumgum, kha ndɨkndɨga mbui, ‘Gu Fhe Bakɨmen rɨvi fhuvara. Gu vhɨra pim gumgi ga ndɨkndɨgi ne fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Kha mana rimgi mbik, ana ne ndɨkndɨgi fhuvara, ana zazera zav won kurkura zav na nzuav simtɨgar na ndɨɨi.’ Ana mba ndɨkndɨga muuŋgiap, mbaram khaŋ wo nzuai, ‘Mbara muuŋ, gu ana kurav ana suaŋv suanga. Gu maaŋ muuŋ tharga, ana zazera zɨv na suaŋv kɨrim, gu guigira anan vhugu rivgi.’ ” ");
INSERT INTO geb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Zisas mba bunain mbe nzua vov khaŋ mbe nzuai, “Nde kha bigi ndi thɨgar mbai guman pana mbatɨk suaŋgi buneŋ, nde ne mbararagire? ");
INSERT INTO geb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Maaŋgi Fhe Bakɨme ram mbui tɨvar muuŋgirie? Ana won mbuiav farasegi gumgi gu mbigi, mbe rari gum mbari tugɨratɨgɨv ana nzav ana nzirga. Fhe Bakɨme mben kurarga fhuv thi? Ee, ana fhura mbe mbararav tuga mpeeŋra mbe rargɨ kɨv vhemkora mben kurarga fhuve? Zakɨra fhuvara! ");
INSERT INTO geb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Gu nde nzuai, ana vhemkora mben kurarga. Maaŋ muuŋgip, Fhe Bakɨme Guma Guar, ana zɨv kha nuianan ki gumgi gu mbigi ganɨnga, mbe thari ana khothɨgɨrga, o fhu?” ");
INSERT INTO geb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Gumgi mbari, mbe kha ndɨkndɨgar wari ga mbui. “Nza nduarira gumgir vhuuiŋ ma, harigi gumgi nza fara muuŋgi fhuvara, mbe gumgi mbatɨgi ma.” Zisas mba khesharigi ndɨkndɨgi ga mbui gumgi vhunama sav khaŋ nzuai. ");
INSERT INTO geb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Guma phunini, mani Fhe Bakɨme phorgɨ suan zav Fhe Bakɨme Phena vui. Guma mbe, ana Fherasiŋ guma ma, mbevi ana ŋkɨɨa ndia rui guma ma. ");
INSERT INTO geb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mba Fherasiŋ guma, ana vov thɨgap, wora nzuav Fhe Bakɨme phorga nzuai, ana khaŋ nzuai, ‘O, Fhe Bakɨme, gu ndun ndikndigi, gu kha harigi gumgi fara muuŋgi fhuvara. Mbe bigi kɨɨv, tɨvi mbatɨgi ga mbui ntɨɨri ma. Mbe mba tɨvi ga mbuav, vhɨra harigi gumgir muuiŋ, mbe ruarin mbe ndi. Gu maaŋ mbui fhuvara. Gu vhɨra mba ŋkɨɨa ndia rui gumgi fara muuŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Gu vhɨra kha tɨva mbui, gu ndu ndɨkndɨgap ndu nzuav ŋaariveŋ tugɨratɨgap, raa phuninin mba thamthav ndu phorga nzuai. Gu vhɨra wo bigi ndiav, gu nta shɨga phɨkthɨgi phogir mbav, phok mbe gu ana ndu ndɨɨi.’ ");
INSERT INTO geb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ana maaŋ nzuaim, mba ŋkɨɨa ndia rui guma, ana vov samra thɨgap, khoga buiva ganɨ thagi. Ana thav, ŋgiav wo gor mbav, khaŋ nzuai, ‘O Fhe Bakɨme, gu tɨvi mbatɨgi ga mbui guma ma. Ndu nan korar muuŋv nan kura!’ ” ");
INSERT INTO geb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Zisas nen mbe nzuav, khaŋ mbe nzuai, “Gu nde nzuai, mba ŋkɨɨa ndia rui guma Fhe Bakɨme phorga suaŋgia thugap, taagia wo phenan vuim, Fhe Bakɨme ana garav khaŋ ana nzuai, ‘Kha guma, ana na nɨman tɨvar vhuuaŋ muuŋgi. Mba Fherasi guma, ana fhuvara.’ Ne khaŋ muuŋgi, mba nduarira wari wo zɨri ndi vun kuamkuagi gumgi, Fhe Bakɨme mbe zɨri mbevarga. Mba nduarira wari wo zɨri mbevi gumgi, Fhe Bakɨme mbe zɨri vun fegɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Gumgi gu mbigi mbari, mbe won tarir kov Zisas han zim, ana wo farven mbe sur zav, mbe mbe kov zi. Mbe mben kov zav, vhɨra tira pi tari bisarire, mbe vhɨra mbe ndiav ana han zi. Mbe maaŋ mbuim, Zisas phorga rui gumgi mbe garav, mbe vhegap, mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Zisas mbaram mba tari bisarirer kav mbe nzuaim, mbe ndegi gu ndegmbori mben kov ana han zim, ana khaŋ wo phorga rui gumgi ga nzuai, “Nde mba tari bisarire thɨvɨ thari, nde fhura mbe ganɨrim, mbe na han zɨri. Kha tarire fara muuŋgi gumgi gu mbigi, mbe Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga ntɨɨri ma. ");
INSERT INTO geb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Gu guigira nde nzuai, guma the kha tari bisarire Fhe Bakɨme khothivi tɨva mbui fhu, ana Fhe Bakɨme won gumgi gu mbigi garim, mbe ana piin ki, ana mbe phorgɨ kegɨrga tuktɨgi fhu. Zakɨra fhuvara!” ");
INSERT INTO geb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Zisas mba bunin mbe nzuav kim, guman pana mbe hɨgap, kha nzambaran ana muuŋgi. “Guman Rum, ndu guman vhuuŋ ma, ndu khar na suaŋ. Gu ram muuŋgip zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigirie?” ");
INSERT INTO geb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ana maaŋ nzuaim Zisas khaŋ ana nzuai, “Ndu thaŋ nzuav khaŋ na nzuai, ‘Ndu guman vhuuŋ ma?’ Fhe Bakɨme nduara guman vhuuŋ ma. ");
INSERT INTO geb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ndu Fhe Bakɨme Moses ga suaŋgi tɨvi, ndu nta kaŋgi, ‘Nde mani gu mburi wari ga rɨgi gumgi gu mbigi, nde ruarin gumgi gu mbigi ndi thari. Nde harigi gumgi gu mbigi shogɨrim, mbe vhɨzɨ thari. Nde kɨmɨ thari. Nde fhura harigi gumgi gu mbigi ga shɨshɨgɨp fhura mbe suaŋv suaŋ thari. Nde wari wo ndegi gu ndegmbori piin kɨv, mbe nzuai buni mbararav nta zɨn ŋgɨri.’ ” ");
INSERT INTO geb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ana ne nzuaim, mba guman pan khaŋ ana nzuai, “Gu taranera kegap, mba tɨvi gu nta zɨn vo zav kav ntige guma ruma muuŋgiap, nta zɨn vuavra ki.” ");
INSERT INTO geb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ana maaŋ nzuaim, Zisas mba kameŋ mbararagiap, khaŋ mba guman pana nzuai, “Nzerara, ndu tɨva mueŋ khegi. Ndu ŋgɨp wo bigi za nta ndi maaŋrim, mbe nta vhezgirim, ndu mba ŋkɨɨa ndiv mba bigi sosuagi gumgir nɨɨŋgiri. Ndu maaŋ muuŋgirga, ndu Hevenan bigi vhuuiŋ kɨrga. Ndu maaŋ muuŋgip zɨv na phorgɨ rurga.” ");
INSERT INTO geb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Zisas maaŋ ana nzuaim, mba guman pan ne mbararagiap, ana guigira ne nzuav ndav simgi. Ana khaŋ muuŋgiap, ana guigira bigi vhɨrkɨvgi guma ma. ");
INSERT INTO geb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Zisas mba guman pana garim, ana ndav simgim, ana khaŋ nzuai, “Ŋkɨɨa kɨvgi gumgi mbe Fhe Bakɨme wo gumgi gu mbigi garim, mbe ana piin ki ŋgun vhen ŋgirɨrgeŋ suaŋv ŋaara mbatɨgar muuŋgirga. ");
INSERT INTO geb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nde kemor gari. Ana shagi sai viiŋ thoon ŋgirɨ zav, ana ŋaar ki fhuvara, ana fhura veri. Ŋkɨɨa kɨvgi guma, ana Fhe Bakɨme wo gumgi gu mbigi gari, mbe ana piin ki ŋgun vhen ŋgirɨrgeŋ suaŋv ŋaara mbatɨgar muuŋgirga.” ");
INSERT INTO geb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Zisas ne nzuaim, maaŋ kav ne mbararagi gumgi gu mbigi, mbe kha nzambara mbui. “Maaŋ muuŋgirga, theiŋ Fhe Bakɨme taagip mbe ndigirie?” ");
INSERT INTO geb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mbe mba nzambara mbuim, Zisas mbe ŋgarkarav khaŋ mbe nzuai, “Guma muungeŋ kakagi bigɨn, Fhe Bakɨme mba bigɨnan muuŋgirga.” ");
INSERT INTO geb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Zisas ne nzuaim, Pita mbaram khaŋ ana nzuai, “Nza za wari wo bigi thav ndu phorga rui.” ");
INSERT INTO geb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Pita ne nzuaim, Zisas mbaram mbe ŋgarkarav khaŋ mbe nzuai, “Gu guigira nde nzuai, guma the Fhe Bakɨme won gumgi gu mbigi ganɨrim, mbe ana piin kɨv, ana Fhe Bakɨme ŋaara muun saŋv, wo phena thav, won muuŋ gu fegi gum ŋgugi, gu ndegi gum ndegmbori, won tari, ana mbe tharga, ana ntigem kha nuianan Fhe Bakɨme guigira bigi vhɨrvera ana nɨɨŋgirga, ana mba fhum ki bigi, mba bigi guigira nta kambararga. Ana vhɨra zumgum kha nuian vhɨzgirga, Fhe Bakɨme zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ anan nɨɨŋgirga.” ");
INSERT INTO geb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Zisas wo farasegi 12 thɨgi ŋaara gumgir kov gaar vugap, mbe fugap khaŋ mbe nzuai, “Nde mbarara, nza ntigem Zerusareman naanga. Nza naanga, mba Fhe Bakɨme kaathoori gumgi, mbe fhum mba Fhe Bakɨme Guma Guaran hɨr za suaŋgi tɨvi, mbe nta khergim, nta Fhe Bakɨme buni vhuuiŋ ki gavan ki, mba tɨvi ntige guigira mba tegɨrga. ");
INSERT INTO geb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nza naanga, mbe ana ndim, harigi ŋgui gumgi farve khɨngirga. Mbe ana ndi mbe farve khɨngirim, mbe ana nzɨɨ buni ana nzuav tɨvi mbatɨgir ana muuŋv, ana khoma parɨv, ");
INSERT INTO geb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kankani ki phivɨga ndigɨ zɨv ana kharɨv, ana shogirim, ana rimgirga. Ana rimgirga, raa phuni khegene vhɨzgirga, ana taagi khavgirga.” ");
INSERT INTO geb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Zisas mba bunin wo farasegi 12 thɨgi ŋaara gumgi ga nzuaim, mbe mba buni nɨɨŋge kaŋgi fhuvara. Fhe Bakɨme mbe buni nɨɨŋge sigasarav mbe suaŋgi fhuvara. Mbe maaŋ muuŋgiap, mbe ana nzuai buna thueŋ kaŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Zisas Zerusareman ndav vov Zerikon him, rɨmani mbatɨgi guma mbe, ana mba tuav gaanin perav kav, bigi ga nzuav nzai. ");
INSERT INTO geb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ana maaŋ kav mba gumgi gu mbigi vhɨrve mbararagim, mbe dugduga vov wari ga nzuaim, ana mben nzarigi, “Nde maaŋ vov dugdugi khɨkhɨm khare?” ");
INSERT INTO geb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ana mba nzambaran mbe mbuim, mbe khaŋ ana nzuai, “Nasaret guma Zisas mbur zi.” ");
INSERT INTO geb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mbe nen ana nzuaim, mba rɨmani mbatɨgi guma ne mbararagiap, mbaram kaav khaŋ nzuai, “Zisas, Devitan kam, ndu na korar muuŋv nan kura.” ");
INSERT INTO geb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ana maaŋ nzuaim, mba Zisas nɨman fhara ndai gumgi, mbe ana vhegap khaŋ ana nzuai, “Ndu wo thɨni mpɨra.” Mbe maaŋ ana nzuaim, ana mbe mbararagi fhuvara, ana khaŋ tɨgap Zisasan kaav khaŋ ana nzuai, “Devitan Kam, ndu nan korar muuŋ.” ");
INSERT INTO geb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ana maaŋ nzuaim, Zisas ana mbararagiap, mbaram thɨgap, mbaram mba rɨmani mbatɨgi guman kov wo han ŋgɨr zav mbe nzuai. Ana nen mbe nzuaim, mbe mba rɨmani mbatɨgi guman kov ana han vugim, ana anan nzarigi, ");
INSERT INTO geb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ndu, gu ram ndun muungeŋ vuzvugi?” Ana mba nzambaran ana muuŋgim, ana khaŋ ana nzuai, “Guma Bakɨme, gu nan rɨmani nzerarim, gu ganɨngane vuzvugi.” ");
INSERT INTO geb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ana maaŋ nzuaim, Zisas mbaram khaŋ ana nzuai, “Ndu rɨmani nzerari, ndu ganɨri. Ndu na khothɨgi, ndu rɨmani nzerigi.” ");
INSERT INTO geb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Zisas maaŋ ana nzuavra thagim, ana rɨmani fhura ndarigim, ana bigi garav, Zisas phorga ndav Fhe Bakɨme zɨ ndi vun kuamkuav ndai. Ana Zisas phorga ndaim, mba gumgi gu mbigi ana gangiap, ana rɨmani nzerigi ne nzuav, mbe vhɨra Fhe Bakɨmen zɨ ndi vun kuamkuagi. ");
INSERT INTO geb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Zisas ndav vov Zeriko ŋgu bakɨme hɨgap, mbaram mba Zeriko ŋgu shɨrav ndai tuav thɨga ndai. ");
INSERT INTO geb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ana ndaim, mba ŋgun guma mbevi, ana zɨ Zakias. Ana ŋkɨɨa ndia rui gumgi gari guman pan ma. Ana vhɨra ŋkɨɨa kɨvgi guma ma. ");
INSERT INTO geb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ana mba tugen Zisas ganɨ za mbui. Ana kaŋgi fhu, Zisas ana ram mbui khesharigi guma. Ana ana ganɨ za mbuav, ana vhɨra guma tɨvaneŋ ma. Ana maaŋ muuŋgiap, mba gumgi gu mbigi vhɨrve, mbe guigira vhɨrkɨvgim, ana ram muuŋgip mbe kharav Zisas gangirie? ");
INSERT INTO geb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ana maaŋ muuŋgia thav, mbaram fharav Zisas nɨma tɨgap fharav khuafɨ vov, Zisas ganɨ zav vov kha mbigen ndav, niŋge vun perav ki. Ana kaŋgi Zisas kha tuavra thɨgɨp zɨrga. ");
INSERT INTO geb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ana perav kim, Zisas mba tuav thɨga ndai. Ana nda zav mba Zakias ki khage nɨɨn hav, khoga Zakias garav, ana kamgiap khaŋ ana nzuai, “Zakias, ndu vhemkora mba khage thav nɨɨn zirɨri. Gu ntige ndu phorgɨp ndu phenan kɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zisas maaŋ ana nzuaim, ana ne mbararagiap, guigira ndikndigap, mbaram vhemkora nɨɨn zergap, Zisasan kov wo phenan vui. ");
INSERT INTO geb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Zisas Zakias phorgap ana phenan vuim, mba gumgi gu mbigi vhɨrve, mbe ana garav suambara mbatɨgar ana mbui. Mbe ana nzuav khaŋ ana nzuai, “Khe tɨvi mbatɨgi ga mbui guma phorgɨv ana phenan kɨr zav vui.” ");
INSERT INTO geb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zisas vov Zakias phenan kim, Zakias mbaram khavgia thɨgap khaŋ Zisas ga nzuai, “Guma Bakɨme, ndu mbarara, gu ntigem wo bigi gu rɨgɨra nta sharav, tharir mba bigi sosuagi gumgir nɨɨnga. Gu vhɨra harigi gumgi, gu mbe guiguigav mbe han mbe bigi ndigi, gu ntige taagip mbe bigi ŋgarkav, gu fethɨgi bigin mben nɨɨŋgirga.” ");
INSERT INTO geb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ana maaŋ nzuaim, Zisas mbaram khaŋ ana nzuai, “Ntigem Fhe Bakɨme taagia kha phenan ki ntɨɨri ndigi. Kha guma ana vhɨra Abrahaman kam ma. ");
INSERT INTO geb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Fhe Bakɨme Guma Guar, ana khaŋ muuŋgiap mbar regi gumgi ndiv ganɨv taagi mbe ndir zav zɨgi.” ");
INSERT INTO geb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Zisas mba bunin mba gumgi gu mbigi ga nzuaim, mbe mba buni mbararav kim, ana wom buna mueŋ vhunama dav mbe nzuai. Ana khaŋ muuŋgi ne nzuav, ana mba vhunama si bunen mbe nzuai. Ana nda vov, Zerusareman han mbaim, mba gumgi gu mbigi khueŋ ndɨkndɨgi, Fhe Bakɨme ntige wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga tuk ntigera hɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mbe mba ndɨkndɨga mbuim, Zisas khaŋ mbe nzuai, “Guma ruma mbe, ana harigi fhain shama guarara ki ŋgu mben ŋgɨr zav mbui. Ana mba ŋgun ŋgɨgɨrim, mbe ana ndim ŋgui gari guman panan farga. Mbe ana ndi farga, ana taagip zɨv wo ŋgu nɨɨŋgen zɨgɨp, won ŋgu ntɨɨri ganɨnga. ");
INSERT INTO geb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mba guma rum ŋgɨr zav, ana mbaram won phɨkthɨgi ŋaara gumgir kamgim, mbe ana han zim, K400.00 mbe heevram mbe nɨɨŋgi. Ana mba ŋkɨɨan mbe ndɨɨv khaŋ mbe nzuai, ‘Nde kha ŋkɨɨa ndigi ŋgɨp, ntan shɨgar muuŋv kɨrim, gu taagi zɨrga.’ ");
INSERT INTO geb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ana maaŋ suaŋgiap vugim, ana ŋgu nɨɨŋgen ki gumgi gu mbigi, mbe ana nzuav nderninin kav, mbaram kaman gumgi mbari ga nɨɨŋgim, mbe ana zɨn ana vugi ŋgun vov, khaŋ mba ŋgun ki ntɨɨri ga nzuai, ‘Nza mba guma nzan guman pan kɨrgeŋ vuzvugi fhu.’ ");
INSERT INTO geb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mbe vov maaŋ ana nzuavra kim, mbe ana ndim ŋgui gari guman panan fagi. Mbe ana ndim fagim, ana taagia wo ŋgu nɨɨŋgen zɨgi. Ana zɨgap mbaram khaŋ nzuai, ‘Nde mba gu fhum ŋkɨɨan nɨɨŋgia vugi ŋaara gumgir kamgirim, mbe na han zɨri. Mbe zɨrim, gu mba mbe nɨɨŋgi ŋkɨɨa, mbe ntan shɨga mbuav ndigi ŋkɨɨa, gu nta ganɨnga.’ ");
INSERT INTO geb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Ana maaŋ suaŋgiap mben kamgim, mbevi fhara zav, khaŋ ana nzuai, ‘Guman pan, gu ndu mba na nɨɨŋgi K400.00, gu ntan shɨga mbuav, K4,000.00 ndigi.’ ");
INSERT INTO geb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ana ne nzuaim, ana guman pan khaŋ ana nzuai, ‘Ndu nan ŋaara guman vhuuŋ ma. Ndu ŋaara vhuuŋra mbuav, gu ndu farve khɨngi bigɨna bisaŋ guaranera, ndu tuituigira ne gari. Ndu maaŋ muuŋgim, gu ntigem zɨ bakɨmen ndun nɨɨŋgirga, ndu ntigem phɨkthɨgi ŋgui bakɨvi, ndu nta ganɨnga.’ ");
INSERT INTO geb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ana maaŋ ana suaŋgim, ana ndegi ŋaara guma zi. Ana zav khaŋ ana nzuai, ‘Guman pan, ndu na nɨɨŋgi K400.00, gu ntan shɨga mbuav harigi K2,000.00 ndigi.’ ");
INSERT INTO geb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ana maaŋ ana nzuaim, mba ŋgui gari guman pan khaŋ ana nzuai, ‘Gu ntigem ndu ndim fagi, ndu ntigem meeŋthɨgi ŋgui bakɨvi ganɨnga.’ ");
INSERT INTO geb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ana maaŋ ana nzuaim, mba harigi ŋaara guma zi. Ana zav khaŋ ana nzuai, ‘Guman pan, ndun K400.00 khare. Gu shaa fɨga mueŋ ndigap, nonɨga vhuuŋra nta muuŋgiap, nta ndi tɨgap kegi. ");
INSERT INTO geb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Gu khaŋ muuŋgiap, gu ndu kaŋgi, ndu guigira vhav shi guma ma. Ndu khaŋ mbui, harigi guma tɨgɨrga bigi, ndu vhɨra nta ndi. Ndu vhɨra harigi guma pargirga mba, ndu vhɨra nta ndi. Gu maaŋ muuŋgiap guigira ndun rivgi.’ ");
INSERT INTO geb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ana maaŋ nzuaim, mba ŋgui gari guman pan khaŋ mba ŋaara guma ga nzuai, ‘Ndu ŋaara guma mbatɨga guar ma! Gu ndu suaŋgi bunira suaŋv ndu ndi suaŋgirga. Ndu na kaŋgi, gu vhav shi guma ma. Ndu kaŋgi, gu vhɨra harigi gumgi sui bigi, gu nta ndiav, vhɨra harigi gumgi pari mba, gu vhɨra nta ndi. ");
INSERT INTO geb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ndu maaŋ muuŋgiap kaŋgiap, ndu thaŋ nzuav nan ŋkɨɨa ndigi ŋgɨp, ŋkɨɨa ki phena khɨngirim, gu ntige taagi zɨv, nta ndiv ntan bɨɨŋbɨɨn ŋkɨɨa phorgɨp ndigirga.’ ");
INSERT INTO geb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ana nen ana nzuav, mbaram kha mba ana han thivgi gumgi ga nzuai, ‘Nde mba guma tɨn mba K400.00 ndigip, mbu K4,000.00 ki guman nɨɨŋ.’ ");
INSERT INTO geb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ana nen mbe nzuaim, mbe khaŋ ana nzuai, ‘Guman pan, ana K4000.00 ki.’ ");
INSERT INTO geb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Mbe maaŋ nzuaim, ana khaŋ mbe nzuai, ‘Gu nde nzuai, mba bigi ki gumgi, gu harigi bigi phorgɨv mben nɨɨŋgirga. Maaŋ muuŋgip, guma the bigi ki fhu, ana mba ki bigi bisaŋrire, gu ana tɨn nta ndigirga.’ ");
INSERT INTO geb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ana maaŋ mbe nzuav, mbaram khaŋ mbe nzuai, ‘Mba panan na kegap, gu mbe gari guman pan kɨr za mbuim, mba na thagi gumgi, nde ŋgɨp, mbe ndigip na han zɨv, na nɨman mbe shogɨrim, mbe vhɨzgiri.’ ” ");
INSERT INTO geb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Zisas mba vhunama si bun mbe suaŋgia thugap, mbaram maaŋ thav khavgiap wom Zerusareman ndai tuav thɨga ndai. ");
INSERT INTO geb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Zisas ndav vov, Betfage gum Betani han mbav mbe mba kha zɨn rɨgi mbɨkshɨman hɨgi, Oriv mbɨkshɨm. Ana ana ndav, mbaram wo phorga rui guma phuni ga sarigi. Ana mani ga sarav khaŋ mani ga nzuai, ");
INSERT INTO geb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ŋko fharav mbu ŋgugen ŋgɨ. Ŋko mba ŋgugen ŋgɨp ganɨnga, mbe doŋki ŋguga kama mbe, mbe ana ndim thɨrigi ana ki. Mba doŋki ŋgugar kam, guma the fhum ana pera vugi fhuvara. Ŋko ŋgɨp, ana gangip, ana mpiiŋ fhɨrgip, ana ndigi zɨri. ");
INSERT INTO geb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ŋko ana mpiiŋ fhɨrɨrim, guma the ŋko gangip khaŋ ŋko suanga, ‘Ŋko thaŋ nzuav mba doŋki mpiiŋ fhɨri?’ Ŋko khaŋ ana suaŋri, ‘Guma Bakɨme ŋaar anan ki.’ ” ");
INSERT INTO geb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ana maaŋ mani ga suaŋgiap, mani ga sarigim, mani vov garim, mba bigi ana mba mani ga suaŋgi bunira zɨn vugap hɨgi. ");
INSERT INTO geb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mani mba doŋki gangiap, ana mpiiŋ fhɨrim, mba doŋki namŋga mani gangiap, khaŋ mani ga nzuai, “Ai, ŋko thaŋ nzuav mba doŋki mpiiŋ fhɨri?” ");
INSERT INTO geb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Mbe maaŋ mani ga nzuaim, mani mbe ŋgarkarav khaŋ mbe nzuai, “Guma Bakɨme ŋaar anan ki.” ");
INSERT INTO geb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mani maaŋ mbe suaŋgiap, mba doŋki ndiga Zisas han zɨgap, mbaram wani wo fhava sharagen zorgiap, mba doŋki kɨra sarav, mbaram Zisasan kurav ana suigim, ana barav mba doŋkir ndav ana perigi. ");
INSERT INTO geb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Zisas mba doŋki ga perav mbe Zerusareman ndai. Ana ndaim, gumgi gu mbigi, mbe wari wo shagi ndim tuav ga sɨgim, ana nta tɨn ndai. ");
INSERT INTO geb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ana nda vov, Oriv mbɨkshɨman hɨgap, vov shargia verim, ana phorga rui gumgi vhɨrvera, mbe zam ndikndiga mbatɨga mbuav, mbe mba gangi mirikori ga nzuav kama bakɨmera Fhe Bakɨme zɨ ndi vu kuamkuagi. ");
INSERT INTO geb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Mbe Fhe Bakɨme zɨ ndi vun kuamkuav khaŋ nzuai, “Fhe Bakɨme ndikndigar vhuun kha ŋgui ganɨnga guman panan muuŋri. Ana Guma Bakɨme zɨ muuŋgi zi. Fhe Bakɨme nza nzuav ndav mbɨrari, nza ne suaŋv Fhe Bakɨme zɨ ndi vun guarara kuamkuarga.” ");
INSERT INTO geb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mba Zisas phorga rui gumgi ndikndigap maaŋ nzuaim, mba Fherasiŋ gumgi mbari vhɨra mba gumgi vhɨrve phorga kav khaŋ Zisas ga nzuai, “Guman Rum, ndu wo phorga rui gumgi ga suaŋrim, mbe wari wo thɨri mpɨra.” ");
INSERT INTO geb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mbe maaŋ nzuaim, Zisas mbe ŋgarkarav khaŋ mbe nzuai, “Gu nde nzuai, mbe wo thɨri mpɨrarga, kha ŋkɨɨ, mbe kama hegɨp kamɨv suanga.” ");
INSERT INTO geb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Zisas maaŋ mbe suaŋgiap nda vov, Zerusareman han mbav, ana ŋgu bakɨme garav, ana ana nzuav nzi. ");
INSERT INTO geb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ana nziav khaŋ nzuai, “O Zerusarem, gu ntigem kha raara ndun muuŋgirim, ndu ndav mbɨrav kɨrga bigi, ndu vhɨra nta kaŋgirga ne vuzvugi. Mba bigi ntige zorga ki, ndu nta gari fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Zumgum tuga, then ndun pana gumgi zɨv nuianan ndu bɨna gaanin vhuigirga. Mbe zɨv, za ndu bɨna gaani behuigip ndu bɨnan vhuigirga. ");
INSERT INTO geb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mbe ndu bɨnan vhuigip, za ndu shogɨp guigira ndun farfagirga. Mbe ndun farfav, vhɨra ndun tari, mbe ndun vhen ki, mbe vhɨra mben farfagirga. Mbe vhɨra guigira ndun farfagirga. Ndun bɨna vhuigi kɨma the, the tɨn ndarav kegɨrga fhuvara. Nde khaŋ muuŋgi ne nzuav, Fhe Bakɨme nden kurkura zav zɨgim, nde ne kaŋgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Zisas nda vov Zerusareman hɨgap, mbaram vera vov Fhe Bakɨme phena bɨna vhen verav, mba bigi ndi mbav shɨga mbui gumgi zɨtɨgap mbe ndim kɨrar mbai. ");
INSERT INTO geb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ana mbe zɨtɨgap mbe ndim kɨrar mbav khaŋ mbe nzuai, “Fhe Bakɨme gavan ki kameŋ khaŋ nzuai, ‘Na phen ana na phorgɨv buni suanga phen ma. Nde ana mbuim, ana kɨɨi gumgi zomzori phena fara muuŋgi.’ ” ");
INSERT INTO geb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Zisas mbe zɨtɨgiap, mbaram maaŋ kav, ana raari tugɨratɨgap Fhe Bakɨme buni vhuuin mba gumgi gu mbigi khɨvav mbe nzuai. Ana maaŋ mbuim, mba Fhe Bakɨme Phena gari gumgir pani gum, Zudaiŋ tɨvir vhuuiŋ kaŋgi gumgi gum, mben gumgi ruu, mbe Zisas shogiri ana rimgirga tuavi ndi gari. ");
INSERT INTO geb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mben gumgir pani ana shogirim, ana rimgirga tuavi ndi garim, mba gumgi gum mbigi vhɨrve, mbe khaŋ tɨgap ana nzuai buni mbararagim, mbe ana shogirim, ana rimgirga tuav thueŋ gangi fhu. ");
INSERT INTO geb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Raa mben, Zisas Fhe Bakɨme phena bɨna vhen kav, gumgi gu mbigi khɨvav mbe nzuai. Ana mbe khɨvav Fhe Bakɨme buni vhuuin mbe nzuav kim, mba Fhe Bakɨme phena gari gumgir pani gum, Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi gum, mben gumgi ruua, mbe ana han zi. ");
INSERT INTO geb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mbe ana han zav ana nzarigi, “Ndu khar nza suaŋ, ndu maam mba ŋkasŋka gum zɨ bakɨme ndigi? The mba ŋkasŋka gum zɨ bakɨmen ndu nɨɨŋgi?” ");
INSERT INTO geb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Mbe mba nzambaren ana muuŋgim, ana mbe ŋgarkarav khaŋ mbe nzuai, “Gu vhɨra nzambara mueŋ nden ki, nde ne ŋgarkarav na suaŋri. ");
INSERT INTO geb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Nde mba Zon Gumgi Ruai Guma, ana mba gumgi gu mbigi ruai, nde ram mbui ndɨkndɨgar ana mba mbui bigeŋ ga ndɨkndɨgi? Ne Heven kega zergi bigeŋ o, ne kha nuianan ki guma wo ndɨkndɨgar mbui bigeŋ?” ");
INSERT INTO geb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Zisas mba nzambaren mbe muuŋgim, mbe nduarira khaŋ wari ga nzuai, “Nza khaŋ muuŋgi tɨgɨv suanga, ‘Ana Hevenan kega zergi bigeŋ ma.’ Nza maaŋ suanga, ana khaŋ nza suanga, ‘Maaŋgim, nde ram muuŋgiap ne khothɨgi fhu?’ ");
INSERT INTO geb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nza vhɨra khaŋ suanga, ‘Ana guma wo ndɨkndɨgar mbui bigeŋ ma.’ Nza maaŋ suanga, kha gumgi za ŋkɨɨr nza segɨrim, nza vhɨzgirga. Mbe khaŋ muuŋgi, mbe za Zon Gumgi Ruai Guma khothɨgi, ana Fhe Bakɨmen kamthooŋ guma ma.” ");
INSERT INTO geb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mbe maaŋ wari ga suaŋgiap, thav khaŋ Zisas ga nzuai, “Nza kaŋgi fhu, Zon Gumgi Ruai Guma maaŋ mba ŋkasŋka ndigap mba gumgi gu mbigi ruai.” ");
INSERT INTO geb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mbe maaŋ nzuaim, Zisas khaŋ mbe nzuai, “Gu vhɨra, gu kha ŋkasŋka gum zɨ bakɨmen na nɨɨŋgim, gu kha ŋaara mbui guma bun nde suaŋgirga fhuvara.” ");
INSERT INTO geb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Zisas mba bunin mba Fhe Bakɨme phena gari gumgir pani mben gumgi ruu ga suaŋgiap, mbaram buna mueŋ vhunama dav khaŋ mba gumgi gu mbigi ga nzuai, “Guma mbe wain mɨna mben pargi. Ana mba wain mɨnan pargiap, ana ndim gumgi mbari farve khɨngi. Ana mba wain mɨnan mbe farve khɨngiap khaŋ mbe nzuai, ‘Nde na wain mɨna ganɨv, ana shɨgar muuŋri. Nde ana shɨgar muunga, nen vhez nde wari ndiv nder thueŋ ndirga, gu wo thueŋ ndirga.’ Ana maaŋ mbe suaŋgiap, mba wain mɨnan mbe farve khɨngip, ana nduara ŋgɨp, saman ki ŋanen harigi ŋgun ŋgɨgɨp, tuga mpeeŋra mba ŋanen kɨrga. ");
INSERT INTO geb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ana vugap kim, mba wain vhɨgi mbarigi tugar, ana mbaram won ŋaara guma mbe sarigim, ana mba wain mɨna garav ana shɨga mbui gumgi han vui. Ana khueŋ vuzvugi, mbe mba ana nderen wain vhɨgi ana nɨɨnga. Ana ne suaŋgiap, ana sarigim, ana vuim, mba wain mɨna garav ana shɨga mbui gumgi, mbe ana ŋaara guma shogiap, fhura ana sarigim, ana taagia vugi. ");
INSERT INTO geb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ana vugim, mba mɨna namkam, mbaram harigi ŋaara guma mbe sarigim, ana vugi. Ana vugim, mbe mbara ana muuŋgi. Mbe ana mbergi fhu. Mbe vhɨra muunga tɨvar ana muuŋgi fhuvara. Mbe ana shogiap, tɨva mbatɨga guarara ana muuŋgiap, fhura ana sarigim, ana taagia vugi. ");
INSERT INTO geb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ana won ŋaara guma phunini ga sarigim, mani vugim, mbe maaŋ mani ga muuŋgim, ana thav harigi ŋaara guma khegene sarigim, ana vugi. Ana vugim, mbe guigira hor mbatɨgar ana muuŋgim, ana ŋama rimgim, mbe ana fegap mba mɨna bɨna kɨra khɨngi. ");
INSERT INTO geb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Mbe maaŋ ana muuŋgim, mba mɨna namkam thav khaŋ wo nzuai, ‘Gu ntigem ram muuŋrie?’ Ana maaŋ suaŋgia thav khaŋ nzuai, ‘Gu ntigem won kama gɨrgɨra sararga, gu guigira ana vuzvugi. Gu ndɨkndɨgi, mbe maaŋ muuŋgip ana buni mbarararga thi?’ ");
INSERT INTO geb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ana ne suaŋgiap, mbaram won kama sarigim, ana vui. Ana vuim, mba mɨna garav ana shɨga mbui gumgi ana garim, ana zim, mbe khaŋ wari ga nzuai, ‘Ai, mbu zi guma, ana ndia rimgirga, ana zɨv, ana za won ndia bigi ndigirga. Nde zɨv, nza ana shogirim, ana rimgirim, nza za kha mɨna wari mbuiarga.’ ");
INSERT INTO geb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mbe maaŋ suaŋgiap, ana gari ana zim, mbe mbaram ana fegap, mba mɨna bɨna kɨra khɨngiap, ana shogim, ana rimgi. “Nde ndɨkndɨgi, mba mɨna namkam, ana ram mbui tɨvar mba gumgir muuŋgirie? ");
INSERT INTO geb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ana zɨv mba mɨna garav ana shɨga mbui gumgi, ana za mbe shogɨrim, mbe vhɨzgirga, ana mba wain mɨnan harigi gumgir nɨɨŋgirga.” Zisas ne nzuaim mba gumgi gu mbigi ne mbararagiap khaŋ nzuai, “Maaŋ muuŋgi bigɨn thueŋ hɨ thari!” ");
INSERT INTO geb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mbe maaŋ nzuaim, Zisas purara mbe garav kha nzambaren mbe muuŋgi, “Nde maaŋ nzuai, mbe thaŋ nzuav kha kameŋ khergim, ne Fhe Bakɨme buni ki gavan ki? Mba kameŋ khaŋ nzuai, ‘Mba kɨm mba pheni ga mbui gumgi ana garim, ana mbatɨgim, mbe ana ndi mbur khɨngi. Mba kɨm ana ntigem mba phena suirigim, ana thɨgi.’ ");
INSERT INTO geb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ntigem mba kɨma tɨɨiri gumgi, mbe za phaviregɨrga. Mba kɨm, ana vhɨra, ana guma the tɨɨirɨgɨrga, mba kɨm ana guigira mba guman muuŋgirim, ana za phaviregɨp mparavgirga.” ");
INSERT INTO geb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Zisas mba bunin mbe nzuaim, mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi gum mba Fhe Bakɨme phena gari gumgir pani, mbe mba buni mbararagiap khaŋ nzuai, “Nza kaŋgi, Zisas nzara vhunama sav mbur nzuai.” Mbe ne suaŋgiap, mba tugara khavgiap, ana suigɨr zav mbui. Mbe ana suigɨr zav mbuav, mbe vhɨra mba gumgi gu mbigin vhɨrver rivgiav wari thagi. ");
INSERT INTO geb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mba tugen mba Fhe Bakɨme rotu gari gumgir pani gum mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi, mbe tɨkhɨngira Zisas gari. Mbe ana garav, mbaram gumgi mbari ga sarigim, mbe zav puskarav kɨɨv, ana gari. Mba kɨɨv ana gari gumgi, mbe khueŋ puskai, mbe guigira Fhe Bakɨme buni zɨn ŋgɨrgeŋ vuzvugi. Mbe khueŋ nzuav zegi, mbe buna thuen ana mpararim, ana pham buna thueŋ suaŋgirim, mbe mba buneŋ ga suaŋv ana suaŋv, ana ndim wari wo guman pana vhari farve khɨngirim, ana Zisas ndi suaŋgirga. ");
INSERT INTO geb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mbe zegap, kav kha nzambaren ana muuŋgi, “Guman Rum, nza kaŋgi, ndun buni nzerara, ndu nzerara bunin vhuuiŋra kha gumgi gu mbigi khɨvav mbe nzuai. Ndu vhɨra kha tɨvi ga mbui, ndu mba nzuai buni, ndu ntan za kha gumgi ga nzuai. Ndu zɨ ki gumgi hiav, zɨ ki fhuv gumgi hiav, kha bunin mbe nzuai fhuvara. Ndu vhɨra buni guarira kha gumgi gu mbigi ga nzuav Fhe Bakɨmen tɨvir mbe khɨvi.” ");
INSERT INTO geb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mbe nen ana suaŋgiap ana nzarigi, “Ena, ndu ram mbui ndɨkndɨga mbui? Nzan tɨv ram nzuai? Nza ŋkɨɨa ndiv Roman gari guman pan Sisar nɨɨnga o, fhu?” ");
INSERT INTO geb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mbe mba khesharigi mparmparen Zisas ga mbuim, Zisas mbe kaŋgi. Ana mbe kaŋgiap, mbaram khaŋ mbe nzuai, ");
INSERT INTO geb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nde mba kɨma raraŋ thueŋ ndigip, zɨv na khɨva.” Ana ne nzuaim, mbe mueŋ ndiga zav ana khɨvigim, ana khaŋ mbe nzuai, “Kha kɨma raren ki guman tum gum zɨ, ni the nɨɨni?” Ana ne nzuaim, mbe khaŋ ana nzuai, “Ana Sisar zɨ gum tum ma.” ");
INSERT INTO geb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mbe maaŋ nzuaim, ana khaŋ mbe nzuai, “Maaŋ muuŋgim, Sisar bigɨn, nde ana nɨɨŋri. Maaŋ muuŋgip, Fhe Bakɨmen bigɨn, nde ana Fhe Bakɨmen nɨɨŋri.” ");
INSERT INTO geb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mba gumgi, mbe kha gumgi gu mbigi Zisas phorgɨ kɨrim, mbe ana suaŋv suanga buna thueŋ ga suaŋv ana panɨ za mbui. Mbe ne nzuav ana mparav ragi. Mbe ana nzarigi nzambareŋ ana ne ŋgarkarav mbe suaŋgim, mbe ne ga nzuav ŋgava mbatɨga muuŋgiap, mbe buna thueŋ suaŋgi fhuvara, mbe fhura ki. ");
INSERT INTO geb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mba tugen Sadusiŋ gumgi mbari, mbe bigɨna mueŋ ga nzuav Zisasan nzan zav ana han zi. Mba Sadusiŋ, mbe khaŋ nzuai ntɨɨri ma, “Guma rimgia taagia khavi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Mbe zav khaŋ Zisas ga nzuai, “Guman Rum, Moses nza nzuav khergi kameŋ khaŋ nzuai, ‘Maaŋ muuŋgip, guma the mbiga then tɨgɨp kɨv, mba mbik ana gon tara the tegi fhu, mba guma fhura rimgi. Mba guma rimgirga, ana ŋguk mba mbigar tɨgɨrga, ana mba mbigar tɨgɨp tegɨrga tari, nta mba ana fek rimgi, nta ana zararga.” ");
INSERT INTO geb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mbe nen ana nzuav khaŋ ana nzuai, “Fhum harathɨgi fegi gum ŋgugi kegi. Mben fega rum fharav mba mbiga tɨgi. Ana mba mbiga tɨgim, mba mbik, ana gon tara the tegim, ana rimgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ana rimgim, ana thɨgine anan ŋguk, ana mba mbiga tɨgi. ");
INSERT INTO geb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ana ana tɨgap, ana vhɨra rimgi. Ana rimgim, mba fegɨra thɨgine, ana thɨgine ana tɨgi. Mbe mbara mbuav, mba harathɨgi fegi gum ŋgugi, mbe za mba mbiga tɨgap kegi. Mbe za mba mbiga tɨgav kim, ana za mbe the gon tara the tegim, mbe vhɨzgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mbe za vhɨzgim, mba mbik vhɨra rimgi. ");
INSERT INTO geb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Maaŋ muuŋgip, zumgum mba vhɨzgi gumgi mbe taagi khavɨrga tugar, mba mbik then muuŋ kɨrie? Ndu kaŋgi mba harathɨgi gumgi, mbe za mbiga bavira tɨgap kegi.” ");
INSERT INTO geb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Mbe maaŋ nzuaim, Zisas khaŋ mbe nzuai, “Nde ntige kha tugen kha nuianan ki gumgi gu mbigi, nde mani gum mburi wari ga rɨgi. ");
INSERT INTO geb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mba Fhe Bakɨme taagi ndigi gumgi gu mbigi, mbe taagia khavgip, mbe mba tugen Fhe Bakɨme phorgɨp Hevenan kɨrga, mbe warir rɨgɨrga fhu. ");
INSERT INTO geb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mbe khaŋ muuŋgiap, mbe vhɨra wom rɨmɨnga fhu. Mbe Fhe Bakɨme enseri farar muuŋgip kɨrga. Mbe vhɨzi, Fhe Bakɨme taagia mbe khavim, mbe ana tari ma. ");
INSERT INTO geb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nde nza za kaŋgi, Moses vhɨra khuen nza khɨvigi. Mba vhɨzgi gumgi, mbe taagia khavi. Ana mba kha bisaneŋ vhav ne shigi ne neŋgap khaŋ suaŋgi, ‘Guma Bakɨme, ana Abraham, gum Aisak, Zekop, ana mben Fhe Bakɨme ma.’ ");
INSERT INTO geb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nza maaŋ muuŋgiap gangiap, kaŋgi, Fhe Bakɨme ana vhɨzgi gumgir Fhe Bakɨme fhuvara. Ana mba zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigi gumgir Fhe Bakɨme ma. Mba Fhe Bakɨmen nɨman ki gumgi gu mbigi, mbe vhɨzgirga fhu. Mbe zazera mbara muuŋgip kɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Zisas mba bunin mbe nzuaim, mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgi mbari mba buni mbararagiap, khaŋ ana nzuai, “Guman Rum, ndu buni nzerara.” ");
INSERT INTO geb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mbe maaŋ suaŋgim, mba gumgi gu mbigi harigi buna thueŋ phorgɨv Zisasan nzangen rivgi. ");
INSERT INTO geb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Zisas mba bunin mba gumgi gu mbigi ga nzua vov, kha nzambaren mbe muuŋgi, “Ram muuŋgi ne nzuav mbe khaŋ nzuai, Fhe Bakɨme taagi kha nuianan ki gumgi gu mbigi ndir zav farasarigi guma, ana Devitan Kam ma? ");
INSERT INTO geb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Devit nduara kha kameŋ khergi, ne kha gavar ki. Mba gava zɨ khare, Ŋgavi Ki Gap. Devit ne kherav khaŋ suaŋgi, ‘Fhe Bakɨme khaŋ na Guma Bakɨme nzuai, “Ndu na guva haren perav kɨrim, gu ndun pana gumgi ndim ndun ŋkarve piiŋ khɨngirga.” ’ ” ");
INSERT INTO geb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Zisas ne mbe nzuav khaŋ mbe nzuai, “Devit nduara mba guma ana Guma Bakɨmen anan kaai. Ana mba kakaman anan muuŋvra kɨrim, ana ram muuŋgip ana kam kɨrie?” ");
INSERT INTO geb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mba gumgi gu mbigi vhɨrve Zisas nzuai buni mbararavra kim, ana khaŋ wo phorga rui gumgi ga nzuai, ");
INSERT INTO geb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Nde mba Zudaiŋ tɨvi vhuuiŋ kaŋgi gumgir rɨvɨri. Mbe khaŋ mbui, mbe shagi mpeeiŋra sharigi rurgane vuzvugi. Mbe khueŋ vuzvugi, mbe mba phogi ga vhui ŋanin ŋgɨrim, mba gumgi gu mbigi mbe ganɨv, za mben ndikndigɨp ‘Manera’ gum ‘Ŋkotuguraagen’ mben nɨɨnga. Mbe vhɨra, mbe Fhe Bakɨme buni mbararagi phenin, mbe zɨ ki gumgi piigi mpirmpirɨgira pigɨrgeŋ vuzvugi. Mbe vhɨra shaa bakɨvi ga mbui tugir, mbe vhɨra zɨ ki gumgi piigi mpirmpirɨgira pigɨrgeŋ vuzvugi. ");
INSERT INTO geb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mbe vhɨra mani rimgi nzɨri mbigi, mbe mbe guguigiap mbe pheni ndi. Mbe maaŋ mbuav fhura shɨshɨgap Fhe Bakɨme phorga nzuav buni mpeeiŋ nzuai. Mbe maaŋ mbui, mbe zumgum Fhe Bakɨme za kha nuianan ki gumgi gu mbigi muuŋgi tɨvi mbatɨgi ga suaŋv mbe suanga tugar, mbe guigira simtɨga bakɨme ndigirga.” ");
INSERT INTO geb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Zisas Fhe Bakɨme phena bɨna vhen kav garim, ŋkɨɨa vhɨrve ki gumgi gu mbigi, mbe zav Fhe Bakɨme ndɨɨi ŋkɨɨa ndim, mba ŋkɨɨa ndi sui kovsɨga sui. ");
INSERT INTO geb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ana kav garim, mana rimgi mbiga saa mbe zav kɨɨma raraŋ hɨva bisaŋ mpuneni ndiv mba ŋkɨɨa ndi sui kovsɨga khɨngi. ");
INSERT INTO geb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ana ni ndi khɨngim, Zisas ana gangiap khaŋ nzuai, “Gu guigira nde nzuai, kha mana rimgi mbigar saa, ana kha kovsɨga khɨngi ŋkɨɨa, nta guigira kha ŋkɨɨa vhɨrve ki gumgi gu mbigi vhɨrve kha kovsɨga suegi ŋkɨɨa kambarigi. ");
INSERT INTO geb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kha gumgi gu mbigi, mbe ŋkɨɨa vhɨrve kav, mbe mbari ndiga zav khar suegi. Kha mbik, ana zakɨra fhuvara, ana mba wandi mba vhezɨrga nɨɨne, ana za ne ndiga zav khar khɨngi.” ");
INSERT INTO geb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Zisas phorga rui gumgi mbari, mbe Fhe Bakɨme phena garav khaŋ nzuai, “Mbe ŋkɨɨr vhuuiŋra ndigap, kha gumgi gu mbigi fhura Fhe Bakɨme ga nɨɨŋgi bigir vhuuiŋra, mbe ntan kha phena sɨɨŋgi.” Mbe maaŋ nzuaim, Zisas khaŋ mbe nzuai, ");
INSERT INTO geb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Gu ntige nde khar gari bigi, gu nta bun nde suanga. Nde khar gari bigi, zumgum tuga the hɨgɨrga, kha ŋkɨɨ nta khara muuŋgip wari tɨɨrin ŋaŋgi kegɨrga tuktɨgi fhuvara. Zakɨra fhuvara! Mbe zumgum za nta shogɨp nta phɨrɨv, nta fuv nɨɨŋa suegɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Zisas nen mbe nzuaim, mba ana phorga rui gumgi, mbe kha nzambaren ana muuŋgi, “Guman Rum, mba farfa maaŋgi tugar hɨrie? Ram mbui khesharigi bigi hɨgɨrim, nza gangip kaŋgirga, mba bigi hɨrga tuk han mbarigi?” ");
INSERT INTO geb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Mbe maaŋ nzuaim, Zisas khaŋ mbe nzuai, “Nde warir rɨvɨri. Nde muuŋv kɨrim gumgi vhɨrve zɨv nde guigirga. Mba tugivigen gumgi vhɨrve mbe zɨv, na zɨ zitɨv khaŋ suanga, ‘Gu ara khare.’ Mbe maaŋ suaŋv khaŋ suanga, ‘Tuk ntige han mbarigi.’ Mbe zɨv maaŋ suaŋrim, nde mbe zɨn ŋgɨ thari. ");
INSERT INTO geb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Zumgum, ŋguia bakɨvi thari wari phorgɨv shogɨrga, ŋguia bakɨvi thari warira daanga. Nde rɨvɨv gori muuŋ thari. Mba khesharigi bigi, nta fharav hɨrga bigi ma. Mba khesharigi bigi nta hɨrga, kha nuian za vhɨzɨrga tuk vhemkora hɨgɨrga fhuvara.” ");
INSERT INTO geb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ana mba bunin mbe nzua vov khueŋ phorga mbe nzuai, “Harigi ŋguia harigi ŋguia phorgɨv shogɨrga, harigi ntɨɨri harigi ntɨɨri phorgɨv shogɨrga. ");
INSERT INTO geb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nde mbarararga, khɨmkhɨgi bakɨvi guarira kha nuianan muunga. Nde mbarararga, ŋgui thari tuga mbatɨga ndiv mba tivɨv thir vhɨzɨrga, rɨmrɨɨ mbatɨgi ŋguia tharir hɨrga. Nde ganɨnga, kha buivar harigi khesharigi bigi guarira hɨrga, nde vhɨra kha buivar harigi khesharigi bigi ganɨv, nde guigira rivgirga. ");
INSERT INTO geb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Gu khar nde nzuai bigi, nta zumgum hɨrga, mbe fharav nden suigɨ ŋgɨv tɨvi mbatɨgi guarira nden muunga. Mbe Zudaiŋ, mbe nde ndigi ŋgɨp, Fhe Bakɨme buni mbararagi pheni vhen ŋgirɨp, nde suaŋ suaŋv, nde ndi bɨna surga. Mbe vhɨra nde na zɨn vuim, mbe na zɨ mbevɨrga ne suaŋv, nde ndi ŋgɨp wari won ŋgui gari gumgir pani nɨman fɨv, nde suaŋv mbe suaŋv, mbe vhɨra wari won gumgir pani nɨman nde suaŋv suanga. ");
INSERT INTO geb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mbe maaŋ nden muunga, mbe nde Fhe Bakɨme bunin vhuuiŋ bun mbe suanga thɨm, mbe ana fhɨrgi, nde mba tugar Fhe Bakɨme bunin vhuuiŋ bun mbe suaŋri. ");
INSERT INTO geb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mbe maaŋ muunga, nde ndɨkndɨk bavira muuŋri. Nde wari ga suaŋ gorɨv mbe suanga buni ga suaŋv ndɨkndɨgi vhɨrver muuŋ thari. ");
INSERT INTO geb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ne khaŋ muuŋgi, gu nduara ndɨkndɨgi vhuuin nden nɨɨŋrim, nde mbe phorgɨp suanga. Nde mbe phorgɨv suanga, mba nde phorga nzuai ntɨɨri, mbe za nde nzuai buna thueŋ daaŋgirga tuktɨgi fhuvara, mbe vhɨra za nde nzuai buna thueŋ mbevarga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Kha tɨv vhɨra nden hɨrga. Nden ndegi gum, ndegmbori, nden fegutari, nde phorge regi ntɨɨri, nden kɨvntogi, mbe vhɨra nde thuuŋ domdorɨv, nde suaŋv nde pana gumgi ga suaŋrim, mbe nde thari shogɨrim, nde vhɨzgirga. ");
INSERT INTO geb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kha nuiana gumgi, mbe za panan nde kegɨrga. Nde khaŋ muuŋgi, ne nzuav, na zɨ nden ki. ");
INSERT INTO geb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nde mbarara! Nden pana rɨgɨna the sigip mbar rɨgɨrga tuktɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nde thɨgɨp havhargip wari kɨv, nde maaŋ muuŋgip zazera mbara muuŋgip kɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Zisas kha bunin mbe nzua vov, wom khaŋ mbe nzuai, “Nde ganɨri, ntari ga mbui gɨɨtɨvi zɨv Zerusarem bɨna gani behuigip wari kɨrim, nde gangip kaŋgiri, mba ŋgu bakɨme mbatɨgɨrga tuk han mbarigi. ");
INSERT INTO geb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mba tugar mba Zudia fhain ki gumgi gu mbigi, mbe rɨv mba mbɨkshɨɨ ndari. Mba Zerusareman ki gumgi gu mbigi, mbe vhɨra rɨv harigi ŋanen ŋgegɨri. Mba ŋgu bakɨme thav kɨrar ki gumgi, mbe mba ŋgu bakɨme vhen ŋgirɨ thari. ");
INSERT INTO geb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mba Fhe Bakɨme buni vhuuiŋ ki gap ne suaŋgi. Mba tugen Fhe Bakɨme mba Isreran ki gumgi gu mbigi muuŋgi tɨvi mbatɨgi vhezar mben nɨɨn saŋv mbe suanga. Mba tugen mba Fhe Bakɨme buni vhuuiŋ ki gavar ki kameŋ za guigira hɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Gu guigira mba ndavir ki mbigi gum mba tari tegav tirar nta ndɨɨi mbigi, gu guigira mben kora muuŋgi. Gu khaŋ muuŋgi ne nzuav, mba tugen simtɨga bakɨ guarara Isreran hɨgɨrga. Mba tugen Fhe Bakɨmen ndav shirɨ kha Isreran ki gumgi gu mbigin hɨrga. ");
INSERT INTO geb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mba tugen kha Isreran ki gumgi gu mbigi, mben pani gumgi, mbe zɨv, mbe thari fhɨri gorɨrim, mbe vhɨzgirga. Mbe thari ndiv za kha nuianan ki ŋguir ŋgɨrim, mbe mben ŋaara gumgi kɨrga. Mba harigi fhain ntɨɨri maaŋ mben muuŋv, mbe vhɨra Zerusarem ŋgu bakɨme ndigip, guigira ana farfagirga. Mbe ana farfagip kɨvkɨrim, Fhe Bakɨme mba mbe sarigi tuk vhɨzgirga.” ");
INSERT INTO geb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Zisas mba bunin mbe nzua vov wom khaŋ mbe nzuai, “Nde vhɨra ganɨnga, harigi khesharigi bigi, nta ra gum, kɨni gum, ŋkaar hɨrga. Kha nuianan ki gumgi gu mbigi, mbe ndɨkndɨgi guigira mbatɨgirga. Mbe mbarararga mbasɨk phurira shogɨp, phɨrirɨv khɨkhɨm bakɨme hɨrga, mbe guigira rɨvɨrga. ");
INSERT INTO geb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kha nuianan ki gumgi gu mbigi vhɨrve, mbe kha nuianan hɨr za mbui bigi vhɨrve ga ndɨkndɨgɨp, mbe guigira rivgip, mben rɨmgi hiinga. Mbe khaŋ muuŋgiap, kha buivar ki bigi havhari, nta za vhasvharga. ");
INSERT INTO geb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mbe mba tugen kha nuianan ki gumgi gu mbigi, mbe zam Fhe Bakɨme Guma Guara ganɨrim, ana Hevenan kegɨp buiva hurar perav, won ŋkasŋka gum wo ŋkasŋkan vhava ŋaara bakɨme phorgɨp zirɨrga. ");
INSERT INTO geb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nde mba tugen mba bigi ganɨrim, nta hɨrga, nde khavɨv thivgip pani ragirga, ne khaŋ muuŋgi, Fhe Bakɨme taagi nde ndirga tuk han mbarigi.” ");
INSERT INTO geb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Zisas mba buni mbe nzua vov, wom kha buneŋ vhunama dav khaŋ mbe nzuai, “Nde mba fik khage ganɨv, za kha khira ganɨri. ");
INSERT INTO geb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nde nta ganɨnga, nta khovɨrga, nde kaŋgi, ra thivɨr za mbui. ");
INSERT INTO geb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nde mba tɨvara, nde kha bigi ganɨrim, nta hɨrim, nde kaŋgiri, Fhe Bakɨme won gumgi gu mbigi ganɨrim, mbe ana piin kɨrga tuk han mbarigi. ");
INSERT INTO geb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Gu guigira khar nde nzuai, nde ntige vhuuŋgia khar ki ntɨɨri, nde vhɨzgirga fhuvara. Nde khara muuŋgip kɨv za mba bigi ganɨrim, nta hegɨrga. ");
INSERT INTO geb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kha nuian gum buip za vhɨzgirga. Na bunin vhuuiŋ, nta vhɨzgirga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Zisas mbe nzua vov wom khaŋ mbe nzuai, “Nde tuituigira wari ganɨri. Nde muuŋv kɨv kha nuianan ndikndigi bigira suaŋv muuŋv, pani havhargip, pharar havharin mbɨv, ŋanŋanɨv kɨrga. Nde vhɨra maaŋ muuŋv kɨv, nde wari won fhavira kurkurigi bigi ga suaŋv thagi nen muunga. Nde mba khesharigi tɨvir muuŋv kɨrga, mba khesharigi tɨv nde mbevarim, nde ŋgirgɨp kɨrga. Fhe Bakɨme nden hɨrga tuk, ana vhemkora nden hɨgɨrga. Mba tuk, ana mba sɨk vhaaŋ thoon vergim, vhaaŋ ana suirigi tɨvar nden muuŋgirga. ");
INSERT INTO geb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Mba tuk ana ndera hɨrga fhuvara, mba tuk ana za kha nuianan ki gumgi gu mbigin hɨrga. ");
INSERT INTO geb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nde maaŋ muuŋgip, nde zazera tuituigira wari ganɨv kɨri. Nde kɨv zazera Fhe Bakɨme phorgɨv suaŋrim, anan ŋkasŋkar nden nɨɨŋrim, nde kɨri. Nde maaŋ muunga, ana ŋkasŋkar nden nɨɨŋrim, nde kha hɨrga bigi, nta nden hɨrim, nde Fhe Bakɨme Guma Guara nɨman thivgiv havhargirga.” ");
INSERT INTO geb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Zisas maaŋ kav kha bunin mbe nzuav, ana zazera rari tugɨratɨgav, Fhe Bakɨmen phena bɨna vhen kav Fhe Bakɨme bunin vhuuin gumgi gu mbigi khɨvav mbe nzuai. Ana rarir maaŋ mbuav, ana mbarir ana ndav vov, Oriv mbɨkshɨma kui. ");
INSERT INTO geb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ana maaŋ kuv Fhe Bakɨme Phena zerim, mba gumgi gu mbigi, mbe khaŋ mbui. Mbe mbarɨrera khavav Fhe Bakɨme Phena zav ana nzuai buni mbararagi. ");
INSERT INTO geb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Zisas Fhe Bakɨme ŋaara mbua ruav kim, mba Vhuui Fhuv Viktuma Pi Shama Bakɨmen muunga tuk hɨgi. Mba shama bakɨme zɨ khare, Pasova. ");
INSERT INTO geb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mba shama bakɨme tuk hɨgim, mba Fhe Bakɨme rotu gari gumgir pani gum, mba Zudaiŋ tɨvir vhuuiŋ kaŋgi gumgi, mbe kha gumgi gu mbigir rivgiap Zisas shogirim ana rimgirga tuavi ndi gari. ");
INSERT INTO geb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mbe ana shogɨrga tuavi ndi garim, Satan mbaram zav Zudas ndava vhen vergi. Mba guma, mbe kha zɨn vhɨra ana kaai, Iskariot guma ma. Ana vhɨra mba Zisas farasarigi 12 thɨgi ŋaara guma mbe ma. ");
INSERT INTO geb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Satan ana ndava vhen vergap, ana ndava khavgim, ana mbaram vov mba Fhe Bakɨme rotu gari gumgir pani gum mba Fhe Bakɨme Phena gari gɨɨtɨvi gumgir pani, ana mbe han vugap, mbe phorga nzuai. Ana Zisas ndim, mbe farve khɨngir zav tuavi ndi garav mbe phorga nzuai. ");
INSERT INTO geb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Zudas vov, mbe phorga nzuaim, mbe ana garav, guigira ne nzuav ndikndigap khaŋ ana nzuai, “Nza ŋkɨɨar ndun nɨɨnga.” ");
INSERT INTO geb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Mbe ŋkɨɨar Zudasan nɨɨn zav nzuaim, ana ne vuzvugi. Ana ne vuzvugiap, mbaram Zisas ndim mben farve ga surga tuavi ndiv gari. Ana tuavi ndi garav khuen rargi, ana ganɨnga, mba gumgi gu mbigi vhɨrve Zisas phorgɨv kɨrga fhu, mba tuk ana tugar vhuuŋ ma. ");
INSERT INTO geb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Zudas mbe phorga suaŋgiap kim, mba Vhuui Fhuv Viktuma Shama Bakɨme pi tuk hɨgi. Mba shama bakɨme tugar, mba Isreran ki gumgi gu mbigi, mbe sipsiva ŋguga shogip, anan mbɨv, mba fhum Fhe Bakɨme mben pheni ŋgɨɨap mba Idzɨvin tari baari shogim, mbe vhɨzgim, mba Isrerin tari baari, mbe nzerara kegi, mbe ne ndɨkndɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Mba tuk hɨgim, Zisas mbaram, Pita gum Zon ga sarav khaŋ mani ga nzuai, “Ŋko ŋgɨ nza kha Pasova shaman mbɨrga bigi bevahɨ.” ");
INSERT INTO geb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ana maaŋ mani ga nzuaim, mani ana nzarigi, “Ndu maaŋgi ŋaneŋ vuzvugi, ŋka ŋgɨp mba bigi bevahɨrie?” ");
INSERT INTO geb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mani maaŋ nzuaim, ana khaŋ mani ga nzuai, “Ŋko mbarara, ŋko ŋgɨp mbu ŋgu bakɨmen vhen ŋgirɨp, ŋko tuavar guma then purarga. Mba guma nda bakɨme mbɨ khɨgɨp phɨgar ndarav ŋgɨrga. Ŋko mba guma gangip, ŋko ana phorgɨ ŋgɨp, ana mba veri phen, ŋko ana phorgɨp mba phena vhen ŋgirɨri. ");
INSERT INTO geb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ŋko ana phorgɨv mba phena vhen ŋgirɨp khaŋ mba phena namkama suaŋri, ‘Ndɨkndɨgi vhuuin nza khɨvi Guma Rum khaŋ ndu nzuai, “Gu wo phorga rui gumgir kov Pasova shaman mbɨrga ŋaneŋ mba?” ’ ");
INSERT INTO geb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ŋko maaŋ ana suanga, ana mba phenan vun ki ŋanen ŋko khɨvarga, mba ŋanen pigav mba pi kaa gum mpirmpirɨgi ki. Ŋko mba ŋanen fhura mbara bevahegɨri.” ");
INSERT INTO geb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Zisas maaŋ mani ga suaŋgiap, mani ga sarigim, mani vov garim, ana mba mani ga suaŋgi bigi, nta mbara muuŋgiap hɨgim, mani mbaram fhura mbe mbɨrga mbara bevahegi. ");
INSERT INTO geb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mani mba bevahegim, mba Pasova shaman mbɨrga tuk hɨgim, Zisas mbaram wo farasegi 12 thɨgi ŋaara gumgir kov, mbe vov mba phenan vegap, Zisas mben kov mba pi kaa ga piigi. ");
INSERT INTO geb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mbe piigim, Zisas khaŋ mbe nzuai, “Gu guigira nde phorgɨp kha Pasova shaman mbɨrga ne vuzvugi. Gu nde phorgɨv ana mbegɨv, gu zaa bakɨme ndirga. ");
INSERT INTO geb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Gu nde nzuai, gu wom nde phorgɨv kha Pasova shaman mbegɨrga tuktɨgi fhu. Gu khara muuŋgip kɨrim, Fhe Bakɨme mba sarigi tugar ana guigira kɨrar hɨgɨp, won gumgi gu mbigi ganɨrim, mbe ana piin kɨrim, gu mba tugen gu taagip kha Pasova shaman mbɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ana maaŋ mbe suaŋgiap, mbe pav, ana thama mbɨ mbe ndigap, Fhe Bakɨme ndikndigap ana phorga suaŋgiap, khaŋ mbe nzuai, “Nde kha thama mbɨ ndigip, ana warir nɨɨŋv anan mbɨ. ");
INSERT INTO geb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Gu nde nzuai, gu zumgum wom kha wain karɨga vhɨgar mbɨn mbegɨrga tuktɨgi fhu. Gu fhura kɨrim Fhe Bakɨme guigira kɨrar hɨgɨp won gumgi gu mbigi ganɨrim, mbe ana piin kɨrga tuk hɨgɨrga. Mba tuk hɨgɨrga, gu taagip kha wain karɨga vhɨgar mbɨn mbɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ana maaŋ mbe suaŋgiap, mbaram viktuma ndigap, ana nzuav Fhe Bakɨme ndikndigap ana phorga suaŋgiap, ana phɨrav, mbe ndɨɨav khaŋ mbe nzuai, “Khe na sɨk ton ma. Fhe Bakɨme nan nde ndɨɨi, gu nde suaŋv zaa ndirga. Nde ana mbɨv na ndɨkndɨgɨri.” ");
INSERT INTO geb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mbe mba viktuma mbegim, ana mbaram thama mbɨ mbe ndigap mba tɨvara muuŋgi. Ana mba thama mbɨ mbe ndɨɨv, khaŋ mbe nzuai, “Kha thama mbɨ, ana na vɨzɨn ma. Fhe Bakɨme fhum taagi nde ndir zav suaŋgi tɨvar kameŋ ma. Na vɨzɨn nde suaŋv siv kha nuiana suarga.” ");
INSERT INTO geb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ana nen mbe suaŋgiap, mbaram khaŋ mbe nzuai, “Mba na thuuŋ dorgɨp na suaŋv kama shɨrarga guma, ana won farven na farve phorgap kha kaa khɨngi. ");
INSERT INTO geb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kha kameŋ Fhe Bakɨme fhum suaŋgi kameŋ ma. Fhe Bakɨme Guma Guara, ana Fhe Bakɨme fhum ana nzuav khɨrgi tuav, ana mba tuavra zɨn ŋgɨgɨrga. Mba ana thuuŋ dorgap ana nzuav kama shɨrav ana ndim ana pana gumgi farve khɨngi guma, gu guigira ana kora muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Zisas ne nzuaim, ana mba farasegi 12 thɨgi ŋaara gumgi ne mbararagiap, tamtam warir nzav, khaŋ wari ga nzuai, “Ai, the mba khesharigi tɨvar ana muuŋgirie?” ");
INSERT INTO geb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Zisas farasegi 12 thɨgi ŋaara gumgi mbe khueŋ nzuav wari daai, “The mbe rɨgar zɨ ki.” ");
INSERT INTO geb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Mbe ne nzuav wari daaim, Zisas khaŋ mbe nzuai, “Nde khueŋ kaŋgiri, harigi ŋguia vhɨrver ki gumgi gu mbigi gari gumgir pani, mbe zɨ bakɨme kav, mbe guigira won gumgi gu mbigi gari. Mbe guigira mbe garav, mbe vhɨra khueŋ vuzvugi, mben gumgi gu mbigi kha ndɨkndɨgar mbe mbui, mbe tɨvir vhuuiaŋ mbui gumgi ma. ");
INSERT INTO geb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Gu nde nzuai, mba khesharigi tɨv nden kɨ thari. Mba tɨv mbar kɨri. Guma the nden rɨgar zɨ kɨr za mbui, mba guma ana za wo mbevav, ana nde zɨn hɨgi ŋgugage farar muuŋgip za nden piin kɨri. Nde rɨgar guma nden guman pan kɨr za mbui, ana za nden ŋaara guma ga gegɨp, za nden kurkurari. ");
INSERT INTO geb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nde vhɨra khueŋ ndɨkndɨgɨ, the zɨ bakɨme ki? Mba perav mba pi guma o, mba mba ndiga zav ana ndɨɨi guma? Fhuvara! Mba perav mba pi guma, ara zɨ bakɨme ki guma ma. Gu ntigem nden rɨgar kav gu maaŋ mbui fhu. Gu fhura nden ŋaara guma ga gegap fhura nden kurkurigi. ");
INSERT INTO geb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Gu nde phorga kim, nan mpari bigi nan him, nde na thagi fhuvara, nde na phorga ki. ");
INSERT INTO geb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nan Ndia, ana zɨ bakɨmen na nɨɨŋgim, gu guman pan ki. Gu ntigem mba zɨ bakɨmen nde nɨɨŋgi, nde gumgir pani kɨrga. ");
INSERT INTO geb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nde vhɨra, gu nden guman pan kɨrga, nde na phorgɨp kaar perav mbɨrga. Gu nde suaŋrim, nde ŋgui vhɨrve gari gumgir pani piigi mpirmpirɨgir piigip kɨrim, gu kha 12 thɨgi Isrerin shɨgi ndan nde farve khɨngirim, nde mbe ganɨnga.” ");
INSERT INTO geb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Zisas mba bunin mbe suaŋgiap mbaram khaŋ nzuai, “Saimon, Saimon, ndu mbarara! Nde na khothivim, Satan khaŋ nde suaŋgi, ‘Gu guigira mben mpararga.’ Ana guigira nden panɨ zav vov Fhe Bakɨmen nzarigim, ana ana khɨrigi. ");
INSERT INTO geb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ana maaŋ nzuaim, gu ndu nzuav Fhe Bakɨme phorga suaŋgi. Ndu na khothɨgi tɨv rɨ thari. Ndu maaŋ muuŋgip taagi dorgɨp, na han zɨgɨp, ndu won fegi gum ŋgugir kurarim, mbe thɨgɨ havhargiri.” ");
INSERT INTO geb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Zisas maaŋ nzuaim, Pita khaŋ ana nzuai, “Guman Bakɨme, gu ndu phorgɨv bɨneŋ rɨr zavra khar ki. Gu vhɨra ndu phorgɨv rɨmɨn zavra khar ki.” ");
INSERT INTO geb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ana maaŋ nzuaim, Zisas khaŋ ana nzuai, “Pita, gu ndu nzuai, ndu ntige kha maaŋra tuar ntigar furga, ndu fhumra na ndim zaahɨ mpuani khegenen muuŋgirga.” ");
INSERT INTO geb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Zisas khaŋ wo farasegi 12 thɨgi ŋaara gumgi ga nzuai, “Gu nde sarigim, nde nan ŋaarar muun zav vov, nde ŋkɨɨa ki daa ndira ndigap, bigi ndia vhui thari ndigap, ŋkari shari ndigap, wari vegi fhuvara. Nde mba tugen vov nde bigɨna the sosuagire?” Ana maaŋ mbe nzuaim, mbe khaŋ ana nzuai, “Nza bigɨn the sosuagi fhu.” ");
INSERT INTO geb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mbe maaŋ ana nzuaim, ana khaŋ mbe nzuai, “Maaŋgi, nde ntigem ŋkɨɨa vhui dama ndera thige kɨv, nde niŋge ndigip, nde vhɨra wari wo bigi ndi vhui tharge ndigiri. Nde ntari ga mbui kos ki fhu, nde wari wo fhava shaa the ndim maaŋrim, mbe ana vhezgirim, nde mba ŋkɨɨar wari ndiv, ntari ga mbui kos the vhezgiri. ");
INSERT INTO geb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ne khaŋ muuŋgi, Fhe Bakɨmen buni vhuuiŋ ki gavar ki kameŋ khaŋ nzuai, ‘Kha gumgi gu mbigi, mbe ana garav khaŋ ana nzuai, ana vhɨra guma mbatɨk ma.’ Gu nde nzuai, mba tɨv nan hɨgɨrga. Ahaŋ, mba nan hɨr za suaŋgi buni, nta Fhe Bakɨme bunin vhuuiŋ ki gavar ki, mba bigi nta nan hɨgɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ana maaŋ mbe nzuaim, mbe khaŋ ana nzuai, “Guman Bakɨme, ndu khar ganɨ, nza ntari ga mbui kos phunini ndigim, ni khar ki.” Ana khaŋ mbe nzuai, “Zam. Tugɨra.” ");
INSERT INTO geb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Zisas mba bunin mbe suaŋgia thugap, mbaram ana mba zazera mbui tɨva mbuav, mba ŋgu bakɨme thav, mbɨkshɨman ndai. Ana ndaim, mba ana phorga rui gumgi ana phorga ndai. ");
INSERT INTO geb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ana nda vov mba ŋanen hɨgap, ana mbaram khaŋ mbe nzuai, “Nde Fhe Bakɨme phorgɨv suaŋri. Nde muuŋv kɨrim, mparmpare thueŋ nden hɨgɨrim, nde ne khɨgɨ rɨgɨ rivgi.” ");
INSERT INTO geb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ana maaŋ mbe suaŋgiap, mbaram maneŋ mbe thav shɨva vugap, mbaram won thɨpanani phɨrgiap, fav Fhe Bakɨme phorga nzuav khaŋ nzuai, ");
INSERT INTO geb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“O, Dara, ndu vuzvuk ma, ndu vuzvugirga, ndu na tɨn kha zaagi mbatɨgi ndigɨrga. Gu ndu nzuai, ndu na vuzvuga zɨn ŋgɨ thari. Ndu wo vuzvuga zɨn ŋgɨri.” ");
INSERT INTO geb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ana maaŋ nzuaim, mbaram Fhe Bakɨme enser mbe anan hɨgap havharan ana nɨɨŋgi. ");
INSERT INTO geb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Zisas wo khɨkhɨm mbararagim, ana guigira simgim, ana thav khaŋ tɨgap Fhe Bakɨme phorga nzuai. Ana khaŋ tɨgap Fhe Bakɨme phorga nzuaim, ana zorɨk vɨzɨna fara muuŋgiap sia mbu nuiana sui. ");
INSERT INTO geb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ana Fhe Bakɨme phorgav suaŋgiap mbaram khavgiap taagia wo phorga rui gumgir han vui. Ana vov mbe garim, mbe ndavi guigira mben simgim, mbe kuav ki. ");
INSERT INTO geb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Mbe kuav kim, ana vov khaŋ mbe nzuai, “Ai, nde ram muuŋgiap kuav ki? Nde khavgip Fhe Bakɨme phorgɨv suaŋ. Nde muuŋv kɨrim mparmpare thueŋ nden hɨgɨrim, nde ne khɨgɨ rɨgɨ rivgi.” ");
INSERT INTO geb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Zisas mba kamen wo phorga rui gumgi ga nzuavra kim, gumgi vhɨrvera zi. Mbe zim, mba Zisas farasegi 12 thɨgi ŋaara guma mbe, ana zɨ Zudas, ana tuavar mbe khɨvav, mbe zi. Ana zɨv, Zisasan han zɨgɨp, ana viavɨv anan khoman panɨnga. ");
INSERT INTO geb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ana ne nzuav mben kov Zisas han zim, Zisas mbaram kha nzambaren ana muuŋgi, “Ai, Zudas, ndu Fhe Bakɨme Guma Guara thuuŋ dorgɨp, ana viavɨv, ana khoman panɨv, ana ndim gumgi farve khɨngirga thi?” ");
INSERT INTO geb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Mba gumgi maaŋ mbuim, mba Zisas phorga rui gumgi mba hɨr za mbui bigi garav, khaŋ Zisas ga nzuai, “Guman Bakɨme, ndu vuzvugi nza ntari ga mbui kozin kheiŋ shogɨp mbe fhɨri gorɨrie?” ");
INSERT INTO geb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mbe nen Zisas ga nzuav mbaram, mbe mbevi hɨga ntari ga mbui kos ndigap, mba Fhe Bakɨme rotu gari guman panan ŋaara guman guva khuareŋ shogi, ne thuga nɨɨeŋ rɨgi. ");
INSERT INTO geb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ana maaŋ muuŋgim, Zisas ana gangiap thav khaŋ nzuai, “Ai, zamra! Shogɨ thari!” Ana maaŋ ana nzuav, mbaram ana khuareŋ suirigim, ana khuareŋ taagia nzerigi. ");
INSERT INTO geb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Zisas taagiap ana khuareŋ ndiv sarav, khaŋ mba Fhe Bakɨme rotu gari gumgir pani gum, mben Fhe Bakɨme Phena gari gɨɨtɨvi gumgir pani gum, mben gumgir pani, mbe ana suigɨr zav zegi, ana khaŋ mbe nzuai, “Nde ntari ga mbuav kɨɨi fara muuŋgi guma then suigɨr zav wari won ntari ga mbui kozi ndiav wari won fani ndiga zegire? ");
INSERT INTO geb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Gu rari tugɨratɨgap nde phorgap mba Fhe Bakɨme phena bɨna vhen kim, nde na suigi fhu. Nde ntigem, Fhe Bakɨme nde khɨrigim, nde nan suigi. Ntigem, nden tuk ma. Fhe Bakɨme ntigem maaŋ khɨrigim, ana ŋkasŋka ntige ŋgari.” ");
INSERT INTO geb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Zisas maaŋ mbe suaŋgim, mbe ana suirav ana ndiga vui. Mbe ana ndiga vov mba Fhe Bakɨme rotu gari guman pan phena vhen vergi. Mbe ana suira vuim, Pita mbe zɨn vov maneŋ samra ki. ");
INSERT INTO geb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pita mbe zɨn vuim, gumgi mbari mba phena bɨna vhen rɨgɨnera vhava tɨgap wari piigiap ki. Mbe piigiap kim, Pita vov mben haa perigi. ");
INSERT INTO geb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pita mben han mba vhava gaa ga perav kim, mba phenan ŋgari mbiga mbevi ana garav kav khaŋ nzuai, “Ai, mba guma, ana vhɨra Zisas phorga kegi guma mbe ma.” ");
INSERT INTO geb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mba mbik maaŋ ana nzuaim, Pita wandi zaahegap khaŋ ana nzuai, “Ai mbik, gu ana kaŋgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pita maaŋ suaŋgiap, perav kim, zumgum tuga mpeenera kegap, harigi guma mbe zav, ana gangiap, khaŋ ana nzuai, “Ndu vhɨra mba guma mbe ma.” Ana ne nzuaim, Pita mbaram khaŋ ana nzuai, “Guma, gu fhuvara!” ");
INSERT INTO geb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ana maaŋ suaŋgiap kim, tuga mpeeŋra kegap harigi guma mbe kama havharara khaŋ Pita ga nzuai, “Mba guma, ana guigira ana phorga kegi guma mbe ma. Ana vhɨra Gariri guma ma.” ");
INSERT INTO geb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ana maaŋ nzuaim, Pita mbaram khaŋ ana nzuai, “Gu guigi guarara ndu mba nzuai kameŋ, gu ne kaŋgi fhuvara!” Ana ne nzuavra kim, tuar furigi. ");
INSERT INTO geb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mba tuar furavra thagim, Zisas dorgap purara Pita garim, Pita ana mba ana suaŋgi kameŋ ga ndɨrigi. Zisas khaŋ Pita ga suaŋgi, “Ntige kha maan, tuar ntigar furga, ndu fhumra na ndim zaahɨ mpuani khegenen muuŋgirga.” ");
INSERT INTO geb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pita ne ndɨrga thav, kɨrar hɨgap nzi mbatɨga mbui. ");
INSERT INTO geb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Pita kɨrar hɨgim, mba Zisas suirav ana ndiga vugi gumgi, mbe ana nzɨɨv, ana nzuav ana bungia kav, ana shogi. ");
INSERT INTO geb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Mbe ana shogap, ana nzɨɨv, khaŋ ana muuŋgi, mbe shaa ndigap, zav ana rɨmani ndogiap, ana shogiap, ana bungia kav, khaŋ ana nzuai, “Ai, Fhe Bakɨme kamthooŋ guma, ndu khar nza suaŋ, the khar ndu shogi?” ");
INSERT INTO geb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mbe maaŋ ana mbuav, mbe vhɨra harigi buni mbatɨgi vhɨrver ana nzuav, ana zɨn farfagi. ");
INSERT INTO geb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mbe mba tɨvar Zisas ga mbuav kim, mɨn thugim, ra ndav shɨrigim, mben bigi ndiv thɨgar mbai buaa degi gumgi wari fugi. Mbe buaa degi gumgi khare, mben gumgi ruu gum, mba Fhe Bakɨme rotu gari gumgir pani gum, mba Zudaiŋ tɨvir vhuuiŋ kaŋgi gumgi. Mbe wari fugim, mba Fhe Bakɨme phena gari gɨɨtɨvi, mbe Zisasan kov mben han vuim, mbe khaŋ ana nzuai, ");
INSERT INTO geb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ndu khar nza suaŋ, ndu mba Fhe Bakɨme taagiap kha gumgi gu mbigi ndir zav sarigi gumarame, ee, fhuve?” Mbe maaŋ ana nzuaim, ana khaŋ mbe nzuai, “Gu maaŋ muuŋgip nde suanga, nde na khothɨgɨrga fhu. ");
INSERT INTO geb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Gu vhɨra maaŋ muuŋgip buni thari ga suaŋv nden nzanga, nde na ŋgarkararga fhu. ");
INSERT INTO geb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Gu thav nde nzuai, ntige gum zumgum nde ganɨnga, Fhe Bakɨme Guma Guar, ana za kha bigi kharav ŋkasŋka ki Fhe Bakɨmen guva haren perav zazera mbara muuŋgip kɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ana maaŋ mbe nzuaim, mbe zam anan nzav khaŋ ana nzuai, “Maaŋgi, ndu nduara Fhe Bakɨmen Kam ee?” Mbe mba nzambaran ana mbuim, ana khaŋ mbe nzuai, “Nde nzerara mbar ne nzuai. Gu ana ma.” ");
INSERT INTO geb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ana maaŋ mbe nzuaim, mbe khaŋ nzuai, “Nza harigi gumgi tharir kamɨrim, mbe zɨv kha guma muuŋgi bigi thari bun nza suanga fhuvara. Kha guma, ana nduara won kamthooŋ ntarav mba kameŋ nzuaim, nza ana mbararagi.” ");
INSERT INTO geb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mbe maaŋ suaŋgiap, mben gumgir pani, mbe za khavgiap Zisasan kov Pairat han vui. ");
INSERT INTO geb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mbe zam ana kov Pairat han vugap, ana nzuav nzuav khaŋ nzuai, “Nza kha guma garim, ana nzan gumgi gu mbigir tɨvir tuara mbuim, mbe ana tɨvi zɨn vui. Ana vhɨra nza ŋkɨɨar Sisaran nɨɨnga tuav nza gori. Ana nza thɨvav, ana vhɨra khaŋ nzuai, ‘Gu mba Fhe Bakɨme taagip wo gumgi gu mbigi ndir zav sarigi ŋgui gari guman pan ma.’ ” ");
INSERT INTO geb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mbe ne nzuaim, Pairat Zisasan nzarigi, “Ndu kha Zudaiŋ gari guman pan ee?” Ana ne nzuaim, Zisas mbaram ana ŋgarkarav khaŋ ana nzuai, “Ahaŋ, ndu nduara mbar ne nzuai.” ");
INSERT INTO geb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Zisas ne nzuaim, Pairat mbaram khaŋ mba Fhe Bakɨme rotu gari gumgir pani gum mba gumgi gu mbigi vhɨrve ga nzuai, “Mbaia, gu simtɨgar kha guma nɨɨnga tɨva mbatɨga thueŋ gangi fhu.” ");
INSERT INTO geb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pairat maaŋ nzuaim, mba gumgi gu mbigi, mbe khaŋ tɨgav nzuav khaŋ nzuai, “Kha guma, ana za kha Zudia fhaiŋ ga ruigi. Ana fhara Gariri fhain kegap, khavgiap, za kha bigi ga rua zav, nza ŋgun hɨgi. Ana maaŋ mbua ruav, bunin nza gumgi gu mbigi khɨvav mbe nzuav, mbe ndavi khavim, mbe ana zɨn vui.” ");
INSERT INTO geb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mbe ne nzuaim, Pairat ne mbararagiap kha nzambaren mbe muuŋgi, “Kha guma, ana Gariri guma ee?” ");
INSERT INTO geb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ana mba nzambaren mbe muuŋgi, mbe ana suaŋgim, ana kaŋgi, Zisas Herot gari fain kega zɨgi. Ana ne kaŋgiap Zisas ga sarigim, mbe anan kov Herot han vui. Mba tugen Herot vhɨra ndav Zerusareman ki. ");
INSERT INTO geb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ana Zisas ga sarigi, ana Herot han vugim, Herot ana garav guigira ndikndiga mbatɨga mbui. Ana fhum mbe Zisas bun nzuaim, ana tuga mpeeŋra ana gangir zav nzuav ki. Ana khueŋ vuzvugi, ana nduara Zisas ganɨrim, ana mirikor then muuŋgirga. ");
INSERT INTO geb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herot mba ndɨkndɨgar Zisas ga mbuav, ana bigi vhɨrver anan nzaŋgi. Ana mba nzambarir Zisas ga mbuim, Zisas ana buna thuen ŋgarkarigi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ana fhura kim, mba Fhe Bakɨme rotu gari gumgir pani gum mba Zudain tɨvir vhuuiŋ kaŋgi gumgi, mbe zav hara thivgiap, khaŋ tɨga ana nzuav nzuai. ");
INSERT INTO geb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mbe ana nzuaim, Herot mbaram won ntari ga mbui gɨɨtɨvir kov, mbe buni mbatɨgi guarira ana nzuav ana nzɨɨi. Mbe maaŋ ana mbuav, mbaram shaa vhuuŋra ndiga zav ŋgui gari guman pan nzɨɨi sɨɨŋmbarar ana muuŋgiap, ana sarigim, ana taagia Pairat han vui. ");
INSERT INTO geb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herot fhum panan Pairat ga kegi. Mani ntigem, kha tugen mani kɨvntoga vhuuŋ ni ma. ");
INSERT INTO geb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pairat mbaram mba Fhe Bakɨme Phena rotu gari gumgir pani gum mben gumgir panin kaav, vhɨra mba gumgi gu mbigir kamgim, mbe zav ana han wari fugi. ");
INSERT INTO geb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Mbe ana han wari fugim, ana khaŋ mbe nzuai, “Nde kha guma suirav zav, na han zɨgav, khaŋ na nzuai, ‘Ana kha gumgi gu mbigir tɨvi ga mbuim, mbe tuara muuŋgiap ana zɨn vui.’ Nde ntige khara kav mbararagim, gu za mba bigi ga nzuav ana nzaŋgi. Nde mbarara. Gu kha guma muuŋgi tɨva mbatɨga thueŋ gangi fhu. Gu ndɨkndɨgi, nde mba ana nzuav nzuai bigi, ana mba bigɨn thueŋ muuŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nde ganɨ, Herot, ana vhɨra, ana gu khar nzuai ndɨkndɨgɨra mbuav ana sarigim, ana nza han zɨgi. Nde mbarara. Kha guma, ana bigɨna mbatɨga thueŋ muuŋgip ne khuav rɨmɨn saŋv muuŋrim, gu khaŋ ana suaŋrie, ‘Ndu rɨmɨnga.’ Fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Gu maaŋ muuŋgiap, gu fhura phivɨgan ana khargip, ana sararim, ana ŋgɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pairat ne nzuaim, mba gumgi gu mbigi, mbe za wari tɨgɨra khavgia ndarav, kaav khaŋ nzuai, “Ndu mba guma shogirim, ana rimgiri. Ndu Barabas fhɨrgirim, ana kɨrar hɨgɨp nza han zɨri.” ");
INSERT INTO geb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Mbe mba fhɨrɨ za nzuai guma Barabas, ana fhum gumgi mbari phorgav mbe ntara bakɨme khavgiap ŋgui gari guman pana mbe phorga shogap, ana guma mbe shogim, ana rimgim, mbe ne nzuav ana ndiv bɨna khɨngi. ");
INSERT INTO geb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Mbe maaŋ nzuaim, Pairat thav wom khaŋ mbe nzuai, “Gu Zisas fhɨrgirim, ana ŋgɨrgeŋ vuzvugi.” ");
INSERT INTO geb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ana ne nzuaim, mbe wom kaav khaŋ nzuai, “Ana shogiri ana rimik! Ana shogiri, ana rimik! Ana ndim, khanarareŋ ga tɨgɨ fugu! Ana rimgirga!” ");
INSERT INTO geb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mbe maaŋ nzuaim, ana suambara mpuanin mbe muuŋgiap, thav wom khegenen mbe mbui. Ana khaŋ mbe nzuai, “Ana ram muuŋgi ne nzuav? Ana thagɨna bigɨna mbatɨgeŋ muuŋgi? Gu ana muuŋgi bigɨna mbatɨga thueŋ kaŋgi fhu. Gu ana muuŋgi bigɨna mbatɨga thueŋ kaŋgip, gu ana rɨmɨnga ne suaŋv suanga. Gu maaŋ muuŋgiap, gu fhura phivɨgan ana khargip, ana fhɨrgirim, ana ŋgɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pairat ne nzuaim, mbe khaŋ tɨgap kaav, ŋgarŋgarav khaŋ Pairat ga nzuai, “Ana ndim, khanarareŋ ga tɨgɨv fugu!” Mbe nen Pairat ga nzuaim, mben kameŋ zav Pairat nzuai kameŋ kharav vun vui. ");
INSERT INTO geb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Mbe ne nzuaim, Pairat thav mben kama zɨn vui. ");
INSERT INTO geb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pairat thav, mba ntara bakɨme khavgiav, mba harigi ŋgui gari guman pana mbe phorgap shogap, ana guma mbe shogi ana rimgi guma, mbe ne nzuav ana ndi bɨna khɨngi, mbe ana nzuav nzuai. Pairat mben vuzvugar ana fhɨrgim, ana mbe han vuim, ana mben vuzvugar zɨn Zisas ndim mba ntari ga mbui gɨɨtɨvi farve khɨngiap, ana shogirim, ana rimgirga nen mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mba ntari ga mbui gɨɨtɨvi, mbe Zisasan kov vov garim, harigi ŋgu guma mbe, ana zav ndav mba ŋgu bakɨmen vhen verim, mbe ana suirigi. Mba guma zɨ khare, Saimon, ana Sairini guma ma. Mbe ana suirav, Zisas khanarareŋ ana phufhurav, ana nzuaim, ana Zisas ndim ne phufhurav ana zɨn vui. ");
INSERT INTO geb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mbe Zisas ndigap vuim, gumgi gu mbigi vhɨrvera ana zɨn vuim, mbigi vhɨrvera ana zɨn vuav, nziav, nanaman kaman ana nziav, wari ana zɨn vui. ");
INSERT INTO geb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mba mbigi vhɨrve ana zɨn vov nzim, Zisas dorgap, mbe garav khaŋ mbe nzuai, “Nde mba Zerusareman mbigi, nde na suaŋv nzi thari. Nde warira suaŋv nzirga ne nzerara. Nde warira suaŋv nziv, wari won tari ga suaŋv nziri. ");
INSERT INTO geb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nde mbarara. Nde zumgum tuga then nde mbarararga, mbe khaŋ suanga, ‘Nde mba khura tav tari tegi fhuv mbigi gum, nde mba tari tɨ thav, tirar nta nɨɨŋgi fhuv mbigi, nde ndikndigɨri!’ ");
INSERT INTO geb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mbe mba tugen, mbe khaŋ mba mbɨkshɨɨ baikɨvi gum mbɨkshɨɨ bisarire ga suanga, ‘Nde phɨrɨ nza tɨɨi rɨv nza vhaigɨ.’ ");
INSERT INTO geb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nde na gari, gu mba ŋamkav mbɨ khɨgɨra ki kha ma. Nde mba gumgi gu mbigi, nde mba shɨɨŋgi khira ma. Mbe ntigem kha tɨvar kha khan ŋamtɨŋ ana mbɨ khɨgɨra ki, mbe kha tɨvar ana mbui. Mbe maaŋgi ram mbui tɨvar mba shɨɨŋgi khira mbe ntan muuŋrie?” ");
INSERT INTO geb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mba ntari ga mbui gɨɨtɨvi Zisas ndiga vov, mbe vhɨra guma phunini phorga ndiga vui. Mba guma mbatɨgani, bigi kɨɨv farfagi gumani ma. Mbe vhɨra mani shogirim, mani vhɨra Zisas phorgɨv rimgirga. ");
INSERT INTO geb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mbe mbe ndiga vov kha ŋanen vugi. Mba ŋaneŋ zɨ khare, Pana Tuam. Mbe mba ŋanen Zisas ndim, khanarareŋ ga ntorgi. Mbe Zisas ndiv ntorgav, mbaram mba bigi kɨɨv farfagi guma mbatɨgani, mbe vhɨra mani ndim, khanararaini ga ntorgi. Mbe mbevi ndim, ana guva haran ki khanarareŋ ga ntorgav, mbaram mbevi ndim ana ŋkɨn haren ki khanarareŋ ga ntorgi. ");
INSERT INTO geb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Mbe Zisas ndim khanarareŋ ga ntorgim, ana khanarareŋ vun kav khaŋ Fhe Bakɨme nzuai, “O, Fhe, ndu kheiŋ mbui tɨvi mbatɨgi, ndu nta vhɨzgip nta ndɨkndɨgɨ thari. Mbe kha mbui bigeŋ, mbe ne kaŋgi fhuvara.” Mbe Zisas ndim, khanarareŋ ga ntorgap, mba ntari ga mbui gɨɨtɨvi, mbe Zisas shagi ndir zav, nta nzuav satu suri. ");
INSERT INTO geb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mbe satu surim, mba gumgi gum mbigi, mbe thivgiap kav Zisas garim, mben gumgir pani, mbe Zisas nzɨɨv khaŋ ana nzuai, “Ana harigi ntɨɨrir kurkurigi. Ana maaŋ muuŋgip ana guigira mba Fhe Bakɨme won ŋaarar muuŋv mba taagip khaŋ nuianan ki gumgi gu mbigi ndir zav suaŋgiap farasarigi guma kɨp, ana maaŋ muuŋgip taagip wora kura.” ");
INSERT INTO geb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mbe maaŋ ana nzuav, mba ntari ga mbui gɨɨtɨvi, mbe vhɨra hegap, ana nzɨɨv ana nzuai. Mbe maaŋ ana nzuav, wain pɨksɨgar ana ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Mbe maaŋ ana mbuav khaŋ ana nzuai, “Ndu guigira Zudaiŋ gari guman pan, ndu nduara won kura.” ");
INSERT INTO geb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mbe vhɨra kama mueŋ khergiap, ana pana shɨn ana khanarareŋ ga ntorgi. Mba kameŋ khaŋ nzuai, “Kha guma, ana Zudaiŋ gari guman pan ma.” ");
INSERT INTO geb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mbe mba bigi kɨɨv farfagi guma mbatɨgani ndim, Zisas gaani ga ntorgi. Mani kav, mbevi vhɨra Zisas nzɨɨv khaŋ ana nzuai, “Ai, ndu Fhe Bakɨme farasarigi gumara kake, ndu maaŋ muuŋgia won kurkurav vhɨra ŋkan kurae.” ");
INSERT INTO geb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ana ne nzuaim, mba Zisas gaa mueŋ ga ntorgi guma mbe ne mbararagiap, ana vhegap, khaŋ ana nzuai, “Ndu vhɨra ana ndi simtɨgara ndi. Ndu Fhe Bakɨmen rɨvi fhuv thi? ");
INSERT INTO geb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mbe ŋka shogim, ŋka rɨɨi, ne nzerara. Mbe tɨvar vhuuŋ zɨn vov mba tɨvar ŋka mbui. Ŋka nzerara wani wo muuŋgi tɨvi mbatɨgi, ŋka ntan vheza ndi. Kha guma, ana tɨva mbatɨga thueŋ muuŋgi, zakɨra fhuvara!” ");
INSERT INTO geb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ana nen mba guma ga nzuav, mbaram khaŋ Zisas ga nzuai, “Zisas, ndu Fhe Bakɨme han Hevenan ŋgɨgɨp, ndu ŋgui vhɨrve gari guman pana gegɨp ndu na ndɨrɨgɨri.” ");
INSERT INTO geb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ana maaŋ nzuaim, Zisas mbaram khaŋ ana nzuai, “Gu guigira ndu nzuai, ndu ntige na phorgɨv Hevenan kɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Mbe Zisas ndim, khanarareŋ ga ntorgim, mba raar ra vov phɨɨŋ ndim, ran ŋaar vhɨzgi. Ran ŋaar vhɨzgim, maaŋ gɨngiap, za kha nuiana vharigi. Mba maaŋ gɨngiap, mbara muuŋgiap kim, ra vera vov ŋkotugun phuni khegene ndigi. Maaŋ gɨngim, mbe mba Fhe Bakɨmen Phena vhee ntorgi shaa bakɨme, ana rɨgɨra shɨragerɨgap, fɨga mpuani ga gegi. ");
INSERT INTO geb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Zisas mbaram kama bakɨmera kaav khaŋ nzuai, “O, Fhe, gu won tuman ndu farve khɨngi.” Ana maaŋ suaŋgiap, za gor vhɨk ŋgɨrgi. ");
INSERT INTO geb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ana rimgim, mba ntari ga mbui gɨɨtɨvi gari guman pan, ana rimgi tɨva gangiap, ana ne nzuav Fhe Bakɨme zɨ ndiv vun kuav khaŋ nzuai, “Guigi guarara, mbu guma, ana guigira tɨvir vhuuiŋra mbui guma ma.” ");
INSERT INTO geb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ana maaŋ nzuaim, mba zegap maaŋ kav gari gumgi gu mbigi, mbe mba hɨgi bigi gangiap, mbe guigira ana kora muuŋgiap wari wo gori mbozav wari taagiap vui. ");
INSERT INTO geb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mba Zisasan kɨvntogi gum mba ana phorgav Garirin kegap ndagi mbigi, mbe vhɨra zegap, samra thivgiap kav, mbe vhɨra mba bigi garim, nta hegi. ");
INSERT INTO geb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Mba tugen, guma mbe ki, mba guma zɨ khare, Zosep. Ana Zudia fhain Arimatea ŋgun ki guma ma. Ana tɨvir vhuuiŋra mbui guma ma. Ana vhɨra mba bigi ndiv thɨgɨr mbai buaa degi gumgi phorga ŋgari guma mbe ma. Ana ntigem mbe Zisas ga nzuai buni gum mbe ana mbui tɨvi, ana nta vuzvugi fhuvara. Ana vhɨra Fhe Bakɨme wo gumgi gu mbigi ganɨrim, mbe ana piin kɨrga tugar rarga ki. ");
INSERT INTO geb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ana vov Pairat han vugap, Zisas khuma ndir zav Pairatan nzarigim, Pairat ana khɨrigi. ");
INSERT INTO geb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pairat ana khɨrigim, ana mbaram ana khuma ndiga vov, shaa huran ana zigap, ana ndiga vov, mbe kɨɨma thoon muuŋgi mboga tɨgi. Mba mbok, mbe fhum guma then mba mboga tɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ana Zisas ndiga vov mboga tɨgi raan, rar verav vhɨzim, Sabat hɨr zav mbuim, mba gumgi gu mbigi, mbe Sabat bigi bevahi. ");
INSERT INTO geb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mba Zisas phorga Garirin kegap ndagi mbigi, mbe vhɨra Zosep phorga vov, mba ana Zisas ndim mboga tɨgi mbok gangi. Mbe ana garav, mbe vhɨra Zosep ana ndi rɨgi rɨrɨk, mbe vhɨra ne gangi. ");
INSERT INTO geb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mba mbigi ana gangiap, mbe taagia vov wari wo phenin vegap, ana khuma hɨvɨ zav, ndɨga vhuuŋ hi mporiiŋ bevahegap, nta ndim rɨgiap, Sabat maaŋ muuŋgiap, mbe Sabata tɨva zɨn vuav wari vhuksui. ");
INSERT INTO geb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sabat raa vhɨzgim, harigi ŋaaren fharigi raa hɨgim, mba mbigi manera mbigera khavgiap mba bevahegi ndɨga vhuuŋ hi mporiiŋ ndigap, mbe mba mbe Zisas ndi mboga tɨgi kɨma thoon muuŋgi mbogar vui. ");
INSERT INTO geb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mbe vov mba mbok thɨɨni mpɨrigi kɨma ndi garim, mba kɨm ki fhu. Mbe ana phokphoga vov ana ndim mbur ndarigi. ");
INSERT INTO geb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Mbe thav vov, mba kɨma thoon muuŋgi mbok vhen verav ana gari. Mbe ana garav, mbe Zisas khuma gangi fhu. ");
INSERT INTO geb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mbe ana gangia thav kha ndɨkndɨga mbui, “Zisas khum maaŋ ki?” Mbe mba ndɨkndɨga mbuav garavra thav, guma phunini garim, mani hanera mbe han mbar thɨgi. Mba gumani, mani shagi guigira hurgiap ŋgara gari. ");
INSERT INTO geb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mba mbigi maaŋ muuŋgiap mani gangia thav, guigira rivgiav, wari rav wari wo khoo ndiv nuiana segap, wari wo khoo ndiv zomzorgi. Mbe wo khoo ndiv zomzorgim mba gumani khaŋ mbe nzuai, “Nde thaŋ nzuav ŋamki guma ga nzuav garav, kha vhɨzgi gumgi ki ŋanen zegi? ");
INSERT INTO geb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ana khaŋ ki fhuvara. Ana taagia khavgi. Nde ana fhum mba Garirin kavra nde suaŋgi kameŋ ga ndɨkndɨgɨri. ");
INSERT INTO geb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ana Garirir kav khaŋ nde suaŋgi, ‘Mbe Fhe Bakɨme Guma Guara ndiv, tɨvi mbatɨgi ga mbui gumgi farve khɨngirga, mbe ana ndiv khanarareŋ ga tɨgɨv fugurim, ana rimgirga. Ana rimgip, raa phunini vhɨzgirga, khegenen ana taagip khavgirga.’ ” ");
INSERT INTO geb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mba guma phunini nen mba mbigi ga suaŋgim, mbe mba fhum Zisas mbe phorga kav mbe suaŋgi kameŋ ga ndɨrigi. ");
INSERT INTO geb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Mbe ne ndɨrgap, mbaram mba kɨman thoon muuŋgi mbok thav, wari taagia vui. Mbe taagia vov, mba bigin ana farasegi 11 thɨgi ŋaara gumgi ga nzuav, vhɨra mba harigi gumgi gu mbigi ga suaŋgi. ");
INSERT INTO geb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mba gumani suaŋgi buni ndiga zav mba Zisas farasegi 11 thɨgi ŋaara gumgi ga suaŋgi mbigi khare. Makdaran mbik Maria gum, Zoana, Zemsan niamuuŋ Maria gum, harigi mbigi mbari phorgap. ");
INSERT INTO geb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mba mbigi zav mba bigeŋ bun mbe suaŋgim, mba Zisas farasegi 11 thɨgi ŋaara gumgi, mbe mba mbigi suaŋgi kameŋ khothɨgi fhuvara. Mbe khaŋ mbe nzuai, mbe fhura nzuai bɨɨŋbɨɨn kaa ma. ");
INSERT INTO geb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mbe maam mba mbigi ga nzuavra kav, Pita ndɨkndɨga mbe muuŋgiap, khaŋ wo nzuai “Gu nduara khuafɨra ŋgɨp gangirga.” Pita maaŋ suaŋgiap, khavgiap, khuafɨra mba kɨma thoon muuŋgi mboga vui. Ana vov, mba mbok thɨm kamani thɨgap, firav mba mbok vhee garav, mba Zisas ziga kegi shagi hurira gari, nta regap ki. Ana maaŋ muuŋgia gangiap, thav mba hegi bigi ga nzuav ndɨkndɨgi vhɨrve ga mbuav, taagia vui. ");
INSERT INTO geb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mba Zisas taagia khavgi raar mba mbigi, mbe Zisas ndim mbok ga tɨgi kɨma thoon muuŋgi mbogar vuim, mba raaram ana phorga ruigi guma phunini, mani mbe kha zɨn rɨgi ŋgun veri, Emaes. Mba ŋgu maneŋ Zerusarem thav samra ki. Ndu phɨɨn khavgirga, ndu ra ŋgirɨp ŋkotuguraagen fe ndirga, ndu mba ŋgun hɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mani Zerusareman kegap, Emaesan verav, mba Zerusareman hegi bigi, mani nta nzuav veri. ");
INSERT INTO geb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mani mba buni nzuav, mba hegi bigi ga nzuav, nuanira wanin nzav verav kim, Zisas nduara tuavar manin hɨgap, mani phorga veri. ");
INSERT INTO geb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ana mani phorga verim, Fhe Bakɨme mbe mani rɨmani ga muuŋgim, mani ana gari, mani tuituigiap ana hiav ana kaŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ana mani phorga verav manin nzarigi, “Ŋko thegi buni nzuav wani zeri?” Ana mba nzambaren mani ga muuŋgim, mani thav fhura mbar thɨgap, guigira mba hegi bigi kora muuŋgiap wani ŋgiigi. ");
INSERT INTO geb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mani ŋgiap kegap, mani mbevi, ana zɨ khare Kriopas, ana ana ŋgarkarav khaŋ ana nzuai, “Ntigem, mbarkɨrga mbarkɨrga ŋgui gumgi, mbe ntigem Zerusareman ki. Ee, ndu nduaram ntigem kha tugen Zerusareman hegi bigi, ndu ne kaŋgi fhuve?” ");
INSERT INTO geb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ana ne ana nzuaim, Zisas manin nzarigi, “Thegi bigi?” Ana maaŋ nzuaim, mani khaŋ ana nzuai, “Ŋka mba Nasaret guma Zisasan hɨgi bigi, ŋka nta nzuai. Ana Fhe Bakɨmen kamthooŋ guma ma. Ana vhɨra Fhe Bakɨme gum gumgi gu mbigi, ana mbe nɨman ana ŋkasŋka ki ŋaari ga mbuav, vhɨra ŋkasŋka ki buni nzuai. ");
INSERT INTO geb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ana maaŋ mbuim, mba Fhe Bakɨme rotu gari gumgir pani gum, nzan gumgir pani, mbe ana shogirim, ana rimgirgane vuzvugi. Mbe ne nzuav ana ndim Pairat farve khɨngim, Pairat nzuaim, mbe ana ndim khanarareŋ ga fukfugim, ana rimgi. ");
INSERT INTO geb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nza fharav khueŋ nzuav ana khothɨgi, Zisas, ana Fhe Bakɨme taagip kha Isreriŋ gumgi gu mbigi ndir zav suaŋgiap farasarigi guma ma. Nza nen anan vhuuŋvhuuŋv kim, fhuvara. “Mbe kha tɨvar ana muuŋgim, ra phunini vhɨzgim, ntige khegene ma. ");
INSERT INTO geb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ntige manera vhɨra nzan mbigi mbari, mbe nza muuŋgim, nza guigira ŋgava mbatɨga muuŋgi. Mbe ntige manera mbigera khavgiap mba Zisas ndim mboga tɨgi kɨma thoon muuŋgi mbogar vui. ");
INSERT INTO geb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Mbe vov, mba mbogar vegap, garim, Zisas khum ki fhu. Mbe maaŋ muuŋgia gangiap, taagia zav khaŋ nzuai, ‘Nza vov, Zisas khuma ndim garim, ana ki fhu. Nza ana nzuav garim, Fhe Bakɨme enserni nzan hɨgap, khaŋ nza nzuai, “Ana maaŋ rimgi, ana taagia khavgi.” ’ ");
INSERT INTO geb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mba mbigi zav maaŋ suaŋgim, nzan gumgi mbari, mbe vhɨra mba mbogar vegap, mbe vhɨra mba mbigi gangia zav suaŋgi bigira gangi. Mbe ana gangi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mani mba bigir Zisas neŋgegim, Zisas khaŋ mani ga nzuai, “Ŋko ndɨkndɨk ki gumani fhuvara. Ŋko ndɨkndɨk ki gumani kake, ŋko mba Fhe Bakɨme kamthooŋ gumgi suaŋgi buni, ŋko nta khothɨge. ");
INSERT INTO geb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ŋko ram mbui ndɨkndɨga mbui? Ee, ŋko khueŋ kaŋgi fhuv thi? Fhe Bakɨme mba taagip wo gumgi gu mbigi ndir zav suaŋgiap farasarigi guma, ana zirgɨp ana fharav zaa ndigip Fhe Bakɨme han zɨ bakɨ guarara ndigirga.” ");
INSERT INTO geb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ana nen mani ga suaŋgiap, mbaram Fhe Bakɨme buni vhuuin mani ga nzuai. Ana Fhe Bakɨmen buni vhuuiŋ mani ga nzuav, ana fhara Moses suaŋgi bunira kegap, mani ga nzuav, vhɨra mba Fhe Bakɨme kamthooŋ gumgi suaŋgi buni phorgav mani ga nzuai. Ana mani ga nzuav, mani khɨvav vov, mba Fhe Bakɨme buni vhuuiŋ nɨɨŋge, mba buni Fhe Bakɨme ara nzuai buni ma. Ana ntan mani ga nzuav mani khɨvi. ");
INSERT INTO geb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ana mba bunin mani ga nzuav, mbe vov mani mba vui ŋgun hav, Zisas puskarav mani mba vui ŋgu kambarav mbur ŋgɨr zav mbui. ");
INSERT INTO geb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ana ŋgɨr zav mbuim, mani khaŋ tɨgav ana nzuai, “Ai, kha ra vhɨzgim, maaŋ gɨnɨn za mbui. Ndu zɨv ŋka phorgɨ kɨ.” Mani maaŋ ana nzuaim, ana mani phorga phenan vui. ");
INSERT INTO geb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mbe phenan vegap, mbɨr zav, Zisas mani phorga vov, mbe mba pi kaa ga piigi. Mbe piigiap, Zisas mbaram viktuma ndigap, ndɨkndɨga vhuun ana muun zav ana nzuav Fhe Bakɨme phorga nzuav ana ndikndigap, mbaram ana phɨrgiap mani ga ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ana mba viktuma phɨrgiap mani ga ndɨɨim, mani rɨmani fhura pu thuga vugi fara muuŋgim, mani ana garav, ana hegim, ana fhura mani thav mbar vugim, mani wom ana gangi fhu. ");
INSERT INTO geb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Mani thav nuanira khaŋ wani ga nzuai, “Guigi guarara, ŋka kha tuavar zerim, ana kha bunin ŋka nzuav, ana kha Fhe Bakɨme bunin vhuuiŋ nɨɨŋge bun ŋka nzuaim, ŋka ndavani guigira khavgi.” ");
INSERT INTO geb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mani nen wani ga nzuavra thav, za khavgiap, wani taagia Zerusareman ndai. Mani ndav vov, mba Zisas farasegi 11 thɨgi ŋaara gumgi gu mbe phorga ki gumgi gu mbigi, mani mbe garim, mbe wari tɨgap phoga vhuigap ki. ");
INSERT INTO geb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Mbe kim, mani nda vov mben hɨgim, mbe khaŋ mani ga nzuai, “Guigira, Guma Bakɨme guigira khargi. Ana khavgiap, vov Saimonan hɨgim, ana ana gangi.” ");
INSERT INTO geb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mbe nen mani ga nzuaim, mani mba tuavar ana manin hɨgap, mani phorga verav, mani ga suaŋgi bigi, mani nta neŋgi. Mani nta neŋga vov, ana mani phorgav phenan vugap, mbe mbɨr zav ana viktuma ndigap, Fhe Bakɨme ndikndigap, ana phorga suaŋgiap, ana phɨrgiap mani ga ndɨɨim, mani ana kheharav khaŋ nzuai, “Khe Zisas ma!” ");
INSERT INTO geb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mani ne bun mbe nzuav, mbe wari tɨgap, mba buni nzuavra kim, Zisas hav, mben rɨgɨra mbar thɨgi. Ana hav thɨgap khaŋ mbe nzuai, “Nden ndavi mbɨrav kɨri.” ");
INSERT INTO geb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ana nen mbe nzuaim, fhuvara, mbe ŋgava mbatɨga muuŋgiap, wari za rivgi. Mbe ana gangiap, khueŋ ndɨkndɨgi, “Khe tum ma?” ");
INSERT INTO geb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mbe mba ndɨkndɨgar ana mbuim, ana khaŋ mbe nzuai, “Nde thaŋ nzuav ndavi havhargiap, pim ndɨkndɨgi vhɨrve ga mbuav, khaŋ nzuai, ‘Khe the khare?’ ");
INSERT INTO geb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nde na farveni ganɨv, nan ŋkarveni ganɨ. Gura nden han khare. Nde zɨv na suigɨv, na ganɨ. Tum, ana khaŋ muuŋgip guma guara farar muuŋgip, harani gum suani kɨv, buni suaŋrim, nde khar na gari farar muuŋgip, ana ganɨrie?” ");
INSERT INTO geb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Zisas nen mbe nzuav, mbaram won farveni gum ŋkarvenin mbe khɨvi. ");
INSERT INTO geb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ana nen mbe nzuaim, mbe ne nzuav ŋgava mbatɨga muuŋgiap, ndikndigap, mbe tuituigia ne khothɨgi fhuvara. Mbe ndɨkndɨgi vhɨrve ga mbui. Mbe ndɨkndɨgi vhɨrve ga mbuim, ana khaŋ mbe nzuai, “Nde pi mba thaneŋ mbar kire?” ");
INSERT INTO geb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ana maaŋ mbe nzuaim, mbe tuegi mbɨgam raraŋ muen ana nɨɨŋgi. ");
INSERT INTO geb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Mbe mba mbɨgama raraŋ muen ana nɨɨŋgim, ana ne ndigap, mbe nɨman ne pim, mbe ana gari. ");
INSERT INTO geb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ana khaŋ mbe nzuai, “Gu fhum nde phorgara kav, gu khaŋ nde suaŋgi, mbe mba na nzuav khergi buni, nta mba Moses suaŋgi tɨvi ki gavar ki, nta vhɨra mba Fhe Bakɨmen kamthooŋ gumgi suaŋgi buni ki gavar ki. Nta vhɨra ŋgavi ki gavar ki, mba buni, nta za guigira mba tegɨrga.” ");
INSERT INTO geb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ana nen mbe nzuav mben kurigi, mbe mba Fhe Bakɨme buni vhuuiŋ ki gavar mba Fhe Bakɨme buni vhuuiŋ nɨɨŋge ndɨkndɨgɨp, ana buni vhuuiŋ kaŋgirga. ");
INSERT INTO geb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ana nen mbe nzua vov, khaŋ mbe nzuai, “Fhe Bakɨmen buni vhuuiŋ ki gavar ki buneŋ khaŋ nzuai, Fhe Bakɨme taagip kha gumgi gu mbigi ndir zav farasarigi guma, ana fharav zaa ndiv rimgirga, raa phuni vhɨzgirim, khegenen, ana taagip khavgirga. ");
INSERT INTO geb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ana taagip khavgirga, mbe ana zɨn panan, mbe kha Fhe Bakɨme buni vhuuiŋ bun za kha nuianan ki gumgi gu mbigi ga suanga, mbe ndavi domdorɨrga, Fhe Bakɨme mbe muuŋgi tɨvi mbatɨgi vhɨzɨv, nta ndɨkndɨgɨ tharga. Mbe fharav Zerusareman kegɨp, Fhe Bakɨme buni vhuuiŋ bun suaŋri. ");
INSERT INTO geb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nde kha gangi bigi bun suaŋri.” ");
INSERT INTO geb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ana maaŋ mbe nzua vov, khaŋ mbe nzuai “Nde mbarara! Fhe fhum won Ŋina Ŋaara sararim, ana nde han zirɨ za suaŋgi. Gu ana sararim, ana nde han zirɨrga tuk han mbarigi. Nde wari tɨgɨp kha ŋgu bakɨmera kɨv, Fhe Bakɨme ŋkasŋka ndigiri.” ");
INSERT INTO geb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Zisas kha buni mbe suaŋgiap, mbaram mben kov vov, Betani han mbav thɨgav, mbaram won harani ŋgav, tɨva vhuun mbe muun zav Fhe Bakɨme phorga nzuai. ");
INSERT INTO geb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ana tɨvar vhuun mben muun zav Fhe Bakɨme phorga nzuavra kim, Fhe Bakɨme ana ndigim, ana mbe thav Hevenan ndai. ");
INSERT INTO geb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Fhe Bakɨme ana ndiga ndaim, mbe thav, thɨvi phɨrav, an zɨ ndi vun kuamkuav ana ndikndigi. Mbe guigira ana ndikndigap, taagiap Zerusareman vui. ");
INSERT INTO geb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Mbe taagia Zerusareman vegap, mbe zazera Fhe Bakɨme Phenan kav Fhe Bakɨme zɨ ndiv vun kuamkuagi.");
INSERT INTO geb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Fhum fhum guarara, kha bigi hɨgi fhuvara. Kameŋ, ana ki. Kha Kameŋ Fhe Bakɨme phorga ki. Mba Kameŋ ne Fhe Bakɨmera fara muuŋgi. ");
INSERT INTO geb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Fhum fhum guarara, kha bigi zumgum hɨgi, kha Kameŋ Fhe Bakɨme phorga ki. ");
INSERT INTO geb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Mba Kameŋra panan Fhe Bakɨme za kha bigi ga muuŋgi. Kha bigɨn the harigi tuav then hɨgi fhuvara. Zakɨra fhuvara! Kha bigi zam, kha Kameŋ za nta muuŋgim, nta hegi. ");
INSERT INTO geb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ana bɨɨŋbɨɨŋ nɨɨŋge ma, mba bɨɨŋbɨɨŋ kha gumgi gu mbigir vhava ŋaar ma. ");
INSERT INTO geb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mba vhava ŋaar, ana gɨngɨnan kav shɨgi. Mba gɨngɨn ana vharav, ana ŋguigirga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Guma mbe, ana niamuuŋ ana tegi, mba guma zɨ khare, Zon. Fhe Bakɨme Zon ga sarigim, ana fhara zɨgi. ");
INSERT INTO geb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Zon mba vhava ŋaar bun suan zav zɨgi. Ana mba vhava ŋaara bun suaŋrim, kha gumgi gu mbigi za mba vhava ŋaara kameŋ mbararagip, ne khothɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Zon, ana nduara, ana mba vhava ŋaar fhuvara. Zakɨra fhuvara! Zon mba vhava ŋaarar kameŋ bun suan zav zɨgi. ");
INSERT INTO geb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mba vhava ŋaar, ana vhava ŋaara guar ma. Mba vhava ŋaar, ana vhava ŋaarar za kha gumgi gu mbigir nɨɨn zav, kha nuianan zeri. ");
INSERT INTO geb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Fhe Bakɨmen Kameŋ ne kha nuianan ki. Mba Kamen panan Fhe Bakɨme kha nuiana muuŋgi. Kha nuianan ki gumgi gu mbigi, mbe ana garav mbe tuituigiap ana kaŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ana vhɨra wo fhain wo ntɨɨri han zɨgim, mbe ana ndigi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Gumgi gu mbigi mbari ana ndigi, mbe ana zɨ khothɨgi gumgi gu mbigi ma. Mbe guigira ana khothɨgim, ana kha zɨn mben kamɨnga tuktɨgi, mbe Fhe Bakɨmen tari kɨrga. ");
INSERT INTO geb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mbe gumgi gu mbigi wari ga rɨgap tari ti tuavar, mbe ana tari ki fhuvara. Zakɨra fhuvara! Mbe ana khothɨgim, Fhe Bakɨme mbe muuŋgim, mbe ana tari ki. ");
INSERT INTO geb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Fhe Bakɨmen Kameŋ, ne guma guara gegap, zerav, nzan rɨgar ki. Fhe Bakɨme mba tara bavira ki. Anan tɨvir vhuuiŋ guarira gum ŋkasŋka bakɨme anan ki. Nza vhɨra ana tɨvir vhuuiŋ guarira gum ana ŋkasŋka bakɨme gangi. Anan tɨvir vhuuiŋ guarira gum kora muumbara bakɨme guigira anan ki. Ana vhɨra guigira Fhe Bakɨmen nza khɨvigi. ");
INSERT INTO geb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Zon ana bun mba gumgi gu mbigi ga nzuav kaav khaŋ nzuai, “Mba guma, gu fhum ana bun nde nzuav khaŋ suaŋgi, ‘Na zɨn zi guma, ana guigira na kambarigi. Ne khaŋ muuŋgi, ana fhum kim, gu zumgum hɨgi.’ ” ");
INSERT INTO geb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ana fhura nza kora mbui kora muumbar, ana khaŋ tɨgap guigira kɨvgiap, ana zazera tɨvir vhuuiŋra za nza mbui. ");
INSERT INTO geb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Khueŋ guigi guarara, Fhe Bakɨme won tɨvir Moses ga nɨɨŋgim, ana mba tɨvir nza nɨɨŋgi. Fhe Bakɨme Zisas Kraisan panan, ana fhura kora mbui kora muumbar gum ana wo buni guarir nza khɨvigi. ");
INSERT INTO geb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Guma the Fhe Bakɨme gangi fhu. Zakɨra fhuvara! Kha Fhe Bakɨmen Kama bavira, ana nduara, ana Fhe Bakɨmera fara muuŋgi. Ana nduara won Ndia han ki. Ana nduara Fhe Bakɨmen nza khɨvigi. ");
INSERT INTO geb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Mbe Zudaiŋ gumgir pani, mbe Fhe Bakɨme rotu gari gumgi mbari gum Rivaiiŋ mbari ga sarigim, mbe Zerusarem thav, zav Zonan nzai, “Ndu the guarara?” ");
INSERT INTO geb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Zon mbaram guigira mbe nzuai, ana buna thueŋ vhagi fhuvara. Ana khaŋ mbe nzuai, “Gu Fhe Bakɨme taagip won gumgi gu mbigi ndir zav suaŋgip sarigi guma fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Mbe thav ana nzarigi, “Maaŋgi ma? Ndu Iraiza e?” Ana khaŋ mbe nzuai, “Gu Iraiza fhuvara!” Mbe khaŋ nzuai, “Ee, ndu nza mba rarga ki Fhe Bakɨmen kamthooŋ guma e?” Ana mbe ŋgarkarav khaŋ nzuai, “Fhuvara!” ");
INSERT INTO geb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mbe mbaram wom ana nzarigi, “Ndu the ma? Maaŋgi nza taagi ŋgɨp, ram muuŋgi kamen nza sarigi nza zegi gumgi ga suaŋrie? Ndu ram mbui suambarar wo mbui?” ");
INSERT INTO geb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Zon mbaram khaŋ mbe nzuai, “Gu mba gumgi ki fhuv ŋanen kav kaai guman kamthooŋ ma. Gu kaav khaŋ nzuai, ‘Guma Bakɨme ndim tuavir muuŋv, nta ndiv thɨgar maaŋri.’ Kha kameŋ, Fhe Bakɨmen kamthooŋ guma Aisaia fhum ne suaŋgi.” ");
INSERT INTO geb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mba gumgi, Fherasiŋ mbe sarigim, mbe Zon han zegi. ");
INSERT INTO geb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Mbe kha nzambara Zon ga muuŋgi “Maaŋ muuŋgiap, ndu Fhe Bakɨme taagip won gumgi gu mbigi ndir zav farasarigi guma fhu, ndu vhɨra Iraiza fhu, ndu vhɨra mba Fhe Bakɨme kamthooŋ guma fhu, ndu thaŋ nzuav mba gumgi gu mbigi ruai?” ");
INSERT INTO geb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Zon mbe ŋgarkarav khaŋ nzuai, “Gu mbɨn mbe ruai. Guma mbe nde rɨgar ki, nde ana kaŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mba guma, ana na zɨn zi. Gu vhɨra zɨ ki guman vhuuŋ fhuvara, gu ana ŋkari sharive mpiiŋ fhɨrgirga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Zon Betanin Zordan mbɨ gaar ra ndai fhain, muen nderen kha kameŋ suaŋgi. Zon mba ŋanen mba gumgi gu mbigi ruai. ");
INSERT INTO geb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mba mɨtimanera Zon Zisas garim, ana ana han zi. Zon mbara khaŋ nzuai, “Ganɨ. Fhe Bakɨme za kha nuianan ki gumgi gu mbigi muuŋgi tɨvi mbatɨgi vhɨzɨr zav farasarigi Sipsiva Ŋguk mbur zi. ");
INSERT INTO geb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Gu fhum mba guma ga nzuav khaŋ suaŋgi, ‘Na zɨn zi guma, ana guigira na kambarigi. Ne khaŋ muuŋgi, ana fhum kim, gu zumgum hɨgi.’ ");
INSERT INTO geb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Gu nduara ana kaŋgi fhu. Gu fhura mbɨn kha gumgi gu mbigi ruai, gu maaŋ muunga, kha Isreriŋ mbe ana kaŋgirga.” ");
INSERT INTO geb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Zon wom nzuav khaŋ nzuai, “Gu Fhe Bakɨmen Ŋina Ŋaara garim, ana Hevenan kegap, fhomne fara muuŋgiap gega zerav, ana phorga ki. ");
INSERT INTO geb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Gu fhum ana kaŋgi fhu. Fhe Bakɨme mbɨn gumgi gu mbigi ruar zav na sarigim, gu zɨgi. Ana fhum khaŋ na suaŋgi, ‘Ndu Fhe Bakɨmen Ŋina Ŋaara ganɨrim, ana zirɨv, guma the phorga kɨrga, mba gumara, ana Fhe Bakɨmen Ŋina Ŋaarar gumgi gu mbigi ruarga.’ ");
INSERT INTO geb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Gu ana gangiap, gu kha kameŋ bun nzuai, khe Fhe Bakɨmen Kam ma.” ");
INSERT INTO geb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mɨtimanera Zon wom thɨgap kim, ana phorga rui guma phuni ana phorgap thɨgap ki. ");
INSERT INTO geb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ana thɨgap kav Zisas garim, ana vui. Zon mbara khaŋ nzuai, “Mbur ganɨ, Fhe Bakɨme za kha nuianan ki gumgi gu mbigi muuŋgi tɨvi mbatɨgi vhɨzɨr zav farasarigi Sipsiva Ŋguk mbure.” ");
INSERT INTO geb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ana phorga rui gumani thɨgap kav, ana nzuai ne mbararagiap, mani Zisas zɨn vui. ");
INSERT INTO geb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Mani Zisas zɨn vuim, Zisas dorgap mani garav, kha nzambarar mani ga muuŋgi, “Ŋko thagɨna ndi gari?” Mani mbara kha nzambarar ana muuŋgi, “Rabai, ndu maaŋgi phenan ki?” Kha zɨ Rabai, ana nɨɨŋge khaŋ nzuai, “Ndɨkndɨgir vhuuiŋ nza khɨvi guma rum.” ");
INSERT INTO geb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Zisas mbaram khaŋ mani ga nzuai, “Ŋko zɨv ganɨ.” Mani mbara ana phorga vov ana ki phena gari. Mani mba raar ana phorga ki. Ne khaŋ muuŋgi, mba raar, ra vera vov fe ndi ra vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andru, ana Saimon Pita phorge rɨgi ne ma. Ana mba guma mbe ma. Ana Zon suaŋgi kameŋ mbararagiap, Zisas zɨn vugi. ");
INSERT INTO geb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ana Zisas thav vov, ana za vov wo phorge rɨgi ne Saimon ndi gari. Ana vov Saimon gangiap, khaŋ Saimon ga nzuai, “Gu Mesaia gangi.” Kha zɨ Mesaia, ana nɨɨŋge khaŋ nzuai, “Fhe Bakɨme taagia wo gumgi gu mbigi ndir zav farasarigi guma ma.” ");
INSERT INTO geb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andru vov Saimon ga suaŋgiap, ana kov Zisas han vui. Ana ana kov vuim, Zisas ana garav khaŋ ana nzuai, “Ndu Saimon, Zonan kam. Mbe zumgum kha zɨn ndun kamɨnga, Sifas.” Kha zɨ Sifas, ana nɨɨŋge khaŋ nzuai, “Pita.” Mba zɨn nɨɨŋge khaŋ nzuai, “Kɨm.” ");
INSERT INTO geb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mba mɨtimanera, Zisas Garirin ŋgirɨr za mbui. Ana vov Firip gangiap, khaŋ ana nzuai, “Ndu na zɨn zɨ.” ");
INSERT INTO geb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Firip, ana Betsaida ŋgun ki guma ma. Ana vhɨra Andru gum Pitar ŋgu guma ma. ");
INSERT INTO geb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Firip mbara vov Natanier gangiap khaŋ ana nzuai, “Nza Moses fhum mba guma bun nzuai buni khergim, nta Moses suaŋgi tɨvi ki gavar ki. Mba Fhe Bakɨmen kamthooŋ gumgi, mbe vhɨra ana bun nzuai buni, mbe nta khergi. Nza mba guma, nza ana gangi. Zisas Nasaret guma ma. Ana Zozevan kam ma.” ");
INSERT INTO geb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ana ne nzuaim, Natanier kha nzambarar ana muuŋgi, “Maaŋ muuŋgim, bigɨna vhuuŋ the Nasaretan kegap hɨgɨrga thi?” Firip mbara khaŋ ana nzuai, “Ndu zɨv ganɨ.” ");
INSERT INTO geb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Mani zim, Zisas Natanier garav, khaŋ nzuai, “Ganɨ, mbur zi guma, ana guigira Isrer guma guar ma. Ana guiguigi buni gum guiguigi tɨva thueŋ ana ki fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanier mbara kha nzambarar Zisas ga muuŋgi, “Ndu ram muuŋgiap na kaŋgi?” Zisas ana ŋgarkarav khaŋ ana nzuai, “Firip, ana zumgum ndun kamgi, gu fharav ndu garim, ndu fik khage nɨɨn ki.” ");
INSERT INTO geb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanier mba kameŋ mbararagiap khaŋ nzuai, “Guman Rum, ndu Fhe Bakɨmen Kam ma. Ndu Isrerin ŋgui vhɨrve gari guman pan ma.” ");
INSERT INTO geb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Zisas ana ŋgarkarav khaŋ nzuai, “Gu khaŋ ndu nzuai, gu ndu garim, ndu fik khage nɨɨn kegi, ndu maaŋ muuŋgiap na khothɨgi. Ndu zumgum bigi bakɨvira ganɨnga, mba bigi kha bigeŋ kambararga.” ");
INSERT INTO geb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Zisas mbara wom khaŋ ana nzuai, “Gu guigira khar ndu nzuai, ndu zumgum Heven ganɨrim, ana fhogɨrga, ndu Fhe Bakɨme enseri ganɨnga, mbe Fhe Bakɨme Guma Guarar naaŋv zirɨrga fara muuŋgirga.” ");
INSERT INTO geb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Zisas Firip gum Natanieran kamgia thugim, ra phuni vhɨzgim, guma mbe Garirin Kana ŋgun muuaŋ rɨgi. Zisasan niamuuŋ mba muuaŋ rɨgi guman shama bakɨmen ki. ");
INSERT INTO geb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Mbe vhɨra Zisas gum ana phorga rui gumgi, mbe vhɨra mben kamgim, mbe zav mba muuaŋ rɨgi guman shama bakɨmen zegi. ");
INSERT INTO geb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mbe mba shama bakɨmen kim, wain vhɨzgim, Zisas niamuuŋ khaŋ ana nzuai, “Kheiŋ wain ki fhu.” ");
INSERT INTO geb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Zisas khaŋ ana nzuai, “Mama, ndu thaŋ nzuav na nzuai? Nan tuk ntigar.” ");
INSERT INTO geb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ana niamuuŋ mbara khaŋ mba ŋaara gumgi ga nzuai, “Ana bigɨn thuen muun saŋv nde suaŋrim, nde fhura mba bigen muuŋri.” ");
INSERT INTO geb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Mba phenan mporathɨgi ndari bakɨvi, mbe kɨman nta muuŋgim, nta ki. Mbe Zudaiŋ, mbe Moses suaŋgi tɨva zɨn vov, mbe mba ndarir phara thuav wari ruai. Nta bevbevira 100 rita phara ntan ki. ");
INSERT INTO geb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Zisas mbara khaŋ mba ŋaara gumgi ga nzuai, “Nde mba ndarir phara thuigiri.” Mbe mba ndarir phara thuigim, nta guigira givigi. ");
INSERT INTO geb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ana mbara khaŋ mbe nzuai, “Nde mba phara thari ndigɨp mba shama bakɨme gari guma ndi ŋgɨ.” Ana maaŋ suaŋgim, mba ŋaara gumgi phara mbari ndiga vugi. ");
INSERT INTO geb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mba phara wain ga gegim, mba shama bakɨme gari guma mba mbɨ mbarir mparigi. Ana mbe mba wain ndigi ŋaneŋ kaŋgi fhuvara. Mba phara thuigi ŋaara gumgi, mbe nduarira ne kaŋgi. Mba shama bakɨme gari guma mbaram mba muuaŋ rɨgi guman kamgi. ");
INSERT INTO geb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ana ana kamgim, ana zim, ana khaŋ ana nzuai, “Mbe gumgi, mbe zam kha tɨva mbui, mbe fharav wain vhuuŋ ndi ndɨɨi.” Mba gumgi za kɨvgia mbegim, mbe zumgum mba maneŋ mbatɨgi wain ndi ndɨɨi. Ndu waina vhuuŋ thɨvav kegap, ndu ntigera ana ndi ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Khe Zisas fhara guarara muuŋgi mirikor ma. Ana Gariri fhain Kana ŋgun ana muuŋgi. Mba mirikor, ana wo zɨ bakɨme gum won ŋkasŋka ndi khɨvi mirikor ma. Ana maaŋ muuŋgim, ana phorga rui gumgi ana gangiap, ana khothɨgi. ");
INSERT INTO geb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Zisas mbara maaŋ Kana thav, ana won niamuuŋ gum, won ŋgugi, gu wo phorga rui gumgir kov, mbe Kaperneaman vergi. Mbe vergap rari mbarir mbe mba ŋgun kegi. ");
INSERT INTO geb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Mbe Zudaiŋ, mbe rotu mbui tuga bakɨ mbe hɨr zav tuga bisaŋ khɨnanera. Mba tuga bakɨme, mbe Fhe Bakɨme fhura Isreriŋ garim, mbe nzerara kegi. Mba tuga bakɨme mbe kha zɨn ana rɨgi, Pasova. Maaŋ muuŋgiap, Zisas Zerusareman ndai. ");
INSERT INTO geb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ana vov garim, mbe Fhe Bakɨme Phena bɨna vhen, mbe borombaga gum sipsivi, korgi, mbe nta ndi mbaim, mbe nta vhezi. Ana garim, mba ŋkɨɨar kurkurigi gumgi, mbe pigiap ki. ");
INSERT INTO geb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Zisas mbe gangiap, mbara mpiiŋ ndigap wip ga muuŋgi. Ana wip ga muuŋgiap, mben borombaga gum sipsivi zɨtɨgim, nta Fhe Bakɨme phena bɨnan kɨrar hi. Ana mba ŋkɨɨar kurkurigi gumgir kaagi dagasuim, mben ŋkɨɨa fhura kɨzrɨga tamtam vui. ");
INSERT INTO geb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ana maaŋ mbe mbuav, mba korgi ndi mbai gumgi ga nzuai, “Nde wari won korgi ndigɨ ŋgɨri. Nde zazera na Dara phena mbuim, ana nde phogi ga vhov bigi ndi mbai phena farar muuŋ thari.” ");
INSERT INTO geb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ana phorga rui gumgi ana garim, ana mba tɨva mbuim, mbe mba Fhe Bakɨmen buni vhuuiŋ ki gavar ki kama mueŋ ga ndɨrigi. Mba kameŋ khaŋ nzuai, “Gu guigi guarara ndun phena vuzvugi. Mba vuzvuk na ndava vhee khavim, gu maaŋ muuŋgiap, khaŋ tɨgap havhargiap ndun phenan muuŋrim, ana nzerara kɨr za mbui.” ");
INSERT INTO geb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mbe Zudaiŋ, mbe Zisas garim, ana mba tɨva muuŋgim, mbe kha nzambarar ana muuŋgi, “Ndu the, ndu kha tɨva muuŋgi? Ndu ntige ram mbui khesharigi mirikor then muuŋgirim, nza ana gangip kaŋgirga, ndu zɨ kav, ndu ntigem kha tɨva muuŋgi?” ");
INSERT INTO geb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Zisas mben kameŋ ŋgarkarav khaŋ mbe nzuai, “Nde kha Fhe Bakɨme Phen, nde ana phɨrgirga, gu ra phuni khegenen, gu taagi ana muuŋgirga.” ");
INSERT INTO geb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mbe Zudaiŋ ne mbararagiap khaŋ nzuai, “Mbaia, kha 46 mparir mbe kha phena mbuav kav ana muuŋgi. Ee, taka, ndu ra phuni khegenera wom anan muuŋgirga thi?” ");
INSERT INTO geb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Zisas mba rotu ga mbui phena nzuai ne khaŋ muuŋgi, ana won fhavara vhunamara sav nzuai. ");
INSERT INTO geb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Maaŋ muuŋgiap, ana rimgim, Fhe Bakɨme taagia ana khavgim, ana phorga rui gumgi, mbe ana mba fhum suaŋgi kameŋ, mbe wom ne ga ndɨrigi. Mbe ne ndɨrgap, mbe Fhe Bakɨme buni vhuuiŋ ki gavar ki buni, mbe nta khothɨgap, mbe vhɨra Zisas mba suaŋgi kameŋ, mbe ne khothɨgi. ");
INSERT INTO geb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Zisas Isreriŋ Pasova tuga bakɨmen Zerusareman kim, gumgi gu mbigi vhɨrve ana muuŋgi mirikori gangi. Mbe maaŋ muuŋgiap ana khothɨgi. ");
INSERT INTO geb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mbe maaŋ mbuim, Zisas mbe khothɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ne khaŋ muuŋgi, ana za mba gumgir tɨvi kaŋgi. Ana bigɨn the kakagirim, guma the mbe won tɨvi gu bigi bun ana suaŋrie? Zakɨra fhuvara! Ana nduara mben ndɨkndɨgi kaŋgi. ");
INSERT INTO geb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Guma mbe ki, mba guma zɨ Nikodemus, ana Fherasi guma ma. Ana Zudaiŋ gari guman pana mbe ma. ");
INSERT INTO geb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ana maan Zisas han zav, khaŋ ana nzuai, “Guma Rum, nza kaŋgi, Fhe Bakɨme ndɨkndɨgir vhuuin nza khɨvɨr zav ndu sarigi ndu zɨgi. Fhe Bakɨme maaŋ muuŋgip guma the phorgɨ kɨrga fhu, mba guma ndu khar mbui mirikorir muuŋgirga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Zisas, ana ŋgarkarav khaŋ ana nzuai, “Gu guigira ndu nzuai, guma ana guman kama gegɨrga fhu, ana Fhe Bakɨme gari gumgi gu mbigi, mbe ana piin ki, ana mbe phorgɨp kegɨrga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ana ne nzuaim, Nikodemus ana nzarigi, “Guman vur, ana ram muuŋgip, taagip guman kama gegɨrie? Ee, ana taagip won niamuuŋ ndava vhen ŋgirgɨrim, ana niamuuŋ taagip ana tegɨrie?” ");
INSERT INTO geb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Zisas ana ŋgarkarav khaŋ nzuai, “Gu guigira ndu nzuai, guma maaŋ muuŋgip mbɨ gu Fhe Bakɨmen Ŋina Ŋaara ruagirga fhu, ana Fhe Bakɨme gari gumgi gu mbigi, mbe ana piin ki, ana mbe phorgɨp kegɨrga tuktɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Guma won fhavar vuzvugar ndi hiaŋ tɨgi bigɨn, ana kha fhava bigɨn ma. Fhe Bakɨmen Ŋina Ŋaar hiaŋ tɨgi bigɨn, ana Fhe Bakɨmen Ŋinan Ŋaarar bigɨn ma. ");
INSERT INTO geb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ndu gu ndu suaŋgi kameŋ mbararagip, ne suaŋv ŋgava mbatɨgar muuŋ thari, ‘Nde taagip ŋkaa ga gegɨri.’ ");
INSERT INTO geb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Bɨɨŋbɨɨŋ, ana wo vuzvugara vov, ana tamtam vuim, ndu ana khɨkhɨm mbararagi. Ndu ana kega zi ŋaneŋ kaŋgi fhu, ndu vhɨra ana vui ŋaneŋ kaŋgi fhu. Mba Fhe Bakɨmen Ŋina Ŋaar gumgi ga mbuim, mbe gumgir ŋkaa ga gi tɨv, ana mba tɨvara muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ana ne nzuaim, Nikodemus kha nzambarar ana muuŋgi, “Ndu kha nzuai bigeŋ ram mbui tɨvar muuŋgip hɨgɨrie?” ");
INSERT INTO geb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Zisas mbara ana ŋgarkarav khaŋ ana nzuai, “Ee, ram muuŋgi? Ndu Moses suaŋgi tɨvir Zudaiŋ khɨvi zɨ ki guma ma. Ndu kha bigi kaŋgi fhuve? ");
INSERT INTO geb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Gu guigira ndu nzuai, nza wo kaŋgi bigi, nza nta nzuai. Nza kha bun nzuai bigi, nza nta gangi. Nza nta bun nzuaim, nde kɨr nza nzuai buni ga segi. ");
INSERT INTO geb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Gu nuiana bigi bun nde nzuaim, nde nta khothɨgi fhuvara. Maaŋ muuŋgip, gu Hevenan ki bigi bun nde suanga, nde ram muuŋgip nta khothɨgɨrie? ");
INSERT INTO geb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Harigi guma the Hevenan ndagi fhu. Zakɨra fhuvara! Fhe Bakɨme Guma Guar, ana nduara Hevenan kegap kha nuianan zergi. ");
INSERT INTO geb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moses, fhum gumgi ki fhuv ŋanen kuruga ŋgatɨgap ana ndi ntorgi, mbe mba tɨvara, mbe Fhe Bakɨme Guma Guara ndi ntorgɨrga. ");
INSERT INTO geb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Mbe maaŋ anan muuŋgirga, ana khothɨgi gumgi ne nzuav, mbe zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigirga. ");
INSERT INTO geb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Fhe Bakɨme, ana Kama bavira ki. Ana guigira wo ndavar kha nuianan ki gumgi gu mbigi ga nɨɨŋgiap, ana ne nzuav mba Kama bavira, ana anan mbe nɨɨŋgi. Ana maaŋ muuŋgim, mba ana khothɨgi gumgi gu mbigi, mbe fhɨrgi rɨgɨp vhɨzgirga tuktɨgi fhu. Zakɨra fhuvara! Mbe zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigirga. ");
INSERT INTO geb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Fhe Bakɨme kha nuianan ki gumgi gu mbigi mbui tɨvi ganɨv nta suaŋv mbe suan zav won Kama sarigim, ana kha nuianan zergi fhuvara. Ana taagip mbe ndir zav ana sarigim, ana zergi. ");
INSERT INTO geb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Guma ana khothɨgi, ana ana suaŋv suanga kameŋ ki fhu. Guma ana khothɨgi fhu, mba guma ana fhɨrge rɨgap vhɨzgi. Ne khaŋ muuŋgi, ana mba Fhe Bakɨmen Kama bavira, ana ana zɨ khothɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Fhe Bakɨme mbe nzuav nzuai ne nɨɨeŋ khaŋ muuŋgi. Vhavar ŋaar kha nuianan hɨgap ana shɨrigi. Kha gumgi gu mbigi, mbe guigira gɨngɨnan kɨrga ne vuzvugi. Mbe vhavar ŋaarar kɨrga ne vuzvugi fhuvara. Ne khaŋ muuŋgi, mbe tɨvi mbatɨgi ga mbui gumgi gu mbigi ma. ");
INSERT INTO geb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mba tɨvi mbatɨgi ga mbui gumgi, mbe mba vhava ŋaarar pana gumgi ma. Mbe wari wo mbui tɨvi kɨrar hɨrga ne vuzvugi fhuvara. Mbe maaŋ muuŋgiap mba vhava ŋaara han zi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Guma tɨvi guari zɨn vui, ana mba vhava ŋaara han zim, mba gumgi gu mbigi, mbe tuituigip mbe ganɨv kaŋgirga, ana Fhe Bakɨme zɨn vui.” ");
INSERT INTO geb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Zisas zumgum wo phorga rui gumgir kov, mbe Zudia ŋgu bakɨme fhain vui. Ana mben kov vov, mbe phorgap maaŋ kav, ana mba gumgi gu mbigi ruai. ");
INSERT INTO geb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Zon vhɨra Sarim ŋgun han Ainon ŋgun kav gumgi gu mbigi ruai. Ne khaŋ muuŋgi, phara vhɨrve mba ŋanen kim, gumgi gu mbigi vhɨrve wari ruar zav ana han zi. ");
INSERT INTO geb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mba tugen Herot ntigar Zon ndim phena tɨvaneŋ ga surga. ");
INSERT INTO geb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Zon phorga rui gumgi gum Zuda guma mbe, mbe wari phorga nzuav wari daai. Mbe khueŋ nzuav wari daai, mbe ram mbui khesharigi ruarɨr muuŋgip, mbe Fhe Bakɨme nɨman ŋgararie? ");
INSERT INTO geb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mbe wari ga nzuav, Zon phorga rui ŋaara gumgi mbari Zon han zav khaŋ ana nzuai, “Guma Rum, mba fhum ndu phorgap ra ndai fhain mueŋ nderen Zordan mbɨn kegi guma, ndu ana buni vhuuiŋ bun suaŋgi, ana ntigem gumgi gu mbigi ruaim, gumgi gu mbigi zam ana han vui.” ");
INSERT INTO geb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Zon mbara mbe ŋgarkarav khaŋ nzuai, “Maaŋ muuŋgip, kha Hevenan ki Fhe Bakɨme, ana bigɨn then guma then nɨɨŋgirga fhu, mba guma mba bigɨna ndigɨrga fhu. ");
INSERT INTO geb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nde nduarira gu fhum suaŋgi kameŋ mbararagi, ‘Gu mba Fhe Bakɨme taagip won gumgi gu mbigi ndir zav farasarigi guma fhuvara. Gu Fhe Bakɨme na sarigim, gu mba guma nɨma tɨgap fhara zɨgi.’ ");
INSERT INTO geb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Maaŋ muuŋgip, guma the mbiga then tɨgɨrga, mba mbik, ana mba guman muuŋ ma, ana ana tɨgi. Ana khurkhum thɨgap, khuarar ana buni ga tɨgap, nta mbararav ntan ndikndigi. Mba tɨvara, gu ntigem ndikndiga mbatɨga mbui. ");
INSERT INTO geb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ana zɨ guigira kɨvgirim, na zɨ nɨɨn ŋgirgɨri. ");
INSERT INTO geb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Guma Hevenan kegap zergi, ana za kha bigi kharav vun ki. Kha nuiana guma, ana kha nuianan tɨvi ga mbui. Ana vhɨra kha nuianan bigi ga nzuai. Guma Hevenan kegap zergi, ana za kha bigi kharav, vun ki. ");
INSERT INTO geb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ana mba garav mbararagi bigi, ana nta bun nzuai. Ana nta bun nzuaim, guma the mba buni ndigap ntan suirigi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Guma ana buni ndigap, nta suira havhargi, ne khaŋ muuŋgi, ana Fhe Bakɨme khothɨgap kha ndɨkndɨga mbui, ana buni guigira buni ma. ");
INSERT INTO geb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Fhe Bakɨme sarigi zi guma, ana Fhe Bakɨme buni bun nzuai. Ne khaŋ muuŋgi, Fhe Bakɨme won Ŋina Ŋaarar fɨgeŋra ana nɨɨŋgi fhuvara. Ana za won Ŋina Ŋaarar ana nɨɨŋgi. ");
INSERT INTO geb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ndia ana guigira won Kama vuzvugiap, mba bigir za won Kama farve khɨngi. ");
INSERT INTO geb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Guma, ana Kama khothɨgi, ana zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ki. Guma, ana Kama nzuai buni zɨn vui fhu, ana zazera mbara muuŋgia ki bɨɨŋbɨɨŋ ndigirga tuktɨgi fhu. Zakɨra fhuvara! Fhe Bakɨmen ndav shirɨ anan ki.” ");
INSERT INTO geb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mbe Fherasiŋ, mbe mbararagim, Zisas gumgi gu mbigi vhɨrve ruaim, mbe ana zɨn vui gumgi gu mbigi kim, mben vhɨrve Zon zɨn vui gumgir vhɨrve kambarigi. ");
INSERT INTO geb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Mbe ne mbararagi, Zisas, ana nduara gumgi thari ruagi fhu. Mba Zisas phorga rui gumgi, mbe nduarira mbe ruai. ");
INSERT INTO geb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Zisas khueŋ kaŋgi, mbe Fherasiŋ, mbe kaŋgi, gumgi vhɨrvera ana zɨn vuim, ana maaŋ muuŋgiap, Zudia ŋgu bakɨme fhaiŋ thav, taagia Gariri ŋgu bakɨme fhain veri. ");
INSERT INTO geb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ana mba veri tuav, ana Samaria ŋgu bakɨme fhaiŋ shɨra vergi. ");
INSERT INTO geb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Zisas maaŋ muuŋgiap vera vov Samaria ŋgu mben hɨgi. Mba ŋgu khare, Sikar. Sikar ana Zekop won kama Zosep ga nɨɨŋgi nuianeŋ han ki. ");
INSERT INTO geb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Zekop fhum korgi mbok mbɨ mbe maaŋ ki. Zisas Sikar hɨgap, ana vhugi. Ana maaŋ muuŋgiap mba mbok mbɨ taan perav kim, ra vov purara thɨgim, phɨɨŋ muuŋgim, ana mbara ki. ");
INSERT INTO geb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ana phorga rui gumgi, mbe mba vhezɨr zav ŋgun vegi. ");
INSERT INTO geb_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Zisas perav kim, Samaria mbiga mbe mbɨ thor zav zim, Zisas khaŋ ana nzuai, “Mbɨ thige nan nɨɨŋ, gu mbɨrga.” ");
INSERT INTO geb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mba Samaria mbik khaŋ ana nzuai, “Ai, ndu Zuda guma ma. Gu Samaria mbik ma. Ndu thaaŋ nzuav khaŋ na nzuai, ‘Mbɨ thige nan nɨɨŋ, gu mbɨrga’ ? ” Mba mbik mba kameŋ nzuai, ne khaŋ muuŋgi, mbe Zudaiŋ, mbe khurkhuur Samariaiŋ khuui fhu. ");
INSERT INTO geb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Zisas mbara khaŋ mba mbiga nzuai, “Ndu Fhe Bakɨme fhura nɨɨŋgi bigeŋ kaŋgip, khaŋ ndu nzuai guma ‘Mbɨ thige nan nɨɨŋ, gu mbɨrga,’ ndu ana nzanga, ana zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndi ndɨɨi mbɨn ndun nɨɨŋgirga.” ");
INSERT INTO geb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ana maaŋ nzuaim, mba mbik khaŋ ana nzuai, “Guma, ndu mbɨ thui nda ki fhu, kha mbok mbɨ guigira mbar vergi. Maaŋ muuŋgip, ndu maaŋ mba zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndi ndɨɨi mbɨ ndigirie? ");
INSERT INTO geb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nzan nzɨk Zekop, ana nza nzuav kha mbok mbɨ korgi. Kha mbok mbɨ, ana nduara won tarir kov, won borombaga gum, sipsivi gu bigi, mbe kha mbok mbɨra mbegi. Ee, ndu Zekop kambarigire?” ");
INSERT INTO geb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Zisas ana kameŋ ŋgarkarav khaŋ ana nzuai, “Kha mbok mbɨ pi gumgi, mbe zam taagi fhɨri khirga. ");
INSERT INTO geb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Guma the maaŋ muuŋgip gu khar nɨɨn za nzuai mbɨ, ana ana mbegɨrga, ana wom taagip tuga then fhɨr khigirga tuktɨgi fhuvara. Zakɨra fhuvara! Gu mba anan nɨɨn za nzuai mbɨ, ana mɨmɨra mbɨ farar muuŋgip ana vhen kɨrga. Mba mbɨ zazera anan kɨv hɨv, zazera mbara muuŋgiap ki bɨɨŋbɨɨn anan nɨɨnga.” ");
INSERT INTO geb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mba mbik mbaram khaŋ Zisas ga nzuai, “Guman Rum, ndu mba mbɨn nan nɨɨŋ. Maaŋ muuŋgirga, gu zumgum wom fhɨr khirga fhu. Gu vhɨra wom kha mbok mbɨn zɨv mbɨ thorga fhu.” ");
INSERT INTO geb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Zisas mbara khaŋ ana nzuai, “Ndu fharav ŋgɨp wo manan kamgip taagi khaŋ zɨri.” ");
INSERT INTO geb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mba mbik ana ŋgarkarav khaŋ nzuai, “Gu man ki fhu.” Zisas mbara khaŋ ana nzuai, “Ndu khaŋ nzuai ndu man ki fhu. Ndu guigira mbar nzuai. ");
INSERT INTO geb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ne khaŋ muuŋgi, ndu fhum meeŋthɨgi gumgi ga tɨga kegi. Ndu ntigem mba phorga ki guma, ana ndun mana guar fhuvara. Ndu mba nzuai kameŋ ne guigi guarara.” ");
INSERT INTO geb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mba mbik khaŋ ana nzuai, “Gu ndu garim, ndu Fhe Bakɨmen kamthooŋ guma mbe ma. ");
INSERT INTO geb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nzan nzɨgi, mbe kha mbɨkshɨman phogi ga vhuav Fhe Bakɨme rotu mbui. Nde Zudaiŋ, nde khaŋ nzuai, ‘Gumgi za ŋgɨp rotur muunga ŋaneŋ, ne Zerusaremra ki.’ ” ");
INSERT INTO geb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Zisas mbara khaŋ ana nzuai, “Mbik, ndu gu nzuai buni, ndu nta khothɨgɨri. Ntige tuga the nden hɨgɨrga, nde mba Dara rotu mbui mbɨkshɨm, nde wom ana Dara rotur muunga fhu, nde vhɨra wom Zerusareman ana rotur muunga fhu. ");
INSERT INTO geb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nde Samariaiŋ, nde mba rotu mbui ne, nde ana kaŋgi fhuvara. Nza Zudaiŋ, nza wari wo rotu mbui bigɨn, nza ana kaŋgi. Ne khaŋ muuŋgi, Fhe Bakɨme nza Zudaiŋ, ana fharav taagip wo gumgi gu mbigi ndirga ŋaarar muun zav nzan farasarigi. ");
INSERT INTO geb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mba hɨr za mbui tuk, ana ntigem hɨgi. Mba guigira rotur muun za mbui gumgi, mbe Fhe Bakɨmen Ŋina Ŋaara ŋkasŋkar panan Fhe Bakɨme rotur muuŋv, mbe vhɨra tɨva guara zɨn ŋgɨp rotur muunga. Mba khesharigi rotu ga mbui gumgi, Dara guigira mbe vuzvugi. ");
INSERT INTO geb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Fhe Bakɨme, ana Ŋina ma. Maaŋ muuŋgiap, gumgi ana rotu mbui, mbe Fhe Bakɨme Ŋina Ŋaara ŋkasŋkar panan ana rotur muuŋv, guigira tɨva guarara zɨn ŋgɨp, rotur muuŋri.” ");
INSERT INTO geb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mba mbik khaŋ Zisas ga nzuai, “Gu kaŋgi, Mesaia, mbe kha zɨn ana rɨgi, Krais, ana zɨrga. Ana zɨgɨp, ana za mba bigi bun nza suanga.” ");
INSERT INTO geb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Zisas mbara khaŋ ana nzuai, “Gura khare, gu ntige ndu phorga nzuai.” ");
INSERT INTO geb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Zisas nen ana nzuaim, ana mba phorga rui gumgi vegap taagia wari zi. Mbe ana garim, ana mbiga mbe phorga nzuaim, mbe ŋgava mbatɨga muuŋgi. Mbe ŋgava mbatɨga mbuav, mbe the kha nzambarar ana muuŋgi fhu, “Ndu thagɨna ndir zav ana phorga nzuai?” o, “Ndu thaaŋ nzuav mba mbiga phorga nzuai?” ");
INSERT INTO geb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mba mbik wo mbɨ thui nda ndi mbara ndarav taagia ŋgun vugi. Ana vov khaŋ mba gumgi gu mbigi ga nzuai, “Nde zɨv guma the ganɨnga. ");
INSERT INTO geb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Mba guma gu fhum muuŋgi bigi, ana za nta bun na suaŋgi. Ana Krais thi?” ");
INSERT INTO geb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ana maaŋ mbe suaŋgim, mbe mba ŋgu thav, Zisas han zi. ");
INSERT INTO geb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mba tugen Zisas phorga rui gumgi khaŋ tɨgap ana nzuai, “Guman Rum, ndu mban mbɨ.” ");
INSERT INTO geb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ana thav khaŋ mbe nzuai, “Gu mba ki, nde mba mba kaŋgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ana maaŋ suaŋgim, ana phorga rui gumgi, mbe nduarira khaŋ wari ga nzuai, “Guma the mba ndiga zav ana nɨɨŋgi thi?” ");
INSERT INTO geb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Zisas mbara khaŋ mbe nzuai, “Fhe Bakɨme na sarigim, gu zɨgi. Nan mba khare, gu ana vuzvuga zɨn ŋgɨp, ana mba na nɨɨŋgi ŋaar, gu anan muuŋv, ana vhɨzgirga. ");
INSERT INTO geb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Nde khaŋ nzuai, fethɨgi kɨnira khar ki, mba ndirga tuk hɨgɨrga. Nde maaŋ nzuai, gu khaŋ nde nzuai, nde tamtam mba mɨni ganɨv, tuituigip nta ganɨri. Mba mɨnin mba gɨvigi. ");
INSERT INTO geb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mba ndi gumgi, mbe wari won vheza ndigap, mbe mba ndiav phogi ga vhui. Mbe mba phogi ga vhui mba, nta mba zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigi gumgi gu mbigi ma. Maaŋ muuŋgiap, mban pargi guma gum mba ndi phoga vhuigi guma, mani wani tɨgɨp vhɨra ndikndigɨri. ");
INSERT INTO geb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Maaŋ muuŋgiap, kha kameŋ, ne guigi guarara, ‘Guma mbe mɨnan pargim, guma mbe mba mɨnan mba ndi.’ ");
INSERT INTO geb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Gu nde sarigi nde ŋgɨp, nde fhum ŋgarigi fhuv mɨnin mba ndiri. Mbe harigi gumgi, mbe mba mɨnin ŋgargi, nde mben hari thoorir hɨgi mba, nde nta ndiri.” ");
INSERT INTO geb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mbe Samariaiŋ vhɨrve, mbe mba ŋgu vhen kav mba mbiga kameŋ mbararagiap, mbe Zisas khothɨgi. Mbe khaŋ muuŋgiap, mba mbik khaŋ mbe nzuai, “Ana gu fhum muuŋgi bigi, ana za nta bun na suaŋgi.” ");
INSERT INTO geb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Maaŋ muuŋgiap, mba Samariaiŋ, mbe ana han zav, khaŋ tɨgap wari han kɨr zav ana nzai. Maaŋ muuŋgiap, ana ra phuninin mba ŋgun kegi. ");
INSERT INTO geb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ana maaŋ kim, gumgi gu mbigi vhɨrve guarira, mbe Zisas buni mbararav ana khothɨgi. ");
INSERT INTO geb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mbe ana khothɨgap, khaŋ mba mbiga nzuai, “Nza ndu bunira mbararagiap ana khothɨgi fhuvara. Nza nduarira ana buni mbararagiap, nza kaŋgi, kha gumara, ana taagip kha nuianan ki gumgi gu mbigi, ana za mbe ndirga.” ");
INSERT INTO geb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Zisas ra phuninin Samariaiŋ han kegap, mbe thav Gariri ŋgu bakɨme fhain vergi. ");
INSERT INTO geb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Zisas nduara khueŋ suaŋgi, “Fhe Bakɨme kamthooŋ guma, ana wo ŋgu nɨɨŋgera, mbe zɨ bakɨme ana ndɨɨi fhu.” ");
INSERT INTO geb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ana vov Garirin hɨgim, mbe Gaririŋ ana nzuav ndikndigi. Mbe ndikndigi, ne khaŋ muuŋgi, mbe nduarira mba Pasova rotu bakɨmen muun zav Zerusareman ndav, mbe ana muuŋgi bigi, mbe nta gangi. ");
INSERT INTO geb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Zisas taagia zav Garirin Kanan ŋgun zɨgi. Ana fhum mba ŋgun mbɨ muuŋgim, ana wain ga gegi. Ana taagia Kanan zɨgim, mba tugen ŋgui vhɨrve gari guman panan ŋaari gari guman pana mbe, ana Kaperneam ŋgun ki, ana kam rɨɨi. ");
INSERT INTO geb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mba guma, ana kha kameŋ mbararagi, Zisas Zudia thav Garirin zergi. Ana maaŋ muuŋgiap, ana Zisas han vov, Kaperneaman zirɨ zav anan nzai, ana zirɨv ana kaman kurarim, ana rɨmrɨm nzerarga. Ana kam rɨmɨn zav gorvhɨk bisanera. ");
INSERT INTO geb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Zisas mbaram khaŋ ana nzuai, “Nde mbarkɨrga mirikori gangirga fhu, nde bigɨn thueŋ khothɨgɨrga fhu.” ");
INSERT INTO geb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mba ŋgui vhɨrve gari guman panan ŋaari gari guman pan khaŋ ana nzuai, “Guman Rum, ndu vhemkora zirɨri. Ndu muuŋv kɨrim, nan kam rimgirga.” ");
INSERT INTO geb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Zisas mbara khaŋ ana nzuai, “Ndu ŋgɨ, ndun kam rimgirga fhu, ana taagi nzerarga.” Ana maaŋ suaŋgim, mba ŋgui vhɨrve gari guman panan ŋaari gari guman pan Zisas khothɨgap, ana taagia vui. ");
INSERT INTO geb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mba ŋgu gari guman pan, ana ntigar ŋgɨp Kaperneaman hɨrga, anan ŋaara gumgi mbari zav tuavar ana purav, khaŋ ana nzuai, “Ndun kam, ana rɨmrɨm vhɨzgiap taagia nzerav nzerara mbur ki.” ");
INSERT INTO geb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ana mben nzarigi, “Mba tar, ana ra vov maaŋ thivim, ana maneŋ nzerigi. Mbe khaŋ ana nzuai, gurum, ŋkotugan ra vov phɨɨŋ ndiga phogia thɨgim, ana rɨmrɨm vhɨzgim, ana nzerigi.” ");
INSERT INTO geb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mbe ne nzuaim, ana ndia kaŋgi, gurum ra vov phɨɨŋ ndigap phogia thɨgim, Zisas khaŋ ana suaŋgi, “Ndun kam rɨmrɨm vhɨzgip nzerara kɨrga.” Maaŋ muuŋgiap, ana Zisas khothivim, ana phorga ki ntɨɨri, mbe vhɨra za Zisas khothɨgi. ");
INSERT INTO geb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Khe Zisas Zudia thav zerav Garirin kav phenatɨtɨgap muuŋgi mirikor ma. ");
INSERT INTO geb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Zumgum Zudaiŋ rotu mbui tuga bakɨ mbe hɨgim, Zisas Zerusareman ndagi. ");
INSERT INTO geb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Mba Zerusarem ŋgu bakɨmen vhen veri bɨna thɨmkama bakɨme, mbe kha zitɨr ana mbui, Sipsivir Thɨmkamani. Mba thɨmkamani han mbok mbɨ bakɨ mbe ki. Mbe Hibruin kaman kha zitɨr ana mbui, Betesda. Mba mbok mbɨ gaar meeŋthɨgi vurirkaaveŋ ki. ");
INSERT INTO geb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Mba vurirkaar rɨɨi gumgi vhɨrve regap ki. Mbe mbari, rɨmgi mbatɨgi gumgi gum, suira mbatɨgi gumgi, hari gu bigi rimgi gumgi, mbe ki. ");
INSERT INTO geb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mba vunkama mben guma mbe rɨɨv ki. Mba guma, mba rɨmrɨm anan kim, 38 thɨgi mpari vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Zisas mba guma garim, ana rɨgap kim, ana kaŋgi, ana tuga mpeeŋra rɨɨv ki. Zisas mbara ana nzarigi, “Ndu rɨmrɨm vhɨzɨrgane vuzvugi thi?” ");
INSERT INTO geb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mba rɨɨi guma ana ŋgarkarar khaŋ nzuai, “Guma Rum, mba mbok mbɨ khɨkhɨm hɨm, nan suirav na ndi mba mbok mbɨn vhorga guma ki fhu. Gu nduara ŋgirɨr za mbui, gu tuktɨgi fhuvara, harigi gumgi na kambav veri.” ");
INSERT INTO geb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Zisas mbara khaŋ ana nzuai, “Ndu khavgip wo mat ndigip ŋgɨ.” ");
INSERT INTO geb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ana ne nzuavra thagim, mba guma rɨmrɨm vhɨzgim, ana fhav taagi nzerigim, ana won mat ndigap vui. Zisas ana kurigi raa, ana Sabat raa ma. ");
INSERT INTO geb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Maaŋ muuŋgiap, mbe Zudaiŋ mba guma gangiap khaŋ ana nzuai, “Ntige Sabat ma, Moses suaŋgi tɨvi khaŋ nzuai, ndu ntige wo mat ndigi rurga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ana mbe ŋgarkarav khaŋ mbe nzuai, “Mba nan kurigi gu nzerigi guma, ana khaŋ na nzuai, ‘Ndu wo mat ndigi ŋgɨ.’ ” ");
INSERT INTO geb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Mbe mbara anan nzarigi, “Maaŋgi guma khaŋ ndu suaŋgi, ndu wo mat ndigi ŋgɨri?” ");
INSERT INTO geb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mba rɨmrɨm vhɨzgi guma, ana mba ana suaŋgi guma, ana ana kaŋgi fhuvara. Ne khaŋ muuŋgi, mbe gumgi vhɨrvera maaŋ kim, Zisas vugi. ");
INSERT INTO geb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Zisas zumgum vov Fhe Bakɨme phena bɨna vhen verav mba guma garim, ana kim, Zisas khaŋ ana nzuai, “Ndu mbarara. Ndu ntige rɨmrɨm vhɨzgim, ndu nzerigi. Ndu wom tɨvi mbatɨgir muuŋ thari. Ndu wom tɨva mbatɨga thuen muuŋgirga, simtɨga bakɨ guarara ndun hɨgɨrga.” ");
INSERT INTO geb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ana maaŋ ana suaŋgim, mba guma mbara vov khaŋ mba Zudaiŋ ga nzuai, “Mba nan kurigim, nan rɨmrɨm vhɨzgi guma, ana Zisas ma.” ");
INSERT INTO geb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ana maaŋ suaŋgi, mbe Zudaiŋ thav tɨva mbatɨgar Zisas ga mbui. Ne khaŋ muuŋgi, ana Sabatar mba tɨva muuŋgi. ");
INSERT INTO geb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mbe maaŋ mbuim, Zisas mbe ŋgarkarav khaŋ mbe nzuai, “Nan Ndia rari tugɨratɨgap ŋgara zav ntige kha tuge thɨgi. Gu vhɨra, gu ntige mba tɨvara zɨn vov ŋgari.” ");
INSERT INTO geb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mbe Zudaiŋ mba kameŋ mbararagiap, mbe guigira Zisas shogirim, ana rimgirga ne vuzvugi. Ne khaŋ muuŋgi, ana Sabat tɨvara phɨrgi fhuvara. Ana vhɨra khueŋ suaŋgi, Fhe Bakɨme ana Ndiara. Ana mba kameŋ nzuai ne khaŋ muuŋgi, ana Fhe Bakɨmera fara muuŋgi. ");
INSERT INTO geb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Zisas mba Zudaiŋ kameŋ ŋgarkarav khaŋ nzuai, “Gu guigira nde nzuai, Kam, ana wo ndɨkndɨgara bigɨn thuen muuŋgirga tuktɨgi fhuvara. Zakɨra fhuvara! Ana won Ndia garim, ana mbui bigi, ana ntara mbui. Ndia mbui tɨvi, Kam vhɨra mba tɨvira mbui. ");
INSERT INTO geb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ndia, ana guigira won Kama vuzvugiap, ana wo mbui bigi, ana za ntan won Kama khɨvigi. Ndia, ana harigi ŋaari bakɨvir muunganen won Kama khɨvarga. Mba ŋaari ana kha fhara muuŋgi ŋaari kambararga. Nta guigira nden muuŋrim, nde ŋgava mbatɨgar muunga. ");
INSERT INTO geb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ndia, ana mba vhɨzgi gumgi, ana taagia mbe khavav, zazera mbara muuŋgiap ki bɨɨŋbɨɨn mbe ndɨɨi. Mba tɨvara, Kam ana wo vuzvugara, ana zazera mbara muuŋgiap ki bɨɨŋbɨɨn ana wo vuzvugi gumgi ga ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ndia, ana gumgi ga nzuav nzuai fhuvara. Ana mba gumgi muuŋgi bigi gu tɨvi ga suaŋv mbe ganɨv, mbe suan zav, za mba bigir won Kama farve khɨngi. ");
INSERT INTO geb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Maaŋ muuŋgiap, kha gumgi, mbe Ndia zɨ ndiv vun kuamkuagi tɨvara, mbe zam Kama zɨ ndiv vun kuamkuarga. Guma, ana Kama zɨ ndiv vun kuamkuagi fhu, ana vhɨra mba Kama sarigim, ana zɨgi Ndia zɨ ndiv vun kuamkuagi fhu. ");
INSERT INTO geb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Gu guigira khar nde nzuai, guma, ana na buni mbararagiap, ana na sarigi gu zɨgi Ndia, ana ana khothɨgi, ana zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigi. Gu ana suaŋv suaŋgirga tuktɨgi fhu, ana rɨɨi tuav thav, ana zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigi. ");
INSERT INTO geb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Gu guigira khar nde nzuai, mba hɨr za mbui tuk, ana ntige khar hɨgi. Mba vhɨzgi fara muuŋgiap ki gumgi gu mbigi, mbe Fhe Bakɨmen Kama kamthooŋ mbarararga. Mba ana mbararagi gumgi gu mbigi, mbe rimgiap, taagia khavgiap bɨɨŋbɨɨŋ ndigi fara muuŋgiap wari ki. ");
INSERT INTO geb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ndia, ana zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ nɨɨŋge ma. Ana ŋkasŋkan Kama nɨɨŋgim, ana vhɨra mba tɨvara muuŋgiap zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ nɨɨŋge ma. ");
INSERT INTO geb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ana Fhe Bakɨme Guma Guar ma. Maaŋ muuŋgiap, Ndia zɨ bakɨmen ana nɨɨŋgi, ana kha gumgi gu mbigi muuŋgi tɨvi ga suaŋv mbe suanga. ");
INSERT INTO geb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nde ŋgava mbatɨgar na bunin muuŋ thari. Mba tuk ntige hɨr za mbui, kha vhɨzgi gumgi, mbe za Kaman kamthooŋ mbarararga. ");
INSERT INTO geb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Mbe ana kamthooŋ mbararav, mbogi thamthav kɨrar hɨrga. Mba tɨvir vhuuiŋ muuŋgi gumgi gu mbigi, mbe taagi khavgip, mbe zazera mbara muuŋgip kɨrga. Mba tɨvi mbatɨgi ga muuŋgi gumgi gu mbigi, mbe taagi khavɨrga, ana mbe muuŋgi tɨvi ga suaŋv mbe suaŋv, khaŋ mbe suanga, mbe za mbatɨgirga.” ");
INSERT INTO geb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Zisas wom khaŋ nzuai, “Gu wo ŋkasŋkara bigɨn then muuŋgirga fhu. Gu wo Ndia han ndigi buni, gu nta zɨn vov, gu gumgi gu mbigi muuŋgi tɨvi ga nzuav mbe nzuai. Gu nde nzuav nzuai buni, nta purara vugi. Ne khaŋ muuŋgi, gu won vuzvugara zɨn vui fhuvara. Zakɨra fhuvara! Gu na sarigi gu zɨgi Ndia, gu ana vuzvuga zɨn vui. ");
INSERT INTO geb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Gu maaŋ muuŋgip, gu nduara won ŋaari gum won tɨvi bun suanga, kha gumgi gu mba bun nzuai buni, mbe nta khothɨgɨrga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Harigine, ana vhɨra ki, ana nan ŋaara bun nzuav, nan tɨvi bun nzuai. Gu kaŋgi, ana mba nzuai buni, nta guigi guarara. ");
INSERT INTO geb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","34","“Gu kaŋgi, nde fhum gumgi mbari ga sarigi, mbe Zon han ŋgɨp ana buni ndirga. Zon bun suaŋgi buni, nta guigira buni guari ma. Gu nduara kha ndɨkndɨga mbui, harigi guma the buneŋ na buneŋ havhargirga tuktɨgi fhuvara. Gu vuzvugi, Fhe Bakɨme taagip nde ndirga. Maaŋ muuŋgiap, nde Zon suaŋgi buni, nde nta ndɨkndɨgɨri. Ne khaŋ muuŋgi, Zon bun suaŋgi buni, nta guigira buni guari ma. ");
INSERT INTO geb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zon buni rama fara muuŋgiap sharav, vhava ŋaarar gumgi ga ndɨɨi, nde tuga tɨvaneŋra nden ndavi vheri ana vhava ŋaara nzuav ndikndigɨri. ");
INSERT INTO geb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Zon kambarigi bigeŋ, ne ntige na bun nzuai. Gu mba muunga ŋaari Dara za ntan na nɨɨŋgi, gu tuituigip za ntan muuŋv nta vhɨzgirga gumgi gu mbigi khaŋ suanga, Dara na sarigim gu zɨgi. ");
INSERT INTO geb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ana na sarigim gu zɨgi, ana nduara na bun nzuai. Nde ana kamthooŋ mbararagi fhu. Zakɨra fhuvara! Nde vhɨra ana khoma gangi fhu. ");
INSERT INTO geb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ana buni vhɨra nden ki fhu. Ne khaŋ muuŋgi, nde mba Dara sarigi zɨgi guma, nde ana khothɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Nde kha ndɨkndɨga mbui, Fhe Bakɨme buni vhuuiŋ ki gavar ki buni, nta zazera mbara muuŋgiap ki bɨɨŋbɨɨn nde ndɨɨi. Maaŋ muuŋgiap, nde zazera Fhe Bakɨmen buni vhuuiŋ ki gap, nde tuituigiap ana gari. Fhe Bakɨme buni vhuuiŋ ki gavara na bun nzuai. ");
INSERT INTO geb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nde vhɨra na han zɨv zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndi thagi. ");
INSERT INTO geb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Gu gumgi zɨ bakɨmen nan nɨɨn zav, gu kha kameŋ nzuai fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Gu nden ndavi vheri kaŋgi. Nde wari wo ndavi vherir, nde guigira ndavi Fhe Bakɨme nɨɨŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Gu wo Ndia zɨn panan zɨgim, nde na buni ndi fhuvara. Maaŋ muuŋgip, guma the ana zɨn panan zɨrga, nde vhemkora ana buni ndirga. ");
INSERT INTO geb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nde wari wo ntɨɨrira han zɨ bakɨme ndiav, nde Fhe Bakɨme nduara ndɨɨi zɨ bakɨme, nde ana ndirgane thagi. Nde mba khesharigi tɨvir muuŋv, nde ram muuŋgi tɨvar muuŋv na khothɨgɨrie? ");
INSERT INTO geb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Nde khueŋ ndɨkndɨgɨ thari, gu Dara nɨman nde suaŋv suaŋgirga. Zakɨra fhuvara! Nde suaŋv suaŋgirga guma, ana Moses ma. Nde kha ndɨkndɨgar Moses mbui, ana nden kurarga. ");
INSERT INTO geb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Maaŋ muuŋgiap, nde Moses suaŋgi buni khothivi. Nde mba ndɨkndɨgar Moses ga mbui. Nde vhɨra na buni khothivɨri. Nde khaŋ muuŋgi, ana kherav suaŋgi buni, nta na bun nzuai. ");
INSERT INTO geb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Maaŋ muuŋgip, nde ana kherav suaŋgi buni, nde nta khothɨgi fhu, nde ram muuŋgip na buni khothɨgɨrie?” ");
INSERT INTO geb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Zisas zumgum vov Gariri mbɨ khiŋgiap muen hɨgi. Mba ŋaneŋ zɨ mbe khare, Taiberias mbɨ. ");
INSERT INTO geb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ana mirikori vhɨrve ga mbuav rɨɨi gumgi vhɨrve, ana mben kurkurigim, mben rɨmrɨɨ vhɨzgim, gumgi vhɨrve ana gangi. Maaŋ muuŋgiap, ana vov hɨgim, gumgi gu mbigi vhɨrve ana zɨn zergi. ");
INSERT INTO geb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Zisas nda vov mbɨkshɨman ndav, wo phorga rui gumgi phorga perav ki. ");
INSERT INTO geb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Mba tugen Zudain Pasova tuga bakɨme hɨr za mbui. ");
INSERT INTO geb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Zisas ragia garav, ana gumgi gu mbigi vhɨrve garim, mbe ana han zi. Mbe zim, ana kha nzambararen Firip ga muuŋgi. “Nza maam vikntuu ga vhezgip mbu gumgi gu mbigir kurmbegɨrie?” ");
INSERT INTO geb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ana Firipan mparav mba kameŋ suaŋgi. Ana nduara wo muunga bigeŋ, ana ne kaŋgi. ");
INSERT INTO geb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Firip ana ŋgarkarav khaŋ nzuai, “Nza maaŋ muuŋgip K900.00 tuktɨgi vikntuu ga vhezgirga, kha gumgi gu mbigi, mbe bevbevira, mbe za fɨgi bisaŋri guarira mbegɨrga.” ");
INSERT INTO geb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Zisas phorga rui guma mbe Andru, Saimonan fek, ana khaŋ Zisas ga nzuai, ");
INSERT INTO geb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Tara mbe khaŋ ki, ana meeŋthɨgi vikntuuveŋ ki. Mbe barin ntaveŋ ga muuŋgi. Ana vhɨra mbɨgama mpuani ki. Mba ki gumgi gu mbigi, mbe guigira vhɨrkɨvgi. Mba meeŋthɨgi vikntuuveŋ gum mba mbɨgama mpuani ram muuŋgip nzan tuktɨgɨrie?” ");
INSERT INTO geb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Mba ŋanen vhazɨgi vhɨrkɨvgi. Zisas khaŋ nzuai, “Mba gumgi gu mbigi ga suaŋrim, mbe pigiri.” Mba mben vhɨrve khaŋ muuŋgi, 5,000. ");
INSERT INTO geb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mbe piigim, Zisas mbaram mba meeŋthɨgi vikntuuveŋ ndigap, Fhe Bakɨme ndikndigap ana phorga suaŋgiap, ntaveŋ phɨrav, nta shama mbuav, mba gumgi gu mbigi ga ndɨɨi. Ana vhɨra mba tɨvara mba mbɨgama mpuani ga muuŋgi. Ana maaŋ ni ga muuŋgiap, niin mbe nɨɨŋgim, mbe za wari wo vuzvuga vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mbe za mbega thugim, Zisas khaŋ wo phorga rui gumgi ga nzuai, “Nde mbe mbegap ndavi givav thagi, mban tɨvi ndi. Nza fhura mban farfarga fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mbe mbara mba bari muuŋgi meeŋthɨgi vikntuur fɨgiveŋ ndiav 12 thɨgi kɨra ga vhuigim, nta za givigi. Mba gumgi gu mbigi za mbegap ndavi givav thagi ntɨɨri ma. ");
INSERT INTO geb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mba gumgi gu mbigi ana muuŋgi mirikor gangiap khaŋ nzuai, “Guigi guarara, khe Fhe Bakɨme kha nuianan zirɨr zav suaŋgiap sarigi kamthooŋ gumara khare.” ");
INSERT INTO geb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Zisas mbe ndɨkndɨgi kaŋgi, mbe zɨv ana suirav, ana ndiv farim, ana mben ŋgui vhɨrve gari guman pan kegɨrga. Ana maaŋ muuŋgiap mba ŋaneŋ thav taagia nduara mbɨkshɨman ndagi. ");
INSERT INTO geb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mba raar ra verav vhɨzgim, ŋkotuguraagen Zisas phorga rui gumgi, mbe taagia Gariri mbɨn vergi. ");
INSERT INTO geb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Mbe vergap fov keman mben maaŋgiap, Gariri mbɨ thugap muen hi. Mbe muen Kaperneaman hi. Mbe vuim, maaŋ gɨngi, Zisas mben han zɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mbe vuim, bɨɨŋbɨɨŋ kɨvgim, mbɨ phuri raa shogap kɨvgi. ");
INSERT INTO geb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mbe mba kema toga vov meeŋ o mporathɨgi kiromitar vugap, mbe Zisas garim, ana mbɨn tɨn thivav, mben han keman zi. Mbe ana gangiap guigira rɨrɨva mbatɨga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Zisas thav khaŋ mbe nzuai, “Gura, nde rɨvɨ thari.” ");
INSERT INTO geb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mbe ana mbararagiap, ndikndigap, ana nzuaim, ana mben han keman vergi. Ana mben han keman veravra thagim, mbe mba vui ŋaneŋ phorgi. ");
INSERT INTO geb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mba mɨtimanera, mba gumgi gu mbigi, mbe mba Gariri mbɨ gaara kav, mbe kaŋgi, gurum harigi kema the kegi fhuvara. Mba kema bavira kegim, Zisas phorga rui gumgi, mbe mbe kema regap wari vuim, Zisas mbe phorga vugi fhuvara. Ana phorga rui gumgi, mbe nduarira ana regap wari vegi. ");
INSERT INTO geb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mba tugen Taiberiasan ŋkee mbari zav, mba Zisas Fhe Bakɨmen ndikndigap, ana phorga suaŋgiap mba gumgi gu mbigi mba meeŋthɨgi vikntuuveŋ mbegi ŋaneŋ han phogi. ");
INSERT INTO geb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mba gumgi gu mbigi garim, Zisas wo phorga rui gumgir kov mbe ki fhu. Maaŋ muuŋgiap, mbe fov mba ŋkee mbarir maaŋgiap, Zisas ndi garav Kaperneaman vegi. ");
INSERT INTO geb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Mba gumgi gu mbigi vov Gariri mbɨ gaar muen Zisasan hɨgap khaŋ ana nzuai, “Guman Rum, ndu rasɨn khaŋ zɨgi?” ");
INSERT INTO geb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Zisas mbe ŋgarkarav khaŋ nzuai, “Gu guigira nde nzuai, nde mba gu muuŋgi mirikori, nde nta gangi, nde nta ndɨkndɨgap, gu mba nde khɨvigi bigi, nde nta ndɨɨriveŋ kaŋgiap na ndi gari fhuvara. Zakɨra fhuvara! Nde gu mba meeŋthɨgi vikntuuven nde nɨɨŋgim, nde nta mbegav, ndavi givav, nde nera nzuav na ndi gari. ");
INSERT INTO geb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nde mba mbarɨgi mba suaŋv ganɨ thari. Fhuvara. Nde mba zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndi ndɨɨi mba, nde ana suaŋv ganɨri. Mba mba, Fhe Bakɨme Guma Guara mba mban nde ndɨɨi. Fhe Bakɨme maaŋ muun zav zɨ bakɨmen ana nɨɨŋgi.” ");
INSERT INTO geb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mbe mbara khaŋ ana nzuai, “Nza ram mbui tɨvar muuŋgip nza Fhe Bakɨme muungen nza vuzvugi ŋaarir muuŋgirie?” ");
INSERT INTO geb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Zisas mbe ŋgarkarav khaŋ mbe nzuai, “Fhe Bakɨme muungen nde vuzvugi ŋaar khaŋ muuŋgi, nde mba Fhe Bakɨme sarigi zɨgi guma, nde ana khothɨgɨri.” ");
INSERT INTO geb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Mbe mba kameŋ mbararagiap, kha nzambarar ana muuŋgi, “Ndu ram muuŋgi khesharigi mirikor o bigen muuŋgirim, nza ndun kameŋ khothɨgɨrie? Nzan nzɨgi gumgi ki fhuv ŋanen mana mbegi. Mba kameŋ Fhe Bakɨmen buni vhuuiŋ ki gavar ki, ‘Ana Hevenan kega zergi vikntuur mba gumgi gu mbigi ga ndɨɨim, mbe nta mbegi. Ndu ram mbui khesharigi mirikorar muuŋgirie?” ");
INSERT INTO geb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Zisas mbara khaŋ mbe nzuai, “Gu guigira khar nde nzuai, khe Moses mba Hevenan kega zeri viktuman nde nɨɨŋgi fhuvara. Zakɨra fhuvara! Nan Ndia, ana guigira Hevenan kega zeri viktuman nde ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mba Hevenan kegap zeri viktum Fhe Bakɨme anan kha nuianan ki gumgi gu mbigi ga ndɨɨim, ana zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndi ndɨɨi guma ma.” ");
INSERT INTO geb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Mbe mbara khaŋ ana nzuai, “Guman Rum, ndu zazera mba viktuman nzan nɨɨŋri.” ");
INSERT INTO geb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Zisas khaŋ mbe nzuai, “Gu nduara mba zazera mbara muuŋgia ki bɨɨŋbɨɨŋ ndi ndɨɨi viktum ma. Guma nan han zɨrga, ana wom thɨhegi fara muuŋgirga fhu. Guma na khothɨgi, ana wom mbɨ suaŋv fhɨr khigi fara muuŋgirga fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Gu nde suaŋgi, nde na gangi, nde na khothɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Na Ndia na nɨɨŋgi gumgi gu mbigi, mbe za nan han zɨrga. Nan han zi gumgi, gu guigira mbe tharga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Gu wo vuzvuga zɨn ŋgɨr zav Heven thav zergi fhuvara. Zakɨra fhuvara! Gu na sarigim gu zergi Dara, gu ana vuzvuga zɨn vui. ");
INSERT INTO geb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na sarigim, gu zergi Dara, ana vuzvuk khaŋ muuŋgi. Gu ana na nɨɨŋgi guma o mbiga the, gu ana tharga tuktɨgi fhuvara. Zakɨra fhuvara! Gu kha nuian gu bigi vhɨzi tugar, gu taagi mbe khavgirga. ");
INSERT INTO geb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nan Ndia vuzvuk khaŋ muuŋgi. Mba ana Kama gangiap ana khothɨgi gumgi gu mbigi, mbe zam zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigirga. Gu kha nuian gu bigi vhɨzi tugar, gu taagi mbe khavgirga.” ");
INSERT INTO geb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mbe Zudaiŋ, mbe Zisas mbararagim, ana khaŋ nzuai, “Gu nduara mba Hevenan kegap zergi viktum ma.” Mbe ne mbararagiap, ana vhegap, buni vhɨrver ana nzuai. ");
INSERT INTO geb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Mbe khaŋ nzuai, “Kha guma Zisas, ana Zozevan kam ma. Nza ana ndia gu niamuuŋ, nza mani kaŋgi. Ana ram muuŋgiap ntigem khaŋ nzuai, ‘Gu Hevenan kegap zergi’ ? ” ");
INSERT INTO geb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Zisas mbe ŋgarkarav khaŋ nzuai, “Nde warira phorgɨp buni vhɨrve suaŋ thari. ");
INSERT INTO geb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Gu Dara na sarigim, gu zergi. Guma the, ana won vuzvugara nan han zɨgɨrga tuktɨgi fhuvara. Zakɨra fhuvara! Dara, ana mba guma ndɨkndɨga khavgip, ana kuv nan han zɨrga. Gu kha nuian gu bigi vhɨzi tugar, gu mba rimgi guma gu taagip ana khavgirga. ");
INSERT INTO geb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Fhe Bakɨmen kamthooŋ gumgi suaŋgi buni ki gavar ki buni khaŋ nzuai, ‘Fhe Bakɨme za kha gumgi gu mbigi khɨvɨv mbe suanga.’ Mba Dara buni mbararav, ana bigi kaŋgi gumgi gu mbigi, mbe nan han zi. ");
INSERT INTO geb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Guma the Dara gangi fhu. Zakɨra fhuvara! Mba Fhe Bakɨme han kegap zergi guma, ana nduara ana gangi. ");
INSERT INTO geb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Gu guigira nde nzuai, guma, ana guigira na khothɨgi, ana zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ki. ");
INSERT INTO geb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Gu nduara zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndi ndɨɨi viktum ma. ");
INSERT INTO geb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nden nzɨgi mbe gumgi ki fhuv ŋanen mana mbegap, mbe za vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Khe Hevenan kegap zergi viktum ma. Mba ana mbegɨrga gumgi gu mbigi, mbe vhɨzɨrga fhu. ");
INSERT INTO geb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Gu mba zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndi ndɨɨi viktum ma, gu Hevenan kegap zergi. Guma the mba viktuman mbegɨrga, ana zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigip kɨrga. Gu anan nɨɨnga viktum, ana nan fhavar sɨk ma. Gu ana ndi nɨɨŋgirga, kha nuianan ki gumgi gu mbigi, mbe zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndirgip kɨrga.” ");
INSERT INTO geb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mbe Zudaiŋ ne mbararagiap, mbe vhegap, mbe nduarira warir rɨgar ne nzuav wari daai. Mbe khaŋ wari ga nzuai, “Mbu guma, ana ram muuŋgip won fhavar nzan nɨɨŋgirim, nza ana mbegɨrie?” ");
INSERT INTO geb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Zisas mbara khaŋ mbe nzuai, “Gu guigira nde nzuai, nde maaŋ muuŋgip, Fhe Bakɨme Guma Guarar fhavar mbegɨrga fhu, nde vhɨra ana vɨzɨnan mbegɨrga fhu, nde zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ nden kegɨrga fhu. ");
INSERT INTO geb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Guma, ana na fhava sɨk gu vɨzɨna pi, ana zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ki. Gu zumgum, kha nuian gu bigi vhɨzi tugar, gu taagi ana khavgirga. ");
INSERT INTO geb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ne khaŋ muuŋgi, nan fhava sɨk, ana guigira mba guar ma. Nan vɨzɨn, ana vhɨra, guigira pi bigɨna guar ma. ");
INSERT INTO geb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Guma nan fhava sɨga pav, nan vɨzɨna pi, mba guma na phorgap kim, gu ana phorgap ki. ");
INSERT INTO geb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Na Dara, ana zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ nɨɨŋge ma. Ana na sarigim, gu zergi. Na Dara zazera mbara muuŋgiap ki bɨɨŋbɨɨn na nɨɨŋgim, gu zergap, gu wo Darar ŋkasŋkar panan khar ki. Mba tɨvara guma nan mbegɨrga, ana nan ŋkasŋkar panan, ana zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigip kɨrga. ");
INSERT INTO geb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Khera, ana Hevenan kegap zergi viktum ma. Ana mba nden nzɨgi fhum mbegap vhɨzgi viktuma fara muuŋgi fhuvara. Zakɨra fhuvara! Guma, ana kha viktuman mbegɨrga, ana zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigip kɨrga.” ");
INSERT INTO geb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Mba tugen Zisas Kaperneaman Fhe Bakɨme buni vhuuiŋ mbararagi phenan kav, Fhe Bakɨme buni vhuuin mbe khɨvav mbe nzuav, kha bunin mbe suaŋgi. ");
INSERT INTO geb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mba Zisas phorga rui gumgi mba kameŋ mbararagiap, mbe vhɨrvera khaŋ nzuai, “Kha kameŋ guigira nzan simgi, the ne mbarararie?” ");
INSERT INTO geb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Zisas won ndava vhera, ana khueŋ kaŋgi, ana phorga rui gumgi ana suaŋgi buneŋ ga nzuav buni vhɨrve nzuai. Ana maaŋ muuŋgiap mben nzarigi, “Kha buneŋ nde na khothɨgi ndɨkndɨgar farfagi thi? ");
INSERT INTO geb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nde maaŋ muuŋgip Fhe Bakɨme Guma Guar ganɨrim, ana taagip fhum kegi ŋgun naanga, nde ram muuŋgirie? ");
INSERT INTO geb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Fhe Bakɨmen Ŋina Ŋaar nduara zazera mbara muuŋgiap ki bɨɨŋbɨɨn gumgi gu mbigi ga ndɨɨi. Guman ŋkasŋka nduara thaneŋ anan kurarga tuktɨgi fhuvara. Gu khar nde nzuai kameŋ, ne Fhe Bakɨmen Ŋina Ŋaarar kameŋ ma. Ne zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndi ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nden rɨgar ki gumgi mbari ne khothɨgi fhu.” Zisas fhumra mba ana khothɨgi fhuv gumgi, ana mbe kaŋgi. Ana vhɨra ana ndim, anan pana gumgi farve ga surga guma, ana ana kaŋgi. ");
INSERT INTO geb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ana maaŋ muuŋgiap khaŋ nzuai, “Mbe na khothɨgi fhu, gu mba bigɨna nɨɨeŋra nzuav, nde nzuai, ‘Dara ŋkasŋkan guma then nɨɨŋgirga fhu, mba guma nan han zɨgɨrga fhu.’ ” ");
INSERT INTO geb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Zisas mba kameŋ suaŋgim, ana phorga rui gumgir vhɨrve ana thav vegi. Mbe ana thav vegap wom ana phorga rui fhu. ");
INSERT INTO geb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Maaŋ muuŋgiap, Zisas mba 12 thɨgi gumgir nzav, khaŋ mbe nzuai, “Nde, nde vhɨra na tha ŋgɨrgeŋ vuzvugi thi?” ");
INSERT INTO geb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon Pita ana ŋgarkarav khaŋ nzuai, “Guma Bakɨme, nza ndu thav, nza then han ŋgɨrie? Ndun bunira, nta zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndi ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nza vhɨra khueŋ khothɨgav, nza tuituigiap khueŋ kaŋgi, ndu Fhe Bakɨme Wora Mbuigi Guman Ŋaar ma.” ");
INSERT INTO geb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Zisas mbara mben ŋgarkarav khaŋ mbe nzuai, “Ram muuŋgi? Gu nduara nde 12 thɨgi gumgi, gu nden farasegi. Nden rɨgar ki guma mbe, ana ŋiniŋgi mbatɨgir guman pan ma.” ");
INSERT INTO geb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ana Saimon Iskariot kama Zudas ga nzuai. Ana mba 12 thɨgi ŋaara gumgi rɨgar, ana zumgum Zisas ndim, ana shogirim, ana rimgirga gumgir farve khɨngirga. ");
INSERT INTO geb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Zumgum tugi mbarir Zisas Gariri ŋgu bakɨme fhaiŋra rui. Ana wom Zudia ŋgu bakɨme fhain ru thagi. Ne khaŋ muuŋgi, Zudain gumgir pani, ana shogiri ana rɨmɨn za mbui. ");
INSERT INTO geb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mbe Zudaiŋ, mbe, mpɨkavir rotu mbui tugi bakɨvi hɨr za mbui tuk han mbai. Mba tuk ana tuga bakɨme ma. ");
INSERT INTO geb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Maaŋ muuŋgiap, ana ŋgugi khaŋ ana nzuai, “Ndu kha ŋgu thav Zudian ŋgu bakɨme fhain naaŋri. Ndu naaŋrim, ndu phorga rui gumgi ndu mbui ŋaari bakɨvi ganɨnga. ");
INSERT INTO geb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Maaŋ muuŋgip, guma the harigi gumgi ana kaŋgir saŋv, ana zorga kav ŋgari fhuvara. Ndu mba khesharigi bigir muun za mbui, ndu za mba gumgi gu mbigi nɨman kɨrara mba bigir muuŋri.” ");
INSERT INTO geb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ana ŋgugi, mbe vhɨra ana khothɨgi fhu. Mbe maaŋ muuŋgiap mba thɨɨn ana nzuai. ");
INSERT INTO geb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Zisas mbaram mbe ŋgarkarav khaŋ nzuai, “Nan tuk hɨgi fhuvara. Kha tugi, nta zazera nden tugi ma. ");
INSERT INTO geb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kha nuianan ki gumgi gu mbigi, mbe panan nde kegɨrga tuktɨgi fhuvara. Mbe panan na kegi. Ne khaŋ muuŋgi, gu zazera mbe mbui tɨvi mbatɨgi ga nzuav mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nde mba rotu mbui tuga bakɨme suaŋv Zerusareman naaŋri. Gu ndarga fhu. Ne khaŋ muuŋgi, nan tuk hɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ana nen mbe suaŋgiap, ana Garirira ki. ");
INSERT INTO geb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Zisas kim, ana ntogi ndagim, ana zumgum vhɨra ndagi. Ana ndav, ana zorga ndagi. Ana mba gumgi ana kaŋgirga ne thagi. ");
INSERT INTO geb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mba rotu mbui tuga bakɨmen, Zudaiŋ gumgir pani ana nzuav garav khaŋ nzuai, “Kha guma maaŋ ki?” ");
INSERT INTO geb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mbe gumgi gu mbigir vhɨrve rɨgar, mbe nduarira shɨɨŋshɨɨŋ kaar wari ga nzuai. Mbe mbari khaŋ nzuai, “Ana guman vhuuŋ ma.” Mbe mbari khaŋ nzuai, “Fhuvara, ana kha gumgi gu mbigi guiguigi.” ");
INSERT INTO geb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mbe maaŋ nzuav, mbe vhɨra Zudain gumgir pani rivgiap, mbe guma the hiiŋ sarav ana mbui tɨvi ga nzuai fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mba rotu mbui tugi bakɨvi vov rɨgar vuim, Zisas mbara vov Fhe Bakɨme phena bɨna vhen vergap Fhe Bakɨme buni vhuuin gumgi gu mbigi khɨvav mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Zudaiŋ gumgir pani ana nzuai buni mbararagiap, mbe ŋgava mbatɨga muuŋgiap khaŋ nzuai, “Kha guma ram muuŋgiap kha ndɨkndɨgi kaŋgi? Ana sure then vugi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Zisas mbara mbe ŋgarkarav khaŋ nzuai, “Gu khar nde nzuai buni, nta na bunira fhuvara. Zakɨra fhuvara! Nta Fhe Bakɨme bunin vhuuiŋ ma. Ana na sarigim, gu zergi. ");
INSERT INTO geb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Guma maaŋ muuŋgip, guigira Fhe Bakɨmen vuzvuga zɨn ŋgɨr za mbui, ana guigira khueŋ kaŋgirga, kha buni vhuuiŋ, nta Fhe Bakɨme han kega zɨgi o, gu won ndɨkndɨgara nzuai buni ma. ");
INSERT INTO geb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Guma won ndɨkndɨgara buni nzuai, ana wo zɨ ndiv vun kuamkuagi. Guma mba ana sarigim, ana zɨgi guma zɨ ndiv vun kuamkuagi, mba guma ana buni guari nzuai guma ma. Ana bigi guiguigi guma fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Moses fhum Fhe Bakɨme suaŋgi tɨvir nde nɨɨŋgim, nde rɨgar guma the mba tɨvi zɨn vui fhu. Nde thaŋ nzuav na shogirim, gu rɨmɨn za mbui?” ");
INSERT INTO geb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mba gumgi gu mbigi ana ŋgarkarav khaŋ nzuai, “Ŋina mbatɨk mbe ndun vhen ki. The ndu shogirim, ndu rɨmɨn zav mbui?” ");
INSERT INTO geb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Zisas mbe ŋgarkarav khaŋ nzuai, “Gu mirikor mbe mbuim, nde za ŋgava mbatɨga mbui. ");
INSERT INTO geb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Nde ndɨkndɨgɨ! Moses nde warir foonga tɨvar nde ndi tɨgim, nde Sabatar wari won tarir fooi. Guigira Moses nduara mba tɨvar nde ndi tɨgi fhuvara. Mba tɨv, ana fhum nden nzɨgir tugen ki. ");
INSERT INTO geb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nde Moses suaŋgi tɨvi, nde tuituigip nta zɨn ŋgɨr zav, nde Sabatar wari won tarir foov nde maaŋ muuŋgiap Moses suaŋgi tɨvi phɨri fhu. Maaŋ muuŋgiap, gu Sabatar guman kurav, ana fhava muuŋgim, ana nzerigim, nde thaŋ nzua na nzuav ndavi shi? ");
INSERT INTO geb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nde fhura rɨmgira mba bigi ganɨv nta suaŋ thari. Nde tɨvar guara zɨn ŋgɨp mba bigi ganɨv nta suaŋri.” ");
INSERT INTO geb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Zerusareman ki gumgi gu mbigi mbari, mbe mbaram khaŋ nzuai, “Ram muuŋgi? Khe mba gumgi pani shogirim, rɨmɨn za nzuai gumara khare. ");
INSERT INTO geb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nde ana ganɨ! Ana kɨrara thɨgap kha buni nzuaim, mbe buna thuen ana nzuai fhu. Ee, mbe kaŋgi, ana Fhe Bakɨme taagip won gumgi gu mbigi ndir zav sarigi guma thi? ");
INSERT INTO geb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nza kha guma, nza ana ŋgu nɨɨŋge, nza niŋge kaŋgi. Maaŋ muuŋgip, Fhe Bakɨme mba suaŋgiap sarigi guma zɨgɨrim, guma the ana ŋgu nɨɨŋge kaŋgirga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Zisas Fhe Bakɨme phena bɨna vhen kav, Fhe Bakɨme buni vhuuin gumgi gu mbigi ga nzuav kav, kaav khaŋ nzuai, “Nde khueŋ ndɨkndɨgi thi, nde na kaŋgiap, na ŋgu nɨɨŋge kaŋgi? Gu nduara wo vuzvugar zɨgi fhuvara. Dara na sarigim, gu zɨgi. Anan tɨvi, nta guigi guarara, nde nta kaŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Gu, gu ana kaŋgi. Gu ana han kim, ana na sarigim, gu zergi.” ");
INSERT INTO geb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Mbe mba kameŋ mbararagiap ana ndi bɨna sur zav mbui. Ana tuk ntigar, maaŋ muuŋgiap guma the farven ana sui fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Gumgi gu mbigi vhɨrve ana khothɨgap khaŋ nzuai, “Maaŋ muuŋgip, Fhe Bakɨme mba suaŋgiap sarigi guma, ana zirɨrga, ana muunga mirikori nta kha guma mbui mirikori kambararga thi?” ");
INSERT INTO geb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mba Fherasiŋ, mbe gumgi gu mbigi mbararagim, mbe mbarkɨrga bigi Zisas nta muuŋgi, mbe nta nzuai. Maaŋ muuŋgiap, mba Fhe Bakɨme rotu gari gumgir pani gum Fherasiŋ, mbe gɨɨtɨvi ga sarigim, mbe Zisas suigɨr zav zi. ");
INSERT INTO geb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Zisas mbara khaŋ mbe nzuai, “Gu tuga tɨvaneŋra nde phorgɨ kegɨp, gu taagi mba na sarigi gu zɨgi ne, gu ana han ndarga. ");
INSERT INTO geb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nde na suaŋv ganɨnga, nde na gangirga tuktɨgi fhu. Nde vhɨra gu ki ŋgun ŋgɨgɨrga tuktɨgi fhu.” ");
INSERT INTO geb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mba Zudaiŋ gumgir pani, mbe ne mbararagiap, mbe nduarira wari ga nzuav, khaŋ nzuai, “Ana maaŋ ŋgɨgɨrim, nza ana gangirga tuktɨgi fhu? Ee, ana harigi fhaiŋ ŋguir han ŋgɨgɨp, nzan fegi gu ŋgugi mben rɨgar ki, ana mbe phorgɨp kɨv, Fhe Bakɨme buni vhuuin harigi fhaiŋ ki ŋgui gumgi khɨvɨrie? ");
INSERT INTO geb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ana khaŋ nzuai, ‘Nde na suaŋv ganɨnga, nde na gangirga tuktɨgi fhu.’ Ana vhɨra khaŋ nzuai, ‘Nde gu ki ŋgun ŋgɨgɨrga tuktɨgi fhu.’ Ana mba nzuai buna nɨɨeŋ ram nzuai?” ");
INSERT INTO geb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mba rotu mbui tugi bakɨvi vov vhɨzɨr za mbuim, mba mpuur raa, ana guigira tuga bakɨ guar ma. Mba raar Zisas thɨgap kaav khaŋ nzuai, “Guma the mbɨ suaŋv fhɨr khigip, ana na han zɨv, mbɨn mbɨrga. ");
INSERT INTO geb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Fhe Bakɨmen buni vhuuiŋ ki gap ne suaŋgi, guma na khothɨgi, ana zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndi ndɨɨi mbɨ ana ndava vhen kɨv sisurga.” ");
INSERT INTO geb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Zisas, ana Fhe Bakɨmen Ŋina Ŋaara nzuai, ana khothɨgi gumgi gu mbigi, mbe ana ndirga. Mba tugen Zisas zɨ bakɨme ndigi fhuvara. Maaŋ muuŋgiap, Fhe Bakɨmen Ŋina Ŋaar zergi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mbe gumgi gu mbigi mbari, mbe Zisas nzuai buni mbararagiap, mbe khaŋ nzuai, “Guigi guarara, khe Fhe Bakɨme kha nuianan zirɨr zav suaŋgiap sarigi Fhe Bakɨmen kamthooŋ guma ma.” ");
INSERT INTO geb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Harigi ntɨɨri khaŋ nzuai, “Ana Fhe Bakɨme taagip won gumgi gu mbigi ndir zav suaŋgiap farasarigi guma ma.” Mbe mbari khaŋ nzuai, “Mba Fhe Bakɨme farasarigi guma, ana Garirin hɨgɨrga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Fhe Bakɨme buni vhuuiŋ ki gap khaŋ suaŋgi, mba guma, ana ŋgui vhɨrve gari guma pan Devitan nzɨga the kɨrga. Ana Devit fhum kegi ŋgu Betreheman hɨgɨrga.” ");
INSERT INTO geb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Maaŋ muuŋgiap, mba gumgi gu mbigi, mbe harigi khesharigi ndɨkndɨgir Zisas ga mbuav, mbe rɨgɨra wari shɨrigi. ");
INSERT INTO geb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mbe mbari ana ndi bɨna surgeŋ vuzvugi. Mbe maaŋ ana muun zav mbuav, mbe guma the farven ana khɨngi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mben gɨɨtɨvi taagiap vov mba Fhe Bakɨmen rotu gari gumgir pani gum Fherasiŋ han vegi. Mbe vegim, mbe mben nzarigi, “Nde ram muuŋgiap ana suira zi fhu?” ");
INSERT INTO geb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mba gɨɨtɨvi mben ŋgarkarav khaŋ nzuai, “Guma the fhum khaŋ muuŋgi buni suaŋgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mbe maaŋ nzuaim, Fherasiŋ mbe ŋgarkarav khaŋ nzuai, “Nde vhɨra, ana nde guigi thi? ");
INSERT INTO geb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nde nza kha gumgir pani gum nza Fherasiŋ, nde nza garim, nza the ana khothɨgɨrie? Zakɨra fhuvara! ");
INSERT INTO geb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mba gumgi gu mbigi, mbe Moses suaŋgi tɨvi kaŋgi fhu ntɨɨri ma. Fhe Bakɨme mben muuŋgirim, mbe mbarɨgɨrga ntɨɨri ma.” ");
INSERT INTO geb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemus, ana mba fhum Zisas han vugi, ana mbe phorga ki guma mbe ma. Ana khaŋ mbe nzuai, ");
INSERT INTO geb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nzan tɨvi ram nzuai, ee, nza fhura guma the suaŋv suaŋrie? Zakɨra fhuvara! Nza tuituigip ana buni mbararagip, ana muuŋgi bigeŋ kaŋgip, za ana suaŋv suanga.” ");
INSERT INTO geb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Mbe ana buneŋ ŋgarkarav khaŋ ana nzuai, “Ndu vhɨra, ndu Gariri guma thi? Ndu tuituigip Fhe Bakɨmen buni vhuuiŋ ki gava gangip, ndu khueŋ kaŋgirga. Fhe Bakɨmen kamthooŋ guma the Garirin hɨgɨrga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mba gumgi, mbe za wari won phenin vegi. ");
INSERT INTO geb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Zisas, ana Oriv mbɨkshɨman ndagi. ");
INSERT INTO geb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ana mɨtimanera, ana maaŋra wom khavgia vov, Fhe Bakɨme phena bɨna vhen vergi. Ana vergim, mba gumgi gu mbigi za ana han zi. Ana perav Fhe Bakɨme buni vhuuin mbe khɨvav mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ana kim, Zudaiŋ tɨvi kaŋgiap ntan harigi ntɨɨri khɨvi gumgi gum Fherasiŋ, mbe mana tɨgi mbiga mbe, mbe ana garim, ana harigi guma mbe ndiga kegi. Mbe ana ndiga zav, mba gumgi gu mbigi nɨman fagi. ");
INSERT INTO geb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Mbe ana ndi fav, khaŋ Zisas ga nzuai, “Ndɨkndɨgir vhuuin nza khɨvi guman rum, kha mana tɨgi mbik, ana harigi guma mbe ndiga kim, mbe ana gangi. ");
INSERT INTO geb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moses nza nɨɨŋgi tɨvi khaŋ nzuai, mba khesharigi mbik, nza ŋkɨɨar ana sɨrim, ana rimgirga. Ndu ram muuŋgi suambarar ana mbui?” ");
INSERT INTO geb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Mbe khueŋ nzuav ana mparav mba nzambarar ana muuŋgi. Mbe khueŋ vuzvugi, ana buna thueŋ suaŋgirim, mbe ne suaŋv ana suaŋv suaŋgirga. Zisas mbara ŋgiav won farafen mbu nuiana kheri. ");
INSERT INTO geb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mbe pim anan nzaa vuav kim, Zisas thav raagia thɨgap khaŋ mbe nzuai, “Nden rɨgar guma the tɨva mbatɨga thueŋ muuŋgi fhu, ana fharigi kɨma ndigip kha mbiga sɨri.” ");
INSERT INTO geb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ana maaŋ mbe suaŋgiap, taagia ŋguav won farafen mbu nuiana kheri. ");
INSERT INTO geb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mbe mba kameŋ mbararagiap, mbe za bevbevira mba ŋaneŋ thav vegi. Mben gumgir vuri, mbe fharav vuim, mba harigi ntɨɨri, mbe fhura mbe zɨn vegi. Mbe vegim, Zisas nduara maaŋ ŋgiav kav kherim, mba mbik mbe ana ndi fagi ŋanen mbara thɨgap ki. ");
INSERT INTO geb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Zisas mbara raagiap thɨgap khaŋ mba mbiga nzuai, “Ena, kha gumgi maaŋ vegi? Ee, ndu suaŋv suanga guma the ki fhuv thi?” ");
INSERT INTO geb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mba mbik khaŋ nzuai, “Guman Rum, guma the ki fhu.” Zisas mbara khaŋ ana nzuai, “Gu vhɨra, gu ndu nzuav nzuai fhu. Ndu taagi ŋgɨgɨp, ndu wom tɨva mbatɨk thueŋ muuŋ thari.” ");
INSERT INTO geb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Zisas taagia khaŋ mba gumgi gu mbigi ga nzuai, “Gu nduara, gu kha nuianan shɨgi vhavar ŋaar ma. Guma na zɨn zɨrga, ana gɨngɨnan ŋgɨgɨrga tuktɨgi fhuvara. Zakɨra fhuvara! Ana zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndi ndɨɨi vhava ŋaara ndigirga.” ");
INSERT INTO geb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mbe Fherasiŋ mba kameŋ mbararagiap, mbe khaŋ Zisas ga nzuai, “Ndu won ŋaari gum won tɨvi, ndu nduara wora bun nzuai. Maaŋ muuŋgiap ndu buni, nta fhura ki buni ma.” ");
INSERT INTO geb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Zisas mben kameŋ ŋgarkarav khaŋ mbe nzuai, “Ne guigira, gu won tɨvara bun nzuai. Gu wo bun nzuai buni, nta guigi guarira. Ne khaŋ muuŋgi, gu wo kegap zergi ŋgu, gu ana kaŋgi, gu vhɨra wo naanga ŋgu, gu ana kaŋgi. Nde nan ŋgu nɨɨŋge kaŋgi fhuvara. Gu mba ndai ŋaneŋ, nde vhɨra ne kaŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nde nuianan tɨvi zɨn vui gumgi mbui tɨvi garav mbe nzuav nzuai. Gu guma the mbui tɨvi garav nta nzuav ana nzuai fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Gu maaŋ muuŋgip, guma the muuŋgi tɨvi ga suaŋv ana suanga, na buneŋ ne guigi guarara. Ne khaŋ muuŋgi, gu nduara ana muuŋgi tɨvi ga nzuav ana nzuai fhuvara. Zakɨra fhuvara! Mba na sarigim, gu zɨgi Dara, ana vhɨra na phorga ŋgarav, ana muuŋgi tɨvi ga nzuav ana nzuai. ");
INSERT INTO geb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nden tɨvi, nta khaŋ nzuai. Guma phuni, mani maaŋ muuŋgip wani tɨgɨp mba kameŋra suanga, mani nzuai kameŋ guigi guarara. ");
INSERT INTO geb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Gu nduara won ŋaara bun nzuav, gu won tɨvira bun nzuaim, na sarigi gu zɨgi Dara, ana vhɨra nan ŋaar gum nan tɨvi bun nzuai.” ");
INSERT INTO geb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Mba Fherasiŋ hegap, kha nzambarar ana muuŋgi, “Ndu mba nzuai Dara, ana maaŋ ki?” Zisas mbe ŋgarkarav khaŋ mbe nzuai, “Nde na kaŋgi fhu, nde maaŋ muuŋgiap nan Ndia kaŋgi fhu. Nde na kaŋgirga, nde vhɨra nan Ndia kaŋgirga.” ");
INSERT INTO geb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Zisas Fhe Bakɨme Phena vhen, mbe Fhe Bakɨme ofa mbui ŋkɨɨa ndi sui ŋanen han perav kav, Fhe Bakɨme buni vhuuin gumgi gu mbigi khɨvav mbe nzuav kha buni suaŋgi. Mbe guma the ana suirigi fhuvara. Ne khaŋ muuŋgi, anan tuk ntigar. ");
INSERT INTO geb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Zisas wom khaŋ mba gumgi gu mbigi ga nzuai, “Gu ntige vui, nde na gangirga fhu. Nde muuŋgi tɨvi mbatɨgi mbara muuŋgip kɨrim, nde vhɨzgirga. Nde gu vui ŋgun ŋgegɨrga tuktɨgi fhu.” ");
INSERT INTO geb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Maaŋ muuŋgiap, mbe Zudaiŋ mba kameŋ mbararagiap, mbe nduarira khaŋ wari ga nzuai, “Ana ram muuŋgiap khaŋ nzuai, ‘Nde gu vui ŋgun ŋgegɨrga tuktɨgi fhuvara’? Ana nduara wo shogip rimgirie?” ");
INSERT INTO geb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Zisas khaŋ mbe nzuai, “Nde kha nɨn ki ntɨɨri ma. Gu, gu kha vun ki ne ma. Nde kha nuiana ntɨɨri ma, gu kha nuiana ne fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Maaŋ muuŋgiap, gu nde suaŋgi, nde muuŋgi tɨvi mbatɨgi nta mbara muuŋgip nden kɨrim, nde vhɨzgirga. Gu ana ma, nde ne khothɨgɨrga fhu, nde muuŋgi tɨvi mbatɨgi mbara muuŋgip nden kɨrim, nde vhɨzgirga.” ");
INSERT INTO geb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mbe ana nzarigi, “Ndu the ma?” Zisas mbara khaŋ mbe nzuai, “Nde nan nzai, gu thevi. Gu fhara guarara wo bun nde suaŋgi. ");
INSERT INTO geb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Gu nde mbui tɨvi ga suanga buni vhɨrve khar ki. Gu nde muuŋgi tɨvi ga suaŋv nde suanga guma farar muuŋgip kɨrga. Na sarigi gu zɨgi guma, anan tɨvi, nta za guigi guarara. Gu ana han mbararagi buni, gu ntara bun kha nuianan ki gumgi gu mbigi ga nzuai.” ");
INSERT INTO geb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Mbe khueŋ kaŋgi fhuvara, Zisas Dara bun mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Maaŋ muuŋgiap, ana khaŋ mbe nzuai, “Nde Fhe Bakɨme Guma Guara ndi ntorgɨrga, nde khueŋ kaŋgirga, gu ana ma. Nde vhɨra khueŋ kaŋgirga, gu nduara wo zɨn panan bigɨn thueŋ muuŋgi fhu. Zakɨra fhuvara! Gu Dara na khɨvigi bigi, gu ntara bun nzuai. ");
INSERT INTO geb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na sarigi, gu zɨgi ne, ana na phorga ki. Ana na thagim, gu nduara ki fhuvara. Zakɨra fhuvara! Ana na thagi fhuv ne khaŋ muuŋgi, gu zazera ana vuzvugi bigi, gu ntara mbui.” ");
INSERT INTO geb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mba gumgi gu mbigi vhɨrve, mbe Zisas mbararagim, ana mba kameŋ suaŋgim, mbe ana khothɨgi. ");
INSERT INTO geb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Zisas mbara mba ana khothɨgi gumgi gu mbigi, ana khaŋ mbe nzuai, “Nde na buni vhuuiŋ zɨn ŋgɨrga, nde guigira na phorga rui gumgi guari kɨrga. ");
INSERT INTO geb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nde maaŋ muuŋgip guigira buna guareŋ kaŋgirga, mba buna guareŋ nden muuŋgirim, nde bɨkbɨɨgirga.” ");
INSERT INTO geb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mbe ne mbararagiap ana ŋgarkarav khaŋ nzuai, “Nza Abrahaman shɨga ntɨɨri ma. Nza tuga then, nza fhura guma then ŋaara gumgi khɨni kegi fhuvara. Maaŋ muuŋgiap, ndu thaŋ nzuav khaŋ nza nzuai, ‘nde bɨkbɨɨgirga?’ ” ");
INSERT INTO geb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Zisas mbe ŋgarkarav khaŋ nzuai, “Gu guigira nde nzuai, tɨvi mbatɨgi ga mbui gumgi, mbe fhura tɨvir mbatɨgir ŋaara gumgi khɨni ki. ");
INSERT INTO geb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mba ŋaara khɨna mbui guma, ana zazera phenan ki fhuvara. Phena vuavir kam, ana zazera phenan ki. ");
INSERT INTO geb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Fhe Bakɨme Kam nden muuŋgirim, nde bɨkbɨɨgirga, nde guigira bɨkbɨɨgi ntɨɨri ma. ");
INSERT INTO geb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Gu nde kaŋgi, nde Abraham ntɨɨri ma. Na buni nde ndavi vherir ki fhuvara. Maaŋ muuŋgiap, nde na shogirim, gu rɨmɨn za mbui. ");
INSERT INTO geb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Gu na Ndia na khɨvigi bigi, gu nta bun nzuai. Nde wari won ndia han ndigi tɨvi, nde nta mbui.” ");
INSERT INTO geb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mba Zudaiŋ Zisas suaŋgi buni mbararagiap, mbe ana ŋgarkarav khaŋ nzuai, “Nzan nzɨgir ndia Abraham ma.” Zisas mbara khaŋ mbe nzuai, “Nde guigira Abrahaman tari gu nzɨgi kɨv, nde Abraham muuŋgi tɨvir muuŋri. ");
INSERT INTO geb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Gu Fhe Bakɨme han mbararagi buni guarira, gu nta bun nde suaŋgi. Gu nta bun nde suaŋgim, nde ntigem na shogirim, gu rɨmɨn za mbui. Mba tɨv, ana Abrahaman tɨv fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nde wari won ndia mbui tɨvara mbui.” Mbe mbara khaŋ ana nzuai, “Nzan ndegmbori, mbe harigi gumgi, mbe ruarir mbe ndiav kav nza tegi fhuvara. Nza ndia bavira ki, ana Fhe Bakɨme ma.” ");
INSERT INTO geb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Zisas khaŋ mbe nzuai, “Maaŋ muuŋgip, Fhe Bakɨme guigira nden ndia kɨrim, nde vhɨra na vuzvugiri. Ne khaŋ muuŋgi, gu Fhe Bakɨme han kega zergi. Gu nduara wo vuzvugara zergi fhuvara. Zakɨra fhuvara! Fhe Bakɨme na sarigim, gu zergi. ");
INSERT INTO geb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","“Nde ram muuŋgiap, na buni kaŋgi fhu? Mba bigɨna nɨɨeŋ khaŋ muuŋgi. Nde na buni mbararageŋ thagi. ");
INSERT INTO geb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nden ndia Satan, nde ana tari ma. Nde wo ndiar vuzvugi zɨn ŋgɨrgeŋ vuzvugi. Ana fhum guarara gumgi shogi guma kav ki. Ana tɨvi guari zɨn vui fhuvara. Ne khaŋ muuŋgi, tɨvi guari anan ki fhuvara. Ana fhura guiguigi buni nzuai, mba buni, nta guigira ana buni ma. Ana guiguigi buni nzuai guma ma. Ana vhɨra guigira bigi guiguigi tɨvir ndia ma. ");
INSERT INTO geb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","“Gu guigira buni guarira bun nde nzuaim, nde ne nzuav na buni khothivi fhu. ");
INSERT INTO geb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Nde khueŋ ndɨkndɨgi, gu tɨva mbatɨgeŋ muuŋgi thi? Nde mba ndɨkndɨgar na mbuim, nde the gu muuŋgi tɨva mbatɨgeŋ bun suaŋ. Gu maaŋ muuŋgip buna guareŋ bun nzuaim, nde ram muuŋgiap na buneŋ khothɨgi fhu? ");
INSERT INTO geb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Fhe Bakɨme tari, mbe za Fhe Bakɨme buni mbararagi. Nde Fhe Bakɨmen tari fhuvara, nde maaŋ muuŋgiap ana buni mbararagi fhu.” ");
INSERT INTO geb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mbe Zudaiŋ, mbe Zisas ŋgarkarav khaŋ nzuai, “Nza khaŋ ndu nzuai, ndu Samaria guma ma, ŋina mbatɨk mbe ndun vhen ki. Ne guigirame?” ");
INSERT INTO geb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Zisas mbe ŋgarkarav khaŋ nzuai, “Gu ŋina mbatɨk the nan vhen ki fhu. Zakɨra fhuvara! Gu won Ndiara zɨ ndiv vun kuamkuagim, nde na zɨ mbevi. ");
INSERT INTO geb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Gu wo zɨra ndiv vun kuamkuar zav gumgi ga mbui fhuvara. Na zɨ ndiv vun kuamkuargen kha gumgi vuzvugi guma mbe ki, mba guma, ana nza mbui tɨvi ga suaŋ nza suanga guma ma. ");
INSERT INTO geb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Gu guigira nde nzuai, maaŋ muuŋgip guma the na buna vhuueŋ zɨn ŋgɨrga, ana rimgirga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mbe Zudaiŋ khaŋ Zisas ga nzuai, “Nza ntige kaŋgi, ŋina mbatɨk ndun vhen ki. Abraham, ana rimgi, Fhe Bakɨmen kamthooŋ gumgi, mbe vhɨra vhɨzgi. Ndu khaŋ nzuai, ‘Maaŋ muuŋgip, guma the tuituigip na buneŋ zɨn ŋgɨrga, ana rimgirga tuktɨgi fhuvara.’ ");
INSERT INTO geb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ram muuŋgi? Ndu nzan nzɨga Abraham kambarav zɨ bakɨ ki thi? Ana rimgim, mba Fhe Bakɨmen kamthooŋ gumgi, mbe vhɨra vhɨzgi. Ndu ndɨkndɨgi, ndu the?” ");
INSERT INTO geb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Zisas mbe ŋgarkarav khaŋ nzuai, “Gu nduara wo zɨ ndiv vun kuamkuarga, na zɨ, ana fhura ki ne ma. Nan Ndia, ana na zɨ ndi vun kuamkuagi. Nde khaŋ ana nzuai, ana nzan Fhe Bakɨme ma. ");
INSERT INTO geb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nde ana kaŋgi fhuvara. Gu, gu ana kaŋgi. Gu maaŋ muuŋgip khaŋ suanga, ‘Gu ana kaŋgi fhu,’ gu ndera farar muuŋgip bigi guiguigi guma kɨrga. Gu ana kaŋgiap, gu tuituigira ana buni zɨn vui. ");
INSERT INTO geb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","“Nden nzɨk Abraham, ana gu hɨgɨp kɨrga tuge ndɨkndɨgap, ana ne nzuav ndikndigi. Ana ndikndigap, ana mba tuga gangiap, ana ndav guigira nzerigi.” ");
INSERT INTO geb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mba Zudaiŋ mba kameŋ mbararagiap, mbe khaŋ Zisas ga nzuai, “Ndun mpari vov 50 thɨgi fhuvara, ndu Abraham gangire?” ");
INSERT INTO geb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Zisas mbaram khaŋ mbe nzuai, “Gu guigira nde nzuai, gu fhum kim, Abraham zumgum kha nuianan hɨgi.” ");
INSERT INTO geb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Mbe ne mbararagiap, ŋkɨɨa ndiav ana sɨr za mbui. Zisas mbara zomzora vov mba Fhe Bakɨme phena bɨna vhee thav kɨrar hɨga vugi. ");
INSERT INTO geb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Zisas vov rɨmani mbatɨgi guma mbe gari. Ana wo niamuuŋ ndava vhera kav rɨmani mbatɨgim, ana niamuuŋ ana tegi. ");
INSERT INTO geb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Zisas phorga rui gumgi ana nzarigi, “Guman Rum, the muuŋgi tɨva mbatɨgeŋ kha guma niamuuŋ ana tegim, ana rɨmani mbatɨgi? Kha guma nduara muuŋgi tɨva mbatɨgeŋ o, ana niamuuŋ gu ndia muuŋgi tɨva mbatɨgeŋ?” ");
INSERT INTO geb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Zisas mbe ŋgarkarav khaŋ nzuai, “Kha guma tɨva mbatɨga thueŋ muuŋgi fhu, ana niamuuŋ gu ndia vhɨra tɨva mbatɨk thueŋ muuŋgi fhu. Kha bigeŋ ana hɨgi, kha gumgi gu mbigi ana hɨgi bigeŋ gangirga, Fhe Bakɨmen ŋaar, ana guigira anan kɨrar hɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ntige, mɨn thugim, nza ntigem na sarigi gu zɨgi guman ŋaarar muunga. Zumgum maaŋ gɨngirga, guma the ŋaara then muuŋgirga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Gu kha nuianara ki, gu kha nuiana shɨrigi vhavar ŋaar ma.” ");
INSERT INTO geb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Zisas maaŋ suaŋgiap, mbara nuiana pargiap, won mparir nuiana digap, mba nuianan mba rɨmani mbatɨgi guman rɨmani hɨvgi. ");
INSERT INTO geb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Zisas maaŋ ana rɨmani ga muuŋgiap khaŋ ana nzuai, “Ndu ŋgɨp Siroam Mbok Mbɨn wo rɨmani ruagiri.” Kha zɨ Siroam, ana khaŋ nzuai kameŋ ma, “Mbe ana sarigim, ana vui.” Mba rɨmani mbatɨgi guma vov wo rɨmani ruagiap, taagia zav, ana rɨmani nzerigim, ana tuituigiap bigi gari. ");
INSERT INTO geb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ana tuituigiap bigi garim, ana ŋgu ntɨɨri gum fhum ana garim, ana ŋkɨɨa gu bigir nzaŋgi gumgi gu mbigi, mbe khaŋ nzuai, “Ram muuŋgi? Mbu gumara fhum pigav kav ŋkɨɨa gu bigir gumgir nzagagi thi?” ");
INSERT INTO geb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mbe mbari khaŋ nzuai, “Ahaŋ, mba gumara.” Mbe mbari khaŋ nzuai, “Fhuvara. Ana mba guma khesharigi, ana harigi guma ma.” Mbe maaŋ nzuaim, mba gumara khaŋ nzuai, “Ana gura.” ");
INSERT INTO geb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mbe anan nzarigi, “Ndu ram muuŋgiap ndun rɨmani nzerigi?” ");
INSERT INTO geb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ana mbe ŋgarkarav khaŋ nzuai, “Mbe kha zɨn kaai guma, Zisas, ana nuiana digap, ana mbɨ muuŋgiap, na rɨmani hɨvgiap, khaŋ na nzuai, ‘Ndu ŋgɨp Siroam Mbok Mbɨn wo rɨmani ruagiri.’ Maaŋ muuŋgiap, gu vov wo rɨmani ruagim, nan rɨmani nzerigim, gu tuituigiap bigi gari.” ");
INSERT INTO geb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Mbe mbara ana nzarigi, “Mba guma maaŋ ki?” Ana khaŋ mbe nzuai, “Gu kaŋgi fhu.” ");
INSERT INTO geb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mbe mbaram mba rɨmani mbatɨgia kegi guma ndigap Fherasiŋ han vugi. ");
INSERT INTO geb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Zisas mba nuiana mbɨ muuŋgiap mba guma rɨmani ntarigi raa, ana Sabat ma. ");
INSERT INTO geb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mba Fherasiŋ vhɨra taagia ana nzarigi, “Ndun rɨmani ram muuŋgiap nzerigi?” Ana khaŋ mbe nzuai, “Ana nuiana mbɨ muuŋgiap nan rɨmani hɨvgim, gu vov wo rɨmani ruagim, nan rɨmani nzerigim, gu tuituigiap bigi gari.” ");
INSERT INTO geb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mbe Fherasiŋ mbari khaŋ nzuai, “Nza kaŋgi, Fhe Bakɨme mba guma ga sarigim, ana zɨgi fhuvara. Ne khaŋ muuŋgi, ana Sabatar tɨva zɨn vui fhuvara.” Mbe mbari khaŋ nzuai, “Tɨvi mbatɨgi ga mbui guma, ana ram muuŋgip khaŋ muuŋgi mirikorar muuŋv harigi khesharigi mirikori muuŋgirie?” Mbe maaŋ nzuav, rɨgɨra wari shɨrigi. ");
INSERT INTO geb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mbe mbara wom mba fhum rɨmani mbatɨgia kegi guman nzarigi. “Mba ndun rɨmani ga muuŋgim, ni nzerigi guma, ndu ndɨkndɨgi ana ram muuŋgi khesharigi guma?” Mba guma mbe ŋgarkarav khaŋ nzuai, “Ana Fhe Bakɨmen kamthooŋ guma mbe ma.” ");
INSERT INTO geb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ne guigira, kha guma ana fhum rɨmani mbatɨgia kegap, ana ntigem rɨmani nzerav bigi gari. Mbe Zudaiŋ gumgir pani, mbe ne khothivɨ thagi. Mbe mbara hegap mba rɨmani nzerigi guman ndia gu niamuun kamgi. ");
INSERT INTO geb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Mbe mani kamgim, mani zim, mbe kha nzambaran mani ga muuŋgi, “Khe ŋkon kam e? Ŋko khaŋ nzuaire, ana niamuuŋ ana tegim, ana ndava vhera rɨmani mbatɨgi? Ana ram muuŋgiap ntige nzerara gari?” ");
INSERT INTO geb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ana niamuuŋ gu ndia, mbe ŋgarkarav khaŋ nzuai, “Ŋka kaŋgi, ana ŋkan kam ma. Ana won niamuuŋ ndava vhera rɨmani mbatɨgi ne, ŋka vhɨra ne kaŋgi. ");
INSERT INTO geb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ana ntigem ram muuŋgiap rɨmani nzerigi, ŋka ne kaŋgi fhu. The ana rɨmani ga muuŋgim, ni nzerigi, ŋka vhɨra ne kaŋgi fhu. Nde anan nzaŋri. Ana guman rum ma. Ana nduara wo bun nde suaŋri.” ");
INSERT INTO geb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ana niamuuŋ gu ndia Zudain gumgir panin rivgiap mba kameŋ nzuai. Mbe Zudain gumgir pani, mbe kha kameŋ suaŋgiap wari ki. Maaŋ muuŋgip, guma the khaŋ mba guma ga suanga, Zisas Fhe Bakɨme taagip won gumgi gu mbigi ndir zav farasarigi guma ma, mbe maaŋ nzuai guma, mbe ana thɨvarga, ana mbe phorgɨv rotur muuŋgirga fhu. ");
INSERT INTO geb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mba bigɨna nɨɨeŋra nzuav, mba guman niamuuŋ gu ndia khaŋ suaŋgi, “Ana guman ruma muuŋgi, nde ana nzaŋri.” ");
INSERT INTO geb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mbe mbara wom phenatɨtɨgap mba rɨmani mbatɨgia kegi guman kamgi. Mbe ana kamgiap khaŋ ana nzuai, “Ndu ntigem Fhe Bakɨme zɨ ndiv vun kuamkuav, kama havharar suaŋv, guigira suaŋri. Nza kaŋgi, ndu mba nzuai guma, ana tɨvi mbatɨgi ga mbui guma ma.” ");
INSERT INTO geb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ana mbe ŋgarkarav khaŋ nzuai, “Ana tɨvi mbatɨgi ga mbui guma thi, fhuv thi? Gu ne kaŋgirga fhu. Gu bigɨn bueŋra kaŋgi. Gu fhum rɨmani mbatɨgiap kegap, gu ntigem nan rɨmani nzerigim, gu tuituigiap gari.” ");
INSERT INTO geb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mbe wom kha nzambarar ana muuŋgi, “Ana ram ndu muuŋgi? Ana ram ndu rɨmani ga muuŋgim, ndu rɨmani nzerigim, ndu tuituigiap gari?” ");
INSERT INTO geb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ana mbe ŋgarkarav khaŋ nzuai, “Gu nde suaŋgi, nde mbarara thagi. Nde thaŋ nzuav pim ne mbararar zav mbui? Ee, nde vhɨra ana phorga rui gumgi kɨr zave?” ");
INSERT INTO geb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ana ne mbe nzuaim, mbe Fherasiŋ ana nzɨɨv, khaŋ ana nzuai, “Ndura ana phorga rui guma ma. Nza Moses phorga rui gumgi ma. ");
INSERT INTO geb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nza kaŋgi, Fhe Bakɨme won bunin Moses ga suaŋgi. Mba guma, ana maaŋ kegap hɨgi? Nza ana kaŋgi fhu.” ");
INSERT INTO geb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mba rɨmani mbatɨgia kegi guma mbe ŋgarkarav khaŋ mbe nzuai, “Nde harigi khesharigi bunira nzuai.” Mba guma na rɨmani ga muuŋgim, ni nzerigim, nde khaŋ nzuai, “Nza ana kaŋgi fhu, ana maaŋ kega zɨgi. ");
INSERT INTO geb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nza khueŋ kaŋgi, Fhe Bakɨme tɨvi mbatɨgi ga mbui gumgi nzuai buni mbararagi fhu. Guma, ana Fhe Bakɨme rotu mbuav, ana piin kav, ana ana vuzvugi zɨn vui, Fhe Bakɨme mba guma buni mbararagi. ");
INSERT INTO geb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Fhum guarara kega zav ntigem, guma the won niamuuŋ ndava vhera rɨmani mbatɨgim, ana niamuuŋ ana tegim, ana mbara muuŋgiap kim, guma the ana rɨmani ga muuŋgim, ni nzerigim, mbe mba kameŋ neŋgi buna thueŋ ki fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Fhe Bakɨme kha guma ga sararim, ana zɨgɨrga fhu, ana bigɨn thueŋ muuŋgirga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mbe Fherasiŋ, mbe ana nzuai kameŋ mbararagiap, mbe ana ŋgarkarav khaŋ nzuai, “Ram muuŋgi? Ndu niamuuŋ ndu tegi tugen kega za ntige kha tuge thɨgi, tɨvi mbatɨgi guigira ndu phorga ki. Ndu ndɨkndɨgi vhuuin nza khɨvɨv nza suan za mbuire?” Mbe nen ana nzuav, ana vharigim, ana mbe thav vugi. ");
INSERT INTO geb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Zisas mbe mba guma ga vharigi ne mbararagiap, ana nzuav gara vui. Zisas ana nzua gara vov, ana gangiap, khaŋ ana nzuai, “Ndu Fhe Bakɨme Guma Guara khothɨgi o, fhu?” ");
INSERT INTO geb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ana Zisas ŋgarkarav khaŋ nzuai, “Guman Rum, the Fhe Bakɨme Guma Guar? Ndu na suaŋgirim, gu ana khothɨgɨrga.” ");
INSERT INTO geb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Zisas khaŋ ana nzuai, “Ndu ana gangi. Mba gumara ntige khar ndu phorga nzuai.” ");
INSERT INTO geb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mba guma thav khaŋ nzuai, “Guma Bakɨme, gu khothɨgi.” Ana ne nzuav, wo thɨpanani phɨrgiap fav, za Zisas rotu mbui. ");
INSERT INTO geb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Zisas mbara khaŋ ana nzuai, “Gu kha gumgi gu mbigi mbui tɨvi mbatɨgi ga suaŋv mbe suaŋv nta ndi kɨra sur zav kha nuianan zergi. Mba rɨmgi mbatɨgi gumgi, mbe rɨmgi nzerav ganɨnga. Mba rɨmgi nzerav gari gumgi mbe rɨmgi mbatɨgirga.” ");
INSERT INTO geb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mba Fherasiŋ mbari Zisas han kav mba kameŋ mbararagi. Maaŋ muuŋgiap, mbe ana nzarigi, “Ndu vhɨra khaŋ nza nzuai thi, nza vhɨra rɨmgi mbatɨgi?” ");
INSERT INTO geb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Zisas mbara khaŋ mbe nzuai, “Nde rɨmgi mbatɨgirga, nde tɨva mbatɨk thueŋ muuŋgi ne suaŋv simtɨk kɨrga fhu. Nde khaŋ nzuai, ‘Nzan rɨmgi mbatɨgi fhu, nza nzerara gari.’ Maaŋ muuŋgiap, nde muuŋgi tɨvi mbatɨgi mbara muuŋgiap nden ki.” ");
INSERT INTO geb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Zisas mbe nzua vov wom khaŋ nzuai, “Gu guigira nde nzuai, guma, ana sipsivi ki bɨna thɨmkamani mbugum vhen veri fhu, ana harigi ŋanen bɨna kharav vhen veri, mba khesharigi guma, ana kɨɨi guma gum harigi gumgi shogap, mbe bigi ndi guma ma. ");
INSERT INTO geb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Guma thɨmkamani mbugum bɨna vhen veri, ana mba sipsivi gari guma ma. ");
INSERT INTO geb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mba thɨmkamani gari guma, ana mba guma ga nzuav thɨma fhɨri. Mba sipsivi anan kamthooŋ kaŋgiap ana mbararagi. Ana won sipsivi bevbevira mben zɨri zitav, mbe kov kɨrar hi. ");
INSERT INTO geb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ana won sipsivir kov za kɨrar hegap, ana mben nɨma thɨgap fharigi. Ana sipsivi anan kamthooŋ kaŋgi, mbe maaŋ muuŋgiap ana zɨn vui. ");
INSERT INTO geb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mbe harigi guma zɨn vui fhu. Zakɨra fhuvara! Harigi guma the mben kamɨnga, mba sipsivi ana kamthooŋ mbararagip, mbe rɨv ŋgɨrga. Ne khaŋ muuŋgi, mbe harigi guma kamthooŋ kaŋgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Zisas mba bunen vhunama daav mbe nzuaim, mbe ana mba vhunama daav mbe nzuai buna nɨɨeŋ, mbe ne kaŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Zisas mbara wom khaŋ mbe nzuai, “Gu guigira nde nzuai, gu nduara mba sipsivi bɨna vhen veri thɨmkamani ma. ");
INSERT INTO geb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mba na nɨma thɨgap fhara zɨgi gumgi, mbe kɨɨi gumgi gum harigi gumgir shogap, mbe bigi ndi gumgi ma. Maaŋ muuŋgiap, mba sipsivi mben kaathoori mbararagi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Gu nduara, gu thɨmkamani ma. Guma the zɨv nan hɨgɨp, ŋgɨp bɨna vhen ŋgɨrgɨrga, Fhe Bakɨme taagip ana ndigɨrga. Ana vhen kɨv kɨrar hɨv, taagi vhen ŋgirɨrga. Ana maaŋ muuŋv mbur ŋgɨp khar zɨv, mba ndirga. ");
INSERT INTO geb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Kɨɨi guma, ana harigi bigen muun za zi fhuvara. Zakɨra fhuvara! Ana sipsivi kɨmɨv, mben farfav, mbe shogɨrim, mbe vhɨzɨr zav zi. Gu mbe zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndir zav gu zɨgi. Mbe maaŋ muuŋgip, mbe guigira mpirmpirɨga vhuun muuŋgirga. ");
INSERT INTO geb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Gu nduara sipsivi gari guman vhuuŋ ma. Sipsivi gari guman vhuuŋ, ana won sipsivir kurkurar zav won tuma fekhɨngiap won sipsivir kurkurigi. ");
INSERT INTO geb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Guma ŋkɨɨra nzuav ŋgari, ana vhɨra sipsivi gari guman vhuuŋ fhu, ana vhɨra mba sipsivir vuavi fhuvara. Ana maaŋ muuŋgip ruaŋruaŋgi fiaŋ ganɨrim, ana zɨrga, ana mba sipsivi thav rɨv ŋgɨgɨrga. Mba ruaŋruaŋgi fiaŋ sipsiva the shogɨrim, mba harigi sipsivi mbe rɨv tamtam ŋgegɨrga. ");
INSERT INTO geb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mba guma rɨv ŋgɨrga ne khaŋ muuŋgi, mba guma ana vhezara nzuav ŋgari. Ana guigira mba sipsivi ga ndɨkndɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Gu nduara, gu sipsivi gari guman vhuuŋ ma. Dara na kaŋgim, gu Dara kaŋgi. Mba tɨvara gu won sipsivi kaŋgim, nan sipsivi na kaŋgi. Gu won tuma fekhɨngip, won sipsivir kurarga. ");
INSERT INTO geb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Gu vhɨra harigi sipsivi ki, mbe kha bɨna ntɨɨri fhuvara. Gu mba sipsivi, gu vhɨra nta ndigip zɨrga. Nta vhɨra na kamthooŋ mbarararga. Maaŋ muuŋgirga, nta za wari tɨgɨp na sipsivira kɨrga, nta gari guma bavira kɨrga. ");
INSERT INTO geb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Dara guigira na vuzvugi, ne khaŋ muuŋgi. Gu won tuma fekhɨngip, gu maaŋ muuŋgip taagi ana ndigɨrga. ");
INSERT INTO geb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Guma the za nan tuma vhɨzgirga tuktɨgi fhuvara. Zakɨra fhuvara! Gu wo vuzvugara, gu won tuma fekhɨngirga. Gu won tuma fekhɨngirga ŋkasŋka ki. Gu vhɨra taagi ana ndirga ŋkasŋka ki. Nan Ndia maaŋ muun zav na suaŋgim, gu maaŋ mbui.” ");
INSERT INTO geb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ana maaŋ nzuaim, mba Zudaiŋ ne mbararagiap, mbe taagia rɨgɨra wari shɨrigi. ");
INSERT INTO geb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mbe gumgi vhɨrvera khaŋ nzuai, “Ŋina mbatɨk ana vhen kim, ana ŋanŋani. Nde thaŋ nzuav khuarir ana buni ga tɨgi?” ");
INSERT INTO geb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mbe mbari khaŋ nzuai, “Khe ŋina mbatɨk vhen ki guma nzuai buni mbure fhuvara. Ee, ŋina mbatɨk rɨmani mbatɨgi guma then muuŋgirim, ana rɨmani taagi nzerarie?” ");
INSERT INTO geb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mba tugera mbe rotu mbui tuga bakɨ mbe Zerusareman ki. Mba rotu mbui tuga bakɨme, mbe Fhe Bakɨme Phena muuŋgim, ana guigira Fhe Bakɨme Phen ki. Mba rotu mbui tuga bakɨme, mbe rugahi tugen mba rotu mbui. ");
INSERT INTO geb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Zisas mba Fhe Bakɨme phena bɨna vhen Soromon vunkamen thɨva ruav ki. ");
INSERT INTO geb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Mbe Zudaiŋ zav, za ana behuigia thivgiap kha nzambaren ana muuŋgi, “Ndu rasɨn wo bun nza suaŋrie, ndu the guarara? Ndu mba Fhe Bakɨme taagip wo gumgi gu mbigi ndir zav farasarigi guma, ndu tuituigip nza suaŋ.” ");
INSERT INTO geb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Zisas mbe ŋgarkarav khaŋ nzuai, “Gu nde suaŋgi, nde na khothɨgi fhu. Gu won Ndiar zɨn panan mbui ŋaari, nde mba ŋaari garav, nde na kaŋgi. ");
INSERT INTO geb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nde na sipsivi fhuvara. Maaŋ muuŋgiap, nde na khothɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nan sipsivi nan kamthooŋ kaŋgim, gu vhɨra mbe kaŋgi, mbe na zɨn vui. ");
INSERT INTO geb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Gu zazera mbara muuŋgiap ki bɨɨŋbɨɨn mbe ndɨɨi, mbe fhɨrgirɨgɨp, ŋgu mbatɨgar ŋgegɨrga fhu. Zakɨra fhuvara! Guma the na farve tɨn mbe vhararga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Na Dara mben na nɨɨŋgi. Ana guigira fhara guarara kav, ana zɨ za kha bigi kharav, guigira vu guarara ki. Maaŋ muuŋgiap, guma the na farve tɨn mbe vhɨrarga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Gu won Ndiar kov, ŋka wani tɨgap ŋka bavira ki.” ");
INSERT INTO geb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mbe Zudaiŋ ne mbararagiap, mbe wom ŋkɨɨa ana sɨrim, ana rɨmɨn za mbui. ");
INSERT INTO geb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Zisas mbaram khaŋ mbe nzuai, “Gu Darar ŋaarir vhuuiŋ vhɨrver nde khɨvigi. Nde maaŋgi ŋaara ndɨkndɨgap, ŋkɨɨar na sɨr za mbui?” ");
INSERT INTO geb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Mbe Zudaiŋ ana ŋgarkarav khaŋ nzuai, “Nza ndu muuŋgi ŋaara vhuuŋ the ndɨkndɨgap ŋkɨɨar ndu sɨr za mbui fhuvara. Zakɨra fhuvara! Ndu Fhe Bakɨme zɨn farfav, ana ŋana ndir za mbuim, nza ne nzuav, ŋkɨɨar ndu sɨr za mbui. Ndu guma khɨn ma, ndu fhura khaŋ nzuai, ‘Gu nduara Fhe Bakɨme ma.’ ” ");
INSERT INTO geb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Zisas mbe ŋgarkarav khaŋ nzuai, “Fhe Bakɨme won ŋaarir muuŋv, wo buni mbari bun suan zav zɨ bakɨme nde nɨɨŋgi. Maaŋ muuŋgiap, Fhe Bakɨme buni vhuuiŋ ki gavar kama mueŋ khaŋ nzuai, ‘Nde Fhe Bakɨme fara muuŋgi.’ ");
INSERT INTO geb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Fhum Fhe Bakɨme kha kamen gumgi ga nzuav khaŋ nzuai, ‘Fhe Bakɨme fara muuŋgi.’ Fhe Bakɨme buni vhuuiŋ ki gavar ki buni, nta zazera mbara muuŋgiap ki buni guari ma. ");
INSERT INTO geb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Gu, Dara nduara na farasarav, na sarigim, gu kha nuianan zergi. Maaŋ muuŋgiap, gu khaŋ nzuai, ‘Gu Fhe Bakɨme Kam ma,’ gu maaŋ nzuaim, nde thaŋ nzuav, khaŋ nzuai, ‘Ndu Fhe Bakɨme zɨn farfav, ana ŋana ndir za mbui’? ");
INSERT INTO geb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Gu won Ndiar ŋaarar muunga fhu, nde maaŋ muuŋgip na khothɨgɨrga fhu. ");
INSERT INTO geb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Gu ana ŋaara mbui. Nde na buni khothivɨ thagi, nde gu mbui ŋaari, nde nta khothɨgɨri. Maaŋ muuŋgip, nde ndɨkndɨgi vhuuiŋ kaŋgip, kha ndɨkndɨgar muuŋri, Dara nan han kim, gu Dara han ki. Ŋka wani tɨgap guma bavira.” ");
INSERT INTO geb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mbe taagip ana suigɨr za mbuim, ana mben vhevge rɨgap vugi. ");
INSERT INTO geb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Zisas taagia vov Zordan mbɨ thugap, mueŋ nderen hɨgi. Ana vov Zon Gumgi Ruai Guma fhum gumgi gu mbigi ruagi ŋanen vugap mba ŋanen ki. ");
INSERT INTO geb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ana kim, gumgi gu mbigi vhɨrve ana han zi. Mbe zav khaŋ ana nzuai, “Khueŋ guigi guarara, Zon wo buni havhari mirikora havhara the muuŋgi fhuvara. Zon kha guma ga nzuav suaŋgi buni, nta guigira buni guari ma.” ");
INSERT INTO geb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Zisas maaŋ ki tugivigen, gumgi gu mbigi vhɨrvera ana khothɨgi. ");
INSERT INTO geb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betani guma mbe, Rasarus, ana rɨɨi. Betani, ana Maria won mbiga hɨrɨɨŋ Martan kov, ana manin ŋgu ma. ");
INSERT INTO geb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mba Mariara, ana ndɨga vhuuŋ hi mporiiŋ siav Guma Bakɨme ŋkarve ga suav, won pana rɨgira, ana ŋkarve thɨgi. Mba rɨɨi guma, Rasarus, ana Maria gu Martan fe ma. ");
INSERT INTO geb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mani kama ndiv Zisas ndi mbav khaŋ nzuai, “Guma Bakɨme ndu mba guigira vuzvugi guma, ana rɨɨi.” ");
INSERT INTO geb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Zisas mba kameŋ mbararagiap khaŋ nzuai, “Mba rɨmrɨm, ana guma shogirim, ana rɨmɨnga rɨmrɨm fhuvara. Mba rɨmrɨm, ana gumgi gu mbigi Fhe Bakɨmen ŋkasŋka ganɨv, zɨ bakɨmen ana nɨɨn za mbui. Mba tuavra Fhe Bakɨme Guma Guar, ana vhɨra zɨ bakɨme ndirga.” ");
INSERT INTO geb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Zisas Marta gum, anan mbiga hɨrɨɨŋ vuzvugiap vhɨra manin fe Rasarus, ana guigira mbe vuzvugi. ");
INSERT INTO geb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Zisas Rasarus rɨɨi kameŋ mbararagiap, ana ra phuni phorgap, ana mba ki ŋgun kegi. ");
INSERT INTO geb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mba ra phuni vhɨzgim, ana khaŋ wo phorga rui gumgi ga nzuai, “Nza taagip Zudia ŋgu bakɨme fhain ŋgɨrga.” ");
INSERT INTO geb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ana phorga rui gumgi khaŋ ana nzuai, “Guman Rum, Zudaiŋ ruarɨmra ŋkɨɨr ndu sɨrim, ndu rɨmɨn za muuŋgi. Ee, ndu ntigem taagip Zudian nan za mbuire?” ");
INSERT INTO geb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Zisas mbe ŋgarkarav khaŋ mbe nzuai, “Raa bavira 12 thɨgi aua ki fhuve? Guma ana maaŋ muuŋgip raar rurga, ana rɨgɨrga fhu. Ne khaŋ muuŋgi, ana kha nuiana shɨgi ran ŋaarar ndi ndɨɨi guma gangi. ");
INSERT INTO geb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Guma maaŋ muuŋgip maan rurga, ana rɨgɨrga. Ne khaŋ muuŋgi, ana wo suaŋv ganɨnga vhava ŋaar ki fhu.” ");
INSERT INTO geb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Zisas maaŋ mbe suaŋgiap, mbaram khaŋ mbe nzuai, “Nzan kɨvntok Rasarus kui. Gu ŋgɨv anan vhurarga.” ");
INSERT INTO geb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ana phorga rui gumgi ne mbararagiap khaŋ ana nzuai, “Guma Bakɨme, ana maaŋ muuŋgip kurga, ana rɨmrɨm vhɨzgirga, ana taagi nzerarga.” ");
INSERT INTO geb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ana phorga rui gumgi khueŋ kaŋgi fhuvara, Rasarus rimgim, Zisas ana nzuai. Mbe khueŋ ndɨkndɨgi, Rasarus kuim, Zisas ana nzuai. ");
INSERT INTO geb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Maaŋ muuŋgiap, Zisas mbe hiav khaŋ mbe nzuai, “Rasarus, ana rimgi. ");
INSERT INTO geb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Gu nde ndɨkndɨgap, gu ndikndigi, gu mba tugen ana phorgɨ kɨ thagi. Ne khaŋ muuŋgi, ne nden muuŋgirga, nde na khothɨgɨrga. Nza ntigem ana han ŋgɨrga.” ");
INSERT INTO geb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Zisas maaŋ suaŋgim, Tomas, ana zɨ mbe Didimus, ana khaŋ mba Zisas phorga rui gumgi mbari ga nzuai, “Aria, nza za ŋgɨp Guma Rum phorgɨp vhɨzgirga.” ");
INSERT INTO geb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Zisas wo phorga rui gumgir kov, mbe vov Betani ŋgun han mbav, Zisas kha kameŋ mbararagi, Rasarus rimgiap mboga tɨgim, fethɨgi rari vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani Zerusarem hara, ki, ana khaŋ muuŋgi, 3 kiromitara. ");
INSERT INTO geb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Maaŋ muuŋgiap, Zudaiŋ gumgi gu mbigi vhɨrvera, mbe zav, Marta gu Maria han manin fen porar ki. ");
INSERT INTO geb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata Zisas zi ne mbararagiap, ana purav tuavar vuim, Maria phenan ki. ");
INSERT INTO geb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta vov khaŋ Zisas ga nzuai, “Guma Bakɨme, ndu khaŋ kake, nan fe rimgia ntɨɨŋ. ");
INSERT INTO geb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Gu ntige vhɨra kaŋgi, ndu bigɨn the suaŋv Fhe Bakɨme phorgɨ suanga, ana mba bigɨnan ndun nɨɨŋgirga.” ");
INSERT INTO geb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Zisas khaŋ ana nzuai, “Ndun fe taagi khavgirga.” ");
INSERT INTO geb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta mbara khaŋ ana nzuai, “Gu kaŋgi, ana mba vhɨzgi gumgi gu mbigi za khavi tugen, ana taagi khavgirga.” ");
INSERT INTO geb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Zisas mbaram khaŋ ana nzuai, “Gu nduara taagia guma khavav, bɨɨŋbɨɨŋ ana ndɨɨim, ana ki nen nɨɨŋge ma. Guma na khothɨgap ana rimgi, ana zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigi. ");
INSERT INTO geb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ŋam kav na khothɨgi guma, ana vhɨzgirga fhu. Ndu ne khothɨgire?” ");
INSERT INTO geb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta mbara khaŋ Zisas ga nzuai, “Ahaŋ, Guma Bakɨme, gu khueŋ khothɨgi, ndu Fhe Bakɨmen Kam ma. Ndu Fhe Bakɨme taagip kha nuianan ki gumgi gu mbigi ndir za suaŋgiap sarigi kha nuianan zirɨr za mbui guma ma.” ");
INSERT INTO geb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta maaŋ suaŋgiap, mbara vov wo mbiga hɨrɨɨŋ Mariar kaai. Maria zim, ana mbarara ana khuareŋ ga tɨgap khaŋ ana nzuai, “Ndɨkndɨgi vhuuin nza khɨvi Guman Rum zɨga mbur kav, ndu nzuav ŋkɨɨa mbui.” ");
INSERT INTO geb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria ne mbararagia thav, vhemkora khavgia Zisas ganɨn za vui. ");
INSERT INTO geb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Zisas vov ŋgun hɨgi fhuvara. Ana mba Marta ana purav, vov ana gangi ŋanera ki. ");
INSERT INTO geb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mbe Zudaiŋ, mbe Maria kharav ana phorgap ki. Mbe ana garim, ana vhemkora khavgiap kɨrar him, mbe vhɨra ana zɨn vui. Mbe khueŋ ndɨkndɨgi, “Ana nzir zav mbok taan vui thi?” ");
INSERT INTO geb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria vov mba Zisas ki ŋanen hɨgap, Zisas gari. Ana Zisas garav, Zisas ŋkarveni nɨman thɨpanani phɨrgiap fav, khaŋ nzuai, “Guma Bakɨme, ndu khaŋ kake, nan fe rimgia ntɨɨŋ.” ");
INSERT INTO geb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Zisas Maria garim, ana nzim, ana phorga zegi Zudaiŋ, mbe vhɨra nzi. Ana ndava vhee guigira mbe kora muuŋgiap, ana vhɨra nzir za mbui. ");
INSERT INTO geb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ana thav khaŋ nzuai, “Nde ana ndi maaŋ mboga tɨgi?” Mbe khaŋ ana nzuai, “Guma Bakɨme ndu zɨv ganɨ.” ");
INSERT INTO geb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Zisas thav nzi. ");
INSERT INTO geb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Zudaiŋ ana gangiap khaŋ nzuai, “Ganɨ. Ana guigira kha guma vuzvugi.” ");
INSERT INTO geb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mbe mbari khaŋ ana nzuai, “Ana rɨmgi mbatɨgi gumgi, ana mbe rɨmgi ga mbuim, mben rɨmgi taagi gari. Ana kha guman kurarga tuktɨgi fhup thi, ana rimgi?” ");
INSERT INTO geb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Zisas guigira ndav simgiap, vov, ana mbogar hɨgi. Ana mbok, mbe mbɨkshɨman kɨma thoon ana muuŋgi. Mbe mba mbok, mbe kɨma bakɨ mben ana thɨni khuigi. ");
INSERT INTO geb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Zisas mbara khaŋ mbe nzuai, “Nde mba mbok thɨni khuigi kɨma daaŋgi mbur khɨnik.” Marta mba rimgi guman mbiga hɨrɨɨŋ, khaŋ Zisas ga nzuai, “Guma Bakɨme, ana rimgim, nza ana ndi mbok ga tɨgim, ra phuni khegene vhɨzgim, ntige fethɨgi raa ma. Maaŋ muuŋgiap, ana ndɨk mbatɨk hɨrga.” ");
INSERT INTO geb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Zisas mbara khaŋ ana nzuai, “Gu fhara ndu suaŋgi, ndu maaŋ muuŋgip na khothɨgɨrga, ndu Fhe Bakɨmen ŋkasŋka bakɨme ganɨnga.” ");
INSERT INTO geb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mbe mbara mba kɨma daaŋgia vov mbur khɨngi. Zisas mbara khoga vu garav, khaŋ nzuai, “Dara, gu ndun ndikndigi, ne khaŋ muuŋgi, ndu na buneŋ mbararagi. Gu kaŋgi, ndu zazera na buni mbararagi. ");
INSERT INTO geb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Gu kha thivgi gumgi ga ndɨkndɨgap kha kameŋ nzuai, mbe maaŋ muuŋgip khueŋ khothɨgɨrga, ndu na sarigim, gu zergi.” ");
INSERT INTO geb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Zisas ne suaŋgiap, mbara kama bakɨmera rugap khɨrɨp Rasarusan kamgi. “Rasarus, ndu mbok thav kɨrar hɨ!” ");
INSERT INTO geb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Rasarus mbara taagiap mbok thav khavgiap kɨrar hɨgi. Ana suani gu harani, mbe shagir nta ndogiap nta kegap, ana khom, mbe shaa fɨgen ana sharigim, ana nta khɨga kɨrar hɨgi. Zisas mbara khaŋ mbe nzuai, “Nde ana ndogi shagi fhɨrgirim, ana thivɨ ru.” ");
INSERT INTO geb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mbe Zudaiŋ vhɨrve, mbe Maria fen vhavar zegap, Maria phorga ki. Mbe Zisas muuŋgi bigeŋ gangiap, mbe ana khothɨgi. ");
INSERT INTO geb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mbe mbari, mbe vov Fherasiŋ han vegap, mba Zisas muuŋgi bigeŋ bun mbe suaŋgi. ");
INSERT INTO geb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Maaŋ muuŋgiap, mba Fhe Bakɨme rotu gari gumgir pani, gum Fherasiŋ, mbe mba buaadegi gumgir kamgim, mbe zav wari fugim, mbe khaŋ mbe nzuai, “Nza ram muuŋgirie? Kha guma, ana mirikori vhɨrve ga mbui. ");
INSERT INTO geb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nza fhura ana ganɨrim, ana mba tɨvar muunga, kha gumgi gu mbigi za ana khothɨgɨrga. Mbe maaŋ muunga Romiŋ zɨv Fhe Bakɨme Phenan farfav, nza ntɨɨrir farfagirga.” ");
INSERT INTO geb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mbe maaŋ nzuaim, mbe rɨgar guma mbe, ana zɨ Kaiafas, ana mba mpariven, ana Fhe Bakɨme rotu gari guman pan ki. Ana khaŋ mbe nzuai, “Nde guigira ndɨkndɨgi ki fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nde warir kurarga tɨva thueŋ kaŋgi fhuv thi? Khueŋ nzerara, guma bavira maaŋ muuŋgip, za kha gumgi gu mbigir ŋana ndigip rimgirga, mbe nza ntɨɨri farfagirga fhu.” ");
INSERT INTO geb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiafas, ana won ndɨkndɨgara mba kameŋ nzuai fhuvara. Ana mba mpariven, ana Fhe Bakɨme rotu gari guman pan kav, ana Fhe Bakɨme kamthooŋ guma nzuai mbugum, khaŋ nzuai, Zisas ana rimgip Zudain kurarga. ");
INSERT INTO geb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Zisas Zudaiŋra kurkurar zav rɨɨi fhuvara. Zakɨra fhuvara! Ana mba Fhe Bakɨmen tari, mbe za tamtam mbar ki, ana rimgip, za mbe fugurim, mbe za wari tɨgɨp ndava bavira ki ntɨɨri kɨrga. ");
INSERT INTO geb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mba raara mba gumgir pani, mbe Zisas shogirim, ana rimgirga tuavi ndi ganɨnga kaa shogi. ");
INSERT INTO geb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Maaŋ muuŋgiap, Zisas wom Zudaiŋ rɨgar hiiŋ sarav rui fhuvara. Ana mba ŋgu thav, vov, gumgi ki fhuv ŋaneŋ, mbe kha zɨn rɨgi ŋgun ki, Efraim. Ana wo phorga rui gumgir kov, mbe mba ŋgun ki. ");
INSERT INTO geb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Zisas maaŋ kim, mbe Zudaiŋ, mbe Pasova rotu bakɨme tuk han mbarigi. Mba gumgi gu mbigi vhɨrve, mbe tamtam wari won ŋguir kegap Zerusareman ndai. Mbe naaŋv, warir muuŋgip, Fhe Bakɨme nɨman ŋgararga. ");
INSERT INTO geb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Mbe Zisas ga nzuav gari. Mbe ana nzuav garav, Fhe Bakɨme phena bɨnan vhee thivgiap, nduarira warira phorga nzuav khaŋ nzuai, “Nde ram mbui ndɨkndɨga mbui? Ana kha rotu mbui tugi bakɨvi ganɨ saŋv ndarga o, fhu?” ");
INSERT INTO geb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mba Fhe Bakɨme rotu gari gumgir pani gum Fherasiŋ, mbe khaŋ mba gumgi gu mbigi ga suaŋgi. Mbe maaŋ muuŋgip, guma the Zisas ki ŋaneŋ kaŋgip, ne bun mbe suaŋgirim, mbe ana suirav ana ndi bɨna khɨngirga. ");
INSERT INTO geb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Mbe maaŋ suaŋgiap, mporathɨgi rari vhɨzgirim, mbe Pasova rotu mbui tugi bakɨvi hɨrga. Mba tugivigen Zisas Betanin vergi. Betani, ana Rasarusan ŋgu ma, mba guma rimgiap, mbok ga tɨgim, Zisas taagia ana khavgi. ");
INSERT INTO geb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mbe Zisasan ndikndigap ana nzuav shama mbui. Marta mbe nzuav mba tuim, Rasarus mba Zisas phorga pi gumgi han perav ki. ");
INSERT INTO geb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria mbara ndɨga vhuuŋ hi mporiiŋ vhuuŋ guarara, ana nda bisanen ki. Mba mporiiŋ vhez guigira vun ndagi. Ana ana ndiga zav Zisas suani hɨvgiap, mbara won pana rɨgira ana suani thɨgi. Ana maaŋ mbuim, mba mporiiŋ ndɨk za mba phena phorgi. ");
INSERT INTO geb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ana maaŋ mbuim, Zisas phorga rui guma mbe, ana zɨ Zudas Iskariot, ana zumgum Zisas ndi ana pana gumgi farve khɨngi, ana khaŋ nzuai, ");
INSERT INTO geb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nza ram muuŋgiap mba mporiiŋ ndi maaŋrim, harigi ntɨɨri ana vhezgirgeŋ thagi? Mbe ana vhezɨrga vhez, guma phɨkthɨgi kɨnin ŋgarigim, mbe ana vhezi vheza fara muuŋgi. Nza maaŋ muuŋgi ŋkɨɨa ndigip, mba bigi sosuagi gumgir nɨɨnga.” ");
INSERT INTO geb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Zudas, ana mba bigi sosuagi gumgi ga ndɨkndɨgap nzuai fhuvara. Zakɨra fhuvara! Ana kɨɨi guma ma. Ana Zisas phorga rui gumgi, ana mben ŋkɨɨa gari guma ma. Ana nta garav, ana tugi vhɨrvera, ana mba ŋkɨɨar wora nzuav bigi ga vhezi. ");
INSERT INTO geb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Zisas Zudas suaŋgi kameŋ mbararagiap khaŋ nzuai, “Ndu fhura mba mbiga ganɨri. Ana mba mporiiŋ siv na fhava suav na hɨvgirim, mbe zumgum na ndigi ŋgɨp mbogar rɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mba bigi sosuagi gumgi, mbe zazera nde phorgɨ kɨrga. Gu zazera nde phorgɨ kegɨrga fhu.” ");
INSERT INTO geb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mbe Zudaiŋ vhɨrvera khueŋ kaŋgi, Zisas Betanin kim, mbe ana han zi. Mbe vhɨra Zisasra ganɨ zav zi fhuvara. Mbe kaŋgi, Zisas Rasarus rimgiap mboga tɨgim, Zisas wom ana khavgim, mbe vhɨra ana ganɨ zav zi. ");
INSERT INTO geb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Maaŋ muuŋgiap, mba Fhe Bakɨme rotu gari gumgir pani, mbe ne nzuav, vhɨra Rasarus shogirim, ana rimgir zav kama shogi. ");
INSERT INTO geb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ne khaŋ muuŋgi, mbe Zudaiŋ vhɨrve, Zisas mba Rasarus ga muuŋgi bigeŋ, mbe ne gangiap, mba Fhe Bakɨme rotu gari gumgir pani thav, mbe Zisas khothɨgi. ");
INSERT INTO geb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Gumgi gu mbigi vhɨrve guarira, mbe mba rotu mbui tuga bakɨme ganɨ za ndav Zerusareman kav, mbe mbararagim, Zisas Zerusareman nan za mbui. ");
INSERT INTO geb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Maaŋ muuŋgiap, mbe tumaraŋ nzari hargiap, anan puav tuavar veri. Mbe verav kaa khaŋ nzuai, “Nza Fhe Bakɨmen ndikndigi. Fhe Bakɨme tɨvir vhuuiŋ kha guman muuŋri. Ana Fhe Bakɨme zɨn panan zi. Fhe Bakɨme tɨvir vhuuiŋ kha guma muuŋri. Ana Isrerin ŋgui vhɨrve gari guman pan kɨrga.” ");
INSERT INTO geb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Zisas doŋki mbe ndigap ana perigi. Ana mba Fhe Bakɨmen buni vhuuiŋ ki gavar ki buna mueŋ zɨra vugi. Mba kameŋ khaŋ nzuai, ");
INSERT INTO geb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Nde Saion ŋgu bakɨmen ki gumgi gu mbigi, nde rɨvɨ thari. Nde ganɨ! Nden ŋgui vhɨrve gari guman pan ntige mbur zi. Ana doŋki ŋguga kama perav mbur zi.” ");
INSERT INTO geb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ana phorga rui gumgi, mbe farav mba buna nɨɨeŋ kaŋgi fhu. Mbe zumgum Fhe Bakɨme zɨ bakɨmen ana nɨɨŋgim, mbe mba Fhe Bakɨmen buni vhuuiŋ ki gavar ki kameŋ ndɨrigi. Mbe ne ndɨrɨgap, mbe kaŋgi, mba kameŋ Zisasra nzuai. Mbe ne ndɨkndɨgap, mbe wom mba gumgi gu mbigi ana muuŋgi ne ndɨkndɨgi. ");
INSERT INTO geb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Rasarus rimgiap mbogar ki tugen, gumgi gu mbigi vhɨrve, mbe Zisas phorga kav, ana garim, ana Rasarusan kamgiap, taagia ana khavgi. Mba gumgi gu mbigi, mbe ntigem, mbe mba Zisas muuŋgi bigeŋ bun nzuav rui. ");
INSERT INTO geb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mba gumgi gu mbigi ana mba mirikor ga muuŋgi ne mbararagiap, mbe ana puav tuavar vui. ");
INSERT INTO geb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mba Fherasiŋ mbe gangiap, mbe nduarira wari phorga nzuav khaŋ nzuai, “Mbur ganɨ. Nza mba muun zav nzuai bigeŋ, ne ntige hɨgɨrga tuktɨgi fhuvara. Kha gumgi gu mbigi za ana zɨn vui.” ");
INSERT INTO geb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mba Pasova rotu mbui tuga bakɨmen Fhe Bakɨme rotur muun zav Zerusareman ndagi gumgi gu mbigi rɨgar, mbe Grikiŋ mbari, mbe vhɨra ndagi. ");
INSERT INTO geb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Mba ndagi Grikiŋ, mbe Garirin Betsaida guma Firip han zi. Mbe zav khaŋ ana nzuai, “Guma, nza Zisas ganɨn za mbui.” ");
INSERT INTO geb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Firip mbara vov Andru ga suaŋgiap, mani wani tɨga vov Zisas ga nzuai. ");
INSERT INTO geb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Mani Zisas ga nzuaim, Zisas mani buneŋ ŋgarkarav khaŋ nzuai, “Fhe Bakɨme Guma Guar, ana zɨ bakɨme ndirga tuk ntige hɨgi. ");
INSERT INTO geb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Gu guigira nde nzuai, wit vhɨk nuiana rɨgɨv vhɨzgirga fhu, ana nduara kɨrga. Ana maaŋ muuŋgip vhɨzgip, taagi thooŋgirga, ana guigira kɨvgip, vhɨgi mbararga. ");
INSERT INTO geb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Maaŋ muuŋgip, guma the won tumara ndɨkndɨgɨrga, ana tum za fhɨrgirɨgɨp, za vhɨzgirga. Guma maaŋ muuŋgip kha nuianan kɨr won tuma segɨrga, ana tuma suirarga mbara muuŋgip kɨrga. ");
INSERT INTO geb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Maaŋ muuŋgip, guma nan ŋaara muuŋv, ana na zɨn zɨri. Gu mba ki ŋaneŋ, nan ŋaara guma na phorgɨp mba ŋanen kɨrga. Guma nan ŋaara mbui, nan Ndia zɨ bakɨmen ana nɨɨnga.” ");
INSERT INTO geb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Zisas wom khaŋ nzuai, “Ntigem, na ndav simgim, gu ndɨkndɨgi vhɨrve ga mbui. Gu ram suaŋrie? Ee, gu khaŋ suaŋrie? ‘Dara, ndu ntigem khar nan hɨr za mbui bigeŋ, ndu na tɨn ne ndigiri!’ Zakɨra fhuvara! Gu maaŋ suaŋgirga tuktɨgi fhuvara. Kha tugen nan hɨr zav mbui simtɨk, ana mbar nan hɨgɨ. Gu mba bigɨna nɨɨeŋra nzuav zergi. ");
INSERT INTO geb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dara, ndu won zɨn muuŋgirim, ana kɨvgiri.” Zisas mba kameŋ suaŋgim, guma kamthooŋ mbe Hevenan kega khaŋ nzuai, “Gu wo zɨ muuŋgim, ana kɨvgi, gu wom anan muuŋgirga.” ");
INSERT INTO geb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mba ana han thivgi gumgi gu mbigi, mbe mba kameŋ mbararagiap, mbe khaŋ nzuai, “Buip phɨreri.” Mbe mbari khaŋ nzuai, “Fhe Bakɨme enser mbe ana phorga nzuai.” ");
INSERT INTO geb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Zisas mben kameŋ ŋgarkarav khaŋ nzuai, “Nde ntigem mbararagi kameŋ, ne nde nzuav hɨgi. Ne na nzuav hɨgi kameŋ fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Fhe Bakɨme ntigem kha nuianan ki gumgi gu mbigi muuŋgi tɨvi ga suaŋv, mbe suanga tuk ma. Ana ntigem, kha nuiana gari guman pana vhararga. ");
INSERT INTO geb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mbe na ndi ntorgɨrga. Gu mba tugen, gu za mba gumgi gu mbigi, ŋgɨrgɨrim, mbe na han zɨrga.” ");
INSERT INTO geb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Zisas mba buni nzuav, ana wo rɨmɨnga tɨva bun nzuai. ");
INSERT INTO geb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mba gumgi gu mbigi ana ŋgarkarav khaŋ nzuai, “Nza Fhe Bakɨme Moses ga nɨɨŋgi tɨvi, nza nta mbararagim, nta khaŋ nzuai, ‘Fhe Bakɨme mba taagi wo gumgi gu mbigi ndir zav farasarigi guma, ana hɨgɨp, ana zazera mbara muuŋgip kɨrga.’ Ram muuŋgi kameŋ khare, ndu khaŋ nzuai, ‘Mbe Fhe Bakɨme Guma Guar, mbe ana ndi ntorgɨrga?’ Mba Fhe Bakɨme Guma Guar, ana the ma?” ");
INSERT INTO geb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Zisas mbara khaŋ mbe nzuai, “Tuga bisanera vhava ŋaar nde phorgɨv kegɨrga. Nde ntigem vhav ŋaar nden han khar ki, nde vhava ŋaarara ruri. Nde muuŋv kɨrim, gɨngɨn nde vhararga. Guma, ana gɨngɨna rui, ana wo vui ŋaneŋ kaŋgi fhu, ana maaŋ vui. ");
INSERT INTO geb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ntigem, vhava ŋaar nde phorga kim, maaŋ muuŋgiap, nde vhava ŋaara khothɨgap, nde vhava ŋaarar tari kɨrga.” Zisas mba bunin mba gumgi gu mbigi phorga suaŋgiap, mbe thav vov wo vhagi. ");
INSERT INTO geb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mbe ana garim, ana mirikori vhɨrve ga muuŋgi, mbe ana khothɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Maaŋ muuŋgiap, Fhe Bakɨme kamthooŋ guma Aisaia suaŋgi kameŋ guigira mba tegi. Aisaia khaŋ suaŋgi, “Guma Bakɨme, the nza buni khothɨgɨrie? The Guma Bakɨme garim, ana won ŋkasŋka bakɨme ndi khɨvigi?” ");
INSERT INTO geb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mbe ne nzuav Zisas khothɨgɨrga tuktɨgi fhuvara. Mba bigɨna nɨɨeŋra Aisaia harigi buneŋ kherav khaŋ suaŋgi, ");
INSERT INTO geb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Fhe Bakɨme mbe rɨmgi ga muuŋgi, mbe bigɨn the gangip, ana kaŋgirga tuktɨgi fhu. Ana vhɨra mbe muuŋgim, mbe pani havhargi. Ana maaŋ mben muuŋgirga, mbe bigɨn the gangip, mbe ndɨkndɨgi mba buna nɨɨŋge kaŋgirga fhu. Maaŋ muuŋgirga, mbe ne kaŋgip, ndavi dorgɨp, taagi na han zɨrim, gu mben muuŋgirim, mbe taagi nzerarga fhu.” ");
INSERT INTO geb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia Zisasan zɨ bakɨme gum ŋkasŋka bakɨme gangiap, mba kamen Zisasra suaŋgi. ");
INSERT INTO geb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Gumgir pani vhɨrve, mbe Zisas khothɨgi. Mbe Fherasin rivgiap, mbe ana khothɨgi ndɨkndɨk, mbe ana ndi hiiŋ phɨgɨ thagi. Mbe khuen rivgi, mbe Fherasiŋ mbe thɨvarga, mbe Zudaiŋ phorgɨp rotur muuŋgirga fhu. ");
INSERT INTO geb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Mbe guigira gumgi gu mbigi mbe zɨri ndiv vun kuamkuarga ne vuzvugi. Mbe Fhe Bakɨme mbe zɨri ndi vun kuamkarga ne vuzvugi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Zisas kama havharar khaŋ nzuai, “Guma na khothɨgi, ana nara khothɨgi fhuvara. Ana na sarigi gu zɨgi Ndia, ana vhɨra ana khothɨgi. ");
INSERT INTO geb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Guma na gari, ana vhɨra na sarigi gu zɨgi Ndia, ana vhɨra ana gari. ");
INSERT INTO geb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Gu vhava ŋaara fara muuŋgiap kha nuianan zergi. Maaŋ muuŋgip na khothɨgi gumgi, mbe za gɨngɨnan kɨrga fhu. ");
INSERT INTO geb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Maaŋ muuŋgip, guma na buni mbararav nta zɨn ŋgɨrga fhu, gu ana suaŋv suaŋgirga fhu. Gu kha nuianan ki gumgi gu mbigi muuŋgi tɨvi ga suaŋv mbe suanga ŋaarar muun zav zergi fhuvara. Zakɨra fhuvara! Gu taagi mbe ndir zav zergi. ");
INSERT INTO geb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Guma maaŋ muuŋgip kɨr na segɨp na buni ndi fhu, mba guma anan tɨvi ga suaŋv ana suanga buni ki. Gu kha bun nzuai bunira, ntara zumgum kha nuiana gu bigi vhɨzi tugen, mba bunira ana suaŋv suaŋgirga. ");
INSERT INTO geb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Gu wo ndɨkndɨgara kha buni nzuai fhuvara. Zakɨra fhuvara! Na sarigi gu zɨgi Ndiara, ana nduara gu bun suanga buni, ana zam ntan na nzuaim, gu nta bun nzuai. ");
INSERT INTO geb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Gu kaŋgi, Dara muun zav nzuai buni, nta zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndi ndɨɨi. Maaŋ muuŋgiap, gu nzuai buni, gu Dara nzuai bunira zɨn vov mba buni bun nzuai.” ");
INSERT INTO geb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasova tuga bakɨme gurmaŋgip hɨrga, Zisas kaŋgi, ana kha nuiana thav, taagip won Ndia han naanga tuk han mbarigi. Ana gumgi gu mbigi kha nuianan ki, ana guigira wo ndavar mbe nɨɨŋgi. Ana guigira wo ndavar mbe nɨɨŋgiap, kavkav ntige rɨmɨn za mbui. ");
INSERT INTO geb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Mbe mba ŋkotuguraagen, mbe piigiap mba pav kim, Satan kha ndɨkndɨgar Saimon Iskariot kama Zudas ga nɨɨŋgi, ana Zisas ndim, ana pana gumgi farve khɨngirga. ");
INSERT INTO geb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Zisas khueŋ kaŋgi, Dara za mba bigir ana farvera khɨngi. Ana vhɨra khueŋ kaŋgi, ana Fhe Bakɨme han kegap zergap, ana vhɨra taagip Fhe Bakɨme han ndarga. ");
INSERT INTO geb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Maaŋ muuŋgiap, Zisas mba thav khavgiap, won fhava shaara mpeeŋ zorgiap, phara thɨgi shaa ndiga wo vhaa tɨgi. ");
INSERT INTO geb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ana anan wo vhaa tɨgap, mbɨ ndiav, thuuŋ mbe tɨgap, mbara hɨgap, wo phorga rui gumgi ŋkari ruav, mba won vhaa tɨgi phara thɨgi shaar mben ŋkari mbɨ thɨgi. ");
INSERT INTO geb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ana maaŋ mbe mbua zav Saimon Pita han zim, Pita ana nzarigi, “Guma Bakɨme, ndu nan ŋkari ruar za mbuire?” ");
INSERT INTO geb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Zisas ana buneŋ ŋgarkarav khaŋ nzuai, “Gu khar mbui bigeŋ, ndu ntige ne kaŋgi fhuvara. Ndu zumgum ne kaŋgirga.” ");
INSERT INTO geb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita mbara khaŋ ana nzuai, “Ndu na ŋkari rua thari. Ndu na ŋkari ruagirga tuktɨgi fhuvara. Zakɨra fhuvara!” Zisas ana ŋgarkarav khaŋ nzuai, “Gu maaŋ muuŋgip ndun ŋkari ruagirga fhu, ndu na phorgɨ kegɨrga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimon Pita khaŋ ana nzuai, “Guma Bakɨme, maaŋ muuŋgip, ndu nan ŋkarira rua thari. Ndu vhɨra nan harani gu pana phorgɨ ruagiri.” ");
INSERT INTO geb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Zisas mbara khaŋ ana nzuai, “Guma ruagi, ana wom thaŋ suaŋv ruarie? Ana won ŋkarira ruagirga, ana za ŋgarigi. Nde za ruagiap, ŋgarav ki. Gu za nde nzuai fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Zisas wo ndim, won pana gumgi farve ga surga guma, ana ana kaŋgiap, ana maaŋ muuŋgiap mba kameŋ nzuai, “Nde za ŋgarav ki fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Zisas mben ŋkari ruagia thugap, wom wo fhava shaa mpeeŋ sharav, vo perigi. Ana perav kha nzambarar mbe muuŋgi, “Nde gu kha nde muuŋgi bigeŋ, nde ne nɨɨeŋ kaŋgi fhuv thi? ");
INSERT INTO geb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nde kha kakaman na mbui, ‘Ndɨkndɨgi Vhuuin Nza Khɨvi Guman Rum’ gum ‘Guma Bakɨme.’ Nde nzerara mba suambarar na mbui. Gu ana ma. ");
INSERT INTO geb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Gu nde Guma Bakɨme gum, gu Ndɨkndɨgi Vhuuin Nde Khɨvi Guman Rum ma. Gu nden ŋkari ruagi. Nde vhɨra, nde wari wo ŋkari ruari. ");
INSERT INTO geb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Gu tɨvar nde khɨvigi, nde vhɨra gu ntige nde muuŋgi tɨvara, nde mba tɨvara muuŋri. ");
INSERT INTO geb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Gu guigira khar nde nzuai, ŋaara guma, ana wo gari guma bakɨme kambarigi fhuvara. Buneŋ ndia rui guma, mba ŋaarar muun zav ana sarigi guma, ana ana kharav vun ki fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nde ntigem gu mba ndɨkndɨga muuŋgiap muuŋgi bigeŋ, nde ntigem ne nɨɨeŋ kaŋgi. Nde maaŋ muuŋgip tuituigip ne zɨn ŋgɨrga, Fhe Bakɨme tɨvar vhuun nden muunga. ");
INSERT INTO geb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Gu za nde nzuai fhuvara. Gu won mbuiav farasegi gumgi, gu mbe kaŋgi. Gu mbe kaŋgiap, gu vhɨra khueŋ kaŋgi, Fhe Bakɨme buni vhuuiŋ ki gap suaŋgi kameŋ ne guigira hɨgɨrga. Mba kameŋ khaŋ nzuai, ‘Na phorgap viktuma pi guma, ana panan na kegirga’ ");
INSERT INTO geb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mba bigeŋ hɨgi fhuvara, gu ntige ne bun nde nzuai. Maaŋ muuŋgip, mba bigeŋ zumgum hɨgɨrga, nde na khothɨgɨrga. Gu mba zazera mbara muuŋgiap ki guma ma. ");
INSERT INTO geb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Gu guigira buna guaren nde nzuai. Gu sarigi ŋaara guma, ana ndigap tɨvar vhuun ana mbui guma, ana vhɨra na ndigap tɨvar vhuun na mbui. Guma na ndigi, ana vhɨra na sarigi gu zɨgi Fhe Bakɨme, ana ana ndigi.” ");
INSERT INTO geb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Zisas nen mbe suaŋgiap, ana ndav guigira anan simgi. Ana thav, khuen mbe nzuai, “Gu guigira khar nde nzuai, nde thera na ndiv panan na kegi gumgi farve khɨngirga.” ");
INSERT INTO geb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ana maaŋ nzuaim, ana phorga rui gumgi, mbe bevbevira phokphoga wari khoo gari. Mbe guigira ŋanŋangiap, mbe kaŋgi fhu, ana the nzuai. ");
INSERT INTO geb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ana mba phorga rui gumgi rɨgar, ana guigira wo ndava nɨɨŋgi guma, ana anan haa perigi. ");
INSERT INTO geb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Pita panara ana nzuai, “Ndu anan nzara, ana the nzuai.” ");
INSERT INTO geb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ana maaŋ ana nzuaim, ana won panan Zisas fheeŋ phorgap, mbarara kha nzambarar ana muuŋgi, “Guma Bakɨme, ndu the nzuai?” ");
INSERT INTO geb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Zisas ana ŋgarkarav khaŋ nzuai, “Gu viktum thueŋ ndigɨp, mbɨn vhera rugɨp, guma then nɨɨnga. Mba gumara, gu ana nzuai.” Ana ne suaŋgiap, mbara viktuma mueŋ ndigap, mbɨn vhera rugap, nen Saimon Iskariot kama Zudas ga ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Zudas mba viktuma ndigim, Satan zav ana ndava vhen vergi. Zisas mbara khaŋ ana nzuai, “Ndu mba muun za mbui bigeŋ, ndu vhemkora nen muuŋri.” ");
INSERT INTO geb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mba ana phorga piigiap pi gumgi, mbe za Zisas Zudas ga nzuai kameŋ mbararagi. Mbe mba kameŋ mbararagiap, mbe nen nɨɨeŋ kaŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Zudas, ana mben ŋkɨɨa ki kovsɨga gari. Maaŋ muuŋgiap, mbe mbari kha ndɨkndɨga mbui, “Ana rotu bakɨmen muunga tuga bakɨme suaŋv bigi thari ga vhezɨ zav ana nzuai thi? Ana bigi tharir bigi sosuagi gumgir nɨɨn zav ana nzuai thi?” ");
INSERT INTO geb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Zudas mba viktuma ndigap, vhemkora khavgiap kɨrar hɨgim, maaŋ gɨngi. ");
INSERT INTO geb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Zudas kɨrar hɨgim, Zisas khaŋ nzuai, “Fhe Bakɨme Guma Guar, ana wo zɨ bakɨme ndi. Fhe Bakɨme vhɨra Fhe Bakɨme Guma Guarar panan zɨ bakɨme ndi. ");
INSERT INTO geb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Maaŋ muuŋgip, Fhe Bakɨme ana panan zɨ bakɨme ndiv, ana vhɨra zɨ bakɨmen Fhe Bakɨmen Guma Guarara nɨɨnga. Ana vhɨra vhemkora mba tɨvar muuŋgirga. ");
INSERT INTO geb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nde nan tari, gu tuga bisanera, nde phorgɨ kegɨrga. Nde vhɨra na suaŋv ganɨnga. Gu Zudaiŋ gumgir pani ga suaŋgi, gu ntige mba kameŋra nde nzuai. ‘Nde gu vui ŋgun ŋgegɨrga tuktɨgi fhu.’ ");
INSERT INTO geb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Gu ntigem tɨvir ŋkaar nde ndɨɨv, khaŋ nde nzuai, nde bevbevira, nde guigira wari won ndavir warir nɨɨŋri. Gu guigira won ndavar nde nɨɨŋgi. Nde vhɨra mba tɨvara, nde bevbevira, nde guigira wari won ndavir warir nɨɨŋri. ");
INSERT INTO geb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nde bevbevira, nde maaŋ muuŋgip nan gumgi gu mbigi, nde wari won ndavir mbe nɨɨnga, mbe za nde ganɨv kaŋgirga, nde khuen mbe khɨvi, nde na phorga ruigi gumgi guari ma.” ");
INSERT INTO geb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita kha nzambarar Zisas ga muuŋgi, “Guma Bakɨme, ndu maaŋ ŋgɨrie?” Zisas ana ŋgarkarav khaŋ nzuai, “Gu vui ŋgu, ndu ntigem na zɨn mba ŋgun ŋgɨgɨrga tuktɨgi fhuvara. Ndu zumgum na zɨn zɨrga.” ");
INSERT INTO geb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita mbara ana nzarigi, “Guma Bakɨme, gu ntige ram muuŋgiap ndu zɨn ŋgɨrga fhu? Gu won tuma fekhɨngip ndun kurarga.” ");
INSERT INTO geb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Zisas ana ŋgarkarav khaŋ nzuai, “Ndu ndɨkndɨgi, ndu guigira won tuma fekhɨngip nan kurarie? Gu guigira ndu nzuai, tuar ntigar furga, ndu suambara mpuani khegenen muuŋv, na ndi zaahɨ khaŋ suanga, ‘Gu ana kaŋgi fhu.’ ” ");
INSERT INTO geb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Zisas wom khaŋ mbe nzuai, “Nde ndavi simɨv ndɨkndɨgi vhɨrver muuŋ thari. Nde Fhe Bakɨme khothɨgɨri, nde vhɨra na khothɨgɨri. ");
INSERT INTO geb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Na Ndia phenan, ŋani vhɨrve ki. Gu nde nzuav ŋani bevahɨr zav ndai. Ana phen maaŋ muuŋgi fhu kake, gu kha kamen nde suangeŋ ntɨɨŋ. ");
INSERT INTO geb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Gu maaŋ muuŋgip ŋgɨv, nde suaŋv ŋani bevahegɨp, gu taagi zirɨv nde ndigi ndarim, nde na phorgɨ kɨrga. Gu mba ki ŋgu, nde vhɨra na phorgɨp mba ŋgura kɨrga. ");
INSERT INTO geb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nde gu kɨr za vuin ŋgu, nde mba ŋgun vui tuav, nde ana kaŋgi.” ");
INSERT INTO geb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas mbaram khaŋ ana nzuai, “Guma Bakɨme, ndu maaŋ vui, nza ndu vui ŋaneŋ kaŋgi fhu. Nza ram muuŋgip ndu vui tuav kaŋgire?” ");
INSERT INTO geb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Zisas mbaram khaŋ ana nzuai, “Gu nduara mba tuav ma. Gu vhɨra nduara buni guarir nɨɨŋge ma. Gu vhɨra nduara zazera mbara muuŋgip ki bɨɨŋbɨɨŋ nɨɨŋge ma. Guma the Dara han ŋgɨr saŋv, ana harigi tuav then, ana han ŋgɨgɨrga tuktɨgi fhu. Zakɨra fhuvara! Gu nduara mba tuav ma. ");
INSERT INTO geb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nde maaŋ muuŋgip na kaŋgi, nde ntige vhɨra nan Ndia kaŋgirga. Nde ntige ana kaŋgi. Nde vhɨra ana gangi.” ");
INSERT INTO geb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Firip mbaram khaŋ Zisas ga nzuai, “Guma Bakɨme, ndu Darar nza khɨvarga, ne tugara.” ");
INSERT INTO geb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Zisas mbara khaŋ anan nzuai, “Firip, gu tuga mpeeŋra nde phorga kegim, ndu ntigar na kaŋrie? Guma na gari, ana vhɨra nan Ndia gari. Ndu ram muuŋgiap khaŋ nzuai, ‘Ndu Darar nza khɨva’? ");
INSERT INTO geb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ee, ndu gu Darar kim, Dara nan ki, ndu ne khothɨgi fhuv thi? Gu nde nzuai buni, gu wo ndɨkndɨgara nde nzuai fhuvara. Zakɨra fhuvara! Dara nan kav, ana won ŋaari ga mbui. ");
INSERT INTO geb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nde kha buneŋ khothɨgɨri. Gu Darar kim, Dara nan ki. Nde gu suaŋgi kameŋ khothɨgi fhu, nde gu muuŋgi mirikori ga ndɨkndɨgɨri, nde nta nzuav na khothɨgɨri. ");
INSERT INTO geb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Gu guigira nde nzuai, guma na khothɨgɨrga, ana vhɨra gu mbui mirikorir muunga. Ana vhɨra muunga mirikori, gu muuŋgi mirikori kambarav, ana mirikori bakɨvir muunga. Ne khaŋ muuŋgi, gu Darar han ndai. ");
INSERT INTO geb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nde nan zɨn panan nzanga bigi, gu za ntan muunga. Maaŋ muunga, Dara won kama zɨn panan zɨ bakɨme ndirga. ");
INSERT INTO geb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nde maaŋ muuŋgip nan zɨn panan nzanga bigɨn the, gu ana muuŋgirga.” ");
INSERT INTO geb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Zisas wom khaŋ mbe nzuai, “Nde guigira wari wo ndavir na nɨɨŋgi, nde tuituigip na tɨvi zɨn ŋgɨrga. ");
INSERT INTO geb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Gu Darar nzanga, ana harigi Kurkurer nden nɨɨnga, ana ŋkasŋka nden nɨɨnga. Ana vhɨra zazera nde phorgɨp mbara muuŋgip kɨrga. ");
INSERT INTO geb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mba Kurkure, ana buna guaren gum Fhe Bakɨme tɨvir guarir nza khɨvi Ŋina ma. Kha nuianan tɨvi zɨn vui gumgi ana ndigirga tuktɨgi fhuvara. Mbe ana gangi fhu, mbe vhɨra ana kaŋgi fhu. Nde, nde ana kaŋgi. Ana nde phorga kegi, ana nden vherir kɨrga. ");
INSERT INTO geb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Gu nde thav fhura nde ganɨrim, nde ndegi gu ndegmbori ki fhu tari farar muuŋgip kegɨrga tuktɨgi fhuvara. Zakɨra fhuvara! Gu nden han zɨrga. ");
INSERT INTO geb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tuga bisanera kha nuianan ki gumgi gu mbigi wom na gangirga tuktɨgi fhuvara. Nde na ganɨnga. Gu rimgip, taagi khavgip, zazera mbara muuŋgip kɨrga. Maaŋ muuŋgiap, nde vhɨra zazera mbara muuŋgip kɨrga. ");
INSERT INTO geb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mba raar nde kaŋgirga, gu won Ndiar vhen kim, nde nan kim, gu vhɨra nden ki. ");
INSERT INTO geb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Guma nan tɨvi ndigap, tuituigiap nta zɨn vui, mba guma, ana guigira won ndavra na nɨɨŋgi. Guma wo ndavar na nɨɨŋgi, nan Ndia won ndavar ana nɨɨŋgi. Gu vhɨra won ndavar mba guman nɨɨŋgip, gu nduara won ana khɨvarga.” ");
INSERT INTO geb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Zisas maaŋ nzuaim, mba harigi guma, ana zɨ vhɨra Zudas, ana Zudas Iskariot fhuvara, mba Zudas, ana kha nzambarar Zisas ga muuŋgi, “Guma Bakɨme, ndu ram muuŋgiap won nza khɨvav, ndu won kha nuianan ki gumgi gu mbigi khɨvɨrgeŋ thagi?” ");
INSERT INTO geb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Zisas ana buneŋ ŋgarkarav khaŋ ana nzuai, “Guma, ana guigira won ndavara na nɨɨŋgi, ana tuituigip na buni zɨn ŋgɨrga. Nan Ndia won ndavar mba guman nɨɨnga. Ŋka vhɨra mba guman han zɨv ana phorgɨ kɨrga. ");
INSERT INTO geb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Guma guigira won ndavar na nɨɨŋgi fhu, ana tuituigip na buni zɨn ŋgɨgɨrga tuktɨgi fhu. Nde khar mbararagi buni, nta gu nduara nzuai buni fhuvara. Zakɨra fhuvara! Nta Dara buni ma. Ana na sarigim, gu zergi. ");
INSERT INTO geb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Gu nde phorga kav, gu mba bigir nde nzuai. ");
INSERT INTO geb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mba Kurkure, ana Fhe Bakɨmen Ŋina Ŋaar ma. Dara na zɨn panan ana sararim, ana zirɨrga. Ana mba bigir za nde khɨvɨrga. Ana vhɨra nde ndɨkndɨgi khavɨrga, nde taagip gu mba nde suaŋgi buni, nde nta ndɨkndɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Gu nde thamtha za mbuav, gu ndava mɨɨtɨgar nde ndɨɨi, ana nde phorgɨ kɨri. Gu won ndava mɨɨtɨk ma, gu ana nde ndɨɨi. Gu nde ndɨɨi ndava mɨɨtɨk, ana kha nuianan gumgi gu mbigi ndɨɨi ndava mɨɨtɨga fara muuŋgi fhuvara. Maaŋ muuŋgiap, nde ndɨkndɨgi vhɨrver muuŋv, ndavi simɨv, rɨvɨ thari. ");
INSERT INTO geb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Gu fhum nde thav ŋgɨr zav nde suaŋgi. ‘Gu taagi nde han zirga.’ Nde maaŋ muuŋgip guigira wari won ndavir nan nɨɨŋgirim, mba tɨv nden muuŋgirim, nde ndikndigɨrga. Ne khaŋ muuŋgi, gu Darar han ndai, ana guigira na kambarigi. ");
INSERT INTO geb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mba bigeŋ hɨgi fhuvara, gu fhumra ne bun nde suaŋgi. Maaŋ muuŋgip, mba bigeŋ hɨgɨrim, nde ne khothɨgɨri. ");
INSERT INTO geb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Gu nde phorgɨp buni vhɨrve suanga fhuvara. Ne khaŋ muuŋgi, kha nuiana gari guman pan ntige mbur zi. Ana bigɨn then nan muunga ŋkasŋka ki fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Gu khueŋ vuzvugi, kha nuianan ki gumgi gu mbigi khueŋ kaŋgirga, gu guigira won ndavar won Ndia ga nɨɨŋgi. Gu maaŋ muuŋgiap, na Ndia muun za na nzuai bigi, gu za nta mbui. Aria, nde khavgip, nza ŋgɨrga.” ");
INSERT INTO geb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Zisas wom khaŋ mbe nzuai, “Gu nduara guigira wain karɨga fara muuŋgi. Nan Ndia mba wain mɨna vuavi ma. ");
INSERT INTO geb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nan ŋgagi vhɨgi mbai fhu, Dara nta kara sui. Nan ŋgagi vhɨgi mbai, Dara zazera nta khɨrav, nta fari mbatɨgi kora suim, nta ŋgarigi. Ana maaŋ ntan muunga, nta kɨvgip vhɨgi maanga. ");
INSERT INTO geb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nde za ŋgarigi. Gu khar nde nzuai buni, nta nde muuŋgim, nde ŋgarigi. ");
INSERT INTO geb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nde na phorgɨrim, gu nde phorgɨrga. Wain karɨgar ŋgaa, ana mba karɨga thɨgi fhu, ana vhɨgi maaŋgirga tuktɨgi fhuvara. Mba tɨvara, nde na phorgɨrga fhu, nde vhɨgi mbararga fhu. ");
INSERT INTO geb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Gu nduara, gu wain karɨgage ma. Nde, nde nan ŋgagi ma. Guma, ana na phorgim, gu ana phorgi, mba guma ana kɨvgia vhɨgi mbai. Gu nden kurkurarga fhu, nde bigɨn then muuŋgirga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Maaŋ muuŋgip, guma the na phorgɨrga fhu, mbe karɨga ŋgaa fuasui farar muuŋgip ana fekhɨngirim, ana shɨɨŋgirga. Mba khesharigi karɨgi ŋgagi, mbe nta ndi phoga vhuigap, kegap, mbe nta fuav vhava suegim, nta shi. ");
INSERT INTO geb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Nde na phorgɨ havhargirga, na buni nden kɨrga, nde wari wo vuzvugar nzai bigɨn, Fhe Bakɨme mba bigɨn nde nɨɨnga. ");
INSERT INTO geb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nde kɨvgip vhɨgi maaŋv, na phorga rui gumgi kɨri. Nde mba tɨvar muuŋrim, na Ndia zɨ bakɨme ndirga. ");
INSERT INTO geb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Dara guigira won ndavar na nɨɨŋgi, gu mba tɨvara, gu guigira won ndavar nde nɨɨŋgi. Maaŋ muuŋgiap, nde zazera gu guigira won ndavar nde nɨɨŋgi tɨvar vhen kɨri. ");
INSERT INTO geb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Gu tuituigiap won Ndiar tɨvi gum ana buni zɨn vov, gu maaŋ muuŋgiap ana vuzvuga vhen ki tɨvar ki. Nde maaŋ muuŋgip tuituigip nan tɨvi gum nan buni zɨn ŋgɨrga, nde nan vuzvuga vhen ki tɨvar kɨrga. ");
INSERT INTO geb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Gu khueŋ vuzvugi, gu ndikndigi ndikndik nden kɨv, mba ndikndik guigira nde ndavi vheri givarga. Maaŋ muuŋgiap, gu khaŋ kamen nde nzuai. ");
INSERT INTO geb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nan tɨv khaŋ muuŋgi. Nde bevbevira, nde gu mbui tɨvar muuŋv, nde guigira wari won ndavir warir nɨɨŋri. ");
INSERT INTO geb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Maaŋ muuŋgip, guma the guigira won ndavar guigira won kɨvntogir nɨɨŋgip, mben kurkurar saŋv won tuma fekhɨngirga, mba tɨv, ana guigira fhura won ndavar ndi ndɨɨi tɨvi ana za nta kambarigi. ");
INSERT INTO geb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nde maaŋ muuŋgip gu nde suaŋgi tɨvar muunga, nde nan kɨvntogi guari kɨrga. ");
INSERT INTO geb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ŋaara guma, ana wo guma bakɨme mbui bigi, ana nta kaŋgi fhu. Gu maaŋ muuŋgi tɨvar nde mbuav, won ŋaari gumgir nden kaai fhuvara. Zakɨra fhuvara! Gu won Ndia han mbararagi bigi, gu za nta bun nde suaŋgi. Gu maaŋ muuŋgiap kha kakaman nde mbui, nde nan kɨvntogi ma. ");
INSERT INTO geb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Nde wari phorgɨ kɨr zav na farasarigi fhuvara. Zakɨra fhuvara! Gu nde farasegi, nde na ntɨɨri kɨrga. Gu ŋaarar nde nɨɨŋgi. Nde ŋgɨp mba vhɨrve tɨrim, nden mba zazera kɨri. Nde maaŋ muuŋgip, nde bigɨn then warir nɨɨn saŋv na zɨn panan Darar nzanga, ana mba bigɨnan nden nɨɨnga. ");
INSERT INTO geb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Gu kha tɨvar nde nɨɨŋgi, nde bevbevira, guigira wari won ndavir wari nɨɨŋri.” ");
INSERT INTO geb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Zisas wom khaŋ mbe nzuai, “Maaŋ muuŋgip, kha nuiana gumgi panan nde kegɨrga, nde khueŋ ndɨkndɨk ŋanɨ thari. Nde kaŋgi, mbe fharav mbara muuŋgiap panan na kegap kegi. ");
INSERT INTO geb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nde maaŋ muuŋgip, kha nuiana gumgira farar muuŋgip kɨrga, kha nuiana ntɨɨri nde vuzvugirga, nde mbe ntɨɨri ma. Nde maaŋ muuŋgi fhuvara. Nde kha nuiana ntɨɨri fhuvara. Zakɨra fhuvara! Gu nden farasegi, nde kha nuianan tɨvi thagi. Maaŋ muuŋgiap, kha nuiana gumgi gu mbigi panan nde kegi. ");
INSERT INTO geb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nde tuituigip gu mba nde suaŋgi kameŋ ndɨkndɨk suirari. Ŋaara guma, ana wo gari guma bakɨme kharigi fhuvara. Mbe tɨva mbatɨgar na muuŋgi, mbe vhɨra tɨva mbatɨgar nden muunga. Mbe na buni zɨn vui, mbe vhɨra nde buni zɨn ŋgɨrga. ");
INSERT INTO geb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mba na sarigi gu zergi Ndia, mbe ana kaŋgi fhuvara. Maaŋ muuŋgiap, mbe za mba khesharigi tɨvi mbatɨgir nden muunga. Ne khaŋ muuŋgi, mbe kaŋgi nde na ntɨɨri ma. ");
INSERT INTO geb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Gu maaŋ muuŋgiap zerav, Fhe Bakɨmen buni vhuuin mbe suaŋ tha kake, mbe wari wo muuŋgi tɨvi mbatɨgi ga nzuav simtɨk kae ntɨɨŋ. Mbe ntigem, mbe wari wo muuŋgi tɨvi mbatɨgi vhagirga tuav ki fhu. ");
INSERT INTO geb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Guma, ana panan na kegi, ana vhɨra panan na Ndia ga kegi. ");
INSERT INTO geb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Gu maaŋ muuŋgip mbe rɨgar kɨv, guma the fhum khaŋ muuŋgi ŋaari bakɨvi ga muuŋgi fhu. Gu mba ŋaari bakɨvi, gu nta muuŋgi fhu, mbe maaŋ muuŋgip wari wo muuŋgi tɨvi mbatɨgi ga suaŋv simtɨk kɨrga fhu. Mbe gu muuŋgi ŋaari bakɨvi, mbe nta gangi. Mbe nta gangiap, mbe panan na kav, mbe vhɨra panan na Ndia ga kegi. ");
INSERT INTO geb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mbe mba muuŋgi tɨv, ana Moses suaŋgi tɨvi suaŋgi kama mueŋ tugɨratɨgi. Mba kameŋ khaŋ nzuai, ‘Mba gumgi, mbe fhura panan na kegi.’ ");
INSERT INTO geb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nden Kurkurarga Ŋina Ŋaar, ana nan Ndiar han ki. Gu ana sararim, ana nden han zirɨrga. Ana Fhe Bakɨmen tɨvi guarir nza khɨvi Ŋina Ŋaar ma. Ana Ndiar han kega zeri. Ana zirɨv, tuituigip nan ŋaari gum nan tɨvi bun nde suanga. ");
INSERT INTO geb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nde vhɨra na bun suaŋri. Ne khaŋ muuŋgi, nde na phorga kim, gu fhara won ŋaara khavgim, nde na phorga kavra zav ntige kha tugen hɨgi. ");
INSERT INTO geb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Gu khueŋ vuzvugi, nde na khothɨgi ndɨkndɨk nde ana kuemkuegɨrga fhu. Gu maaŋ muuŋgiap, gu kha kamen nde nzuai. ");
INSERT INTO geb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mbe wari phorgɨp rotur muungen nde thɨvarga. Mbe zumgum tuga the hɨgɨrga, mbe nde shogɨrim, nde vhɨzɨrga, mbe khueŋ ndɨkndɨgɨrga, mbe Fhe Bakɨmen kurkurav ŋaara vhuuaŋ mbui. ");
INSERT INTO geb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mbe Dara kaŋgi fhu, mbe vhɨra na kaŋgi fhu. Maaŋ muuŋgiap, mbe mba khesharigi tɨvir muunga. ");
INSERT INTO geb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Gu ntige mba hɨrga bigi, gu nta bun nde suaŋgi. Maaŋ muuŋgip, zumgum mba gumgi mba tɨvar nden muunga, nde gu suaŋgi buni, nde nta ndɨkndɨgɨri.” Zisas wom khaŋ mbe nzuai, “Gu fhum nduara nde phorga kav, gu maaŋ muuŋgiap mba bigi bun nde suangeŋ thagi. ");
INSERT INTO geb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Gu ntigem Dara han ndai, ana na sarigi, gu zergi. Nde the kha nzambareŋ na mbui fhu. ‘Ndu maaŋ vui?’ ");
INSERT INTO geb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Gu kha bunen nde suaŋgim, nde maaŋ muuŋgiap guigira ndavi simgi. ");
INSERT INTO geb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Gu guigira nde nzuai, gu nde tha vui ne, ne gu nden kurkurar zav maaŋ mbui. Gu maaŋ muuŋgip ŋgɨgɨrga fhu, Kurkurer nden nɨɨnga Ŋina Ŋaar, ana nden han zirgɨrga tuktɨgi fhuvara. Gu maaŋ muuŋgip ŋgɨgɨrga, gu ana sararim, ana zirɨrga. ");
INSERT INTO geb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ana zirɨv, mbe khɨvɨrga, mbe tɨvi mbatɨgi ga ndɨkndɨgi ndɨkndɨk, ana ram muuŋgi khesharigi. Mbe tɨvir vhuuiaŋ ndɨkndɨgi ndɨkndɨk, ana ram muuŋgi khesharigi. Mbe Fhe Bakɨme kha gumgi gu mbigi ga suaŋv suangeŋ ndɨkndɨgi ndɨkndɨk, ana ram muuŋgi khesharigi. Mbe nta nɨɨŋge kaŋgi fhu, mben ndɨkndɨgi za pham vegi. ");
INSERT INTO geb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tɨvi mbatɨgi nta nɨɨŋge khaŋ muuŋgi, mbe na khothɨgi fhu. ");
INSERT INTO geb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tɨvir vhuuiŋ nɨɨŋge khaŋ muuŋgi, gu Darar han vui, nde wom na gangirga fhu. ");
INSERT INTO geb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Fhe Bakɨme kha nuianan ki gumgi gu mbigi, ana mbe muuŋgi tɨvi mbatɨgi ga suaŋv mbe suanga kama nɨɨeŋ, ne khaŋ muuŋgi, kha nuianan gari guman pan, ana fhɨrge rɨgi. ");
INSERT INTO geb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Gu nde suangeŋ vuzvugi buni vhɨrve khar ki. Nde ntigem mba buni ndigɨrga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Zumgum, Fhe Bakɨme tɨvi guarir nza khɨvi Ŋina Ŋaar, ana zirɨv, nde ndɨkndɨgi ndiv thɨgar maanga, nde za mba buni guari kaŋgirga. Ana wo ndɨkndɨgira nden nɨɨnga fhu. Zakɨra fhuvara! Ana mba mbararagi buni, ana ntara nde suanga. Ana vhɨra zumgum hɨrga bigi bun nde suanga. ");
INSERT INTO geb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ana na buni ndiv nde suanga, ana mba tɨvar muuŋv, na zɨ bakɨme gum nan ŋkasŋka bakɨme ndiv, hiiŋ phɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Na Dara bigi, nta za na bigi ma. Maaŋ muuŋgiap, gu nzuai, ana na buni ndiv nde suanga.” ");
INSERT INTO geb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Zisas wom khaŋ mbe nzuai, “Tuga bisanera nde wom na gangirga fhu. Nde zumgum tuga bisanera kegɨp, nde taagi na ganɨnga.” ");
INSERT INTO geb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ana phorga rui gumgi mbari, mbe nduarira wari ga nzuav khaŋ nzuai, “Ana nza nzuai buna nɨɨeŋ ram nzuai? Ana ne nzuav khaŋ nzuai, ‘Tuga bisanera nde na gangirga fhu. Nde zumgum tuga bisanera, nde wom na ganɨnga.’ Ana vhɨra khaŋ nzuai, ‘Mba bigɨna nɨɨeŋ khaŋ muuŋgi, gu Darar han ndai.’ ” ");
INSERT INTO geb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Mbe vhɨra khaŋ nzuai, “Ana mba nzuai ‘tuga bisaneŋ’ ne ram muuŋgi? Nza ana nzuai buna nɨɨeŋ kaŋgi fhu.” ");
INSERT INTO geb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Zisas kaŋgi, mbe anan nzan za mbui. Maaŋ muuŋgiap, ana khaŋ mbe nzuai, “Nde gu kha suaŋgi buna nɨɨeŋ ga nzuav, tamtam warir nzai thi? Gu khaŋ nzuai, ‘Tuga bisanera nde na gangirga fhu. Zumgum tuga bisanera nde wom na gangirga.’ ");
INSERT INTO geb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Gu guigira nde nzuai, nde guigira khɨrɨv nziv, nde guigira kora mbui nzir muuŋgirga. Kha nuiana gumgi gu mbigi, mbe ndikndigɨrga. Nde ndavi simgirga. Nden ndavir simtɨgi, nta wom dorgɨrga, nde guigira ndikndigirga. ");
INSERT INTO geb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tara ruar za mbui mbik, ana kaŋgi, ana tara ruar za mbui tuk hɨgi, ana ndav simgi. Ana tara ruagiap, ana wom mba zaa ga ndɨkndɨgi fhuvara. Zakɨra fhuvara! Ana mba tara ruagim, ana kha nuianan hɨgi, ana mba tarar ndikndigi. ");
INSERT INTO geb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mba tɨvara nde ntigem ndavi simgi. Gu zumgum taagi nde ganɨnga, nde ndavi vheri guigira ndikndigɨrga. Guma the nde tɨn mba ndikndiga ndigirga, ana nde thav sarga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nde mba tugen, nde bigɨn the suaŋv nan nzararga tuktɨgi fhuvara. Gu guigira nde nzuai, nde na zɨn panan bigɨn the suaŋv Darar nzanga, ana mba bigɨnan nden nɨɨnga. ");
INSERT INTO geb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nde fhum na zɨn panan bigɨn then nzarigi fhuvara. Nde ntige nzanga, nde ndirga, mba ndikndik guigira nden ndavi veri givarga.” ");
INSERT INTO geb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Zisas mbaram khaŋ mbe nzuai, “Gu ntige kha buni, gu nta vhunaa ga sav nde nzuai. Gu zumgum wom vhunaa ga si bunin nde suanga fhu. Gu thugara phɨrgip nde suaŋv, nde bun Dara suanga. ");
INSERT INTO geb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nde mba tugar, nde na zɨn panan Fhe Bakɨme nzanga. Gu khaŋ nde nzuai fhuvara, gu nduara nde suaŋv Dara phorgɨ suaŋrim, ana nden kurkurarga. ");
INSERT INTO geb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Fhuvara, Dara nduara, ana vhɨra won ndavar nde nɨɨŋgi. Ne khaŋ muuŋgi, nde wari won ndavir na nɨɨŋgiap, khueŋ khothɨgi, gu Fhe Bakɨmen han kegap zergi. ");
INSERT INTO geb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Gu fhum Dara han kegap, gu ana thav kha nuianan zergi. Gu ntigem, kha nuiana thav, gu taagiap Darar han nan za mbui.” ");
INSERT INTO geb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ana phorga rui gumgi khaŋ ana nzuai, “Ndu ntigem thugara phɨrgiap nza nzuai. Ndu vhunama sav nza nzuai fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nza ntige kaŋgi, guma ntigar mba bigeŋ suaŋv ndun nzanga, ndu fhumra ana nzanga nzambareŋ ŋgarkararga. Ndu za kha bigi kaŋgi. Nza maaŋ muuŋgiap khueŋ khothɨgi, ndu Fhe Bakɨmen han kegap zergi.” ");
INSERT INTO geb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Zisas mbe ŋgarkarav khaŋ mbe nzuai, “Nde ntige na khothɨgire? ");
INSERT INTO geb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nde mbarara. Tuk ntige han mbarigi, ahaŋ, ana ntige hɨgi. Mbe ntige nde zɨtɨgɨrim, nde rɨv tamtam wari wo ki ŋanin ŋgegɨrga. Nde na thav ŋgegɨrim, gu nduara kegɨrga. Gu za nduara kegɨrga tuktɨgi fhuvara. Ne khaŋ muuŋgi, Dara na phorga ki. ");
INSERT INTO geb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Gu khueŋ vuzvugi, nde na phorgɨrga, nde ndavi mbɨrarga. Gu maaŋ muuŋgiap kha kamen nde nzuai. Nde kha nuianan ki tugen simtɨgi nden hɨrga, nde wari won ndavi havhargip wari kɨri. Gu kha nuianan ŋkasŋka, gu ana kambarigi.” ");
INSERT INTO geb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Zisas wo phorga rui gumgi phorga suaŋgiap, khogap Heven garav khaŋ nzuai, “Dara, tuk ntigem hɨgi, ndu ntigem zɨ bakɨmen won Kaman nɨɨŋri. Ndu maaŋ muunga, ndun Kam zɨ bakɨmen ndun nɨɨnga. ");
INSERT INTO geb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ne khaŋ muuŋgi, ndu zɨ bakɨme gu ŋkasŋkar ana nɨɨŋgi. Ndu vhɨra kha gumgi gu mbigir pan kɨr zav ana farasarigim, ana ndu ana ndɨɨi gumgi, ana za zazera mbara muuŋgiap ki bɨɨŋbɨɨn mbe ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mba zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ khaŋ muuŋgi. Mba zazera mbara muuŋgia ki bɨɨŋbɨɨŋ ndi gumgi, mbe ndu kaŋgi, ndu nduara Fhe Bakɨ guar ma. Mbe vhɨra Zisas Krais kaŋgi, ndu ana sarigim, ana zergi. ");
INSERT INTO geb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Gu ndun ŋaara mbuav, mba ŋaarar panan gu ndu zɨ bakɨme gum ndun ŋkasŋka bakɨmen kha nuiana gumgi gu mbigi khɨvigi. Gu ndu muun zav na nɨɨŋgi ŋaar, gu za ana vhɨzgi. ");
INSERT INTO geb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Dara, kha nuian zumgum hɨgi, gu fhum ndu phorga kav, gu zɨ bakɨme ki. Gu vuzvugi, ndu ntige wo ki ŋanen wom mba zɨ bakɨmen nan nɨɨŋri. ");
INSERT INTO geb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Gu kha nuianan ndu na nɨɨŋgi gumgi, gu ndu zɨ bun mbe suaŋgi. Mbe ndun gumgi ma, ndu mben na nɨɨŋgi. Mbe tuituigiap ndu buni zɨn vui. ");
INSERT INTO geb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Mbe ntigem kaŋgi, ndu na nɨɨŋgi bigi, nta za ndura han kegap zergi. ");
INSERT INTO geb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ndu na suaŋgi buni, gu za ntan mbe suaŋgi. Mbe mba buni ndigap, mbe guigira khueŋ khothɨgi, gu fhum ndu phorga kegap zergi. Mbe vhɨra khueŋ khothɨgi, ndu na sarigim, gu zergi. ");
INSERT INTO geb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Gu mben kurkurar zav ndu phorga nzuai. Gu za kha nuianan ki gumgi gu mbigir kurkurar zav ndu phorga nzuai fhuvara. Gu kha ndu na nɨɨŋgi gumgir kurkurar zav ndu phorga nzuai. Ne khaŋ muuŋgi, mbe ndu ntɨɨri ma. ");
INSERT INTO geb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nan gumgi gu mbigi, mbe zam ndu ntɨɨri ma. Ndun gumgi gu mbigi, mbe za na ntɨɨri ma. Kha gumgi gu mbigi nan gumgi gu mbigi garav, mbe na zɨ bakɨme gangi. ");
INSERT INTO geb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Gu ntigem ndun han ndai, gu wom kha nuianan kɨrga fhu. Mbe kha nuianan kɨrga. Dara, ndu guigira ŋgarigi, guma the ndu fara muuŋgi fhuvara. Ndu wo zɨn ŋkasŋkar panan mbe ganɨri. Ndu mba zɨ bakɨmen na nɨɨŋgi. Maaŋ muuŋgiap, mbe wari tɨgɨp ndava bavira kɨrga. Mbe ŋkara farar muuŋgiri, ŋka wani tɨgap ndava bavira ki. ");
INSERT INTO geb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Gu mben han kav, gu ndu zɨn ŋkasŋkar panan, gu mbe garagagi. Mba zɨ, ana ndu zɨ ma, ndu anan na nɨɨŋgi. Gu gangana vhuuŋra mbe mbuim, mbe the mbarɨgi fhuvara. Mba na tha vui guma, ana nduara mbar rɨgɨrga tuktɨgi. Maaŋ muuŋgirga, ndun buni vhuuiŋ ki gap suaŋgi kameŋ, ne guigira hɨgɨrga. ");
INSERT INTO geb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Gu ntigem ndun han ndai. Gu ntigem kha nuianara kav, gu kha bunin ndu nzuai. Mbe maaŋ muuŋgip nan ndikndik guigira mben ndavir givav kɨrga. ");
INSERT INTO geb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Ndu buni, gu ntan mbe suaŋgi. Kha nuiana gumgi gu mbigi, mbe panan mbe kegi. Mbe panan mbe kegi, ne khaŋ muuŋgi. Nan gumgi gu mbigi, mbe kha nuiana ntɨɨri fhuvara. Gu vhɨra, gu kha nuiana ne fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Gu kha nuiana thav, mbe ndir zav ndun nzai fhuvara. Zakɨra fhuvara! Gu mbe ganɨn zav, mbe nzuav ndu phorga nzuai. Ndu mbe ganɨnga, mba Guma Mbatɨk mben farfagirga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Mbe kha nuiana ntɨɨri fhuvara. Mbe nara fara muuŋgi, gu kha nuiana ne fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ndu buni, nta guigi guarara. Gu khueŋ vuzvugi, ndun buni guari mben ndavi vherir kɨv ŋgarɨrim, mbe guigira ndun ntɨɨri kɨri. ");
INSERT INTO geb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ndu fhum na sarigim, gu zerav kha nuiana gumgi gu mbigi phorga ki. Mba tɨvara ndu na nɨɨŋgi gumgi gu mbigi, gu mbe sararim, mbe ŋgɨp kha nuiana gumgi gu mbɨgi rɨgar kɨrga. ");
INSERT INTO geb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Gu mbera kurkurar zav, gu za won tuman ndu nɨɨŋgi. Gu maaŋ muuŋgirga, mba tɨvara mbe guigira ndu ntɨɨri kɨrga. ");
INSERT INTO geb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Gu mba gumgira kurkurar za ndu phorga nzuai fhuvara. Gu mbe buni mbararav na khothɨgi gumgi gu mbigi ga nzuai. ");
INSERT INTO geb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Gu vhɨra khueŋ vuzvugi, mba gumgi, mbe za wari tɨgɨp ndava bavira kɨrga. Mbe ndu nan kim, gu ndun ki fara muuŋgirga. Gu khueŋ vuzvugi, mbe mba tɨvara muuŋgip, mbe vhɨra ŋkan kɨrga. Mbe maaŋ muunga, kha gumgi gu mbigi khueŋ khothɨgɨrga, ndu na sarigim, gu zergi. ");
INSERT INTO geb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ndu zɨ bakɨme gu ŋkasŋka bakɨmen na nɨɨŋgim, gu niin mbe nɨɨŋgi. Mbe maaŋ muuŋgip, ŋkan farar muuŋgip wari tɨgɨp ndava bavira kɨrga. ");
INSERT INTO geb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Gu mben kim, ndu nan kim, gu mba tɨva nzuav, gu khueŋ vuzvugi, mbe wari tɨgɨp guigira ndava bavira kɨrga. Mbe maaŋ muunga, kha nuianan ki gumgi gu mbigi kaŋgirga, ndu na sarigim, gu zergi. Maaŋ muuŋgiap, ndu won ndavar na nɨɨŋgi tɨvara, ndu ndava, mben nɨɨŋri. ");
INSERT INTO geb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Dara, gu khueŋ vuzvugi, ndu na nɨɨŋgi gumgi gu mbigi, mbe na phorgɨp gu ki ŋgun kɨrga. Gu khueŋ vuzvugi, mbe nan ŋkasŋka bakɨme gum nan zɨ bakɨme ganɨnga. Kha nuian zumgum hɨgi, ndu fhum guarara wo ndavar na nɨɨŋgiap, ndu mba ŋkasŋka bakɨme gum zɨ bakɨmen na nɨɨŋgi. ");
INSERT INTO geb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O, tɨvar vhuuaŋ mbui Ndia, kha nuiana gumgi gu mbigi, mbe ndu kaŋgi fhuvara. Gu ndu kaŋgi. Kha nan gumgi gu mbigi, mbe kaŋgi, ndu na sarigim gu zergi. ");
INSERT INTO geb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Gu tuituigiap ndu bun mbe suaŋgi. Gu khaŋ tɨgɨp ndu zɨ bun suaŋvra kɨrga, mbe guigira wari won ndavir harigi gumgi ga ndɨɨi tɨva zɨn ŋgɨrga. Mbe ndu guigira won ndavar na nɨɨŋgi tɨvara, mbe wari won ndavir harigi gumgir nɨɨnga. Maaŋ muuŋgirga, gu vhɨra, gu mben kɨrga.” ");
INSERT INTO geb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Zisas mba bunin Fhe Bakɨme phorga suaŋgia thugap, wo phorga rui gumgir kov, mbe vov Kidron mbɨ rɨgap muen hegi. Mba mbɨ khiŋgiap muen mɨna mbe ki. Zisas wo phorga rui gumgir kov, mbe vov mba mɨnan vhen vergi. ");
INSERT INTO geb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Zudas, mba Zisas ndim ana pana gumgi farve ga sur za mbui guma, ana vhɨra mba mɨna kaŋgi. Ne khaŋ muuŋgi, Zisas tugi vhɨrvera wo phorga rui gumgir kov, mbe mba mɨnan ka ruigi. ");
INSERT INTO geb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mba Fhe Bakɨme rotu gari gumgir pani gum Fherasin gumgir pani, mbe Fhe Bakɨme Phena gari gɨɨtɨvi mbari gum, Romiŋ gɨɨtɨvi mbari, mbe mbe sarigim, Zudas mben kov mba mɨnan vui. Mbe raa ndigap, nteni ga poŋgiap, ntari ga mbui bigi ndigap, wari zi. ");
INSERT INTO geb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Zisas mba won hɨr za mbui bigi, ana za nta kaŋgi. Ana maaŋ muuŋgiap, mben han vov kha nzambarar mbe muuŋgi, “Nde the ndi gari?” ");
INSERT INTO geb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Mbe ana ŋgarkarav khaŋ nzuai, “Nza Nasaret guma Zisas ndi gari.” Zisas mbara khaŋ mbe nzuai, “Gura khare.” Zudas, ana ndi mbe farve ga sui guma, ana mbe phorga thɨgap ki. ");
INSERT INTO geb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Mbe Zisas mbararagim, ana khaŋ nzuai, “Gura khare,” mba gumgi mbe taagia khimtɨ mbugu vov fhura kɨzrɨga mbar maaŋgi. ");
INSERT INTO geb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Zisas mbara taagia mben nzarigi, “Nde the ndi gari?” Mbe khaŋ nzuai, “Nasaret guma Zisas.” ");
INSERT INTO geb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Zisas mbara mbe ŋgarkarav khaŋ mbe nzuai, “Gu nde suaŋgi, gura khare. Nde na ndi gari, nde kha gumgi, nde fhura mbe ganɨrim, mbe taagi ŋgɨri.” ");
INSERT INTO geb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ana mba tɨva mbui, ana mba fhum suaŋgi kameŋra zɨn vugi, “Ndu mba na nɨɨŋgi gumgi, mbe the mbar rɨgi fhu.” ");
INSERT INTO geb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pita ntari ga mbui kos mbe ndiga zɨgi. Ana mba kos sigap, mba Fhe Bakɨme rotu gari guman panan ŋaara guman khuareŋ shogi, ne thuga nɨɨeŋ rɨgi. Mba ŋaara guma zɨ khare, Markus. ");
INSERT INTO geb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Zisas khaŋ Pita ga nzuai, “Mba ntari ga mbui kos ndi taagip ana nderar rugɨri. Ram muuŋgi bigeŋ? Ndu ndɨkndɨgi, gu mba nan Ndia mbɨr zav na nɨɨŋgi thama mbɨ, gu ana mbɨrga tuktɨgi fhuv thi?” ");
INSERT INTO geb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mbe Romin ntari ga mbui gɨɨtɨvi, wari won guman panan kov, mba Zudain gɨɨtɨvi, mbe Zisas suirav, toriŋ mpiin ana kegi. ");
INSERT INTO geb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Mbe ana kegap, fharav ana ndiga Anas han vui. Anas, ana Kaiafasan vhok ma. Kaiafas, ana mba mpariven, ana Fhe Bakɨmen rotu gari guman pan ma. ");
INSERT INTO geb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ana vhɨra khaŋ mba Zudaiŋ ga nzuai guma ma. Ana khueŋ nzuai, “Guma bavira za kha gumgi gu mbigi ŋana ndigip rimgirga, ne nzerara.” ");
INSERT INTO geb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita gum mba Zisas phorga rui guma mbe, mani Zisas zɨn vui. Mba Zisas phorga rui guma, Fhe Bakɨme rotu gari guman pan ana kaŋgi, ana maaŋ muuŋgiap, Zisas phorga za vov, mba Fhe Bakɨme rotu gari guman pana phena bɨnan vhen vergi. ");
INSERT INTO geb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita fhu, ana mba phena bɨna thɨma kamanira ki. Maaŋ muuŋgiap, mba Zisas phorga rui guma mbe, ana mbara vov mba phena bɨna thɨmkamani gari mbiga nzuaim, ana Pita nzuaim, ana vhen zergi. ");
INSERT INTO geb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mba thɨmkamani gari mbik kha nzambaran Pita muuŋgi, “Ndu vhɨra kha guma phorga rui guma the thi?” Pita mbara khaŋ nzuai, “Fhuvara. Gu ana phorga rui guma fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Mba ŋaneŋ raŋgim, mba ŋaara gumgi gum gɨɨtɨvi, mbe vhava tɨgi vhavir khua kim, mbe nta gurgurav thivgiap ki. Pita vhɨra mbe phorga thɨgap vhava gurgurav ki. ");
INSERT INTO geb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mba tugen Fhe Bakɨmen rotu gari guman pan Zisas phorga rui gumgi ga nzuav ana nzav, vhɨra ana mba gumgi ga suaŋgi buni ga nzuav ana nzai. ");
INSERT INTO geb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Zisas ana ŋgarkarav khaŋ nzuai, “Gu za kha gumgi gu mbigi nɨman hiiŋra kav, gu wo bunin gumgi gu mbigi ga nzuai. Gu zazera Fhe Bakɨme buni mbararagi pheni vhen kav, Fhe Bakɨme bunin mbe khɨvav mbe nzuai. Gu vhɨra Fhe Bakɨme phena bɨna vhen, mbe Zudaiŋ za kav phogia ga vhui ŋanen kav Fhe Bakɨme buni vhuuin mbe khɨvav mbe nzuai. Gu zorga kav buna thueŋ suaŋgi fhu. ");
INSERT INTO geb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Maaŋ muuŋgiap, nde thaŋ nzuav nan nzai? Ndu mba na buni mbararagi gumgir nzaŋri. Mbe gu suaŋgi buni, mbe nta kaŋgi.” ");
INSERT INTO geb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Zisas ne nzuaim, maaŋ thɨga ki gɨmatɨva mbe ana kureŋ phɨrgiap khaŋ nzuai, “Ndu ram muuŋgiap, maaŋ muuŋgia tɨgap, Fhe Bakɨme rotu gari guman pana buneŋ ŋgarkai?” ");
INSERT INTO geb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Zisas ana buneŋ ŋgarkarav khaŋ nzuai, “Gu maaŋ muuŋgip buna mbatɨk thueŋ suaŋgirim, ndu mba gu suaŋgi buna mbatɨgeŋ nɨɨŋ shɨrav nan tɨgɨri. Gu buna vhuueŋ suaŋgim, ndu thaŋ nzuav, na shogi?” ");
INSERT INTO geb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anas thav Zisas ga sarigim, ana Fhe Bakɨme rotu gari guman pan Kaiafasan han vui. Mbe mba ana kegi mpiiŋ, mbe ana fhɨrgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita vhava gurgurav thɨgap ki. Mbe kha nzambaren ana muuŋgi, “Ndu vhɨra ana phorga rui guma the fhup thi?” Ana mbara khaŋ mbe nzuai, “Zakɨra fhuvara! Gu ana phorga rui guma fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pita maaŋ nzuaim, mba Fhe Bakɨme rotu gari guman panan ŋaara guma mbe, ana mba Pita mba mɨnan khuareŋ shogia thugi guman kɨvntok ma, ana khaŋ nzuai, “Gu ndura gari, ndu ana phorga mbu mɨnan kegi thi?” ");
INSERT INTO geb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita taagia khaŋ nzuai, “Zakɨra fhuvara!” Ana maaŋ nzuavra thagim, tuar za fhurigi. ");
INSERT INTO geb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Zudaiŋ Kaiafas phena thav, Zisas ndigap Zudia ŋgu bakɨme fhaiŋ gari guman pan Pairat phenan vui. Mbe mɨn goravra thagim, mbe ana ndiga vui. Mbe khueŋ ndɨkndɨgi, “Nza muuŋv kɨv, Fhe Bakɨme nɨman nzaŋnzaŋgip, nza Pasova tuga bakɨmen pi mba mbegɨrga tuktɨgi fhuvara.” Mbe maaŋ muuŋgiap, mbe ŋgu bakɨme fhaiŋ gari guman pana phena vhen vergi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mbe kɨrara kav rargim, Pairat nduara mben han zav kha nzambarar mbe muuŋgi, “Nde thagɨna bigeŋ nzuav mba guma ga nzuav suan za mbui?” ");
INSERT INTO geb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Mbe ana ŋgarkarav khaŋ nzuai, “Ana maaŋ muuŋgiap nden tɨvi phɨri fhuv guma kake, nza thagɨne suaŋv ana ndigi ndun han zɨrie?” ");
INSERT INTO geb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pairat khaŋ mbe nzuai, “Nde ana ndigi ŋgɨp, wari won tɨvira suaŋv ana suaŋv suaŋri.” Ana maaŋ nzuaim, Zudaiŋ ana ŋgarkarav khaŋ ana nzuai, “Romin tɨvi guma shogirim, ana rɨmɨnga nen nza thɨvigi.” ");
INSERT INTO geb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Zisas fhum wo rɨmɨnga tɨva bun suaŋgi, ntige mba tɨv ana hi. Ne maaŋ muuŋgira, ana suaŋgi kameŋ ne guigi guarara. ");
INSERT INTO geb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pairat mbara taagia vov, ŋgu bakɨme fhaiŋ gari guman pana phena vhen vergi. Ana vhen vergap, Zisasan kamgi, ana zi. Ana zim, ana kha nzambarar ana muuŋgi, “Ndu Zudain ŋgui vhɨrve gari guman pan e?” ");
INSERT INTO geb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Zisas mbara ana ŋgarkarav khaŋ nzuai, “Ndu nduara ne ndɨkndɨgiap ndu mba kameŋ nzuai o, harigi gumgi na bun ndu suaŋgi?” ");
INSERT INTO geb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pairat mbara ana ŋgarkarav khaŋ nzuai, “Ram muuŋgi? Gu Zuda guma e? Ndu ntɨɨri gum Fhe Bakɨmen rotu gari gumgir pani ndu ndigap na farve khɨngi. Ndu ram muuŋgi ne nzuav, mbe ndu ndiga zɨgi.” ");
INSERT INTO geb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Zisas mbara ana ŋgarkarav khaŋ nzuai, “Gu gari nan piin ki bigi, nta kha nuianan ntɨɨri fhuvara. Gu gari nan piin ki bigi, nta kha nuiana bigi kake, gu nzuaim, nan ŋaara gumgi khavgia ntara mbuim, guma the na ndim Zudaiŋ farve khɨngia ntɨɨŋ. Maaŋ muuŋgiap, gu gari nan piin ki bigi, nta kha nuiana ntɨɨri fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pairat thav ana nzarigi, “Maaŋgi, ndu guigira ŋgui vhɨrve gari guma pana the, e?” Zisas mbara ana ŋgarkarav khaŋ nzuai, “Ndu mba ŋgui vhɨrve gari guman pana nzuai kameŋ, ne ndun kameŋra. Nan niamuuŋ na tegi, gu kha nuianan hɨgi, gu ŋaara bavira muun zav hɨgi. Gu buni guarira bun suaŋrim, kha gumgi gu mbigi na buni mbarararga. Mba buni guari mbararav nta zɨn vui gumgi, mbe na buni mbararagi.” ");
INSERT INTO geb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pairat mbara ana nzarigi, “Buni guari, nta ram mbui khesharigi buni guarira?” Pairat maaŋ ana suaŋgiap, ana taagia Zudaiŋ han kɨrar hɨgi. Ana kɨrar hɨgap khaŋ mbe nzuai, “Gu ana muuŋgi tɨva mbatɨga thueŋ gangi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nde Zudaiŋ, nde won tɨva kaŋgi. Nde zazera mpari tugɨratɨgap, kha Pasova tuga bakɨmen nan nzuaim, gu fhura nde garim, nde nduarira guma the farasararim, ana bɨna thav kɨrar hɨgɨp bɨkbɨɨgirga. Maaŋ muuŋgiap, nde vuzvugi, gu kha Zudaiŋ ŋgui vhɨrve gari guman pana fhɨrgirim, ana nden han ŋgɨrie?” ");
INSERT INTO geb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ana ne nzuaim, mbe wom kaav khaŋ nzuai, “Ana fhuvara. Ndu Barabas fhɨrgiri!” Barabas, ana ntari ga mbuav, gumgi shogi mbe vhɨzgim, ana mbe bigi kɨɨi guma ma. ");
INSERT INTO geb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pairat mbaram nzuaim, mbe Zisas ndigap kankani ki phivɨgar ana khari. ");
INSERT INTO geb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Mbe ana kharav, mben gɨɨtɨvi tari ki karɨga ndigap, ana ŋgui vhɨrve gari guman pan fi khorsɨga fara muuŋgi khorsɨga muuŋgiap, ana anan panan fagi. Mbe mba khorar ana fav, shaa hɨva mpeeŋ ndigap, ana sharigi. ");
INSERT INTO geb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Mbe maaŋ ana muuŋgiap, thiva ana han zav khaŋ ana nzuai, “Raar vhuuŋ, Zudaiŋ ŋgui vhɨrve gari guman pan.” Mbe maaŋ ana nzuav ana kurani pogi. ");
INSERT INTO geb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pairat mbara taagia kɨrar hɨgap khaŋ mba gumgi ga nzuai, “Nde ganɨ, gu taagi Zisas ndigi kɨrar hɨrga, nde kaŋgirga, gu ana muuŋgi tɨva mbatɨk thueŋ gangi fhu.” ");
INSERT INTO geb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ana ne suaŋgim, Zisas mbara kɨrar hi. Mbe mba tari ki karɨgar muuŋgi khorsɨk mbara muuŋgiap ana panan fav ki. Mbe mba ana sharigi shaar hɨva mpeeŋ vhɨra mbara muuŋgiap ki. Pairat mbara khaŋ mbe nzuai, “Nde ganɨ, mba gumara khare.” ");
INSERT INTO geb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mba Fhe Bakɨmen rotu gari gumgir pani gum mben gɨɨtɨvi ana garav kaav khaŋ nzuai, “Ana ndim khanarareŋ ga tɨgɨ fugu. Ana ndim khanarareŋ ga tɨgɨ fugu!” Pairat mbara khaŋ mbe nzuai, “Nde nduarira ana ndigi ŋgɨp, khanarareŋ ga tɨgɨ fuguri. Gu ana muuŋgi tɨva mbatɨk thueŋ gangi fhu.” ");
INSERT INTO geb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mbe Zudaiŋ ana kameŋ ŋgarkarav khaŋ nzuai, “Nza tɨva mueŋ ki, mba tɨveŋ khaŋ nzuai, mba guma ana rɨmɨnga. Ne khaŋ muuŋgi, ana khaŋ nzuai, ‘Gu Fhe Bakɨmen Kam ma.’ ” ");
INSERT INTO geb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pairat mba kameŋ mbararagiap ana guigira rivgi. ");
INSERT INTO geb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ana mbara taagia ŋgui vhɨrve gari guman pana phen vhen vera kha nzambaren Zisas ga muuŋgi, “Ndu maaŋgi ŋgu guma?” Zisas buna thuen ana fagi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pairat mbara khaŋ ana nzuai, “Ee, ndu ram muuŋgi? Ndu na buni ŋgarkav ragire? Gu ndu fhɨrgirim, ndu ŋgɨrga ŋkasŋka ki. Gu vhɨra ndu ndi khanarareŋ ga tɨgɨ fukfugɨrga ŋkasŋka ki. Ee, ndu ne kaŋgi fhuv thi?” ");
INSERT INTO geb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Zisas mbara ana ŋgarkarav khaŋ nzuai, “Maaŋ muuŋgip, kha vun ki Fhe Bakɨme, ana ŋkasŋkar ndun nɨɨŋgirga fhu, ndu na mbevarga ŋkasŋka kegɨrga tuktɨgi fhu. Maaŋ muuŋgiap, nan ndu farve khɨngi guma, ana muuŋgi tɨva mbatɨgeŋ ndu muuŋgi tɨva mbatɨgeŋ kambarav guigira kɨvgi.” ");
INSERT INTO geb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pairat mba kameŋ mbararagiap, ana Zisas fhɨrgirim, ana ŋgɨrga tuavi ndi gari. Mbe Zudaiŋ, mbe kaav khaŋ nzuai, “Ndu mba guma fhɨrgirim, ana ŋgɨgɨrga, ndu Romin guman pan Sisar kɨvntok fhuvara. Mba nduara khaŋ wo nzuai guma. ‘Gu ŋgui vhɨrve gari guman pan ma,’ ana Sisar pana guma ma.” ");
INSERT INTO geb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pairat mba kameŋ mbararagiap, mbara Zisas kov kɨrar hɨgi. Ana kɨrar hɨgap, gumgi ga nzuav nzuai guman pan pigi mpirmpirɨga peregi. Mba ŋaneŋ, mbe kha zitɨr ne ga mbui, “Kɨman vundap”. (Mbe Hibruiŋ kaman kha zitɨr ana mbui, “Gabata.”) ");
INSERT INTO geb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Mba raan mbe Pasova tuga bakɨme ndɨkndɨgap mba bevahi tuk ma. Mba raan ra vov phɨɨŋ ndi. Pairat mbaram khaŋ mba Zudaiŋ ga nzuai, “Nde wari wo ŋgui vhɨrve gari guman pana ganɨ.” ");
INSERT INTO geb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Mbe kaav khaŋ nzuai, “Ana vharari ana ŋgɨ! Ana vharari ana ŋgɨ! Ana ndi khanarareŋ ga tɨgɨ fugu!” Pairat mbara mben nzarigi, “Nde vuzvugi, gu nden ŋgui vhɨrve gari guman pana ndi khanarareŋ ga tɨgɨp fukfugɨrie?” Mba Fhe Bakɨme rotu gari gumgir pani ana ŋgarkarav khaŋ nzuai, “Nza harigi ŋgui vhɨrve gari guman pana the ki fhuvara. Sisar nduara!” ");
INSERT INTO geb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mbe maaŋ nzuaim, Pairat Zisas ndim, mba gɨɨtɨvi farve khɨngim, mbe ana ndim khanarareŋ ga tɨgɨp fukfugɨrga. ");
INSERT INTO geb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Mba gɨɨtɨvi mbara Zisas ndiga vui. Ana nduara won khanarareŋ phufhura vui. Mbe ana ndiga vov, mba Zerusarem ŋgu bakɨme thav vov, mbe kha zɨn rɨgi ŋanen hɨgi, “Panan Tuam.” Mbe Hibruiŋ kaman kha zɨn mba ŋanen kaai, “Gorgota.” ");
INSERT INTO geb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Mbe mba ŋanen ana ndim khanarareŋ ga ntorgi. Mbe ana ndi ntorgap, mbe vhɨra harigi guma phuni, mbe vhɨra mani ndi ntorgi. Mbe mbe ndi ana gaar mueŋ ga ntorgap, mbe mbe ndi mueŋ ga ntorgi. Zisas, ana manin rɨganera ntorgi. ");
INSERT INTO geb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pairat vhɨra mbe nzuaim, mbe kama mueŋ khergiap, Zisasan khanarareŋ ga ntorgi. Mba kameŋ khaŋ nzuai, “Zisas Nasaret guma, Zudain ŋgui vhɨrve gari guman pan.” ");
INSERT INTO geb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pairat mbe nzuaim, mbe Hibruin kaman mba kameŋ kherav, Romiŋ kaman ne kherav, vhɨra Grikiŋ kaman ne khergi. Mbe Zisas ndi khanarareŋ ga ntorgi ŋaneŋ, ne ŋgu bakɨme hara ki. Maaŋ muuŋgiap, mbe Zudaiŋ vhɨrve, mbe vov zav mba kameŋ gari. ");
INSERT INTO geb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Maaŋ muuŋgiap, mba Fhe Bakɨme rotu gari gumgir pani khaŋ Pairat ga nzuai, “Ndu khaŋ muuŋgi kherɨ thari, ‘Zudaiŋ ŋgui vhɨrve gari guman pan.’ Fhuvara! Ndu khaŋ muuŋgi kameŋ khergiri, ‘Kha guma khaŋ suaŋgi, gu Zudaiŋ ŋgui vhɨrve gari guman pan ma.’ ” ");
INSERT INTO geb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pairat mben kameŋ ŋgarkarav khaŋ nzuai, “Gu khergi kameŋ, ne ki.” ");
INSERT INTO geb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Mben gɨɨtɨvi, Zisas ndi khanarareŋ ga ntorgap, ana shagi, mbe nta ndigap, nta shɨgap fethɨgi phogi ga suegi. Mba gɨɨtɨvi, mbe zam bueŋbueŋra ndigi. Mbe vhɨra ana fhava sharige ndigi. Mba gɨɨtɨvi ana ndigap garav, mbe shagi fɨgi vhɨrve ndigap, wari tɨgap mba fhava shaage samgi fhuvara. Mbe shaa bavira ana muuŋgiap, ana samgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Maaŋ muuŋgiap, mba gɨɨtɨvi khaŋ nzuai, “Nza kha fhava sharige shɨgɨrga fhuvara. Nza ana suaŋv satu sunuv ganɨnga, the ana ndigirie?” Mbe ana ndir zav ana nzuav maaŋ muuŋgi. Mbe ana nzua muuŋgi tɨv, mbe fhum ana nzuav khergi kama mueŋ ne Fhe Bakɨme buni vhuuiŋ ki gavar ki. Mba tɨv, ana mba kameŋra zɨn vugi. Mba kameŋ khaŋ muuŋgi, “Mbe nan shagi, mbe nta shama mbuav nta ndigi. Mbe na fhava sharige ndir zav, niŋge nzuav satu surav, guma mbe niŋge ndigi.” Mba gɨɨtɨvi, mbe mba tɨvara muuŋgi. ");
INSERT INTO geb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Zisasan niamuuŋ, won mbiga hɨrɨɨn, Maria Kropas muuŋ gum, Maria Makdaran mbik, mbe mba mbigi mbe wari tɨgap, Zisas ntorgi khanarareŋ hara thivgiap ki. ");
INSERT INTO geb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Zisas won niamuuŋ garav, ana wo phorga ruigi guma, ana guigira ana vuzvugi, ana mani garim, mani ana hara thɨgap ki. Zisas mbara khaŋ won niamuuŋ ga nzuai, “Mbik, mba guma, ana ndun kam ma.” ");
INSERT INTO geb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ana khaŋ mba wo phorga ruigi guma, ana guigira won ndavar nɨɨŋgi, ana khaŋ ana nzuai, “Mba mbik, ana ndun niamuuŋ ma.” Ana maaŋ suaŋgim, mba tugera, mba phorga ruigi guma Maria kov wo phenan vugap, ana garim, ana anan han ki. ");
INSERT INTO geb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Zisas kaŋgi, ana mba muun za zergi ŋaari za vhɨzgi. Ana mbara khaŋ nzuai, “Fhɨr na khigi.” Ana mba suaŋgi kameŋ, ne mba Fhe Bakɨme buni vhuuiŋ ki gavar ki kama mueŋra zɨn vugi. ");
INSERT INTO geb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ana maaŋ nzuaim, mbe ana mbararagiap, pɨksɨgi wain nda khɨgap maaŋ ndarav kim, mbe spans fɨga mueŋ ndigap waina rugi. Mba spans fɨgeŋ wain ne givigim, mbe ne ndiv, hisop ŋgaa phokegap, ana ndiv Zisas kamthooŋ phɨrgi. ");
INSERT INTO geb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Zisas mba waina mbegap khaŋ nzuai, “Ntige vhɨzgi.” Ana ne suaŋgiap, mbara bur huazgia ntorgap, gor vhɨk ŋgɨrgi. ");
INSERT INTO geb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mba raar, mbe Sabat bigi bevahi ra ma. Mba Pasova Sabat, ana guigira tuga bakɨme ma. Maaŋ muuŋgiap, mbe Zudaiŋ gumgir pani, mbe mba gumgir ŋkuu, mba khirarareiŋ ga tuigɨ kɨrgeŋ thagi. Mbe maaŋ muuŋgirga, mbe mba khirarareiŋ ga tuigi gumgi suira shogɨv nta phɨrɨ sur zav Pairat ga nzuai. Mbe maaŋ mben muunga, mbe vhemkora vhɨzgirga, mbe mbe ndigi ŋgegɨrga. ");
INSERT INTO geb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Maaŋ muuŋgiap, mba gɨɨtɨvi vov, mbe mba Zisas phorga khanarareŋ ga ntorgi gumani, mbe mani suani shogap, ni phɨra suegi. ");
INSERT INTO geb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mbe maaŋ Zisasan muun za zav, ana gari ana rimgi. Mbe maaŋ muuŋgiap ana suani shogap, ni phɨrgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Mba gɨmatɨva mbe zav fugar Zisas kuvsɨgeŋ dagi. Ana ana dagim, vɨzɨn gu mbɨ vhemkora sia suagi. ");
INSERT INTO geb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mba vɨzɨn gu mbɨ gangi guma, ana mba gangi bigi, ana za nta bun suaŋgi. Ana mba suaŋgi buni, nta guigira. Ana vhɨra nduara kaŋgi, ana guigira buni guarira bun nzuai. Ana ne bun nzuai, nde vhɨra ne khothɨgɨri. ");
INSERT INTO geb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mba hegi bigi, nta Fhe Bakɨme buni vhuuiŋ ki gavar ki buna mueŋ suaŋgi kama mueŋ mɨnan hɨgi. Mba kameŋ khaŋ nzuai, “Mbe ana hara the phɨrgirga tuktɨgi fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Fhe Bakɨme buni vhuuiŋ ki gavar ki buna mueŋ khare, “Mbe mba dagi guma, mbe ana ganɨnga.” ");
INSERT INTO geb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mba raar ra verav vhɨzim, Arimatea guma Zosep vov Pairatan nzai, ana ana khɨrarim, ana Zisas khuma ndigɨ ŋgɨrga. Zosep ana Zisas khothɨgap ana zɨn vui guma mbe ma. Ana Zudain gumgir panin rivgiap, ana wo vhagiap ki. Ana Pairatan nzarigim, ana ana khɨrigim, ana Zisas khuma ndigi. ");
INSERT INTO geb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus, ana mba fhum maaŋ zav Zisas gangi, ana vhɨra zi. Ana mbe kha phunin nanani ndigap wani digap muuŋgi ndɨga vhuuŋ hi mporiiŋ, ana ana ndiga zi. Mba mporiin simtɨk 30 kirogram thɨgi. ");
INSERT INTO geb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Zosep gum Nikodemus Zisas khuma ndiga vov, mba mporiin ana khuma hɨvgiap, shagi vhuuiŋra ndigap, ana khuma zigi. Mbe Zudaiŋ, mbe rimgi guman khum, mbe mba tɨvar ana mbui. Mani mba tɨvar ana muuŋgi. ");
INSERT INTO geb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mba ntari ga mbui gɨɨtɨvi Zisas ndi khanarareŋ ga ntorgi ŋaneŋ han, mɨna mbe ki. Mba mɨnan, mbe kɨma thoon muuŋgi mboga kama mbe ki. Mbe fhum guma the ndi mba mboga tɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Mbe Zudaiŋ, mbe Sabat bigi bevahɨrga tuk ma. Mba mbok ana hara kim, maaŋ muuŋgiap, mani Zisas khuma ndiga vov mba mbok ga tɨgi. ");
INSERT INTO geb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande raa hɨgi. Makdara mbik Maria, ana maaŋra mɨn ntigar gorɨrga, ana gɨngɨn nera khavgiap, Zisas mbogar vui. Ana vov gari mba mbok thɨɨŋ khuigi kɨma bakɨme mba mbok thɨɨn ki fhu. ");
INSERT INTO geb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Maaŋ muuŋgiap, ana vhemkora khuafɨra taagia vov Saimon Pita gum mba Zisas phorga ruigi guma ana guigira won ndavar ana nɨɨŋgi ŋaara guma, ana khaŋ mani ga nzuai, “Mbe Guma Bakɨme khuma ndigi. Nza mbe ana khuma ndi tɨgi ŋaneŋ kaŋgi fhu.” ");
INSERT INTO geb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Maaŋ muuŋgiap, Pita mba Zisas phorga ruigi guman kov, mani Zisas mbok taan vui. ");
INSERT INTO geb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mani wani tɨgara khuafɨrav wani vui. Mani vov, mba Zisas phorga ruigi guma, ana Pita kambarav, fharav vov Zisas mbok taan hɨgi. ");
INSERT INTO geb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ana fharav hɨgav, ŋkuav degav, mbu mbok vhee gari. Ana garav, ana mbe Zisas khuma zigap, ana vhagi shagi vhuuiŋra gari, nta regap ki. Ana dega vhen vergi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon Pita, ana zɨn zav, degiap, mboga vhen vergi. Ana verav, mba shagira gari, nta regap ki. ");
INSERT INTO geb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ana nta garav, ana vhɨra garim, mba Zisas panaŋge kega kegi shaa, mba shagi phorga ki fhu. Fhuvara! Ana kha gangana muuŋgi, guma mbe ana dɨmgiap, ana ndi harigi ŋaneŋ ga tɨgi. ");
INSERT INTO geb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mba Zisas phorga ruigi guma fharav zav mba mbok taan hɨgi, ana vhɨra vhen vergi. Ana vhɨra mba bigi gangiap, ana ne khothɨgi. ");
INSERT INTO geb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mba tugen mbe tuituigiap Fhe Bakɨmen buni vhuuiŋ ki gavar ki bunin vhuuiŋ kaŋgiap, mbe Zisas rimgip, mbogar tɨgɨp, taagi khavgirgane kaŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Maaŋ muuŋgiap, ana phorga ruigi gumani taagia Zerusareman vui. ");
INSERT INTO geb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria mba mbok han kɨrar thɨgap kav, nziav ki. Ana nziavra kav ŋguav, degiav mbu mboga vhee gari. ");
INSERT INTO geb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ana garav, ana Fhe Bakɨme enser mani garim, mani shagi huri shargi. Mani Zisas khum rɨga kegi ŋaneŋ ga perav ki. Mani mbevi, ana pan rɨga kegi fhɨge perigim, mbevi ana suani fhɨge perigi. ");
INSERT INTO geb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Mani mbara kha nzambarar Maria ga muuŋgi, “Ai, mbik, ndu thaŋ nzuav nzi.” Ana mbara khaŋ mani ga nzuai, “Mbe na Guma Bakɨme khuma ndiga mbar vugi, gu mbe ana khuma ndi tɨgi ŋaneŋ kaŋgi fhu.” ");
INSERT INTO geb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ana ne nzuav, dorga garav, Zisas gari, ana thɨgav ki. Maria Zisas gangiap, ana ana heav, ana kaŋgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Zisas mbara kha nzambarar ana muuŋgi, “Mbik, ndu thaŋ nzuav nzi? Ndu the nzuav gari?” Maria khueŋ ndɨkndɨgi, “Mba mɨna gari guma thi?” Ana maaŋ muuŋgiap khaŋ ana nzuai, “Guma, ndu maaŋ muuŋgip ana khuma ndigi ŋgɨp mba ŋana thuen tɨgɨp, ndu mba ŋaneŋ bun na suaŋgirim, gu ŋgɨp ana khuma ndirga.” ");
INSERT INTO geb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Zisas mbara khaŋ ana nzuai, “Maria.” Maria mbara dorgap Hibruiŋ kaman khaŋ ana nzuai, “Rabonai.” Kha kameŋ “Rabonai” ne khaŋ nzuai, “Ndɨkndɨgi vhuuin nza khɨvi guman rum.” ");
INSERT INTO geb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Zisas mbara khaŋ ana nzuai, “Ndu nan suira havharɨ thari. Gu khaŋ muuŋgi, gu won Ndiar han ndagi fhuvara. Ndu na phorga ruigi gumgir han ŋgɨp khaŋ mbe suaŋri, ‘Gu won Dara gu nden Dara han ndai. Gu wo Fhe Bakɨme gum nde Fhe Bakɨme han ndai.’ ” ");
INSERT INTO geb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Makdaran mbik Maria mbara vui, ana vov khaŋ ana phorga ruigi gumgi ga nzuai, “Gu Guma Bakɨme gangi.” Ana nen mbe nzuav vov, mba Zisas mbe suan za suaŋgi kamen mbe nzuai. ");
INSERT INTO geb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Zisas phorga ruigi gumgi, mbe Zudain gumgir pani rivgiap, wari khɨgap, vhembugum thɨma puigap wari vhen ki. Mbe Sande raar kav kim, ra verav vhɨzgim, Zisas zav mbe rɨgar mbar thɨgi. Ana thɨgap khaŋ mbe nzuai, “Nde ndavi mbɨrav wari kɨri.” ");
INSERT INTO geb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ana maaŋ mbe nzuav, won farveni gu won kuvsɨgen mbe khɨvi. Mba Zisas phorga ruigi gumgi ana gangiap, mben ndavi vheri guigira ndikndigi. ");
INSERT INTO geb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Zisas taagia khaŋ mbe nzuai, “Nde ndavi mbɨrav wari kɨri. Dara na sarigi gu zɨgi, mba tɨvara gu nde sarigi nde ŋgɨri.” ");
INSERT INTO geb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ana maaŋ mbe suaŋgiap won bɨɨŋbɨɨŋ ga berigim, ana mben vui. Ana mbara khaŋ nzuai, “Nde Fhe Bakɨmen Ŋina Ŋaara ndiri. ");
INSERT INTO geb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nde gumgi muuŋgi tɨvi mbatɨgi, nde mbe tɨn nta vhɨzɨrga, mbe muuŋgi tɨvi mbatɨgi, Fhe Bakɨme vhɨra nta vhɨzgirga. Nde gumgi muuŋgi tɨvi mbatɨgi, nde mbe ntɨɨri vhɨzgirga fhu, mben tɨvi mbatɨgi mbara muuŋgip kɨrga.” ");
INSERT INTO geb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Zisas wo phorga ruigi gumgir han zɨgi tugen, ana phorga ruigi 11 thɨgi guma mbe, ana mba tugen mbe phorga kegi fhuvara. Mba ana phorga ruigi guma zɨ khare, Tomas, ana zɨ mbe, Didimus. ");
INSERT INTO geb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Mba Zisas phorga ruigi gumgi mba tugen kim, Zisas mba tugen mben hɨgi, mbe khaŋ ana nzuai, “Nza Guma Bakɨme gangi.” Tomas khaŋ mbe nzuai, “Gu maaŋ muuŋgip mbe ana faramborani ndi tɨga fukfugi thooni gangip, gu wo farafen ana fukfugi thoorir suirav, mbe fugar ana kuvsɨgeŋ dagi thooŋ, gu wo farve mba thoon rugɨrga, gu nde nzuai kameŋ khothɨgɨrga. Gu ntige nde khothɨgi fhuvara. Zakɨra fhuvara!” ");
INSERT INTO geb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Harathɨgi rari vhɨzgim, Zisas phorga ruigi gumgi, mbe wom wari fugap phena vhen kim, Tomas vhɨra mbe phorga ki. Mbe mba ki phen, mbe vhembugum, za ana thɨɨ puigi. Zisas hav fhura mbe rɨgagera mbar thɨgi. Ana thɨgap khaŋ nzuai, “Nde ndavi mbɨrav wari kɨri.” ");
INSERT INTO geb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ana mbara khaŋ Tomas ga nzuai, “Ndu wo farafe ndi khaŋ rugɨp, ndu na farver ganɨv, ndu vhɨra wo farver na kuvsɨgen rugɨ. Ndu na khothɨgi ndɨkndɨk phunin muuŋ thari. Ndu fhura guigira na khothɨgɨri.” ");
INSERT INTO geb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas mbara ana ŋgarkarav khaŋ nzuai, “Ndu nan Guma Bakɨme ma. Ndu nan Fhe Bakɨme ma.” ");
INSERT INTO geb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Zisas mbara khaŋ ana nzuai, “Ndu na gangiap na khothɨgi. Mba na gangi fhuv na khothɨgi gumgi, mbe guigira ndikndigɨri.” ");
INSERT INTO geb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Zisas vhɨra harigi mirikori vhɨrve ana wo phorga ruigi gumgi nɨman nta muuŋgi. Gu za ntan kha gava khergi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Gu kha mirikori gu bigi khergi, gu ne khergirim, nde guigira Zisas khothɨgɨrga, ana mba Fhe Bakɨme taagip won gumgi gu mbigi ndir zav suaŋgiap farasarigi guma ma. Ana Fhe Bakɨmen Kam ma. Nde maaŋ muuŋgip ana khothɨgɨrga, nde ana zɨn panan, nde zazera mbara muuŋgiap ki bɨɨŋbɨɨŋ ndigirga. ");
INSERT INTO geb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Zisas zumgum taagia Gariri mbɨ gaar wo phorga ruigi gumgir hɨgi. Mba ana mben hɨgi mbɨ, ana zɨ mbe khare, Taiberias mbɨ. Ana kha tɨva muuŋgiap mben hɨgi. ");
INSERT INTO geb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas, mbe kha zɨn ana rɨgi, Didimus, Kanan Gariri guma Natanier Sebedin kamani Zisas phorga ruigi guma phuni, mbe wari tɨgap ki. ");
INSERT INTO geb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita khaŋ mbe nzuai, “Gu vhaaŋ sur za vui.” Mbe mbara khaŋ ana nzuai, “Nza vhɨra ndu phorgɨ ŋgɨrga.” Mbe maaŋ suaŋgiap, wari tɨgap fo kema mben maaŋgiap wari vui. Mbe vegap, mba maan mbe mbɨgama thaneŋ ndigi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mba mɨtimanera, ra ndaim, Zisas zav mba mbɨ taan thɨgap ki. Ana phorga ruigi gumgi, mbe khueŋ kaŋgi fhuvara ana Zisas ma. ");
INSERT INTO geb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Zisas mbara kha nzambarar mbe muuŋgi, “Ai, mba kɨvntogi, nde mbaga thari ndigire?” Mbe ana ŋgarkarav khaŋ nzuai, “Zakɨra fhuvara!” ");
INSERT INTO geb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ana mbara khaŋ mbe nzuai, “Nde wari won keman guva haren mbarav vhaaŋ ndi khɨngip, nde mbaga thari ndigirga.” Mbe ne mbararagiap, mbe wari wo vhaaŋ ndi khɨngi. Mbe ana ndi khɨngiap, mbe mbaga vhɨrve guarira ndigap mbe nta khɨgap vhaaŋ ŋgɨrga naangen mbovaragi. ");
INSERT INTO geb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Zisas mba ana phorga ruigi guma, ana guigira wo ndavar ana nɨɨŋgi, ana khaŋ Pita ga nzuai, “Mbure, Guma Bakɨmera mbure.” Saimon Pita wo ruga hav shari shaage zorgiap kav ŋgarav ki, ana kav khueŋ mbararagiap, “Mbure, Guma Bakɨmera mbure,” ana nera mbararagiap, wo ruga hav shari shaage kegap, fega mbɨn mbarav, dia thɨvar vui. ");
INSERT INTO geb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Mba ana phorga ruigi gumgi mbari, mbe keman za phorgap, mba mbaga vhaaŋ khɨgap nta ŋgi. Mbe thɨva thav saman ki fhuvara. Mbe thɨva thav 100 mitara ki. ");
INSERT INTO geb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Mbe zav thɨva phorgap, vhava khoma mbe garim, mbɨgama mbe tuav ki. Mbe garim, viktuma mbe phorga ki. ");
INSERT INTO geb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Zisas mbara khaŋ mbe nzuai, “Nde mba ntige ndigi mbaga, nde thari ndigɨ zɨ.” ");
INSERT INTO geb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ana maaŋ nzuaim, Saimon Pita fega keman mbarav mba vhaaŋ ŋgɨrga zav thɨva ndarigi. Mba vhaan mbaga bakɨvira ana ki. Mba vhaan ki mbagar vhɨrve 153 thɨgi. Mba mbaga guigira vhɨrkɨvgi, mba vhaaŋ thaneŋ thugi fhuvara. ");
INSERT INTO geb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Zisas mbara khaŋ mbe nzuai, “Nde zɨv mbɨ.” Mba Zisas phorga ruigi gumgi, mbe rivgiap, mbe the kha nzambarar ana muuŋgi fhuvara, “Ndu the?” Mbe kaŋgi, ana Guma Bakɨmera. ");
INSERT INTO geb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Zisas mbara vov mba vhava han vugap, mba viktuma ndiga zav mbe ndɨɨi. Ana vhɨra mba mbɨgama ndiga zav, ana phorga mbe ndɨɨi. ");
INSERT INTO geb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Khe Zisas hɨrɨ mpuanin wo phorga ruigi gumgi ga muuŋgia kegap, ana ntige wom mben hɨgi ne khare. Ana rimgia mboga tɨga kegap, khavgiap, vov mben hɨgi. ");
INSERT INTO geb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Zisas wo phorga ruigi gumgi phorga mbega thugap, Zisas kha nzambarar Saimon Pita ga muuŋgi. “Saimon, Zonan kam, ndu guigira na vuzvugirie? Ndu na vuzvugi vuzvuk guigira kha gumgi na vuzvugi vuzvuk kambarigi thi?” Pita mbara khaŋ ana nzuai, “Ahaŋ, Guma Bakɨme, ndu kaŋgi, gu ndu vuzvugi.” Zisas mbara khaŋ ana nzuai, “Ndu nan sipsivi ŋgugi, ndu mba gu bigir mbe ganɨri.” ");
INSERT INTO geb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Zisas wom phenatɨtɨgap ana nzarigi, “Saimon, Zonan kam, ndu na vuzvugire?” Pita mbara khaŋ ana nzuai, “Ahaŋ, Guma Bakɨme, ndu kaŋgi, gu ndu vuzvugi.” Zisas mbara khaŋ ana nzuai, “Ndu nan sipsivi ganɨri.” ");
INSERT INTO geb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Zisas nzambara mpuanin Pita ga muuŋgiap, ana wom khegenen ana mbui. Ana wom khaŋ ana nzuai, “Saimon, Zonan kam, ndu na vuzvugire?” Pita ne mbararagiap, ana Zisas nzambara mpuanin ana muuŋgiap, ana wom khegenen ana muuŋgim, Pita ne nzuav ndav simgi. Pita ndav simgiap khaŋ ana nzuai, “Guma Bakɨme, ndu za kha bigi kaŋgi. Ndu kaŋgi, gu ndu vuzvugi.” Zisas mbara khaŋ ana nzuai, “Ndu mba gu bigir nan sipsivi ganɨri. ");
INSERT INTO geb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Gu guigira ndu nzuai, ndu guman kamara kav, ndu nduara won vhaa rɨgi rɨkava tɨgap, ndu wo vuzvugi ŋaneŋ, ndu nen vui. Ndu vurgiap, ndu farve vun fegim, harigi guma ndun kurav ndun rɨkavar ndu vhaa tɨgap, ndun kov ndu ŋgɨrgeŋ vuzvugi fhuv ŋaneŋ ana ndu ndiga mba ŋanen vui.” ");
INSERT INTO geb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Zisas Pita rimgip zɨ bakɨmen Fhe Bakɨmen nɨɨnga tɨva bun ana nzuai. Ana maaŋ ana suaŋgiap, mbaram khaŋ Pita ga nzuai, “Ndu na zɨn zɨri.” ");
INSERT INTO geb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita dorgap, mba Zisas phorga ruigi guma, ana guigira wo ndavar mba guma ga nɨɨŋgi, ana mba guma garim, ana mani zɨn zi. Mba guma mbe wari tɨga piigiap mba pav, ana wo panan Zisas fheeŋ phorgap, kha nzambarar ana muuŋgi. “Guma Bakɨme, the ndu ndiv, ndun pana gumgi farve khɨngirie?” ");
INSERT INTO geb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita ana garav, kha nzambaren Zisas ga muuŋgi, “Guma Bakɨme, mbu guma ram muuŋgi?” ");
INSERT INTO geb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Zisas ana kameŋ ŋgarkarav khaŋ nzuai, “Na vuzvuk ma. Gu maaŋ muuŋgip vuzvugirga, ana mbara muuŋgip kɨrim, gu taagi zirgɨrga, khe ndu bigeŋ fhuvara. Ndu na zɨn zɨri.” ");
INSERT INTO geb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Maaŋ muuŋgiap, mba kameŋ za mba guigira Zisas khothɨgi gumgir vugi. Mba kameŋ khaŋ nzuai, “Kha Zisas phorga ruigi guma, ana rimgirga fhu.” Zisas ana rimgirga fhup ne nzuai fhuvara. Zakɨra fhuvara! Ana khaŋ suaŋgi, “Na vuzvuk ma. Gu maaŋ muuŋgip vuzvugirga, ana mbara muuŋgip kɨrim, gu taagi zirgɨrga, khe ndu bigeŋ fhuvara.” ");
INSERT INTO geb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Khe ntigem ana phorga ruigi gumara kha gava kherav, ana mba bigi bun nzuai. Khe ana nduara khergi gap khare. Nza ntige kaŋgi, ana khergi buni, nta guigira. ");
INSERT INTO geb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Zisas muuŋgi bigi vhɨrve khar ki. Mbe maaŋ muuŋgip ana muuŋgi bigi, mbe zam nta khergirga, gu ndɨkndɨgi, nzan nuian za mba gavi ndi rɨgɨrga ŋan tuktɨgi fhuvara. Kha nuian za givarga, thari ndi rɨgɨrga ŋan kɨrga fhu.");
INSERT INTO geb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O, Tiofirus, gu mba fharav khergi gap, gu ana kherav, gu mba Zisas fhara guarara won ŋaara bakɨme khavgiap, mba gumgi gu mbigi ana Fhe Bakɨme buni vhuuin mbe khɨvav mbe suaŋgi bigi gu za nta neŋgegi. ");
INSERT INTO geb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Gu nta neŋga vov, mba Fhe Bakɨme taagia ana ndiga Hevenan ndagi nera thɨgi. Fhe Bakɨme zumgum ana ndiga Hevenan ndagi, ana fharav rimgiap, khavgiap, ana vov wo farasegi 11 thɨgi ŋaara gumgir hɨgap, ana Fhe Bakɨme Ŋina Ŋaara ŋkasŋkar panan, ana mbe muunga ŋaari bun mbe suaŋgi. Ana ŋaari bun mbe suaŋgim, Fhe Bakɨme ana ndigap Hevenan ndagi. ");
INSERT INTO geb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Zisas fharav won ŋaara bakɨme mbuav kav, zaa bakɨme ndigap, rimgiap, taagia khavgiap, mbaram vov wo farasegi ŋaara gumgir hɨgi. Ana mben hɨgap, won mbe khɨvav ana bigi vhɨrvera muuŋgi. Ana mba bigir muuŋrim, mbe ana gangip, ana khothɨgɨp khaŋ suanga, “Ana guigira rimgiap taagia khavgi.” Ana mba tɨvar mbe mbuav 40 rarir ana mbe phorga kav Fhe Bakɨme won gumgi gu mbigi ganɨrim, mbe ana piin kɨrga bunin mbe suaŋgi. ");
INSERT INTO geb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ana mba tugir mbe phorgara kav, ana kama havharan khaŋ mbe nzuai, “Nde Zerusaremra kɨri. Nde kɨv mba Fhe Bakɨme nden nɨɨn za suaŋgi bigɨn, nde ana rargɨ kɨri. Gu fhum mba bigɨna bun nde suaŋgi. ");
INSERT INTO geb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Zon Gumgi Ruai Guma, ana fhum mbɨn gumgi gu mbigi ruagi. Nde ntigem rari vhɨrve fhuvara, Fhe Bakɨme won Ŋina Ŋaarar nde ruarga.” ");
INSERT INTO geb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Zisas mba kamen mbe nzuaim, mba ana farasegi 11 thɨgi ŋaara gumgi, mbe wari fugap kha nzambaren ana muuŋgi, “Guma Bakɨme, ndu ntigem taagip kha Isreriŋ ganɨnga guman pana ndim farim, ana mbe ganɨrim, mbe taagip thivgip havhargip zazera mbara muuŋgip kɨrie? Ee, fhuve?” ");
INSERT INTO geb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Mbe mba nzambaren Zisas ga muuŋgim, ana mbe ŋgarkarav khaŋ mbe nzuai, “Khe nde bigeŋ, ee? Nde maaŋ muuŋgip mba bigeŋ hɨrga tuk gum ra nzuav nzaire? Fhuvara! Khe Fhe Bakɨme bigɨn ma. Ana nduara ana mba bigi gari, ana nduara mba bigeŋ tugasɨrga. ");
INSERT INTO geb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nde fhura kɨv ganɨri, ana zumgum won Ŋina Ŋaara sararim, ana nde han zirgɨp, ŋkasŋkan nden nɨɨŋgirim, nde Zerusareman nan buni vhuuiŋ bun suaŋv, za mba Zudia fhain nta bun suaŋv, vhɨra Samaria fhain nta bun suaŋv, ŋgɨp vhɨra kha nuianan za nta bun suaŋri.” ");
INSERT INTO geb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Zisas kha bunin mbe suaŋgia thugim, mbe ana garavra kim, ana mbe thav fhura sigap Hevenan ndai. Ana ndaim, buiva hura mbige za ana vharigim, mbe wom ana gari fhu. ");
INSERT INTO geb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Zisas ndagim, mbe ana nzuav khozrɨgia buiva garav kim, guma phunini, mani shagi huri shargi, mani fhura hav mbe gaar mbar thɨgi. ");
INSERT INTO geb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Mani thɨgap khaŋ mbe nzuai, “Nde kha Gariri gumgi, nde thaŋ nzuav thivgiap, fhura khoga kha buiva garav ki? Kha guma Zisas, Fhe Bakɨme ntigem ana ndigim, ana nde thav Hevenan ndagi. Ana zumgum, nde ana ganɨnga, ana ntigem Hevenan ndagi tɨvara muuŋgip, ana taagi Hevenan kegɨp zirɨrga.” ");
INSERT INTO geb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mba gumani maaŋ mbe suaŋgim, mba Zisas farasegi ŋaara gumgi, mbe mba Oriv mbɨkshɨma thav, wari taagiap Zerusareman vergi. Mba Oriv Mbɨkshɨm, ana Zerusarem hara ki. Anan veri rɨksɨgage kiromita bavira thɨgi. ");
INSERT INTO geb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Mbe Zerusareman vergap, mbe vov, mba zazera ki phenan mba vun ki vundavar ndav anan ki. Mbe mba ki ntɨɨri, mbe zɨri khare, Pita gu Zems, Andru, Firip, Tomas, Bartoromiu, Matiu, Arfisun kam Zems, mba Serotan wari ga rɨgi guma mbe Saimon, Zemsan kam Zudas. ");
INSERT INTO geb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mbe kha gumgi, mbe wari tɨgap ndava bavira kav, mbe wari tɨgap Fhe Bakɨme phorga nzuav wari ki. Mbe mbigi mbari, mbe vhɨra mbe phorga ki. Mba mbigi Zisasan niamuuŋ Maria gum, ana ŋgugi, mbe vhɨra zav, maam mbe phorgav mbe wari tɨgap, Fhe Bakɨme phorga nzuai. ");
INSERT INTO geb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mba tugen, guigira Zisasan buni vhuuiŋ khothɨgap, ana zɨn vui gumgi gu mbigi, mben vhɨrve khaŋ muuŋgi, 120. Mba gumgi gu mbigir vhɨrve kim, Pita khavgiap mben rɨga thɨgap khaŋ nzuai, ");
INSERT INTO geb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Nde nan fegi gu ŋgugi, nde mbarara. Fhum, Fhe Bakɨme Ŋina Ŋaar Devit ga rugim, ana kha kameŋ suaŋgim, ne Fhe Bakɨmen buni vhuuiŋ ki gavar ki. Mba kameŋ khaŋ nzuai, ‘Zudas ana mba tuavar mba gumgi khɨvigim, mbe zav Zisasan suirigi.’ Ntigem, mba Devit suaŋgi kameŋ ne mbara muuŋgiap khar hɨgi. ");
INSERT INTO geb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Zudas, ana fhum nza phorga kav, ana nza kha mbui ŋaarara muuŋgi.” ");
INSERT INTO geb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kha guma Zudas, ana mba tɨva mbatɨgeŋ muuŋgiap, ne vheza ndigap, mbaram wo nzuav nuiana sɨga mueŋ ga vhezgi. Ana mba nuiana sɨgeŋ ga vhezgiap, zumgum ana rav, mba nuiana sɨgeŋ ga rɨgav, ndav furagarɨgap, mbu gum bigi za faŋgia nɨɨaŋ ndarigi. ");
INSERT INTO geb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ana maaŋ muuŋgim, zumgum mba Zerusareman ki gumgi, mbe za ana muuŋgi bigeŋ kaŋgi. Mbe mba bigeŋ kaŋgiap, mbe mba nuiana sɨgeŋ mbe won kaman kha zɨn nen kaai, “Akerdama.” Kha zɨ Akerdama, ne nɨɨeŋ khaŋ nzuai, “Vɨzɨn regi nuianeŋ.” ");
INSERT INTO geb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita mba bunin mbe nzua vov khaŋ nzuai, “Kha kameŋ mbe Ŋgavi Ki Gavar ne khergi, mba kameŋ khaŋ nzuai, ‘Ana mba rɨgi ŋaneŋ, ne fhura kɨri, nde guma the ganɨri, ana mba ŋanen kɨ thari.’ “Mba Fhe Bakɨme buni vhuuiŋ ki gavar ŋana mueŋ mbe khaŋ nzuai, ‘Harigi guma the, ana ŋana ndigip, ana mbui ŋaarar muunga.’ ");
INSERT INTO geb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Maaŋ muuŋgiap, nza nduarira warira rɨgar mba fhum Guma Bakɨme Zisas nzan kov, kha bigi ga ruim, mba zazera nza phorga ruigi guma the, nza ana ndim farga. ");
INSERT INTO geb_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Mba guma Zon Gumgi Ruai Guma mba gumgi gu mbigi ruai tugen kegap, zav Zisas won ŋaara bakɨme khavgiap, ana mbua rui tugen hɨgap, zav, ntigem kha raar Fhe Bakɨme Zisas ndigim, ana nza thav taagia Hevenan ndagi raa thɨgi. Mba nza phorga ruav, za mba Zisas muuŋgi bigi gangi, guma the ndi farim, ana nza phorgɨp kha ŋaarar muuŋv, mba Zisas rimgiap, taagia khavgi ne bun suanga.” ");
INSERT INTO geb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita maaŋ suaŋgiap, mbaram mbe guma phunini ndi fagi. Mbe fagi guma mbe, Zosep, ana zɨ mbe khare, Barsabas. Mbe vhɨra kha zɨ phorga ana kaai Zastus. Harigi ne, Matias. ");
INSERT INTO geb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Mbe mani ndi fav, mani ga nzuav Fhe Bakɨme phorga nzuai. Mbe Fhe Bakɨme phorga nzuav khaŋ nzuai, “O, Guma Bakɨme, ndu za kha gumgi ndavir vheri gum ndɨkndɨgi kaŋgi. Ndu nduara nza khɨvari. Ndu kha gumani rɨgar maaŋgi ne farasarigi, ana Zudas ŋana ndigip, nza Zisas farasegi ŋaara gumgi, ana nza phorgɨp kha ŋaarar muunga. Zudas mba ŋaara thav, ana mba kɨrga ŋgu ana vov anan ki.” ");
INSERT INTO geb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mbe ne Fhe Bakɨme phorga suaŋgiap mbaram, mani heen zav, kɨma phuni ndigap, mani zɨnin mba kɨmɨni khergiap, ni ndi thuuŋ khɨngiap ni tuaŋtuagi. Mbe ni tuaŋtuav kim, mbevi nɨɨeŋ rɨgim, mbe mbaram ana ndigap ana zɨ garim, ana Matias zɨ ana ki. Mbe maaŋ muuŋgiap Matias heigim, ana mba Zisas farasegi 11 thɨgi ŋaara gumgi phorgɨv ŋgarɨrga. ");
INSERT INTO geb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Mba Pentikos tuga bakɨme hɨgim, mba raar mba Zisas khothɨgap ana zɨn vui gumgi gu mbigi, mbe wari fugap, phena mbevi vhen ki. ");
INSERT INTO geb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mbe mba phena vhen wari fugap kim, khɨkhɨma mbe fhura Hevenan hɨgi, mba khɨkhɨm bɨɨŋbɨɨŋ bakɨme fara muuŋgiap zerav, mbe mba ki phena vhee mba khɨkhɨm za mba phena vhee ruigi. ");
INSERT INTO geb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mbe garav, vhava zari fara muuŋgi bigi gari. Mbe nta garim, nta vov za mbe pani shɨri tugɨratɨgap nta thivgi. ");
INSERT INTO geb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Mba bigi mbe pani shɨri thivgim, Fhe Bakɨmen Ŋinan Ŋaar za mbe ndavi vherir vergap, mbe rugim, mbe harigi ŋguir kaa ga vhov buni nzuai. Mbe fhura mba tɨva mbui fhuvara, Fhe Bakɨmen Ŋinan Ŋaar nduara mbe rugim, mbe mba kaa ga vhui. ");
INSERT INTO geb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mba tugen, Zudaiŋ mbari, mbe vhɨra zegap, Zerusareman ki, mbe vhɨra guigira Fhe Bakɨme phorga nzuav ana tɨva zɨn vui ntɨɨri ma. Mbe za kha nuianan ki ŋguian kega zegi. ");
INSERT INTO geb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Mba tugen mba khɨkhɨm him, gumgi gu mbigi vhɨrvera, mbe mba khɨkhɨm mbararagiap, zav wari fugap, mba Zisas farasegi 12 tɨgi ŋaara gumgi nzuai buni, mbe za khuara mbe tɨgi. Mbe khuaran mbe tɨgap, mbe mbararav khueŋ nzuav guigira ŋgava mbatɨga muuŋgi. Mba zegi gumgi gu mbigi, mbe mbe mbararagim, mbe mben kaara vhov mba buni nzuaim, mbe mba buni mbararagi. ");
INSERT INTO geb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mba zegi Zudaiŋ, mbe mbararagiap, ŋgava mbatɨga muuŋgiap khaŋ nzuai, “Ee, kheiŋ Gaririŋ gumgira khare. ");
INSERT INTO geb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nza ram muuŋgiap mbe nzuai buni nza won kaara nta mbararagi. ");
INSERT INTO geb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nza khaŋ muuŋgi ŋgui, nza zega khar ki. Nza mbari Partia fhain kega zegi, nza mbari Midia fhain kega zegi, mbari Eram fhain kega zegi, nza mba Mesopotemia fhain ki gumgi gum Zudia fhain ki gumgi, Kapadosian fhain ki gumgi, Pontus fhain ki gumgi, Esia fhain ki gumgi gum, nza mbari. ");
INSERT INTO geb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia gum Pamfiria fhain kega zegi, nza mbari Idzɨp fhain kega zegi, nza mbari Ribia nder muen, Sairini ŋgu bakɨmen han kega zegi. Nza mbari Roman zegap wari zav khaŋ ndagi. ");
INSERT INTO geb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nza Zudaiŋ gum nza phorgap nza rotu mbui tɨva zɨn vui gumgi, gum Krit rɨgɨkɨrigen kega zegi gumgi, gum Arebian kega zegi gumgi, nza khar zegi gumgi, nza mbe mbararagi, mbe Fhe Bakɨme muuŋgi bigi baikɨvi, mbe nzan kamara nta neŋgim, nza nta mbararagi.” ");
INSERT INTO geb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mba zegi gumgi, mbe maaŋ muuŋgiap mbararagiap, ŋgava mbatɨga muuŋgiap, ndɨkndɨgi vhɨrve ga mbui. Mbe ndɨkndɨgi vhɨrve ga mbuav nduarira khaŋ wari ga nzuai, “Kha ntige hi bigeŋ, ne ram mbui khesharigi bigɨna goreŋra?” ");
INSERT INTO geb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mbe maaŋ wari ga nzuav, mbe mbari mbe nzɨɨv khaŋ mbe nzuai, “Mbe waina kama mbegav ŋanŋana nzuai.” ");
INSERT INTO geb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Mbe maaŋ wari ga nzuaim, Pita mbaram mba Zisas farasegi 12 thɨgi ŋaara gumgi rɨgar khavgia thɨgap, kama havharan kaav khaŋ mba gumgi gum mbigi ga nzuai, “Nde kha Zudaiŋ gum nde mbe zegap kha Zerusareman ki gumgi gu mbigi, nde khuarar na bunin tɨgɨri. Nde khuaran na bunin tɨgɨp, nde ntige khar hi bigeŋ nɨɨeŋ kaŋgirga. ");
INSERT INTO geb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nde ndɨkndɨgi, kha gumgi waina kama mbegav ŋanŋanire? Zakɨra fhuvara! Ntigera mɨn thugim, ra ndav shɨrav nzai, 9 kirok ma. ");
INSERT INTO geb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","17","Nde ntige khar hɨgi bigeŋ, nde ne gari ne fhum Fhe Bakɨmen kamthooŋ guma Zoer ne suaŋgi. Ana fhum khaŋ suaŋgi, ‘Fhe Bakɨme khaŋ nzuai, “Mba mpuur rarivige han maanga, gu won Ŋina Ŋaara siv za kha gumgi gu mbigi ga suarga. Nden ŋkaa gum nde ŋkarmbigi, mbe Fhe Bakɨme kamthooŋ gumgi na buni bun nzuai tɨvar muuŋgip, na buni bun suanga. Nden gumgir ŋkaa, mbe rɨɨa kui tɨvar muuŋgip, bigi ganɨnga, nde gumgi vuri mbe rɨɨr kurga. ");
INSERT INTO geb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Gu mba tugen gu won Ŋina Ŋaara sararim, ana na ŋaara gumgi gum nan ŋaara mbigi han ŋgirɨrga, mbe Fhe Bakɨme kamthooŋ gumgi na buni vhuuiŋ bun nzuai tɨvar muuŋgip na buni bun suanga. ");
INSERT INTO geb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Gu kha buivar gu harigi khesharigi bigir muuŋrim, nta hɨrga, gu mba nuianan mirikorir muunga, mba mirikori, nta mba tugen mba raar hi bigir nde khɨvi mirikori ma. Mba tugen vɨzɨn gum vhav, vhava thuura bakɨme nta hɨrga. ");
INSERT INTO geb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mba tugen, ran ŋaar vhɨzgirga, maaŋ gɨngirga, kɨni hɨvgip vɨzɨna gegɨrga. Mba bigi hegɨrga, zumgum Guma Bakɨme hɨrga tuk hɨgɨrga, ana mba raar ana won ŋkasŋka bakɨme gum won vhava ŋaara ndim khɨvɨrga. ");
INSERT INTO geb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Mba tugen, warir kurkura saŋv Guma Bakɨmen kamɨnga, mba gumgi gu mbigi Guma Bakɨme taagip mbe ndigirim, mbe nzerara kɨrga.” ’ Khe Zoer suaŋgi buni khare. ");
INSERT INTO geb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Nde Isreriŋ gumgi, nde khuaran na bunin tɨgɨri. Gu Nasaret guma Zisas bun nde suan za mbui. Fhe Bakɨme ndera nzuav Zisas ga sarigim, ana zergi. Nde nduarira wari wo rɨmgi thugira ana garim, ana nde rɨgar kav, Fhe Bakɨme ŋkasŋkan panan, won farvenira ana ŋaari bakɨvi ga mbuav, mirikori ga muuŋgi. Fhe Bakɨme ana panan maaŋ muuŋrim, nde gangip kaŋgirga, Fhe Bakɨme nduara ana farasarigi. ");
INSERT INTO geb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Fhe Bakɨme vhɨra fhum kha guman nde farve ga sur zav suaŋgiap, ne ndɨkndɨgap kav, ana ntigem anan nde farve khɨngi. Ana anan nde farve khɨngim, nde mba gumgi mbatɨgir kov hegap, ana ndim khanarareŋ ga tɨgap fugim, ana rimgi. ");
INSERT INTO geb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ana rimgim, Fhe Bakɨme taagia ana khavgi. Ana fhura ana garim, ana rimgiap khurigi fhuvara, ana khaŋ muuŋgiap, ana za rimgip mba mbogar kɨv khurɨv shargirga tuktɨgi fhuvara. Ana rimgi, rɨmrɨm ana suirarga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nzan nzɨga Devit fhum ana ndɨkndɨgap khaŋ suaŋgi, ‘Gu Guma Bakɨme garim, ana guigira zazera na nɨmara ki. Ana nan guva haren kav, ŋkasŋkar na ndɨɨim, bigɨn the nan muuŋgirim, gu rivgip, ninɨga muuŋgirga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Gu maaŋ muuŋgiap na ndava vhee guigira ndikndigim, na thɨɨnin gu ndikndigi bunira nzuai. Gu ndikndigi bunira nzuav, gu kaŋgi, gu rimgirga. Gu Fhe Bakɨme muunga bigir vhuuiŋ, gu ntan rarga ki. ");
INSERT INTO geb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ndu fhura na ganɨrim, na tum za vhɨzgi gumgi ki ŋgun kegɨrga fhuvara. Ndu vhɨra, ndu guigira wo zɨn vui ŋaara guman ŋaar, ndu ana farasarigi. Ndu fhura ana ganɨrim, ana mbogar kɨv, khurgirga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ndu zazera mbara muuŋgip kɨrga bɨɨŋbɨɨŋ ndirga tuap, ndu anan na khɨvigi. Ndu fhura na ganɨrim, gu ndu phorgɨv kɨrim, ndu nan kurkurarim, gu guigira ndikndigɨrga.’ ");
INSERT INTO geb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Nzan nzɨga Devit the ndɨkndɨgap kha buni suaŋgi? Nde nan fegi gum ŋgugi, gu ntigem guigira nza won nzɨga Devit bun nde suan za mbui. Nzan nzɨk Devit, ana rimgim, mbe fhum ana ndim mboga tɨgim, ana tum fhum vurvurigi. Anan tum vurvurigim, ana mbok fhum nzan rɨgar ka zav ntigem khar ki. ");
INSERT INTO geb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nzan nzɨga Devit, ana Fhe Bakɨmen kamthooŋ guma ma. Ana kaŋgi, Fhe Bakɨme guigi guarara taagia wora zitav khaŋ suaŋgi, ‘Gu zumgum ndu shɨgar guma the ndiv farim, ana ndu ŋgui gari guman pan kegi farar muuŋgip, ŋgui gari guman pan kɨrga.’ ");
INSERT INTO geb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Devit maaŋ muuŋgiap kaŋgiap, ana mba kameŋ suaŋgi. Ana Fhe Bakɨme taagiap kha nuianan ki gumgi gu mbigi ndir zav suaŋgiap farasarigi guma, ana ana bun nzuai. Ana rimgip, taagip khavgirga. Ana rimgip za mba vhɨzi gumgi ki ŋgun kegɨrga tuktɨgi fhuvara. Ana vhɨra rimgip khurgirga tuktɨgi fhuvara. ");
INSERT INTO geb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ana ne suaŋgim, Fhe Bakɨme ntigem Zisas rimgim, ana taagia ana khavgi. Ana rimgiap, taagia khavgim, nza za ana gangi. Nza ana gangiap, nza mba bigi, nza nta bun nzuai. ");
INSERT INTO geb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Zisas khavgiap, ana ntigem taagia Fhe Bakɨme han Hevenan ndagi. Ana ndav, Fhe Bakɨmen guva hareŋ ga perav mbur ki. Ana ntigem Fhe Bakɨme won Ŋina Ŋaarar ana nɨɨŋgi, ana fhum mba Ŋina Ŋaarar ana nɨɨn za suaŋgiap, ana ntigem anan ana nɨɨŋgi. Fhe Bakɨme mba Ŋina Ŋaarar ana nɨɨŋgim, ana ntigem mba Ŋina Ŋaara siav nza suagim, nza ana panan ŋgarim, nde ntigem ana mbui bigi garav ana buni mbararagi. ");
INSERT INTO geb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Nzan nzɨk Devit, ana Zisas fara muuŋgiap Hevenan ndagi fhuvara. Khe Devit suaŋgi kameŋ khare. Ana khaŋ nzuai, ‘Fhe Bakɨme khaŋ na Guma Bakɨme nzuai, “Ndu nan guva haren perav kɨrim, gu ndun pana gumgir muuŋrim, mbe ndun piin kɨrga.” ’ ");
INSERT INTO geb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Maaŋ muuŋgiap, nde za Isreriŋ, nde tuituigip khueŋ kaŋgiri. Nde mba khanarareŋ ga tɨga fugi guma Zisas, Fhe Bakɨme ana ndiv Guma Bakɨmen fagim, ana taagip won gumgi gu mbigi ndirga guma ma.” ");
INSERT INTO geb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pita mba buni nzuaim, gumgi gu mbigi vhɨrve, mbe mba buni mbararagim, mba buni guigira mbe thɨgi. Mba buni guigira mbe thivgim, mbe mbaram Pita gum mba ana phorga ŋgari ŋaara gumgi, mbe mben nzarigi. Mbe kha nzambarer mbe muuŋgi. “Nde nzan fegi gum ŋgugi, nde khar nza suaŋ, nza ntige ram muuŋrie?” ");
INSERT INTO geb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Mbe maaŋ nzuaim, Pita khaŋ mbe nzuai, “Nde za bevbevira ndavi domdorgip, Zisas Krais zɨn panan ruagirim, Fhe Bakɨme nde fhum muuŋgi tɨvi mbatɨgi, ana nta vhɨzgip, nta ndɨkndɨk ŋangirga. Nde maaŋ muuŋgirga, Fhe Bakɨme won Ŋina Ŋaarar nden nɨɨŋgirga. ");
INSERT INTO geb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Fhe Bakɨme fhum mba Ŋina Ŋaarar nden nɨɨn za suaŋgi, ana mba Ŋina Ŋaarar nden nɨɨŋv, ana vhɨra mba Ŋina Ŋaarar nden tarir nɨɨnga. Ana vhɨra mba saman harigi ŋguir ki gumgi gu mbigi gum zumgum hɨrga gumgi gu mbigi, ana vhɨra anan mben nɨɨnga. Nzan Fhe Bakɨme, ana mba kamgi gumgi gu mbigi, ana za won Ŋina Ŋaarar mben nɨɨn za suaŋgi.” ");
INSERT INTO geb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita mba bunin mbe nzua vov, ana vhɨra harigi buni vhɨrve phorga mbe suaŋgi. Ana kama havharar mbe nzuav, khaŋ mbe nzuai, “Nde warir rɨvɨri. Nde muuŋv kɨv mbarkɨrga tɨvi mbatɨgi ga mbui gumgi phorgɨv mbatɨgirga.” ");
INSERT INTO geb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pita mba bunin mbe nzuaim, ana buni guigira gumgi gu mbigi vhɨrve thivgim, mbe ndavi domdorav Zisas zɨn panan wari ruai. Mba raan ndavi domdorgiav, Zisas zɨn vui gumgi gu mbigi mben vhɨrve khaŋ muuŋgi 3,000. Mbe zav Zisas khothivav, ana zɨn vui gumgi gu mbigi vhen vergi. ");
INSERT INTO geb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Mba gumgi gu mbigi, mbe guigira khaŋ tɨgav mba Zisas farasegi ŋaara gumgi nzuai buni mbararagi. Mbe mbe buni mbararav, mbe wari tɨgap ndava bavira kav mben kurkurav mbe wari phorga mba pav, wari tɨgap viktum gum mbɨ pav, mbe wari tɨgap phogi ga vhuav Fhe Bakɨme phorga nzuai. ");
INSERT INTO geb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mbe maaŋ mbuim, mba Zisas farasegi ŋaara gumgi, mbe Fhe Bakɨmen ŋkasŋkar panan mirikori vhɨrve ga mbuim, mba gumgi gu mbigi, mbe nta garav za ŋgava mbatɨga mbuav, wari rɨvi. ");
INSERT INTO geb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Mbe rɨvim, mba Zisas khothɨgav ana zɨn vui gumgi gu mbigi, mbe guigira za ndava bavira wari tɨgap ki. Mbe wari wo bigi gari, mbe bigi, nta za mba Zisas khothɨgap ana zɨn vui gumgi gu mbigi, mba bigi, nta za mbe bigi ma. ");
INSERT INTO geb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Mbe mba tɨva mbuav, mbe vhɨra wari won nuiani sɨgiveŋ gu bigi ndi mbaim, harigi gumgi nta vhezim, mbe mba ŋkɨɨar, mba mba gum bigi sosuagi gumgi gu mbigir kurkurigi. ");
INSERT INTO geb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Mbe maaŋ mbuav, mbe zazera rari tugɨra tɨgap wari tɨgap Fhe Bakɨme Phenan phogi ga vhui. Mbe maaŋ mbuav, mbe vhɨra wari ga nzuav, warir kaav, wari won phenin vov, ndava bavira kav, ndikndigap wari phorga pi. ");
INSERT INTO geb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Mbe mba tɨva mbuav, mbe zazera Fhe Bakɨme zɨ ndiv vun kuamkuagim, mba gumgi gu mbigi ndɨkndɨgar vhuun mbe mbui. Mbe maaŋ mbuim, Guma Bakɨme rari tugɨra tɨgap gumgi gu mbigi ndi. Ana maaŋ mbuim, mba Zisas khothɨgap ana zɨn vui gumgi gu mbigi, mben vhɨrve khaŋ tɨgap vɨrkɨvgi. ");
INSERT INTO geb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Raa mben, ra vera vov ŋkotuguraagen phuni khegene ndim, Zudaiŋ Fhe Bakɨme phorgɨ suanga tuk ma. Maaŋ muuŋgiap, Pita gum Zon Fhe Bakɨme phorgɨv suan zav Fhe Bakɨme Phenan vui. ");
INSERT INTO geb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mani vov garim, gumgi mbari, mbe suani mbatɨgi guma mbe ndiga zi. Mba guma, ana won niamuuŋ ndava vhera kim, ana suani mbatɨgim, ana niamuuŋ ana ruagi. Mbe zazera rari tugɨratɨgap mba guma ndia zav, Fhe Bakɨme phena bɨna vhen mbe kha zɨn rɨgi thɨmkamani han fim, ana maaŋ pigi. Mba thɨmkamani zɨ khare, Thɨmkaman Vhuuni. Mbe ana ndim maaŋ fim, ana maaŋ kav garim, gumgi gu mbigi mbe Fhe Bakɨme phena bɨna vhen verav zim, ana ŋkɨɨa mben nzai. ");
INSERT INTO geb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Mba guma, ana perav kav Pita gum Zon garim, mani Fhe Bakɨme phena bɨna vhen ŋgirɨ za mbuim, ana mbaram ŋkɨɨa manin nzai. ");
INSERT INTO geb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ana manin nzaim, Pita gu Zon khɨra ana garav, Pita khaŋ ana nzuai, “Ndu ŋka ganɨ.” ");
INSERT INTO geb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Pita maaŋ ana nzuaim, mba suani mbatɨgi guma, ana khueŋ ndɨkndɨgap khɨrav mani gari, mani ŋkɨɨar anan nɨɨnga thi. ");
INSERT INTO geb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ana ne ndɨkndɨgap khɨra mani garim, Pita thav khaŋ ana nzuai, “Gu ŋkɨɨa ki fhuvara. Gu ki bigɨn, gu ana ndun nɨɨn za mbui. Gu Nasaret guma Zisas zɨn pananan ndu nzuai, ndu khavgiv thivɨv ruu.” ");
INSERT INTO geb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pita nen ana suaŋgiap, mbaram vov anan guva hareŋ suirav, ana nzuaim, ana khavgia thɨgi. Ana ana nzuaim, ana khava thivara thav, ana gɨzani gum ana suani havhargim, ana nzerara thɨgi. ");
INSERT INTO geb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ana vhemkora khavgia thɨgap rui. Ana thɨga, ruav mani phorga vov Fhe Bakɨme phena bɨna vhen vergap, thɨva ruav, ndikndigap, fomba ga ruav, Fhe Bakɨme zɨ ndiv vun kuamkuagi. ");
INSERT INTO geb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ana Fhe Bakɨme zɨ ndim vun kuamkua ga ruim, mba gumgi gu mbigi ana gari. ");
INSERT INTO geb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Mbe ana gangiap ana kaŋgi, ana mba zazera mba Fhe Bakɨme phena bɨna vhen mbe kha zɨn rɨgi thɨmkamani ga pigav, ŋkɨɨa ga nzuav nzai guma ma. Mba thɨmkamani zɨ khare, Thɨmkama Vhuuni. Mbe ana garim, ana suani nzerarga ruim, mbe ana gangiap, ŋgava mbatɨga muuŋgiap, ndɨkndɨgi vhɨrve ga mbuav, mben ndɨkndɨgi tivgi. ");
INSERT INTO geb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mba gumgi gu mbigi mba guman hɨgi bigeŋ mbararagiap, ŋgava mbatɨga muuŋgiap, khuafa zav mba guma gari. Mbe zav mba guma garim, ana Pita gum Zon suirav, mbe mba Fhe Bakɨme phena bɨna vhen kha zɨn rɨgi vunkameŋ thɨgap ki. Mba vunkameŋ zɨ khare, Soromon Vunkameŋ. ");
INSERT INTO geb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Mba gumgi gu mbigi ŋgava mbatɨga muuŋgiap khuafua zav ana garim, Pita mba tɨva gangiap, khaŋ mba gumgi gu mbigi ga nzuai, “Nde kha Isreriŋ gumgi gu mbigi, nde thaŋ nzuav kha hɨgi bigeŋ gangiap, ne ga nzuav, ŋgava mbatɨga mbui? Nde thaŋ nzuav khɨra ŋka gari? Ee, nde kha ndɨkndɨgar ŋka mbui thi, ŋka nuanira ŋkasŋka bakɨme kav o, ŋka vhɨra Fhe Bakɨme nɨman nzerara kav, ŋka kha guma ga muuŋgim, ana suani nzerav rui thi? Zakɨra fhuvara! ");
INSERT INTO geb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham gum Aisak, Zekop, nzan nzɨgir, Fhe Bakɨme, ana guigira zɨ bakɨmen won ŋaara guma Zisas ga nɨɨŋgi. Mba gumara, nde anan ana pana gumgi farve khɨngi. Mba tugen Pairat ana fhɨrgirim, ana ŋgɨr za mbuim, nde ana shashagiap, kɨr ana segap, khaŋ Pairat ga nzuai, ‘Pairat ndu ana fhɨrgirim ana ŋgɨ thari.’ ");
INSERT INTO geb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mba guma, ana guigira Fhe Bakɨmen piin ki guma ma. Ana guigira guman ŋaar ma, ana vhɨra tɨvir vhuuiŋra mbui guma ma. Nde ana thav, ana shashagiap, kɨr ana segap, Pairat ga nzuaim, ana harigi guma fhɨrgim, ana nde han vugi. Mba Pairat fhɨrgim, nde han vugi guma, ana guma shogi ana rimgi guma ma. ");
INSERT INTO geb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nde mba shogi rimgi guma, ana guigira fharigi guma ma. Ana nza ndigip, mba zazera mbara muuŋgip kɨrga tuavar vui guma ma. Nde ana shogim, ana rimgim, Fhe Bakɨme taagia ana khavgim, ŋka won rɨmanira ana gangiap, ŋka mba bigi bun nde nzuai. ");
INSERT INTO geb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ŋka Zisas khothɨgi, kha guma nde ana gari, ana vhɨra Zisas khothɨgap, ana Zisas zɨn panan ana suani gum gɨzani ŋkasŋkagim, ana khavgia thɨga rui. Zisas, ana nduara ŋka ana khothɨgim, ana ŋka ana khothɨgi tɨva muuŋgim, ana havhargi. Ŋka ana khothɨgi tɨvara ana kha guma ga muuŋgim, ana ntigem nzerav thiva ruim, nde ntigem ana gari. ");
INSERT INTO geb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Nde ŋkan fegutari khueŋ guigira, gu kaŋgi, nde wari wo gumgir panin kov, nde tuituigia khueŋ kaŋgi fhuvara, ndera kha tɨvar Zisas ga muuŋgi. ");
INSERT INTO geb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Mba tɨv fhum Fhe Bakɨme won kamthooŋ gumgi ga suaŋgim, mbe mba kameŋ suaŋgi. Kha guma, ana ana farasarigi, ana taagip wo gumgi gu mbigi ndirga, ana fharav zaa ndigirga. Nde ntigem khar muuŋgi bigeŋ ne Fhe Bakɨme suaŋgi kamera zɨn vugav mba tegi. ");
INSERT INTO geb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Nde maaŋ muuŋgip gangip, wari ndɨkndɨgɨp ndavi domdorgirim, Fhe Bakɨme nde fhum muuŋgi tɨvi mbatɨgi, ana nta vhɨzgip, nta ndɨkndɨk ŋangirga. ");
INSERT INTO geb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nde maaŋ muuŋgirga, Guma Bakɨme ŋkasŋkar kaman nden nɨɨŋgirga. Ana ŋkasŋkar kaman nden nɨɨŋgirga, ana mba taagia kha nuianan ki gumgi gu mbigi ndir zav suaŋgiap farasarigi guma, ana ana sararim, ana nde han zirɨrga. Mba guma Fhe Bakɨme nden kurkura zav farasarigi guma ma, mba gumara khare, Zisas. ");
INSERT INTO geb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ana ntigem Hevenan kav, mba Fhe Bakɨme sarigi tugar rarga ki. Mba tugar Fhe Bakɨme taagip kha bigir muuŋgirim, nta fhum ana fhara guarara nta muuŋgi farar muuŋgirga. Ana fhum ntan muun zav, mba kamen wo kamthooŋ gumgir ŋaari ga suaŋgi. Mbe ana ŋaara mbuav ne bun suaŋgi. ");
INSERT INTO geb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Fhum ana ŋaara guma Moses kha suaŋgi, ‘Nden Fhe Bakɨme, ana nde phorge rɨgi guma thera ndi farim, ana na farar muuŋgip, ana kamthooŋ guma kɨrga. Nde ana nzuai buni, nde za nta zɨn ŋgɨri. ");
INSERT INTO geb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mba Fhe Bakɨme kamthooŋ guma nzuai buni mbararagi fhuv gumgi, mbe mba Isreriŋ gumgi gu mbigi phorgɨ kegɨrga tuktɨgi fhuvara, mbe vhɨzgirga.’ ");
INSERT INTO geb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Mba fhum Fhe Bakɨme buni vhuuiŋ bun suaŋgi kaathoori gumgi, mba Fhe Bakɨme kamthooŋ guma mbe Samuer, gum zumgum ana zɨn hegi Fhe Bakɨmen kaathoori gumgi, mbe mba suaŋgi bigi hɨrga tuk, ana ntigem hɨgi. ");
INSERT INTO geb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Nde Fhe Bakɨmen kathoori gumgi tegi tari ma. Nde mba Fhe Bakɨme nɨɨn za suaŋgi bigi ndirga gumgi ma. Fhe Bakɨme fhum nden nzɨgi phorga nzuav mba kamen mbe suaŋgi. Ana khaŋ nden nzɨga Abraham ga suaŋgi. ‘Gu ndun nzɨga the panan, gu tɨvar vhuun kha nuianan ki gumgi gu mbigir muunga!’ ");
INSERT INTO geb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ana maaŋ suaŋgiap, ana mbaram fharav won ŋaara guma ga sarigim, ana zergap fhara nde han zɨgap, tɨvar vhuueŋ mbuim, nde bevbevira wari wo mbui tɨvi mbatɨgi, nde nta thamthagi.” ");
INSERT INTO geb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita gum Zon mba bunin mba gumgi gu mbigi ga nzuavra kim, mba Fhe Bakɨme rotu gari gumgi gum, mba Fhe Bakɨme Phena gari gɨɨtɨvir guman pan gum, mba Sadusiŋ gumgi, mbe hegi. ");
INSERT INTO geb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Mbe khueŋ kaŋgi, mani Zisas rimgiap, taagia khavgi ne bun mba gumgi gu mbigi ga nzuai. Mani vhɨra khaŋ mbe nzuai, “Zisas taagia khavgim, mba vhɨzgi gumgi gu mbigi, mbe vhɨra taagip khavɨrga.” Mbe maaŋ muuŋgiap ne nzuav mani ga vhegi. ");
INSERT INTO geb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mbe ne nzuav mani suirav, mani ga suaŋv suan za mbui. Mbe mani ga suaŋv suan za mbuim, ra verav vhɨzgim, mbe thav mani ndim bɨna khɨngi. Mbe gurmaŋgip mani ga suanga. ");
INSERT INTO geb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mani mba Zisas rimgia taagia khavgim, mani ne bun mba gumgi gu mbigi ga nzuaim, gumgi gu mbigi vhɨrve, mbe Zisas khothɨgi. Mba Zisas khothɨgi gumgira, mben vhɨrve khaŋ muuŋgi, 5,000. ");
INSERT INTO geb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mba mɨtimanera mba Zudain gumgir ruu gum, mben gumgir pani gum, mba Zudaiŋ tɨvir vhuuiŋ kaŋgi gumgi, mbe zav, Zerusareman wari fugi. ");
INSERT INTO geb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Mbe wari fugim, Fhe Bakɨme rotu gari guman panani, Anas gum Kaiafas, Zon gum, Areksander gum, mba Fhe Bakɨme rotu gari guman pana ntɨɨri, mbe zav mbe phorgap wari fugi. ");
INSERT INTO geb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mbe wari fugim, mbe Pita gum Zon ndigap, mben nɨman fav khaŋ nzambarer mani ga mbui, “Ŋko ram mbui khesharigi ŋkasŋka ndigap, kha khesharigi bigi ga mbui? Ŋko the zɨn panan mbui?” ");
INSERT INTO geb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Mbe mba nzambarer mani ga muuŋgim, Fhe Bakɨmen Ŋina Ŋaar guigira Pita phorga kav ana rugim, ana khaŋ mbe nzuai, “Nde kha Isreriŋ gumgir ruu gum mben gumgir pani, nde ntigem, ŋka kha suani mbatɨgi guma ŋka ana kurigim, nde ne nzuav ŋkan nzaire? Ee, nde khueŋ kaŋgi zav nzai ti, kha guma ana ram muuŋgiap nzerigi. ");
INSERT INTO geb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nde maaŋ muuŋgip ne kaŋgir saŋv, nde zam khueŋ kaŋgiri, nde Isreriŋ, nde vhɨra za khueŋ kaŋgiri, kha suani mbatɨgi guma, ana Nasaret guma Zisas Krais zɨn panan, ana suani guigira nzerigim, ana ntigem nde nɨman khar thɨgi. Kha guma Zisas, ndera ana shogiap, ana ndim khanarareŋ ga tɨga fugim, ana rimgim, Fhe Bakɨme taagia ana khavgi. ");
INSERT INTO geb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Zisas ana mba pheni ga mbui kɨm ma. Mba pheni ga mbui gumgi ana gangiap, khaŋ ana nzuai, ‘Ana kɨma mbatɨk ma.’ Mbe maaŋ ana suaŋgiap, ana thav ana ndi mbur ndarigi. Ana ntigem ana fharav mba phena bɨna suirigim, ana havhargi. ");
INSERT INTO geb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nde khueŋ kaŋgiri, taagip nza ndigirga guma the ki fhu. Zakɨra fhuvara! Kha guma Zisasra, Fhe Bakɨme ana farasarigi, nza ana zɨn panan, nza kha nuianan ki gumgi gu mbigi, ana taagip nza ndigirga.” ");
INSERT INTO geb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mba gumgi ruu, mbe Pita gu Zon kaŋgi, mani sure muuŋgi gumani fhuvara. Mani guma khɨnani ma. Mbe mani garim, mani rɨvi fhu, mani khaŋ tɨgap Fhe Bakɨme buni vhuuiŋ bun nzuaim, mbe mani gangiap, ndɨkndɨgi vhɨrve ga mbui. Mbe mba ndɨkndɨgar mani ga mbuav, mbe vhɨra kaŋgi, mani fhum Zisas phorga kegi. ");
INSERT INTO geb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mbe ne kaŋgiap, mbe mba guma garim, ana ntige nzerav mani phorga kim, mbe mani nzuai buna thueŋ ŋgarkarga kama thueŋ ki fhu. ");
INSERT INTO geb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mbe thav mani ga sarigim, mani mba buaadegi gumgir pani phena thav kɨrar hɨgi. Mani kɨrar hɨgap vugim, mba g