﻿USE sofia;
DROP TABLE IF EXISTS sofia.gdr_vpl;
CREATE TABLE gdr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gdr_vpl WRITE;
INSERT INTO gdr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Sɨ ɨtemb jɨ Yesu Kerisomna b'usmureni nya gatab ɨrɨki yɨt, yete re Dawidɨm pɨlke b'usmureni b'ɨga dɨde Abraamɨm pɨlke b'usmureni b'ɨga. ");
INSERT INTO gdr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Sɨ Abraam Isakɨnd yorakonj, ɨ daka Isak Yakobɨnd yorakonj, ɨ daka Yakob Yudand dɨde ti nanywar dɨde ti yɨngganwar arakinonj, ");
INSERT INTO gdr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ɨ daka Yuda Tamarɨm pɨlɨnd Peres ake Jera arakonj, ɨ daka Peres Esromɨnd yorakonj, ɨ daka Esrom Ramɨnd yorakonj, ");
INSERT INTO gdr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ɨ daka Ram Aminadabɨnd yorakonj, ɨ daka Aminadab Naasonɨnd yorakonj, ɨ daka Naason Salmonɨnd yorakonj, ");
INSERT INTO gdr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ɨ daka Salmon Yeriko kongga Raabɨm pɨlɨnd Boasɨnd yorakonj, ɨ daka Boas Rutɨm pɨlɨnd Obedɨnd yorakonj, ɨ daka Obed Yesaind yorakonj, ");
INSERT INTO gdr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ɨ daka Yesai king Dawidɨnd yorakonj. Ɨ daka Dawid Uriyamna konggam pɨlɨnd Solomonɨnd yorakonj, ");
INSERT INTO gdr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ɨ daka Solomon Roboamɨnd yorakonj, ɨ daka Roboam Abiyand yorakonj, ɨ daka Abiya Asand yorakonj, ");
INSERT INTO gdr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ɨ daka Asa Yosapatɨnd yorakonj, ɨ daka Yosapat Yoramɨnd yorakonj, ɨ daka Yoram Ujiyand yorakonj, ");
INSERT INTO gdr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ɨ daka Ujiya Yotamɨnd yorakonj, ɨ daka Yotam Aajɨnd yorakonj, ɨ daka Aaj Ejekiyand yorakonj, ");
INSERT INTO gdr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ɨ daka Ejekiya Manasend yorakonj, ɨ daka Manase Amosɨnd yorakonj, ɨ daka Amos Yosiyand yorakonj, ");
INSERT INTO gdr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ɨ daka Yosiya Yekoniyand dɨde ti nanywar dɨde ti yɨngganwar arakinonj, onggɨt wɨnɨnd re Babilon kantrit Yuda kantri negɨr yomnonj dɨde Ju rɨga Babilon kantri wa werenam omnam amninonj. ");
INSERT INTO gdr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ɨ onggɨt kak ke re ket Ju rɨga Babilon kantri wa werento, Yekoniya Salatiyelɨnd yorakonj, ɨ daka Salatiyel Jerubabelɨnd yorakonj, ");
INSERT INTO gdr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ɨ daka Jerubabel Abiyudɨnd yorakonj, ɨ daka Abiyud Eliyakimɨnd yorakonj, ɨ daka Eliyakim Ajorɨnd yorakonj, ");
INSERT INTO gdr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ɨ daka Ajor Sadokɨnd yorakonj, ɨ daka Sadok Akimɨnd yorakonj, ɨ daka Akim Eliyudɨnd yorakonj, ");
INSERT INTO gdr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ɨ daka Eliyud Eleajarɨnd yorakonj, ɨ daka Eleajar Matanɨnd yorakonj, ɨ daka Matan Yakobɨnd yorakonj, ");
INSERT INTO gdr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ɨ daka Yakob Mariyam leo Yosepɨnd yorakonj. Ɨ Yosepɨm kongga Mariya Yesund yukendonj yena re yogenayo da Keriso. ");
INSERT INTO gdr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Sɨ ket Abraamɨm pɨlke b'usmureni b'ɨga de Dawidɨm pɨlwa re komkesa potin (14) b'usmureni b'ɨga na. Ɨ daka Dawidɨm pɨlke b'usmureni b'ɨga de ngɨrpu Ju rɨga Babilon kantri wa werento re kwa potin (14) b'usmureni b'ɨga na. Ɨ kwa daka Babilon kantri wereni ke b'usmureni b'ɨga de Kerisom pɨlwa re kwa potin (14) b'usmureni b'ɨga na. ");
INSERT INTO gdr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ɨ Yesu Kerisomna ukendi yɨt re ɨja emb jɨ. Sɨ Ti mog Mariya re kea yɨt tɨrɨr omni na wɨbnawonj Yosep kɨma molkongga awowɨm. Ɨ yɨmta kena ton molkongga awonda, ajɨ Mariya kea naska nata ngor kɨma awonj rɨna re Yɨnayɨna Wɨngawɨngat b'ɨga yoramitonj ti pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ajɨ ti leo Yosep re negɨr kesa dɨmdɨmjog rɨga na. Sɨ ton kea wumɨr yokatonj ti konggamna ngor kɨma gatab yɨt, ajɨ ton ma singi na ti konggand rɨga wa pɨlwa pɨta tomɨny negɨr ma b'ɨsagɨka okatam tina ngor kɨma ai mopɨp. Sɨ ton ket ti nony mana yɨsamkonj wɨgawɨga tin bondɨk omnam. ");
INSERT INTO gdr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ɨ re Yosep onggɨtyam yɨt nonyɨk b'amdenand yɨbnonj, yɨpa Yonggyamɨmna aneru pɨta awonj ti wɨmand, ɨ ket tin yomnonj da, “Yosep, Dawidɨmna b'ɨga! Man goro moga taet Mariyand okatam mor konggam. Mop nokɨp B'ɨga rɨnte re yɨbɨm ti kom borand re Yɨnayɨna Wɨngawɨngamna oramiti e. ");
INSERT INTO gdr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Sɨ ton ɨta leo b'ɨga ukenj dem, ɨ man b'ogla onggɨt B'ɨgand nyɨ oeket dem da ‘Yesu’. Mop nokɨp Ton opima Tina rɨga tetrɨngasiny dem towaina negɨr mɨle wa pɨlke, ɨ ket yɨrkokar takainy dem.” ");
INSERT INTO gdr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Sɨ komkesa onggɨtyam mɨle aukɨto re nok mana da ɨdenat Yonggyamɨmna yɨtkak rɨrɨrkɨp tainy rɨna re yɨpa bageyamɨmna tugɨm ke yopulitonj da, ");
INSERT INTO gdr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Yɨr de, yɨpa pɨl esopai kesa ngɨmngai ɨta ngor kɨma tainy dem dɨde ket ton leo B'ɨga ukenj dem. Ɨ rɨgap ket tin nyɨ ogenai dem da ‘Emmanuwel’.” Sɨ Emmanuwel engenda yɨtkak re noke da, “God ɨta men kɨma”. ");
INSERT INTO gdr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ɨ re ket Yosep yutunga ke utnyitonj, sɨ ton ket ɨja na mɨle amnɨkinonj rɨja na re Yonggyamɨmna anerut tin yingawonj omnɨkam, ngɨrpu ton ket Mariyand ti konggam wokatonj. ");
INSERT INTO gdr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ɨ Yosep maka Mariyand pɨl wesopayonj, ngɨrpu ton ket leo B'ɨga yukendonj. Ɨ ton ket onggɨt leo B'ɨgand nyɨ yoekonj da “Yesu”. ");
INSERT INTO gdr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ɨ re Yesu ukendonj Betleem taunɨnd de Yuda eriyand, onggɨt wɨnɨnd Erod Yuda king pɨpmet nat yɨbnonj. Ɨ nɨnda b'ogɨl multekɨp rɨga ɨlemet ke opekto de Yerusalem taun wa. ");
INSERT INTO gdr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ɨ ton ket rɨga erkena eyento da, “Rokate Ju rɨga waina king yɨbɨm yet re ukenjɨm. Nokɨp sɨn kea Tina ɨki yɨr yongonda ɨlitand sowa tunggɨnd deta ɨlemet gatab wa ɨ sɨn ket tuyɨn re tin kumsos emka mim.” ");
INSERT INTO gdr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ɨ re king Erod onggɨt Ju rɨga waina king ukenda gatab yɨt utkundonj, ton ma sobijog na nony bebɨg awonj. Ɨ toda kwa kea komkesa Yerusalem rɨga gar moga aukɨto onggɨt B'ɨga gatabɨm. ");
INSERT INTO gdr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ɨ ket king Erod komkesa yɨna mopyam sɨ rɨga dɨde Ju rɨga waina gog ouyaena rɨga ara emokinonj b'eomam. Ɨ ton ket ten arkisinonj da, “Rokate dɨkɨnd Keriso tukenj.” ");
INSERT INTO gdr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ɨ ton ket mɨra yomno da, “Ama de Betleem taun wa Yuda eriyand, mop nokɨp yɨpa bageyam ɨja naemb jɨ yɨrɨkonj da, ");
INSERT INTO gdr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Sɨ man Betleem taun, Yuda gowɨnd, man ma sobijogjog et Yuda kantri wɨp omnena rɨga wa wɨngɨrɨnd. Mop nokɨp mor pɨlke yɨpa wɨp omnena rɨga ɨta pɨta tainy. Sɨ Tontemb Koina rɨga, Israel rɨga waina yɨr ɨpka rɨga tainy, mamoi yɨr ɨpka rɨga re dɨde.’” ");
INSERT INTO gdr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ɨ ket king Erod opimemb b'ogɨl multekɨp rɨga wɨgawɨga ara emokinonj, ɨ ket towa pɨlke b'obogɨl wumɨr awonj ɨmɨnjog wɨn gatab rɨdenat re onggɨtyam ɨki pɨta awonj. ");
INSERT INTO gdr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ɨ re king Erod ten etmɨkisinonj Betleem taun wa, ton yɨt atainonj da, “Ra wɨn wuyɨt, wɨn b'obogɨl oraka iyenya onggɨt B'ɨgand. Ɨ ra wɨn odarya, wɨn b'ogla odenja kor bage yɨt nɨtmɨkitaya, nokɨm da ra kodaka neken dem Ti pɨlwa, ɨdenat kon Ti pɨlwa kumsos b'atɨmken dem.” ");
INSERT INTO gdr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ɨ re ket ton king Erodɨmna yɨt utkunda seg auto, ajɨ re ket ton menonɨm auto, odenja ket ɨtemb ɨki pɨta awonj rɨna re ton naskajog yɨr yongo ɨlitand deta ɨlemet gatab wa. Ɨ onggɨt ɨkit ten wɨp amninonj, ngɨrpu dea de ton opekto rɨkɨnd re ɨtemb B'ɨga yɨbnonj, ɨ omandemb ɨki ena awonj onggɨt pɨpmet tunkɨpjogɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ɨ re ton ɨtemb ɨki yɨr yongo, ton ma sobijog na ukoi sam omnɨka yiyeno. ");
INSERT INTO gdr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ɨ re ket ton onggɨt met wa b'ɨgarkɨto rɨkɨnd re ɨtemb B'ɨga yɨbnonj, ton kea ɨtemb B'ɨga yɨr yongo Ti mog Mariya kɨma, dɨde ket ton Ti pɨlwa kumsos b'amkɨto ewangayam. Ɨ ton ket b'ogɨljog gasa oramkapu ga epangkɨto dɨde ket kear gasa Ti yogonto, opi re gold ɨ b'ogɨl ngɨrangngɨrang pauda ɨ dɨde b'ogɨl ngɨrangngɨrang wulpoj. ");
INSERT INTO gdr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ɨ ket God wɨma ke opimemb jɨ b'ogɨl multekɨp rɨga nonony amninonj da, “Goro king Erodɨm pɨlwa tɨtekinam.” Sɨ ton ket b'enga nya nata ɨtekto towaina kantri wa. ");
INSERT INTO gdr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ɨ re ket opimemb b'ogɨl multekɨp rɨga ɨtekto, ɨ ket yɨpa Yonggyamɨmna aneru wɨmand pɨta awonj Yosepɨm pɨlwa. Ɨ ton ket yomnonj da, “Utnyite, dɨde ɨtemb B'ɨga ake Ti mog akate, ɨ dɨde ket b'ɨtkenyɨt Ejipt kantri wa! Sɨ wɨn adea de wɨmena tuwenyɨt, ngɨrpu ra kon men wumɨr motɨnyɨn dem kwa ɨtendam. Mop nokɨp yu king Erod ɨta onggɨt B'ɨgand oraka yiyeny Tin ongandam.” ");
INSERT INTO gdr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Sɨ ket onggɨt sɨwɨnyɨnd Yosep utnyitonj, ɨ ket ɨtemb B'ɨga ake Ti mog akatonj, ɨ dɨde ket yiwatonj Ejipt kantri wa. ");
INSERT INTO gdr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ɨ Yosep ket adea de ɨtemb B'ɨga ake Ti mog kɨma wekenenonj, ngɨrpu king Erod uj awonj. Nokɨm da ɨdenat yɨmta ke Yonggyamɨmna yɨtkak rɨrɨrkɨp tainy rɨna re Ton yɨpa bageyamɨmna tugɨm ke yopulitonj. Sɨ ton ɨja naemb jɨ yopulitonj da, “Kon kea Koina B'ɨgand ara yemokond Ejipt kantri ke opendam.” ");
INSERT INTO gdr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ɨ re ket king Erod wumɨr yokatonj da onggɨt b'ogɨl multekɨp rɨgap kea tin rabem yomno, ton ma sobijog soro na awonj. Sɨ ton ket tina geja rɨga etmɨkisinonj komkesa leo b'ɨga uj ondrɨkam yepiya re Betleem taunɨnd dɨde onggɨt taun wuswus tungg nata wekenonj, ɨ yepiya re nɨmog kemag kɨma dɨde towa wɨra ke kemag kɨma wekenonj. Sɨ Erod odede kemag agenkinonj re onggɨt wɨn rɨrɨr nat rɨna re ton b'obogɨl wumɨr yokatonj onggɨt b'ogɨl multekɨp rɨga wa pɨlke. ");
INSERT INTO gdr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Sɨ odede nya ke kea bageyam Yeremiyamna tugɨm ke opureni onggɨtyam yɨtkak rɨrɨrkɨp awonj. ");
INSERT INTO gdr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Sɨ ton ɨja naemb jɨ yopulitonj da, “Ɨta rɨgap yii b'aena nonykok utkundenyi Ramand. Ɨ ɨtemb re gar kopa kɨma yii b'ɨrɨnena e dɨde ukoijog yii iyagɨka e. Ɨ Rael opima ti b'ɨgawar yii iyagɨka eyeniny, sɨ ton ma singi o gar ngɨmbla awowɨm, nokɨp tina b'ɨga re kea b'eomnento.” ");
INSERT INTO gdr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ɨ onggɨt kak ke re ket king Erod uj awonj, Yonggyamɨmna aneru wɨma ke pɨta awonj Yosepɨm pɨlwa de Ejipt kantrind. ");
INSERT INTO gdr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ɨ ton ket yomnonj da, “Utnyite! Ɨ ɨtemb B'ɨga ake Ti mog akate, ɨ dɨde ket meke Israel gou wa! Mop nokɨp rɨga yepiya re oraka yiyeno ɨtemb B'ɨgamna yɨrkokar eomnenam re kea uj aukom.” ");
INSERT INTO gdr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Sɨ Yosep utnyitonj, ɨ ket ɨtemb B'ɨga dɨde Ti mog akatonj, ɨ dɨde ket wuwonj Israel gou wa. ");
INSERT INTO gdr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ɨ re Yosep utkundonj da Arkelao Yuda eriya king nyɨ yokatonj rɨna re ti b'u king Erod yɨraronj, sɨ ton re moga na awonj de Yuda eriya wa menonɨm. Ajɨ re ton wɨma ke b'ingawa yɨt yokatonj, ton ket yiwatonj Galili eriya wa. ");
INSERT INTO gdr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ɨ ton ket yikonj yɨpa taun wa ogenaya da Najaret, dɨde ket ademb de yɨbnenenonj ɨtemb B'ɨga ake Ti mog kɨma. Sɨ ɨngkenaemb ket odede bageyam waina tugɨm ke opureni yɨtkak kea rɨrɨrkɨp awonj, ɨt re da “Rɨgap Tin nyɨ ogenai ra ‘Najaret Tunggam Rɨga’ e.” ");
INSERT INTO gdr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ɨ onggɨt wɨnɨnd baptiso Yoan ikonj wul kesa tungg wa de Yuda eriyand dɨde ket odede yɨtkak pɨtapɨta amneninonj ");
INSERT INTO gdr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","da, “Wɨn gar engenjinam negɨr mɨlem pɨlke Godɨm pɨlwa! Mop nokɨp pumb tungg re ke ɨte ke wa wus nate ainy.” ");
INSERT INTO gdr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mop nokɨp onggɨt baptiso Yoanɨmna yɨtkak re bageyam Isayamna tugɨm ke opureni yɨtkak rɨrɨrkɨp omnam e ɨt re da, “Ɨta ukoi ara b'emoka pɨta tainy dem wul kesa tunggɨnd da, ‘Wɨn Yonggyamɨm nya ɨspɨkaindam, ɨ Tina menonpu nya dɨmdɨm omnɨkaindam.’” ");
INSERT INTO gdr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ɨ ɨtemb Yoan kobɨrgɨm b'ikoki eyeninonj re kamel ngɨi ke omnɨki na, ɨ b'angga gɨm rob ke b'ibgi tina robmopɨnd, ɨ dɨde ti owou re nok na koka dɨde tɨbam wui. ");
INSERT INTO gdr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ɨ onggɨt wɨnɨnd rɨga wuwenonj ti pɨlwa Yerusalem taun ke ɨ komkesa Yuda eriya ke ɨ dɨde komkesa Yordan kɨlɨm wuswus eriya ke. ");
INSERT INTO gdr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ɨ ton ket towaina negɨr mɨle pɨtapɨta omnena eyento dɨde ket Yoanɨm pɨlke baptiso yokateno de Yordan kɨlɨmɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ɨ re Yoan yɨr anginonj jogjog Parisai rɨga ake Sadukai rɨga menonɨnd ti pɨlwa baptiso okatam, ton ten amninonj da, “Wɨn negɨr guda kɨma gɨrem waina b'ɨgawar! Yet wen wumɨr amninonj da wɨn b'ogla b'ɨtkenindam Godɨmna ukoi soro kɨma b'ɨsagɨkam pɨlke rɨnte ra ik dem? ");
INSERT INTO gdr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sɨ onggɨt paemb ra wɨn singi engenda baptiso okatam, sɨ wɨn b'obogɨl garjog ke ɨmɨnjog engenjinam waina negɨr mɨlem pɨlke de Godɨm pɨlwa, dɨde ket onggɨt engendi mɨle rɨrɨrɨnd kɨp kɨma mɨlend wɨmena tuwenyɨt. ");
INSERT INTO gdr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ɨ wɨn goro walenggyam odede b'asourena kɨma nonyɨk b'atɨmdeninam da, ‘Sɨn re God ma obagɨki Abraamɨmna b'ɨga im.’ Mop nokɨp kon kea wen amninyɨn da God rɨrɨr e onggɨt gɨmo wa pɨlke Abraamɨmna b'ɨga tawɨnkiny. ");
INSERT INTO gdr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sɨ yapa re kea wul mop wus nate yɨbɨm ɨgogɨm. Sɨ yonggyam ɨta onggɨt yapa ke komkesa wul ɨgka teyeniny rɨnsim re maka b'ogɨl kɨp ejagɨkanj, dɨde ton ket wul wa teskokiny so omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ɨ kon wen nyɨ kaim baptiso omnɨka eyeninyɨn negɨr mɨlem pɨlke engendam Godɨm pɨlwa. Ajɨ kor kak ke ɨta yɨpa dandajog rɨga ik yaina danda re Ti pumbjog wa e ajɨ koina re goujog wa e. Sɨ kon ma rɨrɨrkɨpjog rɨga en Tina yongɨnkak iyenam. Ɨ Ton wen baptiso omnɨka teyeniny ra Yɨnayɨna Wɨngawɨnga kae dɨde wul dɨmɨl kae. ");
INSERT INTO gdr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ɨ Ton ɨta Ti yɨmɨnd owoukɨp iukapu sabol yowam, sɨ Ton ɨta Tina owou erngokapu pɨpmetɨnd komkesa uwakurki owoukɨp sabol ke ouroka teyeniny dɨde ket pumb wa b'ɨtɨskeniny rɨbɨm uturenam. Nokɨm da ɨdenat Ton b'ogɨlyam owoukɨp tekalneniny mogjɨ kesa kɨp dɨde au wa pɨlke. Ɨ ra Ton onggɨtyam wɨko seg omɨny, Ton ɨta ket b'ogɨlyam owoukɨp taramkiny owoukɨp ongapapu met b'ɨga wa, ajɨ Ton ket mogjɨ kesa kɨp dɨde au so tamnɨkiny osouka kesa wul ke.” ");
INSERT INTO gdr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ɨ onggɨt wɨnɨnd Yesu Galili eriya ke opendonj de Yordan kɨlɨm wa Yoanɨm pɨlke baptiso okatam. ");
INSERT INTO gdr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ajɨ Yoan Tin pop yɨswangonj odede yɨt kɨma da, “Kon kolenggyam b'ogla baptiso okasɨn Mor pɨlke, ajɨ kon ma rɨrɨrkɨpjog rɨga en Men baptiso omnam. Sɨ nangga pae Man metket kor pɨlwa baptiso okatam?” ");
INSERT INTO gdr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ajɨ Yesu daka tin mɨra yomnonj da, “Man b'ogla otade ɨnjɨkite Ken baptiso omnam. Mop nokɨp odede nya ke komkesa negɨr kesa dɨmdɨmjog mɨle rɨrɨrkɨp omnam re meranɨm b'ogɨljog e omnɨkam.” Sɨ re Yesu onggɨtyam yɨt yopulitonj, Yoan ket ɨnjɨkitonj Tin baptiso omnam. ");
INSERT INTO gdr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ɨ re Yesu baptiso yokatonj, odenja Ton ket kɨlɨm nyɨ ke oblendonj. Sɨ ket wub Tinɨm ɨpangendonj dɨde ket Ton Godɨmna Wɨngawɨngand yɨr iyonj gimai pɨla inkand dɨde igitand Ti kumbɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ɨ ket odenja wub kumb ke nonykokɨt yindonj da, “Ɨtemb re Koina b'ɨga e yena re Kon singi yiyenyɨn. Sɨ Kon ukoi sam en Tinɨm.” ");
INSERT INTO gdr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ɨ ket Yɨnayɨna Wɨngawɨngat Yesund wɨp yiyonj de wul kesa tungg wa Satanam pɨlke otonkena okatam. ");
INSERT INTO gdr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ɨ onggɨt kak ke re ket Yesu owou uwabɨka wɨn yokatonj poti (40) bibɨr dɨde poti (40) sɨwɨny kɨma, Ton re ket owoupa na yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ɨ otonkena rɨga Satana ikonj Yesum pɨlwa dɨde ket Tin yomnonj da, “Rada Man Godɨmna B'ɨga et, sɨ Man onggɨtyam gɨmo engaine engendam sanam.” ");
INSERT INTO gdr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ajɨ Yesu mɨra yomnonj da, “Ɨja emb jɨ yɨna peband ɨrɨki yɨbɨm da, ‘Rɨgat ma owou nena kae yilo yɨbɨm, ajɨ kwa komkesa opureni yɨtkak kae yilo yɨbɨm rɨnsim re God Tina tugɨm ke apureniny.’” ");
INSERT INTO gdr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ɨ ket Satana Yesund wɨp yiyonj yɨna taun wa, ɨt re Yerusalem taun, dɨde ket Tin yonyitonj yɨnamet papkak petɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ɨ ton ket Yesund yomnonj da, “Rada Man Godɨmna B'ɨga et, Man Molenggyam b'atiyakite de gou wa! Mop nokɨp yɨna peband ɨja emb jɨ ɨrɨki yɨbɨm da, ‘God opima Tina aneru mornɨm tengainy. Ɨ ton ket men towaina yɨm kumbɨnd motowami. Sɨ onggɨt paemb man ma osiya ket moina pɨs taskisɨt motɨr kumbɨnd.’” ");
INSERT INTO gdr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ɨ ket Yesu mɨra yomnonj da, “Ɨ kwa daka yɨna peband ɨja emb jɨ ɨrɨki yɨbɨm da, ‘Man goro Yonggyam mor Godɨnd otonkenyɨt.’” ");
INSERT INTO gdr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ɨ ket Satana b'usaya Yesund wɨp yomnonj de ukoijog uskiuski dor papkak kumb wa, dɨde ket Tin youyaukurinonj komkesa gowukoi kantri dɨde towaina komkesa b'ogɨl ɨnyomarena kɨma mɨle dɨde gasa. ");
INSERT INTO gdr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Seg ton ket Yesund yomnonj da, “Ra man kor pɨlɨnd kumsos b'atɨmket ken ewangayam, kon opima onggɨtyam komkesa gasa mor motgoninyɨn.” ");
INSERT INTO gdr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ɨ ket Yesu tin yomnonj da, “Satana! Man ewaikite kor pɨlke. Mop nokɨp yɨna peband ɨja emb jɨ ɨrɨki yɨbɨm da, ‘Man b'ogla ewangaya yiyene Yonggyam mor Godɨnd. Ɨ ket Tinɨm nena wɨko omnɨka yiyenae!’” ");
INSERT INTO gdr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ɨ ket Satana Yesund yɨraronj. Seg ket aneru tuwonj Ti pɨlwa dɨde ket Tin yɨm yokawo. ");
INSERT INTO gdr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ɨ re Yesu utkundonj da rɨgap kea baptiso Yoanɨnd sɨbɨbmet met wa yoramito, Ton ket Galili eriya wa yikonj. ");
INSERT INTO gdr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ɨ Ton ket Najaret tungg yɨraronj dɨde ket yikonj Kaparnaum taun wa wɨmenam. Sɨ Kaparnaum taun re sɨpa yuru nat yɨbnonj de Jebulon dɨde Naptali eriya wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Sɨ nangga pena Yesu yikonj onggɨt eriya wa re nok mana da ɨdenat bageyam Isayamna tugɨm ke opureni yɨtkak rɨrɨrkɨp omɨny ɨt re da, ");
INSERT INTO gdr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Jebulon gou dɨde Naptali gou re sɨpa yuru nasi ebnya. Ɨ ton re Yordan kɨlɨm tab nasi ebnya Galili eriyand ogenaya da God ma obagɨki kesa rɨga waina tungg i. ");
INSERT INTO gdr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ɨ rɨga yepim re wekeny sɨbɨbɨnd, ɨta ukoijog ngaya yɨr ongi dem. Ɨ rɨga wanɨm yepim re wekeny ujɨmna kara wɨngɨrɨnd, ngayat opima ten ɨnyowaya teyeniny dem.” ");
INSERT INTO gdr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sɨ onggɨt wɨn natemb ket Yesu b'atomonj odede yɨtkak pɨtapɨta omnenam da, “Wɨn gar engenjinam negɨr mɨlem pɨlke Godɨm pɨlwa! Mop nokɨp pumb tungg re ke ɨte ke wa wus nate ainy.” ");
INSERT INTO gdr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ɨ re Yesu Galili sɨpa yuru nata yikenenonj, sɨ yɨpa wɨnɨnd Ton nɨmog nanyɨnggan yɨr angonj, osi re Simon ogenaya da Petro dɨde ti yɨnggan Andrea. Ɨ onggɨt wɨnɨnd osiemb nanyɨnggan sɨpa wa gɨr b'ɨskena nat ebnonda, nokɨp ton re kabum ɨwɨka rɨga na ebnonda. ");
INSERT INTO gdr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ɨ ket Yesu ten amnonj da, “Ayo tetka, yɨmta nundoka! Ɨ kon rɨga ɨwɨka mi wen tamnyɨn odede rɨngmi re wɨn kabum ɨwɨka eyeninya.” ");
INSERT INTO gdr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ɨ odenja ton gɨr erarkinonda dɨde ton ket Tin yɨmta yundokonda. ");
INSERT INTO gdr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ɨ ɨngkek re ket Yesu wɨp wa b'ɨsonkitonj, Ton kea nɨmog nanyɨnggan yɨr angonj, Jebedaimna b'ɨga nɨmog Yakobo ake Yoan. Ɨ onggɨt wɨnɨnd ton towa b'u Jebedai kɨma gɨga nat ebnonda dɨde ket gɨr na angonjento. Ɨ Yesu ket ten ara emokonj Tin yɨmta undokam. ");
INSERT INTO gdr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Sɨ ton odenja ket gɨga yɨraronda dɨde kwa towa b'und da. Ɨ ket Yesund yɨmta yundokonda. ");
INSERT INTO gdr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ɨ re ket Yesu yikenonj kupka Galili eriya nata, Ton Ju rɨga waina yɨr opmitenapu met nata rɨga ouyaena eyeninonj, ɨ ket pumb tungg gatab b'ogɨl yɨrkokar bage yɨt pɨtapɨta omnena yiyenonj, ɨ dɨde ket rɨga wa wɨngɨrɨnd komkesa b'engabenga wɨp kopa rɨga ɨsakka eyeninonj. ");
INSERT INTO gdr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Sɨ Yesum gatab yɨdɨr yɨt re kea warabag auka yikenonj kupka Siriya kantri nata. Ɨ ket rɨgap komkesa kopa rɨga Ti pɨlwa eyento, opi re jogjog b'engabenga wɨp kopa rɨga, ɨ ukoijog kopa b'angnena kɨma rɨga, ɨ negɨr wɨngawɨnga ke imdi rɨga, ɨ nony kesa tumol aembɨka kɨma sap otendena kopa rɨga, ɨ dɨde dɨmɨr kopa rɨga. Sɨ Ton ket kea ten ɨsagɨka eyeninonj. ");
INSERT INTO gdr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ɨ ket jogjog rɨga bobop Galili eriya ke ɨ Dekapoli eriya ke ɨ Yerusalem taun ke ɨ Yuda eriya ke ɨ dɨde Yordan kɨlɨm yɨpa tab ke wuwenonj Yesum pɨlwa, dɨde ket Tin yɨmta undoka yiyeno. ");
INSERT INTO gdr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ɨ re Yesu rɨga bobo yɨr teyinonj Ti pɨlwa menonɨnd, Ton ket yɨpa sukak wa yikonj. Ɨ re Ton omitonj, Tina b'auyaena rɨga ket tuwonj Ti pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Sɨ Ton ket b'atomonj ten ouyaenam odede da, ");
INSERT INTO gdr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ton b'ogɨl omni rɨga im jɨ yepim re wɨngawɨnga ke gasa kesand wekeny dɨde ukoi singi aenanj Godɨm pɨlke wurar okatam, mop nokɨp pumb tungg re towa maemb jɨ. ");
INSERT INTO gdr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ton b'ogɨl omni rɨga im jɨ yepim re yu towaina negɨr mɨle map yii b'eagɨkanj, mop nokɨp God opima towaina gar ngɨmbla tamnɨkiny. ");
INSERT INTO gdr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ton b'ogɨl omni rɨga im jɨ yepim re Godɨm wɨpɨnd nony kɨma muske wɨmena wuweny, mop nokɨp ton ɨta owabɨnsi gowukoi rɨna re God tɨrɨr amnawonj towa okawam. ");
INSERT INTO gdr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ton b'ogɨl omni rɨga im jɨ yepim re negɨr kesa dɨmdɨmjog mɨle okatam pajogɨnd wekeny, mop nokɨp God opima ten ngor tamnɨkiny. ");
INSERT INTO gdr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ton b'ogɨl omni rɨga im jɨ yepim re rɨga kear amnenanj, mop nokɨp God opima ten kear tamneniny. ");
INSERT INTO gdr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ton b'ogɨl omni rɨga im jɨ yepim re gar kɨlkɨp kesa wekeny, mop nokɨp ton ɨta Godɨnd yɨr ongi. ");
INSERT INTO gdr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ton b'ogɨl omni rɨga im jɨ yepim re ngɨmbla omnɨka mɨlend wekeny, mop nokɨp God ten opima Tina b'ɨgam tagenainy. ");
INSERT INTO gdr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ton b'ogɨl omni rɨga im jɨ yepim re negɨr kesa dɨmdɨmjog mɨle omnɨka map bebɨg dɨde b'ɨsadrena mɨle akatenanj, mop nokɨp pumb tungg re towa maemb.” ");
INSERT INTO gdr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Wɨn b'ogɨl omni rɨga im jɨ, ra rɨgap Kor map wen negɨr yɨt ke tamnenanj, ɨ bebɨg dɨde b'ɨsadrena mɨle oramka teyenanj, ɨ dɨde komkesa nenegɨr b'anygɨnena nya ke negɨr omnam ɨl ongka teyenanj. ");
INSERT INTO gdr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sɨ wɨn b'ogla nony sam kɨma ukoi kana ngolengole aeninam, mop nokɨp wa opima ukoijog mɨra ebnainy de pumb tungg wa. Mop nokɨp rɨgap ɨja naemb jɨ yɨpa wɨp nya ke bageyam wa pɨlɨnd bebɨg dɨde b'ɨsadrena mɨle amnɨkenento yepiya re naskand wekenonj. ");
INSERT INTO gdr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Wɨn re gowukoyɨm sol im. Ajɨ ra sol solmet kesa tainy, sɨ rɨdede nya kae solmet kwa b'usaya tɨtenj? Sɨ ra sol solmet kesa tainy, ɨtemb re makwa ket ingawa ma ajɨ ket bau wa b'ɨska ma, ɨ ket rɨgap pɨs ke ɨpmɨndena iyenyi. ");
INSERT INTO gdr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ɨ wɨn re gowukoyɨm ngaya im. Sɨ sukakɨnd orangi taun ma rɨrɨr e ket egiti ɨbɨm. ");
INSERT INTO gdr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ra yɨpa rɨgat lampa so omɨny, ton makwa ɨta kopakak ke utwangɨk. Ajɨ ton ɨndama oramis lampa uwonyitenapu ororɨnd, ɨ ket ngaya tanyorkiny komkesa rɨga yepim re wekeny onggɨt metɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Sɨ odede yɨpa wɨp nya ke wɨn b'ogla b'ogɨl mɨle tamnɨkenenindam rɨga wa wɨpɨnd ngaya enyorka pɨla. Ɨ ket rɨgap waina b'ogɨl wɨko yɨr ongong teyenanj, ɨ ɨngkaemb ket ton b'ogɨl ɨnyomarena okaenyi wa B'uɨm yete re yɨbɨm de pumb tungg wa.” ");
INSERT INTO gdr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ɨ wɨn goro nonyɨk b'atɨmdenindam da Kon gog yɨt dɨde bageyam waina yɨt eomnena mana netkond. Ajɨ Kon netkond re ma eomnena mana, ajɨ rɨrɨrkɨp omna mana. ");
INSERT INTO gdr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sɨ Kon ɨmɨnjog wen tamninyɨn da yɨmta kena wub ake gowukoi b'eteomnenya, ajɨ gog yɨtɨm pɨlke makwa ɨta yɨpa ɨrɨki o yɨpa ɨrɨki mal b'eteomneny ngɨrpu onggɨtyam komkesa yɨtkak rɨrɨrkɨp taukanj. ");
INSERT INTO gdr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Sɨ onggɨt paemb yet ra yɨpa sobijogjog yɨtkak erbenj onggɨt b'ingawa yɨt wɨngɨrɨnd dɨde rɨga ouyaena teyeniny odede omnɨkam, tin ogenai dem ra sobijogjog rɨga e de pumb tungg wa. Ajɨ yet ra b'itngaeny dɨde rɨga ouyaena teyeniny kupka gog yɨt rɨrɨrɨnd, ɨtemb rɨga ogenai dem ra ukoijog rɨga e de pumb tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Sɨ onggɨt mop paemb Kon wen wumɨr tamninyɨn da ra waina negɨr kesa dɨmdɨmjog mɨlet maka ɨgoukis Ju rɨga waina gog ouyaena rɨga dɨde Parisai rɨga waina negɨr kesa dɨmdɨmjog mɨle, wɨn makwa ngai opima b'ɨtgarkindam de pumb tungg wa.” ");
INSERT INTO gdr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ɨ wɨn kea utkundenindam da naska wɨnɨnd Mose yindonj da, ‘Goro rɨga ongandɨm! Yet ra rɨga onganj, ton ɨta negɨr ma b'ɨsagɨka okas.’ ");
INSERT INTO gdr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ajɨ Kon wen wumɨr tamninyɨn da yet ra tina gar ke utkunda nanyɨnd o yɨngganɨnd soro ke omɨny, ton ɨta negɨr ma b'ɨsagɨka okas. Yet ra tina gar ke utkunda nanyɨnd o yɨngganɨnd omɨny da ‘Korɨrkorɨr,’ ton ɨta negɨr ma b'ɨsagɨka okas pumbjog kotɨnd. Ɨ kwa yet ra omɨny da ‘Nony kesa,’ ton ɨta wul tungg wa ɨskam b'ɨsagɨka okas dem rokate re osouka kesa wul dɨmɨl yɨmbeneneny. ");
INSERT INTO gdr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Sɨ onggɨt paemb ra man Godɨm kear gasa oramitam iyɨt de yɨna sɨ omnɨkapu kap wa, ɨ ra ket demb de man nonyɨk b'atɨmjɨt da, ‘yɨpa gar ke utkunda nanyɨt o yɨngganɨt ɨta kor gar soro nowamau.’ ");
INSERT INTO gdr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Sɨ man ket b'ogla moina kear gasa omanda ɨraret yɨna sɨ omnɨkapu kap wɨp ke dɨde ket man naska menon okasɨt onggɨt moina gar ke utkunda nany o yɨngganɨm pɨlwa ɨ dɨde ket ton kɨma rɨgarɨga taet. Seg ket man tɨtenjɨt yɨna sɨ omnɨkapu kap wa ɨ dɨde ket Godɨm pɨlwa moina kear gasa oramisɨt. ");
INSERT INTO gdr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ra yɨpa rɨgat kot wa oramitam mii, sɨ man yɨmta kena b'ɨsagɨkapu pɨpmet wa topenjɨt, ajɨ man b'ogla naska wanakana gangga okasɨt nyawɨnd ton kɨma rɨgarɨga awowɨm. Ɨ man yɨr kɨma, ke onggɨt rɨgat men maramit b'ɨsagɨka rɨgamna yɨm kumb wa, ɨ ke onggɨt b'ɨsagɨka rɨgat maramit timtim rɨgam pɨlwa, ɨ dɨde ke mesɨk sɨbɨbmet wa. ");
INSERT INTO gdr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kon ɨmɨnjog men motɨnyɨn da sɨ man ma ɨta sɨbɨbmet ke topenjɨt ajɨ ɨdenata ra man kikitumjog Toya oramisɨt sɨbɨbmet mɨra undwatam.” ");
INSERT INTO gdr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ɨ wɨn kea utkundenindam da naska wɨnɨnd Mose yindonj da, ‘Goro gigɨr dɨde yɨgyɨg b'iyena mɨle omnɨkɨm.’ ");
INSERT INTO gdr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ajɨ Kon wen wumɨr tamninyɨn da yet ra yɨpa konggand yɨr tɨpɨk ton kɨma gigɨr mɨle omnɨka singind, ton re kea onggɨt kongga kɨma gigɨr dɨde yɨgyɨg b'iyena mɨle yomnɨk tina garɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ɨ ra moina yɨmjog tab ke yɨrɨt negɨr mɨle omnɨkam motɨny, man b'ogla ɨtemb yɨrkɨp ɨtkasɨt dɨde ket b'ɨtɨskansɨt mor pɨlke. Mop nokɨp ɨtemb re b'ogɨljog e mornɨm moina jɨ ke yɨpa kɨpear ewaikitam, ajɨ ma b'ogɨl e moina kupka jɨ ɨskantam de wul tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ɨ kwa ra moina yɨmjog yɨmɨt negɨr mɨle omnɨkam motɨny, man b'ogla ɨtemb yɨm ɨpmarkisɨt dɨde ket b'ɨtɨskansɨt mor pɨlke. Mop nokɨp ɨtemb re b'ogɨljog e mornɨm moina jɨ ke yɨpa kɨpear ewaikitam, ajɨ ma b'ogɨl e moina kupka jɨ ɨskantam de wul tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ɨ kwa Mose yindonj da, ‘Yet ra ti konggand bondɨk tomɨny, ton b'ogla ɨtomb konggam bondɨk omnam ɨmjati peba tokau.’ ");
INSERT INTO gdr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ajɨ Kon wen wumɨr tamninyɨn da yet ra ti konggand jabakɨpɨnd bondɨk tomɨny yɨpa rɨga kɨma negɨr b'iyena mɨle omnɨki kesand, ton kea tin womɨny gigɨr dɨde yɨgyɨg b'iyena mɨle omnɨkam. Ɨ kwa yet ra bondɨk omni konggand tokas ti konggam, ton kea gigɨr dɨde yɨgyɨg b'iyena mɨle yomnɨk.” ");
INSERT INTO gdr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ɨ kwa wɨn utkundenindam da Mose kesam rɨga amninonj da, ‘Goro nenegɨr nya ke danda kɨma tɨrɨr yɨt opulitɨm! Ajɨ ra man danda kɨma tɨrɨr omni yɨt opulisɨt Yonggyamɨm pɨlwa, sɨ man b'ogla onggɨt yɨt rɨrɨrɨnd tamnɨkinyɨt.’ ");
INSERT INTO gdr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ajɨ Kon wen tamninyɨn da goro kwa ngai danda kɨma tɨrɨr yɨt opulitɨm, goro pumb tungg nyɨ kɨma, mop nokɨp pumb tungg re Godɨmna wɨp omnenapu kasa e. ");
INSERT INTO gdr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ɨ goro danda kɨma tɨrɨr yɨt opulitɨm gowukoi nyɨ kɨma, mop nokɨp gowukoi re Godɨmna pɨs oramitenapu e. Ɨ goro Yerusalem taun nyɨ kɨma, mop nokɨp ɨtemb taun re ukoijog King Godɨmna e. ");
INSERT INTO gdr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ɨ goro danda kɨma tɨrɨr yɨt opulitɨm moina moptekɨp ke, mop nokɨp man makwa rɨrɨr et yɨpa moina mopngɨi bɨlbɨl o timtim omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ajɨ man b'ogla ɨna nena yɨt opulisɨt da ‘Owɨ’, nangga e re ɨmɨnjog, ɨ ‘Nayɨ’ nangga e re ma ɨmɨnjog e. Ajɨ nangga na ra onggɨtyam yɨt tumɨnd oramisɨt, ɨtemb re negɨryam Satanam pɨlkae ik.” ");
INSERT INTO gdr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ɨ wɨn kea utkundenindam da naska wɨnɨnd Mose yindonj da, ‘Yet ra moina yɨrkɨp negɨr omɨny, sɨ madaka b'ogla tina yɨrkɨp mɨra negɨr omnyɨt, ɨ yet ra moina orkak ɨrobenj, sɨ madaka b'ogla tina orkak mɨra ɨrobenjɨt.’ ");
INSERT INTO gdr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ajɨ Kon wen tamninyɨn da goro negɨr rɨga mɨra negɨr omnɨm. Ajɨ yet ra moina yɨmjog yɨm tab ke anakak mɨtpokis, sɨ man b'ogla kwa moina yɨpa tab anakak ti engendaet tinɨm ɨpokitam. ");
INSERT INTO gdr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ɨ yet ra singi tainy men kot wa oramitam dɨde moina wɨngɨr ke kobɨrgɨm okatam, sɨ man b'ogla kwa okaet moina bau ke pɨnpɨn kobɨrgɨm. ");
INSERT INTO gdr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ɨ kwa yet ra men danda kɨma ɨl motɨngɨk yɨpa kilomita pɨn menonɨm, sɨ man b'ogla ton kɨma menon okasɨt nɨmog kilomita. ");
INSERT INTO gdr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ɨ man b'ogla okaet onggɨt rɨgam yet ra mɨtgekis, ɨ goro man onggɨt rɨgand ɨsayɨm yete re singi ainy moina gasa yiyoyoi ingawam.” ");
INSERT INTO gdr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ɨ wɨn kea utkundenindam da naska wɨnɨnd Mose yindonj da, ‘Man singi yiyene mor rɨgand dɨde singi kesa yomnene moina geja rɨgand.’ ");
INSERT INTO gdr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ajɨ Kon wen tamninyɨn da singi eyeninam waina geja rɨga, ɨ yɨr topmitenindam towanɨm yepim re bebɨg dɨde b'ɨsadrena mɨle amnɨkenenanj wanɨm. ");
INSERT INTO gdr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Sɨ ra wɨn odede mɨle tamnɨkindam, wɨn b'ogla waina B'u Godɨmna b'ɨga taindam yete re pumb tunggɨnd yɨbɨm. Mop nokɨp Tontemb Tina lomkongga yɨliteneny b'anyoratenam negɨr rɨga wa pɨlwa dɨde b'ogɨl rɨga wa pɨlwa, ɨ dɨde kwa Ton piro yɨgmarkeneny negɨr kesa dɨmdɨmjog rɨga wa pɨlwa dɨde negɨr kɨma kaokao rɨga wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ɨ ra wɨn rɨga singi teyenindam yepim re wen singi eyenanj, sɨ nangga mɨra e wɨn okasya? Rɨngma, ma ma negɨr mɨle kɨma teks imdayam rɨgap todaka opima odede yɨpa wɨp mɨle amnɨkenenanj? ");
INSERT INTO gdr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ɨ kwa ra wɨn waina kus ke rɨga nena simesime yɨt tamnɨkenindam, sɨ wɨn nangga b'ogɨljog mɨle im amnɨkenindam nɨnda rɨga wa pɨlke? Sɨ rɨngma, ma ma God ma obagɨki kesa rɨgap todaka opima odede yɨpa wɨp mɨle amnɨkenenanj? ");
INSERT INTO gdr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Sɨ onggɨt paemb wɨn b'ogla Godɨm wɨpɨnd dɨmdɨmkɨpjog rɨga ainam odede yɨpa wɨp ɨte re wa B'u God dɨmdɨmjog rɨga yɨbɨm de pumb tungg wa.” ");
INSERT INTO gdr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ɨ wɨn yɨr kɨma tekenyɨt onggɨtɨm da goro wɨn waina negɨr kesa dɨmdɨmjog mɨle omnɨka teyenina rɨga wa wɨpɨnd towanɨm yɨr ongong singind. Sɨ ra wɨn odede mɨle tamnɨkenenindam, wɨn ma opima mɨra takatenindam wa B'u Godɨm pɨlke yete re yɨbɨm pumb tungg wa.” ");
INSERT INTO gdr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Sɨ onggɨt paemb ra man kear omnena teyeninyɨt gasa kesa rɨga, goro ara kɨma metkenɨm odede rɨngmim re bibol ɨpaya rɨgap ara kɨma wuweneny rɨga wa utkundam. Sɨ gɨm ke b'ogɨl ajɨ ngor wa negɨr mɨle rɨgap opima odede yɨpa wɨp nya ke mɨle omnɨka eyenanj de Ju rɨga waina yɨr opmitenapu met nata dɨde sobea nata rɨga wa pɨlke esourena okatam. Kon wen ɨmɨnjog wumɨr tamninyɨn da ton kea towaina mɨra yokateno. ");
INSERT INTO gdr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ajɨ ra man kear omnena teyeninyɨt gasa kesa rɨga, man b'ogla odede nya kena omnɨket rɨja e re moina sawai yɨm yɨg nonyɨnd yɨbɨm onggɨt gatab rɨnsim re moina yɨmjog yɨmɨt kear amneniny. ");
INSERT INTO gdr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Sɨ odede nya ke moina kear omnena mɨle b'ogla wɨgawɨga na yebɨm. Sɨ ɨdenat mor B'u God yete re wɨgawɨga yɨr ongong eyeniny nangga im re rɨgap wɨgawɨga amnɨkenenanj, Ton ket men ɨta mɨra motɨny.” ");
INSERT INTO gdr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ɨ kwa ra wɨn yɨr topmitenindam, goro odede taininam rɨngmim re gɨm ke b'ogɨl ajɨ ngor wa negɨr mɨle rɨgap yɨr opmitenenanj. Mop nokɨp ton singi aukenenanj owɨnenam de Ju rɨga waina yɨr opmitenapu met nata dɨde ukoi sobea dedag nata dɨde ket yɨr opmitenenanj rɨga wa bajbajɨnd, nokɨm da ɨdenat rɨgap ten yɨr ongong teyenanj. Sɨ Kon wen ɨmɨnjog wumɨr tamninyɨn da ton re kea towaina mɨra akatento. ");
INSERT INTO gdr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ajɨ ra man yɨr topmisɨt, man b'ogla b'ɨtgaret moina rum wa, ɨ ket mora ɨdoket, ɨ dɨde ket yɨr topmisɨt mor B'u Godɨm pɨlwa yete re wɨgawɨga yɨr ongong kesa yɨbɨm. Sɨ ɨtemb mor B'u ɨta wɨgawɨga yɨr ongong miyeny nangga ma re man yɨr opmitenyɨt, Ton ɨta ket mɨra motɨny. ");
INSERT INTO gdr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ɨ ra wɨn yɨr topmitenindam, goro yɨtkak tusaereninam odede rɨngmim re God ma obagɨki kesa rɨgap yɨr opmita amnɨkenenanj. Mop nokɨp ton nony aukenenanj da God opima towaina yɨr opmitena utkundeniny towaina jogjog yɨtkak usairena map. ");
INSERT INTO gdr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sɨ onggɨt paemb wɨn goro odede God ma obagɨki kesa rɨga pɨla taukinam. Mop nokɨp wɨn yɨmta kae wa B'u Godɨnd yɨr opmita ke nyɨ yuwatenya, ajɨ Ton kea naska nata wumɨr ainy nangga im re wɨn arakindam. ");
INSERT INTO gdr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Sɨ onggɨt paemb wɨn ɨja imemb jɨ yɨr topmitenindam da, ‘Sowa B'u God yete re mɨbnyɨt pumb tungg wa, Moina nyɨ b'ogla yɨnam rain, ");
INSERT INTO gdr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ɨ Moina wɨp omnenapu pumb tungg b'ogla rinɨk onggɨt gowukoi wa, ɨ Moina singi b'ogla rɨrɨrkɨp rain kwa daka dɨkɨnd onggɨt gowukoyɨnd odede rɨja na re pumb tungg wa awonj. ");
INSERT INTO gdr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ɨ bibɨr weanjweanj sowa owou notgoneneninyɨt bibɨr rɨrɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ɨ Man sowaina negɨr mɨle awɨr omnɨka teyeninyɨt, odede yɨpa wɨp opi re sɨn nɨnda rɨga wa towaina negɨr mɨle awɨr amnɨkaenenindam rɨnsim re ton amnɨkenenanj sowa pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ɨ Man goro sɨn wɨp niyinɨm negɨr ma b'atonkena wa, ajɨ nedɨkine negɨryam Satanam pɨlke. Mop nokɨp pumb tungg ɨ danda ɨ dɨde b'ogɨl ɨnyomarena re Moina im dadal ngɨrpu kesa, ɨmɨnjog.’ ");
INSERT INTO gdr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mop nokɨp ra wɨn rɨga wa negɨr mɨle awɨr tamnɨkaenindam rɨnsim re ton amnɨkenenanj wa pɨlwa, sɨ wa B'u God yete re yɨbɨm pumb tungg wa, Todaka opima waina negɨr mɨle awɨr tamnɨkaeniny. ");
INSERT INTO gdr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ajɨ ra wɨn maka ra rɨga wa negɨr mɨle awɨr tamnɨkaenindam rɨnsim re ton amnɨkenanj wa pɨlwa, sɨ wa B'u God Todaka makwa opima waina negɨr mɨle awɨr tamnɨkaeniny. ");
INSERT INTO gdr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ɨ ra wɨn owou uwabɨka wɨn okasya, goro wɨprɨbrɨb taininam odede rɨngmim re gɨm ke b'ogɨl ajɨ ngor wa negɨr rɨga aukenenanj. Mop nokɨp ton wɨprɨbrɨb aukenenanj re rɨga wa ouyawa mim da ton re owou uwabɨka wɨn e yokatenyi. Sɨ Kon wen ɨmɨnjog wumɨr tamninyɨn da ton re kea rɨrɨrkɨpjog towaina mɨra okati im wekeny rɨga wa pɨlke. ");
INSERT INTO gdr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ajɨ ra man owou uwabɨka wɨn okasɨt, man b'ogla gaya ke moina mop b'ɨtɨsnɨket dɨde moina wɨp b'ɨtɨseket. ");
INSERT INTO gdr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Nokɨm da ɨdenat rɨgap maka wumɨr taukanj da man re owou uwabɨka wɨn e yokasɨt, ajɨ mor B'u God nenata wumɨr okas yete re wɨgawɨga yɨr ongong kesa yɨbɨm. Sɨ ɨtemb mor B'u God yete re wɨgawɨga yɨr ongong miyeny nangga e re man wɨgawɨga yomnɨkenenyɨt, Ton ɨta mɨra motɨny. ");
INSERT INTO gdr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ɨ goro wɨn b'ogɨljog gasa ongapa teyeninam wanɨm onggɨt gowukoyɨnd rokasim re bebɨrɨp dɨde orliyap waina gasa owou eyenanj, dɨde rokasim re yurowamam rɨgap waina met eporkenenanj b'ɨgaram dɨde waina gasa imda teyenanj. ");
INSERT INTO gdr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ajɨ wɨn b'ogla waina b'ogɨljog gasa ongapa teyenindam de pumb tungg wa rokasim re bebɨrɨp dɨde orliyap toda maka waina gasa owou eyenanj, dɨde rokasim re yurowamam rɨgap maka waina met eporkenenanj b'ɨgaram dɨde maka waina gasa imda eyenanj. ");
INSERT INTO gdr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mop nokɨp rokate re moina b'ogɨljog gasa yɨbɨm, sɨ ɨndamaemb todaka moina kɨd ɨbɨm. ");
INSERT INTO gdr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Sɨ yɨrkɨp re jɨwɨm lampa e. Sɨ onggɨt paemb rada moina yɨrkɨp b'ogɨljog i, moina kupkakupka jɨ ra ngaya pɨta nate ɨbɨm. ");
INSERT INTO gdr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ajɨ rada moina yɨrkɨp negɨrjog i, sɨ moina kupkakupka jɨ ra sɨbɨb ke ɨkangɨndi e ɨbɨm. Sɨ onggɨt paemb rada ɨtemb ngaya sɨbɨb nate yɨbɨm rɨnte re yɨbɨm mor pɨlɨnd, ɨtemb re ma sobijog sɨbɨb kɨkɨbte mɨtkangɨnj. ");
INSERT INTO gdr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Makwa yɨpa rɨgat rɨrɨr e nɨmog yonggyam wa wɨko tamnɨkainy. Mop nokɨp ton yama rɨka yɨpa yonggyamɨnd singi kesa e omneny dɨde kwa yɨpa yonggyamɨnd ra singi e iyeny, o ton yama rɨka yɨpa yonggyamɨnd ɨsnawa e iyeny, dɨde kwa ra yɨpa yonggyamɨnd ɨsnawa kesa e omneny. Sɨ onggɨt paemb wɨn ma rɨrɨr im wɨko rɨga taukindam nɨmognɨmog Godɨm dɨde onggɨt gowukoi gasam. ");
INSERT INTO gdr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Sɨ onggɨt paemb Kon wen tamninyɨn da goro nony kubɨr taininam da nangga owou im tawenenindam o nangga nyɨ im tanaikindam yɨrkokar wɨmenam, ɨ kwa nangga kobɨrgɨm im b'itkokenenindam waina jɨwɨnd. Sɨ rɨngma, ma ma yilo yɨrkokar re ukoijog e owowɨm pɨlke? Ɨ ma ma jɨ re ukoijog e kobɨrgɨmɨm pɨlke? ");
INSERT INTO gdr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Sɨ wɨn b'obogɨl yɨrɨk teyenindam pumbɨnd ngena. Ton makwa opima tuny ɨgmarka eyenenanj, ɨ makwa opima owoukɨp eakɨkenenanj, dɨde makwa opima bobo omnɨka eyenenanj owou ongapapu met b'ɨga wa. Ajɨ waina B'u God yete re yɨbɨm pumb tungg wa, Tonsimemb ten ongenka eyeniny. Sɨ rɨngma, ma ma wɨn ukoijog im odede ngena wa pɨlke? ");
INSERT INTO gdr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ɨ wa wɨngɨrɨnd yete rɨrɨr e tina nony kubɨr b'amnɨka ke tina yɨrkokar ɨsonkis yɨpa sobijog wɨn kɨma? ");
INSERT INTO gdr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Wɨn b'ogla b'obogɨl temtem gatab nony menamena amnɨkinam rɨja im ton b'obogɨl ɨkaeneni owɨnkenenanj yapɨnd. Sɨ ton ma opima kobɨrgɨm omnɨkam tin kai eraskenenanj, ɨ dɨde kwa ton ma opima kobɨrgɨm omnɨka eyenenanj. ");
INSERT INTO gdr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ajɨ Kon wen wumɨr tamninyɨn da king Solomon kea tina komkesa b'ogɨl ɨnyomarena kɨma b'ajga yikenonj, ajɨ tina b'ajga re makwa yɨpa rɨrɨrkɨp awonj yɨpa odede temtem re dɨde. ");
INSERT INTO gdr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Sɨ rada Godsim odede tɨbam tɨb ejga eyeniny rɨnsim re yu yilo wekeny ajɨ mep uj taukanj wul wa b'ɨskokam. Sɨ rɨngma, rɨdede wɨp e ket God wen b'obogɨljog ejga teyeniny? Sɨ wɨn goro sobijog gar ke utkundand tekenyɨt, Ton opima wen b'obogɨljog ejga teyeniny. ");
INSERT INTO gdr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Sɨ onggɨt paemb wɨn goro nony kubɨr taeninam odede yɨt kɨma da, ‘Nangga im sɨn tawindam?’ o ‘Nangga im sɨn tanaikindam?’ o ‘Nangga im sɨn b'itkokindam?’ ");
INSERT INTO gdr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mop nokɨp God ma obagɨki kesa rɨgap ɨnsimemb odede komkesa gasa oraka eyenanj. Ajɨ wa B'u God yete re yɨbɨm pumb tungg wa, Ton wumɨr e da wɨn b'ogla ɨnsimemb gasa tengaenenindam gowukoi wɨmenam. ");
INSERT INTO gdr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ajɨ wɨn naska God ma pumb tungg dɨde Tina negɨr kesa dɨmdɨmjog mɨle oraka eyeninam! Sɨ God ket wa tagoniny ra ma pumb tungg dɨde negɨr kesa dɨmdɨmjog mɨle nena im ajɨ daka kwa opima odede komkesa gasa tagoniny. ");
INSERT INTO gdr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Sɨ onggɨt paemb goro wɨn nony kubɨr taeninam mepnɨm gatab, nokɨp mepnɨm gasa ra mepnɨm nony kubɨr omna mim. Ita bibɨr wa re opima ebnainy towa rɨrɨr bebɨg. ");
INSERT INTO gdr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ɨ wɨn goro rɨga wa pɨlɨnd b'ɨsagɨka mɨle tamnɨkina, sɨ wɨda makwa ɨta b'ɨsagɨka okatenya. ");
INSERT INTO gdr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mop nokɨp wɨn ɨta odede yɨpa wɨp nya ke b'ɨsagɨka okatenya dem rɨja na re wɨn rɨga wa pɨlɨnd b'ɨsagɨka mɨle omnɨka yiyenonda, ɨ kwa God opima wanɨm okawam odede yɨpa wɨp tondon wa takatenainy rɨja na re wɨn rɨga wa tondon akatenautondam. ");
INSERT INTO gdr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nangga pae man yɨr pɨpla yɨr yiyenyɨt moina rɨgamna yɨrkɨpɨnd, ajɨ kwa nangga pae man maka b'obogɨl wumɨr yokatenyɨt wulpas gatab moinajog yɨrkɨpɨnd? ");
INSERT INTO gdr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ɨ rada mor ɨta mɨbnau wulpas moinajog yɨrkɨpɨnd, sɨ rɨngma, rɨdede e man ket moina rɨgand omnyɨt da ‘Mabe kon mawaikitawɨn yɨr pɨpla moina yɨrkɨp ke’? ");
INSERT INTO gdr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sɨ man re gɨm ke b'ogɨl ajɨ ngor wa negɨr rɨga et. Sɨ man naska moina yɨrkɨp ke wulpas yewaikite! Ɨ ɨngkaemb ket man onggɨtyam yɨr pɨpla pɨtakɨpɨnd yɨr onget mor rɨgamna yɨrkɨpɨnd, ɨ ket man ɨtemb yɨr pɨpla ewaikitaet mor rɨgamna yɨrkɨp ke. ");
INSERT INTO gdr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ɨ wɨn goro yongg pɨla wɨp ɨnggrawa kesa rɨga wa yɨnayɨna gasa tagoninam yepim re Godɨnd ɨsanikesa geja yiyenyi. Ɨ kwa goro b'om pɨla rɨga wa wɨpɨnd teskokinam waina b'ogɨl ngɨndngɨnd timtim jag wɨngawɨnga ke b'ogɨl gasa. Sɨ ra wɨn b'ɨtɨskokindam, ton opima towaina pɨs ke tepmɨndenanj ɨ ton ket opima tengendanj wa pɨlwa ɨ dɨde ket wen mɨ tenyoukanj. ");
INSERT INTO gdr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Wɨn erkena yiyena, ɨ wɨn ɨta okasya. Ɨ wɨn oraka yiyena, ɨ wɨn ɨta ket odarya. Ɨ wɨn mora odounena yiyena, ɨ ɨta mora wanɨm tɨpangenj. ");
INSERT INTO gdr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mop nokɨp komkesa rɨga yepiya ra erkena iyenyi, ton ɨta okasi, ɨ oraka iyenyi, ton ɨta odari, ɨ dɨde mora odounena iyenyi, mora ɨta towanɨm tepangenj. ");
INSERT INTO gdr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ɨ wa wɨngɨrɨnd yete re b'ɨga b'uwam, rada ti b'ɨgat erkis sanam, sɨ rɨngma, ti gɨmo e okau? ");
INSERT INTO gdr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O rada ti b'ɨgat erkis kabumɨm, sɨ rɨngma, ton gɨrem e okau? ");
INSERT INTO gdr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Sɨ onggɨt paemb nangga ma jɨ rada wɨn negɨrjog mɨle rɨga im, ajɨ wɨn wumɨr im wekenyɨt rɨdede e wa b'ɨgawar wa ogonam b'ogɨl gasa. Sɨ wa B'u yete re yɨbɨm pumb tungg wa, Ton re ma ɨja e ɨt re wɨn re dɨde, ajɨ Ton ɨmɨnjog opima b'ogɨljog gasa tagoniny towanɨm yepim re Tin yerkenyi. ");
INSERT INTO gdr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Sɨ onggɨt paemb wɨn ɨja na gasa tamnɨkaenindam rɨga wa odede rɨngma re wɨn singi aenindam rɨgap wa tamnɨkauranj. Mop nokɨp ɨtemb mɨle re gog yɨt e dɨde bageyam waina yɨt e kesam peba wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ɨ wɨn b'ɨgarenina sobijogjog mora nata menonɨm pumb tungg wa, mop nokɨp wul tunggɨm mora re moge warabag dɨde ɨtemb onggɨt mora ke nya ɨmaenam re wewa e rɨnsim re rɨga wɨp eyeniny de wul tungg wa, sɨ ma yɨpa kɨma rɨgapim onggɨt mora nata b'ɨgarena wuweny menonɨm onggɨt nyawɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ajɨ daka ɨtemb pumb tunggɨm mora re sobijogjog e dɨde ɨtemb onggɨt mora ke nya ɨmaenam re bebɨgjog e rɨnsim re rɨga wɨp eyeniny yɨrkokar wa, sɨ ma jog rɨgapim ɨtemb sobijogjog mora oraka yiyenyi b'ɨgarenam. ");
INSERT INTO gdr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ɨ wɨn yɨr kɨma tekenyɨt b'anygɨnena bageyam wa gatab. Opimemb b'anygɨnena bageyam wuweny wa pɨlwa re gɨm ke Godɨmna mamoi pɨla b'ogɨl b'ajgi rɨga im, ajɨ ngor ke ɨmɨnjog re wɨp ɨnggrawa kesa dɨ yongg pɨla rɨga im. ");
INSERT INTO gdr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Sɨ wɨn ten tangwatenindam ra towaina omnɨka kɨp kaim. Sɨ rɨngma, opima rɨgap greip kɨp eakɨkenenanj wanja kai wa pɨlke o pig kɨp eakɨkenenanj sisipa nangg wa pɨlke? Nayɨ, ma ɨja e. Ajɨ toda greip kɨp eakɨkenanj re greip nangg wa pɨlkaim, ɨ pig kɨp re pig nangg wa pɨlkaim. ");
INSERT INTO gdr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Sɨ odede yɨpa wɨp nya ke b'ogɨl wul nanggɨp tejagɨkanj ra b'ogɨl wulkɨp im, ajɨ negɨr wul nanggɨp tejagɨkanj ra negɨr wulkɨp im. ");
INSERT INTO gdr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ɨ b'ogɨl wul nanggɨt ma rɨrɨr e ɨjagenj negɨr wulkɨp, ɨ toda negɨr wul nanggɨt ma rɨrɨr e ɨjagenj b'ogɨl wulkɨp. ");
INSERT INTO gdr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ɨ komkesa wul nangg rɨnsim re maka b'ogɨl wulkɨp ejagɨkanj, yonggyam opima tegkiny dɨde wul wa teskokiny so omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sɨ onggɨt paemb wɨn b'anygɨnena bageyam tangwatenindam ra towaina omnɨki kɨp kaim. ");
INSERT INTO gdr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Sɨ ma komkesa rɨga im pumb tungg wa b'ɨtgarkanj yepim re tugɨm nena ke Ken nogenaenenyi da ‘Yonggyam, Yonggyam,’ ajɨ ton nena im b'ɨtgarkanj yepim re Kor B'u ma singi mɨle omnɨka eyenanj yete re yɨbɨm pumb tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ɨ ra b'ɨsagɨka bibɨr ik dem, jogjog rɨgapim Ken notɨnenyi dem da, ‘Yonggyam Yonggyam! Ma ma sɨn kea Moina nyɨ kɨma bage yɨt opurena eyentondam, ɨ Moina nyɨ kɨma negɨr wɨngawɨnga eaukena eyentondam, ɨ dɨde Moina nyɨ kɨma jogjog kɨd kesa kɨma danda wɨko omnɨka eyentondam?’ ");
INSERT INTO gdr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Sɨ Kon ket opima ten pɨtakɨpɨnd tamninyɨn dem da, ‘Kon makwa ngai wanɨm wumɨr awond. Negɨrjog mɨle omnɨka rɨga, wɨn ewaikisinam Kor pɨlke!’ ");
INSERT INTO gdr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Sɨ onggɨt paemb yet ra onggɨtyam Koina yɨtkak tutkundeniny dɨde omnɨkand b'itngaeny onggɨt yɨtkak rɨrɨrɨnd, ton ɨja e ɨte re b'ogɨl multekɨp kɨma met oranga rɨga re dɨde. Sɨ ton tina met yorang re ngortod wa emki danda rorte kumb nate. ");
INSERT INTO gdr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Sɨ nangga ma jɨ rada ukoi piro tɨgmarɨk dɨde ket ukoi ngɨwɨr ik, ɨ kwa rada ukoi rɨb b'ɨtkeny dɨde ket ɨtemb met ipou, ajɨ ɨtemb met makwa ɨta tosmulis. Mop nokɨp ɨtemb met re b'obogɨl orangi e ngortod wa emki danda rorte kumbɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ɨ yet ra onggɨtyam Koina yɨtkak tutkundeniny dɨde maka omnɨkand b'itngaeny onggɨtyam yɨtkak rɨrɨrɨnd, ton ɨja e ɨte re korɨrkorɨr met oranga rɨga re dɨde. Sɨ ton tina met yorang re bab tumɨnd emki rorte kumb nate. ");
INSERT INTO gdr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ɨ ra ket ukoi piro tɨgmarɨk dɨde ket ukoi ngɨwɨr ik, ɨ kwa ra ukoi rɨb ikeny dɨde ket ɨtemb met ipou, ɨ ɨtemb met ɨta tosmulis. Sɨ ɨtemb re ma sobijog wuwam kɨma e nenegɨr kana b'atɨskis.” ");
INSERT INTO gdr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ɨ re Yesu onggɨtyam yɨtkak opurena seg amninonj, rɨga bobop ma sobijog na kɨd kesa aento Tina ouyaena ke. ");
INSERT INTO gdr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mop nokɨp Ton auyaeninonj re odede na ɨt re Godɨmna danda kɨma rɨga re dɨde, ajɨ ma ɨja na ɨt re Ju rɨga waina gog ouyaena rɨga re dɨde. ");
INSERT INTO gdr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ɨ re Yesu onggɨt sukak ke paga wa etaeta ikonj, jogjog rɨga bobop Tin yɨmta undoka iyo. ");
INSERT INTO gdr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Sɨ yɨr de, yɨpa leprosi kopa rɨga ikonj Ti pɨlwa dɨde ket kumsos b'amkonj odede yɨt kɨma da, “Yonggyam! Ra man singi taet, Man rɨrɨr e ken kɨlkɨp kesa notɨnyɨt.” ");
INSERT INTO gdr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ɨ Yesu ket Tina yɨm b'ɨtnɨkonj dɨde ket tin yesopayonj odede yɨt kɨma da, “Kon ɨta singi, kɨlkɨp kesa ae!” Sɨ odenja ket ton kɨlkɨp kesa awonj onggɨt leprosi kopa ke. ");
INSERT INTO gdr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Seg ket Yesu tin yomnonj da, “Yɨr de, goro yama na usekainɨm dor. Ajɨ meke dɨde ket molenggyam b'atouyaet yɨna sɨ rɨgam pɨlwa. Sɨ man ket Godɨm sɨ gasa tanggɨkinyɨt dor ɨ eyinyɨt de yɨna sɨ rɨgam pɨlwa sɨ omnɨkam rɨna re Mose b'ingawa yoramitonj. Nokɨm da ɨdenat ton mɨtɨmjas rɨga wa wɨpɨnd da ‘Man kea b'ɨsakenjɨt dɨde kɨlkɨp kesa aet.’” ");
INSERT INTO gdr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ɨ re Yesu Kaparnaum taun mora wa b'ɨgaronj, yɨpa Roma andred (100) geja rɨga mopyam Ti wus wa ikonj dɨde ket Tin yɨgekitonj ");
INSERT INTO gdr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","odede yɨt kɨma da, “Yonggyam! Yɨpa koina wɨko rɨga re dɨmɨr kopa kɨma e pas nate yɨbɨm metɨnd, dɨde negɨrjog b'ɨdgotnena e yokateny.” ");
INSERT INTO gdr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Seg Yesu ket tin yomnonj da, “Kon ɨta tin ɨsakendam yopen.” ");
INSERT INTO gdr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Sɨ daka ɨtemb Roma andred (100) geja rɨga mopyam yɨsmonggawonj da, “Yonggyam! Kon ma odede rɨrɨrkɨpjog rɨga en Men yɨt omnam da, ‘Man b'ɨtgaret koina met wɨngɨr wa!’ Ajɨ b'ogla yɨt nena yopulite, sɨ ɨdenat koina wɨko rɨga b'ɨtɨsakenj. ");
INSERT INTO gdr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mop nokɨp koda re yɨpa juwai kɨma rɨga wɨra nate nɨbnyɨn dɨde kwa daka kor wɨrand opima geja rɨga nɨbnainy. Sɨ ra kon yɨpa geja rɨgand ingaen da ‘Meke,’ sɨ ton ɨta yik, ɨ ra kon kwa yɨpa rɨgand ingaen da ‘Metkɨm,’ sɨ ton ɨta ik. Ɨ kwa ra kon yɨpa koina wɨko rɨgand ingaen da ‘Man ɨtemb gasa yomnɨke,’ sɨ ton ɨta omnɨk.” ");
INSERT INTO gdr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Sɨ re Yesu tina yɨt utkundonj, Ton kɨd kesa na awonj dɨde ket ten amninonj yepiya re Tin yɨmta yundoko da, “Kon ɨmɨnjog wen tamninyɨn da Kon maike ya pɨlnat odede ɨmɨnjog gar ke utkunda rɨga yodarond Israel rɨga wa wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ɨ Kon wen tamninyɨn da jogjog God ma obagɨki kesa rɨga opima tuweny dem gowukoi komkesa gatab ke, ɨlemet ke dɨde kemagmet ke, ɨ dɨde ket diyamdiyampund pɨpmet takatenanj dem omitenam yɨpand Abraam kɨma ɨ Isak kɨma ɨ dɨde Yakob kɨma de pumb tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Sɨ Israel rɨgapim pop onggɨt pumb tunggɨm tɨb rɨga, ajɨ God opima ten teskokiny dem dea ta bau ke sɨbɨbsɨbɨb pɨpmet wa, dɨde ket amimemb de ton yii kamil b'iyowa tuweny dem, dɨde kopa b'angnena kɨma or b'ɨinɨka tuweny dem.” ");
INSERT INTO gdr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Seg ket Yesu ɨtemb Roma andred (100) geja rɨga mopyamɨnd yomnonj da, “Meke! Moina gar ke utkunda rɨrɨrɨnd ɨta mornɨm tawɨk.” Ɨ onggɨt wɨnjogɨnd kea ɨtemb tina wɨko rɨga b'ɨsakendonj. ");
INSERT INTO gdr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ɨ re ket Yesu yikonj Petromna met wa, Ton kea Petromna konggayam jeam yɨr wongonj re ton juwar map pasɨnd ekobliti wɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Sɨ re ket Yesu tina yɨmɨnd wesopayonj, juwarɨt tin wɨraronj. Seg ket ɨtomb kongga onyitonj dɨde ket Yesund yɨm yokawonj. ");
INSERT INTO gdr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ɨ re sɨ imokonj, rɨgap jogjog negɨr wɨngawɨnga ke imdi rɨga eyento Yesum pɨlwa. Ɨ ket Yesu Tina yɨtkak ke negɨr wɨngawɨnga eaukeninonj dɨde ket komkesa kopa rɨga esakenjinonj. ");
INSERT INTO gdr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Sɨ nangga pena Ton odede mɨle yomnɨkonj re onggɨt bageyam Isayamna opureni yɨtkak rɨrɨrkɨp omna mana ɨte re da, “Ton Tilenggyam meraina gɨm bodakak mɨle akasinonj, dɨde meraina kopa pokɨrɨnd b'ɨtangisinonj.” ");
INSERT INTO gdr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ɨ re Yesu rɨga bobo yɨr yongonj Tin ɨwatɨndenand, Ton ket Tina b'auyaena rɨga engainonj sɨpa tab wa ɨjendam. ");
INSERT INTO gdr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ɨ ket yɨpa Ju rɨga waina gog ouyaena rɨga Yesum pɨlwa ikonj, ɨ ket Tin yomnonj da, “Ouyaena rɨga! Kon ɨta men yɨmta undoka mitiyenyɨn rɨtata ra man metkenyɨt.” ");
INSERT INTO gdr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Sɨ Yesu ket tin yomnonj da, “Gongɨr wa opima towa wul bora wɨmenam, dɨde pumbɨnd ngena wa kwa opima towa met, ajɨ Rɨgamna B'ɨgam re awɨr e kwa Ti wɨmenapu pɨpmet mop owaglitam.” ");
INSERT INTO gdr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ɨ kwa yɨpa Tina b'auyaena rɨgat Tin yomnonj da, “Yonggyam! Kon yɨmta kae Mor pɨlwa tɨtenjɨn ajɨ naska kon kor b'und eungitam neken.” ");
INSERT INTO gdr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ajɨ Yesu tin yomnonj da, “Man yɨmta nundoke! Ajɨ toko wɨngawɨnga ke uj rɨgap gop raukinem towainajog uj rɨga.” ");
INSERT INTO gdr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Seg re ket Yesu gɨga wa angitonj, sɨ Tina b'auyaena rɨgap kea Tin daka yɨmta yundoko gɨga wa angitam. ");
INSERT INTO gdr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ɨ ket yɨr de, demb de ukoi depu rɨb b'atomonj onggɨt sɨpand, sɨ ɨdenatemb ket wurop ɨtemb gɨga ɨkangɨndena yiyo nyɨ b'auratam. Ajɨ Yesu re yutunga na yikonj. ");
INSERT INTO gdr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Sɨ Tina b'auyaena rɨgap Ti pɨlwa wuwonj dɨde ket yɨt opmura yiyeno odede yɨt kɨma da, “Yonggyam! Yɨm nokaine! Men momta im negɨr taindam.” ");
INSERT INTO gdr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ɨ ket Yesu ten amninonj da, “Utkunda kesa rɨga! Wɨn nangga paim mogamoga aenindam?” Ɨ Ton ket odenja utnyitonj dɨde ket rɨb ake sɨpa wuro samany eyowonj. Seg ket sɨpa kupkakupka mumakesajog awonj. ");
INSERT INTO gdr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Sɨ komkesa rɨga re kɨd kesa na aukɨto, dɨde ket endento da, “Sɨ rɨdede rɨga e jɨ? Rɨb ake sɨpa wuro todaka kea Tin yɨt yutkunjya!” ");
INSERT INTO gdr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ɨ re Yesu opendonj yɨpa sɨpa tab wa de Gadarene eriya wa, nɨmog negɨr wɨngawɨnga ke okati rɨgap Tin wɨpwɨp yomnonda yepiya re gɨmo yɨund oski gopmet ke opendonda. Sɨ osiemb rɨga nɨmog re ma sobijog wɨp ɨnggrawa kesa na ebnonda, sɨ onggɨt penaemb makwa yet rɨrɨr aukenenonj opandenam onggɨt nya nata. ");
INSERT INTO gdr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ɨ odenja ket ton obailitonda odede yɨt kɨma da, “God ma B'ɨga! Nangga e man singi yomnyɨt sowa pɨlɨnd? Sowa makaya ogeni wɨn yokas, ajɨ rɨngma, ma man naska kana e metket sɨn bebɨgɨnd oramitenam?” ");
INSERT INTO gdr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ajɨ onggɨt wɨnɨnd rɨgap kea dɨkɨnd towa wus ke jogjog b'om bobo ongena eyento. ");
INSERT INTO gdr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Sɨ negɨr wɨngawɨngap Yesund yɨgekito odede yɨt kɨma da, “Ra man sɨn notpenjinyɨt rɨga wa pɨlke, sɨ man bea ngai sɨn nɨtmɨkurine de onggɨt b'om bobo wa pɨlwa.” ");
INSERT INTO gdr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ɨ Yesu ket ten amninonj da “Wuwe!” Seg ton ket opekto onggɨt rɨga wa pɨlke, ɨ ket b'om wa pɨlwa b'ɨgarkɨto. Ɨ yɨr de, opimemb komkesa b'om bobo wanakana b'ɨkto sɨpa yuru kumb wa, ɨ ket sɨpa wa unykurto, ngɨrpu ket komkesa uj aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Sɨ opimemb b'om ongena rɨga b'ɨkento, ɨ re ton ket opekto taun wa, ton kea rɨga wumɨr amnento komkesa mɨle gatab rɨna re aukɨto dɨde kwa onggɨt gatab rɨna re negɨr wɨngawɨnga ke okati rɨga wa pɨlɨnd aukonj. ");
INSERT INTO gdr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ɨ yɨr de, komkesa taun rɨgap kea Yesund yɨr ongongɨm yopeno. Seg re rɨgap Yesund yɨr yongo, ton Yesund yerkito towaina eriya ke ewaikitam dɨde menonɨm deta b'enga gatab wa. ");
INSERT INTO gdr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ɨ Yesu ket gɨga wa angitonj dɨde ket tab ɨjendonj. Seg Ton ket yikonj Tinajog tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ɨ yɨr de, nɨnda rɨgap kea yɨpa dɨmɨr kopa rɨga tɨtɨnd yutungi iyo Yesum pɨlwa. Ɨ re Yesu towaina gar ke utkunda yɨr yongonj, Ton ket ɨtemb dɨmɨr kopa rɨgand yomnonj da, “B'ɨga! Goro nony bebɨg. Moina negɨr mɨle kemb awɨr auranj.” ");
INSERT INTO gdr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ɨ onggɨt wɨnɨnd nɨnda Ju rɨga waina gog ouyaena rɨga towaina gar ke endento da, “Onggɨt rɨgat God na yɨsadreny.” ");
INSERT INTO gdr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Sɨ Yesu kea towaina nony menamena wumɨr awonj, ɨ Ton ket yindonj da, “Nangga mop pae wɨn odede negɨrjog nony menamena amnɨkindam waina garɨnd? ");
INSERT INTO gdr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Rɨnte yɨt opulitam wewa ainy, ɨt re da ‘Moina negɨr mɨle kemb awɨr auranj’ o da, ‘Utnyite, ɨ menon yokate’? ");
INSERT INTO gdr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ajɨ Kon yɨpa gasa e omnɨken wen ouyawam da Rɨgamna B'ɨgam ɨta Ti danda gowukoyɨnd negɨr mɨle awɨr omnɨkam.” Seg ket Yesu dɨmɨr kopa rɨgand yomnonj da, “Utnyite, moina tɨt yurowate, ɨ moina met wa meke!” ");
INSERT INTO gdr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Seg ɨtemb rɨga utnyitonj, dɨde ket yiwatonj tina met wa. ");
INSERT INTO gdr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sɨ re rɨga bobop ɨtemb mɨle yɨr yongo, ton kea ukoi moga aukɨto dɨde ket Godɨnd esourena yiyeno yet re odede juwai akainonj rɨga wa. ");
INSERT INTO gdr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ɨ re Yesu ɨtemb pɨpmet yɨraronj, Ton kea yɨpa rɨgand yɨr yongonj omiti teks imdapu metɨnd, nyɨ da Matayo, dɨde ket tin yomnonj da, “Yɨmta nundoke!” Ngɨrpu ket Matayo utnyitonj dɨde ket Yesund yɨmta yundokonj. ");
INSERT INTO gdr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ɨ re ket Yesu diyam awowɨnd yɨbnonj Matayomna metɨnd, sɨ jogjog teks imdayam rɨga dɨde negɨr mɨleyam rɨga kea de wuwenonj onggɨt met wa ɨ ket Yesu dɨde Tina b'auyaena rɨga kɨma yɨpand diyam aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ɨ re Parisai rɨgap onggɨtyam mɨle yɨr yongo, ton kea Yesumna b'auyaena rɨga egekitto da, “Nangga mop pae waina ouyaena rɨga diyam ainy yɨpand teks imdayam dɨde negɨr mɨleyam kɨma?” ");
INSERT INTO gdr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ajɨ re Yesu odede yɨt utkundonj, Ton ket amninonj da, “Ma kopa kesa rɨgapim dokta singi omnyi, ajɨ kopa kɨma rɨgapim. ");
INSERT INTO gdr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ajɨ wɨn b'auyaenam wuwene nangga e onggɨtyam God ma yɨtkakɨt yisɨpkis ɨt re da, ‘Kon singi en kear mɨle ajɨ ma singi en sɨ b'angga.’ Mop nokɨp Kon ma negɨr kesa dɨmdɨmjog rɨga na tatupinond engendam negɨr mɨlem pɨlke de Godɨm pɨlwa, ajɨ negɨr mɨle kɨma rɨga na.” ");
INSERT INTO gdr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ɨ ket Yoanɨmna b'auyaena rɨga tuwonj Yesum pɨlwa dɨde ket yɨgekito da, “Nangga pae sɨn dɨde Parisai rɨga jogjogpyam owou uwabɨka wɨn yokatenyu, ajɨ Moina b'auyaena rɨgap re ma ɨta ton owou uwabɨka wɨn yokatenyi?” ");
INSERT INTO gdr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ɨ Yesu ten mɨra amninonj da, “Rɨngma, rɨrɨr e ton sisɨl kongga kɨma rɨgamna rɨgawarɨp gar bebɨg tekeny, ra ton sisɨl kongga kɨma rɨga dɨkɨnda towa wɨngɨrɨnd ɨbɨm? Ma rɨrɨr e. Ajɨ ɨta wɨn ik dem, ra sisɨl kongga kɨma rɨga tewaikis dem towa pɨlke, sɨ ɨdenatemb ton ket owou uwabɨka wɨn okatenyi dem. ");
INSERT INTO gdr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ɨ makwa ɨta yɨpa rɨgat sisɨl kobɨrgɨm kɨb ke kesam kobɨrgɨm bora pasi omɨny. Ra ton odede pasi omɨny ɨ dɨde ra ɨtemb pasi omni kobɨrgɨm nyɨ ke ɨsek, ɨta sisɨl kobɨrgɨm kɨb b'itɨnkur ajɨ kesam kobɨrgɨm ma ɨta b'itɨnkur. Sɨ onggɨt paemb ɨtemb sisɨl kobɨrgɨm kɨbɨt ɨta kesam kobɨrgɨm ɨnyowɨk dor pasi omnipund. Sɨ negɨrjog ukoi bora emb ket pɨta tainy. ");
INSERT INTO gdr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ɨ kwa rɨgap ma opima sisɨl ɨk angjɨkenenanj de kesam b'angga gɨm ke omnɨki ɨk ga wa. Mop nokɨp sisɨl ɨk ɨta ɨnɨka ik, ajɨ kesam b'angga gɨm ke omnɨki ɨk ga ra ma ɨta warabag tawɨk. Sɨ ra ton tangjɨkanj, ɨtemb sisɨl ɨkɨt opima kesam b'angga gɨm ke omnɨki ɨk ga temkiny. Sɨ ɨk ɨta tokombarɨk dɨde ket opimemb b'angga gɨm ke omnɨki ɨk ga daka opima negɨr taukanj. Ajɨ rɨgap sisɨl ɨk im angjɨkenenanj de sisɨl b'angga gɨm ke omnɨki ɨk ga wa. Sɨ ra odede tangjɨkanj, ɨk dɨde ɨk ga ra nɨmognɨmog b'ogɨl i tebnya.” ");
INSERT INTO gdr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ɨ re Yesu onggɨtyam yɨt towa pɨlwa apureninonj, yɨr de, yɨpa Ju rɨga waina yɨr opmitenapu met wɨp iyena rɨga ikonj dɨde ket Yesum pɨlwa kumsos b'amkonj ɨ dɨde ket yindonj da, “Koina ngɨmngai b'ɨga re otadejog na uj yokas. Ajɨ ra man metket dɨde moina yɨm oramisɨt ti pɨlɨnd, ton ɨta yilo okas.” ");
INSERT INTO gdr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Sɨ Yesu ket utnyitonj dɨde ket Yairond yɨmta yundokonj ɨ daka kea Tina b'auyaena rɨga ton kɨma wuwonj. ");
INSERT INTO gdr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ɨ onggɨt wɨnɨnd yɨpa kongga yet re kus opekenenonj twelp (12) kemag kɨma, ton Yesum kak kena wikonj dɨde ket Tina kobɨrgɨm petɨr yesopayonj. ");
INSERT INTO gdr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mop nokɨp ton kea tina garɨnd windonj da, “Ra kon tina kobɨrgɨm nena esopaen, kon ɨta b'ɨtɨsakenjɨn.” ");
INSERT INTO gdr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu wɨp engendonj kak wa dɨde ket ɨtomb kongga yɨr wongonj ɨ ket womnonj da, “Ngɨmngai b'ɨga, goro gar bebɨg! Sɨ moina gar ke utkundate men mɨsakenj.” Seg odenja ket ɨtomb kongga b'ɨsakendonj. ");
INSERT INTO gdr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ɨ re Yesu onggɨt wɨp iyena rɨgamna met wa b'ɨgaronj, Ton kea wugewuge ɨpaya rɨga dɨde omanayam rɨga bobo guglam mɨlend yɨr anginonj. ");
INSERT INTO gdr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Sɨ Yesu yindonj da, “Wɨn ewaikurina! Mop nokɨp ɨtomb ngɨmngai b'ɨga re ma uj o, ajɨ yɨt o weg.” Ajɨ rɨgap Yesund ngong na yengeno. ");
INSERT INTO gdr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ɨ re Yesu rɨga bobo bau wa ewaikeninonj, Ton kea wɨngɨr wa b'ɨgaronj rɨkɨnd re ngɨmngai b'ɨga wɨbnonj, dɨde ket ngɨmngayɨnd yɨmɨnd wemoratonj, ngɨrpu ket ɨtomb ngɨmngai b'ɨga onyitonj. ");
INSERT INTO gdr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Seg ket kea onggɨt ngɨmngai b'ɨgam gatab yɨdɨr yɨt warabag auka yikenonj kupka onggɨt eriya nata. ");
INSERT INTO gdr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ɨ re Yesu ɨtemb pɨpmet yɨraronj dɨde ket menon yokatonj, nɨmog yɨrdɨdɨ rɨgap Tin yɨmta yundokonda dɨde ket ara yɨawonda da, “Yonggyam, Dawidɨmna B'ɨgawɨi! Sɨn kear nomne-o!” ");
INSERT INTO gdr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ɨ re Yesu met wa b'ɨgaronj, osiemb jɨ ket nɨmog yɨrdɨdɨ rɨga Yesum pɨlwa tetkonda. Sɨ Yesu ket ten amnonj da, “Osiya wɨn gar ke utkunda ke yokasya da Kon rɨrɨr e onggɨtyam wɨko omnɨken?” Ɨ osiemb ket Tin mɨra yomnonda da “Owɨ, Yonggyam.” ");
INSERT INTO gdr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ɨ odedend ket Yesu towaina yɨrkɨp asopainonj odede yɨt kɨma da, “B'ogla wa pɨlɨnd rawɨk waina gar ke utkunda rɨrɨrɨnd!” ");
INSERT INTO gdr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Sɨ Ton kea ket towaina yɨrkɨp epangkinonj. Seg Yesu ket ten danda kɨma nonony amnonj da, “Yɨr de, wɨn goro yena wumɨr omna onggɨt gatab!” ");
INSERT INTO gdr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ajɨ re ton ewaikitonda, ton kea Yesum gatab yɨdɨr yɨt warabag omnɨka yiyenonda kupka onggɨt eriya nata. ");
INSERT INTO gdr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ɨ onggɨt wɨnɨnd re osiemb rɨga nɨmog ewaikitonda, rɨgap yɨpa negɨr wɨngawɨnga ke okati yɨt kesa rɨga iyo Yesum pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ɨ Yesu ket negɨr wɨngawɨnga yewaikitonj, sɨ ɨtemb yɨt kesa rɨgat ket yɨt apureninonj. Sɨ rɨga bobo kea ket kɨd kesa aena wuwenonj odede yɨt kɨma da, “Makwa ke ngai odede mɨle pɨta awonj Israel wɨngɨrɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ajɨ Parisai rɨgap ket endento da, “Ton negɨr wɨngawɨnga ewaikeneniny re negɨr wɨngawɨnga waina mopyamɨmna danda kae.” ");
INSERT INTO gdr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ɨ Yesu yikenonj komkesa taun nata dɨde tungg nata, ɨ Ton kea kwa towaina yɨr opmitenapu met nata rɨga ouyaena eyeninonj God ma yɨt, dɨde pumb tunggɨmna b'ogɨl yɨrkokar bage yɨt pɨtapɨta omnena yiyenonj ɨ dɨde kwa kea rɨga ɨsagɨka eyeninonj komkesa b'engabenga wɨp kopa ke. ");
INSERT INTO gdr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ɨ re Yesu rɨga bobo yɨr ongong eyeninonj, Ton ma sobijog na ten gar ke kear amneninonj. Mop nokɨp ton wekenonj re nony bebɨg nat dɨde yɨg nony nat rɨngmim ra mamoi tekeny yɨr ɨpka rɨga kesa. ");
INSERT INTO gdr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Sɨ Ton ket Tina b'auyaena rɨga amninonj da, “Erngokam re jogjog im, ajɨ wɨko rɨga re ma jog im. ");
INSERT INTO gdr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Sɨ onggɨt paemb wɨn erngoka Yonggyamɨnd yɨgekena odede da, ‘Man wɨko rɨga etmɨkisine Moina erngokapu gou wa.’” ");
INSERT INTO gdr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ɨ Yesu Tina twelp (12) b'auyaena rɨga ara emokinonj b'eomam, ɨ Ton ket towa ukoi juwai akainonj negɨr kɨlkɨl wɨngawɨnga gou wa omnenam, nokɨm da ɨdenat ton opimemb negɨr wɨngawɨnga teaukenenanj dɨde ton rɨga ɨsagɨka teyenanj komkesa b'engabenga wɨp kopa wa pɨlke. ");
INSERT INTO gdr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Sɨ opimemb jɨ twelp (12) ɨtmɨkitijog rɨga waina nyɨ, naskajog Simon yena re yogenayo da Petro, ɨ ti yɨnggan Andrea, ɨ Jebedaimna b'ɨga Yakobo dɨde ti yɨnggan Yoan, ");
INSERT INTO gdr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip, ɨ Batolomeo, Toma ɨ teks imdayam Matayo, Alpayomna b'ɨga Yakobo, ɨ Tadayo, ");
INSERT INTO gdr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon yena re yogenayo Kanana rɨga ke, ɨ Yudas Iskariyot yet re Yesund tɨb yiyonj. ");
INSERT INTO gdr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ɨ Yesu opimemb twelp (12) ɨtmɨkitijog rɨga etmɨkisinonj odede nonony yɨtkak kɨma da, “Goro God ma obagɨki kesa rɨga waina nya nata tuwenɨm, ɨ goro Samariya rɨga waina taun nata tuwenɨm. ");
INSERT INTO gdr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ajɨ wɨn adea ta tuwenyɨt Israel kantrimna b'edamkuri God ma mamoi wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ra wɨn tuwenyɨt, wɨn ɨnte pɨtapɨta omnena iyenya da, ‘Pumb tungg re ke ɨte ke wa wus nate ainy.’ ");
INSERT INTO gdr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ɨ kopa rɨga tesakindam, ɨ uj rɨga tutnɨkindam, ɨ leprosi kopa rɨga kɨlkesa tamnɨkindam, ɨ dɨde negɨr wɨngawɨnga teaukenindam. Ɨ wɨn kea jabajaba onggɨtyam yiyag wurar akatentondam, sɨ wɨdaka b'ogla jabajaba rɨga yɨm okaena teyenindam onggɨt yiyag wurar ke. ");
INSERT INTO gdr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Goro nangga wulkɨp na eyina waina pausond, opi re romyam ɨ kɨpyam ɨ dɨde ujujyam wulkɨp. ");
INSERT INTO gdr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ɨ kwa goro owou ga kɨma, ɨ goro kobɨrgɨm talomam kɨma, ɨ goro nɨmog burur yongɨnkak kɨma ɨ dɨde goro kwa weweyam kutɨp kɨma. Mop nokɨp wɨko rɨga re rɨrɨrkɨpjog rɨga im owou dɨde nɨnda ingaena gasa okatenam rɨga wa pɨlke. ");
INSERT INTO gdr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ɨ ra wɨn b'ɨtgarkindam yɨpa taun wa o yɨpa tungg wa, demb de wɨn odede rɨga na tarakindam yepiya ra rɨrɨrkɨpjog rɨga tekeny wen obai omnenam. Sɨ wɨn adea ton kɨma wɨmena tuwenyɨt, ngɨrpu ra ket wɨn iwasya onggɨt gou ke. ");
INSERT INTO gdr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Rɨdenat ra wɨn onggɨt met wa b'ɨgarena tuwenyɨt, wɨn b'ogla onggɨt metam rɨga b'ogɨl tamnenindam ngɨmbla yɨt ke. ");
INSERT INTO gdr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ɨ rada onggɨt metam rɨgap rɨrɨrkɨpjog im onggɨtyam ngɨmbla yɨt okatenam, sɨ ɨtemb waina ngɨmbla yɨt b'ogla omanda yebɨm towa pɨlɨnd. Ajɨ rada ton ma rɨrɨrkɨpjog rɨga im okatenam, sɨ ɨtemb waina ngɨmbla yɨt ɨta tɨtenj wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ɨ yet ra maka ra simesime wen tamniny, o maka ra waina yɨt tutkundenanj, sɨ wɨn ɨdenatemb ket onggɨt met o onggɨt taun ke iwasya. Ɨ onggɨt iwata wɨnɨnd wɨn b'ogla waina pɨspamɨnd sungar tedbenenindam towanɨm nony aukam da towaina negɨr mɨle b'ɨsagɨkam wɨn ɨta ik dem. ");
INSERT INTO gdr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ɨ Kon ɨmɨnjog wen tamninyɨn da ra b'ɨsagɨka bibɨr ik dem, Sodom rɨgap dɨde Gomora rɨgap ukoi bebɨg e okatenyi dem ajɨ onggɨt taun rɨgap mogjog bebɨg e okatenyi dem. ");
INSERT INTO gdr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Sɨ yɨr de, Kon wen etmɨkeninyɨn re odede wɨp im rɨngmim ra rɨgat mamoi tetmɨkisiny dɨ yongg wa wɨngɨr wa. Sɨ onggɨt paemb wɨn b'ogla b'ogɨl multekɨp kɨma rɨga taukindam odede ɨte re gɨrem re dɨde, ɨ kwa b'ogla b'injawa kesa rɨga taukindam odede ɨte re gimai re dɨde. ");
INSERT INTO gdr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Sɨ wɨn yɨr kɨma tekenyɨt rɨga wa pɨlke! Mop nokɨp ton opima wen pumbjog Sanedrin kot wa oramka teyenanj ɨ ton opima wen ɨraska teyenanj towaina yɨr opmitenapu met nata. ");
INSERT INTO gdr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Sɨ rɨgap opima Kor map wen ɨgonyɨgony teyenanj dem de ukoi gabmani rɨga wa wɨp wa dɨde king wa wɨp wa, nokɨm da ɨdenat wɨn Kor gatab yɨr ungata rɨga taukindam towanɨm dɨde God ma obagɨki kesa rɨga wanɨm. ");
INSERT INTO gdr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ajɨ onggɨt wɨnɨnd ra rɨgap wen kot wa oramka teyenanj, goro wɨn nony kubɨr taukinam nangga yɨt im wɨn tapurenindam. Mop nokɨp onggɨt wɨnɨnd God opima wa tagoniny yɨtkak rɨnsim ra wɨn b'ogla tapurenindam. ");
INSERT INTO gdr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mop nokɨp yɨt opurena rɨga re ma wɨnsim, ajɨ mera B'u Godɨmna Wɨngawɨngate yete re yɨt opurena eyeniny waina garɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ɨ gar ke utkunda rɨga wɨngɨrɨnd opima towainajog nany o yɨnggan kot wa oramka teyenanj dem uj ondrɨkam ɨ dɨde kwa ti b'uɨt ti b'ɨgand. Ɨ b'ɨgawarɨp opima towa b'uwar ake towa mogwar geja teyenanj dem dɨde ket ten uj ondrɨka teyenanj dem. ");
INSERT INTO gdr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ɨ kwa komkesa rɨgap opima wen singi kesa tamnenanj dem Koina nyɨ map. Ajɨ yepiya ra mɨmkam wɨmena tuweny ngɨrpu ama re de onggɨt gowukoi kikitum wɨn wa, ton ɨta okasi dem dadal ngɨrpu kesa yɨrkokar. ");
INSERT INTO gdr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ɨ ra rɨgap wa pɨlɨnd bebɨg dɨde b'ɨsadrena mɨle omnɨka teyenanj yɨpa taunɨnd, sɨ wɨn b'ogla b'ɨtkenindam kwa yɨpa taun wa. Mop nokɨp Kon ɨmɨnjog wen tamninyɨn da wɨn makwa opima komkesa Israel rɨga waina taun tundwasindam dem God ma b'ogɨl yɨrkokar bage yɨt pɨtapɨta omnena ke, ngɨrpu onggɨt wɨnɨnd ra Rɨgamna B'ɨga tɨtenj dem. ");
INSERT INTO gdr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ɨ b'auyaena b'ɨga re ma ɨta tina ouyaena rɨgand ɨgwanjis pumb wa dɨde kwa wɨko rɨga re ma ɨta tina yonggyamɨnd ɨgwanjis pumb wa. ");
INSERT INTO gdr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sɨ ɨtemb re b'auyaena b'ɨgam rɨrɨrkɨpjog e ton kupkakupka wumɨr okas tina ouyaena rɨga re dɨde, ɨ dɨde kwa wɨko rɨgam rɨrɨrkɨpjog e ton ɨsnawa okateny odede ɨt re tina yonggyam re dɨde. Ɨ Kon re Godɨmna metɨnd Yonggyam e nɨbnyɨn dɨde wɨn re met wɨko rɨga im. Sɨ rada rɨgap Ken nyɨ nogenaenenyi Beeljebul kae, ɨt re Satana, sɨ ma sobijog nenegɨr nyɨ kaim wen daka ogenaya teyenanj. ");
INSERT INTO gdr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Sɨ onggɨt paemb wɨn goro ten moga tuwajinam, mop nokɨp God opima komkesa kupkakupka ɨkangɨndi gasa pɨta wa tapekiny dem, dɨde komkesa wɨgawɨga egurki gasa wumɨr tamnɨkiny dem. ");
INSERT INTO gdr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sɨ nangga na re Kon wa wɨgawɨga apurenainond sɨbɨbɨnd, wɨn b'ogla rɨga wa tapurenaindam dem bibɨrtɨkɨnd. Ɨ nangga na re wɨn tu muma ke yɨpya borand utkundentondam, wɨn b'ogla pɨtapɨta tamnenindam dem rɨga bajbajɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Goro moga tuwajinam ten yepim re rɨga jɨ nena uj andrɨkenenanj ajɨ ma rɨrɨr im wɨngawɨnga uj tandrɨkenenanj. Ajɨ wɨn Godɨnd moga yuwada yama re Ti danda yɨbnau yɨpand wɨngawɨnga ake jɨ uj ondrɨkam dɨde ket wul tungg wa ɨskokam. ");
INSERT INTO gdr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Sɨ rɨngma, ma ma rɨgap nɨmog sobijog ngena paib (5) Toya kaim emdenenanj? Ajɨ osiemb nɨmog ngena wɨngɨrɨnd makwa yɨpa ɨta gou wa tɨsenj wa B'u Godɨmna ingai kesa. ");
INSERT INTO gdr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ajɨ God re opima wen b'obogɨl yɨr ɨpka eyeniny, nangga ma jɨ da Ton kwa opima ogenka eyeniny komkesa mopngɨi waina mopɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Sɨ onggɨt paemb wɨn goro moga taeninam, mop nokɨp wɨn re ukoijog ɨsnawa kɨma im, ajɨ ma ɨja im opi re jogjog sobijog ngena re dɨde. ");
INSERT INTO gdr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Sɨ yet ra rɨga wa wɨpɨnd Ken pɨtapɨta notɨneny, Kodaka ɨta tin pɨtapɨta omnyɨn dem Kor B'u Godɨm wɨpɨnd yete re yɨbɨm pumb tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ajɨ yet ra rɨga wa wɨpɨnd Ken oena nitiyeny, Kodaka ɨta tin oenyɨn dem Kor B'u Godɨm wɨpɨnd yete re yɨbɨm pumb tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ɨ wɨn goro nony taindam da Kon rɨga wa ngɨmbla okawa mana netkond dɨkɨnd onggɨt gowukoyɨnd. Ɨ Kon netkond re ma ngɨmbla okawa mana ajɨ geja giri ke b'ipowa mana. ");
INSERT INTO gdr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mop nokɨp Kon netkond re rɨga wɨngɨrɨnd geja omnɨka mana, rɨga b'ɨgat ti b'uɨm pɨlɨnd, ɨ todaka ngɨmngai b'ɨgat ti mogɨm pɨlɨnd, ɨ daka kwa ti dadɨt moleg ti dadɨm pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Sɨ yɨpa rɨgam geja rɨga re tinajog b'ubɨgawar im taukanj dem. ");
INSERT INTO gdr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ɨ yet ra ukoi kana singi iyeny ti b'und o ti mogɨnd ajɨ maka ra Ken ukoi kana singi nitiyeny, ton ma rɨrɨrkɨpjog rɨga e Ken yɨmta undokam. Ɨ daka yet ra ukoi kana singi iyeny tina leo b'ɨgand o tina ngɨmngai b'ɨgand ajɨ maka ra Ken ukoi kana singi nitiyeny, ton ma rɨrɨrkɨpjog rɨga e Ken yɨmta undokam. ");
INSERT INTO gdr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ɨ kwa yet ra maka komkesa tinajog bebɨg takasiny Godɨm wɨkond odede rɨngma ra rɨgat tina wul b'agbag urowas ujɨm dɨde maka ra Ken yɨmta nutundok, ton ma rɨrɨrkɨpjog rɨga e Ken yɨmta undokam. ");
INSERT INTO gdr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ɨ yet ra tilenggyam yɨrkokar yɨrgong omnɨka iyeny, ton ɨta onggɨtyam tina yɨrkokar dadal edamkis dem. Ajɨ yet ra tina yɨrkokar edamkis Kor map, ton ɨta tina yɨrkokar yilom omɨny dem. ");
INSERT INTO gdr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ɨ yet ra wen takateniny, ton Kena nokateny. Ɨ yet ra Ken notkateny, ton Tina yokateny yet re Ken nɨtmɨkitonj. ");
INSERT INTO gdr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ɨ yet ra okas yɨpa God ma bageyam onggɨt map da ton re yɨpa God ma bageyam e, sɨ ton ɨta yɨpa wɨp mɨra okas onggɨt God ma bageyam kɨma. Ɨ daka yet ra okas yɨpa negɨr kesa dɨmdɨmjog rɨga onggɨt map da ton re yɨpa negɨr kesa dɨmdɨmjog rɨga e, sɨ ton ɨta yɨpa wɨp mɨra okas onggɨt negɨr kesa dɨmdɨmjog rɨga kɨma. ");
INSERT INTO gdr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ɨ kwa daka yet ra yɨpa sobijog rɨgam yɨpa kapo nyɨ okau onggɨt Koina b'auyaena rɨga wa wɨngɨrɨnd onggɨt map da ton re Koina b'auyaena rɨga e. Sɨ Kon ɨmɨnjog wen tamninyɨn da tina mɨra ma ɨta awɨr tainy dem.” ");
INSERT INTO gdr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ɨ re Yesu Tina twelp (12) b'auyaena rɨga wa pɨlwa nonony yɨt seg awonj, ton ket onggɨt tungg ke yiwatonj dɨde menon yokatenonj taun nata Galili eriya wɨngɨrɨnd demb de rɨga ouyaenam dɨde God ma b'ogɨl yɨrkokar bage yɨt pɨtapɨta omnenam. ");
INSERT INTO gdr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ɨ re Baptiso Yoan sɨbɨbmetɨnd yɨbnonj, ton kea yɨt utkundenonj nangga wɨko na re Keriso amnɨkinonj. Sɨ ton ket Kerisom b'arkita yɨt yɨtmɨkitawonj tina b'auyaena rɨga wa pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Sɨ ɨnaemb jɨ Yoan b'arkita yoramitonj da, “Yesu! Ma man Kerisotet yet ra Godɨm pɨlke ik? O mɨnda sɨn yɨpa b'enga rɨga na yɨr ungauku?” ");
INSERT INTO gdr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ɨ Yesu ket ten mɨra amnonj da, “Wɨn eka Yoanɨm pɨlwa, ɨ tin wumɨr omnenya nangga na re wɨn utkundenya dɨde yɨr anginya, ");
INSERT INTO gdr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","odede mɨle opi re da yɨrdɨdɨ rɨga yɨr epangkanj, ɨ gomgom rɨga menon akatenanj, ɨ leprosi kopa rɨga kɨlkɨp kesa aukanj, ɨ yɨpya dumdum rɨga utkundenanj, ɨ uj rɨga utnɨkanj, ɨ dɨde God ma b'ogɨl yɨrkokar bage yɨt pɨtapɨta auka yikeny gasa kesa rɨga wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Sɨ God ma b'ogɨl ɨta ton kɨma yet ra onggɨtyam Koina mɨle gatab yɨt tutkunj ɨ ɨngkaemb ket ton maka sap totenj gar ke utkunda kesa mɨle wa.” ");
INSERT INTO gdr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ɨ re Baptiso Yoanɨmna bageyam rɨgap yiwatonda, Yesu ket Yoanɨm gatab yɨt b'atomonj rɨga bobo wa pɨlwa da, “Wɨn nanggamog gasa na yɨr ongongɨm yoponda wul kesa tungg wa? Rɨka rɨb ma ɨtegreni bus na? ");
INSERT INTO gdr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ɨ rada maka, sɨ wɨn nanggamog gasa na yɨr ongongɨm yoponda? Rɨka otomanti b'ogɨl kobɨrgɨm b'ikoki rɨga na? Nayɨ, ma opima de. Ajɨ odede b'ogɨl ngɨndngɨnd kobɨrgɨm b'ikoki rɨga wekeny re king waina met nasim. ");
INSERT INTO gdr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ɨ rada maka, sɨ wɨn nanggamog gasa na yɨr ongongɨm yoponda? Rɨka bageyam na? Owɨ, ɨmɨnjog e. Kon wen tamninyɨn da ton re ukoijog bageyam e ajɨ ma odede e ɨt re naskanyam bageyam re dɨde. ");
INSERT INTO gdr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sɨ Yoan re onggɨtyam rɨga e ya gatab e odede yɨna peband ɨrɨki yɨbɨm da, ‘Yɨr, ɨta Koina bageyam ɨtmɨkisɨn dem Mor naska nya wa, yet ra Mor wɨp ke menon okas ɨ Mornɨm menonɨm nya motngonjenau dem.’ ");
INSERT INTO gdr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ɨ Kon ɨmɨnjog wen tamninyɨn da makwa ɨta yɨpa ukoijog nyɨ rɨga odede Baptiso Yoan re dɨde komkesa rɨga wa wɨngɨrɨnd yena re konggap ukka eyenanj. Ajɨ yete re sobijogjog nyɨ rɨga yɨbɨm pumb tunggɨnd, ton re ukoijog nyɨ rɨga e ajɨ Yoan re ma ukoi nyɨ rɨga e. ");
INSERT INTO gdr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ɨ ɨngkek re Baptiso Yoan wɨko yotomonj ngɨrpu yu rɨgap pumb tungg okatam danda ondratena yiyeneno. Sɨ odede nya kena onggɨt ɨl ongka rɨgap ɨtemb pumb tungg yokateno. ");
INSERT INTO gdr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mop nokɨp komkesa bageyam waina pebap dɨde Mosemna gog pebap God ma bage yɨt pɨtapɨta omnena teito ngɨrpu Yoan wɨko yotomonj. ");
INSERT INTO gdr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Sɨ ra wɨn singi onggɨt kesam peba ke bage yɨt ɨmɨnjog ke takatenindam, sɨ ɨtemb rɨga Yoan re Eliyate ya gatab e re pebap yusenenyi da ton ɨta ik. ");
INSERT INTO gdr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Sɨ yete re man wɨngawɨnga ke yɨpya kɨma, man utkunde! ");
INSERT INTO gdr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ajɨ nanggamog gasa kae Kon yɨpa rɨrɨrkɨp tamninyɨn rɨga yepim re yu wekeny onggɨt gowukoyɨnd? Sɨ ton re yɨpa rɨrɨrkɨp rɨga im odede rɨngmim ra b'ɨga sobijog omnɨki tekeny nɨmog bobond tungg aband, ɨ yɨpa bobo b'ɨgawarɨp kwa yɨpa bobo b'ɨgawar yɨt tugwatenanj ");
INSERT INTO gdr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","odede opurena kɨma da, ‘Sɨn pop wa pate ara epayau, ajɨ wɨn makwa omarkindam. Ɨ sɨn pop wa nony b'uwou kɨma ger atangau, ajɨ wɨn makwa yii wuwenyɨt.’ ");
INSERT INTO gdr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mop nokɨp re Yoan ikonj, ton maka owou aweneninonj nɨnda rɨga re dɨde ɨ dɨde maka ɨk anaikeneninonj, sɨ rɨgap ti gatab endenenanj da, ‘Ton re negɨr wɨngawɨnga ke okati rɨga e.’ ");
INSERT INTO gdr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ɨ re Rɨgamna B'ɨga ikonj, ɨ owou aweneninonj dɨde ɨk anaikeneninonj, sɨ rɨgap endenenanj da, ‘Yɨr, Ton re oba owou rɨga e dɨde oba ɨk onaika rɨga e, ɨ dɨde Ton re teks imdayam dɨde negɨr mɨleyam wa rɨga e.’ Ajɨ komkesa wɨko rɨnsim re Godɨmna multekɨp ke amnɨkenenanj, tontemb ɨmɨnjogɨm yomnenyi da Godɨmna multekɨp re negɨr kesa dɨmdɨmjog e.” ");
INSERT INTO gdr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ɨ Yesu nɨnda taun ke rɨga mong ɨdngawa eyeninonj rɨkɨnd re Ton jogjog kɨd kesa kɨma danda wɨko omnɨka eyeninonj, mop nokɨp ton maka towaina negɨr mɨle ke engento de Godɨm pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Sɨ Yesu ten amninonj da, “God ma sake man kɨma Korajin, ɨ God ma sake man kɨma Betsaida. Mop nokɨp rako Kon opimemb kɨd kesa kɨma danda wɨko amnɨkinond de negɨr kɨma Tiro taun ake Sidon taunɨnd rɨna re Kon wa wɨngɨrɨnd amnɨkeninonj, ton kako b'ila rongg b'ikokto dɨde ket wumbol kumbɨnd omnɨkto negɨr mɨle ke engendam de Godɨm pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ajɨ Kon wen wumɨr tamninyɨn da ra b'ɨsagɨka bibɨr ik dem, Tiro ake Sidon towanɨm ra ukoi bebɨg e dem, ajɨ wanɨm ra dem b'usaya mogjog bebɨg e okasya dem. ");
INSERT INTO gdr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ɨ kwa man, Kaparnaum, ɨta man wub kumb wa b'uturowasɨt dem? Nayɨ, man ɨta tiglet dem de uj rɨga waina tungg wa. Mop nokɨp rada Kon kea amnɨkinond kɨd kesa kɨma danda wɨko rɨna re Kon wa wɨngɨrɨnd amnɨkeninonj de Sodom taunɨnd, ɨtemb taun kakoa omanda yɨbɨm ngɨrpu yu. ");
INSERT INTO gdr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ajɨ Kon wen wumɨr tamninyɨn da ra b'ɨsagɨka bibɨr ik dem, Sodom gowɨm ra ukoijog bebɨg e okas dem, ajɨ mornɨm ra dem b'usaya mogjog bebɨg e okasɨt dem.” ");
INSERT INTO gdr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ɨ onggɨt wɨnɨnd Yesu yɨt pɨtapɨta amneninonj da, “Abu, wub ake gowukoyɨm Yonggyam! Kon sɨteket yɨt momnyɨn, nokɨp Man ke onggɨtyam Moina danda dɨde yɨrkokar yɨtkak agurkinot rɨga wa pɨlke yepim re b'ogɨl multekɨp kɨma dɨde b'ogɨl wumɨr kɨma wekeny. Ajɨ Man kea onggɨtyam Moina gasa towanɨm pɨtapɨta amnenainot yepim re b'ɨga sobijog pɨla wumɨr kesa wekeny. ");
INSERT INTO gdr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Abu, ɨmɨnjog e. Onggɨtyam gasa aukonj re Moina b'ogɨl sam kɨma singi nat. ");
INSERT INTO gdr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Komkesa danda dɨde wumɨr re Kor B'uɨt Kor mana nogoninonj ingaenam. Ɨ makwa yɨpa ɨta yete wumɨr B'ɨgam gatab, ajɨ B'uta tinta wumɨr. Ɨ makwa ɨta yete wumɨr B'uɨm gatab, ajɨ tonpima wumɨr, B'ɨga dɨde rɨga yena re B'ɨgat singi eyeniny B'und pɨta omnenam towa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Sɨ gog ouyaena rɨgap ma sobijog bebɨg kɨma b'ingawa im wanɨm aramkenenanj, sɨ wɨn opima dɨnder kɨma b'asowa akatenindam dɨde bebɨg urowatenindam yɨrkokar okatam. Sɨ wɨn komkesa tuyɨm Kor pɨlwa, Kon toko wa wɨram rakainɨn. ");
INSERT INTO gdr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ɨ wɨn ɨna bebɨg yurowata rɨnte re Kon wa pɨlɨnd yoramitenyɨn wa yɨrkokar okawam, dɨde wɨn b'auyaena tuwenyɨt Kor pɨlke, mop nokɨp Kon re wɨngawɨnga ke nony kɨma muske wɨmena rɨga en dɨde Kolenggyam gou wa b'amnena rɨga en. Sɨ waina wɨngawɨngap ɨta yɨrkokar okasi dɨde ket wɨn ɨta wɨram odarya Kor pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mop nokɨp wɨn rɨrɨr im ɨtemb bebɨg sam kɨma okatenam rɨnte re Kon wa pɨlɨnd yoramitenyɨn yɨrkokar okawam, dɨde Ken yɨmta undokam nya re ma bebɨg e.” ");
INSERT INTO gdr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ɨ onggɨt wɨnɨnd Yesu wit sopapu yuru nata yikonj Ju rɨga waina wɨram dɨde yɨr opmitena bibɨrɨnd. Ajɨ Tina b'auyaena rɨga re owoupa na wekenonj, sɨ ton kea ket b'atomto wit kolkak utouka dɨde ket kɨp auto. ");
INSERT INTO gdr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ɨ re Parisai rɨgap ɨtemb mɨle yɨr yongo, ton Yesund yomno da, “Nangga pae Moina b'auyaena rɨgap onggɨtyam mɨle yomnɨki rɨnte re ma yiyag e omnɨkam meraina wɨram dɨde yɨr opmitena bibɨrɨnd?” ");
INSERT INTO gdr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ɨ Yesu ten mɨra amninonj da, “Ma ke wɨn yɨna peba yogenkonda onggɨt yɨtkak gatab rɨna re Dawid Mosemna gog yɨt yerbekonj, re ton dɨde ton kɨma meni rɨga owoupand wekenonj? ");
INSERT INTO gdr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Sɨ rɨdede na ton b'ɨgaronj Godɨmna yɨnamet wa? Ɨ rɨdede na ton yɨna sana awinonj rɨna re tinɨm dɨde ton kɨma meni rɨga towanɨm gog na yɨbnonj owowɨm, ajɨ yɨna sɨ rɨga wa nena ma owou? ");
INSERT INTO gdr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ɨ kwa yɨna sɨ rɨgap sɨ amnɨkenenanj yɨnametɨnd ita Ju rɨga waina wɨram dɨde yɨr opmitena bibɨr weanjweanj, sɨ odede mɨle kaemb ton Ju rɨga waina wɨram dɨde yɨr opmitena bibɨr gog yerbekenenyi. Ajɨ ton makwa opima b'injawa yokatenyi. Sɨ rɨka wɨn ma wumɨr im onggɨtyam yɨtkak Mosemna gog wɨngɨrɨnd? ");
INSERT INTO gdr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Sɨ Kon wen wumɨr ramninɨn da rɨgap yɨnamet e ukoi yomnenyi ajɨ ɨta yete yɨbɨm dɨkɨnd, Tonta ukoijog. ");
INSERT INTO gdr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Sɨ ra wɨn wumɨr okasya onggɨtyam yɨtkak isɨpkita ɨt re da, ‘Kon singi en kear mɨle ajɨ ma singi en sɨ b'angga,’ wɨn ma rako b'injawa kesa rɨga negɨr ma b'ɨsagɨkand oramka eyenindam. ");
INSERT INTO gdr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mop nokɨp Rɨgamna B'ɨga re Ju rɨga waina wɨram dɨde yɨr opmitena bibɨrɨm Yonggyam e.” ");
INSERT INTO gdr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ɨ Yesu ɨtemb pɨpmet yɨraronj dɨde ket b'ɨgaronj onggɨt Parisai rɨga waina yɨr opmitenapu met wa. ");
INSERT INTO gdr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ɨ demb de kea yɨpa yɨm b'ɨkɨki kopa rɨga yɨbnonj. Sɨ Parisai rɨgap Yesund yɨgekito da, “Rɨka rɨrɨrkɨpjog e meraina wɨram dɨde yɨr opmitena bibɨrɨnd kopa rɨga ɨsakendam?” nokɨm da ɨdenat ton Yesum rɨl odarai Tin kot wa oramitam. ");
INSERT INTO gdr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Seg Yesu ket ten amninonj da, “Sɨ ra wa wɨngɨrɨnd yɨpa rɨgam yɨpa mamoi ɨbnau dɨde ra ɨtemb mamoi tunykis kip wa meraina wɨram dɨde yɨr opmitena bibɨrɨnd, sɨ rɨngma, ma ɨta onggɨt rɨgat ɨtemb mamoi oblas kip ke? ");
INSERT INTO gdr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sɨ rɨga re ma sobijog ukoijog gasa e ajɨ mamoi re ma ukoi gasa e. Ajɨ rada wɨn opima mamoi b'ogɨl amnɨkenenindam meraina wɨram dɨde yɨr opmitena bibɨrɨnd, sɨ onggɨt paemb rɨga b'ogɨl omnena mɨle re rɨrɨrkɨpjog e onggɨt bibɨrɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Seg re ket Yesu ɨtemb yɨm b'ɨkɨki rɨgand yomnonj da, “Moina yɨm b'ɨtnɨke!” Sɨ ɨtemb rɨga ket tina yɨm b'ɨtnɨkonj dɨde ket ɨtemb tina yɨm kupkakupka b'ɨsakendonj ɨja na ɨt re yɨpa tab yɨm re dɨde. ");
INSERT INTO gdr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ajɨ Parisai rɨgap ket opekto dɨde ket gɨlgɨl yɨtnono aento ɨsamkam da, “Rɨdede nya kae Yesund onganju.” ");
INSERT INTO gdr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ajɨ re Yesu towaina ɨsamka gatab wumɨr awonj, Ton ket kea onggɨt pɨpmet ke ewaikitonj. Sɨ jogjog rɨga bobop kea Tin yɨmta yundoko ɨ Ton ket komkesa kopa rɨga esakenjinonj towaina kopa ke. ");
INSERT INTO gdr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ɨ Yesu ten nonony amninonj, nokɨm da ɨdenat ton maka Tin pɨtapɨta omnenyi rɨga wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Sɨ nangga pena Yesu odede nonony amninonj re nok mana da ɨdenat bageyam Isayamna tugɨm ke opureni yɨtkak rɨrɨrkɨp omɨny, ɨt re da, ");
INSERT INTO gdr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yɨr de, ɨtemb Koina Wɨko Rɨga yena re Kon yobagendond, ɨ yena re Kon singi yiyenyɨn, ɨ ya pɨlwa e re Kon gar sam aenyɨn. Ɨ Kon ɨta Koina Wɨngawɨnga oramisɨn Ti pɨlɨnd, sɨ Ton ɨta Koina b'ɨsagɨka mɨle pɨtapɨta omneny komkesa Koina obagɨki kesa rɨga wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ɨ Ton ma ɨta yɨt b'ugwatena ikeny dem, ɨ dɨde ma ɨta unena ikeny dem, sɨ makwa ɨta yete Tina ukoi yɨt pɨam tutkundeny dem sobea nata. ");
INSERT INTO gdr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ɨ Ton ma ɨta negɨr omɨny yɨpa b'ɨkɨnti buskak, ɨ Ton ma ɨta osowɨk yɨpa ngɨndngɨnd wul dɨmɨl, ngɨrpu ra Ton towa pɨlɨnd b'ɨsagɨka mɨle omnɨk dɨde ket danda kɨma teyeniny yɨrkokar pɨpmet wa. ");
INSERT INTO gdr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ɨ komkesa God ma obagɨki kesa rɨgap warɨm b'ogɨl ɨsma oramitenyi ra Tina nyɨwɨm pɨlnate.” ");
INSERT INTO gdr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ɨ onggɨt wɨnɨnd rɨgap yɨpa negɨr wɨngawɨnga ke okati yɨrdɨdɨ dɨde yɨt kesa rɨga iyo Yesum pɨlwa, sɨ Yesu ket tin yɨsakendonj. Sɨ ket ɨtemb yɨt kesa rɨgat yɨt apureninonj dɨde yɨr b'ɨskenonj. ");
INSERT INTO gdr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Seg komkesa rɨga bobop kea kɨd kesa aento odede yɨt kɨma da, “Rɨngma, ma ɨtemb rɨga Yonggyam Dawidɨmna B'ɨga e?” ");
INSERT INTO gdr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ajɨ re Parisai rɨgap onggɨtyam yɨt utkundo, ton endento da, “Ɨtemb rɨga ma Godɨmna danda kaim negɨr wɨngawɨnga eaukeniny ajɨ negɨr wɨngawɨnga waina mopyam Beeljebulɨmna danda kaim.” ");
INSERT INTO gdr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sɨ re Yesu towaina nonyɨk b'amdena wumɨr awonj, Ton ket ten amninonj da, “Ra yɨpa kantrind rɨga towalenggyam b'itpouranj gangga b'akalendam, ɨtemb kantri ɨta negɨr tainy. Ɨ kwa ra yɨpa kantri wɨngɨrɨnd o yɨpa b'ubɨgawar wɨngɨrɨnd rɨga towalenggyam b'itpouranj, ɨtemb kantri o b'ubɨgawar towaina wɨmena re ɨta negɨr tawɨk. ");
INSERT INTO gdr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ɨ ra Satanamna kantrind, Satana Ti wɨrand negɨr wɨngawɨnga teaukeniny, ɨ towalenggyam b'itpouranj gangga b'akalendam, ɨtemb tina kantri ma rɨrɨr e tonyis, ajɨ ma pɨn e negɨr tainy. ");
INSERT INTO gdr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ɨ wɨn apurenindam da Kon Beeljebulɨmna danda kena negɨr wɨngawɨnga eaukeninyɨn. Sɨ daka wainajog rɨga wa wɨngɨrɨnd nɨnda rɨga, ton yaina danda kaim eaukenenanj? Godɨmna danda kaim. Sɨ onggɨt mop paimemb ton ket taukanj ra wanɨm b'ɨsagɨka rɨga im onggɨt waina negɨr opurena gatab. ");
INSERT INTO gdr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ajɨ ra Kon negɨr wɨngawɨnga teaukeninyɨn Godɨmna Wɨngawɨnga ke, sɨ God ma pumb tungg re kemb wa pɨlɨnd au. ");
INSERT INTO gdr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","O kwa rɨdede yɨpa rɨgat rɨrɨr e yɨpa danda rɨgamna met wa b'aturɨk dɨde tina gasa yurowam ke temjiny, ra maka ra ton naska ɨtemb danda rɨgand ɨjobɨk? Ajɨ naska ton b'ogla danda rɨgand ɨjobɨk ɨ yɨmta kae ton ket yurowam ke temjiny tina gasa komkesa leamog im re wekeny tina metɨnd. Sɨ Koda re odede wɨp nya kae negɨr wɨngawɨngamna mopyam danda kesa yomnɨkenenyɨn ɨ ɨngkaimemb Kon ket negɨr wɨngawɨnga eaukeneninyɨn rɨga wa pɨlke. ");
INSERT INTO gdr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ɨ yet ra maka Kon kɨma tainy, ton re Koina geja rɨga tab nate yɨbɨm. Ɨ kwa yet ra maka Kon kɨma yɨpand b'eomkena ikeny, ton re wetaweta omnɨka rɨga e. ");
INSERT INTO gdr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Sɨ onggɨt paemb Kon wen tamninyɨn da God ɨta komkesa negɨr mɨle dɨde Godɨnd ɨsadrena mɨle awɨr tamnɨkiny. Ajɨ God ma opima Yɨnayɨna Wɨngawɨngand ɨsadrena mɨle awɨr tamnɨkiny. ");
INSERT INTO gdr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ɨ kwa yet ra Rɨgamna B'ɨgand negɨr yɨt ke omɨny, God opima ti onggɨtyam negɨr mɨle awɨr omnainy dem. Ajɨ yet ra Yɨnayɨna Wɨngawɨngand ɨsadreny, God makwa ɨta ti onggɨtyam negɨr mɨle awɨr omnau dem yu wɨnɨnd dɨde kwa warɨ. ");
INSERT INTO gdr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ɨ wɨn wul nangg b'ogɨl yomnɨka, sɨ ɨngkaemb tina kɨp ɨta b'ogɨl tainy. O wɨn wul nangg negɨr yomnɨka, sɨ tina wulkɨp ɨta negɨr tainy. Mop nokɨp wul nangg ongwatam re tina ɨjagendi kɨp kae. ");
INSERT INTO gdr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Wɨn re negɨr guda kɨma gɨrem im, sɨ wɨn re negɨrjog nony menamena kɨma im wekenyɨt, ɨ kwa wɨn makwa rɨrɨr im opurenam b'ogɨl yɨtkak. Mop nokɨp nanggamog nony menamena im re rɨga waina garɨnd yɨndangɨr wekeny, ton ɨnsima tugɨm ke apurenanj. ");
INSERT INTO gdr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Sɨ b'ogɨl rɨgat b'ogɨljog gasa angapeneniny. Ɨ ɨngkaemb ton ket b'ogɨl mɨle pɨta wa apendeniny. Ɨ negɨr rɨgat daka tina ongapi negɨr gasam pɨlke negɨr mɨle pɨta wa apendeniny. ");
INSERT INTO gdr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ɨ Kon wen wumɨr tamninyɨn da ra b'ɨsagɨka bibɨr ik dem, yɨpayɨpa rɨgap opima b'agenaya tuweny dem Godɨm wɨpɨnd mɨra okatam towaina komkesa opureni yɨtkak gatab rɨnsim re yu ton kɨp kesa opurena eyenanj. ");
INSERT INTO gdr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mop nokɨp rada moina b'agenai yɨtkak re negɨr kesa dɨmdɨmjog e, sɨ God ɨta negɨr kesa dɨmdɨmjog rɨga nyɨ motkau dem, ɨ rada moina b'agenai yɨtkak re negɨrjog e, sɨ Ton ɨta negɨr ma b'ɨsagɨka motkau dem.” ");
INSERT INTO gdr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ɨ onggɨt wɨnɨnd Ju rɨga waina gog ouyaena rɨga dɨde Parisai rɨga wɨngɨrɨnd nɨnda rɨgap Yesund yomno da, “Ouyaena rɨga! Sɨn singi im mor pɨlke kɨd kesa kɨma danda wɨko yɨr ongong.” ");
INSERT INTO gdr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Sɨ Yesu ten esmonggainonj da, “Rɨga yepim re yu negɨrjog mɨle ɨ gigɨr dɨde yɨgyɨg b'iyena mɨle kɨma wekenyɨt onggɨt gowukoyɨnd! Wɨn nɨgekenya kɨd kesa kɨma danda wɨko omnɨkam, ajɨ Kon kɨd kesa kɨma danda wɨko wa takainyɨn ra ɨna nena e rɨna re bageyam Yonam pɨlɨnd aukonj. ");
INSERT INTO gdr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sɨ Yona ukoijog kabum kom borand yɨbnonj re nowa bibɨr dɨde nowa sɨwɨny kɨma na. Sɨ onggɨt paemb Rɨgamna B'ɨga todaka odede yɨpa wɨp e gou borand ɨbɨm dem nowa bibɨr dɨde nowa sɨwɨny kɨma. ");
INSERT INTO gdr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ɨ ra b'ɨsagɨka wɨn ik dem, Ninebe rɨgap opima yɨpand gɨlgɨl towɨnkanj dem wɨn kɨma yepim re yu wekenyɨt onggɨt gowukoyɨnd, ɨ ton opima yɨr ungata rɨga taukanj dem wanɨm negɨr ma b'ɨsagɨka okatam. Mop nokɨp re Yona God ma bage yɨt pɨtapɨta yomnenonj, Ninebe rɨgap kea towaina negɨr mɨle ke engento Godɨm pɨlwa, ajɨ ɨta yɨpa rɨga yɨbɨm dɨkɨnd, Ton re ukoijog e ajɨ Yona re sobijog e. Ajɨ wɨn makaima Tina opurena ke engenjindam waina negɨr mɨle ke. ");
INSERT INTO gdr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ɨ ra b'ɨsagɨka wɨn ik dem, bargubo gatab ke kwin ɨta yɨpand gɨlgɨl towɨnyis dem wɨn kɨma yepim re yu wekenyɨt onggɨt gowukoyɨnd, ɨ ton ɨta yɨr ungata rɨga tainy dem wanɨm negɨr ma b'ɨsagɨka okatam. Mop nokɨp naskand ton tikonj re ma wuswus kantri kena Solomonɨmna b'ogɨl multekɨp ke yɨtkak utkundam, ajɨ ɨta yɨpa rɨga yɨbɨm dɨkɨnd, Ton re ukoijog e ajɨ Solomon re sobijog e. Ajɨ wɨn makaima Tina yɨtkak singi eyenindam utkundam. ");
INSERT INTO gdr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ɨ ra negɨr wɨngawɨnga topenj yɨpa rɨgam pɨlke, ton ket b'ugumarena ikeny nyɨ kesa pɨpmet nata dɨde oraka iyeny wɨram wɨmenam pɨpmet, ajɨ makwa ɨta odar. ");
INSERT INTO gdr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Sɨ ton ket yindeny da, ‘Kon kwa ama tɨtenjɨn koina met wa rɨna re kon yɨraren.’ Ɨ ra ton tɨtenj, ton met odar ra met tɨb kesa e ɨ b'obogɨl ɨsagɨki e ɨ dɨde b'obogɨl gasa ongonjeni im. ");
INSERT INTO gdr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Sɨ ton ket yikeny dɨde arondeniny nɨnda seben (7) negɨr wɨngawɨnga yepim re ukoi kana negɨr mɨlend wekeny ti pɨlke, ɨ ket ton kɨma yɨpand b'ɨgarkanj ɨ dɨde dea de wɨmena wuweny. Sɨ onggɨt rɨgamna kikitumpu wa wɨmena re ma ɨja e ɨt re naskand re dɨde, ajɨ ɨtemb re ket negɨrjog e yɨbɨm. Sɨ odede yɨpa wɨp mɨle ɨta kwa tawɨk wa pɨlɨnd yepim re yu wɨn negɨrjog mɨle kɨma wekenyɨt onggɨt gowukoyɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ɨ re Yesu dɨdea rɨga bobo wa pɨlwa yɨt omnenand yɨbnonj, Ti mog dɨde Ti yɨngganwar met bau ke owɨnki wekenonj dɨde oraka yiyeno Tin yɨt omnenam. ");
INSERT INTO gdr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Sɨ yɨpa rɨgat Yesund wumɨr yomnonj da, “Yɨr de, Mor mog dɨde Mor yɨngganwar opima owɨnki wekeny bau wa ɨ oraka e miyenyi Men yɨt omnenam.” ");
INSERT INTO gdr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ajɨ Yesu tin yɨsmonggawonj yet re Tin wumɨr yomnonj da, “Yeto Kor mog, ɨ yepim Kor yɨngganwar?” ");
INSERT INTO gdr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Seg Ton ket Tina b'auyaena rɨga pumam etmulisinonj dɨde ket yindonj da, “Yɨr de, opimemb opi Kor mog dɨde Kor yɨngganwar. ");
INSERT INTO gdr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mop nokɨp yet ra mɨle omnɨka teyeniny Kor B'u ma singind yete re yɨbɨm pumb tungg wa, ton re Kor yɨnggan e, Kor ngɨmɨr o dɨde Kor mog o.” ");
INSERT INTO gdr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ɨ ɨtaemb onggɨt bibɨrɨnd Yesu onggɨt met ke opendonj dɨde ket omitonj sɨpa yurund. ");
INSERT INTO gdr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ɨ ket jogjog rɨga bobo auka wuwenonj Ti pɨlwa, ɨ onggɨt mop penaemb Ton ket yɨpa gɨga wa angitonj dɨde ket omitonj, ajɨ komkesa rɨga bobo re sɨpa gate nat owɨnki wekenonj. ");
INSERT INTO gdr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Sɨ Yesu towa jogjog yɨt usenenainonj re tendam yɨt kena, sɨ Ton yɨpa yusekonj da, “Yɨr, yɨpa wala rɨga tuny ɨgmarkam yikonj sopapu wa. ");
INSERT INTO gdr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ɨ re ton tuny egmarkinonj, nɨnda tuny ɨsokto nyawɨnd, ɨngkek ket ngena tuwonj, ɨ ket komkesa auto. ");
INSERT INTO gdr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ɨ kwa nɨnda tuny ɨsokto gɨmo gou nat rɨkɨnd re ma jog gou wekenonj. Ɨ odenja wanaka ɨkkɨto, mop nokɨp gou re bab tum nat wekenonj ɨ dɨde tunyɨp kea wanakana pemb yokato. ");
INSERT INTO gdr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ajɨ re ket lomkongga ɨlitonj, sɨ nangg kea yarɨmyarɨm aukɨto, mop nokɨp ap re ma rɨrɨr na gɨmo bora wa b'ɨgaram. ");
INSERT INTO gdr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ɨ kwa nɨnda tuny ɨsokto wanjametɨnd. Seg ket wanja wanakana owɨnkɨto, ɨ ket kea nangg ekangɨnto. ");
INSERT INTO gdr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ɨ kwa nɨnda tuny ɨsokto b'ogɨl sal gowɨnd. Seg ton ket ɨkkɨto, ɨ ket ton kɨp aukɨto, nɨnda re andred (100) kɨp, ɨ nɨnda re siksti (60) kɨp, ɨ kwa nɨnda tuny re teti (30) kɨp. ");
INSERT INTO gdr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yete re man wɨngawɨnga ke yɨpya kɨma, man utkunde!” ");
INSERT INTO gdr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ɨ b'auyaena rɨga tuwonj Yesum pɨlwa dɨde ket Tin yɨgekito da, “Nangga pae man tendam yɨt ke rɨga wa yɨt usenenainyɨt?” ");
INSERT INTO gdr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Sɨ Yesu ten esmonggainonj da, “God kea jɨ pumb tungg gatab wɨgawɨga yɨt wumɨr akainonj wanɨm nony aukam, ajɨ God towa maka wumɨr akainonj. ");
INSERT INTO gdr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mop nokɨp yet ra onggɨtyam Koina yɨtkak wumɨr okateny, God opima kwa ti b'usaya yɨtkak gatab wumɨr ogoniny, sɨ ti ukoijog wumɨr im ɨbnainy. Ajɨ yet ra maka okateny, God ɨta awɨr omnau nangga mog wumɨr e ton yowam. ");
INSERT INTO gdr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Sɨ onggɨt mop paemb Kon tendam yɨt ke ten amneninyɨn da, ‘Ton yɨr ke yɨr ongong reyeninem ajɨ goro ton wɨngawɨnga ke yɨr ranginem, ɨ kwa ton yɨpya ke rutkundeninem ajɨ goro ton wɨngawɨnga ke rutkundeninem dɨde goro wɨngawɨnga ke nony raukinem.’ ");
INSERT INTO gdr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sɨ yu ɨtemb bageyam Isayamna yɨtkak kea rɨrɨrkɨp auka yikeny gar ke utkunda kesa rɨga wa pɨlɨnd, ɨt re yɨtkak da, ‘Wɨn Godɨmna ara tutkundenindam, ajɨ goro wɨngawɨnga ke nony taukindam, ɨ kwa wɨn usausapyam yɨr ongong teyenindam, ajɨ goro gar ke takatenindam. ");
INSERT INTO gdr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mop nokɨp opimemb rɨga waina gar sɨbɨb ke ɨkangɨndi im wekeny, ɨ towaina yɨpya bora re ɨdokijog im wekeny, ɨ towaina yɨrkɨp re osmantijog im wekeny. Ra maka ra, ke ton wɨngawɨnga ke yɨr ongong reyeninem towaina yɨrkɨp ke, ɨ ke ton wɨngawɨnga ke rutkundeninem towaina yɨpya ke, ɨ ke ton wɨngawɨnga ke nony raukinem towaina garɨnd dɨde ket ke ton rengenjinem Kor pɨlwa ɨ dɨde ket ke Kon ten resakenjinɨn.’ ");
INSERT INTO gdr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ajɨ waina yɨrkɨp re b'ogɨl omni im, mop nokɨp opimemb yɨrkɨp opima wɨngawɨnga ke yɨr ongong eyenanj. Ɨ kwa waina yɨpya re b'ogɨl omni im, mop nokɨp opimemb yɨpya opima wɨngawɨnga ke yɨtkak utkundenanj. ");
INSERT INTO gdr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mop nokɨp Kon ɨmɨnjog wen wumɨr tamninyɨn da naskand jogjog bageyam dɨde negɨr kesa dɨmdɨmjog rɨgap singi na aukenento yɨr ongongɨm nangga im re wɨn yɨr ongong eyenindam, ajɨ ton maka yɨr ongong eyento. Ɨ kwa ton singi aukenento utkundam nangga im re wɨn utkundena eyenindam, ajɨ ton maka utkundenento. ");
INSERT INTO gdr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Sɨ onggɨt paemb wɨn ket utkundena nangga ma onggɨt tuny ɨgmarka rɨga gatab tendam yɨtɨt isɨpkis. ");
INSERT INTO gdr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Sɨ ɨntemb jɨ isɨpkita rɨna re tuny ɨgmarkɨto nyawɨnd. Sɨ yete re pumb tungg gatab yɨtkak utkundeny ajɨ maka ra ton nony tawɨk, sɨ negɨrjogyam Satana ik dɨde ɨsamburiny nanggamog yɨtkak na re tina garɨnd wekeny. ");
INSERT INTO gdr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ɨ opi re jɨ gɨmo gowɨnd ɨsokto re ɨntemb jɨ rɨga yisɨpkis yete re God ma bage yɨt utkundeny dɨde odenja ket ɨtemb yɨtkak sam kɨma yokateny. ");
INSERT INTO gdr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ajɨ ton makaya ngor wa ap b'amka yikeny onggɨt God ma yɨtkakɨm pɨlɨnd ajɨ ton sobijogjog gangga nate ɨtemb yɨtkak gar ke yokateny. Ajɨ daka ra God ma yɨtkak map negɨr ma b'atonkena mɨle ɨ bebɨg dɨde b'ɨsadrena mɨle pɨta taukanj, ton odenja e ket sap totenj dɨde ket ɨtemb God ma yɨtkak ɨrar. ");
INSERT INTO gdr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ɨ opi re jɨ wanjametɨnd ɨsokto re ɨntemb jɨ rɨga yisɨpkis yete re God ma bage yɨt utkundeny, ajɨ ti gowukoi yɨrkokar singind ukoijog nony menamena amnɨkeneniny, ɨ jogjog gasa singind b'anygɨnena sam yokateny, ɨ dɨde kwa nɨnda gowukoi gasa wa singi aukeneny tina garɨnd. Sɨ tonsimemb God ma yɨtkak yɨkangɨndenyi. Sɨ onggɨt paemb ket maka God ma yɨtkak kɨp ɨjagɨk ti pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ɨ opi re jɨ b'ogɨl sal gowɨnd ɨsokto re ɨntemb jɨ rɨga yisɨpkis yete re God ma bage yɨt utkundeny dɨde ket nony awɨk. Sɨ onggɨt paemb ket God ma yɨtkak kɨp ɨjagɨk ti pɨlɨnd, yɨpa re andred (100) kɨp, ɨ yɨpa re siksti (60) kɨp, ɨ dɨde yɨpa re teti (30) kɨp.” ");
INSERT INTO gdr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ɨ Yesu ket kwa yɨpa tendam yɨt towa usekawonj da, “Sɨ pumb tungg re yɨpa wɨp e odede rɨga kɨma yet re b'ogɨl tuny ɨtot eyeninonj tina sopapund. ");
INSERT INTO gdr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ɨ re komkesa rɨga yutungand wekenonj, yɨpa ti geja rɨga ikonj de sopapu wa dɨde ket ngɨi ɨtot eyeninonj onggɨt ɨti tuny ganggand, seg ton ket dea ta yikonj. ");
INSERT INTO gdr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ɨ onggɨt wɨnɨnd re ket tuny pok ɨkkɨto dɨde ket kɨp kɨma aukɨto, sɨ todaka kea ngɨi ɨkkɨto dɨde purag aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Sɨ onggɨt yonggyamɨmna wɨko rɨgap tuwonj ti pɨlwa dɨde ket yɨgekito da, ‘Yonggyam! Ma man pop b'ogɨl tuny nena na ɨtot eyeninot moina sopapu wa? Sɨ rɨngkaimta daka ngɨi wuweny?’ ");
INSERT INTO gdr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Sɨ ton esmonggainonj da, ‘Geja rɨgat odede mɨle yomnɨkonj.’ Ɨ tina wɨko rɨgap ket tin yɨgekito da, ‘Sɨ man singi et sɨn demb de wuyɨn sopapu wa dɨde ket opimemb ngɨi turomkindam?’ ");
INSERT INTO gdr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ɨ todaka esmonggainonj da, ‘Ka, goro. Mop nokɨp ra wɨn ngɨi turomkindam, ke wɨn yɨpand owou nangg ngɨi kɨma uromka eyenina dor. ");
INSERT INTO gdr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Sɨ nangga ma jɨ toko nɨmognɨmog gɨlgɨl rowɨnkine ngɨrpu ra erngoka wɨn okas. Ɨ ra erngoka wɨn ik, Kon toko erngoka rɨga wumɨr ramninɨn dem da, “Naska wɨn ngɨi na turomkindam dɨde supsup tamnɨkindam wul wa imbrɨkam. Ajɨ onggɨt kak kaemb wɨn ket owoukɨp bobo tamnɨkindam dɨde ket koina owou ongapapu met b'ɨga wa taramkindam”.’” ");
INSERT INTO gdr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ɨ Yesu ket kwa yɨpa tendam yɨt towa usekawonj da, “Sɨ pumb tungg re yɨpa wɨp e odede mastad tuny kɨma rɨna re yɨpa rɨgat yokatonj dɨde ket yɨtlitonj tina ɨngkind. ");
INSERT INTO gdr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Sɨ mastad tuny re tina sopapu wɨngɨrɨnd sobijogjog kɨp na yɨbnonj komkesa tuny wa pɨlke. Ajɨ re nangg ɨnɨka yikonj, ɨtemb mastad nangg ket ukoijog aukonj komkesa nangg wɨngɨrɨnd onggɨt sopapund. Sɨ ket wul pɨla onyitonj dɨde ket pumbɨnd ngena wuwenonj, ngɨrpu ton ket onggɨt wul bɨa kumb nata towaina met orangka eyento.” ");
INSERT INTO gdr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ɨ Ton ket kwa yɨpa tendam yɨt towa usekawonj da, “Sɨ pumb tungg re yɨpa wɨp e odede yist kɨma rɨna re yɨpa konggat yokatonj dɨde ket yɨpa ukoi baiko plawa kɨma yɨimɨkonj dampam, ngɨrpu kupkakupka dampa yɨnɨkonj dɨde yudburenonj.” ");
INSERT INTO gdr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sɨ Yesu opimemb komkesa yɨtkak usenena eyenawainonj rɨga bobo wa re tendam yɨt kena, ajɨ makwa ke Ton towa usenenainonj tendam kesa. ");
INSERT INTO gdr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Sɨ nangga pena Yesu odede tendam yɨt nena ke amneninonj re nok mana da ɨdenat yɨpa bageyamɨmna opureni yɨtkak rɨrɨrkɨp tainy, ɨt re da, “Kon ɨta Koina tugɨm ɨpangenjɨn tendam yɨt opurenam, ɨ Kon opima gasa pɨta wa tapekinyɨn rɨnsim re onggɨt gowukoi otomapu ke wumɨr kesa egurki wekeneny.” ");
INSERT INTO gdr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ɨ re Yesu yɨt usenena seg awonj, Ton ket rɨga bobo erarinonj dɨde ket yikonj met wa. Ɨ Tina b'auyaena rɨga tuwonj Ti pɨlwa dɨde ket yomno da, “Be man sowa yisɨpkene sopapund ngɨi gatab tendam yɨt!” ");
INSERT INTO gdr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Sɨ Yesu esmonggainonj da, “Rɨga yet re b'ogɨl tuny egmarkinonj re Rɨgamna B'ɨgat. ");
INSERT INTO gdr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ɨ sopapu re gowukoi e, ɨ opimemb b'ogɨl tuny re pumb tunggɨmna b'ɨgawar im. Ajɨ ngɨi re negɨrjog rɨga Satanamna b'ɨgawar im. ");
INSERT INTO gdr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ɨ ɨtemb geja rɨga yet re ngɨi ɨtot eyeninonj re Negɨr Wɨngawɨnga Satanate. Ɨ kwa erngoka wɨn re gowukoi kikitum b'ɨsagɨka wɨn e, dɨde erngoka rɨga re God ma aneru im. ");
INSERT INTO gdr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sɨ opi re erngoka wɨnɨnd wɨko rɨgap ngɨi uromka eyento dɨde ket wul wa embrɨkto. Sɨ ɨja imemb jɨ mɨle taukanj dem gowukoi kikitum b'ɨsagɨka wɨnɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Sɨ onggɨt wɨnɨnd Rɨgamna B'ɨgat opima Tina aneru tetmɨkeniny dem Tina pumb tungg wa rɨnte re Ton wɨp yomneny onggɨt gowukoyɨnd, ɨ ket onggɨt anerup onggɨt Tina pumb tungg ke odede rɨga im ɨtkoka teyenanj dem yepim re rɨga negɨr mɨle omnɨkam amnenanj dɨde negɨrjog mɨle omnɨka eyenanj. ");
INSERT INTO gdr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Seg anerup ket ten teskokanj dem de ukoi wul dɨmɨl kɨma kap wa. Sɨ opimemb rɨga re amimemb de yii kamil b'iyowa tuweny dem, dɨde kopa b'angnena kɨma or b'ɨinɨka tuweny dem. ");
INSERT INTO gdr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ajɨ onggɨt wɨnɨnd daka negɨr kesa dɨmdɨmjog rɨga wui dem de towa B'u God ma pumb tungg wa, dɨde ket b'atnyoratenanj dem lomkongga re dɨde. Sɨ yete re man wɨngawɨnga ke yɨpya kɨma, man utkunde! ");
INSERT INTO gdr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ɨ pumb tungg re yɨpa wɨp e odede b'ogɨljog ongapi gasa kɨma rɨna re yɨpa sopapund gou bora wa eungiti yɨbnonj. Sɨ re yɨpa rɨgat ɨtemb b'ogɨljog gasa yodaronj, sɨ ton kea kwa yeungitonj gou bora wa dɨde ket sam kɨma yikonj tina met wa. Seg ton ket tina komkesa gasa asogɨkinonj dɨde ket onggɨt osogi wulkɨp ke ɨtemb gou kɨpol yokatonj. ");
INSERT INTO gdr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ɨ kwa pumb tungg re yɨpa wɨp e odede gasa osoga rɨga kɨma yet re b'ogɨl ngɨndngɨnd timtim jag oraka eyeninonj imdam. ");
INSERT INTO gdr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Sɨ re ton yɨpa ukoijog mɨra kɨma b'ogɨljog ngɨndngɨnd timtim jag yodaronj, ton ket yikonj tina met wa dɨde ket tina komkesa gasa asogɨkinonj. Seg ton ket onggɨt osogi wulkɨp ke ɨtemb b'ogɨljog ngɨndngɨnd timtim jag yokatonj. ");
INSERT INTO gdr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ɨ kwa b'usaya pumb tungg re yɨpa wɨp e odede gɨr kɨma rɨna re rɨgap sɨpa wa b'ɨsko dɨde ket komkesa b'engabenga wɨp kabum emjinonj. ");
INSERT INTO gdr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Sɨ re ɨtemb gɨr yɨndangɨr awonj, kabum wɨko rɨgap ket ɨtemb gɨr yɨrgɨnato sɨpa gate wa dɨde ket omnɨkto. Seg re ton ɨsagɨka eyento, ton kea b'ogɨlyam kabum yɨpa ga wa egarkɨto ajɨ negɨryam kabum dea ta eskokto. ");
INSERT INTO gdr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ɨ ɨja imemb jɨ mɨle taukanj dem gowukoi kikitum b'ɨsagɨka wɨnɨnd. Sɨ Godɨmna aneru opima tui dem onggɨt gowukoi wa dɨde ket negɨr kesa dɨmdɨmjog rɨga wa wɨngɨr ke negɨrjog rɨga wetaweta tamnɨkanj dem. ");
INSERT INTO gdr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Seg anerup ket ten teskokanj dem de ukoi wul dɨmɨl kɨma kap wa. Sɨ opimemb rɨga amimemb de yii kamil b'iyowa tuweny dem, dɨde kopa b'angnena kɨma or b'ɨinɨka tuweny dem.” ");
INSERT INTO gdr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Sɨ Yesu Tina b'auyaena rɨga egekisinonj da, ‘Sɨ ke wɨn nony aukindam onggɨtyam komkesa yɨtkak gatab?’” Ɨ ton ket yɨsmonggawo da “Owɨ.” ");
INSERT INTO gdr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ɨ Ton ket ten amninonj da, “Sɨ onggɨt paemb komkesa God ma gog ouyaena rɨga yepiya re Kor pɨlke b'auyaena wuwenonj pumb tunggɨm wɨko omnɨkam, ton re odede met yonggyam pɨla rɨga im yet ra tina b'ogɨljog gasa ongapapu kok ke sisɨl gasa dɨde kesam gasa tapekiny rɨga wa ogonam. Sɨ ton opima Godɨmna yɨna peba ke sisɨl ɨmɨnjog yɨtkak dɨde kesam ɨmɨnjog yɨtkak apekanj rɨga wa ogonam.” ");
INSERT INTO gdr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ɨ re Yesu onggɨtyam komkesa tendam yɨt usenena seg awonj, Ton ket onggɨt pɨpmet ke ewaikitonj. ");
INSERT INTO gdr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ɨ Ton ket yikonj Tinajog tungg wa, dɨde ket rɨga ouyaena eyeninonj towaina yɨr opmitenapu metɨnd. Ɨ onggɨt wɨnɨnd opimemb rɨga kɨd kesa na aena wuwenonj dɨde ket endento da, “Rɨngkaim onggɨt rɨgat odede b'ogɨl multekɨp dɨde odede kɨd kesa kɨma danda emjinonj? ");
INSERT INTO gdr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ma ɨtemb rɨga met oranga rɨgamna b'ɨga e? Ma ma Mariyato Ti mog? Ɨ ma ma Ti yɨngganwar im Yakobo, Yosep, Simon, dɨde Yudas? ");
INSERT INTO gdr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ma ma komkesa Tina ngɨmɨrwar ɨndamima men kɨma wekeny? Sɨ onggɨt paemb rɨngkaim onggɨt rɨgat onggɨtyam komkesa gasa emjinonj?” ");
INSERT INTO gdr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sɨ ɨngkenaemb ket rɨgap Yesund ɨsnawa kesa yomneno. Sɨ ket Yesu ten amninonj da, “Rɨgap Godɨmna bageyam ɨta yɨsnaenenyi komkesa gatab nata, ajɨ tinajog tungg rɨgap dɨde tinajog metam rɨgap ma ɨta tin yɨsnaenenyi”. ");
INSERT INTO gdr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Sɨ Ton demb de maka jogjog kɨd kesa kɨma danda wɨko amnɨkinonj, nokɨp rɨgap maka Tin gar ke utkunda ke yokato. ");
INSERT INTO gdr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ɨ onggɨt wɨnɨnd king Erod kea Yesum gatab yɨdɨr utkundonj. ");
INSERT INTO gdr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Sɨ ton tina wɨko rɨga amninonj da, “Ɨtemb Rɨga re Baptiso Yoante. Sɨ ɨtemb rɨga Yoan kea uj ke utnyitonj. Sɨ onggɨt mop paemb Yoanɨmna kɨd kesa kɨma dandate wɨko omnɨka yiyeny ɨtemb rɨga Yesum pɨlɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Sɨ ɨtemb jɨ yɨt rɨja na re naskand Baptiso Yoan uj awonj. Sɨ re king Erod ti yɨnggan Pilipɨmna kongga Erodiyand wokatonj ti konggam, sɨ Yoan king Erodɨnd yomnenonj da, “Ɨtemb re ma b'ogɨl mɨle emb jɨ, man ɨtomb kongga mor konggam womnyɨt.” Sɨ onggɨt penaemb ket king Erod Yoanɨnd yɨmɨnd yusunatonj dɨde yɨjobɨkonj ɨ ket sɨbɨbmet wa yoramitonj ti kongga Erodiyand nony b'ogɨl omnam. ");
INSERT INTO gdr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ɨ king Erod singi na Yoanɨnd ongandam, ajɨ ton rɨga bobo na moga uwajinonj. Mop nokɨp rɨgap Yoanɨnd yɨpa bageyam kena yogenaeneno. ");
INSERT INTO gdr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ɨ re king Erodɨmna ukendipu bibɨr awonj, Erodiyamna ngɨmngai b'ɨga ger omarkonj ɨngauki rɨga wa wɨpɨnd. Sɨ tina omarkat Erodɨnd ma sobijog na samɨm yomnonj. ");
INSERT INTO gdr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ngɨrpu ket king Erod ɨtomb ngɨmngayɨm danda kɨma tɨrɨr yɨt wopulitawonj da, “Kon ɨta motkaen nangga mana ra man nɨtgekisɨt.” ");
INSERT INTO gdr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ɨ ɨtomb ngɨmngai ti mogɨmna yɨt ɨtai rɨrɨr nat Erodɨnd yɨgekitonj da, “Be man kor otade nokae Baptiso Yoanɨmna moptekɨp yɨpa pleto kumbɨnd!” ");
INSERT INTO gdr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Seg king Erod ma sobijog na gar bebɨg awonj. Ajɨ ton ma rɨrɨr na awonj ngɨmngai ma b'arkita b'ɨsayam, nokɨp ton naskand ke danda kɨma tɨrɨr yɨt wokawonj dɨde kwa tina ɨngauki rɨga yɨr map yepiya re diyamdiyampund wekenonj. Sɨ ton kea b'ingawa yoramitonj Yoanɨmna moptekɨp ngɨmngayɨm okawam. ");
INSERT INTO gdr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ɨ ton ket tina yɨr ɨpka geja rɨga yɨtmɨkitonj dɨde ɨtemb geja rɨgat Yoanɨnd mop yependonj sɨbɨbmetɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Seg ket ton Yoanɨmna moptekɨp iyonj pleto kumbɨnd dɨde ket ɨtomb ngɨmngai b'ɨgam wokawonj. Ɨ ngɨmngayɨt daka ket yiyonj ti mogɨm pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Sɨ Yoanɨmna b'auyaena rɨgap ket Yoanɨmna ujgɨm yopo dɨde ket yurowato, ngɨrpu ket gop wa yeungito. Seg ket ton wuwonj Yesum pɨlwa dɨde ket Tin wumɨr yomno Yoanɨmna uj gatab. ");
INSERT INTO gdr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ɨ re Yesu Yoanɨm gatab yɨt utkundonj, sɨ Ton gɨga nya Tinta yikonj dea ta yɨpa wul kesa tungg gatab wa. Ɨ daka re rɨga bobop utkundeno Tina menon gatab, ton kea towaina taun erarento dɨde ket gɨl nya Tin yɨmta undoka yiyo ");
INSERT INTO gdr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ɨ re Yesu gɨga ke opendonj, Ton kea ukoi rɨga bobo yɨr anginonj. Ɨ Ton ten gar ke kear amninonj. Sɨ Ton kea ket kopa rɨga esakenjinonj. ");
INSERT INTO gdr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ɨ re ket sɨ imoka ikonj, b'auyaena rɨga Yesum pɨlwa tuwonj dɨde ket Tin yomno da, “Ɨtemb tungg re wul kesa tungg e, dɨde bibɨr wɨn re kea awɨr ainy. Sɨ man rɨga bobo etmɨkenine, nokɨm da ɨdenat ton tuweny nɨnda tungg nata dɨde ket towanɨm owou imda teyenanj.” ");
INSERT INTO gdr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ajɨ Yesu ten esmonggainonj da, “Ton ma ɨta menon okasi. Sɨ wɨnpiya towa owou agoninam.” ");
INSERT INTO gdr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ajɨ ton mɨra yomno da, “Sowa ɨnsima dɨkɨnd paib (5) sana nganja dɨde nɨmog kabum nena wekeny.” ");
INSERT INTO gdr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Seg Yesu ten amninonj da, “Opimemb owou teyinam Kor pɨlwa!” ");
INSERT INTO gdr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ɨ Yesu rɨga bobo engainonj tɨb kumbɨnd omitam diyam awowɨm. Seg ket Yesu opimemb paib (5) sana nganja dɨde nɨmog kabum akasinonj, ɨ ket wub pumb wa yɨr yikenonj dɨde ket Godɨnd sɨteket yɨt yomnonj. Ngɨrpu Ton ket sana nganja epkɨkinonj ɨ ket Tina b'auyaena rɨga wa pɨlwa agoninonj. Seg ket b'auyaena rɨgap rɨga bobo wa ogona eyento. ");
INSERT INTO gdr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ɨ ton komkesa rɨga diyam auto dɨde kea ngor aukɨto. Seg ket b'auyaena rɨgap rɨga wa pɨlke owou komb akatto dɨde aramkɨto watɨnd, ngɨrpu twelp (12) wat yɨndangɨr aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Komkesa yepiya re rɨgajog diyam aukɨto re ama rɨka paib tausɨn (5,000) na. Ajɨ kongga dɨde b'ɨga maka agenkɨto. ");
INSERT INTO gdr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Seg ket odenja Yesu Tina b'auyaena rɨga engainonj gɨga wa angurkam dɨde naskanaska menonɨm sɨpa yɨpa tab wa. Ɨ onggɨt ganggand re Tina b'auyaena rɨgap gɨga wa angurkɨto menonɨm tab wa, Yesu ket Tilenggyam rɨga bobo wetaweta amnɨkinonj. ");
INSERT INTO gdr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ɨ re Yesu rɨga bobo wetaweta omnɨka seg amninonj, Ton yiwatonj yɨpa sukak wa Tinta yɨr opmitam. Sɨ re sɨ yimokonj, Yesu adea de Tinta yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ajɨ gɨga re kea gɨl ke ma wus na yɨbnonj ɨ sɨpa wurop gɨga ma sobijog na oskandena yiyo dɨde rɨb daka gɨga wɨpwɨp na yikenonj. ");
INSERT INTO gdr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ɨ ket ɨspara momtand, sɨwɨny tri (3) ɨ siks (6) kɨlok ganggand, Yesu pɨs nya towa pɨlwa yikonj sɨpa nyɨ tumɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ajɨ re ton b'auyaena rɨgap Tin yɨr yongo Tina menonɨnd sɨpa nyɨ tumɨnd, ton ukoijog moga na aukɨto dɨde endento da, “Ɨtemb re kobɨr e.” Sɨ ton kea moga map b'okta irere aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ajɨ odenja Yesu ten amninonj da, “Kɨd seoseo ainam! Konten, goro moga tainam!” ");
INSERT INTO gdr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Sɨ Petro Yesund yomnonj da, “Yonggyam! Rada Mantet, ken ningae menonɨm Mor pɨlwa nyɨ tumɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ɨ Yesu yomnonj da “Metkɨm!” Ɨ ket Petro gɨga ke opendonj sɨpa nyɨ wa dɨde pɨs nya nyɨ tumɨnd yikonj Yesum pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ajɨ re Petro ukoi danda kɨma rɨb yɨr iyonj, ton kea moga awonj dɨde ket nyɨ bora wa sisɨl ɨtwa yikonj. Sɨ ton ket b'okta ara yikenonj da, “Yonggyam! Yɨm nokae, nopende!” ");
INSERT INTO gdr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sɨ odenja ket Yesu yɨm b'ɨtnɨkonj dɨde ket tin yemoratonj. Seg ket tin yomnonj da, “Utkunda kesa rɨga! Nangga pae man maka gar ke utkunda ke nokasɨt da Kon rɨrɨr en men ingawam nyɨ tumɨnd menonɨm.” ");
INSERT INTO gdr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ɨ re ton gɨga wa angitonda, sɨ rɨb daka kea ket mumakesa awonj. ");
INSERT INTO gdr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Seg yepiya re wekenonj onggɨt gɨga kumbɨnd, ton ket Yesund kumsos yemko odede yɨt kɨma da, “Ɨmɨnjog e, Man re Godɨmna B'ɨga et.” ");
INSERT INTO gdr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ɨ re ton ɨjendo sɨpa tab wa, ton ket gɨl ɨpkɨto de Genesaret gou wa. ");
INSERT INTO gdr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ɨ re ket onggɨt tunggam rɨgap Yesund yongwato, ton kea ket yɨt etmɨkento komkesa tungg nata onggɨt eriya wɨngɨrɨnd. Seg ket rɨgap komkesa negɨr kopa kɨma rɨga eyento Yesum pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ɨ ton ket Yesund erkena yiyeno, nokɨm da ɨdenat kopa rɨgap Tina kobɨrgɨm petɨr esopaya iyenyi. Ɨ komkesa rɨga yepiya re yesopayo, ton kea ket b'ogɨl aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ɨ onggɨt wɨnɨnd Parisai rɨga dɨde Ju rɨga waina gog ouyaena rɨga Yesum pɨlwa tuwonj Yerusalem taun ke dɨde ket yɨgekito da, ");
INSERT INTO gdr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nangga paim Moina b'auyaena rɨgap elda rɨga waina dad ke b'ɨsateni mɨle erbeka eyenanj? Mop nokɨp opi re ton owou awenenanj, ton ma opima naska yɨm b'ɨsekenenanj.” ");
INSERT INTO gdr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sɨ Yesu ket ten mɨra amninonj da, “Sɨ wɨdaka nangga pae God ma b'ingawa yɨt yerbekenenya waina dad ke b'ɨsateni mɨle yɨmta undoka map? ");
INSERT INTO gdr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mop nokɨp God yindonj da, ‘Mor b'u ake mor mog esnae,’ ɨ kwa yindonj da, ‘Yet ra b'uɨm pɨlwa o mogɨm pɨlwa negɨr yɨt opulis, ton ɨta ɨmɨnjog uj ondrɨki ɨbɨm.’ ");
INSERT INTO gdr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ajɨ wɨn dad ke b'ɨsateni yɨt ke endenindam da, ‘Yɨpa rɨgat b'ogla ti b'uɨm pɨlwa o ti mogɨm pɨlwa indeny da, “Kon pop men gasa wulpok momnɨkenenyɨn, ajɨ kon ma ɨta motkaen ajɨ God ma okaen.” ’ ");
INSERT INTO gdr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ɨ ra ton odede mɨle omnɨk, ton rɨrɨr e ti b'und ɨsnawa kesa omnɨkeneny ɨ ti mogɨnd ɨsnawa kesa tomnɨkeneny. Sɨ wɨn odede waina dad ke b'ɨsateni mɨle kae God ma yɨtkak awɨr yomnɨkenenya. ");
INSERT INTO gdr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wɨn, gɨm ke b'ogɨl ajɨ ngor wa negɨr mɨle rɨga, bageyam Isaya ɨmɨnjog b'ogɨl bage yɨt na yopulitonj wa gatab da, ");
INSERT INTO gdr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Onggɨt rɨgap Ken nɨsnaenenyi towaina tugɨm nena kae, ajɨ towaina nony menamena re ma wus nasim Kor pɨlke wekeny. ");
INSERT INTO gdr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ɨ ra ton God ma yɨt tauyaenenanj, ton rɨga waina omnɨki gog kaim rɨga auyaenenanj. Sɨ onggɨt paemb ton jabakɨpɨnd nony kesa kana im dɨde mogjɨ kesa im Kor pɨlwa yɨr opmitenenanj.’” ");
INSERT INTO gdr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ɨ seg ket Yesu rɨga bobo ara yemokonj dɨde ten amninonj da, “Wɨn nutkunda! Ɨ wumɨr yokata! ");
INSERT INTO gdr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Makwa ɨta yɨpa gasat rɨgand kɨl kɨma omɨny rɨnte re bau ke yik rɨgam tu bora wa, ajɨ onggɨt gasate rɨnte re rɨgam tu bora ke opek, sɨ tontemb jɨ onggɨt rɨgand kɨl kɨma yomnɨk.” ");
INSERT INTO gdr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ɨ odedend ket daka b'auyaena rɨga Yesum pɨlwa tuwonj dɨde ket Tin yomno da, “Ke Man wumɨr aet da re Parisai rɨgap onggɨtyam Moina yɨt utkundenyi, ton kea komliu aukanj Mor gatab.” ");
INSERT INTO gdr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ajɨ Yesu ten esmonggainonj da, “Kor B'u yete re pumb tungg wa yɨbɨm, Ton opima ap kɨma turomkiny dem komkesa wul nangg rɨna re Ton maka esinonj. ");
INSERT INTO gdr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yebɨkau, waken! Opimemb rɨga re yɨrdɨdɨ rɨga im ajɨ ton kwa yɨrdɨdɨ rɨga im wang eyenanj. Sɨ ra yɨrdɨdɨ rɨgat yɨrdɨdɨ rɨgand wang yii, ton osiya nɨmognɨmog kip wa tɨglansya.” ");
INSERT INTO gdr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ɨ ket Petro Yesund yɨgekitonj da, “Be man sowa yisɨpkene onggɨtyam tendam yɨt.” ");
INSERT INTO gdr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ajɨ Yesu todaka egekisinonj da, “Ma wɨdaka makaima ngai wumɨr aukindam? ");
INSERT INTO gdr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ma wɨn ma wumɨr im da komkesa gasa rɨnsim re bau ke wui de tu bora wa, ton opima wui de kom bora wa, ɨ daka ket ton bau wa topekanj de sobijog met wa b'ɨskokam. ");
INSERT INTO gdr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ajɨ gasa rɨnsim re opekanj tugɨm ke, ton re kɨd kaim wuweny, tonpimemb jɨ onggɨt rɨgand kɨl kɨma yomnɨki. ");
INSERT INTO gdr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mop nokɨp kɨd ke re odede mɨle im wuweny, opi re negɨrjog nonyɨk b'amdena mɨle, onganda mɨle, gigɨr dɨde yɨgyɨg b'iyena mɨle, negɨr b'iyena mɨle, yurowam mɨle, rɨga gatab yɨr ungati kesa b'anygɨnena yɨt useka mɨle ɨ dɨde ɨsadrena mɨle. ");
INSERT INTO gdr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Sɨ odede mɨlepimemb rɨga kɨl kɨma amnɨkenenanj, ajɨ b'ɨseka mɨle omni kesa yɨm ke owowɨm re ma opima rɨga kɨl kɨma tamnɨkiny.” ");
INSERT INTO gdr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ɨ re Yesu ɨtemb pɨpmet yɨraronj, Ton ket yiwatonj Tiro ake Sidon eriya wa. ");
INSERT INTO gdr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Seg yɨpa Kanaan tunggam kongga tikonj onggɨt eriya ke dɨde ket b'okta obailitonj da, “Yonggyam, Dawidɨm B'ɨga! Kear nomne-o! Koina ngɨmngai b'ɨga negɨr wɨngawɨnga ke okati o wɨbɨm dɨde negɨrjog wɨn nato wɨbɨm.” ");
INSERT INTO gdr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ajɨ Yesu makwa yɨt wɨsmonggawonj. Sɨ Tina b'auyaena rɨga tuwonj dɨde ket iror ɨpka yiyo da, “Man wanaka tina singi wundwatae, dɨde ket tɨtmɨkisɨt, nokɨp ton ɨta obairena tik mera yɨmtayɨmta.” ");
INSERT INTO gdr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Seg Yesu esmonggainonj da, “God nɨtmɨkitonj re Israel rɨga wɨngɨrɨnd b'edamkuri mamoi wa pɨlwa nena mana.” ");
INSERT INTO gdr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ajɨ ɨtomb kongga tikonj Yesum pɨlwa dɨde ket kumsos b'amkonj Ti pɨlwa odede yɨt kɨma da, “Yonggyam! Yɨm nokae!” ");
INSERT INTO gdr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ajɨ Yesu wɨsmonggawonj da, “Ɨtemb re ma b'ogɨl mɨle e b'ɨga waina sana ɨsatam dɨde yongg wa b'ɨskokam.” ");
INSERT INTO gdr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ajɨ daka konggat Yesund yomnonj da, “Ɨmɨnjog e, Yonggyam! Ajɨ yonggɨp sobijogsobijog sana kɨb awenenanj rɨnsim re yongg b'uwamɨp towa yongg wa eskokaenenanj owoupu kasa kumb ke.” ");
INSERT INTO gdr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Seg Yesu ket ɨtomb konggand womnonj da, “Kongga! Moina gar ke utkunda re ma sobijog danda e. Sɨ moina singi rɨrɨrɨnd rawɨk!” Ngɨrpu ket ɨtomb konggamna ngɨmngai b'ɨga onggɨt wɨnjogɨnd b'ɨsakendonj. ");
INSERT INTO gdr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ɨ Yesu onggɨt pɨpmet ke ewaikitonj dɨde ket yikonj Galili sɨpa yuru nata. Ɨ ɨngkenaemb Ton ket sukak wa yikonj dɨde ket ademb de omitonj. ");
INSERT INTO gdr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ɨ jogjog rɨga bobop ton kɨma eyento gomgom rɨga, yɨrdɨdɨ rɨga, pɨs b'ɨkɨki rɨga, yɨpya dumdum rɨga, ɨ dɨde kwa jogjog kopa rɨga, dɨde ket Yesum pɨlwa tuwonj. Ɨ re ket ton opimemb kopa rɨga oramka eyento Yesum wus wa, sɨ Ton kea ket ten esakenjinonj. ");
INSERT INTO gdr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ɨ yɨt kesa rɨgap yɨt apurento, ɨ pɨs b'ɨkɨki rɨgap b'obogɨl pɨs b'amdena wuwenonj, ɨ gomgom rɨgap menon yokateno, ɨ dɨde yɨrdɨdɨ rɨgap yɨr b'ɨskena wuwenonj. Sɨ komkesa rɨga yepiya re wekenonj dɨkɨnd, ton kea yɨr angto opimemb komkesa mɨle. Seg ton ket ma sobijog na kɨd kesa aento dɨde ket Israel rɨga waina God esourena yiyeno. ");
INSERT INTO gdr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ɨ Yesu Tina b'auyaena rɨga ara emokinonj dɨde ket ten amninonj da, “Kon rɨga bobo im kear amninyɨn, nokɨp ke nowa bibɨr im Kon kɨma wekeny, sɨ kea towa awɨr im kwa nangga im owowɨm ebnainy. Kon ma singi en ten owoupa ɨtmɨkitam. Nokɨp rada Kon ten tetmɨkeninyɨn owoupa kɨma, nyawɨnd ke owoupat kak ɨjga reyin.” ");
INSERT INTO gdr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Seg Tina b'auyaena rɨgap Tin yomno da, “Sɨ rɨngkaim men odede pɨs owou tadarkindam onggɨt wul kesa tunggɨnd odede rɨga bobo ngor omnɨkam?” ");
INSERT INTO gdr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ɨ Yesu ket ten arkisinonj da, “Leamog sana nganja im wɨn awamindam?” Ɨ ton mɨra yomno da, “Seben (7) nganja im dɨde nɨnda sobijog kabum.” ");
INSERT INTO gdr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ɨ ket Yesu rɨga bobo engainonj omitam gowɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Seg ket Ton opimemb seben (7) sana nganja dɨde nɨnda kabum akasinonj dɨde Godɨnd sɨteket yɨt yomnonj, ngɨrpu epkɨkinonj dɨde Tina b'auyaena rɨga wa agoninonj rɨga wa yingg iyenam. Ɨ ket b'auyaena rɨgap onggɨt rɨga bobo wa yingg eyenauto. ");
INSERT INTO gdr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Sɨ komkesa rɨgap auto dɨde ton kea ket ngor aukɨto. Seg re b'auyaena rɨgap rɨga wa pɨlke sana komb dɨde kabum komb akatto, seben (7) ukoi ga na komb owou ke yɨndangɨr amnɨto. ");
INSERT INTO gdr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ɨ komkesa rɨgajog yepiya re diyam auto re powa tausɨn (4,000) na. Ajɨ kongga dɨde b'ɨga maka agenkɨto. ");
INSERT INTO gdr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ɨ re Yesu rɨga bobo wetaweta amnɨkinonj, Ton ket gɨga wa angitonj dɨde ket yikonj de Magadan eriya wa. ");
INSERT INTO gdr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ɨ Parisai rɨga dɨde Sadukai rɨga tuwonj Yesum pɨlwa dɨde ket singi aukɨto Tin otonkenam. Sɨ ton ket Tin yɨgekeno towa ouyawam kɨd kesa kɨma danda wɨko rɨnte ra God ɨmjas da Ton re Godɨm pɨlkae. ");
INSERT INTO gdr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ajɨ Yesu ten mɨra amninonj da, “Ɨ ra sɨmana lom ipanjɨka yik, wɨn tendenindam da, ‘Mep wub b'ogɨljog e ɨbɨm, nokɨp wub kus re mog e.’ ");
INSERT INTO gdr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ɨ daka sɨtawarɨnd wɨn tendenindam da, ‘Yu ɨta piro ik, nokɨp wub re kea kuskus dɨde timtim e awɨk.’ Sɨ ra wɨn wubɨnd gasa yɨr ongong teyenindam, wɨn ɨta naska kana wumɨr okatenya da wub rɨdede wɨp e ɨbɨm. Ajɨ nangga paim wɨn maka naska kana wumɨr yokatenya wɨn ongwatenam mɨle gatab da rɨdede wɨp wɨn e ik? ");
INSERT INTO gdr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Sɨ rɨga yepim re yu negɨrjog mɨle ɨ gigɨr dɨde yɨgyɨg b'iyena mɨle kɨma wekenyɨt onggɨt gowukoyɨnd, wɨn nɨgekenya kɨd kesa kɨma danda wɨko omnɨkam, ajɨ Kon kɨd kesa kɨma danda wɨko wa takainyɨn ra ɨna nena e rɨna re bageyam Yonam pɨlɨnd aukonj.” Ɨ ket yɨt seg ke Yesu opimemb rɨga erarinonj dɨde ket yiwatonj. ");
INSERT INTO gdr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ɨ re Yesu Tina b'auyaena rɨga kɨma sɨpa ɨjendo de yɨpa tab wa, b'auyaena rɨgap nony b'edatto nɨnda owou iyoyɨm. ");
INSERT INTO gdr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ɨ Yesu ten nonony amninonj da, “Wɨn nony kɨma tekenyɨt! Dɨde wɨn yɨr kɨma tekenyɨt Parisai rɨga ake Sadukai rɨga waina yistɨm!” ");
INSERT INTO gdr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ajɨ b'auyaena rɨgap maka wumɨr aukɨto Yesu ma yɨt mop. Sɨ ton towalenggyam b'arkena wuwenonj da, “Ton nok pae odede yinj nokɨp men maka owou teyindam.” ");
INSERT INTO gdr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Sɨ Yesu kea towaina b'arkena gatab wumɨr awonj, ɨ ket ten amninonj da, “Utkunda kesa rɨga! Nangga mim wɨn b'arkena wuwenyɨt wa wɨngɨrɨnd da wa owou awɨr im? ");
INSERT INTO gdr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Makaima wɨn wumɨr aindam nangga ma Kon nindenyɨn? Ma wɨn ma opima nonyɨnd eyenindam da re Kon paib (5) sana nganja ke paib tausɨn (5,000) rɨga angeninond, sɨ wɨn owou komb ke leamog wat na yɨndangɨr amnɨktondam? ");
INSERT INTO gdr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ɨ kwa wɨn ma opima nonyɨnd eyenindam da re Kon seben (7) sana nganja ke powa tausɨn (4,000) rɨga angeninond, sɨ wɨn owou komb ke leamog ukoi ga na yɨndangɨr amnɨktondam? ");
INSERT INTO gdr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Rɨdede paim wɨn maka nony aukindam da Kon ma owou gatab mim wen nonony amneninyɨn? Ajɨ wɨn yɨr kɨma tekenyɨt Parisai rɨga ake Sadukai rɨga waina yist pɨla ouyaena gatab.” ");
INSERT INTO gdr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Sɨ Yesumna onggɨt opurena kena Tina b'auyaena rɨgap nony aukɨto da Ton ma owou gatab mana nonony nomneniny ajɨ Parisai rɨga ake Sadukai rɨga waina ouyaena gatab mana. ");
INSERT INTO gdr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ɨ re Yesu ikonj de Kaisareya Pilipo eriya wa, Ton Tina b'auyaena rɨga arkisinonj da, “Yena rɨgap yomnɨkenenyi da yete Rɨgamna B'ɨga?” ");
INSERT INTO gdr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Sɨ ton mɨra yomno da, “Nɨnda rɨgap endenenanj da Man Baptiso Yoantet, ɨ nɨndap da Man Eliyatet, ɨ kwa nɨndap da Man Yeremiyatet o yɨpa God ma bageyamtet kesam yɨna peba wɨngɨrɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Seg Yesu ten kwa arkisinonj da, “Ajɨ wɨdaka rɨngmim? Wɨn yena yomnɨkenenya da yeten Kon?” ");
INSERT INTO gdr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Petro mɨra yomnonj da, “Man re Kerisotet yete re yilo Godɨmna B'ɨga.” ");
INSERT INTO gdr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Sɨ Yesu Petrond yɨsmonggawonj da, “Yonamna b'ɨga Simon, man re b'ogɨl omni rɨga et. Mop nokɨp ma gɨm ke rɨgate yete re mɨ dɨde kus kɨma yɨbɨm onggɨt gowukoyɨnd, tonte mor wumɨr pɨtapɨta momnau onggɨtyam gar ke utkunda gatab, ajɨ Kor B'ute yete re yɨbɨm de pumb tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ɨ Kon kwa men wumɨr motɨnyɨn da Man re Petrotet. Ɨ man kea b'agenayet da Kon re Kerisoten. Sɨ ɨtemb moina opuliti re kɨla pɨla danda kɨma met orangapu pɨpmet e. Ɨ Kon onggɨt kɨla kumb nate Koina sosi orangen dem, sɨ ujɨmna dandap rɨnsim re uj rɨga waina tunggɨnd wekeny, ton makwa rɨrɨr e ɨtemb sosi gou wa omnenyi dem. ");
INSERT INTO gdr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Sɨ Kon pumb tunggɨmna ki motkainyɨn rɨnte re God wɨp yomneny, ɨ nanggamog na ra man ɨjobɨket onggɨt gowukoyɨnd, sɨ ɨta ɨjobɨki ɨbɨm dem de pumb tungg wa, ɨ nanggamog na ra man ɨtreket onggɨt gowukoyɨnd, sɨ ɨta ɨtreki ɨbɨm dem de pumb tungg wa.” ");
INSERT INTO gdr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Seg Yesu ket b'auyaena rɨga yɨt etainonj da, “Goro yena wumɨr omnena da, ‘Kon re Kerisoten.’” ");
INSERT INTO gdr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ɨ onggɨt kak ke Yesu omandemb yiyata kɨma b'atomonj Tina b'auyaena rɨga wa odede yɨt pɨtapɨta omnenam da, “Kon b'ogla nekɨn Yerusalem taun wa dɨde jogjog b'ɨdgotnena takasinyɨn dem Ju rɨga waina elda rɨga wa pɨlke, ɨ yɨna mopyam sɨ rɨga wa pɨlke, ɨ dɨde Ju rɨga waina gog ouyaena rɨga wa pɨlke. Ɨ ton Ken notnganji dem dɨde Kon ɨta tutnyisɨn dem nowam bibɨrɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ɨ Petro ket Yesund yɨu wa yiyonj dɨde ket odede samany yɨt yiyowonj da, “Yonggyam! Toko God kear mamɨn! Goro odede mɨle mor pɨlɨnd rawɨk!” ");
INSERT INTO gdr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Sɨ ket Yesu Petrom pɨlwa wɨp ɨtaingitonj dɨde ket yomnonj da, “Satana, ewaikite Kor pɨlke! Man re b'uwombenapu rɨga e aet Kornɨm. Mop nokɨp man ma ɨta nonyɨk b'amdena mekenyɨt Godɨmna singi mɨle omnɨkam ajɨ man rɨgaina singi mɨle omnɨka ma.” ");
INSERT INTO gdr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Seg ket Yesu Tina b'auyaena rɨga amninonj da, “Yet ra man singi taet Ken yɨmta undokam, man b'ogla naska moina singi komkesa terarkinyɨt. Ɨ kwa man b'ogla komkesa bebɨg takasinyɨt Godɨm wɨkond ngɨrpu moina uj wul b'agbagɨnd, dɨde ket Ken yɨmta nutundoket. ");
INSERT INTO gdr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mop nokɨp yet ra tilenggyam tina yɨrkokar yɨrgong omnɨka iyeny, ton ɨta tina onggɨtyam yɨrkokar dadal edamkis dem. Ɨ daka yet ra tina yɨrkokar edamkis Kor map, ton ɨta tina onggɨtyam yɨrkokar dadal okas dem. ");
INSERT INTO gdr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ɨ ra man komkesa gowukoi mornɨm okasɨt ɨ dɨde onggɨt gowukoi map moina yɨrkokar edamkisɨt dem, sɨ nangga b'ogɨl e man yɨr onget onggɨt gowukoi okati ke? O, nangga gasa kɨma e man igerkenyɨt moina yɨrkokar? ");
INSERT INTO gdr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mop nokɨp Rɨgamna B'ɨga ɨta ik dem Ti B'uɨmna b'ogɨl ɨnyomarena kɨma dɨde Tina aneru kɨma, ɨ onggɨt wɨn natemb dem ket Ton rɨga yɨpayɨpa wa mɨra tagoniny dem towaina wɨko omnɨki rɨrɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ɨ Kon ɨmɨnjog wen tamninyɨn da yepim re wɨn owɨnki wekenyɨt dɨkɨnd, wa wɨngɨrɨnd nɨnda rɨgap makwa opima uj taukanj, ngɨrpu ra ton Rɨgamna B'ɨgand yɨr iyi dem menonɨnd Tina pumb tungg wɨp omnenapu danda kɨma.” ");
INSERT INTO gdr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ɨ siks (6) bibɨr kak ke Yesu ara emokinonj Petro, Yakobo, dɨde ti yɨnggan Yoan, ɨ ten nena eyinonj de yɨpa ukoi dor kumb wa. ");
INSERT INTO gdr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Re ket tentawar wa opekto, Yesu b'enga wɨp aukonj towa wɨpɨnd. Sɨ Tina wɨp b'unyomarenonj re lomkongga pɨla na dɨde Tina kobɨrgɨm daka bɨlbɨljog aukonj re ngaya pɨla na. ");
INSERT INTO gdr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ɨ odedend ket Mose ake Eliya pɨta awonda opimemb b'auyaena rɨga wa wɨpɨnd dɨde ton Yesu kɨma yɨtnono aenonda. ");
INSERT INTO gdr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Seg re ket Petro Yesund yomnonj da, “Yonggyam! Sɨn otomanti im wekenyɨn dɨkɨnd. Sɨ ra Man singi taet, kon nowa wungapu plaimet taranginyɨn dɨkɨnd, yɨpa Mornɨm, yɨpa Mosem ɨ dɨde yɨpa Eliyam.” ");
INSERT INTO gdr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ɨ re Petro yɨtnono aenand yɨbnonj, odedend ket ɨnyomarena kɨma rɨmɨt ten ekangɨnjinonj, ɨ odedend ket rɨm bora ke ara ikonj odede da, “Ɨtemb jɨ Koina B'ɨga yena re Kon singi yiyenyɨn dɨde yana kɨma e re Kon ma sobijog sam e aenyɨn. Sɨ wɨn Tin yutkundena!” ");
INSERT INTO gdr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ɨ re b'auyaena rɨgap ɨtemb ara utkundo, ton kea as ɨroukɨto dɨde ket ma sobijog na moga aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ɨ ket Yesu ikonj towa pɨlwa dɨde ket ten asopainonj odede yɨt kɨma da, “Utnɨkina! Ɨ goro moga tainam!” ");
INSERT INTO gdr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Seg re ton pumb wa yɨr aukɨto, ton makwa yena yɨr yongo ajɨ Yesu nena na Tinta. ");
INSERT INTO gdr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Seg re ton dor kumb ke paga etaeta tuwonj, nyawɨnd Yesu b'auyaena rɨga engainonj da, “Goro yena wumɨr tamneninam onggɨt gasa gatab rɨna re wɨn yɨr angindam, ngɨrpu ra Rɨgamna B'ɨga tutnyis dem uj ke!” ");
INSERT INTO gdr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Seg b'auyaena rɨgap ket Yesund yerkito da, “Sɨ nangga pae meraina gog ouyaena rɨgap apurenanj da, ‘Eliya b'ogla naska menon okas, ɨ ti kak ke Keriso ɨta ik dem'?” ");
INSERT INTO gdr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ɨ Yesu ket mɨra amninonj da, “Sɨ yena pebat yindeny da ra Eliya ik, tonte ket komkesa gasa b'obogɨl tangonjeniny. ");
INSERT INTO gdr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ajɨ Kon wen tamninyɨn da Eliya re kea ikonj, dɨde rɨgap maka tin yongwato ajɨ rɨgap kea towaina singi rɨrɨrɨnd komkesa negɨr mɨle amnɨkto ti pɨlɨnd. Ɨ daka odede yɨpa wɨp nya kae Rɨgamna B'ɨga todaka ɨta onggɨt rɨga wa pɨlke b'ɨdgotnena okateny dem.” ");
INSERT INTO gdr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Sɨ ɨdenatemb ket b'auyaena rɨgap nony aukɨto da Ton towa pɨlwa yɨtnono aenonj re Baptiso Yoanɨm gatab na. ");
INSERT INTO gdr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ɨ re Yesu yikonj rɨga bobo wa pɨlwa, yɨpa rɨga ikonj Ti pɨlwa dɨde ket kumsos b'amkonj Ti wɨpɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Seg ton ket yomnonj da, “Yonggyam! Kor b'ɨgand kear yomne! Mop nokɨp ton nony kesa sap otendeny tumol aembɨka kɨma, sɨ ton ma sobijog e b'ɨdgotnena yokateneny. Ɨ ton jogjogpyam b'aklandeneny de wul wa dɨde daka jogjogpyam unykeneny de nyɨ wa. ");
INSERT INTO gdr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Sɨ kon ke tin iyɨn Moina b'auyaena rɨga wa pɨlwa, ajɨ ton ma rɨrɨr na aukanj tin b'ogɨl omnam.” ");
INSERT INTO gdr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Seg ket Yesu mɨra amninonj da, “Oo, gar ke utkunda kesa dɨde gar eskamki rɨga yepim re yu onggɨt gowukoyɨnd wekenyɨt! Rɨdede pɨn e Kon nɨtɨbnyɨn wɨn kɨma? Ɨ rɨdede pɨn e Kon musɨk wɨmena okasɨn waina gar ke utkunda kesa mɨle gatab? B'ɨga iya dɨkɨnd Kor pɨlwa!” ");
INSERT INTO gdr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ɨ re ton b'ɨga iyo Yesum pɨlwa, Ton ket negɨr wɨngawɨngand yingawonj opendam. Seg ɨtemb negɨr wɨngawɨnga kea opendonj onggɨt b'ɨgam pɨlke dɨde ket onggɨt wɨnjogɨnd kea ɨtemb b'ɨga b'ogɨl awonj. ");
INSERT INTO gdr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ɨ ket Yesumna b'auyaena rɨga Ti pɨlwa tuwonj dɨde ket ton nena wekenonj yɨpa pɨpmetɨnd. Ɨ ɨdenatemb ket Tina b'auyaena rɨgap yerkito da, “Nangga pena sɨn maka rɨrɨr aindam ɨtemb negɨr wɨngawɨnga ewaikitam?” ");
INSERT INTO gdr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Sɨ Ton ten esmonggainonj da, “Mop nokɨp waina gar ke utkunda re ma ukoi e. Sɨ Kon wen ɨmɨnjog tamninyɨn da ra wa odede sobijog gar ke utkunda tebnainy mastad tuny re dɨde, sɨ wɨn b'ogɨl e onggɨt dorɨnd omnya da, ‘Man ɨngkekemb b'apakate deta dide,’ ɨ ɨtemb dor ɨta b'atpakas dor. Sɨ awɨr e kwa yɨpa gasa bebɨg tainy wanɨm omnɨkam.” ");
INSERT INTO gdr_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Awɨr e) ");
INSERT INTO gdr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ɨ re Yesu dɨde Tina b'auyaena rɨga yɨpand b'eomto Galili wa, Yesu ten ket amninonj da, “Rɨgamna B'ɨgand ɨta namb tɨb yii dem de rɨgaina yɨm kumb wa. ");
INSERT INTO gdr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ɨ onggɨt rɨgap ɨta Tin onganji dem, ɨ Ton ɨta tutnyis dem nowam bibɨrɨnd.” Ɨ re b'auyaena rɨgap Tina yɨt utkundo, ton ket ma sobijog na nony bebɨg aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ɨ re Yesu dɨde Tina b'auyaena rɨga wuwonj de Kaparnaum taun wa, yɨnamet teks imda rɨga tuwonj Petrom pɨlwa dɨde ket yɨgekito da, “Ma ma ɨta waina Ouyaena Rɨgat yɨnamet teks aramkeneniny?” ");
INSERT INTO gdr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ɨ Petro mɨra amninonj da, “Owɨ, Toda ɨta.” Seg re Petro met wa b'ɨgaronj, Petro re pop Yesund wumɨr omnam yomnonj ajɨ Yesu naska nata tin yomnonj da, “Simon! Rɨngma man nony aet? Sɨ ya pɨlkaim gowukoi kingɨp nɨnda b'engabenga teks imda eyenanj? Rɨka towainajog b'ɨgawar wa pɨlkaim o nɨnda rɨga wa pɨlkaim?” ");
INSERT INTO gdr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Sɨ Petro mɨra yomnonj da, “Nɨnda rɨga wa pɨlkaim.” Seg Yesu tin yomnonj da, “Sɨ raemb odede, king waina b'ɨgawarɨp, odede ɨt re Kon re dɨde, b'ogla teks oramki kesa waken. ");
INSERT INTO gdr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ajɨ man meke de sɨpa wa dɨde ket kedo b'ɨtɨsket. Ɨ ra naskajog kabum ɨwasɨt dor, man tugɨm uwamket dor, sɨ man ɨta odaret dor yɨpa koin wulkɨp. Ɨ man ket meranɨm yiyɨt dor towa pɨlwa teks oramitam, nokɨm da ɨdenat men maka ten komliwɨm tamninya.” ");
INSERT INTO gdr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ɨ onggɨt wɨnɨnd b'auyaena rɨga tuwonj Yesum pɨlwa dɨde ket yerkito da, “Yete ukoyam pumb tunggɨnd rɨnte re God wɨp yomneny?” ");
INSERT INTO gdr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ɨ ket Yesu yɨpa b'ɨga sobijog ara yemokonj dɨde yonyitonj towa wɨpɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Seg Ton ket ten amninonj da, “Kon wen ɨmɨnjog tamninyɨn da ra wɨn maka ra b'etngenjindam dɨde maka ra b'ɨga sobijog pɨla taukindam, wɨn makwa ngai rɨrɨr im b'ɨgarkam de pumb tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sɨ onggɨt paemb yet ra tilenggyam gou wa taukeneny odede b'ɨga sobijog pɨla, ɨtemb rɨga re ukoijog rɨga e pumb tunggɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ɨ dɨde yet ra yɨpa odede b'ɨga sobijogɨnd Kor nyɨ kɨma simesime omɨny rɨnte re wɨp ke dɨkɨnd onyiti yɨbɨm, ton Kena simesime nomɨny. ");
INSERT INTO gdr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ɨ ra yɨpa rɨgat odede b'ɨga sobijog wɨngɨrɨnd yɨpa b'ɨgand negɨr mɨle omnɨkam omɨny yepim re Ken gar ke utkunda ke nokatenyi, ɨtemb re ma sobijog bebɨg e tainy tinɨm. Ajɨ ɨtemb jɨ b'ogɨljog e tinɨm, rako rɨgap tina kunakakɨnd ukoi gɨmo danda kɨma yɨjobɨko kai ke dɨde yɨsko ngortodjog sɨpa nyɨ bora wa nyɨngor b'awamam, sɨ ma rako onggɨt b'ɨgand negɨr mɨle omnɨkam yingawonj. ");
INSERT INTO gdr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Sɨ God ma sake onggɨt gowukoyɨm pɨlwa komkesa odede mɨle map rɨnsim re rɨga negɨr mɨle omnɨkam amnɨkenenanj. Odede negɨr mɨle omnɨkam otonkena mɨle b'ogla wowen, ajɨ God ma sake onggɨt rɨga wa pɨlwa yepim re odede mɨle eyenanj. ");
INSERT INTO gdr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Sɨ ra moina yɨpa yɨmɨt o moina yɨpa pɨsɨt men negɨr mɨle omnɨkam motɨny, man b'ogla ɨtemb jɨ yɨm o pɨs ɨpenjɨt dɨde ket b'ɨtɨsket mor pɨlke. Ɨtemb re b'ogɨljog e mornɨm yɨmdudu o pɨsdudu kɨma b'ɨgaram ngɨrpu kesa yɨrkokar tungg wa. Ajɨ ma b'ogɨl emb jɨ nɨmog yɨm kɨma o nɨmog pɨs kɨma mɨtɨskansi dem de wul tungg wa rokate re dadal ngɨrpu kesa wul dɨmɨl yɨmbeneny. ");
INSERT INTO gdr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ɨ ra moina yɨpa yɨrkɨpɨt negɨr mɨle omnɨkam motɨny, man b'ogla ɨtkasɨt ɨtemb yɨrkɨp dɨde ket b'ɨtɨsket mor pɨlke. Ɨtemb re b'ogɨljog e mornɨm yɨpaina yɨrkɨp kɨma b'ɨgaram ngɨrpu kesa yɨrkokar tungg wa. Ajɨ ma b'ogɨl emb jɨ nɨmog yɨrkɨp kɨma mɨtɨskansi dem de wul tungg wa rokate re dadal ngɨrpu kesa wul dɨmɨl yɨmbeneny. ");
INSERT INTO gdr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ɨ wɨn yɨr kɨma tekenyɨt da goro wɨn yena ɨrɨnena iyena odede b'ɨga sobijog wɨngɨrɨnd. Mop nokɨp Kon wen wumɨr tamninyɨn da towa opima towainajog aneru yepim re wekeny de pumb tungg wa, ton ita wɨnɨnd ɨta Kor B'u Godɨnd wɨp yɨr yongenenyi yete re yɨbɨm pumb tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Awɨr e) ");
INSERT INTO gdr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Sɨ rɨngmim wɨn nony aindam? Ra yɨpa rɨgam ɨbnainy wan andred (100) mamoi ɨ onggɨt mamoi wɨngɨrɨnd yɨpa b'etɨdamkis, sɨ ma ton ɨndaima sukakɨnd yiyag tatkulisiny nainti nain (99) mamoi dɨde oraka iyeny ɨtemb yɨpa b'edamkiti mamoi ngɨrpu ra ket ton odar? ");
INSERT INTO gdr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sɨ Kon wen ɨmɨnjog tamninyɨn da ra ton ket ɨtemb b'edamkiti mamoi odar, ton ket ma sobijog sam e omnɨk ɨtemb odari mamoi kɨma, ajɨ ton ma odede sam e omnɨk opimemb nainti nain (99) mamoi kɨma rɨna re maka b'edamkuranj. ");
INSERT INTO gdr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ɨ odede yɨpa wɨp nya ke wa B'u God yete re yɨbɨm pumb tungg wa, Ton ma singi e odede b'ɨga sobijog wɨngɨrɨnd yɨpa b'ɨga b'etɨdamkis. ");
INSERT INTO gdr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ɨ ra yɨpa moina gar ke utkunda nanyɨt o yɨngganɨt negɨr mɨle omnɨk mor pɨlwa, man b'ogla meket ti pɨlwa dɨde ket man dɨde ton wentawarɨnd tina negɨr mɨle ti pɨta omnaet. Ɨ ra ton yɨt mutkunj dɨde b'atgenai tina negɨr mɨle gatab, sɨ man kea moina gar ke utkunda rɨga yɨm yokaet engendam Godɨm pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ɨ ra ton maka yɨt mutkunj, man yɨpa o nɨmog rɨga takasɨt, nokɨm da ɨdenat nɨmog o nowa yɨr ungata rɨgap komkesa yɨr ungata gatab yɨt temjatenanj towaina tugɨm ke. ");
INSERT INTO gdr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ajɨ ra ton b'ɨtɨsainy towaina yɨt utkundam, man b'ogla tina negɨr mɨle gatab sosi wumɨr omnyɨt. Ɨ kwa ra ton b'ɨtɨsai sosimna yɨt utkundam, ton mor pɨlɨnd ɨja na rau ɨt re yɨpa gar ke utkunda kesa rɨga odede God ma obagendi kesa rɨga pɨla o yɨpa teks imdayam rɨga pɨla. ");
INSERT INTO gdr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Sɨ Kon ɨmɨnjog wen tamninyɨn da nanggamog na ra wɨn ɨjobɨkya onggɨt gowukoyɨnd, sɨ ɨta ɨjobɨki ɨbɨm de pumb tungg wa, ɨ nanggamog na ra wɨn ɨtrekya onggɨt gowukoyɨnd, sɨ ɨta ɨtreki ɨbɨm de pumb tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ɨ Kon b'usaya wen ɨmɨnjog tamninyɨn da ra wa wɨngɨrɨnd nɨmog rɨgap nanggamog gasa gatab mana ra ɨmjasya onggɨt gowukoyɨnd dɨde yɨr opmitenand oramisya, sɨ Kor B'u yete re yɨbɨm pumb tungg wa, Ton ɨta towa tamnɨkau. ");
INSERT INTO gdr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mop nokɨp ra nɨmog o nowa rɨga yɨpand b'eteomkitanj Kor nyɨ kɨma, Kon ɨta dɨkɨnd ton kɨma nɨbnyɨn.” ");
INSERT INTO gdr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ɨ odedend ket Petro ikonj Yesum pɨlwa dɨde ket yɨgekitonj da, “Yonggyam! Ra koina gar ke utkunda rɨgat negɨr mɨle omnɨka teyeniny kor pɨlɨnd, sɨ leamogpyam e kon b'ogla ti negɨr mɨle awɨr omnainyɨn? Rɨka ama de sebenpyam (7) wa e?” ");
INSERT INTO gdr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Seg Yesu tin mɨra yomnonj da, “Kon motɨnyɨn da ma ama de sebenpyam (7) wa ajɨ rɨka ama de sebenti sebenpyam (77) o rɨka ogenka kesa wa e. ");
INSERT INTO gdr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Sɨ onggɨt paemb pumb tungg re yɨpa wɨp e odede king kɨma yet re singi awonj yɨr iyenam nanggamog abitoro im wekeny tina wɨko rɨga wa pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Sɨ re ɨtemb king tina wɨko rɨgaina abitoro wulkɨp yɨr iyena b'atomonj, tina wɨko rɨgap kea yɨpa abitoro rɨga iyo ti pɨlwa yama na re ogenka kesa ukoijog wulkɨp abitoro yɨbnawonj onggɨt kingɨm pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ajɨ ɨtemb rɨga ton ma rɨrɨr na ongandam onggɨtyam abitoro wulkɨp. Sɨ onggɨt penaemb ket ti yonggyam tin yingawonj da, ‘Man b'ogla molenggyam b'atɨsoget dɨde daka kwa tasoginyɨt mor kongga, mor b'ɨgawar ɨ dɨde komkesa moina gasa rɨnsim re mor mɨbnainy, ɨ ket onggɨt osogi wulkɨp ke abitoro onganjɨt.’ ");
INSERT INTO gdr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Sɨ ɨtemb wɨko rɨgat kear okatam kumsos b'amkonj kingɨm pɨlwa dɨde ket tin yɨtenawonj da, ‘Be man gangga nokae! Kon ɨta kupkakupka mor abitoro motngandaen.’ ");
INSERT INTO gdr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Sɨ ɨtemb wɨko rɨgamna yonggyam tin gar ke kear yomnonj dɨde ket tina abitoro awɨr yomnawonj dɨde ket yɨtmɨkitonj. ");
INSERT INTO gdr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ajɨ re ɨtemb wɨko rɨga opendonj, ton yɨpa tina wɨkomadɨnd yodaronj ya pɨlnat re ma ukoi abitoro wulkɨp na yɨbnawonj, dɨde ket tin kunaepɨnd yokatonj dɨde ket kɨr yukonj odede yɨt kɨma da, ‘Or abitoro nongandae!’ ");
INSERT INTO gdr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Sɨ ɨtemb ti wɨkomad kear okatam kum ujokonj ti pɨlwa dɨde ket tin yɨtenawonj da, ‘Be man gangga nokae! Kon ɨta mor abitoro motngandaen.’ ");
INSERT INTO gdr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ajɨ ton makwa singi awonj gangga okawam, sɨ ton ɨtemb tina wɨkomadɨnd yiyonj dɨde ket yɨskantonj sɨbɨbmet wa ngɨrpu ra ket ton ɨtemb abitoro onganj dem. ");
INSERT INTO gdr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Sɨ re tina wɨkomadwarɨp odede mɨle yɨr yongo rɨna re aukonj, ton ma sobijog na gar soro aukɨto. Seg ton ket wuwonj towaina yonggyamɨm pɨlwa dɨde ket komkesa mɨle towa yonggyamɨm yisɨpkenauto rɨna re aukonj. ");
INSERT INTO gdr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ɨ re ɨtemb yonggyam yɨt utkundonj, ton kea ket ɨtemb negɨr wɨko rɨga ara yemokonj dɨde ket yomnonj da, ‘Man re negɨrjog wɨko rɨga et. Kon kea moina kupkakupka abitoro awɨr momnainond, re man ken nɨtenawot gangga okawam mornɨm abitoro ongandam. ");
INSERT INTO gdr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Sɨ rɨngma, ma mor rɨrɨrkɨpjog e da man moina wɨkomadɨnd kear omnyɨt odede rɨngma na re kon men kear momnond?’ ");
INSERT INTO gdr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Seg tina yonggyam ma sobijog na soro awonj, sɨ ton sɨbɨbmet yɨr ɨpka rɨgaina yɨm kumb wa yoramitonj bebɨg okatenam ngɨrpu ra ket ton ɨtemb kupkakupka abitoro onganj dem. ");
INSERT INTO gdr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ɨ ra wɨn yɨpayɨpa rɨgap maka ra man moina gar ke utkunda nanyɨnd o yɨngganɨnd gar ke kear omnenyɨt dɨde ket maka tina negɨr mɨle awɨr omnainyɨt rɨna re ton mor pɨlɨnd amnɨkinonj, sɨ Kor B'u God yete re yɨbɨm pumb tungg wa, Todaka ɨta odede yɨpa wɨp nya ke men motɨneny.” ");
INSERT INTO gdr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ɨ re Yesu onggɨtyam yɨt opurena seg awonj, Ton ket Galili eriya yɨraronj dɨde ket yikonj de Yuda eriya wa de Yordan kɨlɨm yɨpa tab wa. ");
INSERT INTO gdr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ɨ jogjog rɨga bobop Yesund yɨmta yundoko, ɨ Ton ket ademb de kopa rɨga esakenjinonj. ");
INSERT INTO gdr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ɨ Parisai rɨga tuwonj Yesum pɨlwa dɨde ket Tin yotonkeno odede yɨt kɨma da, “Rɨka rɨrɨrkɨpjog e yɨpa rɨgat ti konggand bondɨk tomɨny nanggamog rɨl na ra ton todarau?” ");
INSERT INTO gdr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sɨ Yesu esmonggainonj da, “Ma wɨn ma wumɨr im da gowukoi otomapu ke otobarkayam God rɨga amnɨkonj re rɨga ake kongga na? ");
INSERT INTO gdr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ɨ God ket yindonj da, ‘Onggɨt paemb rɨgat ti b'u ake ti mog terar ɨ dɨde ket ti kongga kɨma b'itɨnkisya. Sɨ osiemb molkongga yɨpaina jɨ i taya.’ ");
INSERT INTO gdr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Sɨ osiemb molkongga re ma nɨmog i, ajɨ ton re yɨpaina jɨ i. Sɨ onggɨt paemb rɨna re God yɨpand enkitonj, goro yet wetaweta ramɨn.” ");
INSERT INTO gdr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Seg Parisai rɨgap Yesund yɨgekito da, “Sɨ nangga pena Mose b'ingawa yɨt yoramitonj da ra yɨpa rɨgat singi tainy ti konggand bondɨk omnam, ton b'ogla bondɨk omna peba tokau dɨde ket ɨtomb kongga tewaikis?” ");
INSERT INTO gdr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ɨ ket Yesu ten esmonggainonj da, “Mose wen enjɨkisinonj waina kongga bondɨk omnam, nokɨp waina gar re rogɨlkak na. Ajɨ odede bondɨk omna mɨle re maka gowukoi otomapu ke aukonj. ");
INSERT INTO gdr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ajɨ Kon wen tamninyɨn da yet ra ti konggand jabakɨpɨnd bondɨk tomɨny yɨpa rɨga kɨma negɨr b'iyena mɨle omnɨki kesand dɨde b'enga kongga tokas ti konggam, sɨ ton gigɨr dɨde yɨgyɨg b'iyena mɨle e omnɨka iyeny ɨtomb sisɨl kongga kɨma.” ");
INSERT INTO gdr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Seg Tina b'auyaena rɨgap Tin yomno da, “Rada kongga kɨma wɨmena mɨle gatab odede bebɨg taukanj rɨgam pɨlɨnd, sɨ ɨtemb b'ogɨljog e tinɨm kongga okati kesa tinta wɨmenam.” ");
INSERT INTO gdr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ɨ Yesu ket mɨra amninonj da, “Ma komkesa rɨga im odede yɨtɨt takasiny, ajɨ ten nena im yena re God amninonj kongga okati kesa wɨmenam. ");
INSERT INTO gdr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mop nokɨp nɨnda rɨga re rɨgaina kɨpear danda kesa im wekeny pɨl b'asopaya mɨle omnɨkam nokɨp ton ɨja na get ke towa mogwar wa pɨlke ukukto, ɨ nɨnda rɨga ɨpakɨp kesa map kongga okati kesa im wekeny nokɨp rɨgap kea ekɨkto, ɨ dɨde kwa nɨnda rɨga kongga okati kesa im wekeny ɨpakɨp ɨkɨki rɨga pɨla nokɨp ton b'ɨsaenenanj kongga okata mɨle, nokɨm da ɨdenat ton pumb tungg gatab wɨko b'obogɨl danda kɨma tamnɨkenenanj. Sɨ yete re rɨrɨrjog yɨbɨm odede kongga kɨma wɨmena mɨle okatam, ton onggɨtyam mɨlend yeken.” ");
INSERT INTO gdr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ɨ odedend ket rɨgap towaina b'ɨga sobijog Yesum pɨlwa eyento odede nony kɨma da ɨdenat Yesu Tina yɨm taramiteniny towa pɨlɨnd dɨde yɨr topmiteny ten b'ogɨl omnɨkam. Ajɨ b'auyaena rɨgap ten samany kɨma rɨga ogoka eyento b'ɨga iyenam Yesum pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ajɨ Yesu b'auyaena rɨga amninonj da, “Tou b'ɨga sobijog Kor pɨlwa! Goro b'ɨga ogoka eyenindam, mop nokɨp odede b'ɨga wa maemb jɨ pumb tungg.” ");
INSERT INTO gdr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ɨ ket Yesu Tina yɨm aramiteninonj yɨpayɨpa b'ɨga wa pɨlɨnd ten b'ogɨl omnam, ɨ ɨngkenaemb ket onggɨt pɨpmet ke yikonj. ");
INSERT INTO gdr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Seg ket yɨpa rɨga Yesum pɨlwa ikonj dɨde ket Yesund yerkitonj da, “Ouyaena Rɨga! Nangga b'ogɨl wɨko e kon omnɨken dadal ngɨrpu kesa yɨrkokar okatam?” ");
INSERT INTO gdr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ajɨ Yesu tin mɨra yomnonj da, “Nangga pae man Ken nɨgekisɨt b'ogɨl gasa gatab? Godta Tinta yɨpaina b'ogɨl yɨbɨm. Ajɨ ra man singi taet b'ɨgaram ngɨrpu kesa yɨrkokar wa, man b'ogla God ma b'ingawa yɨt yɨmta undoka teyeninyɨt.” ");
INSERT INTO gdr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ɨ ton ket Yesund yɨgekitonj da, “Rɨnggɨtyam b'ingawa yɨt im?” Sɨ Yesu ket tin yɨsmonggawonj da, “Man ɨnsimemb jɨ b'ingawa yɨt yɨmta tundokinyɨt, opi re goro rɨga ongandɨm, goro gigɨr dɨde yɨgyɨg b'iyena mɨle omnɨka, goro yurowam, goro rɨga gatab yɨr ungati kesa b'anygɨnena yɨt usekɨm, ");
INSERT INTO gdr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tesnaet mor b'u ake mor mog, ɨ dɨde singi yiyene mor rɨgand mada re dɨde!” ");
INSERT INTO gdr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Seg ɨtemb sisɨl rɨga ket Yesund yomnonj da, “Kon kea opimemb komkesa b'ingawa yɨt yɨmta undoka eyeneninond. Sɨ nangga e kon kwa b'ogla omnɨken?” ");
INSERT INTO gdr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ɨ ket Yesu tin mɨra yomnonj da, “Ra man singi taet rɨrɨrkɨpjog rɨga awowɨm, sɨ man meke! Ɨ nangga gasa im re mor mɨbnainy man tasoginyɨt, ɨ dɨde ket man komkesa osogi wulkɨp ogona teyeninyɨt gasa kesa rɨga wa. Ra man odede omnɨket, yɨmta ke ket mor jogjog b'ogɨljog gasa opima mɨtɨbnainy dem de pumb tungg wa. Seg ket man metket Kor pɨlwa dɨde ket yɨmta nutundoket!” ");
INSERT INTO gdr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Sɨ re onggɨt sisɨl rɨgat odede yɨt utkundonj, ton ket gar bebɨg kɨma yiwatonj, mop nokɨp ti jogjog gasa na yɨbnainonj. ");
INSERT INTO gdr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Seg daka ket Yesu Tina b'auyaena rɨga amninonj da, “Kon ɨmɨnjog wen tamninyɨn da jogjog gasa kɨma rɨgam re bebɨg e b'ɨgaram de pumb tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ɨ Kon kwa b'usaya wen tamninyɨn da ukoi jɨ b'angga kamelɨm b'ɨgaram de nidɨl bora wa, ɨtemb re jɨ ma bebɨg e, ajɨ jogjog gasa kɨma rɨgam God ma pumb tungg wa b'ɨgaram, ɨtemb re jɨ ukoijog bebɨg e.” ");
INSERT INTO gdr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ɨ re b'auyaena rɨgap ɨtemb yɨt utkundo, ton ɨsanikesa ukoijog kɨd kesa aukɨto dɨde ket endento da, “Sɨ yete rɨrɨr yɨrkokar okatam?” ");
INSERT INTO gdr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sɨ Yesu ten yɨr epkinonj dɨde ket amninonj da, “Rɨgam re onggɨtyam gasa ma rɨrɨr im ti omnɨkam, ajɨ Godɨm re Ti komkesa gasa rɨrɨr im omnɨkam.” ");
INSERT INTO gdr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ɨ ket Petro Yesund yomnonj da, “Yɨr de, sɨn komkesa gasa erarkɨtondam dɨde ket mena yɨmta undoka miyenyu. Sɨ nangga b'ogɨl e sɨn yɨr ongu onggɨt mɨle ke?” ");
INSERT INTO gdr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ɨ Yesu ket mɨra amninonj da, “Kon ɨmɨnjog wen tamninyɨn da onggɨt wɨnɨnd ra sisɨl gowukoi pɨta tainy dem dɨde ra Rɨgamna B'ɨga Tina b'ogɨl ɨnyomarena kɨma wɨp omnenapu kasa kumbɨnd tomis dem, wɨn yepim re Ken yɨmta undoka niyenya, wɨdaka opima twelp (12) wɨp omnenapu kasa kumbɨnd tomnɨkindam dem dɨde ket Israel twelp (12) gu rɨga ɨsagɨka teyenindam dem. ");
INSERT INTO gdr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ɨ daka kwa yepiya re Koina nyɨ map erarkɨto towa met, towa nanywar, towa yɨngganwar, towa ngɨmɨrwar, towa b'u, towa mog, towa b'ɨgawar, dɨde towaina gou, ton opima odede gasa takatenanj dem wan andredpyam (100) ɨ dɨde dadal ngɨrpu kesa yɨrkokar owabɨnsi dem. ");
INSERT INTO gdr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ajɨ rɨga yepim re yu ukoijog nyɨ rɨga pɨla wekeny, towa wɨngɨrɨnd jogjog rɨga opima yɨmta ke sobijogjog nyɨ rɨga taukanj dem. Ɨ rɨga yepim re yu sobijogjog nyɨ rɨga pɨla wekeny, towa wɨngɨrɨnd jogjog rɨga opima yɨmta ke ukoijog nyɨ rɨga taukanj dem. ");
INSERT INTO gdr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Sɨ pumb tungg re yɨpa wɨp e odede gou yonggyam kɨma yet re sɨtawarjog tina met ke yiwatonj nɨnda wɨko rɨga imdam tina greip sopapund mɨra kɨma wɨko omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ɨ re ton naska ti nɨnda wɨko rɨga adarinonj sɨtawarɨnd, ton kea ɨmjati yɨt towa akainonj da yɨpa bibɨr wɨko mɨra re siks (6) Kina e dɨde ket ten etmɨkisinonj tina greip sopapu wa wɨko omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ɨ yɨmta ke nain (9) kɨlokɨnd ton ket yikonj maket wa, ɨ ton ket kea kwa nɨnda rɨga jaba owɨnki yɨr anginonj. ");
INSERT INTO gdr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Sɨ ton ket opimemb rɨga amninonj da, ‘Wɨdaka wuwe koina greip sopapu wa wɨko omnɨkam. Sɨ kon opima wa mɨra tagoninyɨn waina wɨko rɨrɨrɨnd.’ ");
INSERT INTO gdr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ɨ ton ket wuwonj sopapu wa. Seg ɨtemb yonggyam ket b'usaya yikonj twelp (12) kɨlokɨnd ɨ dɨde kwa sɨmana gatab tri (3) kɨlokɨnd, ɨ dɨdea kwa yɨpa wɨp mɨle omnɨka yiyenonj. ");
INSERT INTO gdr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ɨ kwa daka ama rɨka sɨmana gatab paib (5) kɨlokɨnd re ton b'usaya yikonj maket wa, ton kwa kea de nɨnda rɨga owɨnki adarinonj. Sɨ ton ten arkisinonj da, ‘Nangga paim wɨn dɨkɨnd jabajaba bibɨr pɨnpɨn owɨnki wekenyɨt?’ ");
INSERT INTO gdr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ɨ opimemb rɨga tin mɨra yomno da, ‘Makwa sɨn yet wulkɨp kɨma wɨkom nimjiny.’ Seg ton ket ten amninonj da, ‘Wɨdaka kwa wuwe koina greip sopapu wa wɨko omnɨkam!’ ");
INSERT INTO gdr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Sɨ re ket sɨ imoka ikonj, ɨtemb greip sopapu yonggyam tina wɨko yɨr ɨpka mopyamɨnd yomnonj da, ‘Man wɨko rɨga ara emokine, dɨde ket towa mɨra wulkɨp tagoninyɨt. Sɨ man yongga otomet ra yɨmtajog imdi wɨko rɨga wa pɨlkae ngɨrpu ama ra de naskajog imdi rɨga wa pɨlwa.’ ");
INSERT INTO gdr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ɨ ket wɨko rɨga yena re emjinonj sɨmana gatab paib (5) kɨlokɨnd tuwonj, dɨde ket kea ton yɨpayɨpa rɨgap siks (6) Kina imda eyento. ");
INSERT INTO gdr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Sɨ re naska imdi rɨga tuwonj mɨra okatam, ton ɨja na nony aukɨto da ton ukoi mɨra im temdanj. Ajɨ todaka kwa yɨpayɨpa rɨgap siks (6) Kina nena na emdɨto. ");
INSERT INTO gdr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ɨ re ton emdɨto, ton ma sobijog na odede yɨt kɨma yɨt b'ebongnena wuwenonj sopapu yonggyamɨm pɨlwa da, ");
INSERT INTO gdr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Opimemb yɨmta imdi wɨko rɨga re jaba yɨpaina awa nena na wɨko yomnɨki ajɨ sɨnpiya bibɨr pɨnpɨn dɨde gɨnggɨl kɨkɨbɨnd ukoi kana bebɨg kɨma b'asowa yokatenyu. Sɨ kea naemb man sɨn onggɨt rɨga kɨma yɨpa rɨrɨrkɨp nomninyɨt.’ ");
INSERT INTO gdr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ajɨ sopapu yonggyam towa wɨngɨrɨnd yɨpa rɨgand yomnonj da, ‘Kor rɨga! Kon maka mor pɨlɨnd negɨr mɨle yomnɨken. Ma man maka siks (6) Kinam wɨko mɨra yɨmjasɨt kon kɨma? ");
INSERT INTO gdr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Sɨ man b'ogla moina mɨra nena yokate dɨde ket meke moina met wa! Ajɨ kon koina singi nat ɨtemb yɨmtanyam okati wɨko rɨgam odede yɨpa rɨrɨrkɨp mɨra wulkɨp yokaen rɨja na re kon mokaen. ");
INSERT INTO gdr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Sɨ rɨngma, ma ɨtemb re ma rɨrɨrkɨpjog e kornɨm koinajog wulkɨp ingaenam koina singi rɨrɨrɨnd? O ma sɨ man nok pae nonyɨk nɨponenyɨt da kon b'ogɨl mɨle na yomnɨken?’ ");
INSERT INTO gdr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Sɨ odede yɨpa wɨp nya ke rɨga yepim re yu ukoijog nyɨ rɨga pɨla wekeny, towa wɨngɨrɨnd jogjog rɨga opima yɨmta ke sobijogjog nyɨ rɨga taukanj dem. Ɨ rɨga yepim re yu sobijogjog nyɨ rɨga pɨla wekeny, towa wɨngɨrɨnd jogjog rɨga opima yɨmta ke ukoijog nyɨ rɨga taukanj dem.” ");
INSERT INTO gdr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ɨ re Yesu Yerusalem taun wa menon yokatonj, Ton twelp (12) b'auyaena rɨga nena tentawar wa amninonj dɨde ket nyawɨnd ten amninonj da, ");
INSERT INTO gdr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Yɨr de, men menon yokasu re Yerusalem ma. Yɨpa rɨgat ɨta Rɨgamna B'ɨga tɨb yii dem dɨde takainy dem yɨna mopyam sɨ rɨga dɨde Ju rɨga waina gog ouyaena rɨga wa pɨlwa, ɨ ket tonpim tɨrɨr omnyi dem Tin ongandam. ");
INSERT INTO gdr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ɨ dɨde ton ket Tin yiyi dem de God ma obagɨki kesa rɨga wa pɨlwa, sɨ ket opimemb God ma obagɨki kesa rɨgap Tin ngong engena kɨma jɨ malɨk omnɨka iyenyi dem, ɨ Tin ɨraska iyenyi dem, ngɨrpu wul b'agbagɨnd ɨdrɨki dem. Seg ket nowam bibɨrɨnd Ton tutnyis dem uj ke.” ");
INSERT INTO gdr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ɨ odedend ket Jebedaimna kongga ti b'ɨga nɨmog Yakobo ake Yoan kɨma tikonj Yesum pɨlwa ɨ ket kum ujokonj ɨ dɨde ket Yesund yɨgekitonj tina singi omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Sɨ Yesu tin werkitonj da, “Nangga ma man singi aet?” Ɨ ket ɨtomb kongga Tin mɨra yomnonj da, “Man tɨrɨr notɨnaet da Man osiemb koina b'ɨga nɨmog wa mor wus ke ukoi pɨpmet takaet omitam, yɨpa Moina yɨmjog yɨm tab ke ɨ yɨpa kwa Moina sawai yɨm tab ke de Moina kantrind.” ");
INSERT INTO gdr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ajɨ Yesu ket ten amnonj da, “Wɨn ma wumɨr im nangga ma wɨn nerkisya. Rɨka wɨn rɨrɨr i Koina b'ɨdgotnena kapo nyɨ onayam rɨnte ra Kon onaen dem?” Sɨ osiemb b'ɨga nɨmogɨp ket mɨra yomnonda da, “Sɨn rɨrɨr i.” ");
INSERT INTO gdr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sɨ Yesu mɨra amnonj da, “Wɨn b'ogɨl i onaya dem Koina b'ɨdgotnena kapo, ajɨ omitam gatab ɨt re Kor yɨmjog yɨm tab ke dɨde sawai yɨm tab ke, ɨtemb re ma Kor ogona gasa im. Ajɨ Kor B'u God towa mi jɨ pɨpmet takau dem yama na re Ton angonjenawonj.” ");
INSERT INTO gdr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ɨ re ten (10) komb b'auyaena rɨgap onggɨtyam yɨt utkundo, ton osiemb nɨmog nanyɨnggan wa pɨlwa soro aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Seg Yesu ket komkesa b'auyaena rɨga ara emokinonj Ti pɨlwa menonɨm dɨde amninonj da, “Wɨn wumɨr im da wɨp iyoi rɨga yepim re wekeny God ma obagɨki kesa rɨga wa wɨngɨrɨnd, ton towaina rɨga wanɨm aukenenanj re yonggyam im, dɨde kwa towaina ukoijog nyɨ rɨgap ɨsanikesa danda engaenenanj towaina rɨga wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Sɨ wa wɨngɨrɨnd re ma ɨja emb jɨ. Ajɨ wa wɨngɨrɨnd yet ra singi tainy ukoi rɨga awowɨm, ton b'ogla waina wɨko rɨga rau dem. ");
INSERT INTO gdr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ɨ daka kwa wa wɨngɨrɨnd yet ra singi tainy pumbjog wa ukoi rɨga wɨmenam, ton b'ogla waina goujog wɨko rɨga rau dem. ");
INSERT INTO gdr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sɨ Rɨgamna B'ɨga daka ma odede mop pena ikonj onggɨt gowukoi wa da rɨga Tinɨm wɨko rɨga taukanj. Ajɨ Ton ikonj re rɨga wa wɨko rɨga awou mana dɨde Tina yɨrkokar ke jogjog rɨgaina negɨr mɨle ɨraba mana.” ");
INSERT INTO gdr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ɨ re Yesu dɨde Tina b'auyaena rɨga Yeriko taun ke yiwato, kea ukoi bobo rɨgap Tin yɨmta yundoko. ");
INSERT INTO gdr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ɨ onggɨt wɨnɨnd ket nɨmog yɨrdɨdɨ rɨga yepiya re omiti ebnonda nya yɨund, ton kea utkundonda da Yesute nya opanjis. Seg ton ket b'okta ara yɨawonda da, “Yonggyam! Dawidɨmna B'ɨgawɨi! Sɨn kear nomne-o!” ");
INSERT INTO gdr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ajɨ rɨga bobop ten samany ke amneno da, “Muma kesa awa!” Ajɨ osiemb yɨrdɨdɨ rɨgap ara yoikɨndenonda da, “Yonggyam! Dawidɨmna b'ɨga-wɨi! Kear nomne-o!” ");
INSERT INTO gdr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Seg ket Yesu omanda onyitonj, ɨ ket ten ara emokonj. Sɨ ket ten arkitonj da, “Nangga mi wɨn singi aya Kon wanɨm omnɨkam?” ");
INSERT INTO gdr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ɨ ton mɨra yomnonda da, “Yonggyam! Sɨn singi i da Man sowaina yɨr tepangkinyɨt.” ");
INSERT INTO gdr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Sɨ Yesu kea ten gar ke kear amnonj, dɨde ket towaina yɨrkɨp asopainonj. Seg odenja ket osiemb nɨmog yɨrdɨdɨ rɨgap yɨr b'ɨskeninonda dɨde ket Yesund yɨmta yundokonda. ");
INSERT INTO gdr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ɨ Yesu dɨde Tina b'auyaena rɨga ket Yerusalem taun wuswus wa aukɨto dɨde ket opento de Betpage tungg wa rɨna re Olib dorɨnd yɨbnonj. Ɨ ɨngkenaemb ket re Yesu Tina nɨmog b'auyaena rɨga etmɨkitonj, ");
INSERT INTO gdr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ton ket ten amnonj da, “Wɨn eka onggɨt tungg wa rɨnte re wa wɨp ke yɨbɨm! Ra wɨn onggɨt tungg wa b'ɨtgarya, odenja wɨn yɨpa mogyat dongki todarya dor ti b'ɨga kɨma rɨnto re kai ke wulɨm pɨlɨnd ɨjobɨki wɨbɨm. Sɨ wɨn ket kai ɨtrekya dɨde teiya dor Kor pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ɨ ra yɨpa rɨgat wen tarkis da, ‘Wɨn nangga pae odede yomnɨkya?’ wɨn b'ogla wumɨr omnya dor da, ‘Yonggyam osiemb dongki mogbɨga singi i amɨny ingawam.’ Ɨ ra wɨn yɨt opurena seg taya, ɨtemb rɨga odenja i tetmɨkis dor dɨkɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ɨ ɨtemb mɨle aukonj re onggɨt mana da ɨdenat ɨtemb bage yɨt rɨrɨrkɨp tainy bageyam waina opureni yɨtkak da, ");
INSERT INTO gdr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Wɨn Siyonɨnd, ɨt re Yerusalem taun, wumɨr womna, Yɨr de, moina King ɨte ik mor pɨlwa, Ton Tilenggyam gou wa ainy, sɨ Ton angis re yɨpa dongki kumb nate, ajɨ ama de gasa iyenapu b'anggamna b'ɨga, ɨtemb re b'ɨgayam dongki kumb nate.” ");
INSERT INTO gdr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Sɨ osiemb nɨmog b'auyaena rɨga ekonda dɨde ket ton kea onggɨt yɨt rɨrɨrɨnd gasa amnɨkinonda rɨja na re Yesu ten engawonj. ");
INSERT INTO gdr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ɨ ton ket ɨtomb dongki dɨde ti b'ɨga teyonda Yesum pɨlwa dɨde ket towaina tumɨnd kobɨrgɨm osiemb dongki kumb wa aramkinonda. Seg Yesu ket dongki b'ɨga kumb wa angitonj. ");
INSERT INTO gdr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ɨ rɨga bobo wɨngɨrɨnd jogjog rɨgap kea towaina tumɨnd kobɨrgɨm Tina menonpu nyawɨnd ondrɨka eito, ɨ dɨde kwa kea nɨnda jogjog rɨgap wulpip ɨpka eyento dɨde ket ondrɨka eito nyawɨnd ukoi ɨsnawa kɨma. ");
INSERT INTO gdr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ɨ rɨga bobo yepiya re Ti wɨp nata dɨde Ti kak nata wuwonj, ton b'okta ara kɨma ger ɨtanga yiyo da, “Osanna, Yonggyam Dawidɨmna B'ɨgam pɨlwa! Ɨta God ma b'ogɨl Man kɨma yete re Yonggyamɨm nyɨ kɨma ik! Osanna pumbjog Godɨm pɨlwa!” ");
INSERT INTO gdr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ɨ re Yesu b'ɨgaronj de Yerusalem taun wa, komkesa taun rɨgap ɨtemb taun guglam nena yomnɨko dɨde endento da, “Yetemb jɨ rɨga?” ");
INSERT INTO gdr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Sɨ opimemb rɨga bobo yepiya re Yesu kɨma b'ɨgarkɨto, ton mɨra amnento da, “Ɨtemb jɨ bageyam Yesu yete re ik Najaret tungg ke Galili eriya wɨngɨrɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ɨ ket Yesu b'ɨgaronj yɨnamet kara wɨngɨr wa. Ɨ Ton ket eaukeninonj komkesa rɨga yepiya re Godɨm sɨ gasa asogenento dɨde imda eyenento yɨnamet aband. Ɨ dɨde ket Ton gu engendurkena eyeninonj wulkɨp sensi omnenapu kasa rɨkɨnd re b'engabenga wulkɨp wekenonj osogam, dɨde yɨnamet teks wulkɨp imdam, dɨde Godɨm sɨ gasa gimai osogapu kasa. ");
INSERT INTO gdr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ɨ ket Yesu ten amninonj da, “Yɨna peband ɨja emb jɨ yɨnamet gatab ɨrɨki yɨbɨm da, ‘Rɨgap b'ogla Koina met yagenae yɨr opmitenapu met ke'. Ajɨ wɨnpim ɨtemb yɨnamet wɨp yomnɨkya da raskol waina wɨmenapu pɨpmet e.” ");
INSERT INTO gdr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ɨ ket yɨrdɨdɨ rɨga dɨde gomgom rɨga tuwonj Yesum pɨlwa yɨnamet aband, sɨ ket Yesu ten esakenjinonj. ");
INSERT INTO gdr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ajɨ re yɨna mopyam sɨ rɨga dɨde Ju rɨga waina gog ouyaena rɨgap yɨr angto opimemb kɨd kesa kɨma mɨle rɨna re Yesu amnɨkinonj dɨde b'ɨga sobijog yepiya re b'okta ara kɨma ger atangto yɨnamet aband da, “Osanna Dawidɨm B'ɨgam pɨlwa,” ton ma sobijog na komliu aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Seg ton ket Yesund yomno da, “Ke man utkundenyɨt nangga im onggɨt b'ɨgap apurenanj?” Sɨ Yesu ten esmonggainonj da, “Owɨ, ke. Rɨngma, ma wɨn maka yɨna peband yogenkonda odede yɨtkak? Sɨ yɨna pebat yindeny da, ‘Ma Man kea Mornɨm angonjeninot b'ɨga sobijog dɨde papa b'ɨga waina tugɨm ke esourena ger ɨtangam?’” ");
INSERT INTO gdr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Seg ket Yesu ten erarinonj dɨde ket opendonj taun bau wa. Ɨ Ton ket yikonj Betaniya tungg wa dɨde ademb de ket yɨpa yɨt wegonj. ");
INSERT INTO gdr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ɨ ɨspari ke ket sɨtawarjogɨnd re Yesu ɨtendonj Yerusalem taun wa, nyawɨnd Ton ket kea owoupa awonj. ");
INSERT INTO gdr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Sɨ re Yesu yɨr yongonj yɨpa pig wul nya yurund, ɨ Ton ket demb de yikonj onggɨt pig wul mop wa. Ajɨ Ton makwa nangga pig kɨp na yɨr anginonj onggɨt pig wul nanggɨm pɨlɨnd ajɨ ɨna rom nena wekenonj. Ɨ Ton ket ɨtemb wul nangg yomnonj da, “Man kɨp kesa e ngɨrpu kesa mɨtɨbnenenyɨt.” Seg odenja ɨtemb pig wul nangg yarɨmɨt yokatonj. ");
INSERT INTO gdr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ɨ re b'auyaena rɨgap ɨtemb mɨle yɨr yongo, ton ma sobijog na kɨd kesa aukɨto. Sɨ ton ket Yesund yɨgekito da, “Rɨdede nya kena ɨtemb pig wul odenja yarɨmɨt yokas?” ");
INSERT INTO gdr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ɨ Yesu ket ten esmonggainonj da, “Kon ɨmɨnjog wen tamninyɨn da rada wa opima gar ke utkunda dɨde maka ra nony nɨmognɨmog taenindam, sɨ wɨn ma odede mɨle nena im tamnɨkindam rɨnte re onggɨt pig wul nanggɨm pɨlɨnd awɨk, ajɨ daka kwa wɨn rɨrɨr im tendenindam onggɨt dorɨm pɨlwa da ‘Man b'uromate dɨde molenggyam b'ɨskante de sɨpa wa,’ sɨ ɨta tawɨk. ");
INSERT INTO gdr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ɨ ra wɨn gar ke utkunda oramisya Godɨm pɨlwa dɨde nanggamog mana ra wɨn b'ɨgekena oramitenya yɨr opmita ke, sɨ wɨn opima takasindam.” ");
INSERT INTO gdr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ɨ re Yesu b'ɨgaronj yɨnamet aba wa dɨde ket rɨga auyaeninonj, odedend ket yɨna mopyam sɨ rɨga dɨde Ju rɨga waina elda rɨga tuwonj Ti pɨlwa. Ɨ ton ket Yesund yerkito da, “Man nangga juwai kaim onggɨtyam gasa amnɨkinyɨt? Ɨ yet mor onggɨtyam juwai mokawonj?” ");
INSERT INTO gdr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ɨ Yesu ket ten mɨra amninonj da, “Kodaka yɨpa yɨt gatab e wen tarkisinyɨn. Ra wɨn mɨra notɨnya, sɨ onggɨt kak kaim Kodaka wen wumɨr tamninyɨn nangga juwai kaim kon onggɨtyam gasa amnɨkinyɨn. ");
INSERT INTO gdr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wɨn wumɨr nomna! Rɨngma, rɨngkae Yoanɨmna baptiso ikonj, rɨka Godɨm pɨlkae o mɨnda rɨka rɨga wa pɨlkae?” Sɨ ket ton towa wɨngɨrɨnd yɨt b'ɨglenena wuwenonj da, “Ra men mɨra omnyu da ‘Godɨm pɨlkae,’ sɨ ton opima netɨrkisiny dor da, ‘Sɨ wɨn nangga pena maka Yoanɨmna baptiso gatab gar ke utkunda ke yokatonda?’ ");
INSERT INTO gdr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ajɨ ra men jaba nitinjindam da, ‘Rɨga wa pɨlkae,’ sɨ men rɨga bobo im moga uwajindam. Mop nokɨp komkesa rɨgap Yoanɨnd ɨmɨnjog kae yokatenyi da ton re God ma yɨpa bageyam na.” ");
INSERT INTO gdr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sɨ ton ket Yesund mɨra yomno da, “Sɨn ma wumɨr im.” Ɨ Yesu daka ket ten amninonj da, “Sɨ Kodaka ma opima wen wumɨr tamninyɨn nangga juwai kaim Kon onggɨtyam gasa amnɨkinyɨn. ");
INSERT INTO gdr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Sɨ rɨja im wɨn nony taindam onggɨt yɨt gatab? Yɨpa rɨgam nɨmog b'ɨga yɨbnawonj. Ɨ ɨtemb rɨga yikonj nanyam b'ɨgam pɨlwa dɨde ket yomnonj da, ‘Kor b'ɨga! Yu man meke greip sopapu wa dɨde ket wɨko omnɨket.’ ");
INSERT INTO gdr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ɨ ton ket ti b'und mɨra yomnonj da, ‘Kon ma singi en.’ Ajɨ yɨmta kena ton gar b'engendonj, ngɨrpu ton ket yikonj greip sopapu wa. ");
INSERT INTO gdr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ɨ kwa towa b'u yikonj yɨngganyam b'ɨgam pɨlwa dɨde ket tida kwa ɨja na yɨt yomnonj rɨja na re nanyamɨnd yɨt yomnonj. Sɨ ɨtemb yɨngganyam b'ɨga mɨra yomnonj da, ‘Abu, kon ɨta neken.’ Ajɨ ton maka yikonj. ");
INSERT INTO gdr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Sɨ rɨngma, osiemb nɨmog nanyɨnggan wa wɨngɨrɨnd yet towa b'uɨmna singi yomnɨkonj?” Sɨ ton mɨra yomno da, “Nanyamyamɨt.” Seg Yesu ten amninonj da, “Kon wen ɨmɨnjog tamninyɨn da teks imdayam dɨde yiyagyiyag iyenapu kongga ton opima God ma pumb tungg wa b'ɨgarena wuweny wa wɨpɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mop nokɨp re baptiso Yoan negɨr kesa dɨmdɨmjog nya ouyawam ikonj wa pɨlwa, sɨ wɨn maka tin gar ke yokatonda, ajɨ teks imdayam dɨde yiyagyiyag iyenapu kongga, tonpiya tin gar ke yokateno. Ɨ nangga ma jɨ da wɨn kea towaina engenda mɨle yɨr ongong yiyenonda, ajɨ wɨn makaima waina gar b'engenjindam Godɨm pɨlwa dɨde tin gar ke utkunda ke yokatenya. ");
INSERT INTO gdr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Wɨn kwa utkunda yɨpa tendam yɨt! Yɨpa gou yonggyam yɨbnonj. Sɨ ton ket greip nangg ɨtot eyeninonj tina gowɨnd, ɨ sopapund kotal eror yiyenonj, ɨ greip kɨp ungka gasa oramitam kip yoskonj, ɨ dɨde sopapu yɨr ɨpkam yɨpa pumbpumb met yorangonj. Seg re ket ton nɨnda sopapu wɨko rɨga kɨma yɨtnono aento dɨde tɨrɨr yomno da, ‘Ra kɨp wɨn okas dem, yonggyam opima sopapu mɨra greip kɨp takasiny dem.’ Yɨt seg ke ton ket sopapu towa akainonj dɨde menon yokatonj b'enga kantri wa. ");
INSERT INTO gdr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sɨ re greip kɨp wɨn wus wa auka ikonj, ɨtemb yonggyam tina wɨko rɨga etmɨkisinonj opimemb sopapu wɨko rɨga wa pɨlwa mɨra greip kɨp okatam. ");
INSERT INTO gdr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ɨ sopapu wɨko rɨgap yonggyamɨmna wɨko rɨga emdɨto, seg ton ket yɨpa yipowo, ɨ yɨpa yongando ɨ dɨde yɨpa gɨmo ke uj tama na yɨdrɨko. ");
INSERT INTO gdr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sɨ yonggyam kwa b'usaya jogjog b'enga wɨko rɨga etmɨkisinonj ajɨ ma odede rɨga pɨs na ɨt re naska re dɨde. Ajɨ sopapu wɨko rɨgap kea ɨja na yɨpa wɨp ke opimemb wɨko rɨga omnɨka eyento rɨja na re naska re dɨde. ");
INSERT INTO gdr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Seg ɨtemb Yonggyam kikitum tinajog b'ɨga yɨtmɨkitonj towa pɨlwa odede nony kɨma da, ‘Ton opima koina b'ɨgand ɨsnai dem.’ ");
INSERT INTO gdr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ajɨ re onggɨt sopapu wɨko rɨgap towa yonggyamɨmna b'ɨga yɨr yongo, ton towalenggyam apurento da, ‘Ɨtemb b'ɨga re tina sopapu owabɨnta rɨga e. Sɨ b'ogɨl e, men tin yangandu. Ɨ men ɨdenatemb ket ɨtemb sopapu okasu rɨnte ra ton owabɨnjis.’ ");
INSERT INTO gdr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Seg ton ket tin yokato dɨde ket yɨskanto greip sopapu bau wa, ngɨrpu uj tama na yongando. ");
INSERT INTO gdr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Sɨ onggɨt paemb ra ket ɨtemb greip sopapu yonggyam ik, nangga e ket ton omnɨk onggɨt sopapu wɨko rɨga wa pɨlwa?” ");
INSERT INTO gdr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ɨ ton Yesund mɨra yomno da, “Ra ɨtemb yonggyam ik dem, ton opima onggɨt negɨrjog sopapu wɨko rɨga nenegɨr kana uj tandrɨkiny dem. Seg ton ket kwa greip sopapu takainy dem b'enga sopapu wɨko rɨga wa yepim ra b'obogɨl sopapu mɨra greip kɨp ti ogonenenanj ita erngoka wɨnɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ɨ ket Yesu ten amninonj da, “Ma wɨn maka odede yɨtkak agenkɨtondam yɨna peband, ɨte re da, ‘Yɨpa Motɨr, met oranga rɨgap b'ɨsayo met orangam, ajɨ God ket yɨmta ke met wugɨnd yoramitonj onggɨt met emorkam. Sɨ Ton ket ɨmɨnjog ɨsnawa kɨma Motɨr na awonj onggɨt met oranga wɨngɨrɨnd. Ɨ ɨtemb re Yonggyam Godɨm pɨlkaemb jɨ aukonj, sɨ kwa ɨtemb re otomantijog na aukonj mera yɨrɨnd'? ");
INSERT INTO gdr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Sɨ onggɨt paemb Kon wen tamninyɨn da God ɨta wa pɨlke Tina pumb tungg ewaikis dem, dɨde ket Ton ɨta ɨtemb Tina pumb tungg takainy dem yɨpa b'enga bobo rɨga wa yepiya ra onggɨt Tina pumb tungg rɨrɨrɨnd gar ke utkunda mɨle omnɨka teyenanj. ");
INSERT INTO gdr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Sɨ yet ra sap totenj onggɨt Motɨr kumbɨnd, ton ɨta kak tiposɨk. Ɨ ya kumb nat ra ɨtemb Motɨr sap totenj, onggɨt Motɨrɨt ɨta tin ɨimɨk dem.” ");
INSERT INTO gdr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sɨ opimemb yɨna mopyam sɨ rɨgap dɨde Parisai rɨgap Yesumna tendam yɨt utkundeno, ton kea nony aukɨto da, “Ton sɨna tendam yɨt ke nomneniny.” ");
INSERT INTO gdr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Sɨ opimemb Ju rɨga waina wɨp iyoi rɨgap singi aukɨto Yesund yɨmɨnd okatam. Ajɨ ton rɨga bobo na moga uwadto, mop nokɨp komkesa rɨgap Yesund ɨmɨnjog kena yokateno da, “Ton re God ma yɨpa bageyam e.” ");
INSERT INTO gdr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ɨ Yesu b'usaya tendam yɨt rɨga wa usekainonj da, ");
INSERT INTO gdr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Sɨ pumb tungg re yɨpa wɨp e odede yɨpa king kɨma yet re ti b'ɨgamna molkongga omnam ukoi diyamdiyam yongonjenonj. ");
INSERT INTO gdr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ɨ ɨtemb king tina wɨko rɨga etmɨkeninonj ara emokam yama na re ton naska yɨt etmɨkenainonj obai omnam onggɨt diyamdiyampu wa, ajɨ ton maka singi aukɨto demb de menonɨm. ");
INSERT INTO gdr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Sɨ ton kwa b'usaya ket nɨnda b'enga wɨko rɨga etmɨkeninonj odede yɨt kɨma da, ‘Wɨn onggɨt ɨngauki rɨga wa odede yɨt tusekaindam yama na re kon naska yɨt etmɨkenainond da, “Yɨr de, koina diyamdiyam re ongonjeni e yɨbɨm, sɨ kon kea leoyam dɨde mogyatyam gayagaya kau agninyɨn dɨde komkesa gasa kea angonjeninyɨn. Sɨ tuyɨt onggɨt molkongga omna diyamdiyampu wa.” ’ ");
INSERT INTO gdr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ajɨ opimemb tina ɨngauki rɨgap yɨg nony na aento. Sɨ yɨpa yikonj tina sopapu wa, ɨ daka yɨpa yikonj re tina wɨkopu wa wulkɨp omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ɨ opimemb nɨnda komb ɨngauki rɨgap onggɨt kingɨmna wɨko rɨga yɨmɨnd usunatto dɨde ket nenegɨr kana ipowa eyento, ngɨrpu uj andrɨkto. ");
INSERT INTO gdr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Sɨ ɨtemb king ma sobijog na soro awonj, ɨ ket tina geja rɨga etmɨkisinonj. Seg onggɨt geja rɨgap kea ket opimemb ɨngauki rɨga nenegɨr kana uj ondrɨka eyento yepiya re kingɨmna wɨko rɨga uj andrɨkto, dɨde ket towaina taun kupkakupka so omnɨka eyenawo. ");
INSERT INTO gdr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Seg ɨtemb king tina wɨko rɨga amninonj da, ‘Molkongga omna diyamdiyam re ongonjeni e yɨbɨm, ajɨ yama na re kon naska yɨt etmɨkenainond obai omnam, ton re ket makwa rɨrɨrkɨpjog im onggɨt diyamdiyampu wa menonɨm. ");
INSERT INTO gdr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Sɨ onggɨt paemb wɨn wuwene sobea dedag nata rokasim re jogjog rɨga wekeny, dɨde ket wɨn ɨngaukam rɨga odarka teyenindam. Ɨ ra ket wɨn rɨga tadarkindam ɨngaukam, sɨ wɨn ket ten ara emoka teyenindam onggɨt molkongga omna diyamdiyampu wa.’ ");
INSERT INTO gdr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Seg ket opimemb wɨko rɨga wuwenonj sobea nata, ɨ ket komkesa negɨrjog rɨga dɨde b'ogɨl rɨga adarkɨto, ɨ dɨde ket opimemb rɨga bobo omnɨka eyento yena re ton adarkɨto. Seg re ton opimemb ɨngauki rɨga teito de molkongga omna diyamdiyampu wa. Sɨ opimemb diyamdiyampu kasa re kea yɨndangɨrjog aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ajɨ re ɨtemb king b'ɨgaronj diyamdiyampu wa ɨngauki rɨga ɨtapnenam, sɨ ton ademb ket yɨpa rɨga yɨr yongonj yet re maka molkongga omna diyamdiyampu wa menonɨm rɨrɨrkɨpjog kobɨrgɨm b'ikokonj. ");
INSERT INTO gdr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Sɨ onggɨt kingɨt tin yɨgekitonj da, ‘Kor rɨga! Man maka molkongga omna diyamdiyampu wa menonɨm rɨrɨrkɨpjog kobɨrgɨm b'ikisɨt. Sɨ rɨdede nya kena man b'ɨgaret dɨkɨnd?’ Ajɨ ɨtemb rɨga re yɨt kesa na tu b'ɨpmɨnti yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Seg ket ɨtemb king diyamdiyam ongonjena rɨga amninonj da, ‘Ɨtemb rɨga yɨm ake pɨs yɨjobɨka. Ɨ ket tin bau wa yɨska de sɨbɨb pɨpmet wa rokasim re rɨga yii kamil b'iyowa wuweny dɨde kopa b'angnena kɨma or b'ɨinɨka wuweny.’ ");
INSERT INTO gdr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sɨ pumb tungg gatab toda ɨja emb jɨ da God jogjog rɨga im ɨngauka eyeniny, ajɨ ma jog rɨga im obagɨka eyeniny pumb tungg wa b'ɨgarkam.” ");
INSERT INTO gdr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Seg ket Parisai rɨgap ɨtemb pɨpmet yɨraro ɨ ket yɨt ɨsamka yiyeno, nokɨm da ɨdenat ton b'anygɨnena nya ke Yesumna negɨr yɨt okasi dɨde onggɨt Tina yɨt ke Tin negɨr omnyi. ");
INSERT INTO gdr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ɨ re ton ɨsamka seg yomno, ton ket towaina b'auyaena rɨga yɨpand nɨnda Erodɨmna yɨmta undoka rɨga kɨma etmɨkurto Yesum pɨlwa odede yɨt kɨma da, “Ouyaena rɨga! Sɨn wumɨr im da Man ɨmɨnjog rɨga et, dɨde Man God ma nya nena im ɨmɨnjog auyaeninyɨt. Ɨ Man makwa ɨta yena moga yuwadenenyɨt. Mop nokɨp Man makwa gɨm kaim rɨga wa pɨlɨnd bu b'iyena mɨle amnɨkeneninyɨt ajɨ komkesa rɨga yɨpa rɨrɨrkɨp im dɨmdɨm amnɨkeneninyɨt. ");
INSERT INTO gdr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Sɨ onggɨt paemb be Man sɨn wumɨr nomnine. Sɨ rɨngma, Roma kantri mopyam king Kaisam teks ogonam, ton b'ogɨl e o ma b'ogɨl e?” ");
INSERT INTO gdr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ajɨ Yesu kea towaina nenegɨr ɨsamki mɨle wumɨr awonj, sɨ ten amninonj da, “Wɨn gɨm ke b'ogɨl ajɨ ngor wa negɨr rɨga! Nangga pae wɨn negɨr nya ke Ken otonkena niyenya? ");
INSERT INTO gdr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wɨn Kor yɨpa koin nouyawa rɨnte re wɨn teks oramitam yiyenenya!” Sɨ ton ket yɨpa Roma kantri wulkɨp, Denari koin Yesum itiyawo. ");
INSERT INTO gdr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Seg ket Yesu ten arkisinonj da, “Yaina wɨp e dɨde nyɨ e ɨrɨki i jɨ onggɨt wulkɨpɨnd?” ");
INSERT INTO gdr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ɨ ton ket mɨra yomno da, “Roma kantri mopyam king Kaisamna i.” Seg ket Yesu ten amninonj da, “Sɨ onggɨt paemb wɨn Kaisam ogonindam nangga im re Kaisa ma ogenaya gasa, ajɨ Godɨm ogonindam nangga im re God ma ogenaya gasa.” ");
INSERT INTO gdr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ɨ re opimemb rɨga onggɨtyam yɨt utkundento, ton ma sobijog na kɨd kesa aukɨto. Ɨ ton ket Yesund yɨraro dɨde ket dea ta wuwonj. ");
INSERT INTO gdr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ɨ ɨtaemb onggɨt bibɨrɨnd, Sadukai rɨga tuwonj Yesum pɨlwa yepiya re apurenento da, “Rɨga ma opima uj ke tutnɨkanj dem.” Ɨ ton ket Yesund yerkito da, ");
INSERT INTO gdr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ouyaena rɨga! Mose yindeny da, ‘Ra yɨpa rɨga uj tainy dɨde ti konggand tɨrar b'ɨga oraki kesa, ti nanyɨt o ti yɨngganɨt tokas ɨtomb mik ɨ ti nanyɨmna o ti yɨngganɨmna nyɨ kɨma im b'ɨga tarakiny.’ ");
INSERT INTO gdr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Sɨ kea dɨkɨnd sowa wɨngɨrɨnd nɨnda seben (7) nanyɨngganwar wekenonj. Ɨ nanyam rɨgat yɨpa kongga wokatonj ɨ ket uj awonj. Ajɨ ton maka b'ɨga arakinonj dɨde ket tina mik wɨraronj ti yɨngganɨm okatam. ");
INSERT INTO gdr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Sɨ todaka ɨja na yɨpa wɨp nya ke nɨmogɨm b'ɨga awonj, ɨ dɨde kwa dɨdea nowam b'ɨga awonj ngɨrpu ama re sebenɨm (7) b'ɨga wa. ");
INSERT INTO gdr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Seg ket kikitumjog ɨtomb kongga todaka uj awonj. ");
INSERT INTO gdr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Sɨ onggɨt paemb ra uj rɨga wa utnyita wɨn ik dem, ɨtomb kongga onggɨt seben (7) nanyɨngganwar wɨngɨrɨnd yama ɨmɨnjog kongga tainy dem? Mop nokɨp komkesa seben (7) nanyɨngganwarɨp kea ɨtomb kongga towa konggam b'ɨsatena tiyo.” ");
INSERT INTO gdr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Sɨ Yesu ket ten mɨra amninonj da, “Wɨn yɨna peba dɨde kwa daka Godɨmna danda ma wumɨr im wekenyɨt, sɨ onggɨt paemb wɨn uj ke utnyita gatab negɨr nya kae wumɨr yokatenya. ");
INSERT INTO gdr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mop nokɨp ra utnyita wɨn ik dem, rɨga ma opima kongga okata mɨle dɨde leo okata mɨle tamnɨkanj dem, ajɨ ɨja imemb jɨ tekeny dem rɨngmim re aneru wekeny pumb tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Sɨ rɨngma, ma wɨn maka yɨna peband agenkɨtondam onggɨt uj rɨga utnyita gatab yɨt rɨna re God wumɨr amninonj odede da, ");
INSERT INTO gdr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Kon re Abraamɨmna God en, ɨ Isakɨmna God en, ɨ dɨde Yakobɨmna God en'? Ɨ opimemb rɨga re yilo im wekeny de pumb tunggɨnd. Sɨ God re ma uj rɨgaina God e ajɨ yilo rɨgaina God e.” ");
INSERT INTO gdr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Sɨ re rɨga bobop ɨtemb yɨt utkundeno, ton ma sobijog na kɨd kesa aento Tina ouyaena gatab. ");
INSERT INTO gdr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ɨ re Sadukai rɨgap uj ke utnyita gatab yɨt utkundento Yesum pɨlke, ton kea yɨt kesa aukɨto. Ɨ re Parisai rɨgap utkundo odede yɨdɨr yɨt da Yesu kea Sadukai rɨga yɨt kesa amniny, sɨ opimemb Parisai rɨgap kea ton nena b'eomto. ");
INSERT INTO gdr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ɨ ket Parisai rɨga wɨngɨrɨnd yɨpa gog yɨt wumɨrjog rɨgat Yesund yotonkenonj odede b'arkita kɨma da, ");
INSERT INTO gdr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ouyaena rɨga! Komkesa gog yɨt wɨngɨrɨnd rɨnggɨtyam e ukoijog b'ingawa yɨt yɨbɨm?” ");
INSERT INTO gdr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ɨ ket Yesu mɨra yomnonj da, “‘Man moina Yonggyam Godɨnd singi yiyene moina kupkakupka kɨd ke, ɨ moina kupkakupka wɨngawɨnga ke, ɨ dɨde moina kupkakupka nony ke!’ ");
INSERT INTO gdr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sɨ ɨntemb jɨ ukoijog dɨde naskajog b'ingawa yɨt yɨbɨm. ");
INSERT INTO gdr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ɨ ket nɨmogɨm b'ingawa yɨt ɨntemb jɨ da man singi yiyene mor rɨgand mada re dɨde! ");
INSERT INTO gdr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sɨ komkesa gog yɨt dɨde bageyam waina yɨt b'atomkanj re osiemb nɨmog b'ingawa yɨt kai.” ");
INSERT INTO gdr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ɨ re Parisai rɨga b'eomto yɨpand, Yesu ket ten arkisinonj da, ");
INSERT INTO gdr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Wɨn rɨdede im nony aindam Kerisom gatab? Sɨ Ton yaina b'ɨga e?” Ɨ ket Parisai rɨgap Tin yɨsmonggawo da, “Sɨ Ton re Yonggyam Dawidɨmna B'ɨga e.” ");
INSERT INTO gdr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Seg Yesu ten amninonj da, “Sɨ re Yɨnayɨna Wɨngawɨnga b'imuronj Dawidɨm pɨlɨnd yɨt opurenam, ton kea odede yindonj da, ‘Yonggyam God yindeny kor Yonggyamɨm pɨlwa da, “Omite Koina yɨmjog yɨm tab ke juwai kɨma pɨpmetɨnd, ngɨrpu ra ket Kon Moina komkesa geja rɨga gou wa tamninyɨn dem dɨde taramisinyɨn dem Moina pɨs wɨrand Moina danda ondratenam towa kumbɨnd!” ’ Sɨ rɨdede pena Dawid ti Yonggyam ke Kerisond yogenayonj? ");
INSERT INTO gdr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Sɨ onggɨt paemb rada Dawid kea Kerisond ukoijog nyɨ ke yogenayonj da ‘Kor Yonggyam’, sɨ rɨdede nya kae Keriso Dawidɨmna b'ɨga tainy? Sɨ Ton re Dawidɨmna B'ɨga e ajɨ kwa ti Yonggyam e.” ");
INSERT INTO gdr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Seg makwa yɨpa rɨgat ket rɨrɨr na awonj Tin yɨt ɨsmonggaenam. Sɨ onggɨt bibɨr kenaemb ket makwa ngai yɨpa rɨgat moga kesa aenonj Tin erkenam. ");
INSERT INTO gdr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Seg ket Yesu rɨga bobo dɨde Tina b'auyaena rɨga amninonj ");
INSERT INTO gdr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","odede da, “Ju rɨga waina gog ouyaena rɨgap dɨde Parisai rɨgap Mosemna gog yɨt ouyaena eyenanj re Godɨmna juwai okai rɨga pɨla im. ");
INSERT INTO gdr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Sɨ onggɨt paemb wɨn b'ogla komkesa towaina yɨt rɨrɨrɨnd b'itngaenindam dɨde yɨmta tundokindam nangga mana ra ton wen tamnenanj. Ajɨ goro towaina omnɨka mɨle rɨrɨrɨnd tamnɨkenenindam. Mop nokɨp ton re opurena nena im amnɨkenenanj ajɨ ma opima towaina opurena rɨrɨrɨnd mɨle amnɨkenenanj. ");
INSERT INTO gdr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ɨ kwa ton bebɨgbebɨg gog yɨt amnɨkenenanj dɨde ket rɨga wa pɨlwa oramka eyenenanj yɨmta undokam. Ajɨ ton towalenggyam re ma opima singi aukenenanj towaina yɨmkurup ingaenam opimemb towaina omnɨki gog yɨt yɨmta undokam. ");
INSERT INTO gdr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ajɨ ton komkesa wɨko amnɨkenenanj re nok mim da ɨdenat rɨgap ten yɨr tangranj. Mop nokɨp ton moppet boks dɨde yɨmpet boks ukoi im omnɨka eyenanj rokasim re onggɨt borand nɨnda yɨna peba yɨtkak wekeny, ɨ ton towaina yɨr opmitena kobɨrgɨm pɨnpɨn omnɨka eyenanj rɨga wa ouyawam da ton re Godɨm pɨlwa kupkakupka yɨrkokar b'akai rɨga im. ");
INSERT INTO gdr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ɨ kwa daka ton opima ukoi singi aukenenanj ukoijog ɨsnawa kɨma pɨpmet okatenam ukoi diyamdiyampu pɨpmet nata dɨde kwa wɨp ke ukoijog rɨgaina pɨpmetɨnd omitenam meraina yɨr opmitenapu met nata. ");
INSERT INTO gdr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ɨ dɨde kwa ton opima ukoi singi aukenenanj ukoi ɨsnawa kɨma simesime okatenam maket nata dɨde kwa da rɨgap ten ukoi nyɨ rɨga ke ogenaya teyenanj da ‘Ouyaena Rɨga'. ");
INSERT INTO gdr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ajɨ goro wen odede ukoi nyɨ rɨga ke ragenaine da ‘Ouyaena Rɨga', mop nokɨp wa ɨnta yɨpaina nena Ouyaena Rɨga ajɨ wɨn komkesa re gar ke utkunda ke nanyɨngganwar im. ");
INSERT INTO gdr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ɨ kwa goro wɨn yɨpa rɨgand wa b'u ke ogenaya onggɨt gowukoyɨnd, mop nokɨp wa ɨnta yɨpaina nena B'u ebnau yete re pumb tungg wa yɨbɨm. ");
INSERT INTO gdr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ɨ dɨde goro kwa rɨgap wen odede nyɨ ke ragenaine da Mopyam Ouyaena Rɨga, mop nokɨp wa ɨnta yɨpaina nena mopyam ouyaena rɨga, ɨte re Keriso. ");
INSERT INTO gdr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Sɨ wa wɨngɨrɨnd ukoyam re wanɨm wɨko rɨga e. ");
INSERT INTO gdr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ɨ yet ra tilenggyam pumb wa b'uturowateny, God ɨta tin gou wa omneny. Ɨ kwa yet ra tilenggyam gou wa aena ikeny, God ɨta tin pumb wa urowateny. ");
INSERT INTO gdr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ju rɨga waina gog ouyaena rɨga dɨde Parisai rɨga! Wɨn re gɨm ke b'ogɨl ajɨ ngor wa negɨr mɨle rɨga im. Sɨ God ma sake wɨn kɨma. Mop nokɨp wɨnte rɨga wa wɨp ke mora utwangka yiyenya rɨga wa b'ɨgarenam de pumb tungg wa. Sɨ wɨda walenggyam makwa opima b'ɨgarena wuwenyɨt dɨde kwa wɨn makwa opima enjɨkenindam rɨga yepim re singi aenanj demb de b'ɨgarenam. ");
INSERT INTO gdr_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Awɨr e) ");
INSERT INTO gdr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ju rɨga waina gog ouyaena rɨga dɨde Parisai rɨga! Wɨn re gɨm ke b'ogɨl ajɨ ngor wa negɨr mɨle rɨga im. Sɨ God ma sake wɨn kɨma. Mop nokɨp wɨn sɨpa wa dɨde gɨl wa wuwenenyɨt re yɨpayɨpa rɨga ɨl ongka mim waina ouyaena yɨmta undokam, ɨ yena ra wɨn odarya, sɨ wɨn ket waina ouyaena nya kae tin ukoijog negɨr mɨle rɨgam yomnɨkenenya ukoijog b'ɨdgotnena okatenam de wul tungg wa ajɨ wɨn re ma ngai odede b'ɨdgotnena e okatenya dem ton re dɨde. ");
INSERT INTO gdr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ɨ kwa wɨn re yɨrdɨdɨ wang iyena rɨga im. Sɨ God ma sake wɨn kɨma. Mop nokɨp wɨn rɨga auyaenenindam da, ‘Yet ra danda kɨma tɨrɨr yɨt opulis yɨnamet nyɨ kɨma, ɨtemb re makwa nangga gog e yɨbɨm. Ajɨ yet ra danda kɨma tɨrɨr yɨt opulis yɨnametɨmna gold nyɨ kɨma, ɨtemb re ɨmɨnjog gog e yɨbɨm.’ ");
INSERT INTO gdr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Wɨn korɨrkorɨr im dɨde yɨrdɨdɨ rɨga im. Sɨ rɨnte ukoijog yɨbɨm, gold e o mɨnda yɨnamet e? Ma sɨ ma yɨnamette ɨtemb gold yɨnam yomnɨkeneny? ");
INSERT INTO gdr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ɨ kwa wɨn ɨja emb jɨ rɨga auyaenenindam da, ‘Yet ra danda kɨma tɨrɨr yɨt opulis yɨna sɨ omnɨkapu kap nyɨ kɨma, ɨtemb re makwa nangga gog e yɨbɨm. Ajɨ yet ra danda kɨma tɨrɨr yɨt opulis Godɨm sɨ gasa nyɨ kɨma, ɨtemb re ɨmɨnjog gog e yɨbɨm.’ ");
INSERT INTO gdr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wɨn yɨrdɨdɨ rɨga, sɨ rɨnte ukoijog yɨbɨm, Godɨm sɨ gasa e o mɨnda yɨna sɨ omnɨkapu kap e? Ma sɨ ma ɨtemb yɨna sɨ omnɨkapu kapte komkesa sɨ gasa yɨnam amnɨkeneniny? ");
INSERT INTO gdr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Sɨ onggɨt paemb yet ra danda kɨma tɨrɨr yɨt opulis yɨna sɨ omnɨkapu kap nyɨ kɨma, sɨ ton danda kɨma tɨrɨr yɨt yopulis re ma yɨna sɨ omnɨkapu kap nyɨ kɨma nena e ajɨ daka kwa komkesa gasa nyɨ kɨma im rɨnsim re wekeny onggɨt yɨna sɨ omnɨkapu kap kumbɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ɨ kwa yet ra danda kɨma tɨrɨr yɨt opulis yɨnamet nyɨ kɨma, sɨ ton danda kɨma tɨrɨr yɨt yopulis re ma yɨnamet nyɨ kɨma nena e ajɨ daka kwa tina nyɨ kɨma e yete re wɨmena yikeny yɨnametɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ɨ kwa daka yet ra danda kɨma tɨrɨr yɨt opulis pumb tungg nyɨ kɨma, sɨ ton danda kɨma tɨrɨr yɨt yopulis re ma Godɨmna wɨp omnenapu kasa nyɨ kɨma nena e ajɨ daka kwa tina nyɨ kɨma e yete re onggɨt wɨp omnenapu kasand omiti yɨbɨm. ");
INSERT INTO gdr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ju rɨga waina gog ouyaena rɨga dɨde Parisai rɨga! Wɨn re gɨm ke b'ogɨl ajɨ ngor wa negɨr mɨle rɨga im. Sɨ God ma sake wɨn kɨma. Mop nokɨp wɨn odede sobijogjog gasa nena im ten (10) ɨkalki wɨngɨrɨnd yɨpa tab Godɨnd wulpok yomnɨkenenya, opi re b'eag, wɨngarom o kɨma, ajɨ wɨn odede gog yɨtɨmna ukoijog b'ingawa yɨt im nony ke ewaenenindam, opi re komkesa rɨga yɨpa rɨrɨrkɨp omnɨka mɨle, rɨga kear omna mɨle, ɨ dɨde nony b'ɨjawa mɨle. Sɨ wɨn b'ogla opimemb b'ingawa yɨt b'obogɨl tamnɨkenenindam ajɨ goro nony ke tewaenenindam! ");
INSERT INTO gdr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Wɨn yɨrdɨdɨ wang iyena rɨga, sɨ wɨn God ma sobijogjog yɨtkak im yɨmta undokenenindam odede wɨp im rɨngmim re rɨgap kapo bora ke ngemba b'ɨga apekenenanj nyɨ onayam, ajɨ God ma ukoijog yɨt im nony ke ewaenenindam odede wɨp im rɨngmim re rɨgap kapo borand ukoi b'angga kamel kupka emkurenenanj. ");
INSERT INTO gdr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ju rɨga waina gog ouyaena rɨga dɨde Parisai rɨga! Wɨn re gɨm ke b'ogɨl ajɨ ngor wa negɨr mɨle rɨga im. Sɨ God ma sake wɨn kɨma. Mop nokɨp wɨn gɨm ke mɨle im b'obogɨl amnɨkenenindam odede wɨp rɨngmim re rɨgap kapo ake dɨsi bau ke b'obogɨl esekenenanj, ajɨ waina gar re nonygor mɨle dɨde negɨrjog mɨle ke yɨndangɨr im wekeny. ");
INSERT INTO gdr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wɨn yɨrdɨdɨ Parisai rɨga! Wɨn naska waina kapo kuwar b'obogɨl esekinam, sɨ ɨngkaimemb ket bau ke todaka kwa kɨlkesa taukanj. ");
INSERT INTO gdr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ju rɨga waina gog ouyaena rɨga dɨde Parisai rɨga! Wɨn re gɨm ke b'ogɨl ajɨ ngor wa negɨr mɨle rɨga im. Sɨ God ma sake wɨn kɨma. Mop nokɨp wɨn re odede b'obogɨl ɨspɨki gopmet pɨla rɨga im rɨnsim re bau ke b'obogɨl pɨtakɨpɨnd kɨlkesa wekeny, ajɨ wɨngɨr ke re yɨndangɨr im wekeny uj rɨgaina kak ke dɨde ɨtkɨki ujgɨm ke. ");
INSERT INTO gdr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sɨ wɨdaka re odede yɨpa wɨp nya kaim rɨga wa wɨpɨnd gɨm ke pɨta aukenenindam negɨr kesa dɨmdɨmjog rɨga pɨla, ajɨ wɨngɨr ke waina gar re yɨndangɨr im wekeny gɨm ke b'ogɨl ajɨ ngor wa negɨr mɨle ke dɨde nenegɨrjog mɨle ke. ");
INSERT INTO gdr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ju rɨga waina gog ouyaena rɨga dɨde Parisai rɨga! Wɨn re gɨm ke b'ogɨl ajɨ ngor wa negɨr mɨle rɨga im. Sɨ God ma sake wɨn kɨma. Mop nokɨp wɨn opima bageyam wa b'ogɨl gopmet arangkaenenindam dɨde negɨr kesa dɨmdɨmjog rɨgaina gopmet ɨsnawa kɨma b'obogɨl ajgenenindam nɨnda gasa ke. ");
INSERT INTO gdr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ɨ wɨn odede endenenindam da, ‘Rako sɨn wekenond onggɨt wɨnɨnd re sowa b'uwar wekenonj, sɨn ma rako yɨpand b'ingautondam bageyam rɨga uj ondrɨkam.’ ");
INSERT INTO gdr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sɨ wɨn odede yɨt ke kea walenggyam b'agenaindam da wɨn re towaina b'ɨgawar im yepiya re bageyam uj ondrɨka eyento. ");
INSERT INTO gdr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Sɨ wɨdaka wa b'uwar waina tondon rɨrɨrɨnd odede negɨrjog mɨle yundwata! ");
INSERT INTO gdr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Wɨn opimemb gɨrem, wɨn re negɨr guda kɨma gɨremɨmna b'ɨgawar im. Sɨ wɨn makwa rɨrɨr im b'ɨtkenindam dem Godɨmna b'ɨsagɨkam pɨlke rɨnsim ra wen teskokiny de wul tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Sɨ onggɨt paemb Kon opima nɨnda bageyam ɨ b'ogɨl multekɨp rɨga ɨ dɨde ouyaena rɨga tetmɨkeninyɨn dem wa pɨlwa. Sɨ wɨn opima towa wɨngɨrɨnd nɨnda uj ondrɨka teyenindam dem dɨde wul b'agbagɨnd ɨdrɨka teyenindam dem, ɨ kwa wɨn opima nɨnda ɨraska teyenindam dem waina yɨr opmitenapu met nata dɨde eaukena teyenindam dem yɨpa taun ke de kwa yɨpa taun wa. ");
INSERT INTO gdr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sɨ onggɨt paemb ra Godɨmna b'ɨsagɨka wɨn ik dem, wɨn opima negɨr ma mɨra takasindam dem komkesa negɨr kesa dɨmdɨmjog rɨgaina kus map rɨna re wɨn opimemb God ma wɨko rɨga kus egmarkenentondam onggɨt gowukoyɨnd, ɨngkek negɨr kesa dɨmdɨmjog rɨga Abelɨmna kus ke ngɨrpu ama re de Barakiyomna b'ɨga Jakariyamna kus yena re wɨn yongandonda yɨnamet ake yɨna sɨ omnɨkapu kap ganggand. ");
INSERT INTO gdr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sɨ Kon ɨmɨnjog wen tamninyɨn da rɨga yepim re yu onggɨt gowukoyɨnd wekeny, ton opima onggɨtyam negɨr ma mɨra takatenanj dem God ma wɨko rɨgaina kus map. ");
INSERT INTO gdr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Oo! Yerusalem, Yerusalem! Yete re man bageyam uj ondrɨka eyeninyɨt, ɨ opimemb rɨga gɨmo ke uj ondrɨka eyeninyɨt yena re God etmɨkeniny mor pɨlwa. Leamogpyam na Kon singi miyenenyɨmɨn mor b'ɨga yɨpand kupokupo omnam odede rɨngmim ra mogyam paurot tinajog b'ɨga tama ke tuwopɨnsiny. Ajɨ man singi kesa na aukenenyɨmɨt. ");
INSERT INTO gdr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yɨr de, waina met Yonggyam, God ɨta wen terariny dem, sɨ waina met ra ket kak e ɨbɨm dem. ");
INSERT INTO gdr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ɨ Kon wen tamninyɨn da wɨn makwa ɨta ket Ken b'usaya yɨr notngya dem, ngɨrpu ra wɨn tendenindam dem da, ‘God ma b'ogɨl Ton kɨma yete re Yonggyamɨmna nyɨ kɨma ik.’” ");
INSERT INTO gdr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ɨ Yesu ket yɨnamet yɨraronj, ɨ Ton ket menon yokatonj. Sɨ dɨkɨnda Tina b'auyaena rɨga tuwonj Ti pɨlwa dɨde ket Yesund ouyawam pumam ke utmurena eyento yɨnamet dɨde nɨnda met yɨnamet aba wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ɨ Yesu mɨra amninonj da, “Wɨn opima yɨr angindam opimemb ukoijog met? Sɨ Kon ɨmɨnjog wen tamninyɨn da makwa ɨta yɨpa motɨr ɨbɨm dem dɨkɨnd onggɨt goujog motɨr kumbɨnd, komkesa onggɨtyam ukoijog motɨr opima tosmurkanj dem.” ");
INSERT INTO gdr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ɨ re Yesu Olib dorɨnd omiti yɨbnonj, Tina b'auyaena rɨga nena Ti pɨlwa tuwonj dɨde ket wɨgawɨga yerkito da, “Wumɨr nomnine! Rɨim onggɨtyam mɨle pɨta taukanj dem? Ɨ ra onggɨtyam komkesa gasa taukanj dem, nanggamog im jɨ ongwata gasa taukanj dem Moina ɨtenda wɨn gatab dɨde onggɨt gowukoi kikitum wɨn gatab?” ");
INSERT INTO gdr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sɨ Yesu ket mɨra amninonj da, “Wɨn b'obogɨl yɨr kɨma tekenyɨt! Ke rɨgap wen b'anygɨnena nya ke wɨp ramneninem. ");
INSERT INTO gdr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mop nokɨp jogjog rɨga opima tuweny dem Koina nyɨ kɨma, dɨde jogjog rɨga ugungatena teyenanj dem odede yɨt kɨma da, ‘Kon ɨtemb Keriso.’ Ɨ ton ket jogjog rɨga onggɨt b'anygɨnena nya ke wɨp tamnenanj dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ɨ ra wɨn ik dem, wɨn opima tutkundenindam dem tɨrɨba geja yɨt dɨde tɨrɨba geja gatab bage yɨt. Ajɨ wɨn yɨr kɨma na tekenyɨt dɨde goro moga taininam dem. Mop nokɨp onggɨtyam gasa opima taukanj dem, ajɨ ɨtemb re ma kikitum wɨn e. ");
INSERT INTO gdr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ɨ b'engabenga yɨtam opima gejam owɨnka tuweny dem nɨnda b'enga yɨtam kɨma. Ɨ kwa daka kantri b'engabenga opima gejam owɨnka tuweny dem nɨnda b'enga kantri kɨma. Ɨ opima ukoijog sou wɨn pɨta taukanj dem ɨ dɨde kwa opima jijɨg taukanj dem b'engabenga pɨpmetɨnd onggɨt gowukoyɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sɨ ra odede komkesa mɨle pɨta auka tuweny dem, ɨtemb re b'ɨdgotnena wɨn otomapu e. ");
INSERT INTO gdr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ɨ onggɨt wɨnɨnd ket rɨgap wen kot wa oramka teyenanj dem b'ɨdgotnena okatam dɨde wen uj ondrɨkam, ɨ dɨde kwa komkesa b'engabenga yɨtam rɨgap wen singi kesa tamnenanj dem Koina nyɨ map. ");
INSERT INTO gdr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ɨ kwa ket onggɨt wɨnɨnd jogjog gar ke utkunda rɨga opima towaina gar ke utkunda mɨle ɨrarka teyenanj dem, dɨde ket towalenggyam towalenggyam kot wa b'aramka tuweny dem ɨ towalenggyam towalenggyam singi kesa b'amnena tuweny dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ɨ kwa jogjog b'anygɨnena bageyam pɨta auka tuweny dem, ɨ ket ton opima jogjog rɨga b'anygɨnena nya ke wɨp tamnenanj dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ɨ opima nenegɨrjog mɨle b'usmurena tuweny dem, sɨ onggɨt paemb jogjog rɨgaina singi b'iyena mɨle opima ngɨmbla taukanj. ");
INSERT INTO gdr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ajɨ yepiya ra mɨmkam wɨmena tuweny ngɨrpu ama re de onggɨt gowukoi kikitum wɨn wa, ton ɨta okasi dem dadal ngɨrpu kesa yɨrkokar. ");
INSERT INTO gdr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ɨ Godɨmna wɨko rɨgap ɨta pumb tunggɨmna b'ogɨl yɨrkokar bage yɨt pɨtapɨta omnena iyenyi dem kupka gowukoyɨnd, nokɨm da ɨdenat komkesa b'engabenga yɨtam rɨgap Godɨmna yɨr ungata yɨt okatena teyenanj. Seg onggɨt wɨn natemb ket gowukoi undwatapu wɨn ik dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ɨ bageyam Daniyel kea ɨja na yopulitonj da, ‘Ɨta moga kɨma negɨrjog gasa pɨta tainy dem, sɨ ɨtemb negɨrjog gasa makwa rɨrɨr e ti wɨmenam yɨna pɨpmetɨnd.’ Sɨ yɨr de, ɨtemb negɨrjog gasa ɨta tonyis dem dɨkɨnd yɨna pɨpmetɨnd. —B'ogla ogenka rɨgat nony rawɨk— ");
INSERT INTO gdr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Sɨ onggɨt wɨnɨnd yepiya ra tekeny Yuda eriyand, wɨn dor wa na mogamoga b'ɨtkenindam dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ɨ yet ra ton wɨmenand ɨbɨm dem de met papkak kumbɨnd, ton goro kwa nanggamog gasa imdam met wɨngɨr wa b'egarɨk dem. Ton komkesa gasa nony b'edasin dem. Ajɨ ton wanakana b'ek dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ɨ dɨde yet ra wɨkond ɨbɨm dem sopapund, ton goro kwa rɨtend dem tina oramiti kobɨrgɨm okatam. Ton ɨtemb kobɨrgɨm yerar dem. Ajɨ ton wanakana b'ek dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Sɨ ukoi kear kɨma! Onggɨt wɨnɨnd dem, ngor kɨma kongga wa dɨde papa b'ɨga kɨma kongga wa pɨlɨnd opima bebɨg dem. Nokɨp ton ma rɨrɨr im wanakana b'ɨtkenanj dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Sɨ wɨn yɨr topmitenindam da ɨtemb waina b'ɨkenam wɨn goro ngɨwɨr kɨma gɨbɨljog wɨnɨnd o Ju rɨga waina wɨram dɨde yɨr opmitena bibɨrɨnd rawɨk dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sɨ ra onggɨtyam wɨn ik dem, ɨta ukoijog bebɨg kɨma b'ɨdgotnena pɨta tainy dem. Sɨ odede b'ɨdgotnena re naskand makwa ke yɨpa pɨta awonj onggɨt gowukoyɨnd God ma gowukoi otobarki otomapu ke ngɨrpu yu, ɨ kwa daka makwa ɨta pɨta tainy dem yɨmta ke. ");
INSERT INTO gdr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Rako Yonggyam maka onggɨtyam wɨn kut yomnonj, makwa rako yɨpa rɨgat yilo okas dem. Ajɨ Ton kea ɨtemb wɨn kut yomnonj Tina obagendi rɨga map. ");
INSERT INTO gdr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ɨ onggɨt wɨnɨnd ra yɨpa rɨgat wen tamneniny dem da, ‘Yɨr de, ɨte ta Keriso,’ o ‘Yɨr de, ama ta Keriso,’ sɨ wɨn goro odede yɨt gar ke utkunda ke takatenindam dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sɨ opima b'anygɨnena Keriso dɨde b'anygɨnena bageyam pɨta taukanj. Ɨ ton ukoi kɨd kesa kɨma danda wɨko dɨde moga kɨma danda wɨko tamnɨkanj dem rɨga b'anygɨnena nya ke wɨp omnenam. Ajɨ daka ton kwa opima towaina kupka danda ondratena teyenanj dem, nokɨm da ɨdenat ton b'anygɨnena nya ke God ma obagɨki rɨga daka wɨp tamnenanj b'anygɨnena nya wa. ");
INSERT INTO gdr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Sɨ yɨr kɨma, Kon naska kana im wen wumɨr amneninyɨn. ");
INSERT INTO gdr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Sɨ onggɨt paemb ra rɨgap wen tamnenanj da ‘Yɨr de, Keriso ɨta de wul kesa tungg wa,’ ajɨ wɨn goro wuyɨm! Ɨ ra kwa tamnenanj da ‘Yɨr de, Keriso ɨta de wɨngɨr wa yɨpa wɨgawɨga rum wa,’ ajɨ wɨn goro gar ke utkunda ke ɨtemb yɨt okata! ");
INSERT INTO gdr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mop nokɨp ra Rɨgamna B'ɨga tɨtenj Tina bibɨrɨnd, Ton ɨja e wɨp tainy dem rɨja e re waral opngɨndeneny ɨlemet gatab ke de kwa kemagmet gatab wa. ");
INSERT INTO gdr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Rokate ra ujgɨm ɨbɨm, yimbyak toda ɨndaima bobo taukanj. Sɨ Tina ɨtenda mɨle ra pɨta nate tawɨk dem rɨga wa yɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ajɨ onggɨt wɨnɨnd ra ɨtemb ukoijog bebɨg kɨma b'ɨdgotnena seg tainy, odenja ket, lomkongga sɨbɨb tainy dem, dɨde kwa mobiror awɨr tainy dem. Ɨ dɨde ɨki ɨsoka tuweny dem wub kumb ke, dɨde kwa danda gasa rɨnsim re pumb wa wekeny opima b'utuwongnenanj dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ɨ kwa onggɨt wɨnɨnd dem wub kumbɨnd ɨta mal pɨta tainy dem ongwatam da Rɨgamna B'ɨga kaemb ik. Sɨ odede natemb ket komkesa gowukoi b'engabenga yɨtam rɨga yii b'eagɨka tuweny dem, ɨ ton ket ɨta Rɨgamna B'ɨga yɨr iyi dem wub kumb ke menonɨnd moi kumbɨnd ukoi danda kɨma dɨde ukoi b'ogɨl ɨnyomarena kɨma. ");
INSERT INTO gdr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ɨ ket ɨtemb Rɨgamna B'ɨga ɨta ukoijog bibol ara kɨma Tina aneru tetmɨkeniny dem onggɨt gowukoi wa, ɨ dɨde Tina obagɨki rɨga bobo tamnɨkanj dem gowukoi komkesa gatab ke, gowukoi ngɨrpu ke ngɨrpu ama re wub kumb ngɨrpu wa. ");
INSERT INTO gdr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ɨ Pig wulɨm pɨlke yɨpa tendam yɨt ouyaena yokata. Sɨ yɨt ɨja emb jɨ da ra wul bɨa rɨna re rom kesa rogɨlkak wekeny gɨbɨljog wɨnɨnd, bodaboda taukanj nyɨ kɨma dɨde sisɨl wɨl tɨkkanj salsal rom kɨma, sɨ wɨn ɨngkaemb ongwasya da, ‘Kemb momta e pembpemb wɨn.’ ");
INSERT INTO gdr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Sɨ ra wɨn odede gasa yɨr tangindam dem aukand rɨnsim re Kon amneninyɨn, wɨn nony ke ongwasya dem da, ‘Rɨgamna B'ɨga ke nya nate dɨde momta e openda mora wa.’ ");
INSERT INTO gdr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ɨ Kon ɨmɨnjog wen tamninyɨn da rɨga yepim re yu onggɨt gowukoyɨnd wekeny yɨmta kaim uj taukanj dem, ajɨ naskajog onggɨtyam komkesa gasa towa liyal im taukanj dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sɨ wub ake gou osiya b'eteomnenya dem, ajɨ Koina yɨtkak makwa ngai opima b'eteomnenanj dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ɨ makwa ɨta yete wumɨr onggɨtyam bibɨr dɨde wɨn gatab. Pumb tungg aneru toda makwa wumɨr im, ɨ kwa toda B'ɨga ma wumɨr e, ajɨ yɨpaina B'uta Tinta wumɨr. ");
INSERT INTO gdr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mop nokɨp ra Rɨgamna B'ɨga tɨtenj Tina bibɨrɨnd, sɨ ɨja ima mɨle taukanj dem rɨja na re mɨle aukɨto Nowam wɨnɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sɨ yɨmta kena ngɨwɨr ikonj, ajɨ rɨga re odede yɨg nony wɨmena mɨle nat wekenonj, opi re owowɨnd ɨ onaikand ɨ kongga imdand ɨ dɨde leo imdand, ngɨrpu onggɨt bibɨrɨnd re Nowa gɨga wa b'ɨgaronj. ");
INSERT INTO gdr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ajɨ ton makwa ke wumɨr wekenonj nanggamog im taukanj, ngɨrpu re ket ngɨwɨr ikonj dɨde ket komkesa rɨga negɨr amnɨkinonj. Sɨ ɨja imemb jɨ daka mɨle pɨta taukanj dem ra Rɨgamna B'ɨga tɨtenj dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ɨ onggɨt wɨnɨnd ra Rɨgamna B'ɨga pɨta tainy dem, ra nɨmog rɨga yɨpaina sopapund gɨlgɨl waland tebnya dem, Rɨgamna B'ɨgat yɨpand ɨta yii dem de pumb wa, ɨ daka yɨpand ɨndama ɨrar dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ɨ kwa ra nɨmog kongga yɨpand sana ɨkmɨkand tebnya dem, Rɨgamna B'ɨgat yɨpand ɨta wii dem de pumb wa, ɨ daka yɨpand ɨndama tɨrar dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Sɨ onggɨt paemb wɨn yɨr kɨma na tekenyɨt, mop nokɨp wɨn ma wumɨr im rɨnggɨt bibɨr nate wa Yonggyam ik dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ɨ wɨn wumɨr im da rada met yonggyam wumɨr ai e yɨbɨm da sɨwɨny onggɨt wɨn nate yurowamam rɨga ik tina met wa, ton ma ɨta yiyag ondras tina met iporkam. ");
INSERT INTO gdr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Sɨ onggɨt paemb wɨda kwa b'ogla b'angonjeni na tekenyɨt, mop nokɨp Rɨgamna B'ɨga ik ra dem waina ongwati kesa wɨn nate dem. ");
INSERT INTO gdr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Sɨ yete jɨ b'ogɨl multekɨp kɨma nony ɨjai wɨko rɨga ya yɨm nat ra ti yonggyam tina met komkesa gasa taramkiny yɨr iyenam? Sɨ yonggyam ɨta ket odede nony ɨjai wɨko rɨga obagenj komkesa tina wɨko rɨga wɨp omnenam dɨde towa ita bibɨr wɨn weanjweanj owou ogonam. ");
INSERT INTO gdr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Sɨ ton re b'ogɨl omni wɨko rɨga e yena ra tina yonggyamɨt tin odar odede yɨpa wɨp mɨle omnɨkand ra ton tɨtenj. ");
INSERT INTO gdr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ɨ Kon ɨmɨnjog wen tamninyɨn da ti yonggyam ɨta odede wɨko rɨgand obagenj komkesa tinajog gasa yɨr ɨpkam. ");
INSERT INTO gdr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ajɨ rada yonggyam yɨpa negɨrjog wɨko rɨgand tina komkesa wɨko rɨga dɨde tina gasa yɨr ɨpka mopyamɨm obagenj, sɨ ɨja emb jɨ ton ti nony mana indeny da, ‘Meda kor yonggyam ma wanakana e tɨtenj.’ ");
INSERT INTO gdr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Sɨ ɨngkaemb ton ket b'atom odede negɨr mɨle omnɨkam, opi re ti wɨko rɨgamadwar ipowam, ɨ ɨkpɨp rɨga kɨma owou yiyand wɨmenam ɨ ɨk onaika yiyand wɨmenam. ");
INSERT INTO gdr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Sɨ onggɨt wɨko rɨgamna yonggyam tɨtenj ra onggɨt bibɨr nate rɨdenat ra ɨtemb wɨko rɨga maka bibɨr wumɨr ɨbɨm dɨde onggɨt wɨn nate rɨdenat ra ton maka wɨn wumɨr ɨbɨm. ");
INSERT INTO gdr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Seg ti yonggyam ket tin mop owaras dɨde ket ti pɨpmet okau ra yɨpand gɨm ke b'ogɨl ajɨ ngor wa negɨr mɨle rɨga kɨma wɨmenam rokasim ra rɨga yii kamil b'iyowa tuweny dem, dɨde kopa b'angnena kɨma or b'ɨinɨka tuweny dem. ");
INSERT INTO gdr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ɨ onggɨt wɨnɨnd ra Yonggyam tɨtenj dem, pumb tungg re ɨja emb jɨ tainy opi re ten (10) pɨl esopai kesa ngɨmngai pɨla yepiya re towainajog yɨpayɨpa lampa emdɨto dɨde ket opekto sisɨl kongga kɨma rɨga wɨpwɨp omnam. ");
INSERT INTO gdr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Sɨ towa wɨngɨrɨnd nɨnda paib (5) re korɨrkorɨr na ajɨ kwa nɨnda paib (5) re b'ogɨl multekɨp kɨma na. ");
INSERT INTO gdr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ɨ opimemb korɨrkorɨr ngɨmngayɨp kea towainajog lampa so omnɨki eito ajɨ ton makwa ke ngai nyɨ eito lampa ongjɨkam. ");
INSERT INTO gdr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ajɨ daka opimemb b'ogɨl multekɨp kɨma ngɨmngayɨp re kea lampa ongjɨkam nyɨ eito jirokakɨnd yɨpand towainajog so omni lampa kɨma. ");
INSERT INTO gdr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ajɨ re onggɨt ten ngɨmngayɨp sisɨl kongga kɨma rɨgand yɨr yungauko, sɨ ɨtemb sisɨl kongga kɨma rɨga maka wanaka opendonj. Sɨ ket yɨtpat ten komkesa akasinonj ngɨrpu ket kea yɨt wungonj. ");
INSERT INTO gdr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Seg sɨdɨrɨnd ket ara ikonj da, ‘Yɨr de, ɨtemb ke sisɨl kongga kɨma rɨga ik. Wɨn opekina tin wɨpwɨp omnam!’ ");
INSERT INTO gdr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Sɨ odedend ket opimemb komkesa ten (10) pɨl esopai kesa ngɨmngai utnɨkto dɨde ket towainajog lampa wikind tim b'ɨskoka eyento ɨ ket so omnɨka eyento. ");
INSERT INTO gdr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ɨ opimemb korɨrkorɨr ngɨmngayɨp b'ogɨl multekɨp kɨma ngɨmngai egekitto da, ‘Sowada ngai nyɨ nokaina lampa ongjɨkam, nokɨp sowaina lampa re momta im tosoukanj.’ ");
INSERT INTO gdr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ajɨ opimemb b'ogɨl multekɨp kɨma ngɨmngayɨp mɨra amnɨto da, ‘Ka! Nyɨ re ma rɨrɨr im taukanj dor rɨrɨrkɨp ongjɨkam sowanɨm dɨde wanɨm. Sɨ wɨn b'ogla wuwe nyɨ osoga rɨga wa pɨlwa dɨde ket wainajog lampa ongjɨkam nyɨ temjindam.’ ");
INSERT INTO gdr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ajɨ onggɨt ganggand re opimemb korɨrkorɨr ngɨmngayɨp yiwato nyɨ imdam, odedend ket sisɨl kongga kɨma rɨga ikonj. Sɨ opimemb b'angonjeni b'ogɨl multekɨp kɨma ngɨmngai yɨpand ɨtemb sisɨl kongga kɨma rɨga kɨma b'ɨgarkɨto molkongga omna diyamdiyampu wa, seg ket wɨko rɨgap kea mora yɨdoko. ");
INSERT INTO gdr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ɨ opimemb ket korɨrkorɨr ngɨmngai daka yɨmta ke tuwonj dɨde ket endento da, ‘Yonggyam, Yonggyam! Mora sowa yɨjge!’ ");
INSERT INTO gdr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ajɨ ɨtemb sisɨl kongga kɨma rɨga ket ten esmonggainonj da, ‘Kon ɨmɨnjog wen tamninyɨn da Kon ma wumɨr en wanɨm.’ ");
INSERT INTO gdr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Sɨ onggɨt paemb wɨn yɨr kɨma na tekenyɨt. Mop nokɨp wɨn ma wumɨr im bibɨr dɨde wɨn rɨdenate ra Rɨgamna B'ɨga tɨtenj. ");
INSERT INTO gdr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ɨ kwa ra Yonggyam tɨtenj dem, pumb tungg re yɨpa wɨp e tainy odede yɨpa rɨga kɨma yet re tina wɨko rɨga ara emokinonj dɨde ket towa tina gasa agoninonj yɨr ɨpkam, ɨ ɨngkenaemb ket ton yiwatonj b'enga kantri wa. ");
INSERT INTO gdr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sɨ re ɨtemb rɨga tina gasa agoninonj yɨr ɨpkam, ton naska tina wɨko rɨgaina danda yɨr eyeninonj dɨde ket onggɨt towaina danda rɨrɨrɨnd wulkɨp agoninonj, yɨpam re paib (5) ukoi gold kɨpol na, ɨ daka yɨpam re nɨmog ukoi gold kɨpol na, ɨ kwa daka yɨpam re yɨpa ukoi gold kɨpol na. Seg ɨngkenaemb ket ton yiwatonj. ");
INSERT INTO gdr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ɨ ɨtemb rɨga yet re paib (5) ukoi gold kɨpol akasinonj, ton odenja yikonj dɨde ket onggɨt wulkɨp ke b'obogɨl wɨko amnɨkeneninonj, ngɨrpu ton ket onggɨt wulkɨp ke kea b'usaya paib (5) ukoi gold kɨpol tumɨnd akasinonj. ");
INSERT INTO gdr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ɨ odede yɨpa wɨp nya ke ɨtemb rɨga yet re nɨmog ukoi gold kɨpol akatonj, todaka onggɨt wulkɨp ke kea b'usaya nɨmog ukoi gold kɨpol tumɨnd akatonj. ");
INSERT INTO gdr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ajɨ ɨtemb rɨga yet re yɨpaina ukoi gold kɨpol yokatonj, ton ket yikonj dɨde ket gou yoskonj, ngɨrpu ton ket onggɨt gou borand ɨtemb ti yonggyamɨmna wulkɨp yegitonj. ");
INSERT INTO gdr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ɨ gɨep ke opimemb wɨko rɨgaina yonggyam ɨtendonj dɨde ket ton yɨrɨk eyeninonj rɨdede na tina wɨko rɨgap opimemb tina wulkɨp engaenento b'usaya tumɨnd mɨra oikɨndenam. ");
INSERT INTO gdr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Sɨ ɨtemb rɨga yet re paib (5) ukoi gold kɨpol akasinonj, ton opimemb tumɨnd oikɨnti paib (5) ukoi gold kɨpol kɨma wulkɨp teyinonj ti yonggyamɨm pɨlwa odede yɨt kɨma da, ‘Yonggyam! Opimemb jɨ mor paib (5) ukoi gold kɨpol rɨna re nokainot. Yɨr de, ɨnaemb jɨ kon kwa paib (5) ukoi gold kɨpol b'usaya tumɨnd aikɨnsinyɨmɨn.’ ");
INSERT INTO gdr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Sɨ ti yonggyam tin yomnonj da, ‘Oo, otomantijog! Sɨ man re b'ogɨl dɨde nony ɨjai wɨko rɨga et. Man kea sobijog gasa yɨr ɨpkam nony b'ɨjawa kɨma b'obogɨl wɨko yiyenenyɨmɨt, sɨ kon men motramisɨn ra jogjog gasa yɨr ɨpka rɨga ma. Sɨ kon moina yonggyamte nitinjɨn da man metkɨm de kor pɨlwa koina sam yingg okatam.’ ");
INSERT INTO gdr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ɨ kwa ɨtemb rɨga yet re nɨmog ukoi gold kɨpol akatonj, ton osiemb tumɨnd oikɨnti nɨmog ukoi gold kɨpol kɨma wulkɨp teyinonj ti yonggyamɨm pɨlwa odede yɨt kɨma da, ‘Yonggyam! Osiemb jɨ mor nɨmog ukoi gold kɨpol rɨna re nokawot. Yɨr de, ɨnaemb jɨ kon kwa nɨmog ukoi gold kɨpol b'usaya tumɨnd aikɨnsmɨn.’ ");
INSERT INTO gdr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Sɨ ti yonggyam tin yomnonj da, ‘Oo, otomantijog! Sɨ man re b'ogɨl dɨde nony ɨjai wɨko rɨga et. Man kea sobijog gasa yɨr ɨpkam nony b'ɨjawa kɨma b'obogɨl wɨko yiyenenyɨmɨt, sɨ kon men motramisɨn ra jogjog gasa yɨr ɨpka rɨga ma. Sɨ kon moina yonggyamte nitinjɨn da man metkɨm de kor pɨlwa koina sam yingg okatam.’ ");
INSERT INTO gdr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ɨ dɨde kwa ɨtemb rɨga yet re yɨpaina ukoi gold kɨpol yokatonj, todaka ket ti yonggyamɨm pɨlwa ikonj dɨde ket yomnonj da, ‘Yonggyam! Kon wumɨr en mornɨm da man re wɨp ɨnggrawa kesa rɨga et. Sɨ man erngokeneninyɨt re ma moina ɨti kaim, ɨ kwa man bobo amnɨkeneninyɨt re ma moina ɨgmarki kaim. ");
INSERT INTO gdr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Sɨ onggɨt penaemb kon moga awond, sɨ ket nekond dɨde ket moina ukoi gold kɨpol yegitond gou bora wa. Sɨ yɨr de, ɨtemb jɨ moina ukoi gold kɨpol.’ ");
INSERT INTO gdr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Seg ti yonggyam ket mɨra yomnonj da, ‘Sɨ man re negɨrjog dɨde dɨnderkak wɨko rɨga et. Ma man ɨja naemb kornɨm wumɨr awot da kon erngokeneninyɨn nangga na re kon maka esinond, ɨ kwa kon bobo amnɨkeneninyɨn nangga na re kon maka egmarkinond? ");
INSERT INTO gdr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Sɨ rako man odede wumɨr awot kornɨm, sɨ man b'ogɨl na rako koina ukoi gold kɨpol bengk rɨga wa akawot. Sɨ kon kakoa ɨngkenaemb koinajog wulkɨp yokasɨn onggɨt wulkɨp kɨma ɨt re koina wulkɨp ke oikɨnti wewe wulkɨp. ");
INSERT INTO gdr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Sɨ onggɨt paemb wɨn yɨsata ɨtemb ukoi gold kɨpol ti pɨlke dɨde ket yokawa onggɨt rɨgam yete re ten (10) ukoi gold kɨpol awaminy. ");
INSERT INTO gdr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mop nokɨp komkesa rɨga yepim re engaenanj nangga im re towa pɨlɨnd ebnainy, God opima b'usaya tumɨnd tagoniny dɨde ket b'atɨikɨndenanj. Ajɨ yete re maka yingaeny nangga e re ti pɨlɨnd yɨbnau, God ɨta onggɨtyam gasa ewaikis ti pɨlke. ");
INSERT INTO gdr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Sɨ wɨn ɨtemb esourena kesa wɨko rɨga yɨska bau wa de sɨbɨb pɨpmet wa rokasim ra rɨga yii kamil b'iyowa tuweny dem, dɨde kopa b'angnena kɨma or b'ɨinɨka tuweny dem.’ ");
INSERT INTO gdr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ɨ onggɨt wɨnɨnd ra Rɨgamna B'ɨga ik dem Tina b'ogɨl ɨnyomarena kɨma dɨde komkesa Tina aneru kɨma, Ton ɨta Tina b'ogɨl ɨnyomarena kɨma wɨp omnenapu kasand tomis dem. ");
INSERT INTO gdr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ɨ ket anerup komkesa b'engabenga yɨtam rɨga Ti wɨp wa yɨpand teomkuranj dem, ɨ Ton ket opima onggɨtyam komkesa b'engabenga yɨtam rɨga yɨpayɨpa ɨsagɨka teyeniny dem wetaweta omnɨkam, odede rɨngma ra mamoi yɨr ɨpka rɨgat mamoi wetaweta tamnɨkiny gout wa pɨlke. ");
INSERT INTO gdr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sɨ ɨtemb mamoi yɨr ɨpka rɨgat opima mamoi oramka teyeniny tina yɨmjog yɨm tab ke dɨde gout tina sawai yɨm tab ke, sɨ odede yɨpa wɨp nya kae ɨtemb Rɨgamna B'ɨgat Todaka opima negɨr kesa dɨmdɨmjog rɨga oramka teyeniny dem Tina yɨmjog yɨm tab ke dɨde negɨr mɨle rɨga Tina sawai yɨm tab ke. ");
INSERT INTO gdr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Seg ket ɨtemb King opima Tina yɨmjog yɨm tab ke rɨga tamniny dem da, ‘Tuyɨm wɨn Kor B'uɨmna b'ogɨl omni rɨga! Ɨ wɨn ket yowabɨnta pumb tungg rɨna re God gowukoi otobarkapu ke yongonjenonj wanɨm okawam. ");
INSERT INTO gdr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mop nokɨp re Kon owoupand nɨbnond, wɨn kea Ken nongenonda owou ke, ɨ re Kon nyɨpand nɨbnond, wɨn kea Ken nyɨ ke nokɨkenonda, ɨ dɨde re Kon tungg tɨb kesa nɨbnenond, wɨn kea Ken nɨngaukenonda waina met wa. ");
INSERT INTO gdr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ɨ kwa re Kon wɨ kesa nɨbnond, wɨn kea Ken kobɨrgɨm nikokenenonda, ɨ re Kon kopa nɨbnenond, wɨn kea odarenam nopenenonda, ɨ re Kon sɨbɨbmetɨnd nɨbnenond, wɨn kea Ken nesmarenenonda.’ ");
INSERT INTO gdr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Seg ket negɨr kesa dɨmdɨmjog rɨgap Tin omnyi dem da, ‘Yonggyam! Rɨdenat sɨn Men yɨr mongonda owoupand ɨ ket mongenonda, o nyɨpand ɨ ket sɨn mokɨkenonda? ");
INSERT INTO gdr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ɨ kwa rɨdenat sɨn Men yɨr mongenonda tungg tɨb kesand ɨ ket Men sowaina met wa mɨngaukenonda, o wɨ kesand ɨ ket sɨn mikokenonda kobɨrgɨm ke? ");
INSERT INTO gdr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ɨ kwa daka rɨdenat sɨn Men yɨr mongenonda kopand o sɨbɨb metɨnd ɨ ket sɨn Men mesmarenonda?’ ");
INSERT INTO gdr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ɨ ket onggɨt Kingɨt ten tesmonggainy dem da, ‘Kon ɨmɨnjog wen tamninyɨn da sɨ wɨn nangga mɨle na onggɨt sobijogjog Koina gar ke utkunda yɨngganwar wa wɨngɨrɨnd yɨpa rɨgam pɨlɨnd omnɨka eyentondam, sɨ wɨn re kea Kor pɨlɨnd omnɨka eyentondam.’ ");
INSERT INTO gdr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Seg ra ket ɨtemb King opima Tina sawai yɨm tab ke rɨga tamniny dem da, ‘Wɨn sake okati rɨga, Kor pɨlke ewaikisina! Ɨ ket b'aklansinam de ngɨrpu kesa b'ɨrmatena wul wa rɨnte re ongonjeni yɨbɨm Satanam dɨde Tina aneru wanɨm. ");
INSERT INTO gdr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mop nokɨp re Kon owoupand nɨbnond, wɨn maka Ken nongenonda owou ke, ɨ re Kon nyɨpand nɨbnond, wɨn maka Ken nyɨ ke nokɨkenonda. ");
INSERT INTO gdr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ɨ re Kon tungg tɨb kesa nɨbnenond, wɨn maka Ken nɨngaukenonda waina met wa, ɨ re Kon wɨ kesa nɨbnond, wɨn maka Ken kobɨrgɨm nikokenenonda, ɨ dɨde re Kon kopand o sɨbɨbmetɨnd nɨbnenond, wɨn maka Ken nesmarenenonda.’ ");
INSERT INTO gdr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Seg ket opimemb negɨr rɨgap todaka Tin omnyi dem da, ‘Yonggyam! Rɨdenat sɨn Men yɨr mongonda owoupand o nyɨpand o tungg tɨb kesand o wɨ kesand o kopand o sɨbɨbmetɨnd, ɨ ket sɨn maka Men yɨm mokaenenonda?’ ");
INSERT INTO gdr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ɨ kwa ket ɨtemb King ten tesmonggainy dem da, ‘Kon ɨmɨnjog wen tamninyɨn da sɨ wɨn nangga mɨle na onggɨt sobijogjog Koina rɨga wa wɨngɨrɨnd yɨpa rɨgam pɨlɨnd maka omnɨka eyentondam, sɨ wɨn re maka Kor pɨlɨnd omnɨka eyentondam.’ ");
INSERT INTO gdr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Sɨ opimemb negɨr rɨga wui dem de ngɨrpu kesa negɨr ma mɨra okatenapu wa, ajɨ opimemb negɨr kesa dɨmdɨmjog rɨga ton wui dem de dadal ngɨrpu kesa yɨrkokar wa.” ");
INSERT INTO gdr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ɨ re ket Yesu opimemb komkesa yɨt useka seg amninonj, Ton Tina b'auyaena rɨga amninonj da, ");
INSERT INTO gdr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Maeda wɨn wumɨr im da nɨmog bibɨr kak kae meraina Uj Ɨgwanti Nony Iyena Diyamdiyam Bibɨr tainy dem, sɨ ɨdenatemb Rɨgamna B'ɨgand yɨmɨnd usunasi dem wul b'agbagɨnd ɨdrɨkam.” ");
INSERT INTO gdr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ɨ onggɨt wɨnɨnd ket yɨna mopyam sɨ rɨgap dɨde Ju rɨga waina elda rɨgap b'eoma yokato yɨna mopyam sɨ rɨga, nyɨ da Kayapa, tina met aband. ");
INSERT INTO gdr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ɨ ton ket odede yɨt yɨsamko da wɨgawɨga rabem nya ke Yesund yɨmɨnd usunasi dɨde ket Tin uj tama onganji. ");
INSERT INTO gdr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ajɨ ton endento da, “Ma onggɨtyam diyamdiyam wɨn nate onganju, nokɨp ke rɨga wa wɨngɨrɨnd soro kɨma bebɨg mɨle rawɨk.” ");
INSERT INTO gdr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ɨ yɨpa wɨnɨnd Yesu yɨbnonj Simonɨmna metɨnd Betaniya tunggɨnd yet re naskand leprosi kopa kɨma yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ɨ onggɨt wɨnɨnd yɨpa kongga Ti pɨlwa tikonj yɨpa ukoi mɨra kɨma b'ogɨl ngɨrangngɨrang gaya kɨma yɨpa otomanti alabasta gɨmo botolɨnd. Ɨ re Yesu diyam awowɨnd yɨbnonj, onggɨt konggat kea Ti mopɨnd ɨtemb ngɨrangngɨrang gaya yɨgmarkonj. ");
INSERT INTO gdr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ɨ re b'auyaena rɨgap ɨtomb konggamna mɨle yɨr yongo, ton kea ket komliu aukɨto dɨde endento da, “Nangga pae ton jabakɨpɨnd yesomneny? ");
INSERT INTO gdr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mop nokɨp rako ton onggɨtyam gaya yosog, ton keakoa rɨrɨr na ukoijog wulkɨp akasiny dɨde ket tagoniny gasa kesa rɨga wa.” ");
INSERT INTO gdr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ajɨ re Yesu towaina yɨt b'ɨglenena gatab wumɨr awonj, Ton ket ten amninonj da, “Nangga ma wɨn onggɨt konggand bebɨgɨm ɨl wongkya? Mop nokɨp ton kea Kornɨm b'ogɨl mɨle yomnɨk. ");
INSERT INTO gdr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mop nokɨp gasa kesa rɨga opima wɨn kɨma wekeneny ita wɨnɨnd, ajɨ Kon ma ɨta ita wɨnɨnd wɨn kɨma nɨtɨbnenenyɨn. ");
INSERT INTO gdr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Sɨ re ɨtomb konggat Koina jɨwɨnd ngɨrangngɨrang gaya yɨgmarɨk, ɨtemb re Koina jɨ eungitam get ke b'angonjenam mɨle emb jɨ. ");
INSERT INTO gdr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sɨ Kon ɨmɨnjog wen tamninyɨn da rokate ra God ma b'ogɨl yɨrkokar bage yɨt pɨtapɨta omnenenyi dem komkesa gowukoyɨnd, onggɨt konggamna omnɨki mɨle daka kwa ɨta ket usenenyi dem tinɨm nony iyenam.” ");
INSERT INTO gdr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ɨ onggɨt wɨnɨnd Twelp (12) ɨtmɨkitijog rɨga wɨngɨrɨnd yɨpa rɨga, ogenaya da Yudas Iskariyot, yikonj yɨna mopyam sɨ rɨga wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Sɨ Yudas ket egekisinonj da, “Wɨn nangga e kor notkaya, ra kon Yesund wa yɨm kumb wa oramisɨn?” Sɨ ton ket ti teti (30) silba koin yokauto. ");
INSERT INTO gdr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Seg onggɨt kak kenaemb ket Yudas b'ogɨl wɨn oraka yiyenonj Yesund okawam towa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ɨ re Yist kesa Bred Wɨn wɨngɨrɨnd, naskajog bibɨr awonj, b'auyaena rɨga Yesum pɨlwa tuwonj dɨde ket yɨgekito da, “Rokate Man singi aet sɨn motngonjenau Mornɨm owowɨm meraina Uj Ɨgwanti Nony Iyena Diyamdiyam?” ");
INSERT INTO gdr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Seg ket Yesu nɨmog b'auyaena rɨga engawonj da, “Eka de Yerusalem taun wa, de yɨpa rɨgam pɨlwa dɨde ket tin omnya dor da Ouyaena Rɨga yindeny da, ‘Koina wɨn re ke wus nate ainy, sɨ Kon ɨndamaemb moina metɨnd meraina Uj Ɨgwanti Nony Iyena Diyamdiyam omnɨken Koina b'auyaena rɨgawar kɨma.’” ");
INSERT INTO gdr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Seg osiemb b'auyaena rɨga nɨmogɨp ɨja na gasa amnɨkinonda rɨja na re Yesu ten engawonj dɨde ket Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam yongonjenonda. ");
INSERT INTO gdr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ɨ re sɨ imokonj, Yesu diyamdiyampu kasand omitonj Twelp (12) b'auyaena rɨga kɨma. ");
INSERT INTO gdr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sɨ re ton diyam awowɨnd wekenonj, Yesu ten amninonj da, “Kon ɨmɨnjog wen tamninyɨn da wa wɨngɨrɨnd yɨpa rɨgat ɨta Ken tɨb nii.” ");
INSERT INTO gdr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Sɨ b'auyaena rɨgap gar bebɨg aukɨto dɨde ket yɨpayɨpa yɨgekeno da, “Yonggyam! Ma konten?” ");
INSERT INTO gdr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ɨ ket Yesu mɨra amninonj da, “Rɨga yete re Kon kɨma gɨlgɨl sana okatam yɨm yoramis de pleto wa, ɨtemb rɨga tontemb Ken tɨb nii. ");
INSERT INTO gdr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sɨ b'ogɨl e Rɨgamna B'ɨga, Ton uj okas dem rɨngma re yɨna peband ɨrɨki yɨbɨm Ti gatab. Ajɨ onggɨt rɨgam yet ra Rɨgamna B'ɨgand tɨb yii dor, ukoi kear kɨma e tinɨm, nokɨp ton ukoijog bebɨg nate tau dem. Sɨ tinɨm keako b'ogɨl na jɨ rako ton maka ukendonj ti mogɨm kom ke.” ");
INSERT INTO gdr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Sɨ Yudas yet ra Yesund tɨb yii dor Yesund yomnonj da, “Ouyaena Rɨga! Rɨka konten?” Ajɨ Yesu tin yɨsmonggawonj da, “Owɨ, kemb man minjɨt.” ");
INSERT INTO gdr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ɨ re Yesu dɨde Tina b'auyaena rɨga diyam auto, Yesu yɨpa sana nganja yokatonj ɨ Godɨnd sɨteket yɨt yomnonj, ngɨrpu ket yipkɨkonj dɨde agoninonj Tina b'auyaena rɨga wa pɨlwa. Ɨ Ton yindonj da, “Wɨn yokata! Ɨtemb re Koina jɨ e.” ");
INSERT INTO gdr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Seg ket Yesu kwa yɨpa kapo yokatonj dɨde Godɨnd sɨteket yɨt yomnonj, ngɨrpu ket Tina b'auyaena rɨga wa kapo akawonj towanɨm onayam odede yɨt kɨma da, “Wɨn komkesa onggɨt kapond nyɨ yonaika! ");
INSERT INTO gdr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mop nokɨp ɨtemb kapond nyɨ re Koina outɨnti tɨrɨr omnijog yɨt kɨma kus e rɨnte re Kon yɨgmarken jogjog rɨgaina negɨr mɨle awɨr omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kon wen tamninyɨn da Kon makwa ɨta b'usaya onaen dem onggɨt greip kɨp ke omnɨki wain, ngɨrpu onggɨt bibɨrɨnd ra Kon sisɨl wain onaen dem wɨn kɨma demb de Kor B'u God ma pumb tungg wa.” ");
INSERT INTO gdr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sɨ diyamdiyam seg ke ton ger yɨtango dɨde ket yiwato de Olib dor wa. ");
INSERT INTO gdr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ɨ onggɨt wɨnɨnd Yesu ket Tina b'auyaena rɨga amninonj da, “Yu sɨwɨny wɨn opima komkesa sap totekindam dor dɨde kak nɨtɨaya dor onggɨt mɨle map rɨnte ra tawɨk Kor pɨlɨnd, mop nokɨp yɨt ɨja emb jɨ ɨrɨki yɨbɨm yɨna peband da, ‘Kon ɨta onganjɨn dem mamoi yɨr ɨpka rɨga, sɨ ket opima mamoi bobo wetaweta b'ɨtkenanj dem.’ ");
INSERT INTO gdr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ajɨ onggɨt kak ke ra Kon tutnyisɨn dem uj ke, sɨ wɨn yɨmta kaim wuyɨt dem de Galili wa ajɨ Kon naska e neken dem.” ");
INSERT INTO gdr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Seg Petro ket Yesund danda kɨma yomnonj da, “Nangga ma jɨ ra ton komkesa rɨgap sap totendanj dor dɨde kak mɨtɨayi dor onggɨt mɨle map rɨnte ra tawɨk Mor pɨlɨnd, ajɨ kon kolenggyam ra makwa ɨta sap totenjɨn dor dɨde kak mɨtɨaen dor.” ");
INSERT INTO gdr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ɨ Yesu ket tin mɨra yomnonj da, “Kon ɨmɨnjog men motɨnyɨn da yu sɨwɨny yɨmta kena pauro ara tuweny dor, ajɨ man naska Ken ɨta nowapyam notiyenyɨt dor.” ");
INSERT INTO gdr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Seg ket Petro Yesund yomnonj da, “Ra Man uj taet, koda b'ogla uj rawɨn Man kɨma. Ajɨ kon makwa ɨta motiyenyɨn.” Ɨ komkesa b'auyaena rɨgap toda ɨja na yɨpa rɨrɨrkɨp endento. ");
INSERT INTO gdr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ɨ re Yesu Tina b'auyaena rɨga kɨma menon yokato yɨpa pɨpmet wa nyɨ da Getsemani, Yesu ten amninonj da, “Kon ama de neken dɨde yɨr e topmitenyɨn. Sɨ wɨn omandemb omnɨki wekene, ngɨrpu ra Kon tɨtenjɨn wa pɨlwa.” ");
INSERT INTO gdr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ɨ Yesu ɨna rɨga eyinonj Ton kɨma Petro dɨde Jebedaimna b'ɨga nɨmog. Seg Ton ket ngor wa gar kopa dɨde gar bebɨg b'atomonj. ");
INSERT INTO gdr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Seg ket Ton ten amninonj da, “Koina wɨngawɨnga ma sobijog gar kopa e ainy momta uj okatam. Wɨn wekene dɨkɨnd dɨde yɨpand Kon kɨma yɨr opngɨki wekene!” ");
INSERT INTO gdr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ɨ re ɨngkek ket Ton sobijog paja wa b'ɨsonkitonj, Ton ket kum ujokonj dɨde ket wɨp gou wa yomnonj, seg ket Godɨm pɨlwa yɨr opmitenonj da, “Kor B'u! Sɨ Man onggɨtyam Koina b'ɨdgotnena kapo yewaikite Kor pɨlke, rada ɨtemb rɨrɨr e. Ajɨ goro Koina singi ke, ajɨ Moina singi kena.” ");
INSERT INTO gdr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Seg ket re Ton ket ɨtendonj nowa b'auyaena rɨga wa pɨlwa ɨ yutunga nat ten adarinonj. Seg Ton ket Petrond yomnonj da, “Rɨngma, wa awɨr im danda yɨpa odede sobijog wɨnɨnd yɨpand Kon kɨma yɨrkokar wɨmenam? ");
INSERT INTO gdr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yɨr opngɨki wekene, dɨde yɨr opmitenina! Nokɨm da ɨdenat maka wɨn Satanamna otonkena takatenindam. Waina wɨngawɨnga ukoi singi im Kon kɨma yɨrkokar wɨmenam, ajɨ waina jɨ re yarɨm im dɨde danda kesa im.” ");
INSERT INTO gdr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Onggɨt kak ke Yesu b'usaya nɨmogɨm yikonj dɨde yɨr opmitonj da, “Kor B'u! Rada ɨtemb ma rɨrɨr e onggɨtyam b'ɨdgotnena kapo ewaikitam Kor pɨlke dɨde rada Kon b'ogla ɨtemb kapo onaen, sɨ Moina singi b'ogla rawɨk.” ");
INSERT INTO gdr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ɨ re Ton kwa ɨtendonj opimemb b'auyaena rɨga wa pɨlwa, Ton b'usaya adarinonj towa yutungand. Ɨ towaina yɨrkɨp re bebɨg na yutɨtɨp wekenonj. Sɨ onggɨt penaemb ton yɨt wungonj. ");
INSERT INTO gdr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ɨ ket Yesu opimemb b'auyaena rɨga erarinonj dɨde ket b'usaya dea de yikonj. Seg ket re Ton nowam yɨr opmitonj Godɨm pɨlwa, Ton ɨna yɨpa wɨp yɨt usaireninonj rɨja na re Ton naskand yerkenonj. ");
INSERT INTO gdr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Seg ket Yesu ɨtendonj b'auyaena rɨga wa pɨlwa, Ton ten amninonj da, “Wɨn yutunga dɨde wɨram nasim dadal wekenyɨt. Yɨr de, wɨn re kemb momta e. Yɨpa rɨga ke Rɨgamna B'ɨga tɨb yii negɨr mɨle rɨga wa yɨm kumb wa. ");
INSERT INTO gdr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Utnɨkinam, men ket wowɨn Kor tɨb iyoyam rɨgam pɨlwa! Yɨr, ɨtemb ke ton ik Kor wus wa.” ");
INSERT INTO gdr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ɨ ket onggɨt wɨnɨnd re Yesu dɨdea yɨt opurenand yɨbnonj, Twelp (12) b'auyaena rɨga wɨngɨrɨnd yɨpa rɨga Yudas yɨna mopyam sɨ rɨga dɨde Ju rɨga waina elda rɨga wa pɨlke ikonj yɨpand ukoi rɨga bobo kɨma yepiya re geja giri dɨde kibam yɨmɨnd teito. ");
INSERT INTO gdr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ɨ ɨtemb Yesumna tɨb iyoi rɨga, Yudas kea towa pɨlwa wumɨr yoramitonj da, “Ra yena ra kon ikwasɨn dor omongnena kɨma, ɨtemb jɨ rɨga. Sɨ wɨn Tin b'obogɨl yɨmɨnd usunasya dor.” ");
INSERT INTO gdr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Sɨ re Yudas ikonj Yesum pɨlwa, ton odenja Yesund yomnonj da, “Ouyaena Rɨga, simesime!” dɨde ket Tin yomongnenonj. ");
INSERT INTO gdr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Seg ket Yesu tin yomnonj da, “Kor rɨga! Nangga singi mɨle nat metket re yomnɨke!” Ɨ odedend ket rɨgap Yesum pɨlwa b'ɨsonkurto ɨ ket Ti pɨlɨnd yɨm aramkɨto ɨ dɨde ket yɨmɨnd yusunato. ");
INSERT INTO gdr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ɨ odedend ket Yesumna b'auyaena rɨga wɨngɨrɨnd yɨpa rɨgat tina geja giri yɨtrɨngatonj metkak ke, ɨ ket yɨna mopyam sɨ rɨgamna wɨko rɨga ma yɨpa yɨpya rom yɨpmarkitonj dɨde ket gou wa ɨsendonj. ");
INSERT INTO gdr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Seg Yesu ket tin yomnonj da, “Moina geja giri yoramite tina metkak wa. Mop nokɨp komkesa rɨga yepim re geja giri engaenanj, ton opima geja giri ke uj taukanj. ");
INSERT INTO gdr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ma wɨn ma wumɨr im da Kon rɨrɨr e Kor B'und ɨgekisɨn da, ‘Man twelp (12) ukoi geja aneru bobo tetmɨkisinyɨt Kornɨm ɨrmekam,’ ɨ Ton odenja im ket tetmɨkisiny? ");
INSERT INTO gdr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ajɨ ra Kon Kor B'und ɨgekisɨn geja aneru ɨtmɨkitam, sɨ rɨdede nya kae opimemb yɨtkak rɨrɨrkɨp taukanj rɨnsim re yɨna peband Kor gatab ɨrɨki wekeny da b'ogla odede mɨle raukinem?” ");
INSERT INTO gdr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ɨ onggɨt wɨn natemb ket Yesu opimemb rɨga bobo amninonj da, “Ma wɨn Kena okatam notupya geja giri dɨde kibam kɨma odede wɨp rɨngma ra wɨn raskol rɨga okasya? Bibɨr weanjweanj Kon wa ouyaenand omiti nɨbnenenyɨmɨn yɨnametɨnd, ajɨ wɨn maka Ken yɨmɨnd nusunasma. Ajɨ wɨn Ken otade odede nya ke nokasya. ");
INSERT INTO gdr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sɨ komkesa onggɨtyam mɨle aukanj re nok mim da ɨdenat opimemb bageyam waina ɨrɨki yɨtkak rɨrɨrkɨp taukanj.” Seg ket komkesa b'auyaena rɨgap Yesund yɨraro dɨde b'ɨkento. ");
INSERT INTO gdr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ɨ rɨga yepiya re Yesund yɨmɨnd yusunato, ton ket Yesund yiyo yɨna mopyam sɨ rɨga Kayapam met wa, rɨkɨnd re Ju rɨga waina gog ouyaena rɨga dɨde Ju rɨga waina elda rɨga yɨpand b'eomkurto. ");
INSERT INTO gdr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ajɨ Petro kea Yesund pajapaja yɨmta undoka yiyonj ngɨrpu ama re yɨna mopyam sɨ rɨga ma met kara mora dunda wa. Ɨ ton ket kara wɨngɨr wa b'ɨgaronj dɨde ket nɨnda yɨnamet yɨr ɨpka rɨga kɨma yɨpand omitonj yɨr ongongɨm nangga e tawɨk Yesum pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ɨ re kot yɨpangendo, yɨna mopyam sɨ rɨgap dɨde komkesa Ju rɨga waina Sanedrin membap Yesum gatab ɨjongki yɨr ungata yɨt oraka eyento rɨdede nya kae Tin onganji. ");
INSERT INTO gdr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nangga ma jɨ da jogjog b'anygɨnena yɨr ungata rɨga tuwonj Yesum gatab yɨt ɨjongkam, ajɨ makwa nangga yɨt na adarkɨto. Ajɨ yɨmta ke nɨmog yɨr ungata rɨga tetkonda ");
INSERT INTO gdr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ɨ ket endenonda da, “Onggɨt rɨgat yindenonj da, ‘Kon rɨrɨr e Godɨmna yɨnamet iporken dɨde nowa bibɨr kɨma b'usaya orangen.’” ");
INSERT INTO gdr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Seg re ket yɨna mopyam sɨ rɨga onyitonj rɨga wa wɨpɨnd, ton ket Yesund yerkitonj da, “Nangga pae Man maka mɨra nomninyɨt? Ropim Mor pɨlke yɨt onggɨtyam negɨr yɨr ungatena yɨt gatab rɨnte re nɨmog rɨgap Mor pɨlwa iya?” ");
INSERT INTO gdr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ajɨ Yesu re mumakesa na yɨbnonj. Sɨ ket ɨtemb yɨna mopyam sɨ rɨgat Tin yomnonj da, “Sɨ kon yilo Godɨmna nyɨ kɨma Men mitngaen da Man b'ogla danda kɨma tɨrɨr yɨt opulisɨt sowa pɨlwa. Rɨka Man ɨmɨnjog Keriso, Godɨmna B'ɨga et?” ");
INSERT INTO gdr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ɨ ket Yesu tin mɨra yomnonj da, “Sɨ kemb man mindenyɨt. Ajɨ Kon ɨmɨnjog wen tamninyɨn da, ‘Otade ke wɨn ɨta Rɨgamna B'ɨga yɨr ongya omiti Komkesa Dandam Rɨgɨb Rɨgamna yɨmjog yɨm tab ke juwai kɨma pɨpmetɨnd ɨ kwa menonɨnd moi kumbɨnd wub kumb ke.’” ");
INSERT INTO gdr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ɨ re yɨna mopyam sɨ rɨgat Yesu ma yɨt utkundonj, ton kea ket soro kɨma tina kobɨrgɨm yɨnyowendonj dɨde ket ton rɨga amninonj da, “Nangga mim men ket kwa yɨr ungata yɨt arakindam Ti gatab? Yɨr de, otade wɨn kea Ti pɨlke Godɨnd ɨsadrena yɨt utkunjya. ");
INSERT INTO gdr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Rɨja im wɨn nony aindam?” Ɨ ket rɨgap tin yɨsmonggawo da, “Tina negɨr map uj yek.” ");
INSERT INTO gdr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Seg ton ket auya ke Yesumna wɨp ɨtmanda yiyeno dɨde ket yɨmkɨk ke Tin ipowa yiyeno. Ɨ nɨndap ket ana ɨpokena yiyeno odede yɨt kɨma da, ");
INSERT INTO gdr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Keriso, man sowa b'agenae! Yete Men mipou?” ");
INSERT INTO gdr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ɨ re Petro yɨna mopyam sɨ rɨga ma met kara wɨngɨrɨnd kot aband omiti yɨbnonj, yɨpa yɨna mopyam sɨ rɨga ma wɨko ngɨmngai tikonj ti pɨlwa dɨde ket yomnonj da, “Madaka kea Galili tunggam Yesu kɨma mɨbnenenot.” ");
INSERT INTO gdr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ajɨ Petro b'aenonj komkesa rɨga wa wɨpɨnd da, “Kon ma wumɨr en nangga yɨt e man yopurenyɨt.” ");
INSERT INTO gdr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ɨ re Petro ket kot aba ke yikonj mora gatab wa, kwa yɨpa b'enga wɨko ngɨmngayɨt tin yɨr yongonj dɨde ket rɨga amninonj yepiya re de wekenonj da, “Ɨtemb rɨga re Najaret tunggam Yesu kɨma na yɨbnenenonj.” ");
INSERT INTO gdr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ɨ Petro ket b'usaya danda kɨma tɨrɨr omna yɨt kɨma b'aenonj da, “Kon ma wumɨr en emb jɨ rɨga.” ");
INSERT INTO gdr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ɨ sobijog wɨn kak ke rɨga yepiya re demb de owɨnki wekenonj, ton tuwonj Petrom pɨlwa dɨde ket tin yomno da, “Ɨmɨnjog e madaka Tina yɨmta undoka rɨga wɨngɨrɨnd yɨpa rɨga et, mop nokɨp moina opurenate men pɨtand momɨny da man re yɨpa Galili rɨga et.” ");
INSERT INTO gdr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Seg ket Petro odede sake yɨt b'atomonj da, “Ra kon b'atɨnygɨnenyɨn, kon God ma sake ɨta okasɨn dem,” dɨde danda kɨma tɨrɨr yɨt ke Yesund yoenonj da, “Kon ma wumɨr en emb jɨ rɨga.” Re ket seg, odenja pauro ara yikenonj. ");
INSERT INTO gdr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Sɨ Petro ket kea nony aukonj Yesu ma opureni yɨtkak da, “Yu sɨwɨny yɨmta kena pauro ara tuweny dor, ajɨ man naska Ken ɨta nowapyam notiyenyɨt dor.” Ɨ ton ket bau wa opendonj dɨde ukoi gar kopa kɨma yii b'ɨrɨnenonj. ");
INSERT INTO gdr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ɨ ɨspari ke sɨtawarjogɨnd komkesa yɨna mopyam sɨ rɨgap dɨde Ju rɨga waina elda rɨgap Yesum gatab yɨpand yɨt ɨglenena seg auto dɨde ket tɨrɨr yomno Tin ongandam. ");
INSERT INTO gdr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Seg re ket ton ket Yesund yɨjobɨko ɨ yiyo ɨ dɨde ket Roma gabmani mopyam Pilatom yɨm kumb wa yoramito. ");
INSERT INTO gdr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ɨ onggɨt wɨnɨnd re Yesum tɨb iyena rɨga Yudas odede mɨle yɨr yongonj rɨna re Yesund ongandam tɨrɨr yomno, ton ma sobijog na nony bebɨg awonj da, “Kon kea naemb negɨr mɨle yomnɨken Ti pɨlɨnd.” Seg ton ket yɨna mopyam sɨ rɨga dɨde Ju rɨga waina elda rɨga wa etendainonj teti (30) silba koin. ");
INSERT INTO gdr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ɨ ton ket ten amninonj da, “Kon kea negɨr mɨle yomnɨkmɨn nokɨp kon negɨr mɨle kesa rɨga na tɨb iyɨmɨn wa pɨlwa ongandam.” Ajɨ todaka tin yɨsmonggawo da, “Nangga e de sowa pɨlwa? Ma sɨn kɨma bebɨg e, moda mor ma.” ");
INSERT INTO gdr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Seg Yudas ket silba koin b'ɨskansinonj yɨnametɨnd ɨ ket opmarkitonj ɨ dɨde ket dea ta yikonj, ngɨrpu ket tilenggyam kai b'atoukonj. ");
INSERT INTO gdr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ajɨ yɨna mopyam sɨ rɨgap opimemb silba koin esɨka eyento ɨ ket endento da, “Ɨtemb re ma rɨrɨrkɨpjog e onggɨtyam wulkɨp oramkam de yɨnamet gasa ongapapu pɨpmet wa, nokɨp opimemb re uj mɨra wulkɨp im.” ");
INSERT INTO gdr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Sɨ ton ket yɨt yɨgleneno dɨde ket tɨrɨr yomno, sɨ ton ket onggɨt wulkɨp ke pam ke gasa omnɨka rɨgamna gou kɨpol yokato, nokɨm da ɨdenat tungg tɨb kesa rɨga wa gop eukapu pɨpmet tainy. ");
INSERT INTO gdr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sɨ onggɨt mop paemb rɨgap ɨtemb gou kɨpol ogena yiyenyi ngɨrpu yu da, “Kus ke Gou Kɨpol”. ");
INSERT INTO gdr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Sɨ onggɨt mɨle kenaemb bageyam Yeremiyamna odede opureni yɨtkak rɨrɨrkɨp aukɨto da, “Ɨ ton opimemb teti (30) silba koin emdɨto re yɨpa rɨga okatam ogeni mɨra na, rɨna re nɨnda Ju rɨgap mɨra yogeno yɨpa rɨgand mɨra omnam ɨtemb rɨga gatab. ");
INSERT INTO gdr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ɨ ton ket opimemb wulkɨp engauto pam ke gasa omnɨka rɨgamna gou kɨpol okatam. Sɨ odede mɨle aukonj re onggɨt rɨrɨr nat rɨja na re Yonggyam ken ningaenonj.” ");
INSERT INTO gdr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ɨ re Yesu Roma gabmani mopyam Pilatom wɨpɨnd onyitonj, ɨtemb Roma gabmani rɨgat ket Yesund yerkitonj da, “Man Ju rɨga waina king et?” Ɨ Yesu mɨra yomnonj da, “Owɨ, kemb man mindenyɨt.” ");
INSERT INTO gdr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ɨ kwa yɨna mopyam sɨ rɨgap dɨde Ju rɨga waina elda rɨgap Yesum gatab negɨr yɨt apurento onggɨt kotɨnd, ajɨ Yesu makwa nangga ɨsmongga yɨt na yopulitonj. ");
INSERT INTO gdr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Seg ket Pilato Yesund yerkitonj da, “Ma man maka utkundenyɨt opimemb komkesa negɨr yɨtkak rɨnsim re ton apurenanj Mor gatab?” ");
INSERT INTO gdr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ajɨ Yesu makwa ngai nangga yɨt na tin yɨsmonggawonj. Sɨ onggɨt mopɨp ɨtemb gabmani mopyam rɨga ma sobijog na kɨd kesa awonj. ");
INSERT INTO gdr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ita Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam Wɨnɨnd Roma gabmani mopyam yɨpayɨpa sɨbɨbmet rɨga apekeninonj Ju rɨga wa pɨlwa towaina singi rɨrɨrɨnd. Ɨtemb re Pilatom get ke mɨle naemb jɨ yɨbnawonj. ");
INSERT INTO gdr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ɨ onggɨt wɨnɨnd kea yɨpa ongwati sɨbɨbmet rɨga yɨbnonj nyɨ da Baraba. ");
INSERT INTO gdr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Sɨ re Ju rɨga b'eomto, Pilato ten arkisinonj da, “Yena wɨn singi yomnya kon openjɨn wanɨm, Baraba o Yesu yena re yogenai da Keriso?” ");
INSERT INTO gdr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nangga pena Pilato odede b'arkita yoramitonj nokɨp ton nony ke wumɨr na da Ju rɨga waina membap Yesund iyi re nonyɨk b'ɨponena mapae, ajɨ Ju rɨga wa pɨlɨnd re kea singi ebnawonj Tin opendam. ");
INSERT INTO gdr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ɨ re Pilato omiti yɨbnonj b'ɨsagɨkapu kasand, ti kongga ti odede yɨt yɨtmɨkitawonj da, “Man goro nangga na omnɨkɨm onggɨt negɨr kesa dɨmdɨmjog rɨgam pɨlɨnd! Mop nokɨp yu sɨwɨny kon kor wɨmand ma sobijog na b'ɨdgotnena yokasɨn Ti map.” ");
INSERT INTO gdr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ajɨ yɨna mopyam sɨ rɨga dɨde Ju rɨga waina elda rɨgap Ju rɨga bobo danda kɨma ɨl ongka eyento, nokɨm da ɨdenat ton Pilatond ɨgekisi Baraband opendam ajɨ Yesund ongandam. ");
INSERT INTO gdr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ajɨ onggɨt Roma gabmani mopyam rɨgat ten amninonj da, “Sɨ osiemb nɨmog rɨga wɨngɨrɨnd yena wɨn singi yomnya kon opendam wa pɨlwa?” Sɨ ton ket yɨsmonggawo da, “Banaba na.” ");
INSERT INTO gdr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Sɨ Pilato egekisinonj da, “Sɨ wɨn kea naemb Banaband singi yomnya. Sɨ daka nangga e kon omnɨken Yesum pɨlɨnd yena re yogenai da Keriso?” Seg ket komkesa rɨgap yɨsmonggawo da, “Wul b'agbagɨnd yɨdrɨke!” ");
INSERT INTO gdr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ɨ ket Pilato ten yɨt esmonggainonj da, “Nangga pae? Nangga ukoi negɨr mɨle na yomnɨkɨm?” Ajɨ ton pumb wa b'okta kana ara yoikɨndeno da, “Wul b'agbagɨnd yɨdrɨke!” ");
INSERT INTO gdr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ɨ re Pilato odede towaina mɨle yɨr yongonj, ton kea b'angwatonj da tina yɨt re kea kɨp kesa ainy, ajɨ ukoi soro kɨma bebɨg re kea pɨta auka yik. Seg ton ket yɨpa besen nyɨ yokatonj dɨde ket rɨga bobo wa wɨpɨnd yɨm b'ɨsekonj odede yɨt kɨma da, “Kon re ma ɨta b'injawa okasɨn onggɨt rɨgamna uj gatab. Ɨtemb re wada waina bebɨg e.” ");
INSERT INTO gdr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Seg ket komkesa rɨga bobop yɨsmonggawo da, “Tina uj gatab bebɨg b'ogla sowa pɨlɨnd dɨde sowaina b'ɨgawar wa pɨlɨnd rain.” ");
INSERT INTO gdr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Seg re ket Pilato Banaband towa apendawonj, ajɨ ton kea tina geja rɨga engainonj Yesund ti wɨpɨnd ɨraskam. Ɨ re ɨraska seg yomno, ton ket Tin towa yɨm kumb wa yoramitonj wul b'agbagɨnd ɨdrɨkam. ");
INSERT INTO gdr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Seg ket Roma gabmani mopyamɨmna geja rɨgap Yesund yiyo de tina wɨkopu met kara wɨngɨr wa, dɨde ket komkesa Roma geja rɨgap yɨpand tuwonj Yesum pɨlwa dɨde ket Tin yɨwatɨnto. ");
INSERT INTO gdr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ɨ ton ket Yesund kobɨrgɨm otogɨka yiyeno dɨde ket king pɨla kuskus kobɨrgɨm yikito. ");
INSERT INTO gdr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Seg ton ket dɨngdɨng kai dɨra pɨla yogauko dɨde ket Ti mopɨnd ɨtemb dɨra yikito kingɨmna dɨra pɨla. Ɨ ket yɨpa buskak Tina yɨmjog yɨm wa yoramitawo kingɨmna kutɨp pɨla. Seg ket Ti wɨpɨnd kumop b'amka wuwenonj dɨde ket odede yɨt kɨma Tin jɨ malɨk omnɨka yiyeno da, “Simesime! Ju rɨga wa king!” ");
INSERT INTO gdr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ɨ ton ket Yesund auya ɨtmanda yiyeno, dɨde ton ket ɨtemb buskak Tin yɨsato ɨ ket onggɨt buskak ke Tina mopɨnd ipowa yiyeno. ");
INSERT INTO gdr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ɨ re ton Yesund jɨ malɨk omnɨka seg yomno, ton kea ɨtemb kobɨrgɨm yotokendawo dɨde ket Tinajog kobɨrgɨm yikoko, ngɨrpu Tin ket wɨp yiyo wul b'agbagɨnd ɨdrɨkam. ");
INSERT INTO gdr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ɨ re geja rɨgap Yesund wɨp yiyo, nyawɨnd ket ton yɨpa Kurene tunggam rɨga wɨpwɨp yomno nyɨ da Simon. Ɨ ket ton Simonɨnd danda kɨma yingawo Yesu ma wul b'agbag iyoyɨm. ");
INSERT INTO gdr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ɨ ket Yesund wɨp yiyo yɨpa sukak wa tungg nyɨ da Golgota, engendena yɨtkak da “Uj Rɨgamna Mopkak Wɨmenapu Tungg”. ");
INSERT INTO gdr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ɨ re ket ton onggɨt sukak wa opekto, geja rɨgap Yesum yokawo wain rɨna re sap nyɨ kɨma yɨsleko dɨmɨr okawam. Ajɨ re Yesu met yotonkitonj, Ton singi kesa awonj onayam. ");
INSERT INTO gdr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ɨ re geja rɨgap Yesund wul b'agbagɨnd nil ke yɨdrɨko, ton ket Yesu ma kobɨrgɨm ɨtaika eyento pes b'arena wɨba ke. ");
INSERT INTO gdr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Seg ket geja rɨgap dɨkɨnda omnɨkto onggɨt wul b'agbag wusɨnd dɨde ket Yesund yɨr engenda yiyeno. ");
INSERT INTO gdr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ɨ ton ket Yesu ma ongandam mop nyɨ yoramito Tina wul b'agbag pumb ke rɨna re wulpagpagɨnd odede erɨkto da, ");
INSERT INTO gdr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ɨ onggɨt wɨnɨnd kwa kea nɨmog negɨr raskol rɨga Yesu kɨma wul b'agbagɨnd edrɨko, yɨpa Tina yɨmjog yɨm tab ke ɨ yɨpa Tina sawai yɨm tab ke. ");
INSERT INTO gdr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ɨ opandena rɨgap Yesund ugaga yiyeno towaina mop b'uwongnena kɨma da, ");
INSERT INTO gdr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ɨ ɨte namb jɨ man rɨga. Man re mindot da, ‘Ɨta God ma yɨnamet iporken dem ɨ nowa bibɨr kɨma orangen dem.’ Sɨ molenggyam man yɨrkokar b'akae! Rada Man Godɨmna B'ɨga et, sɨ molenggyam gou wa ae wul b'agbag kumb ke.” ");
INSERT INTO gdr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ɨ kwa odede yɨpa wɨp nya ke yɨna mopyam sɨ rɨgap todaka Ju rɨga waina gog ouyaena rɨga dɨde Ju rɨga waina elda rɨga kɨma yɨpand Yesund jɨ malɨk omnɨka yiyeno towa wɨngɨrɨnd da, ");
INSERT INTO gdr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ton nɨnda rɨga wa yɨrkokar akainonj, ajɨ Ton ma rɨrɨr e Tilenggyam yɨrkokar b'atkau. Sɨ Ton re Israel rɨga wa king e. Ɨ ra Ton otade gou wa tau wul b'agbag kumb ke, ɨdenatemb men ket gar ke utkunda ke Tin okasu. ");
INSERT INTO gdr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ɨ Ton Godɨnd nony ɨjawa yiyeny. Sɨ otade God b'ogla Tin gou wa yamɨn wul b'agbag kumb ke ra Ton singi tainy Tinɨm. Nokɨp Ton kea yindenonj da, ‘Kon re Godɨmna B'ɨga en.’” ");
INSERT INTO gdr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ɨ osiemb nɨmog raskol rɨga yepiya re wul b'agbagɨnd ɨdrɨki ebnonda yɨpand Yesu kɨma, todaka kwa yɨpa wɨp nya ke Yesund kea ugaga yiyenonda. ");
INSERT INTO gdr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ɨ re lomtɨk awonj, sɨbɨbɨt komkesa gowukoi yɨkangɨndonj, ngɨrpu ama re ket tri (3) kɨlok awonj sɨmana gatabɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ɨ re ama rɨka sɨmana gatab tri (3) kɨlok awonj, Yesu b'okta kana ara yikenonj da, “Eli eli lema sabaktani?” —engendena yɨtkak da, “Kor B'u, Kor B'u, nangga pae Man Ken kak nɨaet?” ");
INSERT INTO gdr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ɨ rɨga yepiya re Yesum wusɨnd owɨnki wekenonj, ton kea Yesumna yɨt utkundo, ɨ ton ket endento da, “Onggɨt Rɨgat Eliya na ara yemok.” ");
INSERT INTO gdr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ɨ odenja ket towa wɨngɨrɨnd yɨpa rɨga b'ɨtkonj ɨ ket nyɨ ɨngmatenapu matres pɨla gasa yokatonj ɨ ket tokɨltokɨl ɨk besen wa yɨsonggonj, ɨ dɨde ket soksok buskak ke yɨponj, ngɨrpu ket ɨtemb matres pɨla gasa yurowatonj Yesumna tugɨm wa onayam. ");
INSERT INTO gdr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ajɨ daka nɨnda rɨgap endento da, “Tin yɨrara! Ma be men yɨr yangu Eliyand ɨta rɨka ik dor Tin gou wa omnam.” ");
INSERT INTO gdr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ajɨ Yesu b'usaya ukoi kana ara yikenonj, seg ket wɨngawɨngat Tin yɨraronj. ");
INSERT INTO gdr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ɨ yɨr de, re Ton uj awonj, ɨtemb ukoi gutomgutom kobɨrgɨm rɨna re yɨnametɨnd ewɨrɨnti yɨbnenenonj yɨnayɨna pɨpmet dɨde yɨna pɨpmet ganggand, ɨnyɨnyɨnd b'ɨnyowendonj pumb ke ngɨrpu ama re de gou wa. Ɨ kwa daka gowukoi kea mumamuma aenonj dɨde kea kɨla b'akangka wuwenonj. ");
INSERT INTO gdr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ɨ gopmet kea ɨpangka wuwenonj dɨde ket jogjog yɨna rɨga waina ujgɨm utnɨkto. ");
INSERT INTO gdr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ɨ opimemb rɨga yepiya re gɨmo yɨund oski gopmet ke opekto, ton yɨmta kena yɨna taun Yerusalem wa b'ɨgarkɨto ajɨ Yesut naska utnyitonj. Ɨ onggɨt kak ke ket jogjog rɨgap opimemb rɨga yɨr ongong eyento. ");
INSERT INTO gdr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sɨ ɨtemb Roma andred (100) geja rɨga mopyam yet re Yesund wul b'agbagɨnd ɨdrɨkam mɨle wɨp yomnonj dɨde opimemb geja rɨga yepiya re Yesund yɨr engenda yiyeno, ton kea yɨr angto jijɨg dɨde komkesa mɨle rɨna re aukɨto, sɨ ket ukoijog mogat kea ten akasinonj. Seg ton ket endento da, “Ɨmɨnjog e! Ɨtemb Rɨga re Godɨmna B'ɨga e.” ");
INSERT INTO gdr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ɨ dɨde demb de jogjog kongga daka kea pajapaja Yesund yɨr ɨpkand wekenonj yepiya re Galili eriya ke Yesund yɨmta undoka dɨde yɨm okaena iyo. ");
INSERT INTO gdr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ɨ opimemb kongga wa wɨngɨrɨnd toda kea dɨkɨnd wekenonj, Magdala tunggam Mariya ɨ Yakobo ake Yose towa mog Mariya, ɨ dɨde Jebedaimna b'ɨgawar wa mog. ");
INSERT INTO gdr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ɨ re ket sɨ imokonj, yɨpa jogjog gasa kɨma rɨga Yosep Arimataya tungg ke ikonj yet re todaka yɨpa Yesumna b'auyaena rɨga na yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ɨ ɨtemb rɨga ket yikonj Pilatom pɨlwa dɨde ket tin yerkitonj Yesumna ujgɨm okatam. Sɨ ket Pilato kea geja rɨga engainonj Yesumna ujgɨm ti okawam. ");
INSERT INTO gdr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Seg Yosep ket ujgɨm yokatonj dɨde ket kɨlkesa b'ogɨl kobɨrgɨm ke ponpon yomnɨkonj. ");
INSERT INTO gdr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Re ket seg ton yiyonj tina sisɨl gopmet wa rɨna re ton gɨmo yɨund yeskonj dɨde ket yoramitonj gopmet wɨngɨr wa ɨ dɨde ket ukoi gɨmo ururkena yiyonj onggɨt gɨmo yɨund oski gopmet mora utwangkam. Seg ton ket ɨtemb gopmet ke yiwatonj. ");
INSERT INTO gdr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ɨ demb de Magdala tunggam Mariya dɨde kwa yɨpa ti nyɨmad Mariya kea omiti ebnonda yɨr dea ta gopmet wa. ");
INSERT INTO gdr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ɨ Yesumna ujgɨm gopmet wa yoramito re Ju rɨga waina wɨram dɨde yɨr opmitena bibɨrɨm B'angonjena Bibɨr nat. Sɨ onggɨt penaemb yɨna mopyam sɨ rɨga dɨde Parisai rɨga yɨpand Pilatom pɨlwa wuwonj. ");
INSERT INTO gdr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ɨ ton ket Pilatond yomno da, “Sɨ ukoyam! Sɨn ɨta nonyɨnd yowamu da re ɨtemb b'anygɨnena rɨga yilo yɨbnonj, Ton kea odede yindenonj da, ‘Kon ɨta uj ke tutnyisɨn nowam bibɨrɨnd.’ ");
INSERT INTO gdr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Sɨ onggɨt paemb man b'ingawa yoramite gopmet yɨr engendam ngɨrpu ama ra de nowam bibɨr, nokɨm da ke Tina b'auyaena rɨga tou dɨde yurowam ke Tina ujgɨm yakate. Seg ton ket kwa ke rɨga wumɨr ramneninem da Ton ke uj ke utnyis. Raemb odede tawɨk, rɨna re naska b'anygɨnena yɨt ke bebɨg aukonj re ma ukoi na, ajɨ ɨt re kikitumam b'anygɨnena yɨt ke tawɨk ra ɨtemb re ma sobijog bebɨg e pɨta tainy meranɨm.” ");
INSERT INTO gdr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ɨ ket Pilato ten esmonggainonj da, “Nɨnda yɨr engenda geja rɨga emjina, ɨ ket wuyɨt dɨde waina wumɨr ke danda ondrasya b'obogɨl yɨrgong omnɨkam.” ");
INSERT INTO gdr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Seg ket opimemb yɨna mopyam sɨ rɨga dɨde Parisai rɨga yɨpand geja rɨga kɨma wuwonj gopmet wa dɨde ket so erka mal gopmet mora utwangki gɨmo kumbɨnd yoramito, ngɨrpu ton ket opimemb yɨr engenda geja rɨga engauto b'obogɨl yɨrgong omnɨkam dɨde ket ton ɨtekto. ");
INSERT INTO gdr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ɨ onggɨt Ju rɨga waina wɨram dɨde yɨr opmitena bibɨr seg ke naskajog bibɨr awonj re Sande na, ɨ onggɨt Sande sɨtawarjogɨnd Magdala tunggam Mariya ɨ dɨde ti nyɨmad Mariya ekonda gopmet yɨr ongongɨm. ");
INSERT INTO gdr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ɨ odedend ket ukoi jijɨg awonj, mop nokɨp Yonggyamɨmna aneru ikonj pumb tungg ke dɨde ket gɨmo yɨund oski gopmet mora wa yikonj ɨ dɨde ket ɨtemb gopmet mora utwangki gɨmo yururkitonj. Seg ket ton onggɨt gɨmo kumbɨnd omitonj. ");
INSERT INTO gdr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ɨ ɨtemb aneru tina wɨp re wenmam pɨla na dɨde tina kobɨrgɨm re bɨlbɨljog na raya pɨla o rɨm pɨla. ");
INSERT INTO gdr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sɨ opimemb yɨr engenda geja rɨgap ma sobijog na moga yuwado ɨtemb aneru, sɨ ton kea kaktɨtɨ aukɨto dɨde ket uj rɨga pɨla na ɨtkobɨki wekenonj. ");
INSERT INTO gdr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ɨ ɨtemb aneru osiemb kongga nɨmog amnonj da, “Goro wɨn moga tawa! Mop nokɨp kon wumɨr en da wɨn Yesu na orakam otupya yena re wul b'agbagɨnd yɨdrɨko. ");
INSERT INTO gdr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ajɨ Ton awɨr e dɨkɨnd. Mop nokɨp Ton kea utnyis rɨja na re Ton yindenonj. Tetka! Dɨde yɨr yonga pɨpmet rɨkɨnd re Tina ujgɨm yoramito! ");
INSERT INTO gdr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Sɨ wɨn wanakana eka Tina b'auyaena rɨga wa pɨlwa ɨ ket ten wumɨr tamninya da, ‘Ton kea utnyis uj ke. Yɨr de, Ton naska e yik de Galili wa, ajɨ wɨn yɨmta kaim wuyɨt dem dɨde ket amaemb de wɨn Tin yɨr ongya dem.’ Seg, kor ɨnsimaemb yɨt wen wumɨr omnam.” ");
INSERT INTO gdr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Seg osiemb kongga nɨmog wanakana ɨtemb gɨmo yɨund oski gopmet ke yiwatonda moga kɨma ajɨ ukoijog sam kɨma na, ɨ ton ket b'ɨkonda Tina b'auyaena rɨga wumɨr omnam. ");
INSERT INTO gdr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ɨ nyawɨnd odedend ket Yesu ten wɨpwɨp amnonj dɨde ket amnonj da, “Simesime!” Sɨ osiemb kongga nɨmog Yesum wus wa tetkonda ɨ ket kumsos b'amkonda dɨde ket Tina pɨs esopaya kɨma Tin yewangayonda. ");
INSERT INTO gdr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Seg ket Yesu ten amnonj da, “Goro moga tawa! Eka dɨde Koina gar ke utkunda yɨngganwar wumɨr tamninya da ton wui dem Galili wa ɨ amaemb de Ken yɨr notngi dem.” ");
INSERT INTO gdr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ɨ onggɨt wɨnɨnd re osiemb kongga nɨmog ekonda b'auyaena rɨga wa pɨlwa, todaka kea odedend nɨnda yɨr engenda geja rɨga wuwonj taun wa dɨde ket wumɨr amnento yɨna mopyam sɨ rɨga komkesa mɨle gatab rɨna re aukɨto gopmetɨnd. ");
INSERT INTO gdr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Seg ket yɨna mopyam sɨ rɨgap yɨpand Ju rɨga waina elda rɨga kɨma b'eoma yokato ɨ ket ɨtemb bebɨg gatab yɨt yɨgleneno dɨde ket opimemb geja rɨga wa wulkɨp okawam tɨrɨr yomno. Sɨ ton ket opimemb yɨr engenda geja rɨga wa ukoijog wulkɨp akawo odede yɨt kɨma da, ");
INSERT INTO gdr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Wɨn ɨja na rɨga wumɨr tamnenindam da, ‘Tina b'auyaena rɨgapiya sɨwɨny tui dɨde ket Tin yurowam ke yiyi re sɨn yutungand wekenyɨn.’ ");
INSERT INTO gdr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ɨ ra Roma gabmani mopyam rɨgat onggɨtyam wa gatab yɨdɨr yɨt tutkunj, sɨn ɨta tin nony ngɨmbla omnyu ɨ ket wɨn ɨdenatemb ket maka bebɨgɨnd taukindam.” ");
INSERT INTO gdr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sɨ ket opimemb yɨr engenda geja rɨgap opimemb wulkɨp emdɨto dɨde ket ɨnaemb yɨt warabag yomnɨko rɨja na re yɨna mopyam sɨ rɨga dɨde Ju rɨga waina elda rɨgap ten engauto opurenam. Sɨ kea onggɨtyam yɨt warabag auka yikenonj Ju rɨga wa wɨngɨrɨnd ngɨrpu yu. ");
INSERT INTO gdr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Seg ket ileben (11) b'auyaena rɨga Galili wa wuwonj dɨde ket opekto onggɨt dor wa rɨtade re Yesu ten menonɨm engainonj. ");
INSERT INTO gdr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ɨ re ton Yesund yɨr yongo, ton kea kumsos b'amkɨto Tin ewangayam, ajɨ nɨnda re nonysɨpsɨp nat wekenonj. ");
INSERT INTO gdr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Seg Yesu ikonj towa wus wa dɨde ket ten yɨt amneninonj da, “God kea Kor kupkakupka juwai nokawonj pumb tungg dɨde onggɨt gowukoi yɨr ɨpkam. ");
INSERT INTO gdr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Sɨ onggɨt paemb wɨn wuwene komkesa b'engabenga yɨtam rɨga wa pɨlwa dɨde ket rɨga tamnɨkindam b'auyaena rɨga awowɨm, ɨ ket opimemb rɨga baptiso omnɨka teyenindam B'uɨm nyɨ kɨma ɨ B'ɨgam nyɨ kɨma ɨ dɨde Yɨnayɨna Wɨngawɨngam nyɨ kɨma. ");
INSERT INTO gdr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ɨ ket wɨn opimemb rɨga ouyaena teyenindam komkesa yɨtkak owamam rɨna re Kon wen engaeninond. Sɨ yɨr de, Kon ɨta wɨn kɨma ita wɨnɨnd ngɨrpu ama ra de onggɨt gowukoi kikitumjog bibɨr wa.” ");
INSERT INTO gdr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ɨtemb jɨ Yesu Keriso, Godɨm b'ɨgamna otobarki b'ogɨl yɨrkokar bage yɨt. ");
INSERT INTO gdr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Sɨ ɨja emb jɨ baptiso Yoan gatab ɨrɨki yɨbɨm bageyam Isayamna peband da, “Man yɨr de, ɨta kon koina bageyam ɨtmɨkisɨn dem mor naska nya wa. Tonte nya motngonjenau dem. ");
INSERT INTO gdr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ɨ dɨde ɨta ukoi ara b'emoka pɨta tainy dem wul kesa tunggɨnd da, ‘Wɨn Yonggyamɨm nya ɨspɨkaindam, ɨ Tina menonpu nya dɨmdɨm omnɨkaindam.’” ");
INSERT INTO gdr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Sɨ ket Yoan yikonj wul kesa tungg wa, ɨ ket rɨga baptiso amnɨkinonj dɨde ket engenda baptiso yɨt pɨtapɨta yomnenonj negɨr mɨle ewaikitam gar ke. ");
INSERT INTO gdr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Sɨ kupkakupka Yuda eriya ke dɨde komkesa Yerusalem ke rɨga wuwenonj ti pɨlwa. Ɨ rɨgap towalenggyam towaina omnɨki negɨr mɨle pɨtapɨta omnena eyento, ngɨrpu onggɨt kak ke ket baptiso yokateno Yoanɨm pɨlke Yordan kɨlɨmɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yoan kobɨrgɨm b'ikoki eyenonj tina jɨwɨnd re kamel ngɨi ke omnɨki na, ajɨ ma b'ogɨl na. Ɨ kwa ton rob b'ibgi yiyenonj re b'angga gɨm ke omnɨki na, ajɨ ma b'ogɨl na. Ɨ dɨde ti owou re nok na koka ake tɨbam wui. ");
INSERT INTO gdr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ɨ ɨja naemb jɨ ton yɨtkak pɨtapɨta yomnenonj da, “Kor kak ke ɨta ik yɨpa dandajog rɨga yaina danda re Ti pumbjog wa e ajɨ koina re goujog wa e. Sɨ kon makwa rɨrɨr en uwontam Tina yongɨnkak kai ɨtrekam rɨna ra goujog wɨko rɨgat mɨle omnɨk obayamɨm pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Sɨ kon nyɨ kaim wen baptiso amnɨkinyɨn, ajɨ Ton Yɨnayɨna Wɨngawɨnga kaim wen baptiso tamnɨkiny dem.” ");
INSERT INTO gdr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ɨ re Yoan rɨga baptiso amnɨkinonj, Yesu ikonj Najaret tungg ke Galili eriya wɨngɨrɨnd, dɨde ton ket baptiso yokatonj Yoanɨm pɨlke Yordan kɨlɨmɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sɨ re Yesu sisɨl opendonj nyɨ ke, ɨ odenja wub kumb yɨr yongonj ɨpangendand dɨde Yɨnayɨna Wɨngawɨnga eyouka ikonj ti pɨlwa ɨja na ɨt re gimai re dɨde. ");
INSERT INTO gdr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ɨ ket ara ikonj wub kumb ke da, “Man re Koina b'ɨga et yena re Kon singi yiyenyɨn. Ɨ Kon ukoi sam en Mornɨm.” ");
INSERT INTO gdr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ɨ odenja Yɨnayɨna Wɨngawɨngat Tin yɨtmɨkitonj deta wul kesa tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Sɨ adea ta Ton yɨbnonj wul kesa tungg wa poti (40) bibɨr kɨma, dɨde ademb jɨ Ton otonkena yokatenonj Satanam pɨlke. Ɨ Ton tɨbam b'angga kɨma na yɨbnonj dɨde anerupiya tin yɨr ɨpka yiyeno. ");
INSERT INTO gdr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ɨ re ket King Erod Yoanɨnd sɨbɨbmet wa yoramitonj, onggɨt kak ke Yesu ket yikonj Galili wa, God ma b'ogɨl yɨrkokar bage yɨt pɨtapɨta omnena yiyonj da, ");
INSERT INTO gdr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Ɨtemb jɨ ket Godɨmna obagendi wɨn rɨrɨr ainy, God ma pumb tungg ke wa wus nate ainy. Sɨ wɨn negɨr mɨle ke gar engenjinam de Godɨm pɨlwa, dɨde gar ke utkunda ke yokata God ma b'ogɨl yɨrkokar bage yɨt.” ");
INSERT INTO gdr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yɨpa wɨnɨnd, re Yesu ton ket menon yokatonj Galili sɨpa yurund, Ton ket nɨmog nanyɨnggan yɨr angonj, Simon ake Andrea. Ɨ onggɨt wɨnɨnd osiemb nanyɨnggan sɨpa wa gɨr b'ɨskena nat ebnonda, nokɨp ton re kabum ɨwɨka rɨga na ebnonda. ");
INSERT INTO gdr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ngɨrpu ket Yesu ara emokonj da, “Ayo tetka! Yɨmta nundoka! Ɨ Kon rɨga ɨwɨka rɨga mi wen tamnyɨn odede rɨngmi re wɨn kabum ɨwɨka eyeninya.” ");
INSERT INTO gdr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ɨ odenja ton gɨr erarkinonda dɨde ton ket Tin yɨmta yundokonda. ");
INSERT INTO gdr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ɨ ɨngkek ket Yesu sobijog b'ɨsonkitonj, kea ton yɨr angonj Jebedaimna b'ɨga nɨmog Yakobo ake ti yɨnggan Yoan, gɨr ongonjenand gɨgand. ");
INSERT INTO gdr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ɨ odenja Yesu ket ten ara emokonj Tin yɨmta undokam. Seg ton ket nanyɨngganɨp towa b'u Jebedaind yɨraronda gɨgand towaina wɨko rɨga kɨma, ɨ ton ket Yesund yɨmta yundokonda. ");
INSERT INTO gdr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ɨ ton wuwonj de Kaparnaum wa. Re ket Ju rɨga waina wɨram dɨde yɨr opmitena bibɨr awonj, odenja ket Yesu yikonj de Ju rɨga waina yɨr opmitenapu met wa, ɨ Ton ket rɨga auyaeninonj. ");
INSERT INTO gdr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Sɨ rɨgap ma sobijog na kɨd kesa aento Tina ouyaena ke. Mop nokɨp Ton auyaeninonj re odede na ɨt re Godɨmna danda kɨma rɨga re dɨde, ajɨ ma ɨja na ɨte re Ju rɨga waina gog ouyaena rɨga re dɨde. ");
INSERT INTO gdr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ɨ demb de onggɨt Ju rɨga waina yɨr opmitenapu met wa kea de ton yɨpa negɨr kɨlkɨl wɨngawɨnga ma okati rɨga yɨbnonj. Ɨ odenja ton irere kɨma b'okta ara yikenonj ");
INSERT INTO gdr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","odede yɨt kɨma da, “Yesu Najaret tunggam! Nanggamog e Man sowa pɨlɨnd singi yomnyɨt? Rɨngma, Man negɨr omna mim sɨn notupinyɨt? Kon wumɨr en yetet Man. Man re Godɨmna yɨnayɨna B'ɨgatet.” ");
INSERT INTO gdr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ajɨ Yesu ɨtemb jɨ negɨr wɨngawɨnga samany yiyowonj da, “Muma kesa ae! Or opende ti pɨlke!” ");
INSERT INTO gdr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yesumna yɨtɨp ket ɨtemb negɨr wɨngawɨngat ɨtemb rɨga ɨsanikesa yɨjgɨndenonj. Ɨ ton ket ukoi kana ara yikenonj, ngɨrpu opendonj rɨgam pɨlke. ");
INSERT INTO gdr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ɨ komkesa rɨga onggɨt b'eoma wɨngɨrɨnd ma sobijog na ton kɨd kesa aena wuwenonj ɨ towalenggyam b'arkena wuwenonj da, “Wɨi, nangga e jɨ? Sisɨl b'auyaena e, danda kɨma e. Ɨ negɨr kɨlkɨl wɨngawɨngap kea daka tin yɨt yutkunji ɨte re ton b'ingawa yoramiteny towa pɨlɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ɨ rawɨr kwa pɨn komkesa yɨt yikenonj Yesumna kɨd kesa kɨma danda wɨko gatab komkesa Galili eriya wɨngɨr nata. ");
INSERT INTO gdr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Re ket seg, odenja Yesu Ju rɨga waina yɨr opmitenapu met yɨraronj. Ɨ Ton ket yikonj Yakobo ake Yoan kɨma de Simon ake Andrea waina met wa. ");
INSERT INTO gdr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ɨ Simonɨm konggayam jeam re pas nat wɨbnonj juwar map. Odenja ton ket Yesund wumɨr yomno ti gatab. ");
INSERT INTO gdr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ɨ re ket Yesu yikonj de Simonɨmna jeamɨm pɨlwa, Ton ket kea yɨm ke wokatonj ɨ ket wurowatonj. Seg ket juwarɨt tin wɨraronj, sɨ ton ket Yesund dɨde Ton kɨma meni rɨga yɨm akainonj. ");
INSERT INTO gdr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Onggɨt sɨ imokand, lom ipanjɨki kak ke, kea rɨgap eyento komkesa kopa rɨga ɨ negɨr wɨngawɨnga ma okati rɨga de Yesum pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ɨ ket komkesa rɨga onggɨt taunɨnd bobo auka wuwenonj mora wa. ");
INSERT INTO gdr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ɨ Yesu esakenjinonj jogjog kopa rɨga yepiya re b'engabenga wɨp kopa kɨma wuwenonj, dɨde kwa ton jogjog negɨr wɨngawɨnga eaukena eyeninonj rɨga wa pɨlke. Ajɨ ton maka enjɨkisinonj negɨr wɨngawɨnga yɨt opurenam, mop nokɨp ton get ke wumɨr na da Yesute. ");
INSERT INTO gdr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sɨwɨny borand momta ɨsparkand ket, Yesu utnyitonj dɨde yikonj deta tintawar wa, ɨ ademb ta ket ton yɨr opmitenonj, ");
INSERT INTO gdr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ngɨrpu ket Simon Yesund oraka yiyonj nɨnda ti rɨgawar kɨma. ");
INSERT INTO gdr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Re ket yodaro, Yesund wumɨr yomno da, “Wɨi, komkesa rɨgap oraka miyenyi.” ");
INSERT INTO gdr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ɨ Yesu daka ket amninonj da, “Tuyɨm! Men wuyɨn ta b'enga gatab wa deta nɨnda wuswus tungg wa, nokɨm da ɨdenat Kon towa daka Godɨmna yɨt pɨtapɨta tamnenainyɨn. Mop nokɨp Kon onggɨt mop penaemb netkond onggɨt gowukoi wa.” ");
INSERT INTO gdr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Sɨ re Yesu ket yikenonj kupkakupka Galili eriya wɨngɨrɨnd, ton ket Godɨmna yɨt ouyaena eyeninonj Ju rɨga waina yɨr opmitenapu met nata, dɨde kwa ton negɨr wɨngawɨnga eaukena eyeninonj rɨga wa pɨlke. ");
INSERT INTO gdr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ngɨrpu ket yɨpa leprosi kopa rɨga ikonj de Yesum pɨlwa, kumsos b'amkonj, ɨ Yesum pɨlwa b'ɨtena yoramitonj da, “Ra Man singi taet, Man rɨrɨr e ken kɨlkɨp kesa notɨnyɨt.” ");
INSERT INTO gdr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Sɨ Yesu re ma sobijog na kear yomnonj, ɨngkek ket yɨm b'ɨtnɨkonj dɨde ket tin yesopayonj odede yɨt kɨma da, “Kon ɨta singi. Kɨlkɨp kesa ae!” ");
INSERT INTO gdr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Sɨ odenja ket ɨt ra leprosit tin yɨraronj, ngɨrpu ton ket b'ɨsakendonj dɨde ket kɨlkɨp kesa awonj. ");
INSERT INTO gdr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Seg Yesu ket ɨtemb jɨ rɨga yɨt ke ukoi danda kɨma odede nonony yomnonj da, “Yɨr de, goro yama na usekainɨm dor. Ajɨ meke dɨde ket molenggyam b'atouyaet yɨna sɨ rɨgam pɨlwa. Ra ton ɨmjas dor da, ‘Kea man ɨmɨnjog b'ogɨl dɨde kɨlkɨp kesa aet,’ sɨ man ket Godɨm sɨ gasa tanggɨkinyɨt dor ɨ eyinyɨt de yɨna sɨ rɨgam pɨlwa sɨ omnɨkam rɨna re Mose b'ingawa yoramitonj. Nokɨm da ɨdenat ton mɨtɨmjas rɨga wa wɨpɨnd da, ‘Man kea b'ɨsakenjɨt dɨde kɨlkɨp kesa aet.’” ");
INSERT INTO gdr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ajɨ re ton Yesum pɨlke ewaikitonj, ita ton ket yɨt pɨtapɨta yomnenonj dɨde yɨt ukoi warabag omnɨka yiyenonj. Onggɨt mopɨp ket Yesum ma rɨrɨr na awonj taun wa menamenam pɨtand. Sɨ ton adea ta taun bau ke rɨga kesa tungg nata yɨbnonj, ajɨ kea tin kwa rɨgap yodareno komkesa gatab ke. ");
INSERT INTO gdr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nɨnda bibɨr kak ke Yesu kwa b'usaya b'ɨgaronj de Kaparnaum taun kara bora wa. Ɨ yɨdɨr yɨt re kea yikenonj ket da ɨta Ton de onggɨt met wa. ");
INSERT INTO gdr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ɨ re ket jogjog rɨga bobo auka wuwenonj onggɨt met wa rɨkɨnd re Yesu yɨbnonj, sɨ ɨtemb met re kea gangga kesa awonj dea ta ngɨrpu mora dunda wa dɨde daka kwa mora bau ke. Ɨ Yesu ket God ma yɨt usenenainonj. ");
INSERT INTO gdr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ɨ ngɨrpu ket nɨnda rɨgap yɨpa dɨmɨr kopa rɨga tɨtɨnd iyo Yesum pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ajɨ towanɨm re ma rɨrɨr na kopa rɨga iyoyɨm de Yesum pɨlwa rɨga jogjogɨp. Ton ket bau ke tɨt na ket ɨjo ɨ wuwonj de ket met papkak kumb wa, ngɨrpu ket ton tumɨnd ouki gasa yotorko, ɨ Yesum tunkɨpɨnd bora yomnɨko. Re ket seg, ɨ ket ɨtemb tɨt rɨkɨnd re dɨmɨr kopa rɨga yutungi yɨbnonj, inka yiyo de Yesum wɨp wa. ");
INSERT INTO gdr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Sɨ re Yesu towaina gar ke utkunda yɨr yongonj, Ton yomnonj ket ɨtemb dɨmɨr kopa rɨgand da, “B'ɨga! Moina negɨr mɨle kemb awɨr auranj.” ");
INSERT INTO gdr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ajɨ nɨnda Ju rɨga waina gog ouyaena rɨga yepiya re de wekenonj, ton towaina garɨnd b'arkena wuwenonj ");
INSERT INTO gdr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","da, “Nangga mop pae ton rɨga jɨ odede yɨt apureniny? God na yɨsadreny. Yete rɨrɨr e negɨr mɨle awɨr omnɨkam? Ajɨ Godta tinta yɨpaina.” ");
INSERT INTO gdr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ɨ kea ton Yesu odenja tina wɨngawɨnga ke wumɨr yokatonj rɨja na re Ju rɨga waina gog ouyaena rɨgap Tin yɨt yɨpateno towaina garɨnd. Yesu ket amninonj da, “Nangga pae wɨn odede b'iklawa yɨt yiyenya waina garɨnd? ");
INSERT INTO gdr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Rɨnte yɨt opulitam wewa ainy de ɨtemb dɨmɨr kopa rɨgam pɨlwa da, ‘Mor negɨr mɨle kemb awɨr auranj,’ o omnam da ‘Utnyite! Tɨt yurowate, ɨ menon yokate'? ");
INSERT INTO gdr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ajɨ Kon yɨpa gasa e omnɨken wen ouyawam da Rɨgamna B'ɨgam ɨta Tina danda gowukoyɨnd negɨr mɨle awɨr omnɨkam.” Ɨ Ton ket dɨmɨr kopa rɨgand yomnonj ");
INSERT INTO gdr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","da, “Kon motɨnyɨn. Utnyite, moina tɨt yurowate, ɨ moina met wa meke!” ");
INSERT INTO gdr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Seg re ket dɨmɨr kopa rɨga utnyitonj, odenja tɨt yurowatonj, ngɨrpu ket menon yokatonj rɨga wa wɨpɨnd. Onggɨt mopɨp komkesa rɨga kɨd kesa aukɨto ɨ odedep ket Godɨnd yesoureno odede yɨt kɨma da, “Makwa sɨn odede wɨp gasa yɨr yongonda naskand.” ");
INSERT INTO gdr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ɨ re Yesu kwa ket yikonj sɨpa yurund, ukoi rɨga bobo wuwenonj Ti pɨlwa, ngɨrpu Ton ket ten auyaeninonj. ");
INSERT INTO gdr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ɨ re Yesu ɨtemb pɨpmet yɨraronj, Ton kea Alpayomna b'ɨga Lebind yɨr yongonj omiti teks imdapu metɨnd, dɨde ket tin yomnonj da, “Yɨmta nundoke!” Ngɨrpu ket Lebi utnyitonj dɨde ket Yesund yɨmta yundokonj. ");
INSERT INTO gdr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ɨ re ket Yesu diyam awowɨnd yɨbnonj Lebimna metɨnd, sɨ jogjog teks imdayam rɨga dɨde negɨr mɨleyam rɨga kea de wuwenonj onggɨt met wa ɨ ket Yesu dɨde Tina b'auyaena rɨga kɨma yɨpand diyam aukɨto. Mop nokɨp ma yɨpa kɨma odede rɨgapiya Yesund yɨmta yundoko. ");
INSERT INTO gdr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ɨ Parisai rɨga wa wɨngɨrɨnd nɨnda Ju rɨga waina gog ouyaena rɨgap kea Yesund yɨr yongo diyam awowɨnd yɨpand negɨr mɨleyam dɨde teks imdayam kɨma. Onggɨt kak ke ket, ton Yesumna b'auyaena rɨga egekitto da, “Nangga mop pae Ton diyam ainy yɨpand teks imdayam dɨde negɨr mɨleyam kɨma?” ");
INSERT INTO gdr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ɨ re Yesu odede yɨt utkundonj, Ton ket ten amninonj da, “Ma kopa kesa rɨgapim dokta singi omnyi, ajɨ kopa kɨma rɨgapim. Kon ma negɨr mɨle kesa rɨga na tatupinond engendam negɨr mɨlem pɨlke de Godɨm pɨlwa, ajɨ negɨr mɨle kɨma rɨga na.” ");
INSERT INTO gdr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yoanɨmna b'auyaena rɨga dɨde Parisai rɨga re owou uwabɨka wɨn na yokateno, ajɨ Yesumna b'auyaena rɨgap re maka yokateno. Sɨ onggɨt penaemb kea nɨnda rɨga tuwonj Yesum pɨlwa dɨde ket Tin yerkeno da, “Nangga pae Yoanɨmna b'auyaena rɨga dɨde Parisai rɨga waina b'auyaena rɨgap owou uwabɨka wɨn yokatenyi, ajɨ moina b'auyaena rɨgap re ma ɨta ton owou uwabɨka wɨn yokatenyi?” ");
INSERT INTO gdr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ɨ Yesu ten mɨra amninonj da, “Rɨngma, rɨrɨr e ton sisɨl kongga kɨma rɨgamna rɨgawarɨp owou uwabɨka wɨn okasi, ra ton sisɨl kongga kɨma rɨga dɨkɨnda towa wɨngɨrɨnd ɨbɨm? Ma rɨrɨr e towanɨm owou uwabɨka wɨn okatam. Mop nokɨp sisɨl kongga kɨma rɨga re ɨta dɨkɨnd ton kɨma yɨpand yɨbɨm. ");
INSERT INTO gdr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ajɨ ɨta wɨn ik dem, ra sisɨl kongga kɨma rɨgat tewaikis dem towa pɨlke, sɨ onggɨt wɨn natemb dem ton ket owou uwabɨka wɨn okatenyi dem. ");
INSERT INTO gdr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Makwa ɨta yɨpa rɨgat sisɨl kobɨrgɨm kɨb ke kesam kobɨrgɨm bora pasi omɨny. Ra ton odede pasi omɨny ɨ dɨde ra ɨtemb pasi omni kobɨrgɨm nyɨ ke ɨsek, ɨta sisɨl kobɨrgɨm kɨb b'itɨnkur ajɨ kesam kobɨrgɨm ma ɨta b'itɨnkur. Sɨ onggɨt paemb ɨtemb sisɨl kobɨrgɨm kɨbɨt ɨta kesam kobɨrgɨm ɨnyowɨk dor pasi omnipund. Sɨ negɨrjog ukoi bora emb ket pɨta tainy. ");
INSERT INTO gdr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ɨ dɨde makwa yɨpa rɨgat ɨta sisɨl ɨk tangjɨkiny kesam b'angga gɨm ke omnɨki ɨk ga wa. Mop nokɨp sisɨl ɨk ɨta ɨnɨka ik, ajɨ kesam b'angga gɨm ke omnɨki ɨk ga ra ma ɨta warabag tawɨk. Sɨ ra ton odede omnɨk, ɨtemb sisɨl ɨkɨt opima onggɨtyam kesam b'angga gɨm ke omnɨki ɨk ga temkiny. Ɨ komkesa negɨr taukanj, ɨk dɨde b'angga gɨm ke omnɨki ɨk ga. Ajɨ sisɨl ɨk im tangjɨkiny de sisɨl b'angga gɨm ke omnɨki ɨk ga wa.” ");
INSERT INTO gdr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yɨpa Ju rɨga waina wɨram dɨde yɨr opmitena bibɨrɨnd Yesu Tina b'auyaena rɨga kɨma wit sopapu yuru nata yikonj. Towa menon wɨngɨrɨnd, Yesumna b'auyaena rɨgap ket wit kolkak yɨpayɨpa utouka eyento. ");
INSERT INTO gdr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ɨ Parisai rɨgap ket Yesund yomno da, “Yɨr de, nangga pae ton Moina b'auyaena rɨgap onggɨtyam mɨle yomnɨki rɨnte re ma yiyag e omnɨkam meraina wɨram dɨde yɨr opmitena bibɨrɨnd?” ");
INSERT INTO gdr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ɨ Yesu ten mɨra amninonj da, “Ma ke wɨn yɨna peba yogenkonda onggɨtyam yɨtkak gatab rɨna re Dawid Mosemna gog yɨt yerbekonj, re ton dɨde ton kɨma meni rɨga gasa b'arakand dɨde owoupand wekenonj? ");
INSERT INTO gdr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Sɨ onggɨt wɨnɨnd re Abiyatar yɨna mopyam sɨ rɨga yɨbnonj, rɨdede na ton b'ɨgaronj Godɨmna yɨnamet wa? Ɨ rɨdede na ton yɨna sana awinonj rɨna re gog yɨbnonj komkesa rɨga wa owowɨm ajɨ yɨna sɨ rɨga wa nena ma owou? Ɨ kwa daka rɨdede na ton onggɨtyam yɨna sana nɨnda ton kɨma meni rɨga wa akainonj?” ");
INSERT INTO gdr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ɨ Yesu kwa amninonj da, “God re meraina wɨram dɨde yɨr opmitena bibɨr yoramitonj rɨgam b'ogɨl mana, ajɨ rɨga re yomnɨkonj ma meraina wɨram dɨde yɨr opmitena bibɨrɨm b'ogɨl mana. ");
INSERT INTO gdr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Sɨ onggɨt paemb Rɨgamna B'ɨga re Yonggyam e komkesa bibɨrɨm, dɨde kwa tonta Ju rɨga waina wɨram dɨde yɨr opmitena bibɨrɨm Yonggyam.” ");
INSERT INTO gdr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu yikonj b'usaya kwa de Ju rɨga waina yɨr opmitenapu met wa. Ɨ onggɨt metɨnd kea de yɨpa yɨm b'ɨkɨki kopa rɨga yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ɨ kea de nɨnda rɨga wekenonj, ɨ ton ket Yesund wuswus yɨr ɨpka yiyeno da, “Ɨta yama dor meraina wɨram dɨde yɨr opmitena bibɨrɨnd Yesu onggɨt kopa rɨgand ɨsakenj.” Nokɨm da ɨdenat ton Yesum rɨl odarai Tin kot wa oramitam. ");
INSERT INTO gdr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sɨ Yesu onggɨt yɨm b'ɨkɨki kopa rɨgand yomnonj da, “Metkɨm, onyite dɨkɨnd wɨp wa!” ");
INSERT INTO gdr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ngɨrpu ket ten amninonj da, “Rɨngma! Meraina wɨram dɨde yɨr opmitena bibɨrɨnd nangga mog gog e b'ogɨljog tainy, gasa b'ogɨl omnɨkam o mɨnda negɨr omnɨkam? Rɨngma, yɨrkokar okawam, o mɨnda ongandam?” Ajɨ Yesu ma yɨtɨt towaina gar edokinonj, sɨ ton mumakesa yɨr nena na b'epkɨto. ");
INSERT INTO gdr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ɨ Yesu ket ukoi soro kɨma yɨrɨk unjomkena eyeninonj, ɨ dɨde ket gar yii yindonj, nokɨp towaina gɨmo pɨla gar re ɨdoki na. Ton yindonj onggɨt kopa rɨgam pɨlwa da, “Moina yɨm b'ɨtnɨke!” Sɨ ton ket tina yɨm b'ɨtnɨkonj dɨde ket ɨtemb tina yɨm kupkakupka b'ɨsakendonj ɨja na ɨt re yɨpa tab yɨm re dɨde. ");
INSERT INTO gdr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Seg, Parisai rɨgap opekto, dɨde ket odenja Erodɨmna yɨmta undoka rɨgawar kɨma wɨpwɨp auto, ɨ ket gɨlgɨl yɨtnono aento da, “Rɨdede nya kae Yesund onganju.” ");
INSERT INTO gdr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ɨ Yesu tungg ke yiwatonj ɨ opendonj de Galili sɨpa yuru wa Tina b'auyaena rɨga kɨma. Ɨ kea ukoi rɨga bobo wuwenonj Galili eriya ke, ɨ kea ket Tin yɨmta yundoko. ");
INSERT INTO gdr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ɨ kwa rɨga jogjog wuwenonj Yesum pɨlwa Yuda eriya ke, ukoijog taun Yerusalem ke, Idumeya eriya ke, b'enga tab ke de Yordan kɨlɨmɨnd, ɨ Tiro dɨde Sidon eriya gatab ke. Mop nokɨp ton kea utkundento komkesa mɨle gatab yɨt rɨngmana re Yesu amnɨkinonj. ");
INSERT INTO gdr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sɨ re rɨga bobo ɨsanikesa Ti pɨlwa wuwenonj, Ton yindonj Tina b'auyaena rɨga wa pɨlwa da, “Gɨga b'ɨga ongonjeni na nebnau. Nokɨp ke rɨgap Ken ukoi kana negɨr namnɨke!” ");
INSERT INTO gdr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mop nokɨp Yesu kea kopa ke jogjog rɨga ɨsagɨka eyeninonj, sɨ ket komkesa kopa kɨma rɨga ɨsanikesa b'asmurena wuwenonj Ti pɨlwa Tina jɨ esopayam. ");
INSERT INTO gdr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Onggɨt wɨnɨnd, re negɨr wɨngawɨngap Yesund yɨr yongo, Ti pɨlwa sap otekto ɨ dɨde ket b'okta ara wuwenonj da, “Man re Godɨmna B'ɨga et.” ");
INSERT INTO gdr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ɨ Yesu ket ukoi danda kɨma ten eswanginonj da, “Goro ket pɨtapɨta notɨnenya!” ");
INSERT INTO gdr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ɨ Yesu yɨpa dor yoglonj dɨde ket Tina ɨsamki rɨga ara emokinonj. Seg ton ket wuwenonj Yesum pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Seg ket Yesu Twelp (12) rɨga abagenjinonj ɨ nyɨ aekinonj da ɨtmɨkitijog rɨga, nokɨm da ɨdenat ton wɨmena tuweny Ton kɨma dɨde ɨdenat Ton ten tetmɨkeniny God ma yɨt pɨtapɨta omnenam, ");
INSERT INTO gdr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ɨ dɨde kwa ɨdenat towa danda tagoniny negɨr wɨngawɨnga eaukenam rɨga wa pɨlke. ");
INSERT INTO gdr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Sɨ Ton Twelp (12) ɨtmɨkitijog rɨga abagenjinonj re nyɨ opimemb, Simon ya mana re Yesu yɨpa nyɨ yokawonj Petro, ");
INSERT INTO gdr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jebedaimna b'ɨga Yakobo dɨde ti yɨnggan Yoan yami re Yesu kwa yɨpa nyɨ towa akawonj Boanerge ongwatam yɨtkak da ɨaram b'ɨga, ");
INSERT INTO gdr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrea, Pilip, Batolomeo, Matayo, Toma, Alpayomna b'ɨga Yakobo, Tadayo, Kanana rɨga Simon, ");
INSERT INTO gdr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","dɨde Yudas Iskariyot yet re Yesund tɨb yiyonj negɨr omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Onggɨt kak ke ket Yesu yikonj yɨpa met wa. Ɨ ket rɨga kwa b'usaya bobo auka wuwenonj Ti pɨlwa. Onggɨt penaemb Ton dɨde Tina b'auyaena rɨga wa ma rɨrɨr na awonj gangga okatam towa diyam owowɨm. ");
INSERT INTO gdr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Re ket Yesum mog ake Ti yɨngganwarɨp Ti gatab odede yɨt utkundo da rɨgap endenanj da, “Ton nony kesa e.” Sɨ onggɨt penaemb ton ket wuwonj de onggɨt met wa Tin okatam ɨ iyoyɨm de tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ɨ nɨnda Ju rɨga waina gog ouyaena rɨgap yepiya re wuwenonj Yerusalem taun ke, ton endento da, “Negɨr wɨngawɨnga waina mopyam Satana, nyɨ da Beeljebul, tonte Yesund yokas. Sɨ Ton onggɨt Beeljebulɨmna danda kena negɨr wɨngawɨnga eaukeniny.” ");
INSERT INTO gdr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Sɨ Yesu ten ara emokinonj dɨde tendam yɨt ke ten amninonj da, “Rɨrɨr e Satana eaukeny Satanand? Ma rɨrɨr e. ");
INSERT INTO gdr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ɨ ra yɨpa kantri rɨgap towalenggyam wetaweta taukanj dɨde b'itpouranj, onggɨt kantrim ma rɨrɨr e ti onyita. ");
INSERT INTO gdr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Dɨde ra yɨpa gu rɨgap towalenggyam wetaweta taukanj dɨde b'itpouranj, onggɨt guwɨm ma rɨrɨr e ti onyita. ");
INSERT INTO gdr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sɨ kwa ra Satana geja b'itiyeny tina negɨr wɨngawɨnga kɨma dɨde wetaweta tauranj, ma rɨrɨr e ti onyita, ɨtemb ti ngɨrpu dɨkɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ɨ makwa yɨpa rɨgat rɨrɨr e yɨpa danda rɨgamna met wa b'aturɨk dɨde tina gasa yurowam ke temjiny, ra maka ra ton naska ɨtemb danda rɨgand ɨjobɨk. Ajɨ naska ton b'ogla danda rɨgand ɨjobɨk ɨ yɨmta kae ton ket yurowam ke temjiny tina gasa komkesa leamog im re wekeny tina metɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ɨ Kon ɨmɨnjog wen tamninyɨn. Rɨgap re opima negɨr mɨle amnɨkenenanj dɨde Godɨnd ɨsadrena yiyenyi. Ajɨ God opima onggɨtyam komkesa negɨr mɨle dɨde Godɨnd ɨsadrena mɨle teomneniny dem rɨga wa pɨlke. ");
INSERT INTO gdr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ajɨ ra rɨgat Yɨnayɨna Wɨngawɨngand ɨsadreny, God makwa ɨta onggɨtyam tina negɨr mɨle awɨr omnau dem dadal ngɨrpu kesa. Ajɨ ton ɨtemb rɨga negɨr mɨlem pɨlke dadal ngɨrpu kesa negɨr mɨra e okateny dem.” ");
INSERT INTO gdr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nok pena Yesu onggɨt gatab yindenonj, nokɨp nɨnda rɨgap opurena yiyeno da, “Yesu re ton negɨr wɨngawɨnga kɨma e yɨbɨm.” ");
INSERT INTO gdr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yesu ma mog dɨde Ti yɨngganwar wuwonj yɨpa met wa rɨkɨnd re Yesu yɨbnonj. Re ket pund owɨnkɨto, ɨ kwa ton ket bage yɨt yɨtmɨkito da, “Mor mog dɨde yɨngganwar opima pu wa yɨr mungai.” ");
INSERT INTO gdr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Sɨ leamog rɨga na re Yesu kɨma omnɨki wekenonj wɨngɨr wa, ton ket Yesum yɨt ɨtmaikena yiyawo da, “Wɨi, Mor mog dɨde Moina yɨngganwar opima Men yɨr mungai pu wa, ɨ Mena orakam motupi.” ");
INSERT INTO gdr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Seg ket Yesu mɨra amninonj da, “Yepim Kor mog dɨde Koina yɨngganwar?” ");
INSERT INTO gdr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yesu rɨga yɨrɨk unjomkeninonj yepiya re Tin yewatɨnto dɨde omnɨki wekenonj. Ɨ ton ket ten amninonj da, “Yɨr de, opimemb jɨ Kor mogwar dɨde Koina yɨngganwar! ");
INSERT INTO gdr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sɨ yet ra mɨle omnɨka teyeniny God ma singind rɨnsim re God ma yɨna pebap apurenanj, ton re Koina yɨnggan e, ton re Koina ngɨmɨr o, ɨ dɨde ton re Kor mog o.” ");
INSERT INTO gdr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ɨ re Yesu b'usaya ouyaena yotomonj Galili Sɨpa yurund, ukoijog rɨga bobo auka wuwenonj Ti pɨlwa dɨde Tin yewatɨnto. Ɨ onggɨt mop penaemb Ton ma rɨrɨr na rɨga ouyaena. Sɨ onggɨt penaemb Ton ket sobijog gɨga yokatonj dɨde omitonj gɨgand, nokɨm da ɨdenat Ton rɨga wa pɨlke gangga okas. Seg ket, rɨga bobo sɨpa yurund nyɨ ngɨrpund wekenonj Tina yɨt utkundam. ");
INSERT INTO gdr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ɨ Ton ket jogjog tendam yɨt ke ten auyaeninonj. Ɨtemb jɨ ket Tina yɨpa ouyaeni tendam yɨt, ");
INSERT INTO gdr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Utkunjinam! Yɨr, yɨpa wala rɨga tuny ɨgmarkam yikonj sopapu wa. ");
INSERT INTO gdr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ɨ re ton tuny egmarkinonj, nɨnda tuny ɨsokto nyawɨnd, ɨngkek ket ngena tuwonj, ɨ ket komkesa tuny auto. ");
INSERT INTO gdr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ɨ kwa nɨnda tuny ɨsokto gɨmo gou nat rɨkɨnd re ma jog gou wekenonj. Ɨ odenja wanaka ɨkkɨto, mop nokɨp gou re bab tum nat wekenonj ɨ dɨde tunyɨp kea wanakana pemb yokato. ");
INSERT INTO gdr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ɨ re ket lomkongga ɨlitonj, sɨ nangg kea yarɨmyarɨm aukɨto, mop nokɨp ap re ma rɨrɨr na gɨmo bora wa b'ɨgarenam. ");
INSERT INTO gdr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ɨ kwa nɨnda tuny ɨsokto wanjametɨnd. Seg ket wanja wanakana owɨnkɨto, ɨ ket kea nangg ekangɨnto. Sɨ onggɨt penaemb ton maka kɨp aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ɨ kwa nɨnda tuny ɨsokto b'ogɨl sal gowɨnd. Seg ton ket ɨkkɨto, ɨ ket owɨnkɨto dɨde ket ton kɨp ɨjagɨkto. Sɨ re kɨp aukɨto, nɨnda tuny re teti (30) kɨp, ɨ nɨnda re siksti (60) kɨp, ɨ kwa nɨnda re andred (100) kɨp.” ");
INSERT INTO gdr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yɨt seg re ket, Yesu yindonj da, “Yete re man wɨngawɨnga ke yɨpya kɨma, man utkunde!” ");
INSERT INTO gdr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ɨ Tina yɨt seg ke rɨga wetaweta aukɨto, ɨ ket Yesu Tinta na yɨbnonj, ɨ yepiya re Ton kɨma wekenonj dɨde Twelp (12) ɨtmɨkitijog rɨga gɨlgɨl b'arkita yoramito Tina tendam yɨt gatab. ");
INSERT INTO gdr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ɨ Yesu mɨra amninonj da, “God kea jɨ Tina pumb tungg gatab wɨgawɨga yɨt wumɨr akainonj wanɨm. Ajɨ rɨga yepim re maka Ken yɨmta nundoki, towanɨm onggɨtyam komkesa yɨt re wumɨr okateni kesa jaba tendam yɨt nena im wekeny. ");
INSERT INTO gdr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nokɨm da ɨdenat onggɨtyam bageyam Isayamna yɨt rɨrɨrkɨp tainy da, ‘Yɨr ke yɨr ongong reyeninem ajɨ goro ton gar ke rakateninem, ɨ kwa yɨpya ke rutkundeninem ajɨ goro nony raukinem, nokɨm da ɨdenat ton maka tengendanj Godɨm pɨlwa ɨ dɨde God towaina negɨr mɨle makwa opima awɨr tamnɨkainy.’” ");
INSERT INTO gdr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ɨ Yesu ten amninonj da, “Wɨn onggɨtyam tendam yɨt maka wumɨr aindam. Sɨ odede ra, rɨdede im wɨn komkesa tendam yɨt wumɨr taukindam?” ");
INSERT INTO gdr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Seg ket Yesu ɨtemb tendam yɨt isɨpkena yiyenonj da, “Wala rɨga re tuny ɨgmarka eyeninonj, sɨ ɨja emb jɨ. God ma wɨko rɨgat Tina yɨt pɨtapɨta omneny rɨga wa pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ɨ opi re jɨ nyawɨnd ɨsokto re ɨnsimemb jɨ rɨga esɨpkeniny ya pɨlwa im re bageyamɨt God ma yɨt apureniny ajɨ ton gar ɨdoki im wekeny. Sɨ ra ton ɨtemb God ma bage yɨt tutkunji, odenja ket Satana opimemb God ma yɨtkak tewaikisiny towa pɨlke rɨnsim re bageyamɨt apureniny towa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ɨ opi re jɨ gɨmo gowɨnd ɨsokto re ɨnsimemb jɨ rɨga esɨpkeniny yepim re God ma bage yɨt utkundenyi dɨde odenja ket ton ɨtemb yɨtkak sam kɨma yokatenyi. ");
INSERT INTO gdr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ajɨ ton makaya ngor wa ap b'amka wuweny God ma onggɨt yɨtkakɨm pɨlɨnd ajɨ ton sobijogjog gangga nate ɨtemb yɨtkak gar ke yokatenyi. Ajɨ daka ra God ma yɨtkak map negɨr ma b'atonkena mɨle ɨ bebɨg dɨde b'ɨsadrena mɨle pɨta taukanj, ton odenja im ket sap totekanj dɨde ket ɨtemb God ma yɨtkak ɨrari. ");
INSERT INTO gdr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ɨ opi re jɨ wanjametɨnd ɨsokto re ɨnsimemb jɨ rɨga esɨpkeniny yepim re God ma yɨtkak utkundenenyi, ");
INSERT INTO gdr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ajɨ ton gowukoi yɨrkokar singind ukoijog nony menamena amnɨkenenanj, ɨ jogjog gasa singind b'anygɨnena sam yokatenyi, ɨ dɨde kwa nɨnda gowukoi gasa wa singi aukenenanj towaina garɨnd. Sɨ tonpimemb jɨ odede rɨga gangga kesa amnɨkenenanj God ma yɨtkak danda kɨma emorkam. Sɨ tonsimemb God ma yɨtkak yɨkangɨndenyi. Sɨ onggɨt paemb ket maka God ma yɨtkak kɨp tɨjagɨkanj towa pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ɨ opi re jɨ b'ogɨl sal gowɨnd ɨsokto re ɨnsimemb jɨ rɨga esɨpkeniny yepim re God ma yɨtkak utkundenyi ɨ gar ke utkunda ke yokatenyi, ngɨrpu ket kɨp jogjog ɨjagɨkanj, yɨpam pɨlke teti (30), yɨpam pɨlke siksti (60), ɨ yɨpam pɨlke andred (100).” ");
INSERT INTO gdr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ɨ Yesu amninonj da, “Wɨn nangga pae lampa so omnenya, mɨnda rɨka kopakak ke utwangka ma o mɨnda rɨka dar ke ɨkangɨnda ma? Sɨ rɨngma, ma ɨta tina uwonyitapu pɨpmetɨnd oramisya? ");
INSERT INTO gdr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sɨ Nangga im komkesa God ma pumb tungg gatab yu egiti wekeny re ngayand pɨtapɨta omnena mim jɨ, ɨ dɨde nangga im komkesa God ma pumb tungg gatab yu utwangki wekeny re ɨpangenda mim jɨ ngayand.” ");
INSERT INTO gdr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ɨ yɨt seg re ket Yesu yindonj da, “Yete re man wɨngawɨnga ke yɨpya kɨma, man utkunde!” ");
INSERT INTO gdr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ɨ kwa ton ten amninonj da, “Wɨn b'ogla nonyɨk b'obogɨl b'amdeninam onggɨt yɨtkakɨm pɨlɨnd nangga yɨt im re yu wɨn utkundenindam Kor pɨlke! God opima wanɨm okawam odede yɨpa wɨp tondon wa takatenainy rɨja na ra wɨn danda ondratena iyenya gar ke utkunda ke onggɨtyam Koina yɨt okatam. Sɨ God kwa opima onggɨtyam waina ondrateni danda rɨrɨrɨnd wa wumɨr tagoniny, ɨ ma onggɨt nena im ajɨ daka Ton opima kwa onggɨtyam waina danda tondon tumɨnd nɨnda wewe wumɨr wa tesmurenainy. ");
INSERT INTO gdr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mop nokɨp yet ra onggɨtyam Koina yɨtkak wumɨr okateny, God opima onggɨt rɨgam b'usaya kwa Tina yɨtkak gatab wumɨr ogoniny. Ajɨ yet ra maka okateny, God ɨta awɨr omnau nangga mog wumɨr e onggɨt rɨgat yowam.” ");
INSERT INTO gdr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ɨ Yesu yindonj da, “God ma pumb tungg ɨja emb jɨ yɨpa wɨp rɨja e re wala rɨgat tuny egmarkiny de gou wa. ");
INSERT INTO gdr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ɨ bibɨr utnyita wɨngɨrɨnd ɨ sɨwɨny yutunga wɨngɨrɨnd tuny pok ɨkkanj ɨ dɨde owɨnkanj. Ajɨ wala rɨgat ton ma wumɨr e rɨja im tuny aukanj. ");
INSERT INTO gdr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Sɨ gowɨt tilenggyam owoukɨp amnɨkiny re ɨja emb jɨ, naska nangg tawɨnkiny, ɨ ɨngkek ket owoukɨp kolkak tejagɨkiny. Sɨ ɨtemb ket mogjɨ tamnɨkiny owoukɨp kolkak borand. ");
INSERT INTO gdr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ɨ ra ket owoukɨp raka taukanj, odenja wala rɨgat ket giri okas ɨpkam, nokɨp kemb erngoka wɨn yokas.” ");
INSERT INTO gdr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ɨ Yesu ket yindonj da, “Rɨdede yɨt kae men isɨpkenyu da God ma pumb tungg ɨja e? Rɨnggɨtyam tendam yɨt e men ingau? ");
INSERT INTO gdr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Sɨ ɨja emb jɨ ket ɨt re mastad tuny ɨtliti yɨbɨm yɨpa sopapu gowɨnd nɨnda b'enga wɨp tuny kɨma. Ɨ re ket ɨgmarka wɨnɨnd, ton sobijogjog kɨp na yɨbɨm komkesa tuny wɨngɨrɨnd onggɨt sopapund. ");
INSERT INTO gdr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ajɨ re ket ɨtot seg, ɨ nangg ɨnɨka yik, ngɨrpu ket ukoijog nangg awɨk onggɨt sopapu wɨngɨrɨnd. Ɨ kwa ukoi bɨa aukanj. Sɨ onggɨt wulɨm pɨlɨnd pumbɨnd ngenap rɨrɨr im towaina met orangka teyenanj.” ");
INSERT INTO gdr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ɨ re Yesu ten auyaeninonj jogjog tendam yɨt ke, sɨ rɨgap rɨrɨrjog na aukɨto tina yɨtkak wumɨr okatam. ");
INSERT INTO gdr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sɨ Yesu tendam yɨt nena kena rɨga amneninonj. Ajɨ re Ton Tinta yɨbnonj Tina b'auyaena rɨga kɨma, Ton ket ɨdenatemb komkesa yɨtkak esɨpkenainonj. Sɨ omandemb jɨ Tina b'auyaena rɨgap nony aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ɨ re onggɨt bibɨrɨnd sɨ yimokonj, Yesu omanda gɨgand omiti yɨbnonj. Ɨ odedend ket Ton Tina b'auyaena rɨga amninonj da, “Sɨpa nata wuyɨn yɨpa tab wa.” ");
INSERT INTO gdr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Seg ton ket tina b'auyaena rɨgap ukoi rɨga bobo erarkɨto sɨpa yurund, ɨ ket angurkɨto gɨga wa rɨkɨnd re Yesu omiti yɨbnonj. Seg odedend ket wanakana yiwato sɨpand, ɨ nɨnda gɨgap kwa kea yɨpand ton kɨma menon yokato. ");
INSERT INTO gdr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ɨ re towaina menonɨnd ukoijog depu rɨb ikonj, dɨde ukoi wurop gɨga ipowa eyento. Sɨ kwa kea toda gɨga nyɨ b'angjɨka wuwenonj. ");
INSERT INTO gdr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ɨ Yesu gɨga kak wa yɨt na wegonj mopbu kumbɨnd. Sɨ Tina b'auyaena rɨgap Tin yɨt opmura yiyeno dɨde ket Tin yomneno da, “Ouyaena rɨga-wɨi! Man ma ɨta nony sowa pɨlɨnd! Men momta im negɨr taindam.” ");
INSERT INTO gdr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ɨ re ket Yesu utnyitonj, Ton ket rɨb samany yiowonj da, “Muma kesa ae!” dɨde sɨpand wuro yomnonj da, “Or seg ae!” Seg ket, depu rɨb re kea mumakesa awonj dɨde ket daka sɨpa nyɨ kea mumakesajog awonj. ");
INSERT INTO gdr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Seg Yesu ten amninonj da, “Nangga paim wɨn moga aindam? Ma wɨn makaya gar ke utkunda ke nokasya?” ");
INSERT INTO gdr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Sɨ ukoi mogat ten akasinonj ɨ towalenggyam b'arkento da, “Sɨ rɨdede Rɨga e jɨ? Wɨi, rɨb ake sɨpa wurop todaka kea Tin yɨt yutkunjya!” ");
INSERT INTO gdr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ɨ ton ket sɨpa yɨpa tab wa wuwonj de Gerasen eriya gatab wa. ");
INSERT INTO gdr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Re Yesu gɨga ke opendonj, odenja yɨpa negɨr kɨlkɨl wɨngawɨnga ma okati rɨga gɨmo yɨund eski gopmet ke ikonj Ti pɨlwa, ɨ wɨpwɨp awonda Ton kɨma. ");
INSERT INTO gdr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Onggɨt eriyand, gopmet re gɨmo yɨund eski na wekenonj gɨmo dorɨnd. Ɨtemb jɨ negɨr wɨngawɨnga ma okati rɨga wɨmena yikenenonj onggɨt gopmet nata. Sɨ makwa yɨpa rɨgat rɨrɨr na tin ɨjobɨkam kai ke o dɨde sein kai ke. ");
INSERT INTO gdr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Rɨgap pop jogjogpyam pɨsɨnd ɨ dɨde yɨmɨnd yɨjobɨkeneno kai ke dɨde sein kai ke. Ajɨ ton kai epkeneninonj ɨ sein kai anygɨkeneninonj ɨ dɨde dea ta b'ɨskokeninonj ti pɨlke. Sɨ makwa yɨpa rɨgat tina danda ke tin gou wa yomnonj. ");
INSERT INTO gdr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ɨ ita bibɨrɨnd dɨde sɨwɨnyɨnd ti menamena yokatenenonj gopmet gangga nata dɨde nɨnda sukak nata obaerena ara kɨma ɨ dɨde tilenggyam gɨmo orkakorkak ke tina jɨ b'epkenenonj. ");
INSERT INTO gdr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ɨ re ton Yesund pajapaja yɨr yongonj, ton b'ɨtkonj Yesum pɨlwa ɨ kumsos b'amkonj Ti pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ɨ dɨde b'okta irere kɨma yindonj da, “Yesu! Pumbjog Godɨmna B'ɨga! Nangga e man singi yomnyɨt kor pɨlɨnd? God ma nyɨ kɨma metɨrkisɨn. Goro ken negɨr notɨnɨm!” ");
INSERT INTO gdr_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nok penaemb ton odede yindenonj, nokɨp Yesu naska kea tin yomnonj da, “Negɨr wɨngawɨnga man opende onggɨt rɨgam pɨlke!” ");
INSERT INTO gdr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sɨ Yesu tin yerkitonj da, “Yete mor nyɨ?” Ɨ ton mɨra yomnonj da, “Kor nyɨ tonte Ligiyon, nokɨp sɨn jogjog im.” ");
INSERT INTO gdr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ɨ ton Yesund danda kɨma yɨtenawonj da, “Yesu! Man goro sɨn neteaukeninɨm onggɨt eriya ke!” ");
INSERT INTO gdr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Onggɨt wɨnɨnd kea jogjog ongeni b'om bobo wekenonj dor tabɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Sɨ onggɨt negɨr wɨngawɨngap ket Yesund yerkito da, “Sɨn nɨtmɨkurine onggɨt b'om wa pɨlwa, sɨ ɨdenat sɨn b'ɨtgarkindam towa pɨlwa.” ");
INSERT INTO gdr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ɨ Yesu ket ten engainonj b'ɨgaram. Seg negɨr wɨngawɨnga ket opekto onggɨt rɨgam pɨlke, ɨ ket b'om wa pɨlwa b'ɨgarkɨto. Opimemb jɨ b'om ama rɨka tu tausɨn (2,000) na. Ton wanakana b'ɨkto sɨpa yuru kumb wa, ɨ ket sɨpa wa unykurto, ngɨrpu ket komkesa uj aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Onggɨt kak ke ket, b'om ongena rɨga b'ɨkento dɨde yɨdɨr yɨt yiyeno onggɨt taunɨnd dɨde nɨnda wuswus tungg nata. Sɨ rɨga re kea opendento onggɨtyam mɨle yɨr ongongɨm rɨna re aukonj. ");
INSERT INTO gdr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Re ton wuwenonj Yesum pɨlwa, rɨgap yɨtabɨno onggɨt rɨgand yet re Ligiyon wɨngawɨnga ma okati yɨbnenenonj. Ajɨ ton ket kobɨrgɨm b'ikoki dɨde b'ogɨl nony menamena kɨma na omiti yɨbnonj. Sɨ rɨga moga na aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ɨ yepiya re mɨle towaina yɨr ke yɨr angto, ton rɨga wa pɨlwa yɨpayɨpa b'obogɨl esɨpkenauto rɨngma na re mɨle aukɨto onggɨt negɨr wɨngawɨnga ma okati rɨgam pɨlɨnd ɨ dɨde kwa b'om gatab. ");
INSERT INTO gdr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ɨ rɨgap Yesund danda kɨma yerkito towaina eriya ke ewaikitam dɨde menonɨm deta b'enga gatab wa. ");
INSERT INTO gdr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ɨ re ket Yesu gɨga kumb wa angitonj, ɨ rɨga yet re negɨr wɨngawɨnga ma okati yɨbnonj, ton Yesund yɨtenawonj menonɨm yɨpand Ton kɨma. ");
INSERT INTO gdr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ajɨ Yesu maike tin yingawonj menonɨm ton kɨma. Ɨ tin yɨt nena na yomnonj da, “Meke moina met wa, de moina rɨga wa pɨlwa, ɨ dɨde man ket ten wumɨr tamninyɨt nangga na re Yonggyam mor momnɨkainy ɨ re kwa Ton men kear momɨny.” ");
INSERT INTO gdr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Sɨ ɨngkek ket ɨtemb rɨga yiwatonj ɨ ket yikonj Dekapoli eriya wa, ngɨrpu ton ket b'atomonj yɨt pɨtapɨta omnenam nangga na re Yesu ti pɨlɨnd amnɨkinonj. Sɨ komkesa rɨga yepiya re tina yɨt utkundeno, kea kɨd kesa aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ɨ Yesu b'usaya gɨga ke ɨjendonj sɨpa tab wa. Ɨ re Ton maka gɨga ke opendonj gɨl wa, ajɨ kea de ukoi rɨga bobo Tinɨm yɨr ungawam b'eomto sɨpa yurund. ");
INSERT INTO gdr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Re ket Yesu opendonj gɨga ke, yɨpa Ju rɨga waina yɨr opmitenapu met mopyam yɨr ɨpka rɨga ikonj Yesum pɨlwa, nyɨ da Yairo. Sɨ re ton Yesund yɨr yongonj, ton ket Yesum wɨpɨnd kumsos b'amkonj. ");
INSERT INTO gdr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ɨ ton odede yɨt kɨma Yesund yɨgekitonj menonɨm tina met wa da, “Koina ngɨmngai b'ɨga momta o uj okas. Rɨngma man koina met wa metket ɨ yɨm taramisɨt ti pɨlɨnd tin ɨsakendam, ɨdenat ton yilo okas?” ");
INSERT INTO gdr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yɨt seg ke Yesu yiwatonj Yairo kɨma. Ɨ ukoi bobo rɨgapiya Yesund yɨmta yundoko, ɨ dɨde kwa Ti wusɨnd pɨpmet b'ɨsatena wuwenonj menon wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Re towa menonɨnd, omanda jɨ yɨpa kongga wikonj towa wɨngɨrɨnd yet re kus opekenenonj twelp (12) kemag kɨma. ");
INSERT INTO gdr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ɨtomb re kongga ton kopa awɨr omnam jogjog dokta wa pɨlwa wikenenonj, ɨ ma sobijog gar bebɨg kɨma na b'asowa yokatenenonj dokta waina yɨr ɨpka wɨngɨrɨnd. Ɨ dɨde kwa komkesa tina wulkɨp esomnena eyeneninonj. Ajɨ ton makwa yɨpa b'ogɨl yokatonj, ajɨ tina kopa re ukoijog na auka yikenenonj. ");
INSERT INTO gdr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ɨ ɨtomb kongga kea Yesum gatab yɨdɨr yɨt utkundonj, seg ton tikonj dɨde ket rɨga wa ganggand Yesum kak ke wikonj, ngɨrpu ton ket Yesumna kobɨrgɨm yesopayonj. ");
INSERT INTO gdr_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mop nokɨp ton kea tina garɨnd windonj da, “Ra kon tina kobɨrgɨm nena esopaen, kon ɨta b'ɨtɨsakenjɨn.” ");
INSERT INTO gdr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ɨ odenja tina kus opekapu yɨra kesa awonj, dɨde ton ket jɨ ke yɨpɨntonj da, “Ke kon b'ogɨl e aen kopa ke.” ");
INSERT INTO gdr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Odenja Yesu todaka kea b'angwatonj da ti pɨlke danda re kea ewaikitonj. Sɨ ton ket engendonj rɨga wa pɨlwa, ngɨrpu arkisinonj da, “Yet Koina kobɨrgɨm yesopai?” ");
INSERT INTO gdr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ɨ Tina b'auyaena rɨgap mɨra yomno da, “Yɨr yonge jɨ rɨga bobo! Mor wusɨnd pɨpmet b'ɨsatena wuweny. Ajɨ nangga pae Man b'arkita yoramisɨt da, ‘Yet Ken nesopai?’” ");
INSERT INTO gdr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ajɨ Yesu yɨr ke oraka yiyenonj onggɨt rɨgand yet re Tin yesopayonj. ");
INSERT INTO gdr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ajɨ odenata onggɨt konggat mogapɨp kaktɨtɨ aukonj, mop nokɨp ton wumɨr na nangga na re ti pɨlɨnd aukonj. Sɨ ton wikonj Yesum pɨlwa, ngɨrpu sap otendonj ɨ ket pɨtapɨta yomnainonj komkesa ɨmɨnjog gasa rɨna re ti pɨlɨnd auka wuwenonj. ");
INSERT INTO gdr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ɨ Yesu onggɨt konggand womnonj da, “Ngɨmngai b'ɨga! Moina gar ke utkundate men mɨsakenj. Meke ngɨmbla kɨma. Mor kopa ke b'asowa re kemb seg ainy.” ");
INSERT INTO gdr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ɨ re Yesu onggɨtyam yɨt opurenand yɨbnonj, odedend ket nɨnda rɨga tuwonj Yairom met ke, ɨ dɨde Yairond yomno da, “Moina ngɨmngai b'ɨga kea uj ainy. Sɨ nangga pae man ouyaena rɨgand jabakɨpɨnd ɨl yongket menonɨm? Goro Tin ɨsakaulisɨt!” ");
INSERT INTO gdr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ajɨ Yesu tin yɨt yomnenonj onggɨt gatab yɨtkak rɨna re bageyam rɨgap apurento Yairom pɨlwa. Ɨ Ton ket Yairond yomnonj da, “Goro moga tawɨm! Gar ke utkunda nena yoramite!” ");
INSERT INTO gdr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ɨ Yesu makwa yena yingawonj tin yɨmta undokam ajɨ ten nena Petro, Yakobo, dɨde Yakobomna yɨnggan Yoan. ");
INSERT INTO gdr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ɨ re ton Yairom met wa opento, Yesu kea yɨr anginonj uj rɨga ɨsnawa mɨlend rɨna re rɨgap amnɨkto yii kɨma ɨ dɨde ukoi guglam kɨma. ");
INSERT INTO gdr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ɨ Yesu ton b'ɨgaronj met wɨngɨr wa, ɨ rɨga amninonj da, “Nangga paim wɨn odede guglam dɨde yii ainindam dɨkɨnd? Ɨtomb ngɨmngai b'ɨga re ma uj o, ajɨ yɨt o weg.” ");
INSERT INTO gdr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ajɨ rɨgap Yesund ngong na yengeno. Ɨngkek ket, Yesu ten komkesa ewaikurinonj, ɨ dɨde ara emokinonj b'ɨgam b'u ake mog dɨde Tina b'auyaena rɨga yepiya re Ton kɨma wuwonj. Ɨ ton ket wuwonj rɨkɨnd re uj b'ɨga wɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ɨ Yesu b'ɨgand yɨmɨnd wokatonj, ɨ ket womnonj Aram yɨt ke da, “Talita kum!” engenda yɨtkak noke da, “Ngɨmngai b'ɨga! Kon momnyɨn, utnyite!” ");
INSERT INTO gdr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ɨ odenja onggɨt ngɨmngai b'ɨgat utnyitonj, ɨ dɨde ket met wɨngɨr nata wikenonj. Ɨ ti kemag re twelp (12) na wɨbnainonj. Sɨ omandemb ket rɨga yepiya re onggɨt b'ɨgam gatab mɨle yɨr yongo, ton ukoijog kɨd kesa aukɨto, nokɨp gasa re towa liyaljog na aukonj. ");
INSERT INTO gdr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ɨ Yesu towanɨm danda kɨma b'ingawa yɨt yoramitonj da, “Goro yɨpat onggɨtyam gatab yɨt pɨta yamnɨk!” Ɨ dɨde amninonj da, “Owou ti wokawa!” ");
INSERT INTO gdr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu ɨngkek ket yiwatonj dɨde yikonj Tinajog tungg Najaret wa, ɨ Tina b'auyaena rɨgap kea Tin yɨmta yundoko. ");
INSERT INTO gdr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ɨ re ket Ju rɨga waina wɨram dɨde yɨr opmitena bibɨr awonj, Yesu ouyaena yotomonj Ju rɨga waina yɨr opmitenapu metɨnd. Ɨ re jogjog rɨgap Tina yɨt yutkundeno, ton kea ket kɨd kesa aukɨto, ngɨrpu ket endento da, “Rɨngkaim onggɨt Rɨgat emjinonj komkesa odede gasa? Yet Ti b'ogɨl multekɨp yokau? Ɨ rɨdede im Ton odede kɨd kesa kɨma danda wɨko amnɨkeniny Tina yɨm ke? ");
INSERT INTO gdr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ma ɨtemb rɨga met oranga rɨga e, ɨ Mariyam b'ɨga e, ɨ dɨde Yakobo, Yose, Yudas dɨde Simon towa nany e? Ma ma Tina ngɨmɨrwar ɨndamima men kɨma?” Sɨ ɨngkenaemb ket rɨgap Yesund ɨsnawa kesa yomneno. ");
INSERT INTO gdr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Seg ket Yesu ten amninonj da, “Rɨgap Godɨmna bageyam ɨta yɨsnaenenyi komkesa gatab nata, ajɨ tinajog tungg rɨgap ma ɨta tin yɨsnaenenyi. Ɨ kwa daka tinajog kus ke rɨgawarɨp dɨde tina metamjog rɨgap ma ɨta yɨsnaenenyi.” ");
INSERT INTO gdr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Sɨ Ton ma rɨrɨr na kɨd kesa kɨma danda wɨko omnɨkam de Tinajog tunggɨnd. Sɨ Ton nɨnda kopa rɨga wa pɨlwa nena na yɨm aramiteninonj dɨde esakenjinonj. ");
INSERT INTO gdr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ajɨ maka gar ke utkunda ke Yesund yokato, sɨ onggɨt penaemb Yesu ma sobijog na nonysɨpsɨp aukonj. Seg ket Ton yikenonj nɨnda wuswus tungg nata ɨ ket rɨga ouyaena eyeninonj. ");
INSERT INTO gdr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu Tina Twelp (12) b'auyaena rɨga ara emokinonj b'eomam, ɨ Ton ket ukoi juwai akainonj negɨr kɨlkɨl wɨngawɨnga eaukenam. Seg Ton ket yotomonj ten ɨtmɨkenam nɨmog nɨmog nɨnda tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Sɨ Yesu yɨmta kena ten etmɨkeninonj, ajɨ naska Ton ten yɨt amneninonj da, “Goro kwa odede nanggamog gasa na eyinam wa menonɨm, opi re sana, ga o wulkɨp ga, ajɨ kutɨp nena na. ");
INSERT INTO gdr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ɨ kwa wɨn b'ogɨl im b'itkokindam yongɨnkak dɨde yɨpaina kobɨrgɨm.” ");
INSERT INTO gdr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ɨ kwa Ton ten amninonj da, “Ra wɨn tuwenyɨt tungg yɨpayɨpa nata, rɨgap opima wen yɨpayɨpa met nata obai tamnenanj waina menon tungg wɨngɨrɨnd. Sɨ wɨn omanda tekenyɨt ngɨrpu ra wɨn opimemb tungg terarenindam dem. ");
INSERT INTO gdr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ɨ ra maka ra yɨpa tunggɨt simesime wen tamɨny ɨ dɨde rɨgap maka ra waina yɨt tutkundanj, sɨ wɨn ɨdenatemb ket onggɨt taun ke iwasya. Ɨ onggɨt iwata wɨnɨnd wɨn b'ogla waina pɨspamɨnd sungar tedbenenindam towanɨm nony aukam da towaina negɨr mɨle b'ɨsagɨkam wɨn ɨta ik dem.” Ɨ re yɨt omnena seg awonj, Ton ket nɨmognɨmog etmɨkeninonj. ");
INSERT INTO gdr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Sɨ Twelp (12) ɨtmɨkitijog rɨgap menon yokateno, ngɨrpu yɨtkak pɨtapɨta amnento da, “Wɨn waina negɨr mɨle ke engenjinam de Godɨm pɨlwa!” ");
INSERT INTO gdr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ɨ kwa ton ket jogjog negɨr wɨngawɨnga eaukena eyento, dɨde jogjog kopa rɨga gaya ke ɨsnɨka eyento ɨ ten ɨsagɨka eyento. ");
INSERT INTO gdr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ɨ king Erod daka kea yɨdɨr yɨt utkundonj Yesum gatab. Mop nokɨp Yesu ma nyɨ re kea pɨtakɨpɨnd awonj dɨde rɨgap Yesum gatab b'engabenga wɨp ke yɨt apurento. Sɨ nɨnda rɨgap yopureno da, “Baptiso Yoan kea uj ke utnyitonj. Sɨ onggɨt mop paemb Yoanɨmna kɨd kesa kɨma dandate wɨko omnɨka yiyeny ɨtemb rɨga Yesum pɨlɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ɨ nɨnda rɨgap yopureno da, “Ton Eliyate.” Ɨ kwa nɨnda rɨgap da, “Ton God ma bageyam e odede wɨp ɨt re yɨpa kesam bageyam re dɨde yet re kesam peba wɨnɨnd yɨbnonj.” ");
INSERT INTO gdr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ajɨ re Erod onggɨtyam yɨdɨr yɨt utkundonj, ton yindonj da, “Yoante utnyitonj yena re kon mop yɨpendond.” ");
INSERT INTO gdr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Sɨ ɨtemb jɨ yɨt rɨja na re Erod Baptiso Yoanɨnd mop yɨpendonj. Sɨ re king Erod ti yɨnggan Pilipɨmna kongga Erodiyand wokatonj ti konggam, sɨ Yoan king Erodɨnd yomnenonj da, “Ɨtemb re ma b'ogɨl mɨle emb jɨ, man ɨtomb mor yɨngganɨm kongga mor konggam womnyɨt.” Sɨ onggɨt penaemb ket king Erod Yoanɨnd yɨmɨnd yusunatonj dɨde yɨjobɨkonj ɨ ket sɨbɨbmet wa yoramitonj ti kongga Erodiyand nony b'ogɨl omnam. ");
INSERT INTO gdr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ajɨ Erodiya re ma sobijog na Yoanɨm pɨlwa soro aukenenonj, ngɨrpu singi awonj tin ongandam. Ajɨ ma rɨrɨr na awonj. ");
INSERT INTO gdr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mop nokɨp Erodɨt tin yowaendenonj rɨga wa pɨlke. Sɨ nangga pena Erod Yoanɨnd yowaendenonj, nokɨp ton kea wumɨr awonj da Yoan re negɨr kesa dɨmdɨmjog rɨga na ɨ dɨde kwa ton yɨna omni rɨga na, sɨ onggɨt penaemb ton Yoanɨnd moga na yuwadonj. Ɨ kwa nok penaemb da ita wɨnɨnd re ton Yoanɨmna yɨt utkundenenonj, ton tina yɨt b'obogɨl gar sam kɨma na utkundenenonj, nangga ma jɨ rada ton ma sobijog na nony bebɨg aukenenonj yɨt utkundand. ");
INSERT INTO gdr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ajɨ kea yɨpa b'ogɨl wɨn awonj Erodiyam. Re Erodɨmna ukendi bibɨr yokatonj, Erod komkesa tina gabmani ukoi wɨko rɨga ɨ nɨnda wan tausɨn (1,000) geja rɨga mopyam ɨ dɨde Galili eriya wɨngɨrɨnd nɨnda ukoijog nyɨ rɨga, towanɨm ukoi diyamdiyam mɨle yomnɨkonj. ");
INSERT INTO gdr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ɨ kea dɨkɨnd diyamdiyampu pɨpmetɨnd Erodiyam ngɨmngai b'ɨga tikonj, ɨ ton ket ger omaronj. Ɨ tina ger omarkat Erod dɨde tina ɨngauki rɨga ukoi sam amninonj. Sɨ king Erod onggɨt ngɨmngayɨnd womnonj da, “Nɨgekite nangga ma man singi aet! Ɨ kon ɨta motkaen.” ");
INSERT INTO gdr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ɨ dɨde ton tin God ma nyɨ kɨma womnonj da, “Nangga mana ra man netɨrkisɨt kon ɨta motkaen. Ra man singi taet koina kantri ɨnyɨnyɨnd okangendi yɨpa tab, sɨ kon ɨta motkaen.” ");
INSERT INTO gdr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ɨ ngɨmngai ton ket bau wa opendonj ɨ wikonj ti mogɨm pɨlwa, ngɨrpu windonj da, “Nangga ma kon b'arkita oramisɨn?” Ɨ ket ti mog mɨra womnonj da, “Baptiso Yoanɨmna moptekɨp mana erkisɨt.” ");
INSERT INTO gdr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ɨ odenja ton ket wanakana wɨngɨr wa b'ɨgaronj, ɨ king Erodɨnd yerkitonj da, “Kon singi da man otadejog Baptiso Yoanɨmna moptekɨp notkaet pletond.” ");
INSERT INTO gdr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Seg, king Erod ma sobijog na gar bebɨg awonj, ajɨ ton ma rɨrɨr na awonj ngɨmngai ma b'arkita b'ɨsayam, nokɨp ton kea God ma nyɨ kɨma okawam womnonj komkesa ɨngauki rɨga wa wɨpɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Sɨ odenja king Erod ara yemokonj yɨpa tina yɨr ɨpka geja rɨga, ɨ yingawonj Yoanɨmna moptekɨp iyoyɨm. Re ket geja rɨga yiwatonj sɨbɨbmet wa, ton kea ket Yoanɨnd mop yɨpendonj. ");
INSERT INTO gdr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Seg ket ton Yoanɨmna moptekɨp iyonj Erodɨm pɨlwa pleto kumbɨnd. Ɨ Erod ket ɨtomb ngɨmngai b'ɨgam wokawonj. Ɨ ngɨmngayɨt daka ket yiyonj ti mog Erodiyam pɨlwa, ɨ ti wokawonj. ");
INSERT INTO gdr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ɨ re Yoanɨmna b'auyaena rɨgap onggɨt gatab yɨt utkundo, ton ket wuwonj, ɨ Yoanɨmna ujgɨm yurowato, ɨ dɨde yɨpa gɨmo yɨund eski gopmet wa yoramito. Sɨ ɨja emb jɨ Yoanɨmna mop ɨpendi yɨt. ");
INSERT INTO gdr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ɨ ɨtmɨkitijog rɨga rɨna re Yesu etmɨkeninonj tungg yɨpayɨpa wa, ton ɨtekto Yesum pɨlwa dɨde yɨpand b'eomkurto. Ɨ ket Yesund wumɨr yomneno komkesa gasa rɨna re ton amnɨkto dɨde auyaento. ");
INSERT INTO gdr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Onggɨt wɨnɨnd ma yɨpa kɨma rɨga na wuwenonj dɨde ɨtendento. Sɨ onggɨt penaemb Yesu dɨde Tina b'auyaena rɨga diyam awowɨm gangga kesa na wekenonj. Sɨ onggɨt penaemb Yesu Tina b'auyaena rɨga amninonj da, “Wuyɨn menta de wul kesa tungg wa, ɨ wɨn sobijog wɨram yokata!” ");
INSERT INTO gdr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Seg ket Yesu dɨde Tina b'auyaena rɨga gɨgand yiwato, ɨ wuwonj de wul kesa tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ajɨ re ton menon yokato, jogjog rɨgap kea ten yɨr angto. Sɨ re ton yongwato pɨpmet rɨtade re ta ton menon yokato, rɨgata rɨgata yɨpand b'ɨkento komkesa wuswus taun ke ɨ ton naska opendento de onggɨt rɨga kesa tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ɨ re Yesu gɨga ke opendonj, Ton kea ukoi rɨga bobo yɨr anginonj. Ɨ Ton ten gar ke kear amninonj, mop nokɨp ton wekenonj re odede wɨp na rɨngmim ra mamoi tekeny yɨr ɨpka rɨga kesa. Sɨ ton ket ouyaena yotomonj dɨde ma yɨpa kɨma yɨtkak na ouyaena eyeninonj. ");
INSERT INTO gdr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ɨ re ket bibɨr wɨn awɨr auka yikonj, Tina b'auyaena rɨga tuwonj Ti pɨlwa dɨde ket Tin yomno da, “Ɨtemb tungg re rɨga kesa tungg e, ɨ kwa bibɨr wɨn re kea awɨr auka yik. ");
INSERT INTO gdr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Sɨ rɨga wetaweta amnɨkine, ɨ etmɨkenine wuswus sopapu tungg nata dɨde wuswus tungg nata. Sɨ ton wou dɨde towalenggyam owou remjinem towanɨm owowɨm.” ");
INSERT INTO gdr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ajɨ Yesu ten mɨra amninonj da, “Wɨn towa owou agoninam!” Sɨ ton Yesund yomno da, “Rɨdede e sɨn omnɨku? Sɨ rɨngma, sɨn wuyɨn ɨ wan tausɨn tu andred (1,200) Kina ke owou temjindam dor ɨ dɨde tagonindam dor towa owowɨm? Ma rɨrɨr e.” ");
INSERT INTO gdr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ajɨ Yesu ton amninonj da, “Leamog sana nganja im wɨn awamindam? Wuwe ɨ mabe yɨr angina!” Sɨ re ton adarkɨto, endento da, “Ɨnsima paib (5) sana nganja dɨde nɨmog kabum nena.” ");
INSERT INTO gdr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ɨ Yesu Tina b'auyaena rɨga engainonj da, “Rɨga engainam bobobobo aukam dɨde tɨb kumbɨnd omnɨkam! Komkesa opima diyam taukanj.” ");
INSERT INTO gdr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Seg, rɨga bobobobo omnɨka wuwenonj, nɨnda re pipti (50) rɨga bobo ɨ nɨnda re andred (100) rɨga bobo. ");
INSERT INTO gdr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ɨ ket Yesu paib (5) sana nganja dɨde nɨmog kabum akasinonj, ɨ pumb wa yɨr yikenonj dɨde ket Godɨnd sɨteket yɨt yomnonj. Ngɨrpu sana nganja epkɨkinonj ɨ ket Tina b'auyaena rɨga wa pɨlwa agoninonj rɨga wa yingg iyenam. Ɨ dɨde kwa nɨmog kabum ɨpka eyenonj towanɨm yingg iyenam. ");
INSERT INTO gdr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ɨ ton komkesa rɨga diyam auto dɨde kea ngor aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Seg ket b'auyaena rɨgap rɨga wa pɨlke sana komb dɨde kabum komb akatto dɨde aramkɨto watɨnd, ngɨrpu twelp (12) wat yɨndangɨr aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Sɨ komkesa yepiya re rɨgajog diyam aukɨto re paib tausɨn (5,000) na. ");
INSERT INTO gdr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Seg ket odenja Yesu Tina b'auyaena rɨga engainonj gɨga wa angurkam dɨde naskanaska menonɨm sɨpa yɨpa tab wa de Betsaida wa. Ɨ onggɨt ganggand re Tina b'auyaena rɨgap gɨga wa angurkɨto menonɨm tab wa, Yesu ket Tilenggyam rɨga wetaweta amnɨkinonj. ");
INSERT INTO gdr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ɨ Yesu rɨga wetaweta amnɨkinonj, seg Ton ket yiwatonj yɨpa sukak wa yɨr opmitam. ");
INSERT INTO gdr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ɨ re sɨ gɨep awonj, gɨga re sɨpa ɨnyɨny nat yɨbnonj, ajɨ Yesu re Tinta na yɨbnonj gɨl wa. ");
INSERT INTO gdr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ɨ Yesumna b'auyaena rɨgap bebɨg na yɨr yongo karab ingaena wɨngɨrɨnd, mop nokɨp rɨb yikenonj re towa wɨpwɨp na. Re Yesu towaina bebɨg yɨr yongonj ɨspara momtand, sɨwɨny tri (3) ɨ siks (6) kɨlok ganggand, Ton pɨs nya towa pɨlwa yikonj sɨpa nyɨ tumɨnd dɨde ton singi na awonj ten ɨgoukitam. ");
INSERT INTO gdr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ajɨ re ton b'auyaena rɨgap Yesund yɨr yongo menonɨnd sɨpa nyɨ tumɨnd, ton ɨja na nony auto da kobɨr e. Sɨ ton kea b'okta irere aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ɨ komkesa rɨgap Tin yɨr yongo dɨde moga yuwado. Sɨ odenja Yesu ten amninonj da, “Kɨd seo ainam! Konten, goro moga tainam!” ");
INSERT INTO gdr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ɨ re Yesu ket ton kɨma angitonj gɨga kumb wa, sɨ rɨb daka kea ket mumakesa awonj. Sɨ ket b'auyaena rɨgap nony menamena kesa ukoi kɨd kesa aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mop nokɨp ton maike nony aukɨto jogjog rɨga wa sana ogona gatab, ɨ towaina ɨpɨndena nony ke kutjog na aukonj. ");
INSERT INTO gdr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Seg ton ket sɨpa ɨjendo de Genesaret gɨl wa, ɨ ton ket gɨga yoramito. ");
INSERT INTO gdr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Re ton gɨga ke opekto, odenja rɨgap ket Yesund yongwato. ");
INSERT INTO gdr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Re rɨgap utkundeno rɨkɨnd re Yesu yikenonj, ton wumɨr omnenam b'ɨkento komkesa tungg nata onggɨt eriya wɨngɨrɨnd, ɨ ket negɨr kopa kɨma rɨga tɨtɨnd eyento Ti pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ɨ rɨkɨnd re Yesu yikenonj tungg nata ɨ taun nata ɨ dɨde sobijog tungg nata, rɨgap kopa rɨga eyento dɨde aramkɨto maketɨnd. Ɨ ton ket Yesund erkena yiyeno, nokɨm da ɨdenat kopa rɨgap Tina kobɨrgɨm petɨr esopaya iyenyi. Ɨ komkesa rɨga yepiya re yesopayo, ton kea ket b'ogɨl aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ɨ Parisai rɨga dɨde nɨnda Ju rɨga waina gog ouyaena rɨga yepiya re tuwonj Yerusalem taun ke, ton b'eomkurto Yesum pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ɨ ton ket nɨnda Yesumna b'auyaena rɨga yɨr angto towaina ɨseka mɨle kesa kɨl kɨma yɨm ke diyam awowɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Parisai rɨga dɨde komkesa Ju rɨgap towaina dad ke b'ɨsateni mɨle nɨnda owama eyento. Ɨja emb jɨ ɨseka gog mɨle, ra rɨga maka ra yɨm b'obogɨl b'ɨtɨsekanj, ton ma opima diyam taukanj. ");
INSERT INTO gdr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ɨ kwa ra ton maketpu ke tui ɨ ra ton maka ra nyɨ ke b'ɨseka mɨle tamnɨkanj, ton ma opima diyam taukanj. Ɨ dɨde ton kwa kea jogjog gog mɨle towa dadwar wa pɨlke owamam emdɨto. Sɨ yɨpa mɨle ɨtemb jɨ kapo, sospen dɨde ketel ɨseka mɨle.) ");
INSERT INTO gdr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Sɨ Parisai rɨga dɨde Ju rɨga waina gog ouyaena rɨgap Yesund yerkito da, “Nangga mop paim Moina b'auyaena rɨgap maka wɨmena wuweny elda rɨga waina dad ke b'ɨsateni mɨle rɨrɨrɨnd, ajɨ ton ɨseka mɨle kesa kɨl kɨma yɨm kaim diyam awou wuweny?” ");
INSERT INTO gdr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ɨ Yesu ket mɨra amninonj da, “God ma bageyam Isaya ɨmɨnjog na b'ogɨl bage yɨt yopulitonj waina gɨm ke b'ogɨl ajɨ ngor wa negɨr mɨle gatab. Ɨja emb jɨ tina peband ɨrɨki yɨbɨm da, ‘Onggɨt rɨgap Ken nɨsnaenenyi towaina tugɨm nena kae, ajɨ towaina nony menamena re ma wus nasim Kor pɨlke wekeny. ");
INSERT INTO gdr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ɨ ra ton God ma yɨt tauyaenenanj, ton rɨgaina omnɨki gog kaim rɨga auyaenenanj. Sɨ onggɨt paemb ton jabakɨpɨnd nony kesa kana im dɨde mogjɨ kesa im Kor pɨlwa yɨr opmitenenanj.’ ");
INSERT INTO gdr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Sɨ wɨn odede yɨpa wɨp nya kaim God ma b'ingawa yɨt awaikenindam, ajɨ wɨn rɨga waina dad wa pɨlke b'ɨsateni mɨle im owama eyenindam.” ");
INSERT INTO gdr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ɨ kwa Ton ten amninonj da, “Wɨn God ma b'ingawa yɨt b'obogɨl im esaenenindam, nokɨm da ɨdenat wɨn waina dad ke b'ɨsateni mɨle nena tamorkenenindam. ");
INSERT INTO gdr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ɨ Mose gog peband yindonj da, ‘Mor b'u ake mor mog esnae,’ ɨ kwa yindonj da, ‘Yet ra b'uɨm pɨlwa o mogɨm pɨlwa negɨr yɨt opulis, ton ɨta ɨmɨnjog uj ondrɨki ɨbɨm.’ ");
INSERT INTO gdr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ajɨ wɨn ɨja imemb jɨ rɨga ouyaena eyenindam da, ‘Ra yɨpa rɨgat ti b'uɨm pɨlwa o ti mogɨm pɨlwa indeny da “Korban,” isɨpkita yɨtkak da, “Ɨtemb re Godɨm pɨlwa singi sɨ gasam oramiti e”, sɨ ton ma rɨrɨr e onggɨtyam gasa ti b'uɨm o ti mogɨm okawam.’ ");
INSERT INTO gdr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Sɨ wɨn onggɨtyam ouyaena ke komkesa nya im edokindam ti b'uɨm o ti mogɨm yɨm okawam. ");
INSERT INTO gdr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Sɨ wɨn onggɨt wa b'uwar wa pɨlke b'ɨsateni yɨtkak e b'obogɨl yemorkenenya, ɨ ɨngkaemb God ma yɨt awɨr amnɨkindam. Ɨ wɨn kwa jogjog im odede yɨpa wɨp gasa amnɨkindam.” ");
INSERT INTO gdr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ɨ seg ket Yesu b'usaya opimemb rɨga bobo ara emokinonj dɨde ten amninonj da, “Wɨn komkesa Ken nutkunda, ɨ wumɨr yokata! ");
INSERT INTO gdr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Makwa ɨta yɨpa gasat rɨgand kɨl kɨma omɨny rɨnte re bau ke yik rɨgam kom bora wa. Ajɨ gasa rɨnte re rɨgam kom bora ke opek, sɨ tontemb jɨ onggɨt rɨgand kɨl kɨma yomnɨk. ");
INSERT INTO gdr_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Yete re man wɨngawɨnga ke yɨpya kɨma, man utkunde!” ");
INSERT INTO gdr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Seg, re ket Yesu rɨga wa pɨlke yiwatonj ɨ dɨde b'ɨgaronj met wa, tina b'auyaena rɨgap tin ket yerkito onggɨt tendam yɨt gatab. ");
INSERT INTO gdr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ɨ Yesu ten mɨra amninonj da, “Ma, wɨdaka wumɨr kesa im wekenyɨt odede opi re ton re dɨde? Wɨn ma wumɨr im da komkesa gasa rɨnte re bau ke yik de rɨgam kom bora wa, ton ma rɨrɨr e tin kɨl kɨma omnɨk. ");
INSERT INTO gdr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mop nokɨp owou rɨnte re b'ɨgarɨk rɨgam kom bora wa, ton ma kɨd wa e yik ajɨ kom bora wa e, ɨ ket opek de sobijog met wa b'ɨskokam.” Onggɨt yɨt kɨma Yesu pɨtapɨta yomnonj da, “Komkesa owou dɨde b'angga re ma kɨl kɨma im, komkesa re owou mim dɨde ongong mim, ma gog kɨma im.” ");
INSERT INTO gdr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ajɨ Yesu kwa yindonj da, “Gasa rɨnte re rɨgam pɨlke opek, tontemb jɨ onggɨt rɨgand kɨl kɨma yomnɨk. ");
INSERT INTO gdr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sɨ gasa rɨnsim re rɨgaina kukɨp ke opekanj, ton rɨgaina kɨd kaim opekanj. Sɨ odede b'engabenga negɨrjog nonyɨk b'amdena im wuweny, opi re negɨr b'iyena mɨle, yurowam mɨle, onganda mɨle, ");
INSERT INTO gdr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","gigɨr dɨde yɨgyɨg b'iyena mɨle, yɨpa rɨga ma gasa nony ke ɨponena mɨle, b'engabenga wɨp negɨr mɨle omnɨka singi, b'anygɨnena mɨle, b'ogɨl mɨle negɨr omnɨka mɨle, yɨr muga b'uwada mɨle, b'ugaga mɨle, b'asourena mɨle, ɨ dɨde nony kesa omnɨka mɨle. ");
INSERT INTO gdr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sɨ opimemb komkesa negɨrjog gasa opekanj re rɨga waina kukɨp kaim, ɨ tonpimemb ket rɨgand kɨl kɨma yomnɨkenenyi.” ");
INSERT INTO gdr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ɨ ɨngkek ket Yesu utnyitonj, yiwatonj dɨde yikonj ket Tiro eriya wa. Ɨ re Ton yɨpa met wa b'ɨgaronj, Ton ma singi na rɨgap wumɨr okasi da ama de Ton onggɨt met wa yɨbɨm. Ajɨ Ton ma rɨrɨr na wɨgawɨga egiti wɨmenam. ");
INSERT INTO gdr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Odenja yɨpa kongga yaina ngɨmngai b'ɨga na re negɨr wɨngawɨnga ma okati wɨbnonj, ton kea Yesumna danda gatab yɨdɨr utkundonj. Sɨ ton ket tikonj Yesum pɨlwa, ngɨrpu sap otendonj Tina pɨs wɨpɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ajɨ ɨtomb kongga re Grik yɨtam na, ɨ Siropoinikisa kongga na. Sɨ ton ma Ju kongga na. Ɨ ket ton Yesund yɨtenawonj negɨr wɨngawɨnga eaukenam tina ngɨmngai b'ɨgam pɨlke. ");
INSERT INTO gdr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ajɨ Yesu tin mɨra womnonj da, “Naska b'ɨga ngor rainem, nokɨp ɨtemb ma b'ogɨl mɨle e b'ɨga waina owou ɨsatam dɨde yongg wa b'ɨskokam.” ");
INSERT INTO gdr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ɨ kwa konggat Yesund mɨra yomnonj da, “Ɨmɨnjog e, Yonggyam! Ajɨ kasa wusɨnd yonggɨp toda b'ɨga waina sobijogsobijog sana kɨb awenenanj rɨnsim re b'ɨgap b'ɨskokanj.” ");
INSERT INTO gdr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ɨ kwa Yesu tin womnonj da, “Kea man gar ke utkunda ke b'ogɨl mɨra nomnyɨt. Sɨ man meke moina met wa! Ke negɨr wɨngawɨnga moina ngɨmngai b'ɨgam pɨlke b'ɨkeny.” ");
INSERT INTO gdr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Re ket seg, ton wikonj tina met wa, ɨ ton ti b'ɨgand wodaronj yutungi dar kumbɨnd, ɨ ton kea wumɨr awonj da ke negɨr wɨngawɨnga b'ɨkeny. ");
INSERT INTO gdr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ɨ Yesu b'usaya Tiro eriya ke yiwatonj, ɨ yikenonj Sidon nata ɨ Dekapoli eriya tunkɨp nata, ngɨrpu opendonj de Galili sɨpa wa. ");
INSERT INTO gdr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ɨ nɨnda rɨgap yɨpa yɨpya dumdum dɨde yɨt kesa rɨga iyo Yesum pɨlwa, ɨ Yesund yɨtenawo da, “Be ngai Man yɨm aramite ti pɨlɨnd tin ɨsakendam!” ");
INSERT INTO gdr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ɨ Yesu onggɨt rɨgand yokatonj rɨga bobo wɨngɨrɨnd, ɨ ket yiyonj dea ta tintawar wa. Ɨ Yesu ket Tina yɨmkak aramisinonj tina yɨpyand. Ɨ re auya ɨtmanda seg, tina weyat yesopayonj. ");
INSERT INTO gdr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Seg Yesu pumb wa yɨr yikenonj yɨr opmitam, ɨ Ton ket gar kopa kɨma nonya unggulitonj ɨ dɨde ket ti pɨlwa yɨt yopulitonj da, “Epata,” engenda yɨtkak da, “Or epangenda!” ");
INSERT INTO gdr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ɨ odenja onggɨt rɨga ma yɨpya mop epangendonda ɨ tina weyat b'inkitipu kea gorogoro awonj, sɨ ton ket dɨmdɨm yɨt apureninonj. ");
INSERT INTO gdr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ɨ Yesu rɨga engainonj da, “Goro kwa yena wumɨr tamninam onggɨt gatab.” Ajɨ re Yesu danda kɨma jogjogpyam engaeninonj ɨswangam, rɨgap toda ɨsanikesa jabajaba danda kɨma onggɨt gatab wumɨrwumɨr yɨt usenena yiyeno. Sɨ ton kea b'iklawa yiyeno onggɨt gatab. ");
INSERT INTO gdr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Seg re rɨgap utkundeno onggɨtyam yɨt, ton ma sobijog na kɨd kesa aena wuwenonj dɨde ket endento da, “Ton kea komkesa gasa b'ogɨl amnɨkiny, yɨpya dumdum rɨga utkundam ɨ yɨt kesa rɨga opurenam.” ");
INSERT INTO gdr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Re onggɨt nɨnda bibɨr ganggand b'usaya ukoi rɨga bobo wekenonj Yesu ma yɨt utkundam, ajɨ towa makwa nangga na owowɨm ebnainonj. Sɨ Yesu Tina b'auyaena rɨga ara emokinonj dɨde ket ten amninonj da, ");
INSERT INTO gdr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kon rɨga bobo im kear amninyɨn, nokɨp ke nowa bibɨr im Kon kɨma wekeny, sɨ kea towa awɨr im kwa nanggamog im owowɨm ebnainy. ");
INSERT INTO gdr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ɨ ra Kon ten tetmɨkeninyɨn owoupa kɨma towa met wa, ke nyawɨnd owoupat kak ɨjga reyenin, nokɨp towa wɨngɨrɨnd nɨnda rɨga ma wuswus tungg kaim tuwonj.” ");
INSERT INTO gdr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ɨ Tina b'auyaena rɨgap mɨra yomno da, “Men dɨkɨnd rɨga kesa tungg nasim wekenyɨn. Sɨ rɨngkaim sɨn odede ukoi owou okasu dɨkɨnd? Men ma rɨrɨr im onggɨtyam rɨga ongenam dɨkɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ɨ Yesu ket ten arkinsinonj da, “Leamog sana nganja im wɨn awamindam?” Ɨ ton mɨra yomno da, “Seben (7) nganja im.” ");
INSERT INTO gdr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ɨ Yesu rɨga engainonj omitam gowɨnd, ɨ Ton ket seben (7) sana nganja akasinonj dɨde Godɨnd sɨteket yɨt yomnonj, ngɨrpu epkɨkinonj dɨde Tina b'auyaena rɨga wa agoninonj rɨga wa yingg iyenam. Ɨ ket b'auyaena rɨgap rɨga bobo wa yingg eyenauto. ");
INSERT INTO gdr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Dɨde kwa kea towa nɨnda sobijog kabum ebnainonj. Ɨ Yesu opimemb kabum daka akasinonj, ɨ ket Godɨnd sɨteket yɨt yomnonj, ngɨrpu ket kwa Tina b'auyaena rɨga amninonj rɨga wa yingg iyenam. ");
INSERT INTO gdr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Sɨ rɨgap auto dɨde ton kea ket ngor aukɨto. Seg re b'auyaena rɨgap rɨga wa pɨlke sana komb dɨde kabum komb akatto dɨde ga wa aramkɨto, sɨ seben (7) ukoi ga na komb owou yɨndangɨr aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ɨ Komkesa rɨga yepiya re wekenonj re powa tausɨn (4,000) na. Ɨ re ton diyam seg aukɨto, Yesu ket rɨga wetaweta amnɨkinonj towaina tungg wa menamenam. ");
INSERT INTO gdr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Seg re ket odenja Yesu gɨga yokatonj Tina b'auyaena rɨga kɨma, ngɨrpu yikonj de Dalmanuta eriya wa. ");
INSERT INTO gdr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ɨ Parisai rɨga tuwonj Yesum pɨlwa dɨde Yesu kɨma yɨt b'ugwatento, nokɨp ton singi na yɨt ke Yesund gou wa omnam. Sɨ ton odede b'arkita kɨma Yesund yotonkeno da, “Man kɨd kesa kɨma danda wɨko yomnɨke! Ɨ ɨngkaemb sɨn motɨngwasu da Moina danda yikeny re Godɨm pɨlkae.” ");
INSERT INTO gdr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sɨ Yesu gar bebɨg kɨma ukoi kana nonya unggulitonj, ɨ yindonj da, “Nangga pae rɨgap yepim re yu wekeny onggɨt gowukoyɨnd, ton Ken oraka niyenyi Koina kɨd kesa kɨma danda wɨko yɨr ongongɨm? Kon ɨmɨnjog wanɨm nitinjɨn da Kon makwa ɨta yɨpa kɨd kesa kɨma danda wɨko tamnɨkaen towanɨm yepim re yu wekeny onggɨt gowukoyɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ɨ ket Yesu Parisai rɨga wa pɨlke yiwatonj dɨde b'usaya gɨga yokato Tina b'auyaena rɨga kɨma, ngɨrpu ket yiwato de sɨpa tab wa. ");
INSERT INTO gdr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ɨ b'auyaena rɨgap nony b'edatkurto nɨnda owou iyoyɨm, ajɨ ɨna yɨpaina owou nena ebnawonj gɨgand. ");
INSERT INTO gdr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ɨ Yesu ten nonony amninonj da, “Wɨn nony kɨma tekenyɨt! Dɨde wɨn yɨr kɨma tekenyɨt Parisai rɨga ake Erod towaina yist!” Yesu ton Parisai rɨga dɨde Erod towaina negɨr ouyaena gatab na tendam yɨt ke yengendonj da ɨja emb jɨ rɨngma re yistɨt wɨko yomnɨk plawa wɨngɨrɨnd. Sɨ onggɨt penaemb Yesu odede yɨt yopulitonj. ");
INSERT INTO gdr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ajɨ b'auyaena rɨgap maka wumɨr aukɨto Yesu ma yɨt mop, sɨ ton towalenggyam b'arkena wuwenonj da, “Ton nok pae odede yinj, nokɨp mera owou awɨr im.” ");
INSERT INTO gdr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Sɨ Yesu kea towaina b'arkena gatab wumɨr awonj, ɨ ket ten amninonj da, “Nangga mim wɨn b'arkena wuwenyɨt da wa owou awɨr im? Makaya wɨn wumɨr aindam ɨ makaya wɨn nony aukindam nangga ma Kon nindenyɨn? Rɨngma, waina nony menamena kut im? ");
INSERT INTO gdr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Wɨn yɨrkɨp kɨma im, ajɨ nangga paim wɨn maka yɨr angindam? Ɨ wɨn yɨpya kɨma im, ajɨ nangga paim wɨn maka utkundenindam? Rɨka wɨn opima nonyɨnd owama eyenindam? ");
INSERT INTO gdr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Sɨ re Kon paib (5) sana nganja ke paib tausɨn (5,000) rɨga angeninond, sɨ wɨn owou komb ke leamog wat na yɨndangɨr akattondam?” Ton mɨra yomno da, “Twelp (12) wat na.” ");
INSERT INTO gdr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ɨ Yesu b'usaya ten arkisinonj da, “Ɨ kwa re Kon sana ke powa tausɨn (4,000) rɨga angeninond, sɨ wɨn owou komb ke leamog ukoi ga na yɨndangɨr akattondam?” Ɨ ton kwa mɨra yomno da, “Seben (7) ukoi ga na.” ");
INSERT INTO gdr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Seg Yesu kwa tina b'auyaena rɨga amninonj da, “Rɨka wɨn makaima nony aukindam nangga ma Kon nindenyɨn?” ");
INSERT INTO gdr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ɨ re ton Betsaida wa opekto, rɨgap ket yɨpa yɨrdɨdɨ rɨga Yesum pɨlwa yiyo ngɨrpu Yesund yɨjeneno da, “Be ngai Man tin yesopae yɨr ɨpangendam!” ");
INSERT INTO gdr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Seg Yesu ket yɨrdɨdɨ rɨgand yɨm otona yiyonj dea ta tungg bau wa, ɨ ket auya yɨtmandonj tina yɨrkɨp wa dɨde ket yɨm yoramitonj ti pɨlɨnd. Seg re ket Yesu tin yerkitonj da, “Wɨi, opima man nangga im yɨr anginyɨt?” ");
INSERT INTO gdr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ɨ re ton yɨrdɨdɨ rɨga yɨr yikenonj, ton ket Yesund mɨra yomnonj da, “Kon rɨga im yɨr anginyɨn, ajɨ ton ɨja im wɨp wuweny da wul im.” ");
INSERT INTO gdr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tina yɨt seg ke ket Yesu b'usaya yɨm yoramitonj yɨrdɨdɨ rɨga ma yɨr kɨpɨnd, ɨ ɨdenatemb ket tina nɨmog yɨrkɨp epangendonda. Sɨ ton ket komkesa gasa pɨta kɨpɨnd yɨr anginonj. ");
INSERT INTO gdr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Seg ket Yesu tin yɨtmɨkitonj tina met wa odede yɨt kɨma da, “Goro tungg wɨngɨr wa mekɨm!” ");
INSERT INTO gdr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ɨ Yesu dɨde Tina b'auyaena rɨga wuwenonj nɨnda tungg nata Kaisareya Pilipo eriya wɨngɨrɨnd. Nyawɨnd Yesu Tina b'auyaena rɨga arkisinonj da, “Yena rɨgap nomnɨkenenyi da yeten Kon?” ");
INSERT INTO gdr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Sɨ ton mɨra yomno da, “Nɨnda rɨgap endenenanj da Man Baptiso Yoantet, ɨ nɨndap da Man Eliyatet, ɨ kwa nɨndap da yɨpa God ma bageyamtet kesam God ma yɨna peba wɨngɨrɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ɨ Yesu ten kwa arkisinonj da, “Ajɨ wɨdaka rɨngmim, wɨn yena yomnɨkenenya da yeten Kon?” Petro mɨra yomnonj da, “Man re Kerisotet yena re God gaya ke yeaukonj Tina wɨko omnɨkam.” ");
INSERT INTO gdr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ɨ Yesu ten engainonj da, “Goro yena rɨga wumɨr omna kor gatab.” ");
INSERT INTO gdr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ɨ ket Yesu ouyaena yotomonj Tina b'auyaena rɨga wa pɨlwa da, “Rɨgamna B'ɨga b'ogla jogjog b'ɨdgotnena takateniny. Sɨ Ju rɨga waina elda rɨga, ɨ yɨna mopyam sɨ rɨga, ɨ dɨde Ju rɨga waina gog ouyaena rɨgap Tin ɨta ɨsayi dem, ngɨrpu Tin onganji dem. Ɨ nowam bibɨrɨnd Ton ɨta uj ke tutnyis dem.” ");
INSERT INTO gdr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ɨ re Yesu onggɨtyam yɨt pɨtapɨta amneninonj, Petro ket Yesund wɨp yowarkitonj dɨde ket danda kɨma yɨt yomnonj da, “Goro odede yɨt apureninyɨt.” ");
INSERT INTO gdr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ajɨ re Yesu b'engendonj Tina b'auyaena rɨga wa wɨp wa, ɨ Ton ket Petrond samany yiyowonj da, “Satana! Man ewaikite Kor pɨlke! Mop nokɨp man ma ɨta nonyɨk b'amdena mekenyɨt Godɨmna singi mɨle omnɨkam ajɨ man rɨgaina singi mɨle omnɨka ma.” ");
INSERT INTO gdr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ɨ ket Yesu rɨga bobo ara emokinonj Tina b'auyaena rɨga kɨma, dɨde ten amninonj da, “Ra man yɨpa rɨgat singi taet Ken yɨmta undokam, man b'ogla naska moina singi komkesa terarkinyɨt, ɨ kwa man b'ogla komkesa bebɨg takasinyɨt Godɨm wɨkond ngɨrpu moina uj wul b'agbagɨnd, dɨde ket Ken yɨmta nutundoket. ");
INSERT INTO gdr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mop nokɨp yet ra tilenggyam tina yɨrkokar yɨrgong omnɨka iyeny, ton ɨta tina onggɨtyam yɨrkokar dadal edamkis dem. Ɨ daka yet ra tina yɨrkokar edamkis Kor map dɨde God ma b'ogɨl yɨrkokar bage yɨt map, ton ɨta tina onggɨtyam yɨrkokar okas dem. ");
INSERT INTO gdr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ɨ ra man komkesa gowukoi mornɨm okasɨt ɨ dɨde onggɨt gowukoi map moina yɨrkokar b'etɨdamkis dem, sɨ nangga b'ogɨl e man yɨr onget onggɨt gowukoi okati ke? ");
INSERT INTO gdr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nangga gasa kɨma e man rɨrɨr e igerkenyɨt moina yɨrkokar? ");
INSERT INTO gdr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ɨ yet ra man moina gar ke Ken dɨde Koina yɨt ɨngar kɨma takasinyɨt rɨga wa wɨngɨrɨnd yepim re yu negɨrjog mɨle ɨ gigɨr dɨde yɨgyɨg b'iyena mɨle kɨma wekeny onggɨt gowukoyɨnd, sɨ Rɨgamna B'ɨga Toda mornɨm ɨngar kɨma e motkas dem, ra Ton yɨna aneru kɨma ik dem Ti B'u ma b'ogɨl ɨnyomarenand.” ");
INSERT INTO gdr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ɨ Yesu ten amninonj da, “Kon ɨmɨnjog wen tamninyɨn da yepim re wɨn owɨnki wekenyɨt dɨkɨnd, wa wɨngɨrɨnd nɨnda rɨgap makwa opima uj taukanj, ngɨrpu ra ton yɨr ongi dem God ma pumb tungg rɨnte ra ik Godɨmna wɨp omnena danda kɨma.” ");
INSERT INTO gdr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ɨ siks (6) bibɨr kak ke Yesu ara emokinonj Petro, Yakobo, dɨde Yoan, ɨ ten nena eyinonj de yɨpa ukoi dor kumb wa. Re ket tentawar wa opekto, Yesu b'enga wɨp aukonj towa wɨpɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ɨ Tina kobɨrgɨm engendonj re bɨlbɨljog na. Sɨ gowukoi kobɨrgɨm ɨseka rɨga ma rɨrɨr e odede bɨlbɨljog tamnɨkanj towaina bɨlbɨl omnɨka ɨseka gasa ke. ");
INSERT INTO gdr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ɨ ket Eliya ake Mose kea b'auyaena rɨga wa wɨpɨnd pɨta awonda ɨ ket ton Yesu kɨma yɨtnono aenonda. ");
INSERT INTO gdr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Seg re ket Petro Yesund yomnonj da, “Ouyaena Rɨga! Sɨn otomanti im wekenyɨn dɨkɨnd. Sɨ sɨn nowa wungapu plaimet raranginum, yɨpa Mornɨm, yɨpa Mosem, ɨ dɨde yɨpa Eliyam.” ");
INSERT INTO gdr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petro maka nony awonj nangga mana ton Yesund yomnonj. Mop nokɨp ton, nowa rɨga ma sobijog moga kɨma na wekenonj. Onggɨt penaemb jɨ ton nony kesa odede yɨt yopulitonj. ");
INSERT INTO gdr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ɨ onggɨt wɨnɨnd rɨmɨt ten ekangɨnjinonj, dɨde ket ara ikonj rɨm bora ke odede da, “Ɨtemb jɨ Koina B'ɨga yena re Kon singi yiyenyɨn. Sɨ wɨn Tin yutkunda!” ");
INSERT INTO gdr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ɨ re b'auyaena rɨgap towa nonony kesand yɨr ɨtaingento, ton makwa yena yɨr angto ajɨ Yesu nenata ton kɨma yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Seg re ton dor kumb ke etaeta tuwonj de paga wa, nyawɨnd Yesu b'auyaena rɨga engainonj da, “Goro yena rɨga wumɨr tamneninam nangga gasa na re wɨn yɨr angindam, ngɨrpu ra Rɨgamna B'ɨga tutnyis dem uj ke!” ");
INSERT INTO gdr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sɨ re ton Yesu ma yɨt gar ke yokateno owamam, towa wɨngɨrɨnd kea ton b'arkena wuwenonj da, “Nangga mog e jɨ ɨtemb yɨtkak uj ke utnyita?” ");
INSERT INTO gdr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Seg ton ket Yesund yerkito da, “Sɨ nangga pae meraina gog ouyaena rɨgap apurenanj da Eliya b'ogla naska menon okas, ɨ ti kak ke ket Keriso ik dem?” ");
INSERT INTO gdr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ɨ Yesu ket ten mɨra amninonj da, “Sɨ yena pebat yindeny da Eliya ɨta naska ik dɨde ton ket komkesa gasa b'obogɨl tangonjeniny. Ajɨ nangga pae kwa yɨna peband Rɨgamna B'ɨga gatab odede ɨrɨki yɨbɨm da Ton b'ogla jogjog b'ɨdgotnena takasiny dem ɨ dɨde rɨgap Tin ɨrɨnena kɨma b'ɨsaya iyenyi dem? ");
INSERT INTO gdr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ajɨ Kon wen tamninyɨn da Eliya re ke ikonj, ajɨ nɨnda negɨr rɨgap kea towaina singi rɨrɨrɨnd komkesa negɨr mɨle ti yomnɨkauto, odede rɨngmim re yɨna peband ɨrɨki wekeny ti gatab.” ");
INSERT INTO gdr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ɨ re ton ɨtekto nɨnda b'auyaena rɨga wa pɨlwa, ton kea yɨr angto ukoi rɨga bobo. Ɨ rɨga bobop re b'auyaena rɨga ɨwatɨnti na awamto. Ɨ Ju rɨga waina gog ouyaena rɨgap yɨt b'ugwatento nɨnda b'auyaena rɨga kɨma. ");
INSERT INTO gdr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ɨ re komkesa rɨga bobop Yesund yɨr yongo, odenja ton ket ma sobijog sam kɨma na kɨd kesa aukɨto, ɨ b'ɨkento Ti pɨlwa dɨde simesime yomneno. ");
INSERT INTO gdr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ɨ Yesu ket ten arkisinonj da, “Nangga gatab mim wɨn ton kɨma yɨt b'ugwatenindam?” ");
INSERT INTO gdr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ɨ rɨga bobo wɨngɨrɨnd yɨpa rɨgat mɨra yomnonj da, “Ouyaena rɨga-wɨi! Negɨr wɨngawɨngate koina b'ɨgand okati yowameneny dɨde onggɨt negɨr wɨngawɨngate tin yɨt kesa yomnɨkeneny. Sɨ kon mor pɨlwa iyɨn re b'ogɨl omna ma. ");
INSERT INTO gdr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ɨ rɨdenat ra onggɨt negɨr wɨngawɨngat tin okas, ton kor b'ɨgand gou wa sap yotendeneny dɨde tugɨm ke tumol yaembɨkeneny dɨde or b'ɨinɨkeneny ɨ dɨde kakwulwul yomnɨkeneny. Sɨ kon ke pop Moina b'auyaena rɨga etenainyɨn negɨr wɨngawɨnga ewaikitam, ajɨ ton ma rɨrɨr na. Onggɨt penaemb ton yɨt b'ugwatento.” ");
INSERT INTO gdr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Sɨ Yesu ten mɨra amninonj da, “Oo, gar ke utkunda kesa rɨga yepim re yu onggɨt gowukoyɨnd wekenyɨt! Rɨdede pɨn e Kon wɨn kɨma nɨtɨbnyɨn? Ɨ rɨdede pɨn e Kon musɨk wɨmenand netkenyɨn waina gar ke utkunda kesa mɨle gatab? B'ɨga iya kor pɨlwa!” ");
INSERT INTO gdr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Seg re ket rɨgap b'ɨga iyo Yesum pɨlwa, ɨ negɨr wɨngawɨngat kea Yesund yɨr yongonj, dɨde b'ɨgand yuwongnenonj, ngɨrpu gou wa sap yotendonj dɨde tumol aembɨka kɨma yengendurkenonj. ");
INSERT INTO gdr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ɨ Yesu ti b'und yerkitonj da, “Rɨdede pɨn na onggɨtyam mɨle ti pɨlɨnd yɨbnenenyɨm?” Ti b'u mɨra yomnonj da, “Ɨdenata b'atomonj b'ɨga sobijogɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ɨ usausapyam negɨr wɨngawɨngat tin ongandam wul wa yɨskeneny dɨde kwa nyɨ wa yɨskeneny. Ajɨ rada man rɨrɨr et nanggamog gasa omnɨkam onggɨt negɨr wɨngawɨngam pɨlwa, Man sɨn kear nomnine dɨde yɨm nokaine!” ");
INSERT INTO gdr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu tin yomnonj da, “Nangga ma man mindenyɨt da, ‘Ra Man rɨrɨr et'? Yet ra man ɨmɨnjog gar ke utkunda oramisɨt, God rɨrɨr e komkesa gasa motɨnkainy.” ");
INSERT INTO gdr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Odenja onggɨt b'ɨga ma b'u b'okta ara yikenonj dɨde yomnonj da, “Kon kea gar ke utkunda yokasɨn. Ajɨ koina gar ke utkunda re ma rɨrɨrkɨpjog e, sɨ man yɨm notkaet.” ");
INSERT INTO gdr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ajɨ Yesu kea yɨr anginonj rɨga bobo yepiya re towa pɨlwa yɨpand b'ɨtkɨto yɨr ongongɨm. Ɨ ket Yesu negɨr kɨlkɨl wɨngawɨnga yingawonj da, “Man negɨr kɨlkɨl wɨngawɨnga yet re onggɨt b'ɨgand yɨt kesa dɨde yɨpya dumdum yomnɨkenenyɨt! Kon mitngaen. Or opende ti pɨlke, dɨde goro kwa b'usaya b'ɨtgarɨm dem ti pɨlɨnd!” ");
INSERT INTO gdr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ɨ onggɨt negɨr wɨngawɨngat b'okta irere yikenonj dɨde onggɨt b'ɨgand yuwongnenonj b'okta kana, ngɨrpu opendonj ti pɨlke. Sɨ ɨtemb re b'ɨga ɨja na wɨp yɨbnonj da uj rɨga re dɨde. Onggɨt penaemb jogjog rɨgap apurento da, “Ton ke uj e.” ");
INSERT INTO gdr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ajɨ Yesu tin yɨmɨnd yokatonj dɨde tin yonyitonj. Sɨ ket b'ɨgat onyitonj. ");
INSERT INTO gdr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Seg ket Yesu yɨpa met wa b'ɨgaronj Tina b'auyaena rɨga kɨma, dɨde demb de ton nena ket wekenonj yɨpa pɨpmetɨnd. Ɨ ɨdenatemb ket Tina b'auyaena rɨgap yerkito da, “Nangga pena sɨn maka rɨrɨr aindam ɨtemb negɨr wɨngawɨnga ewaikitam?” ");
INSERT INTO gdr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ɨ Yesu mɨra amninonj da, “Makwa ɨta yɨpa nya odede gasa ewaikitam, ajɨ yɨr opmita danda ke nena rɨrɨr e.” ");
INSERT INTO gdr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ɨ ɨngkek ket yiwato dɨde pɨs nya wuwenonj Galili nata. Ajɨ Yesu makwa singi awonj yɨpa rɨga wumɨr okatam towaina wɨmenapu pɨpmet gatab. ");
INSERT INTO gdr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mop nokɨp onggɨt wɨnɨnd Ton Tina b'auyaena rɨga na ouyaena eyeninonj. Ton ten auyaeninonj da, “Rɨgamna B'ɨgand ɨta namb tɨb yii dem de rɨgaina yɨm kumb wa, sɨ onggɨt rɨgap Tin onganji dem. Ɨ ra ton onganji dem, nowam bibɨrɨnd Ton ɨta tutnyis dem uj ke.” ");
INSERT INTO gdr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ajɨ ton maka nony aukɨto onggɨt yɨtkak gatab, ɨ ton moga na aukɨto Yesund erkitam. ");
INSERT INTO gdr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ɨ re ton opekto de Kaparnaum wa dɨde yɨpa met wa wekenonj, Yesu Tina b'auyaena rɨga arkisinonj da, “Nangga gatab na wɨn yɨt b'ugwatenindam nyawɨnd?” ");
INSERT INTO gdr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ajɨ ton mumakesa na aukɨto, mop nokɨp kea ton nyawɨnd yɨt b'ugwatento odedemb da yete ukoyam. ");
INSERT INTO gdr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ɨ re Yesu omiti yɨbnonj, Ton Tina Twelp (12) ɨtmɨkitijog rɨga ara emokinonj ɨ amninonj da, “Ra yɨpa rɨgat man singi taet ukoijog rɨga awowɨm, man b'ogla sobijogjog rɨga na taet, dɨde komkesa rɨga wa wɨko rɨga na taet.” ");
INSERT INTO gdr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ɨ Yesu yɨpa b'ɨga sobijog yokatonj dɨde yonyitonj towa wɨpɨnd, ɨ dɨde yɨm ke tin yikwatonj. Ɨ Tina b'auyaena rɨga amninonj da, ");
INSERT INTO gdr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yet ra yɨpa odede b'ɨga sobijogɨnd Kor nyɨ kɨma simesime omɨny rɨnte re wɨp ke dɨkɨnd onyiti yɨbɨm, ton Kena simesime nomɨny. Ɨ dɨde yet ra Ken simesime notɨny, ton ma Kena simesime nomɨny ajɨ ton Tina yet re Ken nɨtmɨkitonj.” ");
INSERT INTO gdr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yoan Yesund yomnonj da, “Ouyaena rɨga-wɨi! Sɨn yɨpa rɨga yɨr yongu Moina nyɨ kɨma negɨr wɨngawɨnga ewaikitand. Sɨ sɨn tin yɨswangu da, ‘Goro yɨmta ke odede omnɨkɨm dem!’ Nokɨp ton ma ɨta yɨmta undoka miyeny sɨn kɨma.” ");
INSERT INTO gdr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ajɨ Yesu amninonj da, “Goro tin ɨswanga! Mop nokɨp yete re kɨd kesa kɨma danda wɨko yomnɨk kor nyɨ kɨma, onggɨt kak ke ton makwa rɨrɨr e wanakana Ken negɨr yɨt notɨny. ");
INSERT INTO gdr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nokɨp yet ra maka men netɨjgasiny, ton re mera tab ke rɨga e. ");
INSERT INTO gdr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kon ɨmɨnjog nitinjɨn da, ‘Yet ra yɨpa kapo nyɨ motkau kor nyɨ kɨma, nokɨp man Keriso ma nyɨ kɨma rɨga et, sɨ tina mɨra ma ɨta awɨr tainy dem.’ ");
INSERT INTO gdr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ɨ ra yɨpa rɨgat odede b'ɨga sobijog wa wɨngɨrɨnd yɨpa b'ɨgand negɨr mɨle omnɨkam omɨny yepim re Ken gar ke utkunda ke nokatenyi, ɨtemb re ma sobijog bebɨg e tainy tinɨm. Ajɨ ɨtemb jɨ b'ogɨljog e tinɨm, rako rɨgap tina kunakakɨnd ukoi gɨmo danda kɨma yɨjobɨko kai ke dɨde yɨsko ukoi sɨpa nyɨ bora wa ujɨm, sɨ ma rako onggɨt b'ɨgand negɨr mɨle omnɨkam yingawonj. ");
INSERT INTO gdr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ɨ ra moina yɨpa yɨmɨt men negɨr mɨle omnɨkam motɨny, man b'ogla ɨtemb yɨm ɨpenjɨt. Ɨtemb re b'ogɨljog e mornɨm yɨpa yɨm kesa b'ɨgaram ngɨrpu kesa yɨrkokar tungg wa. Ajɨ ma b'ogɨl emb jɨ nɨmog yɨm kɨma meket dem de wul tungg wa rokate re osouka kesa wul dɨmɨl yɨmbeneny. ");
INSERT INTO gdr_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Awɨr e) ");
INSERT INTO gdr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ɨ ra moina yɨpa pɨsɨt men negɨr mɨle omnɨkam motɨny, man b'ogɨl e ɨtemb jɨ pɨs ɨpenjɨt mor pɨlke. Ɨtemb re b'ogɨljog e mornɨm pɨsdudu kɨma b'ɨgaram ngɨrpu kesa yɨrkokar tungg wa. Ajɨ ma b'ogɨl emb jɨ nɨmog nɨmog pɨs kɨma mɨtɨskansi dem de wul tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Awɨr e) ");
INSERT INTO gdr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ɨ ra moina yɨpa yɨrkɨpɨt negɨr mɨle omnɨkam motɨny, man b'ogɨl e ɨtemb yɨrkɨp ɨtkasɨt mor pɨlke. Ɨtemb re b'ogɨljog e mornɨm yɨpaina yɨrkɨp kɨma b'ɨgaram de ngɨrpu kesa God ma pumb tungg wa. Ajɨ ma b'ogɨl emb jɨ nɨmog yɨrkɨp kɨma mɨtɨskansi dem wul tungg wa, ");
INSERT INTO gdr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","rokasim re uj kesa kupɨr wekeny rɨga jɨ kumbɨnd dadal ngɨrpu kesa dɨde osouka kesa wul dɨmɨl yɨmbeneny. ");
INSERT INTO gdr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ɨ komkesa gar ke utkunda rɨga wul ke kɨlkesa sɨ gasa im taukanj odede rɨngmim re yɨna sɨ rɨgap sol esankenenanj sɨ gasa kumbɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ɨ sol re b'ogɨl met omnɨka gasa e. Ajɨ ra sol solmet kesa tainy, sɨ wɨn yɨmta ke nangga gasa kae tina met ɨtenjya? Sɨ wɨn sol pɨla b'obogɨl wɨmena tuwenyɨt, ɨ ɨdenat wɨn ngɨmbla mɨle owama iyenya wa wɨngɨrɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ɨ Yesu ɨngkek ket yiwatonj dɨde ket yikenonj de Yuda eriya nata dɨde ket Yordan kɨlɨm yɨpa tab wa. Re rɨga bobo b'usaya Ti pɨlwa wuwenonj, Ton ket ɨja na kwa ten auyaeninonj rɨngmena re naskand ten auyaeneninonj. ");
INSERT INTO gdr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ɨ ket nɨnda Parisai rɨga Yesum pɨlwa tuwonj dɨde ket odede yɨt kɨma Tin yotonkeno da, “Rɨngma gog yɨtɨt yinj? Ra yɨpa rɨgat ti konggand bondɨk tomɨny, ton b'ogɨl e o ma b'ogɨl e?” ");
INSERT INTO gdr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ɨ Yesu ten mɨra amninonj da, “Rɨdede na Mose b'ingawa yoramitonj wa pɨlɨnd?” ");
INSERT INTO gdr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Sɨ ton mɨra yomno da, “Mose ningainonj da ra yɨpa rɨgat singi tainy ti konggand bondɨk omnam, ton b'ogla bondɨk omna peba tɨrɨkau dɨde ket ɨtomb kongga tewaikis.” ");
INSERT INTO gdr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ɨ Yesu ten amninonj da, “Mose onggɨtyam b'ingawa yɨt wanɨm yɨrɨkonj, nokɨp waina gar re rogɨlkak na. ");
INSERT INTO gdr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ajɨ re God naska gowukoi yotobarkonj, Ton rɨga amnɨkonj re rɨga ake kongga na. ");
INSERT INTO gdr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Onggɨt paemb rɨgat ti b'u ake ti mog terar ɨ dɨde ti kongga kɨma b'itɨnkisya. ");
INSERT INTO gdr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Sɨ osiemb jɨ molkongga yɨpaina jɨ i taya. Sɨ osiemb molkongga re ma nɨmog i, ajɨ ton yɨpaina jɨ i. ");
INSERT INTO gdr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Sɨ onggɨt paemb rɨna re God yɨpand enkitonj, goro yet wetaweta ramɨn.” ");
INSERT INTO gdr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ɨ re ket yɨpa met wa b'ɨgarkɨto, b'auyaena rɨgap Yesund yɨwatɨnto, ngɨrpu Tin yerkito onggɨtyam molkongga bond ke awou gatab. ");
INSERT INTO gdr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Sɨ Yesu ten mɨra amninonj da, “Yet ra ti konggand bondɨk tomɨny dɨde kwa yɨpa b'enga kongga tokas ti konggam, sɨ ton gigɨr dɨde yɨgyɨg b'iyena mɨle e omnɨka iyeny ɨtomb sisɨl kongga kɨma. Onggɨt gigɨr dɨde yɨgyɨg b'iyena mɨle ke, ton naskanyam konggand negɨr mɨle e omnɨka wiyenainy. ");
INSERT INTO gdr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ɨ kwa ra yɨpa konggat ti leond bondɨk omɨny dɨde b'enga rɨga okas ti leowɨm, ton kea ket gigɨr dɨde yɨgyɨg b'iyena mɨle e omnɨka iyeny ɨtemb sisɨl leo kɨma.” ");
INSERT INTO gdr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ɨ rɨgap towaina b'ɨga sobijog Yesum pɨlwa eyento odede nony kɨma da Yesu ten tasopainy b'ogɨl omnam. Ajɨ b'auyaena rɨgap ten samany kɨma rɨga ogoka eyento b'ɨga iyenam Yesum pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ajɨ re Yesu yɨr anginonj, Ton gar soro awonj Tina b'auyaena rɨga wa pɨlwa, ngɨrpu ten amninonj da, “Tou b'ɨga sobijog Kor pɨlwa. Goro b'ɨga ogoka eyenindam, mop nokɨp odede b'ɨga wa maemb jɨ God ma pumb tungg. ");
INSERT INTO gdr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ɨ Kon ɨmɨnjog wen wumɨr tamninyɨn da yet ra maka ra God ma pumb tungg ɨmɨnjog ke okas odede b'ɨga sobijog re dɨde, ton makwa ɨta b'ɨtgarɨk dem onggɨt God ma pumb tungg wa.” ");
INSERT INTO gdr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ɨ Yesu yɨpayɨpa b'ɨga yɨm ke ikwatena eyeninonj ɨ yɨm aramiteninonj towa pɨlɨnd b'ogɨl omnam. ");
INSERT INTO gdr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ɨ re Yesu menon yokatonj, nyawɨnd yɨpa rɨga Ti pɨlwa b'ɨtkonj ɨ ket Ti pɨl wa kumsos b'amkonj. Seg ton ket Yesund yerkitonj da, “B'ogɨl ouyaena rɨga-wɨi! Nangga e kon omnɨken dadal ngɨrpu kesa yɨrkokar owabɨntam?” ");
INSERT INTO gdr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ajɨ Yesu tin mɨra yomnonj da, “Nangga pena man Ken nogenaet da b'ogɨl rɨga? Makwa ɨta yete b'ogɨl rɨga ajɨ Godta tinta yɨpaina. ");
INSERT INTO gdr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Man wumɨr et jɨ opi re God ma b'ingawa yɨt, goro rɨga ongandɨm, goro gigɨr dɨde yɨgyɨg b'iyena mɨle omnɨka, goro yurowam, goro rɨga gatab yɨr ungati kesa b'anygɨnena yɨt usekɨm, goro okatɨm yɨpa rɨga ma gasa b'anygɨnena nya ke, tesnaet mor b'u ake mor mog.” ");
INSERT INTO gdr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Seg ton ket Yesund yomnonj da, “Ouyaena rɨga-wɨi! Kon kea komkesa onggɨtyam b'ingawa yɨt yɨmta undoka eyeneninond koina kewar wɨn ke ngɨrpu yu.” ");
INSERT INTO gdr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ɨ ket Yesu tin yɨr yɨpkonj dɨde singi yiyenonj, dɨde ket tin yomnonj da, “Man yɨpa gasa e yesungaet. Sɨ man meke! Ɨ nangga gasa im re mor mɨbnainy man tasoginyɨt, ɨ dɨde ket man komkesa osogi wulkɨp ogona teyeninyɨt gasa kesa rɨga wa. Ra man odede omnɨket, yɨmta ke ket mor jogjog b'ogɨljog gasa opima mɨtɨbnainy dem de pumb tungg wa. Seg ket man metket Kor pɨlwa dɨde ket yɨmta nutundoket!” ");
INSERT INTO gdr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ɨ onggɨt rɨgat ket as ɨrontonj ɨ ton ket gar bebɨg kɨma yiwatonj, mop nokɨp ti jogjog gasa na yɨbnainonj. ");
INSERT INTO gdr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ɨ Yesu yɨrɨk ɨnjomkena eyeninonj dɨde tina b'auyaena rɨga amninonj da, “Jogjog gasa kɨma rɨgam b'ɨgaram de God ma pumb tungg wa, ɨtemb re ma sobijog bebɨg e.” ");
INSERT INTO gdr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ɨ ket Yesu ma odede yɨt map, b'auyaena rɨgap kɨd kesa aukɨto. Sɨ Yesu b'usaya ten mɨra amninonj da, “Kor b'ɨgawar! Utkunda! God ma pumb tungg wa b'ɨgaram re ma sobijog bebɨg e. ");
INSERT INTO gdr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ukoi jɨ b'angga kamel b'ɨgaram de nidɨl bora wa, ɨtemb re jɨ ma bebɨg e, ajɨ jogjog gasa kɨma rɨgam God ma pumb tungg wa b'ɨgaram, ɨtemb re jɨ ukoijog bebɨg e.” ");
INSERT INTO gdr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yɨt seg ke B'auyaena rɨgap ɨsanikesa ukoijog kɨd kesa aukɨto, ɨ ket towalenggyam b'arkento da, “Sɨ yete rɨrɨr e yɨrkokar okatam?” ");
INSERT INTO gdr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu ten yɨr epkinonj dɨde ket amninonj da, “Rɨgam onggɨtyam gasa ti omnɨkam re ma rɨrɨr im, ajɨ Godɨm nena Ti rɨrɨr im. Mop nokɨp Godɨm re komkesa gasa rɨrɨr im Ti omnɨkam.” ");
INSERT INTO gdr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Sɨ ket Petro Yesund yomnonj da, “Yɨr de, sɨn komkesa gasa erarkɨtondam dɨde ket mena yɨmta undoka miyenyu. Sɨ rɨngmim taukanj sowanɨm?” ");
INSERT INTO gdr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ɨ Yesu mɨra amninonj da, “Kon ɨmɨnjog wen tamninyɨn da yepiya re erarkɨto towa met, towa nanywar, towa yɨngganwar, towa mog, towa b'u, towa b'ɨgawar, dɨde towa gou kor map dɨde God ma b'ogɨl yɨrkokar bage yɨt map, ");
INSERT INTO gdr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ton ɨmɨnjog opima andredpyam takatanj onggɨt gowukoyɨnd met, nanywar, yɨngganwar, mog, b'ɨga dɨde gou, ajɨ ton opima bebɨg dɨde b'ɨsadrena mɨle takatenanj rɨga wa pɨlke God ma yɨt yɨmta undokand. Ɨ ton ɨmɨnjog dadal ngɨrpu kesa yɨrkokar okasi dem de sisɨl gowukoi wa rɨnte ra ik dem. ");
INSERT INTO gdr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ajɨ rɨga yepim re yu ukoijog nyɨ rɨga pɨla wekeny, towa wɨngɨrɨnd jogjog rɨga opima yɨmta ke sobijogjog nyɨ rɨga taukanj dem. Ɨ rɨga yepim re yu sobijogjog nyɨ rɨga pɨla wekeny, towa wɨngɨrɨnd jogjog rɨga opima yɨmta ke ukoijog nyɨ rɨga taukanj dem.” ");
INSERT INTO gdr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Re ton menon yokato de Yerusalem taun wa, nyawɨnd Yesu naskanaska nya yɨmayonj. Sɨ twelp (12) ɨtmɨkitijog rɨga gɨmɨrom kɨma kaktɨtɨ aukɨto dɨde kwa nɨnda Tina yɨmta undoka rɨgap daka moga aukɨto. Ɨ Yesu ket b'usaya twelp (12) ɨtmɨkitijog rɨga kɨma yɨpand awonj, dɨde Ton ket amninonj Ti gatab yɨt rɨnsim ra taukanj dem Ti pɨlɨnd ");
INSERT INTO gdr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","da, “Yɨr de, men menon yokasu re Yerusalem ma. Yɨpa rɨgat ɨta Rɨgamna B'ɨgand tɨb yii dem dɨde takainy dem yɨna mopyam sɨ rɨga dɨde Ju rɨga waina gog ouyaena rɨga wa pɨlwa, ɨ ket tonpim tɨrɨr omnyi dem Tin ongandam. Ɨ dɨde ton ket Tin yiyi dem de God ma obagɨki kesa rɨga wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ɨ ton ket God ma obagɨki kesa rɨgap Tin ngong engena kɨma jɨ malɨk omnɨka iyenyi dem, Tin auya ɨtmanda iyenyi dem, ɨ Tin ɨraska iyenyi dem, ngɨrpu onganji dem. Seg ket nowam bibɨrɨnd Ton tutnyis dem uj ke.” ");
INSERT INTO gdr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ɨ Jebedaimna b'ɨga Yakobo ake Yoan Yesum pɨlwa tetkonda dɨde Tin yomnonda da, “Ouyaena rɨga-wɨi, sɨn singi da Man yɨpa gasa sowanɨm omnɨket nangga mana ra sɨn metɨrkisya.” ");
INSERT INTO gdr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Sɨ Yesu ten mɨra amnonj da, “Nangga gasa mi wɨn singi aya Kon wanɨm omnɨkam?” ");
INSERT INTO gdr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ɨ ket nanyɨngganɨp Yesund yomnonda da, “Ra Man king nyɨ okasɨt dem b'ogɨl ɨnyomarena kɨma, sowa notkaet nɨmog pɨpmet omitam yɨpa Moina yɨmjog yɨm tab ke ɨ yɨpa kwa sawai yɨm tab ke.” ");
INSERT INTO gdr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ɨ Yesu ket ten amnonj da, “Wɨn ma wumɨr i nangga ma wɨn nerkisya. Rɨka wɨn rɨrɨr i Koina b'ɨdgotnena kapo nyɨ onayam rɨnte ra Kon onaen dem, dɨde Koina ujɨm baptiso okatam rɨnte ra Kon okasɨn dem?” ");
INSERT INTO gdr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ajɨ ton tin mɨra yomnonda da, “Sɨn rɨrɨr i.” Sɨ Yesu mɨra amnonj da, “Wɨn b'ogɨl i onaya dem Koina b'ɨdgotnena kapo nyɨ rɨnte ra Kon onaen dem, dɨde Koina ujɨm baptiso okasya dem rɨnte ra Kon baptiso okasɨn dem. ");
INSERT INTO gdr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ajɨ omitam gatab ɨt re Kor yɨmjog yɨm tab wa dɨde sawai yɨm tab wa, ɨtemb re ma Kor ogona gasa im. Ajɨ God towa mi jɨ pɨpmet takau dem yama na re Ton angonjenawonj.” ");
INSERT INTO gdr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ɨ re ten (10) ɨtmɨkitijog rɨgap onggɨtyam yɨt utkundo, ton Yakobo ake Yoan wa pɨlwa soro aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Seg Yesu ket komkesa b'auyaena rɨga ara emokinonj Ti pɨlwa menonɨm dɨde ten amninonj da, “Wɨn wumɨr im da wɨp iyoi rɨga yepim re rɨga angwatenanj God ma obagɨki kesa rɨga wa wɨngɨrɨnd, ton towaina rɨga wanɨm aukenenanj re yonggyam im, dɨde kwa towaina ukoijog nyɨ rɨgap ɨsanikesa danda engaenenanj towaina rɨga wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sɨ wa wɨngɨrɨnd re ma ɨja e jɨ. Ajɨ wa wɨngɨrɨnd yet ra singi tainy ukoi rɨga awowɨm, ton b'ogla waina wɨko rɨga rau. ");
INSERT INTO gdr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ɨ daka kwa wa wɨngɨrɨnd yet ra singi tainy pumbjog wa ukoi rɨga wɨmenam, ton b'ogla komkesa rɨgaina goujog wɨko rɨga rau. ");
INSERT INTO gdr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mop nokɨp Rɨgamna B'ɨga ma odede mop pena ikonj onggɨt gowukoi wa da rɨga Tinɨm wɨko rɨga taukanj. Ajɨ Ton ikonj re rɨga wa wɨko rɨga awou mana dɨde Tina yɨrkokar ke jogjog rɨgaina negɨr mɨle ɨraba mɨra okawa mana.” ");
INSERT INTO gdr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ɨ ton ket tuwonj de Yeriko wa. Ɨ re Yesu Yeriko ke yiwatonj Tina b'auyaena rɨga dɨde ukoi rɨga bobo kɨma, yɨpa yɨrdɨdɨ rɨga, Bartimeo ɨt re Timaiyo ma b'ɨga, ton nya yɨund omiti yɨbnenenonj wulkɨp b'ɨjenenand. ");
INSERT INTO gdr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ɨ re ton utkundonj da Najaret tunggam Yesute yik, ton ket Yesund b'okta ara yɨawonj da, “Dawidɨmna b'ɨga, Yesu-wɨi! Kear nomne-o!” ");
INSERT INTO gdr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ajɨ jogjog rɨgap tin samany yiyowo da, “Muma kesa ae!” Ajɨ ton kwa ara yoikɨndenawayonj da, “Dawidɨmna b'ɨga-wɨi! Kear nomne-o!” ");
INSERT INTO gdr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Seg ket Yesu omanda onyitonj, ɨ ket rɨga amninonj da, “Tin ara yemoka!” Ɨ rɨgap ket onggɨt yɨrdɨdɨ rɨgand ara yemoko da, “Sam ae! Utnyite! Ton ke ara memok.” ");
INSERT INTO gdr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ɨngkek ket ton tina kobɨrgɨm b'ɨskantonj, dɨde b'atiyakena yikonj Yesum pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ɨ Yesu tin yerkitonj da, “Nangga ma man singi aet Kon mornɨm omnɨkam?” Seg onggɨt yɨrdɨdɨ rɨgat Tin mɨra yomnonj da, “Ouyaena Rɨga! Kon singi en yɨr opngendam.” ");
INSERT INTO gdr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ɨ Yesu tin yomnonj da, “Yiwate! Moina gar ke utkundate men mɨsakenj.” Seg odenja ket ɨtemb yɨrdɨdɨ rɨgat yɨr b'ɨskena yikenonj dɨde ket Yesund yɨmta yundokonj nyawɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ɨ ton ket Yerusalem taun wuswus wa aukɨto dɨde ket opento de Betpage tungg dɨde Betaniya tungg wa rɨna re Olib dorɨnd ebnonda. Ɨ ɨngkenaemb ket Yesu Tina nɨmog b'auyaena rɨga etmɨkitonj ");
INSERT INTO gdr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","odede yɨt kɨma da, “Wɨn eka onggɨt tungg wa rɨnte re wa wɨp ke yɨbɨm! Ra wɨn onggɨt tungg wa b'ɨtgarya, odenja odarya dor yɨpa dongki b'ɨga rɨnte re kai ke wulɨm pɨlɨnd ɨjobɨki yɨbɨm dɨde makaya yɨpa rɨgat angis tina teskak kumbɨnd. Sɨ wɨn ket kai ɨtrekya dɨde iya dor kor pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ɨ ra yɨpa rɨgat wen tarkis dor da, ‘Wɨn nangga pae odede yomnɨkya?’ wɨn b'ogla wumɨr omnya dor da, ‘Yonggyam ɨtemb dongki b'ɨga singi e yomɨny ingawam’. Ɨ ra wɨn yɨt opurena seg taya dor, ɨtemb rɨga odenja e ɨtmɨkis dor dɨkɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Re ket ton nɨmog b'auyaena rɨga opendonda de onggɨt tungg wa, ton kea yodaronda yɨpa dongki b'ɨga rɨna re ɨjobɨki yɨbnonj yɨpa met mora wusɨnd, ngɨrpu ton ket dongki kai yɨtrekonda. ");
INSERT INTO gdr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ɨ nɨnda onyiti rɨgap ten amno da, “Nangga pae wɨn dongki b'ɨga kai yɨtrekya?” ");
INSERT INTO gdr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ɨ ton ket mɨra amninonda rɨja na re Yesu ten amnonj. Ɨngkek ket rɨgap ten etmɨkito. ");
INSERT INTO gdr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ɨ ton ket ɨtemb dongki b'ɨga iyonda Yesum pɨlwa dɨde towaina tumɨnd kobɨrgɨm dongki kumb wa aramkinonda. Seg Yesu dongki kumb wa angitonj. ");
INSERT INTO gdr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ɨ jogjog rɨgap kea towaina tumɨnd kobɨrgɨm Tina menonpu nyawɨnd ondrɨka eito, ɨ dɨde kwa jogjog rɨgap wulpip epkɨto sopapund dɨde nyawɨnd ondrɨka eito ukoi ɨsnawa kɨma. ");
INSERT INTO gdr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ɨ rɨga yepiya re ti wɨp nata dɨde ti kak nata wuwonj, ton b'okta ara kɨma ger ɨtanga yiyo da, “Osanna, sowa Yɨrkokar Okawa Rɨgam pɨlwa! Ɨta God ma b'ogɨl Man kɨma yete re Yonggyamɨm nyɨ kɨma ik! ");
INSERT INTO gdr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ɨta God ma b'ogɨl mera b'u Dawid ma kantrim pɨlwa rɨnte re ik! Osanna, pumbjog Godɨm pɨlwa!” ");
INSERT INTO gdr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ɨ re Yesu opendonj de Yerusalem taun wa, Ton ket b'ɨgaronj de yɨnamet aba wa ɨ dɨde Ton kwa yɨr eyeninonj komkesa gasa. Ɨ kea daka bibɨr wɨn awɨr auka yikonj, Yesu ket opendonj ɨ yikonj Betaniya wa Tina Twelp (12) ɨtmɨkitijog rɨga kɨma. ");
INSERT INTO gdr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ɨ yɨpa bibɨr kak ke re Ton yiwato Betaniya tungg ke, Yesu owoupa na awonj. ");
INSERT INTO gdr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ɨ re Yesu pajapaja yɨr yongonj yɨpa pig wul rɨna re jogjog rom kɨma yɨbnonj, Ton yikonj onggɨt wul mop wa wulkɨp orakam. Ajɨ re Ton ket wul mop wa onyitonj, ton makwa pig kɨp yɨr anginonj, ajɨ rom nena na wekenonj. Nokɨp ɨtemb re ma pig kɨp wɨn na. ");
INSERT INTO gdr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Sɨ Yesu ket ɨtemb pig wul yomnonj da, “Makwa ɨta yete yɨmta ke mor pɨlke kɨp ou dem.” Re ton pig wul sake yomnonj, kea Tina b'auyaena rɨgap Tina yɨt utkundo. ");
INSERT INTO gdr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Seg re ton wuwonj de Yerusalem taun wa, Yesu ket b'ɨgaronj yɨnamet aba wa. Ɨ Ton ket eaukeninonj rɨga yepiya re Godɨm sɨ gasa asogenento dɨde rɨga yepiya re imda eyenento yɨnamet aband. Ɨ dɨde ket Ton gu engendurkena eyeninonj wulkɨp sensi omnenapu kasa rɨkɨnd re b'engabenga wulkɨp wekenonj ogonam dɨde yɨnamet teks wulkɨp imdam, dɨde Godɨm sɨ gasa gimai osogapu kasa. ");
INSERT INTO gdr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ɨ Yesu ogoka eyeninonj da makwa ɨta yɨpa rɨgat gasa teyeniny yɨnamet aba nata. ");
INSERT INTO gdr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ɨ ket Yesu rɨga auyaeninonj dɨde amninonj da, “Yɨna peband ɨja emb jɨ yɨnamet gatab ɨrɨki yɨbɨm da, ‘Rɨgap b'ogla Koina met yagenae yɨr opmitenapu met ke komkesa b'engabenga yɨtam wa.’ Ajɨ wɨnpim ɨtemb yɨnamet wɨp yomnɨkya da raskol waina wɨmenapu met e.” ");
INSERT INTO gdr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sɨ yɨna mopyam sɨ rɨga dɨde Ju rɨga waina gog ouyaena rɨgap kea utkundo onggɨt gatab yɨt rɨna re Yesu gasa amnɨkinonj yɨnametɨnd. Ɨ re ton utkundo da komkesa rɨga bobo re kea Yesu ma ouyaena ke sam kɨma kɨd kesa aenanj, ton ket Yesund moga yuwado. Sɨ onggɨt penaemb ton nya oraka yiyeno Yesund ongandam. ");
INSERT INTO gdr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ɨ re sɨ imokonj, Yesu dɨde Tina b'auyaena rɨga kɨma yɨpand yiwato Yerusalem taun ke. ");
INSERT INTO gdr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ɨ ɨspari ke re ket Yesu dɨde Tina b'auyaena rɨga menon yokato de Yerusalem taun wa, nyawɨnd ton ɨtemb pig wul yɨr yongo re komkesa yarɨmkak uj ai na ap ke de ngɨrpu pipkak wa. ");
INSERT INTO gdr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Sɨ Petro re kea nonyɨnd awaminonj Yesu ma sake yɨt rɨna re pig wulɨm pɨlwa yopulitonj. Ɨ ton ket Yesund yomnonj da, “Ouyaena Rɨga-wɨi! Yɨr de, ɨtemb pig wul rɨna re Man sake yomnyɨmɨt re ke yarɨmkak uj ai e yɨbɨm.” ");
INSERT INTO gdr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ɨ Yesu ten mɨra amninonj da, “Wɨn Godɨnd gar ke utkunda ke yokata! ");
INSERT INTO gdr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kon ɨmɨnjog nitinjɨn da yet ra yɨpa rɨgat opulis onggɨt dorɨm pɨlwa da ‘Molenggyam b'uromate dɨde molenggyam b'ɨskante sɨpa wa,’ dɨde ra ton maka nony nɨmognɨmog taeny tina garɨnd, ajɨ ra ton gar ke utkunda oramis da ‘Koina opuliti yɨt ɨta ɨmɨnjog tawɨk,’ sɨ ket ɨtemb tina yɨt ɨta ɨmɨnjog tinɨm tawɨk. ");
INSERT INTO gdr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Odede paemb kon wen wumɨr tamninyɨn da nangga mana ra wɨn yɨr opmita ke b'arkita taramisindam ɨ ra wɨn gar ke utkunda oramisya da ‘Sɨn ke mɨra akasindam,’ sɨ ket opimemb gasa opima ɨmɨnjog taukanj wanɨm. ");
INSERT INTO gdr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ɨ ra wɨn yɨr opmitam tonyisindam, wɨn b'ogla komkesa rɨga wa komkesa negɨr mɨle awɨr omnɨka teyenaindam rɨnsim re wɨn nonyɨnd owama eyenindam. Nokɨm da ɨdenat wa B'u God yete re yɨbɨm pumb tungg wa, Todaka kwa wa negɨr mɨle awɨr tamnɨkainy.” ");
INSERT INTO gdr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Awɨr e) ");
INSERT INTO gdr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ɨ Yesu dɨde Tina b'auyaena rɨga b'usaya wuwonj Yerusalem taun wa. Ɨ re Yesu menon yokatonj yɨnamet aba nata, odedend ket yɨna mopyam sɨ rɨga, Ju rɨga waina gog ouyaena rɨga dɨde Ju rɨga waina elda rɨga ket tuwonj Ti pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ɨ ton Yesund yerkito da, “Man nangga juwai kaim onggɨtyam gasa amnɨkinyɨt? Ɨ yet Mor onggɨtyam juwai mokawonj onggɨtyam gasa omnɨkam?” ");
INSERT INTO gdr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ɨ Yesu ket ten mɨra amninonj da, “Sɨ Kon yɨpa yɨt gatab e wen tarkisinyɨn. Wɨn b'ogla mɨra notɨnya! Sɨ onggɨt kak kaim Kon wen wumɨr tamninyɨn nangga danda kaim Kon onggɨtyam gasa amnɨkinyɨn. ");
INSERT INTO gdr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Wɨn wumɨr nomna! Rɨngma, Yoanɨmna baptiso Godɨm pɨlkae ikonj, o mɨnda rɨka rɨga wa pɨlkae?” ");
INSERT INTO gdr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ɨ ton towa wɨngɨrɨnd yɨt b'ɨglenena wuwenonj da, “Ra men mɨra omnyu da, ‘Godɨm pɨlkae,’ sɨ Ton opima netɨrkisiny dor da, 'Sɨ wɨn nangga pena maka Yoanɨmna baptiso gatab gar ke utkunda ke yokatonda?’ ");
INSERT INTO gdr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Rɨngma men jaba nitinjindam da, ‘Rɨga wa pɨlkae'?” Ajɨ ton rɨga bobo na moga uwadto. Mop nokɨp komkesa rɨgap Yoanɨnd ɨmɨnjog kae yokatenyi da ton re ɨmɨnjog God ma yɨpa bageyam na. ");
INSERT INTO gdr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Sɨ ton ket Yesund mɨra yomno da, “Sɨn ma wumɨr im.” Ɨ Yesu daka ket ten mɨra amninonj da, “Sɨ Kodaka ma opima wen wumɨr tamninyɨn nangga danda kaim Kon onggɨtyam gasa amnɨkinyɨn.” ");
INSERT INTO gdr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Seg Yesu tendam yɨt ke ten amninonj da, “Yɨpa rɨgat greip nangg ɨtot eyeninonj tina gowɨnd, ɨ sopapund kotal eror yiyenonj, ɨ greip kɨp ungka gasa oramitam gou kip yoskonj, ɨ dɨde sopapu yɨr ɨpkam yɨpa pumbpumb met yorangonj. Seg re ket ton nɨnda wala rɨga kɨma yɨtnono aento dɨde tɨrɨr yomno da, ‘Ra kɨp wɨn okas dem, yonggyam opima sopapu mɨra greip kɨp takasiny dem.’ Yɨt seg ke, ton ket sopapu towa akainonj dɨde menon yokatonj b'enga kantri wa. ");
INSERT INTO gdr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Re greip kɨp wɨn yokatonj, ɨtemb yonggyam ton yɨpa tina wɨko rɨga yɨtmɨkitonj opimemb wala rɨga wa pɨlwa sopapu ke nɨnda mɨra greip kɨp okatam. ");
INSERT INTO gdr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ɨ wala rɨgap ɨtemb tina wɨko rɨga yokato, yipowo, dɨde yɨtmɨkito mɨra omni kesa. ");
INSERT INTO gdr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Sɨ yonggyam kwa nɨmogɨm tina b'enga wɨko rɨga yɨtmɨkitonj. Ajɨ ton wala rɨgap tin mop yowarato, dɨde ɨngar kɨma nenegɨr kana yomneno. ");
INSERT INTO gdr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ɨ ton kwa yɨpa b'enga yɨtmɨkitonj. Ajɨ kea ton wala rɨgap kwa tin yongando uj tama na. Ɨ kwa b'usaya jogjog etmɨkisinonj, ajɨ ton wala rɨgap kwa nɨnda epouto, dɨde nɨnda angandto uj tama na. ");
INSERT INTO gdr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Seg ɨna yɨpaina ti b'ɨgat komb awonj ɨtmɨkitam yena re ton singi yiyenenonj. Sɨ yonggyam ton kikitumam ɨtemb tina b'ɨga yɨtmɨkitonj towa pɨlwa odede nony kɨma da, ‘Ton opima koina b'ɨgand ɨsnai dem.’ ");
INSERT INTO gdr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ajɨ re onggɨt wala rɨgap towa yonggyamɨmna b'ɨga yɨr yongo, ton towalenggyam apurento da, ‘Ɨtemb b'ɨga re tina sopapu owabɨnta rɨga e. Sɨ b'ogɨl e, men tin yangandu. Ɨ men ɨdenatemb ket owabɨnta rɨga taindam onggɨt sopapum.’ ");
INSERT INTO gdr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Seg ton ket tin yokato dɨde uj tama na yongando, ngɨrpu yɨskanto greip sopapu bau wa. ");
INSERT INTO gdr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Sɨ nangga e ket onggɨt greip sopapu yonggyamɨt omnɨk dem? Sɨ ton ɨta ik dem onggɨt wala rɨga wa pɨlwa dɨde ket ten uj tama na tanganjiny dem. Ɨ ton ket ɨtemb greip sopapu takainy dem b'enga rɨga wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ma wɨn maka odede yɨtkak agenkɨtondam yɨna peband, ɨte re da, ‘Yɨpa Motɨr met oranga rɨgap b'ɨsayo met orangam, ajɨ God ket yɨmta ke met wugɨnd yoramitonj onggɨt met emorkam. Sɨ Ton ket ɨmɨnjog ɨsnawa kɨma Motɨr na awonj onggɨt met oranga wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ɨ ɨtemb re Yonggyam Godɨm pɨlkaemb jɨ aukonj, sɨ kwa ɨtemb re otomantijog na aukonj mera yɨrɨnd'?” ");
INSERT INTO gdr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sɨ onggɨt Ju rɨga waina wɨp iyoi rɨgap yepiya re wekenonj onggɨt pɨpmetɨnd, ton nya oraka eyento Yesund yɨmɨnd okatam. Mop nokɨp ton kea wumɨr yokato da, “Ton sɨna tendam yɨt ke nomneniny.” Ajɨ ton rɨga bobo map moga auto, ɨ Yesund yɨraro ɨ dɨde ket yiwato. ");
INSERT INTO gdr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Sɨ ket Ju rɨga waina mopyam rɨgap Parisai rɨga dɨde Erodɨmna yɨmta undoka rɨga wɨngɨrɨnd nɨnda rɨga emdɨto dɨde etmɨkurto Yesum pɨlwa. Nokɨm da ɨdenat ton b'anygɨnena nya ke Tina negɨr yɨt okasi dɨde onggɨt Tina yɨt ke Tin negɨr omnyi. ");
INSERT INTO gdr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ɨ ton ket tuwonj Yesum pɨlwa dɨde ket Yesund yomno da, “Ouyaena rɨga! Sɨn wumɨr im da Man ɨmɨnjog rɨga et. Ɨ Man makwa ɨta yena moga yuwadenenyɨt. Mop nokɨp Man makwa gɨm kaim rɨga wa pɨlɨnd bu b'iyena mɨle amnɨkeneninyɨt ajɨ komkesa rɨga yɨpa rɨrɨrkɨp im dɨmdɨm amnɨkeneninyɨt. Ajɨ Man Godɨmna nya kaim ɨmɨnjog yɨtkak rɨrɨrɨnd rɨga auyaeninyɨt. Sɨ rɨngma, Roma kantri mopyam king Kaisam teks ogonam, ton b'ogɨl e o ma b'ogɨl e? B'ogɨl e sɨn ogonenindam o ma sɨn opima ogonenindam?” ");
INSERT INTO gdr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ajɨ Yesu kea towaina mɨle nony ke akatawonj da ton gɨm ke b'ogɨl yɨt im apurenanj ajɨ towaina garɨnd re yɨpa nenegɨr nya ke otonkena mɨle e yɨbɨm. Sɨ Ton ket ten amninonj da, “Nangga pae wɨn nenegɨr nya ke Ken otonkena niyenya? Yɨpa Roma kantri wulkɨp denari iya dɨde Ken nouyawa!” ");
INSERT INTO gdr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ɨ re ton iyo yɨpa denari, Yesu ten arkisinonj da, “Yaina wɨp e dɨde nyɨ e ɨrɨki i jɨ onggɨt wulkɨpɨnd?” Ɨ ton ket mɨra yomno da, “Roma kantri mopyam king Kaisamna i.” ");
INSERT INTO gdr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Sɨ Yesu ten amninonj da, “Wɨn Kaisam ogonindam nangga im re Kaisa ma ogenaya gasa, ajɨ Godɨm ogonindam nangga im re God ma ogenaya gasa.” Re yɨt seg ke ton ma sobijog na kɨd kesa aukɨto onggɨtyam yɨt gatab. ");
INSERT INTO gdr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ɨ Sadukai rɨga tuwonj Yesum pɨlwa yepiya re apurenento da, “Rɨga ma opima uj ke tutnɨkanj dem.” Ɨ ton ket Yesund yerkito da, ");
INSERT INTO gdr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ouyaena rɨga! Mose God ma yɨna peband erɨkinonj meranɨm omnɨkam da, ‘Ra yɨpa rɨga uj tainy dɨde ti konggand tɨrar b'ɨga oraki kesa, ti nany o ti yɨngganɨt tokas ɨtomb mik ɨ ti nanyɨm o ti yɨngganɨm nyɨ kɨma im b'ɨga tarakiny.’ ");
INSERT INTO gdr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ɨ ket seben (7) nanyɨngganwar wekenonj. Ɨ nanyam rɨgat yɨpa kongga wokatonj ɨ b'ɨga oraki kesa uj awonj. ");
INSERT INTO gdr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sɨ ti wus ke yɨngganɨt ti nany ma mik wokatonj ɨ dɨde kwa toda b'ɨga oraki kesa uj awonj. Ɨ dɨde kwa ti wus ke yɨngganɨt toda kwa odede na awonj. ");
INSERT INTO gdr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Sɨ komkesa seben (7) nanyɨngganwar ɨtomb yɨpaina konggand okatena tiyo dɨde uj aukɨto b'ɨga oraki kesa. Seg ket kikitumjog ɨtomb kongga todaka uj awonj. ");
INSERT INTO gdr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ɨ ra uj rɨga utnyita wɨn ik dem, ɨtomb kongga opimemb seben (7) nanyɨngganwar wɨngɨrɨnd yama ɨmɨnjog kongga tainy dem? Nokɨp komkesa seben (7) nanyɨngganwarpiya kemb onggɨt konggand towa konggam b'ɨsatena tiyo.” ");
INSERT INTO gdr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sɨ Yesu ket mɨra amninonj da, “Wɨn ma wumɨr im God ma yɨna peba dɨde God ma danda. Ma ma wɨn onggɨt paemb uj ke utnyita gatab negɨr nya ke wumɨr yokatenya? ");
INSERT INTO gdr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mop nokɨp ra rɨga uj ke tutnɨkanj dem, rɨgap ma opima kongga okata mɨle dɨde leo okata mɨle tamnɨkanj dem, ajɨ ɨja im tekeny dem rɨngmim re aneru wekeny pumb tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Maka wɨn agenkɨtondam uj dɨde utnyita gatab yɨt rɨna re Mose erɨkinonj God ma yɨna peband? God ɨja naemb jɨ Mosem pɨlwa yindonj Sinai dorɨnd onggɨt so omni b'uwaepɨnd da, ‘Kon re Abraamɨmna God en, ɨ Isakɨmna God en, ɨ dɨde Yakobɨmna God en.’ ");
INSERT INTO gdr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Sɨ God re ma uj rɨgaina God e ajɨ yilo rɨgaina God e. Sɨ wɨn kea onggɨtyam yɨt wumɨr kesand nenegɨr nya ke yokatenya.” ");
INSERT INTO gdr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ɨ onggɨt wɨnɨnd yɨpa Ju rɨga waina gog ouyaena rɨga ikonj ɨ ket utkundenonj rɨja na Sadukai rɨga Yesu kɨma yɨt b'ugwatena wuwenonj. Ɨ ton ket wumɨr yokatonj gar ke da, “Yesu b'ogɨljog im mɨra amneniny.” Seg ton ket Yesund yerkitonj da, “Komkesa God ma b'ingawa yɨt wɨngɨrɨnd rɨnggɨtyam e ukoijog b'ingawa yɨt yɨbɨm?” ");
INSERT INTO gdr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu mɨra yomnonj da, “Ukoijog b'ingawa yɨt ɨntemb jɨ yɨbɨm. Israel rɨga man utkunde! Mera Yonggyam Godta Tinta yɨpaina Yonggyam yɨbɨm. ");
INSERT INTO gdr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ɨ man moina Yonggyam Godɨnd singi yiyene moina kupkakupka kɨd ke, ɨ moina kupkakupka wɨngawɨnga ke, ɨ moina kupkakupka nony ke, ɨ dɨde moina kupkakupka danda ke! ");
INSERT INTO gdr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ɨ nɨmogɨm b'ingawa yɨt ɨntemb jɨ singi yiyene mor rɨgand mada re dɨde! Awɨr e kwa yɨpa ukoijog b'ingawa yɨt yɨbɨm onggɨtyam nɨmog b'ingawa yɨt pumb ke.” ");
INSERT INTO gdr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Seg ton Ju rɨga waina gog ouyaena rɨgat ket Yesund mɨra yomnonj da, “B'ogɨljog e, ouyaena rɨga! Man ɨmɨnjog na mindenyɨt da, ‘Godta Tinta yɨpaina yɨbɨm, ɨ makwa ɨta b'enga, ajɨ ɨtaemb Ton Tinta yɨpaina.’ ");
INSERT INTO gdr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ɨ kwa Moina yɨt b'ogɨljog i Godɨnd singi iyenam komkesa kɨd ke, komkesa nony ke, dɨde komkesa danda ke. Ɨ kwa mor rɨgand singi iyenam mada re dɨde. Osiemb nɨmog b'ingawa yɨt re ukoijog b'ingawa yɨt i ebnya. Ajɨ komkesa Godɨm pɨlwa oramiti Godɨm singi sɨ gasa re ma ukoijog im, opi re Godɨm singi sɨ gasa rɨnsim re men b'angga embrɨkenenindam dɨde singi gasa yogonenindam Godɨm pɨlwa yɨnametɨnd.” ");
INSERT INTO gdr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ɨ re Yesu tin yɨr yongonj b'obogɨl nony kɨma mɨra omnenand, Ton tin yomnonj da, “Man ma paja e aet God ma pumb tungg ke.” Seg ket makwa yɨpa rɨgat Yesund yerkitonj, nokɨp komkesa rɨga re moga na aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ɨ re Yesu ouyaena eyeninonj yɨnametɨnd da, “Nangga rɨl paim meraina gog ouyaena rɨgap opurena eyenanj da, ‘Keriso re Yonggyam Dawidɨmna B'ɨga e’? ");
INSERT INTO gdr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ajɨ re Yɨnayɨna Wɨngawɨnga Dawidɨm nony menamena yokawonj, sɨ Dawid Kerisom gatab yindonj tina tugɨmjog ke da, ‘Yonggyam God, kor Yonggyamɨm pɨlwa yindeny da, “Omite Koina yɨmjog yɨm tab ke juwai kɨma pɨpmetɨnd, ngɨrpu ra ket Kon Moina komkesa geja rɨga gou wa tamninyɨn dem dɨde taramisinyɨn dem Moina pɨs wɨrand moina danda ondratenam towa kumbɨnd!” ’ ");
INSERT INTO gdr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawid tina tugɨm ke Kerisond yogenayonj da, ‘Kor Yonggyam’. Sɨ rɨdede nya kae Keriso Dawidɨmna B'ɨga tainy? Sɨ Ton re Dawidɨmna B'ɨga e ajɨ kwa ti Yonggyam e.” Ukoi bobo rɨgap Yesu ma b'ogɨl nony menamena kɨma yɨt utkundeno re ukoi sam kɨma na. ");
INSERT INTO gdr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ɨ Yesu odede ouyaena yɨt ke amninonj da, “Wɨn yɨr kɨma tekenyɨt meraina gog ouyaena rɨga gatab. Ton singi im aenanj b'ogɨl pɨnpɨn kobɨrgɨm kɨma menamenam, ɨ ton kwa singi aenanj rɨga wa pɨlke simesime okatam maketpu nata. ");
INSERT INTO gdr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ɨ ton kwa ukoijog wɨp ke pɨpmet akatenenanj meraina yɨr opmitenapu met nata, ɨ dɨde kwa ton ukoijog ɨsnawa kɨma rɨgaina omitenapu kasand omitenenanj ukoi diyamdiyampu pɨpmet nata. ");
INSERT INTO gdr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ɨ ton mik kongga waina gasa endwatenenanj, dɨde kwa rɨga ouyawam dɨde yɨr ongongɨm pɨnpɨn kana yɨr opmitenenanj. Sɨ odede rɨgap opima ukoijog negɨr mɨra takatenanj dem b'ɨsagɨka wɨnɨnd, ajɨ nɨnda rɨga re ma odede ukoi negɨr mɨra im takatenanj dem ton re dɨde.” ");
INSERT INTO gdr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ɨ yɨpa wɨnɨnd Yesu wulkɨp oramkapu boks wɨp ke omitonj yɨnamet gasa ongapapu met wusɨnd, dɨde ket yɨr ɨpka eyeninonj rɨdede na rɨgap wulkɨp aramkɨto wulkɨp boks bora wa. Sɨ jogjog gasa kɨma rɨgap aramkɨto re ukoi wulkɨp na. ");
INSERT INTO gdr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ajɨ yɨpa gasa kesa mik kongga tikonj dɨde ket nɨmog kɨp sobijogjog uj peni nena na aramitonj. ");
INSERT INTO gdr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ɨ re Yesu Tina b'auyaena rɨga ara emokinonj ɨ ten amninonj da, “Kon ɨmɨnjog wen tamninyɨn. Ma yɨpa kɨma rɨgapiya wulkɨp aramkanj onggɨt boks borand, ajɨ onggɨt gasa kesa mik konggato ukoijog wulkɨp aramis onggɨt komkesa rɨga wa wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mop nokɨp komkesa rɨgap onggɨtyam towaina ukoi wulkɨp wɨngɨrɨnd sobijog kana na aramkanj. Ajɨ ɨtomb mik kongga re ti lesmɨta wulkɨp na aramis tina wulkɨp kesa wɨngɨrɨnd. Sɨ ɨtemb tina oramiti wulkɨp re tina kupka yɨrkokar naemb jɨ.” ");
INSERT INTO gdr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ɨ re Yesu yɨnamet yɨraronj, yɨpa Tina b'auyaena rɨgat Tin yomnonj da, “Ouyaena rɨga-wɨi! Yɨr angine! O, nomae ukoi motɨr dɨde b'ogɨl otomanti met im opi!” ");
INSERT INTO gdr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ɨ Yesu mɨra yomnonj da, “Man opima yɨr anginyɨt opimemb ukoijog met? Sɨ makwa ɨta yɨpa motɨr ɨbɨm dem dɨkɨnd onggɨt goujog motɨr kumbɨnd, komkesa onggɨtyam ukoijog motɨr opima tosmurkanj dem.” ");
INSERT INTO gdr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ɨ re Yesu Olib dorɨnd omiti yɨbnonj yɨnamet gatab ke, Petro, Yakobo, Yoan dɨde Andrea ton Yesund wɨgawɨga yerkito da, ");
INSERT INTO gdr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Wumɨr nomnine! Rɨim onggɨtyam mɨle pɨta taukanj dem? Ɨ ra onggɨtyam komkesa gasa taukanj dem, nanggamog im ongwata gasa taukanj dem onggɨtyam komkesa mɨle rɨrɨrkɨp omna gatab?” ");
INSERT INTO gdr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Sɨ Yesu kikitum wɨn gatab yɨt yotomonj da, “Wɨn b'obogɨl yɨr kɨma tekenyɨt! Ke rɨgap wen b'anygɨnena nya ke wɨp ramninem. ");
INSERT INTO gdr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ɨ jogjog rɨga opima tuweny dem Koina nyɨ kɨma, dɨde opima jogjog rɨga ugungatena teyenanj dem odede yɨt kɨma da, ‘Kon ɨtemb Keriso.’ Ɨ ton jogjog rɨga ket opima onggɨt b'anygɨnena nya ke wɨp tamnenanj dem. ");
INSERT INTO gdr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ɨ onggɨt wɨnɨnd ra wɨn tutkundenindam dem tɨrɨba geja yɨt dɨde tɨrɨba geja gatab bage yɨt, wɨn goro moga tainindam dem. Onggɨtyam gasa opima taukanj dem, ajɨ ɨtemb re ma kikitum wɨn e. ");
INSERT INTO gdr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ɨ b'engabenga yɨtam opima gejam owɨnka tuweny dem nɨnda b'enga yɨtam kɨma. Ɨ kwa daka kantri b'engabenga opima gejam owɨnka tuweny dem nɨnda b'enga kantri kɨma. Ɨ opima kwa jijɨg taukanj dem b'engabenga pɨpmetɨnd onggɨt gowukoyɨnd, ɨ dɨde kwa rɨga wa pɨlɨnd opima ukoijog sou wɨn pɨta taukanj dem. Ɨtemb re negɨr wɨn otomapu e, odede wɨp e rɨja e ra konggat naskajog kopa okas mɨna b'ujena wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ɨ kwa wɨn walenggyam yɨr b'etɨpkindam! Mop nokɨp ton opima wen pumbjog Sanedrin kot wa oramka teyenanj dem ɨ ton opima wen ipowa teyenanj meraina yɨr opmitenapu met nata. Ɨ kwa wɨn opima towɨnkindam dem ukoi gabmani rɨga wa wɨpɨnd dɨde king wa wɨpɨnd, nokɨm da ɨdenat wɨn Kor gatab yɨr ungata rɨga taukindam towanɨm. ");
INSERT INTO gdr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ɨ kwa God ma b'ogɨl yɨrkokar bage yɨt b'ogla naska pɨtapɨta omnena iyenyi dem komkesa b'engabenga yɨtam rɨga wa wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ɨ ra rɨgap wen imda teyenanj dem kot wa oramkam, goro wɨn naskanaska nony kubɨr taeninam dem nangga yɨt im wɨn tapurenindam. Ajɨ ra wɨn opurena wɨn okatenya, God opima wa yɨt ogona teyeniny dem opurenam. Sɨ wɨn ɨna yɨt tapurenindam dem. Mop nokɨp yɨt opurena rɨga re ma wɨnpim dem, ajɨ Yɨnayɨna Wɨngawɨngate dem. ");
INSERT INTO gdr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ɨ gar ke utkunda rɨga wɨngɨrɨnd opima towainajog nany o yɨnggan kot wa oramka teyenanj dem uj ondrɨkam ɨ dɨde kwa ti b'uɨt ti b'ɨgand. Ɨ b'ɨgap opima towa b'uwar ake towa mogwar geja teyenanj dem dɨde ket ten uj ondrɨka teyenanj dem. ");
INSERT INTO gdr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ɨ kwa komkesa rɨgap opima wen singi kesa tamnenanj dem Koina nyɨ map. Ajɨ yepiya ra mɨmkam wɨmena tuweny ngɨrpu ama re de onggɨt gowukoi kikitum wɨn wa, ton ɨta okasi dem dadal ngɨrpu kesa yɨrkokar. ");
INSERT INTO gdr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ɨ kwa ɨta yɨpa moga kɨma negɨrjog gasa pɨta tainy dem yama re makwa rɨrɨr e wɨmenam yɨna pɨpmetɨnd. Sɨ ra wɨn ɨtemb negɨrjog gasa yɨr ongya dem onyitand yɨna pɨpmetɨnd, —B'ogla ogenka rɨgat nony rawɨk— sɨ onggɨt wɨnɨnd yepiya ra tekeny Yuda eriyand, wɨn dor wa na mogamoga b'ɨtkenindam dem. ");
INSERT INTO gdr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ɨ yet ra ton ɨbɨm dem wɨmenam met papkak kumbɨnd, ton goro kwa nanggamog gasa imdam met wɨngɨr wa b'egarɨk dem. Ton komkesa gasa nony b'edasin dem. Ajɨ ton wanakana b'ek dem. ");
INSERT INTO gdr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ɨ dɨde yet ra wɨkond ɨbɨm dem sopapund, ton goro kwa rɨtend dem tina oramiti kobɨrgɨm okatam. Ton ɨtemb kobɨrgɨm yerar dem. Ajɨ ton wanakana b'ek dem. ");
INSERT INTO gdr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Sɨ ukoi kear kɨma! Onggɨt wɨnɨnd dem, ngor kɨma kongga wa dɨde papa b'ɨga kɨma kongga wa pɨlɨnd opima bebɨg dem. Nokɨp ton ma rɨrɨr im wanakana b'ɨtkenanj dem. ");
INSERT INTO gdr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Sɨ wɨn yɨr topmitenindam da ɨtemb waina b'ɨkenam wɨn goro ngɨwɨr kɨma gɨbɨljog wɨnɨnd rawɨk dem. ");
INSERT INTO gdr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mop nokɨp ra ɨtemb wɨn ik dem, ɨta ukoijog bebɨg kɨma b'ɨdgotnena pɨta tainy dem. Sɨ naskand makwa yɨpa odede b'ɨdgotnena pɨta awonj onggɨt gowukoyɨnd God ma gowukoi otobarki otomapu ke ngɨrpu yu, ɨ kwa makwa ɨta yɨmta ke tawɨk dem. ");
INSERT INTO gdr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Rako Yonggyam maka onggɨtyam wɨn kut yomnonj, makwa rako yɨpa rɨgat yilo okas dem. Ajɨ Ton kea ɨtemb wɨn kut yomnonj Tina obagendi rɨga map yena re Ton abagenjinonj yɨrkokar okawam. ");
INSERT INTO gdr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ɨ onggɨt wɨnɨnd ra yɨpa rɨgat wen tamniny dem da ‘Yɨr de, ɨte ta Keriso' o ‘Yɨr de, ama ta Keriso,’ wɨn goro odede yɨt gar ke utkunda ke takatenindam dem. ");
INSERT INTO gdr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sɨ opima b'anygɨnena Keriso dɨde b'anygɨnena bageyam pɨta taukanj dem. Ɨ ton kɨd kesa kɨma danda wɨko dɨde moga kɨma danda wɨko opima tamnɨkanj dem rɨga b'anygɨnena nya ke wɨp omnenam. Ajɨ daka ton kwa opima towaina kupka danda ondratena teyenanj dem, nokɨm da ɨdenat ton b'anygɨnena nya ke God ma obagɨki rɨga daka wɨp tamnenanj b'anygɨnena nya wa. ");
INSERT INTO gdr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Sɨ wɨn yɨr kɨma tekenyɨt, yu Kon kea naska kana wen wumɨr amneninyɨn. ");
INSERT INTO gdr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ajɨ onggɨt wɨnɨnd ra ɨtemb ukoijog bebɨg kɨma b'ɨdgotnena seg tainy, lomkongga ɨta sɨbɨb tainy dem, dɨde kwa ɨta mobiror awɨr tainy dem. ");
INSERT INTO gdr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ɨ dɨde ɨki opima ɨsoka tuweny dem wub kumb ke, dɨde kwa danda gasa rɨnsim re pumb wa wekeny opima b'utuwongnenanj dem. ");
INSERT INTO gdr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Onggɨt wɨnɨnd dem rɨgap ɨta Rɨgamna B'ɨga yɨr iyi dem moi borand menonɨnd ukoi danda kɨma dɨde b'ogɨl ɨnyomarena kɨma. ");
INSERT INTO gdr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ɨ ket ɨtemb Rɨgamna B'ɨga ɨta ukoijog bibol ara kɨma Tina aneru tetmɨkeniny dem onggɨt gowukoi wa, ɨ dɨde Tina obagɨki rɨga bobo tamnɨkanj dem gowukoi komkesa gatab ke, gowukoi ngɨrpu ke ngɨrpu wub kumb ngɨrpu wa. ");
INSERT INTO gdr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ɨ Pig wulɨm pɨlke yɨpa tendam yɨt ouyaena yokata. Sɨ yɨt ɨja emb jɨ da ra wul bɨa rɨna re rom kesa rogɨlkak wekeny gɨbɨljog wɨnɨnd, ton ket bodaboda taukanj nyɨ kɨma dɨde sisɨl wɨl tɨkkanj salsal rom kɨma, sɨ wɨn ɨta wɨn ongwasya da, ‘Kemb momta e pembpemb wɨn.’ ");
INSERT INTO gdr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sɨ ra wɨn odede gasa yɨr tangindam dem aukand rɨnsim re Kon amneninyɨn, wɨn nony ke ongwasya dem da Rɨgamna B'ɨga ke nya nate dɨde momta e openda mora wa. ");
INSERT INTO gdr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ɨ Kon ɨmɨnjog wen tamninyɨn da rɨga yepim re yu onggɨt gowukoyɨnd wekeny, ton yɨmta kaim uj taukanj dem, ajɨ naskajog onggɨtyam komkesa gasa towa liyal im taukanj dem. ");
INSERT INTO gdr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Sɨ wub ake gou osiya b'eteomnenya dem, ajɨ Koina yɨtkak makwa ngai opima b'eteomnenanj dem. ");
INSERT INTO gdr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ɨ makwa ɨta yete wumɨr onggɨtyam bibɨr dɨde wɨn gatab. Pumb tungg anerup toda makwa wumɨr im, ɨ kwa toda B'ɨga ma wumɨr e, ajɨ yɨpaina B'uta Tinta wumɨr. ");
INSERT INTO gdr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Sɨ wɨn yɨr kɨma tekenyɨt, goro yɨt tungɨm, mop nokɨp wɨn ma wumɨr im rɨdenate wɨn ik. ");
INSERT INTO gdr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ɨja emb jɨ Koina yɨt rɨngma ra yɨpa rɨgat tina met ɨrar ɨ paja tungg wa yik, ɨ ket tina wɨko rɨga wa danda takainy yɨpayɨpa rɨga wa pɨlwa towaina wulpok wɨko omnɨkam. Ɨ ton kwa mora yɨr ɨpka rɨgand ɨta ingau da, ‘Yɨr opngendi na mɨtɨbnyɨt!’ ");
INSERT INTO gdr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Sɨ onggɨt paemb yɨr opngɨki wekene, mop nokɨp wɨn ma wumɨr im rɨnggɨt wɨn nate met yonggyam tɨtenj, mɨnda rɨka sɨ imokand, mɨnda sɨdɨrɨnd, mɨnda sɨwɨny pauro arand, o mɨnda ɨspara momtand. ");
INSERT INTO gdr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ra Yonggyam rɨdenat ra tɨtenj, goro wen yutungand radarin dem. ");
INSERT INTO gdr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sɨ ɨtemb jɨ Kor yɨt komkesa rɨga wa pɨlwa da, ‘Yɨr opngɨki wekene!’” ");
INSERT INTO gdr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ɨ Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam Bibɨr dɨde Yist kesa Bred Wɨn gatab re yɨpa wɨn nat aukenenonda. Ɨ yɨpa wɨnɨnd re ket nɨmog bibɨr nena na yɨr ungawam komb awonda osiemb nɨmog mɨle aukam, yɨna mopyam sɨ rɨga, dɨde Ju rɨga waina gog ouyaena rɨgap nya arakto rɨdede rabem nya kae Yesund wɨgawɨga yɨmɨnd usunasi dɨde ket uj tama onganji. ");
INSERT INTO gdr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ɨ ton endento da, “Ma onggɨtyam diyamdiyam wɨn nate onganju, nokɨp ke rɨga wa wɨngɨrɨnd soro kɨma bebɨg mɨle rawɨk.” ");
INSERT INTO gdr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ɨ yɨpa wɨnɨnd Yesu yɨbnonj Simonɨmna metɨnd Betaniya tunggɨnd yet re naskand leprosi kopa kɨma yɨbnonj. Ɨ re Yesu owoupu kasand omiti yɨbnonj diyam awowɨnd, yɨpa kongga Ti pɨlwa tikonj yɨpa ukoi mɨra kɨma b'ogɨl ngɨrangngɨrang gaya kɨma ogenaya da “nad” yɨpa otomanti alabasta gɨmo botolɨnd. Ɨ ɨtomb kongga ket onggɨtyam gɨmo botol kuna yɨsambendonj ɨ dɨde Yesum mopɨnd kupkakupka yɨgmarkonj. ");
INSERT INTO gdr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Re nɨnda rɨgap tina mɨle yɨr yongo, ton ket komliu aukɨto dɨde towalenggyam yɨt b'ɨsateno da, “Nangga pae ton jabakɨpɨnd onggɨtyam ngɨrangngɨrang gaya yesomneny? ");
INSERT INTO gdr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mop nokɨp rako men onggɨtyam ngɨrangngɨrang gaya yosogu, keakoa men rɨrɨr na ukoijog wulkɨp yokasu rɨka ama wan tausɨn eit andred (1,800) ɨ nɨnda tumɨnd Kina dɨde ket agonindam nɨnda gasa kesa rɨga wa.” ");
INSERT INTO gdr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ajɨ Yesu ten amninonj da, “Wɨrara! Nangga ma wɨn tin bebɨgɨm ɨl wongkya? Ton kea Kornɨm b'ogɨl mɨle yomnɨk. ");
INSERT INTO gdr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mop nokɨp gasa kesa rɨga opima wɨn kɨma wekeneny ita wɨnɨnd. Sɨ ra wɨn singi taindam b'ogɨl gasa ke ten yɨm okaenam, wɨn rɨrɨr im ita wɨnɨnd omnɨkam. Ajɨ Kon ma ɨta ita wɨnɨnd wɨn kɨma nɨtɨbnenenyɨn. ");
INSERT INTO gdr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nangga na re ton Kor pɨlɨnd yomnɨk, ɨtemb re kupkakupka tina singi dɨde danda kɨma omnɨki mɨle emb jɨ. Ɨ kwa ton Koina jɨwɨnd ngɨrangngɨrang gaya yɨgmarɨk re Koina jɨ tulatula eungitam ongonjena mɨle e. ");
INSERT INTO gdr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Sɨ Kon ɨmɨnjog wen tamninyɨn da rokate ra God ma b'ogɨl yɨrkokar bage yɨt pɨtapɨta omnenenyi dem komkesa gowukoyɨnd, onggɨt konggamna omnɨki mɨle daka kwa ɨta usenenyi dem tinɨm nony iyenam.” ");
INSERT INTO gdr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ɨ Twelp (12) ɨtmɨkitijog rɨga wɨngɨrɨnd Yudas Iskariyot yikonj yɨna mopyam sɨ rɨga wa pɨlwa, nokɨm da ɨdenat ton Yesund tɨb yii towa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Sɨ re ton yɨna mopyam sɨ rɨgap onggɨtyam yɨt utkundo, ton ma sobijog sam na aukɨto dɨde ket towaina tɨrɨr omni yɨt yusekawo da, “Sɨ b'ogɨl e. Sɨn wulkɨp kae tɨb mɨra motɨnau.” Onggɨt kak ke Yudas ket b'ogɨl wɨn oraka yiyonj Yesund okawam towa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ɨ Yist kesa Bred Wɨn wɨngɨrɨnd, re naskajog bibɨr awonj, ton Ju rɨgap mamoi epouto ongongɨm Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam Bibɨrɨm. Yesu ma b'auyaena rɨgap Tin yerkito da, “Rɨtama Man singi aet sɨn menon okasu dɨde amaemb de sɨn motngonjenau Mornɨm owowɨm meraina Uj Ɨgwanti Nony Iyena Diyamdiyam?” ");
INSERT INTO gdr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Seg ket Yesu Tina nɨmog b'auyaena rɨga engaukonj da, “Ra wɨn ekya de Yerusalem taun wa, yɨpa rɨgat wen osiya wɨpwɨp tamɨny dor nyɨkak iyoyɨnd. Sɨ wɨn tin yɨmta undokya dor. ");
INSERT INTO gdr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ra ton b'ɨtgar dor yɨpa met wa, wɨn onggɨt met yonggyamɨnd wumɨr omnya dor da, ‘Ouyaena Rɨgat men momɨny da, “Rote jɨ Koina obai rum rokate ra Kon Koina b'auyaena rɨga kɨma meraina Uj Ɨgwanti Nony Iyena Diyamdiyam omnɨken?” ’ ");
INSERT INTO gdr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ɨ ɨta ton wen tauyau dor pumb ke tula ongonjeni ukoi rum. Sɨ wɨn ɨndamaemb meranɨm diyam ongonjenya dor.” Seg ket Yesu ten etmɨkitonj. ");
INSERT INTO gdr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Sɨ onggɨt nɨmog b'auyaena rɨgap yiwatonda dɨde ket opendonda Yerusalem taun wa. Ɨ gasa ɨja na adarinonda rɨngma na re Yesu ten amnenonj, ngɨrpu demb de ket ton Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam yongonjenonda. ");
INSERT INTO gdr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ɨ re sɨ yimokonj, Yesu onggɨt met wa opendonj Tina Twelp (12) ɨtmɨkitijog rɨga kɨma. ");
INSERT INTO gdr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ɨ ton ket owou ongonjeni kasa wa tuwonj, ɨ ton omnɨkto ɨ dɨde ket diyam auto. Onggɨt diyam awowɨnd, Yesu amninonj da, “Kon ɨmɨnjog wen tamninyɨn da wa wɨngɨrɨnd yɨpat yete re Kon kɨma diyam au, tontemb Ken tɨb nii dor.” ");
INSERT INTO gdr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Sɨ b'auyaena rɨgap gar bebɨg aukɨto dɨde yɨpayɨpa yɨgekeno da, “Ma konten?” ");
INSERT INTO gdr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ɨ ket Yesu mɨra amninonj da, “Ton re wa twelp (12) wɨngɨrɨnd yɨpa rɨga e yete re Kon kɨma gɨlgɨl owou yɨsongg pleto wa. ");
INSERT INTO gdr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Sɨ b'ogɨl e Rɨgamna B'ɨga uj okas dem rɨngma re God ma yɨna peband ɨrɨki yɨbɨm Ti gatab. Ajɨ onggɨt rɨgam yet ra Rɨgamna B'ɨgand tɨb iyeny, ukoi kear kɨma e tinɨm, nokɨp ton ukoijog bebɨg nate tau dem. Ti keako b'ogɨl na jɨ rako ton maka ukendonj ti mogɨm kom ke.” ");
INSERT INTO gdr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Re Yesu dɨde Tina b'auyaena rɨga diyam auto, Yesu yɨpa sana nganja yokatonj ɨ Godɨnd sɨteket yɨt yomnonj, ngɨrpu ket yipkɨkonj dɨde agoninonj Tina b'auyaena rɨga wa pɨlwa. Ɨ Ton yindonj da, “Wɨn yokata! Ɨtemb re Koina jɨ e.” ");
INSERT INTO gdr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Seg ket Yesu kwa yɨpa kapo yokatonj dɨde Godɨnd sɨteket yɨt yomnonj, ngɨrpu ket Tina b'auyaena rɨga wa kapo akawonj towanɨm onayam. Ɨ ket komkesa rɨgap yonayo onggɨt kapo ke. ");
INSERT INTO gdr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Towa onayand Yesu yindonj da, “Ɨtemb kapond nyɨ re Koina outɨnti tɨrɨr omnijog yɨt kɨma kus e rɨnte re Kon yɨgmarken jogjog rɨga wa yɨrkokar okawam. ");
INSERT INTO gdr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kon ɨmɨnjog wen tamninyɨn da Kon makwa ɨta b'usaya onaen dem greip kɨp ke omnɨki wain, ngɨrpu onggɨt bibɨrɨnd ra Kon sisɨl wain onaen dem wɨn kɨma demb de God ma pumb tungg wa.” ");
INSERT INTO gdr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Sɨ diyamdiyam seg ke ton ger yɨtango dɨde ket yiwato de Olib dor wa. ");
INSERT INTO gdr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ɨ Yesu ket Tina b'auyaena rɨga amninonj da, “Wɨn opima komkesa sap totekindam dor dɨde kak nɨtɨaya dor onggɨt mɨle map rɨnte ra tawɨk Kor pɨlɨnd, mop nokɨp yɨt ɨja emb jɨ ɨrɨki yɨbɨm yɨna peband da, ‘Kon ɨta onganjɨn dem mamoi yɨr ɨpka rɨga, sɨ ket opima mamoi wetaweta b'ɨtkenanj dem.’ ");
INSERT INTO gdr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ajɨ onggɨt kak ke ra Kon tutnyisɨn dem uj ke, sɨ wɨn yɨmta kaim wuyɨt dem de Galili wa ajɨ Kon naska e neken dem.” ");
INSERT INTO gdr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Seg Petro ket Yesund yomnonj da, “Nangga ma jɨ ra ton komkesa rɨgap sap totendanj dor dɨde kak mɨtɨayi dor, ajɨ kon kolenggyam ra makwa ɨta sap totenjɨn dor dɨde kak mɨtɨaen dor.” ");
INSERT INTO gdr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ɨ Yesu ket tin mɨra yomnonj da, “Kon ɨmɨnjog men motɨnyɨn da yu sɨwɨny yɨmta kena pauro nɨmogɨm ara tuweny dor, ajɨ man naska Ken ɨta nowapyam notiyenyɨt dor.” ");
INSERT INTO gdr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ajɨ Petro danda kɨma yindonj da, “Ra Man uj taet, koda b'ogla uj rawɨn Man kɨma. Ajɨ kon makwa ɨta motiyenyɨn.” Ɨ komkesa b'auyaena rɨgap toda komkesa ɨja na endento. ");
INSERT INTO gdr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ɨ re Yesu Tina b'auyaena rɨga kɨma menon yokato yɨpa pɨpmet wa nyɨ da Getsemani, Yesu ten amninonj da, “Kon yɨr e topmitenyɨn. Sɨ wɨn omandemb omnɨki wekene, ngɨrpu ra Kon tɨtenjɨn dor wa pɨlwa.” ");
INSERT INTO gdr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ɨ Yesu tena Ton kɨma eyinonj, opi re Petro, Yakobo dɨde Yoan, ɨ ket sobijog b'ɨsonkitonj paja wa. Seg Ton ket ngor wa gar moga dɨde gar bebɨg b'atomonj. ");
INSERT INTO gdr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Seg ket Ton ten amninonj da, “Koina wɨngawɨnga ma sobijog gar kopa e ainy momta uj okatam. Wɨn wekene dɨkɨnd dɨde yɨr opngɨki wekene!” ");
INSERT INTO gdr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ɨ re ɨngkek ket Ton sobijog paja wa b'ɨsonkitonj, gou wa sap otendonj dɨde Godɨm pɨlwa yɨr opmitenonj da, “Rada Man rɨrɨr et, Man onggɨtyam bebɨg wɨn Kor pɨlke yewaikite!” ");
INSERT INTO gdr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ɨ Ton kwa yɨr opmitonj da, “O Abu! Komkesa gasa re rɨrɨr im Mornɨm omnɨkam. Onggɨtyam Koina b'ɨdgotnena kapo yewaikite Kor pɨlke. Ajɨ goro Koina singi ke, ajɨ Moina singi kena.” ");
INSERT INTO gdr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Seg Ton ket ɨtendonj nowa b'auyaena rɨga wa pɨlwa ɨ adarinonj towa yutungand. Seg Ton ket Petrond yomnonj da, “Simon! Man yɨt e weget? Rɨngma, mor awɨr e danda yɨpa odede sobijog wɨnɨnd yɨrkokar wɨmenam? ");
INSERT INTO gdr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yɨr opngɨki wekene, dɨde yɨr opmitenina! Nokɨm da ɨdenat maka wɨn Satanamna otonkena takatenindam. Waina wɨngawɨnga ukoi singi im Kon kɨma yɨr opngɨki wɨmenam, ajɨ waina jɨ re yarɨm im dɨde danda kesa im.” ");
INSERT INTO gdr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Onggɨt kak ke Yesu b'usaya yikonj dɨde yɨr opmitonj Godɨm pɨlwa odede rɨngmena re naskand yerkitonj. ");
INSERT INTO gdr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ɨ re Ton kwa ɨtendonj opimemb b'auyaena rɨga wa pɨlwa, Ton kwa b'usaya adarinonj towa yutungand. Ɨ towaina yɨrkɨp re bebɨg na yutɨtɨp wekenonj. Sɨ onggɨt penaemb ton makwa rɨrɨr na aukɨto Yesund mɨra omnam. ");
INSERT INTO gdr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ɨngkek ket Yesu b'usaya nowam yɨr opmitam yikonj. Ɨ re ɨtendonj towa pɨlwa, Ton ten amninonj da, “Wɨn yutunga dɨde wɨram nasim dadal wekenyɨt. Omandemb seg aina! Wɨn ke ɨte ke ik. Yɨpa rɨga ke Rɨgamna B'ɨga tɨb yii negɨr mɨle rɨga wa yɨm kumb wa. ");
INSERT INTO gdr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Utnɨkinam, men ket wowɨn Kor tɨb iyoyam rɨgam pɨlwa! Yɨr, ɨtemb ke ton ik Kor wus wa.” ");
INSERT INTO gdr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ɨ ket onggɨt wɨnɨnd re Yesu dɨdea yɨt opurenand yɨbnonj, Twelp (12) b'auyaena rɨga wɨngɨrɨnd yɨpa rɨga Yudas ikonj yɨna mopyam sɨ rɨga dɨde Ju rɨga waina gog ouyaena rɨga ɨ dɨde Ju rɨga waina elda rɨga wa pɨlke yɨpand ukoi rɨga bobo kɨma yepiya re geja giri dɨde kibam yɨmɨnd teito. ");
INSERT INTO gdr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ɨ ɨtemb tɨb iyoi rɨga, Yudas kea towa pɨlwa wumɨr yoramitonj da, “Ra yena ra kon ikwasɨn dor omongnena kɨma, ɨtemb jɨ rɨga. Sɨ wɨn Tin b'obogɨl emorkya, ɨ ewatɨnti yɨr ɨpka iya dor.” ");
INSERT INTO gdr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Sɨ re ton Yudas yikonj Yesum pɨlwa, ɨ odenja Yesund yomnonj da, “Ouyaena Rɨga!” dɨde Tin yomongnenonj. ");
INSERT INTO gdr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ɨ odedend ket opimemb rɨga Yesum pɨlwa b'ɨsonkurto ɨ ket Ti pɨlɨnd yɨm aramkɨto ɨ dɨde ket yɨmɨnd yusunato. ");
INSERT INTO gdr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ajɨ onggɨt wɨnɨnd Yesu kɨma owɨnki rɨga wɨngɨrɨnd yɨpa rɨgat tina geja giri yɨtrɨngatonj metkak ke, ɨ ket yɨna mopyam sɨ rɨgamna wɨko rɨga ma yɨpa yɨpya rom yɨpmarkitonj dɨde ket gou wa ɨsendonj. ");
INSERT INTO gdr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ɨ ket Yesu opimemb rɨga amninonj da, “Ma wɨn Kena okatam notupya geja giri dɨde kibam kɨma odede wɨp rɨngma ra wɨn raskol rɨga okasya? ");
INSERT INTO gdr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Bibɨr weanjweanj Kon wen ouyaenand nɨbnenenyɨmɨn yɨnametɨnd, ajɨ wɨn maka Ken yɨmɨnd nusunasma. Ajɨ yu wɨn odede nenegɨr nya ke Ken nokasya, nokɨm da ɨdenat opimemb yɨna peba yɨtkak rɨrɨrkɨp taukanj.” ");
INSERT INTO gdr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Seg ket komkesa b'auyaena rɨgap Yesund yɨraro dɨde b'ɨkento. ");
INSERT INTO gdr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Onggɨt wɨnɨnd yɨpa sisɨl rɨgat Yesund yɨmta yundokonj, ɨ dɨde ton makwa nangga na b'ikiti yowamonj, ajɨ ɨna labalaba ke tina jɨ b'ɨkangɨndi yɨbnonj. Ɨ rɨgap kea tin yokato labalaband. ");
INSERT INTO gdr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ajɨ ton ket tina labalaba otokendonj dɨde ton wɨ kesa na b'ɨkonj. ");
INSERT INTO gdr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ɨ re rɨgap Yesund yiyo yɨna mopyam sɨ rɨgam pɨlwa, komkesa yɨna mopyam sɨ rɨga, Ju rɨga waina elda rɨga dɨde Ju rɨga waina gog ouyaena rɨga yɨpand b'eomkurto. ");
INSERT INTO gdr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ɨ Petro kea Yesund pajapaja yɨmta undoka yiyonj, ngɨrpu ama re yɨna mopyam sɨ rɨga ma met kara mora dunda wa. Ɨ ton ket nɨnda yɨnamet yɨr ɨpka rɨga kɨma yɨpand omitonj dɨde ket wul wusɨnd gɨbɨl b'ɨrnand yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ɨ re kot yɨpangendo, yɨna mopyam sɨ rɨgap dɨde komkesa Ju rɨga waina Sanedrin membap Yesund ongandam nya oraka eyento. Ajɨ makwa adarkɨto negɨr yɨtkak Yesum gatab. ");
INSERT INTO gdr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mop nokɨp jogjog rɨgap b'anygɨnena yɨt ke Ti gatab yɨr ungata yɨt apurento, ajɨ opimemb towaina yɨr ungata yɨt re makwa yɨpa rɨrɨrkɨp aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ɨ kwa daka nɨndap owɨnkɨto mopyam sɨ rɨgam wɨp wa dɨde ket b'anygɨnena yɨt ke Ti gatab yɨr ungata yɨt apurento. ");
INSERT INTO gdr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Sɨ ton odede apurento da, “Sɨn Tina opurena utkundonda odedemb da, ‘Ɨta Kon demb rɨgaina yɨm ke orangi yɨnamet iporken dem, ɨ ket nowa bibɨr wɨngɨrɨnd Kon ɨta yɨpa b'enga yɨnamet orangen dem, sɨ ɨtemb met ra ma rɨgaina yɨm ke omnɨki e dem.’” ");
INSERT INTO gdr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nangga ma jɨ da towaina yɨt jogjog na, ajɨ onggɨtyam towaina yɨr ungata yɨt re makwa toda yɨpa rɨrɨrkɨp aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Seg re ket yɨna mopyam sɨ rɨga onyitonj rɨga wa wɨpɨnd, ton ket Yesund yerkitonj da, “Nangga pae Man maka mɨra nomninyɨt? Ropim Mor pɨlke yɨt onggɨtyam negɨr yɨr ungata yɨt gatab rɨnte re nɨmog rɨgap Mor pɨlwa iya?” ");
INSERT INTO gdr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ajɨ Yesu re mumakesa na yɨbnonj dɨde rawɨr kwa Ton mɨra amninonj. Sɨ b'usaya kwa yɨna mopyam sɨ rɨgat Tin yerkitonj ket da, “Rɨngma, Man Keriso, Godɨmna B'ɨga et yena re rɨgap yewangaenenyi?” ");
INSERT INTO gdr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ɨ ket Yesu mɨra yomnonj da, “Kon ɨtemb rɨga. Wɨn ɨta Rɨgamna B'ɨga yɨr ongya omiti Komkesa Dandam Rɨgɨb Rɨgamna yɨmjog yɨm tab ke juwai kɨma pɨpmetɨnd ɨ kwa menonɨnd moi kumbɨnd wub kumb ke.” ");
INSERT INTO gdr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ɨ re yɨna mopyam sɨ rɨga Yesu ma yɨt utkundonj, ton kea ket soro kɨma tina kobɨrgɨm yɨnyowendonj. Ɨ ket ton rɨga amninonj da, “Nangga mim men ket kwa yɨr ungata yɨt arakindam Ti gatab? ");
INSERT INTO gdr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Wɨn kea Tina Godɨnd ɨsadrena yɨt utkunjya. Rɨdede im wɨn singi aindam Ti gatab?” Seg ket komkesa rɨgap towaina negɨr ma b'ɨsagɨka omni yɨt ke yomneno Yesund ongandam. ");
INSERT INTO gdr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ɨ ket nɨnda rɨgap Yesund kea auya ɨtmanda yiyeno, ɨ Tina wɨp yutwangko dɨde yipowo towaina yɨmkɨk ke odede yɨt kɨma da, “Yepim mipoi? Wumɨr nomnine!” Ɨ yɨnamet yɨr ɨpka rɨgap toda kwa Tin ipowa kɨma yokato. ");
INSERT INTO gdr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Re Petro yɨna mopyam sɨ rɨga ma met kara wɨngɨrɨnd kot aba wa yɨbnonj, yɨpa yɨna mopyam sɨ rɨga ma wɨko ngɨmngai tikonj ti pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Re ket ton Petrond yɨr ɨpka yiyenonj gɨbɨl b'ɨrnand wul wusɨnd, ɨ ket kwa ton tina wɨp b'obogɨl yɨtapnenonj, ɨ yomnonj da, “Man yɨpa onggɨt Najaret tunggam, Yesu kɨma wɨmena rɨga et.” ");
INSERT INTO gdr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ajɨ Petro b'aenonj da, “Kon makwa wumɨr en, ɨ makwa ɨta kon nony auken man nangga yɨt im apureninyɨt.” Ɨ ton ket kot aba ke yikonj mora gatab wa. Ɨ ket pauro ara yikenonj. ");
INSERT INTO gdr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ɨ re ket onggɨt wɨko ngɨmngayɨt b'usaya tin yɨr yongonj, ɨ ton ket b'usaya yɨt apulisinonj rɨga wa pɨlwa yepiya re owɨnki wekenonj ti wusɨnd da, “Ɨtemb re rɨga yɨpa Tina yɨmta undoka rɨga e.” ");
INSERT INTO gdr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ɨ Petro ket b'usaya b'aenonj. Seg sobijog wɨn kak ke rɨga yepiya re owɨnki wekenonj ti wuswusɨnd Petrond yomno da, “Ɨmɨnjog e man yɨpa Tina yɨmta undoka rɨga et, mop nokɨp madaka yɨpa Galili rɨga et.” ");
INSERT INTO gdr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ajɨ Petro odede negɨr yɨt ke yɨt yotomonj da, “Ra kon b'atɨnygɨnenyɨn, kon God ma sake ɨta okasɨn dem,” dɨde Yesum gatab danda kɨma tɨrɨr yɨt ke b'aenonj da, “Kon ma wumɨr en emb jɨ rɨga ya gatab im re wɨn apurenindam.” ");
INSERT INTO gdr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Seg ket odenja pauro nɨmogɨm ara yikenonj, sɨ Petro ket kea nony aukonj yɨtkak rɨna re Yesu apureninyɨm ti gatab da, “Yu sɨwɨny yɨmta kena pauro nɨmogɨm ara tuweny dor, ajɨ man naska Ken ɨta nowapyam notiyenyɨt dor.” Ɨ ton ket ukoi gar bebɨg awonj dɨde yii nena ket yindonj. ");
INSERT INTO gdr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ɨ ɨsparki ke sɨtawarjogɨnd, odenja yɨna mopyam sɨ rɨgap, Ju rɨga waina elda rɨga ɨ Ju rɨga waina gog ouyaena rɨga ɨ dɨde komkesa Ju rɨga waina Sanedrin memba kɨma yɨpand yɨt ɨglenena seg aukɨto dɨde ket yɨt yɨmjato. Seg re ket ton ket Yesund yɨjobɨko ɨ yiyo ɨ dɨde ket Pilatom yɨm kumb wa yoramito. ");
INSERT INTO gdr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ɨ Pilato Yesund yerkitonj da, “Ma Man Ju rɨga waina king et?” Ɨ Yesu mɨra yomnonj da, “Owɨ, kemb man mindenyɨt.” ");
INSERT INTO gdr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ɨ kwa yɨna mopyam sɨ rɨgap Pilatond jogjog negɨr yɨt ke yɨt yugwateno Yesum gatab. ");
INSERT INTO gdr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Sɨ Pilato b'usaya Yesund yerkitonj da, “Nangga pae Man maka mɨra nomninyɨt? Man yɨr de, komkesa towaina negɨr yɨt rɨnsim re ton kor pɨlwa eyenanj Mor gatab b'ɨsagɨkam?” ");
INSERT INTO gdr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ajɨ Yesu makwa ngai mɨra yomnonj, ɨ Pilato kɨd kesa dɨde nonysɨpsɨp na awonj. ");
INSERT INTO gdr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ita Ju rɨga Uj Ɨgwanti Nony Iyena Diyamdiyam wɨnɨnd Pilato yɨpayɨpa sɨbɨbmet rɨga apekeninonj Ju rɨga wa pɨlwa towaina b'arkita rɨrɨrɨnd. Ɨtemb re Pilatom get ke mɨle naemb jɨ yɨbnawonj. ");
INSERT INTO gdr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ɨ onggɨt wɨnɨnd, nɨnda sɨbɨbmet rɨga kea wekenonj yepiya re soro kɨma bebɨg mɨle yomnɨko ukoi nyɨ rɨga kɨma dɨde ton kea nɨnda rɨga angandto onggɨt gejand. Ɨ towa wɨngɨrɨnd yɨpa Ju rɨga nyɨ da Baraba, toda kea sɨbɨbmet wa yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ɨ rɨga bobo tuwonj Pilatom pɨlwa dɨde yerkito yɨpa sɨbɨbmet rɨga pɨta wa omnam onggɨtyam tina get ke mɨle ke. ");
INSERT INTO gdr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Sɨ Pilato mɨra amninonj da, “Wɨn singi im kon Ju rɨga wa King pɨta wa openjɨn?” ");
INSERT INTO gdr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nangga pena Pilato odede b'arkita yoramitonj nokɨp ton nony ke wumɨr na da Ju rɨga waina membap Yesund iyi re nonyɨk b'ɨponena mapae ajɨ Ju rɨga wa pɨlɨnd re kea singi ebnawonj Tin opendam. ");
INSERT INTO gdr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ajɨ yɨna mopyam sɨ rɨgapiya rɨga bobo engaento da Pilato Baraband openj ajɨ goro Yesund. ");
INSERT INTO gdr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ɨ Pilato todaka ten mɨra amninonj da, “Sɨ wɨn kea naemb Banaband singi yomnya, sɨ daka nangga e kon omnɨken onggɨt Rɨgam pɨlɨnd yena re wɨn yogenaya da Ju rɨga waina King?” ");
INSERT INTO gdr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Seg ket ton rɨga b'usaya b'okta ara wuwenonj da, “Wul b'agbagɨnd yɨdrɨke!” ");
INSERT INTO gdr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ɨ Pilato towa yɨt etendainonj da, “Nangga pae? Nangga ukoi negɨr mɨle na yomnɨkɨm?” Ajɨ ton pumb wa b'okta kana ara yoikɨndeno da, “Wul b'agbagɨnd yɨdrɨke!” ");
INSERT INTO gdr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Sɨ Pilato singi awonj Ju rɨga bobo nony rɨrɨr omnɨkam, ɨ ton ket Baraband towa apendawonj, ajɨ ton tina geja rɨga engainonj Yesund ti wɨpɨnd ɨraskam. Ɨ re ɨraska seg yomno, ton ket Tin towa yɨm kumb wa yoramitonj wul b'agbagɨnd ɨdrɨkam. ");
INSERT INTO gdr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ɨ onggɨt geja rɨgap Yesund yiyo de Pilatom met wa, de onggɨt Ju rɨga waina gou yɨr ɨpka Roma gabmani mopyam rɨgamna wɨkopu met kara wɨngɨr wa, dɨde komkesa geja rɨga ara emokto yɨpand b'eomkitam. ");
INSERT INTO gdr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ɨ ton ket Yesund king pɨla kuskus kobɨrgɨm yikito, ɨ dɨngdɨng kai dɨra pɨla yogauko dɨde ket Ti mopɨnd ɨtemb dɨra yikito kingɨmna dɨra pɨla Tin jɨ malɨk omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Seg ton ket jɨ malɨk omnɨkam simesime yomno da, “Simesime! Ju rɨga wa king!” ");
INSERT INTO gdr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ɨ dɨde ton Yesund mopɨnd ipowa yiyeno buskak ke, ɨ Tin auya ɨtmanda yiyeno, ɨ dɨde kwa Ti wɨpɨnd kumsos b'amka wuwenonj jɨ malɨk omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ɨ re ton Yesund jɨ malɨk omnɨka seg yomno, ton kea ɨtemb kuskus kobɨrgɨm yotokendawo dɨde ket Tinajog kobɨrgɨm yikoko, ngɨrpu Tin ket wɨp yiyo wul b'agbagɨnd ɨdrɨkam. ");
INSERT INTO gdr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Re Yesund yiyo, towa nyawɨnd yɨpa Kurene tunggam rɨga nyɨ da Simon, Aleksandro ake Rupo towa b'u, tin wɨpwɨp yomno sopapu tungg ke opantand. Ɨ ket geja rɨgap Simonɨnd danda kɨma yingawo Yesu ma wul b'agbag iyoyɨm, nokɨp Yesu ma rɨrɨr na ket awonj Tina wul b'agbag iyoyɨm de sukak wa. ");
INSERT INTO gdr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ɨ ket Yesund wɨp yiyo yɨpa sukak wa tungg nyɨ da Golgota, engendena yɨtkak da “Uj Rɨgamna Mopkak Wɨmenapu Tungg”. ");
INSERT INTO gdr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Re ket ton onggɨt sukak wa opekto, geja rɨgap yokawo wain rɨna re mir kɨma yɨsleko. Mir re dɨmɨr okawa wulpoj e. Ajɨ Yesu b'ɨsayonj onggɨtyam wain onayam. ");
INSERT INTO gdr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Re sɨtawarɨnd nain (9) kɨlok awonj, ton ket Tina kobɨrgɨm atogɨkto ɨ ket wul b'agbagɨnd Tin nil ke yɨdrɨko. Seg ket, ton Yesu ma kobɨrgɨm ɨtaika eyento pes b'arena wɨba ke. ");
INSERT INTO gdr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ɨ Yesu ma onganda mop nyɨ yɨrɨko Tina wul b'agbag pumb ke da, ");
INSERT INTO gdr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ɨ kwa nɨmog negɨr raskol rɨga Yesu kɨma wul b'agbagɨnd edrɨko, yɨpa Tina yɨmjog yɨm tab ke ɨ yɨpa Tina sawai yɨm tab ke. ");
INSERT INTO gdr_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Awɨr e) ");
INSERT INTO gdr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ɨ opandena rɨgap Yesund ugaga yiyeno mop b'uwongnena kɨma da, “Ɨ ɨte namb jɨ Man rɨga. Man re mindot da, ‘Ɨta yɨnamet iporken dem ɨ nowa bibɨr kɨma orangen dem.’ ");
INSERT INTO gdr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Sɨ molenggyam Man yɨrkokar b'akae! Dɨde kwa Molenggyam gou wa ae wul b'agbag kumb ke.” ");
INSERT INTO gdr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ɨ kwa odede yɨpa wɨp nya ke yɨna mopyam sɨ rɨgap daka Ju rɨga waina gog ouyaena rɨga kɨma yɨpand Yesund jɨ malɨk omnɨka yiyeno towa wɨngɨrɨnd da, “Ton nɨnda rɨga yɨrkokar akainonj, ajɨ Ton ma rɨrɨr e Tilenggyam yɨrkokar b'atkau.” ");
INSERT INTO gdr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ɨ Yesund yomno da, “Keriso! Ju rɨga wa king! Man otade gou wa ae wul b'agbag kumb ke, nokɨm da ɨdenat sɨn yɨr motngu dɨde ket gar ke utkunda ke motkasu.” Ɨ dɨde osiemb nɨmog raskol yepiya re Yesu kɨma wul b'agbagɨnd ɨdrɨki ebnonda, toda kwa Yesund kea ugaga yiyenonda. ");
INSERT INTO gdr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Re lomtɨk awonj, sɨbɨbɨt kupka gowukoi yɨkangɨndonj, ngɨrpu ama re ket tri (3) kɨlok awonj sɨmana gatabɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Re sɨmana gatab tri (3) kɨlok awonj, Yesu b'okta kana ara yikenonj da, “Eloi eloi lema sabaktani?” —engendena yɨtkak da, ‘Kor B'u, Kor B'u, nangga pae Man kak nɨaet?’ ");
INSERT INTO gdr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sɨ rɨga yepiya re Yesum wusɨnd owɨnki wekenonj, ton kea Yesumna yɨt utkundo, ɨ ton ket endento da, “Yɨr de! Onggɨt Rɨgat Eliya na ara yemok.” ");
INSERT INTO gdr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ɨ yɨpa rɨga b'ɨtkonj ɨ ket nyɨ ɨngmatena ɨngmatena matres pɨla gasa ke onggɨt tokɨltokɨl ɨk besen wa yɨsonggonj, ɨ dɨde soksok buskak ke yɨponj, ɨ yurowatonj Yesumna tugɨm wa onayam. Ɨ ket onggɨt rɨgat amninonj da, “Tin yɨrara! Ma be men yɨr yangu Eliyand ɨta rɨka ik dor Tin gou wa omnam.” ");
INSERT INTO gdr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Seg Yesu ukoi kana ara yikenonj, ɨ ket uj awonj. ");
INSERT INTO gdr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ɨ re Ton uj awonj, ukoi gutomgutom kobɨrgɨm rɨna re yɨnametɨnd ewɨrɨnti yɨbnenenonj yɨnayɨna pɨpmet dɨde yɨna pɨpmet ganggand, ɨnyɨnyɨnd b'ɨnyowendonj pumb ke ama re de gou wa. ");
INSERT INTO gdr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ɨ re Yesu uj awonj, yɨpa Roma andred (100) geja rɨga mopyam Ti wɨp ke onyiti yɨbnonj yet re wɨko wɨp yomnonj opimemb nowa rɨga wul b'agbagɨnd ɨdrɨkam. Sɨ re ton yɨr yongonj rɨdede wɨp na Yesu uj awonj, ton ket yindonj da, “Ɨtemb re rɨga ɨmɨnjog Godɨmna B'ɨga e.” ");
INSERT INTO gdr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Ɨ dɨde demb de kea nɨnda kongga daka pajapaja wekenonj Yesund yɨr ɨpkand. Sɨ onggɨt kongga wa wɨngɨrɨnd kea nowa kongga yepiya re Tin yɨmta undoka yiyeno dɨde Tin yɨm okawa yiyeno re Ton Galili eriya wa yɨbnenenonj, toda omanda wekenonj, opi re Magdala tunggam Mariya, sobijogyam Yakobo ake Yose towa mog Mariya, dɨde Salome. Ɨ kwa jogjog kongga yepiya re Ton kɨma yɨpand tuwonj de Yerusalem taun wa, toda kwa omanda wekenonj. ");
INSERT INTO gdr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ɨ Yesu uj awonj re Ju rɨga waina wɨram dɨde yɨr opmitena bibɨrɨm B'angonjena Bibɨr nat. Ɨ re ket momta sɨ yimokonj, sɨ Yesumna ujgɨm eungitam gangga re kea kutjog na auka yikonj. ");
INSERT INTO gdr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Sɨ onggɨt penaemb Arimataya tunggam Yosep onyitonj Yesu ma ujgɨm eungitam. Ton re Ju rɨga waina Sanedrin memba wɨngɨrɨnd yɨpa ongwati rɨga na yɨbnonj dɨde kwa daka ton tilenggyam re God ma pumb tungg na yɨr yungaenenonj. Sɨ ton ket moga kesa awonj dɨde ket kea yikonj Pilatom pɨlwa, ngɨrpu ton ket tin yerkitonj Yesumna ujgɨm okatam. ");
INSERT INTO gdr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ajɨ re Pilato yɨt utkundonj da Yesu kea uj awonj, ton kɨd kesa na awonj. Sɨ ton ket onggɨt andred (100) geja rɨga mopyamɨnd ara yemokonj yet re wɨp yomnonj wul b'agbagɨnd ɨdrɨkam, dɨde ket tin yerkitonj da, “Ma, mɨnda kea Yesu kɨm uj ainy?” ");
INSERT INTO gdr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Re ket Pilato wumɨr yokatonj onggɨt andred (100) geja rɨga mopyamɨm pɨlke da “Kea uj ainy,” ton ket geja rɨga engainonj da, “Yesu ma ujgɨm yokawa.” ");
INSERT INTO gdr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Seg ket Yosep nɨnda rɨga kɨma bɨlbɨl kobɨrgɨm emdɨto, ɨ ket ujgɨm wul b'agbag kumb ke gou wa yɨjgendo dɨde ujgɨm kobɨrgɨm ke ponpon yomnɨko. Re ket seg, yiyo yɨpa gopmet wa rɨna re rɨgap gɨmo yɨund yesko, ɨ ket yoramito onggɨt gopmet wɨngɨr wa, ɨ dɨde ket ukoi gɨmo ururkena yiyo gopmet mora utwangkam. ");
INSERT INTO gdr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdala tunggam Mariya dɨde Yosem mog Mariya kea yɨr yongonda rɨkɨnd re Yesu ma ujgɨm yoramito. ");
INSERT INTO gdr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ɨ re Ju rɨga waina wɨram dɨde yɨr opmitena bibɨr seg awonj, Magdala tunggam Mariya, Yakobomna mog Mariya, dɨde Salome, opimemb nowa konggap ujgɨmɨnd ɨsnɨkam ngɨrangngɨrang gaya emdɨto, nokɨm da ɨdenat ton menon okasi de Yesu ma gopmet wa dɨde ket onggɨt gaya ke ɨsnɨki Tina ujgɨm. ");
INSERT INTO gdr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ɨ onggɨt Ju rɨga waina wɨram dɨde yɨr opmitena bibɨr kak ke naskajog bibɨr awonj re Sande na, ɨ onggɨt Sandend ton wuwonj Yesu ma gopmet wa sɨtawarjog lom ɨlitand. ");
INSERT INTO gdr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nyawɨnd ton towalenggyam b'arkento da, “Yepim meranɨm gopmet utwangki gɨmo ururkisi gopmet mora ke?” ");
INSERT INTO gdr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ajɨ re ton onggɨt gɨmo yɨund oski gopmet wa b'obogɨl pumb wa yɨr aukɨto, kea ton ket yɨr yongo ɨtemb ukoijog gɨmo rɨna re ururkiti yɨbnonj mora ke. ");
INSERT INTO gdr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ɨ re ket gopmet wa opekto dɨde gopmet wɨngɨr wa b'ɨgarkɨto, ton ket yɨr yongo yɨpa sisɨl rɨga yet re yɨmjog yɨm tab ke omiti yɨbnonj pɨnpɨn bɨlbɨl kobɨrgɨm b'ikiti. Sɨ ton ukoi moga kɨma kɨd kesa aukɨto. ");
INSERT INTO gdr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ɨ ton ket ten amninonj da, “Goro moga kɨma kɨd kesa tainam! Wɨn Najaret tunggam Yesu na orakam otupya yena re wul b'agbagɨnd yɨdrɨko. Ajɨ Ton ke utnyis, ɨ Ton awɨr e dɨkɨnd. Sɨ wɨn yɨr yonga Tina pɨpmet rɨkɨnd re Tin yoramito. ");
INSERT INTO gdr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ajɨ wɨn wuwe, ɨ Tina b'auyaena rɨga dɨde Petro wumɨr tamnindam dor da, ‘Ton naska e yik dem de Galili wa, ajɨ wɨn yɨmta kaim wuyɨt dem dɨde ket amaemb de wɨn Tin yɨr ongya dem odede rɨngmana re Ton wen wumɨr amninonj naskand.’” ");
INSERT INTO gdr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Onggɨt kak ke ket ton opekto gɨmo yɨund oski gopmet bora ke dɨde b'ɨkto, mop nokɨp ton kaktɨtɨ dɨde moga kɨma nonysɨpsɨp na aukɨto. Ɨ ton makwa nangga yɨt na apurento dɨde makwa yena wumɨr yomno nokɨp ton ukoijog moga nat wekenonj. ");
INSERT INTO gdr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Re Yesu sɨtawarjog utnyitonj Ju rɨga waina wɨram dɨde yɨr opmitena bibɨr kak ke naskajog bibɨr Sandend, ton naskajog pɨtapɨta awonj Magdala tunggam Mariyam pɨlwa ya pɨlkena re ton seben (7) negɨr wɨngawɨnga eaukeninonj. ");
INSERT INTO gdr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Seg ket onggɨt konggat wikonj de Yesu ma b'auyaena rɨga wa pɨlwa yepiya re naskand Yesu kɨma yɨpand wekenonj. Ɨ re ton Yesu ma uj map gar bebɨg kɨma yii b'ɨrɨnena wuwenonj, ɨtomb konggat ket ten wumɨr amninonj Yesu ma utnyita gatab. ");
INSERT INTO gdr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Sɨ re ton tin wutkundo da Yesu ke yilo ainy dɨde ton kea Tin liyalliyalkɨp yɨr yong, ton maike ɨtomb konggamna yɨt ɨmɨnjogɨm yomno. ");
INSERT INTO gdr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Onggɨt kak ke ket re Tina b'auyaena rɨga wa wɨngɨrɨnd nɨmog rɨga Yerusalem taun ke yiwatonda de yɨpa sobijog tungg wa, Yesu b'enga wɨpkak ke towa wɨpɨnd pɨtapɨta awonj towa menonɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Seg, onggɨt nɨmog b'auyaena rɨgap ket ɨtendonda nɨnda b'auyaena rɨga wa pɨlwa dɨde ten wumɨr amninonda da, “Sɨn kea Tin yɨr yongma.” Ajɨ ton makwa towaina yɨt ɨmɨnjogɨm amnɨkto. ");
INSERT INTO gdr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Onggɨt kak ke, re tina ileben (11) b'auyaena rɨgap diyam aukɨto, Yesu towa wɨpɨnd pɨtapɨta awonj ɨ ket samany eyowinonj towaina gar ke utkunda kesa mɨle dɨde gɨmo pɨla rogɨlkak gar gatab, mop nokɨp ton maka ɨmɨnjogɨm amnento rɨga yepiya re Yesund wɨp yɨr yongo Tina utnyiti kak ke. ");
INSERT INTO gdr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ɨ Ton ket ten amninonj da, “Komkesa gowukoi wa wuwene, dɨde komkesa rɨga wa pɨlwa God ma b'ogɨl yɨrkokar bage yɨt pɨtapɨta omnena iyenya. ");
INSERT INTO gdr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yepiya ra onggɨtyam yɨt gar ke utkunda ke okasi dɨde baptiso okasi, ton opima yɨrkokar okasi dem. Ajɨ yepiya ra maka onggɨtyam yɨt gar ke utkunda ke okasi, ton opima negɨr ma b'ɨsagɨka okasi dem b'ɨsagɨka wɨnɨnd. ");
INSERT INTO gdr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ɨ gar ke utkunda rɨga opima odede kɨd kesa kɨma danda wɨko tamnɨkanj dem, ton kwa opima negɨr wɨngawɨnga teaukenanj dem Koina nyɨ kɨma, ɨ b'engabenga sisɨl yɨt opima tapurenanj dem. ");
INSERT INTO gdr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ɨ ton opima negɨr guda kɨma gɨrem towa yɨm ke imda teyenanj dem, ajɨ ton makwa ɨta negɨr okatenyi dem. Ɨ ra ton uj kɨma negɨr guda nyɨ tanaikanj dem, ajɨ ton makwa ɨta negɨr okatenyi dem. Dɨde ra ton yɨm taramitenanj dem kopa rɨga wa pɨlɨnd, sɨ kopa rɨga opima b'ɨsagɨka tuweny dem.” ");
INSERT INTO gdr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Re ket Yonggyam Yesu towa pɨlwa yɨt opurena seg awonj, God Tin yurowatonj pumb tungg wa. Ɨ Yesu ket juwai kɨma pɨpmetɨnd omitonj Godɨmna yɨmjog yɨm tab ke de pumb tungg wa. ");
INSERT INTO gdr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Onggɨt kak ke ket Tina b'auyaena rɨga wuwenonj komkesa gatab wa, dɨde pɨtapɨta yomneno God ma b'ogɨl yɨrkokar bage yɨt. Ɨ re ton God ma b'ogɨl yɨrkokar bage yɨt pɨtapɨta yomneno, Yonggyam daka ton kɨma yɨpand gɨlgɨl wɨko amnɨkinonj. Ɨ Ton ket ten danda agoninonj kɨd kesa kɨma danda wɨko omnɨkam nokɨm da ɨdenat rɨgap ɨmjatenyi da towaina opureni Tina b'ogɨl yɨrkokar bage yɨt re ɨmɨnjog e. ");
INSERT INTO gdr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Kor rɨga, rɨgap kea otomapu ke towa yɨr ke yɨr angto mɨle rɨna re rɨrɨrkɨp aukɨto mera wɨngɨrɨnd dɨde onggɨt mɨle gatab yɨtkak kea pɨtapɨta amnento. Sɨ ma yɨpa kɨma rɨgapiya towa pɨlke onggɨtyam yɨtkak akatento dɨde b'atonkena wuwenonj yɨtkak dɨmdɨm olngɨkam dɨde ɨrɨkam odede wɨp ɨt re ton akatento towa pɨlke. ");
INSERT INTO gdr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ukoi rɨga Teopilo, koda kwa kea onggɨtyam kupka yɨtkak b'auyaena nekenond otomapu ke. Sɨ kon nony aen da ɨtemb re kornɨm b'ogɨljog e yɨtkak dɨmdɨm olngɨkam dɨde rɨrɨrkɨpjog e ɨrɨkam mornɨm. ");
INSERT INTO gdr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nokɨm da ɨdenat man b'ogɨl wumɨr kɨma temjateninyɨt onggɨtyam ɨmɨnjog yɨtkak gatab rɨna re man b'auyaenot. ");
INSERT INTO gdr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Onggɨt wɨnɨnd re Erod Yuda kantri king yebɨm, yɨpa yɨna sɨ rɨga yɨbnonj nyɨ da Jakariya, yet re Abiyamna sɨ rɨga bobo wɨngɨrɨnd yɨbnonj. Ɨ ti kongga re Aronɨmna kus ke b'usmureni b'ɨgam pɨlke b'ɨga o, ɨ ti nyɨ wɨbnau re Elisabetɨt. ");
INSERT INTO gdr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sɨ osiemb molkongga re negɨr kesa dɨmdɨmjog rɨga na ebnonda Godɨm wɨpɨnd, dɨde ton komkesa Yonggyamɨmna b'ingawa yɨt dɨde yɨmak yɨt b'obogɨl yɨmta undoka eyeneninonda, sɨ ton b'injawa kesa na ebnenenonda. ");
INSERT INTO gdr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ajɨ towa makwa b'ɨga ebnainy, nokɨp Elisabet re popam na webɨm. Ɨ ton osiemb re kea mid ake molegɨt akatonj. ");
INSERT INTO gdr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ɨ yɨpa wɨnɨnd re Jakariyamna sɨ rɨga bobo waina wɨn akatawonj sɨ omnɨkam, sɨ ton sɨ amnɨkinonj Yonggyamɨmna yɨnametɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ɨ onggɨt wɨnɨnd ton towa wɨngɨrɨnd Jakariyand yobagendo re towaina rɨga obagenda get ke mɨle kena so omnam ngɨrangngɨrang sɨ gasa yɨnametɨnd, sɨ Jakariya ket b'ɨgaronj yɨna pɨpmet wa ngɨrangngɨrang sɨ gasa so omnam. ");
INSERT INTO gdr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ɨ re ɨtemb ngɨrangngɨrang sɨ gasa embomb yiyenonj, komkesa rɨga bobo re yɨr opmita na yomnɨko bau ke. ");
INSERT INTO gdr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ngɨrpu yɨpa Yonggyamɨmna aneru pɨta awonj ti wɨpɨnd dɨde onyitonj ngɨrangngɨrang sɨ gasa embombpu kap yɨmjog yɨm tab ke. ");
INSERT INTO gdr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ɨ re Jakariya tin yɨr yongonj, ton ket wɨnga kesa na awonj dɨde mogat tin danda kesa yomnonj. ");
INSERT INTO gdr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Sɨ onggɨt anerut tin yomnonj da, “Jakariya! Goro moga tawɨm! God kea moina yɨr opmita utkunj, sɨ mor kongga Elisabet ɨta mor yɨpa leo b'ɨga mutkendau dem. Man tin nyɨ oeket dem Yoan. ");
INSERT INTO gdr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ɨ mor pɨlɨnd ɨta dem sam, ɨ man ukoijog sam e taet dem. Ɨ jogjog rɨgap kwa toda opima sam taukanj dem tina ukenda gatab map. ");
INSERT INTO gdr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mop nokɨp ton ukoijog rɨga e tainy dem Yonggyamɨm wɨpɨnd. Ɨ ton makwa ɨta wain dɨde danda ɨk onaya teyeniny dem. Ɨ God tin get kae Yɨnayɨna Wɨngawɨnga ke yɨndangɨr omɨny dem ti mogɨmna komɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Sɨ ton jogjog Israel rɨga tengenjiny dem towa God Yonggyamɨm pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ɨ ton kwa Yonggyamɨmna naska nya wa e yik dem Godɨmna Wɨngawɨnga kɨma dɨde danda kɨma odede yɨpa wɨp ɨt re Eliya re dɨde. Sɨ ton b'uwar waina gar tengenjiny dem towaina b'ɨgawar wa pɨlwa b'ogɨl b'ubɨgawarɨnd wɨmenam, dɨde kwa tengenjiny dem utkunda kesa rɨga de negɨr kesa dɨmdɨmjog rɨgaina b'ogɨl nony menamena wa. Ɨ dɨde ton tangonjeniny dem God ma obagɨki Israel rɨga, nokɨm da ɨdenat ton Yonggyamɨnd gar ke okatenyi dem.” ");
INSERT INTO gdr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sɨ ket Jakariya anerund yomnonj da, “Rɨdede e kon moina yɨt ɨmɨnjogɨm omnyɨn? Mop nokɨp kon re mid en, dɨde kor kongga toda kwa tina b'ɨga ukuka wɨn re kea yɨukitonj.” ");
INSERT INTO gdr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ɨ anerut ket tin yɨsmonggawonj da, “Kon Gabriyel ten yete re kon Godɨm wɨpɨnd onyiti nɨbnenenyɨn. Sɨ Godɨt ken nɨtmɨkis mor pɨlwa men wumɨr omnam dɨde onggɨtyam b'ogɨl bage yɨt mornɨm pɨtapɨta omnam. ");
INSERT INTO gdr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Sɨ yɨr de, man ɨta yɨt kesa taet. Ɨ man ma rɨrɨr e yɨt tapureninyɨt, ngɨrpu ra onggɨtyam gasa ɨmɨnjog tainy dem, mop nokɨp man maka koina yɨt ɨmɨnjogɨm amneninyɨt. Ajɨ ra onggɨtyam wɨn okas dem, koina yɨt opima rɨrɨrkɨp taukanj dem.” ");
INSERT INTO gdr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ɨ onggɨt wɨnɨnd rɨgap Jakariyand kasar yomnɨko, dɨde ton kɨd kesa auto, mop nokɨp ton pɨnjog na yɨbnonj yɨnamet wɨngɨr wa. ");
INSERT INTO gdr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ajɨ re ton bau wa opendonj, ton ma rɨrɨr na yɨt opurenam awonj towa pɨlwa. Sɨ rɨgap ket wumɨr yokato da ton kea liyalliyal gasa yɨr yong yɨnamet wɨngɨrɨnd. Ɨ ton ɨtaikena kena ten yɨt amninonj, dɨde ton ma rɨrɨr na yɨt opurenam. ");
INSERT INTO gdr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ɨ re tina sɨ omnɨka wɨn yundwatonj, ton ket tina met wa yikonj. ");
INSERT INTO gdr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ɨ onggɨt wɨn kak ke ti kongga Elisabet kom kɨma awonj, sɨ ton paib (5) mobi kɨma tinta wɨbnenenonj dea ta tina met wa dɨde ton ket odede windenonj ");
INSERT INTO gdr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","da, “Oo, nomae kor Yonggyam! Yu ke odede b'ogɨl wɨko nomnɨkau. Sɨ yu ɨtemb, kor Yonggyam yɨm nokau koina ɨngar awɨr omnam rɨga wa wɨngɨrɨnd.” ");
INSERT INTO gdr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ɨ re Elisabet siks (6) mobi kɨma kom yowamonj, God yɨpa aneru nyɨ da Gabriyel yɨtmɨkitonj yɨpa taun wa ogenaya da Najaret Galili eriya wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Sɨ onggɨt anerut yikonj de yɨpa pɨl esopai kesa ngɨmngayɨm pɨlwa, yet re tɨrɨr yomnonj Dawidɨmna kus ke rɨga Yosep kɨma molkongga awowɨm. Ɨ ɨtomb pɨl esopai kesa ngɨmngayɨmna nyɨ re Mariyat. ");
INSERT INTO gdr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ɨ ket anerut tin wodaronj tina met wa, ɨ womnonj da, “Sime! Man Godɨmna wurar okai kongga et. Sɨ Yonggyam ɨta man kɨma.” ");
INSERT INTO gdr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ajɨ Mariya onggɨtyam yɨtkak map nony bebɨg kɨma nonysɨpsɨp na awonj, dɨde ton nony ke windenonj da, “Rɨdede wɨp e jɨ onggɨtyam sime yɨtkak?” ");
INSERT INTO gdr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ɨ anerut ket tin womnonj da, “Mariya! Goro moga tawɨm! Mop nokɨp God kea Tina wurar mor mokau. ");
INSERT INTO gdr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Sɨ man yɨr de, man ɨta kom kɨma taet dem, ɨ ket leo b'ɨga e ukenjɨt dem. Ɨ man Tin nyɨ oeket dem Yesu. ");
INSERT INTO gdr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ɨ Ton ɨta ukoijog rɨga tainy dem, ɨ rɨgap Tin nyɨ ogenai dem pumbjog Godɨmna b'ɨga, ɨ dɨde Yonggyam God ɨta Ti okau dem Ti b'u Dawidɨmna king pɨpmet. ");
INSERT INTO gdr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ɨ Ton wɨp tamniny dem Yakobɨmna b'usmureni b'ɨga ngɨrpu kesa, dɨde ɨtemb Tina pumb tungg makwa ɨta b'etpau dem.” ");
INSERT INTO gdr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ajɨ kwa Mariya ket anerund yɨsmonggawonj da, “Rɨdede e onggɨtyam yɨt ɨmɨnjogɨm tau dem, nokɨp kon get ke ma rɨga kɨma pɨl b'asopai e nɨbnyɨn?” ");
INSERT INTO gdr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ɨ anerut ket tin wɨsmonggawonj da, “Ɨta Yɨnayɨna Wɨngawɨnga tinɨk dem mor kumbɨnd, dɨde pumbjog God ma dandat ɨta kukum motɨny dem. Sɨ onggɨt paemb onggɨt yɨnayɨna ukendi B'ɨgand ogenai dem da Godɨmna B'ɨga. ");
INSERT INTO gdr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Sɨ man yɨr de, mor kus ke kongga Elisabet, ton re molegjog o, ajɨ ton ti ɨta leo b'ɨga kom borand. Ɨ rɨgap wogenaeneno da ton re popam o, ajɨ ton ke siks (6) mobi kɨma e kom yowam. ");
INSERT INTO gdr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Mop nokɨp Godɨm Ti ɨta danda komkesa gasa rɨrɨrkɨp omnɨkam.” ");
INSERT INTO gdr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Sɨ Mariya ket windonj da, “Sɨ b'ogɨl e, kon re Yonggyamɨmna wɨko ngɨmngai en. Toko moina opureni yɨtkak rɨrɨrkɨp raukinem kor pɨlɨnd.” Seg ket anerut tin wɨraronj. ");
INSERT INTO gdr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sɨ ket onggɨt wɨnɨnd Mariya b'angonjenonj dɨde ket mukupmukup menon yokatonj de dor tungg wa, ɨ dɨde ket opendonj de yɨpa taun wa Yuda eriya wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ngɨrpu ton b'ɨgaronj Jakariyamna met wa dɨde Elisabetɨnd simesime womnonj. ");
INSERT INTO gdr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ɨ re Elisabet utkundonj Mariyamna simesime yɨtkak, odenja tina kom borand b'ɨga b'arurkitonj, ɨ ket God Yɨnayɨna Wɨngawɨnga ke Elisabetɨnd yɨndangɨr womnonj. ");
INSERT INTO gdr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Sɨ Elisabet ket ukoi ara kɨma obailitonj gar sam kɨma, ɨ ket Mariyand womnonj da, “Man re b'ogɨl omni kongga et komkesa kongga wa wɨngɨrɨnd. Dɨde moina komɨnd b'ɨga toda kwa b'ogɨl omni e. ");
INSERT INTO gdr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nangga pae onggɨtyam b'ogɨljog mɨle awɨk kor pɨlɨnd, ɨte re kor Yonggyamɨmna mog tik kor pɨlwa ken esmaram? ");
INSERT INTO gdr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mop nokɨp re moina simesime nonykok b'ɨgar koina yɨpya bora wa, odenja komɨnd b'ɨga ma sobijog sam kɨma na b'arurkis. ");
INSERT INTO gdr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Sɨ ton b'ogɨl omni omb jɨ yeto re yɨtkak gar ke akateniny rɨna re Yonggyam tin wumɨr womnonj, mop nokɨp opimemb Tina yɨtkak opima ɨmɨnjogɨm taukanj.” ");
INSERT INTO gdr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ɨ ket Mariya windonj da, “Koina kukɨpɨt kor Yonggyamɨnd nyɨ pumb wa yurowateneny. ");
INSERT INTO gdr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ɨ koina wɨngawɨngat ɨta koina yɨrkokar okawayam Godɨm pɨlɨnd ukoi sam yomnɨkeneny. ");
INSERT INTO gdr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Mop nokɨp kon re goujog wɨko kongga en, ajɨ Godte b'obogɨl yɨr ɨpka niyeny. Ɨ mop nokɨp kwa komkesa rɨga yepim re yu wekeny dɨde tekenkeneny warɨtawarɨta onggɨt gowukoyɨnd, ton opima ken b'ogɨl notɨnenenyi yu ke dɨde naska nya wa. ");
INSERT INTO gdr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Mop nokɨp dandayam God kea ukoijog gasa nomnɨkainonj. Ɨ Tina nyɨ re yɨnayɨna e. ");
INSERT INTO gdr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ɨ God tena kear amnɨkeneniny yepim re Tin moga kɨma yesourenenyi komkesa yunɨm dɨde warɨm b'usmureni rɨga wa wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","God Tina yɨm ke danda wɨko amnɨkeneniny, sɨ Ton ket b'asourena rɨga erenjaeneniny yepim re towaina garɨnd b'asourena nony menamena amnɨkenenanj. ");
INSERT INTO gdr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","God ukoi wɨp iyoi rɨga gou wa amnɨkeneniny towaina pɨpmet ke, ajɨ Ton rɨga pumb wa urowateneniny yepim re towalenggyam gou wa aukenenanj. ");
INSERT INTO gdr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","God owoupa rɨga ngor amnɨkeneniny b'ogɨl gasa ke, ajɨ jogjog gasa kɨma rɨga yɨmkak nena etmɨkeneniny. ");
INSERT INTO gdr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","God kea yɨm akaeneninonj Tina wɨko rɨga Israelɨnd, odede na ɨt re rɨngmena re Ton tɨrɨr yɨt amninonj mera b'uwar. Sɨ onggɨt penaemb Ton ngɨrpu kesa nonyɨnd awameneninonj kear omnenam Abraamɨm pɨlwa dɨde tina komkesa b'usmureni b'ɨgawar wa pɨlwa.” ");
INSERT INTO gdr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Sɨ Mariya ama rɨka nowa mobi kɨma na Elisabet kɨma wɨbnonj, ɨ ket ton ɨtendonj ti tungg wa. ");
INSERT INTO gdr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ɨ Elisabetɨm ket wɨn wokatawonj b'ɨga ukendam, ɨ ton ket leo b'ɨga yukendonj. ");
INSERT INTO gdr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Sɨ ti wuswus rɨgap dɨde tina kus rɨgap utkundo da kea Yonggyam tin ukoi kear womɨny. Sɨ ket ton tuwonj ti pɨlwa, dɨde yɨpand gɨlgɨl sam yomnɨko ton kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ɨ re b'ɨga eitɨm (8) bibɨr awonj ukendi kak ke, ton b'usaya tuwonj Jakariyamna met wa onggɨt b'ɨgam pɨlɨnd God ma obagendi tɨrɨr omni mal wugɨm ɨpka mɨle omnɨkam. Ɨ ton pop ti nyɨ oekam yomno re ti b'uɨmna nyɨ, Jakariya kena. ");
INSERT INTO gdr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ajɨ ti mog ket esmonggainonj da, “Nayɨ, Yoante ti nyɨ ɨbnau.” ");
INSERT INTO gdr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ɨ todaka tin womno da, “Moina kus rɨga wa wɨngɨrɨnd makwa ɨta rɨga yete odede nyɨ ke oeki.” ");
INSERT INTO gdr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ajɨ ti b'u re yɨpya dum dɨde yɨt kesa na yebɨm. Sɨ onggɨt penaemb ton ti b'und yerkito ɨtaikena kɨma da, “Rɨnggɨtyam nyɨ e man singi yomnyɨt tin nyɨ oekam?” ");
INSERT INTO gdr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ɨ ton ket egekisinonj yɨpa ɨrɨkapu wulpagɨm iyoyɨm, dɨde ket yɨrɨkonj da, “Tina nyɨ re Yoante.” Sɨ onggɨt map komkesa rɨgap kɨd kesa aukɨto. ");
INSERT INTO gdr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ɨ odenja ket tina tugɨm ake weyat b'ogɨl awonda yɨt opurenam. Ɨ ton ket Godɨnd esourena yiyenonj. ");
INSERT INTO gdr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ɨ re komkesa ti wuswusam rɨgap onggɨtyam mɨle yɨr yongo, ton moga na aukɨto. Ɨ dɨde kea komkesa rɨgap kupka dor tunggɨnd Yuda eriya wɨngɨrɨnd yɨt b'ataya yiyeno onggɨtyam mɨle gatab. ");
INSERT INTO gdr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Sɨ komkesa utkunda rɨgap kea onggɨtyam mɨle gatab nonyɨk b'amdena wuwenonj towaina garɨnd, dɨde ton ket b'ɨgekena wuwenonj da, “Ɨtemb b'ɨga rɨdede wɨp rɨga e ɨbɨm dem warɨ?” Mop nokɨp ton kea yongwato da Yonggyamɨmna danda yɨm kea omanda ton kɨma yɨbnenenonj. ");
INSERT INTO gdr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ɨ ket God Yoanɨmna b'u Jakariyand Yɨnayɨna Wɨngawɨnga ke yɨndangɨr yomnonj, sɨ ton bage yɨt apureninonj da, ");
INSERT INTO gdr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Yesoulita Yonggyamɨnd, Israel rɨgaina Godɨnd, mop nokɨp Ton kea Tina rɨga eskena eyeneninonj dɨde ket towaina negɨr mɨle erabinonj ten ɨtraram negɨr mɨlem pɨlke. ");
INSERT INTO gdr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ɨ Ton kea yɨrkokar okawam danda pɨta yomnonj meranɨm Tina wɨko rɨga Dawidɨmna b'usmureni rɨga wa wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Odede na ɨt re rɨngmena re Ton get ke tɨrɨr omni yɨt akainonj Tina yɨna bageyam waina tugɨmɨnd pɨtapɨta omnenam. ");
INSERT INTO gdr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Onggɨtyam yɨrkokar okawa dandate men yɨrkokar okawam nɨtrarkeneniny meraina geja rɨga wa pɨlke dɨde komkesa rɨgaina danda yɨm wa pɨlke yepim re singi kesa nomnenanj. ");
INSERT INTO gdr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Sɨ onggɨt penaemb God kear amnɨkeneninonj mera b'uwar, ɨ onggɨt paemb kwa Ton nonyɨnd yowameneny Tina yɨna outɨnti tɨrɨr omnijog yɨt. ");
INSERT INTO gdr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","God kea danda kɨma Tina nyɨ kɨma yindonj onggɨtyam tɨrɨr omni yɨt mera b'u Abraam pɨlwa. Ɨ ket mera daka nokainonj ɨtrɨngendam geja rɨgaina danda yɨm wa pɨlke. Nokɨm da ɨdenat men meraina komkesa yɨrkokar wɨmena wɨngɨrɨnd moga kesa Ti wɨko omnɨkaindam Ti wɨpɨnd yɨna b'amnena mɨlend dɨde negɨr kesa dɨmdɨmjog mɨlend. ");
INSERT INTO gdr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kor b'ɨga! Man ɨta pumbjog rɨgamna bageyam nyɨ okasɨt dem. Mop nokɨp man naska e meket dem Yonggyamɨmna nya ongonjenam, ɨ Ton ket mor kak kae yik dem. ");
INSERT INTO gdr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Mante dem Tina rɨga wumɨr tamneninyɨt dem da God opima towaina negɨr mɨle awɨr tamnɨkiny dem, ɨ ɨngkaimemb ton ket yɨrkokar okatenyi dem. ");
INSERT INTO gdr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Onggɨt mop paemb jɨ da mera God re kɨd ke kear b'amnena rɨga e. Sɨ ra wɨn okas, yɨrkokar okawa rɨga opima men netɨsmariny dem odede wɨp ɨt re lomkongga rɨngma ra tɨlis sɨbɨbɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nokɨm da ɨdenat Ton tunyomareniny rɨga yepim re sɨbɨbɨnd dɨde ujɨmna danda wɨrand wekeny, ɨ ɨngkaimemb Ton men wang nitiyeniny dem de ngɨmbla nya wa meraina menon wɨngɨrɨnd.” ");
INSERT INTO gdr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ɨ ngɨrpu ket b'ɨga onyitonj dɨde wɨngawɨnga ke danda awonj. Ɨ ton ket yɨbnenenonj dea ta wul kesa tungg wa, ngɨrpu ton ket Israel rɨga wa wɨpɨnd pɨtapɨta awonj. ");
INSERT INTO gdr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ɨ onggɨt wɨnɨnd, Roma mopyam king Kaisa nyɨ da Augusto, kea b'ingawa yɨt yoramitonj Roma kantri rɨga komkesa nyɨ b'aramkam gabmani peba wa. ");
INSERT INTO gdr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sɨ re onggɨtyam naskajog nyɨ b'aramka wɨn awonj, Kwireniyot Roma gabmani mopyam yebɨm Siriya eriya wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ɨ komkesa rɨga ɨtendento towainajog ukendipu taun wa nyɨ b'aramkam. ");
INSERT INTO gdr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ɨ Yosep toda yiwatonj Najaret taun ke Galili eriya wɨngɨrɨnd de Dawidɨmna taun wa nyɨ yogenayo da Betleem Yuda eriya wɨngɨrɨnd, mop nokɨp ton re yɨpa Dawidɨmna b'usmureni b'ɨga na. ");
INSERT INTO gdr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ɨ Yosep yikonj Betleem taun wa re Mariya kɨma na yana kɨma re ton tɨrɨr yomnonj molkongga awowɨm. Ajɨ Mariya re kom kɨma na momta B'ɨga ukendam. ");
INSERT INTO gdr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ɨ re ton dea de Betleem wa ebnonda, ti ket wɨn wokatawonj B'ɨga ukendam. ");
INSERT INTO gdr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Sɨ ton ket ti naskajog leo B'ɨga pɨta yomnonj, ɨ B'ɨga kukum yomnɨkonj kobɨrgɨm ke, ngɨrpu yoramitonj b'angga ongenapu wul iyoki bora wa. Mop nokɨp komkesa obai met re yɨndangɨr na wekenonj, sɨ towa maike ket pɨpmet awonj wɨmenam. ");
INSERT INTO gdr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ɨ onggɨtyam taun bau ke yap nata nɨnda mamoi yɨr ɨpka rɨga wungawungapu pɨpmetɨnd wekenonj. Ɨ yɨpa sɨwɨnyɨnd ton towaina mamoi yɨrgong omnɨka eyento. ");
INSERT INTO gdr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ɨ onggɨt sɨwɨnyɨnd Yonggyamɨmna aneru pɨtapɨta awonj towa wɨpɨnd, ɨ ket Yonggyamɨmna b'ogɨl ɨnyomarenat ten anyowainonj. Sɨ ton ma sobijog moga na aukɨto. ");
INSERT INTO gdr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ajɨ anerut ket ten amninonj da, “Goro moga tainam! Mop nokɨp kon ukoijog sam kɨma God ma b'ogɨl yɨrkokar bage yɨt e pɨtapɨta omnyɨn wa pɨlwa rɨnte ra dem komkesa rɨga wa tainy. ");
INSERT INTO gdr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sɨ yu ke wanɨm yɨrkokar okawayam pɨta ainy Dawidɨmna taunɨnd. Ton re Kerisote yete re Yonggyam. ");
INSERT INTO gdr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ɨ ɨja emb jɨ wɨn ɨmɨnjogɨm ɨmjasya koina yɨt. Ra wɨn wuyɨt, wɨn ɨta odarya yɨpa b'ɨga kobɨrgɨm ke kukum omnɨki dɨde oramiti b'angga ongenapu wul iyoki borand.” ");
INSERT INTO gdr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ɨ yɨr kesa borand pumb tungg ke ukoi geja aneru bobo yɨpand aukɨto onggɨtyam yɨpa aneru kɨma dɨde Godɨnd yesoureno ɨ dɨde endento da, ");
INSERT INTO gdr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“B'ogɨl ɨnyomarena Godɨm pɨlwa pumb tunggɨnd, dɨde God kea ngɨmbla yoramis gowɨnd rɨga wa pɨlwa yena re God sam kɨma singi eyeniny!” ");
INSERT INTO gdr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ɨ re anerup ten erarkɨto ɨ ɨtekto de pumb tungg wa, mamoi yɨr ɨpka rɨgap towalenggyam towalenggyam aena wuwenonj da, “Sɨ b'ogɨl e, mabe wuyɨn Betleem taun wa, ɨ yɨr ongongɨm yapu onggɨtyam auki gasa rɨna re Yonggyam men wumɨr nomniny.” ");
INSERT INTO gdr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Sɨ ton ket mukupmukup wuwonj dɨde adarto Mariya ɨ Yosep ɨ dɨde b'ɨga sobijog oramiti b'angga ongenapu wul iyoki borand. ");
INSERT INTO gdr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ɨ re ton b'ɨga sobijog yɨr yongo, seg ket ton kea rɨga wumɨr amnento onggɨtyam yɨtkak gatab rɨna re aneru towa usekainonj onggɨt b'ɨga gatab. ");
INSERT INTO gdr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ɨ re rɨgap utkundento mamoi yɨr ɨpka rɨgaina opureni yɨtkak, ton komkesa rɨga kea kɨd kesa aena wuwenonj towaina opureni yɨt gatab. ");
INSERT INTO gdr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ajɨ Mariya re kea komkesa onggɨtyam yɨtkak angapinonj ɨpɨndena kɨma tina gar wa. ");
INSERT INTO gdr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ɨ mamoi yɨr ɨpka rɨgap Godɨnd b'ogɨl ɨnyomarena yokaeno dɨde esourena yiyeno onggɨtyam komkesa mɨle gatab rɨna re ton utkundento dɨde yɨr angto odede yɨpa wɨp rɨja na re anerut towa usekainonj. Ɨ ton ket odede esourena kɨma ɨtekto. ");
INSERT INTO gdr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ɨ re b'ɨga eitɨm (8) bibɨr awonj ukendi kak ke, Ton kea God ma obagendi tɨrɨr omni mal wugɨm ɨpka mɨle yokatonj. Ɨ ket Tin nyɨ yoeko da Yesu, ɨtemb nyɨ ɨnta ɨt re rɨja na re aneru Mariyand wingawonj Tin nyɨ oekam, re ton maka Tin komɨnd yowamonj. ");
INSERT INTO gdr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ɨ Mariya ake Yosep towaina ɨseka mɨle omnɨkam bibɨr awonj rɨna re Mosemna gog yɨtɨt Ju rɨga engaeninonj b'ɨga ukendi kak ke omnɨkam. Sɨ ton Yesund yiyonda Yerusalem wa Yonggyamɨm okawam. ");
INSERT INTO gdr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Mop nokɨp ton singi na Yonggyamɨmna gog yɨt rɨrɨrɨnd omnɨkam ɨt re ɨrɨki yɨbɨm da, “God b'ingawa yɨt yoramitonj da wɨn komkesa naskajog ukki leo b'ɨga nyɨ taekindam dem da ton re Yonggyamɨm yɨna omni im.” ");
INSERT INTO gdr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ɨ kwa ton singi awonda Godɨm pɨlwa sɨ gasa okawam Yonggyamɨmna opureni gog yɨt rɨrɨrɨnd ɨt re da nɨmog gimai o nɨmog sisɨlyam kimɨk. ");
INSERT INTO gdr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ɨ onggɨt wɨnɨnd yɨpa rɨga yɨbnonj Yerusalem taunɨnd nyɨ da Simeon. Ton re negɨr kesa dɨmdɨmjog rɨga na dɨde Godɨnd moga kɨma ewangaya rɨga na. Sɨ ton yɨr yungaukenenonj re Keriso na yet ra Israel rɨga wa yɨrkokar takainy dem. Ɨ Yɨnayɨna Wɨngawɨnga kea ton kɨma yɨbnenenonj. ");
INSERT INTO gdr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ɨ Yɨnayɨna Wɨngawɨngat ket nonony yɨt pɨtapɨta yomnenainonj da, “Man ma ɨta uj yɨr onget dem ngɨrpu ama ra dem man yɨr onget dem Yonggyamɨmna Keriso.” ");
INSERT INTO gdr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ɨ Yɨnayɨna Wɨngawɨngat tin ket wɨp yomnonj menonɨm de yɨnamet wa. Ɨ re ket ton yɨnamet aba wa opendonj, odedend ket molkonggap todaka towa B'ɨga Yesund iyonda onggɨt pɨpmet wa gogɨmna b'ingawa rɨrɨrɨnd mɨle omnɨkam Ti pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Sɨ Simeon ket onggɨt B'ɨgand yokatonj dɨde yɨm kumbɨnd yowamonj. Ɨ ton ket Godɨnd b'ogɨl yɨt kɨma yesoulitonj odede da, ");
INSERT INTO gdr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Yonggyam! Kon re moina wɨko rɨga en, ɨ yu man kea koina gar bebɨg awɨr yomnyɨt moina tɨrɨr omni yɨt rɨrɨrɨnd, sɨ kon ket rɨrɨr e ngɨmbland gowukoi ɨraren. ");
INSERT INTO gdr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mop nokɨp kon kea koina yɨrkɨpjog ke yɨr yongen moina Yɨrkokar Okawa Rɨga. ");
INSERT INTO gdr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Man kemb onggɨtyam Yɨrkokar Okawa Rɨga yongonjenyɨt komkesa gowukoi rɨga wa wɨpɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ton re ɨnyomarenam ngaya e God ma obagɨki kesa rɨga wa, ɨ Ton re b'ogɨl ɨnyomarena e moina rɨga, Israelɨm.” ");
INSERT INTO gdr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Sɨ ket Ti b'u ake Ti mog re kɨd kesa na awonda onggɨtyam Ti gatab opureni yɨt map. ");
INSERT INTO gdr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ɨ Simeon b'ogɨl amnonj Ti b'u ake Ti mog, ɨ ket Ti mog Mariyand womnonj da, “Yɨr, God yoramitonj onggɨt B'ɨgand re Israel wɨngɨrɨnd jogjog rɨga negɨr wa sap otenda mana dɨde b'ogɨl wa utnyita mana. Ɨ kwa Ton re yɨpa ongwatam mal e tainy rɨnte ra dem rɨgap Tin ɨsaenenyi. ");
INSERT INTO gdr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Sɨ onggɨt paemb man ɨta okasɨt dem ukoi gar kopa odede rɨngma ra ukoi girit moina kukɨp b'ɨtpaukis, mop nokɨp ɨngkaemb jogjog rɨgaina negɨr nony menamena pɨta taukanj dem towaina gar ke.” ");
INSERT INTO gdr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ɨ onggɨt wɨnɨnd yɨpa kongga bageyam wɨbnonj re nyɨ da Ana. Ton re Panuwelɨmna ngɨmngai b'ɨga na, Aser gu wɨngɨrɨnd. Ɨ ton re molegjog na. Sɨ re ton leo kɨma awonj, ton seben (7) kemag kɨma na yɨpand ebnonda. ");
INSERT INTO gdr_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Onggɨt kak ke ton mik na rain ngɨrpu re ket eiti powa (84) kemag awonj. Ton makwa yɨnamet yɨrarenenonj, ajɨ ton ita sɨwɨny dɨde ita bibɨr Godɨnd yewangaenenonj owou uwabɨka kɨma dɨde yɨr opmita kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ɨ onggɨt wɨnɨnd odedend ton ket tikonj yɨnamet wa, dɨde Godɨnd sɨteket yɨt yomnonj. Seg ket ton onggɨt B'ɨgam gatab apureninonj komkesa rɨga wa yepiya re yɨr ungauka yiyeno da Keriso ɨta Yerusalemɨmna negɨr mɨle ɨrab dem. ");
INSERT INTO gdr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ɨ re Yosep ake Mariya komkesa mɨle endwasinonda Yonggyamɨmna gog rɨrɨrɨnd, ton ket ɨtendonda towainajog Najaret taun wa Galili eriya wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ɨ ademb de ɨtemb B'ɨga Yesu ɨnɨka yikonj dɨde kak seo auka yikonj. Ɨ Ton b'ogɨl multekɨp ke yɨndangɨr omni na yɨbnonj dɨde Godɨmna wurar re omanda Ton kɨma yɨbnenenonj. ");
INSERT INTO gdr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ɨ Yesu ma b'u ake mog re ita kemagɨnd Yerusalem taun wa menon yokatenenonda Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam Wɨnɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sɨ ton onggɨtyam diyamdiyam omnɨka mɨle rɨrɨr nat wuwonj Yerusalem taun wa, re Yesu twelp (12) kemag rain. ");
INSERT INTO gdr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ɨ re ket onggɨtyam diyamdiyam wɨn b'undwatonj, molkonggap tungg wa yiwatonda rɨga bobo kɨma, ajɨ kewar b'ɨga Yesu omanda Yerusalem taunɨnd ɨtendonj. Ajɨ Ti b'u ake Ti mog re maka wumɨr awonda Tina ɨtenda gatab. ");
INSERT INTO gdr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Sɨ ton towaina menon wɨngɨrɨnd ɨja na nony awonda da towa B'ɨga re ɨta yɨpand ik towa bobo wɨngɨrɨnd. Ɨ re ton yɨpa bibɨr kɨma pɨnjog menon yokatonda, ngɨrpu ton ket towa B'ɨgand oraka yiyenonda towaina kus rɨga wa wɨngɨrɨnd dɨde towa rɨgawar wa wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ajɨ re ket Tin maka yodaronda, ton ket nyatnyata Tin oraka yiyenonda ngɨrpu ɨtendonda Yerusalem taun wa. ");
INSERT INTO gdr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ɨ re ton oraka yiyenonda nowa bibɨr kɨma, ton ket Tin yodaronda yɨnamet aband omiti gog ouyaena rɨga ganggand. Sɨ Ton towaina opureni yɨtkak na utkundeninonj, ɨ dɨde Ton b'arkena aramiteninonj towa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ɨ re Ton mɨra amneninonj, komkesa rɨga yepiya re Tina yɨt utkundento, ton kɨd kesa na aena wuwenonj Tina b'ogɨl multekɨp dɨde Tina ɨsmongga yɨt gatab. ");
INSERT INTO gdr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ɨ onggɨt wɨnɨnd re Ti b'u ake Ti mog Tin yɨr yongonda, ton kea wɨnga kesa awonda. Sɨ ket Ti mog Tin yomnonj da, “Kor b'ɨga! Nangga pena Man sɨn odede ɨsnawa kesa nomnenyɨmɨt? Yɨr de, kon dɨde Mor b'u ma sobijog gar bebɨg kɨma na sɨn Men oraka miyenyɨma.” ");
INSERT INTO gdr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ɨ ket Yesu ten amnonj da, “Nangga ma wɨn Ken oraka niyenya? Wɨn ma wumɨr i da Kon b'ogla Kor B'uɨmna metɨnd nɨtɨbnyɨn?” ");
INSERT INTO gdr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ajɨ ton maka nony aukonda Tina opureni yɨtkak gatab rɨna re ten amnonj. ");
INSERT INTO gdr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ɨ ket Yesu yikonj Ti b'u ake Ti mog kɨma de Najaret taun wa. Ɨ re ton Najaret taunɨnd wekenenonj, Ton kea towaina yɨt akatenenainonj. Ajɨ Ti mog Mariya re kea komkesa Tina opureni yɨtkak angapeninonj tina garɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ɨ Yesu kea Tina b'ogɨl multekɨp ke dɨde Tina uski ke ɨnɨka yikonj. Ɨ Godɨm pɨlke dɨde rɨga wa pɨlke singi b'iyena kea ukoi warabag auka yikenonj. ");
INSERT INTO gdr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Ɨ Godɨmna bage yɨt ikonj Jakariyamna b'ɨga Yoanɨm pɨlwa wul kesa tunggɨnd onggɨt wɨn nat re piptinɨm (15) kemag rau Tiberiyom yet re Roma mopyam king Kaisamna pɨpmetɨnd yɨbnonj, ɨ kwa re Pontiyo Pilato Roma gabmani mopyam yebɨm Yuda eriya wɨngɨrɨnd, ɨ kwa re Erod king pɨpmetɨnd yebɨm Galili eriya wɨngɨrɨnd, ɨ kwa re Erodɨmna yɨpa mog ke nany Pilip king pɨpmetɨnd yebɨm Ituraya eriya dɨde Trokoniti eriya wɨngɨrɨnd, ɨ kwa re Lisaniyo king pɨpmetɨnd yebɨm Abilene eriya wɨngɨrɨnd, ɨ kwa re Ana dɨde Kayapa yɨna mopyam sɨ rɨga pɨpmetɨnd rebna. ");
INSERT INTO gdr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ɨ Yoan ket yikenonj komkesa Yordan kɨlɨm wuswus tungg nata, ɨ ton pɨtapɨta omnena yiyenonj re engenda baptiso na negɨr mɨle ewaikitam gar ke. ");
INSERT INTO gdr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ɨja naemb jɨ ton onggɨtyam yɨtkak rɨrɨrkɨp omnam pɨtapɨta yomnenonj rɨnsim re bageyam Isayamna peband ɨrɨki wekeny odede da, “Ɨta ukoi ara b'emoka pɨta tainy dem wul kesa tunggɨnd da, wɨn Yonggyamɨm nya ɨspɨkaindam, ɨ Tina menonpu nya dɨmdɨm omnɨkaindam. ");
INSERT INTO gdr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sɨ komkesa kipkip pɨpmet b'ogla imanggurki waken, ɨ komkesa dor dɨde sukak pɨpmet ɨrɨnjɨp kesa iporki waken. Ɨ kaokao nya dɨmdɨm auki waken, dɨde komkesa negɨr b'uwombenapu gasa ewaikuri waken nya ke. ");
INSERT INTO gdr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ɨ ɨta ket komkesa rɨgap yɨr ongi dem Godɨmna yɨrkokar okawa mɨle.” ");
INSERT INTO gdr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ɨ Yoan rɨga bobo yɨt amninonj yepiya re wuwenonj ti pɨlwa baptiso okatam da, “Wɨn, negɨr guda kɨma gɨrem waina b'ɨgawar! Yet wen wumɨr amninonj da wɨn b'ogla b'ɨtkenindam Godɨmna ukoi soro kɨma b'ɨsagɨkam pɨlke rɨnte ra ik dem? ");
INSERT INTO gdr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sɨ onggɨt paemb ra wɨn singi engenda baptiso okatam, sɨ wɨn b'obogɨl garjog ke ɨmɨnjog engenjinam waina negɨr mɨlem pɨlke de Godɨm pɨlwa, dɨde ket onggɨt engendi mɨle rɨrɨrɨnd kɨp kɨma mɨlend wɨmena tuwenyɨt. Ɨ wɨn goro odede nonyɨk b'atɨmdeninam da, ‘Sɨn re Abraamɨmna b'ɨga im.’ Mop nokɨp kon kea wen amninyɨn da God rɨrɨr e onggɨt gɨmo wa pɨlke Abraamɨmna b'ɨga tawɨnkiny. ");
INSERT INTO gdr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sɨ yapa re kea wul mop wus nate yɨbɨm ɨgogɨm. Sɨ yonggyam ɨta onggɨt yapa ke komkesa wul ɨgka teyeniny rɨnsim re maka b'ogɨl kɨp ejagɨkanj, dɨde ton ket wul wa teskokiny so omnɨkam.” ");
INSERT INTO gdr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sɨ rɨga bobop tin yerkito da, “Nangga e ket omnɨku?” ");
INSERT INTO gdr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Sɨ Yoan ten mɨra amninonj da, “Ya mana ra nɨmog kobɨrgɨm ɨbnau, ton b'ogla weweyam yakau tinɨm yet ra kobɨrgɨm kesa ɨbɨm. Ɨ ya mana ra owou ɨbnau, toda ɨja na yɨpa wɨp mɨle yamnɨk.” ");
INSERT INTO gdr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ɨ teks imdayam rɨga todaka tuwonj Yoanɨm pɨlwa baptiso okatam, ɨ ton ket tin yɨgekito da, “Ouyaena rɨga! Nangga e sɨn omnɨku?” ");
INSERT INTO gdr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Sɨ ton ten amninonj da, “Wɨn b'ogla b'ingawa rɨrɨrɨnd teks imda teyenindam, ajɨ goro kwa onggɨt tumɨnd wewe imda teyeninam!” ");
INSERT INTO gdr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ɨ nɨnda geja rɨgap todaka tin yɨgekito da, “Nangga e sɨdaka omnɨku?” Sɨ ton ket ten mɨra amninonj da, “Goro wɨn ɨsanikesa waina danda ke rɨgaina wulkɨp imda teyeninam. Ɨ goro rɨga b'ɨsagɨkand oramitena teyeninam b'anygɨnena nya ke. Ajɨ wɨn b'ogla nony sam taukindam waina mɨra wulkɨp gatabɨm.” ");
INSERT INTO gdr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Sɨ komkesa rɨga yepiya re Kerisond yɨr yungaeneno, ton towaina garɨnd Yoanɨm gatab ɨkalnena yiyeno da, “Rɨka ton amaya Kerisote?” ");
INSERT INTO gdr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Sɨ Yoan komkesa rɨga mɨra amninonj da, “Kon nyɨ kaim wen baptiso amnɨkinyɨn, ajɨ ukoijog danda rɨga ɨta ik dem yaina danda e re Ti pumbjog wa e ajɨ koina re goujog wa e. Sɨ kon ma rɨrɨrkɨpjog rɨga en Tina yongɨnkak kai ɨtreka wɨko omnɨkam rɨna ra goujog wɨko rɨgat mɨle omnɨk. Ɨ Ton wen baptiso omnɨka teyeniny ra Yɨnayɨna Wɨngawɨnga kae dɨde wul dɨmɨl kae. ");
INSERT INTO gdr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ɨ Ton ɨta Ti yɨmɨnd owoukɨp iukapu sabol yowam, sɨ Ton ɨta Tina owou erngokapu pɨpmetɨnd komkesa uwakurki owoukɨp sabol ke ouroka teyeniny dɨde ket pumb wa b'ɨtɨskeniny rɨbɨm uturenam. Nokɨm da ɨdenat Ton b'ogɨlyam owoukɨp tekalneniny mogjɨ kesa kɨp dɨde au wa pɨlke. Ɨ ra Ton onggɨtyam wɨko seg omɨny, Ton ɨta ket b'ogɨlyam owoukɨp taramkiny owoukɨp ongapapu met b'ɨga wa, ajɨ Ton ket mogjɨ kesa kɨp dɨde au so tamnɨkiny osouka kesa wul ke.” ");
INSERT INTO gdr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Sɨ Yoan God ma b'ogɨl yɨrkokar bage yɨt rɨga wa pɨtapɨta amnenainonj re jogjog b'engabenga b'ugowa yɨt kɨma na. ");
INSERT INTO gdr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ajɨ Yoan samany yɨt kɨma pɨtapɨta yomnenainonj king Erodɨmna negɨr mɨle rɨna re ton amnɨkinonj ti yɨngganɨmna kongga Erodiya kɨma dɨde komkesa tina negɨr mɨle gatab. ");
INSERT INTO gdr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ɨ re Erod Yoanɨnd sɨbɨbmet wa yoramitonj, sɨ ton ɨngkenaemb kwa tina negɨr mɨle b'usaya yangitonj komkesa tina negɨr mɨle tumɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ɨ re komkesa rɨgap baptiso yokateno Yoanɨm pɨlke, Yesu toda kea baptiso yokatonj, dɨde yɨr opmitonj. Ɨ onggɨt wɨnɨnd wub ɨpangendonj, ");
INSERT INTO gdr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","dɨde Yɨnayɨna Wɨngawɨnga eouka ikonj Ti pɨlwa ɨja na ɨt re gimai re dɨde. Ɨ ket ara ikonj wub kumb ke da, “Man re Koina B'ɨga et yena re Kon singi miyenyɨn. Ɨ Kon ukoi sam en Mornɨm.” ");
INSERT INTO gdr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ɨ Yesu Ti wɨko yotomonj re Ti teti (30) kemag nat. Ɨ rɨgap ɨja na wumɨr yokateneno da, Ton re Yosepɨmna b'ɨga e, ɨ Yosep re Elimna b'ɨga e, ");
INSERT INTO gdr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ɨ Eli re Matatɨmna b'ɨga e, ɨ Matat re Lebimna b'ɨga e, ɨ Lebi re Melkimna b'ɨga e, ɨ Melki re Yanaimna b'ɨga e, ɨ Yanai re Yosepɨmna b'ɨga e, ");
INSERT INTO gdr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ɨ Yosep re Mattatiyamna b'ɨga e, ɨ Mattatiya re Amosɨmna b'ɨga e, ɨ Amos re Naumɨmna b'ɨga e, ɨ Naum re Eslimna b'ɨga e, ɨ Esli re Nagaimna b'ɨga e, ");
INSERT INTO gdr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ɨ Nagai re Maatɨmna b'ɨga e, ɨ Maat re Mattatiyamna b'ɨga e, ɨ Mattatiya re Semeinɨmna b'ɨga e, ɨ Semein re Yosekɨmna b'ɨga e, ɨ Yosek re Yodamna b'ɨga e, ");
INSERT INTO gdr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ɨ Yoda re Yoananɨmna b'ɨga e, ɨ Yoanan re Resamna b'ɨga e, ɨ Resa re Jerubabelɨmna b'ɨga e, ɨ Jerubabel re Salatiyelɨmna b'ɨga e, ɨ Salatiyel re Nerimna b'ɨga e, ");
INSERT INTO gdr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ɨ Neri re Melkimna b'ɨga e, ɨ Melki re Adimna b'ɨga e, ɨ Adi re Kosamɨmna b'ɨga e, ɨ Kosam re Elmadamɨmna b'ɨga e, ɨ Elmadam re Erɨmna b'ɨga e, ");
INSERT INTO gdr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ɨ Er re Yosuwamna b'ɨga e, ɨ Yosuwa re Eliyejerɨmna b'ɨga e, ɨ Eliyejer re Yorimɨmna b'ɨga e, ɨ Yorim re Matatɨmna b'ɨga e, ɨ Matat re Lebimna b'ɨga e, ");
INSERT INTO gdr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ɨ Lebi re Simeonɨmna b'ɨga e, ɨ Simeon re Yudamna b'ɨga e, ɨ Yuda re Yosepɨmna b'ɨga e, ɨ Yosep re Yonamɨmna b'ɨga e, ɨ Yonam re Eliyakimɨmna b'ɨga e, ");
INSERT INTO gdr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ɨ Eliyakim re Meleamna b'ɨga e, ɨ Melea re Menamna b'ɨga e, ɨ Mena re Matatamna b'ɨga e, ɨ Matata re Natanɨmna b'ɨga e, ɨ Natan re Dawidɨmna b'ɨga e, ");
INSERT INTO gdr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ɨ Dawid re Yesaimna b'ɨga e, ɨ Yesai re Obedɨmna b'ɨga e, ɨ Obed re Boasɨmna b'ɨga e, ɨ Boas re Salmonɨmna b'ɨga e, ɨ Salmon re Naasonɨmna b'ɨga e, ");
INSERT INTO gdr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ɨ Naason re Aminadabɨmna b'ɨga e, ɨ Aminadab re Adminɨmna b'ɨga e, ɨ Admin re Arnimna b'ɨga e, ɨ Arni re Esromɨmna b'ɨga e, ɨ Esrom re Peresɨmna b'ɨga e, ɨ Peres re Yudamna b'ɨga e, ");
INSERT INTO gdr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ɨ Yuda re Yakobɨmna b'ɨga e, ɨ Yakob re Isakɨmna b'ɨga e, ɨ Isak re Abraamɨmna b'ɨga e, ɨ Abraam re Teramna b'ɨga e, ɨ Tera re Naorɨmna b'ɨga e, ");
INSERT INTO gdr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ɨ Naor re Serukɨmna b'ɨga e, ɨ Seruk re Rɨumna b'ɨga e, ɨ Rɨu re Pelegɨmna b'ɨga e, ɨ Peleg re Eberɨmna b'ɨga e, ɨ Eber re Selamna b'ɨga e, ");
INSERT INTO gdr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ɨ Sela re Kainanɨmna b'ɨga e, ɨ Kainan re Arpaksadɨmna b'ɨga e, ɨ Arpaksad re Semɨmna b'ɨga e, ɨ Sem re Nowamna b'ɨga e, ɨ Nowa re Lamekɨmna b'ɨga e, ");
INSERT INTO gdr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ɨ Lamek re Mutuselamna b'ɨga e, ɨ Mutusela re Enokɨmna b'ɨga e, ɨ Enok re Yaretɨmna b'ɨga e, ɨ Yaret re Maalalelɨmna b'ɨga e, ɨ Maalalel re Kenanɨmna b'ɨga e, ");
INSERT INTO gdr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ɨ Kenan re Enosɨmna b'ɨga e, ɨ Enos re Setɨmna b'ɨga e, ɨ Set re Adamɨmna b'ɨga e, ɨ Adam re Godɨmna b'ɨga e. ");
INSERT INTO gdr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ɨ Yesu Yɨnayɨna Wɨngawɨnga ke yɨndangɨr omni na yɨraronj Yordan kɨlɨm. Sɨ Yɨnayɨna Wɨngawɨngat Tin wɨp yomnonj wul kesa tungg wa. ");
INSERT INTO gdr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Onggɨt wul kesa tunggɨnd Ton otonkena yokatenonj Satanam pɨlke poti (40) bibɨr kɨma. Ɨ Ton makwa nangga na awinonj onggɨt bibɨr wɨngɨrɨnd. Sɨ re ket Ton onggɨtyam bibɨr undwasinonj, sɨ Ton ket owoupa awonj. ");
INSERT INTO gdr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ɨ ket Satana Tin yomnonj da, “Rada Man Godɨmna B'ɨga et, Man ingaet onggɨtyam gɨmo engendam yɨpa sana kɨpolɨm.” ");
INSERT INTO gdr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ajɨ Yesu tin mɨra yomnonj da, “Yɨna peband ɨja emb jɨ ɨrɨki yɨbɨm da, ‘Rɨgat ma owou nena kae yilo yɨbɨm.’” ");
INSERT INTO gdr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ɨ ton ket Yesund yiyonj yɨpa pumbpumb pɨpmet wa, ɨ Tin ket youyainonj gowukoi komkesa kantri gatab sobijog wɨnɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ɨ ket Satana Tin yomnonj da, “Kon Mor motkainyɨn onggɨtyam komkesa gowukoi danda dɨde komkesa kantrimna b'ogɨl ɨnyomarena. Mop nokɨp onggɨtyam komkesa re kor manaemb nogoninonj, sɨ kon rɨrɨr en ti ogonam yena ra kon singi omnyɨn. ");
INSERT INTO gdr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Sɨ onggɨt paemb ra Man ken kumsos netɨmket, komkesa gasa ra ket Mor mima taukanj.” ");
INSERT INTO gdr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ajɨ Yesu tin mɨra yomnonj da, “Ɨja emb jɨ yɨna peband ɨrɨki yɨbɨm da, ‘Man moina Yonggyam Godɨnd kumsos emkenenyɨt, ɨ Ti nena mana emb wɨko omnɨkaenenyɨt.’” ");
INSERT INTO gdr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ɨ kwa ket Satana Yesund wɨp yiyonj de Yerusalem taun wa, dɨde Tin yonyitonj yɨpa yɨnamet papkak kumbɨnd. Ɨ ton ket Yesund yomnonj da, “Rada Man Godɨmna B'ɨga et, ɨngkek Man Molenggyam b'atiyakite de gou wa! ");
INSERT INTO gdr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Mop nokɨp yɨna peband ɨja emb jɨ ɨrɨki yɨbɨm da, ‘God opima Tina aneru tengainy dem Men b'obogɨl yɨr engendam.’ ");
INSERT INTO gdr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ɨ kwa ɨrɨki yɨbɨm da, ‘Ɨ ton ket men towaina yɨm kumbɨnd motowami. Sɨ onggɨt paemb man ma ɨta ket moina pɨs taskisɨt motɨr kumbɨnd.’” ");
INSERT INTO gdr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ajɨ Yesu tin mɨra yomnonj da, “Yɨna peband kwa ɨja emb jɨ yindeny da, ‘Man goro moina Yonggyam Godɨnd otonkena mɨlend oramitenɨm!’” ");
INSERT INTO gdr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ɨ re ket Satana onggɨtyam komkesa otonkena mɨle undwasinonj, ton ket Yesund yɨraronj, ngɨrpu rokate ra kwa yɨpa b'ogɨl wɨn okas otonkenam. ");
INSERT INTO gdr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ɨ ket Yesu Yɨnayɨna Wɨngawɨngamna danda kɨma na ɨtendonj Galili eriya wa, sɨ Ti gatab yɨdɨr yɨt re kea kupka eriya nata yikenonj. ");
INSERT INTO gdr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ɨ Ton kea rɨga ouyaena eyeninonj towaina yɨr opmitenapu met nata, ɨ kea ket komkesa rɨgap Tin daka esourena yiyeno. ");
INSERT INTO gdr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ɨ ket Yesu ɨtendonj Najaret taun wa rɨkɨnd re Ton ukoi awonj. Ɨ re Ju rɨga waina wɨram dɨde yɨr opmitena bibɨr awonj, Ton kea ket yikonj Ju rɨga waina yɨr opmitenapu met wa Tina get ke mɨle rɨrɨrɨnd, dɨde ket b'ɨgaronj wɨngɨr wa, ɨ ket onyitonj yɨna peba ogenkam. ");
INSERT INTO gdr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Sɨ re yɨna peba owama rɨgat Ti yokawonj bageyam Isayamna eoromki peba, Ton ket peba yobgokonj dɨde oraka yiyonj onggɨtyam pɨpmet rɨkɨnd re odede yɨtkak ɨrɨki yebɨm da, ");
INSERT INTO gdr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Yonggyam Godɨmna Wɨngawɨnga ɨta kor pɨlɨnd, mop nokɨp Ton kea ken gaya ke neaukonj Tina b'ogɨl yɨrkokar bage yɨt pɨtapɨta omnenam gasa kesa rɨga wa pɨlwa, ɨ Ton kea ken nɨtmɨkitonj pɨtapɨta omnenam Tina mɨle, opi re da ɨjobɨki rɨga ɨtrɨngkam ɨ yɨrdɨdɨ rɨga yɨr ɨpangkam, ɨ dɨde bebɨg awɨr omnam towa pɨlke yepim re bebɨg wɨrand wekeny, ");
INSERT INTO gdr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ɨ kwa pɨtapɨta omnenam onggɨtyam kemag rɨdenasim ra Yonggyam rɨga kear tamneniny.” ");
INSERT INTO gdr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ɨ Ton ket peba yeoromkonj, ɨ peba owama rɨgam yokawonj. Ɨ re ket Ton omitonj yɨtkak pɨtapɨta omnenam, komkesa rɨga yepiya re wekenonj onggɨt Ju rɨga waina yɨr opmitenapu metɨnd, adea de Ti pɨlwa yɨr ɨsokto. ");
INSERT INTO gdr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ɨ ket Yesu b'atomonj opurena, ɨ ten amninonj da, “Yu kemb ɨtemb Isayamna ɨrɨki yɨtkak rɨrɨrkɨp ainy onggɨt opureni yɨtkak ke rɨna re wɨn utkundenya waina yɨpya ke.” ");
INSERT INTO gdr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Sɨ komkesa rɨgap sam kɨma yɨt yɨmjateno Ti gatab, ɨ ton ket kɨd kesa aena wuwenonj Tina tugɨm ke opureni wurar kɨma yɨtkak gatab, ɨ ton b'ɨgekento da, “Rɨngma, ma ɨnte jɨ Yosepɨmna B'ɨga?” ");
INSERT INTO gdr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Sɨ Yesu ten ramnin da, “Wɨn opima Kornɨm onggɨtyam tendam gatab yɨt tendenindam da, ‘Dokta! Man naska molenggyam moina kopa ke b'ɨsakende!’ Wɨn kwa tendenindam da, ‘Sɨn kea utkundentondam komkesa mɨle rɨna re man amnɨkinot Kaparnaum taunɨnd. Sɨ onggɨt paemb man b'ogla kwa dɨkɨnd moinajog tunggɨnd tamnɨkinyɨt onggɨtyam komkesa mɨle.’” ");
INSERT INTO gdr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ɨ kwa Ton ten amninonj da, “Kon ɨmɨnjog wen tamninyɨn da rɨgap makwa ɨta bageyam simesime yomnɨkenenyi tinajog tunggɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ɨ Kon kwa ɨmɨnjog wen tamninyɨn da Eliyam wɨnɨnd re piro kesa wɨn awonj nowa kemag dɨde siks (6) mobi kɨma dɨde ukoi sou aukonj komkesa Israel gowɨnd, ma yɨpa kɨma mik kongga na wekenonj Israel wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ajɨ onggɨt wɨnɨnd God maka Eliyand yɨtmɨkitonj towa pɨlwa, ajɨ atata b'enga kantri wa, yɨpa mik konggam pɨlwa de Sarepta tungg wa Sidon eriya wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ɨ kwa ma yɨpa kɨma leprosi kopa rɨga na wekenonj Israel wɨngɨrɨnd onggɨt wɨnɨnd re Elisa bageyam yebɨm. Ajɨ makwa yɨpa rɨga kɨlkɨp kesa awonj towa wɨngɨrɨnd, ajɨ ɨna yɨpaina Siriya rɨga Naaman nenat.” ");
INSERT INTO gdr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ɨ re komkesa rɨgap onggɨtyam yɨtkak gatab utkundento onggɨtyam Ju rɨga waina yɨr opmitenapu metɨnd, sɨ ton ma sobijog na soro aukɨto. ");
INSERT INTO gdr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Sɨ ton ket owɨnkɨto, ɨ ket Yesund otoukena yiyo de taun bau wa, ngɨrpu ket Tin yiyo de ekliti dor yɨu wa rɨkɨnd re onggɨtyam taun orangi yɨbnonj, nokɨm da Tin ɨski de paga wa. ");
INSERT INTO gdr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ajɨ Yesu yikonj re rɨga bobo ɨnyɨny nat, dɨde ket Ti menon yokatonj. ");
INSERT INTO gdr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ɨ re Yesu yikonj de Kaparnaum taun wa Galili eriya wɨngɨrɨnd, ademb de Ton ket rɨga ouyaena eyeneninonj ita Ju rɨga waina wɨram dɨde yɨr opmitena bibɨr wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Sɨ rɨga re kɨd kesa na aena wuwenonj Tina ouyaena gatab, mop nokɨp Tina opureni yɨtkak re danda kɨma na wuwenonj. ");
INSERT INTO gdr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ɨ onggɨt Ju rɨga waina yɨr opmitenapu metɨnd omanda yɨpa Satanamna negɨr kɨlkɨl wɨngawɨnga ma okati rɨga yɨbnonj, ɨ ton ket ukoi ara kɨma obailitonj. ");
INSERT INTO gdr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yaaa! Yaaa! Yesu Najaret tunggam! Nanggamog e Man sowa pɨlɨnd singi yomnyɨt? Rɨngma Man negɨr omna mim sɨn notupinyɨt? Kon wumɨr en yetet Man. Man re Godɨmna yɨnayɨna B'ɨgatet.” ");
INSERT INTO gdr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ajɨ Yesu ɨtemb jɨ negɨr wɨngawɨnga samany yiyowonj da, “Muma kesa ae! Or opende ti pɨlke!” Ɨ ket onggɨt negɨr wɨngawɨngat onggɨt rɨgand gou wa sap yotendonj rɨga wa wɨngɨrɨnd, ngɨrpu ton ket opendonj ti pɨlke, ajɨ ton makwa yɨpa ti kɨpear negɨr yomnawonj. ");
INSERT INTO gdr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Seg ket komkesa rɨga re kɨd kesa na aena wuwenonj, ɨ dɨde ket towalenggyam towalenggyam b'arkena wuwenonj da, “Nangga yɨtkak e jɨ? Ton jɨjab kɨma dɨde danda kɨma e negɨr kɨlkɨl wɨngawɨnga yingau, ɨ ton ket openj.” ");
INSERT INTO gdr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ɨ ket Yesum gatab yɨdɨr yɨt re kea warabag auka yikenonj komkesa wuswus tungg nata. ");
INSERT INTO gdr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ɨ Yesu ket Ju rɨga waina yɨr opmitenapu met yɨraronj, dɨde ket yikonj Simonɨmna met wa. Ɨ Simonɨmna konggayam jeam re omanda ukoi juwar kɨma wɨbnonj. Sɨ rɨgap ket Yesund wumɨr yomno ti gatab. ");
INSERT INTO gdr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Sɨ Yesu ti wusɨnd onyitonj dɨde ket samany yɨt kɨma juwar weaukenawonj, sɨ ket juwarɨt tin wɨraronj. Ɨ ton ket odenja utnyitonj, ɨ ton ket Yesu dɨde Ton kɨma meni rɨga yɨm akainonj. ");
INSERT INTO gdr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ɨ re lom ipanjɨka yikonj, rɨgap eyento komkesa b'engabenga wɨp kopa kɨma rɨga Yesum pɨlwa. Sɨ Ton yɨpayɨpa kopa rɨga wa pɨlɨnd yɨm aramiteninonj, ɨ ket kea ten esakenjinonj. ");
INSERT INTO gdr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ɨ kea kwa negɨr wɨngawɨnga todaka opekto jogjog rɨga wa pɨlke odede ukoi ara kɨma da, “Man re Godɨmna B'ɨga et.” Ajɨ Ton ten samany eyowinonj dɨde ten eswanginonj yɨt opurenam, nokɨp ton wumɨr na da Ton re Kerisote. ");
INSERT INTO gdr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ɨ re ket yɨsparonj, Yesu taun ke opendonj dɨde yikonj tintawar wa. Ɨ re rɨga bobop Tin oraka yiyeno, ton kea Tin yodaro, ngɨrpu ton ket Yesund yogoko da, “Goro sɨn nɨtrarinɨm!” ");
INSERT INTO gdr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ajɨ Yesu mɨra amninonj da, “Kon b'ogla God ma pumb tungg gatab God ma b'ogɨl yɨrkokar bage yɨt pɨtapɨta omnena iyenyɨn deta kwa nɨnda taun nata, mop nokɨp God onggɨt rɨl mapenaemb Ken nɨtmɨkitonj.” ");
INSERT INTO gdr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Sɨ Ton ket kea God ma b'ogɨl yɨrkokar bage yɨt pɨtapɨta omnena yiyenonj Ju rɨga waina yɨr opmitenapu met nata komkesa Yuda eriya wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ɨ yɨpa wɨnɨnd re rɨga bobo Godɨmna yɨtkak utkundeno Yesum pɨlke, ton pɨpmet b'ɨsatena kɨma Yesund yɨwatɨnto. Sɨ Ton re onyiti na yɨbnonj Genesaret sɨpa yurund. ");
INSERT INTO gdr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ɨ Ton nɨmog gɨga yɨr angonj rɨna re sɨpa yurund gɨl wa ɨsonati ebnonda. Ajɨ kabum ɨwɨka rɨgap kea onggɨt gɨga ke gɨl ɨpkɨto dɨde ket ton gɨr ɨseka nat wekenonj. ");
INSERT INTO gdr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ɨ Yesu yɨpa gɨga kumb wa angitonj, ɨt re Simonɨmna gɨga. Sɨ Ton ket Simonɨnd yerkitonj gɨl ke gɨga ɨsonatam sobijog ngai de nyɨ wa. Ɨ re rɨgap gɨga yɨsonato nyɨ wa, Yesu ket omitonj gɨga kumbɨnd, ɨ ɨngkenaemb ket Ton rɨga bobo auyaeninonj. ");
INSERT INTO gdr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Re ket Ton ouyaena seg awonj, Simonɨnd yomnonj da, “Gɨga yiya kunɨnkunɨn kubol wa, ɨ amaemb de wɨn ket kabum ɨwɨkam gɨr tekoukindam!” ");
INSERT INTO gdr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sɨ Simon mɨra yomnonj da, “Ukoyam! Sɨn ke pop b'asoindam sɨwɨny pɨnpɨn, ajɨ makwa ngai nangga na ewɨkindam. Ajɨ ke man mindenyɨt, sɨ b'ogɨl e kon opima gɨr tekoukinyɨn.” ");
INSERT INTO gdr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Re ket ton Yesumna yɨt rɨrɨrɨnd wɨko yomnɨko, sɨ ton ket ma yɨpa kɨma kabum na ewɨkto opimemb da jogjog, ngɨrpu towaina gɨr ɨpka wuwenonj. ");
INSERT INTO gdr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sɨ ton ket yɨm ke ara eauto towa wɨkomadwar yepiya re yɨpa gɨgand wekenonj da, “Tuyɨm yɨm okawam!” Seg ton ket tuwonj, ɨ ket nɨmognɨmog gɨga yɨndangɨr amno, sɨ osiemb re gɨga kea ɨtwa ekonda momta iuyongam. ");
INSERT INTO gdr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ɨ re Simon Petro onggɨtyam mɨle yɨr yongonj, ton ket sap otendonj Yesum wɨpɨnd ukoi b'ɨsnawa kɨma, ɨ yindonj da, “Yonggyam! Ewaikite kor pɨlke! Nokɨp kon re negɨr mɨle rɨga en.” ");
INSERT INTO gdr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Mop nokɨp ton dɨde komkesa rɨga yana kɨma re ton yɨpand wɨko yomnɨko kabum ɨwɨkam, kɨd kesa na auto onggɨtyam jogjog kabum map rɨna re ton ewɨkto. ");
INSERT INTO gdr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ɨ Jebedaimna b'ɨga Yakobo ake Yoan yesi re Simonɨmna wɨkomad, toda kwa odede yɨpa wɨp na kɨd kesa awonda. Sɨ ket Yesu Simonɨnd yomnonj da, “Goro moga tawɨm! Man yu bibɨr ke taet ra ket rɨga ɨwɨkayam et.” ");
INSERT INTO gdr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Seg ton ket gɨga gɨl wa esoneno, dɨde ket komkesa gasa erarkɨto, ngɨrpu Yesund yɨmta yundoko. ");
INSERT INTO gdr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ɨ re Yesu yɨpa taunɨnd yɨbnonj, adea de yɨpa leprosi kopa ke ɨkangɨndi rɨga yɨbnonj. Ɨ re ton Yesund yɨr yongonj, ton as eamanta kɨma sap otendonj Ti wɨpɨnd, dɨde ket Tin ɨl yongkonj da, “Yonggyam! Ra man singi taet, Man rɨrɨr e ken kɨlkɨp kesa notɨnyɨt.” ");
INSERT INTO gdr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ɨ Yesu ket Tina yɨm b'ɨtnɨkonj dɨde ket tin yesopayonj odede yɨt kɨma da, “Kon ɨta singi. Kɨlkɨp kesa ae!” Sɨ odenja ɨt ra leprosit tin yɨraronj. ");
INSERT INTO gdr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ɨ Ton ket tin yingawonj da, “Goro yena wumɨr omnɨm! Ajɨ dɨmdɨm na meket moina jɨ ouyawam de yɨna sɨ rɨgam pɨlwa. Ra ton ɨmjas dor da kea man ɨmɨnjog kɨlkɨp kesa aet, man ket Godɨm sɨ gasa tanggɨkinyɨt dor, ɨ eyinyɨt de yɨna sɨ rɨgam pɨlwa sɨ omnɨkam Mosemna b'ingawa yɨt rɨrɨrɨnd. Nokɨm da ɨdenat ton mɨtɨmjas rɨga wa wɨpɨnd da, ‘Man kea b'ɨsakenjɨt dɨde kɨlkɨp kesa aet.’” ");
INSERT INTO gdr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ajɨ Yesum gatab yɨdɨr yɨt re kea b'usaya warabag auka yikenonj. Ɨ ket jogjog rɨga bobo yɨpand wuwenonj Ti pɨlwa yɨt utkundam dɨde towaina kopa ke ɨsakendam. ");
INSERT INTO gdr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ajɨ Yesu kea towa pɨlke ewaikenenonj dɨde yikenenonj rɨga kesa tungg nata, ɨ ket ademb ta yɨr opmitenenonj. ");
INSERT INTO gdr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ɨ yɨpa wɨnɨnd re Yesu rɨga ouyaena eyeninonj, Parisai rɨga dɨde gog yɨt ouyaena rɨga omanda omnɨki wekenonj yepiya re wuwenonj komkesa tungg ke Galili eriya wɨngɨrɨnd ɨ Yuda eriya ke ɨ Yerusalem taun ke. Sɨ Yonggyamɨmna danda kea dɨkɨnd Yesum pɨlɨnd yɨbnonj kopa rɨga ɨsakendam. ");
INSERT INTO gdr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ɨ onggɨt wɨnɨnd nɨnda rɨgap yɨpa dɨmɨr kopa rɨga tɨtɨnd iyo, ɨ ton ket nya oraka eyento tin met wɨngɨr wa ɨgaram dɨde oramitam Yesum wɨpɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ɨ re ket maka re nya yodaro tin ɨgaram wɨngɨr wa rɨga bobo map, sɨ ton ket bau ke tɨt na ɨjo, ɨ wuwonj de ket met papkak kumb wa, ngɨrpu ton ket tumɨnd ouki gasa yotorko. Seg ton ket onggɨt borand tin inka yiyo tɨt kɨma de Yesum tunkɨpjog wa, ɨ ket yoramito Ti wɨpɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ɨ re Yesu towaina gar ke utkunda yɨr yongonj, Ton yomnonj da, “Kor rɨga! Moina negɨr mɨle kemb awɨr auranj.” ");
INSERT INTO gdr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ɨ re Ju rɨga waina gog ouyaena rɨga dɨde Parisai rɨgap onggɨtyam yɨt utkundo, ton kea yɨt b'iklawa yiyeno da, “Yete jɨ rɨga ɨt re Godɨnd yɨsadreny? Yete rɨrɨr e negɨr mɨle awɨr omnɨkam? Ajɨ Godta tinta yɨpaina.” ");
INSERT INTO gdr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Sɨ Yesu re kea wumɨr yokatonj towaina b'iklawa yɨt gatab, ɨ Ton ket ten amninonj da, “Nangga pae wɨn yɨt b'iklawa yiyenya waina garɨnd? ");
INSERT INTO gdr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Rɨnte yɨt opulitam wewa ainy ɨt re da, ‘Mor negɨr mɨle kemb awɨr auranj' o da, ‘Utnyite, ɨ menon yokate'? ");
INSERT INTO gdr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ajɨ Kon yɨpa gasa e omnɨken wen ouyawam da Rɨgamna B'ɨgam ɨta Ti danda gowukoyɨnd negɨr mɨle awɨr omnɨkam.” Ɨ Ton ket ɨtemb rɨgand yomnonj yet re dɨmɨr kopa kɨma yɨbnonj da, “Kon motɨnyɨn. Utnyite, moina tɨt yurowate, ɨ moina met wa meke!” ");
INSERT INTO gdr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Seg re ket odenja ton utnyitonj towa wɨpɨnd, ɨ tɨt yurowatonj rɨkɨnd re ton yutungi yɨbnonj, ɨ ket yiwatonj tina met wa Godɨnd esourena kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Sɨ komkesa rɨga kea wɨnga kesa auto, ɨ ket Godɨnd esourena yiyeno, ɨ dɨde ukoi mogat kea ten akasinonj. Sɨ ton ket endento da, “Yu men kɨd kesa kɨma e yiyata b'ogɨl mɨle yɨr yongu.” ");
INSERT INTO gdr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ɨ onggɨt kak ke ket Yesu opendonj, Ton kea yɨpa teks imdayam rɨga omiti yɨr yongonj teks imdapu metɨnd, nyɨ da Lebi. Sɨ Yesu ket tin yomnonj da, “Yɨmta nundoke!” ");
INSERT INTO gdr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ngɨrpu ton ket utnyitonj, ɨ ket komkesa gasa erarkinonj, dɨde ket Yesund yɨmta yundokonj. ");
INSERT INTO gdr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Seg Lebi ket ukoi owou yomnɨkonj Yesu kɨma diyamdiyam awowɨm tina metɨnd. Sɨ ma yɨpa kɨma teks imdayam rɨga bobo ɨ kwa nɨnda rɨga yɨpand diyam awowɨnd wekenonj Yesu dɨde Tina b'auyaena rɨga kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ajɨ re Parisai rɨga dɨde towa gatab ke gog ouyaena rɨgap onggɨtyam mɨle yɨr yongo, ton kea Yesumna b'auyaena rɨga ugagto dɨde egekitto da, “Nangga mop paim wɨn diyam aindam dɨde nyɨ anaikindam yɨpand teks imdayam dɨde negɨr mɨleyam kɨma?” ");
INSERT INTO gdr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Seg ket Yesu ten mɨra amninonj da, “Ma kopa kesa rɨgapim dokta singi omnyi, ajɨ kopa kɨma rɨgapim. ");
INSERT INTO gdr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kon ma negɨr kesa dɨmdɨmjog rɨga na tatupinond engendam negɨr mɨlem pɨlke de Godɨm pɨlwa, ajɨ Kon ara emokam tatupinond re negɨr mɨle kɨma rɨga na towanɨm engendam negɨr mɨlem pɨlke de Godɨm pɨlwa.” ");
INSERT INTO gdr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Seg ton ket Yesund yomno da, “Yoanɨmna b'auyaena rɨgap opima ita wɨnɨnd owou uwabɨka dɨde yɨr opmita wɨn akatenenanj, ɨ toda Parisai rɨga waina b'auyaena rɨga kwa odede ima aukenenanj. Ajɨ Moina b'auyaena rɨga wuweny re owou dɨde onaika nasim.” ");
INSERT INTO gdr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sɨ Yesu ket ten amninonj da, “Rɨngma, wɨn rɨrɨr im sisɨl kongga kɨma rɨgamna rɨgawar owou uwabɨka wɨn okatam tamnindam, ra ton sisɨl kongga kɨma rɨga dɨkɨnda towa wɨngɨrɨnd ɨbɨm? ");
INSERT INTO gdr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ajɨ ɨta wɨn ik dem, ra sisɨl kongga kɨma rɨgat tewaikis dem towa pɨlke, sɨ onggɨt wɨn nasimemb dem ton ket owou uwabɨka wɨn okatenyi dem.” ");
INSERT INTO gdr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ɨ Ton ket towa tendam yɨt usekawonj da, “Makwa yɨpa rɨgat ɨta sisɨl kobɨrgɨm ɨpɨk sobijog kɨb okatam dɨde onggɨt sisɨl kobɨrgɨm kɨb ke kesam kobɨrgɨm pasi omɨny. Ra ton odede omnɨk, ton ɨta ɨnyowɨk sisɨl kobɨrgɨm. Ajɨ onggɨtyam sisɨl kobɨrgɨm kɨb re ma ɨta b'itɨnkis onggɨt kesam kobɨrgɨmɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ɨ dɨde makwa yɨpa rɨgat ɨta sisɨl ɨk tangjɨkiny kesam b'angga gɨm ke omnɨki ɨk ga wa. Mop nokɨp sisɨl ɨk ɨta ɨnɨka ik, ajɨ kesam b'angga gɨm ke omnɨki ɨk ga ra ma ɨta warabag tawɨk. Sɨ ra ton odede omnɨk, onggɨt sisɨl ɨkɨt opima onggɨtyam kesam b'angga gɨm ke omnɨki ɨk ga temkiny. Sɨ ɨk ket tokombarɨk, ɨ onggɨtyam b'angga gɨm ke omnɨki ɨk ga kwa da opima negɨr taukanj. ");
INSERT INTO gdr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ajɨ ton b'ogla sisɨl ɨk tangjɨkiny de sisɨl b'angga gɨm ke omnɨki ɨk ga wa. ");
INSERT INTO gdr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Sɨ makwa yɨpa rɨgat ɨta singi tainy sisɨl ɨk onayam kesam ɨk onai seg ke, mop nokɨp ton ɨja e indeny da, ‘Kesamyam re otomanti e.’” ");
INSERT INTO gdr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ɨ yɨpa Ju rɨga waina wɨram dɨde yɨr opmitena bibɨrɨnd Yesu Tina b'auyaena rɨga kɨma wit sopapu yuru nata yikonj. Ɨ Tina b'auyaena rɨgap kea wit kolkak utouka eyento dɨde yɨm ke ɨimɨka eyento gɨm uwakurkam, ngɨrpu ton wit kɨp auto. ");
INSERT INTO gdr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sɨ nɨnda Parisai rɨga endento da, “Nangga pae wɨn onggɨtyam mɨle yomnɨkya rɨnte re ma yiyag e omnɨkam meraina wɨram dɨde yɨr opmitena bibɨrɨnd?” ");
INSERT INTO gdr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ɨ Yesu ten mɨra amninonj da, “Ma ke wɨn yɨna peba yogenkonda onggɨtyam yɨtkak gatab rɨna re Dawid Mosemna gog yɨt yerbekonj, re ton dɨde ton kɨma meni rɨga owoupa wekenonj. ");
INSERT INTO gdr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Sɨ rɨdede na ton b'ɨgaronj Godɨmna yɨnamet wa? Ɨ rɨdede na ton yɨna sana awinonj rɨna re gog yɨbnonj komkesa rɨga wanɨm owowɨm ajɨ yɨna sɨ rɨga wa nena ma owou? Ɨ kwa daka rɨdede na ton onggɨtyam yɨna sana nɨnda ton kɨma menonam rɨga wa akainonj?” ");
INSERT INTO gdr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Dɨde ket Yesu ten amninonj da, “Rɨgamna B'ɨga re Ju rɨga waina wɨram dɨde yɨr opmitena bibɨrɨm Yonggyam e.” ");
INSERT INTO gdr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ɨ kwa yɨpa Ju rɨga waina wɨram dɨde yɨr opmitena bibɨrɨnd Yesu Ju rɨga waina yɨr opmitenapu met wa b'ɨgaronj, dɨde ket rɨga auyaeninonj. Ajɨ omanda yɨpa yɨmjog yɨm b'ɨkɨki kopa rɨga yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ajɨ Ju rɨga waina gog ouyaena rɨga dɨde Parisai rɨgap Tin wuswus yɨr ɨpka yiyeno da, “Ɨta yama dor meraina wɨram dɨde yɨr opmitena bibɨrɨnd Ton onggɨt kopa rɨgand ɨsakenj.” Nokɨm da ɨdenat ton rɨl odarai Yesund kot wa oramitam. ");
INSERT INTO gdr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sɨ Yesu kea wumɨr awonj towaina nony menamena, ajɨ Ton yomnonj onggɨt yɨm b'ɨkɨki kopa rɨgand da, “Utnyite! Ɨ onyite de wɨp wa!” Ngɨrpu ton ket utnyitonj dɨde onyitonj. ");
INSERT INTO gdr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ɨ Yesu ket ten amninonj da, “Kon mobe wen rarkisinɨn. Rɨngma, meraina wɨram dɨde yɨr opmitena bibɨrɨnd nanggamog gog e b'ogɨljog tainy, gasa b'ogɨl omnɨkam o mɨnda negɨr omnɨkam? Rɨngma, yɨrkokar okawam o mɨnda yɨrkokar negɨr omnam?” ");
INSERT INTO gdr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ɨ Ton ket komkesa rɨga yɨrɨk unjomkena eyeninonj, ɨ ket kopa rɨgand yomnonj da, “Moina yɨm b'ɨtnɨke!” Sɨ ton ket tina yɨm b'ɨtnɨkonj dɨde ket ɨtemb tina yɨm kupkakupka b'ɨsakendonj ɨja na ɨt re yɨpa tab yɨm re dɨde. ");
INSERT INTO gdr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ajɨ gog ouyaena rɨga dɨde Parisai rɨga ma sobijog na soro aukɨto, dɨde ket towalenggyam towalenggyam yɨt ɨglenena yiyeno nangga mɨle e ton b'ogla omnɨki Yesum pɨlɨnd Tin negɨr omnam. ");
INSERT INTO gdr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ɨ onggɨt wɨn wɨngɨrɨnd Yesu yikonj yɨpa dor wa yɨr opmitam, ɨ ademb de Ton sɨwɨny pɨnpɨn Godɨm pɨlwa yɨr opmitenonj ngɨrpu yɨsparonj. ");
INSERT INTO gdr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ɨ re bibɨr pɨtapɨta auka yikonj, Yesu Tina b'auyaena rɨga ara emokinonj, towa wɨngɨrɨnd twelp (12) rɨga abagɨkinonj, ɨ kwa ten nyɨ aekinonj da Tina ɨtmɨkitijog rɨga. ");
INSERT INTO gdr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon ya mana re Yesu kwa yɨpa nyɨ yokawonj Petro, ɨ ti yɨnggan Andrea, ɨ Yakobo, ɨ Yoan, ɨ Pilip, ɨ Batolomeo, ");
INSERT INTO gdr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ɨ Matayo, ɨ Toma, ɨ Alpayomna b'ɨga Yakobo, ɨ Simon yena re yogenayo Jalas Rɨga Bobo ke, ");
INSERT INTO gdr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ɨ Yakobomna b'ɨga Yudas, ɨ Yudas Iskariyot yet re Yesum tɨb iyoyam awonj. ");
INSERT INTO gdr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ɨ Yesu ket Tina ɨtmɨkitijog rɨga kɨma paga etaeta yikonj. Ɨ re ket Ton ket onyitonj wawa pɨpmetɨnd, ma yɨpa kɨma Tina b'auyaena rɨga bobo na de wekenonj, ɨ dɨde ma sobijog rɨgata rɨgata na wuwenonj komkesa Yuda eriya ke, ɨ Yerusalem taun ke, ɨ dɨde sɨpa gatabɨnd Tiro ake Sidon eriya ke. ");
INSERT INTO gdr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ɨ rɨga wuwenonj re Tina yɨt utkunda mana ɨ dɨde towaina kopa ke ɨsakenda mana. Ɨ kwa yepiya re negɨr kɨlkɨl wɨngawɨnga ke b'ɨdgotnena yokateneno, Yesu kea ten Tina danda ke esakenjinonj. ");
INSERT INTO gdr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ɨ dɨde kwa komkesa rɨgap re kea ɨl ongka yiyeno Tin esopayam, mop nokɨp danda Ti pɨlkena opeka yikenonj dɨde ket kea komkesa esakenjinonj. ");
INSERT INTO gdr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ɨ Yesu Tina b'auyaena rɨga yɨrɨk unjomkeninonj, ɨ yindonj da, “Wɨn b'ogɨl omni rɨga im jɨ yepim re wɨn gasa kesand wekenyɨt, mop nokɨp God ma pumb tungg re wa maemb jɨ. ");
INSERT INTO gdr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Wɨn b'ogɨl omni rɨga im jɨ yepim re yu wɨn owoupand wekenyɨt, mop nokɨp God opima wen ngor tamnɨkiny. Wɨn b'ogɨl omni rɨga im jɨ yepim re yu yii aenindam, mop nokɨp wɨn opima ngongong taenindam dem. ");
INSERT INTO gdr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Wɨn b'ogɨl omni rɨga im jɨ, ra Rɨgamna B'ɨga map rɨgap wen negɨr yɨr ke yɨr tangranj, ɨ kwa ra rɨgap wen kak teaenanj, ɨ wen tesadrenanj, ɨ dɨde waina nyɨ ɨsaya teyenanj negɨr mos pɨla. ");
INSERT INTO gdr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sɨ wɨn b'ogla sam kɨma ngolengole taenindam dɨde sam kɨma b'atrurkenindam onggɨt bibɨrɨnd, mop nokɨp wa opima ukoijog mɨra ebnainy de pumb tungg wa. Mop nokɨp towaina b'uwarɨp odede yɨpa rɨrɨrkɨp nya kena bageyam amnenento. ");
INSERT INTO gdr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ajɨ God ma sake wɨn kɨma yepim re jogjog gasa kɨma wekenyɨt, mop nokɨp wɨn opima sam kɨma wɨmena akatenenindam onggɨt gowukoyɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","God ma sake wɨn kɨma yepim re yu wɨn b'obogɨl ngor auka wuwenyɨt, mop nokɨp wɨn opima owoupa tekenyɨt dem. God ma sake wɨn kɨma yepim re yu ngongong aenindam, mop nokɨp wɨn opima ukoi gar kopa kɨma yii taenindam. ");
INSERT INTO gdr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","God ma sake wɨn kɨma, ra komkesa rɨgap b'ogɨl yɨt nena tapurenanj wa gatab, mop nokɨp towaina b'uwar odede yɨpa rɨrɨr nya kena b'anygɨnena bageyam amnenento. ");
INSERT INTO gdr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ajɨ kon wen tamninyɨn yepim re ken nutkundenya, wɨn b'ogla singi teyenindam waina geja rɨga, ɨ wɨn b'ogla towa b'ogɨl mɨle tamnɨkaenenindam yepim re wen singi kesa amnenanj. ");
INSERT INTO gdr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ɨ wɨn b'ogla ten b'ogɨl tamnenindam yepim re wen sake amnɨkanj, ɨ wɨn b'ogla yɨr topmitenindam towa gatab yepim re wen negɨr yɨt ke amnenanj. ");
INSERT INTO gdr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ɨ ra yɨpa rɨgat naska yɨpa tab anakakɨnd mɨtpokis, sɨ man b'ogla onggɨt rɨgam ɨjgenaet kwa yɨpa tab ɨpokitam. Ɨ ra yɨpa rɨgat moina bau ke kobɨrgɨm okas, sɨ man goro tin ɨswanget moina wɨngɨr ke kobɨrgɨm okatam. ");
INSERT INTO gdr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ɨ man b'ogla tagoninyɨt komkesa rɨga wa yepiya ra mɨtgekisi, ɨ yet ra moina gasa takasiny, man goro omnɨm da kor gasa nɨtendainyɨt. ");
INSERT INTO gdr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ɨ wɨn ɨja na rɨga wa gasa tamnɨkaenindam odede rɨngmim re wɨn singi aenindam nangga im ra rɨgap wa tamnɨkauranj. ");
INSERT INTO gdr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ɨ ra wɨn rɨga singi teyenindam yepim re wen singi eyenanj, sɨ wɨn nangga b'ogɨl ɨsnawa e okasya onggɨt waina singi b'iyena mɨle ke? Makwa ɨta, mop nokɨp negɨr mɨle rɨgap toda kwa opima rɨga singi eyenanj yepim re ten singi eyenanj. ");
INSERT INTO gdr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ɨ kwa ra wɨn rɨga wa b'ogɨl wɨko tamnɨkaenenindam yepim re wa b'ogɨl wɨko amnɨkenenauranj, sɨ rɨngma, wɨn rɨrɨr e b'ogɨl ɨsnawa okasya onggɨt waina b'ogɨl wɨko omnɨka mɨle ke? Ma rɨrɨr e, negɨr mɨle rɨgap toda kwa opima odede mɨle amnɨkenenanj. ");
INSERT INTO gdr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ɨ ra wɨn rɨga wa wulkɨp tagonindam ya pɨlkaim ra wɨn singi da ton kwa mɨra wa tetendauranj, sɨ rɨngma, wɨn rɨrɨr e b'ogɨl ɨsnawa okasya onggɨt waina mɨle ke? Ma rɨrɨr e, negɨr mɨle rɨgap toda kwa opima nɨnda negɨr mɨle rɨga wa wulkɨp agonenenauranj, nokɨm da ɨdenat toda kwa mɨra takatenanj onggɨt ogoni wulkɨp rɨrɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ajɨ wɨn waina geja rɨga singi teyenindam, ɨ towa b'ogɨl wɨko tamnɨkaenenindam, ɨ kwa towa wulkɨp tagonenenindam ajɨ goro odede nony menamena kɨma da, ‘Ton opima amaya mɨra sowa nɨtendauranj.’ Ra wɨn odede mɨle tamnɨkenindam, waina mɨra ra ukoijog e tainy dem, ɨ wɨn kwa Pumbjog Godɨmna b'ɨga im taukindam. Mop nokɨp Ton re kear b'amnena Rɨga e towanɨm yepim re maka Tin sɨteket yɨt yomnɨkenenyi dɨde kwa yepim re negɨrjog mɨle amnɨkenenanj. ");
INSERT INTO gdr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Sɨ wɨn b'ogla kear b'amnena rɨga taukindam odede yɨpa wɨp ɨt re kear b'amnena Rɨga, wa B'u re dɨde. ");
INSERT INTO gdr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ɨ wɨn goro rɨga wa pɨlɨnd b'ɨsagɨka mɨle tamnɨkina, sɨ wɨda makwa ɨta b'ɨsagɨka okatenya dem. Ɨ wɨn goro rɨga negɨr ma b'ɨsagɨkand taramitenina, sɨ wɨda makwa ɨta negɨr ma b'ɨsagɨka okatenya dem. Ɨ wɨn b'ogla nɨnda rɨga wa negɨr mɨle awɨr tamnɨkaenindam rɨnsim re wa amnɨkauranj, sɨ God daka opima waina negɨr mɨle awɨr tamnɨkaeniny. ");
INSERT INTO gdr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Wɨn b'ogla tagonindam, sɨ God kwa opima wa tagoniny. Mop nokɨp God opima wanɨm mɨra ɨtendam odede yɨpa wɨp tondon wa takatenainy rɨja na re wɨn rɨga wa tondon akatenautondam. Sɨ Ton ma onggɨtyam tondon rɨrɨr nena im wa tagoniny, ajɨ Ton opima onggɨtyam tondon rɨrɨrɨnd yɨndangɨr tamnɨkiny, ɨ temlandeniny, ɨ tegiyatneniny, ɨ dɨde taikɨnsiny tu ɨsangendam. Seg Ton ket teyeniny wa pɨlwa dɨde wa yɨm kumbɨnd taramkiny.” ");
INSERT INTO gdr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ɨ Yesu kwa yɨpa tendam yɨt towa usekawonj da, “Ma, rɨrɨr e yɨrdɨdɨ rɨgat yɨrdɨdɨ rɨgand wɨp yii menonɨm? Sɨ rɨngma, ma osiya ton nɨmognɨmog yɨpand sap totenjya de kip bora wa? ");
INSERT INTO gdr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ɨ b'auyaena b'ɨga re ma ɨta tina ouyaena rɨgand ɨgwanjis pumb wa. Ajɨ ra ton komkesa tina ouyaena kupkakupka takasiny, ton ɨja e ket wumɨr okas tina ouyaena rɨga re dɨde. ");
INSERT INTO gdr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nangga pae man yɨr pɨpla yɨr yiyenyɨt moina rɨgamna yɨrkɨpɨnd, ajɨ kwa nangga pae man maka b'obogɨl wumɨr yokatenyɨt wulpas gatab moinajog yɨrkɨpɨnd? ");
INSERT INTO gdr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Rada man ma ɨta molenggyam ɨtemb wulpas yɨr ongong yiyenyɨt rɨnte re yɨbɨm moinajog yɨrkɨpɨnd, sɨ rɨngma, rɨrɨr e man mor rɨgand odede omnyɨt da, ‘Kor rɨga! Mabe kon yɨr pɨpla mewaikitawɨn moina yɨrkɨp ke'? Sɨ man re gɨm ke b'ogɨl ajɨ ngor wa negɨr mɨle rɨga et. Sɨ man naska moina yɨrkɨp ke wulpas yewaikite! Ɨ ɨngkaemb ket man onggɨtyam yɨr pɨpla pɨtakɨpɨnd yɨr onget rɨnte re yɨbɨm mor rɨgamna yɨrkɨpɨnd, ɨ ket man ɨtemb yɨr pɨpla ewaikitaet mor rɨgamna yɨrkɨp ke. ");
INSERT INTO gdr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ɨ b'ogɨl wul nanggɨt ma opima negɨr kɨp tejagɨkiny, ɨ toda kwa negɨr wul nanggɨt ma opima b'ogɨl kɨp tejagɨkiny. ");
INSERT INTO gdr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yɨpa yɨpa wul nangg ongwatam re towainajog ɨjagɨki kɨp kaim. Ɨ rɨgap re ma wanja nangg kaim eakɨkenanj pig kɨp, ɨ kwa ma wika nangg kaim eakɨkenenanj greip kɨp. ");
INSERT INTO gdr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ɨ b'ogɨl rɨgat b'ogɨljog gasa im angapeneniny tina garɨnd. Ɨ ɨngkaemb ton ket b'ogɨl mɨle pɨta wa apendeniny. Ɨ negɨr rɨgat daka tina ongapi negɨr gasam pɨlke negɨr mɨle im pɨta wa apendeniny. Mop nokɨp rɨgat tina tugɨm ke yɨt apureniny re tina garɨnd yɨndangɨr auki nony menamena kaim. ");
INSERT INTO gdr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ɨ wɨn ɨta nyɨ nuwatenenya da ‘Yonggyam, Yonggyam,’ ajɨ nangga paim wɨn maka amnɨkenindam nangga im re Kon nindenenyɨn omnɨkam? ");
INSERT INTO gdr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ɨ Kon wanɨm tendam yɨt ke tauyaenyɨn onggɨt rɨga gatab yet ra Kor pɨlwa ik ɨ Koina yɨtkak tutkundeniny dɨde omnɨkand b'itngaeny onggɨt yɨtkak rɨrɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Sɨ ton re odede met oranga rɨga e yete re ngortod wa kip euka eyeniny rorte emkam, ɨ danda kɨma rorte ɨtot eyeniny, ɨ dɨde met oranga yiyeny onggɨt danda rorte kumbɨnd. Sɨ ra ket ukoi ngɨwɨr ik dɨde ngɨwɨrɨt met uwongneny, ajɨ makwa ɨta ɨmnɨneny, mop nokɨp ɨtemb re b'obogɨl orangi met e. ");
INSERT INTO gdr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ajɨ yet re Koina yɨtkak utkundeniny ajɨ maka ra b'itngaeny onggɨt yɨtkak rɨrɨrɨnd, ton re odede met oranga rɨga e yete re bab tumɨnd kip euka eyeniny rorte emkam, ɨ danda kesa rorte ɨtot eyeniny, ɨ dɨde ket onggɨt kumbɨnd met oranga yiyeny. Sɨ ra ngɨwɨrɨt met uwongneny, odenja ket tosmulis dɨde ket ma sobijog e met tonygɨk.” ");
INSERT INTO gdr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ɨ re Yesu Tina komkesa opurena undwasinonj utkunda rɨga wa pɨlwa, onggɨt kak ke Ton Kaparnaum taun wa yikonj. ");
INSERT INTO gdr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ɨ ademb de yɨpa wan andred (100) Roma geja rɨga mopyam yɨbnonj. Ɨ yɨpa tina nony ɨjai wɨko rɨga re kopa na yɨbnonj momta uj. ");
INSERT INTO gdr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Sɨ re ket ton Yesum gatab yɨdɨr yɨt utkundonj, ton ket nɨnda Ju rɨga waina elda rɨga etmɨkisinonj Yesum pɨlwa odede erkena kɨma da, “Rɨngma ngai Man metket, ɨ koina wɨko rɨga kopa ke ɨsakenjɨt.” ");
INSERT INTO gdr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ɨ re ket ton wuwonj Yesum pɨlwa, ton kea danda kɨma Tin yɨgekito da, “Ton meraina Ju yɨtam rɨga opima singi eyeniny, dɨde tonɨt kwa meranɨm yɨr opmitenapu met yorangonj. Sɨ onggɨt paemb ton re ɨmɨnjog rɨga e yena ra Man yɨm okaet odede ɨsakenda mɨle ke.” ");
INSERT INTO gdr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Sɨ Yesu ket ton kɨma yikonj onggɨt geja rɨga mopyamɨmna met wa. Sɨ Yesu re ma pɨn na awonj tina met ke, ɨ onggɨt geja rɨga mopyamɨt daka nɨnda ti rɨgawar etmɨkisinonj Ti pɨlwa, omnam da, “Yonggyam! Goro nony bebɨg tawɨm menonɨm kor met wa, nokɨp kon ma odede rɨrɨrkɨpjog rɨga en Men yɨt omnam da, 'Man b'ɨtgaret koina met wɨngɨr wa!’ ");
INSERT INTO gdr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Sɨ onggɨt paemb kon kolenggyam b'angwasɨn da kon re ma rɨrɨrjog rɨga en menonɨm mor pɨlwa. Ajɨ man yɨt nena yopulite, ɨ ɨdenat koina wɨko rɨga b'ɨtɨsakenj. ");
INSERT INTO gdr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mop nokɨp koda re yɨpa juwai kɨma rɨga wɨra nate nɨbnyɨn dɨde kwa daka kor wɨrand opima geja rɨga nɨbnainy. Sɨ ra kon yɨpa geja rɨgand ingaen da ‘Meke,’ sɨ ton ɨta yik, ɨ ra kon kwa yɨpa rɨgand ingaen da ‘Metkɨm,’ sɨ ton ɨta ik. Ɨ kwa ra kon yɨpa koina wɨko rɨgand ingaen da ‘Man ɨtemb gasa yomnɨke,’ sɨ ton ɨta omnɨk.” ");
INSERT INTO gdr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ɨ re Yesu onggɨtyam yɨt utkundonj, Ton kɨd kesa awonj ti gatab. Ɨ ket wɨp engendonj ukoi rɨga bobo wa pɨlwa yepiya re Tin yɨmta yundoko dɨde ket amninonj da, “Kon wen tamninyɨn da Kon maike ya pɨlnat odede ɨmɨnjog gar ke utkunda rɨga yodarond Israel rɨga wa wɨngɨrɨnd.” ");
INSERT INTO gdr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ɨ re onggɨt geja rɨga mopyamɨmna ɨtmɨkiti rɨga ɨtekto de met wa, ton ket onggɨt kopa kɨma wɨko rɨgand yodaro re kea kwa tina pɨpmet wa ɨtendonj. ");
INSERT INTO gdr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ɨ onggɨt kak ke re Yesu yikonj de yɨpa taun wa ogenaya da Nain, sɨ Tina b'auyaena rɨga dɨde ukoi rɨga bobo re kea Ton kɨma yɨpand wuwonj. ");
INSERT INTO gdr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ɨ re Ton ket onggɨt taun mora wuswus wa awonj, rɨgap yɨpa uj b'ɨga tɨtɨnd iyo ɨ taun mora ke yopendo. Ɨtemb uj b'ɨga re ti mogɨm lesmɨta b'ɨga na, ɨ ti mog re mik kongga na. Ɨ onggɨt taun ke ukoi rɨga bobo kea dɨkɨnd ton kɨma ikonj. ");
INSERT INTO gdr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ɨ re Yonggyam Yesu tin yɨr wongonj, Ton ma sobijog na tin kear womnonj. Ɨ ket tin womnonj da, “Goro yii tainɨm!” ");
INSERT INTO gdr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Seg Ton ket wus wa yikonj, ɨ ket ɨtemb uj rɨga iyenapu tɨt yesopayonj, sɨ tɨt iyena rɨgap owɨnkɨto ngɨrpu Ton uj b'ɨgand yomnonj da, “Kewar b'ɨga! Kon men motɨnyɨn da Utnyite!” ");
INSERT INTO gdr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ɨ uj b'ɨga ket omitonj, dɨde ket yɨt opurena b'atomonj. Seg Yesu ket b'ɨga ti mogɨm wokawonj. ");
INSERT INTO gdr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sɨ komkesa rɨgap moga na yokato, ɨ Godɨnd yesoureno odede yɨt kɨma da, “Ukoi bageyam kea pɨta ainy mera wɨngɨrɨnd.” Dɨde kwa endento da, “God kea Tina rɨga yɨr engendam tatupiny.” ");
INSERT INTO gdr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ɨ ɨtemb Yesum gatab yɨdɨr yɨt re kea warabag auka yikenonj kupka Yuda eriya wɨngɨrɨnd dɨde komkesa wuswus eriya nata. ");
INSERT INTO gdr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Sɨ re Yoanɨmna b'auyaena rɨgap Yoanɨnd wumɨr yomno komkesa onggɨtyam mɨle gatab, Yoan ket nɨmog rɨga ara emokonj tina b'auyaena rɨga wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ɨ ton ket ten etmɨkitonj Yonggyam Yesum pɨlwa odede ɨgekitam da, “Yesu! Ma man Kerisotet yet ra Godɨm pɨlke ik? O mɨnda sɨn yɨpa b'enga rɨga na yɨr ungauku?” ");
INSERT INTO gdr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sɨ onggɨt nɨmog rɨgap ekonda Yesum pɨlwa, ɨ ket Tin yomnonda da, “Baptiso Yoante sɨn nɨtmɨkis mor pɨlwa men ɨgekitam da, ‘Yesu! Ma man Kerisotet yet ra Godɨm pɨlke ik? O mɨnda sɨn yɨpa b'enga rɨga na yɨr ungauku?’” ");
INSERT INTO gdr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ɨ onggɨt wɨnɨnd re ton Yesund yɨt yomnonda, odedend Ton ket jogjog rɨga esakenjinonj b'engabenga wɨp kopa ke, ɨ jogjog negɨr wɨngawɨnga eaukeninonj negɨr wɨngawɨnga ke okati rɨga wa pɨlke, ɨ dɨde Ton ket yɨrdɨdɨ rɨga yɨr epangkinonj. ");
INSERT INTO gdr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ɨ Yesu ket ten mɨra amninonj da, “Wɨn eka Yoanɨm pɨlwa! Ɨ tin wumɨr omnenya nangga na re wɨn yɨr anginya dɨde utkundenya, odede opi re da yɨrdɨdɨ rɨga yɨr epangkanj, ɨ gomgom rɨga menon akatenanj, ɨ leprosi kopa rɨga kɨlkɨp kesa aukanj, ɨ yɨpya dumdum rɨga utkundenanj, ɨ uj rɨga utnɨkanj, ɨ dɨde God ma b'ogɨl yɨrkokar bage yɨt pɨtapɨta auka yikeny gasa kesa rɨga wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Sɨ God ma b'ogɨl ɨta ton kɨma yet ra onggɨtyam Koina mɨle gatab yɨt tutkunj ɨ ɨngkaemb ket ton maka sap totenj gar ke utkunda kesa mɨle wa.” ");
INSERT INTO gdr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ɨ re Yoanɨmna bageyam rɨgap yiwatonda, Yesu ket Yoanɨm gatab yɨt b'atomonj rɨga bobo wa pɨlwa da, “Wɨn nanggamog gasa na yɨr ongongɨm yoponda wul kesa tungg wa? Rɨka rɨb ma ɨtegreni bus na? ");
INSERT INTO gdr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ɨ rada maka, sɨ wɨn nanggamog gasa na yɨr ongongɨm yoponda? Rɨka otomanti b'ogɨl kobɨrgɨm b'ikoki rɨga na? Nayɨ, ma opima de. Ajɨ odede b'ogɨl ngɨndngɨnd kobɨrgɨm b'ikoki rɨga dɨde ukoi wulkɨp kɨma b'ogɨl gasa ingaena rɨga wekeny re king waina met nasim. ");
INSERT INTO gdr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ɨ rada maka, sɨ wɨn nanggamog gasa na yɨr ongongɨm yoponda? Rɨka bageyam na? Owɨ ɨmɨnjog e, Kon wen tamninyɨn da ton re ukoijog bageyam e, ma odede e ɨt re naskanyam bageyam re dɨde. ");
INSERT INTO gdr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Sɨ ton re ɨntemb jɨ rɨga ya gatab e odede yɨna peband ɨrɨki yɨbɨm da, ‘Yɨr, ɨta Koina bageyam ɨtmɨkisɨn dem Mor naska nya wa, yet ra Mor wɨp ke menon okas ɨ Mornɨm menonɨm nya motngonjenau dem.’ ");
INSERT INTO gdr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ɨ Kon wen tamninyɨn, makwa ɨta yɨpa ukoijog nyɨ rɨga odede Yoan re dɨde komkesa rɨga wɨngɨrɨnd yena re konggap ukka eyenanj. Ajɨ yete re sobijogjog nyɨ rɨga yɨbɨm God ma pumb tunggɨnd, ton re ukoijog nyɨ rɨga e ajɨ Yoan re ma ukoi nyɨ rɨga e.” ");
INSERT INTO gdr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ɨ re rɨgap Tina yɨt utkundo, komkesa rɨga dɨde teks imdayam rɨgap baptiso yokateno Yoanɨm pɨlke, dɨde ket endento da God re negɨr kesa dɨmdɨmjog e. ");
INSERT INTO gdr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ajɨ Parisai rɨga dɨde gog yɨt wumɨrjog rɨga maka Yoanɨm pɨlke baptiso yokateno, sɨ ɨngkenaemb ton towalenggyam Godɨmna ɨsamki singi b'ɨsayo. ");
INSERT INTO gdr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ɨ Yesu kwa yindenonj da, “Sɨ nanggamog gasa kae Kon yɨpa rɨrɨrkɨp tamninyɨn rɨga yepim re yu wekeny onggɨt gowukoyɨnd? Sɨ ton nanggamog gasa kɨma im yɨpa rɨrɨr? ");
INSERT INTO gdr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ton re yɨpa rɨrɨrkɨp rɨga im odede rɨngmim ra b'ɨga sobijog omnɨki tekeny nɨmog bobond tungg aband, ɨ yɨpa bobo b'ɨgawarɨp kwa yɨpa bobo b'ɨgawar yɨt tugwatenanj odede opurena kɨma da, ‘Sɨn pop wa pate ara epayau, ajɨ wɨn makwa omarkindam. Ɨ sɨn pop wa nony b'uwou kɨma ger atangau, ajɨ wɨn makwa yii wuwenyɨt.’ ");
INSERT INTO gdr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Mop nokɨp re Baptiso Yoan ikonj ɨ ton maka owoujog aweneninonj nɨnda rɨga re dɨde, ɨ maka ɨk anaikeneninonj, sɨ wɨn ti gatab endenenindam da, ‘Ton re negɨr wɨngawɨnga ke okati rɨga e.’ ");
INSERT INTO gdr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ɨ re Rɨgamna B'ɨga ikonj, ɨ owou aweneninonj dɨde ɨk anaikeneninonj, sɨ wɨn endenenindam da, ‘Yɨr, Ton re oba owou dɨde oba ɨk onaika rɨga e, ɨ dɨde Ton re teks imdayam dɨde negɨr mɨleyam towa rɨga e.’ ");
INSERT INTO gdr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ajɨ komkesa rɨga yena re God Tina multekɨp ke angenkeneniny, tontemb ɨmɨnjogɨm yomnenyi da Godɨmna multekɨp re negɨr kesa dɨmdɨmjog e.” ");
INSERT INTO gdr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ɨ Parisai rɨga wɨngɨrɨnd yɨpa rɨgat Yesund yɨgekitonj Ton kɨma diyam awowɨm. Sɨ Yesu ket onggɨt Parisai rɨga ma met wa yikonj ɨ omitonj owoupund. ");
INSERT INTO gdr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ɨ omanda onggɨt taunɨnd yɨpa negɨr mɨleyam kongga wɨbnonj. Sɨ re ton wumɨr awonj da Yesu ama diyam ainy onggɨt Parisai rɨga ma metɨnd, ton kea ngɨrangngɨrang gaya yiyonj yɨpa otomanti alabasta gɨmo botolɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Seg ton ket Yesum kak ke onyitonj Tina pɨs wusɨnd, dɨde yii windonj ngɨrpu ket yɨrekɨp ke Tina pɨspam esankonj, ɨ ket tinajog mopngɨi ke esurenonj. Seg ton ket Tina pɨspam amongnenonj, ɨ dɨde ket ngɨrangngɨrang gaya ke esnɨkonj. ");
INSERT INTO gdr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ajɨ re onggɨt Parisai rɨgat yet re Yesund yɨngaukonj yɨr yongonj onggɨtyam mɨle, ton ti nony mana yindonj da, “Rada ɨtemb Rɨga bageyam e, Ton kako wumɨr ainy da yeto ton, dɨde rɨdede konggato Tin yesopai, ɨ ɨtomb re negɨr mɨleyam kongga o.” ");
INSERT INTO gdr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sɨ Yesu tin mɨra yomnonj da, “Simon! Kor ɨta yɨpa yɨt mor usekam.” Ɨ todaka yindonj da, “Ouyaena Rɨga! Nusekae!” ");
INSERT INTO gdr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Sɨ Yesu yindonj da, “Rada ke yɨpa rɨgat nɨmog rɨga wa wulkɨp agoninonj mɨra ɨtendam, yɨpa rɨgam pɨlwa re ukoi wulkɨp tri tausɨn (3,000) Kina na, ɨ daka kwa yɨpa rɨgam pɨlwa re ma ukoi wulkɨp na tri andred (300) Kina na, ");
INSERT INTO gdr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ajɨ ton onggɨt nɨmog rɨgaina abitoro wulkɨp awɨr amnawonj ongandam, mop nokɨp ton ma rɨrɨr na awonda onggɨtyam abitoro ongandam. Sɨ rɨngma, onggɨt nɨmog rɨga wɨngɨrɨnd yete onggɨt wulkɨp yonggyamɨnd ukoi kana singi yiyeny?” ");
INSERT INTO gdr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon mɨra yomnonj da, “Kon ɨja e nony aeny da ɨnte rɨga yamana re ukoijog abitoro wulkɨp awɨr yomnawonj ongandam.” Sɨ Yesu ket tin yomnonj da, “Sɨ man re kea dɨmdɨm na mindenyɨt.” ");
INSERT INTO gdr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ɨ Ton ket onggɨt konggam pɨlwa wɨp ɨtaingitonj, ɨ ket Simonɨm pɨlwa yindonj da, “Man ɨta jɨ onggɨt konggand yɨr wonget? Re Kon moina met wɨngɨr wa b'ɨgaren, man maka Kor nyɨ nokaet pɨspam b'ɨsekam. Ajɨ ton onggɨt konggat Koina pɨspamɨnd yɨrekɨp ke nɨsanɨk, dɨde ton ket tinajog mopngɨi ke nusureny. ");
INSERT INTO gdr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Man makwa ngai nomongnenyɨt simesime omnam, ajɨ re Kon moina met wa b'ɨgaren, ɨdenata ton ɨtomb b'atom Koina pɨspam omongnena, ɨ ton makaya seg ainy. ");
INSERT INTO gdr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Man maka olib gaya ke Koina mop yeauket, ajɨ ton ɨtomb kea ngɨrangngɨrang gaya ke Koina pɨspam eawɨk. ");
INSERT INTO gdr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Sɨ onggɨt paemb Kon men wumɨr motɨnyɨn da God kea tina jogjog negɨr mɨle awɨr womnainy, mop nokɨp ton kea ukoi kana singi niyeny. Ajɨ ya mana ra God sobijog kana negɨr mɨle awɨr omnainy, ton sobijog kana e Ken singi niyeny.” ");
INSERT INTO gdr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ɨ Yesu tin womnonj da, “Moina negɨr mɨle kemb awɨr auranj.” ");
INSERT INTO gdr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ɨ rɨga yepiya re Ton kɨma omnɨkto diyampund, endento towa wɨngɨrɨnd da, “Yete jɨ onggɨtyam rɨga, ɨte re ton kwa negɨr mɨle awɨr amnɨkiny?” ");
INSERT INTO gdr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ɨ Yesu ket onggɨt konggand womnonj da, “Moina gar ke utkundat kea mor yɨrkokar mokau, sɨ man ngɨmbland meke!” ");
INSERT INTO gdr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Onggɨt kak ke re Yesu yikenonj taun nata dɨde tungg nata, Ton God ma pumb tungg gatab God ma b'ogɨl yɨrkokar bage yɨt pɨtapɨta amneninonj. Ɨ kwa twelp (12) ɨtmɨkitijog rɨga kea toda Ton kɨma yɨpand wuwenonj. ");
INSERT INTO gdr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ɨ dɨde kwa nɨnda kongga yamana re Yesu negɨr wɨngawɨnga eaukenainonj, dɨde yena re kopa ke esakenjinonj, opi re Mariya ogenaya da Magdala tunggam kongga ya pɨlkena re seben (7) negɨr wɨngawɨnga opekto, ");
INSERT INTO gdr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ɨ Kujamna kongga Yoanna yet re Erodɨmna wulkɨp yɨr ɨpka rɨga yɨbnonj, ɨ Susanna, ɨ dɨde nɨnda kongga, opimemb komkesa kongga toda kwa kea Yesu kɨma yɨpand wuwenonj, dɨde ket towainajog gasa kena Yesu dɨde ɨtmɨkitijog rɨga yɨm akaenento. ");
INSERT INTO gdr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ɨ re komkesa taun ke rɨga wuwenonj Yesum pɨlwa, sɨ kea ukoi rɨga bobo yɨpand b'eomto, Yesu ket yɨpa tendam yɨt usekawonj. ");
INSERT INTO gdr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Yɨpa wala rɨga tina tuny ɨgmarkam yikonj sopapu wa. Ɨ re ton egmarkinonj, nɨnda tuny ɨsokto nyawɨnd, sɨ rɨgap kea onggɨtyam ɨgmarki tuny ɨpmɨndena eyento towa menamena wɨngɨrɨnd dɨde ket pumbɨnd ngenap auto. ");
INSERT INTO gdr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ɨ nɨnda tuny ɨsokto gɨmo gowɨnd, ɨ pok ɨkkɨto, ajɨ nangg yarɨmyarɨm aukɨto, nokɨp ɨtemb gou re ma ngɨmblakak na. ");
INSERT INTO gdr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ɨ nɨnda tuny ɨsokto wanja met wɨngɨrɨnd, ɨ wanja kɨma yɨpand owɨnkɨto, ɨ ket wanjap opimemb nangg ekangɨnto. ");
INSERT INTO gdr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ɨ kwa nɨnda tuny ɨsokto b'ogɨl sal gowɨnd, ɨ pok ɨkkɨto ngɨrpu ɨngkek ket kɨp ejagɨkto yɨpa ke wan andred (100) kɨp.” Ɨ onggɨt yɨt seg ke, Yesu b'okta ara yikenonj da, “Yete re man wɨngawɨnga ke yɨpya kɨma, man utkunde!” ");
INSERT INTO gdr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ɨ Tina b'auyaena rɨgap Tin yerkito da, “Nangga gatab tendam yɨt e jɨ?” ");
INSERT INTO gdr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Sɨ Ton mɨra amninonj da, “God kea jɨ Tina pumb tungg gatab wɨgawɨga yɨt wumɨr akainonj wanɨm nony aukam, ajɨ nɨnda rɨga wanɨm re tendam yɨt nena kaim amneninyɨn, nokɨm da ɨdenat bageyamɨmna yɨt rɨrɨrkɨp tainy, odede yɨt da, ‘Ton yɨr ongong reyeninem, ajɨ goro rangwateninem, ɨ kwa ton rutkundeninem, ajɨ goro nony raukinem.’ ");
INSERT INTO gdr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Sɨ ɨja emb jɨ onggɨtyam tendam yɨt. Tuny re God ma yɨtkak e. ");
INSERT INTO gdr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ɨ opi re jɨ tuny nyawɨnd ɨsokto re ɨnsimemb jɨ rɨga yepim re God ma yɨtkak utkundenanj, ɨ onggɨt kak ke daka Satana ik towa pɨlwa, dɨde ewaikuriny God ma yɨtkak towaina gar ke, nokɨm da ɨdenat ton maka God ma yɨtkak gar ke utkunda ke okatenyi dɨde maka yɨrkokar okatenyi. ");
INSERT INTO gdr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ɨ opi re jɨ gɨmo gowɨnd ɨsokto re ɨnsimemb jɨ rɨga yepim re God ma bage yɨt utkundenyi dɨde ket ton ɨtemb yɨtkak sam kɨma yokatenyi, ajɨ towa ma opima ap. Sɨ onggɨt paemb ton sobijog ganggand God ma ɨtemb yɨtkak gar ke utkunda ke yokatenyi, ajɨ daka ra sobijog ganggand b'atonkena wɨn ik, ton ket God ma ɨtemb yɨtkak ɨrari. ");
INSERT INTO gdr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ɨ opi re jɨ wanja metɨnd ɨsokto re ɨnsimemb jɨ rɨga yepim re God ma yɨtkak utkundenanj, ajɨ God ma onggɨtyam yɨtkak kɨma wɨmena wɨngɨrɨnd re nɨnda gar bebɨg dɨde jogjog gasa singi ɨ dɨde gowukoi sam mɨlepim ten wɨp awarkenanj, sɨ tonsimemb ket ten ekangɨndenanj. Sɨ onggɨt paimemb ton maka b'obogɨl ɨnɨka wuweny kɨp ɨjagɨkam. ");
INSERT INTO gdr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ɨ kwa opi re jɨ b'ogɨl sal gowɨnd ɨsokto re ɨnsimemb jɨ rɨga yepim re dɨmdɨmjog dɨde b'ogɨl gar ke onggɨtyam God ma yɨtkak utkundenanj, dɨde kwa danda kɨma yɨtkak amorkenenanj musɨk wɨmena kɨma. Sɨ onggɨt paimemb ton kɨp ejagɨkenenanj. ");
INSERT INTO gdr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Makwa ɨta yɨpa rɨgat lampa so omɨny dar ke ɨkangɨndam o kasa wɨrand oramitam. Ajɨ ton oror nate uwonyis, nokɨm da ɨdenat rɨgap ngaya yɨr ongi pɨtand, ra ton wɨngɨr wa b'ɨtgarkanj. ");
INSERT INTO gdr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mop nokɨp God ma komkesa nangga mɨle im egurki wekeny re onggɨt ngayand pɨtapɨta omnena mim, ɨ dɨde nangga im komkesa God ma mɨle wumɨr kesa wekeny re pɨtapɨta omnena mim onggɨt ngayand. ");
INSERT INTO gdr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Sɨ onggɨt paemb wɨn b'ogla nonyɨk b'obogɨl b'amdeninam onggɨt yɨtkakɨm pɨlɨnd rɨja im re yu wɨn utkundenindam Kor pɨlke! Mop nokɨp yet ra Koina onggɨtyam yɨtkak wumɨr okateny, God opima b'usaya kwa yɨtkak gatab ti wumɨr ogoniny. Ajɨ yet ra maka okateny, God ɨta awɨr omnau nangga mog wumɨr rɨnte re ton nony ke yindeny da ton ɨta yowam.” ");
INSERT INTO gdr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu ma mog dɨde yɨngganwar wuwonj Ti pɨlwa, ajɨ towanɨm ma rɨrɨr na Ton kɨma yɨpand awowɨm rɨga bobo map. ");
INSERT INTO gdr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Sɨ yɨpa rɨgat Tin wumɨr yomnonj da, “Mor mog dɨde Mor yɨngganwar opima bau wa owɨnki wekeny men yɨr ongongɨm.” ");
INSERT INTO gdr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ɨ Yesu rɨga esmonggainonj da, “Kor mog dɨde Kor yɨngganwar re tonpimemb jɨ yepim re God ma yɨtkak utkundenanj dɨde b'ingawand aramitenanj.” ");
INSERT INTO gdr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ɨ yɨpa bibɨrɨnd Yesu Tina b'auyaena rɨga kɨma gɨgand angitonj, ɨ ket ten amninonj da, “Men wuyɨn sɨpa nata de yɨpa tab wa.” Ɨ ton ket gɨga nyɨ wa yururkito, ɨ ket menon yokato. ");
INSERT INTO gdr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ɨ re ton gɨgand wuwonj, Yesu kea yɨt wegonj. Ɨ onggɨt wɨnɨnd ukoi depu rɨb ikonj de onggɨt sɨpand, sɨ gɨga re kea nyɨ b'angjɨka yikenonj, ɨ ton ma sobijog bebɨg nat aukɨto. ");
INSERT INTO gdr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Sɨ ket Tina b'auyaena rɨgap Ti pɨlwa wuwonj dɨde ket yɨt opmura yiyeno odede yɨt kɨma da, “Ukoyam, Ukoyam! Yɨm nokaine! Men momta im negɨr taindam.” Ɨ Yesu ket utnyitonj dɨde ɨtemb depu rɨb dɨde ukoi wuro samany eyowonj, ngɨrpu sɨpa mumakesajog awonj. ");
INSERT INTO gdr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Seg Yesu ket ten amninonj da, “Rote waina gar ke utkunda?” Sɨ ton ket moga na aukɨto, ɨ ket towalenggyam towalenggyam kɨd kesa kɨma b'ɨgekena wuwenonj da, “Sɨ rɨdede rɨga e jɨ? Re Ton engau rɨb ake sɨpa, kea Tin yɨt yutkunjya.” ");
INSERT INTO gdr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ɨ ton ket gɨga nya ɨjendo Gerasen eriya wa de Galili sɨpa yɨpa tab wa. ");
INSERT INTO gdr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ɨ re Yesu gɨga ke gɨl wa opendonj, yɨpa onggɨt taun ke rɨgat yet re negɨr wɨngawɨnga ma okati yɨbnonj, ton ket Yesund wɨpwɨp yomnonj. Onggɨt rɨgat b'ila ke maka kobɨrgɨm b'ikokenenonj, ɨ dɨde metɨnd yɨbnenenonj. Ajɨ ton yɨbnenenonj re nɨnda gɨmo yɨund eski gopmet wɨngɨr nat. ");
INSERT INTO gdr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ɨ re ton Yesund yɨr yongonj, ton ukoi ara kɨma irere awonj dɨde sap otendonj Ti wɨpɨnd, ngɨrpu ton ket ukoi ara kɨma obailitonj da, “Yesu, pumbjog Godɨmna b'ɨga! Nangga e man singi yomnyɨt kor pɨlɨnd? Kon metɨrkisɨn, goro ken negɨr notɨnɨm!” ");
INSERT INTO gdr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mop nokɨp Yesu kea negɨr kɨlkɨl wɨngawɨngand yingawonj opendam onggɨt rɨgam pɨlke. Negɨr wɨngawɨngat re kea naskand tin nenegɨr kana emorka yiyenenonj, sɨ rɨgap tin b'engabenga kai ke dɨde sein kai ke yɨm dɨde pɨs ɨjobɨka yiyeneno, dɨde ket tin yɨr ɨpka yiyeneno yɨpa pɨpmetɨnd. Ajɨ ton kea kai epkeneninonj ɨ sein kai anygɨkeneninonj, ɨ negɨr wɨngawɨngat tin wɨp yiyenenonj dea ta wul kesa tungg nata. ");
INSERT INTO gdr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ɨ Yesu ket tin yɨgekitonj da, “Yete mor nyɨ?” Sɨ jogjog negɨr wɨngawɨngap kea b'ɨgarkɨto ti pɨlɨnd, sɨ onggɨt penaemb ton ket mɨra yomnonj da, “Ligiyonte.” ");
INSERT INTO gdr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ɨ ton ket Yesund yɨgekenayo da, “Goro sɨn nitngainɨm menonɨm de ngortod wa kunɨnkunɨn euki kip wa rokasim re negɨr wɨngawɨnga wekeny negɨr ma b'ɨsagɨka okatam.” ");
INSERT INTO gdr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Onggɨt wɨnɨnd kea jogjog ongeni b'om bobo wekenonj dor tabɨnd. Ɨ onggɨt negɨr wɨngawɨngap ket Yesund yɨgekito da, “Sɨn ningaine onggɨt b'om wa pɨlwa b'ɨgarkam.” Ngɨrpu Yesu ket ten engainonj b'ɨgaram. ");
INSERT INTO gdr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Seg negɨr wɨngawɨngap ket onggɨt rɨgam pɨlke opekto dɨde ket b'om wa pɨlwa b'ɨgarkɨto. Ɨ opimemb b'om bobo b'ɨkto sɨpa yuru kumb wa, ɨ ket sɨpa wa unykurto, ngɨrpu ket komkesa uj aukɨto. ");
INSERT INTO gdr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ɨ re onggɨt b'om ongena rɨgap yɨr yongo onggɨtyam mɨle auki, ton ket b'ɨkento dɨde yɨdɨr yɨt yiyeno onggɨt taunɨnd dɨde nɨnda tungg nata. ");
INSERT INTO gdr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Sɨ rɨga re kea wuwenonj onggɨtyam auki mɨle yɨr ongongɨm. Ɨ re ton Yesum pɨlwa wuwenonj, ton kea yodareno ɨtemb rɨga ya pɨlkena re negɨr wɨngawɨnga opekto. Ajɨ ton kobɨrgɨm b'ikoki dɨde b'ogɨl nony menamena okateni kɨma na omiti yɨbnonj Yesum wusɨnd. Sɨ ton ket moga na aukɨto. ");
INSERT INTO gdr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ɨ yepiya re towa yɨr ke yɨr yongo rɨdede na Yesu onggɨt negɨr wɨngawɨnga ma okati rɨgam yɨrkokar yokawonj, ton ket rɨga wumɨr omnena eyento. ");
INSERT INTO gdr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Sɨ re komkesa rɨga bobo yepiya re Gerasen eriya ke tuwonj, utkundeno towaina yɨt, ton kea Yesund danda kɨma yɨgekeno towa pɨlke ewaikitam, mop nokɨp ton ukoi moga na aukɨto. Sɨ ket Yesu gɨga wa angitonj dɨde ket yiwatonj. ");
INSERT INTO gdr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ɨ onggɨt wɨnɨnd re Yesu iwatam awonj, onggɨt rɨgat ya pɨlkena re negɨr wɨngawɨnga opekto, Yesund yɨgekitonj Ton kɨma menonɨm. Ajɨ Yesu tin yɨtmɨkitonj odede yɨt kɨma da, ");
INSERT INTO gdr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mor met wa ɨtende, dɨde tesɨpkenainyɨt rɨja na re God mor ukoi mɨle momnɨkau.” Seg ton ket yiwatonj dɨde komkesa taunɨnd pɨtapɨta amnenainonj rɨja na re Yesu ti ukoi mɨle yomnɨkawonj. ");
INSERT INTO gdr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ɨ re Yesu ɨtendonj, rɨga bobop kea Tin simesime yomno, nokɨp komkesa rɨga re kea Ti yɨr ungawand wekenonj. ");
INSERT INTO gdr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ɨ onggɨt wɨnɨnd yɨpa rɨga nyɨ da Yairo yet re Ju rɨga waina yɨr opmitenapu met mopyam yɨr ɨpka rɨga na yɨbnonj, ton ikonj Yesum pɨlwa. Ɨ ton Yesum wɨp ke kumsos b'amka kɨma b'amairenonj dɨde Tin yɨgekitonj menonɨm tina met wa. ");
INSERT INTO gdr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mop nokɨp ti yɨpaina nena na ngɨmngai b'ɨga yɨbnawonj ama rɨka twelp (12) kemag kɨma na dɨde ket momta uj okata nat wɨbnonj. Sɨ re Yesu Yairom met wa yiwatonj, rɨga bobop kea Tin ɨwatɨndena yiyo pɨpmet b'ɨsatena kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ɨ kea dɨkɨnd yɨpa kongga wikonj towa wɨngɨrɨnd yet re kus opekenenonj twelp (12) kemag kɨma. Sɨ ton kea wikenenonj dokta yɨr ongongɨm dɨde tina kupka yɨrkokar esomnena yiyenenonj. Ajɨ makwa yet Tin wɨsakendonj. ");
INSERT INTO gdr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Sɨ ɨtomb kongga Yesum kak ke wikonj dɨde ket Tina kobɨrgɨm petɨr yesopayonj. Seg ket odenja ket tina kus opekapu yɨra kesa awonj. ");
INSERT INTO gdr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ɨ Yesu rɨga arkisinonj da, “Yet ken nesopai?” Ɨ re komkesa rɨga b'aento, Petro Tin yomnonj da, “Ukoyam! Rɨga bobopim men ɨwatɨndena miyenyi dɨde mor wusɨnd pɨpmet b'ɨsatena wuweny.” ");
INSERT INTO gdr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ajɨ Yesu yindonj da, “Yɨpat ke ken nesopai, mop nokɨp kon ke b'ɨpɨnsɨn da danda re kea kor pɨlke ewaikis.” ");
INSERT INTO gdr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Sɨ ket ɨtomb kongga b'angwatonj da, “Kon ma rɨrɨr e egisɨn pɨta omni kesa.” Ɨ ton ket kaktɨtɨ kɨma Yesum wɨp wa tikonj dɨde kumsos b'amkonj ngɨrpu ket komkesa rɨga wa wɨpɨnd pɨtapɨta yomnenainonj nangga pena Tin yesopayonj dɨde rɨja na re odenja Ton tin wɨsakendonj. ");
INSERT INTO gdr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Seg Yesu tin womnonj da, “Ngɨmngai b'ɨga! Moina gar ke utkundate men mɨsakenj. Meke ngɨmbla kɨma!” ");
INSERT INTO gdr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ɨ re Yesu onggɨt yɨt opurenand yɨbnonj, odedend ket yɨpa rɨga ikonj Yairom met ke, ɨ Yairond yomnonj da, “Moina ngɨmngai b'ɨga kea uj ainy. Sɨ goro man ouyaena rɨgand jabakɨpɨnd ɨl ongket menonɨm! Goro Tin ɨsakaulisɨt!” ");
INSERT INTO gdr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ajɨ re Yesu onggɨtyam yɨt utkundonj, Ton Yairond yomnonj da, “Goro moga tawɨm! Gar ke utkunda nena yoramite! Ɨta mor b'ɨga b'ɨtɨsakenj dor.” ");
INSERT INTO gdr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ajɨ re ton tina met wa opekto, Yesu maka engainonj nɨnda rɨga b'ɨgaram wɨngɨr wa Ton kɨma, ajɨ ɨna Petro ɨ Yoan ɨ Yakobo ɨ dɨde onggɨt b'ɨgamna b'u ake mog. ");
INSERT INTO gdr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ɨ onggɨt wɨnɨnd, komkesa rɨga yii b'ɨrɨnena nat wekenonj dɨde kom b'amoratena kɨma b'ɨaena wuwenonj ti gatab, ajɨ Yesu ket ten amninonj da, “Goro yii taininam! Mop nokɨp ɨtomb ngɨmngai b'ɨga re ma uj o, ajɨ yɨt o weg.” ");
INSERT INTO gdr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ajɨ rɨgap Yesund ngong na yengeno, nokɨp ton yɨr wongo re uj na. ");
INSERT INTO gdr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ɨ re ton b'ɨgarto rɨkɨnd re uj b'ɨga wɨbnonj, Yesu tin yɨmɨnd wokatonj dɨde tin womnonj da, “B'ɨga! Utnyite!” ");
INSERT INTO gdr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Seg ita ket tina wɨngawɨnga ɨtendonj, ɨ ton ket odenja utnyitonj. Ɨ Yesu engainonj ti owou okawam. ");
INSERT INTO gdr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Sɨ ti b'u ake ti mog re wɨnga kesa na awonda. Ajɨ Yesu danda kɨma b'ingawa yɨt yoramitonj da, “Goro yɨpat onggɨtyam gatab yɨt pɨta omnɨkɨm!” ");
INSERT INTO gdr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ɨ Yesu ket Tina Twelp (12) b'auyaena rɨga ara emokinonj b'eomam, ɨ Ton ket ukoi danda dɨde juwai agoninonj komkesa negɨr wɨngawɨnga eaukenam dɨde komkesa kopa ke ɨsagɨkam. ");
INSERT INTO gdr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ɨ Ton ket ten etmɨkisinonj God ma pumb tungg gatab bage yɨt pɨtapɨta omnenam dɨde kopa rɨga ɨsagɨkam. ");
INSERT INTO gdr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ɨ re Ton ɨtmɨkitam amninonj, Ton ten engainonj da, “Goro kwa nangga na eyinam wa menonɨm! Goro kutɨp kɨma, goro ga kɨma, goro owou kɨma, goro wulkɨp kɨma, ɨ goro kobɨrgɨm talomam kɨma! ");
INSERT INTO gdr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ra wɨn tuwenyɨt tungg yɨpayɨpa nata, ɨ dɨde ra yɨpayɨpa met nata obai tamnenanj waina menon tungg wɨngɨrɨnd, omanda tekenyɨt, ngɨrpu ra wɨn tungg terarenindam dem. ");
INSERT INTO gdr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ɨ rɨga yepiya ra maka wen simesime tamnenanj dem, sɨ wɨn ɨdenatemb ket onggɨt met ke o onggɨt taun ke iwasya. Ɨ onggɨt iwata wɨnɨnd wɨn b'ogla waina pɨspamɨnd sungar tedbenenindam towanɨm nony aukam da towaina negɨr mɨle b'ɨsagɨkam wɨn ɨta ik dem.” ");
INSERT INTO gdr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yɨt seg ke ton ket yiwato dɨde tungg nata wuwenonj. Ɨ rɨkɨnd re ton wuwenonj komkesa wɨnɨnd, ton kea God ma b'ogɨl yɨrkokar bage yɨt pɨtapɨta omnena yiyeno dɨde kopa ke rɨga ɨsagɨka eyento. ");
INSERT INTO gdr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ɨ re Galili eriya king Erod utkundenonj komkesa onggɨtyam auki mɨle gatab, ton ma sobijog na nonysɨpsɨp aukonj. Mop nokɨp nɨnda rɨgap opurena eyento da baptiso Yoan kea uj ke utnyitonj, ");
INSERT INTO gdr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ɨ kwa nɨnda rɨgap da bageyam Eliya kea pɨtapɨta awonj, ɨ dɨde kwa nɨnda rɨgap da yɨpa b'ilap bageyam e utnyitonj. ");
INSERT INTO gdr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ajɨ Erod yindonj da, “Kon ke Yoanɨnd mop yɨpendond, ajɨ yetemb jɨ rɨga ya gatab im re kon onggɨtyam yɨt utkundenyɨn?” Sɨ ton nya oraka eyeninonj Yesund yɨr ongongɨm. ");
INSERT INTO gdr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ɨ re ɨtmɨkitijog rɨga ɨtekto, ton ket Yesund wumɨr yomneno komkesa gasa rɨna re ton amnɨkto. Sɨ Yesu ket ten eyinonj tentawar wa Ton kɨma de yɨpa taun wa ogenaya da Betsaida. ");
INSERT INTO gdr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ajɨ rɨga bobop kea wumɨr yokato rɨkɨnd re Yesu yɨbnonj, ton kea Tin oraka yiyo. Seg Ton ten simesime amneninonj dɨde ten yɨt atainonj God ma pumb tungg gatab, dɨde kopa rɨga esakenjinonj yena re Ton singi amneninonj ɨsagɨkam. ");
INSERT INTO gdr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ɨ re ket bibɨr wɨn awɨr auka yikonj, Twelp (12) ɨtmɨkitijog rɨga tuwonj Ti pɨlwa, ɨ yomno da, “Rɨga bobo etmɨkenine, nokɨm da ɨdenat ton wuswus tungg nata dɨde wungawungapu tungg nata wungapu pɨpmet dɨde owou oraka teyenanj! Nokɨp men re wul kesa tungg nasim wekenyɨn.” ");
INSERT INTO gdr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ɨ Yesu ket esmonggainonj da, “Wɨn towa owou agoninam!” Ajɨ todaka ket yomno da, “Sowa ɨnsima paib (5) sana nganja dɨde nɨmog kabum nena wekeny. Sɨ sɨn maka ra wuyɨn dɨde onggɨt komkesa rɨga rɨrɨrɨnd owou temjindam, sɨn ma rɨrɨr im towa ogonam.” ");
INSERT INTO gdr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ton odede penaemb onggɨtyam yɨt apurento, nokɨp demb de ama rɨka paib tausɨn (5,000) rɨgajog na wekenonj. Ajɨ Ton Tina b'auyaena rɨga amninonj da, “Komkesa rɨga b'ogla ama rɨka pipti (50) bobond omnɨka eyenina diyam awowɨm!” ");
INSERT INTO gdr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Seg ton ket Yesu ma onggɨt yɨt rɨrɨrɨnd komkesa rɨga gowɨnd omnɨkam amnento. ");
INSERT INTO gdr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ɨ ket Yesu paib (5) sana nganja dɨde nɨmog kabum akasinonj, ɨ pumb wa yɨr yikenonj dɨde ket Godɨnd sɨteket yɨt yomnonj, ngɨrpu sana nganja epkɨkinonj dɨde kabum ɨpka eyenonj, ɨ ket Tina b'auyaena rɨga wa agoninonj rɨga bobo wa yingg iyenam. ");
INSERT INTO gdr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ɨ komkesa rɨga diyam auto re kea ngor aukɨto. Seg ket b'auyaena rɨgap rɨga wa pɨlke kombyam owou akatto dɨde ket kea twelp (12) wat yɨndangɨr amnɨkto. ");
INSERT INTO gdr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ɨ yɨpa wɨnɨnd re Yesu Tinta yɨr opmitenonj, Tina b'auyaena rɨga re kea dɨkɨnd Ton kɨma wekenonj. Ɨ Ton ket ten arkisinonj da, “Yena rɨgap yomnɨkenenyi da yeten Kon?” ");
INSERT INTO gdr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ɨ ton mɨra yomno da, “Rɨgap endenenanj da Man re baptiso omnɨkayam Yoantet, ajɨ nɨndap da Man Eliyatet, ɨ nɨndap da yɨpa b'ilap bageyam e utnyitonj.” ");
INSERT INTO gdr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ajɨ Yesu ten egekisinonj da, “Ajɨ wɨdaka rɨngmim, wɨn yena yomnɨkenenya da yeten Kon?” Sɨ Petro ket mɨra yomnonj da, “Man re Godɨmna Kerisotet yena re God gaya yeaukonj Tina wɨko omnɨkam.” ");
INSERT INTO gdr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ɨ Yesu danda kɨma ten engainonj da, “Goro yena rɨga wumɨr tamnina Kor gatab!” ");
INSERT INTO gdr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Seg Yesu yindonj da, “Rɨgamna B'ɨga b'ogla jogjog b'ɨdgotnena rakatenin, ɨ Ju rɨga waina elda rɨga ɨ yɨna mopyam sɨ rɨga ɨ dɨde Ju rɨga waina gog ouyaena rɨgap b'ogla ɨsayi dem, ngɨrpu b'ogla onganji dem. Seg nowam bibɨrɨnd Ton b'ogla kwa tutnyis dem uj ke.” ");
INSERT INTO gdr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ɨ Ton ket komkesa rɨga amninonj da, “Yet ra man singi taet Ken yɨmta undokam, man b'ogla naska moina singi komkesa terarkinyɨt, ɨ kwa man b'ogla ita bibɨr rɨrɨrɨnd komkesa bebɨg takasinyɨt Godɨm wɨkond ngɨrpu moina uj wul b'agbagɨnd, dɨde ket Ken yɨmta nutundoket. ");
INSERT INTO gdr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mop nokɨp yet ra tilenggyam tina yɨrkokar yɨrgong omnɨka iyeny, ton ɨta ɨtemb tina yɨrkokar dadal edamkis dem. Ɨ daka yet ra tina yɨrkokar edamkis Kor map, ton ɨta ɨtemb tina yɨrkokar dadal okas dem. ");
INSERT INTO gdr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ɨ ra man komkesa gowukoi mornɨm okasɨt ɨ dɨde onggɨt gowukoi map moina yɨrkokar edamkisɨt dem, sɨ nangga b'ogɨl e man yɨr onget onggɨt gowukoi okati ke? ");
INSERT INTO gdr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ɨ kwa yet ra man Ken dɨde Koina yɨt gar ke ɨngar kɨma takasinyɨt rɨga wa wɨngɨrɨnd, Rɨgamna B'ɨgat daka men ɨngar kae motɨny dem, ra Ton yɨna aneru kɨma ik dem Tina b'ogɨl ɨnyomarena kɨma dɨde Ti B'u ma b'ogɨl ɨnyomarena kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ajɨ Kon ɨmɨnjog nitinjɨn da yepim re wɨn owɨnki wekenyɨt dɨkɨnd, wa wɨngɨrɨnd nɨnda rɨgap makwa opima uj taukanj, ngɨrpu ra ton yɨr ongi dem God ma pumb tungg.” ");
INSERT INTO gdr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ɨ onggɨtyam gatab yɨt opurena seg ke re ket ama rɨka eitɨm (8) bibɨr awonj, Yesu ara emokinonj Petro ɨ Yoan ɨ dɨde Yakobo dɨde ket wuwonj de yɨpa dor kumb wa yɨr opmitam. ");
INSERT INTO gdr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ɨ re Ton yɨr opmitenonj, Tina wɨp re etama kɨma na aukonj dɨde Tina kobɨrgɨm ngaya pɨla na ɨnyomarena kɨma bɨlbɨljog aukonj. ");
INSERT INTO gdr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ɨ odedend ket nɨmog rɨga, Mose ake Eliya, pɨta awonda b'ogɨl ɨnyomarenand dɨde Yesu kɨma yɨpand yɨtnono aenonda Tina gowukoi ɨraram gatab rɨnte ra rɨrɨrkɨp tainy dem Yerusalemɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ajɨ onggɨt wɨnɨnd Petro dɨde ton kɨma rɨga re ma sobijog yɨtpa pena yɨr uwonento. Ajɨ re ton yɨr opngɨkto, ton kea yɨr angto Yesumna b'ogɨl ɨnyomarena dɨde nɨmog rɨga Ton kɨma onyiti. ");
INSERT INTO gdr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ɨ re ton Yesund ɨraram yomnonda, Petro Yesund yomnonj da, “Ukoyam! Sɨn otomanti im wekenyɨn dɨkɨnd. Sɨ sɨn nowa plaimet raranginum, yɨpa Mornɨm, ɨ yɨpa Mosem, ɨ dɨde yɨpa Eliyam.” Ajɨ ton maka nony awonj nangga mana ton yindonj. ");
INSERT INTO gdr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sɨ re ton onggɨtyam yɨt apureninonj, rɨm ikonj dɨde ket ten ekangɨnjinonj. Ɨ re ton rɨm bora wa b'ɨgarkɨto, ton kea moga aukɨto. ");
INSERT INTO gdr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ɨ ara ikonj onggɨt rɨm bora ke odede da, “Ɨtemb jɨ Koina B'ɨga yena re Kon yobagendond. Sɨ wɨn Tin yutkunda!” ");
INSERT INTO gdr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ɨ onggɨtyam ara seg ke ket, ton Yesu nena na yɨr yongo. Sɨ ton nowa rɨga yɨt kesa na wekenonj onggɨt gatab, ɨ onggɨt wɨnɨnd ton makwa yena ngai wumɨr amnento nangga na re ton yɨr angto. ");
INSERT INTO gdr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ɨ ɨspari ke ket re ton tuwonj dor kumb ke, ukoi rɨga bobo kea tuwonj Yesund wɨpwɨp omnam. ");
INSERT INTO gdr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ɨ odedend ket onggɨt rɨga bobo wɨngɨrɨnd yɨpa rɨgat Yesund ara yɨawonj da, “Ouyaena Rɨga-wɨi! Kon Men mɨtenaen da Man kor b'ɨgand kear omnyɨt, nokɨp ton re kor lesmɨta b'ɨga e. ");
INSERT INTO gdr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ɨ negɨr wɨngawɨngat tin yemorkeneny dɨde ɨndama kamil yowarkeneny, ɨ tumol aembɨka kɨma tin kakwulwul yomnɨkeneny, ngɨrpu tin gou wa nenegɨr kana ɨngmandena yiyeneny, ɨ ɨngkaemb ket tin yɨrareneny. Ajɨ ɨdenata ɨrar ra tin gou wa omɨny. Ajɨ maka ra ton odede nenegɨr kana omnena iyeny, ton ma ɨta tin ɨrarena iyeny. ");
INSERT INTO gdr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Sɨ kon ke pop Moina b'auyaena rɨga wa pɨlwa b'ɨtena yoramisɨn negɨr wɨngawɨnga ewaikitam, ajɨ ton ma rɨrɨr na.” ");
INSERT INTO gdr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Sɨ Yesu mɨra amninonj da, “Oo, gar ke utkunda kesa dɨde gar eskamki rɨga yepim re yu wekeny onggɨt gowukoyɨnd! Rɨdede pɨn e Kon nɨtɨbnyɨn wɨn kɨma dɨde rɨdede pɨn e Kon musɨk wɨmena okasɨn waina gar ke utkunda kesa mɨle gatab?” Ɨ Ton ket b'ɨgam b'und yomnonj da, “Mor b'ɨgand iyɨm Kor pɨlwa!” ");
INSERT INTO gdr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ɨ re ɨtemb b'ɨga ikonj Ti pɨlwa, negɨr wɨngawɨngat tin gou wa yɨskantonj dɨde ukoi kana kaktɨtɨ kɨma yɨjgɨndenonj. Sɨ Yesu ket negɨr kɨlkɨl wɨngawɨngand samany yiyowonj, dɨde ket onggɨt kewar b'ɨgand yɨsakendonj, ngɨrpu ti b'uɨm b'ɨga yokawonj. ");
INSERT INTO gdr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Seg komkesa rɨgap wɨnga kesa aukɨto Godɨmna ukoijog danda gatab. Ɨ re komkesa rɨga kɨd kesa aena wuwenonj onggɨtyam komkesa mɨle gatab rɨna re Yesu amnɨkinonj, Ton Tina b'auyaena rɨga amninonj da, ");
INSERT INTO gdr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Wɨn b'obogɨl onggɨtyam Koina yɨtkak gar ke takasindam nangga gatab im ra Kon wumɨr tamninyɨn. Mop nokɨp Rɨgamna B'ɨgand ɨta namb tɨb yii dem de rɨgaina yɨm kumb wa.” ");
INSERT INTO gdr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ajɨ Tina b'auyaena rɨgap maka nony aukɨto onggɨtyam opureni yɨt gatab, dɨde onggɨtyam yɨt re egiti na yɨbnonj towa pɨlke, sɨ onggɨt penaemb ton maka yongwato. Ɨ ton kwa moga na aukɨto Tin ɨgekitam onggɨtyam opureni yɨtkak gatab. ");
INSERT INTO gdr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ɨ yɨpa yɨt b'ugwatena pɨta awonj b'auyaena rɨga wa wɨngɨrɨnd da yete ukoyam yɨbɨm towa wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ajɨ Yesu kea wumɨr awonj towaina garɨnd onggɨtyam yɨt b'ugwatena gatab, ɨ Ton ket yɨpa b'ɨga sobijog yokatonj dɨde ket Ti yɨu ke yonyitonj. ");
INSERT INTO gdr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Seg Ton ket ten amninonj da, “Yet ra odede b'ɨga sobijog simesime omɨny Koina nyɨ kɨma, ton re Kena simesime nomɨny. Ɨ dɨde yet ra Ken simesime notɨny, ton re kea simesime yomɨny yet re Ken nɨtmɨkitonj. Mop nokɨp yet ra sobijogjog tainy komkesa wa wɨngɨrɨnd, ton re ukoijog rɨga e.” ");
INSERT INTO gdr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ɨ Yoan ket Yesund yomnonj da, “Ukoyam! Sɨn yɨpa rɨga yɨr yongu Moina nyɨ kɨma negɨr wɨngawɨnga ewaikitand. Sɨ sɨn tin yɨswangu da, ‘Goro yɨmta ke odede omnɨkɨm dem!’ nokɨp ton ma ɨta yɨmta undoka miyeny sɨn kɨma.” ");
INSERT INTO gdr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ajɨ Yesu tin yomnonj da, “Goro tin ɨswanga! Mop nokɨp yet ra maka wen tajgasiny, ton re wa tab ke rɨga e.” ");
INSERT INTO gdr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sɨ Yesum pumb wa menonɨm wɨn re kea wus wa auka ikonj, ɨ Ton ket danda kɨma yɨmjatonj menonɨm de Yerusalem taun wa. ");
INSERT INTO gdr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ɨ Ton ket naska nata nɨnda bageyam etmɨkisinonj Samariya eriya wa, sɨ ton ket wuwonj dɨde ket b'ɨgarkɨto yɨpa tungg wa Tinɨm gasa ongonjenam. ");
INSERT INTO gdr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ajɨ demb de rɨgap maka Tin simesime yomno, mop nokɨp Ti menon yɨbnawonj re Yerusalem taun wa na. ");
INSERT INTO gdr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ɨ re Tina b'auyaena rɨga Yakobo ake Yoan onggɨtyam mɨle yɨr yongonda, ton endonda da, “Yonggyam! Ma man singi et da sɨn wul ingaya wub kumb ke inkam dɨde ten so omnam?” ");
INSERT INTO gdr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ajɨ Yesu ten wɨp awarkitonj, ɨ samany eyowonj. ");
INSERT INTO gdr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ngɨrpu ton ket wuwonj b'enga tungg wa. ");
INSERT INTO gdr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ɨ re ton menon yokato, nyawɨnd yɨpa rɨga Yesund yomnonj da, “Kon ɨta men yɨmta undoka mitiyenyɨn rɨtata ra man metkenyɨt.” ");
INSERT INTO gdr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Sɨ Yesu tin yomnonj da, “Gongɨr wa opima towa wul bora wɨmenam, dɨde pumbɨnd ngena wa kwa opima towa met, ajɨ Rɨgamna B'ɨgam re awɨr e kwa Ti wɨmenapu pɨpmet mop owaglitam.” ");
INSERT INTO gdr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ɨ Yesu kwa ket yɨpa rɨgand yomnonj da, “Yɨmta nundoke!” Ajɨ onggɨt rɨgat Yesund yomnonj da, “Yonggyam! Kon yɨmta kae Mor pɨlwa tɨtenjɨn ajɨ naska kon kor b'und eungitam neken.” ");
INSERT INTO gdr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ajɨ Yesu tin yomnonj da, “Toko wɨngawɨnga ke uj rɨgap gop raukinem towainajog uj rɨga, ajɨ man meke God ma pumb tungg gatab God ma b'ogɨl yɨrkokar bage yɨt pɨtapɨta omnenam.” ");
INSERT INTO gdr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ɨ kwa yɨpa rɨgat yindonj da, “Yonggyam! Kon men ɨta yɨmta mutundoken, ajɨ naska Man ken nɨnjɨkite wɨdaemb yɨt omnam rɨga yepim re wekeny koina metɨnd.” ");
INSERT INTO gdr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sɨ Yesu tin yomnonj da, “Yet ra yɨm taramis gou ungankapu gasa kumbɨnd, ɨ ra kak wa yɨr tetaingis, ton ma dɨmdɨm e unganka yiyeny. Sɨ ton ma rɨrɨrkɨp rɨga e God ma pumb tungg wɨko iyenam.” ");
INSERT INTO gdr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ɨ onggɨt kak ke, Yonggyam abagenjinonj b'usaya Sebenti (70) rɨga, ɨ Ton naska kana nɨmognɨmog etmɨkeninonj komkesa taun nata dɨde tungg nata rɨtata ra Ton ikeny dem. ");
INSERT INTO gdr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ɨ re Yesu ten etmɨkeninonj, Ton ket ten yɨt etainonj da, “Erngokam re jogjog im, ajɨ wɨko rɨga re ma jog im. Sɨ onggɨt paemb wɨn erngoka Yonggyamɨnd yɨgekita odede da, ‘Man wɨko rɨga etmɨkisine Moina erngokapu gou wa.’ ");
INSERT INTO gdr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Wɨn wuwe! Yɨr de, Kon wen etmɨkeninyɨn re odede wɨp im rɨngmim ra rɨgat mamoi tetmɨkisiny dɨ yongg wa wɨngɨr wa. ");
INSERT INTO gdr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ɨ goro eyina pauso, ɨ goro ga, ɨ goro yongɨnkak, ɨ dɨde goro yena simesime omna nyawɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ra wɨn yɨpayɨpa met nata b'ɨtgarenindam, naska wɨn tendenindam da, ‘Ngɨmbla dɨkɨnd onggɨt metɨnd.’ ");
INSERT INTO gdr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ɨ ra onggɨt ngɨmbla okatam rɨrɨrkɨp rɨga ɨbɨm demb de onggɨt metɨnd, ɨta waina oramiti ngɨmbla ton kɨma ɨbɨm. Ajɨ maka ra, ɨta tɨtenj wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ɨ wɨn omanda wɨmena tuwenyɨt onggɨt met nata, ɨ wɨn owou dɨde onaika teyenindam nangga gasa na ra ton ogona teyenanj. Mop nokɨp God ma wɨko rɨga re rɨrɨrkɨp rɨga e odede nya ke tina wɨko mɨra okatam. Goro metta metta tuwenɨm! ");
INSERT INTO gdr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ɨ ra wɨn yɨpayɨpa taun nata b'ɨtgarenindam dɨde wen simesime tamnenanj, wɨn owou nena teyenindam nanggamog im ra wanɨm wɨp ke taramkauranj. ");
INSERT INTO gdr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ɨ kopa ke rɨga tesagɨkenindam demb de onggɨt taun nata, ɨ ten yɨt tamnenindam da, ‘God ma pumb tungg re kea wa wus nate ainy’. ");
INSERT INTO gdr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ajɨ ra wɨn yɨpayɨpa taun nata b'ɨtgarenindam, ɨ maka ra wen simesime tamnenanj, wɨn tuwenyɨt onggɨt taun sobea nata, ɨ tendenindam da, ");
INSERT INTO gdr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nangga ma jɨ onggɨtyam sungar rɨna re b'ausɨkanj sowaina pɨspamɨnd onggɨt taunɨnd, sɨ sɨn ket wanɨm mim onggɨtyam sungar b'ɨdbenenindam wen nonony omnam da b'ɨsagɨka wɨn ɨta ik dem wanɨm. Ajɨ wɨn b'ogla onggɨtyam gatab wumɨr tekenyɨt da God ma pumb tungg re kea wus nate ainy.’ ");
INSERT INTO gdr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ɨ Kon wumɨr wen tamninyɨn da ra b'ɨsagɨka wɨn ik dem, Sodom taunɨm ra ukoi bebɨg e okas dem, ajɨ onggɨt taunɨm ra dem b'usaya mogjog bebɨg e okas dem. ");
INSERT INTO gdr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“God ma sake man kɨma Korajin, ɨ God ma sake man kɨma Betsaida. Mop nokɨp rako Kon opimemb kɨd kesa kɨma danda wɨko amnɨkinonj de negɨr kɨma Tiro taun ake Sidon taunɨnd rɨna re Kon wa wɨngɨrɨnd amnɨkeninonj, ton kako b'ila rongg b'ikokto dɨde ket wumbol kumbɨnd omnɨkto negɨr mɨle ke engendam de Godɨm pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ajɨ ra b'ɨsagɨka wɨn ik dem, Tiro ake Sidon towanɨm ra ukoi bebɨg e dem, ajɨ wanɨm ra dem b'usaya mogjog bebɨg e okasya dem. ");
INSERT INTO gdr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ɨ kwa man, Kaparnaum, ɨta man wub kumb wa b'uturowasɨt dem? Nayɨ, man ɨta tiglet dem de uj rɨgaina tungg wa. ");
INSERT INTO gdr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yet ra wen yɨt tutkundeniny, ton Kena nutkundeny. Ɨ yet ra wen tesainy, ton Kena nɨsai. Ajɨ yet ra Ken nɨtɨsai, ton Ti na yɨsai yet re Ken nɨtmɨkitonj.” ");
INSERT INTO gdr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Sɨ ket sebenti (70) b'auyaena rɨga ɨtekto sam kɨma, ɨ endento da, “Yonggyam! Nangga ma jɨ negɨr wɨngawɨnga, ton kea sɨn yɨt nutkundento, re sɨn Moina nyɨ kɨma b'ingawa yoramitenonda.” ");
INSERT INTO gdr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ɨ Yesu ten amninonj da, “Kon kea Satanand yɨr yongond wub kumb ke sap otendand odede ɨt re rɨngma ra waral tokmɨnjis. ");
INSERT INTO gdr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kon ke wa danda akainond gɨrem dɨde wɨrmogmog ɨpmɨndenam, dɨde gou wa omnenam komkesa geja rɨgaina danda. Sɨ onggɨt paemb makwa yɨpat ɨta wen negɨr tamnɨkiny. ");
INSERT INTO gdr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ajɨ goro wɨn sam taininam onggɨtyam gatab rɨna re negɨr wɨngawɨngap wen yɨt utkundento, ajɨ wɨn sam omnɨka yiyena onggɨtɨm da waina nyɨ re ɨrɨki im wekeny de pumb tungg wa.” ");
INSERT INTO gdr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ɨ onggɨt wɨnɨnd re Yɨnayɨna Wɨngawɨnga Yesum pɨlɨnd b'imuronj, Ton ma sobijog na sam yomnɨkonj, ɨ Ton yindonj da, “Abu, wub ake gowukoyɨm Yonggyam! Kon sɨteket yɨt momnyɨn, nokɨp Man ke onggɨtyam Moina danda dɨde yɨrkokar yɨtkak agurkinot rɨga wa pɨlke yepim re multekɨp kɨma dɨde b'ogɨl wumɨr kɨma wekeny. Ajɨ Man kea onggɨtyam Moina gasa towanɨm pɨtapɨta amnenainot yepim re b'ɨga sobijog pɨla wumɨr kesa wekeny. Abu! Ɨmɨnjog e, Onggɨtyam gasa aukonj re Moina b'ogɨl sam kɨma singi nasim. ");
INSERT INTO gdr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Komkesa danda dɨde wumɨr re Kor B'uɨt Kor mana nogoninonj ingaenam. Ɨ makwa yɨpa ɨta yete wumɨr B'ɨgam gatab, ajɨ B'uta Tinta wumɨr. Ɨ makwa ɨta yete wumɨr B'uɨm gatab, ajɨ tonpima wumɨr, B'ɨga dɨde rɨga yena re B'ɨgat singi eyeniny B'und pɨta omnenam towa pɨlwa.” ");
INSERT INTO gdr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ɨ Yesu Tina b'auyaena rɨga wɨp awarkisinonj, ɨ ten nena amninonj da, “Ton b'ogɨl omni yɨrkɨp im jɨ yepim re yɨr ongong eyenanj nangga im re wɨn yɨr ongong eyenindam. ");
INSERT INTO gdr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mop nokɨp Kon wen wumɨr tamninyɨn da naskand jogjog bageyamɨp dɨde kingɨp singi aukenento yɨr ongongɨm nangga im re wɨn yɨr ongong eyenindam, ajɨ ton maka yɨr ongong eyento. Ɨ kwa ton singi aukenento utkundam nangga im re wɨn utkundena eyenindam, ajɨ ton maka utkundenento.” ");
INSERT INTO gdr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ɨ yɨpa wɨnɨnd yɨpa gog yɨt wumɨrjog rɨga onyitonj Yesund otonkenam, sɨ ton ket Tin yerkitonj da, “Ouyaena Rɨga-wɨi! Rɨnggɨtyam wɨko omnɨka kae kon owabɨnsɨn dadal ngɨrpu kesa yɨrkokar?” ");
INSERT INTO gdr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ɨ Yesu tin yɨsmonggawonj da, “Rɨdede e Mosemna gog peband ɨrɨki yɨbɨm? Ɨ man rɨdede e yokatenyɨt moina ogenka wɨngɨrɨnd?” ");
INSERT INTO gdr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Seg ton yɨsmonggawonj da, “Man moina Yonggyam Godɨnd singi yiyene moina kupkakupka kɨd ke, ɨ moina kupkakupka wɨngawɨnga ke, ɨ moina kupkakupka danda ke, ɨ dɨde moina kupkakupka nony ke! Ɨ singi yiyene mor rɨgand mada re dɨde!” ");
INSERT INTO gdr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Sɨ Yesu tin yomnonj da, “Kea man dɨmdɨmjog mɨra nomnyɨt. Onggɨtyam yɨt rɨrɨrɨnd yomnɨke! Sɨ man ɨta yɨrkokar mɨtɨbnyɨt.” ");
INSERT INTO gdr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ajɨ ton singi na tilenggyam negɨr kesa dɨmdɨmjog rɨga tainy. Sɨ ton Yesund yerkitonj da, “Sɨ yete jɨ kor rɨga?” ");
INSERT INTO gdr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu yɨsmonggawonj da, “Yɨpa rɨga Yerusalem taun ke yikonj de Yeriko wa, ɨ nyawɨnd raskolɨp ket tin yɨwatɨnto dɨde ket tina kobɨrgɨm yotogɨko, ɨ tin nenegɨr kana yipowo, ngɨrpu gou yɨpo. Seg ton tin kokamkokam yɨraro. ");
INSERT INTO gdr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ɨ odedend yɨpa yɨna sɨ rɨga onggɨtyam nya ɨmayonj, ɨ re ket ton onggɨt rɨgand yɨr yongonj, ton kea tin nya yɨwaponj. ");
INSERT INTO gdr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ɨ odede yɨpa wɨp nya ke yɨpa Lebi gu rɨga todaka onggɨt pɨpmet wa ikonj dɨde ket tin yɨr yongonj. Seg todaka kea tin nya yɨwaponj. ");
INSERT INTO gdr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ajɨ yɨpa Samariya rɨga menon yokatonj, ɨ ket ikonj rɨkɨnd re ɨtemb rɨga yɨbnonj. Ɨ re ton tin yɨr yongonj, ton kea gar ke tin kear yomnonj. ");
INSERT INTO gdr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ɨ ton ket ti wus wa yikonj, ɨ ket ton olib gaya dɨde ɨk egmarkinonj tina ipoipu yɨrand dɨde ket unjoka yiyenonj. Seg ket ton tinajog dongki kumb wa tin yangitonj, dɨde ket yiyonj yɨpa wungapu met wa, ngɨrpu adea ket tin yɨr yengendonj. ");
INSERT INTO gdr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ɨ ɨspari ke ket ton twelp (12) Kina yokawonj onggɨt wungapu met yonggyamɨm, ɨ yomnonj da, ‘Tin yɨr ɨpka iyenyɨt. Ra man wewe wulkɨp tasomnenyɨt tin yɨr ɨpkand, kon ɨta ket mor mɨtendainyɨn onggɨtyam wewe wulkɨp, ra kon tɨtenjɨn dem.’ ");
INSERT INTO gdr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sɨ man rɨdede e nony aet? Rɨngma, onggɨt nowa rɨga wɨngɨrɨnd, yete ti rɨga ainy onggɨt rɨgam yena re raskolɨp nenegɨr kana yipowo?” ");
INSERT INTO gdr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Sɨ onggɨt gog wɨko rɨgat mɨra yomnonj da, “Tonɨt yet re tin kear yomnonj.” Seg Yesu tin yomnonj da, “Meke! Dɨde odede yɨpa wɨp mɨle na tamnɨkinyɨt.” ");
INSERT INTO gdr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ɨ re ton wuwenonj, nyawɨnd Yesu b'ɨgaronj yɨpa tungg wɨngɨr wa. Ɨ ademb de yɨpa kongga nyɨ da Marta Yesund obai omnam yɨngaukonj. ");
INSERT INTO gdr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ɨ onggɨt konggam yɨpa kea wundoi wɨbnawonj wogenayo da Mariya. Sɨ ti wundoi re Yonggyamɨmna pɨs wɨp nat omiti wɨbnonj Tina yɨtkak utkundenam. ");
INSERT INTO gdr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ajɨ Marta re nony bebɨg kɨma na guglam yondratenonj b'engabenga wɨp owou ongonjenam. Sɨ ton Yesum pɨlwa wikonj dɨde ket Tin yomnonj da, “Yonggyam-wɨi! Man ma wumɨr et da kor wundoi kor nena mana wɨko nɨrarkainy? Sɨ be ngai wingae tin ken yɨm okawam!” ");
INSERT INTO gdr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ajɨ Yonggyam mɨra tin womnonj da, “Marta, Marta! Man nangga ma gar bebɨg dɨde nony negɨr ainyɨt jogjog owou ongonjenam? ");
INSERT INTO gdr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ajɨ yɨpaina mɨle nena e b'ogɨljog omnɨkam dɨkɨnd. Mop nokɨp Mariya re kea b'ogɨl pɨpmet yokas, sɨ makwa yete onggɨt pɨpmet ke tin tewaikis.” ");
INSERT INTO gdr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ɨ yɨpa wɨnɨnd Yesu yɨpa pɨpmet yokatonj, ɨ ket yɨr opmitenonj. Ɨ re Ton yɨr opmita seg awonj, Tina b'auyaena rɨga wɨngɨrɨnd yɨpa rɨgat Tin yomnonj da, “Yonggyam! Sɨda nouyaenine rɨdede e yɨr opmitena odede rɨja na re Yoan tina b'auyaena rɨga auyaeninonj!” ");
INSERT INTO gdr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Sɨ Yesu ten yɨt etainonj da, “Ra wɨn yɨr topmisindam, odede tendenindam da, ‘Abu! Moina nyɨ b'ogla yɨnam rain. Ɨ Moina wɨp omnenapu pumb tungg b'ogla rinɨk onggɨt gowukoi wa. ");
INSERT INTO gdr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ɨ bibɨr weanjweanj sowa owou notgoneneninyɨt bibɨr rɨrɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ɨ sɨn komkesa rɨga wa negɨr mɨle awɨr amnɨkaenindam yepim re sowa pɨlɨnd negɨr mɨle amnɨkenenanj, sɨ onggɨt paemb Man sowaina negɨr mɨle awɨr omnɨka teyeninyɨt. Ɨ Man goro sɨn wɨp niyinɨm negɨr ma b'atonkena wa!’” ");
INSERT INTO gdr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ɨ Yesu ten amninonj da, “Rada wa wɨngɨrɨnd yɨpa rɨgam ɨta ti yɨpa ti rɨga, ɨ ton yik onggɨt ti rɨgam met wa sɨdɨrɨnd, dɨde tin omɨny da, ‘Kor rɨga! Nowa sana nganja nokaine, yɨmta ke toko mɨra metendainɨn. ");
INSERT INTO gdr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nokɨp yɨpa kor rɨga kor pɨlwa ik paja tungg ke, ajɨ kor awɨr e kwa nangga e kor yɨmɨnd yɨbɨm ti okawam.’ ");
INSERT INTO gdr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ɨ ti rɨgat met wɨngɨr ke tin yɨsmonggawonj da, ‘Goro nɨtɨsakawɨm! Mora daka re kea ɨdoki e yɨbɨm, ɨ sɨn koina b'ɨgawar kɨma ke yɨpa nasim b'ɨkangɨndi yutungi wekenyɨn. Sɨ kon ma rɨrɨr e ket tutnyisɨn mor ogonam.’ ");
INSERT INTO gdr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Sɨ Kon wen tamninyɨn da nangga ma jɨ rada ton re ti rɨga e yɨbɨm, ton ma ɨta tutnyis tinɨm ogonam ti rɨga map. Ajɨ ra ton ɨngar kesa ti rɨgand ɨjenenawai, ton ɨta ket tutnyis ti ogonam nangga ma ton singi yoramis. ");
INSERT INTO gdr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ɨ Kon kwa wen tamninyɨn da wɨn erkena yiyena, ɨ wɨn ɨta okasya. Ɨ wɨn oraka yiyena, ɨ wɨn ɨta ket odarya. Ɨ wɨn mora odounena yiyena, ɨ ɨta mora wanɨm tɨpangenj. ");
INSERT INTO gdr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mop nokɨp komkesa rɨga yepiya ra erkena iyenyi, ton ɨta okasi, ɨ oraka iyenyi, ton ɨta odari, ɨ dɨde mora odounena iyenyi, mora ɨta towanɨm tepangenj. ");
INSERT INTO gdr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ɨ wa wɨngɨrɨnd yete re b'ɨga b'uwam, rada ti b'ɨgat erkis kabumɨm, sɨ rɨngma, ton gɨrem e okau, o mɨnda ma kabum e? ");
INSERT INTO gdr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ɨ kwa rada paurokɨpɨm erkis, sɨ ton ɨta okau wɨrmogmog? ");
INSERT INTO gdr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Sɨ onggɨt paemb nangga ma jɨ rada wɨn negɨrjog mɨle rɨga im, ajɨ wɨn wumɨr im wekenyɨt rɨdede e wa b'ɨgawar wa ogonam b'ogɨl gasa. Sɨ Abu yete re yɨbɨm pumb tungg wa, Ton re ma ɨja e ɨt re wɨn re dɨde, ajɨ Ton opima ɨmɨnjogjog Yɨnayɨna Wɨngawɨnga towanɨm takainy yepim re Tin yerkenyi.” ");
INSERT INTO gdr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ɨ Yesu yewaikitonj negɨr wɨngawɨnga yet re yɨpa rɨgand yɨt kesa yomnɨkenenonj. Sɨ re onggɨtyam negɨr wɨngawɨnga opendonj, ɨtemb yɨt kesa rɨga kea yɨt apureninonj. Seg ket rɨga bobo kea kɨd kesa aento. ");
INSERT INTO gdr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ajɨ towa wɨngɨrɨnd nɨnda rɨga endento da, “Ton negɨr wɨngawɨnga eaukeniny re negɨr wɨngawɨnga waina mopyam Beeljebulɨmna danda kaim.” ");
INSERT INTO gdr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ɨ nɨnda rɨgap odede erkena kɨma Yesund yotonkeno da, “Man yɨpa kɨd kesa kɨma danda wɨko omnɨket rɨnte ra pumb tungg ke ik. Sɨ ɨngkaimemb sɨn Men gar ke motkasu.” ");
INSERT INTO gdr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ajɨ re Yesu towaina nonyɨk b'amdena wumɨr awonj, Ton ket ten amninonj da, “Ra yɨpa kantrind rɨga towalenggyam b'itpouranj gangga b'akalendam, ɨtemb kantri ɨta negɨr tainy. Ɨ kwa ra b'ubɨgawar wɨngɨrɨnd rɨga towalenggyam b'itpouranj, onggɨt b'ubɨgawar waina wɨmena re ɨta negɨr tawɨk. ");
INSERT INTO gdr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ɨ ra Satanamna kantrind, Satana Ti wɨrand negɨr wɨngawɨnga teaukeniny, ɨ towalenggyam b'itpouranj gangga b'akalendam, sɨ rɨngma, rɨrɨr e ɨtemb tina kantri tonyis? Kon nindenyɨn onggɨtyam yɨt, mop nokɨp wɨn endenindam da Kon negɨr wɨngawɨnga eaukeninyɨn re Beeljebulɨmna danda kena. ");
INSERT INTO gdr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Sɨ wɨn apurenindam da Kon Beeljebulɨmna danda kena negɨr wɨngawɨnga eaukeninyɨn, sɨ daka waina b'ɨgawar wɨngɨrɨnd nɨnda rɨga, ton yaina danda kaim eaukenenanj? Godɨmna danda kaim. Sɨ onggɨt mop paimemb ton ket taukanj ra wanɨm b'ɨsagɨka rɨga im onggɨtyam waina negɨr opurena gatab. ");
INSERT INTO gdr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ajɨ ra Kon negɨr wɨngawɨnga teaukeninyɨn Godɨmna danda yɨm ke, sɨ God ma pumb tungg re kemb wa pɨlɨnd au. ");
INSERT INTO gdr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ɨ ra yɨmmasa kɨkɨb kɨma danda rɨga tinajog met aba yɨrgong omnɨka iyeny, tina gasa re b'ogɨl ima tekeny. ");
INSERT INTO gdr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ajɨ ra yɨpa ukoijog danda rɨga ik dɨde onggɨt danda rɨgand gou wa omɨny, tina geja gasa ɨsamburiny rɨngkae re ton b'uwoga yikeny. Ngɨrpu ton onggɨt rɨgamna gasa komkesa b'asos tuweny ti rɨgawar kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ɨ yet ra maka Kon kɨma tainy, ton re Koina geja rɨga tab nate yɨbɨm. Ɨ kwa yet ra maka Kon kɨma yɨpand b'eomkena ikeny, ton re wetaweta omnɨka rɨga e. ");
INSERT INTO gdr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ɨ ra negɨr wɨngawɨnga topenj yɨpa rɨgam pɨlke, ton ket b'ugumarena ikeny nyɨ kesa pɨpmet nata dɨde oraka iyeny wɨram wɨmenam pɨpmet, ajɨ makwa ɨta odar. Sɨ ton ket indeny da, ‘Kon kwa ama tɨtenjɨn koina met wa rɨna re kon yɨraren.’ ");
INSERT INTO gdr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ɨ ra ton tɨtenj, ton met odar ra b'obogɨl ɨsagɨki e dɨde b'obogɨl gasa ongonjeni im. ");
INSERT INTO gdr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Sɨ ton ket yikeny dɨde arondeniny nɨnda seben (7) negɨr wɨngawɨnga yepim re ukoi kana negɨr mɨlend wekeny ti pɨlke, ɨ ket ton kɨma yɨpand b'ɨgarkanj ɨ dɨde dea de wɨmena wuweny. Sɨ onggɨt rɨgamna kikitumpu wa wɨmena re ma ɨja e ɨt re naskand re dɨde, ajɨ ɨtemb re ket negɨrjog e yɨbɨm.” ");
INSERT INTO gdr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ɨ re Yesu onggɨtyam yɨt opurenand yɨbnonj, rɨga bobo wɨngɨr ke yɨpa kongga ara wikenonj da, “God ma b'ogɨl onggɨt komɨm pɨlɨnd yet re Men komɨnd mowamonj dɨde rɨnggɨt ngompiya re Men ngom mokonda.” ");
INSERT INTO gdr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ajɨ Yesu yindonj da, “Ɨmɨnjog e, ajɨ tonsim ɨmɨnjogjog God ma b'ogɨl kɨma rɨga yepim re God ma yɨt utkundenanj dɨde b'ingawand aramitenenanj.” ");
INSERT INTO gdr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ɨ re rɨga bobo b'aikɨndento, Yesu yindonj da, “Rɨga yepim re yu negɨrjog mɨlend wekeny onggɨt gowukoyɨnd, re negɨrjog mɨle rɨga im, ton Ken nɨgekenyi kɨd kesa kɨma danda wɨko omnɨkam, ajɨ Kon kɨd kesa kɨma danda wɨko wa takainyɨn ra ɨna nena e rɨna re Yonam pɨlɨnd aukonj. ");
INSERT INTO gdr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mop nokɨp onggɨtyam kɨd kesa kɨma danda wɨko rɨna re Yonam pɨlɨnd aukonj re yɨpa mal na awonj Ninebe rɨga wa pɨlwa, sɨ Rɨgamna B'ɨga Toda kwa odede yɨpa wɨp mal emb tainy towanɨm yepim re yu wekeny onggɨt gowukoyɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ɨ ra b'ɨsagɨka wɨn ik dem, bargubo gatab ke kwin ɨta yɨpand gɨlgɨl towɨnyis dem onggɨt rɨga kɨma yepim re yu wekenyɨt onggɨt gowukoyɨnd, ɨ ton ɨta yɨr ungata rɨga tainy dem wanɨm negɨr ma b'ɨsagɨka okatam. Mop nokɨp naskand ton tikonj re ma wuswus kantri kena Solomonɨmna b'ogɨl multekɨp ke yɨtkak utkundam, ajɨ ɨta yete yɨbɨm dɨkɨnd, Ton re ma sobijog b'ogɨl multekɨp kɨma e Solomonɨm pɨlke, ajɨ wɨn makaima Tina b'ogɨl multekɨp ke yɨtkak singi eyenindam utkundam. ");
INSERT INTO gdr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ɨ kwa Ninebe rɨga re kea Yonamna pɨtapɨta omnenyi God ma yɨtkak yutkundeno, ɨ ɨngkenaemb ket negɨr mɨlem pɨlke gar b'engento Godɨm pɨlwa. Ajɨ ɨta dɨkɨnd ukoijog rɨga yɨbɨm, sɨ Ton re ma odede ukoi rɨga e ɨt re Yona re dɨde. Ajɨ rɨga yepim re yu wekeny onggɨt gowukoyɨnd, ton ma opima Tina yɨt utkundenanj dɨde negɨr mɨlem pɨlke gar b'engkɨranj Godɨm pɨlwa. Sɨ onggɨt paimemb Ninebe rɨga opima towɨnkanj dem Godɨmna b'ɨsagɨkapu pɨpmetɨnd yɨpand ton kɨma yepim re yu wekeny onggɨt gowukoyɨnd, dɨde ket onggɨt Ninebe rɨgaina b'ogɨl mɨlep ten negɨr ma b'ɨsagɨkand taramitenanj dem. ");
INSERT INTO gdr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Makwa yɨpa rɨgat ɨta lampa so omɨny kopakak ke utwangkam o mɨnda dar ke ɨkangɨndam. Ajɨ ton lampa so omɨny ra uwonyitapu ororɨnd oramita ma, nokɨm da ɨdenat ngaya yɨr ongi yepiya ra rɨga met wɨngɨr wa b'ɨtgarenanj. ");
INSERT INTO gdr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ɨ waina yɨrkɨp re waina jɨwɨm lampa e. Sɨ rada waina yɨrkɨp b'ogɨljog im, waina kupkakupka jɨ ra ngaya pɨta nasim tekeny. Ajɨ rada waina yɨrkɨp negɨrjog im, sɨ waina jɨ ra sɨbɨb ke ɨkangɨndi im tekeny. ");
INSERT INTO gdr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","36","Sɨ onggɨt paemb rada moina kupka jɨ ngaya nate yɨbɨm, dɨde makwa yɨpa kɨpear sɨbɨb ke ɨkangɨndi e yɨbɨm, sɨ kupkakupka jɨ re ngaya pɨta nate yɨbɨm, odede ɨt re rɨngma ra lampa ngayat men mɨtnyomareny.” ");
INSERT INTO gdr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ɨ re Yesu onggɨtyam yɨt apureninonj, yɨpa Parisai rɨgat Tin yɨngaukonj ton kɨma diyam awowɨm. Seg Yesu tina met wa b'ɨgaronj dɨde ket omitonj diyamɨm. ");
INSERT INTO gdr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ajɨ re onggɨt Parisai rɨgat yɨr yongonj Yesumna diyam mɨle, ton kɨd kesa na awonj, mop nokɨp Ton maka naska yɨm b'ɨseka mɨle yomnɨkonj diyam awowɨm Ju rɨga waina ɨseka mɨle rɨrɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ɨ Yonggyam tin yomnonj da, “Yu wɨn Parisai rɨga re kapo dɨde pleto b'obogɨl im ɨseka eyenindam waina mɨle rɨrɨrɨnd, ajɨ wɨngɨr ke re wɨn nonygor mɨle dɨde negɨrjog mɨle ke yɨndangɨr im wekenyɨt. ");
INSERT INTO gdr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Wɨn wumɨr kesa korɨrkorɨr rɨga! Godɨt gɨm ke yɨr ongong gasa atobarkinonj, sɨ rɨngma, ma Tonɨt kwa atobarkinonj wɨngɨr ke yɨr ongi kesa gasa? ");
INSERT INTO gdr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ajɨ wɨn kear gasa na agoninam gasa kesa rɨga wa rɨnsim re wekeny waina kapo dɨde pleto borand, sɨ ɨngkaimemb ket komkesa gasa wanɨm kɨlkesa tekeny. ");
INSERT INTO gdr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ajɨ God ma sake wɨn kɨma Parisai rɨga, mop nokɨp wɨn opima erngokenenindam kɨma ɨ sili ɨ dɨde b'engabenga wɨp b'eag, ɨ ket onggɨtyam sobijog gasa ten (10) ɨkalki wɨngɨrɨnd yɨpa tab Godɨnd wulpok yomnɨkenenya. Ajɨ wɨn yɨukenenya dɨmdɨm mɨle omnɨkam rɨga wa pɨlwa dɨde singi b'iyena mɨle omnɨkam Godɨm pɨlwa. Ajɨ wɨn b'ogla omnɨkenenya onggɨtyam mɨle, dɨde Godɨm yɨpa bobo wulpok omnɨka mɨle toda kwa b'ogla omnɨkenenya. ");
INSERT INTO gdr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","God ma sake wɨn kɨma Parisai rɨga, mop nokɨp wɨn singi aukenenindam ɨsnawa kɨma pɨpmet okatam Ju rɨga waina yɨr opmitenapu met nata, dɨde ɨsnawa kɨma simesime okatam rɨga wa pɨlke maketpu nata. ");
INSERT INTO gdr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","God ma sake wɨn kɨma, mop nokɨp wɨn re gopmet pɨla im rɨnsim re wɨgawɨga yɨr ongi kesa egurki wekeny, dɨde rɨgap nony kesa pɨs b'amdena wuweny onggɨt kumbɨnd. Sɨ ɨngkaimemb rɨga kɨl kɨma aukenenanj Godɨm wɨpɨnd.” ");
INSERT INTO gdr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ɨ gog yɨt wumɨrjog rɨga wɨngɨrɨnd yɨpat Yesund yomnonj da, “Ouyaena Rɨga! Re man onggɨtyam yɨt apureninyɨt, Man ma sobijog negɨr yɨt na sɨn nomninyɨt.” ");
INSERT INTO gdr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ajɨ Yesu ten esmonggainonj da, “Wɨn gog yɨt wumɨrjog rɨga! God ma sake wɨn kɨma, mop nokɨp wɨn gog yɨt kaim rɨga wa pɨlɨnd bebɨg angurka eyenindam, ajɨ wɨn walenggyam makwa ngai opima ekak aramitenenindam onggɨtyam gog yɨtɨmna bebɨg urowatenam. ");
INSERT INTO gdr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","God ma sake wɨn kɨma, mop nokɨp wɨn opima bageyam wa b'ogɨl gopmet arangkaenenindam, ajɨ ton re wa b'uwar waina uj ondrɨki im. ");
INSERT INTO gdr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sɨ wɨn kemb yɨr b'ungasindam, dɨde wa b'uwar waina omnɨki mɨle yɨpand wa b'uwar kɨma yɨmjatenya, mop nokɨp tonpiyamb ten naska uj andrɨkto, ajɨ wɨnpim kwa ket gopmet arangkaindam. ");
INSERT INTO gdr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Sɨ onggɨt mop paemb God Tina multekɨp ke yindonj da, ‘Kon opima tetmɨkeninyɨn towa pɨlwa bageyam dɨde ɨtmɨkitijog rɨga, sɨ rɨgap opima onggɨtyam rɨga wɨngɨr ke nɨnda rɨga uj ondrɨka teyenindam dem, ɨ ket bebɨg dɨde b'ɨsadrena taramitenauranj dem.’ ");
INSERT INTO gdr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Sɨ onggɨt paimemb rɨga yepim re yu wekeny onggɨt gowukoyɨnd, tonsim kokob takatanj komkesa bageyam waina kus rɨna re ɨgmarkɨto onggɨt gowukoi otomapu ke ngɨrpu yu. ");
INSERT INTO gdr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Sɨ naskajog kus yɨgmarkonj re Abelɨt, ɨ ɨngkenaemb ket rɨgap ma yɨpa kɨma bageyam na kus ɨgmarka teito, ngɨrpu kikitum kus yɨgmarkonj re Jakariyat yena re rɨgap yongando yɨna sɨ omnɨkapu kap dɨde yɨna pɨpmet ganggand yɨnamet wɨngɨrɨnd. Owɨ, Kon nitinjɨn da rɨga yepim re yu wekeny onggɨt gowukoyɨnd re, tonsima onggɨtyam komkesa mɨle kokob takatenanj dem. ");
INSERT INTO gdr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","God ma sake wɨn kɨma, gog yɨt wumɨrjog rɨga, mop nokɨp wɨnpiya Godɨm gatab wumɨr ki yewaikitonda, sɨ wɨn walenggyam maka onggɨtyam wumɨr wa b'ɨgarkɨtondam, dɨde kwa da wɨnpiya ogoka eyentondam rɨga yepiya re onggɨt wumɨr wa b'ɨgaram wuwenonj.” ");
INSERT INTO gdr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ɨ re Yesu opendonj onggɨt met ke, Ju rɨga waina gog ouyaena rɨga dɨde Parisai rɨgap ket Tin soro kɨma ɨwatɨnti yiyo dɨde ket Tin erkena yiyo jogjog gasa gatab Tin bebɨgɨnd oramitam. ");
INSERT INTO gdr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Sɨ ton Yesumna opureni yɨtkak gatab mana yɨpya b'ɨtkiti wekenonj da ra Ton opulis nanggamog gog erbeka yɨt, sɨ ɨngkaim ket Tin yɨmɨnd okasi. ");
INSERT INTO gdr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ɨ re nɨnda ten tausɨn (10,000) rɨga bobo yɨpand b'eomto, sɨ rɨgata rɨgata towalenggyam pɨs b'akaski na wekenonj. Ɨ Yesu naska yɨt opurena b'atomonj re Tina b'auyaena rɨga wa pɨlwa na da, “Wɨn yɨr kɨma tekenyɨt Parisai rɨga waina yist pɨla ouyaena. Ɨtemb towaina ouyaena re gɨm ke b'ogɨl ajɨ ngor wa negɨr mɨle kɨma negɨr ouyaena e. ");
INSERT INTO gdr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ajɨ God opima komkesa kupkakupka ɨkangɨndi gasa pɨta wa tapekiny dem, dɨde komkesa wɨgawɨga egurki gasa wumɨr tamnɨkiny dem. ");
INSERT INTO gdr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nangga na re wɨn wɨgawɨga apurentondam sɨbɨbɨnd, opima bibɨrtɨkɨnd rɨgap pɨtakɨpɨnd tutkundenanj dem. Ɨ nangga na re wɨn tu muma ke yɨpya borand usenentondam wɨgawɨga pɨpmetɨnd, opima pɨtapɨta tamneniny dem rɨga bajbajɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Kor rɨgawar! Kon wen tamneninyɨn da, ‘Goro moga tuwajinam ten yepim re rɨga jɨ nena uj andrɨkenenanj, sɨ ton onggɨt kak ke ra makwa opima b'usaya nangga im omnɨka teyenanj.’ ");
INSERT INTO gdr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ajɨ Kon wen tauyainyɨn yena ra wɨn b'ogla moga uwajya, sɨ wɨn moga yuwada yama re Ti danda yɨbnau rɨga uj ondrɨkam dɨde onggɨt kak ke wul tungg wa ɨskokam. ");
INSERT INTO gdr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Sɨ rɨngma, ma rɨgap paib (5) sobijog ngena im emdenenanj ten (10) Toya ke? Sɨ ngena re ma ukoi gasa e. Ajɨ Godɨm wɨpɨnd makwa ɨta yɨpa odede ngena ngai nony b'edati yɨbɨm. ");
INSERT INTO gdr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ajɨ God re opima wen b'obogɨl yɨr ɨpka eyeniny, nangga ma jɨ da Ton opima kwa ogenka eyeniny komkesa mopngɨi waina mopɨnd. Sɨ wɨn goro moga taininam, mop nokɨp wɨn re ukoijog ɨsnawa kɨma im, ajɨ ma ɨja im opi re jogjog sobijog ngena re dɨde. ");
INSERT INTO gdr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ɨ kwa Kon wen tamninyɨn. Yet ra rɨga wa wɨpɨnd Ken pɨtapɨta notɨneny, Rɨgamna B'ɨga Todaka ɨta Godɨmna aneru wa wɨpɨnd tin pɨtapɨta omɨny dem. ");
INSERT INTO gdr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ajɨ yet ra rɨga wa wɨpɨnd Ken oena nitiyeny, Koda ɨta tin oenyɨn dem Godɨmna aneru wa wɨpɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ɨ kwa yet ra Rɨgamna B'ɨgand negɨr yɨt ke omɨny, God ti onggɨtyam negɨr mɨle opima awɨr omnainy dem. Ajɨ yet ra Yɨnayɨna Wɨngawɨngand ɨsadreny, God makwa ɨta onggɨtyam negɨr mɨle awɨr omnau dem. ");
INSERT INTO gdr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ɨ ra rɨgap wen kot omnɨkam teyenanj Ju rɨga waina yɨr opmitenapu met wa ɨ wɨp iyoi rɨga wa wɨp wa ɨ dɨde ukoi nyɨ rɨga wa wɨp wa, wɨn goro nony bebɨg taininam, rɨdede o nangga yɨtkak kaim b'ɨtɨrmekindam, o nangga yɨtkak im tapurenindam. ");
INSERT INTO gdr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mop nokɨp Yɨnayɨna Wɨngawɨngate ket onggɨt wɨnɨnd wen tauyaeniny nangga yɨtkak im wɨn b'ogla tapurenindam.” ");
INSERT INTO gdr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ɨ rɨga bobo wɨngɨrɨnd yɨpa rɨgat Yesund yomnonj da, “Ouyaena Rɨga-wɨi! Kon singi en Man kor nanyɨnd ingaet da ton sowa b'uɨmna owabɨndeni gasa kon kɨma b'obogɨl takalenjiny.” ");
INSERT INTO gdr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ajɨ Yesu tin yɨsmonggawonj da, “Rɨga! Yet Ken nobagendonj b'ɨsagɨka rɨgam o waina gasa ɨkalka rɨgam?” ");
INSERT INTO gdr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ɨ Yesu ket rɨga amninonj da, “Wɨn yɨr kɨma tekenyɨt, sɨ wɨn b'ogla walenggyam yɨr b'ɨtɨpkindam komkesa b'engabenga wɨp nonygor mɨle wa pɨlke! Mop nokɨp rɨgamna yɨrkokar re ma ɨndama b'inkiti yɨbɨm tina okati jogjog gasa wa pɨlɨnd.” ");
INSERT INTO gdr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ɨ Ton kwa tendam yɨt ke ten amninonj da, “Yɨpa jogjog gasa kɨma rɨga yɨbnonj, ɨ tina sopapund owoukɨp ɨjagɨkto re mog na pɨs. ");
INSERT INTO gdr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sɨ ton ti nony mana yindonj da, ‘Ma kor awɨr e namb ukoi met nɨbnau onggɨtyam jogjog koina owoukɨp ongapam? Sɨ nangga e kon omnɨken?’ ");
INSERT INTO gdr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Seg ton ket yindonj da, ‘Kon ɨja e namb omnɨken. Kon onggɨtyam koina owoukɨp ongapapu met b'ɨga tebogɨkinyɨn, dɨde ket owoukɨp ongapapu ukoi met im tarangkinyɨn. Sɨ amimemb ket komkesa owou dɨde b'ogɨl gasa tangapinyɨn. ");
INSERT INTO gdr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sɨ kon ɨja emb jɨ ket kolenggyam tainyɨn da, “Mor ma yɨpa kɨma b'ogɨl gasa im ongapi mɨbnainy jogjog kemag kɨma ingaenam. Sɨ man b'ogla wɨram yokatene, ɨ owou yiyand mɨbne, ɨ onaika yiyand mɨbne, ɨ dɨde sam nenand mɨbne!” ’ ");
INSERT INTO gdr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ajɨ God ɨja emb tin omɨny da, ‘Korɨrkorɨr, Kon yu sɨwɨny moina yɨrkokar ewaikisɨn dor mor pɨlke. Sɨ opimemb moina b'obogɨl ongapi gasa ra yamim ket taukanj?’ ");
INSERT INTO gdr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ɨja emb jɨ tainy tinɨm yet ra tinɨm nena gasa ongapa teyeniny dɨde maka ra Godɨm jogjog gasa oramkaeneniny.” ");
INSERT INTO gdr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Seg Yesu ket Tina b'auyaena rɨga amninonj da, “Sɨ onggɨt paemb Kon wen tamninyɨn da goro wɨn odede nony kubɨr taininam da nangga owou im tawenenindam yɨrkokar wɨmenam, ɨ kwa nanggamog kobɨrgɨm im b'itkokenenindam waina jɨwɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mop nokɨp yɨrkokar re ukoijog e owowɨm pɨlke, ɨ kwa jɨ re ukoijog e kobɨrgɨmɨm pɨlke. ");
INSERT INTO gdr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Wɨn b'ogla b'awar gatab nony menamena amnɨkinam! Ton makwa opima tuny ɨgmarka eyenenanj, ɨ makwa opima owoukɨp eakɨkenenanj. Ɨ kwa towa awɨr e owou ongapapu met b'ɨga ɨ dɨde kwa owou ongapapu bil. Ajɨ Godte ten owou ke angenkeneniny. Sɨ ɨmɨnjog e da wɨn re ukoijog im odede ngena wa pɨlke. ");
INSERT INTO gdr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ɨ wa wɨngɨrɨnd yete rɨrɨr e tina nony kubɨr b'amnɨka ke tina yɨrkokar ɨsonkis yɨpa sobijog wɨn kɨma? ");
INSERT INTO gdr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Sɨ onggɨt paemb wɨn ma rɨrɨr e walenggyam omnɨkam odede sobijogjog gasa. Sɨ nangga paim daka wɨn nony kubɨr aenindam nɨnda gasa gatab? ");
INSERT INTO gdr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Wɨn b'ogla b'obogɨl temtem gatab nony menamena amnɨkinam rɨja im ton b'obogɨl ɨkaeneni owɨnkenenanj. Sɨ ton ma opima kobɨrgɨm omnɨkam tin kai eraskenenanj, ɨ dɨde kwa ton ma opima kobɨrgɨm omnɨka eyenenanj. Ajɨ Kon wen wumɨr tamninyɨn da king Solomon kea tina komkesa b'ogɨl ɨnyomarena kɨma b'ajga yikenonj, ajɨ tina b'ajga re makwa yɨpa rɨrɨrkɨp awonj yɨpa odede temtem re dɨde. ");
INSERT INTO gdr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Sɨ rada Godsim odede tɨbam tɨb ejga eyeniny rɨnsim re yapɨnd yu yilo wekeny ajɨ mep uj taukanj wul wa b'ɨskokam. Sɨ rɨngma, rɨdede wɨp e ket God wen b'obogɨljog ejga teyeniny? Sɨ wɨn goro sobijog gar ke utkundand tekenɨm! Ton opima wen b'obogɨljog ejga teyeniny. ");
INSERT INTO gdr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Sɨ wɨn goro odede gasa oraka teyeninam, opi re da nangga im wɨn tawindam o nangga im wɨn tanaikindam. Ɨ dɨde kwa wɨn goro nony kubɨr taininam onggɨtyam gasa gatab! ");
INSERT INTO gdr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mop nokɨp gowukoi gar ke utkunda kesa rɨgap ɨnsimemb komkesa gasa oraka eyenanj, ajɨ wa B'u God wumɨr e da wɨn b'ogla onggɨtyam gasa tengaenenindam gowukoi wɨmenam. ");
INSERT INTO gdr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ajɨ wɨn b'ogla God ma pumb tungg oraka yiyena. Sɨ God ket wa tagoniny ra ma pumb tungg nena e ajɨ daka kwa opima odede komkesa gasa tagoniny. ");
INSERT INTO gdr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Sɨ wɨn, Koina sobijog mamoi bobo, goro moga taininam! Mop nokɨp wa B'u God re ma sobijog singi e aeny wanɨm pumb tungg okawam. ");
INSERT INTO gdr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sɨ wɨn asoginam wainajog gasa dɨde ket kear omnam agoninam ingaena gasa kesa rɨga wa. Sɨ ɨngkaimemb wɨn wanɨm pauso tamnɨkindam rɨnsim ra maka kep taukenenanj. Sɨ onggɨtyam re God ma pumb tunggɨnd ongapi b'ogɨljog gasa im rɨnsim ra wanɨm dadal tekeneny. Ɨ demb de pumb tungg wa awɨr im yurowamam rɨga wuweny gasa imdam, ɨ dɨde kwa awɨr im bebɨrɨp gasa negɨr amnɨkenenanj. ");
INSERT INTO gdr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mop nokɨp rokasim re waina b'ogɨljog gasa wekeny, ɨndamimaemb todaka waina kɨd tekeny. ");
INSERT INTO gdr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Wɨn b'obogɨl b'angonjeni na wekene rob ke b'ibgi robmopɨnd dɨde lampa so omni kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Sɨ wɨn odede rɨga na taindam opi re rɨngmim ra wɨko rɨgap towaina yonggyamɨnd yɨr ungaunenyi simesime omnam ra ton tɨtenj sisɨl molkongga omna diyamdiyampu ke dɨde mora odouneny, nokɨm da ɨdenat ton towa yonggyamɨm odenja mora ɨpangendai. ");
INSERT INTO gdr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Sɨ Kon ɨmɨnjog wen tamninyɨn. Onggɨtyam wɨko rɨga re b'ogɨl omni im yena ra towa yonggyam yɨr epangki tadariny ra ton tɨtenj. Sɨ ra towa yonggyam odede mɨlend yɨr tanginy, todaka rob kae b'atɨjɨg, ɨ ket ten tamisiny diyamɨm, ɨ dɨde diyampu wa ik dɨde towanɨm ngole b'atɨndrɨk. ");
INSERT INTO gdr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ton re b'ogɨl omni wɨko rɨga im yena ra yonggyam odede mɨlend tadariny, ra ton tɨtenj mɨnda sɨ gɨepɨnd o mɨnda sɨdɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ɨ wɨn wumɨr im da rada met yonggyam wumɨr ai e yɨbɨm da sɨwɨny onggɨt wɨn nate yurowamam rɨga ik tina met wa, ton ma ɨta yiyag ondras tina met iporkam. ");
INSERT INTO gdr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Sɨ wɨda kwa b'ogla b'angonjeni na tekenyɨt, mop nokɨp Rɨgamna B'ɨga ik ra dem waina ongwati kesa wɨn nate dem.” ");
INSERT INTO gdr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ɨ Petro ket Yesund yerkitonj da, “Yonggyam! Rɨka man onggɨtyam tendam yɨt yopurenyɨt re sowanɨm ma, o rɨka komkesa rɨga wa ma?” ");
INSERT INTO gdr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Sɨ Yonggyam mɨra yomnonj da, “Sɨ yete jɨ b'ogɨl multekɨp kɨma nony ɨjai mopyam wɨko rɨga ya yɨm nat ra yonggyamɨmna metɨnd komkesa gasa taramkiny yɨr ɨpkam? Sɨ yonggyam ɨta ket odede nony ɨjai wɨko rɨga obagenj komkesa tina wɨko rɨga wɨp omnenam dɨde towa ita bibɨr wɨn weanjweanjɨnd owou ogonam towaina yingg rɨrɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Sɨ ton re b'ogɨl omni wɨko rɨga e yena ra tina yonggyam odar odede yɨpa wɨp mɨle omnɨkand ra ton tɨtenj. ");
INSERT INTO gdr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ɨ Kon ɨmɨnjog wen tamninyɨn da ti yonggyam ɨta odede wɨko rɨgand obagenj komkesa tinajog gasa yɨr ɨpkam. ");
INSERT INTO gdr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ajɨ rada yonggyam yɨpa negɨrjog wɨko rɨgand tina komkesa wɨko rɨga dɨde tina gasa yɨr ɨpka mopyamɨm obagenj, sɨ ɨja emb jɨ ton ti nony mana indeny da, ‘Meda kor yonggyam ma wanakana e tɨtenj.’ Sɨ ɨngkaemb ton ket b'atom odede negɨr mɨle omnɨkam, opi re wɨko rɨga dɨde wɨko kongga ipowam ɨ owou yiyand wɨmenam ɨ onaika yiyand wɨmenam ɨ dɨde ɨkpɨpɨnd wɨmenam. ");
INSERT INTO gdr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Sɨ onggɨt wɨko rɨgamna yonggyam tɨtenj ra onggɨt bibɨr nate rɨdenat ra ton maka bibɨr wumɨr ɨbɨm, ɨ onggɨt wɨn nate rɨdenat ra ton maka wɨn wumɨr ɨbɨm. Seg ti yonggyam ket tin mop owaras dɨde ket ti pɨpmet okau ra yɨpand utkunda kesa rɨga kɨma nenegɨr wɨmenam. ");
INSERT INTO gdr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ɨ rada onggɨt wɨko rɨgat wumɨr e yɨbɨm ti yonggyamɨmna singind b'ingaenam, ajɨ ra ton maka ti yonggyamɨmna singind gasa tangonjeniny dɨde tamnɨkiny, sɨ ti yonggyam ket jogjogpyam e tin ipowa iyeny. ");
INSERT INTO gdr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ajɨ rada yete re wumɨr kesa yɨbɨm ti yonggyamɨmna singi gatab, dɨde ra ton tamnɨkiny negɨr gasa rɨnsim re rɨrɨrjog e ipowa okatam, sɨ ti yonggyam ket sobijog kana e tin ipowa iyeny. Ɨ yamim re yonggyam jogjog agoniny, toda yonggyam ra jogjog im towa pɨlke tadarkiny. Ɨ kwa yamim re yonggyam nony b'ɨjawa kɨma jogjog agoniny, toda yonggyam ra jogjog mim ten tarkeniny. ");
INSERT INTO gdr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Kon netkond re wul oramita mana onggɨt gowukoyɨnd. Ɨ rada wul kemb so omni e yɨbɨm, makwa nangga e ket Kon singi yomnyɨn. ");
INSERT INTO gdr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ajɨ Kor ɨta ujɨm baptiso nɨbnau rɨnte ra Kon okasɨn. Sɨ rɨdede gar bebɨg kɨma e Kon nɨbnenenyɨn, ngɨrpu Kon undwasɨn onggɨtyam baptiso? ");
INSERT INTO gdr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Rɨka ɨja im wɨn nony aindam da Kon rɨga wa ngɨmbla okawa mana netkond dɨkɨnd onggɨt gowukoyɨnd? Kon wen tamninyɨn da nayɨ, ajɨ gangga b'akalka mana. ");
INSERT INTO gdr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mop nokɨp yu ke, ra yɨpa metɨnd paib (5) rɨga tekeny, ton opima gangga b'atkalkenenanj towa wɨngɨrɨnd, nowa rɨgap geja omnɨkenenyi nɨmog rɨga wa pɨlɨnd, ɨ nɨmog rɨgap geja omnɨkenenya nowa rɨga wa pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","“Ɨ kwa rɨgap gangga b'atkalkenenanj, b'uɨt geja omnɨkeneny ti rɨga b'ɨgam pɨlɨnd, ɨ todaka rɨga b'ɨgat ti b'uɨm pɨlɨnd, ɨ mogɨt geja omnɨkeneny ti ngɨmngai b'ɨgam pɨlɨnd, ɨ todaka ngɨmngai b'ɨgat ti mogɨm pɨlɨnd, ɨ dɨde mog konggat geja omnɨkeneny ti b'ɨgamna konggam pɨlɨnd, ɨ todaka mea konggat ti leomna mogɨm pɨlɨnd.” ");
INSERT INTO gdr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ɨ kwa Yesu rɨga bobo amninonj da, “Ra wɨn piro moi omgokand yɨr ongya kemag gatab ke, wɨn odenja im ket tendenindam da, ‘Ukoi piro e namb ik.’ Sɨ ɨta ket onggɨt yɨt rɨrɨrɨnd tawɨk. ");
INSERT INTO gdr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ɨ kwa ra rɨb ikeny iye gatab ke, wɨn ket tendenindam da, 'Ma sobijog pemb e namb tainy.’ Sɨ ɨta ket yɨt rɨrɨrɨnd tawɨk. ");
INSERT INTO gdr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Gɨm ke b'ogɨl ajɨ ngor wa negɨr mɨle rɨga! Ra wɨn gowɨnd dɨde wubɨnd gasa yɨr ongong teyenindam, sɨ wɨn ɨta naska kana wumɨr okatenya da rɨdede wɨp i gou ake wub tebnya. Ajɨ rɨdede paim wɨn maka wumɨr ainindam ongwatenam onggɨtyam yunɨm wɨn gatab? ");
INSERT INTO gdr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ɨ kwa nangga paim wɨn maka walenggyam ɨsagɨka eyenindam nanggamog e negɨr kesa dɨmdɨmjog mɨle omnɨkam? ");
INSERT INTO gdr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sɨ ra man mor geja rɨga kɨma yɨpand menon okasɨt majistretɨm pɨlwa kot omnɨkam, sɨ nyawɨnd mada b'ogla iror tauket kot awɨr omnam dɨde rɨgarɨga awowɨm ton kɨma. Ajɨ man maka ra odede omnɨket, ton ke men ɨgonyɨgony mei de b'ɨsagɨka rɨgam pɨlwa, ɨ onggɨt b'ɨsagɨka rɨgat ket men motramis sɨbɨbmet yɨr ɨpka rɨga yɨm wa, ɨ dɨde onggɨt sɨbɨbmet yɨr ɨpka rɨgat ket men ɨsanikesa mɨtɨgarɨk sɨbɨbmet wa. ");
INSERT INTO gdr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Sɨ Kon men motɨnyɨn da sɨ man ma ɨta sɨbɨbmet ke topenjɨt, ajɨ ɨdenata ra man kikitumjog wulkɨp oramisɨt sɨbɨbmet mɨra undwatam.” ");
INSERT INTO gdr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ɨ onggɨt wɨnɨnd nɨnda rɨga kea dɨkɨnd wekenonj, ɨ ton ket Yesund wumɨr yomneno nɨnda Galili rɨga wa gatab yaina kus na re Pilato eslekinonj towaina sɨ b'angga kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Sɨ Yesu ten amninonj da, “Ma wɨn ɨja im nony ainindam da onggɨtyam nɨnda Galili rɨga re ukoijog negɨr mɨle rɨga im, ajɨ ton ma ɨja im opi re komkesa Galili rɨga re dɨde, mop nokɨp ton odede negɨrjog wɨp kenaemb uj yokateno? ");
INSERT INTO gdr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kon wen tamninyɨn da nayɨ, ajɨ wɨda kwa opima komkesa odede wɨp ke negɨr taukindam dem, ra wɨn maka negɨr mɨle ke b'etngenjindam Godɨm pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ɨ kwa wɨn wumɨr im onggɨtyam eitin (18) rɨga yena re Silowam taun yɨr ɨpkapu pumbpumb metɨt epmɨkinonj uj tama na. Ma wɨn ɨja im nony ainindam da ton re ukoijog negɨr mɨle rɨga im, ajɨ ton ma ɨja im opi re komkesa rɨga yepim re wekeny de Yerusalem taunɨnd? ");
INSERT INTO gdr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kon wen tamninyɨn da nayɨ, ajɨ wɨda kwa b'ogla komkesa odede wɨp ke negɨr taukindam dem, ra wɨn maka negɨr mɨle ke b'etngenjindam Godɨm pɨlwa.” ");
INSERT INTO gdr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ɨ Yesu kwa onggɨtyam tendam yɨt usekawonj da, “Yɨpa rɨgam yɨpa pig wul ɨtliti yɨbnawonj tina greip sopapund, ɨ ton ket yikonj onggɨtyam pig wul mop wa, dɨde pig kɨp yɨrɨk yɨndamkenenonj, ajɨ ton ma kɨp na yodarenenonj. ");
INSERT INTO gdr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Sɨ ton onggɨt greip sopapu yɨr ɨpka rɨgand yomnonj da, ‘Wɨi, kon nowa kemag kɨma na pop nekenyɨmɨn onggɨtyam pig wul mop wa, dɨde pig kɨp yɨrɨk yɨndamkenenyɨmɨn, ajɨ kon makwa ngai kɨp yodarkenenyɨmɨn. Sɨ nangga pae jaba onggɨt wulɨt jabakɨpɨnd gou yesomneneny? Sɨ onggɨt paemb man ket yɨge onggɨtyam pig wul!’ ");
INSERT INTO gdr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ajɨ onggɨt sopapu yɨr ɨpka rɨgat ti yonggyamɨnd yɨsmonggawonj da, ‘Kor yonggyam! Mabe ngai onggɨtyam pig wul nangg yɨrare b'usaya kwa onggɨtyam yɨpa kemag kɨma! Mabe kon kwa b'obogɨl kibɨr omnɨka yeyenɨn sal omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Sɨ kon wumɨr en ɨta kɨp tɨjagɨk dem sisɨl kemagɨnd. Ajɨ maka ra dem, man ɨget-a dem.’” ");
INSERT INTO gdr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ɨ yɨpa Ju rɨga waina wɨram dɨde yɨr opmitena bibɨrɨnd, Yesu rɨga ouyaena eyeninonj yɨpa Ju rɨga waina yɨr opmitenapu metɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ɨ demb de yɨpa kongga wɨbnonj yena re negɨr wɨngawɨngat okati wowamenenonj eitin (18) kemag kɨma. Sɨ ton odede penaemb kopap b'ɨmanti wɨbnenenonj dɨde ma rɨrɨr na aukenenonj mudakak kau b'ɨtnɨkam. ");
INSERT INTO gdr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ɨ re Yesu tin yɨr wongonj, Ton ket tin ara wemokonj, ɨ ket tin pɨtapɨta womnonj da, “Kongga! Man kemb moina kopa ke b'ɨsakenjɨt.” ");
INSERT INTO gdr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ngɨrpu ket Ton ti kumbɨnd yɨm aramisinonj. Sɨ odenja ket ton kau b'ɨtnɨkonj, ɨ ket Godɨnd yewangayonj. ");
INSERT INTO gdr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ajɨ Ju rɨga waina yɨr opmitenapu met mopyam rɨgat ma sobijog na soro awonj, mop nokɨp Yesu kopa kongga wɨsakendonj re towaina wɨram dɨde yɨr opmitena bibɨr nat. Sɨ ton rɨga bobo yɨt etainonj da, “Siks (6) bibɨr opi re meranɨm wɨko mim. Sɨ onggɨt paemb wɨn b'ogla kopa ke b'ɨsakendam tuwenenyɨt onggɨt bibɨr wɨngɨrɨnd. Ajɨ goro meraina wɨram dɨde yɨr opmitena bibɨrɨnd!” ");
INSERT INTO gdr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sɨ Yonggyam ket tin mɨra yomnonj da, “Gɨm ke b'ogɨl ajɨ ngor wa negɨr mɨle rɨga, sɨ rɨngma, wa wɨngɨrɨnd yɨpayɨpa rɨgap towaina kau o dongki kai ɨtreka eyenenanj towaina kara bora ke dɨde bod wa eyenenanj nyɨ onaikam meraina wɨram dɨde yɨr opmitena bibɨrɨnd? ");
INSERT INTO gdr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ajɨ onggɨtyam kongga re Abraamɨmna kus ke b'ɨga o, dɨde ɨtomb jɨ kongga Satanat tin ɨjobɨki wowamenenonj kupka eitin (18) kemag kɨma. Sɨ rɨngma, ma rɨrɨrjog e tin ɨtrekam onggɨtyam Satanamna ɨjobɨkim pɨlke onggɨtyam meraina wɨram dɨde yɨr opmitena bibɨrɨnd?” ");
INSERT INTO gdr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ɨ re Yesu onggɨtyam yɨt yopulitonj, komkesa rɨgap yepiya re Tinɨm geja rɨga de wekenonj, ɨngar na aukɨto, ajɨ komkesa rɨga daka re ma sobijog na sam aukɨto komkesa b'ogɨl ɨnyomarena kɨma gasa gatab rɨna re Yesum pɨlke aukɨto. ");
INSERT INTO gdr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sɨ Yesu yindonj da, “Nangga gasa e God ma pumb tungg kɨma yɨpa wɨp? Dɨde nanggamog gasa pɨla e Kon God ma pumb tungg yɨpa rɨrɨrkɨp otonainyɨn? ");
INSERT INTO gdr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Sɨ God ma pumb tungg re yɨpa wɨp e odede ɨt re mastad tuny re dɨde rɨna re yɨpa rɨgat yokatonj ɨ ket yɨtlitonj tinajog ɨngkind. Sɨ onggɨtyam nangg owɨnyitonj ɨ ket bɨa peago b'ɨskokonj, ngɨrpu pumbɨnd ngenap onggɨt wul bɨa kumb nata met orangka eyento.” ");
INSERT INTO gdr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ɨ Ton ket b'usaya yindonj da, “Nanggamog gasa pɨla e Kon God ma pumb tungg yɨpa rɨrɨrkɨp otonainyɨn? ");
INSERT INTO gdr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Sɨ God ma pumb tungg re yɨpa wɨp e odede yist kɨma rɨna re yɨpa konggat yokatonj dɨde ket yɨpa ukoi baiko plawa kɨma yɨimɨkonj dampam, ngɨrpu kupkakupka dampa yɨnɨkonj dɨde yudburenonj.” ");
INSERT INTO gdr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ɨ re Yesu menon yokatonj Yerusalem taun wa, Ton kea nyatnyata yikenonj taun nata dɨde tungg nata, dɨde ket rɨga ouyaena eyeninonj. ");
INSERT INTO gdr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ngɨrpu ket yɨpa rɨgat Tin yɨgekitonj da, “Kor Yonggyam! Rɨka ma jog rɨgapim yɨrkokar yokatenyi?” Ɨ Yesu ket rɨga amninonj da, ");
INSERT INTO gdr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kon wen tamninyɨn. Wɨn b'ogla danda yondratena sobijogjog mora nata b'ɨgarenam, mop nokɨp jogjog rɨgap opima yɨrɨk unjomkena yiyenyi b'ɨgarenam, ajɨ towanɨm re ma rɨrɨr e b'ɨgarenam. ");
INSERT INTO gdr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mop nokɨp ra met yonggyam tutnɨk dɨde mora islongkis, sɨ onggɨt kak ke yepiya ra wɨn bau ke owɨnki tekenyɨt mora odounenand, wɨn pop ɨgekenya da, ‘Yonggyam! Be sowa mora yɨjge!’ Ɨ ton ket ɨja im wen mɨra tamniny da, ‘Wɨn rɨngkaim? Kon ma wumɨr en wanɨm.’ ");
INSERT INTO gdr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ɨ onggɨt wɨnɨnd, wɨn ɨja im tendenindam da, ‘Sɨn ke pop man kɨma diyam aukenentondam dɨde nyɨ anaikenentondam. Ɨ dɨde man kea sɨn kɨma mekenenot dɨde nouyaeneninot nya nata.’ ");
INSERT INTO gdr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ajɨ ton wen tesmonggainy dem da, ‘Wɨn rɨngkaim? Kon ma wumɨr en wanɨm. Wɨn komkesa negɨrjog kaokao mɨle rɨga, ewaikisinam kor pɨlke!’ ");
INSERT INTO gdr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ɨ ra yɨpa wɨn ik dem, wɨn opima yɨr tangindam dem Abraam ɨ Isak ɨ Yakob ɨ dɨde komkesa bageyam God ma pumb tunggɨnd, ajɨ wɨn ra bau wa im tekenyɨt dem. Sɨ demb de bau ke wɨn opima yii kamil b'itiyoindam dem, dɨde kopa b'angnena kɨma or b'ɨtɨinɨkindam dem. ");
INSERT INTO gdr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ɨ komkesa gowukoyɨnd rɨga opima tuweny dem ɨle gatab ke dɨde kemag gatab ke, ɨ bargubo gatab ke dɨde iye gatab ke, ɨ ket God ten tamisiny dem diyamdiyamɨm Tina pumb tunggɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sɨ yɨr de, yepim re yu sobijogjog nyɨ rɨga opima yɨmta ke ukoijog nyɨ rɨga taukanj dem, ɨ dɨde kwa yepim re yu ukoijog nyɨ rɨga opima yɨmta ke sobijogjog nyɨ rɨga taukanj dem.” ");
INSERT INTO gdr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ɨ onggɨt yɨpaina wɨnɨnd, nɨnda Parisai rɨga tuwonj Yesum pɨlwa, dɨde Tin wumɨr yomno da, “Man ewaikite, ɨ ɨngkek menon yokate b'enga gatab wa, mop nokɨp Erod singi e Men ongandam!” ");
INSERT INTO gdr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ɨ Yesu ten amninonj da, “Wɨn wuwe ti pɨlwa! Ɨ onggɨt rabem b'amnenayam sobijog dɨ yongg pɨla rɨgand omnya da yu dɨde mep opima Kon negɨr wɨngawɨnga teaukeninyɨn dɨde kopa ke rɨga tesakenjinyɨn. Ɨ ket nowam bibɨrɨnd Kon ɨta onggɨtyam rɨl rɨrɨrkɨp omnyɨn nangga mana re Kon netkond dɨkɨnd onggɨt gowukoyɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ajɨ Kon b'ogla menon yakatɨn yu ɨ mep ɨ dɨde mep da mep, mop nokɨp ɨtemb re makwa rɨrɨrjog e bageyam uj okas Yerusalem taun bau ke. ");
INSERT INTO gdr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Oo! Yerusalem, Yerusalem! Yete re man bageyam uj ondrɨka eyeninyɨt, ɨ opimemb rɨga gɨmo ke uj ondrɨka eyeninyɨt yena re God etmɨkeniny mor pɨlwa. Leamogpyam na Kon singi miyenenyɨmɨn mor b'ɨga yɨpand kupokupo omnam odede rɨngmim ra mogyam paurot tinajog b'ɨga tama ke tuwopɨnsiny. Ajɨ man singi kesa na aukenenyɨmɨt. ");
INSERT INTO gdr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yɨr de, waina met Yonggyam God ɨta wen terariny dem, sɨ waina met ra ket kak e ɨbɨm dem. Kon wen tamninyɨn da wɨn makwa ɨta ket Ken b'usaya yɨr notngya dem, ngɨrpu ra wɨn tendenindam dem da, ‘God ma b'ogɨl Ton kɨma yete re Yonggyamɨmna nyɨ kɨma ik.’” ");
INSERT INTO gdr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ɨ yɨpa Ju rɨga waina wɨram dɨde yɨr opmitena bibɨrɨnd re Yesu b'ɨgaronj yɨpa Parisai mopyamɨmna met wa diyam awowɨm, rɨgap Yesund wuswus yɨr ɨpka yiyeno. ");
INSERT INTO gdr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ɨ demb de yɨpa kopa rɨga yɨbnonj yaina yɨm ake pɨs re uboubo na wekenonj. ");
INSERT INTO gdr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Sɨ Yesu gog yɨt wumɨrjog rɨga dɨde Parisai rɨga egekisinonj da, “Rɨngma, ma b'ogɨljog e tainy kopa rɨga ɨsakendam meraina wɨram dɨde yɨr opmitena bibɨrɨnd?” ");
INSERT INTO gdr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ajɨ ton re mumakesa na wekenonj. Sɨ Yesu onggɨt kopa rɨgand yokatonj dɨde ket tin yɨsakendonj, ngɨrpu ket tin yɨtmɨkitonj. ");
INSERT INTO gdr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Seg Ton ten ramnin da, “Ra wa wɨngɨrɨnd yɨpa rɨgamna b'ɨga o kau nyɨ kip wa tunykis meraina wɨram dɨde yɨr opmitena bibɨrɨnd, sɨ ma ton ɨdenata e tin oblenj nyɨ kip ke?” ");
INSERT INTO gdr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Sɨ ton makwa rɨrɨr na auto mɨra yɨt opulitam. ");
INSERT INTO gdr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ɨ re Yesu ɨngauki rɨga wa mɨle yɨr angawonj b'ɨsnawa kɨma pɨpmet imdand, Ton onggɨt ɨngauki rɨga wa yɨpa tendam yɨt usekawonj odede da, ");
INSERT INTO gdr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ra man ya met wa obayɨm meket sisɨl molkongga omna diyamdiyampu wa, goro man b'ɨsnawa kɨma pɨpmet okatɨm. Mop nokɨp ra met yonggyamɨt obai tamɨny men dɨde yɨpa ukoijog ɨsnawa kɨma rɨga yaina ɨsnawa re ma ɨja e ɨt re mor re dɨde, ");
INSERT INTO gdr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ɨ ra met yonggyam ik wa pɨlwa dɨde men motɨny da, ‘Man ti yokae ɨtemb ɨsnawa kɨma pɨpmet,’ sɨ onggɨt wɨn natemb man ket ɨngar kɨma ɨsnawa kesa goujog pɨpmet wa omitam meket. ");
INSERT INTO gdr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ajɨ ra man obayɨm meket, man b'ogla ɨsnawa kesa goujog pɨpmet okasɨt. Mop nokɨp ɨdenat met yonggyam yete re obai momɨny, ik mor pɨlwa, dɨde men ɨsnawa kɨma motɨny da, ‘Kor rɨga! Nangga pae man onggɨt ɨsnawa kesa goujog pɨpmetɨnd omisɨt? Utnyite! Ade meke de ɨsnawa kɨma pɨpmet wa omitam!’ Sɨ onggɨt wɨn natemb esourena mɨle pɨta tainy mor pɨlɨnd komkesa man kɨma omiti ɨngauki rɨga wa wɨpɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mop nokɨp yet ra tilenggyam pumb wa b'uturowateny, God ɨta tin gou wa omɨny. Ɨ kwa yet ra tilenggyam gou wa aena ikeny, God ɨta tin pumb wa urowateny.” ");
INSERT INTO gdr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Seg ket Yesu met yonggyamɨnd yomnonj da, “Ra man diyam o ukoi owou omnɨket diyamidamɨm, goro moina rɨga tengaukindam, ɨ goro mor nany dɨde yɨngganwar, ɨ goro mor kus ke dɨde kom ke wuswus rɨga, ɨ dɨde goro mor met wuswus rɨga yepim re jogjog gasa kɨma wekeny. Ra man ten obai tamneninyɨt, todaka opima mɨra obai motɨnenyi. Sɨ man re kemb mɨra yokasɨt. ");
INSERT INTO gdr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ajɨ ra man owou omnɨket diyamdiyamɨm, man b'ogla obai tamneninyɨt gasa kesa rɨga ɨ kobkob rɨga ɨ gomgom rɨga ɨ dɨde yɨrdɨdɨ rɨga. ");
INSERT INTO gdr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ra man odede mɨle omnɨket, God ma b'ogɨl re ɨta man kɨma, mop nokɨp ton ma rɨrɨr im men mɨra obai motɨnenyi. Ajɨ ɨdenate dem God mɨra motɨny, ra Ton negɨr kesa dɨmdɨmjog rɨga tutnɨkiny dem.” ");
INSERT INTO gdr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ɨ re onggɨt met obai rɨga wa wɨngɨrɨnd yɨpa rɨga onggɨtyam yɨt utkundonj, ton ket Yesund yomnonj da, “God ma b'ogɨl onggɨt rɨgam pɨlwa yet ra diyam tainy dem God ma pumb tunggɨnd.” ");
INSERT INTO gdr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ajɨ Yesu tin yɨsmonggawonj da, “Yɨpa rɨgat ukoi owou yomnɨkonj diyamdiyamɨm, sɨ ton re jogjog rɨga na obayɨm engaukinonj. ");
INSERT INTO gdr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ɨ re onggɨt diyamdiyam wɨn awonj, ton ket tina wɨko rɨga yɨtmɨkitonj ten wumɨr omnam yena re ton obayɨm engaukinonj da, 'Wɨn ket menonɨm! Komkesa gasa re ke ongonjeni im.’ ");
INSERT INTO gdr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ajɨ komkesa rɨga yɨpa wɨp opurena ke ognento da, ‘Sɨn ma rɨrɨr im menonɨm.’ Sɨ naskanyamɨt tin yomnonj da, ‘Wɨi, kear nomne! Kon ke yɨpa gou kɨpol yokasɨn. Sɨ kon amaemb neken onggɨt gou kɨpol yɨr ongongɨm.’ ");
INSERT INTO gdr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ɨ kwa yɨpat yomnonj da, ‘Wɨi, ukoi kear. Kon ke ten (10) kau akasinyɨn wɨko omnɨkam. Sɨ kon towaina wɨko otonkena ma neken. Sɨ kear nomne!’ ");
INSERT INTO gdr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ɨ dɨde kwa yɨpat yomnonj da, ‘Kon yu nat kongga kɨma aen. Sɨ onggɨt paemb kon ma rɨrɨr e neken.’ ");
INSERT INTO gdr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Seg ket onggɨt wɨko rɨgat ɨtendonj ti yonggyamɨm pɨlwa, ɨ ket wumɨr yomnenonj opimemb towaina mɨra gatab. Sɨ onggɨt wɨnɨnd, met yonggyam ma sobijog na soro awonj, dɨde ket tina wɨko rɨgand yomnonj da, ‘Otade man metkenyɨt ukoi nya nata ɨ sobijog nya nata onggɨt taun wɨngɨrɨnd. Ɨ man ket teyeninyɨt gasa kesa rɨga ɨ kobkob rɨga ɨ yɨrdɨdɨ rɨga ɨ dɨde gomgom rɨga.’ ");
INSERT INTO gdr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Re ket seg wɨko rɨgat ket ti yonggyamɨnd yomnonj da, ‘Yonggyam! Kon kea moina b'ingawa yɨt rɨrɨrɨnd amnɨkinyɨmɨn, ajɨ pɨpmet re opima komb omitam.’ ");
INSERT INTO gdr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ɨ yonggyam ket ti wɨko rɨgand yomnonj da, ‘Mekene nya nata ɨ wungawungapu tungg nata onggɨt taun bau ke! Ɨ rɨga danda kɨma ugongnena teyeninyɨt iyenam, nokɨm da ɨdenat koina met yɨndangɨr tainy! ");
INSERT INTO gdr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mop nokɨp kon wen wumɨr tamninyɨn da onggɨt rɨga wa wɨngɨrɨnd yena re kon engaukinond, towa wɨngɨrɨnd makwa ɨta yɨpat owou met otonkis dem koina diyamdiyampund.’” ");
INSERT INTO gdr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ɨ re ukoi rɨga bobo Yesu kɨma yɨpand menon yokato, Ton ket towa pɨlwa wɨp engendonj dɨde amninonj da, ");
INSERT INTO gdr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yet ra Kor pɨlwa ik Koina b'auyaena rɨga awowɨm, ton b'ogla Ken kupkakupka singi nitiyeny. Ajɨ ra ton tinajog b'u ake mog ɨ ti kongga dɨde ti b'ɨgawar ɨ dɨde ti nany dɨde yɨngganwar singi teyeniny, ɨ dɨde kwa ra ton tinajog yɨrkokar ukoi kana singi iyeny, ton makwa rɨrɨr e Koina b'auyaena rɨga awowɨm. ");
INSERT INTO gdr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ɨ kwa yet ra maka komkesa tinajog bebɨg takasiny Godɨm wɨkond odede rɨngma ra rɨgat tina wul b'agbag urowas ujɨm dɨde maka ra Ken yɨmta nutundok, ton makwa rɨrɨr e Koina b'auyaena rɨga awowɨm. ");
INSERT INTO gdr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ra wa wɨngɨrɨnd yɨpa rɨga singi tainy pumbpumb met orangam, rɨngma, ma awɨr e ton naska tomis ɨsamkam dɨde mɨra wulkɨp ogenka teyeniny nokɨm da rɨka ti rɨrɨr im wulkɨp onggɨt met undwatam? ");
INSERT INTO gdr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ɨ maka ra ton onggɨtyam mɨle omnɨk, ton rɨrɨr e rorte nena ɨtot teyeniny. Ɨ ra tinɨm maka ra rɨrɨr tainy met undwatam, komkesa rɨgap yepiya ra yɨr ongong iyenyi ɨtemb kombkomb met, ton ma sobijog yɨtkar kɨma e tin ngong engena iyenyi. ");
INSERT INTO gdr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ɨ rɨgap ɨja emb ket omnenyi da, ‘Onggɨt rɨgat ke pop met oranga yotomonj, ajɨ ti ma rɨrɨr na undwatam.’ ");
INSERT INTO gdr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O ra yɨpa king menon okas kwa yɨpa king kɨma geja b'iyenam, rɨngma, ma awɨr e ton naska tomis nɨnda tina geja mopyam kɨma, dɨde ton kɨma yɨt ɨgleneny, nokɨm da rɨka tina ten tausɨn (10,000) geja rɨga wa ɨta danda wɨp owarkitam opimemb twenti tausɨn (20,000) geja rɨga yepim re tinɨm gejam tui? ");
INSERT INTO gdr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ajɨ rada ton ma rɨrɨr e yɨr b'ang wɨp owarkitam ton kɨma gejayam king yete re paja wa yɨbɨm, sɨ onggɨt wɨn natemb ton nɨnda bageyam tetmɨkisiny yɨt iyenam ngɨmbla omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Sɨ onggɨt paemb odede yɨpa wɨp nya ke, wɨn b'ogla terarkindam komkesa wainajog gasa Koina b'auyaena rɨga awowɨm. Ajɨ maka ra, wɨn makwa rɨrɨr im Koina b'auyaena rɨga taukindam. ");
INSERT INTO gdr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Sol re b'ogɨl gasa e. Ajɨ ra sol solmet kesa tainy, sɨ rɨdede nya kae solmet kwa b'usaya tɨtenj? ");
INSERT INTO gdr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Onggɨtyam met kesa sol re ma rɨrɨr e ingawam gou sal omnɨkam dɨde sɨde b'ogɨl sal omnɨkam. Sɨ rɨgap opima onggɨtyam met kesa sol b'ɨskokenenanj. Yete re man wɨngawɨnga ke yɨpya kɨma, man utkunde!” ");
INSERT INTO gdr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ɨ yɨpa wɨnɨnd, komkesa teks imdayam rɨga dɨde negɨr mɨleyam rɨga tuwonj Yesum wuswus wa Tina yɨtkak utkundam. ");
INSERT INTO gdr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Sɨ Parisai rɨga dɨde Ju rɨga waina gog ouyaena rɨga yɨt b'ebongnento odede yɨt kɨma da, “Onggɨt Rɨgat negɨr mɨleyam rɨga im simesime amneniny dɨde ton kɨma yɨpand diyam ainy.” ");
INSERT INTO gdr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Sɨ Yesu towa usekawonj onggɨtyam tendam yɨt da, ");
INSERT INTO gdr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Rada wa wɨngɨrɨnd yɨpa rɨgam ɨbnainy wan andred (100) mamoi, ɨ yɨpa mamoi b'etɨdamkis, rɨngma, ma ton awɨr im nainti nain (99) mamoi dɨkɨnda wul kesa tunggɨnd yiyag tatkulisiny dɨde oraka iyeny ɨtemb yɨpa b'edamkiti mamoi ngɨrpu ra ket ton odar? ");
INSERT INTO gdr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ɨ ra ton ket odar, ton ket ma sobijog sam kɨma e onggɨt mamoyɨnd tina pokɨrɨnd b'ɨtangis ");
INSERT INTO gdr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","dɨde ket yii de met wa, ɨ dɨde ket ti rɨgawar dɨde ti wuswusam rɨga ara teainy, ɨ ngɨrpu ten tamniny da, ‘Wɨn kon kɨma sam yomnɨka, mop nokɨp kon kemb jɨ koina b'edamkiti mamoi yodaren.’ ");
INSERT INTO gdr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kon wen wumɨr tamninyɨn da, ‘Ra yɨpa negɨr mɨleyam rɨga tengenj tina negɨr mɨle ke Godɨm pɨlwa, God odede yɨpa wɨp nya kaemb ukoijog sam omnɨk pumb tunggɨnd, ajɨ ma Ton odede sam e yomnɨkeny negɨr kesa dɨmdɨmjog nainti nain (99) rɨga kɨma re dɨde yamim re awɨr negɨr mɨle Godɨm pɨlwa engendam.’ ");
INSERT INTO gdr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ɨ ra yɨpa konggam ten (10) silba koin ongapi tɨbnainy, ɨ ket yɨpa koin b'etɨdamkis, rɨngma, ma ton ɨta lampa enyoras, ɨ met ɨsagɨka iyeny, ɨ dɨde b'obogɨl kana oraka iyeny ɨtemb koin ngɨrpu ra ket ton odar? ");
INSERT INTO gdr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ɨ ra ton ket odar, ton ket ti rɨgawar dɨde ti wuswusam rɨga ara teainy odede yɨt kɨma da, ‘Wɨn kon kɨma sam yomnɨka, mop nokɨp kon kemb jɨ onggɨtyam koina b'edamkiti silba koin yodaren!’ ");
INSERT INTO gdr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kon wen wumɨr tamninyɨn da, ‘God odede yɨpa wɨp nya kaemb Tina aneru wa wɨpɨnd ukoi sam omnɨk, ra yɨpa negɨr mɨleyam tina negɨr mɨle ke tengenj Ti pɨlwa.’” ");
INSERT INTO gdr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ɨ dɨde Yesu kwa yɨpa tendam yɨt usekawonj da, “Yɨpa rɨgam yɨbnawonj re ti nɨmog rɨga b'ɨga na. ");
INSERT INTO gdr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ɨ yɨngganyam b'ɨgat ti b'und yomnonj da, ‘Abu! Kor nogoninem gasa rɨnsim re kor wulpok wekeny owabɨntam!’ Sɨ ti b'u ket tina gasa ti b'ɨga nɨmog wa ekalkainonj. ");
INSERT INTO gdr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ɨ ɨngkek ket yɨngganyam b'ɨga ma jog bibɨr na yɨbnonj, ajɨ ton kea nɨnda gasa asoginonj dɨde ket komkesa tina gasa atabɨkinonj iyoyɨm. Ɨ dɨde ton ket paja tungg wa menon yokatonj ngɨrpu opimemb tina gasa esomnena eyeninonj tina nenegɨr kana wɨmenand. ");
INSERT INTO gdr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ɨ re ton tina gasa komkesa esomnena seg amninonj, onggɨt eriyand ukoijog sou aukonj. Sɨ ɨdenatemb ket ton pajogɨnd awonj. ");
INSERT INTO gdr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Sɨ ton ket yikonj yɨpa rɨgam pɨlwa yet re yɨpa taunɨnd yɨbnonj onggɨt eriya wɨngɨrɨnd, dɨde ket ti pɨlwa b'ausɨkonj, ngɨrpu ket onggɨt met yonggyamɨt tin yɨtmɨkitonj tina sopapu tungg wa b'om ongenam. ");
INSERT INTO gdr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ɨ ton re ma sobijog na owoupa yɨbnonj, sɨ ton ket singi aukenonj gujo puka ke ngor awowɨm rɨna re b'omɨp awenento, ajɨ makwa ngai yɨpa rɨgat ti yokawonj owowɨm. ");
INSERT INTO gdr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Sɨ ton tilenggyam ti nony mana yindonj da, ‘Kor b'uɨm jogjog im namb ti mɨra kɨma wɨko rɨga yepim re owou oraka kesand wekeny, ajɨ ɨt re dɨkɨnd ke kon ukoijog owoupa map uj rawɨn. ");
INSERT INTO gdr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Sɨ kon tutnyisɨn, ɨ neken kor b'uɨm tungg wa, ɨ dɨde ket tin omnyɨn odede da, “Abu! Kon kea negɨr mɨle yomnɨkond wub kumb rɨgam pɨlwa dɨde mor pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Sɨ kon re ma rɨrɨrkɨpjog rɨga en moina b'ɨga ogenayam. Sɨ man ken yɨpa mɨra kɨma wɨko rɨga pɨla notɨnyɨt.” ’ ");
INSERT INTO gdr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Seg ton ket utnyitonj dɨde ket ti b'u re menon yokatonj. Ɨ re ton paja tungg ke ikonj ti b'uɨm pɨlwa, ti b'u kea tin pajapaja yɨr yongonj, dɨde tin ma sobijog na gar ke kear yomnonj. Sɨ ton b'ɨkonj ti b'ɨgam pɨlwa dɨde yɨm ke tin yogawɨntonj kunand, ngɨrpu ket tin yomongnenonj. ");
INSERT INTO gdr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ɨ ti b'ɨga ti b'und yomnonj da, ‘Abu! Kon kea negɨr mɨle yomnɨkond wub kumb rɨgam pɨlwa dɨde mor pɨlwa. Sɨ kon re ma rɨrɨrkɨpjog rɨga en moina b'ɨga ogenayam.’ ");
INSERT INTO gdr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ajɨ ti b'u ket tina wɨko rɨga amninonj da, ‘Wanaka, wɨn b'ogɨljogyam pɨnpɨn kobɨrgɨm itiyawa, ɨ ket tin yikita! Ɨ ringi tina ekakɨnd yikita, dɨde yongɨnkak tina pɨsɨnd yikoka! ");
INSERT INTO gdr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ɨ gayagaya kau b'ɨga iya dɨde onganjya. Sɨ men diyamdiyam im taindam, dɨde ukoi sam omnɨku. ");
INSERT INTO gdr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mop nokɨp ɨtemb koina b'ɨga re uj wɨngɨr nat yɨbnyɨm, ajɨ ton b'usaya kemb yilo yokas. Ton re b'edamkiti na yɨbnyɨm, ajɨ yu ke openj.’ Sɨ ton ket mɨle yotomo sam kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ajɨ tina nanyamyam b'ɨga re sopapu wa na yɨbnonj. Sɨ re ket ton ɨtendonj met wa, ɨ dɨkɨnda ket ton met wusɨnd utkundenonj guglam rɨna re rɨgap ɨpaya gasa ara epaito dɨde omarkɨto met wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ɨ ket ton ara yɨawonj yɨpa wɨko rɨga, ɨ dɨde ton yɨgekitonj da, ‘Nangga e awɨk?’ ");
INSERT INTO gdr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ɨ ton ket tin yɨsmonggawonj da, ‘Mor yɨngganɨt ik, ɨ mor b'u ke yongandau yɨpa gayagaya kau b'ɨga sam omnɨkam, mop nokɨp ton mor yɨngganɨnd yokas re ma aengneni na.’ ");
INSERT INTO gdr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ɨ ton ket ukoi soro na awonj, sɨ ton b'ɨsayonj met wɨngɨr wa b'ɨgaram. Ajɨ ti b'u met wɨngɨr ke opmarkitonj, dɨde ti b'ɨgand ngɨmbla omnam yugowonj. ");
INSERT INTO gdr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ajɨ ti b'ɨga ti b'und mɨra yomnonj da, ‘Yɨr de, kon ma yɨpa kemag kɨma na b'asowa netkɨmɨn mornɨm wɨko omnɨkam, dɨde kon makwa ngai moina b'ingawa yɨt arbekeninyɨmɨn. Ajɨ man makwa ngai yɨpa sobijog gout nokaumɨt, nokɨm da ɨdenat kon sam omnɨken yɨpand kor rɨgawar kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ajɨ re jɨ onggɨtyam moina b'ɨga ik tungg wa, yet re yiyagyiyag iyenapu kongga kɨma moina gasa asomneneninonj, nangga pae man ket ti map gayagaya kau b'ɨga yonganjɨt?’ ");
INSERT INTO gdr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ajɨ ti b'u tin yomnonj da, ‘Kor b'ɨga! Man re ɨta ita wɨnɨnd dɨkɨnd kon kɨma, ɨ komkesa koina gasa re mor mima. ");
INSERT INTO gdr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ajɨ men b'ogla wɨbawɨba taindam dɨde ukoi sam omnɨku, mop nokɨp ɨtemb mor yɨnggan re uj wɨngɨr nat yɨbnyɨm, ajɨ ton re ke yilo yokas. Ton re b'edamkiti na yɨbnyɨm, ajɨ yu ke openj.’” ");
INSERT INTO gdr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ɨ Yesu ket Tina b'auyaena rɨga amninonj da, “Yɨpa jogjog gasa kɨma rɨgam re kea yɨpa met yɨr ɨpka mopyam wɨko rɨga yɨbnawonj. Ɨ rɨgap onggɨt met yonggyamɨnd wumɨr yomno odede da, ‘Onggɨt met yɨr ɨpka mopyam wɨko rɨgasim asomneniny moina gasa.’ ");
INSERT INTO gdr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Sɨ met yonggyam ket tin ara yemokonj, ɨ yomnonj da, ‘Kon ke mor gatab yɨt utkundenyɨn, sɨ rɨdede na man odede mɨle yomnɨket? Sɨ man kikitumam moina wɨko gatab tagenkinyɨt rɨna re kon mingaenond omnɨkam, mop nokɨp man ma rɨrɨr e ket b'usaya onggɨtyam met yɨr ɨpka mopyam wɨko rɨga mɨtɨbnyɨt.’ ");
INSERT INTO gdr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Sɨ onggɨt met yɨr ɨpka mopyam wɨko rɨgat ti nony mana yindonj da, ‘Nangga e ket kon omnɨken, mop nokɨp kor yonggyam kanaemb ken onggɨtyam met yɨr ɨpka mopyam wɨko ke netwaikis? Kon ma naemb danda en sopapu wɨko omnɨkam, ɨ kwa kon ɨngar en rɨga wa pɨlwa b'ɨtenam. ");
INSERT INTO gdr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kon wumɨr en nangga e kon omnɨken kolenggyam yɨr b'ɨpkam, nokɨm da ɨdenat ken rɨgap simesime notɨnenyi towaina met nata, ra kon onggɨt met yɨr ɨpka mopyam wɨko ke tewaikisɨn.’ ");
INSERT INTO gdr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Seg ton rɨga yɨpayɨpa ara emokinonj ya mana re abitoro gasa ebnauto ti yonggyamɨm pɨlwa, ɨ ton ket naskanyam meni rɨgand yɨgekitonj da, ‘Leamog abitoro gasa im mor mɨbnainy kor yonggyamɨm ɨtendam?’ ");
INSERT INTO gdr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ɨ ton ket mɨra yomnonj da, ‘Kor abitoro nɨbnainy re wan andred (100) olib gaya dramkak im tinɨm okawam.’ Sɨ onggɨt mopyam wɨko rɨgat ket tin yomnonj da, ‘Yokate moina abitoro peba, dɨde wanaka tomisɨt, ɨ dɨde ket ɨrɨket pipti (50) dramkakɨm.’ ");
INSERT INTO gdr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ɨ kwa onggɨtyam mopyam wɨko rɨgat nɨmogɨm meni rɨgand yɨgekitonj da, ‘Leamog abitoro gasa im modaka mɨbnainy ɨtendam?’ Ɨ ton ket tin mɨra yomnonj da, ‘Wan andred (100) wit kɨp baiko im.’ Sɨ ton ket tin yomnonj da, ‘Yokate moina abitoro peba, ɨ ɨrɨket eiti (80) baikom.’ ");
INSERT INTO gdr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ɨ re met yonggyam utkundonj onggɨtyam kaokao b'anygɨnena met yɨr ɨpka mopyam wɨko rɨgamna mɨle, ton tin yesoulitonj, mop nokɨp ton b'ogɨl multekɨp kena wɨko yomnɨkonj tilenggyam yɨr b'ɨpkam. Sɨ onggɨt gowukoyɨmna kaokao mɨle rɨgap re odede b'ogɨl multekɨp kɨma im wɨko omnɨka eyenanj towalenggyam yɨr b'ɨpkam. Ajɨ ngayamna rɨgap towalenggyam yɨr b'ɨpkam wɨko omnɨka eyenanj gowukoi wɨmena wɨngɨrɨnd re ma odede b'ogɨljog im opi re onggɨt gowukoyɨmna kaokao mɨle rɨga re dɨde. ");
INSERT INTO gdr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Sɨ kon wen tamninyɨn. Wɨn b'ogla onggɨtyam gowukoi gasa tengaindam, dɨde ɨngkaimemb rɨga rɨgarɨga tamnenindam wanɨm yɨr b'ɨpkam. Nokɨm da ɨdenat ton wen simesime tamnenanj dem de ngɨrpu kesa pɨpmet wa, ra dem onggɨtyam gowukoi gasa wanɨm ingaena kesa taukanj dem. ");
INSERT INTO gdr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Yet ra sobijog gasa ingaenand nony ɨjai rɨga ɨbɨm, ton b'ogla jogjog gasa ingaenand kwa nony ɨjawa rɨga tainy. Ɨ yet ra sobijog gasa ingaenand kaokao b'anygɨnena mɨle rɨga ɨbɨm, ton b'ogla jogjog gasa ingaenand kwa kaokao b'anygɨnena mɨle rɨga tainy. ");
INSERT INTO gdr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Sɨ onggɨt paemb ra wɨn maka onggɨtyam gowukoi gasa ingaenand nony ɨjai rɨga taukindam, sɨ yete ket wen nony tejainy ɨmɨnjog gasa ingaenam de pumb tungg wa? ");
INSERT INTO gdr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ɨ ra wɨn maka yɨpa rɨgamna gasa ingaenand nony ɨjai rɨga taukindam, yete ket wa tagoniny pumb tungg b'ogɨl gasa wainajogɨm owabɨntam? ");
INSERT INTO gdr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Makwa yɨpa met wɨko rɨgat rɨrɨr e nɨmog yonggyam wa wɨko tamnɨkainy. Mop nokɨp ton yama rɨka yɨpa yonggyamɨnd singi kesa e omneny dɨde kwa yɨpa yonggyamɨnd ra singi e iyeny, o ton yama rɨka yɨpa yonggyamɨnd ɨsnawa e iyeny, dɨde kwa ra yɨpa yonggyamɨnd ɨsnawa kesa e omneny. Sɨ onggɨt paemb wɨn ma rɨrɨr im wɨko rɨga taukindam nɨmognɨmog, Godɨm dɨde onggɨt gowukoi gasam.” ");
INSERT INTO gdr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ɨ Parisai rɨga re wulkɨp singisingi rɨga na, sɨ re ton onggɨtyam komkesa yɨtkak utkundento, ton ma sobijog na Yesund ngong yengeno. ");
INSERT INTO gdr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Sɨ Yesu ket ten amninonj da, “Wɨn opi namb jɨ rɨga yepim re walenggyam rɨga wa wɨpɨnd negɨr kesa dɨmdɨmjog rɨga nyɨ ke b'agenaindam. Ajɨ God wumɨr e waina gar, mop nokɨp Ton soro kaim amneniny nanggamog im re rɨgap ɨsnawa eyenanj gowukoi rɨgaina nony menamena nya ke. ");
INSERT INTO gdr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ɨ God singi na da rɨga wɨmena tuweny gog yɨt dɨde bageyam waina ɨrɨki yɨtkak rɨrɨrɨnd, ngɨrpu Yoan re wɨko yotomonj. Ajɨ onggɨt kak ke God ma pumb tunggɨmna b'ogɨl yɨrkokar bage yɨt kea pɨtapɨta aena yikeny, sɨ komkesa rɨga re danda e ondratena yiyenyi b'ɨgarenam. ");
INSERT INTO gdr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ajɨ ɨtemb re wewa e wub ake gou b'eomnenam, ajɨ gog yɨtɨm pɨlke makwa ɨta yɨpa ɨrɨki o yɨpa ɨrɨki mal b'eteomneny, ɨtemb re bebɨg e. ");
INSERT INTO gdr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Sɨ yet ra ti konggand bondɨk tomɨny dɨde yɨpa b'enga konggand tokas ti konggam, sɨ ton re gigɨr dɨde yɨgyɨg b'iyena mɨle e omnɨka yiyeny onggɨt sisɨl kongga kɨma. Ɨ daka yet ra onggɨt konggand tokas ti konggam yet re ti leond bondɨk yomnonj, todaka gigɨr dɨde yɨgyɨg b'iyena mɨle e omnɨka yiyeny onggɨt kongga kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ɨ yɨpa jogjog gasa kɨma rɨga yɨbnonj, ɨ ton b'ogɨl kuskus uwaluwal kobɨrgɨm dɨde otomanti ngɨmblakak kobɨrgɨm b'ikoki awameneninonj, ɨ dɨde ton b'ogɨl wulkɨp darɨnd ukoi sam kɨma yɨbnɨkenenonj. ");
INSERT INTO gdr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ajɨ kea yɨpa gasa kesajog rɨga yɨbnonj nyɨ da Lajaro, sɨ rɨgap re kea tin yoramiteneno onggɨtyam jogjog gasa kɨma rɨgamna met mora dundand, nokɨp ton re jogjog wai ke ɨkangɨndi na yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ɨ ton singi na da ngor okateny onggɨt jogjog gasa kɨma rɨga ma owou komb ke rɨna re ton b'ɨskokeneninonj tina owoupu kasa kumb ke. Ajɨ yongg kea kwa tina wai ɨsenenam wuwenenonj. ");
INSERT INTO gdr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ajɨ re ket gasa kesa rɨga uj awonj, ɨ ket anerup yɨm tɨtɨk yiyo pumb tungg wa de Abraamɨmna oskak kumb wa oramitam. Ɨ toda kwa kea onggɨt jogjog gasa kɨma rɨga uj awonj dɨde yeungito. ");
INSERT INTO gdr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ɨ re ton wul tungg wa ukoi b'ɨdgotnenand yɨbnenonj, ton yɨr b'ɨskonj pumb wa, ɨ kea ket pajapaja yɨr angonj Abraam dɨde Lajaro ti oskakɨnd omiti. ");
INSERT INTO gdr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Sɨ ton ket Abraamɨnd ara yɨawonj da, ‘Abu Abraam! Kear nomne-o! Ɨ man Lajarond yɨtmɨkite kor pɨlwa, nokɨm da ɨdenat ton yɨm pumam petɨr nyɨ wa ɨsongg dɨde koina weyatɨnd oramis ngɨmbla omnam, mop nokɨp kon ma sobijog kopa b'angnena wɨngɨr nate nɨbnyɨn onggɨtyam wul dɨmɨl borand.’ ");
INSERT INTO gdr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ajɨ Abraam daka ket tin yɨsmonggawonj da, ‘Kor b'ɨga! Man nony ae de re man akateninot b'ogɨl gasa moina yɨrkokar wɨmena wɨngɨrɨnd de gowukoi wa, ajɨ demb de Lajaro akateninonj re negɨrjog gasa na. Sɨ ton ket yu b'ogɨl sam wɨn e yokateny dɨkɨnd, ajɨ man re ukoijog kopa b'angnena wɨngɨr nate mɨbnyɨt. ");
INSERT INTO gdr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ɨ ma onggɨtyam gasa nena im, ajɨ God kea yɨpa ukoijog kunɨnkunɨn get yoramitonj sɨn dɨde wɨn ganggand, nokɨm da ɨdenat ton maka rɨrɨr taenanj opandenam yepiya ra singi taenanj ɨngkek ɨjendam de waina tab wa, ɨ daka waina tab ke ɨjendam de sowaina tab wa.’ ");
INSERT INTO gdr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Sɨ ton ket Abraamɨnd yomnonj da, ‘Abu! Ra odede ra, sɨ kon men metɨrkisɨn da man b'ogla Lajarond ɨtmɨkisɨt kor b'u ma met wa de gowukoi wa. ");
INSERT INTO gdr_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mop nokɨp demb de kor opima paib (5) nany dɨde yɨngganwar. Sɨ Lajaro b'ogla towanɨm pɨtapɨta ramnenain onggɨt wul tungg gatab, nokɨm da ɨdenat toda kwa maka tui dem dɨkɨnd onggɨt ukoi b'ɨdgotnenapu pɨpmet wa.’ ");
INSERT INTO gdr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ajɨ Abraam yɨsmonggawonj da, ‘Demb de opima Mosemna ɨrɨki yɨtkak dɨde bageyam waina ɨrɨki yɨtkak. Sɨ ton ɨnaemb rutkundeninem onggɨtyam towaina yɨtkak.’ ");
INSERT INTO gdr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ajɨ todaka yomnonj da, ‘Nayɨ, abu Abraam! Ajɨ b'ogla ra yɨpa rɨga uj rɨga wa wɨngɨr ke yik towa pɨlwa, ton opima ket negɨr mɨle ke tengendanj de Godɨm pɨlwa.’ ");
INSERT INTO gdr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ajɨ Abraam daka tin yomnonj da, ‘Ra ton maka ra tutkundenanj Mosemna ɨrɨki yɨtkak dɨde bageyam waina ɨrɨki yɨtkak wa pɨlɨnd, sɨ nangga ma jɨ rada yɨpa rɨga uj ke tutnyis, ton makwa opima gar ke utkunda ke takatenanj tina yɨtkak.’” ");
INSERT INTO gdr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ɨ Yesu Tina b'auyaena rɨga amninonj da, “Opima onggɨtyam mɨle tui rɨnsim ra negɨr mɨle omnɨkam rɨga tatonkenanj. Ajɨ God ma sake ɨta onggɨt rɨgam pɨlɨnd yet ra odede mɨle tamnɨkiny. ");
INSERT INTO gdr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Sɨ ɨtemb re b'ogɨljog e tinɨm, rako rɨgap tina kunakakɨnd ukoi gɨmo danda kɨma yɨjobɨko kai ke dɨde yɨsko ukoi sɨpa nyɨ bora wa ujɨm, ajɨ ɨtemb re ma b'ogɨljog e, rako ton onggɨt sobijog rɨga wa wɨngɨrɨnd yɨpa rɨgand negɨr mɨle omnɨkam yingawonj. ");
INSERT INTO gdr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Sɨ wɨn walenggyam yɨr b'ɨpkinam! Rada yɨpa moina gar ke utkunda nanyɨt o yɨngganɨt negɨr mɨle omnɨk, tin samany iyowet. Ɨ ra ton tina negɨr mɨle ke tengenj Godɨm pɨlwa, man b'ogla tina negɨr mɨle awɨr omnainyɨt. ");
INSERT INTO gdr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ɨ ra ton yɨpa bibɨrɨnd sebenpyam negɨr mɨle tamnɨkiny mor pɨlwa, dɨde kwa sebenpyam mor pɨlwa tɨtendeny men omnam da, ‘Kon ke negɨr mɨle ke engenjɨn Godɨm pɨlwa, sɨ koina negɨr mɨle awɨr nomnaine,’ sɨ man b'ogla tina negɨr mɨle awɨr omnɨkaeneninyɨt.” ");
INSERT INTO gdr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sɨ ɨtmɨkitijog rɨgap ket Yonggyamɨnd yomno da, “Sowaina gar ke utkunda b'usaya pɨnjog amnine!” ");
INSERT INTO gdr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ɨ Yonggyam ket ten amninonj da, “Ra wa odede sobijog gar ke utkunda tebnainy mastad tuny re dɨde, sɨ wɨn rɨrɨr im onggɨtyam manggo wulɨnd omnya da, ‘Man ap kɨma b'uromate, dɨde b'ɨtlisɨt de sɨpand'. Ɨ ton ɨta wen yɨt tutkunjiny. ");
INSERT INTO gdr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Rada wa wɨngɨrɨnd yɨpa rɨgam yɨpa wɨko rɨga ɨbnau, ɨ ra ton gou oska iyeny o mamoi yɨr ɨpka teyeniny, sɨ ra ket ton sopapu ke tɨtenj met wa, rɨngma, ɨta ti yonggyam tin omɨny da, ‘Otade, metkɨm, ɨ omite diyam awowɨm'? ");
INSERT INTO gdr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nayɨ, ma ɨja e. Sɨ rɨngma, ma awɨr e tin omɨny da, ‘Man be nanggamog owou na ngai nongonjenae diyam awowɨm, ɨ man ɨja na b'obogɨl b'angonjeni yɨr netngenjɨt ngɨrpu ra kon owou dɨde onaya seg taen, ɨ onggɨt seg ke toko madaka owou yowe dɨde nyɨ yonae'? ");
INSERT INTO gdr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ɨ ɨta ti yonggyam ti wɨko rɨgand sɨteket yɨt omɨny, nokɨp ton kea tina b'ingawa rɨrɨrɨnd gasa amnɨkiny? ");
INSERT INTO gdr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ɨ wɨda kwa b'ogla odede yɨpa wɨp mɨle tamnɨkindam. Sɨ ra wɨn komkesa gasa tamnɨkindam rɨna re wen wa Yonggyam engaeninonj omnɨkam, sɨ wɨn b'ogla tendenindam da, ‘Sɨn re esourena kesa wɨko rɨga im, ajɨ sɨn ɨnsima amnɨkindam wɨko rɨnsim re sɨn b'ogla omnɨkam.’” ");
INSERT INTO gdr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ɨ re Yesu menon yokatonj Yerusalem taun wa, Ton yikonj re Samariya eriya dɨde Galili eriya ɨnyɨny gangga nat. ");
INSERT INTO gdr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ɨ re Yesu sisɨl b'ɨgaram awonj yɨpa tungg wa, nyawɨnd ten (10) leprosi kopa rɨgap kea Tin paja ke yɨr yongo, ɨ dɨkɨnda ta owɨnkɨto. ");
INSERT INTO gdr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Seg ton b'okta ara wuwenonj da, “Ukoyam Yesu-wɨi! Sɨn kear nomninem-o!” ");
INSERT INTO gdr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ɨ re Yesu ten yɨr anginonj, Ton ten amninonj da, “Wɨn wuwe waina jɨ ouyawam de yɨna sɨ rɨga wa pɨlwa!” Sɨ re ton ket menon yokato, nyawɨnd ton kea kɨlkɨp kesa aukɨto. ");
INSERT INTO gdr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ajɨ onggɨt ten (10) rɨga wa wɨngɨrɨnd, re yɨpa rɨgat ton b'ɨsakendi yɨr b'angonj, ton ket Godɨnd ma sobijog na auwam kɨma esourena yiyonj, ngɨrpu ket ɨtendonj Yesum pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Seg ton ukoi ɨsnawa kɨma Yesum wɨpɨnd sap otendonj Tin sɨteket yɨt omnena kɨma. Ɨ ton re Samariya rɨga na. ");
INSERT INTO gdr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Sɨ Yesu samany kɨma yindonj da, “Ma komkesa ten (10) rɨga na kɨlkɨp kesa auranj? Ropim daka onggɨtyam nain (9) kombyam rɨga? ");
INSERT INTO gdr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Rɨngma, ma onggɨtyam Samariya kus rɨga nenat ɨtenj Godɨnd esourenam, ɨ sɨteket yɨt yomneny?” ");
INSERT INTO gdr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ɨ Yesu ket tin yomnonj da, “Utnyite, ɨ meke! Moina gar ke utkundat kemb yɨrkokar mor mokau.” ");
INSERT INTO gdr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ɨ nɨnda Parisai rɨgap Yesund yerkito da, “Rɨe God ma pumb tungg ik?” Sɨ Yesu daka ten ket mɨra amninonj da, “God ma pumb tungg ik ra ma odede nya kae rɨja im re rɨgap gasa yɨr ongong eyenanj towaina yɨrkɨp ke. ");
INSERT INTO gdr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ɨ rɨgap ma rɨrɨr im odede tapurenanj da, ‘Yɨr de ɨte ta God ma pumb tungg' o ‘Yɨr de ama ta pumb tungg,’ mop nokɨp God ma pumb tungg re wa wɨngɨr nate yɨbɨm.” ");
INSERT INTO gdr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ɨ Ton ket Tina b'auyaena rɨga amninonj da, “Wɨn singi ainindam wanaka onggɨtyam bibɨr yɨr ongongɨm Rɨgamna B'ɨga ma bibɨr wɨngɨrɨnd. Onggɨtyam wɨn ɨta jɨ ik dem, ajɨ wɨn ma ɨta yɨr ongya dem waina yɨrkɨp ke. ");
INSERT INTO gdr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ɨ rɨgap opima wen tamnenanj dem da, ‘Yɨr de, ama ta Ton!’ o ‘Yɨr de ɨte ta Ton!’ Ajɨ wɨn goro towaina yɨt gar ke takateninam dem, ɨ goro towa pɨlwa tuwenɨm, ɨ dɨde goro ten yɨmta tundoneninam dem! ");
INSERT INTO gdr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mop nokɨp ra Rɨgamna B'ɨga tɨtenj Tina bibɨrɨnd, Ton ɨja e wɨp tainy dem rɨngma re waral opngɨndeneny yɨpa wub gatab ke de kwa yɨpa gatab wa, sɨ rɨgap rɨrɨr e tina ɨnyomarena pɨtand yɨpapyam yɨr ongong iyenyi dem. ");
INSERT INTO gdr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ajɨ Ton b'ogla naska jogjog b'ɨdgotnena rakasin dɨde rɨga wa pɨlke b'ɨsaya yakaten yepim re yu wekeny onggɨt gowukoyɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Sɨ ra Rɨgamna B'ɨga tɨtenj Tina bibɨrɨnd, sɨ ɨja ima mɨle taukanj dem rɨja na re mɨle aukɨto Nowam wɨnɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sɨ Nowam wɨnɨnd rɨga odede mɨle nat wekenonj opi re owowɨnd ɨ onaikand ɨ kongga imdand ɨ dɨde leo imdand, ngɨrpu onggɨt bibɨrɨnd re Nowa gɨga wa b'ɨgaronj. Ɨ ɨngkek ket ngɨwɨr ikonj dɨde ket komkesa rɨga negɨr amnɨkinonj. ");
INSERT INTO gdr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ɨ kwa Rɨgamna B'ɨga ma bibɨr wɨngɨrɨnd ɨja ima jɨ mɨle taukanj dem odede yɨpa wɨp rɨja na re mɨle aukɨto Lotɨmna bibɨr wɨngɨrɨnd re dɨde. Lotɨmna wɨnɨnd rɨga odede mɨle nat wekenonj opi re owowɨnd ɨ onaikand ɨ gasa imdand ɨ gasa b'asogand ɨ nangg ɨtotɨnd ɨ dɨde met orangand. ");
INSERT INTO gdr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ajɨ onggɨt bibɨrɨnd re Lot Sodom taun yɨraronj, wul dɨmɨl dɨde masis pɨla sɨngba kɨma negɨr guda kɨma gasa salpa gɨmo ngɨndngɨnd kana piro pɨla ɨsokto wub kumb ke, ngɨrpu ket komkesa rɨga negɨr amnɨkinonj. ");
INSERT INTO gdr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Sɨ odede wɨp imemb mɨle taukanj onggɨt bibɨrɨnd rɨdenat ra Rɨgamna B'ɨga pɨta tainy dem. ");
INSERT INTO gdr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Sɨ onggɨt bibɨrɨnd yet ra ton ɨbɨm wɨmenam met papkak kumbɨnd, sɨ rada tina gasa met wɨngɨr wa im tekeny, ton goro kwa rapin dem onggɨtyam gasa imdam. Ajɨ ton wanakana b'ek dem. Ɨ kwa odede yɨpa wɨp nya ke yet ra ɨbɨm dem sopapund, toda goro kwa rɨtend dem met wa tina gasa imdam. Ajɨ ton wanakana b'ek dem. ");
INSERT INTO gdr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Sɨ wɨn nonyɨk b'amjina Lotɨmna kongga gatab! ");
INSERT INTO gdr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ɨ yet ra tilenggyam yɨrkokar yɨrgong omnɨka iyeny, ton ɨta onggɨtyam tina yɨrkokar dadal edamkis dem. Ajɨ yet ra tina yɨrkokar edamkis, ton ɨta tina yɨrkokar yilom omɨny dem. ");
INSERT INTO gdr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kon wen wumɨr tamninyɨn. Onggɨt sɨwɨnyɨnd ra nɨmog rɨga yɨpaina darɨnd gɨlgɨl tegya dem, God yɨpand ɨta yii dem pumb wa, ɨ daka yɨpand ɨndama ɨrar dem. ");
INSERT INTO gdr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ɨ kwa ra nɨmog kongga yɨpand sana ɨkmɨkand tebnya dem, God yɨpand ɨta wii dem de pumb wa, ɨ daka yɨpand ɨndama tɨrar dem.” ");
INSERT INTO gdr_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(Awɨr e) ");
INSERT INTO gdr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ɨ Yesumna b'auyaena rɨgap Tin yerkito da, “Yonggyam! Rokatemb jɨ onggɨtyam mɨle tawɨk dem?” Ɨ Ton ten kikitum b'ɨsagɨka gatab tendam yɨt ke amninonj da, “Rokate ra ujgɨm ɨbɨm, yimbyak toda ɨndamima bobo taukanj.” ");
INSERT INTO gdr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ɨ Yesu Tina b'auyaena rɨga tendam yɨt ke amninonj, nokɨm da ɨdenat ton ita wɨnɨnd yɨr topmitenenanj, ɨ ɨdenat kwa maka gar ke utkundand danda kesa taukenenanj. ");
INSERT INTO gdr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Yɨpa taunɨnd yɨpa b'ɨsagɨka rɨga yɨbnonj yet re maka Godɨnd moga yuwadenenonj dɨde maka rɨga esnaeneninonj. ");
INSERT INTO gdr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ɨ kea de yɨpa mik kongga wɨbnonj onggɨt taunɨnd, ɨ ton kea sɨram b'ɨrari kesa onggɨt b'ɨsagɨka rɨgand erkenam yopenenonj odede yɨt kɨma da, ‘Koina geja rɨgat kaokao nya kae negɨr nomneneny. Sɨ man yɨm nokae, ɨ kor bebɨg awɨr nomnae!’ ");
INSERT INTO gdr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ajɨ ton kea naska nɨnda wɨnɨnd b'ɨsaenenonj onggɨtyam mikɨmna b'arkita gatab. Ajɨ kikitumpu wa ton ket ti nony mana yindonj da, ‘Kon ma ɨta Godɨnd moga yuwadenenyɨn dɨde kwa kon ma opima rɨga esnaeneninyɨn. ");
INSERT INTO gdr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ajɨ onggɨt mik konggato ken sɨram b'ɨrari kesa b'ogɨl wɨmenand nɨsakaureneny. Sɨ mobe kon b'ogla tina bebɨg awɨr omnam dɨmdɨm wamnɨkawɨn. Nokɨm da ɨdenat ton maka tina sɨram b'ɨrari kesa menimenip gɨm dɨnderkak notɨnkeneny.’” ");
INSERT INTO gdr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ɨ kwa Yonggyam yindonj da, “Wɨn utkundam nanggamog e re onggɨt kaokao b'ɨsagɨka rɨgat yindeny. ");
INSERT INTO gdr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Sɨ rɨngma, ma ɨta God Tina obagɨki rɨgaina bebɨg awɨr omnam gasa dɨmdɨm tamnɨkainy yepiya ra ita bibɨr dɨde sɨwɨny nyɨ uwatenenyi? Ɨ rɨngma, ma ɨta Ton wanaka ten mɨra tamniny? ");
INSERT INTO gdr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kon nitinjɨn da God opima wanakana ten mɨra tamniny. Ajɨ ra Rɨgamna B'ɨga tɨtenj dem, rɨka Ton rɨrɨr e odaram odede wɨp gar ke utkunda mɨle onggɨt gowukoyɨnd? Nayɨ, ma ɨta.” ");
INSERT INTO gdr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ajɨ daka Yesu nɨnda rɨga tendam yɨt ke amninonj yepiya re towalenggyam ɨmɨnjog aento da ton re negɨr kesa dɨmdɨmjog rɨga im, dɨde kwa rɨga yɨrɨk esaenento. ");
INSERT INTO gdr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Nɨmog rɨga ekonda yɨnamet wa yɨr opmitam, yɨpa re Parisai rɨga na ɨ yɨpa kwa re teks imdayam rɨga na. ");
INSERT INTO gdr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ɨ onggɨt Parisai rɨgat tinta pɨpmet wa onyitonj, ɨ ket odede yɨr opmitonj da, ‘God! Kon Men sɨteket yɨt momnyɨn nokɨp kon ma odede rɨga en opi re nɨnda rɨga re dɨde, raskol rɨga, kaokao negɨr mɨle rɨga, gigɨr dɨde yɨgyɨg b'iyena rɨga, o kwa ɨte odede teks imdayam rɨga. ");
INSERT INTO gdr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ɨ kon kwa owou uwabɨka wɨn yokatenenyɨn re nɨmogpyam i ita sande wɨngɨrɨnd. Ɨ dɨde kwa kon ɨta ket ten (10) bobond akalkeneninyɨn komkesa gasa rɨnsim re kon akateneninyɨn, ɨ Mornɨm onggɨtyam ten (10) bobo wɨngɨrɨnd yɨpa bobo wulpok momnɨkenenyɨn.’ ");
INSERT INTO gdr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ajɨ teks imdayam rɨgat, ton onyitonj re paja wa na dɨde makwa wɨp pumb wa b'urowatonj, ajɨ ton ɨna tina dorkak nena gar kopa kɨma yodowatenonj odede yɨt kɨma da, ‘God! Kear nomne! Kon re negɨr mɨle rɨga en.’ ");
INSERT INTO gdr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kon wen wumɨr tamninyɨn da onggɨtyam teks imdayam rɨgam re Godɨt negɨr kesa dɨmdɨmjog rɨga nyɨ yokawonj, ɨ ton yikonj tina met wa. Ajɨ God maka onggɨt Parisai rɨgam yokawonj negɨr kesa dɨmdɨmjog rɨga nyɨ. Mop nokɨp yet ra tilenggyam pumb wa b'uturowateny, God ɨta tin gou wa omneny, ajɨ yet ra tilenggyam gou wa aena ikeny, God ɨta tin pumb wa urowateny.” ");
INSERT INTO gdr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ɨ ket rɨgap towaina papa b'ɨga daka Yesum pɨlwa eyento odede nony kɨma da Yesu ten tasopainy b'ogɨl omnam. Ɨ re Tina b'auyaena rɨgap onggɨtyam mɨle yɨr yongo, ton kea ket ten samany kɨma rɨga ogoka eyento b'ɨga iyenam Yesum pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ajɨ Yesu opimemb rɨga ara emokinonj yepiya re b'ɨga teito, ɨ ket daka Tina b'auyaena rɨga amninonj da, “Tou b'ɨga sobijog Kor pɨlwa. Goro b'ɨga ogoka eyenindam, mop nokɨp odede b'ɨga wa maemb jɨ God ma pumb tungg.” ");
INSERT INTO gdr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Kon ɨmɨnjog wen wumɨr tamninyɨn da yet ra maka ra God ma pumb tungg ɨmɨnjog ke okas odede b'ɨga sobijog re dɨde, ton makwa ɨta b'ɨtgarɨk dem onggɨt pumb tungg wa. ");
INSERT INTO gdr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ɨ yɨpa Ju rɨga waina mopyam rɨgat Yesund yɨgekitonj da, “B'ogɨl Ouyaena Rɨga-wɨi! Nangga e kon omnɨken dadal ngɨrpu kesa yɨrkokar owabɨntam?” ");
INSERT INTO gdr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ajɨ Yesu tin mɨra yomnonj da, “Nangga pena man Ken nogenaet da b'ogɨl rɨga? Makwa ɨta yete b'ogɨl rɨga ajɨ Godta tinta yɨpaina. ");
INSERT INTO gdr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Man wumɨr et jɨ opi re God ma b'ingawa yɨt, goro gigɨr dɨde yɨgyɨg b'iyena mɨle omnɨkɨm, goro rɨga ongandɨm, goro yurowam, goro rɨga gatab yɨr ungati kesa b'anygɨnena yɨt usekɨm, tesnaet mor b'u ake mor mog.” ");
INSERT INTO gdr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Seg ton ket Yesund yomnonj da, “Kon kea komkesa onggɨtyam b'ingawa yɨt yɨmta undoka teyinyɨmɨn koina kewar wɨn ke ngɨrpu yu.” ");
INSERT INTO gdr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ajɨ re Yesu onggɨtyam yɨt utkundonj, tin yomnonj da, “Man yɨpa gasa e yesungaet. Sɨ nangga gasa im re mor mɨbnainy man tasoginyɨt, ɨ dɨde ket man komkesa osogi wulkɨp ogona teyeninyɨt gasa kesa rɨga wa. Ra man odede mɨle omnɨket, yɨmta ke ket mor jogjog b'ogɨljog gasa opima mɨtɨbnainy dem de pumb tungg wa. Seg ket man metket Kor pɨlwa dɨde ket yɨmta nutundoket!” ");
INSERT INTO gdr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ajɨ re ton utkundonj onggɨtyam yɨtkak, ton ma sobijog na gar bebɨg awonj, mop nokɨp ton re ukoijog jogjog gasa kɨma rɨga na yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ajɨ re Yesu tin gar bebɨgɨnd yɨr yongonj, Ton kea rɨga amninonj da, “Jogjog gasa kɨma rɨgam b'ɨgaram de God ma pumb tungg wa, ɨtemb re ma sobijog bebɨg e. ");
INSERT INTO gdr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mop nokɨp ukoi jɨ b'angga kamelɨm b'ɨgaram de nidɨl bora wa, ɨtemb re jɨ ma bebɨg e, ajɨ jogjog gasa kɨma rɨgam God ma pumb tungg wa b'ɨgaram, ɨtemb re jɨ ukoijog bebɨg e.” ");
INSERT INTO gdr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ɨ ket utkunda rɨgap endento da, “Sɨ yete rɨrɨr e yɨrkokar okatam?” ");
INSERT INTO gdr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sɨ Yesu daka ket esmonggainonj da, “Nanggamog im re rɨga wa ma rɨrɨr im omnɨkam, onggɨtyam komkesa gasa re Godɨm rɨrɨr im ti omnɨkam.” ");
INSERT INTO gdr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ɨ Petro Yesund yomnonj da, “Yɨr de, sɨn komkesa gasa erarkɨtondam dɨde ket mena yɨmta undoka miyenyu.” ");
INSERT INTO gdr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Seg Yesu ket ten amninonj da, “Kon ɨmɨnjog wen tamninyɨn da yepiya ra God ma pumb tungg wɨko omnɨka map terarenenanj towa met, o towa konggawar, o towa nanywar, o towa yɨngganwar, o towa b'uwar ake mogwar, o mɨnda towa b'ɨgawar, ");
INSERT INTO gdr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","sɨ komkesa odede rɨgap opima onggɨt gowukoi wɨmena wɨnɨnd jogjogpyam takatenanj onggɨtyam gasa rɨna re ton erarkɨto, dɨde ton kwa dadal ngɨrpu kesa yɨrkokar okasi dem de sisɨl gowukoi wa rɨnte ra ik dem.” ");
INSERT INTO gdr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ɨ Yesu Tina twelp (12) ɨtmɨkitijog rɨga eominonj Tintawar wa, ɨ ket ten amninonj da, “Yɨr de, men menon yokasu re Yerusalem ma, ɨ amimemb de komkesa yɨtkak rɨrɨrkɨp taukanj dem rɨna re God bageyam waina yɨm ke erɨkinonj Rɨgamna B'ɨga gatab. ");
INSERT INTO gdr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ɨ Ju rɨgap ket Tin yiyi dem de God ma obagɨki kesa rɨga wa pɨlwa. Ɨ ton ket Tin ngong engena kɨma jɨ malɨk omnɨka iyenyi dem, ɨ Tin ɨngar kɨma negɨr gɨm omnɨka iyenyi dem, ɨ Tin auya ɨtmanji dem, ");
INSERT INTO gdr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ɨ Tin ɨraski dem, ngɨrpu Tin onganji dem. Ajɨ Ton uj ke tutnyis dem nowam bibɨrɨnd.” ");
INSERT INTO gdr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ajɨ ɨtmɨkitijog rɨgap makwa nony aukɨto onggɨt yɨt gatab. Ɨ onggɨtyam opureni yɨt re towa pɨlke upuki na yɨbnonj dɨde ton makwa wumɨr aukɨto nangga gatab yɨt na Ton yindonj. ");
INSERT INTO gdr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ɨ re Yesu Yeriko taun wuswus wa awonj, yɨpa yɨrdɨdɨ rɨga omanda nya yɨund omiti yɨbnenenonj wulkɨp b'ɨjenenam. ");
INSERT INTO gdr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ɨ re ton rɨga bobo waina menon ngele utkundonj, ton ket rɨga ara eainonj da, “Nangga mɨle e awɨk?” ");
INSERT INTO gdr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ɨ ton tin mɨra yomno da, “Najaret tunggam Yesute opanjis.” ");
INSERT INTO gdr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Seg ton ket b'okta ara yikenonj da, “Dawidɨmna B'ɨga, Yesu-wɨi! Kear nomne-o!” ");
INSERT INTO gdr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ɨ naskanyam menonyamɨp tin samany ke yomneno da, “Muma kesa ae!” Ajɨ ton kea ket ara yoikɨndenayonj da, “Dawidɨmna B'ɨga-wɨi! Kear nomne-o!” ");
INSERT INTO gdr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Seg ket Yesu omanda onyitonj dɨde ket rɨga engainonj tin iyoyɨm Ti pɨlwa. Ɨ re ton Yesum wus wa awonj, Yesu tin yɨgekitonj da, ");
INSERT INTO gdr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nangga ma man singi aet Kon mornɨm omnɨkam?” Ɨ ton ket mɨra yomnonj da, “Yonggyam! Kon singi en yɨr opngendam.” ");
INSERT INTO gdr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Sɨ Yesu ket tin yomnonj da, “Yɨr opngende! Moina gar ke utkundate men mɨsakenj.” ");
INSERT INTO gdr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Seg odenja ket ɨtemb yɨrdɨdɨ rɨgat yɨr b'ɨskenonj dɨde ket Godɨnd esourena kɨma Yesund yɨmta yundokonj. Ɨ re komkesa rɨgap onggɨtyam auki mɨle yɨr yongo, toda kwa kea Godɨnd esourena yiyo. ");
INSERT INTO gdr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ɨ Yesu ket Yeriko taun wa b'ɨgaronj, ɨ ket onggɨt taun nata opantonj. ");
INSERT INTO gdr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ɨ demb de onggɨt taunɨnd yɨpa rɨga yɨbnonj nyɨ da Jakayo, ɨ ton re mopyam teks imdayam rɨga na dɨde jogjog gasa kɨma rɨga na. ");
INSERT INTO gdr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ɨ ton nya oraka yiyenonj Yesund yɨr ongongɨm nokɨm da ton wumɨr okas da ɨja e Ti wɨp, ajɨ ton ma rɨrɨr na Tin yɨr ongongɨm, mop nokɨp ton re kutkut rɨga na dɨde rɨga bobopiya Tin yulungayo. ");
INSERT INTO gdr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Sɨ ton b'ɨkonj naska wa Yesund nya owamam, ɨ ket yɨpa sikomo pig wul ɨjonj, nokɨm da ɨdenat ton Tin b'obogɨl yɨr ong ra Ton topanjis onggɨt nyawɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ɨ re Yesu onggɨt pɨpmetɨnd awonj, Ton ti pɨlwa yɨr b'ɨskonj, ɨ ket tin yomnonj da, “Jakayo! Wanakana gou wa inke! Mop nokɨp yu dor Kon b'ogla nɨtɨbnyɨn moina metɨnd.” ");
INSERT INTO gdr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Seg ket Jakayo odenja gou wa inkonj, dɨde ket Yesund ukoi sam kɨma simesime yomnonj. ");
INSERT INTO gdr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ɨ komkesa rɨga yepiya re Yesund yɨr yongo tina met wa b'ɨgarand, ton ket yɨt b'ebongnento odede da, “Ton kea obayɨm b'ɨgarɨk negɨr mɨleyam rɨgamna met wa.” ");
INSERT INTO gdr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ajɨ Jakayo ket onyitonj dɨde ket Yonggyamɨnd yomnonj da, “Yɨr de, Yonggyam! Kon takalenjinyɨn komkesa koina gasa ɨ tab tagoninyɨn gasa kesa rɨga wa. Ɨ rada ke kon ya pɨlke nanggamog gasa na akasinond nenegɨr nya ke, kon opima ket powapyam mɨra towa tetendenawainyɨn koina okati gasa rɨrɨrɨnd.” ");
INSERT INTO gdr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Sɨ Yesu ket tin yomnonj da, “Yu bibɨrɨnd, God ma yɨrkokar okawa mɨle kea onggɨt metɨnd pɨta ainy, mop nokɨp onggɨtyam rɨga toda re yɨpa Abraamɨmna b'ɨga e. ");
INSERT INTO gdr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mop nokɨp Rɨgamna B'ɨga ikonj onggɨt gowukoyɨnd re b'edamkiti rɨga oraka mana dɨde towanɨm yɨrkokar okawa mana.” ");
INSERT INTO gdr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ɨ re rɨgap onggɨtyam yɨt utkundo, Yesu kwa b'usaya yɨpa tendam yɨt towa usekawonj, mop nokɨp Ton kea Yerusalem taun wus wa awonj, dɨde rɨgap nonyɨk b'amdento da God ma pumb tungg pɨta tainy odenja ra Ton b'ɨtgarɨk Yerusalem taunɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Sɨ Ton yɨt yotomonj da, “Yɨpa ukoijog nyɨ rɨga menon yokatonj paja tungg wa de mopyam kingɨm pɨlwa, odede tilenggyam nonyɨk b'amdena kɨma da ɨdenat ton king pɨpmet okas ti pɨlke ɨ tɨtenj onggɨt king nyɨ danda kɨma tina tungg wa. ");
INSERT INTO gdr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ɨ re ton iwatam awonj, ton ket tinajog ten (10) wɨko rɨga ara emokinonj dɨde ket towa agoninonj ten (10) gold koin, ngɨrpu ten amninonj da, ‘Wɨn b'obogɨl onggɨtyam wulkɨp tengaenindam b'usaya mɨra oikɨndenam ngɨrpu ra kon tɨtenjɨn dem.’ ");
INSERT INTO gdr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ajɨ rɨga yepiya re tina danda wɨrand wekenonj, tin yɨsayo, ɨ ket nɨnda rɨga abagɨkto dɨde ton ket ten etmɨkurto ti yɨmta nya de ukoijog kingɨm pɨlwa odede yɨt kɨma da, ‘Sɨn ma singi im jɨ ɨtemb rɨga sowanɨm king pɨpmetɨnd ɨbɨm.’ ");
INSERT INTO gdr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ajɨ re onggɨt ukoijog nyɨ rɨgat king nyɨ yokatonj mopyam kingɨm pɨlke, ton ket ɨtendonj tina tungg wa, ngɨrpu ton ket engaukinonj opimemb tinajog wɨko rɨga ya mana re ton gold wulkɨp agoninonj, nokɨm da ɨdenat ton wumɨr okas rɨdede na ton onggɨtyam wulkɨp engaenento b'usaya mɨra oikɨndenam. ");
INSERT INTO gdr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Sɨ naskanyam ikonj ti wɨp wa, ɨ yindonj da, ‘Yonggyam! Kon moina yɨpa gold koin ke b'usaya mɨra aingɨnsinond re ten (10) gold koin na.’ ");
INSERT INTO gdr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ɨ ket ti yonggyam tin yɨsmonggawonj da, ‘Oo, b'ogɨl wɨko rɨga! Otomanti e. Man re kea sobijog gasand nony ɨjaijog wɨko yomnɨkot, sɨ onggɨt paemb kon mor danda motkaen ten (10) taun wɨp omnam.’ ");
INSERT INTO gdr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ɨ nɨmogɨmyam ikonj, dɨde yindonj da, ‘Yonggyam! Kon moina yɨpa gold koin ke amnɨkinond re paib (5) gold koin na.’ ");
INSERT INTO gdr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ɨ kwa daka ket onggɨt rɨgand ti yonggyam mɨra yomnonj da, 'Madaka paib (5) taun wɨp omna rɨga e taet.’ ");
INSERT INTO gdr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ɨ kwa yɨpa rɨga ikonj, ɨ ket yindonj da, ‘Yonggyam! Ɨtemb moina yɨpa gold koin rɨna re kon ponpon upuki yowamenenond kobɨrgɨm borand. ");
INSERT INTO gdr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mop nokɨp kon men moga na muwadenenond, nokɨm da man re wɨp ɨnggrawa kesa rɨga et. Sɨ man jabajaba im gasa emdeneninyɨt nangga na re man maka aramkinot, dɨde man erngokeneninyɨt nangga na re man maka esinot.’ ");
INSERT INTO gdr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ɨ ti yonggyam ket tin yɨsmonggawonj da, ‘Man, negɨrjog wɨko rɨga! Kon men mɨtɨsagɨken ra moina tugɨmjog ke opureni yɨtkak kae dem. Ma man ɨja e wumɨr aet da kon re wɨp ɨnggrawa kesa rɨga en, sɨ kon jabajaba im gasa emdeneninyɨn nangga na re kon maka aramkinond, dɨde kon erngokeneninyɨn nangga na re kon maka esinond? ");
INSERT INTO gdr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Sɨ nangga penaemb man maka koina wulkɨp yoramitot bengk wa? Rako man ket bengk wa yoramitot, kon kakoa ɨngkenaemb koinajog wulkɨp yokatond onggɨt oikɨnti wewe wulkɨp kɨma.’ ");
INSERT INTO gdr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ɨ ket ton ti wusɨnd owɨnki rɨga amninonj da, ‘Yɨsata onggɨtyam yɨpa gold koin rɨnte re yɨbɨm ti pɨlɨnd, dɨde onggɨt rɨgam yokawa yete re ten (10) gold koin awaminy!’ ");
INSERT INTO gdr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Sɨ ton ket towa yonggyamɨnd yomno da, ‘Yonggyam! Ton re opima ti awaminy ti ten (10) gold koin.’ ");
INSERT INTO gdr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Seg yonggyam tedaka amninonj da, ‘Kon wen tamninyɨn da komkesa rɨga yepiya re towa b'ogɨl wɨko ke b'usaya nɨnda mɨra aikɨndento, Kon opima towa nɨnda kwa tumɨnd tagoninyɨn. Ajɨ yepiya re ton maka b'usaya mɨra aikɨndento, kon opima ten tesamburinyɨn nanggamog im re ton awamanj. ");
INSERT INTO gdr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ajɨ wɨn opimemb koina geja rɨga teyinam dɨkɨnd yepiya re ken nɨsayo towanɨm king awowɨm, ɨ ket kor wɨpɨnd ten uj tama na mop epkinam!’” ");
INSERT INTO gdr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ɨ re ket Yesu onggɨtyam yɨt opurena seg awonj, Ton ket Ti rɨgawar wa wɨp ke naskanaska na yikonj, re Ton menon yokatonj Yerusalem taun wa. ");
INSERT INTO gdr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ɨ Ton ket Betpage tungg dɨde Betaniya tungg wus wa awonj de yɨpa dor wa ogenaya da Olib dor. Ɨ ɨngkenaemb ket Yesu Tina nɨmog b'auyaena rɨga etmɨkitonj ");
INSERT INTO gdr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","odede yɨt kɨma da, “Wɨn eka onggɨt tungg wa rɨnte re wɨp ke yɨbɨm! Ra wɨn onggɨt tungg wa b'ɨtgarya, wɨn ɨta odarya dor yɨpa dongki b'ɨga rɨnte re ɨjobɨki yɨbɨm, dɨde makaya yɨpa rɨgat angis ti teskak kumbɨnd. Sɨ wɨn ket kai ɨtrekya dɨde iya dor dɨkɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ɨ ra yɨpa rɨgat wen tarkis dor da, ‘Nangga pae wɨn kai yɨtrekya?’ wɨn odede wumɨr omnya da, ‘Yonggyam Ton onggɨtyam dongki b'ɨga singi e yomɨny ingawam.’” ");
INSERT INTO gdr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ɨ re osiemb jɨ ɨtmɨkiti rɨga ekonda demb de onggɨt tungg wa, ton ɨja na dongki b'ɨga yodaronda rɨja na re Yesu ten yɨt amnenonj. ");
INSERT INTO gdr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ɨ re ton onggɨtyam dongki b'ɨga kai yɨtrekonda, onggɨt dongkim yonggyamwarɨp ten amno da, “Nangga pae wɨn dongki b'ɨga kai yɨtrekya?” ");
INSERT INTO gdr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Sɨ ton ket yonggyamwar esmonggainonda da, “Yonggyam Ton singi e yomɨny onggɨtyam dongki b'ɨga ingawam.” ");
INSERT INTO gdr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ɨ ton ket ɨtemb dongki b'ɨga yiyonda de Yesum pɨlwa dɨde towaina tumɨnd kobɨrgɨm dongki b'ɨga kumbɨnd aramkinonda dɨde ton ket Yesund yɨm yokawonda angitam. ");
INSERT INTO gdr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Seg re ket Yesu menon yokatonj, rɨgap kea towaina kobɨrgɨm Tina menonpu nyawɨnd ondrɨka eito ukoi ɨsnawa kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ɨ re Yesu Olib dorɨnd paga wa egwarendam awonj, komkesa Tina yɨmta undoka rɨga bobo b'atomto ukoi sam kɨma dɨde b'okta auwam kɨma Godɨnd esourenam. Mop nokɨp ton kea yɨr angenento komkesa Tina kɨd kesa kɨma danda wɨko rɨna re Ton amnɨkeninonj. ");
INSERT INTO gdr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Sɨ ton odede yɨt kɨma esourena yiyeno da, “Ɨta God ma b'ogɨl onggɨt Kingɨm pɨlwa yete re ik Yonggyamɨm nyɨ kɨma! Ton yiyeny ngɨmbla mera pɨlɨnd dɨde pumb tungg wa, dɨde b'ogɨl ɨnyomarena pumbjog Godɨm pɨlwa!” ");
INSERT INTO gdr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ɨ rɨga bobo wɨngɨrɨnd nɨnda Parisai rɨgap Yesund yomno da, “Ouyaena Rɨga! Samany eyowine moina b'auyaena rɨga!” ");
INSERT INTO gdr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ɨ Yesu ket ten mɨra amninonj da, “Kon wen tamninyɨn da ra onggɨtyam rɨga mumakesa taukanj dor, gɨmopim ket b'okta arara taenanj dor.” ");
INSERT INTO gdr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ɨ re Yesu Yerusalem taun wus wa awonj, Ton kea onggɨtyam taun yɨr yongonj ngɨrpu Ton ket yii yiyagɨkonj, ");
INSERT INTO gdr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","odede yɨt kɨma da, “Rako maka yu onggɨtyam bibɨrɨnd wumɨr aet da, ‘Onggɨt gasate ngɨmbla nitiyau.’ Ajɨ yu onggɨtyam gasa re moina yɨrɨnd egiti e yɨbɨm. ");
INSERT INTO gdr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ɨta jɨ yɨpa wɨn ik dem. Moina geja rɨgap ɨta men metwatɨnsi dem dɨde gou kɨpol ke ukoi kara orangi dem moina taun kara bau ke, ɨ dɨde men ɨnyɨny wa motɨnyi dem, ngɨrpu komkesa gatab ke geja rɨgap men mutwopɨnsi dem. ");
INSERT INTO gdr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ɨ kwa moina geja rɨgap men dɨde mor wɨngɨrɨnd komkesa rɨgawar gou wa taskandenanj dem. Sɨ ton moina taunɨnd makwa ɨta ngai yɨpa orangi motɨr ɨrari dem goujog motɨr kumbɨnd, ajɨ komkesa ra eomneni e ɨbɨm dem. Mop nokɨp man maka yongwasɨt onggɨtyam wɨn ɨte re yu God men yɨrkokar okawam motup.” ");
INSERT INTO gdr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ɨ re Yesu yɨnamet kara bora wa b'ɨgaronj, Ton kea ket eaukeninonj b'asoga rɨga yepiya re asogenento sɨ b'angga dɨde rɨga yepiya re yɨnamet teks wulkɨp sensi amnenento yɨr opmitenapu aband. ");
INSERT INTO gdr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ɨ ten amninonj da, “God ma yɨna peband ɨja emb jɨ yɨnamet gatab ɨrɨki yɨbɨm da, ‘Koina met tainy ra yɨr opmitenapu met e.’ Ajɨ wɨnpim ɨtemb yɨnamet wɨp yomnɨkya da raskol waina wɨmenapu met e.” ");
INSERT INTO gdr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ɨ Yesu ket ita bibɨrɨnd rɨga auyaeneninonj yɨnametɨnd. Ajɨ yɨna mopyam sɨ rɨgap dɨde Ju rɨga waina gog ouyaena rɨgap ɨ dɨde Ju rɨga waina mopyam rɨgap nya oraka eyento Yesund ongandam. ");
INSERT INTO gdr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ajɨ ton makwa nya yodaro rɨdede wɨp e Tin onganji, mop nokɨp komkesa rɨga re Tina yɨt b'obogɨl utkunda mana b'ausɨka wuwenonj Ti pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ɨ yɨpa bibɨrɨnd re Yesu rɨga auyaeninonj yɨnametɨnd dɨde God ma b'ogɨl yɨrkokar bage yɨt pɨtapɨta yomnenonj, ton ket yɨna mopyam sɨ rɨgap dɨde Ju rɨga waina gog ouyaena rɨgap, yɨpand Ju rɨga waina elda rɨga kɨma Ti pɨlwa tuwonj. ");
INSERT INTO gdr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Sɨ ton ket Yesund yerkito da, “Man sɨn wumɨr nomnine! Man nangga juwai kaim onggɨtyam gasa amnɨkinyɨt, o yetemb jɨ rɨga mor onggɨtyam juwai mokawonj?” ");
INSERT INTO gdr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ɨ Yesu ket ten mɨra amninonj da, “Sɨ Kodaka yɨpa yɨt gatab e wen tarkisinyɨn. Wɨn b'ogla mɨra notɨnya! ");
INSERT INTO gdr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Rɨngma, Yoanɨmna baptiso Godɨm pɨlkae ikonj, o mɨnda rɨka rɨga wa pɨlkae?” ");
INSERT INTO gdr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ajɨ ton towa wɨngɨrɨnd yɨt b'ɨglenena wuwenonj odede yɨt kɨma da, “Ra men mɨra omnyu da ‘Godɨm pɨlkae,’ sɨ Ton opima netɨrkisiny dor da, ‘Sɨ wɨn nangga pena maka Yoanɨmna baptiso gatab gar ke utkunda ke yokatonda?’ ");
INSERT INTO gdr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ajɨ ra men jaba nitinjindam da ‘Rɨga wa pɨlkae,’ sɨ komkesa rɨgap ke men gɨmokɨp ke nedrɨkine. Mop nokɨp ton komkesa Yoanɨnd ɨmɨnjog kae yokatenyi da ton re God ma yɨpa bageyam na.” ");
INSERT INTO gdr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Sɨ ton ket mɨra yomno da, “Sɨn ma wumɨr im be rɨngkae.” ");
INSERT INTO gdr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ɨ Yesu daka ket ten mɨra amninonj da, “Sɨ Kodaka ma opima wen wumɨr tamninyɨn nangga danda kaim Kon onggɨtyam gasa amnɨkinyɨn.” ");
INSERT INTO gdr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Sɨ Yesu ket onggɨt tendam yɨt ke rɨga amninonj da, “Yɨpa rɨgat greip nangg ɨtot eyeninonj tina gowɨnd. Seg ton ket nɨnda wala rɨga kɨma yɨtnono aento dɨde tɨrɨr yomno da, ‘Ra kɨp wɨn okas dem, yonggyam kɨp opima sopapu mɨra takateniny dem.’ Yɨt seg ke ton ket sopapu towa akainonj, dɨde ket menon yokatonj b'enga kantri wa. ");
INSERT INTO gdr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ɨ re kɨp wɨn yokatonj, yonggyam yɨpa tina wɨko rɨga yɨtmɨkitonj wala rɨga wa pɨlwa, nokɨm da ɨdenat wala rɨgap ti sopapu mɨra greip kɨp okauranj. Ajɨ onggɨt wala rɨgap tin ipowa yiyeno, dɨde yɨtmɨkito mɨra omni kesa. ");
INSERT INTO gdr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ɨ ton kwa b'usaya yɨpa tina wɨko rɨga yɨtmɨkitonj. Ajɨ onggɨt wala rɨgap tidaka kwa ipowa yiyeno, dɨde ɨngar kɨma nenegɨr kana yomneno, ngɨrpu ket tin yɨtmɨkito mɨra omni kesa. ");
INSERT INTO gdr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ɨ ton b'usaya kwa yɨpa tina wɨko rɨga nowam yɨtmɨkitonj. Ajɨ daka ton tin kus yowarɨndeno, dɨde ket yɨskanto sopapu bau wa. ");
INSERT INTO gdr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Seg onggɨt greip sopapu yonggyam ti nony mana yindonj da, 'Nangga e ket kon omnɨken? Sɨ kon ket ɨtmɨkisɨn koina b'ɨga e yena re kon singi yiyenyɨn. Ton yama ɨta koina b'ɨgand ɨsnai dem.’ ");
INSERT INTO gdr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ajɨ re onggɨt sopapu wɨko rɨgap towa yonggyamɨmna b'ɨga yɨr yongo, ton towa wɨngɨrɨnd apurento da, ‘Ɨtemb b'ɨga re tina sopapu owabɨnta rɨga e. Sɨ men b'ogla tin yangandu, nokɨm da ɨdenat men onggɨt sopapum owabɨnta rɨga taindam.’ ");
INSERT INTO gdr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Seg ton ket tin yɨskanto greip sopapu bau wa dɨde uj tama na yongando. Sɨ onggɨt paemb, nangga e ket onggɨt greip sopapu yonggyamɨt towa pɨlɨnd omnɨk dem? ");
INSERT INTO gdr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Sɨ ton ɨta ik dem onggɨt wala rɨga wa pɨlwa dɨde ket ten uj tama na tanganjiny dem. Ɨ ton ket onggɨtyam greip sopapu takainy dem b'enga rɨga wa pɨlwa.” Ɨ rɨgap onggɨtyam tendam yɨt utkundi kak ke endento da, “Goro odede rawɨk!” ");
INSERT INTO gdr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ajɨ Yesu towa pɨlwa yɨr sapsap owɨnkonj, dɨde amninonj da, “Sɨ nangga ma jɨ onggɨtyam ɨrɨki yɨtkak yindeny ɨt re da, ‘Yɨpa Motɨr met oranga rɨgap b'ɨsayo met orangam, ajɨ God ket yɨmta ke met wugɨnd yoramitonj onggɨt met emorkam. Sɨ Ton ket ɨmɨnjog ɨsnawa kɨma Motɨr na awonj onggɨt met oranga wɨngɨrɨnd'? ");
INSERT INTO gdr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Komkesa rɨga yepiya ra sap totendanj onggɨt Motɨr kumbɨnd, ton opima kak tiposkanj. Ɨ ya kumb nat ra ɨtemb Motɨr sap totenj, onggɨt Motɨrɨt ɨta tin ɨimɨk dem.” ");
INSERT INTO gdr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Seg re ket onggɨt wɨnjog natemb Ju rɨga waina gog ouyaena rɨga dɨde yɨna mopyam sɨ rɨgap nya oraka eyento Yesund yɨmɨnd okatam, mop nokɨp ton wumɨr na da, “Sɨna onggɨtyam tendam yɨt ke nomneniny.” Ajɨ ton rɨga bobo na moga uwadto. ");
INSERT INTO gdr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ɨ re onggɨtyam Ju rɨga waina gog ouyaena rɨga dɨde yɨna mopyam sɨ rɨgap Yesund yɨr ɨtena yiyeno, ton ket nɨnda wɨgawɨga bageyam emdɨto, ɨ yɨt ataito da, “Wɨn walenggyam b'ogla b'anygɨnena nya ke gɨm ke negɨr kesa dɨmdɨmjog rɨga wɨp taindam dor Ti wɨpɨnd.” Ɨ dɨde ton ket ten etmɨkurto Yesum pɨlwa, nokɨm da ɨdenat ton Yesumna negɨr opuliti yɨtkak okasi dɨde Tin yiyi de Roma gabmani mopyamɨm pɨlwa, ɨ ɨdenat onggɨt mopyamɨt ket tina gabmani gog ke dɨde tina danda ke Tin ɨsagɨk. ");
INSERT INTO gdr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Seg ton ket tuwonj Yesum pɨlwa, ɨ Tin yerkito da, “Ouyaena Rɨga-wɨi! Sɨn wumɨr im da man dɨmdɨm im apureninyɨt dɨde auyaeninyɨt. Ɨ man ma gowukoi nya kaim rɨga yɨrɨk eyeninyɨt, ajɨ man Godɨmna nya kaim ɨmɨnjog yɨtkak rɨrɨrɨnd rɨga auyaeninyɨt. ");
INSERT INTO gdr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Sɨ rɨngma, Roma kantri mopyam king Kaisam teks ogonam, ton sowanɨm rɨrɨrkɨpjog mɨle e, o mɨnda negɨrjog e?” ");
INSERT INTO gdr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ɨ Yesu kea towaina b'anygɨnena nony menamena angwatawonj, sɨ ket ten amninonj da, ");
INSERT INTO gdr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Yɨpa Roma kantri wulkɨp Denari koin iya, dɨde kor nouyawa! Yaina wɨp e dɨde nyɨ e ɨrɨki i jɨ onggɨt wulkɨpɨnd?” Ton yɨsmonggawo da, “Roma kantri mopyam king Kaisamna i.” ");
INSERT INTO gdr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Sɨ Yesu ket ten amninonj da, “Sɨ onggɨt paemb, wɨn Kaisam ogonindam nangga im re Kaisa ma ogenaya gasa, ajɨ Godɨm ogonindam nangga im re God ma ogenaya gasa.” ");
INSERT INTO gdr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Sɨ ton ma rɨrɨr na aukɨto negɨr yɨt okatam Yesumna opurena wɨngɨrɨnd rɨna re Ton rɨga wa wɨpɨnd apureninonj. Ajɨ re ton utkundeno Tina mɨra yɨt opurenand, ton kea kɨd kesa aento, dɨde ket mumakesa na wekenonj. ");
INSERT INTO gdr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ɨ Sadukai rɨga wɨngɨrɨnd nɨnda rɨga tuwonj Yesum pɨlwa yepiya re apurenento da, “Rɨga ma opima uj ke tutnɨkanj dem.” Ɨ ton ket Yesund yerkito da, ");
INSERT INTO gdr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ouyaena Rɨga! Mose God ma yɨna peband erɨkinonj meranɨm omnɨkam da, ‘Ra yɨpa rɨga uj tainy dɨde ti konggand tɨrar b'ɨga oraki kesa, ti nanyɨt o ti yɨngganɨt tokas ɨtomb mik ɨ ti nanyɨmna o ti yɨngganɨmna nyɨ kɨma im b'ɨga tarakiny.’ ");
INSERT INTO gdr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sɨ ket seben (7) nanyɨngganwar wekenonj, ɨ nanyam rɨgat yɨpa kongga wokatonj dɨde b'ɨga oraki kesa uj awonj. ");
INSERT INTO gdr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Sɨ ti wus ke yɨngganɨt ti nanyɨmna mik wokatonj. ");
INSERT INTO gdr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ɨ dɨde daka onggɨt wus ke yɨngganɨt tin wokatonj, ɨ ɨja na onggɨtyam seben (7) nanyɨngganwarɨp tin okatena tiyo, dɨde b'ɨga oraki kesa uj aukɨto. ");
INSERT INTO gdr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Seg ket kikitum ɨtomb kongga todaka uj awonj. ");
INSERT INTO gdr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Sɨ onggɨt paemb ra utnyita wɨn ik dem, ɨtomb kongga opimemb seben (7) nanyɨngganwar wɨngɨrɨnd yama ɨmɨnjog kongga tainy dem? Mop nokɨp komkesa seben (7) nanyɨngganwarɨp kea ɨtomb kongga towa konggam b'ɨsatena tiyo.” ");
INSERT INTO gdr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ɨ Yesu ket ten mɨra amninonj da, “Rɨga onggɨt gowukoyɨnd opima kongga imda mɨle dɨde leo imda mɨle amnɨkenenanj. ");
INSERT INTO gdr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ajɨ rɨga yena ra b'ɨsagɨka wɨnɨnd God danda tagoniny dem b'ɨgaram sisɨl gowukoi wa rɨnte ra ik dem, dɨde kwa danda tagoniny uj ke utnyitam, ton ma opima kongga okata mɨle dɨde leo okata mɨle tamnɨkanj dem. ");
INSERT INTO gdr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mop nokɨp ton ma rɨrɨr im kwa b'usaya uj taukanj dem. Mop nokɨp ton aneru kɨma yɨpa wɨp im taukanj dem. Ɨ ton kwa God ma b'ɨga im taukanj dem, mop nokɨp Godsim ten uj ke tutnɨkiny dem Tina b'ɨga awowɨm. ");
INSERT INTO gdr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ajɨ Mose daka tina peband pɨtapɨta yomnonj uj rɨga utnyita gatab yɨt rɨna re ton Sinai dorɨnd onggɨt so omni b'uwaepɨnd yokatonj. Sɨ ton ɨja emb jɨ Yonggyamɨnd yogenai da Abraamɨmna God e, ɨ Isakɨmna God e, ɨ dɨde Yakobɨmna God e. Sɨ Abraam, ɨ Isak ɨ dɨde Yakob re yilo im wekeny de pumb tunggɨnd utnyita wɨn yɨr ungawand. ");
INSERT INTO gdr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Sɨ God re ma uj rɨgaina God e ajɨ yilo rɨgaina God e. Mop nokɨp komkesa rɨga Ti pɨlɨnd wekeny re yilo im.” ");
INSERT INTO gdr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ɨ nɨnda Ju rɨga waina gog ouyaena rɨgap yɨsmonggawo da, “Ouyaena Rɨga! Man otomanti na mindenyɨt.” ");
INSERT INTO gdr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Sɨ makwa yɨpa rɨgat rɨrɨr na Tin erkitam, nokɨp Tina mɨra yɨtɨt kea towaina gar mogam amninonj. ");
INSERT INTO gdr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ɨ Yesu ket towa pɨlɨnd b'arkita yoramitonj da, “Rɨdede ma paim rɨgap opurena eyenanj da Keriso re Dawidɨmna B'ɨga e? ");
INSERT INTO gdr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mop nokɨp Dawid tilenggyam yindeny Ger peband da, ‘Yonggyam God yindeny kor Yonggyamɨm pɨlwa da, “Omite Koina yɨmjog yɨm tab ke juwai kɨma pɨpmetɨnd, ");
INSERT INTO gdr_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ngɨrpu ra ket Kon Moina komkesa geja rɨga gou wa tamninyɨn dem dɨde taramisinyɨn dem Moina pɨs wɨrand moina danda ondratenam towa kumbɨnd.” ’ ");
INSERT INTO gdr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Sɨ Dawid tina tugɨm ke Kerisond yogenayonj da, ‘Kor Yonggyam,’ sɨ rɨdede nya kae Keriso Dawidɨmna B'ɨga tainy? Sɨ Ton re Dawidɨmna B'ɨga e ajɨ kwa ti Yonggyam e.” ");
INSERT INTO gdr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ɨ re komkesa rɨgap Yesumna yɨt utkundento, Ton Tina b'auyaena rɨga amninonj da, ");
INSERT INTO gdr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Wɨn yɨr kɨma tekenyɨt meraina gog ouyaena rɨga gatab. Ton singi im aenanj b'ogɨl pɨnpɨn kobɨrgɨm kɨma menamenam, ɨ ton kwa singi aenanj rɨga wa pɨlke simesime okatam maketpu nata, ɨ ton kwa ukoijog wɨp ke pɨpmet akatenenanj meraina yɨr opmitenapu met nata, ɨ dɨde kwa ton ukoijog ɨsnawa kɨma rɨgaina omitenapu kasand omitenenanj ukoi diyamdiyampu pɨpmet nata. ");
INSERT INTO gdr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ɨ ton mik kongga waina gasa endwatenanj, dɨde kwa rɨga ouyawam dɨde yɨr ongongɨm pɨnpɨn kana yɨr opmitenenanj. Sɨ odede rɨgap opima ukoijog negɨr mɨra takatenanj dem b'ɨsagɨka wɨnɨnd, ajɨ nɨnda rɨga re ma odede ukoi negɨr mɨra im takatenanj dem ton re dɨde.” ");
INSERT INTO gdr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ɨ re jogjog gasa kɨma rɨgap wulkɨp oramka eyento wulkɨp oramkapu boks bora wa, Yesu kea towaina mɨle yɨr ɨpka eyeninonj. ");
INSERT INTO gdr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ɨ Ton kwa yɨpa gasa kesa mik kongga yɨr wongonj re ton nɨmog kɨp sobijog uj peni aramitonj onggɨt wulkɨp oramkapu boks bora wa. ");
INSERT INTO gdr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Seg Yesu ket yindonj da, “Kon ɨmɨnjog wen tamninyɨn da onggɨt gasa kesa mik konggat ukoijog wulkɨp aramis onggɨt komkesa rɨga wa wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mop nokɨp opimemb komkesa rɨga towaina ukoi wulkɨp wɨngɨr ke sobijog wulkɨp nena na aramkɨranj onggɨt wulkɨp oramkapu boks bora wa. Ajɨ ɨtomb mik kongga re komkesa tina wulkɨp aramis tina wulkɨp kesa wɨngɨrɨnd. Onggɨtyam tina oramiti wulkɨp re tina kupka yɨrkokar naemb jɨ.” ");
INSERT INTO gdr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ɨ nɨnda Yesumna b'auyaena rɨgap ɨja naemb jɨ opurena eyento yɨnamet gatab da, “O meraina yɨnamet otomanti motɨr kae dɨde nɨnda rɨgaina Godɨm ogoni apɨg kae ejgi yɨbɨm!” ");
INSERT INTO gdr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ajɨ Yesu yindonj da, “Ɨta jɨ yɨpa wɨn ik dem, sɨ rɨnsim re jɨ wɨn yu yɨr angindam, makwa ɨta yɨpa motɨr ɨbɨm dem dɨkɨnd onggɨt goujog motɨr kumbɨnd, komkesa onggɨtyam ukoijog motɨr opima tosmurkanj dem.” ");
INSERT INTO gdr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Sɨ ton Yesund yɨgekito da, “Ouyaena Rɨga! Sɨ rɨim onggɨtyam mɨle pɨta taukanj dem? Ɨ ra onggɨtyam gasa momta taukanj dem, nanggamog im jɨ ongwata gasa taukanj dem?” ");
INSERT INTO gdr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ɨ Yesu mɨra amninonj da, “Wɨn b'obogɨl yɨr kɨma tekenyɨt! Ke rɨgap wen b'anygɨnena nya ke wɨp ramneninem. Mop nokɨp jogjog rɨga opima tuweny dem Koina nyɨ kɨma, dɨde jogjog rɨga ugungatena teyenanj dem odede yɨt kɨma da ‘Kon ɨtemb Keriso,’ ɨ dɨde da ‘Undwatapu wɨn re ke momta e.’ Ajɨ wɨn goro ten yɨmta tundoneninam dem. ");
INSERT INTO gdr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ɨ wɨn ra ik dem, wɨn opima tutkundenindam dem tɨrɨba geja yɨt dɨde tɨrɨba geja gatab bage yɨt. Ajɨ wɨn goro moga taininam! Mop nokɨp onggɨtyam mɨle opima naska taukanj dem, ajɨ kikitum wɨn ra dem ma wanakana e tainy.” ");
INSERT INTO gdr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ɨ Ton b'usaya ten amninonj da, “Ɨ b'engabenga yɨtam opima gejam owɨnka tuweny dem nɨnda b'enga yɨtam kɨma. Ɨ kwa daka kantri b'engabenga opima gejam owɨnka tuweny dem nɨnda b'enga kantri kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ɨ opima kwa ukoi jijɨg dɨde sou wɨn ɨ dɨde rukoruko kopa taukanj dem gowukoi b'engabenga wɨnɨnd. Ɨ kwa daka moga kɨma mɨle taukanj dɨde kwa ukoi kɨd kesa kɨma danda wɨko tuweny dem wub kumb ke. ");
INSERT INTO gdr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Sɨ yɨmta kaim onggɨtyam gasa taukanj dem, ajɨ naska rɨgap opima Kor nyɨ map wa pɨlɨnd yɨm oramka teyenanj dem negɨr omnɨkam dɨde wa pɨlwa odede bebɨg dɨde b'ɨsadrena mɨle oramka teyenanj dem, opi re da ton wen teyenanj dem de Ju rɨga waina yɨr opmitenapu met nata b'ɨsagɨkam, dɨde ket oramka teyenanj dem sɨbɨbmet nata, ɨ dɨde ton wen teyenanj dem king wa wɨp wa dɨde ukoi gabmani mopyam rɨga wa wɨp wa. ");
INSERT INTO gdr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ajɨ onggɨtyam mɨlend God opima wa gangga takainy Kor gatab yɨr ungata yɨt pɨtapɨta omnenam. ");
INSERT INTO gdr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sɨ onggɨt paemb wɨn goro tulatula b'atngonjeninam waina garɨnd da, ‘Rɨdede im sɨn b'ɨrmeka yɨt tapurenindam towa wɨpɨnd.’ ");
INSERT INTO gdr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mop nokɨp Kon opima wa yɨtkak dɨde b'ogɨl multekɨp tagoninyɨn wanɨm opurenam. Sɨ ɨngkaim waina geja rɨgap maka rɨrɨr aena tuweny wen wɨpɨnd danda kɨma ɨsmonggaenam. ");
INSERT INTO gdr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ajɨ waina b'u ake mog ɨ waina nany dɨde yɨngganwar ɨ waina kus ke rɨgawar ɨ dɨde wa rɨgawar opima wen tɨb teyenanj dem negɨr ma b'ɨsagɨkam, ɨ ɨngkaim ket wa wɨngɨrɨnd nɨnda rɨga uj ondrɨka teyenanj dem. ");
INSERT INTO gdr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ɨ komkesa rɨgap opima wen singi kesa tamnenanj dem Koina nyɨ map. ");
INSERT INTO gdr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ajɨ wɨn makwa ngai ɨta yɨpa mopngɨi edamkisya dem waina moptekɨp ke. ");
INSERT INTO gdr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ɨ wɨn b'ogla waina gar ke utkunda danda kɨma owama teyenindam onggɨtyam b'ɨdgotnena wɨngɨrɨnd, sɨ ɨdenat wɨn waina wɨngawɨnga yɨrkokar okatenya dem. ");
INSERT INTO gdr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ɨ yɨpa wɨnɨnd wa gejayam rɨga opima tui dem, ɨ ket Yerusalem taun ɨwatɨnsi dem. Sɨ ra wɨn odede mɨle yɨr ongya dem, wɨn b'ogla wumɨr okasya dem da, ‘Ɨtemb ke onggɨt taun negɨr omnam wɨn ke momta e au.’ ");
INSERT INTO gdr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Sɨ onggɨt wɨnɨnd yepiya ra tekeny Yuda eriyand, wɨn dor wa na mogamoga b'ɨtkenindam dem. Ɨ yepiya ra tekeny dem Yerusalem taunɨnd, b'ogla rɨtrɨngkinem dem onggɨt taun ke, ɨ dɨde kwa yepiya ra tekeny dem wungawungapu tungg nata, goro b'egarkinem dem onggɨt taun wa. ");
INSERT INTO gdr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mop nokɨp ɨtemb re negɨr ma b'ɨsagɨka wɨn e dem rɨna ra God onggɨtyam taun b'ɨsagɨkand oramis dem komkesa yɨtkak rɨrɨrɨnd rɨnsim re yɨna peband ɨrɨki wekeny. ");
INSERT INTO gdr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Onggɨt wɨnɨnd God ma sake towa pɨlwa yepiya ra ngor kɨma kongga dɨde papa b'ɨga kɨma kongga tekeny dem. Mop nokɨp ukoijog b'ɨdgotnena e pɨta tainy dem gowukoyɨnd dɨde kwa Godɨmna ukoi soro kɨma b'ɨsagɨka pɨta tainy dem onggɨt rɨga wa pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sɨ towa gejayam rɨgap ten towaina giri ke oswanka teyenanj dem, dɨde komb rɨga teyenanj dem komkesa God ma obagɨki kesa rɨgaina tungg wa. Ɨ dɨde God ma obagɨki kesa rɨgap Yerusalem taun owabɨnsi dem dɨde negɨr omnɨka iyenyi dem, ngɨrpu rokate ra towaina wɨn rɨrɨrkɨp tainy dem. ");
INSERT INTO gdr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ɨ kɨd kesa kɨma b'enga wɨp mɨle opima taukanj dem lomkongga ɨ mobi ɨ dɨde ɨki wa pɨlɨnd. Ɨ kwa onggɨt gowukoyɨnd kantri b'engabenga moga im taukanj dem, nokɨp rɨga nony menamena kesa im taukanj dem sɨpa wuwam dɨde wuro map. ");
INSERT INTO gdr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Sɨ rɨgap opima mogapɨp mop b'askena tuweny dem, dɨde ton opima nonyɨk b'amdena tuweny dem da, ‘Nanggamog im ket auka wuweny onggɨt kupka gowukoyɨnd.’ Mop nokɨp danda gasa rɨnsim re pumb wa wekeny opima b'utuwongnenanj dem. ");
INSERT INTO gdr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ɨ onggɨt wɨnɨnd dem rɨgap ɨta Rɨgamna B'ɨga yɨr iyi dem moi borand menonɨnd ukoi danda kɨma dɨde b'ogɨl ɨnyomarena kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Sɨ ra onggɨtyam mɨle b'atomkɨranj dem aukam, wɨn b'ogla towɨnkindam dem dɨde waina as pumb wa turowasindam dem. Mop nokɨp waina komkesa gowukoi b'ɨdgotnena ke b'ɨtraram wɨn re momta e tawɨk.” ");
INSERT INTO gdr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ɨ Yesu ket towa yɨpa tendam yɨt usekawonj da, “Wɨn yɨr angina pig wul dɨde komkesa wul! ");
INSERT INTO gdr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Rada wul ngɨmb kemb ɨkkanj, wɨn walenggyam yɨr ongong eyenindam, sɨ wɨn ɨta wɨn ongwasya da, ‘Kemb momta e pembpemb wɨn.’ ");
INSERT INTO gdr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Sɨ ra wɨn odede gasa yɨr tangindam dem aukand rɨnsim re Kon wumɨr amneninyɨn, wɨn nony ke ongwasya dem da, ‘God ma pumb tungg re kemb momta e wa wus wa tainy.’ ");
INSERT INTO gdr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ɨ Kon ɨmɨnjog wen tamninyɨn da rɨga yepim re yu onggɨt gowukoyɨnd wekeny yɨmta kaim uj taukanj dem, ajɨ naskajog onggɨtyam komkesa gasa towa liyal im taukanj dem. ");
INSERT INTO gdr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sɨ wub ake gou osiya b'eteomnenya dem, ajɨ Koina yɨtkak makwa ngai opima b'eteomnenanj dem. ");
INSERT INTO gdr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ɨ wɨn b'obogɨl walenggyam yɨr b'ɨtɨpkindam. Ajɨ ra wɨn maka ra b'obogɨl yɨr b'ɨtɨpkindam, wɨn tuwenyɨt ra dem b'engabenga negɨr omnɨka singi nasim ɨ ɨkpɨp wɨmena mɨle nasim ɨ dɨde gowukoi yɨrkokar singind ukoijog nony menamena nasim. Sɨ waina gar ra ɨpɨndena kesa im tekeny dem. Sɨ onggɨt paemb onggɨtyam wɨn re kɨd kesa kɨma e wanɨm pɨta tainy dem odede rɨngma ra girɨmɨt b'angga usunas. ");
INSERT INTO gdr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Mop nokɨp onggɨtyam wɨn pɨta tainy ra dem komkesa rɨga wa wɨp nate dem yepim re wekeny kupkakupka gowukoi wɨn wɨngɨrɨnd onggɨt gowukoyɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Sɨ wɨn b'ogla yɨr kɨma tekenenyɨt, dɨde yɨr na topmitenindam onggɨtyam wɨn yɨr ungaukand. Nokɨm da ɨdenat wɨn rɨrɨr taindam b'ɨwatam onggɨtyam komkesa mɨle wa pɨlke rɨnsim ra pɨta taukanj dem dɨde ket onyitam Rɨgamna B'ɨgam wɨpɨnd.” ");
INSERT INTO gdr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ɨ Yesu ita bibɨrɨnd rɨga auyaeninonj yɨnametɨnd, ajɨ Ton Yerusalem taun ke opendenonj de yɨpa dor wa ogenaya da Olib dor, dɨde ita sɨwɨny adea de yɨbnɨkenenonj. ");
INSERT INTO gdr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Sɨ komkesa rɨgap re kea sɨtawarjog utnɨkenento dɨde wuwenenonj Yesum pɨlwa Tina yɨtkak utkundenam de yɨnamet wa. ");
INSERT INTO gdr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ɨ re Yist kesa Bred Wɨn, o kwa ogenaya da Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam Wɨn re ket wus wa auka ikonj, ");
INSERT INTO gdr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","yɨna mopyam sɨ rɨga dɨde Ju rɨga waina gog ouyaena rɨgap pop nɨnda nya oraka eyento rɨdede wɨp e Yesund onganji, ajɨ ma rɨrɨr na aukɨto, mop nokɨp ton rɨga na moga uwadto. ");
INSERT INTO gdr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ɨ onggɨt wɨnɨnd Satana b'ɨgaronj twelp (12) ɨtmɨkitijog rɨga wa wɨngɨrɨnd yɨpa rɨga Yudas Iskariyotɨm pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ɨ ton ket ewaikitonj Yesum pɨlke, dɨde yikonj de yɨna mopyam sɨ rɨga wa pɨlwa dɨde yɨnamet yɨr ɨpka geja rɨga wa pɨlwa, ngɨrpu ton ket ton kɨma yɨtnono aenonj rɨdede wɨp e Yesund tɨb yii towa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Sɨ ton ma sobijog na sam aukɨto, ɨ yɨmjato ti tɨb iyoi mɨra wulkɨp okawam. ");
INSERT INTO gdr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ɨ Yudas daka ket ton kɨma tɨrɨr yɨt yɨmjatonj Yesund tɨb iyenam. Seg ton ket b'ogɨl gangga oraka yiyenonj rɨdenate ton rɨga kesa warɨnd Yesund tɨb yii towa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ɨ Yist kesa Bred Wɨn re Ju rɨga waina mamoi onganda wɨn na Towaina Uj Ɨgwanti Nony Iyena Diyamdiyam omnɨkam. Ɨ re onggɨtyam wɨn awonj, ");
INSERT INTO gdr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu ket etmɨkitonj Petro ake Yoan odede yɨt kɨma da, “Wɨn eka dɨde ket meranɨm Uj Ɨgwanti Nony Iyena Diyamdiyam omnɨkam pɨpmet ongonjenya dor, nokɨm da ɨdenat men onggɨtyam diyamdiyam omnɨku.” ");
INSERT INTO gdr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ajɨ ton Yesund yomnonda da, “Rokate dɨkɨnd man singi aet sɨn ongonjenam?” ");
INSERT INTO gdr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ɨ Yesu ket ten amnonj da, “Yɨr de, ra wɨn onggɨt taun wa b'ɨtgarya dor, wɨn ɨta yɨpa rɨgand wɨpwɨp omnya dor nyɨkak iyoyɨnd. Sɨ wɨn tin yɨmta undoka yiya dor onggɨt met wa rokate ra ton b'ɨtgarɨk dor. ");
INSERT INTO gdr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ɨ wɨn ket onggɨt met yonggyamɨnd wumɨr omnya dor da, ‘Ouyaena Rɨgat men momɨny da, “Rote jɨ Koina obai rum rokate ra Kon Koina b'auyaena rɨga kɨma meraina Uj Ɨgwanti Nony Iyena Diyamdiyam omnɨken?” ’ ");
INSERT INTO gdr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ɨ ɨta ton wen tauyau dor pumb ke tula ongonjeni ukoi rum. Sɨ wɨn ɨndamaemb ongonjenya dor.” ");
INSERT INTO gdr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Seg ton ket yiwatonda, dɨde ket gasa ɨja na adarinonda rɨngma na re Yesu ten amnenonj, ngɨrpu demb de ket ton Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam yongonjenonda. ");
INSERT INTO gdr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ɨ re ket onggɨtyam diyamdiyam wɨn awonj, Yesu omitonj diyamɨm, ɨ kea daka Tina ɨtmɨkitijog rɨga omnɨkto yɨpand Ton kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ɨ Yesu ten amninonj da, “Kon ukoijog singi na aenenond odede da Kon yu meraina Uj Ɨgwanti Nony Iyena Diyamdiyam naska owen wɨn kɨma, ɨ onggɨt kak ke b'ɨdgotnena okasɨn. ");
INSERT INTO gdr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mop nokɨp Kon wen wumɨr tamninyɨn da Kon makwa ɨta b'usaya owen dem onggɨtyam diyamdiyam, ngɨrpu onggɨtyam diyamdiyam mɨle rɨrɨrkɨp tainy God ma pumb tunggɨnd.” ");
INSERT INTO gdr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ɨ Yesu yɨpa kapo yokatonj, dɨde ket Godɨnd sɨteket yɨt yomnonj. Seg ket Ton yindonj da, “Ɨtemb kapo yokata dɨde ket wa wɨngɨrɨnd yingg yiyena! ");
INSERT INTO gdr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mop nokɨp Kon wen wumɨr tamninyɨn da Kon makwa ɨta b'usaya greip kɨp ke omnɨki wain onaen dem yu ke ngɨrpu ra God ma pumb tungg ik dem.” ");
INSERT INTO gdr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Seg re ket Yesu yɨpa sana nganja yokatonj dɨde ket Godɨnd sɨteket yɨt yomnonj, ɨ dɨde ket yipkɨkonj, ngɨrpu ket towa agoninonj odede yɨt kɨma da, “Ɨtemb re Koina jɨ e rɨnte re wanɨm b'ogɨlɨm akainyɨn. Sɨ wɨn b'ogla omnɨkenenya onggɨtyam mɨle Ken nony iyenam.” ");
INSERT INTO gdr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ɨ diyam seg ke ket Ton odede yɨpa wɨp nya ke kwa yɨpa kapo yokatonj, dɨde ket yindonj da, “Ɨtemb kapo re Koina kus ke oramiti sisɨl outɨnti tɨrɨr omnijog mal e, ɨte re Kon yɨgmarken wanɨm b'ogɨlɨm. ");
INSERT INTO gdr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ajɨ yɨr de, yɨpa rɨgat Ken ɨta tɨb niyeny yaina yɨm e re yɨpand b'uwangenj Koina yɨm kɨma owoupu kasa kumbɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mop nokɨp Rɨgamna B'ɨga Godɨmna tɨrɨr omni yɨt rɨrɨr nate menon yokateny ujɨm, ajɨ God ma sake onggɨt rɨgam pɨlɨnd yete re Tin tɨb yiyeny.” ");
INSERT INTO gdr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Seg ket ɨtmɨkitijog rɨgap towalenggyam b'ɨgekena wuwenonj da, “Yete kwa jɨ rɨga mera ganggand onggɨtyam mɨle omnɨka yiyeny?” ");
INSERT INTO gdr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ɨ Yesu ma ɨtmɨkitijog rɨga wa wɨngɨrɨnd yɨt b'ugwatena pɨta awonj odede da, “Yete ukoijog rɨga mera wɨngɨrɨnd.” ");
INSERT INTO gdr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ajɨ Yesu ten amninonj da, “Gowukoi kingɨp towaina kantri rɨga kumbɨnd danda yondratenyi rɨga wɨp iyenam. Ɨ rɨgap opima agenairanj odede king yepim re wɨp iyenam towa kumbɨnd danda yondratenyi da, ‘Ton re b'ogɨljog wɨko rɨga im meranɨm.’ ");
INSERT INTO gdr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ajɨ wa wɨngɨrɨnd mɨle omnɨkam re ma odede im opi re gowukoi rɨgaina mɨle re dɨde. Ajɨ wa wɨngɨrɨnd ukoijog nyɨ rɨga b'ogla sobijog nyɨ rɨga pɨla tainy, dɨde mopyam rɨga b'ogla rɨga wa wɨrand wɨko rɨga pɨla tainy. ");
INSERT INTO gdr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mop nokɨp yete jɨ ukoi rɨga, mɨnda tonte yete re omiti yɨbɨm owowɨm, o mɨnda tonte yete re rɨga owou yingg iyena wɨkond yɨbɨm? Sɨ, ma ɨnte ukoi rɨga au yete re omiti yɨbɨm owowɨm? Owɨ, ɨntemb ukoi rɨga onggɨt gowukoyɨnd. Ajɨ Kon wa wɨngɨrɨnd ɨnte aen yete re rɨga owou yingg iyenam yɨbɨm. ");
INSERT INTO gdr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ɨ wɨda kwa re ɨnsimemb jɨ rɨga aindam yepim re Kon kɨma yɨpa pɨpmetɨnd wekenyɨt Koina b'atonkena wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kor b'u kea Kor pumb tungg nokawonj wɨp iyenam. Sɨ Kodaka kwa odede yɨpa wɨp nya kae wa onggɨtyam pumb tungg takainyɨn wɨp iyenam. ");
INSERT INTO gdr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nokɨm da ɨdenat wɨn diyam taindam dɨde nyɨ tanaikindam Koina owoupu kasand de Koina pumb tungg wa, ɨ dɨde kwa ɨdenat wɨn tomnɨkindam kingɨmna wɨp omnenapu kasand Israel twelp (12) gu rɨga ɨsagɨkam. ");
INSERT INTO gdr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon! Yɨr de, Satana kea Godɨnd yɨgekitonj wen otonkenam odede rɨngma ra rɨgap kɨp tegenenanj au kesa omnam. ");
INSERT INTO gdr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ajɨ Kon kea yɨr opmitond mor gatab, nokɨm da ɨdenat moina gar ke utkunda maka gou wa tɨgomenj. Ajɨ man ɨta gou wa tɨgomenjɨt dor, ɨ ra man tengenjɨt onggɨtyam egomenda kak ke, man b'ogla danda tagoninyɨt moina gar ke utkunda nany dɨde yɨngganwar.” ");
INSERT INTO gdr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ajɨ Petro Yesund yomnonj da, “Kor Yonggyam! Kon b'angonjeni e nɨbnyɨn man kɨma menonɨm de sɨbɨbmet wa ɨ dɨde kwa uj okatam.” ");
INSERT INTO gdr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ajɨ Yesu daka tin yomnonj da, “Petro! Kon men wumɨr motɨnyɨn da man yu sɨwɨny nowapyam e Ken notiyenyɨt dor da, ‘Kon ma wumɨr en Ton,’ ɨ seg ket pauro ara ikeny dor.” ");
INSERT INTO gdr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ɨ kwa Yesu Tina b'auyaena rɨga amninonj da, “Rɨngma, re Kon wen etmɨkeninond pauso kesa ɨ ga kesa ɨ dɨde yongɨnkak kesa, ke wɨn nanggamog gasa mana b'araktondam ingaenam?” Ɨ ton ket mɨra yomno da, “Rawɨr kwa nanggamog mana.” ");
INSERT INTO gdr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Seg Yesu ket ten amninonj da, “Ajɨ yu yete re pauso kɨma rɨga, ton b'ogla yei, ɨ kwa da ga yei. Ɨ ya mana ra giri maka ra ɨbnau, ton b'ogla tina kobɨrgɨm yasog dɨde giri yakat onggɨt wulkɨp ke. ");
INSERT INTO gdr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mop nokɨp Kon wen wumɨr tamninyɨn da onggɨtyam yɨtkak b'ogla rɨrɨrkɨp rain Kor pɨlɨnd rɨnte re yɨna peband ɨrɨki yɨbɨm da, 'Rɨgap Tin b'ɨsagɨkam yomno odede gog erbeka rɨga kɨma yɨpand.’ Ɨ mop nokɨp nangga im re Kor gatab ɨrɨki wekeny yɨna peband re kemb rɨrɨrkɨp auka tui.” ");
INSERT INTO gdr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ɨ b'auyaena rɨgap Yesund mɨra yomno da, “Yonggyam! Yɨr de, sowa osiya ke nɨmog giri.” Ɨ Yesu ket gar bebɨg kɨma esmonggainonj da, “Seg aina! Yebɨkau!” ");
INSERT INTO gdr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ɨ re Yesu Yerusalem taun ke opendonj, ɨ menon yokatonj Olib dor wa Tina sɨram b'ɨrari kesa omnɨka mɨle rɨrɨrɨnd, Tina b'auyaena rɨgap kea daka ket Tin yɨmta yundoko. ");
INSERT INTO gdr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ɨ re ton opekto de Tina pɨpmet wa, Ton ket Tina b'auyaena rɨga amninonj da, “Wɨn b'ogla yɨr topmitenindam, nokɨm da ɨdenat wɨn maka negɨrɨmna b'atonkena wa tegomendenindam.” ");
INSERT INTO gdr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ɨ Yesu sobijog paja wa b'ɨsonkitonj towa pɨlke odede pɨn na rɨngma ra rɨgat gɨmo b'ɨtɨsɨk, ɨ demb de kumsos b'amkonj, ɨ dɨde ket yɨr opmitonj. ");
INSERT INTO gdr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Sɨ ton yindonj da, “Abu! Rada ɨta Mor singi mɨbnau, sɨ Man Kor pɨlke yewaikite onggɨtyam ujɨmna b'ɨdgotnena kapo! Ajɨ goro Koina singind, ajɨ Moina singi ke rawɨk.” ");
INSERT INTO gdr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ngɨrpu ket aneru pɨta awonj pumb ke Yesum pɨlwa, dɨde ket Tin danda yokawonj. ");
INSERT INTO gdr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ɨ Ton ma sobijog na yɨr opmitand ɨsanikesa danda kɨma b'unjora yikenonj ukoi danda kɨma dɨde iror kɨma. Ɨ Tina wɨmɨrkɨp kusɨm b'engkɨto, ɨ kus popokɨp pɨla na gou wa ɨsokto. ");
INSERT INTO gdr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ɨ re Ton yɨr opmita seg awonj, Ton utnyitonj dɨde ɨtendonj b'auyaena rɨga wa pɨlwa. Ajɨ Ton odede wɨn natemb ten adarinonj, re ton gɨm yarɨmɨp yutungand wekenonj. ");
INSERT INTO gdr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Sɨ Yesu ten amninonj da, “Nangga paim wɨn yutungand wekenyɨt? Utnɨkina, ɨ yɨr opmitenina, nokɨm da ɨdenat wɨn maka negɨrɨmna b'atonkena wa tegomendenindam.” ");
INSERT INTO gdr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ɨ re Yesu yɨt opurenand yɨbnonj, rɨga bobo tuwonj. Ɨ twelp (12) ɨtmɨkitijog rɨga wa wɨngɨrɨnd yɨpa rɨga, yogenayo da Yudas, rɨga wɨp teyinonj, dɨde ket Yesund wɨp yowarkitonj Tin omongnenam. ");
INSERT INTO gdr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sɨ Yesu ket tin yomnonj da, “Yudas! Man Rɨgamna B'ɨga omongnena kae tɨb yiyenyɨt?” ");
INSERT INTO gdr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ɨ re rɨga yepiya re Yesum wusɨnd wekenonj, yɨrɨk b'unjomkento da nanggamog mɨle e tawɨk, ton endento da, “Yonggyam! Ma sɨn giri ke tepkindam?” ");
INSERT INTO gdr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sɨ towa wɨngɨrɨnd yɨpa rɨgat giri yingawonj yɨna mopyam sɨ rɨgamna wɨko rɨgam pɨlwa, ɨ ton ket yɨpmarkitawonj tina yɨmjog yɨm tab ke yɨpya rom. ");
INSERT INTO gdr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ajɨ Yesu Tina b'auyaena rɨga amninonj da, “Omandemb seg aina! Goro ket b'usaya omnɨka!” Seg ket Ton onggɨt rɨgamna yɨpya rom yesopayonj dɨde ket tin yɨsakendonj. ");
INSERT INTO gdr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ɨ Yesu ket amninonj yɨna mopyam sɨ rɨga ɨ yɨnamet yɨr ɨpka geja rɨga ɨ dɨde Ju rɨga waina elda rɨga yepiya re tuwonj Tin okatam da, “Wɨn nangga paim Ken okatam notupya giri dɨde kibam kɨma odede ɨt re rɨngmim re rɨgap raskol emdenenanj? ");
INSERT INTO gdr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Re Kon ita bibɨrɨnd wɨn kɨma nɨbnɨkenenyɨmɨn yɨnametɨnd, wɨn maka yɨm aramitenomam Ken okatam. Ajɨ onggɨtyam wɨn re kea wa ma ainy dɨde sɨbɨbɨmna danda wɨra nasim ket aindam.” ");
INSERT INTO gdr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ɨ ton Yesund yokato ɨ ket yɨmtɨtɨk yiyo de yɨna mopyam sɨ rɨgamna met wa, ngɨrpu met kara bora wa b'ɨgarkɨto. Ajɨ Petro re pajapaja na yɨmta undoka yiyonj. ");
INSERT INTO gdr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ajɨ re ket rɨgap wul yɨtano aba ɨnyɨnyɨnd, ton ket yɨpand omnɨka wuwenonj. Sɨ Petro toda kwa kea omitonj towa wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ajɨ re Petro omitonj ngaya wɨp ke, yɨpa wɨko ngɨmngayɨt kea tin yɨr yongonj. Ɨ ton ket Petrond yɨr pɨnpɨn yomnɨkonj dɨde ket windonj da, “Ɨtemb rɨga re toda kea Yesu kɨma yɨpand yɨbnenenonj.” ");
INSERT INTO gdr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ajɨ Petro b'aenonj da, “Kongga! Kon ma wumɨr en Ton.” ");
INSERT INTO gdr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ɨ sobijog wɨn kak ke kwa yɨpa rɨgat Petrond yɨr yongonj, ɨ tin yomnonj da, “Mada kwa ɨtemb Yesu ma yɨpa yɨmta undoka rɨga et.” Ajɨ Petro mɨra yomnonj da, “Rɨga! Kon ma onggɨtyam ogena rɨga en.” ");
INSERT INTO gdr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ɨ ama rɨka re ket yɨpa awa yɨgoukitonj, kwa yɨpa rɨgat daka danda kɨma yɨmjatonj da, “Ɨmɨnjog e. Ɨtemb rɨga toda kwa kea Ton kɨma yɨbnenenonj, mop nokɨp ton re kwa Galili tunggam e.” ");
INSERT INTO gdr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ajɨ Petro yɨsmonggawonj da, “Rɨga! Kon ma wumɨr en nangga gatab im man apureninyɨt.” Ɨ re ton yɨt apureninonj, odedend ket pauro ara yikenonj. ");
INSERT INTO gdr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ɨ ngɨrpu ket Yonggyam wɨp engendonj Petrom pɨlwa, dɨde ket yɨr kakpɨpɨ yɨdrɨkonj. Sɨ Petro kea ket onggɨtyam Yonggyamɨmna opuliti yɨtkak nonyɨk yomdonj rɨna re Ton yomnonj odede da, “Yu sɨwɨny yɨmta kena pauro nɨmogɨm ara tuweny dor, ajɨ man naska Ken ɨta nowapyam notiyenyɨt dor.” ");
INSERT INTO gdr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Seg ton ket bau wa opendonj dɨde ket ma sobijog na gar kopa kɨma yii yindonj. ");
INSERT INTO gdr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ɨ rɨga yepiya re Yesund yɨr yɨteno, ton ket Yesund ipowa kɨma jɨ malɨk omnɨka yiyeno. ");
INSERT INTO gdr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Sɨ ton ket Tin wɨp yutwangko, dɨde ipowa yiyeno odede ɨgekena yɨt kɨma da, “Man b'agenae! Yete Men mipou?” ");
INSERT INTO gdr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ɨ ton kwa kea Tin yɨt omnena yiyeno jogjog b'engabenga ɨsadrena yɨtkak ke. ");
INSERT INTO gdr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ɨ re ket bibɨr yɨsparkonj, Ju rɨga waina elda rɨga, yɨna mopyam sɨ rɨga ɨ kwa Ju rɨga waina gog ouyaena rɨgap yɨpand b'eomkurto. Seg rɨgap ket Yesund yiyo onggɨtyam towaina Sanedrin kot wa b'ɨsagɨkam. ");
INSERT INTO gdr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ɨ ton ket Yesund yingawo da, “Rɨka man Kerisotet? Sɨ sɨn wumɨr nomnine!” Ajɨ Yesu ten esmonggainonj da, “Ra Kon wen wumɨr tamninyɨn, wɨn makwa ɨta gar ke notkasya. ");
INSERT INTO gdr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ɨ ra Kon wen tarkisinyɨn, wɨn makwa ɨta Ken mɨra notɨnya. ");
INSERT INTO gdr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ajɨ yu ke Rɨgamna B'ɨga ɨta omiti ɨbɨm Komkesa Dandam Rɨgɨb Rɨga Godɨmna yɨmjog yɨm tab ke juwai kɨma pɨpmetɨnd.” ");
INSERT INTO gdr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Seg komkesa rɨgap ket yɨgekito da, “Sɨ ɨmɨnjog man Godɨmna b'ɨga et?” Ɨ Yesu ket ten esmonggainonj da, “Owɨ, wɨn ɨmɨnjog na endenindam. Kon ɨtemb jɨ Rɨga.” ");
INSERT INTO gdr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ɨ ton ket endento da, “Nangga mim men ket b'usaya nɨnda yɨr ungata yɨt tarakindam? Mop nokɨp men kemb merainajog yɨpya ke utkundenindam Tina tugɨm ke opureni Godɨnd ɨsadrena yɨtkak.” ");
INSERT INTO gdr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Seg komkesa onggɨtyam rɨga bobo owɨnkɨto, ɨ ket Yesund yiyo Roma gabmani mopyam Pilatom pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ɨ ton ket Pilatom rɨl yogenkauto Yesund kot wa oramitam odede yɨt kɨma da, “Sɨn ke Ti yodarkautondam odede negɨr mɨle opi re Ton sowaina Ju yɨtam rɨgaina mɨle b'anygɨnena nya ke engka eyeninonj, ɨ Ton kwa rɨga ogoka eyeninonj Roma mopyam king Kaisam pɨlwa teks oramkam, ɨ dɨde Ton Tilenggyam b'agenaenonj da, ‘Kon King Kerisoten.’” ");
INSERT INTO gdr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Sɨ Pilato ket Yesund yɨgekitonj da, “Ma Man Ju rɨga waina King et?” Ɨ Yesu tin mɨra yomnonj da, “Owɨ, kemb man mindenyɨt.” ");
INSERT INTO gdr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ngɨrpu Pilato ket yɨt pɨtapɨta yomnonj yɨna mopyam sɨ rɨga wa pɨlwa dɨde rɨga bobo wa pɨlwa da, “Kon makwa onggɨt Rɨgam pɨlɨnd negɨr ma b'ɨsagɨkam rɨl yodaren.” ");
INSERT INTO gdr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ajɨ ton ukoi danda kɨma endento da, “Tonɨt rɨga nenegɨr kana urunyuruny omnena eyeninonj Tina ouyaena ke kupka Yuda eriya nata. Sɨ Ton Galili eriya kena b'atomonj onggɨtyam ouyaena, ngɨrpu ket ikonj dɨkɨnd Yerusalem taunɨnd.” ");
INSERT INTO gdr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ɨ re Pilato onggɨtyam yɨt utkundonj, ton rɨga arkisinonj da, “Sɨ rɨka Ton Galili ke rɨga e?” ");
INSERT INTO gdr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ɨ re ton wumɨr yokatonj da Ton onggɨtyam eriya kena ikonj rɨnte re Erodɨmna danda wɨrand yɨbɨm. Sɨ ton ket Yesund yɨtmɨkitonj Erodɨm pɨlwa, nokɨp onggɨt wɨnɨnd Erod kea de toda kwa yɨbnonj Yerusalem taunɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ɨ re Erod Yesund yɨr yongonj, ton ma sobijog sam na awonj, mop nokɨp ton ma emb jɨ singi aukenenonj Yesund yɨr ongongɨm nokɨp ton kea get ke utkundenonj Ti gatab yɨdɨr yɨt, ɨ dɨde kwa ton singi na yɨr ongongɨm Tina omnɨki kɨd kesa kɨma danda wɨko rɨnte ra Ton omnɨk ti wɨpɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Sɨ Erod Yesund yerkenonj re jogjog b'engabenga gatab kena, ajɨ Yesu makwa ngai tin mɨra yomnenonj. ");
INSERT INTO gdr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ajɨ yɨna mopyam sɨ rɨga dɨde Ju rɨga waina gog ouyaena rɨga owɨnkɨto, dɨde ket ma sobijog danda kɨma na Yesum rɨl ogenka yiyenauto negɨr ma b'ɨsagɨkam. ");
INSERT INTO gdr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Sɨ Erod Yesund ngong engena kɨma yɨtkar omnɨka yiyenonj tina geja rɨga kɨma, ɨ jɨ malɨk yomnɨkonj, ɨ dɨde ket kingɨmna ngɨndngɨnd pɨnpɨn kobɨrgɨm yikitonj, ngɨrpu ket Tin yɨtmɨkitonj Pilatom pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Erod ake Pilato naska re geja rɨga na ebnonda, ajɨ onggɨt bibɨr natemb ket ton rɨgarɨga awonda. ");
INSERT INTO gdr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Sɨ Pilato yɨpand ara emokinonj yɨna mopyam sɨ rɨga ɨ Ju rɨga waina memba ɨ dɨde Ju rɨga. ");
INSERT INTO gdr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ɨ Pilato ten amninonj da, “Wɨn onggɨt Rɨgand kor pɨlwa iya odede negɨr rɨl ogenka kɨma na da Ton re rɨga b'anygɨnena nya ke engka Rɨga e. Yɨr de, kon ke wa wɨpɨnd yɨgekenyɨn waina ogenki negɨr rɨl gatab, ajɨ kon makwa ngai onggɨt Rɨgam pɨlɨnd yodaren yɨpa negɨr mɨle. ");
INSERT INTO gdr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Sɨ Erod toda kwa makwa nangga negɨr na yodarau, mop nokɨp Tin ɨtenda nena yomɨny sowa pɨlwa. Sɨ wɨn kemb yɨr yongya da makwa ɨta yɨpa negɨr mɨle yɨbɨm Ti pɨlɨnd rɨnte ra rɨrɨrkɨp tainy uj ma b'ɨsagɨkam. ");
INSERT INTO gdr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Sɨ onggɨt paemb kon Tin ɨrasken, ɨ ɨngkek ket Tin openjɨn.” ");
INSERT INTO gdr_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Awɨr e) ");
INSERT INTO gdr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ajɨ komkesa rɨga yɨpand b'okta ara wuwenonj da, “Onggɨt Rɨgand uj tama na yeomnene! Ajɨ Baraband sowa yopende!” ");
INSERT INTO gdr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ɨtemb rɨga Baraba re sɨbɨbmet nat oramiti yɨbnonj nokɨp tonɨt onggɨt taunɨnd ukoi nyɨ rɨga kɨma soro kɨma bebɨg mɨle yomnɨkonj dɨde rɨga uj andrɨkinonj. ");
INSERT INTO gdr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ajɨ Pilato b'usaya kwa towa pɨtapɨta amnawonj, nokɨp ton singi na awonj Yesund opendam. ");
INSERT INTO gdr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ajɨ ton ɨja na ara yoikɨndenayo da, “Wul b'agbagɨnd yɨdrɨke! Wul b'agbagɨnd yɨdrɨke!” ");
INSERT INTO gdr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ajɨ Pilato nowam ten amninonj da, “Nangga pae? Nangga ukoi negɨr mɨle na yomnɨkɨm? Kon makwa ngai Ti pɨlɨnd yodaren yɨpa uj okatam negɨr mɨle. Sɨ onggɨt paemb kon Tin ɨrasken, ɨ ɨngkek ket Tin openjɨn.” ");
INSERT INTO gdr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ajɨ rɨgap kea Pilatond ɨl ongka yiyeno ukoijog obairena ara kɨma, dɨde yɨgekeno Yesund wul b'agbagɨnd ɨdrɨkam. Sɨ onggɨtyam towaina obairena arap kea Pilatomna singi gou wa yomnonj. ");
INSERT INTO gdr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Seg ket Pilato kikitum b'ɨsagɨka yɨt yindonj towaina b'arkita rɨrɨrkɨp omnam. ");
INSERT INTO gdr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Sɨ Pilato kea ket Ju rɨga waina b'arkita rɨrɨrɨnd Baraband yopendonj yet re sɨbɨbmetɨnd oramiti yɨbnonj soro kɨma bebɨg mɨle omnɨka map dɨde rɨga uj ondrɨka map. Ajɨ ton Yesund yoramitonj towaina singi rɨrɨrɨnd Tin wul b'agbagɨnd ɨdrɨkam. ");
INSERT INTO gdr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ɨ re Roma geja rɨgap Yesund yiyo, ton ket yɨpa Kurene tunggam Simonɨnd yusunato yet re ikonj wungawungapu tungg ke, dɨde ket Yesumna wul b'agbag ti kumbɨnd yoramito Yesum kakɨnd iyoyɨm. ");
INSERT INTO gdr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ɨ ukoi rɨga bobop Tin yɨmta yundoko, ɨ towa wɨngɨrɨnd nɨnda kongga re dor b'ipowa na wuwenonj dɨde gar kopa kɨma na yii aento Tinɨm. ");
INSERT INTO gdr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ɨ Yesu onggɨt kongga wa pɨlwa wɨp engendonj, dɨde ket ten amninonj da, “Yerusalem taun kongga! Goro Ken yii niyagɨkya! Ajɨ wɨn yii b'eagɨkinam wanɨm dɨde waina b'ɨgawarɨm. ");
INSERT INTO gdr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mop nokɨp ra b'ɨdgotnena wɨn ik dem Yerusalem taunɨnd, rɨgap opima tendenanj dem da, ‘Ton b'ogɨl omni kongga im jɨ yepim re popam ɨ b'ɨga ukki kesa kom ɨ dɨde b'ɨga ngom okki kesa ngom.’ ");
INSERT INTO gdr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","“Ɨ onggɨt wɨnɨnd rɨgap opima b'ɨdgotnena moga map dor tamnenanj dem da, ‘Sɨn nɨpmɨkinam!’ ɨ sukak tamnenanj dem da, ‘Sɨn ujɨm nɨkangɨnjinam!’ ");
INSERT INTO gdr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mop nokɨp rada ton yu odede nenegɨr mɨle im omnɨka eyenanj Kor pɨlɨnd yete re wul nangg pɨla yilo nɨbnyɨn, sɨ nangga e ket tawɨk wa pɨlɨnd dɨde waina b'ɨgawar wa pɨlɨnd, ra onggɨtyam wul nangg uj tainy?” ");
INSERT INTO gdr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ɨ ton kwa nɨmog negɨr raskol rɨga daka yɨpand Yesu kɨma eyo wul b'agbagɨnd ɨdrɨkam. ");
INSERT INTO gdr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ɨ re ton opekto onggɨt pɨpmet wa ogenaya da, “Uj Rɨgamna Mopkak Wɨmenapu Tungg”, ademb de ket Yesund wul b'agbagɨnd yɨdrɨko, ɨ dɨde osiemb nɨmog raskol rɨga daka edrɨko yɨpa re Yesu ma yɨmjog yɨm tab kena ɨ kwa daka yɨpa re Tina sawai yɨm tab kena. ");
INSERT INTO gdr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ɨ Yesu yindonj da, “Abu! Towa negɨr mɨle awɨr amnaine, mop nokɨp ton ma wumɨr im nangga e ton yomnɨki.” Ɨ geja rɨgap Yesumna kobɨrgɨm ɨtaika eyento pes b'arena ke. ");
INSERT INTO gdr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ɨ rɨgap owɨnki Yesund yɨr yɨpko, ɨ Ju rɨga waina membap kea daka Tin jɨ malɨk omnɨka yiyeno da, “Ton nɨnda rɨga wa yɨrkokar akaeneninonj, sɨ rada ɨtemb Rɨga Godɨmna obagendi Keriso e, Ton b'ogla Tilenggyam yɨrkokar yakat.” ");
INSERT INTO gdr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ɨ kwa geja rɨga Ti wus wa tuwonj, dɨde ket todaka Tin jɨ malɨk yomnɨko, ɨ dɨde ket Ti tokɨltokɨl wain yokau onayam. ");
INSERT INTO gdr_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ɨ ton ket endento da, “Rada Man Ju rɨga waina king et, Man b'ogla Molenggyam yɨrkokar b'akae!” ");
INSERT INTO gdr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ɨ kwa ɨja naemb jɨ Yesumna wul b'agbag pumb ke ɨrɨki yɨbnonj da, ");
INSERT INTO gdr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ɨ yɨpa wul b'agbagɨnd ɨdrɨki raskol rɨgat Yesund yɨsadrenonj da, “Ma Man Kerisotet? Sɨ Molenggyam yɨrkokar b'akae, dɨde sowa da yɨrkokar nokae!” ");
INSERT INTO gdr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ajɨ daka yɨpa raskol rɨgat tin yɨsmonggawonj odede samany yɨt kɨma da, “Awɨr e man Godɨnd moga yuwajɨt? Men re Ton kɨma yɨpa rɨrɨr negɨr ma b'ɨsagɨka nasi. ");
INSERT INTO gdr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Sɨ onggɨtyam negɨr ma b'ɨsagɨka re meranɨm dɨmdɨmjog e, mop nokɨp men yokasya re meraina omnɨki mɨle rɨrɨr nate. Ajɨ ɨtemb Rɨga re makwa nanggamog negɨr mɨle na yomnɨkonj.” ");
INSERT INTO gdr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ɨ ton ket Yesund yomnonj da, “Yesu! Man ken nonyɨk notɨmjɨt ra Man meket Moina pumb tungg wa!” ");
INSERT INTO gdr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Sɨ Yesu tin mɨra yomnonj da, “Kon ɨmɨnjog men wumɨr motɨnyɨn da man yu Kon kɨma ɨta mɨtɨbnyɨt dor de otomanti samsam tungg wa.” ");
INSERT INTO gdr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ɨ re ket amaya lomtɨk yokatonj, sɨbɨbɨt kupka gowukoi yɨkangɨndonj, ngɨrpu ama re ket tri (3) kɨlok awonj sɨmana gatabɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sɨ lomkongga ngaya re kea osmantonj. Ɨ kwa ket ukoi gutomgutom kobɨrgɨm rɨna re yɨnametɨnd ewɨrɨnti yɨbnenenonj yɨnayɨna pɨpmet dɨde yɨna pɨpmet ganggand, ton ɨnyɨnyɨnd b'ɨnyowendonj. ");
INSERT INTO gdr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ɨ Yesu ket ukoi kana ara yikenonj da, “Abu! Kon Koina wɨngawɨnga Mor yɨm kumb nate yoramisɨn.” Ɨ onggɨt yɨt seg ke ket Ton uj awonj. ");
INSERT INTO gdr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ɨ re Roma wan andred (100) geja rɨga mopyamɨt mɨle yɨr ongong yiyenonj rɨna re aukonj, ton Godɨnd yesoulitonj odede da, “Ɨmɨnjog e, ɨtemb Rɨga re negɨr kesa dɨmdɨmjog Rɨga e.” ");
INSERT INTO gdr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ɨ komkesa rɨga bobo yepiya re yɨpand wuwenonj onggɨtyam mɨle yɨr ongongɨm, ton kea mɨle yɨr angto rɨna re aukɨto, dɨde ket ton gar bebɨg map dor b'ipowa kɨma ɨtendento. ");
INSERT INTO gdr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ɨ komkesa rɨga yepiya re Yesum wumɨr wekenonj dɨde kongga yepiya re Galili ke Tin yɨmta undoka yiyo, ton paja kena owɨnki wekenonj onggɨtyam mɨle yɨr ɨpkam. ");
INSERT INTO gdr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ɨ yɨpa rɨga nyɨ da Yosep, ton re Arimataya tungg ke rɨga na Yuda eriya wɨngɨrɨnd. Ton re b'ogɨl rɨga na dɨde negɨr kesa dɨmdɨmjog rɨga na yɨbnonj, ɨ dɨde ton God ma pumb tungg na yɨr yungaenenonj. Ɨ kwa ton re yɨpa Ju rɨga waina Sanedrin memba na yɨbnonj, ajɨ ton maka yɨmjatonj rɨna re Ju rɨga waina Sanedrin membap tɨrɨr yomno Yesund ongandam dɨde makwa b'ingaenonj onggɨtyam towaina omnɨka mɨle wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ɨ onggɨt rɨgat ket yikonj Pilatom pɨlwa, ɨ ket tin yerkitonj Yesumna ujgɨm okatam. ");
INSERT INTO gdr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Seg ton nɨnda rɨga kɨma Yesumna ujgɨm wul b'agbag kumb ke yɨjgendo gou wa, dɨde ket kobɨrgɨm ke ujgɨm ponpon yomnɨko, ngɨrpu ket yoramito gɨmo yɨund eski gopmet wa rɨkɨnd re maka yɨpa ujgɨm oramiti yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ɨ ɨtemb bibɨr re b'angonjena bibɨr na awonj Ju rɨga waina wɨram dɨde yɨr opmitena bibɨrɨm, ɨ dɨde ket wɨn re wus wa na auka ikonj onggɨtyam bibɨr otomam. ");
INSERT INTO gdr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ɨ kongga yepiya re Yesu kɨma yɨpand tuwonj Galili eriya ke, ton Tin yɨmta undoka yiyo. Sɨ ton kea yɨr yongo rɨkɨnd re Yesumna ujgɨm yoramito. ");
INSERT INTO gdr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ɨ re kongga ɨtekto, ton ket angonjento ngɨrangngɨrang gasa dɨde gaya ujgɨmɨnd oramkam. Seg ton ket wɨram wekenonj Ju rɨga waina wɨram dɨde yɨr opmitena bibɨrɨnd God ma b'ingawa yɨt rɨrɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ɨ re Ju rɨga waina wɨram dɨde yɨr opmitena bibɨr kak ke naskajog bibɨr awonj, sɨtawarjog konggap eito ngɨrangngɨrang gasa Yesumna gopmet wa rɨna re ton angonjento Yesumna ujgɨmɨnd oramkam. ");
INSERT INTO gdr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ajɨ ton kea yɨr yongo onggɨtyam ukoijog gɨmo rɨna re ururkiti yɨbnonj onggɨtyam gɨmo yɨund oski gopmet mora ke. ");
INSERT INTO gdr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ɨ re ton gɨmo yɨund oski gopmet wɨngɨr wa b'ɨgarkɨto, ton makwa Yonggyam Yesumna ujgɨm yodaro. ");
INSERT INTO gdr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Sɨ ton re onggɨt gatabɨm nonysɨpsɨp na wekenonj, odedend ket nɨmog rɨga onyitonda towa wusɨnd yepiya re ɨnyomarena kɨma kobɨrgɨm b'ikoki awaminonda. ");
INSERT INTO gdr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Sɨ re kongga mogapɨp as ɨroukɨto gou wa, onggɨt rɨgap ten amninonda da, “Nangga pae wɨn yilo ai Rɨgand oraka yiyenya gopmetɨnd uj rɨga wa wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ton awɨr e dɨkɨnd, ajɨ ke utnyis. Wɨn nonyɨk b'amjinam rɨja na re Ton wen wumɨr amninonj, re Ton wɨn kɨma yɨbnenenonj Galili eriyand. ");
INSERT INTO gdr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ton odede yindonj da, ‘Rɨgap b'ogla Rɨgamna B'ɨga negɨr mɨle rɨgaina yɨm kumb wa oramisi dem, dɨde ket onggɨt negɨr mɨle rɨgap Tin wul b'agbagɨnd ɨdrɨki dem, ɨ ɨngkaemb ket nowam bibɨrɨnd Ton ket tutnyis dem.’” ");
INSERT INTO gdr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sɨ konggap omandemb ket nonyɨk amdɨto Yesumna opureni yɨtkak. ");
INSERT INTO gdr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ɨ re ket ton ɨtekto gopmet ke, ton kea onggɨtyam komkesa mɨle usenenauto ileben (11) ɨtmɨkitijog rɨga wa pɨlwa dɨde komkesa rɨga wa pɨlwa yepiya re wekenonj ton kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Sɨ opimemb jɨ kongga, Magdala tunggam Mariya ɨ Yoanna ɨ Yakobom mog Mariya ɨ dɨde nɨnda kongga yepiya re wekenonj ton kɨma. Sɨ tonpiyamb usenenauto onggɨtyam yɨt ɨtmɨkitijog rɨga wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ajɨ onggɨtyam towaina opureni yɨtkak re ɨja na wɨp aukɨto ɨtmɨkitijog rɨga wa wɨpɨnd da nony kesa rɨgaina opureni yɨtkak im, sɨ onggɨt penaemb ton maka ten gar ke akatto. ");
INSERT INTO gdr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ajɨ Petro utnyitonj dɨde ket b'ɨkonj de gopmet wa. Seg ton ket uwontonj, ɨ ket kobɨrgɨm nena na yɨr anginonj, ngɨrpu re ket ton gopmet ke ewaikitonj, ton nony sɨndamara kɨma na yikonj onggɨtyam auki gasa gatab. ");
INSERT INTO gdr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ɨ Yesu ma b'auyaena rɨga wɨngɨrɨnd nɨmog rɨgap menon yokatonda Yerusalem taun ke de yɨpa tungg wa nyɨ da Emmao ama rɨka ileben (11) kilomita pɨn na yɨbnonj Yerusalem taun ke. ");
INSERT INTO gdr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ɨ ton ket towa wɨngɨrɨnd yɨt b'usenena ekonda onggɨtyam komkesa mɨle gatab rɨna re aukɨto. ");
INSERT INTO gdr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ɨ re ton towa wɨngɨrɨnd yɨt b'usenena ekonda dɨde yɨt ɨglenena eyinonda, Yesu ket towa wus wa awonj, dɨde ket ton kɨma yɨpand yikonj. ");
INSERT INTO gdr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ajɨ Godɨt towaina yɨrkɨp utwangkinonj. Sɨ onggɨt penaemb ton maka Yesund yongwatonda. ");
INSERT INTO gdr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ɨ Yesu ket ten arkitonj da, “Nanggamog yɨtkak im wɨn ɨglenena eyinya nyawɨnd?” Ɨ ton osiyamb ket onyitonda gar bebɨg kɨma. ");
INSERT INTO gdr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ɨ towa wɨngɨrɨnd yɨpa rɨga nyɨ da Kleopa Tin yɨsmonggawonj da, “Ma Manɨta Menta obayam wumɨr kesa mɨbnyɨmɨt Yerusalem taunɨnd onggɨt gatab rɨna re onggɨt taunɨnd mɨle aukonj onggɨtyam diyamdiyam wɨnɨnd?” ");
INSERT INTO gdr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Sɨ Yesu ten arkitonj da, “Nangga gasa na aukonj?” Ɨ todaka ket Tin mɨra yomnonda da, “Najaret tunggam Yesum gatab gasa na. Ton re bageyam na yɨbnonj, sɨ Ton wɨko amnɨkeninonj dɨde yɨtkak apureneninonj re danda kɨma na Godɨm wɨpɨnd dɨde komkesa rɨga wa wɨpɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ajɨ meraina yɨna mopyam sɨ rɨga dɨde meraina membapiya Tin uj ma b'ɨsagɨkam yoramito, sɨ ket Tin wul b'agbagɨnd yɨdrɨko. ");
INSERT INTO gdr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Sɨn nony b'ɨjawa yoramitonda Ti pɨlɨnd da Ton ɨta mera Israel kantri ɨtrɨngenj meraina geja rɨga wa pɨlke. Ɨ kwa tumɨnd indondɨm da yu kemb nowam bibɨr e ainy onggɨtyam mɨle auki seg ke. ");
INSERT INTO gdr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ɨ b'usaya kwa tumɨnd indondɨm da sowa wɨngɨrɨnd nɨnda konggap sɨn kɨd kesa nomnanj. Ton sɨtawarjog na wui de Yesumna gopmet wa, ");
INSERT INTO gdr_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ajɨ ton makwa Tina ujgɨm yɨr yongi, ɨ re ton ɨtekanj, ton ket sɨn wumɨr nomnanj da, ‘Sɨn aneru kea liyalliyal yɨr angu yepiya re endenya da Ton ke yilo e ainy.’ ");
INSERT INTO gdr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ɨ kwa sɨn kɨma wɨmena rɨga wɨngɨrɨnd nɨmog rɨga kea ekya de onggɨt gopmet wa, dɨde ket ɨja na gasa adarkinya rɨja na re konggap b'agenairanj, ajɨ ton maka Yesund yɨr yongya.” ");
INSERT INTO gdr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ɨ Yesu ket ten amnonj da, “Wɨn nony menamena kutjog rɨga i. Sɨ wɨn ɨl b'angnena kana im bageyam waina komkesa opureni yɨtkak gar ke akateninya. ");
INSERT INTO gdr_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ma onggɨtyam mɨle b'ogɨl im rɨrɨrkɨp taukanj Kerisom pɨlɨnd? Sɨ onggɨt paemb Ton b'ogla onggɨtyam b'ɨdgotnena rakatenin dɨde Tina b'ogɨl ɨnyomarena wa b'egarɨk.” ");
INSERT INTO gdr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ɨ Yesu ket yɨt b'atomonj Mosemna peba ke ngɨrpu de komkesa bageyam waina peba wa, ɨ ket towa esɨpkenawainonj komkesa Ti gatab ɨrɨki yɨtkak onggɨtyam peba wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ɨ re ton onggɨt tungg wus wa aukɨto rɨtade re ton ekonda, Yesu ɨja na wɨp awonj da onggɨt tunggɨnd topanjis-a de yɨpa tungg wa. ");
INSERT INTO gdr_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ajɨ nɨmog rɨgap danda kɨma Tin yognenonda da, “Omanda sɨn kɨma ɨtende, nokɨp ke momta e sɨ imoka, ɨ lom da ke awɨr e auka yik!” Seg Yesu ket ɨtendonj dɨde b'ɨgaronj yɨpa met wa ton kɨma wɨmenam. ");
INSERT INTO gdr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ɨ re Yesu omitonj ton kɨma diyamɨm, Ton ket yɨpa sana nganja yokatonj, ɨ ket Godɨnd sɨteket yɨt yomnonj, ɨ ket yipkɨkonj dɨde towa akawonj. ");
INSERT INTO gdr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Sɨ omandemb ket God nɨmog rɨgaina yɨrkɨp apngenjinonj, sɨ ɨngkenaemb ket ton Tin yongwatonda. Ngɨrpu omandemb ket Yesu towa yɨrɨnd b'eomnenonj. ");
INSERT INTO gdr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Seg ton towalenggyam b'arkena ekenonda da, “Ma kea Tina yɨtɨt men ɨsanikesa gar nokateny, re Ton nyawɨnd men yɨt nomneny dɨde peba yɨt mera esɨpkeniny?” ");
INSERT INTO gdr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ɨ ton odenja ket utnyita nena awonda, dɨde ket ɨtendonda de Yerusalem taun wa. Seg ademb de ton ket b'eomi adarinonda ileben (11) ɨtmɨkitijog rɨga dɨde nɨnda rɨga yepiya re ton kɨma wekenonj. ");
INSERT INTO gdr_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ɨ ileben (11) ɨtmɨkitijog rɨga dɨde nɨnda rɨga yepiya re ton kɨma wekenonj towa usekawo da, “Yonggyam ke ɨmɨnjog utnyis, dɨde kea Ton pɨtapɨta ainy Simonɨm wɨpɨnd.” ");
INSERT INTO gdr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ngɨrpu todaka nɨmog rɨgap ket usekainonda nanggamog mɨle na re aukonj nyawɨnd dɨde rɨja na re ton Yesund yongwatonda, re Ton sana nganja yipkɨkonj. ");
INSERT INTO gdr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ɨ re ton onggɨtyam yɨt ɨpnenand wekenonj, odedend ket Yesu towa wɨngɨrɨnd onyitonj dɨde ket ten simesime amninonj da, “Ngɨmbla wɨn kɨma.” ");
INSERT INTO gdr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ajɨ ton re wɨnga kesa na dɨde moga na aukɨto, ɨ ton ɨja na nony aukɨto da, “Sɨn wɨngawɨnga e yɨr yongu.” ");
INSERT INTO gdr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Sɨ Yesu ten amninonj da, “Nangga paim wɨn moga aindam, ɨ nangga paim wɨn waina garɨnd nonysɨpsɨp aukindam? ");
INSERT INTO gdr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ɨtenemb jɨ Kon Rɨga. Wɨn yɨr anginam Koina yɨm dɨde pɨs. Wɨn Ken nesopaya dɨde yɨr nonga! Wɨngawɨngam ma opima ti mɨ dɨde kak, ajɨ Kor opima mɨ dɨde kak odede rɨja e re wɨn Ken yɨr nongya.” ");
INSERT INTO gdr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ɨ re Ton onggɨtyam yɨt apureninonj, Ton ket towa auyainonj ɨdrɨki yɨra Tina yɨmɨnd dɨde pɨsɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ɨ re ton ukoi samɨnd wekenonj, ton makwa Tin gar ke yokato, ajɨ ton kɨd kesa na aento. Odedend ket Yesu ten egekisinonj da, “Ɨta wa nangga e owowɨm dɨkɨnd yɨbɨm?” ");
INSERT INTO gdr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Sɨ ton ket kabum ogni kɨb Ti yokawo. ");
INSERT INTO gdr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ngɨrpu Yesu ket yokatonj dɨde ket towa wɨpɨnd yongonj. ");
INSERT INTO gdr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ɨ Yesu ket ten amninonj da, “Ɨnaemb jɨ Kon yɨt apureninond wanɨm, re Kon nɨbnenenond wɨn kɨma da komkesa yɨtkak b'ogla rɨrɨrkɨp taukanj rɨnsim re ɨrɨki wekeny Kor gatab Mosemna gog peband ɨ bageyam waina peband ɨ dɨde Ger peband.” ");
INSERT INTO gdr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ɨ onggɨt wɨnɨnd ket Yesu towaina gar epangkinonj onggɨt yɨna peba yɨtkak isɨpmaram. ");
INSERT INTO gdr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ɨ Yesu ket ten amninonj da, “Ɨja emb jɨ yɨna peband ɨrɨki wekeny odede da Keriso ɨta b'ɨdgotnena okas dem dɨde uj ke tutnyis dem Tina uj kak ke nowam bibɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ɨ dɨde rɨgap opima negɨr mɨle ke engenda gatab yɨt pɨtapɨta tamnenanj dem Tina nyɨ kɨma, nokɨm da ɨdenat God towaina negɨr mɨle awɨr tamnainy. Sɨ onggɨtyam pɨtapɨta omnena mɨle b'atom ra dem Yerusalem kae de komkesa b'engabenga yɨtam rɨga wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Sɨ wɨn re onggɨtyam gasa gatab yɨr ungatayam rɨga im. ");
INSERT INTO gdr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Sɨ yɨr de, Kon ɨta Yɨnayɨna Wɨngawɨnga ɨtmɨkisɨn dem wanɨm yena re Kor B'u tɨrɨr yomnonj wanɨm ɨtmɨkitam. Sɨ onggɨt paemb wɨn omanda tekenyɨt onggɨt taunɨnd, ngɨrpu ra Ton Tina danda ke wen tekokiny dem rɨnte ra pumb ke tinɨk dem.” ");
INSERT INTO gdr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ɨ re ket Yesu Tina b'auyaena rɨga wɨp eyinonj ngɨrpu de Betaniya tungg wus wa, Ton Tina yɨm urowatonj, ngɨrpu Ton ket ten b'ogɨl amninonj. ");
INSERT INTO gdr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ɨ re Ton ten b'ogɨl amnɨkinonj, odedend ket Ton towa pɨlke yiwatonj, ɨ God ket Tin yiyonj de pumb tungg wa. ");
INSERT INTO gdr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Seg ket Tina b'auyaena rɨgap Tin kumsos yemko, ngɨrpu ton ket ukoijog sam kɨma ɨtekto de Yerusalem taun wa. ");
INSERT INTO gdr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ɨ ton ket ita wɨnɨnd yɨnametɨnd wekenenonj dɨde Godɨnd yesoureneno. ");
INSERT INTO gdr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","God yɨmta kena komkesa gasa atobarkinonj, ajɨ Yɨtkak re adea de naska get ke yɨbnonj. Ɨ ɨtemb Yɨtkak adea de yɨbnonj God kɨma. Sɨ ɨtemb Yɨtkak re Godte. ");
INSERT INTO gdr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Otomapu wa onggɨt wɨnɨnd re God komkesa gasa atobarkinonj, ɨtemb Yɨtkak, Ton kea adea de yɨbnonj God kɨma. ");
INSERT INTO gdr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","God komkesa gasa atobarkinonj re onggɨt Yɨtkakɨm pɨlkena. Sɨ onggɨt Yɨtkak kesa makwa ngai yɨpa gasa aukonj rɨnsim re otobarki wekeny. ");
INSERT INTO gdr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yɨrkokar yɨbnonj re onggɨt Yɨtkakɨm pɨlnat, sɨ onggɨtyam yɨrkokarɨt ngaya na teteawonj rɨga wa. ");
INSERT INTO gdr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ɨ ɨtemb ngaya b'anyoratena ikonj re sɨbɨb nat. Ajɨ onggɨt sɨbɨbɨt makwa rɨrɨr na awonj ɨtemb ngaya osoukam. ");
INSERT INTO gdr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ɨ God yɨpa rɨga yɨtmɨkitonj, ɨ ton ket pɨta awonj. Tina nyɨ re Yoanɨt. ");
INSERT INTO gdr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ton ikonj re onggɨt ngaya gatab yɨr ungata yɨt rɨga wa pɨtapɨta omnena mana. Nokɨm da ɨdenat tina yɨt ke komkesa rɨgap gar ke utkunda okasi. ");
INSERT INTO gdr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yoan re ma ton tilenggyam onggɨtyam ngaya na. Ajɨ ton ikonj re onggɨt ngaya gatab yɨr ungata yɨt pɨtapɨta omnena mana. ");
INSERT INTO gdr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ɨtemb re ɨmɨnjog ngaya na rɨnsim re komkesa rɨga ngaya anyorkeneniny. Sɨ ɨtemb ngaya kea ikonj onggɨt gowukoi wa. ");
INSERT INTO gdr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ɨ Ton kea onggɨt gowukoyɨnd yɨbnonj. Sɨ God onggɨtyam gowukoi Ti pɨlkena yotobarkonj. Ajɨ onggɨtyam gowukoyɨt maka Tin yongwatonj. ");
INSERT INTO gdr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ɨ Ton ikonj Tinajog Yuda Kantri wa. Ajɨ Tinajog rɨgap Tin maka singi yiyeno, ajɨ yɨsayowa. ");
INSERT INTO gdr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ajɨ yepiya ra Tin Yonggyamɨm ɨmjatenyi dɨde Tina nyɨwɨm pɨlɨnd gar ke utkunda oramisi, God opima towa danda takainy Tina b'ɨga awowɨm. ");
INSERT INTO gdr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Sɨ opimemb God ma b'ɨga ukukenenanj re ma rɨgaina kus nya kaim, o rɨgaina gɨm ke singi kaim, o leomna singi kaim. Ajɨ Godɨm pɨlkaima ukukenenanj. ");
INSERT INTO gdr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ɨ ɨtemb Yɨtkak rɨga jɨwɨm awonj. Ɨ ket Ton sowa wɨngɨr nat wɨmena yikenonj. Sɨ sɨn kea Tina b'ogɨl ɨnyomarena yɨr ongong yiyenonda. Ɨtemb b'ogɨl ɨnyomarena re lesmɨta B'ɨgamna e yet re ikonj B'uɨm pɨlke. Ton re wurar dɨde ɨmɨnjog yɨtkak ke yɨndangɨr omni na. ");
INSERT INTO gdr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Sɨ Yoan Ti gatab yɨr ungata yɨt pɨtapɨta amneninonj, ɨ ket danda kɨma unenonj odede da, “Ɨtemb jɨ rɨga yena re kon yomnond da, ‘Yɨpa rɨga ɨta kor kak ke ik, ɨ Ton re ukoijog rɨga e, ajɨ kon re goujog rɨga en, nokɨp Ton kea de get ke yɨbnonj re kon maka ukendond.’” ");
INSERT INTO gdr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Sɨ Ton re wurar dɨde ɨmɨnjog yɨtkak ke yɨndangɨr auki na, sɨ men komkesa Ti pɨlkaim usausapyam wurar okatena eyenindam. ");
INSERT INTO gdr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mop nokɨp God Tina gog yɨt aramisinonj re Mosem pɨlnat, ɨ Mose akainonj Israel rɨga wa. Ajɨ osiemb wurar dɨde ɨmɨnjog yɨtkak tetkonda re dɨmdɨm Yesu Kerisom pɨlkena. ");
INSERT INTO gdr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Makwa ngai ke yɨpa rɨgat Godɨnd yɨr yongonj. Ajɨ lesmɨta B'ɨga, Ton Tilenggyam re God e yet re ikonj B'uɨm pɨlke. Sɨ Tonɨtemb rɨga wa pɨlwa Godɨnd pɨtapɨta yomnenonj. ");
INSERT INTO gdr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ɨ Ju rɨgap yepiya re Yerusalem taunɨnd wekenonj, ton nɨnda sɨ rɨga dɨde Lebi rɨga emdɨto, ɨ ket etmɨkurto Yoanɨm pɨlwa erkenam da, “Yetet man?” Sɨ onggɨt wɨnɨnd kea Yoan yɨr ungata yɨt apulisinonj. ");
INSERT INTO gdr_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ajɨ ton maka b'aimantonj dɨde ton kea tilenggyam ɨmɨnjog ke towa pɨtapɨta amnawonj da, “Kon ma Kerisoten.” ");
INSERT INTO gdr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Seg ton ket yerkeno da, “Sɨ yetet man ket? Man Eliyatet?” Ɨ Yoan amninonj da, “Nayɨ, ma kon Ton ten.” Ɨ kwa yomno da, “Ma man onggɨtyam bageyam tet yena re God tɨrɨr yomnonj ɨtmɨkitam?” Ɨ ton ket mɨra amninonj da, “Nayɨ”. ");
INSERT INTO gdr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ngɨrpu ton kikitumjog yomno da, “Sɨ yetet man ket? Man sowa mɨra yɨtkak nokaine towanɨm yepiya re sɨn nɨtmɨkuranj. Man rɨja e ket molenggyam b'atgenaet?” ");
INSERT INTO gdr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Sɨ Yoan mɨra amninonj odede rɨja na re bageyam Isaya yindonj da, “Kon re bage yɨt unenam nonykok en wul kesa tunggɨnd da, ‘Wɨn Yonggyamɨmna nya dɨmdɨm yomnɨka!’” ");
INSERT INTO gdr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ɨ omanda ta nɨnda Parisai rɨgaina ɨtmɨkuri rɨga wekenonj. ");
INSERT INTO gdr_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Sɨ ton Yoanɨnd yerkito odedemb da, “Nangga pae man daka rɨga baptiso amnɨkinyɨt, rada man ma Kerisotet, Eliyatet, ɨ onggɨtyam bageyamtet yena re God tɨrɨr yomnonj ɨtmɨkitam?” ");
INSERT INTO gdr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Seg Yoan ten mɨra amninonj da, “Kon nyɨ kaim rɨga baptiso amnɨkinyɨn. Ajɨ wa wɨngɨrɨnd yɨpa Rɨga ɨta onyiti yɨbɨm yena re wɨn maka yongwasya. ");
INSERT INTO gdr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Sɨ Ton ɨta ik kor yɨmta ke. Sɨ kon ma rɨrɨrkɨpjog rɨga en Tina yongɨnkak kai ɨtreka wɨko omnɨkam rɨna ra goujog wɨko rɨgat mɨle omnɨk.” ");
INSERT INTO gdr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Onggɨtyam komkesa mɨle aukɨto re Betaniya taun nat rɨna re Yordan kɨlɨmɨnd yɨpa tab wa yɨbnonj. Yoan rɨga baptiso amnɨkinonj re onggɨtyam taun natemb. ");
INSERT INTO gdr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Seg yɨpa bibɨr kak ke Yoan Yesund yɨr yongonj re Ton ti wɨpwɨp ikonj. Ɨ Yoan yindonj da, “Yɨr de, God ma Mamoi B'ɨga, yete re urowateniny gowukoi rɨgaina negɨr mɨle. ");
INSERT INTO gdr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Sɨ kon ɨnaemb jɨ rɨga yomnenond da, ‘Yɨpa rɨga ɨta kor kak ke ik. Ɨ Ton re ukoijog pumb rɨga e ajɨ kon re goujog rɨga en, nokɨp Ton kea de get ke yɨbnonj re kon maka ukendond.’ ");
INSERT INTO gdr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Koda makwa naskand Tin yongwatond. Ajɨ kon netkond dɨde yu nyɨ ke rɨga baptiso amnɨkinyɨn, nokɨm da ɨdenat kon Israel rɨga wa tauyaenyɨn onggɨtyam rɨga.” ");
INSERT INTO gdr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ɨ Yoan ɨtemb jɨ ket yɨpa yɨr ungata yɨt pɨtapɨta amnawonj da, “Kon yɨr yongen Yɨnayɨna Wɨngawɨngand. Ɨ Ton ket eouka ik wub kumb ke gimai re dɨde, ɨ ket Ti kumbɨnd igis. ");
INSERT INTO gdr_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ɨ koda kwa maka Tin yongwasɨn. Ajɨ Godɨt ken nɨtmɨkitonj nyɨ ke rɨga baptiso omnɨkam. Tonɨtemb wumɨr nomnonj da, ‘Man ɨta Yɨnayɨna Wɨngawɨngand yɨr iyɨt eoukand dɨde igitand yɨpa rɨgam kumbɨnd. Sɨ ɨndamaemb jɨ man ongwasɨt da ɨtemb jɨ Rɨga yet ra Yɨnayɨna Wɨngawɨnga ke rɨga baptiso tamnɨkiny.’ ");
INSERT INTO gdr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Sɨ kon kea onggɨtyam mɨle yɨr yongen. Sɨ onggɨt paemb kon ket yɨr ungata yɨt nitinjɨn da, ‘Ɨt re jɨ Rɨga God ma B'ɨga e.’” ");
INSERT INTO gdr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yɨpa bibɨr kak ke Yoan b'usaya tina nɨmog b'auyaena rɨga kɨma owɨnki wekenonj. ");
INSERT INTO gdr_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ɨ re Yesu menon yokatonj, Yoan Ti pɨlwa yɨr b'ɨskonj dɨde ket yindonj da, “Yɨr de, God ma Mamoi B'ɨga!” ");
INSERT INTO gdr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Sɨ re onggɨtyam nɨmog b'auyaena rɨgap tina opureni yɨtkak utkundonda, ton kea ket Yesund yɨmta yundokonda. ");
INSERT INTO gdr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ɨ Yesu ɨtaingitonj dɨde ket ten yɨr angonj Tin yɨmta undokand. Ɨ ket ten arkitonj da, “Wɨn nangga e oraka iya?” Ɨ ton ket Tin yomnonda da, “Rabi! Rokate Man mɨbnyɨt?” (Rabi engendi yɨtkak re ouyaena rɨga e.) ");
INSERT INTO gdr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Seg Yesu ten amnonj da, “Ayo tetka! Ɨ ɨta yɨr ongya.” Sɨ onggɨt penaemb ton ekonda, ɨ ket pɨpmet yɨr yongonda rɨkɨnd re Ton yɨbnonj. Ɨ ton ket Yesu kɨma adea de ebnonda onggɨt bibɨrɨnd. Ɨ wɨn re ket sɨmana gatab powa (4) kɨlok awonj. ");
INSERT INTO gdr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Sɨ osi re nɨmog rɨga yepiya re Yoanɨnd yutkundonda, ton kea ket Yesund yɨmta yundokonda. Sɨ osi re onggɨt nɨmog rɨga wɨngɨrɨnd, yɨpa rɨga re Simon Petrom yɨnggan Andreat. ");
INSERT INTO gdr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ɨ ɨtemb re rɨga Andrea naskajog gasa yomnɨkonj re tinajog nany Simon na yodaronj. Sɨ ton ket wumɨr yomnonj da, “Sɨn kea Mesiyand yodarya.” (Mesiya engendi yɨtkak re Kerisote.) ");
INSERT INTO gdr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ɨ ton ket ti nanyɨnd iyonj Yesum pɨlwa. Ɨ re Yesu Simonɨnd yɨr yɨpkonj, Ton ket yomnonj da, “Man re Yoanɨm b'ɨga, Simontet. Rɨgap men ket nyɨ motgenai ra Kepa kae.” (Kepa engendi yɨtkak re Petrote.) ");
INSERT INTO gdr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Yɨpa bibɨr kak ke re Yesu singi awonj Galili eriya wa menonɨm, Ton kea ket Pilipɨnd yodaronj. Seg Yesu ket tin yomnonj da, “Yɨmta nundoke!” ");
INSERT INTO gdr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ɨ Pilip re Betsaida taun ke rɨga na, sɨ toda Andrea ake Petro re onggɨtyam yɨpaina taun ke rɨga i. ");
INSERT INTO gdr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ɨ Pilip ket Natanaelɨnd yodaronj dɨde ket wumɨr yomnonj da, “Sɨn kea jɨ rɨga yodaru ya gatab na re Mose gog yɨt peband yɨrɨkonj dɨde bageyamɨp erɨkto. Ton re Najaret tunggam Yesute, Yosepɨmna B'ɨga.” ");
INSERT INTO gdr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Sɨ Natanael Pilipɨnd yerkitonj da, “Ma Najaret? Sɨ ɨta nangga b'ogɨl e ik onggɨt tungg ke?” Ɨ Pilip ket daka yomnonj da, “Metkɨm! Ɨta yɨr onget.” ");
INSERT INTO gdr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ɨ re Yesu Natanaelɨnd yɨr yongonj menonɨnd Ti pɨlwa, Ton kea ti gatab yindonj da, “Yɨr de! Ɨtemb jɨ ɨmɨnjog Israel rɨga. Ti pɨlɨnd awɨr e kwa b'anygɨnena mɨle.” ");
INSERT INTO gdr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Seg Natanael Yesund yerkitonj da, “Man nangga wumɨr kae odede nomnyɨt?” Ɨ Yesu ket mɨra yomnonj da, “Kon naska nata yɨr mongen re man pig wul wɨrand mɨbnyɨt. Ɨ ɨngkena ket Pilip men ara memok.” ");
INSERT INTO gdr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Sɨ ɨngkenaemb ket Natanael Yesund pɨtand yomnonj da, “Ouyaena Rɨga-wɨi! Man re God ma B'ɨga et. Ɨ Man re Israel King et.” ");
INSERT INTO gdr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ɨ Yesu ket tin yomnonj da, “Ma man onggɨt pae Kor pɨlɨnd gar ke utkunda yoramisɨt re Kon wumɨr momnyɨn da Kon ke men yɨr mongen pig wul wɨrand? Onggɨtyam mɨle re ma ukoi im, ajɨ man opima ket ukoijog mɨle yɨr tanginyɨt.” ");
INSERT INTO gdr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ɨ Yesu ket yɨt yɨsmontonj da, “Kon ɨmɨnjogjog wen tamninyɨn. Wɨn ɨta wub yɨr ongya dem ɨpangendand, ɨ ket opima aneru yɨr teyenindam dem pumb wa menonɨnd Rɨgamna B'ɨgam pɨlke dɨde pumb ke inkand kwa Ti pɨlwa.” ");
INSERT INTO gdr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Re nowam bibɨr yokatonj, yɨpa molkongga awowɨm mɨle aukonj Kana taunɨnd Galili eriya wɨngɨrɨnd. Ɨ Yesumna mog re kea de wɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Sɨ onggɨtyam molkongga awowɨm mɨle yonggyamwarɨp kea Yesu dɨde Tina b'auyaena rɨga engaukɨto. Sɨ todaka ket kea de wekenonj. ");
INSERT INTO gdr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ɨ onggɨtyam mɨlepund bebɨg aukonj re obai omnam ɨk kea b'undwatto. Sɨ Yesumna mog ket Yesund yomnonj da, “Towa ke awɨr im ɨk.” ");
INSERT INTO gdr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ɨ Yesu mɨra womnonj da, “Kongga! Nangga pae man onggɨtyam bebɨg Kor pɨlwa iyɨt? Kor makaya wɨn rɨrɨrkɨp ainy odede wɨko omnɨkam.” ");
INSERT INTO gdr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Sɨ Ti mog wɨko rɨga amninonj da, “Wɨn ɨja ima gasa tamnɨkindam rɨja im ra Ton wen tengainy omnɨkam.” ");
INSERT INTO gdr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ɨ onggɨt wɨnɨnd Ju rɨga wa kea yɨpa ɨseka mɨle ebnawonj. Sɨ onggɨt mop penaemb jɨ siks (6) gɨmo ke omnɨki nyɨkak dɨkɨndemb wekenonj onggɨt metɨnd. Ɨ yɨpa nyɨkak b'ogɨl e owam ama rɨka eiti (80) lita o mɨnda wan andred twenti (120) lita nyɨ. ");
INSERT INTO gdr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ɨ Yesu ket wɨko rɨga amninonj da, “Wɨn nyɨkak angjɨkina nyɨ ke!” Seg ton ket nyɨkak angjɨkto ngɨrpu yɨndangɨr aukɨto. ");
INSERT INTO gdr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ɨ Yesu ket ten amninonj da, “Otade wɨn nyɨ aurokina dɨde ket eyinam de diyamdiyam mopyam rɨgam pɨlwa!” Seg ton ket eito. ");
INSERT INTO gdr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Sɨ onggɨtyam diyamdiyam mopyamɨt ket nyɨ ke auki ɨk met yotonkitonj. Ajɨ ton maka wumɨr yokatonj rɨngkena iyo. Ajɨ onggɨtyam wɨko rɨga yepiya re nyɨ aurokɨto, tonpiya tenta wumɨr wekenonj. Sɨ onggɨtyam diyamdiyam mopyam rɨgat sisɨl kongga kɨma rɨgand ara yɨawonj da, “Metkɨm!” ");
INSERT INTO gdr_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ɨ ton ket tin yomnonj da, “Sɨ ɨja emb jɨ komkesa rɨgaina mɨle, ton naska b'ogɨl ɨk im taramitauranj ɨngauki rɨga wa. Ɨ ra ɨkɨt ten takasiny, ɨngkaemb ket burakak ɨk taramitauranj. Ajɨ man b'ogɨl ɨk na so ameninyɨt ngɨrpu ɨte re ket otade.” ");
INSERT INTO gdr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Sɨ Yesu onggɨtyam naskajog kɨd kesa kɨma danda wɨko yomnɨkonj re Kana taun nat Galili eriya wɨngɨrɨnd. Ɨ onggɨt omnɨka kenaemb Ton Tina b'ogɨl ɨnyomarena pɨta wa yomnonj. Ɨ Tina b'auyaena rɨgap toda kwa onggɨt omnɨka kenaemb gar ke utkunda yoramito Ti pɨlɨnd da, “Ton re God ma B'ɨga, Keriso e.” ");
INSERT INTO gdr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Onggɨt kak ke Yesu, Ti mog, Ti yɨngganwar ɨ dɨde Tina b'auyaena rɨga kɨma wuwonj de Kaparnaum taun wa. Sɨ ton demb de ma jog bibɨr na wekenonj. ");
INSERT INTO gdr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ɨ re Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam Wɨn wus wa awonj, Yesu ket yikonj Yerusalem taun wa. ");
INSERT INTO gdr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ɨ re Yesu yɨnamet aba wa yikonj, Ton kea yɨr anginonj kau b'asoga rɨga, mamoi b'asoga rɨga, gimai b'asoga rɨga ɨ dɨde wulkɨp sensi omnena rɨga yepiya re kasand omnɨki wekenonj. ");
INSERT INTO gdr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ɨ Yesu ket b'ipowa kai yɨraskonj. Seg Ton ket komkesa b'asoga rɨga dɨde wulkɨp sensi omnena rɨga eaukeninonj yɨnamet aba ke, toda kwa kea mamoi dɨde kau. Ɨ Ton ket wulkɨp sensi omnena rɨgaina koin egmarkinonj. Ɨ kwa ket towaina kasa gu etongeninonj. ");
INSERT INTO gdr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ɨ Ton ket gimai b'asoga rɨga amninonj da, “Wɨn ɨngkek ewaikurina jɨ onggɨtyam gasa. Goro Kor B'u ma met yomnɨkya gasa b'asogapu metɨm.” ");
INSERT INTO gdr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ɨ re Yesumna b'auyaena rɨgap onggɨtyam auki mɨle yɨr yongo, ton kea nony aukɨto onggɨtyam yɨtkak rɨnte re yɨna peband ɨrɨki yɨbɨm da, “Abu kon moina metɨm ukoi singi e aukenenyɨn, sɨ onggɨtyam ukoi singite ken mu pembpemb omnɨka niyeneny.” ");
INSERT INTO gdr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ɨ re Ju rɨga waina wɨp iyoi rɨgap onggɨtyam Yesumna mɨle yɨr angto, sɨ onggɨt penaemb ton ket Yesund yerkito da, “Man kea odede mɨle amnɨkinyɨt. Sɨ Man nangga kɨd kesa kɨma danda wɨko im sowa notouyainyɨt rɨngkae ra sɨn Moina danda ɨmjasu da Man rɨrɨr et onggɨtyam mɨle omnɨkam?” ");
INSERT INTO gdr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu ket mɨra amninonj da, “Wɨn onggɨtyam yɨnamet yiyogɨka! Sɨ Kon b'ogɨl e b'usaya orangen nowa bibɨr wɨngɨrɨnd.” ");
INSERT INTO gdr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Seg Ju rɨga waina wɨp iyoi rɨgap yɨsmonggawo da, “Rɨgap onggɨtyam yɨnamet yorango re poti siks (46) kemag kɨma na. Ma sɨ Man nowa bibɨr wɨngɨr nate ɨtemb met oranget dem?” ");
INSERT INTO gdr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ajɨ Yesu onggɨtyam yɨnamet gatab yɨtnono aenonj re Tina jɨ mana. ");
INSERT INTO gdr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ɨ re Yesu yɨmta ke utnyitonj uj ke, Tina b'auyaena rɨgap kea nony aukɨto nangga gatab na re Ton yɨtnono aenonj. Sɨ onggɨt kak kenaemb ton gar ke utkunda yoramito yɨna peband dɨde onggɨtyam yɨtkak rɨna re Yesu apureninonj. ");
INSERT INTO gdr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ɨ re Yesu Yerusalem taunɨnd yɨbnonj Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam Wɨn wɨngɨrɨnd, Ton ademb de nɨnda kɨd kesa kɨma danda wɨko amnɨkinonj. Sɨ re rɨgap onggɨtyam Tina wɨko yɨr angto, kea jogjog rɨgap gar ke utkunda yoramito Tina nyɨwɨm pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ajɨ Yesu maka Tina nony b'ɨjawa yoramitonj towa pɨlɨnd. Mop nokɨp Ton wumɨr na komkesa rɨga. ");
INSERT INTO gdr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Sɨ Yesu ma singi na awonj rɨga wa pɨlke rɨga wa gatab yɨr ungata yɨt okatam. Mop nokɨp Ton wumɨr e nangga e yɨbɨm rɨgaina garɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ɨ yɨpa rɨga yɨbnonj Parisai rɨga wa wɨngɨrɨnd, ɨ tina nyɨ re Nikodemot. Ɨ ton re Ju rɨga waina wɨp iyoi rɨga na. ");
INSERT INTO gdr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ɨ yɨpa sɨwɨnyɨnd, ton ket yikonj Yesum pɨlwa, ɨ ket Yesund yomnonj da, “Ouyaena Rɨga-wɨi! Sɨn wumɨr im da man Godɨm pɨlke metkot re ouyaena rɨga na. Mop nokɨp ra maka ra God yɨpa rɨgam pɨlɨnd ɨbɨm, ton makwa rɨrɨr e odede kɨd kesa kɨma danda wɨko tamnɨkiny rɨnsim re man amnɨkeneninyɨt.” ");
INSERT INTO gdr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Seg Yesu ket tin mɨra yomnonj da, “Kon ɨmɨnjogjog men motɨnyɨn. Ra man maka b'usaya tukenjɨt, man ma rɨrɨr et God ma pumb tungg yɨr ongongɨm.” ");
INSERT INTO gdr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ɨ Nikodemo daka Yesund yerkitonj da, “Sɨ rɨdede e kwa rɨgajog tukenj? Rɨrɨr e ton ti mogɨmna kom bora wa b'ɨtgar, ɨ ket tukenj?” ");
INSERT INTO gdr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu ket mɨra yomnonj da, “Kon ɨmɨnjogjog men motɨnyɨn. Ra yɨpa rɨga maka ra tukenj nyɨ dɨde Yɨnayɨna Wɨngawɨnga ke, ton ma rɨrɨr e God ma pumb tungg wa b'ɨtgar. ");
INSERT INTO gdr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sɨ gɨm ke rɨga jɨ re rɨgaina jɨ kae tukenj, ajɨ wɨngawɨnga ke rɨga re Yɨnayɨna Wɨngawɨnga kae tukenj. ");
INSERT INTO gdr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Sɨ man goro kɨd kesa tawɨm nangga yɨtkak gatab e re Kon wumɨr momnyɨn. Ajɨ wɨn b'ogla b'usaya tukenjindam. ");
INSERT INTO gdr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ɨ rɨb re tina singi rɨrɨr nate yikeny. Sɨ ra man tina dudlam tutkunjɨt, ajɨ man ma wumɨr et rɨngkae ta ik dɨde rɨtama ta yik. Komkesa Yɨnayɨna Wɨngawɨnga ke ukuki rɨga re toda kwa odede yɨpa wɨp imemb.” ");
INSERT INTO gdr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Seg Nikodemo ket yerkitonj da, “Sɨ rɨdede e onggɨtyam mɨle rɨrɨrkɨp tainy?” ");
INSERT INTO gdr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Sɨ Yesu ket tin mɨra yomnonj da, “Man re Israel rɨga wa ouyaena rɨga et. Sɨ man nangga pae maka wumɨr mɨbnyɨt onggɨtyam wɨngawɨnga gatab? ");
INSERT INTO gdr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kon ɨmɨnjogjog men motɨnyɨn. Sɨn ɨnsim apurenindam nangga im re sɨn wumɨr wekenyɨn. Ɨ sɨn ɨnsim yɨr ungata yɨt apurenindam nangga im re sɨn yɨr ongong eyenindam. Ajɨ wɨn makaima sowaina yɨr ungata yɨt emjatenindam. ");
INSERT INTO gdr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kon gowukoi gasa kaim wen wumɨr amneninyɨn, ajɨ wɨn makaima yɨtkak gar ke utkunda ke akasindam. Sɨ rada Kon pumb tungg gasa kaim yɨtnono tamneninyɨn, rɨdede im wɨn onggɨtyam yɨtkak gar ke utkunda ke takatenindam? ");
INSERT INTO gdr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ɨ makwa ke ngai yɨpa rɨga pumb tungg wa yikonj, ajɨ ɨnta yɨpaina, Rɨgamna B'ɨga yet re pumb tungg ke ikonj. ");
INSERT INTO gdr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ɨ rɨgap b'ogla Rɨgamna B'ɨgand urowasi wulkak kumb wa odede rɨja na re Mose demb de wul kesa tunggɨnd yɨpa gɨrem yurowatonj gɨrem ongi rɨga yilo okatam ra ton ɨtemb gɨrem yɨr ongi. ");
INSERT INTO gdr_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Nokɨm da ɨdenat komkesa rɨgap yepiya ra gar ke utkunda oramisi Ti pɨlɨnd, ton b'ogla yakate dadal ngɨrpu kesa yɨrkokar. ");
INSERT INTO gdr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“God ma sobijog na gowukoi rɨga singi eyeninonj, sɨ onggɨt penaemb Ton Tina lesmɨta B'ɨga akainonj. Nokɨm da ɨdenat komkesa rɨga yepiya ra Ti pɨlɨnd gar ke utkunda oramisi, ton ma opima negɨr taukanj ajɨ ton ɨta okasi dadal ngɨrpu kesa yɨrkokar. ");
INSERT INTO gdr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ɨ God Tina B'ɨga gowukoi rɨga wa pɨlwa yɨtmɨkitonj re ma gowukoi rɨga negɨr ma b'ɨsagɨka mana, ajɨ onggɨt mana da gowukoi rɨgap yɨrkokar okasi Tina wɨko ke. ");
INSERT INTO gdr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Sɨ yete re Ti pɨlɨnd gar ke utkunda yoramis, ton ma ɨta ket negɨr ma b'ɨsagɨka okas. Ajɨ yete re maka gar ke utkunda yoramis, ton re kea negɨr ma b'ɨsagɨka okati e yɨbɨm. Mop nokɨp ti awɨr e gar ke utkunda oramiti yɨbnau Godɨmna lesmɨta B'ɨga, Tina nyɨwɨm pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Sɨ ɨtemb re negɨr ma b'ɨsagɨka e. Sɨ ngaya re kea ikonj onggɨt gowukoi wa. Ajɨ rɨgap sɨbɨb e singi yiyenyi, ajɨ ton ma ɨta onggɨtyam ngaya singi yiyenyi nokɨp towaina mɨle re negɨrjog im wekeny. ");
INSERT INTO gdr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Komkesa rɨga yepim re negɨrjog mɨle amnɨkenenanj, ton onggɨt ngayam re bond im aukenenanj. Sɨ ton ma opima onggɨt ngayam pɨlwa tuweny nokɨp ra ton ngaya wa tuweny, ton moga im da towaina negɨr mɨle ke pɨta wa raukinem. ");
INSERT INTO gdr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ajɨ yepim re ɨmɨnjog mɨle amnɨkenenanj, ton opima onggɨt ngayam pɨlwa tuweny, nokɨm da ɨdenat ton towaina omnɨki mɨle tapekanj da onggɨtyam towaina mɨle re God ma singind omnɨki im.” ");
INSERT INTO gdr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Onggɨt kak ke Yesu dɨde Tina b'auyaena rɨga wuwonj Yuda eriya wa. Ɨ Ton ademb de yɨpand gɨlgɨl wekenonj, ɨ Ton ket rɨga baptiso amnɨkinonj. ");
INSERT INTO gdr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ɨ Ainon tungg re Salim tungg wus nat yɨbnonj, ɨ demb de ma yɨpa kɨma nyɨ wɨmenapu na wekenonj. Sɨ onggɨt penaemb Yoan toda kwa rɨga baptiso amnɨkinonj onggɨt tunggɨnd. Sɨ rɨga re kea wuwenonj, dɨde ket baptiso yokateno. ");
INSERT INTO gdr_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mop nokɨp onggɨt wɨnɨnd rɨgap Yoanɨnd maka sɨbɨbmet wa yoramito. ");
INSERT INTO gdr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nɨnda Yoanɨmna b'auyaena rɨga yɨpa Ju rɨga kɨma yɨt b'ɨpatento Ju rɨga waina ɨseka mɨle gatab. ");
INSERT INTO gdr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ɨ ton ket Yoanɨm pɨlwa tuwonj, ɨ Yoanɨnd yomno da, “Ouyaena Rɨga-wɨi! Yɨr de, ɨtemb re rɨga yet re man kɨma yɨbnonj Yordan kɨlɨm yɨpa tab wa, ɨ re man Ti gatab yɨr ungata yɨt pɨta amneninot, Ton rɨga im baptiso amnɨkiny. Sɨ jogjog rɨga im Ti pɨlwa wuweny.” ");
INSERT INTO gdr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Sɨ Yoan mɨra amninonj da, “Makwa yɨpa rɨga rɨrɨr e okas nanggamog gasa, ajɨ b'ogla rada God ti okau. ");
INSERT INTO gdr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Sɨ wɨn b'ogla walenggyam kor gatab yɨr ungata yɨt tapurenindam rɨna re kon nindond da, ‘Kon ma Kerisoten ajɨ Godɨt ken naska nɨtmɨkitonj, ɨ ɨngkenaemb ket Ton ikonj.’ ");
INSERT INTO gdr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ra yɨpa molkongga awowɨm mɨle tawɨk, ɨtemb jɨ sisɨl kongga kɨma rɨga e yet ra kongga okas. Ɨ sisɨl kongga kɨma rɨgamna masar re ti wus nate onyiti ɨbɨm tin yɨm okawam. Ɨ ra masar tutkunj onggɨtyam sisɨl kongga kɨma rɨgamna yɨtkak da, ‘Sɨn kea b'ogɨl molkongga i aya,’ ton ma sobijog gar sam e tainy. Sɨ koda yɨpa wɨp emb onggɨtyam gar sam ke yɨndangɨr auki nɨbnyɨn. ");
INSERT INTO gdr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Sɨ ɨtemb re rɨga Keriso b'ogla ukoijog rɨga rain, ajɨ kon b'ogla goujog rɨga rawɨn.” ");
INSERT INTO gdr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ɨ yet ra wub kumb ke ik, ton re ukoijog rɨga e, ajɨ komkesa gasa ra ti wɨra nasim tekeny. Ɨ yet ra gowukoi ke ik, ton re yɨpa gowukoi rɨga e. Sɨ ton gowukoi gasa gatab im tapureniny. Sɨ Keriso yet re pumb tungg ke ikonj, Ton re ukoijog rɨga e ajɨ komkesa gasa re Ti wɨra nasim wekeny. ");
INSERT INTO gdr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ton ɨnsim yɨr ungata yɨt apureniny rɨna re Ton yɨr anginonj dɨde utkundenonj. Ajɨ makwa yɨpa rɨgat onggɨtyam Tina yɨr ungata yɨt emjasiny. ");
INSERT INTO gdr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ɨ rɨga yete re onggɨtyam Tina yɨr ungata yɨt emjasiny, sɨ tontemb tina garɨnd tɨrɨr yomɨny da God re ɨmɨnjog e. ");
INSERT INTO gdr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mop nokɨp ɨtemb Rɨga, Keriso yena re God yɨtmɨkitonj, Ton Godɨmna opureni yɨtkak im apureneniny, nokɨp God Ti Yɨnayɨna Wɨngawɨnga kupkakupka e yokaeneny. ");
INSERT INTO gdr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ɨ Abu God onggɨt Ti B'ɨgand singi e yiyeny, sɨ Ton kea komkesa gasa Ti yɨmɨnd aramisinonj. ");
INSERT INTO gdr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Sɨ yet ra onggɨt B'ɨgam pɨlɨnd gar ke utkunda oramis, ton re dadal ngɨrpu kesa yɨrkokar kɨma e. Ajɨ yet ra maka onggɨt B'ɨgam pɨlɨnd gar ke utkunda oramis, ton ma ɨta yɨrkokar okas. Ajɨ ton God ma ukoi soro kɨma b'ɨsagɨka wɨra nate yɨbneneny. ");
INSERT INTO gdr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ɨ Parisai rɨgap kea utkundo odede da Yesu jogjog rɨga im Tina b'auyaena rɨgam amnɨkiny dɨde jogjog rɨga im baptiso amnɨkiny, ajɨ Yoan re ma jog im. Sɨ Yesu kea wumɨr yokatonj onggɨtyam Parisai rɨgaina utkundeni yɨtkak gatab. ");
INSERT INTO gdr_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ɨmɨnjog e da Yesu maka Tilenggyam yena baptiso amnɨkinonj ajɨ Tina b'auyaena rɨgapiya. ");
INSERT INTO gdr_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Sɨ Yesu Yuda eriya ke yiwatonj, ɨ ket b'usaya Galili eriya wa ɨtendonj. ");
INSERT INTO gdr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ɨ re Yesu Galili eriya wa ɨtendam awonj, Ton kea God ma singind yɨsamkonj da Ton Samariya eriya nata e yik. ");
INSERT INTO gdr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Sɨ onggɨt penaemb Yesu yikonj de yɨpa taun wa Samariya eriya wɨngɨrɨnd, ogenaya da Sikar. Ɨ Sikar taun re wus nat yɨbnonj onggɨtyam goukɨpol ke rɨna re Yakob yokawonj ti b'ɨga Yosepɨm. ");
INSERT INTO gdr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ɨ demb de kea Yakobɨmna euki nyɨkip yɨbnonj. Ɨ Yesu nya pɨnpɨn ɨmaeni map jɨ yarɨm awonj. Sɨ re Ton onggɨt nyɨkip wusɨnd ɨsamlitonj, kea ket lomtɨk awonj. ");
INSERT INTO gdr_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ɨ onggɨt wɨnɨnd ket yɨpa Samariya tunggam kongga tikonj nyɨ iskam. Sɨ Yesu ket tin womnonj da, “Be ngai onayam nyɨ nokae!” ");
INSERT INTO gdr_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Mop nokɨp onggɨt wɨnɨnd Yesumna b'auyaena rɨga re kea Yesund yɨraro dɨde onggɨt taun wa wuwonj owou imdam. ");
INSERT INTO gdr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ɨ onggɨt wɨnɨnd Ju rɨga maka Samariya tunggam rɨga kɨma b'inkɨndenento. Sɨ onggɨt penaemb ɨtomb Samariya tunggam kongga Yesund yomnonj da, “Man re Ju rɨga et, ɨ kon re Samariya tunggam kongga en. Sɨ rɨdede ma pae Man ken nɨgekisɨt onaya nyɨwɨm?” ");
INSERT INTO gdr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ɨ Yesu tin mɨra womnonj da, “Ra man wumɨr okasɨt nangga e God ma yiyag wurar, dɨde ra Ken notɨngwasɨt yete re Kon merkisɨn da ‘Onaya nyɨ nokae,’ manɨt rako Ken nerkisɨt ɨ Kon keako mor mokaen yɨrkokar nyɨ.” ");
INSERT INTO gdr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ɨ onggɨt konggat Yesund yomnonj da, “Sɨ Mor awɨr e daka nyɨkak nyɨ iskam, ɨ nyɨ re ma sobijog ngortod wa e yɨbɨm onggɨt nyɨkipɨnd. Sɨ onggɨt paemb, rɨngkae Man okasɨt onggɨtyam yɨrkokar nyɨ? ");
INSERT INTO gdr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mera b'u Yakobɨt onggɨtyam nyɨkip yeukonj, ɨ tonjog, ɨ tina b'ɨgawar ɨ dɨde tina ongeni b'angga onggɨt nyɨkip kena nyɨ yonaikeneno. Ɨ ton ket ɨtemb nyɨkip sowa nokainonj. Sɨ rɨka Man pumbjog rɨga et ajɨ Yakob re goujog rɨga e?” ");
INSERT INTO gdr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu ket mɨra womnonj da, “Komkesa yepiya ra onggɨtyam nyɨ onaikenenyi, ton opima b'usaya nyɨpa taukenenanj. ");
INSERT INTO gdr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ajɨ yet ra onggɨtyam nyɨ onai rɨnte ra Kon okaen, ton makwa ɨta ngai nyɨpa taukeneny. Ajɨ onggɨtyam nyɨ rɨna ra Kon okaen, ti pɨlɨnd yɨpa kipnyɨ pɨla e tawɨk. Sɨ onggɨtyam nyɨ tobrureneny ra dadal ngɨrpu kesa yɨrkokar okawa ma.” ");
INSERT INTO gdr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ɨ onggɨt konggat Yesund yomnonj da, “Sɨ be Man kor nokae onggɨtyam nyɨ, nokɨm da ɨdenat kon maka nyɨpa taukenenyɨn, dɨde ɨdenat kon maka dɨkɨnd nyɨ iskam netkenenyɨn.” ");
INSERT INTO gdr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Sɨ Yesu tin womnonj da, “Meke, ɨ moleowɨnd ara emoket, ɨ dɨde ket tɨtenjɨt dor dɨkɨnd!” ");
INSERT INTO gdr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ɨ ket onggɨt konggat yɨsmonggawonj da, “Kor awɨr e leo.” Seg Yesu tin womnonj da, “Sɨ ɨmɨnjog na man minjɨt da kor awɨr e leo. ");
INSERT INTO gdr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nokɨp mor paib (5) leo na mɨbnainonj. Ɨ kwa rɨnte re ket rɨga man kɨma yɨbɨm re ma mor leojog e. Sɨ onggɨtyam moina opureni yɨt re ɨmɨnjog e.” ");
INSERT INTO gdr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ɨ onggɨt konggat ket windonj da, “Ukoyam! Kon ket yɨr mongen re da Man yɨpa bageyam et. ");
INSERT INTO gdr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Sɨn re Samariya tunggam rɨga im, ɨ sowa b'uwarɨp onggɨt Gerisim dor natemb Godɨnd yewangaeneno. Ajɨ wɨn Ju rɨgap endenindam da ɨnta yɨpaina pɨpmet Yerusalem taunɨnd Godɨnd ewangayam.” ");
INSERT INTO gdr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Seg Yesu ket onggɨt konggand womnonj da, “Kongga! Gar ke utkunda ke nokate! Ɨta jɨ wɨn ik. Ra onggɨt wɨnɨnd wɨn ma ɨta B'und ewangaenenya onggɨt Gerisim dorɨnd o de Yerusalem taunɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ɨ wɨn yewangaenenya nangga im re wɨn ma wumɨr im. Ajɨ sɨn yewangaenenyu nangga e re sɨn wumɨr, nokɨp yɨrkokar okawa mɨle ik re Ju rɨga wa pɨlkae. ");
INSERT INTO gdr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ajɨ wɨn ɨta ik. Sɨ ɨtemb jɨ yu wɨn rɨdenasim ra ɨmɨnjog ewangaya rɨgap B'und ewangaenenyi wɨngawɨnga ke dɨde ɨmɨnjog yɨtkak ke. Mop nokɨp B'u odede Tinɨm ewangaya rɨga im oraka eyeniny. ");
INSERT INTO gdr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ɨ God re Wɨngawɨnga e. Sɨ Tinɨm ewangaya rɨgap b'ogla ewangaya yeyene wɨngawɨnga ke dɨde ɨmɨnjog yɨtkak ke.” ");
INSERT INTO gdr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Sɨ todaka ket onggɨt konggat Yesund yomnonj da, “Kon wumɨr en da Mesiya, ogenaya da Keriso, ɨta ik. Ɨ ra Ton ik, Ton ɨta komkesa gasa gatab mera tesɨpkeniny.” ");
INSERT INTO gdr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Sɨ Yesu ket ti pɨta womnawonj da, “Kon ɨntemb jɨ Rɨga yet re man kɨma yɨtnono aenyɨn.” ");
INSERT INTO gdr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ɨ onggɨt wɨnɨnd re Yesu onggɨt Samariya tunggam kongga kɨma yɨtnono aenonj, Tina b'auyaena rɨga ɨtekto, ɨ ket kɨd kesa na auto, nokɨp Yesu kea onggɨtyam kongga kɨma yɨtnono aenonj. Ajɨ makwa ngai yɨpa rɨgat yerkitonj da, “Nangga e Man yomnɨket?” o da, “Nangga pae Man ton kɨma yɨtnono aenyɨt?” ");
INSERT INTO gdr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Seg ket onggɨt konggat omanda tina nyɨkak yɨraronj, dɨde ket ɨtendonj taun wa. Ɨ ton kea ket rɨga wumɨr amninonj da, ");
INSERT INTO gdr_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Tuyɨm, ɨ onggɨt Rɨgand yɨr ongongɨm yopa yete re ken wumɨr nomneny komkesa gasa gatab rɨna re kon amnɨkeneninond. Ma rɨka ɨtemb re Rɨga, Kerisote?” ");
INSERT INTO gdr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Sɨ rɨgap taun ke yiwato, ɨ ket Yesum pɨlwa tuwonj. ");
INSERT INTO gdr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ɨ onggɨt ganggand re rɨga maka opekto, Tina b'auyaena rɨgap Tin ɨl yongko da, “Ouyaena Rɨga-wɨi! Be ngai diyam ae!” ");
INSERT INTO gdr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ajɨ Yesu ten amninonj da, “Kor ɨta owou owowɨm rɨnsim re wɨn ma wumɨr im.” ");
INSERT INTO gdr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Sɨ ket Tina b'auyaena rɨgap towalenggyam b'ɨgekena wuwenonj da, “Ke yet owou Ti itiyau owowɨm?” ");
INSERT INTO gdr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ɨ Yesu ket ten amninonj da, “God Ken nɨtmɨkitonj Tina singi wɨko omnɨkam dɨde undwatam. Sɨ ɨntemb jɨ Kornɨm owou. ");
INSERT INTO gdr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ma wɨn endenindam da powa (4) mobi im komb ɨ ɨngkaemb ket erngokam wɨn ik dem? Ajɨ Kon wen tamninyɨn. Wɨn yɨr epangkinam dɨde ket yɨr ke ɨnjomkena teyenindam sopapu. Sɨ kɨp re kea ungijog im erngokam. ");
INSERT INTO gdr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ɨ yete re kɨp erngoka eyeniny, ton re kea tina mɨra okati e yɨbɨm, sɨ ton kɨp bobo omnɨka eyeniny de dadal ngɨrpu kesa yɨrkokar wa. Nokɨm da ɨdenat tuny ɨgmarka rɨga dɨde kɨp erngoka rɨga yɨpand gɨlgɨl sam okasya. ");
INSERT INTO gdr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ɨ rɨgap yɨpa yɨtkak opurena yiyenyi da, ‘Yɨpa rɨgat tuny ɨgmarka eyeniny ajɨ b'enga rɨgat kɨp erngoka teyeniny.’ Sɨ onggɨtyam yɨtkakɨt kea ɨmɨnjog e yɨmjas onggɨtyam mɨle gatab. ");
INSERT INTO gdr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ɨ Kon wen tetmɨkisinyɨn ra kɨp erngoka mim rɨna re wɨn maka bebɨg kɨma yɨr ɨpka eyentondam. Sɨ nɨnda rɨgapiya bebɨg kɨma yɨr epkɨto, ajɨ wɨn kɨp erngoka teyenindam ra towaina bebɨg kɨma b'asowa wɨko omnɨki sopapu kaim.” ");
INSERT INTO gdr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ɨ re onggɨt konggat Yesum gatab yɨr ungata yɨt b'usekonj da, “Ton kea wumɨr nomneny komkesa mɨle rɨna re kon amnɨkeneninond,” onggɨt taun ke rɨgap kea tina yɨt utkundeno. Sɨ onggɨtyam tina yɨt ke ma yɨpa kɨma Samariya tunggam rɨgapiya Yesund gar ke utkunda ke yokato. ");
INSERT INTO gdr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Sɨ onggɨt penaemb ket ton Samariya tunggam rɨgap Yesum pɨlwa tuwonj, ɨ ket Yesund yerkito ton kɨma towaina taunɨnd wɨmenam. Sɨ Yesu adea ket ton kɨma yɨbnonj nɨmog bibɨr kɨma. ");
INSERT INTO gdr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ɨ Yesu towa yɨtkak pɨtapɨta amnenainonj, sɨ onggɨtyam Tina yɨtkak kenaemb kwa b'usaya jogjog rɨga gar ke utkunda rɨga aukɨto. ");
INSERT INTO gdr_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Sɨ ket rɨgap onggɨt konggand womno da, “Sɨn kea ket sowalenggyam Yesu ma yɨtkak utkundenindam dɨde sɨn ket wumɨr aindam da ɨtemb rɨga re ɨmɨnjog gowukoi rɨga wa yɨrkokar okawa rɨga e. Sɨ onggɨt paemb sɨn ma ɨta ket Yesund gar ke utkunda ke okasu moina opureni yɨtkak ke.” ");
INSERT INTO gdr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ɨ nɨmog bibɨr kak ke Yesu Sikar taun ke yiwatonj de Galili eriya wa. ");
INSERT INTO gdr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu Tilenggyam yɨr ungata yɨt yindonj da, “Makwa ɨta yɨpa bageyamɨt rɨga wa pɨlke b'ɨsnawa yokateny tinajog tunggɨnd.” ");
INSERT INTO gdr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ɨ re Galili tunggam rɨga Yerusalem taun wa wuwenonj Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam okatam, ton ademb de komkesa mɨle yɨr angto rɨna re Yesu amnɨkinonj onggɨtyam diyamdiyam wɨnɨnd. Sɨ onggɨt penaemb re Yesu Galili eriya wa opendonj, Galili tunggam rɨgap Tin simesime yomno. ");
INSERT INTO gdr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ɨ ket Yesu b'usaya Galili eriya wɨngɨrɨnd Kana tungg wa yikonj rɨkɨnd re Ton nyɨ ke ɨk yomnɨkonj. Ɨ onggɨt wɨnɨnd yɨpa kingɨmna ukoi wɨko rɨga yɨbnonj Kaparnaum taunɨnd, ɨ tina b'ɨga re kopa na yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Sɨ onggɨt rɨga ma b'ɨga re momta uj okata nat yɨbnonj. Sɨ onggɨt penaemb re ton ket utkundonj da Yesu ke Yuda eriya ke ikonj de Galili eriya wa, ton kea ket Yesum pɨlwa yikonj. Ɨ ton ket yɨgekitonj menonɨm tina met wa dɨde tina b'ɨga ɨsakendam. ");
INSERT INTO gdr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu tin yomnonj da, “Ra maka ra wɨn yɨr ongya Koina kɨd kesa kɨma danda wɨko dɨde moga kɨma danda wɨko, sɨ wɨn ma opima gar ke utkunda ke notkasya.” ");
INSERT INTO gdr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ɨ onggɨt kingɨmna ukoi wɨko rɨgat Yesund ɨl yongkonj da, “Yonggyam! Koina b'ɨga momta e uj okas. Sɨ wanaka nikya!” ");
INSERT INTO gdr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Sɨ Yesu tin yomnonj da, “B'ogɨl e, man meke! Moina b'ɨga ke yilo yokas.” Seg onggɨt rɨgat ket Yesu ma yɨt gar ke utkunda ke yokatonj rɨna re tin yomnonj. Seg ɨngkenaemb ket ton yiwatonj. ");
INSERT INTO gdr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ɨ re ton menon yokatonj tungg wa, nyawɨnd nɨnda tina wɨko rɨgap tin wɨpwɨp yomno bage yɨt kɨma. Sɨ ton ket tin wumɨr yomno da, “Mor b'ɨga ke yilo yokasɨm.” ");
INSERT INTO gdr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Seg onggɨt ukoi wɨko rɨgat wɨn gatab ten arkisinonj da, “Rɨdenat kor b'ɨga b'ogɨl awɨm?” Sɨ ton ket tin wumɨr yomno da, “Sɨm nat juwarɨt tin yɨrarɨm sɨmana wan (1) kɨlok gatab.” ");
INSERT INTO gdr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Sɨ ti b'u kea ket wumɨr yokatonj da, “Onggɨtyam yɨpaina wɨn natemb Yesu ken yɨt nomnenyɨm da mor b'ɨga ke yilo yokas.” Seg ket ton dɨde komkesa rɨga Yesund gar ke utkunda ke yokato yepiya re tina metɨnd wekenonj. ");
INSERT INTO gdr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ɨ re Yesu Yuda eriya ke ikonj de Galili eriya wa, Ton nɨmogɨm onggɨtyam kɨd kesa kɨma danda wɨko na yomnɨkonj. ");
INSERT INTO gdr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ɨ onggɨt kak ke re ket Ju rɨga waina diyamdiyam wɨn awonj, Yesu Yerusalem taun wa yikonj. ");
INSERT INTO gdr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ɨ yɨpa jambea pɨla kip, Ibru yɨt ke ogenaya da Betsaida, yɨbnonj Yerusalem taun wɨngɨrɨnd de Mamoi B'ɨgarenapu Mora wusɨnd, ɨ demb de paib (5) dɨr kesa met wekenonj. ");
INSERT INTO gdr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ɨ onggɨtyam dɨr kesa met wɨngɨr nat b'engabenga kopa kɨma rɨga bobo wekenonj pasɨnd opi re yɨrdɨdɨ rɨga, gomgom rɨga dɨde dɨmɨr kopa kɨma rɨga. Ɨ ton onggɨt kipɨnd nyɨ ulugaya wɨn na yɨr yungaeneno. ");
INSERT INTO gdr_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Mop nokɨp yɨpa aneru kea wɨn ke yikenenonj onggɨt kip wa, ɨ ket ton nyɨ yulugaenenonj. Sɨ nyɨ ulugaya kak ke yet ra naskajog nyɨ wa tɨsongg, ton ɨta tina kopa ke b'ɨtɨsakenj nanggamog kopa e re ti yɨbnau. ");
INSERT INTO gdr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ɨ ademb de yɨpa rɨga yɨbnonj yet re teti eit (38) kemag wɨngɨrɨnd kopand yɨbnenenonj. ");
INSERT INTO gdr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ɨ re Yesu onggɨt rɨgand yɨr yongonj pasɨnd, Ton kea wumɨr awonj da ton re ma yɨpa kɨma kemag na kopand yɨbnenenonj. Sɨ Ton ket tin yomnonj da, “Ma man singi et b'ɨsakendam?” ");
INSERT INTO gdr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ɨ onggɨt kopa rɨgat Yesund mɨra yomnonj da, “Ukoyam! Kor awɨr e yete yɨm b'akawa rɨga nyɨ wa ken ɨsonggam nyɨ ulugaya wɨnɨnd. Sɨ kon ra ɨl b'angka netkenyɨn nyɨ wa menonɨm, yɨpa rɨgat ɨta nɨtɨsalngis de nyɨ wa menonɨm.” ");
INSERT INTO gdr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ɨ Yesu ket tin yomnonj da, “Onyite, ɨ ket moina dar yotokende dɨde ket menon yokate!” ");
INSERT INTO gdr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Seg odenja ket onggɨt rɨgat ket kopa ke b'ɨsakendonj. Ɨ ton ket tina dar yotokendonj dɨde ket menon yokatonj. Ɨ onggɨtyam bibɨr re Ju rɨga waina wɨram dɨde yɨr opmitena bibɨr na. ");
INSERT INTO gdr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Sɨ onggɨt penaemb Ju rɨgap onggɨt kopa ke b'ɨsakendi rɨgand yomno da, “Yu re meraina wɨram dɨde yɨr opmitena bibɨr e. Sɨ ɨtemb re ma b'ogɨl omnɨka e ainy rɨnte re man moina dar yiyɨt.” ");
INSERT INTO gdr_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ajɨ ton ten mɨra amninonj da, “Onggɨt rɨgat yete re ken nɨsakenj, Tonɨt nomɨny da, ‘Moina dar yotokende dɨde menon yokate!’” ");
INSERT INTO gdr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Sɨ ton ket tin yerkito da, “Yetemb jɨ rɨga yete re men momɨny da, ‘Dar yotokende dɨde menon yokate!’” ");
INSERT INTO gdr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ajɨ onggɨt kopa ke b'ɨsakendi rɨgat maka wumɨr awonj yete Ton jɨ rɨga. Mop nokɨp Yesu kea onggɨt pɨpmet ke ɨimonj Ju rɨga bobo map. ");
INSERT INTO gdr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ɨ onggɨt kak ke ket Yesu tin yodaronj yɨnametɨnd, ɨ Ton ket tin yomnonj da, “Man kea kopa ke b'ɨsakendi et. Sɨ goro kwa ngai negɨr mɨle tamnɨkinɨm, nokɨm da ɨdenat ket makwa nangga negɨrjog mɨle tawɨk mor pɨlɨnd.” ");
INSERT INTO gdr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ɨ re onggɨtyam rɨgat yiwatonj Ju rɨga wa pɨlwa, ton kea ket ten wumɨr amninonj da, “Ɨtemb re rɨga Yesute yet re ken nɨsakenjɨm.” ");
INSERT INTO gdr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sɨ onggɨt penaemb Ju rɨgap Yesum pɨlɨnd negɨr kɨma b'ɨdgotnena mɨle yomnɨko, nokɨp Yesu onggɨtyam mɨle yomnɨkonj re Ju rɨga waina wɨram dɨde yɨr opmitena bibɨr nat. ");
INSERT INTO gdr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Sɨ Yesu ket ten mɨra amninonj da, “Kor B'u wɨko omnɨka nata yɨbnɨkeneny ngɨrpu yu, sɨ Koda kwa wɨko nata nɨbnenenyɨn.” ");
INSERT INTO gdr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sɨ Yesu ma ɨna Ju rɨga waina wɨram dɨde yɨr opmitena bibɨr owama gatab mɨle nena na yerbekonj, ajɨ daka kwa Ton Godɨnd Ti B'ujogɨm yogenayonj. Sɨ odede opurena kenaemb Tilenggyam God kɨma yɨpa rɨrɨrkɨp tondon b'akatenonj. Sɨ onggɨt mop penaemb Ju rɨgap ma sobijog gar soro kɨma na nya oraka eyento Tin ongandam. ");
INSERT INTO gdr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Sɨ onggɨt penaemb Yesu ten mɨra amninonj da, “Kon ɨmɨnjogjog wen tamninyɨn. B'uɨt nangga mɨle im re amnɨkiny, toda kwa Ti B'ɨga ɨnsima mɨle tamnɨkiny. Sɨ onggɨt paemb rada B'ɨgat maka ra yɨr tanginy nanggamog mɨle rɨnsim re Ti B'u omnɨka eyeniny, B'ɨgat ma rɨrɨr e Tilenggyam nanggamog mɨle omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mop nokɨp B'uɨt ɨta Ti B'ɨgand singi yiyeny, sɨ Ton Ti B'ɨgand komkesa mɨle youyaukuriny nangga im re Ton amnɨkeniny. Ɨ ma onggɨtyam nena im youyaukuriny, ajɨ Ton kwa Ti B'ɨgam ukoijog mɨle im ouyaukuriny. Nokɨm da ɨdenat wɨn kɨd kesa tainindam. ");
INSERT INTO gdr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mop nokɨp ɨja emb jɨ B'uɨt uj rɨga utnɨkeneniny dɨde yɨrkokar agoneneniny. Ɨ odede yɨpa wɨp kaim daka B'ɨgat rɨga wa yɨrkokar tagoneneniny yena ra Ton singi tamneniny okawam. ");
INSERT INTO gdr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ɨ ɨja emb jɨ kwa B'u makwa yena ɨsagɨkam yomneny, ajɨ Ton komkesa ɨsagɨka mɨle yoramitonj Ti B'ɨgam pɨlnate. ");
INSERT INTO gdr_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nokɨm da ɨdenat komkesa rɨgap onggɨt B'ɨgand ɨsnaenenyi odede wɨp rɨja im re ton Ti B'und yɨsnaenenyi. Yete re maka B'ɨgand yɨsnaeny, ton kwa ma ɨta yɨsnaeny Ti B'und yet re Tin yɨtmɨkitonj. ");
INSERT INTO gdr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ɨ Kon kwa ɨmɨnjogjog wen tamninyɨn. Yet ra Koina yɨtkak tutkunj ɨ ra gar ke utkunda oramis Ti pɨlɨnd yet re Ken nɨtmɨkitonj, ton kea yokas dadal ngɨrpu kesa yɨrkokar. Ɨ ton ma ɨta negɨr ma b'ɨsagɨka okas dem, ajɨ ton kea uj ke opantonj yɨrkokar wa. ");
INSERT INTO gdr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ɨ kwa Kon ɨmɨnjogjog wen tamninyɨn. Ɨta yɨpa wɨn ik rɨdenat ra uj rɨgap Godɨmna B'ɨga ma nonykok utkundenyi, ɨ utkunda rɨga yilo im taukanj. Sɨ ɨtemb jɨ yu wɨn. ");
INSERT INTO gdr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mop nokɨp B'u Ti pɨlnata yɨrkokar yowam, ɨ ket onggɨtyam yɨrkokar Ti B'ɨgam yokawonj Ti pɨlɨnd owamam odede rɨja e re Ti B'u yowam. ");
INSERT INTO gdr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ɨ B'u kea Ti B'ɨgam yokawonj b'ɨsagɨka mɨle omnɨkam, mop nokɨp Ton re Rɨgamna B'ɨga e. ");
INSERT INTO gdr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Sɨ wɨn goro kɨd kesa taindam onggɨtyam gatab, mop nokɨp yɨpa wɨn ɨta ik dem, ra onggɨt wɨnɨnd gopmetɨnd rɨgap tutkundenyi dem Tina nonykok. ");
INSERT INTO gdr_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ɨ yepiya re b'ogɨl mɨle amnɨkento, ton topekanj dem ra utnyita mim yɨrkokar wa, ajɨ yepiya re negɨrjog mɨle amnɨkento, ton topekanj ra dem utnyita mim de negɨr ma b'ɨsagɨka okatam. ");
INSERT INTO gdr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ɨ Kon makwa rɨrɨr en Kolenggyam nanggamog mɨle omnɨkam. Sɨ Kon b'ɨsagɨka mɨle amnɨkeninyɨn ɨja ima rɨngma re Kon utkundenenyɨn Godɨm pɨlke. Sɨ Koina b'ɨsagɨka mɨle re negɨr kesa dɨmdɨmjog e, mop nokɨp Kon ma Koina singi mɨle e oraka yiyenyɨn ajɨ Tina singi mɨle e yet re Ken nɨtmɨkitonj. ");
INSERT INTO gdr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ɨ ra Konjogɨt yɨr ungata yɨt tapureninyɨn Kor gatab, onggɨtyam Koina yɨr ungata yɨt re ma ɨmɨnjog e. ");
INSERT INTO gdr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Sɨ ɨta yɨpa b'enga rɨga yete re Kor gatabɨm yɨr ungata yɨt apureneniny. Ɨ Kon wumɨr en da onggɨtyam tina Kor gatab yɨr ungata yɨt re ɨmɨnjog e. ");
INSERT INTO gdr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ɨ wɨn rɨga etmɨkurtondam Yoanɨm pɨlwa. Sɨ Yoan ket yɨr ungata yɨt yindenonj ɨmɨnjog yɨtkak gatab. ");
INSERT INTO gdr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Sɨ Kon maka yɨr ungata yɨt yokatenyɨn yɨpa rɨgam pɨlke. Ajɨ Kon onggɨtyam yɨt apureninyɨn re, nok mim da ɨdenat wɨn yɨrkokar okasya. ");
INSERT INTO gdr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ɨ ɨtemb re rɨga Yoan re yɨpa lampa na rɨna re yɨmbenenonj dɨde b'anyoratenonj. Sɨ wɨn singi autondam sobijog ganggand onggɨtyam tina ngaya pɨtand ukoi sam omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Sɨ Yoanɨmna yɨr ungata yɨt re ma ukoi e, ajɨ Kor ɨta yɨpa ukoijog yɨr ungata yɨt. Ɨ Kon ɨnsima wɨko amnɨkeninyɨn rɨna re Kor B'u nokainonj Kornɨm undwatam. Sɨ onggɨtyam Koina omnɨki wɨkopim Kor gatab yɨr ungata yɨt emjatenanj da Kor B'uɨt Ken nɨtmɨkitonj. ");
INSERT INTO gdr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ɨ kwa B'u yet re Ken nɨtmɨkitonj, Tonɨtemb Kor gatab yɨr ungata yɨt yindonj. Ajɨ wɨn makwa ngai Tina nonykok yutkundonda, ɨ kwa wɨn maka Tina jɨ yɨr yongonda. ");
INSERT INTO gdr_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ɨ waina garɨnd awɨr e kwa B'uɨmna yɨtkak yɨbɨm, mop nokɨp wɨn makaya Ti pɨlɨnd gar ke utkunda yoramisya yena re B'u yɨtmɨkitonj. ");
INSERT INTO gdr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ɨ kwa wɨn b'obogɨl im yɨna peba b'auyaena wuwenyɨt, mop nokɨp wɨn nony aindam da wɨn onggɨtyam peba kaim dadal ngɨrpu kesa yɨrkokar yokatenya. Sɨ onggɨtyam yɨna pebapim Kor gatab yɨr ungata yɨt apurenanj. ");
INSERT INTO gdr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ajɨ wɨn ma opima singi ainindam Kor pɨlwa menonɨm yɨrkokar okatam. ");
INSERT INTO gdr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ɨ Kon ma ɨta rɨga wa pɨlke esourena yokatenyɨn. ");
INSERT INTO gdr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ajɨ Kon wanɨm wumɨr ainyɨn da wa awɨr e kwa yɨbɨm Godɨm singi mɨle waina garɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ɨ Kon netkond re Kor B'u ma nyɨ kɨma na, ajɨ wɨn ma ɨta Ken nokatenya. Rada yɨpa rɨga tinajog nyɨ kɨma ik, sɨ wɨn ɨta onggɨt rɨgand okasya. ");
INSERT INTO gdr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Wɨn opima walenggyam walenggyam esourena akatenenindam, ajɨ wɨn ma ɨta oraka yiyenya onggɨt b'ogɨl ɨnyomarena rɨnte re yɨpaina nena God, Ti pɨlke ik. Sɨ wɨn rɨdede e Kor pɨlɨnd gar ke utkunda oramisya? ");
INSERT INTO gdr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ɨ wɨn goro nony taininam da Kon wen opima b'ɨsagɨkam taramisinyɨn Kor B'u ma kot wa. Sɨ wɨn opima Mosem pɨlɨnd singi ainindam warɨm b'ogɨl ɨsma okatam. Ajɨ ɨtemb Mose tontemb wen kot wa taramkiny dem b'ɨsagɨkam. ");
INSERT INTO gdr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ɨ ra wɨn Mosend gar ke utkunda ke okasya, wɨn kea Ken gar ke utkunda ke nokasya. Mop nokɨp ton gog yɨt peba erɨkinonj re Kor gatab na. ");
INSERT INTO gdr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Sɨ ra wɨn maka tina gog yɨt pebam pɨlɨnd gar ke utkunda oramisya, sɨ rɨdede im wɨn Koina opureni yɨtkakɨm pɨlɨnd gar ke utkunda oramisya?” ");
INSERT INTO gdr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ɨ onggɨt kak ke Yesu Galili sɨpa tab wa gɨga nya ɨjendonj. Ɨ Galili Sɨpam kwa yɨpa nyɨ re Tiberiya Sɨpa e. ");
INSERT INTO gdr_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Sɨ jogjog rɨga bobop kea Yesund yɨmta yundoko, mop nokɨp ton kea kɨd kesa kɨma danda wɨko yɨr angto rɨna re Ton kopa rɨga wa pɨlɨnd amnɨkinonj. ");
INSERT INTO gdr_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Seg ket Yesu yɨpa dor ɨjonj. Ɨ demb de ket Tina b'auyaena rɨga kɨma omnɨkto. ");
INSERT INTO gdr_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ɨ onggɨt wɨnɨnd Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam Wɨn re ma pɨn na ket awonj. ");
INSERT INTO gdr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ɨ re Yesu yɨr b'ɨskonj, Ton kea yɨr anginonj jogjog rɨga bobo menonɨnd Ti pɨlwa. Sɨ Yesu Pilipɨnd yerkitonj da, “Rokasim men owou temjindam onggɨt rɨga bobo ongenam?” ");
INSERT INTO gdr_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu Tilenggyam kea wumɨr awonj da ɨnte Ton omnɨk. Ajɨ Ton onggɨtyam yɨt yopulitonj re Pilipɨnd otonkita mana. ");
INSERT INTO gdr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ɨ Pilip ket Yesund mɨra yomnonj da, “Ra ita rɨgap yɨpa kɨpol yɨpa kɨpol imda teyenanj, wan tausɨn tu andred (1,200) Kina ke imdi owou re towanɨm ma rɨrɨr im taukanj.” ");
INSERT INTO gdr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ɨ Tina b'auyaena rɨga wɨngɨrɨnd yɨpa rɨga, Simon Petromna yɨnggan Andrea, todaka ket Tin yomnonj ");
INSERT INTO gdr_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","da, “Ɨta yɨpa b'ɨga dɨkɨnd. Sɨ ton paib (5) sana nganja dɨde nɨmog sobijog kabum kɨma e yɨbɨm. Ajɨ rɨdede im onggɨtyam owou ke odede jogjog rɨga bobo tangenindam?” ");
INSERT INTO gdr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ɨ ket Yesu yindonj da, “Wɨn rɨga wumɨr amninam omnɨkam!” Ɨ onggɨt pɨpmetɨnd re rɨnyarɨnya met na yɨbnonj. Sɨ re rɨga omnɨkto, rɨgajog nena agenkɨto re paib tausɨn (5,000) na, ajɨ maka kongga dɨde b'ɨga agenkɨto. ");
INSERT INTO gdr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Seg ket Yesu sana nganja akasinonj dɨde ket Godɨnd sɨteket yɨt yomnonj. Seg Ton ket rɨga wa agoninonj yepiya re omnɨki wekenonj. Ɨ Ton kwa ɨja na yɨpa wɨp nya ke kabum daka agoninonj towaina singi rɨrɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ɨ re rɨga ngor aukɨto, Yesu Tina b'auyaena rɨga amninonj da, “Owou komb bobo amnɨkinam. Ke owou b'asomneninem.” ");
INSERT INTO gdr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Seg ton kea owou komb yɨpand bobo amnɨkto rɨga wa pɨlke yepiya re onggɨtyam paib (5) sana nganja auto, sɨ ton re twelp (12) wat na yɨndangɨr amnɨkto. ");
INSERT INTO gdr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ɨ re rɨgap onggɨtyam kɨd kesa kɨma danda wɨko yɨr yongo rɨna re Yesu yomnɨkonj, ton kea endento da, “Ɨtemb re ɨmɨnjog onggɨtyam bageyamte yet ra ik onggɨt gowukoi wa.” ");
INSERT INTO gdr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Sɨ onggɨt penaemb rɨgap yɨsamko menonɨm Yesum pɨlwa dɨde Tin danda kɨma usunatam, nokɨm da ɨdenat Tin towa kingɨm omnyi. Ajɨ Yesu kea towaina ɨsamki mɨle wumɨr awonj, sɨ Ton towa pɨlke ɨtrɨngendonj, ɨ b'usaya Tinta yikonj de dor wa. ");
INSERT INTO gdr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ɨ re sɨ imokonj, Yesumna b'auyaena rɨgap wuwonj de sɨpa wa. ");
INSERT INTO gdr_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ɨ demb de yɨpa gɨga yɨbnonj. Sɨ ton ket gɨga wa angurkɨto dɨde ket wuwonj sɨpa yɨpa tab wa de Kaparnaum wa. Re ket sɨbɨb awonj, ajɨ Yesu maka wanaka ten adarinonj. ");
INSERT INTO gdr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ɨ onggɨt ganggand yɨpa ukoi depu rɨb ikonj dɨde ket rɨbɨt sɨpand wuro yowɨnkonj. ");
INSERT INTO gdr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ɨ ton karab ingaena eito re ama rɨka paib (5) o siks (6) kilomita pɨn na. Ɨ onggɨt wɨnɨnd Yesu ikonj sɨpa nyɨ tumɨnd dɨde ket onggɨt gɨga wus wa awonj. Sɨ re Tina b'auyaena rɨgap Tin yɨr yongo, ton kea moga aukɨto. ");
INSERT INTO gdr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Sɨ Yesu ten amninonj da, “Kon ten. Goro moga tainam!” ");
INSERT INTO gdr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ɨ ton sam kɨma Tin gɨga wa angitam simesime yomno. Seg odenja ket gɨga ibekitonj Kaparnaum sɨpa yuru wa rɨtade re ton menonɨm aukɨto. ");
INSERT INTO gdr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Re Yesumna b'auyaena rɨgap onggɨt pɨpmet ke yiwato, rɨga bobo kea naska nata yɨr angto da yɨpaina nena gɨga na de yɨbnonj ɨ Yesu maka onggɨt gɨgand angitonj Tina b'auyaena rɨga kɨma, ajɨ Tina b'auyaena rɨga nenapiya yiwato. Ɨ ɨspari ke ket ton opimemb rɨga bobo omanda wekenonj onggɨt pɨpmetɨnd rɨkɨnd re Yesu ten angeninonj sɨpa yɨpa tabɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ɨ onggɨt wɨnɨnd nɨnda gɨga tuwonj Tiberiya ke, ɨ ket ibekurto onggɨt pɨpmet wusɨnd rɨkɨnd re rɨgap onggɨtyam sana auto rɨna re Yonggyam sɨteket yɨt yomnonj Godɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Sɨ opimemb rɨga bobo yena re Yesu angeninonj, kea wumɨr aukɨto da Yesu dɨde Tina b'auyaena rɨga awɨr im de onggɨt pɨpmetɨnd. Sɨ ton ket gɨga wa angurkɨto rɨna re Tiberiya ke tuwonj, ɨ ket Kaparnaum wa wuwonj Yesund orakam. ");
INSERT INTO gdr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ɨ re ton Yesund yodaro yɨpa sɨpa tab wa, ton ket Tin yomno da, “Ouyaena Rɨga-wɨi! Rɨdenat Man metket dɨkɨnd?” ");
INSERT INTO gdr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Sɨ Yesu ten amninonj da, “Kon ɨmɨnjogjog wen tamninyɨn. Wɨn Ken oraka niyenya re ma onggɨt pae da wɨn kea yɨr yongma kɨd kesa kɨma danda wɨko ajɨ onggɨt pae da wɨn kea sana auromam dɨde ket ngor aukɨromam. ");
INSERT INTO gdr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Goro wɨn wɨko tamnɨkinam onggɨtyam owowɨm rɨnte ra tɨtkɨk ajɨ onggɨtyam owou mana rɨnte ra dadal ɨbneneny dɨde tawameneniny dadal ngɨrpu kesa yɨrkokarɨnd. Sɨ Rɨgamna B'ɨgasim wa tagoniny onggɨtyam dadal yɨrkokar owou, nokɨp Abu God kea Ti pɨlɨnd ɨmjati mal youtɨntonj.” ");
INSERT INTO gdr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Sɨ ton ket Yesund yerkito da, “Sɨn singi im Godɨmna wɨko omnɨkam. Sɨ b'ogla nangga e sɨn omnɨku?” ");
INSERT INTO gdr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ɨ Yesu ket ten mɨra amninonj da, “Ɨtemb jɨ Godɨmna wɨko da wɨn gar ke utkunda oramisya Ti pɨlɨnd yena re Ton yɨtmɨkitonj.” ");
INSERT INTO gdr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Sɨ ket ton Yesund yerkito da, “Sɨ man nangga kɨd kesa kɨma danda wɨko e omnɨket, nokɨm da ɨdenat sɨn yɨr ongu dɨde ket gar ke utkunda ke motkasu? Sɨ man nangga wɨko e omnɨket? ");
INSERT INTO gdr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mera b'uwarɨp owou awenento re mana na wul kesa tungg nata odede rɨngma re peband ɨrɨki yɨbɨm da, ‘Mose pumb tungg ke owou towa agoninonj owowɨm.’” ");
INSERT INTO gdr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ɨ ket Yesu ten amninonj da, “Kon ɨmɨnjogjog wen tamninyɨn. Ma Moset wa owou agoninonj pumb tungg ke. Ajɨ Kor B'ute wa ɨmɨnjog owou agoneneniny pumb tungg ke. ");
INSERT INTO gdr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mop nokɨp ɨntemb jɨ Godɨmna owou rɨnte re pumb tungg ke inɨk ɨ gowukoi rɨga wa yɨrkokar ogona eyeniny.” ");
INSERT INTO gdr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Sɨ ton Yesund yerkito da, “Ukoyam! Onggɨtyam owou sowa nogonenine!” ");
INSERT INTO gdr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ɨ Yesu ket ten amninonj da, “Kontemb yɨrkokarɨm owou. Sɨ yet ra Kor pɨlwa ikeny, ton ma ɨta ket owoupand ɨbɨm. Ɨ yet ra Kor pɨlɨnd gar ke utkunda oramis, ton ita wɨnɨnd ma ɨta nyɨpa ɨbɨm. ");
INSERT INTO gdr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ajɨ Kon kea wen amninond da, ‘Wɨn kea Ken yɨr nongɨma, ajɨ wɨn makaya gar ke utkunda ke nokasya.’ ");
INSERT INTO gdr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Komkesa rɨga rɨnsim re Kor B'u Kor nogoniny, ton opima Kor pɨlwa tuweny. Ɨ yet ra Kor pɨlwa ik, Kon makwa ngai ɨta eaukenyɨn bau wa. ");
INSERT INTO gdr_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mop nokɨp Kon pumb tungg ke netkond re ma Koina singi omnɨka mana, ajɨ Tina singi omnɨka mana yet re Ken nɨtmɨkitonj. ");
INSERT INTO gdr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Sɨ ɨtemb jɨ Tina singi yet re Ken nɨtmɨkitonj da Kon goro kwa ngai yɨpa rɨga yedamkitawɨn komkesa rɨga wa wɨngɨrɨnd rɨna re Kor B'u nokainonj. Ajɨ Kon b'ogla ten rutnɨkinɨn dadal ngɨrpu kesa yɨrkokar wa kikitum bibɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mop nokɨp ɨntemb jɨ Kor B'uɨmna singi da komkesa rɨga yepiya ra B'ɨgand yɨr ongi dɨde gar ke utkunda oramis Ti pɨlɨnd, ton b'ogla dadal ngɨrpu kesa yɨrkokar yakate. Sɨ Kon opima ten tutnɨkinyɨn dem kikitum bibɨrɨnd.” ");
INSERT INTO gdr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Sɨ onggɨt penaemb Ju rɨgap Yesum gatab yɨt b'ebongnento, mop nokɨp Ton yindonj da, “Kon ɨntemb jɨ owou rɨna re pumb tungg ke inkond.” ");
INSERT INTO gdr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Sɨ ton endento da, “Ma ɨte Yesu, Yosepɨm b'ɨga? Ma men ma wumɨr im Ti b'u ake Ti mog? Sɨ rɨdede pae Ton yu yindeny da Kon netkond re pumb tungg kena?” ");
INSERT INTO gdr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ɨ Yesu ket daka mɨra amninonj da, “Seg ke yɨt b'ebongnena wa wɨngɨrɨnd! ");
INSERT INTO gdr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Sɨ makwa ngai yɨpa rɨga rɨrɨr e Kor pɨlwa ik, ajɨ ɨnta ra Kor B'u Kor wus wa yii yet re Ken nɨtmɨkitonj. Ɨ Kon kwa daka ɨta tin utnyisɨn dem kikitum bibɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sɨ bageyam waina peband ɨja imemb jɨ ɨrɨki wekeny da, ‘Komkesa rɨga b'atouyaenanj Godɨm pɨlkaim.’ Sɨ komkesa rɨga yepiya ra B'und yɨt utkundenyi dɨde b'atouyaenanj Ti pɨlke, ton opima Kor pɨlwa tuweny. ");
INSERT INTO gdr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Makwa ke yet B'und yɨr yongonj, ajɨ Tonɨta yet re Godɨm pɨlke ikonj. Sɨ Tonɨta Tinta B'und yɨr yongonj. ");
INSERT INTO gdr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sɨ Kon ɨmɨnjogjog wen tamninyɨn. Yet ra gar ke utkunda rɨga ɨbɨm, ton kea dadal ngɨrpu kesa yɨrkokar yokas. ");
INSERT INTO gdr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Sɨ Kon ɨtemb yɨrkokarɨm owou. ");
INSERT INTO gdr_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wa b'uwarɨp wul kesa tungg nata owou eyento re mana na, ajɨ ton kea uj aukɨto. ");
INSERT INTO gdr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ɨtemb jɨ onggɨtyam owou rɨnte re pumb tungg ke inɨk. Sɨ yet ra onggɨtyam owou ou, ton ma ɨta uj okas. ");
INSERT INTO gdr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Kon ɨtemb yɨrkokarɨm owou rɨna re pumb tungg ke ikonj. Sɨ yet ra onggɨtyam owou ou, ton dadal e yilo ɨbneneny. Sɨ onggɨtyam owou rɨnte ra Kon takainyɨn ra Koina mɨ e gowukoi rɨga wa yɨrkokar okawam.” ");
INSERT INTO gdr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Sɨ onggɨtyam Yesu ma opureni yɨt mapenaemb Ju rɨga towalenggyam towa wɨngɨrɨnd danda kɨma yɨt b'ugwatento da, “Rɨdede e onggɨt rɨgat mera notkainy Tina mɨ ongongɨm?” ");
INSERT INTO gdr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Sɨ onggɨt penaemb Yesu ten amninonj da, “Kon ɨmɨnjogjog wen tamninyɨn. Ra wɨn maka Rɨgamna B'ɨga ma mɨ ongong iyenya dɨde maka Tina kus onaya iyenya, wa awɨr e kwa yɨrkokar wa pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ɨ yet ra Koina mɨ ongong iyeny dɨde Koina kus onaya iyeny, ton kea dadal ngɨrpu kesa yɨrkokar yokas. Ɨ Kodaka ket tin utnyisɨn dem kikitum bibɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mop nokɨp Koina mɨ re ɨmɨnjog owou e, ɨ Koina kus re ɨmɨnjog onaya nyɨ e. ");
INSERT INTO gdr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Sɨ yet ra Koina mɨ ongong iyeny ɨ Koina kus onaya iyeny, ton Kor pɨlnate yɨbneneny ɨ Kodaka ti pɨlnate nɨbnenenyɨn. ");
INSERT INTO gdr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ɨ yɨrkokarɨm B'u Ken nɨtmɨkitonj, sɨ Kodaka B'uɨmna yɨrkokar nate yɨrkokar nɨbnenenyɨn. Ɨ odede yɨpa wɨp nya ke ɨtemb rɨga yet ra Ken ongong nitiyeny, todaka Koina yɨrkokar nate yɨrkokar ɨbneneny. ");
INSERT INTO gdr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ɨntemb jɨ owou rɨna re pumb tungg ke inkonj. Ɨ onggɨtyam owou re ma ɨja e ɨt re mera b'uwarɨp re awenento dɨde ket uj aukenento. Sɨ yet ra onggɨtyam owou oweneny, ton ɨta yɨrkokar ɨbneneny dadal ngɨrpu kesa.” ");
INSERT INTO gdr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu onggɨtyam yɨtkak apureninonj re Tina ouyaena nat de Ju rɨga waina yɨr opmitenapu metɨnd de Kaparnaum wa. ");
INSERT INTO gdr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ɨ re Yesumna b'auyaena rɨga onggɨtyam Tina ouyaeni yɨtkak utkundeno, towa wɨngɨrɨnd jogjog rɨgap apurento da, “Onggɨtyam yɨtkak re seojog e okatam. Sɨ yete rɨrɨr e Tin ɨmjas?” ");
INSERT INTO gdr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ɨ Yesu kea Tilenggyam wumɨr yokatonj da Tina b'auyaena rɨgap re yɨt na b'ebongnento Ti gatab. Sɨ Ton ket ten amninonj da, “Ma ke onggɨtyam yɨtkakɨt wen gar negɨr amnɨkiny? ");
INSERT INTO gdr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Sɨ ra wɨn Rɨgamna B'ɨgand yɨr ongya dem pumb wa menonɨnd rɨtade re Ton naskand yɨbnonj, ma wɨn opima kwa gar negɨr taukindam dem? ");
INSERT INTO gdr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yɨnayɨna Wɨngawɨngatemb jɨ Rɨga yete re rɨga wa yɨrkokar agoniny. Ajɨ gowukoi rɨgaina dandat makwa ngai rɨrɨr e rɨga wa yɨrkokar takainy. Sɨ yɨtkak rɨna re Kon wa apurenawainyɨn re Yɨnayɨna Wɨngawɨngam pɨlkaim dɨde yɨrkokar okawa mim. ");
INSERT INTO gdr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ajɨ wa wɨngɨrɨnd nɨnda rɨga opima wekeny yepim re maka onggɨtyam yɨtkak gar ke utkunda ke yokasi.” Yesu nangga pena odede yindonj re nokɨp Ton get ke wumɨr na rɨga yepiya ra maka gar ke utkunda oramisi ɨ rɨnggɨt rɨgate Tin tɨb yii dem. ");
INSERT INTO gdr_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ɨ Yesu ket yɨt yɨsmontonj da, “Sɨ onggɨt mop penaemb Kon wen amninond da, ‘Makwa ngai yɨpa rɨga rɨrɨr e Kor pɨlwa ik, ajɨ ɨnta ra Kor B'u Kor notkau.’” ");
INSERT INTO gdr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Sɨ onggɨt kak ke Tina b'auyaena rɨga wɨngɨrɨnd jogjog rɨgap Tin kak yiyawo dɨde ket Tin yɨraro. Seg ton ket makwa ngai b'usaya Ton kɨma menon yokateno. ");
INSERT INTO gdr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Sɨ onggɨt penaemb Yesu twelp (12) ɨtmɨkitijog rɨga arkisinonj da, “Ma wɨda opima singi aindam Ken ɨraram?” ");
INSERT INTO gdr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ɨ Simon Petro Tin mɨra yomnonj da, “Yonggyam! Man dadal ngɨrpu kesa yɨrkokar yɨtkak kɨma et. Sɨ ya pɨlwa im sɨn ket wuyɨn? ");
INSERT INTO gdr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ɨ sɨn kwa gar ke utkunda ke yokatenyu dɨde wumɨr im da Man re Godɨmna Yɨnayɨna Rɨga et.” ");
INSERT INTO gdr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ɨ Yesu mɨra amninonj da, “Ma ma Konɨt wen twelp (12) rɨga abagɨkinond? Ajɨ wa wɨngɨrɨnd yɨpa rɨga re negɨr wɨngawɨnga kɨma e.” ");
INSERT INTO gdr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu onggɨtyam yɨt yindonj re Simon Iskariyotɨmna b'ɨga Yudasɨm gatab na nokɨp ton re twelp (12) rɨga wɨngɨrɨnd yɨpa rɨga na dɨde tontemb Tinɨm tɨbam tau dem. ");
INSERT INTO gdr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Onggɨt kak ke ket Yesu Galili eriya wɨngɨr nata yikenonj. Ajɨ Ton maka singi awonj Yuda eriya wa menonɨm. Mop nokɨp Ju rɨgap Tin oraka yiyeno ongandam. ");
INSERT INTO gdr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ɨ Ju rɨga waina Dikaramet Diyamdiyam Wɨn re kea wus nat awonj. ");
INSERT INTO gdr_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Sɨ onggɨt penaemb Yesund Ti yɨngganwarɨp yomno da, “Man b'ogla iwasɨt ɨngkek ɨ meket Yuda eriya wa, nokɨm da ɨdenat Moina b'auyaena rɨgap Moina kɨd kesa kɨma danda wɨko yɨr ongong teyenanj rɨna ra Man tamnɨkinyɨt. ");
INSERT INTO gdr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mop nokɨp yet ra singi tainy tilenggyam pɨtapɨta awowɨm, ton makwa ɨta egiti wɨko tamnɨkiny. Sɨ ra Man onggɨtyam wɨko tamnɨkinyɨt, Man b'ogla Molenggyam pɨtapɨta tainyɨt gowukoi rɨga wa.” ");
INSERT INTO gdr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nangga mop pena Ti yɨngganwarɨp odede endento re, nokɨp ton maka Yesund gar ke utkunda ke yokato. ");
INSERT INTO gdr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Sɨ onggɨt penaemb Yesu ten amninonj da, “Kor makaya wɨn rɨrɨrkɨp ainy menonɨm, ajɨ wa menonɨm wɨn re ɨpangendi e ebnau ita wɨnɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ɨ gowukoi rɨgap makwa opima wen negɨr yɨr ke yɨr tangranj, ajɨ ton opima Ken negɨr yɨr ke yɨr notngi, mop nokɨp Kon towa gatab yɨr ungata yɨt pɨtapɨta amneninyɨn da towaina mɨle re negɨrjog im. ");
INSERT INTO gdr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Sɨ wɨn wuwe onggɨtyam diyamdiyam wɨn okatam. Yu Kon ma ɨta neken onggɨtyam diyamdiyam wɨn okatam, mop nokɨp Kor makaya onggɨtyam wɨn nitkau rɨrɨrkɨp awowɨm.” ");
INSERT INTO gdr_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Sɨ onggɨtyam yɨt seg ke ket Ton adea de yɨbnonj Galili eriyand. ");
INSERT INTO gdr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ɨ re Yesumna yɨngganwar wuwonj onggɨtyam diyamdiyam wɨn okatam, seg Todaka ket yɨmta yikonj ajɨ Ton maka rɨga wa wɨpɨnd pɨtapɨta aenonj ajɨ egitenonj-a. ");
INSERT INTO gdr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Sɨ demb de onggɨtyam Dikaramet Diyamdiyam Wɨn natemb Ju rɨgap Yesund oraka yiyeno dɨde ket erkena yiyeno da, “Rote jɨ onggɨtyam Rɨga?” ");
INSERT INTO gdr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ɨ jogjog rɨga bobo wɨngɨrɨnd rɨgap Ti gatab ma sobijog na yɨt b'ebongnena wuwenonj. Sɨ nɨndap apurento da, “Ton re b'ogɨl Rɨga e.” Ajɨ kwa nɨndap apurento da, “Nayɨ, Ton jogjog rɨga im b'anygɨnena nya ke ugungatena eyeniny.” ");
INSERT INTO gdr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ajɨ makwa ngai yɨpa rɨgat Ti gatab yɨt pɨtapɨta yomnenonj rɨga wa wɨpɨnd, mop nokɨp ton Ju rɨga waina mopyam rɨga na moga uwadto. ");
INSERT INTO gdr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ɨ re ket onggɨtyam Dikaramet Diyamdiyam Wɨn ɨnyɨnyɨnd awonj, Yesu yɨnamet aba wa yikonj dɨde ket rɨga auyaeninonj. ");
INSERT INTO gdr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ɨ re Ju rɨgap Yesund yɨt yutkundeno, ton kea kɨd kesa aento dɨde ket b'ɨgekento da, “Ɨtemb Rɨga re sɨkɨl kesa rɨga e. Sɨ rɨdede na Ton yɨna peba yɨt wumɨr yokatenonj?” ");
INSERT INTO gdr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Sɨ onggɨt penaemb Yesu ten mɨra amninonj da, “Koina ouyaena re ma Koina e, ajɨ Tina e yet re Ken nɨtmɨkitonj. ");
INSERT INTO gdr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ɨ yet ra singi tainy God ma singi mɨle omnɨkam, ton ɨta ongwas onggɨtyam Koina ouyaena gatab da onggɨtyam re Godɨm pɨlkaim o mɨnda Koinajog nony ke opurena im. ");
INSERT INTO gdr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ɨ yete re tinajog nony ke apureniny, ton oraka yiyeny re tilenggyam rɨga wa pɨlke esourena okata ma. Ajɨ yete re nya oraka yiyeny b'ogɨl ɨnyomarena okawam Godɨm pɨlwa yet re Tin yɨtmɨkitonj, Ton re ɨmɨnjog yɨt opurena rɨga e, ɨ Ti pɨlɨnd awɨr e kwa negɨr kɨma kaokao mɨle. ");
INSERT INTO gdr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Sɨ ke wa Mose gog yɨt akainonj? Wa wɨngɨrɨnd awɨr e kwa yete gog yɨt yɨmta undokiny. Sɨ nangga pae wɨn oraka niyenya Ken ongandam?” ");
INSERT INTO gdr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Sɨ rɨga bobop ket mɨra yomno da, “Man negɨr wɨngawɨnga ke okati et. Yete Men oraka miyeny ongandam?” ");
INSERT INTO gdr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Seg Yesu ket ten mɨra amninonj da, “Kon yɨpa kɨd kesa kɨma danda wɨko yomnɨkond. Sɨ onggɨt paemb wɨn komkesa kɨd kesa aena wuwenyɨt. ");
INSERT INTO gdr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ɨ Mose wa God ma obagendi tɨrɨr omni mal wugɨm ɨpka mɨle akainonj. (Onggɨtyam mɨle re ma Mosem pɨlkena ikonj ajɨ wa b'uwar wa pɨlkena.) Sɨ onggɨt paimemb wɨn waina b'ɨga God ma obagendi tɨrɨr omni mal wugɨm ɨpka mɨle amnɨkenenindam waina wɨram dɨde yɨr opmitena bibɨr wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Sɨ wɨn ma opima singi ainindam Mosemna gog yɨt erbekam. Sɨ onggɨt paemb wɨn wa b'ɨgawar God ma obagendi tɨrɨr omni mal wugɨm ɨpka mɨle amnɨkenenindam waina wɨram dɨde yɨr opmitena bibɨr wɨngɨrɨnd. Sɨ nangga paim wɨn daka Kor pɨlwa soro aukindam nokɨp Kon yɨpa rɨgand kea kupkakupka yɨsakendond waina wɨram dɨde yɨr opmitena bibɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Wɨn goro b'ɨsagɨka mɨle tamnɨkindam gɨm ke yɨr ongong gasa ke, ajɨ wɨn b'ɨsagɨka mɨle tamnɨkindam ra negɨr kesa dɨmdɨmjog b'ɨsagɨka mɨle kena.” ");
INSERT INTO gdr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ɨ re nɨnda Yerusalem taun rɨgap Yesund yɨt yutkundo, ton endento da, “Ma ɨtemb jɨ rɨga yena re meraina mopyam rɨgap oraka yiyenyi ongandam? ");
INSERT INTO gdr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Sɨ yɨr de, Ton pɨta kɨpɨnd yɨt pɨtapɨta amneniny rɨga wa wɨpɨnd. Ajɨ makwa yete Tin yɨt yomneny. Sɨ rɨngma, ma ke mopyam rɨgap ɨmɨnjog Tin yongwasi da ɨtemb rɨga re Kerisote? ");
INSERT INTO gdr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ajɨ men wumɨr im da ra Keriso ik, makwa ɨta yete wumɨr okas rɨngkae jɨ Ton ik. Ajɨ ɨtemb re Rɨga men wumɨr im da ɨngkae ikonj.” ");
INSERT INTO gdr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Sɨ onggɨt penaemb Yesu yɨnamet aband unena kɨma ouyaena eyeninonj odede da, “Sɨ wɨn wumɨr im Kornɨm. Ɨ wɨn wumɨr im da rɨngkae Kon netkond. Sɨ Kon ma Koinajog singi kena netkond. Ajɨ God Ton re ɨmɨnjog e yet re Ken nɨtmɨkitonj. Ajɨ wɨn ma wumɨr im Tinɨm. ");
INSERT INTO gdr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ajɨ Kon wumɨr en Tinɨm nokɨp Kon Ti pɨlkena netkond, ɨ Tonɨt daka ket Ken nɨtmɨkitonj.” ");
INSERT INTO gdr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Sɨ onggɨt penaemb ton oraka yiyeno Tin okatam. Ajɨ makwa yɨpa rɨgat yɨm yoramitonj Ti pɨlɨnd nokɨp Tina wɨn re maka yokatonj. ");
INSERT INTO gdr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ajɨ onggɨtyam rɨga bobo wa wɨngɨrɨnd jogjog rɨgap Yesund gar ke utkunda ke yokato. Dɨde ton ket endento da, “Ra ket Keriso ik, rɨka Ton rɨrɨr e tamnɨkiny odede jogjog kɨd kesa kɨma danda wɨko rɨngmim re onggɨt Rɨgat amnɨkeniny? Ma rɨrɨr e.” ");
INSERT INTO gdr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ɨ Parisai rɨgap kea onggɨtyam rɨga bobo waina Yesum gatab b'ebongnena yɨt utkundeno. Sɨ ket yɨna mopyam sɨ rɨga dɨde Parisai rɨgap yɨnamet wɨko rɨga etmɨkurto Yesund yɨmɨnd usunatam. ");
INSERT INTO gdr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Sɨ onggɨt penaemb Yesu yindonj da, “Kon ma pɨnjog e nɨtɨbnyɨn wɨn kɨma. Ɨ ket Kon tɨtenjɨn Ti pɨlwa yet re Ken nɨtmɨkitonj. ");
INSERT INTO gdr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Sɨ wɨn ɨta Ken oraka nitiyenya dem ajɨ wɨn ma ɨta Ken notɨdarya dem. Ɨ dɨde kwa wɨn ma rɨrɨr im menonɨm rokate ra Kon nɨtɨbnyɨn dem.” ");
INSERT INTO gdr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ɨ re Ju rɨga waina mopyam rɨgap Yesund yɨt yutkundo, ton towa wɨngɨrɨnd b'arkena wuwenonj da, “Ɨtemb re rɨga rɨtama menonɨm ainy, sɨ ɨdenat men maka Tin odaru? Ma Ton ama ta meraina wetaweta auki Ju rɨga wa pɨlwa menonɨm ainy Grik yɨt opurena kantri wɨngɨrɨnd dɨde kwa Grik yɨtam rɨga ouyaenam? ");
INSERT INTO gdr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nangga e jɨ onggɨt yɨtkakɨt yisɨpkis re Ton yinj da, ‘Wɨn ɨta Ken oraka nitiyenya dem ajɨ wɨn ma ɨta Ken notɨdarya dem. Ɨ dɨde kwa wɨn ma rɨrɨr im menonɨm rokate ra Kon nɨtɨbnyɨn dem.’” ");
INSERT INTO gdr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ɨ onggɨtyam Dikaramet Diyamdiyam Wɨn wɨngɨrɨnd kikitum bibɨr re ukoijog bibɨr na yɨbnonj. Sɨ re onggɨtyam kikitum bibɨr awonj, Yesu onyitonj dɨde ket unena kɨma yindonj da, “Yepiya ra nyɨpa tekeny, tuyɨm ayo Kor pɨlwa dɨde nyɨ onaikya! ");
INSERT INTO gdr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yet ra Ken gar ke utkunda ke notkas, yɨrkokarɨm nyɨ opima kɨlɨm pɨla b'ɨtkenanj tina gar ke. Sɨ yɨna pebat daka odede wɨp emb yindeny.” ");
INSERT INTO gdr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Sɨ Yesu onggɨtyam yɨt yindonj re Yɨnayɨna Wɨngawɨnga gatab na. Sɨ yepiya ra Yesund gar ke utkunda ke okasi, ton ɨta okasi dem onggɨtyam Yɨnayɨna Wɨngawɨnga. Ajɨ onggɨt wɨnɨnd Yɨnayɨna Wɨngawɨnga maike gar ke utkunda rɨga kɨma yɨbnonj, mop nokɨp Yesu maka uj ke utnyita ke b'ogɨl ɨnyomarena yokatonj. ");
INSERT INTO gdr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ɨ re rɨga bobop onggɨtyam yɨt utkundeno, sɨ nɨnda rɨgap endento da, “Ɨtemb jɨ ɨmɨnjog onggɨtyam bageyam e yena re God tɨrɨr yomnonj ɨtmɨkitam.” ");
INSERT INTO gdr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ɨ nɨndap endento da, “Ɨtemb jɨ Keriso.” Ajɨ kwa nɨndap endento da, “Rɨdede e Keriso ik Galili eriya ke? ");
INSERT INTO gdr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ma yɨna pebat ɨja emb yindeny da Keriso ra pɨta tau dem Dawidɨmna kus kae, ɨ Dawidɨmna tungg, Betleem kae ik dem?” ");
INSERT INTO gdr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Sɨ onggɨt penaemb rɨga bobo Yesu map gangga b'akalkɨto. ");
INSERT INTO gdr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ɨ nɨnda rɨgap singi na aukɨto Yesund yɨmɨnd usunatam ajɨ makwa yet Ti pɨlɨnd yɨm aramisinonj. ");
INSERT INTO gdr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ɨ re yɨnamet wɨko rɨgap ɨtekto yɨna mopyam sɨ rɨga dɨde Parisai rɨga wa pɨlwa, ton ket ten egekitto da, “Wɨn nangga pena Tin maka iya?” ");
INSERT INTO gdr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Sɨ yɨnamet wɨko rɨgap mɨra amnɨto da, “Makwa ke yet odede yɨt apureninonj Ton re dɨde.” ");
INSERT INTO gdr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Sɨ onggɨt penaemb Parisai rɨgap todaka mɨra amnɨto da, “Ma ke Ton wen daka b'anygɨnena nya ke wɨp amniny? ");
INSERT INTO gdr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Rɨka ke yet mera wɨp iyoi rɨga wɨngɨrɨnd o Parisai rɨga wɨngɨrɨnd Tin gar ke utkunda ke yokas? Makwa yet. ");
INSERT INTO gdr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Sɨ opimemb rɨga bobo re gog yɨt wumɨr kesa rɨga im dɨde ton re God ma sake okati rɨga im.” ");
INSERT INTO gdr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ɨ towa wɨngɨrɨnd yɨpa rɨga, Nikodemo yet re naskand Yesum pɨlwa yikonj, ton ten amninonj, ");
INSERT INTO gdr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","da, “Meraina gog yɨtɨt ɨja emb yindeny da men naska rɨgam pɨlke b'agenai yɨt takasindam dɨde ket wumɨr okasu nangga im re ton amnɨkiny. Sɨ ɨngkaemb ket ti pɨlɨnd negɨr ma b'ɨsagɨka mɨle omnɨku. Ma sɨ meraina gog yɨtɨt ɨja emb yindeny?” ");
INSERT INTO gdr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ɨ todaka tin mɨra yomno da, “Ma mada Galili kaet? Sɨ man yɨna peba wa yɨr mekene! Ɨ man ɨta wumɨr okasɨt da makwa ɨta yɨpa bageyam ik Galili ke.” ");
INSERT INTO gdr_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Seg ket rɨgap yiwateno towaina met yɨpayɨpa wa. ");
INSERT INTO gdr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ajɨ Yesu yikonj de Olib dor wa. ");
INSERT INTO gdr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ɨ ɨspari ke re Yesu b'usaya sɨtawarjog yikonj de yɨnamet aba wa, komkesa rɨga bobo kea Ti pɨlwa wuwenonj. Seg Ton ket omitonj dɨde ket ten auyaeninonj. ");
INSERT INTO gdr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ɨ Ju rɨga waina gog ouyaena rɨga dɨde Parisai rɨgap yɨpa kongga wokato tina gigɨr dɨde yɨgyɨg b'iyena mɨle omnɨkand. Sɨ ton ket tin yɨmɨnd usunati wiyo dɨde ket wonyito rɨga bobo wa wɨpɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ɨ ton ket Yesund yomno da, “Ouyaena Rɨga-wɨi! Sɨn onggɨt konggand wokasu re onggɨt pɨpmet nat rɨkɨnd re ton yɨpa b'enga rɨga kɨma gigɨr dɨde yɨgyɨg b'iyena mɨle yomnɨkya. ");
INSERT INTO gdr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ɨ gog yɨt wɨngɨrɨnd Mose sɨn ningainonj odede kongga b'ogla gɨmokɨp ke ɨdrɨkam uj tama na. Sɨ Man nangga e mitinjɨt omnɨkam?” ");
INSERT INTO gdr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Sɨ ton odede yɨt opurena kenaemb Yesund yotonkeno, nokɨm da ɨdenat ton rɨl odarai Tin kot wa oramitam. Ajɨ Yesu uwontonj dɨde ket Tina yɨmkak ke gowɨnd erɨneninonj. ");
INSERT INTO gdr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ɨ re ton Yesund yɨgekenawayo, Yesu ket utnɨkonj dɨde ket ten amninonj da, “Wa wɨngɨrɨnd yete man negɨr mɨle kesa rɨga man naska gɨmokɨp b'ɨske ti pɨlwa!” ");
INSERT INTO gdr_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yɨt seg ke Ton b'usaya uwontonj dɨde ket gowɨnd ɨrɨkand b'aramitonj. ");
INSERT INTO gdr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ɨ re ton Tina yɨt utkundo, ton ket yɨpayɨpa ɨtrɨngka wuwenonj nanyam rɨga naska ɨ daka ket sisɨl rɨga. Ngɨrpu ket Yesu nena unyitonj, ɨ ɨtomb kongga toda re omanda wɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ɨ Yesu utnɨkonj ɨ ket tin werkitonj da, “Kongga! Ropim rɨga? Ma awɨr e yete mornɨm negɨr ma b'ɨsagɨkam rɨga?” ");
INSERT INTO gdr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Sɨ ton mɨra yomnonj da, “Yonggyam! Awɨr e kwa yete.” Sɨ Yesu daka tin womnonj da, “Sɨ b'ogɨl e, Kodaka ma ɨta mor pɨlɨnd negɨr ma b'ɨsagɨka omnɨken. Sɨ man meke, dɨde ngɨrpu yu ke goro kwa ngai yɨpa negɨr mɨle omnɨkɨm!” ");
INSERT INTO gdr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ɨ Yesu b'usaya rɨga amninonj da, “Kon re gowukoyɨm ngaya en. Sɨ yet ra Ken yɨmta nutundok, ton makwa ɨta ikeny sɨbɨbɨnd, ajɨ ton ɨta okas yɨrkokarɨm ngaya.” ");
INSERT INTO gdr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Sɨ Parisai rɨgap Tin yomno da, “Man Moinajog gatab nate yɨr ungata yɨt apureninyɨt. Sɨ Moina yɨr ungata yɨt re ma ɨmɨnjog e.” ");
INSERT INTO gdr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ɨ Yesu ket ten mɨra amninonj da, “Nangga ma jɨ rada Kon Koinajog gatab nate yɨr ungata yɨt apureninyɨn, onggɨtyam Koina yɨr ungata yɨt re ɨmɨnjog e. Nokɨp Kon wumɨr en rɨngkena Kon netkond, ɨ rɨtama Kon neken. Ajɨ wɨn ma wumɨr im rɨngkae Kon netkond o rɨtama Kon neken. ");
INSERT INTO gdr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ɨ wɨn opima gɨm ke gowukoi rɨgaina mɨle rɨrɨrɨnd rɨga wa pɨlɨnd b'ɨsagɨka mɨle amnɨkenindam, ajɨ Kon makwa ngai ya pɨlnate b'ɨsagɨka mɨle yomnɨkenenyɨn. ");
INSERT INTO gdr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ɨ ra Kon b'ɨsagɨka mɨle omnɨken, onggɨtyam Koina b'ɨsagɨka mɨle re ɨmɨnjog e. Mop nokɨp Kon ma Kenta e nɨbnyɨn, ajɨ Kon nɨbnyɨn re Kor B'u kɨma e yet re Ken nɨtmɨkitonj. ");
INSERT INTO gdr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Sɨ waina gog yɨt wɨngɨrɨnd ɨja emb jɨ ɨrɨki yɨbɨm da, ‘Ra nɨmog rɨgaina yɨr ungata yɨt yɨpa rɨrɨr taya, sɨ onggɨtyam yɨr ungata yɨt re ɨmɨnjog e.’ ");
INSERT INTO gdr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Sɨ Kon Kolenggyam re Koinajog gatab yɨr ungata yɨt opurena Rɨga en. Ɨ Kor B'u yet re Ken nɨtmɨkitonj, Todaka kwa Kor gatab yɨr ungata yɨt opurena Rɨga e.” ");
INSERT INTO gdr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Sɨ onggɨt penaemb ton Yesund yerkito da, “Rokate Mor B'u yɨbɨm?” Sɨ Yesu mɨra amninonj da, “Wɨn ma wumɨr im Kornɨm ɨ kwa ma wumɨr im Kor B'uɨm. Ra wɨn Kornɨm wumɨr taindam, wɨn kea kwa Kor B'uɨm daka wumɨr aindam.” ");
INSERT INTO gdr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ɨ re Yesu rɨga ouyaenand yɨbnonj yɨnamet aband, Ton onggɨtyam yɨtkak apureninonj re Godɨm wulkɨp oramkapu boks wus nat. Ajɨ makwa yet Tin yɨmɨnd yusunatonj, mop nokɨp Tina wɨn re maka itkawonj. ");
INSERT INTO gdr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ɨ Yesu b'usaya ten amninonj da, “Kon ɨta tewaikisɨn, ɨ wɨn ɨta Ken oraka nitiyenya. Ajɨ wɨn opima waina negɨr mɨlend uj taukindam. Sɨ wɨn ma rɨrɨr im menonɨm rɨtama ra Kon neken.” ");
INSERT INTO gdr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Sɨ onggɨt penaemb Ju rɨga waina mopyam rɨgap b'arkento da, “Ton nangga pae odede yindeny da, ‘Wɨn ma rɨrɨr im menonɨm rɨtama ra Kon neken.’ Ma sɨ onggɨt mop paemb yinj da Ton Tilenggyam e b'atnganj?” ");
INSERT INTO gdr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Seg Yesu ket ten amninonj da, “Wɨn re gou ke rɨga im, ajɨ Kon re pumb ke Rɨga en. Sɨ wɨn re onggɨtyam gowukoi rɨga im, ajɨ Kon re ma onggɨtyam gowukoi Rɨga en. ");
INSERT INTO gdr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Sɨ onggɨt paemb Kon kea wen wumɨr amninyɨn da, ‘Wɨn opima waina negɨr mɨlend uj taukindam.’ Sɨ ra wɨn maka Ken gar ke utkunda ke notkasya da Kon Tonten, wɨn opima waina negɨr mɨlend uj taukindam.” ");
INSERT INTO gdr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Sɨ onggɨt penaemb ton ket Yesund yɨgekito da, “Yetet Man?” Sɨ Yesu ket ten mɨra amninonj da, “Kon ɨntemb jɨ Rɨga yet re otomapu ke wa opurena tetiyainyɨmɨn ngɨrpu yu. ");
INSERT INTO gdr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ɨ Kon ma yɨpa kɨma gasa im awaminyɨn wa gatab opurenam dɨde negɨr ma b'ɨsagɨka omnɨkam. Ajɨ yet re Ken nɨtmɨkitonj, Tina opurena re ɨmɨnjog e. Sɨ Kodaka ɨnsima gowukoi rɨga wa apurenawainyɨn rɨna re Kon Ti pɨlke utkundeninond.” ");
INSERT INTO gdr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ajɨ ton ma wumɨr na da Yesu re Ti B'uɨm gatab im wumɨr amneniny. ");
INSERT INTO gdr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Sɨ Yesu ten amninonj da, “Onggɨt wɨnɨnd ra wɨn Rɨgamna B'ɨga urowasya, ɨdenatemb wɨn wumɨr okasya dem da Kon Ton ten, ɨ Kon makwa ngai opima Koina nony ke gasa amnɨkeninyɨn ajɨ Kon ɨnsima yɨpa rɨrɨrkɨp yɨtkak apureninyɨn rɨna re Kor B'u nouyaenonj. ");
INSERT INTO gdr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Sɨ yet re Ken nɨtmɨkitonj, Ton re Kon kɨma e. Ɨ Ton ma ɨta Kenta nɨrareny, mop nokɨp Kon ita wɨnɨnd Tinɨm sam okawa mim gasa amnɨkeninyɨn.” ");
INSERT INTO gdr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ɨ re Yesu onggɨtyam yɨt apureninonj, jogjog rɨgap kea Tin gar ke utkunda ke yokato. ");
INSERT INTO gdr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Sɨ onggɨt penaemb Yesu Ju rɨga amninonj yepiya re Tin gar ke utkunda ke yokato da, “Ra wɨn Koina yɨtkakɨm pɨlɨnd tekenyɨt, wɨn opima ɨmɨnjog Koina b'auyaena rɨga taindam. ");
INSERT INTO gdr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ɨ wɨn opima ɨmɨnjog yɨtkak wumɨr taindam, sɨ onggɨtyam ɨmɨnjog yɨtkakɨt ɨta wen tetrɨngasiny.” ");
INSERT INTO gdr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Sɨ ton ket Yesund mɨra yomno da, “Sɨn re Abraamɨmna kus ke b'ɨga im. Ɨ sɨn makwa ngai yɨpa wɨnɨnd yama na wɨko rɨga aukɨtondam. Sɨ Man rɨdede pae minjɨt da, ‘Wɨn opima b'ɨtrari rɨga taindam'?” ");
INSERT INTO gdr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Sɨ Yesu ket ten mɨra amninonj da, “Kon ɨmɨnjogjog wen tamninyɨn. Komkesa rɨga yepiya ra negɨr mɨle tamnɨkenenanj, ton re negɨr mɨlemna wɨko rɨga im. ");
INSERT INTO gdr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Sɨ yɨpa rɨga ma wɨko rɨga ma ɨta dadal ɨbneneny ti yonggyamɨm metɨnd, ajɨ ti b'ɨgata ton dadal ɨbneneny ti b'u ma metɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Sɨ onggɨt paemb ra B'ɨgat wen tetrɨngasiny, wɨn opima ɨmɨnjog b'ɨtrari rɨga taukindam. ");
INSERT INTO gdr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kon wumɨr en da wɨn re Abraamɨmna kus ke b'ɨga im. Ajɨ wɨn Ken oraka niyenya ongandam, mop nokɨp waina garɨnd awɨr e kwa pɨpmet yɨbɨm Koina yɨtkak wɨmenam. ");
INSERT INTO gdr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kon ɨnsim yɨtkak apureninyɨn rɨna re Kor B'u nouyaukinonj. Ajɨ wɨdaka ɨnsim gasa omnɨka eyenindam rɨna re wɨn utkundentondam wa b'uɨm pɨlke.” ");
INSERT INTO gdr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Sɨ ton Yesund mɨra yomno da, “Abraam re sowa b'u e.” Sɨ Yesu daka mɨra amninonj da, “Rada wɨn Abraamɨmna b'ɨgawar im, wɨn kako ɨnaemb gasa omnɨka eyenindam rɨna re Abraam amnɨkeninonj. ");
INSERT INTO gdr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Sɨ Kon wa ɨnsima ɨmɨnjog yɨtkak apurenawainyɨn rɨna re Kon utkundeninond Godɨm pɨlke. Ajɨ otade wɨn Ken oraka niyenya ongandam. Sɨ Abraam maike odede mɨle amnɨkeninonj. ");
INSERT INTO gdr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Sɨ wɨn ɨnsima wɨko omnɨka eyenindam rɨnsim re wa b'u omnɨka eyeniny.” Sɨ onggɨt penaemb ton kwa Yesund yomno da, “Sɨn ma basa oraki b'ɨga im. Sowa yɨpaina b'u re Godta tinta.” ");
INSERT INTO gdr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Sɨ Yesu ket ten amninonj da, “Rako God wa B'u ebnau, kako wɨn Ken singi niyenya, mop nokɨp Kon Godɨm pɨlkena netkond ɨ ɨtemb Kon ket dɨkɨnd nɨbnyɨn. Sɨ Kon ma Koina singi kena netkond, ajɨ Tonɨt Ken nɨtmɨkitonj. ");
INSERT INTO gdr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Sɨ nangga pae wɨn maka nony aukindam Koina opureni yɨtkak gatab? Sɨ nokpaim da wɨn ma rɨrɨr im Koina yɨtkak utkundam. ");
INSERT INTO gdr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Sɨ wɨn wa b'u, Satanam pɨlke rɨga im. Sɨ wɨn singi ainindam wa b'u ma singi mɨle omnɨka mim. Ton re otomapu ke rɨga onganda rɨga na yɨbnonj ɨ ton maka onyitonj ɨmɨnjog yɨtkakɨm pɨlɨnd, mop nokɨp ti pɨlɨnd awɨr e kwa ɨmɨnjog yɨtkak yɨbɨm. Ɨ ra ton b'anygɨnena yɨt tapureniny, ton tinajog nony kaim apureniny, nokɨp ton re b'anygɨnena rɨga e ɨ kwa ton re komkesa b'anygɨnena mɨlem b'u e. ");
INSERT INTO gdr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ajɨ Kon re ɨmɨnjog yɨtkak im apureninyɨn, sɨ onggɨt mop paemb wɨn maka Ken gar ke utkunda ke nokasya. ");
INSERT INTO gdr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ɨ ɨta yete wa wɨngɨrɨnd nɨtɨmjas da Kor ɨta negɨr mɨle? Sɨ rada Kon ɨmɨnjog yɨtkak im apureninyɨn, nangga pae wɨn maka gar ke utkunda ke nokasya? ");
INSERT INTO gdr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Sɨ yet ra Godɨmna rɨga tainy, ton ɨta Godɨmna opureni yɨtkak utkundena yikeny. Sɨ ɨtemb jɨ mop nangga pae wɨn maka God ma yɨtkak utkundenindam, nokɨp wɨn re ma Godɨmna rɨga im.” ");
INSERT INTO gdr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Sɨ onggɨt Ju rɨgap Yesund mɨra yomno da, “Sɨn nindenindam da, ‘Man re Samariya tunggam rɨga et yepim re Godɨm wumɨr kesa wekeny, dɨde Man negɨr wɨngawɨnga ke okati et.’ Sɨ ma onggɨtyam yɨt ɨmɨnjog e?” ");
INSERT INTO gdr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Sɨ Yesu mɨra amninonj da, “Kon ma negɨr wɨngawɨnga ke okati en. Sɨ Kon Kor B'u na yɨsnaenenyɨn. Ajɨ wɨn ma ɨta Ken nɨsnaenenya. ");
INSERT INTO gdr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kon ma Kornɨm b'ogɨl ɨnyomarena e oraka yiyenyɨn. Ajɨ ɨta jɨ yɨpa rɨga yete re Kornɨm b'ogɨl ɨnyomarena oraka yiyeny dɨde rɨga ɨsagɨka eyeniny. ");
INSERT INTO gdr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kon ɨmɨnjogjog wen tamninyɨn. Yet ra Koina yɨtkak tawameneniny, ton ma ɨta uj yɨr ong dem dadal ngɨrpu kesa.” ");
INSERT INTO gdr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Seg Ju rɨgap ket Yesund yomno da, “Sɨ yu sɨn pɨtakɨpɨnd wumɨr yokasu da Man re negɨr wɨngawɨnga ke okati rɨga et. Abraam re kea uj awonj dɨde daka Godɨmna bageyam toda kwa kea uj aukɨto. Ajɨ Man odede mindenyɨt da, ‘Yet ra Koina yɨtkak yɨmta undoka iyeny, ton makwa ɨta uj tainy dem dadal ngɨrpu kesa.’ ");
INSERT INTO gdr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Sɨ rɨka Man ukoyam et, ajɨ sowa b'u Abraam yet re uj awonj re ma amaya ukoyam e? Ɨ bageyam toda re kea uj aukɨto. Sɨ Man rɨdede e Molenggyam b'agenaet?” ");
INSERT INTO gdr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Sɨ Yesu ket ten mɨra amninonj da, “Ra Kon Kolenggyam Kornɨm b'ogɨl ɨnyomarena takasinyɨn, onggɨtyam Koina b'ogɨl ɨnyomarena re kɨp kesa e. Ajɨ ɨta Kor B'u yete re Kornɨm b'ogɨl ɨnyomarena nogoneneniny. Sɨ wɨn Tinaemb yogenaya da, ‘Sowa God’. ");
INSERT INTO gdr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ɨ wɨn ma wumɨr im Tinɨm ajɨ Kon wumɨr en Tinɨm. Ɨ ra Kon nitinjɨn da Kon ma wumɨr en Tinɨm, sɨ Kon re b'anygɨnena rɨga en wɨn re dɨde. Ajɨ Kon Tinɨm wumɨr en dɨde Tina yɨtkak im awameneninyɨn. ");
INSERT INTO gdr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ɨ wa b'u Abraam re ma sobijog sam nat yɨbnɨkenenonj yɨr ungand Koina bibɨr yɨr ongongɨm. Ɨ ton ket kea yɨr yongonj dɨde ket sam awonj.” ");
INSERT INTO gdr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Sɨ onggɨt penaemb Ju rɨgap Tin yomno da, “Man makaya pipti (50) kemag yokasɨt. Sɨ rɨdede na Man Abraamɨnd yɨr yongot?” ");
INSERT INTO gdr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Seg Yesu ket ten esmonggainonj da, “Kon ɨmɨnjogjog wen tamninyɨn. Abraam re yɨmta kena ukendonj, ajɨ Konɨtemb naska get ke nɨbnenenond.” ");
INSERT INTO gdr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Sɨ onggɨt penaemb ton gɨmokɨp emdɨto Tin ɨdrɨkam. Ajɨ Yesu kea b'ulongkena yikonj dɨde ket yɨnamet bau wa opendonj. ");
INSERT INTO gdr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ɨ re Yesu nya yɨmayonj, Ton kea yɨpa yɨrdɨdɨ ukendi rɨga yɨr yongonj. ");
INSERT INTO gdr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Sɨ Tina b'auyaena rɨgap Tin yerkito da, “Ouyaena Rɨga-wɨi! Yaina negɨr mɨlet tin odede yɨrdɨdɨ ukendam yomnonj, mɨnda tinajog negɨr mɨlet o mɨnda ti b'u ake ti mog waina negɨr mɨlet?” ");
INSERT INTO gdr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ɨ Yesu mɨra amninonj da, “Ma tinajog negɨr mɨlet o ma ti b'u ake ti mog waina negɨr mɨlet tin yɨrdɨdɨ ukendam yomnonj. Ajɨ ton yɨrdɨdɨ ukendonj re Godɨmna wɨko pɨta omna mana ti pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yu men b'ogla Tina wɨko ramnɨkinum yet re Ken nɨtmɨkitonj ngɨrpu ra ket bibɨr wɨn b'utundwas. Ɨ sɨwɨny ɨta ik. Sɨ onggɨtyam wɨnɨnd makwa yɨpa rɨgat rɨrɨr e wɨko omnɨk. ");
INSERT INTO gdr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Sɨ ɨte re Kon gowukoyɨnd nɨbnyɨn, Kon re gowukoyɨm ngaya en.” ");
INSERT INTO gdr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Onggɨtyam yɨt seg ke Yesu auya b'ɨskonj gou wa dɨde ket onggɨtyam auya ke pam yomnɨkonj. Seg ket Yesu onggɨtyam pam ke onggɨt rɨga ma yɨrkɨp esnɨkonj. ");
INSERT INTO gdr_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ɨ Yesu ket tin yomnonj da, “Meke Silowam kip wa, ɨ ket yɨrkɨp b'ɨtɨseket!” (Silowam engenda yɨtkak re “Ɨtmɨkiti” e.) Sɨ ton yiwatonj dɨde ket yɨrkɨp b'ɨsekonj. Seg ton ket yɨr b'ɨskena yikonj tina met wa. ");
INSERT INTO gdr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ɨ re ti wuswusam rɨgap dɨde yepiya re naskand tin yɨr ongong yiyeno tina b'ɨjenena mɨlend, ton tin ɨsakendi yɨr yongo, ton kea b'ɨgekento da, “Ma ɨntemb jɨ rɨga yet re omiti yɨbnenenonj b'ɨjenenam?” ");
INSERT INTO gdr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sɨ nɨndap endento da, “Tontemb onggɨtyam rɨga.” Ajɨ kwa nɨndap da, “Nayɨ, ajɨ ton re yɨpa ti wɨp pɨla rɨga e.” Ajɨ onggɨtyam ɨsakendi rɨga tilenggyam b'agenayonj da, “Kon ɨtemb jɨ rɨga.” ");
INSERT INTO gdr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Sɨ onggɨt penaemb ton tin yɨgekito da, “Sɨ rɨdede na moina yɨrkɨp b'ɨpangenjya?” ");
INSERT INTO gdr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Sɨ onggɨt rɨgat ten mɨra amninonj da, “Ɨte re rɨga ogenaya da Yesu, Tonɨt pam yomnɨk ɨ ket onggɨtyam pam ke koina yɨrkɨp esnɨk. Ɨ Ton ket ken ningau da, ‘Meke de Silowam wa dɨde b'ɨtɨseket.’ Sɨ kon yiwasɨn ɨ ket b'ɨseken, ɨ ɨngkenaemb ket koina yɨr ɨpangenjya, ɨ kon ket yɨr b'ɨskenyɨn.” ");
INSERT INTO gdr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Sɨ ton tin yɨgekito da, “Rotemb jɨ onggɨtyam Rɨga?” Ton mɨra amninonj da, “Kon ma wumɨr en.” ");
INSERT INTO gdr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Sɨ rɨgap onggɨtyam ɨsakendi rɨga yiyo Parisai rɨga wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ɨ onggɨtyam bibɨr re Ju rɨga waina wɨram dɨde yɨr opmitena bibɨr nat re Yesu pam yomnɨkonj dɨde onggɨt rɨgamna yɨr epangendonj. ");
INSERT INTO gdr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Sɨ onggɨt penaemb Parisai rɨgap todaka tin b'usaya yɨgekito da, “Rɨdede na man yɨr ɨpangenjɨt yɨr b'ɨskenam?” Sɨ ton ten mɨra amninonj da, “Ton koina yɨrkɨpɨnd pam yoramɨk. Ɨ kon ket b'ɨseken, ɨ ɨngkenaemb ket yɨr ongongɨm aen.” ");
INSERT INTO gdr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Sɨ onggɨt penaemb Parisai rɨga wɨngɨrɨnd ket nɨndap endento da, “Ɨtemb rɨga re ma Godɨm pɨlkae, nokɨp Ton maka meraina wɨram dɨde yɨr opmitena bibɨr yowam.” Ajɨ kwa nɨndap endento da, “Rɨdede na negɨr mɨle kɨma rɨgat odede kɨd kesa kɨma danda wɨko amnɨkiny?” Sɨ ton ket gangga b'akalkɨto towa wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Sɨ onggɨt penaemb ton b'usaya onggɨtyam yɨrdɨdɨ rɨgand yɨgekito da, “Ton kea moina yɨrkɨp epangenj, sɨ rɨdede e man Ti gatab mitinjɨt?” Sɨ ton ket esmonggainonj da, “Ton re bageyam e.” ");
INSERT INTO gdr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ajɨ Ju rɨga waina mopyamɨp maka ti gatab ɨmɨnjogɨm yomno da ton yɨrdɨdɨ rɨga na yɨbnonj ɨ ket yɨr ɨpangɨk. Ngɨrpu ton ket onggɨtyam yɨr ɨpangendi rɨgam b'u ake mog engauko. ");
INSERT INTO gdr_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ɨ ton ket ten arkito da, “Ma waina b'ɨga e jɨ yena re wɨn yomnonda da yɨrdɨdɨ na ukendonj? Sɨ rɨdede na yu ton yɨr ɨpangɨk?” ");
INSERT INTO gdr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Sɨ ti b'u ake ti mog mɨra amninonda da, “Sɨn wumɨr i da ton re sowaina b'ɨga e, ɨ ton yɨrdɨdɨ na ukendonj. ");
INSERT INTO gdr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ajɨ sɨn ma wumɨr i rɨdede na ton yɨr ɨpangɨk o sɨn kwa ma wumɨr i yet tina yɨrkɨp epangenj. Mobe tin yerkena! Ton ke ukoi e. Sɨ ton tilenggyam b'ogɨl e b'atgenai ti gatab.” ");
INSERT INTO gdr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Sɨ ti b'u ake ti mog onggɨtyam yɨt endenonda re Ju rɨga waina mopyam moga mapena, mop nokɨp ton kea tɨrɨr yomno da yet ra pɨtapɨta omɨny da Yesu re Keriso e, ton ɨta b'ɨsagɨka mɨle okas eaukenam towaina yɨr opmitenapu met ke. ");
INSERT INTO gdr_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Sɨ onggɨt mop penaemb ti b'u ake ti mog odede endenonda da, “Ton ke ukoi e. Mobe tin yerkena!” ");
INSERT INTO gdr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Seg ket ton nɨmogɨm yɨgekito onggɨt rɨgand yet re yɨrdɨdɨ yɨbnonj da, “Godɨm b'ogɨl ɨnyomarena yokaene! Sɨn wumɨr im da ɨtemb Rɨga re negɨr mɨleyam e.” ");
INSERT INTO gdr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Sɨ ton mɨra amninonj da, “Kon ma wumɨr en rɨka Ton negɨr mɨleyam e. Ajɨ kon ɨnta yɨpaina wumɨr da kon re yɨrdɨdɨ rɨga na nɨbnond ajɨ yu kon ket yɨr ɨpangendi en.” ");
INSERT INTO gdr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ɨ ton ket tin yɨgekito da, “Nangga na Ton yomnɨk mor pɨlɨnd? Ɨ rɨdede na Ton moina yɨrkɨp epangenj?” ");
INSERT INTO gdr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ɨ ton ket ten mɨra amninonj da, “Kon kea wen wumɨr amninyɨn ajɨ wɨn maka nutkunjya. Nangga pae wɨn b'usaya singi aindam utkundam? Ma sɨ wɨdaka singi im aindam Tina b'auyaena rɨga awowɨm?” ");
INSERT INTO gdr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Sɨ ton ket negɨr yɨt ke tin yomno da, “Man re onggɨt Rɨgamna b'auyaena rɨga et. Ajɨ sɨn re Mosemna b'auyaena rɨga im. ");
INSERT INTO gdr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Sɨn wumɨr im da God kea Mosend yɨt yomnenonj ajɨ sɨn ma wumɨr im ɨtemb Rɨga rɨngkaemb Ton ikonj.” ");
INSERT INTO gdr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Sɨ ton ket ten amninonj da, “Sɨ nangga pae, etama kɨma awɨk. Ton kea koina yɨrkɨp epangenj, ajɨ wɨn maka wumɨr aindam rɨngkae Ton ik. ");
INSERT INTO gdr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Men wumɨr im da God ma opima negɨr mɨleyam utkundeniny, ajɨ Ton utkundeniny re Tinɨm ewangaya rɨga im dɨde Tina singi omnɨka rɨga im. ");
INSERT INTO gdr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Gowukoi otomapu ke ngɨrpu yu makwa ngai yɨpa rɨgat utkundonj da ke yɨpa rɨgat yɨrdɨdɨ ukendi rɨga ma yɨrkɨp epangendonj. ");
INSERT INTO gdr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Sɨ rako ɨtemb rɨga maka Godɨm pɨlke ikonj, Ton makwa rako ngai rɨrɨr na ainy nanggamog odede wɨko omnɨkam.” ");
INSERT INTO gdr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Seg ton ket tin yɨsmonggawo da, “Man kupka negɨr mɨle nat ukendot. Sɨ man sɨn nouyaeninyɨt-a?” Ɨ ton ket tin yeaukeno bau wa. ");
INSERT INTO gdr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ɨ re Yesu utkundonj da ton tin yeaukeno bau wa, Ton kea tin yodaronj. Ɨ Ton ket tin yomnonj da, “Ɨta man gar ke utkunda yoramisɨt Rɨgamna B'ɨgam pɨlɨnd?” ");
INSERT INTO gdr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Sɨ ton mɨra yomnonj da, “Ukoyam! Yetemb jɨ Ton? Kon ɨta singi Ti pɨlɨnd gar ke utkunda oramitam.” ");
INSERT INTO gdr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ɨ Yesu tin yomnonj da, “Sɨ man ɨta Tin yɨr ongong yiyenyɨt. Ɨ Tontemb jɨ Rɨga yete re man kɨma yɨtnono aeny.” ");
INSERT INTO gdr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ɨ ton ket yindonj da, “Yonggyam! Kon ke gar ke utkunda yoramisɨn.” Seg ton ket Yesum pɨlwa kumsos b'amkonj. ");
INSERT INTO gdr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ɨ Yesu ket yindonj da, “Kon onggɨt gowukoi wa netkond re b'ɨsagɨka mɨle omnɨka mana, nokɨm da ɨdenat yɨrdɨdɨ rɨga yɨr tepangkanj, ajɨ yepim re yɨr ɨpangki wekeny, ton b'ogla yɨrdɨdɨ rɨga raukinem.” ");
INSERT INTO gdr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ɨ Parisai rɨga wɨngɨrɨnd nɨnda rɨga yepiya re wekenonj Yesu kɨma, ton kea onggɨtyam yɨt utkundo. Sɨ ton ket Yesund yerkito da, “Sɨ ma sɨda kwa yɨrdɨdɨ rɨga im?” ");
INSERT INTO gdr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ɨ Yesu ket ten amninonj da, “Sɨ rako wɨn yɨrdɨdɨ rɨga aukɨtondam, keako wɨn maka negɨr mɨle kɨma na wekenyɨt. Ajɨ yu wɨn kea endenindam da sɨn yɨr ɨpangki im, sɨ waina negɨr mɨle re opima wa pɨlɨnd wekeny.” ");
INSERT INTO gdr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Kon ɨmɨnjogjog wen tamninyɨn. Yet ra maka mora bora ke b'ɨtgar mamoi kara wɨngɨr wa ajɨ ra b'enga nya tatonkeniny ɨjenam, sɨ ɨtemb rɨga re yurowamam e dɨde raskol rɨga e. ");
INSERT INTO gdr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ajɨ yet ra mora bora ke b'ɨtgar, ton re onggɨtyam mamoi yɨr ɨpka rɨga e. ");
INSERT INTO gdr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ɨ ra mora yɨr ɨpka rɨgat mora ɨpangenj onggɨt mamoi yɨr ɨpka rɨgam b'ɨgaram, mamoyɨp b'ogla tina nonykok utkunji. Ɨ ton tinajog mamoi yɨpayɨpa nyɨ tagenainy dɨde ton ket ten wɨp tamniny de bau wa. ");
INSERT INTO gdr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ɨ ra ton komkesa tinajog mamoi bau wa tapekiny, ton naska wa e tainy dɨde tina mamoyɨp ɨta tin yɨmta undoki, mop nokɨp ton wumɨr im tina nonykok. ");
INSERT INTO gdr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ajɨ ton makwa ɨta ngai b'enga rɨgand yɨmta undoki ajɨ ton ti pɨlke b'ɨtkenanj-a, mop nokɨp ton ma wumɨr im onggɨtyam b'enga rɨga ma nonykok.” ");
INSERT INTO gdr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu onggɨtyam tendam yɨt ke ten amninonj ajɨ ton maka nony aukɨto nangga yɨt na re towa usekawonj. ");
INSERT INTO gdr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Sɨ onggɨt penaemb Yesu b'usaya ten amninonj da, “Kon ɨmɨnjogjog wen tamninyɨn. Kon re mamoi wa mora en. ");
INSERT INTO gdr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kon re yɨmtanyam en ajɨ komkesa Ju rɨga waina wɨp iyoi rɨga yepiya re naska kana tuwonj, ton re yurowamam im dɨde raskol rɨga im. Sɨ mamoyɨp maka ten yɨt utkundenento. ");
INSERT INTO gdr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kon re mora en. Sɨ yet ra b'ɨtgar onggɨtyam mora bora nya, ton ɨta yɨrkokar okas. Ɨ ra ton b'ɨtgareny dɨde topendeny, sɨ odede menamenand ton ɨta b'ogɨl sal tɨb tadarkiny. ");
INSERT INTO gdr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ɨ yurowamam rɨga re ɨna nena ma ik ɨt re da yurowamɨm ɨ uj ondrɨkam ɨ dɨde eomnenam. Ajɨ Kon onggɨt mana netkond da ɨdenat mamoyɨp yɨrkokar okasi dɨde onggɨtyam yɨrkokar kupkakupka ɨnɨka yik. ");
INSERT INTO gdr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Kon re b'ogɨl mamoi yɨr ɨpka rɨga en. Sɨ b'ogɨl mamoi yɨr ɨpka rɨgat tina yɨrkokar b'ogla oramis mamoi b'ogɨl omnam. ");
INSERT INTO gdr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ajɨ wulkɨp kɨma wɨko rɨga re ma ɨmɨnjog mamoi yɨr ɨpka rɨga e. Ɨ mamoi re toda ma tinajog im. Sɨ ra dɨ yongg ik, ton mamoi terarkiny dɨde ket b'ɨtkeny. Sɨ onggɨt dɨ yonggɨt mamoi tejgeniny dɨde ket terenjainy. ");
INSERT INTO gdr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Sɨ nangga pae ton b'ɨtkeny re nokɨp ton re wulkɨp kɨma wɨko rɨga e, sɨ ton ma ɨmɨnjog singi kaim onggɨtyam mamoi yɨr ɨpka eyeniny. ");
INSERT INTO gdr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Kon re b'ogɨl mamoi yɨr ɨpka rɨga en. Ɨ Kon wumɨr en Koina mamoi, ɨ todaka Koina mamoi wumɨr im Kornɨm. ");
INSERT INTO gdr_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ɨ rɨja e re B'u Kornɨm wumɨr yɨbɨm, Kodaka kwa ɨja e Kor B'uɨm wumɨr nɨbnyɨn. Sɨ Kon Koina yɨrkokar b'ogla oramisɨn onggɨtyam Koina mamoi b'ogɨl omnam. ");
INSERT INTO gdr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ɨ God ma obagɨki kesa rɨga toda re Koina mamoi im rɨnsim re maka onggɨt Ju kus kara borand wekeny. Sɨ Kon b'ogla teda kwa wɨp teyeninyɨn. Ɨ ɨngkaemb ton Koina nonykok tutkundenyi dɨde ket yɨpaina mamoi bobo tauranj. Seg ton ket yɨpaina mamoi yɨr ɨpka rɨga wɨrand tekeny. ");
INSERT INTO gdr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ɨ nangga mop pae B'u Ken singi niyeny re nokɨp Kon b'ogla Koina yɨrkokar ujɨnd oramisɨn, nokɨm da ɨdenat Kon b'usaya okasɨn onggɨtyam yɨrkokar. ");
INSERT INTO gdr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ɨ makwa ɨta yɨpat onggɨtyam yɨrkokar nɨtɨsas Kor pɨlke, ajɨ Konte onggɨtyam yɨrkokar ujɨnd oramisɨn Koina singi rɨrɨrɨnd. Sɨ Kor ɨta danda onggɨtyam yɨrkokar ujɨnd oramitam ɨ kwa kor ɨta danda b'usaya onggɨtyam yɨrkokar okatam. Sɨ Kon onggɨtyam b'ingawa yokatond re Kor B'uɨm pɨlkena.” ");
INSERT INTO gdr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ɨ onggɨtyam Yesu ma yɨt map Ju rɨgap b'usaya gangga b'akalento towa wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Sɨ towa wɨngɨrɨnd jogjog rɨgap endento da, “Ton kea negɨr wɨngawɨnga ke okati e yɨbɨm, ɨ ɨngkaemb korɨrkorɨr awɨk. Sɨ nangga pae wɨn Tin yɨt yutkundenya?” ");
INSERT INTO gdr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ɨ nɨndap daka endento da, “Onggɨtyam opureni yɨt re ma negɨr wɨngawɨnga ke okati rɨgaina opurena im. Rɨka rɨrɨr e negɨr wɨngawɨnga ke okati rɨgat yɨrdɨdɨ rɨga ma yɨrkɨp tepangenj?” ");
INSERT INTO gdr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ɨ Yɨnamet B'ogɨl Omna gatab Nony Iyena Diyamdiyam Wɨn awonj Yerusalem taunɨnd, ɨ ɨtemb wɨn re gɨbɨl wɨn nat. ");
INSERT INTO gdr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ɨ Yesu yikenonj yɨpa dɨr kesa met nat ogenaya da, ‘Solomonɨmna Met’ yɨnamet kara wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ɨ re Ju rɨga tuwonj Ti pɨlwa, ton kea Tin yɨwatɨnto. Ɨ ton ket Tin yomno da, “Rɨdede pɨn im Man sɨn nonysɨpsɨpɨnd notowaminyɨt? Rada Man Kerisotet, Man sɨn pɨtakɨpɨnd wumɨr nomnine!” ");
INSERT INTO gdr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ɨ Yesu ket ten mɨra amninonj da, “Kon kea wen wumɨr omnena teyinyɨmɨn ajɨ wɨn maka gar ke utkunda yoramitenyɨma. Onggɨtyam wɨko rɨna re Kon amnɨkinyɨmɨn Kor B'uɨm nyɨ kɨma, tonpim Kor gatab yɨr ungata yɨt apurenanj. ");
INSERT INTO gdr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ajɨ wɨn makwa ɨta gar ke utkunda yoramitenya, mop nokɨp wɨn re ma Koina mamoi im. ");
INSERT INTO gdr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Koina mamoyɨp opima utkundenyi Koina nonykok, ɨ Kodaka towanɨm wumɨr en. Sɨ ton ɨta Ken yɨmta nutundoki. ");
INSERT INTO gdr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ɨ Kontemb towa akainyɨn dadal ngɨrpu kesa yɨrkokar. Sɨ ton makwa opima uj okasi dadal ngɨrpu kesa. Ɨ makwa ɨta yete ten tetrɨngasiny Koina yɨm ke. ");
INSERT INTO gdr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ɨ Kor B'u yet re onggɨtyam mamoi Kor nokainonj, Ton re ukoijog danda rɨga e ajɨ komkesa re ma danda im. Sɨ makwa yete rɨrɨr e ten tetrɨngasiny Kor B'u ma yɨm ke. ");
INSERT INTO gdr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kon dɨde Kor B'u, Sɨn re yɨpaina i.” ");
INSERT INTO gdr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Sɨ Ju rɨgap b'usaya gɨmokɨp emdɨto Tin ɨdrɨkam. ");
INSERT INTO gdr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ajɨ Yesu ket ten amninonj da, “Kon jogjog b'ogɨl wɨko wa pɨta amnɨkainond rɨna re Kor B'u nokainonj omnɨkam. Sɨ onggɨtyam wɨko wɨngɨrɨnd nangga wɨko mop pae wɨn singi aindam Ken gɨmokɨp ke ɨdrɨkam?” ");
INSERT INTO gdr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ɨ Ju rɨgap ket Tin yɨsmonggawo da, “Ma onggɨtyam b'ogɨl wɨko mop pae sɨn gɨmokɨp ke Men ɨdrɨkam momnyu, ajɨ Moina Godɨnd b'ɨsadrena mɨle mop pae. Nokɨp Man re rɨgajog et ajɨ Man Molenggyam God kɨma yɨpa rɨrɨr e awowɨm aenyɨt.” ");
INSERT INTO gdr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Seg Yesu ket ten mɨra amninonj da, “Ma waina gog peband ɨja e ɨrɨki yɨbɨm da, ‘Kon kea nindenond da wɨn re god im wekenyɨt rɨga wa wɨpɨnd’? ");
INSERT INTO gdr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Sɨ God re kea onggɨtyam rɨga ‘god’ ke agenainonj yepiya re Godɨmna yɨtkak yokateno. Sɨ men wumɨr im da makwa yete rɨrɨr e yɨna peba yɨt awɨr omɨny. ");
INSERT INTO gdr_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Sɨ onggɨt mop paemb Kon b'agenaen da, ‘Kon re Godɨmna B'ɨga en,’ nokɨp Godɨt Ken yɨna nomnonj ɨ onggɨt gowukoi wa nɨtmɨkitonj. Ajɨ wɨn nangga pae odede nomnenya onggɨt gatab da, ‘Man kea b'ɨsadrena mɨle yomnɨket’? ");
INSERT INTO gdr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ɨ rada Kon ma Kor B'u ma wɨko im amnɨkeninyɨn, sɨ wɨn goro gar ke utkunda ke notkata! ");
INSERT INTO gdr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ajɨ rada Kon opima amnɨkeninyɨn, wɨn b'ogla gar ke utkunda ke nokata! Ajɨ maka ra rɨrɨr ra, wɨn b'ogla onggɨtyam Koina omnɨki wɨko gar ke utkunda ke akasinam! Sɨ ɨdenat wɨn wumɨr okasya da B'u Kor pɨlnate yɨbɨm ɨ Koda kwa Kor B'uɨm pɨlnata nɨbnyɨn.” ");
INSERT INTO gdr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Sɨ onggɨt penaemb ton b'usaya Yesund oraka yiyo yɨmɨnd usunatam. Ajɨ Ton kea ɨtrɨngendonj towa pɨlke. ");
INSERT INTO gdr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Seg Yesu ket b'usaya yiwatonj Yordan kɨlɨm yɨpa tab wa. Ɨ Ton ket yikonj onggɨt pɨpmet wa rɨkɨnd re Yoan naskand rɨga baptiso amnɨkeninonj dɨde ket ademb de yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Sɨ jogjog rɨga re kea Ti pɨlwa wuwenonj ɨ ket endento da, “Yoan makwa ke yɨpa kɨd kesa kɨma danda wɨko yomnɨkonj, ajɨ komkesa yɨt rɨna re ton onggɨt rɨgam gatab apureninonj re ɨmɨnjog na.” ");
INSERT INTO gdr_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Sɨ ademb de onggɨt pɨpmetɨnd jogjog rɨgap Yesund gar ke utkunda ke yokato. ");
INSERT INTO gdr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Yɨpa rɨga, nyɨ da Lajaro, kopa na yɨbnonj Betaniya tunggɨnd rɨkɨnd re Mariya ake ti wundoi Marta ebnonda. ");
INSERT INTO gdr_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ɨ ɨntomb jɨ Mariya yet re Yonggyamɨm pɨlɨnd ngɨrangngɨrang gaya yɨgmarkonj dɨde ket tina mopngɨi ke Yonggyamɨmna pɨs esekonj. Ɨ Lajaro yet re kopand yɨbnonj, ton re ti kɨmɨr na. ");
INSERT INTO gdr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Sɨ Lajaromna ngɨmɨr nɨmogɨp Yesum yɨt yɨtmɨkitawonda da, “Yonggyam! Yɨr de, Moina singi iyeni rɨga ke kopa nate yɨbɨm.” ");
INSERT INTO gdr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ɨ re Yesu onggɨtyam yɨt utkundonj, Ton yindonj da, “Onggɨtyam kopa re ma uj okata ma ajɨ Godɨmna b'ogɨl ɨnyomarena pɨta omna ma. Sɨ ɨdenat onggɨtyam kopa ke Godɨmna B'ɨgat b'ogɨl ɨnyomarena okas.” ");
INSERT INTO gdr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu kea nanyɨngganwar singi eyeninonj, Marta ɨ ti wundoi dɨde Lajaro. ");
INSERT INTO gdr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ɨ re Yesu utkundonj da Lajaro kopa nate yɨbɨm, Ton maka yikonj ajɨ omanda nɨmog bibɨr awamonj rɨkɨnd re Ton yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ɨ onggɨt kak ke Yesu Tina b'auyaena rɨga amninonj da, “Men b'usaya Yuda eriya wa rɨtekinum!” ");
INSERT INTO gdr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Sɨ Tina b'auyaena rɨgap Tin yomno da, “Ouyaena Rɨga-wɨi! Man rɨna pɨn mɨbnyɨmɨt re Ju rɨgap oraka miyeno gɨmokɨp ke ɨdrɨkam? Ajɨ nangga pae Man b'usaya ɨtendam ainyɨt?” ");
INSERT INTO gdr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ɨ Yesu ket mɨra amninonj da, “Yɨpa bibɨr wɨnɨm, ma twelp (12) awa im pop? Sɨ yet ra bibɨr wɨnɨnd menon okas, ton ma ɨta b'utuwombeny, mop nokɨp ton gasa pɨta nasim yɨr ongong eyeniny onggɨt gowukoyɨmna ngayand. Sɨ Kon re ngaya en. ");
INSERT INTO gdr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ajɨ yet ra sɨwɨnyɨnd menon okas, ton ɨta b'utuwombeny nokɨp ti ma ɨta ngaya.” ");
INSERT INTO gdr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ɨ onggɨt yɨt seg ke ket Ton kwa ten amninonj da, “Meraina rɨga Lajaro yɨt e weg. Ajɨ Kon neken ra tin yɨt opmura ma.” ");
INSERT INTO gdr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ɨ Tina b'auyaena rɨgap Tin yomno da, “Yonggyam! Rada ton yɨt e weg, ton ɨta b'ɨtɨsakenj.” ");
INSERT INTO gdr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu Lajaromna uj gatab na yɨtnono aenonj ajɨ Tina b'auyaena rɨgap ɨja na nony aukɨto da Ton ɨmɨnjog yutunga gatab e yindeny. ");
INSERT INTO gdr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Sɨ onggɨt penaemb Yesu pɨtakɨpɨnd ten wumɨr amninonj da, “Lajaro ke uj awɨm. ");
INSERT INTO gdr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ɨ Kon maka demb de nɨbnyɨmɨn. Sɨ onggɨt paemb Kon sam e aen, nokɨm da ɨdenat wɨn gar ke utkunda ke notkasya. Sɨ men b'ogla wowɨn ti pɨlwa!” ");
INSERT INTO gdr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Seg Toma ogenaya da Didimo ket ti b'auyaena rɨgamadwar amninonj da, “Sɨ meda kwa wowɨn. Sɨ ɨdenat men uj taukindam mera Yonggyam kɨma.” ");
INSERT INTO gdr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ɨ re Yesu opendonj Betaniya tungg wa, Ton ket wumɨr yokatonj da Lajaro re kea powa (4) bibɨr kɨma na gɨmo yɨund oski gopmetɨnd yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betaniya tungg re ma pɨn na yɨbnonj Yerusalem taun ke, b'ogla ama rɨka nowa kilomita pɨn na. ");
INSERT INTO gdr_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ɨ jogjog Ju rɨgap Marta ake Mariya adareno towa kɨmɨr Lajarom uj gatab omanam. ");
INSERT INTO gdr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ɨ re Marta utkundonj da Yesu ke ik, sɨ ton ket met ke yiwatonj Yesund wɨpwɨp omnam. Ajɨ Mariya re adea met wa wɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Sɨ Marta Yesund yomnonj da, “Yonggyam! Rako Man dɨkɨnd mɨbnot, kor kɨmɨr ma rako uj awonj. ");
INSERT INTO gdr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ajɨ yu kon kwa wumɨr en da ra Man Godɨnd erkisɨt, God ɨta mɨra Mor motkau.” ");
INSERT INTO gdr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Sɨ Yesu ket tin womnonj da, “Mor kɨmɨr ɨta tutnyis.” ");
INSERT INTO gdr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ɨ Marta daka ket Tin yɨsmonggawonj da, “Kon wumɨr en da ton ɨta tutnyis dem utnyita wɨnɨnd kikitum bibɨrɨnd.” ");
INSERT INTO gdr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Sɨ Yesu ket tin mɨra womnonj da, “Konten onggɨtyam utnyita dɨde yɨrkokar. Yet ra Ken gar ke utkunda ke notkas, nangga ma jɨ rada ton ke uj yokas, ton ɨta yilo tainy. ");
INSERT INTO gdr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ɨ rɨga yet ra yilo ɨbɨm ɨ ra gar ke utkunda ke Ken notkas, ton makwa ngai ɨta uj okas dadal ngɨrpu kesa. Sɨ ke man onggɨtyam yɨtkak gar ke utkunda ke yokasɨt?” ");
INSERT INTO gdr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ɨ ton ket Yesund mɨra yomnonj da, “Owɨ, Yonggyam! Kon kea gar ke utkunda ke mokasɨn da Man re Godɨmna B'ɨga Kerisotet, yet re ikonj onggɨt gowukoi wa.” ");
INSERT INTO gdr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ɨ onggɨt yɨt opurena kak ke, Marta yiwatonj met wa dɨde ket ti wundoi Mariyand musɨk yɨt wɨgiyawonj da, “Ouyaena rɨga ke ik, ɨ men mɨngawɨk.” ");
INSERT INTO gdr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ɨ re Mariya onggɨtyam yɨt utkundonj, ton wanakana onyitonj ɨ ket Yesum pɨlwa wikonj. ");
INSERT INTO gdr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Sɨ Yesu re maka tungg wa menon yokatonj, ajɨ Ton adea de onggɨt pɨpmetɨnd yɨbnonj rɨkɨnd re Marta Tin wɨpwɨp yomnonj. ");
INSERT INTO gdr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ɨ re Mariya wanakana utnantonj dɨde met ke yiwatonj, sɨ Ju rɨga rɨna re ton kɨma wekenonj metɨnd dɨde ti pɨlwa omanam wuwenonj, ton kea tin yɨr wongo. Ɨ ton ket tin yɨmta wundoko odede nony kɨma da ton gopmet wa e wik demb de yii iyagɨkam. ");
INSERT INTO gdr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ɨ re Mariya opendonj rɨkɨnd re Yesu yɨbnonj, ton Yesumna pɨs wɨpɨnd eobankonj. Ɨ ton ket Yesund yomnonj da, “Yonggyam! Rako Man dɨkɨnd mɨbnot, kor kɨmɨr ma rako uj awonj.” ");
INSERT INTO gdr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ɨ Mariya kea yii b'ɨrɨnenonj dɨde Ju rɨga yepiya re ton kɨma tuwonj, toda kwa yii b'ɨrɨnento. Sɨ re Yesu ten yɨr anginonj yii b'ɨrɨnenand, Ton onggɨtyam towaina yii b'ɨrɨnena map ma sobijog na gar soro awonj dɨde Ton ket nony bebɨg awonj. ");
INSERT INTO gdr_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Sɨ Yesu ten amninonj da, “Rokate tin yoramitonda?” Ɨ ton ket mɨra yomno da, “Yonggyam! Sɨ wuyɨn ɨ Man ɨta yɨr onget.” ");
INSERT INTO gdr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Sɨ Yesu ket yɨrekɨp yikenonj. ");
INSERT INTO gdr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Sɨ onggɨt penaemb Ju rɨgap endento da, “Wɨi, yɨr de. Ma Ton ma sobijog na tin singi yiyenonj?” ");
INSERT INTO gdr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ɨ kwa towa wɨngɨrɨnd nɨnda rɨgap endento da, “Onggɨt rɨgat kea yɨrdɨdɨ rɨga ma yɨrkɨp epangendonj. Sɨ nangga pena Ton maka yogokonj tin uj okatam?” ");
INSERT INTO gdr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ɨ re Yesu onggɨtyam yɨt utkundonj, Ton b'usaya gar soro aukonj dɨde ket onggɨt gar soro kɨma gopmet wa yikonj. Ɨ gopmet re dorɨnd eski na yɨbnonj ukoi gong bora pɨla dɨde ukoi gɨmo ke mora utwangki na yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Seg ket Yesu rɨga amninonj da, “Gɨmo ɨtemb mora ke yururkita!” Ajɨ onggɨtyam uj rɨga ma ngɨmɨr Marta Tin yomnonj da, “Yonggyam! Ton kea powa (4) bibɨr kɨma e yɨbɨm. Sɨ ke kuka e yikeny.” ");
INSERT INTO gdr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Sɨ Yesu tin womnonj da, “Ma Kon ke pop wumɨr momnyɨn da ra man gar ke utkunda oramisɨt, man ɨta yɨr onget Godɨmna b'ogɨl ɨnyomarena?” ");
INSERT INTO gdr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Seg ton ket gɨmo yururkito. Ɨ ket Yesu yɨr pumb wa awonj dɨde ket yindonj da, “Abu! Kon sɨteket yɨt momnyɨn nokɨp kea Man Ken nutkunjɨt. ");
INSERT INTO gdr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kon wumɨr na da Man ita wɨn nate Ken nutkundenyɨt. Ajɨ Kon onggɨtyam yɨt nindenyɨn re onggɨt rɨga bobo mapae yepim re owɨnki wekeny dɨkɨnd. Nokɨm da ɨdenat ton gar ke utkunda oramisi da Manɨt Ken nɨtmɨkitot.” ");
INSERT INTO gdr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ɨ onggɨt yɨt opurena seg ke Yesu unena kɨma ara yikenonj da, “Lajaro! Bau wa opende!” ");
INSERT INTO gdr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Sɨ re uj rɨga bau wa opendonj, tina pɨs dɨde yɨm re kobɨrgɨm ɨsetɨki ke ɨjobɨki na dɨde kwa tina wɨp re kobɨrgɨm kɨb ke ɨjobɨki na wekenonj. Sɨ Yesu ket ten amninonj da, “Kobɨrgɨm yotogɨka! Ɨ ti nya yɨspawa menonɨm!” ");
INSERT INTO gdr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sɨ opimemb Ju rɨga yepiya re wuwenonj Mariyam pɨlwa, ton kea mɨle yɨr angto rɨna re Yesu amnɨkinonj. Sɨ towa wɨngɨrɨnd jogjog rɨgap kea Yesund gar ke utkunda ke yokato. ");
INSERT INTO gdr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ajɨ towa wɨngɨrɨnd nɨndapiya yiwato Parisai rɨga wa pɨlwa, ɨ ket ten wumɨr amnɨto nangga na Yesu amnɨkinonj. ");
INSERT INTO gdr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Sɨ onggɨt penaemb yɨna mopyam sɨ rɨgap dɨde Parisai rɨgap Ju rɨga waina Sanedrin kot b'eoma ara yemoko. Ɨ ton ket b'arkitto da, “Onggɨt Rɨgat kea jogjog im kɨd kesa kɨma danda wɨko amnɨkiny. Sɨ nangga e men Ti gatab omnɨku? ");
INSERT INTO gdr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ra men Tin nony ojwasu odede wɨko omnɨkand, komkesa rɨgap opima Tin gar ke utkunda ke okasi dɨde ket Tin yɨmta undoki. Ɨ ɨngkaim ket Roma mopyam rɨgap towaina geja rɨga kɨma tui dem ɨ ket meraina yɨnamet eomnenyi dem dɨde kwa meraina Ju yɨtam rɨga teomnenanj dem.” ");
INSERT INTO gdr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ɨ towa wɨngɨrɨnd yɨpa rɨga Kayapa yet re yɨna mopyam sɨ rɨga yɨbnonj onggɨt kemagɨnd, ton ten amninonj da, “Wɨn makwa wumɨr im wekenyɨt. ");
INSERT INTO gdr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Sɨ wɨn ma wumɨr im b'ogɨl nya orakam onggɨtyam bebɨg awɨr omnam. Sɨ ɨtemb re b'ogɨljog e wanɨm da yɨpa rɨgat uj okas komkesa meraina Ju rɨga map dɨde ɨdenat kwa meraina kupka yɨtam rɨga maka b'eteomnenanj.” ");
INSERT INTO gdr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Sɨ ton onggɨtyam yɨtkak yopulitonj re ma tinajog nony kena. Ajɨ ton onggɨt kemagɨnd yɨna mopyam sɨ rɨga na yɨbnonj, sɨ ton bage yɨt na yindonj da, “Yesu ɨta uj okas Ju yɨtam rɨga map. ");
INSERT INTO gdr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ɨ ma Ju yɨtam rɨga nena mapae, ajɨ kwa onggɨt mapae da Ton yɨpand teomkuriny Godɨmna b'ɨga yepim re Tina obagɨki kesa rɨga wetaweta auki wekeny b'enga kantri nata.” ");
INSERT INTO gdr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Sɨ onggɨt bibɨr natemb ton yɨsamko Yesund ongandam. ");
INSERT INTO gdr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Sɨ onggɨt penaemb Yesu maka pɨtakɨpɨnd yikenonj Ju rɨga wa wɨngɨrɨnd. Ajɨ Ton ɨngkenaemb ket yiwatonj onggɨt taun wa ogenaya da Epraim. Ɨ Ton ket ademb de yɨbnonj Tina b'auyaena rɨga kɨma. Sɨ ɨtemb eriya re wul kesa tungg wus nat yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ɨ Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam Wɨn wus wa na auka ikonj. Sɨ yɨmta kena onggɨtyam diyamdiyam wɨn awonj, ajɨ nɨnda eriya ke jogjog rɨga kea naska nata wuwenonj Yerusalem taun wa towanɨm ɨseka mɨle omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Sɨ ton Yesund oraka yiyeno ɨ ket yɨnamet aband owɨnki b'arkena wuwenonj towa wɨngɨrɨnd da, “Wɨn rɨja im nony aindam? Ɨta Ton ik onggɨtyam diyamdiyam wɨn okatam?” ");
INSERT INTO gdr_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ajɨ yɨna mopyam sɨ rɨgap dɨde Parisai rɨgap kea odede b'ingawa yɨt yoramito da yet ra wumɨr okas da ɨndama Yesu dɨkɨnd yɨbɨm, ton b'ogla ten wumɨr tamniny Tin yɨmɨnd usunatam. ");
INSERT INTO gdr_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ɨ re siks (6) bibɨr komb aukɨto Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam Wɨn awowɨm, Yesu kea Betaniya tungg wa opendonj. Ɨ Lajaro yena re Yesu uj ke yutnyitonj, ton ademb de onggɨt Betaniya tunggɨnd yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ɨ demb de onggɨt tunggɨnd nɨnda rɨgap kea Yesund ɨngaukam owou yongonjeno diyamdiyamɨm. Sɨ Marta re owou na yingg eyeninonj. Ɨ Yesu nɨnda rɨga kɨma na owoupund omiti yɨbnonj, ɨ Lajaro re kea de onggɨt rɨga wɨngɨrɨnd yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ɨ Mariya ukoi mɨra kɨma kɨlkesa ngɨrangngɨrang gaya ogenaya da nad yokatonj ama rɨka yɨpa lita na. Ɨ ton ket Yesumna pɨsɨnd yɨgmarkonj dɨde ket tina mopngɨi ke Yesumna pɨs esekonj. Sɨ met re kea onggɨt b'ogɨl gaya ngɨrangɨt yɨwɨnatonj. ");
INSERT INTO gdr_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ajɨ Tina b'auyaena rɨga wɨngɨrɨnd yɨpa rɨga, Yudas Iskariyot yet ra Tin tɨb yii dem, ton yindonj da, ");
INSERT INTO gdr_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Rako man onggɨtyam ngɨrangngɨrang gaya yosogot, man keako akasinot wan tausɨn eit andred (1,800) Kina dɨde ket agoninot gasa kesa rɨga wa. Sɨ nangga pena man maka odede yomnɨkot?” ");
INSERT INTO gdr_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ɨ ton odede yindonj re ma onggɨt manaemb jɨ da gasa kesa rɨga yɨm okawam. Ajɨ nok mana da ton re yurowamam na yɨbnonj. Sɨ ton re rɨgaina oramki wulkɨp yɨr ɨpka rɨga na yɨbnonj, ɨ ton kea onggɨtyam wulkɨp wɨngɨrɨnd nɨnda tinɨm emdeneninonj. ");
INSERT INTO gdr_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Sɨ Yesu ket tin yomnonj da, “Tin wɨrare! Sɨ ton onggɨtyam mɨle yomnɨk re Kornɨm naskanaska eungita mɨle omnɨka ma. ");
INSERT INTO gdr_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Sɨ gasa kesa rɨga opima wɨn kɨma wekeneny ita wɨnɨnd, ajɨ Kon ma ɨta ita wɨnɨnd wɨn kɨma nɨtɨbnenenyɨn.” ");
INSERT INTO gdr_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ɨ re ukoi Ju rɨga bobop wumɨr yokato da Yesu adea de onggɨt metɨnd yɨbnonj, ton kea Yesum pɨlwa wuwenonj. Ɨ ton ma Yesu nena na yɨr ongongɨm yopeno, ajɨ tida kwa Lajarond yɨr ongongɨm yena re Yesu uj ke yutnyitonj. ");
INSERT INTO gdr_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Sɨ ket yɨna mopyam sɨ rɨgap kea Lajarond tida kwa yɨsamko ongandam. ");
INSERT INTO gdr_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Mop nokɨp Lajaro map jogjog Ju rɨga Yesum pɨlwa wuwenonj dɨde ket gar ke utkunda ke Tin yokato. ");
INSERT INTO gdr_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ɨ ɨspari ke ukoi rɨga bobo yepiya re onggɨtyam diyamdiyam wɨn okatam wuwenonj Yerusalem taun wa, ton kea utkundento da Yesu ke nya nate ik Yerusalem taun wa. ");
INSERT INTO gdr_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Sɨ ton ket apɨg kɨma opekto Yesund simesime omnam. Ɨ ket auwam kɨma aento da, “Osanna! Ɨta God ma b'ogɨl Man kɨma yete re Yonggyamɨmna nyɨ kɨma ik, ɨte re Israel rɨga wa king.” ");
INSERT INTO gdr_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ɨ re Yesu yɨpa dongki b'ɨga yodaronj, Ton kea angitonj onggɨtyam dongki b'ɨga kumbɨnd. Sɨ onggɨt gatab re yɨna peband ɨja emb jɨ ɨrɨki yɨbɨm da, ");
INSERT INTO gdr_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Goro moga Siyon ngɨmngai! Yɨr de, moina king ɨte ik omiti dongki b'ɨga kumbɨnd.” ");
INSERT INTO gdr_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Naskand Yesu ma b'auyaena rɨga maka nony aukɨto onggɨt gatab. Ajɨ yɨmta kena re Yesu uj ke utnyitonj dɨde ket b'ogɨl ɨnyomarena yokatonj, ton kea nonyɨk b'amdɨto da onggɨtyam yɨtkak ɨrɨki wekeny re Ti gatab im, sɨ onggɨt penaemb rɨgap odede mɨle amnɨkto Ti pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ɨ onggɨt wɨnɨnd re Yesu Lajarond ara yemokonj gɨmo yɨund oski gopmet bau ke dɨde ket tin uj ke yutnyitonj, rɨga bobo re kea Yesu kɨma wekenonj. Sɨ onggɨt rɨga bobopiya Lajarom gatab yɨr ungata yɨt usenena yiyeno. ");
INSERT INTO gdr_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Sɨ onggɨt mop penaemb rɨga bobop Yesund simesime omnam yopo nokɨp ton kea utkundeno onggɨtyam kɨd kesa kɨma danda wɨko gatab rɨna re Ton yomnɨkonj. ");
INSERT INTO gdr_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Sɨ onggɨt penaemb Parisai rɨgap towa wɨngɨrɨnd endento da, “Yɨr de, komkesa onggɨt gowukoi rɨgap re kea Tin yɨmta yundoki. Sɨ mera awɨr e kwa nangga e omnɨkam awɨk.” ");
INSERT INTO gdr_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ɨ re rɨga tuwonj Yerusalem taun wa Godɨnd ewangayam onggɨtyam diyamdiyam wɨnɨnd, sɨ nɨnda Grik rɨga toda kwa kea de wekenonj onggɨt rɨga wa wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ɨ opimemb Grik rɨga tuwonj Betsaida tunggam Pilipɨm pɨlwa yet re ikonj Galili eriya ke. Ɨ ket ton tin yɨgekito da, “Sowa rɨga! Sɨn singi im Yesund yɨr ongongɨm.” ");
INSERT INTO gdr_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ngɨrpu ket Pilip yikonj Andream pɨlwa dɨde tin wumɨr yomnonj. Seg ket Andrea ake Pilip ekonda Yesum pɨlwa dɨde ket Tin wumɨr yomnonda. ");
INSERT INTO gdr_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Sɨ Yesu ten ket esmonggawonj da, “Ɨtemb ke wɨn ik Rɨgamna B'ɨga b'ogɨl ɨnyomarena okatam. ");
INSERT INTO gdr_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kon ɨmɨnjogjog wen tamninyɨn. Ra yɨpa kɨnɨ tuny maka tɨsenj gou wa dɨde ra maka uj tainy, ɨtemb tuny re tinta e ɨbɨm. Ajɨ ra ɨtemb tuny uj tainy, ton jogjog kɨp im tejagɨkiny. ");
INSERT INTO gdr_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ɨ yet ra tina yɨrkokar singi iyeny, ton ɨta onggɨtyam tina yɨrkokar edamkis dem. Ajɨ yet ra tina yɨrkokar singi kesa omɨny onggɨt gowukoyɨnd, ton ɨta onggɨtyam tina yɨrkokar yɨrgong omnɨkeneny dadal ngɨrpu kesa yɨrkokar wa. ");
INSERT INTO gdr_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ɨ yet ra Kornɨm wɨko omnɨka iyeny, ton b'ogla Ken yɨmta nundok. Sɨ rokate ra Kon nɨtɨbnyɨn dɨkɨnd, toda ɨndama onggɨtyam wɨko rɨga ɨbɨm Kon kɨma. Sɨ yet ra Kornɨm wɨko omnɨka iyeny, Kor B'u ɨta tin ɨsnaeneny. ");
INSERT INTO gdr_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Otade Kon kɨd e b'ɨpokenyɨn, sɨ nangga e Kon nitinjɨn? Abu! Be onggɨtyam wɨn ke Ken nɨtrɨngate! Nayɨ, Kon onggɨt mop penaemb netkond ɨtemb wɨn okatam. ");
INSERT INTO gdr_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Abu! Man Moina nyɨwɨm pɨlɨnd b'ogɨl ɨnyomarena yoramitene!” Ɨ onggɨt yɨt seg ke ket wub kumb ke yɨtpɨam ikonj da, “Kon kea b'ogɨl ɨnyomarena yoramitenyɨn, ɨ Kon ɨta b'usaya oramitenenyɨn.” ");
INSERT INTO gdr_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ɨ re rɨga bobop owɨnki onggɨtyam yɨtpɨam utkundo, ton endento da, “Ɨara e ara yikeny.” Ɨ kwa nɨndap da, “Anerute Tin yɨtnono yomneny.” ");
INSERT INTO gdr_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Sɨ Yesu yindonj da, “Onggɨtyam yɨtpɨam re ma Kor mana awɨk ajɨ wanɨm b'ogɨl mana. ");
INSERT INTO gdr_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Sɨ yu ɨte re onggɨt gowukoyɨm b'ɨsagɨka wɨn e. Sɨ yu Godte onggɨt gowukoyɨmna wɨp iyoi rɨga, Satanand b'ɨtɨskanjis bau wa. ");
INSERT INTO gdr_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ɨ ra Kon gou ke b'uturowasɨn, Kon ɨta komkesa rɨga Kor pɨlwa tugungasinyɨn dem.” ");
INSERT INTO gdr_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Sɨ Yesu onggɨtyam yɨt yindonj re ouyawa mana da rɨdede wɨp nya kae Ton uj okas dem. ");
INSERT INTO gdr_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Sɨ rɨga bobop Ton yɨgekito da, “Sɨn gog yɨt ke utkundenyu da, ‘Keriso ra dadal ngɨrpu kesa e ɨbneneny.’ Sɨ nangga pae Man mindenyɨt da Rɨgamna B'ɨgat b'ogla b'uturowas? Sɨ yetemb jɨ onggɨtyam Rɨgamna B'ɨga?” ");
INSERT INTO gdr_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Seg Yesu ket ten esmonggainonj da, “Ɨ ma pɨn e ngaya ɨbɨm wa wɨngɨrɨnd. Sɨ wɨn b'amana wuwene onggɨt ngaya pɨta wɨnɨnd. Nokɨm da ɨdenat sɨbɨbɨt maka wen tekangɨnjiny. Sɨ yet ra sɨbɨbɨnd menon okas, ton ma wumɨr e rɨtama ton yik. ");
INSERT INTO gdr_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Sɨ onggɨt ngaya pɨta nat wɨn gar ke utkunda yoramita onggɨt ngayam pɨlɨnd, nokɨm da ɨdenat wɨn ngayamna b'ɨga taukindam.” Ɨ re Yesu onggɨtyam yɨt opurena seg awonj, Ton towa pɨlke yiwatonj egitam. ");
INSERT INTO gdr_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ɨ Yesu kea onggɨtyam komkesa kɨd kesa kɨma danda wɨko amnɨkeninonj rɨga wa wɨpɨnd. Ajɨ ton maka Tin gar ke utkunda ke yokato. ");
INSERT INTO gdr_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nokɨm da ɨdenat bageyam Isayamna onggɨtyam yɨtkak rɨrɨrkɨp tainy. Sɨ ton odede na yindonj da, “Yonggyam! Yet sowaina bage yɨtɨm pɨlɨnd gar ke utkunda yoramis? Ɨ kwa ke ya pɨlnat Yonggyamɨmna danda yɨm pɨta ainy?” ");
INSERT INTO gdr_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ɨ onggɨt mop penaemb ton maka rɨrɨr aukɨto gar ke utkundam, nokɨp Isaya b'usaya odede kwa yindonj da, ");
INSERT INTO gdr_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“God kea towaina yɨrkɨp yɨrdɨdɨ amnɨkinonj, ɨ towaina gar edokinonj. Nokɨm da ke ton yɨr ongong reyeninem towaina yɨrkɨp ke, ɨ ke ton towaina gar ke repɨndeninem dɨde ket ke ton rengenjinem Kor pɨlwa, ɨ dɨde ket ke Kon ten resakenjinɨn.” ");
INSERT INTO gdr_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Sɨ onggɨt mop penaemb Isaya onggɨtyam yɨt yindonj nokɨp ton kea Yesumna b'ogɨl ɨnyomarena yɨr yongonj, sɨ ton Ti gatab na wumɨr amninonj. ");
INSERT INTO gdr_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Sɨ Ju rɨga waina memba wɨngɨrɨnd jogjog rɨga toda kwa kea Yesund gar ke utkunda ke yokato. Ajɨ ton maka towaina gar ke utkunda gatab pɨtapɨta amnento Parisai rɨga map. Nokɨp ton onggɨtyam gatab moga na auto da Parisai rɨgap ke towaina yɨr opmitenapu met ke ten reaukeninem. ");
INSERT INTO gdr_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Mop nokɨp opimemb memba ukoijog singi aento re rɨga wa pɨlke esourena okata mana ajɨ ton ma ukoi singi na aento Godɨmna b'ogɨl ɨnyomarena okatam. ");
INSERT INTO gdr_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Sɨ Yesu ket unena kɨma yindenonj da, “Yet ra gar ke utkunda ke Ken notkas, ton ma Kena gar ke utkunda ke notkas ajɨ Tina yet re Ken nɨtmɨkitonj. ");
INSERT INTO gdr_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ɨ yet ra Ken yɨr notɨng, ton kea Tin yɨr yong yet re Ken nɨtmɨkitonj. ");
INSERT INTO gdr_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ɨ Kon onggɨt gowukoi wa netkond re ngaya na. Nokɨm da ɨdenat komkesa rɨga maka sɨbɨbɨnd tekeny yepim re gar ke utkunda ke Ken nokasi. ");
INSERT INTO gdr_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ɨ nangga ma jɨ rada yɨpa rɨga maka Koina opureni yɨtkak tutkundeneniny dɨde maka tawameneniny, Kon ma ɨta tin b'ɨsagɨkam omnyɨn. Nokɨp Kon ma nok mana netkond da Kon gowukoi rɨga tesagɨkinyɨn, ajɨ nok mana da gowukoi rɨga wa yɨrkokar takainyɨn. ");
INSERT INTO gdr_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ɨ yet ra Ken nɨtɨsai dɨde maka Koina opureni yɨtkak takasiny, sɨ ɨta jɨ ti b'ɨsagɨkam rɨga. Sɨ onggɨtyam yɨtkaktemb rɨna re Kon apulisinond, tin negɨr ma b'ɨsagɨkam omɨny dem kikitum bibɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mop nokɨp Kon apureninyɨn re ma Kor nony kaim ajɨ Ti pɨlkaim yet re Ken nɨtmɨkitonj. Ton kea Kor b'ingawa yɨt nokawonj nangga im Kon tapureninyɨn ɨ rɨngmim Kon tapureninyɨn. ");
INSERT INTO gdr_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Sɨ Kon wumɨr en da Tina b'ingawa yɨt re dadal ngɨrpu kesa yɨrkokar e. Sɨ onggɨt mop paimemb Kon ɨnsima yɨpa rɨrɨrkɨpjog yɨtkak apureninyɨn rɨngma na re Ken Kor B'u wumɨr nomnonj.” ");
INSERT INTO gdr_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ɨ yɨmta kena Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam Wɨn awonj, ajɨ Yesu kea wumɨr awonj da wɨn re kemb rɨrɨr ainy Tinɨm onggɨtyam gowukoi ɨraram dɨde iwatam Ti B'uɨm pɨlwa. Sɨ Ton Tinajog rɨga na singi eyeninonj yepiya re gowukoyɨnd wekenonj. Ɨ Ton ten kupkakupka singi eyeninonj ngɨrpu de Tina undwatapu wa. ");
INSERT INTO gdr_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ɨ re Yesu dɨde Tina b'auyaena rɨga diyamdiyam auto, Satanat kea Simonɨmna b'ɨga Yudas Iskariyotɨmna gar wa singi yoramitonj Yesund tɨb iyoyɨm. ");
INSERT INTO gdr_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Sɨ Yesu wumɨr na da Ti B'u kea komkesa gasa re Ti yɨm nat aramisinonj. Ɨ Ton nonyɨk b'amdonj da, “Kon Godɨm pɨlkena netkond dɨde kanamb Kon tɨtenjɨn Godɨm pɨlwa.” ");
INSERT INTO gdr_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ɨ Yesu ket onyitonj diyamdiyampu kasa ke dɨde Tina tumɨnd kobɨrgɨm yotogɨkonj. Seg Ton ket tawel yokatonj dɨde ket robmopɨnd b'ibgonj. ");
INSERT INTO gdr_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Seg ket Ton nyɨ yɨgmarkonj besen bora wa, ɨ ket b'atomonj Tina b'auyaena rɨga pɨs ɨsekam dɨde usurenam tawel ke rɨna re Ton robmopɨnd b'ibgi yowamonj. ");
INSERT INTO gdr_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ɨ re ket Simon Petrom pɨlwa yikonj, ton Yesund yomnonj da, “Yonggyam! Ma Man ɨta pɨs nɨtɨseket?” ");
INSERT INTO gdr_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Sɨ Yesu tin yɨsmonggawonj da, “Yu man ma ɨta nony auket nangga e Kon yomnɨken, ajɨ yɨmta kae man nony tauket dem.” ");
INSERT INTO gdr_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ɨ Petro ket Tin yomnonj da, “Man makwa rɨrɨr et koina pɨs ɨsekam.” Ɨ Yesu ket tin mɨra yomnonj da, “Ra maka ra Kon mɨtɨseken, mor awɨr e Kon kɨma b'inkɨndena.” ");
INSERT INTO gdr_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ɨ Simon Petro Tin yomnonj da, “Yonggyam! Goro koina pɨs nena tesekɨm ajɨ bea kwa yɨm ake mop.” ");
INSERT INTO gdr_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Sɨ Yesu tin mɨra yomnonj da, “Gony aureni rɨgat ɨnta pɨs nena b'ɨtɨsek ajɨ ma opima nɨnda kɨpear. Nokɨp tina kupka jɨ re kɨlkesa e. Sɨ wɨn kɨlkesa im ajɨ ma komkesa im.” ");
INSERT INTO gdr_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ɨ nangga mop pena Ton yindonj da, “Ma wɨn komkesa kɨlkesa im,” mop nokɨp Ton wumɨr na da towa wɨngɨrɨnd yɨpa rɨgatemb Tin tɨb yii dem. ");
INSERT INTO gdr_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ɨ re Yesu towaina pɨs ɨseka seg awonj, Ton Tina tumɨnd kobɨrgɨm b'ikitonj dɨde ket b'usaya Tina pɨpmet wa omitonj. Ɨ ket ten amninonj da, “Ke wɨn wumɨr yokasya nangga na Kon wanɨm yomnɨken? ");
INSERT INTO gdr_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Wɨn Ken nogenaya Ouyaena Rɨga kae dɨde Yonggyam kae. Sɨ waina opurena re ɨmɨnjog i. Nokɨp Kon ɨntenemb jɨ Rɨga. ");
INSERT INTO gdr_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kon, ɨte re wa Yonggyam dɨde Ouyaena Rɨga, kea waina pɨs esekinyɨn. Sɨ onggɨt paemb wɨdaka b'ogla walenggyam walenggyam pɨs b'ɨseka tuwenyɨt. ");
INSERT INTO gdr_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kon wɨngata mɨle na wa akainyɨn, nokɨm da ɨdenat wɨdaka kwa odede mɨle omnɨkenenya rɨngma na re Kon wanɨm yomnɨken. ");
INSERT INTO gdr_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kon ɨmɨnjogjog wen tamninyɨn. Wɨko rɨga re ma ukoyam e, ajɨ tina yonggyam re ukoyam e. Ɨ daka yɨdɨr rɨga re ma ukoyam e, ajɨ rɨga yete re tin yɨtmɨkis re ukoyam e. ");
INSERT INTO gdr_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sɨ ra wɨn wumɨr okatenya onggɨtyam gatab dɨde ra wɨn onggɨtyam mɨle tamnɨkindam, wɨn re b'ogɨl omni rɨga im. ");
INSERT INTO gdr_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ɨ Kon ma komkesa wa gatab e nindenyɨn. Sɨ Kon wumɨr en yena re Kon abagɨkinond. Ajɨ onggɨt ma da onggɨt yɨna peba yɨtkak rɨrɨrkɨp rain da, ‘Yet re koina owou yowenenonj, ton kea ken kak nɨawonj.’ ");
INSERT INTO gdr_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Yu Kon naska kana im wen wumɨr amninyɨn gasa rɨnte ra tawɨk Kor pɨlɨnd. Nokɨm da ra ɨtemb gasa pɨta tainy ɨdenat wɨn gar ke utkunda ke notkasya dem da Kon ɨntemb jɨ rɨga. ");
INSERT INTO gdr_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ɨ Kon ɨmɨnjogjog wen tamninyɨn. Yet ra Koina ɨtmɨkiti rɨgand okateny, ton Kena nokateny. Ɨ yet ra Ken notkateny, ton Tina yokateny yet re Ken nɨtmɨkitonj.” ");
INSERT INTO gdr_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ɨ re Yesu onggɨtyam yɨt seg awonj, Ton ma sobijog na kɨd b'ɨpokenonj. Sɨ Ton ket yɨr ungata yɨt yindonj da, “Kon ɨmɨnjogjog wen tamninyɨn. Wa wɨngɨrɨnd yɨpa rɨgat ɨta man Ken tɨb niyɨt dem.” ");
INSERT INTO gdr_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Sɨ Tina b'auyaena rɨgap nonysɨpsɨp na aukɨto da ya gatab e Ton yindeny. Sɨ ton ket yɨrɨk b'unjomkena wuwenonj towa wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ɨ Tina b'auyaena rɨga wɨngɨrɨnd yɨpa rɨga Ti wus kena yɨmkomel b'amki omiti yɨbnonj yena re Ton singi yiyenonj. ");
INSERT INTO gdr_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sɨ Simon Petro onggɨt rɨgand mong ke yomnonj da, “Tin yɨgekite men wumɨr omnam ya gatab e Ton yindeny!” ");
INSERT INTO gdr_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Sɨ ɨtemb rɨga ɨja na Yesumna dorkak wusɨnd b'ɨrmekiti yɨbnonj, ɨ ket Yesund yomnonj da, “Yonggyam! Yetemb jɨ rɨga?” ");
INSERT INTO gdr_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Sɨ Yesu ket mɨra yomnonj da, “Ra Kon onggɨtyam owou pɨkendi ɨsonggen dor dɨde ti okaen, sɨ tontemb jɨ rɨga.” Seg Ton ket owou pɨkendi yɨsonggonj dɨde ket Simonɨmna b'ɨga Yudas Iskariyotɨm yokawonj. ");
INSERT INTO gdr_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ɨ re Yudas onggɨtyam owou pɨkendi yokatonj, sɨ odede natemb ket Satana ti pɨlɨnd b'ɨgaronj. Sɨ onggɨt penaemb Yesu tin yomnonj da, “Man wanakana mɨle yomnɨke rɨnte re man yɨsamket omnɨkam!” ");
INSERT INTO gdr_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ajɨ onggɨtyam owoupund omnɨki rɨga wɨngɨrɨnd makwa ke yɨpa rɨga nony aukonj nangga pena Ton odede yɨt tin yomnonj. ");
INSERT INTO gdr_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Sɨ nɨndap ɨja na nony aukɨto da Yesu nok ma tin yomɨny da, “Man gasa meranɨm temjinyɨt onggɨtyam diyamdiyam wɨnɨnd ingaenam” o mɨnda da, “Nɨnda gasa tagoniny gasa kesa rɨga wa.” Mop nokɨp Yudas re wulkɨp ga owama rɨga na yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Sɨ re ɨtemb rɨga Yudas owou pɨkendi yokatonj, ton odenja ket bau wa opmarkitonj. Sɨ ɨtemb re ket kea sɨwɨny awonj. ");
INSERT INTO gdr_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ɨ re Yudas bau wa opmarkitonj, Yesu yindenonj da, “Otade Rɨgamna B'ɨga kea b'ogɨl ɨnyomarena yokas dɨde God daka kwa kea Ti pɨlke b'ogɨl ɨnyomarena yokas. ");
INSERT INTO gdr_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ɨ rada God kea Ti pɨlke b'ogɨl ɨnyomarena yokas, sɨ God daka kwa ɨta Rɨgamna B'ɨgam Tina b'ogɨl ɨnyomarena okau. Sɨ Ton ɨta odenja Ti okau. ");
INSERT INTO gdr_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kor b'ɨgawar! Kon ma pɨnjog e nɨtɨbnyɨn wɨn kɨma. Ɨ ɨngkaemb ket wɨn Ken oraka nitiyenya dem. Sɨ Kon otade wen wumɨr amninyɨn re odede yɨpa wɨp im rɨja na re Kon Ju rɨga waina mopyam rɨga wumɨr amninond da wɨn ma rɨrɨr im menonɨm de rɨtama ra Kon neken dem. ");
INSERT INTO gdr_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ɨ Kon wa sisɨl b'ingawa yɨt takainyɨn. Wɨn b'ogla singi b'itiyenindam wa wɨngɨrɨnd. Kon kea singi wen eyeninond, sɨ wɨdaka kwa ɨja na singi b'itiyenindam wa wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ra wɨn singi b'itiyenindam wa wɨngɨrɨnd, sɨ ɨdenasimemb komkesa rɨgap wen tangwatenanj da wɨn re Koina b'auyaena rɨga im.” ");
INSERT INTO gdr_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ɨ ket Simon Petro Yesund yɨgekitonj da, “Yonggyam! Rɨtama man meket?” Ɨ Yesu ket yɨsmonggawonj da, “Yu man ma rɨrɨr et Ken yɨmta undokam rɨtama ra Kon neken. Ajɨ yɨmta kae man yɨmta nutundoket dem.” ");
INSERT INTO gdr_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Sɨ Petro kwa Tin yɨgekitonj da, “Yonggyam! Nangga mop pae yu kon maka rɨrɨr taen men yɨmta undokam? Kon Mor mapae koina yɨrkokar b'atkaen.” ");
INSERT INTO gdr_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Seg Yesu ket tin mɨra yomnonj da, “Sɨ ɨta man Kor map moina yɨrkokar b'atkaet? Kon ɨmɨnjogjog men motɨnyɨn. Pauro ma ɨta wanaka ara ikeny dor ngɨrpu ra ket man nowapyam Ken notiyenyɨt. ");
INSERT INTO gdr_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Goro wɨn gar bebɨg taukinam! Wɨn Godɨnd gar ke utkunda ke yokata dɨde Keda kwa gar ke utkunda ke nokata! ");
INSERT INTO gdr_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kor B'uɨmna metɨnd opima jogjog wɨmenapu pɨpmet wekeny. Rako pɨpmet demb de maka wekeny, Kon keako wen wumɨr amninond. Sɨ Kon neken ra wanɨm pɨpmet ongonjena mim. ");
INSERT INTO gdr_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Sɨ ra Kon neken dem dɨde ket wa pɨpmet tangonjenainyɨn, sɨ Kon kwa b'usaya tɨtenjɨn dem. Ɨ Kon ket wen taronsinyɨn dɨde ket eyinyɨn dem Koinajog pɨpmet wa. Sɨ ɨdenat wɨda tekenenyɨt de rokate re Kon nɨbnenenyɨn. ");
INSERT INTO gdr_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ɨ wɨn wumɨr im onggɨtyam nya de onggɨt pɨpmet wa rɨtama ra Kon neken.” ");
INSERT INTO gdr_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Seg Toma ket Yesund yomnonj da, “Yonggyam! Sɨn ma wumɨr im rɨtama man meket. Sɨ rɨdede im sɨn wumɨr taukindam onggɨt nya gatab?” ");
INSERT INTO gdr_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ɨ Yesu ket tin mɨra yomnonj da, “Konta nya ɨ ɨmɨnjog yɨtkak ɨ dɨde yɨrkokar. Sɨ makwa ngai yɨpa rɨgat ɨta yik Kor B'uɨm pɨlwa, ra ton maka Ken yɨmta nutundok. ");
INSERT INTO gdr_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Rada wɨn kea Kornɨm wumɨr aukindam, sɨ wɨn kea Kor B'uɨm daka kwa wumɨr aindam. Sɨ otade im wɨn Tinɨm wumɨr aukindam ɨ wɨn kea Tin yɨr yongenenyɨma.” ");
INSERT INTO gdr_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Seg Pilip daka ket Yesund yomnonj da, “Yonggyam! Bea sɨn B'und nouyaene! Sɨ ɨdenatemb sɨn nony rɨrɨr taindam.” ");
INSERT INTO gdr_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Sɨ Yesu tin mɨra yomnonj da, “Pilip! Kon ma wus na netkɨmɨn wɨn kɨma. Ma man makaya Kornɨm wumɨr yokasɨt? Yet re Ken yɨr ongong nitiyɨm, ton kea Kor B'und yɨr ongong iyɨm. Sɨ rɨdede pae man mindenyɨt da, ‘Bea sɨn B'und nouyaene'? ");
INSERT INTO gdr_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Sɨ ma man ɨtaemb wumɨr aet da Kon re nɨbnyɨn Kor B'uɨm pɨlnate dɨde Kor B'u re yɨbɨm Kor pɨlnate? Onggɨtyam yɨtkak rɨnsim re Kon wanɨm apurenawainyɨn, ma Kor nony kaim opurena eyeninyɨn, ajɨ Kor B'ute yete re Kor pɨlɨnd wɨmena yikeny, Tonte Tina wɨko omnɨka yiyeny. ");
INSERT INTO gdr_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Sɨ man gar ke utkunda ke Ken nokate da Kon re nɨbnyɨn Kor B'uɨm pɨlnate dɨde Kor B'u re yɨbɨm Kor pɨlnate. Ajɨ ra man maka Ken gar ke utkunda ke notkasɨt, man b'ogla onggɨtyam Koina omnɨki kɨd kesa kɨma danda wɨko gar ke utkunda ke takasinyɨt. Ɨ ɨngkaemb man ket Ken gar ke utkunda ke notkasɨt. ");
INSERT INTO gdr_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kon ɨmɨnjogjog wen tamninyɨn. Yet ra Ken gar ke utkunda ke notkas, toda kwa onggɨtyam wɨko im omnɨka teyeniny rɨna re Kon omnɨka teyinond. Ɨ opimemb wɨko re ma ukoi im, ajɨ ton ukoijog wɨko im omnɨka teyeniny. Mop nokɨp Kon neken ra Kor B'uɨm pɨlwa e. ");
INSERT INTO gdr_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ɨ Kon opima onggɨtyam gasa tamnɨkeninyɨn rɨnsim ra wɨn Koina nyɨ kɨma netɨrkenenya. Nokɨm da ɨdenat B'u b'ogɨl ɨnyomarena takasiny B'ɨgam pɨlke. ");
INSERT INTO gdr_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ra wɨn nangga gasa mana Ken netɨrkenya Koina nyɨwɨnd, Kon opima tamnɨkeninyɨn. ");
INSERT INTO gdr_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ɨ ra wɨn Ken singi nitiyenya, sɨ wɨn b'ogla Koina b'ingawa yɨt yɨmta undoka teyenindam. ");
INSERT INTO gdr_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kon ɨta Kor B'und ɨgekisɨn, sɨ Ton wa tetmɨkitau yɨpa yɨr ɨpka dɨde ouyaena rɨga. Ɨ Ton ket ɨta wɨn kɨma dadal ngɨrpu kesa ɨbneneny. ");
INSERT INTO gdr_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ton re ɨmɨnjog yɨtkakɨmna Wɨngawɨnga e. Ɨ gowukoi rɨgap ma rɨrɨr im Tin okatam, mop nokɨp ton makaya Tin yɨr yongi dɨde makaya Tinɨm wumɨr yokasi. Ajɨ wɨn Tinɨm wumɨr im nokɨp Ton wɨn kɨma e yɨbɨm dɨde Ton wa pɨlnate ɨbneneny. ");
INSERT INTO gdr_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Kon ma ɨta wen terarinyɨn ngungum b'ɨga pɨla, ajɨ ɨta wa pɨlwa netken dem. ");
INSERT INTO gdr_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ɨ sobijog wɨn kak ke gowukoi rɨgap ma ɨta yɨr notngi dem. Ajɨ wɨn ɨta yɨr notngya dem, nokɨp Kon yilo e nɨbnyɨn dɨde wɨdaka kwa yilo im tekenyɨt. ");
INSERT INTO gdr_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sɨ wɨn onggɨt bibɨr nasimemb nonyɨk b'atɨmjindam dem da Kon re nɨbnyɨn Kor B'uɨm pɨlnate, ɨ wɨn re wekenyɨt Kor pɨlnasim, ɨ Kodaka re nɨbnyɨn wa pɨlnate. ");
INSERT INTO gdr_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yet ra Koina b'ingawa yɨtkak tawaminy dɨde ra opimemb yɨtkak yɨmta tundokiny, sɨ onggɨt rɨgatemb Ken singi niyeny. Ɨ kwa yet ra Ken singi nitiyeny, Kor B'u ɨta tin singi iyeny. Ɨ Koda kwa tin ɨta singi iyenyɨn dɨde ket Kon Kolenggyam ɨta tinɨm pɨtapɨta taenenenyɨn.” ");
INSERT INTO gdr_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Seg ket Yudas, goro Yudas Iskariyot, ton Yesund yɨgekitonj da, “Yonggyam! Man kea sowa pɨlwa pɨtapɨta aenyɨt. Ajɨ nangga pae maka gowukoi rɨga wanɨm pɨtapɨta taenyɨt?” ");
INSERT INTO gdr_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Sɨ Yesu ket tin yɨsmonggawonj da, “Yet ra Ken singi nitiyeny, ton ɨta Koina yɨtkak yɨmta tundokiny. Ɨ Kor B'u daka ɨta tin singi iyeny. Ɨ dɨde Sɨn opima ti pɨlwa wuyɨn dɨde ket wɨmenapu pɨpmet omgu ti pɨlɨnd yɨpand wɨmenam. ");
INSERT INTO gdr_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yet ra maka singi nitiyeny, ton ma ɨta Koina yɨtkak yɨmta tundokiny. Sɨ onggɨtyam yɨtkak rɨnsim re wɨn utkundenindam re ma Koina im ajɨ Kor B'uɨmna im yet re Ken nɨtmɨkitonj. ");
INSERT INTO gdr_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Sɨ onggɨt ganggand re Kon wɨn kɨma nɨbnenenyɨmɨn ngɨrpu yu, Kon kea onggɨtyam komkesa yɨtkak gatab wen amneninyɨmɨn. ");
INSERT INTO gdr_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ɨ onggɨt yɨr ɨpka dɨde ouyaena rɨga re Yɨnayɨna Wɨngawɨngate. Ɨ Kor B'u ɨta ɨtmɨkis dem Kor nyɨ kɨma. Sɨ Tonsim komkesa gasa gatab wen tauyaeniny dem dɨde wen nonony tamneniny dem komkesa yɨtkak gatab rɨna re Kon wen amneninond. ");
INSERT INTO gdr_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ɨ Kon ngɨmbla ɨraren re wanɨm ma. Sɨ Kon ɨta Koina ngɨmbla wa takainyɨn. Onggɨtyam ngɨmbla rɨnte ra Kon takainyɨn re ma ɨja e rɨngma re gowukoyɨt agoneniny. Sɨ wɨn goro gar bebɨg dɨde moga tainindam. ");
INSERT INTO gdr_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ɨ wɨn kea utkundenya onggɨtyam yɨtkak rɨna re Kon nindenyɨn da Kon ɨta neken dɨde ket tɨtenjɨn wa pɨlwa. Sɨ rada wɨn Ken singi e niyenya, wɨn sam im taindam Koina menon gatab de Kor B'uɨm pɨlwa. Mop nokɨp Kon re ma ukoi en ajɨ Kor B'u re ukoijog e. ");
INSERT INTO gdr_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ɨ yu Kon naska kana im wen onggɨtyam gasa gatab wumɨr amninyɨn rɨnsim ra taukanj. Nokɨm da ra ton pɨta taukanj ɨdenat wɨn gar ke utkunda ke Ken notkasya. ");
INSERT INTO gdr_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ɨ Kon ma pɨn e wɨn kɨma yɨtnono taenyɨn nokɨp gowukoyɨmna wɨp iyoi rɨga Satana re kemb ɨtemb ke ik. Ajɨ ti awɨr e kwa danda ingawam Kor pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ajɨ Kon nok ma singi da gowukoi rɨga wumɨr rainem da Kon ɨta Kor B'und singi yiyenyɨn dɨde Kon ɨnsima gasa amnɨkeninyɨn rɨngma na re Kor B'u Ken ningawonj. Utnɨkinam ɨngkek, ɨ ka wuyɨn! ");
INSERT INTO gdr_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Kon re ɨmɨnjog greip kai en, ɨ Kor B'u re wala rɨga e. ");
INSERT INTO gdr_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Komkesa bɨa rɨnsim re Kor pɨlɨnd wekeny, ra ton maka kɨp tejagɨkanj, Kor B'u opima onggɨtyam bɨa awɨr omnɨkam tepkiny. Ɨ kwa komkesa bɨa rɨnsim re kɨp kɨma wekeny, Kor B'u opima nɨnda negɨr pip ɨpka teyeniny kɨlkesa omnam, nokɨm da ɨdenat ton jogjog kɨp tejagɨkiny. ");
INSERT INTO gdr_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Sɨ wɨn re kea kɨlkesa omni im onggɨtyam yɨtkak ke rɨna re Kon wen amneninond. ");
INSERT INTO gdr_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Wɨn b'ogla wɨmena tuwenyɨt Kor pɨlɨnd, ɨ Kodaka kwa ɨta wa pɨlɨnd wɨmena netkenyɨn. Sɨ yɨpa bɨat maka ra greip kayɨnd wɨmena ikeny, ton ma rɨrɨr e tilenggyam kɨp tejagɨkiny. Toda yɨpa wɨp e ra wɨn maka ra Kor pɨlɨnd tekenyɨt, wɨn ma rɨrɨr im kɨp ɨjagɨkam. ");
INSERT INTO gdr_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Sɨ Kon re greip kai en, ɨ wɨn re bɨa im. Yet ra Kor pɨlɨnd wɨmena ikeny, Kodaka kwa ɨta ti pɨlɨnd wɨmena netkenyɨn. Sɨ ton ɨngkaimemb jogjog kɨp tejagɨkiny. Mop nokɨp man makwa ngai rɨrɨr et Kor kesa ke nanggamog wɨko omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ɨ yet ra maka Kor pɨlɨnd wɨmena ikeny, ton ɨja e wɨp ɨt re sopapu bau wa b'ɨskoki bɨa re dɨde. Sɨ ra ɨrna seg sopapu wɨko rɨgat ket bobo tamnɨkiny dɨde wul wa b'ɨtɨskokiny ɨ dɨde ket tembrɨkiny. ");
INSERT INTO gdr_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ɨ ra wɨn Kor pɨlɨnd wɨmena tuwenyɨt, dɨde ra Koina yɨtkak wa pɨlɨnd tekeny, sɨ ra wɨn nangga singi mana Ken nɨtgekisya, wɨn ɨta okasya. ");
INSERT INTO gdr_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ɨ ra wɨn jogjog kɨp tejagɨkindam dɨde Koina b'auyaena rɨga taukindam, sɨ ɨngkaemb wɨn Kor B'und b'ogɨl ɨnyomarena okaenya. ");
INSERT INTO gdr_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ɨ Koda kwa ɨja ima wen singi eyeninyɨn rɨja e re Kor B'u Ken singi niyeny. Sɨ wɨn b'ogla Koina singi b'iyena mɨlend tuwenyɨt. ");
INSERT INTO gdr_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kon kea Kor B'u ma b'ingawa yɨt yɨmta undoka eyeninond, sɨ ɨngkenaemb Kon Tina singi b'iyena mɨlend wɨmena nekenond. Sɨ wɨdaka ɨja na kwa Koina b'ingawa yɨt yɨmta tundokindam Kon re dɨde, sɨ ɨngkaimemb wɨdaka Koina singi b'iyena mɨlend wɨmena tuwenyɨt. ");
INSERT INTO gdr_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Sɨ onggɨt mop penaemb Kon onggɨtyam yɨt ke wen amninyɨn da ɨdenat Koina sam waina garɨnd ɨbɨm dɨde ɨngkaimemb kwa Kon onggɨtyam waina sam yɨndangɨr tamnɨkinyɨn. ");
INSERT INTO gdr_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ɨtemb jɨ Koina b'ingawa yɨt da wɨn b'ogla wa wɨngɨrɨnd singi b'itiyenindam rɨja im re Kon wen singi eyeninyɨn. ");
INSERT INTO gdr_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Awɨr e kwa yama ukoijog singi b'iyena mɨle yɨbnau, ajɨ ɨnta ra ton tina yɨrkokar b'atkau tina rɨgawar map. ");
INSERT INTO gdr_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Sɨ ra wɨn Koina b'ingawa yɨt yɨmta tundokindam, wɨn re kea Kor rɨgawar im. ");
INSERT INTO gdr_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sɨ Kon ma ɨta ket wen wɨko rɨga ke nyɨ tagenainyɨn, nokɨp wɨko rɨga ma wumɨr e nangga im ti yonggyam amnɨkiny. Ajɨ Kon wen nyɨ agenainyɨn re Kor rɨgawar kaim, mop nokɨp Kon kea wen komkesa gasa wumɨr amnɨkinond rɨna re Kon Kor B'uɨm pɨlke utkundenond. ");
INSERT INTO gdr_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Wɨn maka Ken nobagendonda, ajɨ Konɨt wen abagɨkinond, dɨde nyɨ akainond. Nokɨm da ɨdenat wɨn tuwenyɨt ɨ kɨp tejagɨkindam ɨ dɨde onggɨtyam waina kɨp ɨmnɨneni kesa tekeny. Ɨ nokɨm da kwa ra wɨn nanggamog gasa mana Kor B'und erkenya Kor nyɨ kɨma, ɨdenat Ton wa tagoniny. ");
INSERT INTO gdr_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Sɨ onggɨt mop penaemb Kon onggɨtyam yɨt ke wen engainyɨn da ɨdenat wɨn wa wɨngɨrɨnd singi b'itiyenindam. ");
INSERT INTO gdr_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ɨ ra onggɨt gowukoi rɨgap wen singi kesa tamnenanj, wɨn b'ogla wumɨr okasya da ton naska kea Ken singi kesa nomneno, ajɨ yɨmta kaim wen singi kesa amnenanj. ");
INSERT INTO gdr_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ɨ rada wɨn gowukoi ke rɨga im, gowukoyɨt keako wen singi eyeniny, nokɨp wɨn gowukoi ke rɨga im. Ajɨ wɨn ma gowukoi ke rɨga im, ajɨ Konɨt wen abagɨkinond onggɨt gowukoi ke. Sɨ onggɨt mop paemb gowukoyɨt wen singi kesa amneniny. ");
INSERT INTO gdr_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Sɨ wɨn b'ogla nonyɨnd yowama onggɨtyam yɨtkak rɨna re Kon wen amninonj da, ‘Wɨko rɨga re ma ukoyam e, ajɨ tina yonggyam re ukoyam e.’ Sɨ rada rɨgap ke Kor pɨlɨnd bebɨg dɨde b'ɨsadrena mɨle oramka niyenauto, ton opima kwa daka wa pɨlɨnd bebɨg kɨma b'ɨdgotnena oramka teyenauranj. Ɨ rada rɨgap ke Koina yɨtkak yɨmta yundoko, ton opima kwa daka waina yɨtkak yɨmta undoki. ");
INSERT INTO gdr_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ajɨ rɨgap opima Koina nyɨ map komkesa odede mɨle tamnɨkenenanj wa pɨlɨnd, mop nokɨp ton ma wumɨr im Godɨm yet re Ken nɨtmɨkitonj. ");
INSERT INTO gdr_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ɨ rako Kon maka netkond dɨde ten maka wumɨr amneninond, ma rako towa pɨlɨnd negɨr mɨle wekeny. Ajɨ yu ton ma rɨrɨr im mop ogenka teyenanj towaina negɨr mɨle gatab. ");
INSERT INTO gdr_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ɨ yet ra Ken singi kesa notɨneny, ton kwa daka Kor B'u na singi kesa yomneny. ");
INSERT INTO gdr_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Sɨ rako Kon maka towa wɨngɨrɨnd onggɨtyam wɨko amnɨkeninond rɨna re yɨpa rɨgat maka rɨrɨr awonj omnɨkam, ma rako towa pɨlɨnd negɨr mɨle wekeny. Ajɨ yu Kon nitinjɨn da ton kea onggɨtyam kɨd kesa kɨma danda wɨko yɨr ongong eyento, ajɨ ton kea Sɨn singi kesa nomneno Ken dɨde Kor B'und. ");
INSERT INTO gdr_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ajɨ ɨtemb re onggɨtyam yɨtkak rɨrɨrkɨp omna ma rɨnte re ɨrɨki yɨbɨm towaina gog yɨt wɨngɨrɨnd da, ‘Ton rɨl kesand Ken singi kesa nomneno.’ ");
INSERT INTO gdr_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Sɨ ra yɨr ɨpka dɨde ouyaena rɨga ik dem yena ra Kon Kor B'uɨm pɨlke ɨtmɨkisɨn wa pɨlwa, Ton re ɨmɨnjog yɨtkakɨmna Wɨngawɨnga e. Sɨ ra Ton Kor B'uɨm pɨlke ik dem, Tonsimemb Kor gatab yɨr ungata yɨt pɨtapɨta tamneniny dem. ");
INSERT INTO gdr_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ɨ wɨda kwa b'ogla Kor gatab yɨr ungata yɨt pɨtapɨta tamnenindam, mop nokɨp wɨn kea otomapu ke Kon kɨma wekenot ngɨrpu yu. ");
INSERT INTO gdr_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Sɨ onggɨt mop penaemb Kon onggɨtyam yɨt ke wen amneninyɨn da ɨdenat wɨn maka sap totekindam. ");
INSERT INTO gdr_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ɨ rɨgap opima wen Ju rɨga waina yɨr opmitenapu met ke teaukenanj dem. Ajɨ ɨta jɨ wɨn ik dem, sɨ onggɨt wɨnɨnd rɨgap opima wen uj ondrɨka teyenanj dem. Ɨ onggɨt onganda rɨgap ɨja im nony taukanj dem da, ‘Sɨn kea Godɨm b'ogɨl wɨko yomnɨkau.’ ");
INSERT INTO gdr_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ton maka wumɨr aukɨto Kor B'uɨm dɨde kwa Kornɨm, sɨ onggɨt paemb ton odede wɨko tamnɨkanj dem. ");
INSERT INTO gdr_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ajɨ onggɨt mop penaemb Kon onggɨtyam yɨt ke wen amneninyɨn da ra onggɨtyam bebɨg wɨn ik dem, ɨdenat wɨn onggɨtyam yɨtkak nonyɨk tamjindam dem rɨnsim re Kon wen wumɨr amneninyɨn. “Otomapu ke Kon onggɨtyam yɨtkak maka wen wumɨr amninond, mop nokɨp Kon omanda wɨn kɨma nɨbnond. ");
INSERT INTO gdr_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yu Kon neken Ti pɨlwa e yet re Ken nɨtmɨkitonj. Sɨ wa wɨngɨrɨnd makwa yɨpa rɨgat Ken ke nerkis da, ‘Rɨtama Man meket?’ ");
INSERT INTO gdr_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ajɨ re Kon onggɨtyam yɨt ke wen amneninyɨn, sɨ waina gar re kea gar kopa ke yɨndangɨr auki im wekeny. ");
INSERT INTO gdr_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ajɨ Kon kwa ɨmɨnjog yɨtkak e wen wumɨr tamninyɨn. Ɨtemb re wanɨm b'ogɨl e ra Kon tewaikisɨn, mop nokɨp ra Kon maka neken, sɨ onggɨtyam yɨr ɨpka dɨde ouyaena rɨga ma ɨta wa pɨlwa ik dem. Ajɨ ra Kon neken, Kon ɨta wa pɨlwa Tin ɨtmɨkisɨn dem. ");
INSERT INTO gdr_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ɨ ra Ton ik, Ton ɨta gowukoi rɨga wa temjatenainy dem negɨr mɨle gatab ɨ negɨr kesa dɨmdɨmjog mɨle gatab ɨ dɨde b'ɨsagɨka mɨle gatab. ");
INSERT INTO gdr_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Negɨr mɨle gatab re ɨntemb ɨt re da rɨgap ma opima gar ke utkunda aramkɨranj Kor pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ɨ negɨr kesa dɨmdɨmjog mɨle gatab re ɨntemb ɨt re da Kon neken ra Abum pɨlwa e ɨ wɨn ma ɨta ket Ken yɨr notngya. ");
INSERT INTO gdr_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ɨ b'ɨsagɨka mɨle gatab re ɨntemb ɨt re da onggɨt gowukoyɨmna wɨp iyoi rɨga Satana re kea negɨr ma b'ɨsagɨka okati e yɨbɨm. ");
INSERT INTO gdr_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Kor ma yɨpa kɨma yɨt im pop nɨbnainy wanɨm wumɨr omnenam, ajɨ otade wɨn ma rɨrɨr im okatenam. ");
INSERT INTO gdr_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ajɨ ra onggɨt ɨmɨnjog yɨtkakɨmna Wɨngawɨnga ik dem, Tonsim wen wang teyeniny dem komkesa ɨmɨnjog yɨtkak wɨngɨr wa. Mop nokɨp Ton ma ɨta tina nony ke yɨt tapureniny, ajɨ ɨna nena im tapureniny nangga im re Ton utkundeny. Ɨ kwa Tonsim wa pɨtapɨta tamnenainy onggɨtyam yɨtkak rɨnsim ra warɨ taukanj. ");
INSERT INTO gdr_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Sɨ Ton Kor pɨlkaim yɨtkak tutkundeneniny dɨde ket onggɨtyam yɨtkak im wa pɨtapɨta tamnenenainy. Ɨ ɨngkaemb Ton b'ogɨl ɨnyomarena Kor notkaeneny. ");
INSERT INTO gdr_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ɨ komkesa gasa rɨnsim re Kor B'uɨm pɨlɨnd wekeny re Koina im. Sɨ onggɨt paemb Kon nindenyɨn da, ‘Yɨnayɨna Wɨngawɨnga Kor pɨlkaim yɨtkak tutkundeneniny dɨde ket onggɨtyam yɨtkak im wa pɨtapɨta tamnenenainy.’ ");
INSERT INTO gdr_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ɨ Kon ma pɨn im wen terarinyɨn, onggɨt sobijog wɨnɨnd wɨn ma ɨta yɨr notngya. Ajɨ onggɨt wɨn kak ke ɨta kwa yɨr notngya dem.” ");
INSERT INTO gdr_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Sɨ onggɨt penaemb nɨnda Tina b'auyaena rɨga b'arkena wuwenonj towa wɨngɨrɨnd da, “Nangga e jɨ onggɨtyam yɨtkak rɨnte re Ton men wumɨr nomneniny da, ‘Ɨ Kon ma pɨn im wen terarinyɨn, onggɨt sobijog wɨnɨnd wɨn ma ɨta yɨr notngya. Ajɨ onggɨt wɨn kak ke ɨta kwa yɨr notngya dem' ɨ kwa onggɨtyam yɨtkak da, ‘Kon neken ra Abum pɨlwa e'?” ");
INSERT INTO gdr_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ɨ kwa omanda ton b'arkenand wekenonj da, “Nangga e jɨ onggɨtyam yɨtkak rɨnte re Ton yindeny da, ‘Ma pɨn e jɨ wɨn'? Sɨ men ma wumɨr im nangga e Ton yindeny.” ");
INSERT INTO gdr_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ɨ Yesu kea wumɨr yokatonj nangga na re ton singi aukɨto Tin erkitam. Sɨ Ton ten amninonj da, “Ma wɨn ɨnte onggɨtyam yɨtkak isɨpkitam yorakya rɨna re Kon nindenyɨn da, ‘Ɨ ma pɨn e jɨ wɨn ra wɨn maka Ken yɨr notngya. Ajɨ onggɨt kak ke ket kwa ma pɨn e jɨ wɨn ra wɨn Ken yɨr notngya dem'? ");
INSERT INTO gdr_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ɨ Kon ɨmɨnjogjog wen tamninyɨn. Ra onggɨtyam wɨn pɨta tainy, wɨn yii opima tainindam dɨde gar kopa kɨma yii b'ɨtrɨnenindam, ajɨ gowukoi rɨgap sam e omnɨka iyenyi. Sɨ wɨn gar kopa tainindam ajɨ onggɨtyam waina gar kopa b'etɨngkanj ra ukoi sam mim. ");
INSERT INTO gdr_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ɨ ra konggam momta mɨna b'ujena wɨn titkau, ton gar kopa e okateny, nokɨp kemb ɨtemb ke Ti wɨn titkau. Ajɨ ra ton b'ɨga ukenj, ton makwa ɨta ket tina b'ɨdgotnena gatab nony iyeny ajɨ sam o tainy da b'ɨga ke ukenj onggɨt gowukoi wa. ");
INSERT INTO gdr_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Sɨ onggɨt paemb wɨda kwa yu odedemb gar kopa yokatenya. Ajɨ ra Kon b'usaya wen yɨr tanginyɨn dem, wɨn gar sam im taukindam dem. Ɨ makwa ɨta yɨpat onggɨtyam waina sam teomneniny wa pɨlke. ");
INSERT INTO gdr_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ɨ onggɨt bibɨrɨnd wɨn makwa ɨta nangga ma netɨrkenya dem. Sɨ Kon ɨmɨnjogjog wen tamninyɨn. Nangga mana ra wɨn Kor B'und erkenya Koina nyɨwɨnd, sɨ Ton opima wa takainy. ");
INSERT INTO gdr_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Naskand wɨn maka Godɨnd yerkenonda Koina nyɨwɨnd ngɨrpu yu. Ajɨ yu wɨn ket b'ogla Koina nyɨwɨnd erkenya, ɨ ket wɨn opima takatenindam. Sɨ ɨdenatemb waina gar sam ke yɨndangɨr auki tekeny. ");
INSERT INTO gdr_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ɨ Kon wɨngata yɨt kena onggɨtyam yɨtkak wa apurenainyɨn. Ajɨ ɨta jɨ wɨn ik ra Kon maka ket wɨngata yɨt ke wa tapurenainyɨn. Ajɨ Kon ket pɨtakɨp nasim wa pɨtapɨta tamnenainyɨn Kor B'uɨm gatab. ");
INSERT INTO gdr_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ɨ onggɨt bibɨrɨnd wɨn opima Koina nyɨwɨnd erkenya. Ajɨ Kon ma odede ma nindenyɨn da Konte Kor B'und erkenyɨn wa gatabɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Nokɨp B'ute Tilenggyam wen singi eyeniny. Sɨ nangga pae Ton wen singi eyeniny re, nokɨp wɨn kea Ken singi niyenya dɨde gar ke utkunda yoramitenya da Kon netkond re Godɨm pɨlkena. ");
INSERT INTO gdr_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Sɨ Kon netkond re Kor B'uɨm pɨlkena dɨde ket opendond onggɨt gowukoi wa. Ɨ Kon kwa ɨraren onggɨtyam gowukoi dɨde ket tɨtenjɨn Kor B'uɨm pɨlwa.” ");
INSERT INTO gdr_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Seg Yesumna b'auyaena rɨgap Tin yomno da, “Yɨr de, otade Man keamb pɨtakɨpɨnd mindenyɨt. Dɨde Man maka nanggamog wɨngata yɨt na yingaet. ");
INSERT INTO gdr_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sɨ sɨn otade wumɨr yokasu da Man wumɨr et-a komkesa gasa. Sɨ Man ma ɨta yena rɨga yɨr ungaet nanggamog gatabɨm Men metɨrkeny. Sɨ onggɨt wumɨr kaimemb sɨn gar ke utkunda ke Men mokasu da Man re Godɨm pɨlkena metkot.” ");
INSERT INTO gdr_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ɨ ket Yesu mɨra amninonj da, “Sɨ ke wɨn otade wumɨr yokasya? ");
INSERT INTO gdr_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Sɨ yɨr de, ɨta jɨ wɨn ik rɨdenat ra wɨn komkesa wetaweta taukindam waina yɨpayɨpa pɨpmet wa dɨde ket Ken nena e nɨtrarya. Sɨ ɨtemb ke onggɨtyam wɨn ik. Ajɨ Kon ra ma Kenta e taen, nokɨp Kor B'u ɨta Kon kɨma yɨbneneny. ");
INSERT INTO gdr_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Sɨ Kon onggɨtyam yɨt wen wumɨr amneninyɨn, nok mim da ɨdenat wɨn ngɨmbla okatenya Kor pɨlɨnd. Ɨ wɨn opima b'ɨdgotnena takatenindam onggɨt gowukoyɨnd, ajɨ wɨn b'ogla napnap towɨnkindam, nokɨp Kon kea onggɨtyam gowukoi danda kesa yomnond.” ");
INSERT INTO gdr_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ɨ re Yesu onggɨtyam yɨt opurena seg awonj, Ton wub kumb wa wɨp b'urowatonj dɨde ket yɨr opmitonj da, “Abu! Kemb ɨtemb ke wɨn ik. Man b'ogla Mor B'ɨgam b'ogɨl ɨnyomarena yokae! Sɨ ɨdenat B'ɨgat Todaka Mor b'ogɨl ɨnyomarena motkau. ");
INSERT INTO gdr_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Man kea Mor B'ɨgam odede danda yokawot komkesa rɨga wɨp omnam, nokɨm da ɨdenat Ton komkesa rɨga wa dadal ngɨrpu kesa yɨrkokar takainy yena re Man Ti yokainot. ");
INSERT INTO gdr_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Sɨ ɨtemb jɨ dadal ngɨrpu kesa yɨrkokar da rɨgat wumɨr e yɨbɨm Mornɨm yete re Man yɨpaina ɨmɨnjog God mɨbnyɨt dɨde Yesu Kerisom yena re Man yɨtmɨkitot. ");
INSERT INTO gdr_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kon kea onggɨtyam wɨko yundwasɨn rɨna re Man Kor nokawot omnɨkam. Sɨ ɨngkaemb Kon b'ogɨl ɨnyomarena Mor mokaenyɨn onggɨt gowukoyɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Abu, naskand re onggɨtyam gowukoi maka aukonj, Kon kea Man kɨma b'ogɨl ɨnyomarenand nɨbnond. Sɨ otade Man onggɨtyam b'ogɨl ɨnyomarena nokae Man kɨma yɨpand onggɨtyam b'ogɨl ɨnyomarenand wɨmenam. ");
INSERT INTO gdr_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ɨ Kon ke Moina nyɨ pɨtapɨta yomnenond onggɨtyam rɨga wa pɨlwa yena re Man Kor nokainot onggɨt gowukoi ke. Ton Mornɨm mana wekenonj, ajɨ Manɨt Kor nokainot. Ɨ ton ket Moina yɨtkak e yɨmta undoka yiyenyi. ");
INSERT INTO gdr_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Yu ton ket wumɨr im da komkesa gasa rɨna re Man Kor nogoninot re Mor pɨlkaim. ");
INSERT INTO gdr_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mop nokɨp Kon kea towa onggɨtyam yɨtkak akainond rɨna re Man Kor nokainot, dɨde ton kea onggɨtyam yɨtkak akatento. Ɨ ton ket ɨmɨnjog wumɨr yokato da Kon netkond re Mor pɨlkena dɨde ton ket gar ke utkunda yoramito da Manɨt Ken nɨtmɨkitot. ");
INSERT INTO gdr_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Sɨ Kon towanɨm metɨrkisɨn. Ajɨ Kon ma metɨrkisɨn onggɨt gowukoi rɨga gatab e ajɨ towa gatab e yena re Man Kor nokainot, nokɨp ton re Mor mim. ");
INSERT INTO gdr_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Koina komkesa gasa re Mor mim, ɨ Moina komkesa gasa re Kor mim. Sɨ Kon towa pɨlkaemb b'ogɨl ɨnyomarena yokatenyɨn. ");
INSERT INTO gdr_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ɨ Kon makwa ɨta ket nɨtɨbnyɨn onggɨt gowukoyɨnd, ajɨ ton opima tekeny onggɨt gowukoyɨnd. Sɨ Kon neken ra Mor pɨlwa e. Yɨnayɨna B'u! Man b'ogla ten yɨr ɨpka teyeninyɨt Moina danda nyɨ ke rɨna re Man nokawot! Nokɨm da ɨdenat toda yɨpaina taukanj odede rɨngmim re Men wekenyɨn. ");
INSERT INTO gdr_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ɨ re Kon ton kɨma nɨbnenenyɨmɨn, Kon kea ten yɨr epkeneninyɨmɨn onggɨtyam Moina danda nyɨ ke rɨna re Man nokawot, dɨde Kon kea yɨrgong amnɨkeninyɨmɨn. Sɨ towa wɨngɨrɨnd makwa yet b'edamkisɨm. Ajɨ ɨna yɨpaina wul tunggɨmna b'ɨga nenat, nokɨm da ɨdenat yɨna peba rɨrɨrkɨp tainy. ");
INSERT INTO gdr_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Sɨ yu Kon ket netken Mor pɨlwa e, ajɨ Kon onggɨtyam yɨt apureninyɨn re onggɨt gowukoi nate, nokɨm da ɨdenat Koina sam yɨndangɨr auka ikeny towaina garɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ɨ Kon kea Moina yɨtkak towa akainond ɨ gowukoi rɨgap ten singi kesa amnenenanj. Mop nokɨp ton ma gowukoi ke rɨga im ket odede ɨte re Kon ma onggɨt gowukoi ke rɨga en. ");
INSERT INTO gdr_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kon ma nok ma merkisɨn da Man ten temjinyɨt onggɨt gowukoi ke, ajɨ nok ma da Man ten yɨrgong tamnɨkeneninyɨt negɨrjog rɨga Satanam pɨlke. ");
INSERT INTO gdr_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ton re ma gowukoi ke rɨga im odede ɨte re Kon ma gowukoi ke rɨga en. ");
INSERT INTO gdr_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ɨ Moina yɨtkak re ɨmɨnjog yɨtkak e, sɨ Man ten yɨnam amnine onggɨtyam ɨmɨnjog yɨtkak ke. ");
INSERT INTO gdr_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ɨ Man kea Ken nɨtmɨkitot onggɨt gowukoi wa, sɨ Koda kwa odede wɨp imemb ten etmɨkeneninyɨn onggɨt gowukoi wɨngɨr nata. ");
INSERT INTO gdr_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Sɨ Kon Kolenggyam yɨna omnam b'akaenyɨn towanɨm b'ogɨlɨm, nokɨm da ɨdenat toda towalenggyam wɨngawɨnga kɨlkesa taukanj ɨmɨnjog yɨtkak ke. ");
INSERT INTO gdr_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ɨ Kon merkisɨn re ma towanɨm nena ma, ajɨ daka towanɨm ma yepim ra Ken gar ke utkunda ke notkasi towaina bage yɨt ke. ");
INSERT INTO gdr_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Abu! Ton komkesa b'ogla yɨpaina raukinem odede ɨte re da Man mɨbnyɨt Kor pɨlnate ɨ Koda kwa re nɨbnyɨn Mor pɨlnate! Sɨ ɨdenat ton Mera pɨlɨnd tekeny. Nokɨm da ɨdenat gowukoi rɨgap ɨmɨnjog ke okasi da Manɨt Ken nɨtmɨkitot. ");
INSERT INTO gdr_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Sɨ Kon kea towa akainond onggɨtyam b'ogɨl ɨnyomarena rɨna re Man Kor nokawot, nokɨm da ɨdenat ton yɨpaina taukanj odede ɨte re Men yɨpaina wekenyɨn. ");
INSERT INTO gdr_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ɨ Kon towa pɨlnate nɨbnyɨn dɨde Man Kor pɨlnate mɨbnyɨt. Sɨ toda odede nya kaimemb kupkakupka yɨpaina tauranj. Nokɨm da ɨdenat gowukoi rɨga wumɨr taukanj da Manɨt Ken nɨtmɨkitot dɨde Mansim ten singi eyeninyɨt odede rɨngma na re Man Ken singi niyenot. ");
INSERT INTO gdr_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Abu! Onggɨtyam rɨga rɨna re Man Kor nokainot, Kon singi en da ton Kon kɨma tekeny rokate ra Kon nɨtɨbnyɨn, nokɨm da ɨdenat ton Koina b'ogɨl ɨnyomarena yɨr ongenenyi. Sɨ rɨna re naskand onggɨtyam gowukoi maka pɨta awonj, Man kea onggɨtyam b'ogɨl ɨnyomarena Kor nokawot nokɨp Man kea Ken singi niyenot. ");
INSERT INTO gdr_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Negɨr kesa dɨmdɨmjog B'u! Gowukoi rɨgap maka wumɨr aukɨto Mornɨm ajɨ Konɨt Mornɨm wumɨr awond. Sɨ onggɨtyam Koina b'auyaena rɨgap re kea wumɨr yokato da Manɨt Ken nɨtmɨkitot. ");
INSERT INTO gdr_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ɨ Kon kea Mor gatab ten wumɨr omnena teyinyɨmɨn ngɨrpu yu, ɨ Kon kwa opima wumɨr omnena eyinyɨn. Nokɨm da ɨdenat onggɨtyam singi towa pɨlɨnd ɨbɨm rɨngkae re Man Ken singi niyenyɨt dɨde Koda towa pɨlnate nɨtɨbnyɨn.” ");
INSERT INTO gdr_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Re ket Yesu yɨr opmita seg awonj, Ton ket Tina b'auyaena rɨga kɨma wuwonj Kidron paga yɨpa tab wa. Ɨ ademb de yɨpa sopapu yɨbnonj, sɨ Ton Tina b'auyaena rɨga kɨma onggɨt sopapu wɨngɨr wa wuwonj. ");
INSERT INTO gdr_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ɨ Yesu Tina b'auyaena rɨga kɨma ademb de wɨn ke b'atabɨkenento. Sɨ onggɨt penaemb Yudas yet re Tin tɨb yiyonj, toda kwa wumɨr na yɨbnonj ɨtemb pɨpmet. ");
INSERT INTO gdr_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Sɨ Yudas yɨpa geja rɨga bobo dɨde nɨnda yɨnamet yɨr ɨpka rɨga akasinonj yɨna mopyam sɨ rɨga wa pɨlke dɨde Parisai rɨga wa pɨlke. Seg ton ket lampa ɨ ngaya dɨde ipowa gasa kɨma onggɨt pɨpmet wa wuwonj. ");
INSERT INTO gdr_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Sɨ Yesu re kea wumɨr yokatonj komkesa mɨle rɨnsim ra Ti pɨlɨnd taukanj. Sɨ Ton wɨp wa b'ɨsonkitonj dɨde ket ten arkisinonj da, “Yena wɨn oraka iya?” ");
INSERT INTO gdr_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ɨ ton mɨra yomno da, “Najaret tunggam Yesu.” Sɨ Yesu ten amninonj da, “Ɨtenemb Kon.” Ɨ Ti tɨb iyoyam Yudas toda omanda onyiti yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ɨ re Yesu ten amninonj da, “Ɨtenemb Kon,” ton ket kaknyakaknya gurgur ɨtekto dɨde ket gou wa sap otekto. ");
INSERT INTO gdr_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Sɨ Yesu b'usaya ten arkisinonj da, “Yena wɨn oraka iya?” Ɨ ton ket yomno da, “Najaret tunggam Yesu.” ");
INSERT INTO gdr_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ɨ Yesu ket ten amninonj da, “Kon ke kɨm ninjɨn da, ‘Ɨtenemb Kon.’ Sɨ rada wɨn Kena oraka niyenya, sɨ opimemb Koina rɨga wou.” ");
INSERT INTO gdr_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Sɨ nangga pena Yesu odede yindonj re nok mana da ɨtemb yɨtkak rɨrɨrkɨp tainy rɨna re ton yopulitonj da, “Kon makwa ke yɨpa yɨdamkismɨn towa wɨngɨrɨnd rɨna re Man Kor nokainot.” ");
INSERT INTO gdr_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ɨ Simon Petrom re kea giri yɨbnawonj. Sɨ ton ket giri yɨtrɨngatonj dɨde ket yingawonj yɨna mopyam sɨ rɨgamna wɨko rɨgam pɨlɨnd ɨ dɨde ket tina yɨmjog ke yɨpya rom yɨpmarkitawonj. Ɨ ɨtemb wɨko rɨgamna nyɨ re Malkot. ");
INSERT INTO gdr_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Seg Yesu ket Petrond yɨswangonj da, “Giri yupungite tina metkak wa! Rɨngma, ma ma ɨta Kon onaen onggɨtyam b'ɨdgotnena kapo rɨna re Kor B'u nokawonj?” ");
INSERT INTO gdr_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Seg ket geja rɨga bobo dɨde towa wan tausɨn (1,000) Roma geja rɨga mopyam ɨ dɨde Ju rɨga waina yɨnamet yɨr ɨpka rɨgap Yesund yɨmɨnd yusunato dɨde ket Tin yɨjobɨko. ");
INSERT INTO gdr_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Seg ton naska ket Yesund yiyo de Annam pɨlwa. Nokɨp ton re Kayapamna jeam na yɨbnonj. Ɨ Kayapa re onggɨt kemagɨnd yɨna mopyam sɨ rɨga na yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ɨ kwa Kayapatemb jɨ rɨga yet re Ju rɨga ugoinonj da, “Sɨ ɨtemb re b'ogɨljog emb jɨ ra yɨpa rɨgat uj okas komkesa Ju rɨga map.” ");
INSERT INTO gdr_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ɨ Simon Petro dɨde yɨpa Yesumna b'auyaena rɨga Yesund yɨmta yundokonda. Ɨtemb b'auyaena rɨga re yɨna mopyam sɨ rɨgam wumɨr na yɨbnonj. Sɨ ton kea ket Yesu kɨma b'ɨgaronj onggɨtyam yɨna mopyam sɨ rɨgamna met kara wɨngɨr wa. ");
INSERT INTO gdr_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ajɨ Petro re onyiti na yɨbnonj kara bau ke. Sɨ onggɨt penaemb onggɨtyam b'auyaena rɨga yet re yɨna mopyam sɨ rɨgam wumɨr yɨbnonj, ton kara mora wa ɨtendonj dɨde ket mora yɨr ɨpka konggand yɨt womnonj Petrond ɨgaram. ");
INSERT INTO gdr_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ɨ re ton Petrond wɨngɨr wa yiyonj, mora yɨr ɨpka wɨko konggat Petrond yomnonj da, “Ma madaka onggɨt rɨgamna yɨpa b'auyaena rɨga et?” Sɨ ton womnonj da, “Nayɨ, ma Kon ton ten.” ");
INSERT INTO gdr_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ɨ wɨko rɨga dɨde yɨnamet yɨr ɨpka rɨgap wul yɨtano gɨbɨl map. Ɨ ton ket gɨbɨl b'ɨrnɨto. Ɨ Petro daka re omanda ton kɨma onyiti gɨbɨl b'ɨrnand yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ɨ yɨna mopyam sɨ rɨgat ket Yesund yerkitonj Tina b'auyaena rɨga gatab dɨde Tina ouyaena gatab. ");
INSERT INTO gdr_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Sɨ Yesu tin yɨsmonggawonj da, “Kon ke gowukoi rɨga wa wɨpɨnd pɨta kɨpɨnd apurenenainond. Ɨ Kon ita wɨnɨnd meraina yɨr opmitenapu met nata dɨde yɨnamet aband rɨga auyaeneninond rɨkɨnd re komkesa Ju rɨga b'atabɨkenento. Sɨ Kon maka nangga wɨgawɨga yɨt na apureneninond. ");
INSERT INTO gdr_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Sɨ nangga pae man Kor pɨlɨnd b'ɨgekita yoramisɨt? Sɨ man tena arkenine yepiya re Ken nutkundeno nanggamog yɨt na Kon ten amneninond. Sɨ yɨr de, ton wumɨrjog im wekeny nangga na re Kon apureninond.” ");
INSERT INTO gdr_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ɨ re Yesu onggɨtyam yɨt opurena seg awonj, yɨnamet yɨr ɨpka rɨga wɨngɨrɨnd yɨpa rɨgat yet re Ti wusɨnd onyiti yɨbnonj, ton Yesund ana yɨpokitonj. Ɨ ton ket wɨp sɨngba kɨma Yesund yomnonj da, “Ma man odede wɨp yɨt kae yɨna mopyam sɨ rɨgand yɨt ɨsmonggaet?” ");
INSERT INTO gdr_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ɨ Yesu ket tin mɨra yomnonj da, “Rada ke Kon negɨr yɨt yopulisɨn, man b'ogla yɨr ungata yɨt minde onggɨt negɨr yɨt gatab! Ajɨ rada Kon ɨmɨnjog yɨt e yopulisɨn, sɨ nangga pena man Ken nonganjɨt?” ");
INSERT INTO gdr_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Sɨ onggɨt penaemb Anna Tin dɨdea yɨm ɨjobɨki yɨtmɨkitonj de yɨna mopyam sɨ rɨga Kayapam pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ɨ re Simon Petro onyiti gɨbɨl b'ɨrnand yɨbnonj, nɨnda rɨgap tin yerkito da, “Ma mada yɨpa Tina b'auyaena rɨga et?” Ɨ ton ket b'aenonj da, “Nayɨ, ma kon ton ten.” ");
INSERT INTO gdr_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ɨ omanda yɨpa mopyam sɨ rɨgamna wɨko rɨga yɨbnonj. Ɨ ton re onggɨt kus rɨga na yena re Petro yɨpya rom yɨpmarkitonj. Sɨ ton Petrond yomnonj da, “Ma ke kon men yɨr mongen kɨm re man Ton kɨma mɨbnyɨt de sopapu wa?” ");
INSERT INTO gdr_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Sɨ Petro b'usaya ket b'aenonj, ɨ odenja ket pauro ara yikenonj. ");
INSERT INTO gdr_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Seg ket Ju rɨgap Yesund Kayapam pɨlke yiyo de Roma gabmani mopyam rɨga Pilatomna wɨkopu met wa. Sɨ ɨtemb mɨle aukonj re sɨtawarjog natemb. Ɨ Ju rɨga maka onggɨtyam Roma gabmani mopyam rɨgamna wɨkopu met wa b'ɨgarkɨto, nokɨp ton ma singi na kɨl taukanj, nokɨm da ɨdenat ket ton kɨlkesand Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam owi. ");
INSERT INTO gdr_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Sɨ onggɨt penaemb Pilato bau wa opendonj towa pɨlwa, ɨ ket ten arkisinonj da, “Wɨn nangga mop pae onggɨt rɨgand kot wa oramitam iya?” ");
INSERT INTO gdr_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ɨ ton ket tin yɨsmonggawo da, “Rako onggɨt rɨgat maka negɨrjog mɨle omnɨka rɨga yɨbɨm, sɨn ma rako Tin iyu mor pɨlwa kot omnɨkam.” ");
INSERT INTO gdr_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Sɨ ket Pilato ten amninonj da, “Wɨn walenggyam Tin yiya dɨde ket waina gog ke Ti pɨlɨnd b'ɨsagɨka mɨle yomnɨka!” Ɨ Ju rɨgap ket tin daka yomno da, “Sowa pɨlɨnd awɨr e ingawam danda yɨbɨm rɨga ongandam.” ");
INSERT INTO gdr_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Sɨ nangga pena onggɨtyam mɨle aukonj re nok mana da ɨdenat Yesu ma onggɨtyam yɨtkak rɨrɨrkɨp tainy rɨna re Ton naska kana wumɨr amninonj rɨdede wɨp kae Ton uj okas. ");
INSERT INTO gdr_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Sɨ Pilato b'usaya tina wɨkopu met wɨngɨr wa b'ɨgaronj dɨde ket Yesund ara yemokonj ɨ ket yomnonj da, “Ma Man Ju rɨga waina king et?” ");
INSERT INTO gdr_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Sɨ Yesu ket tin yerkitonj da, “Sɨ man moinajog nony kae mindenyɨt o mɨnda nɨnda rɨgapiya men odede wumɨr momnenyi Kor gatab?” ");
INSERT INTO gdr_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ɨ Pilato daka Yesund yerkitonj da, “Ma Man ɨja e nony aet da kon Ju rɨga en? Moina Ju yɨtam rɨga dɨde yɨna mopyam sɨ rɨgapiya Men mitiyi kor pɨlwa kot omnɨkam. Sɨ nangga negɨrjog mɨle na Man yomnɨkmɨt?” ");
INSERT INTO gdr_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ɨ ket Yesu mɨra yomnonj da, “Koina wɨp omnenapu kantri re ma onggɨt gowukoi kae. Rako da Koina kantri onggɨt gowukoi kae, keako Koina yɨr ɨpka rɨgap Ju rɨga epouranj Ken ɨrmekam, nokɨm da ɨdenat ton maka Ken mor pɨlwa nii. Ajɨ Koina wɨp omnenapu kantri re ma onggɨt gowukoi kae.” ");
INSERT INTO gdr_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Sɨ Pilato ket Yesund yomnonj da, “Sɨ man molenggyam king e b'agenaet?” Ɨ Yesu ket tin mɨra yomnonj da, “Man kemb minjɨt da Kon re king en. Sɨ Kon onggɨt mana pɨta awond dɨde onggɨt mana Kon netkond onggɨt gowukoi wa, nokɨm da ɨdenat Kon yɨr ungata yɨt tapureninyɨn ɨmɨnjog yɨtkak gatab. Sɨ komkesa rɨga yepim re onggɨt ɨmɨnjog yɨtkak tabɨnd wekeny, ton opima Koina nonykok utkundenyi.” ");
INSERT INTO gdr_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ɨ Pilato ket Yesund yomnonj da, “Nangga e jɨ ɨmɨnjog yɨtkak?” Ɨ ton ket onggɨtyam yɨt seg ke b'usaya bau wa opendonj Ju rɨga wa pɨlwa dɨde ket ten amninonj da, “Kon maka nanggamog negɨr mɨle na yodaraen Ti pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ɨ ɨta jɨ wa yɨpa kesam owabɨnti mɨle ebnau da kon yɨpa sɨbɨbmet rɨga openjɨn wanɨm waina Uj Ɨgwanti Nony Iyena Diyamdiyam Wɨnɨnd. Sɨ rɨngma, ma wɨn singi im kon Ju rɨga wa king openjɨn wanɨm?” ");
INSERT INTO gdr_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ajɨ Ju rɨgap unena kɨma ognento da, “Goro onggɨt Rɨgand, ajɨ Baraba na!” Sɨ Baraba re yɨpa raskol rɨga na yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Sɨ onggɨt penaemb Pilato geja rɨga engainonj Yesund okatam dɨde ɨraskam. ");
INSERT INTO gdr_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ɨ ɨraska seg ke geja rɨgap ket dɨngdɨng kai dɨra pɨla yogauko dɨde ket ɨtemb dɨra Yesum mopɨnd yikito king pɨla. Ɨ ton ket king pɨla kuskus kobɨrgɨm kwa Tin yikito. ");
INSERT INTO gdr_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Seg ton ket Yesum wɨp wa wuwenonj odede yɨt kɨma da, “Simesime! Ju rɨga wa king!” dɨde ket ana yɨpokeno. ");
INSERT INTO gdr_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Seg ket Pilato b'usaya bau wa opendonj dɨde ket ten amninonj da, “Yɨr de, kon nok ma Tin iyɨn wa pɨlwa, nokɨm da ɨdenat wɨn wumɨr okasya da kon maka nanggamog negɨr mɨle na yodaraen Ti pɨlɨnd.” ");
INSERT INTO gdr_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Sɨ ket Yesu bau wa opendonj dɨngdɨng kai ke ogauki dɨra b'ikiti dɨde kuskus kobɨrgɨm b'ikiti. Seg Pilato ten amninonj da, “Yɨr de, ɨtemb jɨ Rɨga!” ");
INSERT INTO gdr_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ɨ re yɨna mopyam sɨ rɨgap dɨde yɨnamet yɨr ɨpka rɨgap Yesund yɨr yongo, ton unena kɨma ognento da, “Wul b'agbagɨnd yɨdrɨke! Wul b'agbagɨnd yɨdrɨke!” Sɨ Pilato ket ten amninonj da, “Wɨn walenggyam Tin yokata, dɨde wul b'agbagɨnd yɨdrɨka! Mop nokɨp kon maka nanggamog negɨr mɨle na yodaraen Ti pɨlɨnd.” ");
INSERT INTO gdr_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Seg Ju rɨgap ket tin mɨra yomno da, “Sowa ɨta jɨ gog yɨt, ɨ onggɨtyam gog yɨt kae Ton b'ogla uj okas, nokɨp Ton Tilenggyam b'agenayonj Godɨmna B'ɨgam.” ");
INSERT INTO gdr_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ɨ re Pilato onggɨtyam yɨt utkundonj, ton kwa ket ma sobijog na moga awonj. ");
INSERT INTO gdr_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Sɨ ton ket b'usaya ɨtendonj tina wɨkopu met wɨngɨr wa dɨde ket Yesund yomnonj da, “Rɨngkae Man metkot?” Ajɨ Yesu maka tin yɨsmonggawonj. ");
INSERT INTO gdr_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Sɨ onggɨt penaemb Pilato Yesund yomnonj da, “Ma Man ma ɨta nɨtɨsmonggaet? Ma Man wumɨr et da kor ɨta danda Men ɨtrɨngendam dɨde kor ɨta danda Men wul b'agbagɨnd ɨdrɨkam?” ");
INSERT INTO gdr_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ɨ Yesu ket mɨra yomnonj da, “Mor ma ɨta nanggamog danda Kor pɨlɨnd oramitam, ajɨ ɨnta ra God mor motkau. Sɨ onggɨt paemb moina negɨr mɨle re ma ukoi e, ajɨ yete re Ken nitɨi mor pɨlwa, ti re ukoijog negɨr mɨle e.” ");
INSERT INTO gdr_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Sɨ onggɨt yɨt map Pilato ket nya oraka yiyenonj Tin ɨtrɨngendam. Ajɨ Ju rɨgap unena kɨma ognento da, “Ra man onggɨt Rɨgand ɨtrɨngenjɨt, man ma Roma mopyam king Kaisamna rɨga et. Yet ra tilenggyam b'atgenai kingɨm, ton re Roma mopyam king Kaisamna geja rɨga e.” ");
INSERT INTO gdr_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Sɨ re Pilato onggɨtyam yɨt utkundonj, ton kea ket Yesund yopendonj bau wa dɨde ket tina b'ɨsagɨkapu kasa kumbɨnd omitonj rɨna re onggɨt pɨpmetɨnd yɨbnonj ogenaya da Kɨla pɨpmet, ɨ Ibru yɨt ke da Gabata. ");
INSERT INTO gdr_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Sɨ onggɨtyam mɨle re Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam Wɨn b'angonjenam bibɨr nat aukonj, ɨ ket lomtɨk gatab awonj. Seg Pilato ket Ju rɨga amninonj da, “Yɨr yonga, ɨtemb waina king!” ");
INSERT INTO gdr_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Sɨ ton yɨpand unena kɨma ognento da, “Yeomnene! Yeomnene! Wul b'agbagɨnd yɨdrɨke!” Ɨ Pilato ket ten amninonj da, “Rɨngma, kon b'ogɨl e waina king wul b'agbagɨnd ɨdrɨken?” Seg yɨna mopyam sɨ rɨgap tin yɨsmonggawo da, “Sowa awɨr e king, ajɨ Roma mopyam king Kaisata.” ");
INSERT INTO gdr_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ngɨrpu ket Pilato onggɨt wɨnɨnd Yesund towa yɨmɨnd yoramitonj wul b'agbagɨnd ɨdrɨkam. Sɨ geja rɨgap ket Yesund yokato. ");
INSERT INTO gdr_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Sɨ Yesu Tina wul b'agbag kawar wa yomnonj ɨ ket opmarkitonj ɨ dɨde ket yikonj de onggɨt pɨpmet wa ogenaya da Mopkak Wɨmenapu Tungg, Ibru yɨt ke da Golgota. ");
INSERT INTO gdr_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ɨ omandemb ket Tin wul b'agbagɨnd yɨdrɨko. Ɨ kwa nɨmog rɨga Ti yɨu ke yɨu ke edrɨko, sɨ Yesu re towa ɨnyɨny nat yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Seg Pilato ket Yesu ma ongandam mop yɨtkak yɨrɨkonj wulpagɨmɨnd dɨde ket Tina wul b'agbag pumb ke yoramitonj. Sɨ ɨja naemb ɨrɨki yɨbnonj da, ");
INSERT INTO gdr_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sɨ Ju rɨga wɨngɨrɨnd jogjog rɨgap onggɨtyam ongandam mop ɨrɨki ogenka yiyeno, nokɨp ɨtemb pɨpmet rɨkɨnd re Yesund wul b'agbagɨnd yɨdrɨko re Yerusalem taun wus nat yɨbnonj. Ɨ onggɨtyam mop yɨtkak ɨrɨki yɨbnonj re Ibru yɨt ɨ Latin yɨt dɨde Grik yɨt kena. ");
INSERT INTO gdr_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Sɨ onggɨt penaemb Ju rɨga waina yɨna mopyam sɨ rɨgap Pilatond yomno da, “Goro ɨrɨkɨm da, ‘Ju rɨga ma king', ajɨ ɨja na ɨrɨket da, ‘Onggɨt rɨgat b'agenayonj da Konten Ju rɨga wa king.’” ");
INSERT INTO gdr_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ɨ Pilato ket ten esmonggainonj da, “Nangga na re kon yɨrɨken, b'ogla ɨrɨki yebɨm.” ");
INSERT INTO gdr_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ɨ re geja rɨgap Yesund wul b'agbagɨnd yɨdrɨko, ton Yesumna tumɨnd kobɨrgɨm emdɨto dɨde ket onggɨtyam kobɨrgɨm powa (4) geja rɨgap yɨpayɨpa b'asos wuwenonj. Ɨ ton kwa ket yokato wɨngɨr ke kobɨrgɨm. Ajɨ onggɨtyam kobɨrgɨm re yɨpaina kɨb na dɨde kupka yɨpaina onki na yɨbnonj kuna ke ɨdeni de pɨs wa. ");
INSERT INTO gdr_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Sɨ onggɨt penaemb ton towa wɨngɨrɨnd endento da, “Goro men onggɨtyam kobɨrgɨm yenyouku ajɨ men b'ogla pes b'areninum ɨ ɨngkaemb ket yɨpa rɨgat okas.” Sɨ onggɨt mop penaemb onggɨtyam mɨle aukonj da onggɨtyam yɨtkak rɨrɨrkɨp tainy rɨnte re yɨna peband ɨrɨki yɨbɨm da, “Ton Koina kobɨrgɨm towanɨm ataikɨto, dɨde Koina yɨpa kobɨrgɨm okatam pes b'arento.” Sɨ onggɨt penaemb geja rɨgap odede mɨle amnɨkto. ");
INSERT INTO gdr_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ɨ Yesu ma wul b'agbag wusɨnd kea onyiti wekenonj dɨkɨnd Ti mog Mariya ɨ Ti kom mog ɨ Klopamna kongga Mariya ɨ dɨde Magdala tunggam Mariya. ");
INSERT INTO gdr_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ɨ re Yesu Ti mog dɨde Tina singi iyeni b'auyaena rɨga Ti wusɨnd onyiti yɨr angonj, Ton Ti mogɨnd womnonj da, “Kongga, yɨr de ɨtemb mor b'ɨga.” ");
INSERT INTO gdr_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Dɨde ket daka onggɨt b'auyaena rɨgand yomnonj da, “Yɨr de, ɨtomb mor mog.” Seg ket onggɨt wɨn natemb onggɨt b'auyaena rɨgat tin wiyonj tina met wa. ");
INSERT INTO gdr_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ɨ onggɨt kak ke Yesu kea wumɨr yokatonj da komkesa gasa kemb undwatanj. Sɨ Yesu yindenonj da, “Kon nyɨpa en.” Nokɨm da ɨdenat yɨna peba yɨtkak rɨrɨrkɨp tainy. ");
INSERT INTO gdr_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ɨ ademb de tokɨltokɨl ɨk besenɨnd yɨndangɨr yɨbnonj. Ɨ rɨgap nyɨ ɨngmatena ɨngmatena matres pɨla gasa ke onggɨtyam tokɨltokɨl ɨk besen wa yɨsonggo ɨ yisop tɨbkak ke yɨpo dɨde ket Yesumna tugɨm wa yurowato onayam. ");
INSERT INTO gdr_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ɨ re Yesu onggɨtyam tokɨltokɨl ɨk yonayonj, Ton ket yindonj da, “Kemb yundwasɨn.” Seg ket as eamantonj, dɨde ket Tina wɨngawɨnga ewaikitonj. ");
INSERT INTO gdr_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ɨ ket b'angonjena bibɨr na awonj. Ɨ Ju rɨgap ma singi na da ujgɨm wul b'agbag kumbɨnd tekeny onggɨtyam towaina wɨram dɨde yɨr opmitena bibɨrɨnd. Mop nokɨp onggɨtyam towaina wɨram dɨde yɨr opmitena bibɨr re naskajog bibɨr na Ju rɨga waina Uj Ɨgwanti Nony Iyena Diyamdiyam Wɨn wɨngɨrɨnd, sɨ Ju rɨgap ɨtemb bibɨr ukoijog yɨsnaeneno. Sɨ onggɨt penaemb ton Pilatond yɨgekito towaina selkak onygɨkam dɨde ujgɨm ewaikuram. ");
INSERT INTO gdr_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Sɨ onggɨt penaemb geja rɨgap wuwonj dɨde ket naskanyam rɨga selkak yonygɨko ɨ kwa ket daka yɨpa rɨna re Yesu kɨma ɨdrɨki ebnonda. ");
INSERT INTO gdr_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ɨ re ton Yesum pɨlwa tuwonj, ton kea yɨr yongo da Ton re kea uj yokas. Sɨ ton maka Tin selkak yonygɨko. ");
INSERT INTO gdr_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ajɨ onggɨt geja rɨga wa wɨngɨrɨnd yɨpa rɨgat nɨm ke Yesund yɨponj yororand. Ɨ odenja ket kus ake nyɨ opekonda. ");
INSERT INTO gdr_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ɨ yet re onggɨtyam mɨle yɨr yongonj, tontemb yɨr ungata yɨt yopureny. Sɨ tina yɨr ungata yɨt re ɨmɨnjog e. Ɨ ɨtemb rɨga wumɨr e da ton ɨmɨnjog yɨt im apureniny, nokɨm da ɨdenat wɨda kwa gar ke utkunda oramisya. ");
INSERT INTO gdr_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ɨ onggɨtyam mɨle aukɨto re nok mana da ɨdenat onggɨtyam yɨna peba yɨtkak rɨrɨrkɨp tainy da, “Makwa ɨta yɨpa Tina kak tiposɨk.” ");
INSERT INTO gdr_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ɨ daka kwa b'enga yɨna peba yɨtkakɨt yindeny da, “Rɨgap opima onggɨt Rɨgand yɨr ongi dem yena ra ɨpi dem.” ");
INSERT INTO gdr_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ɨ Arimataya tunggam Yosep re yɨpa Yesumna b'auyaena rɨga na yɨbnonj, ajɨ ton Ju rɨga moga map onggɨtyam wumɨr wɨgawɨga na yowamonj. Ɨ re Yesu uj awonj, ton Pilatond yerkitonj Yesumna ujgɨm okatam. Ɨ Pilato ket yingawonj. Sɨ ton yikonj dɨde ket Tina ujgɨm yokatonj. ");
INSERT INTO gdr_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ɨ Nikodemo yet re naskand Yesund yodaronj yɨpa sɨwɨnyɨnd, todaka b'ogɨl ngɨrangngɨrang wulpoj teyinonj ujgɨm eungitam. Ɨ onggɨtyam wulpoj bebɨg re ama rɨka teti powa (34) kilogram na. ");
INSERT INTO gdr_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Sɨ ton nɨnda rɨga kɨma Yesumna ujgɨm yiyo. Ɨ ton ngɨrangngɨrang wulpoj kɨma na kobɨrgɨm ɨsetɨki ke ujgɨm ogauka yiyeno. Sɨ ton yomnɨko re Ju rɨga waina eungitam mɨle kena. ");
INSERT INTO gdr_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ɨ yɨpa sopapu kea de yɨbnonj onggɨt pɨpmet wusɨnd rɨkɨnd re Yesund wul b'agbagɨnd yɨdrɨko. Ɨ onggɨt sopapund kea yɨpa sisɨl gopmet yɨbnonj rɨna re makwa ke yɨpa rɨga naskand yeungito. ");
INSERT INTO gdr_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ɨ ɨtemb bibɨr re Ju rɨga waina b'angonjena bibɨr na, dɨde kwa ɨtemb gopmet re wus nat yɨbnonj. Sɨ onggɨt penaemb ton dɨkɨndemb Yesund yeungito. ");
INSERT INTO gdr_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ɨ re Ju rɨga waina wɨram dɨde yɨr opmitena bibɨr kak ke naskajog bibɨr awonj, Magdala tunggam Mariya sɨtawarjog sɨ borand wikonj Yesu ma gopmet wa. Seg ton kea onggɨtyam gopmet ɨdokapu ukoi gɨmo ururkiti yɨr yongonj gopmet mora yurund. ");
INSERT INTO gdr_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Sɨ onggɨt penaemb ton b'ɨkonj Simon Petro dɨde Yesu ma singi iyeni b'auyaena rɨga wa pɨlwa. Dɨde ket ten amnonj da, “Ton ke Yonggyamɨmna ujgɨm yokasi gopmet ke. Sɨ sɨn ma wumɨr im rokate Tin yoramisi.” ");
INSERT INTO gdr_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Seg Petro dɨde ɨtemb b'auyaena rɨga yiwatonda Yesumna gopmet wa. ");
INSERT INTO gdr_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ɨ ton gɨlgɨl b'ɨkonda, ajɨ ɨtemb b'auyaena rɨga Petrond yɨsalngitonj dɨde ket naska opendonj de gopmet wa. ");
INSERT INTO gdr_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ɨ ton ket uwontonj dɨde ket ɨsetɨki kobɨrgɨm ondrɨki yɨr anginonj onggɨt gɨmo yɨund oski gopmet wɨngɨrɨnd. Ajɨ ton maike gopmet wɨngɨr wa b'ɨgaronj. ");
INSERT INTO gdr_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ɨ Simon Petro yɨmta kena opendonj dɨde ket gopmet wɨngɨr wa b'ɨgaronj. Sɨ toda kwa kea yɨr anginonj ɨsetɨki kobɨrgɨm ondrɨki. ");
INSERT INTO gdr_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ɨ onggɨtyam mop paspas kobɨrgɨm rɨna re Yesu ma mopɨnd ɨjobɨki yɨbnonj, ton re ma nɨnda ɨsetɨki kobɨrgɨm kɨma na yɨpand yɨbnonj. Ajɨ yɨpa b'enga pɨpmet nat eoromki yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Sɨ onggɨt b'auyaena rɨgat yet re naska opendonj, todaka ɨdenatemb gopmet wɨngɨr wa b'ɨgaronj. Dɨde ket yɨr anginonj ɨ ket ton gar ke utkunda yoramitonj. ");
INSERT INTO gdr_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nokɨp ton makwa ke nony aukonda onggɨtyam yɨna peba yɨtkak da, “Ton b'ogla uj ke tutnyis.” ");
INSERT INTO gdr_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Sɨ kwa osiemb nɨmog b'auyaena rɨga ɨtendonda towaina wɨmenapu wa. ");
INSERT INTO gdr_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ajɨ Mariya re bau ke gɨmo yɨund oski gopmet wɨp owarkiti na yowamonj yii iyagɨkand. Ɨ ton yii iyagɨka kɨma uwontonj dɨde ket ɨtemb gɨmo yɨund oski gopmet wɨngɨr wa yɨr wikenonj. ");
INSERT INTO gdr_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ɨ ton ket nɨmog aneru yɨr angonj bɨlbɨl kobɨrgɨm b'ikoki. Ton re omiti na ebnonda rɨkɨnd re Yesu ma ujgɨm yɨbnonj, yɨpa re mop ke ɨ yɨpa re pɨs ke. ");
INSERT INTO gdr_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ɨ anerup tin wɨgekitonda da, “Kongga! Nangga pae man yii b'ɨrɨnenyɨt?” Sɨ Mariya ket ten amnonj da, “Ton ke kor Yonggyamɨmna ujgɨm yokasi. Sɨ kon ma wumɨr en rokate Tin yoramisi.” ");
INSERT INTO gdr_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ɨ onggɨt yɨt seg ke Mariya kak wa ɨtaingitonj dɨde Yesund dɨkɨnda onyiti yɨr yongonj. Ajɨ ton maka yongwatonj da Yesute. ");
INSERT INTO gdr_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ɨ Yesu ket tin wɨgekitonj da, “Kongga! Nangga pae man yii b'ɨrɨnenyɨt? Yena man oraka yiyenyɨt?” Ɨ onggɨt konggat ɨja na nony awonj da Ton re onggɨtyam sopapu yɨr ɨpka rɨga e. Sɨ ton Tin yomnonj da, “Ukoyam! Rada manɨt Tin yiyɨt, ken wumɨr nomne rokate man Tin yoramisɨt. Sɨ kon ɨta Tin okatam yopen.” ");
INSERT INTO gdr_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ɨ Yesu ket tin womnonj da, “Mariya!” Sɨ ton ket wɨp yowarkitonj dɨde ket Tin Ibru yɨt ke yomnonj da, “Rabuni!” isɨpkita yɨtkak da ouyaena rɨga. ");
INSERT INTO gdr_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ɨ ket Yesu tin womnonj da, “Goro man Ken netɨsopayɨm! Nokɨp Kon makaya pumb wa neken Kor B'uɨm pɨlwa. Ajɨ man meke Koina gar ke utkunda yɨngganwar wa pɨlwa dɨde ten wumɨr tamninyɨt da, ‘Kon pumb wa neken Kor B'uɨm pɨlwa yete re wa B'u, ɨ Kor Godɨm pɨlwa yete re wa God’.” ");
INSERT INTO gdr_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Seg Magdala tunggam Mariya ket wikonj b'auyaena rɨga wa pɨlwa, dɨde ket bage wikonj da, “Kon kea Yonggyamɨnd yɨr yongen.” Ɨ ket ten wumɨr amninonj rɨja na re Yesu tin wumɨr womnenonj. ");
INSERT INTO gdr_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ɨ onggɨt Ju rɨga waina wɨram dɨde yɨr opmitena bibɨr kak ke naskajog bibɨrɨnd b'auyaena rɨgap kea yɨpand b'eomto sɨ imokand. Ɨ ton re Ju rɨga wa moga mapena mora b'ɨdoki wekenonj. Ɨ odedend ket Yesu yikonj dɨde towa wɨpɨnd onyitonj. Ɨ Ton ket ten amninonj da, “Ngɨmbla wɨn kɨma!” ");
INSERT INTO gdr_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ɨ onggɨt yɨt seg ke Yesu towa auyainonj Tina yɨm dɨde yorora. Sɨ re b'auyaena rɨgap Yonggyamɨnd yɨr yongo, ton ket ma sobijog sam na aukɨto. ");
INSERT INTO gdr_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ɨ Yesu b'usaya ket ten amninonj da, “Ngɨmbla wɨn kɨma! Kor B'u kea Ken nɨtmɨkitonj, ɨ Kodaka odede wɨp kaim wen tetmɨkisinyɨn.” ");
INSERT INTO gdr_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ɨ onggɨt yɨt seg ke Ton nyonya unggulitonj towa pɨlwa dɨde ket ten amninonj da, “Yɨnayɨna Wɨngawɨngand yokata! ");
INSERT INTO gdr_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ra wɨn yama na ra negɨr mɨle awɨr tamnɨkaindam, sɨ onggɨtyam towaina negɨr mɨle ra opima awɨr taukanj. Ɨ ra wɨn towa negɨr mɨle terarkaindam, sɨ towaina negɨr mɨle ra ɨndaima tekeny towa pɨlɨnd.” ");
INSERT INTO gdr_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ɨ twelp (12) ɨtmɨkitijog rɨga wa wɨngɨrɨnd yɨpa rɨga Toma, ɨ ti kwa yɨpa nyɨ da Didimo, ton maike yɨbnonj opimemb nɨnda ɨtmɨkitijog rɨga kɨma, re Yesu towa pɨlɨnd pɨtapɨta awonj. ");
INSERT INTO gdr_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Sɨ onggɨt penaemb nɨnda b'auyaena rɨgap tin wumɨr yomno da, “Sɨn kea Yonggyamɨnd yɨr yongu.” Ajɨ Toma ten amninonj da, “Ra kon maka Tina yɨmɨnd nil yɨra yɨr tangen dɨde ra kon maka onggɨtyam nil yɨra tasopaen koina yɨmkak ke, ɨ dɨde ra kon maka Tina yorora esopaen koina yɨm ke, sɨ kon makwa ɨta gar ke utkunda oramisɨn.” ");
INSERT INTO gdr_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ɨ eit (8) bibɨr kak ke Tina b'auyaena rɨga re b'usaya met wɨngɨr nat wekenonj, sɨ Toma toda omanda ton kɨma yɨbnonj. Ɨ mora re ɨdoki na wekenonj, ajɨ Yesu kea ikonj wɨngɨr wa dɨde ket onyitonj towa wɨpɨnd, ɨ dɨde ket yindonj da, “Ngɨmbla wɨn kɨma!” ");
INSERT INTO gdr_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ɨ Yesu ket Tomand yomnonj da, “Mobe moina yɨmkak teyinɨm dɨkɨnd yɨra esopayam dɨde Koina yɨm yɨr ange. Ɨ moina yɨm teyinɨm dɨde ket Koina yorora yɨra yesopae. Sɨ goro gar ke utkunda kesa rɨga tawɨm, ajɨ gar ke utkunda rɨga na taet!” ");
INSERT INTO gdr_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Seg Toma ket Tin yomnonj da, “Kor Yonggyam dɨde kor God!” ");
INSERT INTO gdr_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Sɨ Yesu tin yomnonj da, “Rɨka nok pae man gar ke utkunda ke nokasɨt, nokɨp kemb man Ken yɨr nonget? Sɨ yepiya ra maka Ken yɨr notngi, ajɨ ton gar ke utkunda ke notkasi, ton re God ma b'ogɨl omni rɨga im.” ");
INSERT INTO gdr_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ɨ Yesu kwa nɨnda jogjog kɨd kesa kɨma danda wɨko amnɨkinonj Tina b'auyaena rɨga wa wɨpɨnd. Ajɨ onggɨtyam wɨko gatab awɨr im ɨrɨki wekeny onggɨt peba wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ajɨ kon onggɨtyam yɨtkak erɨkinyɨn re nok mim da ɨdenat wɨn gar ke utkunda oramisya da Yesu re Keriso e, Godɨmna B'ɨga e, dɨde nokɨm da ɨdenat wɨn gar ke utkunda ke yɨrkokar okasya Tina nyɨwɨm pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ɨ onggɨt kak ke Yesu b'usaya Tilenggyam pɨta awonj Tina b'auyaena rɨga wa pɨlwa Tiberiya sɨpa yurund. Sɨ ɨja naemb jɨ pɨta awonj. ");
INSERT INTO gdr_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Sɨ tonpiyamb jɨ rɨga yɨpand wekenonj opi re Simon Petro ɨ Toma ogenaya da Didimo ɨ Natanael yet re ikonj Kana tungg ke Galili eriya wɨngɨrɨnd ɨ Jebedaimna b'ɨga nɨmog ɨ dɨde kwa nɨmog rɨga osi Yesu ma b'auyaena rɨga wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ɨ Simon Petro ten amninonj da, “Kon kabum ɨwɨka ma neken.” Sɨ toda ket tin yomno da, “Sɨda man kɨma wuyɨn-a.” Ɨ ton ket wuwonj dɨde ket gɨga wa angurkɨto. Ajɨ onggɨt sɨwɨnyɨnd ton makwa nangga na ewɨkto. ");
INSERT INTO gdr_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ɨ re sɨtawarjog awonj, Yesu kea ket onyitonj onggɨt sɨpa yurund. Ajɨ b'auyaena rɨgap Tin maka yongwato da Yesute. ");
INSERT INTO gdr_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ɨ Yesu ket ten arkisinonj da, “Kor b'ɨgawar! Ke ngai nangga kabum na wɨn ewɨkindam?” Ɨ ton mɨra yomno da, “Makwa o.” ");
INSERT INTO gdr_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Sɨ Yesu ten amninonj da, “Gɨr b'ɨska gɨga yɨmjog tab ke! Sɨ wɨn opima kabum temjindam.” Sɨ onggɨt penaemb ton gɨr b'ɨsko ɨ ket ma yɨpa kɨma kabum na gɨr borand wekenonj, sɨ ton ma rɨrɨr na ɨrgɨnatam towaina danda ke. ");
INSERT INTO gdr_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Sɨ onggɨt penaemb Yesu ma ɨtemb singi iyeni b'auyaena rɨgat Petrond yomnonj da, “Yonggyamte!” Seg re Simon Petro yutkundonj da, “Yonggyamte,” ton tina tumɨnd kobɨrgɨm ke b'ibgonj, nokɨp ton wɨ kesa na yɨbnonj. Ɨ ton ket sɨpa wa unykitonj. ");
INSERT INTO gdr_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ajɨ nɨnda b'auyaena rɨgap yɨmta na kabum kɨma gɨr ɨgonyɨgony yiyo gɨga nya de yuru wa, mop nokɨp yuru ke pɨn re ama rɨka nainti (90) mita na. ");
INSERT INTO gdr_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ɨ re ton gɨl wa ɨpkɨto, ton kea yɨr angto wul ɨtani dɨde kabum wulɨnd, ɨ kwa sana. ");
INSERT INTO gdr_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ɨ Yesu ten amninonj da, “Nɨnda kabum teyinam rɨna re wɨn otade ewɨkindam!” ");
INSERT INTO gdr_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Sɨ Simon Petro gɨga wa angitonj dɨde gɨr ɨgonyɨgony yiyonj gɨl wa. Ɨ gɨr borand ukoi kabum re wan andred pipti tri (153) na wekenonj. Ɨ nangga ma jɨ da odede jogjog kabum na, ajɨ gɨr maike ɨnyoukonj. ");
INSERT INTO gdr_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ɨ Yesu ket ten amninonj da, “Tuyɨm ayo! Sɨtawar diyam aina!” Ajɨ b'auyaena rɨga wɨngɨrɨnd makwa yɨpa rɨgat pɨtakɨpɨnd Tin erkitam yomnonj odedemb da, “Yetet Man?” Nokɨp ton kea wumɨr yokato da Yonggyamte. ");
INSERT INTO gdr_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ɨ Yesu ket yikonj sana okatam dɨde ket towa akainonj. Ɨ kwa toda ɨja na kabum yomnɨkonj. ");
INSERT INTO gdr_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ɨ Yesu uj ke Tina utnyita kak ke kea Tina b'auyaena rɨga wa wɨpɨnd pɨta aenonj. Sɨ ɨtemb re jɨ nowa manaemb ket. ");
INSERT INTO gdr_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ɨ re ton sɨtawar diyam seg aukɨto, Yesu Simon Petrond yɨgekitonj da, “Yoanɨmna b'ɨga Simon! Ma man ɨta Ken ukoi singi niyenyɨt ajɨ onggɨtyam nɨnda rɨgap ma ukoi kana e singi niyenyi?” Sɨ Petro Tin mɨra yomnonj da, “Owɨ, Yonggyam! Man wumɨr et da kon ɨta singi miyenyɨn.” Ɨ Yesu ket tin yomnonj da, “Koina mamoi tangeninyɨt!” ");
INSERT INTO gdr_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ɨ Yesu b'usaya Petrond yɨgekitonj da, “Yoanɨmna b'ɨga Simon! Ɨta man Ken singi niyenyɨt?” Sɨ Petro mɨra yomnonj da, “Owɨ, Yonggyam! Man wumɨr et da kon ɨta singi miyenyɨn.” Ɨ Yesu ket tin yomnonj da, “Koina mamoi yɨr tepkinyɨt!” ");
INSERT INTO gdr_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ɨ Yesu nowam ket tin yɨgekitonj da, “Yoanɨmna b'ɨga Simon! Ɨta man Ken singi niyenyɨt?” Sɨ Petro ket gar bebɨg awonj nokɨp Ton nowa manaemb ket tin yɨgekitonj da, “Ɨta man Ken singi niyenyɨt?” Ɨ Petro ket Tin mɨra yomnonj da, “Yonggyam! Man wumɨr et komkesa gasa. Sɨ Man wumɨr et da kon ɨta singi miyenyɨn.” Ɨ Yesu ket kwa tin yomnonj da, “Koina mamoi tangeninyɨt! ");
INSERT INTO gdr_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kon ɨmɨnjogjog men motɨnyɨn. Ɨte re man sisɨl rɨgand mɨbnyɨt, man rɨrɨr e aenyɨt molenggyam rob b'ikonenam dɨde menamenam rɨtata ra man singi taet menonɨm. Ajɨ ra man mid taet, man osiya moina yɨm tetnɨket, ɨ yɨpa rɨgat men rob mitkiteny dɨde ket men mitiyeny rɨtata ra man maka singi taet menonɨm.” ");
INSERT INTO gdr_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu onggɨtyam yɨt yindonj re ouyawa mana da Petro rɨdede nya kae uj okas dem dɨde Godɨm b'ogɨl ɨnyomarena okau dem. Ɨ onggɨt yɨt opurena seg ke, Ton Petrond yomnonj da, “Ken yɨmta nundoke!” ");
INSERT INTO gdr_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ɨ Petro wɨp engendonj dɨde ket yɨrɨk yunjomkitonj ɨtemb Yesu ma singi iyeni b'auyaena rɨgand re tin yɨmta yundokonj. Ɨ tonɨtemb jɨ rɨga yet re Yesum wus ke b'ɨrmekiti omiti yɨbnonj kikitum diyamdiyam wɨnɨnd dɨde Yesund yerkitonj da, “Yonggyam! Yetemb jɨ rɨga ra Men tɨb mii?” ");
INSERT INTO gdr_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ɨ re Petro tin yɨr yongonj, ton ket Yesund yɨgekitonj da, “Yonggyam! Sɨ rɨngma jɨ daka ɨtemb rɨga tau dem?” ");
INSERT INTO gdr_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Sɨ Yesu ket tin mɨra yomnonj da, “Ra Kon singi taen da ton yilo ɨbɨm ngɨrpu ra Kon tɨtenjɨn dem, ɨtemb re ma man kɨma yɨt e. Man yɨmta nundoke!” ");
INSERT INTO gdr_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Sɨ onggɨt penaemb onggɨtyam yɨt warabag aukonj gar ke utkunda nany dɨde yɨngganwar wa pɨlwa da, “Onggɨt b'auyaena rɨgat ma ɨta uj okas.” Ajɨ Yesu maka odede yindonj da, “Ton ma ɨta uj okas,” ajɨ ɨja na da, “Ra Kon singi taen da ton yilo ɨbɨm ngɨrpu ra Kon tɨtenjɨn dem, ɨtemb re ma man kɨma yɨt e.” ");
INSERT INTO gdr_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ton ɨntemb jɨ b'auyaena rɨga yete re yɨr ungata yɨt pɨtapɨta amneniny onggɨtyam gatab dɨde yete re onggɨtyam peba yɨrɨk. Sɨ men wumɨr im da tina yɨr ungata yɨt re ɨmɨnjog im. ");
INSERT INTO gdr_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ɨ opima ta kwa nɨnda jogjog gasa rɨna re Yesu amnɨkinonj. Sɨ rako onggɨtyam komkesa yɨpayɨpa gasa ɨrɨki wekeny, kon nony aen da kupka gowukoyɨt makwa rɨrɨr e onggɨtyam ɨrɨki peba tawaminy. ");
INSERT INTO gdr_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teopilo, koina naskanyam peba wɨngɨrɨnd kon erɨkinond komkesa gasa otomapu ke rɨna re Yesu atomkinonj wɨko omnɨka dɨde ouyaena, ");
INSERT INTO gdr_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ngɨrpu onggɨt bibɨrɨnd re Ton ket Tina obagendi ɨtmɨkitijog rɨga engainonj Yɨnayɨna Wɨngawɨnga ma danda ke da, “Wɨn God ma b'ogɨl yɨrkokar bage yɨt dɨde kwa nɨnda yɨtkak warabag tamnɨkindam!” Dɨde God ket Tin yiyonj de pumb tungg wa. ");
INSERT INTO gdr_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Re Yesu maka pumb tungg wa yikonj, Ton b'ɨdgotnena yokatonj kopa kɨma ɨ dɨde uj awonj. Ɨ ket nowam bibɨrɨnd utnyitonj uj ke ɨ yilo na yɨbnonj. Seg ket poti (40) bibɨr kɨma jogjogpyam Ton Tilenggyam wɨp pɨtapɨta aenonj ouyawam Tina ɨtmɨkitijog rɨga wa pɨlwa. Ɨ dɨde apureninonj God ma pumb tungg gatab yɨt. ");
INSERT INTO gdr_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yɨpa wɨnɨnd re Yesu Tina ɨtmɨkitijog rɨga kɨma yɨpand b'eomkurto, sɨ Ton ket odede b'ingawa yɨt akainonj da, “Goro Yerusalem taun ɨrara, ajɨ yɨr ungaya B'uɨmna tɨrɨr omni yɨt rɨna re wɨn kor pɨlke utkundenonda, ");
INSERT INTO gdr_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","mop nokɨp ɨja emb jɨ yɨna peband ɨrɨki yɨbɨm da, ‘Yoan rɨga baptiso amnɨkinonj re nyɨ kena, ajɨ wɨn ma pɨn e Yɨnayɨna Wɨngawɨnga ke baptiso okatenya.’” ");
INSERT INTO gdr_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ɨngkek ket re ton kwa yɨpand b'eomkurto, rɨgap Yesund yerkito da, “Yonggyam! Rɨngma, ma yu wɨn re ɨtemb wɨn e ra man b'usaya ongapet meraina Israel kantri rɨngmena re yɨbnonj Dawidɨm wɨnɨnd?” ");
INSERT INTO gdr_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Sɨ Yesu daka mɨra amninonj da, “Re B'u Tinajog danda ke wɨn o bibɨr aramkinonj, ɨtemb re ma wanɨm wumɨr okata mim. ");
INSERT INTO gdr_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ajɨ wɨn opima danda temjindam dem ra Yɨnayɨna Wɨngawɨnga wa kumbɨnd tinɨk dem. Sɨ wɨn taukindam dem koina yɨr ungatayam im ɨ tapurenindam dem onggɨtyam kor gatab yɨr ungata yɨt de Yerusalem taunɨnd, ɨ komkesa Yuda eriya wɨngɨrɨnd, ɨ Samariya eriyand, ɨ dɨde ngɨrpu de gowukoi ngɨrpu wa.” ");
INSERT INTO gdr_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ɨ re onggɨtyam yɨt opurena seg awonj, God Yesund pumb wa yurowatonj towa yɨrɨnd. Ɨ ket rɨmɨt tin yɨkangɨndonj towaina yɨr iyoyɨnd, ɨ dɨde ket yɨr ongong kesa awonj. ");
INSERT INTO gdr_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ɨ rɨgap tin yɨr ke kakpɨpɨ ɨdrɨka yiyo ti menonɨnd wub kumb wa. Ɨ towa yɨr kesa borand nɨmog bɨlbɨl kobɨrgɨm b'ikoki kɨma rɨga kea towa yɨu ke onyiti ebnonda. ");
INSERT INTO gdr_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ɨ ket rɨga amninonda da, “Galili rɨga! Nangga paim wɨn dɨkɨnd owɨnki wekenyɨt dea de yɨr wub kumb wa? Ɨtemb Rɨga, Yesu yena re God yii wa pɨlke de wub kumb wa, Ton ɨta tɨtenj dem odede yɨpa wɨp nya ke rɨja na re wɨn Tin yɨr yiya menonɨnd de wub kumb wa.” ");
INSERT INTO gdr_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Onggɨt kak ke ket ton yiwato dor kena nyɨ da Olib, ɨ dɨde ket ɨtekto de Yerusalem taun wa. Ɨtemb dor re ma pɨn e Yerusalem taun ke ama rɨka yɨpa kilomita e. ");
INSERT INTO gdr_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ɨ re ket ton b'ɨgarkɨto de Yerusalem taun kara bora wa, ɨ ket wuwonj yɨpa met wa rɨkɨnd re ten obai amnenento, ɨ dɨde ket ɨjto nɨmogɨm ror kok wa. Sɨ tonpiya de rɨga wekenonj Petro ɨte, Yoan ɨte, Yakobo ɨte, Andrea ɨte, Pilip ɨte, Toma ɨte, Batolomeo ɨte, Matayo ɨte, ɨ Alpayomna b'ɨga Yakobo, ɨ Kanana Rɨga Bobo wɨngɨrɨnd Simon, ɨ dɨde ket Yakobom b'ɨga Yudas. ");
INSERT INTO gdr_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Komkesa onggɨt rɨgap nɨnda kongga yepiya re Yesund yɨmta yundokeneno, ɨ Yesum mog Mariya, ɨ dɨde Yesu ma yɨngganwar kɨma yɨpaina nony menamena nena yoramiteno dɨde ket danda kɨma yɨr opmitento. ");
INSERT INTO gdr_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ɨ onggɨt bibɨr wɨngɨrɨnd, re ama rɨka andred twenti (120) rɨga bobo na yɨpand wekenonj dɨkɨnd demb onggɨt metɨnd, ɨ Petro onyitonj onggɨt gar ke utkunda nany dɨde yɨngganwar wɨngɨrɨnd, ɨ dɨde ket yindonj da, ");
INSERT INTO gdr_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Kor nany dɨde yɨngganwar! Sɨ b'ogla yɨna peba rɨrɨrkɨp rain rɨna re Yɨnayɨna Wɨngawɨnga Dawidɨmna tugɨm ke tulatula wumɨr yoramitonj Yudasɨm gatab yet re wang iyoyam awonj towanɨm yepiya re Yesund yokato negɨr omnam. ");
INSERT INTO gdr_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ton re sɨn kɨma yɨpand ogeni rɨga na yɨbnonj sowa wɨngɨrɨnd, ɨ dɨde ton onggɨtyam sowaina wɨko wɨngɨrɨnd kea yɨpa yingg yokatonj yɨr ɨpkam. ");
INSERT INTO gdr_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ajɨ onggɨt rɨgat mɨra wulkɨp yokatonj negɨr kɨma kaokao mɨle kena rɨna re ton Yesum pɨlɨnd yomnɨkonj. Ɨ ket onggɨt wulkɨp kena gou kɨpol yokatonj tinɨm. Onggɨt kak ke ton ket mop ke mop ke gɨrɨgɨrɨ sap otendonj, ɨ kom ɨnyɨnyɨnd otendonj dɨde komkesa ti kom ɨsarkɨto. ");
INSERT INTO gdr_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ɨ komkesa rɨga wekenonj de Yerusalem taun wa, kea onggɨtyam gatab wumɨr aukɨto, sɨ ton ket ɨtemb gou kɨpol nyɨ yoeko towainajog yɨt ke da ‘Akeldama’, yɨtkak nok ma yindeny da ‘Kus kɨma Gou Kɨpol’.) ");
INSERT INTO gdr_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Mop nokɨp Sam Peba wɨngɨrɨnd Yudasɨm gatab ɨja emb jɨ ɨrɨki yɨbɨm da: ‘Toko tina wɨmenapu pɨpmet rɨga kesa tungg rain, ɨ Goro kwa yɨpat de onggɨt pɨpmetɨnd wɨmena yeken.’ Ɨ kwa ɨrɨki yɨbɨm da: ‘Toko yɨpa rɨgat ket tina pɨpmet yakat.’ ");
INSERT INTO gdr_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Sɨ onggɨt paemb da men b'ogla yabagendu mera wɨngɨrɨnd odede rɨga yet re sɨn kɨma yikenenonj komkesa wɨnɨnd rɨna re Yonggyam Yesu yɨbnenenonj sowa wɨngɨrɨnd Yoanɨmna baptiso otomapu ke ngɨrpu de ɨt re wɨn rɨdenat re God Yesund yiyonj pumb wa mera pɨlke. Sɨ ton b'ogla yɨpa rɨga, yɨr ungatayam tainy sɨn kɨma yɨpand Tina utnyita gatab.” ");
INSERT INTO gdr_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tina yɨt seg ke ton ket nɨmog rɨga awaikito. Yɨpa re Yosepɨt, kwa nyɨ da Barsaba yena re rɨgap kwa yɨpa nyɨ ke yogenayo da Yusto, ɨ yɨpa re Matiyat. ");
INSERT INTO gdr_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Onggɨt kak ke ton ket yɨr opmitto da, “Sowa Yonggyam! Man wumɨr et komkesa rɨgaina gar. Sɨ onggɨt nɨmog rɨga wɨngɨrɨnd yɨpa rɨga nouyaene yena re man yobagendot. ");
INSERT INTO gdr_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Sɨ ton b'ogɨl e okas onggɨtyam wɨko pɨpmet dɨde ɨtmɨkitijog rɨgaina pɨpmet rɨna re Yudas kak yɨawonj dɨde menon yokatonj tinajog obagendi pɨpmet wa.” ");
INSERT INTO gdr_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Seg ket ton towaina obagenda mɨle kena osiemb nɨmog rɨgaina nyɨ aramito gɨmokɨp kumbɨnd, ɨ b'ɨskento odede yɨt kɨma da God toko yabagend yɨpa rɨga. Sɨ ɨngkenaemb Matiyand yobagendo. Sɨ rɨgap Matiyand yeomkito ileben (11) ɨtmɨkitijog rɨga kɨma twelp (12) rɨga awowɨm. ");
INSERT INTO gdr_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yɨpa Ju rɨga waina Godɨm ewangaya wɨn awonj re ogenaya da Pentikos. Ɨ Komkesa gar ke utkunda rɨga yɨpand b'eomkurto onggɨt yɨpaina pɨpmetɨnd. ");
INSERT INTO gdr_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ɨ re ton wekenonj, odedend ket ara dudlam ikonj towa pɨlwa wub kumb ke odede wɨp ɨt re ukoi danda kɨma depu rɨb re dɨde, ɨ ket yɨndangɨr yomnonj komkesa met wɨngɨr rɨkɨnd re ton omnɨki wekenonj. ");
INSERT INTO gdr_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ɨ re ton yɨr pumb wa wuwenonj, ɨtemb gasa ɨja na ikonj wul dɨmɨl pɨla. Ɨ wetaweta aukonj dɨde rɨga yɨpayɨpa kumbɨnd igurka yikenonj. ");
INSERT INTO gdr_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ɨ komkesa rɨga re kea Yɨnayɨna Wɨngawɨngat yɨndangɨr amnɨkinonj dɨde ket danda agoninonj towanɨm opurenam b'engabenga yɨt. Sɨ ton ket b'atomto opurenam onggɨt b'engabenga yɨt ke. ");
INSERT INTO gdr_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ɨ onggɨt wɨnɨnd Godɨnd ewangaya Ju rɨga wuwenonj komkesa b'engabenga kantri ke onggɨt gowukoyɨnd de wɨmenam Yerusalem taun wa ɨtemb Godɨmna wɨn owamam. ");
INSERT INTO gdr_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ɨ onggɨt wɨnɨnd opimemb gar ke utkunda rɨga wuwenonj dɨde kea b'engabenga yɨt opurena eyento ara kɨma. Ɨ re rɨgap utkundento, ɨ ket bobo auka wuwenonj towa pɨlwa. Sɨ rɨgap re wɨnga kesa na aento, mop nokɨp ton towaina opureni yɨtkak utkundento re towainajog yɨt kena. ");
INSERT INTO gdr_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ɨ dɨde kwa ma sobijog na kɨd kesa aena wuwenonj, sɨ ɨja naemb b'arkena wuwenonj da, “Sɨ rɨngma, ma opi re komkesa opurena rɨga re Galili eriya ke rɨga im? ");
INSERT INTO gdr_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Sɨ rɨdede im men komkesa utkundenindam yɨpayɨpa komkesa merainajog get ke yɨt? ");
INSERT INTO gdr_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Men re b'engabenga yɨtam rɨga im, nɨnda re Partiya rɨga im, ɨ nɨnda re Mediya rɨga im, ɨ nɨnda re Elam rɨga im, ɨ dɨde nɨnda re Mesopotamiya ke rɨga im. Ɨ nɨnda re Yuda rɨga im, ɨ Kapadokiya rɨga im. Ɨ nɨnda re Ponto rɨga im, ɨ kwa Asiya rɨga im. ");
INSERT INTO gdr_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ɨ nɨnda re Prigiya rɨga im, ɨ kwa Pampiliya rɨga im. Ɨ nɨnda re Ejipt rɨga im, ɨ kwa Kurene wusɨnd Libiya gatab ke rɨga im. Ɨ dɨde nɨnda re Roma taun ke obayam im. ");
INSERT INTO gdr_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ɨ kwa nɨnda re Ju rɨga im dɨde nɨnda re God ma obagɨki kesa rɨga im yepiya re engento Ju rɨga waina omnɨka mɨle wa. Ɨ nɨnda re Krit rɨga im ɨ dɨde kwa Arab rɨga im. Ɨ men yɨpayɨpa rɨga towaina opureni Godɨmna omnɨki ukoijog mɨle gatab yɨt utkundenindam re komkesa merainajog yɨpayɨpa yɨt kaim.” ");
INSERT INTO gdr_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ɨ ton ket komkesa kɨd kesa aento dɨde nony menamena kesa aukɨto, sɨ ton towalenggyam b'arkento da, “Nangga ma jɨ onggɨtyam mɨle pɨta ainy?” ");
INSERT INTO gdr_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ajɨ nɨndap re ngong na engena eyento dɨde amnento da, “Ton re mogjog na sisɨl ɨk anaikanj.” ");
INSERT INTO gdr_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ɨ ket Petro onyitonj ileben (11) ɨtmɨkitijog rɨga kɨma, ɨ b'okta yɨtpɨam kɨma yɨt apureninonj towa pɨlwa da, “Wɨn, Ju rɨga dɨde komkesa rɨga yepim re wekenyɨt Yerusalem taunɨnd, kon mobe resɨpkenawainɨn, ɨ wɨn wumɨr yokata nangga na re awɨk! Sɨ wɨn b'obogɨl yɨpya aramkina! ");
INSERT INTO gdr_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wɨn ɨja na nony aindam da, ‘Opimemb rɨga re ɨkpɨp im.’ Ajɨ ma ɨja e, mop nokɨp wɨn ɨtemb re sɨtawar nain (9) kɨlok e. Rɨgap ma opima sɨtawarɨnd ɨk anaikenenanj. ");
INSERT INTO gdr_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nayɨ, ma ɨja e, ajɨ ɨtemb re bageyam Yoelɨmna opureni yɨtkak kae awɨk. Sɨ ton ɨja emb jɨ yindeny da, ");
INSERT INTO gdr_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ɨ God yindeny da, ‘Kikitum bibɨrɨnd, Kon ɨta Koina Wɨngawɨnga ɨgmarken dem komkesa rɨga wa pɨlɨnd. Sɨ opima ket waina rɨga b'ɨgap dɨde waina ngɨmngai b'ɨgap bage yɨt tapurenanj dem. Ɨ waina sisɨl rɨgap ket opima liyalliyal gasa yɨr ongong teyenanj dem. Ɨ dɨde waina kesam rɨgap opima wɨma wunga tuweny dem. ");
INSERT INTO gdr_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ɨ kwa ɨta kon koina wɨko rɨga dɨde koina wɨko kongga towa pɨlɨnd Koina Wɨngawɨnga ɨgmarken dem onggɨt bibɨrɨnd, ɨ ton ket bage yɨt tapurenanj dem. ");
INSERT INTO gdr_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Kon moga kɨma danda wɨko pɨtapɨta tamneninyɨn dem de wub kumb wa, sɨ lomkongga ɨta b'etngenj dem sɨbɨbɨm dɨde mobi ɨta b'etngenj dem kuskusɨm. Ɨ kwa kon kɨd kesa kɨma danda wɨko pɨtapɨta tamneninyɨn dem de gowukoi kumbɨnd, sɨ rɨgap opima yɨr tangranj dem kus ɨ wul ɨ dɨde ukoijog bungbung kimbra. Seg ra ket ɨngkaemb ket Yonggyamɨmna bibɨr ik dem ukoi danda kɨma dɨde b'ogɨl ɨnyomarena kɨma. ");
INSERT INTO gdr_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ɨ komkesa rɨga yepiya ra Yonggyamɨnd nyɨ uwatenyi, opima ton yɨrkokar okasi dem.’ ");
INSERT INTO gdr_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Ju rɨga! Wɨn b'obogɨl utkundeninam onggɨtyam yɨtkak rɨna ra kon tapureninyɨn. Sɨ God kea yobagendonj yɨpa rɨga, Najaret tunggam Yesund re wanɨm ouyawa mana jogjog sɨrar kɨma danda wɨko, ɨ kɨd kesa kɨma danda wɨko, ɨ dɨde moga kɨma danda wɨko. Sɨ re Yesu ikonj, Ton ket kea onggɨtyam danda wɨko amnɨkinonj wa wɨngɨrɨnd. Sɨ wɨn kea walenggyam wumɨr ainindam onggɨt wɨko gatab. Ɨ odede nya kenaemb God wa pɨtakɨpɨnd auyainonj da ɨtemb jɨ rɨga yena re God yobagendonj. ");
INSERT INTO gdr_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ɨ God kea Tina ɨsamki singi dɨde Tina get ke wumɨr ke naska nata tɨrɨr yomnonj Yesumna uj gatab, sɨ Ton ɨtemb Yesund wa akainonj. Ɨ wɨn ket Godɨm ewangaya kesa negɨr rɨgaina yɨm engaentondam Tin wul b'agbagɨnd ɨdrɨkam, sɨ wɨnpiya tin yongandonda. ");
INSERT INTO gdr_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sɨ ton uj awonj, ajɨ God kea tina ujɨmna ukoi b'ɨdgotnena ke yɨtrɨngendonj dɨde tin yutnyitonj. Mop nokɨp ujɨt ma rɨrɨr e ti wɨrand Tin emorki owam. ");
INSERT INTO gdr_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Sɨ yɨna peband Dawid ɨja emb jɨ yindeny onggɨt ti gatab da, ‘Kon naska nata Yonggyamɨnd yɨr yongenenond ita wɨnɨnd kor wɨp ke, nokɨp Ton re kor yɨmjog yɨm tab kae yɨbɨm juwai kɨma pɨpmetɨnd, nokɨm da ɨdenat Ton danda kɨma yɨm notkaeny dɨde kon makwa ɨta b'utuwongnenyɨn rɨnggɨt bebɨg wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ɨ kon ukoi gar sam aukenenyɨn dɨde kon ukoi sam kɨma im yɨtkak apureninyɨn, ɨ kwa daka kon jɨ ke yilo nɨtɨbnyɨn ra warɨm b'ogɨl ɨsma okata ma. ");
INSERT INTO gdr_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Mop nokɨp Man ma ɨta koina wɨngawɨnga uj rɨgaina tungg wa ɨraret dem, dɨde kwa Man ma ɨta Moina yɨna b'ɨgand ɨtkɨki yɨr onget dem. ");
INSERT INTO gdr_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Man kemb kor nouyawot nya rɨngkae ra rɨgap yɨrkokar okasi. Sɨ ra kon neken dem Mor wɨp wa, Man ɨta ken sam ke yɨndangɨr notɨnyɨt dem.’ Sɨ onggɨt rɨrɨr natemb God Yesund yutnyitonj. ");
INSERT INTO gdr_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Kor nany dɨde yɨngganwar! Kon b'ogɨl e moga kesa danda kɨma nitinjɨn wa pɨlwa mera b'u Dawidɨm gatab. Ton ke uj awonj, ɨ rɨgap gop wa yoramito, sɨ tina gopmet re ɨta yɨbɨm men kɨma ngɨrpu yu. ");
INSERT INTO gdr_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dawid re Godɨmna bageyam na yɨbnonj, ɨ God kea danda kɨma Tina nyɨ kɨma tin yomnonj da, ‘Kon ɨta moina b'ɨgawar wa pɨlke yɨpa rɨga omisɨn dem moina king pɨpmetɨnd rɨngkae ra ton koina rɨga wɨp tamniny dem.’ Sɨ ɨngkenaemb Dawid wumɨr yokatonj onggɨtyam Godɨmna tɨrɨr omni yɨtkak. ");
INSERT INTO gdr_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Sɨ ton re naska nata Kerisomna utnyita gatab yɨr yongonj, ton ket yindonj da, ‘God makwa ɨta Tina wɨngawɨnga ɨrar dem uj rɨga waina tungg wa, sɨ Tina jɨ makwa ɨta tɨtkɨk dem.’ ");
INSERT INTO gdr_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Godɨt ɨtemb rɨga Yesund yutnyitonj. Ɨtemb Yesu re Keriso e. Sɨn komkesa re yɨr ungatayam im Tina utnyita gatab. ");
INSERT INTO gdr_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ɨ God Tin yurowatonj dɨde yomitonj Tina yɨmjog yɨm tab ke juwai kɨma pɨpmetɨnd. Ɨngkenaemb ket Yesu yokatonj Yɨnayɨna Wɨngawɨnga Godɨm pɨlke rɨna re God tɨrɨr yɨt yomnonj Ti okawam, ɨ Ton ket yɨgmarɨk sowa pɨlɨnd. Sɨ ɨntemb jɨ onggɨtyam Yɨnayɨna Wɨngawɨngam pɨlke auki gasa rɨnte re wɨn yu yɨr yongya dɨde utkundenya. ");
INSERT INTO gdr_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ɨ Dawid re maka yikonj de pumb tungg wa, ajɨ ton ɨja naemb jɨ yindonj da, ‘Yonggyam God, Ton kor Yonggyam Kerisom pɨlwa yindonj da, “Omite Koina yɨmjog yɨm tab ke juwai kɨma pɨpmetɨnd, ");
INSERT INTO gdr_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ngɨrpu ra ket Kon Moina komkesa geja rɨga gou wa tamninyɨn dem dɨde taramisinyɨn dem Moina pɨs wɨrand moina danda ondratenam towa kumbɨnd.” ’ ");
INSERT INTO gdr_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Sɨ onggɨt paemb wɨn, komkesa Ju rɨga, b'obogɨl wumɨr yokata Yesum gatab! Wɨnpiya ɨtemb rɨga Yesund wul b'agbagɨnd yɨdrɨkonda. Ajɨ Godɨt Tin yutnyitonj, sɨ ket Yonggyamɨm dɨde Kerisom yomnonj.” ");
INSERT INTO gdr_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ɨ re ket rɨgap ɨtemb tina yɨt utkundeno, sɨ ton ket ma sobijog na gar kopa aukɨto. Ɨ ton ket arkento Petro dɨde nɨnda ɨtmɨkitijog rɨga da, “Sowa nany dɨde yɨngganwar! Nangga e sɨn ket omnɨku?” ");
INSERT INTO gdr_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ɨ Petro mɨra amninonj da, “Gar engenjinam negɨr mɨlem pɨlke de Godɨm pɨlwa dɨde wɨn yɨpayɨpa Yesu Kerisomna nyɨ kɨma baptiso yokatena waina negɨr mɨle awɨr omnɨkam! Seg ra ket, God wanɨm onggɨtyam yiyag wurar takainy ra Yɨnayɨna Wɨngawɨnga e. ");
INSERT INTO gdr_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mop nokɨp ɨtemb re Godɨmna tɨrɨr omni yɨt e wanɨm ɨ waina b'ɨgawarɨm ɨ dɨde towanɨm komkesa yepim re paja wa wekeny rokate ta gowukoi ngɨrpu, yena ra mera Yonggyam God ara temoneniny.” ");
INSERT INTO gdr_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ɨ kwa Petro nony aukam jogjog b'engabenga yɨt ke ten amneninonj, dɨde b'ugowa yɨt ten amneninonj da, “Wɨn ewaikurinam rɨga wa pɨlke yepim re yu onggɨt gowukoyɨnd wekeny negɨr kaokao mɨlend, ɨ ket yɨrkokar yokata Godɨm pɨlke!” ");
INSERT INTO gdr_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Sɨ rɨga yepiya re tina yɨt gar ke emjatento, ton kea Yesund gar ke yokato dɨde baptiso yokateno. Ɨ onggɨt bibɨrɨnd ama rɨka tri tausɨn (3,000) rɨga na yɨpand aukɨto gar ke utkunda rɨga kɨma. ");
INSERT INTO gdr_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ɨ ton danda kɨma onggɨtyam mɨle owama eyento re ɨja naemb jɨ. Ton yɨpaina gar singi kɨma b'eomenento ɨtmɨkitijog rɨgaina ouyaena okatam ɨ towalenggyam towalenggyam yɨpand yɨm b'akaenam, ɨ sana ipkɨkam aretom, ɨ dɨde kwa yɨpand yɨr opmitenam. ");
INSERT INTO gdr_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","God engainonj ɨtmɨkitijog rɨga, sɨ ton ket amnɨkenento jogjog moga kɨma danda wɨko dɨde kɨd kesa kɨma danda wɨko. Sɨ onggɨt penaemb komkesa rɨga ɨsnawa kɨma moga aukenento. ");
INSERT INTO gdr_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ɨ komkesa gar ke utkunda rɨga yɨpa pɨpmetɨnd b'eomenento, ɨ towa wɨngɨrɨnd towaina nony menamena yɨpand aramkenento. Sɨ ton komkesa towaina gasa gɨlgɨl na ingaena eyenento. ");
INSERT INTO gdr_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ɨ towa wɨngɨrɨnd nɨnda rɨga towaina gou kɨpol dɨde gasa asogenento, ɨ ket ɨtaika eyenento komkesa rɨga wa yepiya re ingaena gasam b'arakenento. ");
INSERT INTO gdr_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ɨ ton ita bibɨr yɨpand nony menamena kɨma yɨnamet aband danda kɨma b'eomenento. Ɨ ton ket ita gar ke utkunda rɨgaina metɨnd sana epkɨkenento Yesund nony iyenam, sɨ ton ukoi sam kɨma dɨde kɨlkɨp kesa nony menamena kɨma owou awenento. ");
INSERT INTO gdr_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ɨ ton ket Godɨnd yesoureneno, ɨ komkesa rɨgap ten yɨr angenento re ma sobijog na ten gar ke singi eyenento. Ɨ Yonggyam daka ket ita bibɨr rɨga wa yɨrkokar agoneneninonj, sɨ ket gar ke utkunda rɨgaina bobo re kea ukoi warabag auka yikenonj. ");
INSERT INTO gdr_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ɨ yɨpa bibɨrɨnd re yɨr opmita wɨn awonj tri (3) kɨlokɨnd sɨmana gatabɨnd, Petro ake Yoan ekonda yɨnamet wa yɨr opmitam. ");
INSERT INTO gdr_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ɨ onggɨt wɨnɨnd yɨpa gomgom rɨga yɨbnonj yet re ti mogɨm kom bora ke ɨja na ukendonj. Ɨ ita bibɨrɨnd rɨgap tin yiyeneno yɨpa yɨnamet kara mora wa nyɨ da “Otomanti Mora” ɨ yomiteneno mora dunda wa wulkɨp b'ɨjenenam rɨga wa pɨlke yepiya re b'ɨgarkenento yɨnamet aba wa. ");
INSERT INTO gdr_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Re Petro ake Yoan sisɨl opendonda onggɨt mora dunda wa b'ɨgaram yɨnamet aba wa, onggɨt rɨgat ten yɨr angonj dɨde wulkɨp ejenenonj. ");
INSERT INTO gdr_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ajɨ Petro Yoan kɨma yɨpand ti pɨlwa yɨr ɨsokonda, ɨ ket Petro yomnonj da, “Yɨr de sowa pɨlwa!” ");
INSERT INTO gdr_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Sɨ ton gomgom rɨgat ket nonyɨk b'amdenonj da, “Ɨta ngai ama rɨka towa pɨlke nɨnda wulkɨp takasinyɨn,” ɨ ket yɨr awonj towa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ɨ ket Petro yomnonj da, “Kor awɨr im gold o silba, ajɨ kon ɨna nena e motkaen onggɨtyam gasa nanggamog e re kor nɨbnau. Najaret tunggam Yesu Kerisomna danda nyɨ kɨma utnyite, ɨ menon yokate!” ");
INSERT INTO gdr_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ɨ Petro ket yemoratonj tina yɨmjog yɨmɨnd, ɨ ket tin yutnyitonj. Ɨ odenja ket tina pɨs dɨde kenykak danda kɨma aukɨto. ");
INSERT INTO gdr_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ɨ ton ket b'ukenykitonj dɨde onyitonj, ɨ menon yokatonj, ɨ ket Petro ake Yoan kɨma yɨpand b'ɨgarkɨto yɨnamet aba wa. Re ɨsakendi rɨga yɨnamet aba wa b'ɨgaronj, ton yikenonj, ɨ b'atiyakenonj, ɨ dɨde Godɨnd yesourenonj. ");
INSERT INTO gdr_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ɨ re komkesa rɨgap tin yɨr ongong yiyeno ti menonɨnd dɨde Godɨnd esourenand, ");
INSERT INTO gdr_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ton kea tin yongwato da ɨntaemb jɨ rɨga yete re wulkɨp b'ɨjenenam omiti yɨbneneny yɨnamet Otomanti Mora dundand. Ɨ ton ket ma sobijog na kɨd kesa dɨde wɨnga kesa aento onggɨt gatab rɨna re ti pɨlɨnd aukonj. ");
INSERT INTO gdr_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Re ɨsakendi rɨgat Petro ake Yoan amorkonj yɨpa dɨr kesa metɨnd ogenaya da “Solomonɨmna Met”, ɨ komkesa rɨga wɨnga kesa na aena wuwenonj dɨde yɨpand b'ɨkento towa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Re Petro rɨga yɨr anginonj, ton ket amninonj da, “Israel rɨga! Nangga paim wɨn kɨd kesa aenindam onggɨt gatab, ɨ nangga paim wɨn nony menamena amnɨkindam da sɨn tin yɨsakenjya menamenam sowainajog danda ke o sowaina omnɨki Godɨm pɨlwa yɨna mɨle ke, dɨde ket odede nony kɨma yɨr ɨsokindam sowa pɨlwa? ");
INSERT INTO gdr_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Sɨ Abraamɨmna God ɨ Isakɨmna God ɨ Yakobɨmna God, mera b'uwar waina God, Tonɨt Tina wɨko rɨga Yesund yutnyitonj dɨde b'ogɨl ɨnyomarena yokawonj. Wɨnpiyamb ɨtemb Rɨga Yesund yokawonda ɨ yoramitonda Pilatom pɨlwa ongandam. Ɨ re ton b'ɨsagɨka yomnɨkonj Tin opendam, ajɨ wɨn yoenonda Tin opendam. ");
INSERT INTO gdr_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Sɨ wɨn yoenonda onggɨt yɨnayɨna dɨde dɨmdɨmjog Rɨgand, ajɨ wɨn Pilatond yerkitonda negɨrjog rɨgand opendam wanɨm. ");
INSERT INTO gdr_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Sɨ wɨnpiya yongandonda yɨrkokar otobarkayamɨnd. Ajɨ Godɨt Tin yutnyitonj uj ke. Sɨn re onggɨtyam Tina utnyita gatab yɨr ungata rɨga im. ");
INSERT INTO gdr_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Sɨn onggɨtyam Yesumna danda nyɨ na gar ke yokatonda. Ɨ re kon onggɨt tina danda nyɨwɨnd tin yingaen, sɨ onggɨtyam tina danda nyɨwɨt tin dandam yomɨny. Dɨde ket Yesum pɨlɨnd gar ke utkundat tin odede kupkakupka b'ogɨl yomɨny komkesa wa wɨpɨnd. Sɨ wɨn kemb ɨtemb tin yɨr yongya dɨde wumɨr yokasya. ");
INSERT INTO gdr_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Kor nany dɨde yɨngganwar! Yu kon wumɨr yokasɨn da wɨn maka b'obogɨl wumɨr aukɨtondam yete Yesu. Sɨ onggɨt penaemb jɨ odede Ti pɨlɨnd yomnɨkonda, ɨ waina wɨp iyoi rɨgap toda kwa kea odede mɨle amnɨkenento wɨn re dɨde. ");
INSERT INTO gdr_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ajɨ God kea tulatula komkesa Tina bageyam wumɨr amneninonj pɨtapɨta omnenam da Tina Keriso ɨta b'ɨdgotnena okateny dem. Sɨ ɨtemb re kemb Yesum pɨlɨnd rɨrɨrkɨp awonj waina omnɨki mɨle ke. ");
INSERT INTO gdr_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Sɨ onggɨt paemb wɨn gar b'engenjinam negɨr mɨle ke de Godɨm pɨlwa dɨde Ti pɨlwa ɨtenjinam! Nokɨm da ɨdenat God waina negɨr mɨle teomneniny. ");
INSERT INTO gdr_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ɨ ɨdenatemb b'ogɨl ngɨmbla wɨn tuweny wa pɨlwa dɨmdɨm Yonggyamɨm pɨlke, ɨ ket God ɨta wa b'usaya tetmɨkitau Keriso Yesund yena re Tin tula yobagendonj wanɨm b'ogɨlɨm. ");
INSERT INTO gdr_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ɨtemb re Yesu b'ogla ɨbɨm de pumb tungg wa, ngɨrpu ra onggɨtyam wɨn ik dem ɨt re ra God komkesa gasa sisɨl tamnɨkiny dem. Seg ket ton ik dem. Mop nokɨp God kea get ke Tina yɨna bageyam odede yɨt omnena teyinonj pɨtapɨta omnenam. ");
INSERT INTO gdr_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ɨ Mose odede yindonj da, ‘Wa Yonggyam God ɨta wa wɨngɨrɨnd onyis dem yɨpa bageyam wainajog b'ɨga wa pɨlke odede kon re dɨde. Sɨ wɨn b'ogla tin utkundenya dem nanggamog yɨtkak im ra Ton wanɨm tapureniny dem! ");
INSERT INTO gdr_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Yet ra maka onggɨt bageyamɨmna yɨtkak tutkundeny, God ɨta kupkakupka tina nyɨ eomneny dem pumb tungg rɨga wa pɨlke.’ ");
INSERT INTO gdr_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Ɨ kwa daka komkesa bageyam, Samuwel dɨde yepiya re ti kak ke tuwonj, kea toda opurena dɨde pɨtapɨta omnena teito onggɨtyam komkesa wɨn gatab. ");
INSERT INTO gdr_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ɨ wɨn re onggɨtyam bageyam waina yɨt owabɨndena rɨga im, nokɨp wɨn re towaina b'ɨga im. Ɨ God Abraamɨm yokawonj outɨnti tɨrɨr omnijog yɨtkak, ɨ ket yomnonj da, ‘Ɨ moina kus ke b'ɨgam pɨlkae Kon komkesa gowukoi b'engabenga yɨtam rɨga b'ogɨl tamninyɨn dem.’ Ɨ dɨde Ton kea ket onggɨtyam outɨnti tɨrɨr omnijog yɨt wa b'uwar wa agoneneninonj. Sɨ wɨn re onggɨtyam outɨnti tɨrɨr omnijog mal yɨtkakɨmna owabɨnta rɨga im. ");
INSERT INTO gdr_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Sɨ re God Tina wɨko rɨga Yesund yonyitonj, Ton ket naska nata yɨtmɨkitonj Ju rɨga wa pɨlwa wen b'ogɨl omnam, nokɨm da ɨdenat wɨn yɨpayɨpa rɨgap terarkindam waina negɨrjog mɨle dɨde ket gar b'etngenjindam de Ti pɨlwa.” ");
INSERT INTO gdr_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ɨ re Petro ake Yoan rɨga yɨt amneninonda, yɨna sɨ rɨga ɨ yɨnamet yɨr ɨpka geja rɨga waina mopyam ɨ dɨde Sadukai rɨga tuwonj towa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ɨ re ton tuwonj towa pɨlwa, Petro ake Yoan rɨga auyaeninonda Yesum gatab dɨde pɨtapɨta amneninonda da, “Yesu ke uj ke utnyitonj. Sɨ yet ra man Tin gar ke okasɨt mada ɨta tutnyisɨt dem uj ke.” Sɨ ton kea onggɨtyam towaina yɨt utkundo. Ɨ ton ket ma sobijog na gar negɨr aukɨto. ");
INSERT INTO gdr_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Sɨ ton ket ten yɨmɨnd akato ɨsagɨkam. Ajɨ kea bibɨr wɨn awɨr awonj. Sɨ ton singi auto ɨspari ke b'ɨsagɨka mɨle omnɨkam. Ɨ ket ten egaro sɨbɨbmet wa. ");
INSERT INTO gdr_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ajɨ ma yɨpa kɨma rɨgapiya towaina yɨt utkundeno dɨde towa wɨngɨrɨnd jogjog rɨgap kea Yesund gar ke utkunda ke yokateno. Sɨ onggɨtyam gar ke utkunda rɨga bobo re kea warabag aukonj, sɨ komkesa rɨgajog ogenki re ama rɨka paib tausɨn (5,000) na. ");
INSERT INTO gdr_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ɨ ɨspari ke ket Ju rɨga waina wɨp iyoi rɨgap ɨ elda rɨgap ɨ dɨde Ju rɨga waina gog ouyaena rɨgap yɨpand b'eomkurto Yerusalem taun wa. ");
INSERT INTO gdr_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ɨ dɨde yɨna mopyam sɨ rɨga Anna ɨ Kayapa ɨ Yoan ɨ Aleksandro ɨ dɨde komkesa yɨna mopyam sɨ rɨgamna gu rɨgawar kea omnɨkto de onggɨt b'ɨsagɨkapu pɨpmetɨnd. ");
INSERT INTO gdr_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ɨ ton ket Petro ake Yoan teyo onggɨt b'ɨsagɨkapu pɨpmet ɨnyɨny wa dɨde ket anyito. Ɨ ton ket arkeno da, “Wɨn nanggamog danda kɨma na o yaina nyɨ kɨma na onggɨtyam mɨle yomnɨkma?” ");
INSERT INTO gdr_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Onggɨt wɨnɨnd Yɨnayɨna Wɨngawɨngat Petrond yɨndangɨr yomnonj, ɨ Petro ket ten mɨra amninonj da, “Wɨn sowa wɨp iyoi rɨga dɨde elda rɨga! ");
INSERT INTO gdr_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ɨt re yu wɨn sɨn nerkenya onggɨtyam gomgom rɨga b'ogɨl omna gatab da, ‘Rɨja na onggɨt rɨgat b'ogɨl yokasɨm?’ ");
INSERT INTO gdr_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Wɨn komkesa dɨde komkesa Israel rɨga! Wɨn b'ogla wumɨr taindam! Onggɨt gomgom rɨgat b'ogɨl yokasɨm dɨde ton onyiti yɨbɨm wa wɨpɨnd kupka danda kɨma. Onggɨtyam mɨle aukonj re Najaret tunggam Yesu Kerisomna nyɨ kena. Wɨnpiya onggɨt Yesund wul b'agbagɨnd yɨdrɨkonda, ajɨ Godɨt Tin yutnyitonj uj ke. ");
INSERT INTO gdr_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Sɨ ɨja emb jɨ yɨna pebat Ti gatab yindeny da, ‘Yɨpa Motɨr wɨn met oranga rɨgap b'ɨsayonda met orangam, ajɨ God ket yɨmta ke met wugɨnd yoramitonj onggɨt met emorkam. Sɨ ton ket ɨmɨnjog ɨsnawa kɨma Motɨr na awonj onggɨt met oranga wɨngɨrɨnd.’ Sɨ Yesu re onggɨtyam Motɨr e. ");
INSERT INTO gdr_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Sɨ yɨpaina nena Yesumna nyɨ kae rɨgap rɨrɨr e yɨrkokar okatenyi. Ajɨ rɨgat makwa rɨrɨr e yɨrkokar okas b'enga rɨgam pɨlke, mop nokɨp God makwa yɨpa b'enga rɨgamna nyɨ yoramitonj rɨga wa wɨngɨrɨnd meranɨm yɨrkokar okatam onggɨt gowukoyɨnd.” ");
INSERT INTO gdr_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ɨ ton get ke wumɨr na da Petro ake Yoan re sɨkɨl kesa rɨga i dɨde multekɨp kesa rɨga i. Ajɨ re ton ten yɨr ango moga kesa danda kɨma opurenand, ton ma sobijog na wɨnga kesa aento. Sɨ ton ten omanda nonyɨnd awamo da ton re ke Yesu kɨma ebnonda. ");
INSERT INTO gdr_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ɨ ton singi na da towaina yɨt gou wa omnam, ajɨ re ton yɨr yongo onggɨt rɨgand yet re b'ogɨl yokatonj onyitand ton kɨma, sɨ ton towa ket makwa nangga yɨt na opurenam aukɨto. ");
INSERT INTO gdr_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Sɨ onggɨt penaemb ten engawo opendam bau wa onggɨt Sanedrin kot ke, seg ket ton yɨpand yɨt yɨgleneno towa wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ɨ ket b'arkena wuwenonj da, “Nangga e men omnɨku onggɨt rɨga wa pɨlɨnd? Ton re kea ukoijog kɨd kesa kɨma danda wɨko yomnɨkma dɨde komkesa rɨga yepim re wekeny Yerusalem taunɨnd kea wumɨr yokatenyi onggɨt gatab. Sɨ meda kwa ma rɨrɨr im b'aitiyenindam. ");
INSERT INTO gdr_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Sɨ men b'ogla ten danda kɨma mogam tamnyu da, ‘Goro kwa ngai yɨpa rɨgam pɨlwa onggɨt nyɨwɨnd tapurenina!’ Ke onggɨtyam yɨtkak warabag auka yeken rɨga wa wɨngɨrɨnd, ɨ dɨde kwa ke nɨnda rɨga wumɨr raukine.” ");
INSERT INTO gdr_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Seg ket, kwa b'usaya ten ara emoko. Re Petro ake Yoan b'ɨgaronda, ton ket b'ingawa yɨt amno da, “Goro kwa ngai tapurenina, o goro kwa ngai tauyaenina Yesumna nyɨwɨnd!” ");
INSERT INTO gdr_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ajɨ Petro ake Yoan daka ten mɨra amninonda da, “Wɨn walenggyam b'ɨsagɨkinam Godɨm wɨpɨnd! Ra sɨn waina yɨt b'obogɨl yɨmta undokya, ajɨ ra Godɨmna yɨt maka b'obogɨl yɨmta undokya, sɨ rɨngma, ɨtemb re dɨmdɨm mɨle e? ");
INSERT INTO gdr_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Sɨ onggɨt paemb sɨn ma rɨrɨr i b'atgokya opurenam Ti gatab yɨtkak rɨna re sɨn yɨr anginonda sowainajog yɨr ke dɨde utkundeninonda sowainajog yɨpya ke.” ");
INSERT INTO gdr_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Sɨ ton pop nya oraka eyento ten bebɨgɨnd oramitam, ajɨ ma rɨrɨr na. Sɨ ton ket ten b'usaya mogam amneno, nokɨm da ɨdenat ton maka rɨga tauyaeninya Yesu ma nyɨwɨnd, ɨ ket ten etrɨngendo. Mop nokɨp komkesa rɨgap kea Godɨnd esourena yiyeno onggɨt mɨle gatab rɨna re gomgom rɨga b'ogɨl yokatonj kɨd kesa kɨma danda wɨkom pɨlke. ");
INSERT INTO gdr_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nokɨp onggɨt rɨgamna kemag re kea ama rɨka poti (40) na yɨbnawonj. ");
INSERT INTO gdr_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Re Petro ake Yoan opendonda dɨde ɨtendonda towainajog gar ke utkunda rɨga wa pɨlwa, ton ket pɨta amnenainonda komkesa yɨt rɨna re yɨna mopyam sɨ rɨga dɨde Ju rɨga waina elda rɨgap apurento towa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ɨ re gar ke utkunda rɨgap utkundento onggɨtyam towaina yɨt, ton ket yɨpaina nonykok ke Godɨnd b'okta yesoureno da, “Sowa danda Yonggyam! Manɨt atobarkinot wub ake gou dɨde sɨpa, ɨ dɨde komkesa gasa onggɨt wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Manɨt Yɨnayɨna Wɨngawɨnga ke Moina wɨko rɨga sowa b'u Dawidɨnd yɨndangɨr yomnot, ɨ ton ket sowa Yonggyam Yesum gatab yindonj tina tugɨm ke da, ‘Nangga pena yɨtam b'engabenga gar soro aukɨto Yonggyamɨm pɨlwa, dɨde nangga pena komkesa God ma obagɨki kesa rɨgap kɨp kesa yɨt ɨsamka yiyeno Ti gatab? ");
INSERT INTO gdr_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Gowukoi kingɨp owɨnkɨto dɨde wɨp iyoi rɨgap yɨpand b'eomkurto Yonggyamɨnd negɨr omnam dɨde Tina obagendi Kerisond negɨr omnam.’ ");
INSERT INTO gdr_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Moina yɨt re ɨmɨnjog e. Sɨ Erod ake Pontiyo Pilato, ɨ God ma obagɨki kesa rɨgap, ɨ dɨde Israel rɨgap ɨmɨnjog na yɨpand gɨlgɨl b'eomkurto onggɨt Yerusalem taunɨnd Moina yɨna wɨko rɨga Yesund negɨr omnam yena re Man yobagendot gaya eauka ke. ");
INSERT INTO gdr_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Onggɨtyam mɨle aukonj re Moina yɨtkak rɨrɨrkɨp omnam e rɨna re Man Moina danda ke dɨde Moina singi ke tula yɨsamkot aukam. ");
INSERT INTO gdr_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Sowa Yonggyam! Man ket yu yɨr teyeninyɨt towaina moga b'amnena mɨle. Sɨn re Moina wɨko rɨga im. Sɨ Man sɨn yɨm notkainyɨt, sɨ sɨn ɨdenat Moina yɨtkak kupka juwai kɨma moga kesa tusenenindam. ");
INSERT INTO gdr_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ɨ ra sɨn Moina yɨtkak kupka juwai kɨma tusenenindam, Man Moina yɨm b'ɨtnɨket sowa pɨlɨnd dɨde danda notkainyɨt. Sɨ ɨngkaimemb sɨn kopa rɨga b'ogɨl tamnɨkindam dɨde kwa Moina yɨna wɨko rɨga Yesumna nyɨ kaim pɨtapɨta tamnenindam kɨd kesa kɨma danda wɨko dɨde moga kɨma danda wɨko.” ");
INSERT INTO gdr_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ɨ re ton yɨr opmita seg auto, God yɨjgɨndenonj onggɨtyam pɨpmet rɨkɨnd re ton b'eomto. Ɨ Ton odenja ten Yɨnayɨna Wɨngawɨnga ke yɨndangɨr amnɨkinonj dɨde ket ton moga kesa God ma yɨt kupka juwai kɨma moga kesa apurento. ");
INSERT INTO gdr_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Onggɨtyam gar ke utkunda rɨga bobo, towaina nonykok dɨde gar re yɨpa nat auto. Ɨ ket makwa yɨpa rɨgat tina gasa gatab yindenonj da, “Kor mima koinajog gasa.” Ajɨ kea ton towa wɨngɨrɨnd komkesa gasa gɨlgɨl yingg eyento. ");
INSERT INTO gdr_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ɨ ɨtmɨkitijog rɨgap yɨr ungata yɨt apurento ukoi danda kɨma Yonggyam Yesumna utnyita gatab. Ɨ kwa God ma ukoi wurar re kea komkesa gar ke utkunda rɨga wa kumbɨnd yɨbnonj. ");
INSERT INTO gdr_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Sɨ makwa yɨpa rɨga ingaena gasa kesa yɨbnonj towa wɨngɨrɨnd, nokɨp yepiya re gou kɨpol o met owama eyento, ton asogenento dɨde wulkɨp emdenento, ɨ ket eyenento mɨra wulkɨp ɨtmɨkitijog rɨga wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ɨ ket b'ɨsnawa kɨma aramkenento ɨtmɨkitijog rɨga wa wɨpɨnd. Ɨ ton ket esos eyenento yɨpayɨpa rɨga wa pɨlwa yepiya re ingaena gasa kesa wekenenonj. ");
INSERT INTO gdr_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yɨpa Lebi gu ke rɨga yɨbnonj re Yosepɨt yet re Kipriyo ailan wa ukendonj. Ɨ ɨtmɨkitijog rɨgap daka tin nyɨ yoeko da Banaba, engenda yɨtkak da b'ugowam b'ɨga. ");
INSERT INTO gdr_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ɨ todaka odede yɨpa wɨp nya ke tina owami gou kɨpol yosogonj, dɨde ket mɨra wulkɨp teyinonj, ɨ dɨde ket b'ɨsnawa kɨma aramkinonj ɨtmɨkitijog rɨga wa wɨpɨnd esosɨm. ");
INSERT INTO gdr_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Sɨ yɨpa rɨga, nyɨ da Ananiya, ti kongga Sapira kɨma towaina gou kɨpol yosogonda. ");
INSERT INTO gdr_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ɨ Ananiya yɨpa tab wulkɨp yokatonj towanɨm onggɨtyam mɨra wulkɨp wɨngɨrɨnd dɨde yegitonj. Ɨ ton ket ti konggand b'obogɨl wumɨr womnonj. Seg ket ton eyinonj komb wulkɨp ɨtmɨkitijog rɨga wa pɨlwa, ɨ b'ɨsnawa kɨma aramkinonj. ");
INSERT INTO gdr_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ɨ Petro ket yomnonj da, “Ananiya! Rɨdede na man b'anygɨnena nya ke mɨra wulkɨp yɨpa tab yomnɨket? Moina gar re kea Satanat yɨndangɨr yomɨny. Sɨ ma man kea Yɨnayɨna Wɨngawɨngand rabem yomnenyɨt dɨde ket gou kɨpol mɨra wulkɨp ke yɨpa tab yegisɨt? ");
INSERT INTO gdr_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Sɨ re naskand man maka yosogot onggɨtyam gou kɨpol, ɨtemb re mor yɨm nat yɨbnonj. Ɨ kwa re man mɨra wulkɨp akasinot, opimemb wulkɨp re kwa moina b'ingawa wɨra nat wekenenonj. Sɨ onggɨtyam gou kɨpol dɨde mɨra wulkɨp re mor singi rɨrɨr nat wekenenonj omnɨkam. Ajɨ nangga pae man odede negɨr nony menamena yoramisɨt moina gar wa? Man ma rɨga na rabem amneninyɨt, ajɨ God na.” ");
INSERT INTO gdr_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Re Ananiya onggɨtyam yɨt utkundenonj, ton ket uj sap otendonj gou wa. Ɨ komkesa rɨga yepiya re utkundo onggɨtyam gatab yɨt, ton ma sobijog na moga aukɨto. ");
INSERT INTO gdr_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Sɨ ket sisɨl rɨgap owɨnkɨto, ɨ ket tina ujgɨm kukum yomnɨko, ɨ dɨde ket yiyo dɨde gop wa yeungito. ");
INSERT INTO gdr_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ɨ ti kongga Sapira ma wumɨr na wɨbnonj nangga na re aukonj ti leom pɨlɨnd. Ɨ ket nowa awa seg ke todaka tikonj de onggɨt b'eomapu wa. ");
INSERT INTO gdr_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ɨ ket Petro werkitonj da, “Wumɨr nomne! Ma ɨnsima waina okati mɨra wulkɨp?” Ɨ todaka mɨra yomnonj da, “Owɨ, ɨnsimaemb.” ");
INSERT INTO gdr_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Sɨ Petro ket tin womnonj da, “Nangga pena wɨn molkongga yɨpand odede yɨt yɨsamkya negɨr nya ke otonkenam Yonggyamɨmna Wɨngawɨnga? Yɨr de, rɨga yepiya re mor leond eungitam yiyi re opima ke mora dunda nasim. Ɨ ɨta kwa meda miyi dor.” ");
INSERT INTO gdr_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ɨ odenja Sapira daka ket uj sap otendonj Petrom pɨs wɨpɨnd. Ɨ re sisɨl rɨgap b'ɨgarkɨto wɨngɨr wa, ton kea ket tin uj ondrɨki yɨr wongo. Ɨ ton ket wiyo, ɨ weungito ti leom wusɨnd. ");
INSERT INTO gdr_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Sɨ komkesa sosi rɨga dɨde komkesa rɨga yepiya re utkundento onggɨt uj gatab yɨt, ton ma sobijog na moga aena wuwenonj. ");
INSERT INTO gdr_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ɨ ɨtmɨkitijog rɨgap jogjog kɨd kesa kɨma danda wɨko dɨde moga kɨma danda wɨko amnɨkento rɨga wa wɨngɨrɨnd. Ɨ komkesa gar ke utkunda rɨgap yɨpaina nony menamena kɨma yɨpa dɨr kesa metɨnd b'eomenento yɨnamet kara wɨngɨrɨnd ogenaya da “Solomonɨmna Met”. ");
INSERT INTO gdr_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ɨ gar ke utkunda kesa rɨgap ten moga na uwada eyenento, ɨ makwa yɨpand b'eomkenento ton kɨma. Ajɨ nangga ma jɨ ton maka ton kɨma yɨpand b'eomkenento, ton kea asourenento gar ke utkunda rɨga. ");
INSERT INTO gdr_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ɨ jogjog rɨga dɨde kongga bobo auka wuwenonj Yonggyamɨnd gar ke okatam, sɨ gar ke utkunda rɨga bobo re kea ket b'aikɨndento dɨde warabag auka wuwenonj. ");
INSERT INTO gdr_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ɨ re ket rɨgap yɨr angenento ɨtmɨkitijog rɨgaina jogjog kɨd kesa kɨma danda wɨko dɨde moga kɨma danda wɨko, ton kopa rɨga eyento ukoi nya wa, ɨ ket dar kumbɨnd dɨde tɨtɨnd oramka eyenento. Nokɨm da ra Petro menon okas ukoi nyawɨnd, ɨdenatemb ama rɨka tina wɨngat nɨnda rɨga ɨkangɨndena teyeniny. ");
INSERT INTO gdr_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ɨ dɨde rɨga bobo b'eomkurto nɨnda taun ke rɨnsim re Yerusalem taun wusɨnd wekeny, ɨ eyento kopa rɨga dɨde negɨr kɨlkɨl wɨngawɨnga ke b'ɨdgotnena okateni rɨga. Ɨ kea ket komkesa rɨgap b'ogɨl yokateno. ");
INSERT INTO gdr_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ajɨ yɨna mopyam sɨ rɨga dɨde komkesa ti ɨrmeka rɨga yepiya re Sadukai rɨga bobo wɨngɨrɨnd wekenonj, towaina garɨnd negɨr yɨr ke yɨr ongong mɨle ke yɨndangɨr aukɨto ɨtmɨkitijog rɨga wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Sɨ ton ket ten yɨmɨnd emdɨto negɨr omnam, ɨ ket sɨbɨbmet wa aramkɨto. ");
INSERT INTO gdr_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ajɨ yɨpa Yonggyamɨmna aneru ikonj onggɨt sɨwɨnyɨnd, ɨ ket sɨbɨbmet mora yɨpangendonj dɨde ket apenjinonj bau wa. Ɨ ton ket ten amninonj da, ");
INSERT INTO gdr_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Wuwe dɨde towɨnkindam dor de yɨnamet aba wa, ɨ ket rɨga wumɨr tamnenindam dor onggɨtyam komkesa bage yɨt rɨngkaim re rɨgap yɨrkokar yokatenyi.” ");
INSERT INTO gdr_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yɨt utkunda seg ke ton ket b'ɨgarkɨto yɨnamet aba wa ɨsparkand, ɨ ket rɨga auyaento. Re yɨna mopyam sɨ rɨga dɨde ti ɨrmeka rɨga wuwonj, ton ket Ju rɨga waina Sanedrin memba dɨde Israel wɨngɨrɨnd komkesa ukoi nyɨ rɨga ara emokto b'eomam de Sanedrin kot wa, dɨde ket rɨga etmɨkurto sɨbɨbmet wa ɨtmɨkitijog rɨga opopɨm. ");
INSERT INTO gdr_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ajɨ re opopam rɨgap opekto de sɨbɨbmet wa, ton makwa ɨtmɨkitijog rɨga adarkɨto sɨbɨbmet wɨngɨrɨnd. Sɨ ton ket ɨtekto dɨde wumɨr amnɨto. ");
INSERT INTO gdr_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Sɨ ton yɨt useka yiyeno da, “Re sɨn wuyɨn, sɨn yɨr yongu sɨbɨbmet mora re b'obogɨl ɨdoki na yɨbɨm, dɨde sɨbɨbmet yɨr ɨpka rɨga owɨnki na wekeny yɨpayɨpa morand. Ɨ re sɨn mora epangkindam, ajɨ sɨn makwa daka yena adarkindam onggɨt sɨbɨbmet wɨngɨr borand.” ");
INSERT INTO gdr_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ɨ re yɨnamet yɨr ɨpka geja rɨga waina mopyam dɨde yɨna mopyam sɨ rɨgap utkundo onggɨtyam yɨtkak, ton ket ma sobijog na nonysɨpsɨp aukɨto towa gatab. Sɨ endento da, “Ra odede gasa auka ikeny, sɨ nangga e tawɨk?” ");
INSERT INTO gdr_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Onggɨt wɨnɨnd yɨpa rɨga ikonj, ɨ ten wumɨr amninonj da, “Wɨi, yɨr de, rɨga yena re wɨn aramkomam sɨbɨbmet wa, ton opima de yɨnamet aba wa owɨnki wekeny dɨde rɨga auyaenanj.” ");
INSERT INTO gdr_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Onggɨtyam yɨt utkunda seg ke, yɨnamet timtim rɨga mopyam yikonj tina wɨko rɨga kɨma, dɨde teito ɨtmɨkitijog rɨga de b'ɨsagɨkapu pɨpmet wa. Ajɨ ton ma rɨrɨr na danda kɨma ingaenam menonɨm, mop nokɨp rɨga bobo na moga uwadto da, “Ke gɨmokɨp ke nedrɨkinem uj ondrɨkam.” ");
INSERT INTO gdr_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ɨ re ton teito, ton engauto onyitam onggɨt Ju rɨga waina Sanedrin kotɨnd. Ɨ ket yɨna mopyam sɨ rɨgat ten arkeninonj ");
INSERT INTO gdr_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","da, “Sɨn b'ingawa yɨt wa akautondam da, ‘Goro ouyaena teyenindam onggɨt Rɨgamna nyɨwɨnd.’ Ajɨ wɨn yɨpya kesa aukɨtondam. Sɨ wɨn kea waina ouyaena ke Yerusalem taun yɨndangɨr yomnɨkya, ɨ dɨde wɨn opima singi ainindam sɨn injawam onggɨt Rɨgamna uj gatab.” ");
INSERT INTO gdr_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ɨ Petro dɨde ɨtmɨkitijog rɨgap mɨra amnɨto da, “Men b'ogla naska Godɨnd yɨmta undoku, ɨ yɨmta kena ket gowukoi nyɨ rɨga yɨmta tundokindam. ");
INSERT INTO gdr_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Wɨnpiya Yesund yɨdrɨkonda wul kumbɨnd, ɨ yongandonda. Ajɨ mera b'uwar waina Godɨt Tin yutnyitonj uj ke. ");
INSERT INTO gdr_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ɨ Godɨt Tin ukoyamɨm yomnonj de pumb wa Tina rɨga wa Kingɨm dɨde Yɨrkokar Okawa Rɨgam, ɨ ket yoramitonj Tina yɨmjog yɨm tab ke juwai kɨma pɨpmet okatam. Sɨ ɨdenat ket onggɨtyam Tina danda ke Israel rɨgap negɨr mɨle ke gar tengendanj Godɨm pɨlwa, ɨ ket God towaina negɨr mɨle awɨr tamnɨkainy. ");
INSERT INTO gdr_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Sɨ sɨn re onggɨtyam gasa gatab yɨr ungatayam im. Ɨ God Yɨnayɨna Wɨngawɨnga towa akainonj yepim re Tin gar ke yokasi ɨ yɨmta yundoki, sɨ ɨtemb Yɨnayɨna Wɨngawɨnga daka kwa re onggɨtyam gatab yɨr ungatayam e.” ");
INSERT INTO gdr_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ɨ re b'ɨsagɨka rɨgap odede towaina yɨt utkundento, ton ma sobijog na gar soro aukɨto, dɨde singi yoramito ten uj ondrɨkam. ");
INSERT INTO gdr_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ajɨ onggɨtyam Ju rɨga waina Sanedrin kotɨnd yɨpa Parisai rɨga yɨbnonj nyɨ da Gamaliyel. Ton re gog yɨt ouyaena rɨga na, ɨ komkesa rɨgap tin yɨsnaeneno. Sɨ ton utnyitonj, ɨ b'ingawa yoramitonj ɨtmɨkitijog rɨga opendam bau wa sobijog wɨn kɨma. ");
INSERT INTO gdr_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ɨ re ton opekto, Gamaliyel ket amninonj da, “Israel rɨga! Wɨn wa wɨngɨrɨnd b'obogɨl nony menamena tamnɨkindam onggɨtyam mɨle gatab nangga mim re wɨn singi ainindam omnɨkam onggɨt rɨga wa pɨlɨnd. ");
INSERT INTO gdr_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mop nokɨp men wumɨr im nɨmog rɨga gatab. Sɨ naskand yɨpa rɨga yɨbnonj re nyɨ da Teuda. Ton tilenggyam yindenonj da, ‘Kon re yɨpa ukoi rɨga en.’ Ɨ ama rɨka powa andred (400) rɨgapiya ti tab wa aukɨto. Ɨ re rɨgap tin yongando, ti yɨmta undoka rɨga kea wetaweta aukɨto, ɨ ket ti rawɨr kwa rɨga aukɨto. ");
INSERT INTO gdr_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Onggɨt kak ke, yɨpa wɨnɨnd re gabmani b'ingawa yoramitonj rɨga nyɨ oramkam, yɨpa Galili rɨga Yudas onyitonj, ɨ b'anygɨnena nya ke rɨga wɨp amninonj tin yɨmta undokam. Onggɨtyam rɨga daka negɨr awonj, ɨ komkesa ti yɨmta undoka rɨga wetaweta aukɨto. ");
INSERT INTO gdr_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Sɨ onggɨt paemb kon nitinjɨn wa pɨlwa onggɨtyam yunɨm auki mɨle gatab. Sɨ wɨn erarinam towa pɨlnate, ɨ towaina singind mɨle ramnɨkinem! Sɨ ten apenjinam! Mop nokɨp rada onggɨtyam towaina ɨsamka o omnɨka b'atobarkonj re rɨga wa pɨlkae, sɨ ɨta awɨr tainy dem. ");
INSERT INTO gdr_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ajɨ rada Godɨm pɨlkae b'atobarkonj, wɨn ma rɨrɨr im ten awɨr omnam dɨde wɨn opima walenggyam b'atɨdarindam da wɨn re God kɨma geja rɨga im.” Sɨ komkesa b'ɨsagɨka rɨgap kea yɨmjato tina opureni yɨtkak. ");
INSERT INTO gdr_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ɨ ket ton ɨtmɨkitijog rɨga engaukɨto wɨngɨr wa. Ɨ ten ket ɨraska eyento, dɨde b'ingawa yɨt akauto da, “Goro yɨt tapureninam Yesu ma nyɨ kɨma!” Seg ten ket apekto. ");
INSERT INTO gdr_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ɨ re ɨtmɨkitijog rɨgap opekto onggɨt Ju rɨga waina Sanedrin kot ke, ton ukoi sam kɨma na menon yokato. Mop nokɨp ton kea ɨngar kɨma b'ɨdgotnena akatento Yesumna nyɨ map, ɨ ton nony menamena yomnɨko da, “God kea sɨn sam kɨma nokasiny onggɨtyam sowaina b'ɨdgotnena ke Tina pumb tungg warabag omnɨkam.” ");
INSERT INTO gdr_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ɨ ton ita bibɨr wɨram kesa ouyaena eyento dɨde pɨtapɨta yomneno God ma b'ogɨl yɨrkokar bage yɨt yɨnamet aband dɨde rɨgaina met nata da, “Yesu re Keriso e yena re God tɨrɨr yomnonj ɨtmɨkitam.” ");
INSERT INTO gdr_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ɨ onggɨt wɨnɨnd re Yesum yɨmta undoka rɨga jogjog b'aikɨndena wuwenonj, Grik yɨtam Ju rɨgap ugaga eyento Ibru yɨtam Ju rɨga. Mop nokɨp Ibru yɨtam Ju rɨgap maike b'obogɨl owou yingg amnɨkenento ita bibɨrɨm Grik yɨtam Ju rɨga waina mik kongga wa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Sɨ twelp (12) ɨtmɨkitijog rɨgap ara emokto komkesa Yesu ma b'auyaena rɨga, ɨ dɨde amnɨto da, “Sɨn wa pɨtapɨta tamnaindam sowaina bebɨg. Sɨ sɨn re ɨta kak wa yomnenyu Godɨmna yɨtkak gatab wɨko, nokɨp sɨn jogjog owou yingg iyena wɨko im amnɨkenindam. Sɨ odede mɨle re ma b'ogɨl e ainy sowanɨm omnɨkam Godɨm wɨpɨnd. ");
INSERT INTO gdr_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Sowa gar ke utkunda nany dɨde yɨngganwar! Wɨn b'obogɨl yɨr teyenindam ɨ tabagɨkindam seben (7) ɨmɨnjog b'ogɨl mɨleyam rɨga yepim re Yɨnayɨna Wɨngawɨnga ke dɨde b'ogɨl multekɨp ke yɨndangɨr auki wekeny. Ɨ sɨn towa mimemb danda takaindam onggɨtyam owou yingg iyena wɨko omnɨkam. ");
INSERT INTO gdr_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Sɨ sɨn ɨngkaim ket danda kɨma sowaina kupka nony menamena taramkindam yɨr opmitam dɨde God ma yɨt gatab wɨko omnɨkam.” ");
INSERT INTO gdr_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ɨ komkesa b'eoma rɨgap towaina yɨt sam kɨma yokateno, ɨ ton ket rɨga abagɨkto. Sɨ opimemb jɨ nyɨ Stepano yet re gar ke utkunda ke dɨde Yɨnayɨna Wɨngawɨnga ke yɨndangɨr auki na yɨbnonj, ɨ Pilip, ɨ Prokoro, ɨ Nikanor, ɨ Timona, ɨ Parmena, ɨ dɨde Antiyok ke rɨga Nikolao yet re naskand God ma obagendi kesa rɨga na yɨbnonj ajɨ yɨmta ke engendonj Ju rɨga waina omnɨka mɨle wa. ");
INSERT INTO gdr_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Seg ket rɨgap ten eito ɨtmɨkitijog rɨga wa wɨp wa ɨ awɨnkɨto. Ɨ ket ɨtmɨkitijog rɨgap yɨr opmitto dɨde yɨm aramkɨto towa pɨlɨnd towanɨm danda okawam. ");
INSERT INTO gdr_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Sɨ Godɨmna yɨt warabag auka yikenonj, sɨ Yesu ma b'auyaena rɨga ma sobijog na b'aikɨndento Yerusalem taunɨnd. Ɨ ukoi yɨna sɨ rɨgaina bobo daka kea utkundento God ma yɨrkokar bage yɨt, ɨ ket Yesund gar ke utkunda ke yokato dɨde Tin yɨmta yundoko. ");
INSERT INTO gdr_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ɨ Stepano re Godɨmna wurar dɨde danda kena yɨndangɨr auki yɨbnonj, sɨ ton amnɨkinonj ukoijog moga kɨma danda wɨko dɨde kɨd kesa kɨma danda wɨko rɨga wa wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ɨ Yerusalem taunɨnd yɨpa Ju rɨga waina yɨr opmitenapu met ebnawonj towa mana opi re B'ɨtrari Rɨga ɨ Kurene Rɨga ɨ dɨde Aleksandrea Rɨga. Ɨ re Stepano yɨt apureninonj, onggɨt Ju rɨga waina yɨr opmitenapu met ke nɨnda rɨga dɨde kwa Kilikiya dɨde Asiya ke nɨnda rɨga yɨpand soro kɨma owɨnkɨto Stepano kɨma yɨt b'ugwatenam. ");
INSERT INTO gdr_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ɨ towaina yɨt b'ugwatena wɨngɨrɨnd, God kea Stepanom b'ogɨl multekɨp dɨde Yɨnayɨna Wɨngawɨnga yokawonj. Sɨ Stepano re onggɨtyam danda kenaemb yɨt apureninonj, ngɨrpu opimemb ton kɨma yɨt b'ugwatena rɨgap makwa rɨrɨr na aukɨto tina yɨtkak gou wa omnenam. ");
INSERT INTO gdr_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Sɨ ton nɨnda rɨga wɨgawɨga engauto dɨde b'anygɨnena nya ke auyaento yɨtkak opurenam odede da, “Sɨn ke Mosem pɨlwa dɨde Godɨm pɨlwa b'ɨsadrena yɨtkak utkundenonda Stepanomna opurena wɨngɨrɨnd.” ");
INSERT INTO gdr_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ɨ ton ket onggɨtyam b'anygɨnena yɨtkak opurena ke Ju rɨga ɨ Ju rɨga waina elda rɨga ɨ dɨde Ju rɨga waina gog ouyaena rɨga ɨl angkɨto Stepanom pɨlwa soro omnɨkam. Sɨ komkesa rɨgap kea soro aukɨto, ɨ ket wuwonj Stepanom pɨlwa, ɨ tin yɨmɨnd yusunato dɨde ket yiyo de Ju rɨga waina Sanedrin kot wa. ");
INSERT INTO gdr_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ɨ ton ket nɨnda b'anygɨnena yɨr ungata rɨga teito onggɨt Ju rɨga waina Sanedrin kot wa. Sɨ ton kea b'anygɨnena yɨr ungata yɨt apurento odede da, “Onggɨt rɨgat ita wɨnɨnd negɨr yɨt apureneninonj onggɨt yɨnamet gatab dɨde gog yɨt gatab. ");
INSERT INTO gdr_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ɨ sɨn kea tin yutkundenonda odede opurenand da, ‘Onggɨt Najaret tunggam Yesut ɨta itrorɨk dem onggɨtyam yɨnamet, dɨde kwa opima tengenjiny dem gog rɨna re Mose mera nogoninonj.’” ");
INSERT INTO gdr_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ɨ komkesa rɨga yepiya re omnɨki wekenonj onggɨt b'ɨsagɨkapu pɨpmetɨnd, yɨr ɨsokto ti pɨlwa. Ɨ ton tina wɨp yɨr yɨpko re ɨja na ɨt re aneru ma wɨp re dɨde. ");
INSERT INTO gdr_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Seg re ket, yɨna mopyam sɨ rɨga Stepanond yerkitonj da, “Mɨnda onggɨtyam yɨt re ɨmɨnjog im?” ");
INSERT INTO gdr_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sɨ Stepano mɨra amninonj da, “Kor nany dɨde yɨngganwar, ɨ kor b'uwar! Wɨn nutkunda! Mera b'u Abraam naskand yɨbnonj ade Mesopotamiya wa. Ɨ re ton maka menon yokatonj Aran wa, b'ogɨl ɨnyomarena God pɨtapɨta awonj ti pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ɨ Ton ket Abraamɨnd yomnonj da, ‘Man topenjɨt moina gou ke dɨde moina gu rɨga wa pɨlke, ɨ menon okasɨt onggɨt gou wa rɨna ra kon motouyaen.’ ");
INSERT INTO gdr_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ɨ ton ket Kaldaya gou yɨraronj, ɨ yikonj de Aran wa wɨmenam. Re ton Aran gowɨnd yɨbnenenonj, ti b'u uj awonj. Sɨ ɨngkenaemb ket God Abraamɨnd yiyonj wɨmenam de onggɨt Kanaan gou wa rokasim re yu wɨn wekenyɨt. ");
INSERT INTO gdr_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ajɨ God makwa ngai ti yokawonj sobijogjog gou kɨpol ti owabɨndena iyoyɨm. Ɨ ti re maka yɨpa tina oraki b'ɨga yɨbnawonj, ajɨ God tɨrɨr yɨt tin yomnonj da, ‘Kon ɨta motkaen dem onggɨtyam gou rokate re man mɨbnyɨt man dɨde moina kus ke b'ɨgawar kɨma owabɨndenam.’ ");
INSERT INTO gdr_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ɨ God kwa tin yomnonj odede da, ‘Moina kus ke b'ɨgawar opima b'enga rɨgaina gowɨnd obayam taukanj dem. Ɨ onggɨt gou yonggyamwar rɨgap towaina wɨko rɨga mim tamnenanj dem ɨ ket towa pɨlɨnd nenegɨrjog mɨle tamnɨkenenauranj dem powa andred (400) kemag kɨma. ");
INSERT INTO gdr_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ɨ ket Kon ɨta negɨr ma b'ɨsagɨka omnɨken dem onggɨt kantrim pɨlɨnd yet ra wen wɨko rɨgam tamneniny dem.’ Ɨ dɨde kwa God yomnonj da, ‘Ɨ onggɨt kak ke ket opima moina b'ɨgawar topendanj dem onggɨt kantri ke, ɨ tɨtekanj dem dɨkɨnd onggɨt gowɨnd, ɨ dɨde ket ton opima Kor pɨlwa kumsos b'amka tuweny dem.’ ");
INSERT INTO gdr_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ɨ God Abraamɨm outɨnti tɨrɨr omnijog yɨt yokawonj Tina obagendi tɨrɨr omni mal wugɨm ɨpka mɨle omnɨkam. Sɨ re ton b'ɨga yorakonj Isak dɨde re Isak eitɨm (8) bibɨr yokatonj, ton ket Isakɨm pɨlɨnd God ma obagendi tɨrɨr omni mal wugɨm ɨpka mɨle yomnɨkonj. Ɨ re Isak b'ɨga yorakonj Yakob, todaka ti b'ɨga Yakobɨm pɨlɨnd kea onggɨtyam mɨle yomnɨkonj. Ɨ kwa re Yakob b'ɨga arakinonj meraina twelp (12) b'uwar, toda kwa kea towa pɨlɨnd onggɨtyam mɨle yomnɨkonj. ");
INSERT INTO gdr_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ɨ meraina b'uwarɨp towa yɨnggan Yosepɨnd nonyɨk yɨponeneno, ngɨrpu tin wɨko rɨgam yosogo yɨpa Ejipt rɨgam pɨlwa. Ajɨ re ton ket Yosepɨnd yiyonj de Ejipt wa, God kea ton kɨma b'inkenenonj. ");
INSERT INTO gdr_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Sɨ re Yosep jogjog b'engabenga bebɨg kɨma b'ɨdgotnena akateneninonj, God kea tin yopendenenonj onggɨtyam komkesa b'ɨdgotnena ke. Ɨ kwa Ton ti yokawonj b'ogɨl multekɨp, sɨ ɨngkenaemb ton b'ogɨl b'ugowa yɨt yogoninonj Ejipt kantri mopyam king Paraom. Sɨ onggɨt penaemb ɨtemb king Parao tin ukoi singi yiyenenonj, dɨde ton ket gabmani mopyam danda yokawonj wɨp iyoyɨm Ejipt kantri dɨde komkesa tina wɨko rɨga tina met wɨngɨrɨnd. ");
INSERT INTO gdr_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ɨ onggɨt wɨnɨnd kea ukoi sou pɨta awonj komkesa Ejipt dɨde Kanaan gou wɨngɨrɨnd, sɨ ukoi bebɨg kɨma b'ɨdgotnena na aukonj. Sɨ onggɨt penaemb mera b'uwarɨp daka ma rɨrɨr na owou odarkam aukɨto. ");
INSERT INTO gdr_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ɨ re Yakob utkundonj da owou opima de Ejipt wa, ton ket yiyata kɨma mera b'uwar etmɨkurinonj Ejipt wa owou okatam. ");
INSERT INTO gdr_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ɨ re ton nɨmogɨm menon yokato Ejipt wa, Yosep wumɨr amninonj ti nanywar da, ‘Kon re wa yɨnggan en.’ Ɨ omandemb ket Ejipt kantri mopyam king Parao daka b'obogɨl wumɨr yokatonj Yosepɨmna gu rɨgawar gatab. ");
INSERT INTO gdr_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ɨ ket Yosep ti nanywar etmɨkurinonj ti b'uɨm pɨlwa, ɨ engaukinonj ti b'u Yakob dɨde komkesa tina sebenti paib (75) gu rɨga menonɨm de Ejipt wa. ");
INSERT INTO gdr_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Sɨ ket Yakob Ejipt wa yikonj komkesa ti konggawar dɨde b'ɨgawar kɨma. Ɨ ton dɨde mera b'uwar ademb Ejipt wa uj aukɨto. ");
INSERT INTO gdr_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ɨ ton ket towaina ujgɨm eito Sekem wa Kanaan eriyand rɨna re Abraam naskand yɨpa gou kɨpol wulkɨp ke yokatonj Amorɨmna b'ɨgawar wa pɨlke, ɨ ket ademb jɨ aramkenento onggɨt yɨpaina gopmet wa rɨna re Abraam yoskonj. ");
INSERT INTO gdr_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Sɨ re ket God ma tɨrɨr omni powa andred (400) kemag wus wa auka ikonj rɨna re God Abraamɨnd tɨrɨr yɨt yokawonj ɨtendam Kanaan wa, meraina Israel rɨga kea b'usmurento dɨde ukoi warabag auka wuwenonj Ejiptɨnd, ");
INSERT INTO gdr_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ngɨrpu yɨpa b'enga rɨgat king pɨpmet yokatonj Ejiptɨnd yet re ma wumɨr na yɨbnonj Yosepɨm gatab. ");
INSERT INTO gdr_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ton b'anygɨnena nya ke meraina gu rɨga amneninonj. Ɨ ton ket mera b'uwar wa pɨlɨnd negɨrjog b'ingawa yɨt yoramitonj towaina sisɨl ukuki b'ɨga oramitenam de bau wa, nokɨm da ɨdenat onggɨt b'ɨgap maka yilo okasi dem. ");
INSERT INTO gdr_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ɨ onggɨt wɨnɨnd Mose kea ukendonj. Ton re Godɨm wɨpɨnd otomanti b'ɨga na, sɨ ti mog ket tin yɨr ɨpka yiyenonj nowa mobi kɨma ti b'uɨm metɨnd. ");
INSERT INTO gdr_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nowa mobi seg ke, re ti b'u ake ti mog yɨraronda sɨta borand Nael kɨlɨmɨnd, Ejipt kantri mopyam king Paraomna ngɨmngai b'ɨgat tin yokatonj onggɨt kɨlɨm ke. Ɨ ton ket ti b'ɨgajogɨm yongenonj. ");
INSERT INTO gdr_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ɨ Mose b'auyaenenonj Ejipt kantri mopyam king Paraomna metɨnd, sɨ ton kea wumɨrjog aukonj komkesa Ejipt rɨgaina omnɨka gasa. Sɨ ɨngkenaemb komkesa tina opurena dɨde tina omnɨka re kea ukoijog danda kɨma na aukɨto. ");
INSERT INTO gdr_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ɨ re ton poti (40) kemag awonj, ton ket ti garɨnd nony menamena yomnɨkonj odaram ti nany dɨde yɨngganwar, Israel rɨga. ");
INSERT INTO gdr_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Sɨ ton ket yikonj towa pɨlwa. Ɨ re ton yɨr yongonj yɨpa Ejipt rɨga nenegɨr kana ingaenand yɨpa Israel rɨgand, ton kea onggɨt Ejipt rɨgaina negɨr mɨle gatab yɨsagɨkonj, dɨde ket mɨra omnam yongandonj uj tama na. ");
INSERT INTO gdr_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ɨ Mose ɨja na nony menamena yomnɨkonj odede da, ‘Koina Israel nany dɨde yɨngganwar b'ogla b'obogɨl nony raukinem da God ɨta ken nitngau ten opendam onggɨt b'ɨdgotnena ke’. Ajɨ ton maka nony aukɨto. ");
INSERT INTO gdr_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ɨ yɨpa bibɨr kak ke, re ton yɨr angonj nɨmog Israel rɨga b'ipowand, ton pop ɨl ongka eyenonj rɨgarɨga awowɨm. Ɨ ket ton towa ganggand ngɨmbla omnam amnonj da, ‘Wɨi, wɨn osiemb b'ipoya re nanyɨnggan i. Nangga pai wɨn walenggyam walenggyam nenegɨr kana b'ipoya?’ ");
INSERT INTO gdr_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ajɨ onggɨt rɨgat yet re ti rɨgand nenegɨr kana yomnenonj, ton Mosend yotoukitonj yɨu wa, ɨ ket yomnonj da, ‘Yet mor danda mokawonj sowanɨm wɨp iyoi rɨgam dɨde b'ɨsagɨka rɨgam? ");
INSERT INTO gdr_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ma man singi et ken uj tama na ongandam odede rɨja na re man yɨpa Ejipt rɨga sɨm yonganjmɨt?’ ");
INSERT INTO gdr_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Re Mose onggɨtyam tina yɨt utkundonj, ton moga na awonj, ɨ ket b'ɨkenonj Ejipt ke. Ɨ ton ket yikonj Midiyan gou wa, ɨ obayam awonj onggɨt gowɨnd. Sɨ ademb de ton kongga wokatonj, ɨ ton ket nɨmog b'ɨga arakonj. ");
INSERT INTO gdr_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ɨ kwa ton ademb de nɨnda poti (40) kemag b'ɨskokinonj. Seg ket yɨpa wɨnɨnd re ton yikonj wul kesa tungg wa de Sinai dor wa, ton kea yɨr yongonj yɨpa b'uwaep wul dɨmɨl b'ɨrmatenand. Ɨ kwa Mose yɨr yongonj yɨpa aneru onggɨt b'uwaepɨnd. ");
INSERT INTO gdr_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ɨ re Mose yɨr yɨpkonj ɨtemb gasa, ton kɨd kesa awonj. Re ton b'obogɨl yɨr ongongɨm yikonj de onggɨt b'uwaep wus wa, ton ket Yonggyamɨnd nonykok yutkundonj da, ");
INSERT INTO gdr_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Kon re mor b'uwar waina God en, Abraamɨmna ɨ Isakɨmna ɨ dɨde Yakobɨmna God en.’ Re Mose yɨt utkundonj, ton ukoi moga kɨma kaktɨtɨ aukonj. Sɨ onggɨt penaemb ton maka ket b'usaya yɨr aenonj. ");
INSERT INTO gdr_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ɨ Yonggyam kwa tin yomnonj da, ‘Man mor pɨsɨnd yongɨnkak atogɨkine, mop nokɨp ɨtemb pɨpmet rokate re man onyiti mɨbnyɨt re yɨna gou e. ");
INSERT INTO gdr_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kon kea yɨr ongong eyeninyɨmɨn Koina Israel rɨgaina bebɨg kɨma b'ɨdgotnena de Ejiptɨnd. Ɨ Kon ke utkundenenyɨmɨn towaina b'aena. Sɨ onggɨt paemb yu Kon netken dɨkɨnd ten ɨtrekam towaina bebɨg kɨma b'ɨdgotnenam pɨlke. Sɨ metkɨm, Kon ɨta men mɨtɨtmɨkisɨn de Ejipt wa.’ ");
INSERT INTO gdr_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Sɨ Mose ɨntemb jɨ rɨga yena re naskand Israel rɨgap yɨsayo odede yɨt kɨma da, ‘Yet mor danda mokawonj wɨp iyoi rɨgam dɨde b'ɨsagɨka rɨgam?’ Ajɨ Godɨt ɨtemb rɨga Mosem danda yokawonj Israel rɨga wa wɨp iyoi rɨgam dɨde towaina b'ɨdgotnenam pɨlke ɨtreka rɨgam. Ɨ God ket onggɨt anerumna yɨmɨnd tin yoramitonj yet re pɨtapɨta awonj b'uwaepɨnd, dɨde ket yɨtmɨkitonj towa pɨlwa. ");
INSERT INTO gdr_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ɨ onggɨt Mosetemb moga kɨma danda wɨko dɨde kɨd kesa kɨma danda wɨko amnɨkinonj Ejipt kantri wɨngɨrɨnd ɨ Kuskus Sɨpa ɨjendand ɨ dɨde poti (40) kemag kɨma wul kesa tungg nata menamenand. Sɨ ton ket Israel rɨga apenjinonj Ejipt kantri ke. ");
INSERT INTO gdr_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ɨ ɨntaemb jɨ Mose yet re Israel rɨga wumɨr amninonj da, ‘God ɨta wa tetmɨkitau dem yɨpa bageyam wainajog gu rɨga wa pɨlke odede ɨt re kon re dɨde.’ ");
INSERT INTO gdr_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ɨ ɨntaemb jɨ yɨpaina Mose yet re wul kesa tunggɨnd yɨpand yɨbnenenonj Israel rɨga bobo kɨma. Ɨ onggɨt wɨnɨnd ton yɨbnenenonj re onggɨt aneru kɨma na yet re ton kɨma yɨtnono aenonj Sinai dorɨnd dɨde mera b'uwar kɨma na. Ɨ ton ɨntemb jɨ Mose yet re yɨrkokarɨm yɨtkak akasinonj Godɨm pɨlke mera okawam. ");
INSERT INTO gdr_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ajɨ mera b'uwarɨp ma singi na aukɨto tin yɨmta undokam. Ɨ ton ket tin yɨsaeneno dɨde nony ɨtendento ɨtendam de Ejipt wa. ");
INSERT INTO gdr_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Re Mose Oreb dor ɨjonj God ma yɨt okatam poti (40) bibɨr kɨma, Israel rɨgap Aronɨnd yomno da, ‘Man b'ogla meranɨm tamnɨkinyɨt nɨnda god yepim ra men wɨp nitiyenan